#!/bin/bash
gmt begin haida1.26_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance haida1.26'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.900    17.611
     1.000    19.011
     1.100    20.411
     1.200    21.810
     1.300    23.210
     1.400    24.610
     1.500    26.009
     1.600    27.409
     1.700    28.809
     1.800    30.208
     1.900    31.608
     2.000    33.007
     2.100    34.407
     2.200    35.807
     2.300    37.206
     2.400    38.606
     2.500    40.006
     2.600    41.405
     2.700    42.805
     2.800    44.205
     2.900    45.604
     3.000    47.004
     3.100    48.404
     3.200    49.803
     3.300    51.203
     3.400    52.603
     3.500    54.002
     3.600    55.402
     3.700    56.801
     3.800    58.201
     3.900    59.600
     4.000    60.999
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    53.402 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.553
     0.200     4.019
     0.300     5.675
     0.400     7.395
     0.500     9.142
     0.600    10.904
     0.700    12.674
     0.800    14.450
     0.900    16.229
     1.000    18.011
     1.100    19.715
     1.200    21.322
     1.300    22.928
     1.400    24.534
     1.500    26.141
     1.600    27.747
     1.700    29.354
     1.800    30.960
     1.900    32.566
     2.000    34.173
     2.100    35.779
     2.200    37.386
     2.300    38.992
     2.400    40.598
     2.500    42.205
     2.600    43.811
     2.700    45.417
     2.800    47.023
     2.900    48.629
     3.000    50.235
     3.100    51.841
     3.200    53.447
     3.300    55.053
     3.400    56.659
     3.500    58.265
     3.600    59.871
     3.700    61.477
     3.800    63.083
     3.900    64.689
     4.000    66.294
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    58.871 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    43.484
     2.600    45.472
     2.700    47.461
     2.800    49.449
     2.900    51.438
     3.000    53.426
     3.100    55.415
     3.200    57.403
     3.300    59.392
     3.400    61.380
     3.500    63.369
     3.600    65.357
     3.700    67.346
     3.800    69.335
     3.900    71.323
     4.000    73.312
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    67.357 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    28.518
     0.900    30.949
     1.000    33.379
     1.100    35.809
     1.200    38.239
     1.300    40.669
     1.400    43.099
     1.500    45.529
     1.600    47.960
     1.700    50.390
     1.800    52.820
     1.900    55.250
     2.000    57.680
     2.100    60.110
     2.200    62.541
     2.300    64.971
     2.400    67.401
     2.500    69.831
     2.600    72.261
     2.700    74.691
     2.800    77.122
     2.900    79.552
     3.000    81.982
     3.100    84.412
     3.200    86.842
     3.300    89.272
     3.400    91.703
     3.500    94.133
     3.600    96.563
     3.700    98.992
     3.800   101.421
     3.900   103.851
     4.000   106.280
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    94.563 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.397
     0.200     6.921
     0.300     9.773
     0.400    12.735
     0.500    15.745
     0.600    18.779
     0.700    21.828
     0.800    24.886
     0.900    27.950
     1.000    31.018
     1.100    34.090
     1.200    37.164
     1.300    40.239
     1.400    43.161
     1.500    46.040
     1.600    48.919
     1.700    51.798
     1.800    54.677
     1.900    57.556
     2.000    60.435
     2.100    63.314
     2.200    66.193
     2.300    69.072
     2.400    71.951
     2.500    74.830
     2.600    77.708
     2.700    80.587
     2.800    83.466
     2.900    86.344
     3.000    89.223
     3.100    92.102
     3.200    94.980
     3.300    97.858
     3.400   100.736
     3.500   103.614
     3.600   106.492
     3.700   109.371
     3.800   112.250
     3.900   115.127
     4.000   118.005
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   105.492 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    75.971
     2.600    79.126
     2.700    82.281
     2.800    85.436
     2.900    88.590
     3.000    91.745
     3.100    94.900
     3.200    98.055
     3.300   101.210
     3.400   104.365
     3.500   107.519
     3.600   110.674
     3.700   113.829
     3.800   116.984
     3.900   120.139
     4.000   123.294
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   112.674 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    20.046
     1.100    21.445
     1.200    22.845
     1.300    24.245
     1.400    25.644
     1.500    27.044
     1.600    28.443
     1.700    29.843
     1.800    31.243
     1.900    32.642
     2.000    34.042
     2.100    35.442
     2.200    36.841
     2.300    38.241
     2.400    39.641
     2.500    41.040
     2.600    42.440
     2.700    43.840
     2.800    45.239
     2.900    46.639
     3.000    48.038
     3.100    49.438
     3.200    50.838
     3.300    52.237
     3.400    53.637
     3.500    55.037
     3.600    56.436
     3.700    57.836
     3.800    59.236
     3.900    60.635
     4.000    62.035
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.801
     0.200     3.590
     0.300     5.382
     0.400     7.175
     0.500     8.968
     0.600    10.761
     0.700    12.554
     0.800    14.347
     0.900    16.141
     1.000    17.934
     1.100    19.727
     1.200    21.520
     1.300    23.313
     1.400    25.106
     1.500    26.875
     1.600    28.481
     1.700    30.088
     1.800    31.694
     1.900    33.300
     2.000    34.907
     2.100    36.513
     2.200    38.120
     2.300    39.726
     2.400    41.332
     2.500    42.938
     2.600    44.545
     2.700    46.151
     2.800    47.757
     2.900    49.363
     3.000    50.970
     3.100    52.576
     3.200    54.182
     3.300    55.788
     3.400    57.394
     3.500    59.000
     3.600    60.606
     3.700    62.212
     3.800    63.818
     3.900    65.424
     4.000    67.030
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    32.708
     1.000    35.138
     1.100    37.568
     1.200    39.998
     1.300    42.428
     1.400    44.858
     1.500    47.288
     1.600    49.719
     1.700    52.149
     1.800    54.579
     1.900    57.009
     2.000    59.439
     2.100    61.869
     2.200    64.299
     2.300    66.730
     2.400    69.160
     2.500    71.590
     2.600    74.020
     2.700    76.450
     2.800    78.880
     2.900    81.310
     3.000    83.741
     3.100    86.171
     3.200    88.601
     3.300    91.031
     3.400    93.461
     3.500    95.891
     3.600    98.321
     3.700   100.751
     3.800   103.181
     3.900   105.611
     4.000   108.041
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.101
     0.200     6.183
     0.300     9.270
     0.400    12.357
     0.500    15.445
     0.600    18.533
     0.700    21.621
     0.800    24.709
     0.900    27.798
     1.000    32.672
     1.100    33.974
     1.200    37.062
     1.300    40.150
     1.400    43.238
     1.500    46.327
     1.600    49.415
     1.700    52.503
     1.800    55.591
     1.900    58.583
     2.000    61.462
     2.100    64.341
     2.200    67.220
     2.300    70.099
     2.400    72.978
     2.500    75.857
     2.600    78.736
     2.700    81.615
     2.800    84.494
     2.900    87.372
     3.000    90.251
     3.100    93.129
     3.200    96.008
     3.300    98.886
     3.400   101.765
     3.500   104.643
     3.600   107.522
     3.700   110.400
     3.800   113.278
     3.900   116.157
     4.000   119.035
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    15.335
     0.900    16.735
     1.000    18.134
     1.100    19.534
     1.200    20.934
     1.300    22.333
     1.400    23.733
     1.500    25.133
     1.600    26.532
     1.700    27.932
     1.800    29.332
     1.900    30.731
     2.000    32.131
     2.100    33.530
     2.200    34.930
     2.300    36.330
     2.400    37.729
     2.500    39.129
     2.600    40.529
     2.700    41.928
     2.800    43.328
     2.900    44.728
     3.000    46.127
     3.100    47.527
     3.200    48.927
     3.300    50.326
     3.400    51.726
     3.500    53.126
     3.600    54.525
     3.700    55.925
     3.800    57.324
     3.900    58.723
     4.000    60.122
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     3.689
     0.200     4.820
     0.300     6.266
     0.400     7.851
     0.500     9.457
     0.600    11.064
     0.700    12.670
     0.800    14.277
     0.900    15.883
     1.000    17.489
     1.100    19.096
     1.200    20.702
     1.300    22.309
     1.400    23.915
     1.500    25.521
     1.600    27.128
     1.700    28.734
     1.800    30.341
     1.900    31.947
     2.000    33.553
     2.100    35.160
     2.200    36.766
     2.300    38.372
     2.400    39.978
     2.500    41.585
     2.600    43.191
     2.700    44.797
     2.800    46.403
     2.900    48.009
     3.000    49.615
     3.100    51.221
     3.200    52.827
     3.300    54.433
     3.400    56.039
     3.500    57.645
     3.600    59.251
     3.700    60.856
     3.800    62.462
     3.900    64.068
     4.000    65.674
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    24.598
     0.800    27.028
     0.900    29.458
     1.000    31.889
     1.100    34.319
     1.200    36.749
     1.300    39.179
     1.400    41.609
     1.500    44.039
     1.600    46.469
     1.700    48.900
     1.800    51.330
     1.900    53.760
     2.000    56.190
     2.100    58.620
     2.200    61.050
     2.300    63.481
     2.400    65.911
     2.500    68.341
     2.600    70.771
     2.700    73.201
     2.800    75.631
     2.900    78.062
     3.000    80.492
     3.100    82.922
     3.200    85.352
     3.300    87.782
     3.400    90.212
     3.500    92.642
     3.600    95.072
     3.700    97.501
     3.800    99.931
     3.900   102.360
     4.000   104.789
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     6.354
     0.200     8.301
     0.300    10.791
     0.400    13.529
     0.500    16.386
     0.600    19.265
     0.700    22.144
     0.800    25.023
     0.900    27.902
     1.000    30.781
     1.100    33.660
     1.200    36.539
     1.300    39.418
     1.400    42.297
     1.500    45.176
     1.600    48.055
     1.700    50.934
     1.800    53.813
     1.900    56.692
     2.000    59.571
     2.100    62.450
     2.200    65.329
     2.300    68.208
     2.400    71.087
     2.500    73.965
     2.600    76.844
     2.700    79.722
     2.800    82.601
     2.900    85.480
     3.000    88.358
     3.100    91.236
     3.200    94.115
     3.300    96.993
     3.400    99.871
     3.500   102.750
     3.600   105.628
     3.700   108.505
     3.800   111.383
     3.900   114.261
     4.000   117.139
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.929    31.703     0.200
     2.572    40.398     0.200
     3.242    52.297     0.200
     3.929    59.500     0.200
     3.964    59.703     0.200
     4.082    63.102     0.200
     4.176    62.797     0.200
     4.644    71.102     0.200
     4.769    72.227     0.200
     4.776    72.297     0.200
     5.243    79.000     0.200
     5.322    79.938     0.200
     5.694    85.242     0.200
     5.984    89.297     0.200
     7.195   106.102     0.200
     7.415   112.258     0.200
     7.439   113.562     0.200
     7.736   116.398     0.200
     7.795   118.727     0.200
     7.949   120.398     0.200
     8.081   123.117     0.200
     8.135   121.930     0.200
     8.204   123.203     0.200
     8.213   123.062     0.200
     8.287   125.406     0.200
     8.325   125.641     0.200
     8.566   128.297     0.200
     8.600   127.898     0.200
     8.811   132.000     0.200
     9.034   133.500     0.200
     9.364   137.000     0.200
    10.236   150.000     0.200
    10.735   153.203     0.200
    10.784   160.000     0.200
    11.037   159.000     0.200
    11.388   166.898     0.200
    12.231   176.203     0.200
    12.941   184.703     0.200
    13.830   197.000     0.200
    13.830   197.500     0.200
    13.967   203.297     0.200
    14.027   202.500     0.200
    14.547   209.500     0.200
    14.543   206.398     0.200
    14.571   209.203     0.200
    14.869   210.000     0.200
    15.030   214.703     0.200
    15.373   218.797     0.200
    15.704   220.500     0.200
    15.793   224.297     0.200
    17.119   237.500     0.200
    18.523   259.500     0.200
    18.530   259.500     0.200
    18.692   262.297     0.200
    18.693   261.500     0.200
    20.297   279.000     0.200
    20.436   281.000     0.200
    20.747   282.898     0.200
    20.828   284.602     0.200
     1.940    31.578     0.200
     2.572    40.484     0.200
     3.227    52.484     0.200
     3.924    60.578     0.200
     4.164    61.781     0.200
     4.630    70.984     0.200
     4.773    72.430     0.200
     4.777    71.781     0.200
     5.246    77.781     0.200
     5.696    85.414     0.200
     5.968    89.578     0.200
     7.185   105.883     0.200
     8.597   128.781     0.200
    13.824   196.781     0.200
    15.702   222.781     0.200
    16.442   231.781     0.200
    17.106   238.781     0.200
    18.527   261.281     0.200
     1.271    22.805     0.200
     1.898    34.008     0.200
     2.548    39.711     0.200
     3.270    51.305     0.200
     4.113    63.805     0.200
     4.176    63.109     0.200
     4.673    72.008     0.200
     6.007    89.406     0.200
     2.567    39.918     0.200
     3.242    51.117     0.200
     3.934    59.418     0.200
     3.959    59.316     0.200
     4.084    62.816     0.200
     4.171    62.316     0.200
     4.644    71.117     0.200
     4.764    72.105     0.200
     4.771    72.016     0.200
     5.239    78.816     0.200
     5.689    84.977     0.200
     5.982    89.316     0.200
     7.198   106.016     0.200
     8.594   133.316     0.200
     9.359   139.816     0.200
    12.936   186.316     0.200
    14.545   206.316     0.200
     1.343    23.336     0.200
     2.080    34.039     0.200
     2.982    45.336     0.200
     3.320    52.141     0.200
     3.647    54.438     0.200
     4.069    62.734     0.200
     4.312    64.438     0.200
     4.636    68.938     0.200
     4.692    71.836     0.200
     5.093    76.586     0.200
     6.054    89.391     0.200
     6.190    92.039     0.200
     7.043   103.438     0.200
     7.524   111.438     0.200
    10.849   157.539     0.200
    11.067   162.438     0.200
    11.207   160.938     0.200
    11.873   168.938     0.200
    13.419   190.438     0.200
    14.478   205.438     0.200
    15.338   215.438     0.200
    16.152   227.438     0.200
    17.568   242.438     0.200
    20.523   279.539     0.200
     3.509    53.777     0.200
     3.748    56.066     0.200
     3.970    60.336     0.200
     4.309    66.074     0.200
     4.473    66.176     0.200
     6.299    93.977     0.200
     1.265    22.160     0.200
     2.651    41.633     0.200
     2.651    40.461     0.200
     3.007    49.160     0.200
     3.284    53.762     0.200
     3.883    58.352     0.200
     4.023    61.762     0.200
     4.104    63.262     0.200
     4.694    71.434     0.200
     4.821    74.441     0.200
     5.825    84.762     0.200
     6.057    91.262     0.200
     7.080   104.211     0.200
     7.080   102.961     0.200
     7.714   113.312     0.200
    13.428   191.363     0.200
    18.263   252.062     0.200
    20.261   278.832     0.200
    20.535   282.184     0.200
     2.948    46.148     0.200
     3.715    55.320     0.200
     4.154    63.977     0.200
     4.262    65.344     0.200
     4.666    69.977     0.200
     4.778    72.875     0.200
     4.792    73.008     0.200
     6.170    91.477     0.200
     6.269    94.273     0.200
     7.022   102.547     0.200
     7.022   102.750     0.200
    12.342   176.773     0.200
    12.719   177.977     0.200
    20.531   280.125     0.200
     1.184    20.598     0.200
     1.492    25.678     0.200
     2.657    40.402     0.200
     3.409    51.197     0.200
     3.712    53.896     0.200
     3.909    57.828     0.200
     4.030    58.498     0.200
     4.483    65.727     0.200
     4.573    67.547     0.200
     4.603    67.988     0.200
     4.993    72.928     0.200
     5.179    76.658     0.200
     5.768    87.047     0.200
     5.864    85.928     0.200
     5.920    86.697     0.200
     6.166    91.918     0.200
     6.220    93.477     0.200
     6.763    99.078     0.200
     6.854   101.518     0.200
     8.016   115.857     0.200
     8.918   130.098     0.200
    10.298   148.287     0.200
    13.502   189.373     0.200
    13.539   188.877     0.200
    13.539   189.408     0.200
    15.088   213.707     0.200
     1.527    26.139     0.200
     2.881    44.318     0.200
     3.614    56.249     0.200
     4.091    60.629     0.200
     4.280    63.438     0.200
     4.445    68.179     0.200
     4.445    68.719     0.200
     4.624    70.339     0.200
     4.625    69.559     0.200
     5.823    85.749     0.200
     6.801   100.219     0.200
    12.267   171.063     0.200
    18.462   257.169     0.200
     2.467    37.672     0.200
     3.530    51.914     0.200
     3.758    55.145     0.200
     4.058    60.602     0.200
     4.097    60.895     0.200
     4.533    67.875     0.200
     5.092    77.055     0.200
     6.082    91.074     0.200
     6.640    96.953     0.200
     7.274   106.625     0.200
     7.458   109.395     0.200
     0.926    16.695     0.200
     1.246    21.453     0.200
     2.905    43.914     0.200
     3.998    58.656     0.200
     4.224    62.992     0.200
     4.527    67.836     0.200
     4.623    68.727     0.200
     4.790    73.945     0.200
     5.047    74.727     0.200
     2.585    40.168     0.200
     3.769    56.176     0.200
     3.964    58.746     0.200
     3.936    59.785     0.200
     4.231    63.824     0.200
     4.231    63.723     0.200
     4.307    64.113     0.200
     4.303    64.996     0.200
     4.732    69.914     0.200
     4.757    71.234     0.200
     4.704    71.895     0.200
     4.704    71.746     0.200
     4.764    71.246     0.200
     5.696    84.426     0.200
     5.811    86.195     0.200
     6.401    96.176     0.200
     6.278    92.633     0.200
     6.688    99.363     0.200
     7.196   104.816     0.200
     7.116   104.816     0.200
     7.759   113.016     0.200
     8.038   117.223     0.200
     8.183   119.086     0.200
     8.539   124.344     0.200
    10.577   152.484     0.200
    11.063   159.094     0.200
    12.397   174.039     0.200
    12.434   174.805     0.200
    13.479   192.746     0.200
    14.382   203.656     0.200
    14.580   206.902     0.200
    14.580   207.914     0.200
    14.580   205.203     0.200
    15.174   215.906     0.200
    15.791   223.984     0.200
    16.457   230.625     0.200
    17.564   244.664     0.200
    19.879   274.434     0.200
    20.196   276.535     0.200
     1.259    22.464     0.200
     1.935    31.914     0.200
     2.574    40.474     0.200
     2.665    42.384     0.200
     3.942    59.904     0.200
     4.697    72.254     0.200
     5.149    76.313     0.200
     6.058    91.234     0.200
     7.116   104.424     0.200
     8.017   117.714     0.200
     9.361   135.514     0.200
    10.636   152.654     0.200
    12.051   172.614     0.200
    12.384   176.834     0.200
    12.823   182.684     0.200
    13.415   190.584     0.200
    13.484   193.054     0.200
    14.034   198.934     0.200
    15.634   220.004     0.200
    17.820   246.004     0.200
    18.181   251.434     0.200
    20.178   281.114     0.200
    20.458   281.523     0.200
     2.885    45.943     0.200
     5.779    87.045     0.200
     5.981    90.451     0.200
     5.981    88.283     0.200
     6.132    90.834     0.200
     7.049   103.174     0.200
     6.937   102.064     0.200
     7.262   107.154     0.200
     7.584   110.984     0.200
     8.665   125.104     0.200
     9.028   132.453     0.200
     9.266   135.984     0.200
    10.038   144.385     0.200
    10.146   147.363     0.200
    10.251   148.533     0.200
    10.311   149.064     0.200
    10.324   149.164     0.200
    10.423   150.613     0.200
    10.416   151.283     0.200
    10.666   153.363     0.200
    10.813   155.154     0.200
    10.772   157.535     0.200
    11.030   162.072     0.200
    11.519   164.523     0.200
    11.532   164.064     0.200
    11.533   169.498     0.200
    11.635   170.523     0.200
    11.914   170.754     0.200
    11.859   172.385     0.200
    12.038   170.295     0.200
    11.953   175.041     0.200
    12.033   174.381     0.200
    12.242   173.635     0.200
    12.586   179.873     0.200
    12.781   182.613     0.200
    12.994   184.654     0.200
    13.126   187.203     0.200
    13.153   187.354     0.200
    13.692   192.789     0.200
    13.692   192.783     0.200
    13.903   198.145     0.200
    13.800   196.113     0.200
    14.089   201.475     0.200
    14.269   201.334     0.200
    14.342   203.244     0.200
    14.371   204.744     0.200
    14.565   205.975     0.200
    14.677   208.904     0.200
    15.004   212.514     0.200
    15.012   212.084     0.200
    15.038   214.283     0.200
    15.562   221.305     0.200
    15.715   224.953     0.200
    16.199   231.033     0.200
    16.741   239.084     0.200
    16.788   238.754     0.200
    16.818   238.033     0.200
    16.942   238.514     0.200
    17.040   237.635     0.200
    16.983   241.314     0.200
    17.241   243.453     0.200
    17.241   243.809     0.200
    17.297   244.584     0.200
    17.643   249.184     0.200
    17.689   250.055     0.200
    18.187   253.895     0.200
    18.187   254.777     0.200
    18.276   255.984     0.200
    18.276   255.203     0.200
    19.510   271.240     0.200
    19.867   276.385     0.200
    20.558   283.064     0.200
     1.200    20.770     0.200
     1.942    31.699     0.200
     2.638    41.246     0.200
     2.698    41.598     0.200
     3.389    49.547     0.200
     3.607    55.207     0.200
     3.692    53.520     0.200
     3.831    56.918     0.200
     3.889    57.316     0.200
     4.010    58.789     0.200
     4.093    59.586     0.200
     4.387    64.289     0.200
     4.462    65.727     0.200
     4.590    67.770     0.200
     4.982    75.539     0.200
     5.159    73.387     0.200
     5.456    78.727     0.200
     5.595    82.816     0.200
     5.776    87.348     0.200
     5.776    88.488     0.200
     5.844    85.438     0.200
     6.200    92.520     0.200
     6.528    94.867     0.200
     6.755    98.898     0.200
     6.834   100.527     0.200
     6.868   100.957     0.200
     6.997   102.977     0.200
     7.106   104.477     0.200
     7.673   112.289     0.200
     7.939   116.598     0.200
     8.016   115.887     0.200
     8.453   123.926     0.200
     8.515   124.457     0.200
     8.515   123.520     0.200
     8.889   131.121     0.200
     8.901   128.246     0.200
     8.865   127.656     0.200
     9.103   133.609     0.200
     9.323   136.996     0.200
    10.154   145.156     0.200
    10.368   149.059     0.200
    10.521   154.969     0.200
    10.678   156.641     0.200
    10.690   153.398     0.200
    10.773   157.637     0.200
    11.125   160.527     0.200
    11.085   159.547     0.200
    11.096   159.758     0.200
    11.167   164.129     0.200
    11.292   166.129     0.200
    11.312   161.727     0.200
    11.387   162.949     0.200
    11.412   162.676     0.200
    11.536   168.359     0.200
    11.668   170.977     0.200
    11.768   171.477     0.200
    11.799   170.117     0.200
    11.863   169.316     0.200
    11.863   165.988     0.200
    11.924   174.098     0.200
    11.960   173.488     0.200
    11.938   170.047     0.200
    12.113   173.246     0.200
    12.322   177.656     0.200
    12.417   175.797     0.200
    12.461   178.770     0.200
    12.472   179.926     0.200
    12.476   175.859     0.200
    12.582   181.699     0.200
    12.558   177.992     0.200
    12.579   178.469     0.200
    12.675   183.629     0.200
    12.629   179.848     0.200
    12.659   181.676     0.200
    12.725   182.328     0.200
    12.830   184.367     0.200
    12.803   181.836     0.200
    12.821   182.996     0.200
    12.986   186.176     0.200
    13.110   191.020     0.200
    13.208   190.879     0.200
    13.192   187.699     0.200
    13.267   191.008     0.200
    13.501   188.441     0.200
    13.501   188.727     0.200
    13.539   190.867     0.200
    13.594   196.598     0.200
    13.697   194.719     0.200
    13.771   196.609     0.200
    13.788   196.477     0.200
    13.851   198.520     0.200
    13.949   199.008     0.200
    14.115   199.547     0.200
    14.209   202.520     0.200
    14.223   202.367     0.200
    14.273   203.246     0.200
    14.555   207.258     0.200
    14.822   210.777     0.200
    14.868   210.098     0.200
    15.127   213.816     0.200
    15.089   212.719     0.200
    15.200   216.098     0.200
    15.288   214.688     0.200
    15.288   214.945     0.200
    15.418   218.258     0.200
    15.551   219.598     0.200
    15.551   220.469     0.200
    15.551   217.398     0.200
    17.184   240.008     0.200
    17.959   248.336     0.200
    19.159   266.008     0.200
    19.192   266.016     0.200
    19.451   269.367     0.200
    19.451   269.156     0.200
    19.747   271.398     0.200
    19.747   272.457     0.200
    19.749   273.469     0.200
    19.964   274.426     0.200
    19.996   273.859     0.200
    19.996   276.332     0.200
    20.007   279.102     0.200
    20.066   276.656     0.200
    20.185   276.039     0.200
    20.193   276.816     0.200
    20.274   276.609     0.200
    20.314   277.859     0.200
    20.335   278.617     0.200
    20.352   278.117     0.200
    20.339   278.609     0.200
    20.551   279.828     0.200
    20.551   280.027     0.200
    20.675   281.859     0.200
    20.682   281.527     0.200
    20.747   282.816     0.200
    20.747   285.102     0.200
    20.755   283.777     0.200
    20.895   284.699     0.200
     2.455    38.625     0.200
     2.455    37.090     0.200
     2.916    43.551     0.200
     4.824    72.363     0.200
     5.814    85.391     0.200
     9.094   129.832     0.200
     9.164   131.793     0.200
    12.903   186.480     0.200
    13.050   183.082     0.200
    13.565   187.176     0.200
    13.351   191.203     0.200
    13.695   197.902     0.200
    15.084   217.711     0.200
    15.330   218.652     0.200
    15.660   221.043     0.200
    15.589   222.273     0.200
    15.847   225.621     0.200
    16.047   228.953     0.200
    16.619   234.781     0.200
    16.757   236.250     0.200
    16.657   235.672     0.200
    16.856   237.992     0.200
    17.114   242.152     0.200
    17.114   241.352     0.200
    17.169   242.902     0.200
    17.452   244.242     0.200
    18.002   251.730     0.200
    18.002   251.000     0.200
    18.002   250.793     0.200
    18.298   255.871     0.200
    18.920   263.973     0.200
    19.789   272.980     0.200
    19.728   273.312     0.200
    19.945   275.422     0.200
    20.083   276.781     0.200
     2.697    41.605     0.200
     2.706    40.039     0.200
     3.618    55.156     0.200
     4.575    67.215     0.200
     5.592    82.207     0.200
     5.802    87.645     0.200
     6.862   100.844     0.200
     7.085   102.316     0.200
     8.491   122.836     0.200
     8.503   123.344     0.200
     8.497   123.625     0.200
     9.154   133.414     0.200
     9.378   135.996     0.200
    10.150   146.234     0.200
    10.192   144.816     0.200
    10.532   152.504     0.200
    10.537   152.227     0.200
    10.563   154.305     0.200
    10.654   154.188     0.200
    11.052   160.656     0.200
    11.059   159.367     0.200
    11.355   162.887     0.200
    11.375   162.957     0.200
    11.772   168.484     0.200
    11.854   168.594     0.200
    11.894   168.996     0.200
    12.018   172.816     0.200
    12.080   172.176     0.200
    12.259   176.656     0.200
    12.296   175.504     0.200
    12.370   175.484     0.200
    12.426   176.977     0.200
    12.452   177.914     0.200
    12.428   175.426     0.200
    12.503   175.535     0.200
    12.539   178.367     0.200
    12.592   179.688     0.200
    12.623   181.367     0.200
    12.648   181.414     0.200
    12.706   180.734     0.200
    12.729   181.754     0.200
    12.810   182.445     0.200
    12.958   184.566     0.200
    13.152   187.777     0.200
    13.331   191.234     0.200
    13.331   191.527     0.200
    13.553   188.996     0.200
    13.553   190.297     0.200
    13.667   194.504     0.200
    13.772   196.773     0.200
    13.749   194.957     0.200
    13.827   195.734     0.200
    13.827   200.301     0.200
    13.920   197.477     0.200
    14.093   201.465     0.200
    14.093   198.672     0.200
    14.093   199.336     0.200
    14.177   201.305     0.200
    14.198   201.746     0.200
    14.249   202.137     0.200
    14.518   205.805     0.200
    14.838   210.156     0.200
    15.043   214.367     0.200
    15.122   216.094     0.200
    15.129   215.734     0.200
    15.186   216.035     0.200
    15.196   214.270     0.200
    15.351   217.047     0.200
    15.391   218.594     0.200
    15.560   218.340     0.200
    15.560   219.324     0.200
    16.275   229.957     0.200
    16.283   229.824     0.200
    16.795   236.895     0.200
    16.963   237.234     0.200
    16.985   238.785     0.200
    17.395   242.242     0.200
    18.030   250.445     0.200
    18.279   253.215     0.200
    18.503   259.754     0.200
    19.227   267.844     0.200
    19.491   269.660     0.200
    19.780   272.656     0.200
    19.780   272.816     0.200
    19.785   273.375     0.200
    20.060   276.281     0.200
    20.806   285.688     0.200
     2.844    44.789     0.200
     2.896    43.379     0.200
     2.896    43.000     0.200
     4.666    67.102     0.200
     5.724    83.719     0.200
     6.019    89.379     0.200
     6.019    90.301     0.200
     6.070    90.711     0.200
     6.985   103.469     0.200
     7.151   104.570     0.200
     7.150   106.641     0.200
     7.778   115.371     0.200
     7.890   116.680     0.200
     8.545   123.992     0.200
     8.606   125.531     0.200
     8.542   130.031     0.200
     8.842   133.199     0.200
     9.230   134.180     0.200
     9.480   138.301     0.200
     9.579   140.559     0.200
    10.158   147.152     0.200
    10.206   150.102     0.200
    10.552   153.789     0.200
    10.489   155.906     0.200
    10.656   151.039     0.200
    10.898   155.406     0.200
    10.932   161.297     0.200
    11.065   159.492     0.200
    11.059   159.602     0.200
    11.298   163.871     0.200
    11.221   164.676     0.200
    11.241   164.457     0.200
    11.373   162.789     0.200
    11.372   165.570     0.200
    11.674   170.281     0.200
    11.812   170.672     0.200
    11.682   170.840     0.200
    11.964   171.859     0.200
    11.848   174.199     0.200
    12.093   171.379     0.200
    12.129   177.215     0.200
    12.178   177.660     0.200
    12.341   176.910     0.200
    12.321   174.512     0.200
    12.373   174.039     0.200
    12.431   177.121     0.200
    12.517   180.141     0.200
    12.522   180.191     0.200
    12.462   181.988     0.200
    12.588   180.000     0.200
    12.624   180.609     0.200
    12.776   183.121     0.200
    12.635   180.852     0.200
    12.789   184.391     0.200
    12.730   184.910     0.200
    12.911   183.141     0.200
    12.990   185.242     0.200
    12.867   187.559     0.200
    13.136   190.879     0.200
    13.116   191.207     0.200
    13.145   191.293     0.200
    13.318   193.102     0.200
    13.288   192.039     0.200
    13.823   191.449     0.200
    13.823   193.121     0.200
    13.538   196.070     0.200
    13.860   194.551     0.200
    13.656   197.402     0.200
    13.881   200.832     0.200
    13.881   198.332     0.200
    13.952   200.512     0.200
    13.955   200.980     0.200
    13.890   202.129     0.200
    13.946   202.410     0.200
    14.152   202.172     0.200
    14.152   200.250     0.200
    14.152   202.582     0.200
    14.197   202.250     0.200
    14.245   202.820     0.200
    14.300   206.039     0.200
    14.224   205.477     0.200
    14.431   205.789     0.200
    14.457   209.039     0.200
    14.863   210.941     0.200
    14.999   212.602     0.200
    15.085   214.059     0.200
    15.274   217.879     0.200
    15.264   218.211     0.200
    15.388   218.680     0.200
    15.388   217.891     0.200
    15.220   217.051     0.200
    15.504   221.000     0.200
    15.726   219.480     0.200
    15.882   227.332     0.200
    15.946   227.531     0.200
    16.422   232.352     0.200
    16.428   232.602     0.200
    16.915   238.359     0.200
    16.935   238.520     0.200
    17.408   243.387     0.200
    17.465   246.152     0.200
    17.557   246.629     0.200
    17.801   250.121     0.200
    18.182   254.422     0.200
    18.412   256.742     0.200
    18.412   258.246     0.200
    18.412   256.652     0.200
    18.412   257.691     0.200
    18.575   258.742     0.200
    18.481   258.891     0.200
    18.528   259.652     0.200
    18.472   259.742     0.200
    18.624   260.480     0.200
    19.035   266.461     0.200
    19.018   265.547     0.200
    19.095   269.309     0.200
    19.215   272.109     0.200
    19.227   267.816     0.200
    19.514   270.480     0.200
    19.677   272.047     0.200
    19.771   274.277     0.200
    19.880   274.699     0.200
    19.970   275.281     0.200
    20.088   276.559     0.200
    20.008   277.152     0.200
    20.220   278.859     0.200
    20.472   285.402     0.200
    20.625   284.871     0.200
    20.794   283.910     0.200
    20.794   285.574     0.200
    20.867   285.840     0.200
     2.884    45.598     0.200
     3.821    57.785     0.200
     4.733    71.324     0.200
     5.773    86.137     0.200
     6.018    88.250     0.200
     6.018    88.977     0.200
     7.660   114.895     0.200
     8.669   126.207     0.200
     8.628   124.926     0.200
    10.099   148.246     0.200
    11.162   165.004     0.200
    11.469   164.395     0.200
    11.584   169.180     0.200
    11.735   171.188     0.200
    11.914   173.137     0.200
    12.018   175.035     0.200
    12.190   174.547     0.200
    12.082   177.500     0.200
    12.428   178.625     0.200
    12.596   181.207     0.200
    12.531   179.816     0.200
    12.682   180.766     0.200
    12.629   184.855     0.200
    12.552   181.957     0.200
    12.620   183.387     0.200
    12.725   186.855     0.200
    12.976   186.406     0.200
    12.768   185.223     0.200
    12.768   186.207     0.200
    13.081   189.926     0.200
    13.242   193.645     0.200
    13.768   194.520     0.200
    13.547   195.176     0.200
    14.234   205.137     0.200
    14.292   203.496     0.200
    14.331   204.848     0.200
    14.131   205.531     0.200
    14.385   206.207     0.200
    15.101   216.785     0.200
    15.934   225.246     0.200
    16.291   230.047     0.200
    17.013   239.316     0.200
    16.852   239.035     0.200
    17.037   240.254     0.200
    17.174   241.926     0.200
    20.662   283.047     0.200
    20.662   283.895     0.200
     2.886    45.750     0.200
    11.125   157.121     0.200
    11.433   164.641     0.200
    11.159   162.520     0.200
    11.621   169.480     0.200
    12.153   174.039     0.200
    12.066   175.980     0.200
    12.399   176.090     0.200
    12.391   177.871     0.200
    12.831   182.559     0.200
    12.756   182.938     0.200
    12.667   183.789     0.200
    13.049   183.688     0.200
    12.806   183.945     0.200
    13.055   189.820     0.200
    13.426   191.938     0.200
    13.478   195.352     0.200
    13.594   194.320     0.200
    14.011   197.391     0.200
    14.209   199.059     0.200
    14.209   200.543     0.200
    14.257   199.820     0.200
    14.165   205.582     0.200
    14.548   207.246     0.200
    14.626   207.973     0.200
    14.580   206.820     0.200
    14.857   208.340     0.200
    15.766   219.125     0.200
    15.819   223.160     0.200
    15.885   225.078     0.200
    16.186   228.719     0.200
    16.069   226.809     0.200
    16.362   230.250     0.200
    16.367   230.969     0.200
    16.699   235.098     0.200
    16.854   237.910     0.200
    17.087   241.500     0.200
    17.345   244.641     0.200
    17.345   242.023     0.200
    17.403   245.598     0.200
    18.351   256.738     0.200
    18.524   257.254     0.200
    18.418   257.266     0.200
    18.465   257.980     0.200
    19.165   266.879     0.200
    19.727   273.168     0.200
    20.737   283.488     0.200
    20.737   283.922     0.200
     2.873    42.406     0.200
     3.827    57.469     0.200
     4.694    67.414     0.200
     5.753    83.969     0.200
     8.571   123.164     0.200
     9.465   137.227     0.200
    11.398   163.648     0.200
    11.991   173.328     0.200
    12.806   181.422     0.200
    12.842   187.312     0.200
    13.016   184.734     0.200
    13.299   190.562     0.200
    13.846   190.938     0.200
    14.179   199.078     0.200
    17.385   244.578     0.200
     2.507    38.969     0.200
     3.463    53.047     0.200
     4.037    60.656     0.200
     4.173    61.938     0.200
     4.225    63.445     0.200
     4.353    65.156     0.200
     4.439    65.617     0.200
     4.340    63.930     0.200
     4.725    72.016     0.200
     4.806    72.336     0.200
     4.930    72.484     0.200
     5.283    80.555     0.200
     5.316    78.938     0.200
     5.439    80.883     0.200
     5.505    82.742     0.200
     5.389    79.930     0.200
     5.698    86.188     0.200
     5.698    85.664     0.200
     5.771    85.766     0.200
     5.794    86.523     0.200
     5.736    84.523     0.200
     6.190    90.773     0.200
     6.489    95.516     0.200
     6.547    97.008     0.200
     6.704    98.594     0.200
     6.769   100.055     0.200
     6.651    96.883     0.200
     6.835   100.484     0.200
     8.085   117.109     0.200
     8.119   119.508     0.200
     8.277   121.242     0.200
     8.277   120.594     0.200
     8.235   119.844     0.200
     8.626   125.133     0.200
     9.734   140.445     0.200
     9.832   142.312     0.200
     9.875   143.867     0.200
    10.261   149.133     0.200
    10.778   156.492     0.200
    10.781   155.688     0.200
    11.083   159.969     0.200
    11.097   160.164     0.200
    11.509   166.258     0.200
    11.633   166.523     0.200
    11.806   168.969     0.200
    12.202   173.055     0.200
    12.150   175.023     0.200
    12.257   175.734     0.200
    12.213   174.430     0.200
    12.313   176.445     0.200
    12.459   177.266     0.200
    12.476   178.664     0.200
    12.692   183.727     0.200
    12.870   181.953     0.200
    13.568   188.977     0.200
    13.568   188.977     0.200
    13.400   188.047     0.200
    13.572   191.680     0.200
    13.655   192.648     0.200
    13.840   195.945     0.200
    13.840   196.734     0.200
    13.840   198.133     0.200
    13.906   198.398     0.200
    13.939   198.523     0.200
    14.194   198.977     0.200
    14.131   202.086     0.200
    14.349   203.547     0.200
    14.569   206.508     0.200
    15.390   216.758     0.200
    15.390   218.469     0.200
    16.699   234.227     0.200
    18.206   248.078     0.200
    18.564   260.688     0.200
    20.209   280.062     0.200
     2.653    42.311     0.200
     2.697    40.920     0.200
     3.570    55.480     0.200
     4.537    67.070     0.200
     5.549    82.420     0.200
     5.751    86.775     0.200
     5.751    87.699     0.200
     6.820   100.820     0.200
     7.061   104.400     0.200
     7.401   109.199     0.200
     7.569   112.430     0.200
     7.807   110.840     0.200
     7.736   112.939     0.200
     8.003   117.162     0.200
     7.995   117.504     0.200
     8.171   120.840     0.200
     8.464   124.289     0.200
     8.458   121.520     0.200
     8.401   123.219     0.200
     8.517   125.820     0.200
     8.771   128.279     0.200
     8.846   129.578     0.200
     8.953   131.914     0.200
     9.168   133.980     0.200
     9.387   135.709     0.200
     9.440   136.820     0.200
     9.711   142.156     0.200
     9.966   145.455     0.200
    10.123   146.840     0.200
    10.216   147.129     0.200
    10.270   148.869     0.200
    10.341   149.439     0.200
    10.432   150.410     0.200
    10.490   152.754     0.200
    10.629   154.250     0.200
    10.520   152.852     0.200
    10.546   152.619     0.200
    10.692   150.840     0.200
    10.740   154.855     0.200
    10.740   155.650     0.200
    10.837   157.859     0.200
    11.025   156.820     0.200
    11.034   158.359     0.200
    10.958   159.676     0.200
    11.189   159.949     0.200
    11.327   162.520     0.200
    11.220   161.525     0.200
    11.350   162.539     0.200
    11.229   161.744     0.200
    11.224   163.248     0.200
    11.600   167.340     0.200
    11.813   169.699     0.200
    11.728   169.711     0.200
    11.831   171.980     0.200
    12.052   173.080     0.200
    12.024   171.699     0.200
    12.049   174.760     0.200
    12.264   175.930     0.200
    12.124   175.922     0.200
    12.248   177.539     0.200
    12.353   174.980     0.200
    12.400   177.170     0.200
    12.517   178.939     0.200
    12.494   175.818     0.200
    12.567   179.850     0.200
    12.597   179.990     0.200
    12.475   177.938     0.200
    12.643   182.750     0.200
    12.622   181.180     0.200
    12.739   182.510     0.200
    12.739   183.299     0.200
    12.728   184.170     0.200
    12.927   184.449     0.200
    12.908   185.238     0.200
    12.908   183.000     0.200
    13.129   186.080     0.200
    13.163   188.043     0.200
    13.171   189.867     0.200
    13.272   189.760     0.200
    13.329   191.580     0.200
    13.329   190.564     0.200
    13.503   189.445     0.200
    13.503   190.449     0.200
    13.320   190.400     0.200
    13.541   189.799     0.200
    13.638   193.689     0.200
    13.727   195.574     0.200
    13.725   195.549     0.200
    13.588   194.852     0.200
    13.657   194.209     0.200
    13.890   198.029     0.200
    14.059   199.580     0.200
    14.059   198.549     0.200
    14.059   199.279     0.200
    13.925   199.459     0.200
    13.963   200.449     0.200
    14.149   200.680     0.200
    14.165   200.020     0.200
    13.997   198.820     0.200
    14.216   202.561     0.200
    14.283   203.523     0.200
    14.493   205.660     0.200
    14.571   206.480     0.200
    14.609   207.619     0.200
    14.761   209.010     0.200
    14.808   209.779     0.200
    14.751   205.750     0.200
    14.942   211.299     0.200
    15.131   214.389     0.200
    15.129   215.000     0.200
    15.129   214.547     0.200
    15.185   213.910     0.200
    15.185   214.711     0.200
    15.360   216.820     0.200
    15.265   217.670     0.200
    15.349   217.320     0.200
    15.389   217.740     0.200
    15.921   226.430     0.200
    15.895   226.500     0.200
    15.989   228.049     0.200
    16.102   228.910     0.200
    16.152   230.320     0.200
    16.274   230.830     0.200
    16.282   231.539     0.200
    16.670   234.596     0.200
    16.780   237.650     0.200
    16.932   236.990     0.200
    16.981   238.549     0.200
    17.162   242.670     0.200
    17.247   243.260     0.200
    17.419   245.299     0.200
    17.419   245.191     0.200
    17.475   246.170     0.200
    17.920   251.643     0.200
    18.281   254.252     0.200
    18.281   255.049     0.200
    18.281   254.689     0.200
    18.343   255.709     0.200
    18.433   261.959     0.200
    18.653   260.617     0.200
    18.959   263.539     0.200
    19.031   264.494     0.200
    19.153   266.910     0.200
    19.894   275.100     0.200
    19.995   275.230     0.200
    20.028   275.830     0.200
    20.131   277.160     0.200
    20.470   280.000     0.200
    20.379   279.840     0.200
    20.932   286.680     0.200
     2.829    43.098     0.200
     2.921    43.547     0.200
     3.786    57.578     0.200
     4.646    67.977     0.200
     5.708    82.816     0.200
     6.012    90.172     0.200
     8.587   123.688     0.200
     9.257   134.535     0.200
     9.606   138.887     0.200
    11.349   161.078     0.200
    11.701   166.258     0.200
    11.946   167.578     0.200
    11.945   172.016     0.200
    12.069   171.738     0.200
    14.130   200.746     0.200
    14.173   200.098     0.200
    15.290   215.695     0.200
    17.433   243.723     0.200
    18.439   256.348     0.200
    19.539   269.309     0.200
     1.280    22.895     0.200
     2.150    33.625     0.200
     2.967    44.605     0.200
     2.967    44.336     0.200
     3.665    53.805     0.200
     3.602    54.637     0.200
     3.983    57.527     0.200
     4.112    61.055     0.200
     4.155    61.715     0.200
     4.296    62.445     0.200
     4.388    64.336     0.200
     4.750    69.984     0.200
     4.883    71.547     0.200
     5.257    77.504     0.200
     5.327    78.324     0.200
     5.836    87.879     0.200
     5.836    87.594     0.200
    13.955   199.156     0.200
    18.269   251.055     0.200
     1.154    20.262     0.200
     1.168    21.480     0.200
     1.919    31.250     0.200
     2.664    40.980     0.200
     3.730    54.562     0.200
     3.871    55.840     0.200
     4.049    60.719     0.200
     4.131    61.180     0.200
     4.501    67.031     0.200
     4.619    69.492     0.200
     5.025    75.281     0.200
     5.011    75.191     0.200
     5.132    76.770     0.200
     5.196    77.469     0.200
     5.468    81.102     0.200
     5.737    87.242     0.200
     6.562    97.910     0.200
     6.746    99.211     0.200
     7.941   115.090     0.200
     7.991   116.020     0.200
     8.107   119.410     0.200
    13.477   190.535     0.200
     1.949    30.839     0.200
     2.514    40.658     0.200
     2.858    43.063     0.200
     2.858    42.809     0.200
     3.452    53.329     0.200
     3.937    57.568     0.200
     4.078    59.849     0.200
     4.337    63.778     0.200
     4.375    65.549     0.200
     4.708    69.639     0.200
     4.826    71.809     0.200
     5.143    77.629     0.200
     5.338    78.019     0.200
     5.402    78.589     0.200
     5.663    85.738     0.200
     5.663    85.229     0.200
     5.663    85.448     0.200
     5.755    84.559     0.200
     6.086    89.119     0.200
     7.801   113.639     0.200
     7.801   113.309     0.200
    10.909   154.677     0.200
    13.490   189.733     0.200
    13.490   189.729     0.200
    13.889   199.430     0.200
    13.889   199.429     0.200
    15.186   215.698     0.200
    15.387   218.464     0.200
    16.535   232.049     0.200
    18.455   256.669     0.200
    20.288   277.999     0.200
    20.772   282.139     0.200
    20.989   284.669     0.200
     1.205    21.510     0.200
     1.997    31.680     0.200
     2.654    41.770     0.200
     2.759    41.439     0.200
     2.759    42.090     0.200
     3.533    51.850     0.200
     3.942    57.580     0.200
     3.996    59.320     0.200
     4.122    59.740     0.200
     4.208    61.480     0.200
     4.495    67.580     0.200
     4.524    66.260     0.200
     4.575    67.039     0.200
     4.699    69.020     0.200
     5.125    75.100     0.200
     5.085    74.529     0.200
     5.208    76.180     0.200
     5.540    81.850     0.200
     5.547    81.619     0.200
     5.564    82.180     0.200
     5.776    87.164     0.200
     5.776    86.641     0.200
     5.899    87.561     0.200
     5.899    87.359     0.200
     5.960    87.270     0.200
     6.258    91.590     0.200
     6.296    92.959     0.200
     6.317    92.250     0.200
     6.474    92.850     0.200
     6.656    96.561     0.200
     6.816   100.289     0.200
     6.946   101.471     0.200
     7.031   103.471     0.200
     7.110   104.641     0.200
     7.110   105.490     0.200
     7.110   104.379     0.200
     7.111   103.980     0.200
     7.112   104.080     0.200
     7.598   111.879     0.200
     7.623   112.650     0.200
     7.779   114.580     0.200
     7.840   114.910     0.200
     7.942   115.369     0.200
     7.942   115.129     0.200
     8.066   116.590     0.200
     8.054   119.256     0.200
     8.041   117.045     0.200
     8.303   121.279     0.200
     8.454   123.000     0.200
     8.454   122.471     0.200
     8.437   122.641     0.200
     8.437   122.490     0.200
     8.557   127.160     0.200
     8.725   128.199     0.200
     8.844   130.119     0.200
     8.804   127.090     0.200
     8.819   130.359     0.200
     9.021   130.869     0.200
     8.996   131.969     0.200
     9.149   133.830     0.200
     9.158   135.469     0.200
     9.214   134.570     0.200
     9.437   137.900     0.200
     9.496   138.689     0.200
     9.747   144.271     0.200
     9.925   144.109     0.200
    10.010   145.516     0.200
    10.026   145.629     0.200
    10.319   149.840     0.200
    10.397   152.660     0.200
    10.475   152.561     0.200
    10.526   154.369     0.200
    10.578   152.850     0.200
    10.622   155.010     0.200
    10.596   153.529     0.200
    10.798   156.117     0.200
    10.798   156.580     0.200
    10.995   157.859     0.200
    11.242   161.709     0.200
    11.260   164.250     0.200
    11.298   162.551     0.200
    11.431   164.141     0.200
    11.317   162.930     0.200
    11.648   168.760     0.200
    11.806   168.750     0.200
    11.806   167.570     0.200
    11.848   170.197     0.200
    11.835   170.119     0.200
    12.077   173.270     0.200
    12.022   172.170     0.200
    12.161   175.520     0.200
    12.311   178.939     0.200
    12.311   177.699     0.200
    12.241   175.459     0.200
    12.241   174.721     0.200
    12.357   179.279     0.200
    12.368   177.109     0.200
    12.480   179.260     0.200
    12.444   176.037     0.200
    12.534   178.650     0.200
    12.565   180.119     0.200
    12.703   182.789     0.200
    12.703   184.439     0.200
    12.653   183.051     0.200
    12.798   185.199     0.200
    12.761   181.090     0.200
    12.789   183.971     0.200
    12.902   184.869     0.200
    12.990   186.770     0.200
    12.936   183.090     0.200
    13.093   187.221     0.200
    13.191   188.789     0.200
    13.315   191.330     0.200
    13.387   191.840     0.200
    13.387   192.180     0.200
    13.552   189.834     0.200
    13.552   188.529     0.200
    13.587   190.369     0.200
    13.589   190.551     0.200
    13.589   189.600     0.200
    13.611   193.811     0.200
    13.729   195.125     0.200
    13.804   198.850     0.200
    14.039   199.660     0.200
    14.039   198.084     0.200
    14.120   201.480     0.200
    14.194   201.811     0.200
    14.474   205.721     0.200
    14.308   205.281     0.200
    14.383   203.484     0.200
    14.456   204.445     0.200
    14.460   206.141     0.200
    14.559   208.029     0.200
    14.528   204.980     0.200
    14.669   208.939     0.200
    14.730   209.879     0.200
    14.781   208.830     0.200
    14.999   213.670     0.200
    14.984   214.090     0.200
    15.181   216.420     0.200
    15.181   216.717     0.200
    15.248   215.609     0.200
    15.248   215.061     0.200
    15.408   218.699     0.200
    15.408   218.246     0.200
    15.336   217.119     0.200
    15.522   218.602     0.200
    15.522   217.811     0.200
    15.522   217.689     0.200
    16.184   229.230     0.200
    16.430   231.180     0.200
    16.384   230.840     0.200
    16.610   234.500     0.200
    16.727   234.051     0.200
    16.727   235.154     0.200
    16.809   235.109     0.200
    16.907   236.609     0.200
    17.204   237.910     0.200
    17.453   241.277     0.200
    18.063   249.410     0.200
    18.409   254.363     0.200
    18.458   257.801     0.200
    18.458   257.584     0.200
    18.619   259.070     0.200
    18.643   260.520     0.200
    18.643   259.285     0.200
    19.007   264.350     0.200
    19.065   263.861     0.200
    19.179   269.301     0.200
    19.266   267.570     0.200
    19.285   266.066     0.200
    19.550   270.301     0.200
    19.550   270.066     0.200
    19.610   275.350     0.200
    19.723   272.035     0.200
    19.843   273.996     0.200
    19.837   272.539     0.200
    19.942   277.721     0.200
    20.044   274.689     0.200
    20.074   275.830     0.200
    20.117   275.039     0.200
    20.291   277.770     0.200
    20.285   277.705     0.200
    20.380   278.721     0.200
    20.379   278.629     0.200
    20.428   279.270     0.200
    20.444   280.141     0.200
    20.449   280.102     0.200
    20.672   281.529     0.200
    20.710   282.254     0.200
    20.787   283.039     0.200
    20.769   283.520     0.200
    20.864   283.820     0.200
    20.864   283.648     0.200
    20.863   284.459     0.200
    20.975   288.029     0.200
    20.992   285.350     0.200
     1.208    21.238     0.200
     1.971    31.059     0.200
     2.678    41.148     0.200
     2.698    40.781     0.200
     2.698    41.137     0.200
     2.698    40.656     0.200
     3.472    52.398     0.200
     3.597    54.629     0.200
     3.747    54.559     0.200
     3.885    58.309     0.200
     4.149    60.926     0.200
     4.439    65.707     0.200
     4.517    66.695     0.200
     4.559    66.629     0.200
     4.640    68.277     0.200
     5.027    73.648     0.200
     5.076    74.777     0.200
     5.149    75.578     0.200
     5.216    75.707     0.200
     5.483    81.398     0.200
     5.574    81.656     0.200
     5.779    87.133     0.200
     5.779    86.797     0.200
     5.779    86.969     0.200
     5.901    86.676     0.200
     5.928    86.969     0.200
     6.200    90.066     0.200
     6.414    92.266     0.200
     6.844    99.438     0.200
     6.888   100.605     0.200
     7.537   109.129     0.200
     7.563   111.508     0.200
     7.724   113.566     0.200
     7.967   115.605     0.200
     7.967   115.477     0.200
     8.043   116.016     0.200
     8.478   120.477     0.200
     8.487   122.777     0.200
     8.961   129.969     0.200
     9.157   133.797     0.200
     9.378   135.828     0.200
    10.261   148.676     0.200
    10.425   149.809     0.200
    10.716   153.398     0.200
    10.737   154.309     0.200
    10.824   153.695     0.200
    11.182   160.508     0.200
    11.345   162.898     0.200
    11.837   168.516     0.200
    12.017   170.938     0.200
    12.070   172.156     0.200
    12.365   175.426     0.200
    12.583   178.707     0.200
    12.614   180.816     0.200
    12.794   182.637     0.200
    13.144   185.945     0.200
    13.529   189.453     0.200
    13.564   190.277     0.200
    13.566   190.668     0.200
    13.657   191.066     0.200
    13.741   193.777     0.200
    13.909   194.777     0.200
    14.080   199.945     0.200
    14.167   199.836     0.200
    14.510   205.527     0.200
    15.445   219.219     0.200
     1.086    19.619     0.200
     1.929    30.579     0.200
     2.835    42.554     0.200
     2.835    42.449     0.200
     3.618    52.779     0.200
     3.918    57.019     0.200
     4.119    60.979     0.200
     4.237    61.369     0.200
     5.136    77.759     0.200
     5.656    83.569     0.200
     5.654    83.579     0.200
     5.654    85.239     0.200
     5.757    84.639     0.200
     6.373    96.059     0.200
     6.826    99.739     0.200
     7.801   112.789     0.200
     8.160   123.219     0.200
     8.311   120.819     0.200
     8.661   126.899     0.200
     8.678   126.219     0.200
     9.006   132.849     0.200
     9.315   134.719     0.200
     9.578   137.729     0.200
     9.664   140.079     0.200
     9.819   140.789     0.200
    13.472   188.812     0.200
    13.897   195.907     0.200
    15.385   216.904     0.200
    17.587   243.333     0.200
     1.990    31.406     0.200
     2.584    39.195     0.200
     2.584    38.875     0.200
     2.584    39.559     0.200
     3.368    52.355     0.200
     3.305    48.219     0.200
     3.696    56.219     0.200
     3.613    52.559     0.200
     3.803    56.168     0.200
     3.929    57.016     0.200
     4.016    58.527     0.200
     4.302    63.918     0.200
     4.382    64.078     0.200
     4.508    66.035     0.200
     4.733    67.059     0.200
     4.952    74.566     0.200
     5.026    74.285     0.200
     5.016    73.906     0.200
     5.083    73.746     0.200
     5.347    79.035     0.200
     5.371    79.496     0.200
     5.689    81.738     0.200
     5.702    84.355     0.200
     5.855    88.398     0.200
     5.855    88.188     0.200
     5.855    88.617     0.200
     5.769    84.355     0.200
     6.045    88.258     0.200
     6.065    89.527     0.200
     6.104    89.527     0.200
     6.126    88.945     0.200
     6.282    89.578     0.200
     6.345    94.008     0.200
     6.457    95.785     0.200
     6.541    95.035     0.200
     6.772    99.445     0.200
     6.962   100.277     0.200
     7.284   105.766     0.200
     7.655   113.406     0.200
     7.993   116.996     0.200
     8.080   116.688     0.200
     8.080   116.496     0.200
     8.503   124.016     0.200
     8.464   127.336     0.200
     8.610   124.746     0.200
     8.610   125.547     0.200
     8.610   123.098     0.200
     8.610   123.836     0.200
     8.899   130.656     0.200
     8.857   129.328     0.200
     8.789   131.707     0.200
     8.885   129.488     0.200
     8.960   131.648     0.200
     9.020   133.637     0.200
     9.245   133.977     0.200
     9.344   141.836     0.200
     9.562   136.496     0.200
     9.629   137.918     0.200
     9.629   138.676     0.200
     9.688   142.059     0.200
     9.799   142.578     0.200
     9.896   140.977     0.200
     9.912   142.406     0.200
     9.980   143.105     0.200
     9.980   145.477     0.200
    10.136   145.688     0.200
    10.470   151.238     0.200
    10.745   154.867     0.200
    12.561   180.266     0.200
    12.669   182.238     0.200
    12.721   181.219     0.200
    12.917   184.137     0.200
    13.549   190.094     0.200
    13.549   190.277     0.200
    13.791   197.148     0.200
    14.211   203.348     0.200
    14.647   209.059     0.200
    15.641   221.445     0.200
    17.266   240.746     0.200
    19.361   268.488     0.200
     1.210    22.000     0.200
     1.301    23.418     0.200
     1.681    28.980     0.200
     1.802    30.820     0.200
     2.088    34.281     0.200
     2.967    45.648     0.200
     1.600    26.922     0.200
     1.767    29.562     0.200
     2.046    33.570     0.200
     2.703    41.172     0.200
     1.087    19.859     0.200
     1.145    20.230     0.200
     1.428    24.082     0.200
     1.483    25.031     0.200
     1.611    26.691     0.200
     1.943    31.461     0.200
     2.194    34.570     0.200
     3.145    47.742     0.200
     3.209    50.570     0.200
     3.972    61.480     0.200
     4.624    70.941     0.200
     1.698    27.324     0.200
     1.844    29.262     0.200
     1.983    31.383     0.200
     2.196    34.422     0.200
     2.457    38.902     0.200
     2.537    39.473     0.200
     2.537    39.289     0.200
     2.648    40.625     0.200
     2.873    42.930     0.200
     3.181    48.195     0.200
     3.479    53.453     0.200
     3.636    53.422     0.200
     4.080    59.992     0.200
     4.259    62.133     0.200
     4.268    65.473     0.200
     4.268    65.359     0.200
     4.392    64.324     0.200
     4.634    69.184     0.200
     4.711    69.414     0.200
     4.659    69.051     0.200
     4.832    71.305     0.200
     5.047    75.473     0.200
     5.047    75.914     0.200
     5.173    77.344     0.200
     5.188    77.805     0.200
     5.408    77.664     0.200
     5.426    80.633     0.200
     5.694    86.453     0.200
     5.694    83.793     0.200
     5.694    85.895     0.200
     5.694    84.344     0.200
     5.776    85.012     0.200
     6.026    89.203     0.200
     6.681    97.793     0.200
     6.693    96.875     0.200
     6.841    99.352     0.200
     7.190   101.824     0.200
     7.310   106.273     0.200
     7.279   106.773     0.200
     7.279   106.312     0.200
     7.279   106.473     0.200
     7.430   108.973     0.200
     7.430   108.738     0.200
     8.040   116.203     0.200
     8.061   116.602     0.200
     8.057   119.082     0.200
     8.225   119.895     0.200
     8.300   121.273     0.200
     8.326   121.414     0.200
     8.326   120.824     0.200
     8.510   126.203     0.200
     8.614   124.250     0.200
     8.725   127.074     0.200
     8.857   126.512     0.200
     8.861   128.012     0.200
     9.311   134.852     0.200
     9.323   135.004     0.200
     9.323   134.129     0.200
     9.489   138.332     0.200
     9.722   140.934     0.200
     9.722   140.359     0.200
     9.899   141.852     0.200
    10.143   146.324     0.200
    10.153   146.684     0.200
    10.428   149.531     0.200
    10.801   153.895     0.200
    11.158   160.941     0.200
    11.680   166.914     0.200
    11.678   168.113     0.200
    11.882   170.352     0.200
    12.026   171.973     0.200
    12.171   172.664     0.200
    12.424   178.484     0.200
    12.539   178.531     0.200
    12.633   180.645     0.200
    13.524   189.430     0.200
    13.550   192.145     0.200
    13.612   193.973     0.200
    13.903   197.234     0.200
    13.980   199.613     0.200
    14.006   198.574     0.200
    14.088   200.793     0.200
    14.264   200.594     0.200
    14.320   202.555     0.200
    14.382   203.293     0.200
    14.590   208.934     0.200
    14.642   207.934     0.200
    14.788   206.531     0.200
    14.999   212.652     0.200
    15.197   215.484     0.200
    15.287   215.023     0.200
    15.413   216.113     0.200
    15.531   219.922     0.200
    16.260   228.914     0.200
    16.769   235.312     0.200
    18.104   246.715     0.200
     1.091    19.562     0.200
     1.529    25.621     0.200
     1.682    28.102     0.200
     1.682    28.203     0.200
     1.907    31.121     0.200
     1.962    31.242     0.200
     2.013    32.242     0.200
     2.397    38.180     0.200
     3.103    47.473     0.200
     3.701    57.633     0.200
     1.312    23.945     0.200
     1.412    25.234     0.200
     1.412    25.266     0.200
     1.466    26.266     0.200
     1.943    31.961     0.200
     2.213    36.578     0.200
     3.286    52.508     0.200
     1.100    19.987     0.200
     1.811    29.047     0.200
     1.811    28.877     0.200
     2.121    33.558     0.200
     2.505    38.797     0.200
     2.430    38.407     0.200
     2.430    38.237     0.200
     2.518    39.127     0.200
     2.615    40.157     0.200
     2.854    42.947     0.200
     2.854    42.524     0.200
     2.854    42.797     0.200
     3.162    48.058     0.200
     3.456    53.257     0.200
     3.456    52.947     0.200
     3.630    52.688     0.200
     3.931    56.268     0.200
     4.072    59.308     0.200
     4.250    61.487     0.200
     4.239    65.547     0.200
     4.381    63.257     0.200
     4.702    69.377     0.200
     4.644    69.237     0.200
     5.021    76.177     0.200
     5.021    76.037     0.200
     5.158    78.527     0.200
     5.407    79.987     0.200
     5.407    78.207     0.200
     5.667    85.730     0.200
     5.667    85.427     0.200
     6.004    89.497     0.200
     6.501    96.657     0.200
     6.501    96.367     0.200
     6.661    98.417     0.200
     6.677    98.567     0.200
     6.827    99.827     0.200
     7.276   106.007     0.200
     7.257   106.907     0.200
     7.257   106.558     0.200
     7.806   113.717     0.200
     7.806   113.007     0.200
     8.204   119.217     0.200
     8.292   120.547     0.200
     9.104   131.197     0.200
     9.242   133.577     0.200
     9.312   135.067     0.200
    13.491   189.632     0.200
    15.392   217.282     0.200
    20.445   278.938     0.200
    20.768   283.567     0.200
     1.017    18.852     0.200
     1.033    19.109     0.200
     1.826    30.227     0.200
     1.940    32.656     0.200
     2.380    38.461     0.200
     2.887    45.812     0.200
     3.072    49.578     0.200
     3.675    56.820     0.200
     0.775    14.001     0.200
     0.893    15.741     0.200
     1.831    28.801     0.200
     1.937    31.111     0.200
     2.178    34.081     0.200
     2.576    39.581     0.200
     2.634    40.591     0.200
     2.641    40.381     0.200
     2.952    44.086     0.200
     3.256    49.151     0.200
     3.361    50.991     0.200
     3.750    54.791     0.200
     4.049    59.061     0.200
     4.169    62.131     0.200
     4.192    62.311     0.200
     4.821    70.251     0.200
     4.935    71.871     0.200
     4.935    71.791     0.200
     4.936    73.241     0.200
     5.195    76.861     0.200
     5.332    77.931     0.200
     5.512    80.321     0.200
     5.648    82.841     0.200
     5.908    85.831     0.200
     6.413    93.081     0.200
     6.503    94.461     0.200
     6.556    94.361     0.200
     6.711    97.801     0.200
     6.872    99.801     0.200
     6.920    99.901     0.200
     7.161   102.761     0.200
     7.155   103.381     0.200
     7.158   103.921     0.200
     7.265   104.771     0.200
     7.697   111.211     0.200
     7.932   114.441     0.200
     8.103   116.471     0.200
     8.169   118.251     0.200
     8.196   118.291     0.200
     8.732   126.301     0.200
     8.724   127.181     0.200
     8.982   129.371     0.200
     9.119   130.101     0.200
     9.198   132.611     0.200
     9.189   132.841     0.200
    11.550   163.230     0.200
    12.327   176.071     0.200
    12.799   181.381     0.200
    13.460   187.886     0.200
    13.499   188.501     0.200
    13.499   190.561     0.200
    13.483   190.591     0.200
    13.773   193.861     0.200
    13.916   196.401     0.200
    14.662   207.941     0.200
    15.291   214.986     0.200
    17.050   235.381     0.200
    17.114   235.616     0.200
    17.719   243.953     0.200
    18.560   256.306     0.200
     1.214    21.088     0.200
     1.827    29.059     0.200
     1.933    30.598     0.200
     2.173    33.678     0.200
     2.352    37.539     0.200
     2.412    37.539     0.200
     2.571    39.219     0.200
     2.630    39.549     0.200
     2.637    40.039     0.200
     3.057    46.379     0.200
     2.948    45.268     0.200
     2.948    43.938     0.200
     3.254    51.357     0.200
     3.361    51.719     0.200
     3.747    54.379     0.200
     4.168    63.848     0.200
     4.045    58.668     0.200
     4.263    62.629     0.200
     4.188    60.879     0.200
     4.531    67.758     0.200
     4.935    75.139     0.200
     4.817    70.029     0.200
     4.931    71.469     0.200
     4.931    71.758     0.200
     5.190    75.268     0.200
     5.289    77.949     0.200
     5.328    76.959     0.200
     5.649    82.719     0.200
     5.508    82.449     0.200
     5.508    79.078     0.200
     5.907    88.049     0.200
     5.907    86.168     0.200
     6.145    89.199     0.200
     6.190    90.078     0.200
     6.413    95.059     0.200
     6.413    93.809     0.200
     6.557    95.518     0.200
     6.557    94.729     0.200
     6.499    94.938     0.200
     6.546    95.398     0.200
     6.709    96.648     0.200
     6.916   100.898     0.200
     6.868   100.607     0.200
     7.137   104.299     0.200
     7.157   104.869     0.200
     7.157   103.848     0.200
     7.157   106.539     0.200
     7.262   105.318     0.200
     7.698   111.848     0.200
     7.698   111.438     0.200
     7.928   114.238     0.200
     7.933   114.148     0.200
     8.103   117.838     0.200
     8.171   117.729     0.200
     8.197   118.879     0.200
     8.225   120.279     0.200
     8.546   122.389     0.200
     8.596   122.879     0.200
     8.706   128.299     0.200
     8.725   125.998     0.200
     8.733   126.168     0.200
     8.733   125.709     0.200
     8.984   129.738     0.200
     8.984   128.758     0.200
     9.121   129.529     0.200
     9.191   132.279     0.200
     9.195   131.658     0.200
     9.198   132.148     0.200
     9.360   135.738     0.200
     9.453   135.299     0.200
     9.539   137.639     0.200
     9.398   135.238     0.200
     9.461   138.857     0.200
     9.461   134.449     0.200
     9.695   139.018     0.200
     9.771   138.658     0.200
     9.674   139.959     0.200
     9.674   138.168     0.200
     9.879   140.469     0.200
    10.015   143.398     0.200
    10.015   140.607     0.200
    10.026   144.938     0.200
    10.458   149.178     0.200
    10.338   150.938     0.200
    10.674   150.549     0.200
    10.558   153.838     0.200
    10.574   152.688     0.200
    10.881   159.357     0.200
    11.085   156.578     0.200
    11.094   158.658     0.200
    11.004   156.713     0.200
    11.004   160.607     0.200
    11.551   165.459     0.200
    11.551   163.869     0.200
    11.757   167.799     0.200
    12.104   173.119     0.200
    12.208   172.088     0.200
    12.301   175.039     0.200
    12.327   176.479     0.200
    12.327   175.469     0.200
    12.307   176.699     0.200
    12.636   179.969     0.200
    12.799   182.598     0.200
    12.832   183.508     0.200
    12.935   184.588     0.200
    13.295   188.229     0.200
    13.457   188.344     0.200
    13.496   189.408     0.200
    13.496   191.459     0.200
    13.496   188.578     0.200
    13.496   188.688     0.200
    13.593   195.938     0.200
    13.775   192.818     0.200
    13.855   197.107     0.200
    13.905   196.268     0.200
    13.916   197.488     0.200
    13.916   194.379     0.200
    14.197   201.857     0.200
    14.425   205.158     0.200
    14.425   205.379     0.200
    14.662   208.379     0.200
    14.880   210.678     0.200
    14.993   213.588     0.200
    14.993   209.369     0.200
    15.291   214.219     0.200
    15.291   216.168     0.200
    15.291   216.629     0.200
    15.565   220.248     0.200
    15.654   221.279     0.200
    15.668   220.828     0.200
    15.915   220.318     0.200
    16.298   228.418     0.200
    16.552   231.268     0.200
    17.048   236.488     0.200
    17.111   238.744     0.200
    17.372   239.068     0.200
    17.716   245.543     0.200
    18.125   247.709     0.200
    20.561   279.729     0.200
    20.860   284.209     0.200
     0.774    14.219     0.200
     0.906    16.062     0.200
     0.906    16.305     0.200
     1.216    21.055     0.200
     1.341    22.570     0.200
     1.341    22.172     0.200
     1.847    29.523     0.200
     1.954    31.523     0.200
     2.190    34.062     0.200
     2.426    38.289     0.200
     2.426    37.836     0.200
     2.587    39.945     0.200
     2.657    40.922     0.200
     2.958    44.445     0.200
     2.958    44.289     0.200
     3.071    46.641     0.200
     3.377    51.898     0.200
     3.377    51.633     0.200
     3.749    54.641     0.200
     3.749    54.844     0.200
     4.187    64.070     0.200
     4.273    62.391     0.200
     4.273    62.242     0.200
     4.250    62.391     0.200
     4.543    67.320     0.200
     4.622    68.016     0.200
     4.821    69.984     0.200
     4.953    73.414     0.200
     4.937    71.562     0.200
     4.944    71.898     0.200
     5.179    75.359     0.200
     5.298    76.875     0.200
     5.312    78.789     0.200
     5.331    76.992     0.200
     5.513    80.148     0.200
     5.513    79.781     0.200
     5.607    85.242     0.200
     5.607    81.648     0.200
     5.923    87.625     0.200
     5.923    87.023     0.200
     6.430    95.500     0.200
     6.430    92.992     0.200
     6.503    93.523     0.200
     6.571    95.445     0.200
     6.571    95.250     0.200
     6.577    95.625     0.200
     6.552    94.148     0.200
     6.722    97.742     0.200
     6.937   100.711     0.200
     7.146   102.891     0.200
     7.146   103.625     0.200
     7.172   104.523     0.200
     7.172   103.180     0.200
     7.167   103.562     0.200
     7.167   102.273     0.200
     7.452   106.836     0.200
     7.582   109.773     0.200
     7.711   111.812     0.200
     7.711   111.242     0.200
     7.797   111.516     0.200
     7.936   113.844     0.200
     7.945   114.844     0.200
     7.945   114.539     0.200
     8.052   116.469     0.200
     8.117   117.164     0.200
     8.178   117.609     0.200
     8.178   117.734     0.200
     8.159   117.664     0.200
     8.207   118.812     0.200
     8.354   120.141     0.200
     8.556   123.555     0.200
     8.608   122.742     0.200
     8.608   123.633     0.200
     8.733   124.812     0.200
     8.744   125.141     0.200
     8.828   126.055     0.200
     8.899   128.211     0.200
     8.991   128.836     0.200
     8.991   129.016     0.200
     9.127   130.891     0.200
     9.127   130.250     0.200
     9.212   133.000     0.200
     9.212   131.789     0.200
     9.367   134.219     0.200
     9.401   133.234     0.200
     9.459   134.773     0.200
     9.544   136.234     0.200
     9.671   138.242     0.200
     9.700   138.375     0.200
     9.770   139.344     0.200
     9.783   139.742     0.200
     9.783   138.789     0.200
     9.889   140.312     0.200
    10.021   142.445     0.200
    10.469   149.586     0.200
    10.469   149.273     0.200
    11.036   156.320     0.200
    11.097   157.445     0.200
    11.103   157.680     0.200
    11.698   165.953     0.200
    11.761   166.844     0.200
    11.906   168.703     0.200
    12.113   172.086     0.200
    12.203   171.648     0.200
    12.203   172.250     0.200
    12.340   176.555     0.200
    12.340   175.141     0.200
    12.813   181.180     0.200
    12.833   181.250     0.200
    12.947   183.445     0.200
    13.478   190.516     0.200
    13.478   190.109     0.200
    13.517   189.711     0.200
    13.782   194.594     0.200
    13.931   196.375     0.200
    14.072   198.266     0.200
    14.138   200.086     0.200
    14.199   199.742     0.200
    14.469   203.172     0.200
    14.676   206.398     0.200
    14.881   209.602     0.200
    15.005   211.703     0.200
    15.306   216.344     0.200
    15.306   215.984     0.200
    15.434   216.391     0.200
    15.518   219.070     0.200
    15.657   219.789     0.200
    15.668   219.539     0.200
    15.675   220.242     0.200
    15.757   222.312     0.200
    15.875   223.344     0.200
    16.138   225.719     0.200
    16.244   227.500     0.200
    17.413   241.539     0.200
    18.563   257.289     0.200
    18.657   257.031     0.200
     1.188    21.320     0.200
     1.508    25.938     0.200
     1.508    25.801     0.200
     1.548    26.148     0.200
     1.571    27.090     0.200
     1.610    26.961     0.200
     2.489    39.820     0.200
     2.704    42.641     0.200
     2.704    41.789     0.200
     3.834    56.789     0.200
     3.834    57.508     0.200
     3.883    59.098     0.200
     4.047    60.758     0.200
     4.048    61.238     0.200
     4.238    63.250     0.200
     4.366    65.180     0.200
     4.438    66.840     0.200
     4.684    70.730     0.200
     4.784    71.938     0.200
     4.784    73.469     0.200
     4.784    72.508     0.200
     4.819    72.570     0.200
     4.835    73.039     0.200
     4.910    73.480     0.200
     4.987    75.238     0.200
     5.133    76.500     0.200
     5.133    77.781     0.200
     5.433    81.109     0.200
     6.046    90.320     0.200
     6.046    89.949     0.200
     6.198    89.699     0.200
     6.252    92.719     0.200
     6.365    94.738     0.200
     6.365    94.188     0.200
     6.568    98.121     0.200
     6.835   101.340     0.200
     6.835   101.070     0.200
     6.872   101.418     0.200
     7.123   105.230     0.200
     7.123   104.848     0.200
     7.263   107.969     0.200
     7.583   110.590     0.200
     7.623   113.789     0.200
     7.736   113.020     0.200
     7.993   116.680     0.200
     8.037   119.949     0.200
     8.383   124.828     0.200
     8.396   121.801     0.200
     8.407   122.328     0.200
     8.419   121.891     0.200
     8.456   126.039     0.200
     8.505   123.328     0.200
     8.520   122.258     0.200
     8.535   124.680     0.200
     8.535   124.828     0.200
     8.571   126.500     0.200
     8.668   125.738     0.200
     8.683   129.020     0.200
     8.839   128.258     0.200
     8.839   130.879     0.200
     8.942   129.660     0.200
     8.942   129.500     0.200
     9.029   131.219     0.200
     9.055   131.031     0.200
     9.222   133.289     0.200
     9.278   133.828     0.200
     9.286   134.469     0.200
     9.294   134.559     0.200
     9.466   136.949     0.200
     9.497   137.680     0.200
     9.738   140.199     0.200
    10.006   143.469     0.200
    10.044   144.609     0.200
    10.141   146.648     0.200
    10.496   150.188     0.200
    10.721   156.227     0.200
    10.721   154.090     0.200
    11.053   158.828     0.200
    11.158   159.668     0.200
    11.571   164.500     0.200
    11.688   166.129     0.200
    11.706   166.559     0.200
    11.709   167.480     0.200
    12.015   172.988     0.200
    12.041   173.410     0.200
    12.067   172.250     0.200
    12.130   171.840     0.200
    12.138   172.531     0.200
    12.153   172.141     0.200
    12.302   175.148     0.200
    12.333   174.371     0.200
    12.382   176.238     0.200
    12.389   176.328     0.200
    12.389   175.129     0.200
    12.551   176.859     0.200
    12.589   179.090     0.200
    12.739   179.789     0.200
    12.857   183.711     0.200
    12.890   182.898     0.200
    13.031   184.629     0.200
    13.106   186.879     0.200
    13.177   186.430     0.200
    13.293   189.500     0.200
    13.317   189.109     0.200
    13.434   191.008     0.200
    13.434   190.789     0.200
    13.467   196.477     0.200
    13.612   194.289     0.200
    13.641   193.488     0.200
    13.942   196.969     0.200
    13.952   196.980     0.200
    14.100   199.668     0.200
    14.124   199.328     0.200
    14.179   199.438     0.200
    14.284   201.250     0.200
    14.492   205.070     0.200
    14.511   205.578     0.200
    14.621   207.461     0.200
    14.621   208.238     0.200
    14.737   209.031     0.200
    14.790   211.570     0.200
    14.805   211.688     0.200
    14.969   213.309     0.200
    14.986   212.500     0.200
    15.016   214.859     0.200
    15.074   212.980     0.200
    15.186   215.309     0.200
    15.207   215.051     0.200
    15.294   217.828     0.200
    15.290   216.320     0.200
    15.329   219.059     0.200
    15.465   220.121     0.200
    15.563   219.871     0.200
    15.612   221.070     0.200
    15.744   222.801     0.200
    15.858   224.020     0.200
    16.405   230.418     0.200
    16.679   235.711     0.200
    16.841   237.199     0.200
    17.068   239.871     0.200
    17.365   242.789     0.200
    18.106   252.059     0.200
    18.420   256.539     0.200
    18.599   259.391     0.200
    18.951   262.180     0.200
    19.186   265.910     0.200
    19.360   268.578     0.200
    19.776   272.180     0.200
    19.888   273.000     0.200
    19.947   273.551     0.200
    20.452   280.031     0.200
    20.585   281.410     0.200
     1.374    23.977     0.200
     1.723    28.648     0.200
     2.029    32.406     0.200
     3.095    46.625     0.200
     4.157    61.195     0.200
     4.394    66.328     0.200
     4.683    69.598     0.200
     5.017    74.188     0.200
     1.455    25.803     0.200
     1.565    26.812     0.200
     1.605    27.932     0.200
     1.605    27.252     0.200
     2.408    38.902     0.200
     2.584    41.883     0.200
     2.584    41.643     0.200
     2.704    42.271     0.200
     3.827    58.652     0.200
     3.880    58.062     0.200
     3.880    57.941     0.200
     3.975    60.852     0.200
     4.078    60.611     0.200
     4.078    60.842     0.200
     4.275    63.502     0.200
     4.335    65.303     0.200
     4.413    66.182     0.200
     4.657    71.402     0.200
     4.657    70.793     0.200
     4.677    69.652     0.200
     4.722    70.861     0.200
     4.848    72.402     0.200
     4.876    73.191     0.200
     4.852    73.691     0.200
     5.022    75.322     0.200
     5.361    80.111     0.200
     5.448    81.172     0.200
     5.845    87.512     0.200
     5.917    88.412     0.200
     6.104    90.293     0.200
     6.178    91.723     0.200
     6.229    92.352     0.200
     6.229    92.072     0.200
     6.544    96.562     0.200
     6.706    99.432     0.200
     6.807   100.502     0.200
     6.807   100.182     0.200
     6.977   102.043     0.200
     7.029   104.043     0.200
     7.197   105.021     0.200
     7.660   112.031     0.200
     7.660   112.213     0.200
     8.307   120.332     0.200
     8.428   123.592     0.200
     8.618   127.332     0.200
     8.771   128.732     0.200
     8.771   129.303     0.200
     8.790   129.293     0.200
     9.020   133.941     0.200
     9.487   138.133     0.200
     9.557   138.832     0.200
     9.703   140.803     0.200
    10.078   145.322     0.200
    10.969   157.592     0.200
    10.969   158.322     0.200
    11.400   164.213     0.200
    11.952   171.002     0.200
    11.952   171.463     0.200
    12.775   184.932     0.200
    14.984   212.592     0.200
    15.004   212.643     0.200
    15.320   216.213     0.200
    15.807   223.623     0.200
    16.028   226.281     0.200
    16.331   230.262     0.200
    16.578   232.982     0.200
     1.303    22.691     0.200
     1.582    26.570     0.200
     1.606    26.949     0.200
     2.584    41.199     0.200
     2.718    41.891     0.200
     3.888    57.531     0.200
     4.285    63.590     0.200
     4.355    65.602     0.200
     4.422    65.941     0.200
     4.662    71.430     0.200
     4.732    71.148     0.200
     5.032    75.750     0.200
     5.935    87.000     0.200
     1.460    25.797     0.200
     1.559    26.586     0.200
     1.599    27.426     0.200
     1.599    27.096     0.200
     1.760    29.037     0.200
     1.830    31.496     0.200
     2.414    38.707     0.200
     2.590    41.717     0.200
     2.590    41.537     0.200
     2.698    42.230     0.200
     2.698    42.396     0.200
     2.698    42.076     0.200
     3.834    59.016     0.200
     3.968    59.576     0.200
     4.072    60.586     0.200
     4.269    63.445     0.200
     4.332    65.176     0.200
     4.406    65.105     0.200
     4.661    71.506     0.200
     4.661    71.707     0.200
     4.683    70.945     0.200
     4.708    71.637     0.200
     4.716    70.467     0.200
     4.841    71.416     0.200
     4.858    73.025     0.200
     5.015    75.037     0.200
     5.057    76.426     0.200
     5.057    76.006     0.200
     5.355    80.096     0.200
     5.442    81.236     0.200
     5.871    87.227     0.200
     5.916    88.186     0.200
     5.968    89.307     0.200
     6.097    89.816     0.200
     6.224    92.287     0.200
     6.229    92.227     0.200
     6.229    92.025     0.200
     6.292    94.436     0.200
     6.292    94.436     0.200
     6.442    96.387     0.200
     6.510    96.326     0.200
     6.537    98.686     0.200
     6.801   101.186     0.200
     6.801   101.506     0.200
     6.801   100.736     0.200
     6.885   101.867     0.200
     6.978   101.887     0.200
     7.035   104.326     0.200
     7.035   103.996     0.200
     7.035   103.816     0.200
     7.213   106.506     0.200
     7.308   107.666     0.200
     7.308   109.525     0.200
     7.308   109.477     0.200
     7.309   109.916     0.200
     7.309   109.596     0.200
     7.376   107.836     0.200
     7.666   111.986     0.200
     7.666   112.537     0.200
     7.687   113.166     0.200
     7.741   114.176     0.200
     8.019   117.445     0.200
     8.133   118.297     0.200
     8.250   120.916     0.200
     8.303   121.146     0.200
     8.371   121.967     0.200
     8.390   124.617     0.200
     8.399   123.746     0.200
     8.412   122.486     0.200
     8.434   123.127     0.200
     8.434   123.377     0.200
     8.469   124.287     0.200
     8.543   123.896     0.200
     8.546   123.506     0.200
     8.621   125.576     0.200
     8.624   127.656     0.200
     8.796   129.006     0.200
     8.952   130.646     0.200
     8.977   130.105     0.200
     9.006   130.807     0.200
     9.185   132.926     0.200
     9.276   132.996     0.200
     9.304   134.355     0.200
     9.396   137.936     0.200
     9.478   140.137     0.200
     9.480   137.916     0.200
     9.478   139.086     0.200
     9.550   140.346     0.200
     9.593   141.945     0.200
     9.642   138.195     0.200
     9.901   145.617     0.200
    10.009   145.996     0.200
    10.057   147.617     0.200
    10.085   146.957     0.200
    10.212   149.957     0.200
    10.272   150.826     0.200
    10.380   152.586     0.200
    10.690   156.850     0.200
    12.416   175.975     0.200
    12.411   173.980     0.200
    13.380   190.656     0.200
    13.519   193.734     0.200
    14.515   205.855     0.200
    15.141   213.877     0.200
    15.180   215.137     0.200
    15.247   214.547     0.200
    15.287   216.445     0.200
    15.296   215.816     0.200
    15.314   218.586     0.200
    15.423   217.426     0.200
    15.513   217.986     0.200
    18.654   261.977     0.200
    19.805   272.387     0.200
    19.911   273.717     0.200
    20.025   275.195     0.200
    20.114   276.486     0.200
    20.425   280.297     0.200
    20.425   278.855     0.200
    20.755   282.176     0.200
     1.454    25.422     0.200
     1.561    26.562     0.200
     1.605    27.633     0.200
     1.605    27.199     0.200
     1.760    29.281     0.200
     2.409    38.840     0.200
     2.584    41.730     0.200
     2.584    41.531     0.200
     2.702    42.137     0.200
     3.829    58.223     0.200
     4.274    63.750     0.200
     4.332    65.832     0.200
     4.411    66.582     0.200
     4.655    69.742     0.200
     4.655    70.812     0.200
     4.655    71.539     0.200
     4.678    69.930     0.200
     4.720    71.141     0.200
     4.853    72.391     0.200
     4.846    72.609     0.200
     5.020    75.672     0.200
     5.359    80.051     0.200
     5.446    80.199     0.200
     5.845    86.090     0.200
     5.914    88.133     0.200
     5.963    87.281     0.200
     6.226    91.801     0.200
     6.226    92.062     0.200
     6.804   101.480     0.200
     9.004   127.812     0.200
     9.065   129.039     0.200
     9.309   132.859     0.200
     9.554   136.332     0.200
     9.597   136.840     0.200
     9.971   141.520     0.200
    10.000   142.500     0.200
    10.080   143.551     0.200
    10.491   149.590     0.200
    10.693   153.305     0.200
    10.878   154.020     0.200
    10.970   156.520     0.200
    11.189   158.250     0.200
    11.742   166.359     0.200
    11.881   168.359     0.200
    12.096   170.801     0.200
    12.100   170.641     0.200
    12.407   173.277     0.200
    13.375   191.109     0.200
    15.117   211.871     0.200
    15.115   211.539     0.200
    16.025   224.441     0.200
    16.275   227.781     0.200
    16.280   226.680     0.200
    16.332   228.133     0.200
    17.955   248.590     0.200
     1.167    21.162     0.200
     1.167    21.023     0.200
     1.344    24.113     0.200
     1.464    26.062     0.200
     2.061    33.123     0.200
     2.205    35.662     0.200
     2.477    39.764     0.200
     2.477    39.514     0.200
     3.155    47.848     0.200
     3.519    53.133     0.200
     3.636    54.584     0.200
     3.728    57.113     0.200
     4.471    67.184     0.200
     4.489    67.863     0.200
     4.550    67.912     0.200
     4.654    69.053     0.200
     4.697    71.594     0.200
     4.697    69.748     0.200
     4.697    72.863     0.200
     4.813    72.363     0.200
     4.844    73.033     0.200
     4.832    72.363     0.200
     5.406    81.674     0.200
     5.928    87.803     0.200
     6.313    94.072     0.200
     6.857   100.412     0.200
     6.857   100.783     0.200
     6.885    99.463     0.200
     7.292   106.992     0.200
     7.292   107.482     0.200
     7.950   116.004     0.200
     8.098   118.982     0.200
     8.293   120.652     0.200
    11.933   167.342     0.200
    12.673   177.773     0.200
    13.070   184.322     0.200
    14.418   201.748     0.200
    18.295   252.271     0.200
     2.878    44.355     0.200
     5.790    87.555     0.200
    10.915   156.074     0.200
    12.335   176.301     0.200
    13.613   192.105     0.200
    13.975   197.828     0.200
    15.505   217.988     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.548    44.508     0.200
     3.270    58.211     0.200
     4.176    74.508     0.200
     3.242    57.918     0.200
     4.084    74.117     0.200
     4.171    74.316     0.200
     3.509    63.777     0.200
     2.651    46.660     0.200
     3.284    60.762     0.200
     4.666    82.773     0.200
     4.778    86.773     0.200
     2.881    50.744     0.200
     2.881    49.719     0.200
     6.082   112.922     0.200
     2.905    51.734     0.200
     4.623    81.094     0.200
     2.585    45.543     0.200
     3.964    71.363     0.200
     4.231    76.504     0.200
     4.732    83.844     0.200
     4.704    84.246     0.200
     7.196   140.543     0.200
     7.646   148.465     0.200
     2.574    44.023     0.200
     2.657    46.814     0.200
     2.764    48.449     0.200
     2.764    47.887     0.200
     5.259    93.555     0.200
     5.663   104.559     0.200
     3.806    71.430     0.200
     2.584    46.926     0.200
     2.905    53.281     0.200
     4.490    80.512     0.200
     2.606    45.487     0.200
     2.615    45.447     0.200
     2.634    45.041     0.200
     2.958    51.617     0.200
     2.704    48.383     0.200
     2.702    47.086     0.200
     2.878    51.082     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.478     9.398     0.200
     0.556    10.297     0.200
     0.735    12.500     0.200
     0.794    14.500     0.200
     0.929    16.602     0.200
     0.946    16.500     0.200
     1.084    18.797     0.200
     1.300    22.797     0.200
     0.484     9.383     0.200
     0.557    10.281     0.200
     0.748    12.383     0.200
     0.810    14.781     0.200
     0.945    16.883     0.200
     0.955    17.078     0.200
     1.089    18.883     0.200
     1.315    22.984     0.200
     0.495     9.305     0.200
     0.532     9.805     0.200
     0.737    12.305     0.200
     0.802    14.305     0.200
     0.771    14.109     0.200
     0.915    16.305     0.200
     0.957    17.008     0.200
     0.484     9.418     0.200
     0.551    10.016     0.200
     0.718    12.918     0.200
     0.741    12.617     0.200
     0.796    14.516     0.200
     0.784    14.316     0.200
     0.933    16.617     0.200
     0.952    17.316     0.200
     1.090    18.918     0.200
     1.300    22.816     0.200
     1.927    34.215     0.200
     0.111     3.234     0.200
     0.308     5.938     0.200
     0.469     8.438     0.200
     0.655    12.141     0.200
     0.643    10.938     0.200
     0.744    13.641     0.200
     0.989    17.141     0.200
     2.080    36.734     0.200
     0.420     7.977     0.200
     0.698    11.875     0.200
     0.759    13.676     0.200
     0.978    16.977     0.200
     1.060    17.977     0.200
     1.123    18.977     0.200
     0.618    11.660     0.200
     0.639    11.262     0.200
     0.727    13.262     0.200
     0.893    15.062     0.200
     0.987    17.160     0.200
     0.252     4.977     0.200
     0.474     8.375     0.200
     0.574    10.977     0.200
     0.662    12.180     0.200
     0.684    11.680     0.200
     0.972    17.375     0.200
     1.230    20.773     0.200
     1.263    21.977     0.200
     3.112    50.773     0.200
     3.405    55.375     0.200
     0.382     7.098     0.200
     0.441     8.197     0.200
     1.216    20.428     0.200
     1.200    21.908     0.200
     0.218     4.809     0.200
     0.757    13.429     0.200
     0.868    15.469     0.200
     0.824    14.169     0.200
     0.972    17.419     0.200
     0.991    17.579     0.200
     0.361     6.793     0.200
     0.586    10.285     0.200
     0.866    15.305     0.200
     1.202    20.594     0.200
     0.219     4.992     0.200
     0.519     9.570     0.200
     0.609    10.875     0.200
     1.211    20.562     0.200
     0.571    10.664     0.200
     0.404     8.023     0.200
     0.866    15.594     0.200
     0.741    13.414     0.200
     0.867    15.496     0.200
     0.905    15.844     0.200
     1.253    22.023     0.200
     2.585    43.266     0.200
     5.696    95.195     0.200
     0.417     8.404     0.200
     0.559    10.804     0.200
     0.751    13.504     0.200
     0.751    13.813     0.200
     0.887    15.944     0.200
     0.887    15.894     0.200
     0.851    15.914     0.200
     0.921    16.214     0.200
     0.921    16.584     0.200
     1.259    22.304     0.200
     0.637    11.365     0.200
     0.383     7.520     0.200
     0.414     7.047     0.200
     0.398     7.488     0.200
     0.398     7.617     0.200
     0.398     6.809     0.200
     0.457     8.398     0.200
     0.395     7.395     0.200
     0.395     7.484     0.200
     0.450     8.387     0.200
     0.595    10.379     0.200
     0.595    10.160     0.200
     0.632    11.309     0.200
     0.597    10.691     0.200
     0.644    11.195     0.200
     0.619    10.469     0.200
     0.661    11.488     0.200
     0.306     5.766     0.200
     0.306     5.797     0.200
     0.323     6.188     0.200
     0.324     6.203     0.200
     0.538     9.578     0.200
     0.986    17.688     0.200
     1.145    20.836     0.200
     2.040    35.734     0.200
     0.350     6.189     0.200
     0.351     6.029     0.200
     0.591    10.848     0.200
     0.591    10.105     0.200
     0.625    11.348     0.200
     0.430     7.965     0.200
     0.430     7.746     0.200
     0.455     8.625     0.200
     0.456     8.516     0.200
     0.615    11.234     0.200
     0.717    12.844     0.200
     1.122    19.164     0.200
     2.150    37.457     0.200
     2.967    50.637     0.200
     0.140     2.949     0.200
     0.357     6.902     0.200
     0.351     6.449     0.200
     0.351     6.293     0.200
     0.410     7.723     0.200
     0.410     7.551     0.200
     0.454     7.941     0.200
     0.611    10.711     0.200
     0.897    15.512     0.200
     0.239     4.429     0.200
     0.239     4.988     0.200
     0.295     5.809     0.200
     0.277     5.738     0.200
     0.278     5.669     0.200
     0.423     7.719     0.200
     0.661    12.188     0.200
     0.817    14.429     0.200
     0.998    17.469     0.200
     1.097    19.509     0.200
     1.103    18.938     0.200
     1.949    34.198     0.200
     0.239     4.850     0.200
     0.357     6.900     0.200
     0.357     6.844     0.200
     0.437     8.061     0.200
     0.528     9.801     0.200
     0.695    12.320     0.200
     0.967    16.689     0.200
     1.142    19.500     0.200
     0.193     4.188     0.200
     0.376     7.277     0.200
     0.376     7.367     0.200
     0.409     7.836     0.200
     0.431     8.559     0.200
     0.432     8.309     0.200
     0.469     8.836     0.200
     0.635    11.285     0.200
     0.910    15.738     0.200
     1.173    20.277     0.200
     0.228     4.669     0.200
     0.228     4.699     0.200
     0.271     5.279     0.200
     0.399     7.509     0.200
     0.643    11.589     0.200
     0.797    13.909     0.200
     1.000    17.369     0.200
     1.085    18.599     0.200
     0.214     4.668     0.200
     0.336     6.559     0.200
     0.510     9.188     0.200
     0.493     9.086     0.200
     1.292    22.398     0.200
     1.296    21.816     0.200
     1.990    34.855     0.200
     0.474     8.551     0.200
     0.659    11.141     0.200
     0.660    11.910     0.200
     0.696    12.418     0.200
     0.734    13.379     0.200
     0.937    16.609     0.200
     0.978    18.262     0.200
     1.318    22.930     0.200
     1.446    25.039     0.200
     0.285     6.172     0.200
     0.690    12.586     0.200
     0.759    13.930     0.200
     0.794    14.141     0.200
     0.847    15.227     0.200
     0.919    16.289     0.200
     0.938    16.125     0.200
     0.977    17.102     0.200
     0.989    17.852     0.200
     1.151    20.266     0.200
     1.301    22.898     0.200
     1.482    25.828     0.200
     0.197     4.852     0.200
     0.350     6.453     0.200
     0.480     8.152     0.200
     0.813    14.641     0.200
     0.898    16.320     0.200
     1.277    21.691     0.200
     0.314     6.203     0.200
     0.271     5.414     0.200
     0.271     5.574     0.200
     0.271     5.473     0.200
     0.454     8.375     0.200
     0.454     8.562     0.200
     0.663    12.352     0.200
     1.104    18.781     0.200
     1.020    18.094     0.200
     1.326    21.914     0.200
     1.329    22.434     0.200
     1.698    29.613     0.200
     1.844    32.344     0.200
     0.238     4.871     0.200
     0.644    11.023     0.200
     1.005    18.090     0.200
     1.093    19.500     0.200
     1.249    21.820     0.200
     0.225     4.195     0.200
     0.334     5.570     0.200
     0.514     8.648     0.200
     0.735    12.891     0.200
     1.012    18.227     0.200
     1.125    20.367     0.200
     1.436    24.336     0.200
     2.227    37.586     0.200
     2.406    43.461     0.200
     2.491    43.688     0.200
     2.496    44.008     0.200
     0.242     5.257     0.200
     0.242     5.207     0.200
     0.242     5.268     0.200
     0.422     8.107     0.200
     0.655    12.138     0.200
     0.655    12.138     0.200
     0.745    13.697     0.200
     1.003    17.357     0.200
     1.294    21.558     0.200
     1.811    31.268     0.200
     2.121    36.237     0.200
     0.382     7.188     0.200
     0.518     9.633     0.200
     0.625    11.039     0.200
     0.696    12.953     0.200
     0.835    14.703     0.200
     1.408    24.812     0.200
     0.201     4.561     0.200
     0.389     7.491     0.200
     0.466     8.851     0.200
     0.656    12.131     0.200
     1.218    20.521     0.200
     1.327    22.571     0.200
     0.198     4.309     0.200
     0.198     4.449     0.200
     0.198     4.518     0.200
     0.385     7.369     0.200
     0.461     8.998     0.200
     0.461     8.758     0.200
     0.655    12.008     0.200
     0.893    15.598     0.200
     0.772    13.898     0.200
     1.214    20.238     0.200
     1.322    21.879     0.200
     0.219     4.969     0.200
     0.219     4.602     0.200
     0.219     4.859     0.200
     0.219     4.859     0.200
     0.394     7.641     0.200
     0.479     9.211     0.200
     1.217    20.266     0.200
     0.303     6.621     0.200
     0.465     8.699     0.200
     0.711    12.949     0.200
     0.712    12.570     0.200
     0.712    13.590     0.200
     0.712    13.098     0.200
     0.737    13.258     0.200
     0.861    15.340     0.200
     1.045    18.988     0.200
     0.138     3.227     0.200
     0.320     6.105     0.200
     0.298     6.098     0.200
     0.642    11.598     0.200
     0.753    13.648     0.200
     0.929    16.566     0.200
     1.126    19.566     0.200
     0.284     6.123     0.200
     0.568    10.611     0.200
     0.691    12.752     0.200
     0.765    13.902     0.200
     0.796    13.982     0.200
     0.796    14.092     0.200
     0.853    15.111     0.200
     0.915    16.451     0.200
     0.915    16.771     0.200
     0.995    17.723     0.200
     1.306    23.012     0.200
     1.481    25.463     0.200
     1.605    28.553     0.200
     1.824    32.582     0.200
     0.269     5.820     0.200
     0.549    10.270     0.200
     0.706    12.520     0.200
     0.757    13.711     0.200
     0.777    13.832     0.200
     0.839    14.840     0.200
     0.932    16.520     0.200
     0.987    17.531     0.200
     1.500    26.180     0.200
     0.291     5.957     0.200
     0.685    13.057     0.200
     0.685    12.707     0.200
     0.761    13.836     0.200
     0.761    14.006     0.200
     0.852    15.297     0.200
     0.852    15.006     0.200
     0.852    15.137     0.200
     0.852    15.186     0.200
     0.913    16.826     0.200
     0.913    16.506     0.200
     0.992    17.695     0.200
     1.476    25.426     0.200
     0.287     6.012     0.200
     0.688    12.652     0.200
     0.766    14.020     0.200
     0.855    15.312     0.200
     0.855    15.172     0.200
     0.856    15.172     0.200
     0.911    16.262     0.200
     0.911    16.520     0.200
     0.997    17.961     0.200
     1.478    25.500     0.200
     1.825    31.590     0.200
     0.294     5.623     0.200
     0.258     6.174     0.200
     0.748    13.363     0.200
     0.748    13.174     0.200
     0.748    13.293     0.200
     0.749    13.203     0.200
     0.854    15.434     0.200
     1.034    18.354     0.200
     1.344    23.334     0.200
     0.367     6.844     0.200
     0.367     6.879     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     7.195   186.703     0.200
     1.271    39.711     0.200
     0.978    30.977     0.200
     4.309   114.777     0.200
     6.042   155.074     0.200
     4.104   108.562     0.200
     7.080   181.910     0.200
     7.080   183.160     0.200
     2.657    72.502     0.200
     3.712    95.248     0.200
     3.909   103.557     0.200
     4.483   118.088     0.200
     5.179   134.098     0.200
     4.058   108.125     0.200
     4.224   107.914     0.200
     1.253    39.105     0.200
     2.585    71.152     0.200
     4.704   126.523     0.200
     6.278   161.453     0.200
     7.116   182.543     0.200
     1.259    39.494     0.200
     1.935    56.034     0.200
     2.574    72.444     0.200
     6.058   160.594     0.200
     3.805   101.023     0.200
    12.994   325.965     0.200
     1.200    37.027     0.200
     3.389    87.477     0.200
     3.692    94.309     0.200
     3.831    97.637     0.200
     3.889   100.758     0.200
     4.010   104.887     0.200
     4.093   105.379     0.200
     4.590   121.316     0.200
     5.159   132.578     0.200
     5.365   138.988     0.200
     5.428   140.477     0.200
    12.113   309.348     0.200
     2.455    66.875     0.200
     2.455    67.363     0.200
     2.697    75.574     0.200
     2.706    70.641     0.200
     3.618    97.605     0.200
     5.802   150.719     0.200
     7.085   185.074     0.200
    11.059   283.266     0.200
    11.355   288.875     0.200
    11.894   302.785     0.200
    12.080   306.754     0.200
    12.503   308.734     0.200
    12.539   317.395     0.200
    12.592   319.117     0.200
    12.623   318.938     0.200
    13.553   334.312     0.200
    13.749   347.047     0.200
    14.177   357.566     0.200
    15.560   385.941     0.200
     2.896    75.406     0.200
     3.798   101.730     0.200
     0.986    31.609     0.200
     2.975    78.398     0.200
     3.463    94.336     0.200
     4.037   106.133     0.200
     4.173   106.703     0.200
     4.225   112.180     0.200
     4.353   113.516     0.200
     4.439   117.383     0.200
     4.340   117.414     0.200
     4.725   124.438     0.200
     5.505   143.398     0.200
     5.389   142.836     0.200
     6.651   176.414     0.200
     6.835   181.812     0.200
    12.213   303.281     0.200
     2.653    73.730     0.200
     2.697    75.580     0.200
     2.921    75.898     0.200
     1.280    41.277     0.200
     1.485    43.754     0.200
     3.665    97.695     0.200
     1.154    35.691     0.200
     1.168    37.070     0.200
     3.730    98.152     0.200
     4.049   109.711     0.200
     4.131   109.289     0.200
     5.196   135.852     0.200
     5.737   151.371     0.200
     7.991   203.430     0.200
     2.858    75.464     0.200
     2.858    75.249     0.200
     3.452    93.278     0.200
     3.618    96.459     0.200
     3.937   101.499     0.200
     4.078   104.908     0.200
     4.337   112.079     0.200
     4.375   118.049     0.200
     4.826   125.219     0.200
     5.338   139.358     0.200
     5.402   139.438     0.200
     5.610   146.669     0.200
     5.663   152.789     0.200
     5.663   146.639     0.200
     5.674   148.679     0.200
     2.759    76.391     0.200
     2.759    73.029     0.200
     3.498    89.770     0.200
     3.942   101.180     0.200
     3.996   104.379     0.200
     4.208   107.879     0.200
     4.699   123.920     0.200
     5.275   136.090     0.200
     5.480   143.240     0.200
     5.776   152.314     0.200
     7.942   202.590     0.200
     8.437   216.721     0.200
     2.698    72.383     0.200
     2.698    71.707     0.200
     3.472    92.086     0.200
     3.747    96.266     0.200
     3.885   102.938     0.200
     4.149   107.617     0.200
     5.216   134.695     0.200
     5.779   151.531     0.200
     6.237   155.988     0.200
     7.967   201.328     0.200
     1.929    54.179     0.200
     2.835    75.254     0.200
     3.618    93.419     0.200
     3.918   101.339     0.200
     5.382   137.549     0.200
     5.654   149.079     0.200
     5.654   147.039     0.200
     7.801   198.749     0.200
     8.473   216.179     0.200
     9.315   235.759     0.200
     9.578   242.279     0.200
     9.664   241.479     0.200
     9.819   246.189     0.200
     2.584    69.398     0.200
     2.584    68.875     0.200
     2.584    70.367     0.200
     3.305    85.277     0.200
     3.613    92.945     0.200
     3.803   100.227     0.200
     3.929   104.617     0.200
     4.016   104.766     0.200
     5.016   129.207     0.200
     5.083   130.648     0.200
     5.347   140.625     0.200
     5.855   154.273     0.200
     9.562   242.598     0.200
     9.629   241.207     0.200
     9.896   248.098     0.200
     9.980   252.348     0.200
    10.136   256.719     0.200
     1.681    50.461     0.200
     1.802    53.469     0.200
     2.088    60.141     0.200
     2.349    66.219     0.200
     2.967    81.191     0.200
     1.301    40.922     0.200
     1.482    45.367     0.200
     1.277    38.953     0.200
     1.611    47.402     0.200
     1.943    55.723     0.200
     2.194    60.973     0.200
     2.203    61.711     0.200
     3.145    83.750     0.200
     2.537    70.402     0.200
     2.873    75.727     0.200
     2.873    75.492     0.200
     3.181    87.133     0.200
     3.479    93.820     0.200
     3.636    93.395     0.200
     4.080   104.723     0.200
     4.259   108.402     0.200
     4.711   122.684     0.200
     4.659   123.375     0.200
     5.047   132.434     0.200
     5.047   135.438     0.200
     5.408   140.172     0.200
     5.439   140.789     0.200
     7.279   187.340     0.200
     1.529    45.590     0.200
     1.312    41.719     0.200
     1.436    45.758     0.200
     1.466    46.117     0.200
     2.227    63.500     0.200
     2.213    63.211     0.200
     2.491    69.758     0.200
     3.286    91.344     0.200
     1.100    35.087     0.200
     2.854    75.824     0.200
     2.854    75.357     0.200
     3.456    91.567     0.200
     3.931   101.327     0.200
     4.072   106.207     0.200
     4.250   110.487     0.200
     5.021   132.518     0.200
     5.397   139.447     0.200
     5.667   151.313     0.200
     1.826    53.547     0.200
     2.380    68.180     0.200
     2.887    82.078     0.200
     3.665   101.227     0.200
     4.383   119.031     0.200
     1.218    37.480     0.200
     2.576    68.411     0.200
     2.952    79.236     0.200
     2.952    79.071     0.200
     3.361    89.371     0.200
     4.049   104.391     0.200
     4.192   107.061     0.200
     1.322    38.848     0.200
     2.571    67.438     0.200
     2.948    77.129     0.200
     3.361    86.908     0.200
     4.045   103.898     0.200
     4.188   107.428     0.200
     5.190   131.988     0.200
     5.328   133.838     0.200
     5.508   138.748     0.200
    12.208   303.613     0.200
    13.457   334.549     0.200
     1.217    36.742     0.200
     1.216    36.680     0.200
     3.377    90.281     0.200
     3.749    97.305     0.200
     4.250   109.195     0.200
     4.622   117.953     0.200
     4.953   127.469     0.200
     4.937   125.719     0.200
     4.944   126.141     0.200
     5.513   139.969     0.200
     6.430   163.281     0.200
     7.452   186.219     0.200
     7.936   199.344     0.200
     8.178   201.305     0.200
     8.733   216.930     0.200
     8.744   215.195     0.200
     8.991   223.312     0.200
     9.127   224.531     0.200
     9.459   235.266     0.200
     9.544   236.641     0.200
     9.700   238.695     0.200
     1.548    45.211     0.200
     3.834   102.578     0.200
     4.047   110.590     0.200
     4.366   118.211     0.200
     4.684   125.461     0.200
     4.394   116.738     0.200
     1.455    44.723     0.200
     1.565    47.172     0.200
     2.408    68.742     0.200
     2.584    72.652     0.200
     2.704    74.473     0.200
     3.880   103.133     0.200
     4.078   108.803     0.200
     4.275   113.361     0.200
     4.413   117.873     0.200
     4.657   125.021     0.200
     4.848   127.723     0.200
     5.022   131.592     0.200
     5.917   153.531     0.200
     6.104   158.223     0.200
     2.584    73.441     0.200
     4.089   108.461     0.200
     4.422   117.949     0.200
     1.460    44.896     0.200
     1.454    44.930     0.200
     1.478    45.332     0.200
     1.167    36.764     0.200
     1.167    36.402     0.200
     1.344    41.123     0.200
     3.155    82.873     0.200
     4.471   116.973     0.200
     4.654   122.572     0.200
     4.697   123.373     0.200
     4.844   127.844     0.200
     5.406   141.713     0.200
     6.857   174.322     0.200
     7.950   203.213     0.200
     8.293   212.643     0.200
     2.878    77.156     0.200
     5.790   150.777     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.556    17.797     0.200
     0.557    17.781     0.200
     0.495    16.609     0.200
     0.532    17.508     0.200
     0.957    31.305     0.200
     1.103    34.508     0.200
     1.898    58.305     0.200
     0.551    17.516     0.200
     0.784    24.316     0.200
     0.952    30.715     0.200
     1.300    40.316     0.200
     0.308     9.938     0.200
     0.989    30.641     0.200
     2.080    64.141     0.200
     0.420    14.574     0.200
     0.494    16.176     0.200
     0.759    24.176     0.200
     1.060    32.477     0.200
     0.662    20.977     0.200
     0.684    20.180     0.200
     0.972    31.477     0.200
     1.230    37.977     0.200
     0.382    12.396     0.200
     0.441    14.207     0.200
     1.216    36.838     0.200
     1.184    37.047     0.200
     1.492    45.277     0.200
     2.657    78.602     0.200
     0.218     9.278     0.200
     0.757    23.959     0.200
     0.868    27.349     0.200
     0.824    25.269     0.200
     0.972    30.269     0.200
     0.991    31.389     0.200
     1.527    47.159     0.200
     2.881    86.068     0.200
     4.280   124.818     0.200
     5.064   146.318     0.200
     0.586    19.203     0.200
     0.866    27.484     0.200
     1.202    36.242     0.200
     2.467    74.172     0.200
     0.219     9.562     0.200
     0.519    16.867     0.200
     0.609    19.797     0.200
     0.663    20.781     0.200
     0.926    28.711     0.200
     1.211    36.156     0.200
     3.998   115.344     0.200
     4.224   123.234     0.200
     4.564   132.547     0.200
     4.623   134.766     0.200
     0.404    14.203     0.200
     0.866    26.594     0.200
     0.741    23.473     0.200
     0.867    27.543     0.200
     0.905    28.066     0.200
     4.757   142.434     0.200
     5.696   171.555     0.200
     6.529   196.746     0.200
     0.417    14.574     0.200
     0.559    18.304     0.200
     0.751    23.754     0.200
     0.751    23.974     0.200
     0.887    27.554     0.200
     0.887    27.134     0.200
     0.887    27.134     0.200
     0.851    26.954     0.200
     0.921    29.554     0.200
     1.259    39.044     0.200
     0.637    20.457     0.200
     0.383    13.258     0.200
     0.414    12.566     0.200
     0.398    13.488     0.200
     0.398    12.629     0.200
     0.457    14.547     0.200
     0.630    19.641     0.200
     0.630    19.492     0.200
     0.691    21.492     0.200
     0.395    12.945     0.200
     0.395    13.055     0.200
     0.450    14.676     0.200
     2.706    79.215     0.200
     0.595    18.301     0.200
     0.595    18.180     0.200
     0.632    20.070     0.200
     0.597    19.465     0.200
     0.644    19.973     0.200
     0.619    19.719     0.200
     0.661    21.289     0.200
     0.306     9.875     0.200
     0.306     9.992     0.200
     0.323    10.859     0.200
     0.324    10.594     0.200
     0.538    16.656     0.200
     0.759    24.430     0.200
     2.040    60.586     0.200
     2.507    73.680     0.200
     2.975    87.953     0.200
     0.350    11.299     0.200
     0.351    10.740     0.200
     0.591    18.688     0.200
     0.625    20.367     0.200
     0.430    13.277     0.200
     0.430    14.137     0.200
     0.455    15.086     0.200
     0.456    14.477     0.200
     0.615    19.324     0.200
     0.717    23.234     0.200
     1.122    33.445     0.200
     2.150    64.586     0.200
     2.967    87.004     0.200
     2.967    88.277     0.200
     0.357    12.262     0.200
     0.351    11.250     0.200
     0.351    11.402     0.200
     0.410    13.281     0.200
     0.410    13.062     0.200
     0.454    14.199     0.200
     0.611    18.949     0.200
     0.897    27.180     0.200
     1.919    58.770     0.200
     2.664    78.742     0.200
     0.239     7.988     0.200
     0.239     8.479     0.200
     0.295     9.948     0.200
     0.277     9.309     0.200
     0.278     9.158     0.200
     0.423    12.869     0.200
     0.661    21.049     0.200
     0.817    25.089     0.200
     0.998    30.049     0.200
     1.103    33.249     0.200
     1.949    58.528     0.200
     2.858    84.669     0.200
     0.239     8.551     0.200
     0.357    11.699     0.200
     0.357    11.945     0.200
     0.437    14.189     0.200
     0.528    16.891     0.200
     0.695    21.459     0.200
     0.967    29.910     0.200
     1.142    34.879     0.200
     1.997    59.189     0.200
     2.759    81.830     0.200
     3.806   113.109     0.200
     0.193     7.285     0.200
     0.376    12.285     0.200
     0.376    12.277     0.200
     0.409    13.059     0.200
     0.431    14.168     0.200
     0.432    14.137     0.200
     0.635    19.367     0.200
     0.910    28.008     0.200
     1.971    59.707     0.200
     2.698    80.238     0.200
     0.228     8.339     0.200
     0.228     8.089     0.200
     0.271     9.779     0.200
     0.399    13.119     0.200
     0.797    25.079     0.200
     1.085    32.809     0.200
     0.214     8.035     0.200
     0.336    11.227     0.200
     0.510    15.656     0.200
     0.493    15.598     0.200
     0.493    15.738     0.200
     1.296    38.828     0.200
     1.990    59.926     0.200
     0.474    14.180     0.200
     0.659    19.449     0.200
     0.660    20.699     0.200
     0.696    21.551     0.200
     0.734    23.160     0.200
     0.937    29.059     0.200
     0.978    31.129     0.200
     1.210    38.059     0.200
     1.318    41.180     0.200
     1.301    40.359     0.200
     1.446    44.820     0.200
     0.690    23.258     0.200
     0.759    24.031     0.200
     0.847    26.070     0.200
     0.919    28.391     0.200
     0.977    29.930     0.200
     0.989    30.625     0.200
     1.151    35.500     0.200
     1.600    48.938     0.200
     2.046    61.750     0.200
     0.197     7.691     0.200
     0.350    10.980     0.200
     0.813    25.512     0.200
     0.898    28.320     0.200
     1.087    33.812     0.200
     1.145    35.250     0.200
     1.428    43.152     0.200
     1.483    44.633     0.200
     1.857    55.973     0.200
     0.314    10.773     0.200
     0.271     9.453     0.200
     0.271     9.352     0.200
     0.454    14.762     0.200
     1.104    33.164     0.200
     1.020    31.992     0.200
     1.329    38.973     0.200
     1.698    51.383     0.200
     1.844    55.531     0.200
     1.983    60.273     0.200
     2.457    71.391     0.200
     0.238     8.293     0.200
     0.644    19.461     0.200
     1.005    31.621     0.200
     1.093    34.062     0.200
     1.091    33.602     0.200
     1.249    38.801     0.200
     1.529    47.633     0.200
     1.682    51.070     0.200
     1.682    51.293     0.200
     1.907    58.543     0.200
     1.962    60.570     0.200
     1.976    61.691     0.200
     2.185    66.543     0.200
     2.397    73.820     0.200
     0.514    14.938     0.200
     0.735    22.555     0.200
     1.125    36.406     0.200
     1.412    43.484     0.200
     1.412    44.000     0.200
     0.242     8.297     0.200
     0.242     8.438     0.200
     0.242     8.499     0.200
     0.422    13.417     0.200
     0.655    21.257     0.200
     0.655    20.417     0.200
     0.745    23.257     0.200
     1.003    30.917     0.200
     1.811    54.537     0.200
     1.811    54.098     0.200
     2.121    63.327     0.200
     2.430    72.917     0.200
     2.854    85.066     0.200
     0.518    16.961     0.200
     0.625    19.312     0.200
     0.696    21.930     0.200
     0.835    25.789     0.200
     1.017    32.422     0.200
     1.033    32.992     0.200
     1.408    43.242     0.200
     1.940    58.289     0.200
     0.201     8.071     0.200
     0.389    13.241     0.200
     0.466    15.601     0.200
     0.656    21.331     0.200
     0.775    24.491     0.200
     0.893    27.631     0.200
     1.327    40.441     0.200
     1.831    55.881     0.200
     1.937    59.121     0.200
     2.178    65.980     0.200
     0.198     8.568     0.200
     0.385    12.928     0.200
     0.461    15.889     0.200
     0.655    20.799     0.200
     0.893    27.369     0.200
     0.772    24.488     0.200
     1.214    35.709     0.200
     1.827    55.588     0.200
     1.933    58.979     0.200
     2.173    66.049     0.200
     0.219     8.492     0.200
     0.219     8.445     0.200
     0.219     8.336     0.200
     0.394    13.500     0.200
     0.479    16.070     0.200
     0.479    16.172     0.200
     0.774    24.984     0.200
     0.906    28.734     0.200
     0.906    28.391     0.200
     1.341    41.898     0.200
     1.341    40.664     0.200
     1.847    56.055     0.200
     1.954    59.539     0.200
     2.190    65.594     0.200
     2.426    69.789     0.200
     0.465    15.520     0.200
     0.711    23.160     0.200
     0.712    21.961     0.200
     0.712    22.121     0.200
     0.712    21.258     0.200
     0.712    20.988     0.200
     1.045    32.438     0.200
     1.045    32.969     0.200
     1.188    37.281     0.200
     1.508    46.609     0.200
     1.508    45.781     0.200
     1.571    47.879     0.200
     2.489    75.910     0.200
     0.138     5.867     0.200
     0.320    11.086     0.200
     0.298    10.996     0.200
     0.753    24.137     0.200
     1.126    34.496     0.200
     1.334    41.605     0.200
     1.374    41.488     0.200
     1.723    52.008     0.200
     1.965    58.316     0.200
     0.284     9.662     0.200
     0.568    18.303     0.200
     0.691    22.002     0.200
     0.765    24.012     0.200
     0.765    23.623     0.200
     0.796    24.973     0.200
     0.853    26.422     0.200
     0.853    26.053     0.200
     0.915    29.342     0.200
     0.915    28.963     0.200
     0.995    31.031     0.200
     1.306    40.951     0.200
     1.481    45.062     0.200
     1.605    48.982     0.200
     1.605    48.793     0.200
     1.824    55.252     0.200
     0.549    17.879     0.200
     0.706    22.320     0.200
     0.757    24.719     0.200
     0.777    24.219     0.200
     0.839    26.250     0.200
     0.932    28.949     0.200
     1.303    39.711     0.200
     1.500    45.449     0.200
     1.582    47.449     0.200
     1.606    48.492     0.200
     0.685    21.906     0.200
     0.761    23.367     0.200
     0.761    24.566     0.200
     0.852    26.877     0.200
     0.852    26.926     0.200
     0.913    28.826     0.200
     1.599    49.387     0.200
     1.599    48.867     0.200
     1.830    55.016     0.200
     5.442   163.877     0.200
     0.287    11.141     0.200
     0.688    22.262     0.200
     0.766    24.320     0.200
     0.766    24.000     0.200
     0.855    26.320     0.200
     0.855    26.602     0.200
     0.855    26.520     0.200
     0.856    26.609     0.200
     0.911    28.539     0.200
     0.911    28.652     0.200
     0.997    30.902     0.200
     1.561    48.312     0.200
     1.605    49.262     0.200
     1.605    48.883     0.200
     1.760    54.371     0.200
     0.294     9.703     0.200
     0.748    23.143     0.200
     0.748    23.312     0.200
     0.748    23.764     0.200
     0.749    24.043     0.200
     0.854    26.912     0.200
     0.854    26.684     0.200
     1.034    32.273     0.200
     1.464    45.152     0.200
     0.367    10.363     0.200
     0.367    10.363     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     7.188   218.203     0.200
     7.195   224.500     0.200
    17.119   528.000     0.200
     3.924   120.578     0.200
     2.548    77.805     0.200
     3.270   100.805     0.200
     4.113   128.008     0.200
     4.176   128.109     0.200
     2.567    78.316     0.200
     3.242   100.816     0.200
     4.171   127.316     0.200
     4.644   145.516     0.200
     4.771   146.016     0.200
     5.239   160.316     0.200
     7.198   228.918     0.200
     4.069   126.641     0.200
     7.043   219.938     0.200
     3.509   105.676     0.200
     4.309   134.277     0.200
     4.473   136.176     0.200
     6.042   192.574     0.200
     6.299   198.375     0.200
     2.651    79.730     0.200
     2.651    81.461     0.200
     3.883   117.863     0.200
     4.104   127.062     0.200
     4.694   145.230     0.200
     5.825   179.262     0.200
     6.057   192.262     0.200
     6.177   186.531     0.200
     7.260   220.113     0.200
    13.428   427.062     0.200
    18.263   575.160     0.200
    21.160   665.363     0.200
     2.948    90.297     0.200
     4.154   129.977     0.200
     4.666   143.578     0.200
     4.778   152.375     0.200
     6.170   191.773     0.200
     6.269   195.477     0.200
     7.022   218.328     0.200
     7.022   217.680     0.200
    12.719   401.477     0.200
     5.768   177.377     0.200
     6.763   209.977     0.200
    13.502   423.037     0.200
    15.539   490.053     0.200
     2.881    88.019     0.200
     4.445   136.630     0.200
     3.530   112.645     0.200
     4.428   134.684     0.200
     5.503   175.664     0.200
     6.640   208.543     0.200
     8.226   258.883     0.200
     2.905    89.164     0.200
     2.585    78.293     0.200
     2.585    78.543     0.200
     4.231   130.895     0.200
     4.307   136.105     0.200
     4.732   143.773     0.200
     4.704   145.871     0.200
     4.704   145.445     0.200
     5.330   160.543     0.200
     5.811   179.816     0.200
     5.987   182.793     0.200
     6.133   187.523     0.200
     6.313   191.566     0.200
     6.401   193.465     0.200
     6.278   193.395     0.200
     6.586   199.145     0.200
     6.688   203.445     0.200
     6.712   208.293     0.200
     7.065   215.223     0.200
     7.196   219.645     0.200
     7.116   218.566     0.200
     7.646   235.996     0.200
     7.759   247.605     0.200
     8.038   255.234     0.200
     8.183   252.754     0.200
     8.539   266.496     0.200
     8.625   265.094     0.200
    10.577   327.043     0.200
    10.786   338.125     0.200
    11.063   347.996     0.200
    11.916   373.613     0.200
    12.434   393.445     0.200
     2.574    78.404     0.200
     4.697   146.104     0.200
     6.058   189.604     0.200
     7.327   230.884     0.200
    10.564   326.379     0.200
    12.384   389.854     0.200
     2.657    80.844     0.200
     2.885    88.354     0.200
     3.805   117.373     0.200
     2.638    78.789     0.200
     4.982   152.520     0.200
     5.026   152.418     0.200
     5.776   179.156     0.200
     6.755   209.309     0.200
     6.777   210.758     0.200
     3.618   111.305     0.200
     5.802   176.090     0.200
    13.553   419.762     0.200
    14.093   444.812     0.200
     6.019   186.180     0.200
    13.823   431.879     0.200
     6.045   188.500     0.200
     5.259   162.633     0.200
     5.283   162.492     0.200
     5.698   174.836     0.200
     5.698   175.789     0.200
    11.022   341.352     0.200
    13.568   424.094     0.200
    13.840   436.531     0.200
    15.390   483.883     0.200
     5.751   178.074     0.200
    10.740   331.830     0.200
     3.744   115.695     0.200
     3.871   116.730     0.200
     5.025   155.051     0.200
     5.196   158.402     0.200
     5.737   175.941     0.200
     5.905   182.340     0.200
     6.562   200.902     0.200
     6.746   209.039     0.200
     7.941   246.359     0.200
     7.991   250.191     0.200
     2.514    76.608     0.200
     3.452   108.839     0.200
     5.143   156.889     0.200
     5.663   174.028     0.200
     5.755   180.769     0.200
     7.801   243.568     0.200
    13.490   424.884     0.200
     2.759    82.482     0.200
     3.582   110.930     0.200
     5.125   155.051     0.200
     5.776   178.840     0.200
     5.776   177.400     0.200
     6.731   210.770     0.200
     7.942   244.100     0.200
     8.066   245.619     0.200
     8.844   274.160     0.200
     9.021   276.930     0.200
     9.461   290.551     0.200
    10.427   319.609     0.200
    10.606   325.230     0.200
    11.806   366.410     0.200
    12.311   381.811     0.200
    13.552   421.547     0.200
    15.522   489.016     0.200
    22.765   715.324     0.200
     2.698    81.480     0.200
     5.779   181.281     0.200
     2.835    84.779     0.200
     5.654   170.229     0.200
    10.886   335.081     0.200
    13.472   420.174     0.200
     2.584    77.273     0.200
     2.584    77.047     0.200
     3.368   102.227     0.200
     4.952   150.406     0.200
     5.026   154.867     0.200
     5.855   178.348     0.200
     6.045   186.598     0.200
     6.541   206.027     0.200
     7.284   226.828     0.200
     7.407   228.148     0.200
     8.080   250.336     0.200
     8.372   259.586     0.200
     8.503   263.477     0.200
     8.610   273.516     0.200
     8.899   278.488     0.200
     8.885   272.105     0.200
    10.614   326.090     0.200
    13.549   425.895     0.200
     2.703    82.250     0.200
     4.338   131.422     0.200
     4.611   141.641     0.200
     3.972   124.633     0.200
     2.638    79.852     0.200
     2.648    80.352     0.200
     2.873    86.555     0.200
     4.268   130.582     0.200
     4.268   131.215     0.200
     5.173   158.473     0.200
     5.188   158.602     0.200
     5.694   174.953     0.200
     5.694   174.344     0.200
     5.694   171.953     0.200
    13.524   426.348     0.200
     2.905    89.180     0.200
     3.103    94.402     0.200
     3.701   115.621     0.200
     4.334   134.953     0.200
     4.490   138.461     0.200
     2.505    74.978     0.200
     2.854    86.457     0.200
     5.158   155.787     0.200
     5.157   156.617     0.200
     6.501   199.827     0.200
    10.904   335.299     0.200
    15.392   483.389     0.200
     4.383   135.820     0.200
     4.486   137.891     0.200
     5.122   159.391     0.200
     2.576    78.241     0.200
     2.634    79.951     0.200
     2.641    80.831     0.200
     2.952    90.261     0.200
     3.256   100.011     0.200
     3.361   105.371     0.200
     4.169   128.091     0.200
    13.460   423.841     0.200
     2.571    77.979     0.200
     2.630    79.588     0.200
     2.637    80.459     0.200
     2.948    90.188     0.200
     5.190   160.369     0.200
    11.004   342.438     0.200
    13.457   419.443     0.200
    13.775   433.820     0.200
    15.291   481.094     0.200
     2.587    77.203     0.200
     2.649    79.266     0.200
     2.958    89.414     0.200
     2.958    89.016     0.200
     4.187   128.266     0.200
     5.209   159.398     0.200
     5.607   175.320     0.200
     5.607   172.930     0.200
     5.923   184.531     0.200
     6.862   212.734     0.200
     6.937   215.320     0.200
     7.172   221.875     0.200
     7.167   222.539     0.200
     7.283   225.836     0.200
     2.704    83.801     0.200
     4.438   135.648     0.200
     4.784   146.891     0.200
     5.133   156.500     0.200
     5.433   164.680     0.200
     6.252   190.531     0.200
     6.466   195.461     0.200
     6.752   210.469     0.200
    12.551   392.797     0.200
    14.621   456.859     0.200
     4.798   147.926     0.200
     4.826   146.277     0.200
     2.704    82.873     0.200
     2.698    81.707     0.200
     2.698    82.377     0.200
     4.332   132.297     0.200
     4.661   144.256     0.200
     6.292   190.426     0.200
    10.690   328.023     0.200
    17.131   537.230     0.200
    22.108   689.805     0.200
     2.702    81.086     0.200
     4.655   142.336     0.200
    12.407   382.230     0.200
     3.155    95.049     0.200
     2.878    87.406     0.200
     5.790   175.605     0.200
    10.915   333.824     0.200
    13.613   425.281     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.556    17.797     0.200
     0.557    17.781     0.200
     0.495    16.609     0.200
     0.532    17.508     0.200
     0.957    31.305     0.200
     1.103    34.508     0.200
     1.898    58.305     0.200
     0.551    17.516     0.200
     0.784    24.316     0.200
     0.952    30.715     0.200
     1.300    40.316     0.200
     0.308     9.938     0.200
     0.989    30.641     0.200
     2.080    64.141     0.200
     0.420    14.574     0.200
     0.494    16.176     0.200
     0.759    24.176     0.200
     1.060    32.477     0.200
     0.662    20.977     0.200
     0.684    20.180     0.200
     0.972    31.477     0.200
     1.230    37.977     0.200
     0.382    12.396     0.200
     0.441    14.207     0.200
     1.216    36.838     0.200
     1.184    37.047     0.200
     1.492    45.277     0.200
     2.657    78.602     0.200
     0.218     9.278     0.200
     0.757    23.959     0.200
     0.868    27.349     0.200
     0.824    25.269     0.200
     0.972    30.269     0.200
     0.991    31.389     0.200
     1.527    47.159     0.200
     2.881    86.068     0.200
     4.280   124.818     0.200
     5.064   146.318     0.200
     0.586    19.203     0.200
     0.866    27.484     0.200
     1.202    36.242     0.200
     2.467    74.172     0.200
     0.219     9.562     0.200
     0.519    16.867     0.200
     0.609    19.797     0.200
     0.663    20.781     0.200
     0.926    28.711     0.200
     1.211    36.156     0.200
     3.998   115.344     0.200
     4.224   123.234     0.200
     4.564   132.547     0.200
     4.623   134.766     0.200
     0.404    14.203     0.200
     0.866    26.594     0.200
     0.741    23.473     0.200
     0.867    27.543     0.200
     0.905    28.066     0.200
     4.757   142.434     0.200
     5.696   171.555     0.200
     6.529   196.746     0.200
     0.417    14.574     0.200
     0.559    18.304     0.200
     0.751    23.754     0.200
     0.751    23.974     0.200
     0.887    27.554     0.200
     0.887    27.134     0.200
     0.887    27.134     0.200
     0.851    26.954     0.200
     0.921    29.554     0.200
     1.259    39.044     0.200
     0.637    20.457     0.200
     0.383    13.258     0.200
     0.414    12.566     0.200
     0.398    13.488     0.200
     0.398    12.629     0.200
     0.457    14.547     0.200
     0.630    19.641     0.200
     0.630    19.492     0.200
     0.691    21.492     0.200
     0.395    12.945     0.200
     0.395    13.055     0.200
     0.450    14.676     0.200
     2.706    79.215     0.200
     0.595    18.301     0.200
     0.595    18.180     0.200
     0.632    20.070     0.200
     0.597    19.465     0.200
     0.644    19.973     0.200
     0.619    19.719     0.200
     0.661    21.289     0.200
     0.306     9.875     0.200
     0.306     9.992     0.200
     0.323    10.859     0.200
     0.324    10.594     0.200
     0.538    16.656     0.200
     0.759    24.430     0.200
     2.040    60.586     0.200
     2.507    73.680     0.200
     2.975    87.953     0.200
     0.350    11.299     0.200
     0.351    10.740     0.200
     0.591    18.688     0.200
     0.625    20.367     0.200
     0.430    13.277     0.200
     0.430    14.137     0.200
     0.455    15.086     0.200
     0.456    14.477     0.200
     0.615    19.324     0.200
     0.717    23.234     0.200
     1.122    33.445     0.200
     2.150    64.586     0.200
     2.967    87.004     0.200
     2.967    88.277     0.200
     0.357    12.262     0.200
     0.351    11.250     0.200
     0.351    11.402     0.200
     0.410    13.281     0.200
     0.410    13.062     0.200
     0.454    14.199     0.200
     0.611    18.949     0.200
     0.897    27.180     0.200
     1.919    58.770     0.200
     2.664    78.742     0.200
     0.239     7.988     0.200
     0.239     8.479     0.200
     0.295     9.948     0.200
     0.277     9.309     0.200
     0.278     9.158     0.200
     0.423    12.869     0.200
     0.661    21.049     0.200
     0.817    25.089     0.200
     0.998    30.049     0.200
     1.103    33.249     0.200
     1.949    58.528     0.200
     2.858    84.669     0.200
     0.239     8.551     0.200
     0.357    11.699     0.200
     0.357    11.945     0.200
     0.437    14.189     0.200
     0.528    16.891     0.200
     0.695    21.459     0.200
     0.967    29.910     0.200
     1.142    34.879     0.200
     1.997    59.189     0.200
     2.759    81.830     0.200
     3.806   113.109     0.200
     0.193     7.285     0.200
     0.376    12.285     0.200
     0.376    12.277     0.200
     0.409    13.059     0.200
     0.431    14.168     0.200
     0.432    14.137     0.200
     0.635    19.367     0.200
     0.910    28.008     0.200
     1.971    59.707     0.200
     2.698    80.238     0.200
     0.228     8.339     0.200
     0.228     8.089     0.200
     0.271     9.779     0.200
     0.399    13.119     0.200
     0.797    25.079     0.200
     1.085    32.809     0.200
     0.214     8.035     0.200
     0.336    11.227     0.200
     0.510    15.656     0.200
     0.493    15.598     0.200
     0.493    15.738     0.200
     1.296    38.828     0.200
     1.990    59.926     0.200
     0.474    14.180     0.200
     0.659    19.449     0.200
     0.660    20.699     0.200
     0.696    21.551     0.200
     0.734    23.160     0.200
     0.937    29.059     0.200
     0.978    31.129     0.200
     1.210    38.059     0.200
     1.318    41.180     0.200
     1.301    40.359     0.200
     1.446    44.820     0.200
     0.690    23.258     0.200
     0.759    24.031     0.200
     0.847    26.070     0.200
     0.919    28.391     0.200
     0.977    29.930     0.200
     0.989    30.625     0.200
     1.151    35.500     0.200
     1.600    48.938     0.200
     2.046    61.750     0.200
     0.197     7.691     0.200
     0.350    10.980     0.200
     0.813    25.512     0.200
     0.898    28.320     0.200
     1.087    33.812     0.200
     1.145    35.250     0.200
     1.428    43.152     0.200
     1.483    44.633     0.200
     1.857    55.973     0.200
     0.314    10.773     0.200
     0.271     9.453     0.200
     0.271     9.352     0.200
     0.454    14.762     0.200
     1.104    33.164     0.200
     1.020    31.992     0.200
     1.329    38.973     0.200
     1.698    51.383     0.200
     1.844    55.531     0.200
     1.983    60.273     0.200
     2.457    71.391     0.200
     0.238     8.293     0.200
     0.644    19.461     0.200
     1.005    31.621     0.200
     1.093    34.062     0.200
     1.091    33.602     0.200
     1.249    38.801     0.200
     1.529    47.633     0.200
     1.682    51.070     0.200
     1.682    51.293     0.200
     1.907    58.543     0.200
     1.962    60.570     0.200
     1.976    61.691     0.200
     2.185    66.543     0.200
     2.397    73.820     0.200
     0.514    14.938     0.200
     0.735    22.555     0.200
     1.125    36.406     0.200
     1.412    43.484     0.200
     1.412    44.000     0.200
     0.242     8.297     0.200
     0.242     8.438     0.200
     0.242     8.499     0.200
     0.422    13.417     0.200
     0.655    21.257     0.200
     0.655    20.417     0.200
     0.745    23.257     0.200
     1.003    30.917     0.200
     1.811    54.537     0.200
     1.811    54.098     0.200
     2.121    63.327     0.200
     2.430    72.917     0.200
     2.854    85.066     0.200
     0.518    16.961     0.200
     0.625    19.312     0.200
     0.696    21.930     0.200
     0.835    25.789     0.200
     1.017    32.422     0.200
     1.033    32.992     0.200
     1.408    43.242     0.200
     1.940    58.289     0.200
     0.201     8.071     0.200
     0.389    13.241     0.200
     0.466    15.601     0.200
     0.656    21.331     0.200
     0.775    24.491     0.200
     0.893    27.631     0.200
     1.327    40.441     0.200
     1.831    55.881     0.200
     1.937    59.121     0.200
     2.178    65.980     0.200
     0.198     8.568     0.200
     0.385    12.928     0.200
     0.461    15.889     0.200
     0.655    20.799     0.200
     0.893    27.369     0.200
     0.772    24.488     0.200
     1.214    35.709     0.200
     1.827    55.588     0.200
     1.933    58.979     0.200
     2.173    66.049     0.200
     0.219     8.492     0.200
     0.219     8.445     0.200
     0.219     8.336     0.200
     0.394    13.500     0.200
     0.479    16.070     0.200
     0.479    16.172     0.200
     0.774    24.984     0.200
     0.906    28.734     0.200
     0.906    28.391     0.200
     1.341    41.898     0.200
     1.341    40.664     0.200
     1.847    56.055     0.200
     1.954    59.539     0.200
     2.190    65.594     0.200
     2.426    69.789     0.200
     0.465    15.520     0.200
     0.711    23.160     0.200
     0.712    21.961     0.200
     0.712    22.121     0.200
     0.712    21.258     0.200
     0.712    20.988     0.200
     1.045    32.438     0.200
     1.045    32.969     0.200
     1.188    37.281     0.200
     1.508    46.609     0.200
     1.508    45.781     0.200
     1.571    47.879     0.200
     2.489    75.910     0.200
     0.138     5.867     0.200
     0.320    11.086     0.200
     0.298    10.996     0.200
     0.753    24.137     0.200
     1.126    34.496     0.200
     1.334    41.605     0.200
     1.374    41.488     0.200
     1.723    52.008     0.200
     1.965    58.316     0.200
     0.284     9.662     0.200
     0.568    18.303     0.200
     0.691    22.002     0.200
     0.765    24.012     0.200
     0.765    23.623     0.200
     0.796    24.973     0.200
     0.853    26.422     0.200
     0.853    26.053     0.200
     0.915    29.342     0.200
     0.915    28.963     0.200
     0.995    31.031     0.200
     1.306    40.951     0.200
     1.481    45.062     0.200
     1.605    48.982     0.200
     1.605    48.793     0.200
     1.824    55.252     0.200
     0.549    17.879     0.200
     0.706    22.320     0.200
     0.757    24.719     0.200
     0.777    24.219     0.200
     0.839    26.250     0.200
     0.932    28.949     0.200
     1.303    39.711     0.200
     1.500    45.449     0.200
     1.582    47.449     0.200
     1.606    48.492     0.200
     0.685    21.906     0.200
     0.761    23.367     0.200
     0.761    24.566     0.200
     0.852    26.877     0.200
     0.852    26.926     0.200
     0.913    28.826     0.200
     1.599    49.387     0.200
     1.599    48.867     0.200
     1.830    55.016     0.200
     5.442   163.877     0.200
     0.287    11.141     0.200
     0.688    22.262     0.200
     0.766    24.320     0.200
     0.766    24.000     0.200
     0.855    26.320     0.200
     0.855    26.602     0.200
     0.855    26.520     0.200
     0.856    26.609     0.200
     0.911    28.539     0.200
     0.911    28.652     0.200
     0.997    30.902     0.200
     1.561    48.312     0.200
     1.605    49.262     0.200
     1.605    48.883     0.200
     1.760    54.371     0.200
     0.294     9.703     0.200
     0.748    23.143     0.200
     0.748    23.312     0.200
     0.748    23.764     0.200
     0.749    24.043     0.200
     0.854    26.912     0.200
     0.854    26.684     0.200
     1.034    32.273     0.200
     1.464    45.152     0.200
     0.367    10.363     0.200
     0.367    10.363     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
