#!/bin/bash
gmt begin haida1.26_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source haida1.26'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.478     0.731     0.200
     0.556     0.240     0.200
     0.735    -0.785     0.200
     0.794     0.173     0.200
     0.929    -0.162     0.200
     0.946    -0.556     0.200
     0.484     0.611     0.200
     0.557     0.216     0.200
     0.748    -1.126     0.200
     0.810     0.165     0.200
     0.945    -0.169     0.200
     0.955    -0.134     0.200
     0.495     0.394     0.200
     0.532     0.228     0.200
     0.737    -0.968     0.200
     0.802    -0.091     0.200
     0.771     0.227     0.200
     0.915    -0.182     0.200
     0.957    -0.212     0.200
     0.484     0.647     0.200
     0.551     0.052     0.200
     0.718    -0.018     0.200
     0.741    -0.762     0.200
     0.796     0.159     0.200
     0.784     0.201     0.200
     0.933    -0.210     0.200
     0.952     0.157     0.200
     0.111     0.656     0.200
     0.308     0.136     0.200
     0.469    -0.161     0.200
     0.655     0.294     0.200
     0.643    -0.701     0.200
     0.744     0.173     0.200
     0.989    -0.655     0.200
     0.420     0.061     0.200
     0.698    -0.856     0.200
     0.759    -0.189     0.200
     0.978    -0.521     0.200
     0.618     0.396     0.200
     0.639    -0.330     0.200
     0.727     0.080     0.200
     0.893    -1.034     0.200
     0.987    -0.617     0.200
     0.252     0.130     0.200
     0.474    -0.310     0.200
     0.574     0.561     0.200
     0.662     0.158     0.200
     0.684    -0.678     0.200
     0.972    -0.123     0.200
     0.382    -0.218     0.200
     0.441    -0.137     0.200
     0.218     0.641     0.200
     0.757    -0.261     0.200
     0.868    -0.160     0.200
     0.824    -0.665     0.200
     0.972    -0.101     0.200
     0.991    -0.302     0.200
     0.361     0.073     0.200
     0.586    -0.401     0.200
     0.866    -0.341     0.200
     0.219     0.204     0.200
     0.519    -0.182     0.200
     0.609    -0.451     0.200
     0.571     0.301     0.200
     0.404     0.602     0.200
     0.866    -0.018     0.200
     0.741     0.002     0.200
     0.867    -0.182     0.200
     0.905    -0.493     0.200
     0.417     0.869     0.200
     0.559     0.727     0.200
     0.751    -0.043     0.200
     0.751     0.266     0.200
     0.887     0.012     0.200
     0.887    -0.037     0.200
     0.851     0.632     0.200
     0.921    -0.360     0.200
     0.921     0.010     0.200
     0.637    -0.234     0.200
     0.383     0.074     0.200
     0.414    -0.927     0.200
     0.398    -0.152     0.200
     0.398    -0.023     0.200
     0.398    -0.832     0.200
     0.457    -0.308     0.200
     0.395    -0.206     0.200
     0.395    -0.117     0.200
     0.450    -0.200     0.200
     0.595    -0.387     0.200
     0.595    -0.606     0.200
     0.632    -0.174     0.200
     0.597    -0.139     0.200
     0.644    -0.529     0.200
     0.619    -0.801     0.200
     0.661    -0.577     0.200
     0.306    -0.007     0.200
     0.306     0.023     0.200
     0.323     0.055     0.200
     0.324     0.060     0.200
     0.538    -0.274     0.200
     0.986    -0.110     0.200
     0.350    -0.387     0.200
     0.351    -0.548     0.200
     0.591    -0.072     0.200
     0.591    -0.815     0.200
     0.625    -0.216     0.200
     0.430     0.021     0.200
     0.430    -0.198     0.200
     0.455     0.172     0.200
     0.456     0.052     0.200
     0.615     0.002     0.200
     0.717    -0.193     0.200
     0.140    -0.428     0.200
     0.357     0.071     0.200
     0.351    -0.240     0.200
     0.351    -0.397     0.200
     0.410    -0.036     0.200
     0.410    -0.211     0.200
     0.454    -0.565     0.200
     0.611    -0.464     0.200
     0.897    -0.729     0.200
     0.239    -0.346     0.200
     0.239     0.213     0.200
     0.295     0.118     0.200
     0.277     0.259     0.200
     0.278     0.182     0.200
     0.423    -0.199     0.200
     0.661     0.115     0.200
     0.817    -0.354     0.200
     0.998    -0.549     0.200
     0.239    -0.063     0.200
     0.357     0.057     0.200
     0.357     0.000     0.200
     0.437    -0.191     0.200
     0.528    -0.017     0.200
     0.695    -0.369     0.200
     0.967    -0.662     0.200
     0.193    -0.039     0.200
     0.376     0.115     0.200
     0.376     0.204     0.200
     0.409     0.068     0.200
     0.431     0.385     0.200
     0.432     0.130     0.200
     0.469     0.034     0.200
     0.635    -0.338     0.200
     0.910    -0.686     0.200
     0.228    -0.261     0.200
     0.228    -0.232     0.200
     0.271    -0.296     0.200
     0.399    -0.200     0.200
     0.643    -0.305     0.200
     0.797    -0.526     0.200
     1.000    -0.394     0.200
     0.214     0.047     0.200
     0.336    -0.064     0.200
     0.510    -0.308     0.200
     0.493    -0.115     0.200
     0.474    -0.000     0.200
     0.659    -0.681     0.200
     0.660     0.008     0.200
     0.696    -0.061     0.200
     0.734     0.167     0.200
     0.937    -0.191     0.200
     0.978     0.730     0.200
     0.285     0.996     0.200
     0.690     0.188     0.200
     0.759     0.257     0.200
     0.794    -0.164     0.200
     0.847     0.009     0.200
     0.919    -0.209     0.200
     0.938    -0.716     0.200
     0.977    -0.468     0.200
     0.989     0.098     0.200
     0.197     0.827     0.200
     0.350    -0.170     0.200
     0.480    -0.671     0.200
     0.813    -0.064     0.200
     0.898     0.067     0.200
     0.314     0.009     0.200
     0.271    -0.095     0.200
     0.271     0.065     0.200
     0.271    -0.037     0.200
     0.454    -0.207     0.200
     0.454    -0.020     0.200
     0.663     0.144     0.200
     0.238     0.307     0.200
     0.644    -0.627     0.200
     0.225     0.151     0.200
     0.334    -0.458     0.200
     0.514    -0.571     0.200
     0.735    -0.300     0.200
     0.242     0.286     0.200
     0.242     0.234     0.200
     0.242     0.294     0.200
     0.422     0.120     0.200
     0.655     0.110     0.200
     0.655     0.102     0.200
     0.745     0.105     0.200
     0.382     0.272     0.200
     0.518     0.337     0.200
     0.625    -0.176     0.200
     0.696     0.425     0.200
     0.835    -0.333     0.200
     0.201    -0.287     0.200
     0.389    -0.185     0.200
     0.466    -0.124     0.200
     0.656     0.118     0.200
     0.198    -0.280     0.200
     0.198    -0.139     0.200
     0.198    -0.070     0.200
     0.385    -0.110     0.200
     0.461     0.184     0.200
     0.461    -0.056     0.200
     0.655    -0.115     0.200
     0.893    -0.382     0.200
     0.772    -0.141     0.200
     0.219    -0.118     0.200
     0.219    -0.485     0.200
     0.219    -0.228     0.200
     0.219    -0.227     0.200
     0.394    -0.113     0.200
     0.479     0.031     0.200
     0.303     1.064     0.200
     0.465     0.249     0.200
     0.711     0.158     0.200
     0.712    -0.249     0.200
     0.712     0.772     0.200
     0.712     0.274     0.200
     0.737    -0.044     0.200
     0.861    -0.137     0.200
     0.138    -0.292     0.200
     0.320    -0.178     0.200
     0.298     0.227     0.200
     0.642    -0.168     0.200
     0.753    -0.107     0.200
     0.929    -0.130     0.200
     0.284     0.964     0.200
     0.568     0.374     0.200
     0.691     0.332     0.200
     0.765     0.130     0.200
     0.796    -0.346     0.200
     0.796    -0.236     0.200
     0.853    -0.201     0.200
     0.915     0.031     0.200
     0.915     0.351     0.200
     0.995    -0.131     0.200
     0.269     0.735     0.200
     0.549     0.273     0.200
     0.706    -0.235     0.200
     0.757     0.005     0.200
     0.777    -0.229     0.200
     0.839    -0.291     0.200
     0.932    -0.269     0.200
     0.987    -0.224     0.200
     0.291     0.625     0.200
     0.685     0.730     0.200
     0.685     0.381     0.200
     0.761     0.101     0.200
     0.761     0.271     0.200
     0.852    -0.017     0.200
     0.852    -0.308     0.200
     0.852    -0.176     0.200
     0.852    -0.133     0.200
     0.913     0.417     0.200
     0.913     0.097     0.200
     0.992    -0.118     0.200
     0.287     0.739     0.200
     0.688     0.262     0.200
     0.766     0.197     0.200
     0.855    -0.068     0.200
     0.855    -0.207     0.200
     0.856    -0.213     0.200
     0.911    -0.111     0.200
     0.911     0.147     0.200
     0.997     0.062     0.200
     0.294     0.108     0.200
     0.258     1.330     0.200
     0.748    -0.129     0.200
     0.748    -0.319     0.200
     0.748    -0.199     0.200
     0.749    -0.295     0.200
     0.854     0.009     0.200
     0.367     0.192     0.200
     0.367     0.223     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.926    -0.677     0.200
     0.775    -1.048     0.200
     0.893    -0.954     0.200
     0.774    -0.811     0.200
     0.906    -0.822     0.200
     0.906    -0.579     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.556     0.478     0.200
     0.557     0.446     0.200
     0.495     1.265     0.200
     0.532     1.016     0.200
     0.957     1.664     0.200
     0.551     0.355     0.200
     0.784     0.008     0.200
     0.952     1.179     0.200
     0.308    -0.041     0.200
     0.989    -0.006     0.200
     0.420     0.943     0.200
     0.494     0.320     0.200
     0.759     0.313     0.200
     0.662     0.287     0.200
     0.684    -1.102     0.200
     0.972     1.341     0.200
     0.382    -0.190     0.200
     0.441    -0.128     0.200
     0.218     2.101     0.200
     0.757     0.398     0.200
     0.868     0.433     0.200
     0.824    -0.278     0.200
     0.972     0.112     0.200
     0.991     0.617     0.200
     0.586     0.822     0.200
     0.866     0.556     0.200
     0.219     1.316     0.200
     0.519     0.084     0.200
     0.609     0.310     0.200
     0.663    -0.282     0.200
     0.926    -0.248     0.200
     0.404     1.422     0.200
     0.866    -0.293     0.200
     0.741     0.390     0.200
     0.867     0.565     0.200
     0.905    -0.052     0.200
     0.417     1.597     0.200
     0.559     0.950     0.200
     0.751     0.439     0.200
     0.751     0.659     0.200
     0.887     0.117     0.200
     0.887    -0.303     0.200
     0.887    -0.301     0.200
     0.851     0.635     0.200
     0.921     1.027     0.200
     0.637     0.504     0.200
     0.383     0.446     0.200
     0.414    -1.154     0.200
     0.398     0.331     0.200
     0.398    -0.528     0.200
     0.457    -0.431     0.200
     0.630     0.070     0.200
     0.630    -0.078     0.200
     0.691    -0.042     0.200
     0.395    -0.144     0.200
     0.395    -0.035     0.200
     0.450    -0.095     0.200
     0.595    -0.239     0.200
     0.595    -0.361     0.200
     0.632     0.318     0.200
     0.597     0.814     0.200
     0.644    -0.197     0.200
     0.619     0.310     0.200
     0.661     0.532     0.200
     0.306    -0.065     0.200
     0.306     0.050     0.200
     0.323     0.316     0.200
     0.324     0.032     0.200
     0.538    -0.296     0.200
     0.759     0.751     0.200
     0.350    -0.027     0.200
     0.351    -0.586     0.200
     0.591    -0.318     0.200
     0.625     0.245     0.200
     0.430    -0.402     0.200
     0.430     0.456     0.200
     0.455     0.547     0.200
     0.456    -0.079     0.200
     0.615    -0.006     0.200
     0.717     0.799     0.200
     0.357     0.509     0.200
     0.351    -0.270     0.200
     0.351    -0.118     0.200
     0.410    -0.062     0.200
     0.410    -0.287     0.200
     0.454    -0.436     0.200
     0.611    -0.297     0.200
     0.897    -0.783     0.200
     0.239    -0.234     0.200
     0.239     0.256     0.200
     0.295     0.148     0.200
     0.277    -0.112     0.200
     0.278    -0.275     0.200
     0.423    -0.754     0.200
     0.661     0.273     0.200
     0.817    -0.371     0.200
     0.998    -1.015     0.200
     0.239     0.090     0.200
     0.357    -0.085     0.200
     0.357     0.161     0.200
     0.437    -0.009     0.200
     0.528    -0.003     0.200
     0.695    -0.395     0.200
     0.967    -0.254     0.200
     0.193     0.006     0.200
     0.376    -0.050     0.200
     0.376    -0.058     0.200
     0.409    -0.306     0.200
     0.431     0.108     0.200
     0.432     0.069     0.200
     0.635    -0.649     0.200
     0.910    -0.394     0.200
     0.228    -0.151     0.200
     0.228    -0.402     0.200
     0.271     0.178     0.200
     0.399    -0.147     0.200
     0.797     0.057     0.200
     0.214     0.076     0.200
     0.336    -0.168     0.200
     0.510    -0.698     0.200
     0.493    -0.247     0.200
     0.493    -0.106     0.200
     0.474    -0.530     0.200
     0.659    -0.910     0.200
     0.660     0.226     0.200
     0.696     0.062     0.200
     0.734     0.424     0.200
     0.937     0.124     0.200
     0.978     0.935     0.200
     0.690     1.906     0.200
     0.759     0.501     0.200
     0.847    -0.135     0.200
     0.919    -0.022     0.200
     0.977    -0.318     0.200
     0.989     0.050     0.200
     0.197     0.761     0.200
     0.350    -0.414     0.200
     0.813     0.189     0.200
     0.898     0.344     0.200
     0.314     0.106     0.200
     0.271    -0.034     0.200
     0.271    -0.137     0.200
     0.454    -0.007     0.200
     0.238     0.433     0.200
     0.644    -0.603     0.200
     0.514    -0.940     0.200
     0.735    -0.161     0.200
     0.242    -0.262     0.200
     0.242    -0.126     0.200
     0.242    -0.066     0.200
     0.422    -0.327     0.200
     0.655     0.559     0.200
     0.655    -0.296     0.200
     0.745    -0.142     0.200
     0.518     0.952     0.200
     0.625    -0.001     0.200
     0.696     0.366     0.200
     0.835    -0.087     0.200
     0.201    -0.277     0.200
     0.389     0.017     0.200
     0.466     0.105     0.200
     0.656     0.385     0.200
     0.775     0.079     0.200
     0.893    -0.149     0.200
     0.198     0.669     0.200
     0.385     0.048     0.200
     0.461     0.721     0.200
     0.655    -0.070     0.200
     0.893    -0.622     0.200
     0.772     0.084     0.200
     0.219    -0.268     0.200
     0.219    -0.316     0.200
     0.219    -0.422     0.200
     0.394     0.142     0.200
     0.479     0.208     0.200
     0.479     0.310     0.200
     0.774     0.611     0.200
     0.906     0.566     0.200
     0.906     0.223     0.200
     0.465     0.977     0.200
     0.711     1.130     0.200
     0.712    -0.115     0.200
     0.712     0.045     0.200
     0.712    -0.816     0.200
     0.712    -1.095     0.200
     0.138    -0.188     0.200
     0.320     0.275     0.200
     0.298     0.887     0.200
     0.753     0.461     0.200
     0.284     0.777     0.200
     0.568     0.684     0.200
     0.691     0.613     0.200
     0.765     0.310     0.200
     0.765    -0.079     0.200
     0.796     0.313     0.200
     0.853     0.052     0.200
     0.853    -0.317     0.200
     0.915     1.063     0.200
     0.915     0.684     0.200
     0.995     0.283     0.200
     0.549     0.674     0.200
     0.706     0.354     0.200
     0.757     1.130     0.200
     0.777     0.018     0.200
     0.839     0.193     0.200
     0.932     0.037     0.200
     0.685     0.678     0.200
     0.761    -0.271     0.200
     0.761     0.929     0.200
     0.852     0.507     0.200
     0.852     0.546     0.200
     0.913     0.567     0.200
     0.287     2.059     0.200
     0.688     0.922     0.200
     0.766     0.532     0.200
     0.766     0.212     0.200
     0.855    -0.166     0.200
     0.855     0.115     0.200
     0.855     0.035     0.200
     0.856     0.115     0.200
     0.911     0.342     0.200
     0.911     0.455     0.200
     0.997     0.076     0.200
     0.294     0.218     0.200
     0.748    -0.093     0.200
     0.748     0.077     0.200
     0.748     0.529     0.200
     0.749     0.798     0.200
     0.854     0.364     0.200
     0.854     0.135     0.200
     0.367    -1.091     0.200
     0.367    -1.098     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.978    -1.206     0.200
     0.986    -1.575     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.061
 1.00   -0.061
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.815
 1.00   -0.815
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.2
 1.00    0.2
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -1.4
 1.00   -1.4
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =  -0.1 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.8 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.2 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -1.4 (dashed green line)
EOF
gmt end
