#!/bin/bash
gmt begin haida1.26_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic haida1.26'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.726
   137.000     1.817
   137.500     1.912
   138.000     2.010
   138.500     2.112
   139.000     2.217
   139.500     2.326
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.802
   142.000     2.932
   142.500     3.067
   143.000     3.207
   143.500     3.352
   144.000     3.503
   144.500     3.659
   145.000     3.821
   145.500     3.990
   146.000     4.165
   146.500     4.346
   147.000     4.535
   147.500     4.730
   148.000     4.933
   148.500     5.144
   149.000     5.364
   149.500     5.592
   150.000     5.830
   150.500     6.078
   151.000     6.337
   151.500     6.605
   152.000     6.884
   152.500     7.172
   153.000     7.471
   153.500     7.781
   154.000     8.101
   154.500     8.432
   155.000     8.774
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.687
   145.500     0.276
   146.000     1.303
   146.500     2.372
   147.000     3.476
   147.500     4.610
   148.000     5.771
   148.500     6.957
   149.000     8.167
   149.500     9.400
   150.000    10.655
   150.500    11.931
   151.000    13.227
   151.500    14.543
   152.000    15.879
   152.500    17.232
   153.000    18.603
   153.500    19.993
   154.000    21.399
   154.500    22.824
   155.000    24.265
   155.500    25.724
   156.000    27.199
   156.500    28.691
   157.000    30.200
   157.500    31.725
   158.000    33.267
   158.500    34.826
   159.000    36.401
   159.500    37.993
   160.000    39.600
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.690
   145.500     0.076
   146.000     0.769
   146.500     1.411
   147.000     2.010
   147.500     2.570
   148.000     3.095
   148.500     3.587
   149.000     4.053
   149.500     4.499
   150.000     4.929
   150.500     5.346
   151.000     5.753
   151.500     6.150
   152.000     6.539
   152.500     6.920
   153.000     7.295
   153.500     7.667
   154.000     8.036
   154.500     8.402
   155.000     8.767
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   143.569    -2.813     0.200
   143.679    -2.236     0.200
   143.679    -1.548     0.200
   149.615    -1.384     0.200
   149.615    -0.818     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   145.136    -0.047     0.200
   147.695     2.627     0.200
   148.088     3.478     0.200
   149.641     3.305     0.200
   150.407     3.996     0.200
   150.673     5.313     0.200
   151.162     3.825     0.200
   151.189     3.381     0.200
   151.005     5.409     0.200
   151.127     4.606     0.200
   150.770     4.467     0.200
   149.142     2.683     0.200
   149.665     3.329     0.200
   149.917     3.377     0.200
   151.221     4.321     0.200
   151.848     5.051     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   147.866     5.345     0.200
   148.600     6.140     0.200
   150.345     9.354     0.200
   149.641     7.805     0.200
   149.142     8.478     0.200
   146.238     2.602     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   149.641     5.602     0.200
   150.407     6.297     0.200
   150.729     5.546     0.200
   142.412     1.612     0.200
   150.682     5.342     0.200
   150.886     5.535     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
