#!/bin/bash
gmt begin haida1.26_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P haida1.26'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.708
    79.000     8.533
    80.000     7.443
    81.000     6.438
    82.000     5.519
    83.000     4.684
    84.000     3.933
    85.000     3.270
    86.000     2.692
    87.000     2.193
    88.000     1.797
    89.000     1.497
    90.000     1.239
    91.000     1.013
    92.000     0.812
    93.000     0.630
    94.000     0.464
    95.000     0.319
    96.000     0.199
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.547    10.622     0.200
    15.030     9.126     0.200
    15.793     6.934     0.200
    16.447     1.706     0.200
    16.660     2.703     0.200
    17.347     2.573     0.200
    17.526     1.348     0.200
    17.846     1.179     0.200
    18.171     2.885     0.200
    20.659     0.373     0.200
    21.168     1.377     0.200
    21.398     1.893     0.200
    21.756     3.050     0.200
    21.792     2.667     0.200
    21.967     0.093     0.200
    22.181     1.506     0.200
    22.566     2.404     0.200
    22.934     2.508     0.200
    22.945     1.097     0.200
    23.010    -0.300     0.200
    23.616     1.416     0.200
    23.890     1.908     0.200
    25.409     0.567     0.200
    25.730     1.654     0.200
    25.733     1.927     0.200
    26.164     2.225     0.200
    29.825     2.001     0.200
    30.332     1.617     0.200
    30.494     0.786     0.200
    32.653     0.581     0.200
    35.522     0.474     0.200
    36.468     0.580     0.200
    37.132     2.120     0.200
    38.444     0.328     0.200
    45.674     0.802     0.200
    45.674     1.302     0.200
    48.172     1.172     0.200
    51.980     1.373     0.200
    53.711    -0.217     0.200
    56.750    -1.347     0.200
    56.750    -0.551     0.200
    57.976     3.994     0.200
    57.976     4.392     0.200
    61.657     0.467     0.200
    62.437    -0.070     0.200
    62.763     0.050     0.200
    63.188     4.425     0.200
    63.822    -1.965     0.200
    64.390    -0.796     0.200
    64.558     0.604     0.200
    65.159     0.783     0.200
    66.119     2.290     0.200
    66.466     1.062     0.200
    68.779     0.254     0.200
    69.249     0.535     0.200
    69.667     0.746     0.200
    69.763     1.358     0.200
    69.782     1.238     0.200
    69.876     1.060     0.200
    69.929     1.542     0.200
    69.929     0.835     0.200
    69.981    -2.982     0.200
    70.000     1.398     0.200
    70.652     1.910     0.200
    70.945     0.129     0.200
    71.005     1.287     0.200
    71.038     1.383     0.200
    71.041     1.542     0.200
    71.323     0.839     0.200
    71.333     3.777     0.200
    71.333     4.777     0.200
    71.661     0.797     0.200
    71.678     0.989     0.200
    71.949     0.065     0.200
    72.070     1.136     0.200
    72.173     0.225     0.200
    72.202    -0.453     0.200
    72.272     1.130     0.200
    72.331     1.078     0.200
    72.385     0.956     0.200
    72.411     1.201     0.200
    72.527     0.908     0.200
    72.608     0.527     0.200
    72.621     0.844     0.200
    72.625     4.525     0.200
    72.662     0.704     0.200
    72.667     0.976     0.200
    72.706     0.643     0.200
    72.771    -0.842     0.200
    72.771    -0.444     0.200
    72.877     1.030     0.200
    72.886     0.577     0.200
    72.963     2.016     0.200
    72.963     2.312     0.200
    73.202     1.303     0.200
    73.208     1.968     0.200
    73.365     0.742     0.200
    73.427     0.073     0.200
    73.435    -1.172     0.200
    73.439     1.102     0.200
    73.552     1.039     0.200
    73.684     0.765     0.200
    73.684     1.062     0.200
    73.813     1.111     0.200
    73.878     1.025     0.200
    73.975     2.161     0.200
    74.362     1.800     0.200
    74.572    -0.023     0.200
    74.783     1.954     0.200
    74.879     5.200     0.200
    75.003     0.981     0.200
    75.072    -0.319     0.200
    75.222     0.316     0.200
    75.489     0.287     0.200
    75.498     0.630     0.200
    76.475     1.559     0.200
    76.520     1.108     0.200
    76.532     1.738     0.200
    76.686     1.262     0.200
    77.007     5.157     0.200
    77.128     1.772     0.200
    77.199    -0.423     0.200
    78.177     0.324     0.200
    78.552     4.549     0.200
    78.543    -0.405     0.200
    78.637     0.076     0.200
    78.828     2.530     0.200
    78.917     1.036     0.200
    78.920     1.622     0.200
    79.157     1.721     0.200
    81.732    -0.115     0.200
    82.425    -0.959     0.200
    82.586     0.806     0.200
    83.080     0.044     0.200
    83.547    -0.567     0.200
    83.583     1.249     0.200
    83.583     1.546     0.200
    84.689     3.618     0.200
    85.661     0.751     0.200
    85.649    -0.194     0.200
    85.649     0.306     0.200
    85.875    -0.311     0.200
    86.642     1.906     0.200
    86.909     0.600     0.200
    88.164    -0.434     0.200
    88.187     0.460     0.200
    88.207     0.361     0.200
    88.399     2.453     0.200
    88.695     1.061     0.200
    89.721     1.242     0.200
    92.428     1.467     0.200
    92.730     1.279     0.200
    92.731     0.875     0.200
    92.893     0.923     0.200
    92.953     1.453     0.200
    14.531     3.915     0.200
    14.869     7.506     0.200
    17.351     4.100     0.200
    20.739    -1.510     0.200
    22.931     1.824     0.200
    22.945     3.205     0.200
    14.473     8.314     0.200
    17.672     3.230     0.200
    22.964     1.412     0.200
    14.792     6.057     0.200
    15.636     5.194     0.200
    21.160    -0.553     0.200
    21.856     2.775     0.200
    22.083    -1.762     0.200
    31.784     1.232     0.200
    32.825     1.000     0.200
    36.545     0.141     0.200
    56.860     0.413     0.200
    21.500    -0.341     0.200
    22.153     3.090     0.200
    22.459     1.804     0.200
    23.050     0.250     0.200
    15.539     2.393     0.200
    17.240     0.551     0.200
    17.377     2.768     0.200
    22.070     1.307     0.200
    29.849     0.857     0.200
    31.537     1.637     0.200
    76.439     0.473     0.200
    18.147     3.222     0.200
    32.016     1.846     0.200
    17.020     3.045     0.200
    17.827     2.937     0.200
    18.194     1.210     0.200
    18.194     4.219     0.200
    20.256    -0.145     0.200
    21.111    -1.158     0.200
    21.552     0.556     0.200
    22.018    -0.722     0.200
    22.174     0.724     0.200
    23.993     0.668     0.200
    29.781     0.381     0.200
    31.719     1.786     0.200
    62.749    -0.436     0.200
    74.600    -0.413     0.200
    74.822    -2.345     0.200
    75.205     0.440     0.200
    75.752     0.129     0.200
    75.824     0.120     0.200
    75.824     0.112     0.200
    77.145     0.106     0.200
    18.181     3.379     0.200
    21.380     1.983     0.200
    24.811     1.093     0.200
    36.479     0.826     0.200
    75.755    -0.293     0.200
    75.822    -0.149     0.200
    77.149     0.380     0.200
    85.660     0.375     0.200
    88.560    -1.186     0.200
    14.307     9.605     0.200
    15.012     7.724     0.200
    18.441     2.037     0.200
    18.852     3.432     0.200
    19.068     3.575     0.200
    19.340     3.509     0.200
    19.340     3.300     0.200
    19.394     2.590     0.200
    19.617     3.051     0.200
    19.617     2.922     0.200
    19.627     3.179     0.200
    19.868     2.589     0.200
    19.980     0.756     0.200
    20.095     2.538     0.200
    20.068     2.815     0.200
    20.186     2.361     0.200
    20.251     3.233     0.200
    20.237     2.522     0.200
    20.558     2.811     0.200
    20.643     0.080     0.200
    20.554     2.972     0.200
    20.590     2.382     0.200
    20.704     1.549     0.200
    20.704     2.411     0.200
    20.672     2.628     0.200
    20.780     2.608     0.200
    21.061     2.787     0.200
    21.151     2.522     0.200
    21.188     2.613     0.200
    21.450     1.176     0.200
    21.426     2.552     0.200
    21.461     3.344     0.200
    21.434     2.931     0.200
    21.454     2.337     0.200
    21.505     1.584     0.200
    21.567     2.291     0.200
    21.578     1.754     0.200
    21.646     1.553     0.200
    21.680     1.712     0.200
    21.711     0.493     0.200
    21.733     0.893     0.200
    21.732     2.320     0.200
    21.757     1.377     0.200
    21.761     2.427     0.200
    21.844     2.083     0.200
    22.071     1.824     0.200
    22.013     2.330     0.200
    22.186     2.085     0.200
    22.186     1.102     0.200
    22.188     2.040     0.200
    22.193     1.888     0.200
    22.207     2.365     0.200
    22.238     1.813     0.200
    22.731     1.721     0.200
    22.731     1.102     0.200
    22.811     2.452     0.200
    22.845     1.479     0.200
    23.194     1.663     0.200
    23.194     1.817     0.200
    23.176     1.209     0.200
    23.904     1.806     0.200
    23.904     1.647     0.200
    24.151     2.762     0.200
    24.599     2.534     0.200
    25.073     0.772     0.200
    25.233     1.642     0.200
    25.527     1.652     0.200
    25.527     1.371     0.200
    29.799     1.242     0.200
    30.763     0.032     0.200
    31.329     0.284     0.200
    31.441     1.635     0.200
    31.442     1.580     0.200
    31.442     1.583     0.200
    31.660     0.007     0.200
    31.776     0.683     0.200
    31.898     0.163     0.200
    31.962     0.685     0.200
    32.072    -0.062     0.200
    32.328     0.770     0.200
    32.354    -0.648     0.200
    32.468     0.177     0.200
    32.468    -1.458     0.200
    32.874    -0.457     0.200
    32.908     0.914     0.200
    32.908     0.459     0.200
    33.138     1.734     0.200
    35.378    -0.298     0.200
    35.847    -0.498     0.200
    39.106     0.638     0.200
    63.025     0.347     0.200
    63.025     0.347     0.200
    69.365     0.467     0.200
    69.369     0.440     0.200
    76.615     1.210     0.200
    76.615     1.214     0.200
    79.025     3.659     0.200
    14.115     4.598     0.200
    14.223     7.588     0.200
    14.273     8.391     0.200
    14.879     3.594     0.200
    15.068     3.733     0.200
    15.859     4.546     0.200
    16.039     5.254     0.200
    16.212     3.883     0.200
    16.220     4.247     0.200
    16.309     5.540     0.200
    16.516     2.674     0.200
    16.607     2.203     0.200
    16.717     3.458     0.200
    16.836     5.120     0.200
    16.901     4.782     0.200
    16.920     5.172     0.200
    16.920     5.043     0.200
    16.920     4.105     0.200
    16.974     4.581     0.200
    16.990     2.283     0.200
    17.086     3.602     0.200
    17.100     3.540     0.200
    17.100     4.918     0.200
    17.112     4.600     0.200
    17.357     3.507     0.200
    17.357     3.894     0.200
    17.768     4.482     0.200
    17.772     4.739     0.200
    17.814     4.970     0.200
    17.874     2.005     0.200
    17.874     2.325     0.200
    17.856     3.934     0.200
    17.856     3.098     0.200
    18.218     3.579     0.200
    18.218     2.584     0.200
    18.218     1.447     0.200
    18.218     3.576     0.200
    18.289     0.738     0.200
    18.346     2.567     0.200
    20.532     1.226     0.200
    21.118     1.305     0.200
    21.193     3.075     0.200
    21.197     2.541     0.200
    21.271     2.590     0.200
    21.317     2.323     0.200
    21.476     3.947     0.200
    21.476     2.721     0.200
    21.477     2.892     0.200
    21.486     2.617     0.200
    21.519     3.894     0.200
    21.583     3.658     0.200
    21.594     2.651     0.200
    21.626     3.043     0.200
    21.635     2.816     0.200
    21.637     2.196     0.200
    21.739     2.018     0.200
    21.740     4.303     0.200
    21.770     3.052     0.200
    21.792     3.297     0.200
    21.792     3.783     0.200
    21.823     1.918     0.200
    21.903     2.698     0.200
    21.909     2.104     0.200
    22.050     3.277     0.200
    22.056     0.372     0.200
    22.115     2.025     0.200
    22.652    -1.738     0.200
    22.652    -0.523     0.200
    22.652    -3.234     0.200
    23.246     2.015     0.200
    23.302     2.076     0.200
    23.402     0.324     0.200
    23.416     0.766     0.200
    23.416     0.992     0.200
    23.949     1.924     0.200
    24.236     2.322     0.200
    24.622     2.620     0.200
    25.009    -0.440     0.200
    25.201     1.758     0.200
    25.592    -0.056     0.200
    25.592     3.093     0.200
    25.592     1.975     0.200
    25.646     4.455     0.200
    25.685     1.100     0.200
    26.209     1.664     0.200
    26.579     1.212     0.200
    26.906     2.669     0.200
    29.829     1.489     0.200
    29.829     1.161     0.200
    30.762     0.584     0.200
    31.307     1.104     0.200
    31.516     1.719     0.200
    31.516     1.593     0.200
    31.516     1.592     0.200
    31.643    -0.237     0.200
    31.856     1.475     0.200
    31.881     0.709     0.200
    31.881     0.303     0.200
    31.892     0.046     0.200
    31.965     0.608     0.200
    32.070     0.158     0.200
    32.196     1.470     0.200
    32.335     0.558     0.200
    32.337    -0.014     0.200
    32.468     0.740     0.200
    32.541     0.429     0.200
    32.752     2.091     0.200
    32.872    -0.389     0.200
    32.897    -0.349     0.200
    32.917     1.104     0.200
    33.043     0.219     0.200
    33.094    -0.776     0.200
    33.502    -0.241     0.200
    33.950     0.792     0.200
    34.210     0.177     0.200
    35.372    -0.011     0.200
    35.895     0.118     0.200
    35.948     1.738     0.200
    35.948     1.285     0.200
    36.138    -2.151     0.200
    36.394     1.022     0.200
    36.751     0.857     0.200
    36.799    -0.151     0.200
    36.813    -0.388     0.200
    37.013     0.333     0.200
    37.168     0.871     0.200
    37.436    -0.648     0.200
    37.436     0.989     0.200
    37.639    -0.107     0.200
    37.933     0.801     0.200
    37.948     0.816     0.200
    38.040     0.477     0.200
    38.237     0.491     0.200
    38.237     0.112     0.200
    38.266     0.129     0.200
    38.316    -0.053     0.200
    38.518     0.331     0.200
    38.592     0.365     0.200
    39.019     0.846     0.200
    39.019     0.143     0.200
    39.004     1.376     0.200
    39.004     0.825     0.200
    39.145     0.464     0.200
    39.257    -0.150     0.200
    39.682     0.986     0.200
    39.825    -0.025     0.200
    40.138     1.048     0.200
    40.138     0.669     0.200
    40.601     1.139     0.200
    40.603     1.289     0.200
    40.603     1.121     0.200
    40.603     1.289     0.200
    41.063     1.548     0.200
    41.063     2.188     0.200
    41.792     1.086     0.200
    41.792     0.747     0.200
    43.587     0.020     0.200
    43.587     0.344     0.200
    44.165    -0.270     0.200
    48.625     0.557     0.200
    48.625     0.878     0.200
    48.625    -1.099     0.200
    52.002     0.634     0.200
    54.713     0.007     0.200
    56.017     1.962     0.200
    59.421     0.159     0.200
    61.608    -0.436     0.200
    61.608    -0.438     0.200
    61.608    -0.251     0.200
    62.820     0.225     0.200
    62.820     0.225     0.200
    62.820     0.225     0.200
    64.136    -0.019     0.200
    64.321    -0.413     0.200
    65.775     0.703     0.200
    65.880    -0.618     0.200
    66.010     0.938     0.200
    66.679    -0.039     0.200
    66.988     0.290     0.200
    67.776     0.405     0.200
    67.986     0.766     0.200
    67.986     0.766     0.200
    68.739    -1.029     0.200
    68.821     3.558     0.200
    69.203    -0.513     0.200
    69.207    -0.491     0.200
    69.207    -0.538     0.200
    70.539     0.767     0.200
    70.749    -0.914     0.200
    71.598    -0.135     0.200
    71.637     1.310     0.200
    72.040    -2.510     0.200
    72.460     0.683     0.200
    72.507     1.195     0.200
    72.832     0.584     0.200
    72.817    -0.235     0.200
    72.817    -0.543     0.200
    72.834    -0.302     0.200
    73.295     1.427     0.200
    73.591    -0.352     0.200
    73.812     1.988     0.200
    73.841     1.114     0.200
    74.198     0.932     0.200
    74.381     0.963     0.200
    74.638     0.709     0.200
    74.638     0.870     0.200
    74.661     0.739     0.200
    74.677     0.714     0.200
    74.677     0.667     0.200
    74.885     0.265     0.200
    74.885     1.241     0.200
    74.885     0.741     0.200
    75.075     0.342     0.200
    75.444     1.970     0.200
    75.572     0.854     0.200
    75.586     1.464     0.200
    75.649     0.756     0.200
    75.650     0.774     0.200
    75.654     1.705     0.200
    75.682    -0.641     0.200
    75.682    -0.641     0.200
    75.687    -0.668     0.200
    75.916     0.320     0.200
    76.031     1.124     0.200
    76.090    -3.573     0.200
    76.122     0.545     0.200
    76.456    -0.383     0.200
    76.456    -0.383     0.200
    76.456    -0.379     0.200
    76.476    -0.592     0.200
    76.753    -0.277     0.200
    76.882     1.883     0.200
    76.882     0.441     0.200
    76.882     1.043     0.200
    77.022     0.425     0.200
    77.152     0.023     0.200
    77.596     0.539     0.200
    77.597     0.713     0.200
    77.772     0.343     0.200
    77.774     3.941     0.200
    78.092     0.945     0.200
    78.119     1.295     0.200
    78.123     1.402     0.200
    78.257     0.062     0.200
    78.494     0.750     0.200
    78.921     1.203     0.200
    78.919     1.112     0.200
    79.424     0.547     0.200
    79.856     0.699     0.200
    79.975     0.160     0.200
    80.063     0.780     0.200
    80.209     0.991     0.200
    80.212     0.579     0.200
    80.391     1.514     0.200
    80.947     0.336     0.200
    81.648     0.448     0.200
    81.935    -1.097     0.200
    81.955     0.811     0.200
    82.037     0.630     0.200
    82.148     0.304     0.200
    82.148     0.124     0.200
    82.269    -0.222     0.200
    82.450    -0.476     0.200
    82.450    -0.375     0.200
    82.644     0.299     0.200
    82.685     0.582     0.200
    82.797     0.921     0.200
    82.985     0.663     0.200
    83.397     1.297     0.200
    83.508     0.258     0.200
    83.508     0.425     0.200
    83.508     0.086     0.200
    83.742     0.274     0.200
    83.999     1.211     0.200
    84.027     0.580     0.200
    84.214     2.013     0.200
    84.875     0.378     0.200
    84.910     0.828     0.200
    85.708     0.509     0.200
    85.793     0.863     0.200
    86.786     0.471     0.200
    86.811     1.209     0.200
    87.027     0.125     0.200
    87.027     0.214     0.200
    87.027     0.123     0.200
    87.372     0.420     0.200
    87.372     1.701     0.200
    87.372     1.552     0.200
    88.142    -0.501     0.200
    88.142    -0.279     0.200
    88.503    -0.133     0.200
    89.171    -0.401     0.200
    94.844     0.001     0.200
    14.354     6.899     0.200
    15.111     6.405     0.200
    15.686     5.212     0.200
    15.865     6.415     0.200
    16.622     4.322     0.200
    17.232     1.894     0.200
    17.695     1.363     0.200
    18.234     3.375     0.200
    19.503     3.061     0.200
    20.034     2.735     0.200
    20.035     2.654     0.200
    20.525     2.204     0.200
    20.441     2.146     0.200
    20.369     3.102     0.200
    20.431     2.849     0.200
    20.517     2.247     0.200
    20.629     2.774     0.200
    21.256     2.409     0.200
    21.290     3.672     0.200
    21.354     1.988     0.200
    21.287     1.726     0.200
    21.396     2.104     0.200
    21.406     2.555     0.200
    21.407     1.136     0.200
    21.354     1.658     0.200
    21.460     1.085     0.200
    21.475     2.075     0.200
    21.509     1.376     0.200
    21.540     1.697     0.200
    21.563     1.599     0.200
    21.587     0.988     0.200
    21.592     2.104     0.200
    21.673     2.552     0.200
    21.679     2.462     0.200
    21.820     2.532     0.200
    21.772     2.753     0.200
    21.892     2.071     0.200
    22.100     4.958     0.200
    22.563     1.815     0.200
    22.525     2.304     0.200
    22.490     2.182     0.200
    22.681     0.581     0.200
    23.019     2.049     0.200
    23.139     2.217     0.200
    23.178     2.609     0.200
    23.410     1.255     0.200
    23.997     2.461     0.200
    25.360     1.862     0.200
    25.905     3.272     0.200
    26.945     0.918     0.200
    31.281     1.510     0.200
    31.281     1.513     0.200
    39.246     2.134     0.200
    59.652     0.089     0.200
    69.438     1.319     0.200
    73.056     0.754     0.200
    76.692     0.014     0.200
    76.692     0.010     0.200
    78.015     2.924     0.200
    79.162     1.299     0.200
    15.870     6.264     0.200
    15.961     6.117     0.200
    16.374     4.689     0.200
    16.779     3.132     0.200
    16.897     3.740     0.200
    16.900     4.544     0.200
    16.940     5.694     0.200
    16.985     4.039     0.200
    16.982     4.221     0.200
    17.035     4.046     0.200
    17.148     3.093     0.200
    17.173     4.831     0.200
    17.395     4.976     0.200
    17.451     4.314     0.200
    17.840     2.474     0.200
    17.840     3.716     0.200
    17.991     3.972     0.200
    18.279     3.329     0.200
    18.279     3.607     0.200
    18.279     3.506     0.200
    18.361     0.505     0.200
    19.207     0.443     0.200
    20.014     2.499     0.200
    20.060     2.413     0.200
    20.232     2.450     0.200
    20.228     2.597     0.200
    20.321     1.588     0.200
    20.368     2.913     0.200
    20.492    -0.360     0.200
    20.618     1.702     0.200
    20.618     1.377     0.200
    20.711     2.576     0.200
    20.711     2.849     0.200
    20.728     2.675     0.200
    20.804     2.424     0.200
    21.089     1.514     0.200
    21.225     2.387     0.200
    21.229     2.638     0.200
    21.254     2.741     0.200
    21.411     1.204     0.200
    21.411     1.052     0.200
    21.538     3.850     0.200
    21.540     1.965     0.200
    21.575     2.529     0.200
    21.608     2.267     0.200
    21.641     2.007     0.200
    21.681     2.713     0.200
    21.691     3.191     0.200
    21.760     1.136     0.200
    21.794     3.278     0.200
    21.795     0.095     0.200
    21.825    -0.548     0.200
    22.105     1.549     0.200
    22.173     0.992     0.200
    22.170     2.174     0.200
    22.345     1.529     0.200
    22.724    -1.087     0.200
    22.724     0.960     0.200
    22.812     2.669     0.200
    22.812     1.798     0.200
    23.302     1.828     0.200
    23.489     0.485     0.200
    24.007     3.166     0.200
    24.284     2.972     0.200
    25.271     1.182     0.200
    25.645     0.376     0.200
    25.645     3.505     0.200
    25.737     3.847     0.200
    26.008     3.073     0.200
    26.281     1.627     0.200
    26.281     0.784     0.200
    26.978     1.584     0.200
    28.192     1.332     0.200
    29.890     1.524     0.200
    29.890     0.915     0.200
    31.567     0.561     0.200
    31.567     1.695     0.200
    31.567     0.556     0.200
    32.159     2.107     0.200
    32.159     0.704     0.200
    34.579    -0.476     0.200
    35.998     1.330     0.200
    37.240     0.536     0.200
    37.317     2.539     0.200
    37.564     0.662     0.200
    38.018     0.075     0.200
    38.018     0.645     0.200
    38.091     0.535     0.200
    38.109     0.254     0.200
    38.384    -0.078     0.200
    38.562     0.573     0.200
    38.961    -0.546     0.200
    38.961     1.204     0.200
    40.081     2.065     0.200
    40.544     0.858     0.200
    40.546     0.844     0.200
    41.016    -0.220     0.200
    41.016     2.136     0.200
    43.564     0.086     0.200
    43.564     0.477     0.200
    44.196     0.895     0.200
    48.588     1.099     0.200
    48.588    -2.303     0.200
    51.945     1.077     0.200
    54.703    -0.378     0.200
    55.967     3.085     0.200
    56.905     0.116     0.200
    56.905     0.112     0.200
    57.225    -2.060     0.200
    59.367     0.885     0.200
    62.714     1.343     0.200
    62.853     0.422     0.200
    62.853     0.450     0.200
    62.853     0.446     0.200
    65.743     0.187     0.200
    65.892    -0.975     0.200
    68.878     2.201     0.200
    68.878     3.822     0.200
    69.185    -0.118     0.200
    69.189     0.080     0.200
    69.189    -0.135     0.200
    70.752     0.091     0.200
    71.593     1.494     0.200
    72.438     1.028     0.200
    72.810    -0.281     0.200
    72.868     0.390     0.200
    73.493     0.379     0.200
    73.554     1.017     0.200
    73.576    -0.508     0.200
    73.635     1.045     0.200
    73.832     0.690     0.200
    73.920     0.874     0.200
    73.931     0.810     0.200
    74.110     1.365     0.200
    74.418     0.966     0.200
    74.714     0.722     0.200
    74.722     0.732     0.200
    74.919     1.360     0.200
    75.102     2.805     0.200
    75.484     1.947     0.200
    75.619    -0.167     0.200
    75.626     1.676     0.200
    75.707    -1.003     0.200
    75.707     0.032     0.200
    75.707     0.044     0.200
    75.950     0.142     0.200
    75.984     1.751     0.200
    76.067     1.420     0.200
    76.156     0.370     0.200
    76.437    -0.375     0.200
    76.437    -0.274     0.200
    76.437    -0.274     0.200
    76.437    -0.375     0.200
    76.457    -0.385     0.200
    76.500    -0.153     0.200
    76.631     0.416     0.200
    76.915     1.775     0.200
    77.059     0.276     0.200
    77.142     0.297     0.200
    77.648    -0.062     0.200
    77.749     3.998     0.200
    77.772    -0.150     0.200
    78.525     0.395     0.200
    78.877     1.758     0.200
    78.949     0.965     0.200
    79.457     0.089     0.200
    79.457     0.191     0.200
    80.242     0.638     0.200
    82.134     0.515     0.200
    82.440    -0.253     0.200
    82.440    -0.355     0.200
    82.672     0.863     0.200
    83.523     0.876     0.200
    83.523     0.267     0.200
    83.757     0.367     0.200
    84.013     1.257     0.200
    84.561     1.215     0.200
    84.860     0.567     0.200
    87.051     0.248     0.200
    87.051     0.242     0.200
    88.199    -0.555     0.200
    88.199    -0.719     0.200
    89.171     0.095     0.200
    14.489     5.095     0.200
    14.491     6.141     0.200
    14.519     7.712     0.200
    14.657     4.834     0.200
    15.228     6.544     0.200
    15.430     3.205     0.200
    15.364     5.389     0.200
    16.065     6.292     0.200
    16.247     3.751     0.200
    16.131     4.716     0.200
    16.152     5.389     0.200
    16.329     4.251     0.200
    16.540     4.274     0.200
    16.559     5.209     0.200
    16.760     2.859     0.200
    16.814     2.682     0.200
    16.814     3.280     0.200
    16.929     1.681     0.200
    16.999     1.728     0.200
    16.901     5.913     0.200
    17.029     3.554     0.200
    16.960     3.654     0.200
    16.967     4.043     0.200
    17.118     5.036     0.200
    17.145     2.204     0.200
    17.145     3.259     0.200
    17.166     4.518     0.200
    17.149     4.343     0.200
    17.283     4.090     0.200
    17.294     3.720     0.200
    17.304     3.576     0.200
    17.337     2.735     0.200
    17.826     2.885     0.200
    17.924     0.882     0.200
    17.845     4.199     0.200
    17.847     4.159     0.200
    18.135     0.690     0.200
    18.135     2.174     0.200
    18.098     1.885     0.200
    18.412    -0.264     0.200
    18.481     0.426     0.200
    18.624     2.050     0.200
    19.265     1.906     0.200
    19.514     2.699     0.200
    19.556     2.684     0.200
    19.638     1.682     0.200
    19.771     2.821     0.200
    19.789     2.929     0.200
    20.078     2.071     0.200
    20.211     0.098     0.200
    20.211     0.801     0.200
    20.112     2.445     0.200
    20.226     2.984     0.200
    20.286     2.493     0.200
    20.350     1.984     0.200
    20.379     2.530     0.200
    20.460     2.278     0.200
    20.405     2.416     0.200
    20.453     2.992     0.200
    20.717     1.974     0.200
    20.717     2.513     0.200
    20.780     2.154     0.200
    20.923     1.431     0.200
    20.923     1.579     0.200
    20.971     2.484     0.200
    20.949     2.815     0.200
    21.118     1.784     0.200
    21.214     2.113     0.200
    21.239     2.328     0.200
    21.315     2.433     0.200
    21.341     2.245     0.200
    21.632     0.631     0.200
    21.632     0.850     0.200
    21.637     3.275     0.200
    21.676     0.928     0.200
    21.676     1.279     0.200
    21.684     1.158     0.200
    21.591     1.750     0.200
    21.673     2.234     0.200
    21.592     2.356     0.200
    21.621     2.514     0.200
    21.697     2.472     0.200
    21.736     2.334     0.200
    21.778     3.620     0.200
    21.791     2.065     0.200
    21.789     1.233     0.200
    21.841     1.632     0.200
    21.857     1.974     0.200
    21.891     1.232     0.200
    21.891     0.986     0.200
    21.922     2.374     0.200
    21.943     2.223     0.200
    21.945     2.322     0.200
    21.969     1.809     0.200
    21.971     3.104     0.200
    22.055     2.448     0.200
    22.062     1.416     0.200
    22.089     1.525     0.200
    22.082     2.365     0.200
    22.203     2.252     0.200
    22.175     1.978     0.200
    22.173     1.216     0.200
    22.291     0.918     0.200
    22.344     2.890     0.200
    22.344     2.285     0.200
    22.351     2.433     0.200
    22.375     2.068     0.200
    22.395     2.252     0.200
    22.660     2.308     0.200
    22.692     2.215     0.200
    22.968     0.324     0.200
    22.968     1.004     0.200
    22.868     2.474     0.200
    22.868     2.314     0.200
    22.939     1.785     0.200
    22.939     1.887     0.200
    22.981     2.713     0.200
    22.981     2.893     0.200
    23.001     3.144     0.200
    23.099     2.102     0.200
    23.187     2.369     0.200
    23.409     1.408     0.200
    23.409     2.322     0.200
    23.333     2.521     0.200
    23.456     1.851     0.200
    23.470     1.601     0.200
    23.670     0.653     0.200
    23.721     0.769     0.200
    23.721     0.562     0.200
    23.745     2.670     0.200
    23.890     2.484     0.200
    24.123     2.860     0.200
    24.123     1.927     0.200
    24.145     1.370     0.200
    24.345     1.253     0.200
    24.826     2.877     0.200
    24.826     2.170     0.200
    25.158     1.441     0.200
    25.246     1.945     0.200
    25.472     1.750     0.200
    25.472     1.422     0.200
    25.735    -0.916     0.200
    25.735     2.740     0.200
    25.893     1.811     0.200
    25.819     2.716     0.200
    25.813     2.557     0.200
    26.089     2.977     0.200
    26.275     1.125     0.200
    26.519     0.269     0.200
    26.519     0.675     0.200
    26.619     0.970     0.200
    26.854     0.479     0.200
    26.854     0.627     0.200
    26.576     1.820     0.200
    27.205     0.902     0.200
    27.279     1.785     0.200
    28.254     2.350     0.200
    28.803     0.841     0.200
    28.864     2.754     0.200
    28.864     2.594     0.200
    30.025     1.536     0.200
    31.053     0.624     0.200
    31.567     0.878     0.200
    31.643     2.410     0.200
    31.644    -1.013     0.200
    31.644    -1.010     0.200
    31.898     0.320     0.200
    32.195     0.757     0.200
    32.158     0.057     0.200
    32.307     0.334     0.200
    32.592    -0.292     0.200
    32.702     1.505     0.200
    32.703     1.827     0.200
    32.703     2.329     0.200
    33.109    -0.454     0.200
    33.317     0.391     0.200
    33.817     3.321     0.200
    35.455     1.250     0.200
    35.455     2.231     0.200
    35.522     0.412     0.200
    37.171    -0.844     0.200
    37.496     0.661     0.200
    37.399     1.572     0.200
    37.595     0.826     0.200
    37.904    -0.216     0.200
    38.079    -0.049     0.200
    38.203     0.206     0.200
    38.203     0.061     0.200
    38.217    -0.451     0.200
    38.217    -0.205     0.200
    38.341    -0.301     0.200
    38.300    -0.102     0.200
    38.300    -0.329     0.200
    38.453    -0.981     0.200
    38.503     0.457     0.200
    38.503    -0.312     0.200
    38.566    -0.141     0.200
    38.815     0.289     0.200
    38.792     1.026     0.200
    38.917    -0.042     0.200
    38.927    -0.117     0.200
    38.927     3.008     0.200
    39.344     1.354     0.200
    39.581    -0.246     0.200
    39.598     0.920     0.200
    39.696     0.322     0.200
    39.759    -0.850     0.200
    39.931     0.155     0.200
    39.970     3.005     0.200
    40.436    -0.849     0.200
    40.962    -0.757     0.200
    44.426     1.168     0.200
    48.585    -0.500     0.200
    48.585    -0.672     0.200
    52.620     1.359     0.200
    53.762     0.486     0.200
    54.806    -1.532     0.200
    55.899     2.861     0.200
    57.088     2.695     0.200
    57.235    -3.546     0.200
    61.413    -1.329     0.200
    61.413     1.960     0.200
    61.413    -1.322     0.200
    62.947    -0.315     0.200
    63.087     1.139     0.200
    63.087    -0.209     0.200
    63.087    -0.213     0.200
    64.033     0.288     0.200
    65.759     2.649     0.200
    66.067    -1.634     0.200
    66.310     1.856     0.200
    66.341    -1.132     0.200
    66.341    -1.132     0.200
    66.969     2.297     0.200
    67.933     1.187     0.200
    67.946     0.515     0.200
    67.946     0.511     0.200
    68.718     1.876     0.200
    68.985     1.997     0.200
    68.985     5.119     0.200
    69.259    -1.441     0.200
    69.263    -0.485     0.200
    69.263     0.214     0.200
    70.897     1.962     0.200
    71.021     2.911     0.200
    71.381     2.740     0.200
    71.401     2.710     0.200
    71.401     2.389     0.200
    71.535     2.600     0.200
    71.553     1.589     0.200
    72.254     1.184     0.200
    72.492     1.464     0.200
    72.495     1.543     0.200
    72.789     3.893     0.200
    72.922     0.368     0.200
    73.165     2.364     0.200
    73.745     1.948     0.200
    73.661    -0.958     0.200
    73.812     2.556     0.200
    73.893     2.582     0.200
    73.892     1.537     0.200
    74.090     2.329     0.200
    74.103     1.832     0.200
    74.113     1.396     0.200
    74.173     2.444     0.200
    74.191     2.441     0.200
    74.469    -0.178     0.200
    74.660     2.120     0.200
    74.660     1.811     0.200
    74.851     2.206     0.200
    74.908     1.175     0.200
    74.924     1.122     0.200
    74.957     1.165     0.200
    74.957    -0.839     0.200
    74.965     1.096     0.200
    75.157     0.941     0.200
    75.157     0.441     0.200
    75.348     0.436     0.200
    75.187     2.667     0.200
    75.472     3.261     0.200
    75.513     4.605     0.200
    75.625     2.160     0.200
    75.731     4.900     0.200
    75.811     1.161     0.200
    75.858     2.311     0.200
    75.937     2.429     0.200
    75.920    -0.775     0.200
    75.940    -1.668     0.200
    75.925     1.937     0.200
    76.022     2.948     0.200
    76.304     1.477     0.200
    76.306     1.857     0.200
    76.505     0.229     0.200
    76.505    -0.661     0.200
    76.505    -0.657     0.200
    76.524     0.130     0.200
    76.568     0.348     0.200
    76.872     2.074     0.200
    76.903     1.584     0.200
    77.148     0.409     0.200
    77.349     2.047     0.200
    77.919    -0.662     0.200
    77.920     1.352     0.200
    77.794     3.395     0.200
    78.375     2.671     0.200
    78.850     2.553     0.200
    79.171     2.792     0.200
    79.688     3.871     0.200
    80.117     1.250     0.200
    80.313    -1.506     0.200
    80.213     1.224     0.200
    80.511     0.328     0.200
    83.707     1.156     0.200
    83.941     0.312     0.200
    84.884     1.281     0.200
    84.947     3.567     0.200
    87.260     0.031     0.200
    87.260     0.033     0.200
    88.305     0.025     0.200
    96.248     0.332     0.200
    96.248     0.328     0.200
    14.651     4.441     0.200
    14.620     6.008     0.200
    14.896     5.743     0.200
    15.134     3.972     0.200
    15.101     7.237     0.200
    15.113     6.690     0.200
    15.344     6.267     0.200
    15.519     5.195     0.200
    16.785     2.896     0.200
    16.900     2.184     0.200
    16.798     4.104     0.200
    16.988     2.206     0.200
    17.089     2.655     0.200
    17.212     2.890     0.200
    18.003     0.887     0.200
    18.282     2.559     0.200
    18.282     2.169     0.200
    18.446     1.271     0.200
    18.446     2.232     0.200
    18.511     1.027     0.200
    18.753     0.141     0.200
    19.091    -0.666     0.200
    19.405     2.326     0.200
    19.671     2.588     0.200
    19.954     1.374     0.200
    20.079     1.622     0.200
    20.094     2.077     0.200
    20.613     3.507     0.200
    20.795     1.114     0.200
    20.795     1.325     0.200
    21.210     2.426     0.200
    21.504     0.682     0.200
    21.504     0.995     0.200
    21.241     2.477     0.200
    21.546     1.028     0.200
    21.546     1.704     0.200
    22.163     1.540     0.200
    22.268     2.567     0.200
    22.845     1.911     0.200
    23.283     1.611     0.200
    23.283     2.095     0.200
    23.232     2.832     0.200
    23.594     0.130     0.200
    23.758     1.434     0.200
    23.995     0.656     0.200
    23.995     1.324     0.200
    25.030     3.137     0.200
    25.341     1.288     0.200
    25.341     0.698     0.200
    25.612     1.831     0.200
    27.077     4.014     0.200
    31.435     0.719     0.200
    31.522     0.799     0.200
    31.523     1.367     0.200
    31.766    -0.269     0.200
    31.838     0.364     0.200
    32.003     0.452     0.200
    32.063     0.667     0.200
    32.129     0.310     0.200
    32.175     0.291     0.200
    32.977     0.025     0.200
    33.021    -0.209     0.200
    33.008     1.403     0.200
    48.688    -1.768     0.200
    48.688     0.138     0.200
    54.870    -1.868     0.200
    63.073    -0.112     0.200
    73.089     0.815     0.200
    74.096     1.251     0.200
    74.639     0.394     0.200
    74.935     0.854     0.200
    76.375     0.630     0.200
    76.583    -0.596     0.200
    77.863     0.621     0.200
    77.882     4.569     0.200
    78.960     2.611     0.200
    15.165     7.354     0.200
    15.165     6.932     0.200
    15.333     5.769     0.200
    16.005     2.845     0.200
    16.482     4.573     0.200
    16.968     3.516     0.200
    16.839     4.516     0.200
    17.057     4.983     0.200
    17.105     5.389     0.200
    17.274     3.280     0.200
    17.495     2.308     0.200
    17.763     2.952     0.200
    18.079     1.347     0.200
    18.036     2.692     0.200
    18.561     2.019     0.200
    18.561     2.414     0.200
    18.815     1.723     0.200
    18.971     1.749     0.200
    19.202     1.603     0.200
    19.451     2.417     0.200
    19.710     2.842     0.200
    19.710     3.413     0.200
    19.816     2.326     0.200
    19.907     1.796     0.200
    20.015     1.879     0.200
    20.024     2.369     0.200
    20.150     0.767     0.200
    20.150     1.236     0.200
    20.157     1.955     0.200
    20.064     3.057     0.200
    20.223     2.205     0.200
    20.164     3.305     0.200
    20.315     2.184     0.200
    20.287     1.983     0.200
    20.397     2.476     0.200
    20.390     2.813     0.200
    20.343     2.800     0.200
    20.583     3.610     0.200
    20.655     2.629     0.200
    20.655     3.238     0.200
    20.716     2.223     0.200
    20.861     1.921     0.200
    20.861     2.242     0.200
    20.804     2.739     0.200
    20.887     2.896     0.200
    21.253     2.660     0.200
    21.583     1.104     0.200
    21.583     0.936     0.200
    21.615     0.382     0.200
    21.615     1.382     0.200
    21.623     0.936     0.200
    21.574     1.789     0.200
    21.610     1.417     0.200
    21.528     1.838     0.200
    21.559     2.291     0.200
    21.673     1.703     0.200
    21.633     2.099     0.200
    21.715     1.884     0.200
    21.728     1.586     0.200
    21.726     1.657     0.200
    21.778     1.763     0.200
    21.794     1.359     0.200
    21.828     1.476     0.200
    21.828     1.308     0.200
    21.859     1.356     0.200
    21.882     1.542     0.200
    21.880     1.123     0.200
    21.906     0.950     0.200
    21.908     1.016     0.200
    21.991     1.481     0.200
    21.999     1.425     0.200
    22.026     2.115     0.200
    22.140     1.533     0.200
    22.114     2.309     0.200
    22.312     2.224     0.200
    22.334     1.390     0.200
    22.924    -0.993     0.200
    22.924    -0.470     0.200
    22.630     2.600     0.200
    22.805     1.568     0.200
    22.876     1.232     0.200
    22.876     1.661     0.200
    22.918     1.535     0.200
    22.918     1.843     0.200
    22.939     2.790     0.200
    23.038     0.057     0.200
    23.347     1.218     0.200
    23.347     1.730     0.200
    23.272     2.087     0.200
    23.615     1.178     0.200
    23.674     0.312     0.200
    23.674    -0.707     0.200
    23.408     1.565     0.200
    23.408     2.580     0.200
    23.681     1.610     0.200
    23.831     1.078     0.200
    23.831     1.441     0.200
    24.061     1.982     0.200
    24.282     2.094     0.200
    25.096     2.001     0.200
    25.096     1.603     0.200
    25.184     2.086     0.200
    25.418     1.619     0.200
    25.672    -0.169     0.200
    25.750     2.046     0.200
    25.750     1.855     0.200
    26.474     0.744     0.200
    26.559     1.648     0.200
    27.044     1.146     0.200
    27.044     2.451     0.200
    27.156     2.509     0.200
    27.759     3.566     0.200
    28.162     1.254     0.200
    28.801     1.444     0.200
    29.963     1.158     0.200
    30.998     0.473     0.200
    31.080     0.322     0.200
    31.511     0.376     0.200
    31.488     0.470     0.200
    31.651     0.243     0.200
    31.651     0.130     0.200
    31.659     0.531     0.200
    31.581     0.844     0.200
    31.581     0.835     0.200
    31.842     0.112     0.200
    31.861    -0.149     0.200
    31.913    -0.006     0.200
    32.079    -0.010     0.200
    32.084     0.425     0.200
    32.115     0.742     0.200
    32.137     0.580     0.200
    32.205     0.769     0.200
    32.249     0.499     0.200
    32.445     0.726     0.200
    32.434    -0.390     0.200
    32.536    -0.458     0.200
    32.502     0.751     0.200
    32.644     0.176     0.200
    32.728    -0.359     0.200
    32.793     0.748     0.200
    32.843    -0.218     0.200
    33.051    -0.139     0.200
    33.097    -0.051     0.200
    33.080     1.098     0.200
    33.080     1.340     0.200
    33.210    -0.291     0.200
    33.264     0.214     0.200
    33.264     0.081     0.200
    33.290    -0.140     0.200
    33.408    -0.100     0.200
    33.407    -0.931     0.200
    33.714     0.260     0.200
    34.114     1.496     0.200
    34.433     0.162     0.200
    34.446     0.182     0.200
    34.570     2.041     0.200
    34.775     0.204     0.200
    34.959     0.054     0.200
    34.959     0.444     0.200
    35.156     0.660     0.200
    35.268     0.437     0.200
    35.531     0.295     0.200
    35.469     0.591     0.200
    35.447     0.559     0.200
    35.556    -0.136     0.200
    35.556     0.090     0.200
    35.619     0.267     0.200
    35.746    -1.890     0.200
    35.787     0.035     0.200
    36.027    -0.397     0.200
    36.121    -0.273     0.200
    36.558     1.583     0.200
    36.998    -1.450     0.200
    37.013     0.111     0.200
    37.008    -0.447     0.200
    37.297     0.587     0.200
    37.457     0.463     0.200
    37.576    -0.079     0.200
    37.839     0.021     0.200
    37.900     0.061     0.200
    38.149     0.335     0.200
    38.163    -1.187     0.200
    38.163    -0.816     0.200
    38.179     0.558     0.200
    38.301    -0.633     0.200
    38.244     0.352     0.200
    38.448     0.143     0.200
    38.448     0.397     0.200
    38.452     0.568     0.200
    38.775     0.259     0.200
    38.739     0.562     0.200
    38.800    -0.369     0.200
    38.860     0.599     0.200
    38.905     0.743     0.200
    39.185     0.273     0.200
    39.227     0.172     0.200
    39.903     0.344     0.200
    40.035     0.174     0.200
    43.674     0.306     0.200
    44.448     0.328     0.200
    48.647     0.952     0.200
    54.857     0.242     0.200
    57.833     0.594     0.200
    59.341     0.852     0.200
    61.474     2.125     0.200
    61.474     2.126     0.200
    63.108    -0.245     0.200
    63.108    -0.245     0.200
    66.175    -0.651     0.200
    68.922     1.236     0.200
    71.393     1.028     0.200
    71.414     1.334     0.200
    71.874    -0.118     0.200
    72.509     0.921     0.200
    72.972    -0.140     0.200
    73.127     0.814     0.200
    73.589     1.428     0.200
    74.132     1.642     0.200
    74.215     1.162     0.200
    74.488     1.369     0.200
    74.678     1.220     0.200
    74.678     1.673     0.200
    74.928     0.822     0.200
    74.928     0.923     0.200
    74.946     0.619     0.200
    74.952     1.286     0.200
    74.974    -0.370     0.200
    74.992     1.151     0.200
    75.176     1.390     0.200
    75.367     0.988     0.200
    75.486     1.913     0.200
    75.827     2.157     0.200
    75.873     1.961     0.200
    75.888     1.673     0.200
    75.951     1.860     0.200
    75.948    -1.183     0.200
    75.948    -0.273     0.200
    75.953    -0.471     0.200
    76.207     0.792     0.200
    76.325     0.192     0.200
    76.410     1.034     0.200
    76.560    -0.566     0.200
    76.560    -0.566     0.200
    76.890     1.343     0.200
    77.169     1.554     0.200
    77.319     0.378     0.200
    77.673    -0.167     0.200
    77.919     0.037     0.200
    77.920     0.418     0.200
    78.369     0.818     0.200
    78.396     0.821     0.200
    78.400     2.100     0.200
    78.777     0.818     0.200
    79.196     1.420     0.200
    79.710     1.019     0.200
    80.140     0.691     0.200
    80.338     1.725     0.200
    80.341     1.107     0.200
    80.491     0.905     0.200
    80.533     0.776     0.200
    80.569     0.786     0.200
    81.219     1.411     0.200
    82.928     0.542     0.200
    83.977     0.345     0.200
    84.939     0.973     0.200
    87.289     0.570     0.200
    87.289     0.568     0.200
    88.242    -0.060     0.200
    88.242    -0.415     0.200
    18.400     1.284     0.200
    21.762     1.370     0.200
    31.626    -0.095     0.200
    31.626    -0.096     0.200
    38.213     0.093     0.200
    38.213    -0.633     0.200
    38.821    -0.083     0.200
    38.949     1.790     0.200
    43.643     0.520     0.200
    57.138    -0.974     0.200
    57.138    -0.974     0.200
    59.295     2.040     0.200
    61.425     3.584     0.200
    61.425     3.582     0.200
    62.974    -1.489     0.200
    63.115     0.836     0.200
    63.115     0.829     0.200
    64.427     0.380     0.200
    64.648    -0.859     0.200
    66.356     4.163     0.200
    66.356     4.162     0.200
    66.356     4.162     0.200
    67.969     3.208     0.200
    68.007     6.061     0.200
    69.286     2.161     0.200
    72.519     0.773     0.200
    73.136     0.557     0.200
    73.689     0.648     0.200
    73.796     0.022     0.200
    74.140     1.506     0.200
    74.496     1.332     0.200
    74.687     1.426     0.200
    74.935     0.890     0.200
    74.984     1.008     0.200
    74.992     0.690     0.200
    75.184     0.829     0.200
    75.184     0.954     0.200
    75.376    -0.148     0.200
    75.949    -1.098     0.200
    75.949    -1.106     0.200
    76.532    -0.185     0.200
    76.532    -0.185     0.200
    77.942     0.872     0.200
    77.943     0.796     0.200
    83.677     1.175     0.200
    87.288    -0.310     0.200
    87.289    -0.312     0.200
    88.289     0.190     0.200
    96.268     0.510     0.200
    16.614     5.418     0.200
    17.675     2.973     0.200
    17.602     3.157     0.200
    20.822     2.061     0.200
    22.937    -1.609     0.200
    25.528     1.214     0.200
    25.936     0.701     0.200
    31.858     1.061     0.200
    38.675     1.141     0.200
    40.257     1.242     0.200
    43.308     0.486     0.200
    44.111    -0.588     0.200
    48.310     1.234     0.200
    59.076     0.412     0.200
    62.774    -0.048     0.200
    62.774     0.225     0.200
    62.599     1.216     0.200
    67.671     1.079     0.200
    68.945    -0.050     0.200
    71.307    -0.691     0.200
    72.186     0.425     0.200
    72.802     1.207     0.200
    73.263     1.116     0.200
    73.803     0.939     0.200
    74.356     1.413     0.200
    74.652    -1.209     0.200
    74.985    -3.236     0.200
    75.999     0.898     0.200
    76.078     1.099     0.200
    76.189    -0.090     0.200
    77.338     0.878     0.200
    78.116     0.335     0.200
    81.498     0.626     0.200
    81.785     0.719     0.200
    82.021     0.407     0.200
    82.275     0.864     0.200
    82.548     1.783     0.200
    84.565     2.829     0.200
    86.932     0.120     0.200
    88.488    -1.004     0.200
    88.972    -0.488     0.200
    96.011     0.717     0.200
    14.404     7.861     0.200
    15.513     2.072     0.200
    16.170     6.554     0.200
    16.369     3.645     0.200
    16.352     4.657     0.200
    16.577     7.270     0.200
    16.670     4.448     0.200
    16.796     3.513     0.200
    16.899     6.076     0.200
    16.981     3.584     0.200
    16.983     3.404     0.200
    16.927     5.367     0.200
    16.963     5.277     0.200
    17.010     4.536     0.200
    17.149     3.554     0.200
    17.163     4.631     0.200
    17.175     4.980     0.200
    17.438     4.758     0.200
    17.802     0.546     0.200
    17.749     3.014     0.200
    17.829     3.991     0.200
    17.932     2.542     0.200
    17.932     1.708     0.200
    17.997     1.832     0.200
    17.875     4.079     0.200
    17.999     3.664     0.200
    18.281     2.966     0.200
    18.281     2.983     0.200
    18.343     0.530     0.200
    18.410     1.868     0.200
    18.410     1.157     0.200
    18.603     2.314     0.200
    18.603     0.970     0.200
    19.223     2.591     0.200
    19.253     2.682     0.200
    19.435     2.538     0.200
    19.514     2.882     0.200
    19.514     2.357     0.200
    19.578     3.064     0.200
    19.617     2.823     0.200
    19.689     2.357     0.200
    19.811     2.022     0.200
    19.807     2.695     0.200
    20.058     1.988     0.200
    20.058     1.486     0.200
    20.066     2.752     0.200
    20.249     2.777     0.200
    20.254     3.005     0.200
    20.338     2.593     0.200
    20.341     2.114     0.200
    20.399     3.267     0.200
    20.611     2.556     0.200
    20.611     1.689     0.200
    20.746     2.597     0.200
    20.736     2.876     0.200
    20.736     2.458     0.200
    20.811     2.367     0.200
    20.811     2.060     0.200
    20.819     3.147     0.200
    20.957     2.408     0.200
    21.023     2.035     0.200
    21.253     2.966     0.200
    21.257     2.651     0.200
    21.392     1.355     0.200
    21.333     2.664     0.200
    21.378     2.543     0.200
    21.539     1.850     0.200
    21.539     0.368     0.200
    21.550     2.986     0.200
    21.584     3.732     0.200
    21.647     2.857     0.200
    21.620     2.297     0.200
    21.658     2.693     0.200
    21.691     2.844     0.200
    21.700     2.586     0.200
    21.701     1.727     0.200
    21.754     2.907     0.200
    21.770     1.766     0.200
    21.803     2.079     0.200
    21.804     1.854     0.200
    21.844     0.597     0.200
    21.834     1.854     0.200
    21.856     1.949     0.200
    21.856     1.513     0.200
    21.881     1.405     0.200
    21.887     2.219     0.200
    21.967     1.578     0.200
    21.973     1.906     0.200
    22.077     2.312     0.200
    22.114     1.971     0.200
    22.118     2.461     0.200
    22.179     2.071     0.200
    22.195     2.106     0.200
    22.228     3.147     0.200
    22.372     1.697     0.200
    22.372     1.826     0.200
    22.374     1.762     0.200
    22.384     2.940     0.200
    22.379     1.827     0.200
    22.476     3.292     0.200
    22.476     2.120     0.200
    22.425     2.374     0.200
    22.698     0.251     0.200
    22.698     2.097     0.200
    22.658     2.366     0.200
    22.708     1.025     0.200
    22.828     2.032     0.200
    22.858     1.771     0.200
    22.858     1.543     0.200
    22.986     1.826     0.200
    22.986     1.979     0.200
    23.032     1.534     0.200
    23.135     0.757     0.200
    23.211     1.216     0.200
    23.320     0.275     0.200
    23.320     0.570     0.200
    23.310     1.772     0.200
    23.310     1.135     0.200
    23.466     1.252     0.200
    23.466    -0.058     0.200
    23.363     1.243     0.200
    23.444     2.106     0.200
    23.484     1.630     0.200
    23.484     1.023     0.200
    23.727     2.008     0.200
    23.727     0.135     0.200
    23.714     3.025     0.200
    23.917     2.045     0.200
    23.917     1.547     0.200
    24.013     2.012     0.200
    24.013     1.369     0.200
    24.150     2.363     0.200
    24.300     1.593     0.200
    24.685     1.864     0.200
    24.685     1.520     0.200
    25.045     1.295     0.200
    25.045     0.817     0.200
    25.258     1.079     0.200
    25.258     0.493     0.200
    25.246     2.599     0.200
    25.656     0.929     0.200
    25.656     1.554     0.200
    25.656     1.316     0.200
    25.705     1.430     0.200
    25.749     3.880     0.200
    25.791     1.871     0.200
    25.791     1.711     0.200
    26.020     1.926     0.200
    26.257     0.859     0.200
    26.257     0.412     0.200
    26.203     1.920     0.200
    26.563    -0.249     0.200
    26.563    -0.424     0.200
    26.461     1.513     0.200
    26.766     2.527     0.200
    26.958     1.579     0.200
    26.962     1.442     0.200
    27.250     1.675     0.200
    27.972     0.369     0.200
    28.084     1.028     0.200
    28.197     2.439     0.200
    28.197     1.531     0.200
    28.353     2.778     0.200
    28.314     1.617     0.200
    28.314     1.820     0.200
    28.444     0.764     0.200
    28.576     2.413     0.200
    28.800     1.876     0.200
    28.800     0.823     0.200
    29.410     1.018     0.200
    29.892     1.538     0.200
    29.892     1.204     0.200
    30.735     1.478     0.200
    30.735     0.579     0.200
    31.014     2.253     0.200
    31.365    -1.439     0.200
    31.496    -1.492     0.200
    31.580     1.434     0.200
    31.580    -0.361     0.200
    31.581     1.437     0.200
    31.701     0.448     0.200
    31.745    -0.130     0.200
    31.784     1.243     0.200
    31.786     0.107     0.200
    31.940     0.019     0.200
    31.951     0.060     0.200
    32.026     0.494     0.200
    32.061     0.303     0.200
    32.130     0.445     0.200
    32.292    -0.362     0.200
    32.396    -0.284     0.200
    32.529     0.160     0.200
    32.580     0.266     0.200
    32.684     1.684     0.200
    32.932     0.053     0.200
    32.964     0.455     0.200
    32.955     0.269     0.200
    32.978     0.939     0.200
    33.098    -0.164     0.200
    33.153    -0.587     0.200
    33.559     0.196     0.200
    34.015    -0.217     0.200
    34.009     1.542     0.200
    34.174     0.247     0.200
    34.541    -0.546     0.200
    34.613     0.727     0.200
    34.609     0.517     0.200
    35.141     2.796     0.200
    35.308    -0.462     0.200
    35.431    -0.088     0.200
    35.464     0.162     0.200
    35.559     0.504     0.200
    36.010     1.790     0.200
    36.455     1.704     0.200
    36.855     0.433     0.200
    36.872    -0.919     0.200
    36.877    -2.171     0.200
    37.696    -0.067     0.200
    37.749     0.177     0.200
    37.801    -0.293     0.200
    37.989    -0.185     0.200
    38.005     0.496     0.200
    38.062    -1.014     0.200
    38.041    -0.341     0.200
    38.097    -0.390     0.200
    38.294     0.649     0.200
    38.294     0.420     0.200
    38.326     0.046     0.200
    38.577    -0.201     0.200
    38.774     0.021     0.200
    38.940     0.683     0.200
    39.073     0.159     0.200
    39.079    -0.845     0.200
    39.503    -1.522     0.200
    39.729    -0.391     0.200
    39.757    -0.382     0.200
    39.882     0.168     0.200
    40.537     1.341     0.200
    40.539     1.319     0.200
    40.880    -0.087     0.200
    40.999     1.423     0.200
    42.647    -1.423     0.200
    43.530     0.611     0.200
    48.563     0.460     0.200
    55.953     0.749     0.200
    59.356     0.074     0.200
    61.545    -0.500     0.200
    61.545    -0.499     0.200
    62.802     0.639     0.200
    62.802     0.309     0.200
    62.802     0.312     0.200
    66.433     0.181     0.200
    66.433     0.183     0.200
    67.260     1.431     0.200
    67.924    -0.179     0.200
    67.924    -0.179     0.200
    69.149     0.158     0.200
    69.153     0.138     0.200
    71.574     1.876     0.200
    72.817     1.139     0.200
    74.663     1.155     0.200
    75.188     1.298     0.200
    75.656    -0.799     0.200
    75.656    -0.799     0.200
    76.401     0.419     0.200
    76.401     0.413     0.200
    77.599     0.196     0.200
    77.717     3.440     0.200
    78.387     0.218     0.200
    78.856     1.134     0.200
    80.035     0.005     0.200
    80.035     0.841     0.200
    83.708     0.869     0.200
    87.000     0.573     0.200
    87.001     0.571     0.200
    88.206    -0.040     0.200
    88.206     0.066     0.200
    19.611     1.672     0.200
    19.906     2.145     0.200
    20.405     2.152     0.200
    25.497     1.358     0.200
    31.671     2.791     0.200
    31.671     2.791     0.200
    63.082     0.936     0.200
    63.082     0.940     0.200
    74.954     1.760     0.200
    15.527     2.334     0.200
    17.584     2.760     0.200
    18.528     4.060     0.200
    30.140     1.558     0.200
    31.793    -0.471     0.200
    38.758     0.595     0.200
    43.421     0.751     0.200
    69.064     0.079     0.200
    74.788     0.532     0.200
    76.306     0.379     0.200
    77.787     0.879     0.200
    88.438     0.317     0.200
    14.069     8.346     0.200
    17.402     3.099     0.200
    18.251     2.345     0.200
    31.556     2.598     0.200
    76.409    -0.076     0.200
    22.816    -0.639     0.200
    25.407     0.931     0.200
    26.499     2.297     0.200
    26.499     0.457     0.200
    30.066     0.471     0.200
    31.763    -0.067     0.200
    31.763    -0.073     0.200
    62.731    -0.086     0.200
    62.731    -0.087     0.200
    76.234     0.118     0.200
    76.234     0.113     0.200
    14.039     4.726     0.200
    14.023    10.633     0.200
    14.143     5.580     0.200
    14.380     9.234     0.200
    14.550     5.427     0.200
    14.669     3.609     0.200
    15.293     7.942     0.200
    15.421     8.536     0.200
    16.018     7.071     0.200
    16.159     2.721     0.200
    16.473     2.433     0.200
    16.853     2.359     0.200
    16.809     2.446     0.200
    16.954     2.818     0.200
    16.958     7.330     0.200
    17.040     2.187     0.200
    17.040     2.347     0.200
    17.039     3.781     0.200
    16.999     3.880     0.200
    17.039     3.628     0.200
    17.205     2.307     0.200
    17.219     2.868     0.200
    17.230     3.020     0.200
    17.196     3.683     0.200
    17.297     2.079     0.200
    17.492     2.960     0.200
    17.453     3.532     0.200
    17.509     2.569     0.200
    17.798     3.020     0.200
    17.860     2.545     0.200
    17.995     2.171     0.200
    17.995     2.351     0.200
    17.952     1.917     0.200
    18.050     2.678     0.200
    18.336     3.662     0.200
    18.336     1.363     0.200
    18.337     3.800     0.200
    18.337     3.677     0.200
    18.409     0.889     0.200
    20.356     0.962     0.200
    20.218     2.396     0.200
    20.433     1.908     0.200
    20.672     1.477     0.200
    20.769     2.111     0.200
    21.032     0.961     0.200
    21.160     2.344     0.200
    21.282     2.904     0.200
    21.458     1.823     0.200
    21.366     2.452     0.200
    21.596     1.721     0.200
    21.595     2.032     0.200
    21.595     1.045     0.200
    21.600     3.397     0.200
    21.634     3.272     0.200
    21.697     1.938     0.200
    21.666     2.409     0.200
    21.701     2.985     0.200
    21.740     3.217     0.200
    21.750     3.865     0.200
    21.751     2.921     0.200
    21.804     3.230     0.200
    21.819     2.922     0.200
    21.853     2.344     0.200
    21.854     2.499     0.200
    21.884     2.977     0.200
    21.906     2.581     0.200
    21.906     3.019     0.200
    21.931     2.299     0.200
    21.936     2.760     0.200
    22.017     2.454     0.200
    22.023     3.040     0.200
    22.144     0.781     0.200
    22.144    -0.697     0.200
    22.164     2.305     0.200
    22.232     2.534     0.200
    22.228     1.612     0.200
    22.403     1.090     0.200
    22.419     2.699     0.200
    22.456    -0.049     0.200
    22.531     4.162     0.200
    22.531     1.639     0.200
    22.765    -0.020     0.200
    22.765     0.213     0.200
    22.742     1.306     0.200
    22.871     2.169     0.200
    22.907     1.994     0.200
    22.907     1.734     0.200
    23.361     2.520     0.200
    23.361     1.934     0.200
    23.375     0.812     0.200
    23.533     0.917     0.200
    23.533     0.386     0.200
    23.786     1.929     0.200
    23.786     1.667     0.200
    23.755     4.591     0.200
    24.066     2.202     0.200
    24.066     1.595     0.200
    24.268    -1.190     0.200
    24.344     2.668     0.200
    24.742     2.591     0.200
    24.742     1.649     0.200
    25.121     1.200     0.200
    25.322     1.153     0.200
    25.322     0.557     0.200
    25.283     1.500     0.200
    25.705    -0.396     0.200
    25.705     3.668     0.200
    25.705     1.535     0.200
    25.884     1.892     0.200
    25.831     1.363     0.200
    26.597     0.442     0.200
    26.597     3.120     0.200
    26.597    -0.790     0.200
    27.024    -0.378     0.200
    27.007     2.047     0.200
    27.791     1.371     0.200
    28.251     3.338     0.200
    28.251     0.418     0.200
    28.366     3.683     0.200
    28.366    -0.045     0.200
    29.948     2.082     0.200
    29.948     1.556     0.200
    31.119     1.184     0.200
    31.428    -0.604     0.200
    31.626     2.458     0.200
    31.627     1.383     0.200
    31.764    -0.396     0.200
    31.976     2.051     0.200
    32.003     0.333     0.200
    32.003     0.018     0.200
    32.013    -0.512     0.200
    32.355    -1.544     0.200
    32.366    -1.065     0.200
    32.459    -0.281     0.200
    32.456    -0.005     0.200
    32.682    -0.694     0.200
    32.656     2.536     0.200
    32.656    -0.017     0.200
    32.739     0.643     0.200
    32.772    -0.522     0.200
    32.993    -0.355     0.200
    33.037     1.672     0.200
    33.037     0.590     0.200
    33.215    -0.277     0.200
    34.070     0.280     0.200
    34.192     0.026     0.200
    34.595     4.491     0.200
    34.595     2.083     0.200
    34.677     0.644     0.200
    35.177     2.074     0.200
    35.195     3.028     0.200
    35.357     1.127     0.200
    35.372     0.075     0.200
    35.370    -0.611     0.200
    35.493     0.440     0.200
    35.493    -0.773     0.200
    35.527    -0.462     0.200
    35.708     0.229     0.200
    35.955     0.301     0.200
    36.015    -1.471     0.200
    36.048    -0.105     0.200
    36.259     0.102     0.200
    36.291    -0.458     0.200
    36.502    -2.546     0.200
    36.512    -1.172     0.200
    36.523    -0.230     0.200
    36.528     1.107     0.200
    36.515     0.861     0.200
    36.617    -1.419     0.200
    36.840     1.213     0.200
    36.919    -0.201     0.200
    36.934    -0.297     0.200
    36.940     0.214     0.200
    36.986    -1.755     0.200
    37.376     3.618     0.200
    37.455    -0.697     0.200
    37.724    -0.580     0.200
    37.759     0.513     0.200
    37.813     0.151     0.200
    37.824     0.901     0.200
    37.955    -0.799     0.200
    38.053    -0.219     0.200
    38.103    -0.320     0.200
    38.161     1.008     0.200
    38.161    -0.970     0.200
    38.226    -0.643     0.200
    38.358     0.247     0.200
    38.358    -0.456     0.200
    38.387     0.083     0.200
    38.455    -0.653     0.200
    38.437     0.301     0.200
    38.641    -1.106     0.200
    38.639     0.420     0.200
    38.712     0.437     0.200
    38.766     0.668     0.200
    38.836    -0.238     0.200
    39.070     0.464     0.200
    39.137    -0.447     0.200
    39.413     0.179     0.200
    39.564    -1.016     0.200
    39.565     0.635     0.200
    39.821    -0.947     0.200
    39.918    -2.708     0.200
    39.946     0.145     0.200
    40.943    -1.239     0.200
    41.821     2.077     0.200
    41.821     1.888     0.200
    44.175     0.128     0.200
    59.307    -0.133     0.200
    62.833     0.205     0.200
    62.833     0.141     0.200
    64.790    -0.017     0.200
    66.471    -1.241     0.200
    67.316     2.360     0.200
    67.878     0.258     0.200
    67.891     0.131     0.200
    68.937     2.873     0.200
    69.137     0.110     0.200
    69.137     0.060     0.200
    69.137    -0.470     0.200
    71.534     1.599     0.200
    72.762     0.417     0.200
    72.851     0.650     0.200
    73.525     0.195     0.200
    73.839     1.750     0.200
    74.401     1.668     0.200
    74.401     1.309     0.200
    74.653     0.747     0.200
    74.698     0.806     0.200
    74.706     0.612     0.200
    74.901     0.912     0.200
    75.092     0.609     0.200
    75.552     1.864     0.200
    75.680    -0.621     0.200
    75.926     2.268     0.200
    75.932    -0.006     0.200
    76.136     0.630     0.200
    76.384     0.189     0.200
    76.384     0.220     0.200
    76.404    -0.292     0.200
    76.447     0.383     0.200
    77.648     0.742     0.200
    77.649     0.903     0.200
    77.729    -0.493     0.200
    77.694     1.350     0.200
    78.818     1.227     0.200
    80.096     0.946     0.200
    82.083     0.895     0.200
    83.293     0.690     0.200
    83.722     0.564     0.200
    84.755     3.538     0.200
    85.745     1.244     0.200
    87.023     0.501     0.200
    88.258    -0.252     0.200
    15.539     2.671     0.200
    18.012     1.817     0.200
    18.276     3.927     0.200
    18.276     3.627     0.200
    22.709     1.730     0.200
    25.261     1.391     0.200
    31.570     1.702     0.200
    31.570     1.697     0.200
    69.171    -0.183     0.200
    69.175    -0.207     0.200
    76.423    -0.433     0.200
    76.423    -0.003     0.200
    76.423    -0.008     0.200
    76.423    -0.195     0.200
    76.443    -0.494     0.200
    76.486    -0.430     0.200
    18.434    -0.657     0.200
    31.745    -0.161     0.200
    68.994    -0.313     0.200
    76.242    -0.328     0.200
    14.368     9.082     0.200
    14.688     8.687     0.200
    16.904     5.862     0.200
    18.148     3.167     0.200
    18.148     5.179     0.200
    22.628     1.343     0.200
    25.155     1.802     0.200
    26.648     1.918     0.200
    29.759     2.099     0.200
    31.434     1.613     0.200
    31.434     2.011     0.200
    69.303    -0.071     0.200
    76.552     0.267     0.200
    76.844    -0.164     0.200
    87.107    -1.033     0.200
    88.066    -0.159     0.200
    14.057     8.286     0.200
    14.173     9.400     0.200
    14.413     8.618     0.200
    14.844     7.167     0.200
    15.637     4.287     0.200
    16.157     3.202     0.200
    22.169    -0.943     0.200
    28.879    -0.504     0.200
    28.883    -0.631     0.200
    29.009    -1.281     0.200
    31.039     0.590     0.200
    39.152    -1.827     0.200
    40.085    -1.043     0.200
    62.763     0.419     0.200
    69.003     0.355     0.200
    69.003    -0.235     0.200
    69.003     0.456     0.200
    71.394    -0.528     0.200
    73.394     0.499     0.200
    75.595    -0.532     0.200
    76.250    -0.098     0.200
    76.250     0.430     0.200
    76.250     0.101     0.200
    76.313     0.091     0.200
    77.621     1.075     0.200
    77.557     2.845     0.200
    14.365     9.695     0.200
    15.336     5.717     0.200
    15.593     3.928     0.200
    16.222     5.035     0.200
    16.359     5.537     0.200
    16.763     2.886     0.200
    16.787     4.262     0.200
    18.450     3.209     0.200
    22.813     0.324     0.200
    26.502     1.992     0.200
    30.061     1.430     0.200
    31.757    -0.796     0.200
    57.087     0.289     0.200
    68.993    -0.769     0.200
    72.638    -0.915     0.200
    73.489    -0.244     0.200
    76.240     0.154     0.200
    77.589    -0.785     0.200
    14.992     3.189     0.200
    15.564     6.103     0.200
    15.744     2.641     0.200
    15.847     5.591     0.200
    15.915     3.447     0.200
    16.296     2.314     0.200
    17.371     4.736     0.200
    17.499     3.518     0.200
    17.807     4.979     0.200
    19.266     3.986     0.200
    21.801     2.059     0.200
    22.151     1.400     0.200
    31.877     1.182     0.200
    73.370     0.643     0.200
    76.119     0.570     0.200
    14.800     9.169     0.200
    15.212     8.320     0.200
    15.508     4.893     0.200
    16.092     1.840     0.200
    16.103     3.608     0.200
    16.241     4.551     0.200
    16.556     3.666     0.200
    16.542     3.550     0.200
    17.064     3.985     0.200
    16.939     4.165     0.200
    17.241     4.015     0.200
    17.423     3.000     0.200
    18.125     1.681     0.200
    18.556     0.532     0.200
    21.093     3.118     0.200
    21.669     0.384     0.200
    21.797     1.107     0.200
    22.042     1.882     0.200
    22.147     1.015     0.200
    22.169     2.696     0.200
    22.256     2.830     0.200
    22.261     2.702     0.200
    22.870     0.167     0.200
    24.373     1.695     0.200
    31.873     1.501     0.200
    62.663     0.255     0.200
    62.663     0.218     0.200
    63.974     0.279     0.200
    68.874     0.310     0.200
    72.524     0.280     0.200
    73.264     0.972     0.200
    73.371     0.340     0.200
    74.540     1.622     0.200
    76.121     0.439     0.200
    77.554     0.322     0.200
    88.490    -0.113     0.200
    15.482     2.336     0.200
    15.928     1.879     0.200
    16.647     0.908     0.200
    16.689     1.320     0.200
    17.073     0.593     0.200
    17.819     0.502     0.200
    17.944     0.717     0.200
    18.038    -0.043     0.200
    18.563    -0.323     0.200
    20.871     0.998     0.200
    22.168     0.738     0.200
    22.887     2.303     0.200
    22.887     0.303     0.200
    31.876     2.105     0.200
    31.876     0.558     0.200
    68.883     0.462     0.200
    68.883     0.071     0.200
    73.380     0.466     0.200
    76.128     0.801     0.200
    76.192     0.660     0.200
    77.575     1.417     0.200
    15.933     2.900     0.200
    16.052     4.442     0.200
    16.111     3.203     0.200
    16.183     2.043     0.200
    16.272     2.929     0.200
    16.289     3.017     0.200
    16.640     1.928     0.200
    16.823     2.706     0.200
    16.822     2.403     0.200
    16.954     3.204     0.200
    17.080     1.266     0.200
    17.097     2.156     0.200
    17.102     1.905     0.200
    17.119     2.589     0.200
    17.194     2.789     0.200
    17.288     1.951     0.200
    17.571     1.907     0.200
    17.646     0.816     0.200
    17.787     1.006     0.200
    17.894     3.962     0.200
    17.894     2.782     0.200
    17.984     0.738     0.200
    18.023     1.409     0.200
    18.152     0.905     0.200
    18.277     0.339     0.200
    18.332     1.017     0.200
    18.331     0.449     0.200
    18.332     4.439     0.200
    18.332     1.208     0.200
    18.361     0.152     0.200
    19.785     0.806     0.200
    20.893     0.739     0.200
    20.921     0.492     0.200
    21.295     0.522     0.200
    21.837     0.116     0.200
    21.874     0.242     0.200
    21.987    -0.055     0.200
    21.991    -0.138     0.200
    22.018     0.536     0.200
    22.175     0.687     0.200
    22.515    -0.107     0.200
    23.043     0.334     0.200
    25.577     0.428     0.200
    30.918     0.663     0.200
    31.829     3.232     0.200
    33.366    -0.343     0.200
    53.900     0.419     0.200
    53.900    -0.264     0.200
    56.958     0.227     0.200
    66.295     0.763     0.200
    67.454     0.337     0.200
    68.462     0.086     0.200
    68.462    -0.367     0.200
    71.999     0.666     0.200
    72.816    -0.404     0.200
    72.922     0.079     0.200
    73.677    -0.023     0.200
    74.688     0.025     0.200
    75.725     0.378     0.200
    75.725    -0.044     0.200
    75.785    -0.293     0.200
    76.648    -0.482     0.200
    76.884    -0.298     0.200
    82.778     0.649     0.200
    86.036     0.480     0.200
    14.515     4.904     0.200
    17.131     2.394     0.200
    17.924     3.338     0.200
    17.932     2.457     0.200
    18.143     4.423     0.200
    18.299     3.131     0.200
    18.307     2.162     0.200
    20.000    -0.593     0.200
    20.425     0.693     0.200
    20.465     0.416     0.200
    21.119     0.223     0.200
    21.167     0.413     0.200
    21.536    -0.246     0.200
    21.918    -0.484     0.200
    22.108     0.519     0.200
    22.108     1.191     0.200
    22.503     5.205     0.200
    22.533     1.328     0.200
    22.562     0.447     0.200
    22.924     3.142     0.200
    23.058     2.359     0.200
    23.058     0.890     0.200
    23.151    -0.148     0.200
    23.252     0.603     0.200
    23.331     0.707     0.200
    23.611     0.575     0.200
    23.930     0.084     0.200
    24.083     0.333     0.200
    24.106     0.227     0.200
    24.618     1.485     0.200
    24.932     1.277     0.200
    24.932     0.285     0.200
    25.711    -0.396     0.200
    25.829     0.528     0.200
    25.858     1.944     0.200
    25.858     0.124     0.200
    25.858     1.503     0.200
    25.859     0.695     0.200
    26.186     2.926     0.200
    26.186     1.735     0.200
    26.257    -0.121     0.200
    26.325    -0.171     0.200
    26.369    -0.433     0.200
    27.262     0.442     0.200
    29.048     2.158     0.200
    29.048    -0.932     0.200
    29.080     0.208     0.200
    29.894     0.195     0.200
    31.690     1.255     0.200
    31.690    -0.436     0.200
    31.716    -0.015     0.200
    31.784     0.605     0.200
    31.826     1.740     0.200
    31.831     1.803     0.200
    31.831     2.172     0.200
    32.032     1.133     0.200
    32.732     0.334     0.200
    32.866     1.943     0.200
    32.866     0.435     0.200
    33.611     0.145     0.200
    34.341    -0.937     0.200
    34.272     0.546     0.200
    35.183     2.398     0.200
    36.552     0.663     0.200
    36.552     0.093     0.200
    36.731     0.870     0.200
    37.102     0.507     0.200
    38.001     2.462     0.200
    38.877     0.037     0.200
    40.505     2.788     0.200
    40.661    -0.725     0.200
    43.032     2.941     0.200
    43.032     2.152     0.200
    53.819    -0.235     0.200
    53.819    -0.403     0.200
    55.767    -0.294     0.200
    56.950     0.123     0.200
    60.781     0.704     0.200
    61.571     0.484     0.200
    61.571    -0.887     0.200
    61.686    -0.254     0.200
    63.003     0.387     0.200
    63.196     0.169     0.200
    63.676     1.115     0.200
    63.676    -0.378     0.200
    65.144     4.318     0.200
    67.241     2.718     0.200
    67.413     3.328     0.200
    67.421     0.997     0.200
    67.421    -0.921     0.200
    68.393    -0.088     0.200
    68.393     0.170     0.200
    69.149     2.148     0.200
    71.913    -0.123     0.200
    72.675     3.717     0.200
    72.742     0.334     0.200
    72.742    -0.619     0.200
    72.848    -0.159     0.200
    73.542     0.137     0.200
    74.131     1.338     0.200
    74.520    -0.765     0.200
    74.562    -0.374     0.200
    74.567     2.509     0.200
    74.567    -0.100     0.200
    75.130     0.941     0.200
    75.219    -3.173     0.200
    75.369    -2.223     0.200
    75.658     0.157     0.200
    75.658    -1.116     0.200
    75.887     0.295     0.200
    76.508     0.613     0.200
    76.508    -0.075     0.200
    76.787    -0.833     0.200
    76.787    -0.602     0.200
    77.047     0.227     0.200
    77.122     4.541     0.200
    78.291     3.842     0.200
    78.439     3.966     0.200
    78.936     1.188     0.200
    82.663    -0.004     0.200
    84.439     3.471     0.200
    85.912    -0.705     0.200
    85.912    -0.275     0.200
    88.311    -0.189     0.200
    95.951     0.388     0.200
    98.750    -1.111     0.200
    17.937     1.345     0.200
    18.311     1.999     0.200
    31.835     0.543     0.200
    75.653     0.617     0.200
    75.386     0.013     0.200
    17.540     1.559     0.200
    18.450     0.840     0.200
    22.880     0.377     0.200
    31.731     1.198     0.200
    64.171     0.197     0.200
    69.079    -0.116     0.200
    72.736     0.024     0.200
    73.578    -0.111     0.200
    76.324     0.046     0.200
    88.367     0.419     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   102.170     0.104     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    48.172    87.273     0.200
    53.711    65.580     0.200
    66.466    34.062     0.200
    70.945    14.129     0.200
    71.949    21.565     0.200
    31.719   172.361     0.200
    77.145     7.106     0.200
    77.149     7.380     0.200
    65.880    30.882     0.200
    77.068    10.357     0.200
    79.162    10.100     0.200
    32.159   173.806     0.200
    78.877    10.258     0.200
    16.065   296.323     0.200
    76.903    12.385     0.200
    78.960    10.111     0.200
    31.581   172.312     0.200
    31.581   172.312     0.200
    76.039     7.493     0.200
    31.858   171.256     0.200
    77.338    10.878     0.200
    17.419   282.444     0.200
    78.387    10.018     0.200
    15.336   307.047     0.200
    32.549   169.287     0.200
    17.932   275.881     0.200
    31.831   170.973     0.200
    77.047     7.426     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
