#!/bin/bash
gmt begin haida1.26_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times haida1.26'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.717
    25.500   328.260
    26.000   332.792
    26.500   337.313
    27.000   341.820
    27.500   346.312
    28.000   350.784
    28.500   355.240
    29.000   359.685
    29.500   364.122
    30.000   368.550
    30.500   372.971
    31.000   377.384
    31.500   381.789
    32.000   386.186
    32.500   390.574
    33.000   394.951
    33.500   399.315
    34.000   403.666
    34.500   408.001
    35.000   412.321
    35.500   416.627
    36.000   420.917
    36.500   425.192
    37.000   429.451
    37.500   433.695
    38.000   437.923
    38.500   442.135
    39.000   446.330
    39.500   450.508
    40.000   454.669
    40.500   458.813
    41.000   462.940
    41.500   467.050
    42.000   471.143
    42.500   475.219
    43.000   479.277
    43.500   483.318
    44.000   487.341
    44.500   491.347
    45.000   495.334
    45.500   499.303
    46.000   503.255
    46.500   507.188
    47.000   511.104
    47.500   515.001
    48.000   518.880
    48.500   522.741
    49.000   526.584
    49.500   530.409
    50.000   534.215
    50.500   538.003
    51.000   541.773
    51.500   545.525
    52.000   549.258
    52.500   552.974
    53.000   556.672
    53.500   560.352
    54.000   564.014
    54.500   567.657
    55.000   571.283
    55.500   574.889
    56.000   578.477
    56.500   582.047
    57.000   585.599
    57.500   589.132
    58.000   592.647
    58.500   596.144
    59.000   599.623
    59.500   603.084
    60.000   606.526
    60.500   609.950
    61.000   613.355
    61.500   616.742
    62.000   620.111
    62.500   623.462
    63.000   626.795
    63.500   630.109
    64.000   633.406
    64.500   636.686
    65.000   639.947
    65.500   643.190
    66.000   646.415
    66.500   649.623
    67.000   652.812
    67.500   655.983
    68.000   659.135
    68.500   662.270
    69.000   665.387
    69.500   668.485
    70.000   671.565
    70.500   674.627
    71.000   677.671
    71.500   680.697
    72.000   683.704
    72.500   686.694
    73.000   689.665
    73.500   692.617
    74.000   695.551
    74.500   698.466
    75.000   701.362
    75.500   704.240
    76.000   707.100
    76.500   709.941
    77.000   712.764
    77.500   715.569
    78.000   718.356
    78.500   721.125
    79.000   723.876
    79.500   726.608
    80.000   729.322
    80.500   732.016
    81.000   734.692
    81.500   737.347
    82.000   739.984
    82.500   742.602
    83.000   745.202
    83.500   747.782
    84.000   750.343
    84.500   752.884
    85.000   755.404
    85.500   757.905
    86.000   760.386
    86.500   762.850
    87.000   765.297
    87.500   767.720
    88.000   770.108
    88.500   772.475
    89.000   774.829
    89.500   777.175
    90.000   779.512
    90.500   781.844
    91.000   784.168
    91.500   786.488
    92.000   788.802
    92.500   791.113
    93.000   793.420
    93.500   795.724
    94.000   798.024
    94.500   800.320
    95.000   802.610
    95.500   804.895
    96.000   807.173
    96.500   809.444
    97.000   811.710
    97.500   813.968
    98.000   816.220
    98.500   818.464
    99.000   820.700
    99.500   822.929
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.941
   116.000  1122.903
   116.500  1123.865
   117.000  1124.827
   117.500  1125.789
   118.000  1126.751
   118.500  1127.713
   119.000  1128.674
   119.500  1129.636
   120.000  1130.597
   120.500  1131.558
   121.000  1132.519
   121.500  1133.479
   122.000  1134.440
   122.500  1135.400
   123.000  1136.359
   123.500  1137.318
   124.000  1138.277
   124.500  1139.235
   125.000  1140.193
   125.500  1141.150
   126.000  1142.106
   126.500  1143.062
   127.000  1144.018
   127.500  1144.972
   128.000  1145.926
   128.500  1146.878
   129.000  1147.830
   129.500  1148.781
   130.000  1149.731
   130.500  1150.680
   131.000  1151.627
   131.500  1152.574
   132.000  1153.519
   132.500  1154.463
   133.000  1155.405
   133.500  1156.345
   134.000  1157.284
   134.500  1158.221
   135.000  1159.156
   135.500  1160.090
   136.000  1161.021
   136.500  1161.950
   137.000  1162.876
   137.500  1163.800
   138.000  1164.721
   138.500  1165.640
   139.000  1166.556
   139.500  1167.468
   140.000  1168.378
   140.500  1169.284
   141.000  1170.187
   141.500  1171.085
   142.000  1171.980
   142.500  1172.870
   143.000  1173.756
   143.500  1174.637
   144.000  1175.514
   144.500  1176.385
   145.000  1177.250
   145.500  1178.110
   146.000  1178.964
   146.500  1179.812
   147.000  1180.653
   147.500  1181.487
   148.000  1182.314
   148.500  1183.134
   149.000  1183.945
   149.500  1184.748
   150.000  1185.541
   150.500  1186.325
   151.000  1187.098
   151.500  1187.861
   152.000  1188.615
   152.500  1189.358
   153.000  1190.092
   153.500  1190.814
   154.000  1191.527
   154.500  1192.228
   155.000  1192.919
   155.500  1193.598
   156.000  1194.265
   156.500  1194.921
   157.000  1195.564
   157.500  1196.196
   158.000  1196.815
   158.500  1197.421
   159.000  1198.016
   159.500  1198.597
   160.000  1199.165
   160.500  1199.721
   161.000  1200.263
   161.500  1200.793
   162.000  1201.309
   162.500  1201.812
   163.000  1202.301
   163.500  1202.777
   164.000  1203.240
   164.500  1203.688
   165.000  1204.122
   165.500  1204.543
   166.000  1204.950
   166.500  1205.343
   167.000  1205.722
   167.500  1206.087
   168.000  1206.438
   168.500  1206.776
   169.000  1207.098
   169.500  1207.407
   170.000  1207.702
   170.500  1207.982
   171.000  1208.248
   171.500  1208.500
   172.000  1208.737
   172.500  1208.961
   173.000  1209.170
   173.500  1209.364
   174.000  1209.544
   174.500  1209.710
   175.000  1209.862
   175.500  1209.999
   176.000  1210.121
   176.500  1210.230
   177.000  1210.323
   177.500  1210.403
   178.000  1210.468
   178.500  1210.518
   179.000  1210.555
   179.500  1210.576
   180.000  1210.583
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.882
     1.000   992.890
     1.500   992.904
     2.000   992.924
     2.500   992.949
     3.000   992.980
     3.500   993.016
     4.000   993.058
     4.500   993.106
     5.000   993.159
     5.500   993.218
     6.000   993.282
     6.500   993.352
     7.000   993.427
     7.500   993.508
     8.000   993.595
     8.500   993.687
     9.000   993.785
     9.500   993.888
    10.000   993.997
    10.500   994.112
    11.000   994.232
    11.500   994.357
    12.000   994.488
    12.500   994.625
    13.000   994.767
    13.500   994.915
    14.000   995.068
    14.500   995.227
    15.000   995.391
    15.500   995.561
    16.000   995.736
    16.500   995.917
    17.000   996.103
    17.500   996.295
    18.000   996.492
    18.500   996.695
    19.000   996.903
    19.500   997.117
    20.000   997.336
    20.500   997.560
    21.000   997.790
    21.500   998.025
    22.000   998.266
    22.500   998.512
    23.000   998.764
    23.500   999.021
    24.000   999.283
    24.500   999.551
    25.000   999.824
    25.500  1000.103
    26.000  1000.387
    26.500  1000.676
    27.000  1000.970
    27.500  1001.270
    28.000  1001.575
    28.500  1001.886
    29.000  1002.201
    29.500  1002.522
    30.000  1002.848
    30.500  1003.180
    31.000  1003.517
    31.500  1003.859
    32.000  1004.206
    32.500  1004.558
    33.000  1004.916
    33.500  1005.279
    34.000  1005.646
    34.500  1006.020
    35.000  1006.398
    35.500  1006.781
    36.000  1007.170
    36.500  1007.563
    37.000  1007.962
    37.500  1008.366
    38.000  1008.775
    38.500  1009.189
    39.000  1009.608
    39.500  1010.032
    40.000  1010.461
    40.500  1010.895
    41.000  1011.334
    41.500  1011.777
    42.000  1012.226
    42.500  1012.680
    43.000  1013.139
    43.500  1013.603
    44.000  1014.071
    44.500  1014.545
    45.000  1015.023
    45.500  1015.506
    46.000  1015.994
    46.500  1016.487
    47.000  1016.985
    47.500  1017.487
    48.000  1017.994
    48.500  1018.506
    49.000  1019.023
    49.500  1019.544
    50.000  1020.070
    50.500  1020.601
    51.000  1021.136
    51.500  1021.677
    52.000  1022.221
    52.500  1022.771
    53.000  1023.325
    53.500  1023.883
    54.000  1024.446
    54.500  1025.014
    55.000  1025.586
    55.500  1026.163
    56.000  1026.744
    56.500  1027.329
    57.000  1027.919
    57.500  1028.514
    58.000  1029.113
    58.500  1029.716
    59.000  1030.324
    59.500  1030.936
    60.000  1031.552
    60.500  1032.173
    61.000  1032.798
    61.500  1033.427
    62.000  1034.061
    62.500  1034.699
    63.000  1035.341
    63.500  1035.987
    64.000  1036.638
    64.500  1037.292
    65.000  1037.951
    65.500  1038.614
    66.000  1039.281
    66.500  1039.952
    67.000  1040.627
    67.500  1041.306
    68.000  1041.989
    68.500  1042.676
    69.000  1043.367
    69.500  1044.062
    70.000  1044.762
    70.500  1045.465
    71.000  1046.171
    71.500  1046.882
    72.000  1047.597
    72.500  1048.315
    73.000  1049.037
    73.500  1049.763
    74.000  1050.493
    74.500  1051.227
    75.000  1051.964
    75.500  1052.705
    76.000  1053.449
    76.500  1054.198
    77.000  1054.950
    77.500  1055.705
    78.000  1056.464
    78.500  1057.227
    79.000  1057.993
    79.500  1058.763
    80.000  1059.536
    80.500  1060.313
    81.000  1061.093
    81.500  1061.877
    82.000  1062.664
    82.500  1063.454
    83.000  1064.248
    83.500  1065.045
    84.000  1065.845
    84.500  1066.649
    85.000  1067.456
    85.500  1068.266
    86.000  1069.080
    86.500  1069.897
    87.000  1070.717
    87.500  1071.540
    88.000  1072.366
    88.500  1073.195
    89.000  1074.027
    89.500  1074.863
    90.000  1075.701
    90.500  1076.543
    91.000  1077.387
    91.500  1078.235
    92.000  1079.085
    92.500  1079.938
    93.000  1080.795
    93.500  1081.654
    94.000  1082.516
    94.500  1083.381
    95.000  1084.248
    95.500  1085.119
    96.000  1085.992
    96.500  1086.868
    97.000  1087.746
    97.500  1088.628
    98.000  1089.511
    98.500  1090.398
    99.000  1091.287
    99.500  1092.179
   100.000  1093.073
   100.500  1093.970
   101.000  1094.870
   101.500  1095.772
   102.000  1096.676
   102.500  1097.583
   103.000  1098.492
   103.500  1099.404
   104.000  1100.318
   104.500  1101.234
   105.000  1102.153
   105.500  1103.074
   106.000  1103.997
   106.500  1104.923
   107.000  1105.851
   107.500  1106.781
   108.000  1107.713
   108.500  1108.647
   109.000  1109.584
   109.500  1110.522
   110.000  1111.463
   110.500  1112.406
   111.000  1113.350
   111.500  1114.297
   112.000  1115.246
   112.500  1116.197
   113.000  1117.149
   113.500  1118.104
   114.000  1119.060
   114.500  1120.019
   115.000  1120.979
   115.500  1121.941
   116.000  1122.905
   116.500  1123.870
   117.000  1124.838
   117.500  1125.807
   118.000  1126.777
   118.500  1127.750
   119.000  1128.724
   119.500  1129.700
   120.000  1130.677
   120.500  1131.656
   121.000  1132.636
   121.500  1133.619
   122.000  1134.602
   122.500  1135.587
   123.000  1136.573
   123.500  1137.561
   124.000  1138.551
   124.500  1139.541
   125.000  1140.534
   125.500  1141.527
   126.000  1142.522
   126.500  1143.518
   127.000  1144.515
   127.500  1145.514
   128.000  1146.514
   128.500  1147.514
   129.000  1148.517
   129.500  1149.520
   130.000  1150.525
   130.500  1151.530
   131.000  1152.537
   131.500  1153.544
   132.000  1154.553
   132.500  1155.563
   133.000  1156.574
   133.500  1157.585
   134.000  1158.598
   134.500  1159.612
   135.000  1160.626
   135.500  1161.642
   136.000  1162.658
   136.500  1163.675
   137.000  1164.693
   137.500  1165.712
   138.000  1166.731
   138.500  1167.751
   139.000  1168.772
   139.500  1169.794
   140.000  1170.816
   140.500  1171.839
   141.000  1172.863
   141.500  1173.887
   142.000  1174.912
   142.500  1175.937
   143.000  1176.963
   143.500  1177.990
   144.000  1179.017
   144.500  1180.044
   145.000  1181.072
   145.500  1182.100
   146.000  1183.129
   146.500  1184.158
   147.000  1185.188
   147.500  1186.217
   148.000  1187.248
   148.500  1188.278
   149.000  1189.309
   149.500  1190.340
   150.000  1191.371
   150.500  1192.403
   151.000  1193.434
   151.500  1194.466
   152.000  1195.498
   152.500  1196.531
   153.000  1197.563
   153.500  1198.595
   154.000  1199.628
   154.500  1200.660
   155.000  1201.693
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.563
   145.500  1178.386
   146.000  1180.267
   146.500  1182.184
   147.000  1184.129
   147.500  1186.097
   148.000  1188.085
   148.500  1190.091
   149.000  1192.112
   149.500  1194.148
   150.000  1196.196
   150.500  1198.255
   151.000  1200.325
   151.500  1202.405
   152.000  1204.493
   152.500  1206.590
   153.000  1208.695
   153.500  1210.807
   154.000  1212.926
   154.500  1215.052
   155.000  1217.184
   155.500  1219.321
   156.000  1221.464
   156.500  1223.611
   157.000  1225.764
   157.500  1227.921
   158.000  1230.082
   158.500  1232.247
   159.000  1234.417
   159.500  1236.589
   160.000  1238.766
   160.500  1240.945
   161.000  1243.128
   161.500  1245.313
   162.000  1247.502
   162.500  1249.692
   163.000  1251.885
   163.500  1254.081
   164.000  1256.278
   164.500  1258.478
   165.000  1260.680
   165.500  1262.883
   166.000  1265.088
   166.500  1267.295
   167.000  1269.503
   167.500  1271.713
   168.000  1273.924
   168.500  1276.136
   169.000  1278.349
   169.500  1280.564
   170.000  1282.779
   170.500  1284.995
   171.000  1287.213
   171.500  1289.431
   172.000  1291.650
   172.500  1293.869
   173.000  1296.089
   173.500  1298.309
   174.000  1300.530
   174.500  1302.752
   175.000  1304.974
   175.500  1307.196
   176.000  1309.418
   176.500  1311.640
   177.000  1313.863
   177.500  1316.086
   178.000  1318.309
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.560
   145.500  1178.187
   146.000  1179.734
   146.500  1181.223
   147.000  1182.663
   147.500  1184.057
   148.000  1185.409
   148.500  1186.721
   149.000  1187.998
   149.500  1189.247
   150.000  1190.470
   150.500  1191.671
   151.000  1192.851
   151.500  1194.011
   152.000  1195.153
   152.500  1196.278
   153.000  1197.387
   153.500  1198.481
   154.000  1199.562
   154.500  1200.631
   155.000  1201.685
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.757
     1.000   509.793
     1.500   509.854
     2.000   509.938
     2.500   510.046
     3.000   510.178
     3.500   510.333
     4.000   510.513
     4.500   510.717
     5.000   510.944
     5.500   511.196
     6.000   511.471
     6.500   511.770
     7.000   512.092
     7.500   512.438
     8.000   512.807
     8.500   513.200
     9.000   513.616
     9.500   514.056
    10.000   514.518
    10.500   515.004
    11.000   515.513
    11.500   516.045
    12.000   516.599
    12.500   517.176
    13.000   517.776
    13.500   518.398
    14.000   519.043
    14.500   519.710
    15.000   520.399
    15.500   521.110
    16.000   521.843
    16.500   522.598
    17.000   523.375
    17.500   524.173
    18.000   524.992
    18.500   525.832
    19.000   526.694
    19.500   527.577
    20.000   528.480
    20.500   529.404
    21.000   530.348
    21.500   531.313
    22.000   532.297
    22.500   533.302
    23.000   534.327
    23.500   535.371
    24.000   536.435
    24.500   537.518
    25.000   538.620
    25.500   539.741
    26.000   540.881
    26.500   542.040
    27.000   543.217
    27.500   544.412
    28.000   545.625
    28.500   546.857
    29.000   548.106
    29.500   549.372
    30.000   550.656
    30.500   551.957
    31.000   553.275
    31.500   554.610
    32.000   555.962
    32.500   557.330
    33.000   558.714
    33.500   560.114
    34.000   561.530
    34.500   562.962
    35.000   564.410
    35.500   565.873
    36.000   567.350
    36.500   568.843
    37.000   570.351
    37.500   571.873
    38.000   573.409
    38.500   574.960
    39.000   576.525
    39.500   578.104
    40.000   579.696
    40.500   581.301
    41.000   582.920
    41.500   584.552
    42.000   586.198
    42.500   587.855
    43.000   589.526
    43.500   591.208
    44.000   592.903
    44.500   594.610
    45.000   596.329
    45.500   598.059
    46.000   599.801
    46.500   601.554
    47.000   603.318
    47.500   605.094
    48.000   606.880
    48.500   608.677
    49.000   610.484
    49.500   612.301
    50.000   614.129
    50.500   615.966
    51.000   617.814
    51.500   619.671
    52.000   621.537
    52.500   623.413
    53.000   625.298
    53.500   627.192
    54.000   629.094
    54.500   631.006
    55.000   632.926
    55.500   634.854
    56.000   636.790
    56.500   638.735
    57.000   640.687
    57.500   642.648
    58.000   644.615
    58.500   646.591
    59.000   648.573
    59.500   650.563
    60.000   652.560
    60.500   654.564
    61.000   656.574
    61.500   658.592
    62.000   660.615
    62.500   662.645
    63.000   664.682
    63.500   666.724
    64.000   668.772
    64.500   670.827
    65.000   672.886
    65.500   674.952
    66.000   677.023
    66.500   679.099
    67.000   681.181
    67.500   683.267
    68.000   685.359
    68.500   687.455
    69.000   689.556
    69.500   691.662
    70.000   693.772
    70.500   695.887
    71.000   698.006
    71.500   700.129
    72.000   702.257
    72.500   704.388
    73.000   706.523
    73.500   708.662
    74.000   710.804
    74.500   712.950
    75.000   715.100
    75.500   717.253
    76.000   719.409
    76.500   721.568
    77.000   723.731
    77.500   725.896
    78.000   728.064
    78.500   730.235
    79.000   732.409
    79.500   734.585
    80.000   736.764
    80.500   738.946
    81.000   741.129
    81.500   743.315
    82.000   745.504
    82.500   747.694
    83.000   749.886
    83.500   752.080
    84.000   754.277
    84.500   756.475
    85.000   758.674
    85.500   760.876
    86.000   763.079
    86.500   765.283
    87.000   767.489
    87.500   769.697
    88.000   771.905
    88.500   774.115
    89.000   776.326
    89.500   778.538
    90.000   780.752
    90.500   782.966
    91.000   785.181
    91.500   787.397
    92.000   789.614
    92.500   791.832
    93.000   794.050
    93.500   796.269
    94.000   798.489
    94.500   800.709
    95.000   802.930
    95.500   805.151
    96.000   807.372
    96.500   809.594
    97.000   811.816
    97.500   814.038
    98.000   816.261
    98.500   818.483
    99.000   820.706
    99.500   822.929
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.561
    29.000   425.118
    29.500   430.675
    30.000   436.231
    30.500   441.786
    31.000   447.340
    31.500   452.892
    32.000   458.442
    32.500   463.989
    33.000   469.533
    33.500   475.075
    34.000   480.612
    34.500   486.145
    35.000   491.674
    35.500   497.198
    36.000   502.716
    36.500   508.228
    37.000   513.733
    37.500   519.231
    38.000   524.722
    38.500   530.204
    39.000   535.678
    39.500   541.142
    40.000   546.596
    40.500   552.039
    41.000   557.471
    41.500   562.892
    42.000   568.300
    42.500   573.695
    43.000   579.077
    43.500   584.445
    44.000   589.799
    44.500   595.138
    45.000   600.462
    45.500   605.770
    46.000   611.061
    46.500   616.336
    47.000   621.594
    47.500   626.338
    48.000   630.909
    48.500   635.475
    49.000   640.036
    49.500   644.593
    50.000   649.144
    50.500   653.690
    51.000   658.231
    51.500   662.767
    52.000   667.297
    52.500   671.821
    53.000   676.339
    53.500   680.852
    54.000   685.357
    54.500   689.854
    55.000   694.342
    55.500   698.820
    56.000   703.288
    56.500   707.748
    57.000   712.201
    57.500   716.650
    58.000   721.093
    58.500   725.532
    59.000   729.966
    59.500   734.397
    60.000   738.824
    60.500   743.247
    61.000   747.666
    61.500   752.082
    62.000   756.493
    62.500   760.901
    63.000   765.305
    63.500   769.705
    64.000   774.100
    64.500   778.491
    65.000   782.876
    65.500   787.257
    66.000   791.632
    66.500   796.000
    67.000   800.362
    67.500   804.717
    68.000   809.064
    68.500   813.404
    69.000   817.736
    69.500   822.061
    70.000   826.379
    70.500   830.688
    71.000   834.991
    71.500   839.285
    72.000   843.572
    72.500   847.852
    73.000   852.124
    73.500   856.388
    74.000   860.644
    74.500   864.893
    75.000   869.133
    75.500   873.366
    76.000   877.591
    76.500   881.807
    77.000   886.016
    77.500   890.216
    78.000   894.408
    78.500   898.591
    79.000   902.766
    79.500   906.932
    80.000   911.090
    80.500   915.239
    81.000   919.380
    81.500   923.512
    82.000   927.635
    82.500   931.751
    83.000   935.857
    83.500   939.955
    84.000   944.045
    84.500   948.126
    85.000   952.198
    85.500   956.262
    86.000   960.316
    86.500   964.362
    87.000   968.400
    87.500   972.428
    88.000   976.447
    88.500   980.458
    89.000   984.460
    89.500   988.452
    90.000   992.436
    90.500   996.411
    91.000  1000.377
    91.500  1004.333
    92.000  1008.281
    92.500  1012.220
    93.000  1016.150
    93.500  1020.071
    94.000  1023.982
    94.500  1027.885
    95.000  1031.779
    95.500  1035.663
    96.000  1039.539
    96.500  1043.405
    97.000  1047.262
    97.500  1051.111
    98.000  1054.950
    98.500  1058.780
    99.000  1062.601
    99.500  1066.413
   100.000  1070.215
   100.500  1074.009
   101.000  1077.793
   101.500  1081.568
   102.000  1085.334
   102.500  1089.091
   103.000  1092.839
   103.500  1096.578
   104.000  1100.307
   104.500  1104.028
   105.000  1107.740
   105.500  1111.443
   106.000  1115.138
   106.500  1118.823
   107.000  1122.499
   107.500  1126.167
   108.000  1129.825
   108.500  1133.474
   109.000  1137.114
   109.500  1140.744
   110.000  1144.365
   110.500  1147.977
   111.000  1151.580
   111.500  1155.173
   112.000  1158.758
   112.500  1162.333
   113.000  1165.899
   113.500  1169.455
   114.000  1173.003
   114.500  1176.542
   115.000  1180.071
   115.500  1183.592
   116.000  1187.103
   116.500  1190.605
   117.000  1194.099
   117.500  1197.583
   118.000  1201.058
   118.500  1204.524
   119.000  1207.981
   119.500  1211.428
   120.000  1214.866
   120.500  1218.296
   121.000  1221.716
   121.500  1225.126
   122.000  1228.528
   122.500  1231.920
   123.000  1235.303
   123.500  1238.677
   124.000  1242.042
   124.500  1245.398
   125.000  1248.745
   125.500  1252.083
   126.000  1255.412
   126.500  1258.732
   127.000  1262.043
   127.500  1265.345
   128.000  1268.639
   128.500  1271.923
   129.000  1275.198
   129.500  1278.465
   130.000  1281.722
   130.500  1284.971
   131.000  1288.210
   131.500  1291.441
   132.000  1294.662
   132.500  1297.874
   133.000  1301.078
   133.500  1304.272
   134.000  1307.457
   134.500  1310.633
   135.000  1313.800
   135.500  1316.958
   136.000  1320.107
   136.500  1323.247
   137.000  1326.378
   137.500  1329.499
   138.000  1332.612
   138.500  1335.715
   139.000  1338.810
   139.500  1341.895
   140.000  1344.971
   140.500  1348.039
   141.000  1351.097
   141.500  1354.146
   142.000  1357.186
   142.500  1360.217
   143.000  1363.239
   143.500  1366.251
   144.000  1369.255
   144.500  1372.250
   145.000  1375.235
   145.500  1378.212
   146.000  1381.178
   146.500  1384.136
   147.000  1387.085
   147.500  1390.024
   148.000  1392.953
   148.500  1395.874
   149.000  1398.785
   149.500  1401.686
   150.000  1404.578
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.152
   100.500   827.375
   101.000   829.598
   101.500   831.820
   102.000   834.043
   102.500   836.266
   103.000   838.489
   103.500   840.712
   104.000   842.935
   104.500   845.157
   105.000   847.380
   105.500   849.603
   106.000   851.826
   106.500   854.049
   107.000   856.272
   107.500   858.494
   108.000   860.717
   108.500   862.940
   109.000   865.163
   109.500   867.386
   110.000   869.609
   110.500   871.831
   111.000   874.054
   111.500   876.277
   112.000   878.500
   112.500   880.723
   113.000   882.946
   113.500   885.168
   114.000   887.391
   114.500   889.614
   115.000   891.837
   115.500   894.060
   116.000   896.283
   116.500   898.505
   117.000   900.728
   117.500   902.951
   118.000   905.174
   118.500   907.397
   119.000   909.620
   119.500   911.842
   120.000   914.065
   120.500   916.288
   121.000   918.511
   121.500   920.734
   122.000   922.957
   122.500   925.180
   123.000   927.402
   123.500   929.625
   124.000   931.848
   124.500   934.071
   125.000   936.294
   125.500   938.516
   126.000   940.739
   126.500   942.962
   127.000   945.185
   127.500   947.408
   128.000   949.631
   128.500   951.853
   129.000   954.076
   129.500   956.299
   130.000   958.522
   130.500   960.745
   131.000   962.968
   131.500   965.190
   132.000   967.413
   132.500   969.636
   133.000   971.859
   133.500   974.082
   134.000   976.305
   134.500   978.527
   135.000   980.750
   135.500   982.973
   136.000   985.196
   136.500   987.419
   137.000   989.642
   137.500   991.864
   138.000   994.087
   138.500   996.310
   139.000   998.533
   139.500  1000.756
   140.000  1002.979
   140.500  1005.201
   141.000  1007.424
   141.500  1009.647
   142.000  1011.870
   142.500  1014.093
   143.000  1016.316
   143.500  1018.539
   144.000  1020.761
   144.500  1022.984
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.444
    15.000   395.683
    15.500   405.918
    16.000   416.145
    16.500   426.363
    17.000   436.566
    17.500   446.751
    18.000   456.913
    18.500   467.047
    19.000   477.147
    19.500   487.207
    20.000   497.222
    20.500   507.185
    21.000   517.090
    21.500   526.933
    22.000   536.708
    22.500   546.410
    23.000   555.076
    23.500   563.219
    24.000   571.328
    24.500   579.405
    25.000   587.437
    25.500   595.390
    26.000   603.302
    26.500   611.202
    27.000   619.093
    27.500   626.977
    28.000   634.854
    28.500   642.725
    29.000   650.589
    29.500   658.446
    30.000   666.296
    30.500   674.137
    31.000   681.969
    31.500   689.790
    32.000   697.598
    32.500   705.392
    33.000   713.170
    33.500   720.932
    34.000   728.676
    34.500   736.401
    35.000   744.107
    35.500   751.794
    36.000   759.461
    36.500   767.108
    37.000   774.735
    37.500   782.341
    38.000   789.926
    38.500   797.489
    39.000   805.031
    39.500   812.549
    40.000   820.045
    40.500   827.518
    41.000   834.968
    41.500   842.394
    42.000   849.795
    42.500   857.173
    43.000   864.527
    43.500   871.855
    44.000   879.160
    44.500   886.439
    45.000   893.693
    45.500   900.922
    46.000   908.125
    46.500   915.302
    47.000   922.453
    47.500   929.578
    48.000   936.676
    48.500   943.748
    49.000   950.792
    49.500   957.809
    50.000   964.800
    50.500   971.763
    51.000   978.699
    51.500   985.608
    52.000   992.488
    52.500   999.342
    53.000  1006.168
    53.500  1012.968
    54.000  1019.742
    54.500  1026.490
    55.000  1033.211
    55.500  1039.906
    56.000  1046.572
    56.500  1053.211
    57.000  1059.822
    57.500  1066.405
    58.000  1072.960
    58.500  1079.486
    59.000  1085.985
    59.500  1092.457
    60.000  1098.901
    60.500  1105.317
    61.000  1111.706
    61.500  1118.066
    62.000  1124.398
    62.500  1130.702
    63.000  1136.977
    63.500  1143.224
    64.000  1149.442
    64.500  1155.632
    65.000  1161.793
    65.500  1167.927
    66.000  1174.032
    66.500  1180.109
    67.000  1186.157
    67.500  1192.177
    68.000  1198.169
    68.500  1204.132
    69.000  1210.066
    69.500  1215.971
    70.000  1221.848
    70.500  1227.697
    71.000  1233.516
    71.500  1239.306
    72.000  1245.068
    72.500  1250.800
    73.000  1256.502
    73.500  1262.174
    74.000  1267.816
    74.500  1273.428
    75.000  1279.010
    75.500  1284.563
    76.000  1290.087
    76.500  1295.581
    77.000  1301.046
    77.500  1306.481
    78.000  1311.885
    78.500  1317.259
    79.000  1322.603
    79.500  1327.918
    80.000  1333.203
    80.500  1338.459
    81.000  1343.685
    81.500  1348.879
    82.000  1354.042
    82.500  1359.173
    83.000  1364.271
    83.500  1369.339
    84.000  1374.375
    84.500  1379.381
    85.000  1384.355
    85.500  1389.298
    86.000  1394.209
    86.500  1399.089
    87.000  1403.936
    87.500  1408.750
    88.000  1413.531
    88.500  1418.280
    89.000  1422.995
    89.500  1427.677
    90.000  1432.325
    90.500  1436.939
    91.000  1441.519
    91.500  1446.066
    92.000  1450.579
    92.500  1455.058
    93.000  1459.503
    93.500  1463.913
    94.000  1468.298
    94.500  1472.666
    95.000  1477.021
    95.500  1481.365
    96.000  1485.696
    96.500  1490.015
    97.000  1494.317
    97.500  1498.599
    98.000  1502.861
    98.500  1507.103
    99.000  1511.325
    99.500  1515.528
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   720.494
     1.000   720.541
     1.500   720.619
     2.000   720.727
     2.500   720.867
     3.000   721.039
     3.500   721.241
     4.000   721.474
     4.500   721.738
     5.000   722.032
     5.500   722.358
     6.000   722.714
     6.500   723.101
     7.000   723.518
     7.500   723.966
     8.000   724.444
     8.500   724.952
     9.000   725.490
     9.500   726.059
    10.000   726.657
    10.500   727.284
    11.000   727.941
    11.500   728.628
    12.000   729.343
    12.500   730.088
    13.000   730.861
    13.500   731.663
    14.000   732.494
    14.500   733.353
    15.000   734.239
    15.500   735.154
    16.000   736.096
    16.500   737.066
    17.000   738.063
    17.500   739.087
    18.000   740.138
    18.500   741.215
    19.000   742.319
    19.500   743.448
    20.000   744.603
    20.500   745.784
    21.000   746.990
    21.500   748.221
    22.000   749.477
    22.500   750.757
    23.000   752.061
    23.500   753.389
    24.000   754.741
    24.500   756.116
    25.000   757.514
    25.500   758.935
    26.000   760.378
    26.500   761.843
    27.000   763.330
    27.500   764.839
    28.000   766.369
    28.500   767.920
    29.000   769.491
    29.500   771.083
    30.000   772.694
    30.500   774.325
    31.000   775.976
    31.500   777.645
    32.000   779.333
    32.500   781.040
    33.000   782.764
    33.500   784.506
    34.000   786.266
    34.500   788.042
    35.000   789.835
    35.500   791.645
    36.000   793.470
    36.500   795.311
    37.000   797.168
    37.500   799.039
    38.000   800.925
    38.500   802.826
    39.000   804.740
    39.500   806.668
    40.000   808.610
    40.500   810.564
    41.000   812.532
    41.500   814.511
    42.000   816.502
    42.500   818.506
    43.000   820.520
    43.500   822.545
    44.000   824.581
    44.500   826.628
    45.000   828.684
    45.500   830.750
    46.000   832.826
    46.500   834.910
    47.000   837.004
    47.500   839.105
    48.000   841.215
    48.500   843.332
    49.000   845.457
    49.500   847.589
    50.000   849.728
    50.500   851.874
    51.000   854.026
    51.500   856.183
    52.000   858.346
    52.500   860.515
    53.000   862.689
    53.500   864.867
    54.000   867.051
    54.500   869.238
    55.000   871.429
    55.500   873.624
    56.000   875.823
    56.500   878.024
    57.000   880.229
    57.500   882.436
    58.000   884.646
    58.500   886.858
    59.000   889.072
    59.500   891.288
    60.000   893.506
    60.500   895.724
    61.000   897.944
    61.500   900.165
    62.000   902.387
    62.500   904.609
    63.000   906.832
    63.500   909.055
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   932.548
     1.000   932.615
     1.500   932.725
     2.000   932.880
     2.500   933.079
     3.000   933.323
     3.500   933.610
     4.000   933.942
     4.500   934.318
     5.000   934.737
     5.500   935.201
     6.000   935.708
     6.500   936.259
     7.000   936.854
     7.500   937.492
     8.000   938.173
     8.500   938.897
     9.000   939.665
     9.500   940.476
    10.000   941.329
    10.500   942.225
    11.000   943.164
    11.500   944.145
    12.000   945.168
    12.500   946.232
    13.000   947.339
    13.500   948.487
    14.000   949.677
    14.500   950.908
    15.000   952.179
    15.500   953.491
    16.000   954.844
    16.500   956.237
    17.000   957.670
    17.500   959.143
    18.000   960.655
    18.500   962.206
    19.000   963.796
    19.500   965.425
    20.000   967.093
    20.500   968.798
    21.000   970.542
    21.500   972.323
    22.000   974.141
    22.500   975.996
    23.000   977.888
    23.500   979.816
    24.000   981.781
    24.500   983.781
    25.000   985.817
    25.500   987.888
    26.000   989.993
    26.500   992.133
    27.000   994.308
    27.500   996.516
    28.000   998.758
    28.500  1001.034
    29.000  1003.342
    29.500  1005.682
    30.000  1008.055
    30.500  1010.460
    31.000  1012.897
    31.500  1015.365
    32.000  1017.863
    32.500  1020.393
    33.000  1022.952
    33.500  1025.542
    34.000  1028.161
    34.500  1030.809
    35.000  1033.486
    35.500  1036.192
    36.000  1038.926
    36.500  1041.688
    37.000  1044.478
    37.500  1047.295
    38.000  1050.138
    38.500  1053.008
    39.000  1055.905
    39.500  1058.827
    40.000  1061.775
    40.500  1064.748
    41.000  1067.746
    41.500  1070.769
    42.000  1073.815
    42.500  1076.886
    43.000  1079.980
    43.500  1083.098
    44.000  1086.238
    44.500  1089.401
    45.000  1092.586
    45.500  1095.794
    46.000  1099.022
    46.500  1102.273
    47.000  1105.544
    47.500  1108.836
    48.000  1112.148
    48.500  1115.481
    49.000  1118.833
    49.500  1122.205
    50.000  1125.596
    50.500  1129.006
    51.000  1132.434
    51.500  1135.880
    52.000  1139.345
    52.500  1142.828
    53.000  1146.327
    53.500  1149.844
    54.000  1153.378
    54.500  1156.928
    55.000  1160.495
    55.500  1164.077
    56.000  1167.676
    56.500  1171.289
    57.000  1174.918
    57.500  1178.562
    58.000  1182.220
    58.500  1185.893
    59.000  1189.580
    59.500  1193.281
    60.000  1196.996
    60.500  1200.723
    61.000  1204.464
    61.500  1208.218
    62.000  1211.984
    62.500  1215.763
    63.000  1219.554
    63.500  1223.356
    64.000  1227.171
    64.500  1230.996
    65.000  1234.833
    65.500  1238.681
    66.000  1242.540
    66.500  1246.409
    67.000  1250.288
    67.500  1254.177
    68.000  1258.077
    68.500  1261.985
    69.000  1265.904
    69.500  1269.831
    70.000  1273.767
    70.500  1277.712
    71.000  1281.666
    71.500  1285.628
    72.000  1289.598
    72.500  1293.576
    73.000  1297.562
    73.500  1301.555
    74.000  1305.556
    74.500  1309.564
    75.000  1313.579
    75.500  1317.601
    76.000  1321.629
    76.500  1325.664
    77.000  1329.705
    77.500  1333.753
    78.000  1337.806
    78.500  1341.865
    79.000  1345.929
    79.500  1349.999
    80.000  1354.074
    80.500  1358.155
    81.000  1362.240
    81.500  1366.330
    82.000  1370.424
    82.500  1374.523
    83.000  1378.626
    83.500  1382.734
    84.000  1386.845
    84.500  1390.960
    85.000  1395.079
    85.500  1399.202
    86.000  1403.328
    86.500  1407.457
    87.000  1411.589
    87.500  1415.724
    88.000  1419.862
    88.500  1424.003
    89.000  1428.146
    89.500  1432.292
    90.000  1436.440
    90.500  1440.591
    91.000  1444.743
    91.500  1448.897
    92.000  1453.054
    92.500  1457.212
    93.000  1461.371
    93.500  1465.532
    94.000  1469.695
    94.500  1473.858
    95.000  1478.023
    95.500  1482.189
    96.000  1486.355
    96.500  1490.523
    97.000  1494.691
    97.500  1498.860
    98.000  1503.029
    98.500  1507.199
    99.000  1511.369
    99.500  1515.539
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.398
    29.500   783.638
    30.000   793.876
    30.500   804.113
    31.000   814.346
    31.500   824.577
    32.000   834.803
    32.500   845.025
    33.000   855.240
    33.500   865.449
    34.000   875.649
    34.500   885.841
    35.000   896.023
    35.500   906.193
    36.000   916.351
    36.500   926.494
    37.000   936.623
    37.500   946.735
    38.000   956.829
    38.500   966.572
    39.000   976.957
    39.500   986.988
    40.000   996.994
    40.500  1006.975
    41.000  1016.929
    41.500  1026.854
    42.000  1036.750
    42.500  1046.614
    43.000  1056.445
    43.500  1066.243
    44.000  1076.006
    44.500  1085.732
    45.000  1095.421
    45.500  1104.789
    46.000  1112.959
    46.500  1121.112
    47.000  1129.248
    47.500  1137.368
    48.000  1145.471
    48.500  1153.558
    49.000  1161.627
    49.500  1169.676
    50.000  1177.699
    50.500  1185.685
    51.000  1193.615
    51.500  1201.531
    52.000  1209.440
    52.500  1217.343
    53.000  1225.241
    53.500  1233.135
    54.000  1241.025
    54.500  1248.911
    55.000  1256.794
    55.500  1264.673
    56.000  1272.548
    56.500  1280.421
    57.000  1288.290
    57.500  1296.156
    58.000  1304.019
    58.500  1311.878
    59.000  1319.734
    59.500  1327.586
    60.000  1335.434
    60.500  1343.279
    61.000  1351.119
    61.500  1358.954
    62.000  1366.784
    62.500  1374.608
    63.000  1382.427
    63.500  1390.239
    64.000  1398.044
    64.500  1405.843
    65.000  1413.634
    65.500  1421.417
    66.000  1429.192
    66.500  1436.959
    67.000  1444.717
    67.500  1452.466
    68.000  1460.207
    68.500  1467.938
    69.000  1475.659
    69.500  1483.371
    70.000  1491.074
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     4.644    83.203     0.150
     7.188   111.297     0.150
    13.967   210.500     0.150
    26.164   337.000     0.150
    42.986   484.102     0.150
    45.674    13.000     0.150
    45.674    12.500     0.150
    48.172   521.898     0.150
    51.980   551.000     0.150
    53.711   562.203     0.150
    62.976   628.703     0.150
    62.976   628.703     0.150
    63.141   633.000     0.150
    64.558   638.203     0.150
    66.119   650.000     0.150
    66.466   651.000     0.150
    68.779   664.797     0.150
    68.887   671.000     0.150
    70.652   678.000     0.150
    70.945   678.000     0.150
    70.945   692.000     0.150
    71.041   680.000     0.150
    71.661   683.000     0.150
    73.208   693.398     0.150
    75.072     4.500     0.150
    75.489   705.000     0.150
    77.622   712.000     0.150
    78.623   728.398     0.150
    84.689   758.000     0.150
    85.875   760.000     0.150
     4.070    60.781     0.150
     4.630    84.484     0.150
     9.366   141.281     0.150
    12.566   179.484     0.150
    12.933   187.781     0.150
    25.730   335.781     0.150
     0.771    26.305     0.150
     0.915    30.211     0.150
     1.103    18.906     0.150
     4.113    73.906     0.150
     4.673    84.211     0.150
     4.644    83.617     0.150
     8.594   133.316     0.150
    12.236   167.316     0.150
    12.239   234.316     0.150
    12.573   172.715     0.150
    16.451   236.215     0.150
    17.114   229.316     0.150
     4.636    83.539     0.150
     4.692    85.641     0.150
     9.046   140.438     0.150
    13.555   198.438     0.150
     0.407     4.277     0.150
     0.472     3.676     0.150
     0.472     9.977     0.150
     0.494     8.574     0.150
     0.593    10.477     0.150
     0.698    21.676     0.150
     0.978    17.875     0.150
     4.473    79.176     0.150
     6.042    94.977     0.150
    12.666   180.375     0.150
     0.379     6.262     0.150
     0.835    13.363     0.150
     4.104    73.562     0.150
     6.232    92.961     0.150
    12.424   174.262     0.150
    12.424   174.160     0.150
    12.424   390.660     0.150
    26.137   336.262     0.150
    31.784   388.543     0.150
     0.197     2.477     0.150
     4.262   117.828     0.150
     6.112    94.078     0.150
     7.022   101.375     0.150
    12.679   176.977     0.150
    12.679   177.773     0.150
    12.679   393.773     0.150
    18.585   263.477     0.150
    33.170   400.227     0.150
     1.943    25.447     0.150
     1.943    28.578     0.150
     1.943    53.248     0.150
     4.407    53.438     0.150
     5.179   154.527     0.150
    14.098   202.969     0.150
    14.098   457.578     0.150
     0.870    13.589     0.150
     0.870    24.669     0.150
     2.881    44.389     0.150
     4.445    79.294     0.150
     4.445    68.179     0.150
     4.445    68.669     0.150
     4.624   132.818     0.150
     5.085   145.369     0.150
     6.009   170.148     0.150
    12.267   171.059     0.150
    13.155   193.794     0.150
    13.155   193.799     0.150
     0.361     9.125     0.150
     4.428    79.273     0.150
     5.092    92.324     0.150
     5.092   146.723     0.150
     5.092   153.113     0.150
     5.165    90.395     0.150
     5.503    85.012     0.150
     6.082   190.152     0.150
     6.888   211.293     0.150
     0.663    11.812     0.150
     1.246    38.906     0.150
     4.998    75.141     0.150
     0.571    20.215     0.150
     0.571    10.664     0.150
     0.571    20.215     0.150
     2.585    40.164     0.150
     4.704    83.543     0.150
     4.704    71.695     0.150
     5.330    90.695     0.150
     5.696   171.555     0.150
     5.987    88.926     0.150
     6.133   109.453     0.150
     6.401   229.664     0.150
     6.529   196.746     0.150
     6.912   104.844     0.150
     6.912   125.363     0.150
    10.577   156.379     0.150
    12.397   384.625     0.150
    12.434   174.785     0.150
    14.580   462.445     0.150
    14.580   464.613     0.150
    17.020   239.266     0.150
    77.145    10.000     0.150
   149.641  1199.496     0.150
   149.641  1190.793     0.150
   149.641  1192.996     0.150
   149.641  1199.496     0.150
   150.407  1194.594     0.150
   150.407  1201.293     0.150
   150.407  1192.695     0.150
   150.407  1194.594     0.150
   150.407  1201.293     0.150
     0.559    10.794     0.150
     0.887    15.944     0.150
     0.887    27.554     0.150
     0.887    15.894     0.150
     0.851    15.914     0.150
     0.851    26.954     0.150
     2.574    40.454     0.150
     2.574    44.029     0.150
     2.574    78.404     0.150
     4.697    83.954     0.150
     4.697    72.254     0.150
     4.697    83.954     0.150
     4.697   146.104     0.150
     7.327   105.114     0.150
    12.384   176.832     0.150
    12.384   389.849     0.150
    12.539   178.684     0.150
    13.484   432.704     0.150
    13.484   193.054     0.150
    13.484   432.704     0.150
    14.577   467.129     0.150
    16.213   223.844     0.150
    17.820   246.004     0.150
    18.181   251.434     0.150
    36.479   426.654     0.150
    57.652  4297.081     0.150
    57.654  4297.040     0.150
    57.669  4298.114     0.150
    62.760   621.054     0.150
    75.755   706.279     0.150
    75.822   706.804     0.150
    77.149     4.700     0.150
     0.584     8.410     0.150
     8.637   123.184     0.150
    11.217   160.764     0.150
    17.133   241.084     0.150
    20.554   281.629     0.150
    21.064   285.984     0.150
    21.257   290.953     0.150
    21.419   288.344     0.150
    25.233   327.623     0.150
    56.841  4292.545     0.150
    56.843  4294.336     0.150
    56.858  4301.352     0.150
    57.901  4377.340     0.150
    57.912  4365.102     0.150
    57.919  4373.109     0.150
    77.922   723.885     0.150
    79.025     4.199     0.150
    79.025   735.084     0.150
    79.025   912.385     0.150
     0.398    13.559     0.150
     1.209    22.199     0.150
     1.942    55.918     0.150
     2.638    43.457     0.150
     2.698    76.887     0.150
     3.607   100.176     0.150
     4.387   113.438     0.150
     4.590    67.797     0.150
     4.590   121.297     0.150
     5.026    88.148     0.150
     5.428    78.148     0.150
     5.776    87.270     0.150
     5.951    90.598     0.150
     9.103   133.598     0.150
    10.154   145.199     0.150
    10.185   150.867     0.150
    10.678   156.848     0.150
    10.678   156.898     0.150
    12.113   309.348     0.150
    12.113   173.297     0.150
    12.113   309.398     0.150
    12.322   177.699     0.150
    12.675   183.598     0.150
    12.629   179.898     0.150
    12.750   185.727     0.150
    13.539   186.637     0.150
    13.697   194.699     0.150
    13.949   198.996     0.150
    14.115   199.598     0.150
    15.065   215.977     0.150
    15.127   213.781     0.150
    15.288   214.699     0.150
    15.551   220.496     0.150
    16.901   240.496     0.150
    17.959   248.297     0.150
    18.346   256.098     0.150
    19.451   269.398     0.150
    19.747   271.398     0.150
    19.964   274.398     0.150
    20.314   277.898     0.150
    20.551   279.797     0.150
    20.532   278.699     0.150
    20.675   281.898     0.150
    21.193   287.699     0.150
    21.530   289.438     0.150
    21.817   294.746     0.150
    22.056   294.297     0.150
    22.652   299.699     0.150
    23.246   309.758     0.150
    25.201   326.504     0.150
    25.728   332.898     0.150
    26.579   338.398     0.150
    29.829   367.699     0.150
    31.516   382.699     0.150
    31.881   384.996     0.150
    32.196   398.297     0.150
    32.335   388.895     0.150
    32.917   394.496     0.150
    32.917   394.391     0.150
    37.948   437.398     0.150
    39.145   447.098     0.150
    40.603   460.098     0.150
    41.063   464.098     0.150
    41.792   469.297     0.150
    43.587   483.199     0.150
    44.165   487.496     0.150
    49.607   524.199     0.150
    57.258   581.797     0.150
    62.820   624.898     0.150
    65.775   644.797     0.150
    71.598   680.199     0.150
    72.040   688.398     0.150
    72.040   704.496     0.150
    72.832   688.297     0.150
    73.295   691.898     0.150
    73.591   691.898     0.150
    73.841   694.797     0.150
    73.841   702.398     0.150
    74.198   696.699     0.150
    74.381   697.797     0.150
    74.381   705.398     0.150
    74.638   698.996     0.150
    74.638   698.598     0.150
    74.661   699.199     0.150
    74.677   699.297     0.150
    75.682   703.699     0.150
    75.792   713.996     0.150
    75.916   705.996     0.150
    76.122   707.398     0.150
    76.456   708.398     0.150
    76.456   708.367     0.150
    76.456   708.398     0.150
    76.595   706.547     0.150
    76.882   711.598     0.150
    78.123   719.496     0.150
    78.494   720.898     0.150
    78.919     3.801     0.150
    78.919     6.301     0.150
    79.424   725.797     0.150
    79.856   728.297     0.150
    80.063   729.496     0.150
    80.212   730.098     0.150
    80.947   733.797     0.150
    81.955   739.598     0.150
    82.148   739.898     0.150
    82.450   740.898     0.150
    82.450   740.996     0.150
    82.644   742.699     0.150
    82.985   744.797     0.150
    84.027   750.098     0.150
    84.910   754.797     0.150
    85.793   759.297     0.150
    86.786   763.797     0.150
    88.142   769.598     0.150
    96.345   809.570     0.150
    96.345   809.598     0.150
   127.753  1146.086     0.150
   127.753  1145.996     0.150
   127.753  1146.098     0.150
   151.162  1190.199     0.150
     0.630     9.652     0.150
     0.630     9.602     0.150
     0.691    10.496     0.150
     3.803    55.500     0.150
     5.936    86.375     0.150
     5.936    86.043     0.150
     7.433   104.773     0.150
    12.422   179.773     0.150
    12.604   185.953     0.150
    25.360   329.320     0.150
    31.280   378.773     0.150
    57.044  4295.719     0.150
    57.046  4295.910     0.150
    57.061  4297.016     0.150
    58.103  4377.871     0.150
    58.114  4377.574     0.150
    58.121  4379.098     0.150
    62.953   637.301     0.150
    69.442   669.953     0.150
    79.162     4.000     0.150
    87.916   771.277     0.150
     2.706    44.605     0.150
     2.706    79.234     0.150
     4.575    67.215     0.150
     5.802    87.617     0.150
     5.802   150.707     0.150
     5.945    90.605     0.150
     5.945   154.844     0.150
     9.154   133.414     0.150
    10.192   144.816     0.150
    10.427   148.746     0.150
    12.080   172.215     0.150
    12.080   306.715     0.150
    12.296   175.516     0.150
    12.503   175.535     0.150
    12.503   308.734     0.150
    12.503   175.516     0.150
    12.503   308.715     0.150
    12.592   179.715     0.150
    12.592   319.117     0.150
    13.667   194.516     0.150
    13.920   197.516     0.150
    14.605   208.645     0.150
    15.351   217.016     0.150
    15.560   477.914     0.150
    15.560   219.316     0.150
    16.940   241.816     0.150
    18.030   250.414     0.150
    18.279   256.125     0.150
    19.491   262.906     0.150
    19.491   262.914     0.150
    19.780   272.617     0.150
    20.014   274.316     0.150
    20.368   278.617     0.150
    20.492   276.715     0.150
    20.618   280.117     0.150
    20.711   282.016     0.150
    21.225   287.316     0.150
    22.345   298.516     0.150
    22.724   301.914     0.150
    25.271   326.543     0.150
    29.890   368.215     0.150
    31.567   382.117     0.150
    38.018   437.816     0.150
    38.961   444.566     0.150
    41.016   461.957     0.150
    43.564   483.027     0.150
    56.860  4290.777     0.150
    56.863  4291.805     0.150
    56.877  4292.262     0.150
    57.923  4369.418     0.150
    57.934  4370.953     0.150
    57.941  4371.500     0.150
    61.547   620.516     0.150
    69.189   665.504     0.150
    69.189   665.516     0.150
    72.868   688.316     0.150
    73.576   691.617     0.150
    74.418   698.016     0.150
    74.919   701.316     0.150
    75.707   704.516     0.150
    75.950   706.016     0.150
    76.156   707.414     0.150
    76.437   708.316     0.150
    76.437   708.316     0.150
    76.500   708.816     0.150
    76.915   713.117     0.150
    77.648   715.387     0.150
    78.152   730.117     0.150
    78.525   720.715     0.150
    78.877     5.500     0.150
    78.877   932.316     0.150
    80.242   730.316     0.150
    82.134   740.215     0.150
    82.440   741.117     0.150
    82.440   741.016     0.150
    83.757   748.516     0.150
    83.757   748.516     0.150
    88.199   769.414     0.150
   150.729  1191.234     0.150
   151.189  1189.816     0.150
     2.896    75.402     0.150
     3.798    56.980     0.150
     4.666    67.082     0.150
     6.019   151.879     0.150
     6.019   151.879     0.150
     6.019   186.180     0.150
     9.230   134.180     0.150
    10.206   150.082     0.150
    10.898   328.629     0.150
    10.898   155.402     0.150
    10.898   328.629     0.150
    12.093   171.379     0.150
    12.014   175.230     0.150
    12.341   176.879     0.150
    12.431   177.082     0.150
    12.406   173.000     0.150
    12.406   173.000     0.150
    12.588   179.980     0.150
    12.645   182.121     0.150
    12.867   182.387     0.150
    12.867   187.582     0.150
    13.823   191.449     0.150
    13.823   431.879     0.150
    13.823   191.480     0.150
    13.695   198.359     0.150
    13.695   198.379     0.150
    13.738   199.441     0.150
    13.952   200.480     0.150
    13.955   200.980     0.150
    13.946   202.379     0.150
    14.152   439.094     0.150
    14.152   200.250     0.150
    14.152   439.090     0.150
    14.489   210.281     0.150
    15.228   219.730     0.150
    15.220   217.082     0.150
    15.504   220.980     0.150
    15.726   489.129     0.150
    15.726   225.391     0.150
    15.726   225.379     0.150
    16.960   241.082     0.150
    16.967   241.582     0.150
    17.337   244.879     0.150
    17.408   245.082     0.150
    17.408   243.379     0.150
    18.481   256.582     0.150
    19.514   270.180     0.150
    19.556   270.680     0.150
    19.771   273.180     0.150
    20.088   276.582     0.150
    20.460   280.082     0.150
    20.717   282.582     0.150
    20.971   285.879     0.150
    21.211   287.309     0.150
    21.211   287.281     0.150
    22.968   305.680     0.150
    23.470   311.582     0.150
    23.470   311.594     0.150
    25.735   335.770     0.150
    25.735   336.379     0.150
    25.813   333.980     0.150
    25.813   333.930     0.150
    26.619   339.680     0.150
    26.854   341.480     0.150
    26.576   340.180     0.150
    30.025   370.680     0.150
    31.644   382.379     0.150
    31.644   382.391     0.150
    32.135   389.750     0.150
    32.135   389.781     0.150
    32.158   566.180     0.150
    32.703   394.582     0.150
    35.455   417.879     0.150
    38.217   439.879     0.150
    38.927   445.949     0.150
    39.931   454.582     0.150
    40.438   457.793     0.150
    40.438   457.789     0.150
    40.962   462.219     0.150
    43.616   483.738     0.150
    43.616   483.742     0.150
    43.616   486.379     0.150
    44.426   492.281     0.150
    48.585   523.250     0.150
    56.610  4297.750     0.150
    56.613  4295.543     0.150
    56.627  4298.961     0.150
    57.671  4373.102     0.150
    57.682  4373.523     0.150
    57.689  4374.051     0.150
    59.278   598.547     0.150
    59.278   598.551     0.150
    61.413   615.191     0.150
    62.817   630.781     0.150
    63.087   628.879     0.150
    63.087   627.531     0.150
    64.033   634.281     0.150
    66.341   647.879     0.150
    67.946   659.680     0.150
    69.263   665.922     0.150
    69.263   667.582     0.150
    72.254   691.180     0.150
    72.254   697.980     0.150
    72.922   689.980     0.150
    73.109   692.859     0.150
    73.109   692.879     0.150
    73.892   696.879     0.150
    74.103   698.379     0.150
    74.113   697.980     0.150
    74.113   702.379     0.150
    74.469   698.480     0.150
    74.469   704.980     0.150
    74.660   701.582     0.150
    74.660   706.379     0.150
    74.908   705.680     0.150
    74.908   705.680     0.150
    74.957   702.680     0.150
    74.957   700.652     0.150
    75.056   707.980     0.150
    75.157   703.582     0.150
    75.873   710.898     0.150
    75.920   706.242     0.150
    76.187   714.680     0.150
    76.390   713.379     0.150
    76.505   710.582     0.150
    76.505   709.621     0.150
    76.505   709.582     0.150
    76.568   711.082     0.150
    77.148   714.379     0.150
    77.148   714.379     0.150
    77.301   714.141     0.150
    77.919   717.621     0.150
    77.910   719.922     0.150
    78.375   723.480     0.150
    78.754   729.980     0.150
    78.754   729.980     0.150
    78.850     5.000     0.150
    78.850     9.301     0.150
    78.850   919.281     0.150
    79.688   731.879     0.150
    79.944   723.980     0.150
    80.117   731.582     0.150
    80.313   729.879     0.150
    80.466   726.480     0.150
    80.466   726.480     0.150
    83.941   750.730     0.150
    84.884     5.000     0.150
    87.260   766.969     0.150
    88.305   771.949     0.150
    88.305   771.980     0.150
    96.248   809.012     0.150
   142.442  1169.102     0.150
   142.442  1169.102     0.150
   151.005  1192.910     0.150
     7.024   100.355     0.150
     7.229   111.055     0.150
    11.161   166.824     0.150
    12.691   185.734     0.150
    13.768   194.527     0.150
    13.788   201.348     0.150
    14.234   199.324     0.150
    14.234   199.324     0.150
    17.703   249.016     0.150
    22.845   305.176     0.150
    25.612   331.297     0.150
    31.523   383.555     0.150
    39.039   444.750     0.150
    39.039   444.754     0.150
    56.731  4293.941     0.150
    56.733  4295.363     0.150
    56.748  4295.227     0.150
    57.791  4382.992     0.150
    57.802  4382.699     0.150
    57.809  4382.699     0.150
    63.073   627.375     0.150
    71.666   685.676     0.150
    74.935   702.055     0.150
    76.583   710.027     0.150
    77.863   718.426     0.150
    78.960     4.199     0.150
     0.619     4.379     0.150
     2.841    45.949     0.150
    13.824   190.344     0.150
    14.303   199.078     0.150
    14.357   198.621     0.150
    18.351   256.789     0.150
    19.451   268.836     0.150
    21.280   289.598     0.150
    32.644   391.844     0.150
    63.108   617.449     0.150
    74.116   697.020     0.150
    77.673     5.000     0.150
    77.673     7.000     0.150
    84.939     5.000     0.150
     0.623     5.305     0.150
     0.660     7.367     0.150
     6.047    85.398     0.150
     6.047    85.383     0.150
    13.846   193.367     0.150
    13.846   193.367     0.150
    14.179   199.078     0.150
    17.385   244.578     0.150
    20.359   274.688     0.150
    31.626   381.773     0.150
    38.949   446.656     0.150
    43.643   483.938     0.150
    57.138   584.523     0.150
    59.295   602.625     0.150
    61.425   618.734     0.150
    63.115   627.305     0.150
    64.427   635.508     0.150
    64.648   635.703     0.150
    67.969   661.055     0.150
    67.969   661.055     0.150
    68.007   664.148     0.150
    68.007   664.148     0.150
    68.970   662.812     0.150
    69.290   668.227     0.150
    69.290   668.227     0.150
    74.129   693.016     0.150
    74.984   701.172     0.150
    75.184   702.148     0.150
    75.949   704.602     0.150
    76.532   708.828     0.150
    77.942   717.805     0.150
    83.677   748.758     0.150
    87.289   765.266     0.150
    88.289   770.547     0.150
    96.268   807.773     0.150
   142.412  1173.172     0.150
   151.127  1190.742     0.150
     0.306     5.773     0.150
     0.306     9.789     0.150
     2.975    38.312     0.150
     2.975    38.312     0.150
     2.975    60.195     0.150
     2.975    87.953     0.150
     5.736   154.492     0.150
     6.939    99.812     0.150
    10.472   138.938     0.150
    11.022   152.648     0.150
    11.022   148.953     0.150
    11.022   341.344     0.150
    11.633   162.898     0.150
    12.295   162.664     0.150
    12.583   175.438     0.150
    13.151   182.164     0.150
    13.917   184.969     0.150
    13.992   202.906     0.150
    14.179   195.180     0.150
    14.241   206.289     0.150
    14.950   208.266     0.150
    15.459   211.555     0.150
    15.128   212.844     0.150
    15.411   213.930     0.150
    15.390   213.656     0.150
    15.390   483.883     0.150
    15.639   212.406     0.150
    16.438   219.828     0.150
    17.253   229.242     0.150
    18.281   245.094     0.150
    18.564   249.180     0.150
    18.689   248.914     0.150
    20.889   275.273     0.150
    22.244   292.227     0.150
    22.759   294.023     0.150
    23.100   295.508     0.150
    23.138   297.289     0.150
    28.480   346.680     0.150
    30.175   362.219     0.150
    56.659  4276.562     0.150
    56.661  4277.125     0.150
    56.676  4275.430     0.150
    57.724  4360.727     0.150
    57.735  4360.727     0.150
    57.742  4361.859     0.150
    70.488   668.977     0.150
    72.802   686.039     0.150
    73.339   685.344     0.150
    75.717   714.695     0.150
    77.666   714.312     0.150
    77.338    14.000     0.150
    77.490   712.586     0.150
    78.116     4.203     0.150
    78.593   717.383     0.150
    78.593     5.703     0.150
    78.593     9.203     0.150
    78.593   868.883     0.150
    81.898   732.508     0.150
    83.606   746.438     0.150
    84.565     7.500     0.150
    84.565   955.586     0.150
     2.697    43.975     0.150
     2.697    77.975     0.150
    10.503   150.230     0.150
    10.740   154.869     0.150
    15.349   213.230     0.150
    19.807   272.609     0.150
    21.392   289.750     0.150
    21.593   294.320     0.150
    21.632   291.604     0.150
    22.828   306.430     0.150
    32.396   389.174     0.150
    38.005   438.350     0.150
    56.888  4288.355     0.150
    56.891  4289.012     0.150
    56.905  4290.078     0.150
    57.951  4367.107     0.150
    57.962  4368.434     0.150
    57.970  4369.371     0.150
    61.824  4641.500     0.150
    68.892  5172.500     0.150
    69.077  5180.799     0.150
    71.643  5378.500     0.150
    71.715  5383.900     0.150
    71.786  5383.699     0.150
    71.846  5394.000     0.150
    75.685  5678.900     0.150
    77.326  5804.199     0.150
    78.856     6.000     0.150
    78.856     9.000     0.150
   149.665  1192.305     0.150
   149.917  1192.713     0.150
   151.221  1196.248     0.150
     6.012   189.973     0.150
     6.012    85.988     0.150
     6.012   189.977     0.150
    12.295   175.309     0.150
    56.590  4294.184     0.150
    56.592  4310.969     0.150
    56.607  4295.441     0.150
    57.651  4380.762     0.150
     1.485    24.176     0.150
     5.836   186.605     0.150
     5.836   186.605     0.150
     5.836    87.875     0.150
    15.458   214.254     0.150
    56.611  4264.887     0.150
    56.613  4287.480     0.150
    56.628  4289.168     0.150
    57.674  4361.410     0.150
    57.685  4362.160     0.150
    57.692  4364.590     0.150
     0.140     5.320     0.150
     5.025    89.340     0.150
     6.236   186.910     0.150
    56.924  4286.301     0.150
    56.927  4286.516     0.150
    56.941  4288.105     0.150
    57.987  4366.445     0.150
    57.998  4369.379     0.150
    58.006  4367.895     0.150
     0.239     5.009     0.150
     0.239     7.999     0.150
     0.278     5.669     0.150
     0.278     9.158     0.150
     0.423     7.719     0.150
     0.423    12.869     0.150
     0.661    12.188     0.150
     0.661    21.049     0.150
     0.998    17.469     0.150
     0.998    30.049     0.150
     1.097    19.509     0.150
     1.949    30.839     0.150
     1.949    34.198     0.150
     1.949    58.528     0.150
     2.858    43.068     0.150
     2.858    75.459     0.150
     2.858    84.669     0.150
     3.937    57.568     0.150
     3.937   101.499     0.150
     4.708    69.639     0.150
     4.826    71.809     0.150
     4.826   125.219     0.150
     5.143    91.009     0.150
     5.663   173.198     0.150
     5.674    85.188     0.150
     8.005   114.629     0.150
    10.909   343.442     0.150
    15.387   494.039     0.150
    16.757   235.759     0.150
    18.455   260.131     0.150
    56.779  4287.365     0.150
    56.781  4284.455     0.150
    56.796  4285.551     0.150
    72.137   682.139     0.150
     0.357     6.820     0.150
     0.357    11.650     0.150
     0.437     8.061     0.150
     0.437    14.189     0.150
     0.528     9.801     0.150
     0.528    16.891     0.150
     1.142    19.500     0.150
     1.142    34.879     0.150
     1.205    21.510     0.150
     1.997    31.680     0.150
     1.997    59.189     0.150
     2.759    82.480     0.150
     2.759    41.359     0.150
     3.498    89.770     0.150
     3.806    71.430     0.150
     3.806   113.109     0.150
     3.996    59.320     0.150
     3.996   104.379     0.150
     4.122    59.740     0.150
     4.495   119.750     0.150
     4.495    67.580     0.150
     4.495   119.750     0.150
     4.575    67.039     0.150
     4.699    69.020     0.150
     5.125    75.100     0.150
     5.085    74.529     0.150
     5.275    74.000     0.150
     5.899   151.400     0.150
     7.110   213.949     0.150
     9.149   295.811     0.150
    10.798   336.432     0.150
    10.798   336.430     0.150
    10.798   156.059     0.150
    10.995   157.939     0.150
    14.039   455.189     0.150
    15.135   214.250     0.150
    15.522   489.020     0.150
    19.837   272.469     0.150
    20.117   274.982     0.150
    21.408   287.771     0.150
    21.629   294.359     0.150
    22.765   715.320     0.150
    22.765   301.609     0.150
    22.871   307.590     0.150
    23.375   311.990     0.150
    32.191   386.600     0.150
    56.822  4287.977     0.150
    56.824  4285.701     0.150
    56.839  4290.305     0.150
    57.885  4368.814     0.150
    57.896  4364.633     0.150
    57.903  4370.711     0.150
    68.864  5176.891     0.150
    69.049  5190.289     0.150
    71.614  5382.590     0.150
    71.686  5388.289     0.150
    71.707  5388.689     0.150
    71.757  5385.891     0.150
    71.817  5397.789     0.150
    75.671  5683.689     0.150
    76.384   708.859     0.150
    77.298  5808.590     0.150
    77.694     6.898     0.150
    78.345   728.090     0.150
    78.818     3.600     0.150
    78.818     4.900     0.150
     0.376     7.246     0.150
     0.376    12.188     0.150
     2.698    72.379     0.150
     2.698    81.477     0.150
     4.439   114.938     0.150
     5.076    89.816     0.150
     5.779   151.535     0.150
     5.779   181.285     0.150
    56.877  4289.016     0.150
    56.879  4289.234     0.150
    56.894  4288.645     0.150
     2.835    75.249     0.150
     5.757   147.529     0.150
     7.987   118.149     0.150
     8.473   131.079     0.150
    13.897   441.442     0.150
    15.385   479.029     0.150
    56.804  4279.765     0.150
    56.807  4279.972     0.150
    56.821  4281.097     0.150
    57.869  4360.530     0.150
    57.880  4361.663     0.150
    57.887  4362.791     0.150
     0.214     4.668     0.150
     0.214     8.035     0.150
     0.336     6.559     0.150
     0.336    11.227     0.150
     0.493     8.988     0.150
     1.292    22.398     0.150
     1.296    21.816     0.150
     5.026    88.496     0.150
     5.855   177.887     0.150
     6.045    87.016     0.150
     6.045   154.938     0.150
     6.045   157.559     0.150
     6.126   159.527     0.150
     6.772   208.688     0.150
     6.918   107.105     0.150
    11.679   174.016     0.150
    12.636   183.438     0.150
    14.044   356.918     0.150
    14.211   456.246     0.150
    14.962   213.078     0.150
    56.952  4292.879     0.150
    56.954  4294.609     0.150
    56.969  4298.609     0.150
    58.013  4377.547     0.150
    58.024  4375.637     0.150
    58.031  4378.457     0.150
     0.663    21.703     0.150
     1.104    19.191     0.150
     1.104    30.414     0.150
     1.326    38.793     0.150
     1.844    29.305     0.150
     1.983    31.441     0.150
     2.196    65.941     0.150
     2.873    42.832     0.150
     3.479    53.391     0.150
     3.636    53.473     0.150
     4.392   114.406     0.150
     4.634   119.633     0.150
     6.681    97.848     0.150
     6.681   199.824     0.150
     6.693    96.953     0.150
     6.841    99.195     0.150
     9.311   134.801     0.150
     9.323   135.102     0.150
    13.903   206.043     0.150
    13.903   446.793     0.150
    19.691   268.523     0.150
    22.299   293.543     0.150
    56.752  4279.227     0.150
    56.755  4277.312     0.150
    56.769  4287.000     0.150
    57.817  4362.773     0.150
    57.828  4364.867     0.150
    57.835  4364.328     0.150
     0.649    10.461     0.150
     2.013    61.660     0.150
     1.012    31.750     0.150
     2.020    32.844     0.150
     0.242     5.247     0.150
     0.242     8.407     0.150
     1.294    38.697     0.150
     2.430    72.938     0.150
     3.162    48.047     0.150
     3.630    51.717     0.150
     4.644    69.207     0.150
     5.667   172.842     0.150
     6.004    89.438     0.150
    13.491   425.491     0.150
    13.895   204.407     0.150
    13.895   444.308     0.150
    40.366   456.884     0.150
    56.781  4285.363     0.150
    56.784  4285.586     0.150
    56.798  4286.647     0.150
    57.846  4365.594     0.150
    57.857  4365.641     0.150
    57.864  4366.934     0.150
     2.952    44.181     0.150
    13.773   440.948     0.150
    56.727  4277.484     0.150
    56.730  4283.393     0.150
    56.744  4278.771     0.150
    57.794  4357.727     0.150
    57.805  4361.668     0.150
    57.812  4375.191     0.150
     0.198     8.688     0.150
     1.933    32.768     0.150
     2.948    82.818     0.150
     3.361    49.898     0.150
     3.747    57.449     0.150
     4.168    60.748     0.150
     5.649    81.119     0.150
     6.712    96.449     0.150
     7.157   101.289     0.150
    14.462   207.879     0.150
    14.662   208.338     0.150
    56.732  4276.445     0.150
    56.734  4276.951     0.150
    56.749  4278.043     0.150
    57.798  4356.754     0.150
    57.809  4354.100     0.150
    57.816  4358.707     0.150
    75.486   704.107     0.150
     0.219     8.445     0.150
     0.479     9.219     0.150
     1.954    31.586     0.150
     2.370    37.781     0.150
     2.958    44.344     0.150
     4.187    60.883     0.150
     4.953    73.461     0.150
     5.661   145.102     0.150
     6.196    88.992     0.150
     6.552   163.031     0.150
     7.283   103.672     0.150
     8.045   249.898     0.150
     8.117   252.391     0.150
     8.207   118.812     0.150
     8.258   254.555     0.150
     8.318   255.703     0.150
    56.714  4277.891     0.150
    56.717  4278.094     0.150
    56.731  4279.172     0.150
     0.712    12.629     0.150
     0.861    27.781     0.150
     1.045    18.898     0.150
     4.784    71.934     0.150
     4.784   124.285     0.150
     4.784   153.461     0.150
     4.858    74.051     0.150
     6.094   182.449     0.150
     6.277   188.770     0.150
     6.635   198.711     0.150
     7.736   113.039     0.150
     8.089   121.430     0.150
     8.668   127.258     0.150
    86.053   138.848     0.150
     9.771   140.230     0.150
    10.721   334.754     0.150
    11.053   161.961     0.150
     9.893   170.270     0.150
    13.434   417.426     0.150
    17.119   243.883     0.150
    90.813   281.258     0.150
    51.706   283.758     0.150
    61.548   289.609     0.150
    24.607   320.238     0.150
    25.000   323.871     0.150
    31.829   388.570     0.150
    57.446  4288.934     0.150
    57.448  4288.453     0.150
    57.463  4303.703     0.150
    58.519  4359.363     0.150
    58.530  4353.480     0.150
    58.537  4353.789     0.150
    67.454   656.719     0.150
    71.999   685.059     0.150
    73.677   694.328     0.150
    74.688   700.281     0.150
    76.648   711.000     0.150
   143.569  1172.680     0.150
     1.334    23.246     0.150
     4.157   111.637     0.150
     4.573    78.688     0.150
     0.691    22.762     0.150
     0.691    12.803     0.150
     0.765    13.982     0.150
     0.796    25.002     0.150
     0.853    15.133     0.150
     2.704    42.242     0.150
     4.722    82.553     0.150
     5.448   163.322     0.150
     5.448    81.162     0.150
     7.029   104.123     0.150
     8.428   123.623     0.150
    14.935   213.912     0.150
     2.718    77.379     0.150
     0.291     9.445     0.150
     0.685    22.547     0.150
     0.801    17.146     0.150
     0.801    15.176     0.150
     0.852    27.377     0.150
     0.992    31.426     0.150
     1.476    45.326     0.150
     3.981    62.086     0.150
     4.661    84.156     0.150
     4.661    71.457     0.150
     5.442    81.336     0.150
     5.442   163.877     0.150
     6.097   182.996     0.150
     6.885   206.207     0.150
     7.227   216.146     0.150
     7.309   220.037     0.150
     7.542   227.316     0.150
     7.560   108.896     0.150
    11.959   175.057     0.150
    12.411   383.156     0.150
    13.380   415.605     0.150
    14.316   206.826     0.150
    14.515   444.906     0.150
    14.515   208.656     0.150
    15.287   219.707     0.150
    17.253   242.016     0.150
    51.740   283.967     0.150
    21.108   285.986     0.150
    21.137   285.287     0.150
    72.163   302.797     0.150
    90.484   365.168     0.150
    79.364   366.508     0.150
    31.831   387.477     0.150
    57.552  4295.664     0.150
    57.554  4293.961     0.150
    57.569  4291.668     0.150
    58.626  4368.305     0.150
    58.637  4369.031     0.150
    58.644  4369.781     0.150
    39.809   621.137     0.150
    74.050   692.238     0.150
    74.562   701.656     0.150
    77.047     4.801     0.150
    88.311   772.105     0.150
     0.688    12.582     0.150
     0.688    22.262     0.150
     0.766    14.109     0.150
     0.855    15.289     0.150
     0.911    28.691     0.150
     1.825    56.652     0.150
     2.702    42.172     0.150
     2.702    42.062     0.150
     4.655    82.484     0.150
     7.312   104.320     0.150
     7.661   110.051     0.150
     9.485   135.020     0.150
    10.693   324.055     0.150
    13.375   415.816     0.150
    14.510   439.211     0.150
    17.077   237.332     0.150
    57.552  4296.508     0.150
    57.555  4297.434     0.150
    57.569  4296.895     0.150
     0.294     5.633     0.150
     0.294     9.713     0.150
     0.854    15.424     0.150
     1.344    41.213     0.150
     3.155    47.812     0.150
     3.155    47.793     0.150
     4.697   148.197     0.150
     6.575    98.613     0.150
     6.575    98.742     0.150
    11.933   289.668     0.150
    13.070   408.174     0.150
    18.788   257.775     0.150
    32.272   386.822     0.150
    57.075  4271.527     0.150
    57.078  4272.043     0.150
    57.092  4272.727     0.150
    58.152  4352.969     0.150
    58.163  4351.967     0.150
    58.170  4354.771     0.150
    13.975   435.383     0.150
    15.505   481.156     0.150
    56.708  4286.215     0.150
    56.711  4287.031     0.150
    56.725  4288.453     0.150
    57.772  4363.406     0.150
    57.783  4363.277     0.150
    57.790  4364.723     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.478     9.398     0.150
     0.556    10.297     0.150
     0.556    17.797     0.150
     0.735    12.500     0.150
     0.794    14.500     0.150
     0.929    16.602     0.150
     0.946    16.500     0.150
     1.084    18.797     0.150
     1.300    22.797     0.150
     1.929    31.703     0.150
     2.572    40.398     0.150
     3.242    52.297     0.150
     3.929    59.500     0.150
     3.964    59.703     0.150
     4.082    63.102     0.150
     4.176    62.797     0.150
     4.644    71.102     0.150
     4.769    72.227     0.150
     4.776    72.297     0.150
     5.243    79.000     0.150
     5.322    79.938     0.150
     5.694    85.242     0.150
     5.984    89.297     0.150
     7.188   218.203     0.150
     7.195   106.102     0.150
     7.195   186.703     0.150
     7.195   224.500     0.150
     7.415   112.258     0.150
     7.439   113.562     0.150
     7.736   116.398     0.150
     7.795   118.727     0.150
     7.949   120.398     0.150
     8.081   123.117     0.150
     8.135   121.930     0.150
     8.204   123.203     0.150
     8.213   123.062     0.150
     8.287   125.406     0.150
     8.325   125.641     0.150
     8.566   128.297     0.150
     8.600   127.898     0.150
     8.811   132.000     0.150
     9.034   133.500     0.150
     9.364   137.000     0.150
    10.236   150.000     0.150
    10.735   153.203     0.150
    10.784   160.000     0.150
    11.037   159.000     0.150
    11.388   166.898     0.150
    12.231   176.203     0.150
    12.941   184.703     0.150
    13.830   197.000     0.150
    13.830   197.500     0.150
    13.967   203.297     0.150
    14.027   202.500     0.150
    14.547   209.500     0.150
    14.547   216.703     0.150
    14.543   206.398     0.150
    14.571   209.203     0.150
    14.869   210.000     0.150
    15.030   214.703     0.150
    15.030   221.797     0.150
    15.373   218.797     0.150
    15.704   220.500     0.150
    15.793   224.297     0.150
    15.793   229.602     0.150
    16.447   232.797     0.150
    16.660   236.500     0.150
    17.119   237.500     0.150
    17.119   528.000     0.150
    17.347   245.000     0.150
    17.526   246.000     0.150
    17.846   249.797     0.150
    18.171   255.500     0.150
    18.523   259.500     0.150
    18.530   259.500     0.150
    18.692   262.297     0.150
    18.693   261.500     0.150
    20.297   279.000     0.150
    20.436   281.000     0.150
    20.659   280.500     0.150
    20.747   282.898     0.150
    20.828   284.602     0.150
    21.168   287.000     0.150
    21.398   290.000     0.150
    21.756   295.000     0.150
    21.792   295.000     0.150
    21.967   294.297     0.150
    22.181   298.000     0.150
    22.566   303.000     0.150
    22.934   307.000     0.150
    22.945   305.703     0.150
    23.010   305.000     0.150
    23.616   313.000     0.150
    23.890   316.000     0.150
    25.409   328.500     0.150
    25.730   332.500     0.150
    25.733   332.797     0.150
    26.164   337.000     0.150
    29.825   369.500     0.150
    30.332   373.602     0.150
    30.494   374.203     0.150
    32.653   393.000     0.150
    35.522   417.797     0.150
    36.468   426.000     0.150
    37.132   433.203     0.150
    38.444   442.500     0.150
    45.674   502.000     0.150
    45.674   502.500     0.150
    48.172   521.898     0.150
    48.172   608.000     0.150
    51.980   551.000     0.150
    53.711   562.203     0.150
    53.711   628.000     0.150
    56.750   583.000     0.150
    56.750   583.797     0.150
    57.976   597.000     0.150
    57.976   597.398     0.150
    61.657   618.797     0.150
    62.437   623.500     0.150
    62.763   625.797     0.150
    63.188   633.000     0.150
    63.822   630.797     0.150
    64.390   635.703     0.150
    64.390     5.297     0.150
    64.558   638.203     0.150
    65.159   642.297     0.150
    66.119   650.000     0.150
    66.466   651.000     0.150
    66.466   684.000     0.150
    68.779   664.797     0.150
    69.249   668.000     0.150
    69.667   670.797     0.150
    69.763   672.000     0.150
    69.763     4.203     0.150
    69.782   672.000     0.150
    69.876   672.398     0.150
    69.929   673.203     0.150
    69.929     4.195     0.150
    69.929   672.500     0.150
    69.981   669.000     0.150
    70.000   673.500     0.150
    70.000     3.797     0.150
    70.652   678.000     0.150
    70.945   678.000     0.150
    70.945   692.000     0.150
    71.005   679.523     0.150
    71.038   679.820     0.150
    71.041   680.000     0.150
    71.323   681.000     0.150
    71.333   684.000     0.150
    71.333   685.000     0.150
    71.661   683.000     0.150
    71.661     4.000     0.150
    71.678   683.297     0.150
    71.949   684.000     0.150
    71.949   705.500     0.150
    72.070   685.797     0.150
    72.173   685.500     0.150
    72.202   685.000     0.150
    72.272   687.000     0.150
    72.331   687.297     0.150
    72.385   687.500     0.150
    72.411   687.898     0.150
    72.527   688.297     0.150
    72.608   688.398     0.150
    72.621   688.797     0.150
    72.625   692.500     0.150
    72.662   688.898     0.150
    72.667   689.203     0.150
    72.706   689.102     0.150
    72.771   688.000     0.150
    72.771   688.398     0.150
    72.877   690.500     0.150
    72.886   690.102     0.150
    72.963   692.000     0.150
    72.963   692.297     0.150
    73.202   692.703     0.150
    73.208   693.398     0.150
    73.365   693.102     0.150
    73.427   692.797     0.150
    73.435   691.602     0.150
    73.439   693.898     0.150
    73.552   694.500     0.150
    73.684   695.000     0.150
    73.684   695.297     0.150
    73.813   696.102     0.150
    73.878   696.398     0.150
    73.975   698.102     0.150
    74.362   700.000     0.150
    74.572   699.398     0.150
    74.783   702.602     0.150
    74.879   706.398     0.150
    75.003   702.898     0.150
    75.072   702.000     0.150
    75.222   703.500     0.150
    75.489   705.000     0.150
    75.498   705.398     0.150
    76.475   711.898     0.150
    76.520   711.703     0.150
    76.532   712.398     0.150
    76.686   712.797     0.150
    77.007   718.500     0.150
    77.128   715.797     0.150
    77.128     3.203     0.150
    77.199   714.000     0.150
    78.177   720.203     0.150
    78.552   726.500     0.150
    78.543   721.500     0.150
    78.637   722.500     0.150
    78.637     4.000     0.150
    78.828   726.000     0.150
    78.917   725.000     0.150
    78.920   725.602     0.150
    79.157   727.000     0.150
    81.732   739.000     0.150
    82.425   741.797     0.150
    82.586   744.398     0.150
    83.080   746.203     0.150
    83.547   748.000     0.150
    83.583   750.000     0.150
    83.583   750.297     0.150
    84.689   758.000     0.150
    85.661   760.000     0.150
    85.649   759.000     0.150
    85.649   759.500     0.150
    85.875   760.000     0.150
    86.642   766.000     0.150
    86.909   766.000     0.150
    88.164   771.000     0.150
    88.187   772.000     0.150
    88.207   772.000     0.150
    88.399   775.000     0.150
    88.695   775.000     0.150
    89.721   780.000     0.150
    92.428   792.797     0.150
    92.730   794.000     0.150
    92.731   793.602     0.150
    92.893   794.398     0.150
    92.953   795.203     0.150
   145.136  1178.000     0.150
   147.695  1185.000     0.150
   147.866  1188.000     0.150
   148.088  1186.500     0.150
   148.600  1190.000     0.150
   150.345  1196.000     0.150
     0.484     9.383     0.150
     0.557    10.281     0.150
     0.557    17.781     0.150
     0.748    12.383     0.150
     0.810    14.781     0.150
     0.945    16.883     0.150
     0.955    17.078     0.150
     1.089    18.883     0.150
     1.315    22.984     0.150
     1.940    31.578     0.150
     2.572    40.484     0.150
     3.227    52.484     0.150
     3.924    60.578     0.150
     3.924   120.578     0.150
     4.164    61.781     0.150
     4.630    70.984     0.150
     4.773    72.430     0.150
     4.777    71.781     0.150
     5.246    77.781     0.150
     5.696    85.414     0.150
     5.968    89.578     0.150
     7.185   105.883     0.150
     8.597   128.781     0.150
    13.824   196.781     0.150
    14.531   209.781     0.150
    14.869   217.984     0.150
    15.702   222.781     0.150
    16.442   231.781     0.150
    17.106   238.781     0.150
    17.351   246.578     0.150
    18.527   261.281     0.150
    20.739   279.484     0.150
    22.931   306.281     0.150
     0.495     9.305     0.150
     0.495    16.609     0.150
     0.532     9.805     0.150
     0.532    17.508     0.150
     0.737    12.305     0.150
     0.802    14.305     0.150
     0.771    14.109     0.150
     0.915    16.305     0.150
     0.957    17.008     0.150
     0.957    31.305     0.150
     1.103    34.508     0.150
     1.271    22.805     0.150
     1.271    39.711     0.150
     1.898    34.008     0.150
     1.898    58.305     0.150
     2.548    39.711     0.150
     2.548    44.508     0.150
     2.548    77.805     0.150
     3.270    51.305     0.150
     3.270    58.211     0.150
     3.270   100.805     0.150
     4.113    63.805     0.150
     4.113   128.008     0.150
     4.176    63.109     0.150
     4.176    74.508     0.150
     4.176   128.109     0.150
     4.673    72.008     0.150
     6.007    89.406     0.150
     0.484     9.418     0.150
     0.551    10.016     0.150
     0.551    17.516     0.150
     0.718    12.918     0.150
     0.741    12.617     0.150
     0.796    14.516     0.150
     0.784    14.316     0.150
     0.784    24.316     0.150
     0.933    16.617     0.150
     0.952    17.316     0.150
     0.952    30.715     0.150
     1.090    18.918     0.150
     1.300    22.816     0.150
     1.300    40.316     0.150
     1.927    34.215     0.150
     2.567    39.918     0.150
     2.567    78.316     0.150
     3.242    51.117     0.150
     3.242    57.918     0.150
     3.242   100.816     0.150
     3.934    59.418     0.150
     3.959    59.316     0.150
     4.084    62.816     0.150
     4.084    74.117     0.150
     4.171    62.316     0.150
     4.171    74.316     0.150
     4.171   127.316     0.150
     4.644    71.117     0.150
     4.644   145.516     0.150
     4.764    72.105     0.150
     4.771    72.016     0.150
     4.771   146.016     0.150
     5.239    78.816     0.150
     5.239   160.316     0.150
     5.689    84.977     0.150
     5.982    89.316     0.150
     7.198   106.016     0.150
     7.198   228.918     0.150
     9.359   139.816     0.150
    12.936   186.316     0.150
    14.545   206.316     0.150
    22.945   307.816     0.150
     0.111     3.234     0.150
     0.308     5.938     0.150
     0.308     9.938     0.150
     0.469     8.438     0.150
     0.655    12.141     0.150
     0.643    10.938     0.150
     0.744    13.641     0.150
     0.989    17.141     0.150
     0.989    30.641     0.150
     1.343    23.336     0.150
     2.080    34.039     0.150
     2.080    36.734     0.150
     2.080    64.141     0.150
     2.982    45.336     0.150
     3.320    52.141     0.150
     3.647    54.438     0.150
     4.069    62.734     0.150
     4.069   126.641     0.150
     4.312    64.438     0.150
     4.636    68.938     0.150
     4.692    71.836     0.150
     5.093    76.586     0.150
     6.054    89.391     0.150
     6.190    92.039     0.150
     7.043   103.438     0.150
     7.043   219.938     0.150
     7.524   111.438     0.150
    10.849   157.539     0.150
    11.067   162.438     0.150
    11.207   160.938     0.150
    11.873   168.938     0.150
    13.419   190.438     0.150
    14.473   213.141     0.150
    14.478   205.438     0.150
    15.338   215.438     0.150
    16.152   227.438     0.150
    17.568   242.438     0.150
    17.672   249.438     0.150
    20.523   279.539     0.150
    22.964   305.938     0.150
     0.420     7.977     0.150
     0.420    14.574     0.150
     0.494    16.176     0.150
     0.698    11.875     0.150
     0.759    13.676     0.150
     0.759    24.176     0.150
     0.978    16.977     0.150
     0.978    30.977     0.150
     1.060    17.977     0.150
     1.060    32.477     0.150
     1.123    18.977     0.150
     3.509    53.777     0.150
     3.509    63.777     0.150
     3.509   105.676     0.150
     3.748    56.066     0.150
     3.970    60.336     0.150
     4.309    66.074     0.150
     4.309   114.777     0.150
     4.309   134.277     0.150
     4.473    66.176     0.150
     4.473   136.176     0.150
     6.042   155.074     0.150
     6.042   192.574     0.150
     6.299    93.977     0.150
     6.299   198.375     0.150
     0.618    11.660     0.150
     0.639    11.262     0.150
     0.727    13.262     0.150
     0.893    15.062     0.150
     0.987    17.160     0.150
     1.265    22.160     0.150
     2.651    41.633     0.150
     2.651    79.730     0.150
     2.651    40.461     0.150
     2.651    46.660     0.150
     2.651    81.461     0.150
     3.007    49.160     0.150
     3.284    53.762     0.150
     3.284    60.762     0.150
     3.883    58.352     0.150
     3.883   117.863     0.150
     4.023    61.762     0.150
     4.104    63.262     0.150
     4.104   108.562     0.150
     4.104   127.062     0.150
     4.694    71.434     0.150
     4.694   145.230     0.150
     4.821    74.441     0.150
     5.825    84.762     0.150
     5.825   179.262     0.150
     6.057    91.262     0.150
     6.057   192.262     0.150
     6.177   186.531     0.150
     7.080   104.211     0.150
     7.080   181.910     0.150
     7.080   102.961     0.150
     7.080   183.160     0.150
     7.260   220.113     0.150
     7.714   113.312     0.150
    13.428   191.363     0.150
    13.428   427.062     0.150
    14.792   215.113     0.150
    15.636   225.441     0.150
    18.263   252.062     0.150
    18.263   575.160     0.150
    20.261   278.832     0.150
    20.535   282.184     0.150
    21.160   284.562     0.150
    21.160   665.363     0.150
    21.160   747.762     0.150
    21.856   295.363     0.150
    22.083   293.262     0.150
    31.784   385.562     0.150
    32.825   394.461     0.150
    36.545   425.762     0.150
    56.860   585.062     0.150
     0.252     4.977     0.150
     0.474     8.375     0.150
     0.574    10.977     0.150
     0.662    12.180     0.150
     0.662    20.977     0.150
     0.684    11.680     0.150
     0.684    20.180     0.150
     0.972    17.375     0.150
     0.972    31.477     0.150
     1.230    20.773     0.150
     1.230    37.977     0.150
     1.263    21.977     0.150
     2.948    46.148     0.150
     2.948    90.297     0.150
     3.112    50.773     0.150
     3.405    55.375     0.150
     3.715    55.320     0.150
     4.154    63.977     0.150
     4.154   129.977     0.150
     4.262    65.344     0.150
     4.666    69.977     0.150
     4.666    82.773     0.150
     4.666   143.578     0.150
     4.778    72.875     0.150
     4.778    86.773     0.150
     4.778   152.375     0.150
     4.792    73.008     0.150
     6.170    91.477     0.150
     6.170   191.773     0.150
     6.269    94.273     0.150
     6.269   195.477     0.150
     7.022   102.547     0.150
     7.022   102.750     0.150
     7.022   218.328     0.150
     7.022   217.680     0.150
    12.342   176.773     0.150
    12.719   177.977     0.150
    12.719   401.477     0.150
    20.531   280.125     0.150
    21.500   288.578     0.150
    22.153   299.000     0.150
    22.459   300.977     0.150
    23.050   305.680     0.150
     0.382     7.098     0.150
     0.382    12.396     0.150
     0.441     8.197     0.150
     0.441    14.207     0.150
     1.216    20.428     0.150
     1.216    36.838     0.150
     1.200    21.908     0.150
     1.184    20.598     0.150
     1.184    37.047     0.150
     1.492    25.678     0.150
     1.492    45.277     0.150
     2.657    40.402     0.150
     2.657    72.502     0.150
     2.657    78.602     0.150
     3.409    51.197     0.150
     3.712    53.896     0.150
     3.712    95.248     0.150
     3.909    57.828     0.150
     3.909   103.557     0.150
     4.030    58.498     0.150
     4.483    65.727     0.150
     4.483   118.088     0.150
     4.573    67.547     0.150
     4.603    67.988     0.150
     4.993    72.928     0.150
     5.179    76.658     0.150
     5.179   134.098     0.150
     5.768    87.047     0.150
     5.768   177.377     0.150
     5.864    85.928     0.150
     5.920    86.697     0.150
     6.166    91.918     0.150
     6.220    93.477     0.150
     6.763    99.078     0.150
     6.763   209.977     0.150
     6.854   101.518     0.150
     8.016   115.857     0.150
     8.918   130.098     0.150
    10.298   148.287     0.150
    13.502   189.373     0.150
    13.502   423.037     0.150
    13.539   188.877     0.150
    13.539   189.408     0.150
    15.088   213.707     0.150
    15.539   220.877     0.150
    15.539   490.053     0.150
    17.240   240.727     0.150
    17.377   244.652     0.150
    22.070   295.617     0.150
    29.849   367.498     0.150
    31.537   383.178     0.150
    76.439   709.453     0.150
     0.218     4.809     0.150
     0.218     9.278     0.150
     0.757    13.429     0.150
     0.757    23.959     0.150
     0.868    15.469     0.150
     0.868    27.349     0.150
     0.824    14.169     0.150
     0.824    25.269     0.150
     0.972    17.419     0.150
     0.972    30.269     0.150
     0.991    17.579     0.150
     0.991    31.389     0.150
     1.527    26.139     0.150
     1.527    47.159     0.150
     2.881    44.318     0.150
     2.881    50.744     0.150
     2.881    88.019     0.150
     2.881    49.719     0.150
     2.881    86.068     0.150
     3.614    56.249     0.150
     4.091    60.629     0.150
     4.280    63.438     0.150
     4.280   124.818     0.150
     4.445    68.179     0.150
     4.445    68.719     0.150
     4.445   136.630     0.150
     4.624    70.339     0.150
     4.625    69.559     0.150
     5.064   146.318     0.150
     5.823    85.749     0.150
     6.801   100.219     0.150
    12.267   171.063     0.150
    18.147   255.419     0.150
    18.462   257.169     0.150
    32.016   388.519     0.150
     0.361     6.793     0.150
     0.586    10.285     0.150
     0.586    19.203     0.150
     0.866    15.305     0.150
     0.866    27.484     0.150
     1.202    20.594     0.150
     1.202    36.242     0.150
     2.467    37.672     0.150
     2.467    74.172     0.150
     3.530    51.914     0.150
     3.530   112.645     0.150
     3.758    55.145     0.150
     4.058    60.602     0.150
     4.058   108.125     0.150
     4.097    60.895     0.150
     4.428   134.684     0.150
     4.533    67.875     0.150
     5.092    77.055     0.150
     5.503   175.664     0.150
     6.082    91.074     0.150
     6.082   112.922     0.150
     6.640    96.953     0.150
     6.640   208.543     0.150
     7.274   106.625     0.150
     7.458   109.395     0.150
     8.226   258.883     0.150
     0.219     4.992     0.150
     0.219     9.562     0.150
     0.519     9.570     0.150
     0.519    16.867     0.150
     0.609    10.875     0.150
     0.609    19.797     0.150
     0.663    20.781     0.150
     0.926    16.695     0.150
     0.926    28.711     0.150
     1.211    20.562     0.150
     1.211    36.156     0.150
     1.246    21.453     0.150
     2.905    43.914     0.150
     2.905    51.734     0.150
     2.905    89.164     0.150
     3.998    58.656     0.150
     3.998   115.344     0.150
     4.224    62.992     0.150
     4.224   107.914     0.150
     4.224   123.234     0.150
     4.527    67.836     0.150
     4.564   132.547     0.150
     4.623    68.727     0.150
     4.623    81.094     0.150
     4.623   134.766     0.150
     4.790    73.945     0.150
     5.047    74.727     0.150
     0.571    10.664     0.150
     0.404     8.023     0.150
     0.404    14.203     0.150
     0.866    15.594     0.150
     0.866    26.594     0.150
     0.741    13.414     0.150
     0.741    23.473     0.150
     0.867    15.496     0.150
     0.867    27.543     0.150
     0.905    15.844     0.150
     0.905    28.066     0.150
     1.253    22.023     0.150
     1.253    39.105     0.150
     2.585    40.168     0.150
     2.585    45.543     0.150
     2.585    71.152     0.150
     2.585    78.293     0.150
     2.585    43.266     0.150
     2.585    78.543     0.150
     3.769    56.176     0.150
     3.964    58.746     0.150
     3.964    71.363     0.150
     3.936    59.785     0.150
     4.231    63.824     0.150
     4.231    76.504     0.150
     4.231   130.895     0.150
     4.231    63.723     0.150
     4.307    64.113     0.150
     4.307   136.105     0.150
     4.303    64.996     0.150
     4.732    69.914     0.150
     4.732    83.844     0.150
     4.732   143.773     0.150
     4.757    71.234     0.150
     4.757   142.434     0.150
     4.704    71.895     0.150
     4.704   126.523     0.150
     4.704   145.871     0.150
     4.704    71.746     0.150
     4.704    84.246     0.150
     4.704   145.445     0.150
     4.764    71.246     0.150
     5.330   160.543     0.150
     5.696    84.426     0.150
     5.696    95.195     0.150
     5.811    86.195     0.150
     5.811   179.816     0.150
     5.987   182.793     0.150
     6.133   187.523     0.150
     6.313   191.566     0.150
     6.401    96.176     0.150
     6.401   193.465     0.150
     6.278    92.633     0.150
     6.278   161.453     0.150
     6.278   193.395     0.150
     6.586   199.145     0.150
     6.688    99.363     0.150
     6.688   203.445     0.150
     6.712   208.293     0.150
     7.065   215.223     0.150
     7.196   140.543     0.150
     7.196   219.645     0.150
     7.196   104.816     0.150
     7.116   104.816     0.150
     7.116   182.543     0.150
     7.116   218.566     0.150
     7.646   148.465     0.150
     7.646   235.996     0.150
     7.759   113.016     0.150
     7.759   247.605     0.150
     8.038   117.223     0.150
     8.038   255.234     0.150
     8.183   119.086     0.150
     8.183   252.754     0.150
     8.539   124.344     0.150
     8.539   266.496     0.150
     8.625   265.094     0.150
    10.577   327.043     0.150
    10.577   152.484     0.150
    10.786   338.125     0.150
    11.063   159.094     0.150
    11.063   347.996     0.150
    11.916   373.613     0.150
    12.397   174.039     0.150
    12.434   174.805     0.150
    12.434   393.445     0.150
    13.479   192.746     0.150
    14.382   203.656     0.150
    14.580   206.902     0.150
    14.580   207.914     0.150
    14.580   205.203     0.150
    15.174   215.906     0.150
    15.791   223.984     0.150
    16.457   230.625     0.150
    17.020   241.121     0.150
    17.564   244.664     0.150
    17.827   251.055     0.150
    18.194   253.844     0.150
    18.194   256.855     0.150
    19.879   274.434     0.150
    20.196   276.535     0.150
    20.256   275.316     0.150
    21.111   283.566     0.150
    21.552   290.035     0.150
    22.018   293.746     0.150
    22.174   296.855     0.150
    23.993   315.395     0.150
    29.781   367.184     0.150
    31.719   385.695     0.150
    31.719   556.270     0.150
    62.749   624.895     0.150
    74.600   698.844     0.150
    74.822   698.195     0.150
    75.205   703.195     0.150
    75.752   706.020     0.150
    75.824   706.426     0.150
    75.824   706.418     0.150
    77.145   713.895     0.150
    77.145   720.895     0.150
   149.641  1190.793     0.150
   149.641  1192.996     0.150
   149.641  1188.496     0.150
   150.407  1192.695     0.150
   150.407  1190.395     0.150
     0.417     8.404     0.150
     0.417    14.574     0.150
     0.559    10.804     0.150
     0.559    18.304     0.150
     0.751    13.504     0.150
     0.751    23.754     0.150
     0.751    13.813     0.150
     0.751    23.974     0.150
     0.887    15.944     0.150
     0.887    27.554     0.150
     0.887    27.134     0.150
     0.887    15.894     0.150
     0.887    27.134     0.150
     0.851    15.914     0.150
     0.851    26.954     0.150
     0.921    16.214     0.150
     0.921    29.554     0.150
     0.921    16.584     0.150
     1.259    22.304     0.150
     1.259    39.044     0.150
     1.259    22.464     0.150
     1.259    39.494     0.150
     1.935    31.914     0.150
     1.935    56.034     0.150
     2.574    40.474     0.150
     2.574    44.023     0.150
     2.574    72.444     0.150
     2.574    78.404     0.150
     2.665    42.384     0.150
     3.942    59.904     0.150
     4.697    72.254     0.150
     4.697   146.104     0.150
     5.149    76.313     0.150
     6.058    91.234     0.150
     6.058   160.594     0.150
     6.058   189.604     0.150
     7.116   104.424     0.150
     7.327   230.884     0.150
     8.017   117.714     0.150
     9.361   135.514     0.150
    10.564   326.379     0.150
    10.636   152.654     0.150
    12.051   172.614     0.150
    12.384   176.834     0.150
    12.384   389.854     0.150
    12.823   182.684     0.150
    13.415   190.584     0.150
    13.484   193.054     0.150
    14.034   198.934     0.150
    15.634   220.004     0.150
    17.820   246.004     0.150
    18.181   256.384     0.150
    18.181   251.434     0.150
    20.178   281.114     0.150
    20.458   281.523     0.150
    21.380   290.184     0.150
    24.811   323.894     0.150
    36.479   426.654     0.150
    75.755   706.273     0.150
    75.822   706.804     0.150
    77.149   714.854     0.150
    77.149   721.854     0.150
    77.149   890.254     0.150
    85.660   759.954     0.150
    88.560   772.454     0.150
     0.637    11.365     0.150
     0.637    20.457     0.150
     2.657    46.814     0.150
     2.657    80.844     0.150
     2.885    45.943     0.150
     2.885    88.354     0.150
     3.805   101.023     0.150
     3.805   117.373     0.150
     5.779    87.045     0.150
     5.981    90.451     0.150
     5.981    88.283     0.150
     6.132    90.834     0.150
     7.049   103.174     0.150
     6.937   102.064     0.150
     7.262   107.154     0.150
     7.584   110.984     0.150
     8.665   125.104     0.150
     9.028   132.453     0.150
     9.266   135.984     0.150
    10.038   144.385     0.150
    10.146   147.363     0.150
    10.251   148.533     0.150
    10.311   149.064     0.150
    10.324   149.164     0.150
    10.423   150.613     0.150
    10.416   151.283     0.150
    10.666   153.363     0.150
    10.813   155.154     0.150
    10.772   157.535     0.150
    11.030   162.072     0.150
    11.519   164.523     0.150
    11.532   164.064     0.150
    11.533   169.498     0.150
    11.635   170.523     0.150
    11.914   170.754     0.150
    11.859   172.385     0.150
    12.038   170.295     0.150
    11.953   175.041     0.150
    12.033   174.381     0.150
    12.242   173.635     0.150
    12.586   179.873     0.150
    12.781   182.613     0.150
    12.994   184.654     0.150
    12.994   325.965     0.150
    13.126   187.203     0.150
    13.153   187.354     0.150
    13.692   192.789     0.150
    13.692   192.783     0.150
    13.903   198.145     0.150
    13.800   196.113     0.150
    14.089   201.475     0.150
    14.269   201.334     0.150
    14.342   203.244     0.150
    14.371   204.744     0.150
    14.307   212.172     0.150
    14.565   205.975     0.150
    14.677   208.904     0.150
    15.004   212.514     0.150
    15.012   212.084     0.150
    15.012   219.910     0.150
    15.038   214.283     0.150
    15.562   221.305     0.150
    15.715   224.953     0.150
    16.199   231.033     0.150
    16.741   239.084     0.150
    16.788   238.754     0.150
    16.818   238.033     0.150
    16.942   238.514     0.150
    17.040   237.635     0.150
    16.983   241.314     0.150
    17.241   243.453     0.150
    17.241   243.809     0.150
    17.297   244.584     0.150
    17.643   249.184     0.150
    17.689   250.055     0.150
    18.022   264.236     0.150
    18.187   253.895     0.150
    18.187   254.777     0.150
    18.276   255.984     0.150
    18.276   255.203     0.150
    18.441   257.637     0.150
    18.852   263.551     0.150
    19.068   266.062     0.150
    19.340   268.984     0.150
    19.340   268.775     0.150
    19.394   268.654     0.150
    19.510   271.240     0.150
    19.617   271.555     0.150
    19.617   271.426     0.150
    19.627   271.789     0.150
    19.868   273.834     0.150
    19.980   273.221     0.150
    19.867   276.385     0.150
    20.095   276.254     0.150
    20.068   276.232     0.150
    20.186   277.064     0.150
    20.251   278.645     0.150
    20.237   277.777     0.150
    20.558   283.064     0.150
    20.558   281.561     0.150
    20.643   279.744     0.150
    20.554   281.674     0.150
    20.590   281.475     0.150
    20.704   281.873     0.150
    20.704   282.734     0.150
    20.672   282.604     0.150
    20.780   283.760     0.150
    21.061   286.975     0.150
    21.151   287.682     0.150
    21.188   288.170     0.150
    21.450   289.551     0.150
    21.426   290.674     0.150
    21.461   291.844     0.150
    21.434   291.137     0.150
    21.454   290.754     0.150
    21.505   290.555     0.150
    21.567   291.924     0.150
    21.567   530.564     0.150
    21.578   291.504     0.150
    21.646   292.033     0.150
    21.680   292.564     0.150
    21.711   291.674     0.150
    21.733   292.314     0.150
    21.732   293.725     0.150
    21.757   293.055     0.150
    21.761   294.145     0.150
    21.844   294.684     0.150
    22.071   296.863     0.150
    22.013   296.742     0.150
    22.186   298.344     0.150
    22.186   297.361     0.150
    22.188   298.324     0.150
    22.193   298.221     0.150
    22.207   298.846     0.150
    22.238   298.627     0.150
    22.731   303.773     0.150
    22.731   303.154     0.150
    22.811   305.354     0.150
    22.845   304.740     0.150
    23.194   308.613     0.150
    23.194   308.768     0.150
    23.176   307.973     0.150
    23.904   315.725     0.150
    23.904   315.566     0.150
    24.151   318.934     0.150
    24.599   322.791     0.150
    25.073   325.350     0.150
    25.233   327.674     0.150
    25.527   330.354     0.150
    25.527   330.072     0.150
    29.799   368.211     0.150
    30.763   375.518     0.150
    31.329   380.760     0.150
    31.441   383.104     0.150
    31.442   383.055     0.150
    31.442   383.059     0.150
    31.660   383.402     0.150
    31.776   385.096     0.150
    31.898   385.648     0.150
    31.962   386.730     0.150
    32.072   386.951     0.150
    32.328   390.033     0.150
    32.354   388.844     0.150
    32.468   390.664     0.150
    32.468   389.029     0.150
    32.874   393.592     0.150
    32.908   395.254     0.150
    32.908   394.799     0.150
    33.138   398.084     0.150
    35.378   415.475     0.150
    35.847   419.305     0.150
    39.106   448.053     0.150
    63.025   627.514     0.150
    63.025   627.514     0.150
    69.365   668.324     0.150
    69.369   668.322     0.150
    76.615   712.014     0.150
    76.615   712.018     0.150
    79.025   727.885     0.150
     0.383     7.520     0.150
     0.383    13.258     0.150
     0.414     7.047     0.150
     0.414    12.566     0.150
     0.398     7.488     0.150
     0.398    13.488     0.150
     0.398     7.617     0.150
     0.398     6.809     0.150
     0.398    12.629     0.150
     0.457     8.398     0.150
     0.457    14.547     0.150
     1.200    20.770     0.150
     1.200    37.027     0.150
     1.942    31.699     0.150
     2.638    41.246     0.150
     2.638    78.789     0.150
     2.698    41.598     0.150
     3.389    49.547     0.150
     3.389    87.477     0.150
     3.607    55.207     0.150
     3.692    53.520     0.150
     3.692    94.309     0.150
     3.831    56.918     0.150
     3.831    97.637     0.150
     3.889    57.316     0.150
     3.889   100.758     0.150
     4.010    58.789     0.150
     4.010   104.887     0.150
     4.093    59.586     0.150
     4.093   105.379     0.150
     4.387    64.289     0.150
     4.462    65.727     0.150
     4.590    67.770     0.150
     4.590   121.316     0.150
     4.982    75.539     0.150
     4.982   152.520     0.150
     5.026   152.418     0.150
     5.159    73.387     0.150
     5.159   132.578     0.150
     5.365   138.988     0.150
     5.428   140.477     0.150
     5.456    78.727     0.150
     5.595    82.816     0.150
     5.776    87.348     0.150
     5.776    88.488     0.150
     5.776   179.156     0.150
     5.844    85.438     0.150
     6.200    92.520     0.150
     6.528    94.867     0.150
     6.755    98.898     0.150
     6.755   209.309     0.150
     6.777   210.758     0.150
     6.834   100.527     0.150
     6.868   100.957     0.150
     6.997   102.977     0.150
     7.106   104.477     0.150
     7.673   112.289     0.150
     7.939   116.598     0.150
     8.016   115.887     0.150
     8.453   123.926     0.150
     8.515   124.457     0.150
     8.515   123.520     0.150
     8.889   131.121     0.150
     8.901   128.246     0.150
     8.865   127.656     0.150
     9.103   133.609     0.150
     9.323   136.996     0.150
    10.154   145.156     0.150
    10.368   149.059     0.150
    10.521   154.969     0.150
    10.678   156.641     0.150
    10.690   153.398     0.150
    10.773   157.637     0.150
    11.125   160.527     0.150
    11.085   159.547     0.150
    11.096   159.758     0.150
    11.167   164.129     0.150
    11.292   166.129     0.150
    11.312   161.727     0.150
    11.387   162.949     0.150
    11.412   162.676     0.150
    11.536   168.359     0.150
    11.668   170.977     0.150
    11.768   171.477     0.150
    11.799   170.117     0.150
    11.863   169.316     0.150
    11.863   165.988     0.150
    11.924   174.098     0.150
    11.960   173.488     0.150
    11.938   170.047     0.150
    12.113   173.246     0.150
    12.322   177.656     0.150
    12.417   175.797     0.150
    12.461   178.770     0.150
    12.472   179.926     0.150
    12.476   175.859     0.150
    12.582   181.699     0.150
    12.558   177.992     0.150
    12.579   178.469     0.150
    12.675   183.629     0.150
    12.629   179.848     0.150
    12.659   181.676     0.150
    12.725   182.328     0.150
    12.830   184.367     0.150
    12.803   181.836     0.150
    12.821   182.996     0.150
    12.986   186.176     0.150
    13.110   191.020     0.150
    13.208   190.879     0.150
    13.192   187.699     0.150
    13.267   191.008     0.150
    13.501   188.441     0.150
    13.501   188.727     0.150
    13.539   190.867     0.150
    13.594   196.598     0.150
    13.697   194.719     0.150
    13.771   196.609     0.150
    13.788   196.477     0.150
    13.851   198.520     0.150
    13.949   199.008     0.150
    14.115   199.547     0.150
    14.115   203.707     0.150
    14.209   202.520     0.150
    14.223   202.367     0.150
    14.223   208.168     0.150
    14.273   203.246     0.150
    14.273   209.648     0.150
    14.555   207.258     0.150
    14.879   213.117     0.150
    14.822   210.777     0.150
    14.868   210.098     0.150
    15.068   215.789     0.150
    15.127   213.816     0.150
    15.089   212.719     0.150
    15.200   216.098     0.150
    15.288   214.688     0.150
    15.288   214.945     0.150
    15.418   218.258     0.150
    15.551   219.598     0.150
    15.551   220.469     0.150
    15.551   217.398     0.150
    15.859   226.926     0.150
    16.039   229.969     0.150
    16.212   230.809     0.150
    16.220   231.277     0.150
    16.309   233.707     0.150
    16.516   233.477     0.150
    16.607   234.168     0.150
    16.717   236.816     0.150
    16.836   239.969     0.150
    16.901   240.449     0.150
    16.920   241.078     0.150
    16.920   240.949     0.150
    16.920   240.020     0.150
    16.974   241.168     0.150
    16.990   239.078     0.150
    17.086   241.598     0.150
    17.100   241.707     0.150
    17.100   243.086     0.150
    17.112   242.918     0.150
    17.184   240.008     0.150
    17.357   244.887     0.150
    17.357   245.273     0.150
    17.768   250.957     0.150
    17.772   251.258     0.150
    17.814   252.008     0.150
    17.874   249.789     0.150
    17.874   250.109     0.150
    17.856   251.488     0.150
    17.856   250.652     0.150
    17.959   248.336     0.150
    18.218   255.578     0.150
    18.218   254.586     0.150
    18.218   253.449     0.150
    18.218   255.578     0.150
    18.289   253.617     0.150
    18.346   256.137     0.150
    19.159   266.008     0.150
    19.192   266.016     0.150
    19.451   269.367     0.150
    19.451   269.156     0.150
    19.747   271.398     0.150
    19.747   272.457     0.150
    19.749   273.469     0.150
    19.964   274.426     0.150
    19.996   273.859     0.150
    19.996   276.332     0.150
    20.007   279.102     0.150
    20.066   276.656     0.150
    20.185   276.039     0.150
    20.193   276.816     0.150
    20.274   276.609     0.150
    20.314   277.859     0.150
    20.335   278.617     0.150
    20.352   278.117     0.150
    20.339   278.609     0.150
    20.551   279.828     0.150
    20.551   280.027     0.150
    20.532   278.699     0.150
    20.675   281.859     0.150
    20.682   281.527     0.150
    20.747   282.816     0.150
    20.747   285.102     0.150
    20.755   283.777     0.150
    20.895   284.699     0.150
    21.118   285.109     0.150
    21.193   287.688     0.150
    21.197   287.199     0.150
    21.271   288.043     0.150
    21.317   288.277     0.150
    21.476   291.609     0.150
    21.476   290.383     0.150
    21.477   290.559     0.150
    21.486   290.379     0.150
    21.519   292.020     0.150
    21.583   292.469     0.150
    21.594   291.578     0.150
    21.626   292.316     0.150
    21.635   292.188     0.150
    21.637   291.586     0.150
    21.739   292.496     0.150
    21.740   294.797     0.150
    21.770   293.867     0.150
    21.792   294.348     0.150
    21.792   294.828     0.150
    21.823   293.297     0.150
    21.903   294.938     0.150
    21.909   294.406     0.150
    22.050   297.086     0.150
    22.056   294.246     0.150
    22.115   296.527     0.150
    22.652   298.473     0.150
    22.652   299.688     0.150
    22.652   296.977     0.150
    23.246   308.500     0.150
    23.302   309.156     0.150
    23.402   308.453     0.150
    23.416   309.047     0.150
    23.416   309.273     0.150
    23.949   315.191     0.150
    24.236   318.207     0.150
    24.622   322.027     0.150
    25.009   322.488     0.150
    25.201   326.438     0.150
    25.592   328.168     0.150
    25.592   331.316     0.150
    25.592   330.199     0.150
    25.646   333.168     0.150
    25.685   330.168     0.150
    26.209   335.477     0.150
    26.579   338.367     0.150
    26.906   342.773     0.150
    29.829   367.648     0.150
    29.829   367.320     0.150
    30.762   374.996     0.150
    31.307   380.320     0.150
    31.516   382.770     0.150
    31.516   382.648     0.150
    31.516   382.648     0.150
    31.643   381.934     0.150
    31.856   385.520     0.150
    31.881   384.977     0.150
    31.881   384.570     0.150
    31.892   384.406     0.150
    31.965   385.609     0.150
    32.070   386.078     0.150
    32.196   388.496     0.150
    32.335   388.809     0.150
    32.337   388.258     0.150
    32.468   390.156     0.150
    32.541   390.484     0.150
    32.752   393.996     0.150
    32.872   392.566     0.150
    32.897   392.820     0.150
    32.917   394.449     0.150
    33.043   394.664     0.150
    33.094   394.117     0.150
    33.502   398.211     0.150
    33.950   403.141     0.150
    34.210   404.785     0.150
    35.372   414.629     0.150
    35.895   419.250     0.150
    35.948   421.328     0.150
    35.948   420.875     0.150
    36.138   419.062     0.150
    36.394   424.426     0.150
    36.751   427.309     0.150
    36.799   426.703     0.150
    36.813   426.586     0.150
    37.013   429.012     0.150
    37.168   430.867     0.150
    37.436   431.621     0.150
    37.436   433.258     0.150
    37.639   433.879     0.150
    37.933   437.270     0.150
    37.948   437.418     0.150
    38.040   437.848     0.150
    38.237   439.527     0.150
    38.237   439.148     0.150
    38.266   439.410     0.150
    38.316   439.648     0.150
    38.518   441.730     0.150
    38.592   442.383     0.150
    39.019   446.449     0.150
    39.019   445.746     0.150
    39.004   446.848     0.150
    39.004   446.297     0.150
    39.145   447.117     0.150
    39.257   447.445     0.150
    39.682   452.125     0.150
    39.825   452.301     0.150
    40.138   455.977     0.150
    40.138   455.598     0.150
    40.601   459.898     0.150
    40.603   460.066     0.150
    40.603   459.898     0.150
    40.603   460.066     0.150
    41.063   464.117     0.150
    41.063   464.758     0.150
    41.792   469.637     0.150
    41.792   469.297     0.150
    43.587   483.145     0.150
    43.587   483.469     0.150
    44.165   487.496     0.150
    48.625   523.355     0.150
    48.625   523.676     0.150
    48.625   521.699     0.150
    52.002   548.996     0.150
    54.713   568.297     0.150
    56.017   579.648     0.150
    59.421   601.773     0.150
    61.608   616.109     0.150
    61.608   616.109     0.150
    61.608   616.297     0.150
    62.820   624.898     0.150
    62.820   624.898     0.150
    62.820   624.898     0.150
    64.136   633.355     0.150
    64.321   634.172     0.150
    65.775   644.738     0.150
    65.880   644.098     0.150
    65.880   675.598     0.150
    66.010   646.488     0.150
    66.679   649.797     0.150
    66.988   652.098     0.150
    67.776   657.199     0.150
    67.986   658.879     0.150
    67.986   658.879     0.150
    68.739   661.797     0.150
    68.821   666.898     0.150
    69.203   665.199     0.150
    69.207   665.246     0.150
    69.207   665.199     0.150
    70.539   674.699     0.150
    70.749   674.297     0.150
    70.749   830.297     0.150
    70.749  1228.199     0.150
    70.749  1496.496     0.150
    71.598   680.219     0.150
    71.637   681.898     0.150
    72.040   680.496     0.150
    72.460   686.199     0.150
    72.507   686.996     0.150
    72.832   688.316     0.150
    72.817   687.406     0.150
    72.817   687.098     0.150
    72.834   687.438     0.150
    73.295   691.898     0.150
    73.591   691.859     0.150
    73.812   695.496     0.150
    73.841   694.797     0.150
    73.841     7.602     0.150
    74.198   696.699     0.150
    74.381   697.797     0.150
    74.381     7.602     0.150
    74.638   699.039     0.150
    74.638   699.199     0.150
    74.661   699.199     0.150
    74.677   699.270     0.150
    74.677   699.223     0.150
    74.885   700.020     0.150
    74.885   700.996     0.150
    74.885   700.496     0.150
    75.075   701.199     0.150
    75.444   704.949     0.150
    75.572   704.566     0.150
    75.586   705.258     0.150
    75.649   704.906     0.150
    75.650   704.930     0.150
    75.654   705.887     0.150
    75.682   703.699     0.150
    75.682   703.699     0.150
    75.687   703.699     0.150
    75.742   711.223     0.150
    75.916   705.996     0.150
    76.031   707.457     0.150
    76.090   703.098     0.150
    76.122   707.398     0.150
    76.456   708.367     0.150
    76.456   708.367     0.150
    76.456   708.371     0.150
    76.476   708.270     0.150
    76.753   710.148     0.150
    76.882   713.039     0.150
    76.882   711.598     0.150
    76.882   712.199     0.150
    77.022   712.371     0.150
    77.068   722.562     0.150
    77.152   712.699     0.150
    77.596   715.699     0.150
    77.597   715.879     0.150
    77.772   716.488     0.150
    77.774   720.098     0.150
    78.092   718.867     0.150
    78.119   719.367     0.150
    78.123   719.496     0.150
    78.257   718.898     0.150
    78.494   720.898     0.150
    78.921   723.699     0.150
    78.919   723.598     0.150
    79.424   725.797     0.150
    79.856   728.297     0.150
    79.975   728.398     0.150
    80.063   729.496     0.150
    80.209   730.496     0.150
    80.212   730.098     0.150
    80.391   731.996     0.150
    80.947   733.797     0.150
    81.648   737.629     0.150
    81.935   737.598     0.150
    81.955   739.609     0.150
    82.037   739.859     0.150
    82.148   740.117     0.150
    82.148   739.938     0.150
    82.269   740.227     0.150
    82.450   740.918     0.150
    82.450   741.020     0.150
    82.644   742.699     0.150
    82.685   743.199     0.150
    82.797   744.117     0.150
    82.985   744.836     0.150
    83.397   747.598     0.150
    83.508   747.129     0.150
    83.508   747.297     0.150
    83.508   746.957     0.150
    83.742   748.348     0.150
    83.999   750.598     0.150
    84.027   750.109     0.150
    84.214   752.496     0.150
    84.875   754.199     0.150
    84.910   754.828     0.150
    85.708   758.496     0.150
    85.793   759.270     0.150
    86.786   763.770     0.150
    86.811   764.629     0.150
    87.027   764.598     0.150
    87.027   764.688     0.150
    87.027   764.598     0.150
    87.372   766.566     0.150
    87.372   767.848     0.150
    87.372   767.699     0.150
    88.142   769.324     0.150
    88.142   769.547     0.150
    88.503   771.398     0.150
    89.171   774.273     0.150
    94.844   800.938     0.150
   127.753  1145.496     0.150
   127.753  1145.988     0.150
   150.673  1190.922     0.150
   151.162  1190.188     0.150
     0.630    19.641     0.150
     0.630    19.492     0.150
     0.691    21.492     0.150
     2.455    38.625     0.150
     2.455    66.875     0.150
     2.455    37.090     0.150
     2.455    67.363     0.150
     2.916    43.551     0.150
     4.824    72.363     0.150
     5.814    85.391     0.150
     9.094   129.832     0.150
     9.164   131.793     0.150
    12.903   186.480     0.150
    13.050   183.082     0.150
    13.565   187.176     0.150
    13.351   191.203     0.150
    13.695   197.902     0.150
    14.354   210.352     0.150
    15.111   220.152     0.150
    15.084   217.711     0.150
    15.330   218.652     0.150
    15.660   221.043     0.150
    15.589   222.273     0.150
    15.686   226.492     0.150
    15.865   230.023     0.150
    15.847   225.621     0.150
    16.047   228.953     0.150
    16.619   234.781     0.150
    16.757   236.250     0.150
    16.622   237.633     0.150
    16.657   235.672     0.150
    16.856   237.992     0.150
    17.232   242.891     0.150
    17.114   242.152     0.150
    17.114   241.352     0.150
    17.169   242.902     0.150
    17.452   244.242     0.150
    17.695   248.113     0.150
    18.002   251.730     0.150
    18.002   251.000     0.150
    18.002   250.793     0.150
    18.298   255.871     0.150
    18.234   256.762     0.150
    18.920   263.973     0.150
    19.503   270.602     0.150
    19.789   272.980     0.150
    19.728   273.312     0.150
    19.945   275.422     0.150
    20.034   276.070     0.150
    20.083   276.781     0.150
    20.035   276.000     0.150
    20.525   280.871     0.150
    20.441   279.910     0.150
    20.369   280.082     0.150
    20.431   280.500     0.150
    20.517   280.832     0.150
    20.629   282.570     0.150
    21.256   288.980     0.150
    21.290   290.613     0.150
    21.354   289.613     0.150
    21.287   288.633     0.150
    21.396   290.191     0.150
    21.406   290.750     0.150
    21.407   289.340     0.150
    21.354   289.293     0.150
    21.460   289.852     0.150
    21.475   291.012     0.150
    21.509   290.672     0.150
    21.540   291.332     0.150
    21.563   291.473     0.150
    21.587   291.121     0.150
    21.592   292.293     0.150
    21.673   293.613     0.150
    21.679   293.590     0.150
    21.820   295.172     0.150
    21.772   294.871     0.150
    21.892   295.480     0.150
    22.100   300.590     0.150
    22.563   302.371     0.150
    22.525   302.461     0.150
    22.490   301.973     0.150
    22.681   302.391     0.150
    23.019   307.441     0.150
    23.139   308.871     0.150
    23.178   309.680     0.150
    23.410   310.762     0.150
    23.997   317.531     0.150
    25.360   329.348     0.150
    25.905   335.703     0.150
    26.945   342.742     0.150
    31.281   381.871     0.150
    31.281   381.875     0.150
    39.246   451.027     0.150
    59.652   604.750     0.150
    69.438   669.953     0.150
    73.056   691.289     0.150
    76.692   711.582     0.150
    76.692   711.578     0.150
    78.015   721.902     0.150
    79.162   726.602     0.150
    79.162   735.402     0.150
     0.395     7.395     0.150
     0.395    12.945     0.150
     0.395     7.484     0.150
     0.395    13.055     0.150
     0.450     8.387     0.150
     0.450    14.676     0.150
     2.697    41.605     0.150
     2.697    75.574     0.150
     2.706    40.039     0.150
     2.706    70.641     0.150
     2.706    79.215     0.150
     3.618    55.156     0.150
     3.618    97.605     0.150
     3.618   111.305     0.150
     4.575    67.215     0.150
     5.592    82.207     0.150
     5.802    87.645     0.150
     5.802   150.719     0.150
     5.802   176.090     0.150
     6.862   100.844     0.150
     7.085   102.316     0.150
     7.085   185.074     0.150
     8.491   122.836     0.150
     8.503   123.344     0.150
     8.497   123.625     0.150
     9.154   133.414     0.150
     9.378   135.996     0.150
    10.150   146.234     0.150
    10.192   144.816     0.150
    10.532   152.504     0.150
    10.537   152.227     0.150
    10.563   154.305     0.150
    10.654   154.188     0.150
    11.052   160.656     0.150
    11.059   159.367     0.150
    11.059   283.266     0.150
    11.355   162.887     0.150
    11.355   288.875     0.150
    11.375   162.957     0.150
    11.772   168.484     0.150
    11.854   168.594     0.150
    11.894   168.996     0.150
    11.894   302.785     0.150
    12.018   172.816     0.150
    12.080   172.176     0.150
    12.080   306.754     0.150
    12.259   176.656     0.150
    12.296   175.504     0.150
    12.370   175.484     0.150
    12.426   176.977     0.150
    12.452   177.914     0.150
    12.428   175.426     0.150
    12.503   175.535     0.150
    12.503   308.734     0.150
    12.539   178.367     0.150
    12.539   317.395     0.150
    12.592   179.688     0.150
    12.592   319.117     0.150
    12.623   181.367     0.150
    12.623   318.938     0.150
    12.648   181.414     0.150
    12.706   180.734     0.150
    12.729   181.754     0.150
    12.810   182.445     0.150
    12.958   184.566     0.150
    13.152   187.777     0.150
    13.331   191.234     0.150
    13.331   191.527     0.150
    13.553   188.996     0.150
    13.553   334.312     0.150
    13.553   419.762     0.150
    13.553   190.297     0.150
    13.667   194.504     0.150
    13.772   196.773     0.150
    13.749   194.957     0.150
    13.749   347.047     0.150
    13.827   195.734     0.150
    13.827   200.301     0.150
    13.920   197.477     0.150
    14.093   201.465     0.150
    14.093   198.672     0.150
    14.093   444.812     0.150
    14.093   199.336     0.150
    14.177   201.305     0.150
    14.177   357.566     0.150
    14.198   201.746     0.150
    14.249   202.137     0.150
    14.518   205.805     0.150
    14.838   210.156     0.150
    15.043   214.367     0.150
    15.122   216.094     0.150
    15.129   215.734     0.150
    15.186   216.035     0.150
    15.196   214.270     0.150
    15.351   217.047     0.150
    15.391   218.594     0.150
    15.560   218.340     0.150
    15.560   385.941     0.150
    15.560   219.324     0.150
    15.870   228.797     0.150
    15.961   229.816     0.150
    16.275   229.957     0.150
    16.283   229.824     0.150
    16.374   233.695     0.150
    16.779   237.266     0.150
    16.795   236.895     0.150
    16.897   239.355     0.150
    16.963   237.234     0.150
    16.900   240.207     0.150
    16.940   241.855     0.150
    16.985   238.785     0.150
    16.985   240.762     0.150
    16.982   240.906     0.150
    17.035   241.395     0.150
    17.148   241.855     0.150
    17.173   243.906     0.150
    17.395   246.824     0.150
    17.395   242.242     0.150
    17.451   246.855     0.150
    17.840   249.836     0.150
    17.840   251.078     0.150
    18.030   250.445     0.150
    17.991   253.195     0.150
    18.279   256.074     0.150
    18.279   256.355     0.150
    18.279   253.215     0.150
    18.279   256.254     0.150
    18.361   254.234     0.150
    18.503   259.754     0.150
    19.207   263.465     0.150
    19.227   267.844     0.150
    19.491   269.660     0.150
    19.780   272.656     0.150
    19.780   272.816     0.150
    19.785   273.375     0.150
    20.014   274.344     0.150
    20.060   274.754     0.150
    20.060   276.281     0.150
    20.232   276.656     0.150
    20.228   276.762     0.150
    20.321   276.766     0.150
    20.368   278.605     0.150
    20.492   276.676     0.150
    20.618   280.105     0.150
    20.618   279.781     0.150
    20.711   281.984     0.150
    20.711   282.258     0.150
    20.728   282.266     0.150
    20.806   285.688     0.150
    20.804   282.836     0.150
    21.089   285.004     0.150
    21.225   287.344     0.150
    21.229   287.637     0.150
    21.254   288.016     0.150
    21.411   288.164     0.150
    21.411   288.012     0.150
    21.538   292.176     0.150
    21.540   290.316     0.150
    21.575   291.246     0.150
    21.608   291.340     0.150
    21.641   291.438     0.150
    21.681   292.574     0.150
    21.691   293.156     0.150
    21.760   291.844     0.150
    21.794   294.344     0.150
    21.795   291.176     0.150
    21.825   290.855     0.150
    22.105   295.945     0.150
    22.173   296.117     0.150
    22.170   297.262     0.150
    22.345   298.484     0.150
    22.724   299.891     0.150
    22.724   301.938     0.150
    22.812   304.574     0.150
    22.812   303.703     0.150
    23.302   308.910     0.150
    23.489   309.523     0.150
    24.007   316.965     0.150
    24.284   319.297     0.150
    25.271   326.496     0.150
    25.645   329.086     0.150
    25.645   332.215     0.150
    25.737   333.387     0.150
    26.008   335.066     0.150
    26.281   336.094     0.150
    26.281   335.250     0.150
    26.978   342.336     0.150
    28.192   352.957     0.150
    29.890   368.227     0.150
    29.890   367.617     0.150
    31.567   382.066     0.150
    31.567   383.195     0.150
    31.567   382.062     0.150
    32.159   388.816     0.150
    32.159   387.414     0.150
    32.159   452.914     0.150
    32.159   560.516     0.150
    34.579   407.324     0.150
    35.998   421.344     0.150
    37.240   431.145     0.150
    37.317   433.797     0.150
    37.564   434.016     0.150
    38.018   437.266     0.150
    38.018   437.836     0.150
    38.091   438.336     0.150
    38.109   438.207     0.150
    38.384   440.195     0.150
    38.562   442.344     0.150
    38.961   444.566     0.150
    38.961   446.316     0.150
    40.081   456.516     0.150
    40.544   459.145     0.150
    40.546   459.148     0.150
    41.016   461.961     0.150
    41.016   464.316     0.150
    43.564   483.023     0.150
    43.564   483.414     0.150
    44.196   488.914     0.150
    48.588   523.617     0.150
    48.588   520.215     0.150
    51.945   549.016     0.150
    54.703   567.840     0.150
    55.967   580.414     0.150
    56.905   584.125     0.150
    56.905   584.121     0.150
    57.225   584.215     0.150
    59.367   602.129     0.150
    62.714   625.305     0.150
    62.853   625.316     0.150
    62.853   625.344     0.150
    62.853   625.340     0.150
    65.743   644.016     0.150
    65.892   643.816     0.150
    68.878   665.895     0.150
    68.878   667.516     0.150
    69.185   665.484     0.150
    69.189   665.707     0.150
    69.189   665.492     0.150
    70.752   675.316     0.150
    70.752   830.516     0.150
    70.752  1230.117     0.150
    70.752  1499.316     0.150
    71.593   681.816     0.150
    72.438   686.414     0.150
    72.810   687.316     0.150
    72.868   688.336     0.150
    73.493   692.016     0.150
    73.554   693.016     0.150
    73.576   691.617     0.150
    73.635   693.516     0.150
    73.832   694.316     0.150
    73.920   695.016     0.150
    73.931   695.016     0.150
    74.110   696.617     0.150
    74.418   698.016     0.150
    74.714   699.492     0.150
    74.722   699.547     0.150
    74.919   701.316     0.150
    75.102   703.816     0.150
    75.484   705.152     0.150
    75.619   703.816     0.150
    75.626   705.695     0.150
    75.707   703.480     0.150
    75.707   704.516     0.150
    75.707   704.527     0.150
    75.950   706.016     0.150
    75.984   707.816     0.150
    76.067   707.957     0.150
    76.156   707.414     0.150
    76.437   708.266     0.150
    76.437   708.367     0.150
    76.437   708.367     0.150
    76.437   708.266     0.150
    76.457   708.367     0.150
    76.500   708.844     0.150
    76.631   710.156     0.150
    76.915   713.117     0.150
    77.059   712.430     0.150
    77.142   712.914     0.150
    77.648   715.391     0.150
    77.749   720.016     0.150
    77.772   715.996     0.150
    78.525   720.715     0.150
    78.877   724.016     0.150
    78.877   732.516     0.150
    78.949   723.617     0.150
    79.457   725.516     0.150
    79.457   725.617     0.150
    80.242   730.316     0.150
    82.134   740.254     0.150
    82.440   741.086     0.150
    82.440   740.984     0.150
    82.672   743.414     0.150
    83.523   747.824     0.150
    83.523   747.215     0.150
    83.757   748.516     0.150
    84.013   750.715     0.150
    84.561   753.457     0.150
    84.860   754.316     0.150
    87.051   764.836     0.150
    87.051   764.832     0.150
    88.199   769.539     0.150
    88.199   769.375     0.150
    89.171   774.770     0.150
   150.729  1191.242     0.150
   151.189  1189.785     0.150
     0.595    10.379     0.150
     0.595    18.301     0.150
     0.595    10.160     0.150
     0.595    18.180     0.150
     0.632    11.309     0.150
     0.632    20.070     0.150
     2.844    44.789     0.150
     2.896    43.379     0.150
     2.896    75.406     0.150
     2.896    43.000     0.150
     3.798   101.730     0.150
     4.666    67.102     0.150
     5.724    83.719     0.150
     6.019    89.379     0.150
     6.019   186.180     0.150
     6.019    90.301     0.150
     6.070    90.711     0.150
     6.985   103.469     0.150
     7.151   104.570     0.150
     7.150   106.641     0.150
     7.778   115.371     0.150
     7.890   116.680     0.150
     8.545   123.992     0.150
     8.606   125.531     0.150
     8.542   130.031     0.150
     8.842   133.199     0.150
     9.230   134.180     0.150
     9.480   138.301     0.150
     9.579   140.559     0.150
    10.158   147.152     0.150
    10.206   150.102     0.150
    10.552   153.789     0.150
    10.489   155.906     0.150
    10.656   151.039     0.150
    10.898   155.406     0.150
    10.932   161.297     0.150
    11.065   159.492     0.150
    11.059   159.602     0.150
    11.298   163.871     0.150
    11.221   164.676     0.150
    11.241   164.457     0.150
    11.373   162.789     0.150
    11.372   165.570     0.150
    11.674   170.281     0.150
    11.812   170.672     0.150
    11.682   170.840     0.150
    11.964   171.859     0.150
    11.848   174.199     0.150
    12.093   171.379     0.150
    12.129   177.215     0.150
    12.178   177.660     0.150
    12.341   176.910     0.150
    12.321   174.512     0.150
    12.373   174.039     0.150
    12.431   177.121     0.150
    12.517   180.141     0.150
    12.522   180.191     0.150
    12.462   181.988     0.150
    12.588   180.000     0.150
    12.624   180.609     0.150
    12.776   183.121     0.150
    12.635   180.852     0.150
    12.789   184.391     0.150
    12.730   184.910     0.150
    12.911   183.141     0.150
    12.990   185.242     0.150
    12.867   187.559     0.150
    13.136   190.879     0.150
    13.116   191.207     0.150
    13.145   191.293     0.150
    13.318   193.102     0.150
    13.288   192.039     0.150
    13.823   191.449     0.150
    13.823   431.879     0.150
    13.823   193.121     0.150
    13.538   196.070     0.150
    13.860   194.551     0.150
    13.656   197.402     0.150
    13.881   200.832     0.150
    13.881   198.332     0.150
    13.952   200.512     0.150
    13.955   200.980     0.150
    13.890   202.129     0.150
    13.946   202.410     0.150
    14.152   202.172     0.150
    14.152   200.250     0.150
    14.152   202.582     0.150
    14.197   202.250     0.150
    14.245   202.820     0.150
    14.300   206.039     0.150
    14.224   205.477     0.150
    14.431   205.789     0.150
    14.489   210.262     0.150
    14.491   211.344     0.150
    14.519   213.289     0.150
    14.457   209.039     0.150
    14.657   212.301     0.150
    14.863   210.941     0.150
    14.999   212.602     0.150
    15.085   214.059     0.150
    15.274   217.879     0.150
    15.228   221.699     0.150
    15.264   218.211     0.150
    15.388   218.680     0.150
    15.388   217.891     0.150
    15.220   217.051     0.150
    15.430   221.020     0.150
    15.364   222.332     0.150
    15.504   221.000     0.150
    15.726   219.480     0.150
    15.882   227.332     0.150
    16.065   232.359     0.150
    16.065   522.391     0.150
    15.946   227.531     0.150
    16.247   232.152     0.150
    16.131   231.629     0.150
    16.152   232.570     0.150
    16.422   232.352     0.150
    16.428   232.602     0.150
    16.329   233.711     0.150
    16.540   236.422     0.150
    16.559   237.590     0.150
    16.760   237.789     0.150
    16.814   238.301     0.150
    16.814   238.898     0.150
    16.929   238.750     0.150
    16.915   238.359     0.150
    16.935   238.520     0.150
    16.999   239.672     0.150
    16.901   242.621     0.150
    17.029   241.879     0.150
    16.960   241.109     0.150
    16.967   241.590     0.150
    17.118   244.469     0.150
    17.145   241.980     0.150
    17.145   243.035     0.150
    17.166   244.559     0.150
    17.149   244.172     0.150
    17.283   245.590     0.150
    17.294   245.352     0.150
    17.304   245.332     0.150
    17.337   244.910     0.150
    17.408   243.387     0.150
    17.465   246.152     0.150
    17.557   246.629     0.150
    17.826   251.129     0.150
    17.924   250.332     0.150
    17.845   252.680     0.150
    17.801   250.121     0.150
    17.847   252.660     0.150
    18.135   252.730     0.150
    18.135   254.215     0.150
    18.098   253.480     0.150
    18.182   254.422     0.150
    18.412   256.742     0.150
    18.412   258.246     0.150
    18.412   256.652     0.150
    18.412   255.160     0.150
    18.412   257.691     0.150
    18.575   258.742     0.150
    18.481   256.609     0.150
    18.481   258.891     0.150
    18.528   259.652     0.150
    18.472   259.742     0.150
    18.624   259.809     0.150
    18.624   260.480     0.150
    19.035   266.461     0.150
    19.018   265.547     0.150
    19.095   269.309     0.150
    19.215   272.109     0.150
    19.265   266.699     0.150
    19.227   267.816     0.150
    19.514   270.211     0.150
    19.514   270.480     0.150
    19.556   270.660     0.150
    19.677   272.047     0.150
    19.638   270.551     0.150
    19.771   273.141     0.150
    19.771   274.277     0.150
    19.789   273.445     0.150
    19.880   274.699     0.150
    19.970   275.281     0.150
    20.078   275.742     0.150
    20.088   276.559     0.150
    20.008   277.152     0.150
    20.211   275.211     0.150
    20.211   275.914     0.150
    20.220   278.859     0.150
    20.112   276.480     0.150
    20.226   278.262     0.150
    20.286   278.430     0.150
    20.350   278.609     0.150
    20.379   279.469     0.150
    20.472   285.402     0.150
    20.460   280.102     0.150
    20.405   279.645     0.150
    20.453   280.742     0.150
    20.625   284.871     0.150
    20.794   283.910     0.150
    20.794   285.574     0.150
    20.717   282.582     0.150
    20.717   283.121     0.150
    20.780   283.441     0.150
    20.867   285.840     0.150
    20.923   284.270     0.150
    20.923   284.418     0.150
    20.971   285.840     0.150
    20.949   285.934     0.150
    21.118   286.730     0.150
    21.214   288.090     0.150
    21.239   288.582     0.150
    21.315   289.500     0.150
    21.341   289.594     0.150
    21.632   291.109     0.150
    21.632   291.328     0.150
    21.637   293.809     0.150
    21.676   291.879     0.150
    21.676   292.230     0.150
    21.684   292.191     0.150
    21.591   291.781     0.150
    21.673   293.152     0.150
    21.592   292.402     0.150
    21.621   292.875     0.150
    21.697   293.641     0.150
    21.736   293.922     0.150
    21.778   295.660     0.150
    21.791   294.242     0.150
    21.789   293.391     0.150
    21.841   294.352     0.150
    21.857   294.859     0.150
    21.891   294.480     0.150
    21.891   294.242     0.150
    21.922   295.961     0.150
    21.943   296.031     0.150
    21.945   296.152     0.150
    21.969   295.891     0.150
    21.971   297.211     0.150
    22.055   297.449     0.150
    22.062   296.492     0.150
    22.089   296.891     0.150
    22.082   297.664     0.150
    22.203   298.840     0.150
    22.175   298.270     0.150
    22.173   297.484     0.150
    22.291   298.441     0.150
    22.344   300.980     0.150
    22.344   300.375     0.150
    22.351   300.598     0.150
    22.375   300.484     0.150
    22.395   300.883     0.150
    22.660   303.758     0.150
    22.692   304.004     0.150
    22.968   305.031     0.150
    22.968   305.711     0.150
    22.868   306.129     0.150
    22.868   305.969     0.150
    22.939   306.191     0.150
    22.939   306.293     0.150
    22.981   307.559     0.150
    22.981   307.738     0.150
    23.001   308.199     0.150
    23.099   308.199     0.150
    23.187   309.387     0.150
    23.409   310.770     0.150
    23.409   311.684     0.150
    23.333   311.082     0.150
    23.456   311.699     0.150
    23.470   311.602     0.150
    23.670   312.578     0.150
    23.721   313.160     0.150
    23.721   312.953     0.150
    23.745   315.281     0.150
    23.890   316.422     0.150
    24.123   318.930     0.150
    24.123   317.996     0.150
    24.145   317.641     0.150
    24.345   319.352     0.150
    24.826   325.359     0.150
    24.826   324.652     0.150
    25.158   326.941     0.150
    25.246   328.246     0.150
    25.472   330.102     0.150
    25.472   329.773     0.150
    25.735   329.824     0.150
    25.735   333.480     0.150
    25.893   333.980     0.150
    25.819   334.211     0.150
    25.813   334.000     0.150
    26.089   336.922     0.150
    26.275   336.750     0.150
    26.519   338.102     0.150
    26.519   338.508     0.150
    26.619   339.699     0.150
    26.854   341.332     0.150
    26.854   341.480     0.150
    26.576   340.160     0.150
    27.205   344.910     0.150
    27.279   346.461     0.150
    28.254   355.742     0.150
    28.803   359.121     0.150
    28.864   361.582     0.150
    28.864   361.422     0.150
    30.025   370.652     0.150
    31.053   378.820     0.150
    31.567   383.602     0.150
    31.643   385.809     0.150
    31.644   382.391     0.150
    31.644   382.395     0.150
    31.898   385.957     0.150
    32.195   389.008     0.150
    32.158   387.980     0.150
    32.158   459.180     0.150
    32.307   389.562     0.150
    32.592   391.434     0.150
    32.702   394.199     0.150
    32.703   394.531     0.150
    32.703   395.031     0.150
    33.109   395.801     0.150
    33.317   398.461     0.150
    33.817   405.750     0.150
    35.455   417.840     0.150
    35.455   418.820     0.150
    35.522   417.582     0.150
    37.171   430.410     0.150
    37.496   434.672     0.150
    37.399   434.762     0.150
    37.595   435.680     0.150
    37.904   437.250     0.150
    38.079   438.891     0.150
    38.203   440.191     0.150
    38.203   440.047     0.150
    38.217   439.656     0.150
    38.217   439.902     0.150
    38.341   440.852     0.150
    38.300   440.699     0.150
    38.300   440.473     0.150
    38.453   441.109     0.150
    38.503   442.969     0.150
    38.503   442.199     0.150
    38.566   442.902     0.150
    38.815   445.422     0.150
    38.792   445.969     0.150
    38.917   445.941     0.150
    38.927   445.957     0.150
    38.927   449.082     0.150
    39.344   450.910     0.150
    39.581   451.289     0.150
    39.598   452.602     0.150
    39.696   452.820     0.150
    39.759   452.172     0.150
    39.931   454.602     0.150
    39.970   457.781     0.150
    40.436   457.789     0.150
    40.962   462.223     0.150
    44.426   492.281     0.150
    48.585   523.254     0.150
    48.585   523.082     0.150
    52.620   555.582     0.150
    53.762   563.121     0.150
    54.806   568.707     0.150
    55.899   580.980     0.150
    57.088   589.281     0.150
    57.235   584.082     0.150
    61.413   615.191     0.150
    61.413   618.480     0.150
    61.413   615.195     0.150
    62.947   626.492     0.150
    63.087   628.879     0.150
    63.087   627.531     0.150
    63.087   627.527     0.150
    64.033   634.281     0.150
    65.759   647.879     0.150
    66.067   645.582     0.150
    66.310   650.629     0.150
    66.341   647.840     0.150
    66.341   647.840     0.150
    66.969   655.281     0.150
    67.933   660.270     0.150
    67.946   659.680     0.150
    67.946   659.676     0.150
    68.718   665.879     0.150
    68.985   667.660     0.150
    68.985   670.781     0.150
    69.259   665.922     0.150
    69.263   666.902     0.150
    69.263   667.602     0.150
    70.897   679.379     0.150
    70.897   835.980     0.150
    70.897  1500.281     0.150
    71.021   681.082     0.150
    71.381   683.090     0.150
    71.401   683.180     0.150
    71.401   682.859     0.150
    71.535   683.879     0.150
    71.553   682.980     0.150
    72.254   686.781     0.150
    72.492   688.480     0.150
    72.495   688.582     0.150
    72.789   692.680     0.150
    72.922   689.941     0.150
    73.165   693.379     0.150
    73.745   696.379     0.150
    73.661   692.980     0.150
    73.812   697.379     0.150
    73.893   697.879     0.150
    73.892   696.832     0.150
    74.090   698.781     0.150
    74.103   698.359     0.150
    74.113   697.980     0.150
    74.113     4.398     0.150
    74.173   699.379     0.150
    74.191   699.480     0.150
    74.469   698.480     0.150
    74.469     6.500     0.150
    74.660   701.891     0.150
    74.660   701.582     0.150
    74.660     4.797     0.150
    74.851   703.082     0.150
    74.908   702.379     0.150
    74.924   702.422     0.150
    74.957   702.652     0.150
    74.957   700.648     0.150
    74.965   702.629     0.150
    75.157   703.582     0.150
    75.157   703.082     0.150
    75.348   704.180     0.150
    75.187   705.480     0.150
    75.472   707.715     0.150
    75.513   709.293     0.150
    75.625   707.492     0.150
    75.731   710.840     0.150
    75.811   707.559     0.150
    75.858   708.977     0.150
    75.937   709.543     0.150
    75.920   706.242     0.150
    75.940   705.465     0.150
    75.925   708.980     0.150
    76.022   710.547     0.150
    76.304   710.680     0.150
    76.306   711.074     0.150
    76.505   710.570     0.150
    76.505   709.680     0.150
    76.505   709.684     0.150
    76.524   710.582     0.150
    76.568   711.051     0.150
    76.872   714.492     0.150
    76.903   714.180     0.150
    76.903   724.980     0.150
    77.148   714.379     0.150
    77.349   717.145     0.150
    77.919   717.621     0.150
    77.920   719.641     0.150
    77.794   720.980     0.150
    78.375   723.480     0.150
    78.850   725.980     0.150
    79.171   727.980     0.150
    79.688   731.879     0.150
    80.117   731.582     0.150
    80.313   729.879     0.150
    80.213   732.070     0.150
    80.511   732.781     0.150
    83.707   750.379     0.150
    83.941   750.730     0.150
    84.884   756.480     0.150
    84.884   954.480     0.150
    84.884  1381.781     0.150
    84.884  1716.980     0.150
    84.947   759.082     0.150
    87.260   766.969     0.150
    87.260   766.973     0.150
    88.305   771.957     0.150
    96.248   809.012     0.150
    96.248   809.008     0.150
   115.342  1121.730     0.150
   151.005  1192.906     0.150
     0.597    10.691     0.150
     0.597    19.465     0.150
     0.644    11.195     0.150
     0.644    19.973     0.150
     2.764    48.449     0.150
     2.764    47.887     0.150
     2.884    45.598     0.150
     3.821    57.785     0.150
     4.733    71.324     0.150
     5.773    86.137     0.150
     6.018    88.250     0.150
     6.018    88.977     0.150
     7.660   114.895     0.150
     8.669   126.207     0.150
     8.628   124.926     0.150
    10.099   148.246     0.150
    11.162   165.004     0.150
    11.469   164.395     0.150
    11.584   169.180     0.150
    11.735   171.188     0.150
    11.914   173.137     0.150
    12.018   175.035     0.150
    12.190   174.547     0.150
    12.082   177.500     0.150
    12.428   178.625     0.150
    12.596   181.207     0.150
    12.531   179.816     0.150
    12.682   180.766     0.150
    12.629   184.855     0.150
    12.552   181.957     0.150
    12.620   183.387     0.150
    12.725   186.855     0.150
    12.976   186.406     0.150
    12.768   185.223     0.150
    12.768   186.207     0.150
    13.081   189.926     0.150
    13.242   193.645     0.150
    13.768   194.520     0.150
    13.547   195.176     0.150
    14.234   205.137     0.150
    14.292   203.496     0.150
    14.331   204.848     0.150
    14.131   205.531     0.150
    14.385   206.207     0.150
    14.651   211.695     0.150
    14.620   212.848     0.150
    14.896   216.336     0.150
    15.134   217.766     0.150
    15.101   216.785     0.150
    15.101   220.602     0.150
    15.113   220.207     0.150
    15.344   222.824     0.150
    15.519   224.047     0.150
    15.934   225.246     0.150
    16.291   230.047     0.150
    16.785   238.016     0.150
    16.900   238.746     0.150
    16.798   239.387     0.150
    17.013   239.316     0.150
    16.852   239.035     0.150
    16.988   239.875     0.150
    17.037   240.254     0.150
    17.089   241.598     0.150
    17.174   241.926     0.150
    17.212   243.367     0.150
    18.003   251.176     0.150
    18.282   256.277     0.150
    18.282   255.887     0.150
    18.446   256.926     0.150
    18.446   257.887     0.150
    18.511   257.395     0.150
    18.753   259.176     0.150
    19.091   262.074     0.150
    19.405   268.504     0.150
    19.671   271.676     0.150
    19.954   273.547     0.150
    20.079   275.164     0.150
    20.094   275.785     0.150
    20.662   283.047     0.150
    20.662   283.895     0.150
    20.613   282.844     0.150
    20.795   282.426     0.150
    20.795   282.637     0.150
    21.210   288.223     0.150
    21.504   289.637     0.150
    21.504   289.949     0.150
    21.241   288.609     0.150
    21.546   290.438     0.150
    21.546   291.113     0.150
    22.163   297.555     0.150
    22.268   299.703     0.150
    22.845   305.176     0.150
    23.283   309.496     0.150
    23.283   309.980     0.150
    23.232   310.180     0.150
    23.594   311.215     0.150
    23.758   314.016     0.150
    23.995   315.406     0.150
    23.995   316.074     0.150
    25.030   327.320     0.150
    25.341   328.297     0.150
    25.341   327.707     0.150
    25.612   331.297     0.150
    27.077   346.723     0.150
    31.435   382.129     0.150
    31.522   382.977     0.150
    31.523   383.551     0.150
    31.766   384.055     0.150
    31.838   385.320     0.150
    32.003   386.863     0.150
    32.063   387.605     0.150
    32.129   387.820     0.150
    32.175   388.207     0.150
    32.977   394.973     0.150
    33.021   395.117     0.150
    33.008   396.621     0.150
    48.688   522.621     0.150
    48.688   524.527     0.150
    54.870   568.676     0.150
    63.073   627.375     0.150
    73.089   691.215     0.150
    74.096   697.574     0.150
    74.452   705.375     0.150
    74.639   699.875     0.150
    74.935   702.051     0.150
    76.375   710.074     0.150
    76.583   710.027     0.150
    77.863   718.426     0.150
    77.882   722.477     0.150
    78.960   726.477     0.150
    78.960   733.977     0.150
    78.960   906.676     0.150
     0.619    10.469     0.150
     0.619    19.719     0.150
     0.661    11.488     0.150
     0.661    21.289     0.150
     2.886    45.750     0.150
     6.045   188.500     0.150
    11.125   157.121     0.150
    11.433   164.641     0.150
    11.159   162.520     0.150
    11.621   169.480     0.150
    12.153   174.039     0.150
    12.066   175.980     0.150
    12.399   176.090     0.150
    12.391   177.871     0.150
    12.831   182.559     0.150
    12.756   182.938     0.150
    12.667   183.789     0.150
    13.049   183.688     0.150
    12.806   183.945     0.150
    13.055   189.820     0.150
    13.426   191.938     0.150
    13.478   195.352     0.150
    13.594   194.320     0.150
    14.011   197.391     0.150
    14.209   199.059     0.150
    14.209   200.543     0.150
    14.257   199.820     0.150
    14.165   205.582     0.150
    14.548   207.246     0.150
    14.626   207.973     0.150
    14.580   206.820     0.150
    14.857   208.340     0.150
    15.165   221.309     0.150
    15.165   220.887     0.150
    15.333   221.934     0.150
    15.766   219.125     0.150
    15.819   223.160     0.150
    16.005   227.750     0.150
    15.885   225.078     0.150
    16.186   228.719     0.150
    16.069   226.809     0.150
    16.362   230.250     0.150
    16.367   230.969     0.150
    16.482   235.590     0.150
    16.699   235.098     0.150
    16.854   237.910     0.150
    16.968   240.680     0.150
    16.839   240.059     0.150
    17.057   243.258     0.150
    17.105   244.270     0.150
    17.087   241.500     0.150
    17.274   244.277     0.150
    17.345   244.641     0.150
    17.345   242.023     0.150
    17.495   246.051     0.150
    17.403   245.598     0.150
    17.763   250.020     0.150
    18.079   252.312     0.150
    18.036   253.121     0.150
    18.351   256.738     0.150
    18.524   257.254     0.150
    18.418   257.266     0.150
    18.465   257.980     0.150
    18.561   258.660     0.150
    18.561   259.055     0.150
    18.815   261.160     0.150
    18.971   262.898     0.150
    19.202   265.277     0.150
    19.165   266.879     0.150
    19.451   268.820     0.150
    19.710   272.070     0.150
    19.710   272.641     0.150
    19.727   273.168     0.150
    19.816   272.719     0.150
    19.907   273.180     0.150
    20.015   274.438     0.150
    20.024   275.027     0.150
    20.150   274.801     0.150
    20.150   275.270     0.150
    20.157   276.059     0.150
    20.064   276.152     0.150
    20.223   277.027     0.150
    20.164   277.488     0.150
    20.315   278.008     0.150
    20.287   277.500     0.150
    20.397   279.188     0.150
    20.390   279.449     0.150
    20.343   278.926     0.150
    20.737   283.488     0.150
    20.737   283.922     0.150
    20.583   282.340     0.150
    20.655   282.141     0.150
    20.655   282.750     0.150
    20.716   282.398     0.150
    20.861   283.660     0.150
    20.861   283.980     0.150
    20.804   283.859     0.150
    20.887   284.914     0.150
    21.253   288.633     0.150
    21.583   290.621     0.150
    21.583   290.453     0.150
    21.615   290.250     0.150
    21.615   291.250     0.150
    21.623   290.891     0.150
    21.574   291.219     0.150
    21.610   291.230     0.150
    21.528   290.770     0.150
    21.559   291.555     0.150
    21.673   292.188     0.150
    21.633   292.160     0.150
    21.715   292.820     0.150
    21.728   292.660     0.150
    21.726   292.711     0.150
    21.778   293.379     0.150
    21.794   293.141     0.150
    21.828   293.621     0.150
    21.828   293.461     0.150
    21.859   293.840     0.150
    21.882   294.270     0.150
    21.880   293.828     0.150
    21.906   293.930     0.150
    21.908   294.020     0.150
    21.991   295.379     0.150
    21.999   295.398     0.150
    22.026   296.379     0.150
    22.140   297.020     0.150
    22.114   297.512     0.150
    22.312   299.547     0.150
    22.334   298.938     0.150
    22.924   302.824     0.150
    22.924   303.348     0.150
    22.630   303.301     0.150
    22.805   304.121     0.150
    22.876   304.539     0.150
    22.876   304.969     0.150
    22.918   305.289     0.150
    22.918   305.598     0.150
    22.939   306.766     0.150
    23.038   305.078     0.150
    23.347   309.488     0.150
    23.347   310.000     0.150
    23.272   309.570     0.150
    23.615   312.152     0.150
    23.674   311.820     0.150
    23.674   310.801     0.150
    23.408   310.480     0.150
    23.408   311.496     0.150
    23.681   313.188     0.150
    23.831   314.020     0.150
    23.831   314.383     0.150
    24.061   317.027     0.150
    24.282   319.160     0.150
    25.096   326.480     0.150
    25.096   326.082     0.150
    25.184   327.363     0.150
    25.418   329.027     0.150
    25.672   329.543     0.150
    25.750   332.461     0.150
    25.750   332.270     0.150
    26.474   337.711     0.150
    26.559   339.383     0.150
    27.044   343.250     0.150
    27.044   344.555     0.150
    27.156   345.625     0.150
    27.759   352.090     0.150
    28.162   353.371     0.150
    28.801   359.250     0.150
    29.963   369.273     0.150
    30.998   377.730     0.150
    31.080   378.305     0.150
    31.511   382.152     0.150
    31.488   382.039     0.150
    31.651   383.250     0.150
    31.651   383.137     0.150
    31.659   383.609     0.150
    31.581   383.230     0.150
    31.581   554.699     0.150
    31.581   383.223     0.150
    31.581   554.699     0.150
    31.842   384.797     0.150
    31.861   384.703     0.150
    31.913   385.301     0.150
    32.079   386.762     0.150
    32.084   387.242     0.150
    32.115   387.828     0.150
    32.137   387.855     0.150
    32.205   388.641     0.150
    32.249   388.758     0.150
    32.445   390.703     0.150
    32.434   389.492     0.150
    32.536   390.316     0.150
    32.502   391.230     0.150
    32.644   391.898     0.150
    32.728   392.098     0.150
    32.793   393.777     0.150
    32.843   393.250     0.150
    33.051   395.148     0.150
    33.097   395.633     0.150
    33.080   396.641     0.150
    33.080   396.883     0.150
    33.210   396.387     0.150
    33.264   397.359     0.150
    33.264   397.227     0.150
    33.290   397.230     0.150
    33.408   398.301     0.150
    33.407   397.461     0.150
    33.714   401.324     0.150
    34.114   406.043     0.150
    34.433   407.469     0.150
    34.446   407.605     0.150
    34.570   410.539     0.150
    34.775   410.473     0.150
    34.959   411.910     0.150
    34.959   412.301     0.150
    35.156   414.219     0.150
    35.268   414.957     0.150
    35.531   417.078     0.150
    35.469   416.836     0.150
    35.447   416.617     0.150
    35.556   416.859     0.150
    35.556   417.086     0.150
    35.619   417.805     0.150
    35.746   416.742     0.150
    35.787   419.012     0.150
    36.027   420.641     0.150
    36.121   421.570     0.150
    36.558   427.156     0.150
    36.998   427.875     0.150
    37.013   429.562     0.150
    37.008   428.957     0.150
    37.297   432.449     0.150
    37.457   433.680     0.150
    37.576   434.145     0.150
    37.839   436.469     0.150
    37.900   437.027     0.150
    38.149   439.402     0.150
    38.163   438.000     0.150
    38.163   438.371     0.150
    38.179   439.883     0.150
    38.301   439.711     0.150
    38.244   440.223     0.150
    38.448   441.730     0.150
    38.448   441.984     0.150
    38.452   442.188     0.150
    38.775   444.590     0.150
    38.739   444.590     0.150
    38.800   444.176     0.150
    38.860   445.645     0.150
    38.905   446.160     0.150
    39.185   448.039     0.150
    39.227   448.285     0.150
    39.903   454.094     0.150
    40.035   455.020     0.150
    43.674   484.910     0.150
    44.448   491.148     0.150
    48.647   524.707     0.150
    54.857   570.375     0.150
    57.833   591.949     0.150
    59.341   602.723     0.150
    61.474   618.574     0.150
    61.474   618.578     0.150
    63.108   627.148     0.150
    63.108   627.148     0.150
    66.175   646.770     0.150
    68.922   666.020     0.150
    71.393   680.961     0.150
    71.414   681.391     0.150
    71.874   682.711     0.150
    72.509   687.551     0.150
    72.972   689.238     0.150
    73.127   691.109     0.150
    73.589   694.449     0.150
    74.132   697.848     0.150
    74.215   697.848     0.150
    74.488   699.648     0.150
    74.678   700.598     0.150
    74.678   701.051     0.150
    74.928   701.648     0.150
    74.928   701.750     0.150
    74.946   701.551     0.150
    74.952   702.250     0.150
    74.974   700.723     0.150
    74.992   702.348     0.150
    75.176   703.648     0.150
    75.367   704.348     0.150
    75.486   705.953     0.150
    75.827   708.148     0.150
    75.873   708.219     0.150
    75.888   708.016     0.150
    75.951   708.562     0.150
    75.948   705.500     0.150
    75.948   706.410     0.150
    75.953   706.238     0.150
    76.039   714.695     0.150
    76.207   708.949     0.150
    76.325   709.020     0.150
    76.410   710.348     0.150
    76.654   715.852     0.150
    76.560   709.598     0.150
    76.560   709.598     0.150
    76.890   713.367     0.150
    77.169   715.148     0.150
    77.319   714.812     0.150
    77.673   716.250     0.150
    77.919   717.824     0.150
    77.920   718.211     0.150
    78.369   721.098     0.150
    78.396   721.250     0.150
    78.400   722.551     0.150
    78.777   723.348     0.150
    79.196   726.250     0.150
    79.710   728.648     0.150
    80.140   730.648     0.150
    80.338   732.750     0.150
    80.341   732.148     0.150
    80.491   732.750     0.150
    80.533   732.848     0.150
    80.569   733.051     0.150
    81.219   737.148     0.150
    82.928   745.250     0.150
    83.977   750.449     0.150
    84.939   755.949     0.150
    84.939   953.949     0.150
    84.939  1381.949     0.150
    84.939  1716.949     0.150
    87.289   767.148     0.150
    87.289   767.148     0.150
    88.242   771.074     0.150
    88.242   770.719     0.150
     2.873    42.406     0.150
     3.827    57.469     0.150
     4.694    67.414     0.150
     5.753    83.969     0.150
     8.571   123.164     0.150
     9.465   137.227     0.150
    11.398   163.648     0.150
    11.991   173.328     0.150
    12.806   181.422     0.150
    12.842   187.312     0.150
    13.016   184.734     0.150
    13.299   190.562     0.150
    13.846   190.938     0.150
    14.179   199.078     0.150
    17.385   244.578     0.150
    18.400   255.305     0.150
    21.762   291.953     0.150
    31.626   381.773     0.150
    31.626   381.773     0.150
    38.213   438.773     0.150
    38.213   438.047     0.150
    38.821   443.703     0.150
    38.949   446.648     0.150
    43.643   483.938     0.150
    57.138   584.523     0.150
    57.138   584.523     0.150
    59.295   602.625     0.150
    61.425   618.734     0.150
    61.425   618.734     0.150
    62.974   624.047     0.150
    63.115   627.305     0.150
    63.115   627.297     0.150
    64.427   635.500     0.150
    64.648   635.703     0.150
    66.356   651.773     0.150
    66.356   651.773     0.150
    66.356   651.773     0.150
    67.969   661.055     0.150
    69.286   668.227     0.150
    72.519   686.477     0.150
    73.136   689.922     0.150
    73.689   693.273     0.150
    73.796   693.273     0.150
    74.140   696.773     0.150
    74.140     7.000     0.150
    74.496   698.672     0.150
    74.687   699.875     0.150
    74.687     7.602     0.150
    74.935   700.773     0.150
    74.984   701.172     0.150
    74.992   700.898     0.150
    75.184   702.148     0.150
    75.184   702.273     0.150
    75.376   702.273     0.150
    75.949   704.602     0.150
    75.949   704.594     0.150
    76.532   708.828     0.150
    76.532   708.828     0.150
    77.942   717.797     0.150
    77.943   717.727     0.150
    83.677   748.750     0.150
    87.288   765.266     0.150
    87.289   765.266     0.150
    88.289   770.547     0.150
    96.268   807.773     0.150
   142.412  1173.172     0.150
   151.127  1190.742     0.150
     0.306     5.766     0.150
     0.306     9.875     0.150
     0.306     5.797     0.150
     0.306     9.992     0.150
     0.323     6.188     0.150
     0.323    10.859     0.150
     0.324     6.203     0.150
     0.324    10.594     0.150
     0.538     9.578     0.150
     0.538    16.656     0.150
     0.759    24.430     0.150
     0.986    17.688     0.150
     0.986    31.609     0.150
     1.145    20.836     0.150
     2.040    35.734     0.150
     2.040    60.586     0.150
     2.507    38.969     0.150
     2.507    73.680     0.150
     2.975    87.953     0.150
     2.975    78.398     0.150
     3.463    53.047     0.150
     3.463    94.336     0.150
     4.037    60.656     0.150
     4.037   106.133     0.150
     4.173    61.938     0.150
     4.173   106.703     0.150
     4.225    63.445     0.150
     4.225   112.180     0.150
     4.353    65.156     0.150
     4.353   113.516     0.150
     4.439    65.617     0.150
     4.439   117.383     0.150
     4.340    63.930     0.150
     4.340   117.414     0.150
     4.725    72.016     0.150
     4.725   124.438     0.150
     4.806    72.336     0.150
     4.930    72.484     0.150
     5.259    93.555     0.150
     5.259   162.633     0.150
     5.283    80.555     0.150
     5.283   162.492     0.150
     5.316    78.938     0.150
     5.439    80.883     0.150
     5.505    82.742     0.150
     5.505   143.398     0.150
     5.389    79.930     0.150
     5.389   142.836     0.150
     5.698    86.188     0.150
     5.698   174.836     0.150
     5.698    85.664     0.150
     5.698   175.789     0.150
     5.771    85.766     0.150
     5.794    86.523     0.150
     5.736    84.523     0.150
     6.190    90.773     0.150
     6.489    95.516     0.150
     6.547    97.008     0.150
     6.704    98.594     0.150
     6.769   100.055     0.150
     6.651    96.883     0.150
     6.651   176.414     0.150
     6.835   100.484     0.150
     6.835   181.812     0.150
     8.085   117.109     0.150
     8.119   119.508     0.150
     8.277   121.242     0.150
     8.277   120.594     0.150
     8.235   119.844     0.150
     8.626   125.133     0.150
     9.734   140.445     0.150
     9.832   142.312     0.150
     9.875   143.867     0.150
    10.261   149.133     0.150
    11.022   341.352     0.150
    10.778   156.492     0.150
    10.781   155.688     0.150
    11.083   159.969     0.150
    11.097   160.164     0.150
    11.509   166.258     0.150
    11.633   166.523     0.150
    11.806   168.969     0.150
    12.202   173.055     0.150
    12.150   175.023     0.150
    12.257   175.734     0.150
    12.213   174.430     0.150
    12.213   303.281     0.150
    12.313   176.445     0.150
    12.459   177.266     0.150
    12.476   178.664     0.150
    12.692   183.727     0.150
    12.870   181.953     0.150
    13.568   188.977     0.150
    13.568   424.094     0.150
    13.568   188.977     0.150
    13.400   188.047     0.150
    13.572   191.680     0.150
    13.655   192.648     0.150
    13.840   195.945     0.150
    13.840   196.734     0.150
    13.840   436.531     0.150
    13.840   198.133     0.150
    13.906   198.398     0.150
    13.939   198.523     0.150
    14.194   198.977     0.150
    14.131   202.086     0.150
    14.349   203.547     0.150
    14.569   206.508     0.150
    15.390   216.758     0.150
    15.390   483.883     0.150
    15.390   218.469     0.150
    16.614   238.242     0.150
    16.699   234.227     0.150
    17.675   249.086     0.150
    17.602   248.359     0.150
    18.206   248.078     0.150
    18.564   260.688     0.150
    20.209   280.062     0.150
    20.822   283.523     0.150
    22.937   302.484     0.150
    25.528   329.766     0.150
    25.936   332.953     0.150
    31.858   386.039     0.150
    31.858   556.234     0.150
    38.675   444.789     0.150
    40.257   458.086     0.150
    43.308   482.297     0.150
    44.111   487.688     0.150
    48.310   522.555     0.150
    59.076   600.609     0.150
    62.774   625.289     0.150
    62.774   625.562     0.150
    62.599   625.383     0.150
    67.671   658.188     0.150
    68.945   665.039     0.150
    71.307   678.883     0.150
    72.186   685.289     0.150
    72.802   689.742     0.150
    73.263   692.383     0.150
    73.803   695.383     0.150
    74.356   699.086     0.150
    74.652   698.188     0.150
    74.985   698.086     0.150
    75.999   708.039     0.150
    76.078   708.688     0.150
    76.189   708.133     0.150
    77.338   715.586     0.150
    77.338   725.586     0.150
    77.338  1310.086     0.150
    78.116   719.383     0.150
    81.498   738.008     0.150
    81.785   739.617     0.150
    82.021   740.547     0.150
    82.275   742.336     0.150
    82.548   744.680     0.150
    84.565   756.086     0.150
    84.565  1390.383     0.150
    86.932   765.133     0.150
    88.488   771.461     0.150
    88.972   774.258     0.150
    96.011   807.984     0.150
   150.770  1191.258     0.150
     0.350     6.189     0.150
     0.350    11.299     0.150
     0.351     6.029     0.150
     0.351    10.740     0.150
     2.653    42.311     0.150
     2.653    73.730     0.150
     2.697    40.920     0.150
     2.697    75.580     0.150
     3.570    55.480     0.150
     4.537    67.070     0.150
     5.549    82.420     0.150
     5.751    86.775     0.150
     5.751   178.074     0.150
     5.751    87.699     0.150
     6.820   100.820     0.150
     7.061   104.400     0.150
     7.401   109.199     0.150
     7.569   112.430     0.150
     7.807   110.840     0.150
     7.736   112.939     0.150
     8.003   117.162     0.150
     7.995   117.504     0.150
     8.171   120.840     0.150
     8.464   124.289     0.150
     8.458   121.520     0.150
     8.401   123.219     0.150
     8.517   125.820     0.150
     8.771   128.279     0.150
     8.846   129.578     0.150
     8.953   131.914     0.150
     9.168   133.980     0.150
     9.387   135.709     0.150
     9.440   136.820     0.150
     9.711   142.156     0.150
     9.966   145.455     0.150
    10.123   146.840     0.150
    10.216   147.129     0.150
    10.270   148.869     0.150
    10.341   149.439     0.150
    10.432   150.410     0.150
    10.490   152.754     0.150
    10.629   154.250     0.150
    10.520   152.852     0.150
    10.546   152.619     0.150
    10.692   150.840     0.150
    10.740   154.855     0.150
    10.740   331.830     0.150
    10.740   155.650     0.150
    10.837   157.859     0.150
    11.025   156.820     0.150
    11.034   158.359     0.150
    10.958   159.676     0.150
    11.189   159.949     0.150
    11.327   162.520     0.150
    11.220   161.525     0.150
    11.350   162.539     0.150
    11.229   161.744     0.150
    11.224   163.248     0.150
    11.600   167.340     0.150
    11.813   169.699     0.150
    11.728   169.711     0.150
    11.831   171.980     0.150
    12.052   173.080     0.150
    12.024   171.699     0.150
    12.049   174.760     0.150
    12.264   175.930     0.150
    12.124   175.922     0.150
    12.248   177.539     0.150
    12.353   174.980     0.150
    12.400   177.170     0.150
    12.517   178.939     0.150
    12.494   175.818     0.150
    12.567   179.850     0.150
    12.597   179.990     0.150
    12.475   177.938     0.150
    12.643   182.750     0.150
    12.622   181.180     0.150
    12.739   182.510     0.150
    12.739   183.299     0.150
    12.728   184.170     0.150
    12.927   184.449     0.150
    12.908   185.238     0.150
    12.908   183.000     0.150
    13.129   186.080     0.150
    13.163   188.043     0.150
    13.171   189.867     0.150
    13.272   189.760     0.150
    13.329   191.580     0.150
    13.329   190.564     0.150
    13.503   189.445     0.150
    13.503   190.449     0.150
    13.320   190.400     0.150
    13.541   189.799     0.150
    13.638   193.689     0.150
    13.727   195.574     0.150
    13.725   195.549     0.150
    13.588   194.852     0.150
    13.657   194.209     0.150
    13.890   198.029     0.150
    14.059   199.580     0.150
    14.059   198.549     0.150
    14.059   199.279     0.150
    13.925   199.459     0.150
    13.963   200.449     0.150
    14.149   200.680     0.150
    14.165   200.020     0.150
    13.997   198.820     0.150
    14.216   202.561     0.150
    14.404   211.510     0.150
    14.283   203.523     0.150
    14.493   205.660     0.150
    14.571   206.480     0.150
    14.609   207.619     0.150
    14.761   209.010     0.150
    14.808   209.779     0.150
    14.751   205.750     0.150
    14.942   211.299     0.150
    15.131   214.389     0.150
    15.129   215.000     0.150
    15.129   214.547     0.150
    15.185   213.910     0.150
    15.185   214.711     0.150
    15.360   216.820     0.150
    15.265   217.670     0.150
    15.349   217.320     0.150
    15.513   220.590     0.150
    15.389   217.740     0.150
    15.921   226.430     0.150
    15.895   226.500     0.150
    15.989   228.049     0.150
    16.102   228.910     0.150
    16.152   230.320     0.150
    16.170   233.590     0.150
    16.274   230.830     0.150
    16.282   231.539     0.150
    16.369   233.230     0.150
    16.352   234.020     0.150
    16.577   239.500     0.150
    16.670   237.850     0.150
    16.670   234.596     0.150
    16.780   237.650     0.150
    16.796   238.510     0.150
    16.932   236.990     0.150
    16.899   242.369     0.150
    16.981   240.910     0.150
    16.981   238.549     0.150
    16.983   240.760     0.150
    16.927   242.010     0.150
    16.963   242.379     0.150
    17.037   243.789     0.150
    17.010   242.230     0.150
    17.149   242.990     0.150
    17.163   244.240     0.150
    17.175   244.740     0.150
    17.162   242.670     0.150
    17.247   243.260     0.150
    17.438   247.799     0.150
    17.419   245.299     0.150
    17.419   245.191     0.150
    17.419   525.250     0.150
    17.475   246.170     0.150
    17.802   248.102     0.150
    17.749   249.910     0.150
    17.758   254.330     0.150
    17.829   251.879     0.150
    17.932   251.699     0.150
    17.932   250.865     0.150
    17.997   251.789     0.150
    17.875   252.529     0.150
    17.920   251.643     0.150
    17.999   253.639     0.150
    18.281   256.400     0.150
    18.281   254.252     0.150
    18.281   256.420     0.150
    18.281   255.049     0.150
    18.281   254.689     0.150
    18.343   255.709     0.150
    18.343   254.732     0.150
    18.410   256.850     0.150
    18.410   256.139     0.150
    18.433   261.959     0.150
    18.603   259.420     0.150
    18.603   258.076     0.150
    18.653   260.617     0.150
    18.959   263.539     0.150
    19.031   264.494     0.150
    19.153   266.910     0.150
    19.223   266.500     0.150
    19.253   266.918     0.150
    19.435   268.770     0.150
    19.514   269.969     0.150
    19.514   269.443     0.150
    19.578   270.850     0.150
    19.617   271.035     0.150
    19.689   271.355     0.150
    19.811   272.352     0.150
    19.807   272.990     0.150
    19.894   275.100     0.150
    19.995   275.230     0.150
    20.058   275.020     0.150
    20.058   274.518     0.150
    20.028   275.830     0.150
    20.066   275.867     0.150
    20.131   277.160     0.150
    20.249   277.879     0.150
    20.254   278.168     0.150
    20.338   278.660     0.150
    20.341   278.219     0.150
    20.470   280.000     0.150
    20.379   279.840     0.150
    20.399   280.000     0.150
    20.611   281.590     0.150
    20.611   280.723     0.150
    20.746   283.090     0.150
    20.736   283.270     0.150
    20.736   282.852     0.150
    20.811   283.570     0.150
    20.811   283.264     0.150
    20.819   284.439     0.150
    20.932   286.680     0.150
    20.957   285.191     0.150
    21.023   285.525     0.150
    21.253   288.939     0.150
    21.257   288.670     0.150
    21.392   288.824     0.150
    21.333   289.494     0.150
    21.378   289.861     0.150
    21.539   290.900     0.150
    21.539   289.418     0.150
    21.550   292.150     0.150
    21.584   293.260     0.150
    21.647   293.070     0.150
    21.620   292.219     0.150
    21.658   293.020     0.150
    21.691   293.520     0.150
    21.700   293.359     0.150
    21.701   292.520     0.150
    21.754   294.260     0.150
    21.770   293.289     0.150
    21.803   293.959     0.150
    21.804   293.750     0.150
    21.844   292.920     0.150
    21.834   294.070     0.150
    21.856   294.400     0.150
    21.856   293.959     0.150
    21.881   294.119     0.150
    21.887   295.000     0.150
    21.967   295.219     0.150
    21.973   295.609     0.150
    22.077   297.129     0.150
    22.114   297.180     0.150
    22.118   297.713     0.150
    22.179   297.969     0.150
    22.195   298.180     0.150
    22.228   299.572     0.150
    22.372   299.650     0.150
    22.372   299.779     0.150
    22.374   299.740     0.150
    22.384   301.025     0.150
    22.379   299.854     0.150
    22.476   302.350     0.150
    22.476   301.178     0.150
    22.425   300.893     0.150
    22.698   301.674     0.150
    22.698   303.520     0.150
    22.658   303.359     0.150
    22.708   302.555     0.150
    22.828   304.832     0.150
    22.858   304.889     0.150
    22.858   304.660     0.150
    22.986   306.299     0.150
    22.986   306.451     0.150
    23.032   306.492     0.150
    23.135   306.799     0.150
    23.211   308.061     0.150
    23.320   308.260     0.150
    23.320   308.555     0.150
    23.310   309.650     0.150
    23.310   309.014     0.150
    23.466   310.779     0.150
    23.466   309.469     0.150
    23.363   309.686     0.150
    23.444   311.400     0.150
    23.484   311.340     0.150
    23.484   310.732     0.150
    23.727   314.000     0.150
    23.727   312.127     0.150
    23.714   314.900     0.150
    23.917   315.779     0.150
    23.917   315.281     0.150
    24.013   316.619     0.150
    24.013   315.977     0.150
    24.150   318.219     0.150
    24.300   318.820     0.150
    24.685   322.600     0.150
    24.685   322.256     0.150
    25.045   325.311     0.150
    25.045   324.832     0.150
    25.258   327.029     0.150
    25.258   326.443     0.150
    25.246   328.445     0.150
    25.656   330.494     0.150
    25.656   331.119     0.150
    25.656   330.881     0.150
    25.705   331.439     0.150
    25.749   334.289     0.150
    25.791   332.660     0.150
    25.791   332.500     0.150
    26.020   334.789     0.150
    26.257   335.869     0.150
    26.257   335.422     0.150
    26.203   336.439     0.150
    26.563   337.525     0.150
    26.563   337.350     0.150
    26.461   338.359     0.150
    26.766   342.131     0.150
    26.958   342.906     0.150
    26.962   342.812     0.150
    27.250   345.629     0.150
    27.972   350.789     0.150
    28.084   352.449     0.150
    28.197   354.869     0.150
    28.197   353.961     0.150
    28.353   356.600     0.150
    28.314   355.090     0.150
    28.314   355.293     0.150
    28.444   355.398     0.150
    28.576   358.219     0.150
    28.800   359.670     0.150
    28.800   358.617     0.150
    29.410   364.230     0.150
    29.892   369.020     0.150
    29.892   368.686     0.150
    30.735   376.410     0.150
    30.735   375.512     0.150
    31.014   379.650     0.150
    31.365   379.053     0.150
    31.496   380.154     0.150
    31.580   383.820     0.150
    31.580   382.020     0.150
    31.581   383.824     0.150
    31.701   383.898     0.150
    31.745   383.705     0.150
    31.784   385.420     0.150
    31.786   384.303     0.150
    31.940   385.566     0.150
    31.951   385.705     0.150
    32.026   386.795     0.150
    32.061   386.918     0.150
    32.130   387.660     0.150
    32.292   388.273     0.150
    32.396   389.268     0.150
    32.529   390.873     0.150
    32.580   391.434     0.150
    32.684   393.758     0.150
    32.932   394.303     0.150
    32.964   394.980     0.150
    32.955   394.715     0.150
    32.978   395.588     0.150
    33.098   395.535     0.150
    33.153   395.586     0.150
    33.559   399.912     0.150
    34.015   403.465     0.150
    34.009   405.172     0.150
    34.174   405.314     0.150
    34.541   407.701     0.150
    34.613   409.590     0.150
    34.609   409.346     0.150
    35.141   416.219     0.150
    35.308   414.402     0.150
    35.431   415.836     0.150
    35.464   416.363     0.150
    35.559   417.525     0.150
    36.010   422.684     0.150
    36.455   426.402     0.150
    36.855   428.541     0.150
    36.872   427.328     0.150
    36.877   426.121     0.150
    37.696   435.174     0.150
    37.749   435.869     0.150
    37.801   435.836     0.150
    37.989   437.533     0.150
    38.005   438.350     0.150
    38.062   437.322     0.150
    38.041   437.812     0.150
    38.097   438.242     0.150
    38.294   440.939     0.150
    38.294   440.711     0.150
    38.326   440.604     0.150
    38.577   442.465     0.150
    38.774   444.348     0.150
    38.940   446.400     0.150
    39.073   446.988     0.150
    39.079   446.033     0.150
    39.503   448.900     0.150
    39.729   451.908     0.150
    39.757   452.158     0.150
    39.882   453.746     0.150
    40.537   460.350     0.150
    40.539   460.346     0.150
    40.880   461.748     0.150
    40.999   464.244     0.150
    42.647   474.877     0.150
    43.530   484.059     0.150
    48.563   523.572     0.150
    55.953   578.775     0.150
    59.356   602.049     0.150
    61.545   616.430     0.150
    61.545   616.428     0.150
    62.802   626.000     0.150
    62.802   625.670     0.150
    62.802   625.674     0.150
    66.433   649.258     0.150
    66.433   649.260     0.150
    67.260   655.775     0.150
    67.924   658.359     0.150
    67.924   658.359     0.150
    69.149   666.350     0.150
    69.153   666.354     0.150
    71.574   682.900     0.150
    72.817   689.600     0.150
    74.663   700.449     0.150
    75.188   703.625     0.150
    75.656   704.219     0.150
    75.656   704.219     0.150
    76.401   709.680     0.150
    76.401   709.674     0.150
    77.599   716.199     0.150
    77.717   720.100     0.150
    78.387   720.600     0.150
    78.387   730.400     0.150
    78.856   724.100     0.150
    80.035   729.395     0.150
    80.035   730.230     0.150
    83.708   749.600     0.150
    87.000   765.750     0.150
    87.001   765.750     0.150
    88.206   770.924     0.150
    88.206   771.029     0.150
   149.142  1186.732     0.150
   149.142  1192.527     0.150
   149.665  1188.215     0.150
   149.917  1188.662     0.150
   150.682  1191.824     0.150
   151.221  1191.633     0.150
     0.591    10.848     0.150
     0.591    10.105     0.150
     0.591    18.688     0.150
     0.625    11.348     0.150
     0.625    20.367     0.150
     2.829    43.098     0.150
     2.921    43.547     0.150
     2.921    75.898     0.150
     3.786    57.578     0.150
     4.646    67.977     0.150
     5.708    82.816     0.150
     6.012    90.172     0.150
     8.587   123.688     0.150
     9.257   134.535     0.150
     9.606   138.887     0.150
    11.349   161.078     0.150
    11.701   166.258     0.150
    11.946   167.578     0.150
    11.945   172.016     0.150
    12.069   171.738     0.150
    14.130   200.746     0.150
    14.173   200.098     0.150
    15.290   215.695     0.150
    17.433   243.723     0.150
    18.439   256.348     0.150
    19.539   269.309     0.150
    19.611   268.695     0.150
    19.906   272.387     0.150
    20.405   277.816     0.150
    25.497   328.266     0.150
    31.671   384.746     0.150
    31.671   384.746     0.150
    63.082   626.867     0.150
    63.082   626.871     0.150
    74.954   701.422     0.150
     0.430     7.965     0.150
     0.430    13.277     0.150
     0.430     7.746     0.150
     0.430    14.137     0.150
     0.455     8.625     0.150
     0.455    15.086     0.150
     0.456     8.516     0.150
     0.456    14.477     0.150
     0.615    11.234     0.150
     0.615    19.324     0.150
     0.717    12.844     0.150
     0.717    23.234     0.150
     1.122    19.164     0.150
     1.122    33.445     0.150
     1.280    22.895     0.150
     1.280    41.277     0.150
     1.485    43.754     0.150
     2.150    33.625     0.150
     2.150    37.457     0.150
     2.150    64.586     0.150
     2.967    44.605     0.150
     2.967    87.004     0.150
     2.967    44.336     0.150
     2.967    50.637     0.150
     2.967    88.277     0.150
     3.665    53.805     0.150
     3.665    97.695     0.150
     3.602    54.637     0.150
     3.744   115.695     0.150
     3.983    57.527     0.150
     4.112    61.055     0.150
     4.155    61.715     0.150
     4.296    62.445     0.150
     4.388    64.336     0.150
     4.750    69.984     0.150
     4.883    71.547     0.150
     5.257    77.504     0.150
     5.327    78.324     0.150
     5.836    87.879     0.150
     5.836    87.594     0.150
    13.955   199.156     0.150
    15.527   221.031     0.150
    17.584   247.617     0.150
    18.269   251.055     0.150
    18.528   260.336     0.150
    30.140   371.234     0.150
    31.793   383.789     0.150
    38.758   444.781     0.150
    43.421   483.316     0.150
    69.064   665.742     0.150
    74.788   700.547     0.150
    76.306   709.102     0.150
    77.787   717.930     0.150
    88.438   772.379     0.150
   150.886  1192.332     0.150
     0.140     2.949     0.150
     0.357     6.902     0.150
     0.357    12.262     0.150
     0.351     6.449     0.150
     0.351    11.250     0.150
     0.351     6.293     0.150
     0.351    11.402     0.150
     0.410     7.723     0.150
     0.410    13.281     0.150
     0.410     7.551     0.150
     0.410    13.062     0.150
     0.454     7.941     0.150
     0.454    14.199     0.150
     0.611    10.711     0.150
     0.611    18.949     0.150
     0.897    15.512     0.150
     0.897    27.180     0.150
     1.154    20.262     0.150
     1.154    35.691     0.150
     1.168    21.480     0.150
     1.168    37.070     0.150
     1.919    31.250     0.150
     1.919    58.770     0.150
     2.664    40.980     0.150
     2.664    78.742     0.150
     3.730    54.562     0.150
     3.730    98.152     0.150
     3.871    55.840     0.150
     3.871   116.730     0.150
     4.049    60.719     0.150
     4.049   109.711     0.150
     4.131    61.180     0.150
     4.131   109.289     0.150
     4.501    67.031     0.150
     4.619    69.492     0.150
     5.025    75.281     0.150
     5.025   155.051     0.150
     5.011    75.191     0.150
     5.132    76.770     0.150
     5.196    77.469     0.150
     5.196   135.852     0.150
     5.196   158.402     0.150
     5.468    81.102     0.150
     5.737    87.242     0.150
     5.737   151.371     0.150
     5.737   175.941     0.150
     5.905   182.340     0.150
     6.562    97.910     0.150
     6.562   200.902     0.150
     6.746    99.211     0.150
     6.746   209.039     0.150
     7.941   115.090     0.150
     7.941   246.359     0.150
     7.991   116.020     0.150
     7.991   203.430     0.150
     7.991   250.191     0.150
     8.107   119.410     0.150
    13.477   190.535     0.150
    14.069   207.180     0.150
    17.402   245.426     0.150
    18.251   255.156     0.150
    31.556   384.465     0.150
    76.409   708.902     0.150
     0.239     4.429     0.150
     0.239     7.988     0.150
     0.239     4.988     0.150
     0.239     8.479     0.150
     0.295     5.809     0.150
     0.295     9.948     0.150
     0.277     5.738     0.150
     0.277     9.309     0.150
     0.278     5.669     0.150
     0.278     9.158     0.150
     0.423     7.719     0.150
     0.423    12.869     0.150
     0.661    12.188     0.150
     0.661    21.049     0.150
     0.817    14.429     0.150
     0.817    25.089     0.150
     0.998    17.469     0.150
     0.998    30.049     0.150
     1.097    19.509     0.150
     1.103    18.938     0.150
     1.103    33.249     0.150
     1.949    30.839     0.150
     1.949    34.198     0.150
     1.949    58.528     0.150
     2.514    40.658     0.150
     2.514    76.608     0.150
     2.858    43.063     0.150
     2.858    75.464     0.150
     2.858    84.669     0.150
     2.858    42.809     0.150
     2.858    75.249     0.150
     3.452    53.329     0.150
     3.452    93.278     0.150
     3.452   108.839     0.150
     3.618    96.459     0.150
     3.937    57.568     0.150
     3.937   101.499     0.150
     4.078    59.849     0.150
     4.078   104.908     0.150
     4.337    63.778     0.150
     4.337   112.079     0.150
     4.375    65.549     0.150
     4.375   118.049     0.150
     4.708    69.639     0.150
     4.826    71.809     0.150
     4.826   125.219     0.150
     5.143    77.629     0.150
     5.143   156.889     0.150
     5.338    78.019     0.150
     5.338   139.358     0.150
     5.402    78.589     0.150
     5.402   139.438     0.150
     5.610   146.669     0.150
     5.663    85.738     0.150
     5.663   152.789     0.150
     5.663    85.229     0.150
     5.663   146.639     0.150
     5.663    85.448     0.150
     5.663   104.559     0.150
     5.663   174.028     0.150
     5.674   148.679     0.150
     5.755    84.559     0.150
     5.755   180.769     0.150
     6.086    89.119     0.150
     7.801   113.639     0.150
     7.801   113.309     0.150
     7.801   243.568     0.150
    10.909   154.677     0.150
    13.490   189.733     0.150
    13.490   424.884     0.150
    13.490   189.729     0.150
    13.889   199.430     0.150
    13.889   199.429     0.150
    15.186   215.698     0.150
    15.387   218.464     0.150
    16.535   232.049     0.150
    18.455   256.669     0.150
    20.288   277.999     0.150
    20.772   282.139     0.150
    20.989   284.669     0.150
    22.816   301.889     0.150
    25.407   328.089     0.150
    26.499   339.339     0.150
    26.499   337.499     0.150
    30.066   369.339     0.150
    31.763   383.769     0.150
    31.763   383.764     0.150
    62.731   624.639     0.150
    62.731   624.638     0.150
    76.234   708.269     0.150
    76.234   708.264     0.150
     0.239     4.850     0.150
     0.239     8.551     0.150
     0.357     6.900     0.150
     0.357    11.699     0.150
     0.357     6.844     0.150
     0.357    11.945     0.150
     0.437     8.061     0.150
     0.437    14.189     0.150
     0.528     9.801     0.150
     0.528    16.891     0.150
     0.695    12.320     0.150
     0.695    21.459     0.150
     0.967    16.689     0.150
     0.967    29.910     0.150
     1.142    19.500     0.150
     1.142    34.879     0.150
     1.205    21.510     0.150
     1.997    31.680     0.150
     1.997    59.189     0.150
     2.654    41.770     0.150
     2.759    41.439     0.150
     2.759    82.482     0.150
     2.759    42.090     0.150
     2.759    76.391     0.150
     2.759    73.029     0.150
     2.759    81.830     0.150
     3.533    51.850     0.150
     3.498    89.770     0.150
     3.582   110.930     0.150
     3.806    71.430     0.150
     3.806   113.109     0.150
     3.942    57.580     0.150
     3.942   101.180     0.150
     3.996    59.320     0.150
     3.996   104.379     0.150
     4.122    59.740     0.150
     4.208    61.480     0.150
     4.208   107.879     0.150
     4.495    67.580     0.150
     4.524    66.260     0.150
     4.575    67.039     0.150
     4.699    69.020     0.150
     4.699   123.920     0.150
     5.125    75.100     0.150
     5.125   155.051     0.150
     5.085    74.529     0.150
     5.208    76.180     0.150
     5.275   136.090     0.150
     5.480   143.240     0.150
     5.540    81.850     0.150
     5.547    81.619     0.150
     5.564    82.180     0.150
     5.776    87.164     0.150
     5.776   152.314     0.150
     5.776   178.840     0.150
     5.776    86.641     0.150
     5.776   177.400     0.150
     5.899    87.561     0.150
     5.899    87.359     0.150
     5.960    87.270     0.150
     6.258    91.590     0.150
     6.296    92.959     0.150
     6.317    92.250     0.150
     6.474    92.850     0.150
     6.656    96.561     0.150
     6.731   210.770     0.150
     6.816   100.289     0.150
     6.946   101.471     0.150
     7.031   103.471     0.150
     7.110   104.641     0.150
     7.110   105.490     0.150
     7.110   104.379     0.150
     7.111   103.980     0.150
     7.112   104.080     0.150
     7.598   111.879     0.150
     7.623   112.650     0.150
     7.779   114.580     0.150
     7.840   114.910     0.150
     7.942   115.369     0.150
     7.942   115.129     0.150
     7.942   202.590     0.150
     7.942   244.100     0.150
     8.066   116.590     0.150
     8.066   245.619     0.150
     8.054   119.256     0.150
     8.041   117.045     0.150
     8.303   121.279     0.150
     8.454   123.000     0.150
     8.454   122.471     0.150
     8.437   122.641     0.150
     8.437   122.490     0.150
     8.437   216.721     0.150
     8.557   127.160     0.150
     8.725   128.199     0.150
     8.844   130.119     0.150
     8.844   274.160     0.150
     8.804   127.090     0.150
     8.819   130.359     0.150
     9.021   130.869     0.150
     9.021   276.930     0.150
     8.996   131.969     0.150
     9.149   133.830     0.150
     9.158   135.469     0.150
     9.214   134.570     0.150
     9.461   290.551     0.150
     9.437   137.900     0.150
     9.496   138.689     0.150
     9.747   144.271     0.150
     9.925   144.109     0.150
    10.010   145.516     0.150
    10.026   145.629     0.150
    10.319   149.840     0.150
    10.427   319.609     0.150
    10.397   152.660     0.150
    10.606   325.230     0.150
    10.475   152.561     0.150
    10.526   154.369     0.150
    10.578   152.850     0.150
    10.622   155.010     0.150
    10.596   153.529     0.150
    10.798   156.117     0.150
    10.798   156.580     0.150
    10.995   157.859     0.150
    11.242   161.709     0.150
    11.260   164.250     0.150
    11.298   162.551     0.150
    11.431   164.141     0.150
    11.317   162.930     0.150
    11.648   168.760     0.150
    11.806   168.750     0.150
    11.806   167.570     0.150
    11.806   366.410     0.150
    11.848   170.197     0.150
    11.835   170.119     0.150
    12.077   173.270     0.150
    12.022   172.170     0.150
    12.161   175.520     0.150
    12.311   178.939     0.150
    12.311   177.699     0.150
    12.311   381.811     0.150
    12.241   175.459     0.150
    12.241   174.721     0.150
    12.357   179.279     0.150
    12.368   177.109     0.150
    12.480   179.260     0.150
    12.444   176.037     0.150
    12.534   178.650     0.150
    12.565   180.119     0.150
    12.703   182.789     0.150
    12.703   184.439     0.150
    12.653   183.051     0.150
    12.798   185.199     0.150
    12.761   181.090     0.150
    12.789   183.971     0.150
    12.902   184.869     0.150
    12.990   186.770     0.150
    12.936   183.090     0.150
    13.093   187.221     0.150
    13.191   188.789     0.150
    13.315   191.330     0.150
    13.387   191.840     0.150
    13.387   192.180     0.150
    13.552   189.834     0.150
    13.552   421.547     0.150
    13.552   188.529     0.150
    13.587   190.369     0.150
    13.589   190.551     0.150
    13.589   189.600     0.150
    13.611   193.811     0.150
    13.729   195.125     0.150
    13.804   198.850     0.150
    14.039   199.660     0.150
    14.039   198.084     0.150
    14.039   203.039     0.150
    14.023   208.730     0.150
    14.120   201.480     0.150
    14.143   205.311     0.150
    14.194   201.811     0.150
    14.474   205.721     0.150
    14.308   205.281     0.150
    14.380   212.199     0.150
    14.383   203.484     0.150
    14.456   204.445     0.150
    14.460   206.141     0.150
    14.559   208.029     0.150
    14.528   204.980     0.150
    14.550   210.709     0.150
    14.669   208.939     0.150
    14.669   210.510     0.150
    14.730   209.879     0.150
    14.781   208.830     0.150
    14.999   213.670     0.150
    14.984   214.090     0.150
    15.181   216.420     0.150
    15.181   216.717     0.150
    15.248   215.609     0.150
    15.248   215.061     0.150
    15.293   223.209     0.150
    15.408   218.699     0.150
    15.408   218.246     0.150
    15.336   217.119     0.150
    15.336   522.869     0.150
    15.421   225.471     0.150
    15.522   218.602     0.150
    15.522   489.016     0.150
    15.522   217.811     0.150
    15.522   217.689     0.150
    16.018   231.760     0.150
    16.159   229.230     0.150
    16.184   229.230     0.150
    16.430   231.180     0.150
    16.384   230.840     0.150
    16.473   232.949     0.150
    16.610   234.500     0.150
    16.727   234.051     0.150
    16.727   235.154     0.150
    16.853   237.680     0.150
    16.809   235.109     0.150
    16.809   237.221     0.150
    16.954   239.420     0.150
    16.907   236.609     0.150
    16.958   243.980     0.150
    17.040   239.869     0.150
    17.040   240.029     0.150
    17.039   241.449     0.150
    16.999   241.039     0.150
    17.039   241.289     0.150
    17.204   237.910     0.150
    17.205   242.051     0.150
    17.219   242.779     0.150
    17.230   243.080     0.150
    17.196   243.311     0.150
    17.297   242.971     0.150
    17.492   246.279     0.150
    17.453   246.369     0.150
    17.453   241.277     0.150
    17.509   246.100     0.150
    17.798   250.119     0.150
    17.808   255.650     0.150
    17.860   250.420     0.150
    17.995   251.709     0.150
    17.995   251.889     0.150
    18.063   249.410     0.150
    17.952   250.914     0.150
    18.050   252.891     0.150
    18.336   257.379     0.150
    18.336   255.080     0.150
    18.337   257.520     0.150
    18.337   257.396     0.150
    18.409   255.430     0.150
    18.409   254.363     0.150
    18.458   257.801     0.150
    18.458   257.584     0.150
    18.619   259.070     0.150
    18.559   264.580     0.150
    18.643   260.520     0.150
    18.643   259.285     0.150
    19.007   264.350     0.150
    19.065   263.861     0.150
    19.179   269.301     0.150
    19.266   267.570     0.150
    19.285   266.066     0.150
    19.550   270.301     0.150
    19.550   270.066     0.150
    19.610   275.350     0.150
    19.723   272.035     0.150
    19.843   273.996     0.150
    19.837   272.539     0.150
    19.942   277.721     0.150
    20.044   274.689     0.150
    20.074   275.830     0.150
    20.117   275.039     0.150
    20.291   277.770     0.150
    20.285   277.705     0.150
    20.356   276.801     0.150
    20.218   276.740     0.150
    20.380   278.721     0.150
    20.379   278.629     0.150
    20.428   279.270     0.150
    20.444   280.141     0.150
    20.449   280.102     0.150
    20.433   278.590     0.150
    20.672   281.529     0.150
    20.672   280.750     0.150
    20.710   282.254     0.150
    20.787   283.039     0.150
    20.769   283.520     0.150
    20.769   282.434     0.150
    20.864   283.820     0.150
    20.864   283.648     0.150
    20.863   284.459     0.150
    20.975   288.029     0.150
    20.992   285.350     0.150
    21.032   284.129     0.150
    21.160   286.891     0.150
    21.282   288.760     0.150
    21.458   289.570     0.150
    21.366   289.211     0.150
    21.596   290.959     0.150
    21.595   291.260     0.150
    21.595   290.273     0.150
    21.600   292.670     0.150
    21.634   292.910     0.150
    21.697   292.260     0.150
    21.666   292.395     0.150
    21.701   293.340     0.150
    21.740   294.000     0.150
    21.750   294.750     0.150
    21.751   293.820     0.150
    21.804   294.689     0.150
    21.819   294.551     0.150
    21.853   294.330     0.150
    21.854   294.500     0.150
    21.884   295.301     0.150
    21.906   295.141     0.150
    21.906   295.570     0.150
    21.931   295.119     0.150
    21.936   295.641     0.150
    22.017   296.199     0.150
    22.023   296.850     0.150
    22.144   295.879     0.150
    22.144   294.400     0.150
    22.164   297.619     0.150
    22.232   298.570     0.150
    22.228   297.605     0.150
    22.403   298.947     0.150
    22.419   300.723     0.150
    22.456   298.369     0.150
    22.531   303.379     0.150
    22.531   300.855     0.150
    22.765   301.678     0.150
    22.765   715.324     0.150
    22.765   301.910     0.150
    22.742   302.760     0.150
    22.871   304.992     0.150
    22.907   305.199     0.150
    22.907   304.939     0.150
    23.361   310.510     0.150
    23.361   309.924     0.150
    23.375   308.941     0.150
    23.533   310.680     0.150
    23.533   310.148     0.150
    23.786   314.010     0.150
    23.786   313.748     0.150
    23.755   316.391     0.150
    24.066   316.840     0.150
    24.066   316.232     0.150
    24.268   315.289     0.150
    24.344   319.840     0.150
    24.742   323.391     0.150
    24.742   322.449     0.150
    25.121   325.449     0.150
    25.322   327.230     0.150
    25.322   326.635     0.150
    25.283   327.221     0.150
    25.705   329.156     0.150
    25.705   333.221     0.150
    25.705   331.088     0.150
    25.884   333.070     0.150
    25.831   332.059     0.150
    26.597   338.062     0.150
    26.597   340.740     0.150
    26.597   336.830     0.150
    27.024   341.088     0.150
    27.007   343.361     0.150
    27.791   349.721     0.150
    28.251   355.789     0.150
    28.251   352.869     0.150
    28.366   357.160     0.150
    28.366   353.432     0.150
    29.948   369.600     0.150
    29.948   369.074     0.150
    31.119   379.051     0.150
    31.428   379.984     0.150
    31.626   384.789     0.150
    31.627   383.721     0.150
    31.764   383.146     0.150
    31.976   387.459     0.150
    32.003   385.971     0.150
    32.003   385.656     0.150
    32.013   385.219     0.150
    32.355   387.189     0.150
    32.366   387.764     0.150
    32.459   389.359     0.150
    32.456   389.611     0.150
    32.682   390.900     0.150
    32.656   393.910     0.150
    32.656   391.357     0.150
    32.739   392.736     0.150
    32.772   391.867     0.150
    32.993   393.967     0.150
    33.037   396.379     0.150
    33.037   395.297     0.150
    33.215   395.980     0.150
    34.070   403.984     0.150
    34.192   404.783     0.150
    34.595   412.740     0.150
    34.595   410.332     0.150
    34.677   409.602     0.150
    35.177   415.344     0.150
    35.195   416.459     0.150
    35.357   415.953     0.150
    35.372   415.029     0.150
    35.370   414.326     0.150
    35.493   416.430     0.150
    35.493   415.217     0.150
    35.527   415.826     0.150
    35.708   418.068     0.150
    35.955   420.260     0.150
    36.015   418.996     0.150
    36.048   420.648     0.150
    36.259   422.660     0.150
    36.291   422.377     0.150
    36.502   422.092     0.150
    36.512   423.549     0.150
    36.523   424.580     0.150
    36.528   425.959     0.150
    36.515   425.604     0.150
    36.617   424.195     0.150
    36.840   428.729     0.150
    36.919   427.988     0.150
    36.934   428.018     0.150
    36.940   428.578     0.150
    36.986   427.002     0.150
    37.376   435.689     0.150
    37.455   432.039     0.150
    37.724   434.432     0.150
    37.759   435.822     0.150
    37.813   435.916     0.150
    37.824   436.762     0.150
    37.955   436.170     0.150
    38.053   437.576     0.150
    38.103   437.896     0.150
    38.161   439.709     0.150
    38.161   437.730     0.150
    38.226   438.605     0.150
    38.358   440.609     0.150
    38.358   439.906     0.150
    38.387   440.693     0.150
    38.455   440.525     0.150
    38.437   441.332     0.150
    38.641   441.635     0.150
    38.639   443.146     0.150
    38.712   443.779     0.150
    38.766   444.461     0.150
    38.836   444.143     0.150
    39.070   446.801     0.150
    39.137   446.449     0.150
    39.413   449.385     0.150
    39.564   449.449     0.150
    39.565   451.109     0.150
    39.821   451.652     0.150
    39.918   450.697     0.150
    39.946   453.785     0.150
    40.943   460.650     0.150
    41.821   471.180     0.150
    41.821   470.990     0.150
    44.175   488.289     0.150
    59.307   601.021     0.150
    62.833   625.289     0.150
    62.833   625.225     0.150
    64.790   637.957     0.150
    66.471   647.590     0.150
    67.316   656.572     0.150
    67.878   658.020     0.150
    67.891   657.975     0.150
    68.937   667.260     0.150
    69.137   665.740     0.150
    69.137   665.689     0.150
    69.137   665.160     0.150
    71.534   681.891     0.150
    72.762   688.061     0.150
    72.851   688.820     0.150
    73.525   692.350     0.150
    73.839   695.750     0.150
    74.401   698.949     0.150
    74.401   698.590     0.150
    74.653   699.490     0.150
    74.698   699.809     0.150
    74.706   699.660     0.150
    74.901   701.090     0.150
    75.092   701.891     0.150
    75.552   705.789     0.150
    75.680   704.039     0.150
    75.926   708.330     0.150
    75.932   706.090     0.150
    76.136   707.891     0.150
    76.384   708.859     0.150
    76.384   708.891     0.150
    76.404   708.490     0.150
    76.447   709.410     0.150
    77.648   716.523     0.150
    77.649   716.689     0.150
    77.729   715.740     0.150
    77.694   717.391     0.150
    78.818   723.490     0.150
    78.818   903.090     0.150
    80.096   730.170     0.150
    82.083   740.699     0.150
    83.293   746.789     0.150
    83.722   748.869     0.150
    84.755   757.090     0.150
    84.755  1381.090     0.150
    85.745   759.746     0.150
    87.023   765.289     0.150
    88.258   770.455     0.150
   102.170   834.279     0.150
   146.238  1181.330     0.150
     0.193     4.188     0.150
     0.193     7.285     0.150
     0.376     7.277     0.150
     0.376    12.285     0.150
     0.376     7.367     0.150
     0.376    12.277     0.150
     0.409     7.836     0.150
     0.409    13.059     0.150
     0.431     8.559     0.150
     0.431    14.168     0.150
     0.432     8.309     0.150
     0.432    14.137     0.150
     0.469     8.836     0.150
     0.635    11.285     0.150
     0.635    19.367     0.150
     0.910    15.738     0.150
     0.910    28.008     0.150
     1.173    20.277     0.150
     1.208    21.238     0.150
     1.971    31.059     0.150
     1.971    59.707     0.150
     2.678    41.148     0.150
     2.698    40.781     0.150
     2.698    72.383     0.150
     2.698    81.480     0.150
     2.698    41.137     0.150
     2.698    40.656     0.150
     2.698    71.707     0.150
     2.698    80.238     0.150
     3.472    52.398     0.150
     3.472    92.086     0.150
     3.597    54.629     0.150
     3.747    54.559     0.150
     3.747    96.266     0.150
     3.885    58.309     0.150
     3.885   102.938     0.150
     4.149    60.926     0.150
     4.149   107.617     0.150
     4.439    65.707     0.150
     4.517    66.695     0.150
     4.559    66.629     0.150
     4.640    68.277     0.150
     5.027    73.648     0.150
     5.076    74.777     0.150
     5.149    75.578     0.150
     5.216    75.707     0.150
     5.216   134.695     0.150
     5.483    81.398     0.150
     5.574    81.656     0.150
     5.779    87.133     0.150
     5.779   151.531     0.150
     5.779   181.281     0.150
     5.779    86.797     0.150
     5.779    86.969     0.150
     5.901    86.676     0.150
     5.928    86.969     0.150
     6.200    90.066     0.150
     6.237   155.988     0.150
     6.414    92.266     0.150
     6.844    99.438     0.150
     6.888   100.605     0.150
     7.537   109.129     0.150
     7.563   111.508     0.150
     7.724   113.566     0.150
     7.967   115.605     0.150
     7.967   115.477     0.150
     7.967   201.328     0.150
     8.043   116.016     0.150
     8.478   120.477     0.150
     8.487   122.777     0.150
     8.961   129.969     0.150
     9.157   133.797     0.150
     9.378   135.828     0.150
    10.261   148.676     0.150
    10.425   149.809     0.150
    10.716   153.398     0.150
    10.737   154.309     0.150
    10.824   153.695     0.150
    11.182   160.508     0.150
    11.345   162.898     0.150
    11.837   168.516     0.150
    12.017   170.938     0.150
    12.070   172.156     0.150
    12.365   175.426     0.150
    12.583   178.707     0.150
    12.614   180.816     0.150
    12.794   182.637     0.150
    13.144   185.945     0.150
    13.529   189.453     0.150
    13.564   190.277     0.150
    13.566   190.668     0.150
    13.657   191.066     0.150
    13.741   193.777     0.150
    13.909   194.777     0.150
    14.080   199.945     0.150
    14.167   199.836     0.150
    14.510   205.527     0.150
    15.445   219.219     0.150
    15.539   221.156     0.150
    18.012   251.559     0.150
    18.276   256.906     0.150
    18.276   256.605     0.150
    22.709   302.832     0.150
    25.261   326.918     0.150
    31.570   383.535     0.150
    31.570   383.531     0.150
    69.171   665.656     0.150
    69.175   665.656     0.150
    76.423   708.457     0.150
    76.423   708.887     0.150
    76.423   708.883     0.150
    76.423   708.695     0.150
    76.443   708.508     0.150
    76.486   708.816     0.150
     0.228     4.669     0.150
     0.228     8.339     0.150
     0.228     4.699     0.150
     0.228     8.089     0.150
     0.271     5.279     0.150
     0.271     9.779     0.150
     0.399     7.509     0.150
     0.399    13.119     0.150
     0.643    11.589     0.150
     0.797    13.909     0.150
     0.797    25.079     0.150
     1.000    17.369     0.150
     1.085    18.599     0.150
     1.085    32.809     0.150
     1.086    19.619     0.150
     1.929    30.579     0.150
     1.929    54.179     0.150
     2.835    42.554     0.150
     2.835    75.254     0.150
     2.835    84.779     0.150
     2.835    42.449     0.150
     3.618    52.779     0.150
     3.618    93.419     0.150
     3.918    57.019     0.150
     3.918   101.339     0.150
     4.119    60.979     0.150
     4.237    61.369     0.150
     5.136    77.759     0.150
     5.382   137.549     0.150
     5.656    83.569     0.150
     5.654    83.579     0.150
     5.654   149.079     0.150
     5.654   170.229     0.150
     5.654    85.239     0.150
     5.654   147.039     0.150
     5.757    84.639     0.150
     6.373    96.059     0.150
     6.826    99.739     0.150
     7.801   112.789     0.150
     7.801   198.749     0.150
     8.160   123.219     0.150
     8.311   120.819     0.150
     8.473   216.179     0.150
     8.661   126.899     0.150
     8.678   126.219     0.150
     9.006   132.849     0.150
     9.315   134.719     0.150
     9.315   235.759     0.150
     9.578   137.729     0.150
     9.578   242.279     0.150
     9.664   140.079     0.150
     9.664   241.479     0.150
     9.819   140.789     0.150
     9.819   246.189     0.150
    10.886   335.081     0.150
    13.472   188.812     0.150
    13.472   420.174     0.150
    13.897   195.907     0.150
    15.385   216.904     0.150
    17.587   243.333     0.150
    18.434   253.879     0.150
    31.745   382.904     0.150
    68.994   664.104     0.150
    76.242   707.204     0.150
     0.214     4.668     0.150
     0.214     8.035     0.150
     0.336     6.559     0.150
     0.336    11.227     0.150
     0.510     9.188     0.150
     0.510    15.656     0.150
     0.493     9.086     0.150
     0.493    15.598     0.150
     0.493    15.738     0.150
     1.292    22.398     0.150
     1.296    21.816     0.150
     1.296    38.828     0.150
     1.990    31.406     0.150
     1.990    34.855     0.150
     1.990    59.926     0.150
     2.584    39.195     0.150
     2.584    69.398     0.150
     2.584    77.273     0.150
     2.584    38.875     0.150
     2.584    46.926     0.150
     2.584    68.875     0.150
     2.584    77.047     0.150
     2.584    39.559     0.150
     2.584    70.367     0.150
     3.368    52.355     0.150
     3.368   102.227     0.150
     3.305    48.219     0.150
     3.305    85.277     0.150
     3.696    56.219     0.150
     3.613    52.559     0.150
     3.613    92.945     0.150
     3.803    56.168     0.150
     3.803   100.227     0.150
     3.929    57.016     0.150
     3.929   104.617     0.150
     4.016    58.527     0.150
     4.016   104.766     0.150
     4.302    63.918     0.150
     4.382    64.078     0.150
     4.508    66.035     0.150
     4.733    67.059     0.150
     4.952    74.566     0.150
     4.952   150.406     0.150
     5.026    74.285     0.150
     5.026   154.867     0.150
     5.016    73.906     0.150
     5.016   129.207     0.150
     5.083    73.746     0.150
     5.083   130.648     0.150
     5.347    79.035     0.150
     5.347   140.625     0.150
     5.371    79.496     0.150
     5.689    81.738     0.150
     5.702    84.355     0.150
     5.855    88.398     0.150
     5.855   154.273     0.150
     5.855   178.348     0.150
     5.855    88.188     0.150
     5.855    88.617     0.150
     5.769    84.355     0.150
     6.045   186.598     0.150
     6.045    88.258     0.150
     6.065    89.527     0.150
     6.104    89.527     0.150
     6.126    88.945     0.150
     6.282    89.578     0.150
     6.345    94.008     0.150
     6.457    95.785     0.150
     6.541    95.035     0.150
     6.541   206.027     0.150
     6.772    99.445     0.150
     6.962   100.277     0.150
     7.284   105.766     0.150
     7.284   226.828     0.150
     7.407   228.148     0.150
     7.655   113.406     0.150
     7.993   116.996     0.150
     8.080   116.688     0.150
     8.080   250.336     0.150
     8.080   116.496     0.150
     8.372   259.586     0.150
     8.503   124.016     0.150
     8.503   263.477     0.150
     8.464   127.336     0.150
     8.610   124.746     0.150
     8.610   273.516     0.150
     8.610   125.547     0.150
     8.610   123.098     0.150
     8.610   123.836     0.150
     8.899   130.656     0.150
     8.899   278.488     0.150
     8.857   129.328     0.150
     8.789   131.707     0.150
     8.885   129.488     0.150
     8.885   272.105     0.150
     8.960   131.648     0.150
     9.020   133.637     0.150
     9.245   133.977     0.150
     9.344   141.836     0.150
     9.562   136.496     0.150
     9.562   242.598     0.150
     9.629   137.918     0.150
     9.629   241.207     0.150
     9.629   138.676     0.150
     9.688   142.059     0.150
     9.799   142.578     0.150
     9.896   140.977     0.150
     9.896   248.098     0.150
     9.912   142.406     0.150
     9.980   143.105     0.150
     9.980   252.348     0.150
     9.980   145.477     0.150
    10.136   145.688     0.150
    10.136   256.719     0.150
    10.470   151.238     0.150
    10.614   326.090     0.150
    10.745   154.867     0.150
    12.561   180.266     0.150
    12.669   182.238     0.150
    12.721   181.219     0.150
    12.917   184.137     0.150
    13.549   190.094     0.150
    13.549   425.895     0.150
    13.549   190.277     0.150
    13.791   197.148     0.150
    14.211   203.348     0.150
    14.368   211.758     0.150
    14.647   209.059     0.150
    14.688   215.719     0.150
    15.641   221.445     0.150
    16.904   241.695     0.150
    17.266   240.746     0.150
    18.148   254.445     0.150
    18.148   256.457     0.150
    19.361   268.488     0.150
    22.628   301.445     0.150
    25.155   326.207     0.150
    26.648   339.848     0.150
    29.759   367.797     0.150
    31.434   382.098     0.150
    31.434   382.496     0.150
    32.549   559.566     0.150
    69.303   666.422     0.150
    76.552   709.723     0.150
    76.844   710.945     0.150
    87.107   763.996     0.150
    88.066   769.473     0.150
     0.474     8.551     0.150
     0.474    14.180     0.150
     0.659    11.141     0.150
     0.659    19.449     0.150
     0.660    11.910     0.150
     0.660    20.699     0.150
     0.696    12.418     0.150
     0.696    21.551     0.150
     0.734    13.379     0.150
     0.734    23.160     0.150
     0.937    16.609     0.150
     0.937    29.059     0.150
     0.978    18.262     0.150
     0.978    31.129     0.150
     1.210    22.000     0.150
     1.210    38.059     0.150
     1.318    22.930     0.150
     1.318    41.180     0.150
     1.301    23.418     0.150
     1.301    40.359     0.150
     1.446    25.039     0.150
     1.446    44.820     0.150
     1.681    28.980     0.150
     1.681    50.461     0.150
     1.802    30.820     0.150
     1.802    53.469     0.150
     2.088    34.281     0.150
     2.088    60.141     0.150
     2.349    66.219     0.150
     2.967    45.648     0.150
     2.967    81.191     0.150
     0.285     6.172     0.150
     0.690    12.586     0.150
     0.690    23.258     0.150
     0.759    13.930     0.150
     0.759    24.031     0.150
     0.794    14.141     0.150
     0.847    15.227     0.150
     0.847    26.070     0.150
     0.919    16.289     0.150
     0.919    28.391     0.150
     0.938    16.125     0.150
     0.977    17.102     0.150
     0.977    29.930     0.150
     0.989    17.852     0.150
     0.989    30.625     0.150
     1.151    20.266     0.150
     1.151    35.500     0.150
     1.301    22.898     0.150
     1.301    40.922     0.150
     1.482    25.828     0.150
     1.482    45.367     0.150
     1.600    26.922     0.150
     1.600    48.938     0.150
     1.767    29.562     0.150
     2.046    33.570     0.150
     2.046    61.750     0.150
     2.703    41.172     0.150
     2.703    82.250     0.150
     4.338   131.422     0.150
     4.611   141.641     0.150
     0.197     4.852     0.150
     0.197     7.691     0.150
     0.350     6.453     0.150
     0.350    10.980     0.150
     0.480     8.152     0.150
     0.813    14.641     0.150
     0.813    25.512     0.150
     0.898    16.320     0.150
     0.898    28.320     0.150
     1.087    19.859     0.150
     1.087    33.812     0.150
     1.145    20.230     0.150
     1.145    35.250     0.150
     1.277    21.691     0.150
     1.277    38.953     0.150
     1.428    24.082     0.150
     1.428    43.152     0.150
     1.483    25.031     0.150
     1.483    44.633     0.150
     1.611    26.691     0.150
     1.611    47.402     0.150
     1.857    55.973     0.150
     1.943    31.461     0.150
     1.943    55.723     0.150
     2.194    34.570     0.150
     2.194    60.973     0.150
     2.203    61.711     0.150
     3.145    47.742     0.150
     3.145    83.750     0.150
     3.209    50.570     0.150
     3.972    61.480     0.150
     3.972   124.633     0.150
     4.624    70.941     0.150
     0.314     6.203     0.150
     0.314    10.773     0.150
     0.271     5.414     0.150
     0.271     5.574     0.150
     0.271     9.453     0.150
     0.271     5.473     0.150
     0.271     9.352     0.150
     0.454     8.375     0.150
     0.454     8.562     0.150
     0.454    14.762     0.150
     0.663    12.352     0.150
     1.104    18.781     0.150
     1.104    33.164     0.150
     1.020    18.094     0.150
     1.020    31.992     0.150
     1.326    21.914     0.150
     1.329    22.434     0.150
     1.329    38.973     0.150
     1.698    27.324     0.150
     1.698    29.613     0.150
     1.698    51.383     0.150
     1.844    29.262     0.150
     1.844    32.344     0.150
     1.844    55.531     0.150
     1.983    31.383     0.150
     1.983    60.273     0.150
     2.196    34.422     0.150
     2.457    38.902     0.150
     2.457    71.391     0.150
     2.537    39.473     0.150
     2.537    39.289     0.150
     2.537    70.402     0.150
     2.638    79.852     0.150
     2.648    40.625     0.150
     2.648    80.352     0.150
     2.873    42.930     0.150
     2.873    75.727     0.150
     2.873    86.555     0.150
     2.873    75.492     0.150
     3.181    48.195     0.150
     3.181    87.133     0.150
     3.479    53.453     0.150
     3.479    93.820     0.150
     3.636    53.422     0.150
     3.636    93.395     0.150
     4.080    59.992     0.150
     4.080   104.723     0.150
     4.259    62.133     0.150
     4.259   108.402     0.150
     4.268    65.473     0.150
     4.268   130.582     0.150
     4.268    65.359     0.150
     4.268   131.215     0.150
     4.392    64.324     0.150
     4.634    69.184     0.150
     4.711    69.414     0.150
     4.711   122.684     0.150
     4.659    69.051     0.150
     4.659   123.375     0.150
     4.832    71.305     0.150
     5.047    75.473     0.150
     5.047   132.434     0.150
     5.047    75.914     0.150
     5.047   135.438     0.150
     5.173    77.344     0.150
     5.173   158.473     0.150
     5.188    77.805     0.150
     5.188   158.602     0.150
     5.408    77.664     0.150
     5.408   140.172     0.150
     5.426    80.633     0.150
     5.439   140.789     0.150
     5.694    86.453     0.150
     5.694   174.953     0.150
     5.694    83.793     0.150
     5.694    85.895     0.150
     5.694   174.344     0.150
     5.694    84.344     0.150
     5.694   171.953     0.150
     5.776    85.012     0.150
     6.026    89.203     0.150
     6.681    97.793     0.150
     6.693    96.875     0.150
     6.841    99.352     0.150
     7.190   101.824     0.150
     7.310   106.273     0.150
     7.279   106.773     0.150
     7.279   106.312     0.150
     7.279   106.473     0.150
     7.279   187.340     0.150
     7.430   108.973     0.150
     7.430   108.738     0.150
     8.040   116.203     0.150
     8.061   116.602     0.150
     8.057   119.082     0.150
     8.225   119.895     0.150
     8.300   121.273     0.150
     8.326   121.414     0.150
     8.326   120.824     0.150
     8.510   126.203     0.150
     8.614   124.250     0.150
     8.725   127.074     0.150
     8.857   126.512     0.150
     8.861   128.012     0.150
     9.311   134.852     0.150
     9.323   135.004     0.150
     9.323   134.129     0.150
     9.489   138.332     0.150
     9.722   140.934     0.150
     9.722   140.359     0.150
     9.899   141.852     0.150
    10.143   146.324     0.150
    10.153   146.684     0.150
    10.428   149.531     0.150
    10.801   153.895     0.150
    11.158   160.941     0.150
    11.680   166.914     0.150
    11.678   168.113     0.150
    11.882   170.352     0.150
    12.026   171.973     0.150
    12.171   172.664     0.150
    12.424   178.484     0.150
    12.539   178.531     0.150
    12.633   180.645     0.150
    13.524   189.430     0.150
    13.524   426.348     0.150
    13.550   192.145     0.150
    13.612   193.973     0.150
    13.903   197.234     0.150
    13.980   199.613     0.150
    14.006   198.574     0.150
    14.057   206.723     0.150
    14.088   200.793     0.150
    14.173   209.422     0.150
    14.264   200.594     0.150
    14.320   202.555     0.150
    14.382   203.293     0.150
    14.413   211.914     0.150
    14.590   208.934     0.150
    14.642   207.934     0.150
    14.788   206.531     0.150
    14.844   216.332     0.150
    14.999   212.652     0.150
    14.999   218.965     0.150
    15.197   215.484     0.150
    15.197   220.762     0.150
    15.287   215.023     0.150
    15.413   216.113     0.150
    15.531   219.922     0.150
    15.637   223.914     0.150
    16.157   229.562     0.150
    16.260   228.914     0.150
    16.769   235.312     0.150
    18.104   246.715     0.150
    22.169   294.281     0.150
    28.879   357.383     0.150
    28.883   357.293     0.150
    29.009   357.762     0.150
    31.039   377.594     0.150
    39.152   445.043     0.150
    40.085   453.602     0.150
    62.763   624.871     0.150
    69.003   664.992     0.150
    69.003   664.402     0.150
    69.003   665.094     0.150
    71.394   678.754     0.150
    73.394   691.715     0.150
    75.595   703.477     0.150
    76.250   707.645     0.150
    76.250   708.172     0.150
    76.250   707.844     0.150
    76.313   708.191     0.150
    77.621   716.543     0.150
    77.557   717.953     0.150
     0.238     4.871     0.150
     0.238     8.293     0.150
     0.644    11.023     0.150
     0.644    19.461     0.150
     1.005    18.090     0.150
     1.005    31.621     0.150
     1.093    19.500     0.150
     1.093    34.062     0.150
     1.091    19.562     0.150
     1.091    33.602     0.150
     1.249    21.820     0.150
     1.249    38.801     0.150
     1.529    25.621     0.150
     1.529    45.590     0.150
     1.529    47.633     0.150
     1.682    28.102     0.150
     1.682    51.070     0.150
     1.682    28.203     0.150
     1.682    51.293     0.150
     1.907    31.121     0.150
     1.907    58.543     0.150
     1.962    31.242     0.150
     1.962    60.570     0.150
     1.976    61.691     0.150
     2.013    32.242     0.150
     2.185    66.543     0.150
     2.397    38.180     0.150
     2.397    73.820     0.150
     2.905    53.281     0.150
     2.905    89.180     0.150
     3.103    47.473     0.150
     3.103    94.402     0.150
     3.701    57.633     0.150
     3.701   115.621     0.150
     4.334   134.953     0.150
     4.490    80.512     0.150
     4.490   138.461     0.150
     0.225     4.195     0.150
     0.334     5.570     0.150
     0.514     8.648     0.150
     0.514    14.938     0.150
     0.735    12.891     0.150
     0.735    22.555     0.150
     1.012    18.227     0.150
     1.125    20.367     0.150
     1.125    36.406     0.150
     1.312    23.945     0.150
     1.312    41.719     0.150
     1.412    25.234     0.150
     1.412    43.484     0.150
     1.412    44.000     0.150
     1.412    25.266     0.150
     1.436    24.336     0.150
     1.436    45.758     0.150
     1.466    26.266     0.150
     1.466    46.117     0.150
     1.943    31.961     0.150
     2.227    37.586     0.150
     2.227    63.500     0.150
     2.213    36.578     0.150
     2.213    63.211     0.150
     2.406    43.461     0.150
     2.491    43.688     0.150
     2.491    69.758     0.150
     2.496    44.008     0.150
     3.286    52.508     0.150
     3.286    91.344     0.150
     0.242     5.257     0.150
     0.242     8.297     0.150
     0.242     5.207     0.150
     0.242     8.438     0.150
     0.242     5.268     0.150
     0.242     8.499     0.150
     0.422     8.107     0.150
     0.422    13.417     0.150
     0.655    12.138     0.150
     0.655    21.257     0.150
     0.655    12.138     0.150
     0.655    20.417     0.150
     0.745    13.697     0.150
     0.745    23.257     0.150
     1.003    17.357     0.150
     1.003    30.917     0.150
     1.100    19.987     0.150
     1.100    35.087     0.150
     1.294    21.558     0.150
     1.811    29.047     0.150
     1.811    54.537     0.150
     1.811    28.877     0.150
     1.811    31.268     0.150
     1.811    54.098     0.150
     2.121    33.558     0.150
     2.121    36.237     0.150
     2.121    63.327     0.150
     2.505    38.797     0.150
     2.505    74.978     0.150
     2.430    38.407     0.150
     2.430    72.917     0.150
     2.430    38.237     0.150
     2.606    45.487     0.150
     2.518    39.127     0.150
     2.615    40.157     0.150
     2.615    45.447     0.150
     2.854    42.947     0.150
     2.854    42.524     0.150
     2.854    75.824     0.150
     2.854    85.066     0.150
     2.854    42.797     0.150
     2.854    75.357     0.150
     2.854    86.457     0.150
     3.162    48.058     0.150
     3.456    53.257     0.150
     3.456    52.947     0.150
     3.456    91.567     0.150
     3.630    52.688     0.150
     3.931    56.268     0.150
     3.931   101.327     0.150
     4.072    59.308     0.150
     4.072   106.207     0.150
     4.250    61.487     0.150
     4.250   110.487     0.150
     4.239    65.547     0.150
     4.381    63.257     0.150
     4.702    69.377     0.150
     4.644    69.237     0.150
     5.021    76.177     0.150
     5.021    76.037     0.150
     5.021   132.518     0.150
     5.158    78.527     0.150
     5.158   155.787     0.150
     5.157   156.617     0.150
     5.397   139.447     0.150
     5.407    79.987     0.150
     5.407    78.207     0.150
     5.667    85.730     0.150
     5.667   151.313     0.150
     5.667    85.427     0.150
     6.004    89.497     0.150
     6.501    96.657     0.150
     6.501    96.367     0.150
     6.501   199.827     0.150
     6.661    98.417     0.150
     6.677    98.567     0.150
     6.827    99.827     0.150
     7.276   106.007     0.150
     7.257   106.907     0.150
     7.257   106.558     0.150
     7.806   113.717     0.150
     7.806   113.007     0.150
     8.204   119.217     0.150
     8.292   120.547     0.150
     9.104   131.197     0.150
     9.242   133.577     0.150
     9.312   135.067     0.150
    10.904   335.299     0.150
    13.491   189.632     0.150
    14.365   212.457     0.150
    15.336   221.537     0.150
    15.392   217.282     0.150
    15.392   483.389     0.150
    15.593   223.107     0.150
    16.222   232.357     0.150
    16.359   234.607     0.150
    16.763   237.077     0.150
    16.787   238.757     0.150
    18.450   258.207     0.150
    20.445   278.938     0.150
    20.768   283.567     0.150
    22.813   302.534     0.150
    26.502   338.757     0.150
    30.061   369.947     0.150
    31.757   382.686     0.150
    57.087   585.907     0.150
    68.993   663.968     0.150
    72.638   685.991     0.150
    73.489   691.694     0.150
    76.240   708.007     0.150
    77.589   714.666     0.150
     0.382     7.188     0.150
     0.518     9.633     0.150
     0.518    16.961     0.150
     0.625    11.039     0.150
     0.625    19.312     0.150
     0.696    12.953     0.150
     0.696    21.930     0.150
     0.835    14.703     0.150
     0.835    25.789     0.150
     1.017    18.852     0.150
     1.017    32.422     0.150
     1.033    19.109     0.150
     1.033    32.992     0.150
     1.408    24.812     0.150
     1.408    43.242     0.150
     1.826    30.227     0.150
     1.826    53.547     0.150
     1.940    32.656     0.150
     1.940    58.289     0.150
     2.380    38.461     0.150
     2.380    68.180     0.150
     2.887    45.812     0.150
     2.887    82.078     0.150
     3.072    49.578     0.150
     3.675    56.820     0.150
     3.665   101.227     0.150
     4.383   119.031     0.150
     4.383   135.820     0.150
     4.486   137.891     0.150
     5.122   159.391     0.150
     0.201     4.561     0.150
     0.201     8.071     0.150
     0.389     7.491     0.150
     0.389    13.241     0.150
     0.466     8.851     0.150
     0.466    15.601     0.150
     0.656    12.131     0.150
     0.656    21.331     0.150
     0.775    14.001     0.150
     0.775    24.491     0.150
     0.893    15.741     0.150
     0.893    27.631     0.150
     1.218    20.521     0.150
     1.218    37.480     0.150
     1.327    22.571     0.150
     1.327    40.441     0.150
     1.831    28.801     0.150
     1.831    55.881     0.150
     1.937    31.111     0.150
     1.937    59.121     0.150
     2.178    34.081     0.150
     2.178    65.980     0.150
     2.576    39.581     0.150
     2.576    68.411     0.150
     2.576    78.241     0.150
     2.634    40.591     0.150
     2.634    45.041     0.150
     2.634    79.951     0.150
     2.641    40.381     0.150
     2.641    80.831     0.150
     2.952    44.086     0.150
     2.952    79.236     0.150
     2.952    79.071     0.150
     2.952    90.261     0.150
     3.256    49.151     0.150
     3.256   100.011     0.150
     3.361    50.991     0.150
     3.361    89.371     0.150
     3.361   105.371     0.150
     3.750    54.791     0.150
     4.049    59.061     0.150
     4.049   104.391     0.150
     4.169    62.131     0.150
     4.169   128.091     0.150
     4.192    62.311     0.150
     4.192   107.061     0.150
     4.821    70.251     0.150
     4.935    71.871     0.150
     4.935    71.791     0.150
     4.936    73.241     0.150
     5.195    76.861     0.150
     5.332    77.931     0.150
     5.512    80.321     0.150
     5.648    82.841     0.150
     5.908    85.831     0.150
     6.413    93.081     0.150
     6.503    94.461     0.150
     6.556    94.361     0.150
     6.711    97.801     0.150
     6.872    99.801     0.150
     6.920    99.901     0.150
     7.161   102.761     0.150
     7.155   103.381     0.150
     7.158   103.921     0.150
     7.265   104.771     0.150
     7.697   111.211     0.150
     7.932   114.441     0.150
     8.103   116.471     0.150
     8.169   118.251     0.150
     8.196   118.291     0.150
     8.732   126.301     0.150
     8.724   127.181     0.150
     8.982   129.371     0.150
     9.119   130.101     0.150
     9.198   132.611     0.150
     9.189   132.841     0.150
    11.550   163.230     0.150
    12.327   176.071     0.150
    12.799   181.381     0.150
    13.460   187.886     0.150
    13.460   423.841     0.150
    13.499   188.501     0.150
    13.499   190.561     0.150
    13.483   190.591     0.150
    13.773   193.861     0.150
    13.916   196.401     0.150
    14.662   207.941     0.150
    14.992   213.871     0.150
    15.291   214.986     0.150
    15.564   224.281     0.150
    15.744   223.161     0.150
    15.847   227.441     0.150
    15.915   226.171     0.150
    16.296   229.941     0.150
    17.050   235.381     0.150
    17.114   235.616     0.150
    17.371   245.891     0.150
    17.499   246.261     0.150
    17.719   243.953     0.150
    17.807   251.531     0.150
    18.560   256.306     0.150
    19.266   267.230     0.150
    21.801   292.771     0.150
    22.151   295.861     0.150
    31.877   384.949     0.150
    73.370   691.061     0.150
    76.119   706.911     0.150
     0.198     4.309     0.150
     0.198     4.449     0.150
     0.198     4.518     0.150
     0.198     8.568     0.150
     0.385     7.369     0.150
     0.385    12.928     0.150
     0.461     8.998     0.150
     0.461     8.758     0.150
     0.461    15.889     0.150
     0.655    12.008     0.150
     0.655    20.799     0.150
     0.893    15.598     0.150
     0.893    27.369     0.150
     0.772    13.898     0.150
     0.772    24.488     0.150
     1.214    21.088     0.150
     1.214    20.238     0.150
     1.214    35.709     0.150
     1.322    21.879     0.150
     1.322    38.848     0.150
     1.827    29.059     0.150
     1.827    55.588     0.150
     1.933    30.598     0.150
     1.933    58.979     0.150
     2.173    33.678     0.150
     2.173    66.049     0.150
     2.352    37.539     0.150
     2.412    37.539     0.150
     2.571    39.219     0.150
     2.571    67.438     0.150
     2.571    77.979     0.150
     2.630    39.549     0.150
     2.630    79.588     0.150
     2.637    40.039     0.150
     2.637    80.459     0.150
     3.057    46.379     0.150
     2.948    45.268     0.150
     2.948    43.938     0.150
     2.948    77.129     0.150
     2.948    90.188     0.150
     3.254    51.357     0.150
     3.361    51.719     0.150
     3.361    86.908     0.150
     3.747    54.379     0.150
     4.168    63.848     0.150
     4.045    58.668     0.150
     4.045   103.898     0.150
     4.263    62.629     0.150
     4.188    60.879     0.150
     4.188   107.428     0.150
     4.531    67.758     0.150
     4.935    75.139     0.150
     4.817    70.029     0.150
     4.931    71.469     0.150
     4.931    71.758     0.150
     5.190    75.268     0.150
     5.190   131.988     0.150
     5.190   160.369     0.150
     5.289    77.949     0.150
     5.328    76.959     0.150
     5.328   133.838     0.150
     5.649    82.719     0.150
     5.508    82.449     0.150
     5.508    79.078     0.150
     5.508   138.748     0.150
     5.907    88.049     0.150
     5.907    86.168     0.150
     6.145    89.199     0.150
     6.190    90.078     0.150
     6.413    95.059     0.150
     6.413    93.809     0.150
     6.557    95.518     0.150
     6.557    94.729     0.150
     6.499    94.938     0.150
     6.546    95.398     0.150
     6.709    96.648     0.150
     6.916   100.898     0.150
     6.868   100.607     0.150
     7.137   104.299     0.150
     7.157   104.869     0.150
     7.157   103.848     0.150
     7.157   106.539     0.150
     7.262   105.318     0.150
     7.698   111.848     0.150
     7.698   111.438     0.150
     7.928   114.238     0.150
     7.933   114.148     0.150
     8.103   117.838     0.150
     8.171   117.729     0.150
     8.197   118.879     0.150
     8.225   120.279     0.150
     8.546   122.389     0.150
     8.596   122.879     0.150
     8.706   128.299     0.150
     8.725   125.998     0.150
     8.733   126.168     0.150
     8.733   125.709     0.150
     8.984   129.738     0.150
     8.984   128.758     0.150
     9.121   129.529     0.150
     9.191   132.279     0.150
     9.195   131.658     0.150
     9.198   132.148     0.150
     9.360   135.738     0.150
     9.453   135.299     0.150
     9.539   137.639     0.150
     9.398   135.238     0.150
     9.461   138.857     0.150
     9.461   134.449     0.150
     9.695   139.018     0.150
     9.771   138.658     0.150
     9.674   139.959     0.150
     9.674   138.168     0.150
     9.879   140.469     0.150
    10.015   143.398     0.150
    10.015   140.607     0.150
    10.026   144.938     0.150
    10.458   149.178     0.150
    10.338   150.938     0.150
    10.674   150.549     0.150
    10.558   153.838     0.150
    10.574   152.688     0.150
    10.881   159.357     0.150
    11.085   156.578     0.150
    11.094   158.658     0.150
    11.004   156.713     0.150
    11.004   342.438     0.150
    11.004   160.607     0.150
    11.551   165.459     0.150
    11.551   163.869     0.150
    11.757   167.799     0.150
    12.104   173.119     0.150
    12.208   172.088     0.150
    12.208   303.613     0.150
    12.301   175.039     0.150
    12.327   176.479     0.150
    12.327   175.469     0.150
    12.307   176.699     0.150
    12.636   179.969     0.150
    12.799   182.598     0.150
    12.832   183.508     0.150
    12.935   184.588     0.150
    13.295   188.229     0.150
    13.457   188.344     0.150
    13.457   334.549     0.150
    13.457   419.443     0.150
    13.496   189.408     0.150
    13.496   191.459     0.150
    13.496   188.578     0.150
    13.496   188.688     0.150
    13.593   195.938     0.150
    13.775   192.818     0.150
    13.775   433.820     0.150
    13.855   197.107     0.150
    13.905   196.268     0.150
    13.916   197.488     0.150
    13.916   194.379     0.150
    14.197   201.857     0.150
    14.425   205.158     0.150
    14.425   205.379     0.150
    14.662   208.379     0.150
    14.880   210.678     0.150
    14.800   217.488     0.150
    14.993   213.588     0.150
    14.993   209.369     0.150
    15.291   214.219     0.150
    15.291   481.094     0.150
    15.291   216.168     0.150
    15.291   216.629     0.150
    15.212   222.148     0.150
    15.508   222.588     0.150
    15.565   220.248     0.150
    15.654   221.279     0.150
    15.668   220.828     0.150
    15.915   220.318     0.150
    16.092   227.098     0.150
    16.103   229.008     0.150
    16.241   231.729     0.150
    16.298   228.418     0.150
    16.552   231.268     0.150
    16.556   234.857     0.150
    16.542   234.559     0.150
    17.064   241.578     0.150
    17.048   236.488     0.150
    16.939   240.188     0.150
    17.111   238.744     0.150
    17.241   243.818     0.150
    17.372   239.068     0.150
    17.423   245.068     0.150
    17.716   245.543     0.150
    18.125   252.408     0.150
    18.125   247.709     0.150
    18.556   256.268     0.150
    20.561   279.729     0.150
    20.860   284.209     0.150
    21.093   286.508     0.150
    21.669   289.969     0.150
    21.797   292.068     0.150
    22.042   295.459     0.150
    22.147   295.719     0.150
    22.169   297.629     0.150
    22.256   298.688     0.150
    22.261   298.619     0.150
    22.870   302.543     0.150
    24.373   318.678     0.150
    31.873   385.543     0.150
    62.663   623.719     0.150
    62.663   623.682     0.150
    63.974   632.426     0.150
    68.874   663.818     0.150
    72.524   686.018     0.150
    73.264   691.098     0.150
    73.371   691.094     0.150
    74.540   699.217     0.150
    76.121   707.119     0.150
    77.554   715.086     0.150
    88.490   771.193     0.150
     0.219     4.969     0.150
     0.219     8.492     0.150
     0.219     4.602     0.150
     0.219     4.859     0.150
     0.219     8.445     0.150
     0.219     4.859     0.150
     0.219     8.336     0.150
     0.394     7.641     0.150
     0.394    13.500     0.150
     0.479     9.211     0.150
     0.479    16.070     0.150
     0.479    16.172     0.150
     0.774    14.219     0.150
     0.774    24.984     0.150
     0.906    16.062     0.150
     0.906    28.734     0.150
     0.906    16.305     0.150
     0.906    28.391     0.150
     1.217    20.266     0.150
     1.217    36.742     0.150
     1.216    21.055     0.150
     1.216    36.680     0.150
     1.341    22.570     0.150
     1.341    41.898     0.150
     1.341    22.172     0.150
     1.341    40.664     0.150
     1.847    29.523     0.150
     1.847    56.055     0.150
     1.954    31.523     0.150
     1.954    59.539     0.150
     2.190    34.062     0.150
     2.190    65.594     0.150
     2.426    38.289     0.150
     2.426    69.789     0.150
     2.426    37.836     0.150
     2.587    39.945     0.150
     2.587    77.203     0.150
     2.649    79.266     0.150
     2.657    40.922     0.150
     2.958    44.445     0.150
     2.958    51.617     0.150
     2.958    89.414     0.150
     2.958    44.289     0.150
     2.958    89.016     0.150
     3.071    46.641     0.150
     3.377    51.898     0.150
     3.377    51.633     0.150
     3.377    90.281     0.150
     3.749    54.641     0.150
     3.749    54.844     0.150
     3.749    97.305     0.150
     4.187    64.070     0.150
     4.187   128.266     0.150
     4.273    62.391     0.150
     4.273    62.242     0.150
     4.250    62.391     0.150
     4.250   109.195     0.150
     4.543    67.320     0.150
     4.622    68.016     0.150
     4.622   117.953     0.150
     4.821    69.984     0.150
     4.953    73.414     0.150
     4.953   127.469     0.150
     4.937    71.562     0.150
     4.937   125.719     0.150
     4.944    71.898     0.150
     4.944   126.141     0.150
     5.179    75.359     0.150
     5.209   159.398     0.150
     5.298    76.875     0.150
     5.312    78.789     0.150
     5.331    76.992     0.150
     5.513    80.148     0.150
     5.513    79.781     0.150
     5.513   139.969     0.150
     5.607    85.242     0.150
     5.607   175.320     0.150
     5.607    81.648     0.150
     5.607   172.930     0.150
     5.923    87.625     0.150
     5.923    87.023     0.150
     5.923   184.531     0.150
     6.430    95.500     0.150
     6.430    92.992     0.150
     6.430   163.281     0.150
     6.503    93.523     0.150
     6.571    95.445     0.150
     6.571    95.250     0.150
     6.577    95.625     0.150
     6.552    94.148     0.150
     6.722    97.742     0.150
     6.862   212.734     0.150
     6.937   100.711     0.150
     6.937   215.320     0.150
     7.146   102.891     0.150
     7.146   103.625     0.150
     7.172   104.523     0.150
     7.172   103.180     0.150
     7.172   221.875     0.150
     7.167   103.562     0.150
     7.167   102.273     0.150
     7.167   222.539     0.150
     7.283   225.836     0.150
     7.452   106.836     0.150
     7.452   186.219     0.150
     7.582   109.773     0.150
     7.711   111.812     0.150
     7.711   111.242     0.150
     7.797   111.516     0.150
     7.936   113.844     0.150
     7.936   199.344     0.150
     7.945   114.844     0.150
     7.945   114.539     0.150
     8.052   116.469     0.150
     8.117   117.164     0.150
     8.178   117.609     0.150
     8.178   117.734     0.150
     8.178   201.305     0.150
     8.159   117.664     0.150
     8.207   118.812     0.150
     8.354   120.141     0.150
     8.556   123.555     0.150
     8.608   122.742     0.150
     8.608   123.633     0.150
     8.733   124.812     0.150
     8.733   216.930     0.150
     8.744   125.141     0.150
     8.744   215.195     0.150
     8.828   126.055     0.150
     8.899   128.211     0.150
     8.991   128.836     0.150
     8.991   129.016     0.150
     8.991   223.312     0.150
     9.127   130.891     0.150
     9.127   130.250     0.150
     9.127   224.531     0.150
     9.212   133.000     0.150
     9.212   131.789     0.150
     9.367   134.219     0.150
     9.401   133.234     0.150
     9.459   134.773     0.150
     9.459   235.266     0.150
     9.544   136.234     0.150
     9.544   236.641     0.150
     9.671   138.242     0.150
     9.700   138.375     0.150
     9.700   238.695     0.150
     9.770   139.344     0.150
     9.783   139.742     0.150
     9.783   138.789     0.150
     9.889   140.312     0.150
    10.021   142.445     0.150
    10.469   149.586     0.150
    10.469   149.273     0.150
    11.036   156.320     0.150
    11.097   157.445     0.150
    11.103   157.680     0.150
    11.698   165.953     0.150
    11.761   166.844     0.150
    11.906   168.703     0.150
    12.113   172.086     0.150
    12.203   171.648     0.150
    12.203   172.250     0.150
    12.340   176.555     0.150
    12.340   175.141     0.150
    12.813   181.180     0.150
    12.833   181.250     0.150
    12.947   183.445     0.150
    13.478   190.516     0.150
    13.478   190.109     0.150
    13.517   189.711     0.150
    13.782   194.594     0.150
    13.931   196.375     0.150
    14.072   198.266     0.150
    14.138   200.086     0.150
    14.199   199.742     0.150
    14.469   203.172     0.150
    14.676   206.398     0.150
    14.881   209.602     0.150
    15.005   211.703     0.150
    15.306   216.344     0.150
    15.306   215.984     0.150
    15.434   216.391     0.150
    15.482   219.445     0.150
    15.518   219.070     0.150
    15.657   219.789     0.150
    15.668   219.539     0.150
    15.675   220.242     0.150
    15.757   222.312     0.150
    15.875   223.344     0.150
    15.928   224.773     0.150
    16.138   225.719     0.150
    16.244   227.500     0.150
    16.647   232.984     0.150
    16.689   233.930     0.150
    17.073   238.031     0.150
    17.413   241.539     0.150
    17.819   247.203     0.150
    17.944   248.961     0.150
    18.038   249.359     0.150
    18.563   257.289     0.150
    18.563   255.211     0.150
    18.657   257.031     0.150
    20.871   281.711     0.150
    22.168   295.375     0.150
    22.887   304.570     0.150
    22.887   302.570     0.150
    31.876   385.867     0.150
    31.876   384.320     0.150
    68.883   663.695     0.150
    68.883   663.305     0.150
    73.380   690.945     0.150
    76.128   707.195     0.150
    76.192   707.414     0.150
    77.575   715.969     0.150
     0.303     6.621     0.150
     0.465     8.699     0.150
     0.465    15.520     0.150
     0.711    12.949     0.150
     0.711    23.160     0.150
     0.712    12.570     0.150
     0.712    21.961     0.150
     0.712    22.121     0.150
     0.712    13.590     0.150
     0.712    21.258     0.150
     0.712    13.098     0.150
     0.712    20.988     0.150
     0.737    13.258     0.150
     0.861    15.340     0.150
     1.045    18.988     0.150
     1.045    32.438     0.150
     1.045    32.969     0.150
     1.188    21.320     0.150
     1.188    37.281     0.150
     1.508    25.938     0.150
     1.508    46.609     0.150
     1.508    25.801     0.150
     1.508    45.781     0.150
     1.548    26.148     0.150
     1.548    45.211     0.150
     1.571    27.090     0.150
     1.571    47.879     0.150
     1.610    26.961     0.150
     2.489    39.820     0.150
     2.489    75.910     0.150
     2.704    42.641     0.150
     2.704    41.789     0.150
     2.704    83.801     0.150
     3.834    56.789     0.150
     3.834    57.508     0.150
     3.834   102.578     0.150
     3.883    59.098     0.150
     4.047    60.758     0.150
     4.047   110.590     0.150
     4.048    61.238     0.150
     4.238    63.250     0.150
     4.366    65.180     0.150
     4.366   118.211     0.150
     4.438    66.840     0.150
     4.438   135.648     0.150
     4.684    70.730     0.150
     4.684   125.461     0.150
     4.784    71.938     0.150
     4.784    73.469     0.150
     4.784   146.891     0.150
     4.784    72.508     0.150
     4.819    72.570     0.150
     4.835    73.039     0.150
     4.910    73.480     0.150
     4.987    75.238     0.150
     5.133    76.500     0.150
     5.133    77.781     0.150
     5.133   156.500     0.150
     5.433    81.109     0.150
     5.433   164.680     0.150
     6.046    90.320     0.150
     6.046    89.949     0.150
     6.198    89.699     0.150
     6.252    92.719     0.150
     6.252   190.531     0.150
     6.365    94.738     0.150
     6.365    94.188     0.150
     6.466   195.461     0.150
     6.568    98.121     0.150
     6.752   210.469     0.150
     6.835   101.340     0.150
     6.835   101.070     0.150
     6.872   101.418     0.150
     7.123   105.230     0.150
     7.123   104.848     0.150
     7.263   107.969     0.150
     7.583   110.590     0.150
     7.623   113.789     0.150
     7.736   113.020     0.150
     7.993   116.680     0.150
     8.037   119.949     0.150
     8.383   124.828     0.150
     8.396   121.801     0.150
     8.407   122.328     0.150
     8.419   121.891     0.150
     8.456   126.039     0.150
     8.505   123.328     0.150
     8.520   122.258     0.150
     8.535   124.680     0.150
     8.535   124.828     0.150
     8.571   126.500     0.150
     8.668   125.738     0.150
     8.683   129.020     0.150
     8.839   128.258     0.150
     8.839   130.879     0.150
     8.942   129.660     0.150
     8.942   129.500     0.150
     9.029   131.219     0.150
     9.055   131.031     0.150
     9.222   133.289     0.150
     9.278   133.828     0.150
     9.286   134.469     0.150
     9.294   134.559     0.150
     9.466   136.949     0.150
     9.497   137.680     0.150
     9.738   140.199     0.150
    10.006   143.469     0.150
    10.044   144.609     0.150
    10.141   146.648     0.150
    10.496   150.188     0.150
    10.721   156.227     0.150
    10.721   154.090     0.150
    11.053   158.828     0.150
    11.158   159.668     0.150
    11.571   164.500     0.150
    11.688   166.129     0.150
    11.706   166.559     0.150
    11.709   167.480     0.150
    12.015   172.988     0.150
    12.041   173.410     0.150
    12.067   172.250     0.150
    12.130   171.840     0.150
    12.138   172.531     0.150
    12.153   172.141     0.150
    12.302   175.148     0.150
    12.333   174.371     0.150
    12.382   176.238     0.150
    12.389   176.328     0.150
    12.389   175.129     0.150
    12.551   176.859     0.150
    12.551   392.797     0.150
    12.589   179.090     0.150
    12.739   179.789     0.150
    12.857   183.711     0.150
    12.890   182.898     0.150
    13.031   184.629     0.150
    13.106   186.879     0.150
    13.177   186.430     0.150
    13.293   189.500     0.150
    13.317   189.109     0.150
    13.434   191.008     0.150
    13.434   190.789     0.150
    13.467   196.477     0.150
    13.612   194.289     0.150
    13.641   193.488     0.150
    13.942   196.969     0.150
    13.952   196.980     0.150
    14.100   199.668     0.150
    14.124   199.328     0.150
    14.179   199.438     0.150
    14.284   201.250     0.150
    14.492   205.070     0.150
    14.511   205.578     0.150
    14.621   207.461     0.150
    14.621   456.859     0.150
    14.621   208.238     0.150
    14.737   209.031     0.150
    14.790   211.570     0.150
    14.805   211.688     0.150
    14.969   213.309     0.150
    14.986   212.500     0.150
    15.016   214.859     0.150
    15.074   212.980     0.150
    15.186   215.309     0.150
    15.207   215.051     0.150
    15.294   217.828     0.150
    15.290   216.320     0.150
    15.329   219.059     0.150
    15.465   220.121     0.150
    15.563   219.871     0.150
    15.612   221.070     0.150
    15.744   222.801     0.150
    15.858   224.020     0.150
    15.933   227.520     0.150
    16.052   230.598     0.150
    16.111   230.121     0.150
    16.183   229.879     0.150
    16.272   231.910     0.150
    16.289   232.219     0.150
    16.405   230.418     0.150
    16.640   235.598     0.150
    16.679   235.711     0.150
    16.823   238.688     0.150
    16.822   238.379     0.150
    16.841   237.199     0.150
    16.954   240.848     0.150
    17.068   239.871     0.150
    17.080   240.480     0.150
    17.097   241.590     0.150
    17.102   241.398     0.150
    17.119   242.301     0.150
    17.194   243.438     0.150
    17.288   243.770     0.150
    17.365   242.789     0.150
    17.571   247.258     0.150
    17.646   247.098     0.150
    17.787   249.031     0.150
    17.894   253.309     0.150
    17.894   252.129     0.150
    17.984   251.188     0.150
    18.023   252.348     0.150
    18.106   252.059     0.150
    18.152   253.430     0.150
    18.277   254.391     0.150
    18.332   255.738     0.150
    18.331   255.168     0.150
    18.332   259.160     0.150
    18.332   255.930     0.150
    18.361   255.238     0.150
    18.420   256.539     0.150
    18.599   259.391     0.150
    18.951   262.180     0.150
    19.186   265.910     0.150
    19.360   268.578     0.150
    19.776   272.180     0.150
    19.785   271.570     0.150
    19.888   273.000     0.150
    19.947   273.551     0.150
    20.452   280.031     0.150
    20.585   281.410     0.150
    20.893   283.539     0.150
    20.921   283.598     0.150
    21.295   287.660     0.150
    21.837   293.070     0.150
    21.874   293.598     0.150
    21.987   294.508     0.150
    21.991   294.469     0.150
    22.018   295.438     0.150
    22.175   297.258     0.150
    22.515   300.090     0.150
    23.043   306.121     0.150
    25.577   330.039     0.150
    30.918   377.980     0.150
    31.829   388.574     0.150
    33.366   398.461     0.150
    53.900   564.383     0.150
    53.900   563.699     0.150
    56.958   586.211     0.150
    66.295   649.770     0.150
    67.454   656.723     0.150
    68.462   662.812     0.150
    68.462   662.359     0.150
    71.999   685.062     0.150
    72.816   688.871     0.150
    72.922   689.984     0.150
    73.677   694.336     0.150
    74.688   700.285     0.150
    75.725   706.609     0.150
    75.725   706.188     0.150
    75.785   706.281     0.150
    76.648   711.000     0.150
    76.884   712.520     0.150
    82.778   745.410     0.150
    86.036   761.758     0.150
   143.569  1172.680     0.150
     0.138     3.227     0.150
     0.138     5.867     0.150
     0.320     6.105     0.150
     0.320    11.086     0.150
     0.298     6.098     0.150
     0.298    10.996     0.150
     0.642    11.598     0.150
     0.753    13.648     0.150
     0.753    24.137     0.150
     0.929    16.566     0.150
     1.126    19.566     0.150
     1.126    34.496     0.150
     1.334    41.605     0.150
     1.374    23.977     0.150
     1.374    41.488     0.150
     1.723    28.648     0.150
     1.723    52.008     0.150
     1.965    58.316     0.150
     2.029    32.406     0.150
     3.095    46.625     0.150
     4.157    61.195     0.150
     4.394    66.328     0.150
     4.394   116.738     0.150
     4.683    69.598     0.150
     4.798   147.926     0.150
     4.826   146.277     0.150
     5.017    74.188     0.150
     0.284     6.123     0.150
     0.284     9.662     0.150
     0.568    10.611     0.150
     0.568    18.303     0.150
     0.691    12.752     0.150
     0.691    22.002     0.150
     0.765    13.902     0.150
     0.765    24.012     0.150
     0.765    23.623     0.150
     0.796    13.982     0.150
     0.796    24.973     0.150
     0.796    14.092     0.150
     0.853    15.111     0.150
     0.853    26.422     0.150
     0.853    26.053     0.150
     0.915    16.451     0.150
     0.915    29.342     0.150
     0.915    16.771     0.150
     0.915    28.963     0.150
     0.995    17.723     0.150
     0.995    31.031     0.150
     1.306    23.012     0.150
     1.306    40.951     0.150
     1.455    25.803     0.150
     1.455    44.723     0.150
     1.481    25.463     0.150
     1.481    45.062     0.150
     1.565    26.812     0.150
     1.565    47.172     0.150
     1.605    27.932     0.150
     1.605    48.982     0.150
     1.605    27.252     0.150
     1.605    28.553     0.150
     1.605    48.793     0.150
     1.824    32.582     0.150
     1.824    55.252     0.150
     2.408    38.902     0.150
     2.408    68.742     0.150
     2.584    41.883     0.150
     2.584    41.643     0.150
     2.584    72.652     0.150
     2.704    42.271     0.150
     2.704    48.383     0.150
     2.704    74.473     0.150
     2.704    82.873     0.150
     3.827    58.652     0.150
     3.880    58.062     0.150
     3.880    57.941     0.150
     3.880   103.133     0.150
     3.975    60.852     0.150
     4.078    60.611     0.150
     4.078    60.842     0.150
     4.078   108.803     0.150
     4.275    63.502     0.150
     4.275   113.361     0.150
     4.335    65.303     0.150
     4.413    66.182     0.150
     4.413   117.873     0.150
     4.657    71.402     0.150
     4.657    70.793     0.150
     4.657   125.021     0.150
     4.677    69.652     0.150
     4.722    70.861     0.150
     4.848    72.402     0.150
     4.848   127.723     0.150
     4.876    73.191     0.150
     4.852    73.691     0.150
     5.022    75.322     0.150
     5.022   131.592     0.150
     5.361    80.111     0.150
     5.448    81.172     0.150
     5.845    87.512     0.150
     5.917    88.412     0.150
     5.917   153.531     0.150
     6.104    90.293     0.150
     6.104   158.223     0.150
     6.178    91.723     0.150
     6.229    92.352     0.150
     6.229    92.072     0.150
     6.544    96.562     0.150
     6.706    99.432     0.150
     6.807   100.502     0.150
     6.807   100.182     0.150
     6.977   102.043     0.150
     7.029   104.043     0.150
     7.197   105.021     0.150
     7.660   112.031     0.150
     7.660   112.213     0.150
     8.307   120.332     0.150
     8.428   123.592     0.150
     8.618   127.332     0.150
     8.771   128.732     0.150
     8.771   129.303     0.150
     8.790   129.293     0.150
     9.020   133.941     0.150
     9.487   138.133     0.150
     9.557   138.832     0.150
     9.703   140.803     0.150
    10.078   145.322     0.150
    10.969   157.592     0.150
    10.969   158.322     0.150
    11.400   164.213     0.150
    11.952   171.002     0.150
    11.952   171.463     0.150
    12.775   184.932     0.150
    14.984   212.592     0.150
    15.004   212.643     0.150
    15.320   216.213     0.150
    15.807   223.623     0.150
    16.028   226.281     0.150
    16.331   230.262     0.150
    16.578   232.982     0.150
     0.269     5.820     0.150
     0.549    10.270     0.150
     0.549    17.879     0.150
     0.706    12.520     0.150
     0.706    22.320     0.150
     0.757    13.711     0.150
     0.757    24.719     0.150
     0.777    13.832     0.150
     0.777    24.219     0.150
     0.839    14.840     0.150
     0.839    26.250     0.150
     0.932    16.520     0.150
     0.932    28.949     0.150
     0.987    17.531     0.150
     1.303    22.691     0.150
     1.303    39.711     0.150
     1.500    26.180     0.150
     1.500    45.449     0.150
     1.582    26.570     0.150
     1.582    47.449     0.150
     1.606    26.949     0.150
     1.606    48.492     0.150
     2.584    41.199     0.150
     2.584    73.441     0.150
     2.718    41.891     0.150
     3.888    57.531     0.150
     4.089   108.461     0.150
     4.285    63.590     0.150
     4.355    65.602     0.150
     4.422    65.941     0.150
     4.422   117.949     0.150
     4.662    71.430     0.150
     4.732    71.148     0.150
     5.032    75.750     0.150
     5.935    87.000     0.150
     0.291     5.957     0.150
     0.685    13.057     0.150
     0.685    12.707     0.150
     0.685    21.906     0.150
     0.761    13.836     0.150
     0.761    23.367     0.150
     0.761    14.006     0.150
     0.761    24.566     0.150
     0.852    15.297     0.150
     0.852    15.006     0.150
     0.852    15.137     0.150
     0.852    26.877     0.150
     0.852    15.186     0.150
     0.852    26.926     0.150
     0.913    16.826     0.150
     0.913    16.506     0.150
     0.913    28.826     0.150
     0.992    17.695     0.150
     1.460    25.797     0.150
     1.460    44.896     0.150
     1.476    25.426     0.150
     1.559    26.586     0.150
     1.599    27.426     0.150
     1.599    49.387     0.150
     1.599    27.096     0.150
     1.599    48.867     0.150
     1.760    29.037     0.150
     1.830    31.496     0.150
     1.830    55.016     0.150
     2.414    38.707     0.150
     2.590    41.717     0.150
     2.590    41.537     0.150
     2.698    42.230     0.150
     2.698    81.707     0.150
     2.698    42.396     0.150
     2.698    42.076     0.150
     2.698    82.377     0.150
     3.834    59.016     0.150
     3.968    59.576     0.150
     4.072    60.586     0.150
     4.269    63.445     0.150
     4.332    65.176     0.150
     4.332   132.297     0.150
     4.406    65.105     0.150
     4.661    71.506     0.150
     4.661    71.707     0.150
     4.661   144.256     0.150
     4.683    70.945     0.150
     4.708    71.637     0.150
     4.716    70.467     0.150
     4.841    71.416     0.150
     4.858    73.025     0.150
     5.015    75.037     0.150
     5.057    76.426     0.150
     5.057    76.006     0.150
     5.355    80.096     0.150
     5.442    81.236     0.150
     5.871    87.227     0.150
     5.916    88.186     0.150
     5.968    89.307     0.150
     6.097    89.816     0.150
     6.224    92.287     0.150
     6.229    92.227     0.150
     6.229    92.025     0.150
     6.292    94.436     0.150
     6.292    94.436     0.150
     6.292   190.426     0.150
     6.442    96.387     0.150
     6.510    96.326     0.150
     6.537    98.686     0.150
     6.801   101.186     0.150
     6.801   101.506     0.150
     6.801   100.736     0.150
     6.885   101.867     0.150
     6.978   101.887     0.150
     7.035   104.326     0.150
     7.035   103.996     0.150
     7.035   103.816     0.150
     7.213   106.506     0.150
     7.308   107.666     0.150
     7.308   109.525     0.150
     7.308   109.477     0.150
     7.309   109.916     0.150
     7.309   109.596     0.150
     7.376   107.836     0.150
     7.666   111.986     0.150
     7.666   112.537     0.150
     7.687   113.166     0.150
     7.741   114.176     0.150
     8.019   117.445     0.150
     8.133   118.297     0.150
     8.250   120.916     0.150
     8.303   121.146     0.150
     8.371   121.967     0.150
     8.390   124.617     0.150
     8.399   123.746     0.150
     8.412   122.486     0.150
     8.434   123.127     0.150
     8.434   123.377     0.150
     8.469   124.287     0.150
     8.543   123.896     0.150
     8.546   123.506     0.150
     8.621   125.576     0.150
     8.624   127.656     0.150
     8.796   129.006     0.150
     8.952   130.646     0.150
     8.977   130.105     0.150
     9.006   130.807     0.150
     9.185   132.926     0.150
     9.276   132.996     0.150
     9.304   134.355     0.150
     9.396   137.936     0.150
     9.478   140.137     0.150
     9.480   137.916     0.150
     9.478   139.086     0.150
     9.550   140.346     0.150
     9.593   141.945     0.150
     9.642   138.195     0.150
     9.901   145.617     0.150
    10.009   145.996     0.150
    10.057   147.617     0.150
    10.085   146.957     0.150
    10.212   149.957     0.150
    10.272   150.826     0.150
    10.380   152.586     0.150
    10.690   156.850     0.150
    10.690   328.023     0.150
    12.416   175.975     0.150
    12.411   173.980     0.150
    13.380   190.656     0.150
    13.519   193.734     0.150
    14.515   210.676     0.150
    14.515   205.855     0.150
    15.141   213.877     0.150
    15.180   215.137     0.150
    15.247   214.547     0.150
    15.287   216.445     0.150
    15.296   215.816     0.150
    15.314   218.586     0.150
    15.423   217.426     0.150
    15.513   217.986     0.150
    17.131   242.256     0.150
    17.131   537.230     0.150
    17.515   250.506     0.150
    17.924   253.057     0.150
    17.932   252.268     0.150
    17.932   525.691     0.150
    18.143   256.826     0.150
    18.299   257.457     0.150
    18.307   256.584     0.150
    18.654   261.977     0.150
    19.805   272.387     0.150
    19.911   273.717     0.150
    20.000   272.516     0.150
    20.025   275.195     0.150
    20.114   276.486     0.150
    20.425   280.297     0.150
    20.425   278.416     0.150
    20.425   278.855     0.150
    20.465   278.576     0.150
    20.755   282.176     0.150
    21.119   285.467     0.150
    21.167   286.168     0.150
    21.536   289.484     0.150
    21.918   293.348     0.150
    22.108   296.383     0.150
    22.108   689.805     0.150
    22.108   297.055     0.150
    22.503   305.277     0.150
    22.533   301.715     0.150
    22.562   301.145     0.150
    22.924   307.668     0.150
    23.058   308.305     0.150
    23.058   306.836     0.150
    23.151   306.777     0.150
    23.252   308.598     0.150
    23.331   309.527     0.150
    23.611   312.266     0.150
    23.930   314.695     0.150
    24.083   316.336     0.150
    24.106   316.445     0.150
    24.618   322.375     0.150
    24.932   325.027     0.150
    24.932   324.035     0.150
    25.711   330.426     0.150
    25.829   332.418     0.150
    25.858   334.098     0.150
    25.858   332.277     0.150
    25.858   333.656     0.150
    25.859   332.855     0.150
    26.186   338.047     0.150
    26.186   336.855     0.150
    26.257   335.645     0.150
    26.325   336.207     0.150
    26.369   336.348     0.150
    27.262   345.266     0.150
    29.048   362.926     0.150
    29.048   359.836     0.150
    29.080   361.258     0.150
    29.894   368.457     0.150
    31.690   385.367     0.150
    31.690   383.676     0.150
    31.716   384.328     0.150
    31.784   385.547     0.150
    31.826   387.055     0.150
    31.831   387.156     0.150
    31.831   387.531     0.150
    31.831   556.332     0.150
    32.032   388.258     0.150
    32.732   393.598     0.150
    32.866   396.375     0.150
    32.866   394.867     0.150
    33.611   401.086     0.150
    34.341   406.348     0.150
    34.272   407.227     0.150
    35.183   416.957     0.150
    36.552   426.957     0.150
    36.552   426.387     0.150
    36.731   428.688     0.150
    37.102   431.484     0.150
    38.001   441.055     0.150
    38.877   445.996     0.150
    40.505   462.305     0.150
    40.661   460.086     0.150
    43.032   483.145     0.150
    43.032   482.355     0.150
    53.819   563.133     0.150
    53.819   562.965     0.150
    55.767   577.195     0.150
    56.950   586.055     0.150
    60.781   613.258     0.150
    61.571   618.398     0.150
    61.571   617.027     0.150
    61.686   618.434     0.150
    63.003   627.891     0.150
    63.196   628.957     0.150
    63.676   633.078     0.150
    63.676   631.586     0.150
    65.144   645.895     0.150
    67.241   657.758     0.150
    67.413   659.457     0.150
    67.421   657.176     0.150
    67.421   655.258     0.150
    68.393   662.207     0.150
    68.393   662.465     0.150
    69.149   669.156     0.150
    71.913   683.758     0.150
    72.675   692.156     0.150
    72.742   689.168     0.150
    72.742   688.215     0.150
    72.848   689.305     0.150
    73.542   693.703     0.150
    74.131   698.355     0.150
    74.520   698.520     0.150
    74.562   699.156     0.150
    74.567   702.066     0.150
    74.567   699.457     0.150
    75.130   703.758     0.150
    75.219   700.156     0.150
    75.369   701.969     0.150
    75.658   706.008     0.150
    75.658   704.734     0.150
    75.887   707.453     0.150
    76.508   711.305     0.150
    76.508   710.617     0.150
    76.787   711.438     0.150
    76.787   711.668     0.150
    77.047   713.957     0.150
    77.047   721.156     0.150
    77.122   718.695     0.150
    78.291   724.516     0.150
    78.439   725.457     0.150
    78.936   725.418     0.150
    82.663   744.156     0.150
    84.439   756.758     0.150
    85.912   759.957     0.150
    85.912   760.387     0.150
    88.311   772.105     0.150
    95.951   808.055     0.150
    98.750   819.188     0.150
   143.679  1173.449     0.150
   143.679  1174.137     0.150
   149.615  1184.281     0.150
   149.615  1190.305     0.150
   149.615  1184.848     0.150
   151.848  1194.172     0.150
     0.287     6.012     0.150
     0.287    11.141     0.150
     0.688    12.652     0.150
     0.688    22.262     0.150
     0.766    14.020     0.150
     0.766    24.320     0.150
     0.766    24.000     0.150
     0.855    15.312     0.150
     0.855    26.320     0.150
     0.855    26.602     0.150
     0.855    15.172     0.150
     0.855    26.520     0.150
     0.856    15.172     0.150
     0.856    26.609     0.150
     0.911    16.262     0.150
     0.911    28.539     0.150
     0.911    28.652     0.150
     0.911    16.520     0.150
     0.997    17.961     0.150
     0.997    30.902     0.150
     1.454    25.422     0.150
     1.454    44.930     0.150
     1.478    25.500     0.150
     1.478    45.332     0.150
     1.561    26.562     0.150
     1.561    48.312     0.150
     1.605    27.633     0.150
     1.605    49.262     0.150
     1.605    27.199     0.150
     1.605    48.883     0.150
     1.760    29.281     0.150
     1.760    54.371     0.150
     1.825    31.590     0.150
     2.409    38.840     0.150
     2.584    41.730     0.150
     2.584    41.531     0.150
     2.702    42.137     0.150
     2.702    47.086     0.150
     2.702    81.086     0.150
     3.829    58.223     0.150
     4.274    63.750     0.150
     4.332    65.832     0.150
     4.411    66.582     0.150
     4.655    69.742     0.150
     4.655    70.812     0.150
     4.655   142.336     0.150
     4.655    71.539     0.150
     4.678    69.930     0.150
     4.720    71.141     0.150
     4.853    72.391     0.150
     4.846    72.609     0.150
     5.020    75.672     0.150
     5.359    80.051     0.150
     5.446    80.199     0.150
     5.845    86.090     0.150
     5.914    88.133     0.150
     5.963    87.281     0.150
     6.226    91.801     0.150
     6.226    92.062     0.150
     6.804   101.480     0.150
     9.004   127.812     0.150
     9.065   129.039     0.150
     9.309   132.859     0.150
     9.554   136.332     0.150
     9.597   136.840     0.150
     9.971   141.520     0.150
    10.000   142.500     0.150
    10.080   143.551     0.150
    10.491   149.590     0.150
    10.693   153.305     0.150
    10.878   154.020     0.150
    10.970   156.520     0.150
    11.189   158.250     0.150
    11.742   166.359     0.150
    11.881   168.359     0.150
    12.096   170.801     0.150
    12.100   170.641     0.150
    12.407   173.277     0.150
    12.407   382.230     0.150
    13.375   191.109     0.150
    15.117   211.871     0.150
    15.115   211.539     0.150
    16.025   224.441     0.150
    16.275   227.781     0.150
    16.280   226.680     0.150
    16.332   228.133     0.150
    17.937   251.215     0.150
    17.955   248.590     0.150
    18.311   256.461     0.150
    31.835   385.938     0.150
    75.653   706.438     0.150
     0.294     5.623     0.150
     0.294     9.703     0.150
     0.258     6.174     0.150
     0.748    13.363     0.150
     0.748    23.143     0.150
     0.748    13.174     0.150
     0.748    23.312     0.150
     0.748    13.293     0.150
     0.748    23.764     0.150
     0.749    13.203     0.150
     0.749    24.043     0.150
     0.854    15.434     0.150
     0.854    26.912     0.150
     0.854    26.684     0.150
     1.034    18.354     0.150
     1.034    32.273     0.150
     1.167    21.162     0.150
     1.167    36.764     0.150
     1.167    21.023     0.150
     1.167    36.402     0.150
     1.344    24.113     0.150
     1.344    41.123     0.150
     1.344    23.334     0.150
     1.464    26.062     0.150
     1.464    45.152     0.150
     2.061    33.123     0.150
     2.205    35.662     0.150
     2.477    39.764     0.150
     2.477    39.514     0.150
     3.155    47.848     0.150
     3.155    82.873     0.150
     3.155    95.049     0.150
     3.519    53.133     0.150
     3.636    54.584     0.150
     3.728    57.113     0.150
     4.471    67.184     0.150
     4.471   116.973     0.150
     4.489    67.863     0.150
     4.550    67.912     0.150
     4.654    69.053     0.150
     4.654   122.572     0.150
     4.697    71.594     0.150
     4.697    69.748     0.150
     4.697   123.373     0.150
     4.697    72.863     0.150
     4.813    72.363     0.150
     4.844    73.033     0.150
     4.844   127.844     0.150
     4.832    72.363     0.150
     5.406    81.674     0.150
     5.406   141.713     0.150
     5.928    87.803     0.150
     6.313    94.072     0.150
     6.857   100.412     0.150
     6.857   100.783     0.150
     6.857   174.322     0.150
     6.885    99.463     0.150
     7.292   106.992     0.150
     7.292   107.482     0.150
     7.950   116.004     0.150
     7.950   203.213     0.150
     8.098   118.982     0.150
     8.293   120.652     0.150
     8.293   212.643     0.150
    11.933   167.342     0.150
    12.673   177.773     0.150
    13.070   184.322     0.150
    14.418   201.748     0.150
    18.295   252.271     0.150
    75.386   703.973     0.150
     0.367     6.844     0.150
     0.367    10.363     0.150
     0.367     6.879     0.150
     0.367    10.363     0.150
     2.878    44.355     0.150
     2.878    51.082     0.150
     2.878    77.156     0.150
     2.878    87.406     0.150
     5.790    87.555     0.150
     5.790   150.777     0.150
     5.790   175.605     0.150
    10.915   156.074     0.150
    10.915   333.824     0.150
    12.335   176.301     0.150
    13.613   192.105     0.150
    13.613   425.281     0.150
    13.975   197.828     0.150
    15.505   217.988     0.150
    17.540   246.656     0.150
    18.450   257.109     0.150
    22.880   304.590     0.150
    31.731   385.824     0.150
    64.171   635.582     0.150
    69.079   666.621     0.150
    72.736   688.988     0.150
    73.578   693.832     0.150
    76.324   709.855     0.150
    88.367   773.148     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
