#!/bin/bash
gmt begin haida1.26_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-4/5/0/14
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya10f5+l'Counts' -BWeSn+t'Origin Time Mislocation haida1.26' << EOF
     1.000
     1.141
    -0.484
     0.910
     0.891
    -0.824
     0.793
    -1.484
    -0.480
    -0.320
     0.246
     0.266
    -1.062
    -0.595
     1.979
     0.586
     1.703
     1.770
     3.586
     2.148
     2.875
     2.445
     0.898
     2.604
     2.285
    -0.703
     0.461
     0.319
     0.781
    -0.414
    -0.818
     0.922
    -0.348
    -0.312
     0.066
    -1.984
    -0.457
    -0.523
    -0.542
    -0.031
     0.520
     0.930
    -1.102
    -0.566
    -0.051
    -0.967
     0.062
     0.498
    -1.359
     0.445
     0.090
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.246    12.735 Median =   0.2 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.2  0.
  0.2  12.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -3.800    13.265 Author: all (  51 samples)
EOF
gmt end
