#!/bin/bash
gmt begin haida1.26_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-45/45/-45/45
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation haida1.26'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    12.138    12.138
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.427    -1.896
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.741    -6.587
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.285     3.802
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.439    -4.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.770    -5.975
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.686    -0.330
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.157     2.373
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.563     2.922
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.532     9.338
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.532     9.338 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.822    -1.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.120     0.720
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.748     0.685
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.520     0.000
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.520     0.000 13
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.111    -1.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.959    20.694
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.959    20.694 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.673    -1.484
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    25.153    28.935
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    25.153    28.935 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.897     6.750
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.826    19.544
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.826    19.544 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    22.735    26.154
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    22.735    26.154 20
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.639    32.064
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.639    32.064 21
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    30.408    31.489
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    30.408    31.489 22
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    31.067     8.324
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    31.067     8.324 23
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.801    13.945
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.801    13.945 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.404    17.404
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    17.404    17.404 25
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.654    -2.855
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.381     3.810
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.181     4.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.275     8.621
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.275     8.621 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.741    -1.746
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.755    -5.408
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.605    16.752
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.605    16.752 32
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.565    -0.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.373     1.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.204     1.563
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.969    -3.548
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.224     1.970
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.288    -1.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.351    -3.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.099    -2.821
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.054     2.962
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.915     8.465
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.257     2.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.620    -0.418
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.393    -1.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.056     0.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.135    -0.766
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.448    -0.443
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.342    -0.165
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.720    -2.537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.736    10.313
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.736    10.313 51
EOF
gmt plot $proj $reg -SE -Gred << EOF
     5.140     4.643     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -43.000    43.000 Author: all (  51 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -43.000   -43.000 Average =   6.9 km at  47.9 deg; median =    6.1 km
EOF
gmt end
