#!/bin/bash
gmt begin haida1.26_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-17/18/0/20
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation haida1.26' << EOF
     0.300
     7.000
    -0.000
     7.000
    10.000
    -0.000
     4.000
    -0.000
    -3.900
     6.000
     3.400
     4.600
    -0.000
    -0.000
    -0.000
    -0.400
     2.000
     5.000
    13.000
    -0.000
    10.000
     4.000
     2.200
    10.000
     2.000
    -6.900
    -0.100
     0.700
    -2.900
    -0.200
     2.700
    -3.700
    -0.000
    -0.000
    -1.800
   -11.500
    -1.600
    -1.000
    -3.900
    -1.900
     2.000
    -0.000
    -2.400
    -6.600
     0.700
    -1.600
    -0.000
    -0.300
    -4.400
    -0.400
    -6.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.000    18.050 Median =  -0.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.0  0.
 -0.0  17.7
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -16.000    18.950 Author: all (  51 samples)
EOF
gmt end
