#!/bin/bash
gmt begin haida1.26_depth_histogram pdf,ps
proj=-JX12/10
reg=-R0/25/0/13
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depths haida1.26' << EOF
     8.000
     8.000
     5.000
     8.000
    10.000
    15.000
    11.000
    10.000
    15.000
     9.000
    10.000
    17.000
    10.000
     6.000
    10.000
    17.000
     8.000
    17.000
     9.000
    10.000
    12.000
    18.000
    11.000
    12.000
    20.000
    12.000
    14.000
    13.000
    15.000
    15.000
    17.000
    16.000
     1.000
     5.000
    12.000
    16.000
    10.000
     1.000
    15.000
     3.000
    20.000
    18.000
    20.000
     7.000
    15.000
     5.000
    10.000
     7.000
     7.000
     9.000
     6.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000    12.220 Median of constrained depths =  10.0
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000    11.440 Spread of constrained depths =   4.9
EOF
gmt end
