#!/bin/bash
gmt begin haida1.26_dcal pdf,ps
proj=-JM16.0c+
reg=-R-136.0/-128.2/50.7/56.1
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration haida1.26'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -132.118    54.003
  -131.352    53.851
>
  -130.637    53.493
  -131.352    53.851
>
  -130.637    53.493
  -131.352    53.851
>
  -132.567    53.706
  -131.352    53.851
>
  -131.997    53.158
  -131.352    53.851
>
  -132.541    53.252
  -131.352    53.851
>
  -132.942    53.955
  -131.352    53.851
>
  -132.118    54.003
  -131.335    53.864
>
  -130.637    53.493
  -131.335    53.864
>
  -130.637    53.493
  -131.335    53.864
>
  -132.567    53.706
  -131.335    53.864
>
  -131.997    53.158
  -131.335    53.864
>
  -132.541    53.252
  -131.335    53.864
>
  -132.942    53.955
  -131.335    53.864
>
  -132.118    54.003
  -131.341    53.821
>
  -132.118    54.003
  -131.341    53.821
>
  -130.637    53.493
  -131.341    53.821
>
  -130.637    53.493
  -131.341    53.821
>
  -132.567    53.706
  -131.341    53.821
>
  -130.287    54.326
  -131.341    53.821
>
  -131.997    53.158
  -131.341    53.821
>
  -132.541    53.252
  -131.341    53.821
>
  -132.942    53.955
  -131.341    53.821
>
  -132.942    53.955
  -131.341    53.821
>
  -132.118    54.003
  -131.343    53.850
>
  -130.637    53.493
  -131.343    53.850
>
  -130.637    53.493
  -131.343    53.850
>
  -131.996    53.248
  -131.343    53.850
>
  -132.567    53.706
  -131.343    53.850
>
  -131.997    53.158
  -131.343    53.850
>
  -130.287    54.326
  -131.343    53.850
>
  -130.287    54.326
  -131.343    53.850
>
  -132.541    53.252
  -131.343    53.850
>
  -132.942    53.955
  -131.343    53.850
>
  -132.942    53.955
  -131.343    53.850
>
  -132.118    54.003
  -132.156    53.894
>
  -132.567    53.706
  -132.156    53.894
>
  -132.567    53.706
  -132.156    53.894
>
  -132.942    53.955
  -132.156    53.894
>
  -131.996    53.248
  -132.156    53.894
>
  -133.058    54.256
  -132.156    53.894
>
  -131.997    53.158
  -132.156    53.894
>
  -130.637    53.493
  -132.156    53.894
>
  -130.637    53.493
  -132.156    53.894
>
  -132.118    54.003
  -131.783    53.634
>
  -132.118    54.003
  -131.783    53.634
>
  -131.997    53.158
  -131.783    53.634
>
  -130.637    53.493
  -131.783    53.634
>
  -132.942    53.955
  -131.783    53.634
>
  -132.942    53.955
  -131.783    53.634
>
  -133.058    54.256
  -131.783    53.634
>
  -133.058    54.256
  -131.783    53.634
>
  -132.567    53.706
  -131.547    53.832
>
  -130.637    53.493
  -131.547    53.832
>
  -131.997    53.158
  -131.547    53.832
>
  -130.287    54.326
  -131.547    53.832
>
  -133.058    54.256
  -131.547    53.832
>
  -132.567    53.706
  -132.181    53.810
>
  -132.942    53.955
  -132.181    53.810
>
  -131.996    53.248
  -132.181    53.810
>
  -131.997    53.158
  -132.181    53.810
>
  -131.997    53.158
  -132.181    53.810
>
  -133.058    54.256
  -132.181    53.810
>
  -133.058    54.256
  -132.181    53.810
>
  -130.637    53.493
  -132.181    53.810
>
  -130.637    53.493
  -132.181    53.810
>
  -131.969    53.145
  -132.329    52.831
>
  -131.969    53.145
  -132.329    52.831
>
  -132.541    53.252
  -132.329    52.831
>
  -132.541    53.252
  -132.329    52.831
>
  -132.023    54.015
  -131.683    54.100
>
  -132.023    54.015
  -131.683    54.100
>
  -132.942    53.955
  -131.683    54.100
>
  -132.942    53.955
  -131.683    54.100
>
  -130.637    53.493
  -131.683    54.100
>
  -130.637    53.493
  -131.683    54.100
>
  -133.058    54.256
  -131.683    54.100
>
  -133.058    54.256
  -131.683    54.100
>
  -131.969    53.145
  -131.683    54.100
>
  -131.969    53.145
  -131.683    54.100
>
  -132.541    53.252
  -131.683    54.100
>
  -132.541    53.252
  -131.683    54.100
>
  -131.969    53.145
  -131.614    53.436
>
  -132.541    53.252
  -131.614    53.436
>
  -132.541    53.252
  -131.614    53.436
>
  -131.752    52.576
  -131.614    53.436
>
  -131.752    52.576
  -131.614    53.436
>
  -132.023    54.015
  -132.104    53.802
>
  -132.023    54.015
  -132.104    53.802
>
  -132.942    53.955
  -132.104    53.802
>
  -132.942    53.955
  -132.104    53.802
>
  -132.541    53.252
  -132.104    53.802
>
  -132.541    53.252
  -132.104    53.802
>
  -131.969    53.145
  -132.104    53.802
>
  -130.637    53.493
  -132.104    53.802
>
  -130.637    53.493
  -132.104    53.802
>
  -130.637    53.493
  -131.433    53.811
>
  -132.023    54.015
  -131.433    53.811
>
  -132.023    54.015
  -131.433    53.811
>
  -130.252    54.326
  -131.433    53.811
>
  -130.252    54.326
  -131.433    53.811
>
  -131.969    53.145
  -131.433    53.811
>
  -131.969    53.145
  -131.433    53.811
>
  -132.541    53.252
  -131.433    53.811
>
  -132.541    53.252
  -131.433    53.811
>
  -132.942    53.955
  -131.433    53.811
>
  -132.942    53.955
  -131.433    53.811
>
  -132.023    54.015
  -131.405    53.815
>
  -132.023    54.015
  -131.405    53.815
>
  -130.637    53.493
  -131.405    53.815
>
  -130.637    53.493
  -131.405    53.815
>
  -131.969    53.145
  -131.405    53.815
>
  -131.969    53.145
  -131.405    53.815
>
  -131.969    53.145
  -131.405    53.815
>
  -131.969    53.145
  -131.405    53.815
>
  -132.477    53.202
  -131.405    53.815
>
  -132.477    53.202
  -131.405    53.815
>
  -132.477    53.202
  -131.405    53.815
>
  -132.477    53.202
  -131.405    53.815
>
  -132.477    53.202
  -131.405    53.815
>
  -130.252    54.326
  -131.405    53.815
>
  -130.252    54.326
  -131.405    53.815
>
  -132.942    53.955
  -131.405    53.815
>
  -132.942    53.955
  -131.405    53.815
>
  -132.942    53.955
  -131.405    53.815
>
  -132.542    53.252
  -132.392    52.622
>
  -132.542    53.252
  -132.392    52.622
>
  -131.969    53.145
  -132.302    52.820
>
  -131.969    53.145
  -132.302    52.820
>
  -131.752    52.576
  -132.302    52.820
>
  -131.752    52.576
  -132.302    52.820
>
  -132.477    53.202
  -132.302    52.820
>
  -132.477    53.202
  -132.302    52.820
>
  -132.477    53.202
  -132.302    52.820
>
  -132.477    53.202
  -132.302    52.820
>
  -132.477    53.202
  -132.302    52.820
>
  -132.542    53.252
  -132.302    52.820
>
  -132.542    53.252
  -132.302    52.820
>
  -132.477    53.202
  -132.058    52.627
>
  -132.477    53.202
  -132.058    52.627
>
  -132.542    53.252
  -132.058    52.627
>
  -132.477    53.202
  -132.420    52.809
>
  -132.477    53.202
  -132.420    52.809
>
  -132.477    53.202
  -132.420    52.809
>
  -132.477    53.202
  -132.420    52.809
>
  -132.542    53.252
  -132.420    52.809
>
  -132.542    53.252
  -132.420    52.809
>
  -132.477    53.202
  -132.783    52.638
>
  -132.477    53.202
  -132.783    52.638
>
  -132.477    53.202
  -132.783    52.638
>
  -132.477    53.202
  -132.783    52.638
>
  -132.542    53.252
  -132.783    52.638
>
  -132.542    53.252
  -132.783    52.638
>
  -132.477    53.202
  -132.572    52.609
>
  -132.477    53.202
  -132.572    52.609
>
  -132.542    53.252
  -132.572    52.609
>
  -132.542    53.252
  -132.572    52.609
>
  -132.477    53.202
  -132.701    52.599
>
  -132.477    53.202
  -132.701    52.599
>
  -132.542    53.252
  -132.701    52.599
>
  -132.542    53.252
  -132.701    52.599
>
  -132.477    53.202
  -132.814    52.974
>
  -132.477    53.202
  -132.814    52.974
>
  -132.477    53.202
  -132.814    52.974
>
  -132.477    53.202
  -132.814    52.974
>
  -132.542    53.252
  -132.814    52.974
>
  -132.542    53.252
  -132.814    52.974
>
  -132.541    53.252
  -132.814    52.974
>
  -132.541    53.252
  -132.814    52.974
>
  -131.969    53.145
  -132.814    52.974
>
  -131.969    53.145
  -132.814    52.974
>
  -131.752    52.576
  -132.814    52.974
>
  -132.942    53.955
  -132.814    52.974
>
  -132.942    53.955
  -132.814    52.974
>
  -132.477    53.202
  -132.389    52.857
>
  -132.477    53.202
  -132.389    52.857
>
  -132.477    53.202
  -132.389    52.857
>
  -132.477    53.202
  -132.389    52.857
>
  -132.477    53.202
  -132.822    52.651
>
  -132.477    53.202
  -132.822    52.651
>
  -132.477    53.202
  -132.822    52.651
>
  -132.542    53.252
  -132.822    52.651
>
  -132.542    53.252
  -132.822    52.651
>
  -132.477    53.202
  -132.849    52.837
>
  -132.477    53.202
  -132.849    52.837
>
  -132.477    53.202
  -132.849    52.837
>
  -132.477    53.202
  -132.849    52.837
>
  -132.542    53.252
  -132.849    52.837
>
  -132.542    53.252
  -132.849    52.837
>
  -132.541    53.252
  -132.849    52.837
>
  -132.541    53.252
  -132.849    52.837
>
  -131.969    53.145
  -132.849    52.837
>
  -131.969    53.145
  -132.849    52.837
>
  -131.752    52.576
  -132.849    52.837
>
  -131.752    52.576
  -132.849    52.837
>
  -132.131    52.935
  -132.330    52.863
>
  -131.969    53.145
  -132.330    52.863
>
  -131.969    53.145
  -132.330    52.863
>
  -132.477    53.202
  -132.330    52.863
>
  -132.477    53.202
  -132.330    52.863
>
  -132.477    53.202
  -132.330    52.863
>
  -132.477    53.202
  -132.330    52.863
>
  -132.542    53.252
  -132.330    52.863
>
  -132.542    53.252
  -132.330    52.863
>
  -132.541    53.252
  -132.330    52.863
>
  -132.541    53.252
  -132.330    52.863
>
  -131.752    52.576
  -132.330    52.863
>
  -131.752    52.576
  -132.330    52.863
>
  -131.443    52.577
  -132.330    52.863
>
  -131.443    52.577
  -132.330    52.863
>
  -131.197    52.293
  -132.330    52.863
>
  -131.197    52.293
  -132.330    52.863
>
  -132.477    53.202
  -132.613    52.979
>
  -132.477    53.202
  -132.613    52.979
>
  -132.477    53.202
  -132.613    52.979
>
  -132.477    53.202
  -132.613    52.979
>
  -132.131    52.935
  -132.613    52.979
>
  -132.131    52.935
  -132.613    52.979
>
  -132.542    53.252
  -132.613    52.979
>
  -132.542    53.252
  -132.613    52.979
>
  -132.541    53.252
  -132.613    52.979
>
  -132.541    53.252
  -132.613    52.979
>
  -131.969    53.145
  -132.613    52.979
>
  -131.969    53.145
  -132.613    52.979
>
  -131.752    52.576
  -132.613    52.979
>
  -131.752    52.576
  -132.613    52.979
>
  -131.443    52.577
  -132.613    52.979
>
  -131.443    52.577
  -132.613    52.979
>
  -132.942    53.955
  -132.613    52.979
>
  -132.942    53.955
  -132.613    52.979
>
  -132.131    52.935
  -132.497    52.846
>
  -132.131    52.935
  -132.497    52.846
>
  -132.477    53.202
  -132.497    52.846
>
  -132.477    53.202
  -132.497    52.846
>
  -132.477    53.202
  -132.497    52.846
>
  -132.477    53.202
  -132.497    52.846
>
  -131.969    53.145
  -132.497    52.846
>
  -131.969    53.145
  -132.497    52.846
>
  -131.752    52.576
  -132.497    52.846
>
  -131.752    52.576
  -132.497    52.846
>
  -131.443    52.577
  -132.497    52.846
>
  -131.443    52.577
  -132.497    52.846
>
  -131.197    52.293
  -132.497    52.846
>
  -131.197    52.293
  -132.497    52.846
>
  -132.131    52.935
  -132.399    52.830
>
  -132.131    52.935
  -132.399    52.830
>
  -132.477    53.202
  -132.399    52.830
>
  -132.477    53.202
  -132.399    52.830
>
  -132.477    53.202
  -132.399    52.830
>
  -132.477    53.202
  -132.399    52.830
>
  -131.969    53.145
  -132.399    52.830
>
  -131.969    53.145
  -132.399    52.830
>
  -132.542    53.252
  -132.399    52.830
>
  -132.542    53.252
  -132.399    52.830
>
  -132.541    53.252
  -132.399    52.830
>
  -132.541    53.252
  -132.399    52.830
>
  -131.752    52.576
  -132.399    52.830
>
  -131.443    52.577
  -132.399    52.830
>
  -131.443    52.577
  -132.399    52.830
>
  -131.197    52.293
  -132.399    52.830
>
  -131.197    52.293
  -132.399    52.830
>
  -132.477    53.202
  -132.572    52.982
>
  -132.477    53.202
  -132.572    52.982
>
  -132.477    53.202
  -132.572    52.982
>
  -132.477    53.202
  -132.572    52.982
>
  -132.131    52.935
  -132.572    52.982
>
  -132.131    52.935
  -132.572    52.982
>
  -131.969    53.145
  -132.572    52.982
>
  -131.969    53.145
  -132.572    52.982
>
  -131.752    52.576
  -132.572    52.982
>
  -131.443    52.577
  -132.572    52.982
>
  -131.443    52.577
  -132.572    52.982
>
  -132.942    53.955
  -132.572    52.982
>
  -132.131    52.935
  -132.241    52.732
>
  -132.131    52.935
  -132.241    52.732
>
  -131.752    52.576
  -132.241    52.732
>
  -131.752    52.576
  -132.241    52.732
>
  -131.443    52.577
  -132.241    52.732
>
  -131.443    52.577
  -132.241    52.732
>
  -132.477    53.202
  -132.241    52.732
>
  -132.477    53.202
  -132.241    52.732
>
  -132.477    53.202
  -132.241    52.732
>
  -132.942    53.955
  -132.153    53.869
>
  -132.942    53.955
  -132.153    53.869
>
  -133.058    54.256
  -132.153    53.869
>
  -133.058    54.256
  -132.153    53.869
>
  -132.541    53.252
  -132.153    53.869
>
  -132.541    53.252
  -132.153    53.869
>
  -132.477    53.202
  -132.153    53.869
>
  -132.477    53.202
  -132.153    53.869
>
  -131.969    53.145
  -132.153    53.869
>
  -131.969    53.145
  -132.153    53.869
>
  -132.131    52.935
  -132.153    53.869
>
  -132.131    52.935
  -132.153    53.869
>
  -130.637    53.493
  -132.153    53.869
>
  -130.637    53.493
  -132.153    53.869
>
  -132.023    54.015
  -131.607    53.871
>
  -130.637    53.493
  -131.607    53.871
>
  -130.637    53.493
  -131.607    53.871
>
  -131.969    53.145
  -131.607    53.871
>
  -131.969    53.145
  -131.607    53.871
>
  -132.942    53.955
  -131.607    53.871
>
  -132.477    53.202
  -131.607    53.871
>
  -132.477    53.202
  -131.607    53.871
>
  -130.252    54.326
  -131.607    53.871
>
  -130.252    54.326
  -131.607    53.871
>
  -133.058    54.256
  -131.607    53.871
>
  -129.958    53.847
  -131.607    53.871
>
  -129.958    53.847
  -131.607    53.871
>
  -132.131    52.935
  -131.607    53.871
>
  -132.131    52.935
  -131.607    53.871
>
  -132.023    54.015
  -132.356    54.011
>
  -132.023    54.015
  -132.356    54.011
>
  -132.942    53.955
  -132.356    54.011
>
  -132.942    53.955
  -132.356    54.011
>
  -133.058    54.256
  -132.356    54.011
>
  -132.477    53.202
  -132.356    54.011
>
  -132.477    53.202
  -132.356    54.011
>
  -131.969    53.145
  -132.356    54.011
>
  -131.969    53.145
  -132.356    54.011
>
  -132.131    52.935
  -132.649    52.952
>
  -132.131    52.935
  -132.649    52.952
>
  -132.477    53.202
  -132.649    52.952
>
  -132.477    53.202
  -132.649    52.952
>
  -132.477    53.202
  -132.649    52.952
>
  -132.477    53.202
  -132.649    52.952
>
  -132.477    53.202
  -132.649    52.952
>
  -131.969    53.145
  -132.649    52.952
>
  -131.969    53.145
  -132.649    52.952
>
  -131.969    53.145
  -132.649    52.952
>
  -131.752    52.576
  -132.649    52.952
>
  -132.023    54.015
  -131.961    54.250
>
  -132.023    54.015
  -131.961    54.250
>
  -133.058    54.256
  -131.961    54.250
>
  -133.058    54.256
  -131.961    54.250
>
  -132.023    54.015
  -132.379    53.934
>
  -132.942    53.955
  -132.379    53.934
>
  -133.058    54.256
  -132.379    53.934
>
  -133.058    54.256
  -132.379    53.934
>
  -132.477    53.202
  -132.379    53.934
>
  -132.477    53.202
  -132.379    53.934
>
  -132.477    53.202
  -132.608    52.974
>
  -132.477    53.202
  -132.608    52.974
>
  -132.477    53.202
  -132.608    52.974
>
  -132.477    53.202
  -132.608    52.974
>
  -132.477    53.202
  -132.608    52.974
>
  -132.477    53.202
  -132.608    52.974
>
  -131.969    53.145
  -132.608    52.974
>
  -131.969    53.145
  -132.608    52.974
>
  -131.753    52.576
  -132.608    52.974
>
  -131.753    52.576
  -132.608    52.974
>
  -131.752    52.576
  -132.608    52.974
>
  -131.752    52.576
  -132.608    52.974
>
  -132.521    53.715
  -132.608    52.974
>
  -132.521    53.715
  -132.608    52.974
>
  -131.969    53.145
  -131.486    53.394
>
  -130.637    53.493
  -131.486    53.394
>
  -130.637    53.493
  -131.486    53.394
>
  -132.477    53.202
  -131.486    53.394
>
  -132.477    53.202
  -131.486    53.394
>
  -132.521    53.715
  -131.486    53.394
>
  -132.521    53.715
  -131.486    53.394
>
  -131.753    52.576
  -131.486    53.394
>
  -131.753    52.576
  -131.486    53.394
>
  -132.477    53.202
  -132.732    53.073
>
  -132.477    53.202
  -132.732    53.073
>
  -132.131    52.935
  -132.732    53.073
>
  -132.131    52.935
  -132.732    53.073
>
  -131.969    53.145
  -132.732    53.073
>
  -131.969    53.145
  -132.732    53.073
>
  -132.521    53.715
  -132.732    53.073
>
  -132.521    53.715
  -132.732    53.073
>
  -131.753    52.576
  -132.732    53.073
>
  -131.753    52.576
  -132.732    53.073
>
  -132.942    53.955
  -132.732    53.073
>
  -132.942    53.955
  -132.732    53.073
>
  -132.477    53.202
  -132.725    53.073
>
  -132.477    53.202
  -132.725    53.073
>
  -132.477    53.202
  -132.725    53.073
>
  -132.477    53.202
  -132.725    53.073
>
  -132.131    52.935
  -132.725    53.073
>
  -132.131    52.935
  -132.725    53.073
>
  -131.969    53.145
  -132.725    53.073
>
  -131.969    53.145
  -132.725    53.073
>
  -131.969    53.145
  -132.725    53.073
>
  -132.521    53.715
  -132.725    53.073
>
  -132.521    53.715
  -132.725    53.073
>
  -132.942    53.955
  -132.725    53.073
>
  -132.942    53.955
  -132.725    53.073
>
  -131.753    52.576
  -132.725    53.073
>
  -131.753    52.576
  -132.725    53.073
>
  -132.477    53.202
  -132.750    53.058
>
  -132.477    53.202
  -132.750    53.058
>
  -132.477    53.202
  -132.750    53.058
>
  -132.477    53.202
  -132.750    53.058
>
  -132.477    53.202
  -132.750    53.058
>
  -132.477    53.202
  -132.750    53.058
>
  -132.477    53.202
  -132.750    53.058
>
  -132.131    52.935
  -132.750    53.058
>
  -132.131    52.935
  -132.750    53.058
>
  -131.969    53.145
  -132.750    53.058
>
  -131.969    53.145
  -132.750    53.058
>
  -131.969    53.145
  -132.750    53.058
>
  -131.753    52.576
  -132.750    53.058
>
  -131.753    52.576
  -132.750    53.058
>
  -132.942    53.955
  -132.750    53.058
>
  -132.942    53.955
  -132.750    53.058
>
  -132.942    53.955
  -132.750    53.058
>
  -132.942    53.955
  -132.750    53.058
>
  -132.023    54.015
  -131.742    53.762
>
  -132.521    53.715
  -131.742    53.762
>
  -132.521    53.715
  -131.742    53.762
>
  -130.637    53.493
  -131.742    53.762
>
  -130.637    53.493
  -131.742    53.762
>
  -132.477    53.202
  -131.742    53.762
>
  -132.477    53.202
  -131.742    53.762
>
  -132.477    53.202
  -131.742    53.762
>
  -132.477    53.202
  -131.742    53.762
>
  -132.477    53.202
  -131.742    53.762
>
  -132.477    53.202
  -131.742    53.762
>
  -132.477    53.202
  -131.742    53.762
>
  -132.942    53.955
  -131.742    53.762
>
  -132.131    52.935
  -131.742    53.762
>
  -132.521    53.715
  -132.436    53.843
>
  -132.521    53.715
  -132.436    53.843
>
  -132.942    53.955
  -132.436    53.843
>
  -132.942    53.955
  -132.436    53.843
>
  -132.023    54.015
  -132.436    53.843
>
  -132.023    54.015
  -132.436    53.843
>
  -132.477    53.202
  -132.436    53.843
>
  -131.969    53.145
  -132.436    53.843
>
  -131.969    53.145
  -132.436    53.843
>
  -132.131    52.935
  -132.436    53.843
>
  -132.023    54.015
  -131.604    53.876
>
  -132.023    54.015
  -131.604    53.876
>
  -132.521    53.715
  -131.604    53.876
>
  -132.521    53.715
  -131.604    53.876
>
  -130.637    53.493
  -131.604    53.876
>
  -130.637    53.493
  -131.604    53.876
>
  -131.969    53.145
  -131.604    53.876
>
  -131.969    53.145
  -131.604    53.876
>
  -131.969    53.145
  -131.604    53.876
>
  -132.942    53.955
  -131.604    53.876
>
  -132.942    53.955
  -131.604    53.876
>
  -132.942    53.955
  -131.604    53.876
>
  -132.477    53.202
  -131.604    53.876
>
  -132.477    53.202
  -131.604    53.876
>
  -132.477    53.202
  -131.604    53.876
>
  -130.252    54.326
  -131.604    53.876
>
  -130.252    54.326
  -131.604    53.876
>
  -130.252    54.326
  -131.604    53.876
>
  -130.252    54.326
  -131.604    53.876
>
  -132.131    52.935
  -131.604    53.876
>
  -132.131    52.935
  -131.604    53.876
>
  -132.023    54.015
  -131.636    53.874
>
  -132.521    53.715
  -131.636    53.874
>
  -132.521    53.715
  -131.636    53.874
>
  -130.637    53.493
  -131.636    53.874
>
  -130.637    53.493
  -131.636    53.874
>
  -131.969    53.145
  -131.636    53.874
>
  -131.969    53.145
  -131.636    53.874
>
  -132.942    53.955
  -131.636    53.874
>
  -132.942    53.955
  -131.636    53.874
>
  -132.477    53.202
  -131.636    53.874
>
  -132.477    53.202
  -131.636    53.874
>
  -130.252    54.326
  -131.636    53.874
>
  -130.252    54.326
  -131.636    53.874
>
  -132.131    52.935
  -131.636    53.874
>
  -132.023    54.015
  -131.596    53.871
>
  -130.637    53.493
  -131.596    53.871
>
  -130.637    53.493
  -131.596    53.871
>
  -130.637    53.493
  -131.596    53.871
>
  -131.969    53.145
  -131.596    53.871
>
  -131.969    53.145
  -131.596    53.871
>
  -131.969    53.145
  -131.596    53.871
>
  -131.969    53.145
  -131.596    53.871
>
  -132.477    53.202
  -131.596    53.871
>
  -132.477    53.202
  -131.596    53.871
>
  -132.477    53.202
  -131.596    53.871
>
  -132.477    53.202
  -131.596    53.871
>
  -132.477    53.202
  -131.596    53.871
>
  -132.477    53.202
  -131.596    53.871
>
  -130.252    54.326
  -131.596    53.871
>
  -130.252    54.326
  -131.596    53.871
>
  -130.252    54.326
  -131.596    53.871
>
  -132.131    52.935
  -131.596    53.871
>
  -132.023    54.015
  -131.597    53.877
>
  -132.023    54.015
  -131.597    53.877
>
  -130.637    53.493
  -131.597    53.877
>
  -130.637    53.493
  -131.597    53.877
>
  -131.969    53.145
  -131.597    53.877
>
  -131.969    53.145
  -131.597    53.877
>
  -131.969    53.145
  -131.597    53.877
>
  -132.477    53.202
  -131.597    53.877
>
  -132.477    53.202
  -131.597    53.877
>
  -132.477    53.202
  -131.597    53.877
>
  -132.477    53.202
  -131.597    53.877
>
  -132.477    53.202
  -131.597    53.877
>
  -132.477    53.202
  -131.597    53.877
>
  -132.477    53.202
  -131.597    53.877
>
  -130.252    54.326
  -131.597    53.877
>
  -130.252    54.326
  -131.597    53.877
>
  -130.252    54.326
  -131.597    53.877
>
  -130.252    54.326
  -131.597    53.877
>
  -132.131    52.935
  -131.597    53.877
>
  -132.131    52.935
  -131.597    53.877
>
  -132.942    53.955
  -132.445    53.949
>
  -132.942    53.955
  -132.445    53.949
>
  -132.023    54.015
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -132.477    53.202
  -132.445    53.949
>
  -131.969    53.145
  -132.445    53.949
>
  -131.969    53.145
  -132.445    53.949
>
  -131.969    53.145
  -132.445    53.949
>
  -132.477    53.202
  -132.692    52.860
>
  -132.477    53.202
  -132.692    52.860
>
  -132.477    53.202
  -132.692    52.860
>
  -132.477    53.202
  -132.692    52.860
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -132.118    54.003     0.300
  -130.637    53.493     0.300
  -132.567    53.706     0.300
  -131.997    53.158     0.300
  -132.541    53.252     0.300
  -132.942    53.955     0.300
  -130.287    54.326     0.300
  -131.996    53.248     0.300
  -133.058    54.256     0.300
  -131.969    53.145     0.300
  -132.023    54.015     0.300
  -131.752    52.576     0.300
  -130.252    54.326     0.300
  -132.477    53.202     0.300
  -132.477    53.202     0.300
  -132.542    53.252     0.300
  -132.131    52.935     0.300
  -131.443    52.577     0.300
  -131.197    52.293     0.300
  -129.958    53.847     0.300
  -132.477    53.202     0.300
  -131.753    52.576     0.300
  -132.521    53.715     0.300
  -132.477    53.202     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -131.352    53.851     0.200
>
  -131.335    53.864     0.200
>
  -131.341    53.821     0.200
>
  -131.343    53.850     0.200
>
  -132.156    53.894     0.200
>
  -131.783    53.634     0.200
>
  -131.547    53.832     0.200
>
  -132.181    53.810     0.200
>
  -132.329    52.831     0.200
>
  -131.683    54.100     0.200
>
  -131.614    53.436     0.200
>
  -132.104    53.802     0.200
>
  -131.433    53.811     0.200
>
  -131.405    53.815     0.200
>
  -132.392    52.622     0.200
>
  -132.302    52.820     0.200
>
  -132.058    52.627     0.200
>
  -132.420    52.809     0.200
>
  -132.783    52.638     0.200
>
  -132.572    52.609     0.200
>
  -132.701    52.599     0.200
>
  -132.784    52.608     0.200
>
  -132.814    52.974     0.200
>
  -132.389    52.857     0.200
>
  -132.822    52.651     0.200
>
  -132.849    52.837     0.200
>
  -132.330    52.863     0.200
>
  -132.613    52.979     0.200
>
  -132.497    52.846     0.200
>
  -132.399    52.830     0.200
>
  -132.572    52.982     0.200
>
  -132.241    52.732     0.200
>
  -132.153    53.869     0.200
>
  -131.607    53.871     0.200
>
  -132.356    54.011     0.200
>
  -132.649    52.952     0.200
>
  -131.961    54.250     0.200
>
  -132.379    53.934     0.200
>
  -132.608    52.974     0.200
>
  -131.486    53.394     0.200
>
  -132.732    53.073     0.200
>
  -132.725    53.073     0.200
>
  -132.750    53.058     0.200
>
  -131.742    53.762     0.200
>
  -132.436    53.843     0.200
>
  -131.604    53.876     0.200
>
  -131.636    53.874     0.200
>
  -131.596    53.871     0.200
>
  -131.597    53.877     0.200
>
  -132.445    53.949     0.200
>
  -132.692    52.860     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -132.163    53.345     0.000   222.000   222.000
  -132.163    53.345     0.000   444.000   444.000
EOF
gmt end
