#!/bin/bash
gmt begin haida1.26_base pdf,ps
proj=-JM16.0c+
reg=-R-132.9/-131.2/52.5/54.4
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map haida1.26'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -131.352    53.851 1
  -131.335    53.864 2
  -131.341    53.821 3
  -131.343    53.850 4
  -132.156    53.894 5
  -131.783    53.634 6
  -131.547    53.832 7
  -132.181    53.810 8
  -132.329    52.831 9
  -131.683    54.100 10
  -131.614    53.436 11
  -132.104    53.802 12
  -131.433    53.811 13
  -131.405    53.815 14
  -132.392    52.622 15
  -132.302    52.820 16
  -132.058    52.627 17
  -132.420    52.809 18
  -132.783    52.638 19
  -132.572    52.609 20
  -132.701    52.599 21
  -132.784    52.608 22
  -132.814    52.974 23
  -132.389    52.857 24
  -132.822    52.651 25
  -132.849    52.837 26
  -132.330    52.863 27
  -132.613    52.979 28
  -132.497    52.846 29
  -132.399    52.830 30
  -132.572    52.982 31
  -132.241    52.732 32
  -132.153    53.869 33
  -131.607    53.871 34
  -132.356    54.011 35
  -132.649    52.952 36
  -131.961    54.250 37
  -132.379    53.934 38
  -132.608    52.974 39
  -131.486    53.394 40
  -132.732    53.073 41
  -132.725    53.073 42
  -132.750    53.058 43
  -131.742    53.762 44
  -132.436    53.843 45
  -131.604    53.876 46
  -131.636    53.874 47
  -131.596    53.871 48
  -131.597    53.877 49
  -132.445    53.949 50
  -132.692    52.860 51
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -131.389    53.834
  -131.352    53.851
>
  -131.468    53.805
  -131.335    53.864
>
  -131.307    53.855
  -131.341    53.821
>
  -131.410    53.810
  -131.343    53.850
>
  -132.244    53.841
  -132.156    53.894
>
  -131.742    53.631
  -131.783    53.634
>
  -131.565    53.853
  -131.547    53.832
>
  -132.081    53.836
  -132.181    53.810
>
  -132.157    52.915
  -132.329    52.831
>
  -131.639    54.086
  -131.683    54.100
>
  -131.661    53.443
  -131.614    53.436
>
  -132.146    53.808
  -132.104    53.802
>
  -131.244    53.811
  -131.433    53.811
>
  -131.452    53.804
  -131.405    53.815
>
  -132.188    52.809
  -132.392    52.622
>
  -132.248    52.806
  -132.302    52.820
>
  -131.689    52.888
  -132.058    52.627
>
  -132.363    52.870
  -132.420    52.809
>
  -132.549    52.814
  -132.783    52.638
>
  -132.235    52.843
  -132.572    52.609
>
  -132.474    52.888
  -132.701    52.599
>
  -132.333    52.889
  -132.784    52.608
>
  -132.352    53.048
  -132.814    52.974
>
  -132.316    52.981
  -132.389    52.857
>
  -132.566    52.808
  -132.822    52.651
>
  -132.691    52.811
  -132.849    52.837
>
  -132.295    52.898
  -132.330    52.863
>
  -132.447    53.016
  -132.613    52.979
>
  -132.301    52.925
  -132.497    52.846
>
  -132.411    52.814
  -132.399    52.830
>
  -132.613    52.933
  -132.572    52.982
>
  -131.967    52.883
  -132.241    52.732
>
  -132.192    53.865
  -132.153    53.869
>
  -131.613    53.884
  -131.607    53.871
>
  -132.405    54.025
  -132.356    54.011
>
  -132.531    52.921
  -132.649    52.952
>
  -132.026    54.268
  -131.961    54.250
>
  -132.459    53.921
  -132.379    53.934
>
  -132.483    52.944
  -132.608    52.974
>
  -131.488    53.369
  -131.486    53.394
>
  -132.567    53.099
  -132.732    53.073
>
  -132.768    53.149
  -132.725    53.073
>
  -132.753    53.077
  -132.750    53.058
>
  -131.732    53.758
  -131.742    53.762
>
  -132.456    53.831
  -132.436    53.843
>
  -131.557    53.878
  -131.604    53.876
>
  -131.634    53.867
  -131.636    53.874
>
  -131.618    53.868
  -131.596    53.871
>
  -131.618    53.875
  -131.597    53.877
>
  -132.487    53.926
  -132.445    53.949
>
  -132.502    52.952
  -132.692    52.860
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -131.355    53.849
  -131.352    53.851
>
  -131.340    53.862
  -131.335    53.864
>
  -131.341    53.818
  -131.341    53.821
>
  -131.348    53.847
  -131.343    53.850
>
  -132.157    53.893
  -132.156    53.894
>
  -131.775    53.633
  -131.783    53.634
>
  -131.547    53.833
  -131.547    53.832
>
  -132.186    53.808
  -132.181    53.810
>
  -132.336    52.830
  -132.329    52.831
>
  -131.683    54.099
  -131.683    54.100
>
  -131.613    53.436
  -131.614    53.436
>
  -132.102    53.802
  -132.104    53.802
>
  -131.435    53.811
  -131.433    53.811
>
  -131.405    53.816
  -131.405    53.815
>
  -132.384    52.625
  -132.392    52.622
>
  -132.300    52.820
  -132.302    52.820
>
  -132.048    52.629
  -132.058    52.627
>
  -132.410    52.812
  -132.420    52.809
>
  -132.782    52.638
  -132.783    52.638
>
  -132.567    52.609
  -132.572    52.609
>
  -132.698    52.601
  -132.701    52.599
>
  -132.776    52.611
  -132.784    52.608
>
  -132.813    52.975
  -132.814    52.974
>
  -132.392    52.857
  -132.389    52.857
>
  -132.827    52.650
  -132.822    52.651
>
  -132.848    52.837
  -132.849    52.837
>
  -132.328    52.864
  -132.330    52.863
>
  -132.612    52.979
  -132.613    52.979
>
  -132.496    52.846
  -132.497    52.846
>
  -132.398    52.831
  -132.399    52.830
>
  -132.572    52.982
  -132.572    52.982
>
  -132.235    52.733
  -132.241    52.732
>
  -132.154    53.869
  -132.153    53.869
>
  -131.608    53.871
  -131.607    53.871
>
  -132.356    54.011
  -132.356    54.011
>
  -132.647    52.952
  -132.649    52.952
>
  -131.960    54.251
  -131.961    54.250
>
  -132.378    53.934
  -132.379    53.934
>
  -132.609    52.976
  -132.608    52.974
>
  -131.485    53.392
  -131.486    53.394
>
  -132.732    53.072
  -132.732    53.073
>
  -132.725    53.073
  -132.725    53.073
>
  -132.750    53.058
  -132.750    53.058
>
  -131.740    53.762
  -131.742    53.762
>
  -132.436    53.844
  -132.436    53.843
>
  -131.603    53.876
  -131.604    53.876
>
  -131.635    53.873
  -131.636    53.874
>
  -131.596    53.871
  -131.596    53.871
>
  -131.599    53.877
  -131.597    53.877
>
  -132.446    53.949
  -132.445    53.949
>
  -132.692    52.854
  -132.692    52.860
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -131.352    53.851   -53.141     1.565     1.857
  -131.335    53.864   -25.787     2.449     2.952
  -131.341    53.821    -7.106     2.489     2.998
  -131.343    53.850   -42.546     2.186     2.357
  -132.156    53.894   -27.735     1.702     2.806
  -131.783    53.634   -10.754     3.166     5.929
  -131.547    53.832   -24.751     2.623     3.884
  -132.181    53.810   -37.321     2.011     3.310
  -132.329    52.831   -32.955     2.328     3.452
  -131.683    54.100   -45.717     2.312     3.865
  -131.614    53.436    54.142     3.591     5.186
  -132.104    53.802   -75.674     3.837     3.988
  -131.433    53.811    39.913     1.704     1.997
  -131.405    53.815    31.089     1.896     2.671
  -132.392    52.622   -24.825     1.551     4.617
  -132.302    52.820   -36.091     1.211     2.284
  -132.058    52.627    44.031     1.800     2.062
  -132.420    52.809   -29.058     1.356     3.147
  -132.783    52.638   -22.960     1.523     2.540
  -132.572    52.609   -26.373     2.538     5.331
  -132.701    52.599   -25.785     1.653     3.947
  -132.784    52.608    61.611     0.511     4.866
  -132.814    52.974   -83.114     1.996     2.210
  -132.389    52.857   -30.911     1.301     2.939
  -132.822    52.651    -5.273     4.038     5.966
  -132.849    52.837    -0.498     2.785     3.466
  -132.330    52.863   -32.907     1.510     3.687
  -132.613    52.979   -32.950     1.458     3.105
  -132.497    52.846   -37.992     1.109     1.574
  -132.399    52.830   -33.983     1.230     2.139
  -132.572    52.982   -36.464     1.405     2.758
  -132.241    52.732   -32.143     1.368     3.053
  -132.153    53.869    -3.427     1.112     1.409
  -131.607    53.871    11.213     1.536     1.757
  -132.356    54.011    -2.371     1.192     1.435
  -132.649    52.952   -54.829     1.208     2.184
  -131.961    54.250   -79.007     1.676     2.163
  -132.379    53.934    -5.225     1.569     1.950
  -132.608    52.974   -40.055     1.871     3.147
  -131.486    53.394    64.189     1.906     3.374
  -132.732    53.073   -46.037     1.449     3.000
  -132.725    53.073   -48.817     1.276     2.751
  -132.750    53.058   -46.728     1.279     2.543
  -131.742    53.762    16.313     1.314     1.837
  -132.436    53.843    69.012     2.555     3.421
  -131.604    53.876    23.513     0.770     1.147
  -131.636    53.874    69.170     1.597     2.751
  -131.596    53.871    10.024     1.290     1.916
  -131.597    53.877    27.437     1.054     2.041
  -132.445    53.949    -3.413     1.221     2.247
  -132.692    52.860    -5.873     5.916     6.521
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -132.860    52.553    41.280     1.133     1.729
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -132.838    52.553   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -132.860    52.553     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -132.860    52.553     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -132.860    52.508   5 km
EOF
gmt end
