#!/bin/bash
gmt begin fes5.6_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases fes5.6'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     3.546
     1.500    -0.295
     2.000    -4.135
     2.500    -7.976
     3.000   -11.816
     3.500   -15.657
     4.000   -19.502
     4.500   -23.346
     5.000   -27.193
     5.500   -31.041
     6.000   -34.893
     6.500   -38.746
     7.000   -42.602
     7.500   -46.462
     8.000   -50.322
     8.500   -54.188
     9.000   -58.057
     9.500   -61.930
    10.000   -65.806
    10.500   -69.687
    11.000   -73.573
    11.500   -77.463
    12.000   -81.358
    12.500   -85.257
    13.000   -89.163
    13.500   -93.074
    14.000   -96.991
    14.500  -100.913
    15.000  -104.844
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -86.163 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     2.075
     1.000     2.118
     1.500     0.467
     2.000    -1.184
     2.500    -2.835
     3.000    -4.488
     3.500    -6.142
     4.000    -7.798
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -10.798 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
    17.486    97.108     0.200
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.526    -0.766     0.200
     2.591     3.180     0.200
     2.600     0.877     0.200
     3.212     4.475     0.200
     4.327    -1.868     0.200
     5.619     2.185     0.200
     2.525     0.941     0.200
     2.882    -1.955     0.200
     2.882     2.545     0.200
     3.963    -1.213     0.200
     2.751    -2.092     0.200
     2.760    -2.886     0.200
     5.042    -1.718     0.200
     9.343    -4.043     0.200
     3.055     3.373     0.200
     2.580    -0.241     0.200
     5.588     1.993     0.200
     2.721     3.816     0.200
     4.427     7.255     0.200
    19.960    -9.198     0.200
    19.813    -8.745     0.200
    20.012   -10.731     0.200
    25.219    -0.578     0.200
     2.674    -1.571     0.200
     3.159    -2.909     0.200
     2.525    -1.476     0.200
     2.672    -1.710     0.200
     2.766    -2.540     0.200
     2.546    -0.999     0.200
     2.558     0.308     0.200
     2.794    -2.374     0.200
     3.472    -2.659     0.200
     2.817     0.445     0.200
     3.503    -2.394     0.200
     2.550    -1.329     0.200
     2.526    -1.312     0.200
     3.220    -1.929     0.200
     2.514    -1.476     0.200
     2.723    -0.085     0.200
     2.597    -2.130     0.200
     3.242    -0.855     0.200
     2.574    -0.600     0.200
     3.003    -2.199     0.200
     3.436    -0.794     0.200
     4.163    -4.332     0.200
     4.296    -0.258     0.200
     2.980    -2.196     0.200
     3.034     2.276     0.200
     2.507    -2.411     0.200
     2.547    -2.392     0.200
     3.004    -1.591     0.200
     3.345    -2.415     0.200
     3.440    -3.060     0.200
     4.161    -4.960     0.200
     4.291    -0.243     0.200
     2.703    -1.679     0.200
     2.506     0.842     0.200
     2.657    -1.816     0.200
     2.877    -1.628     0.200
     3.121    -1.918     0.200
     2.770    -1.034     0.200
     2.947    -2.890     0.200
     2.689    -1.734     0.200
     2.775    -1.337     0.200
     3.821    -2.912     0.200
     2.968     0.140     0.200
     3.629    -2.767     0.200
     4.067    -2.417     0.200
     2.494    -1.768     0.200
     3.342    -1.641     0.200
     2.902     3.754     0.200
     2.794    -1.724     0.200
     3.402     1.409     0.200
     2.719    -2.186     0.200
     2.724    -0.738     0.200
     2.814    -1.829     0.200
     2.553    -1.682     0.200
     3.038    -2.426     0.200
     2.991    -2.212     0.200
     2.768    -2.125     0.200
     2.591    -0.412     0.200
     2.758    -1.856     0.200
     3.093    -1.279     0.200
     2.737    -2.321     0.200
     3.074    -2.332     0.200
     2.748    -0.491     0.200
     2.735    -2.303     0.200
     2.626    -2.027     0.200
     2.760    -1.737     0.200
     2.873     1.493     0.200
     3.095    -2.691     0.200
     2.704    -1.774     0.200
     2.675    -1.854     0.200
     3.011    -2.278     0.200
     2.556    -1.508     0.200
     2.718    -2.194     0.200
     2.502    -1.966     0.200
     2.545    -0.105     0.200
     2.530    -0.779     0.200
     2.867    -2.401     0.200
     3.093    -2.814     0.200
     2.592    -2.580     0.200
     2.640    -1.383     0.200
     2.715    -1.537     0.200
     2.721    -3.106     0.200
     2.565    -1.396     0.200
     2.628    -1.403     0.200
     2.644    -1.597     0.200
     2.979    -2.385     0.200
     2.597    -1.427     0.200
     2.584    -2.630     0.200
     3.090    -2.410     0.200
     2.811    -1.015     0.200
     2.549    -0.618     0.200
     2.691     4.257     0.200
     3.058     1.978     0.200
     3.296     2.907     0.200
     3.588    -0.363     0.200
     2.670    -1.380     0.200
     2.763    -0.875     0.200
     3.644    -1.007     0.200
     4.111    -0.603     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.662    -9.017     0.200
     7.696   -45.582     0.200
    24.363  -174.915     0.200
     1.458     2.781     0.200
     1.474     2.272     0.200
     3.660   -16.684     0.200
     7.497   -47.336     0.200
    17.382  -114.694     0.200
     1.672    -0.578     0.200
     1.828    -3.516     0.200
     7.309   -41.073     0.200
     7.882   -46.435     0.200
    17.486  -116.892     0.200
     1.822    -5.625     0.200
     1.822    -3.625     0.200
     4.169   -21.741     0.200
     6.219   -39.232     0.200
     6.586   -43.156     0.200
     7.300   -46.792     0.200
     8.221   -54.276     0.200
     9.343   -58.942     0.200
     3.858   -18.067     0.200
     3.860   -16.327     0.200
     6.541   -37.302     0.200
     7.010   -39.674     0.200
     2.250    -4.493     0.200
     4.599   -21.982     0.200
     5.546   -29.695     0.200
     5.458   -28.408     0.200
     5.521   -30.183     0.200
     5.778   -35.346     0.200
     5.894   -35.520     0.200
     7.089   -40.887     0.200
     7.653   -45.768     0.200
     8.156   -52.716     0.200
     8.648   -56.015     0.200
     8.657   -57.116     0.200
     8.759   -57.849     0.200
     9.578   -63.298     0.200
    11.249   -78.278     0.200
    20.812  -137.831     0.200
     3.863   -18.943     0.200
     5.302   -27.949     0.200
     5.776   -32.601     0.200
     6.062   -36.646     0.200
     6.316   -37.697     0.200
     6.535   -39.667     0.200
     6.626   -39.537     0.200
     6.930   -43.184     0.200
     7.020   -42.041     0.200
     7.534   -46.331     0.200
     8.447   -53.763     0.200
     8.769   -57.459     0.200
    19.986  -139.045     0.200
    20.581  -139.901     0.200
    20.654  -143.822     0.200
    23.127  -163.617     0.200
     3.478   -18.737     0.200
     3.845   -18.365     0.200
     3.804   -18.068     0.200
     4.214   -24.660     0.200
     5.289   -32.553     0.200
     5.621   -35.555     0.200
     5.766   -35.766     0.200
     5.533   -30.872     0.200
     5.533   -28.872     0.200
     5.987   -36.856     0.200
     6.061   -38.298     0.200
     6.311   -39.832     0.200
     6.616   -43.222     0.200
     6.642   -44.036     0.200
     7.029   -45.292     0.200
     7.940   -52.170     0.200
     7.986   -53.640     0.200
     9.510   -66.453     0.200
     9.548   -61.863     0.200
    10.306   -74.269     0.200
    12.106   -83.255     0.200
    12.410   -86.890     0.200
    20.587  -139.081     0.200
    20.793  -145.632     0.200
    21.989  -155.519     0.200
     1.761    -4.140     0.200
     1.764    -4.221     0.200
     2.342    -8.547     0.200
     2.705   -10.053     0.200
     3.295   -14.260     0.200
     3.790   -19.944     0.200
     3.833   -18.806     0.200
     4.255   -23.210     0.200
     4.416   -23.811     0.200
     5.813   -35.579     0.200
     6.934   -45.919     0.200
     2.120    -3.489     0.200
     2.587    -6.810     0.200
     2.505    -6.192     0.200
     2.769   -10.962     0.200
     2.806   -10.257     0.200
     2.961   -12.345     0.200
     3.103   -12.461     0.200
     3.339   -14.756     0.200
     3.858   -18.107     0.200
     3.860   -18.454     0.200
     4.332   -22.103     0.200
     4.345   -22.843     0.200
     4.804   -25.095     0.200
     1.706    -1.156     0.200
     2.095    -3.505     0.200
     2.434    -9.231     0.200
     2.557    -8.653     0.200
     2.803    -9.934     0.200
     2.827    -9.902     0.200
     2.999   -12.039     0.200
     3.111   -14.089     0.200
     3.569   -15.228     0.200
     3.874   -18.694     0.200
     4.327   -22.266     0.200
     4.396   -20.928     0.200
     4.733   -23.126     0.200
     1.120     3.341     0.200
     1.684    -1.519     0.200
     2.369    -5.736     0.200
     2.325    -6.354     0.200
     2.841    -7.717     0.200
     2.874    -9.168     0.200
     2.988    -9.758     0.200
     3.049   -11.320     0.200
     3.291   -12.875     0.200
     3.442   -15.178     0.200
     3.535   -14.110     0.200
     3.693   -15.722     0.200
     3.813   -13.536     0.200
     4.085   -17.754     0.200
     4.102   -18.071     0.200
     4.618   -21.355     0.200
     4.861   -25.646     0.200
     5.224   -31.459     0.200
     6.000   -34.555     0.200
     6.617   -41.621     0.200
     7.019   -41.740     0.200
     1.128     1.829     0.200
     1.412    -2.153     0.200
     1.574    -2.307     0.200
     1.761    -4.228     0.200
     2.304    -9.162     0.200
     2.936   -11.784     0.200
     3.032   -11.905     0.200
     3.342   -14.731     0.200
     3.654   -18.244     0.200
     4.038   -19.400     0.200
     4.127   -22.437     0.200
     5.404   -34.699     0.200
     6.527   -40.810     0.200
     7.157   -45.687     0.200
     1.361    -0.767     0.200
     1.939    -3.598     0.200
     2.243    -5.245     0.200
     2.455    -6.453     0.200
     2.604    -9.682     0.200
     2.628    -7.952     0.200
     3.215   -11.551     0.200
     3.518   -15.662     0.200
     3.649   -15.303     0.200
     3.663   -16.253     0.200
     3.716   -14.731     0.200
     3.797   -15.999     0.200
     3.913   -17.880     0.200
     3.974   -18.620     0.200
     3.972   -19.154     0.200
     4.216   -20.380     0.200
     4.361   -21.384     0.200
     4.572   -24.252     0.200
     5.026   -25.046     0.200
     1.988    -5.346     0.200
     2.335    -8.371     0.200
     2.167    -5.723     0.200
     2.641    -9.059     0.200
     2.728   -11.018     0.200
     2.830   -11.235     0.200
     2.879   -12.202     0.200
     3.575   -19.161     0.200
     3.646   -19.428     0.200
     4.252   -21.624     0.200
     5.022   -30.336     0.200
     1.100     4.153     0.200
     1.205     1.325     0.200
     1.583    -3.171     0.200
     1.716    -2.380     0.200
     2.866    -9.424     0.200
     3.006   -11.782     0.200
     3.070   -10.300     0.200
     3.309   -13.179     0.200
     3.464   -13.683     0.200
     3.717   -16.721     0.200
     3.867   -20.553     0.200
     3.869   -20.135     0.200
     3.802   -16.991     0.200
     4.078   -21.555     0.200
     4.100   -18.967     0.200
     4.122   -19.238     0.200
     4.246   -23.780     0.200
     4.195   -20.965     0.200
     4.464   -24.595     0.200
     4.878   -25.202     0.200
     1.890    -4.452     0.200
     1.890    -2.452     0.200
     1.890    -1.452     0.200
     1.933    -3.928     0.200
     2.010    -3.250     0.200
     2.739   -12.830     0.200
     2.942   -12.501     0.200
     3.194   -14.707     0.200
     3.362   -15.506     0.200
     3.631   -17.542     0.200
     3.681   -18.636     0.200
     3.752   -19.477     0.200
     4.338   -21.157     0.200
     4.397   -23.633     0.200
     4.490   -23.468     0.200
     4.706   -24.313     0.200
     4.791   -25.407     0.200
     4.877   -25.543     0.200
     5.071   -26.988     0.200
     5.087   -26.413     0.200
     5.094   -28.219     0.200
     5.865   -33.981     0.200
     6.539   -39.947     0.200
     6.950   -43.864     0.200
     7.207   -41.504     0.200
     1.693    -3.307     0.200
     1.693    -1.807     0.200
     2.472    -7.520     0.200
     2.472    -5.520     0.200
     3.190   -14.272     0.200
     3.969   -15.972     0.200
     4.023   -18.689     0.200
     4.850   -27.082     0.200
     4.854   -27.319     0.200
     4.957   -27.297     0.200
     5.068   -27.097     0.200
     5.119   -28.725     0.200
     5.192   -29.137     0.200
     5.372   -30.640     0.200
     5.503   -32.997     0.200
     6.107   -35.242     0.200
     6.894   -42.879     0.200
     7.695   -46.892     0.200
     2.435    -9.387     0.200
     2.683   -10.258     0.200
     3.685   -20.816     0.200
     4.149   -24.645     0.200
     4.440   -23.756     0.200
     4.491   -23.788     0.200
     4.745   -24.415     0.200
     4.777   -27.753     0.200
     4.875   -27.157     0.200
     4.986   -29.661     0.200
     4.991   -29.130     0.200
     5.054   -30.724     0.200
     5.095   -29.606     0.200
     5.206   -30.428     0.200
     5.257   -31.444     0.200
     5.329   -31.442     0.200
     5.532   -30.074     0.200
     5.546   -32.627     0.200
     6.313   -36.544     0.200
     6.994   -46.630     0.200
     7.313   -50.944     0.200
     7.929   -54.469     0.200
     8.472   -55.075     0.200
     3.315   -17.557     0.200
     3.315   -15.557     0.200
     3.315   -13.557     0.200
     3.797   -23.629     0.200
     4.263   -25.688     0.200
     4.451   -25.765     0.200
     4.613   -24.986     0.200
     4.861   -29.749     0.200
     4.996   -30.124     0.200
     5.045   -32.278     0.200
     5.093   -31.901     0.200
     5.168   -33.496     0.200
     5.172   -31.230     0.200
     5.332   -31.881     0.200
     5.408   -32.986     0.200
     5.668   -36.130     0.200
     6.437   -40.912     0.200
     7.423   -51.159     0.200
     2.516    -7.304     0.200
     2.987    -9.250     0.200
     3.393   -14.380     0.200
     3.455   -14.056     0.200
     3.727   -18.169     0.200
     3.790   -17.002     0.200
     3.774   -16.982     0.200
     3.808   -14.637     0.200
     3.896   -18.350     0.200
     4.057   -19.754     0.200
     4.086   -19.791     0.200
     4.146   -20.575     0.200
     4.505   -21.649     0.200
     5.035   -27.846     0.200
     5.371   -27.927     0.200
     5.900   -32.175     0.200
     5.900   -35.023     0.200
     6.119   -36.547     0.200
     6.811   -41.708     0.200
     7.469   -45.695     0.200
     2.491   -10.231     0.200
     2.952   -13.292     0.200
     3.183   -12.515     0.200
     3.274   -12.435     0.200
     3.306   -15.336     0.200
     3.585   -15.775     0.200
     3.682   -16.899     0.200
     3.903   -19.311     0.200
     3.854   -19.153     0.200
     3.466   -14.831     0.200
     3.813   -20.055     0.200
     3.767   -19.549     0.200
     3.934   -21.155     0.200
     3.978   -21.264     0.200
     4.361   -22.586     0.200
     4.413   -21.423     0.200
     4.307   -22.176     0.200
     4.350   -23.644     0.200
     4.575   -25.756     0.200
     4.553   -24.888     0.200
     5.172   -27.431     0.200
     5.193   -30.354     0.200
     5.797   -34.943     0.200
     5.797   -35.644     0.200
     6.127   -37.328     0.200
     6.131   -39.610     0.200
     3.712   -21.031     0.200
     3.708   -18.764     0.200
     3.857   -20.388     0.200
     3.920   -20.182     0.200
     3.984   -21.226     0.200
     4.075   -21.469     0.200
     4.263   -23.506     0.200
     4.298   -23.476     0.200
     4.497   -25.987     0.200
     4.506   -25.526     0.200
     5.118   -29.173     0.200
     5.468   -33.396     0.200
     5.628   -32.336     0.200
     5.638   -35.143     0.200
     5.638   -34.891     0.200
     5.766   -34.903     0.200
     5.960   -35.759     0.200
     5.997   -37.993     0.200
     6.098   -38.842     0.200
     6.956   -46.054     0.200
     7.207   -45.383     0.200
     7.446   -47.129     0.200
     7.792   -50.942     0.200
     8.425   -57.021     0.200
     9.404   -66.236     0.200
     3.132   -10.533     0.200
     3.132    -8.533     0.200
     3.778   -17.798     0.200
     3.935   -16.583     0.200
     3.920   -16.961     0.200
     3.996   -19.578     0.200
     4.326   -22.982     0.200
     4.447   -25.112     0.200
     4.346   -20.312     0.200
     4.635   -24.394     0.200
     4.789   -24.523     0.200
     5.516   -30.187     0.200
     5.816   -35.135     0.200
     5.945   -32.824     0.200
     6.016   -36.045     0.200
     6.016   -36.339     0.200
     6.196   -36.240     0.200
     6.919   -43.129     0.200
     7.602   -47.305     0.200
     2.208    -6.408     0.200
     2.215    -8.553     0.200
     2.293    -9.841     0.200
     2.386    -7.070     0.200
     2.422    -7.620     0.200
     2.852   -11.804     0.200
     3.165   -18.214     0.200
     3.415   -19.618     0.200
     3.423   -19.585     0.200
     3.306   -15.180     0.200
     3.465   -16.142     0.200
     3.492   -16.016     0.200
     3.780   -18.720     0.200
     3.835   -18.866     0.200
     4.042   -23.699     0.200
     3.915   -19.697     0.200
     4.378   -23.016     0.200
     4.490   -25.631     0.200
     4.491   -23.602     0.200
     4.840   -31.599     0.200
     4.739   -25.648     0.200
     5.071   -32.377     0.200
     5.222   -33.898     0.200
     5.449   -35.692     0.200
     5.428   -32.767     0.200
     5.427   -31.096     0.200
     5.597   -35.772     0.200
     5.524   -32.974     0.200
     5.685   -37.283     0.200
     5.732   -38.192     0.200
     5.815   -37.740     0.200
     5.815   -37.191     0.200
     5.887   -37.599     0.200
     5.905   -35.865     0.200
     6.214   -41.643     0.200
     6.292   -41.729     0.200
     6.650   -44.875     0.200
     6.690   -41.963     0.200
     6.913   -43.228     0.200
     7.177   -48.676     0.200
     7.460   -48.897     0.200
     7.645   -53.404     0.200
     7.804   -53.451     0.200
     7.751   -50.533     0.200
     8.179   -56.715     0.200
     8.234   -56.992     0.200
     8.534   -56.327     0.200
     8.598   -57.148     0.200
     8.849   -59.138     0.200
     8.945   -60.427     0.200
     9.285   -65.060     0.200
     9.261   -61.799     0.200
     9.570   -65.878     0.200
     9.734   -67.772     0.200
    10.272   -71.394     0.200
    12.057   -84.186     0.200
    12.649   -92.550     0.200
    13.742   -99.796     0.200
    14.204  -104.740     0.200
    14.339  -107.705     0.200
    14.785  -110.348     0.200
    15.139  -114.681     0.200
     2.388    -6.414     0.200
     2.840   -10.267     0.200
     2.984   -10.880     0.200
     3.086   -10.418     0.200
     3.133   -11.016     0.200
     3.296   -13.591     0.200
     3.394   -12.935     0.200
     3.518   -13.890     0.200
     3.733   -16.643     0.200
     3.677   -15.009     0.200
     3.920   -20.436     0.200
     3.911   -19.039     0.200
     3.982   -19.913     0.200
     4.028   -18.485     0.200
     4.087   -19.272     0.200
     4.188   -20.515     0.200
     4.206   -19.619     0.200
     4.582   -25.237     0.200
     4.560   -25.223     0.200
     4.759   -23.990     0.200
     4.837   -24.390     0.200
     4.973   -26.164     0.200
     5.338   -27.753     0.200
     5.473   -30.414     0.200
     5.474   -30.056     0.200
     5.639   -31.197     0.200
     5.639   -31.594     0.200
     6.071   -39.432     0.200
     1.187     4.562     0.200
     2.617    -9.318     0.200
     2.887    -9.834     0.200
     3.560   -12.110     0.200
     3.896   -19.236     0.200
     3.708   -13.860     0.200
     4.252   -19.938     0.200
     4.480   -24.837     0.200
     4.440   -24.073     0.200
     4.918   -28.575     0.200
     0.897     4.463     0.200
     1.103     2.423     0.200
     1.392    -1.242     0.200
     3.014   -13.571     0.200
     4.096   -21.212     0.200
     4.096   -22.743     0.200
     4.084   -22.635     0.200
     4.084   -21.369     0.200
     4.154   -22.551     0.200
     4.602   -26.475     0.200
     4.602   -27.194     0.200
     4.780   -27.359     0.200
     5.173   -30.749     0.200
     1.801    -3.183     0.200
     2.452    -9.853     0.200
     2.693    -9.851     0.200
     2.836   -10.793     0.200
     3.489   -18.916     0.200
     3.489   -18.396     0.200
     3.725   -20.390     0.200
     3.725   -21.398     0.200
     3.725   -18.838     0.200
     3.742   -21.562     0.200
     4.040   -22.975     0.200
     4.040   -22.484     0.200
     4.040   -22.145     0.200
     1.643    -1.445     0.200
     2.021    -3.440     0.200
     2.700    -5.971     0.200
     2.851    -8.178     0.200
     2.851   -10.959     0.200
     3.032   -10.524     0.200
     3.032   -11.258     0.200
     3.080   -11.989     0.200
     3.276   -11.280     0.200
     3.276   -14.398     0.200
     3.378   -15.444     0.200
     3.619   -14.956     0.200
     3.704   -14.856     0.200
     3.726   -15.140     0.200
     3.952   -16.929     0.200
     3.952   -16.359     0.200
     3.995   -15.629     0.200
     4.017   -16.076     0.200
     4.094   -19.122     0.200
     4.234   -22.358     0.200
     4.262   -20.001     0.200
     4.262   -22.477     0.200
     4.609   -23.469     0.200
     4.632   -23.363     0.200
     4.713   -25.478     0.200
     4.660   -21.099     0.200
     4.660   -22.825     0.200
     4.805   -26.679     0.200
     4.805   -26.577     0.200
     4.781   -23.530     0.200
     4.781   -24.007     0.200
     4.852   -23.169     0.200
     5.284   -28.824     0.200
     5.284   -30.808     0.200
     5.314   -28.531     0.200
     5.503   -30.125     0.200
     5.607   -29.868     0.200
     5.992   -30.008     0.200
     6.202   -35.541     0.200
     6.422   -38.050     0.200
     6.422   -39.448     0.200
     6.435   -38.464     0.200
     6.435   -38.566     0.200
     6.976   -41.417     0.200
     7.124   -44.122     0.200
     7.349   -44.940     0.200
     7.858   -48.853     0.200
     7.858   -50.853     0.200
     8.142   -53.032     0.200
     8.385   -54.077     0.200
     8.494   -54.170     0.200
     8.712   -56.045     0.200
     9.696   -63.092     0.200
     9.770   -64.824     0.200
    10.083   -65.299     0.200
     1.279     3.029     0.200
     1.952    -6.735     0.200
     2.477    -9.732     0.200
     2.897   -12.141     0.200
     2.939   -13.954     0.200
     2.939   -11.313     0.200
     2.939   -13.383     0.200
     3.051   -12.682     0.200
     3.051   -12.260     0.200
     3.234   -14.553     0.200
     3.234   -13.349     0.200
     3.321   -13.882     0.200
     3.355   -12.076     0.200
     3.503   -12.675     0.200
     3.961   -19.788     0.200
     4.010   -19.897     0.200
     3.984   -17.232     0.200
     4.052   -22.506     0.200
     4.082   -19.933     0.200
     4.151   -18.069     0.200
     4.151   -18.627     0.200
     4.137   -20.972     0.200
     4.630   -27.510     0.200
     4.671   -27.929     0.200
     4.760   -26.747     0.200
     4.977   -30.450     0.200
     4.977   -29.223     0.200
     5.120   -29.844     0.200
     5.253   -31.770     0.200
     5.276   -26.942     0.200
     5.276   -27.488     0.200
     5.626   -32.229     0.200
     5.626   -31.858     0.200
     5.781   -33.087     0.200
     6.118   -38.471     0.200
     6.216   -38.590     0.200
     6.660   -43.251     0.200
     7.048   -42.672     0.200
     7.014   -44.514     0.200
     7.177   -41.115     0.200
     7.529   -49.324     0.200
     7.984   -52.190     0.200
     7.984   -50.448     0.200
     8.172   -52.875     0.200
     1.091     3.812     0.200
     2.455   -10.424     0.200
     2.899   -11.263     0.200
     3.015   -12.440     0.200
     2.894   -12.842     0.200
     2.894   -12.351     0.200
     3.080   -12.600     0.200
     3.186   -13.855     0.200
     3.281   -13.631     0.200
     3.317   -16.382     0.200
     3.474   -15.482     0.200
     3.474   -14.242     0.200
     3.943   -16.357     0.200
     4.058   -21.502     0.200
     3.964   -21.541     0.200
     4.131   -20.006     0.200
     4.065   -22.746     0.200
     4.197   -18.166     0.200
     4.707   -25.737     0.200
     4.643   -26.889     0.200
     4.695   -28.749     0.200
     4.978   -31.274     0.200
     4.978   -30.844     0.200
     5.228   -29.114     0.200
     5.228   -27.254     0.200
     6.118   -37.942     0.200
     7.526   -48.601     0.200
     1.925    -2.915     0.200
     4.264   -19.619     0.200
     4.425   -22.364     0.200
     5.204   -29.940     0.200
     5.185   -26.505     0.200
     5.335   -30.499     0.200
     5.332   -27.551     0.200
     5.523   -30.873     0.200
     5.754   -32.085     0.200
     5.854   -34.398     0.200
     5.907   -32.884     0.200
     6.024   -35.130     0.200
     6.336   -37.032     0.200
     6.344   -37.953     0.200
     7.399   -44.643     0.200
     7.467   -45.578     0.200
     7.429   -47.195     0.200
     1.283     3.315     0.200
     1.963    -3.954     0.200
     2.447    -9.320     0.200
     4.253   -19.988     0.200
     4.424   -22.097     0.200
     4.492   -22.126     0.200
     5.216   -30.254     0.200
     5.162   -26.000     0.200
     5.223   -28.948     0.200
     5.247   -26.264     0.200
     5.341   -30.467     0.200
     5.320   -28.474     0.200
     5.543   -31.743     0.200
     5.650   -32.920     0.200
     5.767   -33.151     0.200
     5.845   -33.673     0.200
     5.845   -33.341     0.200
     5.888   -32.326     0.200
     5.888   -31.388     0.200
     6.010   -35.248     0.200
     6.351   -37.653     0.200
     6.351   -39.190     0.200
     7.218   -47.242     0.200
     7.204   -43.110     0.200
     7.475   -47.583     0.200
     7.419   -48.044     0.200
     7.419   -47.076     0.200
     7.419   -47.523     0.200
     8.035   -50.930     0.200
     8.035   -49.449     0.200
     8.919   -58.275     0.200
     9.501   -62.767     0.200
     9.501   -62.185     0.200
     9.546   -64.006     0.200
     9.546   -64.725     0.200
     1.395     1.244     0.200
     2.897   -10.375     0.200
     3.347   -12.634     0.200
     3.554   -13.759     0.200
     4.878   -26.529     0.200
     4.889   -25.909     0.200
     5.162   -27.440     0.200
     5.359   -30.901     0.200
     5.450   -31.284     0.200
     5.911   -35.537     0.200
     6.060   -35.741     0.200
     7.051   -44.548     0.200
     1.792    -2.953     0.200
     2.610    -7.361     0.200
     3.096   -10.792     0.200
     3.696   -18.646     0.200
     3.842   -18.877     0.200
     4.131   -22.543     0.200
     4.150   -19.568     0.200
     4.343   -21.245     0.200
     4.505   -22.097     0.200
     4.621   -23.800     0.200
     4.725   -23.521     0.200
     4.759   -23.651     0.200
     4.864   -27.990     0.200
     5.077   -30.048     0.200
     5.119   -29.119     0.200
     5.387   -28.022     0.200
     5.387   -26.811     0.200
     5.448   -31.707     0.200
     5.515   -32.051     0.200
     5.560   -31.241     0.200
     5.560   -29.788     0.200
     5.645   -33.570     0.200
     6.141   -37.870     0.200
     6.157   -36.301     0.200
     6.249   -36.331     0.200
     6.660   -38.431     0.200
     6.660   -35.658     0.200
     6.847   -41.284     0.200
     7.008   -46.813     0.200
     7.008   -44.344     0.200
     7.280   -47.124     0.200
     7.278   -47.052     0.200
     7.833   -51.039     0.200
     7.872   -50.943     0.200
     7.942   -52.072     0.200
     8.205   -53.320     0.200
     9.191   -60.799     0.200
     9.241   -62.630     0.200
     9.350   -63.147     0.200
     9.747   -66.408     0.200
    10.538   -72.084     0.200
    10.580   -70.842     0.200
    10.654   -73.227     0.200
    10.826   -71.911     0.200
    10.855   -72.448     0.200
    10.892   -72.445     0.200
    15.246  -107.934     0.200
    15.654  -112.082     0.200
     0.923     4.350     0.200
     0.979     3.575     0.200
     1.277     1.144     0.200
     1.266     2.492     0.200
     1.695    -2.108     0.200
     2.386    -8.042     0.200
     2.952   -11.001     0.200
     2.984   -13.994     0.200
     3.027   -12.991     0.200
     3.135   -14.776     0.200
     3.337   -13.911     0.200
     3.337   -12.060     0.200
     3.676   -16.488     0.200
     3.822   -21.029     0.200
     3.929   -22.115     0.200
     4.036   -17.954     0.200
     4.072   -18.865     0.200
     4.221   -24.400     0.200
     4.382   -24.600     0.200
     4.506   -24.487     0.200
     4.694   -24.584     0.200
     4.731   -24.895     0.200
     4.731   -25.762     0.200
     4.941   -29.636     0.200
     5.638   -32.962     0.200
     6.067   -38.712     0.200
     6.086   -34.845     0.200
     0.991     4.044     0.200
     4.753   -25.173     0.200
     5.177   -28.993     0.200
     5.635   -30.216     0.200
     6.054   -37.562     0.200
     6.141   -37.992     0.200
     6.512   -39.220     0.200
     7.158   -47.060     0.200
     0.983     3.440     0.200
     3.248   -16.347     0.200
     4.018   -21.897     0.200
     4.084   -23.985     0.200
     4.556   -27.115     0.200
     4.743   -26.234     0.200
     5.102   -31.856     0.200
     5.102   -29.024     0.200
     5.611   -34.239     0.200
     1.191     3.634     0.200
     2.733    -9.728     0.200
     4.513   -21.036     0.200
     4.673   -25.148     0.200
     4.934   -25.283     0.200
     5.808   -37.567     0.200
     5.894   -36.864     0.200
     5.932   -35.544     0.200
     6.172   -37.867     0.200
     6.212   -33.035     0.200
     6.279   -37.329     0.200
     6.367   -38.319     0.200
     6.959   -42.293     0.200
     7.115   -44.751     0.200
     7.840   -51.721     0.200
     8.044   -52.188     0.200
     1.037     2.674     0.200
     1.762    -4.581     0.200
     1.766    -4.743     0.200
     2.147    -6.366     0.200
     2.266    -6.279     0.200
     2.274    -8.854     0.200
     2.741   -11.519     0.200
     2.998   -12.478     0.200
     3.090   -14.819     0.200
     3.752   -15.219     0.200
     3.752   -16.606     0.200
     3.821   -21.570     0.200
     3.875   -19.514     0.200
     3.946   -22.809     0.200
     4.831   -29.115     0.200
     5.041   -28.816     0.200
     1.054     2.116     0.200
     1.166    -0.427     0.200
     1.809    -5.808     0.200
     2.001    -5.900     0.200
     2.240    -9.920     0.200
     2.280   -10.133     0.200
     2.267    -7.331     0.200
     2.566    -9.819     0.200
     3.031   -14.120     0.200
     3.114   -15.065     0.200
     3.777   -16.910     0.200
     3.806   -20.713     0.200
     3.883   -20.775     0.200
     3.922   -22.572     0.200
     4.817   -29.642     0.200
     1.897    -3.125     0.200
     4.077   -20.715     0.200
     4.234   -25.850     0.200
     4.288   -25.813     0.200
     4.711   -29.272     0.200
     4.684   -27.252     0.200
     4.772   -27.135     0.200
     5.308   -33.008     0.200
     5.525   -33.927     0.200
     6.285   -41.499     0.200
     2.509   -11.652     0.200
     2.510    -7.690     0.200
     3.290   -10.920     0.200
     3.899   -18.711     0.200
     4.128   -21.390     0.200
     4.374   -23.005     0.200
     4.520   -23.401     0.200
     5.257   -26.121     0.200
     5.537   -29.644     0.200
     5.667   -31.771     0.200
     5.755   -34.557     0.200
     5.796   -35.871     0.200
     5.922   -37.307     0.200
     6.300   -34.765     0.200
     6.499   -40.150     0.200
     6.539   -40.305     0.200
     6.800   -44.569     0.200
     6.984   -45.332     0.200
     7.104   -46.516     0.200
     7.123   -44.738     0.200
     7.933   -51.513     0.200
     1.333     1.806     0.200
     2.252    -3.811     0.200
     2.927   -10.227     0.200
     3.377   -12.482     0.200
     3.391   -14.375     0.200
     3.536   -14.813     0.200
     3.866   -17.466     0.200
     4.011   -19.710     0.200
     4.394   -21.957     0.200
     4.394   -20.027     0.200
     4.770   -26.846     0.200
     4.872   -27.183     0.200
     4.879   -26.540     0.200
     5.143   -28.681     0.200
     5.359   -31.295     0.200
     5.445   -31.634     0.200
     5.902   -35.606     0.200
     6.143   -36.948     0.200
     7.042   -43.963     0.200
     2.108    -5.513     0.200
     2.350    -6.157     0.200
     2.442    -7.102     0.200
     2.455    -6.514     0.200
     2.537    -7.110     0.200
     2.626    -8.935     0.200
     2.724   -10.800     0.200
     2.725   -10.855     0.200
     3.096   -12.834     0.200
     3.241   -11.415     0.200
     3.345   -14.097     0.200
     3.651   -17.410     0.200
     4.071   -22.002     0.200
     4.146   -18.098     0.200
     4.203   -20.844     0.200
     4.211   -20.625     0.200
     4.284   -17.470     0.200
     4.308   -21.359     0.200
     4.400   -21.350     0.200
     4.485   -22.204     0.200
     4.550   -23.902     0.200
     4.582   -22.297     0.200
     4.653   -21.196     0.200
     5.192   -26.932     0.200
     5.537   -31.211     0.200
     5.542   -30.792     0.200
     5.606   -33.198     0.200
     5.746   -33.713     0.200
     5.799   -32.514     0.200
     5.859   -35.601     0.200
     5.877   -35.421     0.200
     5.880   -35.874     0.200
     6.072   -35.127     0.200
     6.233   -35.844     0.200
     6.260   -39.520     0.200
     6.285   -39.624     0.200
     6.454   -40.072     0.200
     6.500   -40.736     0.200
     6.649   -38.363     0.200
     6.748   -41.527     0.200
     6.938   -41.810     0.200
     7.054   -44.103     0.200
     7.055   -42.368     0.200
     7.079   -44.566     0.200
     7.529   -46.398     0.200
     7.700   -54.129     0.200
     7.860   -50.340     0.200
     7.881   -51.007     0.200
     8.411   -54.211     0.200
     8.809   -58.108     0.200
     8.793   -54.262     0.200
     8.887   -54.600     0.200
     8.979   -58.316     0.200
     9.267   -61.352     0.200
     9.522   -62.222     0.200
     9.652   -63.404     0.200
     9.913   -66.259     0.200
    10.842   -72.554     0.200
     1.087     4.175     0.200
     1.312     3.039     0.200
     1.578    -0.934     0.200
     1.582    -1.017     0.200
     2.032    -4.964     0.200
     2.173    -5.254     0.200
     2.372    -9.115     0.200
     2.692    -9.232     0.200
     2.834   -10.319     0.200
     2.834   -11.469     0.200
     2.931   -10.380     0.200
     2.931   -11.772     0.200
     2.933   -11.117     0.200
     2.922    -8.734     0.200
     2.922    -9.426     0.200
     3.076   -11.105     0.200
     3.123   -11.278     0.200
     3.259   -13.667     0.200
     3.729   -14.892     0.200
     3.729   -12.812     0.200
     4.017   -20.413     0.200
     4.017   -20.805     0.200
     4.179   -21.317     0.200
     4.199   -23.500     0.200
     4.200   -23.514     0.200
     4.216   -18.020     0.200
     4.554   -20.740     0.200
     4.666   -26.981     0.200
     4.667   -27.122     0.200
     4.753   -27.053     0.200
     4.966   -24.970     0.200
     4.866   -28.746     0.200
     5.016   -27.817     0.200
     5.275   -31.285     0.200
     5.328   -30.877     0.200
     5.378   -30.871     0.200
     6.149   -37.107     0.200
     7.077   -43.412     0.200
     7.257   -44.439     0.200
     1.227     1.627     0.200
     1.324     1.555     0.200
     2.105    -4.213     0.200
     2.645    -8.304     0.200
     2.822   -11.930     0.200
     2.918   -10.967     0.200
     3.311   -15.412     0.200
     3.610   -18.075     0.200
     3.552   -16.560     0.200
     3.727   -21.282     0.200
     3.727   -18.231     0.200
     4.058   -24.340     0.200
     4.058   -20.942     0.200
     4.191   -23.355     0.200
     4.191   -21.340     0.200
     4.311   -21.552     0.200
     4.373   -22.342     0.200
     4.454   -22.370     0.200
     4.574   -24.623     0.200
     4.763   -27.883     0.200
     4.763   -25.379     0.200
     4.946   -29.556     0.200
     5.012   -30.546     0.200
     5.054   -32.515     0.200
     5.054   -29.155     0.200
     5.068   -29.221     0.200
     5.235   -30.917     0.200
     5.296   -31.660     0.200
     5.296   -31.460     0.200
     5.234   -29.292     0.200
     5.334   -33.046     0.200
     5.334   -30.542     0.200
     5.426   -31.768     0.200
     5.528   -32.900     0.200
     5.538   -34.333     0.200
     5.626   -34.513     0.200
     6.091   -37.743     0.200
     6.135   -37.844     0.200
     6.329   -39.985     0.200
     6.886   -46.149     0.200
     6.886   -42.911     0.200
     6.958   -43.248     0.200
     7.231   -47.378     0.200
     8.339   -53.533     0.200
     8.662   -58.167     0.200
     9.169   -63.478     0.200
     9.169   -61.037     0.200
     9.300   -62.695     0.200
     1.038     2.423     0.200
     1.168     3.806     0.200
     1.594    -3.197     0.200
     2.562   -13.555     0.200
     2.865   -15.344     0.200
     4.200   -25.877     0.200
     4.351   -25.629     0.200
     4.363   -27.874     0.200
     4.367   -27.420     0.200
     4.695   -29.022     0.200
     4.816   -29.658     0.200
     0.943     6.179     0.200
     2.154    -4.686     0.200
     3.904   -19.039     0.200
     3.878   -20.036     0.200
     3.908   -20.046     0.200
     4.084   -19.452     0.200
     4.084   -20.172     0.200
     4.275   -16.326     0.200
     4.236   -22.031     0.200
     4.174   -19.342     0.200
     4.375   -24.412     0.200
     4.438   -24.698     0.200
     4.483   -24.523     0.200
     4.926   -26.777     0.200
     5.169   -29.073     0.200
     1.029     5.058     0.200
     1.116     2.298     0.200
     1.276     2.207     0.200
     1.752    -3.290     0.200
     1.756    -3.400     0.200
     2.141    -6.924     0.200
     2.255    -6.815     0.200
     2.283    -8.787     0.200
     2.709   -11.109     0.200
     2.756   -10.822     0.200
     2.997   -12.195     0.200
     3.092   -14.132     0.200
     3.754   -13.863     0.200
     3.754   -17.574     0.200
     3.837   -21.133     0.200
     3.883   -19.799     0.200
     3.964   -23.451     0.200
     3.974   -22.806     0.200
     4.329   -25.075     0.200
     4.412   -25.693     0.200
     4.540   -26.462     0.200
     4.623   -27.479     0.200
     4.846   -28.811     0.200
     5.022   -30.136     0.200
     5.039   -26.962     0.200
     5.142   -31.035     0.200
     5.418   -30.141     0.200
     0.885     2.819     0.200
     1.170    -2.228     0.200
     1.657    -3.783     0.200
     1.667    -4.992     0.200
     1.669    -5.046     0.200
     2.155    -8.380     0.200
     2.203   -11.383     0.200
     2.226    -6.692     0.200
     2.407   -11.298     0.200
     2.449   -10.760     0.200
     2.598   -10.748     0.200
     2.627   -11.945     0.200
     2.435    -8.328     0.200
     2.681   -12.634     0.200
     2.688    -9.942     0.200
     3.121   -14.473     0.200
     3.404   -20.776     0.200
     3.438   -16.498     0.200
     3.476   -18.925     0.200
     3.549   -20.527     0.200
     3.597   -20.557     0.200
     3.626   -21.953     0.200
     3.624   -21.880     0.200
     3.588   -17.888     0.200
     3.824   -23.140     0.200
     3.908   -22.905     0.200
     3.779   -19.930     0.200
     3.943   -23.232     0.200
     3.997   -24.037     0.200
     4.094   -24.820     0.200
     4.092   -18.382     0.200
     4.165   -24.856     0.200
     4.201   -25.209     0.200
     4.172   -22.719     0.200
     4.104   -22.233     0.200
     4.308   -22.945     0.200
     4.646   -30.166     0.200
     4.705   -29.094     0.200
     4.705   -28.794     0.200
     4.740   -30.180     0.200
     4.817   -29.333     0.200
     4.887   -30.158     0.200
     5.038   -31.801     0.200
     5.463   -31.503     0.200
     5.563   -34.281     0.200
     5.571   -34.655     0.200
     5.571   -36.280     0.200
     5.571   -35.763     0.200
     5.504   -32.596     0.200
     5.786   -38.351     0.200
     5.821   -37.343     0.200
     6.338   -40.261     0.200
     6.486   -44.806     0.200
     6.715   -43.790     0.200
     7.001   -45.972     0.200
     7.135   -45.990     0.200
     7.218   -48.150     0.200
     7.285   -48.962     0.200
     7.602   -51.012     0.200
     7.737   -53.633     0.200
     7.856   -54.226     0.200
     9.047   -64.533     0.200
     9.086   -64.898     0.200
     9.128   -63.673     0.200
     9.258   -63.414     0.200
     9.485   -65.209     0.200
     9.490   -65.076     0.200
     9.508   -66.187     0.200
     9.545   -63.683     0.200
     9.916   -67.582     0.200
    11.735   -82.243     0.200
    12.181   -84.862     0.200
    12.314   -86.579     0.200
    13.014   -92.076     0.200
    13.778  -100.901     0.200
    14.178  -101.968     0.200
    14.184  -103.058     0.200
     1.028     5.612     0.200
     1.278     4.182     0.200
     2.301    -3.240     0.200
     2.610    -9.532     0.200
     2.610    -8.032     0.200
     4.640   -23.400     0.200
     5.315   -29.384     0.200
     5.412   -30.655     0.200
     5.484   -31.608     0.200
     5.505   -30.723     0.200
     5.505   -31.223     0.200
     5.584   -31.724     0.200
     5.837   -33.344     0.200
     5.837   -33.844     0.200
     6.001   -33.045     0.200
     6.018   -34.929     0.200
     6.031   -35.502     0.200
     6.600   -40.105     0.200
     6.630   -39.570     0.200
     6.795   -39.822     0.200
     7.729   -48.106     0.200
     7.729   -48.406     0.200
     1.449     0.984     0.200
     1.844    -2.525     0.200
     2.206    -6.009     0.200
     2.381    -5.559     0.200
     2.357    -6.789     0.200
     2.790    -9.790     0.200
     2.757    -9.478     0.200
     2.950    -9.597     0.200
     3.149   -13.881     0.200
     3.346   -13.669     0.200
     3.345   -13.523     0.200
     3.384   -13.330     0.200
     3.469   -18.187     0.200
     3.703   -16.241     0.200
     3.794   -18.036     0.200
     3.850   -16.121     0.200
     3.954   -19.156     0.200
     4.068   -18.643     0.200
     4.124   -18.403     0.200
     4.232   -18.703     0.200
     4.337   -19.103     0.200
     4.372   -22.374     0.200
     4.510   -22.610     0.200
     4.579   -25.690     0.200
     4.538   -21.924     0.200
     4.571   -24.564     0.200
     4.567   -22.856     0.200
     4.697   -25.562     0.200
     4.759   -26.229     0.200
     4.798   -27.888     0.200
     4.806   -25.703     0.200
     4.806   -28.031     0.200
     4.963   -29.111     0.200
     4.905   -24.545     0.200
     5.000   -27.765     0.200
     4.998   -26.413     0.200
     5.056   -28.249     0.200
     5.077   -28.808     0.200
     5.158   -24.822     0.200
     5.178   -27.740     0.200
     5.277   -29.642     0.200
     5.286   -29.739     0.200
     5.371   -30.032     0.200
     5.635   -32.684     0.200
     5.723   -31.969     0.200
     5.828   -34.566     0.200
     5.879   -35.221     0.200
     5.879   -34.628     0.200
     5.939   -31.943     0.200
     5.982   -34.610     0.200
     6.069   -36.147     0.200
     6.271   -33.160     0.200
     6.464   -40.391     0.200
     6.555   -40.354     0.200
     6.628   -44.170     0.200
     6.628   -44.045     0.200
     6.631   -41.675     0.200
     6.631   -41.097     0.200
     6.633   -41.125     0.200
     6.711   -40.693     0.200
     6.890   -38.058     0.200
     6.968   -44.366     0.200
     6.997   -43.591     0.200
     7.520   -47.462     0.200
     7.520   -48.564     0.200
     7.570   -47.326     0.200
     7.897   -50.614     0.200
     8.099   -51.242     0.200
     8.176   -51.663     0.200
     8.176   -47.847     0.200
     8.169   -54.842     0.200
     8.879   -59.346     0.200
     8.905   -60.080     0.200
     8.960   -59.068     0.200
     9.038   -61.212     0.200
     8.996   -54.618     0.200
     9.399   -62.234     0.200
     9.385   -59.034     0.200
     9.858   -62.863     0.200
    10.064   -66.960     0.200
    10.066   -65.500     0.200
    10.116   -69.350     0.200
    10.147   -65.930     0.200
    10.180   -70.145     0.200
    10.205   -67.901     0.200
    10.237   -66.150     0.200
    10.240   -66.330     0.200
    10.268   -71.049     0.200
    10.235   -70.484     0.200
    10.320   -70.056     0.200
    10.448   -70.580     0.200
    10.451   -68.633     0.200
    10.469   -67.632     0.200
    10.506   -69.369     0.200
    10.606   -74.010     0.200
    11.458   -79.837     0.200
    11.745   -82.751     0.200
    12.247   -87.490     0.200
    12.682   -85.876     0.200
    13.076   -87.295     0.200
    13.241   -89.798     0.200
    14.023   -99.797     0.200
    14.776  -103.875     0.200
    15.264  -109.944     0.200
    15.285  -113.005     0.200
    15.613  -113.613     0.200
    15.936  -116.947     0.200
    16.037  -116.749     0.200
    22.532  -157.337     0.200
     0.809     4.914     0.200
     1.204     3.387     0.200
     2.389    -9.264     0.200
     2.681   -10.765     0.200
     3.338   -14.549     0.200
     3.685   -20.567     0.200
     3.707   -20.213     0.200
     3.724   -21.278     0.200
     3.743   -21.352     0.200
     3.680   -14.081     0.200
     3.853   -19.426     0.200
     3.853   -22.668     0.200
     3.991   -21.993     0.200
     4.068   -21.487     0.200
     4.096   -21.673     0.200
     4.185   -24.587     0.200
     4.728   -27.774     0.200
     4.819   -28.890     0.200
     4.939   -29.297     0.200
     1.269     3.494     0.200
     1.571    -1.095     0.200
     2.099    -4.838     0.200
     2.455    -5.121     0.200
     2.529    -8.465     0.200
     4.577   -26.799     0.200
     4.794   -27.651     0.200
     5.118   -27.813     0.200
     5.118   -30.423     0.200
     5.446   -32.814     0.200
     5.546   -33.601     0.200
     5.623   -32.934     0.200
     5.622   -33.369     0.200
     5.718   -33.151     0.200
     5.732   -34.603     0.200
     5.960   -35.709     0.200
     6.009   -36.448     0.200
     6.176   -35.262     0.200
     6.176   -38.761     0.200
     6.178   -37.152     0.200
     6.178   -38.949     0.200
     6.693   -41.952     0.200
     6.745   -41.673     0.200
     6.937   -42.674     0.200
     7.456   -47.341     0.200
     7.873   -50.051     0.200
     2.578    -8.991     0.200
     2.891    -8.916     0.200
     3.013   -11.776     0.200
     3.018   -11.932     0.200
     3.335   -14.976     0.200
     4.616   -25.285     0.200
     4.857   -28.003     0.200
     4.985   -27.617     0.200
     5.478   -33.617     0.200
     5.468   -31.655     0.200
     5.468   -30.709     0.200
     5.588   -34.793     0.200
     5.598   -34.722     0.200
     5.701   -34.888     0.200
     5.693   -35.212     0.200
     5.786   -33.118     0.200
     5.863   -37.408     0.200
     5.845   -33.391     0.200
     5.946   -36.147     0.200
     6.231   -39.779     0.200
     6.223   -38.495     0.200
     6.287   -40.754     0.200
     6.441   -40.977     0.200
     6.510   -40.650     0.200
     6.621   -42.317     0.200
     6.716   -43.054     0.200
     6.748   -42.986     0.200
     6.798   -43.856     0.200
     6.863   -45.277     0.200
     7.022   -44.158     0.200
     7.420   -47.175     0.200
     7.559   -49.877     0.200
     7.829   -48.899     0.200
     7.975   -53.073     0.200
     8.018   -53.082     0.200
     8.536   -58.152     0.200
     9.265   -63.462     0.200
    10.040   -69.961     0.200
    10.040   -70.445     0.200
    10.032   -69.950     0.200
    11.429   -79.367     0.200
     2.273    -5.579     0.200
     3.852   -21.207     0.200
     4.607   -25.836     0.200
     4.772   -28.531     0.200
     5.193   -30.978     0.200
     5.342   -32.561     0.200
     5.452   -33.051     0.200
     5.502   -32.982     0.200
     5.488   -33.094     0.200
     5.537   -34.101     0.200
     5.591   -33.675     0.200
     5.678   -36.026     0.200
     5.835   -35.687     0.200
     6.084   -37.580     0.200
     6.112   -37.772     0.200
     6.199   -38.506     0.200
     6.236   -37.200     0.200
     6.363   -39.063     0.200
     6.601   -42.294     0.200
     6.661   -40.989     0.200
     6.685   -42.982     0.200
     6.860   -43.294     0.200
     7.305   -46.105     0.200
     7.389   -47.949     0.200
     7.773   -52.504     0.200
     7.805   -51.060     0.200
     8.366   -55.422     0.200
     9.082   -60.418     0.200
     9.842   -67.482     0.200
     1.351     2.467     0.200
     1.686    -2.142     0.200
     2.001    -2.631     0.200
     2.264    -6.470     0.200
     2.613    -6.553     0.200
     3.620   -15.948     0.200
     5.560   -33.647     0.200
     6.708   -43.059     0.200
     1.995    -2.430     0.200
     2.361    -4.524     0.200
     2.581    -8.503     0.200
     2.715    -7.766     0.200
     5.370   -32.201     0.200
     5.468   -33.117     0.200
     5.541   -32.480     0.200
     5.555   -32.789     0.200
     5.648   -32.927     0.200
     5.645   -31.876     0.200
     5.889   -34.265     0.200
     6.083   -36.230     0.200
     6.091   -36.570     0.200
     6.614   -39.939     0.200
     6.660   -39.316     0.200
     1.947    -3.728     0.200
     3.224   -12.206     0.200
     4.766   -27.503     0.200
     4.836   -28.213     0.200
     4.883   -28.142     0.200
     4.911   -28.356     0.200
     5.110   -30.109     0.200
     5.223   -30.477     0.200
     5.343   -31.778     0.200
     5.933   -36.986     0.200
     1.648     0.360     0.200
     2.908   -11.457     0.200
     2.908    -9.465     0.200
     3.390   -13.332     0.200
     3.573   -13.775     0.200
     3.573   -13.353     0.200
     4.218   -18.827     0.200
     4.333   -18.611     0.200
     4.483   -21.055     0.200
     4.483   -20.094     0.200
     4.531   -22.988     0.200
     4.672   -25.910     0.200
     4.811   -21.330     0.200
     5.026   -27.505     0.200
     5.407   -26.052     0.200
     5.537   -29.857     0.200
     5.537   -31.510     0.200
     1.183     5.083     0.200
     1.537    -0.142     0.200
     3.075   -10.903     0.200
     3.646   -13.991     0.200
     3.961   -16.967     0.200
     4.173   -17.705     0.200
     4.319   -18.717     0.200
     4.379   -22.408     0.200
     4.527   -20.856     0.200
     5.368   -31.871     0.200
     5.422   -32.189     0.200
     5.422   -29.627     0.200
     5.422   -32.477     0.200
     5.451   -32.783     0.200
     5.451   -29.187     0.200
     5.505   -31.348     0.200
     5.505   -28.079     0.200
     5.560   -31.363     0.200
     5.687   -31.201     0.200
     5.687   -30.883     0.200
     6.443   -39.301     0.200
     6.443   -35.864     0.200
     6.530   -39.617     0.200
     6.702   -41.275     0.200
     1.150     1.621     0.200
     4.001   -22.108     0.200
     4.075   -23.511     0.200
     4.359   -25.276     0.200
     4.565   -26.704     0.200
     5.092   -32.166     0.200
     5.171   -29.502     0.200
     5.315   -28.179     0.200
     5.282   -30.329     0.200
     5.568   -32.386     0.200
     5.947   -36.005     0.200
     6.491   -39.334     0.200
     7.223   -45.456     0.200
     1.813    -2.219     0.200
     5.185   -29.503     0.200
     5.280   -30.910     0.200
     5.350   -32.138     0.200
     5.447   -33.218     0.200
     5.880   -35.711     0.200
     5.895   -35.708     0.200
     6.462   -39.505     0.200
     1.559    -1.420     0.200
     1.976    -2.630     0.200
     3.077   -13.492     0.200
     4.034   -22.181     0.200
     4.109   -22.957     0.200
     4.162   -23.443     0.200
     4.222   -21.867     0.200
     4.422   -25.361     0.200
     4.479   -25.921     0.200
     4.678   -27.096     0.200
     4.666   -27.769     0.200
     4.666   -25.909     0.200
     5.241   -30.712     0.200
     5.241   -30.243     0.200
     1.268     2.360     0.200
     1.563    -2.983     0.200
     1.990    -4.511     0.200
     2.173    -4.320     0.200
     2.314    -8.273     0.200
     2.853   -10.464     0.200
     2.853   -12.464     0.200
     2.877    -9.639     0.200
     3.071   -12.204     0.200
     3.256   -15.234     0.200
     3.309   -15.346     0.200
     3.345   -15.383     0.200
     3.707   -17.525     0.200
     3.784   -17.285     0.200
     4.022   -21.533     0.200
     4.097   -22.915     0.200
     4.151   -24.097     0.200
     4.151   -23.737     0.200
     4.061   -19.210     0.200
     4.061   -20.042     0.200
     4.079   -18.931     0.200
     4.095   -18.038     0.200
     4.141   -20.567     0.200
     4.212   -22.795     0.200
     4.212   -24.087     0.200
     4.297   -23.765     0.200
     4.297   -25.275     0.200
     4.297   -24.385     0.200
     4.361   -23.473     0.200
     4.409   -25.211     0.200
     4.463   -23.925     0.200
     4.471   -25.345     0.200
     4.594   -26.755     0.200
     4.658   -27.567     0.200
     4.668   -27.506     0.200
     4.717   -27.782     0.200
     4.660   -26.834     0.200
     4.743   -23.555     0.200
     4.743   -24.435     0.200
     4.836   -26.572     0.200
     4.947   -24.013     0.200
     4.947   -25.412     0.200
     5.230   -31.033     0.200
     5.231   -31.346     0.200
     5.258   -31.905     0.200
     5.445   -32.629     0.200
     5.690   -32.964     0.200
     5.790   -33.196     0.200
     5.949   -37.627     0.200
     5.972   -37.735     0.200
     5.972   -38.586     0.200
     6.031   -36.716     0.200
     6.031   -38.747     0.200
     6.043   -37.343     0.200
     6.096   -34.495     0.200
     6.235   -40.187     0.200
     6.235   -41.096     0.200
     6.355   -37.879     0.200
     6.450   -42.877     0.200
     6.450   -41.257     0.200
     7.147   -47.352     0.200
     7.607   -48.391     0.200
     7.607   -49.831     0.200
     7.968   -52.459     0.200
     7.981   -50.329     0.200
     8.354   -55.293     0.200
     8.438   -56.230     0.200
     8.540   -57.700     0.200
     9.138   -58.928     0.200
     9.692   -66.068     0.200
     9.789   -66.271     0.200
     9.896   -65.793     0.200
     9.921   -66.367     0.200
    10.115   -69.113     0.200
    10.149   -68.864     0.200
    10.151   -69.032     0.200
    10.172   -69.292     0.200
    10.201   -69.184     0.200
    10.573   -70.986     0.200
     1.457     1.346     0.200
     2.413    -5.937     0.200
     5.194   -27.502     0.200
     5.298   -28.122     0.200
     5.360   -28.880     0.200
     5.360   -30.896     0.200
     5.379   -28.899     0.200
     5.379   -29.665     0.200
     5.458   -29.179     0.200
     5.504   -29.328     0.200
     5.504   -31.352     0.200
     5.590   -30.453     0.200
     5.700   -31.256     0.200
     5.811   -31.703     0.200
     5.811   -30.859     0.200
     5.943   -33.355     0.200
     6.001   -32.871     0.200
     6.515   -38.606     0.200
     6.697   -37.668     0.200
     7.222   -42.787     0.200
     1.401     2.212     0.200
     1.833    -1.494     0.200
     3.327   -14.853     0.200
     3.791   -18.244     0.200
     3.979   -20.141     0.200
     3.979   -21.399     0.200
     4.362   -19.980     0.200
     4.362   -18.948     0.200
     4.526   -22.820     0.200
     4.526   -21.460     0.200
     4.674   -25.646     0.200
     4.739   -26.305     0.200
     4.796   -26.665     0.200
     4.969   -29.027     0.200
     4.969   -27.113     0.200
     5.028   -30.138     0.200
     5.028   -28.271     0.200
     5.057   -28.488     0.200
     5.088   -28.544     0.200
     5.265   -30.407     0.200
     5.259   -29.485     0.200
     5.352   -30.853     0.200
     5.662   -33.176     0.200
     5.819   -35.322     0.200
     5.861   -34.684     0.200
     6.055   -35.635     0.200
     6.544   -39.140     0.200
     6.646   -40.445     0.200
     6.958   -42.572     0.200
     6.982   -44.990     0.200
     8.172   -53.359     0.200
     8.903   -59.822     0.200
     0.954     3.967     0.200
     1.965    -4.090     0.200
     4.180   -22.696     0.200
     4.466   -26.718     0.200
     4.669   -24.525     0.200
     5.252   -31.477     0.200
     5.334   -31.875     0.200
     5.391   -32.419     0.200
     5.447   -33.954     0.200
     5.567   -32.780     0.200
     5.642   -33.747     0.200
     5.804   -35.393     0.200
     5.787   -34.670     0.200
     5.907   -35.556     0.200
     5.956   -36.115     0.200
     6.238   -38.334     0.200
     6.468   -40.668     0.200
     6.686   -41.245     0.200
     7.031   -43.469     0.200
     7.188   -45.869     0.200
     7.254   -44.950     0.200
     7.254   -47.653     0.200
     7.604   -49.845     0.200
     7.660   -51.255     0.200
     8.836   -58.007     0.200
     8.836   -58.815     0.200
     9.575   -63.927     0.200
     4.290   -23.809     0.200
     5.263   -29.807     0.200
     5.353   -29.768     0.200
     5.419   -31.086     0.200
     5.475   -31.094     0.200
     5.500   -32.091     0.200
     5.656   -33.257     0.200
     5.894   -35.301     0.200
     5.953   -35.681     0.200
     6.246   -36.063     0.200
     6.518   -39.688     0.200
     6.724   -41.015     0.200
     7.234   -45.000     0.200
     2.593    -7.305     0.200
     4.610   -22.675     0.200
     5.346   -31.169     0.200
     5.456   -31.954     0.200
     5.493   -31.005     0.200
     5.493   -32.029     0.200
     5.542   -32.356     0.200
     5.596   -32.283     0.200
     5.682   -35.018     0.200
     5.743   -33.943     0.200
     6.088   -36.685     0.200
     6.116   -36.567     0.200
     6.202   -37.598     0.200
     6.316   -38.813     0.200
     6.689   -41.224     0.200
     6.864   -41.793     0.200
     7.166   -44.262     0.200
     5.421   -31.732     0.200
     5.504   -31.654     0.200
     5.562   -33.114     0.200
     5.618   -31.991     0.200
     5.812   -34.007     0.200
     6.059   -38.006     0.200
     6.078   -35.755     0.200
     6.639   -40.075     0.200
     1.413    -1.512     0.200
     2.043    -4.483     0.200
     2.524   -10.437     0.200
     2.938   -10.316     0.200
     3.164   -12.599     0.200
     3.368   -14.715     0.200
     3.988   -19.760     0.200
     4.010   -22.320     0.200
     4.105   -16.445     0.200
     4.041   -22.723     0.200
     4.169   -19.726     0.200
     4.374   -24.568     0.200
     4.403   -24.095     0.200
     4.403   -23.962     0.200
     4.428   -24.888     0.200
     4.472   -25.779     0.200
     5.007   -28.775     0.200
     4.989   -28.667     0.200
     5.277   -31.306     0.200
     1.319    -1.133     0.200
     3.135   -13.756     0.200
     3.307   -14.230     0.200
     4.050   -21.985     0.200
     4.106   -24.385     0.200
     4.131   -23.786     0.200
     4.136   -25.139     0.200
     4.171   -23.322     0.200
     4.466   -26.596     0.200
     4.514   -26.226     0.200
     4.534   -27.462     0.200
     4.538   -26.868     0.200
     5.066   -33.108     0.200
     5.082   -30.316     0.200
     5.346   -32.192     0.200
     1.303     1.680     0.200
     1.790    -2.758     0.200
     2.118    -5.540     0.200
     2.403    -8.197     0.200
     3.495   -14.799     0.200
     3.642   -14.470     0.200
     3.704   -17.442     0.200
     4.013   -18.233     0.200
     4.861   -28.883     0.200
     5.222   -28.672     0.200
     5.322   -30.678     0.200
     5.356   -31.684     0.200
     5.475   -33.557     0.200
     5.580   -34.099     0.200
     5.516   -29.766     0.200
     5.635   -33.044     0.200
     5.635   -35.024     0.200
     5.661   -34.635     0.200
     5.735   -34.307     0.200
     5.785   -36.173     0.200
     5.871   -35.315     0.200
     5.978   -35.198     0.200
     6.211   -39.200     0.200
     6.225   -38.333     0.200
     6.263   -39.016     0.200
     6.267   -36.279     0.200
     6.448   -41.016     0.200
     6.411   -39.589     0.200
     6.729   -43.104     0.200
     6.729   -42.904     0.200
     6.748   -43.707     0.200
     6.793   -42.849     0.200
     6.796   -43.731     0.200
     6.980   -43.064     0.200
     7.108   -46.240     0.200
     7.289   -46.385     0.200
     7.211   -44.300     0.200
     7.446   -45.752     0.200
     7.446   -46.992     0.200
     7.504   -49.173     0.200
     7.642   -50.942     0.200
     7.834   -51.463     0.200
     7.834   -51.350     0.200
     7.920   -52.685     0.200
     8.051   -53.654     0.200
     8.480   -56.129     0.200
     8.754   -59.156     0.200
     8.804   -63.495     0.200
     8.806   -58.156     0.200
     8.837   -57.435     0.200
     9.188   -63.080     0.200
     9.276   -59.347     0.200
     9.365   -61.173     0.200
     9.355   -63.333     0.200
     9.471   -64.042     0.200
     9.517   -60.106     0.200
     9.809   -65.639     0.200
     9.832   -67.285     0.200
     9.944   -68.037     0.200
    10.116   -68.092     0.200
    11.188   -79.915     0.200
    11.302   -78.835     0.200
    11.395   -80.320     0.200
    11.701   -82.522     0.200
    11.718   -82.085     0.200
    12.099   -85.640     0.200
     1.541    -1.074     0.200
     2.713    -8.728     0.200
     3.169   -12.176     0.200
     4.814   -27.905     0.200
     4.886   -28.492     0.200
     4.935   -28.902     0.200
     4.970   -28.415     0.200
     5.086   -29.750     0.200
     5.200   -30.552     0.200
     5.292   -30.466     0.200
     5.386   -31.731     0.200
     5.434   -32.478     0.200
     5.802   -34.828     0.200
     5.991   -37.591     0.200
     6.219   -38.559     0.200
     6.575   -40.227     0.200
     7.170   -47.039     0.200
     1.295     3.056     0.200
     1.518     0.091     0.200
     1.943    -2.472     0.200
     2.862   -12.112     0.200
     2.958   -11.647     0.200
     3.074   -11.915     0.200
     3.330   -14.048     0.200
     3.947   -19.132     0.200
     4.017   -19.777     0.200
     4.086   -18.311     0.200
     4.365   -22.616     0.200
     4.632   -25.545     0.200
     4.845   -27.583     0.200
     4.879   -27.839     0.200
     4.891   -27.842     0.200
     5.131   -28.341     0.200
     5.379   -31.437     0.200
     5.610   -32.735     0.200
     0.806     3.934     0.200
     5.508   -31.922     0.200
     5.641   -32.388     0.200
     5.828   -34.807     0.200
     6.211   -36.345     0.200
     6.822   -42.525     0.200
     5.155   -28.833     0.200
     5.265   -30.714     0.200
     5.350   -31.114     0.200
     5.492   -32.045     0.200
     5.552   -32.112     0.200
     5.792   -33.984     0.200
     5.792   -32.429     0.200
     5.821   -34.690     0.200
     5.925   -34.941     0.200
     6.125   -37.400     0.200
     6.499   -40.730     0.200
     7.202   -44.515     0.200
     1.654    -1.327     0.200
     4.451   -23.060     0.200
     4.466   -24.474     0.200
     4.566   -24.440     0.200
     4.582   -27.213     0.200
     4.585   -26.636     0.200
     4.959   -30.087     0.200
     5.173   -30.095     0.200
     5.476   -33.382     0.200
     1.132    -0.732     0.200
     3.077   -15.742     0.200
     3.903   -20.098     0.200
     4.316   -26.654     0.200
     4.371   -27.220     0.200
     4.405   -28.053     0.200
     4.402   -27.951     0.200
     4.642   -29.294     0.200
     4.560   -27.078     0.200
     4.690   -28.422     0.200
     4.644   -24.420     0.200
     4.917   -30.609     0.200
     4.875   -31.774     0.200
     5.303   -33.364     0.200
     5.424   -35.831     0.200
     6.042   -38.873     0.200
     6.152   -40.654     0.200
     6.577   -44.698     0.200
     2.505   -12.675     0.200
     2.723   -14.185     0.200
     3.625   -21.153     0.200
     3.677   -21.605     0.200
     3.716   -22.565     0.200
     3.710   -23.613     0.200
     3.923   -24.076     0.200
     4.001   -24.185     0.200
     4.096   -24.522     0.200
     4.184   -26.193     0.200
     4.235   -25.697     0.200
     4.253   -25.666     0.200
     4.612   -28.435     0.200
     4.738   -31.140     0.200
     4.976   -31.369     0.200
     5.346   -33.721     0.200
     5.463   -34.628     0.200
     5.918   -39.569     0.200
     5.241   -31.579     0.200
     5.320   -32.091     0.200
     5.375   -31.732     0.200
     5.424   -30.817     0.200
     5.488   -30.913     0.200
     5.563   -33.386     0.200
     5.620   -33.076     0.200
     5.630   -33.815     0.200
     5.746   -33.182     0.200
     5.879   -36.926     0.200
     5.879   -35.684     0.200
     5.886   -35.704     0.200
     6.228   -38.455     0.200
     6.445   -39.721     0.200
     6.667   -40.867     0.200
     7.015   -43.909     0.200
     5.329   -32.710     0.200
     5.441   -34.049     0.200
     5.575   -33.205     0.200
     5.726   -35.394     0.200
     5.819   -35.527     0.200
     6.105   -40.115     0.200
     6.298   -40.212     0.200
     1.240     3.800     0.200
     1.370     1.664     0.200
     1.774    -3.120     0.200
     2.252    -6.295     0.200
     5.171   -30.029     0.200
     5.205   -29.206     0.200
     5.205   -30.886     0.200
     5.259   -30.912     0.200
     5.309   -31.546     0.200
     5.407   -32.915     0.200
     5.457   -31.483     0.200
     5.552   -32.290     0.200
     5.697   -34.589     0.200
     5.748   -34.294     0.200
     5.838   -34.147     0.200
     5.961   -35.527     0.200
     6.412   -40.210     0.200
     6.881   -41.939     0.200
     1.223     0.739     0.200
     2.288    -8.006     0.200
     2.803   -11.116     0.200
     2.870   -11.602     0.200
     2.948   -11.042     0.200
     2.869    -9.432     0.200
     2.957   -11.896     0.200
     3.007   -13.378     0.200
     3.608   -15.123     0.200
     3.739   -16.601     0.200
     3.856   -18.151     0.200
     3.874   -19.518     0.200
     3.971   -22.445     0.200
     4.155   -23.985     0.200
     4.183   -24.382     0.200
     4.191   -24.136     0.200
     4.469   -25.672     0.200
     4.524   -27.210     0.200
     4.667   -26.636     0.200
     4.773   -28.310     0.200
     4.863   -27.463     0.200
     4.835   -26.219     0.200
     4.964   -29.652     0.200
     5.138   -31.274     0.200
     5.195   -31.470     0.200
     5.284   -31.913     0.200
     5.696   -33.774     0.200
     5.726   -34.107     0.200
     5.925   -37.183     0.200
     6.094   -37.564     0.200
     7.020   -43.223     0.200
     7.588   -49.041     0.200
     1.964    -3.066     0.200
     2.027    -3.071     0.200
     2.316    -4.230     0.200
     3.168   -10.218     0.200
     3.237   -11.412     0.200
     3.299   -12.369     0.200
     3.637   -15.082     0.200
     3.704   -15.104     0.200
     3.754   -15.792     0.200
     3.890   -16.351     0.200
     3.893   -16.426     0.200
     3.896   -16.608     0.200
     3.954   -18.147     0.200
     4.120   -15.402     0.200
     4.300   -23.118     0.200
     4.376   -21.041     0.200
     4.434   -22.830     0.200
     4.657   -23.685     0.200
     5.262   -27.590     0.200
     5.330   -29.865     0.200
     5.305   -28.539     0.200
     5.355   -28.478     0.200
     5.385   -28.678     0.200
     5.427   -31.242     0.200
     5.500   -31.958     0.200
     5.519   -31.663     0.200
     5.519   -34.296     0.200
     5.611   -35.524     0.200
     5.611   -31.368     0.200
     5.601   -33.604     0.200
     5.602   -29.668     0.200
     5.724   -33.066     0.200
     5.852   -34.300     0.200
     5.869   -34.792     0.200
     5.968   -33.107     0.200
     6.018   -32.508     0.200
     6.048   -36.415     0.200
     6.036   -37.436     0.200
     6.185   -35.527     0.200
     6.309   -36.803     0.200
     6.616   -41.486     0.200
     6.811   -41.627     0.200
     7.006   -43.200     0.200
     7.054   -40.029     0.200
     7.084   -41.859     0.200
     7.315   -42.884     0.200
     7.315   -46.541     0.200
     7.335   -49.638     0.200
     7.328   -46.113     0.200
     7.422   -48.066     0.200
     7.604   -48.356     0.200
     7.700   -48.298     0.200
     7.745   -50.219     0.200
     7.851   -51.148     0.200
     8.100   -54.428     0.200
     8.136   -49.405     0.200
     8.304   -52.132     0.200
     8.665   -55.585     0.200
     8.933   -59.567     0.200
     8.933   -59.466     0.200
     8.934   -59.508     0.200
     8.949   -57.001     0.200
     9.001   -57.851     0.200
     9.001   -61.156     0.200
     9.188   -59.562     0.200
     9.201   -59.580     0.200
     9.206   -58.489     0.200
     9.295   -62.559     0.200
     9.413   -62.894     0.200
     9.616   -63.243     0.200
     9.652   -64.271     0.200
     9.752   -64.614     0.200
     9.817   -70.848     0.200
     9.817   -66.341     0.200
     9.945   -66.161     0.200
    10.273   -66.345     0.200
    10.669   -75.646     0.200
    10.739   -73.231     0.200
    11.034   -75.767     0.200
    11.049   -75.216     0.200
    11.069   -75.225     0.200
    11.072   -75.051     0.200
    11.093   -73.600     0.200
    11.132   -75.790     0.200
    11.159   -77.498     0.200
    11.152   -74.145     0.200
    11.169   -77.146     0.200
    11.182   -75.310     0.200
    11.220   -75.958     0.200
    11.509   -77.931     0.200
    11.588   -77.094     0.200
     1.536    -3.729     0.200
     1.893    -6.041     0.200
     2.137    -8.778     0.200
     2.478   -10.574     0.200
     2.916   -10.452     0.200
     3.667   -17.275     0.200
     3.803   -18.593     0.200
     5.000   -30.528     0.200
     5.355   -32.790     0.200
     5.576   -34.795     0.200
     6.239   -41.104     0.200
     6.271   -42.228     0.200
     6.604   -44.484     0.200
     6.609   -41.933     0.200
     6.667   -44.875     0.200
     6.857   -45.684     0.200
     6.856   -44.576     0.200
     6.866   -44.684     0.200
     7.219   -47.480     0.200
     7.347   -50.029     0.200
     8.248   -53.798     0.200
     8.320   -57.869     0.200
     8.441   -58.301     0.200
     8.854   -60.904     0.200
     8.854   -58.803     0.200
     9.249   -64.020     0.200
     9.715   -68.487     0.200
     9.828   -70.062     0.200
    10.204   -73.111     0.200
    10.509   -75.264     0.200
     0.239     7.153     0.200
     0.833     1.333     0.200
     1.788    -4.453     0.200
     2.333    -8.218     0.200
     3.701   -23.074     0.200
     3.734   -23.539     0.200
     4.066   -25.460     0.200
     4.119   -25.715     0.200
     4.180   -26.061     0.200
     4.319   -27.762     0.200
     4.326   -27.499     0.200
     4.335   -27.861     0.200
     4.681   -29.346     0.200
     4.823   -31.553     0.200
     5.451   -35.148     0.200
     1.061     2.006     0.200
     1.670    -3.291     0.200
     1.976    -4.987     0.200
     2.113    -6.324     0.200
     5.568   -35.765     0.200
     5.701   -36.862     0.200
     5.758   -35.475     0.200
     5.808   -37.654     0.200
     5.966   -38.660     0.200
     6.016   -40.054     0.200
     6.196   -39.970     0.200
     6.424   -42.417     0.200
     6.424   -42.396     0.200
     6.513   -42.203     0.200
     1.567     0.248     0.200
     1.686    -0.511     0.200
     2.124    -7.407     0.200
     5.317   -29.996     0.200
     5.432   -31.470     0.200
     5.523   -32.759     0.200
     5.682   -33.169     0.200
     5.714   -33.897     0.200
     6.030   -35.927     0.200
     6.685   -41.243     0.200
     7.972   -51.666     0.200
     1.158     2.806     0.200
     2.837   -12.417     0.200
     2.956   -12.581     0.200
     4.839   -28.053     0.200
     4.905   -28.750     0.200
     4.948   -28.690     0.200
     4.964   -28.152     0.200
     5.129   -30.492     0.200
     5.128   -28.438     0.200
     5.128   -30.136     0.200
     5.189   -29.066     0.200
     5.222   -31.119     0.200
     5.244   -30.855     0.200
     5.316   -31.298     0.200
     5.433   -33.103     0.200
     5.473   -32.455     0.200
     5.827   -35.787     0.200
     5.986   -36.238     0.200
     6.028   -36.961     0.200
     7.146   -45.579     0.200
     0.748     2.816     0.200
     0.963     2.023     0.200
     1.152     0.019     0.200
     1.657    -6.004     0.200
     3.903   -24.601     0.200
     3.978   -24.561     0.200
     4.031   -24.882     0.200
     4.093   -24.251     0.200
     4.360   -25.935     0.200
     4.549   -26.257     0.200
     4.658   -26.888     0.200
     5.112   -33.520     0.200
     1.214     3.953     0.200
     1.795    -3.485     0.200
     2.302    -7.555     0.200
     5.133   -29.698     0.200
     5.242   -31.257     0.200
     5.387   -30.635     0.200
     5.468   -32.114     0.200
     5.901   -35.040     0.200
     6.000   -35.626     0.200
     6.104   -36.177     0.200
     6.475   -39.393     0.200
     2.144    -7.972     0.200
     2.178    -6.349     0.200
     2.487    -7.122     0.200
     2.525    -9.348     0.200
     3.364   -12.951     0.200
     3.506   -15.432     0.200
     3.910   -18.003     0.200
     3.955   -17.686     0.200
     4.097   -19.242     0.200
     4.103   -19.663     0.200
     4.361   -20.544     0.200
     4.523   -20.911     0.200
     4.645   -26.687     0.200
     4.856   -26.855     0.200
     4.910   -26.939     0.200
     5.303   -27.294     0.200
     5.495   -33.602     0.200
     5.519   -29.403     0.200
     5.569   -28.925     0.200
     5.598   -35.548     0.200
     5.600   -28.666     0.200
     5.666   -33.910     0.200
     5.666   -35.817     0.200
     5.675   -33.882     0.200
     5.763   -35.855     0.200
     5.763   -36.585     0.200
     5.790   -37.200     0.200
     5.814   -32.509     0.200
     5.891   -36.944     0.200
     6.005   -37.460     0.200
     6.073   -36.752     0.200
     6.134   -39.390     0.200
     6.228   -40.224     0.200
     6.233   -38.176     0.200
     6.233   -35.037     0.200
     6.245   -39.055     0.200
     6.471   -40.632     0.200
     6.690   -38.300     0.200
     6.803   -44.290     0.200
     7.212   -45.005     0.200
     7.513   -48.443     0.200
     7.632   -50.885     0.200
     7.814   -53.407     0.200
     7.929   -51.955     0.200
     8.049   -53.168     0.200
     8.489   -54.985     0.200
     8.737   -58.978     0.200
     9.192   -59.388     0.200
     9.192   -62.214     0.200
     9.358   -63.051     0.200
     9.420   -60.686     0.200
     9.480   -64.005     0.200
     9.600   -63.506     0.200
     9.810   -64.471     0.200
     9.946   -66.956     0.200
    10.001   -68.340     0.200
    10.127   -68.021     0.200
    10.924   -77.977     0.200
    11.294   -77.506     0.200
    11.378   -79.982     0.200
    11.434   -79.268     0.200
    11.664   -81.333     0.200
    11.669   -83.295     0.200
    11.690   -83.571     0.200
    11.722   -80.747     0.200
    11.802   -79.330     0.200
    15.188  -110.571     0.200
    16.972  -124.611     0.200
     2.627   -10.152     0.200
     5.699   -32.861     0.200
     5.717   -33.213     0.200
     6.057   -37.118     0.200
     6.813   -42.947     0.200
     1.129     2.721     0.200
     2.614   -10.351     0.200
     3.137   -12.931     0.200
     5.227   -31.442     0.200
     5.262   -31.602     0.200
     5.445   -33.204     0.200
     6.284   -40.061     0.200
     1.199     4.828     0.200
     2.656    -6.371     0.200
     4.070   -20.015     0.200
     4.403   -20.875     0.200
     4.681   -20.902     0.200
     4.765   -21.537     0.200
     4.871   -19.915     0.200
     5.265   -28.662     0.200
     5.336   -29.333     0.200
     5.384   -30.034     0.200
     5.409   -30.370     0.200
     5.534   -29.905     0.200
     5.572   -31.629     0.200
     5.651   -32.006     0.200
     5.678   -30.447     0.200
     5.836   -32.564     0.200
     5.877   -32.563     0.200
     5.901   -33.817     0.200
     5.954   -33.800     0.200
     6.253   -36.084     0.200
     6.431   -37.137     0.200
     7.023   -41.214     0.200
     7.156   -42.519     0.200
     7.592   -47.786     0.200
     8.124   -50.287     0.200
     8.170   -50.765     0.200
     8.785   -54.740     0.200
     8.785   -56.520     0.200
     9.113   -57.461     0.200
     9.515   -62.343     0.200
     9.641   -62.485     0.200
     1.232     1.436     0.200
     1.993    -5.687     0.200
     2.583   -10.412     0.200
     4.497   -23.488     0.200
     5.321   -27.671     0.200
     5.388   -31.908     0.200
     5.486   -33.419     0.200
     5.559   -34.018     0.200
     5.573   -33.390     0.200
     5.663   -35.156     0.200
     5.666   -34.528     0.200
     5.783   -35.222     0.200
     5.907   -36.171     0.200
     5.932   -36.755     0.200
     6.026   -36.648     0.200
     6.079   -32.738     0.200
     6.109   -37.367     0.200
     6.099   -37.694     0.200
     6.115   -38.059     0.200
     6.366   -40.928     0.200
     6.632   -41.641     0.200
     6.678   -40.843     0.200
     7.389   -47.161     0.200
     7.667   -50.933     0.200
     9.063   -59.966     0.200
     1.178     3.455     0.200
     2.678   -10.093     0.200
     5.000   -28.724     0.200
     5.050   -28.341     0.200
     5.084   -28.000     0.200
     5.197   -30.362     0.200
     5.197   -29.921     0.200
     5.264   -30.696     0.200
     5.271   -30.354     0.200
     5.314   -31.573     0.200
     5.396   -30.944     0.200
     5.549   -33.607     0.200
     5.564   -31.978     0.200
     5.916   -35.038     0.200
     6.106   -36.913     0.200
     1.230     3.134     0.200
     2.473    -5.190     0.200
     2.476    -5.263     0.200
     3.313   -13.802     0.200
     3.752   -17.747     0.200
     3.879   -17.239     0.200
     3.913   -17.197     0.200
     4.051   -18.851     0.200
     4.721   -24.454     0.200
     4.817   -26.365     0.200
     4.810   -27.822     0.200
     4.856   -27.502     0.200
     4.873   -28.351     0.200
     4.862   -26.993     0.200
     4.911   -26.811     0.200
     5.186   -29.670     0.200
     5.151   -27.562     0.200
     5.295   -31.507     0.200
     5.439   -31.792     0.200
     5.439   -30.870     0.200
     5.450   -31.620     0.200
     5.800   -33.728     0.200
     5.828   -35.674     0.200
     5.947   -34.975     0.200
     6.101   -36.148     0.200
     6.438   -38.218     0.200
     6.560   -40.117     0.200
     6.904   -43.141     0.200
     8.132   -52.826     0.200
     0.783     4.762     0.200
     1.259     2.671     0.200
     1.243     0.194     0.200
     2.320    -6.856     0.200
     2.365    -6.401     0.200
     2.347    -8.816     0.200
     3.693   -20.385     0.200
     3.682   -19.581     0.200
     3.725   -21.187     0.200
     3.737   -20.271     0.200
     3.777   -19.133     0.200
     3.801   -19.856     0.200
     4.011   -20.579     0.200
     3.935   -15.412     0.200
     4.057   -22.528     0.200
     4.092   -21.423     0.200
     4.164   -23.804     0.200
     4.310   -25.228     0.200
     4.329   -25.050     0.200
     4.672   -28.025     0.200
     4.703   -28.597     0.200
     1.421     0.158     0.200
     1.801    -1.871     0.200
     2.616    -6.706     0.200
     2.979   -12.232     0.200
     3.063   -10.884     0.200
     3.491   -16.739     0.200
     3.588   -17.741     0.200
     3.666   -18.422     0.200
     3.786   -18.515     0.200
     3.809   -19.929     0.200
     3.885   -19.937     0.200
     4.201   -24.444     0.200
     4.237   -22.616     0.200
     4.471   -23.826     0.200
     4.476   -23.758     0.200
     4.731   -25.312     0.200
     4.812   -27.785     0.200
     5.514   -31.269     0.200
     1.585    -1.926     0.200
     2.215    -4.884     0.200
     5.376   -32.377     0.200
     5.488   -32.845     0.200
     5.773   -35.167     0.200
     6.154   -37.867     0.200
     6.343   -39.556     0.200
     1.386     1.962     0.200
     2.554    -6.084     0.200
     2.940   -11.812     0.200
     2.961   -11.316     0.200
     2.989    -8.875     0.200
     3.092   -11.126     0.200
     3.533   -17.699     0.200
     3.627   -17.788     0.200
     3.701   -18.127     0.200
     3.760   -19.094     0.200
     3.760   -16.465     0.200
     3.833   -18.742     0.200
     3.926   -19.069     0.200
     4.073   -20.835     0.200
     4.207   -22.088     0.200
     4.265   -21.813     0.200
     4.473   -23.488     0.200
     4.515   -25.437     0.200
     4.709   -24.381     0.200
     4.838   -26.026     0.200
     5.334   -31.591     0.200
     5.543   -33.013     0.200
     1.671    -2.445     0.200
     4.718   -24.212     0.200
     4.754   -25.304     0.200
     5.110   -27.659     0.200
     5.174   -28.888     0.200
     5.174   -29.035     0.200
     5.244   -29.301     0.200
     5.298   -27.634     0.200
     5.353   -29.384     0.200
     5.507   -30.650     0.200
     5.544   -29.025     0.200
     5.571   -32.345     0.200
     5.875   -32.926     0.200
     5.975   -35.073     0.200
     6.004   -34.975     0.200
     6.391   -37.282     0.200
     6.554   -39.814     0.200
     6.687   -39.639     0.200
     6.947   -40.779     0.200
     7.235   -43.926     0.200
     8.960   -56.608     0.200
     1.777    -4.293     0.200
     2.852    -9.933     0.200
     3.005   -12.382     0.200
     3.528   -15.755     0.200
     3.765   -17.597     0.200
     3.890   -19.379     0.200
     3.953   -19.593     0.200
     4.051   -19.366     0.200
     4.051   -20.536     0.200
     4.110   -19.747     0.200
     4.151   -19.747     0.200
     4.226   -22.052     0.200
     4.342   -21.887     0.200
     4.407   -23.175     0.200
     4.431   -23.113     0.200
     4.555   -23.555     0.200
     4.753   -24.621     0.200
     4.970   -27.000     0.200
     4.971   -28.545     0.200
     5.184   -28.681     0.200
     5.530   -30.860     0.200
     5.689   -33.296     0.200
     5.811   -35.243     0.200
     2.071    -5.364     0.200
     2.644    -9.503     0.200
     4.401   -23.241     0.200
     4.949   -25.766     0.200
     5.316   -30.411     0.200
     5.411   -31.538     0.200
     5.482   -32.988     0.200
     5.579   -32.617     0.200
     5.601   -32.338     0.200
     5.710   -32.304     0.200
     5.841   -36.071     0.200
     5.980   -30.321     0.200
     6.003   -36.684     0.200
     6.027   -36.352     0.200
     6.296   -38.381     0.200
     6.556   -40.423     0.200
     6.594   -40.500     0.200
     7.117   -44.115     0.200
     7.303   -46.855     0.200
     7.308   -46.156     0.200
     7.390   -48.590     0.200
     8.978   -60.919     0.200
     1.066     2.853     0.200
     2.640    -8.865     0.200
     3.273   -11.413     0.200
     3.758   -20.688     0.200
     3.813   -21.246     0.200
     3.849   -21.421     0.200
     3.860   -20.517     0.200
     4.066   -22.549     0.200
     4.094   -21.930     0.200
     4.094   -21.332     0.200
     4.136   -23.275     0.200
     4.137   -21.216     0.200
     4.328   -24.759     0.200
     4.363   -25.053     0.200
     4.388   -24.349     0.200
     4.746   -27.590     0.200
     4.882   -28.215     0.200
     4.929   -29.004     0.200
     5.118   -30.399     0.200
     5.607   -34.005     0.200
     5.620   -36.094     0.200
     5.807   -35.360     0.200
     6.021   -36.740     0.200
     6.064   -37.643     0.200
     7.241   -46.813     0.200
     2.903   -10.839     0.200
     3.459   -15.581     0.200
     4.138   -22.617     0.200
     4.191   -21.398     0.200
     4.216   -22.104     0.200
     4.222   -23.277     0.200
     4.377   -22.805     0.200
     4.492   -19.838     0.200
     4.508   -24.353     0.200
     4.515   -24.570     0.200
     4.689   -24.380     0.200
     4.744   -26.624     0.200
     4.766   -25.346     0.200
     5.125   -27.910     0.200
     5.238   -30.161     0.200
     5.483   -31.770     0.200
     5.896   -36.047     0.200
     5.965   -34.954     0.200
     2.483   -10.288     0.200
     2.730    -9.888     0.200
     3.049   -13.010     0.200
     3.133   -10.632     0.200
     3.374   -15.758     0.200
     3.736   -16.973     0.200
     3.833   -20.866     0.200
     3.842   -20.754     0.200
     3.771   -19.973     0.200
     3.870   -22.233     0.200
     3.887   -22.581     0.200
     3.967   -20.642     0.200
     4.089   -22.595     0.200
     4.201   -24.417     0.200
     4.217   -23.519     0.200
     4.217   -24.120     0.200
     4.245   -24.509     0.200
     4.322   -24.970     0.200
     4.453   -27.948     0.200
     4.453   -25.517     0.200
     4.464   -25.064     0.200
     4.463   -25.912     0.200
     4.555   -21.456     0.200
     4.815   -28.688     0.200
     4.863   -29.512     0.200
     4.962   -29.759     0.200
     4.931   -26.356     0.200
     5.124   -30.985     0.200
     5.413   -29.125     0.200
     5.477   -35.464     0.200
     5.515   -33.270     0.200
     5.594   -34.572     0.200
     5.651   -36.150     0.200
     5.651   -34.561     0.200
     5.844   -35.910     0.200
     5.844   -36.972     0.200
     5.990   -39.406     0.200
     6.005   -38.508     0.200
     6.553   -41.475     0.200
     7.160   -45.291     0.200
     7.194   -47.391     0.200
     7.194   -47.931     0.200
     7.211   -43.463     0.200
     7.428   -49.233     0.200
     7.539   -49.942     0.200
     7.782   -50.849     0.200
     7.912   -54.045     0.200
     8.069   -54.752     0.200
     2.600   -10.006     0.200
     3.072   -12.682     0.200
     3.203   -14.253     0.200
     3.346   -13.439     0.200
     3.440   -14.335     0.200
     4.073   -22.608     0.200
     4.119   -21.765     0.200
     4.146   -24.530     0.200
     4.153   -23.286     0.200
     4.131   -21.271     0.200
     4.205   -21.777     0.200
     4.480   -25.720     0.200
     4.559   -26.423     0.200
     4.557   -19.600     0.200
     4.733   -27.219     0.200
     4.731   -26.556     0.200
     4.758   -27.230     0.200
     5.090   -30.017     0.200
     5.223   -31.262     0.200
     5.367   -32.525     0.200
     5.590   -34.491     0.200
     5.771   -35.445     0.200
     5.822   -35.255     0.200
     7.756   -51.049     0.200
     2.615    -8.319     0.200
     3.113   -14.582     0.200
     3.226   -16.284     0.200
     3.136   -11.610     0.200
     3.509   -17.970     0.200
     3.522   -16.760     0.200
     3.927   -20.387     0.200
     4.339   -23.935     0.200
     4.710   -25.761     0.200
     6.748   -45.584     0.200
     2.772    -8.049     0.200
     3.570   -13.145     0.200
     4.978   -28.680     0.200
     5.023   -30.392     0.200
     5.045   -27.761     0.200
     5.191   -31.749     0.200
     5.216   -29.801     0.200
     5.254   -30.851     0.200
     5.332   -30.099     0.200
     5.487   -31.625     0.200
     5.544   -32.632     0.200
     5.593   -31.801     0.200
     6.067   -37.930     0.200
     6.103   -35.259     0.200
     6.301   -39.533     0.200
     6.720   -41.362     0.200
     6.792   -41.505     0.200
     6.920   -44.502     0.200
     1.794    -3.063     0.200
     5.185   -31.036     0.200
     5.271   -31.265     0.200
     5.411   -32.405     0.200
     5.492   -31.462     0.200
     5.823   -33.770     0.200
     6.170   -38.048     0.200
     6.633   -42.443     0.200
     6.971   -42.465     0.200
     7.140   -46.114     0.200
     2.217    -4.418     0.200
     2.431    -8.468     0.200
     2.761    -8.256     0.200
     2.935   -11.115     0.200
     3.230   -12.840     0.200
     3.680   -14.441     0.200
     3.888   -19.740     0.200
     3.953   -20.214     0.200
     3.970   -20.583     0.200
     3.966   -15.486     0.200
     4.038   -20.390     0.200
     4.905   -29.173     0.200
     5.424   -32.152     0.200
     1.682    -4.637     0.200
     3.874   -16.728     0.200
     1.668    -1.855     0.200
     2.325    -5.070     0.200
     2.421    -5.322     0.200
     2.616    -6.130     0.200
     2.635   -10.012     0.200
     2.635   -11.815     0.200
     2.665    -9.337     0.200
     2.672    -9.296     0.200
     3.139   -11.635     0.200
     3.150    -9.943     0.200
     3.192   -13.453     0.200
     3.200    -9.602     0.200
     3.294   -16.743     0.200
     3.520   -17.956     0.200
     3.630   -17.220     0.200
     3.639   -17.493     0.200
     3.650   -16.993     0.200
     3.774   -17.942     0.200
     3.907   -16.912     0.200
     3.960   -15.410     0.200
     4.029   -18.164     0.200
     4.141   -20.339     0.200
     4.160   -17.680     0.200
     4.366   -21.902     0.200
     4.508   -22.011     0.200
     4.569   -19.848     0.200
     4.611   -24.517     0.200
     4.664   -26.798     0.200
     4.678   -27.073     0.200
     4.695   -26.553     0.200
     4.804   -27.282     0.200
     4.901   -27.120     0.200
     4.940   -28.446     0.200
     4.940   -29.110     0.200
     4.988   -29.942     0.200
     4.988   -28.364     0.200
     4.988   -28.378     0.200
     5.154   -31.426     0.200
     5.214   -30.440     0.200
     5.270   -28.701     0.200
     5.250   -25.009     0.200
     5.250   -23.541     0.200
     5.518   -31.411     0.200
     5.598   -33.315     0.200
     5.700   -34.063     0.200
     5.774   -34.567     0.200
     5.951   -35.097     0.200
     5.951   -37.276     0.200
     6.288   -38.583     0.200
     6.288   -39.544     0.200
     6.330   -38.507     0.200
     6.400   -39.130     0.200
     6.429   -40.233     0.200
     6.451   -40.531     0.200
     6.451   -39.695     0.200
     6.451   -40.263     0.200
     6.453   -38.902     0.200
     6.527   -43.058     0.200
     6.527   -41.261     0.200
     6.626   -40.184     0.200
     6.841   -43.904     0.200
     6.888   -44.008     0.200
     7.113   -42.345     0.200
     7.171   -45.835     0.200
     7.313   -46.072     0.200
     7.390   -46.721     0.200
     7.390   -47.846     0.200
     7.393   -47.799     0.200
     7.771   -50.485     0.200
     7.727   -48.468     0.200
     7.905   -50.136     0.200
     7.973   -49.549     0.200
     8.035   -52.669     0.200
     8.035   -53.880     0.200
     8.267   -55.825     0.200
     8.348   -54.672     0.200
     8.378   -56.326     0.200
     8.624   -57.134     0.200
     8.749   -58.708     0.200
     8.758   -58.797     0.200
     8.907   -60.532     0.200
     9.046   -60.916     0.200
     9.320   -63.781     0.200
     9.812   -67.599     0.200
     9.979   -67.083     0.200
    10.016   -68.547     0.200
    10.026   -67.240     0.200
    10.144   -69.162     0.200
    10.174   -69.468     0.200
    10.241   -71.280     0.200
    10.276   -70.890     0.200
    10.315   -67.984     0.200
    10.378   -70.212     0.200
    10.625   -73.956     0.200
     1.353     1.778     0.200
     3.111   -12.573     0.200
     3.169   -14.792     0.200
     3.266   -12.337     0.200
     3.269   -16.858     0.200
     3.494   -16.253     0.200
     3.615   -16.107     0.200
     3.628   -18.956     0.200
     3.747   -17.179     0.200
     3.881   -17.874     0.200
     4.001   -17.684     0.200
     4.596   -24.978     0.200
     4.648   -26.531     0.200
     4.658   -28.263     0.200
     4.678   -27.657     0.200
     4.780   -27.787     0.200
     4.774   -23.645     0.200
     4.876   -26.774     0.200
     4.929   -27.915     0.200
     4.973   -28.522     0.200
     4.975   -29.376     0.200
     4.975   -28.098     0.200
     5.135   -30.741     0.200
     5.201   -29.858     0.200
     5.253   -28.500     0.200
     5.583   -33.967     0.200
     5.680   -33.921     0.200
     5.757   -32.871     0.200
     5.932   -35.834     0.200
     6.262   -39.112     0.200
     6.312   -38.380     0.200
     6.409   -40.838     0.200
     6.424   -39.046     0.200
     6.611   -39.546     0.200
     6.821   -44.101     0.200
     7.370   -46.108     0.200
     7.751   -50.982     0.200
     7.878   -48.970     0.200
     8.014   -52.715     0.200
     8.247   -53.800     0.200
     8.357   -55.604     0.200
     8.602   -56.853     0.200
     8.729   -58.288     0.200
     8.729   -57.686     0.200
     8.736   -58.664     0.200
     8.887   -60.728     0.200
     9.026   -60.104     0.200
     4.043   -23.030     0.200
     4.047   -23.352     0.200
     4.384   -26.040     0.200
     4.999   -29.827     0.200
     1.318     1.406     0.200
     1.820    -5.341     0.200
     2.456    -8.908     0.200
     2.683    -9.252     0.200
     2.852   -12.482     0.200
     2.959   -11.119     0.200
     3.074   -12.942     0.200
     3.253   -14.025     0.200
     3.327   -14.101     0.200
     3.910   -21.823     0.200
     3.958   -20.848     0.200
     3.984   -21.467     0.200
     3.990   -23.093     0.200
     3.978   -20.597     0.200
     3.991   -18.073     0.200
     4.063   -20.909     0.200
     4.319   -23.369     0.200
     4.367   -21.908     0.200
     4.367   -24.988     0.200
     4.387   -23.929     0.200
     4.568   -24.163     0.200
     4.600   -25.387     0.200
     4.790   -27.070     0.200
     4.934   -28.388     0.200
     4.927   -28.635     0.200
     5.204   -29.424     0.200
     5.295   -27.138     0.200
     5.449   -31.259     0.200
     5.608   -32.540     0.200
     5.612   -31.669     0.200
     5.612   -33.400     0.200
     5.660   -33.483     0.200
     6.068   -36.330     0.200
     6.159   -37.595     0.200
     6.612   -38.558     0.200
     6.999   -42.937     0.200
     7.234   -46.900     0.200
     7.234   -47.293     0.200
     7.595   -48.016     0.200
     7.813   -49.643     0.200
     7.969   -51.775     0.200
     9.426   -67.585     0.200
     9.823   -70.751     0.200
     1.228     1.251     0.200
     1.584    -2.294     0.200
     1.993    -5.661     0.200
     2.396    -9.239     0.200
     2.476    -7.292     0.200
     2.703    -9.076     0.200
     2.718    -8.309     0.200
     2.871   -12.159     0.200
     2.978   -10.878     0.200
     3.093   -10.511     0.200
     3.271   -14.273     0.200
     3.346   -11.899     0.200
     3.660   -13.955     0.200
     3.974   -22.049     0.200
     4.000   -22.791     0.200
     4.007   -24.314     0.200
     3.997   -21.512     0.200
     4.083   -21.170     0.200
     4.334   -24.688     0.200
     4.380   -22.648     0.200
     4.380   -23.711     0.200
     4.401   -24.891     0.200
     4.471   -21.321     0.200
     4.584   -25.808     0.200
     4.614   -26.561     0.200
     4.950   -29.205     0.200
     4.946   -32.675     0.200
     5.221   -30.808     0.200
     5.313   -28.819     0.200
     5.469   -32.239     0.200
     5.625   -33.703     0.200
     5.632   -34.807     0.200
     5.678   -33.081     0.200
     6.087   -40.033     0.200
     6.176   -37.965     0.200
     7.254   -47.623     0.200
     7.502   -49.494     0.200
     7.613   -49.628     0.200
     1.087     1.575     0.200
     1.217     2.247     0.200
     1.286     1.737     0.200
     2.483   -10.173     0.200
     2.708    -9.148     0.200
     2.979   -11.077     0.200
     3.098    -9.555     0.200
     3.269   -12.689     0.200
     4.011   -17.619     0.200
     3.942   -22.773     0.200
     4.007   -22.115     0.200
     4.090   -19.392     0.200
     3.991   -21.973     0.200
     4.023   -23.131     0.200
     4.017   -23.295     0.200
     4.352   -25.198     0.200
     4.399   -22.509     0.200
     4.419   -25.640     0.200
     4.601   -26.094     0.200
     4.633   -27.103     0.200
     4.960   -29.037     0.200
     4.968   -29.318     0.200
     5.237   -30.246     0.200
     5.476   -32.892     0.200
     5.641   -34.169     0.200
     5.692   -34.593     0.200
     6.101   -41.137     0.200
     1.231     3.232     0.200
     1.997    -3.810     0.200
     2.023    -5.763     0.200
     2.480    -9.132     0.200
     2.991   -11.782     0.200
     3.288   -12.130     0.200
     3.685   -14.189     0.200
     3.920   -19.268     0.200
     3.993   -22.512     0.200
     3.997   -19.506     0.200
     4.023   -16.014     0.200
     4.087   -18.855     0.200
     5.474   -31.868     0.200
     1.248     0.525     0.200
     2.300    -7.421     0.200
     3.070   -12.456     0.200
     3.178   -11.063     0.200
     5.406   -33.315     0.200
     5.468   -35.126     0.200
     5.545   -31.497     0.200
     5.545   -34.497     0.200
     5.536   -34.172     0.200
     5.712   -34.495     0.200
     5.758   -36.866     0.200
     5.864   -35.929     0.200
     5.898   -36.655     0.200
     6.305   -39.092     0.200
     6.556   -43.103     0.200
     6.768   -43.473     0.200
     7.274   -48.022     0.200
     7.286   -48.292     0.200
     1.250     3.497     0.200
     1.330     3.305     0.200
     2.390    -4.838     0.200
     2.656    -4.589     0.200
     2.855   -11.157     0.200
     3.014   -13.062     0.200
     3.112   -12.320     0.200
     3.275   -13.912     0.200
     3.978   -17.722     0.200
     4.448   -22.763     0.200
     4.605   -25.206     0.200
     4.807   -26.648     0.200
     4.837   -25.647     0.200
     4.846   -25.232     0.200
     5.179   -28.081     0.200
     5.588   -31.422     0.200
     5.792   -32.630     0.200
     5.841   -33.077     0.200
     1.327     2.232     0.200
     3.004   -10.402     0.200
     3.690   -11.727     0.200
     4.163   -21.037     0.200
     5.266   -31.110     0.200
     5.345   -32.230     0.200
     5.449   -33.860     0.200
     5.512   -31.700     0.200
     5.655   -34.051     0.200
     5.684   -27.729     0.200
     5.770   -33.883     0.200
     5.904   -35.419     0.200
     6.253   -37.988     0.200
     7.040   -43.854     0.200
     7.158   -46.094     0.200
     7.192   -45.461     0.200
     7.607   -48.529     0.200
     7.655   -49.408     0.200
     9.572   -63.296     0.200
     0.799     3.768     0.200
     1.071     3.170     0.200
     1.105     2.095     0.200
     5.403   -35.340     0.200
     5.499   -35.192     0.200
     5.594   -35.094     0.200
     5.594   -36.562     0.200
     5.668   -36.758     0.200
     5.685   -35.380     0.200
     5.797   -36.934     0.200
     6.041   -38.380     0.200
     6.091   -38.816     0.200
     6.382   -41.588     0.200
     7.205   -45.882     0.200
     7.397   -50.163     0.200
     6.095   -36.163     0.200
     6.175   -37.197     0.200
     6.223   -35.634     0.200
     6.438   -38.340     0.200
     6.668   -39.619     0.200
     6.982   -42.391     0.200
     1.031     5.704     0.200
     1.323     4.023     0.200
     2.470    -6.087     0.200
     2.985    -9.403     0.200
     3.394   -10.601     0.200
     3.790   -14.148     0.200
     4.745   -26.051     0.200
     4.842   -27.798     0.200
     5.053   -27.826     0.200
     5.053   -28.998     0.200
     5.108   -28.563     0.200
     5.093   -29.019     0.200
     5.126   -28.531     0.200
     5.337   -29.930     0.200
     5.377   -30.888     0.200
     5.733   -33.082     0.200
     6.479   -38.140     0.200
     6.480   -41.542     0.200
     7.010   -44.978     0.200
     1.094     3.373     0.200
     2.160    -6.935     0.200
     2.347    -6.563     0.200
     2.980   -12.263     0.200
     3.078   -10.858     0.200
     3.412   -16.806     0.200
     3.384   -13.273     0.200
     3.517   -17.723     0.200
     3.601   -17.533     0.200
     3.764   -16.063     0.200
     3.766   -18.693     0.200
     3.808   -19.247     0.200
     4.189   -22.068     0.200
     4.389   -24.274     0.200
     4.484   -23.946     0.200
     4.773   -25.972     0.200
     5.226   -29.818     0.200
     5.459   -31.594     0.200
     5.835   -35.325     0.200
     6.075   -36.934     0.200
     1.164     2.559     0.200
     1.133     3.395     0.200
     1.304     2.110     0.200
     1.359     2.942     0.200
     1.815    -2.468     0.200
     2.770    -6.202     0.200
     3.564   -13.511     0.200
     3.688   -12.090     0.200
     4.322   -16.939     0.200
     4.778   -22.031     0.200
     4.783   -21.325     0.200
     1.251     5.421     0.200
     1.382     4.165     0.200
     1.779    -1.417     0.200
     2.162    -4.081     0.200
     2.309    -4.790     0.200
     2.891    -8.311     0.200
     3.020    -9.020     0.200
     3.117    -9.938     0.200
     3.384   -13.271     0.200
     3.487   -12.859     0.200
     3.617   -12.444     0.200
     3.778   -14.193     0.200
     3.860   -17.454     0.200
     3.909   -16.671     0.200
     3.983   -21.816     0.200
     3.994   -21.948     0.200
     4.231   -18.050     0.200
     4.231   -15.343     0.200
     4.435   -24.230     0.200
     4.543   -21.253     0.200
     4.867   -19.427     0.200
     4.948   -27.610     0.200
     5.062   -24.950     0.200
     5.291   -27.513     0.200
     5.585   -32.099     0.200
     5.603   -31.861     0.200
     1.011     5.433     0.200
     1.198     2.941     0.200
     1.106     5.576     0.200
     1.209     5.581     0.200
     1.349     3.737     0.200
     1.810    -2.514     0.200
     2.340    -5.999     0.200
     3.072    -9.890     0.200
     3.164   -11.326     0.200
     3.826   -16.937     0.200
     3.886   -18.347     0.200
     3.869   -20.578     0.200
     3.942   -19.124     0.200
     3.983   -21.344     0.200
     4.281   -19.336     0.200
     4.979   -25.913     0.200
     5.326   -29.078     0.200
     1.050     2.396     0.200
     1.154     2.248     0.200
     1.786    -6.666     0.200
     1.841    -4.408     0.200
     2.383    -8.833     0.200
     2.968   -11.562     0.200
     3.096   -12.814     0.200
     3.195   -13.653     0.200
     3.856   -18.112     0.200
     3.919   -22.405     0.200
     3.932   -20.670     0.200
     3.984   -20.726     0.200
     4.026   -23.834     0.200
     4.034   -23.785     0.200
     4.040   -24.084     0.200
     5.138   -28.583     0.200
     5.367   -31.589     0.200
     0.810     3.090     0.200
     1.571    -3.607     0.200
     2.030    -6.265     0.200
     2.030    -6.156     0.200
     2.569   -12.704     0.200
     3.039   -16.618     0.200
     3.340   -17.683     0.200
     3.506   -19.027     0.200
     3.549   -16.140     0.200
     3.572   -20.345     0.200
     3.697   -17.292     0.200
     4.339   -21.779     0.200
     4.614   -25.299     0.200
     4.618   -26.985     0.200
     4.659   -28.290     0.200
     4.786   -29.266     0.200
     5.196   -34.087     0.200
     5.665   -35.296     0.200
     2.287    -7.371     0.200
     3.047   -10.539     0.200
     3.691   -16.540     0.200
     3.992   -21.225     0.200
     4.067   -21.802     0.200
     4.121   -22.371     0.200
     4.182   -23.168     0.200
     4.269   -22.390     0.200
     4.269   -24.140     0.200
     4.380   -24.001     0.200
     4.443   -25.591     0.200
     4.565   -22.664     0.200
     4.634   -26.180     0.200
     4.722   -21.727     0.200
     4.980   -27.341     0.200
     5.200   -30.217     0.200
     5.201   -30.926     0.200
     5.415   -30.514     0.200
     5.761   -33.179     0.200
     5.920   -35.614     0.200
     6.017   -37.998     0.200
     6.210   -37.597     0.200
     6.335   -38.499     0.200
     6.421   -38.834     0.200
     6.756   -40.446     0.200
     1.157     3.778     0.200
     1.714    -1.093     0.200
     2.480    -4.991     0.200
     2.572    -7.367     0.200
     2.875    -8.706     0.200
     2.946   -12.543     0.200
     3.676   -14.348     0.200
     3.950   -18.628     0.200
     4.108   -20.377     0.200
     4.360   -20.037     0.200
     4.475   -20.732     0.200
     4.845   -27.976     0.200
     4.909   -28.616     0.200
     4.950   -28.770     0.200
     4.961   -29.120     0.200
     5.118   -30.326     0.200
     5.139   -27.225     0.200
     5.135   -27.989     0.200
     5.228   -30.817     0.200
     5.228   -30.088     0.200
     5.430   -31.921     0.200
     5.522   -30.153     0.200
     5.833   -34.911     0.200
     5.983   -36.954     0.200
     6.030   -35.769     0.200
     6.030   -35.998     0.200
     6.222   -36.454     0.200
     6.398   -39.239     0.200
     6.589   -39.964     0.200
     6.615   -42.584     0.200
     6.710   -42.497     0.200
     6.780   -43.102     0.200
     6.858   -43.090     0.200
     6.858   -44.502     0.200
     7.123   -45.814     0.200
     7.138   -46.955     0.200
     7.150   -44.755     0.200
     7.675   -48.115     0.200
     9.061   -62.711     0.200
     9.193   -62.176     0.200
     2.543    -6.900     0.200
     2.903   -10.167     0.200
     4.868   -28.807     0.200
     4.931   -29.501     0.200
     4.970   -31.865     0.200
     4.976   -28.310     0.200
     5.125   -28.896     0.200
     5.250   -31.425     0.200
     5.230   -31.838     0.200
     5.999   -36.939     0.200
     6.240   -38.411     0.200
     6.725   -42.099     0.200
     0.773     3.980     0.200
     2.939   -11.844     0.200
     3.109   -14.378     0.200
     3.303   -19.096     0.200
     3.739   -21.219     0.200
     3.762   -19.300     0.200
     4.077   -24.779     0.200
     4.152   -26.645     0.200
     4.082   -21.796     0.200
     4.205   -26.982     0.200
     4.263   -26.320     0.200
     4.353   -27.223     0.200
     4.464   -28.645     0.200
     4.516   -27.054     0.200
     4.649   -28.611     0.200
     4.700   -28.919     0.200
     4.771   -26.233     0.200
     5.065   -32.595     0.200
     5.284   -34.843     0.200
     5.282   -33.812     0.200
     5.845   -37.205     0.200
     6.001   -40.170     0.200
     6.086   -42.163     0.200
     6.084   -41.575     0.200
     6.274   -42.106     0.200
     1.185     4.441     0.200
     2.337    -6.179     0.200
     3.392   -16.408     0.200
     3.443   -16.539     0.200
     3.476   -17.549     0.200
     3.489   -17.950     0.200
     3.768   -18.324     0.200
     3.719   -19.734     0.200
     4.020   -21.885     0.200
     4.020   -20.900     0.200
     3.915   -20.760     0.200
     4.056   -18.403     0.200
     4.379   -22.479     0.200
     4.511   -25.069     0.200
     4.745   -25.785     0.200
     5.113   -27.169     0.200
     5.296   -33.074     0.200
     2.890   -11.606     0.200
     3.112   -11.792     0.200
     3.546   -16.859     0.200
     3.852   -20.777     0.200
     3.923   -20.826     0.200
     3.934   -17.540     0.200
     3.973   -22.739     0.200
     3.907   -18.061     0.200
     4.026   -23.027     0.200
     4.143   -24.668     0.200
     4.237   -23.700     0.200
     4.283   -25.023     0.200
     4.487   -24.719     0.200
     4.475   -25.920     0.200
     4.575   -23.664     0.200
     4.840   -28.107     0.200
     5.045   -31.518     0.200
     5.262   -30.795     0.200
     5.765   -35.320     0.200
     5.858   -37.061     0.200
     2.810    -8.901     0.200
     3.290   -13.616     0.200
     4.266   -23.832     0.200
     4.343   -24.081     0.200
     4.399   -24.714     0.200
     4.460   -23.531     0.200
     4.709   -25.931     0.200
     4.903   -28.621     0.200
     4.885   -28.130     0.200
     5.479   -32.345     0.200
     6.270   -40.062     0.200
     2.165    -7.334     0.200
     2.489    -7.024     0.200
     2.564    -7.248     0.200
     2.823    -8.385     0.200
     4.006   -19.394     0.200
     4.253   -21.402     0.200
     4.570   -24.712     0.200
     4.852   -23.003     0.200
     5.157   -28.891     0.200
     5.208   -28.966     0.200
     5.519   -30.870     0.200
     2.376    -6.468     0.200
     2.548    -7.741     0.200
     3.959   -18.425     0.200
     4.370   -20.118     0.200
     4.571   -21.228     0.200
     5.301   -30.816     0.200
     5.360   -31.687     0.200
     5.382   -31.128     0.200
     5.395   -31.552     0.200
     5.384   -27.377     0.200
     5.490   -30.193     0.200
     5.562   -30.054     0.200
     5.606   -33.891     0.200
     5.663   -34.191     0.200
     5.893   -34.374     0.200
     6.289   -38.344     0.200
     6.404   -38.943     0.200
     6.475   -39.627     0.200
     6.656   -41.151     0.200
     7.032   -44.072     0.200
     7.546   -48.564     0.200
     2.162    -8.705     0.200
     2.924   -14.321     0.200
     3.102   -16.684     0.200
     3.577   -19.534     0.200
     3.882   -23.239     0.200
     4.005   -23.600     0.200
     4.060   -24.403     0.200
     4.268   -25.971     0.200
     4.317   -25.787     0.200
     4.461   -26.377     0.200
     4.510   -27.161     0.200
     4.871   -29.766     0.200
     5.079   -32.364     0.200
     5.296   -33.432     0.200
     5.798   -37.971     0.200
     6.085   -40.184     0.200
     6.214   -41.453     0.200
     6.296   -41.709     0.200
     7.454   -51.145     0.200
     1.199     2.280     0.200
     2.141    -6.990     0.200
     2.957   -11.189     0.200
     4.248   -24.640     0.200
     4.367   -25.403     0.200
     5.212   -32.585     0.200
     1.144     3.524     0.200
     1.275     0.546     0.200
     2.835   -11.088     0.200
     3.638   -15.572     0.200
     4.811   -29.020     0.200
     4.877   -29.532     0.200
     4.921   -30.125     0.200
     4.939   -29.761     0.200
     5.107   -32.149     0.200
     5.195   -31.492     0.200
     5.224   -31.619     0.200
     5.392   -32.956     0.200
     5.799   -36.257     0.200
     5.961   -37.436     0.200
     6.686   -42.380     0.200
     3.329   -12.965     0.200
     3.879   -13.950     0.200
     5.350   -30.191     0.200
     5.449   -31.128     0.200
     5.629   -31.134     0.200
     5.905   -33.936     0.200
     6.075   -34.410     0.200
     6.328   -37.795     0.200
     0.349     4.706     0.200
     0.878     0.479     0.200
     1.575    -4.548     0.200
     1.669    -4.214     0.200
     2.018    -9.121     0.200
     2.080    -9.049     0.200
     2.970   -14.404     0.200
     4.534   -29.965     0.200
     4.613   -29.619     0.200
     4.638   -30.169     0.200
     4.637   -30.263     0.200
     5.255   -34.372     0.200
     5.547   -36.700     0.200
     5.588   -37.519     0.200
     6.250   -40.698     0.200
     1.684    -3.588     0.200
     1.893    -6.508     0.200
     1.893    -5.129     0.200
     1.944    -5.366     0.200
     2.449   -13.947     0.200
     2.511   -11.896     0.200
     2.427    -8.186     0.200
     2.517   -10.719     0.200
     2.738   -13.801     0.200
     2.887   -12.836     0.200
     2.928   -14.656     0.200
     3.000   -14.620     0.200
     3.281   -13.978     0.200
     3.367   -15.597     0.200
     3.648   -19.340     0.200
     3.742   -19.088     0.200
     3.989   -22.966     0.200
     4.046   -22.702     0.200
     4.042   -23.950     0.200
     4.073   -24.886     0.200
     4.068   -25.253     0.200
     4.068   -24.433     0.200
     4.123   -22.194     0.200
     4.402   -26.362     0.200
     4.476   -27.800     0.200
     4.451   -27.349     0.200
     4.451   -25.818     0.200
     4.471   -28.523     0.200
     4.442   -23.696     0.200
     4.650   -28.829     0.200
     4.654   -30.288     0.200
     4.684   -29.192     0.200
     4.739   -29.469     0.200
     4.807   -26.496     0.200
     5.005   -32.596     0.200
     5.018   -31.882     0.200
     5.284   -33.184     0.200
     5.284   -33.312     0.200
     5.508   -35.283     0.200
     5.508   -34.662     0.200
     5.668   -37.101     0.200
     5.668   -35.128     0.200
     5.690   -36.172     0.200
     5.738   -38.911     0.200
     5.794   -34.166     0.200
     5.792   -31.604     0.200
     6.046   -39.314     0.200
     6.046   -37.682     0.200
     6.085   -40.708     0.200
     6.146   -39.647     0.200
     6.240   -42.113     0.200
     6.296   -40.206     0.200
     6.388   -44.039     0.200
     6.613   -46.182     0.200
     6.656   -43.420     0.200
     6.689   -46.954     0.200
     6.689   -44.852     0.200
     6.766   -44.602     0.200
     7.077   -45.651     0.200
     7.061   -43.607     0.200
     7.309   -49.386     0.200
     7.309   -49.694     0.200
     7.560   -52.252     0.200
     7.885   -53.580     0.200
     8.019   -54.833     0.200
     8.046   -56.958     0.200
     8.202   -58.408     0.200
     8.421   -54.701     0.200
     8.404   -53.556     0.200
     8.630   -61.143     0.200
     9.098   -65.047     0.200
     9.247   -63.820     0.200
     9.244   -64.716     0.200
     9.436   -66.750     0.200
     9.450   -68.614     0.200
     9.468   -68.937     0.200
     9.534   -65.712     0.200
     9.603   -63.049     0.200
     9.860   -72.568     0.200
    10.811   -80.117     0.200
    12.115   -90.748     0.200
    12.096   -89.457     0.200
    12.274   -91.598     0.200
    13.051   -96.635     0.200
    13.070   -96.945     0.200
    13.371  -100.172     0.200
    13.812  -103.448     0.200
    13.806  -102.377     0.200
    13.920  -102.675     0.200
    14.225  -106.834     0.200
    14.304  -105.655     0.200
    14.331  -105.794     0.200
    14.471  -107.835     0.200
    14.645  -108.354     0.200
    14.769  -112.293     0.200
    15.068  -114.169     0.200
    15.066  -111.210     0.200
    16.295  -120.981     0.200
    16.343  -121.373     0.200
    16.520  -123.703     0.200
    16.990  -126.881     0.200
     1.072     4.335     0.200
     1.045     3.349     0.200
     1.833    -5.180     0.200
     1.836    -5.270     0.200
     1.871    -2.329     0.200
     2.402    -8.967     0.200
     2.402    -8.381     0.200
     2.881   -13.873     0.200
     2.881   -12.841     0.200
     2.794    -7.539     0.200
     3.037   -12.815     0.200
     3.156   -16.370     0.200
     3.443   -16.732     0.200
     3.589   -19.165     0.200
     4.152   -22.894     0.200
     4.445   -26.151     0.200
     4.465   -25.799     0.200
     4.537   -25.970     0.200
     4.534   -23.678     0.200
     4.686   -27.545     0.200
     4.692   -26.468     0.200
     4.700   -28.018     0.200
     4.700   -28.401     0.200
     4.720   -27.835     0.200
     5.033   -29.063     0.200
     5.039   -29.872     0.200
     5.135   -30.282     0.200
     5.135   -29.032     0.200
     5.143   -32.208     0.200
     5.143   -30.177     0.200
     5.262   -31.334     0.200
     5.290   -32.128     0.200
     5.324   -29.371     0.200
     5.350   -31.321     0.200
     5.538   -34.403     0.200
     5.655   -34.101     0.200
     5.708   -31.345     0.200
     5.809   -36.294     0.200
     5.847   -35.880     0.200
     5.865   -36.948     0.200
     5.935   -37.454     0.200
     6.271   -39.112     0.200
     6.517   -41.504     0.200
     6.671   -42.694     0.200
     6.680   -42.157     0.200
     6.680   -41.478     0.200
     6.817   -43.638     0.200
     6.893   -43.547     0.200
     6.876   -44.204     0.200
     7.201   -44.209     0.200
     7.201   -43.920     0.200
     7.224   -45.130     0.200
     7.264   -48.424     0.200
     7.598   -48.795     0.200
     7.776   -52.103     0.200
     7.776   -51.337     0.200
     8.059   -54.701     0.200
     8.195   -53.159     0.200
     8.326   -53.873     0.200
     8.457   -57.106     0.200
     8.549   -57.243     0.200
     8.704   -59.030     0.200
     8.855   -58.923     0.200
     9.503   -65.798     0.200
     9.583   -66.361     0.200
     9.596   -66.214     0.200
     9.692   -66.094     0.200
     9.874   -68.093     0.200
     9.965   -69.431     0.200
    10.240   -71.152     0.200
    10.243   -68.328     0.200
    10.773   -73.727     0.200
    10.994   -74.742     0.200
    11.251   -70.095     0.200
    13.550   -98.758     0.200
     2.229    -6.876     0.200
     2.455   -10.746     0.200
     2.963   -15.389     0.200
     3.260   -16.994     0.200
     3.901   -21.532     0.200
     3.945   -23.318     0.200
     3.973   -22.264     0.200
     3.972   -24.561     0.200
     3.979   -25.074     0.200
     3.995   -18.231     0.200
     4.062   -23.802     0.200
     4.306   -26.359     0.200
     4.372   -24.559     0.200
     4.558   -30.025     0.200
     4.558   -27.654     0.200
     4.586   -28.730     0.200
     4.919   -31.110     0.200
     4.922   -30.672     0.200
     5.194   -32.606     0.200
     5.449   -34.704     0.200
     5.597   -37.189     0.200
     5.613   -36.084     0.200
     5.651   -36.297     0.200
     5.783   -35.705     0.200
     6.009   -40.295     0.200
     1.073     2.731     0.200
     1.204     1.898     0.200
     2.068    -5.564     0.200
     5.882   -35.613     0.200
     5.963   -36.980     0.200
     6.019   -38.265     0.200
     6.064   -38.222     0.200
     6.117   -36.940     0.200
     6.117   -36.659     0.200
     6.196   -37.669     0.200
     6.272   -38.772     0.200
     6.239   -39.951     0.200
     6.520   -39.729     0.200
     6.868   -43.269     0.200
     7.086   -47.404     0.200
     7.310   -46.874     0.200
     7.808   -50.368     0.200
     2.139    -4.360     0.200
     2.662    -6.117     0.200
     3.346   -13.457     0.200
     3.321   -10.048     0.200
     4.155   -16.700     0.200
     4.595   -24.776     0.200
     4.638   -25.756     0.200
     4.642   -22.366     0.200
     4.701   -24.608     0.200
     4.777   -26.239     0.200
     4.967   -27.466     0.200
     4.989   -27.183     0.200
     5.219   -29.762     0.200
     5.635   -35.397     0.200
     2.387    -9.391     0.200
     2.388    -5.523     0.200
     2.450    -6.015     0.200
     2.503    -8.265     0.200
     2.904   -10.558     0.200
     2.904   -11.326     0.200
     2.957   -11.923     0.200
     3.039   -14.520     0.200
     3.264   -15.122     0.200
     3.408   -15.899     0.200
     3.521   -17.083     0.200
     3.651   -16.658     0.200
     3.784   -17.386     0.200
     3.784   -16.149     0.200
     3.888   -16.601     0.200
     4.131   -21.488     0.200
     4.131   -20.484     0.200
     4.413   -24.893     0.200
     4.459   -25.826     0.200
     4.459   -25.935     0.200
     4.446   -24.627     0.200
     4.482   -25.895     0.200
     4.553   -27.166     0.200
     4.553   -24.822     0.200
     4.549   -20.593     0.200
     4.645   -26.732     0.200
     4.767   -26.324     0.200
     4.767   -25.406     0.200
     4.786   -27.511     0.200
     4.806   -26.943     0.200
     4.925   -29.326     0.200
     5.029   -28.606     0.200
     5.038   -29.205     0.200
     5.058   -30.536     0.200
     5.001   -23.797     0.200
     5.203   -31.241     0.200
     5.285   -30.373     0.200
     5.399   -32.022     0.200
     5.467   -33.166     0.200
     5.726   -34.212     0.200
     5.825   -31.014     0.200
     6.032   -38.407     0.200
     6.032   -38.795     0.200
     6.113   -36.973     0.200
     6.171   -34.312     0.200
     6.197   -39.542     0.200
     6.194   -39.091     0.200
     6.273   -32.361     0.200
     6.427   -38.861     0.200
     6.584   -43.770     0.200
     6.608   -42.977     0.200
     6.669   -41.009     0.200
     6.711   -42.720     0.200
     7.092   -45.901     0.200
     7.156   -45.738     0.200
     7.156   -45.618     0.200
     7.137   -47.133     0.200
     7.207   -46.251     0.200
     7.207   -44.112     0.200
     7.539   -48.972     0.200
     7.510   -46.100     0.200
     7.510   -44.988     0.200
     7.651   -50.259     0.200
     7.729   -47.376     0.200
     7.794   -51.538     0.200
     8.031   -53.286     0.200
     8.507   -57.688     0.200
     8.515   -57.705     0.200
     8.513   -57.549     0.200
     8.672   -58.449     0.200
     9.089   -62.364     0.200
     9.494   -66.343     0.200
     9.762   -68.193     0.200
     9.769   -67.705     0.200
     9.792   -64.903     0.200
     9.912   -68.146     0.200
    10.021   -66.740     0.200
     9.988   -70.117     0.200
    10.021   -70.661     0.200
    10.060   -69.101     0.200
    10.074   -61.961     0.200
    10.125   -67.204     0.200
    10.244   -67.834     0.200
    10.244   -68.129     0.200
    10.244   -66.610     0.200
    10.375   -73.782     0.200
    14.229  -102.563     0.200
    14.444  -105.456     0.200
    14.829  -108.976     0.200
    14.854  -109.463     0.200
    15.171  -111.924     0.200
    15.492  -113.790     0.200
     1.151     5.697     0.200
     1.242     5.658     0.200
     2.708    -5.253     0.200
     2.186    -5.280     0.200
     2.382    -6.667     0.200
     2.904   -11.734     0.200
     3.034   -15.440     0.200
     3.384   -15.601     0.200
     3.402   -18.811     0.200
     3.518   -17.824     0.200
     3.648   -17.722     0.200
     3.783   -18.363     0.200
     3.885   -18.223     0.200
     4.405   -24.585     0.200
     4.439   -25.786     0.200
     4.450   -25.423     0.200
     4.474   -26.382     0.200
     4.547   -27.749     0.200
     4.547   -22.534     0.200
     4.641   -27.320     0.200
     4.758   -27.703     0.200
     4.758   -26.465     0.200
     4.778   -27.408     0.200
     4.797   -29.353     0.200
     4.797   -26.623     0.200
     4.918   -29.051     0.200
     5.020   -28.790     0.200
     4.999   -25.546     0.200
     4.999   -24.581     0.200
     5.030   -31.901     0.200
     5.030   -29.100     0.200
     5.050   -29.940     0.200
     5.390   -32.017     0.200
     5.460   -34.094     0.200
     5.551   -33.123     0.200
     5.719   -33.831     0.200
     5.824   -33.284     0.200
     6.028   -39.303     0.200
     6.105   -37.281     0.200
     6.190   -39.372     0.200
     6.190   -39.668     0.200
     6.190   -39.430     0.200
     6.419   -41.055     0.200
     6.577   -44.049     0.200
     6.601   -43.007     0.200
     6.662   -42.520     0.200
     6.703   -41.324     0.200
     7.084   -44.115     0.200
     7.149   -45.973     0.200
     7.532   -48.302     0.200
     7.649   -50.364     0.200
     7.787   -50.906     0.200
     8.025   -53.525     0.200
     8.373   -54.969     0.200
     8.507   -59.485     0.200
     8.665   -61.249     0.200
     8.806   -59.788     0.200
     9.757   -69.188     0.200
    10.057   -68.815     0.200
     3.365   -13.240     0.200
     4.500   -24.682     0.200
     4.543   -27.756     0.200
     4.872   -29.065     0.200
     5.484   -31.894     0.200
     2.478    -6.273     0.200
     4.464   -22.664     0.200
     4.508   -25.739     0.200
     4.860   -24.309     0.200
     5.082   -28.852     0.200
     5.088   -28.845     0.200
     5.449   -30.676     0.200
     6.159   -37.482     0.200
     3.040   -15.749     0.200
     3.389   -10.944     0.200
     3.441   -12.913     0.200
     3.507   -19.056     0.200
     3.644   -15.886     0.200
     3.762   -18.315     0.200
     4.203   -21.329     0.200
     4.468   -27.004     0.200
     4.492   -26.619     0.200
     4.513   -27.808     0.200
     4.534   -21.829     0.200
     4.562   -27.990     0.200
     4.646   -27.234     0.200
     4.809   -29.350     0.200
     4.809   -26.661     0.200
     4.821   -27.339     0.200
     4.982   -23.906     0.200
     5.068   -28.785     0.200
     5.073   -31.645     0.200
     5.073   -29.335     0.200
     5.434   -31.570     0.200
     5.489   -34.221     0.200
     5.752   -34.562     0.200
     6.032   -39.137     0.200
     6.142   -36.929     0.200
     6.220   -38.391     0.200
     3.003   -13.765     0.200
     3.456   -15.437     0.200
     3.705   -16.955     0.200
     3.822   -15.595     0.200
     4.453   -23.595     0.200
     4.455   -25.308     0.200
     4.455   -24.616     0.200
     4.492   -25.537     0.200
     4.510   -26.086     0.200
     4.482   -18.704     0.200
     4.533   -24.976     0.200
     4.608   -25.836     0.200
     4.822   -27.772     0.200
     4.822   -25.585     0.200
     4.822   -26.900     0.200
     4.856   -26.279     0.200
     4.928   -22.834     0.200
     5.075   -27.798     0.200
     5.436   -31.357     0.200
     5.474   -32.642     0.200
     5.584   -34.259     0.200
     5.742   -33.654     0.200
     5.993   -37.242     0.200
     6.150   -38.349     0.200
     6.206   -38.153     0.200
     7.097   -45.721     0.200
     7.097   -45.447     0.200
     7.789   -51.780     0.200
     7.789   -49.647     0.200
     5.596   -30.602     0.200
     1.198     4.793     0.200
     2.985    -6.670     0.200
     3.293    -9.244     0.200
     3.457   -13.697     0.200
     3.509   -11.043     0.200
     4.057   -19.285     0.200
     4.225   -18.389     0.200
     4.476   -19.143     0.200
     4.472   -21.798     0.200
     4.760   -21.389     0.200
     5.028   -23.551     0.200
     5.127   -23.723     0.200
     5.208   -28.377     0.200
     5.297   -28.693     0.200
     5.361   -30.244     0.200
     5.425   -30.472     0.200
     5.425   -29.563     0.200
     5.439   -29.944     0.200
     5.508   -30.703     0.200
     5.600   -30.913     0.200
     5.678   -31.681     0.200
     5.747   -32.372     0.200
     5.846   -33.217     0.200
     5.829   -32.668     0.200
     5.893   -33.486     0.200
     6.191   -35.353     0.200
     6.457   -38.773     0.200
     6.665   -39.056     0.200
     6.999   -40.453     0.200
     7.174   -43.907     0.200
     7.203   -43.157     0.200
     7.203   -41.833     0.200
     7.217   -45.322     0.200
     7.394   -44.641     0.200
     7.590   -46.901     0.200
     7.672   -46.511     0.200
     8.148   -50.068     0.200
     8.835   -55.735     0.200
     9.580   -61.260     0.200
     9.663   -63.094     0.200
     2.364    -5.278     0.200
     5.378   -30.683     0.200
     5.436   -31.947     0.200
     5.740   -33.158     0.200
     1.221     4.555     0.200
     1.959    -2.475     0.200
     2.286    -4.222     0.200
     3.053    -9.620     0.200
     3.487   -15.494     0.200
     3.469   -13.285     0.200
     3.696   -14.030     0.200
     4.568   -25.938     0.200
     4.546   -23.145     0.200
     4.489   -20.233     0.200
     4.616   -24.585     0.200
     4.598   -23.013     0.200
     4.654   -22.906     0.200
     4.947   -26.899     0.200
     4.947   -25.438     0.200
     4.935   -27.856     0.200
     5.197   -28.066     0.200
     5.550   -32.237     0.200
     5.564   -31.950     0.200
     5.689   -33.348     0.200
     6.036   -34.460     0.200
     6.239   -36.985     0.200
     0.967     2.783     0.200
     1.334    -1.456     0.200
     3.053   -12.082     0.200
     4.697   -28.000     0.200
     4.754   -29.513     0.200
     4.789   -29.385     0.200
     4.782   -30.757     0.200
     5.014   -29.347     0.200
     4.918   -30.984     0.200
     5.066   -31.194     0.200
     5.077   -31.432     0.200
     5.294   -32.725     0.200
     5.685   -35.518     0.200
     5.804   -37.991     0.200
     6.425   -41.983     0.200
     1.175     6.317     0.200
     1.450     1.177     0.200
     1.711    -2.521     0.200
     2.694    -6.784     0.200
     2.854    -7.680     0.200
     2.728    -8.109     0.200
     2.939    -8.592     0.200
     3.374   -12.660     0.200
     3.399   -12.604     0.200
     3.277    -8.574     0.200
     3.652   -17.222     0.200
     3.719   -17.736     0.200
     3.765   -18.314     0.200
     3.753   -14.398     0.200
     3.813   -19.126     0.200
     4.073   -19.402     0.200
     3.939   -13.829     0.200
     4.240   -20.272     0.200
     4.400   -19.330     0.200
     4.641   -24.758     0.200
     4.846   -25.459     0.200
     5.405   -29.195     0.200
     5.553   -31.863     0.200
     5.665   -31.927     0.200
     5.654   -34.482     0.200
     5.777   -28.858     0.200
     5.851   -34.001     0.200
     6.048   -35.273     0.200
     7.207   -45.696     0.200
     7.433   -45.294     0.200
     7.952   -50.264     0.200
     8.041   -52.549     0.200
     0.969     1.741     0.200
     1.824    -5.712     0.200
     1.817    -6.447     0.200
     2.083    -7.908     0.200
     2.806   -12.212     0.200
     3.490   -18.845     0.200
     3.452   -14.958     0.200
     3.636   -14.227     0.200
     4.677   -29.280     0.200
     4.691   -27.300     0.200
     4.769   -31.322     0.200
     0.885     3.018     0.200
     1.731    -4.500     0.200
     2.365    -7.406     0.200
     3.496   -19.663     0.200
     3.560   -19.416     0.200
     3.668   -17.380     0.200
     3.707   -16.453     0.200
     4.512   -23.648     0.200
     4.624   -29.971     0.200
     4.659   -27.737     0.200
     4.661   -27.770     0.200
     4.693   -28.493     0.200
     4.702   -26.812     0.200
     4.704   -30.199     0.200
     5.026   -30.740     0.200
     5.045   -30.685     0.200
     5.045   -30.536     0.200
     5.075   -30.878     0.200
     5.281   -32.829     0.200
     5.293   -32.387     0.200
     5.641   -35.333     0.200
     6.082   -40.253     0.200
     6.324   -40.278     0.200
     6.373   -40.352     0.200
     2.083    -5.552     0.200
     2.143    -4.621     0.200
     3.540   -17.819     0.200
     4.178   -16.863     0.200
     4.478   -24.618     0.200
     4.501   -25.909     0.200
     4.522   -26.899     0.200
     4.544   -26.762     0.200
     4.597   -27.281     0.200
     4.681   -27.924     0.200
     4.835   -28.781     0.200
     4.835   -30.117     0.200
     4.850   -29.408     0.200
     4.873   -27.342     0.200
     5.463   -32.031     0.200
     6.173   -38.657     0.200
     6.253   -39.968     0.200
     0.996     1.943     0.200
     1.192     1.571     0.200
     2.878   -11.010     0.200
     2.958    -9.961     0.200
     3.338   -13.083     0.200
     3.567   -14.308     0.200
     3.780   -16.910     0.200
     4.039   -25.501     0.200
     4.115   -25.276     0.200
     4.400   -27.838     0.200
     6.367   -42.235     0.200
     0.893     5.021     0.200
     1.008     3.799     0.200
     1.091     4.351     0.200
     2.664    -9.050     0.200
     3.032   -11.118     0.200
     3.725   -21.744     0.200
     3.737   -18.637     0.200
     3.849   -22.479     0.200
     1.124     3.520     0.200
     1.206     4.188     0.200
     1.211     3.674     0.200
     1.249     3.418     0.200
     1.643    -0.308     0.200
     1.741    -0.928     0.200
     2.041    -6.917     0.200
     2.042    -5.987     0.200
     2.498    -8.992     0.200
     2.554    -9.517     0.200
     2.685    -6.882     0.200
     2.803   -11.649     0.200
     2.954    -9.705     0.200
     3.051   -12.394     0.200
     3.533   -12.354     0.200
     3.898   -18.599     0.200
     3.977   -19.207     0.200
     3.933   -15.771     0.200
     4.159   -22.579     0.200
     4.389   -25.307     0.200
     4.431   -22.932     0.200
     4.452   -24.024     0.200
     4.773   -25.393     0.200
     4.689   -23.028     0.200
     4.945   -27.040     0.200
     4.963   -28.966     0.200
     4.963   -26.919     0.200
     5.134   -28.042     0.200
     5.383   -30.535     0.200
     5.354   -30.203     0.200
     5.409   -31.359     0.200
     5.861   -34.378     0.200
     6.394   -36.777     0.200
     6.554   -37.732     0.200
     6.767   -38.908     0.200
     2.081    -4.212     0.200
     2.385    -5.608     0.200
     3.247   -14.844     0.200
     3.410   -16.831     0.200
     3.496   -14.652     0.200
     3.632   -15.530     0.200
     3.753   -16.578     0.200
     3.862   -16.916     0.200
     4.095   -17.859     0.200
     4.433   -24.543     0.200
     4.453   -25.036     0.200
     4.476   -25.293     0.200
     4.497   -25.893     0.200
     4.523   -22.225     0.200
     4.548   -26.105     0.200
     4.632   -25.583     0.200
     4.793   -26.616     0.200
     4.793   -26.046     0.200
     4.805   -26.913     0.200
     4.831   -26.533     0.200
     4.934   -29.108     0.200
     4.972   -22.343     0.200
     5.052   -28.965     0.200
     5.074   -29.036     0.200
     5.418   -30.946     0.200
     5.573   -33.573     0.200
     5.573   -33.903     0.200
     6.018   -37.618     0.200
     6.178   -38.033     0.200
     6.204   -38.274     0.200
     6.581   -42.037     0.200
     6.615   -42.091     0.200
     6.725   -40.899     0.200
     6.896   -44.658     0.200
     7.162   -44.322     0.200
     7.545   -47.991     0.200
     7.627   -47.406     0.200
     7.795   -52.589     0.200
     7.795   -49.110     0.200
     8.036   -51.040     0.200
     8.147   -52.658     0.200
     8.378   -55.193     0.200
     8.512   -56.452     0.200
     8.520   -56.080     0.200
     8.677   -58.501     0.200
     8.818   -57.646     0.200
     1.096     5.120     0.200
     1.473    -2.432     0.200
     2.692    -9.878     0.200
     2.969    -9.530     0.200
     3.059    -9.538     0.200
     3.338   -12.318     0.200
     3.796   -20.131     0.200
     3.928   -21.964     0.200
     3.845   -18.229     0.200
     3.936   -22.334     0.200
     2.675    -8.892     0.200
     2.971   -10.657     0.200
     3.707   -16.121     0.200
     3.713   -20.054     0.200
     3.733   -19.760     0.200
     3.831   -22.758     0.200
     2.109    -5.424     0.200
     2.404    -7.509     0.200
     3.500   -17.068     0.200
     3.752   -16.988     0.200
     3.866   -19.454     0.200
     4.461   -26.838     0.200
     4.475   -26.632     0.200
     4.503   -27.158     0.200
     4.523   -26.677     0.200
     4.564   -27.654     0.200
     4.645   -26.172     0.200
     4.832   -29.489     0.200
     4.974   -27.517     0.200
     5.081   -29.699     0.200
     5.445   -31.233     0.200
     6.030   -38.429     0.200
     6.151   -37.914     0.200
     6.188   -39.083     0.200
     6.227   -39.103     0.200
     4.518   -25.139     0.200
     4.541   -27.425     0.200
     4.603   -26.786     0.200
     4.690   -27.481     0.200
     4.846   -27.531     0.200
     4.866   -26.478     0.200
     1.906    -4.149     0.200
     2.902    -9.814     0.200
     3.386   -14.355     0.200
     3.478   -16.858     0.200
     3.604   -17.260     0.200
     3.846   -20.295     0.200
     4.459   -19.129     0.200
     4.793   -25.944     0.200
     4.824   -27.683     0.200
     4.898   -28.507     0.200
     5.037   -28.966     0.200
     5.040   -28.472     0.200
     5.050   -28.878     0.200
     5.388   -31.499     0.200
     5.464   -31.452     0.200
     5.479   -31.692     0.200
     5.616   -32.146     0.200
     5.639   -36.152     0.200
     5.689   -33.136     0.200
     6.004   -36.332     0.200
     6.097   -37.270     0.200
     6.208   -37.991     0.200
     6.633   -40.468     0.200
     6.636   -40.565     0.200
     1.175     2.432     0.200
     1.241     3.680     0.200
     1.320     0.669     0.200
     5.427   -31.661     0.200
     5.525   -33.196     0.200
     5.600   -35.002     0.200
     5.705   -34.241     0.200
     5.821   -35.278     0.200
     5.944   -35.859     0.200
     5.976   -37.568     0.200
     6.143   -37.715     0.200
     6.405   -40.262     0.200
     7.431   -46.501     0.200
     7.530   -48.193     0.200
     3.811   -23.285     0.200
     3.847   -23.975     0.200
     3.860   -23.460     0.200
     4.069   -23.530     0.200
     4.133   -24.602     0.200
     4.133   -24.707     0.200
     4.239   -27.285     0.200
     4.742   -30.315     0.200
     5.117   -33.192     0.200
     5.484   -35.942     0.200
     5.607   -36.716     0.200
     2.051    -4.070     0.200
     3.464   -18.752     0.200
     3.561   -17.361     0.200
     4.471   -26.179     0.200
     4.517   -27.414     0.200
     4.503   -26.298     0.200
     4.540   -26.598     0.200
     4.606   -24.240     0.200
     4.588   -21.237     0.200
     4.694   -27.013     0.200
     4.824   -28.106     0.200
     4.824   -28.442     0.200
     4.844   -27.700     0.200
     4.864   -28.112     0.200
     5.087   -30.880     0.200
     5.096   -30.293     0.200
     5.457   -32.611     0.200
     5.617   -35.301     0.200
     5.784   -36.083     0.200
     6.171   -38.157     0.200
     6.638   -42.526     0.200
     2.957   -10.872     0.200
     3.409   -15.027     0.200
     3.775   -19.237     0.200
     3.853   -19.544     0.200
     4.046   -21.556     0.200
     4.310   -23.853     0.200
     4.413   -21.833     0.200
     4.651   -24.232     0.200
     4.735   -27.700     0.200
     4.800   -28.474     0.200
     4.843   -28.158     0.200
     4.859   -28.448     0.200
     5.028   -30.465     0.200
     5.028   -30.894     0.200
     5.088   -31.521     0.200
     5.088   -30.380     0.200
     5.118   -31.054     0.200
     5.075   -24.975     0.200
     5.146   -30.381     0.200
     5.319   -31.608     0.200
     5.328   -32.703     0.200
     5.369   -33.876     0.200
     5.369   -31.396     0.200
     5.414   -32.640     0.200
     5.528   -28.079     0.200
     5.723   -36.336     0.200
     5.923   -37.272     0.200
     5.923   -36.292     0.200
     6.118   -37.636     0.200
     6.482   -40.375     0.200
     6.534   -42.165     0.200
     6.607   -42.143     0.200
     6.703   -43.611     0.200
     6.748   -44.258     0.200
     6.748   -41.805     0.200
     7.021   -46.770     0.200
     7.043   -46.677     0.200
     7.574   -47.888     0.200
     7.640   -50.401     0.200
     7.949   -53.198     0.200
     8.175   -52.809     0.200
     8.234   -54.238     0.200
     8.234   -55.316     0.200
     8.453   -55.482     0.200
     8.563   -57.254     0.200
     8.830   -59.723     0.200
     8.933   -60.972     0.200
     8.965   -59.595     0.200
     9.091   -60.041     0.200
     9.227   -62.007     0.200
     9.495   -65.523     0.200
    10.001   -68.829     0.200
    10.246   -71.164     0.200
     1.587     0.214     0.200
     2.305    -6.008     0.200
     3.467   -13.215     0.200
     3.468   -12.320     0.200
     4.014   -17.272     0.200
     4.190   -20.229     0.200
     4.430   -21.937     0.200
     4.737   -23.506     0.200
     4.842   -25.079     0.200
     5.147   -29.604     0.200
     5.012   -23.348     0.200
     5.105   -24.036     0.200
     5.238   -31.062     0.200
     5.304   -30.534     0.200
     5.361   -32.081     0.200
     5.361   -31.159     0.200
     5.387   -30.807     0.200
     5.540   -31.851     0.200
     5.684   -33.114     0.200
     5.636   -31.794     0.200
     5.839   -34.531     0.200
     5.864   -34.522     0.200
     5.793   -34.111     0.200
     5.768   -29.937     0.200
     6.380   -38.364     0.200
     6.380   -38.106     0.200
     6.609   -40.036     0.200
     6.941   -43.256     0.200
     7.141   -43.545     0.200
     7.141   -42.608     0.200
     7.120   -43.547     0.200
     7.181   -45.810     0.200
     7.518   -50.155     0.200
     7.360   -46.553     0.200
     7.507   -45.712     0.200
     7.537   -49.144     0.200
     7.625   -49.435     0.200
     7.941   -50.250     0.200
     8.101   -50.933     0.200
     8.287   -54.066     0.200
     8.784   -56.521     0.200
     8.784   -56.794     0.200
     8.861   -55.424     0.200
     8.978   -57.336     0.200
     9.086   -59.751     0.200
     9.396   -61.270     0.200
     9.531   -63.189     0.200
     9.728   -60.924     0.200
     9.610   -63.501     0.200
    10.529   -71.680     0.200
    10.859   -72.536     0.200
    10.926   -72.557     0.200
     1.144     1.998     0.200
     1.273     1.384     0.200
     2.808    -8.455     0.200
     2.815   -11.428     0.200
     3.884   -21.024     0.200
     3.960   -21.415     0.200
     4.014   -23.816     0.200
     4.080   -24.486     0.200
     4.161   -24.183     0.200
     4.161   -22.409     0.200
     4.352   -24.509     0.200
     4.456   -24.362     0.200
     4.534   -27.617     0.200
     4.551   -28.592     0.200
     4.660   -23.685     0.200
     4.872   -28.438     0.200
     5.309   -32.593     0.200
     5.815   -37.339     0.200
     5.933   -39.147     0.200
     1.128     4.094     0.200
     1.302     2.953     0.200
     1.332     2.152     0.200
     2.870    -9.415     0.200
     2.975    -8.538     0.200
     3.008   -10.231     0.200
     3.357   -15.150     0.200
     3.919   -21.554     0.200
     3.829   -18.154     0.200
     4.337   -24.417     0.200
     4.502   -22.651     0.200
     4.546   -25.728     0.200
     1.225     4.090     0.200
     1.305     3.154     0.200
     1.334     3.281     0.200
     2.404    -5.883     0.200
     2.721    -7.227     0.200
     2.821    -7.896     0.200
     2.893    -9.691     0.200
     3.100    -8.169     0.200
     3.156    -8.483     0.200
     3.450   -12.264     0.200
     3.769   -14.016     0.200
     4.312   -18.992     0.200
     4.753   -24.347     0.200
     4.794   -25.716     0.200
     4.794   -25.034     0.200
     4.815   -24.771     0.200
     5.018   -25.727     0.200
     5.137   -27.173     0.200
     5.495   -29.751     0.200
     5.747   -33.425     0.200
     2.886    -9.019     0.200
     2.592    -8.133     0.200
     3.394   -13.164     0.200
     4.886   -30.131     0.200
     4.963   -30.668     0.200
     5.274   -33.339     0.200
     5.526   -34.111     0.200
     5.523   -31.823     0.200
     1.353     1.551     0.200
     3.061    -8.684     0.200
     3.900   -20.593     0.200
     3.954   -21.995     0.200
     4.021   -22.241     0.200
     4.165   -20.307     0.200
     4.212   -21.784     0.200
     4.297   -23.880     0.200
     4.501   -24.338     0.200
     5.039   -29.551     0.200
     5.756   -34.527     0.200
     2.748    -9.115     0.200
     3.077   -11.638     0.200
     3.626   -18.253     0.200
     3.817   -19.949     0.200
     3.895   -21.039     0.200
     3.967   -24.110     0.200
     3.900   -18.112     0.200
     4.017   -25.872     0.200
     4.072   -26.455     0.200
     4.281   -26.371     0.200
     4.328   -26.475     0.200
     4.473   -25.578     0.200
     4.530   -28.994     0.200
     4.530   -26.085     0.200
     4.519   -27.863     0.200
     4.613   -24.524     0.200
     4.883   -28.268     0.200
     5.098   -28.106     0.200
     5.308   -33.321     0.200
     5.810   -38.455     0.200
     5.902   -37.998     0.200
     6.307   -42.303     0.200
     0.449     3.962     0.200
     0.955     1.188     0.200
     1.099    -1.038     0.200
     1.079    -1.862     0.200
     1.254    -2.130     0.200
     1.386    -2.477     0.200
     2.163    -9.438     0.200
     2.555   -10.964     0.200
     2.654   -13.207     0.200
     2.543   -10.268     0.200
     2.658   -12.146     0.200
     4.104   -27.101     0.200
     4.195   -27.895     0.200
     4.497   -29.552     0.200
     4.742   -33.562     0.200
     5.087   -34.164     0.200
     6.094   -42.386     0.200
     3.420   -13.092     0.200
     5.194   -30.534     0.200
     5.275   -31.304     0.200
     5.436   -32.200     0.200
     5.436   -31.583     0.200
     5.512   -35.134     0.200
     5.512   -32.509     0.200
     5.584   -33.390     0.200
     5.749   -34.112     0.200
     5.846   -36.005     0.200
     5.897   -36.226     0.200
     6.180   -38.095     0.200
     6.411   -38.500     0.200
     6.626   -41.618     0.200
     6.971   -43.473     0.200
     7.127   -45.922     0.200
     7.197   -44.136     0.200
     7.543   -49.392     0.200
     8.981   -58.575     0.200
     9.089   -59.816     0.200
     1.163     2.527     0.200
     1.620    -3.087     0.200
     2.447    -6.834     0.200
     2.602    -7.915     0.200
     2.842   -10.392     0.200
     2.951   -10.296     0.200
     3.002   -11.690     0.200
     3.252   -12.476     0.200
     3.541   -16.970     0.200
     3.715   -18.726     0.200
     3.887   -18.905     0.200
     4.135   -23.292     0.200
     4.540   -24.175     0.200
     4.721   -25.071     0.200
     4.890   -28.962     0.200
     4.974   -29.717     0.200
     4.974   -30.186     0.200
     5.034   -30.987     0.200
     5.102   -30.606     0.200
     5.127   -29.576     0.200
     5.204   -32.351     0.200
     5.204   -31.015     0.200
     5.281   -32.041     0.200
     5.336   -31.933     0.200
     5.441   -31.925     0.200
     5.470   -31.271     0.200
     5.491   -32.948     0.200
     5.528   -34.875     0.200
     5.528   -32.289     0.200
     5.558   -34.811     0.200
     5.598   -33.991     0.200
     5.876   -36.204     0.200
     6.112   -37.791     0.200
     6.121   -39.610     0.200
     6.333   -40.087     0.200
     6.673   -41.767     0.200
     6.839   -43.839     0.200
     7.057   -44.970     0.200
     7.255   -47.526     0.200
     8.496   -55.542     0.200
     8.803   -58.692     0.200
     9.239   -64.445     0.200
     2.221    -7.506     0.200
     3.428   -17.578     0.200
     3.468   -19.117     0.200
     3.797   -21.465     0.200
     3.939   -23.066     0.200
     4.050   -24.167     0.200
     4.411   -26.327     0.200
     1.264     2.936     0.200
     1.507    -0.667     0.200
     1.788    -2.709     0.200
     2.205    -3.540     0.200
     2.983    -8.444     0.200
     4.290   -21.485     0.200
     5.260   -29.314     0.200
     5.350   -31.467     0.200
     5.417   -30.222     0.200
     5.472   -31.219     0.200
     5.498   -31.343     0.200
     5.557   -32.114     0.200
     5.653   -32.766     0.200
     5.742   -33.577     0.200
     5.899   -33.856     0.200
     5.894   -34.053     0.200
     5.951   -35.817     0.200
     6.243   -37.166     0.200
     6.492   -38.982     0.200
     6.516   -39.037     0.200
     6.722   -40.744     0.200
     7.232   -45.036     0.200
     1.040     4.092     0.200
     1.146     3.493     0.200
     1.239     2.479     0.200
     1.731    -4.627     0.200
     2.329    -8.837     0.200
     2.760   -10.741     0.200
     2.906   -11.576     0.200
     3.024   -12.181     0.200
     3.127   -11.780     0.200
     3.787   -16.844     0.200
     3.889   -22.486     0.200
     3.885   -19.321     0.200
     3.928   -20.078     0.200
     4.016   -23.053     0.200
     4.016   -24.341     0.200
     4.026   -23.071     0.200
     4.365   -24.805     0.200
     4.382   -26.345     0.200
     4.616   -28.312     0.200
     4.616   -27.273     0.200
     4.898   -30.319     0.200
     4.981   -29.430     0.200
     5.075   -30.107     0.200
     5.066   -27.033     0.200
     5.194   -31.197     0.200
     5.309   -32.305     0.200
     5.460   -32.749     0.200
     5.616   -34.469     0.200
     5.631   -34.156     0.200
     0.998     5.948     0.200
     1.502     0.030     0.200
     1.767    -1.101     0.200
     2.197    -4.927     0.200
     2.776    -7.693     0.200
     2.978   -10.402     0.200
     3.262   -12.571     0.200
     3.412   -13.540     0.200
     3.662   -12.509     0.200
     3.725   -12.543     0.200
     5.333   -30.384     0.200
     5.400   -30.552     0.200
     5.483   -30.261     0.200
     5.538   -31.074     0.200
     5.635   -31.656     0.200
     5.729   -33.725     0.200
     5.777   -32.961     0.200
     5.881   -35.284     0.200
     5.881   -33.644     0.200
     5.884   -35.730     0.200
     5.935   -34.567     0.200
     6.225   -37.347     0.200
     6.501   -39.063     0.200
     7.037   -41.582     0.200
     7.216   -46.286     0.200
     1.636     0.207     0.200
     2.516    -5.640     0.200
     2.774    -7.300     0.200
     2.872    -6.512     0.200
     3.258   -10.461     0.200
     3.339   -11.886     0.200
     3.366   -13.192     0.200
     3.553   -15.181     0.200
     3.757   -12.984     0.200
     3.868   -13.786     0.200
     4.097   -16.909     0.200
     3.872   -12.550     0.200
     4.288   -20.576     0.200
     4.503   -20.597     0.200
     4.545   -22.698     0.200
     4.853   -24.587     0.200
     4.949   -22.870     0.200
     5.175   -27.923     0.200
     5.137   -24.655     0.200
     5.272   -29.276     0.200
     5.344   -31.115     0.200
     5.369   -29.762     0.200
     5.445   -31.242     0.200
     5.459   -32.515     0.200
     5.459   -30.314     0.200
     5.570   -31.422     0.200
     5.699   -32.239     0.200
     5.717   -33.854     0.200
     5.814   -35.564     0.200
     5.814   -32.166     0.200
     5.891   -34.019     0.200
     5.900   -33.702     0.200
     5.888   -34.322     0.200
     6.155   -36.181     0.200
     6.417   -39.107     0.200
     6.417   -37.575     0.200
     6.460   -38.883     0.200
     6.655   -39.133     0.200
     6.852   -39.477     0.200
     6.978   -41.468     0.200
     7.162   -41.688     0.200
     7.172   -43.016     0.200
     7.275   -45.743     0.200
     7.458   -47.280     0.200
     7.539   -45.350     0.200
     7.589   -46.123     0.200
     8.147   -49.334     0.200
     8.250   -56.116     0.200
     8.845   -54.964     0.200
     8.973   -58.585     0.200
     9.032   -57.266     0.200
     9.139   -57.861     0.200
     9.461   -60.072     0.200
     9.596   -62.095     0.200
     9.661   -64.326     0.200
    10.939   -73.044     0.200
     1.075     3.940     0.200
     1.139     2.958     0.200
     1.354    -0.966     0.200
     2.069    -4.092     0.200
     2.015    -3.800     0.200
     3.418   -12.885     0.200
     3.827   -15.045     0.200
     3.763   -14.744     0.200
     4.480   -24.737     0.200
     5.017   -29.475     0.200
     5.508   -34.149     0.200
     5.579   -33.025     0.200
     5.609   -34.340     0.200
     5.672   -33.144     0.200
     5.699   -34.188     0.200
     5.807   -36.926     0.200
     5.939   -36.810     0.200
     5.927   -38.285     0.200
     6.052   -36.086     0.200
     6.084   -38.254     0.200
     6.121   -37.974     0.200
     6.394   -39.819     0.200
     6.688   -42.731     0.200
     6.852   -42.953     0.200
     7.402   -45.888     0.200
     1.268     2.029     0.200
     2.423    -8.219     0.200
     3.834   -17.661     0.200
     4.405   -22.066     0.200
     4.497   -23.365     0.200
     4.878   -28.578     0.200
     4.878   -26.644     0.200
     4.941   -26.114     0.200
     4.941   -29.063     0.200
     5.022   -28.643     0.200
     5.018   -30.062     0.200
     5.101   -28.938     0.200
     5.101   -30.997     0.200
     5.183   -30.350     0.200
     5.269   -30.328     0.200
     5.269   -32.332     0.200
     5.435   -32.382     0.200
     5.435   -31.957     0.200
     5.471   -32.272     0.200
     5.471   -32.499     0.200
     5.777   -34.558     0.200
     6.243   -37.348     0.200
     6.753   -42.194     0.200
     6.821   -44.832     0.200
     7.169   -44.689     0.200
     1.311     1.864     0.200
     2.101    -4.455     0.200
     2.112    -6.445     0.200
     2.793    -7.613     0.200
     3.405   -12.411     0.200
     3.378   -10.526     0.200
     4.489   -25.797     0.200
     4.809   -26.838     0.200
     4.818   -26.929     0.200
     4.846   -27.605     0.200
     4.944   -29.617     0.200
     5.067   -28.428     0.200
     5.070   -28.626     0.200
     5.070   -31.186     0.200
     5.585   -33.540     0.200
     5.747   -34.065     0.200
     6.138   -36.764     0.200
     6.214   -38.965     0.200
     5.383   -31.516     0.200
     5.865   -34.777     0.200
     5.959   -35.462     0.200
     1.202     4.882     0.200
     1.278     4.166     0.200
     1.408    -0.083     0.200
     2.696    -7.165     0.200
     4.489   -26.217     0.200
     5.057   -26.715     0.200
     5.057   -25.715     0.200
     5.330   -30.778     0.200
     5.432   -31.795     0.200
     5.505   -32.618     0.200
     5.509   -33.017     0.200
     5.601   -33.049     0.200
     5.601   -34.428     0.200
     5.623   -33.684     0.200
     5.726   -34.212     0.200
     5.726   -33.516     0.200
     5.842   -35.811     0.200
     5.910   -35.659     0.200
     5.968   -35.606     0.200
     6.062   -35.970     0.200
     6.066   -36.398     0.200
     6.066   -35.827     0.200
     6.088   -35.974     0.200
     6.089   -33.601     0.200
     6.307   -38.428     0.200
     6.307   -38.588     0.200
     6.579   -40.364     0.200
     6.579   -41.001     0.200
     6.636   -41.218     0.200
     6.825   -41.751     0.200
     7.140   -43.949     0.200
     7.308   -44.687     0.200
     7.346   -46.668     0.200
     7.474   -49.273     0.200
     7.762   -50.176     0.200
     7.884   -52.129     0.200
     8.143   -49.541     0.200
     8.322   -53.110     0.200
     9.026   -57.928     0.200
     0.804     3.079     0.200
     1.206     0.099     0.200
     2.314    -9.078     0.200
     2.651    -8.765     0.200
     3.197   -12.509     0.200
     3.477   -15.881     0.200
     3.625   -20.081     0.200
     4.276   -24.498     0.200
     4.365   -25.609     0.200
     4.365   -27.437     0.200
     4.529   -27.035     0.200
     4.529   -27.996     0.200
     4.918   -30.222     0.200
     4.918   -29.995     0.200
     4.951   -30.462     0.200
     5.175   -34.075     0.200
     5.528   -34.978     0.200
     6.012   -40.029     0.200
     6.543   -43.823     0.200
     0.852     1.719     0.200
     2.454    -9.516     0.200
     2.566   -11.024     0.200
     2.566   -10.596     0.200
     4.198   -27.314     0.200
     4.415   -28.588     0.200
     4.496   -29.363     0.200
     4.837   -31.958     0.200
     4.915   -32.626     0.200
     1.108     3.300     0.200
     1.149     4.102     0.200
     2.262    -6.670     0.200
     2.493    -9.190     0.200
     2.435    -6.119     0.200
     4.321   -23.386     0.200
     4.414   -26.688     0.200
     4.485   -24.736     0.200
     4.535   -24.869     0.200
     4.535   -26.072     0.200
     4.714   -26.155     0.200
     4.959   -27.427     0.200
     4.904   -28.476     0.200
     5.036   -28.865     0.200
     5.036   -29.701     0.200
     5.114   -30.717     0.200
     5.303   -30.411     0.200
     0.549     4.593     0.200
     0.748     2.767     0.200
     1.606    -4.133     0.200
     1.982    -8.923     0.200
     1.985    -7.990     0.200
     3.071   -17.612     0.200
     2.953   -13.104     0.200
     3.590   -16.103     0.200
     3.843   -21.619     0.200
     4.378   -22.143     0.200
     4.682   -29.307     0.200
     4.789   -28.948     0.200
     4.804   -30.671     0.200
     5.175   -32.779     0.200
     5.224   -31.554     0.200
     5.396   -33.294     0.200
     5.689   -38.697     0.200
     5.760   -36.443     0.200
     1.373     4.449     0.200
     1.977    -1.013     0.200
     2.066    -3.661     0.200
     5.579   -31.590     0.200
     5.702   -32.294     0.200
     5.977   -34.399     0.200
     6.039   -34.674     0.200
     6.398   -37.165     0.200
     6.535   -38.214     0.200
     0.749     3.696     0.200
     2.214    -6.907     0.200
     2.908   -14.679     0.200
     2.908   -14.171     0.200
     3.112   -16.208     0.200
     3.552   -19.551     0.200
     3.900   -26.018     0.200
     3.969   -26.411     0.200
     4.018   -26.437     0.200
     4.065   -26.400     0.200
     4.195   -25.165     0.200
     4.285   -25.518     0.200
     4.311   -27.633     0.200
     4.311   -24.832     0.200
     4.483   -27.283     0.200
     4.535   -27.540     0.200
     4.524   -26.995     0.200
     4.497   -28.694     0.200
     4.497   -28.366     0.200
     4.582   -24.896     0.200
     4.889   -30.050     0.200
     5.085   -34.770     0.200
     5.085   -33.723     0.200
     5.880   -40.502     0.200
     2.679    -6.809     0.200
     3.066   -15.007     0.200
     3.371   -15.500     0.200
     4.642   -25.031     0.200
     4.644   -25.098     0.200
     4.680   -26.247     0.200
     4.790   -27.309     0.200
     4.804   -28.406     0.200
     4.804   -29.040     0.200
     4.808   -27.673     0.200
     4.808   -28.349     0.200
     5.145   -30.656     0.200
     5.173   -30.567     0.200
     5.226   -30.135     0.200
     5.397   -31.942     0.200
     5.397   -33.731     0.200
     5.438   -30.137     0.200
     5.687   -35.459     0.200
     5.761   -34.690     0.200
     5.865   -35.486     0.200
     5.986   -36.532     0.200
     6.407   -39.680     0.200
     6.421   -40.609     0.200
     3.905   -20.923     0.200
     3.981   -21.542     0.200
     4.293   -23.514     0.200
     4.475   -26.009     0.200
     4.558   -26.517     0.200
     4.893   -27.733     0.200
     5.332   -31.976     0.200
     6.204   -39.700     0.200
     6.467   -42.250     0.200
     6.499   -43.557     0.200
     6.697   -44.633     0.200
     6.928   -47.058     0.200
     7.012   -47.212     0.200
     7.645   -51.285     0.200
     8.191   -57.815     0.200
     0.829     3.193     0.200
     1.191     1.509     0.200
     1.214     0.081     0.200
     4.110   -23.406     0.200
     4.216   -25.459     0.200
     4.380   -25.971     0.200
     4.506   -27.461     0.200
     4.622   -27.918     0.200
     4.748   -28.825     0.200
     4.877   -31.217     0.200
     5.085   -32.410     0.200
     5.622   -35.640     0.200
     6.153   -39.648     0.200
     1.063     1.688     0.200
     1.149     1.328     0.200
     1.186     2.057     0.200
     2.611    -8.384     0.200
     3.330   -17.018     0.200
     4.128   -24.566     0.200
     4.232   -24.556     0.200
     4.314   -24.454     0.200
     4.403   -25.575     0.200
     4.524   -27.510     0.200
     4.644   -29.210     0.200
     4.766   -28.493     0.200
     4.821   -29.222     0.200
     4.887   -30.624     0.200
     4.887   -30.048     0.200
     5.104   -31.314     0.200
     5.380   -32.461     0.200
     5.461   -34.661     0.200
     5.941   -37.042     0.200
     2.348    -8.345     0.200
     2.391    -7.010     0.200
     3.064   -12.752     0.200
     3.586   -15.321     0.200
     5.170   -30.200     0.200
     5.253   -30.341     0.200
     5.561   -33.488     0.200
     5.592   -32.428     0.200
     5.832   -35.000     0.200
     6.394   -38.655     0.200
     1.728    -3.030     0.200
     2.897   -12.212     0.200
     3.454   -16.234     0.200
     3.561   -18.173     0.200
     4.036   -22.016     0.200
     4.036   -19.688     0.200
     4.174   -20.824     0.200
     4.281   -20.500     0.200
     4.402   -21.945     0.200
     4.832   -28.339     0.200
     4.892   -28.548     0.200
     4.929   -29.656     0.200
     4.929   -28.714     0.200
     4.928   -29.616     0.200
     4.928   -28.811     0.200
     5.068   -31.416     0.200
     5.068   -29.291     0.200
     5.139   -29.472     0.200
     5.169   -29.805     0.200
     5.194   -29.326     0.200
     5.213   -30.916     0.200
     5.213   -31.651     0.200
     5.401   -33.084     0.200
     5.401   -34.608     0.200
     5.423   -31.297     0.200
     5.464   -30.476     0.200
     5.502   -32.596     0.200
     5.820   -36.270     0.200
     5.903   -34.703     0.200
     5.950   -36.770     0.200
     5.950   -36.219     0.200
     6.009   -35.661     0.200
     6.009   -37.353     0.200
     6.195   -37.551     0.200
     6.195   -38.649     0.200
     6.566   -41.028     0.200
     6.555   -41.237     0.200
     6.678   -42.260     0.200
     7.091   -45.653     0.200
     8.167   -52.218     0.200
     2.375    -6.285     0.200
     5.507   -34.588     0.200
     5.572   -32.625     0.200
     5.796   -33.329     0.200
     5.858   -35.807     0.200
     5.890   -36.130     0.200
     6.085   -37.095     0.200
     6.496   -39.025     0.200
     7.249   -45.613     0.200
     1.068     4.200     0.200
     1.321     2.698     0.200
     2.451    -6.038     0.200
     3.813   -20.049     0.200
     3.839   -19.846     0.200
     3.843   -18.248     0.200
     3.914   -16.413     0.200
     4.024   -22.736     0.200
     4.025   -16.201     0.200
     4.181   -22.974     0.200
     4.311   -23.424     0.200
     4.390   -22.441     0.200
     4.749   -24.926     0.200
     5.104   -28.879     0.200
     5.479   -32.151     0.200
     0.749     3.284     0.200
     1.911    -5.727     0.200
     2.876   -13.696     0.200
     3.121   -15.059     0.200
     3.264   -17.276     0.200
     3.264   -16.381     0.200
     3.789   -20.721     0.200
     3.969   -22.791     0.200
     4.052   -24.713     0.200
     4.052   -23.521     0.200
     4.152   -21.951     0.200
     4.198   -25.814     0.200
     4.223   -26.540     0.200
     4.293   -25.550     0.200
     4.293   -26.378     0.200
     4.359   -25.555     0.200
     4.359   -25.980     0.200
     4.491   -29.038     0.200
     4.491   -27.909     0.200
     4.528   -26.803     0.200
     4.607   -27.208     0.200
     4.607   -28.969     0.200
     4.647   -29.266     0.200
     4.700   -30.182     0.200
     4.700   -29.529     0.200
     4.818   -25.320     0.200
     4.955   -31.153     0.200
     4.955   -32.200     0.200
     5.190   -34.110     0.200
     5.214   -33.349     0.200
     5.513   -35.938     0.200
     5.751   -35.788     0.200
     5.928   -37.078     0.200
     6.079   -41.918     0.200
     6.183   -35.870     0.200
     6.344   -40.882     0.200
     6.454   -43.445     0.200
     7.181   -50.234     0.200
     7.598   -51.330     0.200
     0.934     3.227     0.200
     1.075     2.890     0.200
     1.287     2.108     0.200
     2.220    -7.722     0.200
     2.579    -7.653     0.200
     2.579    -8.028     0.200
     2.814    -9.125     0.200
     3.797   -19.083     0.200
     4.036   -23.408     0.200
     4.059   -22.358     0.200
     4.059   -23.288     0.200
     4.064   -22.790     0.200
     4.363   -24.386     0.200
     4.363   -24.980     0.200
     4.400   -24.366     0.200
     4.535   -25.551     0.200
     4.541   -25.222     0.200
     4.650   -27.087     0.200
     4.864   -28.624     0.200
     4.864   -28.804     0.200
     5.015   -29.155     0.200
     5.080   -30.229     0.200
     5.597   -34.505     0.200
     5.614   -33.252     0.200
     1.604    -1.386     0.200
     1.803    -2.057     0.200
     1.958    -2.850     0.200
     2.341    -5.177     0.200
     2.737    -9.176     0.200
     2.889   -13.617     0.200
     3.025   -13.088     0.200
     2.987   -11.069     0.200
     2.987   -10.399     0.200
     2.967   -10.616     0.200
     3.104   -15.181     0.200
     3.230   -14.261     0.200
     3.344   -13.638     0.200
     3.923   -16.598     0.200
     4.084   -17.643     0.200
     4.480   -23.971     0.200
     4.771   -28.659     0.200
     4.771   -28.947     0.200
     4.792   -27.736     0.200
     4.793   -27.746     0.200
     4.793   -28.545     0.200
     5.093   -30.062     0.200
     5.093   -30.505     0.200
     5.133   -30.835     0.200
     5.256   -30.222     0.200
     5.254   -30.956     0.200
     5.344   -31.622     0.200
     5.383   -31.164     0.200
     5.383   -32.653     0.200
     5.458   -31.333     0.200
     5.588   -33.869     0.200
     5.588   -32.917     0.200
     5.748   -34.334     0.200
     5.748   -35.660     0.200
     5.908   -35.304     0.200
     6.319   -38.538     0.200
     6.348   -38.446     0.200
     1.130     3.866     0.200
     1.283     1.677     0.200
     1.728    -3.864     0.200
     1.903    -3.232     0.200
     2.705    -8.255     0.200
     3.595   -17.934     0.200
     4.085   -22.541     0.200
     4.818   -28.482     0.200
     4.882   -28.515     0.200
     4.923   -27.915     0.200
     5.091   -30.075     0.200
     5.172   -29.633     0.200
     5.172   -31.406     0.200
     5.200   -30.822     0.200
     5.404   -32.272     0.200
     5.451   -32.367     0.200
     5.451   -34.195     0.200
     5.806   -35.418     0.200
     5.956   -36.135     0.200
     6.003   -36.562     0.200
     6.195   -38.348     0.200
     2.078    -5.030     0.200
     2.672    -7.572     0.200
     3.699   -15.161     0.200
     3.910   -20.648     0.200
     3.942   -21.250     0.200
     4.043   -22.462     0.200
     4.243   -23.613     0.200
     4.336   -24.962     0.200
     4.579   -22.133     0.200
     4.792   -26.519     0.200
     4.859   -27.526     0.200
     4.871   -29.074     0.200
     2.436    -7.229     0.200
     2.494    -6.435     0.200
     2.769   -10.455     0.200
     3.115   -12.806     0.200
     3.132   -11.830     0.200
     4.029   -17.372     0.200
     4.272   -21.225     0.200
     4.444   -21.604     0.200
     4.444   -21.362     0.200
     4.503   -22.333     0.200
     4.503   -24.654     0.200
     4.618   -23.783     0.200
     4.633   -24.351     0.200
     4.803   -21.985     0.200
     4.883   -26.402     0.200
     4.883   -27.300     0.200
     5.449   -26.184     0.200
     5.495   -31.899     0.200
     5.495   -33.195     0.200
     5.548   -32.644     0.200
     5.549   -33.507     0.200
     5.549   -33.320     0.200
     5.579   -34.612     0.200
     5.624   -31.902     0.200
     5.624   -33.402     0.200
     5.673   -32.778     0.200
     5.673   -34.473     0.200
     5.813   -34.068     0.200
     5.813   -35.177     0.200
     5.866   -32.345     0.200
     5.866   -36.009     0.200
     5.873   -34.482     0.200
     5.873   -36.326     0.200
     5.873   -31.656     0.200
     6.028   -36.696     0.200
     6.094   -35.484     0.200
     6.125   -36.052     0.200
     6.125   -38.263     0.200
     6.154   -37.788     0.200
     6.359   -38.051     0.200
     6.483   -39.603     0.200
     6.483   -40.306     0.200
     6.569   -41.929     0.200
     6.569   -40.577     0.200
     6.624   -36.949     0.200
     6.829   -42.076     0.200
     6.829   -43.779     0.200
     7.052   -44.984     0.200
     7.194   -44.839     0.200
     7.213   -44.740     0.200
     7.299   -46.695     0.200
     7.510   -45.666     0.200
     7.510   -47.627     0.200
     7.710   -50.014     0.200
     7.807   -48.894     0.200
     8.193   -50.632     0.200
     9.599   -65.830     0.200
     9.599   -65.947     0.200
     9.773   -66.078     0.200
     0.453     3.623     0.200
     1.102    -1.852     0.200
     1.248    -1.891     0.200
     1.380    -3.180     0.200
     2.550   -10.864     0.200
     2.659   -12.694     0.200
     2.659   -14.067     0.200
     4.111   -26.892     0.200
     4.202   -27.986     0.200
     4.272   -28.914     0.200
     4.336   -28.324     0.200
     4.415   -28.516     0.200
     4.504   -29.943     0.200
     4.652   -30.654     0.200
     4.750   -32.234     0.200
     4.821   -32.983     0.200
     4.821   -33.163     0.200
     5.094   -34.058     0.200
     5.582   -37.635     0.200
     6.101   -42.562     0.200
     1.152     2.628     0.200
     2.856   -12.519     0.200
     3.297   -10.330     0.200
     3.672   -18.979     0.200
     3.736   -19.025     0.200
     3.736   -20.142     0.200
     3.781   -20.293     0.200
     3.781   -20.723     0.200
     3.821   -21.747     0.200
     3.984   -20.085     0.200
     4.035   -21.096     0.200
     4.054   -20.609     0.200
     4.071   -22.279     0.200
     4.071   -21.927     0.200
     4.118   -16.098     0.200
     4.282   -24.115     0.200
     4.282   -24.568     0.200
     4.265   -23.785     0.200
     4.265   -24.261     0.200
     4.305   -22.756     0.200
     4.660   -26.219     0.200
     4.842   -29.501     0.200
     4.842   -29.977     0.200
     4.861   -27.487     0.200
     4.861   -28.191     0.200
     5.064   -29.614     0.200
     5.562   -32.917     0.200
     5.978   -36.086     0.200
     1.142     4.251     0.200
     2.862    -7.608     0.200
     3.076   -14.396     0.200
     3.076   -13.818     0.200
     3.226   -14.749     0.200
     3.300   -13.757     0.200
     4.378   -22.949     0.200
     4.409   -22.968     0.200
     4.409   -22.460     0.200
     4.501   -24.613     0.200
     4.664   -25.664     0.200
     4.679   -27.332     0.200
     4.682   -27.737     0.200
     4.997   -28.436     0.200
     5.022   -29.213     0.200
     5.133   -30.028     0.200
     5.137   -29.570     0.200
     5.273   -31.555     0.200
     5.341   -31.227     0.200
     5.498   -33.219     0.200
     1.535    -0.154     0.200
     1.969    -3.313     0.200
     2.552    -6.358     0.200
     3.067    -8.725     0.200
     3.184    -9.834     0.200
     3.480   -10.866     0.200
     3.654   -14.217     0.200
     4.731   -20.801     0.200
     5.402   -30.520     0.200
     5.459   -32.632     0.200
     5.512   -29.888     0.200
     5.559   -30.122     0.200
     5.637   -32.564     0.200
     5.714   -33.229     0.200
     5.873   -34.074     0.200
     5.958   -34.458     0.200
     5.973   -34.627     0.200
     6.538   -37.928     0.200
     6.533   -40.330     0.200
     6.753   -40.542     0.200
     7.098   -42.999     0.200
     7.229   -46.167     0.200
     7.254   -45.138     0.200
     7.722   -49.837     0.200
     1.148     6.662     0.200
     1.391     2.950     0.200
     1.391     3.747     0.200
     1.429     2.525     0.200
     1.726    -0.779     0.200
     1.863    -1.450     0.200
     2.305    -3.722     0.200
     2.670    -6.636     0.200
     3.586   -13.261     0.200
     4.482   -23.991     0.200
     5.061   -27.367     0.200
     5.169   -28.373     0.200
     5.169   -29.435     0.200
     5.252   -29.635     0.200
     5.252   -30.920     0.200
     5.320   -28.456     0.200
     5.320   -30.823     0.200
     5.458   -29.734     0.200
     5.562   -29.745     0.200
     5.699   -31.674     0.200
     5.713   -33.728     0.200
     5.713   -34.704     0.200
     5.823   -34.116     0.200
     5.823   -34.628     0.200
     5.916   -35.331     0.200
     6.396   -37.965     0.200
     6.573   -39.096     0.200
     7.101   -42.708     0.200
     7.298   -45.634     0.200
     1.056     3.963     0.200
     1.084     4.657     0.200
     1.304     2.172     0.200
     1.770    -2.942     0.200
     2.438    -6.134     0.200
     2.433    -5.570     0.200
     3.212   -13.026     0.200
     3.273   -12.787     0.200
     3.439   -12.357     0.200
     3.559   -16.502     0.200
     3.780   -19.935     0.200
     3.780   -19.701     0.200
     3.830   -19.930     0.200
     3.830   -20.052     0.200
     3.861   -20.415     0.200
     3.861   -21.482     0.200
     3.856   -19.231     0.200
     3.898   -16.067     0.200
     4.040   -22.538     0.200
     4.040   -21.030     0.200
     4.129   -20.103     0.200
     4.155   -21.638     0.200
     4.168   -20.951     0.200
     4.282   -18.365     0.200
     4.196   -23.150     0.200
     4.196   -23.272     0.200
     4.328   -24.907     0.200
     4.328   -25.016     0.200
     4.392   -23.527     0.200
     4.407   -22.922     0.200
     4.435   -23.812     0.200
     4.879   -29.253     0.200
     4.940   -28.605     0.200
     5.122   -28.263     0.200
     5.496   -30.737     0.200
     5.605   -32.103     0.200
     5.582   -33.646     0.200
     6.045   -35.334     0.200
     6.571   -39.709     0.200
     1.660    -1.028     0.200
     1.942    -4.489     0.200
     2.676    -9.792     0.200
     3.306   -11.751     0.200
     3.306   -10.485     0.200
     3.693   -18.561     0.200
     3.757   -18.895     0.200
     3.801   -19.514     0.200
     4.057   -19.492     0.200
     4.086   -21.893     0.200
     4.076   -21.185     0.200
     3.862   -12.683     0.200
     4.278   -21.927     0.200
     4.301   -22.628     0.200
     4.326   -22.331     0.200
     4.326   -23.541     0.200
     4.113   -17.143     0.200
     4.212   -15.503     0.200
     4.861   -27.779     0.200
     5.084   -27.747     0.200
     5.582   -32.832     0.200
     0.995     4.774     0.200
     1.282     2.917     0.200
     1.986    -3.821     0.200
     2.811    -8.368     0.200
     3.033    -9.444     0.200
     3.070   -10.770     0.200
     3.613   -12.045     0.200
     3.749   -15.218     0.200
     3.847   -14.439     0.200
     4.215   -22.296     0.200
     4.513   -25.681     0.200
     4.527   -25.075     0.200
     5.302   -32.643     0.200
     5.808   -36.237     0.200
     6.225   -39.727     0.200
     1.511    -5.212     0.200
     2.421    -8.121     0.200
     2.430   -12.277     0.200
     2.527   -11.019     0.200
     3.221   -18.127     0.200
     3.327   -16.760     0.200
     4.207   -27.692     0.200
     4.311   -28.150     0.200
     4.253   -25.890     0.200
     4.392   -29.708     0.200
     4.392   -29.857     0.200
     4.532   -30.939     0.200
     4.603   -30.749     0.200
     4.723   -31.236     0.200
     4.845   -34.452     0.200
     4.845   -32.702     0.200
     4.889   -32.729     0.200
     4.964   -34.023     0.200
     4.964   -34.968     0.200
     5.127   -34.854     0.200
     5.152   -34.113     0.200
     5.459   -37.581     0.200
     5.537   -39.139     0.200
     5.537   -37.647     0.200
     5.954   -42.097     0.200
     6.240   -43.637     0.200
     6.500   -45.582     0.200
     6.706   -48.021     0.200
     4.128   -25.616     0.200
     4.228   -27.697     0.200
     4.305   -27.277     0.200
     4.305   -28.995     0.200
     4.326   -28.112     0.200
     4.326   -28.315     0.200
     4.437   -29.587     0.200
     4.412   -29.136     0.200
     4.412   -28.285     0.200
     4.523   -29.095     0.200
     4.652   -28.652     0.200
     4.766   -31.715     0.200
     4.766   -30.977     0.200
     4.784   -32.131     0.200
     4.871   -32.162     0.200
     5.019   -32.152     0.200
     5.019   -32.894     0.200
     5.444   -36.967     0.200
     5.444   -36.533     0.200
     5.624   -37.039     0.200
     5.624   -37.617     0.200
     5.845   -39.288     0.200
     5.936   -39.001     0.200
     6.149   -41.490     0.200
     6.393   -44.319     0.200
     6.566   -43.389     0.200
     1.046     0.709     0.200
     2.482   -12.215     0.200
     2.585    -9.260     0.200
     2.770   -10.457     0.200
     3.264   -15.267     0.200
     3.223   -15.828     0.200
     3.602   -16.519     0.200
     4.150   -25.032     0.200
     4.253   -26.485     0.200
     4.253   -27.751     0.200
     4.209   -24.734     0.200
     4.336   -26.820     0.200
     4.336   -28.016     0.200
     4.334   -27.474     0.200
     4.426   -27.782     0.200
     4.545   -28.695     0.200
     4.545   -28.531     0.200
     4.667   -29.545     0.200
     4.788   -31.832     0.200
     4.788   -30.332     0.200
     4.833   -30.580     0.200
     4.884   -30.925     0.200
     4.905   -32.351     0.200
     4.905   -33.476     0.200
     5.074   -33.164     0.200
     5.401   -34.828     0.200
     5.479   -37.516     0.200
     5.962   -39.743     0.200
     6.182   -41.448     0.200
     6.599   -43.728     0.200
     1.651    -0.412     0.200
     1.828    -2.155     0.200
     2.018    -3.490     0.200
     2.492    -5.542     0.200
     2.492    -5.663     0.200
     2.762    -6.782     0.200
     2.683    -7.503     0.200
     4.925   -28.041     0.200
     5.046   -30.260     0.200
     5.080   -28.839     0.200
     5.195   -28.767     0.200
     5.266   -32.270     0.200
     5.266   -31.313     0.200
     5.311   -30.896     0.200
     5.391   -30.185     0.200
     5.496   -30.460     0.200
     5.545   -33.685     0.200
     5.561   -32.412     0.200
     6.102   -37.437     0.200
     6.330   -37.606     0.200
     6.686   -40.476     0.200
     6.825   -41.234     0.200
     7.240   -45.935     0.200
     1.988    -4.095     0.200
     2.380    -6.471     0.200
     2.511    -8.742     0.200
     2.401    -5.386     0.200
     2.486   -10.317     0.200
     2.486   -10.022     0.200
     2.576    -8.453     0.200
     2.755    -8.007     0.200
     3.216   -13.667     0.200
     3.295   -15.076     0.200
     3.274   -15.274     0.200
     3.362   -13.084     0.200
     4.160   -23.972     0.200
     4.199   -23.224     0.200
     4.199   -22.833     0.200
     4.341   -25.754     0.200
     4.341   -25.051     0.200
     4.350   -25.973     0.200
     4.439   -26.227     0.200
     4.479   -24.838     0.200
     4.555   -27.164     0.200
     4.555   -27.303     0.200
     4.679   -27.152     0.200
     4.798   -28.645     0.200
     4.833   -30.326     0.200
     4.833   -28.662     0.200
     4.892   -29.799     0.200
     4.911   -30.474     0.200
     5.071   -31.042     0.200
     5.071   -30.533     0.200
     5.096   -27.555     0.200
     5.225   -29.541     0.200
     5.410   -33.721     0.200
     5.485   -34.464     0.200
     5.485   -34.712     0.200
     5.898   -35.802     0.200
     5.971   -37.015     0.200
     6.188   -39.889     0.200
     6.444   -41.797     0.200
     6.605   -43.151     0.200
     6.974   -45.501     0.200
     7.165   -48.340     0.200
     7.543   -50.754     0.200
     7.882   -53.015     0.200
     8.156   -54.998     0.200
     8.253   -54.346     0.200
     0.294     5.730     0.200
     1.334    -3.228     0.200
     1.409    -2.353     0.200
     1.534    -6.620     0.200
     1.960    -5.700     0.200
     2.366    -9.519     0.200
     2.552   -10.174     0.200
     2.445   -11.625     0.200
     2.445   -13.242     0.200
     2.759   -14.340     0.200
     2.806   -11.128     0.200
     3.270   -16.970     0.200
     3.195   -17.867     0.200
     3.344   -18.146     0.200
     3.413   -15.109     0.200
     3.626   -22.901     0.200
     3.626   -20.370     0.200
     3.633   -17.078     0.200
     3.841   -23.512     0.200
     4.175   -27.569     0.200
     4.246   -27.386     0.200
     4.246   -26.746     0.200
     4.265   -26.763     0.200
     4.265   -23.412     0.200
     4.357   -28.665     0.200
     4.357   -28.009     0.200
     4.361   -29.063     0.200
     4.361   -28.493     0.200
     4.448   -29.977     0.200
     4.448   -29.047     0.200
     4.505   -30.917     0.200
     4.505   -30.605     0.200
     4.571   -30.218     0.200
     4.571   -30.413     0.200
     4.611   -29.092     0.200
     4.618   -28.839     0.200
     4.689   -29.907     0.200
     4.813   -33.146     0.200
     4.813   -32.341     0.200
     4.868   -32.963     0.200
     4.868   -33.319     0.200
     4.910   -32.764     0.200
     4.936   -34.427     0.200
     4.936   -34.091     0.200
     5.110   -35.596     0.200
     5.110   -34.963     0.200
     5.141   -31.742     0.200
     5.272   -32.925     0.200
     5.428   -36.858     0.200
     5.510   -37.454     0.200
     5.510   -38.133     0.200
     5.683   -38.529     0.200
     5.683   -38.755     0.200
     5.940   -40.986     0.200
     5.989   -40.285     0.200
     6.153   -41.869     0.200
     6.212   -43.767     0.200
     6.483   -44.770     0.200
     6.629   -47.171     0.200
     6.690   -47.335     0.200
     6.691   -47.577     0.200
     6.796   -47.329     0.200
     6.993   -48.001     0.200
     7.542   -53.226     0.200
     7.580   -54.722     0.200
     7.909   -55.452     0.200
     8.074   -56.450     0.200
     8.179   -58.716     0.200
     8.296   -58.597     0.200
     8.821   -62.894     0.200
     1.828    -4.907     0.200
     2.099    -4.932     0.200
     3.064   -14.299     0.200
     3.875   -14.337     0.200
     4.177   -24.895     0.200
     4.231   -23.668     0.200
     4.219   -24.847     0.200
     4.243   -25.666     0.200
     4.241   -25.625     0.200
     4.636   -29.099     0.200
     4.632   -26.739     0.200
     4.650   -26.801     0.200
     4.829   -28.104     0.200
     4.863   -29.435     0.200
     4.942   -28.593     0.200
     5.161   -32.557     0.200
     5.446   -34.387     0.200
     5.894   -36.745     0.200
     2.395    -7.909     0.200
     2.909    -9.000     0.200
     3.145   -14.567     0.200
     3.212   -12.430     0.200
     3.656   -19.711     0.200
     3.756   -14.358     0.200
     4.151   -22.900     0.200
     4.261   -24.192     0.200
     4.311   -23.746     0.200
     4.350   -24.376     0.200
     4.350   -25.798     0.200
     4.326   -25.431     0.200
     4.334   -22.929     0.200
     4.408   -25.169     0.200
     4.513   -27.356     0.200
     4.547   -26.337     0.200
     4.650   -27.139     0.200
     4.787   -27.458     0.200
     4.903   -29.971     0.200
     4.903   -32.112     0.200
     4.936   -30.277     0.200
     4.936   -28.980     0.200
     5.161   -31.659     0.200
     5.161   -32.252     0.200
     5.512   -34.004     0.200
     5.512   -36.269     0.200
     5.675   -35.085     0.200
     5.919   -42.381     0.200
     5.971   -37.050     0.200
     5.998   -39.106     0.200
     6.209   -39.878     0.200
     6.477   -41.417     0.200
     6.528   -43.627     0.200
     6.740   -46.158     0.200
     6.741   -45.651     0.200
     6.815   -45.860     0.200
     2.863   -10.176     0.200
     3.896   -22.955     0.200
     4.032   -23.171     0.200
     4.105   -23.530     0.200
     4.165   -22.584     0.200
     4.230   -21.909     0.200
     4.285   -23.058     0.200
     4.387   -25.963     0.200
     4.557   -26.055     0.200
     4.592   -28.178     0.200
     5.404   -34.190     0.200
     2.279    -4.427     0.200
     2.461    -6.438     0.200
     2.554    -5.458     0.200
     2.985   -11.261     0.200
     2.998    -9.312     0.200
     3.213   -15.769     0.200
     3.260   -11.899     0.200
     3.663   -12.799     0.200
     4.574   -23.233     0.200
     4.956   -29.690     0.200
     5.039   -29.744     0.200
     5.159   -29.916     0.200
     5.197   -29.900     0.200
     5.273   -32.747     0.200
     5.273   -31.427     0.200
     5.384   -32.993     0.200
     5.346   -31.513     0.200
     5.532   -32.049     0.200
     5.509   -32.953     0.200
     5.594   -33.840     0.200
     5.617   -34.250     0.200
     6.179   -38.204     0.200
     6.297   -38.505     0.200
     6.394   -39.642     0.200
     6.497   -35.188     0.200
     6.736   -41.584     0.200
     6.919   -45.128     0.200
     6.898   -44.112     0.200
     6.959   -43.564     0.200
     7.096   -45.701     0.200
     7.223   -46.406     0.200
     7.314   -47.794     0.200
     7.870   -51.141     0.200
     8.239   -54.972     0.200
     8.551   -55.995     0.200
     8.591   -57.852     0.200
     8.862   -58.975     0.200
     9.293   -63.368     0.200
     1.116     4.422     0.200
     1.905    -1.038     0.200
     2.281    -4.075     0.200
     2.457    -5.393     0.200
     2.569    -5.423     0.200
     2.854    -5.967     0.200
     2.989    -9.768     0.200
     3.258   -10.895     0.200
     3.301    -8.914     0.200
     3.368    -9.643     0.200
     3.680   -12.071     0.200
     4.170   -19.874     0.200
     4.435   -20.466     0.200
     4.456   -21.886     0.200
     4.563   -22.336     0.200
     4.936   -27.372     0.200
     5.018   -28.532     0.200
     5.077   -29.682     0.200
     5.141   -27.922     0.200
     5.175   -28.489     0.200
     5.251   -30.141     0.200
     5.251   -29.930     0.200
     5.326   -29.917     0.200
     5.369   -31.362     0.200
     5.405   -28.078     0.200
     5.488   -31.396     0.200
     5.488   -26.897     0.200
     5.518   -32.287     0.200
     5.573   -33.070     0.200
     5.573   -32.625     0.200
     5.598   -33.226     0.200
     5.642   -32.565     0.200
     6.156   -37.270     0.200
     6.161   -37.260     0.200
     6.285   -37.090     0.200
     6.375   -38.306     0.200
     6.716   -40.571     0.200
     6.880   -42.628     0.200
     6.906   -44.051     0.200
     6.938   -41.596     0.200
     7.083   -43.631     0.200
     7.083   -44.787     0.200
     7.084   -43.535     0.200
     7.203   -45.012     0.200
     7.289   -43.705     0.200
     7.295   -46.257     0.200
     7.365   -47.092     0.200
     7.852   -51.092     0.200
     8.012   -52.600     0.200
     8.263   -53.643     0.200
     8.379   -53.943     0.200
     8.533   -53.152     0.200
     8.581   -53.461     0.200
     8.843   -57.028     0.200
     9.276   -60.502     0.200
     9.368   -62.385     0.200
     1.184     0.911     0.200
     2.018    -6.054     0.200
     2.242    -8.754     0.200
     2.657    -9.410     0.200
     2.838   -10.098     0.200
     2.910   -11.531     0.200
     2.986   -12.811     0.200
     3.671   -21.476     0.200
     3.916   -24.264     0.200
     3.993   -23.030     0.200
     4.048   -25.112     0.200
     4.048   -25.422     0.200
     4.117   -25.722     0.200
     4.117   -23.701     0.200
     4.188   -24.923     0.200
     4.188   -25.290     0.200
     4.252   -27.078     0.200
     4.252   -24.197     0.200
     4.304   -25.716     0.200
     4.304   -25.222     0.200
     4.392   -26.664     0.200
     4.392   -25.963     0.200
     4.485   -25.517     0.200
     4.571   -28.240     0.200
     4.571   -28.829     0.200
     4.592   -28.717     0.200
     4.592   -27.236     0.200
     5.135   -32.863     0.200
     5.135   -31.941     0.200
     5.345   -35.716     0.200
     5.401   -35.691     0.200
     5.688   -36.874     0.200
     5.852   -39.271     0.200
     6.174   -40.760     0.200
     6.268   -41.384     0.200
     1.211     3.898     0.200
     2.271    -4.201     0.200
     2.456    -5.527     0.200
     2.539    -5.506     0.200
     3.255   -12.384     0.200
     3.655   -14.212     0.200
     4.972   -28.376     0.200
     5.054   -29.524     0.200
     5.095   -24.684     0.200
     5.113   -30.608     0.200
     5.175   -29.494     0.200
     5.212   -29.102     0.200
     5.289   -31.464     0.200
     5.289   -30.554     0.200
     5.362   -31.194     0.200
     5.399   -32.857     0.200
     5.525   -31.581     0.200
     5.546   -32.555     0.200
     5.610   -34.385     0.200
     5.610   -32.768     0.200
     5.633   -33.484     0.200
     6.195   -38.424     0.200
     6.310   -36.860     0.200
     6.410   -38.961     0.200
     6.752   -41.531     0.200
     6.914   -42.873     0.200
     7.397   -48.192     0.200
     0.578     3.231     0.200
     2.619   -10.050     0.200
     3.397   -20.922     0.200
     3.397   -20.485     0.200
     3.455   -21.126     0.200
     3.495   -21.593     0.200
     3.495   -22.374     0.200
     3.528   -23.512     0.200
     3.569   -18.994     0.200
     3.776   -24.052     0.200
     3.776   -23.529     0.200
     3.785   -24.769     0.200
     3.990   -25.565     0.200
     3.999   -23.888     0.200
     3.994   -26.300     0.200
     4.028   -24.149     0.200
     4.549   -31.116     0.200
     4.814   -32.548     0.200
     0.552     3.810     0.200
     0.979    -0.147     0.200
     2.139    -8.612     0.200
     2.652    -9.880     0.200
     3.390   -21.266     0.200
     3.390   -20.809     0.200
     3.446   -21.109     0.200
     3.483   -20.512     0.200
     3.508   -18.575     0.200
     3.564   -16.827     0.200
     3.535   -15.227     0.200
     3.755   -23.651     0.200
     3.755   -21.584     0.200
     3.972   -25.882     0.200
     3.959   -25.086     0.200
     3.959   -24.063     0.200
     4.020   -25.302     0.200
     4.196   -19.865     0.200
     4.380   -22.711     0.200
     4.529   -29.606     0.200
     4.529   -28.602     0.200
     4.777   -30.346     0.200
     5.121   -32.919     0.200
     5.339   -35.409     0.200
     1.178     2.887     0.200
     2.594    -6.026     0.200
     2.645    -6.372     0.200
     2.778    -8.407     0.200
     2.776    -7.131     0.200
     2.862    -9.536     0.200
     2.864    -8.825     0.200
     3.105   -12.165     0.200
     3.404   -16.192     0.200
     3.445   -15.961     0.200
     4.259   -20.091     0.200
     4.445   -21.675     0.200
     4.445   -24.946     0.200
     4.474   -23.902     0.200
     4.612   -21.433     0.200
     4.921   -27.331     0.200
     5.232   -29.363     0.200
     5.248   -29.247     0.200
     5.393   -28.651     0.200
     5.512   -32.100     0.200
     5.512   -34.557     0.200
     5.529   -32.452     0.200
     5.529   -31.477     0.200
     5.526   -31.606     0.200
     5.526   -32.897     0.200
     5.537   -31.234     0.200
     5.537   -31.658     0.200
     5.569   -34.144     0.200
     5.585   -33.198     0.200
     5.603   -32.896     0.200
     5.884   -35.844     0.200
     5.884   -34.283     0.200
     5.899   -35.903     0.200
     5.899   -34.626     0.200
     5.925   -35.816     0.200
     6.000   -35.068     0.200
     6.000   -35.597     0.200
     6.148   -37.226     0.200
     6.151   -35.775     0.200
     6.162   -35.762     0.200
     6.192   -35.025     0.200
     6.383   -32.647     0.200
     6.528   -41.808     0.200
     6.528   -41.412     0.200
     6.658   -41.999     0.200
     6.658   -41.251     0.200
     6.783   -40.115     0.200
     6.807   -42.873     0.200
     6.807   -42.408     0.200
     6.906   -42.406     0.200
     7.037   -42.318     0.200
     7.037   -43.635     0.200
     7.038   -41.305     0.200
     7.209   -45.359     0.200
     7.286   -42.830     0.200
     7.542   -46.909     0.200
     7.542   -46.507     0.200
     7.575   -48.906     0.200
     7.659   -49.012     0.200
     7.668   -50.928     0.200
     7.812   -50.081     0.200
     7.815   -49.104     0.200
     8.209   -53.325     0.200
     8.599   -56.206     0.200
     8.816   -58.019     0.200
     9.077   -60.683     0.200
     9.189   -62.673     0.200
     9.382   -63.070     0.200
     9.514   -61.686     0.200
     9.514   -65.545     0.200
     9.565   -65.377     0.200
     9.596   -66.034     0.200
     9.721   -66.849     0.200
    10.212   -69.428     0.200
    10.606   -74.384     0.200
    10.697   -71.133     0.200
    10.711   -71.556     0.200
    10.799   -75.469     0.200
    10.945   -69.787     0.200
    10.972   -75.072     0.200
     1.122     4.288     0.200
     2.547    -5.497     0.200
     2.784    -8.723     0.200
     3.106   -10.338     0.200
     3.419   -12.401     0.200
     4.248   -23.897     0.200
     4.432   -22.152     0.200
     5.516   -32.154     0.200
     5.500   -33.229     0.200
     5.556   -34.039     0.200
     5.525   -32.245     0.200
     5.872   -33.178     0.200
     5.886   -34.292     0.200
     5.912   -33.576     0.200
     5.987   -36.169     0.200
     6.135   -36.623     0.200
     6.138   -38.310     0.200
     6.138   -36.021     0.200
     6.149   -35.994     0.200
     6.180   -38.205     0.200
     6.515   -42.883     0.200
     6.645   -41.114     0.200
     6.770   -41.718     0.200
     6.795   -42.161     0.200
     7.196   -44.499     0.200
     7.563   -49.523     0.200
     7.646   -49.244     0.200
     7.655   -49.902     0.200
     8.803   -56.898     0.200
     1.114     5.706     0.200
     2.646    -6.787     0.200
     2.563    -6.801     0.200
     2.754    -8.729     0.200
     2.858    -9.030     0.200
     3.404   -10.084     0.200
     4.248   -18.654     0.200
     4.426   -21.577     0.200
     4.462   -21.047     0.200
     4.633   -20.864     0.200
     5.239   -25.743     0.200
     5.493   -32.918     0.200
     5.493   -31.516     0.200
     5.506   -32.536     0.200
     5.506   -31.887     0.200
     5.510   -32.272     0.200
     5.523   -31.221     0.200
     5.523   -29.467     0.200
     5.547   -33.849     0.200
     5.563   -35.184     0.200
     5.563   -30.883     0.200
     5.861   -35.526     0.200
     5.861   -32.886     0.200
     5.877   -35.747     0.200
     5.877   -33.387     0.200
     5.902   -33.220     0.200
     5.980   -37.580     0.200
     5.980   -35.455     0.200
     6.125   -35.595     0.200
     6.129   -38.683     0.200
     6.129   -35.445     0.200
     6.141   -36.242     0.200
     6.180   -34.426     0.200
     6.509   -40.511     0.200
     6.509   -39.253     0.200
     6.637   -42.059     0.200
     6.637   -41.462     0.200
     6.761   -40.039     0.200
     6.787   -42.724     0.200
     6.787   -41.868     0.200
     7.188   -44.315     0.200
     7.559   -46.245     0.200
     7.639   -48.398     0.200
     7.649   -50.060     0.200
     7.791   -48.811     0.200
     8.798   -58.472     0.200
     9.059   -60.836     0.200
     9.497   -61.468     0.200
     3.464   -13.777     0.200
     4.032   -17.672     0.200
     4.354   -22.302     0.200
     4.502   -24.412     0.200
     4.502   -24.018     0.200
     4.562   -21.960     0.200
     4.708   -22.681     0.200
     4.747   -22.987     0.200
     5.327   -26.192     0.200
     5.347   -25.420     0.200
     5.555   -33.082     0.200
     5.555   -31.875     0.200
     5.562   -33.275     0.200
     5.562   -32.603     0.200
     5.526   -28.415     0.200
     5.600   -35.336     0.200
     5.504   -25.683     0.200
     5.621   -33.657     0.200
     5.621   -34.860     0.200
     5.596   -33.213     0.200
     5.596   -31.217     0.200
     5.537   -27.176     0.200
     5.619   -30.627     0.200
     5.619   -31.963     0.200
     5.719   -35.091     0.200
     5.897   -33.543     0.200
     5.897   -34.426     0.200
     5.928   -35.549     0.200
     5.928   -36.568     0.200
     5.942   -37.747     0.200
     5.942   -36.407     0.200
     5.856   -31.969     0.200
     6.047   -36.633     0.200
     6.047   -37.215     0.200
     6.167   -37.794     0.200
     6.180   -38.930     0.200
     6.180   -39.852     0.200
     6.197   -37.658     0.200
     6.189   -33.454     0.200
     6.282   -34.998     0.200
     6.493   -34.933     0.200
     6.580   -40.854     0.200
     6.580   -41.401     0.200
     6.696   -42.248     0.200
     6.696   -42.080     0.200
     6.817   -43.054     0.200
     6.853   -43.646     0.200
     6.853   -43.771     0.200
     6.838   -36.426     0.200
     6.980   -39.044     0.200
     7.125   -43.308     0.200
     7.194   -39.422     0.200
     7.313   -41.874     0.200
     7.569   -47.074     0.200
     7.643   -51.505     0.200
     7.703   -50.587     0.200
     7.721   -50.532     0.200
     7.849   -51.054     0.200
     8.223   -53.385     0.200
     8.264   -54.500     0.200
     8.327   -48.613     0.200
     8.396   -49.050     0.200
     8.652   -55.986     0.200
     8.625   -59.712     0.200
     8.878   -58.156     0.200
     9.134   -62.495     0.200
     9.246   -63.438     0.200
     9.187   -55.285     0.200
     9.227   -55.692     0.200
     9.448   -63.199     0.200
     9.580   -62.457     0.200
     9.580   -66.883     0.200
     9.620   -64.890     0.200
     9.777   -67.009     0.200
    10.630   -69.586     0.200
    10.998   -75.327     0.200
     2.120    -3.514     0.200
     4.224   -19.487     0.200
     4.415   -23.031     0.200
     5.484   -32.549     0.200
     5.495   -32.057     0.200
     5.495   -30.917     0.200
     5.505   -32.232     0.200
     5.505   -30.719     0.200
     5.544   -33.304     0.200
     5.559   -31.849     0.200
     5.559   -31.218     0.200
     5.863   -32.508     0.200
     5.874   -35.550     0.200
     5.874   -33.698     0.200
     5.971   -35.741     0.200
     5.971   -35.163     0.200
     6.125   -35.343     0.200
     6.126   -36.378     0.200
     6.499   -39.241     0.200
     6.499   -39.391     0.200
     6.632   -40.145     0.200
     6.779   -42.604     0.200
     6.779   -41.407     0.200
     7.632   -47.820     0.200
     8.785   -56.267     0.200
     1.089     4.551     0.200
     1.089     4.690     0.200
     2.215    -5.400     0.200
     2.564    -5.622     0.200
     3.074    -9.331     0.200
     3.388   -11.008     0.200
     5.526   -33.249     0.200
     5.526   -31.028     0.200
     5.567   -33.925     0.200
     5.584   -33.298     0.200
     5.897   -34.221     0.200
     5.920   -34.125     0.200
     6.002   -36.559     0.200
     6.002   -35.868     0.200
     6.149   -36.390     0.200
     6.782   -40.380     0.200
     6.809   -41.032     0.200
     7.209   -43.893     0.200
     7.661   -48.155     0.200
     7.672   -47.983     0.200
     1.088     4.106     0.200
     2.571    -6.274     0.200
     2.752    -7.277     0.200
     4.273   -23.176     0.200
     5.264   -28.036     0.200
     5.510   -33.912     0.200
     5.510   -32.717     0.200
     5.520   -32.830     0.200
     5.520   -31.584     0.200
     5.531   -35.415     0.200
     5.546   -32.403     0.200
     5.546   -32.056     0.200
     5.561   -32.946     0.200
     5.578   -32.315     0.200
     5.578   -34.429     0.200
     5.871   -36.277     0.200
     5.891   -36.629     0.200
     5.891   -34.801     0.200
     5.913   -34.233     0.200
     5.997   -37.241     0.200
     5.997   -36.385     0.200
     6.137   -36.032     0.200
     6.143   -36.418     0.200
     6.156   -36.264     0.200
     6.527   -40.895     0.200
     6.653   -40.827     0.200
     6.653   -40.718     0.200
     6.776   -40.663     0.200
     6.804   -41.599     0.200
     7.260   -47.367     0.200
     7.656   -49.259     0.200
     7.667   -48.858     0.200
     7.806   -48.841     0.200
     8.209   -51.665     0.200
     8.818   -58.830     0.200
     1.035     2.438     0.200
     1.104     1.811     0.200
     1.168     0.913     0.200
     1.252     1.544     0.200
     1.831    -6.178     0.200
     1.831    -5.788     0.200
     2.252    -5.665     0.200
     2.170    -6.502     0.200
     2.748   -13.624     0.200
     2.748   -12.002     0.200
     2.724   -10.291     0.200
     3.149   -16.390     0.200
     2.993   -12.200     0.200
     3.264   -14.235     0.200
     3.309   -17.382     0.200
     3.309   -17.890     0.200
     3.212   -12.958     0.200
     3.573   -17.370     0.200
     3.649   -19.123     0.200
     3.651   -19.076     0.200
     3.779   -21.024     0.200
     3.779   -20.883     0.200
     4.266   -22.273     0.200
     4.280   -20.124     0.200
     4.670   -28.571     0.200
     4.702   -28.250     0.200
     4.743   -27.069     0.200
     4.743   -28.764     0.200
     4.882   -29.946     0.200
     4.882   -30.719     0.200
     5.066   -32.589     0.200
     5.066   -31.702     0.200
     5.089   -30.818     0.200
     5.091   -32.102     0.200
     5.091   -31.485     0.200
     5.381   -33.893     0.200
     5.381   -33.303     0.200
     5.430   -33.876     0.200
     5.430   -32.649     0.200
     5.554   -34.627     0.200
     5.551   -34.543     0.200
     5.551   -34.410     0.200
     5.639   -34.745     0.200
     5.756   -36.401     0.200
     5.871   -36.983     0.200
     6.011   -37.123     0.200
     6.196   -38.736     0.200
     6.196   -39.775     0.200
     6.264   -39.909     0.200
     6.601   -42.818     0.200
     6.639   -43.627     0.200
     6.791   -42.359     0.200
     6.996   -47.924     0.200
     7.052   -46.955     0.200
     7.066   -45.576     0.200
     7.259   -46.958     0.200
     7.518   -46.798     0.200
     7.572   -51.465     0.200
     7.920   -52.648     0.200
     8.066   -54.133     0.200
     8.480   -57.529     0.200
     9.166   -61.329     0.200
     1.118     4.038     0.200
     1.485     0.013     0.200
     2.241    -5.576     0.200
     3.818   -17.580     0.200
     3.818   -17.052     0.200
     3.822   -17.544     0.200
     3.822   -17.938     0.200
     3.901   -20.840     0.200
     3.901   -18.787     0.200
     4.100   -22.048     0.200
     4.106   -23.262     0.200
     4.106   -21.457     0.200
     4.398   -24.272     0.200
     4.398   -23.260     0.200
     4.442   -24.099     0.200
     4.442   -23.927     0.200
     4.648   -25.158     0.200
     4.691   -25.545     0.200
     4.897   -28.392     0.200
     4.897   -27.470     0.200
     5.273   -29.481     0.200
     5.630   -32.744     0.200
     5.651   -32.066     0.200
     6.028   -36.092     0.200
     6.069   -35.825     0.200
     1.203     2.669     0.200
     2.078    -4.752     0.200
     2.148    -5.062     0.200
     2.954    -9.386     0.200
     3.530   -17.795     0.200
     3.636   -19.852     0.200
     3.636   -19.395     0.200
     3.400   -13.390     0.200
     4.309   -24.490     0.200
     1.111     3.128     0.200
     1.946    -3.763     0.200
     2.026    -5.064     0.200
     4.234   -17.596     0.200
     1.069     6.049     0.200
     1.019     7.293     0.200
     1.427     3.200     0.200
     2.254    -4.554     0.200
     2.935   -10.590     0.200
     2.955   -10.676     0.200
     3.449   -15.370     0.200
     3.549   -17.082     0.200
     3.781   -17.670     0.200
     3.844   -18.186     0.200
     4.087   -19.680     0.200
     4.206   -21.913     0.200
     4.206   -20.921     0.200
     4.186   -21.491     0.200
     4.186   -21.693     0.200
     4.469   -21.595     0.200
     4.469   -23.693     0.200
     4.697   -25.677     0.200
     4.765   -25.679     0.200
     4.782   -25.050     0.200
     4.782   -26.999     0.200
     5.325   -30.441     0.200
     5.481   -29.736     0.200
     5.714   -34.483     0.200
     1.475     2.928     0.200
     1.846    -0.236     0.200
     2.255    -3.361     0.200
     2.329    -2.788     0.200
     2.998   -11.955     0.200
     5.002   -27.391     0.200
     5.085   -27.503     0.200
     5.663   -32.557     0.200
     1.147     4.522     0.200
     1.147     4.093     0.200
     1.279     2.641     0.200
     1.568    -1.017     0.200
     1.667    -1.212     0.200
     1.814    -2.980     0.200
     2.176    -4.184     0.200
     2.626    -8.731     0.200
     2.626    -7.793     0.200
     2.657    -7.663     0.200
     2.840    -9.697     0.200
     3.500   -12.490     0.200
     3.933   -19.616     0.200
     4.137   -21.669     0.200
     4.137   -21.348     0.200
     4.169   -21.755     0.200
     4.795   -27.963     0.200
     4.864   -27.669     0.200
     4.933   -28.677     0.200
     5.078   -28.592     0.200
     5.111   -31.329     0.200
     5.111   -30.524     0.200
     5.141   -30.159     0.200
     5.180   -31.530     0.200
     5.180   -30.077     0.200
     5.166   -29.337     0.200
     5.234   -31.014     0.200
     5.373   -32.162     0.200
     5.401   -32.182     0.200
     5.401   -31.549     0.200
     5.430   -31.518     0.200
     5.479   -31.668     0.200
     5.955   -36.586     0.200
     5.989   -36.231     0.200
     5.984   -36.534     0.200
     6.088   -36.028     0.200
     6.188   -38.133     0.200
     6.188   -37.695     0.200
     6.548   -39.882     0.200
     6.622   -42.316     0.200
     6.668   -42.708     0.200
     6.680   -40.977     0.200
     7.026   -44.440     0.200
     7.095   -45.123     0.200
     7.124   -46.067     0.200
     1.117     4.189     0.200
     2.188    -5.061     0.200
     2.575    -7.896     0.200
     2.564    -7.345     0.200
     2.644    -6.263     0.200
     2.781    -7.257     0.200
     3.178    -9.646     0.200
     3.935   -15.730     0.200
     4.113   -20.185     0.200
     4.147   -18.920     0.200
     4.154   -15.640     0.200
     4.423   -22.445     0.200
     4.557   -20.814     0.200
     4.898   -26.030     0.200
     5.417   -25.097     0.200
     5.490   -32.284     0.200
     5.490   -32.612     0.200
     5.504   -33.000     0.200
     5.504   -32.664     0.200
     5.507   -32.097     0.200
     5.520   -30.585     0.200
     5.544   -33.546     0.200
     5.561   -32.902     0.200
     5.599   -32.020     0.200
     5.858   -35.298     0.200
     5.858   -35.399     0.200
     5.874   -35.651     0.200
     5.899   -36.122     0.200
     5.899   -35.505     0.200
     5.977   -35.625     0.200
     6.122   -37.226     0.200
     6.126   -38.212     0.200
     6.126   -36.939     0.200
     6.138   -37.945     0.200
     6.506   -39.673     0.200
     6.634   -41.144     0.200
     6.758   -41.434     0.200
     6.784   -42.610     0.200
     6.784   -41.313     0.200
     7.021   -42.074     0.200
     7.185   -44.660     0.200
     7.239   -46.429     0.200
     7.261   -44.463     0.200
     7.516   -46.163     0.200
     7.636   -48.929     0.200
     7.646   -50.030     0.200
     7.788   -50.477     0.200
     8.156   -52.410     0.200
     8.187   -53.546     0.200
     8.577   -57.101     0.200
     8.795   -58.256     0.200
     9.056   -60.567     0.200
     9.168   -60.483     0.200
     9.172   -61.473     0.200
     9.362   -63.264     0.200
     9.494   -65.368     0.200
     9.543   -64.022     0.200
     9.844   -66.443     0.200
    10.189   -68.884     0.200
    10.674   -71.568     0.200
    10.688   -72.335     0.200
    10.922   -71.421     0.200
    11.659   -74.601     0.200
    20.148  -132.155     0.200
     2.271    -5.852     0.200
     2.549   -10.728     0.200
     2.932   -11.062     0.200
     2.947   -11.204     0.200
     4.306   -20.086     0.200
     4.306   -20.367     0.200
     4.456   -24.230     0.200
     4.456   -21.699     0.200
     4.514   -22.583     0.200
     4.663   -25.961     0.200
     4.703   -24.440     0.200
     5.514   -33.590     0.200
     5.517   -32.903     0.200
     5.517   -30.935     0.200
     5.549   -33.748     0.200
     5.558   -33.363     0.200
     5.571   -32.625     0.200
     5.571   -30.688     0.200
     5.578   -35.092     0.200
     5.578   -33.491     0.200
     5.859   -35.400     0.200
     5.859   -33.408     0.200
     5.887   -35.456     0.200
     5.904   -33.567     0.200
     6.003   -37.210     0.200
     6.003   -36.562     0.200
     6.128   -36.053     0.200
     6.139   -39.318     0.200
     6.139   -36.662     0.200
     6.155   -36.664     0.200
     6.535   -42.611     0.200
     6.535   -39.408     0.200
     6.653   -42.462     0.200
     6.653   -40.837     0.200
     6.775   -41.784     0.200
     6.809   -43.874     0.200
     6.809   -41.983     0.200
     7.077   -46.666     0.200
     7.090   -43.709     0.200
     7.205   -45.315     0.200
     7.267   -44.964     0.200
     7.528   -48.410     0.200
     7.528   -46.551     0.200
     7.596   -48.776     0.200
     7.676   -48.509     0.200
     7.806   -50.211     0.200
     7.896   -47.132     0.200
     8.179   -52.151     0.200
     8.218   -52.461     0.200
     8.832   -58.527     0.200
     9.088   -60.491     0.200
     9.200   -61.838     0.200
     9.534   -61.259     0.200
     2.079    -4.810     0.200
     2.291    -6.861     0.200
     2.983    -9.377     0.200
     4.307   -22.595     0.200
     4.442   -21.951     0.200
     5.502   -31.402     0.200
     5.502   -33.363     0.200
     5.492   -31.533     0.200
     5.492   -30.452     0.200
     5.540   -33.319     0.200
     5.540   -33.856     0.200
     5.537   -31.441     0.200
     5.566   -32.247     0.200
     5.558   -32.492     0.200
     5.558   -34.255     0.200
     5.834   -32.152     0.200
     5.865   -35.126     0.200
     5.865   -33.858     0.200
     5.879   -32.793     0.200
     5.986   -35.984     0.200
     5.986   -35.766     0.200
     6.104   -34.788     0.200
     6.118   -35.881     0.200
     6.520   -40.249     0.200
     6.520   -41.538     0.200
     6.634   -40.903     0.200
     6.634   -40.251     0.200
     6.754   -40.235     0.200
     6.792   -42.940     0.200
     7.081   -45.995     0.200
     7.187   -44.429     0.200
     7.252   -44.701     0.200
     7.642   -47.994     0.200
     3.475   -20.079     0.200
     3.475   -18.837     0.200
     3.528   -19.222     0.200
     3.563   -20.262     0.200
     3.579   -20.363     0.200
     3.576   -16.816     0.200
     3.809   -23.045     0.200
     3.820   -20.548     0.200
     3.852   -22.756     0.200
     3.852   -21.263     0.200
     3.860   -22.754     0.200
     3.860   -21.629     0.200
     4.001   -22.645     0.200
     4.001   -22.833     0.200
     4.045   -23.926     0.200
     4.045   -23.629     0.200
     4.083   -22.991     0.200
     4.103   -24.982     0.200
     4.103   -22.686     0.200
     4.137   -23.335     0.200
     4.643   -27.432     0.200
     4.643   -27.205     0.200
     4.750   -28.378     0.200
     4.811   -28.768     0.200
     4.834   -29.546     0.200
     4.834   -29.382     0.200
     5.201   -31.657     0.200
     5.325   -32.626     0.200
     5.673   -35.857     0.200
     5.740   -37.255     0.200
     5.795   -37.528     0.200
     6.965   -45.111     0.200
     7.175   -47.067     0.200
     7.284   -47.824     0.200
     7.946   -52.358     0.200
     1.378     2.461     0.200
     2.278    -3.772     0.200
     3.500   -12.464     0.200
     5.271   -29.447     0.200
     5.352   -30.711     0.200
     5.588   -28.675     0.200
     5.661   -33.085     0.200
     5.909   -33.312     0.200
     5.924   -34.425     0.200
     7.049   -43.628     0.200
     0.930     3.633     0.200
     3.103   -14.333     0.200
     3.463   -18.028     0.200
     3.517   -18.322     0.200
     3.517   -17.172     0.200
     3.552   -18.304     0.200
     3.569   -19.002     0.200
     3.808   -20.204     0.200
     3.802   -21.039     0.200
     3.840   -20.971     0.200
     3.995   -21.873     0.200
     4.035   -22.745     0.200
     4.092   -22.345     0.200
     4.739   -26.669     0.200
     4.806   -27.788     0.200
     5.190   -30.019     0.200
     5.315   -31.474     0.200
     5.356   -32.537     0.200
     5.376   -33.486     0.200
     5.663   -34.829     0.200
     1.303     3.203     0.200
     2.112    -4.257     0.200
     2.849    -9.842     0.200
     2.809    -8.400     0.200
     3.232   -15.050     0.200
     3.399   -16.747     0.200
     3.478   -16.147     0.200
     3.586   -17.654     0.200
     3.615   -17.281     0.200
     3.734   -18.273     0.200
     4.428   -24.933     0.200
     4.428   -24.199     0.200
     4.443   -24.760     0.200
     4.470   -25.289     0.200
     4.490   -26.350     0.200
     4.490   -25.104     0.200
     4.505   -24.434     0.200
     4.534   -26.735     0.200
     4.534   -25.192     0.200
     4.617   -25.405     0.200
     4.617   -26.003     0.200
     4.790   -26.315     0.200
     4.790   -26.862     0.200
     4.799   -27.588     0.200
     4.799   -28.233     0.200
     4.827   -27.510     0.200
     4.925   -29.071     0.200
     4.925   -28.508     0.200
     5.048   -29.400     0.200
     5.051   -30.180     0.200
     5.345   -31.404     0.200
     5.566   -33.842     0.200
     5.566   -34.249     0.200
     5.686   -34.156     0.200
     5.727   -33.951     0.200
     5.727   -34.783     0.200
     6.003   -37.573     0.200
     6.087   -38.362     0.200
     6.118   -37.032     0.200
     6.194   -38.149     0.200
     6.568   -42.006     0.200
     6.576   -41.139     0.200
     6.605   -41.391     0.200
     2.228    -7.001     0.200
     2.632   -11.065     0.200
     2.652    -9.865     0.200
     3.157   -15.347     0.200
     3.482   -19.389     0.200
     3.539   -20.004     0.200
     3.577   -20.016     0.200
     3.577   -20.633     0.200
     3.603   -21.358     0.200
     3.603   -21.792     0.200
     3.818   -21.609     0.200
     3.846   -23.326     0.200
     3.861   -22.132     0.200
     3.860   -23.505     0.200
     3.860   -21.735     0.200
     4.044   -23.822     0.200
     4.067   -24.563     0.200
     4.067   -24.126     0.200
     4.085   -23.529     0.200
     4.112   -23.682     0.200
     4.150   -24.037     0.200
     4.180   -22.586     0.200
     4.762   -28.657     0.200
     4.853   -29.062     0.200
     4.857   -29.385     0.200
     5.216   -32.008     0.200
     5.347   -33.115     0.200
     5.424   -36.153     0.200
     5.691   -36.373     0.200
     6.317   -40.305     0.200
     6.992   -45.730     0.200
     2.166    -6.699     0.200
     2.592   -11.163     0.200
     2.857   -12.383     0.200
     3.526   -18.804     0.200
     3.572   -19.106     0.200
     3.593   -19.798     0.200
     3.593   -18.005     0.200
     3.600   -19.151     0.200
     3.600   -20.073     0.200
     3.788   -21.042     0.200
     3.891   -20.708     0.200
     3.891   -21.544     0.200
     3.899   -21.154     0.200
     3.959   -21.750     0.200
     3.959   -22.004     0.200
     4.053   -23.234     0.200
     4.064   -23.590     0.200
     4.064   -22.946     0.200
     4.145   -23.264     0.200
     4.151   -22.716     0.200
     4.175   -23.431     0.200
     4.679   -27.089     0.200
     4.758   -27.437     0.200
     4.792   -27.553     0.200
     5.234   -31.716     0.200
     5.341   -31.722     0.200
     5.344   -33.922     0.200
     5.540   -32.951     0.200
     5.701   -34.906     0.200
     5.787   -36.262     0.200
     6.162   -37.805     0.200
     0.966     3.715     0.200
     2.573    -9.076     0.200
     2.573    -8.963     0.200
     2.695   -10.415     0.200
     2.778    -9.773     0.200
     2.867   -10.951     0.200
     3.106   -13.355     0.200
     3.106   -14.400     0.200
     3.431   -17.559     0.200
     3.431   -17.172     0.200
     3.487   -17.657     0.200
     3.469   -15.772     0.200
     3.523   -17.633     0.200
     3.523   -18.036     0.200
     3.501   -15.397     0.200
     3.546   -18.773     0.200
     3.585   -16.172     0.200
     3.774   -19.185     0.200
     3.787   -20.728     0.200
     3.809   -19.888     0.200
     3.809   -20.336     0.200
     3.814   -20.206     0.200
     3.814   -19.456     0.200
     3.986   -21.642     0.200
     3.986   -21.751     0.200
     4.010   -22.130     0.200
     4.010   -21.693     0.200
     4.038   -21.050     0.200
     4.061   -22.328     0.200
     4.061   -21.738     0.200
     4.096   -21.952     0.200
     4.128   -19.470     0.200
     4.153   -17.413     0.200
     4.162   -16.958     0.200
     4.604   -25.617     0.200
     4.709   -26.508     0.200
     4.797   -28.194     0.200
     4.797   -26.212     0.200
     4.800   -28.096     0.200
     5.161   -29.714     0.200
     5.290   -32.733     0.200
     5.366   -33.855     0.200
     5.446   -31.459     0.200
     5.446   -30.381     0.200
     5.515   -30.727     0.200
     5.515   -30.624     0.200
     5.563   -35.214     0.200
     5.635   -34.268     0.200
     5.705   -35.706     0.200
     5.750   -34.699     0.200
     5.768   -35.913     0.200
     6.150   -36.941     0.200
     6.259   -38.693     0.200
     6.332   -39.963     0.200
     6.632   -43.014     0.200
     6.934   -43.519     0.200
     7.141   -46.179     0.200
     7.151   -45.232     0.200
     7.250   -46.163     0.200
     7.540   -48.729     0.200
     7.618   -50.442     0.200
     7.777   -52.042     0.200
     7.911   -51.433     0.200
     0.835     4.009     0.200
     0.823     5.144     0.200
     1.151     1.595     0.200
     1.151     2.079     0.200
     2.360    -7.133     0.200
     3.104   -11.354     0.200
     4.469   -23.468     0.200
     4.469   -24.265     0.200
     4.726   -26.577     0.200
     4.709   -24.840     0.200
     4.709   -25.777     0.200
     5.238   -32.353     0.200
     5.238   -31.295     0.200
     5.322   -31.846     0.200
     5.382   -33.087     0.200
     5.382   -31.908     0.200
     5.445   -33.102     0.200
     5.445   -32.223     0.200
     5.469   -33.728     0.200
     5.469   -33.524     0.200
     5.548   -33.194     0.200
     5.628   -35.233     0.200
     5.628   -34.166     0.200
     5.663   -36.033     0.200
     5.663   -35.932     0.200
     5.786   -35.405     0.200
     5.801   -36.009     0.200
     5.801   -37.751     0.200
     5.876   -36.215     0.200
     5.903   -37.963     0.200
     5.903   -36.799     0.200
     6.545   -40.689     0.200
     6.557   -40.281     0.200
     6.679   -43.134     0.200
     6.679   -42.028     0.200
     7.020   -43.378     0.200
     7.184   -45.836     0.200
     0.871     1.594     0.200
     1.700    -3.730     0.200
     2.498   -10.251     0.200
     3.489   -18.466     0.200
     3.535   -20.697     0.200
     3.556   -20.980     0.200
     3.562   -21.448     0.200
     3.562   -19.885     0.200
     3.755   -24.765     0.200
     3.755   -23.359     0.200
     3.930   -23.893     0.200
     3.930   -24.321     0.200
     4.027   -25.610     0.200
     4.027   -25.388     0.200
     4.641   -29.465     0.200
     1.148     2.401     0.200
     2.044    -5.212     0.200
     2.884   -11.623     0.200
     2.990   -12.740     0.200
     2.956   -10.701     0.200
     3.005   -11.308     0.200
     3.005   -12.507     0.200
     3.132   -15.731     0.200
     3.274   -17.316     0.200
     3.667   -19.181     0.200
     3.667   -20.334     0.200
     3.613   -14.952     0.200
     3.854   -22.689     0.200
     3.854   -21.614     0.200
     3.933   -23.234     0.200
     3.991   -23.671     0.200
     4.069   -23.111     0.200
     4.121   -23.505     0.200
     4.121   -23.267     0.200
     4.187   -25.810     0.200
     4.187   -23.053     0.200
     4.243   -25.637     0.200
     4.243   -24.617     0.200
     4.357   -26.135     0.200
     4.357   -25.412     0.200
     4.420   -25.961     0.200
     4.492   -25.964     0.200
     4.519   -28.122     0.200
     4.519   -26.169     0.200
     4.556   -25.996     0.200
     4.567   -27.387     0.200
     4.567   -27.938     0.200
     5.070   -31.275     0.200
     5.070   -30.513     0.200
     5.085   -31.653     0.200
     5.157   -30.792     0.200
     5.291   -31.762     0.200
     5.631   -34.489     0.200
     5.801   -36.307     0.200
     5.861   -38.177     0.200
     5.946   -39.802     0.200
     6.118   -39.029     0.200
     6.145   -41.587     0.200
     6.146   -41.969     0.200
     6.204   -38.559     0.200
     6.217   -39.954     0.200
     6.322   -40.550     0.200
     6.914   -45.937     0.200
     7.140   -47.519     0.200
     7.468   -49.644     0.200
     7.659   -49.470     0.200
     7.766   -50.574     0.200
     0.904     5.432     0.200
     1.535    -1.216     0.200
     1.720    -1.785     0.200
     4.864   -27.279     0.200
     4.879   -27.785     0.200
     5.234   -28.844     0.200
     5.931   -34.808     0.200
     6.478   -39.967     0.200
     1.410    -2.820     0.200
     1.598    -3.298     0.200
     1.988    -5.987     0.200
     2.175    -7.329     0.200
     2.255    -8.599     0.200
     2.272    -7.162     0.200
     2.272    -6.563     0.200
     2.654   -11.161     0.200
     2.777   -10.086     0.200
     2.880   -13.208     0.200
     2.862    -9.869     0.200
     3.089   -11.886     0.200
     3.145   -12.573     0.200
     3.481   -15.916     0.200
     3.716   -21.974     0.200
     3.716   -20.851     0.200
     3.551   -13.807     0.200
     3.790   -21.177     0.200
     3.790   -21.970     0.200
     3.775   -19.557     0.200
     3.775   -20.666     0.200
     3.809   -21.415     0.200
     3.810   -21.508     0.200
     3.810   -18.271     0.200
     3.863   -20.900     0.200
     3.790   -14.886     0.200
     3.889   -16.225     0.200
     3.889   -16.887     0.200
     3.940   -17.572     0.200
     4.146   -23.633     0.200
     4.146   -23.943     0.200
     4.204   -24.723     0.200
     4.204   -24.930     0.200
     4.217   -24.324     0.200
     4.217   -24.861     0.200
     4.217   -22.355     0.200
     4.230   -26.486     0.200
     4.230   -24.545     0.200
     4.387   -25.606     0.200
     4.398   -28.362     0.200
     4.398   -26.443     0.200
     4.215   -18.154     0.200
     4.439   -25.939     0.200
     4.646   -27.274     0.200
     4.606   -26.251     0.200
     4.732   -29.343     0.200
     4.732   -29.458     0.200
     4.700   -23.796     0.200
     4.876   -30.276     0.200
     4.876   -29.075     0.200
     4.763   -24.488     0.200
     5.011   -30.858     0.200
     5.013   -30.376     0.200
     5.013   -30.972     0.200
     5.250   -33.664     0.200
     5.415   -32.782     0.200
     5.415   -33.030     0.200
     5.416   -32.916     0.200
     5.465   -33.296     0.200
     5.789   -35.190     0.200
     5.789   -35.590     0.200
     5.812   -37.229     0.200
     5.873   -37.540     0.200
     6.031   -39.549     0.200
     6.386   -40.847     0.200
     6.415   -41.722     0.200
     6.803   -44.404     0.200
     7.034   -46.146     0.200
     7.285   -48.623     0.200
     7.399   -48.881     0.200
     7.397   -49.591     0.200
     7.612   -49.501     0.200
     7.745   -50.880     0.200
     7.771   -52.962     0.200
     8.072   -55.407     0.200
    19.757  -132.791     0.200
    21.528  -151.193     0.200
     1.960    -4.797     0.200
     2.231    -8.136     0.200
     2.231    -8.382     0.200
     2.640   -10.503     0.200
     2.894   -12.735     0.200
     2.852   -10.093     0.200
     3.790   -21.116     0.200
     3.790   -20.546     0.200
     3.807   -23.552     0.200
     3.807   -21.419     0.200
     3.805   -20.367     0.200
     3.805   -20.867     0.200
     3.756   -18.331     0.200
     3.756   -19.300     0.200
     3.838   -19.348     0.200
     3.838   -20.130     0.200
     4.144   -23.218     0.200
     4.144   -22.991     0.200
     4.222   -25.021     0.200
     4.233   -23.789     0.200
     4.194   -25.382     0.200
     4.194   -24.402     0.200
     4.383   -24.664     0.200
     4.396   -25.137     0.200
     4.441   -25.607     0.200
     4.644   -26.679     0.200
     4.721   -27.249     0.200
     4.870   -28.769     0.200
     5.007   -28.945     0.200
     5.004   -30.224     0.200
     5.004   -30.619     0.200
     5.415   -33.417     0.200
     5.454   -33.426     0.200
     5.858   -36.306     0.200
     0.928     2.121     0.200
     1.414    -3.174     0.200
     3.806   -21.336     0.200
     3.824   -22.350     0.200
     4.213   -24.625     0.200
     0.806     3.718     0.200
     1.419    -3.682     0.200
     1.958    -7.656     0.200
     2.139    -8.059     0.200
     2.255    -7.827     0.200
     2.255   -10.359     0.200
     2.664   -10.631     0.200
     2.664   -12.930     0.200
     2.767   -10.977     0.200
     2.767   -12.146     0.200
     3.074   -12.659     0.200
     3.463   -16.599     0.200
     3.729   -20.058     0.200
     3.780   -21.093     0.200
     3.780   -21.275     0.200
     3.811   -21.321     0.200
     3.827   -22.873     0.200
     3.827   -22.515     0.200
     3.829   -22.400     0.200
     3.862   -21.248     0.200
     3.862   -21.115     0.200
     4.218   -25.380     0.200
     4.218   -24.901     0.200
     4.417   -26.969     0.200
     4.461   -26.796     0.200
     4.602   -25.064     0.200
     4.666   -27.590     0.200
     4.744   -28.037     0.200
     4.893   -29.191     0.200
     5.027   -29.813     0.200
     5.249   -31.826     0.200
     5.438   -33.347     0.200
     5.477   -33.826     0.200
     6.426   -40.316     0.200
     2.589    -5.664     0.200
     2.778    -6.887     0.200
     2.900    -7.293     0.200
     3.071    -9.212     0.200
     3.162    -9.855     0.200
     3.982   -20.823     0.200
     4.401   -22.891     0.200
     5.389   -32.223     0.200
     5.443   -33.789     0.200
     5.444   -30.169     0.200
     5.473   -32.130     0.200
     5.526   -32.524     0.200
     5.581   -31.657     0.200
     5.707   -32.459     0.200
     5.760   -33.022     0.200
     5.767   -34.292     0.200
     5.924   -36.814     0.200
     5.988   -35.041     0.200
     6.019   -35.948     0.200
     6.264   -37.324     0.200
     6.273   -37.739     0.200
     6.465   -40.399     0.200
     6.664   -40.741     0.200
     6.724   -41.039     0.200
     6.961   -43.124     0.200
     7.107   -43.897     0.200
     7.196   -47.244     0.200
     7.571   -48.250     0.200
     0.893     1.919     0.200
     1.945    -6.422     0.200
     2.755   -11.860     0.200
     3.774   -21.620     0.200
     3.829   -21.801     0.200
     3.827   -24.723     0.200
     3.854   -21.559     0.200
     4.216   -23.784     0.200
     0.908     4.385     0.200
     1.099     3.932     0.200
     2.431    -8.405     0.200
     2.602    -7.752     0.200
     3.125   -15.011     0.200
     3.125   -15.136     0.200
     3.140   -11.274     0.200
     3.455   -18.326     0.200
     3.455   -17.944     0.200
     3.511   -18.053     0.200
     3.548   -18.764     0.200
     3.517   -14.594     0.200
     3.571   -20.984     0.200
     3.475   -13.740     0.200
     3.528   -14.250     0.200
     3.563   -14.518     0.200
     3.811   -21.526     0.200
     3.811   -21.909     0.200
     3.833   -20.179     0.200
     3.833   -20.827     0.200
     3.837   -20.782     0.200
     3.837   -20.376     0.200
     4.009   -22.237     0.200
     4.009   -21.276     0.200
     4.035   -22.843     0.200
     4.061   -21.661     0.200
     4.085   -23.682     0.200
     4.085   -21.979     0.200
     4.592   -26.642     0.200
     4.592   -28.799     0.200
     4.628   -26.385     0.200
     4.733   -27.572     0.200
     4.822   -28.618     0.200
     4.822   -27.986     0.200
     4.823   -29.293     0.200
     5.186   -30.571     0.200
     5.315   -31.440     0.200
     5.660   -34.775     0.200
     5.730   -36.320     0.200
     6.285   -38.648     0.200
     6.959   -44.430     0.200
     1.084     3.477     0.200
     1.742    -2.282     0.200
     3.543   -18.321     0.200
     3.570   -18.605     0.200
     3.815   -21.448     0.200
     4.016   -22.200     0.200
     4.591   -26.546     0.200
     4.831   -28.103     0.200
     1.142     1.901     0.200
     1.238     2.549     0.200
     2.459    -7.170     0.200
     2.474    -7.103     0.200
     3.207   -13.550     0.200
     4.368   -26.587     0.200
     4.665   -28.544     0.200
     4.910   -30.075     0.200
     5.002   -30.856     0.200
     5.586   -34.297     0.200
     1.245     3.161     0.200
     1.245     3.180     0.200
     1.381    -0.684     0.200
     1.696    -1.454     0.200
     1.960    -2.559     0.200
     1.969    -3.454     0.200
     3.012    -9.015     0.200
     3.578   -14.126     0.200
     5.602   -33.597     0.200
     5.700   -33.904     0.200
     5.997   -35.160     0.200
     6.120   -37.436     0.200
     6.240   -37.508     0.200
     6.322   -39.985     0.200
     6.475   -41.253     0.200
     7.086   -42.080     0.200
     7.584   -48.662     0.200
     7.603   -48.809     0.200
     9.275   -60.520     0.200
     1.261     4.207     0.200
     1.753    -0.789     0.200
     1.953    -2.131     0.200
     2.109    -2.990     0.200
     2.602    -9.647     0.200
     2.585    -6.131     0.200
     3.012   -13.603     0.200
     3.119   -15.102     0.200
     3.092   -10.696     0.200
     3.139   -11.717     0.200
     3.195   -13.344     0.200
     3.298   -13.750     0.200
     3.449   -13.607     0.200
     3.634   -17.675     0.200
     4.045   -16.291     0.200
     4.163   -19.236     0.200
     4.542   -22.114     0.200
     4.542   -23.059     0.200
     4.605   -23.871     0.200
     4.605   -23.973     0.200
     4.635   -24.630     0.200
     4.736   -25.873     0.200
     4.736   -25.662     0.200
     4.918   -26.991     0.200
     4.918   -28.015     0.200
     4.941   -28.039     0.200
     4.943   -28.289     0.200
     5.234   -29.753     0.200
     5.234   -28.721     0.200
     5.282   -29.492     0.200
     5.282   -29.297     0.200
     5.274   -28.473     0.200
     5.405   -30.773     0.200
     5.407   -30.032     0.200
     5.532   -32.158     0.200
     5.609   -32.221     0.200
     5.726   -33.551     0.200
     5.726   -33.793     0.200
     5.888   -33.344     0.200
     5.961   -35.288     0.200
     5.961   -35.022     0.200
     6.050   -36.736     0.200
     6.050   -34.932     0.200
     6.116   -35.478     0.200
     6.457   -38.333     0.200
     6.492   -38.625     0.200
     6.655   -41.389     0.200
     6.906   -41.247     0.200
     1.249     2.116     0.200
     1.853    -2.225     0.200
     1.973    -5.200     0.200
     3.188   -10.429     0.200
     3.338   -13.135     0.200
     4.598   -26.267     0.200
     4.633   -25.132     0.200
     4.633   -24.834     0.200
     4.647   -25.314     0.200
     5.006   -27.925     0.200
     5.065   -29.722     0.200
     5.394   -28.934     0.200
     5.597   -32.305     0.200
     5.871   -35.143     0.200
     6.181   -37.094     0.200
     1.057     2.122     0.200
     1.761    -4.554     0.200
     1.761    -4.202     0.200
     2.430    -8.194     0.200
     2.641   -12.928     0.200
     2.595    -8.962     0.200
     2.708    -9.665     0.200
     3.469   -15.572     0.200
     3.548   -19.888     0.200
     3.599   -20.230     0.200
     3.630   -20.542     0.200
     3.630   -20.722     0.200
     3.634   -18.637     0.200
     3.842   -21.474     0.200
     3.842   -22.532     0.200
     3.891   -21.749     0.200
     3.924   -22.487     0.200
     3.939   -21.858     0.200
     4.019   -22.849     0.200
     4.019   -23.314     0.200
     4.103   -24.911     0.200
     4.103   -24.478     0.200
     4.176   -26.061     0.200
     4.176   -24.101     0.200
     4.204   -24.111     0.200
     4.422   -25.542     0.200
     4.656   -28.545     0.200
     4.656   -28.111     0.200
     4.821   -29.799     0.200
     4.894   -29.476     0.200
     5.266   -32.398     0.200
     5.381   -33.048     0.200
     5.398   -34.463     0.200
     5.403   -35.148     0.200
     5.736   -36.007     0.200
     5.836   -37.207     0.200
     5.858   -36.829     0.200
     1.332     2.765     0.200
     2.615   -11.221     0.200
     2.615   -10.463     0.200
     2.720    -8.894     0.200
     2.750   -11.390     0.200
     2.750   -10.257     0.200
     3.091   -11.858     0.200
     3.093   -11.057     0.200
     3.347   -11.692     0.200
     3.713   -15.281     0.200
     3.694   -11.235     0.200
     4.207   -20.556     0.200
     4.682   -25.655     0.200
     5.006   -27.429     0.200
     5.362   -29.622     0.200
     5.370   -31.303     0.200
     1.281     2.842     0.200
     5.683   -36.021     0.200
     5.710   -34.794     0.200
     5.985   -36.894     0.200
     6.408   -39.771     0.200
     6.443   -40.116     0.200
     7.329   -51.055     0.200
     7.419   -47.593     0.200
     1.072     7.164     0.200
     1.156     5.602     0.200
     4.704   -24.009     0.200
     4.773   -24.671     0.200
     5.089   -27.571     0.200
     5.314   -28.611     0.200
     5.582   -31.156     0.200
     6.101   -34.391     0.200
     6.937   -41.869     0.200
     1.506     0.166     0.200
     1.597    -0.365     0.200
     1.923    -1.018     0.200
     1.923    -1.447     0.200
     2.113    -2.436     0.200
     2.298    -4.846     0.200
     2.907    -9.162     0.200
     3.278    -9.498     0.200
     3.333   -13.315     0.200
     3.755   -14.739     0.200
     3.879   -11.308     0.200
     4.035   -16.945     0.200
     4.228   -21.005     0.200
     4.228   -20.368     0.200
     4.441   -22.644     0.200
     4.486   -23.547     0.200
     4.797   -24.374     0.200
     4.797   -23.816     0.200
     4.891   -26.451     0.200
     4.891   -24.752     0.200
     5.115   -29.083     0.200
     5.115   -28.087     0.200
     5.211   -28.973     0.200
     5.283   -29.530     0.200
     5.283   -30.253     0.200
     5.312   -29.971     0.200
     5.312   -29.800     0.200
     5.370   -29.155     0.200
     5.383   -30.161     0.200
     5.401   -30.847     0.200
     5.510   -31.175     0.200
     5.641   -32.125     0.200
     5.656   -31.604     0.200
     5.656   -32.651     0.200
     5.754   -35.612     0.200
     5.754   -32.951     0.200
     5.830   -34.745     0.200
     5.830   -33.815     0.200
     5.839   -33.831     0.200
     5.828   -33.624     0.200
     5.828   -32.401     0.200
     5.829   -31.450     0.200
     5.990   -34.767     0.200
     6.356   -37.772     0.200
     6.398   -39.088     0.200
     6.398   -37.752     0.200
     6.430   -37.523     0.200
     6.594   -41.122     0.200
     6.594   -38.829     0.200
     6.917   -41.225     0.200
     7.103   -41.483     0.200
     7.110   -43.022     0.200
     7.210   -46.058     0.200
     7.214   -45.445     0.200
     7.398   -46.017     0.200
     7.398   -47.002     0.200
     7.479   -45.004     0.200
     7.527   -47.221     0.200
     7.634   -48.610     0.200
     8.085   -51.200     0.200
     8.145   -50.990     0.200
     8.447   -53.947     0.200
     8.653   -55.351     0.200
     8.916   -57.415     0.200
     8.970   -57.001     0.200
     8.984   -56.674     0.200
     9.077   -58.167     0.200
     9.399   -60.978     0.200
     9.534   -64.908     0.200
     9.534   -61.447     0.200
     9.599   -63.122     0.200
    10.877   -75.211     0.200
     1.125     5.639     0.200
     1.323     4.153     0.200
     2.323    -3.526     0.200
     2.455    -5.812     0.200
     2.644    -7.042     0.200
     2.660    -5.740     0.200
     3.443   -13.265     0.200
     3.522   -13.613     0.200
     4.930   -27.572     0.200
     5.004   -28.095     0.200
     5.263   -29.559     0.200
     5.317   -29.987     0.200
     5.557   -32.360     0.200
     6.134   -37.166     0.200
     3.393   -17.717     0.200
     4.284   -24.943     0.200
     4.353   -26.125     0.200
     4.420   -25.494     0.200
     4.762   -29.405     0.200
     4.762   -28.851     0.200
     4.899   -29.852     0.200
     4.899   -29.038     0.200
     4.972   -30.452     0.200
     5.468   -34.956     0.200
     5.468   -34.475     0.200
     6.311   -41.274     0.200
     6.352   -41.915     0.200
     1.921    -2.375     0.200
     2.585    -6.295     0.200
     5.858   -32.314     0.200
     5.948   -33.980     0.200
     5.982   -35.371     0.200
     6.048   -34.192     0.200
     6.067   -34.214     0.200
     6.255   -36.449     0.200
     6.615   -40.630     0.200
     6.681   -40.320     0.200
     6.713   -41.014     0.200
     7.132   -43.079     0.200
     7.177   -43.991     0.200
     7.597   -50.459     0.200
     8.203   -52.542     0.200
     1.790    -2.234     0.200
     2.118    -4.415     0.200
     2.561    -8.122     0.200
     2.716    -7.722     0.200
     2.734    -8.348     0.200
     3.538   -15.217     0.200
     4.828   -28.885     0.200
     4.828   -28.549     0.200
     4.899   -29.233     0.200
     4.947   -29.168     0.200
     5.103   -29.731     0.200
     5.164   -31.404     0.200
     5.164   -30.675     0.200
     5.169   -30.648     0.200
     5.214   -31.253     0.200
     5.292   -30.316     0.200
     5.292   -29.805     0.200
     5.402   -31.858     0.200
     5.444   -32.524     0.200
     5.444   -32.359     0.200
     5.463   -33.087     0.200
     5.516   -33.883     0.200
     5.706   -35.399     0.200
     6.000   -36.012     0.200
     6.000   -37.423     0.200
     6.044   -35.672     0.200
     6.123   -37.502     0.200
     6.229   -38.367     0.200
     6.586   -41.138     0.200
     6.722   -42.298     0.200
     6.724   -41.705     0.200
     7.066   -45.883     0.200
     1.982    -2.532     0.200
     2.919   -10.103     0.200
     3.890   -19.936     0.200
     3.972   -20.589     0.200
     4.280   -22.287     0.200
     4.567   -25.252     0.200
     1.310     1.525     0.200
     1.594    -1.419     0.200
     1.954    -3.738     0.200
     2.220    -6.169     0.200
     2.220    -6.867     0.200
     2.734    -8.054     0.200
     2.734   -10.712     0.200
     2.841   -11.663     0.200
     2.906    -9.379     0.200
     3.746   -17.598     0.200
     3.746   -17.950     0.200
     3.802   -20.696     0.200
     3.800   -19.693     0.200
     3.800   -18.298     0.200
     3.827   -18.821     0.200
     3.827   -18.458     0.200
     4.187   -22.940     0.200
     4.187   -23.103     0.200
     4.567   -26.095     0.200
     4.713   -25.630     0.200
     4.864   -27.148     0.200
     1.863    -7.923     0.200
     1.864    -7.144     0.200
     2.194    -6.945     0.200
     2.232    -8.933     0.200
     2.553   -10.398     0.200
     2.519    -8.670     0.200
     2.873   -14.651     0.200
     3.252   -14.675     0.200
     3.540   -20.018     0.200
     3.882   -24.009     0.200
     3.882   -23.732     0.200
     3.922   -24.180     0.200
     3.942   -24.924     0.200
     3.942   -24.725     0.200
     4.036   -23.284     0.200
     4.036   -23.624     0.200
     4.159   -25.598     0.200
     4.159   -26.332     0.200
     4.257   -24.035     0.200
     4.288   -25.983     0.200
     4.383   -28.695     0.200
     4.383   -28.238     0.200
     4.504   -28.941     0.200
     4.508   -28.302     0.200
     4.518   -28.907     0.200
     4.923   -28.210     0.200
     4.925   -33.566     0.200
     5.018   -32.544     0.200
     5.138   -32.829     0.200
     5.183   -34.107     0.200
     5.183   -33.303     0.200
     5.547   -37.656     0.200
     5.571   -35.982     0.200
     5.592   -35.488     0.200
     5.655   -37.096     0.200
     6.031   -40.662     0.200
     6.057   -42.279     0.200
     6.067   -41.582     0.200
     7.259   -48.696     0.200
     0.901     3.345     0.200
     1.182     2.725     0.200
     1.165     2.050     0.200
     1.373    -1.570     0.200
     2.038    -5.044     0.200
     2.379    -8.239     0.200
     2.379    -9.552     0.200
     2.491    -7.910     0.200
     2.683   -10.343     0.200
     2.704   -10.996     0.200
     2.955   -12.164     0.200
     3.034   -12.701     0.200
     3.289   -12.380     0.200
     3.697   -14.598     0.200
     3.744   -21.609     0.200
     3.744   -20.219     0.200
     3.778   -21.001     0.200
     3.693   -20.005     0.200
     3.792   -23.121     0.200
     3.792   -19.269     0.200
     3.862   -21.692     0.200
     3.862   -20.005     0.200
     3.985   -21.460     0.200
     3.985   -21.702     0.200
     3.988   -16.857     0.200
     4.109   -22.982     0.200
     4.109   -22.427     0.200
     4.222   -25.486     0.200
     4.222   -23.283     0.200
     4.362   -24.585     0.200
     4.378   -24.249     0.200
     4.761   -28.284     0.200
     4.751   -29.050     0.200
     4.990   -28.053     0.200
     5.024   -30.824     0.200
     1.506     1.372     0.200
     1.934    -2.373     0.200
     3.155    -9.848     0.200
     5.303   -30.004     0.200
     5.386   -29.379     0.200
     5.853   -32.156     0.200
     5.961   -34.004     0.200
     6.740   -40.785     0.200
     1.113    -2.629     0.200
     1.740    -6.956     0.200
     2.587   -10.578     0.200
     2.685   -13.689     0.200
     2.695   -14.436     0.200
     3.425   -21.495     0.200
     3.336   -18.798     0.200
     3.507   -21.763     0.200
     4.080   -27.205     0.200
     4.170   -26.754     0.200
     4.472   -29.000     0.200
     4.472   -29.284     0.200
     4.623   -28.543     0.200
     4.657   -30.813     0.200
     4.657   -31.367     0.200
     4.786   -32.281     0.200
     4.786   -31.724     0.200
     4.875   -31.659     0.200
     5.356   -35.408     0.200
     5.356   -35.543     0.200
     5.391   -36.242     0.200
     5.549   -38.095     0.200
     5.549   -36.641     0.200
     5.691   -37.784     0.200
     6.066   -40.568     0.200
     6.253   -43.416     0.200
     6.368   -43.390     0.200
     6.611   -46.939     0.200
     1.216     2.864     0.200
     2.167    -4.909     0.200
     3.734   -18.959     0.200
     3.764   -20.314     0.200
     4.157   -23.425     0.200
     4.198   -22.821     0.200
     4.350   -23.717     0.200
     4.371   -21.619     0.200
     4.975   -26.728     0.200
     1.156     3.125     0.200
     2.676    -9.472     0.200
     2.676    -8.994     0.200
     2.850   -10.423     0.200
     2.850    -9.792     0.200
     3.348   -15.393     0.200
     3.348   -16.018     0.200
     3.377   -15.258     0.200
     3.322   -10.374     0.200
     3.668   -19.061     0.200
     3.668   -19.477     0.200
     3.732   -20.142     0.200
     3.722   -17.898     0.200
     3.722   -16.226     0.200
     3.776   -19.578     0.200
     3.776   -20.174     0.200
     3.816   -20.831     0.200
     3.816   -21.178     0.200
     3.981   -20.229     0.200
     3.981   -21.245     0.200
     3.988   -21.830     0.200
     4.032   -21.105     0.200
     4.050   -22.779     0.200
     4.050   -21.502     0.200
     4.064   -21.592     0.200
     4.064   -21.543     0.200
     4.064   -19.880     0.200
     4.260   -23.037     0.200
     4.259   -23.138     0.200
     4.259   -21.819     0.200
     4.276   -24.116     0.200
     4.276   -23.803     0.200
     4.301   -22.877     0.200
     4.347   -23.858     0.200
     4.374   -19.290     0.200
     4.836   -28.237     0.200
     4.836   -26.978     0.200
     4.857   -27.150     0.200
     4.956   -28.689     0.200
     5.059   -28.926     0.200
     5.067   -28.476     0.200
     5.416   -31.653     0.200
     5.557   -32.909     0.200
     5.640   -33.611     0.200
     5.894   -34.954     0.200
     5.973   -36.589     0.200
     6.045   -36.747     0.200
     1.023     3.909     0.200
     1.309     3.051     0.200
     1.393    -1.687     0.200
     1.712    -2.269     0.200
     1.937    -4.756     0.200
     2.133    -5.487     0.200
     2.657   -11.992     0.200
     2.814   -12.636     0.200
     2.920   -12.864     0.200
     3.072   -11.351     0.200
     3.180   -12.339     0.200
     3.267   -12.680     0.200
     3.615   -13.720     0.200
     3.782   -17.909     0.200
     4.170   -21.683     0.200
     4.251   -23.549     0.200
     4.241   -15.813     0.200
     4.423   -23.606     0.200
     4.638   -26.909     0.200
     4.674   -25.548     0.200
     4.689   -26.136     0.200
     4.762   -26.201     0.200
     4.922   -27.446     0.200
     4.907   -26.438     0.200
     5.016   -28.187     0.200
     5.264   -30.172     0.200
     5.401   -32.752     0.200
     5.511   -32.400     0.200
     5.737   -34.631     0.200
     6.592   -41.202     0.200
     0.961     5.108     0.200
     1.306     3.665     0.200
     1.744    -2.938     0.200
     2.162    -5.532     0.200
     2.648    -9.821     0.200
     2.679   -10.811     0.200
     2.789   -10.699     0.200
     2.825   -11.060     0.200
     2.825   -11.753     0.200
     2.925   -11.384     0.200
     2.925   -11.796     0.200
     3.087   -13.642     0.200
     3.208   -12.629     0.200
     3.208   -12.935     0.200
     3.282   -11.487     0.200
     3.619   -11.679     0.200
     3.789   -18.205     0.200
     4.187   -20.699     0.200
     4.272   -22.068     0.200
     4.278   -20.073     0.200
     4.243   -15.982     0.200
     4.450   -24.177     0.200
     4.668   -26.592     0.200
     4.704   -25.956     0.200
     4.720   -27.166     0.200
     4.774   -25.205     0.200
     4.949   -29.343     0.200
     4.949   -27.755     0.200
     4.907   -25.937     0.200
     5.046   -28.296     0.200
     5.236   -29.772     0.200
     5.294   -31.037     0.200
     5.398   -32.074     0.200
     5.426   -32.090     0.200
     5.426   -31.761     0.200
     5.542   -32.151     0.200
     5.694   -33.352     0.200
     5.763   -34.511     0.200
     5.763   -33.425     0.200
     5.859   -32.990     0.200
     6.155   -35.689     0.200
     6.218   -36.709     0.200
     6.619   -42.211     0.200
     1.221     2.501     0.200
     1.335     1.731     0.200
     2.083    -4.237     0.200
     2.717   -11.732     0.200
     2.717   -11.336     0.200
     2.819   -11.281     0.200
     2.819   -11.935     0.200
     2.893   -10.221     0.200
     2.893    -9.563     0.200
     3.098   -11.590     0.200
     3.334   -13.202     0.200
     4.204   -21.298     0.200
     4.308   -23.565     0.200
     4.436   -18.690     0.200
     4.746   -26.987     0.200
     4.634   -20.616     0.200
     4.787   -27.601     0.200
     4.808   -28.892     0.200
     4.808   -28.390     0.200
     5.013   -28.571     0.200
     5.013   -29.554     0.200
     5.130   -29.307     0.200
     5.130   -30.419     0.200
     5.376   -32.150     0.200
     5.483   -31.557     0.200
     5.483   -32.116     0.200
     5.623   -32.649     0.200
     5.826   -34.490     0.200
     5.934   -34.366     0.200
     6.285   -39.500     0.200
     6.680   -41.631     0.200
     0.752     2.710     0.200
     0.867     2.100     0.200
     1.014     1.999     0.200
     2.594   -13.373     0.200
     3.361   -17.401     0.200
     4.190   -26.354     0.200
     4.190   -25.421     0.200
     4.278   -26.467     0.200
     4.465   -27.726     0.200
     4.500   -26.905     0.200
     4.582   -28.295     0.200
     4.737   -30.342     0.200
     4.738   -30.084     0.200
     4.738   -29.380     0.200
     4.829   -31.328     0.200
     4.886   -31.807     0.200
     4.886   -31.331     0.200
     4.944   -31.216     0.200
     4.944   -30.038     0.200
     5.067   -30.341     0.200
     5.454   -34.633     0.200
     5.454   -35.304     0.200
     5.652   -37.343     0.200
     5.652   -35.706     0.200
     5.980   -45.179     0.200
     5.753   -36.264     0.200
     6.167   -40.021     0.200
     6.700   -43.059     0.200
     0.950     2.746     0.200
     1.776    -7.809     0.200
     2.625   -10.178     0.200
     2.737   -14.396     0.200
     2.990   -17.344     0.200
     3.259   -20.156     0.200
     3.553   -20.455     0.200
     4.153   -26.708     0.200
     4.622   -30.758     0.200
     4.762   -30.340     0.200
     4.836   -31.528     0.200
     5.330   -35.544     0.200
     5.651   -37.122     0.200
     1.196     2.482     0.200
     1.156     1.645     0.200
     1.461    -2.320     0.200
     2.232    -8.807     0.200
     2.198    -5.761     0.200
     2.364    -7.628     0.200
     2.699    -9.912     0.200
     2.940   -11.396     0.200
     3.018   -13.646     0.200
     3.274   -12.620     0.200
     3.768   -20.213     0.200
     3.847   -21.637     0.200
     3.970   -21.491     0.200
     3.973   -19.298     0.200
     4.100   -21.906     0.200
     4.154   -22.850     0.200
     4.209   -23.253     0.200
     4.352   -22.985     0.200
     4.749   -27.896     0.200
     4.736   -26.379     0.200
     4.979   -27.204     0.200
     5.358   -32.468     0.200
     0.720     3.875     0.200
     1.080     0.992     0.200
     5.417   -32.313     0.200
     5.885   -36.881     0.200
     5.972   -36.219     0.200
     5.991   -37.478     0.200
     6.212   -37.545     0.200
     6.770   -42.610     0.200
     0.722     3.258     0.200
     0.839     3.127     0.200
     1.775    -4.521     0.200
     1.987    -7.416     0.200
     1.987    -6.619     0.200
     2.522   -10.695     0.200
     2.664    -8.955     0.200
     2.756   -11.295     0.200
     2.756   -12.178     0.200
     2.729   -10.628     0.200
     2.734   -13.332     0.200
     2.921   -12.824     0.200
     2.921   -14.089     0.200
     3.038   -13.514     0.200
     3.041   -13.600     0.200
     3.041   -13.705     0.200
     3.235   -17.450     0.200
     3.429   -17.550     0.200
     3.429   -17.140     0.200
     3.459   -15.688     0.200
     3.459   -17.153     0.200
     3.517   -19.293     0.200
     3.713   -20.254     0.200
     3.713   -20.929     0.200
     3.781   -21.463     0.200
     3.829   -22.309     0.200
     3.794   -19.023     0.200
     3.795   -17.505     0.200
     3.803   -19.855     0.200
     3.803   -19.472     0.200
     3.879   -23.524     0.200
     3.879   -22.403     0.200
     4.014   -23.059     0.200
     4.069   -24.615     0.200
     4.069   -22.677     0.200
     4.097   -23.600     0.200
     4.139   -24.216     0.200
     4.139   -23.184     0.200
     4.229   -22.642     0.200
     4.298   -25.007     0.200
     4.337   -26.595     0.200
     4.337   -25.657     0.200
     4.347   -27.201     0.200
     4.347   -24.943     0.200
     4.337   -25.000     0.200
     4.337   -25.293     0.200
     4.398   -25.964     0.200
     4.456   -25.070     0.200
     4.591   -27.069     0.200
     4.899   -30.199     0.200
     4.899   -30.797     0.200
     5.005   -29.598     0.200
     5.117   -32.766     0.200
     5.117   -31.860     0.200
     5.148   -31.246     0.200
     5.387   -30.282     0.200
     5.469   -33.182     0.200
     5.618   -34.914     0.200
     5.692   -36.465     0.200
     5.725   -36.829     0.200
     5.725   -35.474     0.200
     5.718   -37.215     0.200
     5.829   -34.087     0.200
     5.829   -36.137     0.200
     5.914   -38.318     0.200
     5.916   -37.836     0.200
     5.950   -38.104     0.200
     6.034   -39.361     0.200
     6.050   -37.446     0.200
     6.115   -40.324     0.200
     6.463   -42.192     0.200
     6.590   -43.490     0.200
     6.681   -44.108     0.200
     6.959   -45.911     0.200
     7.493   -49.759     0.200
     7.581   -51.651     0.200
     7.883   -52.986     0.200
     7.948   -54.574     0.200
     8.019   -53.530     0.200
     8.019   -53.925     0.200
     8.107   -55.349     0.200
     8.239   -56.546     0.200
     8.815   -60.358     0.200
     9.023   -62.794     0.200
     9.358   -64.435     0.200
     9.463   -66.786     0.200
     9.860   -69.195     0.200
     1.362     5.366     0.200
     1.278     4.963     0.200
     1.411     4.775     0.200
     1.256     4.035     0.200
     1.983    -2.060     0.200
     2.105    -2.271     0.200
     5.374   -31.955     0.200
     5.656   -33.317     0.200
     6.050   -36.932     0.200
     6.579   -39.714     0.200
     1.133     1.467     0.200
     1.156     1.882     0.200
     1.594    -1.599     0.200
     2.783   -12.616     0.200
     2.783   -13.811     0.200
     3.025   -13.691     0.200
     3.025   -14.097     0.200
     4.014   -19.817     0.200
     4.334   -21.552     0.200
     4.334   -21.669     0.200
     4.373   -21.467     0.200
     4.373   -23.881     0.200
     4.476   -22.828     0.200
     4.648   -26.491     0.200
     4.668   -28.294     0.200
     4.668   -27.802     0.200
     4.974   -30.606     0.200
     4.974   -28.450     0.200
     5.009   -29.714     0.200
     5.129   -31.082     0.200
     5.129   -31.676     0.200
     5.131   -29.893     0.200
     5.471   -31.502     0.200
     5.471   -32.565     0.200
     5.693   -35.438     0.200
     1.816    -2.571     0.200
     2.450    -5.345     0.200
     2.871    -8.593     0.200
     3.883   -17.043     0.200
     4.634   -25.568     0.200
     4.634   -26.008     0.200
     4.694   -26.161     0.200
     4.730   -25.556     0.200
     4.730   -25.120     0.200
     4.731   -25.471     0.200
     4.731   -25.012     0.200
     4.881   -25.644     0.200
     4.881   -28.285     0.200
     4.946   -26.360     0.200
     5.000   -29.145     0.200
     5.000   -27.666     0.200
     5.015   -28.393     0.200
     5.015   -29.365     0.200
     4.991   -27.101     0.200
     4.991   -27.799     0.200
     5.203   -29.875     0.200
     5.203   -30.572     0.200
     5.228   -30.546     0.200
     5.266   -30.153     0.200
     5.810   -33.884     0.200
     5.997   -35.134     0.200
     5.997   -35.826     0.200
     6.368   -38.490     0.200
     6.379   -37.951     0.200
     6.437   -39.168     0.200
     6.839   -42.424     0.200
     6.894   -43.190     0.200
     2.114    -4.503     0.200
     2.150    -5.119     0.200
     2.767    -8.874     0.200
     2.948    -8.788     0.200
     3.501   -13.578     0.200
     3.816   -16.525     0.200
     3.909   -14.470     0.200
     4.640   -20.902     0.200
     2.363    -7.464     0.200
     2.193    -7.465     0.200
     2.938   -10.467     0.200
     3.016   -12.603     0.200
     3.271   -11.947     0.200
     3.305   -12.229     0.200
     3.443   -12.448     0.200
     3.769   -20.200     0.200
     3.748   -12.833     0.200
     3.847   -19.350     0.200
     3.968   -19.338     0.200
     3.970   -17.675     0.200
     4.210   -23.290     0.200
     4.749   -27.654     0.200
     0.998     3.069     0.200
     2.806    -9.390     0.200
     3.931   -20.944     0.200
     4.265   -24.731     0.200
     4.393   -26.099     0.200
     4.476   -26.866     0.200
     4.662   -29.328     0.200
     4.714   -28.961     0.200
     4.896   -29.710     0.200
     5.116   -30.847     0.200
     5.165   -31.081     0.200
     5.455   -35.249     0.200
     5.583   -34.543     0.200
     6.004   -42.562     0.200
     6.685   -44.712     0.200
     0.844     4.647     0.200
     0.973     4.539     0.200
     1.462     0.115     0.200
     1.978    -2.568     0.200
     2.182    -4.833     0.200
     5.141   -29.452     0.200
     5.234   -30.611     0.200
     5.535   -32.811     0.200
     5.842   -35.004     0.200
     6.454   -39.555     0.200
     6.927   -49.452     0.200
     7.123   -44.342     0.200
     2.832    -8.511     0.200
     5.967   -37.773     0.200
     6.033   -37.577     0.200
     6.098   -39.120     0.200
     6.142   -37.624     0.200
     6.158   -38.910     0.200
     6.364   -40.561     0.200
     6.404   -41.261     0.200
     6.595   -42.329     0.200
     6.730   -43.842     0.200
     6.815   -44.957     0.200
     6.814   -43.988     0.200
     7.246   -47.376     0.200
     7.284   -47.808     0.200
     7.692   -54.664     0.200
     7.535   -49.830     0.200
     7.802   -51.194     0.200
     8.080   -53.641     0.200
     8.318   -53.907     0.200
     1.147     4.080     0.200
     1.365     3.683     0.200
     1.367     3.247     0.200
     1.383     2.924     0.200
     1.961    -4.007     0.200
     2.077    -2.428     0.200
     2.248    -3.267     0.200
     2.734    -9.920     0.200
     2.734    -8.670     0.200
     2.734    -8.295     0.200
     2.833    -9.586     0.200
     2.844   -10.939     0.200
     2.844    -9.939     0.200
     2.681    -5.484     0.200
     2.922   -10.167     0.200
     2.922    -9.401     0.200
     3.120   -11.458     0.200
     3.141   -12.899     0.200
     3.141   -12.360     0.200
     3.181   -10.783     0.200
     3.183   -11.804     0.200
     3.311   -12.606     0.200
     3.311   -11.145     0.200
     3.416   -15.553     0.200
     3.416   -13.483     0.200
     3.348   -10.326     0.200
     3.795   -15.206     0.200
     3.653   -11.220     0.200
     4.129   -19.794     0.200
     4.114   -18.998     0.200
     4.225   -20.455     0.200
     4.225   -19.494     0.200
     4.247   -22.196     0.200
     4.326   -22.841     0.200
     4.326   -21.364     0.200
     4.524   -23.314     0.200
     4.524   -22.611     0.200
     4.405   -21.763     0.200
     4.405   -16.795     0.200
     4.604   -19.235     0.200
     4.753   -26.106     0.200
     4.793   -26.451     0.200
     4.812   -27.222     0.200
     4.812   -26.699     0.200
     4.888   -23.960     0.200
     5.024   -27.748     0.200
     5.135   -29.549     0.200
     5.135   -28.463     0.200
     5.299   -29.707     0.200
     5.313   -30.132     0.200
     5.313   -26.640     0.200
     5.382   -29.848     0.200
     5.491   -31.734     0.200
     5.496   -30.576     0.200
     5.496   -30.115     0.200
     5.555   -29.977     0.200
     5.629   -32.737     0.200
     5.612   -27.233     0.200
     5.806   -33.196     0.200
     5.838   -32.104     0.200
     5.942   -32.901     0.200
     6.295   -35.959     0.200
     2.133    -5.914     0.200
     2.342    -7.161     0.200
     2.774    -9.197     0.200
     3.504   -17.845     0.200
     3.504   -17.454     0.200
     3.672   -18.795     0.200
     3.798   -18.367     0.200
     3.798   -17.607     0.200
     3.945   -19.792     0.200
     3.945   -18.941     0.200
     4.014   -20.433     0.200
     4.014   -18.782     0.200
     4.017   -20.185     0.200
     4.017   -20.990     0.200
     4.152   -20.698     0.200
     5.079   -28.400     0.200
     5.079   -29.022     0.200
     5.079   -28.700     0.200
     5.163   -29.748     0.200
     5.163   -29.385     0.200
     5.192   -31.486     0.200
     5.526   -34.180     0.200
     5.526   -32.057     0.200
     5.553   -31.712     0.200
     5.553   -32.483     0.200
     5.587   -34.531     0.200
     5.587   -34.068     0.200
     5.581   -32.611     0.200
     5.731   -32.028     0.200
     5.778   -35.076     0.200
     5.798   -34.820     0.200
     5.940   -33.149     0.200
     6.026   -36.405     0.200
     6.107   -37.095     0.200
     6.107   -36.966     0.200
     6.264   -39.188     0.200
     6.264   -39.029     0.200
     6.398   -39.368     0.200
     6.398   -38.573     0.200
     6.397   -38.620     0.200
     6.576   -41.835     0.200
     6.810   -43.014     0.200
     6.841   -43.349     0.200
     7.170   -45.038     0.200
     7.170   -44.147     0.200
     7.245   -47.440     0.200
     7.252   -46.691     0.200
     7.772   -49.407     0.200
     7.783   -49.244     0.200
     8.175   -54.068     0.200
     8.378   -53.705     0.200
     8.647   -57.346     0.200
     8.759   -57.909     0.200
     9.136   -63.341     0.200
     9.439   -64.674     0.200
     1.170     4.127     0.200
     1.513    -0.673     0.200
     1.759    -2.941     0.200
     1.759    -2.699     0.200
     2.147    -4.118     0.200
     2.569    -7.455     0.200
     2.733    -9.428     0.200
     3.554   -12.653     0.200
     3.539   -15.003     0.200
     4.789   -28.685     0.200
     4.789   -28.225     0.200
     4.861   -28.915     0.200
     4.942   -29.280     0.200
     5.064   -29.390     0.200
     5.089   -30.200     0.200
     5.133   -29.652     0.200
     5.133   -31.316     0.200
     5.129   -30.223     0.200
     5.175   -31.296     0.200
     5.208   -25.271     0.200
     5.263   -30.351     0.200
     5.263   -31.061     0.200
     5.362   -32.627     0.200
     5.407   -31.537     0.200
     5.407   -32.864     0.200
     5.425   -32.827     0.200
     5.478   -33.624     0.200
     5.667   -35.287     0.200
     5.964   -36.838     0.200
     5.989   -37.020     0.200
     6.085   -38.424     0.200
     6.192   -38.884     0.200
     6.687   -43.807     0.200
     7.028   -45.077     0.200
     7.102   -46.007     0.200
     7.656   -48.795     0.200
     8.324   -53.202     0.200
     1.779    -3.182     0.200
     2.406    -5.595     0.200
     2.585    -6.536     0.200
     5.188   -28.556     0.200
     5.214   -29.542     0.200
     5.601   -32.255     0.200
     5.826   -33.391     0.200
     6.283   -37.197     0.200
     1.181     4.655     0.200
     1.400     1.910     0.200
     1.770    -0.892     0.200
     2.018    -1.756     0.200
     2.056    -2.862     0.200
     2.790    -8.179     0.200
     5.353   -31.718     0.200
     5.451   -31.305     0.200
     5.748   -33.128     0.200
     5.874   -34.299     0.200
     5.992   -34.318     0.200
     6.072   -35.662     0.200
     6.227   -36.418     0.200
     6.596   -38.839     0.200
     6.669   -39.682     0.200
     1.163     2.540     0.200
     2.114    -5.047     0.200
     2.401    -7.374     0.200
     2.401    -7.575     0.200
     2.722   -12.297     0.200
     2.722   -12.043     0.200
     2.978   -10.594     0.200
     3.405   -11.837     0.200
     3.757   -19.128     0.200
     3.675   -13.253     0.200
     3.708   -13.487     0.200
     3.790   -19.911     0.200
     3.805   -20.402     0.200
     3.716   -17.819     0.200
     3.882   -18.263     0.200
     3.882   -18.475     0.200
     4.006   -20.224     0.200
     4.006   -20.093     0.200
     4.011   -17.786     0.200
     4.118   -20.890     0.200
     4.121   -23.720     0.200
     4.121   -23.017     0.200
     4.145   -21.913     0.200
     4.145   -22.365     0.200
     4.237   -24.848     0.200
     4.237   -23.101     0.200
     4.374   -24.309     0.200
     4.387   -23.896     0.200
     4.621   -26.152     0.200
     4.778   -27.077     0.200
     4.774   -25.182     0.200
     4.880   -28.193     0.200
     5.003   -27.982     0.200
     5.040   -29.269     0.200
     5.040   -28.072     0.200
     5.432   -30.960     0.200
     5.394   -31.964     0.200
     5.439   -31.913     0.200
     5.888   -34.957     0.200
     0.773     4.069     0.200
     0.901     3.610     0.200
     1.788    -4.610     0.200
     2.822   -12.487     0.200
     4.384   -26.393     0.200
     4.453   -27.112     0.200
     4.499   -28.449     0.200
     4.738   -32.533     0.200
     4.769   -29.311     0.200
     4.888   -32.925     0.200
     4.997   -32.646     0.200
     5.554   -37.326     0.200
     5.781   -38.678     0.200
     6.139   -40.361     0.200
     6.277   -42.983     0.200
     6.275   -44.702     0.200
     6.296   -43.238     0.200
     1.158     3.034     0.200
     1.307    -0.554     0.200
     1.385    -0.463     0.200
     2.224    -4.836     0.200
     2.224    -5.105     0.200
     2.316    -5.371     0.200
     2.410    -6.732     0.200
     3.459   -14.078     0.200
     4.177   -22.314     0.200
     4.531   -22.497     0.200
     5.484   -32.999     0.200
     5.529   -32.536     0.200
     5.545   -33.440     0.200
     5.691   -34.245     0.200
     5.691   -33.879     0.200
     5.755   -34.953     0.200
     5.800   -36.548     0.200
     6.015   -37.696     0.200
     6.015   -37.351     0.200
     6.050   -37.266     0.200
     6.292   -39.468     0.200
     6.567   -41.999     0.200
     6.708   -40.974     0.200
     6.805   -42.866     0.200
     2.132    -2.006     0.200
     3.516   -11.113     0.200
     3.784   -12.278     0.200
     5.957   -34.547     0.200
     6.055   -35.150     0.200
     6.136   -36.908     0.200
     6.231   -36.213     0.200
     6.352   -37.705     0.200
     6.473   -38.322     0.200
     6.595   -39.156     0.200
     6.674   -41.543     0.200
     6.829   -40.745     0.200
     7.201   -44.148     0.200
     7.273   -44.280     0.200
     7.736   -53.972     0.200
     7.938   -48.303     0.200
     7.955   -48.559     0.200
     8.259   -51.600     0.200
     9.624   -61.740     0.200
     1.225     2.763     0.200
     2.231    -6.100     0.200
     6.060   -37.253     0.200
     6.142   -37.665     0.200
     6.290   -37.268     0.200
     6.336   -36.878     0.200
     6.371   -39.159     0.200
     6.450   -40.036     0.200
     6.609   -41.349     0.200
     6.698   -41.405     0.200
     6.708   -41.636     0.200
     6.764   -42.035     0.200
     6.937   -43.915     0.200
     7.056   -44.411     0.200
     7.277   -46.446     0.200
     7.365   -48.007     0.200
     7.490   -48.034     0.200
     7.838   -51.684     0.200
     7.988   -53.182     0.200
     8.061   -50.366     0.200
     8.322   -53.891     0.200
     8.404   -56.460     0.200
     2.688    -8.702     0.200
     2.729    -8.979     0.200
     3.525   -15.086     0.200
     1.012     4.500     0.200
     1.353     2.983     0.200
     1.453    -0.119     0.200
     1.352     2.015     0.200
     1.538    -1.355     0.200
     1.768    -1.159     0.200
     1.898    -4.171     0.200
     2.545    -7.262     0.200
     3.030    -9.517     0.200
     5.381   -32.094     0.200
     5.381   -31.193     0.200
     5.488   -31.886     0.200
     5.537   -31.740     0.200
     5.537   -29.630     0.200
     5.571   -33.902     0.200
     5.638   -33.796     0.200
     5.702   -34.012     0.200
     5.778   -34.071     0.200
     5.778   -34.399     0.200
     5.881   -34.175     0.200
     6.019   -35.759     0.200
     6.010   -37.500     0.200
     6.139   -38.077     0.200
     6.139   -36.653     0.200
     6.198   -36.236     0.200
     6.250   -37.714     0.200
     6.361   -39.685     0.200
     6.700   -40.839     0.200
     6.891   -41.606     0.200
     7.151   -50.174     0.200
     7.417   -47.520     0.200
     7.834   -50.703     0.200
     1.129     1.829     0.200
     1.492    -2.035     0.200
     1.656    -2.265     0.200
     2.248    -6.703     0.200
     5.585   -34.978     0.200
     5.701   -36.382     0.200
     5.983   -36.794     0.200
     6.377   -41.005     0.200
     6.448   -42.189     0.200
     6.556   -42.424     0.200
     7.342   -53.364     0.200
     1.082     1.951     0.200
     1.082     1.576     0.200
     1.191     3.201     0.200
     1.453    -1.465     0.200
     2.191    -7.637     0.200
     2.397    -6.730     0.200
     2.397    -8.995     0.200
     2.614    -8.833     0.200
     2.614   -10.817     0.200
     2.673   -10.233     0.200
     3.091   -13.584     0.200
     3.434   -14.611     0.200
     3.434   -15.611     0.200
     3.533   -19.001     0.200
     3.533   -18.329     0.200
     3.582   -18.909     0.200
     3.611   -19.133     0.200
     3.610   -20.015     0.200
     3.610   -19.383     0.200
     3.608   -13.748     0.200
     3.812   -21.650     0.200
     3.812   -20.744     0.200
     3.879   -20.531     0.200
     3.892   -21.201     0.200
     3.892   -21.358     0.200
     3.908   -20.756     0.200
     3.908   -21.084     0.200
     3.928   -22.307     0.200
     3.928   -21.331     0.200
     3.987   -20.495     0.200
     3.987   -21.737     0.200
     4.080   -22.069     0.200
     4.080   -22.858     0.200
     4.085   -20.460     0.200
     4.149   -22.997     0.200
     4.160   -24.174     0.200
     4.160   -22.893     0.200
     4.186   -23.306     0.200
     4.406   -24.272     0.200
     4.533   -24.865     0.200
     4.632   -25.821     0.200
     4.632   -27.540     0.200
     4.690   -26.870     0.200
     4.802   -27.553     0.200
     4.787   -27.155     0.200
     4.872   -27.620     0.200
     4.872   -27.729     0.200
     5.246   -30.446     0.200
     5.358   -32.193     0.200
     5.368   -32.522     0.200
     5.371   -32.862     0.200
     5.458   -31.267     0.200
     5.548   -31.321     0.200
     5.561   -33.654     0.200
     5.563   -34.332     0.200
     5.715   -35.052     0.200
     5.772   -36.383     0.200
     5.808   -36.165     0.200
     5.839   -35.767     0.200
     6.231   -37.858     0.200
     6.324   -39.865     0.200
     6.987   -44.979     0.200
     7.126   -45.742     0.200
     7.204   -47.117     0.200
     7.314   -45.833     0.200
     7.723   -50.783     0.200
     7.842   -51.819     0.200
     9.117   -61.942     0.200
     0.870     4.697     0.200
     0.834     3.450     0.200
     0.834     2.730     0.200
     1.087     0.784     0.200
     2.189    -8.496     0.200
     3.534   -19.570     0.200
     3.534   -19.226     0.200
     3.582   -20.164     0.200
     3.611   -20.059     0.200
     3.611   -19.880     0.200
     3.609   -19.851     0.200
     3.810   -22.197     0.200
     3.810   -21.893     0.200
     3.880   -21.106     0.200
     3.894   -21.638     0.200
     3.894   -20.669     0.200
     3.908   -22.094     0.200
     3.908   -21.750     0.200
     3.929   -22.291     0.200
     3.984   -21.810     0.200
     3.984   -22.419     0.200
     4.079   -23.942     0.200
     4.079   -22.747     0.200
     4.151   -23.860     0.200
     4.160   -22.895     0.200
     4.186   -23.726     0.200
     4.407   -25.455     0.200
     4.534   -26.136     0.200
     4.631   -26.970     0.200
     4.631   -27.087     0.200
     4.691   -27.661     0.200
     4.802   -28.203     0.200
     4.784   -28.387     0.200
     4.872   -29.726     0.200
     4.872   -28.968     0.200
     5.247   -32.352     0.200
     5.357   -33.618     0.200
     5.367   -33.688     0.200
     5.369   -34.414     0.200
     5.549   -32.889     0.200
     5.559   -35.731     0.200
     5.560   -36.152     0.200
     5.715   -35.771     0.200
     5.771   -35.268     0.200
     5.807   -37.124     0.200
     1.444     4.959     0.200
     1.304     6.070     0.200
     1.670     1.312     0.200
     1.931    -0.857     0.200
     2.082    -1.380     0.200
     2.463    -4.512     0.200
     2.888    -6.938     0.200
     5.392   -30.074     0.200
     5.419   -28.485     0.200
     5.676   -31.765     0.200
     5.768   -32.885     0.200
     5.916   -33.651     0.200
     6.058   -34.985     0.200
     6.254   -37.277     0.200
     1.204     2.418     0.200
     1.342     1.832     0.200
     1.639    -2.032     0.200
     1.710    -2.199     0.200
     3.021   -13.992     0.200
     2.936    -8.511     0.200
     4.906   -27.469     0.200
     4.926   -28.415     0.200
     5.229   -30.400     0.200
     5.267   -29.128     0.200
     5.479   -32.724     0.200
     5.589   -32.890     0.200
     5.724   -33.107     0.200
     5.901   -36.365     0.200
     5.951   -36.599     0.200
     6.045   -35.802     0.200
     6.104   -37.100     0.200
     1.414     3.958     0.200
     1.420     5.536     0.200
     5.324   -29.433     0.200
     5.438   -30.558     0.200
     5.455   -30.058     0.200
     5.528   -30.107     0.200
     5.682   -31.724     0.200
     5.721   -32.265     0.200
     6.111   -35.304     0.200
     6.188   -36.007     0.200
     6.296   -37.724     0.200
     6.644   -39.135     0.200
     6.686   -39.633     0.200
     7.148   -42.727     0.200
     1.166     4.587     0.200
     1.346     3.147     0.200
     1.485     0.280     0.200
     1.775    -2.035     0.200
     2.167    -4.280     0.200
     2.573    -6.408     0.200
     5.196   -29.554     0.200
     5.305   -30.139     0.200
     5.593   -32.157     0.200
     5.963   -35.634     0.200
     6.174   -36.285     0.200
     6.515   -38.522     0.200
     6.964   -48.206     0.200
     7.240   -44.747     0.200
     1.430     4.125     0.200
     1.622     0.756     0.200
     1.535     1.455     0.200
     1.795    -1.125     0.200
     2.592    -5.859     0.200
     5.200   -28.767     0.200
     5.308   -29.735     0.200
     5.355   -29.109     0.200
     5.596   -31.337     0.200
     5.963   -35.974     0.200
     6.179   -35.347     0.200
     6.519   -37.641     0.200
     6.969   -46.789     0.200
     1.305     2.792     0.200
     2.915    -9.372     0.200
     3.049    -8.355     0.200
     3.347   -10.246     0.200
     1.135     3.558     0.200
     1.182     4.023     0.200
     1.257     4.171     0.200
     1.489    -1.486     0.200
     2.039    -4.387     0.200
     2.941   -13.067     0.200
     3.045    -8.977     0.200
     3.057   -10.049     0.200
     3.135   -11.873     0.200
     3.135   -11.468     0.200
     3.246   -13.498     0.200
     3.246   -12.334     0.200
     3.384   -10.905     0.200
     3.480   -13.914     0.200
     3.921   -14.291     0.200
     4.107   -17.592     0.200
     4.055   -15.986     0.200
     4.475   -22.430     0.200
     4.534   -23.362     0.200
     4.534   -22.249     0.200
     4.867   -27.083     0.200
     4.867   -27.480     0.200
     4.869   -26.074     0.200
     5.160   -29.588     0.200
     5.160   -29.261     0.200
     5.208   -28.960     0.200
     5.274   -29.746     0.200
     5.334   -29.573     0.200
     5.333   -30.281     0.200
     5.333   -30.746     0.200
     5.416   -31.176     0.200
     5.458   -31.062     0.200
     5.535   -30.221     0.200
     5.652   -32.412     0.200
     5.652   -31.801     0.200
     5.706   -31.776     0.200
     5.842   -34.082     0.200
     5.886   -34.473     0.200
     5.975   -35.249     0.200
     5.975   -34.444     0.200
     5.975   -35.644     0.200
     6.417   -38.780     0.200
     6.831   -43.967     0.200
     0.951     2.512     0.200
     1.062     3.899     0.200
     1.249     0.901     0.200
     1.936    -6.265     0.200
     1.998    -5.709     0.200
     2.260    -5.818     0.200
     2.516    -9.154     0.200
     2.548    -9.869     0.200
     2.859   -12.345     0.200
     2.859   -12.538     0.200
     3.121   -13.799     0.200
     3.121   -16.177     0.200
     3.534   -15.785     0.200
     3.858   -22.457     0.200
     3.867   -15.493     0.200
     3.886   -20.087     0.200
     3.899   -22.394     0.200
     3.920   -22.903     0.200
     3.920   -22.364     0.200
     3.924   -18.708     0.200
     4.025   -24.451     0.200
     4.025   -21.854     0.200
     4.153   -24.148     0.200
     4.153   -21.847     0.200
     4.212   -23.942     0.200
     4.228   -24.809     0.200
     4.231   -22.113     0.200
     4.262   -23.713     0.200
     4.364   -27.165     0.200
     4.364   -26.440     0.200
     4.346   -23.394     0.200
     4.481   -26.067     0.200
     4.482   -26.344     0.200
     4.497   -27.244     0.200
     4.728   -27.742     0.200
     4.857   -29.085     0.200
     4.908   -30.016     0.200
     4.908   -29.493     0.200
     4.997   -30.790     0.200
     5.164   -31.286     0.200
     5.164   -31.502     0.200
     5.550   -35.509     0.200
     5.582   -36.813     0.200
     5.638   -35.662     0.200
     5.871   -34.272     0.200
     6.011   -38.953     0.200
     6.049   -38.989     0.200
     7.586   -52.183     0.200
     1.180     3.846     0.200
     1.282     2.282     0.200
     2.973   -12.806     0.200
     4.516   -22.620     0.200
     4.565   -23.571     0.200
     4.864   -29.764     0.200
     4.866   -29.822     0.200
     5.173   -30.594     0.200
     5.207   -32.329     0.200
     6.401   -40.843     0.200
     6.426   -40.469     0.200
     0.987     1.736     0.200
     2.508    -8.375     0.200
     4.540   -24.819     0.200
     5.278   -31.085     0.200
     5.477   -31.391     0.200
     6.053   -40.134     0.200
     6.166   -41.137     0.200
     6.183   -41.072     0.200
     6.269   -41.359     0.200
     6.292   -39.620     0.200
     6.393   -41.978     0.200
     6.450   -43.344     0.200
     6.450   -42.583     0.200
     6.536   -42.089     0.200
     6.689   -44.236     0.200
     6.699   -45.899     0.200
     6.798   -45.468     0.200
     6.828   -46.649     0.200
     6.828   -44.430     0.200
     6.878   -45.557     0.200
     6.918   -46.609     0.200
     7.026   -47.338     0.200
     7.316   -49.113     0.200
     7.576   -52.138     0.200
     7.576   -51.236     0.200
     7.813   -58.328     0.200
     7.876   -53.620     0.200
     8.009   -54.502     0.200
     8.009   -54.889     0.200
     8.105   -55.735     0.200
     8.420   -58.068     0.200
     8.522   -59.118     0.200
     9.082   -63.437     0.200
     9.797   -67.946     0.200
    10.072   -69.633     0.200
     1.412     0.505     0.200
     2.229    -4.276     0.200
     2.204    -4.263     0.200
     2.520    -6.547     0.200
     3.276   -12.010     0.200
     3.342   -10.984     0.200
     4.590   -22.375     0.200
     5.765   -32.040     0.200
     2.076    -1.891     0.200
     2.941   -11.418     0.200
     2.941   -10.111     0.200
     3.054    -7.979     0.200
     3.217   -12.095     0.200
     3.371   -13.261     0.200
     3.960   -13.625     0.200
     4.082   -17.898     0.200
     4.466   -21.455     0.200
     4.534   -21.184     0.200
     4.534   -22.349     0.200
     4.865   -25.985     0.200
     4.865   -25.609     0.200
     4.891   -25.402     0.200
     5.173   -26.976     0.200
     5.232   -26.670     0.200
     5.365   -29.771     0.200
     5.481   -29.680     0.200
     5.662   -31.107     0.200
     5.662   -31.837     0.200
     5.904   -34.088     0.200
     5.989   -34.080     0.200
     1.201     2.610     0.200
     2.557    -7.559     0.200
     2.692    -8.508     0.200
     2.692    -8.147     0.200
     2.817    -8.614     0.200
     2.888   -10.044     0.200
     3.543   -16.177     0.200
     3.655   -18.966     0.200
     4.377   -21.833     0.200
     4.899   -29.601     0.200
     4.899   -29.134     0.200
     4.962   -29.859     0.200
     5.002   -30.491     0.200
     5.002   -29.116     0.200
     5.009   -30.069     0.200
     5.009   -28.351     0.200
     5.158   -31.043     0.200
     5.158   -30.689     0.200
     5.158   -27.544     0.200
     5.196   -30.036     0.200
     5.255   -33.213     0.200
     5.255   -32.104     0.200
     5.262   -31.222     0.200
     5.262   -30.991     0.200
     5.281   -32.132     0.200
     5.281   -31.798     0.200
     5.480   -33.565     0.200
     5.480   -33.311     0.200
     5.485   -33.524     0.200
     5.532   -34.005     0.200
     5.574   -32.894     0.200
     5.900   -35.463     0.200
     5.998   -35.130     0.200
     6.031   -38.000     0.200
     6.031   -36.178     0.200
     6.082   -37.794     0.200
     6.186   -38.634     0.200
     6.272   -39.239     0.200
     6.272   -37.269     0.200
     6.649   -42.364     0.200
     6.714   -42.284     0.200
     6.758   -42.503     0.200
     7.113   -45.301     0.200
     7.172   -46.041     0.200
     7.180   -47.651     0.200
     8.378   -56.152     0.200
     9.105   -60.565     0.200
     1.585    -0.001     0.200
     1.765    -1.410     0.200
     1.851    -0.555     0.200
     2.419    -5.125     0.200
     2.419    -6.643     0.200
     2.560    -5.452     0.200
     2.561    -5.472     0.200
     2.936    -8.470     0.200
     2.936    -8.797     0.200
     3.011   -12.385     0.200
     3.011   -11.338     0.200
     3.370   -12.369     0.200
     3.370   -13.191     0.200
     3.477   -11.172     0.200
     3.477   -13.045     0.200
     3.590   -15.672     0.200
     3.592   -13.993     0.200
     4.116   -16.547     0.200
     4.560   -22.595     0.200
     4.601   -21.263     0.200
     4.601   -21.650     0.200
     4.697   -23.904     0.200
     4.697   -23.289     0.200
     4.858   -25.587     0.200
     4.858   -27.253     0.200
     4.869   -25.546     0.200
     4.874   -26.854     0.200
     5.194   -28.261     0.200
     5.214   -28.911     0.200
     5.214   -27.983     0.200
     5.317   -28.170     0.200
     5.317   -25.906     0.200
     5.324   -28.390     0.200
     5.465   -30.215     0.200
     5.529   -30.809     0.200
     5.694   -31.901     0.200
     5.848   -33.294     0.200
     5.908   -34.572     0.200
     6.009   -34.558     0.200
     6.009   -34.726     0.200
     6.058   -35.108     0.200
     6.443   -36.031     0.200
     1.377    -0.771     0.200
     1.946    -5.983     0.200
     5.544   -34.985     0.200
     5.558   -35.078     0.200
     5.637   -34.712     0.200
     5.658   -35.955     0.200
     5.835   -36.102     0.200
     5.903   -36.757     0.200
     6.250   -40.420     0.200
     6.296   -40.421     0.200
     6.401   -41.256     0.200
     6.709   -43.295     0.200
     6.757   -42.904     0.200
     7.184   -51.762     0.200
     6.984   -45.051     0.200
     7.522   -49.457     0.200
     1.108     3.846     0.200
     1.180     4.158     0.200
     5.335   -31.258     0.200
     5.432   -32.820     0.200
     5.523   -32.943     0.200
     6.054   -37.511     0.200
     6.322   -39.355     0.200
     7.335   -46.836     0.200
     1.125    -1.628     0.200
     1.709    -7.715     0.200
     2.557   -10.542     0.200
     2.670   -13.617     0.200
     3.063   -13.787     0.200
     3.327   -18.267     0.200
     3.327   -20.689     0.200
     3.458   -20.897     0.200
     3.488   -20.331     0.200
     4.030   -23.117     0.200
     4.117   -26.942     0.200
     4.207   -26.908     0.200
     4.345   -28.151     0.200
     4.345   -28.003     0.200
     4.388   -27.931     0.200
     4.378   -27.823     0.200
     4.378   -28.753     0.200
     4.423   -29.253     0.200
     4.509   -29.515     0.200
     4.660   -29.602     0.200
     4.689   -30.855     0.200
     4.689   -31.207     0.200
     4.822   -32.356     0.200
     4.904   -31.418     0.200
     4.904   -31.941     0.200
     5.110   -34.381     0.200
     5.391   -36.674     0.200
     6.238   -43.017     0.200
     6.282   -43.256     0.200
     2.136    -5.772     0.200
     2.957   -10.138     0.200
     3.020   -11.307     0.200
     4.456   -25.537     0.200
     4.487   -24.682     0.200
     4.589   -25.604     0.200
     4.832   -27.052     0.200
     4.978   -28.333     0.200
     5.110   -29.944     0.200
     5.139   -29.656     0.200
     5.316   -32.263     0.200
     5.365   -32.876     0.200
     5.540   -32.593     0.200
     5.662   -33.602     0.200
     5.716   -35.703     0.200
     6.105   -42.717     0.200
     6.411   -39.536     0.200
     2.767    -6.956     0.200
     4.751   -26.679     0.200
     4.751   -26.421     0.200
     4.805   -26.493     0.200
     4.934   -28.143     0.200
     4.934   -26.682     0.200
     5.023   -29.202     0.200
     5.023   -26.819     0.200
     5.078   -27.887     0.200
     5.127   -27.581     0.200
     5.129   -28.570     0.200
     5.293   -31.860     0.200
     5.293   -30.915     0.200
     5.353   -30.716     0.200
     5.380   -29.415     0.200
     5.752   -34.026     0.200
     5.838   -35.174     0.200
     6.936   -43.117     0.200
     1.652    -2.680     0.200
     1.977    -1.662     0.200
     1.977    -2.201     0.200
     2.177    -6.126     0.200
     2.177    -5.794     0.200
     2.367    -5.361     0.200
     2.736    -6.192     0.200
     2.840    -6.923     0.200
     2.840    -9.366     0.200
     2.947    -9.063     0.200
     2.948    -7.892     0.200
     3.606   -15.428     0.200
     3.744   -17.574     0.200
     3.786   -19.651     0.200
     3.769   -14.710     0.200
     3.961   -20.806     0.200
     3.961   -19.830     0.200
     3.961   -19.950     0.200
     4.301   -21.924     0.200
     4.281   -21.483     0.200
     4.281   -21.733     0.200
     4.515   -22.731     0.200
     4.551   -23.427     0.200
     4.935   -26.780     0.200
     4.991   -26.740     0.200
     4.881   -21.925     0.200
     4.881   -22.835     0.200
     5.282   -28.840     0.200
     5.522   -30.702     0.200
     5.952   -34.267     0.200
     1.495    -3.435     0.200
     1.568    -2.355     0.200
     1.755    -3.909     0.200
     4.044   -22.943     0.200
     4.043   -23.002     0.200
     4.384   -25.339     0.200
     4.359   -23.668     0.200
     5.071   -29.360     0.200
     3.170    -9.691     0.200
     3.817   -13.746     0.200
     0.950     2.762     0.200
     1.081     1.038     0.200
     1.319    -2.008     0.200
     2.515    -8.213     0.200
     3.602   -20.255     0.200
     3.602   -17.325     0.200
     3.792   -19.805     0.200
     4.496   -28.060     0.200
     4.584   -28.280     0.200
     4.584   -27.624     0.200
     4.727   -28.941     0.200
     4.727   -29.183     0.200
     4.727   -29.964     0.200
     4.805   -29.469     0.200
     4.805   -30.117     0.200
     4.888   -30.714     0.200
     4.888   -30.581     0.200
     4.888   -31.026     0.200
     5.010   -31.758     0.200
     5.010   -31.883     0.200
     5.042   -31.684     0.200
     5.135   -32.405     0.200
     5.135   -32.257     0.200
     5.185   -33.761     0.200
     5.185   -33.472     0.200
     5.195   -33.215     0.200
     5.373   -34.444     0.200
     5.491   -35.561     0.200
     5.725   -37.604     0.200
     5.725   -36.542     0.200
     5.752   -38.024     0.200
     5.752   -37.243     0.200
     5.806   -37.152     0.200
     5.954   -38.163     0.200
     5.954   -38.491     0.200
     6.286   -40.198     0.200
     6.286   -40.479     0.200
     6.466   -42.413     0.200
     6.495   -42.056     0.200
     6.495   -42.571     0.200
     6.495   -41.001     0.200
     6.563   -44.420     0.200
     6.579   -44.700     0.200
     6.777   -44.580     0.200
     6.883   -45.310     0.200
     0.974     3.037     0.200
     0.997     3.127     0.200
     1.056     3.932     0.200
     1.300     0.943     0.200
     1.457    -1.018     0.200
     2.023    -4.978     0.200
     2.469    -7.187     0.200
     2.701   -10.134     0.200
     2.701   -10.867     0.200
     2.701    -9.105     0.200
     2.890   -10.285     0.200
     2.890   -11.527     0.200
     3.173   -15.775     0.200
     3.235   -13.340     0.200
     3.322   -15.342     0.200
     3.322   -14.986     0.200
     3.546   -16.010     0.200
     3.546   -16.255     0.200
     3.742   -17.615     0.200
     3.742   -17.311     0.200
     3.767   -16.747     0.200
     3.769   -16.928     0.200
     3.793   -19.414     0.200
     3.764   -17.811     0.200
     4.283   -23.042     0.200
     4.399   -21.941     0.200
     4.729   -24.710     0.200
     4.729   -24.950     0.200
     4.836   -28.920     0.200
     4.980   -29.970     0.200
     4.980   -29.319     0.200
     4.981   -30.008     0.200
     4.981   -30.628     0.200
     4.991   -31.372     0.200
     4.991   -30.834     0.200
     5.330   -32.621     0.200
     5.330   -33.044     0.200
     5.332   -32.680     0.200
     5.357   -29.482     0.200
     5.424   -32.988     0.200
     5.581   -34.656     0.200
     5.537   -30.935     0.200
     5.537   -30.686     0.200
     5.633   -34.522     0.200
     5.837   -36.342     0.200
     5.837   -36.033     0.200
     6.036   -37.707     0.200
     6.146   -39.945     0.200
     6.146   -39.674     0.200
     6.279   -37.461     0.200
     6.575   -41.747     0.200
     0.818     4.044     0.200
     0.936     3.812     0.200
     0.872     4.463     0.200
     1.622    -2.621     0.200
     1.879    -4.843     0.200
     1.882    -4.290     0.200
     2.285    -7.473     0.200
     2.310    -6.373     0.200
     2.503    -8.666     0.200
     3.000   -12.771     0.200
     3.162   -13.965     0.200
     3.448   -14.689     0.200
     3.502   -13.774     0.200
     3.546   -15.899     0.200
     4.636   -26.920     0.200
     4.636   -27.236     0.200
     4.767   -27.885     0.200
     4.767   -28.264     0.200
     4.772   -28.331     0.200
     4.772   -27.975     0.200
     4.780   -27.949     0.200
     4.780   -28.465     0.200
     5.118   -31.443     0.200
     5.118   -30.896     0.200
     5.130   -31.831     0.200
     5.130   -30.694     0.200
     5.196   -29.978     0.200
     5.196   -29.333     0.200
     5.196   -31.005     0.200
     5.348   -31.784     0.200
     5.370   -32.863     0.200
     5.419   -31.634     0.200
     5.419   -33.388     0.200
     5.457   -29.456     0.200
     5.618   -34.485     0.200
     5.640   -34.114     0.200
     5.640   -34.532     0.200
     5.752   -35.536     0.200
     5.944   -37.953     0.200
     5.944   -37.558     0.200
     5.944   -36.761     0.200
     5.973   -37.163     0.200
     6.109   -37.117     0.200
     6.370   -39.331     0.200
     6.373   -40.365     0.200
     6.634   -41.479     0.200
     6.760   -43.713     0.200
     6.800   -43.528     0.200
     1.873    -3.212     0.200
     4.819   -28.400     0.200
     4.831   -28.804     0.200
     5.176   -30.715     0.200
     5.251   -30.158     0.200
     5.264   -31.793     0.200
     5.803   -35.834     0.200
     1.118     3.674     0.200
     1.245     2.557     0.200
     2.042    -4.302     0.200
     2.387    -6.009     0.200
     2.420    -7.977     0.200
     2.624    -8.800     0.200
     2.624    -9.113     0.200
     2.896   -10.558     0.200
     2.896   -11.035     0.200
     3.197   -13.145     0.200
     3.292   -12.747     0.200
     3.292   -14.141     0.200
     3.429   -13.488     0.200
     3.429   -13.035     0.200
     3.561   -16.341     0.200
     3.590   -17.127     0.200
     3.591   -13.403     0.200
     3.840   -20.544     0.200
     3.840   -19.812     0.200
     3.840   -18.914     0.200
     3.889   -21.315     0.200
     3.889   -21.937     0.200
     3.907   -19.958     0.200
     3.907   -20.132     0.200
     3.918   -22.305     0.200
     3.918   -21.360     0.200
     3.862   -18.320     0.200
     4.079   -20.602     0.200
     4.183   -21.836     0.200
     4.193   -23.919     0.200
     4.193   -21.351     0.200
     4.193   -20.888     0.200
     4.193   -22.890     0.200
     4.215   -24.327     0.200
     4.215   -22.676     0.200
     4.215   -22.498     0.200
     4.231   -21.860     0.200
     4.231   -21.389     0.200
     4.225   -22.702     0.200
     4.225   -21.907     0.200
     4.255   -21.767     0.200
     4.380   -26.351     0.200
     4.380   -26.192     0.200
     4.454   -23.713     0.200
     4.454   -24.043     0.200
     4.467   -26.814     0.200
     4.467   -23.846     0.200
     4.467   -24.900     0.200
     4.493   -23.345     0.200
     4.713   -25.042     0.200
     4.929   -29.691     0.200
     4.929   -29.386     0.200
     5.004   -28.040     0.200
     5.109   -30.127     0.200
     5.175   -31.535     0.200
     5.175   -31.707     0.200
     5.175   -31.080     0.200
     5.552   -34.149     0.200
     5.552   -34.454     0.200
     5.612   -34.597     0.200
     5.598   -32.386     0.200
     5.636   -34.306     0.200
     5.657   -35.450     0.200
     5.793   -36.364     0.200
     5.793   -35.363     0.200
     5.795   -34.294     0.200
     5.855   -35.092     0.200
     5.855   -34.598     0.200
     5.855   -36.232     0.200
     6.019   -37.783     0.200
     6.088   -38.163     0.200
     7.323   -48.538     0.200
     8.008   -53.099     0.200
     8.008   -51.388     0.200
     1.825    -1.584     0.200
     1.934    -2.037     0.200
     2.073    -4.222     0.200
     2.348    -4.567     0.200
     2.808    -7.655     0.200
     5.543   -33.326     0.200
     5.543   -33.170     0.200
     5.633   -33.314     0.200
     5.667   -33.042     0.200
     5.667   -32.096     0.200
     5.826   -35.745     0.200
     5.826   -35.398     0.200
     6.065   -37.593     0.200
     6.122   -37.099     0.200
     6.215   -39.621     0.200
     6.293   -40.096     0.200
     6.401   -40.408     0.200
     6.327   -37.552     0.200
     6.790   -42.904     0.200
     6.958   -44.958     0.200
     7.188   -50.506     0.200
     7.126   -43.910     0.200
     7.253   -46.394     0.200
     7.490   -48.033     0.200
     1.224     1.124     0.200
     1.278     0.917     0.200
     1.816    -3.616     0.200
     1.898    -3.604     0.200
     2.465    -9.466     0.200
     2.765    -9.926     0.200
     3.053   -12.866     0.200
     3.179   -13.992     0.200
     3.941   -20.479     0.200
     4.078   -23.684     0.200
     4.096   -23.515     0.200
     4.478   -26.151     0.200
     4.684   -28.116     0.200
     4.727   -28.215     0.200
     5.066   -31.083     0.200
     5.288   -31.628     0.200
     5.702   -34.610     0.200
     5.734   -36.627     0.200
     1.048     4.156     0.200
     1.133     2.427     0.200
     1.882    -4.170     0.200
     2.167    -5.665     0.200
     2.593    -7.885     0.200
     2.770    -8.217     0.200
     3.468   -13.660     0.200
     3.638   -16.705     0.200
     4.377   -24.077     0.200
     5.225   -30.811     0.200
     5.225   -32.277     0.200
     5.325   -32.031     0.200
     5.325   -32.240     0.200
     5.512   -33.362     0.200
     5.401   -31.941     0.200
     5.407   -31.778     0.200
     5.407   -32.635     0.200
     5.471   -32.745     0.200
     5.500   -31.793     0.200
     5.500   -32.522     0.200
     5.620   -35.519     0.200
     5.512   -30.981     0.200
     5.620   -33.765     0.200
     5.620   -34.281     0.200
     5.798   -36.046     0.200
     5.742   -34.385     0.200
     5.742   -33.500     0.200
     5.798   -35.660     0.200
     5.956   -37.881     0.200
     5.864   -35.726     0.200
     5.864   -35.832     0.200
     5.975   -36.388     0.200
     5.955   -36.110     0.200
     5.956   -36.342     0.200
     5.975   -35.909     0.200
     6.211   -39.137     0.200
     6.526   -41.960     0.200
     6.526   -40.130     0.200
     6.542   -40.182     0.200
     6.716   -41.535     0.200
     6.716   -40.898     0.200
     7.004   -49.690     0.200
     6.758   -42.634     0.200
     7.236   -46.107     0.200
     7.352   -47.068     0.200
     7.361   -48.145     0.200
     7.531   -48.235     0.200
     7.546   -48.753     0.200
     7.652   -49.257     0.200
     7.771   -48.819     0.200
     8.914   -58.112     0.200
     8.914   -58.755     0.200
     1.298     4.425     0.200
     1.870    -0.628     0.200
     2.356    -2.471     0.200
     2.609    -4.542     0.200
     2.602    -4.000     0.200
     2.691    -6.189     0.200
     2.684    -7.202     0.200
     2.691    -5.932     0.200
     2.907    -8.514     0.200
     3.080    -9.116     0.200
     3.058   -10.673     0.200
     3.588   -11.785     0.200
     4.023   -15.947     0.200
     4.023   -19.939     0.200
     4.267   -18.444     0.200
     4.267   -19.168     0.200
     4.447   -20.041     0.200
     4.605   -20.218     0.200
     5.150   -25.445     0.200
     5.559   -28.462     0.200
     5.512   -28.389     0.200
     5.697   -30.317     0.200
     5.697   -31.592     0.200
     5.811   -32.128     0.200
     5.811   -31.748     0.200
     5.829   -33.541     0.200
     5.829   -33.414     0.200
     5.832   -34.236     0.200
     6.168   -36.260     0.200
     6.168   -35.561     0.200
     6.196   -35.400     0.200
     6.185   -34.043     0.200
     6.192   -35.830     0.200
     6.213   -33.767     0.200
     6.213   -34.920     0.200
     6.213   -34.304     0.200
     6.192   -37.555     0.200
     6.238   -36.307     0.200
     6.238   -36.203     0.200
     6.406   -35.687     0.200
     6.420   -38.141     0.200
     6.453   -37.999     0.200
     6.453   -36.078     0.200
     6.669   -38.581     0.200
     6.699   -38.479     0.200
     6.801   -40.447     0.200
     7.006   -39.977     0.200
     7.006   -43.369     0.200
     7.030   -41.883     0.200
     7.431   -45.191     0.200
     7.432   -44.809     0.200
     7.862   -49.150     0.200
     1.100     3.573     0.200
     1.337     4.014     0.200
     1.340     4.284     0.200
     1.685    -0.625     0.200
     2.026    -4.538     0.200
     2.276    -6.018     0.200
     2.411    -6.033     0.200
     2.562    -8.848     0.200
     2.843   -10.053     0.200
     2.924   -10.105     0.200
     3.037    -9.279     0.200
     3.108   -10.200     0.200
     3.187    -9.634     0.200
     3.505   -13.334     0.200
     3.557   -13.994     0.200
     3.813   -14.155     0.200
     4.193   -19.207     0.200
     4.429   -21.190     0.200
     4.332   -16.996     0.200
     4.534   -19.383     0.200
     4.665   -23.523     0.200
     4.913   -26.454     0.200
     4.959   -26.719     0.200
     4.959   -27.145     0.200
     4.858   -22.189     0.200
     4.983   -25.905     0.200
     5.165   -28.218     0.200
     5.301   -28.972     0.200
     5.301   -29.476     0.200
     5.478   -31.616     0.200
     5.478   -29.402     0.200
     5.496   -31.526     0.200
     5.496   -32.524     0.200
     5.627   -31.780     0.200
     5.666   -31.506     0.200
     5.794   -32.109     0.200
     5.931   -33.577     0.200
     5.977   -34.927     0.200
     6.098   -35.399     0.200
     6.351   -37.167     0.200
     6.264   -33.877     0.200
     6.441   -38.179     0.200
     6.441   -37.929     0.200
     6.735   -40.902     0.200
     6.830   -40.429     0.200
     1.125     2.886     0.200
     1.411    -2.643     0.200
     2.222    -8.833     0.200
     2.698   -11.424     0.200
     2.698   -11.893     0.200
     3.170   -14.242     0.200
     3.201   -14.575     0.200
     3.946   -15.345     0.200
     3.964   -15.581     0.200
     3.995   -20.603     0.200
     4.108   -17.188     0.200
     4.282   -21.555     0.200
     4.282   -23.254     0.200
     4.508   -27.095     0.200
     4.519   -27.093     0.200
     4.519   -27.673     0.200
     4.519   -26.428     0.200
     4.524   -27.059     0.200
     4.524   -26.204     0.200
     4.849   -29.182     0.200
     4.849   -27.837     0.200
     4.863   -29.417     0.200
     4.863   -28.194     0.200
     4.970   -29.504     0.200
     4.975   -31.361     0.200
     4.975   -28.698     0.200
     5.353   -31.230     0.200
     5.353   -33.210     0.200
     5.663   -35.611     0.200
     5.663   -34.637     0.200
     5.663   -34.959     0.200
     5.708   -33.781     0.200
     6.096   -36.615     0.200
     1.990    -6.317     0.200
     3.473   -20.636     0.200
     3.509   -21.112     0.200
     3.840   -23.436     0.200
     3.967   -24.363     0.200
     4.092   -25.867     0.200
     4.470   -27.372     0.200
     4.602   -28.766     0.200
     4.723   -29.906     0.200
     4.767   -29.193     0.200
     5.154   -32.743     0.200
     0.825     2.490     0.200
     2.042    -6.598     0.200
     2.671   -11.688     0.200
     2.873   -11.739     0.200
     3.041   -13.931     0.200
     2.938   -10.775     0.200
     1.731    -2.075     0.200
     1.968    -3.752     0.200
     2.500    -9.396     0.200
     3.458   -13.828     0.200
     3.568   -16.462     0.200
     3.910   -19.120     0.200
     4.827   -29.545     0.200
     4.888   -29.630     0.200
     5.072   -30.943     0.200
     5.175   -30.304     0.200
     5.188   -31.227     0.200
     5.400   -34.154     0.200
     5.460   -33.115     0.200
     5.828   -35.982     0.200
     5.950   -38.020     0.200
     6.194   -38.752     0.200
     0.826     4.186     0.200
     2.469    -8.910     0.200
     2.594   -12.546     0.200
     3.579   -21.486     0.200
     3.596   -20.839     0.200
     3.606   -20.804     0.200
     3.644   -18.293     0.200
     3.788   -23.850     0.200
     3.907   -22.662     0.200
     3.957   -24.119     0.200
     4.047   -23.881     0.200
     4.159   -25.847     0.200
     4.619   -29.729     0.200
     4.754   -30.128     0.200
     5.240   -33.574     0.200
     0.961     1.980     0.200
     3.139   -13.540     0.200
     4.126   -24.819     0.200
     4.183   -25.440     0.200
     4.183   -25.768     0.200
     4.227   -27.134     0.200
     4.227   -25.674     0.200
     4.449   -28.447     0.200
     4.449   -26.237     0.200
     4.409   -29.202     0.200
     4.409   -28.038     0.200
     4.497   -26.694     0.200
     4.505   -29.336     0.200
     4.505   -27.477     0.200
     4.552   -28.428     0.200
     4.552   -28.225     0.200
     4.697   -30.526     0.200
     4.725   -29.884     0.200
     5.250   -34.542     0.200
     5.250   -33.761     0.200
     5.324   -32.547     0.200
     5.488   -37.006     0.200
     5.488   -34.381     0.200
     5.857   -38.969     0.200
     5.940   -39.815     0.200
     5.967   -40.322     0.200
     1.552    -3.528     0.200
     2.288    -9.260     0.200
     2.288    -7.998     0.200
     2.658   -10.196     0.200
     2.829   -11.661     0.200
     2.895   -11.640     0.200
     3.679   -14.948     0.200
     3.873   -20.978     0.200
     4.092   -24.818     0.200
     4.092   -24.732     0.200
     4.557   -25.247     0.200
     4.683   -28.535     0.200
     4.916   -30.135     0.200
     5.122   -31.177     0.200
     1.323     3.423     0.200
     1.445     0.258     0.200
     3.109   -10.012     0.200
     3.618   -11.656     0.200
     5.350   -31.344     0.200
     5.433   -29.884     0.200
     5.900   -33.991     0.200
     6.569   -38.159     0.200
     0.950     3.379     0.200
     1.290     1.779     0.200
     1.567    -2.286     0.200
     1.912    -4.349     0.200
     2.969    -9.596     0.200
     3.500   -15.755     0.200
     3.794   -20.174     0.200
     3.794   -19.112     0.200
     3.841   -20.644     0.200
     3.841   -19.566     0.200
     4.313   -25.292     0.200
     4.313   -24.964     0.200
     4.428   -26.307     0.200
     4.458   -24.999     0.200
     4.458   -26.233     0.200
     4.502   -26.163     0.200
     4.520   -26.389     0.200
     4.520   -25.506     0.200
     4.515   -24.434     0.200
     4.559   -28.181     0.200
     4.693   -27.805     0.200
     4.693   -28.133     0.200
     4.711   -26.955     0.200
     4.711   -27.541     0.200
     4.803   -28.430     0.200
     4.865   -26.794     0.200
     4.877   -27.857     0.200
     5.113   -30.595     0.200
     5.346   -33.116     0.200
     5.346   -33.444     0.200
     5.526   -32.323     0.200
     5.690   -36.734     0.200
     5.848   -36.266     0.200
     6.138   -38.403     0.200
     6.182   -40.056     0.200
     6.273   -40.061     0.200
     6.623   -44.194     0.200
     6.713   -44.689     0.200
     6.925   -46.023     0.200
     6.997   -44.638     0.200
     7.809   -52.790     0.200
     8.543   -57.823     0.200
     4.539   -19.888     0.200
     4.780   -24.679     0.200
     4.910   -26.210     0.200
     5.126   -29.439     0.200
     5.202   -27.973     0.200
     5.307   -30.530     0.200
     5.411   -32.014     0.200
     5.468   -26.812     0.200
     5.527   -31.276     0.200
     5.530   -32.153     0.200
     5.639   -31.197     0.200
     5.639   -33.521     0.200
     5.791   -34.362     0.200
     6.076   -34.448     0.200
     6.146   -37.712     0.200
     6.379   -38.876     0.200
     6.364   -36.527     0.200
     6.684   -44.387     0.200
     6.766   -44.426     0.200
     6.791   -41.847     0.200
     6.944   -45.665     0.200
     6.952   -43.841     0.200
     6.996   -47.322     0.200
     7.097   -40.678     0.200
     7.170   -46.067     0.200
     7.240   -44.415     0.200
     7.357   -45.804     0.200
     7.531   -50.556     0.200
     7.636   -51.554     0.200
     7.692   -49.702     0.200
     7.744   -50.821     0.200
     7.941   -51.893     0.200
     7.941   -51.159     0.200
     7.942   -52.457     0.200
     8.084   -50.736     0.200
     8.465   -55.570     0.200
     8.457   -49.534     0.200
     8.830   -59.366     0.200
     8.873   -60.993     0.200
     9.028   -60.981     0.200
     9.110   -60.233     0.200
     9.193   -59.477     0.200
     9.250   -63.924     0.200
     9.420   -63.312     0.200
     9.454   -62.850     0.200
     9.503   -64.649     0.200
     9.529   -63.142     0.200
     9.502   -58.148     0.200
     9.543   -63.605     0.200
     9.592   -63.339     0.200
     9.619   -65.249     0.200
     9.645   -66.066     0.200
     9.673   -64.628     0.200
     9.676   -65.488     0.200
     9.733   -64.977     0.200
     2.911   -10.017     0.200
     3.058   -11.070     0.200
     3.588   -17.976     0.200
     3.802   -19.508     0.200
     3.802   -16.537     0.200
     3.933   -20.669     0.200
     4.002   -19.736     0.200
     4.079   -21.496     0.200
     4.142   -19.175     0.200
     4.189   -22.705     0.200
     4.189   -21.781     0.200
     4.282   -23.944     0.200
     4.438   -22.803     0.200
     4.455   -25.153     0.200
     4.455   -24.210     0.200
     4.680   -25.960     0.200
     4.801   -26.870     0.200
     4.801   -25.610     0.200
     5.019   -28.717     0.200
     5.102   -28.080     0.200
     5.229   -31.099     0.200
     5.229   -29.962     0.200
     5.572   -31.914     0.200
     5.736   -33.601     0.200
     1.806    -4.408     0.200
     1.913    -3.844     0.200
     2.739    -7.992     0.200
     2.739   -10.839     0.200
     2.866   -10.471     0.200
     3.272   -12.075     0.200
     3.272   -13.536     0.200
     3.295   -16.117     0.200
     3.410   -16.929     0.200
     3.641   -18.789     0.200
     3.744   -18.806     0.200
     3.747   -17.728     0.200
     3.747   -18.142     0.200
     3.902   -18.729     0.200
     3.902   -19.401     0.200
     4.142   -22.838     0.200
     4.160   -19.254     0.200
     4.160   -20.784     0.200
     4.269   -22.962     0.200
     4.270   -20.990     0.200
     4.672   -27.594     0.200
     4.672   -26.444     0.200
     4.731   -26.989     0.200
     4.731   -27.894     0.200
     4.731   -27.470     0.200
     4.765   -26.387     0.200
     4.765   -28.270     0.200
     4.767   -26.852     0.200
     4.767   -27.885     0.200
     4.910   -28.079     0.200
     4.910   -29.024     0.200
     4.930   -26.722     0.200
     4.985   -28.867     0.200
     4.985   -29.599     0.200
     4.985   -28.193     0.200
     4.994   -28.019     0.200
     5.017   -27.814     0.200
     5.017   -28.601     0.200
     5.038   -30.004     0.200
     5.052   -28.687     0.200
     5.052   -30.202     0.200
     5.052   -27.769     0.200
     5.238   -33.000     0.200
     5.238   -31.250     0.200
     5.267   -30.302     0.200
     5.303   -30.368     0.200
     5.303   -32.321     0.200
     5.341   -31.236     0.200
     5.548   -31.990     0.200
     5.673   -35.051     0.200
     5.673   -32.500     0.200
     5.758   -32.922     0.200
     5.787   -34.426     0.200
     5.787   -36.417     0.200
     5.847   -35.322     0.200
     5.847   -34.871     0.200
     5.953   -35.006     0.200
     6.032   -36.656     0.200
     6.032   -37.883     0.200
     6.032   -37.209     0.200
     6.199   -34.238     0.200
     6.404   -39.670     0.200
     6.404   -38.763     0.200
     6.405   -40.623     0.200
     6.466   -40.597     0.200
     6.515   -40.816     0.200
     6.570   -42.300     0.200
     6.686   -40.939     0.200
     6.686   -42.101     0.200
     6.686   -40.601     0.200
     6.874   -43.370     0.200
     6.928   -44.283     0.200
     6.932   -45.019     0.200
     7.390   -47.940     0.200
     7.479   -47.519     0.200
     7.510   -48.566     0.200
     8.032   -50.158     0.200
     8.131   -53.525     0.200
     8.131   -52.826     0.200
     8.357   -54.523     0.200
     8.723   -59.377     0.200
     8.858   -59.439     0.200
     2.538   -10.598     0.200
     2.538   -12.149     0.200
     2.748   -12.290     0.200
     2.748   -14.405     0.200
     2.987   -15.420     0.200
     2.987   -15.748     0.200
     3.127   -15.089     0.200
     3.127   -18.027     0.200
     3.250   -18.472     0.200
     3.353   -16.461     0.200
     3.605   -22.829     0.200
     3.741   -16.837     0.200
     4.048   -25.733     0.200
     4.081   -22.947     0.200
     4.081   -25.334     0.200
     4.125   -25.556     0.200
     4.125   -25.831     0.200
     4.140   -24.768     0.200
     4.147   -25.891     0.200
     4.147   -26.514     0.200
     4.146   -26.262     0.200
     4.146   -27.709     0.200
     4.146   -25.836     0.200
     4.482   -28.795     0.200
     4.482   -28.513     0.200
     4.482   -28.254     0.200
     4.504   -27.731     0.200
     4.538   -29.211     0.200
     4.538   -29.823     0.200
     4.542   -28.310     0.200
     4.559   -27.771     0.200
     4.724   -30.028     0.200
     4.734   -30.935     0.200
     4.771   -30.682     0.200
     4.771   -29.975     0.200
     4.982   -31.684     0.200
     5.063   -32.630     0.200
     5.063   -33.206     0.200
     5.115   -33.145     0.200
     5.213   -34.014     0.200
     5.213   -33.879     0.200
     5.291   -32.760     0.200
     5.348   -35.501     0.200
     5.348   -36.102     0.200
     5.348   -34.594     0.200
     5.348   -34.139     0.200
     5.759   -38.157     0.200
     5.796   -37.923     0.200
     6.124   -40.145     0.200
     6.201   -40.584     0.200
     7.612   -52.185     0.200
     1.822    -3.701     0.200
     2.734   -10.523     0.200
     3.511   -18.935     0.200
     3.511   -17.947     0.200
     3.388   -14.660     0.200
     3.579   -19.731     0.200
     3.579   -18.958     0.200
     3.627   -18.674     0.200
     3.681   -20.957     0.200
     3.819   -19.580     0.200
     3.959   -21.874     0.200
     4.100   -24.020     0.200
     4.146   -22.838     0.200
     4.146   -21.631     0.200
     4.137   -22.970     0.200
     4.174   -23.195     0.200
     4.389   -24.165     0.200
     4.512   -24.503     0.200
     4.700   -27.483     0.200
     4.803   -26.886     0.200
     4.916   -30.505     0.200
     4.916   -28.575     0.200
     5.267   -31.035     0.200
     5.267   -30.750     0.200
     5.510   -34.457     0.200
     5.551   -36.066     0.200
     5.748   -35.117     0.200
     6.269   -38.138     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.146     1.962     0.200
     0.614     2.878     0.200
     2.016     0.420     0.200
     1.828    -1.016     0.200
     2.357     1.691     0.200
     0.189     3.136     0.200
     1.506     1.375     0.200
     3.206    -9.509     0.200
     4.058   -10.515     0.200
     5.042   -13.218     0.200
     7.300   -16.190     0.200
     0.603     4.107     0.200
     1.183    -5.784     0.200
     1.183    -2.284     0.200
     1.569     0.482     0.200
     1.801     1.633     0.200
     2.598    -4.132     0.200
     7.009   -12.966     0.200
     0.609     1.757     0.200
     1.205    -2.652     0.200
     4.572   -11.185     0.200
     7.010   -13.674     0.200
     1.604     2.968     0.200
     1.940     0.323     0.200
     4.599   -10.982     0.200
     0.149     4.470     0.200
     0.701     1.457     0.200
     1.839    -2.111     0.200
     0.827     2.984     0.200
     0.998     1.455     0.200
     0.764     1.204     0.200
     0.899     2.411     0.200
     1.054     2.807     0.200
     0.523     1.263     0.200
     1.198     1.365     0.200
     1.557    -0.505     0.200
     1.704    -1.184     0.200
     1.660    -0.279     0.200
     1.879    -0.203     0.200
     1.917    -0.826     0.200
     1.867    -0.835     0.200
     2.434    -3.817     0.200
     0.646     2.101     0.200
     0.746     2.934     0.200
     0.943     0.714     0.200
     1.486    -1.010     0.200
     1.642    -0.949     0.200
     0.215     1.059     0.200
     0.274     1.678     0.200
     0.274     2.178     0.200
     0.274     3.178     0.200
     0.826     3.193     0.200
     1.138     1.788     0.200
     1.644    -0.241     0.200
     1.738    -0.739     0.200
     2.046    -1.998     0.200
     2.950    -4.635     0.200
     0.645     2.203     0.200
     0.956     0.368     0.200
     1.297     1.037     0.200
     1.652    -0.202     0.200
     1.875    -2.765     0.200
     0.220     2.044     0.200
     0.658     2.652     0.200
     0.792     2.202     0.200
     1.921    -1.678     0.200
     2.110    -3.356     0.200
     2.329    -4.827     0.200
     0.756     2.474     0.200
     1.890     0.548     0.200
     2.010     0.750     0.200
     2.010     1.750     0.200
     2.010     2.750     0.200
     0.700     1.656     0.200
     1.693     0.193     0.200
     2.472    -2.520     0.200
     0.783     2.463     0.200
     0.783     3.463     0.200
     1.799    -1.236     0.200
     2.683    -4.258     0.200
     0.906     1.831     0.200
     2.317    -3.926     0.200
     0.667     2.811     0.200
     0.456     2.599     0.200
     2.064    -3.373     0.200
     0.750     1.997     0.200
     1.359     0.670     0.200
     1.247    -0.394     0.200
     5.071   -15.338     0.200
     0.577     2.636     0.200
     0.610     1.860     0.200
     1.414     0.074     0.200
     1.374     1.479     0.200
     1.378     1.298     0.200
     1.549     0.571     0.200
     1.153     3.074     0.200
     1.243     2.224     0.200
     2.103    -1.047     0.200
     2.301    -1.314     0.200
     0.167     2.854     0.200
     1.262    -2.362     0.200
     1.666    -0.152     0.200
     1.801     0.068     0.200
     1.979    -1.298     0.200
     1.984    -1.427     0.200
     1.990    -3.241     0.200
     2.368    -3.919     0.200
     3.111    -7.033     0.200
     3.355    -9.787     0.200
     1.599    -0.312     0.200
     1.920    -1.007     0.200
     1.930    -2.624     0.200
     1.852    -0.327     0.200
     2.421    -3.352     0.200
     0.424     1.665     0.200
     1.087     3.662     0.200
     1.792     2.296     0.200
     0.140     1.833     0.200
     0.461     1.665     0.200
     1.047     2.073     0.200
     1.508     3.473     0.200
     0.130     3.361     0.200
     0.390     2.111     0.200
     1.055     2.032     0.200
     1.214     0.993     0.200
     1.880     1.368     0.200
     0.798     2.084     0.200
     1.110     3.170     0.200
     1.748     1.960     0.200
     2.419    -1.301     0.200
     2.665    -2.598     0.200
     2.592    -4.803     0.200
     0.562     1.804     0.200
     1.713    -0.693     0.200
     0.946     2.471     0.200
     1.051     2.143     0.200
     1.402     2.028     0.200
     1.735    -1.539     0.200
     1.855    -1.341     0.200
     2.064    -2.968     0.200
     0.766     3.327     0.200
     0.855     1.505     0.200
     1.155     0.995     0.200
     1.352     0.766     0.200
     1.455     0.487     0.200
     1.656     0.122     0.200
     2.121    -3.619     0.200
     0.804     3.424     0.200
     1.049     1.658     0.200
     1.506     2.162     0.200
     2.181    -2.235     0.200
     0.842     1.347     0.200
     0.976     0.608     0.200
     1.280     0.957     0.200
     1.757    -1.645     0.200
     2.036    -2.996     0.200
     0.313     4.622     0.200
     0.815     1.696     0.200
     0.947     1.514     0.200
     1.082     0.221     0.200
     1.263     0.493     0.200
     0.765     1.762     0.200
     0.771     3.076     0.200
     0.996     1.453     0.200
     1.529    -0.438     0.200
     0.843     2.149     0.200
     0.926     2.729     0.200
     1.337     2.485     0.200
     1.643    -0.193     0.200
     1.966    -0.432     0.200
     2.091    -2.424     0.200
     2.412    -5.589     0.200
     0.104     2.289     0.200
     0.866     4.121     0.200
     1.036     3.716     0.200
     1.918    -0.725     0.200
     0.926     3.165     0.200
     1.332     1.109     0.200
     1.625    -0.183     0.200
     4.099    -7.614     0.200
     4.657    -9.302     0.200
     7.055   -17.175     0.200
     1.064     0.895     0.200
     2.933    -7.177     0.200
     0.212     2.813     0.200
     0.569     2.505     0.200
     1.053     3.137     0.200
     1.485     1.472     0.200
     2.414    -4.984     0.200
     0.117     4.616     0.200
     1.987    -3.171     0.200
     0.345     0.656     0.200
     0.603     3.472     0.200
     1.008     3.621     0.200
     0.977     1.701     0.200
     0.471     3.926     0.200
     1.088     0.382     0.200
     1.290    -1.040     0.200
     1.639    -0.139     0.200
     2.254    -5.416     0.200
     2.404    -4.243     0.200
     2.409    -4.396     0.200
     2.417    -4.485     0.200
     3.429   -11.444     0.200
     0.599     1.693     0.200
     0.599     2.193     0.200
     1.028     4.612     0.200
     1.232     3.637     0.200
     0.148     0.251     0.200
     0.305     2.269     0.200
     0.970     2.178     0.200
     1.284     1.228     0.200
     1.643     0.918     0.200
     1.868    -0.298     0.200
     0.775     1.997     0.200
     0.964     1.008     0.200
     1.270     0.306     0.200
     2.327    -5.197     0.200
     0.553     1.174     0.200
     0.537     1.686     0.200
     1.181     2.268     0.200
     1.439     1.084     0.200
     1.657     0.186     0.200
     1.807    -0.563     0.200
     2.099    -0.639     0.200
     0.258     3.541     0.200
     0.757     3.730     0.200
     1.197    -0.716     0.200
     1.404    -0.763     0.200
     1.633    -0.044     0.200
     1.820    -0.955     0.200
     1.773    -0.465     0.200
     2.010    -3.993     0.200
     2.119    -3.441     0.200
     0.285     3.447     0.200
     1.537    -0.263     0.200
     1.530     1.952     0.200
     1.701    -1.455     0.200
     1.600     0.332     0.200
     1.667     0.830     0.200
     1.979    -0.276     0.200
     0.286     2.216     0.200
     0.518     2.382     0.200
     1.541     0.950     0.200
     1.553     1.567     0.200
     0.464     3.089     0.200
     0.581     2.406     0.200
     1.087     2.852     0.200
     1.240     3.019     0.200
     1.342     2.772     0.200
     0.250     2.062     0.200
     0.447     2.835     0.200
     0.714     1.359     0.200
     1.247     0.471     0.200
     1.471     0.353     0.200
     0.937     2.900     0.200
     1.336     2.260     0.200
     0.610     0.251     0.200
     0.610     1.251     0.200
     0.554     2.029     0.200
     0.554     3.029     0.200
     1.537     2.858     0.200
     1.630     0.928     0.200
     0.672     3.764     0.200
     0.807     1.477     0.200
     1.020     1.721     0.200
     1.152     0.554     0.200
     1.503    -0.564     0.200
     1.642    -0.996     0.200
     2.153    -4.174     0.200
     0.233     1.226     0.200
     0.368     2.963     0.200
     0.308     2.982     0.200
     0.636     1.590     0.200
     0.917     2.683     0.200
     1.254     0.506     0.200
     0.844     2.755     0.200
     1.427     1.769     0.200
     0.779     2.865     0.200
     0.858     1.362     0.200
     1.045    -0.568     0.200
     1.435     1.082     0.200
     1.914    -1.099     0.200
     2.233    -4.235     0.200
     0.301     1.000     0.200
     0.396     2.972     0.200
     1.135     2.547     0.200
     0.201     2.237     0.200
     0.832     3.229     0.200
     0.695     4.172     0.200
     0.968     2.508     0.200
     0.432     2.832     0.200
     0.862     3.196     0.200
     0.753     0.642     0.200
     1.117     3.115     0.200
     0.289     1.758     0.200
     0.497     2.657     0.200
     1.332     0.692     0.200
     1.534     0.786     0.200
     0.668     2.254     0.200
     0.876     1.659     0.200
     0.967     1.777     0.200
     0.621     2.612     0.200
     0.970     2.543     0.200
     1.663    -0.437     0.200
     0.666     3.549     0.200
     1.734     0.723     0.200
     1.996    -1.586     0.200
     0.457     2.517     0.200
     0.580     3.611     0.200
     1.545     1.010     0.200
     1.386     1.067     0.200
     0.301     2.736     0.200
     0.518     2.873     0.200
     0.654     2.564     0.200
     1.219     1.650     0.200
     1.193     1.474     0.200
     1.211     1.891     0.200
     0.550     1.681     0.200
     1.100     1.251     0.200
     1.516     0.111     0.200
     1.482     1.119     0.200
     1.294     1.373     0.200
     1.721    -0.162     0.200
     1.918    -1.408     0.200
     0.276     2.136     0.200
     0.329     1.447     0.200
     1.588     0.544     0.200
     1.774    -1.362     0.200
     0.662     3.128     0.200
     1.375    -0.501     0.200
     1.671    -0.870     0.200
     1.768     0.050     0.200
     2.336    -4.444     0.200
     0.103     6.881     0.200
     0.589     2.491     0.200
     1.702    -2.785     0.200
     0.459     3.706     0.200
     2.354    -3.354     0.200
     0.605     1.695     0.200
     0.640     2.574     0.200
     0.932     1.333     0.200
     0.968     2.167     0.200
     1.017     2.642     0.200
     1.641    -0.144     0.200
     0.244     2.985     0.200
     1.359     0.639     0.200
     1.578    -1.300     0.200
     0.276     1.361     0.200
     1.664     0.351     0.200
     1.992    -1.033     0.200
     1.442    -0.830     0.200
     1.446    -0.934     0.200
     1.451    -1.105     0.200
     1.443     1.750     0.200
     2.275    -2.632     0.200
     0.595     3.339     0.200
     1.043     2.131     0.200
     1.169     2.610     0.200
     1.233     2.123     0.200
     1.295     2.149     0.200
     1.995    -1.032     0.200
     0.671     1.698     0.200
     0.491     3.077     0.200
     0.556     2.304     0.200
     1.449     2.006     0.200
     0.470     3.629     0.200
     0.784     3.677     0.200
     1.335     0.193     0.200
     0.295     2.079     0.200
     0.535     3.738     0.200
     0.589     3.035     0.200
     0.589     2.035     0.200
     1.348     0.858     0.200
     1.509    -0.144     0.200
     1.868    -2.501     0.200
     2.144    -3.272     0.200
     0.627     2.251     0.200
     0.669     2.900     0.200
     1.169     4.050     0.200
     1.161     3.312     0.200
     1.455     1.984     0.200
     2.000    -1.283     0.200
     0.457     2.004     0.200
     0.645     3.063     0.200
     0.789     2.496     0.200
     0.976     1.557     0.200
     0.542     1.652     0.200
     0.915     1.830     0.200
     0.483     2.186     0.200
     0.587     2.874     0.200
     0.336     2.153     0.200
     0.641     1.456     0.200
     1.117     0.369     0.200
     1.293     0.812     0.200
     1.605    -1.094     0.200
     1.380     0.824     0.200
     1.820    -0.110     0.200
     0.321     1.544     0.200
     1.021     3.341     0.200
     0.253     3.311     0.200
     0.552     1.815     0.200
     0.391     1.487     0.200
     1.783    -0.622     0.200
     0.380     1.491     0.200
     1.179     5.059     0.200
     1.797     2.555     0.200
     0.812     2.295     0.200
     0.425     1.828     0.200
     0.633     3.238     0.200
     1.201     0.213     0.200
     1.388     0.189     0.200
     1.683    -0.721     0.200
     0.234     0.727     0.200
     1.795    -0.052     0.200
     0.083     4.334     0.200
     1.378     0.476     0.200
     1.378     1.151     0.200
     2.213    -3.926     0.200
     2.217    -4.033     0.200
     2.224    -2.960     0.200
     2.224    -5.060     0.200
     0.937     1.824     0.200
     1.474     0.917     0.200
     2.065    -2.884     0.200
     2.069    -2.980     0.200
     1.079     2.120     0.200
     0.523     2.673     0.200
     0.671     3.543     0.200
     1.884    -0.823     0.200
     1.884     0.505     0.200
     2.081    -0.335     0.200
     0.883     3.510     0.200
     1.504     2.276     0.200
     1.838     0.012     0.200
     1.990    -0.794     0.200
     3.107    -4.106     0.200
     3.640    -9.805     0.200
     0.307     2.488     0.200
     0.451     1.189     0.200
     1.942    -1.701     0.200
     2.974    -3.730     0.200
     0.336     4.064     0.200
     2.177    -4.039     0.200
     2.428    -5.190     0.200
     2.487    -4.007     0.200
     3.224    -9.384     0.200
     3.500    -8.963     0.200
     0.254     1.954     0.200
     0.444     2.497     0.200
     0.471     1.894     0.200
     0.582     2.341     0.200
     1.343     0.947     0.200
     1.727    -0.312     0.200
     1.847    -0.697     0.200
     1.963    -1.275     0.200
     2.586    -4.711     0.200
     2.676    -4.820     0.200
     3.289    -9.148     0.200
     3.390    -8.768     0.200
     0.234     2.264     0.200
     0.417     1.923     0.200
     0.486     1.587     0.200
     0.594     1.948     0.200
     1.670     1.315     0.200
     1.588     1.675     0.200
     1.992    -0.127     0.200
     1.992    -0.709     0.200
     1.981     0.325     0.200
     0.479     1.816     0.200
     0.933     1.895     0.200
     1.531    -0.443     0.200
     1.525     0.487     0.200
     1.557     0.567     0.200
     1.530     1.413     0.200
     1.684     2.672     0.200
     0.607     1.032     0.200
     2.040     0.141     0.200
     0.587     1.075     0.200
     1.299     1.386     0.200
     1.299     1.011     0.200
     1.839    -1.360     0.200
     1.839     2.492     0.200
     0.321     2.723     0.200
     0.584     1.117     0.200
     1.641     0.947     0.200
     2.368    -2.432     0.200
     3.518    -5.694     0.200
     3.758    -7.481     0.200
     0.835     1.574     0.200
     0.754     2.771     0.200
     1.495    -1.571     0.200
     1.477     0.144     0.200
     1.388     2.891     0.200
     1.762     0.318     0.200
     1.898    -3.680     0.200
     1.898    -3.152     0.200
     2.043    -2.722     0.200
     2.582    -4.381     0.200
     3.589   -10.492     0.200
     0.994     2.964     0.200
     1.045     0.836     0.200
     1.291     2.697     0.200
     1.484     4.088     0.200
     1.599     2.250     0.200
     2.052    -0.613     0.200
     2.450    -2.386     0.200
     0.662     3.567     0.200
     0.661     2.915     0.200
     0.728     4.117     0.200
     0.782     2.711     0.200
     1.110     2.411     0.200
     1.503     1.228     0.200
     1.365     2.666     0.200
     2.167    -0.385     0.200
     2.487    -1.610     0.200
     2.470    -4.551     0.200
     2.683    -2.535     0.200
     2.855    -4.373     0.200
     3.243    -7.767     0.200
     3.408    -7.420     0.200
     3.462    -8.791     0.200
     1.170     2.453     0.200
     1.509    -0.629     0.200
     2.733    -5.359     0.200
     2.801    -6.450     0.200
     3.262    -7.500     0.200
     3.304    -8.858     0.200
     3.801   -11.742     0.200
     0.352     0.601     0.200
     0.927     1.473     0.200
     1.532     2.360     0.200
     1.630     3.571     0.200
     2.205    -0.986     0.200
     2.352     1.121     0.200
     0.084     2.509     0.200
     0.641     2.463     0.200
     1.383     1.610     0.200
     1.815    -1.648     0.200
     2.416    -1.815     0.200
     2.575    -2.042     0.200
     2.599    -2.411     0.200
     0.191     1.858     0.200
     1.504     0.620     0.200
     1.634     1.143     0.200
     1.855     0.109     0.200
     1.924    -0.447     0.200
     2.053     0.119     0.200
     0.476     2.346     0.200
     0.807     1.837     0.200
     1.050     3.551     0.200
     2.032    -1.602     0.200
     2.537    -3.527     0.200
     3.136    -3.570     0.200
     0.542     2.952     0.200
     0.730     2.218     0.200
     0.819     1.675     0.200
     1.008     1.116     0.200
     1.144     2.594     0.200
     1.536     2.300     0.200
     1.710     0.574     0.200
     1.768    -0.141     0.200
     1.779    -0.788     0.200
     1.758     0.682     0.200
     2.838    -3.024     0.200
     3.566    -8.682     0.200
     3.764    -6.158     0.200
     0.768     2.758     0.200
     1.403     3.965     0.200
     1.838    -0.268     0.200
     2.017    -0.498     0.200
     2.556    -3.013     0.200
     2.814    -3.557     0.200
     3.712    -4.604     0.200
     0.504     2.814     0.200
     0.742     2.718     0.200
     1.763    -1.723     0.200
     1.841    -2.689     0.200
     0.559     2.741     0.200
     0.769     2.564     0.200
     1.074     1.463     0.200
     1.617    -0.872     0.200
     1.674    -0.903     0.200
     1.895    -1.675     0.200
     1.947    -4.617     0.200
     2.529    -5.288     0.200
     3.283    -5.868     0.200
     3.411    -9.031     0.200
     5.128   -12.839     0.200
     0.589     1.649     0.200
     0.934     2.942     0.200
     2.097    -1.817     0.200
     0.354     0.468     0.200
     0.566     1.571     0.200
     1.256     2.353     0.200
     1.750    -0.298     0.200
     1.999    -1.212     0.200
     2.351    -1.282     0.200
     2.444    -2.463     0.200
     2.639    -3.154     0.200
     2.982    -2.887     0.200
     0.111     3.711     0.200
     0.315     2.473     0.200
     0.446     1.845     0.200
     1.168    -0.341     0.200
     1.690     0.134     0.200
     2.461    -2.043     0.200
     2.601    -4.955     0.200
     0.804     2.064     0.200
     1.094     0.252     0.200
     1.220    -0.162     0.200
     2.090    -3.263     0.200
     1.548     2.357     0.200
     1.691     1.201     0.200
     1.795     0.123     0.200
     0.631     3.145     0.200
     0.993     1.730     0.200
     2.710    -6.500     0.200
     2.989    -7.332     0.200
     0.669     3.321     0.200
     2.806    -3.522     0.200
     3.125    -5.138     0.200
     0.334     1.092     0.200
     0.916     2.539     0.200
     0.991     3.437     0.200
     1.807     0.454     0.200
     2.915    -6.028     0.200
     0.273     1.867     0.200
     0.898     3.341     0.200
     1.920     0.814     0.200
     0.618     2.522     0.200
     1.251     0.415     0.200
     1.373    -0.081     0.200
     1.949    -4.108     0.200
     2.174    -0.534     0.200
     2.974    -4.050     0.200
     3.082    -8.331     0.200
     0.339     2.269     0.200
     1.517     1.487     0.200
     1.638    -0.872     0.200
     1.904    -1.307     0.200
     2.031     0.875     0.200
     2.194    -3.056     0.200
     2.287    -3.017     0.200
     2.505    -5.723     0.200
     2.679    -4.569     0.200
     2.738    -5.691     0.200
     3.117    -9.852     0.200
     0.584     1.564     0.200
     0.760     3.503     0.200
     1.490     2.741     0.200
     1.796     0.185     0.200
     2.868    -3.011     0.200
     3.017    -5.642     0.200
     3.529    -7.248     0.200
     4.084   -10.977     0.200
     0.412     1.896     0.200
     0.542     1.889     0.200
     0.791     1.410     0.200
     1.858    -2.340     0.200
     1.749    -1.499     0.200
     1.975    -1.262     0.200
     2.144    -0.706     0.200
     2.186    -2.647     0.200
     2.420    -2.676     0.200
     2.696    -7.285     0.200
     2.851    -7.451     0.200
     1.146     4.013     0.200
     1.219     3.506     0.200
     1.396     2.434     0.200
     1.559     1.991     0.200
     1.744     1.609     0.200
     1.772     2.203     0.200
     1.978     0.498     0.200
     2.050    -0.246     0.200
     2.752    -3.986     0.200
     3.230    -6.521     0.200
     0.363     4.331     0.200
     1.125     1.114     0.200
     0.966     0.595     0.200
     1.139     1.488     0.200
     1.407    -0.843     0.200
     1.638    -1.183     0.200
     1.580     0.666     0.200
     2.025    -2.212     0.200
     5.668   -17.000     0.200
     0.875     2.643     0.200
     1.018     2.031     0.200
     1.003     1.487     0.200
     1.003     1.354     0.200
     1.449     1.392     0.200
     2.133    -0.424     0.200
     2.141     0.115     0.200
     2.291    -2.685     0.200
     3.342    -8.953     0.200
     0.284     3.942     0.200
     0.434     3.926     0.200
     0.605     1.641     0.200
     1.003    -0.444     0.200
     1.076     1.850     0.200
     1.396     0.393     0.200
     1.324     0.747     0.200
     0.183     3.423     0.200
     0.857     2.270     0.200
     1.110     0.301     0.200
     1.079     1.154     0.200
     1.681    -1.325     0.200
     1.757     0.016     0.200
     1.866     0.198     0.200
     2.278    -2.377     0.200
     0.384     0.957     0.200
     0.524     1.058     0.200
     0.604     1.142     0.200
     1.690     1.855     0.200
     2.021     0.578     0.200
     2.713    -3.073     0.200
     2.949    -6.084     0.200
     0.103     3.778     0.200
     0.492     1.270     0.200
     1.371     1.478     0.200
     1.611     0.449     0.200
     1.602     2.248     0.200
     1.744    -0.209     0.200
     1.816    -1.810     0.200
     1.904    -1.487     0.200
     2.174    -1.176     0.200
     2.189    -3.604     0.200
     2.372    -2.609     0.200
     2.458    -2.861     0.200
     2.774    -2.960     0.200
     2.967    -6.231     0.200
     3.044    -5.695     0.200
     3.347    -4.645     0.200
     0.938     2.488     0.200
     1.022     4.580     0.200
     1.572     2.176     0.200
     2.195    -1.264     0.200
     2.350    -0.127     0.200
     2.816    -3.776     0.200
     2.772    -2.629     0.200
     0.096     3.505     0.200
     0.202     2.920     0.200
     1.364     1.838     0.200
     1.822    -1.341     0.200
     1.903     0.236     0.200
     2.196    -3.756     0.200
     2.373    -2.224     0.200
     2.451    -1.826     0.200
     2.459    -2.160     0.200
     2.459    -2.968     0.200
     2.777    -4.121     0.200
     0.448     2.925     0.200
     0.615     2.303     0.200
     0.716     1.577     0.200
     1.444     0.237     0.200
     1.357     1.192     0.200
     1.595     1.145     0.200
     1.671    -0.495     0.200
     2.135    -3.538     0.200
     2.733    -6.757     0.200
     2.994    -6.198     0.200
     0.474     2.414     0.200
     1.560     1.195     0.200
     1.637     2.049     0.200
     1.901     0.573     0.200
     2.082    -1.170     0.200
     2.139    -2.046     0.200
     2.692    -2.581     0.200
     2.760    -5.045     0.200
     3.011    -3.895     0.200
     3.373    -9.753     0.200
     3.421    -9.156     0.200
     0.495     2.099     0.200
     0.664     3.185     0.200
     0.751     1.078     0.200
     1.328     2.747     0.200
     1.544     1.790     0.200
     1.881     1.227     0.200
     2.087    -2.334     0.200
     2.087    -0.870     0.200
     2.188    -1.669     0.200
     2.167    -0.411     0.200
     2.334    -3.614     0.200
     2.479    -4.651     0.200
     2.780    -5.611     0.200
     3.030    -4.021     0.200
     0.667     3.405     0.200
     1.493     2.381     0.200
     1.719    -0.787     0.200
     1.847    -0.368     0.200
     2.151    -2.193     0.200
     2.165     1.897     0.200
     2.184    -1.309     0.200
     0.776     3.359     0.200
     0.834     2.266     0.200
     0.874     3.876     0.200
     1.374     1.601     0.200
     1.610     2.420     0.200
     1.713     2.966     0.200
     1.796     1.838     0.200
     1.963     2.484     0.200
     2.283    -1.601     0.200
     0.802     4.120     0.200
     0.863     2.718     0.200
     0.943     3.117     0.200
     1.770     3.664     0.200
     1.730     4.114     0.200
     1.938     2.482     0.200
     1.910     2.408     0.200
     3.147    -6.892     0.200
     0.336     1.026     0.200
     0.557     3.453     0.200
     0.840     3.233     0.200
     1.033     1.559     0.200
     1.185     1.258     0.200
     2.351    -2.755     0.200
     2.364    -2.378     0.200
     2.515    -3.191     0.200
     2.958    -6.588     0.200
     3.717    -5.897     0.200
     0.356     1.568     0.200
     0.551     4.132     0.200
     0.638     1.195     0.200
     0.787     4.590     0.200
     1.623     1.907     0.200
     1.657     2.754     0.200
     1.683     2.744     0.200
     1.821     1.519     0.200
     2.106     0.376     0.200
     2.278    -0.310     0.200
     2.219    -0.902     0.200
     2.303    -1.204     0.200
     2.810    -4.503     0.200
     3.465    -7.884     0.200
     3.524    -8.422     0.200
     4.334   -11.511     0.200
     0.126     6.257     0.200
     0.397     3.485     0.200
     0.521     3.410     0.200
     0.564     2.445     0.200
     2.651    -5.131     0.200
     2.408    -2.797     0.200
     0.867     2.724     0.200
     0.851     3.945     0.200
     1.496     2.386     0.200
     1.566     1.654     0.200
     2.312     1.620     0.200
     2.414     1.900     0.200
     2.906    -2.905     0.200
     3.188    -4.589     0.200
     3.221    -5.625     0.200
     0.620     2.030     0.200
     1.181    -0.205     0.200
     1.814    -2.803     0.200
     1.827    -4.091     0.200
     1.817    -1.469     0.200
     2.011    -2.513     0.200
     2.157    -5.659     0.200
     2.188    -4.374     0.200
     2.468    -6.370     0.200
     0.451     2.638     0.200
     0.603     2.057     0.200
     0.636     2.027     0.200
     1.215     1.168     0.200
     1.713     1.266     0.200
     1.750    -1.972     0.200
     1.760    -0.226     0.200
     1.839    -0.895     0.200
     1.900    -3.345     0.200
     2.041    -0.766     0.200
     2.203    -1.215     0.200
     2.188    -4.127     0.200
     2.259    -3.777     0.200
     2.788    -5.676     0.200
     0.210     1.681     0.200
     0.460     2.578     0.200
     0.634     1.151     0.200
     0.695     1.795     0.200
     1.355     0.960     0.200
     1.429     0.030     0.200
     1.574     0.443     0.200
     1.652     0.139     0.200
     2.474    -4.297     0.200
     2.999    -4.107     0.200
     3.364   -10.080     0.200
     0.631     2.612     0.200
     0.818     1.367     0.200
     1.288     0.415     0.200
     1.285     1.781     0.200
     1.412     0.322     0.200
     1.912    -1.896     0.200
     2.044    -1.888     0.200
     2.040    -0.867     0.200
     2.146    -1.708     0.200
     2.253    -2.632     0.200
     2.677    -8.059     0.200
     2.854    -6.633     0.200
     2.910    -9.162     0.200
     0.898     2.486     0.200
     1.350     2.088     0.200
     1.497     1.745     0.200
     1.552     0.127     0.200
     1.693     1.495     0.200
     0.910     3.698     0.200
     1.764     0.770     0.200
     1.884     1.367     0.200
     2.893    -4.882     0.200
     3.173    -3.640     0.200
     0.156     2.327     0.200
     0.507     1.463     0.200
     1.659     0.369     0.200
     1.825     0.110     0.200
     1.872     1.233     0.200
     0.873     3.733     0.200
     0.916     2.922     0.200
     1.446     2.554     0.200
     1.497     0.955     0.200
     1.834     0.743     0.200
     1.750     0.639     0.200
     1.766     0.828     0.200
     2.614    -3.200     0.200
     2.565    -3.533     0.200
     0.494     4.223     0.200
     0.681     2.302     0.200
     0.888     2.536     0.200
     0.907     2.216     0.200
     1.497    -0.789     0.200
     1.555     0.302     0.200
     1.721    -1.435     0.200
     1.858    -2.632     0.200
     0.170     3.023     0.200
     0.675     2.924     0.200
     1.812    -0.625     0.200
     2.109    -1.057     0.200
     3.405    -4.649     0.200
     0.632     1.724     0.200
     0.720     1.397     0.200
     1.930     1.667     0.200
     2.167    -1.922     0.200
     2.733    -3.216     0.200
     0.801     2.716     0.200
     0.858     2.262     0.200
     0.994     3.476     0.200
     1.821     0.363     0.200
     2.151    -1.673     0.200
     2.588    -6.241     0.200
     0.825     3.018     0.200
     1.434     1.833     0.200
     1.521     0.112     0.200
     1.505     2.068     0.200
     1.531     1.445     0.200
     1.810    -0.597     0.200
     1.810     0.640     0.200
     1.810     0.058     0.200
     2.730    -4.933     0.200
     0.251     4.928     0.200
     0.687     0.900     0.200
     0.137     2.585     0.200
     1.783    -0.246     0.200
     0.488     1.055     0.200
     0.579     2.053     0.200
     1.643    -1.221     0.200
     1.833    -0.268     0.200
     0.802     3.979     0.200
     0.885     2.157     0.200
     0.973     2.826     0.200
     1.300     1.983     0.200
     1.176     3.402     0.200
     1.427     3.859     0.200
     1.701     1.978     0.200
     1.643     0.778     0.200
     1.778     0.222     0.200
     1.882     1.628     0.200
     2.231    -0.857     0.200
     0.662     2.087     0.200
     0.986     1.639     0.200
     1.443     1.742     0.200
     1.353     0.410     0.200
     1.397     0.826     0.200
     2.183    -3.617     0.200
     2.110    -2.087     0.200
     0.726     1.341     0.200
     0.914     3.123     0.200
     1.044     1.573     0.200
     1.457     0.775     0.200
     1.983     2.209     0.200
     2.214    -0.594     0.200
     2.848    -4.203     0.200
     0.552     3.233     0.200
     0.831     1.962     0.200
     1.180     3.286     0.200
     1.186     1.177     0.200
     1.250     2.554     0.200
     1.533     2.406     0.200
     0.772     2.330     0.200
     0.584     2.303     0.200
     0.702     2.329     0.200
     1.727    -0.887     0.200
     2.311    -1.224     0.200
     2.003    -2.770     0.200
     2.724    -4.033     0.200
     2.855    -7.253     0.200
     3.598   -10.232     0.200
     0.705     2.151     0.200
     0.701     1.311     0.200
     0.876     3.933     0.200
     1.040     3.743     0.200
     1.353     0.536     0.200
     2.822    -5.007     0.200
     3.064    -3.875     0.200
     0.608     2.591     0.200
     0.955     2.608     0.200
     1.420    -2.225     0.200
     1.239     1.216     0.200
     1.407    -0.124     0.200
     1.959    -2.555     0.200
     2.173    -4.975     0.200
     2.743    -6.431     0.200
     2.962    -8.352     0.200
     3.234    -9.412     0.200
     4.143   -12.800     0.200
     0.675     1.810     0.200
     0.753     2.521     0.200
     1.070     2.851     0.200
     0.856     3.099     0.200
     1.880    -2.081     0.200
     1.686     2.387     0.200
     1.937     1.683     0.200
     2.106    -1.585     0.200
     0.563     2.943     0.200
     0.727     3.257     0.200
     0.841     1.599     0.200
     1.125    -0.422     0.200
     1.142    -0.339     0.200
     1.392     1.373     0.200
     1.620    -0.305     0.200
     1.749     0.184     0.200
     1.951    -0.959     0.200
     1.939    -1.442     0.200
     2.063    -1.921     0.200
     2.296    -4.126     0.200
     2.382    -3.687     0.200
     3.026    -7.077     0.200
     0.519     3.078     0.200
     0.696     2.567     0.200
     0.918     1.862     0.200
     1.352     1.632     0.200
     1.259     1.182     0.200
     1.443     2.294     0.200
     1.520    -0.047     0.200
     1.678    -2.005     0.200
     2.442    -4.433     0.200
     0.865     2.710     0.200
     0.915     3.279     0.200
     0.991     4.200     0.200
     1.788     1.552     0.200
     1.923    -1.720     0.200
     3.708    -8.880     0.200
     0.570     4.029     0.200
     0.815     2.727     0.200
     1.364     0.543     0.200
     1.412     1.074     0.200
     1.686    -2.024     0.200
     1.764     1.058     0.200
     1.831     0.708     0.200
     1.939    -3.040     0.200
     0.920     3.343     0.200
     1.386     0.022     0.200
     1.906     2.040     0.200
     0.944     2.246     0.200
     1.034     3.227     0.200
     1.121     3.535     0.200
     1.636     2.256     0.200
     1.636     0.836     0.200
     1.758     2.948     0.200
     2.082    -1.137     0.200
     0.769     3.869     0.200
     0.769     3.572     0.200
     1.443     1.523     0.200
     1.851    -1.566     0.200
     1.892     0.233     0.200
     2.069    -0.615     0.200
     0.805     2.587     0.200
     0.925     2.172     0.200
     1.513     1.057     0.200
     1.874    -0.207     0.200
     1.861    -1.604     0.200
     2.013     0.751     0.200
     2.086    -1.125     0.200
     0.176     1.940     0.200
     0.675     1.800     0.200
     0.756     1.903     0.200
     1.822     3.131     0.200
     2.101    -3.232     0.200
     2.174    -3.531     0.200
     3.046    -5.302     0.200
     0.193     1.764     0.200
     0.953     2.479     0.200
     1.250     1.390     0.200
     0.940     4.564     0.200
     1.416     2.252     0.200
     1.503     1.218     0.200
     1.445     2.442     0.200
     1.693     0.443     0.200
     1.693     0.927     0.200
     1.705     1.732     0.200
     1.619     0.229     0.200
     1.758     0.383     0.200
     1.982    -0.237     0.200
     1.917    -1.489     0.200
     1.998    -0.472     0.200
     2.056    -0.368     0.200
     2.902    -5.571     0.200
     2.973    -3.794     0.200
     0.236     2.951     0.200
     0.746    -0.003     0.200
     0.746     2.043     0.200
     1.333     1.202     0.200
     1.467    -1.479     0.200
     1.528    -0.337     0.200
     1.659    -0.132     0.200
     2.022    -2.737     0.200
     2.323    -4.701     0.200
     2.570    -7.595     0.200
     0.463     2.587     0.200
     1.220    -1.044     0.200
     1.352    -1.245     0.200
     0.856     1.551     0.200
     1.130     1.008     0.200
     1.696     0.899     0.200
     1.759     2.888     0.200
     2.348    -3.447     0.200
     1.909    -0.172     0.200
     1.906    -4.036     0.200
     2.080    -2.814     0.200
     2.857    -8.397     0.200
     0.893     3.104     0.200
     1.270     1.055     0.200
     1.298     2.685     0.200
     1.321     3.454     0.200
     1.669     1.880     0.200
     1.757     3.953     0.200
     1.832     2.167     0.200
     1.905     1.228     0.200
     0.577     2.538     0.200
     1.113    -0.074     0.200
     1.383     0.340     0.200
     1.735    -0.558     0.200
     1.938    -4.616     0.200
     2.085    -2.364     0.200
     2.702    -6.796     0.200
     2.705    -7.046     0.200
     2.956    -7.779     0.200
     3.104    -8.026     0.200
     0.555     3.001     0.200
     0.756     1.984     0.200
     0.796     2.439     0.200
     0.845     1.896     0.200
     1.080     2.461     0.200
     1.596     0.167     0.200
     1.704     0.434     0.200
     1.895    -1.741     0.200
     1.973    -2.668     0.200
     1.975    -2.074     0.200
     2.024     0.450     0.200
     2.086    -1.530     0.200
     3.263    -6.541     0.200
     3.381    -7.116     0.200
     0.682     1.757     0.200
     0.618     2.296     0.200
     0.857     2.262     0.200
     0.973     1.676     0.200
     1.170    -0.360     0.200
     1.261     0.660     0.200
     1.339     1.472     0.200
     1.386     1.149     0.200
     1.470     2.704     0.200
     0.324     2.432     0.200
     0.937     1.149     0.200
     1.492    -1.885     0.200
     1.560    -1.908     0.200
     2.196    -3.648     0.200
     2.208    -4.132     0.200
     2.318    -2.293     0.200
     2.420    -3.761     0.200
     0.226     3.165     0.200
     1.360    -1.249     0.200
     1.467    -0.060     0.200
     1.598    -0.426     0.200
     2.414    -4.938     0.200
     0.264     2.625     0.200
     0.871     0.939     0.200
     0.871     1.232     0.200
     1.321    -0.273     0.200
     1.425     0.956     0.200
     1.556    -1.236     0.200
     1.630    -0.706     0.200
     2.414    -3.497     0.200
     2.446    -6.009     0.200
     2.491    -2.405     0.200
     0.724     2.908     0.200
     0.807     3.813     0.200
     1.084     1.759     0.200
     1.379     0.113     0.200
     1.489     0.643     0.200
     1.634     1.498     0.200
     1.825    -2.105     0.200
     1.825    -1.581     0.200
     1.902    -1.830     0.200
     2.045    -1.747     0.200
     2.441    -3.906     0.200
     0.513     1.568     0.200
     0.434     1.998     0.200
     0.705     1.673     0.200
     1.115     2.117     0.200
     1.381     1.724     0.200
     1.813    -1.895     0.200
     0.496     2.067     0.200
     0.516     1.849     0.200
     1.052     2.548     0.200
     1.330    -0.376     0.200
     1.510     2.207     0.200
     1.687     1.416     0.200
     1.795     0.940     0.200
     2.328    -3.169     0.200
     0.604     2.537     0.200
     0.879     3.600     0.200
     1.423     1.802     0.200
     1.424     1.767     0.200
     1.771    -0.110     0.200
     0.719     1.518     0.200
     0.825    -0.408     0.200
     0.942     0.680     0.200
     1.233    -1.385     0.200
     1.233    -0.877     0.200
     1.282     0.428     0.200
     1.259    -0.504     0.200
     1.387     0.496     0.200
     1.963    -1.434     0.200
     0.803     2.156     0.200
     1.037     1.891     0.200
     1.439     1.326     0.200
     1.520     0.948     0.200
     1.515    -0.797     0.200
     1.551     1.189     0.200
     1.545     1.952     0.200
     1.698    -1.466     0.200
     1.069     1.105     0.200
     1.127     2.084     0.200
     1.158     2.290     0.200
     1.451    -0.038     0.200
     1.628     0.585     0.200
     0.368     1.296     0.200
     1.314     0.712     0.200
     1.646    -0.272     0.200
     1.740    -0.103     0.200
     1.903    -0.599     0.200
     2.459    -3.542     0.200
     0.212     1.000     0.200
     0.972     3.258     0.200
     0.995     2.733     0.200
     1.062     0.823     0.200
     1.100     1.486     0.200
     1.291     1.290     0.200
     1.422     1.693     0.200
     1.565    -0.262     0.200
     2.019    -1.330     0.200
     2.291    -3.324     0.200
     2.427    -3.091     0.200
     0.336     1.505     0.200
     0.416     1.756     0.200
     0.679     2.390     0.200
     0.841     2.666     0.200
     1.134     1.065     0.200
     1.087     1.886     0.200
     1.735     1.274     0.200
     2.528    -2.984     0.200
     2.521    -3.840     0.200
     2.609    -3.659     0.200
     2.696    -4.389     0.200
     2.778    -5.049     0.200
     2.822    -6.356     0.200
     2.940    -6.611     0.200
     3.031    -7.892     0.200
     0.735     2.153     0.200
     1.531    -0.681     0.200
     1.531    -0.525     0.200
     1.669     1.927     0.200
     1.943    -0.826     0.200
     2.341     0.029     0.200
     2.600    -4.027     0.200
     3.197    -6.765     0.200
     0.698     3.469     0.200
     0.957     1.745     0.200
     1.110     2.371     0.200
     1.114     2.175     0.200
     1.327    -0.058     0.200
     1.413     3.130     0.200
     1.654     1.421     0.200
     1.676     0.347     0.200
     1.832    -0.501     0.200
     2.207    -1.102     0.200
     0.735     2.204     0.200
     0.727     2.423     0.200
     1.108     1.542     0.200
     1.865     2.387     0.200
     2.152    -1.797     0.200
     2.233    -1.262     0.200
     2.495    -2.245     0.200
     3.482    -7.503     0.200
     0.700     0.247     0.200
     1.133     3.368     0.200
     1.467     3.810     0.200
     0.587     2.756     0.200
     0.896     3.222     0.200
     1.130     3.447     0.200
     1.146     2.564     0.200
     1.422     2.613     0.200
     1.653     0.989     0.200
     1.738     2.232     0.200
     2.358    -2.410     0.200
     2.369    -3.415     0.200
     0.712     3.260     0.200
     1.537     1.402     0.200
     2.342     0.184     0.200
     2.333    -2.838     0.200
     2.333    -3.123     0.200
     2.865    -4.974     0.200
     3.200    -8.091     0.200
     0.845     0.107     0.200
     1.348     0.293     0.200
     1.440     1.735     0.200
     1.406     1.967     0.200
     1.848    -1.219     0.200
     2.184    -3.249     0.200
     2.174     0.019     0.200
     2.694    -4.814     0.200
     2.914    -5.697     0.200
     0.331     4.025     0.200
     1.052    -0.017     0.200
     1.375    -0.470     0.200
     1.507    -1.529     0.200
     0.321     3.797     0.200
     0.984     1.700     0.200
     1.241     0.001     0.200
     1.360    -1.721     0.200
     1.306    -1.205     0.200
     1.400    -1.417     0.200
     1.532    -2.387     0.200
     1.974    -2.977     0.200
     0.477     2.509     0.200
     0.595     2.572     0.200
     0.735     2.105     0.200
     0.966     1.344     0.200
     1.135     2.979     0.200
     1.828     0.977     0.200
     2.303    -0.033     0.200
     2.200     0.812     0.200
     2.247    -0.303     0.200
     0.312     1.737     0.200
     1.377     1.225     0.200
     1.557     1.569     0.200
     1.509     0.703     0.200
     1.958    -1.772     0.200
     0.529     2.101     0.200
     0.914    -0.231     0.200
     0.934     1.673     0.200
     1.112     1.437     0.200
     1.283     1.159     0.200
     1.833    -1.671     0.200
     1.918    -2.195     0.200
     2.227    -1.539     0.200
     2.337    -2.876     0.200
     2.524    -5.168     0.200
     3.472    -7.186     0.200
     0.745     0.906     0.200
     0.790     0.531     0.200
     1.323     2.633     0.200
     1.389     2.235     0.200
     1.462     0.718     0.200
     1.522    -0.937     0.200
     2.033    -0.212     0.200
     2.338    -4.207     0.200
     2.395    -3.705     0.200
     0.650     3.122     0.200
     0.647     2.233     0.200
     0.892     2.534     0.200
     0.994     3.348     0.200
     1.304    -0.976     0.200
     1.283     1.530     0.200
     1.409     1.079     0.200
     1.895     0.010     0.200
     2.018    -2.850     0.200
     0.549     2.738     0.200
     0.687     2.933     0.200
     0.795     3.478     0.200
     1.197     0.524     0.200
     1.221     0.755     0.200
     1.706    -0.720     0.200
     1.677     1.421     0.200
     1.889    -1.244     0.200
     1.999     0.928     0.200
     2.302    -2.287     0.200
     2.047     0.856     0.200
     0.552     3.444     0.200
     0.698     2.691     0.200
     0.808     1.881     0.200
     1.175     2.119     0.200
     1.224     0.858     0.200
     1.699     0.831     0.200
     1.984     1.876     0.200
     1.984     2.165     0.200
     2.053     1.583     0.200
     2.053     1.990     0.200
     2.299    -1.278     0.200
     0.661     2.600     0.200
     0.857     1.210     0.200
     0.861     1.168     0.200
     1.331     1.402     0.200
     1.255     0.836     0.200
     1.380     0.142     0.200
     2.078    -0.423     0.200
     2.218    -5.234     0.200
     2.133    -3.838     0.200
     0.555     3.218     0.200
     0.686     3.349     0.200
     0.793     1.306     0.200
     0.917     2.328     0.200
     1.079     3.893     0.200
     1.213     0.239     0.200
     1.213     1.841     0.200
     1.211     2.965     0.200
     1.662     0.758     0.200
     1.699     0.930     0.200
     1.721     1.387     0.200
     1.875    -1.274     0.200
     2.003     1.150     0.200
     2.003     0.810     0.200
     2.037     0.665     0.200
     2.037     0.778     0.200
     2.220    -0.710     0.200
     2.271    -1.100     0.200
     0.900     1.087     0.200
     0.900    -0.483     0.200
     0.977     1.440     0.200
     1.017     1.826     0.200
     1.425    -0.829     0.200
     1.646    -1.844     0.200
     1.687    -2.178     0.200
     1.796    -2.638     0.200
     2.515    -6.293     0.200
     2.508    -3.937     0.200
     2.691    -7.456     0.200
     2.872    -8.041     0.200
     1.006     2.485     0.200
     1.124     1.143     0.200
     1.692    -1.334     0.200
     1.799    -1.800     0.200
     2.551    -3.134     0.200
     0.393     1.678     0.200
     0.393     2.793     0.200
     0.524     3.459     0.200
     1.189     2.046     0.200
     0.382     1.661     0.200
     0.514     2.276     0.200
     1.201     1.369     0.200
     1.165     1.132     0.200
     1.177     1.091     0.200
     2.098    -1.646     0.200
     2.179    -1.571     0.200
     2.770    -3.499     0.200
     2.583    -4.749     0.200
     2.638    -4.689     0.200
     0.367     2.170     0.200
     0.499     2.026     0.200
     1.154     2.595     0.200
     1.169     1.354     0.200
     1.202     1.609     0.200
     2.171    -1.803     0.200
     2.583    -5.283     0.200
     2.754    -5.182     0.200
     2.778    -6.198     0.200
     3.100    -5.189     0.200
     0.376     1.839     0.200
     0.500     1.971     0.200
     1.191     1.460     0.200
     0.385     1.853     0.200
     0.517     1.423     0.200
     1.148     2.960     0.200
     1.157     2.388     0.200
     1.164     2.392     0.200
     1.223     0.554     0.200
     2.198    -1.777     0.200
     3.130    -3.460     0.200
     0.376     1.531     0.200
     0.506     2.168     0.200
     1.170     1.656     0.200
     1.190     0.895     0.200
     1.176     1.753     0.200
     2.067    -1.431     0.200
     2.183    -1.096     0.200
     2.145    -3.021     0.200
     2.145    -0.756     0.200
     2.610    -4.458     0.200
     3.093    -5.489     0.200
     0.369     2.125     0.200
     0.790     2.612     0.200
     1.164     0.617     0.200
     1.184     0.963     0.200
     1.179     1.007     0.200
     2.063    -2.218     0.200
     2.145     0.578     0.200
     2.612    -4.716     0.200
     2.607    -4.476     0.200
     2.646    -5.038     0.200
     2.672    -5.294     0.200
     2.748    -5.944     0.200
     1.179    -0.486     0.200
     1.293     0.549     0.200
     1.747    -2.361     0.200
     2.101    -4.680     0.200
     2.154    -4.082     0.200
     2.443    -6.521     0.200
     0.930     3.311     0.200
     0.843     3.194     0.200
     1.053     2.067     0.200
     1.469    -0.354     0.200
     1.434     2.952     0.200
     1.516     2.519     0.200
     1.542     2.526     0.200
     1.658     0.663     0.200
     0.225     2.717     0.200
     1.756     1.222     0.200
     1.485     2.797     0.200
     1.629     1.094     0.200
     1.565     3.107     0.200
     1.855     0.643     0.200
     1.985    -0.157     0.200
     1.333     0.619     0.200
     1.401    -0.448     0.200
     1.422     1.904     0.200
     1.505     0.770     0.200
     1.498     1.728     0.200
     1.623    -0.792     0.200
     1.574     1.037     0.200
     1.642    -0.237     0.200
     1.789    -1.273     0.200
     0.267     0.515     0.200
     0.999     3.325     0.200
     1.261     3.242     0.200
     1.496     3.155     0.200
     1.564     2.619     0.200
     1.855     1.570     0.200
     1.982    -0.357     0.200
     0.687     3.282     0.200
     0.790     3.546     0.200
     1.049     4.102     0.200
     1.197     2.630     0.200
     1.635     2.140     0.200
     1.718     2.374     0.200
     2.017     2.114     0.200
     2.009     1.909     0.200
     0.456     1.739     0.200
     0.578     2.639     0.200
     0.586     1.787     0.200
     0.815     2.405     0.200
     1.568    -0.384     0.200
     1.814     0.567     0.200
     1.814    -0.737     0.200
     1.768    -1.264     0.200
     1.969     0.425     0.200
     2.148    -0.905     0.200
     2.250    -0.599     0.200
     2.250    -0.013     0.200
     2.391    -2.703     0.200
     2.520    -3.539     0.200
     2.722    -4.331     0.200
     0.366     1.475     0.200
     0.498     1.370     0.200
     1.151     1.365     0.200
     1.166     0.961     0.200
     1.205     0.867     0.200
     1.717     1.986     0.200
     2.085    -1.522     0.200
     2.174    -2.598     0.200
     2.580    -4.678     0.200
     2.575    -3.623     0.200
     2.626    -4.359     0.200
     3.100    -5.905     0.200
     3.383    -8.199     0.200
     0.343     2.206     0.200
     0.470     2.249     0.200
     0.760     2.860     0.200
     1.153     1.580     0.200
     1.187     1.341     0.200
     1.154     1.434     0.200
     2.093    -2.902     0.200
     2.610    -4.834     0.200
     2.640    -5.354     0.200
     2.655    -4.892     0.200
     2.619    -6.524     0.200
     2.704    -4.813     0.200
     2.704    -6.533     0.200
     3.033    -5.018     0.200
     3.211    -8.300     0.200
     0.314     2.905     0.200
     0.439     2.989     0.200
     1.128     2.889     0.200
     1.021     3.956     0.200
     1.710    -0.154     0.200
     1.972    -1.610     0.200
     2.641    -3.409     0.200
     2.655    -6.040     0.200
     2.650    -3.415     0.200
     0.367     4.041     0.200
     0.617     0.733     0.200
     0.894     0.827     0.200
     0.893     1.481     0.200
     1.712    -0.511     0.200
     0.705     2.851     0.200
     0.780     3.917     0.200
     0.772     2.234     0.200
     1.122     1.261     0.200
     1.360     0.370     0.200
     1.613    -0.065     0.200
     1.705     0.763     0.200
     2.129     1.074     0.200
     2.462    -3.096     0.200
     0.379     4.301     0.200
     0.607     2.766     0.200
     0.890     2.426     0.200
     1.559    -0.997     0.200
     1.619     0.256     0.200
     1.709    -1.539     0.200
     1.725    -0.670     0.200
     3.467    -8.743     0.200
     0.148     2.049     0.200
     0.642     3.156     0.200
     1.667    -1.013     0.200
     1.854    -0.172     0.200
     1.840     0.720     0.200
     2.095    -0.642     0.200
     2.161    -1.183     0.200
     2.226    -2.766     0.200
     2.193    -3.612     0.200
     0.395     3.026     0.200
     0.645     1.187     0.200
     0.942     2.418     0.200
     0.891     1.743     0.200
     1.481    -1.285     0.200
     1.600    -0.928     0.200
     1.657    -1.927     0.200
     1.709    -0.776     0.200
     0.271     4.439     0.200
     0.632     2.846     0.200
     0.845     2.980     0.200
     1.111     0.038     0.200
     1.426    -1.049     0.200
     1.563    -0.599     0.200
     1.663    -1.235     0.200
     1.825    -1.006     0.200
     0.416     2.361     0.200
     0.586     2.405     0.200
     0.886     2.793     0.200
     0.954     1.487     0.200
     0.954     0.284     0.200
     0.938     1.588     0.200
     1.423     0.985     0.200
     1.588     0.321     0.200
     1.692    -0.685     0.200
     1.651     0.570     0.200
     1.757     0.234     0.200
     2.625    -4.465     0.200
     2.669    -4.280     0.200
     2.815    -6.194     0.200
     0.728     2.913     0.200
     0.761     3.404     0.200
     1.065    -1.131     0.200
     1.434    -0.765     0.200
     1.382    -0.488     0.200
     1.704     0.951     0.200
     1.612     1.059     0.200
     1.863    -2.248     0.200
     2.053    -2.063     0.200
     2.118    -2.596     0.200
     2.277    -4.520     0.200
     2.488    -5.704     0.200
     2.498    -2.653     0.200
     3.576   -10.202     0.200
     0.306     3.236     0.200
     1.235    -0.544     0.200
     1.437    -0.895     0.200
     1.627    -0.598     0.200
     1.600    -0.976     0.200
     0.634     2.659     0.200
     0.653     3.707     0.200
     0.787     0.388     0.200
     0.729     1.289     0.200
     0.922     1.821     0.200
     1.038     2.282     0.200
     1.286    -0.591     0.200
     1.326     0.547     0.200
     1.466     1.139     0.200
     1.452     0.134     0.200
     1.907    -3.068     0.200
     2.054     0.113     0.200
     2.234    -4.518     0.200
     0.646     3.129     0.200
     1.030     2.097     0.200
     1.927    -1.093     0.200
     0.354     3.772     0.200
     0.852    -0.182     0.200
     0.907     0.314     0.200
     0.936     1.273     0.200
     1.240     0.574     0.200
     1.275     2.066     0.200
     1.598    -0.653     0.200
     1.928    -1.239     0.200
     1.933    -0.920     0.200
     1.940    -1.492     0.200
     2.168    -4.878     0.200
     2.272    -5.589     0.200
     2.599    -4.448     0.200
     2.937    -8.919     0.200
     3.060    -5.840     0.200
     0.389     2.346     0.200
     0.842     2.260     0.200
     1.299     0.733     0.200
     1.395    -1.033     0.200
     1.469     0.068     0.200
     1.629    -0.425     0.200
     1.672    -1.935     0.200
     1.535    -0.457     0.200
     2.236    -4.310     0.200
     0.381     3.882     0.200
     0.860     1.046     0.200
     0.906     0.990     0.200
     1.217    -0.026     0.200
     1.280    -0.072     0.200
     1.450    -0.957     0.200
     1.516    -1.703     0.200
     0.378     3.670     0.200
     0.865     0.800     0.200
     1.628    -1.373     0.200
     1.908    -1.179     0.200
     1.915    -1.710     0.200
     0.243     2.466     0.200
     0.311     1.569     0.200
     0.574     2.096     0.200
     1.125     0.725     0.200
     1.630     1.252     0.200
     1.754    -0.750     0.200
     1.900     0.050     0.200
     1.955    -1.280     0.200
     2.504    -2.824     0.200
     2.459    -0.890     0.200
     2.698    -5.637     0.200
     0.393     3.721     0.200
     0.863     1.596     0.200
     0.937     1.061     0.200
     1.284     0.101     0.200
     1.451    -0.969     0.200
     1.516    -0.960     0.200
     1.676    -0.792     0.200
     0.402     2.144     0.200
     0.951     2.119     0.200
     0.915     1.711     0.200
     0.948     2.474     0.200
     1.368     0.951     0.200
     1.588     0.682     0.200
     1.681    -0.044     0.200
     1.681    -1.192     0.200
     1.627    -0.385     0.200
     1.734    -0.990     0.200
     2.816    -5.625     0.200
     0.418     2.476     0.200
     0.961     2.512     0.200
     1.374     1.926     0.200
     1.607     0.389     0.200
     1.634    -0.829     0.200
     1.665    -0.749     0.200
     1.792     2.068     0.200
     0.455     2.695     0.200
     0.967     1.485     0.200
     1.198    -0.489     0.200
     1.369     1.299     0.200
     1.503    -1.567     0.200
     1.825     0.004     0.200
     2.319    -3.519     0.200
     2.426    -5.997     0.200
     2.458    -6.487     0.200
     0.638     2.686     0.200
     0.701     3.961     0.200
     1.150     0.415     0.200
     1.646     1.007     0.200
     1.808    -1.503     0.200
     1.914    -1.641     0.200
     2.196    -2.974     0.200
     0.847     2.902     0.200
     0.933     2.645     0.200
     1.121     2.722     0.200
     1.180     0.611     0.200
     1.169     1.928     0.200
     1.586     0.656     0.200
     2.434    -2.311     0.200
     0.253     1.938     0.200
     0.360     1.854     0.200
     0.655     2.176     0.200
     0.815     3.606     0.200
     1.687     0.082     0.200
     2.071    -0.286     0.200
     2.280    -1.670     0.200
     2.776    -4.724     0.200
     3.431   -10.114     0.200
     0.278     4.443     0.200
     0.905     1.497     0.200
     1.285     1.620     0.200
     1.477    -1.505     0.200
     1.535    -0.317     0.200
     1.638    -0.894     0.200
     0.436     1.168     0.200
     1.094     1.199     0.200
     1.524     2.267     0.200
     1.551     1.301     0.200
     1.052     1.239     0.200
     1.271    -1.081     0.200
     1.367     1.307     0.200
     1.814    -0.453     0.200
     1.679    -0.408     0.200
     1.849    -0.800     0.200
     1.922    -1.241     0.200
     2.049    -1.206     0.200
     0.527     2.297     0.200
     0.659     1.552     0.200
     1.030     3.913     0.200
     1.100     2.350     0.200
     1.100     3.467     0.200
     1.233     3.445     0.200
     1.246     3.355     0.200
     1.750     2.468     0.200
     1.736     1.746     0.200
     1.642     1.768     0.200
     1.788     0.737     0.200
     1.700     2.567     0.200
     1.684    -0.054     0.200
     0.513     1.242     0.200
     0.628     1.182     0.200
     1.267     2.506     0.200
     1.396     1.834     0.200
     1.653     1.832     0.200
     1.802    -0.150     0.200
     1.995    -1.105     0.200
     2.131    -0.518     0.200
     2.212     1.258     0.200
     0.797     1.556     0.200
     0.626     2.204     0.200
     0.868     0.751     0.200
     1.061     1.196     0.200
     1.211     2.219     0.200
     1.331     2.445     0.200
     1.542     3.266     0.200
     1.943    -0.201     0.200
     1.966     1.908     0.200
     1.951     1.160     0.200
     2.009     1.582     0.200
     2.069     1.246     0.200
     0.278     3.466     0.200
     0.485     1.723     0.200
     0.611     1.753     0.200
     0.879     1.913     0.200
     1.225     1.335     0.200
     1.503    -0.289     0.200
     1.790    -1.551     0.200
     1.742    -0.668     0.200
     2.014     0.748     0.200
     2.205    -0.818     0.200
     2.327    -1.338     0.200
     0.576     2.817     0.200
     1.031     2.459     0.200
     0.959     2.876     0.200
     1.233     1.098     0.200
     1.321     2.680     0.200
     1.449     2.874     0.200
     1.965     1.226     0.200
     0.834     1.621     0.200
     0.840     4.104     0.200
     0.914     1.572     0.200
     1.479     0.893     0.200
     1.544     0.602     0.200
     1.816    -0.854     0.200
     2.127    -2.219     0.200
     0.468     3.000     0.200
     0.523     2.757     0.200
     1.074     3.142     0.200
     1.011     1.089     0.200
     1.232    -1.110     0.200
     1.230    -0.110     0.200
     1.348     0.329     0.200
     1.320     0.063     0.200
     1.592    -1.321     0.200
     1.649    -1.237     0.200
     1.959    -1.717     0.200
     2.336    -5.195     0.200
     0.833     1.868     0.200
     1.373     1.031     0.200
     1.405     0.002     0.200
     1.393     0.427     0.200
     1.479    -0.575     0.200
     1.476     0.062     0.200
     2.095    -2.867     0.200
     2.173    -3.155     0.200
     2.203    -4.513     0.200
     2.397    -5.253     0.200
     2.831    -6.122     0.200
     0.753     1.957     0.200
     0.816     3.494     0.200
     1.078     2.724     0.200
     1.365    -0.006     0.200
     1.567     2.064     0.200
     1.843     2.194     0.200
     2.109    -1.339     0.200
     2.384    -2.835     0.200
     0.458     2.802     0.200
     0.838    -0.563     0.200
     0.812     0.884     0.200
     0.970     2.525     0.200
     1.113    -0.536     0.200
     1.258    -0.193     0.200
     1.449     0.860     0.200
     1.389    -0.663     0.200
     1.122     0.956     0.200
     1.420     1.948     0.200
     1.502     1.711     0.200
     2.046    -0.529     0.200
     2.543    -2.638     0.200
     0.736     2.469     0.200
     0.894     2.530     0.200
     0.894     1.112     0.200
     1.427     1.767     0.200
     1.537     0.099     0.200
     1.537     1.734     0.200
     1.697     1.597     0.200
     1.664     1.476     0.200
     1.937     1.867     0.200
     2.352    -4.481     0.200
     2.406    -1.404     0.200
     2.594    -3.632     0.200
     2.684    -6.294     0.200
     2.896    -5.471     0.200
     2.890    -6.236     0.200
     0.478     2.144     0.200
     0.988     2.234     0.200
     1.181     1.504     0.200
     1.443     1.214     0.200
     1.470     1.231     0.200
     1.507     0.324     0.200
     2.518    -5.071     0.200
     2.562    -3.203     0.200
     2.643    -5.556     0.200
     0.499     1.916     0.200
     1.049     1.285     0.200
     1.451     2.720     0.200
     1.480     1.612     0.200
     1.523     1.059     0.200
     2.546    -5.455     0.200
     2.648    -4.433     0.200
     2.638    -3.049     0.200
     0.547     2.164     0.200
     1.626     0.287     0.200
     1.841    -2.067     0.200
     2.672    -6.016     0.200
     3.684   -11.018     0.200
     0.542     2.306     0.200
     0.953    -0.824     0.200
     1.152     0.666     0.200
     1.283    -0.951     0.200
     1.819     0.857     0.200
     0.496     2.605     0.200
     1.018     2.987     0.200
     1.239     0.384     0.200
     1.370    -0.337     0.200
     2.091    -3.288     0.200
     1.417     0.771     0.200
     1.406     1.479     0.200
     1.446     1.490     0.200
     1.491     1.115     0.200
     2.083    -2.780     0.200
     2.389    -4.696     0.200
     0.755     1.853     0.200
     0.815     3.793     0.200
     1.332     1.088     0.200
     1.544     0.845     0.200
     1.539     1.407     0.200
     0.856     1.469     0.200
     0.933     0.651     0.200
     0.848     1.302     0.200
     1.469    -0.878     0.200
     1.396     0.566     0.200
     1.514    -0.669     0.200
     0.425     0.137     0.200
     1.329     1.529     0.200
     1.469     4.018     0.200
     1.443     1.836     0.200
     1.600     1.493     0.200
     1.607     3.130     0.200
     1.501     2.272     0.200
     2.139     0.341     0.200
     0.666     2.778     0.200
     0.743     3.804     0.200
     1.364     0.523     0.200
     0.187     2.319     0.200
     0.595     1.581     0.200
     0.922     4.774     0.200
     1.884     0.588     0.200
     1.926    -1.527     0.200
     2.266    -1.530     0.200
     2.407     1.045     0.200
     2.420    -4.091     0.200
     2.871    -3.362     0.200
     0.216     2.431     0.200
     1.411    -0.145     0.200
     1.376     2.054     0.200
     1.529     0.807     0.200
     2.017    -1.702     0.200
     2.913    -4.413     0.200
     0.612     3.199     0.200
     1.152     0.276     0.200
     1.461     3.725     0.200
     1.443     3.276     0.200
     1.490     0.816     0.200
     2.079    -2.704     0.200
     2.701    -5.725     0.200
     0.476     1.339     0.200
     1.847    -2.038     0.200
     1.961    -2.923     0.200
     2.134    -4.296     0.200
     0.919     0.967     0.200
     1.024     3.439     0.200
     1.634     1.486     0.200
     1.832     1.518     0.200
     0.444     1.205     0.200
     1.018     1.126     0.200
     1.115     0.270     0.200
     1.518     1.738     0.200
     1.525     2.960     0.200
     1.704    -1.111     0.200
     2.090     0.038     0.200
     2.115    -0.076     0.200
     2.290     0.270     0.200
     2.491    -4.065     0.200
     1.241     2.154     0.200
     1.281     1.836     0.200
     1.415     1.216     0.200
     1.479     1.839     0.200
     1.498     2.601     0.200
     1.596     2.629     0.200
     1.841     0.539     0.200
     1.961    -0.358     0.200
     2.649    -2.548     0.200
     2.641    -3.505     0.200
     0.459     2.567     0.200
     0.540     3.332     0.200
     0.733     4.007     0.200
     0.828     1.921     0.200
     0.907     1.975     0.200
     1.393     1.345     0.200
     2.634    -6.910     0.200
     2.725    -5.065     0.200
     3.198    -4.215     0.200
     0.287     2.836     0.200
     0.616     2.227     0.200
     0.641     1.245     0.200
     1.189     1.303     0.200
     1.781    -0.014     0.200
     1.979    -0.443     0.200
     2.186    -0.412     0.200
     2.569    -3.159     0.200
     0.512     3.405     0.200
     0.791     2.476     0.200
     1.425     1.568     0.200
     3.139    -4.716     0.200
     0.716     1.019     0.200
     1.061     4.160     0.200
     1.110     3.491     0.200
     1.456     2.947     0.200
     1.528     2.921     0.200
     1.810     2.779     0.200
     0.108     2.329     0.200
     0.591     3.535     0.200
     0.676     3.309     0.200
     0.843     2.073     0.200
     1.360     0.066     0.200
     1.495     0.594     0.200
     1.377     1.978     0.200
     1.481     0.086     0.200
     1.463     1.136     0.200
     2.020    -1.687     0.200
     2.020    -1.200     0.200
     0.644     1.884     0.200
     0.790     2.282     0.200
     0.963     0.721     0.200
     1.570    -0.798     0.200
     2.191    -3.492     0.200
     2.535    -7.028     0.200
     2.638    -6.089     0.200
     0.527     2.601     0.200
     0.545     3.485     0.200
     0.651     2.592     0.200
     0.677     3.596     0.200
     1.137     1.382     0.200
     1.738     0.735     0.200
     1.739    -1.079     0.200
     1.663    -0.873     0.200
     2.097    -0.414     0.200
     2.449    -4.726     0.200
     2.410    -3.618     0.200
     2.821    -7.456     0.200
     3.180    -8.548     0.200
     0.574     1.257     0.200
     0.802     1.953     0.200
     1.199     1.038     0.200
     1.465     2.160     0.200
     1.518     2.164     0.200
     1.465     1.912     0.200
     1.488     1.848     0.200
     2.641    -2.231     0.200
     0.111     3.212     0.200
     0.755     1.304     0.200
     0.964     2.892     0.200
     1.241     0.811     0.200
     1.379     0.516     0.200
     2.013    -2.586     0.200
     2.435    -5.026     0.200
     2.540    -4.665     0.200
     0.293     2.977     0.200
     0.420     2.524     0.200
     0.537     2.398     0.200
     1.305     0.421     0.200
     1.334     0.966     0.200
     1.472    -0.084     0.200
     1.618    -1.833     0.200
     2.024    -3.941     0.200
     2.257    -1.783     0.200
     2.278    -1.606     0.200
     0.479     1.270     0.200
     1.429     1.968     0.200
     1.607     1.487     0.200
     1.638     2.094     0.200
     1.693     0.818     0.200
     0.172     3.181     0.200
     1.527    -0.042     0.200
     1.598     1.460     0.200
     1.791    -3.212     0.200
     1.305     1.011     0.200
     1.553    -0.006     0.200
     1.654    -0.664     0.200
     1.793    -0.476     0.200
     0.273     3.282     0.200
     0.647     1.239     0.200
     1.087    -0.068     0.200
     1.552     0.293     0.200
     1.653    -0.748     0.200
     0.450     0.072     0.200
     1.347     2.967     0.200
     1.177     4.622     0.200
     1.522     4.202     0.200
     1.491     1.262     0.200
     1.466     2.356     0.200
     1.858     1.095     0.200
     2.107    -0.371     0.200
     1.069     3.016     0.200
     1.115     2.827     0.200
     1.574    -0.532     0.200
     2.163    -0.077     0.200
     2.232    -2.359     0.200
     2.380    -2.574     0.200
     0.380    -0.417     0.200
     1.417     1.705     0.200
     1.265     1.185     0.200
     1.237     2.863     0.200
     1.479     1.507     0.200
     1.435     2.384     0.200
     1.607     0.692     0.200
     0.578     0.073     0.200
     1.270     3.394     0.200
     1.218     4.092     0.200
     1.500     2.599     0.200
     1.325     3.346     0.200
     0.927     3.645     0.200
     1.232     2.996     0.200
     1.345     1.233     0.200
     1.456     1.919     0.200
     1.581     1.547     0.200
     2.292    -0.330     0.200
     2.360    -2.680     0.200
     2.434    -2.423     0.200
     0.891     4.788     0.200
     1.324     1.175     0.200
     1.712     1.455     0.200
     2.318    -1.801     0.200
     2.656    -5.770     0.200
     0.072     5.130     0.200
     0.495     3.040     0.200
     0.539     2.533     0.200
     1.319     0.803     0.200
     1.341     0.728     0.200
     1.637    -0.005     0.200
     1.936    -1.069     0.200
     2.213    -2.657     0.200
     2.287    -5.384     0.200
     2.483    -4.462     0.200
     2.703    -5.974     0.200
     3.203    -8.729     0.200
     0.830     3.245     0.200
     1.066     2.179     0.200
     1.105     2.740     0.200
     1.259     0.095     0.200
     1.535     1.994     0.200
     1.697     0.794     0.200
     2.332    -1.078     0.200
     0.720    -0.206     0.200
     1.138     0.995     0.200
     1.138     0.303     0.200
     1.309     0.240     0.200
     1.571    -0.237     0.200
     1.915    -3.068     0.200
     1.878    -0.442     0.200
     2.220    -4.168     0.200
     2.267    -4.358     0.200
     2.689    -5.063     0.200
     0.630     2.518     0.200
     0.630     2.721     0.200
     0.677     1.862     0.200
     0.715     3.131     0.200
     1.201     0.675     0.200
     1.543     0.233     0.200
     1.667     0.772     0.200
     1.922     0.503     0.200
     0.949     4.876     0.200
     1.195     2.769     0.200
     1.191     3.717     0.200
     1.234     3.822     0.200
     1.315     3.675     0.200
     1.374     3.375     0.200
     1.478     2.594     0.200
     1.590     1.557     0.200
     1.691     1.360     0.200
     1.906    -0.402     0.200
     2.285     0.317     0.200
     2.456    -1.527     0.200
     2.620    -4.455     0.200
     0.136     3.509     0.200
     0.304     2.241     0.200
     0.433     2.302     0.200
     1.633    -0.947     0.200
     1.966    -2.513     0.200
     2.048    -1.978     0.200
     2.155    -3.775     0.200
     2.387    -1.945     0.200
     2.498    -4.285     0.200
     2.438    -2.188     0.200
     2.772    -6.929     0.200
     2.899    -7.451     0.200
     0.782     4.069     0.200
     1.011     4.017     0.200
     0.995     3.799     0.200
     1.033     3.850     0.200
     1.109     3.982     0.200
     1.253     2.434     0.200
     1.585     1.448     0.200
     2.278    -0.425     0.200
     2.690    -4.682     0.200
     3.532    -6.706     0.200
     0.208     1.276     0.200
     1.324     3.586     0.200
     1.204    -1.414     0.200
     1.390     1.397     0.200
     1.806     0.610     0.200
     2.219    -3.205     0.200
     2.378    -0.626     0.200
     0.871     3.671     0.200
     1.417     0.953     0.200
     1.774    -0.648     0.200
     2.016    -2.120     0.200
     2.073    -3.165     0.200
     0.475     1.865     0.200
     1.055     1.626     0.200
     1.229     0.324     0.200
     1.361     0.134     0.200
     1.945    -4.081     0.200
     0.761     1.611     0.200
     0.761     2.717     0.200
     0.978     0.697     0.200
     1.291     0.162     0.200
     1.318    -0.511     0.200
     1.563     0.336     0.200
     1.523     1.316     0.200
     1.651     0.598     0.200
     1.903    -1.575     0.200
     2.131    -1.994     0.200
     2.189    -3.053     0.200
     2.400    -5.121     0.200
     0.123     1.696     0.200
     0.393     2.119     0.200
     0.332     1.248     0.200
     0.447     1.678     0.200
     0.999     4.889     0.200
     1.426     2.599     0.200
     1.781     0.406     0.200
     2.048    -0.581     0.200
     2.048    -1.878     0.200
     2.941    -3.814     0.200
     0.999     2.122     0.200
     1.652     2.257     0.200
     0.746     2.881     0.200
     0.524     1.954     0.200
     0.977     1.032     0.200
     1.388     1.625     0.200
     1.487     0.203     0.200
     1.522     1.377     0.200
     2.020    -1.803     0.200
     0.824     2.631     0.200
     0.858     2.232     0.200
     0.951     4.022     0.200
     0.997     3.746     0.200
     1.543     0.936     0.200
     1.629     1.720     0.200
     1.815     0.379     0.200
     1.903     0.096     0.200
     2.143    -0.668     0.200
     0.753     1.506     0.200
     0.691     2.398     0.200
     0.763     1.039     0.200
     0.763     1.164     0.200
     1.044    -0.532     0.200
     1.237    -0.078     0.200
     1.319    -0.094     0.200
     1.319    -0.282     0.200
     1.429    -1.841     0.200
     1.805    -0.938     0.200
     1.814     0.851     0.200
     2.283    -2.717     0.200
     2.290    -6.002     0.200
     2.443    -5.724     0.200
     0.781     3.211     0.200
     0.838     2.394     0.200
     0.888     2.159     0.200
     1.758    -0.710     0.200
     1.937    -2.147     0.200
     2.098    -3.215     0.200
     2.027    -1.541     0.200
     2.239    -0.925     0.200
     2.630    -6.747     0.200
     0.818     2.591     0.200
     1.091     1.057     0.200
     1.573     0.171     0.200
     1.623    -1.829     0.200
     1.883    -2.667     0.200
     2.162    -1.076     0.200
     2.690    -4.886     0.200
     3.053    -7.134     0.200
     3.341    -4.653     0.200
     3.476    -6.342     0.200
     3.689   -11.438     0.200
     0.949     2.144     0.200
     0.877     3.072     0.200
     0.904     2.816     0.200
     0.966     2.692     0.200
     1.474    -0.617     0.200
     1.641    -0.014     0.200
     1.939    -1.906     0.200
     2.137    -0.925     0.200
     0.141     3.760     0.200
     0.528     2.731     0.200
     0.528     1.735     0.200
     0.950     2.474     0.200
     1.002     1.537     0.200
     1.198     0.114     0.200
     1.387     1.922     0.200
     1.347     1.517     0.200
     1.728    -0.714     0.200
     1.804    -1.347     0.200
     2.344    -4.583     0.200
     2.417    -5.400     0.200
     2.425    -2.504     0.200
     2.573    -3.399     0.200
     2.735    -7.249     0.200
     0.297    -0.036     0.200
     1.148     3.939     0.200
     1.352     0.705     0.200
     1.352     0.010     0.200
     1.149     2.151     0.200
     1.570     0.818     0.200
     1.626     1.585     0.200
     1.808     0.665     0.200
     0.419     2.608     0.200
     0.835     1.990     0.200
     1.825    -0.371     0.200
     2.367    -2.830     0.200
     0.993     2.758     0.200
     1.516    -0.126     0.200
     1.547     2.715     0.200
     1.626    -0.433     0.200
     1.665    -1.373     0.200
     1.626    -1.457     0.200
     1.775    -1.278     0.200
     1.775    -1.055     0.200
     1.658    -1.380     0.200
     1.775    -0.503     0.200
     1.882     0.135     0.200
     1.982    -3.125     0.200
     2.861    -4.718     0.200
     1.340     2.052     0.200
     1.492     3.251     0.200
     2.056     0.072     0.200
     2.572    -2.864     0.200
     3.230    -4.655     0.200
     0.705     1.986     0.200
     0.695     3.345     0.200
     1.257     1.228     0.200
     1.339     0.728     0.200
     1.607     3.016     0.200
     1.658     2.143     0.200
     1.744     1.794     0.200
     2.663    -2.398     0.200
     0.600     2.926     0.200
     0.662     2.290     0.200
     0.960     1.894     0.200
     1.139     2.422     0.200
     1.141     1.166     0.200
     1.327     1.720     0.200
     1.533     0.634     0.200
     1.642    -0.507     0.200
     1.669    -0.640     0.200
     1.725    -1.156     0.200
     2.029    -3.348     0.200
     2.286    -1.368     0.200
     2.463    -5.324     0.200
     0.328     4.485     0.200
     1.301    -0.329     0.200
     1.646    -0.474     0.200
     1.737    -0.951     0.200
     0.532     3.364     0.200
     0.685     3.058     0.200
     1.108     1.210     0.200
     1.215     0.170     0.200
     1.230     0.881     0.200
     1.466    -1.032     0.200
     1.727    -2.780     0.200
     2.049    -3.104     0.200
     2.113    -5.006     0.200
     0.061     5.159     0.200
     0.318     2.313     0.200
     0.450     1.171     0.200
     1.767    -0.957     0.200
     1.828    -0.097     0.200
     1.961    -1.970     0.200
     1.961    -0.220     0.200
     2.414    -4.709     0.200
     2.763    -5.562     0.200
     0.261     5.078     0.200
     0.638     0.755     0.200
     1.413     0.507     0.200
     1.656    -0.249     0.200
     1.836    -3.570     0.200
     1.836    -4.074     0.200
     2.302    -6.481     0.200
     2.641    -8.315     0.200
     0.454     4.051     0.200
     0.466     2.573     0.200
     0.696     1.492     0.200
     1.074     1.397     0.200
     1.245    -0.999     0.200
     1.708    -1.973     0.200
     0.527     1.700     0.200
     1.442    -0.740     0.200
     1.474    -0.964     0.200
     1.511    -1.617     0.200
     0.771     2.577     0.200
     0.780     3.480     0.200
     0.828     3.438     0.200
     1.068     2.825     0.200
     1.550     2.667     0.200
     1.793     1.739     0.200
     1.971    -0.348     0.200
     1.971     0.142     0.200
     2.109     1.132     0.200
     2.191    -1.613     0.200
     2.379    -3.180     0.200
     2.540    -2.461     0.200
     3.143    -7.591     0.200
     0.384     2.030     0.200
     0.738     2.198     0.200
     0.950     1.957     0.200
     1.477    -0.452     0.200
     1.542     0.807     0.200
     1.670    -0.115     0.200
     2.150    -3.915     0.200
     1.734     0.536     0.200
     2.941    -3.533     0.200
     3.857    -7.717     0.200
     1.655     0.701     0.200
     0.724     1.122     0.200
     0.797     2.062     0.200
     1.342     1.028     0.200
     1.342     0.837     0.200
     3.084    -4.749     0.200
     0.356     1.773     0.200
     0.356     1.318     0.200
     0.557     1.937     0.200
     1.913    -2.049     0.200
     1.913    -1.090     0.200
     0.431     1.802     0.200
     0.590     3.472     0.200
     1.744    -2.974     0.200
     0.790     1.102     0.200
     0.750     3.318     0.200
     1.495    -0.466     0.200
EOF
gmt end
