#!/bin/bash
gmt begin fes5.6_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional fes5.6'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    42.148
    14.500    41.870
    15.000    41.592
    15.500    41.310
    16.000    41.026
    16.500    40.736
    17.000    40.439
    17.500    40.134
    18.000    39.818
    18.500    39.490
    19.000    39.147
    19.500    38.788
    20.000    38.409
    20.500    38.009
    21.000    37.585
    21.500    37.136
    22.000    36.658
    22.500    36.150
    23.000    35.611
    23.500    35.038
    24.000    33.783
    24.500    32.511
    25.000    31.229
    25.500    29.937
    26.000    28.633
    26.500    27.319
    27.000    25.991
    27.500    24.647
    28.000    23.282
    28.500    21.903
    29.000    20.513
    29.500    19.114
    30.000    17.707
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    20.282 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     8.962
     1.500     9.998
     2.000    11.034
     2.500    12.070
     3.000    13.106
     3.500    14.142
     4.000    15.175
     4.500    16.208
     5.000    17.239
     5.500    18.269
     6.000    19.298
     6.500    20.325
     7.000    21.350
     7.500    22.373
     8.000    23.393
     8.500    24.412
     9.000    25.428
     9.500    26.441
    10.000    27.451
    10.500    28.459
    11.000    29.463
    11.500    30.464
    12.000    31.462
    12.500    32.456
    13.000    33.446
    13.500    34.433
    14.000    35.416
    14.500    36.395
    15.000    37.192
    15.500    37.901
    16.000    38.542
    16.500    39.065
    17.000    39.522
    17.500    39.041
    18.000    39.384
    18.500    39.668
    19.000    39.895
    19.500    40.063
    20.000    40.174
    20.500    40.225
    21.000    40.216
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    30.446 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     4.803
     1.000     8.256
     1.500    10.686
     2.000    13.116
     2.500    15.546
     3.000    17.975
     3.500    20.403
     4.000    22.830
     4.500    25.256
     5.000    27.681
     5.500    30.105
     6.000    32.526
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    25.681 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    23.576
     1.500    29.750
     2.000    35.925
     2.500    42.099
     3.000    48.274
     3.500    54.448
     4.000    60.618
     4.500    66.789
     5.000    72.957
     5.500    79.124
     6.000    85.287
     6.500    91.449
     7.000    97.608
     7.500   103.763
     8.000   109.918
     8.500   116.067
     9.000   122.213
     9.500   128.355
    10.000   134.494
    10.500   140.628
    11.000   146.757
    11.500   152.882
    12.000   159.002
    12.500   165.118
    13.000   171.227
    13.500   177.331
    14.000   183.429
    14.500   189.522
    15.000   195.606
    15.500   201.685
    16.000   207.758
    16.500   213.823
    17.000   219.881
    17.500   233.524
    18.000   239.794
    18.500   246.052
    19.000   252.297
    19.500   258.528
    20.000   264.745
    20.500   270.948
    21.000   277.136
    21.500   283.309
    22.000   289.466
    22.500   295.607
    23.000   301.732
    23.500   307.840
    24.000   313.931
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    58.618 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    12.090
     1.000    22.148
     1.500    30.512
     2.000    38.876
     2.500    47.240
     3.000    55.602
     3.500    63.963
     4.000    72.322
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    61.963 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    17.399    45.735     0.150
    18.262   254.266     0.150
    23.340   287.999     0.150
    23.588   293.106     0.150
    24.005   300.241     0.150
    24.002   302.280     0.150
    20.301    61.288     0.150
    17.509    51.997     0.150
    18.538   261.995     0.150
    18.672    55.425     0.150
    19.167   258.647     0.150
    19.462   264.207     0.150
    20.580   292.165     0.150
    17.486   447.356     0.150
    28.717  -331.726     0.150
    21.647   300.599     0.150
    21.796    55.764     0.150
    17.007    46.148     0.150
    17.604    46.383     0.150
    22.528    59.919     0.150
    22.528    59.419     0.150
    23.691    60.343     0.150
    24.193    66.487     0.150
    20.772   266.100     0.150
    21.813   278.251     0.150
    22.091   277.706     0.150
    22.394   279.166     0.150
    22.723   278.336     0.150
    23.183   286.967     0.150
    23.448    59.470     0.150
    23.448   284.868     0.150
    23.459   288.743     0.150
    23.490    63.879     0.150
    23.787   288.916     0.150
    23.908   287.397     0.150
    23.952   292.992     0.150
    24.744   300.746     0.150
    25.238   302.975     0.150
    26.580  -302.995     0.150
    17.198    44.517     0.150
    17.297    44.168     0.150
    17.533    45.414     0.150
    17.556    45.645     0.150
    17.603    44.795     0.150
    19.993   260.204     0.150
    20.027    50.810     0.150
    20.186    51.649     0.150
    20.378   279.106     0.150
    20.670   268.402     0.150
    21.483   277.810     0.150
    21.827   279.795     0.150
    21.913   282.188     0.150
    22.411   279.979     0.150
    22.411   281.979     0.150
    22.736   282.188     0.150
    23.147   287.395     0.150
    23.213    58.627     0.150
    23.213   288.627     0.150
    23.213   488.627     0.150
    23.854   293.143     0.150
    23.963   295.670     0.150
    24.814   301.444     0.150
    24.748   303.708     0.150
    25.258   303.764     0.150
    26.603  -300.461     0.150
    26.603    74.758     0.150
    27.484   222.776     0.150
    28.191   312.533     0.150
    29.877  -340.669     0.150
    29.877    72.851     0.150
    29.877   317.851     0.150
    20.126    59.484     0.150
    20.242   506.667     0.150
    20.242   514.167     0.150
    20.554    57.588     0.150
    17.547    49.198     0.150
    18.759    52.152     0.150
    20.316   265.049     0.150
    20.567    56.549     0.150
    17.911    48.206     0.150
    19.430    53.876     0.150
    20.202    49.672     0.150
    20.202    57.270     0.150
    20.202   261.672     0.150
    20.202    49.672     0.150
    20.202    57.270     0.150
    20.202   261.672     0.150
    20.891   263.137     0.150
    27.399  -311.396     0.150
    29.177  -331.679     0.150
    19.960   256.954     0.150
    22.274   284.388     0.150
    19.514    56.906     0.150
    20.839   271.951     0.150
    22.532   312.980     0.150
    22.297   284.188     0.150
    23.338   288.135     0.150
    23.341   295.200     0.150
    23.407   288.433     0.150
    23.716   291.333     0.150
    24.391   295.153     0.150
    24.442   296.658     0.150
    19.500   247.724     0.150
    19.813    45.797     0.150
    20.007   255.006     0.150
    20.012   254.935     0.150
    23.775    39.244     0.150
    23.775    63.244     0.150
    25.219   302.341     0.150
    26.263  -303.833     0.150
    27.623  -321.251     0.150
    19.673   271.890     0.150
    21.596   275.657     0.150
    21.710   277.332     0.150
    18.639   250.895     0.150
    20.127   257.133     0.150
    21.190   274.009     0.150
    22.187   284.379     0.150
    22.239   280.871     0.150
    22.531   286.964     0.150
    23.324   289.906     0.150
    23.357   291.825     0.150
    19.231    44.235     0.150
    19.669    42.857     0.150
    17.366   252.663     0.150
    17.828   238.796     0.150
    17.994   255.814     0.150
    18.009   255.117     0.150
    18.141   258.043     0.150
    18.797   261.088     0.150
    19.500   265.264     0.150
    21.407   274.412     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    17.325    44.204     0.200
    17.445    42.397     0.200
    17.551    42.567     0.200
    17.623    44.429     0.200
    17.774    42.363     0.200
    17.874    42.400     0.200
    18.262    42.266     0.200
    18.379    42.395     0.200
    19.257    37.654     0.200
    20.516    39.960     0.200
    20.760    39.108     0.200
    20.894    39.247     0.200
    21.700    39.140     0.200
    21.915    38.636     0.200
    23.143    35.307     0.200
    23.340    35.999     0.200
    23.588    36.106     0.200
    24.005    34.241     0.200
    24.002    35.483     0.200
    24.185    33.641     0.200
    24.189    33.095     0.200
    24.363    35.070     0.200
    24.421    32.393     0.200
    24.841    33.491     0.200
    25.067    32.852     0.200
    25.984    31.749     0.200
    26.829    26.284     0.200
    26.967    27.674     0.200
    27.551    25.863     0.200
    19.844    38.729     0.200
    20.669    38.102     0.200
    20.920    37.165     0.200
    23.327    36.079     0.200
    29.187    23.193     0.200
    21.629    37.577     0.200
    24.100    35.750     0.200
    14.516    43.924     0.200
    14.516    47.924     0.200
    16.347    45.259     0.200
    16.388    44.785     0.200
    17.509    43.098     0.200
    20.456    40.606     0.200
    21.488    39.558     0.200
    21.489    40.053     0.200
    21.666    39.489     0.200
    21.782    39.128     0.200
    27.634    27.133     0.200
    28.662    23.051     0.200
    20.141    40.370     0.200
    21.441    42.199     0.200
    21.529    41.178     0.200
    23.478    37.430     0.200
    27.301    25.716     0.200
    28.717    22.694     0.200
    28.997    22.028     0.200
    14.619    46.823     0.200
    14.947    45.195     0.200
    17.076    41.445     0.200
    17.160    42.363     0.200
    17.736    41.946     0.200
    17.767    41.777     0.200
    18.241    41.148     0.200
    20.630    37.367     0.200
    21.092    38.976     0.200
    21.647    36.799     0.200
    21.796    36.764     0.200
    22.025    37.088     0.200
    21.987    36.330     0.200
    22.130    37.864     0.200
    22.132    37.843     0.200
    22.338    39.434     0.200
    22.383    37.910     0.200
    22.383    38.511     0.200
    22.736    37.295     0.200
    22.906    37.811     0.200
    24.503    33.166     0.200
    24.839    33.253     0.200
    26.861    27.853     0.200
    27.404    29.820     0.200
    14.593    41.748     0.200
    15.350    44.108     0.200
    15.390    41.847     0.200
    15.638    45.847     0.200
    15.730    46.680     0.200
    21.010    38.860     0.200
    21.483    38.839     0.200
    22.166    38.373     0.200
    22.523    37.706     0.200
    22.755    38.493     0.200
    22.742    38.647     0.200
    22.847    37.822     0.200
    24.867    33.851     0.200
    29.965    20.155     0.200
    14.747    42.727     0.200
    16.278    43.859     0.200
    16.307    43.720     0.200
    16.421    44.589     0.200
    16.567    44.282     0.200
    16.645    43.170     0.200
    16.650    43.520     0.200
    16.796    44.810     0.200
    16.763    45.195     0.200
    16.862    43.647     0.200
    17.115    45.383     0.200
    17.222    45.339     0.200
    17.405    44.708     0.200
    17.448    45.807     0.200
    17.424    44.978     0.200
    17.685    44.937     0.200
    17.709    43.959     0.200
    17.910    44.815     0.200
    17.923    45.160     0.200
    18.079    43.840     0.200
    18.351    44.058     0.200
    18.373    44.010     0.200
    18.375    45.388     0.200
    19.617    41.889     0.200
    19.617    42.491     0.200
    20.193    40.071     0.200
    20.478    41.844     0.200
    20.458    41.578     0.200
    20.535    40.580     0.200
    20.592    41.512     0.200
    20.812    41.643     0.200
    20.821    41.841     0.200
    20.963    41.985     0.200
    21.153    40.366     0.200
    21.639    39.294     0.200
    21.939    41.297     0.200
    22.298    38.600     0.200
    22.528    38.919     0.200
    22.622    40.825     0.200
    22.833    36.361     0.200
    22.909    37.471     0.200
    23.124    37.762     0.200
    23.344    36.697     0.200
    23.344    36.798     0.200
    23.349    37.336     0.200
    23.505    36.810     0.200
    23.604    37.153     0.200
    23.532    38.207     0.200
    23.691    38.343     0.200
    23.848    38.308     0.200
    23.961    36.691     0.200
    23.961    36.589     0.200
    24.193    36.386     0.200
    24.179    36.655     0.200
    24.702    35.546     0.200
    24.921    34.889     0.200
    24.921    34.592     0.200
    24.965    36.482     0.200
    25.087    34.050     0.200
    25.430    34.158     0.200
    25.579    36.308     0.200
    25.956    33.416     0.200
    26.100    29.232     0.200
    26.100    29.834     0.200
    26.337    32.467     0.200
    26.666    29.624     0.200
    26.666    30.421     0.200
    27.707    28.484     0.200
    15.446    41.332     0.200
    15.856    41.671     0.200
    15.884    41.845     0.200
    16.016    41.496     0.200
    16.016    41.699     0.200
    16.268    41.759     0.200
    16.248    42.891     0.200
    16.460    42.819     0.200
    16.499    41.566     0.200
    16.624    42.009     0.200
    16.642    43.498     0.200
    16.649    43.311     0.200
    16.909    41.882     0.200
    16.962    40.858     0.200
    16.971    41.859     0.200
    17.184    43.168     0.200
    17.278    43.273     0.200
    17.335    40.608     0.200
    17.383    42.654     0.200
    17.512    41.345     0.200
    17.512    41.748     0.200
    17.534    42.890     0.200
    17.587    42.563     0.200
    17.825    41.287     0.200
    17.857    41.112     0.200
    17.857    42.612     0.200
    17.897    41.449     0.200
    17.897    41.848     0.200
    17.946    41.076     0.200
    17.946    41.576     0.200
    17.958    41.740     0.200
    17.958    41.630     0.200
    17.958    42.138     0.200
    18.021    41.806     0.200
    18.021    41.704     0.200
    18.219    41.192     0.200
    18.283    41.751     0.200
    18.301    43.649     0.200
    18.323    41.675     0.200
    18.460    40.483     0.200
    18.616    39.954     0.200
    18.545    40.087     0.200
    18.545    40.985     0.200
    18.617    40.474     0.200
    18.683    40.476     0.200
    18.757    40.711     0.200
    18.896    40.996     0.200
    19.073    40.322     0.200
    19.073    40.454     0.200
    19.096    40.194     0.200
    19.175    40.364     0.200
    19.187    40.396     0.200
    19.282    39.885     0.200
    19.278    40.133     0.200
    19.310    39.863     0.200
    19.569    40.636     0.200
    19.591    39.947     0.200
    19.624    39.990     0.200
    19.817    37.646     0.200
    19.914    38.907     0.200
    19.950    39.689     0.200
    19.986    39.643     0.200
    19.972    40.128     0.200
    19.959    38.784     0.200
    20.017    40.045     0.200
    20.144    38.733     0.200
    20.147    39.993     0.200
    20.169    38.442     0.200
    20.223    39.705     0.200
    20.293    39.058     0.200
    20.303    37.966     0.200
    20.307    39.124     0.200
    20.423    38.669     0.200
    20.520    39.039     0.200
    20.527    38.362     0.200
    20.581    39.331     0.200
    20.654    38.079     0.200
    20.654    37.918     0.200
    20.772    38.701     0.200
    20.847    38.123     0.200
    20.945    38.980     0.200
    21.058    36.766     0.200
    21.228    38.376     0.200
    21.228    37.626     0.200
    21.234    37.110     0.200
    21.340    36.864     0.200
    21.312    37.299     0.200
    21.324    37.531     0.200
    21.313    37.785     0.200
    21.474    36.505     0.200
    21.474    39.302     0.200
    21.451    37.376     0.200
    21.487    36.357     0.200
    21.485    37.951     0.200
    21.549    36.824     0.200
    21.603    37.280     0.200
    21.508    37.805     0.200
    21.545    37.301     0.200
    21.552    36.995     0.200
    21.668    36.703     0.200
    21.635    37.032     0.200
    21.647    38.152     0.200
    21.755    36.758     0.200
    21.713    36.815     0.200
    21.776    36.599     0.200
    21.781    36.602     0.200
    21.800    36.569     0.200
    21.813    36.751     0.200
    21.813    36.861     0.200
    21.839    36.680     0.200
    21.811    37.707     0.200
    21.834    37.765     0.200
    21.852    38.494     0.200
    21.907    36.547     0.200
    21.856    37.948     0.200
    21.895    35.097     0.200
    21.862    37.377     0.200
    21.952    37.073     0.200
    22.113    39.453     0.200
    22.207    37.851     0.200
    22.245    35.711     0.200
    22.294    37.832     0.200
    22.290    37.315     0.200
    22.394    36.267     0.200
    22.377    37.600     0.200
    22.440    37.351     0.200
    22.736    39.181     0.200
    22.723    35.535     0.200
    22.796    38.174     0.200
    22.772    36.720     0.200
    22.931    36.504     0.200
    23.056    37.284     0.200
    23.127    34.917     0.200
    23.237    39.334     0.200
    23.244    38.247     0.200
    23.183    34.967     0.200
    23.248    35.041     0.200
    23.187    36.421     0.200
    23.370    35.776     0.200
    23.448    33.970     0.200
    23.448    34.388     0.200
    23.459    33.743     0.200
    23.413    35.675     0.200
    23.490    34.578     0.200
    23.567    35.004     0.200
    23.787    33.314     0.200
    23.839    33.309     0.200
    23.908    34.198     0.200
    23.895    34.853     0.200
    23.944    33.379     0.200
    23.952    34.992     0.200
    23.984    34.334     0.200
    24.114    33.095     0.200
    24.114    33.294     0.200
    24.228    34.641     0.200
    24.264    32.703     0.200
    24.316    32.742     0.200
    24.478    33.570     0.200
    24.468    33.548     0.200
    24.579    33.996     0.200
    24.625    34.139     0.200
    24.735    33.352     0.200
    24.701    33.252     0.200
    24.800    31.688     0.200
    24.845    30.868     0.200
    24.744    32.785     0.200
    24.885    32.456     0.200
    25.238    30.975     0.200
    25.286    32.420     0.200
    25.360    32.553     0.200
    25.441    32.609     0.200
    25.542    32.437     0.200
    25.753    29.671     0.200
    25.929    30.911     0.200
    26.103    28.886     0.200
    26.130    28.575     0.200
    26.124    29.645     0.200
    26.233    31.602     0.200
    26.245    25.033     0.200
    26.302    28.562     0.200
    26.427    29.103     0.200
    26.580    27.314     0.200
    26.920    26.453     0.200
    27.145    27.723     0.200
    27.196    25.633     0.200
    28.103    24.551     0.200
    28.541    25.040     0.200
    29.339    21.421     0.200
    29.851    18.152     0.200
    15.320    40.040     0.200
    15.322    40.710     0.200
    15.554    40.803     0.200
    15.628    40.538     0.200
    15.683    39.605     0.200
    15.660    40.301     0.200
    15.689    40.733     0.200
    15.757    40.732     0.200
    15.810    40.119     0.200
    15.861    40.726     0.200
    15.904    43.355     0.200
    15.912    42.061     0.200
    15.932    44.114     0.200
    16.014    44.259     0.200
    16.070    43.289     0.200
    16.204    43.833     0.200
    16.200    44.657     0.200
    16.263    44.728     0.200
    16.276    40.082     0.200
    16.286    42.456     0.200
    16.343    41.750     0.200
    16.478    44.423     0.200
    16.587    43.058     0.200
    16.532    41.794     0.200
    16.626    41.791     0.200
    16.633    42.116     0.200
    16.656    41.041     0.200
    16.664    40.752     0.200
    16.695    43.218     0.200
    16.763    42.502     0.200
    16.782    43.304     0.200
    16.917    41.601     0.200
    16.963    41.066     0.200
    16.979    41.369     0.200
    16.968    43.086     0.200
    17.016    42.746     0.200
    17.122    42.302     0.200
    17.204    41.951     0.200
    17.235    43.089     0.200
    17.275    43.625     0.200
    17.279    43.140     0.200
    17.254    43.247     0.200
    17.335    42.616     0.200
    17.389    42.887     0.200
    17.553    41.779     0.200
    17.664    40.778     0.200
    17.806    43.221     0.200
    17.827    43.263     0.200
    17.848    42.833     0.200
    17.880    43.634     0.200
    17.911    42.295     0.200
    17.968    44.726     0.200
    18.037    43.128     0.200
    18.086    41.962     0.200
    18.167    43.114     0.200
    18.231    41.561     0.200
    18.347    44.107     0.200
    19.847    39.409     0.200
    19.932    39.917     0.200
    19.976    39.500     0.200
    20.161    39.438     0.200
    20.168    39.255     0.200
    20.186    38.751     0.200
    20.299    39.377     0.200
    20.326    38.117     0.200
    20.334    39.623     0.200
    20.444    39.634     0.200
    20.587    39.272     0.200
    20.670    38.801     0.200
    20.670    38.430     0.200
    20.793    39.360     0.200
    20.855    39.344     0.200
    21.076    38.168     0.200
    21.239    40.157     0.200
    21.239    38.388     0.200
    21.249    37.564     0.200
    21.353    38.729     0.200
    21.343    39.145     0.200
    21.409    37.409     0.200
    21.483    40.009     0.200
    21.482    37.349     0.200
    21.474    38.922     0.200
    21.510    38.002     0.200
    21.514    38.056     0.200
    21.564    37.277     0.200
    21.541    37.641     0.200
    21.573    38.440     0.200
    21.586    41.609     0.200
    21.683    37.307     0.200
    21.666    38.675     0.200
    21.677    37.922     0.200
    21.770    37.285     0.200
    21.791    37.507     0.200
    21.744    38.162     0.200
    21.796    37.354     0.200
    21.815    37.632     0.200
    21.827    38.194     0.200
    21.827    37.405     0.200
    21.854    37.445     0.200
    21.839    37.928     0.200
    21.863    37.733     0.200
    21.922    37.383     0.200
    21.913    35.789     0.200
    21.882    36.054     0.200
    21.893    38.534     0.200
    22.105    40.553     0.200
    22.058    37.608     0.200
    22.148    37.551     0.200
    22.199    40.461     0.200
    22.262    36.821     0.200
    22.302    39.252     0.200
    22.318    37.283     0.200
    22.411    37.081     0.200
    22.406    37.352     0.200
    22.413    36.258     0.200
    22.469    37.330     0.200
    22.527    37.624     0.200
    22.578    36.535     0.200
    22.597    37.940     0.200
    22.728    36.285     0.200
    22.736    36.188     0.200
    22.803    37.443     0.200
    23.006    39.041     0.200
    22.963    37.540     0.200
    23.147    35.395     0.200
    23.260    35.791     0.200
    23.222    39.516     0.200
    23.394    35.514     0.200
    23.465    34.685     0.200
    23.465    36.384     0.200
    23.465    34.947     0.200
    23.475    34.562     0.200
    23.446    36.671     0.200
    23.511    34.752     0.200
    23.598    37.648     0.200
    23.801    34.161     0.200
    23.854    34.541     0.200
    23.821    35.524     0.200
    23.930    34.557     0.200
    23.963    34.170     0.200
    23.927    35.734     0.200
    23.986    37.099     0.200
    24.015    34.941     0.200
    24.103    37.136     0.200
    24.137    33.843     0.200
    24.260    36.023     0.200
    24.297    35.172     0.200
    24.553    36.986     0.200
    24.693    35.448     0.200
    24.748    33.711     0.200
    24.472    34.277     0.200
    24.814    32.444     0.200
    24.862    31.681     0.200
    24.867    31.318     0.200
    25.013    33.224     0.200
    24.748    32.868     0.200
    24.889    33.384     0.200
    25.233    35.655     0.200
    25.258    32.764     0.200
    25.311    33.137     0.200
    25.387    33.253     0.200
    25.709    34.395     0.200
    25.774    30.837     0.200
    26.077    30.205     0.200
    26.123    29.561     0.200
    26.149    29.254     0.200
    26.147    30.379     0.200
    26.278    28.856     0.200
    26.372    30.764     0.200
    26.372    31.764     0.200
    26.454    31.800     0.200
    26.603    28.058     0.200
    26.808    30.670     0.200
    26.808    31.670     0.200
    26.811    24.634     0.200
    26.927    29.286     0.200
    27.157    30.597     0.200
    27.225    27.809     0.200
    27.225    28.309     0.200
    27.484    26.276     0.200
    27.717    27.061     0.200
    28.130    25.242     0.200
    28.732    23.712     0.200
    28.732    24.212     0.200
    28.842    22.932     0.200
    28.842    20.932     0.200
    28.814    23.154     0.200
    29.266    21.990     0.200
    29.375    21.719     0.200
    29.695    20.984     0.200
    29.877    18.851     0.200
    20.126    38.284     0.200
    20.984    38.184     0.200
    20.136    37.733     0.200
    20.136    38.033     0.200
    20.260    37.584     0.200
    20.340    41.080     0.200
    21.663    37.647     0.200
    21.967    37.905     0.200
    28.953    21.276     0.200
    18.166    43.349     0.200
    21.461    37.906     0.200
    21.589    38.412     0.200
    14.019    44.383     0.200
    14.048    45.578     0.200
    14.070    44.322     0.200
    14.103    45.299     0.200
    14.114    45.756     0.200
    14.173    46.288     0.200
    14.212    46.114     0.200
    14.316    43.448     0.200
    14.356    45.148     0.200
    14.400    44.718     0.200
    14.436    44.764     0.200
    14.572    45.249     0.200
    14.653    41.068     0.200
    14.729    40.973     0.200
    14.834    44.266     0.200
    15.268    44.299     0.200
    15.271    44.146     0.200
    15.294    44.693     0.200
    15.311    45.486     0.200
    15.558    45.611     0.200
    16.013    42.796     0.200
    16.380    40.521     0.200
    16.309    43.241     0.200
    16.391    42.490     0.200
    16.323    44.879     0.200
    16.394    42.577     0.200
    16.402    44.455     0.200
    16.534    42.213     0.200
    16.509    45.514     0.200
    16.713    44.035     0.200
    16.784    45.601     0.200
    16.925    42.524     0.200
    16.896    44.799     0.200
    17.014    43.515     0.200
    17.015    43.610     0.200
    17.057    42.914     0.200
    17.068    42.484     0.200
    17.365    42.215     0.200
    17.441    42.438     0.200
    17.487    42.900     0.200
    17.701    41.204     0.200
    17.751    42.508     0.200
    17.989    41.539     0.200
    18.239    41.125     0.200
    18.254    42.046     0.200
    18.325    41.404     0.200
    18.200    45.875     0.200
    18.443    42.442     0.200
    19.938    40.589     0.200
    20.001    39.361     0.200
    20.363    39.935     0.200
    20.437    39.066     0.200
    20.567    38.849     0.200
    21.471    39.603     0.200
    21.653    37.880     0.200
    21.774    37.773     0.200
    22.108    36.564     0.200
    22.589    36.161     0.200
    22.880    35.564     0.200
    23.242    35.836     0.200
    24.344    33.276     0.200
    25.696    30.798     0.200
    28.155    22.507     0.200
    28.947    20.860     0.200
    28.947    21.160     0.200
    14.269    43.113     0.200
    14.417    39.387     0.200
    14.641    41.273     0.200
    15.114    44.046     0.200
    15.118    43.808     0.200
    15.179    38.484     0.200
    16.061    44.296     0.200
    17.015    41.062     0.200
    17.052    41.739     0.200
    17.267    42.125     0.200
    17.484    42.485     0.200
    17.539    41.949     0.200
    17.672    40.801     0.200
    17.642    41.446     0.200
    18.121    39.855     0.200
    20.617    36.026     0.200
    21.048    37.802     0.200
    21.017    36.759     0.200
    21.258    37.610     0.200
    21.277    38.522     0.200
    22.140    37.256     0.200
    22.290    36.706     0.200
    22.525    36.264     0.200
    27.399    26.303     0.200
    27.712    25.463     0.200
    27.834    24.505     0.200
    29.177    20.333     0.200
    20.315    37.878     0.200
    21.675    39.330     0.200
    22.409    36.848     0.200
    22.465    35.094     0.200
    25.549    29.995     0.200
    26.109    27.518     0.200
    27.278    27.618     0.200
    20.475    41.451     0.200
    22.113    37.883     0.200
    25.662    32.515     0.200
    20.555    40.569     0.200
    21.524    39.147     0.200
    21.653    38.673     0.200
    25.950    32.507     0.200
    19.902    39.262     0.200
    20.809    38.871     0.200
    15.130    41.160     0.200
    15.687    41.759     0.200
    17.480    43.246     0.200
    18.046    41.822     0.200
    19.960    41.403     0.200
    19.960    41.751     0.200
    20.299    39.832     0.200
    20.300    40.217     0.200
    20.300    40.217     0.200
    20.332    38.782     0.200
    20.586    38.979     0.200
    20.746    38.814     0.200
    20.746    38.853     0.200
    20.891    38.929     0.200
    20.893    38.199     0.200
    21.199    39.186     0.200
    21.208    39.720     0.200
    21.221    38.679     0.200
    21.366    38.982     0.200
    21.906    37.884     0.200
    21.945    37.020     0.200
    22.120    39.186     0.200
    22.196    39.293     0.200
    22.219    38.121     0.200
    22.274    39.388     0.200
    22.329    38.437     0.200
    22.329    38.187     0.200
    22.457    37.377     0.200
    22.716    39.129     0.200
    23.019    36.287     0.200
    23.127    36.326     0.200
    24.033    35.152     0.200
    24.650    34.752     0.200
    25.278    34.925     0.200
    26.144    33.226     0.200
    26.291    31.802     0.200
    28.424    22.013     0.200
    21.153    37.956     0.200
    22.019    39.327     0.200
    14.464    47.340     0.200
    14.557    45.752     0.200
    14.587    42.603     0.200
    14.584    41.941     0.200
    14.636    42.332     0.200
    14.671    44.427     0.200
    14.731    44.914     0.200
    14.861    43.397     0.200
    15.058    44.001     0.200
    15.427    44.195     0.200
    15.432    42.835     0.200
    15.515    42.974     0.200
    16.008    44.017     0.200
    16.404    46.195     0.200
    16.589    44.168     0.200
    17.201    43.488     0.200
    17.246    44.960     0.200
    17.277    43.206     0.200
    17.289    44.671     0.200
    17.341    45.362     0.200
    17.373    43.489     0.200
    17.429    43.534     0.200
    17.732    43.496     0.200
    17.850    43.919     0.200
    17.850    43.931     0.200
    17.879    45.388     0.200
    18.298    43.488     0.200
    18.316    42.973     0.200
    18.316    43.178     0.200
    18.437    42.827     0.200
    18.460    41.772     0.200
    18.571    42.404     0.200
    18.775    42.298     0.200
    18.845    42.191     0.200
    19.005    42.144     0.200
    19.057    41.901     0.200
    19.075    42.240     0.200
    19.855    41.223     0.200
    19.960    39.788     0.200
    20.149    39.707     0.200
    20.159    41.786     0.200
    20.461    40.646     0.200
    20.530    41.460     0.200
    20.555    42.386     0.200
    20.572    41.451     0.200
    20.572    41.451     0.200
    20.799    39.341     0.200
    20.927    40.410     0.200
    20.839    40.959     0.200
    20.839    41.341     0.200
    21.066    39.689     0.200
    21.054    41.203     0.200
    21.131    41.014     0.200
    21.143    38.290     0.200
    21.143    39.125     0.200
    21.180    39.465     0.200
    21.272    39.086     0.200
    21.360    41.255     0.200
    21.451    40.804     0.200
    21.509    40.414     0.200
    21.533    41.244     0.200
    21.705    39.237     0.200
    21.707    39.264     0.200
    21.853    40.883     0.200
    21.881    38.374     0.200
    22.119    39.967     0.200
    22.251    39.856     0.200
    22.270    38.493     0.200
    22.208    42.869     0.200
    22.312    37.757     0.200
    22.333    37.603     0.200
    22.479    39.472     0.200
    22.439    40.673     0.200
    22.439    40.969     0.200
    22.452    40.118     0.200
    22.532    36.980     0.200
    22.532    40.184     0.200
    22.544    39.837     0.200
    22.521    40.325     0.200
    22.550    42.762     0.200
    22.559    43.367     0.200
    22.636    40.406     0.200
    22.709    40.009     0.200
    22.687    39.567     0.200
    22.740    38.550     0.200
    22.859    41.326     0.200
    22.881    39.510     0.200
    22.799    41.651     0.200
    22.799    41.464     0.200
    22.871    39.626     0.200
    22.913    37.006     0.200
    22.913    39.131     0.200
    22.975    40.552     0.200
    23.089    40.140     0.200
    23.308    39.889     0.200
    23.315    38.442     0.200
    23.317    38.393     0.200
    23.365    36.957     0.200
    23.418    36.143     0.200
    23.479    38.631     0.200
    23.689    36.474     0.200
    23.689    36.021     0.200
    23.719    39.728     0.200
    23.719    39.235     0.200
    23.679    39.910     0.200
    23.999    38.759     0.200
    23.999    38.157     0.200
    24.003    39.710     0.200
    24.043    38.950     0.200
    24.081    39.010     0.200
    24.081    38.807     0.200
    24.237    37.683     0.200
    24.190    39.806     0.200
    24.252    39.904     0.200
    24.368    38.256     0.200
    24.474    39.722     0.200
    24.619    34.724     0.200
    24.984    35.470     0.200
    24.938    38.116     0.200
    25.138    34.670     0.200
    25.231    36.283     0.200
    25.388    34.550     0.200
    25.396    36.260     0.200
    25.396    36.760     0.200
    25.688    34.450     0.200
    25.762    31.251     0.200
    25.749    33.840     0.200
    25.834    36.810     0.200
    25.875    33.762     0.200
    26.035    35.430     0.200
    26.048    32.152     0.200
    26.304    31.380     0.200
    26.304    30.911     0.200
    26.328    31.180     0.200
    26.453    32.731     0.200
    26.613    30.454     0.200
    26.746    30.012     0.200
    27.302    28.418     0.200
    28.357    23.902     0.200
    28.994    25.940     0.200
    29.249    23.598     0.200
    29.670    23.005     0.200
    29.919    22.276     0.200
    29.919    21.752     0.200
    16.450    40.119     0.200
    20.040    39.838     0.200
    20.040    39.868     0.200
    25.219    32.700     0.200
    25.219    30.605     0.200
    18.507    39.820     0.200
    19.461    42.252     0.200
    19.869    41.213     0.200
    20.079    41.111     0.200
    20.098    40.888     0.200
    20.159    39.740     0.200
    20.168    40.806     0.200
    20.525    41.373     0.200
    21.487    41.445     0.200
    21.602    40.998     0.200
    21.816    38.115     0.200
    21.959    41.038     0.200
    21.969    39.815     0.200
    22.096    40.232     0.200
    22.167    39.003     0.200
    22.167    37.425     0.200
    22.210    38.705     0.200
    22.297    38.188     0.200
    22.297    37.688     0.200
    22.547    38.863     0.200
    22.596    39.299     0.200
    22.678    38.750     0.200
    22.719    37.458     0.200
    22.973    39.701     0.200
    23.181    39.171     0.200
    23.200    39.849     0.200
    23.338    36.940     0.200
    23.341    38.904     0.200
    23.407    38.738     0.200
    23.421    38.469     0.200
    23.563    37.210     0.200
    23.666    36.535     0.200
    23.666    36.809     0.200
    23.716    37.137     0.200
    23.932    34.901     0.200
    23.932    37.011     0.200
    24.391    34.848     0.200
    24.442    32.752     0.200
    24.499    34.393     0.200
    24.592    37.405     0.200
    24.708    35.150     0.200
    24.708    34.252     0.200
    24.888    35.044     0.200
    24.996    34.894     0.200
    25.042    35.850     0.200
    25.060    31.945     0.200
    25.155    34.240     0.200
    25.155    35.138     0.200
    25.298    33.972     0.200
    25.416    32.445     0.200
    25.436    33.558     0.200
    25.619    35.118     0.200
    25.648    33.512     0.200
    25.648    34.880     0.200
    25.727    34.563     0.200
    26.873    30.982     0.200
    27.240    29.410     0.200
    27.856    27.538     0.200
    28.098    26.790     0.200
    17.903    39.624     0.200
    19.500    38.474     0.200
    19.507    38.432     0.200
    21.163    36.555     0.200
    21.313    36.556     0.200
    21.654    38.770     0.200
    21.972    37.459     0.200
    22.133    38.477     0.200
    22.316    35.742     0.200
    22.367    34.954     0.200
    22.424    34.390     0.200
    22.760    35.596     0.200
    22.778    36.853     0.200
    22.862    35.141     0.200
    22.862    35.473     0.200
    23.199    34.581     0.200
    23.401    34.588     0.200
    23.434    33.594     0.200
    23.637    34.032     0.200
    25.343    31.819     0.200
    25.358    30.794     0.200
    25.660    32.714     0.200
    25.808    28.391     0.200
    26.420    28.125     0.200
    26.420    29.457     0.200
    27.786    25.009     0.200
    16.296    46.568     0.200
    17.544    41.919     0.200
    17.575    43.930     0.200
    19.669    40.910     0.200
    19.729    39.361     0.200
    20.010    40.445     0.200
    20.007    39.527     0.200
    20.012    39.560     0.200
    20.012    39.470     0.200
    20.578    39.315     0.200
    20.639    39.908     0.200
    20.736    40.180     0.200
    21.051    40.676     0.200
    21.132    39.187     0.200
    21.214    38.632     0.200
    21.814    40.238     0.200
    22.021    37.064     0.200
    22.375    37.782     0.200
    22.375    36.583     0.200
    22.489    37.057     0.200
    22.506    37.458     0.200
    22.506    36.558     0.200
    22.751    38.196     0.200
    22.922    35.664     0.200
    23.405    35.047     0.200
    23.547    35.005     0.200
    23.547    36.707     0.200
    23.616    35.506     0.200
    23.616    40.400     0.200
    23.926    39.092     0.200
    24.138    33.940     0.200
    24.138    34.414     0.200
    24.405    34.002     0.200
    24.600    32.525     0.200
    24.914    32.359     0.200
    24.980    32.490     0.200
    25.112    32.544     0.200
    25.266    35.052     0.200
    25.219    32.617     0.200
    25.239    32.561     0.200
    25.329    34.014     0.200
    25.329    35.363     0.200
    25.531    31.955     0.200
    25.656    31.693     0.200
    25.778    32.708     0.200
    25.778    33.579     0.200
    26.263    31.612     0.200
    28.040    25.741     0.200
    28.040    25.972     0.200
    28.289    24.768     0.200
    28.291    24.749     0.200
    20.360    36.595     0.200
    21.787    39.101     0.200
    20.593    38.102     0.200
    20.932    38.849     0.200
    20.937    38.545     0.200
    20.956    40.619     0.200
    20.956    39.376     0.200
    21.066    39.372     0.200
    21.066    38.911     0.200
    21.502    39.107     0.200
    22.106    39.176     0.200
    23.212    37.672     0.200
    26.469    29.042     0.200
    26.715    27.982     0.200
    20.222    38.343     0.200
    21.723    39.830     0.200
    20.238    37.713     0.200
    16.942    41.125     0.200
    17.294    40.014     0.200
    17.359    39.321     0.200
    17.395    40.534     0.200
    17.565    39.503     0.200
    17.533    39.946     0.200
    17.610    38.777     0.200
    17.894    39.203     0.200
    17.865    39.271     0.200
    17.910    39.642     0.200
    18.112    40.519     0.200
    18.104    42.496     0.200
    18.296    41.181     0.200
    19.640    37.702     0.200
    19.673    38.640     0.200
    19.830    38.748     0.200
    19.913    37.319     0.200
    20.239    37.150     0.200
    20.239    37.025     0.200
    20.239    36.330     0.200
    20.266    37.005     0.200
    20.363    37.657     0.200
    20.363    36.746     0.200
    20.679    37.394     0.200
    20.833    36.276     0.200
    20.856    38.693     0.200
    20.856    38.002     0.200
    21.297    36.581     0.200
    21.303    36.573     0.200
    21.308    36.438     0.200
    21.315    36.018     0.200
    21.318    36.021     0.200
    21.321    37.592     0.200
    21.325    35.875     0.200
    21.328    36.234     0.200
    21.335    35.935     0.200
    21.358    35.846     0.200
    21.399    35.965     0.200
    21.471    35.822     0.200
    21.596    36.758     0.200
    21.675    35.236     0.200
    21.710    36.063     0.200
    21.774    35.189     0.200
    21.870    35.070     0.200
    22.023    35.045     0.200
    22.023    35.201     0.200
    22.023    34.873     0.200
    21.646    38.922     0.200
    22.456    35.427     0.200
    22.512    34.271     0.200
    22.528    35.085     0.200
    22.588    34.888     0.200
    22.615    36.978     0.200
    22.799    35.110     0.200
    22.799    34.821     0.200
    22.799    34.313     0.200
    23.081    34.938     0.200
    23.155    34.842     0.200
    23.558    34.889     0.200
    23.555    35.039     0.200
    23.555    34.121     0.200
    23.990    34.190     0.200
    24.116    32.757     0.200
    24.256    31.637     0.200
    24.256    31.895     0.200
    24.427    32.929     0.200
    24.672    33.005     0.200
    25.231    31.312     0.200
    25.532    30.789     0.200
    25.596    30.082     0.200
    26.154    27.970     0.200
    26.154    29.321     0.200
    26.316    27.853     0.200
    26.316    29.144     0.200
    26.316    28.167     0.200
    26.725    28.401     0.200
    26.781    28.054     0.200
    27.138    28.085     0.200
    27.239    26.360     0.200
    28.947    18.733     0.200
    29.860    15.146     0.200
    29.860    16.341     0.200
    19.110    40.200     0.200
    19.569    39.603     0.200
    20.103    39.698     0.200
    20.103    40.409     0.200
    20.103    40.550     0.200
    20.237    40.804     0.200
    20.237    40.929     0.200
    21.159    39.393     0.200
    21.672    38.348     0.200
    21.860    37.937     0.200
    21.898    40.579     0.200
    25.691    34.072     0.200
    26.029    31.939     0.200
    27.255    26.945     0.200
    17.416    42.075     0.200
    17.773    44.323     0.200
    17.868    41.998     0.200
    19.388    38.606     0.200
    20.007    39.223     0.200
    20.567    39.092     0.200
    20.711    39.861     0.200
    20.711    38.445     0.200
    20.711    39.740     0.200
    20.838    40.738     0.200
    20.838    39.369     0.200
    21.101    38.350     0.200
    21.409    37.920     0.200
    21.595    37.724     0.200
    21.825    37.428     0.200
    21.825    37.237     0.200
    21.843    36.279     0.200
    21.947    39.795     0.200
    22.486    37.648     0.200
    22.667    39.051     0.200
    22.911    35.976     0.200
    23.060    35.503     0.200
    23.262    36.820     0.200
    25.082    34.495     0.200
    25.463    34.460     0.200
    26.534    28.002     0.200
    26.534    29.306     0.200
    26.722    28.693     0.200
    26.727    29.853     0.200
    27.030    27.172     0.200
    27.504    28.568     0.200
    29.316    20.999     0.200
    20.711    38.311     0.200
    21.191    38.504     0.200
    16.693    42.483     0.200
    18.493    40.247     0.200
    20.792    40.882     0.200
    21.222    37.878     0.200
    26.239    30.830     0.200
    21.923    39.602     0.200
    15.293    43.971     0.200
    16.107    42.134     0.200
    17.037    44.292     0.200
    17.586    42.055     0.200
    17.586    43.313     0.200
    18.045    43.261     0.200
    18.391    42.622     0.200
    18.436    42.222     0.200
    19.009    41.290     0.200
    19.100    39.902     0.200
    19.120    40.951     0.200
    19.246    41.081     0.200
    19.268    40.615     0.200
    19.358    40.661     0.200
    19.374    42.525     0.200
    19.570    43.068     0.200
    19.694    40.849     0.200
    19.694    42.490     0.200
    19.732    42.046     0.200
    19.853    41.116     0.200
    19.871    40.074     0.200
    19.983    41.249     0.200
    19.983    41.413     0.200
    20.033    40.893     0.200
    20.142    39.829     0.200
    20.081    40.346     0.200
    20.081    40.080     0.200
    20.081    40.431     0.200
    20.272    41.145     0.200
    20.272    41.333     0.200
    20.283    39.987     0.200
    20.534    39.731     0.200
    20.640    39.057     0.200
    20.796    39.595     0.200
    20.813    39.688     0.200
    20.836    40.348     0.200
    20.838    40.044     0.200
    20.838    40.333     0.200
    20.868    40.160     0.200
    20.958    38.500     0.200
    20.958    37.969     0.200
    21.252    39.611     0.200
    21.300    39.589     0.200
    21.342    38.560     0.200
    21.342    38.739     0.200
    21.342    37.872     0.200
    21.342    38.739     0.200
    21.480    38.582     0.200
    21.480    39.020     0.200
    21.620    39.492     0.200
    21.620    38.448     0.200
    21.732    38.692     0.200
    21.766    41.088     0.200
    21.766    38.698     0.200
    21.844    38.020     0.200
    21.908    38.622     0.200
    21.941    38.664     0.200
    21.984    38.446     0.200
    22.351    36.934     0.200
    22.486    37.430     0.200
    22.515    37.544     0.200
    22.528    38.705     0.200
    22.528    37.650     0.200
    22.591    38.757     0.200
    22.591    37.257     0.200
    22.671    38.122     0.200
    22.806    37.210     0.200
    22.824    36.645     0.200
    22.824    37.137     0.200
    22.867    38.417     0.200
    22.870    37.802     0.200
    22.884    38.496     0.200
    22.884    37.597     0.200
    23.080    36.352     0.200
    23.080    36.954     0.200
    23.080    36.712     0.200
    23.573    37.100     0.200
    23.573    37.459     0.200
    23.617    35.893     0.200
    23.647    36.537     0.200
    23.662    36.162     0.200
    23.702    36.291     0.200
    23.791    35.459     0.200
    23.791    35.975     0.200
    23.856    34.830     0.200
    23.856    36.002     0.200
    23.856    35.893     0.200
    25.482    31.921     0.200
    25.509    33.387     0.200
    25.682    32.012     0.200
    26.866    28.401     0.200
    20.540    40.546     0.200
    21.657    38.648     0.200
    25.887    31.940     0.200
    20.560    40.316     0.200
    21.654    38.970     0.200
    14.301    41.322     0.200
    14.404    40.936     0.200
    15.864    42.410     0.200
    15.864    42.230     0.200
    16.114    46.145     0.200
    16.143    45.160     0.200
    17.126    44.359     0.200
    17.133    42.743     0.200
    17.298    44.605     0.200
    17.678    43.043     0.200
    17.772    43.025     0.200
    17.783    42.476     0.200
    17.783    43.126     0.200
    17.835    43.856     0.200
    17.927    42.308     0.200
    18.088    39.790     0.200
    18.150    42.593     0.200
    18.318    43.545     0.200
    18.549    42.092     0.200
    18.639    41.455     0.200
    18.693    41.529     0.200
    18.693    41.968     0.200
    18.693    43.000     0.200
    18.701    41.454     0.200
    18.717    41.439     0.200
    18.756    41.577     0.200
    18.863    41.959     0.200
    18.863    42.280     0.200
    18.873    42.194     0.200
    18.953    41.258     0.200
    18.975    41.101     0.200
    19.015    41.854     0.200
    19.015    41.679     0.200
    19.122    41.784     0.200
    19.226    41.398     0.200
    19.226    42.439     0.200
    19.262    43.224     0.200
    19.342    41.851     0.200
    19.434    41.439     0.200
    19.489    44.951     0.200
    19.504    41.567     0.200
    19.547    41.679     0.200
    19.574    40.671     0.200
    19.681    40.945     0.200
    19.681    41.132     0.200
    19.708    41.350     0.200
    19.847    40.428     0.200
    19.928    40.969     0.200
    19.928    41.848     0.200
    19.963    41.319     0.200
    19.963    42.038     0.200
    20.000    40.834     0.200
    20.109    40.511     0.200
    20.127    38.744     0.200
    20.161    40.664     0.200
    20.210    43.104     0.200
    20.231    40.684     0.200
    20.266    44.105     0.200
    20.235    40.613     0.200
    20.315    40.659     0.200
    20.331    40.652     0.200
    20.431    40.009     0.200
    20.506    44.108     0.200
    20.515    40.245     0.200
    20.545    40.478     0.200
    20.561    40.931     0.200
    20.561    39.906     0.200
    20.553    39.589     0.200
    20.553    44.149     0.200
    20.596    40.285     0.200
    20.596    41.580     0.200
    20.590    40.798     0.200
    20.668    43.791     0.200
    20.658    39.306     0.200
    20.658    39.627     0.200
    20.749    39.643     0.200
    20.842    43.881     0.200
    20.876    38.305     0.200
    20.876    40.420     0.200
    20.927    41.193     0.200
    20.944    40.250     0.200
    20.944    39.824     0.200
    20.944    40.099     0.200
    20.978    43.840     0.200
    20.966    40.388     0.200
    20.966    39.957     0.200
    20.966    40.097     0.200
    21.035    38.946     0.200
    21.049    39.573     0.200
    21.049    38.727     0.200
    21.113    42.913     0.200
    21.116    40.225     0.200
    21.157    38.729     0.200
    21.190    39.228     0.200
    21.190    39.109     0.200
    21.190    38.878     0.200
    21.190    40.308     0.200
    21.196    40.024     0.200
    21.196    40.473     0.200
    21.325    38.133     0.200
    21.377    39.696     0.200
    21.447    41.910     0.200
    21.447    41.600     0.200
    21.459    38.698     0.200
    21.459    39.428     0.200
    21.503    41.906     0.200
    21.503    40.138     0.200
    21.503    41.646     0.200
    21.539    38.552     0.200
    21.557    38.176     0.200
    21.563    39.243     0.200
    21.563    40.220     0.200
    21.539    40.278     0.200
    21.568    39.606     0.200
    21.628    40.921     0.200
    21.601    38.164     0.200
    21.630    38.358     0.200
    21.630    38.813     0.200
    21.633    38.450     0.200
    21.642    40.895     0.200
    21.670    41.121     0.200
    21.693    38.836     0.200
    21.686    40.593     0.200
    21.704    40.818     0.200
    21.720    39.352     0.200
    21.766    38.770     0.200
    21.775    40.781     0.200
    21.781    39.431     0.200
    21.881    38.984     0.200
    21.969    41.679     0.200
    21.969    43.029     0.200
    21.951    38.918     0.200
    21.963    38.465     0.200
    21.963    38.929     0.200
    21.982    37.696     0.200
    21.990    38.985     0.200
    22.023    39.659     0.200
    22.106    38.850     0.200
    22.105    39.403     0.200
    22.136    39.558     0.200
    22.166    37.930     0.200
    22.166    39.524     0.200
    22.166    40.213     0.200
    22.187    38.388     0.200
    22.168    38.277     0.200
    22.236    40.379     0.200
    22.219    38.298     0.200
    22.219    38.060     0.200
    22.201    39.173     0.200
    22.255    40.613     0.200
    22.239    37.771     0.200
    22.239    37.371     0.200
    22.246    39.585     0.200
    22.244    38.530     0.200
    22.245    39.664     0.200
    22.256    38.860     0.200
    22.295    39.130     0.200
    22.295    40.978     0.200
    22.276    39.301     0.200
    22.366    35.935     0.200
    22.400    40.316     0.200
    22.400    40.146     0.200
    22.432    38.716     0.200
    22.485    40.088     0.200
    22.491    41.173     0.200
    22.531    36.964     0.200
    22.531    38.964     0.200
    22.531    37.160     0.200
    22.531    38.765     0.200
    22.531    37.675     0.200
    22.561    41.607     0.200
    22.524    37.554     0.200
    22.564    38.177     0.200
    22.564    38.398     0.200
    22.603    36.789     0.200
    22.603    37.932     0.200
    22.631    39.502     0.200
    22.659    38.710     0.200
    22.659    39.368     0.200
    22.713    39.019     0.200
    22.663    38.354     0.200
    22.700    38.854     0.200
    22.700    38.041     0.200
    22.700    38.725     0.200
    22.728    37.659     0.200
    22.781    37.167     0.200
    22.781    36.874     0.200
    22.781    37.048     0.200
    22.781    37.548     0.200
    22.781    37.337     0.200
    22.776    37.474     0.200
    22.868    36.644     0.200
    22.890    37.039     0.200
    23.016    37.677     0.200
    23.039    35.954     0.200
    23.063    36.657     0.200
    23.063    37.968     0.200
    23.065    37.373     0.200
    23.060    38.728     0.200
    23.128    37.465     0.200
    23.159    38.451     0.200
    23.223    37.367     0.200
    23.223    38.045     0.200
    23.210    39.619     0.200
    23.221    37.472     0.200
    23.221    37.879     0.200
    23.243    35.543     0.200
    23.253    37.197     0.200
    23.253    37.718     0.200
    23.282    36.497     0.200
    23.282    36.907     0.200
    23.324    36.406     0.200
    23.324    38.008     0.200
    23.324    36.867     0.200
    23.366    37.002     0.200
    23.411    35.788     0.200
    23.413    36.857     0.200
    23.450    36.539     0.200
    23.470    35.220     0.200
    23.481    37.003     0.200
    23.487    35.901     0.200
    23.487    41.040     0.200
    23.484    36.657     0.200
    23.556    35.785     0.200
    23.556    35.303     0.200
    23.556    36.397     0.200
    23.556    36.096     0.200
    23.605    39.749     0.200
    23.641    37.160     0.200
    23.641    36.000     0.200
    23.641    37.310     0.200
    23.688    35.224     0.200
    23.688    36.993     0.200
    23.737    36.034     0.200
    23.726    36.187     0.200
    23.724    36.099     0.200
    23.724    39.734     0.200
    23.747    35.912     0.200
    23.747    35.443     0.200
    23.747    36.834     0.200
    23.771    35.990     0.200
    23.768    35.601     0.200
    23.768    35.122     0.200
    23.768    35.911     0.200
    23.768    35.771     0.200
    23.797    36.572     0.200
    23.902    35.969     0.200
    23.925    36.031     0.200
    23.982    35.183     0.200
    24.047    34.668     0.200
    24.244    36.801     0.200
    24.244    34.401     0.200
    24.314    35.155     0.200
    24.383    34.901     0.200
    24.399    38.658     0.200
    24.399    38.848     0.200
    24.391    37.929     0.200
    24.410    34.918     0.200
    24.635    33.739     0.200
    24.637    35.924     0.200
    24.640    33.787     0.200
    24.679    33.706     0.200
    24.679    34.202     0.200
    24.669    35.387     0.200
    24.700    34.816     0.200
    24.703    33.627     0.200
    24.736    33.959     0.200
    24.753    34.142     0.200
    24.753    35.578     0.200
    24.753    35.433     0.200
    24.798    34.179     0.200
    24.798    34.509     0.200
    24.751    35.150     0.200
    24.836    34.646     0.200
    24.927    32.166     0.200
    24.927    33.516     0.200
    24.985    32.852     0.200
    24.985    33.593     0.200
    24.985    33.923     0.200
    25.010    33.907     0.200
    25.033    33.376     0.200
    25.080    33.885     0.200
    25.080    35.225     0.200
    25.176    32.900     0.200
    25.133    33.492     0.200
    25.171    34.342     0.200
    25.171    35.131     0.200
    25.171    35.320     0.200
    25.316    34.164     0.200
    25.342    33.183     0.200
    25.529    32.575     0.200
    25.572    33.040     0.200
    25.572    33.335     0.200
    25.623    32.624     0.200
    25.656    32.289     0.200
    25.741    30.155     0.200
    25.741    32.075     0.200
    25.730    31.287     0.200
    25.783    31.907     0.200
    25.787    31.025     0.200
    25.787    31.371     0.200
    25.783    31.670     0.200
    25.799    31.629     0.200
    25.832    31.886     0.200
    25.832    31.488     0.200
    25.832    32.056     0.200
    25.832    32.668     0.200
    25.812    31.334     0.200
    25.922    31.340     0.200
    25.922    31.786     0.200
    25.922    31.985     0.200
    25.922    32.096     0.200
    25.905    31.747     0.200
    26.087    31.496     0.200
    26.087    30.701     0.200
    26.087    30.867     0.200
    26.087    31.666     0.200
    26.087    31.767     0.200
    26.087    31.107     0.200
    26.191    30.549     0.200
    26.172    30.876     0.200
    26.176    30.858     0.200
    26.243    30.459     0.200
    26.243    31.039     0.200
    26.346    31.534     0.200
    26.384    29.096     0.200
    26.415    30.537     0.200
    26.446    30.583     0.200
    26.446    33.972     0.200
    26.536    29.645     0.200
    26.536    30.324     0.200
    26.536    30.504     0.200
    26.555    32.743     0.200
    26.629    29.521     0.200
    26.637    33.412     0.200
    26.822    29.401     0.200
    26.822    28.796     0.200
    26.822    29.282     0.200
    26.824    29.227     0.200
    26.821    28.254     0.200
    26.825    29.656     0.200
    26.833    29.040     0.200
    26.846    29.411     0.200
    26.843    31.244     0.200
    26.843    31.424     0.200
    27.107    28.076     0.200
    27.118    27.952     0.200
    27.175    27.676     0.200
    27.175    28.668     0.200
    27.175    29.918     0.200
    27.193    28.252     0.200
    27.332    26.342     0.200
    27.332    28.436     0.200
    27.332    27.346     0.200
    27.424    27.449     0.200
    27.686    24.711     0.200
    27.924    24.823     0.200
    27.932    25.999     0.200
    27.932    27.827     0.200
    28.035    24.720     0.200
    28.551    21.409     0.200
    28.734    25.776     0.200
    28.799    24.212     0.200
    28.834    23.909     0.200
    28.890    23.753     0.200
    28.911    21.460     0.200
    28.911    23.200     0.200
    28.911    24.299     0.200
    28.975    21.338     0.200
    29.289    22.499     0.200
    17.417    42.164     0.200
    20.119    42.223     0.200
    20.071    40.913     0.200
    20.748    39.702     0.200
    20.779    38.817     0.200
    20.779    38.457     0.200
    20.995    41.441     0.200
    21.169    38.116     0.200
    21.169    38.292     0.200
    21.310    38.008     0.200
    21.310    38.636     0.200
    21.310    38.195     0.200
    21.445    40.053     0.200
    21.660    38.414     0.200
    21.755    37.147     0.200
    21.813    40.962     0.200
    22.079    40.746     0.200
    22.305    39.531     0.200
    22.358    37.299     0.200
    22.358    37.951     0.200
    22.648    37.458     0.200
    22.648    37.619     0.200
    22.648    37.880     0.200
    22.645    35.756     0.200
    22.645    36.096     0.200
    22.685    36.582     0.200
    22.685    38.270     0.200
    22.721    38.173     0.200
    22.801    38.611     0.200
    22.901    37.760     0.200
    22.901    35.772     0.200
    23.184    40.072     0.200
    23.402    38.722     0.200
    23.402    39.480     0.200
    23.444    37.738     0.200
    23.487    36.169     0.200
    23.531    37.812     0.200
    23.677    36.529     0.200
    23.677    37.408     0.200
    23.677    37.048     0.200
    24.023    35.182     0.200
    24.318    34.534     0.200
    24.863    33.439     0.200
    25.745    34.351     0.200
    25.745    33.886     0.200
    26.944    27.957     0.200
    14.399    41.359     0.200
    15.916    41.294     0.200
    16.912    42.775     0.200
    16.995    44.496     0.200
    17.050    41.787     0.200
    17.680    41.536     0.200
    17.771    43.175     0.200
    18.089    41.617     0.200
    18.149    41.863     0.200
    18.345    42.073     0.200
    18.755    41.126     0.200
    18.974    41.035     0.200
    19.071    44.328     0.200
    19.428    41.514     0.200
    19.574    40.447     0.200
    19.714    41.114     0.200
    20.148    39.564     0.200
    20.148    39.713     0.200
    20.428    40.764     0.200
    20.557    38.737     0.200
    20.559    43.211     0.200
    20.659    39.904     0.200
    20.946    40.138     0.200
    20.946    39.560     0.200
    20.975    39.428     0.200
    20.975    40.108     0.200
    21.049    38.879     0.200
    21.049    39.488     0.200
    21.049    38.832     0.200
    21.325    39.311     0.200
    21.540    38.763     0.200
    21.635    39.361     0.200
    21.692    40.920     0.200
    22.022    39.109     0.200
    22.170    39.124     0.200
    22.219    38.875     0.200
    22.219    38.281     0.200
    22.238    38.957     0.200
    22.366    39.056     0.200
    22.527    38.277     0.200
    22.524    37.413     0.200
    22.524    37.523     0.200
    22.566    37.629     0.200
    22.601    39.220     0.200
    22.601    39.486     0.200
    22.781    37.137     0.200
    22.781    37.629     0.200
    23.281    37.879     0.200
    23.281    38.239     0.200
    23.265    37.423     0.200
    23.557    36.687     0.200
    23.557    36.366     0.200
    23.557    37.304     0.200
    23.903    39.186     0.200
    24.739    33.033     0.200
    25.318    34.711     0.200
    25.848    30.805     0.200
    25.848    31.070     0.200
    26.543    29.332     0.200
    26.828    28.812     0.200
    20.116    40.071     0.200
    21.130    37.889     0.200
    16.294    41.287     0.200
    16.294    39.819     0.200
    16.480    42.916     0.200
    16.861    42.096     0.200
    17.120    41.547     0.200
    17.120    40.314     0.200
    17.167    39.947     0.200
    17.228    41.090     0.200
    17.244    41.288     0.200
    17.366    40.161     0.200
    17.397    41.047     0.200
    17.503    41.001     0.200
    17.515    41.353     0.200
    17.561    40.311     0.200
    17.694    40.780     0.200
    17.769    42.109     0.200
    17.994    39.894     0.200
    18.067    40.896     0.200
    18.141    42.148     0.200
    18.309    40.253     0.200
    18.584    39.668     0.200
    19.438    37.960     0.200
    19.454    38.563     0.200
    19.476    39.142     0.200
    19.473    39.449     0.200
    19.500    39.022     0.200
    19.549    39.138     0.200
    19.531    39.252     0.200
    19.757    37.854     0.200
    19.757    37.380     0.200
    20.071    37.485     0.200
    20.071    38.079     0.200
    20.071    37.024     0.200
    20.121    39.221     0.200
    20.192    38.253     0.200
    20.192    38.792     0.200
    20.192    38.042     0.200
    20.322    38.141     0.200
    20.531    37.732     0.200
    20.603    37.915     0.200
    20.683    37.012     0.200
    20.806    37.920     0.200
    20.805    37.537     0.200
    20.901    37.868     0.200
    21.060    37.019     0.200
    21.077    38.324     0.200
    21.109    37.947     0.200
    21.226    38.382     0.200
    21.260    35.825     0.200
    21.260    37.376     0.200
    21.287    38.494     0.200
    21.407    36.512     0.200
    21.407    37.412     0.200
    21.407    38.682     0.200
    21.528    38.506     0.200
    21.528    40.125     0.200
    21.501    36.632     0.200
    21.501    36.022     0.200
    21.501    37.704     0.200
    21.616    35.376     0.200
    21.616    35.585     0.200
    21.721    36.114     0.200
    21.721    36.444     0.200
    21.864    35.546     0.200
    21.864    34.306     0.200
    21.864    34.677     0.200
    21.864    35.038     0.200
    21.920    38.256     0.200
    21.992    37.347     0.200
    22.202    38.869     0.200
    22.285    34.831     0.200
    22.343    35.886     0.200
    22.343    34.947     0.200
    22.413    35.675     0.200
    22.360    38.049     0.200
    22.564    35.714     0.200
    22.634    35.592     0.200
    22.640    33.394     0.200
    22.640    34.429     0.200
    22.640    35.029     0.200
    22.640    35.279     0.200
    22.673    36.039     0.200
    22.984    36.628     0.200
    23.020    34.203     0.200
    23.020    36.627     0.200
    23.015    35.598     0.200
    23.364    35.776     0.200
    23.446    34.853     0.200
    23.491    35.692     0.200
    23.467    35.489     0.200
    23.889    34.056     0.200
    23.996    32.784     0.200
    24.311    32.265     0.200
    24.533    31.881     0.200
    24.714    31.032     0.200
    24.891    32.774     0.200
    24.891    33.055     0.200
    25.135    31.238     0.200
    25.455    27.876     0.200
    25.436    30.342     0.200
    25.436    28.999     0.200
    25.436    29.928     0.200
    25.808    29.660     0.200
    26.058    29.322     0.200
    26.058    27.343     0.200
    26.058    26.433     0.200
    26.058    29.462     0.200
    26.198    28.869     0.200
    26.199    27.668     0.200
    26.199    28.791     0.200
    26.627    27.654     0.200
    26.684    27.198     0.200
    26.684    26.456     0.200
    26.714    27.587     0.200
    27.505    25.230     0.200
    28.010    22.058     0.200
    28.063    19.142     0.200
    28.366    21.643     0.200
    28.571    23.313     0.200
    28.712    18.573     0.200
    28.890    18.488     0.200
    29.118    20.731     0.200
    29.699    14.550     0.200
    29.713    17.242     0.200
    29.725    15.670     0.200
    20.381    40.838     0.200
    21.025    42.428     0.200
    21.237    42.983     0.200
    21.386    42.405     0.200
    21.997    41.215     0.200
    22.011    38.862     0.200
    22.140    38.342     0.200
    22.645    39.143     0.200
    22.684    40.462     0.200
    25.633    34.077     0.200
    21.802    39.203     0.200
    17.747    43.157     0.200
    18.144    41.900     0.200
    18.419    41.257     0.200
    18.561    40.734     0.200
    18.894    38.665     0.200
    19.457    40.509     0.200
    20.022    40.145     0.200
    20.146    38.962     0.200
    20.147    38.966     0.200
    20.276    38.312     0.200
    20.381    39.908     0.200
    20.655    38.682     0.200
    20.655    37.901     0.200
    20.655    38.342     0.200
    20.655    38.131     0.200
    20.559    40.000     0.200
    20.559    41.068     0.200
    20.793    38.023     0.200
    20.934    38.612     0.200
    21.042    39.680     0.200
    21.264    39.741     0.200
    21.297    40.044     0.200
    21.401    38.166     0.200
    21.522    39.025     0.200
    21.707    37.979     0.200
    21.707    39.270     0.200
    21.778    39.439     0.200
    21.840    39.218     0.200
    22.141    36.926     0.200
    22.141    37.484     0.200
    22.192    37.950     0.200
    22.192    38.483     0.200
    22.397    37.163     0.200
    22.397    37.403     0.200
    22.688    39.314     0.200
    22.886    37.460     0.200
    22.930    35.061     0.200
    22.930    36.841     0.200
    22.960    38.305     0.200
    23.117    35.496     0.200
    23.117    35.341     0.200
    23.173    37.189     0.200
    26.293    29.952     0.200
    26.293    31.308     0.200
    26.493    27.284     0.200
    18.887    45.313     0.200
    18.887    41.233     0.200
    19.365    40.794     0.200
    19.429    43.160     0.200
    19.447    43.065     0.200
    19.670    41.472     0.200
    19.721    44.283     0.200
    19.790    43.642     0.200
    19.790    41.331     0.200
    19.790    42.271     0.200
    19.797    41.792     0.200
    20.022    40.309     0.200
    20.022    43.751     0.200
    20.132    43.772     0.200
    20.132    43.463     0.200
    20.390    43.224     0.200
    20.495    42.118     0.200
    20.841    42.053     0.200
    20.841    41.184     0.200
    20.943    41.366     0.200
    20.977    41.240     0.200
    21.032    41.109     0.200
    21.062    41.353     0.200
    21.091    41.489     0.200
    21.091    41.300     0.200
    21.125    42.178     0.200
    21.354    41.625     0.200
    21.354    41.450     0.200
    21.480    39.662     0.200
    21.480    39.271     0.200
    21.663    41.347     0.200
    21.684    41.517     0.200
    21.684    41.165     0.200
    21.684    41.013     0.200
    21.708    42.700     0.200
    21.775    37.952     0.200
    21.838    39.366     0.200
    21.891    40.833     0.200
    22.054    40.642     0.200
    22.076    42.000     0.200
    22.185    40.917     0.200
    22.321    38.218     0.200
    22.321    38.744     0.200
    22.570    40.368     0.200
    22.634    39.872     0.200
    22.660    37.903     0.200
    22.655    39.411     0.200
    22.655    39.532     0.200
    22.655    38.577     0.200
    22.660    38.172     0.200
    22.733    41.286     0.200
    22.787    39.426     0.200
    22.787    36.977     0.200
    22.787    39.295     0.200
    22.871    38.264     0.200
    23.011    38.865     0.200
    23.147    38.677     0.200
    23.231    38.811     0.200
    23.231    36.911     0.200
    23.231    37.204     0.200
    23.292    37.284     0.200
    23.342    37.254     0.200
    23.451    38.617     0.200
    23.451    38.488     0.200
    23.470    37.120     0.200
    23.440    36.480     0.200
    23.450    36.470     0.200
    23.567    39.291     0.200
    23.591    37.140     0.200
    23.767    39.438     0.200
    23.767    40.258     0.200
    23.767    38.258     0.200
    23.825    36.054     0.200
    23.960    36.391     0.200
    23.960    37.702     0.200
    24.140    36.848     0.200
    24.183    35.154     0.200
    24.183    34.894     0.200
    24.183    36.013     0.200
    24.238    38.062     0.200
    24.264    37.449     0.200
    24.264    35.959     0.200
    24.264    35.349     0.200
    24.287    37.352     0.200
    24.363    38.884     0.200
    24.435    34.860     0.200
    24.435    34.429     0.200
    24.435    34.116     0.200
    24.467    36.417     0.200
    24.841    37.573     0.200
    24.934    36.132     0.200
    24.993    34.185     0.200
    25.086    33.919     0.200
    25.124    34.077     0.200
    25.124    34.416     0.200
    25.211    32.696     0.200
    25.211    33.107     0.200
    25.210    35.515     0.200
    25.210    33.245     0.200
    25.210    33.415     0.200
    25.210    34.015     0.200
    25.302    34.090     0.200
    26.211    30.749     0.200
    26.495    29.039     0.200
    28.409    24.279     0.200
    17.296    41.389     0.200
    17.299    41.853     0.200
    17.776    41.027     0.200
    18.138    41.313     0.200
    18.792    42.733     0.200
    18.971    40.708     0.200
    19.493    41.887     0.200
    19.886    40.946     0.200
    19.886    40.313     0.200
    20.085    41.236     0.200
    20.725    39.223     0.200
    21.069    38.438     0.200
    21.069    38.589     0.200
    21.069    38.758     0.200
    21.198    38.987     0.200
    21.703    37.999     0.200
    21.997    39.575     0.200
    22.194    38.062     0.200
    22.212    35.578     0.200
    22.367    39.411     0.200
    22.587    36.765     0.200
    22.874    36.013     0.200
    23.344    37.365     0.200
    23.353    35.738     0.200
    23.403    36.228     0.200
    23.615    36.278     0.200
    26.359    29.781     0.200
    26.359    28.621     0.200
    28.285    23.434     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.163    10.533     0.200
     2.662    11.312     0.200
     8.367    25.745     0.200
     9.347    22.511     0.200
     9.915    27.475     0.200
    10.755    34.867     0.200
    10.836    30.923     0.200
    12.684    31.866     0.200
    13.486    31.998     0.200
    16.059    37.975     0.200
    17.392    35.714     0.200
    20.162    41.087     0.200
     1.376     8.247     0.200
     2.526    10.827     0.200
     2.591    13.072     0.200
     2.600    10.960     0.200
     3.212    13.817     0.200
     4.327    13.607     0.200
     5.619    18.931     0.200
     7.360    22.417     0.200
     7.878    22.872     0.200
    18.955    42.098     0.200
    19.625    41.276     0.200
    20.859    40.883     0.200
     1.474    11.793     0.200
     2.146    12.948     0.200
     2.525    13.522     0.200
     4.815    17.804     0.200
     4.815    18.804     0.200
     5.673    21.291     0.200
     5.673    21.791     0.200
    19.016    44.078     0.200
    19.558    42.755     0.200
    20.423    41.652     0.200
     1.370    10.343     0.200
     3.660    14.823     0.200
     5.573    19.693     0.200
     6.585    22.881     0.200
    14.706    38.511     0.200
    18.538    45.198     0.200
    18.672    42.425     0.200
    19.094    44.505     0.200
    19.167    42.647     0.200
    19.714    42.268     0.200
    20.580    42.665     0.200
     0.969     9.613     0.200
     1.672    10.409     0.200
     1.828    10.091     0.200
     1.828    11.291     0.200
     2.357    13.909     0.200
     2.882    14.581     0.200
     3.410    17.721     0.200
     3.963    15.669     0.200
     6.081    22.458     0.200
     7.309    21.424     0.200
     7.882    24.438     0.200
    19.476    42.137     0.200
    20.365    40.759     0.200
     1.506     8.845     0.200
     1.822     9.862     0.200
     2.760    12.406     0.200
     3.206    14.207     0.200
     3.606    14.543     0.200
     4.058    17.265     0.200
     4.169    19.268     0.200
     5.042    18.278     0.200
     6.219    19.541     0.200
     6.249    19.199     0.200
     6.586    20.262     0.200
     7.272    21.756     0.200
     7.300    20.730     0.200
     8.221    23.185     0.200
     9.343    28.193     0.200
    10.609    27.509     0.200
    10.804    30.541     0.200
    12.362    31.653     0.200
    12.461    29.501     0.200
    13.793    33.961     0.200
    14.120    34.837     0.200
    14.932    39.162     0.200
    14.974    38.077     0.200
    15.220    37.103     0.200
    15.313    37.814     0.200
    15.377    37.366     0.200
    15.519    37.621     0.200
    15.696    38.447     0.200
    15.802    37.409     0.200
    19.315    40.215     0.200
    19.356    42.232     0.200
    19.732    43.144     0.200
    20.381    43.080     0.200
    20.574    42.022     0.200
    20.580    40.958     0.200
     1.569    10.107     0.200
     1.801    11.201     0.200
     2.598    11.900     0.200
     3.055    10.564     0.200
     3.870    11.051     0.200
     3.858    14.198     0.200
     4.720    18.129     0.200
     7.009    23.922     0.200
     7.665    22.170     0.200
    13.914    37.640     0.200
     2.580    13.637     0.200
     3.883    14.230     0.200
     3.860    14.996     0.200
     4.481    20.554     0.200
     4.572    16.891     0.200
     4.607    17.781     0.200
     7.010    22.239     0.200
     7.655    23.719     0.200
     9.153    28.229     0.200
    10.249    28.443     0.200
    11.219    32.124     0.200
    18.662    42.359     0.200
    20.783    40.513     0.200
     1.604    11.600     0.200
     1.940    12.681     0.200
     2.250    13.067     0.200
     2.454    13.187     0.200
     4.599    20.145     0.200
     4.857    18.342     0.200
     5.448    20.846     0.200
     5.546    20.199     0.200
     5.458    20.724     0.200
     5.521    21.793     0.200
     5.656    20.310     0.200
     5.778    19.390     0.200
     5.894    20.037     0.200
     6.733    23.843     0.200
     7.089    24.097     0.200
     7.073    24.273     0.200
     7.476    23.780     0.200
     7.653    25.514     0.200
     7.703    25.425     0.200
     8.014    25.794     0.200
     8.156    24.440     0.200
     8.443    28.286     0.200
     8.648    26.199     0.200
     8.657    25.391     0.200
     8.759    25.802     0.200
     9.578    27.547     0.200
    10.039    31.665     0.200
    10.757    33.787     0.200
    11.249    31.543     0.200
    11.963    34.411     0.200
    13.510    37.654     0.200
    13.595    35.169     0.200
    13.722    39.483     0.200
    13.834    38.176     0.200
    14.207    38.625     0.200
    15.257    41.071     0.200
    15.245    40.416     0.200
    15.481    41.159     0.200
    15.552    41.034     0.200
    15.642    41.571     0.200
    15.913    42.316     0.200
    17.137    42.833     0.200
    18.453    44.474     0.200
    18.523    44.459     0.200
    18.543    43.929     0.200
    18.736    44.372     0.200
    18.702    46.567     0.200
    18.978    43.848     0.200
    19.001    43.686     0.200
    19.035    43.478     0.200
    19.254    44.128     0.200
    19.608    43.396     0.200
    19.699    43.435     0.200
    19.896    43.630     0.200
    20.180    42.315     0.200
    20.180    46.315     0.200
    20.592    46.012     0.200
     2.391    10.607     0.200
     2.576    10.447     0.200
     3.074    13.135     0.200
     3.362    12.779     0.200
     3.507    13.587     0.200
     3.844    13.643     0.200
     3.863    15.929     0.200
     4.208    15.098     0.200
     4.368    16.536     0.200
     4.970    20.513     0.200
     5.035    18.749     0.200
     5.302    17.241     0.200
     5.336    18.240     0.200
     5.408    17.396     0.200
     5.463    17.758     0.200
     5.485    17.495     0.200
     5.566    17.055     0.200
     5.621    16.405     0.200
     5.759    18.296     0.200
     5.776    17.798     0.200
     5.980    17.321     0.200
     6.062    19.167     0.200
     6.316    18.203     0.200
     6.535    19.739     0.200
     6.553    18.640     0.200
     6.626    18.483     0.200
     6.659    18.601     0.200
     6.715    20.642     0.200
     6.930    20.631     0.200
     7.020    20.477     0.200
     7.723    22.893     0.200
     7.929    22.177     0.200
     8.007    22.569     0.200
     8.447    23.431     0.200
     8.469    22.672     0.200
     8.769    25.376     0.200
     8.936    23.524     0.200
     9.526    24.145     0.200
     9.566    25.567     0.200
     9.737    25.872     0.200
    10.296    26.850     0.200
    10.319    30.081     0.200
    10.352    24.200     0.200
    10.329    26.642     0.200
    10.485    26.948     0.200
    11.155    28.834     0.200
    11.374    27.268     0.200
    11.457    29.201     0.200
    11.446    30.848     0.200
    11.533    28.916     0.200
    12.122    32.016     0.200
    12.098    32.018     0.200
    12.133    31.716     0.200
    12.189    31.464     0.200
    12.190    31.547     0.200
    12.202    31.214     0.200
    12.208    31.037     0.200
    12.295    31.722     0.200
    12.197    28.167     0.200
    12.307    33.889     0.200
    12.339    32.905     0.200
    12.423    33.486     0.200
    12.305    30.907     0.200
    12.436    31.613     0.200
    12.376    32.883     0.200
    12.501    31.125     0.200
    13.008    35.000     0.200
    13.853    33.943     0.200
    14.101    34.751     0.200
    14.242    35.904     0.200
    14.550    35.810     0.200
    14.765    35.306     0.200
    14.806    37.023     0.200
    14.833    37.209     0.200
    15.045    38.228     0.200
    15.305    39.797     0.200
    15.486    37.788     0.200
    15.517    39.430     0.200
    15.537    36.793     0.200
    15.563    37.190     0.200
    15.611    38.531     0.200
    15.629    39.912     0.200
    15.660    36.553     0.200
    15.680    37.720     0.200
    15.672    39.019     0.200
    15.740    39.022     0.200
    15.792    38.513     0.200
    15.845    39.701     0.200
    16.053    39.169     0.200
    16.053    39.868     0.200
    16.091    41.329     0.200
    16.983    41.010     0.200
    17.528    39.962     0.200
    17.528    40.762     0.200
    17.629    40.079     0.200
    17.631    40.553     0.200
    17.799    40.916     0.200
    17.825    40.385     0.200
    17.884    39.799     0.200
    17.884    40.197     0.200
    18.052    41.337     0.200
    18.149    40.807     0.200
    18.283    41.048     0.200
    18.413    41.634     0.200
    18.413    41.935     0.200
    18.564    40.683     0.200
    18.566    42.142     0.200
    18.566    42.040     0.200
    18.554    42.477     0.200
    18.659    42.060     0.200
    18.659    41.958     0.200
    18.754    40.650     0.200
    18.763    42.140     0.200
    18.916    41.455     0.200
    19.031    41.716     0.200
    19.031    41.615     0.200
    20.193    40.085     0.200
    20.847    42.224     0.200
     2.374    11.810     0.200
     2.537    11.418     0.200
     3.327    13.693     0.200
     3.478    14.930     0.200
     3.845    16.149     0.200
     3.804    16.127     0.200
     4.214    15.645     0.200
     5.021    18.928     0.200
     5.289    16.991     0.200
     5.320    19.433     0.200
     5.395    18.560     0.200
     5.447    19.958     0.200
     5.621    18.426     0.200
     5.766    18.428     0.200
     5.533    18.451     0.200
     5.987    18.957     0.200
     6.061    19.793     0.200
     6.311    20.572     0.200
     6.513    20.014     0.200
     6.531    20.005     0.200
     6.616    20.704     0.200
     6.642    20.006     0.200
     6.718    22.218     0.200
     6.928    21.572     0.200
     7.029    21.392     0.200
     7.537    23.064     0.200
     7.749    23.698     0.200
     7.940    24.062     0.200
     7.986    22.822     0.200
     8.431    23.831     0.200
     8.447    23.947     0.200
     8.776    26.728     0.200
     8.925    24.564     0.200
     9.510    25.735     0.200
     9.548    26.789     0.200
    10.306    27.253     0.200
    10.329    29.982     0.200
    10.314    26.651     0.200
    11.190    28.427     0.200
    11.362    30.824     0.200
    11.441    30.704     0.200
    11.569    28.512     0.200
    11.625    29.357     0.200
    12.106    32.327     0.200
    12.136    35.590     0.200
    12.195    34.903     0.200
    12.205    35.588     0.200
    12.212    35.808     0.200
    12.235    30.742     0.200
    12.410    33.050     0.200
    12.342    30.489     0.200
    12.538    32.198     0.200
    13.042    33.320     0.200
    14.107    37.388     0.200
    14.247    37.151     0.200
    14.558    37.027     0.200
    14.771    37.341     0.200
    14.823    38.834     0.200
    14.850    39.122     0.200
    15.063    39.138     0.200
    15.507    39.747     0.200
    15.641    38.918     0.200
    15.666    38.397     0.200
    15.862    38.405     0.200
    15.891    39.173     0.200
    18.491    42.124     0.200
    18.577    41.613     0.200
    18.583    43.060     0.200
    18.627    41.939     0.200
    18.629    41.357     0.200
    18.577    42.822     0.200
    18.674    42.790     0.200
    18.693    41.168     0.200
    18.766    41.020     0.200
    18.789    42.655     0.200
    18.795    42.988     0.200
    18.930    41.304     0.200
    18.927    42.441     0.200
    19.048    43.531     0.200
    19.085    40.997     0.200
    19.109    40.952     0.200
    19.201    41.146     0.200
    19.294    40.761     0.200
    19.297    42.120     0.200
    19.321    40.839     0.200
    19.604    40.750     0.200
    19.962    40.565     0.200
    19.993    41.305     0.200
    20.032    41.244     0.200
    20.242    40.490     0.200
    20.548    40.720     0.200
    20.833    41.025     0.200
    20.855    41.446     0.200
    20.870    40.369     0.200
    20.953    40.002     0.200
    20.983    45.250     0.200
     1.761     9.135     0.200
     1.764    10.606     0.200
     1.839    10.726     0.200
     1.903    14.982     0.200
     2.042     9.062     0.200
     2.055    11.706     0.200
     2.689    12.309     0.200
     2.960    13.341     0.200
     3.134    13.114     0.200
     3.295    13.135     0.200
     3.790    15.462     0.200
     3.833    13.461     0.200
     4.255    15.027     0.200
     4.416    15.149     0.200
     4.631    15.139     0.200
     5.025    16.051     0.200
     5.813    19.051     0.200
     6.934    19.268     0.200
     6.934    19.069     0.200
     1.540    11.235     0.200
     1.776    11.976     0.200
     2.120    13.469     0.200
     2.587    12.013     0.200
     2.505    16.977     0.200
     2.769    13.595     0.200
     2.806    15.057     0.200
     2.961    15.156     0.200
     3.103    15.795     0.200
     3.339    15.837     0.200
     3.636    15.275     0.200
     3.858    16.077     0.200
     3.860    17.462     0.200
     4.332    16.857     0.200
     4.345    18.395     0.200
     4.804    18.139     0.200
     1.706    13.009     0.200
     2.095    14.963     0.200
     2.434    12.014     0.200
     2.803    14.206     0.200
     2.827    12.423     0.200
     2.999    14.421     0.200
     3.569    17.262     0.200
     3.874    15.602     0.200
     3.896    17.245     0.200
     4.327    15.413     0.200
     4.396    18.117     0.200
     4.733    20.178     0.200
     1.660    12.974     0.200
     1.896     9.227     0.200
     1.867    13.061     0.200
     2.325    11.216     0.200
     2.841    13.592     0.200
     2.874    13.455     0.200
     2.988    12.914     0.200
     3.049    13.971     0.200
     3.291    15.163     0.200
     3.535    14.176     0.200
     3.693    16.291     0.200
     3.780    14.957     0.200
     3.843    15.302     0.200
     3.813    16.846     0.200
     4.085    16.274     0.200
     4.102    15.593     0.200
     4.861    17.830     0.200
     5.224    16.382     0.200
     6.000    18.067     0.200
     6.252    20.766     0.200
     6.617    21.424     0.200
     7.019    21.972     0.200
     7.230    20.578     0.200
     7.855    22.836     0.200
    19.527    45.470     0.200
    20.126    44.284     0.200
     1.470     5.939     0.200
     2.304    11.200     0.200
     2.295     8.813     0.200
     2.936    12.726     0.200
     3.032    13.716     0.200
     3.072    14.546     0.200
     3.342    14.996     0.200
     3.453    14.796     0.200
     3.654    12.746     0.200
     3.717    12.718     0.200
     4.038    15.974     0.200
     4.127    15.431     0.200
     4.403    16.712     0.200
     4.925    17.615     0.200
    20.242    38.667     0.200
     1.939    10.439     0.200
     2.455    12.719     0.200
     2.604    10.978     0.200
     2.628    13.194     0.200
     2.713    13.408     0.200
     2.726    14.057     0.200
     3.215    14.847     0.200
     3.518    14.809     0.200
     3.649    15.284     0.200
     3.663    15.119     0.200
     3.716    15.201     0.200
     3.797    14.954     0.200
     3.913    15.501     0.200
     3.974    14.486     0.200
     4.216    17.167     0.200
     4.361    16.073     0.200
     4.450    15.433     0.200
     4.536    15.039     0.200
     4.572    16.016     0.200
     5.026    18.519     0.200
     6.853    20.589     0.200
     8.055    22.866     0.200
    20.984    42.285     0.200
    20.984    45.586     0.200
     1.988    11.967     0.200
     1.875    11.587     0.200
     1.923    13.008     0.200
     2.335    11.909     0.200
     2.167     9.776     0.200
     2.728    11.826     0.200
     2.830    11.943     0.200
     2.879    12.867     0.200
     3.575    12.746     0.200
     3.933    15.061     0.200
     4.252    17.543     0.200
     1.100     9.183     0.200
     1.716     9.992     0.200
     1.921    10.299     0.200
     2.087     9.659     0.200
     2.828    13.319     0.200
     2.866    14.375     0.200
     2.872    14.303     0.200
     2.891    12.274     0.200
     3.006    13.034     0.200
     3.070    14.491     0.200
     3.309    15.501     0.200
     3.464    14.995     0.200
     3.717    13.237     0.200
     3.806    13.197     0.200
     3.869    13.864     0.200
     4.100    17.165     0.200
     4.122    15.318     0.200
     4.246    15.167     0.200
     4.195    17.062     0.200
     4.464    14.921     0.200
     4.878    17.996     0.200
     5.588    18.211     0.200
    20.136    42.733     0.200
     1.933    11.194     0.200
     2.739    15.806     0.200
     2.942    14.622     0.200
     3.078    13.631     0.200
     3.194    14.374     0.200
     3.362    15.724     0.200
     3.460    15.674     0.200
     3.631    16.382     0.200
     3.681    14.796     0.200
     3.752    13.670     0.200
     3.872    16.670     0.200
     4.338    18.229     0.200
     4.397    16.241     0.200
     4.428    16.078     0.200
     4.497    17.472     0.200
     4.490    18.259     0.200
     4.706    17.341     0.200
     4.791    17.446     0.200
     5.071    17.977     0.200
     5.087    17.785     0.200
     5.094    18.309     0.200
     5.144    19.924     0.200
     5.241    18.096     0.200
     5.854    20.531     0.200
     5.865    19.304     0.200
     5.986    20.694     0.200
     6.539    21.138     0.200
     6.673    21.379     0.200
     6.950    22.346     0.200
     7.336    22.845     0.200
    16.920    41.891     0.200
    20.554    43.588     0.200
     3.190    14.624     0.200
     3.969    17.531     0.200
     4.023    15.899     0.200
     4.643    16.166     0.200
     4.850    16.955     0.200
     4.869    17.234     0.200
     4.854    17.007     0.200
     4.957    17.198     0.200
     5.068    17.611     0.200
     5.119    17.612     0.200
     5.192    18.061     0.200
     5.372    18.359     0.200
     5.503    18.230     0.200
     6.107    19.582     0.200
     6.894    21.302     0.200
     7.140    21.725     0.200
     8.066    24.120     0.200
     8.577    24.754     0.200
     8.973    25.635     0.200
     1.799    10.797     0.200
     2.435    11.379     0.200
     2.683    13.481     0.200
     3.203    12.408     0.200
     3.203    14.408     0.200
     3.685    15.989     0.200
     4.149    15.868     0.200
     4.440    18.076     0.200
     4.745    18.620     0.200
     4.777    15.839     0.200
     4.856    16.220     0.200
     4.945    16.084     0.200
     4.986    16.305     0.200
     4.991    16.243     0.200
     5.054    16.910     0.200
     5.095    16.537     0.200
     5.206    16.740     0.200
     5.257    16.946     0.200
     5.329    17.300     0.200
     5.532    20.732     0.200
     5.546    18.566     0.200
     6.313    20.414     0.200
     6.994    20.667     0.200
     7.313    21.444     0.200
     7.929    22.756     0.200
     8.472    25.322     0.200
     8.494    24.665     0.200
     1.790    10.142     0.200
     3.315    14.348     0.200
     3.797    14.226     0.200
     4.263    14.992     0.200
     4.451    14.492     0.200
     4.563    17.093     0.200
     4.861    15.011     0.200
     4.949    15.085     0.200
     5.045    15.067     0.200
     5.093    15.705     0.200
     5.172    15.774     0.200
     5.276    16.067     0.200
     5.332    16.215     0.200
     5.408    16.429     0.200
     5.668    17.795     0.200
     5.585    16.860     0.200
     5.726    16.910     0.200
     6.437    20.618     0.200
     7.368    20.249     0.200
     7.423    20.216     0.200
     2.516    13.940     0.200
     2.987    14.573     0.200
     3.393    14.728     0.200
     3.455    15.987     0.200
     3.456    13.992     0.200
     3.580    15.170     0.200
     3.727    15.870     0.200
     3.790    15.915     0.200
     3.815    15.126     0.200
     3.774    16.159     0.200
     3.808    16.357     0.200
     3.914    15.466     0.200
     3.896    16.376     0.200
     4.057    15.204     0.200
     4.086    15.659     0.200
     4.146    16.265     0.200
     4.505    18.171     0.200
     4.638    18.484     0.200
     5.035    18.294     0.200
     5.371    20.122     0.200
     5.900    20.097     0.200
     5.900    19.977     0.200
     6.119    19.678     0.200
     6.811    21.747     0.200
     7.469    23.206     0.200
     1.915    12.710     0.200
     2.491    12.047     0.200
     2.952    12.945     0.200
     3.183    12.673     0.200
     3.274    14.134     0.200
     3.306    14.954     0.200
     3.585    14.755     0.200
     3.682    15.769     0.200
     3.903    13.892     0.200
     3.466    14.601     0.200
     3.813    15.582     0.200
     3.978    14.025     0.200
     4.124    14.824     0.200
     4.361    16.422     0.200
     4.413    18.529     0.200
     4.350    14.991     0.200
     4.575    15.568     0.200
     4.553    15.417     0.200
     5.193    16.751     0.200
     5.797    18.767     0.200
     5.797    18.767     0.200
     2.714    12.848     0.200
     2.804    12.845     0.200
     2.815    13.460     0.200
     3.009    12.716     0.200
     3.103    12.600     0.200
     3.140    14.499     0.200
     3.413    15.335     0.200
     3.520    15.402     0.200
     3.691    14.033     0.200
     3.712    14.301     0.200
     3.713    14.534     0.200
     3.708    14.101     0.200
     3.725    16.279     0.200
     3.857    14.463     0.200
     3.920    14.628     0.200
     3.984    14.476     0.200
     4.075    14.661     0.200
     4.263    15.041     0.200
     4.265    15.238     0.200
     4.237    17.927     0.200
     4.298    15.313     0.200
     4.497    15.789     0.200
     4.506    15.592     0.200
     4.805    18.471     0.200
     4.998    18.577     0.200
     5.118    16.842     0.200
     5.384    18.934     0.200
     5.468    18.073     0.200
     5.638    18.623     0.200
     5.638    18.711     0.200
     5.766    19.285     0.200
     5.820    21.186     0.200
     5.960    19.318     0.200
     5.997    19.143     0.200
     6.025    19.157     0.200
     6.098    19.404     0.200
     6.413    21.304     0.200
     6.574    20.456     0.200
     6.956    20.992     0.200
     7.135    22.172     0.200
     7.207    21.267     0.200
     7.446    21.984     0.200
     7.792    22.735     0.200
     8.023    25.427     0.200
     8.058    25.738     0.200
     8.425    24.608     0.200
     8.556    27.179     0.200
     9.168    25.177     0.200
     9.474    26.148     0.200
     9.474    27.251     0.200
     9.482    28.514     0.200
     9.668    28.049     0.200
     9.688    28.812     0.200
     9.886    27.798     0.200
    10.007    29.485     0.200
    10.092    28.991     0.200
    10.406    30.830     0.200
    10.858    32.955     0.200
    11.728    32.606     0.200
    12.145    30.936     0.200
    13.878    34.409     0.200
    14.268    34.961     0.200
    14.498    36.073     0.200
    14.952    38.382     0.200
    15.050    37.334     0.200
    15.119    39.037     0.200
    18.597    40.934     0.200
    18.654    41.373     0.200
    18.654    41.474     0.200
    18.735    42.408     0.200
    18.759    41.652     0.200
    18.920    42.268     0.200
    19.040    41.470     0.200
    19.139    41.216     0.200
    19.400    41.876     0.200
    19.700    40.471     0.200
    19.700    40.471     0.200
    19.912    41.102     0.200
    19.984    40.858     0.200
    20.567    45.249     0.200
     1.359    10.398     0.200
     3.132    14.207     0.200
     3.778    15.875     0.200
     3.935    17.841     0.200
     3.920    18.224     0.200
     3.996    17.493     0.200
     4.447    17.464     0.200
     4.789    20.176     0.200
     5.516    20.413     0.200
     5.816    20.115     0.200
     5.945    21.573     0.200
     6.016    20.907     0.200
     6.016    20.757     0.200
     7.602    23.965     0.200
     1.247     8.079     0.200
     2.672    12.006     0.200
     2.852    12.793     0.200
     3.165    11.689     0.200
     3.415    12.381     0.200
     3.423    12.380     0.200
     3.306    13.045     0.200
     3.465    13.798     0.200
     3.492    12.940     0.200
     3.514    13.725     0.200
     3.752    13.924     0.200
     3.780    15.241     0.200
     3.835    15.314     0.200
     4.042    13.358     0.200
     3.915    14.578     0.200
     4.378    15.638     0.200
     4.490    16.010     0.200
     4.491    16.534     0.200
     4.840    15.748     0.200
     4.739    16.801     0.200
     5.071    16.284     0.200
     5.222    16.091     0.200
     5.449    16.044     0.200
     5.428    17.922     0.200
     5.427    18.300     0.200
     5.597    17.350     0.200
     5.524    18.871     0.200
     5.685    17.086     0.200
     5.732    17.333     0.200
     5.815    17.972     0.200
     5.815    17.922     0.200
     5.905    19.221     0.200
     6.292    18.770     0.200
     6.650    18.922     0.200
     6.690    21.093     0.200
     6.913    20.667     0.200
     7.177    19.978     0.200
     7.460    21.877     0.200
     7.629    21.399     0.200
     7.645    20.815     0.200
     7.804    21.337     0.200
     7.751    22.798     0.200
     7.905    17.575     0.200
     8.179    22.035     0.200
     8.234    22.616     0.200
     8.409    20.502     0.200
     8.534    23.875     0.200
     8.598    24.224     0.200
     8.761    19.486     0.200
     8.849    24.942     0.200
     8.945    25.042     0.200
     9.285    24.896     0.200
     9.261    26.228     0.200
     9.570    26.308     0.200
     9.734    26.548     0.200
     9.746    27.092     0.200
     9.783    26.364     0.200
     9.793    26.649     0.200
     9.818    27.150     0.200
     9.900    26.900     0.200
     9.933    27.317     0.200
     9.966    27.124     0.200
    10.027    27.410     0.200
    10.024    27.153     0.200
    10.085    27.340     0.200
    10.182    27.603     0.200
    10.203    22.103     0.200
    10.272    28.453     0.200
    10.407    27.783     0.200
    10.524    28.308     0.200
    10.795    29.249     0.200
    10.881    29.851     0.200
    12.057    30.621     0.200
    12.057    30.722     0.200
    12.539    31.199     0.200
    12.649    31.313     0.200
    12.659    34.293     0.200
    13.279    32.764     0.200
    13.742    33.560     0.200
    13.742    34.157     0.200
    13.939    32.959     0.200
    14.204    34.266     0.200
    14.339    33.196     0.200
    14.339    33.497     0.200
    14.354    33.821     0.200
    14.590    35.266     0.200
    14.785    35.489     0.200
    14.874    36.055     0.200
    15.139    36.154     0.200
    15.219    35.721     0.200
    15.598    37.603     0.200
    17.583    36.923     0.200
    18.332    40.999     0.200
    18.422    41.140     0.200
    18.498    40.553     0.200
    18.699    40.112     0.200
    18.865    42.170     0.200
    18.909    40.067     0.200
    18.925    40.671     0.200
    19.077    39.694     0.200
    19.081    42.148     0.200
    19.087    40.983     0.200
    19.305    38.541     0.200
    19.430    40.176     0.200
    20.202    38.672     0.200
    20.202    38.672     0.200
    20.641    38.848     0.200
     2.388    12.177     0.200
     2.840    13.060     0.200
     2.984    12.656     0.200
     3.086    14.449     0.200
     3.133    15.500     0.200
     3.296    14.834     0.200
     3.394    15.646     0.200
     3.518    16.203     0.200
     3.733    15.560     0.200
     3.677    15.675     0.200
     3.920    15.280     0.200
     3.911    15.207     0.200
     3.982    15.079     0.200
     4.028    17.416     0.200
     4.087    16.327     0.200
     4.188    16.408     0.200
     4.206    17.505     0.200
     4.582    16.446     0.200
     4.560    15.811     0.200
     4.759    18.508     0.200
     4.837    18.221     0.200
     4.973    18.528     0.200
     5.338    19.941     0.200
     5.473    18.643     0.200
     5.474    18.490     0.200
     5.639    17.849     0.200
     6.026    19.325     0.200
     8.064    25.604     0.200
     1.187    11.332     0.200
     1.489     9.810     0.200
     2.156    11.017     0.200
     2.617    14.496     0.200
     3.560    16.871     0.200
     3.840    15.868     0.200
     3.896    16.506     0.200
     3.708    18.410     0.200
     4.252    19.432     0.200
     4.218    17.818     0.200
     4.918    18.128     0.200
     1.414     9.897     0.200
     3.014    13.150     0.200
     4.096    14.744     0.200
     4.154    15.053     0.200
     4.602    15.402     0.200
     4.780    16.042     0.200
     5.173    16.379     0.200
     1.801     9.745     0.200
     1.801     9.446     0.200
     1.549     9.600     0.200
     2.157     7.771     0.200
     2.157     8.511     0.200
     2.157     8.121     0.200
     2.452    11.463     0.200
     2.693    12.284     0.200
     2.836    13.309     0.200
     2.745    10.844     0.200
     3.489    14.952     0.200
     3.489    15.464     0.200
     3.847    13.487     0.200
     3.847    13.219     0.200
     4.729    17.522     0.200
     4.729    17.993     0.200
     4.040    14.088     0.200
     5.227    17.857     0.200
     1.643    11.461     0.200
     1.856    10.968     0.200
     2.700    15.119     0.200
     2.851    16.099     0.200
     3.032    13.717     0.200
     3.032    13.881     0.200
     3.080    14.694     0.200
     3.276    15.797     0.200
     3.307    16.044     0.200
     3.378    16.214     0.200
     3.619    16.779     0.200
     3.619    16.420     0.200
     3.704    18.167     0.200
     3.726    17.329     0.200
     3.952    17.189     0.200
     3.995    18.757     0.200
     4.017    19.133     0.200
     4.094    18.210     0.200
     4.234    16.858     0.200
     4.234    16.678     0.200
     4.262    17.180     0.200
     4.484    18.138     0.200
     4.632    18.164     0.200
     4.632    18.282     0.200
     4.713    18.927     0.200
     4.660    20.052     0.200
     4.660    20.317     0.200
     4.805    17.959     0.200
     4.805    18.663     0.200
     4.781    19.579     0.200
     4.852    20.533     0.200
     4.852    21.408     0.200
     5.284    19.601     0.200
     5.314    18.717     0.200
     5.607    21.496     0.200
     5.992    22.779     0.200
     6.202    21.175     0.200
     6.422    21.687     0.200
     6.976    23.320     0.200
     7.029    23.319     0.200
     7.124    23.737     0.200
     7.885    26.337     0.200
     8.250    25.557     0.200
     8.250    24.955     0.200
     8.385    25.754     0.200
     8.385    26.059     0.200
     8.494    26.059     0.200
     8.494    25.270     0.200
     9.696    29.451     0.200
     9.765    29.826     0.200
     9.798    29.170     0.200
    10.083    30.666     0.200
    10.092    30.160     0.200
    10.494    31.462     0.200
    11.474    32.831     0.200
    14.421    37.240     0.200
    14.818    37.912     0.200
    14.827    37.997     0.200
     1.262     7.424     0.200
     1.801    10.640     0.200
     1.952     9.372     0.200
     1.979    10.545     0.200
     1.984    10.506     0.200
     2.087    11.806     0.200
     2.477    10.203     0.200
     2.477    10.453     0.200
     2.939    11.814     0.200
     3.051    13.731     0.200
     3.051    14.852     0.200
     3.111    14.486     0.200
     3.234    12.467     0.200
     3.234    13.021     0.200
     3.321    13.701     0.200
     3.355    14.562     0.200
     3.503    15.418     0.200
     3.961    12.633     0.200
     3.961    13.325     0.200
     4.010    14.465     0.200
     3.984    16.086     0.200
     3.984    16.668     0.200
     4.052    12.995     0.200
     4.052    13.166     0.200
     4.082    14.259     0.200
     4.163    16.307     0.200
     4.151    16.875     0.200
     4.137    14.883     0.200
     4.459    14.594     0.200
     4.630    15.727     0.200
     4.671    15.441     0.200
     4.760    17.410     0.200
     4.926    17.770     0.200
     4.977    15.662     0.200
     4.977    15.873     0.200
     5.120    16.509     0.200
     5.276    18.997     0.200
     5.276    18.286     0.200
     5.626    16.298     0.200
     5.781    19.697     0.200
     6.118    18.865     0.200
     6.216    19.116     0.200
     6.318    19.346     0.200
     6.318    20.322     0.200
     6.572    20.042     0.200
     6.572    20.566     0.200
     6.660    19.240     0.200
     7.048    20.802     0.200
     7.014    20.949     0.200
     7.014    22.601     0.200
     7.529    21.988     0.200
     7.851    21.532     0.200
     8.002    24.526     0.200
     8.172    22.315     0.200
     9.422    26.808     0.200
     9.452    26.355     0.200
     9.813    27.636     0.200
    10.764    29.245     0.200
     1.920     7.803     0.200
     1.924     7.731     0.200
     1.852    11.770     0.200
     2.455     9.479     0.200
     2.336    12.122     0.200
     2.421    12.134     0.200
     2.899    11.496     0.200
     3.015    12.403     0.200
     2.894    10.911     0.200
     3.080    12.724     0.200
     3.186    11.807     0.200
     3.281    13.490     0.200
     3.317    14.835     0.200
     3.474    15.082     0.200
     3.943    16.398     0.200
     4.058    15.037     0.200
     3.964    13.044     0.200
     4.131    14.756     0.200
     4.197    16.403     0.200
     4.707    17.908     0.200
     4.643    14.304     0.200
     4.695    14.392     0.200
     5.228    18.859     0.200
     7.048    19.533     0.200
     7.526    20.851     0.200
     1.925    11.649     0.200
     4.039    17.223     0.200
     4.264    16.925     0.200
     4.425    17.676     0.200
     5.204    18.093     0.200
     5.185    19.426     0.200
     5.335    18.275     0.200
     5.332    18.821     0.200
     5.523    19.558     0.200
     5.754    20.568     0.200
     5.854    19.484     0.200
     5.907    20.159     0.200
     6.024    20.423     0.200
     6.336    21.574     0.200
     6.344    20.586     0.200
     7.399    23.268     0.200
     7.467    23.777     0.200
     7.429    22.358     0.200
     1.283    10.859     0.200
     1.508    12.671     0.200
     1.963    11.360     0.200
     2.447    11.703     0.200
     4.253    17.434     0.200
     4.253    17.032     0.200
     4.424    17.189     0.200
     4.424    18.040     0.200
     4.491    17.606     0.200
     4.492    17.045     0.200
     5.216    18.148     0.200
     5.301    18.114     0.200
     5.162    19.424     0.200
     5.162    18.315     0.200
     5.223    20.439     0.200
     5.247    18.959     0.200
     5.247    20.931     0.200
     5.341    18.093     0.200
     5.320    19.262     0.200
     5.543    18.881     0.200
     5.650    19.283     0.200
     5.767    19.265     0.200
     5.845    19.686     0.200
     5.888    22.028     0.200
     5.888    21.551     0.200
     6.010    20.630     0.200
     6.010    19.829     0.200
     6.351    21.255     0.200
     6.351    20.349     0.200
     6.905    22.180     0.200
     7.218    22.553     0.200
     7.218    18.721     0.200
     7.204    24.500     0.200
     7.412    23.067     0.200
     7.475    22.934     0.200
     7.419    22.473     0.200
     7.419    22.485     0.200
     8.035    24.702     0.200
     8.035    23.764     0.200
     9.365    27.672     0.200
     9.501    27.253     0.200
     9.546    26.991     0.200
    10.866    30.456     0.200
    10.974    30.227     0.200
    10.974    32.001     0.200
     2.897    13.660     0.200
     3.347    15.411     0.200
     3.554    15.413     0.200
     4.878    17.333     0.200
     4.889    17.319     0.200
     5.162    18.820     0.200
     5.359    18.336     0.200
     5.450    18.575     0.200
     5.911    19.497     0.200
     6.060    20.248     0.200
     6.347    23.234     0.200
     7.051    21.686     0.200
     7.077    21.879     0.200
     7.603    23.042     0.200
     7.980    24.049     0.200
     8.483    24.880     0.200
     8.856    24.927     0.200
     8.962    25.880     0.200
     1.792    10.949     0.200
     2.419    14.143     0.200
     2.592    15.117     0.200
     2.610    13.912     0.200
     3.096    15.231     0.200
     3.119    15.964     0.200
     3.696    16.573     0.200
     3.696    16.323     0.200
     3.842    14.112     0.200
     4.051    15.489     0.200
     4.131    16.022     0.200
     4.150    16.691     0.200
     4.343    16.202     0.200
     4.454    17.571     0.200
     4.505    19.406     0.200
     4.621    18.057     0.200
     4.725    19.366     0.200
     4.759    19.943     0.200
     4.864    17.478     0.200
     5.077    17.893     0.200
     5.119    17.554     0.200
     5.280    18.031     0.200
     5.387    20.437     0.200
     5.448    18.932     0.200
     5.515    18.909     0.200
     5.560    19.837     0.200
     5.645    18.892     0.200
     6.141    20.221     0.200
     6.157    20.620     0.200
     6.249    20.542     0.200
     6.465    21.024     0.200
     6.660    24.034     0.200
     7.008    21.671     0.200
     7.280    22.108     0.200
     7.278    22.135     0.200
     7.833    23.355     0.200
     7.872    23.615     0.200
     7.942    24.195     0.200
     8.205    24.018     0.200
     8.308    27.610     0.200
     8.421    23.730     0.200
     9.191    26.400     0.200
     9.241    26.211     0.200
     9.350    26.822     0.200
     9.747    26.912     0.200
    10.538    28.957     0.200
    10.580    29.638     0.200
    10.654    29.370     0.200
    10.834    31.882     0.200
    10.826    31.734     0.200
    10.855    31.788     0.200
    10.892    31.152     0.200
    15.246    37.844     0.200
    15.654    38.883     0.200
     1.277    10.713     0.200
     1.266    12.841     0.200
     1.713    12.619     0.200
     1.695    11.834     0.200
     2.386    13.759     0.200
     2.952    13.502     0.200
     2.984    14.782     0.200
     3.027    14.099     0.200
     3.135    15.022     0.200
     3.337    15.741     0.200
     3.822    14.182     0.200
     3.929    14.546     0.200
     4.072    16.717     0.200
     4.221    15.548     0.200
     4.506    16.457     0.200
     4.694    18.884     0.200
     4.731    18.578     0.200
     4.941    17.082     0.200
     5.638    20.018     0.200
     6.067    19.410     0.200
     6.086    21.583     0.200
     1.735    11.213     0.200
     1.855    10.814     0.200
     2.064    12.874     0.200
     2.269    11.983     0.200
     2.409    12.351     0.200
     2.646    12.585     0.200
     4.753    17.289     0.200
     4.905    15.126     0.200
     5.177    16.905     0.200
     5.504    20.165     0.200
     5.564    20.418     0.200
     5.635    20.731     0.200
     5.805    21.113     0.200
     6.054    18.370     0.200
     6.141    18.082     0.200
     6.512    19.390     0.200
     7.077    23.558     0.200
     7.158    20.743     0.200
     7.665    24.656     0.200
     8.070    22.392     0.200
     8.070    22.744     0.200
     8.848    24.313     0.200
    10.282    27.450     0.200
    10.363    27.171     0.200
     1.455     9.630     0.200
     1.656    11.287     0.200
     2.121    11.860     0.200
     3.248    12.707     0.200
     4.018    15.048     0.200
     4.084    14.072     0.200
     4.556    15.711     0.200
     4.556    14.446     0.200
     4.743    15.805     0.200
     5.102    16.850     0.200
     1.506    11.825     0.200
     1.629    10.883     0.200
     2.064    11.810     0.200
     2.733    14.008     0.200
     4.513    16.392     0.200
     4.673    16.040     0.200
     4.934    17.738     0.200
     5.433    21.444     0.200
     5.552    19.844     0.200
     5.808    18.520     0.200
     5.894    18.268     0.200
     5.932    18.469     0.200
     6.172    19.265     0.200
     6.212    21.876     0.200
     6.279    19.978     0.200
     6.367    19.601     0.200
     6.393    19.449     0.200
     6.959    21.988     0.200
     7.115    21.569     0.200
     7.467    25.611     0.200
     7.634    22.812     0.200
     7.840    22.586     0.200
     8.044    23.326     0.200
     9.901    27.146     0.200
     1.757    12.042     0.200
     1.762     9.934     0.200
     1.766     9.831     0.200
     2.036    12.784     0.200
     2.147     9.711     0.200
     2.266    13.603     0.200
     2.248    10.196     0.200
     2.274     9.172     0.200
     2.603    12.169     0.200
     2.998    10.982     0.200
     3.090    12.656     0.200
     3.287    13.798     0.200
     3.752    13.066     0.200
     3.752    16.257     0.200
     3.821    13.598     0.200
     3.875    14.413     0.200
     3.917    15.360     0.200
     3.946    13.035     0.200
     4.831    15.234     0.200
     1.809     9.425     0.200
     2.001    10.182     0.200
     2.240     9.693     0.200
     2.280     8.076     0.200
     2.267    13.578     0.200
     2.566    11.585     0.200
     3.031    11.585     0.200
     3.114    11.678     0.200
     3.777    14.577     0.200
     3.806    12.992     0.200
     3.883    13.026     0.200
     3.922    12.414     0.200
     4.817    14.907     0.200
     5.073    17.364     0.200
     1.336    10.924     0.200
     1.529    10.681     0.200
     1.897    11.878     0.200
     4.234    14.620     0.200
     4.288    15.010     0.200
     4.711    17.001     0.200
     4.684    16.362     0.200
     5.308    16.849     0.200
     5.525    18.542     0.200
     2.091    12.968     0.200
     2.412    12.726     0.200
     2.509    10.098     0.200
     2.510    11.584     0.200
     2.688    11.508     0.200
     2.993    12.949     0.200
     3.290    15.480     0.200
     3.455    15.557     0.200
     3.899    15.378     0.200
     4.128    14.611     0.200
     4.199    15.272     0.200
     4.275    15.901     0.200
     4.374    17.266     0.200
     4.463    17.356     0.200
     4.551    15.522     0.200
     4.520    18.130     0.200
     4.646    16.599     0.200
     4.922    19.436     0.200
     5.139    16.000     0.200
     5.257    19.292     0.200
     5.313    20.171     0.200
     5.537    19.260     0.200
     5.613    17.380     0.200
     5.625    18.935     0.200
     5.667    18.323     0.200
     5.796    16.961     0.200
     5.922    17.241     0.200
     6.300    22.304     0.200
     6.499    18.428     0.200
     6.539    18.567     0.200
     6.800    19.270     0.200
     6.984    19.867     0.200
     7.104    19.973     0.200
     7.118    21.781     0.200
     7.123    20.643     0.200
     7.933    22.190     0.200
     8.861    24.163     0.200
    11.157    29.906     0.200
    19.902    40.055     0.200
     1.918    12.189     0.200
     2.252    14.292     0.200
     2.927    14.408     0.200
     3.377    15.160     0.200
     4.011    15.926     0.200
     4.394    19.028     0.200
     4.770    16.401     0.200
     4.872    17.480     0.200
     4.872    17.109     0.200
     4.879    16.843     0.200
     5.143    19.335     0.200
     5.143    18.046     0.200
     5.211    22.061     0.200
     5.240    19.181     0.200
     5.902    18.966     0.200
     6.143    19.586     0.200
     7.042    21.288     0.200
     1.928    12.327     0.200
     2.108    12.718     0.200
     2.350    11.903     0.200
     2.442    12.319     0.200
     2.455    12.668     0.200
     2.537    12.712     0.200
     2.724    12.793     0.200
     2.725    12.824     0.200
     3.096    14.187     0.200
     3.241    15.501     0.200
     3.326    15.709     0.200
     3.345    15.002     0.200
     3.413    16.497     0.200
     3.587    17.467     0.200
     3.651    15.717     0.200
     3.910    14.697     0.200
     3.979    18.883     0.200
     4.071    15.368     0.200
     4.146    17.239     0.200
     4.203    15.683     0.200
     4.211    15.534     0.200
     4.284    18.332     0.200
     4.308    15.989     0.200
     4.400    16.050     0.200
     4.485    15.844     0.200
     4.550    16.228     0.200
     4.549    17.240     0.200
     4.582    17.458     0.200
     4.583    17.840     0.200
     4.653    17.158     0.200
     4.657    18.976     0.200
     4.653    17.458     0.200
     4.864    16.562     0.200
     4.883    16.242     0.200
     4.972    19.322     0.200
     5.083    16.900     0.200
     5.192    19.577     0.200
     5.365    16.718     0.200
     5.381    17.563     0.200
     5.542    19.943     0.200
     5.606    18.950     0.200
     5.642    17.899     0.200
     5.746    18.280     0.200
     5.799    20.645     0.200
     5.859    18.851     0.200
     5.877    18.147     0.200
     5.880    18.603     0.200
     6.233    21.578     0.200
     6.260    19.268     0.200
     6.285    19.773     0.200
     6.454    19.703     0.200
     6.500    19.964     0.200
     6.649    22.713     0.200
     6.748    20.494     0.200
     6.766    20.758     0.200
     6.839    19.607     0.200
     6.938    20.956     0.200
     6.949    21.327     0.200
     6.982    20.438     0.200
     7.054    21.398     0.200
     7.055    22.654     0.200
     7.055    22.412     0.200
     7.079    21.716     0.200
     7.268    23.720     0.200
     7.529    23.692     0.200
     7.700    22.162     0.200
     7.860    23.397     0.200
     7.881    23.151     0.200
     8.029    24.101     0.200
     8.120    26.133     0.200
     8.277    26.093     0.200
     8.411    24.665     0.200
     8.700    26.799     0.200
     8.809    24.927     0.200
     8.793    27.324     0.200
     8.887    27.698     0.200
     8.917    26.266     0.200
     8.979    25.735     0.200
     9.259    27.393     0.200
     9.267    26.173     0.200
     9.471    29.150     0.200
     9.522    26.900     0.200
     9.758    27.347     0.200
     9.787    30.861     0.200
     9.878    30.042     0.200
     9.913    28.020     0.200
    10.122    29.525     0.200
    10.171    29.927     0.200
    10.361    29.310     0.200
    10.469    31.323     0.200
    10.601    30.604     0.200
    10.641    29.246     0.200
    10.652    32.913     0.200
    10.751    29.919     0.200
    10.842    29.401     0.200
    10.992    29.747     0.200
    11.067    30.904     0.200
    11.119    30.712     0.200
    13.044    33.299     0.200
    13.545    38.349     0.200
    14.029    38.807     0.200
    14.146    34.541     0.200
    14.212    35.871     0.200
    15.137    37.072     0.200
    17.868    41.656     0.200
     1.312    10.312     0.200
     1.578     9.722     0.200
     1.582     9.663     0.200
     2.032    11.903     0.200
     2.173    13.265     0.200
     2.372    10.778     0.200
     2.414    14.655     0.200
     2.545    12.154     0.200
     2.692    11.918     0.200
     2.834    14.193     0.200
     2.732    13.733     0.200
     2.931    13.652     0.200
     2.933    15.332     0.200
     3.076    14.421     0.200
     3.123    14.290     0.200
     3.259    13.435     0.200
     3.341    15.996     0.200
     3.729    15.951     0.200
     3.951    16.173     0.200
     3.970    17.353     0.200
     4.017    15.744     0.200
     4.179    14.560     0.200
     4.199    14.413     0.200
     4.200    14.608     0.200
     4.666    15.172     0.200
     4.667    15.957     0.200
     4.753    15.951     0.200
     4.966    19.451     0.200
     4.966    19.161     0.200
     4.866    16.329     0.200
     5.016    17.576     0.200
     5.275    16.765     0.200
     5.328    18.242     0.200
     5.460    19.089     0.200
     6.149    19.860     0.200
     6.421    20.313     0.200
     6.842    22.835     0.200
     7.077    22.234     0.200
     7.257    22.426     0.200
     7.811    23.666     0.200
     9.165    27.068     0.200
     9.216    26.574     0.200
     1.324     9.078     0.200
     2.414    13.363     0.200
     2.645    13.668     0.200
     2.822    12.597     0.200
     2.918    13.479     0.200
     3.311    13.897     0.200
     3.610    16.078     0.200
     3.610    14.324     0.200
     3.552    15.094     0.200
     3.727    13.472     0.200
     4.058    14.974     0.200
     4.191    15.387     0.200
     4.311    16.002     0.200
     4.373    16.256     0.200
     4.454    16.738     0.200
     4.574    16.742     0.200
     4.763    17.086     0.200
     4.946    16.414     0.200
     5.012    16.542     0.200
     5.054    16.398     0.200
     5.068    15.915     0.200
     5.235    17.041     0.200
     5.296    17.025     0.200
     5.296    17.424     0.200
     5.234    18.780     0.200
     5.334    17.392     0.200
     5.426    18.266     0.200
     5.528    17.721     0.200
     5.538    17.798     0.200
     5.626    18.477     0.200
     6.091    19.109     0.200
     6.135    19.136     0.200
     6.329    19.477     0.200
     6.489    21.391     0.200
     6.886    20.029     0.200
     6.958    21.429     0.200
     7.231    21.252     0.200
     8.159    23.614     0.200
     8.339    24.221     0.200
     8.662    24.641     0.200
     9.035    25.492     0.200
     9.169    25.376     0.200
     9.300    25.567     0.200
     9.705    26.192     0.200
    10.530    27.544     0.200
     1.038     7.709     0.200
     0.987     8.798     0.200
     1.168    10.194     0.200
     2.562    10.645     0.200
     2.865    11.805     0.200
     4.200    14.928     0.200
     4.351    14.422     0.200
     4.367    14.456     0.200
     4.695    14.924     0.200
     5.117    18.220     0.200
     2.154    12.951     0.200
     3.904    15.105     0.200
     3.878    14.233     0.200
     3.908    14.535     0.200
     4.084    16.583     0.200
     4.275    20.400     0.200
     4.275    19.020     0.200
     4.236    17.329     0.200
     4.236    16.837     0.200
     4.174    16.870     0.200
     4.214    16.202     0.200
     4.375    16.325     0.200
     4.438    17.094     0.200
     4.483    16.269     0.200
     4.926    17.499     0.200
     5.169    19.062     0.200
     1.329    10.156     0.200
     2.255    11.350     0.200
     2.283     9.286     0.200
     2.709    12.115     0.200
     2.997    11.417     0.200
     3.092    12.539     0.200
     3.754    15.727     0.200
     3.837    13.220     0.200
     3.883    14.702     0.200
     3.964    13.304     0.200
     3.974    14.086     0.200
     4.329    15.243     0.200
     4.540    15.282     0.200
     4.623    15.318     0.200
     4.846    16.589     0.200
     5.022    16.159     0.200
     5.039    19.351     0.200
     5.039    17.445     0.200
     5.142    16.956     0.200
     5.418    16.400     0.200
     1.253     7.246     0.200
     1.170     7.211     0.200
     1.667     8.408     0.200
     1.669     8.388     0.200
     1.639    10.581     0.200
     2.155    10.724     0.200
     2.203    10.821     0.200
     2.254    10.559     0.200
     2.226    10.892     0.200
     2.407    10.221     0.200
     2.417     9.644     0.200
     2.449     9.290     0.200
     2.598    11.050     0.200
     2.627    10.791     0.200
     2.435    11.449     0.200
     2.659    10.840     0.200
     2.681    10.676     0.200
     2.688    11.662     0.200
     3.121    12.145     0.200
     3.122    12.568     0.200
     3.404    11.634     0.200
     3.429    15.026     0.200
     3.438    14.301     0.200
     3.476    13.282     0.200
     3.549    11.851     0.200
     3.597    11.991     0.200
     3.626    12.109     0.200
     3.624    11.866     0.200
     3.588    12.989     0.200
     3.824    12.806     0.200
     3.908    12.366     0.200
     3.779    13.765     0.200
     3.943    12.249     0.200
     3.997    13.618     0.200
     4.094    12.986     0.200
     4.092    15.514     0.200
     4.165    12.963     0.200
     4.201    12.941     0.200
     4.172    14.483     0.200
     4.308    16.332     0.200
     4.646    14.072     0.200
     4.705    14.756     0.200
     4.705    14.354     0.200
     4.740    14.356     0.200
     4.817    14.754     0.200
     4.887    15.135     0.200
     5.038    16.674     0.200
     5.382    16.062     0.200
     5.463    18.320     0.200
     5.563    16.248     0.200
     5.571    16.287     0.200
     5.571    16.428     0.200
     5.571    16.651     0.200
     5.504    17.641     0.200
     5.786    16.742     0.200
     5.821    16.840     0.200
     6.338    18.198     0.200
     6.338    17.796     0.200
     6.486    18.813     0.200
     6.715    18.807     0.200
     7.001    19.463     0.200
     7.135    20.184     0.200
     7.218    19.732     0.200
     7.285    19.751     0.200
     7.602    20.653     0.200
     7.698    20.935     0.200
     7.737    21.055     0.200
     7.856    21.318     0.200
     8.226    21.871     0.200
     9.047    24.140     0.200
     9.086    23.764     0.200
     9.078    24.955     0.200
     9.128    24.172     0.200
     9.150    24.365     0.200
     9.243    25.546     0.200
     9.258    25.617     0.200
     9.485    24.778     0.200
     9.490    25.116     0.200
     9.508    25.502     0.200
     9.545    25.750     0.200
     9.916    25.644     0.200
    11.735    28.815     0.200
    12.181    30.219     0.200
    12.314    29.666     0.200
    13.014    30.794     0.200
    13.778    32.177     0.200
    14.178    33.311     0.200
    14.184    33.042     0.200
    14.564    33.904     0.200
    14.902    34.656     0.200
     1.278    11.779     0.200
     2.301    14.843     0.200
     2.610    13.238     0.200
     2.610    14.238     0.200
     4.640    18.142     0.200
     5.315    18.370     0.200
     5.412    18.739     0.200
     5.484    19.065     0.200
     5.505    18.546     0.200
     5.584    19.231     0.200
     5.837    19.573     0.200
     6.001    22.758     0.200
     6.018    20.317     0.200
     6.031    20.306     0.200
     6.168    23.008     0.200
     6.168    24.108     0.200
     6.557    21.474     0.200
     6.600    21.345     0.200
     6.630    22.123     0.200
     7.729    23.799     0.200
     7.729    23.598     0.200
     8.985    26.940     0.200
     9.600    27.965     0.200
     1.643    11.259     0.200
     1.844    12.410     0.200
     1.868    12.126     0.200
     2.206    13.183     0.200
     2.381    13.140     0.200
     2.357    14.423     0.200
     2.790    13.195     0.200
     2.790    14.265     0.200
     2.757    14.752     0.200
     2.950    14.499     0.200
     3.149    13.186     0.200
     3.346    15.035     0.200
     3.345    14.789     0.200
     3.384    16.443     0.200
     3.454    15.322     0.200
     3.469    13.420     0.200
     3.703    17.366     0.200
     3.794    15.825     0.200
     3.850    15.998     0.200
     3.954    15.208     0.200
     3.944    19.899     0.200
     4.068    15.613     0.200
     4.124    16.410     0.200
     4.232    16.313     0.200
     4.337    17.087     0.200
     4.372    18.294     0.200
     4.510    18.091     0.200
     4.579    16.043     0.200
     4.538    19.972     0.200
     4.571    16.979     0.200
     4.567    18.628     0.200
     4.697    17.219     0.200
     4.650    18.662     0.200
     4.759    17.595     0.200
     4.798    17.902     0.200
     4.806    16.893     0.200
     4.963    17.917     0.200
     5.000    18.083     0.200
     4.998    19.499     0.200
     5.056    18.026     0.200
     5.077    18.145     0.200
     5.158    20.421     0.200
     5.178    18.866     0.200
     5.277    18.553     0.200
     5.286    18.742     0.200
     5.208    21.147     0.200
     5.371    18.852     0.200
     5.635    18.878     0.200
     5.636    20.155     0.200
     5.723    20.263     0.200
     5.828    19.704     0.200
     5.879    19.724     0.200
     5.879    19.927     0.200
     5.843    21.241     0.200
     5.939    21.440     0.200
     5.982    20.514     0.200
     5.921    21.030     0.200
     6.069    20.313     0.200
     6.189    20.708     0.200
     6.205    20.521     0.200
     6.271    22.645     0.200
     6.452    21.405     0.200
     6.387    21.894     0.200
     6.464    20.388     0.200
     6.492    22.264     0.200
     6.555    21.140     0.200
     6.628    21.010     0.200
     6.631    21.128     0.200
     6.633    21.127     0.200
     6.711    21.821     0.200
     6.968    21.906     0.200
     6.997    22.169     0.200
     7.391    27.174     0.200
     7.520    22.871     0.200
     7.520    22.668     0.200
     7.570    23.008     0.200
     7.897    24.066     0.200
     7.933    26.156     0.200
     8.099    24.652     0.200
     8.176    23.807     0.200
     8.176    26.095     0.200
     8.169    21.907     0.200
     8.879    25.705     0.200
     8.905    25.215     0.200
     8.996    27.520     0.200
     9.263    28.147     0.200
     9.260    31.871     0.200
     9.346    26.969     0.200
     9.399    26.604     0.200
     9.385    27.597     0.200
     9.511    25.942     0.200
     9.630    29.183     0.200
     9.728    33.404     0.200
     9.858    28.286     0.200
    10.064    30.060     0.200
    10.066    30.097     0.200
    10.011    32.106     0.200
    10.116    28.672     0.200
    10.147    29.058     0.200
    10.180    27.696     0.200
    10.205    28.297     0.200
    10.125    32.775     0.200
    10.237    30.595     0.200
    10.268    28.745     0.200
    10.235    25.286     0.200
    10.320    28.865     0.200
    10.284    30.921     0.200
    10.437    29.925     0.200
    10.448    29.794     0.200
    10.451    29.646     0.200
    10.469    30.158     0.200
    10.506    30.025     0.200
    10.573    30.743     0.200
    10.606    26.748     0.200
    10.757    30.099     0.200
    10.824    30.610     0.200
    10.903    35.696     0.200
    10.903    35.696     0.200
    10.960    28.925     0.200
    10.943    34.229     0.200
    10.991    29.447     0.200
    11.114    29.085     0.200
    11.304    32.011     0.200
    11.458    29.532     0.200
    11.745    29.621     0.200
    11.759    33.701     0.200
    12.247    33.605     0.200
    12.292    35.024     0.200
    12.682    32.435     0.200
    13.033    36.036     0.200
    13.076    34.430     0.200
    13.241    33.912     0.200
    13.701    40.239     0.200
    13.729    36.815     0.200
    13.732    35.680     0.200
    13.757    36.888     0.200
    13.962    37.198     0.200
    14.023    34.783     0.200
    13.964    33.766     0.200
    14.119    36.861     0.200
    14.165    37.019     0.200
    14.296    39.091     0.200
    14.338    36.408     0.200
    14.425    36.890     0.200
    14.524    37.729     0.200
    14.776    38.491     0.200
    14.876    37.330     0.200
    15.145    37.683     0.200
    15.184    38.135     0.200
    15.264    37.696     0.200
    15.285    37.452     0.200
    15.290    41.796     0.200
    15.434    39.420     0.200
    15.613    39.020     0.200
    15.731    40.246     0.200
    15.936    40.159     0.200
    17.808    41.715     0.200
    18.209    42.636     0.200
    18.533    44.552     0.200
    18.571    42.803     0.200
    18.571    42.701     0.200
    18.720    44.133     0.200
    18.949    42.730     0.200
    18.957    44.106     0.200
    19.005    43.746     0.200
    19.026    43.624     0.200
    19.178    43.073     0.200
    19.340    43.061     0.200
    19.452    43.779     0.200
    19.514    44.703     0.200
    19.534    42.960     0.200
    19.823    42.700     0.200
    19.831    43.058     0.200
    19.886    42.814     0.200
    20.048    42.459     0.200
    20.026    43.458     0.200
    20.312    41.817     0.200
    20.572    42.462     0.200
    20.768    43.779     0.200
    21.001    42.540     0.200
     2.389    10.638     0.200
     3.338    14.294     0.200
     3.685    12.753     0.200
     3.707    12.651     0.200
     3.724    12.607     0.200
     3.743    12.231     0.200
     3.853    14.629     0.200
     3.991    15.983     0.200
     4.068    13.693     0.200
     4.185    14.530     0.200
     4.728    15.227     0.200
     2.099    12.214     0.200
     2.455    14.061     0.200
     2.529    11.198     0.200
     3.086    13.699     0.200
     5.118    18.107     0.200
     5.405    18.306     0.200
     5.446    18.163     0.200
     5.546    18.889     0.200
     5.623    18.196     0.200
     5.622    18.583     0.200
     5.718    18.184     0.200
     5.732    18.815     0.200
     5.960    19.766     0.200
     6.009    19.182     0.200
     6.176    19.943     0.200
     6.178    19.480     0.200
     6.693    19.807     0.200
     6.745    21.152     0.200
     6.762    21.899     0.200
     6.937    21.464     0.200
     7.425    23.662     0.200
     7.456    22.402     0.200
     7.873    23.840     0.200
     9.133    26.529     0.200
     1.633    10.673     0.200
     1.773    11.045     0.200
     2.578    11.648     0.200
     2.891    14.994     0.200
     3.013    14.573     0.200
     3.018    14.516     0.200
     3.335    14.818     0.200
     4.616    16.510     0.200
     4.857    15.181     0.200
     4.985    17.125     0.200
     4.985    18.054     0.200
     5.478    17.011     0.200
     5.468    17.223     0.200
     5.588    17.026     0.200
     5.598    16.906     0.200
     5.568    19.714     0.200
     5.701    17.304     0.200
     5.693    17.653     0.200
     5.786    18.152     0.200
     5.863    17.364     0.200
     5.845    19.598     0.200
     5.946    18.245     0.200
     6.231    18.522     0.200
     6.223    18.839     0.200
     6.287    18.471     0.200
     6.441    18.247     0.200
     6.510    20.729     0.200
     6.510    21.869     0.200
     6.621    18.886     0.200
     6.716    18.369     0.200
     6.748    19.582     0.200
     6.696    20.481     0.200
     6.696    22.192     0.200
     6.798    20.108     0.200
     6.863    19.627     0.200
     7.022    19.992     0.200
     7.420    22.044     0.200
     7.559    21.126     0.200
     7.829    23.060     0.200
     7.975    21.869     0.200
     8.018    21.428     0.200
     8.536    23.222     0.200
     9.265    25.215     0.200
    10.040    26.478     0.200
    10.032    26.751     0.200
    11.429    30.362     0.200
    11.429    30.971     0.200
     1.667     9.715     0.200
     2.273    11.944     0.200
     2.593    14.212     0.200
     3.852    16.517     0.200
     4.607    16.103     0.200
     4.772    16.180     0.200
     5.193    16.462     0.200
     5.342    16.730     0.200
     5.452    17.146     0.200
     5.502    18.361     0.200
     5.488    17.124     0.200
     5.537    17.486     0.200
     5.591    17.317     0.200
     5.678    17.713     0.200
     5.835    17.977     0.200
     6.084    18.671     0.200
     6.112    18.544     0.200
     6.199    18.436     0.200
     6.236    19.476     0.200
     6.363    19.329     0.200
     6.601    19.629     0.200
     6.661    21.033     0.200
     6.685    19.390     0.200
     6.860    19.712     0.200
     7.305    21.517     0.200
     7.389    21.143     0.200
     7.773    21.795     0.200
     7.805    21.979     0.200
     9.082    24.985     0.200
     9.315    25.412     0.200
     1.686    10.620     0.200
     2.001    13.443     0.200
     2.264    13.373     0.200
     2.613    14.293     0.200
     3.620    16.551     0.200
     5.560    17.911     0.200
     5.701    17.858     0.200
     6.708    20.705     0.200
     1.995    13.030     0.200
     2.361    12.762     0.200
     2.581    13.193     0.200
     2.715    15.624     0.200
     5.370    17.446     0.200
     5.468    17.902     0.200
     5.541    18.427     0.200
     5.555    17.983     0.200
     5.648    18.402     0.200
     5.645    18.045     0.200
     6.083    19.553     0.200
     6.091    19.629     0.200
     6.614    20.531     0.200
     6.660    20.851     0.200
     1.947    11.270     0.200
     4.766    16.168     0.200
     4.836    16.355     0.200
     4.883    16.534     0.200
     4.911    16.688     0.200
     5.047    16.596     0.200
     5.110    17.155     0.200
     5.163    18.535     0.200
     5.223    18.454     0.200
     5.334    18.673     0.200
     5.343    17.538     0.200
     5.933    18.863     0.200
     1.874    11.739     0.200
     2.908    12.845     0.200
     2.908    15.072     0.200
     3.390    14.809     0.200
     3.390    17.539     0.200
     3.573    16.028     0.200
     4.218    17.564     0.200
     4.333    17.840     0.200
     4.483    17.532     0.200
     4.483    18.895     0.200
     4.531    16.816     0.200
     4.672    17.277     0.200
     4.811    18.022     0.200
     5.026    18.059     0.200
     5.407    20.882     0.200
     5.537    19.023     0.200
     1.630    10.569     0.200
     1.630    11.569     0.200
     3.075    13.697     0.200
     4.173    16.884     0.200
     5.368    18.544     0.200
     5.422    18.117     0.200
     5.451    18.668     0.200
     5.560    21.135     0.200
     5.687    19.241     0.200
     5.687    20.222     0.200
     5.902    20.210     0.200
     7.174    22.869     0.200
     8.764    25.921     0.200
     9.648    27.538     0.200
     2.153    11.947     0.200
     4.001    14.111     0.200
     4.075    12.767     0.200
     4.359    14.686     0.200
     4.565    15.691     0.200
     5.092    15.956     0.200
     2.519    12.225     0.200
     5.171    17.670     0.200
     5.315    17.888     0.200
     5.282    18.173     0.200
     5.568    18.741     0.200
     5.947    19.614     0.200
     7.223    21.925     0.200
     5.350    17.325     0.200
     5.880    18.706     0.200
     5.895    19.061     0.200
     6.462    19.077     0.200
     1.976    11.948     0.200
     3.077    12.650     0.200
     4.034    15.926     0.200
     4.109    16.350     0.200
     4.162    16.346     0.200
     4.162    15.432     0.200
     4.222    15.532     0.200
     4.422    16.907     0.200
     4.479    16.457     0.200
     4.678    17.113     0.200
     4.666    16.616     0.200
     4.666    16.952     0.200
     4.745    17.490     0.200
     5.241    17.607     0.200
     1.990    10.842     0.200
     2.173    12.704     0.200
     2.233    13.499     0.200
     2.314    12.676     0.200
     2.853    13.813     0.200
     3.071    13.227     0.200
     3.256    14.158     0.200
     3.309    13.941     0.200
     3.707    14.323     0.200
     3.707    13.982     0.200
     3.784    16.925     0.200
     3.778    14.249     0.200
     4.022    14.026     0.200
     4.097    14.249     0.200
     4.151    14.703     0.200
     4.061    16.034     0.200
     4.079    17.173     0.200
     4.095    17.338     0.200
     4.141    16.037     0.200
     4.212    14.609     0.200
     4.297    15.412     0.200
     4.361    15.972     0.200
     4.409    15.206     0.200
     4.471    15.433     0.200
     4.594    16.355     0.200
     4.658    16.800     0.200
     4.668    15.690     0.200
     4.717    15.409     0.200
     4.660    16.478     0.200
     4.743    18.314     0.200
     4.836    17.329     0.200
     4.892    18.468     0.200
     4.947    19.005     0.200
     5.230    17.326     0.200
     5.230    16.926     0.200
     5.231    16.948     0.200
     5.258    17.005     0.200
     5.445    17.324     0.200
     5.690    19.502     0.200
     5.790    18.087     0.200
     5.949    18.835     0.200
     5.972    18.674     0.200
     5.972    18.544     0.200
     6.031    19.082     0.200
     6.031    19.782     0.200
     6.043    18.936     0.200
     6.096    20.674     0.200
     6.235    19.286     0.200
     6.235    19.116     0.200
     6.355    19.304     0.200
     6.365    19.481     0.200
     6.450    19.033     0.200
     6.801    22.982     0.200
     7.147    21.275     0.200
     7.128    21.556     0.200
     7.607    21.854     0.200
     7.981    24.176     0.200
     8.354    24.173     0.200
     8.438    23.891     0.200
     8.540    23.505     0.200
     8.828    25.837     0.200
     8.835    25.574     0.200
     8.817    25.329     0.200
     9.512    25.792     0.200
     9.654    26.489     0.200
     9.692    26.968     0.200
     9.763    27.569     0.200
     9.789    27.394     0.200
     9.896    28.111     0.200
     9.921    29.397     0.200
    10.115    28.924     0.200
    10.119    28.570     0.200
    10.149    27.922     0.200
    10.151    28.597     0.200
    10.172    28.610     0.200
    10.201    27.935     0.200
    10.573    28.881     0.200
    12.836    33.369     0.200
    12.973    33.067     0.200
    13.624    34.566     0.200
    13.679    34.227     0.200
    14.434    35.213     0.200
    14.669    37.270     0.200
    14.839    36.092     0.200
    14.836    35.621     0.200
    15.228    37.054     0.200
    15.567    37.496     0.200
    15.657    37.840     0.200
     2.413    13.385     0.200
     5.194    17.725     0.200
     5.298    18.309     0.200
     5.360    17.985     0.200
     5.360    17.743     0.200
     5.379    18.310     0.200
     5.458    18.549     0.200
     5.504    18.669     0.200
     5.504    18.403     0.200
     5.590    19.103     0.200
     5.700    19.417     0.200
     5.811    20.058     0.200
     5.811    20.331     0.200
     5.943    19.684     0.200
     6.515    20.058     0.200
     6.697    22.177     0.200
     7.222    22.762     0.200
     1.401    10.265     0.200
     3.327    14.785     0.200
     3.481    15.557     0.200
     3.979    15.552     0.200
     4.362    18.030     0.200
     4.674    16.670     0.200
     4.739    16.811     0.200
     4.796    17.135     0.200
     4.969    17.542     0.200
     5.028    17.662     0.200
     5.057    17.800     0.200
     5.088    18.707     0.200
     5.265    18.060     0.200
     5.259    18.539     0.200
     5.307    17.540     0.200
     5.307    18.392     0.200
     5.307    17.228     0.200
     5.352    18.852     0.200
     5.662    18.634     0.200
     5.819    19.392     0.200
     5.861    19.813     0.200
     6.055    19.946     0.200
     6.304    22.250     0.200
     6.544    21.035     0.200
     6.687    21.273     0.200
     6.958    21.905     0.200
     8.172    24.810     0.200
     8.903    25.815     0.200
     9.028    25.856     0.200
     1.965    12.268     0.200
     4.180    14.012     0.200
     4.466    15.802     0.200
     4.669    16.431     0.200
     4.785    17.097     0.200
     5.052    17.752     0.200
     5.052    19.642     0.200
     5.252    16.811     0.200
     5.334    17.058     0.200
     5.391    17.183     0.200
     5.447    16.898     0.200
     5.567    17.629     0.200
     5.642    17.961     0.200
     5.713    19.696     0.200
     5.713    20.833     0.200
     5.804    18.364     0.200
     5.787    18.369     0.200
     5.907    18.162     0.200
     5.956    19.088     0.200
     6.238    19.008     0.200
     6.470    19.094     0.200
     6.468    19.528     0.200
     6.686    20.276     0.200
     7.031    20.454     0.200
     7.188    21.210     0.200
     7.254    21.647     0.200
     7.345    21.073     0.200
     7.604    21.962     0.200
     8.160    23.175     0.200
     8.836    24.883     0.200
     8.816    23.999     0.200
     9.042    25.077     0.200
     9.151    25.310     0.200
     9.575    26.114     0.200
     9.676    26.135     0.200
    10.062    27.035     0.200
     4.810    17.648     0.200
     4.919    18.143     0.200
     5.263    18.108     0.200
     5.353    18.055     0.200
     5.419    18.176     0.200
     5.500    17.977     0.200
     5.560    19.841     0.200
     5.656    19.925     0.200
     5.799    19.350     0.200
     5.894    19.845     0.200
     5.953    19.955     0.200
     6.246    19.838     0.200
     6.518    20.649     0.200
     6.724    21.660     0.200
     7.234    22.302     0.200
     8.897    25.803     0.200
     2.593    13.641     0.200
     4.610    16.702     0.200
     5.346    17.516     0.200
     5.456    17.631     0.200
     5.493    17.706     0.200
     5.493    17.581     0.200
     5.542    17.759     0.200
     5.596    18.203     0.200
     5.682    17.558     0.200
     5.743    18.487     0.200
     5.983    18.765     0.200
     6.116    19.238     0.200
     6.202    18.984     0.200
     6.316    19.401     0.200
     6.689    19.959     0.200
     6.864    20.902     0.200
     7.166    21.480     0.200
     5.421    17.457     0.200
     5.504    17.492     0.200
     5.562    17.614     0.200
     5.618    17.777     0.200
     6.059    20.012     0.200
     6.078    19.189     0.200
     6.407    20.353     0.200
     6.639    19.968     0.200
     2.043    12.442     0.200
     2.524    12.529     0.200
     3.164    13.391     0.200
     3.441    14.482     0.200
     3.988    14.307     0.200
     4.105    17.337     0.200
     4.041    13.424     0.200
     4.053    14.169     0.200
     4.169    16.586     0.200
     4.374    15.741     0.200
     4.403    15.401     0.200
     4.403    15.701     0.200
     4.472    15.296     0.200
     4.644    15.986     0.200
     5.007    16.336     0.200
     4.989    16.263     0.200
     5.277    17.398     0.200
     5.410    19.470     0.200
     5.676    17.851     0.200
     1.319     8.284     0.200
     3.135    13.651     0.200
     3.307    13.640     0.200
     4.050    14.591     0.200
     4.106    13.559     0.200
     4.064    18.120     0.200
     4.131    13.464     0.200
     4.136    14.946     0.200
     4.514    14.194     0.200
     4.514    15.483     0.200
     4.538    15.323     0.200
     5.066    16.649     0.200
     5.082    15.770     0.200
     5.346    17.487     0.200
     1.790    11.099     0.200
     2.118    11.497     0.200
     3.521    16.904     0.200
     3.495    16.204     0.200
     3.642    15.485     0.200
     3.704    15.759     0.200
     4.013    16.155     0.200
     4.861    17.029     0.200
     4.921    16.814     0.200
     5.222    17.147     0.200
     5.322    18.402     0.200
     5.356    18.110     0.200
     5.475    17.101     0.200
     5.580    17.370     0.200
     5.516    19.565     0.200
     5.635    17.328     0.200
     5.635    17.718     0.200
     5.661    17.979     0.200
     5.603    19.266     0.200
     5.631    20.591     0.200
     5.735    17.664     0.200
     5.785    17.756     0.200
     5.871    18.178     0.200
     5.978    18.432     0.200
     6.211    18.607     0.200
     6.225    18.848     0.200
     6.263    19.027     0.200
     6.267    21.860     0.200
     6.448    19.041     0.200
     6.411    19.570     0.200
     6.437    21.906     0.200
     6.729    20.068     0.200
     6.748    19.846     0.200
     6.793    20.515     0.200
     6.796    19.998     0.200
     6.980    20.338     0.200
     7.012    24.035     0.200
     7.108    20.351     0.200
     7.289    20.923     0.200
     7.211    23.081     0.200
     7.446    21.894     0.200
     7.446    22.094     0.200
     7.504    21.523     0.200
     7.557    24.377     0.200
     7.649    21.127     0.200
     7.642    23.391     0.200
     7.834    22.112     0.200
     7.834    21.975     0.200
     7.920    22.360     0.200
     8.051    23.092     0.200
     8.480    23.827     0.200
     8.480    23.387     0.200
     8.804    25.248     0.200
     8.804    24.148     0.200
     8.806    24.126     0.200
     8.837    24.465     0.200
     9.188    25.262     0.200
     9.276    25.244     0.200
     9.365    25.303     0.200
     9.355    25.327     0.200
     9.471    25.463     0.200
     9.517    27.124     0.200
     9.461    27.245     0.200
     9.809    26.525     0.200
     9.832    26.551     0.200
     9.944    27.069     0.200
    10.116    27.635     0.200
    10.283    29.702     0.200
    11.188    29.852     0.200
    11.302    29.259     0.200
    11.349    31.113     0.200
    11.314    31.937     0.200
    11.395    30.887     0.200
    11.395    30.200     0.200
    11.463    31.292     0.200
    11.482    31.958     0.200
    11.691    33.192     0.200
    11.701    32.043     0.200
    11.718    32.236     0.200
    11.726    32.810     0.200
    11.749    31.758     0.200
    12.099    33.598     0.200
    13.271    35.503     0.200
     2.713    12.623     0.200
     3.169    13.304     0.200
     4.814    16.215     0.200
     4.886    16.372     0.200
     4.935    16.747     0.200
     4.970    16.910     0.200
     5.086    17.396     0.200
     5.200    17.206     0.200
     5.292    18.631     0.200
     5.386    17.736     0.200
     5.434    17.871     0.200
     5.991    18.846     0.200
     6.219    19.712     0.200
     6.575    20.462     0.200
     6.715    21.227     0.200
     2.862    11.116     0.200
     3.074    15.261     0.200
     3.330    15.719     0.200
     3.400    15.552     0.200
     3.947    16.346     0.200
     4.017    16.410     0.200
     4.086    18.055     0.200
     4.365    17.593     0.200
     4.632    17.100     0.200
     4.845    17.494     0.200
     4.879    17.481     0.200
     4.891    17.531     0.200
     5.379    18.807     0.200
     5.610    19.417     0.200
     5.833    19.237     0.200
     5.802    20.040     0.200
     6.777    22.225     0.200
     1.918    13.003     0.200
     5.508    18.124     0.200
     5.641    18.209     0.200
     5.828    17.944     0.200
     6.211    19.139     0.200
     6.822    20.324     0.200
     1.774    11.172     0.200
     5.155    17.319     0.200
     5.265    17.438     0.200
     5.492    17.754     0.200
     5.552    18.384     0.200
     5.792    18.737     0.200
     5.792    18.987     0.200
     5.821    18.522     0.200
     5.925    18.733     0.200
     6.125    19.189     0.200
     6.499    19.709     0.200
     7.202    21.536     0.200
     1.375     8.550     0.200
     1.768    12.467     0.200
     4.451    16.508     0.200
     4.466    16.026     0.200
     4.566    16.118     0.200
     4.582    15.666     0.200
     4.585    15.296     0.200
     4.959    16.035     0.200
     5.173    17.228     0.200
     5.213    17.066     0.200
     5.476    17.246     0.200
     5.538    17.477     0.200
     5.645    17.325     0.200
     5.771    18.957     0.200
     1.702    10.297     0.200
     3.077    10.539     0.200
     4.316    14.389     0.200
     4.371    14.040     0.200
     4.405    12.835     0.200
     4.402    13.083     0.200
     4.642    15.583     0.200
     4.642    13.394     0.200
     4.560    13.811     0.200
     4.690    14.120     0.200
     4.917    15.076     0.200
     4.875    14.767     0.200
     5.303    15.664     0.200
     5.424    15.773     0.200
     6.042    16.745     0.200
     6.152    17.464     0.200
     6.577    18.230     0.200
     7.116    19.807     0.200
     2.505    10.103     0.200
     2.723    10.241     0.200
     3.153    11.978     0.200
     3.625    11.052     0.200
     3.677    11.244     0.200
     3.716    11.036     0.200
     3.710    11.582     0.200
     3.923    13.515     0.200
     4.096    13.132     0.200
     4.184    12.422     0.200
     4.235    13.031     0.200
     4.253    12.262     0.200
     4.738    14.461     0.200
     4.789    14.363     0.200
     4.976    14.690     0.200
     5.463    15.699     0.200
     5.918    15.764     0.200
     7.096    18.662     0.200
     7.833    20.834     0.200
     5.241    17.202     0.200
     5.320    17.477     0.200
     5.375    17.703     0.200
     5.424    17.780     0.200
     5.488    18.524     0.200
     5.488    19.133     0.200
     5.563    17.773     0.200
     5.620    18.006     0.200
     5.630    18.360     0.200
     5.746    18.827     0.200
     5.879    18.662     0.200
     5.879    18.764     0.200
     5.886    18.784     0.200
     6.228    18.989     0.200
     6.445    20.235     0.200
     6.667    20.867     0.200
     7.015    20.700     0.200
     7.166    21.633     0.200
     7.630    22.752     0.200
     8.810    25.458     0.200
     9.546    27.061     0.200
     9.654    25.924     0.200
     5.329    16.234     0.200
     5.441    16.332     0.200
     5.726    17.302     0.200
     5.966    17.258     0.200
     5.966    18.107     0.200
     6.105    17.877     0.200
     6.298    17.931     0.200
     7.151    20.276     0.200
     1.664    11.683     0.200
     1.774    11.906     0.200
     2.252    11.819     0.200
     2.462    14.374     0.200
     5.171    17.453     0.200
     5.205    17.758     0.200
     5.205    17.178     0.200
     5.259    17.436     0.200
     5.309    17.723     0.200
     5.309    18.153     0.200
     5.407    17.359     0.200
     5.457    18.321     0.200
     5.552    18.413     0.200
     5.697    18.585     0.200
     5.748    18.786     0.200
     5.838    18.879     0.200
     5.961    19.178     0.200
     6.029    19.044     0.200
     6.412    19.034     0.200
     6.881    21.598     0.200
     1.442     9.276     0.200
     1.446     9.229     0.200
     2.296    12.704     0.200
     2.803    11.622     0.200
     2.870    12.439     0.200
     2.948    12.312     0.200
     2.869    13.024     0.200
     2.957    13.710     0.200
     3.007    14.041     0.200
     3.608    15.312     0.200
     3.739    16.036     0.200
     3.856    14.849     0.200
     3.874    14.257     0.200
     3.971    13.921     0.200
     4.037    15.510     0.200
     4.155    13.668     0.200
     4.183    13.589     0.200
     4.191    14.394     0.200
     4.469    15.243     0.200
     4.524    15.103     0.200
     4.667    15.142     0.200
     4.773    14.836     0.200
     4.773    15.398     0.200
     4.863    16.246     0.200
     4.835    18.108     0.200
     4.964    16.331     0.200
     5.138    16.242     0.200
     5.195    16.878     0.200
     5.223    16.719     0.200
     5.284    17.831     0.200
     5.696    18.322     0.200
     5.726    18.079     0.200
     6.094    18.787     0.200
     6.319    19.357     0.200
     6.721    20.610     0.200
     7.735    22.439     0.200
     8.120    23.362     0.200
     9.144    26.289     0.200
     1.964    12.274     0.200
     2.027    11.536     0.200
     2.316    13.165     0.200
     3.168    16.229     0.200
     3.237    15.421     0.200
     3.299    15.701     0.200
     3.637    17.757     0.200
     3.704    16.392     0.200
     3.754    16.392     0.200
     3.890    16.940     0.200
     3.893    16.862     0.200
     3.896    17.126     0.200
     3.954    17.052     0.200
     4.120    19.117     0.200
     4.300    18.013     0.200
     4.376    15.844     0.200
     4.434    15.357     0.200
     4.657    17.316     0.200
     4.687    16.495     0.200
     4.705    18.537     0.200
     5.262    19.008     0.200
     5.330    17.792     0.200
     5.305    20.269     0.200
     5.355    20.315     0.200
     5.385    19.590     0.200
     5.427    18.158     0.200
     5.500    18.561     0.200
     5.519    18.286     0.200
     5.519    17.755     0.200
     5.611    18.359     0.200
     5.601    18.309     0.200
     5.602    20.276     0.200
     5.724    18.993     0.200
     5.731    21.474     0.200
     5.852    19.407     0.200
     5.869    19.068     0.200
     5.968    19.332     0.200
     5.968    19.442     0.200
     6.018    21.535     0.200
     6.048    19.619     0.200
     6.036    19.635     0.200
     6.185    22.758     0.200
     6.309    20.068     0.200
     6.476    22.862     0.200
     6.572    20.893     0.200
     6.594    20.640     0.200
     6.616    20.666     0.200
     6.566    22.640     0.200
     6.660    22.361     0.200
     6.705    21.946     0.200
     6.753    23.490     0.200
     6.811    21.104     0.200
     7.006    20.034     0.200
     7.084    22.630     0.200
     7.315    22.536     0.200
     7.315    21.989     0.200
     7.335    19.041     0.200
     7.328    22.377     0.200
     7.302    23.979     0.200
     7.422    21.676     0.200
     7.604    22.258     0.200
     7.700    23.436     0.200
     7.745    23.311     0.200
     7.851    23.309     0.200
     7.918    25.579     0.200
     8.136    24.050     0.200
     8.304    24.589     0.200
     8.528    24.720     0.200
     8.665    24.974     0.200
     8.933    25.750     0.200
     8.934    25.734     0.200
     8.949    27.749     0.200
     9.001    25.548     0.200
     9.001    25.696     0.200
     9.111    25.818     0.200
     9.188    26.175     0.200
     9.201    26.217     0.200
     9.206    27.718     0.200
     9.295    26.425     0.200
     9.413    26.746     0.200
     9.616    27.270     0.200
     9.652    28.054     0.200
     9.658    26.983     0.200
     9.752    27.679     0.200
     9.817    25.457     0.200
     9.817    27.424     0.200
     9.945    27.841     0.200
    10.027    29.671     0.200
    10.273    30.259     0.200
    10.669    25.436     0.200
    10.662    31.190     0.200
    10.739    29.379     0.200
    11.022    29.492     0.200
    11.034    34.650     0.200
    11.049    32.001     0.200
    11.069    30.978     0.200
    11.093    33.355     0.200
    11.132    32.225     0.200
    11.159    30.139     0.200
    11.152    33.121     0.200
    11.169    31.702     0.200
    11.182    30.526     0.200
    11.220    30.192     0.200
    11.241    32.381     0.200
    11.315    32.420     0.200
    11.451    32.406     0.200
    11.454    32.625     0.200
    11.476    30.972     0.200
    11.509    31.106     0.200
    11.551    32.829     0.200
    11.588    32.522     0.200
    11.584    31.815     0.200
    11.601    32.205     0.200
    11.644    32.713     0.200
    11.849    33.624     0.200
    11.970    33.484     0.200
    13.049    37.264     0.200
    13.700    34.921     0.200
    13.725    33.115     0.200
    14.103    34.011     0.200
    14.263    33.852     0.200
    14.756    33.888     0.200
    15.023    35.277     0.200
    15.039    34.791     0.200
    15.602    35.827     0.200
    15.616    36.054     0.200
    15.824    36.925     0.200
    15.888    36.988     0.200
    16.171    36.475     0.200
    16.212    36.901     0.200
    16.230    38.687     0.200
    16.459    37.317     0.200
    16.456    37.549     0.200
    16.462    37.289     0.200
    16.595    37.734     0.200
    16.758    38.236     0.200
    16.926    40.273     0.200
    17.022    39.049     0.200
    17.039    38.141     0.200
    17.969    40.002     0.200
    18.228    37.871     0.200
    18.320    40.797     0.200
    18.876    43.275     0.200
    18.969    43.331     0.200
    19.237    42.707     0.200
    19.334    43.463     0.200
    19.330    42.714     0.200
    19.330    42.511     0.200
    19.553    43.508     0.200
    19.599    43.481     0.200
    19.599    42.278     0.200
    20.036    42.169     0.200
    20.885    42.962     0.200
     3.200    11.924     0.200
     3.778    12.882     0.200
     4.452    17.019     0.200
     4.676    14.605     0.200
     5.198    15.911     0.200
     5.236    15.872     0.200
     5.355    18.476     0.200
     5.435    16.240     0.200
     5.839    17.026     0.200
     5.922    17.665     0.200
     6.239    16.765     0.200
     6.271    16.888     0.200
     6.604    17.702     0.200
     6.609    16.743     0.200
     6.646    16.769     0.200
     6.646    17.316     0.200
     6.667    17.769     0.200
     6.857    17.596     0.200
     6.857    18.155     0.200
     6.856    18.060     0.200
     6.866    17.743     0.200
     6.761    23.077     0.200
     7.219    18.825     0.200
     7.347    19.131     0.200
     7.347    18.932     0.200
     7.536    21.047     0.200
     7.893    20.563     0.200
     7.917    20.482     0.200
     8.248    21.216     0.200
     8.320    22.180     0.200
     8.441    21.867     0.200
     8.854    23.344     0.200
     8.854    23.044     0.200
     9.249    23.639     0.200
     9.435    24.969     0.200
     9.828    24.585     0.200
    10.204    25.586     0.200
    10.509    26.434     0.200
    11.313    29.096     0.200
     0.239     6.948     0.200
     0.833     7.020     0.200
     1.221     8.498     0.200
     1.788     8.870     0.200
     2.333    11.514     0.200
     3.701    10.253     0.200
     3.734    10.559     0.200
     4.066    11.390     0.200
     4.119    12.577     0.200
     4.180    13.264     0.200
     4.335    12.158     0.200
     4.681    13.415     0.200
     1.976    10.590     0.200
     2.113     9.993     0.200
     5.701    16.724     0.200
     5.758    17.455     0.200
     5.808    16.336     0.200
     5.966    17.131     0.200
     6.424    17.687     0.200
     6.424    18.378     0.200
     6.513    18.446     0.200
     2.124    10.145     0.200
     5.317    18.097     0.200
     5.432    18.339     0.200
     5.523    17.877     0.200
     5.586    18.893     0.200
     5.682    18.409     0.200
     5.714    19.256     0.200
     5.952    20.120     0.200
     5.952    20.276     0.200
     6.030    19.608     0.200
     6.109    20.243     0.200
     6.281    20.433     0.200
     6.583    21.017     0.200
     6.685    21.122     0.200
     7.972    23.238     0.200
     9.085    26.472     0.200
     9.849    28.551     0.200
     2.837    12.416     0.200
     2.956    13.373     0.200
     4.721    16.304     0.200
     4.839    15.663     0.200
     4.905    16.291     0.200
     4.948    16.870     0.200
     4.964    16.847     0.200
     5.129    17.016     0.200
     5.160    17.606     0.200
     5.128    16.873     0.200
     5.244    17.834     0.200
     5.433    17.723     0.200
     5.986    18.498     0.200
     6.712    20.600     0.200
     7.146    21.891     0.200
     8.338    23.985     0.200
     1.152     7.092     0.200
     4.031    13.602     0.200
     4.360    13.745     0.200
     4.549    14.752     0.200
     4.658    14.411     0.200
     5.112    15.357     0.200
     2.302    12.557     0.200
     5.133    17.918     0.200
     5.242    18.145     0.200
     5.387    18.660     0.200
     5.468    18.013     0.200
     5.874    19.274     0.200
     5.901    19.557     0.200
     6.000    18.771     0.200
     6.104    19.788     0.200
     6.475    20.655     0.200
     1.348     8.384     0.200
     1.868    10.908     0.200
     2.178    11.282     0.200
     2.525    12.233     0.200
     3.364    15.439     0.200
     3.506    15.790     0.200
     3.776    15.638     0.200
     3.910    15.804     0.200
     3.955    16.543     0.200
     4.097    15.963     0.200
     4.103    16.248     0.200
     4.321    16.975     0.200
     4.361    17.428     0.200
     4.507    17.421     0.200
     4.523    17.265     0.200
     4.645    14.634     0.200
     4.819    16.760     0.200
     4.856    16.846     0.200
     4.900    15.391     0.200
     4.910    17.206     0.200
     5.303    17.758     0.200
     5.495    17.171     0.200
     5.519    20.066     0.200
     5.569    18.708     0.200
     5.598    17.476     0.200
     5.600    18.930     0.200
     5.666    17.481     0.200
     5.675    17.787     0.200
     5.763    17.708     0.200
     5.763    17.548     0.200
     5.790    17.721     0.200
     5.891    18.054     0.200
     5.945    19.951     0.200
     6.005    18.223     0.200
     6.073    18.240     0.200
     6.134    18.494     0.200
     6.228    18.722     0.200
     6.233    18.768     0.200
     6.233    20.705     0.200
     6.245    18.950     0.200
     6.471    19.185     0.200
     6.690    22.690     0.200
     6.745    20.086     0.200
     6.803    19.887     0.200
     6.964    23.683     0.200
     7.212    21.643     0.200
     7.306    21.538     0.200
     7.468    20.698     0.200
     7.513    21.433     0.200
     7.516    23.532     0.200
     7.632    21.040     0.200
     7.814    21.408     0.200
     7.814    21.809     0.200
     7.851    20.685     0.200
     7.873    22.425     0.200
     7.929    22.368     0.200
     8.049    22.592     0.200
     8.309    23.234     0.200
     8.489    23.841     0.200
     8.489    23.641     0.200
     8.737    23.979     0.200
     8.773    26.627     0.200
     8.847    24.056     0.200
     9.154    27.773     0.200
     9.192    25.231     0.200
     9.192    24.891     0.200
     9.248    21.840     0.200
     9.283    26.673     0.200
     9.325    25.199     0.200
     9.373    25.219     0.200
     9.358    25.493     0.200
     9.420    27.098     0.200
     9.480    25.474     0.200
     9.810    26.420     0.200
     9.842    26.151     0.200
     9.946    26.783     0.200
    10.001    26.451     0.200
    10.127    27.221     0.200
    10.240    29.064     0.200
    10.476    30.826     0.200
    10.875    30.343     0.200
    10.924    28.839     0.200
    11.201    28.684     0.200
    11.294    29.099     0.200
    11.351    30.070     0.200
    11.368    30.802     0.200
    11.378    29.569     0.200
    11.434    29.042     0.200
    11.664    30.668     0.200
    11.669    30.129     0.200
    11.690    30.780     0.200
    11.688    34.456     0.200
    11.722    30.511     0.200
    11.765    31.832     0.200
    11.802    32.046     0.200
    11.795    32.798     0.200
    12.063    30.425     0.200
    12.183    32.831     0.200
    13.004    31.948     0.200
    13.192    34.907     0.200
    13.192    35.757     0.200
    13.658    34.925     0.200
    14.317    33.919     0.200
    14.477    33.055     0.200
    14.464    37.711     0.200
    14.966    33.952     0.200
    15.236    34.398     0.200
    15.251    34.720     0.200
    15.808    35.829     0.200
    15.827    35.900     0.200
    15.825    35.923     0.200
    16.015    36.905     0.200
    16.032    36.016     0.200
    16.097    36.653     0.200
    16.386    36.480     0.200
    16.430    37.062     0.200
    16.426    36.510     0.200
    16.437    37.882     0.200
    16.584    36.466     0.200
    16.667    37.201     0.200
    16.674    36.919     0.200
    16.672    37.936     0.200
    16.806    38.373     0.200
    16.972    37.239     0.200
    17.138    39.103     0.200
    17.234    37.987     0.200
    17.252    37.869     0.200
    18.476    41.493     0.200
    18.491    41.713     0.200
    18.533    42.018     0.200
    18.607    43.647     0.200
    18.721    41.826     0.200
    19.084    42.047     0.200
    19.160    42.902     0.200
    19.182    42.048     0.200
    19.253    41.417     0.200
    19.447    41.474     0.200
    19.549    41.370     0.200
    19.543    41.441     0.200
    19.694    41.780     0.200
    19.768    41.111     0.200
    19.813    41.047     0.200
    19.813    41.586     0.200
    20.193    41.437     0.200
    20.990    40.049     0.200
     2.000    11.777     0.200
     2.627    12.462     0.200
     5.699    18.917     0.200
     5.798    18.349     0.200
     6.813    20.807     0.200
     2.614    14.003     0.200
     3.137    13.899     0.200
     5.227    17.299     0.200
     5.262    17.622     0.200
     6.284    19.630     0.200
     2.656    13.833     0.200
     3.215    16.310     0.200
     3.400    16.703     0.200
     4.070    16.142     0.200
     4.403    17.880     0.200
     4.765    19.904     0.200
     4.871    20.116     0.200
     5.265    18.890     0.200
     5.336    18.955     0.200
     5.384    19.419     0.200
     5.261    21.282     0.200
     5.409    19.057     0.200
     5.534    19.750     0.200
     5.602    19.707     0.200
     5.572    19.600     0.200
     5.651    19.883     0.200
     5.558    23.180     0.200
     5.678    20.081     0.200
     5.836    20.326     0.200
     5.877    20.248     0.200
     5.901    20.021     0.200
     5.901    20.271     0.200
     5.954    20.351     0.200
     6.253    20.859     0.200
     6.214    22.340     0.200
     6.431    21.329     0.200
     6.464    21.493     0.200
     6.796    24.809     0.200
     7.023    22.667     0.200
     7.156    23.119     0.200
     7.209    22.597     0.200
     7.227    23.308     0.200
     7.586    23.900     0.200
     7.592    23.540     0.200
     8.015    24.889     0.200
     8.124    25.329     0.200
     8.170    25.565     0.200
     8.785    26.414     0.200
     9.113    27.379     0.200
     9.380    27.662     0.200
     9.515    27.725     0.200
     9.641    28.431     0.200
    10.552    30.562     0.200
    10.788    31.708     0.200
    10.868    31.233     0.200
    10.802    31.781     0.200
    10.930    31.120     0.200
     1.993    12.229     0.200
     2.583    12.335     0.200
     4.497    14.236     0.200
     5.321    17.987     0.200
     5.388    16.808     0.200
     5.486    17.265     0.200
     5.559    17.536     0.200
     5.573    17.143     0.200
     5.573    16.924     0.200
     5.663    16.848     0.200
     5.666    17.513     0.200
     5.907    18.048     0.200
     5.932    18.197     0.200
     6.026    18.427     0.200
     6.079    19.662     0.200
     6.109    18.594     0.200
     6.099    18.606     0.200
     6.115    18.523     0.200
     6.366    18.789     0.200
     6.632    19.893     0.200
     6.678    19.986     0.200
     7.193    21.242     0.200
     7.389    21.349     0.200
     7.667    21.279     0.200
     7.759    22.631     0.200
     7.914    22.432     0.200
     9.063    25.115     0.200
     9.063    25.314     0.200
     9.814    26.509     0.200
     2.678    12.541     0.200
     5.000    16.235     0.200
     5.050    16.560     0.200
     5.084    16.715     0.200
     5.197    17.137     0.200
     5.264    16.853     0.200
     5.271    17.020     0.200
     5.314    17.670     0.200
     5.549    17.933     0.200
     5.564    17.462     0.200
     5.916    18.054     0.200
     6.106    18.768     0.200
     6.829    20.494     0.200
     3.313    14.764     0.200
     3.414    14.296     0.200
     3.752    15.190     0.200
     3.874    14.928     0.200
     3.879    16.270     0.200
     3.913    15.173     0.200
     4.051    16.060     0.200
     4.721    17.993     0.200
     4.817    17.923     0.200
     4.810    16.598     0.200
     4.856    16.568     0.200
     4.873    16.707     0.200
     4.862    17.081     0.200
     4.911    17.743     0.200
     5.186    18.214     0.200
     5.151    18.950     0.200
     5.162    17.834     0.200
     5.295    18.349     0.200
     5.439    18.209     0.200
     5.439    18.769     0.200
     5.354    19.351     0.200
     5.800    19.651     0.200
     5.828    19.028     0.200
     5.947    19.441     0.200
     5.939    21.176     0.200
     6.101    20.246     0.200
     6.560    20.783     0.200
     6.904    20.675     0.200
     8.132    23.585     0.200
     1.380     9.474     0.200
     1.243     9.083     0.200
     1.820    11.345     0.200
     2.186    11.864     0.200
     2.320    10.382     0.200
     2.365    12.979     0.200
     2.347    12.195     0.200
     2.977    14.017     0.200
     3.693    12.887     0.200
     3.682    13.556     0.200
     3.737    12.470     0.200
     3.777    15.512     0.200
     3.801    13.458     0.200
     4.011    15.770     0.200
     3.935    16.605     0.200
     4.164    13.395     0.200
     4.310    14.192     0.200
     4.672    14.659     0.200
     4.703    14.941     0.200
     1.801    10.197     0.200
     2.616    13.686     0.200
     2.979    13.443     0.200
     3.063    14.466     0.200
     3.666    14.758     0.200
     4.201    15.974     0.200
     4.237    16.661     0.200
     4.471    16.231     0.200
     4.476    16.584     0.200
     4.731    17.727     0.200
     4.812    16.564     0.200
     5.376    16.993     0.200
     5.488    17.080     0.200
     5.514    18.085     0.200
     5.773    18.164     0.200
     6.154    18.905     0.200
     6.343    18.699     0.200
     6.900    20.204     0.200
     7.198    20.826     0.200
     1.386     9.716     0.200
     2.554    13.078     0.200
     2.961    13.564     0.200
     2.989    15.001     0.200
     3.092    14.804     0.200
     3.701    15.176     0.200
     3.833    15.649     0.200
     4.265    16.313     0.200
     4.473    17.343     0.200
     4.515    16.595     0.200
     4.838    17.180     0.200
     1.671    10.025     0.200
     4.718    18.215     0.200
     4.754    18.687     0.200
     5.110    18.892     0.200
     5.174    18.646     0.200
     5.174    18.993     0.200
     5.244    18.931     0.200
     5.298    18.994     0.200
     5.298    19.494     0.200
     5.353    19.210     0.200
     5.544    20.024     0.200
     5.571    19.510     0.200
     5.975    20.400     0.200
     6.004    20.411     0.200
     6.053    20.884     0.200
     6.271    21.067     0.200
     6.391    21.637     0.200
     6.554    21.452     0.200
     6.687    22.092     0.200
     6.947    22.760     0.200
     7.235    22.992     0.200
     7.511    23.874     0.200
     8.960    27.161     0.200
     1.777     8.302     0.200
     3.528    15.372     0.200
     3.953    16.593     0.200
     4.051    16.469     0.200
     4.051    15.478     0.200
     4.110    16.376     0.200
     4.226    16.844     0.200
     4.342    17.274     0.200
     4.407    17.506     0.200
     4.431    17.155     0.200
     4.555    18.500     0.200
     4.753    17.976     0.200
     4.970    18.143     0.200
     4.971    18.066     0.200
     5.689    19.651     0.200
     5.775    20.095     0.200
     5.811    20.959     0.200
     1.388     9.396     0.200
     2.071    12.125     0.200
     2.644    12.447     0.200
     4.401    15.194     0.200
     4.949    18.053     0.200
     5.316    17.363     0.200
     5.411    17.448     0.200
     5.482    17.140     0.200
     5.579    17.328     0.200
     5.601    17.840     0.200
     5.841    18.934     0.200
     5.980    21.034     0.200
     6.003    17.649     0.200
     6.027    19.065     0.200
     6.296    19.825     0.200
     6.556    20.491     0.200
     6.594    19.400     0.200
     7.308    21.817     0.200
     7.390    20.942     0.200
     8.978    24.052     0.200
     2.640    12.153     0.200
     3.273    13.773     0.200
     3.758    13.687     0.200
     3.390    14.385     0.200
     3.813    13.040     0.200
     3.849    13.366     0.200
     3.860    13.010     0.200
     4.066    15.297     0.200
     4.137    15.657     0.200
     4.328    14.534     0.200
     4.363    16.030     0.200
     4.746    15.663     0.200
     4.882    16.125     0.200
     4.929    16.523     0.200
     5.118    17.315     0.200
     5.607    17.607     0.200
     5.620    17.044     0.200
     5.807    18.484     0.200
     6.064    18.528     0.200
     7.241    21.180     0.200
     2.903    13.104     0.200
     3.282    16.849     0.200
     3.459    15.235     0.200
     3.974    14.980     0.200
     4.138    16.463     0.200
     4.191    16.447     0.200
     4.216    16.062     0.200
     4.222    16.343     0.200
     4.377    16.483     0.200
     4.492    18.627     0.200
     4.508    17.640     0.200
     4.515    17.165     0.200
     4.689    17.034     0.200
     4.744    17.087     0.200
     4.766    15.922     0.200
     5.125    17.943     0.200
     5.238    17.865     0.200
     5.483    19.457     0.200
     5.965    19.533     0.200
     2.213    10.730     0.200
     2.217    10.676     0.200
     2.224    10.803     0.200
     2.483     9.118     0.200
     2.730    12.092     0.200
     3.049    11.282     0.200
     3.133    12.745     0.200
     3.374    12.527     0.200
     3.417    14.285     0.200
     3.736    13.854     0.200
     3.650    14.230     0.200
     3.833    12.815     0.200
     3.842    12.467     0.200
     3.805    17.487     0.200
     3.870    12.885     0.200
     3.887    12.996     0.200
     3.967    13.437     0.200
     4.089    14.203     0.200
     4.082    15.317     0.200
     4.201    13.626     0.200
     4.217    15.241     0.200
     4.217    15.075     0.200
     4.245    14.044     0.200
     4.322    14.808     0.200
     4.453    14.071     0.200
     4.453    14.281     0.200
     4.463    14.073     0.200
     4.555    16.916     0.200
     4.474    14.140     0.200
     4.815    14.958     0.200
     4.863    14.812     0.200
     4.962    15.138     0.200
     4.931    17.769     0.200
     5.124    15.951     0.200
     5.413    18.690     0.200
     5.477    17.455     0.200
     5.515    16.592     0.200
     5.594    16.771     0.200
     5.651    16.758     0.200
     5.651    16.645     0.200
     5.720    17.300     0.200
     5.844    17.249     0.200
     5.844    17.365     0.200
     5.990    17.659     0.200
     6.005    17.572     0.200
     6.070    18.116     0.200
     6.491    19.099     0.200
     6.449    18.815     0.200
     6.553    18.679     0.200
     6.935    19.714     0.200
     7.160    19.937     0.200
     7.194    20.099     0.200
     7.211    21.688     0.200
     7.428    20.460     0.200
     7.539    20.768     0.200
     7.782    21.230     0.200
     7.912    21.323     0.200
     8.069    21.553     0.200
     8.209    22.446     0.200
     8.560    25.856     0.200
     9.333    23.667     0.200
     9.552    26.593     0.200
     2.600    11.301     0.200
     3.072    11.930     0.200
     3.203    12.913     0.200
     3.440    14.958     0.200
     4.073    13.872     0.200
     4.146    15.523     0.200
     4.153    14.998     0.200
     4.131    15.661     0.200
     4.102    16.597     0.200
     4.205    15.038     0.200
     4.559    15.103     0.200
     4.733    15.779     0.200
     5.090    17.158     0.200
     5.367    17.777     0.200
     5.590    17.677     0.200
     5.771    18.758     0.200
     5.822    18.265     0.200
     6.230    19.101     0.200
     7.394    21.428     0.200
     7.756    22.400     0.200
     2.490    11.442     0.200
     2.371    12.359     0.200
     2.889     9.610     0.200
     3.226    12.632     0.200
     3.136    12.350     0.200
     3.509    12.724     0.200
     3.522    12.405     0.200
     3.749    13.425     0.200
     3.927    13.856     0.200
     4.005    14.870     0.200
     4.084    13.523     0.200
     4.074    16.261     0.200
     4.199    14.937     0.200
     4.339    14.997     0.200
     4.506    14.522     0.200
     4.710    16.180     0.200
     4.936    15.982     0.200
     5.192    16.793     0.200
     5.224    17.211     0.200
     5.670    16.711     0.200
     5.905    17.388     0.200
     6.148    18.966     0.200
     6.748    20.224     0.200
     9.897    27.404     0.200
     1.884    11.244     0.200
     2.772    14.316     0.200
     3.570    16.002     0.200
     4.220    16.088     0.200
     4.978    16.818     0.200
     5.023    17.166     0.200
     5.045    17.469     0.200
     5.191    17.632     0.200
     5.216    17.346     0.200
     5.254    17.330     0.200
     5.332    18.110     0.200
     5.487    18.274     0.200
     5.544    18.092     0.200
     5.544    18.514     0.200
     5.697    22.427     0.200
     6.067    19.321     0.200
     6.301    19.974     0.200
     6.720    20.798     0.200
     6.792    21.041     0.200
     6.887    21.405     0.200
     7.206    22.112     0.200
     8.421    24.504     0.200
     5.185    16.619     0.200
     5.271    16.714     0.200
     5.411    17.381     0.200
     5.492    16.809     0.200
     5.492    18.240     0.200
     5.730    17.762     0.200
     5.823    17.122     0.200
     5.823    18.571     0.200
     6.170    18.729     0.200
     6.633    19.819     0.200
     6.971    20.372     0.200
     7.140    21.005     0.200
     7.556    22.349     0.200
     8.113    23.152     0.200
     8.796    24.976     0.200
     2.201    11.569     0.200
     2.353    11.139     0.200
     2.431    10.787     0.200
     2.422    13.232     0.200
     2.761    12.452     0.200
     2.935    11.846     0.200
     3.230    13.062     0.200
     3.560    17.958     0.200
     3.680    16.199     0.200
     3.888    12.951     0.200
     3.816    17.089     0.200
     3.953    14.609     0.200
     3.970    14.363     0.200
     3.966    17.274     0.200
     4.038    14.933     0.200
     4.638    17.370     0.200
     5.272    19.808     0.200
     5.424    17.009     0.200
     1.682     8.328     0.200
     2.487    12.517     0.200
     3.224    12.059     0.200
     4.109    15.229     0.200
     4.275    14.669     0.200
     4.281    13.687     0.200
     4.304    15.668     0.200
     4.397    13.559     0.200
     4.400    14.230     0.200
     4.737    15.095     0.200
     5.292    15.934     0.200
     5.353    16.505     0.200
     1.979    11.745     0.200
     2.325    12.365     0.200
     2.421    13.005     0.200
     2.525    12.138     0.200
     2.616    14.018     0.200
     2.586    12.499     0.200
     2.635    13.552     0.200
     2.635    13.504     0.200
     2.676    12.940     0.200
     2.766    14.138     0.200
     3.139    14.637     0.200
     3.150    13.814     0.200
     3.192    15.072     0.200
     3.289    15.723     0.200
     3.294    12.222     0.200
     3.390    15.796     0.200
     3.520    13.518     0.200
     3.630    14.989     0.200
     3.639    14.639     0.200
     3.650    14.694     0.200
     3.774    14.551     0.200
     3.907    15.978     0.200
     3.960    14.220     0.200
     4.029    14.885     0.200
     4.141    17.131     0.200
     4.160    15.722     0.200
     4.366    17.226     0.200
     4.508    18.262     0.200
     4.569    15.804     0.200
     4.611    16.042     0.200
     4.664    16.421     0.200
     4.678    15.685     0.200
     4.695    15.922     0.200
     4.804    16.028     0.200
     4.801    18.991     0.200
     4.901    16.982     0.200
     4.940    16.703     0.200
     4.940    16.539     0.200
     4.988    16.527     0.200
     4.988    16.745     0.200
     4.988    17.138     0.200
     5.154    17.807     0.200
     5.250    20.696     0.200
     5.250    21.165     0.200
     5.444    20.134     0.200
     5.518    19.210     0.200
     5.598    18.724     0.200
     5.700    18.203     0.200
     5.951    19.003     0.200
     6.068    21.633     0.200
     6.288    19.532     0.200
     6.288    19.344     0.200
     6.330    19.584     0.200
     6.400    20.562     0.200
     6.429    20.033     0.200
     6.451    19.901     0.200
     6.451    20.074     0.200
     6.453    19.894     0.200
     6.527    19.251     0.200
     6.527    20.282     0.200
     6.506    22.347     0.200
     6.626    20.826     0.200
     6.626    20.498     0.200
     6.841    20.518     0.200
     6.888    21.067     0.200
     7.113    23.474     0.200
     7.171    23.023     0.200
     7.313    21.806     0.200
     7.390    21.605     0.200
     7.393    22.009     0.200
     7.771    22.369     0.200
     7.727    24.477     0.200
     7.905    23.589     0.200
     7.973    25.319     0.200
     8.035    22.781     0.200
     8.267    23.575     0.200
     8.348    24.136     0.200
     8.378    23.981     0.200
     8.624    24.412     0.200
     8.749    24.847     0.200
     8.758    24.925     0.200
     8.792    26.154     0.200
     8.907    24.708     0.200
     9.046    25.180     0.200
     9.058    26.860     0.200
     9.320    26.071     0.200
     9.812    26.779     0.200
     9.874    29.272     0.200
     9.979    27.897     0.200
     9.979    27.225     0.200
    10.016    27.400     0.200
    10.026    28.358     0.200
    10.079    29.157     0.200
    10.144    27.280     0.200
    10.174    27.397     0.200
    10.315    29.976     0.200
    10.318    29.505     0.200
    10.378    29.914     0.200
    12.129    32.432     0.200
    12.485    30.858     0.200
    13.995    37.150     0.200
    17.644    41.045     0.200
    18.606    42.973     0.200
    18.639    43.447     0.200
    20.325    44.294     0.200
     1.992    11.365     0.200
     1.981    13.022     0.200
     2.121    12.941     0.200
     2.301    12.530     0.200
     2.398    12.937     0.200
     2.546    14.290     0.200
     2.558    12.947     0.200
     2.612    13.428     0.200
     2.794    13.910     0.200
     3.111    14.194     0.200
     3.169    12.603     0.200
     3.176    13.592     0.200
     3.266    15.274     0.200
     3.269    12.246     0.200
     3.385    15.257     0.200
     3.494    15.036     0.200
     3.615    15.444     0.200
     3.628    14.441     0.200
     3.747    14.415     0.200
     3.881    15.224     0.200
     4.001    15.172     0.200
     3.987    14.209     0.200
     4.113    18.147     0.200
     4.182    17.058     0.200
     4.545    16.917     0.200
     4.596    15.983     0.200
     4.648    16.278     0.200
     4.658    15.734     0.200
     4.678    15.960     0.200
     4.780    16.969     0.200
     4.774    18.857     0.200
     4.876    16.980     0.200
     4.929    16.804     0.200
     4.975    16.371     0.200
     4.975    16.558     0.200
     5.135    17.900     0.200
     5.201    17.324     0.200
     5.223    21.478     0.200
     5.583    18.663     0.200
     5.680    18.571     0.200
     5.932    18.992     0.200
     5.932    19.343     0.200
     6.040    22.256     0.200
     6.262    18.929     0.200
     6.312    19.557     0.200
     6.409    20.233     0.200
     6.424    20.113     0.200
     6.611    20.373     0.200
     6.821    20.822     0.200
     7.370    22.015     0.200
     7.878    23.843     0.200
     8.014    23.503     0.200
     8.247    23.882     0.200
     8.357    23.995     0.200
     8.602    24.439     0.200
     8.729    24.656     0.200
     8.729    24.953     0.200
     8.736    24.699     0.200
     8.887    24.459     0.200
     9.026    25.286     0.200
     1.447     9.531     0.200
     1.531     9.264     0.200
     3.976    18.700     0.200
     4.043    14.148     0.200
     4.047    13.505     0.200
     4.384    15.168     0.200
     4.999    16.397     0.200
     5.583    18.375     0.200
     5.599    18.487     0.200
     2.376    13.420     0.200
     2.456    10.331     0.200
     2.683    12.253     0.200
     2.817    12.861     0.200
     2.852    13.055     0.200
     2.959    13.209     0.200
     3.074    15.231     0.200
     3.253    13.587     0.200
     3.327    15.350     0.200
     3.705    17.105     0.200
     3.910    14.265     0.200
     3.958    14.537     0.200
     3.984    14.435     0.200
     3.990    14.485     0.200
     3.978    14.444     0.200
     3.991    18.239     0.200
     4.063    15.231     0.200
     4.319    16.031     0.200
     4.367    16.465     0.200
     4.367    14.986     0.200
     4.387    15.957     0.200
     4.387    17.037     0.200
     4.453    19.861     0.200
     4.568    16.826     0.200
     4.790    20.364     0.200
     4.934    17.447     0.200
     4.927    17.019     0.200
     5.204    17.604     0.200
     5.295    20.754     0.200
     5.449    17.806     0.200
     5.608    18.187     0.200
     5.612    18.359     0.200
     5.660    18.483     0.200
     5.820    18.263     0.200
     5.963    20.244     0.200
     5.963    19.182     0.200
     6.068    19.114     0.200
     6.159    19.559     0.200
     6.576    20.493     0.200
     6.555    20.215     0.200
     6.612    20.473     0.200
     6.999    20.854     0.200
     7.084    22.193     0.200
     7.234    21.905     0.200
     7.234    21.209     0.200
     7.193    23.333     0.200
     7.592    22.333     0.200
     7.595    22.403     0.200
     7.813    22.552     0.200
     7.946    23.074     0.200
     7.969    23.037     0.200
     8.021    26.230     0.200
     8.126    23.483     0.200
     8.269    23.931     0.200
     9.426    29.725     0.200
     9.539    28.980     0.200
     9.823    30.198     0.200
     9.970    30.084     0.200
     1.993     9.020     0.200
     2.197    11.917     0.200
     2.396    12.584     0.200
     2.377    13.298     0.200
     2.476    11.007     0.200
     2.703    10.845     0.200
     2.718    13.143     0.200
     2.836    11.916     0.200
     2.871    12.191     0.200
     2.947    13.754     0.200
     2.978    11.896     0.200
     3.093    13.744     0.200
     3.271    13.584     0.200
     3.346    14.280     0.200
     3.518    15.260     0.200
     3.759    13.401     0.200
     3.660    14.636     0.200
     3.928    12.837     0.200
     3.974    13.741     0.200
     4.000    13.732     0.200
     4.007    13.436     0.200
     3.997    13.374     0.200
     4.009    17.069     0.200
     4.083    14.413     0.200
     4.334    15.332     0.200
     4.380    15.694     0.200
     4.380    14.392     0.200
     4.401    14.356     0.200
     4.414    15.599     0.200
     4.471    18.779     0.200
     4.471    17.849     0.200
     4.602    14.969     0.200
     4.806    18.699     0.200
     4.950    16.446     0.200
     4.946    15.594     0.200
     5.221    16.679     0.200
     5.313    19.079     0.200
     5.469    16.469     0.200
     5.625    17.369     0.200
     5.632    17.347     0.200
     5.632    17.724     0.200
     5.678    17.651     0.200
     6.087    18.383     0.200
     6.176    18.440     0.200
     6.354    20.922     0.200
     6.593    19.570     0.200
     6.630    19.039     0.200
     7.017    19.521     0.200
     7.103    21.248     0.200
     7.254    20.665     0.200
     7.254    20.515     0.200
     7.502    21.467     0.200
     7.613    21.567     0.200
     7.832    21.808     0.200
     7.987    22.501     0.200
     8.039    25.207     0.200
     8.144    22.674     0.200
     8.288    23.198     0.200
     1.976     9.367     0.200
     2.483    10.985     0.200
     2.708    12.969     0.200
     2.847    13.728     0.200
     2.979    12.708     0.200
     3.098    13.749     0.200
     3.347    14.665     0.200
     3.640    15.133     0.200
     3.518    15.551     0.200
     4.011    17.630     0.200
     3.942    14.343     0.200
     3.785    17.556     0.200
     4.007    15.151     0.200
     4.090    15.173     0.200
     3.991    13.373     0.200
     4.023    14.541     0.200
     4.017    13.371     0.200
     4.471    18.985     0.200
     4.352    15.066     0.200
     4.399    15.811     0.200
     4.419    16.078     0.200
     4.633    16.491     0.200
     4.605    16.473     0.200
     4.960    16.319     0.200
     4.968    16.381     0.200
     5.311    20.014     0.200
     5.237    16.643     0.200
     5.476    16.986     0.200
     5.641    17.224     0.200
     5.692    17.524     0.200
     6.101    18.259     0.200
     7.266    20.558     0.200
     7.627    21.450     0.200
     1.997    11.756     0.200
     2.023     9.091     0.200
     3.685    16.428     0.200
     3.920    14.084     0.200
     3.993    14.552     0.200
     3.997    14.889     0.200
     4.023    17.485     0.200
     4.087    16.695     0.200
     4.938    16.038     0.200
     5.330    19.448     0.200
     1.495     8.963     0.200
     1.898    10.338     0.200
     2.043    11.495     0.200
     2.300     9.971     0.200
     2.582    13.174     0.200
     3.070    11.810     0.200
     3.178    14.164     0.200
     3.589    16.294     0.200
     5.406    16.274     0.200
     5.468    16.554     0.200
     5.536    16.338     0.200
     5.712    17.511     0.200
     5.758    17.326     0.200
     5.864    18.833     0.200
     5.898    17.652     0.200
     6.305    18.290     0.200
     6.556    19.054     0.200
     6.768    19.588     0.200
     7.107    19.932     0.200
     7.274    20.278     0.200
     8.929    24.072     0.200
     8.929    23.596     0.200
     1.425    10.333     0.200
     1.484     9.645     0.200
     2.052    12.308     0.200
     2.390    14.242     0.200
     2.450    12.311     0.200
     2.656    14.239     0.200
     3.014    13.383     0.200
     3.112    13.913     0.200
     3.275    15.447     0.200
     3.794    17.988     0.200
     3.920    17.134     0.200
     3.978    17.823     0.200
     4.448    17.188     0.200
     4.605    17.143     0.200
     4.807    17.823     0.200
     4.837    18.141     0.200
     4.846    18.236     0.200
     5.179    18.352     0.200
     5.841    20.023     0.200
     1.933    14.828     0.200
     3.025    16.581     0.200
     3.004    14.188     0.200
     3.243    16.013     0.200
     3.414    17.308     0.200
     3.462    17.407     0.200
     4.163    14.573     0.200
     5.266    17.166     0.200
     5.345    17.341     0.200
     5.345    17.821     0.200
     5.417    17.644     0.200
     5.449    17.623     0.200
     5.512    18.299     0.200
     5.587    17.923     0.200
     5.655    18.327     0.200
     5.684    21.333     0.200
     5.770    19.210     0.200
     5.823    18.666     0.200
     5.904    18.539     0.200
     5.904    18.727     0.200
     5.911    18.940     0.200
     6.253    19.054     0.200
     7.040    20.761     0.200
     7.158    21.236     0.200
     7.192    21.492     0.200
     7.607    22.645     0.200
     7.655    22.272     0.200
     8.162    23.666     0.200
     8.835    25.220     0.200
     8.835    24.720     0.200
     9.153    25.706     0.200
     9.437    26.292     0.200
     9.572    26.370     0.200
     9.679    25.881     0.200
     9.813    27.709     0.200
     2.842    13.339     0.200
     3.447    14.269     0.200
     3.801    16.397     0.200
     5.403    15.975     0.200
     5.499    15.851     0.200
     5.594    16.643     0.200
     5.668    15.311     0.200
     5.685    16.166     0.200
     6.041    16.976     0.200
     6.041    17.523     0.200
     6.091    16.307     0.200
     6.382    17.645     0.200
     7.397    20.097     0.200
     1.589     9.941     0.200
     2.182    13.311     0.200
     6.095    20.419     0.200
     6.175    20.588     0.200
     6.223    21.220     0.200
     6.438    21.515     0.200
     6.469    21.152     0.200
     6.668    22.335     0.200
     6.982    22.266     0.200
     7.878    24.415     0.200
     7.943    25.853     0.200
     8.163    24.282     0.200
     1.815    11.305     0.200
     2.470    13.691     0.200
     2.985    14.025     0.200
     3.394    15.261     0.200
     3.790    16.074     0.200
     4.842    17.157     0.200
     5.053    18.514     0.200
     5.093    18.482     0.200
     7.010    21.930     0.200
     1.924    11.605     0.200
     2.053    12.100     0.200
     2.980    12.627     0.200
     3.078    13.709     0.200
     3.412    12.831     0.200
     3.384    13.113     0.200
     3.517    14.314     0.200
     3.601    13.625     0.200
     3.764    14.972     0.200
     3.766    14.478     0.200
     4.189    15.017     0.200
     4.389    14.736     0.200
     4.484    15.995     0.200
     4.773    17.350     0.200
     5.281    18.101     0.200
     5.459    17.545     0.200
     6.075    19.056     0.200
     6.193    19.983     0.200
     7.166    20.769     0.200
     1.815    10.380     0.200
     2.770    13.495     0.200
     3.564    15.072     0.200
     3.672    17.578     0.200
     4.322    17.711     0.200
     4.778    18.345     0.200
     4.783    18.346     0.200
     1.737    10.337     0.200
     1.768    11.179     0.200
     1.758    12.425     0.200
     1.959    13.884     0.200
     2.309    11.069     0.200
     2.550    15.941     0.200
     2.526    15.667     0.200
     2.891    14.041     0.200
     3.020    13.482     0.200
     3.117    14.780     0.200
     3.384    15.083     0.200
     3.566    18.182     0.200
     3.778    16.586     0.200
     3.860    14.895     0.200
     3.861    16.195     0.200
     3.909    15.932     0.200
     3.983    14.365     0.200
     3.984    14.799     0.200
     3.994    14.142     0.200
     4.231    17.286     0.200
     4.231    18.209     0.200
     4.332    15.392     0.200
     4.428    16.072     0.200
     4.428    15.253     0.200
     4.435    15.695     0.200
     4.543    17.010     0.200
     4.867    20.005     0.200
     4.870    20.202     0.200
     4.948    16.702     0.200
     5.062    18.973     0.200
     5.291    18.898     0.200
     5.585    19.069     0.200
     5.603    18.763     0.200
     5.907    19.299     0.200
     6.881    22.433     0.200
     9.020    26.825     0.200
     9.292    27.390     0.200
     1.810    11.290     0.200
     2.340    11.027     0.200
     3.164    14.780     0.200
     3.440    15.650     0.200
     3.826    16.268     0.200
     3.886    15.415     0.200
     3.869    14.481     0.200
     3.942    15.785     0.200
     3.983    14.404     0.200
     4.281    17.652     0.200
     1.763     8.627     0.200
     1.786     9.112     0.200
     2.004     9.177     0.200
     2.383    10.058     0.200
     2.968    12.111     0.200
     3.096    13.030     0.200
     3.195    12.868     0.200
     3.856    15.430     0.200
     3.919    13.135     0.200
     3.932    14.426     0.200
     3.984    14.875     0.200
     4.026    13.605     0.200
     4.034    13.309     0.200
     4.040    12.138     0.200
     4.378    13.795     0.200
     5.138    18.097     0.200
     5.367    16.911     0.200
     5.639    16.276     0.200
     1.571     8.359     0.200
     1.617     9.449     0.200
     1.883    11.177     0.200
     1.947     9.687     0.200
     2.026     8.834     0.200
     2.529    12.377     0.200
     2.569     9.783     0.200
     3.039    10.964     0.200
     3.340    11.497     0.200
     3.411    14.725     0.200
     3.506    13.478     0.200
     3.549    12.502     0.200
     3.697    14.122     0.200
     3.880    15.050     0.200
     4.339    16.210     0.200
     4.614    15.461     0.200
     4.618    15.332     0.200
     4.659    13.692     0.200
     4.786    14.522     0.200
     4.791    13.967     0.200
     5.196    15.552     0.200
     5.196    14.391     0.200
     5.213    14.397     0.200
     5.665    16.675     0.200
     1.982    13.052     0.200
     2.287    14.822     0.200
     3.047    12.693     0.200
     3.691    15.692     0.200
     4.067    14.668     0.200
     4.182    15.994     0.200
     4.228    17.356     0.200
     4.269    16.316     0.200
     4.269    16.006     0.200
     4.380    17.324     0.200
     4.443    17.001     0.200
     4.565    18.067     0.200
     4.634    17.072     0.200
     4.722    19.746     0.200
     4.980    18.014     0.200
     5.200    19.247     0.200
     5.201    18.067     0.200
     5.415    19.544     0.200
     5.920    19.554     0.200
     6.017    19.144     0.200
     6.210    19.756     0.200
     6.335    20.401     0.200
     6.421    20.601     0.200
     1.750    11.319     0.200
     1.714    11.773     0.200
     2.331    13.384     0.200
     2.444    15.104     0.200
     2.480    14.249     0.200
     2.572    12.361     0.200
     2.639    13.971     0.200
     2.875    13.311     0.200
     2.946    14.426     0.200
     3.620    13.718     0.200
     3.676    14.703     0.200
     3.950    16.446     0.200
     3.959    15.707     0.200
     4.108    15.092     0.200
     4.360    17.239     0.200
     4.475    19.262     0.200
     4.845    16.360     0.200
     4.909    16.709     0.200
     4.950    16.919     0.200
     4.961    16.830     0.200
     5.118    17.322     0.200
     5.139    17.719     0.200
     5.135    19.955     0.200
     5.228    18.491     0.200
     5.228    19.227     0.200
     5.430    18.633     0.200
     5.584    22.776     0.200
     5.983    19.031     0.200
     6.030    19.520     0.200
     6.030    19.041     0.200
     6.222    20.280     0.200
     6.398    23.646     0.200
     6.589    20.907     0.200
     6.615    20.725     0.200
     6.710    20.896     0.200
     6.780    20.893     0.200
     6.858    22.568     0.200
     6.858    21.115     0.200
     7.123    21.766     0.200
     7.138    21.231     0.200
     7.150    21.957     0.200
     7.675    22.823     0.200
     8.052    24.229     0.200
     8.332    24.459     0.200
     8.332    24.269     0.200
     8.665    25.181     0.200
     9.061    25.815     0.200
     9.193    25.815     0.200
    10.102    27.623     0.200
     2.543    12.157     0.200
     2.601    11.752     0.200
     2.903    12.488     0.200
     4.868    15.592     0.200
     4.931    16.858     0.200
     4.970    16.116     0.200
     4.976    16.384     0.200
     5.250    17.531     0.200
     5.999    18.284     0.200
     6.240    18.577     0.200
     6.725    20.811     0.200
     1.316     9.466     0.200
     1.220     8.196     0.200
     1.847    11.751     0.200
     2.090    11.153     0.200
     2.939    11.299     0.200
     3.109    10.715     0.200
     3.303    11.266     0.200
     3.739    12.723     0.200
     3.762    12.634     0.200
     4.077    13.591     0.200
     4.152    14.017     0.200
     4.082    14.640     0.200
     4.205    13.913     0.200
     4.263    13.796     0.200
     4.353    13.167     0.200
     4.464    14.674     0.200
     4.516    14.322     0.200
     4.649    14.515     0.200
     4.700    14.654     0.200
     4.771    16.958     0.200
     5.065    15.265     0.200
     5.284    16.402     0.200
     5.282    15.417     0.200
     6.001    16.934     0.200
     6.086    18.043     0.200
     6.086    17.277     0.200
     6.084    17.471     0.200
     6.274    17.313     0.200
     6.498    17.594     0.200
     7.658    20.527     0.200
     7.829    20.453     0.200
     8.403    22.031     0.200
     1.795    10.939     0.200
     2.337    11.302     0.200
     3.392    13.338     0.200
     3.443    13.839     0.200
     3.476    13.573     0.200
     3.489    14.316     0.200
     3.719    15.375     0.200
     4.020    15.520     0.200
     3.915    14.776     0.200
     4.056    17.924     0.200
     4.511    16.438     0.200
     5.113    18.250     0.200
     2.206    11.185     0.200
     2.710    14.354     0.200
     2.890    12.750     0.200
     2.989    15.397     0.200
     3.112    13.985     0.200
     3.546    14.444     0.200
     3.852    15.173     0.200
     3.923    15.347     0.200
     3.934    15.326     0.200
     3.973    13.592     0.200
     3.907    16.197     0.200
     4.026    13.534     0.200
     4.143    14.925     0.200
     4.237    16.175     0.200
     4.283    15.863     0.200
     4.487    15.557     0.200
     4.475    16.521     0.200
     4.575    17.418     0.200
     4.840    16.436     0.200
     5.045    16.729     0.200
     5.765    18.147     0.200
     5.858    18.092     0.200
     6.052    18.441     0.200
     7.420    21.923     0.200
     7.621    22.078     0.200
     2.810    13.333     0.200
     4.343    15.518     0.200
     4.399    15.039     0.200
     4.460    15.796     0.200
     4.654    16.490     0.200
     4.709    16.222     0.200
     4.903    16.588     0.200
     4.885    16.932     0.200
     5.254    16.697     0.200
     5.479    17.618     0.200
     1.807    11.900     0.200
     2.421    11.540     0.200
     2.489    11.653     0.200
     2.564    13.753     0.200
     2.774    14.340     0.200
     2.823    13.452     0.200
     2.933    14.623     0.200
     2.915    16.217     0.200
     2.998    15.211     0.200
     3.437    16.465     0.200
     3.884    17.100     0.200
     4.006    15.972     0.200
     4.253    15.716     0.200
     4.517    16.353     0.200
     4.570    16.431     0.200
     4.852    18.403     0.200
     5.157    18.191     0.200
     5.208    17.905     0.200
     5.519    18.668     0.200
     1.920    11.936     0.200
     2.376    12.414     0.200
     2.548    11.724     0.200
     2.619    14.548     0.200
     2.711    12.536     0.200
     2.567    13.368     0.200
     2.952    15.899     0.200
     3.019    14.202     0.200
     3.116    13.908     0.200
     3.718    17.709     0.200
     3.959    14.420     0.200
     4.370    16.676     0.200
     4.571    18.729     0.200
     5.252    16.814     0.200
     5.301    17.468     0.200
     5.360    17.479     0.200
     5.382    17.212     0.200
     5.395    17.498     0.200
     5.384    20.136     0.200
     5.490    18.720     0.200
     5.562    19.074     0.200
     5.606    18.106     0.200
     5.606    17.407     0.200
     5.663    18.094     0.200
     5.663    18.744     0.200
     5.893    18.963     0.200
     6.289    19.436     0.200
     6.404    19.478     0.200
     6.475    19.969     0.200
     6.591    22.630     0.200
     6.656    20.262     0.200
     6.945    22.292     0.200
     7.032    21.073     0.200
     7.133    21.186     0.200
     7.316    22.661     0.200
     7.546    22.177     0.200
     8.736    24.684     0.200
     1.949    11.705     0.200
     2.102     8.799     0.200
     2.924    10.738     0.200
     3.882    13.328     0.200
     3.954    13.790     0.200
     4.005    13.548     0.200
     4.060    13.161     0.200
     4.230    13.377     0.200
     4.268    14.325     0.200
     4.317    14.309     0.200
     4.461    13.976     0.200
     4.510    14.717     0.200
     4.871    14.694     0.200
     5.079    15.210     0.200
     5.296    16.438     0.200
     5.645    17.262     0.200
     5.798    16.670     0.200
     6.214    17.417     0.200
     6.296    17.785     0.200
     7.454    20.645     0.200
     7.454    20.463     0.200
     2.141    11.138     0.200
     2.957    12.243     0.200
     4.248    13.949     0.200
     4.367    14.165     0.200
     4.646    14.911     0.200
     5.212    15.903     0.200
     6.076    18.416     0.200
     3.841    18.016     0.200
     3.990    14.605     0.200
     4.063    14.760     0.200
     4.376    15.403     0.200
     4.567    15.775     0.200
     4.978    16.175     0.200
     1.749    12.266     0.200
     2.186    11.599     0.200
     2.420    14.185     0.200
     2.696    13.036     0.200
     2.835    12.597     0.200
     2.851    13.299     0.200
     3.638    13.269     0.200
     4.811    15.036     0.200
     4.877    15.060     0.200
     4.921    15.523     0.200
     4.939    15.788     0.200
     5.107    16.670     0.200
     5.195    17.254     0.200
     5.224    17.137     0.200
     5.392    16.550     0.200
     5.799    17.899     0.200
     5.961    17.995     0.200
     6.560    18.824     0.200
     6.686    19.448     0.200
     1.396    11.057     0.200
     2.050    13.257     0.200
     2.703    14.820     0.200
     3.329    16.163     0.200
     3.879    17.046     0.200
     5.449    20.008     0.200
     5.629    19.264     0.200
     5.905    20.569     0.200
     6.328    20.749     0.200
     7.355    23.861     0.200
     0.349     6.183     0.200
     0.750     7.702     0.200
     0.774     6.964     0.200
     0.791     7.162     0.200
     1.575     8.683     0.200
     1.669    10.286     0.200
     2.018     8.917     0.200
     2.080     8.218     0.200
     2.105    10.379     0.200
     4.535    14.111     0.200
     4.534    12.602     0.200
     4.638    12.884     0.200
     4.637    13.407     0.200
     4.972    13.892     0.200
     5.255    14.888     0.200
     5.547    14.815     0.200
     5.588    15.203     0.200
     6.250    16.282     0.200
     1.638    10.576     0.200
     1.638    10.173     0.200
     1.580    10.765     0.200
     2.025    11.138     0.200
     2.449    11.537     0.200
     2.511    12.288     0.200
     2.427    10.749     0.200
     2.517    10.304     0.200
     2.558    10.465     0.200
     2.738    10.518     0.200
     2.887    12.693     0.200
     2.928    11.610     0.200
     3.000    11.894     0.200
     3.281    12.419     0.200
     3.367    13.760     0.200
     3.648    12.807     0.200
     3.742    15.579     0.200
     3.989    12.729     0.200
     4.046    12.732     0.200
     4.042    12.714     0.200
     4.030    16.499     0.200
     4.073    12.737     0.200
     4.068    12.719     0.200
     4.123    14.072     0.200
     4.402    13.416     0.200
     4.476    14.755     0.200
     4.451    13.276     0.200
     4.451    13.745     0.200
     4.451    13.546     0.200
     4.471    13.803     0.200
     4.488    16.199     0.200
     4.650    14.317     0.200
     4.654    13.811     0.200
     4.684    14.327     0.200
     4.739    15.541     0.200
     4.739    15.892     0.200
     4.807    16.993     0.200
     5.005    15.223     0.200
     5.018    15.128     0.200
     5.284    15.864     0.200
     5.284    16.024     0.200
     5.323    18.952     0.200
     5.269    18.599     0.200
     5.508    16.407     0.200
     5.508    16.524     0.200
     5.668    16.495     0.200
     5.668    17.225     0.200
     5.668    15.299     0.200
     5.670    16.874     0.200
     5.690    16.591     0.200
     5.522    19.349     0.200
     5.540    19.141     0.200
     5.738    16.825     0.200
     5.792    20.430     0.200
     5.976    20.239     0.200
     6.046    17.525     0.200
     6.046    17.728     0.200
     6.085    17.808     0.200
     6.146    17.563     0.200
     6.240    17.768     0.200
     6.296    18.011     0.200
     6.613    18.968     0.200
     6.656    18.809     0.200
     6.689    19.127     0.200
     6.689    18.698     0.200
     6.766    19.226     0.200
     6.766    18.284     0.200
     7.077    19.100     0.200
     7.128    20.409     0.200
     7.061    21.364     0.200
     7.224    21.839     0.200
     7.309    20.041     0.200
     7.560    20.768     0.200
     7.885    21.064     0.200
     8.019    21.540     0.200
     8.046    21.897     0.200
     8.049    23.466     0.200
     8.202    21.922     0.200
     8.421    25.259     0.200
     8.404    24.487     0.200
     8.630    22.967     0.200
     8.691    25.042     0.200
     9.092    26.225     0.200
     9.247    25.401     0.200
     9.244    25.688     0.200
     9.343    26.607     0.200
     9.436    24.196     0.200
     9.450    24.268     0.200
     9.468    27.302     0.200
     9.497    26.959     0.200
     9.484    29.766     0.200
     9.603    26.713     0.200
     9.631    27.105     0.200
     9.860    28.522     0.200
     9.997    28.199     0.200
    10.811    29.826     0.200
    11.713    31.400     0.200
    12.115    32.410     0.200
    12.096    32.327     0.200
    12.815    32.832     0.200
    12.844    33.798     0.200
    13.051    34.279     0.200
    13.070    28.957     0.200
    13.371    34.547     0.200
    13.662    30.349     0.200
    13.698    30.133     0.200
    13.812    35.504     0.200
    13.806    35.765     0.200
    13.951    30.782     0.200
    14.141    33.051     0.200
    14.183    31.276     0.200
    14.225    31.186     0.200
    14.225    35.788     0.200
    14.382    31.457     0.200
    14.471    36.314     0.200
    14.769    32.531     0.200
    14.769    37.133     0.200
    15.066    32.866     0.200
    15.066    37.065     0.200
    15.981    34.590     0.200
    16.240    35.367     0.200
    16.343    35.571     0.200
    16.520    35.897     0.200
    17.347    37.544     0.200
    18.158    38.390     0.200
    18.174    39.060     0.200
    18.851    40.179     0.200
    18.950    40.062     0.200
    19.036    40.071     0.200
    19.300    40.154     0.200
     1.833    10.230     0.200
     1.836    10.196     0.200
     1.871    11.032     0.200
     2.133    11.529     0.200
     2.401    13.172     0.200
     2.402    11.767     0.200
     2.376    11.357     0.200
     2.301    12.420     0.200
     2.141    14.268     0.200
     2.291    12.056     0.200
     2.881    11.539     0.200
     2.892    13.043     0.200
     2.794    13.217     0.200
     3.037    13.023     0.200
     3.156    13.149     0.200
     3.315    13.789     0.200
     3.443    15.002     0.200
     3.511    14.622     0.200
     3.589    13.792     0.200
     3.842    16.668     0.200
     4.152    17.504     0.200
     4.445    17.368     0.200
     4.465    16.125     0.200
     4.537    16.369     0.200
     4.562    17.978     0.200
     4.606    16.317     0.200
     4.534    17.021     0.200
     4.534    17.373     0.200
     4.686    15.942     0.200
     4.692    15.613     0.200
     4.700    15.121     0.200
     4.700    15.957     0.200
     4.720    17.089     0.200
     4.823    17.789     0.200
     5.033    17.036     0.200
     5.039    17.358     0.200
     5.135    16.040     0.200
     5.135    17.236     0.200
     5.135    16.243     0.200
     5.143    16.172     0.200
     5.089    17.984     0.200
     5.105    17.794     0.200
     5.262    17.562     0.200
     5.290    16.771     0.200
     5.290    17.131     0.200
     5.324    19.317     0.200
     5.350    16.834     0.200
     5.286    18.779     0.200
     5.538    18.423     0.200
     5.655    17.873     0.200
     5.708    20.588     0.200
     5.809    19.519     0.200
     5.809    19.269     0.200
     5.847    19.133     0.200
     5.865    19.418     0.200
     5.935    20.131     0.200
     5.935    19.842     0.200
     6.271    19.893     0.200
     6.371    20.235     0.200
     6.517    20.610     0.200
     6.603    21.612     0.200
     6.671    20.724     0.200
     6.680    20.627     0.200
     6.817    20.911     0.200
     6.893    21.025     0.200
     6.901    21.500     0.200
     6.876    21.799     0.200
     7.201    21.625     0.200
     7.201    21.836     0.200
     7.224    21.666     0.200
     7.264    22.503     0.200
     7.325    22.278     0.200
     7.598    21.992     0.200
     7.776    23.074     0.200
     8.059    23.023     0.200
     8.034    24.560     0.200
     8.195    24.403     0.200
     8.326    24.403     0.200
     8.457    24.657     0.200
     8.549    24.700     0.200
     8.704    25.157     0.200
     8.855    25.738     0.200
     9.151    26.108     0.200
     9.305    27.409     0.200
     9.409    27.707     0.200
     9.503    28.127     0.200
     9.583    27.086     0.200
     9.569    28.900     0.200
     9.596    27.091     0.200
     9.544    27.484     0.200
     9.568    27.595     0.200
     9.638    28.494     0.200
     9.692    27.658     0.200
     9.874    28.151     0.200
     9.920    29.105     0.200
     9.965    27.593     0.200
    11.251    31.291     0.200
    11.804    33.314     0.200
    12.154    33.127     0.200
    12.680    34.292     0.200
    12.912    34.581     0.200
    13.208    36.337     0.200
    13.530    35.681     0.200
    13.550    36.040     0.200
    14.847    37.403     0.200
    14.942    38.535     0.200
    17.642    40.939     0.200
    17.634    40.404     0.200
     1.324     8.967     0.200
     2.007     8.288     0.200
     2.188     7.517     0.200
     2.229    10.155     0.200
     2.455     8.870     0.200
     2.963     9.819     0.200
     3.260     9.888     0.200
     3.901    12.525     0.200
     3.945    11.604     0.200
     3.973    13.418     0.200
     3.972    11.594     0.200
     3.979    12.683     0.200
     3.995    15.441     0.200
     4.062    14.642     0.200
     4.306    13.193     0.200
     4.558    12.741     0.200
     4.558    13.850     0.200
     4.586    14.228     0.200
     4.919    13.725     0.200
     4.922    14.411     0.200
     5.194    15.631     0.200
     5.303    17.872     0.200
     1.681    10.173     0.200
     1.757    10.670     0.200
     5.882    18.212     0.200
     5.963    18.367     0.200
     6.019    18.591     0.200
     6.064    18.248     0.200
     6.868    20.205     0.200
     7.086    21.170     0.200
     1.690    10.992     0.200
     2.021    12.644     0.200
     2.139    11.717     0.200
     2.662    14.660     0.200
     3.346    16.499     0.200
     3.321    15.060     0.200
     4.155    17.763     0.200
     4.595    16.857     0.200
     4.638    16.648     0.200
     4.660    15.730     0.200
     4.777    18.750     0.200
     4.950    16.511     0.200
     4.967    17.416     0.200
     4.989    17.053     0.200
     5.212    17.655     0.200
     5.219    17.573     0.200
     5.579    18.565     0.200
     5.635    18.387     0.200
     5.899    18.838     0.200
     6.289    20.083     0.200
     6.366    19.787     0.200
     6.776    20.897     0.200
     1.365     9.209     0.200
     1.611    10.364     0.200
     1.611    10.069     0.200
     1.816    11.156     0.200
     1.904    12.296     0.200
     2.028    11.800     0.200
     2.174    11.144     0.200
     2.189    11.509     0.200
     2.387    12.953     0.200
     2.388    12.370     0.200
     2.372    11.119     0.200
     2.503    11.340     0.200
     2.649    12.277     0.200
     2.538    12.485     0.200
     2.774    13.191     0.200
     3.003    13.923     0.200
     2.944    13.935     0.200
     2.967    13.691     0.200
     2.957    14.305     0.200
     3.044    14.284     0.200
     3.039    11.191     0.200
     3.095    14.403     0.200
     3.347    13.898     0.200
     3.264    12.073     0.200
     3.389    13.759     0.200
     3.436    14.944     0.200
     3.408    13.786     0.200
     3.521    13.565     0.200
     3.651    14.657     0.200
     3.784    14.888     0.200
     3.888    16.010     0.200
     4.163    14.194     0.200
     4.131    15.920     0.200
     4.296    15.562     0.200
     4.258    17.948     0.200
     4.258    17.524     0.200
     4.317    14.731     0.200
     4.413    14.908     0.200
     4.459    14.992     0.200
     4.459    14.742     0.200
     4.446    14.797     0.200
     4.482    15.016     0.200
     4.553    15.015     0.200
     4.553    16.037     0.200
     4.549    18.110     0.200
     4.645    15.957     0.200
     4.767    15.486     0.200
     4.767    15.587     0.200
     4.786    16.156     0.200
     4.806    15.905     0.200
     4.925    16.832     0.200
     5.029    16.724     0.200
     5.038    16.175     0.200
     5.058    16.981     0.200
     5.001    19.749     0.200
     5.001    18.870     0.200
     5.203    17.127     0.200
     5.280    19.738     0.200
     5.399    17.411     0.200
     5.467    17.201     0.200
     5.577    19.423     0.200
     5.726    18.227     0.200
     5.726    17.977     0.200
     5.825    20.924     0.200
     6.032    18.262     0.200
     6.032    18.607     0.200
     6.113    18.773     0.200
     6.197    18.891     0.200
     6.194    19.203     0.200
     6.194    19.065     0.200
     6.427    20.174     0.200
     6.584    19.895     0.200
     6.608    19.691     0.200
     6.669    20.080     0.200
     6.711    20.298     0.200
     6.915    21.225     0.200
     7.092    20.950     0.200
     7.064    25.575     0.200
     7.156    20.999     0.200
     7.156    20.691     0.200
     7.137    21.320     0.200
     7.207    21.306     0.200
     7.207    19.825     0.200
     7.390    21.615     0.200
     7.421    25.513     0.200
     7.539    21.433     0.200
     7.510    23.200     0.200
     7.651    23.370     0.200
     7.794    22.015     0.200
     8.507    25.624     0.200
     8.515    23.845     0.200
     8.513    23.953     0.200
     8.672    23.284     0.200
     8.813    24.367     0.200
     8.845    25.274     0.200
     9.089    24.279     0.200
     9.762    26.299     0.200
     9.762    26.674     0.200
     9.769    27.192     0.200
     9.912    26.580     0.200
     9.930    27.319     0.200
     9.988    29.249     0.200
    10.021    29.564     0.200
    10.060    28.538     0.200
    10.074    28.863     0.200
    10.125    29.003     0.200
    10.244    30.663     0.200
    10.244    29.102     0.200
    10.375    30.534     0.200
    11.191    31.257     0.200
    12.025    34.504     0.200
    12.025    34.228     0.200
    13.008    34.761     0.200
    13.293    31.685     0.200
    13.564    32.417     0.200
    13.852    34.994     0.200
    14.157    32.200     0.200
    14.229    33.754     0.200
    14.327    37.915     0.200
    14.697    39.003     0.200
    14.735    39.051     0.200
    14.988    34.801     0.200
    14.993    34.640     0.200
    15.282    39.667     0.200
    15.492    38.819     0.200
    15.563    40.187     0.200
    16.492    40.747     0.200
    16.800    41.458     0.200
    16.843    41.352     0.200
    17.030    41.070     0.200
    17.286    40.791     0.200
    17.497    40.694     0.200
    17.850    41.352     0.200
    18.084    40.078     0.200
    18.626    43.266     0.200
    20.114    43.926     0.200
    20.373    41.639     0.200
    20.712    41.503     0.200
     2.708    15.051     0.200
     2.816    14.910     0.200
     2.772    15.427     0.200
     3.755    17.886     0.200
     4.445    19.035     0.200
     1.903    11.547     0.200
     2.021    11.257     0.200
     2.021    10.644     0.200
     2.168    12.393     0.200
     2.373    10.505     0.200
     2.382    12.493     0.200
     2.507    10.814     0.200
     2.644    12.771     0.200
     2.777    13.894     0.200
     3.004    13.378     0.200
     2.938    12.674     0.200
     3.034    10.923     0.200
     3.345    13.360     0.200
     3.440    15.382     0.200
     3.384    14.171     0.200
     3.402    13.685     0.200
     3.518    12.887     0.200
     3.648    15.519     0.200
     3.783    13.523     0.200
     3.885    16.872     0.200
     4.161    14.051     0.200
     4.291    14.936     0.200
     4.312    14.841     0.200
     4.405    14.550     0.200
     4.439    14.505     0.200
     4.450    14.360     0.200
     4.450    14.618     0.200
     4.474    14.702     0.200
     4.547    15.634     0.200
     4.547    17.355     0.200
     4.641    15.544     0.200
     4.758    15.172     0.200
     4.758    16.036     0.200
     4.778    16.096     0.200
     4.797    15.260     0.200
     4.797    15.470     0.200
     4.918    16.362     0.200
     5.020    16.268     0.200
     4.999    18.672     0.200
     4.999    19.390     0.200
     5.030    15.564     0.200
     5.030    15.755     0.200
     5.050    16.519     0.200
     5.390    16.552     0.200
     5.460    17.307     0.200
     5.551    17.172     0.200
     5.719    17.726     0.200
     5.824    21.612     0.200
     6.028    18.193     0.200
     6.105    18.509     0.200
     6.190    18.718     0.200
     6.190    18.567     0.200
     6.190    19.032     0.200
     6.419    19.196     0.200
     6.419    19.946     0.200
     6.577    19.534     0.200
     6.601    19.618     0.200
     6.662    20.015     0.200
     6.703    20.133     0.200
     7.084    20.682     0.200
     7.149    21.026     0.200
     7.511    23.136     0.200
     7.532    21.459     0.200
     7.649    22.756     0.200
     7.787    21.808     0.200
     8.025    22.708     0.200
     8.373    23.044     0.200
     8.508    23.768     0.200
     8.507    23.490     0.200
     8.665    23.660     0.200
     8.806    24.193     0.200
     9.082    24.876     0.200
     9.757    25.899     0.200
     9.905    26.091     0.200
     9.924    26.937     0.200
    10.057    28.466     0.200
     2.135    11.349     0.200
     3.365    14.884     0.200
     4.500    14.550     0.200
     4.543    15.243     0.200
     4.857    16.284     0.200
     4.872    15.911     0.200
     5.117    16.643     0.200
     5.484    17.259     0.200
     5.641    17.032     0.200
     5.805    17.921     0.200
     6.194    17.776     0.200
     6.273    18.460     0.200
     1.637    10.633     0.200
     4.464    15.057     0.200
     4.508    15.252     0.200
     4.822    17.386     0.200
     4.836    16.818     0.200
     4.860    16.539     0.200
     5.082    17.547     0.200
     5.088    17.576     0.200
     5.106    17.972     0.200
     5.449    17.868     0.200
     5.606    17.837     0.200
     5.769    18.127     0.200
     6.159    18.983     0.200
     6.238    19.460     0.200
     6.649    20.067     0.200
     2.087    10.997     0.200
     2.479    13.240     0.200
     3.040    11.599     0.200
     3.389    16.568     0.200
     3.441    15.063     0.200
     3.507    13.062     0.200
     4.203    17.748     0.200
     4.468    15.307     0.200
     4.492    14.454     0.200
     4.513    14.981     0.200
     4.534    17.387     0.200
     4.562    15.972     0.200
     4.809    15.457     0.200
     4.809    15.557     0.200
     4.821    16.218     0.200
     4.846    16.318     0.200
     5.068    16.929     0.200
     5.073    15.654     0.200
     5.073    17.274     0.200
     5.434    17.464     0.200
     5.489    17.360     0.200
     5.752    17.949     0.200
     6.032    19.101     0.200
     6.220    19.090     0.200
     6.596    19.742     0.200
     6.630    19.698     0.200
     6.741    20.403     0.200
     1.847    13.399     0.200
     2.151    10.981     0.200
     2.184    14.641     0.200
     3.003    13.266     0.200
     3.003    12.680     0.200
     3.456    14.015     0.200
     3.705    14.582     0.200
     3.822    16.380     0.200
     4.453    16.602     0.200
     4.455    15.330     0.200
     4.492    16.146     0.200
     4.492    14.994     0.200
     4.510    15.772     0.200
     4.482    19.633     0.200
     4.608    17.167     0.200
     4.608    15.901     0.200
     4.822    15.342     0.200
     4.822    17.396     0.200
     4.822    17.391     0.200
     4.856    16.033     0.200
     4.856    16.896     0.200
     4.928    17.136     0.200
     5.077    17.825     0.200
     5.075    16.169     0.200
     5.075    17.946     0.200
     5.436    18.131     0.200
     5.474    18.382     0.200
     5.584    18.399     0.200
     5.742    19.561     0.200
     5.993    19.267     0.200
     6.136    19.557     0.200
     6.150    19.510     0.200
     6.206    19.946     0.200
     6.616    20.663     0.200
     6.738    20.740     0.200
     7.161    22.599     0.200
     7.161    21.021     0.200
     7.789    22.440     0.200
    17.043    40.689     0.200
     2.283    13.827     0.200
     5.204    18.064     0.200
     5.292    18.041     0.200
     5.507    19.728     0.200
     5.596    19.790     0.200
     6.188    20.882     0.200
     6.993    21.889     0.200
     7.166    23.175     0.200
     2.491    15.283     0.200
     2.572    14.552     0.200
     3.036    16.423     0.200
     3.087    15.583     0.200
     3.147    15.858     0.200
     3.293    15.652     0.200
     3.457    15.548     0.200
     3.568    15.357     0.200
     4.057    17.989     0.200
     4.225    16.605     0.200
     4.476    18.711     0.200
     4.472    17.769     0.200
     4.760    18.001     0.200
     4.871    19.211     0.200
     5.028    21.111     0.200
     5.127    21.036     0.200
     5.208    18.035     0.200
     5.297    17.998     0.200
     5.361    18.227     0.200
     5.425    18.571     0.200
     5.439    18.884     0.200
     5.508    18.598     0.200
     5.508    19.028     0.200
     5.600    20.056     0.200
     5.678    19.642     0.200
     5.747    19.941     0.200
     5.846    19.133     0.200
     5.846    19.683     0.200
     5.790    21.737     0.200
     5.829    19.325     0.200
     5.893    21.143     0.200
     6.191    19.958     0.200
     6.438    20.982     0.200
     6.457    20.874     0.200
     6.665    21.234     0.200
     6.999    21.933     0.200
     7.067    24.687     0.200
     7.174    22.388     0.200
     7.203    22.570     0.200
     7.203    22.847     0.200
     7.217    22.800     0.200
     7.394    23.483     0.200
     7.590    23.531     0.200
     8.148    24.327     0.200
     8.513    26.260     0.200
     8.835    26.229     0.200
     8.887    26.356     0.200
     9.031    26.517     0.200
     9.444    28.095     0.200
     9.504    28.195     0.200
     9.580    28.279     0.200
     9.663    28.545     0.200
     2.364    13.184     0.200
     2.364    13.062     0.200
     2.515    13.882     0.200
     2.958    15.064     0.200
     5.378    18.332     0.200
     5.436    18.246     0.200
     5.740    19.408     0.200
     6.009    19.761     0.200
     1.221    10.804     0.200
     1.623    11.032     0.200
     1.959    12.058     0.200
     2.303    12.924     0.200
     2.810    14.388     0.200
     3.121    15.128     0.200
     3.524    14.966     0.200
     3.487    14.560     0.200
     3.469    15.371     0.200
     3.696    15.821     0.200
     4.334    19.043     0.200
     4.568    17.369     0.200
     4.546    17.062     0.200
     4.489    20.181     0.200
     4.603    16.066     0.200
     4.603    17.769     0.200
     4.616    16.166     0.200
     4.598    17.919     0.200
     4.654    17.243     0.200
     4.947    17.432     0.200
     4.947    18.151     0.200
     4.935    17.593     0.200
     5.197    18.334     0.200
     5.550    18.819     0.200
     5.564    18.964     0.200
     5.689    19.195     0.200
     5.838    19.049     0.200
     6.036    21.021     0.200
     6.239    19.775     0.200
     6.704    21.142     0.200
     3.053    14.137     0.200
     4.697    13.886     0.200
     4.754    14.418     0.200
     4.789    15.227     0.200
     4.918    14.785     0.200
     5.066    15.679     0.200
     5.077    16.356     0.200
     5.294    16.818     0.200
     5.685    17.056     0.200
     5.804    16.429     0.200
     6.425    18.117     0.200
     6.945    19.157     0.200
     6.943    18.719     0.200
     1.496    10.854     0.200
     1.496    10.143     0.200
     1.450    10.164     0.200
     1.711    10.252     0.200
     1.566    10.735     0.200
     2.694    14.180     0.200
     2.728    13.806     0.200
     2.939    15.875     0.200
     3.374    14.561     0.200
     3.188    14.899     0.200
     3.399    16.893     0.200
     3.652    14.331     0.200
     3.719    14.553     0.200
     3.719    14.307     0.200
     3.765    15.126     0.200
     3.753    17.629     0.200
     3.813    14.354     0.200
     4.011    16.938     0.200
     4.073    16.893     0.200
     3.939    17.568     0.200
     4.240    17.165     0.200
     4.273    16.749     0.200
     4.400    19.479     0.200
     4.641    16.295     0.200
     4.846    17.202     0.200
     5.405    18.072     0.200
     5.553    18.654     0.200
     5.654    19.048     0.200
     5.777    21.798     0.200
     5.851    20.262     0.200
     5.968    20.003     0.200
     6.048    20.520     0.200
     7.207    22.701     0.200
     7.433    23.158     0.200
     7.952    24.228     0.200
     8.041    24.076     0.200
     1.817     8.029     0.200
     2.011    11.634     0.200
     2.083     8.873     0.200
     2.157    10.364     0.200
     2.188    11.425     0.200
     2.468    11.880     0.200
     2.806    12.517     0.200
     3.040    14.356     0.200
     3.490    13.311     0.200
     3.636    14.267     0.200
     4.677    15.560     0.200
     4.691    15.756     0.200
     4.719    16.018     0.200
     4.769    14.623     0.200
     1.900     8.637     0.200
     2.188    11.796     0.200
     2.365    10.768     0.200
     3.496    11.711     0.200
     3.564    14.512     0.200
     3.668    11.800     0.200
     4.512    15.612     0.200
     4.624    13.302     0.200
     4.659    15.175     0.200
     4.661    14.093     0.200
     4.693    15.407     0.200
     4.693    13.813     0.200
     4.702    15.518     0.200
     4.704    13.765     0.200
     5.026    15.135     0.200
     5.045    15.333     0.200
     5.045    15.513     0.200
     5.075    15.166     0.200
     5.641    16.356     0.200
     6.324    17.490     0.200
     6.373    17.911     0.200
     6.929    19.427     0.200
     2.083    10.066     0.200
     2.999    14.343     0.200
     3.364    13.488     0.200
     3.540    14.085     0.200
     4.178    15.411     0.200
     4.478    15.985     0.200
     4.501    14.895     0.200
     4.522    15.772     0.200
     4.544    15.094     0.200
     4.597    16.336     0.200
     4.681    15.646     0.200
     4.835    15.450     0.200
     4.835    16.122     0.200
     4.873    16.374     0.200
     5.096    17.076     0.200
     5.463    17.493     0.200
     6.173    18.600     0.200
     6.253    19.073     0.200
     6.664    19.881     0.200
     7.845    21.642     0.200
     2.878    11.463     0.200
     2.910    12.066     0.200
     2.958    12.716     0.200
     3.338    13.259     0.200
     3.567    12.952     0.200
     3.780    14.155     0.200
     4.115    13.459     0.200
     4.400    14.168     0.200
     1.552     9.877     0.200
     1.996     9.857     0.200
     2.664    12.693     0.200
     3.032    14.071     0.200
     3.725    13.092     0.200
     3.737    15.146     0.200
     3.849    14.412     0.200
     4.155    17.694     0.200
     1.643    10.699     0.200
     1.638    10.653     0.200
     2.042    11.642     0.200
     1.948    11.934     0.200
     2.498    11.870     0.200
     2.554    11.499     0.200
     2.685    13.582     0.200
     2.803    13.397     0.200
     2.902    14.436     0.200
     3.173    14.221     0.200
     3.533    16.705     0.200
     3.898    16.572     0.200
     3.977    16.109     0.200
     3.933    17.317     0.200
     4.159    15.976     0.200
     4.213    18.258     0.200
     4.389    16.024     0.200
     4.431    16.210     0.200
     4.452    15.955     0.200
     4.773    16.915     0.200
     4.689    19.033     0.200
     4.945    17.408     0.200
     4.963    16.408     0.200
     4.963    16.697     0.200
     5.134    17.402     0.200
     5.242    19.669     0.200
     5.383    18.294     0.200
     5.409    18.889     0.200
     5.861    19.822     0.200
     1.825    13.139     0.200
     2.081    11.395     0.200
     2.081    11.552     0.200
     2.173    12.624     0.200
     2.129    10.969     0.200
     2.328    12.800     0.200
     2.385    12.012     0.200
     2.453    12.269     0.200
     2.488    14.131     0.200
     2.793    13.895     0.200
     3.038    14.249     0.200
     3.247    15.021     0.200
     3.392    13.641     0.200
     3.410    14.573     0.200
     3.454    16.284     0.200
     3.496    14.295     0.200
     3.632    15.766     0.200
     3.753    16.465     0.200
     3.862    16.925     0.200
     4.433    15.260     0.200
     4.453    15.433     0.200
     4.476    15.363     0.200
     4.497    15.789     0.200
     4.523    18.958     0.200
     4.548    16.705     0.200
     4.632    16.626     0.200
     4.793    16.730     0.200
     4.793    16.862     0.200
     4.805    16.727     0.200
     4.831    16.375     0.200
     4.831    17.226     0.200
     4.934    17.320     0.200
     4.972    20.432     0.200
     5.052    18.037     0.200
     5.074    17.390     0.200
     5.418    18.473     0.200
     5.573    18.459     0.200
     5.573    17.929     0.200
     5.792    22.178     0.200
     6.018    19.212     0.200
     6.178    19.889     0.200
     6.204    19.796     0.200
     6.447    21.367     0.200
     6.581    20.380     0.200
     6.615    20.604     0.200
     6.725    21.113     0.200
     7.103    21.804     0.200
     7.162    21.324     0.200
     7.545    22.344     0.200
     7.627    23.572     0.200
     7.795    22.669     0.200
     7.795    22.828     0.200
     8.147    23.925     0.200
     8.378    24.325     0.200
     8.512    24.422     0.200
     8.520    24.473     0.200
     8.677    24.780     0.200
     8.818    25.387     0.200
     1.473     9.915     0.200
     2.692    12.197     0.200
     2.969    13.659     0.200
     3.059    14.200     0.200
     3.552    14.842     0.200
     3.597    16.338     0.200
     3.721    17.198     0.200
     3.796    14.854     0.200
     3.845    15.266     0.200
     3.816    17.699     0.200
     3.936    13.709     0.200
     4.089    16.321     0.200
     1.497     9.127     0.200
     1.555     9.367     0.200
     1.858     9.948     0.200
     2.028    10.959     0.200
     2.675    11.665     0.200
     2.968    13.351     0.200
     2.971    12.878     0.200
     3.043    12.902     0.200
     3.354    14.992     0.200
     3.707    15.550     0.200
     3.713    13.581     0.200
     3.831    12.885     0.200
     1.812    13.295     0.200
     2.109    13.484     0.200
     2.107    11.222     0.200
     2.161    14.729     0.200
     2.404    12.277     0.200
     2.785    12.907     0.200
     3.041    13.374     0.200
     3.405    12.198     0.200
     3.445    15.512     0.200
     3.500    14.186     0.200
     3.752    17.362     0.200
     3.866    16.942     0.200
     4.461    15.921     0.200
     4.503    14.731     0.200
     4.523    15.625     0.200
     4.564    16.298     0.200
     4.645    17.219     0.200
     4.823    16.698     0.200
     4.832    16.493     0.200
     4.860    16.167     0.200
     5.081    16.981     0.200
     5.445    17.438     0.200
     5.599    17.545     0.200
     6.151    18.697     0.200
     6.227    19.617     0.200
     2.733    14.272     0.200
     3.342    13.093     0.200
     3.391    15.127     0.200
     4.473    15.877     0.200
     4.518    15.653     0.200
     4.541    15.556     0.200
     4.603    16.178     0.200
     4.866    16.191     0.200
     5.089    17.489     0.200
     5.458    17.680     0.200
     6.254    18.897     0.200
     1.906    10.299     0.200
     2.151    12.411     0.200
     2.588    12.671     0.200
     2.902    14.189     0.200
     2.902    14.984     0.200
     3.386    12.791     0.200
     3.478    13.071     0.200
     3.604    14.959     0.200
     3.827    15.285     0.200
     3.846    15.955     0.200
     4.459    17.474     0.200
     4.793    17.478     0.200
     4.824    17.593     0.200
     4.898    16.393     0.200
     4.958    16.969     0.200
     5.037    15.916     0.200
     5.040    16.041     0.200
     5.050    15.964     0.200
     5.050    15.763     0.200
     5.388    17.418     0.200
     5.464    17.546     0.200
     5.464    17.726     0.200
     5.479    17.233     0.200
     5.479    17.753     0.200
     5.591    19.016     0.200
     5.616    17.750     0.200
     5.639    17.202     0.200
     5.689    17.507     0.200
     6.004    17.927     0.200
     6.097    18.345     0.200
     6.150    19.555     0.200
     6.208    19.049     0.200
     6.633    19.988     0.200
     6.636    19.852     0.200
     7.033    21.016     0.200
     7.251    21.178     0.200
     7.564    22.623     0.200
     7.961    23.390     0.200
     2.730    13.682     0.200
     3.319    13.924     0.200
     5.427    16.934     0.200
     5.525    17.280     0.200
     5.600    17.601     0.200
     5.705    17.451     0.200
     5.821    18.126     0.200
     5.944    18.494     0.200
     5.976    18.844     0.200
     6.143    18.951     0.200
     6.405    19.021     0.200
     6.580    22.517     0.200
     6.672    20.104     0.200
     7.233    20.753     0.200
     7.431    21.741     0.200
     7.848    22.578     0.200
     3.811    12.042     0.200
     3.847    12.302     0.200
     3.860    13.092     0.200
     4.069    13.596     0.200
     4.133    13.703     0.200
     4.133    13.278     0.200
     4.239    14.215     0.200
     4.358    14.752     0.200
     4.385    13.203     0.200
     4.742    14.170     0.200
     4.927    14.517     0.200
     5.117    15.400     0.200
     5.484    15.510     0.200
     5.607    16.384     0.200
     2.051    11.355     0.200
     3.561    13.864     0.200
     4.471    14.981     0.200
     4.517    14.953     0.200
     4.503    14.597     0.200
     4.540    15.282     0.200
     4.606    16.260     0.200
     4.694    16.464     0.200
     4.824    15.874     0.200
     4.824    16.073     0.200
     4.864    16.606     0.200
     5.087    17.404     0.200
     5.096    16.048     0.200
     5.096    17.388     0.200
     5.457    18.085     0.200
     5.617    17.811     0.200
     5.784    17.966     0.200
     6.171    18.647     0.200
     6.254    19.076     0.200
     6.638    19.622     0.200
     2.302    12.202     0.200
     2.854    14.476     0.200
     3.409    14.629     0.200
     3.775    13.179     0.200
     3.853    13.994     0.200
     4.046    14.399     0.200
     4.310    15.136     0.200
     4.413    16.710     0.200
     4.735    15.639     0.200
     4.800    15.676     0.200
     4.797    15.651     0.200
     4.843    16.138     0.200
     4.859    15.866     0.200
     5.028    16.179     0.200
     5.088    16.074     0.200
     5.118    16.465     0.200
     5.075    18.369     0.200
     5.146    16.734     0.200
     5.319    16.826     0.200
     5.328    17.115     0.200
     5.369    16.761     0.200
     5.414    17.011     0.200
     5.528    20.463     0.200
     5.723    17.603     0.200
     5.803    18.527     0.200
     5.923    18.369     0.200
     5.923    18.002     0.200
     6.118    18.599     0.200
     6.118    18.498     0.200
     6.350    21.153     0.200
     6.482    19.254     0.200
     6.534    19.205     0.200
     6.534    19.760     0.200
     6.607    19.891     0.200
     6.703    19.747     0.200
     6.748    19.736     0.200
     6.748    20.748     0.200
     7.021    20.660     0.200
     7.043    20.419     0.200
     7.067    20.818     0.200
     7.471    21.300     0.200
     7.574    21.909     0.200
     7.640    21.761     0.200
     7.949    22.826     0.200
     8.175    23.369     0.200
     8.234    23.314     0.200
     8.453    23.743     0.200
     8.516    23.516     0.200
     8.563    23.964     0.200
     8.830    24.045     0.200
     8.933    24.650     0.200
     8.965    23.873     0.200
     9.091    24.673     0.200
     9.227    25.214     0.200
     9.495    25.808     0.200
    10.001    26.648     0.200
    10.246    27.395     0.200
    10.276    27.623     0.200
    10.320    27.201     0.200
    10.379    28.032     0.200
     2.231    12.673     0.200
     2.305    13.353     0.200
     2.567    14.670     0.200
     3.020    14.004     0.200
     3.413    15.415     0.200
     3.131    15.877     0.200
     3.252    15.984     0.200
     3.130    15.819     0.200
     3.218    14.769     0.200
     3.467    15.428     0.200
     3.468    16.267     0.200
     3.611    16.356     0.200
     4.014    17.621     0.200
     4.190    15.412     0.200
     4.430    16.475     0.200
     4.737    17.215     0.200
     4.842    18.428     0.200
     5.147    17.906     0.200
     5.012    19.404     0.200
     5.105    20.249     0.200
     5.238    18.047     0.200
     5.238    17.820     0.200
     5.304    18.298     0.200
     5.361    17.793     0.200
     5.361    18.113     0.200
     5.361    17.988     0.200
     5.387    18.131     0.200
     5.414    18.526     0.200
     5.540    19.119     0.200
     5.684    19.339     0.200
     5.636    18.629     0.200
     5.839    19.232     0.200
     5.864    19.736     0.200
     5.793    19.391     0.200
     5.768    20.868     0.200
     6.256    20.665     0.200
     6.226    22.058     0.200
     6.226    22.504     0.200
     6.380    20.720     0.200
     6.609    20.847     0.200
     6.505    23.120     0.200
     6.941    21.670     0.200
     7.141    22.512     0.200
     7.120    22.177     0.200
     7.052    24.232     0.200
     7.181    21.591     0.200
     7.360    22.136     0.200
     7.360    22.245     0.200
     7.507    23.560     0.200
     7.537    23.022     0.200
     7.625    23.140     0.200
     7.941    24.103     0.200
     8.095    24.709     0.200
     8.101    24.532     0.200
     8.459    25.759     0.200
     8.784    25.548     0.200
     8.784    25.861     0.200
     8.861    25.860     0.200
     8.978    25.794     0.200
     9.086    26.241     0.200
     9.396    27.025     0.200
     9.451    26.882     0.200
     9.531    27.226     0.200
     9.728    27.219     0.200
     9.610    26.902     0.200
    10.529    29.484     0.200
    10.859    30.367     0.200
    10.940    29.882     0.200
    10.926    30.667     0.200
    12.878    36.655     0.200
    17.916    42.384     0.200
    20.346    43.668     0.200
     2.815    12.542     0.200
     3.884    14.979     0.200
     3.752    15.621     0.200
     3.960    14.999     0.200
     4.014    13.935     0.200
     4.080    14.507     0.200
     3.847    17.142     0.200
     4.352    14.980     0.200
     4.534    15.097     0.200
     4.551    15.867     0.200
     4.872    16.551     0.200
     2.848    14.691     0.200
     2.870    13.469     0.200
     2.975    14.830     0.200
     3.008    12.828     0.200
     3.357    14.574     0.200
     3.919    14.434     0.200
     3.829    17.471     0.200
     3.976    13.642     0.200
     4.337    15.365     0.200
     4.502    16.922     0.200
     4.546    16.231     0.200
     5.068    16.447     0.200
     1.932    12.292     0.200
     2.678    14.238     0.200
     2.680    13.146     0.200
     2.721    13.573     0.200
     2.821    12.095     0.200
     2.893    14.346     0.200
     3.100    14.746     0.200
     3.156    14.332     0.200
     3.687    17.856     0.200
     3.769    17.178     0.200
     4.207    17.731     0.200
     4.312    17.495     0.200
     4.639    16.745     0.200
     4.753    17.496     0.200
     4.794    17.609     0.200
     4.794    16.398     0.200
     4.815    17.567     0.200
     5.018    17.190     0.200
     5.137    18.010     0.200
     5.747    18.987     0.200
     6.215    20.631     0.200
     6.291    20.235     0.200
     2.003    11.856     0.200
     2.724    12.840     0.200
     2.855    12.617     0.200
     2.855    14.250     0.200
     2.886    12.870     0.200
     2.592    10.749     0.200
     3.232    14.352     0.200
     3.394    14.911     0.200
     4.886    15.237     0.200
     4.963    15.541     0.200
     4.963    16.181     0.200
     5.214    16.011     0.200
     5.526    17.074     0.200
     5.523    17.405     0.200
     5.873    17.919     0.200
     1.326     9.922     0.200
     1.353    10.748     0.200
     2.822    15.566     0.200
     3.954    14.272     0.200
     4.165    16.221     0.200
     4.297    15.646     0.200
     4.474    17.215     0.200
     4.501    16.242     0.200
     5.039    17.332     0.200
     1.420     8.349     0.200
     1.420     8.132     0.200
     2.748    11.481     0.200
     2.999    13.015     0.200
     3.817    13.735     0.200
     3.967    13.095     0.200
     3.900    17.016     0.200
     4.017    12.131     0.200
     4.072    12.229     0.200
     4.281    14.574     0.200
     4.143    14.598     0.200
     4.328    14.276     0.200
     4.473    14.826     0.200
     4.530    14.191     0.200
     4.530    14.961     0.200
     4.529    14.178     0.200
     4.519    15.066     0.200
     4.613    17.775     0.200
     5.091    14.816     0.200
     5.810    16.725     0.200
     6.307    17.192     0.200
     0.449     6.177     0.200
     0.955     7.345     0.200
     1.099     7.423     0.200
     1.079     6.780     0.200
     1.254     7.971     0.200
     1.386     8.497     0.200
     2.163     9.441     0.200
     2.555    11.344     0.200
     2.654    10.193     0.200
     2.543    11.201     0.200
     2.658    11.040     0.200
     3.476     9.734     0.200
     4.104    12.397     0.200
     4.195    12.432     0.200
     4.195    12.245     0.200
     4.407    12.980     0.200
     4.407    13.355     0.200
     4.497    14.118     0.200
     4.742    13.327     0.200
     5.087    14.127     0.200
     5.576    15.722     0.200
     6.094    16.478     0.200
     1.880    11.316     0.200
     1.880    11.035     0.200
     2.106    11.948     0.200
     2.443    12.653     0.200
     3.000    15.134     0.200
     3.017    14.880     0.200
     3.420    15.954     0.200
     3.420    15.128     0.200
     3.223    15.468     0.200
     3.641    13.619     0.200
     5.194    17.003     0.200
     5.275    17.159     0.200
     5.436    18.079     0.200
     5.436    17.048     0.200
     5.512    17.723     0.200
     5.584    18.055     0.200
     5.749    18.532     0.200
     5.846    18.493     0.200
     5.897    18.999     0.200
     6.180    18.892     0.200
     6.626    20.296     0.200
     6.875    21.886     0.200
     6.971    20.763     0.200
     7.127    21.542     0.200
     7.197    21.626     0.200
     7.543    22.193     0.200
     7.546    22.557     0.200
     8.099    23.607     0.200
     8.468    24.291     0.200
     8.774    25.322     0.200
     8.981    25.311     0.200
     9.089    25.543     0.200
     1.620     9.663     0.200
     1.749    11.605     0.200
     1.939    11.023     0.200
     2.063    11.086     0.200
     2.296    12.300     0.200
     2.447    10.962     0.200
     2.602    12.553     0.200
     2.842    13.496     0.200
     2.951    14.051     0.200
     3.002    13.750     0.200
     3.026    15.002     0.200
     3.167    14.021     0.200
     3.300    14.001     0.200
     3.252    12.261     0.200
     3.376    13.661     0.200
     3.541    13.093     0.200
     3.715    12.704     0.200
     3.722    14.955     0.200
     3.887    13.269     0.200
     4.135    14.125     0.200
     4.721    16.155     0.200
     4.890    15.695     0.200
     4.974    15.820     0.200
     4.974    15.328     0.200
     5.034    15.783     0.200
     5.102    15.705     0.200
     5.127    16.726     0.200
     5.127    16.523     0.200
     5.204    16.297     0.200
     5.204    16.532     0.200
     5.281    16.738     0.200
     5.336    16.453     0.200
     5.441    17.266     0.200
     5.470    18.155     0.200
     5.491    16.847     0.200
     5.528    16.921     0.200
     5.558    17.103     0.200
     5.598    17.735     0.200
     5.876    17.592     0.200
     6.112    18.539     0.200
     6.121    18.335     0.200
     6.333    18.557     0.200
     6.333    19.127     0.200
     6.673    19.494     0.200
     6.839    20.055     0.200
     7.057    19.648     0.200
     7.245    21.117     0.200
     7.255    20.794     0.200
     7.812    22.203     0.200
     8.179    22.315     0.200
     8.496    23.725     0.200
     8.695    23.796     0.200
     8.803    24.033     0.200
     9.104    24.820     0.200
     9.239    25.335     0.200
     1.678     9.088     0.200
     2.221     9.794     0.200
     2.442     9.779     0.200
     3.428    11.795     0.200
     3.468    11.909     0.200
     3.468    11.737     0.200
     3.797    13.093     0.200
     3.939    13.835     0.200
     4.050    12.882     0.200
     1.507     9.447     0.200
     2.205    12.584     0.200
     2.983    14.449     0.200
     3.257    14.098     0.200
     5.260    17.944     0.200
     5.350    17.447     0.200
     5.350    17.988     0.200
     5.417    16.896     0.200
     5.498    17.902     0.200
     5.653    19.960     0.200
     5.742    18.666     0.200
     5.899    19.792     0.200
     5.894    18.930     0.200
     5.951    19.881     0.200
     6.243    19.976     0.200
     6.516    20.080     0.200
     6.722    20.288     0.200
     7.232    22.228     0.200
     1.163    11.156     0.200
     1.163    10.343     0.200
     1.146     9.911     0.200
     1.239     9.376     0.200
     1.364     9.353     0.200
     1.412     9.407     0.200
     1.686    10.986     0.200
     1.731     8.795     0.200
     1.939     9.783     0.200
     2.329    10.872     0.200
     2.760    11.538     0.200
     2.906    12.761     0.200
     3.024    13.921     0.200
     3.127    12.980     0.200
     3.787    16.905     0.200
     3.889    14.141     0.200
     3.885    14.555     0.200
     3.928    15.750     0.200
     4.016    13.288     0.200
     4.016    12.895     0.200
     4.026    12.969     0.200
     4.026    13.172     0.200
     4.052    14.341     0.200
     4.365    14.619     0.200
     4.382    14.920     0.200
     4.462    15.086     0.200
     4.616    14.248     0.200
     4.616    15.092     0.200
     4.874    14.354     0.200
     4.898    15.357     0.200
     4.981    16.031     0.200
     5.075    16.240     0.200
     5.066    18.876     0.200
     5.194    16.844     0.200
     5.309    17.118     0.200
     5.616    17.517     0.200
     5.631    17.540     0.200
     6.036    18.323     0.200
     6.229    18.964     0.200
     1.767    11.656     0.200
     2.197    12.330     0.200
     2.197    13.010     0.200
     2.978    14.754     0.200
     3.262    15.527     0.200
     3.412    14.464     0.200
     3.662    16.483     0.200
     3.725    17.804     0.200
     5.333    18.438     0.200
     5.333    18.860     0.200
     5.400    17.744     0.200
     5.483    18.070     0.200
     5.538    19.248     0.200
     5.635    20.215     0.200
     5.729    18.600     0.200
     5.881    18.699     0.200
     5.881    19.547     0.200
     5.884    20.050     0.200
     5.935    20.014     0.200
     6.225    20.135     0.200
     6.501    21.468     0.200
     1.636    11.446     0.200
     1.758    12.643     0.200
     2.082    13.135     0.200
     2.516    13.160     0.200
     2.703    15.854     0.200
     2.703    14.604     0.200
     2.774    15.521     0.200
     3.084    16.615     0.200
     2.872    15.884     0.200
     2.872    14.156     0.200
     3.258    17.394     0.200
     3.258    17.068     0.200
     3.339    16.504     0.200
     3.366    16.119     0.200
     3.366    15.582     0.200
     3.555    17.070     0.200
     3.757    17.567     0.200
     3.757    17.739     0.200
     3.800    16.883     0.200
     3.868    16.181     0.200
     4.097    18.050     0.200
     4.113    18.469     0.200
     4.288    16.207     0.200
     4.545    18.168     0.200
     4.853    18.104     0.200
     4.949    19.196     0.200
     5.175    18.238     0.200
     5.137    19.900     0.200
     5.272    18.314     0.200
     5.344    18.725     0.200
     5.369    18.178     0.200
     5.369    19.124     0.200
     5.445    17.511     0.200
     5.459    18.458     0.200
     5.570    19.136     0.200
     5.699    19.222     0.200
     5.717    19.335     0.200
     5.814    19.285     0.200
     5.814    19.486     0.200
     5.891    19.583     0.200
     5.900    19.678     0.200
     5.888    19.478     0.200
     5.885    21.989     0.200
     6.155    20.005     0.200
     6.109    22.033     0.200
     6.417    20.990     0.200
     6.460    20.836     0.200
     6.463    21.666     0.200
     6.655    21.169     0.200
     6.655    22.614     0.200
     6.852    22.270     0.200
     6.931    22.652     0.200
     6.978    21.901     0.200
     7.162    22.858     0.200
     7.172    22.337     0.200
     7.178    25.513     0.200
     7.275    22.015     0.200
     7.458    22.394     0.200
     7.539    23.554     0.200
     7.589    23.276     0.200
     8.147    24.455     0.200
     8.204    24.588     0.200
     8.845    26.308     0.200
     8.973    26.291     0.200
     9.032    26.536     0.200
     9.139    26.385     0.200
     9.461    27.427     0.200
     9.596    27.266     0.200
    10.939    31.291     0.200
    11.003    31.443     0.200
    11.021    30.847     0.200
     1.525     9.701     0.200
     2.069    11.468     0.200
     2.069    12.788     0.200
     2.015    11.510     0.200
     3.418    13.734     0.200
     3.827    16.062     0.200
     3.763    16.253     0.200
     4.480    15.004     0.200
     5.017    14.852     0.200
     5.508    17.388     0.200
     5.579    17.311     0.200
     5.609    17.612     0.200
     5.672    17.168     0.200
     5.699    17.610     0.200
     5.699    17.860     0.200
     5.807    17.898     0.200
     5.939    18.555     0.200
     5.927    18.082     0.200
     6.052    18.489     0.200
     6.052    18.841     0.200
     6.084    18.421     0.200
     6.121    18.533     0.200
     6.394    19.055     0.200
     6.688    19.713     0.200
     7.214    21.578     0.200
     7.402    21.482     0.200
     7.819    22.621     0.200
     1.861    10.064     0.200
     2.013    12.415     0.200
     2.299    12.638     0.200
     2.423    11.330     0.200
     2.423    11.580     0.200
     4.405    16.362     0.200
     4.497    16.664     0.200
     4.878    16.235     0.200
     4.941    16.475     0.200
     4.941    16.339     0.200
     5.018    16.314     0.200
     5.101    17.136     0.200
     5.101    16.765     0.200
     5.269    17.898     0.200
     5.339    17.864     0.200
     5.430    17.473     0.200
     5.435    17.612     0.200
     5.435    18.104     0.200
     5.471    17.616     0.200
     5.471    17.448     0.200
     5.777    18.149     0.200
     6.753    20.459     0.200
     7.169    21.601     0.200
     7.256    21.314     0.200
     2.101    11.293     0.200
     2.101    10.489     0.200
     2.112    11.753     0.200
     2.174    13.396     0.200
     2.438    11.038     0.200
     2.793    14.564     0.200
     3.046    14.423     0.200
     3.405    13.983     0.200
     3.378    13.657     0.200
     4.489    15.917     0.200
     4.489    15.023     0.200
     4.809    16.386     0.200
     4.818    17.578     0.200
     4.846    16.755     0.200
     4.944    17.009     0.200
     5.067    17.470     0.200
     5.070    17.733     0.200
     5.070    17.085     0.200
     5.431    18.222     0.200
     5.585    18.328     0.200
     5.747    18.840     0.200
     5.747    17.959     0.200
     6.138    19.077     0.200
     6.214    19.693     0.200
     1.993    11.940     0.200
     2.443    12.152     0.200
     2.443    12.719     0.200
     2.475    13.323     0.200
     2.875    12.870     0.200
     2.919    14.361     0.200
     5.383    17.912     0.200
     5.383    16.814     0.200
     5.383    18.627     0.200
     5.865    17.794     0.200
     5.929    19.649     0.200
     5.959    18.593     0.200
     6.317    19.818     0.200
     6.665    20.856     0.200
     7.047    21.293     0.200
     1.503    11.135     0.200
     1.445    10.382     0.200
     1.445    11.897     0.200
     1.408     9.962     0.200
     1.408    10.329     0.200
     1.693    11.434     0.200
     1.619    11.477     0.200
     1.619    11.860     0.200
     1.758    12.612     0.200
     1.758    13.245     0.200
     1.982    12.412     0.200
     1.917    11.897     0.200
     1.917    12.401     0.200
     1.998    13.554     0.200
     2.056    12.209     0.200
     2.696    12.578     0.200
     2.902    15.082     0.200
     2.902    15.941     0.200
     2.973    15.398     0.200
     3.461    16.582     0.200
     3.395    15.575     0.200
     3.536    15.468     0.200
     3.544    15.435     0.200
     3.544    16.403     0.200
     3.901    17.183     0.200
     3.942    17.033     0.200
     3.948    17.124     0.200
     3.948    17.702     0.200
     4.489    15.538     0.200
     4.489    15.304     0.200
     5.057    17.970     0.200
     5.057    17.446     0.200
     5.153    18.658     0.200
     5.153    18.447     0.200
     5.330    17.887     0.200
     5.341    18.137     0.200
     5.341    18.915     0.200
     5.432    18.299     0.200
     5.432    17.835     0.200
     5.432    18.194     0.200
     5.425    19.646     0.200
     5.427    19.671     0.200
     5.505    18.245     0.200
     5.509    18.307     0.200
     5.509    18.662     0.200
     5.601    18.532     0.200
     5.623    18.445     0.200
     5.726    19.073     0.200
     5.842    19.410     0.200
     5.910    19.036     0.200
     5.910    19.392     0.200
     5.968    19.439     0.200
     5.968    19.311     0.200
     6.066    19.699     0.200
     6.066    19.512     0.200
     6.088    19.354     0.200
     6.088    19.143     0.200
     6.089    22.304     0.200
     6.307    19.993     0.200
     6.307    19.798     0.200
     6.579    20.412     0.200
     6.636    20.611     0.200
     6.636    20.728     0.200
     6.825    21.247     0.200
     6.825    21.028     0.200
     6.869    21.478     0.200
     7.140    21.664     0.200
     7.308    22.801     0.200
     7.346    22.367     0.200
     7.382    24.589     0.200
     7.474    21.860     0.200
     7.696    23.778     0.200
     7.762    23.304     0.200
     7.884    23.440     0.200
     8.322    23.476     0.200
     9.026    25.857     0.200
     9.178    26.604     0.200
     9.313    26.408     0.200
     9.644    27.346     0.200
     9.780    27.382     0.200
     9.834    27.238     0.200
     9.960    28.157     0.200
    11.220    30.507     0.200
     2.570    12.622     0.200
     2.651    12.703     0.200
     3.197    13.944     0.200
     3.477    13.058     0.200
     4.365    13.596     0.200
     4.529    14.729     0.200
     4.918    15.672     0.200
     4.918    15.406     0.200
     4.951    15.521     0.200
     5.175    15.169     0.200
     5.528    16.539     0.200
     5.528    16.312     0.200
     6.012    16.828     0.200
     6.543    18.187     0.200
     0.852     7.116     0.200
     1.036     8.316     0.200
     1.088     7.245     0.200
     1.220     8.723     0.200
     1.352     9.358     0.200
     2.454    11.430     0.200
     2.566    11.290     0.200
     3.126    11.719     0.200
     4.198    13.577     0.200
     4.292    14.087     0.200
     4.415    12.845     0.200
     4.496    13.098     0.200
     4.592    13.986     0.200
     4.735    13.815     0.200
     4.791    14.185     0.200
     4.837    14.523     0.200
     4.915    14.515     0.200
     5.180    14.814     0.200
     5.180    14.657     0.200
     5.436    15.232     0.200
     5.485    15.355     0.200
     1.695     9.819     0.200
     2.007    10.489     0.200
     2.262    12.545     0.200
     2.493    11.449     0.200
     2.435    13.140     0.200
     4.414    16.002     0.200
     4.485    15.001     0.200
     4.904    16.725     0.200
     5.036    17.306     0.200
     5.036    16.572     0.200
     5.303    16.510     0.200
     5.606    17.302     0.200
     1.606     6.395     0.200
     1.985     7.790     0.200
     1.906     8.109     0.200
     2.080     9.694     0.200
     2.857    11.614     0.200
     3.071    10.705     0.200
     2.953    10.309     0.200
     3.378    10.630     0.200
     3.378     9.693     0.200
     3.371    10.972     0.200
     4.378    13.469     0.200
     4.648    14.684     0.200
     4.648    14.434     0.200
     4.647    14.358     0.200
     4.682    14.373     0.200
     4.682    13.404     0.200
     4.789    14.775     0.200
     4.804    13.573     0.200
     4.807    13.663     0.200
     4.807    13.335     0.200
     5.144    15.130     0.200
     5.175    14.874     0.200
     5.175    14.710     0.200
     5.206    15.110     0.200
     5.224    15.491     0.200
     5.396    15.487     0.200
     5.396    14.792     0.200
     5.689    16.043     0.200
     5.760    16.041     0.200
     5.988    16.390     0.200
     6.408    17.280     0.200
     6.423    17.913     0.200
     6.699    18.008     0.200
     6.826    18.803     0.200
     7.020    19.638     0.200
     1.818    13.234     0.200
     4.173    18.174     0.200
     5.579    19.854     0.200
     5.977    20.517     0.200
     6.039    19.688     0.200
     6.398    21.893     0.200
     1.113     6.985     0.200
     1.221     7.957     0.200
     1.342     9.588     0.200
     1.735     9.897     0.200
     1.938     8.982     0.200
     2.214    10.412     0.200
     2.085    10.860     0.200
     2.702    12.010     0.200
     2.705    11.186     0.200
     2.908    10.463     0.200
     2.908    10.260     0.200
     2.971    10.444     0.200
     2.974    11.691     0.200
     2.956    13.190     0.200
     3.112     9.524     0.200
     3.104    12.895     0.200
     3.197    12.340     0.200
     3.552    11.892     0.200
     3.598    13.573     0.200
     3.900    12.503     0.200
     3.969    12.797     0.200
     3.969    13.274     0.200
     3.969    12.531     0.200
     4.018    13.070     0.200
     4.252    13.198     0.200
     4.252    13.030     0.200
     4.285    13.512     0.200
     4.311    13.469     0.200
     4.483    13.608     0.200
     4.535    14.095     0.200
     4.535    13.638     0.200
     4.524    13.425     0.200
     4.524    13.117     0.200
     4.497    13.410     0.200
     4.497    13.277     0.200
     4.582    15.404     0.200
     4.889    14.968     0.200
     5.085    14.271     0.200
     5.305    15.513     0.200
     5.305    14.915     0.200
     5.658    16.796     0.200
     5.880    15.537     0.200
     1.596    10.384     0.200
     1.899    11.616     0.200
     1.973    11.453     0.200
     1.975    11.559     0.200
     2.679    13.902     0.200
     2.679    14.244     0.200
     2.852    14.334     0.200
     3.066    12.015     0.200
     3.371    12.730     0.200
     3.854    16.338     0.200
     4.642    17.230     0.200
     4.644    17.582     0.200
     4.644    17.480     0.200
     4.680    16.657     0.200
     4.790    15.934     0.200
     4.804    16.219     0.200
     4.808    15.925     0.200
     4.808    15.667     0.200
     5.145    17.293     0.200
     5.173    17.458     0.200
     5.208    17.251     0.200
     5.226    18.444     0.200
     5.397    17.754     0.200
     5.397    16.983     0.200
     5.438    18.575     0.200
     5.549    18.571     0.200
     5.687    18.081     0.200
     5.687    17.497     0.200
     5.761    18.502     0.200
     5.865    18.687     0.200
     5.865    18.025     0.200
     5.986    19.072     0.200
     6.407    19.658     0.200
     6.421    19.801     0.200
     6.824    20.699     0.200
     7.019    21.415     0.200
     3.000    12.912     0.200
     3.905    14.192     0.200
     3.981    14.502     0.200
     4.542    15.263     0.200
     4.558    14.574     0.200
     4.893    16.266     0.200
     1.492     8.780     0.200
     1.560     7.791     0.200
     4.784    18.219     0.200
     6.204    18.057     0.200
     6.467    17.482     0.200
     6.697    19.504     0.200
     6.928    19.410     0.200
     8.191    22.258     0.200
     1.598     9.120     0.200
     4.216    13.788     0.200
     4.748    15.578     0.200
     4.877    15.572     0.200
     5.085    15.645     0.200
     6.153    17.587     0.200
     1.321     8.388     0.200
     2.446    10.949     0.200
     2.611    11.440     0.200
     3.330    10.906     0.200
     4.232    14.212     0.200
     4.314    14.588     0.200
     4.403    14.516     0.200
     4.524    15.104     0.200
     4.644    15.407     0.200
     4.766    15.875     0.200
     4.821    15.727     0.200
     4.887    16.166     0.200
     5.104    15.829     0.200
     5.461    16.876     0.200
     5.941    18.264     0.200
     1.489     8.358     0.200
     1.825     9.287     0.200
     2.348    11.672     0.200
     2.391    10.507     0.200
     3.064    12.786     0.200
     3.586    14.287     0.200
     5.832    19.219     0.200
     1.728    11.145     0.200
     1.979    11.071     0.200
     1.979    11.278     0.200
     2.251    12.343     0.200
     2.434    13.085     0.200
     2.530    14.098     0.200
     2.683    12.639     0.200
     2.808    12.081     0.200
     2.779    13.568     0.200
     2.898    13.516     0.200
     2.859    13.749     0.200
     2.966    13.818     0.200
     2.913    13.573     0.200
     3.454    13.669     0.200
     3.339    14.991     0.200
     3.561    14.029     0.200
     3.767    14.494     0.200
     4.036    15.005     0.200
     4.036    15.201     0.200
     4.174    15.834     0.200
     4.281    17.093     0.200
     4.402    17.083     0.200
     4.832    15.740     0.200
     4.892    16.135     0.200
     4.929    15.988     0.200
     4.929    16.347     0.200
     4.928    16.321     0.200
     4.928    16.583     0.200
     5.068    16.775     0.200
     5.068    17.228     0.200
     5.139    16.255     0.200
     5.169    17.909     0.200
     5.194    16.710     0.200
     5.213    16.891     0.200
     5.401    17.393     0.200
     5.423    17.431     0.200
     5.464    17.161     0.200
     5.820    18.503     0.200
     5.903    19.796     0.200
     5.950    18.606     0.200
     6.009    18.898     0.200
     6.009    18.148     0.200
     6.195    19.128     0.200
     6.195    18.953     0.200
     6.317    21.914     0.200
     6.566    19.594     0.200
     6.555    20.236     0.200
     7.091    21.075     0.200
     7.092    20.858     0.200
     8.167    24.924     0.200
     8.293    23.549     0.200
     8.630    24.112     0.200
     2.375    12.056     0.200
     3.027    15.861     0.200
     3.576    16.096     0.200
     5.572    18.473     0.200
     5.572    18.273     0.200
     6.085    19.381     0.200
     6.496    21.085     0.200
     1.771    10.783     0.200
     2.451    12.444     0.200
     2.583    13.553     0.200
     3.763    13.511     0.200
     3.813    13.527     0.200
     3.914    16.271     0.200
     4.024    15.748     0.200
     4.025    15.322     0.200
     4.152    15.972     0.200
     4.181    16.150     0.200
     4.311    15.918     0.200
     4.375    17.067     0.200
     4.390    16.292     0.200
     5.104    18.157     0.200
     5.479    18.884     0.200
     5.588    18.908     0.200
     1.911     9.116     0.200
     1.981    10.648     0.200
     2.137     9.999     0.200
     2.337    11.198     0.200
     2.761    12.254     0.200
     2.827    10.904     0.200
     2.876    11.827     0.200
     2.876    12.577     0.200
     2.932    10.538     0.200
     3.121    11.142     0.200
     3.196    12.339     0.200
     3.689    11.797     0.200
     3.789    12.588     0.200
     3.969    13.512     0.200
     3.969    13.918     0.200
     4.052    13.649     0.200
     4.052    13.356     0.200
     4.152    14.198     0.200
     4.198    13.415     0.200
     4.293    13.735     0.200
     4.359    14.761     0.200
     4.359    14.647     0.200
     4.491    14.780     0.200
     4.528    14.492     0.200
     4.607    15.069     0.200
     4.607    14.960     0.200
     4.647    15.005     0.200
     4.647    14.739     0.200
     4.700    14.396     0.200
     4.700    14.509     0.200
     4.818    16.703     0.200
     4.955    15.401     0.200
     5.214    15.716     0.200
     5.513    16.755     0.200
     5.751    16.713     0.200
     5.928    17.053     0.200
     6.079    17.088     0.200
     6.454    18.097     0.200
     7.181    20.103     0.200
     7.598    20.963     0.200
     1.439     8.805     0.200
     1.515     9.401     0.200
     1.545     8.899     0.200
     1.698    10.010     0.200
     1.730     9.682     0.200
     2.220    10.464     0.200
     2.579    12.176     0.200
     2.579     9.880     0.200
     2.724    11.534     0.200
     2.724    11.722     0.200
     2.814    10.101     0.200
     3.142    13.771     0.200
     3.599    14.714     0.200
     3.797    15.366     0.200
     3.801    13.476     0.200
     3.866    12.764     0.200
     3.977    17.173     0.200
     4.036    13.677     0.200
     4.036    13.200     0.200
     4.059    13.347     0.200
     4.059    13.121     0.200
     4.064    13.297     0.200
     4.363    15.708     0.200
     4.400    15.867     0.200
     4.535    16.596     0.200
     4.541    14.830     0.200
     4.650    15.054     0.200
     4.650    14.874     0.200
     4.852    19.265     0.200
     4.864    15.748     0.200
     5.015    15.795     0.200
     5.080    16.235     0.200
     5.112    17.918     0.200
     5.178    17.495     0.200
     5.597    17.604     0.200
     5.614    17.201     0.200
     5.997    18.442     0.200
     1.604     9.615     0.200
     1.628     9.454     0.200
     2.889    11.147     0.200
     2.889    11.260     0.200
     3.025    14.198     0.200
     2.987    14.588     0.200
     2.987    12.608     0.200
     2.967    12.523     0.200
     3.104    12.228     0.200
     3.104    12.483     0.200
     3.230    13.315     0.200
     3.344    16.221     0.200
     4.084    17.310     0.200
     4.431    17.074     0.200
     4.431    17.186     0.200
     4.480    17.664     0.200
     4.771    15.886     0.200
     4.771    16.024     0.200
     4.792    16.454     0.200
     4.792    16.186     0.200
     4.793    16.550     0.200
     4.793    15.931     0.200
     5.093    17.447     0.200
     5.093    17.142     0.200
     5.133    17.179     0.200
     5.133    17.077     0.200
     5.256    17.647     0.200
     5.256    17.348     0.200
     5.344    17.417     0.200
     5.383    17.760     0.200
     5.383    17.500     0.200
     5.458    17.888     0.200
     5.588    18.642     0.200
     5.748    18.400     0.200
     5.748    18.169     0.200
     5.908    19.134     0.200
     6.319    20.136     0.200
     6.348    20.401     0.200
     6.716    21.208     0.200
     6.967    21.680     0.200
     7.641    23.410     0.200
     1.646     9.679     0.200
     1.740    11.634     0.200
     1.903    10.929     0.200
     2.462    13.435     0.200
     2.705    12.840     0.200
     2.705    13.043     0.200
     3.687    14.519     0.200
     4.085    15.900     0.200
     4.085    15.330     0.200
     4.818    15.709     0.200
     4.882    16.164     0.200
     4.923    17.037     0.200
     5.091    17.048     0.200
     5.172    16.968     0.200
     5.404    17.468     0.200
     5.451    17.316     0.200
     5.451    17.137     0.200
     5.956    19.089     0.200
     6.003    18.679     0.200
     6.195    19.338     0.200
     6.682    20.348     0.200
     7.096    20.926     0.200
     2.019    11.386     0.200
     2.078     9.952     0.200
     2.291    11.598     0.200
     2.427    13.376     0.200
     2.672    12.620     0.200
     3.522    16.157     0.200
     3.699    15.058     0.200
     3.881    14.909     0.200
     3.942    14.505     0.200
     4.043    15.175     0.200
     4.336    15.195     0.200
     4.496    15.333     0.200
     4.579    16.614     0.200
     4.792    15.816     0.200
     1.990    12.079     0.200
     2.107    12.610     0.200
     2.436    13.434     0.200
     2.438    13.968     0.200
     2.494    12.423     0.200
     2.528    13.105     0.200
     2.528    13.448     0.200
     2.528    13.550     0.200
     2.521    13.439     0.200
     2.609    14.157     0.200
     2.694    14.884     0.200
     2.696    15.013     0.200
     2.778    14.585     0.200
     2.769    14.949     0.200
     2.769    15.285     0.200
     2.814    16.002     0.200
     2.822    14.169     0.200
     2.940    13.316     0.200
     3.031    13.914     0.200
     3.132    13.372     0.200
     3.229    13.109     0.200
     3.263    15.269     0.200
     3.473    15.438     0.200
     3.828    17.308     0.200
     4.029    16.543     0.200
     4.076    13.857     0.200
     4.076    14.013     0.200
     4.272    16.157     0.200
     4.272    17.290     0.200
     4.444    15.856     0.200
     4.444    15.575     0.200
     4.467    16.822     0.200
     4.503    16.738     0.200
     4.503    16.308     0.200
     4.618    16.446     0.200
     4.618    16.313     0.200
     4.633    17.815     0.200
     4.633    17.479     0.200
     4.803    18.576     0.200
     4.883    16.739     0.200
     5.120    22.146     0.200
     5.449    20.442     0.200
     5.495    17.770     0.200
     5.495    17.473     0.200
     5.548    17.638     0.200
     5.548    17.466     0.200
     5.549    18.039     0.200
     5.549    18.188     0.200
     5.579    18.021     0.200
     5.579    18.138     0.200
     5.624    18.015     0.200
     5.624    18.476     0.200
     5.673    18.734     0.200
     5.673    18.859     0.200
     5.673    19.765     0.200
     5.813    18.861     0.200
     5.813    19.025     0.200
     5.813    18.470     0.200
     5.866    18.843     0.200
     5.866    18.522     0.200
     5.873    18.859     0.200
     5.873    18.672     0.200
     5.873    20.077     0.200
     5.874    17.414     0.200
     5.874    18.468     0.200
     6.002    19.412     0.200
     6.002    19.670     0.200
     6.002    20.303     0.200
     6.028    18.948     0.200
     6.028    18.596     0.200
     6.094    19.180     0.200
     6.125    19.220     0.200
     6.125    18.790     0.200
     6.154    20.182     0.200
     6.359    20.803     0.200
     6.483    19.949     0.200
     6.483    19.816     0.200
     6.569    20.258     0.200
     6.569    19.946     0.200
     6.624    22.891     0.200
     6.657    20.503     0.200
     6.657    20.362     0.200
     6.657    20.745     0.200
     6.829    20.808     0.200
     6.829    21.159     0.200
     6.829    20.573     0.200
     6.829    21.370     0.200
     7.052    20.894     0.200
     7.052    21.496     0.200
     7.168    22.144     0.200
     7.194    21.009     0.200
     7.194    22.142     0.200
     7.196    21.846     0.200
     7.213    21.525     0.200
     7.299    21.816     0.200
     7.510    23.055     0.200
     7.510    22.836     0.200
     7.665    22.248     0.200
     7.710    22.624     0.200
     7.807    23.184     0.200
     7.883    23.959     0.200
     7.883    24.248     0.200
     8.107    24.521     0.200
     8.257    23.829     0.200
     8.257    24.228     0.200
     8.309    22.827     0.200
     8.563    25.677     0.200
     8.653    25.651     0.200
     9.599    26.724     0.200
     9.599    26.427     0.200
     9.773    27.400     0.200
    10.417    30.338     0.200
    11.105    29.426     0.200
    11.981    33.132     0.200
    12.744    30.359     0.200
    12.744    32.351     0.200
    13.151    33.453     0.200
    13.151    34.524     0.200
    13.278    32.839     0.200
    18.061    41.797     0.200
    18.050    41.073     0.200
    18.127    41.143     0.200
    18.424    41.298     0.200
    18.637    42.186     0.200
    18.871    42.171     0.200
    18.940    43.042     0.200
    18.989    41.702     0.200
    19.047    41.844     0.200
    19.100    41.824     0.200
    19.105    42.368     0.200
    19.267    42.159     0.200
    19.334    41.898     0.200
     0.453     5.591     0.200
     0.823     6.420     0.200
     0.962     7.194     0.200
     1.102     7.129     0.200
     1.102     6.830     0.200
     1.248     7.744     0.200
     1.380     8.010     0.200
     1.703     6.121     0.200
     2.163     9.410     0.200
     2.550     9.658     0.200
     2.659    10.681     0.200
     2.659     8.955     0.200
     4.111    12.252     0.200
     4.202    12.288     0.200
     4.202    12.154     0.200
     4.272    13.435     0.200
     4.336    12.828     0.200
     4.415    13.010     0.200
     4.415    12.799     0.200
     4.504    14.168     0.200
     4.652    14.235     0.200
     4.750    13.200     0.200
     4.821    13.472     0.200
     5.094    13.779     0.200
     5.391    15.024     0.200
     5.582    15.682     0.200
     5.907    16.594     0.200
     6.101    16.834     0.200
     1.531     9.579     0.200
     2.345    12.179     0.200
     2.600    13.898     0.200
     3.197    14.957     0.200
     3.297    15.411     0.200
     3.672    13.261     0.200
     3.672    13.018     0.200
     3.736    13.711     0.200
     3.736    12.906     0.200
     3.781    13.840     0.200
     3.729    14.161     0.200
     3.984    14.919     0.200
     3.879    16.788     0.200
     4.035    15.326     0.200
     4.035    14.490     0.200
     4.071    14.650     0.200
     4.118    16.286     0.200
     4.282    15.043     0.200
     4.282    14.933     0.200
     4.265    15.347     0.200
     4.305    14.894     0.200
     4.232    16.679     0.200
     4.660    16.225     0.200
     4.660    15.593     0.200
     4.842    16.843     0.200
     4.861    16.083     0.200
     4.861    16.201     0.200
     5.562    18.195     0.200
     5.978    19.449     0.200
     1.327     9.157     0.200
     1.654     9.628     0.200
     1.676    10.154     0.200
     1.676    10.263     0.200
     2.207    11.708     0.200
     2.862    14.524     0.200
     3.076    12.901     0.200
     3.076    12.800     0.200
     3.226    12.969     0.200
     3.226    13.149     0.200
     3.300    14.007     0.200
     3.695    16.118     0.200
     3.961    16.662     0.200
     4.378    17.070     0.200
     4.378    16.609     0.200
     4.409    17.599     0.200
     4.409    16.521     0.200
     4.501    16.346     0.200
     4.664    16.057     0.200
     4.679    16.485     0.200
     4.682    16.143     0.200
     4.682    15.385     0.200
     4.997    17.164     0.200
     5.022    16.675     0.200
     5.137    16.829     0.200
     5.232    17.980     0.200
     5.273    17.453     0.200
     5.273    16.782     0.200
     5.341    17.755     0.200
     5.498    18.226     0.200
     5.812    19.451     0.200
     6.230    19.781     0.200
     1.865    13.398     0.200
     2.147    13.499     0.200
     2.152    13.239     0.200
     2.233    13.672     0.200
     2.552    12.606     0.200
     2.495    13.671     0.200
     3.067    13.099     0.200
     3.184    14.599     0.200
     3.480    15.886     0.200
     3.482    16.891     0.200
     3.654    15.189     0.200
     5.402    18.475     0.200
     5.402    18.270     0.200
     5.459    18.558     0.200
     5.559    20.035     0.200
     5.559    18.949     0.200
     5.714    19.786     0.200
     5.873    20.871     0.200
     5.842    21.138     0.200
     5.973    19.611     0.200
     6.533    20.448     0.200
     7.098    22.777     0.200
     7.254    23.160     0.200
     7.670    23.610     0.200
     7.722    23.546     0.200
     1.726    12.812     0.200
     1.726    12.340     0.200
     1.863    12.256     0.200
     2.305    12.934     0.200
     2.670    14.033     0.200
     3.586    15.643     0.200
     4.482    17.135     0.200
     4.482    17.436     0.200
     5.061    18.512     0.200
     5.169    18.560     0.200
     5.169    18.157     0.200
     5.169    18.665     0.200
     5.220    18.859     0.200
     5.252    18.530     0.200
     5.252    17.409     0.200
     5.320    18.998     0.200
     5.320    18.768     0.200
     5.458    19.687     0.200
     5.562    19.667     0.200
     5.699    20.171     0.200
     5.713    19.554     0.200
     5.823    20.220     0.200
     5.823    19.771     0.200
     6.318    21.248     0.200
     6.396    20.903     0.200
     6.573    22.266     0.200
     6.878    22.006     0.200
     7.101    22.812     0.200
     7.298    22.378     0.200
     1.770    10.614     0.200
     1.770    10.835     0.200
     2.438    12.771     0.200
     2.369    12.213     0.200
     2.433    11.598     0.200
     3.292    15.991     0.200
     3.212    15.298     0.200
     3.212    12.365     0.200
     3.273    13.806     0.200
     3.439    14.175     0.200
     3.439    15.204     0.200
     3.780    14.078     0.200
     3.780    13.661     0.200
     3.830    14.491     0.200
     3.861    13.783     0.200
     3.898    16.652     0.200
     4.040    15.658     0.200
     4.040    15.373     0.200
     4.129    16.003     0.200
     4.129    16.302     0.200
     4.168    16.144     0.200
     4.282    16.918     0.200
     4.196    15.210     0.200
     4.196    14.650     0.200
     4.328    16.283     0.200
     4.328    16.183     0.200
     4.392    16.739     0.200
     4.407    15.656     0.200
     4.879    16.726     0.200
     4.940    17.341     0.200
     5.122    18.021     0.200
     5.122    18.784     0.200
     5.496    18.750     0.200
     5.605    18.974     0.200
     5.582    17.584     0.200
     6.045    19.485     0.200
     1.537    10.324     0.200
     2.342    13.944     0.200
     2.333    11.976     0.200
     2.865    13.921     0.200
     3.185    15.430     0.200
     3.306    15.706     0.200
     3.693    13.615     0.200
     3.757    14.766     0.200
     3.801    15.242     0.200
     4.057    16.370     0.200
     4.057    16.170     0.200
     4.086    16.001     0.200
     4.278    17.248     0.200
     4.301    16.422     0.200
     4.212    16.132     0.200
     4.861    16.927     0.200
     1.348     9.585     0.200
     1.848    11.558     0.200
     2.694    13.616     0.200
     2.811    14.512     0.200
     3.033    15.181     0.200
     3.070    13.601     0.200
     3.613    16.373     0.200
     3.749    15.212     0.200
     3.876    15.187     0.200
     3.847    16.565     0.200
     3.952    15.734     0.200
     3.952    15.601     0.200
     4.215    15.379     0.200
     4.448    16.284     0.200
     4.513    16.539     0.200
     4.527    16.352     0.200
     1.052     7.834     0.200
     1.375     8.760     0.200
     1.511     6.627     0.200
     1.507     8.924     0.200
     2.421    10.453     0.200
     2.430     8.180     0.200
     2.527     9.265     0.200
     3.221     9.318     0.200
     3.327    11.355     0.200
     4.207    12.682     0.200
     4.311    12.999     0.200
     4.311    12.585     0.200
     4.253    13.341     0.200
     4.392    13.242     0.200
     4.392    13.530     0.200
     4.603    14.065     0.200
     4.723    14.413     0.200
     4.845    14.008     0.200
     4.845    14.712     0.200
     4.964    15.068     0.200
     4.964    14.435     0.200
     5.459    16.325     0.200
     5.537    15.495     0.200
     5.537    14.839     0.200
     5.954    16.807     0.200
     6.020    17.099     0.200
     6.240    17.036     0.200
     2.329    11.210     0.200
     4.228    13.132     0.200
     4.228    12.089     0.200
     4.305    12.895     0.200
     4.305    13.192     0.200
     4.326    12.970     0.200
     4.326    11.873     0.200
     4.412    13.238     0.200
     4.523    13.805     0.200
     4.652    14.180     0.200
     4.766    14.103     0.200
     4.766    14.845     0.200
     4.784    15.167     0.200
     4.871    15.285     0.200
     4.871    14.508     0.200
     5.019    15.689     0.200
     5.019    16.087     0.200
     5.444    15.665     0.200
     5.444    15.829     0.200
     5.845    17.715     0.200
     5.936    17.247     0.200
     6.149    17.330     0.200
     1.306     9.066     0.200
     1.400     9.730     0.200
     1.532     9.928     0.200
     1.995    12.033     0.200
     1.974    10.897     0.200
     2.401    13.014     0.200
     2.482    10.102     0.200
     2.482    10.360     0.200
     2.585    11.730     0.200
     2.770    12.034     0.200
     3.264     8.914     0.200
     3.223    11.691     0.200
     3.602    13.892     0.200
     4.150    13.455     0.200
     4.253    13.948     0.200
     4.253    13.362     0.200
     4.209    13.674     0.200
     4.336    13.989     0.200
     4.336    13.598     0.200
     4.334    13.631     0.200
     4.426    14.083     0.200
     4.426    14.380     0.200
     4.545    14.581     0.200
     4.545    13.995     0.200
     4.667    15.180     0.200
     4.788    14.805     0.200
     4.788    15.156     0.200
     4.833    15.885     0.200
     4.884    15.072     0.200
     4.905    15.598     0.200
     4.905    14.848     0.200
     5.074    15.909     0.200
     5.401    16.260     0.200
     5.479    16.032     0.200
     5.962    17.346     0.200
     6.182    17.996     0.200
     6.599    19.141     0.200
     1.828    11.581     0.200
     1.828    12.007     0.200
     2.018    11.638     0.200
     2.247    14.249     0.200
     2.492    13.104     0.200
     2.492    12.721     0.200
     2.762    14.027     0.200
     2.683    13.056     0.200
     2.683    12.527     0.200
     3.146    15.306     0.200
     3.494    15.918     0.200
     3.481    14.319     0.200
     3.792    15.845     0.200
     4.925    16.864     0.200
     4.997    17.135     0.200
     5.046    17.376     0.200
     5.046    17.051     0.200
     5.080    17.092     0.200
     5.266    17.936     0.200
     5.266    17.334     0.200
     5.311    18.283     0.200
     5.391    18.000     0.200
     5.496    19.349     0.200
     5.545    18.652     0.200
     5.561    18.751     0.200
     6.102    19.543     0.200
     6.102    19.297     0.200
     6.330    20.181     0.200
     6.686    20.927     0.200
     6.825    21.373     0.200
     7.240    22.243     0.200
     1.988    11.052     0.200
     1.958    12.561     0.200
     2.380    12.881     0.200
     2.511    11.643     0.200
     2.401    12.461     0.200
     2.486    11.989     0.200
     2.486    11.624     0.200
     2.576    12.460     0.200
     2.755    13.959     0.200
     3.207    12.093     0.200
     3.216    13.729     0.200
     3.295    14.735     0.200
     3.274    10.993     0.200
     3.362    14.560     0.200
     4.160    15.450     0.200
     4.199    15.457     0.200
     4.199    16.533     0.200
     4.262    15.452     0.200
     4.262    15.350     0.200
     4.341    15.763     0.200
     4.341    16.409     0.200
     4.350    15.744     0.200
     4.439    15.867     0.200
     4.439    16.149     0.200
     4.479    15.895     0.200
     4.555    16.538     0.200
     4.555    16.307     0.200
     4.679    16.881     0.200
     4.798    16.761     0.200
     4.798    16.873     0.200
     4.833    17.620     0.200
     4.892    16.922     0.200
     4.911    17.414     0.200
     5.071    18.001     0.200
     5.096    18.296     0.200
     5.225    19.879     0.200
     5.410    18.426     0.200
     5.485    18.099     0.200
     5.898    20.048     0.200
     5.971    19.398     0.200
     6.142    20.451     0.200
     6.142    20.213     0.200
     6.188    19.940     0.200
     6.444    20.152     0.200
     6.605    20.916     0.200
     7.165    22.259     0.200
     7.882    23.862     0.200
     8.156    23.870     0.200
     8.253    24.153     0.200
     0.294     5.562     0.200
     0.874     6.423     0.200
     1.334     6.905     0.200
     1.409     8.521     0.200
     1.506     7.890     0.200
     1.540     8.573     0.200
     1.534     5.757     0.200
     2.032     9.396     0.200
     1.960     8.659     0.200
     2.431     9.584     0.200
     2.366     9.209     0.200
     2.552     9.978     0.200
     2.445     9.959     0.200
     2.445     8.256     0.200
     2.759    11.441     0.200
     2.806    10.965     0.200
     3.270    11.431     0.200
     3.226     8.498     0.200
     3.195    10.472     0.200
     3.413    11.927     0.200
     3.626    12.418     0.200
     3.626    10.550     0.200
     3.633    12.554     0.200
     3.724    11.929     0.200
     4.175    12.347     0.200
     4.279    12.707     0.200
     4.246    12.356     0.200
     4.246    12.481     0.200
     4.265    13.943     0.200
     4.265    14.154     0.200
     4.357    13.101     0.200
     4.357    12.711     0.200
     4.361    12.938     0.200
     4.361    13.320     0.200
     4.448    13.124     0.200
     4.448    13.327     0.200
     4.505    13.101     0.200
     4.571    13.658     0.200
     4.571    13.548     0.200
     4.611    14.067     0.200
     4.618    13.951     0.200
     4.618    13.169     0.200
     4.689    14.154     0.200
     4.813    13.753     0.200
     4.813    14.081     0.200
     4.868    14.248     0.200
     4.868    14.767     0.200
     4.868    14.525     0.200
     4.910    14.015     0.200
     4.936    14.253     0.200
     5.110    15.025     0.200
     5.110    14.915     0.200
     5.141    14.671     0.200
     5.272    16.519     0.200
     5.428    15.608     0.200
     5.510    15.254     0.200
     5.683    16.030     0.200
     5.940    16.878     0.200
     5.989    16.219     0.200
     6.153    17.181     0.200
     6.153    16.931     0.200
     6.212    17.110     0.200
     6.483    17.075     0.200
     6.541    18.239     0.200
     6.629    18.161     0.200
     6.690    17.799     0.200
     6.796    18.251     0.200
     7.580    19.786     0.200
     7.909    20.410     0.200
     8.179    20.690     0.200
     8.296    21.082     0.200
     1.828     8.827     0.200
     1.918    10.220     0.200
     2.099    10.641     0.200
     3.217    15.090     0.200
     3.687    15.878     0.200
     3.799    15.819     0.200
     4.177    15.147     0.200
     4.243    14.257     0.200
     4.241    13.618     0.200
     4.577    15.152     0.200
     4.636    15.421     0.200
     4.618    17.443     0.200
     4.632    15.583     0.200
     4.650    14.865     0.200
     4.829    15.750     0.200
     4.863    15.825     0.200
     4.942    17.192     0.200
     5.161    16.152     0.200
     5.310    16.555     0.200
     5.446    17.371     0.200
     5.856    17.621     0.200
     5.894    17.327     0.200
     6.299    18.661     0.200
     1.462     9.233     0.200
     1.663    10.254     0.200
     2.033    12.928     0.200
     2.338    12.440     0.200
     2.395    10.435     0.200
     2.395    11.373     0.200
     2.549    11.779     0.200
     2.909    12.928     0.200
     3.145    11.214     0.200
     3.212    13.475     0.200
     3.656    14.302     0.200
     3.756    16.150     0.200
     4.151    14.407     0.200
     4.261    14.177     0.200
     4.261    14.404     0.200
     4.350    14.654     0.200
     4.326    14.695     0.200
     4.513    15.360     0.200
     4.547    15.714     0.200
     4.650    15.487     0.200
     4.787    16.154     0.200
     4.903    16.074     0.200
     4.903    15.949     0.200
     4.936    16.308     0.200
     4.936    16.097     0.200
     5.161    16.980     0.200
     5.161    16.816     0.200
     5.349    18.494     0.200
     5.411    17.484     0.200
     5.512    16.841     0.200
     5.512    17.200     0.200
     5.675    19.126     0.200
     5.919    15.035     0.200
     5.971    18.392     0.200
     5.998    18.362     0.200
     6.209    18.450     0.200
     6.477    19.699     0.200
     6.528    18.820     0.200
     6.815    20.426     0.200
     1.304     9.187     0.200
     2.018    10.291     0.200
     2.863    13.443     0.200
     4.032    15.101     0.200
     4.230    15.088     0.200
     4.285    16.030     0.200
     4.387    15.026     0.200
     4.557    15.530     0.200
     4.592    15.486     0.200
     5.404    17.509     0.200
     5.692    14.582     0.200
     5.839    19.225     0.200
     1.677    11.488     0.200
     1.677    11.269     0.200
     1.889    11.678     0.200
     1.889    12.444     0.200
     1.889    12.295     0.200
     1.999    11.513     0.200
     1.999    11.341     0.200
     2.302    13.128     0.200
     2.047    12.449     0.200
     2.047    12.214     0.200
     2.047    13.777     0.200
     2.279    12.028     0.200
     2.461    12.137     0.200
     2.461    12.519     0.200
     2.554    13.493     0.200
     2.554    13.353     0.200
     2.861    13.891     0.200
     2.985    13.432     0.200
     2.985    14.846     0.200
     2.998    13.745     0.200
     3.213    14.241     0.200
     3.303    14.684     0.200
     3.366    14.736     0.200
     3.260    13.554     0.200
     3.260    14.616     0.200
     3.663    15.859     0.200
     3.663    16.922     0.200
     4.466    15.947     0.200
     4.574    17.808     0.200
     4.956    16.934     0.200
     5.039    17.037     0.200
     5.039    17.427     0.200
     5.097    17.322     0.200
     5.159    16.909     0.200
     5.197    17.706     0.200
     5.197    18.503     0.200
     5.273    17.670     0.200
     5.273    17.834     0.200
     5.384    18.346     0.200
     5.346    18.076     0.200
     5.497    20.775     0.200
     5.532    18.500     0.200
     5.509    18.518     0.200
     5.594    18.170     0.200
     5.594    18.366     0.200
     5.617    18.326     0.200
     5.662    18.757     0.200
     6.179    19.375     0.200
     6.175    20.104     0.200
     6.297    20.181     0.200
     6.394    20.284     0.200
     6.394    20.073     0.200
     6.781    23.580     0.200
     6.497    20.524     0.200
     6.736    20.615     0.200
     6.749    16.903     0.200
     6.919    20.414     0.200
     6.898    21.341     0.200
     6.959    21.770     0.200
     7.096    21.060     0.200
     7.223    22.294     0.200
     7.314    22.332     0.200
     7.309    22.489     0.200
     7.382    21.570     0.200
     7.870    23.504     0.200
     8.239    24.768     0.200
     8.551    24.910     0.200
     8.591    24.005     0.200
     8.862    25.648     0.200
     9.158    25.798     0.200
     9.228    25.551     0.200
     9.293    27.048     0.200
     1.699    11.712     0.200
     1.984    12.045     0.200
     1.905    12.448     0.200
     1.905    12.823     0.200
     2.053    13.102     0.200
     2.281    12.685     0.200
     2.299    13.358     0.200
     2.299    14.342     0.200
     2.457    12.895     0.200
     2.457    13.379     0.200
     2.569    13.712     0.200
     2.569    14.071     0.200
     2.569    15.071     0.200
     2.854    14.610     0.200
     2.983    14.795     0.200
     2.989    13.751     0.200
     2.989    16.172     0.200
     3.258    14.333     0.200
     3.301    15.584     0.200
     3.368    15.307     0.200
     3.680    16.497     0.200
     3.680    17.114     0.200
     4.170    16.196     0.200
     4.435    14.921     0.200
     4.456    16.822     0.200
     4.563    16.908     0.200
     4.936    17.730     0.200
     5.018    17.929     0.200
     5.018    18.570     0.200
     5.077    18.186     0.200
     5.141    18.106     0.200
     5.251    18.419     0.200
     5.251    18.654     0.200
     5.326    18.995     0.200
     5.369    18.620     0.200
     5.405    19.161     0.200
     5.488    19.461     0.200
     5.488    20.318     0.200
     5.518    18.915     0.200
     5.573    18.981     0.200
     5.573    19.200     0.200
     5.598    19.053     0.200
     5.642    19.897     0.200
     6.161    20.403     0.200
     6.285    21.093     0.200
     6.375    21.352     0.200
     6.375    21.680     0.200
     6.495    20.408     0.200
     6.716    21.574     0.200
     6.775    23.354     0.200
     6.880    22.169     0.200
     6.906    21.298     0.200
     6.938    22.506     0.200
     7.083    22.295     0.200
     7.203    23.069     0.200
     7.289    23.132     0.200
     7.295    23.019     0.200
     7.365    22.647     0.200
     7.852    24.103     0.200
     8.379    24.126     0.200
     8.533    25.852     0.200
     8.581    24.459     0.200
     8.735    26.003     0.200
     8.843    26.426     0.200
     9.141    26.976     0.200
     9.368    26.548     0.200
     1.871    10.060     0.200
     2.018     9.495     0.200
     2.218    10.681     0.200
     2.133    11.585     0.200
     2.657    10.981     0.200
     2.838    12.349     0.200
     2.870    12.824     0.200
     2.910    11.704     0.200
     2.986    11.582     0.200
     3.671    11.877     0.200
     3.916    12.824     0.200
     3.993    12.722     0.200
     4.048    13.899     0.200
     4.048    14.292     0.200
     4.117    13.937     0.200
     4.188    13.805     0.200
     4.188    15.211     0.200
     4.252    13.744     0.200
     4.304    14.351     0.200
     4.304    14.883     0.200
     4.392    13.788     0.200
     4.392    14.001     0.200
     4.485    15.103     0.200
     4.553    14.188     0.200
     4.571    14.349     0.200
     4.592    14.422     0.200
     5.135    15.263     0.200
     5.345    16.362     0.200
     5.401    15.912     0.200
     5.852    16.705     0.200
     7.515    21.319     0.200
     1.699    11.247     0.200
     1.875    11.621     0.200
     2.220    14.297     0.200
     2.271    12.175     0.200
     2.456    12.716     0.200
     2.539    12.884     0.200
     3.255    13.669     0.200
     3.655    16.233     0.200
     4.972    17.045     0.200
     5.054    17.225     0.200
     5.095    18.000     0.200
     5.113    17.429     0.200
     5.175    18.187     0.200
     5.289    19.263     0.200
     5.399    19.657     0.200
     5.525    19.251     0.200
     5.546    19.228     0.200
     5.610    19.601     0.200
     5.633    19.361     0.200
     6.195    20.004     0.200
     6.310    19.952     0.200
     6.752    21.324     0.200
     6.765    17.596     0.200
     6.914    21.985     0.200
     7.239    22.276     0.200
     7.397    22.159     0.200
     1.081     7.366     0.200
     1.425     8.759     0.200
     1.646     9.077     0.200
     1.687     9.384     0.200
     1.796     9.850     0.200
     2.184     9.479     0.200
     2.423    10.781     0.200
     2.515    12.044     0.200
     2.619    10.706     0.200
     2.691    12.868     0.200
     2.872    13.563     0.200
     3.397    10.807     0.200
     3.455    11.044     0.200
     3.495    11.290     0.200
     3.495    10.712     0.200
     3.528    11.192     0.200
     3.528    11.074     0.200
     3.523    12.967     0.200
     3.731    12.969     0.200
     3.569    13.446     0.200
     3.774    11.663     0.200
     3.774    12.514     0.200
     3.776    11.814     0.200
     3.776    11.939     0.200
     3.785    13.247     0.200
     3.785    13.122     0.200
     3.990    12.238     0.200
     3.999    12.097     0.200
     3.994    13.210     0.200
     3.994    13.100     0.200
     4.028    11.882     0.200
     4.028    12.358     0.200
     4.549    14.515     0.200
     4.774    14.353     0.200
     4.814    14.800     0.200
     0.942     6.468     0.200
     1.124     7.668     0.200
     1.692     8.853     0.200
     1.799     9.326     0.200
     2.652    10.537     0.200
     3.390    10.333     0.200
     3.483    11.631     0.200
     3.508    11.465     0.200
     3.564    11.961     0.200
     3.535    13.437     0.200
     3.755    11.983     0.200
     3.755    12.972     0.200
     3.972    11.605     0.200
     3.972    12.219     0.200
     3.959    11.675     0.200
     3.959    12.096     0.200
     4.020    11.484     0.200
     4.196    14.423     0.200
     4.380    13.331     0.200
     4.529    13.845     0.200
     4.529    14.189     0.200
     4.777    16.097     0.200
     5.121    14.621     0.200
     5.667    16.281     0.200
     1.901    13.073     0.200
     2.602    13.917     0.200
     2.602    13.353     0.200
     2.602    14.142     0.200
     2.594    13.799     0.200
     2.540    12.667     0.200
     2.645    13.044     0.200
     2.778    14.229     0.200
     2.778    14.340     0.200
     2.768    14.310     0.200
     2.776    13.542     0.200
     2.862    14.003     0.200
     2.864    14.032     0.200
     3.105    14.917     0.200
     3.105    15.058     0.200
     3.121    15.273     0.200
     3.064    13.641     0.200
     3.419    15.146     0.200
     3.404    15.955     0.200
     3.404    16.234     0.200
     3.445    14.652     0.200
     3.445    15.129     0.200
     3.495    13.612     0.200
     3.957    14.066     0.200
     3.957    14.265     0.200
     4.034    16.691     0.200
     4.165    16.808     0.200
     4.170    17.102     0.200
     4.170    16.961     0.200
     4.170    17.221     0.200
     4.259    15.906     0.200
     4.259    16.099     0.200
     4.316    17.125     0.200
     4.445    16.881     0.200
     4.445    16.998     0.200
     4.474    17.007     0.200
     4.474    17.714     0.200
     4.483    18.975     0.200
     4.555    16.639     0.200
     4.612    18.941     0.200
     4.613    17.949     0.200
     4.637    16.897     0.200
     4.637    17.442     0.200
     4.791    18.983     0.200
     4.921    17.464     0.200
     5.016    15.361     0.200
     5.232    21.877     0.200
     5.248    21.016     0.200
     5.296    18.000     0.200
     5.393    19.450     0.200
     5.425    19.982     0.200
     5.512    17.797     0.200
     5.529    17.862     0.200
     5.526    18.187     0.200
     5.526    18.889     0.200
     5.537    19.304     0.200
     5.537    19.523     0.200
     5.569    18.099     0.200
     5.569    17.871     0.200
     5.503    19.179     0.200
     5.585    18.056     0.200
     5.603    18.598     0.200
     5.603    18.082     0.200
     5.603    18.276     0.200
     5.742    19.410     0.200
     5.742    19.246     0.200
     5.884    18.549     0.200
     5.884    18.348     0.200
     5.884    18.749     0.200
     5.899    18.703     0.200
     5.925    18.464     0.200
     5.925    18.083     0.200
     5.925    18.353     0.200
     5.867    19.631     0.200
     6.000    18.822     0.200
     6.148    19.193     0.200
     6.151    19.164     0.200
     6.151    19.053     0.200
     6.162    19.025     0.200
     6.317    20.774     0.200
     6.383    22.409     0.200
     6.383    23.553     0.200
     6.528    20.002     0.200
     6.528    20.215     0.200
     6.658    20.289     0.200
     6.723    23.250     0.200
     6.783    20.554     0.200
     6.807    20.469     0.200
     6.807    20.295     0.200
     6.807    20.645     0.200
     6.775    21.338     0.200
     6.864    23.613     0.200
     6.906    21.760     0.200
     6.906    21.291     0.200
     6.906    23.012     0.200
     7.037    22.934     0.200
     7.037    22.182     0.200
     7.037    22.682     0.200
     7.116    25.549     0.200
     7.209    21.132     0.200
     7.286    22.639     0.200
     7.234    23.579     0.200
     7.427    24.585     0.200
     7.453    22.521     0.200
     7.542    22.254     0.200
     7.542    22.129     0.200
     7.575    23.228     0.200
     7.518    24.161     0.200
     7.659    22.405     0.200
     7.668    22.698     0.200
     7.812    22.772     0.200
     7.815    24.649     0.200
     7.815    24.385     0.200
     7.933    25.807     0.200
     7.960    24.801     0.200
     8.179    23.519     0.200
     8.209    23.936     0.200
     8.209    24.077     0.200
     8.209    23.597     0.200
     8.209    24.286     0.200
     8.220    28.321     0.200
     8.234    25.405     0.200
     8.551    25.106     0.200
     8.599    24.248     0.200
     8.816    24.926     0.200
     9.005    26.815     0.200
     9.077    25.767     0.200
     9.075    28.708     0.200
     9.106    27.197     0.200
     9.106    27.320     0.200
     9.189    26.059     0.200
     9.382    26.024     0.200
     9.367    28.279     0.200
     9.382    27.711     0.200
     9.514    26.543     0.200
     9.514    27.303     0.200
     9.565    26.741     0.200
     9.596    24.969     0.200
     9.679    29.811     0.200
     9.721    27.191     0.200
     9.677    31.269     0.200
     9.769    28.192     0.200
     9.866    27.208     0.200
     9.802    32.006     0.200
     9.967    27.644     0.200
     9.999    26.305     0.200
    10.060    31.993     0.200
    10.212    29.706     0.200
    10.310    29.580     0.200
    10.375    30.016     0.200
    10.573    30.079     0.200
    10.606    31.496     0.200
    10.711    30.018     0.200
    10.855    31.025     0.200
    10.945    30.774     0.200
    10.945    31.001     0.200
    10.945    29.468     0.200
    10.945    31.120     0.200
    10.932    30.083     0.200
    10.972    29.139     0.200
    10.994    31.547     0.200
    11.302    33.108     0.200
    11.302    32.257     0.200
    11.392    30.876     0.200
    11.644    32.463     0.200
    11.644    32.815     0.200
    12.946    34.643     0.200
    12.946    34.794     0.200
    12.946    34.983     0.200
    13.039    31.300     0.200
    13.039    30.980     0.200
    13.039    31.130     0.200
    14.338    36.642     0.200
    15.010    37.458     0.200
    15.010    39.266     0.200
    15.637    39.417     0.200
    15.992    42.131     0.200
    16.592    41.258     0.200
    16.988    41.842     0.200
    17.045    42.127     0.200
    17.298    41.625     0.200
    17.298    41.836     0.200
    17.835    42.366     0.200
    18.150    42.089     0.200
    18.150    42.304     0.200
    18.318    41.865     0.200
    18.318    42.160     0.200
    18.346    42.017     0.200
    18.693    42.847     0.200
    18.693    42.330     0.200
    19.032    42.528     0.200
    19.196    44.015     0.200
    19.228    44.146     0.200
    19.260    42.669     0.200
    19.251    42.840     0.200
    19.379    43.225     0.200
    19.379    43.985     0.200
    19.489    44.330     0.200
    19.825    44.046     0.200
    19.904    43.207     0.200
    20.210    42.684     0.200
    20.216    42.166     0.200
    20.668    42.901     0.200
    20.668    43.252     0.200
    20.842    42.110     0.200
     2.098    11.716     0.200
     2.194    12.366     0.200
     2.547    13.253     0.200
     2.583    14.250     0.200
     2.770    14.264     0.200
     2.770    13.874     0.200
     2.638    13.284     0.200
     3.106    14.476     0.200
     3.106    14.362     0.200
     3.419    15.386     0.200
     3.392    16.348     0.200
     4.248    15.978     0.200
     5.516    17.924     0.200
     5.500    17.379     0.200
     5.556    17.841     0.200
     5.556    19.025     0.200
     5.514    18.784     0.200
     5.572    17.788     0.200
     5.525    18.755     0.200
     5.734    19.402     0.200
     5.872    18.785     0.200
     5.886    19.267     0.200
     5.912    18.619     0.200
     5.987    18.710     0.200
     6.135    19.122     0.200
     6.138    18.962     0.200
     6.138    19.232     0.200
     6.149    18.976     0.200
     6.515    19.818     0.200
     6.645    20.635     0.200
     6.770    20.894     0.200
     6.795    21.586     0.200
     7.196    21.544     0.200
     7.529    23.757     0.200
     7.563    22.622     0.200
     7.646    22.454     0.200
     7.655    22.797     0.200
     7.799    23.184     0.200
     8.166    23.838     0.200
     8.196    24.207     0.200
     8.586    24.039     0.200
     8.803    25.894     0.200
     9.065    25.763     0.200
     9.177    26.027     0.200
     9.552    26.821     0.200
     9.853    27.889     0.200
     2.084    13.293     0.200
     2.178    12.547     0.200
     2.171    12.181     0.200
     2.171    12.443     0.200
     2.598    13.633     0.200
     2.583    13.596     0.200
     2.646    12.780     0.200
     2.563    12.919     0.200
     2.754    14.151     0.200
     2.754    14.514     0.200
     2.758    14.242     0.200
     2.858    14.640     0.200
     2.778    13.474     0.200
     3.100    15.323     0.200
     3.181    14.372     0.200
     3.093    14.567     0.200
     3.093    14.435     0.200
     3.404    15.466     0.200
     3.942    16.342     0.200
     3.942    15.908     0.200
     4.248    17.566     0.200
     4.426    16.844     0.200
     4.462    18.030     0.200
     4.462    18.460     0.200
     4.602    17.789     0.200
     4.604    18.470     0.200
     4.633    16.946     0.200
     4.633    17.086     0.200
     5.239    20.444     0.200
     5.493    17.653     0.200
     5.506    18.001     0.200
     5.510    19.008     0.200
     5.510    18.782     0.200
     5.523    19.819     0.200
     5.547    17.865     0.200
     5.547    17.978     0.200
     5.563    18.060     0.200
     5.563    17.837     0.200
     5.602    18.849     0.200
     5.602    18.595     0.200
     5.739    19.096     0.200
     5.739    20.115     0.200
     5.861    18.637     0.200
     5.861    18.875     0.200
     5.861    19.977     0.200
     5.877    19.438     0.200
     5.902    18.364     0.200
     5.902    19.173     0.200
     5.980    18.831     0.200
     6.125    19.142     0.200
     6.129    18.782     0.200
     6.129    19.341     0.200
     6.141    19.405     0.200
     6.180    20.447     0.200
     6.378    22.989     0.200
     6.509    19.975     0.200
     6.637    20.204     0.200
     6.637    20.470     0.200
     6.761    20.535     0.200
     6.787    20.945     0.200
     6.787    21.402     0.200
     6.893    21.980     0.200
     7.188    21.415     0.200
     7.365    23.527     0.200
     7.559    23.010     0.200
     7.639    22.599     0.200
     7.649    22.820     0.200
     7.791    23.281     0.200
     8.159    23.797     0.200
     8.190    24.235     0.200
     8.580    25.023     0.200
     8.798    25.651     0.200
     9.059    25.862     0.200
     9.171    25.895     0.200
     9.497    26.792     0.200
     9.702    27.132     0.200
     9.847    27.607     0.200
     2.974    12.614     0.200
     3.186    12.439     0.200
     3.464    13.943     0.200
     3.552    14.324     0.200
     3.617    17.613     0.200
     4.032    13.383     0.200
     4.032    13.894     0.200
     4.217    15.869     0.200
     4.354    13.951     0.200
     4.354    14.529     0.200
     4.502    16.087     0.200
     4.553    16.452     0.200
     4.562    16.138     0.200
     4.562    16.013     0.200
     4.438    20.026     0.200
     4.708    17.281     0.200
     4.710    17.272     0.200
     4.747    15.796     0.200
     4.747    15.257     0.200
     4.677    18.238     0.200
     4.913    21.684     0.200
     5.063    16.132     0.200
     5.137    17.070     0.200
     5.156    17.650     0.200
     5.327    19.139     0.200
     5.347    18.748     0.200
     5.555    17.345     0.200
     5.555    17.661     0.200
     5.562    17.070     0.200
     5.562    16.554     0.200
     5.526    19.161     0.200
     5.600    17.349     0.200
     5.600    17.599     0.200
     5.600    17.970     0.200
     5.504    18.319     0.200
     5.621    17.369     0.200
     5.621    17.127     0.200
     5.412    18.464     0.200
     5.596    17.860     0.200
     5.537    18.557     0.200
     5.619    18.401     0.200
     5.624    18.483     0.200
     5.719    17.687     0.200
     5.897    18.534     0.200
     5.897    18.171     0.200
     5.897    18.741     0.200
     5.897    19.233     0.200
     5.928    18.395     0.200
     5.928    18.270     0.200
     5.942    17.775     0.200
     5.942    18.264     0.200
     5.942    18.455     0.200
     5.856    18.003     0.200
     5.856    17.671     0.200
     5.856    18.803     0.200
     6.047    18.141     0.200
     6.047    18.325     0.200
     6.167    19.031     0.200
     6.180    18.616     0.200
     6.180    18.909     0.200
     6.197    18.965     0.200
     5.982    21.611     0.200
     6.189    20.035     0.200
     6.282    19.896     0.200
     6.493    21.570     0.200
     6.493    21.042     0.200
     6.580    19.177     0.200
     6.580    18.771     0.200
     6.438    25.185     0.200
     6.696    19.652     0.200
     6.696    19.976     0.200
     6.696    20.112     0.200
     6.817    20.259     0.200
     6.853    20.041     0.200
     6.853    19.737     0.200
     6.853    20.514     0.200
     6.853    20.987     0.200
     6.991    20.241     0.200
     6.991    20.448     0.200
     6.980    21.605     0.200
     6.892    20.788     0.200
     7.125    20.234     0.200
     7.125    20.555     0.200
     7.125    20.965     0.200
     7.126    21.552     0.200
     7.248    20.899     0.200
     7.194    22.251     0.200
     7.313    22.128     0.200
     7.569    21.736     0.200
     7.569    22.291     0.200
     7.643    21.873     0.200
     7.703    22.082     0.200
     7.721    22.136     0.200
     7.628    23.705     0.200
     7.849    22.872     0.200
     7.935    23.618     0.200
     8.028    22.848     0.200
     8.223    23.363     0.200
     8.264    22.960     0.200
     8.264    23.210     0.200
     8.264    24.121     0.200
     8.327    25.620     0.200
     8.459    24.570     0.200
     8.652    23.556     0.200
     8.625    22.457     0.200
     8.878    24.443     0.200
     9.246    25.322     0.200
     9.119    28.901     0.200
     9.227    26.078     0.200
     9.580    26.681     0.200
     9.580    26.196     0.200
     9.580    26.025     0.200
     9.620    26.412     0.200
     9.480    28.391     0.200
     9.777    25.469     0.200
     9.793    27.933     0.200
     9.921    27.171     0.200
    10.134    30.318     0.200
    10.671    28.344     0.200
    10.689    30.566     0.200
    10.865    30.855     0.200
    10.998    28.442     0.200
    10.967    28.529     0.200
    11.755    31.019     0.200
    11.755    31.472     0.200
    13.066    33.272     0.200
    13.066    33.784     0.200
    13.039    33.557     0.200
    13.039    35.210     0.200
    18.820    42.595     0.200
    18.972    40.925     0.200
    19.231    41.055     0.200
    20.071    42.105     0.200
     1.866    13.955     0.200
     2.120    11.720     0.200
     2.198    12.650     0.200
     2.205    13.159     0.200
     2.538    13.763     0.200
     2.538    14.252     0.200
     2.560    14.746     0.200
     2.612    14.333     0.200
     2.795    15.093     0.200
     2.795    13.884     0.200
     3.130    14.705     0.200
     3.130    14.200     0.200
     3.131    15.791     0.200
     3.440    14.907     0.200
     4.224    16.331     0.200
     5.484    18.229     0.200
     5.495    19.623     0.200
     5.505    18.324     0.200
     5.504    18.446     0.200
     5.544    18.245     0.200
     5.559    18.385     0.200
     5.708    19.142     0.200
     5.863    19.045     0.200
     5.874    19.676     0.200
     5.903    18.775     0.200
     5.971    19.144     0.200
     5.971    19.503     0.200
     6.125    19.662     0.200
     6.126    19.165     0.200
     6.126    19.774     0.200
     6.499    20.188     0.200
     6.499    20.362     0.200
     6.632    20.985     0.200
     6.779    20.896     0.200
     6.779    21.945     0.200
     6.779    21.779     0.200
     7.182    21.800     0.200
     7.632    23.071     0.200
     7.639    23.253     0.200
     7.786    23.633     0.200
     8.180    24.656     0.200
     8.570    25.173     0.200
     8.785    25.578     0.200
     1.919    13.450     0.200
     1.919    13.805     0.200
     2.067    12.121     0.200
     2.145    12.326     0.200
     2.215    11.389     0.200
     2.610    14.376     0.200
     2.564    13.172     0.200
     2.671    13.581     0.200
     2.671    13.329     0.200
     2.737    15.676     0.200
     3.093    16.266     0.200
     3.074    14.974     0.200
     3.074    14.536     0.200
     3.388    14.908     0.200
     3.962    17.765     0.200
     4.275    17.327     0.200
     5.526    17.806     0.200
     5.535    17.111     0.200
     5.567    17.922     0.200
     5.567    17.766     0.200
     5.584    18.053     0.200
     5.897    19.275     0.200
     5.920    20.226     0.200
     6.002    18.869     0.200
     6.002    20.030     0.200
     6.149    19.421     0.200
     6.161    19.804     0.200
     6.782    20.956     0.200
     6.809    21.491     0.200
     7.209    21.527     0.200
     7.661    22.675     0.200
     7.672    22.543     0.200
     8.823    25.217     0.200
     2.063    11.978     0.200
     2.176    12.244     0.200
     2.145    12.517     0.200
     2.216    11.691     0.200
     2.612    13.872     0.200
     2.646    13.857     0.200
     2.571    12.912     0.200
     2.571    13.552     0.200
     2.672    13.028     0.200
     2.748    14.094     0.200
     2.735    13.764     0.200
     2.735    14.645     0.200
     2.752    13.462     0.200
     3.071    14.516     0.200
     3.071    14.067     0.200
     3.200    14.787     0.200
     3.200    15.215     0.200
     5.264    20.056     0.200
     5.510    17.284     0.200
     5.510    17.054     0.200
     5.520    17.389     0.200
     5.520    17.647     0.200
     5.531    18.434     0.200
     5.531    18.152     0.200
     5.546    18.650     0.200
     5.561    17.414     0.200
     5.578    17.597     0.200
     5.578    17.345     0.200
     5.765    19.124     0.200
     5.871    18.152     0.200
     5.871    18.443     0.200
     5.891    18.925     0.200
     5.913    18.262     0.200
     5.997    18.348     0.200
     6.137    18.916     0.200
     6.143    18.355     0.200
     6.143    19.084     0.200
     6.156    19.046     0.200
     6.527    19.504     0.200
     6.527    19.112     0.200
     6.653    19.725     0.200
     6.653    20.234     0.200
     6.776    20.498     0.200
     6.804    21.098     0.200
     7.204    21.067     0.200
     7.260    21.312     0.200
     7.343    22.625     0.200
     7.656    22.212     0.200
     7.667    22.286     0.200
     7.806    22.725     0.200
     8.175    23.409     0.200
     8.209    23.776     0.200
     8.598    24.556     0.200
     8.818    24.945     0.200
     9.189    25.572     0.200
     1.831     8.828     0.200
     1.831     8.977     0.200
     2.101    11.347     0.200
     2.252    12.086     0.200
     2.154    12.251     0.200
     2.170    11.464     0.200
     2.570    12.354     0.200
     2.520    11.860     0.200
     2.443    10.789     0.200
     2.748    11.606     0.200
     2.724    12.499     0.200
     3.149    12.317     0.200
     2.993    12.856     0.200
     3.264    12.191     0.200
     3.309    11.724     0.200
     3.212    12.175     0.200
     3.573    13.707     0.200
     3.649    13.724     0.200
     3.651    13.586     0.200
     3.779    14.364     0.200
     3.746    14.297     0.200
     3.739    14.498     0.200
     3.819    14.440     0.200
     4.266    16.676     0.200
     4.280    14.247     0.200
     4.670    16.269     0.200
     4.702    15.199     0.200
     4.702    13.637     0.200
     4.743    16.218     0.200
     4.743    17.058     0.200
     4.882    16.148     0.200
     4.882    16.031     0.200
     5.066    15.722     0.200
     5.066    15.616     0.200
     5.089    15.712     0.200
     5.091    15.499     0.200
     5.091    15.608     0.200
     5.259    16.525     0.200
     5.354    17.812     0.200
     5.381    16.395     0.200
     5.381    17.043     0.200
     5.430    16.876     0.200
     5.554    16.075     0.200
     5.554    16.704     0.200
     5.551    16.477     0.200
     5.551    17.047     0.200
     5.639    17.292     0.200
     5.756    16.995     0.200
     5.871    18.396     0.200
     5.871    18.107     0.200
     6.011    19.016     0.200
     6.196    18.963     0.200
     6.196    19.240     0.200
     6.264    18.459     0.200
     6.601    19.388     0.200
     6.639    19.177     0.200
     6.996    20.424     0.200
     7.052    20.487     0.200
     7.066    20.426     0.200
     7.259    20.925     0.200
     7.572    21.779     0.200
     8.066    23.062     0.200
     1.469     9.379     0.200
     1.658     9.915     0.200
     1.765    10.089     0.200
     2.241    10.093     0.200
     2.241    10.861     0.200
     2.583    10.880     0.200
     2.684    15.865     0.200
     2.762    12.100     0.200
     2.907    14.492     0.200
     3.155    14.859     0.200
     3.397    15.966     0.200
     3.699    16.583     0.200
     3.818    15.475     0.200
     3.818    16.022     0.200
     3.822    15.922     0.200
     3.822    14.877     0.200
     3.901    14.326     0.200
     3.901    15.170     0.200
     3.988    19.377     0.200
     4.100    14.994     0.200
     4.100    14.886     0.200
     4.106    15.188     0.200
     4.398    15.130     0.200
     4.398    16.111     0.200
     4.442    15.283     0.200
     4.442    15.931     0.200
     4.579    16.003     0.200
     4.579    16.223     0.200
     4.648    16.404     0.200
     4.691    16.140     0.200
     4.691    16.359     0.200
     4.777    16.657     0.200
     4.897    16.635     0.200
     4.897    17.340     0.200
     5.273    18.270     0.200
     5.630    19.078     0.200
     5.651    18.656     0.200
     6.028    19.854     0.200
     6.069    19.625     0.200
     6.270    20.388     0.200
     6.557    21.161     0.200
     6.955    21.399     0.200
     2.078    11.256     0.200
     2.148    11.080     0.200
     2.378    12.567     0.200
     2.954    13.394     0.200
     3.400    13.577     0.200
     4.168    16.324     0.200
     4.309    15.742     0.200
     5.306    16.125     0.200
     1.333     9.358     0.200
     1.623     9.789     0.200
     1.946    10.653     0.200
     2.026    10.431     0.200
     3.179    15.262     0.200
     4.234    16.553     0.200
     1.855    12.533     0.200
     1.982    13.135     0.200
     2.254    11.994     0.200
     2.955    12.543     0.200
     3.106    14.019     0.200
     3.549    14.645     0.200
     3.978    16.660     0.200
     4.087    17.256     0.200
     4.206    15.908     0.200
     4.206    17.358     0.200
     4.186    16.589     0.200
     4.186    16.996     0.200
     4.469    17.723     0.200
     4.469    17.615     0.200
     4.697    17.850     0.200
     4.765    19.159     0.200
     4.782    17.634     0.200
     4.782    16.722     0.200
     5.231    14.958     0.200
     5.258    18.564     0.200
     5.325    18.724     0.200
     5.481    19.029     0.200
     5.714    19.723     0.200
     2.255    12.469     0.200
     2.998    14.293     0.200
     5.002    18.687     0.200
     5.085    19.358     0.200
     5.663    19.720     0.200
     1.568     9.764     0.200
     1.814     9.878     0.200
     1.768    11.868     0.200
     2.176    12.439     0.200
     2.391    13.828     0.200
     2.520    14.047     0.200
     2.626    12.805     0.200
     2.626    12.219     0.200
     2.657    13.223     0.200
     2.840    14.766     0.200
     3.028    14.394     0.200
     3.028    14.988     0.200
     3.500    15.879     0.200
     4.137    14.825     0.200
     4.137    15.309     0.200
     4.169    15.547     0.200
     4.795    16.136     0.200
     4.864    16.617     0.200
     4.933    16.818     0.200
     5.111    16.645     0.200
     5.111    17.090     0.200
     5.141    16.894     0.200
     5.141    17.746     0.200
     5.180    17.934     0.200
     5.180    17.785     0.200
     5.166    18.047     0.200
     5.234    17.700     0.200
     5.373    18.856     0.200
     5.401    17.546     0.200
     5.401    17.983     0.200
     5.430    17.414     0.200
     5.955    18.781     0.200
     5.989    18.986     0.200
     5.984    19.232     0.200
     6.188    18.800     0.200
     6.441    20.261     0.200
     6.622    20.104     0.200
     6.668    19.894     0.200
     6.680    20.567     0.200
     6.806    20.764     0.200
     7.026    21.831     0.200
     7.095    21.512     0.200
     7.124    21.281     0.200
     2.085    12.301     0.200
     2.188    10.628     0.200
     2.174    12.087     0.200
     2.580    13.492     0.200
     2.575    13.371     0.200
     2.575    13.792     0.200
     2.595    14.290     0.200
     2.564    12.025     0.200
     2.644    12.998     0.200
     2.753    13.657     0.200
     2.753    13.845     0.200
     2.760    14.274     0.200
     2.781    13.336     0.200
     2.873    12.536     0.200
     2.873    12.739     0.200
     3.069    14.356     0.200
     3.100    15.002     0.200
     3.095    14.501     0.200
     3.095    14.649     0.200
     3.178    14.963     0.200
     3.383    14.855     0.200
     3.383    15.519     0.200
     3.383    15.925     0.200
     3.435    15.688     0.200
     3.405    15.120     0.200
     3.497    13.655     0.200
     3.935    16.785     0.200
     4.012    16.793     0.200
     4.113    16.106     0.200
     4.113    16.660     0.200
     4.147    16.391     0.200
     4.147    16.250     0.200
     4.147    16.922     0.200
     4.154    17.008     0.200
     4.245    15.661     0.200
     4.323    17.721     0.200
     4.423    16.732     0.200
     4.423    16.521     0.200
     4.459    17.075     0.200
     4.459    16.676     0.200
     4.557    17.688     0.200
     4.562    17.141     0.200
     4.601    18.413     0.200
     4.630    16.715     0.200
     4.798    18.176     0.200
     4.898    16.021     0.200
     4.949    17.812     0.200
     5.236    20.059     0.200
     5.217    19.156     0.200
     5.308    18.328     0.200
     5.417    20.931     0.200
     5.442    17.559     0.200
     5.490    17.684     0.200
     5.490    16.997     0.200
     5.504    17.732     0.200
     5.504    17.920     0.200
     5.507    18.420     0.200
     5.520    19.118     0.200
     5.520    19.970     0.200
     5.510    19.571     0.200
     5.544    17.581     0.200
     5.544    17.941     0.200
     5.561    17.859     0.200
     5.599    18.467     0.200
     5.599    17.725     0.200
     5.599    18.702     0.200
     5.737    19.172     0.200
     5.737    19.750     0.200
     5.858    18.557     0.200
     5.858    18.994     0.200
     5.858    19.244     0.200
     5.874    18.521     0.200
     5.874    18.693     0.200
     5.899    18.578     0.200
     5.899    18.187     0.200
     5.899    18.390     0.200
     5.880    20.252     0.200
     5.977    18.843     0.200
     5.991    20.756     0.200
     6.122    19.110     0.200
     6.126    19.068     0.200
     6.126    18.849     0.200
     6.126    19.349     0.200
     6.138    19.481     0.200
     6.147    19.737     0.200
     6.287    19.904     0.200
     6.299    21.459     0.200
     6.314    20.889     0.200
     6.326    21.148     0.200
     6.375    22.387     0.200
     6.506    19.897     0.200
     6.634    20.593     0.200
     6.634    20.788     0.200
     6.646    21.212     0.200
     6.758    20.912     0.200
     6.784    20.288     0.200
     6.784    19.952     0.200
     6.784    20.796     0.200
     6.784    20.413     0.200
     6.786    21.576     0.200
     6.784    22.404     0.200
     6.890    20.904     0.200
     6.975    22.167     0.200
     7.021    21.531     0.200
     7.021    22.632     0.200
     7.022    21.188     0.200
     7.125    22.630     0.200
     7.185    21.277     0.200
     7.239    21.915     0.200
     7.261    22.085     0.200
     7.280    21.608     0.200
     7.420    24.201     0.200
     7.462    21.989     0.200
     7.516    22.228     0.200
     7.521    23.700     0.200
     7.532    25.075     0.200
     7.529    22.601     0.200
     7.636    22.583     0.200
     7.646    22.692     0.200
     7.692    23.917     0.200
     7.788    23.045     0.200
     7.814    24.314     0.200
     7.970    23.863     0.200
     8.156    23.604     0.200
     8.187    23.618     0.200
     8.187    24.118     0.200
     8.187    24.313     0.200
     8.245    25.348     0.200
     8.521    26.531     0.200
     8.577    24.410     0.200
     8.795    24.789     0.200
     9.018    26.532     0.200
     9.056    25.663     0.200
     9.107    27.460     0.200
     9.168    26.076     0.200
     9.172    25.905     0.200
     9.362    26.078     0.200
     9.395    27.034     0.200
     9.434    26.978     0.200
     9.494    27.152     0.200
     9.543    26.620     0.200
     9.844    27.280     0.200
    10.189    28.763     0.200
    10.569    31.093     0.200
    10.674    29.859     0.200
    10.688    30.267     0.200
    10.688    29.619     0.200
    10.922    30.236     0.200
    10.922    30.580     0.200
    11.659    31.709     0.200
    11.659    32.904     0.200
    12.954    34.100     0.200
    12.954    33.607     0.200
    13.066    31.740     0.200
    13.066    31.240     0.200
    16.006    39.151     0.200
    17.164    41.153     0.200
    18.699    41.975     0.200
    18.716    41.413     0.200
    18.952    41.547     0.200
    19.034    41.750     0.200
    19.549    41.553     0.200
    19.965    41.357     0.200
     1.731    11.410     0.200
     1.953    12.499     0.200
     2.093    12.975     0.200
     2.271    10.752     0.200
     2.610    13.738     0.200
     2.640    13.914     0.200
     2.655    13.678     0.200
     2.619    12.355     0.200
     2.704    13.848     0.200
     2.675    14.451     0.200
     2.725    12.242     0.200
     2.704    14.096     0.200
     2.932    14.521     0.200
     2.947    13.412     0.200
     3.011    14.984     0.200
     3.033    15.231     0.200
     3.211    14.352     0.200
     3.211    14.508     0.200
     3.418    14.538     0.200
     3.418    14.945     0.200
     3.971    16.248     0.200
     4.038    15.967     0.200
     4.165    15.471     0.200
     4.306    15.704     0.200
     4.306    16.689     0.200
     4.456    15.835     0.200
     4.456    16.015     0.200
     4.514    16.551     0.200
     4.514    16.364     0.200
     4.599    17.591     0.200
     4.703    16.490     0.200
     4.703    15.865     0.200
     5.301    20.015     0.200
     5.514    17.138     0.200
     5.514    17.263     0.200
     5.517    16.807     0.200
     5.549    18.177     0.200
     5.549    18.052     0.200
     5.558    17.189     0.200
     5.571    17.939     0.200
     5.571    17.775     0.200
     5.578    17.239     0.200
     5.677    18.808     0.200
     5.813    18.409     0.200
     5.859    18.128     0.200
     5.859    18.027     0.200
     5.887    18.660     0.200
     5.904    17.933     0.200
     5.904    17.831     0.200
     6.003    17.960     0.200
     6.128    18.753     0.200
     6.139    18.326     0.200
     6.139    18.576     0.200
     6.155    18.600     0.200
     6.448    21.924     0.200
     6.448    21.760     0.200
     6.535    18.987     0.200
     6.535    19.315     0.200
     6.653    19.635     0.200
     6.653    19.862     0.200
     6.775    19.707     0.200
     6.809    20.040     0.200
     6.809    20.173     0.200
     7.077    20.363     0.200
     7.090    20.730     0.200
     7.205    20.640     0.200
     7.267    21.056     0.200
     7.528    21.950     0.200
     7.596    21.462     0.200
     7.660    21.738     0.200
     7.676    21.721     0.200
     7.806    22.400     0.200
     7.896    24.968     0.200
     8.179    23.077     0.200
     8.218    23.255     0.200
     8.606    24.156     0.200
     8.832    24.580     0.200
     9.088    24.837     0.200
     9.189    27.741     0.200
     9.200    25.135     0.200
     9.401    25.490     0.200
     9.876    26.626     0.200
    11.739    30.561     0.200
     1.972    12.191     0.200
     2.079    12.852     0.200
     2.291    10.435     0.200
     2.589    14.359     0.200
     2.641    14.151     0.200
     2.655    13.590     0.200
     2.668    13.627     0.200
     2.668    14.406     0.200
     2.650    14.770     0.200
     2.983    15.065     0.200
     4.307    14.091     0.200
     4.461    16.554     0.200
     4.512    17.360     0.200
     5.502    16.193     0.200
     5.502    16.415     0.200
     5.492    17.152     0.200
     5.492    17.508     0.200
     5.540    18.019     0.200
     5.537    17.463     0.200
     5.566    18.142     0.200
     5.558    17.232     0.200
     5.558    17.367     0.200
     5.824    16.689     0.200
     5.865    18.477     0.200
     5.865    18.955     0.200
     5.986    18.542     0.200
     6.104    18.698     0.200
     6.118    19.483     0.200
     6.520    18.792     0.200
     6.520    19.051     0.200
     6.634    19.300     0.200
     6.634    19.932     0.200
     6.754    20.602     0.200
     6.792    19.732     0.200
     7.081    20.817     0.200
     7.187    20.967     0.200
     7.252    21.534     0.200
     7.642    22.102     0.200
     7.661    22.335     0.200
     1.551    10.409     0.200
     1.607     9.405     0.200
     1.743    11.421     0.200
     1.712     9.032     0.200
     1.713     9.923     0.200
     2.610    12.768     0.200
     3.475    11.765     0.200
     3.528    12.012     0.200
     3.528    11.825     0.200
     3.563    12.294     0.200
     3.563    12.044     0.200
     3.462    15.728     0.200
     3.579    11.987     0.200
     3.579    12.331     0.200
     3.576    13.834     0.200
     3.576    14.451     0.200
     3.809    13.056     0.200
     3.809    13.407     0.200
     3.820    12.761     0.200
     3.820    14.011     0.200
     3.852    12.730     0.200
     3.852    12.847     0.200
     3.860    12.683     0.200
     3.860    12.917     0.200
     4.001    14.243     0.200
     4.001    14.517     0.200
     4.045    13.285     0.200
     4.083    13.870     0.200
     4.103    13.067     0.200
     4.103    13.184     0.200
     4.643    14.423     0.200
     4.643    15.345     0.200
     4.750    15.050     0.200
     4.811    15.928     0.200
     4.834    15.678     0.200
     4.834    16.139     0.200
     4.834    16.545     0.200
     5.201    15.730     0.200
     5.325    16.242     0.200
     5.673    16.887     0.200
     5.740    17.465     0.200
     5.795    17.146     0.200
     6.965    20.706     0.200
     7.284    20.452     0.200
     1.360     9.895     0.200
     2.462    14.357     0.200
     3.500    16.591     0.200
     5.271    17.893     0.200
     5.352    18.156     0.200
     5.511    18.811     0.200
     5.588    19.408     0.200
     5.661    19.144     0.200
     5.909    19.189     0.200
     5.909    20.740     0.200
     5.924    19.297     0.200
     6.488    21.268     0.200
     6.576    21.807     0.200
     7.049    21.675     0.200
     7.205    22.705     0.200
     7.620    23.458     0.200
     8.851    26.004     0.200
     2.616    12.403     0.200
     2.616    11.222     0.200
     3.463    12.352     0.200
     3.517    12.583     0.200
     3.517    12.100     0.200
     3.467    15.784     0.200
     3.552    12.236     0.200
     3.482    16.163     0.200
     3.569    12.477     0.200
     3.808    13.893     0.200
     3.802    13.908     0.200
     3.840    13.359     0.200
     3.995    14.457     0.200
     4.035    13.906     0.200
     4.092    13.454     0.200
     4.092    13.573     0.200
     4.144    16.765     0.200
     4.739    15.342     0.200
     4.806    15.617     0.200
     5.190    16.460     0.200
     5.315    17.311     0.200
     5.356    16.168     0.200
     5.663    17.453     0.200
     1.667    11.250     0.200
     1.840    12.542     0.200
     2.095    11.231     0.200
     2.112    11.242     0.200
     2.226    13.086     0.200
     2.193    12.618     0.200
     2.373    11.713     0.200
     2.403    13.565     0.200
     2.809    14.136     0.200
     3.279    14.560     0.200
     3.399    13.194     0.200
     3.478    14.524     0.200
     3.615    14.585     0.200
     4.428    15.625     0.200
     4.428    15.855     0.200
     4.443    15.553     0.200
     4.470    14.811     0.200
     4.490    15.184     0.200
     4.490    15.945     0.200
     4.505    16.358     0.200
     4.534    16.649     0.200
     4.534    15.481     0.200
     4.617    17.100     0.200
     4.617    16.483     0.200
     4.790    16.046     0.200
     4.799    16.052     0.200
     4.799    17.021     0.200
     4.827    15.693     0.200
     4.827    16.521     0.200
     4.925    16.522     0.200
     4.925    16.932     0.200
     5.048    17.308     0.200
     5.051    15.975     0.200
     5.051    17.026     0.200
     5.345    18.145     0.200
     5.566    17.048     0.200
     5.566    17.740     0.200
     5.686    18.069     0.200
     5.727    17.549     0.200
     6.003    19.318     0.200
     6.087    18.678     0.200
     6.118    19.090     0.200
     6.194    19.435     0.200
     6.568    20.136     0.200
     6.576    19.968     0.200
     6.605    20.055     0.200
     7.784    22.598     0.200
     1.481     8.129     0.200
     1.657     9.807     0.200
     1.657     8.889     0.200
     1.709    10.038     0.200
     2.228    11.240     0.200
     2.567    11.755     0.200
     2.652    10.557     0.200
     3.157    12.289     0.200
     3.482    11.802     0.200
     3.539    11.973     0.200
     3.539    11.813     0.200
     3.577    12.195     0.200
     3.603    12.092     0.200
     3.818    14.083     0.200
     3.818    13.029     0.200
     3.846    13.584     0.200
     3.846    13.768     0.200
     3.861    12.816     0.200
     3.860    12.429     0.200
     3.860    12.671     0.200
     4.044    13.933     0.200
     4.044    13.757     0.200
     4.067    13.099     0.200
     4.085    13.186     0.200
     4.112    13.023     0.200
     4.112    13.152     0.200
     4.762    14.890     0.200
     5.216    15.863     0.200
     5.347    16.669     0.200
     5.691    16.843     0.200
     1.621    10.332     0.200
     1.563     9.673     0.200
     1.663    10.061     0.200
     1.825    11.820     0.200
     2.166    10.508     0.200
     2.592    11.553     0.200
     2.592    11.385     0.200
     2.657    12.889     0.200
     2.857    12.679     0.200
     3.526    11.990     0.200
     3.526    12.213     0.200
     3.572    12.352     0.200
     3.572    12.567     0.200
     3.593    12.247     0.200
     3.600    12.475     0.200
     3.511    16.535     0.200
     3.788    13.328     0.200
     3.891    13.181     0.200
     3.899    13.374     0.200
     3.899    13.667     0.200
     3.959    14.285     0.200
     4.053    14.808     0.200
     4.064    13.522     0.200
     4.145    14.011     0.200
     4.151    13.628     0.200
     4.679    14.752     0.200
     4.758    15.489     0.200
     4.792    15.284     0.200
     5.234    15.920     0.200
     5.341    17.357     0.200
     5.344    17.024     0.200
     5.540    17.246     0.200
     5.701    17.630     0.200
     5.755    18.413     0.200
     5.787    17.704     0.200
     6.162    17.841     0.200
     6.968    20.686     0.200
     1.634    10.960     0.200
     1.588    10.742     0.200
     1.692     9.857     0.200
     1.692    10.045     0.200
     1.651    10.075     0.200
     1.765    11.930     0.200
     1.757    12.236     0.200
     2.169    10.708     0.200
     2.625    13.180     0.200
     2.648    11.639     0.200
     2.695    12.204     0.200
     2.669    14.920     0.200
     2.778    12.658     0.200
     2.815    13.860     0.200
     2.867    13.683     0.200
     3.106    12.520     0.200
     3.106    13.370     0.200
     3.133    14.940     0.200
     3.431    12.843     0.200
     3.431    13.038     0.200
     3.487    13.251     0.200
     3.469    12.576     0.200
     3.523    13.473     0.200
     3.476    16.523     0.200
     3.501    14.963     0.200
     3.546    13.210     0.200
     3.546    13.417     0.200
     3.500    15.279     0.200
     3.585    14.320     0.200
     3.585    15.150     0.200
     3.774    13.391     0.200
     3.774    13.764     0.200
     3.774    13.629     0.200
     3.787    13.809     0.200
     3.787    14.143     0.200
     3.809    13.968     0.200
     3.814    13.571     0.200
     3.986    14.893     0.200
     3.986    15.167     0.200
     4.010    14.325     0.200
     4.010    14.466     0.200
     4.038    14.215     0.200
     4.061    14.182     0.200
     4.061    14.371     0.200
     4.096    14.608     0.200
     4.153    15.286     0.200
     4.162    16.508     0.200
     4.345    17.034     0.200
     4.604    15.630     0.200
     4.604    15.848     0.200
     4.709    16.197     0.200
     4.797    15.789     0.200
     4.797    16.203     0.200
     4.797    15.968     0.200
     4.800    16.974     0.200
     5.161    16.979     0.200
     5.290    17.308     0.200
     5.366    17.523     0.200
     5.446    17.295     0.200
     5.446    17.816     0.200
     5.515    18.732     0.200
     5.563    18.566     0.200
     5.635    17.927     0.200
     5.705    18.575     0.200
     5.750    18.551     0.200
     5.768    18.751     0.200
     6.259    19.585     0.200
     6.332    20.297     0.200
     6.536    21.181     0.200
     6.632    20.676     0.200
     6.934    21.095     0.200
     7.141    21.297     0.200
     7.151    20.798     0.200
     7.250    21.625     0.200
     7.777    22.146     0.200
     7.911    23.473     0.200
     1.382     8.544     0.200
     1.612    10.901     0.200
     1.848    11.909     0.200
     2.118    12.999     0.200
     2.118    11.206     0.200
     2.360    11.428     0.200
     2.277    11.486     0.200
     2.488    12.547     0.200
     3.104    13.549     0.200
     3.576    16.251     0.200
     4.469    15.654     0.200
     4.726    14.564     0.200
     4.709    15.119     0.200
     5.238    15.632     0.200
     5.238    16.390     0.200
     5.322    16.369     0.200
     5.322    16.892     0.200
     5.382    16.361     0.200
     5.382    17.389     0.200
     5.445    16.901     0.200
     5.445    17.218     0.200
     5.469    15.766     0.200
     5.469    17.040     0.200
     5.548    17.424     0.200
     5.628    16.746     0.200
     5.628    17.641     0.200
     5.663    17.058     0.200
     5.663    16.870     0.200
     5.801    17.576     0.200
     5.801    19.967     0.200
     5.876    17.986     0.200
     5.903    17.379     0.200
     5.903    18.058     0.200
     6.545    19.840     0.200
     6.557    20.035     0.200
     6.679    18.678     0.200
     6.679    20.057     0.200
     7.029    16.623     0.200
     7.020    20.274     0.200
     7.184    21.097     0.200
     8.836    24.548     0.200
     1.700     9.204     0.200
     2.498    10.736     0.200
     3.489    11.462     0.200
     3.535    11.719     0.200
     3.562    11.657     0.200
     4.027    13.627     0.200
     4.108    13.881     0.200
     1.286     8.334     0.200
     1.907    10.331     0.200
     2.044    10.192     0.200
     2.234    11.645     0.200
     2.884    11.306     0.200
     2.894    12.757     0.200
     2.990    11.744     0.200
     2.990    11.905     0.200
     2.956    13.791     0.200
     3.005    12.201     0.200
     3.005    12.505     0.200
     3.274    12.015     0.200
     3.667    13.095     0.200
     3.667    13.392     0.200
     3.613    14.436     0.200
     3.695    13.578     0.200
     3.695    15.289     0.200
     3.854    12.828     0.200
     3.933    14.307     0.200
     3.933    12.874     0.200
     3.991    13.298     0.200
     4.069    13.538     0.200
     4.121    14.131     0.200
     4.121    14.244     0.200
     4.187    13.738     0.200
     4.187    14.711     0.200
     4.357    14.150     0.200
     4.357    15.232     0.200
     4.420    15.491     0.200
     4.492    13.982     0.200
     4.519    14.621     0.200
     4.567    14.995     0.200
     4.567    15.127     0.200
     4.694    18.170     0.200
     5.070    15.625     0.200
     5.070    15.863     0.200
     5.085    16.434     0.200
     5.085    16.325     0.200
     5.157    16.536     0.200
     5.291    17.443     0.200
     5.291    17.260     0.200
     5.631    16.600     0.200
     5.801    17.754     0.200
     5.861    17.358     0.200
     5.861    17.921     0.200
     5.946    18.176     0.200
     6.118    18.140     0.200
     6.145    17.910     0.200
     6.146    18.338     0.200
     6.204    18.647     0.200
     6.217    18.466     0.200
     6.914    20.196     0.200
     7.468    20.924     0.200
     7.659    21.682     0.200
     7.766    21.637     0.200
     8.083    22.808     0.200
     8.219    23.072     0.200
     1.535    10.286     0.200
     1.720    11.125     0.200
     1.927    11.108     0.200
     2.643    13.624     0.200
     4.864    15.856     0.200
     4.879    16.139     0.200
     5.217    18.238     0.200
     5.234    18.074     0.200
     5.931    19.049     0.200
     6.048    20.252     0.200
     6.478    20.692     0.200
     1.240     8.260     0.200
     1.410     8.270     0.200
     1.275     9.488     0.200
     1.598     8.915     0.200
     1.667     9.132     0.200
     1.449     9.489     0.200
     1.450     9.547     0.200
     1.518     9.542     0.200
     1.518     9.292     0.200
     1.928    10.624     0.200
     1.933    10.292     0.200
     1.940     9.988     0.200
     1.940    10.209     0.200
     1.988     9.570     0.200
     2.175    11.215     0.200
     2.255     8.213     0.200
     2.255     8.580     0.200
     2.168    10.667     0.200
     2.272    10.589     0.200
     2.272    10.876     0.200
     2.272    10.726     0.200
     2.376    10.423     0.200
     2.376    10.792     0.200
     2.272     9.624     0.200
     2.654    10.807     0.200
     2.654    10.703     0.200
     2.599    13.914     0.200
     2.777    10.360     0.200
     2.880    11.009     0.200
     2.880    10.862     0.200
     2.862    11.672     0.200
     3.131    11.650     0.200
     3.131    11.107     0.200
     2.937    13.605     0.200
     3.089    11.456     0.200
     3.089    12.281     0.200
     3.145    13.679     0.200
     3.146    13.724     0.200
     3.481    13.686     0.200
     3.481    13.249     0.200
     3.716    11.662     0.200
     3.716    11.926     0.200
     3.551    14.516     0.200
     3.790    11.882     0.200
     3.775    12.349     0.200
     3.775    12.819     0.200
     3.809    12.329     0.200
     3.809    12.019     0.200
     3.809    11.696     0.200
     3.810    11.899     0.200
     3.810    12.145     0.200
     3.713    15.323     0.200
     3.810    16.121     0.200
     3.863    13.230     0.200
     3.790    14.977     0.200
     3.889    14.351     0.200
     3.889    15.245     0.200
     3.940    14.942     0.200
     4.146    12.790     0.200
     4.204    12.902     0.200
     4.204    13.181     0.200
     4.217    14.146     0.200
     4.217    12.533     0.200
     4.217    14.664     0.200
     4.217    13.433     0.200
     4.217    14.514     0.200
     4.230    12.704     0.200
     4.387    13.736     0.200
     4.398    13.173     0.200
     4.398    13.064     0.200
     4.398    13.314     0.200
     4.215    15.907     0.200
     4.439    13.297     0.200
     4.646    13.952     0.200
     4.606    15.164     0.200
     4.588    15.372     0.200
     4.588    15.187     0.200
     4.588    16.651     0.200
     4.732    14.166     0.200
     4.732    14.482     0.200
     4.641    16.969     0.200
     4.700    15.307     0.200
     4.876    14.410     0.200
     4.876    14.591     0.200
     4.763    16.242     0.200
     5.011    14.719     0.200
     5.013    15.221     0.200
     5.013    15.952     0.200
     5.013    15.821     0.200
     5.013    15.329     0.200
     5.129    18.406     0.200
     5.129    18.242     0.200
     5.250    15.731     0.200
     5.250    16.031     0.200
     5.422    15.976     0.200
     5.415    15.722     0.200
     5.415    16.498     0.200
     5.415    16.347     0.200
     5.416    16.324     0.200
     5.416    16.591     0.200
     5.465    16.278     0.200
     5.789    16.705     0.200
     5.789    16.842     0.200
     5.812    16.930     0.200
     5.866    16.755     0.200
     5.873    17.049     0.200
     5.832    18.275     0.200
     6.031    17.696     0.200
     6.143    18.902     0.200
     6.143    19.630     0.200
     6.167    19.285     0.200
     6.167    19.115     0.200
     6.386    18.144     0.200
     6.415    18.230     0.200
     6.415    17.861     0.200
     6.803    18.628     0.200
     7.034    19.752     0.200
     7.285    19.925     0.200
     7.399    20.239     0.200
     7.397    20.190     0.200
     7.612    20.654     0.200
     7.745    20.858     0.200
     7.771    20.721     0.200
     7.812    23.291     0.200
     8.072    21.300     0.200
     7.956    22.081     0.200
     8.269    24.374     0.200
     9.375    26.504     0.200
     9.436    26.411     0.200
     9.606    26.631     0.200
    10.097    25.577     0.200
    10.196    26.921     0.200
    10.310    27.299     0.200
    11.824    31.198     0.200
    12.592    32.461     0.200
    14.708    37.367     0.200
    14.890    37.660     0.200
    15.973    38.987     0.200
    16.123    39.140     0.200
    16.772    37.762     0.200
    16.861    39.414     0.200
    17.828    38.407     0.200
    17.964    39.005     0.200
    18.067    39.905     0.200
    18.067    40.066     0.200
    18.217    39.288     0.200
    18.449    40.660     0.200
    18.644    41.183     0.200
    18.681    40.628     0.200
    18.797    40.033     0.200
    18.797    39.834     0.200
    19.066    40.480     0.200
    19.323    39.703     0.200
    19.450    39.257     0.200
    19.854    39.793     0.200
    20.396    39.073     0.200
    20.698    39.986     0.200
    20.927    39.342     0.200
     1.629    10.751     0.200
     1.672     9.232     0.200
     1.960    10.442     0.200
     2.231     9.226     0.200
     2.231     8.828     0.200
     2.236    10.533     0.200
     2.746    11.113     0.200
     2.746    10.335     0.200
     2.894    11.623     0.200
     2.852    12.409     0.200
     3.096    14.690     0.200
     3.055    12.950     0.200
     3.055    11.204     0.200
     3.115    13.443     0.200
     3.705    12.566     0.200
     3.744    14.961     0.200
     3.790    12.151     0.200
     3.790    12.432     0.200
     3.807    12.353     0.200
     3.805    12.460     0.200
     3.805    13.406     0.200
     3.756    14.073     0.200
     3.756    14.541     0.200
     3.838    14.329     0.200
     3.838    13.688     0.200
     3.922    16.815     0.200
     3.975    14.194     0.200
     4.144    14.101     0.200
     4.222    15.028     0.200
     4.222    15.582     0.200
     4.194    14.023     0.200
     4.194    14.531     0.200
     4.383    14.649     0.200
     4.396    13.462     0.200
     4.396    14.873     0.200
     4.441    14.990     0.200
     4.644    15.061     0.200
     4.721    15.125     0.200
     4.870    15.670     0.200
     5.007    15.656     0.200
     5.004    16.012     0.200
     5.004    16.473     0.200
     5.415    16.493     0.200
     5.454    16.767     0.200
     5.858    17.242     0.200
     5.861    17.527     0.200
     7.384    20.985     0.200
     2.138    10.416     0.200
     2.879    12.012     0.200
     3.728    15.447     0.200
     3.806    11.563     0.200
     3.824    11.475     0.200
     3.962    14.385     0.200
     4.213    13.458     0.200
     5.876    16.580     0.200
     1.628     7.913     0.200
     1.908    10.708     0.200
     1.915    10.989     0.200
     1.958     9.504     0.200
     2.139    10.569     0.200
     2.255     8.293     0.200
     2.255     8.541     0.200
     2.298    10.046     0.200
     2.664    10.284     0.200
     2.767    10.595     0.200
     2.767     9.810     0.200
     2.875    11.753     0.200
     3.074    12.255     0.200
     3.074    12.428     0.200
     3.146    10.488     0.200
     3.729    11.797     0.200
     3.780    13.440     0.200
     3.799    13.867     0.200
     3.811    11.825     0.200
     3.827    12.231     0.200
     3.827    12.090     0.200
     3.829    11.676     0.200
     3.862    12.577     0.200
     4.218    12.844     0.200
     4.218    13.173     0.200
     4.417    14.447     0.200
     4.461    13.233     0.200
     4.602    15.010     0.200
     4.666    14.666     0.200
     4.893    14.799     0.200
     5.027    15.726     0.200
     5.115    17.668     0.200
     5.249    14.739     0.200
     5.438    16.291     0.200
     5.477    15.865     0.200
     5.881    16.905     0.200
     5.885    16.622     0.200
     6.047    17.302     0.200
     6.426    18.061     0.200
     6.815    18.832     0.200
     7.043    19.573     0.200
     7.296    19.422     0.200
     1.754    12.020     0.200
     1.900    12.662     0.200
     1.955    12.479     0.200
     2.448    11.928     0.200
     2.504    14.293     0.200
     2.459    12.691     0.200
     2.589    14.750     0.200
     2.698    12.917     0.200
     2.778    13.173     0.200
     2.900    13.794     0.200
     2.885    14.945     0.200
     3.071    14.137     0.200
     3.162    14.789     0.200
     4.304    16.098     0.200
     4.401    16.120     0.200
     5.389    17.188     0.200
     5.443    17.377     0.200
     5.443    17.721     0.200
     5.473    17.699     0.200
     5.526    17.483     0.200
     5.581    18.551     0.200
     5.760    17.890     0.200
     5.760    18.812     0.200
     5.767    19.659     0.200
     5.924    19.164     0.200
     5.988    19.408     0.200
     6.019    18.575     0.200
     6.019    20.121     0.200
     6.264    20.054     0.200
     6.724    21.310     0.200
     6.961    20.445     0.200
     7.107    21.630     0.200
     7.196    21.557     0.200
     7.571    23.220     0.200
     9.139    25.665     0.200
     1.945     9.714     0.200
     2.755     9.724     0.200
     3.774    12.245     0.200
     3.829    12.171     0.200
     3.854    11.567     0.200
     4.216    14.163     0.200
     1.681    10.263     0.200
     1.627    10.019     0.200
     1.734    10.348     0.200
     2.431    12.162     0.200
     2.602    12.491     0.200
     2.816    14.166     0.200
     3.125    13.010     0.200
     3.125    13.541     0.200
     3.455    12.157     0.200
     3.455    12.696     0.200
     3.511    12.997     0.200
     3.548    12.612     0.200
     3.548    13.237     0.200
     3.517    14.268     0.200
     3.452    16.196     0.200
     3.475    14.687     0.200
     3.528    14.220     0.200
     3.563    14.555     0.200
     3.811    14.164     0.200
     3.811    15.609     0.200
     3.833    13.617     0.200
     3.833    13.883     0.200
     3.837    13.548     0.200
     4.009    14.373     0.200
     4.009    13.951     0.200
     4.035    13.863     0.200
     4.035    14.035     0.200
     4.061    14.914     0.200
     4.085    14.097     0.200
     4.148    16.189     0.200
     4.592    15.836     0.200
     4.592    15.438     0.200
     4.628    15.356     0.200
     4.733    15.777     0.200
     4.822    14.932     0.200
     4.823    17.774     0.200
     5.186    16.775     0.200
     5.315    17.369     0.200
     5.660    17.452     0.200
     5.730    18.370     0.200
     1.742    10.270     0.200
     2.595    12.116     0.200
     3.543    13.317     0.200
     3.570    12.560     0.200
     3.815    14.140     0.200
     4.016    13.631     0.200
     4.591    15.881     0.200
     4.831    16.444     0.200
     2.426    11.824     0.200
     2.458    11.566     0.200
     2.459    12.030     0.200
     2.474    12.366     0.200
     3.207    14.104     0.200
     4.368    14.685     0.200
     4.910    15.344     0.200
     5.002    16.039     0.200
     6.054    14.918     0.200
     1.646    10.654     0.200
     1.808    11.241     0.200
     3.012    15.072     0.200
     3.578    15.690     0.200
     5.602    17.829     0.200
     5.700    18.024     0.200
     5.784    19.981     0.200
     5.997    18.955     0.200
     6.120    19.671     0.200
     6.322    19.938     0.200
     6.475    19.571     0.200
     7.086    21.900     0.200
     7.381    18.061     0.200
     7.407    21.618     0.200
     7.603    22.501     0.200
     8.020    23.498     0.200
     9.275    26.455     0.200
     9.570    26.721     0.200
     1.586    10.906     0.200
     2.434    13.006     0.200
     2.602    12.911     0.200
     2.585    14.573     0.200
     3.012    12.415     0.200
     3.012    12.556     0.200
     2.991    14.894     0.200
     3.119    14.545     0.200
     3.092    14.070     0.200
     3.139    12.959     0.200
     3.195    13.347     0.200
     3.195    13.035     0.200
     3.298    14.789     0.200
     3.298    15.195     0.200
     3.449    14.558     0.200
     3.634    15.565     0.200
     3.756    16.947     0.200
     4.045    17.542     0.200
     4.163    17.782     0.200
     4.542    17.815     0.200
     4.542    17.456     0.200
     4.605    17.139     0.200
     4.605    16.857     0.200
     4.635    16.822     0.200
     4.736    17.275     0.200
     4.736    17.103     0.200
     4.918    16.902     0.200
     4.918    16.761     0.200
     4.941    17.381     0.200
     4.943    16.567     0.200
     4.943    17.481     0.200
     5.143    18.281     0.200
     5.234    18.133     0.200
     5.282    17.638     0.200
     5.282    17.990     0.200
     5.274    19.927     0.200
     5.405    18.469     0.200
     5.407    17.878     0.200
     5.407    18.151     0.200
     5.491    18.733     0.200
     5.532    18.088     0.200
     5.532    18.284     0.200
     5.609    18.928     0.200
     5.726    19.233     0.200
     5.781    19.103     0.200
     5.888    19.978     0.200
     5.961    19.299     0.200
     6.050    20.017     0.200
     6.050    20.322     0.200
     6.116    19.939     0.200
     6.457    20.507     0.200
     6.492    20.605     0.200
     6.655    21.341     0.200
     6.852    21.222     0.200
     6.906    21.689     0.200
     7.111    22.571     0.200
     7.776    23.061     0.200
     1.853    11.244     0.200
     1.973    10.328     0.200
     2.071    13.071     0.200
     2.276    12.062     0.200
     2.280    12.485     0.200
     2.776    14.310     0.200
     3.088    14.050     0.200
     3.093    15.640     0.200
     3.188    14.569     0.200
     3.338    15.864     0.200
     3.338    16.067     0.200
     3.502    13.501     0.200
     3.503    14.944     0.200
     3.664    15.429     0.200
     4.311    16.993     0.200
     4.522    18.492     0.200
     4.579    16.146     0.200
     4.633    16.610     0.200
     4.633    16.247     0.200
     4.647    15.720     0.200
     4.689    17.461     0.200
     4.965    16.434     0.200
     5.006    17.610     0.200
     5.065    16.814     0.200
     5.394    18.925     0.200
     5.465    17.954     0.200
     5.597    17.329     0.200
     5.597    17.659     0.200
     5.871    18.800     0.200
     5.871    19.106     0.200
     6.071    19.558     0.200
     6.181    19.374     0.200
     6.271    19.503     0.200
     6.329    19.439     0.200
     6.674    19.833     0.200
     6.722    20.123     0.200
     1.285    10.527     0.200
     1.477    10.931     0.200
     1.535     9.656     0.200
     1.638     9.802     0.200
     1.761     9.294     0.200
     1.761     9.618     0.200
     2.430    10.365     0.200
     2.595    12.152     0.200
     2.708     9.998     0.200
     3.458    13.696     0.200
     3.469    12.720     0.200
     3.548    11.220     0.200
     3.548    11.599     0.200
     3.599    11.761     0.200
     3.630    11.620     0.200
     3.630    11.949     0.200
     3.634    11.729     0.200
     3.448    14.647     0.200
     3.559    12.636     0.200
     3.573    15.200     0.200
     3.842    13.200     0.200
     3.842    12.516     0.200
     3.924    13.097     0.200
     3.939    12.649     0.200
     4.019    13.638     0.200
     4.019    13.286     0.200
     4.103    12.666     0.200
     4.103    13.080     0.200
     4.176    13.076     0.200
     4.176    13.197     0.200
     4.204    13.912     0.200
     4.098    13.867     0.200
     4.422    13.426     0.200
     4.380    14.512     0.200
     4.656    14.706     0.200
     4.656    14.527     0.200
     4.821    15.620     0.200
     4.894    16.280     0.200
     4.894    15.913     0.200
     5.266    15.323     0.200
     5.381    16.237     0.200
     5.398    15.823     0.200
     5.403    17.190     0.200
     5.736    16.650     0.200
     5.795    17.354     0.200
     5.836    16.603     0.200
     1.368     9.844     0.200
     1.332     9.843     0.200
     2.582    14.187     0.200
     2.615    11.620     0.200
     2.615    12.401     0.200
     2.720    12.237     0.200
     2.750    12.175     0.200
     2.750    13.448     0.200
     3.091    14.311     0.200
     3.093    13.139     0.200
     3.347    15.381     0.200
     3.713    16.464     0.200
     4.207    16.860     0.200
     4.663    16.455     0.200
     4.589    17.124     0.200
     4.682    16.467     0.200
     5.370    18.718     0.200
     1.271     7.825     0.200
     1.849    10.530     0.200
     5.587    17.368     0.200
     5.683    17.665     0.200
     5.710    17.617     0.200
     5.800    18.217     0.200
     5.985    18.426     0.200
     6.045    19.035     0.200
     6.408    19.331     0.200
     6.443    18.963     0.200
     7.329    18.645     0.200
     7.419    21.549     0.200
     1.595    11.074     0.200
     1.747    12.426     0.200
     1.860    12.868     0.200
     2.665    14.972     0.200
     2.800    15.896     0.200
     2.910    16.296     0.200
     3.609    16.763     0.200
     4.704    17.786     0.200
     4.773    18.093     0.200
     5.049    18.409     0.200
     5.314    19.350     0.200
     5.582    20.206     0.200
     1.506    10.648     0.200
     1.597    11.154     0.200
     1.788    11.968     0.200
     1.923    12.083     0.200
     2.113    12.429     0.200
     2.298    13.240     0.200
     2.657    15.070     0.200
     2.907    14.086     0.200
     3.206    16.225     0.200
     3.278    15.933     0.200
     3.333    14.811     0.200
     3.492    16.694     0.200
     3.755    16.136     0.200
     3.879    16.916     0.200
     4.035    17.777     0.200
     4.228    15.549     0.200
     4.441    17.700     0.200
     4.486    16.937     0.200
     4.797    17.299     0.200
     4.891    18.163     0.200
     5.115    18.030     0.200
     5.084    20.044     0.200
     5.165    20.194     0.200
     5.166    20.676     0.200
     5.211    18.347     0.200
     5.283    18.609     0.200
     5.312    18.157     0.200
     5.370    18.552     0.200
     5.383    18.449     0.200
     5.401    18.542     0.200
     5.435    20.003     0.200
     5.510    18.981     0.200
     5.510    19.095     0.200
     5.641    19.289     0.200
     5.656    19.152     0.200
     5.656    18.980     0.200
     5.754    19.453     0.200
     5.754    19.562     0.200
     5.830    19.688     0.200
     5.839    19.623     0.200
     5.828    19.676     0.200
     5.828    19.793     0.200
     5.829    22.158     0.200
     5.990    19.711     0.200
     6.356    20.857     0.200
     6.398    20.767     0.200
     6.430    21.136     0.200
     6.594    21.345     0.200
     6.898    18.126     0.200
     6.589    24.070     0.200
     6.589    24.198     0.200
     6.842    22.600     0.200
     6.917    21.866     0.200
     7.103    22.502     0.200
     7.110    22.344     0.200
     7.126    24.815     0.200
     7.126    24.916     0.200
     7.210    22.468     0.200
     7.214    22.072     0.200
     7.413    22.941     0.200
     7.398    22.577     0.200
     7.398    22.459     0.200
     7.479    23.712     0.200
     7.527    23.482     0.200
     7.634    23.376     0.200
     7.919    24.440     0.200
     8.085    24.881     0.200
     8.145    24.700     0.200
     8.447    25.655     0.200
     8.653    25.337     0.200
     8.801    28.108     0.200
     8.801    27.944     0.200
     8.916    26.037     0.200
     8.970    26.112     0.200
     8.984    26.211     0.200
     9.077    26.663     0.200
     9.399    27.368     0.200
     9.440    27.334     0.200
     9.534    27.909     0.200
     9.599    27.372     0.200
     9.727    27.877     0.200
    10.521    29.593     0.200
    10.877    29.999     0.200
    10.941    30.454     0.200
    10.961    30.532     0.200
    11.310    32.250     0.200
    19.076    43.254     0.200
    19.305    42.981     0.200
    19.643    42.716     0.200
    19.681    42.667     0.200
    19.943    43.009     0.200
    20.046    43.312     0.200
    20.565    43.124     0.200
    20.588    43.513     0.200
     1.396    10.560     0.200
     1.802    11.998     0.200
     2.323    13.393     0.200
     2.455    12.678     0.200
     2.644    14.250     0.200
     2.660    12.932     0.200
     3.443    15.635     0.200
     3.522    16.247     0.200
     4.930    17.598     0.200
     5.004    17.712     0.200
     5.263    19.224     0.200
     5.557    19.357     0.200
     5.808    20.072     0.200
     2.608    10.057     0.200
     4.194    14.898     0.200
     4.353    14.698     0.200
     4.420    14.799     0.200
     4.498    14.985     0.200
     4.736    16.291     0.200
     4.762    15.871     0.200
     4.899    16.033     0.200
     4.899    16.319     0.200
     4.972    15.542     0.200
     5.070    16.253     0.200
     5.468    16.330     0.200
     6.179    18.697     0.200
     6.311    18.446     0.200
     1.921    12.003     0.200
     1.943    12.318     0.200
     2.585    14.409     0.200
     5.858    19.734     0.200
     5.948    20.112     0.200
     5.982    20.259     0.200
     6.048    20.913     0.200
     6.067    20.582     0.200
     6.067    20.781     0.200
     6.255    20.972     0.200
     6.489    21.961     0.200
     6.615    21.285     0.200
     6.681    21.803     0.200
     6.713    21.673     0.200
     7.132    22.539     0.200
     7.177    22.708     0.200
     7.597    20.966     0.200
     7.690    23.427     0.200
     7.951    23.849     0.200
     8.203    24.637     0.200
     8.220    24.633     0.200
     1.503     8.722     0.200
     1.790    10.381     0.200
     1.790    10.628     0.200
     1.742    11.472     0.200
     2.118    11.731     0.200
     2.327    14.115     0.200
     2.561    12.072     0.200
     2.561    12.588     0.200
     2.716    12.877     0.200
     2.734    12.294     0.200
     3.538    14.825     0.200
     4.828    16.026     0.200
     4.899    16.163     0.200
     4.947    16.303     0.200
     4.947    16.176     0.200
     5.164    17.097     0.200
     5.169    16.937     0.200
     5.214    17.619     0.200
     5.292    18.263     0.200
     5.292    18.511     0.200
     5.402    18.576     0.200
     5.444    17.806     0.200
     5.463    18.176     0.200
     5.706    18.927     0.200
     6.000    18.785     0.200
     6.000    18.499     0.200
     6.044    19.468     0.200
     6.586    19.850     0.200
     6.722    19.153     0.200
     6.724    20.759     0.200
     7.138    20.949     0.200
     1.982    11.849     0.200
     2.831    14.364     0.200
     2.919    15.415     0.200
     3.890    15.227     0.200
     3.972    16.408     0.200
     4.216    15.570     0.200
     4.528    16.863     0.200
     4.567    17.059     0.200
     4.768    17.695     0.200
     1.594     9.869     0.200
     1.954    11.087     0.200
     2.220     9.925     0.200
     2.316    13.047     0.200
     2.734    12.333     0.200
     2.734    12.099     0.200
     2.841    13.168     0.200
     2.841    11.937     0.200
     2.906    13.776     0.200
     3.043    14.793     0.200
     3.043    12.063     0.200
     3.756    17.288     0.200
     3.746    15.524     0.200
     3.746    14.774     0.200
     3.802    13.143     0.200
     3.802    13.689     0.200
     3.800    14.187     0.200
     3.800    14.626     0.200
     3.766    14.033     0.200
     3.827    14.649     0.200
     4.187    15.009     0.200
     4.187    15.219     0.200
     4.567    15.786     0.200
     4.713    16.049     0.200
     4.713    16.161     0.200
     4.997    16.335     0.200
     5.084    19.194     0.200
     5.446    17.860     0.200
     5.851    17.875     0.200
     1.230     8.134     0.200
     1.348     8.405     0.200
     1.320     8.385     0.200
     1.959    10.600     0.200
     2.194    10.108     0.200
     2.232     8.769     0.200
     2.336    12.228     0.200
     2.519    11.280     0.200
     2.873    10.170     0.200
     3.252    12.411     0.200
     3.372    12.941     0.200
     3.540    11.123     0.200
     3.587    13.388     0.200
     3.836    13.479     0.200
     3.922    12.195     0.200
     3.942    11.962     0.200
     3.942    12.297     0.200
     4.036    13.825     0.200
     4.036    14.130     0.200
     4.159    14.955     0.200
     4.159    14.049     0.200
     4.288    12.643     0.200
     4.383    14.123     0.200
     4.504    13.313     0.200
     4.923    15.562     0.200
     4.925    14.630     0.200
     5.138    15.692     0.200
     5.183    15.409     0.200
     5.183    15.667     0.200
     5.547    16.937     0.200
     5.592    16.537     0.200
     5.655    16.312     0.200
     6.031    17.347     0.200
     6.057    16.872     0.200
     6.067    17.118     0.200
     7.259    20.118     0.200
     1.373     7.842     0.200
     2.038    11.544     0.200
     2.038    10.802     0.200
     2.095    10.272     0.200
     2.173    11.434     0.200
     2.203     9.802     0.200
     2.379     9.751     0.200
     2.379    10.063     0.200
     2.397    10.917     0.200
     2.508    10.706     0.200
     2.491    10.872     0.200
     2.683     9.850     0.200
     2.629    12.916     0.200
     2.831    12.867     0.200
     2.955    12.018     0.200
     2.955    11.432     0.200
     3.034    13.299     0.200
     3.034    12.713     0.200
     3.289    14.692     0.200
     3.697    15.375     0.200
     3.744    12.400     0.200
     3.740    12.341     0.200
     3.778    12.290     0.200
     3.778    12.001     0.200
     3.792    11.797     0.200
     3.792    12.344     0.200
     3.862    13.456     0.200
     3.985    13.864     0.200
     3.985    15.169     0.200
     3.988    16.801     0.200
     4.109    12.581     0.200
     4.137    14.798     0.200
     4.162    14.777     0.200
     4.222    13.649     0.200
     4.222    14.422     0.200
     4.362    14.526     0.200
     4.378    15.647     0.200
     4.369    14.575     0.200
     4.761    14.412     0.200
     4.761    14.795     0.200
     4.990    15.550     0.200
     5.024    15.351     0.200
     5.024    15.585     0.200
     5.418    16.512     0.200
     5.418    16.244     0.200
     5.492    16.573     0.200
     5.873    17.215     0.200
     5.903    17.489     0.200
     7.089    19.775     0.200
     7.325    20.091     0.200
     7.436    20.462     0.200
     3.155    16.257     0.200
     5.303    18.570     0.200
     5.386    18.594     0.200
     5.616    20.425     0.200
     5.853    20.606     0.200
     5.961    20.114     0.200
     6.523    21.166     0.200
     6.740    21.982     0.200
     7.083    23.283     0.200
     7.243    22.941     0.200
     7.570    23.047     0.200
     1.113     6.354     0.200
     1.113     6.851     0.200
     1.060     7.725     0.200
     1.258     8.074     0.200
     1.449     8.758     0.200
     1.389     7.915     0.200
     1.740     6.233     0.200
     2.587     9.746     0.200
     2.685     9.516     0.200
     2.695    10.036     0.200
     3.425    11.008     0.200
     3.507     9.311     0.200
     4.080    12.698     0.200
     4.080    12.828     0.200
     4.170    12.654     0.200
     4.386    13.726     0.200
     4.472    13.364     0.200
     4.623    14.754     0.200
     4.657    14.237     0.200
     4.657    14.682     0.200
     4.718    14.256     0.200
     4.786    13.741     0.200
     4.786    14.018     0.200
     4.797    13.897     0.200
     4.875    14.522     0.200
     4.875    14.869     0.200
     5.000    14.322     0.200
     5.356    15.365     0.200
     5.391    16.538     0.200
     5.549    15.736     0.200
     5.549    15.578     0.200
     5.869    12.260     0.200
     5.691    16.159     0.200
     5.874    16.356     0.200
     6.066    16.797     0.200
     6.253    16.505     0.200
     6.368    17.821     0.200
     6.611    17.915     0.200
     2.167    10.783     0.200
     3.467    17.074     0.200
     3.747    14.629     0.200
     3.781    15.354     0.200
     3.734    13.232     0.200
     3.764    13.136     0.200
     4.135    15.734     0.200
     4.157    15.479     0.200
     4.198    14.892     0.200
     4.605    18.178     0.200
     4.975    16.843     0.200
     5.003    16.369     0.200
     5.399    17.361     0.200
     5.467    17.866     0.200
     5.853    18.498     0.200
     1.537     9.622     0.200
     2.352    13.007     0.200
     2.594    12.639     0.200
     2.676    12.913     0.200
     2.676    11.673     0.200
     2.684    12.267     0.200
     2.850    12.075     0.200
     2.850    13.366     0.200
     2.896    14.581     0.200
     3.224    14.371     0.200
     3.348    11.789     0.200
     3.348    13.813     0.200
     3.377    12.760     0.200
     3.322    14.968     0.200
     3.322    14.062     0.200
     3.668    13.577     0.200
     3.668    12.929     0.200
     3.732    13.170     0.200
     3.722    15.825     0.200
     3.722    14.971     0.200
     3.776    14.118     0.200
     3.776    13.591     0.200
     3.816    13.071     0.200
     3.816    13.514     0.200
     3.981    14.481     0.200
     3.981    14.841     0.200
     4.032    15.941     0.200
     4.050    14.397     0.200
     4.050    15.465     0.200
     4.064    13.753     0.200
     4.064    14.501     0.200
     4.125    16.740     0.200
     4.260    16.518     0.200
     4.259    15.328     0.200
     4.259    16.580     0.200
     4.276    14.329     0.200
     4.276    14.838     0.200
     4.301    14.351     0.200
     4.301    14.902     0.200
     4.232    17.252     0.200
     4.347    15.186     0.200
     4.374    15.887     0.200
     4.836    16.379     0.200
     4.836    16.906     0.200
     4.956    16.938     0.200
     5.059    16.315     0.200
     5.059    16.995     0.200
     5.067    17.440     0.200
     5.416    17.733     0.200
     5.557    18.251     0.200
     5.640    17.826     0.200
     5.894    18.177     0.200
     5.973    19.022     0.200
     6.045    18.816     0.200
     1.296     7.694     0.200
     2.133    11.541     0.200
     2.518    10.654     0.200
     2.657    10.414     0.200
     2.562    14.424     0.200
     2.814    11.777     0.200
     2.643    13.983     0.200
     2.920    10.779     0.200
     3.072    13.433     0.200
     3.180    13.196     0.200
     3.267    14.250     0.200
     3.615    15.496     0.200
     3.782    15.927     0.200
     4.170    16.439     0.200
     4.170    16.122     0.200
     4.251    13.963     0.200
     4.241    17.315     0.200
     4.423    13.655     0.200
     4.638    15.406     0.200
     4.674    14.910     0.200
     4.674    16.185     0.200
     4.689    15.964     0.200
     4.762    14.836     0.200
     4.922    16.114     0.200
     4.922    16.344     0.200
     4.907    19.154     0.200
     4.907    18.051     0.200
     5.016    16.867     0.200
     5.264    15.624     0.200
     5.264    16.565     0.200
     5.401    17.755     0.200
     5.401    16.482     0.200
     5.666    17.463     0.200
     5.737    19.076     0.200
     5.737    18.677     0.200
     6.190    19.170     0.200
     6.592    19.696     0.200
     7.442    21.848     0.200
     1.320     9.123     0.200
     1.744    10.545     0.200
     1.971    11.062     0.200
     2.162    11.494     0.200
     2.546    10.690     0.200
     2.648    11.721     0.200
     2.679    11.861     0.200
     2.679    10.073     0.200
     2.789    13.154     0.200
     2.825    11.187     0.200
     2.925    13.120     0.200
     2.925    12.650     0.200
     3.087    14.835     0.200
     3.087    12.613     0.200
     3.169    13.628     0.200
     3.208    13.077     0.200
     3.282    15.698     0.200
     3.619    17.320     0.200
     3.789    16.862     0.200
     4.187    16.461     0.200
     4.187    15.195     0.200
     4.272    13.966     0.200
     4.278    14.853     0.200
     4.668    16.013     0.200
     4.668    14.694     0.200
     4.704    14.989     0.200
     4.704    15.986     0.200
     4.720    16.186     0.200
     4.774    15.873     0.200
     4.949    16.862     0.200
     4.949    16.663     0.200
     4.907    19.162     0.200
     4.907    17.935     0.200
     5.046    15.914     0.200
     5.236    17.548     0.200
     5.294    15.945     0.200
     5.294    16.354     0.200
     5.426    16.968     0.200
     5.542    17.386     0.200
     5.694    17.775     0.200
     5.763    19.428     0.200
     6.155    19.411     0.200
     6.619    20.638     0.200
     2.717    11.743     0.200
     2.717    10.961     0.200
     2.819    12.110     0.200
     2.819    11.809     0.200
     2.893    14.318     0.200
     3.334    14.877     0.200
     3.379    16.203     0.200
     3.684    16.804     0.200
     4.204    15.118     0.200
     4.204    14.487     0.200
     4.308    14.324     0.200
     4.308    15.433     0.200
     4.436    17.833     0.200
     4.634    18.282     0.200
     4.787    15.047     0.200
     4.808    15.768     0.200
     5.013    16.838     0.200
     5.130    16.377     0.200
     5.130    17.560     0.200
     5.376    17.520     0.200
     5.488    18.436     0.200
     1.181     6.104     0.200
     1.152     7.494     0.200
     1.283     8.031     0.200
     2.123    10.601     0.200
     4.190    13.142     0.200
     4.190    13.429     0.200
     4.278    13.710     0.200
     4.423    13.119     0.200
     4.423    13.718     0.200
     4.465    14.659     0.200
     4.500    13.896     0.200
     4.582    14.531     0.200
     4.737    14.909     0.200
     4.738    14.987     0.200
     4.738    15.531     0.200
     4.829    14.739     0.200
     4.886    15.100     0.200
     4.886    14.768     0.200
     4.944    15.139     0.200
     5.067    15.129     0.200
     5.454    15.992     0.200
     5.454    16.467     0.200
     5.500    16.695     0.200
     5.652    15.817     0.200
     5.652    16.722     0.200
     5.980    13.368     0.200
     5.753    17.049     0.200
     5.981    17.258     0.200
     6.167    17.602     0.200
     6.700    18.976     0.200
     0.950     8.549     0.200
     1.018     8.198     0.200
     1.239     8.593     0.200
     1.370     8.998     0.200
     1.776     6.860     0.200
     2.091    10.807     0.200
     2.625    10.462     0.200
     2.737     9.466     0.200
     3.259     9.627     0.200
     3.553     9.602     0.200
     4.065    13.156     0.200
     4.153    13.310     0.200
     4.301    13.249     0.200
     4.301    14.226     0.200
     4.376    14.233     0.200
     4.457    14.994     0.200
     4.613    14.948     0.200
     4.622    13.402     0.200
     4.703    15.037     0.200
     4.762    14.563     0.200
     4.941    15.184     0.200
     5.330    15.229     0.200
     5.855    13.562     0.200
     6.042    16.550     0.200
     1.417     8.913     0.200
     1.461     8.987     0.200
     2.083    11.085     0.200
     2.232    11.802     0.200
     2.198    10.056     0.200
     2.389    11.867     0.200
     2.699    10.989     0.200
     2.940    11.799     0.200
     3.018    12.449     0.200
     3.274    14.811     0.200
     3.735    12.892     0.200
     3.768    12.837     0.200
     3.768    12.610     0.200
     3.847    13.251     0.200
     3.973    15.363     0.200
     4.100    14.297     0.200
     4.154    15.316     0.200
     4.209    14.925     0.200
     4.352    15.102     0.200
     4.600    15.068     0.200
     4.749    15.233     0.200
     4.736    16.497     0.200
     4.855    15.554     0.200
     4.979    16.071     0.200
     5.012    16.077     0.200
     5.012    15.225     0.200
     5.479    16.908     0.200
     5.862    17.931     0.200
     5.890    18.083     0.200
     2.209    11.685     0.200
     3.157    14.868     0.200
     3.499    15.275     0.200
     3.508    14.712     0.200
     5.417    16.365     0.200
     5.725    16.490     0.200
     5.972    18.866     0.200
     5.991    18.163     0.200
     6.212    17.931     0.200
     6.640    19.628     0.200
     7.114    20.620     0.200
     7.272    20.516     0.200
     1.987    10.980     0.200
     1.987     9.449     0.200
     2.522    11.382     0.200
     2.664    11.164     0.200
     2.756    10.249     0.200
     2.729    11.218     0.200
     2.734    10.405     0.200
     2.734    11.615     0.200
     2.921    12.645     0.200
     2.921    11.074     0.200
     2.955    12.549     0.200
     3.038    11.277     0.200
     3.041    12.812     0.200
     3.235    10.367     0.200
     3.241    14.211     0.200
     3.429    12.060     0.200
     3.459    13.113     0.200
     3.459    12.641     0.200
     3.517    12.259     0.200
     3.713    11.446     0.200
     3.713    11.982     0.200
     3.781    12.076     0.200
     3.829    12.279     0.200
     3.829    12.502     0.200
     3.794    13.301     0.200
     3.795    13.143     0.200
     3.803    13.049     0.200
     3.879    12.030     0.200
     3.879    12.409     0.200
     4.014    13.377     0.200
     4.069    13.081     0.200
     4.097    13.145     0.200
     4.139    12.893     0.200
     4.139    13.038     0.200
     4.337    13.329     0.200
     4.337    13.501     0.200
     4.347    14.039     0.200
     4.337    13.325     0.200
     4.337    13.727     0.200
     4.398    13.965     0.200
     4.456    15.212     0.200
     4.591    14.420     0.200
     4.899    14.790     0.200
     4.899    15.021     0.200
     5.005    15.739     0.200
     5.117    14.990     0.200
     5.117    15.568     0.200
     5.148    15.772     0.200
     5.469    16.228     0.200
     5.618    17.189     0.200
     5.692    16.353     0.200
     5.718    16.567     0.200
     5.829    19.048     0.200
     5.829    18.548     0.200
     5.914    16.067     0.200
     5.914    16.801     0.200
     5.950    17.016     0.200
     6.034    17.768     0.200
     6.050    18.106     0.200
     6.115    17.564     0.200
     6.590    19.246     0.200
     6.681    18.949     0.200
     6.959    19.338     0.200
     7.493    19.916     0.200
     7.581    20.700     0.200
     7.883    21.303     0.200
     7.948    22.101     0.200
     8.019    21.433     0.200
     8.019    21.234     0.200
     8.107    21.779     0.200
     8.239    22.077     0.200
     9.358    25.344     0.200
     9.463    24.776     0.200
     1.600    11.540     0.200
     1.983    12.329     0.200
     5.374    18.870     0.200
     5.656    19.668     0.200
     5.740    21.100     0.200
     6.050    20.260     0.200
     1.594     8.932     0.200
     2.251    12.088     0.200
     2.783    12.904     0.200
     2.783    12.130     0.200
     2.912    13.176     0.200
     3.025    11.963     0.200
     3.025    11.862     0.200
     4.014    16.763     0.200
     4.334    16.607     0.200
     4.334    16.029     0.200
     4.373    16.572     0.200
     4.476    15.850     0.200
     4.476    15.366     0.200
     4.648    16.060     0.200
     4.668    15.678     0.200
     4.668    15.793     0.200
     4.974    16.639     0.200
     4.974    16.092     0.200
     5.009    16.412     0.200
     5.131    16.575     0.200
     5.174    18.145     0.200
     5.471    17.596     0.200
     5.471    16.534     0.200
     5.693    18.098     0.200
     5.693    17.059     0.200
     5.789    18.494     0.200
     5.789    17.228     0.200
     6.203    19.203     0.200
     6.645    20.547     0.200
     1.816    10.599     0.200
     1.926    12.226     0.200
     2.266    13.238     0.200
     2.420    12.656     0.200
     2.450    13.603     0.200
     2.644    14.283     0.200
     2.871    13.176     0.200
     3.022    12.778     0.200
     3.459    15.693     0.200
     3.832    15.016     0.200
     3.883    16.181     0.200
     4.634    16.287     0.200
     4.694    16.543     0.200
     4.730    16.904     0.200
     4.731    16.710     0.200
     4.731    16.274     0.200
     4.881    17.437     0.200
     4.881    16.843     0.200
     4.946    15.868     0.200
     5.000    17.304     0.200
     5.015    17.406     0.200
     5.015    17.197     0.200
     4.991    18.278     0.200
     4.991    17.655     0.200
     5.203    17.958     0.200
     5.203    17.692     0.200
     5.228    18.205     0.200
     5.266    17.585     0.200
     5.266    17.745     0.200
     5.810    19.151     0.200
     5.997    19.418     0.200
     6.368    20.057     0.200
     6.379    20.944     0.200
     6.437    20.738     0.200
     6.480    20.843     0.200
     6.839    21.092     0.200
     6.894    21.629     0.200
     2.114    11.071     0.200
     2.150    10.602     0.200
     2.767    12.663     0.200
     2.948    13.802     0.200
     3.501    14.657     0.200
     3.621    14.630     0.200
     3.745    13.985     0.200
     3.816    14.392     0.200
     3.909    15.474     0.200
     4.640    15.791     0.200
     2.079    11.101     0.200
     2.363    10.937     0.200
     2.193    10.709     0.200
     2.701    14.237     0.200
     2.938    13.202     0.200
     3.016    13.682     0.200
     3.271    15.111     0.200
     3.305    15.144     0.200
     3.443    14.912     0.200
     3.554    16.183     0.200
     3.737    13.954     0.200
     3.769    13.113     0.200
     3.748    16.048     0.200
     3.847    14.030     0.200
     3.968    15.736     0.200
     3.970    16.017     0.200
     4.210    15.071     0.200
     4.749    15.263     0.200
     5.013    16.994     0.200
     5.408    18.205     0.200
     5.480    17.915     0.200
     1.387     8.571     0.200
     2.134    10.238     0.200
     2.806    10.907     0.200
     2.941    15.062     0.200
     3.931    13.162     0.200
     4.265    14.682     0.200
     4.362    14.692     0.200
     4.662    15.644     0.200
     4.714    15.029     0.200
     4.896    16.121     0.200
     5.119    16.159     0.200
     5.116    15.963     0.200
     5.165    16.279     0.200
     5.455    17.134     0.200
     5.583    18.013     0.200
     6.004    16.169     0.200
     6.099    18.476     0.200
     6.378    19.213     0.200
     1.978    12.316     0.200
     2.182    11.992     0.200
     3.361    15.112     0.200
     5.234    17.428     0.200
     5.674    19.162     0.200
     5.780    19.523     0.200
     5.842    19.769     0.200
     7.123    21.818     0.200
     2.491    13.219     0.200
     2.796    13.765     0.200
     2.832    13.149     0.200
     4.571    16.775     0.200
     4.690    18.163     0.200
     6.033    18.860     0.200
     6.098    18.655     0.200
     6.158    19.248     0.200
     6.364    18.923     0.200
     6.404    19.830     0.200
     6.595    20.586     0.200
     6.815    19.957     0.200
     6.814    19.941     0.200
     7.246    21.578     0.200
     7.284    21.570     0.200
     7.692    19.927     0.200
     7.535    22.735     0.200
     7.802    22.679     0.200
     8.080    23.041     0.200
     8.318    23.909     0.200
     1.415    10.628     0.200
     1.498    11.240     0.200
     1.596    12.551     0.200
     1.961    12.644     0.200
     2.077    12.922     0.200
     2.649    15.181     0.200
     2.734    12.901     0.200
     2.734    12.128     0.200
     2.734    12.307     0.200
     2.597    16.745     0.200
     2.833    14.450     0.200
     2.641    15.428     0.200
     2.844    13.270     0.200
     2.844    12.895     0.200
     2.681    14.240     0.200
     2.922    15.148     0.200
     2.922    14.281     0.200
     3.120    15.332     0.200
     3.181    15.576     0.200
     3.183    15.465     0.200
     3.311    14.283     0.200
     3.311    15.009     0.200
     3.416    15.487     0.200
     3.348    15.450     0.200
     3.795    17.160     0.200
     3.653    16.378     0.200
     3.966    19.117     0.200
     4.114    18.320     0.200
     4.225    16.906     0.200
     4.225    17.132     0.200
     4.126    19.752     0.200
     4.247    16.778     0.200
     4.247    17.645     0.200
     4.326    16.723     0.200
     4.524    18.000     0.200
     4.405    18.898     0.200
     4.405    17.984     0.200
     4.604    18.282     0.200
     4.753    17.064     0.200
     4.753    17.408     0.200
     4.793    17.007     0.200
     4.793    17.367     0.200
     4.812    16.489     0.200
     4.812    17.404     0.200
     4.888    20.437     0.200
     4.888    19.148     0.200
     5.024    18.328     0.200
     5.024    18.711     0.200
     5.135    17.401     0.200
     5.135    17.964     0.200
     5.299    18.376     0.200
     5.313    17.776     0.200
     5.313    18.237     0.200
     5.313    18.448     0.200
     5.382    18.339     0.200
     5.382    18.487     0.200
     5.491    18.535     0.200
     5.496    19.052     0.200
     5.496    19.653     0.200
     5.555    19.048     0.200
     5.555    19.985     0.200
     5.629    19.338     0.200
     5.655    20.157     0.200
     5.612    21.161     0.200
     5.775    20.257     0.200
     5.775    20.000     0.200
     5.806    20.356     0.200
     5.838    19.712     0.200
     5.942    20.271     0.200
     6.295    21.104     0.200
     6.367    21.067     0.200
     1.650    12.386     0.200
     1.828     8.880     0.200
     2.133    10.484     0.200
     2.099    11.944     0.200
     2.235    11.429     0.200
     2.253    11.985     0.200
     2.342    10.203     0.200
     2.444    12.626     0.200
     2.774    12.157     0.200
     2.634    12.974     0.200
     2.745    12.438     0.200
     2.725    13.555     0.200
     2.725    11.651     0.200
     2.725    14.309     0.200
     2.974    13.660     0.200
     2.974    14.304     0.200
     3.090    15.660     0.200
     3.198    15.090     0.200
     3.351    14.067     0.200
     3.504    12.193     0.200
     3.504    12.644     0.200
     3.395    16.377     0.200
     3.395    15.996     0.200
     3.395    16.110     0.200
     3.672    14.370     0.200
     3.672    14.113     0.200
     3.798    14.180     0.200
     3.798    14.451     0.200
     3.651    16.616     0.200
     3.945    14.727     0.200
     3.945    15.795     0.200
     4.014    14.984     0.200
     4.014    15.339     0.200
     4.017    15.306     0.200
     4.017    14.608     0.200
     4.152    15.168     0.200
     4.154    15.748     0.200
     4.197    15.058     0.200
     4.197    15.196     0.200
     4.519    15.784     0.200
     4.429    18.465     0.200
     4.790    18.179     0.200
     4.886    16.956     0.200
     5.079    16.996     0.200
     5.079    17.443     0.200
     5.079    15.888     0.200
     5.079    16.338     0.200
     5.096    16.316     0.200
     5.081    16.881     0.200
     5.163    16.362     0.200
     5.163    16.659     0.200
     5.192    16.311     0.200
     5.192    16.200     0.200
     5.183    16.605     0.200
     5.313    16.909     0.200
     5.313    17.163     0.200
     5.526    17.492     0.200
     5.526    17.242     0.200
     5.553    16.632     0.200
     5.553    17.076     0.200
     5.553    17.746     0.200
     5.553    17.537     0.200
     5.587    16.675     0.200
     5.587    17.497     0.200
     5.581    16.972     0.200
     5.581    17.722     0.200
     5.778    17.307     0.200
     5.778    17.888     0.200
     5.798    18.359     0.200
     5.940    20.095     0.200
     5.940    20.877     0.200
     6.026    18.389     0.200
     6.107    17.761     0.200
     6.107    18.461     0.200
     6.047    19.212     0.200
     6.167    22.109     0.200
     6.264    18.464     0.200
     6.264    18.089     0.200
     6.264    18.682     0.200
     6.398    18.893     0.200
     6.398    18.514     0.200
     6.398    19.303     0.200
     6.397    18.868     0.200
     6.447    18.141     0.200
     6.447    19.652     0.200
     6.447    19.295     0.200
     6.447    19.861     0.200
     6.576    19.519     0.200
     6.576    17.987     0.200
     6.612    19.838     0.200
     6.544    20.509     0.200
     6.585    21.224     0.200
     6.810    19.580     0.200
     6.841    19.706     0.200
     7.130    20.680     0.200
     7.170    20.947     0.200
     7.170    20.683     0.200
     7.245    22.021     0.200
     7.245    20.572     0.200
     7.252    20.636     0.200
     7.270    22.432     0.200
     7.315    22.507     0.200
     7.419    21.498     0.200
     7.772    22.113     0.200
     7.783    21.493     0.200
     7.783    22.183     0.200
     7.880    22.140     0.200
     8.175    22.152     0.200
     8.378    22.858     0.200
     8.448    26.583     0.200
     8.647    23.944     0.200
     8.759    24.133     0.200
     8.778    23.981     0.200
     8.938    24.464     0.200
     9.069    24.467     0.200
     9.069    24.648     0.200
     9.136    24.843     0.200
     9.439    25.426     0.200
    10.349    28.656     0.200
    10.418    26.497     0.200
    11.474    28.675     0.200
    11.474    30.515     0.200
    13.734    35.483     0.200
    15.793    36.850     0.200
    17.103    37.189     0.200
    17.356    40.012     0.200
    18.753    41.272     0.200
    19.187    44.284     0.200
    19.753    41.375     0.200
    19.966    43.867     0.200
    19.972    40.980     0.200
    20.123    40.388     0.200
    20.147    40.325     0.200
    20.178    40.542     0.200
    20.242    40.480     0.200
    20.276    43.914     0.200
    20.546    40.871     0.200
    20.575    44.456     0.200
     1.759    10.059     0.200
     1.781    11.532     0.200
     2.186    13.941     0.200
     2.147    12.363     0.200
     2.569    15.054     0.200
     2.569    11.394     0.200
     2.733    11.882     0.200
     3.013    14.439     0.200
     3.554    14.964     0.200
     3.539    13.563     0.200
     4.789    15.224     0.200
     4.789    15.738     0.200
     4.861    16.152     0.200
     4.861    16.415     0.200
     4.942    16.348     0.200
     5.064    16.923     0.200
     5.089    17.262     0.200
     5.133    17.878     0.200
     5.133    16.968     0.200
     5.129    16.550     0.200
     5.175    17.312     0.200
     5.208    18.536     0.200
     5.263    18.574     0.200
     5.263    17.263     0.200
     5.362    17.438     0.200
     5.407    17.819     0.200
     5.425    17.769     0.200
     5.478    17.874     0.200
     5.667    18.422     0.200
     5.964    18.166     0.200
     5.989    18.902     0.200
     6.085    19.325     0.200
     6.192    19.799     0.200
     6.192    20.241     0.200
     6.687    20.163     0.200
     7.028    21.277     0.200
     7.102    21.041     0.200
     7.656    22.414     0.200
     8.324    24.158     0.200
     8.538    24.442     0.200
     8.647    24.538     0.200
     2.154    12.441     0.200
     2.585    14.361     0.200
     5.188    17.238     0.200
     5.214    16.957     0.200
     5.549    17.629     0.200
     5.601    18.946     0.200
     5.801    18.845     0.200
     5.826    19.016     0.200
     6.283    19.537     0.200
     6.412    20.104     0.200
     6.828    21.195     0.200
     6.852    21.155     0.200
     7.256    21.951     0.200
     7.267    22.570     0.200
     2.056    12.721     0.200
     2.831    14.837     0.200
     2.790    14.509     0.200
     5.353    18.409     0.200
     5.451    18.604     0.200
     5.748    19.523     0.200
     5.874    19.867     0.200
     5.992    19.817     0.200
     6.072    20.756     0.200
     6.227    20.317     0.200
     6.596    21.096     0.200
     6.669    21.380     0.200
     7.134    18.843     0.200
     7.157    22.316     0.200
     7.352    23.100     0.200
     7.654    23.601     0.200
     7.769    23.859     0.200
     1.377     9.714     0.200
     1.481     9.455     0.200
     1.463     9.965     0.200
     2.020    10.242     0.200
     2.020    11.913     0.200
     2.114    10.388     0.200
     2.401    11.900     0.200
     2.401    12.626     0.200
     2.661    13.460     0.200
     2.978    13.537     0.200
     2.978    14.496     0.200
     3.056    12.343     0.200
     3.405    14.638     0.200
     3.675    14.213     0.200
     3.675    14.924     0.200
     3.708    15.430     0.200
     3.790    14.188     0.200
     3.790    14.606     0.200
     3.805    14.110     0.200
     3.805    13.644     0.200
     3.882    14.916     0.200
     3.882    14.533     0.200
     4.006    16.586     0.200
     4.006    15.645     0.200
     4.011    14.810     0.200
     3.912    14.733     0.200
     4.121    14.396     0.200
     4.121    16.160     0.200
     4.145    16.245     0.200
     4.237    15.311     0.200
     4.237    16.014     0.200
     4.374    16.184     0.200
     4.387    15.647     0.200
     4.621    16.243     0.200
     4.778    16.102     0.200
     4.778    16.693     0.200
     4.774    17.400     0.200
     5.040    18.102     0.200
     5.040    17.593     0.200
     5.394    17.407     0.200
     5.439    18.007     0.200
     1.603     8.357     0.200
     1.683     8.807     0.200
     1.801     9.762     0.200
     1.788     8.619     0.200
     2.535    10.802     0.200
     2.640    12.035     0.200
     2.822    10.655     0.200
     3.733    13.480     0.200
     4.499    14.679     0.200
     4.672    16.030     0.200
     4.738    15.111     0.200
     4.769    15.935     0.200
     4.888    16.033     0.200
     4.997    15.515     0.200
     5.262    16.502     0.200
     5.554    16.157     0.200
     5.781    17.075     0.200
     6.139    17.526     0.200
     6.277    18.133     0.200
     6.296    17.394     0.200
     1.158    10.399     0.200
     1.385     9.166     0.200
     1.739    10.282     0.200
     1.663    10.591     0.200
     2.097    12.588     0.200
     2.224    11.044     0.200
     2.224    11.539     0.200
     2.316    12.416     0.200
     2.449    12.822     0.200
     2.410    12.856     0.200
     2.410    12.206     0.200
     2.821    13.305     0.200
     3.180    15.700     0.200
     3.459    13.394     0.200
     4.177    12.812     0.200
     5.484    17.172     0.200
     5.529    16.206     0.200
     5.545    16.585     0.200
     5.691    16.441     0.200
     5.691    19.103     0.200
     5.755    17.664     0.200
     5.784    19.195     0.200
     5.784    20.361     0.200
     5.800    17.444     0.200
     5.800    18.035     0.200
     6.015    17.913     0.200
     6.015    18.593     0.200
     6.050    18.250     0.200
     6.292    19.249     0.200
     6.567    19.275     0.200
     6.567    19.834     0.200
     6.609    18.786     0.200
     7.168    20.948     0.200
     7.294    21.315     0.200
     2.046    12.238     0.200
     2.132    12.841     0.200
     2.641    14.711     0.200
     3.516    16.587     0.200
     5.957    18.997     0.200
     6.055    19.675     0.200
     6.136    20.160     0.200
     6.231    19.714     0.200
     6.231    20.085     0.200
     6.352    20.447     0.200
     6.473    21.785     0.200
     6.595    20.636     0.200
     6.595    20.956     0.200
     6.684    21.554     0.200
     6.674    21.943     0.200
     6.829    21.339     0.200
     7.201    22.575     0.200
     7.273    22.277     0.200
     7.762    23.435     0.200
     7.938    24.914     0.200
     7.955    24.233     0.200
     8.259    25.313     0.200
     8.322    25.720     0.200
     8.372    25.610     0.200
     8.930    26.176     0.200
     9.624    28.419     0.200
     9.922    28.485     0.200
    10.236    29.486     0.200
    10.572    30.518     0.200
     1.599    10.711     0.200
     2.038    11.548     0.200
     2.231    12.025     0.200
     2.576    12.648     0.200
     3.026    13.474     0.200
     3.096    14.953     0.200
     3.281    15.158     0.200
     3.272    14.846     0.200
     3.680    15.575     0.200
     6.060    18.324     0.200
     6.142    18.646     0.200
     6.290    19.968     0.200
     6.371    19.775     0.200
     6.450    19.809     0.200
     6.609    20.119     0.200
     6.698    19.509     0.200
     6.698    19.869     0.200
     6.708    20.061     0.200
     6.937    20.245     0.200
     7.056    20.832     0.200
     7.277    21.262     0.200
     7.365    21.928     0.200
     7.490    22.552     0.200
     7.838    22.381     0.200
     7.988    23.106     0.200
     8.061    23.431     0.200
     8.322    23.748     0.200
     8.404    23.892     0.200
     8.958    25.320     0.200
     1.119     9.428     0.200
     1.472     8.648     0.200
     1.618     9.810     0.200
     2.024    10.974     0.200
     2.530    12.021     0.200
     2.688    12.241     0.200
     2.729    11.838     0.200
     3.525    13.992     0.200
     5.021    16.517     0.200
     1.284    12.128     0.200
     1.307    10.437     0.200
     1.353    10.672     0.200
     1.352    10.963     0.200
     1.429    11.164     0.200
     1.538    11.449     0.200
     1.607    11.462     0.200
     1.638    11.616     0.200
     1.768    12.093     0.200
     1.693    11.921     0.200
     1.898    11.538     0.200
     2.022    10.741     0.200
     1.986    12.666     0.200
     2.117    13.394     0.200
     2.545    13.293     0.200
     3.030    14.095     0.200
     5.381    17.359     0.200
     5.381    18.117     0.200
     5.488    18.258     0.200
     5.537    18.465     0.200
     5.571    18.389     0.200
     5.638    18.479     0.200
     5.638    18.609     0.200
     5.702    18.592     0.200
     5.778    18.741     0.200
     5.881    19.285     0.200
     6.019    19.308     0.200
     6.019    19.489     0.200
     6.010    19.579     0.200
     6.139    19.662     0.200
     6.139    20.048     0.200
     6.198    19.855     0.200
     6.250    19.648     0.200
     6.361    20.156     0.200
     6.637    21.500     0.200
     6.700    21.757     0.200
     7.151    18.644     0.200
     7.198    22.256     0.200
     7.417    22.582     0.200
     7.701    23.251     0.200
     7.834    23.398     0.200
     1.225     7.929     0.200
     1.492     9.003     0.200
     1.791     9.289     0.200
     2.248     9.389     0.200
     5.701    17.137     0.200
     5.983    18.160     0.200
     6.377    19.027     0.200
     6.448    18.600     0.200
     7.342    18.328     0.200
     0.836     8.859     0.200
     0.835     7.990     0.200
     1.082     8.527     0.200
     1.082     9.402     0.200
     1.191    10.511     0.200
     2.191    10.350     0.200
     2.397    11.677     0.200
     2.397    10.974     0.200
     2.614    11.539     0.200
     2.614    11.102     0.200
     2.673    11.528     0.200
     3.091    12.470     0.200
     3.434    15.244     0.200
     3.434    13.643     0.200
     3.533    12.468     0.200
     3.533    12.828     0.200
     3.582    12.888     0.200
     3.611    12.516     0.200
     3.611    12.992     0.200
     3.610    12.588     0.200
     3.608    15.614     0.200
     3.812    13.249     0.200
     3.812    14.187     0.200
     3.879    13.655     0.200
     3.892    12.771     0.200
     3.892    13.529     0.200
     3.908    13.718     0.200
     3.908    13.835     0.200
     3.928    14.296     0.200
     3.987    14.382     0.200
     3.987    14.671     0.200
     4.080    13.499     0.200
     4.080    14.077     0.200
     4.085    14.131     0.200
     4.149    14.147     0.200
     4.160    14.128     0.200
     4.186    14.907     0.200
     4.406    14.722     0.200
     4.533    14.892     0.200
     4.632    15.728     0.200
     4.632    16.111     0.200
     4.690    14.639     0.200
     4.690    15.241     0.200
     4.802    15.705     0.200
     4.787    16.448     0.200
     4.872    15.616     0.200
     4.872    16.428     0.200
     5.246    16.368     0.200
     5.358    17.225     0.200
     5.368    16.984     0.200
     5.371    16.453     0.200
     5.548    17.650     0.200
     5.561    17.493     0.200
     5.563    17.476     0.200
     5.715    17.636     0.200
     5.772    18.106     0.200
     5.808    18.169     0.200
     5.839    18.166     0.200
     6.324    19.291     0.200
     6.987    21.019     0.200
     7.126    21.093     0.200
     7.204    21.226     0.200
     7.314    21.502     0.200
     7.588    21.811     0.200
     7.723    21.681     0.200
     7.842    21.817     0.200
     9.117    24.236     0.200
     1.195     9.860     0.200
     1.429     9.502     0.200
     1.448    10.011     0.200
     1.552    10.646     0.200
     1.660    11.069     0.200
     1.653    10.278     0.200
     2.189     8.987     0.200
     3.534    12.067     0.200
     3.582    12.248     0.200
     3.611    11.941     0.200
     3.611    12.355     0.200
     3.609    11.969     0.200
     3.810    13.988     0.200
     3.810    13.082     0.200
     3.894    13.197     0.200
     3.894    13.587     0.200
     3.908    13.123     0.200
     3.908    13.224     0.200
     3.929    13.505     0.200
     3.984    14.722     0.200
     3.984    13.949     0.200
     4.079    12.737     0.200
     4.079    13.417     0.200
     4.151    13.264     0.200
     4.160    13.393     0.200
     4.186    14.277     0.200
     4.407    13.931     0.200
     4.534    14.178     0.200
     4.631    14.499     0.200
     4.631    15.062     0.200
     4.691    14.722     0.200
     4.802    15.011     0.200
     4.784    15.457     0.200
     4.872    15.398     0.200
     4.872    15.226     0.200
     5.247    15.615     0.200
     5.357    16.940     0.200
     5.367    15.886     0.200
     5.369    16.309     0.200
     5.549    16.819     0.200
     5.559    16.444     0.200
     5.560    16.919     0.200
     5.715    17.026     0.200
     5.771    17.416     0.200
     5.807    17.426     0.200
     5.840    17.419     0.200
     6.324    18.492     0.200
     7.587    21.526     0.200
     2.082    13.676     0.200
     2.463    14.423     0.200
     2.888    14.692     0.200
     5.392    19.420     0.200
     5.419    19.955     0.200
     5.676    20.447     0.200
     5.768    20.758     0.200
     5.916    21.373     0.200
     6.058    21.149     0.200
     6.254    21.283     0.200
     7.042    19.957     0.200
     7.102    23.233     0.200
     7.334    24.103     0.200
     1.574     9.314     0.200
     1.639    10.036     0.200
     1.710     9.740     0.200
     2.081    10.846     0.200
     2.163    12.466     0.200
     2.232    12.295     0.200
     2.380    13.404     0.200
     3.021    14.199     0.200
     2.936    12.918     0.200
     3.530    16.727     0.200
     4.193    17.667     0.200
     4.558    18.002     0.200
     4.613    17.610     0.200
     4.732    16.730     0.200
     4.906    15.679     0.200
     4.926    16.499     0.200
     5.229    17.383     0.200
     5.267    17.016     0.200
     5.386    16.608     0.200
     5.589    17.276     0.200
     5.724    18.354     0.200
     5.901    18.317     0.200
     5.951    18.660     0.200
     6.045    19.130     0.200
     6.104    18.891     0.200
     6.456    19.834     0.200
     6.484    20.130     0.200
     6.852    21.338     0.200
     6.901    21.196     0.200
     7.103    21.111     0.200
     7.777    23.381     0.200
     1.598    12.635     0.200
     1.881    13.142     0.200
     2.039    12.908     0.200
     2.391    14.104     0.200
     5.324    19.060     0.200
     5.438    19.245     0.200
     5.455    19.066     0.200
     5.528    19.564     0.200
     5.721    20.104     0.200
     5.807    20.325     0.200
     6.023    20.710     0.200
     6.111    21.026     0.200
     6.188    20.448     0.200
     6.233    20.468     0.200
     6.296    20.776     0.200
     6.644    21.828     0.200
     6.686    21.671     0.200
     7.083    19.868     0.200
     7.148    22.672     0.200
     7.279    23.594     0.200
     8.994    25.550     0.200
     1.346     9.829     0.200
     2.167    12.519     0.200
     2.573    13.711     0.200
     5.305    17.694     0.200
     5.593    18.568     0.200
     5.963    19.217     0.200
     6.064    19.069     0.200
     6.174    19.663     0.200
     6.455    20.761     0.200
     6.515    21.701     0.200
     6.964    19.188     0.200
     2.165    13.705     0.200
     2.592    13.234     0.200
     5.200    18.237     0.200
     5.308    17.905     0.200
     5.355    18.991     0.200
     5.455    19.005     0.200
     5.596    18.918     0.200
     5.837    19.720     0.200
     5.963    20.638     0.200
     6.068    19.973     0.200
     6.179    20.634     0.200
     6.457    21.943     0.200
     6.519    22.313     0.200
     6.969    19.915     0.200
     1.522    10.598     0.200
     1.581    10.393     0.200
     2.434    13.485     0.200
     2.915    12.291     0.200
     3.049    15.172     0.200
     3.347    16.211     0.200
     3.821    16.585     0.200
     4.834    17.056     0.200
     4.860    16.966     0.200
     5.634    18.349     0.200
     1.257    10.965     0.200
     1.489     9.297     0.200
     1.572     9.065     0.200
     1.627     8.644     0.200
     2.244    13.859     0.200
     2.318    13.097     0.200
     2.527    12.555     0.200
     2.656    12.561     0.200
     2.941    11.647     0.200
     2.941    12.452     0.200
     3.045    15.336     0.200
     2.999    13.037     0.200
     3.057    11.906     0.200
     3.135    12.636     0.200
     3.135    13.269     0.200
     3.246    13.250     0.200
     3.246    13.886     0.200
     3.384    13.743     0.200
     3.384    14.604     0.200
     3.300    15.026     0.200
     3.480    15.835     0.200
     3.559    16.219     0.200
     3.669    16.469     0.200
     3.772    16.359     0.200
     3.921    16.227     0.200
     4.107    16.618     0.200
     4.055    15.340     0.200
     4.475    16.614     0.200
     4.475    17.122     0.200
     4.534    15.843     0.200
     4.534    16.458     0.200
     4.598    16.583     0.200
     4.662    16.271     0.200
     4.662    16.523     0.200
     4.843    16.225     0.200
     4.867    16.588     0.200
     4.867    16.136     0.200
     4.869    16.786     0.200
     5.081    19.096     0.200
     5.160    16.829     0.200
     5.160    17.440     0.200
     5.208    17.301     0.200
     5.230    19.367     0.200
     5.274    17.555     0.200
     5.334    17.510     0.200
     5.334    17.270     0.200
     5.333    18.161     0.200
     5.416    17.728     0.200
     5.458    17.613     0.200
     5.535    17.707     0.200
     5.652    18.123     0.200
     5.652    18.881     0.200
     5.706    18.265     0.200
     5.842    18.593     0.200
     5.886    18.123     0.200
     5.886    18.888     0.200
     5.975    18.690     0.200
     5.975    19.375     0.200
     5.975    18.106     0.200
     6.039    19.490     0.200
     6.383    20.136     0.200
     6.417    19.825     0.200
     6.584    20.554     0.200
     6.831    20.883     0.200
     7.352    22.430     0.200
     7.531    23.446     0.200
     1.936     9.820     0.200
     1.936     9.515     0.200
     2.260    10.566     0.200
     2.516    10.950     0.200
     2.548    11.062     0.200
     2.548     9.695     0.200
     2.750    12.037     0.200
     2.859    11.364     0.200
     2.859    11.811     0.200
     3.121    12.537     0.200
     3.369    14.200     0.200
     3.534    13.785     0.200
     3.534    13.019     0.200
     3.867    15.335     0.200
     3.886    13.662     0.200
     3.899    13.875     0.200
     3.920    13.449     0.200
     3.920    13.815     0.200
     3.924    14.886     0.200
     4.025    14.603     0.200
     4.153    14.496     0.200
     4.153    15.021     0.200
     4.212    15.420     0.200
     4.228    14.934     0.200
     4.231    13.526     0.200
     4.262    15.085     0.200
     4.364    14.614     0.200
     4.364    14.827     0.200
     4.346    14.417     0.200
     4.481    14.869     0.200
     4.482    15.602     0.200
     4.728    15.515     0.200
     4.857    16.242     0.200
     4.908    15.610     0.200
     4.908    16.113     0.200
     5.164    16.193     0.200
     5.164    16.683     0.200
     5.164    16.561     0.200
     5.550    17.485     0.200
     5.582    17.502     0.200
     5.638    17.138     0.200
     6.011    17.979     0.200
     6.049    18.101     0.200
     7.244    21.741     0.200
     7.835    21.525     0.200
     7.957    22.086     0.200
     8.254    23.748     0.200
     1.697    11.475     0.200
     1.876    11.231     0.200
     4.516    16.288     0.200
     4.565    16.681     0.200
     4.864    16.779     0.200
     4.866    16.102     0.200
     5.173    17.088     0.200
     5.207    16.560     0.200
     5.841    18.571     0.200
     5.988    18.696     0.200
     6.401    19.898     0.200
     6.426    19.991     0.200
     1.138     7.369     0.200
     1.571    10.256     0.200
     1.854    11.497     0.200
     1.840    10.926     0.200
     1.915    11.056     0.200
     1.878    10.967     0.200
     2.121    11.180     0.200
     2.236    12.290     0.200
     2.236    11.364     0.200
     2.220    12.325     0.200
     2.267    10.595     0.200
     2.508    11.571     0.200
     2.784    12.568     0.200
     3.036    12.653     0.200
     4.152    15.057     0.200
     4.213    16.020     0.200
     4.142    16.480     0.200
     4.326    16.187     0.200
     4.540    13.424     0.200
     4.583    15.761     0.200
     4.603    16.841     0.200
     5.278    15.931     0.200
     5.477    15.163     0.200
     6.053    17.006     0.200
     6.166    17.101     0.200
     6.183    17.038     0.200
     6.253    17.669     0.200
     6.269    18.162     0.200
     6.292    17.506     0.200
     6.292    17.947     0.200
     6.393    17.148     0.200
     6.450    17.145     0.200
     6.450    17.891     0.200
     6.536    18.548     0.200
     6.689    18.315     0.200
     6.689    18.424     0.200
     6.699    18.467     0.200
     6.798    18.454     0.200
     6.828    18.072     0.200
     6.828    18.521     0.200
     6.878    18.382     0.200
     6.918    18.324     0.200
     7.026    18.643     0.200
     7.316    20.122     0.200
     7.576    19.346     0.200
     7.576    20.127     0.200
     7.813    17.498     0.200
     7.876    21.183     0.200
     8.009    21.196     0.200
     8.009    21.895     0.200
     8.105    21.258     0.200
     8.381    21.782     0.200
     8.420    22.603     0.200
     8.522    22.254     0.200
     9.797    25.139     0.200
    10.072    25.778     0.200
    10.419    26.762     0.200
     1.412    10.814     0.200
     1.543    10.620     0.200
     2.229    12.128     0.200
     2.204    13.056     0.200
     2.520    13.087     0.200
     3.276    14.250     0.200
     3.342    15.555     0.200
     4.590    17.853     0.200
     4.967    17.744     0.200
     5.765    20.215     0.200
     1.590    10.856     0.200
     1.906    12.607     0.200
     2.076    13.138     0.200
     2.366    13.937     0.200
     2.456    14.457     0.200
     2.620    14.524     0.200
     2.941    13.414     0.200
     2.941    13.827     0.200
     3.054    15.071     0.200
     3.371    14.919     0.200
     3.371    14.818     0.200
     3.342    16.453     0.200
     3.461    13.875     0.200
     3.823    17.533     0.200
     3.960    17.514     0.200
     4.082    17.527     0.200
     4.466    17.902     0.200
     4.534    17.960     0.200
     4.534    17.634     0.200
     4.865    16.515     0.200
     4.865    17.913     0.200
     4.891    17.616     0.200
     4.895    17.295     0.200
     4.895    17.933     0.200
     5.173    18.305     0.200
     5.173    18.604     0.200
     5.118    19.680     0.200
     5.232    18.243     0.200
     5.303    18.788     0.200
     5.481    18.841     0.200
     5.564    19.340     0.200
     5.662    19.560     0.200
     5.865    19.199     0.200
     5.904    18.980     0.200
     5.989    20.006     0.200
     5.989    21.131     0.200
     6.434    20.779     0.200
     6.583    22.058     0.200
     6.845    22.130     0.200
     1.386     9.155     0.200
     1.633     9.002     0.200
     1.966    10.953     0.200
     2.155    11.542     0.200
     2.438    13.801     0.200
     2.557    12.241     0.200
     2.772    13.385     0.200
     2.692    13.049     0.200
     2.692    12.442     0.200
     2.899    13.913     0.200
     2.817    13.167     0.200
     2.888    12.361     0.200
     3.347    15.007     0.200
     3.543    13.959     0.200
     3.655    13.822     0.200
     3.655    13.414     0.200
     3.686    13.843     0.200
     4.899    15.164     0.200
     4.899    15.779     0.200
     4.962    15.929     0.200
     4.962    16.167     0.200
     5.002    15.816     0.200
     5.002    16.189     0.200
     5.009    16.205     0.200
     5.009    16.645     0.200
     5.158    16.525     0.200
     5.158    16.848     0.200
     5.196    18.040     0.200
     5.196    16.657     0.200
     5.255    16.505     0.200
     5.262    16.570     0.200
     5.262    16.851     0.200
     5.281    16.165     0.200
     5.281    16.975     0.200
     5.480    16.562     0.200
     5.480    17.431     0.200
     5.485    17.624     0.200
     5.532    17.040     0.200
     5.532    17.399     0.200
     5.900    18.028     0.200
     5.998    17.967     0.200
     6.031    17.745     0.200
     6.031    18.586     0.200
     6.082    17.806     0.200
     6.186    18.711     0.200
     6.272    18.110     0.200
     6.272    19.297     0.200
     6.640    19.685     0.200
     6.649    19.203     0.200
     6.649    20.543     0.200
     6.714    19.912     0.200
     6.758    20.390     0.200
     7.113    20.677     0.200
     7.172    21.115     0.200
     7.723    22.607     0.200
     8.378    24.041     0.200
     8.712    24.468     0.200
     9.241    25.030     0.200
     1.585    11.077     0.200
     1.765    10.936     0.200
     2.010    12.310     0.200
     2.106    15.017     0.200
     2.278    12.619     0.200
     2.419    12.682     0.200
     2.469    13.412     0.200
     2.560    13.104     0.200
     2.561    14.300     0.200
     2.850    13.574     0.200
     2.936    12.836     0.200
     3.011    13.336     0.200
     3.011    12.664     0.200
     3.154    14.923     0.200
     3.159    15.830     0.200
     3.370    16.430     0.200
     3.370    14.861     0.200
     3.477    16.107     0.200
     3.477    14.691     0.200
     3.532    18.307     0.200
     3.590    15.564     0.200
     3.592    16.928     0.200
     3.623    15.206     0.200
     3.785    17.343     0.200
     3.905    16.388     0.200
     4.116    14.989     0.200
     4.223    17.369     0.200
     4.560    18.857     0.200
     4.601    18.388     0.200
     4.601    18.050     0.200
     4.697    17.877     0.200
     4.697    17.441     0.200
     4.858    16.810     0.200
     4.858    16.482     0.200
     4.869    17.781     0.200
     4.874    17.309     0.200
     4.874    17.542     0.200
     4.913    18.809     0.200
     5.194    18.183     0.200
     5.194    18.564     0.200
     5.214    18.147     0.200
     5.214    18.665     0.200
     5.317    19.521     0.200
     5.317    17.978     0.200
     5.324    19.506     0.200
     5.433    19.545     0.200
     5.465    19.158     0.200
     5.529    19.389     0.200
     5.694    19.876     0.200
     5.694    19.183     0.200
     5.848    19.785     0.200
     5.908    19.111     0.200
     6.009    20.068     0.200
     6.009    20.484     0.200
     6.009    19.787     0.200
     6.058    20.319     0.200
     6.426    21.394     0.200
     6.443    21.030     0.200
     6.652    21.665     0.200
     6.824    22.126     0.200
     6.865    22.301     0.200
     7.061    22.568     0.200
     7.751    24.664     0.200
     7.917    25.030     0.200
     1.204     9.198     0.200
     1.314     8.634     0.200
     1.377     9.174     0.200
     1.946    10.486     0.200
     2.665    12.116     0.200
     5.558    18.143     0.200
     5.658    17.871     0.200
     5.835    18.026     0.200
     6.250    18.881     0.200
     6.296    19.395     0.200
     6.757    21.053     0.200
     7.184    18.095     0.200
     7.522    21.700     0.200
     1.108     8.801     0.200
     1.180     9.451     0.200
     5.335    17.156     0.200
     5.432    17.326     0.200
     5.523    17.841     0.200
     5.614    18.128     0.200
     5.729    18.430     0.200
     6.054    19.589     0.200
     6.322    19.320     0.200
     7.115    17.592     0.200
     7.139    21.329     0.200
     7.335    21.707     0.200
     1.125     6.016     0.200
     1.125     6.539     0.200
     1.794     9.360     0.200
     1.945     9.384     0.200
     2.143    10.379     0.200
     2.527    12.043     0.200
     2.557    10.141     0.200
     2.666     9.377     0.200
     2.670     9.948     0.200
     3.063    11.057     0.200
     3.327    11.324     0.200
     3.327     9.886     0.200
     4.030    13.942     0.200
     4.030    11.700     0.200
     4.207    13.334     0.200
     4.207    12.951     0.200
     4.345    12.689     0.200
     4.378    12.080     0.200
     4.423    13.736     0.200
     4.352    13.349     0.200
     4.352    13.146     0.200
     4.660    14.176     0.200
     4.689    14.156     0.200
     4.689    13.500     0.200
     4.688    13.015     0.200
     4.755    14.606     0.200
     4.755    14.778     0.200
     4.822    14.481     0.200
     4.904    14.422     0.200
     4.904    13.828     0.200
     5.023    15.026     0.200
     5.110    15.349     0.200
     5.391    15.601     0.200
     5.391    14.507     0.200
     5.906    12.813     0.200
     6.238    16.393     0.200
     6.282    16.472     0.200
     1.291     8.983     0.200
     1.318     9.806     0.200
     1.651    11.196     0.200
     1.903    13.106     0.200
     2.136    12.468     0.200
     2.131    12.947     0.200
     2.189    12.551     0.200
     2.189    10.878     0.200
     2.400    13.133     0.200
     2.682    14.280     0.200
     2.957    13.159     0.200
     3.020    13.948     0.200
     4.456    15.193     0.200
     4.487    15.185     0.200
     4.589    15.918     0.200
     4.832    16.321     0.200
     4.978    16.416     0.200
     5.110    16.601     0.200
     5.139    16.794     0.200
     5.316    17.309     0.200
     5.365    17.658     0.200
     5.540    17.410     0.200
     5.607    18.460     0.200
     5.716    18.047     0.200
     6.105    16.318     0.200
     6.411    19.340     0.200
     1.426    10.042     0.200
     1.882    11.458     0.200
     2.048    12.307     0.200
     2.048    11.807     0.200
     2.405    14.036     0.200
     2.645    14.691     0.200
     2.694    15.328     0.200
     2.941    14.492     0.200
     2.941    14.601     0.200
     3.065    14.185     0.200
     3.119    13.905     0.200
     3.293    15.473     0.200
     3.417    14.744     0.200
     3.923    16.073     0.200
     4.751    15.969     0.200
     4.751    16.368     0.200
     4.805    17.110     0.200
     4.805    16.571     0.200
     4.805    17.438     0.200
     4.934    17.970     0.200
     5.023    17.513     0.200
     5.078    17.964     0.200
     5.078    18.917     0.200
     5.127    17.892     0.200
     5.129    18.438     0.200
     5.293    17.902     0.200
     5.353    18.566     0.200
     5.752    19.156     0.200
     5.838    18.972     0.200
     6.567    20.415     0.200
     6.936    21.566     0.200
     6.979    21.825     0.200
     1.652    11.423     0.200
     1.652    11.418     0.200
     1.841    12.313     0.200
     1.977    11.954     0.200
     2.191    14.208     0.200
     2.177    11.472     0.200
     2.367    13.592     0.200
     2.736    14.099     0.200
     2.840    13.649     0.200
     2.840    13.843     0.200
     2.947    14.338     0.200
     2.948    14.032     0.200
     3.606    16.732     0.200
     3.744    17.537     0.200
     3.769    16.629     0.200
     3.769    16.215     0.200
     3.961    14.797     0.200
     3.961    15.564     0.200
     3.961    15.627     0.200
     3.961    15.388     0.200
     4.301    16.594     0.200
     4.281    17.038     0.200
     4.281    17.563     0.200
     4.551    17.834     0.200
     4.789    17.738     0.200
     4.935    18.458     0.200
     4.991    18.669     0.200
     4.881    19.528     0.200
     4.881    20.167     0.200
     5.282    18.700     0.200
     5.522    20.139     0.200
     5.923    20.605     0.200
     5.952    20.909     0.200
     1.495     9.633     0.200
     1.568     9.748     0.200
     1.755    10.594     0.200
     1.755    10.750     0.200
     4.044    14.450     0.200
     4.043    14.900     0.200
     4.043    14.197     0.200
     4.384    15.347     0.200
     4.359    15.481     0.200
     5.071    17.407     0.200
     5.597    18.612     0.200
     5.998    19.257     0.200
     1.543    10.558     0.200
     1.580     8.923     0.200
     1.903     9.691     0.200
     2.143    13.767     0.200
     2.712    14.421     0.200
     3.170    15.109     0.200
     3.817    16.283     0.200
     4.511    15.583     0.200
     4.526    15.219     0.200
     4.884    17.036     0.200
     1.081     8.083     0.200
     1.237     8.417     0.200
     1.319     8.206     0.200
     1.319     7.612     0.200
     1.429     8.836     0.200
     1.564    10.112     0.200
     2.201    12.271     0.200
     2.283    13.193     0.200
     2.290    11.801     0.200
     2.468    11.309     0.200
     2.443    11.384     0.200
     2.443    11.071     0.200
     2.515    10.636     0.200
     3.336    10.852     0.200
     3.602    13.277     0.200
     4.496    13.972     0.200
     4.584    13.685     0.200
     4.584    14.130     0.200
     4.727    14.065     0.200
     4.727    14.354     0.200
     4.727    14.237     0.200
     4.805    14.584     0.200
     4.888    14.986     0.200
     5.010    15.085     0.200
     5.010    15.194     0.200
     5.042    15.532     0.200
     5.135    15.265     0.200
     5.185    15.624     0.200
     5.185    15.789     0.200
     5.195    15.506     0.200
     5.210    15.789     0.200
     5.373    15.640     0.200
     5.491    15.971     0.200
     5.725    16.769     0.200
     5.725    17.003     0.200
     5.752    16.667     0.200
     5.752    16.932     0.200
     5.806    17.231     0.200
     5.954    17.512     0.200
     5.954    17.145     0.200
     6.287    14.026     0.200
     6.286    17.915     0.200
     6.286    17.736     0.200
     6.466    18.462     0.200
     6.495    18.026     0.200
     6.495    18.441     0.200
     6.495    18.214     0.200
     6.563    18.444     0.200
     6.579    18.062     0.200
     6.777    19.454     0.200
     6.883    19.376     0.200
     1.056     8.882     0.200
     1.457     9.234     0.200
     1.758    11.321     0.200
     1.869    10.612     0.200
     1.937    11.148     0.200
     1.934    13.502     0.200
     2.023    10.424     0.200
     2.038     9.830     0.200
     2.027    12.350     0.200
     2.511    13.925     0.200
     2.701    12.563     0.200
     2.701    12.458     0.200
     2.701    12.557     0.200
     2.712    13.353     0.200
     2.630    13.066     0.200
     2.891    12.936     0.200
     2.890    13.700     0.200
     2.890    12.534     0.200
     3.173    11.924     0.200
     3.235    13.977     0.200
     3.322    13.073     0.200
     3.322    12.897     0.200
     3.546    13.788     0.200
     3.546    13.965     0.200
     3.742    15.270     0.200
     3.742    14.798     0.200
     3.767    13.940     0.200
     3.769    14.867     0.200
     3.793    13.847     0.200
     3.764    13.658     0.200
     3.992    17.553     0.200
     4.399    17.617     0.200
     4.729    17.052     0.200
     4.729    17.330     0.200
     4.836    15.806     0.200
     4.980    15.984     0.200
     4.980    15.619     0.200
     4.981    15.764     0.200
     4.981    15.986     0.200
     4.991    15.848     0.200
     4.991    15.736     0.200
     5.330    16.844     0.200
     5.330    17.000     0.200
     5.332    17.028     0.200
     5.357    18.305     0.200
     5.424    17.932     0.200
     5.581    17.237     0.200
     5.581    17.118     0.200
     5.537    19.582     0.200
     5.633    16.893     0.200
     5.837    18.547     0.200
     5.964    17.964     0.200
     6.036    18.491     0.200
     6.036    18.038     0.200
     6.087    19.858     0.200
     6.146    19.066     0.200
     6.146    18.920     0.200
     6.279    19.524     0.200
     6.575    19.380     0.200
     1.622     8.820     0.200
     1.508     7.903     0.200
     1.795     9.835     0.200
     1.883    10.408     0.200
     1.879     8.798     0.200
     1.882     8.975     0.200
     2.008    13.359     0.200
     2.310    10.763     0.200
     2.162    13.386     0.200
     2.503    11.929     0.200
     2.743    13.326     0.200
     2.690    12.604     0.200
     3.000    11.922     0.200
     3.000    12.414     0.200
     3.162    13.588     0.200
     3.053    15.365     0.200
     3.448    14.113     0.200
     3.502    13.868     0.200
     3.546    13.797     0.200
     3.476    14.814     0.200
     3.747    15.871     0.200
     3.689    15.551     0.200
     3.944    15.808     0.200
     4.284    17.359     0.200
     4.570    16.347     0.200
     4.636    15.412     0.200
     4.767    15.293     0.200
     4.767    15.055     0.200
     4.772    14.861     0.200
     4.772    15.111     0.200
     4.780    14.555     0.200
     4.780    15.325     0.200
     4.745    17.764     0.200
     5.118    15.993     0.200
     5.118    16.341     0.200
     5.130    16.471     0.200
     5.196    15.705     0.200
     5.196    16.326     0.200
     5.196    15.510     0.200
     5.219    18.632     0.200
     5.348    16.248     0.200
     5.370    16.686     0.200
     5.370    16.917     0.200
     5.370    16.221     0.200
     5.419    17.829     0.200
     5.457    19.161     0.200
     5.618    17.542     0.200
     5.640    17.562     0.200
     5.752    17.508     0.200
     5.752    17.804     0.200
     5.944    18.573     0.200
     5.944    18.733     0.200
     5.944    17.855     0.200
     5.944    18.222     0.200
     5.936    17.712     0.200
     5.936    19.376     0.200
     5.973    18.346     0.200
     6.370    18.978     0.200
     6.370    19.278     0.200
     6.373    19.384     0.200
     6.760    19.230     0.200
     6.775    19.866     0.200
     7.321    21.688     0.200
     7.703    21.913     0.200
     1.873    10.771     0.200
     1.939    10.889     0.200
     2.137    11.690     0.200
     4.819    16.245     0.200
     4.831    15.878     0.200
     5.176    16.819     0.200
     5.251    17.367     0.200
     5.264    16.920     0.200
     5.803    17.837     0.200
     5.990    18.695     0.200
     6.022    18.336     0.200
     6.417    19.816     0.200
     6.846    20.167     0.200
     1.245     9.865     0.200
     1.347    10.290     0.200
     1.804    11.155     0.200
     1.804    10.557     0.200
     2.344    12.002     0.200
     2.311    12.391     0.200
     2.458    10.961     0.200
     2.387    11.799     0.200
     2.573    13.068     0.200
     2.624    11.676     0.200
     2.624    11.371     0.200
     2.896    12.089     0.200
     3.197    14.840     0.200
     3.292    13.171     0.200
     3.292    12.300     0.200
     3.274    14.615     0.200
     3.429    13.691     0.200
     3.429    13.918     0.200
     3.459    13.625     0.200
     3.561    16.179     0.200
     3.561    13.700     0.200
     3.590    14.405     0.200
     3.591    16.268     0.200
     3.840    13.064     0.200
     3.840    13.340     0.200
     3.840    12.717     0.200
     3.889    13.361     0.200
     3.889    13.512     0.200
     3.889    13.012     0.200
     3.907    13.785     0.200
     3.907    12.722     0.200
     3.918    13.362     0.200
     3.862    15.194     0.200
     4.183    15.871     0.200
     4.193    13.747     0.200
     4.193    15.077     0.200
     4.193    13.454     0.200
     4.215    14.837     0.200
     4.215    14.987     0.200
     4.215    14.181     0.200
     4.231    15.349     0.200
     4.231    15.058     0.200
     4.225    15.167     0.200
     4.225    15.313     0.200
     4.255    14.493     0.200
     4.283    14.797     0.200
     4.380    14.709     0.200
     4.380    15.341     0.200
     4.454    15.759     0.200
     4.454    15.415     0.200
     4.467    14.598     0.200
     4.467    16.107     0.200
     4.467    14.818     0.200
     4.713    15.194     0.200
     4.929    15.821     0.200
     4.929    16.024     0.200
     5.004    16.750     0.200
     5.109    16.615     0.200
     5.175    17.313     0.200
     5.175    17.133     0.200
     5.175    17.805     0.200
     5.552    17.492     0.200
     5.612    16.911     0.200
     5.598    19.233     0.200
     5.636    17.672     0.200
     5.657    18.293     0.200
     5.793    17.299     0.200
     5.793    17.088     0.200
     5.855    18.182     0.200
     5.855    17.672     0.200
     6.019    18.845     0.200
     6.070    19.070     0.200
     6.088    18.630     0.200
     6.541    19.311     0.200
     7.277    21.982     0.200
     8.008    21.778     0.200
     1.352     9.603     0.200
     1.329     9.426     0.200
     1.934    11.491     0.200
     2.073    11.140     0.200
     2.348    12.022     0.200
     2.808    14.141     0.200
     3.228    15.707     0.200
     3.890    14.966     0.200
     5.543    18.556     0.200
     5.543    18.131     0.200
     5.667    19.318     0.200
     5.667    19.423     0.200
     5.826    19.704     0.200
     6.122    19.969     0.200
     6.215    19.319     0.200
     6.293    19.638     0.200
     6.401    20.994     0.200
     6.790    20.740     0.200
     7.188    19.033     0.200
     7.253    21.901     0.200
     1.192     9.672     0.200
     1.192     9.203     0.200
     1.816     9.407     0.200
     2.367    12.298     0.200
     2.465    10.722     0.200
     2.765    12.749     0.200
     3.053    13.333     0.200
     3.941    15.550     0.200
     4.078    15.079     0.200
     4.096    13.209     0.200
     4.478    15.379     0.200
     4.727    15.628     0.200
     4.933    15.728     0.200
     5.066    16.219     0.200
     5.288    17.129     0.200
     5.702    18.288     0.200
     5.734    17.691     0.200
     1.048     9.280     0.200
     1.133     9.368     0.200
     1.217    10.042     0.200
     1.882    10.240     0.200
     2.593    13.417     0.200
     2.770    13.140     0.200
     3.189    13.902     0.200
     3.215    14.771     0.200
     3.358    16.303     0.200
     3.468    14.982     0.200
     3.638    15.434     0.200
     3.638    15.201     0.200
     3.860    16.517     0.200
     4.377    15.500     0.200
     5.325    16.513     0.200
     5.225    16.823     0.200
     5.225    16.569     0.200
     5.325    16.995     0.200
     5.325    16.814     0.200
     5.512    17.085     0.200
     5.401    16.572     0.200
     5.407    17.178     0.200
     5.407    16.764     0.200
     5.500    17.185     0.200
     5.500    16.697     0.200
     5.620    17.518     0.200
     5.512    17.327     0.200
     5.620    17.881     0.200
     5.620    17.733     0.200
     5.798    17.995     0.200
     5.742    18.009     0.200
     5.742    17.730     0.200
     5.798    18.104     0.200
     5.956    18.269     0.200
     5.864    18.043     0.200
     5.864    17.459     0.200
     5.975    18.673     0.200
     5.955    18.388     0.200
     5.956    18.581     0.200
     5.975    18.339     0.200
     6.098    18.541     0.200
     6.211    18.681     0.200
     6.526    19.882     0.200
     6.526    19.232     0.200
     6.542    19.770     0.200
     6.716    20.122     0.200
     6.716    19.708     0.200
     7.004    16.977     0.200
     6.758    20.238     0.200
     7.206    21.284     0.200
     7.206    21.038     0.200
     7.236    21.103     0.200
     7.352    21.270     0.200
     7.361    20.258     0.200
     7.531    21.852     0.200
     7.546    21.434     0.200
     7.652    22.261     0.200
     7.771    22.018     0.200
     8.914    25.044     0.200
     8.914    23.946     0.200
     9.668    25.932     0.200
     1.870    12.377     0.200
     2.356    13.755     0.200
     2.529    14.083     0.200
     2.609    15.232     0.200
     2.572    15.030     0.200
     2.602    13.818     0.200
     2.691    13.636     0.200
     2.691    13.898     0.200
     2.907    15.914     0.200
     2.907    16.281     0.200
     3.058    14.938     0.200
     3.230    16.460     0.200
     3.296    15.994     0.200
     3.296    16.864     0.200
     3.296    15.153     0.200
     3.371    16.098     0.200
     3.588    16.202     0.200
     3.588    15.459     0.200
     3.563    17.565     0.200
     3.563    16.927     0.200
     3.932    17.666     0.200
     4.023    17.171     0.200
     4.023    15.176     0.200
     4.097    18.602     0.200
     4.156    18.054     0.200
     4.267    18.881     0.200
     4.267    17.435     0.200
     4.447    17.393     0.200
     4.465    18.350     0.200
     4.538    18.703     0.200
     4.605    18.143     0.200
     4.660    18.816     0.200
     5.170    19.892     0.200
     5.150    20.787     0.200
     5.203    20.346     0.200
     5.426    20.601     0.200
     5.512    19.754     0.200
     5.559    20.180     0.200
     5.512    20.157     0.200
     5.614    20.519     0.200
     5.697    19.595     0.200
     5.811    20.000     0.200
     5.811    20.448     0.200
     5.811    19.646     0.200
     5.829    19.793     0.200
     5.832    20.300     0.200
     5.832    19.405     0.200
     5.832    19.925     0.200
     6.152    22.190     0.200
     6.168    20.859     0.200
     6.196    22.113     0.200
     6.185    21.530     0.200
     6.192    20.574     0.200
     6.213    20.486     0.200
     6.213    21.515     0.200
     6.213    20.778     0.200
     6.213    21.092     0.200
     6.238    21.347     0.200
     6.238    22.211     0.200
     6.406    22.299     0.200
     6.420    20.628     0.200
     6.420    21.268     0.200
     6.453    21.451     0.200
     6.453    22.096     0.200
     6.669    22.807     0.200
     6.699    21.684     0.200
     6.801    22.353     0.200
     6.903    23.688     0.200
     7.010    23.967     0.200
     7.006    23.078     0.200
     7.006    22.470     0.200
     7.006    22.796     0.200
     7.030    23.481     0.200
     7.431    22.883     0.200
     7.432    23.539     0.200
     7.832    24.569     0.200
     7.862    24.328     0.200
     1.100     9.824     0.200
     1.340    10.544     0.200
     1.685    11.335     0.200
     2.276    12.820     0.200
     2.276    13.447     0.200
     2.411    12.673     0.200
     2.562    12.753     0.200
     2.843    12.956     0.200
     2.924    14.543     0.200
     3.037    14.082     0.200
     3.108    14.974     0.200
     3.187    14.474     0.200
     3.505    14.845     0.200
     3.505    14.205     0.200
     3.557    14.694     0.200
     3.813    17.343     0.200
     3.728    16.257     0.200
     4.092    17.421     0.200
     4.193    16.846     0.200
     4.300    17.548     0.200
     4.429    17.252     0.200
     4.534    18.060     0.200
     4.665    17.113     0.200
     4.913    16.801     0.200
     4.959    16.877     0.200
     4.959    17.068     0.200
     4.858    18.858     0.200
     4.983    17.031     0.200
     5.165    18.019     0.200
     5.301    17.478     0.200
     5.478    17.565     0.200
     5.478    18.080     0.200
     5.478    18.625     0.200
     5.496    18.522     0.200
     5.627    18.540     0.200
     5.666    19.262     0.200
     5.794    19.037     0.200
     5.892    19.701     0.200
     5.931    18.589     0.200
     5.931    19.149     0.200
     5.977    19.299     0.200
     5.977    19.768     0.200
     6.098    19.904     0.200
     6.351    20.116     0.200
     6.264    22.105     0.200
     6.441    20.749     0.200
     6.830    20.957     0.200
     1.411     7.531     0.200
     1.669     8.985     0.200
     1.725    10.108     0.200
     2.029    11.227     0.200
     2.463    12.599     0.200
     2.698    12.312     0.200
     2.760    11.022     0.200
     2.760    13.245     0.200
     2.760    11.679     0.200
     2.887    13.116     0.200
     3.201    12.496     0.200
     3.322    15.135     0.200
     3.946    15.529     0.200
     3.946    15.429     0.200
     3.964    15.664     0.200
     3.995    15.382     0.200
     4.108    15.737     0.200
     4.282    16.478     0.200
     4.282    14.761     0.200
     4.508    15.420     0.200
     4.519    14.654     0.200
     4.519    14.766     0.200
     4.519    15.511     0.200
     4.524    14.596     0.200
     4.524    15.275     0.200
     4.524    15.603     0.200
     4.849    15.601     0.200
     4.849    16.127     0.200
     4.863    15.150     0.200
     4.863    16.073     0.200
     4.917    16.371     0.200
     4.918    17.505     0.200
     4.970    16.611     0.200
     4.975    15.936     0.200
     5.083    16.501     0.200
     5.180    16.645     0.200
     5.353    17.343     0.200
     5.363    17.210     0.200
     5.497    16.219     0.200
     5.497    17.169     0.200
     5.663    17.486     0.200
     5.663    19.110     0.200
     5.663    18.318     0.200
     5.663    18.441     0.200
     5.708    18.054     0.200
     6.086    19.012     0.200
     6.096    18.909     0.200
     6.520    20.129     0.200
     1.262     6.954     0.200
     1.990     8.875     0.200
     2.373    10.191     0.200
     3.473    10.621     0.200
     3.509    11.111     0.200
     3.509    10.956     0.200
     4.092    12.167     0.200
     5.154    15.610     0.200
     1.727     9.470     0.200
     2.042     9.548     0.200
     2.671     9.850     0.200
     2.896    12.935     0.200
     2.873    11.714     0.200
     3.041    10.852     0.200
     2.938    12.279     0.200
     3.536    12.958     0.200
     3.893    13.126     0.200
     4.084    13.561     0.200
     1.968     9.898     0.200
     1.961    11.419     0.200
     1.961     9.419     0.200
     2.500    12.857     0.200
     3.458    13.774     0.200
     3.568    14.316     0.200
     3.910    13.547     0.200
     4.827    15.370     0.200
     4.888    15.680     0.200
     5.072    17.238     0.200
     5.175    17.676     0.200
     5.188    17.232     0.200
     5.400    17.720     0.200
     5.460    17.857     0.200
     5.828    18.398     0.200
     5.950    18.288     0.200
     6.194    18.736     0.200
     1.836     9.125     0.200
     2.302    10.524     0.200
     2.469    10.935     0.200
     2.660    11.714     0.200
     3.579    11.422     0.200
     3.514    13.763     0.200
     3.596    11.788     0.200
     3.633    14.127     0.200
     3.644    13.252     0.200
     3.788    11.798     0.200
     3.907    12.593     0.200
     3.957    13.005     0.200
     4.159    13.072     0.200
     4.619    14.054     0.200
     0.696     6.639     0.200
     0.961     7.626     0.200
     1.708     8.828     0.200
     1.708     8.265     0.200
     2.237    11.051     0.200
     2.437    10.588     0.200
     2.461     9.981     0.200
     2.537    11.168     0.200
     2.741    12.361     0.200
     2.866    11.402     0.200
     2.967    12.556     0.200
     3.139    11.929     0.200
     3.139    12.257     0.200
     3.531    13.070     0.200
     4.183    12.141     0.200
     4.183    13.829     0.200
     4.183    14.009     0.200
     4.220    13.287     0.200
     4.227    13.033     0.200
     4.227    13.705     0.200
     4.360    13.960     0.200
     4.449    13.146     0.200
     4.449    14.731     0.200
     4.449    13.567     0.200
     4.409    13.607     0.200
     4.409    13.888     0.200
     4.497    14.421     0.200
     4.505    13.988     0.200
     4.505    15.081     0.200
     4.552    14.142     0.200
     4.552    14.798     0.200
     4.697    14.450     0.200
     4.725    14.826     0.200
     4.756    14.633     0.200
     5.250    15.204     0.200
     5.250    15.759     0.200
     5.324    15.607     0.200
     5.488    15.716     0.200
     5.488    16.684     0.200
     5.488    16.169     0.200
     5.857    16.480     0.200
     5.940    18.042     0.200
     5.940    16.745     0.200
     5.967    17.174     0.200
     1.511     8.426     0.200
     1.591     8.115     0.200
     1.552     8.827     0.200
     1.753     9.525     0.200
     2.288     9.505     0.200
     2.288     8.911     0.200
     2.658    10.345     0.200
     2.658    10.775     0.200
     2.829    12.070     0.200
     3.023    11.602     0.200
     3.620    13.627     0.200
     3.679    14.997     0.200
     3.873    13.753     0.200
     4.092    12.174     0.200
     4.092    12.865     0.200
     4.092    11.943     0.200
     4.111    14.070     0.200
     4.111    14.708     0.200
     4.214    13.905     0.200
     4.275    14.809     0.200
     4.557    15.156     0.200
     4.916    14.221     0.200
     5.122    15.112     0.200
     1.323    10.813     0.200
     1.971    12.388     0.200
     1.971    12.272     0.200
     2.540    14.142     0.200
     3.109    14.194     0.200
     3.143    16.141     0.200
     3.524    16.058     0.200
     3.618    16.719     0.200
     4.134    17.803     0.200
     5.350    18.237     0.200
     5.433    18.901     0.200
     5.433    17.465     0.200
     5.900    19.182     0.200
     6.346    20.353     0.200
     6.569    19.896     0.200
     1.912    10.732     0.200
     2.209    10.741     0.200
     2.209     9.920     0.200
     2.429    11.945     0.200
     2.969    12.523     0.200
     3.251    12.676     0.200
     3.500    12.884     0.200
     3.794    14.722     0.200
     3.794    14.105     0.200
     3.841    14.980     0.200
     4.313    14.333     0.200
     4.313    15.029     0.200
     4.428    15.017     0.200
     4.458    15.082     0.200
     4.458    14.840     0.200
     4.502    16.315     0.200
     4.520    15.560     0.200
     4.520    15.138     0.200
     4.515    16.421     0.200
     4.559    15.729     0.200
     4.559    15.331     0.200
     4.693    14.765     0.200
     4.693    15.194     0.200
     4.711    16.174     0.200
     4.711    15.893     0.200
     4.803    16.110     0.200
     4.865    17.370     0.200
     4.877    17.361     0.200
     5.113    16.950     0.200
     5.287    17.251     0.200
     5.346    17.272     0.200
     5.346    17.139     0.200
     5.526    19.430     0.200
     5.579    17.397     0.200
     5.690    17.303     0.200
     5.690    17.131     0.200
     5.848    18.050     0.200
     6.138    18.359     0.200
     6.182    18.113     0.200
     6.273    18.004     0.200
     6.623    19.558     0.200
     6.713    19.327     0.200
     6.925    21.001     0.200
     6.997    20.023     0.200
     8.543    23.131     0.200
     1.577    12.810     0.200
     1.734    12.475     0.200
     3.857    17.260     0.200
     4.012    15.927     0.200
     4.012    18.908     0.200
     4.112    18.952     0.200
     4.410    17.725     0.200
     4.524    16.592     0.200
     4.539    17.452     0.200
     4.780    15.935     0.200
     4.780    18.195     0.200
     4.851    17.177     0.200
     4.851    17.893     0.200
     4.910    16.748     0.200
     4.910    18.618     0.200
     5.053    18.623     0.200
     5.126    17.849     0.200
     5.126    19.115     0.200
     5.307    18.580     0.200
     5.411    18.142     0.200
     5.411    18.535     0.200
     5.400    17.763     0.200
     5.400    18.643     0.200
     5.468    18.779     0.200
     5.468    20.047     0.200
     5.527    17.571     0.200
     5.527    19.385     0.200
     5.527    18.725     0.200
     5.527    19.077     0.200
     5.530    19.087     0.200
     5.530    19.200     0.200
     5.530    18.688     0.200
     5.639    19.372     0.200
     5.710    19.052     0.200
     5.710    19.775     0.200
     5.791    18.893     0.200
     5.791    19.160     0.200
     5.768    20.197     0.200
     5.769    21.485     0.200
     6.076    20.997     0.200
     6.146    19.919     0.200
     6.215    20.275     0.200
     6.379    20.827     0.200
     6.364    20.744     0.200
     6.364    20.520     0.200
     6.433    20.462     0.200
     6.681    21.714     0.200
     6.681    21.449     0.200
     6.791    21.710     0.200
     6.791    21.372     0.200
     6.952    21.387     0.200
     6.952    22.004     0.200
     6.952    21.824     0.200
     7.097    22.281     0.200
     7.170    21.947     0.200
     7.240    22.688     0.200
     7.233    23.029     0.200
     7.357    22.097     0.200
     7.357    23.730     0.200
     7.692    22.585     0.200
     7.744    22.896     0.200
     7.744    24.546     0.200
     7.744    22.757     0.200
     7.753    24.724     0.200
     7.753    26.140     0.200
     7.941    22.529     0.200
     7.941    23.647     0.200
     7.941    23.256     0.200
     8.465    24.953     0.200
     8.465    25.359     0.200
     8.793    25.523     0.200
     8.845    25.429     0.200
     8.947    23.988     0.200
     9.110    26.223     0.200
     9.193    27.333     0.200
     9.454    26.869     0.200
     9.503    25.771     0.200
     9.456    27.359     0.200
     9.456    29.070     0.200
     9.502    26.055     0.200
     9.650    28.788     0.200
     9.959    28.879     0.200
     9.959    28.699     0.200
    10.102    25.005     0.200
    10.280    29.765     0.200
    11.487    33.330     0.200
    12.233    33.294     0.200
    13.616    36.737     0.200
    13.982    34.964     0.200
    19.954    42.929     0.200
    20.290    42.533     0.200
    20.330    42.312     0.200
    20.361    42.188     0.200
    20.576    42.304     0.200
    20.593    42.060     0.200
    21.245    41.567     0.200
     1.655    12.281     0.200
     1.655    12.267     0.200
     1.073    11.631     0.200
     2.138    12.458     0.200
     2.911    15.275     0.200
     2.911    12.240     0.200
     3.058    13.789     0.200
     3.878    16.299     0.200
     3.933    15.228     0.200
     4.142    16.790     0.200
     4.189    16.916     0.200
     4.282    17.110     0.200
     4.455    16.943     0.200
     4.455    17.586     0.200
     4.489    16.540     0.200
     4.801    17.254     0.200
     4.801    18.373     0.200
     5.019    18.019     0.200
     5.598    15.214     0.200
     5.736    19.762     0.200
     1.913    11.554     0.200
     1.913    11.396     0.200
     1.913    11.105     0.200
     2.739    13.718     0.200
     2.739    12.785     0.200
     2.812    12.937     0.200
     2.866    14.688     0.200
     2.866    14.166     0.200
     2.866    12.756     0.200
     3.018    12.869     0.200
     3.272    14.079     0.200
     3.272    13.083     0.200
     3.295    15.083     0.200
     3.388    14.685     0.200
     3.410    13.685     0.200
     3.641    14.772     0.200
     3.641    13.530     0.200
     3.744    15.078     0.200
     3.744    14.963     0.200
     3.747    14.753     0.200
     3.747    13.772     0.200
     3.902    14.461     0.200
     3.902    13.633     0.200
     4.030    15.046     0.200
     4.160    16.561     0.200
     4.160    14.811     0.200
     4.269    17.392     0.200
     4.270    16.323     0.200
     4.672    14.952     0.200
     4.672    15.915     0.200
     4.731    15.549     0.200
     4.731    16.139     0.200
     4.765    16.366     0.200
     4.765    15.013     0.200
     4.767    16.401     0.200
     4.767    15.716     0.200
     4.910    17.114     0.200
     4.910    16.317     0.200
     4.930    19.795     0.200
     4.985    16.713     0.200
     4.985    15.545     0.200
     4.994    16.485     0.200
     5.017    17.783     0.200
     5.017    18.015     0.200
     5.017    16.634     0.200
     5.038    16.436     0.200
     5.052    17.026     0.200
     5.052    16.015     0.200
     5.238    16.656     0.200
     5.238    17.478     0.200
     5.267    17.260     0.200
     5.267    17.147     0.200
     5.303    17.933     0.200
     5.303    17.066     0.200
     5.303    17.347     0.200
     5.341    18.075     0.200
     5.548    17.631     0.200
     5.561    18.917     0.200
     5.561    19.292     0.200
     5.673    17.883     0.200
     5.673    18.683     0.200
     5.758    19.373     0.200
     5.787    18.277     0.200
     5.787    17.758     0.200
     5.847    19.074     0.200
     5.847    18.916     0.200
     5.953    19.162     0.200
     6.032    18.795     0.200
     6.032    19.043     0.200
     6.032    18.090     0.200
     6.032    18.934     0.200
     6.199    22.193     0.200
     6.199    20.943     0.200
     6.405    20.084     0.200
     6.405    19.873     0.200
     6.404    19.629     0.200
     6.405    19.621     0.200
     6.466    19.484     0.200
     6.515    20.189     0.200
     6.570    19.194     0.200
     6.570    20.427     0.200
     6.686    21.046     0.200
     6.686    20.210     0.200
     6.686    21.327     0.200
     6.874    20.684     0.200
     6.928    21.137     0.200
     6.932    20.500     0.200
     7.390    21.780     0.200
     7.479    21.676     0.200
     7.479    22.147     0.200
     7.479    21.867     0.200
     7.510    22.305     0.200
     7.857    23.113     0.200
     8.131    23.146     0.200
     8.131    23.378     0.200
     8.357    24.117     0.200
     8.468    24.102     0.200
     8.720    24.553     0.200
     8.858    24.861     0.200
    10.688    28.623     0.200
    12.229    32.784     0.200
    16.760    39.418     0.200
     6.571    20.081     0.200
    12.229    31.995     0.200
     2.493    10.414     0.200
     2.538     9.768     0.200
     2.538     9.274     0.200
     2.748    11.359     0.200
     2.748    11.154     0.200
     2.987    10.557     0.200
     2.987    10.868     0.200
     3.127    11.250     0.200
     3.127    11.836     0.200
     3.250    12.267     0.200
     3.353    12.858     0.200
     3.741    13.820     0.200
     4.014    15.537     0.200
     4.081    13.515     0.200
     4.081    12.759     0.200
     4.125    11.975     0.200
     4.125    12.340     0.200
     4.125    12.162     0.200
     4.140    14.241     0.200
     4.147    12.692     0.200
     4.147    11.876     0.200
     4.146    11.999     0.200
     4.482    13.632     0.200
     4.482    13.220     0.200
     4.482    13.736     0.200
     4.504    13.882     0.200
     4.538    13.868     0.200
     4.538    13.730     0.200
     4.542    13.576     0.200
     4.559    14.011     0.200
     4.724    14.205     0.200
     4.734    13.383     0.200
     4.771    13.709     0.200
     4.771    13.893     0.200
     4.982    14.813     0.200
     5.063    14.628     0.200
     5.063    13.880     0.200
     5.115    13.889     0.200
     5.115    15.010     0.200
     5.213    14.979     0.200
     5.213    14.284     0.200
     5.291    18.022     0.200
     5.291    17.108     0.200
     5.348    15.169     0.200
     5.348    14.671     0.200
     5.348    15.277     0.200
     5.759    15.853     0.200
     5.796    16.169     0.200
     6.124    16.850     0.200
     6.201    16.748     0.200
     6.722    18.786     0.200
     6.743    18.492     0.200
     7.133    19.253     0.200
     7.355    19.658     0.200
     7.612    19.758     0.200
     8.099    20.925     0.200
     8.400    22.455     0.200
     1.495    10.317     0.200
     1.822    11.547     0.200
     2.734    12.179     0.200
     3.511    13.298     0.200
     3.388    15.720     0.200
     3.579    13.292     0.200
     3.627    13.295     0.200
     3.681    12.769     0.200
     3.959    14.384     0.200
     4.100    14.279     0.200
     4.146    14.749     0.200
     4.137    14.712     0.200
     4.174    14.903     0.200
     4.512    14.459     0.200
     4.700    15.113     0.200
     4.803    16.443     0.200
     4.916    16.683     0.200
     5.267    16.943     0.200
     5.524    17.976     0.200
     5.510    16.727     0.200
     5.551    18.973     0.200
     6.269    21.638     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.600    20.960     0.200
     3.212    24.817     0.200
     4.327    28.806     0.200
     4.815    35.804     0.200
     2.882    19.781     0.200
     3.309    25.199     0.200
     6.081    48.458     0.200
     2.751    20.015     0.200
     2.760    17.906     0.200
     5.042    34.278     0.200
     6.586    46.262     0.200
     7.009    50.422     0.200
     2.803    20.342     0.200
     2.846    21.140     0.200
     2.665    18.272     0.200
     3.230    21.182     0.200
     3.352    21.759     0.200
     4.436    28.109     0.200
     4.638    30.753     0.200
     2.721    19.328     0.200
     3.507    26.395     0.200
     4.121    31.227     0.200
     4.427    30.264     0.200
     4.279    29.040     0.200
     4.384    31.809     0.200
     3.107    21.639     0.200
     2.672    20.237     0.200
     2.920    22.423     0.200
     2.514    16.958     0.200
     2.982    19.621     0.200
     2.865    19.027     0.200
     2.912    23.913     0.200
     4.868    31.000     0.200
     3.034    23.751     0.200
     2.692    18.715     0.200
     3.629    25.636     0.200
     4.067    30.694     0.200
     4.291    31.012     0.200
     2.964    23.135     0.200
     3.402    24.407     0.200
     2.793    21.076     0.200
     3.046    21.132     0.200
     3.483    30.217     0.200
     4.645    29.696     0.200
     4.651    36.619     0.200
     3.260    22.733     0.200
     3.258    23.028     0.200
     4.335    32.311     0.200
     4.457    31.008     0.200
     2.795    20.255     0.200
     3.088    24.538     0.200
     2.873    21.732     0.200
     2.715    19.547     0.200
     2.881    20.297     0.200
     2.565    17.729     0.200
     3.554    26.099     0.200
     2.691    19.513     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.376    10.247     0.200
     4.327    25.806     0.200
     0.743     6.319     0.200
     1.458    12.980     0.200
     2.146    16.948     0.200
     2.374    17.286     0.200
     4.815    27.804     0.200
     0.614     5.668     0.200
     2.016    14.301     0.200
     1.672    11.909     0.200
     1.672    13.409     0.200
     2.017    14.882     0.200
     2.357    15.909     0.200
     0.189     3.418     0.200
     1.822    12.163     0.200
     2.751    15.015     0.200
     6.586    32.262     0.200
     0.603     5.181     0.200
     1.183     5.410     0.200
     3.055    18.564     0.200
     7.009    37.422     0.200
     0.609     6.547     0.200
     1.205     6.484     0.200
     1.769    13.398     0.200
     2.250    15.567     0.200
     4.957    25.677     0.200
     5.533    28.451     0.200
     5.533    29.451     0.200
     5.533    31.451     0.200
     0.149     3.951     0.200
     0.701     7.203     0.200
     1.070     7.696     0.200
     0.773     6.882     0.200
     0.998     9.356     0.200
     0.764     6.501     0.200
     0.779     6.819     0.200
     0.822     7.820     0.200
     0.899     9.421     0.200
     1.054     8.615     0.200
     0.523     6.443     0.200
     0.674     5.984     0.200
     1.198     9.865     0.200
     1.120    10.277     0.200
     1.557    12.180     0.200
     1.684    12.702     0.200
     1.704    12.457     0.200
     1.879    13.926     0.200
     1.917    12.255     0.200
     2.369    14.797     0.200
     2.434    15.941     0.200
     0.646     5.050     0.200
     0.746     7.681     0.200
     0.943     7.594     0.200
     1.128     9.427     0.200
     1.412     9.621     0.200
     1.486    10.753     0.200
     1.574    10.223     0.200
     1.642    11.435     0.200
     1.761    11.044     0.200
     2.083    12.984     0.200
     0.215     2.060     0.200
     0.274     2.867     0.200
     0.826     7.431     0.200
     1.138     9.585     0.200
     1.361     9.988     0.200
     1.644    10.684     0.200
     1.738    11.581     0.200
     2.046    12.988     0.200
     2.950    17.645     0.200
     0.645     7.131     0.200
     0.830     6.277     0.200
     0.956     7.511     0.200
     1.297    11.024     0.200
     0.220     2.450     0.200
     0.792     6.772     0.200
     1.205     7.957     0.200
     2.154    15.391     0.200
     2.110    13.399     0.200
     0.756     6.625     0.200
     1.890    14.400     0.200
     5.854    32.331     0.200
     0.700     6.680     0.200
     1.693    12.098     0.200
     1.693    13.098     0.200
     3.251    18.913     0.200
     0.783     6.651     0.200
     3.231    18.782     0.200
     0.906     6.669     0.200
     1.790    12.642     0.200
     0.667     6.166     0.200
     0.456     4.733     0.200
     2.064    13.578     0.200
     2.358    13.510     0.200
     0.750     7.013     0.200
     2.208    11.634     0.200
     2.293    11.775     0.200
     2.386    12.220     0.200
     2.422    12.598     0.200
     0.577     5.190     0.200
     2.150    15.327     0.200
     0.610     5.069     0.200
     0.897     8.930     0.200
     1.103     8.523     0.200
     1.392     9.649     0.200
     0.360     3.978     0.200
     1.374    10.044     0.200
     1.378     9.998     0.200
     0.705     6.406     0.200
     1.153    10.174     0.200
     1.243    10.125     0.200
     1.807    13.544     0.200
     2.021    14.045     0.200
     2.103    15.085     0.200
     2.301    15.778     0.200
     0.167     2.704     0.200
     1.059     9.795     0.200
     1.990    14.654     0.200
     1.091     8.156     0.200
     0.155     1.813     0.200
     0.424     3.665     0.200
     1.555    11.969     0.200
     1.792    12.699     0.200
     0.140     1.634     0.200
     0.461     3.391     0.200
     0.130     1.959     0.200
     0.390     4.422     0.200
     0.836     7.718     0.200
     1.055     9.162     0.200
     1.214     9.807     0.200
     1.880    15.030     0.200
     0.404     5.449     0.200
     0.651     6.375     0.200
     0.798     7.059     0.200
     1.110    10.410     0.200
     1.125     9.240     0.200
     2.157    16.195     0.200
     0.562     5.054     0.200
     0.946     7.421     0.200
     0.991     8.895     0.200
     1.051     8.195     0.200
     1.402    10.104     0.200
     0.766     7.670     0.200
     0.855     7.631     0.200
     0.983     9.135     0.200
     1.155     9.130     0.200
     1.352     9.837     0.200
     0.754     7.098     0.200
     0.804     7.520     0.200
     1.049     8.661     0.200
     1.191     9.996     0.200
     0.359     4.357     0.200
     0.842     6.715     0.200
     0.976     7.154     0.200
     1.280     9.602     0.200
     0.313     3.886     0.200
     0.815     6.023     0.200
     0.947     6.983     0.200
     1.082     7.903     0.200
     1.054     9.232     0.200
     1.166     8.928     0.200
     1.263     8.794     0.200
     0.765     7.089     0.200
     0.771     8.021     0.200
     0.996     8.399     0.200
     0.843     7.036     0.200
     0.926     7.204     0.200
     1.337    11.269     0.200
     1.966    12.938     0.200
     3.567    21.243     0.200
     5.421    29.614     0.200
     5.433    29.470     0.200
     0.104     1.362     0.200
     0.377     4.675     0.200
     0.866     7.465     0.200
     1.333    10.011     0.200
     1.425    11.439     0.200
     0.926     8.120     0.200
     1.332    10.782     0.200
     0.184     2.978     0.200
     1.064     8.205     0.200
     1.087     8.939     0.200
     2.032    16.313     0.200
     0.212     3.058     0.200
     0.569     4.895     0.200
     1.227     9.209     0.200
     1.053     8.238     0.200
     1.485    11.207     0.200
     2.105    12.960     0.200
     0.117     3.957     0.200
     0.626     7.014     0.200
     1.520    11.087     0.200
     1.594     9.723     0.200
     1.987    12.131     0.200
     0.345     3.061     0.200
     0.603     6.548     0.200
     1.062     8.189     0.200
     1.008     8.817     0.200
     0.943    10.575     0.200
     0.977     8.265     0.200
     1.116     9.644     0.200
     1.276     9.770     0.200
     0.662     4.146     0.200
     0.471     5.367     0.200
     0.885     8.542     0.200
     1.088     7.672     0.200
     1.290     9.808     0.200
     1.657     9.498     0.200
     2.404    14.441     0.200
     2.409    14.356     0.200
     0.599     5.698     0.200
     0.599     6.698     0.200
     1.028    10.698     0.200
     1.028     9.698     0.200
     1.232    10.315     0.200
     0.148     2.207     0.200
     0.305     3.373     0.200
     0.568     5.615     0.200
     0.884     8.619     0.200
     0.970     8.609     0.200
     1.296     9.811     0.200
     1.284     9.946     0.200
     1.449    11.015     0.200
     1.643    11.658     0.200
     0.275     3.857     0.200
     0.775     5.519     0.200
     0.964     7.314     0.200
     1.270     9.243     0.200
     1.204    10.509     0.200
     1.737    12.288     0.200
     2.277    12.986     0.200
     2.327    13.909     0.200
     0.553     5.258     0.200
     0.537     5.446     0.200
     1.181     8.929     0.200
     1.269     9.908     0.200
     1.439    11.416     0.200
     1.657    11.377     0.200
     1.807    12.628     0.200
     1.924    12.767     0.200
     2.099    16.015     0.200
     0.258     3.718     0.200
     0.757     6.897     0.200
     1.197     8.263     0.200
     1.404    10.353     0.200
     1.820    12.497     0.200
     2.010    12.274     0.200
     2.119    14.004     0.200
     2.119    13.301     0.200
     0.285     3.146     0.200
     1.331     9.931     0.200
     1.537    10.527     0.200
     1.530    11.107     0.200
     1.701    10.616     0.200
     1.600    10.090     0.200
     1.979    13.369     0.200
     0.286     3.450     0.200
     0.518     4.750     0.200
     1.351    11.526     0.200
     1.541    11.311     0.200
     1.553    12.670     0.200
     0.464     4.892     0.200
     0.581     5.536     0.200
     1.087     9.626     0.200
     1.240     9.847     0.200
     1.342    11.652     0.200
     0.250     3.073     0.200
     0.447     4.780     0.200
     0.714     6.660     0.200
     1.247     9.443     0.200
     1.471    10.823     0.200
     0.406     4.363     0.200
     0.874     7.407     0.200
     0.937     9.670     0.200
     1.336    10.016     0.200
     1.648    12.372     0.200
     0.610     5.468     0.200
     0.610     4.968     0.200
     0.554     6.123     0.200
     0.554     5.623     0.200
     1.183     9.780     0.200
     1.537    12.647     0.200
     0.672     7.226     0.200
     0.807     7.648     0.200
     1.020     8.161     0.200
     1.152     8.627     0.200
     1.150     8.652     0.200
     1.503    10.534     0.200
     1.642    10.903     0.200
     0.233     1.896     0.200
     0.368     3.327     0.200
     1.278     9.701     0.200
     1.618    11.731     0.200
     0.308     3.655     0.200
     0.636     5.829     0.200
     0.917     8.551     0.200
     1.254     9.620     0.200
     1.813    12.095     0.200
     0.775     8.461     0.200
     0.844     8.159     0.200
     1.039     8.884     0.200
     1.427    10.354     0.200
     1.559    10.812     0.200
     0.953     7.937     0.200
     0.779     8.470     0.200
     0.858     8.549     0.200
     1.045     7.366     0.200
     1.268    11.762     0.200
     1.435    11.819     0.200
     1.563    10.323     0.200
     1.914    12.230     0.200
     0.301     3.027     0.200
     0.396     3.913     0.200
     1.457    11.534     0.200
     0.201     2.264     0.200
     0.832     7.398     0.200
     0.984     8.121     0.200
     1.315    10.268     0.200
     1.340    10.477     0.200
     1.833    13.219     0.200
     0.560     5.659     0.200
     0.695     6.090     0.200
     0.954     8.069     0.200
     0.968     7.901     0.200
     1.684    11.548     0.200
     0.432     4.484     0.200
     0.862     7.465     0.200
     0.753     5.733     0.200
     1.117     9.489     0.200
     0.289     3.038     0.200
     0.497     4.609     0.200
     1.332     9.866     0.200
     1.534    11.007     0.200
     0.668     6.629     0.200
     0.832     6.712     0.200
     0.876     7.701     0.200
     0.967     8.140     0.200
     0.073     1.438     0.200
     0.621     6.043     0.200
     0.970     8.769     0.200
     1.663    11.876     0.200
     0.195     1.402     0.200
     0.666     6.898     0.200
     0.972     9.333     0.200
     1.734    11.446     0.200
     1.996    12.387     0.200
     0.457     4.662     0.200
     0.580     5.224     0.200
     1.303     9.782     0.200
     1.418     9.508     0.200
     1.418    10.860     0.200
     1.545    10.959     0.200
     1.386     9.820     0.200
     2.210    13.203     0.200
     2.576    15.928     0.200
     0.301     2.772     0.200
     0.518     5.246     0.200
     0.654     6.159     0.200
     1.211     9.153     0.200
     1.541    11.301     0.200
     0.550     6.196     0.200
     1.100     8.779     0.200
     1.295    10.998     0.200
     1.453    11.161     0.200
     1.482    12.313     0.200
     1.943    13.442     0.200
     0.242     3.563     0.200
     0.806     7.977     0.200
     1.294     9.286     0.200
     1.721    13.303     0.200
     0.276     2.658     0.200
     0.329     3.036     0.200
     1.588    11.346     0.200
     0.662     6.380     0.200
     0.747     7.889     0.200
     1.654    11.300     0.200
     1.671    11.601     0.200
     0.103     4.949     0.200
     1.132     8.443     0.200
     0.459     4.898     0.200
     2.129    13.410     0.200
     2.354    13.788     0.200
     0.605     5.309     0.200
     0.640     6.396     0.200
     0.932     7.995     0.200
     0.968     8.565     0.200
     1.017     9.004     0.200
     1.641    12.220     0.200
     0.244     3.877     0.200
     0.502     4.866     0.200
     1.359    10.364     0.200
     1.578    10.310     0.200
     1.240    10.634     0.200
     1.370    10.112     0.200
     0.228     4.835     0.200
     0.720     6.097     0.200
     1.223     9.231     0.200
     1.443    10.658     0.200
     0.429     5.188     0.200
     0.595     5.754     0.200
     1.169     8.634     0.200
     1.233     9.811     0.200
     1.295    11.085     0.200
     1.995    13.419     0.200
     7.105    40.984     0.200
     7.120    40.810     0.200
     0.671     6.140     0.200
     2.021    11.382     0.200
     2.478    13.057     0.200
     2.916    15.947     0.200
     5.730    30.108     0.200
     0.491     4.916     0.200
     1.061     8.263     0.200
     1.670    10.159     0.200
     0.556     5.446     0.200
     1.449    11.028     0.200
     1.567    11.645     0.200
     1.686    12.261     0.200
     0.172     2.526     0.200
     0.470     5.043     0.200
     0.784     7.380     0.200
     1.158     9.009     0.200
     1.335     9.943     0.200
     1.434    11.790     0.200
     0.605     6.477     0.200
     0.748     6.803     0.200
     0.963     8.302     0.200
     1.657    10.193     0.200
     0.295     2.483     0.200
     0.303     3.885     0.200
     1.214    10.260     0.200
     1.795    12.473     0.200
     2.005    13.021     0.200
     0.535     5.458     0.200
     0.589     5.331     0.200
     0.589     4.831     0.200
     1.509    10.589     0.200
     2.144    13.679     0.200
     2.144    12.479     0.200
     2.487    14.685     0.200
     6.297    34.216     0.200
     6.537    35.418     0.200
     0.627     5.804     0.200
     0.669     7.306     0.200
     1.169    10.471     0.200
     1.161     9.568     0.200
     1.455    12.134     0.200
     0.457     5.167     0.200
     0.645     5.979     0.200
     0.789     6.798     0.200
     0.976     8.112     0.200
     1.129     8.331     0.200
     0.542     5.506     0.200
     0.915     8.654     0.200
     1.199    10.840     0.200
     0.807     6.916     0.200
     0.483     4.852     0.200
     0.587     6.133     0.200
     1.097     8.679     0.200
     1.232     9.109     0.200
     0.336     3.873     0.200
     0.641     5.804     0.200
     1.117     8.750     0.200
     1.605    11.057     0.200
     1.230     9.781     0.200
     1.361    10.257     0.200
     2.473    16.838     0.200
     2.476    16.840     0.200
     0.783     6.446     0.200
     1.629    12.338     0.200
     0.321     2.968     0.200
     1.021     8.993     0.200
     1.064    10.789     0.200
     1.421    10.625     0.200
     1.507    12.623     0.200
     0.253     3.377     0.200
     0.552     4.881     0.200
     1.585    10.828     0.200
     1.634    11.254     0.200
     2.215    13.480     0.200
     0.391     3.822     0.200
     1.783    12.084     0.200
     0.380     3.095     0.200
     1.179    12.070     0.200
     1.797    14.552     0.200
     0.812     6.562     0.200
     0.425     4.339     0.200
     0.633     5.913     0.200
     1.201     9.278     0.200
     1.762    11.236     0.200
     1.986    12.116     0.200
     0.896     8.085     0.200
     1.066     8.905     0.200
     1.683    12.598     0.200
     0.234     2.018     0.200
     1.795    12.200     0.200
     0.083     3.187     0.200
     0.922     8.180     0.200
     1.007     8.103     0.200
     1.077     9.289     0.200
     1.308     9.689     0.200
     1.366     9.818     0.200
     1.536     9.930     0.200
     1.378     9.463     0.200
     1.378     9.663     0.200
     1.778    11.681     0.200
     1.795    11.369     0.200
     1.796    11.982     0.200
     0.937     8.472     0.200
     1.474    10.560     0.200
     3.735    21.637     0.200
     0.255     3.137     0.200
     1.079     9.397     0.200
     1.039     8.834     0.200
     1.954    13.539     0.200
     0.523     4.022     0.200
     0.671     6.532     0.200
     1.884    14.228     0.200
     2.081    13.574     0.200
     0.883     8.451     0.200
     0.792     7.140     0.200
     1.838    12.972     0.200
     1.794    12.173     0.200
     1.990    12.749     0.200
     2.450    16.479     0.200
     2.674    17.241     0.200
     3.640    18.535     0.200
     0.307     4.056     0.200
     0.451     4.997     0.200
     0.632     5.270     0.200
     1.272     9.712     0.200
     1.365    10.041     0.200
     1.568    10.961     0.200
     1.942    12.832     0.200
     2.217    14.217     0.200
     2.974    17.024     0.200
     0.336     3.997     0.200
     1.493    12.571     0.200
     1.825    12.431     0.200
     1.849    11.127     0.200
     3.500    18.010     0.200
     0.254     3.241     0.200
     0.444     4.680     0.200
     0.471     4.416     0.200
     0.582     4.906     0.200
     0.582     5.109     0.200
     0.860     7.944     0.200
     1.343     9.932     0.200
     1.564    12.830     0.200
     1.668    11.038     0.200
     1.668    10.812     0.200
     1.727    11.849     0.200
     1.847    12.558     0.200
     1.963    14.047     0.200
     0.234     3.280     0.200
     0.417     4.633     0.200
     0.486     4.342     0.200
     0.594     5.130     0.200
     0.840     8.230     0.200
     1.353    10.441     0.200
     1.555    11.847     0.200
     1.588    12.140     0.200
     1.710    11.921     0.200
     1.825    13.138     0.200
     0.479     4.549     0.200
     0.791     8.149     0.200
     0.933     6.848     0.200
     1.058    10.093     0.200
     1.269    10.886     0.200
     1.525    10.427     0.200
     1.557    10.779     0.200
     1.684    11.100     0.200
     3.472    19.159     0.200
     0.607     5.988     0.200
     1.318     9.976     0.200
     1.820    11.689     0.200
     1.820    12.331     0.200
     2.040    15.493     0.200
     2.205    16.118     0.200
     2.483    15.751     0.200
     0.408     4.241     0.200
     0.587     5.550     0.200
     1.069     9.629     0.200
     1.066     8.849     0.200
     1.228     9.441     0.200
     1.299     9.588     0.200
     1.584    10.392     0.200
     1.629    10.565     0.200
     1.817    13.307     0.200
     1.839    11.982     0.200
     1.839    11.037     0.200
     2.197    15.505     0.200
     0.397     4.066     0.200
     0.321     4.292     0.200
     0.584     5.288     0.200
     1.087     9.165     0.200
     1.399     9.944     0.200
     1.217     9.556     0.200
     1.286     9.644     0.200
     1.641    10.497     0.200
     1.559    11.919     0.200
     1.851    12.746     0.200
     2.211    14.770     0.200
     2.368    14.169     0.200
     2.706    15.090     0.200
     0.413     5.362     0.200
     0.579     4.872     0.200
     1.050    10.004     0.200
     2.168    15.897     0.200
     3.503    22.227     0.200
     3.758    20.490     0.200
     0.835     6.235     0.200
     0.754     6.744     0.200
     1.248     9.337     0.200
     1.477    10.458     0.200
     1.762    11.883     0.200
     1.898    12.678     0.200
     0.994     9.483     0.200
     1.045     8.549     0.200
     1.250    11.153     0.200
     1.291    11.579     0.200
     1.330    10.976     0.200
     1.599    12.249     0.200
     0.662     6.611     0.200
     0.661     6.613     0.200
     0.728     7.157     0.200
     0.782     7.181     0.200
     1.110     8.763     0.200
     1.327    10.699     0.200
     1.503    11.609     0.200
     1.365    10.915     0.200
     2.167    15.385     0.200
     2.423    17.346     0.200
     2.487    15.932     0.200
     2.683    15.302     0.200
     3.408    19.350     0.200
     0.799     7.257     0.200
     1.071     8.615     0.200
     1.105     8.571     0.200
     1.170     8.500     0.200
     1.476    10.843     0.200
     1.509     9.761     0.200
     1.502    11.586     0.200
     1.714    10.848     0.200
     1.855    13.022     0.200
     2.035    13.364     0.200
     2.733    13.558     0.200
     2.801    15.559     0.200
     3.304    15.587     0.200
     0.352     2.994     0.200
     0.927     7.664     0.200
     1.532    12.330     0.200
     1.630    12.367     0.200
     2.205    15.326     0.200
     2.304    17.275     0.200
     2.352    15.327     0.200
     0.084     1.832     0.200
     0.641     5.478     0.200
     1.383    10.904     0.200
     1.323    11.884     0.200
     1.769    12.814     0.200
     1.883    13.676     0.200
     2.416    15.662     0.200
     2.575    15.567     0.200
     2.599    16.795     0.200
     0.191     1.711     0.200
     0.546     4.517     0.200
     1.094     9.051     0.200
     1.504    10.883     0.200
     1.634    11.690     0.200
     2.347    14.955     0.200
     0.476     5.205     0.200
     0.807     7.114     0.200
     1.050     7.747     0.200
     1.164     9.742     0.200
     1.133    10.686     0.200
     1.236    10.206     0.200
     1.304    10.644     0.200
     1.359    11.309     0.200
     2.032    13.484     0.200
     2.537    16.410     0.200
     3.136    18.184     0.200
     0.542     5.142     0.200
     0.730     7.510     0.200
     1.008     8.806     0.200
     1.129    10.017     0.200
     1.144    10.260     0.200
     1.432    10.580     0.200
     1.710    12.540     0.200
     3.220    20.157     0.200
     3.764    20.570     0.200
     0.788     6.922     0.200
     0.768     7.527     0.200
     1.198    11.147     0.200
     1.209    10.470     0.200
     1.349    10.913     0.200
     1.403    10.987     0.200
     2.017    13.123     0.200
     2.556    16.323     0.200
     2.814    16.673     0.200
     3.712    21.328     0.200
     0.504     4.290     0.200
     0.742     5.730     0.200
     0.742     7.250     0.200
     0.779     5.440     0.200
     1.061     6.868     0.200
     1.050     9.405     0.200
     1.154     8.322     0.200
     1.173     9.681     0.200
     1.219     8.022     0.200
     1.307     9.231     0.200
     1.359     9.518     0.200
     0.559     5.093     0.200
     0.769     6.076     0.200
     0.810     6.581     0.200
     0.826     6.391     0.200
     0.872     7.680     0.200
     0.996     7.356     0.200
     1.074     8.434     0.200
     1.617    10.742     0.200
     1.674    10.793     0.200
     1.811    11.402     0.200
     3.283    17.988     0.200
     0.589     5.804     0.200
     0.802     8.219     0.200
     0.884     7.591     0.200
     1.240    12.057     0.200
     1.297     9.394     0.200
     0.134     2.405     0.200
     0.354     3.586     0.200
     0.485     4.386     0.200
     0.566     5.490     0.200
     1.157    10.271     0.200
     1.256     9.688     0.200
     1.999    14.779     0.200
     2.156    15.410     0.200
     2.351    14.597     0.200
     0.111     2.651     0.200
     0.315     4.196     0.200
     0.446     3.321     0.200
     1.245     9.712     0.200
     1.690    11.067     0.200
     2.461    13.592     0.200
     0.662     6.255     0.200
     0.804     6.754     0.200
     1.094     7.917     0.200
     0.423     4.605     0.200
     0.814     7.381     0.200
     1.185     9.678     0.200
     1.438    11.266     0.200
     1.548    11.723     0.200
     1.691    12.149     0.200
     0.631     6.336     0.200
     0.993     8.398     0.200
     1.275     9.853     0.200
     1.396     9.964     0.200
     1.854    12.491     0.200
     0.532     5.123     0.200
     0.669     6.892     0.200
     1.089     7.880     0.200
     2.597    16.481     0.200
     0.334     2.915     0.200
     1.024    10.299     0.200
     0.991     9.260     0.200
     0.273     3.019     0.200
     0.898     8.082     0.200
     2.431    14.044     0.200
     0.618     5.943     0.200
     1.114     9.218     0.200
     1.251     8.034     0.200
     1.373     8.727     0.200
     2.174    13.440     0.200
     0.339     4.283     0.200
     1.199     8.407     0.200
     1.638    10.812     0.200
     1.904    11.887     0.200
     2.031    13.786     0.200
     2.194    13.522     0.200
     2.287    13.986     0.200
     2.505    13.579     0.200
     2.679    15.052     0.200
     2.738    15.118     0.200
     0.584     5.695     0.200
     0.759     7.341     0.200
     0.760     7.590     0.200
     1.490    12.462     0.200
     1.796    13.199     0.200
     2.171    13.990     0.200
     2.574    16.371     0.200
     2.868    16.517     0.200
     3.017    17.077     0.200
     0.412     4.234     0.200
     0.542     5.368     0.200
     1.144     9.288     0.200
     1.275     8.941     0.200
     1.924    14.069     0.200
     1.975    12.589     0.200
     2.144    13.274     0.200
     0.882     8.397     0.200
     1.146     9.882     0.200
     1.219    10.721     0.200
     1.559    12.499     0.200
     1.744    13.278     0.200
     1.772    13.860     0.200
     1.978    13.351     0.200
     3.230    18.185     0.200
     0.363     5.129     0.200
     1.125     8.137     0.200
     0.966     7.187     0.200
     1.139     8.917     0.200
     1.226     8.424     0.200
     1.407     9.587     0.200
     1.684     9.729     0.200
     1.893    10.341     0.200
     1.893    10.777     0.200
     0.875     8.590     0.200
     1.072     9.874     0.200
     1.045     9.403     0.200
     1.018     8.304     0.200
     1.003     7.886     0.200
     1.003     8.097     0.200
     1.449    11.394     0.200
     1.491    11.570     0.200
     1.710    12.683     0.200
     1.826    12.404     0.200
     2.212    13.505     0.200
     3.066    19.795     0.200
     0.284     4.839     0.200
     0.434     5.723     0.200
     0.605     5.245     0.200
     1.039     7.753     0.200
     1.076     7.983     0.200
     1.253     9.175     0.200
     1.396     8.804     0.200
     1.539    11.048     0.200
     0.183     3.312     0.200
     0.857     7.333     0.200
     1.110     7.962     0.200
     1.079     8.366     0.200
     1.073     8.372     0.200
     1.204     9.338     0.200
     1.866    12.166     0.200
     2.068    12.755     0.200
     2.433    13.775     0.200
     0.384     4.057     0.200
     0.524     5.395     0.200
     0.604     6.122     0.200
     2.399    15.434     0.200
     2.713    17.574     0.200
     2.949    16.519     0.200
     0.103     3.341     0.200
     0.492     5.046     0.200
     0.688     5.529     0.200
     0.778     5.930     0.200
     1.371    10.063     0.200
     1.512    11.288     0.200
     1.602    11.871     0.200
     2.450    16.473     0.200
     2.458    17.682     0.200
     2.458    16.502     0.200
     4.282    25.838     0.200
     4.397    26.497     0.200
     5.144    28.780     0.200
     5.280    28.195     0.200
     0.938     8.397     0.200
     1.022     8.977     0.200
     1.151     9.868     0.200
     1.242    10.263     0.200
     1.442    12.193     0.200
     1.572    12.091     0.200
     2.195    14.375     0.200
     2.287    17.148     0.200
     2.980    19.163     0.200
     3.210    17.759     0.200
     0.096     2.978     0.200
     0.202     3.720     0.200
     0.496     4.704     0.200
     0.626     6.528     0.200
     1.364     9.799     0.200
     1.367     9.382     0.200
     1.504    10.076     0.200
     1.603     9.974     0.200
     1.596    10.970     0.200
     1.822    12.551     0.200
     1.742    11.570     0.200
     2.196    12.864     0.200
     2.451    15.537     0.200
     2.459    16.795     0.200
     2.459    17.330     0.200
     0.221     3.448     0.200
     0.448     5.146     0.200
     0.615     6.094     0.200
     0.716     6.203     0.200
     1.444    10.391     0.200
     1.357    10.201     0.200
     1.595    10.577     0.200
     1.671    12.425     0.200
     2.733    14.568     0.200
     2.994    17.024     0.200
     0.474     5.292     0.200
     0.649     6.037     0.200
     1.560    11.733     0.200
     1.901    13.385     0.200
     2.082    13.513     0.200
     2.139    12.592     0.200
     2.478    15.652     0.200
     2.760    17.241     0.200
     3.011    19.103     0.200
     4.187    23.489     0.200
     0.163     2.564     0.200
     0.495     5.550     0.200
     0.664     6.490     0.200
     0.668     5.828     0.200
     0.751     6.526     0.200
     1.544    11.655     0.200
     1.729    11.924     0.200
     1.881    12.792     0.200
     2.087    13.653     0.200
     2.188    13.071     0.200
     2.167    13.612     0.200
     2.334    14.933     0.200
     2.703    16.259     0.200
     2.780    15.653     0.200
     3.030    18.085     0.200
     0.226     2.669     0.200
     0.543     5.273     0.200
     0.667     7.007     0.200
     0.691     6.175     0.200
     0.764     6.864     0.200
     1.544    11.397     0.200
     1.825    14.481     0.200
     0.834     7.238     0.200
     0.874     8.506     0.200
     1.374    10.770     0.200
     1.505    11.662     0.200
     1.610    12.560     0.200
     1.796    13.401     0.200
     1.963    14.208     0.200
     2.274    14.384     0.200
     0.802     7.065     0.200
     0.880     8.806     0.200
     0.863     6.913     0.200
     0.943     7.873     0.200
     1.198    10.399     0.200
     1.517    11.660     0.200
     1.597    13.025     0.200
     1.770    13.384     0.200
     1.770    13.541     0.200
     1.770    13.704     0.200
     1.730    13.537     0.200
     1.938    13.687     0.200
     2.253    14.237     0.200
     2.260    14.376     0.200
     0.310     2.531     0.200
     0.336     3.450     0.200
     0.557     5.800     0.200
     0.840     8.044     0.200
     1.033     8.926     0.200
     1.185     8.611     0.200
     1.873    12.955     0.200
     2.351    15.480     0.200
     2.352    14.433     0.200
     2.506    16.441     0.200
     0.356     3.564     0.200
     0.551     5.546     0.200
     0.638     5.688     0.200
     1.657    13.250     0.200
     2.106    14.711     0.200
     0.126     3.884     0.200
     0.397     4.120     0.200
     0.521     5.208     0.200
     0.564     6.476     0.200
     0.967     7.435     0.200
     1.334     8.847     0.200
     2.651    13.931     0.200
     2.408    12.936     0.200
     2.770    14.845     0.200
     0.439     4.716     0.200
     0.867     7.383     0.200
     0.851     6.911     0.200
     0.766     7.206     0.200
     1.175    10.556     0.200
     2.312    16.455     0.200
     2.906    17.190     0.200
     3.221    20.596     0.200
     0.408     5.310     0.200
     0.628     4.740     0.200
     0.620     5.412     0.200
     0.632     5.846     0.200
     0.969     7.342     0.200
     1.181     8.014     0.200
     1.814    11.505     0.200
     1.824    10.233     0.200
     1.827    11.631     0.200
     1.817    11.469     0.200
     0.451     4.908     0.200
     0.565     5.960     0.200
     0.603     5.522     0.200
     0.636     5.912     0.200
     0.885     7.704     0.200
     1.215     9.071     0.200
     1.731    12.360     0.200
     1.750    10.652     0.200
     1.760    10.265     0.200
     1.839    10.389     0.200
     2.041    12.990     0.200
     2.203    12.401     0.200
     2.259    13.051     0.200
     2.788    14.700     0.200
     2.947    16.237     0.200
     0.165     2.683     0.200
     0.460     5.609     0.200
     0.634     5.894     0.200
     0.695     5.832     0.200
     1.355    10.032     0.200
     1.429    10.378     0.200
     1.574    11.207     0.200
     1.652    11.775     0.200
     2.474    13.520     0.200
     2.689    16.364     0.200
     0.631     5.694     0.200
     0.702     5.808     0.200
     0.818     6.596     0.200
     0.996     8.286     0.200
     1.192     8.958     0.200
     1.288     9.570     0.200
     1.288    10.090     0.200
     1.285     9.845     0.200
     1.412     9.245     0.200
     1.502     9.998     0.200
     1.912    11.635     0.200
     2.010    14.346     0.200
     2.044    11.915     0.200
     2.040    12.450     0.200
     2.146    12.724     0.200
     2.253    12.477     0.200
     2.677    14.080     0.200
     2.854    14.382     0.200
     0.522     4.934     0.200
     0.898     7.904     0.200
     0.893     7.239     0.200
     1.008     8.227     0.200
     1.091     8.916     0.200
     1.350    11.265     0.200
     1.403    10.719     0.200
     1.497    10.147     0.200
     1.693    10.850     0.200
     2.119    12.810     0.200
     2.443    16.376     0.200
     0.910     9.117     0.200
     0.952     8.394     0.200
     1.124     8.985     0.200
     1.206    11.599     0.200
     1.211    11.552     0.200
     1.211    11.670     0.200
     1.249     9.842     0.200
     1.741    14.162     0.200
     1.884    13.426     0.200
     2.041    13.929     0.200
     0.156     2.816     0.200
     0.507     5.143     0.200
     0.683     5.873     0.200
     0.766     6.336     0.200
     1.528    11.482     0.200
     1.718    11.848     0.200
     1.872    13.477     0.200
     0.873     7.841     0.200
     0.916     7.676     0.200
     1.096     9.204     0.200
     1.446    11.197     0.200
     1.497    11.119     0.200
     1.834    12.054     0.200
     1.766    11.927     0.200
     2.477    14.716     0.200
     2.614    16.518     0.200
     2.565    15.712     0.200
     0.494     5.264     0.200
     0.681     5.834     0.200
     0.888     6.558     0.200
     0.907     6.611     0.200
     1.111     7.812     0.200
     1.721    10.950     0.200
     0.185     2.222     0.200
     0.170     2.792     0.200
     0.675     6.125     0.200
     0.663     5.269     0.200
     0.743     5.994     0.200
     1.554    10.518     0.200
     0.632     6.140     0.200
     0.720     6.532     0.200
     1.571    12.471     0.200
     1.930    15.138     0.200
     2.167    13.203     0.200
     0.801     6.773     0.200
     0.858     7.249     0.200
     0.994     8.758     0.200
     1.801    11.966     0.200
     1.821    11.526     0.200
     0.825     7.146     0.200
     1.175     8.646     0.200
     1.241     9.661     0.200
     1.320    10.000     0.200
     1.434     9.697     0.200
     1.521    11.059     0.200
     1.505    10.328     0.200
     1.531    11.334     0.200
     1.810    11.786     0.200
     1.810    12.316     0.200
     1.810    12.433     0.200
     1.778    11.855     0.200
     1.975    11.702     0.200
     2.047    14.535     0.200
     0.251     4.999     0.200
     0.687     5.956     0.200
     0.896     8.085     0.200
     1.035     7.500     0.200
     0.137     2.898     0.200
     0.720     5.756     0.200
     1.384    10.321     0.200
     1.658    13.528     0.200
     1.783    12.162     0.200
     0.488     3.953     0.200
     0.579     5.642     0.200
     0.579     5.392     0.200
     1.643    11.322     0.200
     1.833    10.990     0.200
     2.270    13.889     0.200
     2.481    14.106     0.200
     0.802     7.426     0.200
     0.885     7.833     0.200
     0.973     7.715     0.200
     1.300    10.643     0.200
     1.176    10.193     0.200
     1.427    11.592     0.200
     1.701    13.569     0.200
     1.643    11.936     0.200
     1.778    12.495     0.200
     1.882    13.282     0.200
     1.587    11.735     0.200
     0.662     6.511     0.200
     0.852     7.935     0.200
     1.144     9.168     0.200
     0.986     9.094     0.200
     1.443    10.932     0.200
     1.273     9.149     0.200
     1.353     9.619     0.200
     1.397    10.353     0.200
     2.183    12.737     0.200
     2.110    13.656     0.200
     2.808    17.012     0.200
     2.949    15.497     0.200
     3.025    16.200     0.200
     0.726     6.726     0.200
     0.914     8.486     0.200
     1.128    11.164     0.200
     1.044     9.557     0.200
     1.332    11.050     0.200
     1.444    11.350     0.200
     1.457    11.200     0.200
     1.983    13.147     0.200
     2.214    14.654     0.200
     0.552     5.484     0.200
     0.831     6.742     0.200
     1.180     9.831     0.200
     1.186     9.055     0.200
     1.225    10.891     0.200
     1.250     9.819     0.200
     1.305    11.338     0.200
     1.448    11.464     0.200
     1.533    12.184     0.200
     1.572    12.041     0.200
     1.588    12.100     0.200
     1.631    13.034     0.200
     0.417     5.099     0.200
     0.417     4.950     0.200
     0.772     6.535     0.200
     0.584     5.360     0.200
     0.702     6.421     0.200
     0.702     5.991     0.200
     1.020     8.485     0.200
     1.020     8.649     0.200
     1.196     8.196     0.200
     2.164    13.971     0.200
     2.311    13.584     0.200
     0.705     5.530     0.200
     0.701     6.456     0.200
     0.876     8.105     0.200
     1.040     8.897     0.200
     1.089    11.155     0.200
     1.396    13.295     0.200
     2.128    15.965     0.200
     2.794    17.275     0.200
     3.061    19.233     0.200
     3.064    17.794     0.200
     3.882    22.358     0.200
     0.608     5.913     0.200
     0.788     6.729     0.200
     0.955     7.853     0.200
     1.239     8.248     0.200
     1.407     9.732     0.200
     1.959    11.897     0.200
     2.173    12.514     0.200
     0.675     5.854     0.200
     0.753     6.252     0.200
     1.070     8.801     0.200
     0.856     8.099     0.200
     1.297    10.510     0.200
     1.423     9.867     0.200
     1.631    11.127     0.200
     1.686    11.931     0.200
     1.937    12.900     0.200
     2.631    14.737     0.200
     2.351    13.652     0.200
     0.563     5.532     0.200
     0.727     6.044     0.200
     0.841     7.081     0.200
     1.125     7.988     0.200
     1.142     8.812     0.200
     1.163     9.314     0.200
     1.392     9.768     0.200
     1.620    11.225     0.200
     1.951    12.062     0.200
     2.150    14.839     0.200
     2.382    12.875     0.200
     0.519     5.414     0.200
     0.696     4.713     0.200
     0.918     7.155     0.200
     1.352     8.701     0.200
     1.259     8.874     0.200
     1.443    10.321     0.200
     1.520    10.573     0.200
     0.865     7.799     0.200
     0.915     7.257     0.200
     0.991     7.865     0.200
     1.264    10.977     0.200
     1.788    12.906     0.200
     1.788    13.067     0.200
     1.923    12.556     0.200
     0.570     5.071     0.200
     0.815     6.870     0.200
     1.040     8.607     0.200
     1.040     8.787     0.200
     1.764    11.529     0.200
     1.831    12.370     0.200
     1.831    12.245     0.200
     0.864     8.426     0.200
     0.920     7.888     0.200
     0.998     8.377     0.200
     1.386    11.274     0.200
     1.386    11.743     0.200
     1.502    12.971     0.200
     1.906    13.208     0.200
     1.906    13.622     0.200
     2.634    15.840     0.200
     2.776    16.376     0.200
     0.944     9.261     0.200
     1.034     8.460     0.200
     1.287    10.648     0.200
     1.287    11.002     0.200
     1.121     9.489     0.200
     1.299    11.108     0.200
     1.556    12.274     0.200
     1.636    13.036     0.200
     1.636    13.288     0.200
     1.758    12.926     0.200
     0.769     6.858     0.200
     0.769     6.968     0.200
     1.075     8.262     0.200
     1.139     8.524     0.200
     1.354     9.358     0.200
     1.443    10.504     0.200
     1.851    11.680     0.200
     1.892    11.607     0.200
     1.892    12.943     0.200
     0.805     7.283     0.200
     0.925     8.240     0.200
     0.925     7.799     0.200
     1.268    10.371     0.200
     1.268    11.031     0.200
     1.513    10.957     0.200
     1.874    11.963     0.200
     2.013    12.927     0.200
     2.086    13.211     0.200
     2.086    14.531     0.200
     0.176     3.016     0.200
     0.675     6.337     0.200
     0.756     7.137     0.200
     1.311     9.993     0.200
     1.311    10.411     0.200
     1.822    13.281     0.200
     2.719    15.124     0.200
     0.193     2.694     0.200
     0.252     2.682     0.200
     0.953     8.531     0.200
     1.250     9.566     0.200
     1.852    12.591     0.200
     1.993    14.944     0.200
     0.940     7.827     0.200
     0.940     8.785     0.200
     1.202     9.838     0.200
     1.416    10.796     0.200
     1.416    11.237     0.200
     1.693    13.227     0.200
     1.693    13.079     0.200
     1.705    12.484     0.200
     1.705    12.866     0.200
     0.236     3.859     0.200
     0.746     6.741     0.200
     0.746     6.600     0.200
     0.804     6.245     0.200
     1.380     9.390     0.200
     1.206     8.679     0.200
     1.333     8.927     0.200
     1.467    10.370     0.200
     1.528    10.454     0.200
     1.659     9.662     0.200
     2.022    12.521     0.200
     2.314    12.207     0.200
     2.323    14.164     0.200
     2.557    13.124     0.200
     0.463     5.371     0.200
     1.031     6.587     0.200
     0.856     7.752     0.200
     1.108     9.689     0.200
     1.130     8.699     0.200
     1.696    11.546     0.200
     1.759    12.439     0.200
     2.348    13.336     0.200
     2.472    14.856     0.200
     0.549     5.113     0.200
     0.748     6.451     0.200
     0.786     6.557     0.200
     0.770     6.528     0.200
     1.909    11.281     0.200
     0.893     8.896     0.200
     1.270    10.447     0.200
     1.321    11.180     0.200
     1.373    13.229     0.200
     1.669    13.755     0.200
     1.757    14.170     0.200
     1.832    13.678     0.200
     1.977    14.432     0.200
     2.066    14.424     0.200
     1.905    14.334     0.200
     0.496     5.758     0.200
     0.577     5.668     0.200
     0.749     6.185     0.200
     0.940     7.793     0.200
     1.383     9.041     0.200
     0.555     6.027     0.200
     0.756     7.015     0.200
     0.845     7.165     0.200
     1.080     9.653     0.200
     1.704    12.478     0.200
     1.895    12.607     0.200
     2.024    13.990     0.200
     2.086    13.961     0.200
     3.263    17.889     0.200
     3.381    18.128     0.200
     0.682     5.717     0.200
     0.618     5.890     0.200
     0.857     7.556     0.200
     0.973     9.288     0.200
     1.170     8.468     0.200
     1.261    10.153     0.200
     1.339    10.033     0.200
     1.386     9.494     0.200
     1.470    10.909     0.200
     2.884    16.091     0.200
     0.324     3.364     0.200
     0.937     6.628     0.200
     2.196    11.999     0.200
     2.208    13.158     0.200
     0.226     3.624     0.200
     0.829     7.102     0.200
     1.191     9.217     0.200
     1.214     8.988     0.200
     1.360     9.265     0.200
     1.467     9.465     0.200
     1.636    11.234     0.200
     2.414    12.834     0.200
     0.264     3.827     0.200
     0.871     6.496     0.200
     0.871     7.474     0.200
     1.063     8.596     0.200
     1.149     9.694     0.200
     1.186     9.186     0.200
     1.425     9.948     0.200
     1.556    10.110     0.200
     1.630    10.386     0.200
     2.414    13.273     0.200
     0.724     6.535     0.200
     0.807     7.474     0.200
     1.084     9.380     0.200
     1.379    10.029     0.200
     1.634    10.678     0.200
     1.825    11.178     0.200
     1.902    12.083     0.200
     2.045    12.320     0.200
     2.163    13.605     0.200
     2.441    13.507     0.200
     0.513     5.361     0.200
     0.705     7.100     0.200
     1.115     9.885     0.200
     1.381     9.566     0.200
     1.813    11.566     0.200
     1.969    11.984     0.200
     2.109    12.274     0.200
     2.402    13.279     0.200
     0.496     5.117     0.200
     0.516     5.056     0.200
     1.052     9.002     0.200
     1.330    11.231     0.200
     1.687    12.161     0.200
     1.795    12.347     0.200
     2.190    13.798     0.200
     2.297    13.994     0.200
     2.328    13.828     0.200
     0.153     2.256     0.200
     0.604     5.551     0.200
     0.633     6.314     0.200
     0.879     7.568     0.200
     1.068     9.053     0.200
     1.321    10.727     0.200
     1.423    10.820     0.200
     1.424    10.605     0.200
     1.771    13.151     0.200
     1.854    13.825     0.200
     0.749     7.014     0.200
     0.719     6.805     0.200
     0.825     6.401     0.200
     0.942     8.107     0.200
     1.233     7.924     0.200
     1.282    10.240     0.200
     1.259     8.632     0.200
     1.387     9.260     0.200
     1.963    11.991     0.200
     2.876    16.007     0.200
     0.467     4.772     0.200
     0.774     7.474     0.200
     0.803     7.275     0.200
     0.934     6.306     0.200
     1.037     8.035     0.200
     1.075     6.410     0.200
     1.287    10.096     0.200
     1.520    10.399     0.200
     1.551    10.326     0.200
     0.745     7.070     0.200
     1.069     9.199     0.200
     1.127     9.390     0.200
     1.158     9.138     0.200
     1.230     7.619     0.200
     1.451    10.659     0.200
     1.803    11.432     0.200
     1.958    12.031     0.200
     0.368     3.911     0.200
     0.540     5.562     0.200
     1.130     9.990     0.200
     1.314     9.728     0.200
     1.283    10.117     0.200
     1.881    11.964     0.200
     2.459    13.861     0.200
     0.212     2.365     0.200
     0.480     5.242     0.200
     0.972     8.123     0.200
     0.995     9.086     0.200
     1.062     9.212     0.200
     1.100     9.813     0.200
     1.291     9.782     0.200
     1.422    10.683     0.200
     1.483    10.985     0.200
     1.565    11.038     0.200
     0.336     3.823     0.200
     0.416     4.384     0.200
     0.679     6.188     0.200
     0.841     7.776     0.200
     1.134     9.932     0.200
     1.087     8.838     0.200
     2.528    14.448     0.200
     2.769    16.574     0.200
     0.401     4.442     0.200
     0.869     7.573     0.200
     0.735     6.803     0.200
     1.157     9.517     0.200
     1.152     9.615     0.200
     1.424     9.863     0.200
     1.539    10.557     0.200
     1.943    13.135     0.200
     2.341    14.421     0.200
     2.401    15.284     0.200
     0.719     6.561     0.200
     0.698     6.883     0.200
     0.957     8.325     0.200
     1.110     9.496     0.200
     1.114     9.261     0.200
     1.142     9.904     0.200
     1.413    11.349     0.200
     1.832    11.986     0.200
     0.735     6.852     0.200
     0.727     6.819     0.200
     1.108     9.121     0.200
     1.535    12.151     0.200
     1.969    14.887     0.200
     0.700     4.282     0.200
     1.133    11.019     0.200
     1.148    11.255     0.200
     1.233    11.487     0.200
     1.282    11.482     0.200
     1.391    12.299     0.200
     1.391    12.740     0.200
     1.429    11.321     0.200
     1.467    12.236     0.200
     1.554    12.415     0.200
     2.504    15.063     0.200
     0.587     4.994     0.200
     0.896     8.240     0.200
     1.130     8.572     0.200
     1.146     8.241     0.200
     1.056     9.943     0.200
     1.084     9.443     0.200
     1.304    10.882     0.200
     1.422    10.397     0.200
     1.653    12.447     0.200
     1.738    12.221     0.200
     1.868    13.132     0.200
     2.358    15.292     0.200
     2.553    16.800     0.200
     0.712     6.600     0.200
     0.815     7.597     0.200
     0.815     8.266     0.200
     1.130    10.200     0.200
     1.130    10.611     0.200
     1.402    10.376     0.200
     1.517    12.065     0.200
     0.845     7.079     0.200
     0.859     9.103     0.200
     0.995     9.181     0.200
     1.282     9.482     0.200
     1.440    11.736     0.200
     1.406    10.068     0.200
     1.986    12.493     0.200
     2.184    13.194     0.200
     2.174    14.815     0.200
     2.914    15.652     0.200
     0.331     5.252     0.200
     0.321     4.816     0.200
     0.984     8.095     0.200
     1.241     8.956     0.200
     1.360     8.858     0.200
     1.492     9.346     0.200
     0.892     6.633     0.200
     1.046     8.327     0.200
     0.477     4.874     0.200
     0.595     5.446     0.200
     0.735     6.843     0.200
     0.966     8.336     0.200
     1.135     9.900     0.200
     1.284    11.235     0.200
     1.651    11.282     0.200
     2.096    14.174     0.200
     2.303    14.956     0.200
     2.200    14.376     0.200
     0.915     8.476     0.200
     0.915     8.132     0.200
     1.377    10.682     0.200
     1.557    11.740     0.200
     1.509    11.208     0.200
     0.269     4.104     0.200
     0.529     5.160     0.200
     0.934     7.397     0.200
     1.060     7.504     0.200
     1.112     8.230     0.200
     1.283     9.628     0.200
     1.319     9.890     0.200
     1.436    10.216     0.200
     1.833    11.234     0.200
     2.227    13.968     0.200
     2.337    12.938     0.200
     3.038    17.701     0.200
     3.472    17.498     0.200
     0.222     3.387     0.200
     0.745     6.027     0.200
     0.790     6.732     0.200
     1.323    10.280     0.200
     1.263    10.523     0.200
     1.389    10.377     0.200
     1.532     9.743     0.200
     0.650     6.446     0.200
     0.647     6.183     0.200
     0.892     7.058     0.200
     0.994     8.656     0.200
     1.283     9.818     0.200
     1.409    10.693     0.200
     1.895    11.666     0.200
     0.549     5.255     0.200
     0.549     5.434     0.200
     0.549     6.262     0.200
     0.687     6.022     0.200
     0.795     6.600     0.200
     0.795     6.709     0.200
     1.156    10.168     0.200
     1.095     9.676     0.200
     1.095     9.168     0.200
     1.095     9.317     0.200
     1.197     9.846     0.200
     1.221     8.139     0.200
     1.221     8.561     0.200
     1.706    13.209     0.200
     2.302    13.799     0.200
     2.302    14.799     0.200
     2.985    15.830     0.200
     0.552     5.493     0.200
     0.552     5.946     0.200
     0.698     6.338     0.200
     0.808     6.824     0.200
     1.175    10.668     0.200
     1.175    11.347     0.200
     1.151     8.790     0.200
     1.151    10.626     0.200
     1.116    10.099     0.200
     1.116     9.607     0.200
     1.224     8.654     0.200
     1.224     8.772     0.200
     1.224     9.772     0.200
     1.684    11.882     0.200
     1.699    12.228     0.200
     1.699    13.314     0.200
     1.984    13.655     0.200
     1.984    13.905     0.200
     1.905    14.893     0.200
     2.053    13.524     0.200
     2.299    16.225     0.200
     0.661     5.761     0.200
     0.857     6.160     0.200
     0.857     6.381     0.200
     0.861     7.070     0.200
     1.184     8.806     0.200
     1.331     9.547     0.200
     1.255     9.346     0.200
     1.380     9.792     0.200
     2.078    13.197     0.200
     2.991    16.421     0.200
     0.555     5.726     0.200
     0.686     6.231     0.200
     0.793     7.007     0.200
     0.917     7.783     0.200
     1.079     9.791     0.200
     1.213     8.119     0.200
     1.213     8.662     0.200
     1.211    10.163     0.200
     1.662    11.884     0.200
     1.662    12.435     0.200
     1.699    13.001     0.200
     2.003    13.634     0.200
     2.037    12.931     0.200
     2.037    14.529     0.200
     2.271    14.644     0.200
     0.578     6.158     0.200
     0.900     7.474     0.200
     0.900     6.395     0.200
     0.977     7.626     0.200
     1.017     7.812     0.200
     0.552     6.004     0.200
     0.979     7.089     0.200
     1.006     7.598     0.200
     2.551    13.668     0.200
     0.393     4.192     0.200
     0.524     5.054     0.200
     0.524     5.147     0.200
     0.813     7.800     0.200
     1.116     9.523     0.200
     1.178    10.485     0.200
     1.190     9.017     0.200
     1.189     9.459     0.200
     2.098    13.816     0.200
     0.382     3.571     0.200
     0.514     4.797     0.200
     1.122     9.064     0.200
     1.201     9.518     0.200
     1.165    10.145     0.200
     1.177     8.927     0.200
     1.890    13.329     0.200
     2.179    13.078     0.200
     2.770    15.298     0.200
     0.367     3.685     0.200
     0.499     4.965     0.200
     1.154    10.255     0.200
     1.169    10.590     0.200
     1.114     9.164     0.200
     1.202     8.955     0.200
     1.892    12.436     0.200
     0.376     3.827     0.200
     0.499     5.302     0.200
     0.500     5.224     0.200
     2.576    14.565     0.200
     0.385     3.387     0.200
     0.385     4.187     0.200
     0.517     4.773     0.200
     1.148     9.450     0.200
     1.148    10.470     0.200
     1.157    10.422     0.200
     1.164     9.241     0.200
     2.120    14.133     0.200
     2.120    15.133     0.200
     2.198    15.250     0.200
     0.376     3.764     0.200
     0.506     4.801     0.200
     1.089     9.225     0.200
     1.089     9.569     0.200
     1.170    10.010     0.200
     1.190     8.938     0.200
     1.190    10.058     0.200
     1.176     9.245     0.200
     1.176     9.684     0.200
     2.183    14.740     0.200
     2.145    15.158     0.200
     0.369     3.923     0.200
     0.790     7.186     0.200
     1.164     9.752     0.200
     1.088     9.088     0.200
     1.184     9.876     0.200
     1.179     8.878     0.200
     1.916    14.197     0.200
     1.916    13.197     0.200
     1.916    12.187     0.200
     2.063    13.553     0.200
     2.176    13.193     0.200
     2.145    14.517     0.200
     2.607    14.157     0.200
     2.748    14.959     0.200
     1.035     8.383     0.200
     1.179     7.674     0.200
     1.104     8.124     0.200
     1.168     8.982     0.200
     1.252     9.518     0.200
     1.293     9.374     0.200
     1.681    10.226     0.200
     1.747    11.405     0.200
     0.429     4.044     0.200
     0.786     7.140     0.200
     0.930     7.044     0.200
     0.843     7.850     0.200
     1.053     8.693     0.200
     1.118    10.413     0.200
     1.334    12.030     0.200
     1.434    11.334     0.200
     1.582    11.256     0.200
     1.516    11.097     0.200
     1.542    10.837     0.200
     1.658    11.308     0.200
     0.225     3.348     0.200
     1.203     9.685     0.200
     1.756    12.472     0.200
     1.485    11.934     0.200
     1.629    11.754     0.200
     1.565    12.295     0.200
     1.855    12.570     0.200
     1.985    12.641     0.200
     1.189     9.337     0.200
     1.111     9.323     0.200
     1.401     9.823     0.200
     1.422    10.425     0.200
     1.505    10.570     0.200
     1.498    10.742     0.200
     1.574    11.263     0.200
     1.642    10.487     0.200
     1.789    11.605     0.200
     0.267     2.751     0.200
     0.999     8.236     0.200
     1.261    10.956     0.200
     1.427    12.773     0.200
     1.496    12.301     0.200
     1.564    12.088     0.200
     0.687     6.000     0.200
     0.790     6.627     0.200
     1.049     9.629     0.200
     1.197     9.496     0.200
     1.475    12.932     0.200
     1.635    12.212     0.200
     1.718    13.039     0.200
     1.846    13.156     0.200
     1.846    14.453     0.200
     2.017    13.480     0.200
     2.009    14.990     0.200
     2.329    14.879     0.200
     0.456     4.582     0.200
     0.578     6.023     0.200
     0.586     5.064     0.200
     0.815     7.999     0.200
     0.815     8.811     0.200
     1.279    10.511     0.200
     1.279    10.401     0.200
     1.568    11.022     0.200
     1.814    13.331     0.200
     1.969    13.136     0.200
     1.955    13.400     0.200
     2.148    13.232     0.200
     2.250    13.724     0.200
     0.366     3.950     0.200
     0.366     4.075     0.200
     0.497     4.901     0.200
     0.497     4.713     0.200
     0.498     4.816     0.200
     0.786     7.367     0.200
     1.151    10.159     0.200
     1.166     8.776     0.200
     1.117     9.196     0.200
     1.205     8.722     0.200
     1.717    11.871     0.200
     1.889    12.242     0.200
     2.626    14.663     0.200
     4.338    25.544     0.200
     0.343     3.732     0.200
     0.343     3.427     0.200
     0.470     4.786     0.200
     0.760     7.255     0.200
     1.036     9.285     0.200
     1.153     9.526     0.200
     1.187     9.548     0.200
     1.154     8.788     0.200
     0.314     3.176     0.200
     0.439     4.883     0.200
     1.128     9.593     0.200
     1.021     8.604     0.200
     1.170     9.672     0.200
     1.161     8.541     0.200
     0.367     4.080     0.200
     0.617     4.764     0.200
     0.894     7.674     0.200
     0.893     7.079     0.200
     0.918     7.386     0.200
     0.705     6.578     0.200
     0.780     7.517     0.200
     0.772     6.821     0.200
     1.122     8.790     0.200
     1.378    11.231     0.200
     1.613    11.939     0.200
     1.705    13.024     0.200
     1.891    13.327     0.200
     2.129    13.867     0.200
     2.278    14.092     0.200
     0.379     4.251     0.200
     0.607     5.297     0.200
     0.890     8.303     0.200
     1.559    10.632     0.200
     1.619    10.943     0.200
     1.709    10.557     0.200
     1.725    10.518     0.200
     2.556    15.787     0.200
     0.148     2.868     0.200
     0.171     2.684     0.200
     0.642     6.767     0.200
     0.694     6.035     0.200
     0.775     6.282     0.200
     1.521    11.671     0.200
     1.854    13.619     0.200
     2.161    13.834     0.200
     2.718    16.639     0.200
     0.395     4.028     0.200
     0.645     4.676     0.200
     0.942     7.309     0.200
     0.936     7.336     0.200
     0.891     7.215     0.200
     0.932     7.443     0.200
     1.340     9.650     0.200
     1.600     9.710     0.200
     1.601    10.269     0.200
     2.502    14.157     0.200
     0.271     3.877     0.200
     0.632     5.237     0.200
     0.835     7.356     0.200
     0.845     6.976     0.200
     1.111     7.590     0.200
     1.426    10.417     0.200
     0.416     4.431     0.200
     0.586     5.689     0.200
     0.886     8.475     0.200
     0.954     7.398     0.200
     0.938     7.449     0.200
     0.966     7.672     0.200
     0.966     8.445     0.200
     1.588    12.174     0.200
     2.545    15.553     0.200
     0.728     6.423     0.200
     0.761     6.999     0.200
     0.835     6.847     0.200
     0.823     8.655     0.200
     1.151     7.958     0.200
     1.434     9.277     0.200
     1.704    10.309     0.200
     1.863    11.426     0.200
     1.863    11.899     0.200
     2.053    11.640     0.200
     2.498    13.451     0.200
     0.306     4.433     0.200
     0.595     6.480     0.200
     0.871     7.308     0.200
     0.883     6.777     0.200
     1.235     8.648     0.200
     1.627    12.163     0.200
     1.600    10.367     0.200
     0.634     4.981     0.200
     0.653     6.275     0.200
     0.787     7.091     0.200
     0.787     6.149     0.200
     0.729     6.444     0.200
     0.922     7.661     0.200
     1.038     8.802     0.200
     1.148     9.247     0.200
     1.286     9.373     0.200
     1.326     9.076     0.200
     1.466    11.105     0.200
     1.452     9.664     0.200
     2.054    13.131     0.200
     0.646     6.169     0.200
     0.798     6.908     0.200
     0.829     7.257     0.200
     0.904     8.089     0.200
     1.030     8.463     0.200
     1.924    14.941     0.200
     2.111    13.508     0.200
     0.354     4.593     0.200
     0.852     5.824     0.200
     0.907     7.253     0.200
     0.802     6.496     0.200
     0.936     6.886     0.200
     1.598     9.405     0.200
     1.598     9.636     0.200
     1.637    10.180     0.200
     2.239    12.324     0.200
     0.389     4.271     0.200
     0.648     6.815     0.200
     0.842     6.570     0.200
     0.829     7.096     0.200
     0.915     7.407     0.200
     1.299     9.815     0.200
     1.205     9.133     0.200
     1.395     9.127     0.200
     1.469    10.273     0.200
     1.535    10.051     0.200
     0.381     4.945     0.200
     0.860     7.316     0.200
     0.928     7.943     0.200
     0.906     7.425     0.200
     1.217     8.523     0.200
     1.280     9.845     0.200
     1.414     9.271     0.200
     1.450    10.234     0.200
     1.516     9.384     0.200
     1.665    10.490     0.200
     0.378     4.941     0.200
     0.865     6.073     0.200
     0.806     6.688     0.200
     0.907     7.170     0.200
     1.221     7.999     0.200
     1.419     8.818     0.200
     1.511     9.917     0.200
     1.662    11.547     0.200
     0.311     3.164     0.200
     0.574     5.292     0.200
     0.909     7.171     0.200
     1.125    10.019     0.200
     1.630    12.397     0.200
     2.035    13.826     0.200
     0.393     4.341     0.200
     0.630     6.586     0.200
     0.863     7.373     0.200
     0.937     7.411     0.200
     0.893     7.763     0.200
     1.207     9.070     0.200
     1.284     9.467     0.200
     1.451     9.752     0.200
     1.516    10.010     0.200
     1.676    10.273     0.200
     0.402     4.034     0.200
     0.908     8.526     0.200
     0.951     8.251     0.200
     0.951     6.884     0.200
     0.915     7.512     0.200
     0.948     7.808     0.200
     1.099     8.562     0.200
     1.368    10.159     0.200
     1.588    10.667     0.200
     1.775    11.996     0.200
     2.431    13.514     0.200
     2.598    14.067     0.200
     2.530    15.141     0.200
     3.140    16.101     0.200
     0.418     4.264     0.200
     0.961     7.606     0.200
     1.084     8.802     0.200
     1.374    10.850     0.200
     1.607    12.124     0.200
     1.634    11.497     0.200
     1.665    11.328     0.200
     1.792    12.323     0.200
     3.445    19.283     0.200
     0.455     4.958     0.200
     0.967     8.166     0.200
     1.142     8.423     0.200
     1.198     8.311     0.200
     1.238     8.520     0.200
     1.369     9.073     0.200
     1.825    12.504     0.200
     2.349    12.602     0.200
     0.638     5.751     0.200
     0.701     6.297     0.200
     1.150     8.310     0.200
     1.245    10.235     0.200
     1.245    10.406     0.200
     1.345    10.807     0.200
     1.295    10.840     0.200
     1.381    10.097     0.200
     1.696    12.095     0.200
     1.914    12.544     0.200
     1.960    12.417     0.200
     1.969    13.338     0.200
     0.847     7.473     0.200
     0.933     8.683     0.200
     1.168     9.841     0.200
     1.121     9.994     0.200
     1.180     9.454     0.200
     1.169     9.869     0.200
     1.261    11.324     0.200
     1.383    10.831     0.200
     1.555    11.829     0.200
     1.586    11.024     0.200
     1.753    12.991     0.200
     1.755    12.889     0.200
     1.770    11.872     0.200
     1.953    13.369     0.200
     2.109    12.958     0.200
     0.253     2.777     0.200
     0.360     4.085     0.200
     0.603     5.368     0.200
     0.655     5.714     0.200
     0.815     7.512     0.200
     1.249     8.824     0.200
     1.623    11.192     0.200
     1.687    11.734     0.200
     1.773    13.890     0.200
     2.867    18.023     0.200
     0.278     3.820     0.200
     0.905     7.454     0.200
     0.819     6.588     0.200
     0.831     6.825     0.200
     1.057     7.461     0.200
     1.157     8.118     0.200
     0.436     4.289     0.200
     1.094     8.695     0.200
     1.524    11.356     0.200
     1.551    11.311     0.200
     2.640    17.318     0.200
     0.079     1.756     0.200
     0.879     6.285     0.200
     1.052     7.723     0.200
     1.281     9.877     0.200
     1.367    10.455     0.200
     1.814    10.948     0.200
     1.679    11.416     0.200
     1.922    11.651     0.200
     2.049    12.740     0.200
     0.527     4.687     0.200
     0.659     5.720     0.200
     1.156    10.444     0.200
     1.365    11.806     0.200
     2.245    14.887     0.200
     2.214    16.251     0.200
     2.428    16.168     0.200
     1.008     8.956     0.200
     1.030     9.364     0.200
     1.100     9.169     0.200
     1.100     9.611     0.200
     1.233    10.650     0.200
     1.246    10.420     0.200
     1.750    13.459     0.200
     1.736    13.494     0.200
     1.642    12.045     0.200
     1.700    12.360     0.200
     1.684    12.399     0.200
     2.714    15.802     0.200
     0.513     5.254     0.200
     0.628     6.026     0.200
     1.125    10.693     0.200
     1.267    11.251     0.200
     1.323    11.221     0.200
     1.653    11.930     0.200
     1.995    12.941     0.200
     2.131    13.948     0.200
     2.212    14.667     0.200
     0.797     7.754     0.200
     1.139     7.786     0.200
     0.626     5.561     0.200
     0.868     7.255     0.200
     1.061     8.579     0.200
     1.211     9.708     0.200
     1.331    11.500     0.200
     1.542    12.021     0.200
     1.966    15.363     0.200
     1.951    13.848     0.200
     2.009    14.082     0.200
     2.069    14.915     0.200
     0.278     3.724     0.200
     0.485     4.479     0.200
     0.611     5.407     0.200
     0.879     7.454     0.200
     1.225     8.814     0.200
     1.236    10.292     0.200
     2.014    13.672     0.200
     2.205    14.339     0.200
     0.576     5.767     0.200
     1.031     9.770     0.200
     0.959     8.960     0.200
     1.233    10.159     0.200
     1.321    10.691     0.200
     1.208    11.598     0.200
     1.449    11.563     0.200
     1.990    14.576     0.200
     1.965    14.790     0.200
     0.658     7.003     0.200
     0.834     7.212     0.200
     0.840     6.753     0.200
     0.914     7.265     0.200
     0.896     8.365     0.200
     1.193     9.823     0.200
     1.310    10.409     0.200
     1.479    10.563     0.200
     1.544    10.400     0.200
     1.683    11.393     0.200
     1.816    11.651     0.200
     2.127    12.424     0.200
     0.468     5.366     0.200
     0.523     5.344     0.200
     0.973     8.838     0.200
     1.074     8.873     0.200
     1.011     8.388     0.200
     1.232     8.406     0.200
     1.311     9.042     0.200
     1.592     9.330     0.200
     1.649    10.132     0.200
     1.959    13.080     0.200
     2.721    15.604     0.200
     0.603     5.677     0.200
     0.695     6.799     0.200
     0.833     6.485     0.200
     0.901     7.381     0.200
     1.182     9.242     0.200
     1.165     8.734     0.200
     1.373    10.060     0.200
     1.405     9.029     0.200
     1.393     9.225     0.200
     1.479     9.502     0.200
     1.476     9.062     0.200
     1.460    10.104     0.200
     1.691    10.491     0.200
     0.753     7.514     0.200
     0.752     6.433     0.200
     0.816     6.779     0.200
     1.078     9.228     0.200
     1.365    10.915     0.200
     1.506    12.377     0.200
     1.567    12.243     0.200
     1.843    13.837     0.200
     1.934    14.823     0.200
     2.125    14.491     0.200
     2.109    13.845     0.200
     2.384    14.587     0.200
     0.458     5.309     0.200
     0.812     6.648     0.200
     0.970     7.993     0.200
     0.620     6.650     0.200
     0.825     7.390     0.200
     1.122     9.902     0.200
     1.216    10.274     0.200
     1.420     9.802     0.200
     1.409    11.516     0.200
     1.502    10.068     0.200
     2.046    12.358     0.200
     2.543    15.479     0.200
     2.731    14.884     0.200
     0.736     6.094     0.200
     0.863     8.077     0.200
     0.894     7.370     0.200
     0.894     8.087     0.200
     0.835     8.005     0.200
     1.150    10.542     0.200
     1.156     9.982     0.200
     1.427    10.042     0.200
     1.537    10.740     0.200
     1.541    10.533     0.200
     1.697    12.286     0.200
     1.664    11.289     0.200
     1.909    11.753     0.200
     1.937    12.357     0.200
     2.348    16.152     0.200
     2.406    15.664     0.200
     2.890    17.873     0.200
     0.478     4.397     0.200
     1.023     7.217     0.200
     1.181     9.451     0.200
     1.309     9.163     0.200
     1.314    10.142     0.200
     1.393    10.032     0.200
     1.443    10.553     0.200
     1.470    10.601     0.200
     1.507    11.200     0.200
     1.712    11.192     0.200
     1.937    11.488     0.200
     0.499     4.651     0.200
     1.198     9.629     0.200
     1.306     9.521     0.200
     1.295    10.749     0.200
     1.451    10.922     0.200
     1.480    10.925     0.200
     1.523    10.522     0.200
     0.547     5.144     0.200
     1.221    11.247     0.200
     1.335     9.755     0.200
     1.530    11.109     0.200
     1.568    11.051     0.200
     1.626    11.505     0.200
     1.841    12.641     0.200
     2.083    13.779     0.200
     0.542     5.184     0.200
     0.752     7.272     0.200
     0.867     7.437     0.200
     1.014     8.000     0.200
     1.819    12.185     0.200
     2.527    12.639     0.200
     0.496     5.207     0.200
     0.614     6.117     0.200
     1.196     9.296     0.200
     1.156     8.864     0.200
     1.406     9.817     0.200
     1.446     9.544     0.200
     1.491     9.617     0.200
     0.720     6.632     0.200
     0.755     5.818     0.200
     0.815     7.884     0.200
     1.080     6.714     0.200
     1.332     9.851     0.200
     1.427    10.689     0.200
     1.544    10.860     0.200
     1.539    10.198     0.200
     1.836    11.426     0.200
     1.965    12.558     0.200
     2.123    12.839     0.200
     2.390    13.982     0.200
     0.722     6.502     0.200
     0.856     6.250     0.200
     0.933     6.780     0.200
     0.839     6.595     0.200
     0.848     7.425     0.200
     1.231     9.311     0.200
     1.469     9.461     0.200
     1.396     9.867     0.200
     1.514    10.198     0.200
     1.775    10.779     0.200
     0.425     3.644     0.200
     1.329    10.779     0.200
     1.362    12.748     0.200
     1.469    12.394     0.200
     1.278    12.095     0.200
     1.411    12.341     0.200
     1.256    11.593     0.200
     1.443    11.305     0.200
     1.519    12.527     0.200
     1.607    13.108     0.200
     1.501    11.680     0.200
     2.139    14.628     0.200
     2.105    13.600     0.200
     0.666     6.329     0.200
     0.743     7.107     0.200
     1.007     8.582     0.200
     1.133    10.150     0.200
     1.156     9.372     0.200
     1.364    10.388     0.200
     0.187     2.601     0.200
     0.560     5.174     0.200
     0.595     5.193     0.200
     0.922     9.042     0.200
     1.491    11.660     0.200
     1.708    11.942     0.200
     1.884    13.493     0.200
     2.407    14.526     0.200
     0.216     2.813     0.200
     1.411     9.936     0.200
     1.376    10.547     0.200
     1.485    10.823     0.200
     1.529    10.424     0.200
     2.017    11.959     0.200
     2.913    16.277     0.200
     0.148     2.930     0.200
     0.612     6.323     0.200
     1.152     9.079     0.200
     1.461    11.153     0.200
     1.443    11.086     0.200
     1.490    10.409     0.200
     0.476     4.808     0.200
     0.998     8.825     0.200
     1.847    12.323     0.200
     1.961    13.433     0.200
     0.844     8.615     0.200
     1.024     8.675     0.200
     0.973     9.437     0.200
     1.634    12.067     0.200
     1.832    12.612     0.200
     0.444     4.118     0.200
     0.647     5.288     0.200
     1.018     7.981     0.200
     1.115     7.896     0.200
     1.518    10.964     0.200
     1.525    10.700     0.200
     1.704    11.239     0.200
     2.090    14.277     0.200
     2.115    12.629     0.200
     2.183    14.107     0.200
     2.290    13.091     0.200
     2.979    18.303     0.200
     1.147     9.680     0.200
     1.241    10.615     0.200
     1.281     9.930     0.200
     1.365    11.198     0.200
     1.365    11.307     0.200
     1.367    11.511     0.200
     1.479    11.259     0.200
     1.841    13.213     0.200
     1.961    13.113     0.200
     0.459     4.816     0.200
     0.459     4.970     0.200
     0.539     5.113     0.200
     0.540     5.168     0.200
     0.733     7.114     0.200
     0.828     6.007     0.200
     0.907     7.318     0.200
     1.393    10.230     0.200
     4.734    27.028     0.200
     0.287     3.372     0.200
     0.616     5.396     0.200
     0.641     5.323     0.200
     0.863     7.571     0.200
     1.170     9.921     0.200
     1.189     9.164     0.200
     1.272     9.640     0.200
     1.979    14.355     0.200
     0.512     5.647     0.200
     0.791     6.546     0.200
     0.861     7.196     0.200
     1.425    11.203     0.200
     1.779    11.609     0.200
     2.406    14.808     0.200
     3.139    17.250     0.200
     0.716     5.832     0.200
     0.853     7.672     0.200
     1.061    10.152     0.200
     1.110     9.676     0.200
     1.181    10.243     0.200
     1.456    11.684     0.200
     1.400    10.974     0.200
     1.511    12.063     0.200
     1.528    11.888     0.200
     1.810    12.802     0.200
     1.770    12.570     0.200
     2.018    13.046     0.200
     0.108     2.126     0.200
     0.591     5.537     0.200
     0.676     6.766     0.200
     0.843     6.320     0.200
     1.163     9.404     0.200
     2.811    17.268     0.200
     0.644     6.282     0.200
     0.790     6.525     0.200
     0.963     8.062     0.200
     1.570     9.282     0.200
     2.191    12.073     0.200
     2.638    14.107     0.200
     0.527     5.014     0.200
     0.545     5.275     0.200
     0.651     5.552     0.200
     0.677     6.328     0.200
     1.137     8.686     0.200
     1.307     9.160     0.200
     1.738    12.648     0.200
     0.574     5.480     0.200
     0.802     6.117     0.200
     1.195     8.329     0.200
     1.199     9.846     0.200
     1.465    12.216     0.200
     1.518    12.043     0.200
     1.488    12.083     0.200
     1.967    13.428     0.200
     0.111     2.974     0.200
     0.755     6.183     0.200
     0.964     8.189     0.200
     1.225     9.055     0.200
     1.241     9.532     0.200
     1.379    10.863     0.200
     1.627    11.343     0.200
     2.013    12.765     0.200
     2.435    13.734     0.200
     2.540    15.031     0.200
     0.293     3.832     0.200
     0.420     4.753     0.200
     0.537     5.385     0.200
     1.305     9.201     0.200
     1.334     9.345     0.200
     2.257    13.254     0.200
     2.278    13.594     0.200
     0.479     4.130     0.200
     1.012     9.193     0.200
     1.453    11.591     0.200
     0.172     2.454     0.200
     0.995     6.882     0.200
     1.527     9.707     0.200
     1.129     7.991     0.200
     1.656    10.487     0.200
     1.598    11.135     0.200
     1.655    11.034     0.200
     1.723    11.585     0.200
     1.781    10.327     0.200
     0.647     6.246     0.200
     1.305    10.188     0.200
     1.551    11.264     0.200
     1.453    10.724     0.200
     1.453    10.849     0.200
     1.553    11.303     0.200
     1.665    11.909     0.200
     1.654    10.871     0.200
     1.793    10.795     0.200
     0.273     3.905     0.200
     0.647     5.217     0.200
     0.870     8.500     0.200
     0.834     7.310     0.200
     1.087     7.833     0.200
     1.087     8.028     0.200
     0.450     3.005     0.200
     1.347    12.016     0.200
     1.444    12.442     0.200
     1.177    11.262     0.200
     1.304    11.395     0.200
     1.522    13.353     0.200
     1.347    11.991     0.200
     1.491    11.825     0.200
     1.446    12.406     0.200
     1.466    11.758     0.200
     1.670    12.794     0.200
     1.531    12.693     0.200
     1.931    13.731     0.200
     1.858    13.638     0.200
     2.107    15.550     0.200
     0.882     8.048     0.200
     1.069     8.727     0.200
     1.115     9.007     0.200
     1.204    10.127     0.200
     1.342    10.236     0.200
     1.794    12.439     0.200
     1.794    13.332     0.200
     0.380     2.305     0.200
     1.201    10.525     0.200
     1.414    12.199     0.200
     1.417    11.180     0.200
     1.420    12.463     0.200
     1.432    11.226     0.200
     1.515    12.295     0.200
     1.600    12.516     0.200
     0.566     4.331     0.200
     1.265     9.479     0.200
     1.237    10.199     0.200
     1.166    10.120     0.200
     1.485    11.175     0.200
     1.479    11.375     0.200
     1.435    10.725     0.200
     1.420    11.168     0.200
     1.607    11.307     0.200
     1.540    11.316     0.200
     1.775    11.905     0.200
     0.578     4.382     0.200
     1.270    10.793     0.200
     1.218    11.070     0.200
     1.500    12.135     0.200
     1.501    12.300     0.200
     1.325    11.066     0.200
     1.430    11.535     0.200
     1.414    11.692     0.200
     1.622    12.103     0.200
     1.535    11.975     0.200
     1.795    12.705     0.200
     0.927     8.357     0.200
     1.135     8.408     0.200
     1.232     9.731     0.200
     1.305    11.885     0.200
     1.345    10.254     0.200
     1.456    11.358     0.200
     2.292    15.498     0.200
     2.360    14.177     0.200
     0.891     8.166     0.200
     1.135     8.890     0.200
     1.182     9.404     0.200
     1.483    11.295     0.200
     1.712    12.615     0.200
     0.072     2.767     0.200
     0.495     4.681     0.200
     0.539     5.584     0.200
     0.951     8.336     0.200
     1.026     8.790     0.200
     1.062     9.363     0.200
     1.249     9.161     0.200
     1.319     9.685     0.200
     1.341     9.480     0.200
     1.605    10.729     0.200
     1.637    10.570     0.200
     1.853    13.130     0.200
     1.998    14.055     0.200
     2.213    12.592     0.200
     2.483    13.011     0.200
     2.703    14.554     0.200
     3.203    16.019     0.200
     0.830     7.143     0.200
     1.066     8.633     0.200
     1.105     8.396     0.200
     1.180     9.678     0.200
     1.259     7.769     0.200
     1.282    10.250     0.200
     1.535    11.064     0.200
     1.649    10.849     0.200
     2.332    14.868     0.200
     0.479     5.117     0.200
     0.773     5.535     0.200
     0.720     5.405     0.200
     0.987     6.434     0.200
     1.138     7.549     0.200
     0.630     6.425     0.200
     0.677     5.819     0.200
     0.715     6.146     0.200
     1.201     8.918     0.200
     1.667    11.639     0.200
     1.922    12.880     0.200
     0.949     8.876     0.200
     1.124     9.072     0.200
     1.195     9.944     0.200
     1.191    10.008     0.200
     1.234    10.348     0.200
     1.315    11.321     0.200
     1.374    11.526     0.200
     1.478    11.783     0.200
     2.285    16.073     0.200
     0.136     2.983     0.200
     0.304     3.542     0.200
     0.433     4.462     0.200
     0.603     5.375     0.200
     0.802     6.903     0.200
     1.201     9.631     0.200
     1.212     9.720     0.200
     2.048    12.016     0.200
     2.387    13.774     0.200
     2.498    13.669     0.200
     0.782     6.963     0.200
     1.011     9.816     0.200
     1.109     9.841     0.200
     1.253    10.321     0.200
     1.329    10.003     0.200
     1.851    14.456     0.200
     1.866    15.910     0.200
     0.208     2.527     0.200
     1.045     8.012     0.200
     1.390    10.276     0.200
     1.580    12.121     0.200
     1.521    11.284     0.200
     1.726    12.409     0.200
     1.806    12.096     0.200
     2.219    13.587     0.200
     2.378    15.462     0.200
     0.871     8.005     0.200
     1.417    10.362     0.200
     1.797    12.371     0.200
     1.774    11.697     0.200
     2.016    12.804     0.200
     2.073    12.327     0.200
     0.475     5.066     0.200
     0.801     7.295     0.200
     0.940     7.650     0.200
     1.055     7.975     0.200
     1.229     8.405     0.200
     1.361     8.931     0.200
     0.411     4.163     0.200
     0.761     6.358     0.200
     0.761     6.736     0.200
     1.484    11.061     0.200
     1.563    10.975     0.200
     1.523    11.160     0.200
     0.123     1.856     0.200
     0.393     4.278     0.200
     0.332     3.248     0.200
     0.447     4.160     0.200
     0.550     5.614     0.200
     1.436    11.736     0.200
     1.648    12.130     0.200
     2.240    14.547     0.200
     2.549    15.828     0.200
     0.999     8.725     0.200
     0.746     6.937     0.200
     0.524     5.711     0.200
     0.977     7.875     0.200
     1.388    11.119     0.200
     1.487    10.737     0.200
     1.522    11.241     0.200
     2.020    13.298     0.200
     0.432     5.214     0.200
     0.824     7.114     0.200
     0.858     8.039     0.200
     0.951     8.497     0.200
     0.983     8.059     0.200
     0.997     8.212     0.200
     1.462    11.713     0.200
     1.629    12.398     0.200
     1.815    12.514     0.200
     0.753     5.596     0.200
     0.691     6.496     0.200
     0.763     5.856     0.200
     0.763     6.028     0.200
     0.950     7.807     0.200
     1.044     8.486     0.200
     1.130     8.572     0.200
     1.805    11.063     0.200
     2.080    11.820     0.200
     0.781     7.334     0.200
     0.838     6.784     0.200
     0.888     7.202     0.200
     0.974     8.325     0.200
     0.974     8.578     0.200
     0.997     8.625     0.200
     1.300    10.303     0.200
     2.098    12.951     0.200
     2.239    13.774     0.200
     0.594     5.895     0.200
     0.818     7.993     0.200
     0.818     7.372     0.200
     0.939     6.219     0.200
     0.936     7.984     0.200
     0.891     7.086     0.200
     0.872     6.966     0.200
     1.091     8.449     0.200
     1.623    12.465     0.200
     2.285    12.822     0.200
     0.651     6.151     0.200
     0.949     7.139     0.200
     0.877     7.434     0.200
     0.904     7.311     0.200
     0.966     8.259     0.200
     1.474     9.671     0.200
     1.641    10.508     0.200
     0.141     2.237     0.200
     0.528     5.073     0.200
     0.528     5.573     0.200
     0.553     6.046     0.200
     0.950     8.194     0.200
     1.118     9.922     0.200
     1.002     9.462     0.200
     1.198     9.277     0.200
     1.198     7.638     0.200
     1.198     8.851     0.200
     1.387    10.612     0.200
     1.497    11.014     0.200
     1.728    11.565     0.200
     1.906    11.355     0.200
     2.042    13.368     0.200
     0.297     2.731     0.200
     1.148    10.104     0.200
     1.352     9.966     0.200
     1.149     9.327     0.200
     1.498    11.944     0.200
     1.570    10.760     0.200
     1.473    12.307     0.200
     1.550    11.901     0.200
     1.626    12.093     0.200
     1.825    11.780     0.200
     0.419     4.023     0.200
     1.088     8.706     0.200
     1.224     9.345     0.200
     1.126     9.393     0.200
     1.278     9.467     0.200
     1.300    10.096     0.200
     1.825    11.186     0.200
     0.993     8.824     0.200
     1.516    10.952     0.200
     1.547    10.615     0.200
     1.626    11.795     0.200
     1.665    11.579     0.200
     1.626    11.342     0.200
     1.626    10.327     0.200
     1.775    11.542     0.200
     1.775    11.278     0.200
     1.658    11.645     0.200
     1.982    12.195     0.200
     2.167    12.480     0.200
     2.593    13.970     0.200
     0.897     8.244     0.200
     1.026     9.352     0.200
     1.340    10.525     0.200
     1.298    11.822     0.200
     1.511    12.014     0.200
     1.492    12.617     0.200
     2.056    14.246     0.200
     3.588    21.820     0.200
     0.705     5.852     0.200
     1.257     9.773     0.200
     1.339    10.606     0.200
     1.337    11.884     0.200
     1.607    12.093     0.200
     1.658    12.201     0.200
     1.744    13.002     0.200
     2.026    12.658     0.200
     2.663    16.876     0.200
     0.600     5.970     0.200
     0.662     5.247     0.200
     0.960     8.495     0.200
     1.125     9.266     0.200
     1.139     8.685     0.200
     1.141     8.458     0.200
     1.327    10.305     0.200
     1.533    10.578     0.200
     1.642    10.434     0.200
     1.669    10.500     0.200
     2.286    14.140     0.200
     0.328     4.825     0.200
     0.873     7.861     0.200
     1.301     8.864     0.200
     1.466     9.339     0.200
     1.646    10.552     0.200
     1.737    10.080     0.200
     0.532     5.881     0.200
     0.685     6.198     0.200
     0.825     7.339     0.200
     1.108     8.084     0.200
     1.215     7.880     0.200
     1.230     8.788     0.200
     1.466     8.943     0.200
     2.049    11.960     0.200
     2.113    11.159     0.200
     0.061     3.233     0.200
     0.716     7.226     0.200
     1.117    10.207     0.200
     1.704    11.351     0.200
     1.828    11.884     0.200
     1.968    12.328     0.200
     1.961    11.997     0.200
     2.242    13.826     0.200
     2.414    13.394     0.200
     2.515    16.177     0.200
     0.261     5.119     0.200
     0.638     5.272     0.200
     0.638     5.799     0.200
     0.826     7.915     0.200
     1.413     9.050     0.200
     1.557     9.592     0.200
     1.656     9.854     0.200
     1.836    10.281     0.200
     2.641    13.040     0.200
     0.454     5.191     0.200
     0.466     5.097     0.200
     1.074     8.487     0.200
     1.245     8.325     0.200
     1.544     9.566     0.200
     1.978    10.584     0.200
     0.527     4.097     0.200
     0.693     6.914     0.200
     0.749     6.588     0.200
     1.015     7.113     0.200
     1.286     8.723     0.200
     1.286     9.475     0.200
     1.442    10.026     0.200
     1.474     9.792     0.200
     4.092    23.090     0.200
     0.771     7.120     0.200
     0.780     7.902     0.200
     0.828     7.267     0.200
     1.068     8.981     0.200
     1.445    11.452     0.200
     1.550    12.105     0.200
     1.820    13.085     0.200
     1.793    13.431     0.200
     2.109    13.681     0.200
     2.109    14.184     0.200
     2.191    13.619     0.200
     0.384     4.230     0.200
     0.738     7.059     0.200
     0.738     6.606     0.200
     0.950     7.219     0.200
     0.950     8.688     0.200
     0.950     7.742     0.200
     1.290     9.542     0.200
     1.345    10.344     0.200
     1.477    11.118     0.200
     1.542    11.443     0.200
     1.567    11.150     0.200
     1.670    10.338     0.200
     2.150    13.719     0.200
     2.155    13.423     0.200
     2.209    13.241     0.200
     1.271    10.039     0.200
     1.577    12.092     0.200
     1.577    12.371     0.200
     2.051    15.432     0.200
     2.051    14.743     0.200
     0.724     6.396     0.200
     1.342    10.245     0.200
     1.342    10.113     0.200
     0.356     3.840     0.200
     0.356     3.699     0.200
     0.557     5.117     0.200
     0.431     4.292     0.200
     0.431     4.363     0.200
     0.590     6.123     0.200
     1.209     7.985     0.200
     0.750     6.793     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.662    44.312     0.200
     7.696   108.570     0.200
    24.363   313.070     0.200
     1.458    31.980     0.200
     1.474    31.793     0.200
     3.660    56.620     0.200
     7.497   102.835     0.200
    17.382   233.475     0.200
     1.672    32.909     0.200
     1.828    33.091     0.200
     7.309   105.324     0.200
     7.882   111.438     0.200
    17.486   233.356     0.200
     1.822    30.862     0.200
     1.822    32.862     0.200
     4.169    61.768     0.200
     6.219    85.342     0.200
     6.586    88.762     0.200
     7.300    99.429     0.200
     8.221   110.385     0.200
     9.343   128.193     0.200
     3.858    59.198     0.200
     3.860    60.996     0.200
     6.541    93.714     0.200
     7.010   100.739     0.200
     2.250    40.567     0.200
     4.599    70.145     0.200
     5.546    81.394     0.200
     5.458    80.920     0.200
     5.521    80.395     0.200
     5.778    80.390     0.200
     5.894    82.537     0.200
     7.089   101.097     0.200
     7.653   107.514     0.200
     8.156   110.643     0.200
     8.648   117.199     0.200
     8.657   116.290     0.200
     8.759   117.599     0.200
     9.578   128.547     0.200
    11.249   147.043     0.200
    20.812   279.041     0.200
     3.863    58.429     0.200
     5.302    78.241     0.200
     5.776    83.099     0.200
     6.062    84.769     0.200
     6.316    88.804     0.200
     6.535    91.239     0.200
     6.626    93.182     0.200
     6.930    95.631     0.200
     7.020    98.579     0.200
     7.534   104.582     0.200
     8.447   115.431     0.200
     8.769   118.177     0.200
    19.986   261.272     0.200
    20.581   272.331     0.200
    20.654   269.875     0.200
    23.127   299.616     0.200
     3.478    50.930     0.200
     3.845    58.649     0.200
     3.804    58.127     0.200
     4.214    59.743     0.200
     5.289    73.394     0.200
     5.621    77.027     0.200
     5.766    79.729     0.200
     5.533    79.951     0.200
     5.533    81.951     0.200
     5.987    83.055     0.200
     6.061    83.094     0.200
     6.311    86.572     0.200
     6.616    89.306     0.200
     6.642    89.006     0.200
     7.029    95.494     0.200
     7.940   106.863     0.200
     7.986   106.322     0.200
     9.510   124.036     0.200
     9.548   129.391     0.200
    10.306   132.152     0.200
    12.106   159.237     0.200
    12.410   161.690     0.200
    20.587   273.272     0.200
    20.793   270.860     0.200
    21.989   284.913     0.200
     1.761    31.135     0.200
     1.764    31.106     0.200
     2.342    38.359     0.200
     2.705    44.123     0.200
     3.295    51.736     0.200
     3.790    55.962     0.200
     3.833    57.961     0.200
     4.255    62.027     0.200
     4.416    64.649     0.200
     5.813    80.852     0.200
     6.934    92.968     0.200
     2.120    38.969     0.200
     2.587    45.013     0.200
     2.505    43.977     0.200
     2.769    44.497     0.200
     2.806    45.956     0.200
     2.961    46.957     0.200
     3.103    49.693     0.200
     3.339    52.134     0.200
     3.858    59.179     0.200
     3.860    58.861     0.200
     4.332    64.658     0.200
     4.345    64.196     0.200
     4.804    71.139     0.200
     1.706    33.009     0.200
     2.095    38.463     0.200
     2.434    39.514     0.200
     2.557    42.570     0.200
     2.803    46.206     0.200
     2.827    46.724     0.200
     2.999    48.022     0.200
     3.111    48.215     0.200
     3.569    56.262     0.200
     3.874    58.903     0.200
     4.327    64.413     0.200
     4.396    67.117     0.200
     4.733    71.678     0.200
     1.120    25.777     0.200
     1.684    32.202     0.200
     2.369    41.707     0.200
     2.325    40.216     0.200
     2.841    49.192     0.200
     2.874    48.405     0.200
     2.988    50.084     0.200
     3.049    49.761     0.200
     3.291    53.043     0.200
     3.442    53.775     0.200
     3.535    56.696     0.200
     3.693    58.251     0.200
     3.813    62.846     0.200
     4.085    64.074     0.200
     4.102    64.083     0.200
     4.618    71.152     0.200
     4.861    71.720     0.200
     5.224    73.182     0.200
     6.000    85.627     0.200
     6.617    90.924     0.200
     7.019    98.842     0.200
     1.128    24.427     0.200
     1.412    26.121     0.200
     1.574    29.223     0.200
     1.761    31.044     0.200
     2.304    36.997     0.200
     2.936    47.030     0.200
     3.032    48.817     0.200
     3.342    52.200     0.200
     3.654    54.949     0.200
     4.038    61.474     0.200
     4.127    60.228     0.200
     5.404    73.534     0.200
     6.527    89.925     0.200
     7.157    97.671     0.200
     1.361    26.488     0.200
     1.939    35.240     0.200
     2.243    39.688     0.200
     2.455    42.719     0.200
     2.604    42.478     0.200
     2.628    44.694     0.200
     3.215    52.847     0.200
     3.518    54.809     0.200
     3.649    57.784     0.200
     3.663    57.119     0.200
     3.716    59.701     0.200
     3.797    60.056     0.200
     3.913    60.501     0.200
     3.974    60.986     0.200
     3.972    60.410     0.200
     4.216    64.065     0.200
     4.361    65.972     0.200
     4.572    67.317     0.200
     5.026    75.617     0.200
     1.988    34.467     0.200
     2.335    38.409     0.200
     2.167    37.678     0.200
     2.641    43.842     0.200
     2.728    43.627     0.200
     2.830    45.443     0.200
     2.879    45.465     0.200
     3.575    52.445     0.200
     3.646    53.610     0.200
     4.252    63.543     0.200
     5.022    70.256     0.200
     1.100    26.183     0.200
     1.205    25.457     0.200
     1.583    28.541     0.200
     1.716    31.992     0.200
     2.866    47.975     0.200
     3.006    48.434     0.200
     3.070    51.191     0.200
     3.309    53.101     0.200
     3.464    55.696     0.200
     3.717    57.737     0.200
     3.867    56.894     0.200
     3.869    57.364     0.200
     3.802    59.154     0.200
     4.078    60.128     0.200
     4.100    63.165     0.200
     4.122    63.318     0.200
     4.246    61.267     0.200
     4.195    63.062     0.200
     4.464    64.821     0.200
     4.878    72.496     0.200
     1.890    33.400     0.200
     1.890    35.400     0.200
     1.890    36.400     0.200
     1.933    34.792     0.200
     2.010    37.002     0.200
     2.739    42.037     0.200
     2.942    46.423     0.200
     3.194    49.276     0.200
     3.362    51.826     0.200
     3.631    55.183     0.200
     3.681    55.096     0.200
     3.752    55.670     0.200
     4.338    65.729     0.200
     4.397    64.440     0.200
     4.490    66.458     0.200
     4.706    69.938     0.200
     4.791    70.548     0.200
     4.877    72.141     0.200
     5.071    74.578     0.200
     5.087    75.484     0.200
     5.094    73.809     0.200
     5.865    83.504     0.200
     6.539    91.037     0.200
     6.950    95.346     0.200
     7.207   102.849     0.200
     1.693    30.598     0.200
     1.693    32.098     0.200
     2.472    42.000     0.200
     2.472    44.000     0.200
     3.190    49.624     0.200
     3.969    63.531     0.200
     4.023    61.899     0.200
     4.850    70.057     0.200
     4.854    69.905     0.200
     4.957    71.999     0.200
     5.068    74.410     0.200
     5.119    73.811     0.200
     5.192    74.860     0.200
     5.372    76.961     0.200
     5.503    77.230     0.200
     6.107    87.082     0.200
     6.894    95.202     0.200
     7.695   107.246     0.200
     2.435    39.379     0.200
     2.683    43.481     0.200
     3.685    52.989     0.200
     4.149    58.467     0.200
     4.440    65.176     0.200
     4.491    66.176     0.200
     4.745    70.620     0.200
     4.777    67.939     0.200
     4.875    70.496     0.200
     4.986    70.206     0.200
     4.991    70.844     0.200
     5.054    70.509     0.200
     5.095    72.437     0.200
     5.206    73.841     0.200
     5.257    73.846     0.200
     5.329    75.300     0.200
     5.532    80.732     0.200
     5.546    78.466     0.200
     6.313    89.914     0.200
     6.994    93.467     0.200
     7.313    95.543     0.200
     7.929   104.356     0.200
     8.472   114.621     0.200
     3.315    48.848     0.200
     3.315    50.848     0.200
     3.315    52.848     0.200
     3.797    52.425     0.200
     4.263    59.693     0.200
     4.451    63.393     0.200
     4.613    67.406     0.200
     4.861    67.612     0.200
     4.996    69.938     0.200
     5.045    68.766     0.200
     5.093    70.106     0.200
     5.168    70.024     0.200
     5.172    72.374     0.200
     5.332    74.915     0.200
     5.408    75.330     0.200
     5.668    77.395     0.200
     6.437    88.019     0.200
     7.423    97.515     0.200
     2.516    43.100     0.200
     2.987    50.573     0.200
     3.393    53.588     0.200
     3.455    55.147     0.200
     3.727    56.478     0.200
     3.790    58.915     0.200
     3.774    58.620     0.200
     3.808    61.644     0.200
     3.896    59.696     0.200
     4.057    61.504     0.200
     4.086    62.060     0.200
     4.146    62.466     0.200
     4.505    68.591     0.200
     5.035    72.995     0.200
     5.371    79.663     0.200
     5.900    85.997     0.200
     5.900    83.148     0.200
     6.119    86.018     0.200
     6.811    94.708     0.200
     7.469   103.905     0.200
     2.491    39.664     0.200
     2.952    45.843     0.200
     3.183    51.243     0.200
     3.274    53.134     0.200
     3.306    50.876     0.200
     3.585    56.036     0.200
     3.682    56.847     0.200
     3.903    58.861     0.200
     3.854    58.051     0.200
     3.466    54.601     0.200
     3.813    56.317     0.200
     3.767    55.896     0.200
     3.934    57.644     0.200
     3.978    58.423     0.200
     4.361    64.774     0.200
     4.413    66.974     0.200
     4.307    64.091     0.200
     4.350    63.491     0.200
     4.575    65.873     0.200
     4.553    66.316     0.200
     5.172    76.160     0.200
     5.193    73.658     0.200
     5.797    81.165     0.200
     5.797    80.462     0.200
     6.127    85.406     0.200
     6.131    83.204     0.200
     3.712    53.327     0.200
     3.708    55.502     0.200
     3.857    56.862     0.200
     3.920    58.328     0.200
     3.984    58.576     0.200
     4.075    60.157     0.200
     4.263    61.872     0.200
     4.298    62.613     0.200
     4.497    64.089     0.200
     4.506    64.738     0.200
     5.118    73.342     0.200
     5.468    76.122     0.200
     5.628    80.392     0.200
     5.638    77.788     0.200
     5.638    78.039     0.200
     5.766    80.584     0.200
     5.960    83.618     0.200
     5.997    82.132     0.200
     6.098    83.305     0.200
     6.956    93.270     0.200
     7.207    98.968     0.200
     7.446   102.014     0.200
     7.792   105.135     0.200
     8.425   111.729     0.200
     9.404   122.126     0.200
     3.132    52.207     0.200
     3.132    54.207     0.200
     3.778    57.873     0.200
     3.935    62.225     0.200
     3.920    61.554     0.200
     3.996    60.453     0.200
     4.326    63.674     0.200
     4.447    63.964     0.200
     4.346    66.742     0.200
     4.635    68.451     0.200
     4.789    71.396     0.200
     5.516    80.293     0.200
     5.816    81.362     0.200
     5.945    86.253     0.200
     6.016    84.453     0.200
     6.016    84.157     0.200
     6.196    87.871     0.200
     6.919    95.462     0.200
     7.602   104.965     0.200
     2.208    37.813     0.200
     2.215    35.804     0.200
     2.293    36.095     0.200
     2.386    40.712     0.200
     2.422    40.887     0.200
     2.852    45.312     0.200
     3.165    45.189     0.200
     3.415    48.779     0.200
     3.423    48.981     0.200
     3.306    51.045     0.200
     3.465    53.255     0.200
     3.492    53.921     0.200
     3.780    56.983     0.200
     3.835    57.951     0.200
     4.042    57.261     0.200
     3.915    58.727     0.200
     4.378    64.677     0.200
     4.490    64.307     0.200
     4.491    66.355     0.200
     4.840    65.346     0.200
     4.739    69.281     0.200
     5.071    69.186     0.200
     5.222    70.692     0.200
     5.449    73.443     0.200
     5.428    75.961     0.200
     5.427    77.600     0.200
     5.597    76.338     0.200
     5.524    77.672     0.200
     5.685    76.586     0.200
     5.732    76.629     0.200
     5.815    78.726     0.200
     5.815    79.273     0.200
     5.887    80.323     0.200
     5.905    82.420     0.200
     6.214    82.815     0.200
     6.292    84.302     0.200
     6.650    88.324     0.200
     6.690    92.042     0.200
     6.913    95.249     0.200
     7.177    95.075     0.200
     7.460   100.518     0.200
     7.645    99.717     0.200
     7.804   102.857     0.200
     7.751   104.728     0.200
     8.179   107.105     0.200
     8.234   107.936     0.200
     8.534   114.613     0.200
     8.598   115.076     0.200
     8.849   118.103     0.200
     8.945   118.741     0.200
     9.285   120.915     0.200
     9.261   123.708     0.200
     9.570   125.808     0.200
     9.734   127.208     0.200
    10.272   134.355     0.200
    12.057   157.320     0.200
    12.649   160.813     0.200
    13.742   175.458     0.200
    14.204   179.766     0.200
    14.339   179.497     0.200
    14.785   185.790     0.200
    15.139   188.556     0.200
     2.388    41.415     0.200
     2.840    46.619     0.200
     2.984    48.891     0.200
     3.086    51.391     0.200
     3.133    51.738     0.200
     3.296    52.432     0.200
     3.394    55.040     0.200
     3.518    56.582     0.200
     3.733    58.123     0.200
     3.677    58.636     0.200
     3.920    58.077     0.200
     3.911    59.304     0.200
     3.982    59.849     0.200
     4.028    62.201     0.200
     4.087    62.585     0.200
     4.188    63.369     0.200
     4.206    64.622     0.200
     4.582    66.547     0.200
     4.560    66.108     0.200
     4.759    71.328     0.200
     4.837    72.494     0.200
     4.973    73.446     0.200
     5.338    79.172     0.200
     5.473    79.209     0.200
     5.474    79.588     0.200
     5.639    81.759     0.200
     5.639    81.361     0.200
     6.071    82.173     0.200
     1.187    28.332     0.200
     2.617    43.108     0.200
     2.887    47.982     0.200
     3.560    59.196     0.200
     3.896    58.795     0.200
     3.708    60.410     0.200
     4.252    65.239     0.200
     4.480    64.899     0.200
     4.440    64.864     0.200
     4.918    69.934     0.200
     0.897    22.430     0.200
     1.103    24.523     0.200
     1.392    26.649     0.200
     3.014    46.807     0.200
     4.096    60.822     0.200
     4.096    59.291     0.200
     4.084    59.173     0.200
     4.084    60.438     0.200
     4.154    60.655     0.200
     4.602    65.707     0.200
     4.602    64.988     0.200
     4.780    68.378     0.200
     5.173    72.871     0.200
     1.801    32.896     0.200
     2.452    39.262     0.200
     2.693    44.085     0.200
     2.836    46.011     0.200
     3.489    50.964     0.200
     3.489    51.483     0.200
     3.725    54.217     0.200
     3.725    53.209     0.200
     3.725    55.770     0.200
     3.742    53.397     0.200
     4.040    57.943     0.200
     4.040    58.433     0.200
     4.040    58.773     0.200
     1.643    31.461     0.200
     2.021    37.045     0.200
     2.700    48.119     0.200
     2.851    48.935     0.200
     2.851    46.154     0.200
     3.032    50.209     0.200
     3.032    49.475     0.200
     3.080    49.694     0.200
     3.276    54.344     0.200
     3.276    51.227     0.200
     3.378    52.214     0.200
     3.619    57.537     0.200
     3.704    59.331     0.200
     3.726    59.493     0.200
     3.952    62.236     0.200
     3.952    62.806     0.200
     3.995    64.398     0.200
     4.017    64.391     0.200
     4.094    62.890     0.200
     4.234    62.444     0.200
     4.262    65.375     0.200
     4.262    62.899     0.200
     4.609    68.847     0.200
     4.632    69.414     0.200
     4.713    68.927     0.200
     4.660    72.247     0.200
     4.660    70.521     0.200
     4.805    69.561     0.200
     4.805    69.663     0.200
     4.781    72.236     0.200
     4.781    71.759     0.200
     4.852    74.017     0.200
     5.284    77.015     0.200
     5.284    75.031     0.200
     5.314    77.913     0.200
     5.503    80.090     0.200
     5.607    82.441     0.200
     5.992    90.021     0.200
     6.202    88.675     0.200
     6.422    90.585     0.200
     6.422    89.187     0.200
     6.435    90.433     0.200
     6.435    90.331     0.200
     6.976    98.320     0.200
     7.124    98.573     0.200
     7.349   102.265     0.200
     7.858   108.536     0.200
     7.858   106.536     0.200
     8.142   110.058     0.200
     8.385   113.879     0.200
     8.494   115.957     0.200
     8.712   118.451     0.200
     9.696   131.115     0.200
     9.770   130.873     0.200
    10.083   136.666     0.200
     1.279    28.643     0.200
     1.952    32.372     0.200
     2.477    39.875     0.200
     2.897    45.887     0.200
     2.939    44.916     0.200
     2.939    47.556     0.200
     2.939    45.486     0.200
     3.051    48.430     0.200
     3.051    48.852     0.200
     3.234    50.217     0.200
     3.234    51.420     0.200
     3.321    52.638     0.200
     3.355    55.125     0.200
     3.503    57.481     0.200
     3.961    59.559     0.200
     4.010    60.422     0.200
     3.984    62.559     0.200
     4.052    58.662     0.200
     4.082    61.826     0.200
     4.151    65.074     0.200
     4.151    64.516     0.200
     4.137    61.883     0.200
     4.630    65.227     0.200
     4.671    65.640     0.200
     4.760    68.593     0.200
     4.977    69.244     0.200
     4.977    70.470     0.200
     5.120    72.708     0.200
     5.253    73.453     0.200
     5.276    78.735     0.200
     5.276    78.188     0.200
     5.626    80.459     0.200
     5.626    80.830     0.200
     5.781    82.697     0.200
     6.118    84.065     0.200
     6.216    85.916     0.200
     6.660    90.139     0.200
     7.048    98.505     0.200
     7.014    95.980     0.200
     7.177   102.632     0.200
     7.529   101.488     0.200
     7.984   107.737     0.200
     7.984   109.479     0.200
     8.172   110.819     0.200
     1.091    25.656     0.200
     2.455    38.739     0.200
     2.899    46.797     0.200
     3.015    47.943     0.200
     2.894    45.121     0.200
     2.894    45.613     0.200
     3.080    49.084     0.200
     3.186    49.967     0.200
     3.281    52.090     0.200
     3.317    50.055     0.200
     3.474    54.102     0.200
     3.474    55.342     0.200
     3.943    62.618     0.200
     4.058    59.777     0.200
     3.964    57.854     0.200
     4.131    62.736     0.200
     4.065    58.681     0.200
     4.197    65.903     0.200
     4.707    68.548     0.200
     4.643    66.103     0.200
     4.695    65.292     0.200
     4.978    68.432     0.200
     4.978    68.862     0.200
     5.228    75.609     0.200
     5.228    77.469     0.200
     6.118    84.592     0.200
     7.526   102.151     0.200
     1.925    35.649     0.200
     4.264    65.792     0.200
     4.425    66.262     0.200
     5.204    74.304     0.200
     5.185    77.355     0.200
     5.335    76.369     0.200
     5.332    79.251     0.200
     5.523    79.761     0.200
     5.754    83.170     0.200
     5.854    82.851     0.200
     5.907    85.433     0.200
     6.024    85.524     0.200
     6.336    89.879     0.200
     6.344    89.125     0.200
     7.399   103.565     0.200
     7.467   103.981     0.200
     7.429   101.608     0.200
     1.283    29.008     0.200
     1.963    35.360     0.200
     2.447    39.703     0.200
     4.253    65.200     0.200
     4.424    66.509     0.200
     4.492    67.846     0.200
     5.216    74.218     0.200
     5.162    77.393     0.200
     5.223    75.674     0.200
     5.247    78.834     0.200
     5.341    76.507     0.200
     5.320    78.082     0.200
     5.543    79.280     0.200
     5.650    80.244     0.200
     5.767    82.363     0.200
     5.845    83.397     0.200
     5.845    83.729     0.200
     5.888    85.614     0.200
     5.888    86.551     0.200
     6.010    85.130     0.200
     6.351    89.551     0.200
     6.351    88.021     0.200
     7.218    97.338     0.200
     7.204   101.192     0.200
     7.475   102.137     0.200
     7.419   100.562     0.200
     7.419   101.531     0.200
     7.419   101.082     0.200
     8.035   110.002     0.200
     8.035   111.483     0.200
     8.919   120.377     0.200
     9.501   127.542     0.200
     9.501   128.124     0.200
     9.546   127.190     0.200
     9.546   126.471     0.200
     1.395    29.190     0.200
     2.897    47.660     0.200
     3.347    54.411     0.200
     3.554    57.433     0.200
     4.878    71.170     0.200
     4.889    72.013     0.200
     5.162    75.950     0.200
     5.359    76.436     0.200
     5.450    77.874     0.200
     5.911    82.864     0.200
     6.060    85.649     0.200
     7.051    96.686     0.200
     1.792    32.949     0.200
     2.610    44.912     0.200
     3.096    51.231     0.200
     3.696    55.394     0.200
     3.842    58.073     0.200
     4.131    60.194     0.200
     4.150    63.550     0.200
     4.343    65.741     0.200
     4.505    68.148     0.200
     4.621    68.760     0.200
     4.725    71.124     0.200
     4.759    71.678     0.200
     4.864    69.439     0.200
     5.077    71.643     0.200
     5.119    73.421     0.200
     5.387    79.882     0.200
     5.387    81.093     0.200
     5.448    77.425     0.200
     5.515    78.409     0.200
     5.560    80.134     0.200
     5.560    81.587     0.200
     5.645    79.493     0.200
     6.141    85.127     0.200
     6.157    87.018     0.200
     6.249    88.839     0.200
     6.660    94.971     0.200
     6.660    97.745     0.200
     6.847    95.861     0.200
     7.008    93.554     0.200
     7.008    96.023     0.200
     7.280    98.702     0.200
     7.278    98.729     0.200
     7.833   105.855     0.200
     7.872   106.724     0.200
     7.942   107.015     0.200
     8.205   111.018     0.200
     9.191   123.306     0.200
     9.241   122.469     0.200
     9.350   124.135     0.200
     9.747   128.818     0.200
    10.538   138.996     0.200
    10.580   141.067     0.200
    10.654   140.175     0.200
    10.826   144.929     0.200
    10.855   144.983     0.200
    10.892   145.715     0.200
    15.246   197.445     0.200
    15.654   201.477     0.200
     0.923    22.838     0.200
     0.979    23.184     0.200
     1.277    26.713     0.200
     1.266    27.841     0.200
     1.695    31.834     0.200
     2.386    39.759     0.200
     2.952    48.123     0.200
     2.984    45.782     0.200
     3.027    47.630     0.200
     3.135    48.022     0.200
     3.337    52.921     0.200
     3.337    54.773     0.200
     3.676    57.151     0.200
     3.822    55.533     0.200
     3.929    56.585     0.200
     4.036    62.888     0.200
     4.072    62.698     0.200
     4.221    60.149     0.200
     4.382    63.171     0.200
     4.506    65.777     0.200
     4.694    69.446     0.200
     4.731    69.867     0.200
     4.731    69.000     0.200
     4.941    69.324     0.200
     5.638    79.959     0.200
     6.067    82.808     0.200
     6.086    87.063     0.200
     0.991    23.895     0.200
     4.753    70.031     0.200
     5.177    74.702     0.200
     5.635    82.653     0.200
     6.054    83.706     0.200
     6.141    85.004     0.200
     6.512    91.211     0.200
     7.158    96.321     0.200
     0.983    23.135     0.200
     3.248    48.707     0.200
     4.018    58.583     0.200
     4.084    57.814     0.200
     4.556    64.133     0.200
     4.743    68.762     0.200
     5.102    70.338     0.200
     5.102    73.170     0.200
     5.611    78.141     0.200
     1.191    27.496     0.200
     2.733    45.008     0.200
     4.513    69.353     0.200
     4.673    68.446     0.200
     4.934    73.535     0.200
     5.808    78.762     0.200
     5.894    81.198     0.200
     5.932    83.274     0.200
     6.172    85.765     0.200
     6.212    91.400     0.200
     6.279    88.432     0.200
     6.367    89.203     0.200
     6.959    97.089     0.200
     7.115    97.764     0.200
     7.840   105.313     0.200
     8.044   108.927     0.200
     1.037    23.443     0.200
     1.762    30.704     0.200
     1.766    30.632     0.200
     2.147    36.629     0.200
     2.266    39.103     0.200
     2.274    36.696     0.200
     2.741    43.391     0.200
     2.998    47.579     0.200
     3.090    47.078     0.200
     3.752    59.933     0.200
     3.752    58.546     0.200
     3.821    54.969     0.200
     3.875    58.100     0.200
     3.946    56.238     0.200
     4.831    67.652     0.200
     5.041    72.148     0.200
     1.054    23.232     0.200
     1.166    22.928     0.200
     1.809    30.425     0.200
     2.001    34.182     0.200
     2.240    34.951     0.200
     2.280    35.536     0.200
     2.267    38.078     0.200
     2.566    41.585     0.200
     3.031    46.585     0.200
     3.114    47.318     0.200
     3.777    58.745     0.200
     3.806    55.512     0.200
     3.883    57.007     0.200
     3.922    55.985     0.200
     4.817    66.849     0.200
     1.897    34.878     0.200
     4.077    60.957     0.200
     4.234    58.964     0.200
     4.288    60.072     0.200
     4.711    65.096     0.200
     4.684    66.561     0.200
     4.772    68.448     0.200
     5.308    73.304     0.200
     5.525    76.741     0.200
     6.285    84.385     0.200
     2.509    38.598     0.200
     2.510    42.584     0.200
     3.290    54.980     0.200
     3.899    59.378     0.200
     4.128    61.302     0.200
     4.374    64.602     0.200
     4.520    67.130     0.200
     5.257    79.182     0.200
     5.537    81.260     0.200
     5.667    81.733     0.200
     5.755    80.715     0.200
     5.796    80.219     0.200
     5.922    81.312     0.200
     6.300    91.417     0.200
     6.499    90.029     0.200
     6.539    90.668     0.200
     6.800    91.626     0.200
     6.984    94.566     0.200
     7.104    95.774     0.200
     7.123    97.944     0.200
     7.933   107.394     0.200
     1.333    28.511     0.200
     2.252    41.292     0.200
     2.927    48.408     0.200
     3.377    55.160     0.200
     3.391    53.540     0.200
     3.536    56.013     0.200
     3.866    59.977     0.200
     4.011    60.637     0.200
     4.394    66.059     0.200
     4.394    67.989     0.200
     4.770    68.702     0.200
     4.872    70.410     0.200
     4.879    71.194     0.200
     5.143    74.343     0.200
     5.359    76.036     0.200
     5.445    77.427     0.200
     5.902    82.607     0.200
     6.143    86.086     0.200
     7.042    97.089     0.200
     2.108    36.718     0.200
     2.350    40.903     0.200
     2.442    41.819     0.200
     2.455    42.668     0.200
     2.537    43.712     0.200
     2.626    43.672     0.200
     2.724    43.758     0.200
     2.725    43.723     0.200
     3.096    49.187     0.200
     3.241    53.501     0.200
     3.345    52.905     0.200
     3.651    55.717     0.200
     4.071    59.530     0.200
     4.146    64.948     0.200
     4.203    63.343     0.200
     4.211    63.714     0.200
     4.284    68.332     0.200
     4.308    64.934     0.200
     4.400    66.790     0.200
     4.485    67.626     0.200
     4.550    67.228     0.200
     4.582    69.480     0.200
     4.653    72.008     0.200
     5.192    77.069     0.200
     5.537    79.702     0.200
     5.542    80.222     0.200
     5.606    79.089     0.200
     5.746    81.370     0.200
     5.799    83.645     0.200
     5.859    81.751     0.200
     5.877    82.297     0.200
     5.880    81.902     0.200
     6.072    86.487     0.200
     6.233    89.009     0.200
     6.260    85.868     0.200
     6.285    86.273     0.200
     6.454    89.203     0.200
     6.500    89.464     0.200
     6.649    94.823     0.200
     6.748    93.634     0.200
     6.938    97.157     0.200
     7.054    97.197     0.200
     7.055    98.941     0.200
     7.079    97.216     0.200
     7.529   104.401     0.200
     7.700   100.103     0.200
     7.860   107.096     0.200
     7.881   106.850     0.200
     8.411   114.264     0.200
     8.809   118.327     0.200
     8.793   121.865     0.200
     8.887   123.409     0.200
     8.979   121.536     0.200
     9.267   124.272     0.200
     9.522   128.502     0.200
     9.652   129.923     0.200
     9.913   132.292     0.200
    10.842   144.602     0.200
     1.087    25.939     0.200
     1.312    29.312     0.200
     1.578    30.665     0.200
     1.582    30.663     0.200
     2.032    35.743     0.200
     2.173    38.265     0.200
     2.372    38.399     0.200
     2.692    44.689     0.200
     2.834    46.453     0.200
     2.834    45.303     0.200
     2.931    48.332     0.200
     2.931    46.940     0.200
     2.933    47.632     0.200
     2.922    49.785     0.200
     2.922    49.093     0.200
     3.076    50.505     0.200
     3.123    51.282     0.200
     3.259    51.615     0.200
     3.729    59.801     0.200
     3.729    61.881     0.200
     4.017    60.044     0.200
     4.017    59.652     0.200
     4.179    62.390     0.200
     4.199    60.613     0.200
     4.200    60.608     0.200
     4.216    66.422     0.200
     4.554    70.475     0.200
     4.666    66.472     0.200
     4.667    66.357     0.200
     4.753    68.151     0.200
     4.966    74.491     0.200
     4.866    68.729     0.200
     5.016    72.662     0.200
     5.275    74.365     0.200
     5.328    75.842     0.200
     5.378    76.855     0.200
     6.149    86.060     0.200
     7.077    98.335     0.200
     7.257   100.926     0.200
     1.227    26.209     0.200
     1.324    28.078     0.200
     2.105    37.960     0.200
     2.645    44.668     0.200
     2.822    44.597     0.200
     2.918    47.479     0.200
     3.311    50.897     0.200
     3.610    54.227     0.200
     3.552    54.594     0.200
     3.727    53.362     0.200
     3.727    56.413     0.200
     4.058    56.943     0.200
     4.058    60.342     0.200
     4.191    60.586     0.200
     4.191    62.601     0.200
     4.311    64.799     0.200
     4.373    65.256     0.200
     4.454    66.835     0.200
     4.574    66.995     0.200
     4.763    67.523     0.200
     4.763    70.027     0.200
     4.946    69.511     0.200
     5.012    69.843     0.200
     5.054    68.726     0.200
     5.054    72.085     0.200
     5.068    72.298     0.200
     5.235    73.939     0.200
     5.296    74.424     0.200
     5.296    74.623     0.200
     5.234    75.542     0.200
     5.334    73.795     0.200
     5.334    76.299     0.200
     5.426    76.919     0.200
     5.528    77.822     0.200
     5.538    76.599     0.200
     5.626    78.176     0.200
     6.091    84.254     0.200
     6.135    85.038     0.200
     6.329    86.777     0.200
     6.886    91.767     0.200
     6.886    95.006     0.200
     6.958    96.128     0.200
     7.231    97.451     0.200
     8.339   113.506     0.200
     8.662   115.340     0.200
     9.169   120.185     0.200
     9.169   122.626     0.200
     9.300   123.590     0.200
     1.038    23.209     0.200
     1.168    27.194     0.200
     1.594    28.723     0.200
     2.562    37.754     0.200
     2.865    42.047     0.200
     4.200    58.241     0.200
     4.351    61.531     0.200
     4.363    59.510     0.200
     4.367    60.057     0.200
     4.695    65.026     0.200
     4.816    66.815     0.200
     0.943    25.075     0.200
     2.154    38.451     0.200
     3.904    59.148     0.200
     3.878    57.633     0.200
     3.908    58.232     0.200
     4.084    62.353     0.200
     4.084    61.633     0.200
     4.275    69.310     0.200
     4.236    62.819     0.200
     4.174    64.270     0.200
     4.375    63.225     0.200
     4.438    64.194     0.200
     4.483    65.269     0.200
     4.926    71.889     0.200
     5.169    74.462     0.200
     1.029    25.661     0.200
     1.116    24.644     0.200
     1.276    27.770     0.200
     1.752    31.794     0.200
     1.756    31.773     0.200
     2.141    35.970     0.200
     2.255    38.350     0.200
     2.283    36.943     0.200
     2.709    43.162     0.200
     2.756    44.373     0.200
     2.997    47.832     0.200
     3.092    47.805     0.200
     3.754    61.321     0.200
     3.754    57.610     0.200
     3.837    55.712     0.200
     3.883    57.975     0.200
     3.964    55.945     0.200
     3.974    56.790     0.200
     4.329    61.641     0.200
     4.412    62.677     0.200
     4.540    64.477     0.200
     4.623    65.115     0.200
     4.846    68.253     0.200
     5.022    70.455     0.200
     5.039    73.969     0.200
     5.142    71.956     0.200
     5.418    78.377     0.200
     0.885    20.542     0.200
     1.170    21.211     0.200
     1.657    29.408     0.200
     1.667    28.408     0.200
     1.669    28.388     0.200
     2.155    34.775     0.200
     2.203    32.739     0.200
     2.226    37.892     0.200
     2.407    36.904     0.200
     2.449    38.290     0.200
     2.598    41.288     0.200
     2.627    40.670     0.200
     2.435    40.449     0.200
     2.681    41.075     0.200
     2.688    43.892     0.200
     3.121    48.039     0.200
     3.404    47.400     0.200
     3.438    52.371     0.200
     3.476    50.700     0.200
     3.549    50.555     0.200
     3.597    51.491     0.200
     3.626    50.679     0.200
     3.624    50.706     0.200
     3.588    53.989     0.200
     3.824    53.458     0.200
     3.908    55.366     0.200
     3.779    55.765     0.200
     3.943    55.749     0.200
     3.997    56.028     0.200
     4.094    57.189     0.200
     4.092    63.577     0.200
     4.165    58.565     0.200
     4.201    58.941     0.200
     4.172    60.842     0.200
     4.104    59.972     0.200
     4.308    63.336     0.200
     4.646    62.896     0.200
     4.705    65.155     0.200
     4.705    65.455     0.200
     4.740    64.755     0.200
     4.817    67.152     0.200
     4.887    67.732     0.200
     5.038    69.112     0.200
     5.463    77.922     0.200
     5.563    77.146     0.200
     5.571    76.939     0.200
     5.571    75.314     0.200
     5.571    75.831     0.200
     5.504    77.641     0.200
     5.786    77.543     0.200
     5.821    79.242     0.200
     6.338    86.698     0.200
     6.486    85.114     0.200
     6.715    90.706     0.200
     7.001    94.264     0.200
     7.135    96.918     0.200
     7.218    96.431     0.200
     7.285    96.954     0.200
     7.602   101.254     0.200
     7.737   101.336     0.200
     7.856   103.127     0.200
     9.047   116.679     0.200
     9.086   117.092     0.200
     9.128   119.160     0.200
     9.258   122.015     0.200
     9.485   124.778     0.200
     9.490   125.014     0.200
     9.508   124.252     0.200
     9.545   127.511     0.200
     9.916   131.042     0.200
    11.735   152.815     0.200
    12.181   159.117     0.200
    12.314   160.065     0.200
    13.014   168.595     0.200
    13.778   175.076     0.200
    14.178   182.014     0.200
    14.184   181.042     0.200
     1.028    26.198     0.200
     1.278    29.779     0.200
     2.301    42.843     0.200
     2.610    42.738     0.200
     2.610    44.238     0.200
     4.640    69.542     0.200
     5.315    77.070     0.200
     5.412    77.739     0.200
     5.484    78.235     0.200
     5.505    79.546     0.200
     5.505    79.046     0.200
     5.584    80.131     0.200
     5.837    83.573     0.200
     5.837    83.073     0.200
     6.001    87.159     0.200
     6.018    85.617     0.200
     6.031    85.306     0.200
     6.600    92.085     0.200
     6.630    93.224     0.200
     6.795    96.290     0.200
     7.729   106.699     0.200
     7.729   106.399     0.200
     1.449    30.015     0.200
     1.844    34.410     0.200
     2.206    38.183     0.200
     2.381    42.140     0.200
     2.357    40.423     0.200
     2.790    46.101     0.200
     2.757    45.752     0.200
     2.950    49.499     0.200
     3.149    49.186     0.200
     3.346    53.356     0.200
     3.345    53.469     0.200
     3.384    54.443     0.200
     3.469    51.303     0.200
     3.703    57.928     0.200
     3.794    57.958     0.200
     3.850    60.998     0.200
     3.954    60.044     0.200
     4.068    62.839     0.200
     4.124    64.191     0.200
     4.232    66.055     0.200
     4.337    67.759     0.200
     4.372    65.193     0.200
     4.510    67.732     0.200
     4.579    66.035     0.200
     4.538    68.972     0.200
     4.571    67.003     0.200
     4.567    68.628     0.200
     4.697    68.516     0.200
     4.759    69.095     0.200
     4.798    68.222     0.200
     4.806    70.557     0.200
     4.806    68.229     0.200
     4.963    70.300     0.200
     4.905    73.694     0.200
     5.000    72.380     0.200
     4.998    73.702     0.200
     5.056    73.026     0.200
     5.077    72.879     0.200
     5.158    78.484     0.200
     5.178    75.968     0.200
     5.277    76.053     0.200
     5.286    76.140     0.200
     5.371    77.548     0.200
     5.635    80.175     0.200
     5.723    82.670     0.200
     5.828    82.173     0.200
     5.879    82.529     0.200
     5.879    83.122     0.200
     5.939    87.018     0.200
     5.982    85.217     0.200
     6.069    85.406     0.200
     6.271    92.450     0.200
     6.464    89.091     0.200
     6.555    90.936     0.200
     6.628    88.589     0.200
     6.628    88.714     0.200
     6.631    91.151     0.200
     6.631    91.729     0.200
     6.633    91.729     0.200
     6.711    93.719     0.200
     6.890    99.951     0.200
     6.968    95.211     0.200
     6.997    96.567     0.200
     7.520   103.168     0.200
     7.520   102.067     0.200
     7.570   104.304     0.200
     7.897   107.566     0.200
     8.099   110.988     0.200
     8.176   112.112     0.200
     8.176   115.916     0.200
     8.169   108.774     0.200
     8.879   118.510     0.200
     8.905   118.294     0.200
     8.960   120.404     0.200
     9.038   119.812     0.200
     8.996   125.567     0.200
     9.399   126.026     0.200
     9.385   128.956     0.200
     9.858   134.591     0.200
    10.064   134.623     0.200
    10.066   136.128     0.200
    10.116   133.274     0.200
    10.147   137.308     0.200
    10.180   133.766     0.200
    10.205   136.508     0.200
    10.237   138.900     0.200
    10.240   138.774     0.200
    10.268   134.628     0.200
    10.235   134.520     0.200
    10.320   136.662     0.200
    10.448   138.700     0.200
    10.451   140.701     0.200
    10.469   142.057     0.200
    10.506   141.072     0.200
    10.606   138.420     0.200
    11.458   149.658     0.200
    11.745   152.504     0.200
    12.247   157.824     0.200
    12.682   168.138     0.200
    13.076   174.625     0.200
    13.241   175.412     0.200
    14.023   181.080     0.200
    14.776   192.093     0.200
    15.264   195.797     0.200
    15.285   193.155     0.200
    15.613   199.121     0.200
    15.936   202.253     0.200
    16.037   204.478     0.200
    22.532   293.980     0.200
     0.809    21.120     0.200
     1.204    27.509     0.200
     2.389    38.584     0.200
     2.681    42.940     0.200
     3.338    52.314     0.200
     3.685    53.253     0.200
     3.707    54.030     0.200
     3.724    53.307     0.200
     3.743    53.610     0.200
     3.680    59.622     0.200
     3.853    57.743     0.200
     3.853    54.500     0.200
     3.991    57.955     0.200
     4.068    59.990     0.200
     4.096    60.366     0.200
     4.185    59.229     0.200
     4.728    66.934     0.200
     4.819    67.629     0.200
     4.939    69.626     0.200
     1.269    28.908     0.200
     1.571    30.378     0.200
     2.099    37.214     0.200
     2.455    44.061     0.200
     2.529    42.198     0.200
     4.577    64.886     0.200
     4.794    68.374     0.200
     5.118    74.704     0.200
     5.118    72.095     0.200
     5.446    76.264     0.200
     5.546    77.490     0.200
     5.623    79.696     0.200
     5.622    79.239     0.200
     5.718    81.383     0.200
     5.732    80.202     0.200
     5.960    83.665     0.200
     6.009    83.909     0.200
     6.176    88.442     0.200
     6.176    84.943     0.200
     6.178    86.601     0.200
     6.178    84.804     0.200
     6.693    92.108     0.200
     6.745    93.437     0.200
     6.937    96.265     0.200
     7.456   102.004     0.200
     7.873   107.641     0.200
     2.578    42.648     0.200
     2.891    48.994     0.200
     3.013    48.573     0.200
     3.018    48.516     0.200
     3.335    51.818     0.200
     4.616    67.166     0.200
     4.857    69.291     0.200
     4.985    72.242     0.200
     5.478    76.105     0.200
     5.468    77.864     0.200
     5.468    78.809     0.200
     5.588    77.128     0.200
     5.598    77.406     0.200
     5.701    79.304     0.200
     5.693    78.825     0.200
     5.786    82.785     0.200
     5.863    80.035     0.200
     5.845    83.676     0.200
     5.946    82.948     0.200
     6.231    85.022     0.200
     6.223    86.151     0.200
     6.287    85.167     0.200
     6.441    88.036     0.200
     6.510    89.736     0.200
     6.621    90.308     0.200
     6.716    91.463     0.200
     6.748    92.184     0.200
     6.798    92.303     0.200
     6.863    92.190     0.200
     7.022    96.492     0.200
     7.420   101.443     0.200
     7.559   101.524     0.200
     7.829   107.912     0.200
     7.975   106.666     0.200
     8.018   107.522     0.200
     8.536   112.823     0.200
     9.265   122.113     0.200
    10.040   131.134     0.200
    10.040   130.649     0.200
    10.032   130.985     0.200
    11.429   149.549     0.200
     2.273    39.944     0.200
     3.852    55.944     0.200
     4.607    66.443     0.200
     4.772    67.048     0.200
     5.193    73.042     0.200
     5.342    74.431     0.200
     5.452    76.146     0.200
     5.502    77.232     0.200
     5.488    76.825     0.200
     5.537    76.809     0.200
     5.591    78.317     0.200
     5.678    77.703     0.200
     5.835    81.179     0.200
     6.084    84.273     0.200
     6.112    84.644     0.200
     6.199    85.655     0.200
     6.236    87.717     0.200
     6.363    88.390     0.200
     6.601    89.930     0.200
     6.661    92.432     0.200
     6.685    90.922     0.200
     6.860    94.110     0.200
     7.305   100.216     0.200
     7.389   100.043     0.200
     7.773   103.196     0.200
     7.805   105.280     0.200
     8.366   112.141     0.200
     9.082   121.485     0.200
     9.842   129.650     0.200
     1.351    29.526     0.200
     1.686    31.620     0.200
     2.001    37.443     0.200
     2.264    38.873     0.200
     2.613    45.793     0.200
     3.620    56.551     0.200
     5.560    77.711     0.200
     6.708    91.307     0.200
     1.995    37.530     0.200
     2.361    42.762     0.200
     2.581    43.193     0.200
     2.715    46.624     0.200
     5.370    75.352     0.200
     5.468    76.402     0.200
     5.541    78.513     0.200
     5.555    78.483     0.200
     5.648    80.199     0.200
     5.645    81.193     0.200
     5.889    83.690     0.200
     6.083    85.608     0.200
     6.091    85.433     0.200
     6.614    92.531     0.200
     6.660    94.078     0.200
     1.947    35.270     0.200
     3.224    52.369     0.200
     4.766    67.969     0.200
     4.836    68.656     0.200
     4.883    69.659     0.200
     4.911    70.012     0.200
     5.110    72.252     0.200
     5.223    74.134     0.200
     5.343    75.241     0.200
     5.933    81.852     0.200
     1.648    33.372     0.200
     2.908    46.783     0.200
     2.908    48.775     0.200
     3.390    54.578     0.200
     3.573    57.789     0.200
     3.573    58.211     0.200
     4.218    65.654     0.200
     4.333    68.180     0.200
     4.483    68.731     0.200
     4.483    69.692     0.200
     4.531    67.773     0.200
     4.672    67.679     0.200
     4.811    75.030     0.200
     5.026    73.157     0.200
     5.407    82.241     0.200
     5.537    81.043     0.200
     5.537    79.391     0.200
     1.183    28.780     0.200
     1.537    30.647     0.200
     3.075    50.697     0.200
     3.646    59.038     0.200
     3.961    62.371     0.200
     4.173    65.884     0.200
     4.319    67.799     0.200
     4.379    65.310     0.200
     4.527    69.818     0.200
     5.368    75.644     0.200
     5.422    76.418     0.200
     5.422    78.980     0.200
     5.422    76.117     0.200
     5.451    76.408     0.200
     5.451    80.004     0.200
     5.505    78.908     0.200
     5.505    82.178     0.200
     5.560    79.995     0.200
     5.687    82.704     0.200
     5.687    83.022     0.200
     6.443    89.754     0.200
     6.443    93.192     0.200
     6.530    91.180     0.200
     6.702    92.971     0.200
     1.150    24.652     0.200
     4.001    58.029     0.200
     4.075    58.107     0.200
     4.359    62.026     0.200
     4.565    64.741     0.200
     5.092    69.827     0.200
     5.171    74.073     0.200
     5.315    78.287     0.200
     5.282    75.474     0.200
     5.568    79.140     0.200
     5.947    83.114     0.200
     6.491    90.673     0.200
     7.223    99.222     0.200
     1.813    34.095     0.200
     5.185    74.346     0.200
     5.280    74.840     0.200
     5.350    75.026     0.200
     5.447    75.878     0.200
     5.880    82.056     0.200
     5.895    82.362     0.200
     6.462    89.936     0.200
     1.559    29.812     0.200
     1.976    36.948     0.200
     3.077    48.134     0.200
     4.034    58.629     0.200
     4.109    59.350     0.200
     4.162    59.932     0.200
     4.222    62.704     0.200
     4.422    63.204     0.200
     4.479    63.793     0.200
     4.678    66.613     0.200
     4.666    65.694     0.200
     4.666    67.554     0.200
     5.241    74.271     0.200
     5.241    74.740     0.200
     1.268    27.762     0.200
     1.563    28.323     0.200
     1.990    35.342     0.200
     2.173    39.204     0.200
     2.314    38.076     0.200
     2.853    46.673     0.200
     2.853    44.673     0.200
     2.877    47.987     0.200
     3.071    49.318     0.200
     3.256    49.978     0.200
     3.309    50.941     0.200
     3.345    51.623     0.200
     3.707    56.723     0.200
     3.784    58.505     0.200
     4.022    59.026     0.200
     4.097    59.149     0.200
     4.151    59.043     0.200
     4.151    59.402     0.200
     4.061    62.124     0.200
     4.061    61.292     0.200
     4.079    62.763     0.200
     4.095    63.978     0.200
     4.141    62.377     0.200
     4.212    61.569     0.200
     4.212    60.277     0.200
     4.297    62.311     0.200
     4.297    60.802     0.200
     4.297    61.691     0.200
     4.361    63.872     0.200
     4.409    63.106     0.200
     4.463    65.475     0.200
     4.471    64.213     0.200
     4.594    65.255     0.200
     4.658    65.739     0.200
     4.668    65.989     0.200
     4.717    66.709     0.200
     4.660    66.508     0.200
     4.743    71.444     0.200
     4.743    70.564     0.200
     4.836    70.289     0.200
     4.947    75.085     0.200
     4.947    73.685     0.200
     5.230    73.727     0.200
     5.231    73.428     0.200
     5.258    73.406     0.200
     5.445    76.424     0.200
     5.690    81.002     0.200
     5.790    82.787     0.200
     5.949    81.535     0.200
     5.972    81.874     0.200
     5.972    81.024     0.200
     6.031    84.082     0.200
     6.031    82.050     0.200
     6.043    83.706     0.200
     6.096    87.604     0.200
     6.235    84.706     0.200
     6.235    83.796     0.200
     6.355    89.404     0.200
     6.450    86.313     0.200
     6.450    87.933     0.200
     7.147    95.805     0.200
     7.607   103.984     0.200
     7.607   102.544     0.200
     7.968   107.149     0.200
     7.981   109.526     0.200
     8.354   112.033     0.200
     8.438   112.782     0.200
     8.540   113.365     0.200
     9.138   124.108     0.200
     9.692   128.059     0.200
     9.789   129.804     0.200
     9.896   132.431     0.200
     9.921   132.359     0.200
    10.115   133.484     0.200
    10.149   134.422     0.200
    10.151   134.297     0.200
    10.172   134.460     0.200
    10.201   135.145     0.200
    10.573   140.781     0.200
     1.457    30.534     0.200
     2.413    42.385     0.200
     5.194    76.529     0.200
     5.298    78.004     0.200
     5.360    78.485     0.200
     5.360    76.470     0.200
     5.379    78.834     0.200
     5.379    78.068     0.200
     5.458    80.142     0.200
     5.504    80.927     0.200
     5.504    78.903     0.200
     5.590    81.510     0.200
     5.700    82.917     0.200
     5.811    84.683     0.200
     5.811    85.527     0.200
     5.943    85.684     0.200
     6.001    87.333     0.200
     6.515    91.886     0.200
     6.697    96.482     0.200
     7.222   101.864     0.200
     1.401    30.265     0.200
     1.833    35.219     0.200
     3.327    51.785     0.200
     3.791    57.694     0.200
     3.979    59.567     0.200
     3.979    58.310     0.200
     4.362    67.382     0.200
     4.362    68.413     0.200
     4.526    67.832     0.200
     4.526    69.192     0.200
     4.674    67.967     0.200
     4.739    68.608     0.200
     4.796    69.408     0.200
     4.969    70.503     0.200
     4.969    72.417     0.200
     5.028    70.568     0.200
     5.028    72.435     0.200
     5.057    72.800     0.200
     5.088    73.371     0.200
     5.265    75.060     0.200
     5.259    75.844     0.200
     5.352    76.352     0.200
     5.662    80.236     0.200
     5.819    81.228     0.200
     5.861    82.712     0.200
     6.055    85.649     0.200
     6.544    91.941     0.200
     6.646    92.665     0.200
     6.958    96.804     0.200
     6.982    94.852     0.200
     8.172   110.318     0.200
     8.903   118.502     0.200
     0.954    23.069     0.200
     1.965    35.268     0.200
     4.180    61.023     0.200
     4.466    62.732     0.200
     4.669    68.994     0.200
     5.252    73.713     0.200
     5.334    74.957     0.200
     5.391    75.566     0.200
     5.447    75.156     0.200
     5.567    78.730     0.200
     5.642    79.258     0.200
     5.804    80.864     0.200
     5.787    81.236     0.200
     5.907    82.763     0.200
     5.956    83.189     0.200
     6.238    86.605     0.200
     6.468    88.883     0.200
     6.686    92.674     0.200
     7.031    97.352     0.200
     7.188    98.112     0.200
     7.254   100.347     0.200
     7.254    97.643     0.200
     7.604   102.462     0.200
     7.660   102.182     0.200
     8.836   118.980     0.200
     8.836   118.172     0.200
     9.575   127.864     0.200
     4.290    62.120     0.200
     5.263    75.608     0.200
     5.353    77.454     0.200
     5.419    77.456     0.200
     5.475    78.571     0.200
     5.500    78.076     0.200
     5.656    80.025     0.200
     5.894    82.765     0.200
     5.953    83.555     0.200
     6.246    89.038     0.200
     6.518    90.870     0.200
     6.724    93.660     0.200
     7.234    99.902     0.200
     2.593    44.641     0.200
     4.610    69.663     0.200
     5.346    75.915     0.200
     5.456    77.334     0.200
     5.493    79.011     0.200
     5.493    77.988     0.200
     5.542    78.642     0.200
     5.596    79.804     0.200
     5.682    78.792     0.200
     5.743    81.089     0.200
     6.088    85.258     0.200
     6.116    85.933     0.200
     6.202    86.625     0.200
     6.316    87.698     0.200
     6.689    92.764     0.200
     6.864    95.698     0.200
     7.166    99.277     0.200
     5.421    76.855     0.200
     5.504    78.589     0.200
     5.562    78.294     0.200
     5.618    80.539     0.200
     5.812    82.401     0.200
     6.059    83.360     0.200
     6.078    85.990     0.200
     6.639    92.898     0.200
     1.413    26.794     0.200
     2.043    36.442     0.200
     2.524    40.127     0.200
     2.938    48.541     0.200
     3.164    50.785     0.200
     3.368    52.741     0.200
     3.988    60.120     0.200
     4.010    57.993     0.200
     4.105    65.778     0.200
     4.041    58.224     0.200
     4.169    63.773     0.200
     4.374    63.042     0.200
     4.403    64.100     0.200
     4.403    64.233     0.200
     4.428    63.808     0.200
     4.472    63.796     0.200
     5.007    71.519     0.200
     4.989    71.263     0.200
     5.277    74.398     0.200
     1.319    25.284     0.200
     3.135    49.034     0.200
     3.307    52.012     0.200
     4.050    59.138     0.200
     4.106    57.860     0.200
     4.131    58.964     0.200
     4.136    57.708     0.200
     4.171    60.233     0.200
     4.466    62.858     0.200
     4.514    64.194     0.200
     4.534    63.361     0.200
     4.538    64.022     0.200
     5.066    68.371     0.200
     5.082    71.473     0.200
     5.346    74.889     0.200
     1.303    27.782     0.200
     1.790    33.099     0.200
     2.118    36.877     0.200
     2.403    39.943     0.200
     3.495    55.204     0.200
     3.642    58.485     0.200
     3.704    56.759     0.200
     4.013    62.155     0.200
     4.861    68.489     0.200
     5.222    75.928     0.200
     5.322    75.922     0.200
     5.356    75.590     0.200
     5.475    76.101     0.200
     5.580    77.670     0.200
     5.516    80.725     0.200
     5.635    79.828     0.200
     5.635    77.848     0.200
     5.661    78.749     0.200
     5.735    80.564     0.200
     5.785    79.706     0.200
     5.871    82.278     0.200
     5.978    84.532     0.200
     6.211    85.207     0.200
     6.225    86.348     0.200
     6.263    86.437     0.200
     6.267    89.240     0.200
     6.448    88.141     0.200
     6.411    88.830     0.200
     6.729    91.668     0.200
     6.729    91.868     0.200
     6.748    91.446     0.200
     6.793    93.215     0.200
     6.796    92.398     0.200
     6.980    96.738     0.200
     7.108    96.131     0.200
     7.289    99.623     0.200
     7.211   100.131     0.200
     7.446   103.394     0.200
     7.446   102.154     0.200
     7.504   101.123     0.200
     7.642   102.121     0.200
     7.834   105.462     0.200
     7.834   105.575     0.200
     7.920   105.960     0.200
     8.051   107.612     0.200
     8.480   113.727     0.200
     8.754   116.183     0.200
     8.804   112.848     0.200
     8.806   118.226     0.200
     8.837   119.565     0.200
     9.188   120.962     0.200
     9.276   126.444     0.200
     9.365   126.403     0.200
     9.355   124.047     0.200
     9.471   125.663     0.200
     9.517   130.524     0.200
     9.809   130.825     0.200
     9.832   129.651     0.200
     9.944   131.149     0.200
    10.116   134.535     0.200
    11.188   144.172     0.200
    11.302   147.539     0.200
    11.395   147.927     0.200
    11.701   151.843     0.200
    11.718   152.636     0.200
    12.099   156.698     0.200
     1.541    29.801     0.200
     2.713    45.623     0.200
     3.169    51.304     0.200
     4.814    68.512     0.200
     4.886    69.372     0.200
     4.935    69.942     0.200
     4.970    71.129     0.200
     5.086    72.123     0.200
     5.200    73.605     0.200
     5.292    75.537     0.200
     5.386    76.142     0.200
     5.434    76.371     0.200
     5.802    81.380     0.200
     5.991    82.416     0.200
     6.219    86.009     0.200
     6.575    91.462     0.200
     7.170    96.581     0.200
     1.295    28.998     0.200
     1.518    30.499     0.200
     1.943    36.442     0.200
     2.862    45.206     0.200
     2.958    47.596     0.200
     3.074    49.648     0.200
     3.330    52.656     0.200
     3.947    59.917     0.200
     4.017    60.691     0.200
     4.086    63.524     0.200
     4.365    64.812     0.200
     4.632    67.229     0.200
     4.845    69.455     0.200
     4.879    69.879     0.200
     4.891    70.133     0.200
     5.131    74.434     0.200
     5.379    76.307     0.200
     5.610    79.628     0.200
     0.806    20.078     0.200
     5.508    78.397     0.200
     5.641    80.600     0.200
     5.828    81.921     0.200
     6.211    88.068     0.200
     6.822    94.121     0.200
     5.155    74.420     0.200
     5.265    74.735     0.200
     5.350    76.044     0.200
     5.492    77.957     0.200
     5.552    79.087     0.200
     5.792    82.026     0.200
     5.792    83.581     0.200
     5.821    81.905     0.200
     5.925    83.733     0.200
     6.125    85.290     0.200
     6.499    89.436     0.200
     7.202    99.732     0.200
     1.654    31.800     0.200
     4.451    66.097     0.200
     4.466    64.987     0.200
     4.566    67.016     0.200
     4.582    64.569     0.200
     4.585    65.198     0.200
     4.959    69.234     0.200
     5.173    73.528     0.200
     5.476    76.305     0.200
     1.132    21.943     0.200
     3.077    45.894     0.200
     3.903    58.085     0.200
     4.316    59.790     0.200
     4.371    60.339     0.200
     4.405    60.184     0.200
     4.402    60.222     0.200
     4.642    63.683     0.200
     4.560    64.258     0.200
     4.690    65.521     0.200
     4.644    68.606     0.200
     4.917    67.875     0.200
     4.875    65.866     0.200
     5.303    72.863     0.200
     5.424    72.820     0.200
     6.042    82.146     0.200
     6.152    82.564     0.200
     6.577    87.033     0.200
     2.505    37.496     0.200
     2.723    40.362     0.200
     3.625    51.452     0.200
     3.677    52.044     0.200
     3.716    51.861     0.200
     3.710    50.689     0.200
     3.923    54.494     0.200
     4.001    55.960     0.200
     4.096    57.525     0.200
     4.184    57.622     0.200
     4.235    59.131     0.200
     4.253    59.522     0.200
     4.612    63.936     0.200
     4.738    63.761     0.200
     4.976    68.290     0.200
     5.346    73.364     0.200
     5.463    74.799     0.200
     5.918    78.977     0.200
     5.241    73.402     0.200
     5.320    74.477     0.200
     5.375    75.937     0.200
     5.424    77.819     0.200
     5.488    79.008     0.200
     5.563    78.031     0.200
     5.620    79.503     0.200
     5.630    78.961     0.200
     5.746    81.909     0.200
     5.879    80.822     0.200
     5.879    82.065     0.200
     5.886    82.183     0.200
     6.228    86.289     0.200
     6.445    89.368     0.200
     6.667    92.668     0.200
     7.015    96.603     0.200
     5.329    74.035     0.200
     5.441    74.931     0.200
     5.575    78.465     0.200
     5.726    79.302     0.200
     5.819    81.021     0.200
     6.105    82.176     0.200
     6.298    85.931     0.200
     1.240    28.634     0.200
     1.370    29.112     0.200
     1.774    32.406     0.200
     2.252    38.819     0.200
     5.171    73.554     0.200
     5.205    75.057     0.200
     5.205    73.377     0.200
     5.259    74.416     0.200
     5.309    74.784     0.200
     5.407    75.390     0.200
     5.457    77.821     0.200
     5.552    78.913     0.200
     5.697    79.515     0.200
     5.748    80.836     0.200
     5.838    82.780     0.200
     5.961    83.871     0.200
     6.412    88.224     0.200
     6.881    95.897     0.200
     1.223    25.231     0.200
     2.288    37.823     0.200
     2.803    45.020     0.200
     2.870    45.893     0.200
     2.948    47.999     0.200
     2.869    48.024     0.200
     2.957    47.335     0.200
     3.007    46.853     0.200
     3.608    57.140     0.200
     3.739    58.294     0.200
     3.856    59.076     0.200
     3.874    58.069     0.200
     3.971    57.100     0.200
     4.155    59.238     0.200
     4.183    59.393     0.200
     4.191    59.800     0.200
     4.469    63.845     0.200
     4.524    63.407     0.200
     4.667    66.837     0.200
     4.773    67.297     0.200
     4.863    69.949     0.200
     4.835    70.624     0.200
     4.964    69.785     0.200
     5.138    71.641     0.200
     5.195    72.581     0.200
     5.284    73.933     0.200
     5.696    80.322     0.200
     5.726    80.579     0.200
     5.925    81.500     0.200
     6.094    84.490     0.200
     7.020    97.379     0.200
     7.588   102.947     0.200
     1.964    36.274     0.200
     2.027    37.536     0.200
     2.316    42.165     0.200
     3.168    53.229     0.200
     3.237    53.421     0.200
     3.299    53.701     0.200
     3.637    57.757     0.200
     3.704    59.087     0.200
     3.754    59.392     0.200
     3.890    61.565     0.200
     3.893    61.557     0.200
     3.896    61.431     0.200
     3.954    61.052     0.200
     4.120    67.117     0.200
     4.300    63.013     0.200
     4.376    66.601     0.200
     4.434    65.982     0.200
     4.657    69.597     0.200
     5.262    77.805     0.200
     5.330    76.894     0.200
     5.305    77.722     0.200
     5.355    78.776     0.200
     5.385    79.191     0.200
     5.427    77.463     0.200
     5.500    78.201     0.200
     5.519    78.887     0.200
     5.519    76.255     0.200
     5.611    76.859     0.200
     5.611    81.015     0.200
     5.601    78.583     0.200
     5.602    82.549     0.200
     5.724    81.594     0.200
     5.852    82.907     0.200
     5.869    82.771     0.200
     5.968    86.442     0.200
     6.018    88.035     0.200
     6.048    84.720     0.200
     6.036    83.456     0.200
     6.185    88.360     0.200
     6.309    89.568     0.200
     6.616    91.033     0.200
     6.811    94.807     0.200
     7.006    97.135     0.200
     7.054   101.270     0.200
     7.084   100.028     0.200
     7.315   103.629     0.200
     7.315    99.973     0.200
     7.335    97.283     0.200
     7.328   100.674     0.200
     7.422   100.606     0.200
     7.604   103.945     0.200
     7.700   105.936     0.200
     7.745   104.913     0.200
     7.851   106.106     0.200
     8.100   107.811     0.200
     8.136   113.550     0.200
     8.304   114.190     0.200
     8.665   117.974     0.200
     8.933   119.351     0.200
     8.933   119.453     0.200
     8.934   119.437     0.200
     8.949   122.241     0.200
     9.001   122.446     0.200
     9.001   119.142     0.200
     9.188   124.472     0.200
     9.201   124.717     0.200
     9.206   125.914     0.200
     9.295   123.621     0.200
     9.413   125.645     0.200
     9.616   129.371     0.200
     9.652   129.062     0.200
     9.752   130.718     0.200
     9.817   125.777     0.200
     9.817   130.299     0.200
     9.945   133.036     0.200
    10.273   139.416     0.200
    10.669   138.045     0.200
    10.739   141.871     0.200
    11.034   145.252     0.200
    11.049   146.087     0.200
    11.069   146.478     0.200
    11.072   146.725     0.200
    11.093   148.597     0.200
    11.132   147.179     0.200
    11.159   146.022     0.200
    11.152   149.231     0.200
    11.169   146.561     0.200
    11.182   148.659     0.200
    11.220   148.771     0.200
    11.509   152.591     0.200
    11.588   155.007     0.200
     1.536    27.044     0.200
     1.893    31.879     0.200
     2.137    34.031     0.200
     2.478    39.057     0.200
     2.916    47.947     0.200
     3.667    56.177     0.200
     3.803    57.588     0.200
     5.000    69.622     0.200
     5.355    74.476     0.200
     5.576    76.897     0.200
     6.239    83.863     0.200
     6.271    83.388     0.200
     6.604    87.799     0.200
     6.609    90.446     0.200
     6.667    88.667     0.200
     6.857    91.655     0.200
     6.856    92.759     0.200
     6.866    92.845     0.200
     7.219    97.122     0.200
     7.347    97.131     0.200
     8.248   111.415     0.200
     8.320   108.778     0.200
     8.441   110.769     0.200
     8.854   116.445     0.200
     8.854   118.544     0.200
     9.249   121.236     0.200
     9.715   126.101     0.200
     9.828   126.785     0.200
    10.204   131.285     0.200
    10.509   135.231     0.200
     0.239    11.948     0.200
     0.833    18.020     0.200
     1.788    31.370     0.200
     2.333    38.514     0.200
     3.701    51.054     0.200
     3.734    51.262     0.200
     4.066    55.988     0.200
     4.119    56.780     0.200
     4.180    57.662     0.200
     4.319    58.742     0.200
     4.326    59.154     0.200
     4.335    58.959     0.200
     4.681    64.415     0.200
     4.823    65.057     0.200
     5.451    74.030     0.200
     1.061    23.263     0.200
     1.670    30.159     0.200
     1.976    34.590     0.200
     2.113    35.993     0.200
     5.568    75.768     0.200
     5.701    77.322     0.200
     5.758    79.853     0.200
     5.808    78.684     0.200
     5.966    80.831     0.200
     6.016    80.441     0.200
     6.196    84.140     0.200
     6.424    86.265     0.200
     6.424    86.280     0.200
     6.513    88.246     0.200
     1.567    31.645     0.200
     1.686    33.261     0.200
     2.124    35.145     0.200
     5.317    76.495     0.200
     5.432    77.339     0.200
     5.523    77.877     0.200
     5.682    80.643     0.200
     5.714    80.553     0.200
     6.030    84.850     0.200
     6.685    92.653     0.200
     7.972   108.004     0.200
     1.158    26.009     0.200
     2.837    44.416     0.200
     2.956    46.623     0.200
     4.839    68.863     0.200
     4.905    69.491     0.200
     4.948    70.410     0.200
     4.964    71.277     0.200
     5.129    72.237     0.200
     5.128    74.281     0.200
     5.128    72.583     0.200
     5.189    74.872     0.200
     5.222    73.484     0.200
     5.244    74.174     0.200
     5.316    75.175     0.200
     5.433    75.723     0.200
     5.473    77.163     0.200
     5.827    80.927     0.200
     5.986    83.668     0.200
     6.028    83.781     0.200
     7.146    97.561     0.200
     0.748    17.803     0.200
     0.963    21.302     0.200
     1.152    23.092     0.200
     1.657    27.193     0.200
     3.903    53.583     0.200
     3.978    55.114     0.200
     4.031    55.862     0.200
     4.093    57.742     0.200
     4.360    61.396     0.200
     4.549    64.853     0.200
     4.658    66.421     0.200
     5.112    68.877     0.200
     1.214    28.260     0.200
     1.795    32.473     0.200
     2.302    38.557     0.200
     5.133    73.119     0.200
     5.242    73.745     0.200
     5.387    77.260     0.200
     5.468    77.403     0.200
     5.901    83.157     0.200
     6.000    84.552     0.200
     6.104    86.088     0.200
     6.475    90.293     0.200
     2.144    34.979     0.200
     2.178    37.282     0.200
     2.487    42.685     0.200
     2.525    41.233     0.200
     3.364    54.439     0.200
     3.506    54.790     0.200
     3.910    60.321     0.200
     3.955    61.543     0.200
     4.097    62.831     0.200
     4.103    62.528     0.200
     4.361    66.809     0.200
     4.523    69.675     0.200
     4.645    66.349     0.200
     4.856    70.421     0.200
     4.910    71.405     0.200
     5.303    78.932     0.200
     5.495    76.472     0.200
     5.519    81.148     0.200
     5.569    82.626     0.200
     5.598    76.576     0.200
     5.600    83.498     0.200
     5.666    79.580     0.200
     5.666    77.674     0.200
     5.675    79.794     0.200
     5.763    79.579     0.200
     5.763    78.849     0.200
     5.790    78.774     0.200
     5.814    83.950     0.200
     5.891    81.054     0.200
     6.005    82.823     0.200
     6.073    84.890     0.200
     6.134    83.464     0.200
     6.228    84.522     0.200
     6.233    86.666     0.200
     6.233    89.802     0.200
     6.245    86.038     0.200
     6.471    88.985     0.200
     6.690    95.709     0.200
     6.803    91.973     0.200
     7.212    99.444     0.200
     7.513   102.032     0.200
     7.632   101.980     0.200
     7.814   103.117     0.200
     7.929   106.868     0.200
     8.049   108.047     0.200
     8.489   115.042     0.200
     8.737   116.026     0.200
     9.192   124.731     0.200
     9.192   121.905     0.200
     9.358   124.394     0.200
     9.420   128.000     0.200
     9.480   125.875     0.200
     9.600   128.775     0.200
     9.810   132.022     0.200
     9.946   132.257     0.200
    10.001   131.976     0.200
    10.127   134.822     0.200
    10.924   140.834     0.200
    11.294   148.714     0.200
    11.378   147.921     0.200
    11.434   149.748     0.200
    11.664   152.307     0.200
    11.669   150.429     0.200
    11.690   150.581     0.200
    11.722   154.052     0.200
    11.802   157.064     0.200
    15.188   193.653     0.200
    16.972   215.339     0.200
     2.627    42.462     0.200
     5.699    81.300     0.200
     5.717    81.308     0.200
     6.057    84.200     0.200
     6.813    93.526     0.200
     1.129    25.331     0.200
     2.614    42.003     0.200
     3.137    49.899     0.200
     5.227    73.249     0.200
     5.262    73.802     0.200
     5.445    75.867     0.200
     6.284    85.809     0.200
     1.199    28.840     0.200
     2.656    46.833     0.200
     4.070    61.517     0.200
     4.403    67.324     0.200
     4.681    72.850     0.200
     4.765    73.914     0.200
     4.871    77.655     0.200
     5.265    76.791     0.200
     5.336    77.554     0.200
     5.384    77.804     0.200
     5.409    77.973     0.200
     5.534    80.939     0.200
     5.572    79.987     0.200
     5.651    81.184     0.200
     5.678    83.278     0.200
     5.836    84.326     0.200
     5.877    85.149     0.200
     5.901    84.371     0.200
     5.954    85.451     0.200
     6.253    89.160     0.200
     6.431    91.680     0.200
     7.023    99.466     0.200
     7.156   100.818     0.200
     7.592   104.285     0.200
     8.124   112.428     0.200
     8.170   112.878     0.200
     8.785   121.215     0.200
     8.785   119.435     0.200
     9.113   125.078     0.200
     9.515   128.241     0.200
     9.641   130.624     0.200
     1.232    26.109     0.200
     1.993    34.229     0.200
     2.583    41.335     0.200
     4.497    66.586     0.200
     5.321    78.907     0.200
     5.388    76.009     0.200
     5.486    76.464     0.200
     5.559    77.337     0.200
     5.573    78.244     0.200
     5.663    78.268     0.200
     5.666    78.962     0.200
     5.783    80.602     0.200
     5.907    82.148     0.200
     5.932    82.072     0.200
     6.026    84.058     0.200
     6.079    89.023     0.200
     6.109    84.994     0.200
     6.099    84.462     0.200
     6.115    84.424     0.200
     6.366    86.590     0.200
     6.632    91.192     0.200
     6.678    92.907     0.200
     7.389   100.849     0.200
     7.667   102.629     0.200
     9.063   121.574     0.200
     1.178    27.045     0.200
     2.678    43.541     0.200
     5.000    71.434     0.200
     5.050    72.802     0.200
     5.084    73.828     0.200
     5.197    73.739     0.200
     5.197    74.180     0.200
     5.264    74.751     0.200
     5.271    75.215     0.200
     5.314    74.873     0.200
     5.396    77.143     0.200
     5.549    77.535     0.200
     5.564    79.462     0.200
     5.916    83.452     0.200
     6.106    85.381     0.200
     1.230    27.781     0.200
     2.473    44.351     0.200
     2.476    44.340     0.200
     3.313    52.564     0.200
     3.752    57.410     0.200
     3.879    60.460     0.200
     3.913    61.182     0.200
     4.051    62.300     0.200
     4.721    70.113     0.200
     4.817    70.124     0.200
     4.810    68.518     0.200
     4.856    69.768     0.200
     4.873    69.247     0.200
     4.862    70.391     0.200
     4.911    71.563     0.200
     5.186    74.214     0.200
     5.151    75.610     0.200
     5.295    74.549     0.200
     5.439    77.161     0.200
     5.439    78.069     0.200
     5.450    77.540     0.200
     5.800    82.451     0.200
     5.828    81.059     0.200
     5.947    84.140     0.200
     6.101    86.046     0.200
     6.438    90.742     0.200
     6.560    91.283     0.200
     6.904    95.155     0.200
     8.132   110.065     0.200
     0.783    20.446     0.200
     1.259    27.891     0.200
     1.243    25.083     0.200
     2.320    39.615     0.200
     2.365    40.979     0.200
     2.347    38.195     0.200
     3.693    53.586     0.200
     3.682    54.171     0.200
     3.725    53.418     0.200
     3.737    54.583     0.200
     3.777    56.512     0.200
     3.801    56.285     0.200
     4.011    59.771     0.200
     3.935    63.410     0.200
     4.057    58.737     0.200
     4.092    60.533     0.200
     4.164    59.594     0.200
     4.310    61.092     0.200
     4.329    61.663     0.200
     4.672    65.559     0.200
     4.703    65.597     0.200
     1.421    28.625     0.200
     1.801    34.197     0.200
     2.616    45.686     0.200
     2.979    47.443     0.200
     3.063    50.466     0.200
     3.491    53.176     0.200
     3.588    54.135     0.200
     3.666    55.008     0.200
     3.786    57.325     0.200
     3.809    56.369     0.200
     3.885    57.875     0.200
     4.201    59.700     0.200
     4.237    62.260     0.200
     4.471    65.731     0.200
     4.476    65.906     0.200
     4.731    69.443     0.200
     4.812    68.601     0.200
     5.514    79.168     0.200
     1.585    29.828     0.200
     2.215    39.480     0.200
     5.376    75.297     0.200
     5.488    77.080     0.200
     5.773    80.460     0.200
     6.154    85.405     0.200
     6.343    87.503     0.200
     1.386    29.716     0.200
     2.554    45.078     0.200
     2.940    47.077     0.200
     2.961    47.990     0.200
     2.989    51.001     0.200
     3.092    50.804     0.200
     3.533    53.059     0.200
     3.627    54.861     0.200
     3.701    56.004     0.200
     3.760    56.211     0.200
     3.760    58.840     0.200
     3.833    58.024     0.200
     3.926    59.570     0.200
     4.073    60.751     0.200
     4.207    62.188     0.200
     4.265    63.614     0.200
     4.473    66.105     0.200
     4.515    64.998     0.200
     4.709    69.931     0.200
     4.838    70.887     0.200
     5.334    75.244     0.200
     5.543    78.005     0.200
     1.671    31.025     0.200
     4.718    70.295     0.200
     4.754    69.921     0.200
     5.110    74.693     0.200
     5.174    74.745     0.200
     5.174    74.599     0.200
     5.244    75.731     0.200
     5.298    78.494     0.200
     5.353    77.845     0.200
     5.507    79.657     0.200
     5.544    82.024     0.200
     5.571    79.252     0.200
     5.875    84.759     0.200
     5.975    84.601     0.200
     6.004    85.294     0.200
     6.391    90.738     0.200
     6.554    91.466     0.200
     6.687    94.294     0.200
     6.947    98.360     0.200
     7.235   100.992     0.200
     8.960   122.862     0.200
     1.777    31.302     0.200
     2.852    47.198     0.200
     3.005    47.799     0.200
     3.528    54.920     0.200
     3.765    57.808     0.200
     3.890    58.542     0.200
     3.953    59.580     0.200
     4.051    61.769     0.200
     4.051    60.599     0.200
     4.110    62.576     0.200
     4.151    63.398     0.200
     4.226    62.604     0.200
     4.342    65.074     0.200
     4.407    65.106     0.200
     4.431    65.639     0.200
     4.555    67.689     0.200
     4.753    70.576     0.200
     4.970    72.543     0.200
     4.971    71.027     0.200
     5.184    75.147     0.200
     5.530    79.906     0.200
     5.689    80.651     0.200
     5.811    81.153     0.200
     2.071    36.125     0.200
     2.644    43.447     0.200
     4.401    64.908     0.200
     4.949    73.364     0.200
     5.316    76.063     0.200
     5.411    76.849     0.200
     5.482    76.821     0.200
     5.579    79.121     0.200
     5.601    79.840     0.200
     5.710    82.064     0.200
     5.841    80.915     0.200
     5.980    89.461     0.200
     6.003    83.560     0.200
     6.027    84.365     0.200
     6.296    87.725     0.200
     6.556    90.891     0.200
     6.594    91.586     0.200
     7.117    98.441     0.200
     7.303    99.421     0.200
     7.308   100.217     0.200
     7.390    99.439     0.200
     8.978   118.913     0.200
     1.066    24.202     0.200
     2.640    44.012     0.200
     3.273    54.152     0.200
     3.758    54.585     0.200
     3.813    55.138     0.200
     3.849    55.671     0.200
     3.860    56.803     0.200
     4.066    58.898     0.200
     4.094    60.069     0.200
     4.094    60.667     0.200
     4.136    59.574     0.200
     4.137    61.657     0.200
     4.328    61.933     0.200
     4.363    62.330     0.200
     4.388    63.537     0.200
     4.746    67.463     0.200
     4.882    69.578     0.200
     4.929    69.722     0.200
     5.118    72.116     0.200
     5.607    78.307     0.200
     5.620    76.474     0.200
     5.807    80.957     0.200
     6.021    83.870     0.200
     6.064    83.809     0.200
     7.241    98.227     0.200
     2.903    47.299     0.200
     3.459    53.703     0.200
     4.138    60.260     0.200
     4.191    62.541     0.200
     4.216    62.335     0.200
     4.222    61.296     0.200
     4.377    64.866     0.200
     4.492    70.134     0.200
     4.508    65.945     0.200
     4.515    65.860     0.200
     4.689    69.534     0.200
     4.744    68.391     0.200
     4.766    70.126     0.200
     5.125    74.740     0.200
     5.238    74.756     0.200
     5.483    78.058     0.200
     5.896    82.052     0.200
     5.965    84.533     0.200
     2.483    39.438     0.200
     2.730    44.792     0.200
     3.049    48.055     0.200
     3.133    52.126     0.200
     3.374    51.818     0.200
     3.736    57.854     0.200
     3.833    55.915     0.200
     3.842    56.208     0.200
     3.771    55.553     0.200
     3.870    55.286     0.200
     3.887    55.277     0.200
     3.967    58.822     0.200
     4.089    59.302     0.200
     4.201    59.726     0.200
     4.217    60.941     0.200
     4.217    60.341     0.200
     4.245    60.513     0.200
     4.322    61.608     0.200
     4.453    61.250     0.200
     4.453    63.681     0.200
     4.464    64.353     0.200
     4.463    63.472     0.200
     4.555    69.776     0.200
     4.815    67.758     0.200
     4.863    67.904     0.200
     4.962    69.638     0.200
     4.931    72.419     0.200
     5.124    71.652     0.200
     5.413    79.299     0.200
     5.477    74.235     0.200
     5.515    77.192     0.200
     5.594    77.471     0.200
     5.651    77.032     0.200
     5.651    78.621     0.200
     5.844    81.148     0.200
     5.844    80.087     0.200
     5.990    80.569     0.200
     6.005    81.771     0.200
     6.553    89.778     0.200
     7.160    98.117     0.200
     7.194    96.700     0.200
     7.194    96.160     0.200
     7.211   100.968     0.200
     7.428    99.560     0.200
     7.539   101.068     0.200
     7.782   105.030     0.200
     7.912   104.423     0.200
     8.069   106.873     0.200
     2.600    42.063     0.200
     3.072    48.860     0.200
     3.203    49.901     0.200
     3.346    53.577     0.200
     3.440    54.564     0.200
     4.073    58.967     0.200
     4.119    60.741     0.200
     4.146    58.523     0.200
     4.153    59.902     0.200
     4.131    61.471     0.200
     4.205    62.447     0.200
     4.480    64.024     0.200
     4.559    64.903     0.200
     4.557    71.672     0.200
     4.733    67.579     0.200
     4.731    68.202     0.200
     4.758    68.081     0.200
     5.090    71.929     0.200
     5.223    73.357     0.200
     5.367    74.977     0.200
     5.590    77.482     0.200
     5.771    80.158     0.200
     5.822    81.365     0.200
     7.756   104.300     0.200
     2.615    44.065     0.200
     3.113    47.762     0.200
     3.226    48.335     0.200
     3.136    51.201     0.200
     3.509    52.325     0.200
     3.522    53.788     0.200
     3.927    58.263     0.200
     4.339    62.974     0.200
     4.710    68.571     0.200
     6.748    89.584     0.200
     2.772    47.472     0.200
     3.570    58.362     0.200
     4.978    71.021     0.200
     5.023    70.213     0.200
     5.045    73.289     0.200
     5.191    72.226     0.200
     5.216    74.666     0.200
     5.254    74.393     0.200
     5.332    76.704     0.200
     5.487    78.274     0.200
     5.544    78.412     0.200
     5.593    80.234     0.200
     6.067    83.595     0.200
     6.103    86.987     0.200
     6.301    86.677     0.200
     6.720    93.236     0.200
     6.792    94.541     0.200
     6.920    94.114     0.200
     1.794    32.875     0.200
     5.185    72.821     0.200
     5.271    74.316     0.200
     5.411    75.980     0.200
     5.492    78.539     0.200
     5.823    82.871     0.200
     6.170    85.530     0.200
     6.633    90.420     0.200
     6.971    97.173     0.200
     7.140    96.903     0.200
     2.217    39.983     0.200
     2.431    40.224     0.200
     2.761    47.046     0.200
     2.935    47.667     0.200
     3.230    51.859     0.200
     3.680    59.262     0.200
     3.888    58.131     0.200
     3.953    58.968     0.200
     3.970    58.941     0.200
     3.966    63.962     0.200
     4.038    60.488     0.200
     4.905    69.072     0.200
     5.424    76.501     0.200
     1.682    29.047     0.200
     3.874    60.864     0.200
     1.668    31.562     0.200
     2.325    41.490     0.200
     2.421    43.169     0.200
     2.616    46.268     0.200
     2.635    42.771     0.200
     2.635    40.957     0.200
     2.665    44.046     0.200
     2.672    44.229     0.200
     3.139    51.247     0.200
     3.150    53.158     0.200
     3.192    50.478     0.200
     3.200    54.503     0.200
     3.294    49.238     0.200
     3.520    52.557     0.200
     3.630    55.489     0.200
     3.639    55.389     0.200
     3.650    56.116     0.200
     3.774    57.652     0.200
     3.907    61.353     0.200
     3.960    63.916     0.200
     4.029    62.541     0.200
     4.141    62.599     0.200
     4.160    65.652     0.200
     4.366    65.554     0.200
     4.508    68.293     0.200
     4.569    71.671     0.200
     4.611    67.839     0.200
     4.664    66.624     0.200
     4.678    66.622     0.200
     4.695    67.485     0.200
     4.804    68.934     0.200
     4.901    71.052     0.200
     4.940    70.500     0.200
     4.940    69.836     0.200
     4.988    69.964     0.200
     4.988    71.542     0.200
     4.988    71.537     0.200
     5.154    71.807     0.200
     5.214    74.002     0.200
     5.270    76.853     0.200
     5.250    80.157     0.200
     5.250    81.626     0.200
     5.518    79.109     0.200
     5.598    78.817     0.200
     5.700    80.102     0.200
     5.774    81.086     0.200
     5.951    84.105     0.200
     5.951    81.925     0.200
     6.288    87.368     0.200
     6.288    86.407     0.200
     6.330    88.279     0.200
     6.400    89.062     0.200
     6.429    88.533     0.200
     6.451    88.675     0.200
     6.451    89.511     0.200
     6.451    88.941     0.200
     6.453    90.355     0.200
     6.527    87.680     0.200
     6.527    89.477     0.200
     6.626    92.529     0.200
     6.841    93.120     0.200
     6.888    93.965     0.200
     7.113   100.131     0.200
     7.171    97.804     0.200
     7.313   100.407     0.200
     7.390   101.309     0.200
     7.390   100.184     0.200
     7.393   100.290     0.200
     7.771   105.166     0.200
     7.727   106.313     0.200
     7.905   108.207     0.200
     7.973   110.155     0.200
     8.035   108.281     0.200
     8.035   107.070     0.200
     8.267   109.770     0.200
     8.348   112.534     0.200
     8.378   111.481     0.200
     8.624   115.607     0.200
     8.749   116.543     0.200
     8.758   116.628     0.200
     8.907   117.880     0.200
     9.046   120.281     0.200
     9.320   122.899     0.200
     9.812   128.943     0.200
     9.979   132.795     0.200
    10.016   132.064     0.200
    10.026   133.577     0.200
    10.144   134.015     0.200
    10.174   134.327     0.200
    10.241   133.842     0.200
    10.276   134.934     0.200
    10.315   138.625     0.200
    10.378   137.656     0.200
    10.625   138.860     0.200
     1.353    28.886     0.200
     3.111    49.748     0.200
     3.169    48.677     0.200
     3.266    53.086     0.200
     3.269    48.613     0.200
     3.494    53.735     0.200
     3.615    56.304     0.200
     3.628    53.715     0.200
     3.747    57.864     0.200
     3.881    59.857     0.200
     4.001    62.461     0.200
     4.596    67.085     0.200
     4.648    66.575     0.200
     4.658    65.031     0.200
     4.678    66.042     0.200
     4.780    67.954     0.200
     4.774    71.974     0.200
     4.876    70.886     0.200
     4.929    70.804     0.200
     4.973    71.086     0.200
     4.975    70.281     0.200
     4.975    71.558     0.200
     5.135    72.103     0.200
     5.201    74.324     0.200
     5.253    76.720     0.200
     5.583    77.866     0.200
     5.680    79.840     0.200
     5.757    82.439     0.200
     5.932    82.992     0.200
     6.262    86.324     0.200
     6.312    88.057     0.200
     6.409    87.530     0.200
     6.424    89.636     0.200
     6.611    92.873     0.200
     6.821    92.521     0.200
     7.370   101.515     0.200
     7.751   104.269     0.200
     7.878   108.823     0.200
     8.014   107.800     0.200
     8.247   111.382     0.200
     8.357   111.792     0.200
     8.602   115.439     0.200
     8.729   116.554     0.200
     8.729   117.156     0.200
     8.736   116.312     0.200
     8.887   117.275     0.200
     9.026   120.689     0.200
     4.043    57.949     0.200
     4.047    57.704     0.200
     4.384    61.770     0.200
     4.999    70.295     0.200
     1.318    27.802     0.200
     1.820    31.110     0.200
     2.456    40.282     0.200
     2.683    44.484     0.200
     2.852    44.645     0.200
     2.959    48.146     0.200
     3.074    48.621     0.200
     3.253    51.132     0.200
     3.327    52.535     0.200
     3.910    56.490     0.200
     3.958    58.437     0.200
     3.984    58.335     0.200
     3.990    56.827     0.200
     3.978    59.073     0.200
     3.991    61.857     0.200
     4.063    60.467     0.200
     4.319    63.133     0.200
     4.367    65.566     0.200
     4.367    62.486     0.200
     4.387    63.938     0.200
     4.568    67.326     0.200
     4.600    66.749     0.200
     4.790    68.872     0.200
     4.934    70.447     0.200
     4.927    70.058     0.200
     5.204    74.805     0.200
     5.295    78.925     0.200
     5.449    77.892     0.200
     5.608    79.786     0.200
     5.612    80.746     0.200
     5.612    79.016     0.200
     5.660    79.881     0.200
     6.068    85.216     0.200
     6.159    85.761     0.200
     6.612    93.873     0.200
     6.999    97.252     0.200
     7.234    98.004     0.200
     7.234    97.612     0.200
     7.595   104.102     0.200
     7.813   106.853     0.200
     7.969   107.836     0.200
     9.426   121.225     0.200
     9.823   125.999     0.200
     1.228    25.851     0.200
     1.584    29.433     0.200
     1.993    34.254     0.200
     2.396    38.748     0.200
     2.476    42.296     0.200
     2.703    45.055     0.200
     2.718    46.141     0.200
     2.871    45.347     0.200
     2.978    48.765     0.200
     3.093    51.445     0.200
     3.271    51.237     0.200
     3.346    55.116     0.200
     3.660    59.351     0.200
     3.974    57.542     0.200
     4.000    57.332     0.200
     4.007    55.940     0.200
     3.997    58.552     0.200
     4.083    60.604     0.200
     4.334    62.130     0.200
     4.380    65.093     0.200
     4.380    64.030     0.200
     4.401    63.256     0.200
     4.471    68.236     0.200
     4.584    66.015     0.200
     4.614    65.864     0.200
     4.950    69.946     0.200
     4.946    66.387     0.200
     5.221    73.778     0.200
     5.313    77.598     0.200
     5.469    77.310     0.200
     5.625    78.968     0.200
     5.632    78.005     0.200
     5.678    80.651     0.200
     6.087    81.883     0.200
     6.176    85.741     0.200
     7.254    97.665     0.200
     7.502   100.768     0.200
     7.613   102.866     0.200
     1.087    23.356     0.200
     1.217    26.630     0.200
     1.286    27.503     0.200
     2.483    39.567     0.200
     2.708    45.098     0.200
     2.979    48.599     0.200
     3.098    52.491     0.200
     3.269    52.786     0.200
     4.011    62.712     0.200
     3.942    56.195     0.200
     4.007    58.155     0.200
     4.090    62.529     0.200
     3.991    57.975     0.200
     4.023    57.455     0.200
     4.017    57.172     0.200
     4.352    61.968     0.200
     4.399    65.612     0.200
     4.419    62.879     0.200
     4.601    66.062     0.200
     4.633    65.690     0.200
     4.960    70.307     0.200
     4.968    70.181     0.200
     5.237    74.643     0.200
     5.476    76.799     0.200
     5.641    78.821     0.200
     5.692    79.423     0.200
     6.101    81.059     0.200
     1.231    27.880     0.200
     1.997    36.186     0.200
     2.023    34.765     0.200
     2.480    40.538     0.200
     2.991    48.122     0.200
     3.288    53.727     0.200
     3.685    59.620     0.200
     3.920    59.240     0.200
     3.993    57.472     0.200
     3.997    60.546     0.200
     4.023    64.561     0.200
     4.087    63.008     0.200
     5.474    77.776     0.200
     1.248    25.517     0.200
     2.300    38.650     0.200
     3.070    49.036     0.200
     3.178    52.582     0.200
     5.406    74.977     0.200
     5.468    74.401     0.200
     5.545    79.563     0.200
     5.545    76.563     0.200
     5.536    76.717     0.200
     5.712    79.913     0.200
     5.758    78.475     0.200
     5.864    81.533     0.200
     5.898    81.472     0.200
     6.305    87.193     0.200
     6.556    88.207     0.200
     6.768    92.088     0.200
     7.274    97.680     0.200
     7.286    97.638     0.200
     1.250    28.533     0.200
     1.330    29.950     0.200
     2.390    43.039     0.200
     2.656    48.609     0.200
     2.855    46.025     0.200
     3.014    47.314     0.200
     3.112    50.011     0.200
     3.275    51.677     0.200
     3.978    61.962     0.200
     4.448    66.338     0.200
     4.605    67.042     0.200
     4.807    69.634     0.200
     4.837    71.241     0.200
     4.846    71.836     0.200
     5.179    75.652     0.200
     5.588    80.514     0.200
     5.792    83.392     0.200
     5.841    83.923     0.200
     1.327    28.816     0.200
     3.004    49.763     0.200
     3.690    62.179     0.200
     4.163    62.350     0.200
     5.266    74.369     0.200
     5.345    74.841     0.200
     5.449    75.287     0.200
     5.512    78.701     0.200
     5.655    79.225     0.200
     5.684    86.126     0.200
     5.770    81.698     0.200
     5.904    82.829     0.200
     6.253    87.254     0.200
     7.040    97.164     0.200
     7.158    97.287     0.200
     7.192    98.594     0.200
     7.607   103.844     0.200
     7.655   103.921     0.200
     9.572   128.429     0.200
     0.799    19.780     0.200
     1.071    24.615     0.200
     1.105    24.219     0.200
     5.403    72.874     0.200
     5.499    74.952     0.200
     5.594    76.948     0.200
     5.594    75.479     0.200
     5.668    76.780     0.200
     5.685    78.486     0.200
     5.797    79.178     0.200
     6.041    82.625     0.200
     6.091    83.190     0.200
     6.382    86.247     0.200
     7.205    98.439     0.200
     7.397    98.003     0.200
     6.095    85.919     0.200
     6.175    86.486     0.200
     6.223    89.021     0.200
     6.438    90.617     0.200
     6.668    93.937     0.200
     6.982    97.465     0.200
     1.031    26.357     0.200
     1.323    30.517     0.200
     2.470    43.387     0.200
     2.985    50.385     0.200
     3.394    57.378     0.200
     3.790    61.769     0.200
     4.745    68.988     0.200
     4.842    69.188     0.200
     5.053    73.389     0.200
     5.053    72.217     0.200
     5.108    73.749     0.200
     5.093    72.989     0.200
     5.126    74.136     0.200
     5.337    76.973     0.200
     5.377    76.808     0.200
     5.733    81.751     0.200
     6.479    91.643     0.200
     6.480    88.253     0.200
     7.010    95.430     0.200
     1.094    25.277     0.200
     2.160    36.326     0.200
     2.347    40.447     0.200
     2.980    47.431     0.200
     3.078    50.787     0.200
     3.412    51.535     0.200
     3.384    54.504     0.200
     3.517    52.712     0.200
     3.601    54.594     0.200
     3.764    59.331     0.200
     3.766    56.744     0.200
     3.808    57.019     0.200
     4.189    61.845     0.200
     4.389    63.634     0.200
     4.484    65.863     0.200
     4.773    69.624     0.200
     5.226    74.862     0.200
     5.459    77.748     0.200
     5.835    81.558     0.200
     6.075    84.751     0.200
     1.164    25.883     0.200
     1.133    26.088     0.200
     1.304    28.229     0.200
     1.359    30.157     0.200
     1.815    33.889     0.200
     2.770    49.283     0.200
     3.564    57.878     0.200
     3.688    61.772     0.200
     4.322    69.641     0.200
     4.778    73.681     0.200
     4.783    74.486     0.200
     1.251    30.478     0.200
     1.382    31.851     0.200
     1.779    34.210     0.200
     2.162    39.232     0.200
     2.309    41.454     0.200
     2.891    49.593     0.200
     3.020    51.472     0.200
     3.117    52.496     0.200
     3.384    54.513     0.200
     3.487    56.991     0.200
     3.617    60.006     0.200
     3.778    61.485     0.200
     3.860    59.852     0.200
     3.909    61.620     0.200
     3.983    57.965     0.200
     3.994    58.043     0.200
     4.231    66.707     0.200
     4.231    69.414     0.200
     4.435    64.595     0.200
     4.543    69.741     0.200
     4.867    78.051     0.200
     4.948    71.502     0.200
     5.062    76.443     0.200
     5.291    78.468     0.200
     5.585    79.769     0.200
     5.603    80.363     0.200
     1.011    25.675     0.200
     1.198    26.936     0.200
     1.106    27.733     0.200
     1.209    29.790     0.200
     1.349    30.757     0.200
     1.810    33.747     0.200
     2.340    40.867     0.200
     3.072    51.647     0.200
     3.164    52.040     0.200
     3.826    59.688     0.200
     3.886    59.485     0.200
     3.869    56.911     0.200
     3.942    59.836     0.200
     3.983    58.445     0.200
     4.281    66.412     0.200
     4.979    73.817     0.200
     5.326    77.598     0.200
     1.050    23.436     0.200
     1.154    25.369     0.200
     1.786    29.104     0.200
     1.841    32.468     0.200
     2.383    38.890     0.200
     2.968    47.885     0.200
     3.096    49.198     0.200
     3.195    50.333     0.200
     3.856    59.118     0.200
     3.919    56.088     0.200
     3.932    58.082     0.200
     3.984    59.066     0.200
     4.026    56.804     0.200
     4.034    57.024     0.200
     4.040    56.837     0.200
     5.138    74.327     0.200
     5.367    75.903     0.200
     0.810    19.316     0.200
     1.571    27.851     0.200
     2.030    34.386     0.200
     2.030    34.495     0.200
     2.569    38.751     0.200
     3.039    44.261     0.200
     3.340    49.227     0.200
     3.506    51.208     0.200
     3.549    54.951     0.200
     3.572    51.204     0.200
     3.697    56.751     0.200
     4.339    65.140     0.200
     4.614    67.110     0.200
     4.618    65.511     0.200
     4.659    65.024     0.200
     4.786    66.592     0.200
     5.196    69.993     0.200
     5.665    78.179     0.200
     2.287    38.441     0.200
     3.047    50.482     0.200
     3.691    57.391     0.200
     3.992    58.744     0.200
     4.067    59.668     0.200
     4.121    60.173     0.200
     4.182    60.605     0.200
     4.269    63.117     0.200
     4.269    61.367     0.200
     4.380    63.725     0.200
     4.443    63.411     0.200
     4.565    68.766     0.200
     4.634    66.642     0.200
     4.722    72.845     0.200
     4.980    72.415     0.200
     5.200    73.946     0.200
     5.201    73.256     0.200
     5.415    77.944     0.200
     5.761    82.208     0.200
     5.920    82.954     0.200
     6.017    82.523     0.200
     6.210    86.782     0.200
     6.335    88.401     0.200
     6.421    89.781     0.200
     6.756    94.886     0.200
     1.157    26.959     0.200
     1.714    33.230     0.200
     2.480    44.690     0.200
     2.572    44.149     0.200
     2.875    48.884     0.200
     2.946    46.466     0.200
     3.676    59.282     0.200
     3.950    60.486     0.200
     4.108    61.912     0.200
     4.360    67.299     0.200
     4.475    68.901     0.200
     4.845    69.060     0.200
     4.909    69.709     0.200
     4.950    70.378     0.200
     4.961    70.247     0.200
     5.118    72.182     0.200
     5.139    75.719     0.200
     5.135    74.875     0.200
     5.228    73.890     0.200
     5.228    74.623     0.200
     5.430    76.833     0.200
     5.522    80.453     0.200
     5.833    81.925     0.200
     5.983    82.891     0.200
     6.030    85.020     0.200
     6.030    84.791     0.200
     6.222    88.180     0.200
     6.398    88.905     0.200
     6.589    92.006     0.200
     6.615    89.917     0.200
     6.710    91.896     0.200
     6.780    92.708     0.200
     6.858    94.268     0.200
     6.858    92.856     0.200
     7.123    96.867     0.200
     7.138    96.010     0.200
     7.150    98.457     0.200
     7.675   105.624     0.200
     9.061   118.781     0.200
     9.193   121.956     0.200
     2.543    44.034     0.200
     2.903    47.979     0.200
     4.868    68.692     0.200
     4.931    69.258     0.200
     4.970    67.686     0.200
     4.976    71.363     0.200
     5.125    73.765     0.200
     5.250    73.731     0.200
     5.230    72.926     0.200
     5.999    83.213     0.200
     6.240    86.577     0.200
     6.725    92.612     0.200
     0.773    19.453     0.200
     2.939    47.018     0.200
     3.109    47.887     0.200
     3.303    47.063     0.200
     3.739    53.676     0.200
     3.762    56.056     0.200
     4.077    56.888     0.200
     4.152    56.517     0.200
     4.082    59.960     0.200
     4.205    57.241     0.200
     4.263    59.070     0.200
     4.353    59.972     0.200
     4.464    60.776     0.200
     4.516    63.401     0.200
     4.649    64.515     0.200
     4.700    65.217     0.200
     4.771    69.325     0.200
     5.065    68.859     0.200
     5.284    71.003     0.200
     5.282    71.995     0.200
     5.845    79.863     0.200
     6.001    80.035     0.200
     6.086    79.746     0.200
     6.084    80.284     0.200
     6.274    83.563     0.200
     1.185    28.178     0.200
     2.337    40.623     0.200
     3.392    51.533     0.200
     3.443    52.433     0.200
     3.476    52.080     0.200
     3.489    51.933     0.200
     3.768    57.146     0.200
     3.719    54.766     0.200
     4.020    58.629     0.200
     4.020    59.614     0.200
     3.915    57.651     0.200
     4.056    62.838     0.200
     4.379    65.223     0.200
     4.511    65.282     0.200
     4.745    69.248     0.200
     5.113    75.250     0.200
     5.296    72.997     0.200
     2.890    46.281     0.200
     3.112    50.532     0.200
     3.546    54.171     0.200
     3.852    56.377     0.200
     3.923    57.746     0.200
     3.934    61.256     0.200
     3.973    56.834     0.200
     3.907    60.205     0.200
     4.026    57.612     0.200
     4.143    58.315     0.200
     4.237    61.175     0.200
     4.283    60.762     0.200
     4.487    65.159     0.200
     4.475    63.724     0.200
     4.575    67.980     0.200
     4.840    68.843     0.200
     5.045    69.542     0.200
     5.262    74.611     0.200
     5.765    80.147     0.200
     5.858    80.272     0.200
     2.810    47.388     0.200
     3.290    52.285     0.200
     4.266    61.620     0.200
     4.343    62.919     0.200
     4.399    63.390     0.200
     4.460    65.801     0.200
     4.709    68.384     0.200
     4.903    69.588     0.200
     4.885    69.721     0.200
     5.479    77.402     0.200
     6.270    85.534     0.200
     2.165    36.041     0.200
     2.489    42.824     0.200
     2.564    44.104     0.200
     2.823    48.163     0.200
     4.006    60.855     0.200
     4.253    63.778     0.200
     4.570    66.829     0.200
     4.852    74.192     0.200
     5.157    74.394     0.200
     5.208    75.358     0.200
     5.519    79.668     0.200
     2.376    41.115     0.200
     2.548    43.304     0.200
     3.959    60.877     0.200
     4.370    67.414     0.200
     4.571    70.329     0.200
     5.301    75.369     0.200
     5.360    75.680     0.200
     5.382    76.683     0.200
     5.395    76.516     0.200
     5.384    80.474     0.200
     5.490    79.780     0.200
     5.562    81.353     0.200
     5.606    78.407     0.200
     5.663    79.244     0.200
     5.893    83.663     0.200
     6.289    87.635     0.200
     6.404    89.336     0.200
     6.475    90.069     0.200
     6.656    92.162     0.200
     7.032    96.774     0.200
     7.546   102.575     0.200
     2.162    34.596     0.200
     2.924    44.238     0.200
     3.102    45.440     0.200
     3.577    52.113     0.200
     3.882    54.527     0.200
     4.005    56.618     0.200
     4.060    56.915     0.200
     4.268    59.524     0.200
     4.317    60.691     0.200
     4.461    62.976     0.200
     4.510    63.166     0.200
     4.871    67.795     0.200
     5.079    69.372     0.200
     5.296    72.637     0.200
     5.798    78.170     0.200
     6.085    81.707     0.200
     6.214    83.016     0.200
     6.296    84.394     0.200
     7.454    98.165     0.200
     1.199    26.301     0.200
     2.141    35.896     0.200
     2.957    48.032     0.200
     4.248    60.449     0.200
     4.367    62.063     0.200
     5.212    71.805     0.200
     1.144    26.429     0.200
     1.275    26.078     0.200
     2.835    45.695     0.200
     3.638    57.300     0.200
     4.811    67.337     0.200
     4.877    68.158     0.200
     4.921    68.433     0.200
     4.939    69.159     0.200
     5.107    70.139     0.200
     5.195    72.555     0.200
     5.224    73.019     0.200
     5.392    75.050     0.200
     5.799    79.899     0.200
     5.961    81.960     0.200
     6.686    91.546     0.200
     3.329    53.706     0.200
     3.879    63.756     0.200
     5.350    76.963     0.200
     5.449    78.008     0.200
     5.629    81.624     0.200
     5.905    84.333     0.200
     6.075    87.262     0.200
     6.328    88.949     0.200
     0.349    11.687     0.200
     0.878    18.058     0.200
     1.575    27.004     0.200
     1.669    29.220     0.200
     2.018    31.303     0.200
     2.080    32.608     0.200
     2.970    45.091     0.200
     4.534    60.860     0.200
     4.613    62.782     0.200
     4.638    62.735     0.200
     4.637    62.606     0.200
     5.255    70.888     0.200
     5.547    74.397     0.200
     5.588    74.406     0.200
     6.250    84.481     0.200
     1.684    30.151     0.200
     1.893    31.419     0.200
     1.893    32.792     0.200
     1.944    33.574     0.200
     2.449    35.107     0.200
     2.511    38.390     0.200
     2.427    40.424     0.200
     2.517    39.694     0.200
     2.738    41.038     0.200
     2.887    44.994     0.200
     2.928    43.989     0.200
     3.000    45.461     0.200
     3.281    51.739     0.200
     3.367    51.846     0.200
     3.648    53.736     0.200
     3.742    55.860     0.200
     3.989    56.928     0.200
     4.046    58.346     0.200
     4.042    57.015     0.200
     4.073    56.690     0.200
     4.068    56.219     0.200
     4.068    57.040     0.200
     4.123    60.384     0.200
     4.402    61.814     0.200
     4.476    61.852     0.200
     4.451    61.804     0.200
     4.451    63.335     0.200
     4.471    61.026     0.200
     4.442    65.281     0.200
     4.650    64.317     0.200
     4.654    62.940     0.200
     4.684    64.627     0.200
     4.739    65.459     0.200
     4.807    69.794     0.200
     5.005    67.664     0.200
     5.018    68.628     0.200
     5.284    72.653     0.200
     5.284    72.524     0.200
     5.508    75.052     0.200
     5.508    75.673     0.200
     5.668    76.436     0.200
     5.668    78.409     0.200
     5.690    77.790     0.200
     5.738    76.024     0.200
     5.794    81.878     0.200
     5.792    84.418     0.200
     6.046    81.794     0.200
     6.046    83.427     0.200
     6.085    81.168     0.200
     6.146    83.461     0.200
     6.240    82.869     0.200
     6.296    85.909     0.200
     6.388    83.918     0.200
     6.613    86.281     0.200
     6.656    89.906     0.200
     6.689    87.026     0.200
     6.689    89.127     0.200
     6.766    90.925     0.200
     7.077    96.100     0.200
     7.061    97.825     0.200
     7.309    97.006     0.200
     7.309    96.697     0.200
     7.560    99.166     0.200
     7.885   104.364     0.200
     8.019   105.779     0.200
     8.046   104.194     0.200
     8.202   105.887     0.200
     8.421   113.977     0.200
     8.404   114.784     0.200
     8.630   111.709     0.200
     9.098   117.191     0.200
     9.247   121.401     0.200
     9.244   120.442     0.200
     9.436   122.258     0.200
     9.450   120.671     0.200
     9.468   120.700     0.200
     9.534   125.264     0.200
     9.603   129.295     0.200
     9.860   124.924     0.200
    10.811   136.424     0.200
    12.115   151.910     0.200
    12.096   152.827     0.200
    12.274   154.251     0.200
    13.051   164.779     0.200
    13.070   164.855     0.200
    13.371   167.648     0.200
    13.812   173.203     0.200
    13.806   174.167     0.200
    13.920   176.141     0.200
    14.225   178.085     0.200
    14.304   180.859     0.200
    14.331   181.249     0.200
    14.471   182.013     0.200
    14.645   184.982     0.200
    14.769   183.531     0.200
    15.068   187.644     0.200
    15.066   190.565     0.200
    16.295   205.417     0.200
    16.343   205.969     0.200
    16.520   207.197     0.200
    16.990   213.419     0.200
     1.072    25.804     0.200
     1.045    24.286     0.200
     1.833    31.542     0.200
     1.836    31.509     0.200
     1.871    35.149     0.200
     2.402    39.142     0.200
     2.402    39.728     0.200
     2.881    43.828     0.200
     2.881    44.859     0.200
     2.794    48.420     0.200
     3.037    48.023     0.200
     3.156    46.853     0.200
     3.443    52.228     0.200
     3.589    52.730     0.200
     4.152    60.262     0.200
     4.445    62.884     0.200
     4.465    63.640     0.200
     4.537    64.901     0.200
     4.534    67.146     0.200
     4.686    66.325     0.200
     4.692    67.511     0.200
     4.700    66.121     0.200
     4.700    65.738     0.200
     4.720    66.707     0.200
     5.033    71.739     0.200
     5.039    71.061     0.200
     5.135    72.564     0.200
     5.135    73.814     0.200
     5.143    70.813     0.200
     5.143    72.844     0.200
     5.262    74.062     0.200
     5.290    73.834     0.200
     5.324    77.278     0.200
     5.350    75.834     0.200
     5.538    76.516     0.200
     5.655    79.170     0.200
     5.708    82.978     0.200
     5.809    80.051     0.200
     5.847    81.235     0.200
     5.865    80.535     0.200
     5.935    81.420     0.200
     6.271    86.487     0.200
     6.517    89.032     0.200
     6.671    90.919     0.200
     6.680    91.635     0.200
     6.680    92.315     0.200
     6.817    92.911     0.200
     6.893    94.525     0.200
     6.876    93.518     0.200
     7.201   100.032     0.200
     7.201   100.321     0.200
     7.224    99.564     0.200
     7.264    97.073     0.200
     7.598   103.399     0.200
     7.776   103.652     0.200
     7.776   104.417     0.200
     8.059   106.718     0.200
     8.195   110.989     0.200
     8.326   112.903     0.200
     8.457   112.290     0.200
     8.549   113.997     0.200
     8.704   115.314     0.200
     8.855   118.433     0.200
     9.503   124.541     0.200
     9.583   125.578     0.200
     9.596   125.997     0.200
     9.692   128.041     0.200
     9.874   129.674     0.200
     9.965   130.164     0.200
    10.240   133.963     0.200
    10.243   136.834     0.200
    10.773   142.049     0.200
    10.994   145.466     0.200
    11.251   155.268     0.200
    13.550   172.641     0.200
     2.229    37.772     0.200
     2.455    38.421     0.200
     2.963    43.968     0.200
     3.260    48.313     0.200
     3.901    56.607     0.200
     3.945    55.705     0.200
     3.973    57.325     0.200
     3.972    54.996     0.200
     3.979    54.617     0.200
     3.995    61.796     0.200
     4.062    57.556     0.200
     4.306    59.892     0.200
     4.372    63.021     0.200
     4.558    61.280     0.200
     4.558    63.651     0.200
     4.586    63.126     0.200
     4.919    67.416     0.200
     4.922    67.911     0.200
     5.194    71.432     0.200
     5.449    74.433     0.200
     5.597    74.925     0.200
     5.613    76.337     0.200
     5.651    76.897     0.200
     5.783    80.127     0.200
     6.009    80.056     0.200
     1.073    24.231     0.200
     1.204    26.018     0.200
     2.068    35.849     0.200
     5.882    82.212     0.200
     5.963    82.469     0.200
     6.019    82.302     0.200
     6.064    83.240     0.200
     6.117    85.588     0.200
     6.117    85.870     0.200
     6.196    86.446     0.200
     6.272    86.864     0.200
     6.239    85.018     0.200
     6.520    90.870     0.200
     6.868    94.306     0.200
     7.086    94.522     0.200
     7.310    99.549     0.200
     7.808   106.033     0.200
     2.139    38.480     0.200
     2.662    47.201     0.200
     3.346    53.567     0.200
     3.321    56.463     0.200
     4.155    66.534     0.200
     4.595    67.257     0.200
     4.638    67.148     0.200
     4.642    70.615     0.200
     4.701    69.560     0.200
     4.777    69.440     0.200
     4.967    72.016     0.200
     4.989    72.753     0.200
     5.219    74.773     0.200
     5.635    77.469     0.200
     2.387    38.422     0.200
     2.388    42.299     0.200
     2.450    43.049     0.200
     2.503    41.868     0.200
     2.904    47.616     0.200
     2.904    46.848     0.200
     2.957    47.305     0.200
     3.039    46.341     0.200
     3.264    50.253     0.200
     3.408    52.368     0.200
     3.521    53.438     0.200
     3.651    56.474     0.200
     3.784    58.414     0.200
     3.784    59.650     0.200
     3.888    61.272     0.200
     4.131    61.252     0.200
     4.131    62.256     0.200
     4.413    63.507     0.200
     4.459    63.480     0.200
     4.459    63.371     0.200
     4.446    64.424     0.200
     4.482    63.879     0.200
     4.553    64.033     0.200
     4.553    66.377     0.200
     4.549    70.528     0.200
     4.645    66.317     0.200
     4.767    69.150     0.200
     4.767    70.068     0.200
     4.786    68.358     0.200
     4.806    69.324     0.200
     4.925    69.332     0.200
     5.029    72.124     0.200
     5.038    71.714     0.200
     5.058    70.782     0.200
     5.001    76.378     0.200
     5.203    72.967     0.200
     5.285    75.490     0.200
     5.399    76.112     0.200
     5.467    76.337     0.200
     5.726    80.486     0.200
     5.825    85.655     0.200
     6.032    82.416     0.200
     6.032    82.027     0.200
     6.113    85.473     0.200
     6.171    89.295     0.200
     6.197    84.590     0.200
     6.194    84.977     0.200
     6.273    93.287     0.200
     6.427    89.877     0.200
     6.584    88.098     0.200
     6.608    89.391     0.200
     6.669    92.580     0.200
     6.711    91.697     0.200
     7.092    96.150     0.200
     7.156    97.601     0.200
     7.156    97.720     0.200
     7.137    95.826     0.200
     7.207    98.106     0.200
     7.207   100.245     0.200
     7.539   102.033     0.200
     7.510   104.322     0.200
     7.510   105.433     0.200
     7.651   102.997     0.200
     7.729   107.430     0.200
     7.794   104.576     0.200
     8.031   107.585     0.200
     8.507   112.703     0.200
     8.515   112.845     0.200
     8.513   112.968     0.200
     8.672   115.258     0.200
     9.089   119.699     0.200
     9.494   123.820     0.200
     9.762   127.349     0.200
     9.769   127.976     0.200
     9.792   131.237     0.200
     9.912   130.396     0.200
    10.021   133.972     0.200
     9.988   129.948     0.200
    10.021   130.064     0.200
    10.060   132.396     0.200
    10.074   139.816     0.200
    10.125   135.593     0.200
    10.244   137.358     0.200
    10.244   137.063     0.200
    10.244   138.582     0.200
    10.375   134.034     0.200
    14.229   182.454     0.200
    14.444   183.853     0.200
    14.829   188.055     0.200
    14.854   188.065     0.200
    15.171   191.961     0.200
    15.492   196.519     0.200
     1.151    28.759     0.200
     1.242    30.536     0.200
     2.708    48.993     0.200
     2.186    38.515     0.200
     2.382    41.036     0.200
     2.904    46.439     0.200
     3.034    45.329     0.200
     3.384    52.171     0.200
     3.402    49.325     0.200
     3.518    52.648     0.200
     3.648    55.339     0.200
     3.783    57.413     0.200
     3.885    59.602     0.200
     4.405    63.648     0.200
     4.439    63.122     0.200
     4.450    63.720     0.200
     4.474    63.233     0.200
     4.547    63.337     0.200
     4.547    68.542     0.200
     4.641    65.637     0.200
     4.758    67.594     0.200
     4.758    68.833     0.200
     4.778    68.296     0.200
     4.797    66.740     0.200
     4.797    69.470     0.200
     4.918    69.460     0.200
     5.020    71.768     0.200
     4.999    74.594     0.200
     4.999    75.558     0.200
     5.030    68.853     0.200
     5.030    71.654     0.200
     5.050    71.219     0.200
     5.390    75.951     0.200
     5.460    75.267     0.200
     5.551    78.071     0.200
     5.719    80.718     0.200
     5.824    83.365     0.200
     6.028    81.431     0.200
     6.105    85.009     0.200
     6.190    84.617     0.200
     6.190    84.317     0.200
     6.190    84.556     0.200
     6.419    87.517     0.200
     6.577    87.698     0.200
     6.601    89.219     0.200
     6.662    90.914     0.200
     6.703    92.934     0.200
     7.084    97.783     0.200
     7.149    97.225     0.200
     7.532   102.561     0.200
     7.649   102.838     0.200
     7.787   105.077     0.200
     8.025   107.208     0.200
     8.373   112.743     0.200
     8.507   110.908     0.200
     8.665   112.320     0.200
     8.806   116.592     0.200
     9.757   126.250     0.200
    10.057   132.622     0.200
     3.365    54.165     0.200
     4.500    65.449     0.200
     4.543    63.243     0.200
     4.872    68.512     0.200
     5.484    77.958     0.200
     2.478    43.371     0.200
     4.464    66.758     0.200
     4.508    64.551     0.200
     4.860    73.039     0.200
     5.082    72.946     0.200
     5.088    73.076     0.200
     5.449    78.467     0.200
     6.159    85.881     0.200
     3.040    45.139     0.200
     3.389    56.930     0.200
     3.441    56.017     0.200
     3.507    51.182     0.200
     3.644    57.107     0.200
     3.762    57.033     0.200
     4.203    62.857     0.200
     4.468    62.497     0.200
     4.492    63.354     0.200
     4.513    62.581     0.200
     4.534    68.978     0.200
     4.562    63.392     0.200
     4.646    65.824     0.200
     4.809    66.967     0.200
     4.809    69.657     0.200
     4.821    69.218     0.200
     4.982    75.890     0.200
     5.068    72.729     0.200
     5.073    69.964     0.200
     5.073    72.274     0.200
     5.434    77.264     0.200
     5.489    75.720     0.200
     5.752    80.649     0.200
     6.032    81.679     0.200
     6.142    86.096     0.200
     6.220    86.190     0.200
     3.003    46.395     0.200
     3.456    53.789     0.200
     3.705    57.250     0.200
     3.822    60.962     0.200
     4.453    65.602     0.200
     4.455    63.920     0.200
     4.455    64.611     0.200
     4.492    64.443     0.200
     4.510    64.241     0.200
     4.482    71.063     0.200
     4.533    65.829     0.200
     4.608    66.468     0.200
     4.822    68.810     0.200
     4.822    70.998     0.200
     4.822    69.692     0.200
     4.856    70.994     0.200
     4.928    75.871     0.200
     5.075    73.849     0.200
     5.436    77.529     0.200
     5.474    77.007     0.200
     5.584    77.599     0.200
     5.742    81.358     0.200
     5.993    82.802     0.200
     6.150    84.830     0.200
     6.206    86.149     0.200
     7.097    96.439     0.200
     7.097    96.713     0.200
     7.789   104.237     0.200
     7.789   106.370     0.200
     5.596    81.489     0.200
     1.198    28.789     0.200
     2.985    53.122     0.200
     3.293    56.709     0.200
     3.457    55.541     0.200
     3.509    59.240     0.200
     4.057    61.969     0.200
     4.225    66.232     0.200
     4.476    70.513     0.200
     4.472    67.779     0.200
     4.760    73.950     0.200
     5.028    77.151     0.200
     5.127    78.980     0.200
     5.208    75.935     0.200
     5.297    77.398     0.200
     5.361    77.140     0.200
     5.425    78.191     0.200
     5.425    79.100     0.200
     5.439    78.998     0.200
     5.508    79.628     0.200
     5.600    81.256     0.200
     5.678    82.051     0.200
     5.747    82.741     0.200
     5.846    83.883     0.200
     5.829    84.091     0.200
     5.893    84.543     0.200
     6.191    88.658     0.200
     6.457    90.566     0.200
     6.665    94.434     0.200
     6.999    99.733     0.200
     7.174    99.789     0.200
     7.203   101.123     0.200
     7.203   102.447     0.200
     7.217    99.233     0.200
     7.394   103.452     0.200
     7.590   105.131     0.200
     7.672   107.149     0.200
     8.148   113.127     0.200
     8.835   121.222     0.200
     9.580   130.619     0.200
     9.663   130.458     0.200
     2.364    42.072     0.200
     5.378    77.032     0.200
     5.436    76.946     0.200
     5.740    81.808     0.200
     1.221    29.007     0.200
     1.959    36.754     0.200
     2.286    41.573     0.200
     3.053    51.534     0.200
     3.487    54.345     0.200
     3.469    56.195     0.200
     3.696    60.001     0.200
     4.568    65.569     0.200
     4.546    67.910     0.200
     4.489    69.685     0.200
     4.616    67.873     0.200
     4.598    69.079     0.200
     4.654    70.306     0.200
     4.947    72.190     0.200
     4.947    73.651     0.200
     4.935    70.991     0.200
     5.197    76.033     0.200
     5.550    78.920     0.200
     5.564    79.488     0.200
     5.689    80.597     0.200
     6.036    86.435     0.200
     6.239    87.978     0.200
     0.967    22.150     0.200
     1.334    25.269     0.200
     3.053    49.063     0.200
     4.697    66.086     0.200
     4.754    65.719     0.200
     4.789    66.536     0.200
     4.782    65.019     0.200
     5.014    71.086     0.200
     4.918    67.527     0.200
     5.066    70.280     0.200
     5.077    70.255     0.200
     5.294    73.318     0.200
     5.685    78.357     0.200
     5.804    78.261     0.200
     6.425    86.718     0.200
     1.175    29.860     0.200
     1.450    30.217     0.200
     1.711    31.750     0.200
     2.694    47.180     0.200
     2.854    49.491     0.200
     2.728    46.525     0.200
     2.939    50.273     0.200
     3.374    54.931     0.200
     3.399    55.482     0.200
     3.277    57.062     0.200
     3.652    55.931     0.200
     3.719    56.752     0.200
     3.765    57.109     0.200
     3.753    60.779     0.200
     3.813    57.244     0.200
     4.073    62.174     0.200
     3.939    65.060     0.200
     4.240    64.665     0.200
     4.400    68.809     0.200
     4.641    68.195     0.200
     4.846    71.601     0.200
     5.405    79.072     0.200
     5.553    79.354     0.200
     5.665    81.547     0.200
     5.654    78.767     0.200
     5.777    86.848     0.200
     5.851    83.187     0.200
     6.048    85.870     0.200
     7.207    98.651     0.200
     7.433   103.589     0.200
     7.952   109.018     0.200
     8.041   108.506     0.200
     0.969    21.154     0.200
     1.824    30.831     0.200
     1.817    29.955     0.200
     2.083    33.818     0.200
     2.806    43.982     0.200
     3.490    51.065     0.200
     3.452    54.177     0.200
     3.636    58.603     0.200
     4.677    64.407     0.200
     4.691    66.654     0.200
     4.769    64.201     0.200
     0.885    20.743     0.200
     1.731    30.168     0.200
     2.365    39.971     0.200
     3.496    50.359     0.200
     3.560    51.884     0.200
     3.668    56.097     0.200
     3.707    57.808     0.200
     4.512    66.725     0.200
     4.624    62.657     0.200
     4.659    65.585     0.200
     4.661    65.593     0.200
     4.693    65.517     0.200
     4.702    67.377     0.200
     4.704    64.015     0.200
     5.026    69.932     0.200
     5.045    70.364     0.200
     5.045    70.513     0.200
     5.075    70.767     0.200
     5.281    72.954     0.200
     5.293    73.623     0.200
     5.641    77.657     0.200
     6.082    81.570     0.200
     6.324    86.388     0.200
     6.373    87.309     0.200
     2.083    36.171     0.200
     2.143    38.299     0.200
     3.540    53.097     0.200
     4.178    66.821     0.200
     4.478    65.082     0.200
     4.501    64.254     0.200
     4.522    63.675     0.200
     4.544    64.246     0.200
     4.597    64.800     0.200
     4.681    65.837     0.200
     4.835    68.059     0.200
     4.835    66.723     0.200
     4.850    67.742     0.200
     4.873    70.272     0.200
     5.463    77.392     0.200
     6.173    84.998     0.200
     6.253    85.276     0.200
     0.996    21.895     0.200
     1.192    25.438     0.200
     2.878    46.639     0.200
     2.958    49.286     0.200
     3.338    53.786     0.200
     3.567    57.144     0.200
     3.780    58.800     0.200
     4.039    55.403     0.200
     4.115    57.154     0.200
     4.400    60.301     0.200
     6.367    85.290     0.200
     0.893    22.899     0.200
     1.008    23.981     0.200
     1.091    26.194     0.200
     2.664    44.306     0.200
     3.032    49.604     0.200
     3.725    52.874     0.200
     3.737    56.210     0.200
     3.849    54.623     0.200
     1.124    26.032     0.200
     1.206    28.342     0.200
     1.211    27.935     0.200
     1.249    28.443     0.200
     1.643    32.605     0.200
     1.741    33.951     0.200
     2.041    33.968     0.200
     2.042    34.923     0.200
     2.498    41.034     0.200
     2.554    41.640     0.200
     2.685    46.895     0.200
     2.803    44.498     0.200
     2.954    49.469     0.200
     3.051    48.726     0.200
     3.533    58.416     0.200
     3.898    59.479     0.200
     3.977    60.444     0.200
     3.933    63.012     0.200
     4.159    60.733     0.200
     4.389    62.602     0.200
     4.431    65.811     0.200
     4.452    65.158     0.200
     4.773    70.212     0.200
     4.689    70.900     0.200
     4.945    72.010     0.200
     4.963    70.447     0.200
     4.963    72.494     0.200
     5.134    74.800     0.200
     5.383    77.294     0.200
     5.354    77.031     0.200
     5.409    76.990     0.200
     5.861    83.017     0.200
     6.394    91.295     0.200
     6.554    93.536     0.200
     6.767    96.642     0.200
     2.081    37.472     0.200
     2.385    42.171     0.200
     3.247    50.202     0.200
     3.410    51.470     0.200
     3.496    55.365     0.200
     3.632    57.216     0.200
     3.753    58.585     0.200
     3.862    60.445     0.200
     4.095    64.154     0.200
     4.433    64.260     0.200
     4.453    64.153     0.200
     4.476    64.363     0.200
     4.497    64.180     0.200
     4.523    68.368     0.200
     4.548    64.987     0.200
     4.632    67.206     0.200
     4.793    69.392     0.200
     4.793    69.963     0.200
     4.805    69.327     0.200
     4.831    70.226     0.200
     4.934    69.719     0.200
     4.972    77.252     0.200
     5.052    72.237     0.200
     5.074    72.589     0.200
     5.418    77.573     0.200
     5.573    78.060     0.200
     5.573    77.730     0.200
     6.018    82.932     0.200
     6.178    85.714     0.200
     6.204    85.996     0.200
     6.581    89.779     0.200
     6.615    90.405     0.200
     6.725    93.812     0.200
     6.896    93.459     0.200
     7.162    99.124     0.200
     7.545   103.144     0.200
     7.627   105.362     0.200
     7.795   103.549     0.200
     7.795   107.029     0.200
     8.036   109.920     0.200
     8.147   110.525     0.200
     8.378   112.625     0.200
     8.512   114.043     0.200
     8.520   114.572     0.200
     8.677   115.305     0.200
     8.818   118.988     0.200
     1.096    27.066     0.200
     1.473    27.067     0.200
     2.692    44.046     0.200
     2.969    49.930     0.200
     3.059    51.740     0.200
     3.338    54.545     0.200
     3.796    55.904     0.200
     3.928    56.708     0.200
     3.845    58.777     0.200
     3.936    56.508     0.200
     2.675    44.696     0.200
     2.971    48.854     0.200
     3.707    58.128     0.200
     3.713    54.308     0.200
     3.733    55.006     0.200
     3.831    53.986     0.200
     2.109    36.828     0.200
     2.404    40.637     0.200
     3.500    53.038     0.200
     3.752    58.166     0.200
     3.866    57.989     0.200
     4.461    62.522     0.200
     4.475    63.008     0.200
     4.503    63.036     0.200
     4.523    63.914     0.200
     4.564    63.767     0.200
     4.645    66.860     0.200
     4.832    67.297     0.200
     4.974    72.111     0.200
     5.081    72.082     0.200
     5.445    77.836     0.200
     6.030    82.355     0.200
     6.151    85.299     0.200
     6.188    84.868     0.200
     6.227    85.617     0.200
     4.518    65.354     0.200
     4.541    63.527     0.200
     4.603    65.418     0.200
     4.690    66.468     0.200
     4.846    69.529     0.200
     4.866    70.990     0.200
     1.906    34.030     0.200
     2.902    48.316     0.200
     3.386    53.461     0.200
     3.478    52.811     0.200
     3.604    54.931     0.200
     3.846    56.739     0.200
     4.459    70.187     0.200
     4.793    70.056     0.200
     4.824    68.945     0.200
     4.898    69.600     0.200
     5.037    71.916     0.200
     5.040    72.483     0.200
     5.050    72.264     0.200
     5.388    76.418     0.200
     5.464    77.996     0.200
     5.479    78.053     0.200
     5.616    80.350     0.200
     5.639    76.802     0.200
     5.689    80.807     0.200
     6.004    83.927     0.200
     6.097    84.845     0.200
     6.208    86.349     0.200
     6.633    92.388     0.200
     6.636    92.352     0.200
     1.175    25.970     0.200
     1.241    28.532     0.200
     1.320    27.118     0.200
     5.427    77.032     0.200
     5.525    77.479     0.200
     5.600    77.159     0.200
     5.705    80.029     0.200
     5.821    81.326     0.200
     5.944    83.197     0.200
     5.976    82.141     0.200
     6.143    85.330     0.200
     6.405    88.021     0.200
     7.431   102.343     0.200
     7.530   102.633     0.200
     3.811    53.042     0.200
     3.847    53.071     0.200
     3.860    53.853     0.200
     4.069    57.967     0.200
     4.133    58.179     0.200
     4.133    58.079     0.200
     4.239    57.614     0.200
     4.742    64.670     0.200
     5.117    69.298     0.200
     5.484    73.908     0.200
     5.607    75.583     0.200
     2.051    37.016     0.200
     3.464    50.627     0.200
     3.561    53.958     0.200
     4.471    63.382     0.200
     4.517    63.054     0.200
     4.503    63.892     0.200
     4.540    64.337     0.200
     4.606    68.018     0.200
     4.588    70.660     0.200
     4.694    67.014     0.200
     4.824    68.509     0.200
     4.824    68.173     0.200
     4.844    69.331     0.200
     4.864    69.305     0.200
     5.087    71.003     0.200
     5.096    71.788     0.200
     5.457    76.685     0.200
     5.617    77.211     0.200
     5.784    79.767     0.200
     6.171    85.448     0.200
     6.638    90.425     0.200
     2.957    48.348     0.200
     3.409    53.258     0.200
     3.775    56.378     0.200
     3.853    57.635     0.200
     4.046    59.481     0.200
     4.310    62.476     0.200
     4.413    66.562     0.200
     4.651    68.919     0.200
     4.735    67.139     0.200
     4.800    67.676     0.200
     4.843    68.841     0.200
     4.859    68.878     0.200
     5.028    70.245     0.200
     5.028    69.816     0.200
     5.088    70.382     0.200
     5.088    71.523     0.200
     5.118    71.465     0.200
     5.075    76.677     0.200
     5.146    72.702     0.200
     5.319    74.924     0.200
     5.328    74.017     0.200
     5.369    73.659     0.200
     5.369    76.140     0.200
     5.414    75.808     0.200
     5.528    82.643     0.200
     5.723    78.302     0.200
     5.923    81.369     0.200
     5.923    82.349     0.200
     6.118    84.900     0.200
     6.482    89.453     0.200
     6.534    88.717     0.200
     6.607    90.191     0.200
     6.703    90.646     0.200
     6.748    90.896     0.200
     6.748    93.349     0.200
     7.021    93.859     0.200
     7.043    94.399     0.200
     7.574   103.811     0.200
     7.640   102.632     0.200
     7.949   106.025     0.200
     8.175   110.940     0.200
     8.234   110.685     0.200
     8.234   109.607     0.200
     8.453   113.840     0.200
     8.563   114.264     0.200
     8.830   117.147     0.200
     8.933   117.950     0.200
     8.965   119.971     0.200
     9.091   122.052     0.200
     9.227   122.812     0.200
     9.495   124.659     0.200
    10.001   131.496     0.200
    10.246   134.063     0.200
     1.587    31.993     0.200
     2.305    40.157     0.200
     3.467    56.233     0.200
     3.468    57.150     0.200
     4.014    63.136     0.200
     4.190    63.701     0.200
     4.430    66.795     0.200
     4.737    71.371     0.200
     4.842    71.912     0.200
     5.147    73.500     0.200
     5.012    77.037     0.200
     5.105    78.210     0.200
     5.238    73.851     0.200
     5.304    75.704     0.200
     5.361    75.293     0.200
     5.361    76.215     0.200
     5.387    77.100     0.200
     5.540    79.119     0.200
     5.684    80.737     0.200
     5.636    81.090     0.200
     5.839    82.427     0.200
     5.864    82.939     0.200
     5.793    81.930     0.200
     5.768    85.595     0.200
     6.380    89.423     0.200
     6.380    89.681     0.200
     6.609    92.347     0.200
     6.941    95.772     0.200
     7.141    99.496     0.200
     7.141   100.434     0.200
     7.120    99.076     0.200
     7.181    98.021     0.200
     7.518   100.430     0.200
     7.360   100.862     0.200
     7.507   104.662     0.200
     7.537   101.819     0.200
     7.625   103.296     0.200
     7.941   108.806     0.200
     8.101   111.329     0.200
     8.287   111.913     0.200
     8.784   119.431     0.200
     8.784   119.158     0.200
     8.861   122.071     0.200
     8.978   122.498     0.200
     9.086   122.241     0.200
     9.396   126.924     0.200
     9.531   127.718     0.200
     9.728   133.922     0.200
     9.610   128.980     0.200
    10.529   139.219     0.200
    10.859   144.960     0.200
    10.926   146.300     0.200
     1.144    24.922     0.200
     1.273    26.881     0.200
     2.808    47.782     0.200
     2.815    44.960     0.200
     3.884    56.778     0.200
     3.960    57.898     0.200
     4.014    56.586     0.200
     4.080    57.231     0.200
     4.161    59.171     0.200
     4.161    60.944     0.200
     4.352    62.654     0.200
     4.456    64.901     0.200
     4.534    63.197     0.200
     4.551    62.574     0.200
     4.660    69.662     0.200
     4.872    69.150     0.200
     5.309    73.750     0.200
     5.815    79.143     0.200
     5.933    79.685     0.200
     1.128    26.688     0.200
     1.302    29.032     0.200
     1.332    28.831     0.200
     2.870    48.070     0.200
     2.975    51.049     0.200
     3.008    50.016     0.200
     3.357    52.090     0.200
     3.919    56.934     0.200
     3.829    58.542     0.200
     4.337    62.451     0.200
     4.502    67.524     0.200
     4.546    65.325     0.200
     1.225    28.629     0.200
     1.305    29.287     0.200
     1.334    30.008     0.200
     2.404    42.275     0.200
     2.721    47.282     0.200
     2.821    48.608     0.200
     2.893    48.264     0.200
     3.100    53.932     0.200
     3.156    54.738     0.200
     3.450    56.847     0.200
     3.769    61.481     0.200
     4.312    67.385     0.200
     4.753    70.848     0.200
     4.794    70.308     0.200
     4.794    70.990     0.200
     4.815    71.667     0.200
     5.018    74.790     0.200
     5.137    75.711     0.200
     5.495    80.322     0.200
     5.747    81.687     0.200
     2.886    48.784     0.200
     2.592    43.788     0.200
     3.394    54.825     0.200
     4.886    67.737     0.200
     4.963    68.744     0.200
     5.274    72.307     0.200
     5.526    76.574     0.200
     5.523    78.804     0.200
     1.353    28.654     0.200
     3.061    52.624     0.200
     3.900    57.515     0.200
     3.954    57.202     0.200
     4.021    58.291     0.200
     4.165    63.120     0.200
     4.212    62.576     0.200
     4.297    62.185     0.200
     4.501    65.812     0.200
     5.039    71.372     0.200
     5.756    80.760     0.200
     2.748    45.929     0.200
     3.077    49.993     0.200
     3.626    54.385     0.200
     3.817    56.499     0.200
     3.895    56.977     0.200
     3.967    55.341     0.200
     3.900    59.997     0.200
     4.017    54.594     0.200
     4.072    55.100     0.200
     4.281    59.375     0.200
     4.328    60.214     0.200
     4.473    64.026     0.200
     4.530    61.752     0.200
     4.530    64.661     0.200
     4.519    62.652     0.200
     4.613    67.880     0.200
     4.883    69.544     0.200
     5.098    74.016     0.200
     5.308    72.991     0.200
     5.810    77.925     0.200
     5.902    80.213     0.200
     6.307    84.024     0.200
     0.449    12.950     0.200
     0.955    20.306     0.200
     1.099    20.978     0.200
     1.079    19.741     0.200
     1.254    22.995     0.200
     1.386    25.286     0.200
     2.163    33.894     0.200
     2.555    40.219     0.200
     2.654    39.951     0.200
     2.543    40.662     0.200
     2.658    41.087     0.200
     4.104    55.100     0.200
     4.195    56.136     0.200
     4.497    60.516     0.200
     4.742    61.429     0.200
     5.087    67.728     0.200
     6.094    79.674     0.200
     3.420    55.415     0.200
     5.194    73.503     0.200
     5.275    74.355     0.200
     5.436    76.680     0.200
     5.436    77.298     0.200
     5.512    75.270     0.200
     5.512    77.895     0.200
     5.584    78.454     0.200
     5.749    81.032     0.200
     5.846    81.095     0.200
     5.897    81.897     0.200
     6.180    85.696     0.200
     6.411    89.906     0.200
     6.626    91.093     0.200
     6.971    96.161     0.200
     7.127    96.839     0.200
     7.197   100.024     0.200
     7.543   101.693     0.200
     8.981   121.311     0.200
     9.089   122.246     0.200
     1.163    25.830     0.200
     1.620    29.366     0.200
     2.447    42.188     0.200
     2.602    44.209     0.200
     2.842    46.535     0.200
     2.951    48.817     0.200
     3.002    48.437     0.200
     3.252    52.659     0.200
     3.541    53.952     0.200
     3.715    55.680     0.200
     3.887    58.956     0.200
     4.135    59.523     0.200
     4.540    66.765     0.200
     4.721    69.491     0.200
     4.890    68.992     0.200
     4.974    69.914     0.200
     4.974    69.445     0.200
     5.034    69.846     0.200
     5.102    71.580     0.200
     5.127    73.125     0.200
     5.204    71.891     0.200
     5.204    73.227     0.200
     5.281    73.738     0.200
     5.336    74.953     0.200
     5.441    77.063     0.200
     5.470    78.296     0.200
     5.491    77.027     0.200
     5.528    75.859     0.200
     5.528    78.445     0.200
     5.558    76.509     0.200
     5.598    78.134     0.200
     5.876    81.491     0.200
     6.112    84.633     0.200
     6.121    82.991     0.200
     6.333    86.760     0.200
     6.673    91.892     0.200
     6.839    93.148     0.200
     7.057    96.375     0.200
     7.255    97.794     0.200
     8.496   114.623     0.200
     8.803   117.635     0.200
     9.239   120.616     0.200
     2.221    36.990     0.200
     3.428    51.092     0.200
     3.468    50.338     0.200
     3.797    54.593     0.200
     3.939    55.835     0.200
     4.050    56.945     0.200
     4.411    62.024     0.200
     1.264    28.256     0.200
     1.507    29.515     0.200
     1.788    33.096     0.200
     2.205    40.619     0.200
     2.983    51.307     0.200
     4.290    64.449     0.200
     5.260    76.044     0.200
     5.350    75.703     0.200
     5.417    78.271     0.200
     5.472    78.376     0.200
     5.498    78.790     0.200
     5.557    79.184     0.200
     5.653    80.460     0.200
     5.742    81.432     0.200
     5.899    84.292     0.200
     5.894    84.014     0.200
     5.951    83.381     0.200
     6.243    87.876     0.200
     6.492    91.062     0.200
     6.516    91.484     0.200
     6.722    93.888     0.200
     7.232    99.827     0.200
     1.040    24.920     0.200
     1.146    26.442     0.200
     1.239    27.298     0.200
     1.731    30.053     0.200
     2.329    37.818     0.200
     2.760    44.546     0.200
     2.906    46.628     0.200
     3.024    48.390     0.200
     3.127    50.847     0.200
     3.787    59.014     0.200
     3.889    55.407     0.200
     3.885    58.492     0.200
     3.928    58.594     0.200
     4.016    57.390     0.200
     4.016    56.106     0.200
     4.026    57.571     0.200
     4.365    62.619     0.200
     4.382    61.420     0.200
     4.616    64.147     0.200
     4.616    65.186     0.200
     4.898    67.786     0.200
     4.981    70.335     0.200
     5.075    71.537     0.200
     5.066    74.431     0.200
     5.194    72.844     0.200
     5.309    74.040     0.200
     5.460    76.617     0.200
     5.616    78.017     0.200
     5.631    78.641     0.200
     0.998    25.944     0.200
     1.502    30.116     0.200
     1.767    34.293     0.200
     2.197    39.084     0.200
     2.776    47.907     0.200
     2.978    49.242     0.200
     3.262    52.758     0.200
     3.412    54.808     0.200
     3.662    60.835     0.200
     3.725    62.066     0.200
     5.333    76.438     0.200
     5.400    77.603     0.200
     5.483    79.566     0.200
     5.538    79.850     0.200
     5.635    81.215     0.200
     5.729    81.033     0.200
     5.777    82.756     0.200
     5.881    82.508     0.200
     5.881    84.148     0.200
     5.884    82.124     0.200
     5.935    84.315     0.200
     6.225    87.334     0.200
     6.501    91.148     0.200
     7.037    99.360     0.200
     7.216    98.260     0.200
     1.636    32.968     0.200
     2.516    44.746     0.200
     2.774    48.273     0.200
     2.872    51.017     0.200
     3.258    54.792     0.200
     3.339    54.995     0.200
     3.366    54.233     0.200
     3.553    55.994     0.200
     3.757    62.270     0.200
     3.868    63.683     0.200
     4.097    65.152     0.200
     3.872    65.005     0.200
     4.288    65.316     0.200
     4.503    69.597     0.200
     4.545    68.329     0.200
     4.853    72.614     0.200
     4.949    76.265     0.200
     5.175    75.738     0.200
     5.137    78.237     0.200
     5.272    76.314     0.200
     5.344    75.919     0.200
     5.369    77.778     0.200
     5.445    77.816     0.200
     5.459    76.827     0.200
     5.459    79.029     0.200
     5.570    80.136     0.200
     5.699    81.921     0.200
     5.717    80.659     0.200
     5.814    80.887     0.200
     5.814    84.285     0.200
     5.891    83.983     0.200
     5.900    84.479     0.200
     5.888    83.619     0.200
     6.155    87.104     0.200
     6.417    89.420     0.200
     6.417    90.951     0.200
     6.460    90.504     0.200
     6.655    94.169     0.200
     6.852    97.770     0.200
     6.978    98.301     0.200
     7.162   101.758     0.200
     7.172   100.638     0.200
     7.275    99.968     0.200
     7.458   102.099     0.200
     7.539   105.654     0.200
     7.589   105.875     0.200
     8.147   113.855     0.200
     8.250   109.140     0.200
     8.845   122.208     0.200
     8.973   121.154     0.200
     9.032   123.635     0.200
     9.139   125.186     0.200
     9.461   129.427     0.200
     9.596   130.121     0.200
     9.661   129.182     0.200
    10.939   146.057     0.200
     1.075    25.481     0.200
     1.139    25.766     0.200
     1.354    26.163     0.200
     2.069    37.358     0.200
     2.015    36.557     0.200
     3.418    55.570     0.200
     3.827    61.616     0.200
     3.763    60.636     0.200
     4.480    65.004     0.200
     5.017    71.024     0.200
     5.508    76.185     0.200
     5.579    78.717     0.200
     5.609    78.010     0.200
     5.672    80.465     0.200
     5.699    79.962     0.200
     5.807    79.398     0.200
     5.939    82.156     0.200
     5.927    80.433     0.200
     6.052    85.137     0.200
     6.084    83.609     0.200
     6.121    84.635     0.200
     6.394    88.251     0.200
     6.688    91.236     0.200
     6.852    94.284     0.200
     7.402   102.380     0.200
     1.268    27.433     0.200
     2.423    40.319     0.200
     3.834    59.140     0.200
     4.405    66.175     0.200
     4.497    66.703     0.200
     4.878    69.133     0.200
     4.878    71.067     0.200
     4.941    72.854     0.200
     4.941    69.905     0.200
     5.022    71.953     0.200
     5.018    70.450     0.200
     5.101    73.234     0.200
     5.101    71.175     0.200
     5.183    73.474     0.200
     5.269    75.210     0.200
     5.269    73.206     0.200
     5.435    76.475     0.200
     5.435    76.901     0.200
     5.471    77.315     0.200
     5.471    77.089     0.200
     5.777    81.149     0.200
     6.243    87.704     0.200
     6.753    93.061     0.200
     6.821    91.800     0.200
     7.169    98.902     0.200
     1.311    28.128     0.200
     2.101    37.629     0.200
     2.112    35.853     0.200
     2.793    48.337     0.200
     3.405    55.797     0.200
     3.378    57.132     0.200
     4.489    64.119     0.200
     4.809    69.485     0.200
     4.818    69.578     0.200
     4.846    69.456     0.200
     4.944    69.410     0.200
     5.067    73.070     0.200
     5.070    72.934     0.200
     5.070    70.374     0.200
     5.585    78.328     0.200
     5.747    81.041     0.200
     6.138    86.176     0.200
     6.214    85.493     0.200
     5.383    76.310     0.200
     5.865    82.692     0.200
     5.959    83.894     0.200
     1.202    28.967     0.200
     1.278    29.770     0.200
     1.408    28.114     0.200
     2.696    46.828     0.200
     4.489    63.699     0.200
     5.057    74.583     0.200
     5.057    75.583     0.200
     5.330    75.985     0.200
     5.432    77.002     0.200
     5.505    77.647     0.200
     5.509    77.323     0.200
     5.601    79.130     0.200
     5.601    77.751     0.200
     5.623    78.953     0.200
     5.726    80.472     0.200
     5.726    81.167     0.200
     5.842    81.211     0.200
     5.910    82.728     0.200
     5.968    83.939     0.200
     6.062    85.447     0.200
     6.066    85.102     0.200
     6.066    85.672     0.200
     6.088    85.964     0.200
     6.089    88.370     0.200
     6.307    87.891     0.200
     6.307    87.731     0.200
     6.579    91.412     0.200
     6.579    90.775     0.200
     6.636    91.705     0.200
     6.825    94.946     0.200
     7.140    99.066     0.200
     7.308   101.699     0.200
     7.346   100.464     0.200
     7.474   100.426     0.200
     7.762   105.304     0.200
     7.884   105.780     0.200
     8.143   113.562     0.200
     8.322   113.573     0.200
     9.026   122.857     0.200
     0.804    19.191     0.200
     1.206    24.250     0.200
     2.314    37.270     0.200
     2.651    44.336     0.200
     3.197    51.522     0.200
     3.477    53.761     0.200
     3.625    52.531     0.200
     4.276    61.152     0.200
     4.365    61.815     0.200
     4.365    59.987     0.200
     4.529    63.674     0.200
     4.529    62.713     0.200
     4.918    68.281     0.200
     4.918    68.508     0.200
     4.951    68.716     0.200
     5.175    69.583     0.200
     5.528    75.742     0.200
     6.012    80.398     0.200
     6.543    87.226     0.200
     0.852    18.781     0.200
     2.454    39.629     0.200
     2.566    40.379     0.200
     2.566    40.797     0.200
     4.198    56.776     0.200
     4.415    59.845     0.200
     4.496    60.697     0.200
     4.837    64.924     0.200
     4.915    65.815     0.200
     1.108    25.502     0.200
     1.149    27.125     0.200
     2.262    38.630     0.200
     2.493    40.753     0.200
     2.435    42.664     0.200
     4.321    63.156     0.200
     4.414    61.728     0.200
     4.485    65.103     0.200
     4.535    65.962     0.200
     4.535    64.759     0.200
     4.714    68.268     0.200
     4.959    71.907     0.200
     4.904    69.748     0.200
     5.036    72.009     0.200
     5.036    71.173     0.200
     5.114    71.708     0.200
     5.303    75.799     0.200
     0.549    15.582     0.200
     0.748    17.748     0.200
     1.606    28.028     0.200
     1.982    30.786     0.200
     1.985    31.766     0.200
     3.071    43.892     0.200
     2.953    46.036     0.200
     3.590    55.802     0.200
     3.843    55.365     0.200
     4.378    65.539     0.200
     4.682    64.466     0.200
     4.789    66.978     0.200
     4.804    65.549     0.200
     5.175    70.874     0.200
     5.224    73.093     0.200
     5.396    74.792     0.200
     5.689    75.261     0.200
     5.760    78.939     0.200
     1.373    31.948     0.200
     1.977    38.580     0.200
     2.066    37.729     0.200
     5.579    80.158     0.200
     5.702    81.918     0.200
     5.977    85.314     0.200
     6.039    86.289     0.200
     6.398    90.995     0.200
     6.535    92.692     0.200
     0.749    18.705     0.200
     2.214    37.447     0.200
     2.908    43.560     0.200
     2.908    44.068     0.200
     3.112    46.122     0.200
     3.552    51.588     0.200
     3.900    52.105     0.200
     3.969    53.098     0.200
     4.018    54.039     0.200
     4.065    55.020     0.200
     4.195    58.863     0.200
     4.285    60.313     0.200
     4.311    58.722     0.200
     4.311    61.523     0.200
     4.483    62.507     0.200
     4.535    63.298     0.200
     4.524    63.625     0.200
     4.497    61.375     0.200
     4.497    61.703     0.200
     4.582    66.880     0.200
     4.889    67.871     0.200
     5.085    67.083     0.200
     5.085    68.130     0.200
     5.880    77.280     0.200
     2.679    46.854     0.200
     3.066    46.412     0.200
     3.371    52.019     0.200
     4.642    67.943     0.200
     4.644    67.918     0.200
     4.680    67.495     0.200
     4.790    68.633     0.200
     4.804    67.811     0.200
     4.804    67.176     0.200
     4.808    68.626     0.200
     4.808    67.950     0.200
     5.145    72.393     0.200
     5.173    73.057     0.200
     5.226    74.543     0.200
     5.397    76.152     0.200
     5.397    74.363     0.200
     5.438    78.777     0.200
     5.687    78.460     0.200
     5.761    80.702     0.200
     5.865    81.988     0.200
     5.986    83.373     0.200
     6.407    88.658     0.200
     6.421    88.001     0.200
     3.905    57.292     0.200
     3.981    58.202     0.200
     4.293    62.468     0.200
     4.475    63.634     0.200
     4.558    64.774     0.200
     4.893    70.266     0.200
     5.332    74.833     0.200
     6.204    84.557     0.200
     6.467    87.287     0.200
     6.499    86.613     0.200
     6.697    89.504     0.200
     6.928    91.707     0.200
     7.012    93.230     0.200
     7.645   101.840     0.200
     8.191   106.258     0.200
     0.829    19.794     0.200
     1.191    25.372     0.200
     1.214    24.395     0.200
     4.110    58.921     0.200
     4.216    58.988     0.200
     4.380    61.768     0.200
     4.506    62.800     0.200
     4.622    64.653     0.200
     4.748    66.279     0.200
     4.877    66.472     0.200
     5.085    69.445     0.200
     5.622    76.975     0.200
     6.153    83.587     0.200
     1.063    22.982     0.200
     1.149    24.337     0.200
     1.186    25.811     0.200
     2.611    43.907     0.200
     3.330    49.683     0.200
     4.128    58.122     0.200
     4.232    60.212     0.200
     4.314    61.948     0.200
     4.403    62.616     0.200
     4.524    63.104     0.200
     4.644    63.805     0.200
     4.766    66.976     0.200
     4.821    67.333     0.200
     4.887    67.266     0.200
     4.887    67.842     0.200
     5.104    70.929     0.200
     5.380    75.310     0.200
     5.461    74.732     0.200
     5.941    81.963     0.200
     2.348    38.680     0.200
     2.391    40.889     0.200
     3.064    48.614     0.200
     3.586    56.514     0.200
     5.170    73.354     0.200
     5.253    74.882     0.200
     5.561    77.890     0.200
     5.592    79.578     0.200
     5.832    81.820     0.200
     6.394    89.419     0.200
     1.728    31.578     0.200
     2.897    45.824     0.200
     3.454    52.954     0.200
     3.561    53.162     0.200
     4.036    58.818     0.200
     4.036    61.146     0.200
     4.174    62.772     0.200
     4.281    65.253     0.200
     4.402    66.224     0.200
     4.832    68.439     0.200
     4.892    69.436     0.200
     4.929    69.070     0.200
     4.929    70.011     0.200
     4.928    69.087     0.200
     4.928    69.892     0.200
     5.068    70.095     0.200
     5.068    72.220     0.200
     5.139    73.455     0.200
     5.169    73.722     0.200
     5.194    74.710     0.200
     5.213    73.493     0.200
     5.213    72.758     0.200
     5.401    75.096     0.200
     5.401    73.573     0.200
     5.423    77.334     0.200
     5.464    78.961     0.200
     5.502    77.613     0.200
     5.820    80.304     0.200
     5.903    83.527     0.200
     5.950    82.410     0.200
     5.950    82.961     0.200
     6.009    84.699     0.200
     6.009    83.008     0.200
     6.195    86.531     0.200
     6.195    85.433     0.200
     6.566    90.496     0.200
     6.555    90.068     0.200
     6.678    91.493     0.200
     7.091    96.375     0.200
     8.167   111.377     0.200
     2.375    41.282     0.200
     5.507    75.722     0.200
     5.572    78.973     0.200
     5.796    82.756     0.200
     5.858    81.528     0.200
     5.890    81.853     0.200
     6.085    84.783     0.200
     6.496    91.085     0.200
     7.249    99.592     0.200
     1.068    25.596     0.200
     1.321    29.160     0.200
     2.451    43.049     0.200
     3.813    56.324     0.200
     3.839    57.052     0.200
     3.843    58.729     0.200
     3.914    61.986     0.200
     4.024    57.869     0.200
     4.025    64.419     0.200
     4.181    60.771     0.200
     4.311    62.918     0.200
     4.390    65.491     0.200
     4.749    70.199     0.200
     5.104    73.357     0.200
     5.479    77.587     0.200
     0.749    18.291     0.200
     1.911    32.558     0.200
     2.876    43.905     0.200
     3.121    47.459     0.200
     3.264    48.111     0.200
     3.264    49.006     0.200
     3.789    55.178     0.200
     3.969    56.711     0.200
     4.052    56.446     0.200
     4.052    57.637     0.200
     4.152    61.221     0.200
     4.198    58.266     0.200
     4.223    58.049     0.200
     4.293    60.435     0.200
     4.293    59.606     0.200
     4.359    61.761     0.200
     4.359    61.335     0.200
     4.491    60.913     0.200
     4.491    62.042     0.200
     4.528    63.890     0.200
     4.607    65.069     0.200
     4.607    63.307     0.200
     4.647    63.805     0.200
     4.700    63.955     0.200
     4.700    64.607     0.200
     4.818    71.179     0.200
     4.955    68.104     0.200
     4.955    67.057     0.200
     5.190    69.854     0.200
     5.214    71.079     0.200
     5.513    74.485     0.200
     5.751    79.412     0.200
     5.928    81.655     0.200
     6.079    79.854     0.200
     6.183    87.977     0.200
     6.344    86.193     0.200
     6.454    85.827     0.200
     7.181    93.611     0.200
     7.598   100.861     0.200
     0.934    21.931     0.200
     1.075    24.418     0.200
     1.287    27.877     0.200
     2.220    36.738     0.200
     2.579    44.005     0.200
     2.579    43.630     0.200
     2.814    47.234     0.200
     3.797    56.976     0.200
     4.036    57.427     0.200
     4.059    58.949     0.200
     4.059    58.019     0.200
     4.064    58.602     0.200
     4.363    63.005     0.200
     4.363    62.412     0.200
     4.400    63.773     0.200
     4.535    65.291     0.200
     4.541    65.729     0.200
     4.650    66.054     0.200
     4.864    68.810     0.200
     4.864    68.631     0.200
     5.015    71.295     0.200
     5.080    71.532     0.200
     5.597    77.604     0.200
     5.614    79.201     0.200
     1.604    30.733     0.200
     1.803    34.064     0.200
     1.958    36.364     0.200
     2.341    41.722     0.200
     2.737    45.637     0.200
     2.889    44.243     0.200
     3.025    47.507     0.200
     2.987    48.770     0.200
     2.987    49.441     0.200
     2.967    48.808     0.200
     3.104    46.996     0.200
     3.230    50.444     0.200
     3.344    53.350     0.200
     3.923    61.980     0.200
     4.084    64.157     0.200
     4.480    65.764     0.200
     4.771    66.896     0.200
     4.771    66.609     0.200
     4.792    68.254     0.200
     4.793    68.251     0.200
     4.793    67.452     0.200
     5.093    71.947     0.200
     5.093    71.505     0.200
     5.133    71.979     0.200
     5.256    75.048     0.200
     5.254    74.272     0.200
     5.344    75.417     0.200
     5.383    76.660     0.200
     5.383    75.170     0.200
     5.458    77.988     0.200
     5.588    78.050     0.200
     5.588    79.003     0.200
     5.748    80.801     0.200
     5.748    79.474     0.200
     5.908    83.034     0.200
     6.319    88.036     0.200
     6.348    88.702     0.200
     1.130    26.505     0.200
     1.283    27.383     0.200
     1.728    30.758     0.200
     1.903    34.890     0.200
     2.705    45.925     0.200
     3.595    54.066     0.200
     4.085    59.291     0.200
     4.818    68.014     0.200
     4.882    69.265     0.200
     4.923    70.686     0.200
     5.091    71.900     0.200
     5.172    73.968     0.200
     5.172    72.194     0.200
     5.200    73.343     0.200
     5.404    75.968     0.200
     5.451    76.816     0.200
     5.451    74.988     0.200
     5.806    80.877     0.200
     5.956    83.160     0.200
     6.003    83.679     0.200
     6.195    85.736     0.200
     2.078    36.593     0.200
     2.672    45.940     0.200
     3.699    58.933     0.200
     3.910    57.668     0.200
     3.942    57.708     0.200
     4.043    58.511     0.200
     4.243    61.380     0.200
     4.336    61.890     0.200
     4.579    69.591     0.200
     4.792    69.472     0.200
     4.859    69.792     0.200
     4.871    68.492     0.200
     2.436    41.559     0.200
     2.494    43.525     0.200
     2.769    45.012     0.200
     3.115    49.581     0.200
     3.132    50.903     0.200
     4.029    63.332     0.200
     4.272    64.337     0.200
     4.444    67.411     0.200
     4.444    67.653     0.200
     4.503    67.863     0.200
     4.503    65.543     0.200
     4.618    68.712     0.200
     4.633    68.448     0.200
     4.803    74.216     0.200
     4.883    71.410     0.200
     4.883    70.512     0.200
     5.449    82.958     0.200
     5.495    78.169     0.200
     5.495    76.872     0.200
     5.548    78.482     0.200
     5.549    77.641     0.200
     5.549    77.828     0.200
     5.579    77.130     0.200
     5.624    80.749     0.200
     5.624    79.249     0.200
     5.673    80.851     0.200
     5.673    79.156     0.200
     5.813    82.361     0.200
     5.813    81.252     0.200
     5.866    85.147     0.200
     5.866    81.483     0.200
     5.873    83.156     0.200
     5.873    81.312     0.200
     5.873    85.984     0.200
     6.028    84.049     0.200
     6.094    86.578     0.200
     6.125    86.626     0.200
     6.125    84.415     0.200
     6.154    85.479     0.200
     6.359    89.326     0.200
     6.483    90.245     0.200
     6.483    89.542     0.200
     6.569    89.641     0.200
     6.569    90.992     0.200
     6.624    95.719     0.200
     6.829    94.706     0.200
     6.829    93.003     0.200
     7.052    96.261     0.200
     7.194    99.267     0.200
     7.213    99.728     0.200
     7.299    99.511     0.200
     7.510   104.758     0.200
     7.510   102.797     0.200
     7.710   104.421     0.200
     7.807   107.489     0.200
     8.193   113.484     0.200
     9.599   126.435     0.200
     9.599   126.318     0.200
     9.773   129.666     0.200
     0.453    12.696     0.200
     1.102    20.225     0.200
     1.248    23.114     0.200
     1.380    24.463     0.200
     2.550    40.211     0.200
     2.659    40.564     0.200
     2.659    39.191     0.200
     4.111    55.453     0.200
     4.202    56.187     0.200
     4.272    56.646     0.200
     4.336    58.527     0.200
     4.415    59.910     0.200
     4.504    60.270     0.200
     4.652    62.536     0.200
     4.750    62.901     0.200
     4.821    63.574     0.200
     4.821    63.394     0.200
     5.094    67.980     0.200
     5.582    74.182     0.200
     6.101    79.635     0.200
     1.152    25.709     0.200
     2.856    44.686     0.200
     3.297    55.716     0.200
     3.672    54.565     0.200
     3.736    55.812     0.200
     3.736    54.695     0.200
     3.781    55.434     0.200
     3.781    55.004     0.200
     3.821    54.790     0.200
     3.984    59.716     0.200
     4.035    59.724     0.200
     4.054    60.600     0.200
     4.071    59.259     0.200
     4.071    59.611     0.200
     4.118    66.387     0.200
     4.282    61.644     0.200
     4.282    61.191     0.200
     4.265    61.652     0.200
     4.265    61.175     0.200
     4.305    63.472     0.200
     4.660    67.124     0.200
     4.842    67.476     0.200
     4.842    66.999     0.200
     4.861    69.880     0.200
     4.861    69.177     0.200
     5.064    71.818     0.200
     5.562    78.500     0.200
     5.978    83.652     0.200
     1.142    27.131     0.200
     2.862    49.728     0.200
     3.076    47.214     0.200
     3.076    47.792     0.200
     3.226    49.868     0.200
     3.300    52.351     0.200
     4.378    64.734     0.200
     4.409    65.349     0.200
     4.409    65.857     0.200
     4.501    65.533     0.200
     4.664    67.753     0.200
     4.679    66.383     0.200
     4.682    66.042     0.200
     4.997    71.664     0.200
     5.022    71.378     0.200
     5.133    72.781     0.200
     5.137    73.329     0.200
     5.273    74.055     0.200
     5.341    75.755     0.200
     5.498    76.898     0.200
     1.535    30.589     0.200
     1.969    36.123     0.200
     2.552    44.757     0.200
     3.067    52.703     0.200
     3.184    53.951     0.200
     3.480    58.836     0.200
     3.654    58.970     0.200
     4.731    73.955     0.200
     5.402    77.677     0.200
     5.459    76.707     0.200
     5.512    80.525     0.200
     5.559    81.234     0.200
     5.637    80.335     0.200
     5.714    81.231     0.200
     5.873    83.570     0.200
     5.958    84.883     0.200
     5.973    85.011     0.200
     6.538    93.021     0.200
     6.533    90.528     0.200
     6.753    94.711     0.200
     7.098    99.178     0.200
     7.229    98.640     0.200
     7.254   100.160     0.200
     7.722   104.835     0.200
     1.148    29.650     0.200
     1.391    30.818     0.200
     1.391    31.615     0.200
     1.429    31.153     0.200
     1.726    33.797     0.200
     1.863    35.857     0.200
     2.305    42.438     0.200
     2.670    46.837     0.200
     3.586    58.573     0.200
     4.482    65.792     0.200
     5.061    74.012     0.200
     5.169    75.157     0.200
     5.169    74.095     0.200
     5.252    75.561     0.200
     5.252    74.276     0.200
     5.320    78.096     0.200
     5.320    75.729     0.200
     5.458    79.585     0.200
     5.562    81.667     0.200
     5.699    82.472     0.200
     5.713    80.694     0.200
     5.713    79.718     0.200
     5.823    82.521     0.200
     5.823    82.009     0.200
     5.916    83.165     0.200
     6.396    90.153     0.200
     6.573    92.567     0.200
     7.101    99.516     0.200
     7.298   100.546     0.200
     1.056    25.111     0.200
     1.084    26.361     0.200
     1.304    28.286     0.200
     1.770    32.510     0.200
     2.438    42.692     0.200
     2.433    43.163     0.200
     3.212    51.320     0.200
     3.273    52.761     0.200
     3.439    56.526     0.200
     3.559    54.794     0.200
     3.780    55.778     0.200
     3.780    56.012     0.200
     3.830    56.791     0.200
     3.830    56.669     0.200
     3.861    56.912     0.200
     3.861    55.845     0.200
     3.856    58.013     0.200
     3.898    62.013     0.200
     4.040    58.390     0.200
     4.040    59.898     0.200
     4.129    62.603     0.200
     4.155    61.596     0.200
     4.168    62.544     0.200
     4.282    67.394     0.200
     4.196    60.891     0.200
     4.196    60.769     0.200
     4.328    61.783     0.200
     4.328    61.674     0.200
     4.392    64.439     0.200
     4.407    65.356     0.200
     4.435    65.029     0.200
     4.879    68.470     0.200
     4.940    70.341     0.200
     5.122    74.321     0.200
     5.496    79.350     0.200
     5.605    80.174     0.200
     5.582    78.170     0.200
     6.045    85.753     0.200
     6.571    91.907     0.200
     1.660    32.231     0.200
     1.942    34.412     0.200
     2.676    43.804     0.200
     3.306    54.460     0.200
     3.306    55.726     0.200
     3.693    55.415     0.200
     3.757    56.366     0.200
     3.801    56.629     0.200
     4.057    61.770     0.200
     4.086    59.955     0.200
     4.076    60.451     0.200
     3.862    64.670     0.200
     4.278    63.767     0.200
     4.301    63.522     0.200
     4.326    64.326     0.200
     4.326    63.116     0.200
     4.113    65.234     0.200
     4.212    68.861     0.200
     4.861    69.581     0.200
     5.084    74.085     0.200
     5.582    78.974     0.200
     0.995    24.705     0.200
     1.282    28.594     0.200
     1.986    35.950     0.200
     2.811    47.930     0.200
     3.033    51.311     0.200
     3.070    50.725     0.200
     3.613    60.330     0.200
     3.749    59.876     0.200
     3.847    62.623     0.200
     4.215    62.139     0.200
     4.513    64.709     0.200
     4.527    65.602     0.200
     5.302    73.557     0.200
     5.808    80.108     0.200
     6.225    84.952     0.200
     1.511    25.049     0.200
     2.421    40.367     0.200
     2.430    36.398     0.200
     2.527    39.601     0.200
     3.221    46.388     0.200
     3.327    49.878     0.200
     4.207    56.580     0.200
     4.311    58.194     0.200
     4.253    59.302     0.200
     4.392    58.257     0.200
     4.392    58.109     0.200
     4.532    59.838     0.200
     4.603    61.448     0.200
     4.723    63.367     0.200
     4.845    62.602     0.200
     4.845    64.352     0.200
     4.889    65.191     0.200
     4.964    65.396     0.200
     4.964    64.451     0.200
     5.127    67.840     0.200
     5.152    69.075     0.200
     5.459    71.762     0.200
     5.537    71.776     0.200
     5.537    73.268     0.200
     5.954    77.159     0.200
     6.240    81.356     0.200
     6.500    84.619     0.200
     6.706    86.302     0.200
     4.128    57.066     0.200
     4.228    56.983     0.200
     4.305    58.957     0.200
     4.305    57.238     0.200
     4.326    58.529     0.200
     4.326    58.326     0.200
     4.437    59.277     0.200
     4.412    59.238     0.200
     4.412    60.089     0.200
     4.523    61.496     0.200
     4.652    64.527     0.200
     4.766    63.755     0.200
     4.766    64.494     0.200
     4.784    63.699     0.200
     4.871    65.402     0.200
     5.019    68.388     0.200
     5.019    67.646     0.200
     5.444    72.075     0.200
     5.444    72.509     0.200
     5.624    75.600     0.200
     5.624    75.022     0.200
     5.845    77.793     0.200
     5.936    79.896     0.200
     6.149    81.670     0.200
     6.393    83.741     0.200
     6.566    88.119     0.200
     1.046    21.670     0.200
     2.482    37.492     0.200
     2.585    42.519     0.200
     2.770    45.026     0.200
     3.264    50.102     0.200
     3.223    48.731     0.200
     3.602    55.634     0.200
     4.150    58.088     0.200
     4.253    58.698     0.200
     4.253    57.432     0.200
     4.209    59.565     0.200
     4.336    60.036     0.200
     4.336    58.841     0.200
     4.334    59.326     0.200
     4.426    60.872     0.200
     4.545    62.347     0.200
     4.545    62.511     0.200
     4.667    63.930     0.200
     4.788    64.070     0.200
     4.788    65.570     0.200
     4.833    66.229     0.200
     4.884    66.892     0.200
     4.905    65.903     0.200
     4.905    64.778     0.200
     5.074    68.472     0.200
     5.401    73.353     0.200
     5.479    72.236     0.200
     5.962    79.674     0.200
     6.182    82.379     0.200
     6.599    88.445     0.200
     1.651    32.653     0.200
     1.828    34.453     0.200
     2.018    36.935     0.200
     2.492    44.377     0.200
     2.492    44.256     0.200
     2.762    48.551     0.200
     2.683    46.232     0.200
     4.925    70.602     0.200
     5.046    70.817     0.200
     5.080    72.912     0.200
     5.195    75.289     0.200
     5.266    73.209     0.200
     5.266    74.166     0.200
     5.311    75.490     0.200
     5.391    77.805     0.200
     5.496    79.619     0.200
     5.545    77.383     0.200
     5.561    78.969     0.200
     6.102    84.781     0.200
     6.330    89.189     0.200
     6.686    93.446     0.200
     6.825    95.475     0.200
     7.240    99.083     0.200
     1.988    35.724     0.200
     2.380    41.195     0.200
     2.511    41.551     0.200
     2.401    42.713     0.200
     2.486    39.483     0.200
     2.486    39.778     0.200
     2.576    43.147     0.200
     2.755    47.185     0.200
     3.216    50.740     0.200
     3.295    50.920     0.200
     3.274    50.306     0.200
     3.362    54.253     0.200
     4.160    59.351     0.200
     4.199    60.885     0.200
     4.199    61.276     0.200
     4.341    61.206     0.200
     4.341    61.909     0.200
     4.350    61.154     0.200
     4.439    62.678     0.200
     4.479    64.868     0.200
     4.555    64.077     0.200
     4.555    63.938     0.200
     4.679    66.571     0.200
     4.798    67.462     0.200
     4.833    66.473     0.200
     4.833    68.137     0.200
     4.892    68.194     0.200
     4.911    67.895     0.200
     5.071    70.524     0.200
     5.071    71.034     0.200
     5.096    74.528     0.200
     5.225    75.123     0.200
     5.410    74.635     0.200
     5.485    75.394     0.200
     5.485    75.146     0.200
     5.898    82.331     0.200
     5.971    82.578     0.200
     6.188    84.061     0.200
     6.444    87.275     0.200
     6.605    89.147     0.200
     6.974    94.189     0.200
     7.165    95.179     0.200
     7.543   100.322     0.200
     7.882   104.862     0.200
     8.156   108.360     0.200
     8.253   110.954     0.200
     0.294    11.617     0.200
     1.334    23.499     0.200
     1.409    25.864     0.200
     1.534    24.116     0.200
     1.960    33.557     0.200
     2.366    37.873     0.200
     2.552    40.939     0.200
     2.445    37.349     0.200
     2.445    35.732     0.200
     2.759    40.926     0.200
     2.806    45.075     0.200
     3.270    48.532     0.200
     3.195    46.129     0.200
     3.344    48.840     0.200
     3.413    53.255     0.200
     3.626    49.730     0.200
     3.626    52.261     0.200
     3.633    55.695     0.200
     3.841    53.425     0.200
     4.175    56.058     0.200
     4.246    57.661     0.200
     4.246    58.301     0.200
     4.265    58.670     0.200
     4.265    62.021     0.200
     4.357    58.601     0.200
     4.357    59.258     0.200
     4.361    58.297     0.200
     4.361    58.867     0.200
     4.448    59.116     0.200
     4.448    60.046     0.200
     4.505    59.327     0.200
     4.505    59.640     0.200
     4.571    61.337     0.200
     4.571    61.142     0.200
     4.611    63.262     0.200
     4.618    63.662     0.200
     4.689    64.014     0.200
     4.813    63.261     0.200
     4.813    64.065     0.200
     4.868    64.537     0.200
     4.868    64.189     0.200
     4.910    65.593     0.200
     4.936    64.433     0.200
     4.936    64.769     0.200
     5.110    66.767     0.200
     5.110    67.400     0.200
     5.141    71.241     0.200
     5.272    72.667     0.200
     5.428    71.866     0.200
     5.510    72.910     0.200
     5.510    72.230     0.200
     5.683    75.303     0.200
     5.683    75.077     0.200
     5.940    77.988     0.200
     5.989    79.672     0.200
     6.153    81.384     0.200
     6.212    80.656     0.200
     6.483    85.075     0.200
     6.629    85.598     0.200
     6.690    86.659     0.200
     6.691    86.446     0.200
     6.796    88.798     0.200
     6.993    92.060     0.200
     7.542    97.838     0.200
     7.580    97.114     0.200
     7.909   102.957     0.200
     8.074   105.265     0.200
     8.179   105.112     0.200
     8.296   107.575     0.200
     8.821   113.782     0.200
     1.828    31.712     0.200
     2.099    37.110     0.200
     3.064    47.082     0.200
     3.875    63.285     0.200
     4.177    58.765     0.200
     4.231    61.080     0.200
     4.219    59.652     0.200
     4.243    59.327     0.200
     4.241    59.328     0.200
     4.636    63.761     0.200
     4.632    66.033     0.200
     4.650    66.344     0.200
     4.829    68.620     0.200
     4.863    67.966     0.200
     4.942    70.404     0.200
     5.161    70.820     0.200
     5.446    74.692     0.200
     5.894    81.317     0.200
     2.395    40.060     0.200
     2.909    49.264     0.200
     3.145    48.425     0.200
     3.212    51.897     0.200
     3.656    53.521     0.200
     3.756    60.877     0.200
     4.151    60.235     0.200
     4.261    61.161     0.200
     4.311    62.609     0.200
     4.350    62.747     0.200
     4.350    61.326     0.200
     4.326    61.219     0.200
     4.334    63.878     0.200
     4.408    63.127     0.200
     4.513    63.047     0.200
     4.547    64.746     0.200
     4.650    66.010     0.200
     4.787    68.435     0.200
     4.903    68.230     0.200
     4.903    66.090     0.200
     4.936    68.597     0.200
     4.936    69.894     0.200
     5.161    71.707     0.200
     5.161    71.113     0.200
     5.512    76.411     0.200
     5.512    74.146     0.200
     5.675    78.595     0.200
     5.919    76.176     0.200
     5.971    82.556     0.200
     5.998    81.034     0.200
     6.209    84.497     0.200
     6.477    88.324     0.200
     6.528    87.125     0.200
     6.740    88.834     0.200
     6.741    89.372     0.200
     6.815    90.637     0.200
     2.863    47.165     0.200
     3.896    55.091     0.200
     4.032    57.586     0.200
     4.105    58.702     0.200
     4.165    60.840     0.200
     4.230    62.819     0.200
     4.285    62.769     0.200
     4.387    61.916     0.200
     4.557    65.229     0.200
     4.592    63.806     0.200
     5.404    74.052     0.200
     2.279    41.223     0.200
     2.461    42.848     0.200
     2.554    45.696     0.200
     2.985    48.526     0.200
     2.998    50.729     0.200
     3.213    48.584     0.200
     3.260    53.405     0.200
     3.663    60.562     0.200
     4.574    68.386     0.200
     4.956    69.583     0.200
     5.039    71.177     0.200
     5.159    73.424     0.200
     5.197    74.190     0.200
     5.273    72.866     0.200
     5.273    74.186     0.200
     5.384    74.853     0.200
     5.346    75.576     0.200
     5.532    78.750     0.200
     5.509    77.400     0.200
     5.594    78.209     0.200
     5.617    78.256     0.200
     6.179    85.562     0.200
     6.297    87.618     0.200
     6.394    88.424     0.200
     6.497    94.946     0.200
     6.736    93.342     0.200
     6.919    93.469     0.200
     6.898    94.060     0.200
     6.959    95.817     0.200
     7.096    96.427     0.200
     7.223    98.270     0.200
     7.314    98.707     0.200
     7.870   106.504     0.200
     8.239   110.050     0.200
     8.551   115.285     0.200
     8.591   114.232     0.200
     8.862   118.523     0.200
     9.293   122.775     0.200
     1.116    26.779     0.200
     1.905    37.120     0.200
     2.281    41.615     0.200
     2.457    43.824     0.200
     2.569    46.040     0.200
     2.854    51.196     0.200
     2.989    50.102     0.200
     3.258    54.372     0.200
     3.301    57.209     0.200
     3.368    57.815     0.200
     3.680    61.645     0.200
     4.170    63.650     0.200
     4.435    68.358     0.200
     4.456    67.376     0.200
     4.563    69.057     0.200
     4.936    71.488     0.200
     5.018    71.984     0.200
     5.077    72.015     0.200
     5.141    75.052     0.200
     5.175    75.169     0.200
     5.251    75.044     0.200
     5.251    75.255     0.200
     5.326    76.761     0.200
     5.369    76.175     0.200
     5.405    80.192     0.200
     5.488    78.531     0.200
     5.488    83.021     0.200
     5.518    78.243     0.200
     5.573    78.567     0.200
     5.573    79.012     0.200
     5.598    78.904     0.200
     5.642    80.436     0.200
     6.156    86.025     0.200
     6.161    86.137     0.200
     6.285    88.796     0.200
     6.375    89.375     0.200
     6.716    93.957     0.200
     6.880    95.169     0.200
     6.906    94.275     0.200
     6.938    97.366     0.200
     7.083    98.240     0.200
     7.083    97.084     0.200
     7.084    98.365     0.200
     7.203    99.272     0.200
     7.289   102.296     0.200
     7.295    99.870     0.200
     7.365   100.436     0.200
     7.852   106.181     0.200
     8.012   107.877     0.200
     8.263   111.857     0.200
     8.379   113.884     0.200
     8.533   117.773     0.200
     8.581   118.420     0.200
     8.843   120.098     0.200
     9.276   125.296     0.200
     9.368   125.259     0.200
     1.184    24.634     0.200
     2.018    34.368     0.200
     2.242    36.153     0.200
     2.657    43.815     0.200
     2.838    46.745     0.200
     2.910    46.759     0.200
     2.986    47.004     0.200
     3.671    52.055     0.200
     3.916    54.170     0.200
     3.993    56.943     0.200
     4.048    55.975     0.200
     4.048    55.665     0.200
     4.117    56.745     0.200
     4.117    58.767     0.200
     4.188    58.967     0.200
     4.188    58.600     0.200
     4.252    58.094     0.200
     4.252    60.975     0.200
     4.304    60.488     0.200
     4.304    60.982     0.200
     4.392    61.305     0.200
     4.392    62.006     0.200
     4.485    64.324     0.200
     4.571    63.308     0.200
     4.571    62.718     0.200
     4.592    63.267     0.200
     4.592    64.748     0.200
     5.135    69.993     0.200
     5.135    70.915     0.200
     5.345    71.342     0.200
     5.401    72.496     0.200
     5.688    77.052     0.200
     5.852    77.944     0.200
     6.174    82.900     0.200
     6.268    84.167     0.200
     1.211    28.163     0.200
     2.271    41.297     0.200
     2.456    43.677     0.200
     2.539    45.353     0.200
     3.255    52.817     0.200
     3.655    58.998     0.200
     4.972    71.217     0.200
     5.054    71.717     0.200
     5.095    77.367     0.200
     5.113    71.804     0.200
     5.175    74.159     0.200
     5.212    75.303     0.200
     5.289    74.466     0.200
     5.289    75.376     0.200
     5.362    76.214     0.200
     5.399    75.286     0.200
     5.525    79.090     0.200
     5.546    78.525     0.200
     5.610    77.984     0.200
     5.610    79.601     0.200
     5.633    79.337     0.200
     6.195    85.656     0.200
     6.310    89.530     0.200
     6.410    89.423     0.200
     6.752    93.714     0.200
     6.914    95.614     0.200
     7.397    99.975     0.200
     0.578    14.814     0.200
     2.619    42.401     0.200
     3.397    47.112     0.200
     3.397    47.549     0.200
     3.455    48.083     0.200
     3.495    48.415     0.200
     3.495    47.634     0.200
     3.528    47.160     0.200
     3.569    52.501     0.200
     3.776    51.587     0.200
     3.776    52.110     0.200
     3.785    51.051     0.200
     3.990    54.347     0.200
     3.999    56.214     0.200
     3.994    53.702     0.200
     4.028    56.522     0.200
     4.549    60.000     0.200
     4.814    63.885     0.200
     0.552    14.859     0.200
     0.979    19.464     0.200
     2.139    34.225     0.200
     2.652    43.244     0.200
     3.390    46.637     0.200
     3.390    47.094     0.200
     3.446    47.912     0.200
     3.483    49.252     0.200
     3.508    51.696     0.200
     3.564    54.550     0.200
     3.535    55.574     0.200
     3.755    51.569     0.200
     3.755    53.636     0.200
     3.972    53.668     0.200
     3.959    54.217     0.200
     3.959    55.241     0.200
     4.020    55.214     0.200
     4.196    64.181     0.200
     4.380    65.026     0.200
     4.529    61.118     0.200
     4.529    62.122     0.200
     4.777    65.343     0.200
     5.121    69.660     0.200
     5.339    71.523     0.200
     1.178    26.473     0.200
     2.594    45.931     0.200
     2.645    46.603     0.200
     2.778    47.233     0.200
     2.776    48.475     0.200
     2.862    47.796     0.200
     2.864    48.548     0.200
     3.105    50.021     0.200
     3.404    52.000     0.200
     3.445    53.047     0.200
     4.259    65.208     0.200
     4.445    67.358     0.200
     4.445    64.086     0.200
     4.474    65.718     0.200
     4.612    70.936     0.200
     4.921    71.245     0.200
     5.232    75.440     0.200
     5.248    75.870     0.200
     5.393    79.362     0.200
     5.512    78.313     0.200
     5.512    75.856     0.200
     5.529    78.292     0.200
     5.529    79.267     0.200
     5.526    79.090     0.200
     5.526    77.799     0.200
     5.537    79.677     0.200
     5.537    79.253     0.200
     5.569    77.400     0.200
     5.585    78.665     0.200
     5.603    79.330     0.200
     5.884    82.018     0.200
     5.884    83.579     0.200
     5.899    82.252     0.200
     5.899    83.529     0.200
     5.925    82.863     0.200
     6.000    85.109     0.200
     6.000    84.580     0.200
     6.148    85.914     0.200
     6.151    87.434     0.200
     6.162    87.666     0.200
     6.192    88.995     0.200
     6.383    95.211     0.200
     6.528    88.951     0.200
     6.528    89.347     0.200
     6.658    91.368     0.200
     6.658    92.116     0.200
     6.783    95.744     0.200
     6.807    93.481     0.200
     6.807    93.945     0.200
     6.906    95.930     0.200
     7.037    98.624     0.200
     7.037    97.307     0.200
     7.038    99.662     0.200
     7.209    99.032     0.200
     7.286   103.110     0.200
     7.542   104.147     0.200
     7.542   104.549     0.200
     7.575   102.826     0.200
     7.659   104.405     0.200
     7.668   102.669     0.200
     7.812   106.393     0.200
     7.815   107.440     0.200
     8.209   111.106     0.200
     8.599   116.030     0.200
     8.816   118.566     0.200
     9.077   121.136     0.200
     9.189   121.389     0.200
     9.382   124.844     0.200
     9.514   128.875     0.200
     9.514   125.015     0.200
     9.565   126.200     0.200
     9.596   126.166     0.200
     9.721   127.862     0.200
    10.212   135.116     0.200
    10.606   138.047     0.200
    10.697   143.132     0.200
    10.711   142.989     0.200
    10.799   140.833     0.200
    10.945   149.440     0.200
    10.972   144.688     0.200
     1.122    26.767     0.200
     2.547    45.519     0.200
     2.784    47.046     0.200
     3.106    51.882     0.200
     3.419    56.074     0.200
     4.248    61.181     0.200
     4.432    66.624     0.200
     5.516    78.334     0.200
     5.500    76.926     0.200
     5.556    77.247     0.200
     5.525    78.426     0.200
     5.872    84.434     0.200
     5.886    83.606     0.200
     5.912    84.850     0.200
     5.987    83.749     0.200
     6.135    86.263     0.200
     6.138    84.642     0.200
     6.138    86.931     0.200
     6.149    87.176     0.200
     6.180    85.587     0.200
     6.515    87.619     0.200
     6.645    91.995     0.200
     6.770    93.882     0.200
     6.795    93.934     0.200
     7.196    99.634     0.200
     7.563   101.958     0.200
     7.646   103.914     0.200
     7.655   103.438     0.200
     8.803   119.433     0.200
     1.114    28.019     0.200
     2.646    46.222     0.200
     2.563    44.540     0.200
     2.754    46.425     0.200
     2.858    48.222     0.200
     3.404    58.099     0.200
     4.248    66.441     0.200
     4.426    67.083     0.200
     4.462    68.327     0.200
     4.633    71.926     0.200
     5.239    79.198     0.200
     5.493    77.102     0.200
     5.493    78.505     0.200
     5.506    77.759     0.200
     5.506    78.407     0.200
     5.510    78.098     0.200
     5.523    79.413     0.200
     5.523    81.167     0.200
     5.547    77.256     0.200
     5.563    76.251     0.200
     5.563    80.552     0.200
     5.861    81.863     0.200
     5.861    84.504     0.200
     5.877    81.965     0.200
     5.877    84.324     0.200
     5.902    84.993     0.200
     5.980    82.199     0.200
     5.980    84.324     0.200
     6.125    87.083     0.200
     6.129    84.083     0.200
     6.129    87.321     0.200
     6.141    86.756     0.200
     6.180    89.365     0.200
     6.509    89.862     0.200
     6.509    91.120     0.200
     6.637    90.884     0.200
     6.637    91.481     0.200
     6.761    95.387     0.200
     6.787    93.226     0.200
     6.787    94.081     0.200
     7.188    99.657     0.200
     7.559   105.154     0.200
     7.639   104.611     0.200
     7.649   103.152     0.200
     7.791   107.238     0.200
     8.798   117.760     0.200
     9.059   120.612     0.200
     9.497   128.756     0.200
     3.464    55.599     0.200
     4.032    63.098     0.200
     4.354    64.900     0.200
     4.502    65.755     0.200
     4.502    66.150     0.200
     4.562    69.415     0.200
     4.708    71.625     0.200
     4.747    72.105     0.200
     5.327    80.514     0.200
     5.347    81.689     0.200
     5.555    78.185     0.200
     5.555    79.392     0.200
     5.562    78.136     0.200
     5.562    78.808     0.200
     5.526    82.270     0.200
     5.600    76.829     0.200
     5.504    84.561     0.200
     5.621    78.924     0.200
     5.621    77.720     0.200
     5.596    78.880     0.200
     5.596    80.876     0.200
     5.537    83.733     0.200
     5.619    81.912     0.200
     5.619    80.576     0.200
     5.719    79.457     0.200
     5.897    84.573     0.200
     5.897    83.690     0.200
     5.928    83.188     0.200
     5.928    82.168     0.200
     5.942    81.275     0.200
     5.942    82.615     0.200
     5.856    85.323     0.200
     6.047    84.497     0.200
     6.047    83.915     0.200
     6.167    85.731     0.200
     6.180    84.858     0.200
     6.180    83.936     0.200
     6.197    86.477     0.200
     6.189    90.508     0.200
     6.282    90.838     0.200
     6.493    95.116     0.200
     6.580    90.943     0.200
     6.580    90.396     0.200
     6.696    91.878     0.200
     6.696    92.046     0.200
     6.817    93.482     0.200
     6.853    93.620     0.200
     6.853    93.495     0.200
     6.838   100.535     0.200
     6.980   100.773     0.200
     7.125    99.399     0.200
     7.194   104.665     0.200
     7.313   104.601     0.200
     7.569   104.533     0.200
     7.643   101.584     0.200
     7.703   103.711     0.200
     7.721   104.117     0.200
     7.849   106.161     0.200
     8.223   111.312     0.200
     8.264   111.023     0.200
     8.327   118.178     0.200
     8.396   119.128     0.200
     8.652   117.306     0.200
     8.625   113.043     0.200
     8.878   119.673     0.200
     9.134   120.458     0.200
     9.246   121.752     0.200
     9.187   128.732     0.200
     9.227   129.125     0.200
     9.448   126.043     0.200
     9.580   129.439     0.200
     9.580   125.013     0.200
     9.620   127.803     0.200
     9.777   128.824     0.200
    10.630   143.337     0.200
    10.998   144.970     0.200
     2.120    38.943     0.200
     4.224    65.120     0.200
     4.415    65.402     0.200
     5.484    77.288     0.200
     5.495    77.998     0.200
     5.495    79.139     0.200
     5.505    78.027     0.200
     5.505    79.541     0.200
     5.544    77.735     0.200
     5.559    79.490     0.200
     5.559    80.121     0.200
     5.863    84.928     0.200
     5.874    82.108     0.200
     5.874    83.959     0.200
     5.971    83.866     0.200
     5.971    84.444     0.200
     6.125    87.341     0.200
     6.126    86.335     0.200
     6.499    90.934     0.200
     6.499    90.784     0.200
     6.632    92.688     0.200
     6.779    93.187     0.200
     6.779    94.384     0.200
     7.632   105.040     0.200
     8.785   119.699     0.200
     1.089    26.360     0.200
     1.089    26.500     0.200
     2.215    38.963     0.200
     2.564    45.738     0.200
     3.074    52.243     0.200
     3.388    56.858     0.200
     5.526    77.431     0.200
     5.526    79.653     0.200
     5.567    77.581     0.200
     5.584    78.553     0.200
     5.897    83.886     0.200
     5.920    84.446     0.200
     6.002    83.669     0.200
     6.002    84.360     0.200
     6.149    86.771     0.200
     6.782    95.456     0.200
     6.809    95.361     0.200
     7.209   100.507     0.200
     7.661   105.295     0.200
     7.672   105.693     0.200
     1.088    25.905     0.200
     2.571    45.214     0.200
     2.752    47.850     0.200
     4.273    62.406     0.200
     5.264    77.401     0.200
     5.510    76.460     0.200
     5.510    77.655     0.200
     5.520    77.731     0.200
     5.520    78.977     0.200
     5.531    75.371     0.200
     5.546    78.681     0.200
     5.546    79.029     0.200
     5.561    78.443     0.200
     5.578    79.421     0.200
     5.578    77.308     0.200
     5.871    81.328     0.200
     5.891    81.360     0.200
     5.891    83.188     0.200
     5.913    84.213     0.200
     5.997    82.881     0.200
     5.997    83.736     0.200
     6.137    86.887     0.200
     6.143    86.625     0.200
     6.156    87.034     0.200
     6.527    89.837     0.200
     6.653    92.426     0.200
     6.653    92.535     0.200
     6.776    95.058     0.200
     6.804    94.688     0.200
     7.260    98.043     0.200
     7.656   104.082     0.200
     7.667   104.715     0.200
     7.806   107.514     0.200
     8.209   112.757     0.200
     8.818   117.795     0.200
     1.035    23.168     0.200
     1.104    23.932     0.200
     1.168    24.310     0.200
     1.252    26.628     0.200
     1.831    30.488     0.200
     1.831    30.879     0.200
     2.252    39.442     0.200
     2.170    36.972     0.200
     2.748    41.426     0.200
     2.748    43.048     0.200
     2.724    44.280     0.200
     3.149    46.692     0.200
     2.993    47.751     0.200
     3.264    51.141     0.200
     3.309    48.896     0.200
     3.309    48.388     0.200
     3.212    51.374     0.200
     3.573    54.188     0.200
     3.649    53.962     0.200
     3.651    54.051     0.200
     3.779    54.669     0.200
     3.779    54.810     0.200
     4.266    63.184     0.200
     4.280    65.606     0.200
     4.670    64.972     0.200
     4.702    65.922     0.200
     4.743    67.929     0.200
     4.743    66.234     0.200
     4.882    67.847     0.200
     4.882    67.074     0.200
     5.066    68.886     0.200
     5.066    69.773     0.200
     5.089    71.123     0.200
     5.091    69.862     0.200
     5.091    70.479     0.200
     5.381    73.883     0.200
     5.381    74.473     0.200
     5.430    74.891     0.200
     5.430    76.118     0.200
     5.554    76.614     0.200
     5.551    76.645     0.200
     5.551    76.778     0.200
     5.639    78.202     0.200
     5.756    78.893     0.200
     5.871    80.607     0.200
     6.011    83.270     0.200
     6.196    85.369     0.200
     6.196    84.330     0.200
     6.264    85.557     0.200
     6.601    89.407     0.200
     6.639    89.357     0.200
     6.791    93.664     0.200
     6.996    92.205     0.200
     7.052    94.299     0.200
     7.066    95.957     0.200
     7.259    98.437     0.200
     7.518   103.796     0.200
     7.572   100.209     0.200
     7.920   105.983     0.200
     8.066   107.434     0.200
     8.480   112.332     0.200
     9.166   122.269     0.200
     1.118    26.437     0.200
     1.485    29.759     0.200
     2.241    39.308     0.200
     3.818    58.891     0.200
     3.818    59.419     0.200
     3.822    59.002     0.200
     3.822    58.608     0.200
     3.901    57.293     0.200
     3.901    59.345     0.200
     4.100    60.084     0.200
     4.106    58.983     0.200
     4.106    60.787     0.200
     4.398    63.820     0.200
     4.398    64.832     0.200
     4.442    64.869     0.200
     4.442    65.040     0.200
     4.648    67.943     0.200
     4.691    68.420     0.200
     4.897    69.699     0.200
     4.897    70.621     0.200
     5.273    76.139     0.200
     5.630    80.017     0.200
     5.651    81.127     0.200
     6.028    84.655     0.200
     6.069    85.746     0.200
     1.203    26.756     0.200
     2.078    36.881     0.200
     2.148    37.971     0.200
     2.954    49.789     0.200
     3.530    52.908     0.200
     3.636    52.985     0.200
     3.636    53.442     0.200
     3.400    54.717     0.200
     4.309    61.824     0.200
     1.111    25.375     0.200
     1.946    35.216     0.200
     2.026    35.520     0.200
     4.234    67.202     0.200
     1.069    27.462     0.200
     1.019    27.712     0.200
     1.427    31.779     0.200
     2.254    40.595     0.200
     2.935    48.200     0.200
     2.955    48.504     0.200
     3.449    53.707     0.200
     3.549    54.006     0.200
     3.781    58.066     0.200
     3.844    58.799     0.200
     4.087    62.186     0.200
     4.206    62.336     0.200
     4.206    63.328     0.200
     4.186    62.350     0.200
     4.186    62.148     0.200
     4.469    67.927     0.200
     4.469    65.829     0.200
     4.697    68.401     0.200
     4.765    69.759     0.200
     4.782    70.725     0.200
     4.782    68.776     0.200
     5.325    76.214     0.200
     5.481    80.050     0.200
     5.714    79.968     0.200
     1.475    32.463     0.200
     1.846    36.734     0.200
     2.255    41.813     0.200
     2.329    43.856     0.200
     2.998    48.098     0.200
     5.002    72.804     0.200
     5.085    74.342     0.200
     5.663    80.869     0.200
     1.147    27.497     0.200
     1.147    27.067     0.200
     1.279    28.261     0.200
     1.568    30.389     0.200
     1.667    32.169     0.200
     1.814    33.354     0.200
     2.176    39.392     0.200
     2.626    43.860     0.200
     2.626    44.797     0.200
     2.657    45.551     0.200
     2.840    47.196     0.200
     3.500    57.606     0.200
     3.933    59.159     0.200
     4.137    61.192     0.200
     4.137    61.512     0.200
     4.169    61.758     0.200
     4.795    68.081     0.200
     4.864    69.749     0.200
     4.933    70.138     0.200
     5.078    73.127     0.200
     5.111    71.043     0.200
     5.111    71.848     0.200
     5.141    72.816     0.200
     5.180    72.223     0.200
     5.180    73.676     0.200
     5.166    74.141     0.200
     5.234    73.825     0.200
     5.373    75.465     0.200
     5.401    75.991     0.200
     5.401    76.624     0.200
     5.430    77.242     0.200
     5.479    78.086     0.200
     5.955    82.703     0.200
     5.989    83.736     0.200
     5.984    83.334     0.200
     6.088    85.909     0.200
     6.188    85.816     0.200
     6.188    86.253     0.200
     6.548    91.283     0.200
     6.622    90.323     0.200
     6.668    90.855     0.200
     6.680    92.825     0.200
     7.026    96.284     0.200
     7.095    96.980     0.200
     7.124    96.633     0.200
     1.117    26.555     0.200
     2.188    38.768     0.200
     2.575    43.683     0.200
     2.564    44.009     0.200
     2.644    46.693     0.200
     2.781    48.445     0.200
     3.178    54.017     0.200
     3.935    63.082     0.200
     4.113    62.207     0.200
     4.147    64.149     0.200
     4.154    67.563     0.200
     4.423    66.154     0.200
     4.557    70.461     0.200
     4.898    72.075     0.200
     5.417    83.408     0.200
     5.490    77.676     0.200
     5.490    77.348     0.200
     5.504    77.240     0.200
     5.504    77.576     0.200
     5.507    78.209     0.200
     5.520    79.985     0.200
     5.544    77.503     0.200
     5.561    78.476     0.200
     5.599    80.123     0.200
     5.858    82.041     0.200
     5.858    81.940     0.200
     5.874    82.005     0.200
     5.899    82.039     0.200
     5.899    82.656     0.200
     5.977    84.093     0.200
     6.122    85.399     0.200
     6.126    84.498     0.200
     6.126    85.771     0.200
     6.138    84.996     0.200
     6.506    90.639     0.200
     6.634    91.742     0.200
     6.758    93.935     0.200
     6.784    93.280     0.200
     6.784    94.577     0.200
     7.021    98.562     0.200
     7.185    99.254     0.200
     7.239    98.563     0.200
     7.261   100.975     0.200
     7.516   104.392     0.200
     7.636   104.020     0.200
     7.646   103.121     0.200
     7.788   105.514     0.200
     8.156   110.948     0.200
     8.187   110.446     0.200
     8.577   114.691     0.200
     8.795   117.914     0.200
     9.056   120.819     0.200
     9.168   123.146     0.200
     9.172   122.248     0.200
     9.362   124.250     0.200
     9.494   124.793     0.200
     9.543   127.120     0.200
     9.844   130.741     0.200
    10.189   135.193     0.200
    10.674   142.241     0.200
    10.688   141.752     0.200
    10.922   147.346     0.200
    11.659   158.935     0.200
    20.148   271.416     0.200
     2.271    39.642     0.200
     2.549    40.335     0.200
     2.932    47.661     0.200
     2.947    47.826     0.200
     4.306    66.173     0.200
     4.306    65.892     0.200
     4.456    65.023     0.200
     4.456    67.554     0.200
     4.514    67.840     0.200
     4.663    67.441     0.200
     4.703    69.763     0.200
     5.514    76.865     0.200
     5.517    77.611     0.200
     5.517    79.580     0.200
     5.549    77.404     0.200
     5.558    77.970     0.200
     5.571    78.963     0.200
     5.571    80.900     0.200
     5.578    76.638     0.200
     5.578    78.239     0.200
     5.859    81.964     0.200
     5.859    83.956     0.200
     5.887    82.457     0.200
     5.904    84.683     0.200
     6.003    83.031     0.200
     6.003    83.679     0.200
     6.128    86.690     0.200
     6.139    83.647     0.200
     6.139    86.303     0.200
     6.155    86.623     0.200
     6.535    88.284     0.200
     6.535    91.487     0.200
     6.653    90.807     0.200
     6.653    92.432     0.200
     6.775    93.910     0.200
     6.809    92.509     0.200
     6.809    94.399     0.200
     7.077    95.089     0.200
     7.090    98.300     0.200
     7.205    99.008     0.200
     7.267   100.603     0.200
     7.528   102.380     0.200
     7.528   104.239     0.200
     7.596   103.376     0.200
     7.676   105.236     0.200
     7.806   106.150     0.200
     7.896   111.015     0.200
     8.179   111.670     0.200
     8.218   112.154     0.200
     8.832   118.377     0.200
     9.088   121.548     0.200
     9.200   122.440     0.200
     9.534   129.702     0.200
     2.079    36.829     0.200
     2.291    39.026     0.200
     2.983    50.369     0.200
     4.307    63.675     0.200
     4.442    67.025     0.200
     5.502    78.794     0.200
     5.502    76.832     0.200
     5.492    78.477     0.200
     5.492    79.558     0.200
     5.540    77.640     0.200
     5.540    77.103     0.200
     5.537    79.473     0.200
     5.566    79.232     0.200
     5.558    78.842     0.200
     5.558    77.079     0.200
     5.834    84.707     0.200
     5.865    82.357     0.200
     5.865    83.625     0.200
     5.879    84.971     0.200
     5.986    83.924     0.200
     5.986    84.142     0.200
     6.104    87.478     0.200
     6.118    86.653     0.200
     6.520    90.338     0.200
     6.520    89.049     0.200
     6.634    91.980     0.200
     6.634    92.633     0.200
     6.754    95.052     0.200
     6.792    93.097     0.200
     7.081    95.847     0.200
     7.187    99.517     0.200
     7.252   100.554     0.200
     7.642   105.073     0.200
     3.475    49.515     0.200
     3.475    50.757     0.200
     3.528    51.450     0.200
     3.563    51.107     0.200
     3.579    51.331     0.200
     3.576    54.818     0.200
     3.809    53.251     0.200
     3.820    55.972     0.200
     3.852    54.394     0.200
     3.852    55.886     0.200
     3.860    54.558     0.200
     3.860    55.683     0.200
     4.001    57.486     0.200
     4.001    57.298     0.200
     4.045    57.098     0.200
     4.045    57.395     0.200
     4.083    58.800     0.200
     4.103    57.208     0.200
     4.103    59.505     0.200
     4.137    59.522     0.200
     4.643    65.572     0.200
     4.643    65.798     0.200
     4.750    66.768     0.200
     4.811    67.592     0.200
     4.834    67.271     0.200
     4.834    67.435     0.200
     5.201    72.512     0.200
     5.325    74.031     0.200
     5.673    77.778     0.200
     5.740    77.708     0.200
     5.795    78.545     0.200
     6.965    94.393     0.200
     7.175    96.640     0.200
     7.284    98.069     0.200
     7.946   106.791     0.200
     1.378    30.056     0.200
     2.278    41.862     0.200
     3.500    57.638     0.200
     5.271    76.132     0.200
     5.352    76.496     0.200
     5.588    83.248     0.200
     5.661    80.304     0.200
     5.909    85.041     0.200
     5.924    84.226     0.200
     7.049    97.558     0.200
     0.930    22.257     0.200
     3.103    47.815     0.200
     3.463    51.333     0.200
     3.517    52.122     0.200
     3.517    53.272     0.200
     3.552    52.843     0.200
     3.569    52.494     0.200
     3.808    56.073     0.200
     3.802    55.108     0.200
     3.840    55.949     0.200
     3.995    58.143     0.200
     4.035    58.076     0.200
     4.092    59.614     0.200
     4.739    68.252     0.200
     4.806    68.479     0.200
     5.190    73.930     0.200
     5.315    74.980     0.200
     5.356    74.750     0.200
     5.376    74.201     0.200
     5.663    78.592     0.200
     1.303    29.309     0.200
     2.112    38.050     0.200
     2.849    47.222     0.200
     2.809    47.866     0.200
     3.232    49.678     0.200
     3.399    51.327     0.200
     3.478    53.520     0.200
     3.586    54.165     0.200
     3.615    55.136     0.200
     3.734    56.521     0.200
     4.428    63.762     0.200
     4.428    64.496     0.200
     4.443    64.233     0.200
     4.470    64.240     0.200
     4.490    63.578     0.200
     4.490    64.824     0.200
     4.505    65.804     0.200
     4.534    64.090     0.200
     4.534    65.633     0.200
     4.617    67.080     0.200
     4.617    66.483     0.200
     4.790    69.636     0.200
     4.790    69.089     0.200
     4.799    68.533     0.200
     4.799    67.888     0.200
     4.827    69.173     0.200
     4.925    69.569     0.200
     4.925    70.131     0.200
     5.048    71.718     0.200
     5.051    70.995     0.200
     5.345    75.653     0.200
     5.566    77.638     0.200
     5.566    77.232     0.200
     5.686    79.729     0.200
     5.727    80.767     0.200
     5.727    79.935     0.200
     6.003    82.670     0.200
     6.087    83.569     0.200
     6.118    85.520     0.200
     6.194    85.923     0.200
     6.568    89.558     0.200
     6.576    90.581     0.200
     6.605    90.903     0.200
     2.228    37.622     0.200
     2.632    41.650     0.200
     2.652    43.264     0.200
     3.157    47.883     0.200
     3.482    50.349     0.200
     3.539    50.883     0.200
     3.577    51.636     0.200
     3.577    51.019     0.200
     3.603    50.819     0.200
     3.603    50.385     0.200
     3.818    54.861     0.200
     3.846    53.705     0.200
     3.861    55.199     0.200
     3.860    53.820     0.200
     3.860    55.589     0.200
     4.044    57.171     0.200
     4.067    56.895     0.200
     4.067    57.333     0.200
     4.085    58.303     0.200
     4.112    58.684     0.200
     4.150    59.084     0.200
     4.180    61.143     0.200
     4.762    66.722     0.200
     4.853    68.141     0.200
     4.857    67.901     0.200
     5.216    72.464     0.200
     5.347    73.989     0.200
     5.424    72.496     0.200
     5.691    77.613     0.200
     6.317    86.223     0.200
     6.992    94.323     0.200
     2.166    36.692     0.200
     2.592    40.760     0.200
     2.857    44.847     0.200
     3.526    51.826     0.200
     3.572    52.450     0.200
     3.593    52.161     0.200
     3.593    53.954     0.200
     3.600    52.952     0.200
     3.600    52.030     0.200
     3.788    54.828     0.200
     3.891    57.224     0.200
     3.891    56.388     0.200
     3.899    56.949     0.200
     3.959    57.551     0.200
     3.959    57.297     0.200
     4.053    57.952     0.200
     4.064    57.812     0.200
     4.064    58.456     0.200
     4.145    59.761     0.200
     4.151    60.436     0.200
     4.175    60.198     0.200
     4.679    66.623     0.200
     4.758    67.860     0.200
     4.792    68.425     0.200
     5.234    73.127     0.200
     5.341    75.267     0.200
     5.344    73.114     0.200
     5.540    78.016     0.200
     5.701    79.291     0.200
     5.787    79.645     0.200
     6.162    85.623     0.200
     0.966    23.068     0.200
     2.573    42.454     0.200
     2.573    42.567     0.200
     2.695    43.575     0.200
     2.778    45.875     0.200
     2.867    46.478     0.200
     3.106    48.862     0.200
     3.106    47.817     0.200
     3.431    51.171     0.200
     3.431    51.558     0.200
     3.487    52.183     0.200
     3.469    53.715     0.200
     3.523    52.938     0.200
     3.523    52.536     0.200
     3.501    54.726     0.200
     3.546    52.249     0.200
     3.585    55.628     0.200
     3.774    56.402     0.200
     3.787    55.117     0.200
     3.809    56.414     0.200
     3.809    55.966     0.200
     3.814    56.192     0.200
     3.814    56.942     0.200
     3.986    58.188     0.200
     3.986    58.079     0.200
     4.010    58.188     0.200
     4.010    58.626     0.200
     4.038    59.836     0.200
     4.061    59.012     0.200
     4.061    59.602     0.200
     4.096    60.098     0.200
     4.128    63.222     0.200
     4.153    65.780     0.200
     4.162    66.406     0.200
     4.604    66.593     0.200
     4.709    67.816     0.200
     4.797    67.886     0.200
     4.797    69.869     0.200
     4.800    68.056     0.200
     5.161    73.669     0.200
     5.290    73.227     0.200
     5.366    73.624     0.200
     5.446    77.627     0.200
     5.446    78.705     0.200
     5.515    79.748     0.200
     5.515    79.851     0.200
     5.563    76.213     0.200
     5.635    78.608     0.200
     5.705    78.565     0.200
     5.750    80.471     0.200
     5.768    79.615     0.200
     6.150    86.248     0.200
     6.259    86.684     0.200
     6.332    86.875     0.200
     6.632    89.826     0.200
     6.934    95.364     0.200
     7.141    96.856     0.200
     7.151    98.002     0.200
     7.250    99.055     0.200
     7.540   102.306     0.200
     7.618   102.149     0.200
     7.777   103.725     0.200
     7.911   107.022     0.200
     0.835    20.738     0.200
     0.823    21.620     0.200
     1.151    24.650     0.200
     1.151    25.134     0.200
     2.360    40.143     0.200
     3.104    50.814     0.200
     4.469    66.048     0.200
     4.469    65.251     0.200
     4.726    68.076     0.200
     4.709    69.490     0.200
     4.709    68.553     0.200
     5.238    72.554     0.200
     5.238    73.613     0.200
     5.322    74.748     0.200
     5.382    74.705     0.200
     5.382    75.885     0.200
     5.445    75.956     0.200
     5.445    76.835     0.200
     5.469    75.817     0.200
     5.469    76.020     0.200
     5.548    77.936     0.200
     5.628    77.504     0.200
     5.628    78.571     0.200
     5.663    77.390     0.200
     5.663    77.491     0.200
     5.786    80.484     0.200
     5.801    80.178     0.200
     5.801    78.436     0.200
     5.876    81.474     0.200
     5.903    80.265     0.200
     5.903    81.429     0.200
     6.545    90.398     0.200
     6.557    91.047     0.200
     6.679    90.651     0.200
     6.679    91.757     0.200
     7.020    97.243     0.200
     7.184    98.058     0.200
     0.871    19.041     0.200
     1.700    30.323     0.200
     2.498    39.783     0.200
     3.489    51.418     0.200
     3.535    50.110     0.200
     3.556    50.247     0.200
     3.562    49.906     0.200
     3.562    51.469     0.200
     3.755    50.447     0.200
     3.755    51.852     0.200
     3.930    54.819     0.200
     3.930    54.392     0.200
     4.027    55.055     0.200
     4.027    55.276     0.200
     4.641    63.499     0.200
     1.148    25.403     0.200
     2.044    35.739     0.200
     2.884    46.134     0.200
     2.990    47.155     0.200
     2.956    48.517     0.200
     3.005    48.876     0.200
     3.005    47.677     0.200
     3.132    46.994     0.200
     3.274    48.261     0.200
     3.667    54.259     0.200
     3.667    53.106     0.200
     3.613    57.420     0.200
     3.854    54.515     0.200
     3.854    55.589     0.200
     3.933    55.553     0.200
     3.991    56.279     0.200
     4.069    58.385     0.200
     4.121    59.045     0.200
     4.121    59.283     0.200
     4.187    58.051     0.200
     4.187    60.808     0.200
     4.243    59.353     0.200
     4.243    60.373     0.200
     4.357    61.142     0.200
     4.357    61.865     0.200
     4.420    62.581     0.200
     4.492    64.001     0.200
     4.519    62.402     0.200
     4.519    64.356     0.200
     4.556    65.261     0.200
     4.567    64.092     0.200
     4.567    63.541     0.200
     5.070    70.273     0.200
     5.070    71.035     0.200
     5.085    70.208     0.200
     5.157    72.504     0.200
     5.291    74.221     0.200
     5.631    78.291     0.200
     5.801    79.883     0.200
     5.861    79.222     0.200
     5.946    79.305     0.200
     6.118    83.519     0.200
     6.145    81.496     0.200
     6.146    81.143     0.200
     6.204    85.713     0.200
     6.217    84.575     0.200
     6.322    86.074     0.200
     6.914    92.559     0.200
     7.140    95.489     0.200
     7.468    99.944     0.200
     7.659   103.932     0.200
     7.766   104.985     0.200
     0.904    23.542     0.200
     1.535    29.536     0.200
     1.720    32.664     0.200
     4.864    70.145     0.200
     4.879    69.944     0.200
     5.234    75.996     0.200
     5.931    83.994     0.200
     6.478    89.786     0.200
     1.410    25.425     0.200
     1.598    28.712     0.200
     1.988    33.838     0.200
     2.175    36.243     0.200
     2.255    36.576     0.200
     2.272    38.337     0.200
     2.272    38.936     0.200
     2.654    41.989     0.200
     2.777    45.536     0.200
     2.880    44.487     0.200
     2.862    47.459     0.200
     3.089    49.978     0.200
     3.145    50.425     0.200
     3.481    53.800     0.200
     3.716    52.461     0.200
     3.716    53.584     0.200
     3.551    57.321     0.200
     3.790    54.737     0.200
     3.790    53.944     0.200
     3.775    56.062     0.200
     3.775    54.952     0.200
     3.809    54.888     0.200
     3.810    54.799     0.200
     3.810    58.037     0.200
     3.863    56.468     0.200
     3.790    61.033     0.200
     3.889    61.663     0.200
     3.889    61.001     0.200
     3.940    61.346     0.200
     4.146    59.405     0.200
     4.146    59.095     0.200
     4.204    59.487     0.200
     4.204    59.280     0.200
     4.217    60.140     0.200
     4.217    59.603     0.200
     4.217    62.109     0.200
     4.230    58.234     0.200
     4.230    60.175     0.200
     4.387    62.267     0.200
     4.398    59.724     0.200
     4.398    61.644     0.200
     4.215    66.268     0.200
     4.439    62.979     0.200
     4.646    65.792     0.200
     4.606    66.008     0.200
     4.732    65.443     0.200
     4.732    65.328     0.200
     4.700    70.346     0.200
     4.876    67.390     0.200
     4.876    68.591     0.200
     4.763    70.924     0.200
     5.011    69.508     0.200
     5.013    70.037     0.200
     5.013    69.442     0.200
     5.250    71.486     0.200
     5.415    75.672     0.200
     5.415    75.424     0.200
     5.416    75.564     0.200
     5.465    76.169     0.200
     5.789    80.772     0.200
     5.789    80.371     0.200
     5.812    79.182     0.200
     5.873    80.090     0.200
     6.031    81.247     0.200
     6.386    87.074     0.200
     6.415    86.771     0.200
     6.803    91.868     0.200
     7.034    94.752     0.200
     7.285    97.303     0.200
     7.399    99.319     0.200
     7.397    98.571     0.200
     7.612   102.964     0.200
     7.745   104.255     0.200
     7.771   102.701     0.200
     8.072   106.281     0.200
    19.757   262.944     0.200
    21.528   280.006     0.200
     1.960    34.470     0.200
     2.231    36.558     0.200
     2.231    36.312     0.200
     2.640    42.368     0.200
     2.894    45.236     0.200
     2.852    47.038     0.200
     3.790    54.795     0.200
     3.790    55.366     0.200
     3.807    52.704     0.200
     3.807    54.837     0.200
     3.805    55.851     0.200
     3.805    55.351     0.200
     3.756    56.897     0.200
     3.756    55.928     0.200
     3.838    57.532     0.200
     3.838    56.751     0.200
     4.144    59.785     0.200
     4.144    60.011     0.200
     4.222    59.543     0.200
     4.233    60.994     0.200
     4.194    58.633     0.200
     4.194    59.613     0.200
     4.383    63.118     0.200
     4.396    62.912     0.200
     4.441    63.353     0.200
     4.644    66.350     0.200
     4.721    67.305     0.200
     4.870    68.779     0.200
     5.007    71.336     0.200
     5.004    70.008     0.200
     5.004    69.614     0.200
     5.415    75.055     0.200
     5.454    75.810     0.200
     5.858    81.024     0.200
     0.928    20.715     0.200
     1.414    25.153     0.200
     3.806    54.903     0.200
     3.824    54.245     0.200
     4.213    59.758     0.200
     0.806    19.852     0.200
     1.419    24.750     0.200
     1.958    31.557     0.200
     2.139    34.776     0.200
     2.255    37.346     0.200
     2.255    34.814     0.200
     2.664    42.722     0.200
     2.664    40.423     0.200
     2.767    44.444     0.200
     2.767    43.275     0.200
     3.074    48.907     0.200
     3.463    52.758     0.200
     3.729    54.635     0.200
     3.780    54.622     0.200
     3.780    54.441     0.200
     3.811    55.006     0.200
     3.827    53.789     0.200
     3.827    54.147     0.200
     3.829    54.286     0.200
     3.862    56.110     0.200
     3.862    56.243     0.200
     4.218    59.104     0.200
     4.218    59.583     0.200
     4.417    61.507     0.200
     4.461    62.563     0.200
     4.602    67.106     0.200
     4.666    65.866     0.200
     4.744    66.992     0.200
     4.893    68.808     0.200
     5.027    70.885     0.200
     5.249    73.307     0.200
     5.438    75.581     0.200
     5.477    75.885     0.200
     6.426    88.401     0.200
     2.589    46.203     0.200
     2.778    48.759     0.200
     2.900    50.786     0.200
     3.071    52.301     0.200
     3.162    53.476     0.200
     3.982    58.946     0.200
     4.401    65.269     0.200
     5.389    75.719     0.200
     5.443    75.237     0.200
     5.444    78.879     0.200
     5.473    77.496     0.200
     5.526    78.171     0.200
     5.581    80.129     0.200
     5.707    81.857     0.200
     5.760    82.351     0.200
     5.767    81.222     0.200
     5.924    81.843     0.200
     5.988    84.900     0.200
     6.019    84.606     0.200
     6.264    88.147     0.200
     6.273    87.911     0.200
     6.465    89.098     0.200
     6.664    92.739     0.200
     6.724    93.646     0.200
     6.961    96.305     0.200
     7.107    98.458     0.200
     7.196    96.886     0.200
     7.571   103.392     0.200
     0.893    19.810     0.200
     1.945    32.546     0.200
     2.755    43.330     0.200
     3.774    53.968     0.200
     3.829    54.901     0.200
     3.827    51.937     0.200
     3.854    55.630     0.200
     4.216    60.655     0.200
     0.908    22.565     0.200
     1.099    25.937     0.200
     2.431    40.287     0.200
     2.602    44.358     0.200
     3.125    47.580     0.200
     3.125    47.455     0.200
     3.140    51.616     0.200
     3.455    50.876     0.200
     3.455    51.259     0.200
     3.511    52.270     0.200
     3.548    52.300     0.200
     3.517    55.854     0.200
     3.571    50.544     0.200
     3.475    55.867     0.200
     3.528    56.415     0.200
     3.563    56.844     0.200
     3.811    54.812     0.200
     3.811    54.429     0.200
     3.833    56.602     0.200
     3.833    55.953     0.200
     3.837    56.064     0.200
     3.837    56.470     0.200
     4.009    58.060     0.200
     4.009    59.021     0.200
     4.035    57.981     0.200
     4.061    59.679     0.200
     4.085    58.136     0.200
     4.085    59.839     0.200
     4.592    65.344     0.200
     4.592    63.188     0.200
     4.628    66.317     0.200
     4.733    67.238     0.200
     4.822    67.963     0.200
     4.822    68.596     0.200
     4.823    67.305     0.200
     5.186    73.306     0.200
     5.315    75.025     0.200
     5.660    78.601     0.200
     5.730    78.456     0.200
     6.285    87.235     0.200
     6.959    94.960     0.200
     1.084    25.197     0.200
     1.742    32.614     0.200
     3.543    52.653     0.200
     3.570    52.903     0.200
     3.815    54.972     0.200
     4.016    58.237     0.200
     4.591    65.416     0.200
     4.831    68.666     0.200
     1.142    24.775     0.200
     1.238    27.348     0.200
     2.459    42.085     0.200
     2.474    42.445     0.200
     3.207    50.690     0.200
     4.368    60.912     0.200
     4.665    64.906     0.200
     4.910    68.266     0.200
     5.002    69.336     0.200
     5.586    77.592     0.200
     1.245    28.102     0.200
     1.245    28.109     0.200
     1.381    26.987     0.200
     1.696    32.509     0.200
     1.960    36.698     0.200
     1.969    35.979     0.200
     3.012    51.322     0.200
     3.578    57.541     0.200
     5.602    78.610     0.200
     5.700    80.274     0.200
     5.997    84.955     0.200
     6.120    85.139     0.200
     6.240    87.487     0.200
     6.322    86.649     0.200
     6.475    88.438     0.200
     7.086    99.853     0.200
     7.584   103.250     0.200
     7.603   103.477     0.200
     9.275   125.260     0.200
     1.261    29.464     0.200
     1.753    34.319     0.200
     1.953    36.994     0.200
     2.109    39.255     0.200
     2.602    42.466     0.200
     2.585    45.651     0.200
     3.012    46.736     0.200
     3.119    47.374     0.200
     3.092    51.242     0.200
     3.139    51.162     0.200
     3.195    50.652     0.200
     3.298    52.304     0.200
     3.449    55.472     0.200
     3.634    55.105     0.200
     4.045    64.722     0.200
     4.163    64.141     0.200
     4.542    68.862     0.200
     4.542    67.917     0.200
     4.605    68.373     0.200
     4.605    68.272     0.200
     4.635    68.212     0.200
     4.736    68.994     0.200
     4.736    69.205     0.200
     4.918    71.519     0.200
     4.918    70.496     0.200
     4.941    70.936     0.200
     4.943    70.716     0.200
     5.234    75.094     0.200
     5.234    76.125     0.200
     5.282    76.310     0.200
     5.282    76.505     0.200
     5.274    77.169     0.200
     5.405    77.492     0.200
     5.407    78.269     0.200
     5.532    78.651     0.200
     5.609    80.123     0.200
     5.726    81.139     0.200
     5.726    80.897     0.200
     5.888    84.587     0.200
     5.961    84.104     0.200
     5.961    84.369     0.200
     6.050    84.439     0.200
     6.050    86.244     0.200
     6.116    87.025     0.200
     6.457    90.999     0.200
     6.492    91.410     0.200
     6.655    91.903     0.200
     6.906    97.079     0.200
     1.249    27.138     0.200
     1.853    34.896     0.200
     1.973    34.318     0.200
     3.188    53.418     0.200
     3.338    53.729     0.200
     4.598    65.832     0.200
     4.633    67.659     0.200
     4.633    67.958     0.200
     4.647    67.771     0.200
     5.006    72.350     0.200
     5.065    71.726     0.200
     5.394    79.101     0.200
     5.597    79.803     0.200
     5.871    82.456     0.200
     6.181    86.705     0.200
     1.057    23.289     0.200
     1.761    30.724     0.200
     1.761    31.075     0.200
     2.430    40.486     0.200
     2.641    39.977     0.200
     2.595    43.012     0.200
     2.708    44.572     0.200
     3.469    53.912     0.200
     3.548    51.185     0.200
     3.599    51.851     0.200
     3.630    52.163     0.200
     3.630    51.984     0.200
     3.634    54.143     0.200
     3.842    55.481     0.200
     3.842    54.422     0.200
     3.891    56.182     0.200
     3.924    56.105     0.200
     3.939    57.040     0.200
     4.019    57.657     0.200
     4.019    57.192     0.200
     4.103    57.263     0.200
     4.103    57.697     0.200
     4.176    57.576     0.200
     4.176    59.537     0.200
     4.204    60.103     0.200
     4.422    63.024     0.200
     4.656    64.710     0.200
     4.656    65.144     0.200
     4.821    66.761     0.200
     4.894    68.554     0.200
     5.266    73.081     0.200
     5.381    74.737     0.200
     5.398    73.663     0.200
     5.403    73.080     0.200
     5.736    78.880     0.200
     5.836    79.697     0.200
     5.858    80.505     0.200
     1.332    29.437     0.200
     2.615    41.151     0.200
     2.615    41.909     0.200
     2.720    45.596     0.200
     2.750    43.690     0.200
     2.750    44.823     0.200
     3.091    50.054     0.200
     3.093    50.897     0.200
     3.347    55.357     0.200
     3.713    59.081     0.200
     3.694    62.757     0.200
     4.207    63.719     0.200
     4.682    68.131     0.200
     5.006    72.834     0.200
     5.362    77.783     0.200
     5.370    76.265     0.200
     1.281    28.498     0.200
     5.683    77.814     0.200
     5.710    79.586     0.200
     5.985    82.977     0.200
     6.408    88.589     0.200
     6.443    88.943     0.200
     7.329    95.747     0.200
     7.419   101.002     0.200
     1.072    28.642     0.200
     1.156    28.748     0.200
     4.704    70.208     0.200
     4.773    70.937     0.200
     5.089    74.362     0.200
     5.314    77.834     0.200
     5.582    80.644     0.200
     6.101    87.805     0.200
     6.937    97.087     0.200
     1.506    30.324     0.200
     1.597    31.619     0.200
     1.923    37.505     0.200
     1.923    37.075     0.200
     2.113    39.878     0.200
     2.298    41.177     0.200
     2.907    49.074     0.200
     3.278    56.160     0.200
     3.333    53.444     0.200
     3.755    60.468     0.200
     3.879    66.388     0.200
     4.035    63.886     0.200
     4.228    63.690     0.200
     4.228    64.326     0.200
     4.441    66.310     0.200
     4.486    66.301     0.200
     4.797    71.705     0.200
     4.797    72.264     0.200
     4.891    71.518     0.200
     4.891    73.218     0.200
     5.115    73.378     0.200
     5.115    74.374     0.200
     5.211    75.405     0.200
     5.283    76.281     0.200
     5.283    75.559     0.200
     5.312    76.422     0.200
     5.312    76.594     0.200
     5.370    78.404     0.200
     5.383    77.656     0.200
     5.401    77.332     0.200
     5.510    79.181     0.200
     5.641    80.867     0.200
     5.656    81.676     0.200
     5.656    80.629     0.200
     5.754    79.640     0.200
     5.754    82.300     0.200
     5.830    82.020     0.200
     5.830    82.950     0.200
     5.839    83.134     0.200
     5.828    83.109     0.200
     5.828    84.332     0.200
     5.829    85.307     0.200
     5.990    85.204     0.200
     6.356    89.537     0.200
     6.398    89.060     0.200
     6.398    90.396     0.200
     6.430    91.265     0.200
     6.594    90.950     0.200
     6.594    93.243     0.200
     6.917    97.327     0.200
     7.103   100.784     0.200
     7.110    99.395     0.200
     7.210    98.367     0.200
     7.214    99.056     0.200
     7.398   102.163     0.200
     7.398   101.178     0.200
     7.479   104.794     0.200
     7.527   103.541     0.200
     7.634   104.306     0.200
     8.085   110.752     0.200
     8.145   112.165     0.200
     8.447   115.245     0.200
     8.653   117.966     0.200
     8.916   121.178     0.200
     8.970   122.663     0.200
     8.984   123.270     0.200
     9.077   123.643     0.200
     9.399   127.278     0.200
     9.534   126.066     0.200
     9.534   129.527     0.200
     9.599   129.150     0.200
    10.877   142.655     0.200
     1.125    28.165     0.200
     1.323    30.657     0.200
     2.323    43.012     0.200
     2.455    43.367     0.200
     2.644    45.924     0.200
     2.660    47.538     0.200
     3.443    55.694     0.200
     3.522    56.937     0.200
     4.930    71.168     0.200
     5.004    72.132     0.200
     5.263    75.864     0.200
     5.317    76.509     0.200
     5.557    78.946     0.200
     6.134    85.707     0.200
     3.393    50.237     0.200
     4.284    60.871     0.200
     4.353    61.058     0.200
     4.420    63.032     0.200
     4.762    65.969     0.200
     4.762    66.523     0.200
     4.899    68.274     0.200
     4.899    69.088     0.200
     4.972    69.144     0.200
     5.468    74.572     0.200
     5.468    75.054     0.200
     6.311    85.139     0.200
     6.352    85.317     0.200
     1.921    36.097     0.200
     2.585    45.486     0.200
     5.858    85.013     0.200
     5.948    85.151     0.200
     5.982    84.450     0.200
     6.048    86.944     0.200
     6.067    87.303     0.200
     6.255    88.843     0.200
     6.615    91.865     0.200
     6.681    93.502     0.200
     6.713    93.443     0.200
     7.132    99.779     0.200
     7.177    99.759     0.200
     7.597   101.706     0.200
     8.203   111.756     0.200
     1.790    33.626     0.200
     2.118    38.015     0.200
     2.561    43.179     0.200
     2.716    46.679     0.200
     2.734    46.411     0.200
     3.538    55.639     0.200
     4.828    67.817     0.200
     4.828    68.152     0.200
     4.899    68.893     0.200
     4.947    69.915     0.200
     5.103    72.488     0.200
     5.164    72.034     0.200
     5.164    72.764     0.200
     5.169    72.877     0.200
     5.214    73.179     0.200
     5.292    75.674     0.200
     5.292    76.185     0.200
     5.402    76.337     0.200
     5.444    76.511     0.200
     5.444    76.676     0.200
     5.463    76.346     0.200
     5.516    76.608     0.200
     5.706    78.887     0.200
     6.000    84.166     0.200
     6.000    82.755     0.200
     6.044    85.398     0.200
     6.123    85.146     0.200
     6.229    86.407     0.200
     6.586    90.789     0.200
     6.722    92.333     0.200
     6.724    92.969     0.200
     7.066    95.639     0.200
     1.982    37.177     0.200
     2.919    48.360     0.200
     3.890    57.984     0.200
     3.972    58.978     0.200
     4.280    63.442     0.200
     4.567    66.231     0.200
     1.310    27.760     0.200
     1.594    30.518     0.200
     1.954    35.400     0.200
     2.220    38.308     0.200
     2.220    37.610     0.200
     2.734    46.702     0.200
     2.734    44.044     0.200
     2.841    45.234     0.200
     2.906    48.837     0.200
     3.746    57.434     0.200
     3.746    57.081     0.200
     3.802    55.463     0.200
     3.800    56.415     0.200
     3.800    57.810     0.200
     3.827    57.840     0.200
     3.827    58.203     0.200
     4.187    60.932     0.200
     4.187    60.769     0.200
     4.567    65.383     0.200
     4.713    68.770     0.200
     4.864    70.281     0.200
     1.863    29.397     0.200
     1.864    30.190     0.200
     2.194    37.006     0.200
     2.232    35.781     0.200
     2.553    40.740     0.200
     2.519    41.791     0.200
     2.873    42.904     0.200
     3.252    50.458     0.200
     3.540    50.885     0.200
     3.882    53.753     0.200
     3.882    54.030     0.200
     3.922    54.378     0.200
     3.942    54.028     0.200
     3.942    54.227     0.200
     4.036    57.552     0.200
     4.036    57.212     0.200
     4.159    57.709     0.200
     4.159    56.975     0.200
     4.257    61.239     0.200
     4.288    59.912     0.200
     4.383    59.092     0.200
     4.383    59.549     0.200
     4.504    61.274     0.200
     4.508    61.983     0.200
     4.518    61.598     0.200
     4.923    70.402     0.200
     4.925    65.091     0.200
     5.018    67.967     0.200
     5.138    70.079     0.200
     5.183    69.714     0.200
     5.183    70.519     0.200
     5.547    73.453     0.200
     5.571    75.609     0.200
     5.592    76.529     0.200
     5.655    76.179     0.200
     6.031    80.136     0.200
     6.057    79.039     0.200
     6.067    79.938     0.200
     7.259    96.697     0.200
     0.901    21.397     0.200
     1.182    26.406     0.200
     1.165    25.383     0.200
     1.373    25.935     0.200
     2.038    35.778     0.200
     2.379    39.415     0.200
     2.379    38.103     0.200
     2.491    41.990     0.200
     2.683    43.404     0.200
     2.704    43.159     0.200
     2.955    47.033     0.200
     3.034    48.065     0.200
     3.289    53.505     0.200
     3.697    59.461     0.200
     3.744    53.385     0.200
     3.744    54.775     0.200
     3.778    54.665     0.200
     3.693    53.975     0.200
     3.792    52.828     0.200
     3.792    56.680     0.200
     3.862    55.659     0.200
     3.862    57.347     0.200
     3.985    58.356     0.200
     3.985    58.114     0.200
     3.988    63.028     0.200
     4.109    59.331     0.200
     4.109    59.886     0.200
     4.222    59.071     0.200
     4.222    61.274     0.200
     4.362    62.784     0.200
     4.378    63.436     0.200
     4.761    67.084     0.200
     4.751    66.121     0.200
     4.990    71.893     0.200
     5.024    69.812     0.200
     1.506    31.541     0.200
     1.934    36.368     0.200
     3.155    53.338     0.200
     5.303    76.211     0.200
     5.386    78.495     0.200
     5.853    85.086     0.200
     5.961    85.404     0.200
     6.740    94.212     0.200
     1.113    19.672     0.200
     1.740    27.891     0.200
     2.587    41.238     0.200
     2.685    40.088     0.200
     2.695    39.550     0.200
     3.425    47.115     0.200
     3.336    48.029     0.200
     3.507    48.487     0.200
     4.080    54.516     0.200
     4.170    56.774     0.200
     4.472    60.582     0.200
     4.472    60.297     0.200
     4.623    64.065     0.200
     4.657    62.465     0.200
     4.657    61.910     0.200
     4.786    63.582     0.200
     4.786    64.138     0.200
     4.875    65.978     0.200
     5.356    71.865     0.200
     5.356    71.729     0.200
     5.391    71.738     0.200
     5.549    73.043     0.200
     5.549    74.498     0.200
     5.691    76.213     0.200
     6.066    80.938     0.200
     6.253    81.824     0.200
     6.368    84.170     0.200
     6.611    85.470     0.200
     1.216    27.211     0.200
     2.167    38.486     0.200
     3.734    55.831     0.200
     3.764    55.087     0.200
     4.157    59.831     0.200
     4.198    61.273     0.200
     4.350    63.407     0.200
     4.371    65.936     0.200
     4.975    72.913     0.200
     1.156    26.273     0.200
     2.676    44.126     0.200
     2.676    44.604     0.200
     2.850    46.659     0.200
     2.850    47.290     0.200
     3.348    51.659     0.200
     3.348    51.034     0.200
     3.377    52.387     0.200
     3.322    56.170     0.200
     3.668    54.405     0.200
     3.668    53.989     0.200
     3.732    54.610     0.200
     3.722    56.655     0.200
     3.722    58.327     0.200
     3.776    56.058     0.200
     3.776    55.462     0.200
     3.816    55.596     0.200
     3.816    55.249     0.200
     3.981    59.517     0.200
     3.981    58.501     0.200
     3.988    58.045     0.200
     4.032    59.652     0.200
     4.050    58.348     0.200
     4.050    59.626     0.200
     4.064    59.801     0.200
     4.064    59.866     0.200
     4.064    61.528     0.200
     4.260    62.290     0.200
     4.259    62.162     0.200
     4.259    63.480     0.200
     4.276    61.537     0.200
     4.276    61.850     0.200
     4.301    63.271     0.200
     4.347    63.207     0.200
     4.374    68.331     0.200
     4.836    68.631     0.200
     4.836    69.890     0.200
     4.857    70.127     0.200
     4.956    70.577     0.200
     5.059    72.405     0.200
     5.067    73.024     0.200
     5.416    76.823     0.200
     5.557    78.401     0.200
     5.640    79.365     0.200
     5.894    83.107     0.200
     5.973    83.042     0.200
     6.045    84.325     0.200
     1.023    24.407     0.200
     1.309    29.281     0.200
     1.393    26.224     0.200
     1.712    32.015     0.200
     1.937    34.047     0.200
     2.133    37.236     0.200
     2.657    41.233     0.200
     2.814    43.726     0.200
     2.920    45.632     0.200
     3.072    50.191     0.200
     3.180    51.348     0.200
     3.267    52.752     0.200
     3.615    58.683     0.200
     3.782    57.841     0.200
     4.170    61.846     0.200
     4.251    61.593     0.200
     4.241    69.127     0.200
     4.423    64.983     0.200
     4.638    65.994     0.200
     4.674    68.071     0.200
     4.689    67.784     0.200
     4.762    69.189     0.200
     4.922    71.144     0.200
     4.907    71.844     0.200
     5.016    72.287     0.200
     5.264    75.265     0.200
     5.401    75.430     0.200
     5.511    77.995     0.200
     5.737    80.277     0.200
     6.592    90.836     0.200
     0.961    24.351     0.200
     1.306    29.826     0.200
     1.744    31.991     0.200
     2.162    37.779     0.200
     2.648    43.227     0.200
     2.679    42.841     0.200
     2.789    45.166     0.200
     2.825    45.522     0.200
     2.825    44.830     0.200
     2.925    47.197     0.200
     2.925    46.786     0.200
     3.087    48.200     0.200
     3.208    51.633     0.200
     3.208    51.327     0.200
     3.282    54.243     0.200
     3.619    60.803     0.200
     3.789    57.692     0.200
     4.187    63.165     0.200
     4.272    63.498     0.200
     4.278    65.611     0.200
     4.243    68.997     0.200
     4.450    64.948     0.200
     4.668    66.902     0.200
     4.704    68.269     0.200
     4.720    67.375     0.200
     4.774    70.424     0.200
     4.949    69.784     0.200
     4.949    71.373     0.200
     4.907    72.344     0.200
     5.046    72.784     0.200
     5.236    75.097     0.200
     5.294    75.005     0.200
     5.398    76.038     0.200
     5.426    76.603     0.200
     5.426    76.932     0.200
     5.542    78.847     0.200
     5.694    80.705     0.200
     5.763    80.932     0.200
     5.763    82.018     0.200
     5.859    84.370     0.200
     6.155    87.591     0.200
     6.218    87.828     0.200
     6.619    90.358     0.200
     1.221    26.963     0.200
     1.335    28.475     0.200
     2.083    37.495     0.200
     2.717    42.688     0.200
     2.717    43.084     0.200
     2.819    45.187     0.200
     2.819    44.532     0.200
     2.893    47.730     0.200
     2.893    48.388     0.200
     3.098    50.454     0.200
     3.334    53.581     0.200
     4.204    62.901     0.200
     4.308    62.726     0.200
     4.436    70.161     0.200
     4.746    68.077     0.200
     4.634    72.196     0.200
     4.787    68.287     0.200
     4.808    67.406     0.200
     4.808    67.908     0.200
     5.013    71.830     0.200
     5.013    70.847     0.200
     5.130    73.442     0.200
     5.130    72.330     0.200
     5.376    75.541     0.200
     5.483    78.265     0.200
     5.483    77.706     0.200
     5.623    79.989     0.200
     5.826    82.209     0.200
     5.934    84.500     0.200
     6.285    86.395     0.200
     6.680    92.175     0.200
     0.752    17.777     0.200
     0.867    19.457     0.200
     1.014    22.315     0.200
     2.594    38.585     0.200
     3.361    49.928     0.200
     4.190    57.576     0.200
     4.190    58.509     0.200
     4.278    59.230     0.200
     4.465    61.699     0.200
     4.500    63.226     0.200
     4.582    63.486     0.200
     4.737    64.539     0.200
     4.738    64.813     0.200
     4.738    65.517     0.200
     4.829    65.389     0.200
     4.886    66.062     0.200
     4.886    66.538     0.200
     4.944    67.805     0.200
     4.944    68.983     0.200
     5.067    71.149     0.200
     5.454    74.620     0.200
     5.454    73.949     0.200
     5.652    75.865     0.200
     5.652    77.501     0.200
     5.980    74.608     0.200
     5.753    78.963     0.200
     6.167    83.502     0.200
     6.700    91.144     0.200
     0.950    21.783     0.200
     1.776    27.772     0.200
     2.625    42.401     0.200
     2.737    40.435     0.200
     2.990    42.541     0.200
     3.259    45.119     0.200
     3.553    50.719     0.200
     4.153    56.470     0.200
     4.622    61.828     0.200
     4.762    65.034     0.200
     4.836    65.336     0.200
     5.330    71.223     0.200
     5.651    76.059     0.200
     1.196    26.445     0.200
     1.156    24.809     0.200
     1.461    26.948     0.200
     2.232    35.903     0.200
     2.198    38.259     0.200
     2.364    39.719     0.200
     2.699    44.146     0.200
     2.940    47.494     0.200
     3.018    46.809     0.200
     3.274    52.967     0.200
     3.768    55.251     0.200
     3.847    55.423     0.200
     3.970    58.019     0.200
     3.973    60.278     0.200
     4.100    60.211     0.200
     4.154    60.347     0.200
     4.209    61.058     0.200
     4.352    64.188     0.200
     4.749    67.217     0.200
     4.736    68.482     0.200
     4.979    72.532     0.200
     5.358    74.844     0.200
     0.720    18.304     0.200
     1.080    22.628     0.200
     5.417    76.185     0.200
     5.885    81.004     0.200
     5.972    83.405     0.200
     5.991    82.522     0.200
     6.212    86.876     0.200
     6.770    92.989     0.200
     0.722    17.724     0.200
     0.839    19.927     0.200
     1.775    31.037     0.200
     1.987    32.383     0.200
     1.987    33.180     0.200
     2.522    39.812     0.200
     2.664    44.399     0.200
     2.756    43.913     0.200
     2.756    43.030     0.200
     2.729    44.035     0.200
     2.734    41.427     0.200
     2.921    45.680     0.200
     2.921    44.414     0.200
     3.038    47.336     0.200
     3.041    47.305     0.200
     3.041    47.199     0.200
     3.235    47.356     0.200
     3.429    51.142     0.200
     3.429    51.552     0.200
     3.459    53.590     0.200
     3.459    52.125     0.200
     3.517    51.157     0.200
     3.713    54.118     0.200
     3.713    53.442     0.200
     3.781    54.275     0.200
     3.829    54.388     0.200
     3.794    56.973     0.200
     3.795    58.507     0.200
     3.803    56.319     0.200
     3.803    56.701     0.200
     3.879    54.171     0.200
     3.879    55.292     0.200
     4.014    57.345     0.200
     4.069    56.881     0.200
     4.069    58.819     0.200
     4.097    58.469     0.200
     4.139    58.682     0.200
     4.139    59.713     0.200
     4.229    62.055     0.200
     4.298    61.091     0.200
     4.337    60.274     0.200
     4.337    61.212     0.200
     4.347    59.878     0.200
     4.347    62.136     0.200
     4.337    61.876     0.200
     4.337    61.583     0.200
     4.398    62.133     0.200
     4.456    64.193     0.200
     4.591    64.881     0.200
     4.899    67.919     0.200
     4.899    67.322     0.200
     5.005    70.661     0.200
     5.117    69.724     0.200
     5.117    70.630     0.200
     5.148    71.866     0.200
     5.387    77.616     0.200
     5.469    76.361     0.200
     5.618    77.619     0.200
     5.692    77.544     0.200
     5.725    77.852     0.200
     5.725    79.207     0.200
     5.718    77.325     0.200
     5.829    82.665     0.200
     5.829    80.614     0.200
     5.914    80.145     0.200
     5.916    80.655     0.200
     5.950    81.075     0.200
     6.034    81.498     0.200
     6.050    83.739     0.200
     6.115    82.153     0.200
     6.463    87.254     0.200
     6.590    88.508     0.200
     6.681    89.715     0.200
     6.959    93.479     0.200
     7.493   100.326     0.200
     7.581   100.200     0.200
     7.883   104.916     0.200
     7.948   104.620     0.200
     8.019   107.085     0.200
     8.019   106.691     0.200
     8.107   107.026     0.200
     8.239   108.475     0.200
     8.815   116.197     0.200
     9.023   117.939     0.200
     9.358   123.012     0.200
     9.463   122.761     0.200
     9.860   128.308     0.200
     1.362    32.643     0.200
     1.278    30.552     0.200
     1.411    33.040     0.200
     1.256    29.191     0.200
     1.983    37.657     0.200
     2.105    39.897     0.200
     5.374    75.682     0.200
     5.656    79.969     0.200
     6.050    84.249     0.200
     6.579    92.053     0.200
     1.133    24.166     0.200
     1.156    25.044     0.200
     1.594    30.338     0.200
     2.783    43.130     0.200
     2.783    41.935     0.200
     3.025    46.901     0.200
     3.025    46.495     0.200
     4.014    60.575     0.200
     4.334    65.263     0.200
     4.334    65.146     0.200
     4.373    66.119     0.200
     4.373    63.705     0.200
     4.476    66.827     0.200
     4.648    66.599     0.200
     4.668    65.210     0.200
     4.668    65.707     0.200
     4.974    69.014     0.200
     4.974    71.170     0.200
     5.009    70.616     0.200
     5.129    71.652     0.200
     5.129    71.058     0.200
     5.131    72.880     0.200
     5.471    78.073     0.200
     5.471    77.010     0.200
     5.693    78.598     0.200
     1.816    33.795     0.200
     2.450    43.736     0.200
     2.871    48.915     0.200
     3.883    60.728     0.200
     4.634    67.257     0.200
     4.634    66.818     0.200
     4.694    67.854     0.200
     4.730    69.193     0.200
     4.730    69.629     0.200
     4.731    69.286     0.200
     4.731    69.745     0.200
     4.881    72.113     0.200
     4.881    69.472     0.200
     4.946    72.708     0.200
     5.000    70.996     0.200
     5.000    72.474     0.200
     5.015    72.055     0.200
     5.015    71.082     0.200
     4.991    72.876     0.200
     4.991    72.179     0.200
     5.203    74.346     0.200
     5.203    73.649     0.200
     5.228    74.176     0.200
     5.266    75.325     0.200
     5.810    82.500     0.200
     5.997    84.978     0.200
     5.997    84.287     0.200
     6.368    89.057     0.200
     6.379    89.819     0.200
     6.437    89.765     0.200
     6.839    94.553     0.200
     6.894    94.891     0.200
     2.114    37.835     0.200
     2.150    37.947     0.200
     2.767    46.558     0.200
     2.948    50.251     0.200
     3.501    56.547     0.200
     3.816    59.918     0.200
     3.909    63.820     0.200
     4.640    72.033     0.200
     2.363    39.859     0.200
     2.193    36.467     0.200
     2.938    48.374     0.200
     3.016    47.815     0.200
     3.271    53.580     0.200
     3.305    53.980     0.200
     3.443    56.506     0.200
     3.769    55.300     0.200
     3.748    62.243     0.200
     3.847    57.702     0.200
     3.968    60.150     0.200
     3.970    61.853     0.200
     4.210    61.039     0.200
     4.749    67.474     0.200
     0.998    23.067     0.200
     2.806    46.813     0.200
     3.931    57.799     0.200
     4.265    60.694     0.200
     4.393    61.896     0.200
     4.476    62.788     0.200
     4.662    64.062     0.200
     4.714    65.450     0.200
     4.896    68.351     0.200
     5.116    71.635     0.200
     5.165    72.373     0.200
     5.455    74.020     0.200
     5.583    77.294     0.200
     6.004    77.696     0.200
     6.685    89.179     0.200
     0.844    21.560     0.200
     0.973    24.023     0.200
     1.462    29.394     0.200
     1.978    37.050     0.200
     2.182    38.867     0.200
     5.141    73.531     0.200
     5.234    74.225     0.200
     5.535    78.050     0.200
     5.842    82.011     0.200
     6.454    89.720     0.200
     6.927    89.300     0.200
     7.123    98.334     0.200
     2.832    48.212     0.200
     5.967    81.741     0.200
     6.033    83.260     0.200
     6.098    83.015     0.200
     6.142    85.398     0.200
     6.158    84.438     0.200
     6.364    86.913     0.200
     6.404    87.010     0.200
     6.595    89.776     0.200
     6.730    90.956     0.200
     6.815    91.557     0.200
     6.814    92.501     0.200
     7.246    97.769     0.200
     7.284    98.090     0.200
     7.692    99.407     0.200
     7.535   101.105     0.200
     7.802   105.089     0.200
     8.080   108.200     0.200
     8.318   112.709     0.200
     1.147    27.063     0.200
     1.365    31.034     0.200
     1.367    30.636     0.200
     1.383    30.626     0.200
     1.961    35.277     0.200
     2.077    39.180     0.200
     2.248    41.754     0.200
     2.734    44.839     0.200
     2.734    46.089     0.200
     2.734    46.464     0.200
     2.833    47.153     0.200
     2.844    46.028     0.200
     2.844    47.028     0.200
     2.681    48.209     0.200
     2.922    48.351     0.200
     2.922    49.117     0.200
     3.120    51.035     0.200
     3.141    50.006     0.200
     3.141    50.545     0.200
     3.181    52.928     0.200
     3.183    51.950     0.200
     3.311    53.713     0.200
     3.311    55.174     0.200
     3.416    52.869     0.200
     3.416    54.940     0.200
     3.348    56.739     0.200
     3.795    60.817     0.200
     3.653    61.948     0.200
     4.129    62.909     0.200
     4.114    63.414     0.200
     4.225    64.171     0.200
     4.225    65.132     0.200
     4.247    62.864     0.200
     4.326    63.801     0.200
     4.326    65.278     0.200
     4.524    67.305     0.200
     4.524    68.008     0.200
     4.405    66.469     0.200
     4.405    71.437     0.200
     4.604    72.978     0.200
     4.753    69.096     0.200
     4.793    69.546     0.200
     4.812    69.154     0.200
     4.812    69.677     0.200
     4.888    73.953     0.200
     5.024    72.875     0.200
     5.135    73.308     0.200
     5.135    74.394     0.200
     5.299    76.438     0.200
     5.313    76.292     0.200
     5.313    79.784     0.200
     5.382    77.956     0.200
     5.491    78.254     0.200
     5.496    79.505     0.200
     5.496    79.966     0.200
     5.555    81.290     0.200
     5.629    80.017     0.200
     5.612    85.169     0.200
     5.806    83.106     0.200
     5.838    84.822     0.200
     5.942    86.123     0.200
     6.295    90.135     0.200
     2.133    36.811     0.200
     2.342    39.751     0.200
     2.774    46.372     0.200
     3.504    52.336     0.200
     3.504    52.726     0.200
     3.672    54.755     0.200
     3.798    57.709     0.200
     3.798    58.469     0.200
     3.945    59.221     0.200
     3.945    60.072     0.200
     4.014    59.962     0.200
     4.014    61.613     0.200
     4.017    60.284     0.200
     4.017    59.480     0.200
     4.152    62.461     0.200
     5.079    73.342     0.200
     5.079    72.716     0.200
     5.079    73.039     0.200
     5.163    73.675     0.200
     5.163    74.038     0.200
     5.192    72.501     0.200
     5.526    76.498     0.200
     5.526    78.621     0.200
     5.553    79.507     0.200
     5.553    78.736     0.200
     5.587    77.374     0.200
     5.587    77.837     0.200
     5.581    79.182     0.200
     5.731    82.757     0.200
     5.778    80.657     0.200
     5.798    81.320     0.200
     5.940    85.838     0.200
     6.026    84.299     0.200
     6.107    85.230     0.200
     6.107    85.359     0.200
     6.264    86.284     0.200
     6.264    86.442     0.200
     6.398    88.779     0.200
     6.398    89.574     0.200
     6.397    89.519     0.200
     6.576    89.878     0.200
     6.810    93.398     0.200
     6.841    93.667     0.200
     7.170    98.574     0.200
     7.170    99.465     0.200
     7.245    97.684     0.200
     7.252    98.565     0.200
     7.772   106.273     0.200
     7.783   106.642     0.200
     8.175   109.681     0.200
     8.378   114.099     0.200
     8.647   115.854     0.200
     8.759   117.543     0.200
     9.136   119.644     0.200
     9.439   124.385     0.200
     1.170    27.563     0.200
     1.513    29.624     0.200
     1.759    32.294     0.200
     1.759    32.536     0.200
     2.147    38.890     0.200
     2.569    44.006     0.200
     2.733    45.321     0.200
     3.554    58.540     0.200
     3.539    55.888     0.200
     4.789    67.238     0.200
     4.789    67.698     0.200
     4.861    68.442     0.200
     4.942    69.715     0.200
     5.064    72.033     0.200
     5.089    71.741     0.200
     5.133    73.155     0.200
     5.133    71.492     0.200
     5.129    72.510     0.200
     5.175    72.362     0.200
     5.208    79.053     0.200
     5.263    75.076     0.200
     5.263    74.366     0.200
     5.362    74.778     0.200
     5.407    76.770     0.200
     5.407    75.442     0.200
     5.425    75.829     0.200
     5.478    76.104     0.200
     5.667    78.222     0.200
     5.964    82.622     0.200
     5.989    82.942     0.200
     6.085    83.455     0.200
     6.192    85.150     0.200
     6.687    90.142     0.200
     7.028    95.696     0.200
     7.102    96.251     0.200
     7.656   104.564     0.200
     8.324   113.538     0.200
     1.779    32.447     0.200
     2.406    42.592     0.200
     2.585    45.233     0.200
     5.188    75.367     0.200
     5.214    74.897     0.200
     5.601    79.926     0.200
     5.826    83.306     0.200
     6.283    88.646     0.200
     1.181    28.301     0.200
     1.400    29.946     0.200
     1.770    34.562     0.200
     2.018    38.660     0.200
     2.056    38.319     0.200
     2.790    47.708     0.200
     5.353    75.510     0.200
     5.451    77.874     0.200
     5.748    82.004     0.200
     5.874    83.367     0.200
     5.992    85.699     0.200
     6.072    85.955     0.200
     6.227    88.305     0.200
     6.596    93.284     0.200
     6.669    93.892     0.200
     1.163    25.842     0.200
     2.114    37.293     0.200
     2.401    40.717     0.200
     2.401    40.516     0.200
     2.722    42.224     0.200
     2.722    42.477     0.200
     2.978    49.061     0.200
     3.405    56.368     0.200
     3.757    56.123     0.200
     3.675    60.348     0.200
     3.708    60.784     0.200
     3.790    55.997     0.200
     3.805    55.812     0.200
     3.716    56.605     0.200
     3.882    59.491     0.200
     3.882    59.279     0.200
     4.006    60.025     0.200
     4.006    60.156     0.200
     4.011    62.556     0.200
     4.118    61.602     0.200
     4.121    58.828     0.200
     4.121    59.530     0.200
     4.145    61.107     0.200
     4.145    60.655     0.200
     4.237    60.027     0.200
     4.237    61.774     0.200
     4.374    63.294     0.200
     4.387    63.977     0.200
     4.621    66.413     0.200
     4.778    68.624     0.200
     4.774    70.436     0.200
     4.880    69.548     0.200
     5.003    72.222     0.200
     5.040    71.674     0.200
     5.040    72.872     0.200
     5.432    77.836     0.200
     5.394    76.086     0.200
     5.439    77.021     0.200
     5.888    82.987     0.200
     0.773    19.545     0.200
     0.901    21.658     0.200
     1.788    31.200     0.200
     2.822    44.036     0.200
     4.384    61.415     0.200
     4.453    62.073     0.200
     4.499    61.666     0.200
     4.738    62.375     0.200
     4.769    66.205     0.200
     4.888    64.972     0.200
     4.997    67.435     0.200
     5.554    73.921     0.200
     5.781    77.125     0.200
     6.139    82.596     0.200
     6.277    82.743     0.200
     6.275    80.986     0.200
     6.296    82.861     0.200
     1.158    26.220     0.200
     1.307    25.625     0.200
     1.385    27.287     0.200
     2.224    39.720     0.200
     2.224    39.451     0.200
     2.316    41.018     0.200
     2.410    41.540     0.200
     3.459    55.208     0.200
     4.177    61.360     0.200
     4.531    68.264     0.200
     5.484    76.842     0.200
     5.529    78.206     0.200
     5.545    77.626     0.200
     5.691    79.751     0.200
     5.691    80.116     0.200
     5.755    80.324     0.200
     5.800    79.621     0.200
     6.015    82.786     0.200
     6.015    83.132     0.200
     6.050    83.908     0.200
     6.292    86.567     0.200
     6.567    89.545     0.200
     6.708    93.386     0.200
     6.805    93.441     0.200
     2.132    40.700     0.200
     3.516    59.310     0.200
     3.784    63.514     0.200
     5.957    84.766     0.200
     6.055    86.136     0.200
     6.136    85.988     0.200
     6.231    88.593     0.200
     6.352    89.517     0.200
     6.473    91.324     0.200
     6.595    92.945     0.200
     6.674    92.142     0.200
     6.829    96.050     0.200
     7.201   100.086     0.200
     7.273   101.390     0.200
     7.736   100.974     0.200
     7.938   110.695     0.200
     7.955   110.784     0.200
     8.259   113.821     0.200
     9.624   131.028     0.200
     1.225    27.297     0.200
     2.231    38.584     0.200
     6.060    84.124     0.200
     6.142    85.356     0.200
     6.290    88.718     0.200
     6.336    90.037     0.200
     6.371    88.445     0.200
     6.450    89.159     0.200
     6.609    91.019     0.200
     6.698    92.749     0.200
     6.708    92.721     0.200
     6.764    93.452     0.200
     6.937    95.035     0.200
     7.056    96.912     0.200
     7.277    99.322     0.200
     7.365    99.518     0.200
     7.490   101.992     0.200
     7.838   105.311     0.200
     7.988   106.826     0.200
     8.061   111.091     0.200
     8.322   112.808     0.200
     8.404   111.862     0.200
     2.688    45.145     0.200
     2.729    45.687     0.200
     3.525    55.521     0.200
     1.012    24.765     0.200
     1.353    30.092     0.200
     1.453    28.981     0.200
     1.352    29.103     0.200
     1.538    29.449     0.200
     1.768    34.251     0.200
     1.898    33.848     0.200
     2.545    43.708     0.200
     3.030    51.176     0.200
     5.381    75.696     0.200
     5.381    76.597     0.200
     5.488    78.048     0.200
     5.537    79.175     0.200
     5.537    81.286     0.200
     5.571    77.682     0.200
     5.638    79.139     0.200
     5.702    80.191     0.200
     5.778    81.659     0.200
     5.778    81.331     0.200
     5.881    83.625     0.200
     6.019    84.798     0.200
     6.010    82.873     0.200
     6.139    84.884     0.200
     6.139    86.308     0.200
     6.198    87.919     0.200
     6.250    87.478     0.200
     6.361    87.725     0.200
     6.700    93.367     0.200
     6.891    96.426     0.200
     7.151    93.064     0.200
     7.417   101.042     0.200
     7.834   106.208     0.200
     1.129    24.445     0.200
     1.492    27.843     0.200
     1.656    30.912     0.200
     2.248    38.334     0.200
     5.585    76.900     0.200
     5.701    77.817     0.200
     5.983    83.043     0.200
     6.377    86.718     0.200
     6.448    86.971     0.200
     6.556    88.886     0.200
     7.342    93.687     0.200
     1.082    23.628     0.200
     1.082    23.253     0.200
     1.191    27.050     0.200
     1.453    27.638     0.200
     2.191    36.240     0.200
     2.397    41.279     0.200
     2.397    39.013     0.200
     2.614    43.516     0.200
     2.614    41.532     0.200
     2.673    43.302     0.200
     3.091    48.337     0.200
     3.434    54.174     0.200
     3.434    53.174     0.200
     3.533    51.773     0.200
     3.533    52.445     0.200
     3.582    52.834     0.200
     3.611    53.195     0.200
     3.610    52.283     0.200
     3.610    52.916     0.200
     3.608    58.520     0.200
     3.812    54.703     0.200
     3.812    55.609     0.200
     3.879    57.163     0.200
     3.892    56.763     0.200
     3.892    56.607     0.200
     3.908    57.515     0.200
     3.908    57.186     0.200
     3.928    56.366     0.200
     3.928    57.343     0.200
     3.987    59.358     0.200
     3.987    58.116     0.200
     4.080    59.648     0.200
     4.080    58.859     0.200
     4.085    61.365     0.200
     4.149    60.115     0.200
     4.160    59.144     0.200
     4.160    60.425     0.200
     4.186    60.540     0.200
     4.406    63.980     0.200
     4.533    65.939     0.200
     4.632    66.954     0.200
     4.632    65.236     0.200
     4.690    67.077     0.200
     4.802    68.627     0.200
     4.787    68.729     0.200
     4.872    69.975     0.200
     4.872    69.866     0.200
     5.246    74.641     0.200
     5.358    75.123     0.200
     5.368    75.007     0.200
     5.371    74.719     0.200
     5.458    78.056     0.200
     5.548    79.798     0.200
     5.561    77.735     0.200
     5.563    77.085     0.200
     5.715    79.417     0.200
     5.772    79.223     0.200
     5.808    80.177     0.200
     5.839    81.197     0.200
     6.231    86.953     0.200
     6.324    86.807     0.200
     6.987    94.980     0.200
     7.126    96.999     0.200
     7.204    97.179     0.200
     7.314   100.658     0.200
     7.723   103.915     0.200
     7.842   105.247     0.200
     9.117   120.674     0.200
     0.870    22.117     0.200
     0.834    20.157     0.200
     0.834    19.443     0.200
     1.087    22.552     0.200
     2.189    35.347     0.200
     3.534    51.223     0.200
     3.534    51.567     0.200
     3.582    51.592     0.200
     3.611    52.277     0.200
     3.611    52.457     0.200
     3.609    52.437     0.200
     3.810    54.121     0.200
     3.810    54.426     0.200
     3.880    56.616     0.200
     3.894    56.361     0.200
     3.894    57.330     0.200
     3.908    56.193     0.200
     3.908    56.537     0.200
     3.929    56.412     0.200
     3.984    57.995     0.200
     3.984    57.386     0.200
     4.079    57.768     0.200
     4.079    58.964     0.200
     4.151    59.280     0.200
     4.160    60.439     0.200
     4.186    60.129     0.200
     4.407    62.814     0.200
     4.534    64.686     0.200
     4.631    65.796     0.200
     4.631    65.679     0.200
     4.691    66.292     0.200
     4.802    67.988     0.200
     4.784    67.441     0.200
     4.872    67.867     0.200
     4.872    68.625     0.200
     5.247    72.740     0.200
     5.357    73.690     0.200
     5.367    73.808     0.200
     5.369    73.121     0.200
     5.549    78.248     0.200
     5.559    75.608     0.200
     5.560    75.216     0.200
     5.715    78.698     0.200
     5.771    80.330     0.200
     5.807    79.192     0.200
     1.444    33.875     0.200
     1.304    32.191     0.200
     1.670    34.759     0.200
     1.931    37.828     0.200
     2.082    40.321     0.200
     2.463    44.825     0.200
     2.888    50.907     0.200
     5.392    77.920     0.200
     5.419    80.065     0.200
     5.676    81.935     0.200
     5.768    82.648     0.200
     5.916    84.842     0.200
     6.058    86.360     0.200
     6.254    87.994     0.200
     1.204    26.536     0.200
     1.342    28.707     0.200
     1.639    30.796     0.200
     1.710    32.051     0.200
     3.021    46.522     0.200
     2.936    50.307     0.200
     4.906    70.792     0.200
     4.926    70.259     0.200
     5.229    74.344     0.200
     5.267    76.366     0.200
     5.479    77.026     0.200
     5.589    79.057     0.200
     5.724    81.544     0.200
     5.901    81.827     0.200
     5.951    82.600     0.200
     6.045    85.270     0.200
     6.104    85.171     0.200
     1.414    32.285     0.200
     1.420    33.974     0.200
     5.324    77.201     0.200
     5.438    78.366     0.200
     5.455    79.214     0.200
     5.528    80.615     0.200
     5.682    82.086     0.200
     5.721    82.326     0.200
     6.111    87.096     0.200
     6.188    87.936     0.200
     6.296    88.385     0.200
     6.644    93.937     0.200
     6.686    94.285     0.200
     7.148   100.449     0.200
     1.166    27.947     0.200
     1.346    30.111     0.200
     1.485    30.035     0.200
     1.775    33.509     0.200
     2.167    39.131     0.200
     2.573    45.122     0.200
     5.196    74.526     0.200
     5.305    76.124     0.200
     5.593    79.867     0.200
     5.963    83.807     0.200
     6.174    87.383     0.200
     6.515    91.981     0.200
     6.964    91.279     0.200
     7.240   100.273     0.200
     1.430    32.775     0.200
     1.622    33.254     0.200
     1.535    32.195     0.200
     1.795    34.822     0.200
     2.592    46.051     0.200
     5.200    75.387     0.200
     5.308    76.585     0.200
     5.355    78.142     0.200
     5.596    80.760     0.200
     5.963    83.468     0.200
     6.179    88.414     0.200
     6.519    92.934     0.200
     6.969    92.794     0.200
     1.305    28.934     0.200
     2.915    49.019     0.200
     3.049    52.708     0.200
     3.347    56.803     0.200
     1.135    26.298     0.200
     1.182    27.701     0.200
     1.257    29.353     0.200
     1.489    28.348     0.200
     2.039    36.452     0.200
     2.941    45.848     0.200
     3.045    52.011     0.200
     3.057    51.187     0.200
     3.135    50.913     0.200
     3.135    51.318     0.200
     3.246    51.527     0.200
     3.246    52.691     0.200
     3.384    56.870     0.200
     3.480    55.792     0.200
     3.921    64.245     0.200
     4.107    64.668     0.200
     4.055    65.230     0.200
     4.475    67.198     0.200
     4.534    67.452     0.200
     4.534    68.566     0.200
     4.867    70.398     0.200
     4.867    70.002     0.200
     4.869    71.446     0.200
     5.160    73.762     0.200
     5.160    74.088     0.200
     5.208    75.350     0.200
     5.274    75.894     0.200
     5.334    77.260     0.200
     5.333    76.532     0.200
     5.333    76.067     0.200
     5.416    77.308     0.200
     5.458    78.254     0.200
     5.535    80.648     0.200
     5.652    80.791     0.200
     5.652    81.402     0.200
     5.706    82.515     0.200
     5.842    82.923     0.200
     5.886    83.417     0.200
     5.975    84.430     0.200
     5.975    85.235     0.200
     5.975    84.035     0.200
     6.417    89.755     0.200
     6.831    92.863     0.200
     0.951    21.551     0.200
     1.062    25.180     0.200
     1.249    25.915     0.200
     1.936    32.503     0.200
     1.998    34.311     0.200
     2.260    39.444     0.200
     2.516    41.249     0.200
     2.548    41.167     0.200
     2.859    44.921     0.200
     2.859    44.728     0.200
     3.121    48.716     0.200
     3.121    46.338     0.200
     3.534    55.002     0.200
     3.858    54.823     0.200
     3.867    61.955     0.200
     3.886    57.756     0.200
     3.899    55.705     0.200
     3.920    55.615     0.200
     3.920    56.154     0.200
     3.924    59.893     0.200
     4.025    56.173     0.200
     4.025    58.770     0.200
     4.153    59.043     0.200
     4.153    61.344     0.200
     4.212    60.430     0.200
     4.228    59.884     0.200
     4.231    62.626     0.200
     4.262    61.665     0.200
     4.364    60.252     0.200
     4.364    60.977     0.200
     4.346    63.665     0.200
     4.481    63.679     0.200
     4.482    63.432     0.200
     4.497    62.822     0.200
     4.728    66.955     0.200
     4.857    68.192     0.200
     4.908    68.292     0.200
     4.908    68.815     0.200
     4.997    69.295     0.200
     5.164    72.149     0.200
     5.164    71.933     0.200
     5.550    75.665     0.200
     5.582    74.998     0.200
     5.638    77.258     0.200
     5.871    83.317     0.200
     6.011    81.449     0.200
     6.049    82.181     0.200
     7.586    99.755     0.200
     1.180    27.475     0.200
     1.282    27.953     0.200
     2.973    46.750     0.200
     4.516    67.827     0.200
     4.565    67.857     0.200
     4.864    67.670     0.200
     4.866    67.649     0.200
     5.173    73.022     0.200
     5.207    71.958     0.200
     6.401    87.370     0.200
     6.426    88.253     0.200
     0.987    21.500     0.200
     2.508    41.860     0.200
     4.540    66.119     0.200
     5.278    74.630     0.200
     5.477    78.311     0.200
     6.053    81.108     0.200
     6.166    82.362     0.200
     6.183    82.777     0.200
     6.269    84.201     0.200
     6.292    86.408     0.200
     6.393    86.074     0.200
     6.450    85.852     0.200
     6.450    86.614     0.200
     6.536    88.829     0.200
     6.689    89.744     0.200
     6.699    88.283     0.200
     6.798    90.693     0.200
     6.828    90.115     0.200
     6.828    92.333     0.200
     6.878    92.203     0.200
     6.918    91.953     0.200
     7.026    93.393     0.200
     7.316    97.419     0.200
     7.576    99.616     0.200
     7.576   100.518     0.200
     7.813    98.166     0.200
     7.876   104.132     0.200
     8.009   105.910     0.200
     8.009   105.524     0.200
     8.105   106.609     0.200
     8.420   110.583     0.200
     8.522   111.574     0.200
     9.082   118.477     0.200
     9.797   128.279     0.200
    10.072   132.118     0.200
     1.412    28.782     0.200
     2.229    40.370     0.200
     2.204    39.877     0.200
     2.520    43.923     0.200
     3.276    53.601     0.200
     3.342    55.954     0.200
     4.590    69.556     0.200
     5.765    83.433     0.200
     2.076    39.701     0.200
     2.941    47.485     0.200
     2.941    48.791     0.200
     3.054    53.190     0.200
     3.217    52.348     0.200
     3.371    54.266     0.200
     3.960    65.694     0.200
     4.082    63.870     0.200
     4.466    67.999     0.200
     4.534    69.632     0.200
     4.534    68.467     0.200
     4.865    71.452     0.200
     4.865    71.828     0.200
     4.891    72.556     0.200
     5.173    76.649     0.200
     5.232    78.123     0.200
     5.365    77.683     0.200
     5.481    80.111     0.200
     5.662    82.304     0.200
     5.662    81.574     0.200
     5.904    84.166     0.200
     5.989    85.874     0.200
     1.201    26.662     0.200
     2.557    43.655     0.200
     2.692    45.409     0.200
     2.692    45.770     0.200
     2.817    47.817     0.200
     2.888    47.806     0.200
     3.543    54.789     0.200
     3.655    54.242     0.200
     4.377    65.841     0.200
     4.899    68.521     0.200
     4.899    68.988     0.200
     4.962    69.530     0.200
     5.002    69.699     0.200
     5.002    71.074     0.200
     5.009    70.258     0.200
     5.009    71.977     0.200
     5.158    72.271     0.200
     5.158    72.625     0.200
     5.158    75.768     0.200
     5.196    74.040     0.200
     5.255    72.036     0.200
     5.255    73.146     0.200
     5.262    74.181     0.200
     5.262    74.412     0.200
     5.281    73.651     0.200
     5.281    73.985     0.200
     5.480    76.207     0.200
     5.480    76.460     0.200
     5.485    76.345     0.200
     5.532    76.800     0.200
     5.574    78.763     0.200
     5.900    82.707     0.200
     5.998    85.012     0.200
     6.031    82.805     0.200
     6.031    84.627     0.200
     6.082    84.036     0.200
     6.186    85.262     0.200
     6.272    86.397     0.200
     6.272    88.368     0.200
     6.649    90.822     0.200
     6.714    92.199     0.200
     6.758    92.861     0.200
     7.113    97.177     0.200
     7.172    97.605     0.200
     7.180    96.168     0.200
     8.378   111.650     0.200
     9.105   121.805     0.200
     1.585    31.743     0.200
     1.765    33.942     0.200
     1.851    36.529     0.200
     2.419    43.336     0.200
     2.419    41.818     0.200
     2.560    45.827     0.200
     2.561    45.819     0.200
     2.936    50.332     0.200
     2.936    50.006     0.200
     3.011    47.926     0.200
     3.011    48.973     0.200
     3.370    55.133     0.200
     3.370    54.311     0.200
     3.477    58.478     0.200
     3.477    56.605     0.200
     3.590    56.246     0.200
     3.592    57.963     0.200
     4.116    65.905     0.200
     4.560    68.748     0.200
     4.601    70.886     0.200
     4.601    70.499     0.200
     4.697    70.172     0.200
     4.697    70.787     0.200
     4.858    71.716     0.200
     4.858    70.050     0.200
     4.869    71.982     0.200
     4.874    70.780     0.200
     5.194    75.767     0.200
     5.214    75.528     0.200
     5.214    76.456     0.200
     5.317    78.320     0.200
     5.317    80.583     0.200
     5.324    78.246     0.200
     5.465    79.248     0.200
     5.529    79.940     0.200
     5.694    82.142     0.200
     5.848    83.846     0.200
     5.908    83.761     0.200
     6.009    85.793     0.200
     6.009    85.625     0.200
     6.058    86.229     0.200
     6.443    93.030     0.200
     1.377    26.807     0.200
     1.946    32.994     0.200
     5.544    76.055     0.200
     5.558    76.253     0.200
     5.637    78.194     0.200
     5.658    77.371     0.200
     5.835    80.768     0.200
     5.903    81.475     0.200
     6.250    84.771     0.200
     6.296    85.684     0.200
     6.401    86.961     0.200
     6.709    91.078     0.200
     6.757    92.436     0.200
     7.184    92.142     0.200
     6.984    94.835     0.200
     7.522   101.200     0.200
     1.108    26.031     0.200
     1.180    27.802     0.200
     5.335    75.593     0.200
     5.432    75.986     0.200
     5.523    77.673     0.200
     6.054    83.749     0.200
     6.322    87.274     0.200
     7.335   100.074     0.200
     1.125    20.899     0.200
     1.709    26.517     0.200
     2.557    40.680     0.200
     2.670    39.854     0.200
     3.063    47.557     0.200
     3.327    48.371     0.200
     3.327    45.949     0.200
     3.458    48.375     0.200
     3.488    49.541     0.200
     4.030    57.598     0.200
     4.117    55.519     0.200
     4.207    57.358     0.200
     4.345    58.885     0.200
     4.345    59.033     0.200
     4.388    59.963     0.200
     4.378    59.869     0.200
     4.378    58.940     0.200
     4.423    59.338     0.200
     4.509    60.806     0.200
     4.660    63.746     0.200
     4.689    63.062     0.200
     4.689    62.711     0.200
     4.822    64.223     0.200
     4.904    66.805     0.200
     4.904    66.281     0.200
     5.110    67.974     0.200
     5.391    71.312     0.200
     6.238    81.925     0.200
     6.282    82.582     0.200
     2.136    37.018     0.200
     2.957    49.082     0.200
     3.020    49.178     0.200
     4.456    63.723     0.200
     4.487    65.195     0.200
     4.589    66.308     0.200
     4.832    69.731     0.200
     4.978    71.376     0.200
     5.110    72.411     0.200
     5.139    73.284     0.200
     5.316    74.219     0.200
     5.365    74.589     0.200
     5.540    78.376     0.200
     5.662    79.805     0.200
     5.716    78.788     0.200
     6.105    79.558     0.200
     6.411    88.880     0.200
     2.767    48.467     0.200
     4.751    68.485     0.200
     4.751    68.743     0.200
     4.805    69.743     0.200
     4.934    70.680     0.200
     4.934    72.141     0.200
     5.023    71.411     0.200
     5.023    73.794     0.200
     5.078    73.816     0.200
     5.127    75.103     0.200
     5.129    74.157     0.200
     5.293    74.160     0.200
     5.293    75.105     0.200
     5.353    76.511     0.200
     5.380    78.353     0.200
     5.752    81.187     0.200
     5.838    81.761     0.200
     6.936    95.808     0.200
     1.652    30.402     0.200
     1.977    37.944     0.200
     1.977    37.405     0.200
     2.177    37.474     0.200
     2.177    37.806     0.200
     2.367    42.057     0.200
     2.736    48.601     0.200
     2.840    49.954     0.200
     2.840    47.511     0.200
     2.947    49.961     0.200
     2.948    51.161     0.200
     3.606    56.807     0.200
     3.744    57.427     0.200
     3.786    56.179     0.200
     3.769    60.773     0.200
     3.961    58.529     0.200
     3.961    59.506     0.200
     3.961    59.379     0.200
     4.301    64.225     0.200
     4.281    64.274     0.200
     4.281    64.024     0.200
     4.515    67.713     0.200
     4.551    67.734     0.200
     4.935    72.067     0.200
     4.991    73.220     0.200
     4.881    75.843     0.200
     4.881    74.932     0.200
     5.282    76.950     0.200
     5.522    79.899     0.200
     5.952    84.950     0.200
     1.495    26.508     0.200
     1.568    29.053     0.200
     1.755    31.250     0.200
     4.044    58.067     0.200
     4.043    57.986     0.200
     4.384    62.472     0.200
     4.359    63.645     0.200
     5.071    72.212     0.200
     3.170    53.810     0.200
     3.817    62.714     0.200
     0.950    21.799     0.200
     1.081    22.685     0.200
     1.319    24.417     0.200
     2.515    42.160     0.200
     3.602    51.894     0.200
     3.602    54.824     0.200
     3.792    56.147     0.200
     4.496    62.004     0.200
     4.584    63.536     0.200
     4.584    64.193     0.200
     4.727    65.737     0.200
     4.727    65.495     0.200
     4.727    64.713     0.200
     4.805    66.772     0.200
     4.805    66.123     0.200
     4.888    67.197     0.200
     4.888    67.330     0.200
     4.888    66.884     0.200
     5.010    68.585     0.200
     5.010    68.460     0.200
     5.042    69.313     0.200
     5.135    70.444     0.200
     5.135    70.593     0.200
     5.185    70.093     0.200
     5.185    70.382     0.200
     5.195    70.842     0.200
     5.373    73.179     0.200
     5.491    74.417     0.200
     5.725    77.066     0.200
     5.725    78.128     0.200
     5.752    77.182     0.200
     5.752    77.964     0.200
     5.806    79.137     0.200
     5.954    81.090     0.200
     5.954    80.762     0.200
     6.286    85.712     0.200
     6.286    85.431     0.200
     6.466    87.103     0.200
     6.495    88.034     0.200
     6.495    87.519     0.200
     6.495    89.089     0.200
     6.563    87.045     0.200
     6.579    87.086     0.200
     6.777    91.173     0.200
     6.883    92.548     0.200
     0.974    22.545     0.200
     0.997    23.099     0.200
     1.056    25.089     0.200
     1.300    26.981     0.200
     1.457    28.157     0.200
     2.023    35.544     0.200
     2.469    42.270     0.200
     2.701    43.963     0.200
     2.701    43.230     0.200
     2.701    45.002     0.200
     2.890    47.611     0.200
     2.890    46.369     0.200
     3.173    47.782     0.200
     3.235    51.462     0.200
     3.322    51.196     0.200
     3.322    51.553     0.200
     3.546    55.026     0.200
     3.546    54.781     0.200
     3.742    57.345     0.200
     3.742    57.649     0.200
     3.767    58.698     0.200
     3.769    58.556     0.200
     3.793    56.551     0.200
     3.764    57.579     0.200
     4.283    62.754     0.200
     4.399    66.179     0.200
     4.729    70.015     0.200
     4.729    69.774     0.200
     4.836    67.944     0.200
     4.980    69.771     0.200
     4.980    70.422     0.200
     4.981    69.757     0.200
     4.981    69.137     0.200
     4.991    68.604     0.200
     4.991    69.142     0.200
     5.330    74.134     0.200
     5.330    73.711     0.200
     5.332    74.112     0.200
     5.357    77.826     0.200
     5.424    75.660     0.200
     5.581    77.135     0.200
     5.537    79.963     0.200
     5.537    80.212     0.200
     5.633    78.309     0.200
     5.837    80.577     0.200
     5.837    80.886     0.200
     6.036    83.200     0.200
     6.146    83.156     0.200
     6.146    83.427     0.200
     6.279    88.314     0.200
     6.575    89.950     0.200
     0.818    20.423     0.200
     0.936    22.558     0.200
     0.872    21.927     0.200
     1.622    29.870     0.200
     1.879    32.794     0.200
     1.882    33.405     0.200
     2.285    38.290     0.200
     2.310    39.900     0.200
     2.503    41.472     0.200
     3.000    47.328     0.200
     3.162    49.377     0.200
     3.448    54.382     0.200
     3.502    56.368     0.200
     3.546    55.129     0.200
     4.636    65.935     0.200
     4.636    65.619     0.200
     4.767    67.594     0.200
     4.767    67.215     0.200
     4.772    67.247     0.200
     4.772    67.603     0.200
     4.780    67.798     0.200
     4.780    67.282     0.200
     5.118    71.075     0.200
     5.118    71.622     0.200
     5.130    70.932     0.200
     5.130    72.069     0.200
     5.196    74.100     0.200
     5.196    74.744     0.200
     5.196    73.072     0.200
     5.348    75.338     0.200
     5.370    74.694     0.200
     5.419    76.911     0.200
     5.419    75.157     0.200
     5.457    79.848     0.200
     5.618    78.053     0.200
     5.640    78.859     0.200
     5.640    78.441     0.200
     5.752    79.676     0.200
     5.944    81.108     0.200
     5.944    81.503     0.200
     5.944    82.300     0.200
     5.973    82.475     0.200
     6.109    85.242     0.200
     6.370    88.255     0.200
     6.373    87.294     0.200
     6.634    91.391     0.200
     6.760    91.699     0.200
     6.800    92.676     0.200
     1.873    34.310     0.200
     4.819    68.128     0.200
     4.831    67.964     0.200
     5.176    72.952     0.200
     5.251    75.023     0.200
     5.264    73.646     0.200
     5.803    80.408     0.200
     1.118    26.063     0.200
     1.245    27.504     0.200
     2.042    36.598     0.200
     2.387    41.795     0.200
     2.420    40.494     0.200
     2.624    43.750     0.200
     2.624    43.438     0.200
     2.896    47.458     0.200
     2.896    46.981     0.200
     3.197    50.883     0.200
     3.292    53.187     0.200
     3.292    51.792     0.200
     3.429    55.187     0.200
     3.429    55.640     0.200
     3.561    54.978     0.200
     3.590    54.789     0.200
     3.591    58.533     0.200
     3.840    56.377     0.200
     3.840    57.109     0.200
     3.840    58.008     0.200
     3.889    56.582     0.200
     3.889    55.961     0.200
     3.907    58.298     0.200
     3.907    58.125     0.200
     3.918    56.163     0.200
     3.918    57.109     0.200
     3.862    59.030     0.200
     4.079    61.091     0.200
     4.183    61.951     0.200
     4.193    60.060     0.200
     4.193    62.628     0.200
     4.193    63.091     0.200
     4.193    61.089     0.200
     4.215    60.099     0.200
     4.215    61.749     0.200
     4.215    61.927     0.200
     4.231    62.890     0.200
     4.231    63.361     0.200
     4.225    61.928     0.200
     4.225    62.723     0.200
     4.255    63.466     0.200
     4.380    61.382     0.200
     4.380    61.541     0.200
     4.454    65.499     0.200
     4.454    65.169     0.200
     4.467    62.658     0.200
     4.467    65.627     0.200
     4.467    64.572     0.200
     4.493    66.645     0.200
     4.713    69.364     0.200
     4.929    69.043     0.200
     4.929    69.348     0.200
     5.004    72.193     0.200
     5.109    72.205     0.200
     5.175    72.124     0.200
     5.175    71.952     0.200
     5.175    72.579     0.200
     5.552    77.063     0.200
     5.552    76.758     0.200
     5.612    77.821     0.200
     5.598    79.735     0.200
     5.636    78.582     0.200
     5.657    77.853     0.200
     5.793    79.674     0.200
     5.793    80.676     0.200
     5.795    81.773     0.200
     5.855    82.178     0.200
     5.855    82.672     0.200
     5.855    81.037     0.200
     6.019    82.776     0.200
     6.088    83.778     0.200
     7.323    98.151     0.200
     8.008   107.303     0.200
     8.008   109.014     0.200
     1.825    34.971     0.200
     1.934    36.698     0.200
     2.073    37.308     0.200
     2.348    42.468     0.200
     2.808    48.582     0.200
     5.543    77.705     0.200
     5.543    77.861     0.200
     5.633    79.511     0.200
     5.667    80.478     0.200
     5.667    81.423     0.200
     5.826    80.954     0.200
     5.826    81.301     0.200
     6.065    83.882     0.200
     6.122    85.527     0.200
     6.215    84.866     0.200
     6.293    85.954     0.200
     6.401    87.806     0.200
     6.327    89.184     0.200
     6.790    93.095     0.200
     6.958    94.415     0.200
     7.188    93.471     0.200
     7.126    98.829     0.200
     7.253    98.889     0.200
     7.490   101.996     0.200
     1.224    25.635     0.200
     1.278    26.512     0.200
     1.816    32.754     0.200
     1.898    34.421     0.200
     2.465    39.913     0.200
     2.765    45.461     0.200
     3.053    48.286     0.200
     3.179    49.676     0.200
     3.941    58.450     0.200
     4.078    57.989     0.200
     4.096    58.519     0.200
     4.478    63.538     0.200
     4.684    65.709     0.200
     4.727    66.469     0.200
     5.066    70.379     0.200
     5.288    74.299     0.200
     5.702    79.608     0.200
     5.734    78.221     0.200
     1.048    25.140     0.200
     1.133    25.124     0.200
     1.882    33.531     0.200
     2.167    37.730     0.200
     2.593    44.046     0.200
     2.770    47.263     0.200
     3.468    55.806     0.200
     3.638    56.170     0.200
     4.377    63.598     0.200
     5.225    73.854     0.200
     5.225    72.387     0.200
     5.325    74.636     0.200
     5.325    74.427     0.200
     5.512    77.050     0.200
     5.401    76.240     0.200
     5.407    76.518     0.200
     5.407    75.660     0.200
     5.471    76.838     0.200
     5.500    78.377     0.200
     5.500    77.648     0.200
     5.620    77.059     0.200
     5.512    79.431     0.200
     5.620    78.813     0.200
     5.620    78.297     0.200
     5.798    80.079     0.200
     5.742    80.619     0.200
     5.742    81.504     0.200
     5.798    80.466     0.200
     5.956    81.411     0.200
     5.864    81.724     0.200
     5.864    81.619     0.200
     5.975    83.300     0.200
     5.955    83.169     0.200
     5.956    82.950     0.200
     5.975    83.778     0.200
     6.211    85.271     0.200
     6.526    88.747     0.200
     6.526    90.577     0.200
     6.542    90.851     0.200
     6.716    92.981     0.200
     6.716    93.618     0.200
     7.004    90.598     0.200
     6.758    92.736     0.200
     7.236    98.823     0.200
     7.352   100.184     0.200
     7.361    99.301     0.200
     7.531   102.621     0.200
     7.546   102.401     0.200
     7.652   104.021     0.200
     7.771   106.836     0.200
     8.914   120.442     0.200
     8.914   119.800     0.200
     1.298    30.428     0.200
     1.870    36.832     0.200
     2.356    44.718     0.200
     2.609    47.717     0.200
     2.602    48.115     0.200
     2.691    47.710     0.200
     2.684    46.566     0.200
     2.691    47.967     0.200
     2.907    49.711     0.200
     3.080    52.574     0.200
     3.058    50.577     0.200
     3.588    60.087     0.200
     4.023    64.629     0.200
     4.023    60.637     0.200
     4.267    67.027     0.200
     4.267    66.302     0.200
     4.447    69.036     0.200
     4.605    72.011     0.200
     5.150    77.708     0.200
     5.559    82.892     0.200
     5.512    82.014     0.200
     5.697    83.791     0.200
     5.697    82.516     0.200
     5.811    84.268     0.200
     5.811    84.648     0.200
     5.829    83.209     0.200
     5.829    83.336     0.200
     5.832    82.576     0.200
     6.168    87.290     0.200
     6.168    87.989     0.200
     6.196    88.707     0.200
     6.185    89.850     0.200
     6.192    88.194     0.200
     6.213    90.689     0.200
     6.213    89.536     0.200
     6.213    90.152     0.200
     6.192    86.469     0.200
     6.238    88.647     0.200
     6.238    88.751     0.200
     6.406    92.619     0.200
     6.420    90.458     0.200
     6.453    91.255     0.200
     6.453    93.176     0.200
     6.669    94.997     0.200
     6.699    95.708     0.200
     6.801    95.782     0.200
     7.006   100.348     0.200
     7.006    96.956     0.200
     7.030    98.931     0.200
     7.431   103.649     0.200
     7.432   104.059     0.200
     7.862   108.318     0.200
     1.100    25.604     0.200
     1.337    30.794     0.200
     1.340    31.116     0.200
     1.685    33.128     0.200
     2.026    36.051     0.200
     2.276    39.576     0.200
     2.411    42.261     0.200
     2.562    42.460     0.200
     2.843    46.897     0.200
     2.924    48.459     0.200
     3.037    51.552     0.200
     3.108    52.050     0.200
     3.187    54.211     0.200
     3.505    56.877     0.200
     3.557    57.255     0.200
     3.813    62.216     0.200
     4.193    64.771     0.200
     4.429    67.528     0.200
     4.332    69.781     0.200
     4.534    71.438     0.200
     4.665    69.923     0.200
     4.913    71.959     0.200
     4.959    72.605     0.200
     4.959    72.180     0.200
     4.858    75.110     0.200
     4.983    73.912     0.200
     5.165    75.228     0.200
     5.301    77.215     0.200
     5.301    76.711     0.200
     5.478    78.100     0.200
     5.478    80.315     0.200
     5.496    78.551     0.200
     5.496    77.553     0.200
     5.627    80.922     0.200
     5.666    81.992     0.200
     5.794    83.937     0.200
     5.931    85.229     0.200
     5.977    84.789     0.200
     6.098    86.744     0.200
     6.351    90.036     0.200
     6.264    91.586     0.200
     6.441    90.839     0.200
     6.441    91.089     0.200
     6.735    94.006     0.200
     6.830    96.367     0.200
     1.125    25.419     0.200
     1.411    25.617     0.200
     2.222    35.664     0.200
     2.698    42.625     0.200
     2.698    42.156     0.200
     3.170    49.259     0.200
     3.201    49.533     0.200
     3.946    63.690     0.200
     3.964    63.825     0.200
     3.995    59.426     0.200
     4.108    65.102     0.200
     4.282    64.206     0.200
     4.282    62.507     0.200
     4.508    63.192     0.200
     4.519    63.417     0.200
     4.519    62.837     0.200
     4.519    64.081     0.200
     4.524    63.548     0.200
     4.524    64.403     0.200
     4.849    67.942     0.200
     4.849    69.287     0.200
     4.863    67.996     0.200
     4.863    69.219     0.200
     4.970    70.051     0.200
     4.975    68.297     0.200
     4.975    70.961     0.200
     5.353    75.991     0.200
     5.353    74.011     0.200
     5.663    77.828     0.200
     5.663    78.802     0.200
     5.663    78.481     0.200
     5.708    80.545     0.200
     6.096    85.479     0.200
     1.990    33.547     0.200
     3.473    48.930     0.200
     3.509    49.166     0.200
     3.840    53.473     0.200
     3.967    55.097     0.200
     4.092    56.098     0.200
     4.470    62.153     0.200
     4.602    63.403     0.200
     4.723    64.689     0.200
     4.767    66.284     0.200
     5.154    70.500     0.200
     0.825    19.019     0.200
     2.042    34.298     0.200
     2.671    41.803     0.200
     2.873    45.808     0.200
     3.041    46.985     0.200
     2.938    48.068     0.200
     1.731    32.606     0.200
     1.968    35.672     0.200
     2.500    40.678     0.200
     3.458    55.430     0.200
     3.568    55.003     0.200
     3.910    59.203     0.200
     4.827    67.143     0.200
     4.888    68.282     0.200
     5.072    70.652     0.200
     5.175    73.355     0.200
     5.188    72.685     0.200
     5.400    74.016     0.200
     5.460    76.240     0.200
     5.828    80.758     0.200
     5.950    81.163     0.200
     6.194    85.306     0.200
     0.826    20.724     0.200
     2.469    40.541     0.200
     2.594    39.413     0.200
     3.579    50.209     0.200
     3.596    51.196     0.200
     3.606    51.423     0.200
     3.644    54.690     0.200
     3.788    52.023     0.200
     3.907    55.585     0.200
     3.957    55.141     0.200
     4.047    57.186     0.200
     4.159    57.451     0.200
     4.619    62.785     0.200
     4.754    65.101     0.200
     5.240    71.385     0.200
     0.961    21.220     0.200
     3.139    49.336     0.200
     4.126    57.816     0.200
     4.183    58.352     0.200
     4.183    58.024     0.200
     4.227    57.541     0.200
     4.227    59.002     0.200
     4.449    60.661     0.200
     4.449    62.872     0.200
     4.409    59.115     0.200
     4.409    60.279     0.200
     4.497    63.390     0.200
     4.505    60.902     0.200
     4.505    62.761     0.200
     4.552    62.752     0.200
     4.552    62.955     0.200
     4.697    63.559     0.200
     4.725    64.748     0.200
     5.250    70.611     0.200
     5.250    71.392     0.200
     5.324    74.100     0.200
     5.488    72.927     0.200
     5.488    75.552     0.200
     5.857    78.355     0.200
     5.940    79.159     0.200
     5.967    79.190     0.200
     1.552    27.556     0.200
     2.288    36.561     0.200
     2.288    37.823     0.200
     2.658    43.052     0.200
     2.829    45.003     0.200
     2.895    46.344     0.200
     3.679    58.741     0.200
     3.873    56.599     0.200
     4.092    57.151     0.200
     4.092    57.238     0.200
     4.557    66.026     0.200
     4.683    65.268     0.200
     4.916    68.337     0.200
     5.122    71.412     0.200
     1.323    29.920     0.200
     1.445    29.206     0.200
     3.109    52.269     0.200
     3.618    60.815     0.200
     5.350    75.811     0.200
     5.433    78.930     0.200
     5.900    84.186     0.200
     6.569    93.412     0.200
     0.950    22.406     0.200
     1.290    27.613     0.200
     1.567    29.103     0.200
     1.912    33.951     0.200
     2.969    49.874     0.200
     3.500    54.345     0.200
     3.794    55.823     0.200
     3.794    56.886     0.200
     3.841    56.292     0.200
     3.841    57.370     0.200
     4.313    61.107     0.200
     4.313    61.435     0.200
     4.428    62.392     0.200
     4.458    64.285     0.200
     4.458    63.051     0.200
     4.502    64.010     0.200
     4.520    64.154     0.200
     4.520    65.037     0.200
     4.515    65.999     0.200
     4.559    63.143     0.200
     4.693    66.194     0.200
     4.693    65.866     0.200
     4.711    67.401     0.200
     4.711    66.815     0.200
     4.803    67.766     0.200
     4.865    70.659     0.200
     4.877    69.838     0.200
     5.113    71.817     0.200
     5.346    73.959     0.200
     5.346    73.631     0.200
     5.526    78.368     0.200
     5.690    77.233     0.200
     5.848    80.870     0.200
     6.138    84.546     0.200
     6.182    83.770     0.200
     6.273    85.589     0.200
     6.623    88.457     0.200
     6.713    89.780     0.200
     6.925    92.680     0.200
     6.997    95.515     0.200
     7.809   103.621     0.200
     8.543   113.295     0.200
     4.539    71.028     0.200
     4.780    71.064     0.200
     4.910    72.135     0.200
     5.126    73.236     0.200
     5.202    76.229     0.200
     5.307    75.778     0.200
     5.411    76.376     0.200
     5.468    82.707     0.200
     5.527    79.428     0.200
     5.530    78.614     0.200
     5.639    81.747     0.200
     5.639    79.423     0.200
     5.791    81.623     0.200
     6.076    87.255     0.200
     6.146    85.399     0.200
     6.379    88.888     0.200
     6.364    90.940     0.200
     6.684    89.484     0.200
     6.766    91.105     0.200
     6.791    94.181     0.200
     6.944    93.428     0.200
     6.952    95.408     0.200
     6.996    92.818     0.200
     7.097   101.479     0.200
     7.170    97.551     0.200
     7.240   100.594     0.200
     7.357   101.554     0.200
     7.531   100.295     0.200
     7.636   101.399     0.200
     7.692   104.370     0.200
     7.744   104.287     0.200
     7.941   107.162     0.200
     7.941   107.897     0.200
     7.942   106.628     0.200
     8.084   111.186     0.200
     8.465   113.986     0.200
     8.457   119.856     0.200
     8.830   117.494     0.200
     8.873   116.732     0.200
     9.028   119.844     0.200
     9.110   122.245     0.200
     9.193   124.649     0.200
     9.250   121.351     0.200
     9.420   125.362     0.200
     9.454   126.514     0.200
     9.503   125.689     0.200
     9.529   127.716     0.200
     9.502   132.170     0.200
     9.543   127.545     0.200
     9.592   128.788     0.200
     9.619   127.430     0.200
     9.645   127.129     0.200
     9.673   129.131     0.200
     9.676   128.323     0.200
     9.733   129.983     0.200
     2.911    48.297     0.200
     3.058    50.190     0.200
     3.588    53.888     0.200
     3.802    56.643     0.200
     3.802    59.613     0.200
     3.933    58.099     0.200
     4.002    60.416     0.200
     4.079    60.217     0.200
     4.142    63.780     0.200
     4.189    61.207     0.200
     4.189    62.130     0.200
     4.282    61.827     0.200
     4.438    66.096     0.200
     4.455    64.072     0.200
     4.455    65.015     0.200
     4.680    67.777     0.200
     4.801    69.293     0.200
     4.801    70.553     0.200
     5.019    71.819     0.200
     5.102    74.105     0.200
     5.229    73.634     0.200
     5.229    74.771     0.200
     5.572    79.695     0.200
     5.736    81.291     0.200
     1.806    31.776     0.200
     1.913    34.470     0.200
     2.739    46.875     0.200
     2.739    44.015     0.200
     2.866    46.926     0.200
     3.272    53.454     0.200
     3.272    51.993     0.200
     3.295    49.884     0.200
     3.410    51.372     0.200
     3.641    54.132     0.200
     3.744    56.188     0.200
     3.747    57.325     0.200
     3.747    56.911     0.200
     3.902    59.418     0.200
     3.902    58.746     0.200
     4.142    60.118     0.200
     4.160    64.076     0.200
     4.160    62.547     0.200
     4.269    62.536     0.200
     4.270    64.536     0.200
     4.672    65.986     0.200
     4.672    67.136     0.200
     4.731    67.770     0.200
     4.731    66.865     0.200
     4.731    67.289     0.200
     4.765    69.057     0.200
     4.765    67.175     0.200
     4.767    68.630     0.200
     4.767    67.596     0.200
     4.910    70.272     0.200
     4.910    69.327     0.200
     4.930    72.019     0.200
     4.985    70.974     0.200
     4.985    70.242     0.200
     4.985    71.648     0.200
     4.994    72.016     0.200
     5.017    72.685     0.200
     5.017    71.898     0.200
     5.038    70.905     0.200
     5.052    72.511     0.200
     5.052    70.995     0.200
     5.052    73.429     0.200
     5.238    71.920     0.200
     5.238    73.670     0.200
     5.267    75.186     0.200
     5.303    75.860     0.200
     5.303    73.907     0.200
     5.341    75.735     0.200
     5.548    79.141     0.200
     5.673    78.582     0.200
     5.673    81.133     0.200
     5.758    82.416     0.200
     5.787    81.496     0.200
     5.787    79.506     0.200
     5.847    81.793     0.200
     5.847    82.244     0.200
     5.953    84.242     0.200
     6.032    84.166     0.200
     6.032    82.940     0.200
     6.032    83.614     0.200
     6.199    89.935     0.200
     6.404    88.605     0.200
     6.404    89.512     0.200
     6.405    87.666     0.200
     6.466    88.926     0.200
     6.515    89.678     0.200
     6.570    89.296     0.200
     6.686    92.989     0.200
     6.686    91.827     0.200
     6.686    93.327     0.200
     6.874    94.325     0.200
     6.928    94.487     0.200
     6.932    93.838     0.200
     7.390   100.091     0.200
     7.479   102.287     0.200
     7.510   101.867     0.200
     8.032   110.726     0.200
     8.131   109.339     0.200
     8.131   110.039     0.200
     8.357   112.877     0.200
     8.723   115.349     0.200
     8.858   117.977     0.200
     2.538    40.229     0.200
     2.538    38.678     0.200
     2.748    42.748     0.200
     2.748    40.633     0.200
     2.987    44.401     0.200
     2.987    44.073     0.200
     3.127    47.545     0.200
     3.127    44.607     0.200
     3.250    46.626     0.200
     3.353    50.704     0.200
     3.605    49.380     0.200
     3.741    58.103     0.200
     4.048    55.357     0.200
     4.081    58.792     0.200
     4.081    56.406     0.200
     4.125    57.061     0.200
     4.125    56.785     0.200
     4.140    58.157     0.200
     4.147    57.167     0.200
     4.147    56.544     0.200
     4.146    56.778     0.200
     4.146    55.331     0.200
     4.146    57.204     0.200
     4.482    60.974     0.200
     4.482    61.255     0.200
     4.482    61.515     0.200
     4.504    62.491     0.200
     4.538    61.681     0.200
     4.538    61.069     0.200
     4.542    62.675     0.200
     4.559    63.550     0.200
     4.724    64.596     0.200
     4.734    63.883     0.200
     4.771    64.875     0.200
     4.771    65.582     0.200
     4.982    68.112     0.200
     5.063    68.777     0.200
     5.063    68.201     0.200
     5.115    69.300     0.200
     5.213    70.399     0.200
     5.213    70.534     0.200
     5.291    73.225     0.200
     5.348    71.613     0.200
     5.348    71.011     0.200
     5.348    72.519     0.200
     5.348    72.978     0.200
     5.759    77.190     0.200
     5.796    78.169     0.200
     6.124    82.510     0.200
     6.201    83.627     0.200
     7.612   100.277     0.200
     1.822    32.785     0.200
     2.734    44.234     0.200
     3.511    51.400     0.200
     3.511    52.388     0.200
     3.388    53.208     0.200
     3.579    51.956     0.200
     3.579    52.729     0.200
     3.627    53.974     0.200
     3.681    52.781     0.200
     3.819    56.911     0.200
     3.959    57.419     0.200
     4.100    58.095     0.200
     4.146    60.199     0.200
     4.146    61.406     0.200
     4.137    59.903     0.200
     4.174    60.403     0.200
     4.389    63.746     0.200
     4.512    65.877     0.200
     4.700    66.664     0.200
     4.803    69.322     0.200
     4.916    67.960     0.200
     4.916    69.890     0.200
     5.267    74.458     0.200
     5.267    74.744     0.200
     5.510    75.899     0.200
     5.551    75.121     0.200
     5.748    80.022     0.200
     6.269    87.423     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.526    49.827     0.200
     2.591    55.072     0.200
     2.600    52.960     0.200
     3.212    68.817     0.200
     4.327    84.806     0.200
     5.619   114.732     0.200
     2.525    51.522     0.200
     2.882    55.781     0.200
     2.882    60.281     0.200
     3.963    78.169     0.200
     2.751    53.015     0.200
     2.760    52.406     0.200
     5.042    99.278     0.200
     9.343   183.091     0.200
     3.055    64.564     0.200
     2.580    51.437     0.200
     5.588   113.911     0.200
     2.721    58.318     0.200
     4.427    95.934     0.200
    19.960   390.593     0.200
    19.813   388.104     0.200
    20.012   390.116     0.200
    25.219   504.568     0.200
     2.674    51.980     0.200
     3.159    60.373     0.200
     2.525    49.107     0.200
     2.672    51.815     0.200
     2.766    52.857     0.200
     2.546    49.989     0.200
     2.558    51.548     0.200
     2.794    53.582     0.200
     3.472    66.882     0.200
     2.817    56.861     0.200
     3.503    67.765     0.200
     2.550    49.753     0.200
     2.526    49.282     0.200
     3.220    62.567     0.200
     2.514    48.887     0.200
     2.723    54.452     0.200
     2.597    49.881     0.200
     3.242    64.081     0.200
     2.574    50.965     0.200
     3.003    57.950     0.200
     3.436    68.026     0.200
     4.163    79.055     0.200
     4.296    85.786     0.200
     2.980    57.503     0.200
     3.034    63.044     0.200
     2.507    47.798     0.200
     2.547    48.622     0.200
     3.004    58.570     0.200
     3.345    64.590     0.200
     3.440    65.839     0.200
     4.161    78.391     0.200
     4.291    85.705     0.200
     2.703    52.465     0.200
     2.506    51.040     0.200
     2.657    51.402     0.200
     2.877    56.006     0.200
     3.121    60.604     0.200
     2.770    54.458     0.200
     2.947    56.132     0.200
     2.689    52.129     0.200
     2.775    54.243     0.200
     3.821    73.616     0.200
     2.968    59.597     0.200
     3.629    69.918     0.200
     4.067    79.046     0.200
     2.494    48.196     0.200
     3.342    65.304     0.200
     2.902    61.884     0.200
     2.794    54.243     0.200
     3.402    69.547     0.200
     2.719    52.276     0.200
     2.724    53.831     0.200
     2.814    54.526     0.200
     2.553    49.456     0.200
     3.038    58.424     0.200
     2.991    57.688     0.200
     2.768    53.310     0.200
     2.591    51.491     0.200
     2.758    53.390     0.200
     3.093    60.677     0.200
     2.737    52.510     0.200
     3.074    59.242     0.200
     2.748    54.557     0.200
     2.735    52.475     0.200
     2.626    50.563     0.200
     2.760    53.547     0.200
     2.873    59.036     0.200
     3.095    59.298     0.200
     2.704    52.379     0.200
     2.675    51.732     0.200
     3.011    58.023     0.200
     2.556    49.698     0.200
     2.718    52.256     0.200
     2.502    48.157     0.200
     2.545    50.876     0.200
     2.530    49.907     0.200
     2.867    55.015     0.200
     3.093    59.143     0.200
     2.592    49.340     0.200
     2.640    51.506     0.200
     2.715    52.836     0.200
     2.721    51.405     0.200
     2.565    49.973     0.200
     2.628    51.229     0.200
     2.644    51.363     0.200
     2.979    57.295     0.200
     2.597    50.581     0.200
     2.584    49.133     0.200
     3.090    59.484     0.200
     2.811    55.283     0.200
     2.549    50.445     0.200
     2.691    58.156     0.200
     3.058    63.227     0.200
     3.296    68.923     0.200
     3.588    71.509     0.200
     2.670    52.104     0.200
     2.763    54.462     0.200
     3.644    71.975     0.200
     4.111    81.734     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.146    44.948     0.200
     0.614    15.168     0.200
     2.016    40.801     0.200
     1.828    35.591     0.200
     2.357    48.909     0.200
     0.189     6.918     0.200
     1.506    31.544     0.200
     3.206    54.707     0.200
     4.058    70.765     0.200
     5.042    87.778     0.200
     7.300   130.031     0.200
     0.603    16.181     0.200
     1.183    17.910     0.200
     1.183    21.410     0.200
     1.569    31.907     0.200
     1.801    37.701     0.200
     2.598    47.900     0.200
     7.009   127.422     0.200
     0.609    13.946     0.200
     1.205    21.484     0.200
     4.572    80.391     0.200
     7.010   126.739     0.200
     1.604    35.100     0.200
     1.940    39.181     0.200
     4.599    81.145     0.200
     0.149     7.451     0.200
     0.701    15.504     0.200
     1.839    34.726     0.200
     0.827    19.553     0.200
     0.998    21.454     0.200
     0.764    16.501     0.200
     0.899    20.421     0.200
     1.054    23.916     0.200
     0.523    11.743     0.200
     1.198    25.365     0.200
     1.557    30.680     0.200
     1.704    32.957     0.200
     1.660    32.974     0.200
     1.879    37.426     0.200
     1.917    37.575     0.200
     1.867    36.561     0.200
     2.434    44.941     0.200
     0.646    15.050     0.200
     0.746    17.884     0.200
     0.943    19.594     0.200
     1.486    28.753     0.200
     1.642    31.935     0.200
     0.215     5.361     0.200
     0.274     7.168     0.200
     0.274     7.668     0.200
     0.274     8.668     0.200
     0.826    19.731     0.200
     1.138    24.585     0.200
     1.644    32.684     0.200
     1.738    34.081     0.200
     2.046    38.988     0.200
     2.950    54.445     0.200
     0.645    15.131     0.200
     0.956    19.511     0.200
     1.297    27.024     0.200
     1.652    32.886     0.200
     1.875    34.786     0.200
     0.220     6.450     0.200
     0.658    15.836     0.200
     0.792    18.072     0.200
     1.921    36.799     0.200
     2.110    38.899     0.200
     2.329    41.833     0.200
     0.756    17.625     0.200
     1.890    38.400     0.200
     2.010    41.002     0.200
     2.010    42.002     0.200
     2.010    43.002     0.200
     0.700    15.680     0.200
     1.693    34.098     0.200
     2.472    47.000     0.200
     0.783    18.151     0.200
     0.783    19.151     0.200
     1.799    34.797     0.200
     2.683    49.481     0.200
     0.906    19.969     0.200
     2.317    42.492     0.200
     0.667    16.166     0.200
     0.456    11.733     0.200
     2.064    37.978     0.200
     0.750    17.013     0.200
     1.359    27.899     0.200
     1.247    24.579     0.200
     5.071    86.225     0.200
     0.577    14.190     0.200
     0.610    14.069     0.200
     1.414    28.397     0.200
     1.374    28.993     0.200
     1.378    28.898     0.200
     1.549    31.600     0.200
     1.153    26.174     0.200
     1.243    27.125     0.200
     2.103    41.085     0.200
     2.301    44.778     0.200
     0.167     6.204     0.200
     1.262    22.924     0.200
     1.666    33.216     0.200
     1.801    36.140     0.200
     1.979    38.350     0.200
     1.984    38.307     0.200
     1.990    36.615     0.200
     2.368    43.518     0.200
     3.111    55.275     0.200
     3.355    57.414     0.200
     1.599    31.720     0.200
     1.920    37.443     0.200
     1.930    36.032     0.200
     1.852    36.770     0.200
     2.421    45.134     0.200
     0.424    10.165     0.200
     1.087    25.433     0.200
     1.792    38.199     0.200
     0.140     4.634     0.200
     0.461    10.891     0.200
     1.047    23.046     0.200
     1.508    33.671     0.200
     0.130     5.959     0.200
     0.390     9.922     0.200
     1.055    23.162     0.200
     1.214    25.307     0.200
     1.880    39.030     0.200
     0.798    18.059     0.200
     1.110    25.410     0.200
     1.748    36.970     0.200
     2.419    47.143     0.200
     2.665    50.772     0.200
     2.592    47.117     0.200
     0.562    13.054     0.200
     1.713    33.619     0.200
     0.946    21.421     0.200
     1.051    23.195     0.200
     1.402    30.104     0.200
     1.735    33.213     0.200
     1.855    35.814     0.200
     2.064    38.374     0.200
     0.766    18.670     0.200
     0.855    18.631     0.200
     1.155    24.130     0.200
     1.352    27.837     0.200
     1.455    29.630     0.200
     1.656    33.287     0.200
     2.121    38.860     0.200
     0.804    19.520     0.200
     1.049    22.661     0.200
     1.506    32.325     0.200
     2.181    41.448     0.200
     0.842    18.215     0.200
     0.976    20.154     0.200
     1.280    26.602     0.200
     1.757    33.542     0.200
     2.036    37.784     0.200
     0.313    10.886     0.200
     0.815    18.023     0.200
     0.947    20.483     0.200
     1.082    21.903     0.200
     1.263    25.794     0.200
     0.765    17.089     0.200
     0.771    18.521     0.200
     0.996    21.399     0.200
     1.529    30.181     0.200
     0.843    19.036     0.200
     0.926    21.278     0.200
     1.337    29.269     0.200
     1.643    32.707     0.200
     1.966    38.938     0.200
     2.091    39.468     0.200
     2.412    42.726     0.200
     0.104     4.362     0.200
     0.866    21.465     0.200
     1.036    24.475     0.200
     1.918    37.689     0.200
     0.926    21.722     0.200
     1.332    27.782     0.200
     1.625    32.361     0.200
     4.099    74.488     0.200
     4.657    83.976     0.200
     7.055   124.133     0.200
     1.064    22.205     0.200
     2.933    51.572     0.200
     0.212     7.058     0.200
     0.569    13.895     0.200
     1.053    24.238     0.200
     1.485    31.207     0.200
     2.414    43.363     0.200
     0.117     6.957     0.200
     1.987    36.631     0.200
     0.345     7.561     0.200
     0.603    15.548     0.200
     1.008    23.817     0.200
     0.977    21.265     0.200
     0.471    13.367     0.200
     1.088    22.172     0.200
     1.290    24.808     0.200
     1.639    32.682     0.200
     2.254    39.739     0.200
     2.404    43.910     0.200
     2.409    43.856     0.200
     2.417    43.937     0.200
     3.429    57.241     0.200
     0.599    13.698     0.200
     0.599    14.198     0.200
     1.028    25.198     0.200
     1.232    28.315     0.200
     0.148     3.207     0.200
     0.305     8.373     0.200
     0.970    21.609     0.200
     1.284    26.946     0.200
     1.643    33.822     0.200
     1.868    37.126     0.200
     0.775    17.519     0.200
     0.964    20.314     0.200
     1.270    25.743     0.200
     2.327    41.409     0.200
     0.553    12.258     0.200
     0.537    12.446     0.200
     1.181    25.929     0.200
     1.439    29.916     0.200
     1.657    33.377     0.200
     1.807    35.628     0.200
     2.099    41.413     0.200
     0.258     8.718     0.200
     0.757    18.897     0.200
     1.197    23.263     0.200
     1.404    27.353     0.200
     1.633    32.673     0.200
     1.820    35.497     0.200
     1.773    35.045     0.200
     2.010    36.274     0.200
     2.119    39.004     0.200
     0.285     9.146     0.200
     1.537    30.527     0.200
     1.530    32.607     0.200
     1.701    32.616     0.200
     1.600    32.389     0.200
     1.667    34.215     0.200
     1.979    39.369     0.200
     0.286     7.950     0.200
     0.518    12.750     0.200
     1.541    31.811     0.200
     1.553    32.670     0.200
     0.464    12.392     0.200
     0.581    14.036     0.200
     1.087    24.626     0.200
     1.240    27.847     0.200
     1.342    29.652     0.200
     0.250     7.073     0.200
     0.447    11.780     0.200
     0.714    15.660     0.200
     1.247    25.443     0.200
     1.471    29.823     0.200
     0.937    21.670     0.200
     1.336    29.016     0.200
     0.610    12.468     0.200
     0.610    13.468     0.200
     0.554    13.123     0.200
     0.554    14.123     0.200
     1.537    33.647     0.200
     1.630    33.569     0.200
     0.672    17.226     0.200
     0.807    17.648     0.200
     1.020    22.161     0.200
     1.152    23.627     0.200
     1.503    29.534     0.200
     1.642    31.903     0.200
     2.153    38.947     0.200
     0.233     5.896     0.200
     0.368    10.327     0.200
     0.308     9.155     0.200
     0.636    14.329     0.200
     0.917    21.051     0.200
     1.254    25.620     0.200
     0.844    19.659     0.200
     1.427    30.354     0.200
     0.779    18.470     0.200
     0.858    18.549     0.200
     1.045    20.366     0.200
     1.435    29.819     0.200
     1.914    37.230     0.200
     2.233    40.499     0.200
     0.301     7.027     0.200
     0.396    10.913     0.200
     1.135    25.289     0.200
     0.201     6.264     0.200
     0.832    19.898     0.200
     0.695    18.090     0.200
     0.968    21.901     0.200
     0.432    11.484     0.200
     0.862    20.465     0.200
     0.753    15.733     0.200
     1.117    25.489     0.200
     0.289     7.538     0.200
     0.497    12.609     0.200
     1.332    27.366     0.200
     1.534    31.507     0.200
     0.668    15.629     0.200
     0.876    19.201     0.200
     0.967    21.140     0.200
     0.621    15.043     0.200
     0.970    21.968     0.200
     1.663    32.876     0.200
     0.666    16.898     0.200
     1.734    35.446     0.200
     1.996    38.387     0.200
     0.457    11.662     0.200
     0.580    15.224     0.200
     1.545    31.959     0.200
     1.386    28.820     0.200
     0.301     8.772     0.200
     0.518    13.246     0.200
     0.654    15.659     0.200
     1.219    26.064     0.200
     1.193    25.368     0.200
     1.211    26.153     0.200
     0.550    12.696     0.200
     1.100    23.279     0.200
     1.516    30.481     0.200
     1.482    30.813     0.200
     1.294    27.286     0.200
     1.721    34.303     0.200
     1.918    37.003     0.200
     0.276     7.658     0.200
     0.329     8.036     0.200
     1.588    32.346     0.200
     1.774    34.172     0.200
     0.662    16.380     0.200
     1.375    27.050     0.200
     1.671    32.601     0.200
     1.768    35.467     0.200
     2.336    42.342     0.200
     0.103     8.949     0.200
     0.589    14.284     0.200
     1.702    31.297     0.200
     0.459    12.898     0.200
     2.354    43.788     0.200
     0.605    13.809     0.200
     0.640    15.396     0.200
     0.932    19.995     0.200
     0.968    21.565     0.200
     1.017    23.004     0.200
     1.641    32.720     0.200
     0.244     7.877     0.200
     1.359    27.864     0.200
     1.578    30.310     0.200
     0.276     6.885     0.200
     1.664    33.683     0.200
     1.992    38.860     0.200
     1.442    28.049     0.200
     1.446    28.026     0.200
     1.451    27.953     0.200
     1.443    30.658     0.200
     2.275    42.945     0.200
     0.595    15.254     0.200
     1.043    23.023     0.200
     1.169    26.033     0.200
     1.233    26.811     0.200
     1.295    28.085     0.200
     1.995    38.919     0.200
     0.671    15.140     0.200
     0.491    12.916     0.200
     0.556    13.446     0.200
     1.449    31.028     0.200
     0.470    13.043     0.200
     0.784    19.380     0.200
     1.335    26.943     0.200
     0.295     7.983     0.200
     0.535    14.458     0.200
     0.589    14.831     0.200
     0.589    13.831     0.200
     1.348    27.859     0.200
     1.509    30.089     0.200
     1.868    34.908     0.200
     2.144    39.679     0.200
     0.627    14.804     0.200
     0.669    16.306     0.200
     1.169    27.471     0.200
     1.161    26.568     0.200
     1.455    31.134     0.200
     2.000    38.777     0.200
     0.457    11.167     0.200
     0.645    15.979     0.200
     0.789    18.298     0.200
     0.976    21.112     0.200
     0.542    12.506     0.200
     0.915    20.154     0.200
     0.483    11.852     0.200
     0.587    14.633     0.200
     0.336     8.873     0.200
     0.641    14.304     0.200
     1.117    22.750     0.200
     1.293    26.704     0.200
     1.605    31.057     0.200
     1.380    28.474     0.200
     1.820    36.345     0.200
     0.321     7.968     0.200
     1.021    23.794     0.200
     0.253     8.377     0.200
     0.552    12.881     0.200
     0.391     9.322     0.200
     1.783    35.084     0.200
     0.380     9.095     0.200
     1.179    28.670     0.200
     1.797    38.552     0.200
     0.812    18.562     0.200
     0.425    10.339     0.200
     0.633    15.913     0.200
     1.201    24.278     0.200
     1.388    27.997     0.200
     1.683    32.996     0.200
     0.234     5.416     0.200
     1.795    35.903     0.200
     0.083     5.987     0.200
     1.378    28.088     0.200
     1.378    28.763     0.200
     2.213    40.390     0.200
     2.217    40.376     0.200
     2.224    41.593     0.200
     2.224    39.493     0.200
     0.937    20.582     0.200
     1.474    30.440     0.200
     2.065    38.476     0.200
     2.069    38.465     0.200
     1.079    23.725     0.200
     0.523    13.147     0.200
     0.671    16.977     0.200
     1.884    36.908     0.200
     1.884    38.236     0.200
     2.081    41.348     0.200
     0.883    21.201     0.200
     1.504    32.405     0.200
     1.838    36.831     0.200
     1.990    39.066     0.200
     3.107    58.123     0.200
     3.640    63.098     0.200
     0.307     8.642     0.200
     0.451    10.231     0.200
     1.942    37.192     0.200
     2.974    55.845     0.200
     0.336    10.786     0.200
     2.177    39.569     0.200
     2.428    43.435     0.200
     2.487    45.806     0.200
     3.224    55.200     0.200
     3.500    61.150     0.200
     0.254     7.038     0.200
     0.444    11.399     0.200
     0.471    11.330     0.200
     0.582    14.008     0.200
     1.343    27.854     0.200
     1.727    34.287     0.200
     1.847    36.308     0.200
     1.963    38.039     0.200
     2.586    47.077     0.200
     2.676    48.784     0.200
     3.289    56.723     0.200
     3.390    59.124     0.200
     0.234     6.952     0.200
     0.417    10.270     0.200
     0.486    11.319     0.200
     0.594    13.841     0.200
     1.670    34.760     0.200
     1.588    33.488     0.200
     1.992    39.775     0.200
     1.992    39.193     0.200
     1.981    40.006     0.200
     0.479    11.420     0.200
     0.933    20.587     0.200
     1.531    30.233     0.200
     1.525    31.032     0.200
     1.557    31.747     0.200
     1.530    32.059     0.200
     1.684    36.405     0.200
     0.607    13.188     0.200
     2.040    41.003     0.200
     0.587    12.839     0.200
     1.299    27.399     0.200
     1.299    27.024     0.200
     1.839    35.478     0.200
     1.839    39.336     0.200
     0.321     9.155     0.200
     0.584    12.811     0.200
     1.641    33.825     0.200
     2.368    45.009     0.200
     3.518    64.777     0.200
     3.758    67.785     0.200
     0.835    18.301     0.200
     0.754    17.866     0.200
     1.495    28.369     0.200
     1.477    29.736     0.200
     1.388    30.690     0.200
     1.762    35.617     0.200
     1.898    34.338     0.200
     1.898    34.865     0.200
     2.043    38.198     0.200
     2.582    47.327     0.200
     3.589    61.392     0.200
     0.994    22.866     0.200
     1.045    21.761     0.200
     1.291    28.548     0.200
     1.484    33.803     0.200
     1.599    34.270     0.200
     2.052    40.486     0.200
     2.450    46.681     0.200
     0.662    16.818     0.200
     0.661    16.164     0.200
     0.728    18.692     0.200
     0.782    18.377     0.200
     1.110    24.654     0.200
     1.503    31.339     0.200
     1.365    30.012     0.200
     2.167    43.030     0.200
     2.487    48.214     0.200
     2.470    44.920     0.200
     2.683    51.200     0.200
     2.855    52.814     0.200
     3.243    57.185     0.200
     3.408    60.850     0.200
     3.462    60.552     0.200
     1.170    25.891     0.200
     1.509    29.589     0.200
     2.733    49.386     0.200
     2.801    49.645     0.200
     3.262    57.828     0.200
     3.304    57.329     0.200
     3.801    64.397     0.200
     0.352     7.658     0.200
     0.927    20.031     0.200
     1.532    33.037     0.200
     1.630    36.210     0.200
     2.205    43.174     0.200
     2.352    48.222     0.200
     0.084     4.192     0.200
     0.641    15.306     0.200
     1.383    29.303     0.200
     1.815    34.704     0.200
     2.416    46.568     0.200
     2.575    49.535     0.200
     2.599    49.647     0.200
     0.191     5.680     0.200
     1.504    30.750     0.200
     1.634    33.870     0.200
     1.855    37.256     0.200
     1.924    38.097     0.200
     2.053    41.233     0.200
     0.476    11.872     0.200
     0.807    17.992     0.200
     1.050    24.580     0.200
     2.032    39.097     0.200
     2.537    47.287     0.200
     3.136    59.238     0.200
     0.542    13.803     0.200
     0.730    16.830     0.200
     0.819    18.074     0.200
     1.008    21.314     0.200
     1.144    25.504     0.200
     1.536    33.072     0.200
     1.710    34.820     0.200
     1.768    35.269     0.200
     1.779    34.839     0.200
     1.758    35.897     0.200
     2.838    53.828     0.200
     3.566    62.742     0.200
     3.764    69.234     0.200
     0.768    18.146     0.200
     1.403    32.077     0.200
     1.838    36.549     0.200
     2.017    39.900     0.200
     2.556    48.182     0.200
     2.814    52.813     0.200
     3.712    69.750     0.200
     0.504    12.911     0.200
     0.742    17.589     0.200
     1.763    33.580     0.200
     1.841    34.187     0.200
     0.559    13.932     0.200
     0.769    17.967     0.200
     1.074    22.984     0.200
     1.617    31.519     0.200
     1.674    32.625     0.200
     1.895    36.281     0.200
     1.947    34.378     0.200
     2.529    45.361     0.200
     3.283    59.898     0.200
     3.411    59.284     0.200
     5.128    89.882     0.200
     0.589    13.443     0.200
     0.934    21.652     0.200
     2.097    40.183     0.200
     0.354     7.559     0.200
     0.566    12.910     0.200
     1.256    27.513     0.200
     1.750    34.762     0.200
     1.999    38.819     0.200
     2.351    45.799     0.200
     2.444    46.494     0.200
     2.639    49.714     0.200
     2.982    56.851     0.200
     0.111     5.926     0.200
     0.315     8.780     0.200
     0.446    10.778     0.200
     1.168    23.055     0.200
     1.690    33.988     0.200
     2.461    47.255     0.200
     2.601    47.143     0.200
     0.804    18.175     0.200
     1.094    22.159     0.200
     1.220    24.282     0.200
     2.090    38.606     0.200
     1.548    33.364     0.200
     1.691    35.071     0.200
     1.795    36.071     0.200
     0.631    15.789     0.200
     0.993    21.617     0.200
     2.710    47.776     0.200
     2.989    52.530     0.200
     0.669    16.715     0.200
     2.806    52.678     0.200
     3.125    57.463     0.200
     0.334     7.782     0.200
     0.916    20.883     0.200
     0.991    23.292     0.200
     1.807    36.642     0.200
     2.915    52.358     0.200
     0.273     7.329     0.200
     0.898    21.336     0.200
     1.920    39.280     0.200
     0.618    14.902     0.200
     1.251    25.478     0.200
     1.373    27.426     0.200
     1.949    34.933     0.200
     2.174    43.007     0.200
     2.974    55.510     0.200
     3.082    53.409     0.200
     0.339     9.057     0.200
     1.517    31.864     0.200
     1.638    31.933     0.200
     1.904    36.828     0.200
     2.031    41.556     0.200
     2.194    40.889     0.200
     2.287    42.786     0.200
     2.505    44.458     0.200
     2.679    49.087     0.200
     2.738    49.150     0.200
     3.117    52.589     0.200
     0.584    13.257     0.200
     0.760    18.730     0.200
     1.490    32.587     0.200
     1.796    36.168     0.200
     2.868    54.431     0.200
     3.017    54.795     0.200
     3.529    63.435     0.200
     4.084    70.829     0.200
     0.412    10.144     0.200
     0.542    12.755     0.200
     0.791    17.249     0.200
     1.858    34.873     0.200
     1.749    33.539     0.200
     1.975    38.296     0.200
     2.144    42.235     0.200
     2.186    41.145     0.200
     2.420    45.802     0.200
     2.696    46.719     0.200
     2.851    49.647     0.200
     1.146    26.977     0.200
     1.219    27.920     0.200
     1.396    30.405     0.200
     1.559    33.215     0.200
     1.744    36.536     0.200
     1.772    37.704     0.200
     1.978    40.126     0.200
     2.050    40.814     0.200
     2.752    51.144     0.200
     3.230    58.185     0.200
     0.363    11.598     0.200
     1.125    23.648     0.200
     0.966    19.952     0.200
     1.139    24.299     0.200
     1.407    27.341     0.200
     1.638    31.626     0.200
     1.580    32.312     0.200
     2.025    38.341     0.200
     5.668    96.538     0.200
     0.875    20.176     0.200
     1.018    22.414     0.200
     1.003    21.581     0.200
     1.003    21.449     0.200
     1.449    30.417     0.200
     2.133    42.302     0.200
     2.141    42.994     0.200
     2.291    43.212     0.200
     3.342    57.985     0.200
     0.284     9.636     0.200
     0.434    12.614     0.200
     0.605    13.757     0.200
     1.003    19.644     0.200
     1.076    23.394     0.200
     1.396    28.351     0.200
     1.324    27.272     0.200
     0.183     7.085     0.200
     0.857    19.426     0.200
     1.110    22.532     0.200
     1.079    22.772     0.200
     1.681    32.344     0.200
     1.757    35.217     0.200
     1.866    37.580     0.200
     2.278    43.242     0.200
     0.384     8.642     0.200
     0.524    11.560     0.200
     0.604    13.238     0.200
     1.690    35.709     0.200
     2.021    41.065     0.200
     2.713    51.259     0.200
     2.949    52.976     0.200
     0.103     5.841     0.200
     0.492    11.118     0.200
     1.371    28.942     0.200
     1.611    32.723     0.200
     1.602    34.346     0.200
     1.744    34.721     0.200
     1.816    34.570     0.200
     1.904    36.650     0.200
     2.174    42.375     0.200
     2.189    40.239     0.200
     2.372    44.893     0.200
     2.458    46.364     0.200
     2.774    52.594     0.200
     2.967    53.191     0.200
     3.044    55.284     0.200
     3.347    62.402     0.200
     0.938    21.283     0.200
     1.022    25.055     0.200
     1.572    33.673     0.200
     2.195    42.711     0.200
     2.350    46.938     0.200
     2.816    52.629     0.200
     2.772    52.903     0.200
     0.096     5.427     0.200
     0.202     6.974     0.200
     1.364    29.155     0.200
     1.822    35.145     0.200
     1.903    38.351     0.200
     2.196    40.231     0.200
     2.373    45.310     0.200
     2.451    47.268     0.200
     2.459    47.096     0.200
     2.459    46.287     0.200
     2.777    51.507     0.200
     0.448    11.900     0.200
     0.615    14.618     0.200
     0.716    15.918     0.200
     1.444    29.153     0.200
     1.357    28.376     0.200
     1.595    33.093     0.200
     1.671    32.976     0.200
     2.135    39.235     0.200
     2.733    47.990     0.200
     2.994    53.766     0.200
     0.474    11.917     0.200
     1.560    32.434     0.200
     1.637    34.844     0.200
     1.901    38.648     0.200
     2.082    40.530     0.200
     2.139    40.797     0.200
     2.692    51.347     0.200
     2.760    50.236     0.200
     3.011    56.410     0.200
     3.373    57.799     0.200
     3.421    59.364     0.200
     0.495    12.012     0.200
     0.664    16.494     0.200
     0.751    16.114     0.200
     1.328    29.341     0.200
     1.544    32.706     0.200
     1.881    38.908     0.200
     2.087    39.473     0.200
     2.087    40.936     0.200
     2.188    42.155     0.200
     2.167    42.993     0.200
     2.334    43.127     0.200
     2.479    44.995     0.200
     2.780    50.080     0.200
     3.030    56.665     0.200
     0.667    16.761     0.200
     1.493    32.284     0.200
     1.719    33.636     0.200
     1.847    36.633     0.200
     2.151    40.883     0.200
     2.165    45.262     0.200
     2.184    42.438     0.200
     0.776    18.899     0.200
     0.834    18.961     0.200
     0.874    21.392     0.200
     1.374    29.122     0.200
     1.610    34.673     0.200
     1.713    37.283     0.200
     1.796    37.811     0.200
     1.963    41.798     0.200
     2.283    44.120     0.200
     0.802    20.186     0.200
     0.863    19.996     0.200
     0.943    22.010     0.200
     1.770    39.119     0.200
     1.730    38.772     0.200
     1.938    41.293     0.200
     1.910    40.657     0.200
     3.147    56.143     0.200
     0.336     7.759     0.200
     0.557    14.619     0.200
     0.840    20.065     0.200
     1.033    22.247     0.200
     1.185    24.983     0.200
     2.351    44.345     0.200
     2.364    44.973     0.200
     2.515    47.182     0.200
     2.958    52.665     0.200
     3.717    68.547     0.200
     0.356     8.693     0.200
     0.551    15.163     0.200
     0.638    13.973     0.200
     0.787    20.359     0.200
     1.623    34.415     0.200
     1.657    35.941     0.200
     1.683    36.461     0.200
     1.821    37.987     0.200
     2.106    42.555     0.200
     2.278    45.316     0.200
     2.219    43.545     0.200
     2.303    44.920     0.200
     2.810    51.779     0.200
     3.465    61.520     0.200
     3.524    62.169     0.200
     4.334    75.293     0.200
     0.126     8.783     0.200
     0.397    11.445     0.200
     0.521    13.841     0.200
     0.564    13.750     0.200
     2.651    47.967     0.200
     2.408    45.432     0.200
     0.867    20.087     0.200
     0.851    20.982     0.200
     1.496    32.352     0.200
     1.566    33.016     0.200
     2.312    47.921     0.200
     2.414    50.260     0.200
     2.906    55.301     0.200
     3.188    59.263     0.200
     3.221    58.902     0.200
     0.620    14.443     0.200
     1.181    23.459     0.200
     1.814    33.528     0.200
     1.827    32.513     0.200
     1.817    34.922     0.200
     2.011    37.767     0.200
     2.157    37.536     0.200
     2.188    39.456     0.200
     2.468    43.060     0.200
     0.451    11.666     0.200
     0.603    14.128     0.200
     0.636    14.776     0.200
     1.215    25.497     0.200
     1.713    35.584     0.200
     1.750    33.074     0.200
     1.760    35.035     0.200
     1.839    35.943     0.200
     1.900    34.711     0.200
     2.041    40.108     0.200
     2.203    42.909     0.200
     2.188    39.695     0.200
     2.259    41.472     0.200
     2.788    50.165     0.200
     0.210     5.886     0.200
     0.460    11.797     0.200
     0.634    13.843     0.200
     0.695    15.715     0.200
     1.355    28.099     0.200
     1.429    28.647     0.200
     1.574    31.968     0.200
     1.652    33.236     0.200
     2.474    45.262     0.200
     2.999    55.968     0.200
     3.364    57.308     0.200
     0.631    15.245     0.200
     0.818    17.748     0.200
     1.288    26.215     0.200
     1.285    27.525     0.200
     1.412    28.597     0.200
     1.912    36.397     0.200
     2.044    39.055     0.200
     2.040    39.996     0.200
     2.146    41.279     0.200
     2.253    42.489     0.200
     2.677    45.568     0.200
     2.854    50.538     0.200
     2.910    49.128     0.200
     0.898    20.474     0.200
     1.350    29.128     0.200
     1.497    31.723     0.200
     1.552    31.219     0.200
     1.693    35.399     0.200
     0.910    21.922     0.200
     1.764    36.112     0.200
     1.884    39.106     0.200
     2.893    53.056     0.200
     3.173    59.916     0.200
     0.156     5.456     0.200
     0.507    11.623     0.200
     1.659    33.597     0.200
     1.825    36.669     0.200
     1.872    38.728     0.200
     0.873    21.211     0.200
     0.916    21.266     0.200
     1.446    31.522     0.200
     1.497    30.941     0.200
     1.834    37.472     0.200
     1.750    35.685     0.200
     1.766    36.194     0.200
     2.614    49.149     0.200
     2.565    47.853     0.200
     0.494    14.115     0.200
     0.681    15.936     0.200
     0.888    20.316     0.200
     0.907    20.389     0.200
     1.497    29.197     0.200
     1.555    31.453     0.200
     1.721    33.032     0.200
     1.858    34.581     0.200
     0.170     6.424     0.200
     0.675    16.453     0.200
     1.812    35.662     0.200
     2.109    41.195     0.200
     3.405    63.558     0.200
     0.632    14.374     0.200
     0.720    15.815     0.200
     1.930    40.331     0.200
     2.167    41.474     0.200
     2.733    51.536     0.200
     0.801    18.751     0.200
     0.858    19.456     0.200
     0.994    23.378     0.200
     1.821    36.836     0.200
     2.151    41.413     0.200
     2.588    45.590     0.200
     0.825    19.549     0.200
     1.434    30.553     0.200
     1.521    30.571     0.200
     1.505    32.219     0.200
     1.531    32.108     0.200
     1.810    35.653     0.200
     1.810    36.886     0.200
     1.810    36.304     0.200
     2.730    49.752     0.200
     0.251     9.952     0.200
     0.687    14.659     0.200
     0.137     5.339     0.200
     1.783    35.473     0.200
     0.488    10.824     0.200
     0.579    13.642     0.200
     1.643    31.689     0.200
     1.833    36.451     0.200
     0.802    20.036     0.200
     0.885    19.888     0.200
     0.973    22.316     0.200
     1.300    28.018     0.200
     1.176    26.966     0.200
     1.427    32.436     0.200
     1.701    36.053     0.200
     1.643    33.686     0.200
     1.778    35.831     0.200
     1.882    39.321     0.200
     2.231    43.821     0.200
     0.662    15.350     0.200
     0.986    21.391     0.200
     1.443    30.655     0.200
     1.353    27.510     0.200
     1.397    28.812     0.200
     2.183    40.110     0.200
     2.110    40.172     0.200
     0.726    15.890     0.200
     0.914    21.423     0.200
     1.044    22.487     0.200
     1.457    29.958     0.200
     1.983    41.929     0.200
     2.214    43.755     0.200
     2.848    52.847     0.200
     0.552    14.297     0.200
     0.831    18.615     0.200
     1.180    26.915     0.200
     1.186    24.941     0.200
     1.250    27.588     0.200
     1.533    33.122     0.200
     0.772    17.785     0.200
     0.584    14.008     0.200
     0.702    16.397     0.200
     1.727    33.700     0.200
     2.311    45.068     0.200
     2.003    37.356     0.200
     2.724    50.535     0.200
     2.855    49.937     0.200
     3.598    61.843     0.200
     0.705    16.273     0.200
     0.701    15.346     0.200
     0.876    21.480     0.200
     1.040    24.584     0.200
     1.353    27.639     0.200
     2.822    51.520     0.200
     3.064    57.490     0.200
     0.608    14.774     0.200
     0.955    21.742     0.200
     1.420    26.219     0.200
     1.239    26.037     0.200
     1.407    28.057     0.200
     1.959    36.680     0.200
     2.173    38.553     0.200
     2.743    48.517     0.200
     2.962    50.981     0.200
     3.234    55.360     0.200
     4.143    70.178     0.200
     0.675    15.323     0.200
     0.753    17.603     0.200
     1.070    24.285     0.200
     0.856    20.240     0.200
     1.880    35.566     0.200
     1.686    36.149     0.200
     1.937    40.486     0.200
     2.106    40.596     0.200
     0.563    14.219     0.200
     0.727    17.825     0.200
     0.841    18.449     0.200
     1.125    22.113     0.200
     1.142    22.538     0.200
     1.392    29.260     0.200
     1.620    32.147     0.200
     1.749    35.215     0.200
     1.951    38.116     0.200
     1.939    37.391     0.200
     2.063    39.406     0.200
     2.296    41.862     0.200
     2.382    44.023     0.200
     3.026    53.541     0.200
     0.519    13.469     0.200
     0.696    16.509     0.200
     0.918    20.249     0.200
     1.352    28.709     0.200
     1.259    26.406     0.200
     1.443    31.203     0.200
     1.520    30.401     0.200
     1.678    31.595     0.200
     2.442    44.474     0.200
     0.865    20.034     0.200
     0.915    21.608     0.200
     0.991    24.045     0.200
     1.788    37.358     0.200
     1.923    36.790     0.200
     3.708    65.400     0.200
     0.570    15.453     0.200
     0.815    19.042     0.200
     1.364    27.868     0.200
     1.412    29.352     0.200
     1.686    31.736     0.200
     1.764    36.396     0.200
     1.831    37.378     0.200
     1.939    35.790     0.200
     0.920    21.779     0.200
     1.386    27.778     0.200
     1.906    40.208     0.200
     0.944    21.154     0.200
     1.034    23.935     0.200
     1.121    25.983     0.200
     1.636    35.016     0.200
     1.636    33.596     0.200
     1.758    38.160     0.200
     2.082    40.566     0.200
     0.769    19.265     0.200
     0.769    18.968     0.200
     1.443    30.426     0.200
     1.851    35.509     0.200
     1.892    38.131     0.200
     2.069    40.835     0.200
     0.805    18.709     0.200
     0.925    20.694     0.200
     1.513    31.363     0.200
     1.874    37.322     0.200
     1.861    35.665     0.200
     2.013    41.064     0.200
     2.086    40.652     0.200
     0.176     5.469     0.200
     0.675    15.328     0.200
     0.756    17.049     0.200
     1.822    39.628     0.200
     2.101    38.852     0.200
     2.174    40.006     0.200
     3.046    55.701     0.200
     0.193     5.628     0.200
     0.953    21.574     0.200
     1.250    26.418     0.200
     0.940    23.398     0.200
     1.416    30.608     0.200
     1.503    31.318     0.200
     1.445    31.382     0.200
     1.693    34.360     0.200
     1.693    34.844     0.200
     1.705    35.886     0.200
     1.619    32.665     0.200
     1.758    35.604     0.200
     1.982    39.458     0.200
     1.917    36.917     0.200
     1.998    39.542     0.200
     2.056    40.807     0.200
     2.902    52.558     0.200
     2.973    55.757     0.200
     0.236     7.671     0.200
     0.746    14.936     0.200
     0.746    16.983     0.200
     1.333    27.904     0.200
     1.467    27.909     0.200
     1.528    30.274     0.200
     1.659    33.100     0.200
     2.022    37.763     0.200
     2.323    41.828     0.200
     2.570    43.888     0.200
     0.463    11.853     0.200
     1.220    23.387     0.200
     1.352    25.829     0.200
     0.856    18.697     0.200
     1.130    23.636     0.200
     1.696    34.866     0.200
     1.759    38.111     0.200
     2.348    43.578     0.200
     1.909    38.070     0.200
     1.906    34.140     0.200
     2.080    38.850     0.200
     2.857    48.825     0.200
     0.893    20.997     0.200
     1.270    26.502     0.200
     1.298    28.687     0.200
     1.321    29.923     0.200
     1.669    35.301     0.200
     1.757    39.155     0.200
     1.832    38.857     0.200
     1.905    39.381     0.200
     0.577    14.090     0.200
     1.113    22.211     0.200
     1.383    28.041     0.200
     1.735    34.194     0.200
     1.938    34.208     0.200
     2.085    39.391     0.200
     2.702    47.319     0.200
     2.705    47.143     0.200
     2.956    51.424     0.200
     3.104    54.137     0.200
     0.555    14.117     0.200
     0.756    17.134     0.200
     0.796    18.378     0.200
     0.845    18.820     0.200
     1.080    24.086     0.200
     1.596    32.126     0.200
     1.704    34.570     0.200
     1.895    36.222     0.200
     1.973    36.859     0.200
     1.975    37.483     0.200
     2.024    40.996     0.200
     2.086    40.246     0.200
     3.263    58.818     0.200
     3.381    60.601     0.200
     0.682    15.419     0.200
     0.618    14.680     0.200
     0.857    19.429     0.200
     0.973    21.161     0.200
     1.170    23.080     0.200
     1.261    25.908     0.200
     1.339    28.299     0.200
     1.386    28.901     0.200
     1.470    32.142     0.200
     0.324     8.927     0.200
     0.937    19.917     0.200
     1.492    27.991     0.200
     1.560    29.346     0.200
     2.196    40.335     0.200
     2.208    40.103     0.200
     2.318    44.146     0.200
     2.420    44.722     0.200
     0.226     7.684     0.200
     1.360    25.996     0.200
     1.467    29.318     0.200
     1.598    31.589     0.200
     2.414    43.413     0.200
     0.264     7.913     0.200
     0.871    18.388     0.200
     0.871    18.681     0.200
     1.321    26.191     0.200
     1.425    29.489     0.200
     1.556    29.935     0.200
     1.630    31.937     0.200
     2.414    44.851     0.200
     2.446    42.978     0.200
     2.491    47.480     0.200
     0.724    17.410     0.200
     0.807    19.974     0.200
     1.084    23.474     0.200
     1.379    27.740     0.200
     1.489    30.467     0.200
     1.634    34.233     0.200
     1.825    34.451     0.200
     1.825    34.975     0.200
     1.902    36.270     0.200
     2.045    39.218     0.200
     2.441    44.984     0.200
     0.513    11.849     0.200
     0.434    10.695     0.200
     0.705    15.803     0.200
     1.115    24.452     0.200
     1.381    29.394     0.200
     1.813    34.410     0.200
     0.496    12.004     0.200
     0.516    12.185     0.200
     1.052    23.611     0.200
     1.330    26.266     0.200
     1.510    32.443     0.200
     1.687    35.204     0.200
     1.795    36.890     0.200
     2.328    43.468     0.200
     0.604    14.637     0.200
     0.879    21.197     0.200
     1.423    30.297     0.200
     1.424    30.289     0.200
     1.771    35.354     0.200
     0.719    15.926     0.200
     0.825    16.120     0.200
     0.942    19.557     0.200
     1.233    23.311     0.200
     1.233    23.819     0.200
     1.282    26.103     0.200
     1.259    24.706     0.200
     1.387    28.283     0.200
     1.963    37.877     0.200
     0.803    18.244     0.200
     1.037    22.668     0.200
     1.439    30.141     0.200
     1.520    31.399     0.200
     1.515    29.557     0.200
     1.551    32.248     0.200
     1.545    32.899     0.200
     1.698    32.549     0.200
     1.069    22.515     0.200
     1.127    24.648     0.200
     1.158    25.486     0.200
     1.451    29.021     0.200
     1.628    33.190     0.200
     0.368     8.677     0.200
     1.314    27.032     0.200
     1.646    32.702     0.200
     1.740    34.759     0.200
     1.903    37.523     0.200
     2.459    45.720     0.200
     0.212     5.255     0.200
     0.972    22.732     0.200
     0.995    22.672     0.200
     1.062    22.087     0.200
     1.100    23.516     0.200
     1.291    27.141     0.200
     1.422    30.183     0.200
     1.565    31.077     0.200
     2.019    39.120     0.200
     2.291    42.567     0.200
     2.427    45.516     0.200
     0.336     8.245     0.200
     0.416    10.095     0.200
     0.679    16.000     0.200
     0.841    19.503     0.200
     1.134    23.776     0.200
     1.087    23.658     0.200
     1.735    36.026     0.200
     2.528    47.644     0.200
     2.521    46.657     0.200
     2.609    48.610     0.200
     2.696    49.614     0.200
     2.778    50.600     0.200
     2.822    50.169     0.200
     2.940    52.277     0.200
     3.031    52.812     0.200
     0.735    16.865     0.200
     1.531    29.985     0.200
     1.531    30.141     0.200
     1.669    35.363     0.200
     1.943    38.096     0.200
     2.341    46.921     0.200
     2.600    48.054     0.200
     3.197    57.270     0.200
     0.698    17.454     0.200
     0.957    20.911     0.200
     1.110    24.597     0.200
     1.114    24.496     0.200
     1.327    26.517     0.200
     1.413    31.427     0.200
     1.654    34.550     0.200
     1.676    33.928     0.200
     1.832    36.197     0.200
     2.207    43.099     0.200
     0.735    16.916     0.200
     0.727    16.979     0.200
     1.108    23.728     0.200
     1.865    39.738     0.200
     2.152    41.298     0.200
     2.233    43.463     0.200
     2.495    47.722     0.200
     3.482    62.244     0.200
     0.700    14.259     0.200
     1.133    26.070     0.200
     1.467    33.201     0.200
     0.587    14.511     0.200
     0.896    21.167     0.200
     1.130    26.072     0.200
     1.146    25.514     0.200
     1.422    31.094     0.200
     1.653    34.102     0.200
     1.738    37.048     0.200
     2.358    44.827     0.200
     2.369    44.035     0.200
     0.712    17.531     0.200
     1.537    32.185     0.200
     2.342    47.092     0.200
     2.333    43.885     0.200
     2.333    43.600     0.200
     2.865    52.405     0.200
     3.200    56.014     0.200
     0.845    17.040     0.200
     1.348    27.291     0.200
     1.440    30.587     0.200
     1.406    30.134     0.200
     1.848    35.796     0.200
     2.184    40.507     0.200
     2.174    43.566     0.200
     2.694    49.140     0.200
     2.914    52.672     0.200
     0.331    10.659     0.200
     1.052    21.053     0.200
     1.375    27.081     0.200
     1.507    28.651     0.200
     0.321    10.234     0.200
     0.984    21.403     0.200
     1.241    24.863     0.200
     1.360    25.529     0.200
     1.306    24.964     0.200
     1.400    26.629     0.200
     1.532    28.295     0.200
     1.974    36.569     0.200
     0.477    12.065     0.200
     0.595    14.485     0.200
     0.735    16.823     0.200
     0.966    20.700     0.200
     1.135    25.705     0.200
     1.828    37.585     0.200
     2.303    46.096     0.200
     2.200    44.872     0.200
     2.247    44.706     0.200
     0.312     7.978     0.200
     1.377    28.803     0.200
     1.557    32.766     0.200
     1.509    30.919     0.200
     1.958    37.443     0.200
     0.529    12.690     0.200
     0.914    18.082     0.200
     0.934    20.387     0.200
     1.112    23.716     0.200
     1.283    26.860     0.200
     1.833    35.034     0.200
     1.918    36.223     0.200
     2.227    43.077     0.200
     2.337    43.932     0.200
     2.524    45.385     0.200
     3.472    62.354     0.200
     0.745    15.824     0.200
     0.790    16.357     0.200
     1.323    29.132     0.200
     1.389    30.056     0.200
     1.462    30.006     0.200
     1.522    29.550     0.200
     2.033    40.514     0.200
     2.338    42.627     0.200
     2.395    44.263     0.200
     0.650    16.134     0.200
     0.647    15.194     0.200
     0.892    20.402     0.200
     0.994    23.261     0.200
     1.304    25.140     0.200
     1.283    27.225     0.200
     1.409    29.295     0.200
     1.895    37.967     0.200
     2.018    37.576     0.200
     0.549    13.739     0.200
     0.687    16.693     0.200
     0.795    19.412     0.200
     1.197    24.510     0.200
     1.221    25.217     0.200
     1.706    33.451     0.200
     1.677    35.004     0.200
     1.889    36.600     0.200
     1.999    40.958     0.200
     2.302    43.823     0.200
     2.047    41.855     0.200
     0.552    14.493     0.200
     0.698    16.674     0.200
     0.808    18.074     0.200
     1.175    25.660     0.200
     1.224    25.373     0.200
     1.699    34.861     0.200
     1.984    41.623     0.200
     1.984    41.913     0.200
     2.053    42.695     0.200
     2.053    43.102     0.200
     2.299    44.772     0.200
     0.661    15.833     0.200
     0.857    18.377     0.200
     0.861    18.416     0.200
     1.331    28.066     0.200
     1.255    25.965     0.200
     1.380    27.784     0.200
     2.078    41.207     0.200
     2.218    39.189     0.200
     2.133    38.895     0.200
     0.555    14.328     0.200
     0.686    17.086     0.200
     0.793    17.183     0.200
     0.917    20.689     0.200
     1.079    25.506     0.200
     1.213    24.541     0.200
     1.213    26.142     0.200
     1.211    27.230     0.200
     1.662    34.044     0.200
     1.699    34.954     0.200
     1.721    35.860     0.200
     1.875    36.273     0.200
     2.003    41.267     0.200
     2.003    40.927     0.200
     2.037    41.466     0.200
     2.037    41.580     0.200
     2.220    43.747     0.200
     2.271    44.398     0.200
     0.900    19.114     0.200
     0.900    17.544     0.200
     0.977    21.016     0.200
     1.017    22.195     0.200
     1.425    27.704     0.200
     1.646    31.132     0.200
     1.687    31.611     0.200
     1.796    33.327     0.200
     2.515    44.076     0.200
     2.508    46.296     0.200
     2.691    46.447     0.200
     2.872    49.484     0.200
     1.006    22.645     0.200
     1.124    23.657     0.200
     1.692    32.556     0.200
     1.799    34.228     0.200
     2.551    47.969     0.200
     0.393     9.542     0.200
     0.393    10.657     0.200
     0.524    13.952     0.200
     1.189    25.871     0.200
     0.382     9.317     0.200
     0.514    12.567     0.200
     1.201    25.428     0.200
     1.165    24.469     0.200
     1.177    24.669     0.200
     2.098    40.376     0.200
     2.179    42.070     0.200
     2.770    51.993     0.200
     2.583    46.984     0.200
     2.638    48.151     0.200
     0.367     9.529     0.200
     0.499    12.016     0.200
     1.154    25.704     0.200
     1.169    24.766     0.200
     1.202    25.689     0.200
     2.171    41.681     0.200
     2.583    46.459     0.200
     2.754    49.971     0.200
     2.778    49.447     0.200
     3.100    56.905     0.200
     0.376     9.378     0.200
     0.500    11.985     0.200
     1.191    25.321     0.200
     0.385     9.557     0.200
     0.517    11.769     0.200
     1.148    25.958     0.200
     1.157    25.572     0.200
     1.164    25.702     0.200
     1.223    25.060     0.200
     2.198    42.246     0.200
     3.130    59.227     0.200
     0.376     9.064     0.200
     0.506    12.312     0.200
     1.170    25.098     0.200
     1.190    24.732     0.200
     1.176    25.305     0.200
     2.067    39.976     0.200
     2.183    42.629     0.200
     2.145    39.953     0.200
     2.145    42.218     0.200
     2.610    47.822     0.200
     3.093    56.473     0.200
     0.369     9.522     0.200
     0.790    18.427     0.200
     1.164    23.932     0.200
     1.184    24.689     0.200
     1.179    24.628     0.200
     2.063    39.109     0.200
     2.145    43.546     0.200
     2.612    47.608     0.200
     2.607    47.748     0.200
     2.646    47.970     0.200
     2.672    48.227     0.200
     2.748    49.104     0.200
     1.179    23.124     0.200
     1.293    26.444     0.200
     1.747    32.624     0.200
     2.101    37.405     0.200
     2.154    39.067     0.200
     2.443    42.410     0.200
     0.930    21.938     0.200
     0.843    20.072     0.200
     1.053    23.166     0.200
     1.469    29.078     0.200
     1.434    31.678     0.200
     1.516    32.881     0.200
     1.542    33.415     0.200
     1.658    33.878     0.200
     0.225     7.223     0.200
     1.756    36.390     0.200
     1.485    32.531     0.200
     1.629    33.719     0.200
     1.565    34.455     0.200
     1.855    37.808     0.200
     1.985    39.606     0.200
     1.333    27.319     0.200
     1.401    27.617     0.200
     1.422    30.389     0.200
     1.505    30.918     0.200
     1.498    31.728     0.200
     1.623    31.707     0.200
     1.574    32.558     0.200
     1.642    32.656     0.200
     1.789    34.558     0.200
     0.267     5.866     0.200
     0.999    23.342     0.200
     1.261    28.505     0.200
     1.496    33.120     0.200
     1.564    33.952     0.200
     1.855    38.717     0.200
     1.982    39.349     0.200
     0.687    17.039     0.200
     0.790    19.377     0.200
     1.049    25.121     0.200
     1.197    26.598     0.200
     1.635    34.884     0.200
     1.718    36.781     0.200
     2.017    42.511     0.200
     2.009    42.154     0.200
     0.456    10.863     0.200
     0.578    14.211     0.200
     0.586    13.517     0.200
     0.815    18.725     0.200
     1.568    31.022     0.200
     1.814    36.901     0.200
     1.814    35.597     0.200
     1.768    34.149     0.200
     1.969    39.870     0.200
     2.148    42.115     0.200
     2.250    44.474     0.200
     2.250    45.060     0.200
     2.391    45.195     0.200
     2.520    46.946     0.200
     2.722    50.194     0.200
     0.366     8.802     0.200
     0.498    11.340     0.200
     1.151    24.424     0.200
     1.166    24.315     0.200
     1.205    25.011     0.200
     1.717    36.387     0.200
     2.085    40.239     0.200
     2.174    40.939     0.200
     2.580    47.000     0.200
     2.575    47.957     0.200
     2.626    48.233     0.200
     3.100    56.189     0.200
     3.383    59.566     0.200
     0.343     9.076     0.200
     0.470    11.653     0.200
     0.760    18.084     0.200
     1.153    24.666     0.200
     1.187    25.126     0.200
     1.154    24.554     0.200
     2.093    39.030     0.200
     2.610    47.441     0.200
     2.640    47.531     0.200
     2.655    48.279     0.200
     2.619    45.941     0.200
     2.704    49.340     0.200
     2.704    47.635     0.200
     3.033    55.731     0.200
     3.211    56.023     0.200
     0.314     9.200     0.200
     0.439    11.776     0.200
     1.128    25.491     0.200
     1.021    24.411     0.200
     1.710    34.102     0.200
     1.972    37.894     0.200
     2.641    49.481     0.200
     2.655    47.143     0.200
     2.650    49.663     0.200
     0.367    11.400     0.200
     0.617    13.085     0.200
     0.894    18.737     0.200
     0.893    19.368     0.200
     1.712    33.789     0.200
     0.705    16.977     0.200
     0.780    19.536     0.200
     0.772    17.708     0.200
     1.122    23.739     0.200
     1.360    27.617     0.200
     1.613    32.248     0.200
     1.705    34.915     0.200
     2.129    43.722     0.200
     2.462    46.213     0.200
     0.379    11.898     0.200
     0.607    14.932     0.200
     0.890    20.250     0.200
     1.559    30.224     0.200
     1.619    32.686     0.200
     1.709    32.698     0.200
     1.725    33.878     0.200
     3.467    60.700     0.200
     0.148     5.017     0.200
     0.642    16.021     0.200
     1.667    32.375     0.200
     1.854    36.955     0.200
     1.840    37.570     0.200
     2.095    41.321     0.200
     2.161    42.099     0.200
     2.226    41.813     0.200
     2.193    40.309     0.200
     0.395    10.942     0.200
     0.645    14.113     0.200
     0.942    21.278     0.200
     0.891    19.583     0.200
     1.481    28.383     0.200
     1.600    31.120     0.200
     1.657    31.264     0.200
     1.709    33.460     0.200
     0.271     9.873     0.200
     0.632    15.514     0.200
     0.845    19.910     0.200
     1.111    22.290     0.200
     1.426    27.507     0.200
     1.563    30.709     0.200
     1.663    32.069     0.200
     1.825    35.554     0.200
     0.416    10.700     0.200
     0.586    14.152     0.200
     0.886    20.542     0.200
     0.954    20.599     0.200
     0.954    19.396     0.200
     0.938    20.367     0.200
     1.423    29.486     0.200
     1.588    32.137     0.200
     1.692    33.211     0.200
     1.651    33.632     0.200
     1.757    35.431     0.200
     2.625    48.115     0.200
     2.669    49.185     0.200
     2.815    50.190     0.200
     0.728    17.486     0.200
     0.761    18.644     0.200
     1.065    20.196     0.200
     1.434    27.957     0.200
     1.382    27.200     0.200
     1.704    35.090     0.200
     1.612    33.350     0.200
     1.863    35.075     0.200
     2.053    39.050     0.200
     2.118    39.827     0.200
     2.277    41.095     0.200
     2.488    44.137     0.200
     2.498    47.373     0.200
     3.576    61.435     0.200
     0.306     9.368     0.200
     1.235    24.184     0.200
     1.437    27.890     0.200
     1.627    31.987     0.200
     1.600    31.081     0.200
     0.634    15.364     0.200
     0.653    16.791     0.200
     0.787    16.149     0.200
     0.729    15.901     0.200
     0.922    20.290     0.200
     1.038    23.071     0.200
     1.286    25.178     0.200
     1.326    27.115     0.200
     1.466    30.499     0.200
     1.452    29.219     0.200
     1.907    35.136     0.200
     2.054    41.248     0.200
     2.234    40.235     0.200
     0.646    16.060     0.200
     1.030    22.729     0.200
     1.927    37.514     0.200
     0.354    10.860     0.200
     0.852    16.882     0.200
     0.907    18.475     0.200
     0.936    20.023     0.200
     1.240    25.418     0.200
     1.275    27.604     0.200
     1.598    31.356     0.200
     1.928    37.384     0.200
     1.933    37.798     0.200
     1.940    37.375     0.200
     2.168    38.542     0.200
     2.272    39.911     0.200
     2.599    47.603     0.200
     2.937    49.918     0.200
     3.060    55.459     0.200
     0.389    10.142     0.200
     0.842    19.117     0.200
     1.299    26.749     0.200
     1.395    26.916     0.200
     1.469    29.488     0.200
     1.629    32.212     0.200
     1.672    31.552     0.200
     1.535    30.289     0.200
     2.236    40.486     0.200
     0.381    11.512     0.200
     0.860    18.271     0.200
     0.906    19.133     0.200
     1.217    24.357     0.200
     1.280    25.574     0.200
     1.450    28.083     0.200
     1.516    28.664     0.200
     0.378    11.247     0.200
     0.865    18.127     0.200
     1.628    31.231     0.200
     1.908    37.036     0.200
     1.915    36.657     0.200
     0.243     7.325     0.200
     0.311     7.805     0.200
     0.574    13.596     0.200
     1.125    23.261     0.200
     1.630    33.905     0.200
     1.754    34.387     0.200
     1.900    38.108     0.200
     1.955    37.870     0.200
     2.504    47.332     0.200
     2.459    48.355     0.200
     2.698    48.409     0.200
     0.393    11.583     0.200
     0.863    18.877     0.200
     0.937    19.825     0.200
     1.284    25.810     0.200
     1.451    28.092     0.200
     1.516    29.408     0.200
     1.676    32.785     0.200
     0.402    10.198     0.200
     0.951    21.158     0.200
     0.915    20.035     0.200
     0.948    21.456     0.200
     1.368    28.354     0.200
     1.588    32.496     0.200
     1.681    33.630     0.200
     1.681    32.482     0.200
     1.627    32.206     0.200
     1.734    33.746     0.200
     2.816    50.783     0.200
     0.418    10.846     0.200
     0.961    21.754     0.200
     1.374    29.444     0.200
     1.607    32.573     0.200
     1.634    31.907     0.200
     1.665    32.594     0.200
     1.792    37.960     0.200
     0.455    11.818     0.200
     0.967    20.845     0.200
     1.198    23.515     0.200
     1.369    28.729     0.200
     1.503    28.543     0.200
     1.825    36.551     0.200
     2.319    42.930     0.200
     2.426    42.605     0.200
     2.458    42.745     0.200
     0.638    15.462     0.200
     0.701    18.000     0.200
     1.150    23.443     0.200
     1.646    33.983     0.200
     1.808    34.702     0.200
     1.914    36.700     0.200
     2.196    41.013     0.200
     0.847    19.871     0.200
     0.933    21.332     0.200
     1.121    25.166     0.200
     1.180    24.250     0.200
     1.169    25.337     0.200
     1.586    32.422     0.200
     2.434    46.435     0.200
     0.253     7.001     0.200
     0.360     9.059     0.200
     0.655    15.297     0.200
     0.815    19.929     0.200
     1.687    33.866     0.200
     2.071    41.200     0.200
     2.280    43.993     0.200
     2.776    50.887     0.200
     3.431    58.611     0.200
     0.278    10.008     0.200
     0.905    19.630     0.200
     1.285    27.359     0.200
     1.477    28.087     0.200
     1.535    30.437     0.200
     1.638    31.923     0.200
     0.436     9.898     0.200
     1.094    23.109     0.200
     1.524    32.793     0.200
     1.551    32.373     0.200
     1.052    22.305     0.200
     1.271    24.376     0.200
     1.367    28.678     0.200
     1.814    35.874     0.200
     1.679    33.213     0.200
     1.849    36.245     0.200
     1.922    37.265     0.200
     2.049    39.830     0.200
     0.527    12.851     0.200
     0.659    14.744     0.200
     1.030    24.536     0.200
     1.100    24.392     0.200
     1.100    25.509     0.200
     1.233    28.142     0.200
     1.246    28.307     0.200
     1.750    37.522     0.200
     1.736    36.526     0.200
     1.642    34.658     0.200
     1.788    36.554     0.200
     1.700    36.618     0.200
     1.684    33.684     0.200
     0.513    11.508     0.200
     0.628    13.767     0.200
     1.267    27.879     0.200
     1.396    29.803     0.200
     1.653    34.942     0.200
     1.802    35.952     0.200
     1.995    38.850     0.200
     2.131    42.166     0.200
     2.212    45.568     0.200
     0.797    17.513     0.200
     0.626    14.744     0.200
     0.868    18.141     0.200
     1.061    22.441     0.200
     1.211    26.471     0.200
     1.331    29.102     0.200
     1.542    34.152     0.200
     1.943    38.724     0.200
     1.966    41.281     0.200
     1.951    40.243     0.200
     2.009    41.820     0.200
     2.069    42.681     0.200
     0.278     9.031     0.200
     0.485    11.428     0.200
     0.611    13.998     0.200
     0.879    19.521     0.200
     1.225    25.872     0.200
     1.503    29.824     0.200
     1.790    34.309     0.200
     1.742    34.217     0.200
     2.014    41.092     0.200
     2.205    43.339     0.200
     2.327    45.262     0.200
     0.576    14.360     0.200
     1.031    23.114     0.200
     0.959    22.093     0.200
     1.233    25.792     0.200
     1.321    29.144     0.200
     1.449    31.891     0.200
     1.965    40.594     0.200
     0.834    18.335     0.200
     0.840    20.930     0.200
     0.914    19.871     0.200
     1.479    30.510     0.200
     1.544    31.533     0.200
     1.816    35.528     0.200
     2.127    40.387     0.200
     0.468    12.374     0.200
     0.523    13.242     0.200
     1.074    24.654     0.200
     1.011    21.341     0.200
     1.232    23.563     0.200
     1.230    24.528     0.200
     1.348    27.323     0.200
     1.320    26.510     0.200
     1.592    30.576     0.200
     1.649    31.784     0.200
     1.959    37.522     0.200
     2.336    41.587     0.200
     0.833    18.548     0.200
     1.373    28.537     0.200
     1.405    28.138     0.200
     1.393    28.334     0.200
     1.479    29.042     0.200
     1.476    29.617     0.200
     2.095    39.092     0.200
     2.173    40.364     0.200
     2.203    39.622     0.200
     2.397    42.760     0.200
     2.831    50.586     0.200
     0.753    17.037     0.200
     0.816    19.835     0.200
     1.078    24.319     0.200
     1.365    27.325     0.200
     1.567    33.461     0.200
     1.843    39.109     0.200
     2.109    40.907     0.200
     2.384    44.919     0.200
     0.458    11.983     0.200
     0.838    16.225     0.200
     0.812    17.141     0.200
     0.970    21.956     0.200
     1.113    21.766     0.200
     1.258    24.995     0.200
     1.449    29.891     0.200
     1.389    27.159     0.200
     1.122    23.427     0.200
     1.420    30.392     0.200
     1.502    31.802     0.200
     2.046    40.459     0.200
     2.543    48.288     0.200
     0.736    17.213     0.200
     0.894    20.440     0.200
     0.894    19.022     0.200
     1.427    30.353     0.200
     1.537    30.884     0.200
     1.537    32.519     0.200
     1.697    35.591     0.200
     1.664    34.807     0.200
     1.937    40.656     0.200
     2.352    42.630     0.200
     2.406    46.789     0.200
     2.594    48.328     0.200
     2.684    47.464     0.200
     2.896    52.532     0.200
     2.890    51.652     0.200
     0.478    11.721     0.200
     0.988    22.016     0.200
     1.181    25.165     0.200
     1.443    30.124     0.200
     1.470    30.676     0.200
     1.507    30.501     0.200
     2.518    45.360     0.200
     2.562    48.107     0.200
     2.643    47.392     0.200
     0.499    11.902     0.200
     1.049    22.306     0.200
     1.451    31.779     0.200
     1.480    31.265     0.200
     1.523    31.564     0.200
     2.546    45.549     0.200
     2.648    48.615     0.200
     2.638    49.781     0.200
     0.547    13.115     0.200
     1.626    32.853     0.200
     1.841    34.815     0.200
     2.672    47.507     0.200
     3.684    62.776     0.200
     0.542    13.154     0.200
     0.953    18.269     0.200
     1.152    23.732     0.200
     1.283    24.755     0.200
     1.819    37.284     0.200
     0.496    12.531     0.200
     1.018    23.374     0.200
     1.239    25.209     0.200
     1.370    27.111     0.200
     2.091    38.604     0.200
     1.417    29.147     0.200
     1.406    29.645     0.200
     1.446    30.458     0.200
     1.491    30.977     0.200
     2.083    38.952     0.200
     2.389    43.148     0.200
     0.755    16.982     0.200
     0.815    20.110     0.200
     1.332    27.773     0.200
     1.544    31.766     0.200
     1.539    32.229     0.200
     0.856    18.606     0.200
     0.933    19.346     0.200
     0.848    18.280     0.200
     1.469    28.555     0.200
     1.396    28.531     0.200
     1.514    29.651     0.200
     0.425     8.652     0.200
     1.329    28.143     0.200
     1.469    33.445     0.200
     1.443    30.731     0.200
     1.600    33.540     0.200
     1.607    35.315     0.200
     1.501    32.336     0.200
     2.139    43.191     0.200
     0.666    16.118     0.200
     0.743    18.693     0.200
     1.364    27.842     0.200
     0.187     6.071     0.200
     0.595    13.506     0.200
     0.922    23.233     0.200
     1.884    38.333     0.200
     1.926    37.052     0.200
     2.266    43.850     0.200
     2.407    49.253     0.200
     2.420    44.386     0.200
     2.871    54.145     0.200
     0.216     6.761     0.200
     1.411    28.114     0.200
     1.376    29.606     0.200
     1.529    31.434     0.200
     2.017    38.707     0.200
     2.913    53.937     0.200
     0.612    15.464     0.200
     1.152    23.352     0.200
     1.461    32.989     0.200
     1.443    32.172     0.200
     1.490    30.659     0.200
     2.079    38.945     0.200
     2.701    48.377     0.200
     0.476    10.874     0.200
     1.847    34.952     0.200
     1.961    36.359     0.200
     2.134    38.445     0.200
     0.919    19.376     0.200
     1.024    23.949     0.200
     1.634    34.223     0.200
     1.832    38.214     0.200
     0.444    10.104     0.200
     1.018    21.524     0.200
     1.115    22.604     0.200
     1.518    32.135     0.200
     1.525    33.515     0.200
     1.704    33.026     0.200
     2.090    41.895     0.200
     2.115    42.282     0.200
     2.290    46.134     0.200
     2.491    45.820     0.200
     1.241    27.005     0.200
     1.281    27.500     0.200
     1.415    29.558     0.200
     1.479    31.470     0.200
     1.498    32.615     0.200
     1.596    34.590     0.200
     1.841    37.424     0.200
     1.961    38.925     0.200
     2.649    50.509     0.200
     2.641    49.397     0.200
     0.459    11.753     0.200
     0.540    14.139     0.200
     0.733    18.685     0.200
     0.828    18.499     0.200
     0.907    20.134     0.200
     1.393    29.244     0.200
     2.634    45.859     0.200
     2.725    49.522     0.200
     3.198    59.834     0.200
     0.287     8.594     0.200
     0.616    14.575     0.200
     0.641    14.079     0.200
     1.189    25.116     0.200
     1.781    35.667     0.200
     1.979    39.190     0.200
     2.186    43.375     0.200
     2.569    48.302     0.200
     0.512    13.659     0.200
     0.791    18.316     0.200
     1.425    30.112     0.200
     3.139    58.156     0.200
     0.716    15.360     0.200
     1.061    25.414     0.200
     1.110    25.715     0.200
     1.456    32.105     0.200
     1.528    33.532     0.200
     1.810    39.029     0.200
     0.108     4.487     0.200
     0.591    15.377     0.200
     0.676    16.843     0.200
     0.843    18.965     0.200
     1.360    27.310     0.200
     1.495    30.540     0.200
     1.377    29.551     0.200
     1.481    29.759     0.200
     1.463    30.441     0.200
     2.020    38.774     0.200
     2.020    39.261     0.200
     0.644    14.793     0.200
     0.790    18.097     0.200
     0.963    20.014     0.200
     1.570    30.644     0.200
     2.191    40.394     0.200
     2.535    43.755     0.200
     2.638    46.742     0.200
     0.527    13.153     0.200
     0.545    14.408     0.200
     0.651    15.627     0.200
     0.677    17.150     0.200
     1.137    24.161     0.200
     1.738    35.546     0.200
     1.739    33.757     0.200
     1.663    32.430     0.200
     2.097    41.583     0.200
     2.449    44.322     0.200
     2.410    44.653     0.200
     2.821    49.046     0.200
     3.180    55.155     0.200
     0.574    12.750     0.200
     0.802    18.024     0.200
     1.199    25.057     0.200
     1.465    31.497     0.200
     1.518    32.570     0.200
     1.465    31.263     0.200
     1.488    31.649     0.200
     2.641    50.668     0.200
     0.111     5.442     0.200
     0.755    16.432     0.200
     0.964    22.201     0.200
     1.241    25.665     0.200
     1.379    28.135     0.200
     2.013    37.733     0.200
     2.435    43.744     0.200
     2.540    46.203     0.200
     0.293     8.854     0.200
     0.420    10.944     0.200
     0.537    13.159     0.200
     1.305    26.553     0.200
     1.334    27.695     0.200
     1.472    29.390     0.200
     1.618    30.570     0.200
     2.024    36.603     0.200
     2.257    43.419     0.200
     2.278    44.031     0.200
     0.479    10.864     0.200
     1.429    30.581     0.200
     1.607    33.676     0.200
     1.638    34.910     0.200
     1.693    34.731     0.200
     0.172     6.618     0.200
     1.527    30.551     0.200
     1.598    33.471     0.200
     1.791    32.672     0.200
     1.305    27.157     0.200
     1.553    31.092     0.200
     1.654    32.464     0.200
     1.793    35.436     0.200
     0.273     8.756     0.200
     0.647    14.194     0.200
     1.087    21.700     0.200
     1.552    31.380     0.200
     1.653    32.364     0.200
     0.450     9.087     0.200
     1.347    29.953     0.200
     1.177    28.195     0.200
     1.522    34.692     0.200
     1.491    31.122     0.200
     1.466    31.715     0.200
     1.858    38.317     0.200
     2.107    41.835     0.200
     1.069    24.425     0.200
     1.115    25.154     0.200
     1.574    30.994     0.200
     2.163    43.256     0.200
     2.232    42.347     0.200
     2.380    45.098     0.200
     0.380     7.192     0.200
     1.417    30.091     0.200
     1.265    26.532     0.200
     1.237    27.639     0.200
     1.479    31.140     0.200
     1.435    31.136     0.200
     1.607    32.880     0.200
     0.578    11.656     0.200
     1.270    28.838     0.200
     1.218    28.488     0.200
     1.500    32.637     0.200
     1.325    29.884     0.200
     0.927    22.203     0.200
     1.232    27.663     0.200
     1.345    28.182     0.200
     1.456    31.083     0.200
     1.581    33.208     0.200
     2.292    45.575     0.200
     2.360    44.581     0.200
     2.434    46.334     0.200
     0.891    22.639     0.200
     1.324    27.688     0.200
     1.712    35.740     0.200
     2.318    44.626     0.200
     2.656    47.424     0.200
     0.072     6.565     0.200
     0.495    12.953     0.200
     0.539    13.323     0.200
     1.319    27.220     0.200
     1.341    27.586     0.200
     1.637    32.787     0.200
     1.936    37.699     0.200
     2.213    41.677     0.200
     2.287    40.416     0.200
     2.483    45.270     0.200
     2.703    48.166     0.200
     3.203    55.423     0.200
     0.830    19.869     0.200
     1.066    23.532     0.200
     1.105    24.869     0.200
     1.259    25.319     0.200
     1.535    32.739     0.200
     1.697    34.788     0.200
     2.332    45.638     0.200
     0.720    14.210     0.200
     1.138    23.780     0.200
     1.138    23.088     0.200
     1.309    26.459     0.200
     1.571    31.225     0.200
     1.915    35.294     0.200
     1.878    37.167     0.200
     2.220    40.302     0.200
     2.267    41.056     0.200
     2.689    48.806     0.200
     0.630    15.144     0.200
     0.630    15.347     0.200
     0.677    15.421     0.200
     0.715    17.443     0.200
     1.201    24.738     0.200
     1.543    31.136     0.200
     1.667    34.163     0.200
     1.922    39.005     0.200
     0.949    23.885     0.200
     1.195    26.695     0.200
     1.191    27.565     0.200
     1.234    28.544     0.200
     1.315    30.004     0.200
     1.374    30.889     0.200
     1.478    32.202     0.200
     1.590    33.396     0.200
     1.691    35.236     0.200
     1.906    37.771     0.200
     2.285    46.090     0.200
     2.456    47.661     0.200
     2.620    48.027     0.200
     0.136     6.223     0.200
     0.304     8.323     0.200
     0.433    10.976     0.200
     1.633    31.762     0.200
     1.966    36.873     0.200
     2.048    39.036     0.200
     2.155    39.394     0.200
     2.387    45.860     0.200
     2.498    45.755     0.200
     2.438    46.637     0.200
     2.772    48.594     0.200
     2.899    50.622     0.200
     0.782    19.725     0.200
     1.011    24.265     0.200
     0.995    23.726     0.200
     1.033    24.537     0.200
     1.109    26.205     0.200
     1.253    27.528     0.200
     1.585    33.192     0.200
     2.278    45.199     0.200
     2.690    49.207     0.200
     3.532    64.033     0.200
     0.208     5.441     0.200
     1.324    30.104     0.200
     1.204    22.705     0.200
     1.390    29.230     0.200
     1.806    36.784     0.200
     2.219    41.244     0.200
     2.378    47.001     0.200
     0.871    21.114     0.200
     1.417    29.342     0.200
     1.774    34.889     0.200
     2.016    38.269     0.200
     2.073    38.358     0.200
     0.475    11.379     0.200
     1.055    22.748     0.200
     1.229    24.944     0.200
     1.361    27.392     0.200
     1.945    34.884     0.200
     0.761    16.864     0.200
     0.761    17.969     0.200
     0.978    20.294     0.200
     1.291    26.017     0.200
     1.318    25.896     0.200
     1.563    31.642     0.200
     1.523    31.827     0.200
     1.651    33.666     0.200
     1.903    36.547     0.200
     2.131    40.688     0.200
     2.189    40.799     0.200
     2.400    42.954     0.200
     0.123     4.169     0.200
     0.393     9.981     0.200
     0.332     7.889     0.200
     0.447    10.629     0.200
     0.999    24.892     0.200
     1.426    31.167     0.200
     1.781    36.077     0.200
     2.048    40.432     0.200
     2.048    39.136     0.200
     2.941    55.093     0.200
     0.999    22.134     0.200
     1.652    35.348     0.200
     0.746    17.820     0.200
     0.524    12.453     0.200
     0.977    20.609     0.200
     1.388    29.432     0.200
     1.487    29.994     0.200
     1.522    31.858     0.200
     2.020    38.650     0.200
     0.824    19.130     0.200
     0.858    19.409     0.200
     0.951    23.078     0.200
     0.997    23.718     0.200
     1.543    31.841     0.200
     1.629    34.355     0.200
     1.815    36.724     0.200
     1.903    38.206     0.200
     2.143    42.252     0.200
     0.753    16.588     0.200
     0.691    16.230     0.200
     0.763    16.317     0.200
     0.763    16.442     0.200
     1.044    20.369     0.200
     1.237    24.698     0.200
     1.319    26.331     0.200
     1.319    26.143     0.200
     1.429    26.774     0.200
     1.805    35.212     0.200
     1.814    37.183     0.200
     2.283    43.013     0.200
     2.290    39.864     0.200
     2.443    43.204     0.200
     0.781    18.862     0.200
     0.838    19.171     0.200
     0.888    19.938     0.200
     1.758    34.510     0.200
     1.937    36.643     0.200
     2.098    38.810     0.200
     2.027    39.061     0.200
     2.239    43.922     0.200
     2.630    45.924     0.200
     0.818    18.969     0.200
     1.091    22.914     0.200
     1.573    31.686     0.200
     1.623    30.688     0.200
     1.883    35.057     0.200
     2.162    42.230     0.200
     2.690    48.987     0.200
     3.053    54.022     0.200
     3.341    62.273     0.200
     3.476    63.275     0.200
     3.689    62.446     0.200
     0.949    21.162     0.200
     0.877    20.630     0.200
     0.904    20.921     0.200
     0.966    22.040     0.200
     1.474    28.898     0.200
     1.641    32.852     0.200
     1.939    36.929     0.200
     2.137    41.886     0.200
     0.141     6.588     0.200
     0.528    13.302     0.200
     0.528    12.306     0.200
     0.950    21.504     0.200
     1.002    21.609     0.200
     1.198    24.113     0.200
     1.387    29.700     0.200
     1.347    28.491     0.200
     1.728    33.890     0.200
     1.804    34.780     0.200
     2.344    42.372     0.200
     2.417    43.012     0.200
     2.425    46.068     0.200
     2.573    48.139     0.200
     2.735    47.540     0.200
     0.297     5.923     0.200
     1.148    26.925     0.200
     1.352    27.783     0.200
     1.352    27.087     0.200
     1.149    25.163     0.200
     1.570    32.260     0.200
     1.626    34.163     0.200
     1.808    36.888     0.200
     0.419    10.995     0.200
     0.835    18.725     0.200
     1.825    36.183     0.200
     2.367    44.576     0.200
     0.993    22.650     0.200
     1.516    30.249     0.200
     1.547    33.703     0.200
     1.626    32.137     0.200
     1.665    31.983     0.200
     1.626    31.114     0.200
     1.775    34.282     0.200
     1.775    34.505     0.200
     1.658    31.823     0.200
     1.775    35.057     0.200
     1.882    37.835     0.200
     1.982    36.572     0.200
     2.861    52.580     0.200
     1.340    28.901     0.200
     1.492    33.136     0.200
     2.056    41.254     0.200
     2.572    48.653     0.200
     3.230    60.042     0.200
     0.705    16.098     0.200
     0.695    17.266     0.200
     1.257    26.404     0.200
     1.339    27.542     0.200
     1.607    35.199     0.200
     1.658    35.357     0.200
     1.744    36.732     0.200
     2.663    50.942     0.200
     0.600    14.938     0.200
     0.662    15.553     0.200
     0.960    21.130     0.200
     1.139    25.235     0.200
     1.141    24.016     0.200
     1.327    28.292     0.200
     1.533    31.339     0.200
     1.642    32.383     0.200
     1.669    32.797     0.200
     1.725    33.395     0.200
     2.029    37.289     0.200
     2.286    44.414     0.200
     2.463    44.013     0.200
     0.328    11.052     0.200
     1.301    25.732     0.200
     1.646    32.499     0.200
     1.737    33.847     0.200
     0.532    14.014     0.200
     0.685    16.784     0.200
     1.108    23.405     0.200
     1.215    24.513     0.200
     1.230    25.515     0.200
     1.466    28.325     0.200
     1.727    31.814     0.200
     2.049    37.944     0.200
     2.113    37.323     0.200
     0.061     6.381     0.200
     0.318     8.676     0.200
     0.450    10.175     0.200
     1.767    34.435     0.200
     1.828    36.509     0.200
     1.961    37.310     0.200
     1.961    39.060     0.200
     2.414    43.652     0.200
     2.763    49.775     0.200
     0.261    10.304     0.200
     0.638    13.527     0.200
     1.413    28.802     0.200
     1.656    32.917     0.200
     1.836    33.211     0.200
     1.836    32.707     0.200
     2.302    39.629     0.200
     2.641    44.593     0.200
     0.454    13.136     0.200
     0.466    11.901     0.200
     0.696    15.428     0.200
     1.074    22.901     0.200
     1.245    23.934     0.200
     1.708    32.234     0.200
     0.527    12.251     0.200
     1.442    28.139     0.200
     1.474    28.564     0.200
     1.511    28.653     0.200
     0.771    18.011     0.200
     0.780    19.103     0.200
     0.828    20.027     0.200
     1.068    24.209     0.200
     1.550    33.710     0.200
     1.793    37.647     0.200
     1.971    39.128     0.200
     1.971    39.617     0.200
     2.109    43.379     0.200
     2.191    42.263     0.200
     2.379    44.474     0.200
     2.540    48.421     0.200
     3.143    55.366     0.200
     0.384     9.722     0.200
     0.738    16.981     0.200
     0.950    20.985     0.200
     1.477    29.141     0.200
     1.542    31.693     0.200
     1.670    33.338     0.200
     2.150    39.141     0.200
     1.734    35.275     0.200
     2.941    55.381     0.200
     3.857    69.539     0.200
     1.655    33.852     0.200
     0.724    15.622     0.200
     0.797    18.032     0.200
     1.342    27.908     0.200
     1.342    27.716     0.200
     3.084    57.022     0.200
     0.356     8.910     0.200
     0.356     8.455     0.200
     0.557    13.094     0.200
     1.913    36.265     0.200
     1.913    37.224     0.200
     0.431    10.444     0.200
     0.590    15.281     0.200
     1.744    31.961     0.200
     0.790    16.925     0.200
     0.750    18.336     0.200
     1.495    29.481     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
