#!/bin/bash
gmt begin fes5.6_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance fes5.6'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.700    16.510
     0.800    17.884
     0.900    19.258
     1.000    20.632
     1.100    22.006
     1.200    23.381
     1.300    24.755
     1.400    26.129
     1.500    27.503
     1.600    28.877
     1.700    30.252
     1.800    31.626
     1.900    33.000
     2.000    34.374
     2.100    35.748
     2.200    37.123
     2.300    38.497
     2.400    39.871
     2.500    41.245
     2.600    42.620
     2.700    43.994
     2.800    45.368
     2.900    46.742
     3.000    48.116
     3.100    49.491
     3.200    50.865
     3.300    52.239
     3.400    53.613
     3.500    54.987
     3.600    56.361
     3.700    57.734
     3.800    59.108
     3.900    60.481
     4.000    61.855
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    54.361 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.614
     0.200     5.064
     0.300     6.826
     0.400     8.709
     0.500    10.638
     0.600    12.580
     0.700    14.525
     0.800    16.470
     0.900    18.273
     1.000    19.926
     1.100    21.579
     1.200    23.232
     1.300    24.885
     1.400    26.538
     1.500    28.191
     1.600    29.844
     1.700    31.497
     1.800    33.150
     1.900    34.803
     2.000    36.456
     2.100    38.109
     2.200    39.763
     2.300    41.416
     2.400    43.069
     2.500    44.721
     2.600    46.374
     2.700    48.027
     2.800    49.680
     2.900    51.332
     3.000    52.985
     3.100    54.638
     3.200    56.290
     3.300    57.943
     3.400    59.596
     3.500    61.248
     3.600    62.901
     3.700    64.553
     3.800    66.206
     3.900    67.858
     4.000    69.510
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.901 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    30.442
     0.900    32.844
     1.000    35.246
     1.100    37.648
     1.200    40.050
     1.300    42.452
     1.400    44.854
     1.500    47.255
     1.600    49.657
     1.700    52.059
     1.800    54.461
     1.900    56.863
     2.000    59.265
     2.100    61.667
     2.200    64.069
     2.300    66.470
     2.400    68.872
     2.500    71.274
     2.600    73.676
     2.700    76.078
     2.800    78.480
     2.900    80.882
     3.000    83.284
     3.100    85.685
     3.200    88.087
     3.300    90.489
     3.400    92.891
     3.500    95.293
     3.600    97.695
     3.700   100.095
     3.800   102.496
     3.900   104.897
     4.000   107.298
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    95.695 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     6.096
     0.200     8.542
     0.300    11.513
     0.400    14.683
     0.500    17.925
     0.600    21.182
     0.700    24.442
     0.800    27.703
     0.900    30.964
     1.000    33.818
     1.100    36.658
     1.200    39.497
     1.300    42.337
     1.400    45.177
     1.500    48.017
     1.600    50.857
     1.700    53.697
     1.800    56.536
     1.900    59.376
     2.000    62.216
     2.100    65.056
     2.200    67.896
     2.300    70.736
     2.400    73.576
     2.500    76.415
     2.600    79.254
     2.700    82.094
     2.800    84.933
     2.900    87.772
     3.000    90.612
     3.100    93.451
     3.200    96.290
     3.300    99.129
     3.400   101.969
     3.500   104.808
     3.600   107.647
     3.700   110.486
     3.800   113.324
     3.900   116.163
     4.000   119.002
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   106.647 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    21.466
     1.000    22.840
     1.100    24.215
     1.200    25.589
     1.300    26.963
     1.400    28.337
     1.500    29.711
     1.600    31.086
     1.700    32.460
     1.800    33.834
     1.900    35.208
     2.000    36.582
     2.100    37.957
     2.200    39.331
     2.300    40.705
     2.400    42.079
     2.500    43.453
     2.600    44.828
     2.700    46.202
     2.800    47.576
     2.900    48.950
     3.000    50.324
     3.100    51.699
     3.200    53.073
     3.300    54.447
     3.400    55.821
     3.500    57.195
     3.600    58.569
     3.700    59.943
     3.800    61.317
     3.900    62.690
     4.000    64.064
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     2.059
     0.200     4.118
     0.300     6.177
     0.400     8.236
     0.500    10.295
     0.600    12.355
     0.700    14.414
     0.800    16.473
     0.900    18.532
     1.000    20.591
     1.100    22.650
     1.200    24.709
     1.300    26.643
     1.400    28.296
     1.500    29.949
     1.600    31.602
     1.700    33.255
     1.800    34.908
     1.900    36.561
     2.000    38.214
     2.100    39.867
     2.200    41.521
     2.300    43.174
     2.400    44.827
     2.500    46.480
     2.600    48.133
     2.700    49.785
     2.800    51.438
     2.900    53.091
     3.000    54.744
     3.100    56.397
     3.200    58.049
     3.300    59.702
     3.400    61.355
     3.500    63.007
     3.600    64.660
     3.700    66.313
     3.800    67.965
     3.900    69.617
     4.000    71.270
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    36.453
     1.000    38.855
     1.100    41.257
     1.200    43.659
     1.300    46.061
     1.400    48.463
     1.500    50.865
     1.600    53.267
     1.700    55.669
     1.800    58.071
     1.900    60.472
     2.000    62.874
     2.100    65.276
     2.200    67.678
     2.300    70.080
     2.400    72.482
     2.500    74.884
     2.600    77.286
     2.700    79.688
     2.800    82.090
     2.900    84.491
     3.000    86.893
     3.100    89.295
     3.200    91.697
     3.300    94.099
     3.400    96.501
     3.500    98.903
     3.600   101.305
     3.700   103.707
     3.800   106.107
     3.900   108.508
     4.000   110.909
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.475
     0.200     6.949
     0.300    10.424
     0.400    13.899
     0.500    17.373
     0.600    20.848
     0.700    24.323
     0.800    27.798
     0.900    31.272
     1.000    34.747
     1.100    38.222
     1.200    41.696
     1.300    45.171
     1.400    48.036
     1.500    50.876
     1.600    53.716
     1.700    56.556
     1.800    59.396
     1.900    62.236
     2.000    65.076
     2.100    67.915
     2.200    70.755
     2.300    73.595
     2.400    76.435
     2.500    79.275
     2.600    82.114
     2.700    84.954
     2.800    87.793
     2.900    90.633
     3.000    93.472
     3.100    96.312
     3.200    99.151
     3.300   101.990
     3.400   104.830
     3.500   107.669
     3.600   110.508
     3.700   113.347
     3.800   116.186
     3.900   119.025
     4.000   121.864
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     8.324
     0.200     8.854
     0.300     9.665
     0.400    10.682
     0.500    11.839
     0.600    13.085
     0.700    14.381
     0.800    15.706
     0.900    17.047
     1.000    18.398
     1.100    19.755
     1.200    21.116
     1.300    22.480
     1.400    23.845
     1.500    25.212
     1.600    26.579
     1.700    27.948
     1.800    29.317
     1.900    30.687
     2.000    32.057
     2.100    33.427
     2.200    34.797
     2.300    36.168
     2.400    37.539
     2.500    38.910
     2.600    40.282
     2.700    41.653
     2.800    43.024
     2.900    44.396
     3.000    45.767
     3.100    47.139
     3.200    48.510
     3.300    49.882
     3.400    51.254
     3.500    52.625
     3.600    53.997
     3.700    55.369
     3.800    56.740
     3.900    58.112
     4.000    59.484
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    14.183
     0.200    15.090
     0.300    16.481
     0.400    18.230
     0.500    20.226
     0.600    22.380
     0.700    24.631
     0.800    26.939
     0.900    29.278
     1.000    31.636
     1.100    34.005
     1.200    36.383
     1.300    38.765
     1.400    41.150
     1.500    43.539
     1.600    45.929
     1.700    48.321
     1.800    50.714
     1.900    53.108
     2.000    55.502
     2.100    57.898
     2.200    60.293
     2.300    62.689
     2.400    65.086
     2.500    67.482
     2.600    69.879
     2.700    72.277
     2.800    74.674
     2.900    77.072
     3.000    79.469
     3.100    81.866
     3.200    84.264
     3.300    86.662
     3.400    89.060
     3.500    91.458
     3.600    93.856
     3.700    96.253
     3.800    98.652
     3.900   101.050
     4.000   103.447
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.163    35.781     0.200
     2.662    42.383     0.200
     8.367   123.383     0.200
     9.347   131.586     0.200
     9.915   143.180     0.200
    10.755   160.383     0.200
    10.836   157.383     0.200
    12.684   179.883     0.200
    13.486   189.383     0.200
    16.059   225.383     0.200
    17.392   238.680     0.200
    20.162   276.383     0.200
     1.376    24.305     0.200
     2.526    40.305     0.200
     2.591    43.305     0.200
     2.600    41.305     0.200
     3.212    51.305     0.200
     4.327    64.105     0.200
     5.619    84.504     0.200
     7.360   108.305     0.200
     7.878   114.805     0.200
    18.955   263.305     0.200
    19.625   270.305     0.200
    20.859   284.305     0.200
     1.474    28.992     0.200
     2.146    37.992     0.200
     2.525    42.992     0.200
     4.815    73.992     0.200
     4.815    74.992     0.200
     5.673    87.492     0.200
     5.673    87.992     0.200
    19.016   265.992     0.200
    19.558   270.992     0.200
    20.423   279.992     0.200
     1.370    26.328     0.200
     3.660    57.531     0.200
     5.573    84.727     0.200
     6.585    99.727     0.200
    14.706   210.125     0.200
    18.538   261.531     0.200
    18.672   260.328     0.200
    19.094   267.328     0.200
    19.167   266.328     0.200
    19.714   272.328     0.200
    20.580   282.828     0.200
     0.969    20.919     0.200
     1.672    29.919     0.200
     1.828    31.419     0.200
     1.828    32.619     0.200
     2.357    41.419     0.200
     2.882    48.219     0.200
     3.410    57.519     0.200
     3.963    61.919     0.200
     6.081    93.419     0.200
     7.309   106.719     0.200
     7.882   116.419     0.200
    19.476   269.419     0.200
    20.365   278.419     0.200
     1.506    26.422     0.200
     1.822    31.121     0.200
     2.760    44.621     0.200
     3.206    51.621     0.200
     3.606    56.621     0.200
     4.058    64.621     0.200
     4.169    67.922     0.200
     5.042    77.121     0.200
     6.219    92.121     0.200
     6.249    92.121     0.200
     6.586    97.121     0.200
     7.272   106.621     0.200
     7.300   105.922     0.200
     8.221   119.121     0.200
     9.343   137.223     0.200
    10.609   151.320     0.200
    10.804   156.621     0.200
    12.362   175.922     0.200
    12.461   174.922     0.200
    13.793   194.922     0.200
    14.120   199.621     0.200
    14.932   213.422     0.200
    14.974   212.820     0.200
    15.220   214.723     0.200
    15.313   216.520     0.200
    15.377   216.820     0.200
    15.519   218.723     0.200
    15.696   221.621     0.200
    15.802   221.820     0.200
    19.315   265.621     0.200
    19.356   268.121     0.200
    19.732   273.422     0.200
    20.381   280.922     0.200
    20.574   282.121     0.200
    20.580   281.121     0.200
     1.569    28.415     0.200
     1.801    32.215     0.200
     2.598    42.215     0.200
     3.055    46.215     0.200
     3.870    56.215     0.200
     3.858    59.215     0.200
     4.720    73.215     0.200
     7.009   105.715     0.200
     7.665   111.615     0.200
    13.914   200.015     0.200
     2.580    43.746     0.200
     3.883    59.547     0.200
     3.860    60.047     0.200
     4.481    72.848     0.200
     4.572    70.246     0.200
     4.607    71.547     0.200
     7.010   104.047     0.200
     7.655   113.047     0.200
     9.153   135.047     0.200
    10.249   148.047     0.200
    11.219   163.047     0.200
    18.662   260.148     0.200
    20.783   283.047     0.200
     1.604    30.320     0.200
     1.940    35.320     0.200
     2.250    39.320     0.200
     2.454    41.820     0.200
     4.599    73.820     0.200
     4.857    75.023     0.200
     5.448    84.422     0.200
     5.546    84.922     0.200
     5.458    84.422     0.200
     5.521    86.219     0.200
     5.656    86.320     0.200
     5.778    86.820     0.200
     5.894    88.820     0.200
     6.733   102.422     0.200
     7.089   106.820     0.200
     7.073   106.820     0.200
     7.476   111.023     0.200
     7.653   114.820     0.200
     7.703   115.320     0.200
     8.014   119.320     0.200
     8.156   119.617     0.200
     8.443   126.820     0.200
     8.648   127.117     0.200
     8.657   126.422     0.200
     8.759   128.023     0.200
     9.578   139.320     0.200
    10.039   148.820     0.200
    10.757   159.320     0.200
    11.249   162.820     0.200
    11.963   174.023     0.200
    13.510   195.320     0.200
    13.595   193.820     0.200
    13.722   199.617     0.200
    13.834   199.617     0.200
    14.207   204.422     0.200
    15.257   219.117     0.200
    15.245   218.320     0.200
    15.481   221.820     0.200
    15.552   222.523     0.200
    15.642   224.117     0.200
    15.913   228.023     0.200
    17.137   242.820     0.200
    18.453   259.820     0.200
    18.523   260.617     0.200
    18.543   260.320     0.200
    18.736   263.023     0.200
    18.702   264.820     0.200
    18.978   265.320     0.200
    19.001   265.422     0.200
    19.035   265.617     0.200
    19.254   268.820     0.200
    19.608   272.219     0.200
    19.699   273.320     0.200
    19.896   275.820     0.200
    20.180   277.820     0.200
    20.180   281.820     0.200
    20.592   286.320     0.200
     2.391    38.508     0.200
     2.576    40.508     0.200
     3.074    49.008     0.200
     3.362    52.008     0.200
     3.507    54.508     0.200
     3.844    58.508     0.200
     3.863    61.008     0.200
     4.208    64.207     0.200
     4.368    67.508     0.200
     4.970    78.508     0.200
     5.035    77.508     0.200
     5.302    79.109     0.200
     5.336    80.508     0.200
     5.408    80.508     0.200
     5.463    81.508     0.200
     5.485    81.508     0.200
     5.566    82.008     0.200
     5.621    82.008     0.200
     5.759    85.508     0.200
     5.776    85.207     0.200
     5.980    87.109     0.200
     6.062    89.906     0.200
     6.316    91.906     0.200
     6.535    96.008     0.200
     6.553    95.109     0.200
     6.626    95.809     0.200
     6.659    96.309     0.200
     6.715    99.008     0.200
     6.930   101.508     0.200
     7.020   102.406     0.200
     7.723   113.020     0.200
     7.929   114.707     0.200
     8.007   116.008     0.200
     8.447   122.008     0.200
     8.469   121.508     0.200
     8.769   127.707     0.200
     8.936   127.809     0.200
     9.526   135.309     0.200
     9.566   137.207     0.200
     9.737   139.508     0.200
    10.296   147.008     0.200
    10.319   150.508     0.200
    10.352   145.008     0.200
    10.329   147.180     0.200
    10.485   149.309     0.200
    11.155   159.008     0.200
    11.374   160.008     0.200
    11.457   162.906     0.200
    11.446   164.418     0.200
    11.533   163.508     0.200
    12.122   173.477     0.200
    12.098   173.207     0.200
    12.133   173.309     0.200
    12.189   173.707     0.200
    12.190   173.809     0.200
    12.202   173.609     0.200
    12.208   173.508     0.200
    12.295   175.207     0.200
    12.197   170.508     0.200
    12.307   177.508     0.200
    12.339   176.906     0.200
    12.423   178.457     0.200
    12.305   174.508     0.200
    12.436   176.746     0.200
    12.376   177.309     0.200
    12.501   177.008     0.200
    13.008   186.809     0.200
    13.853   195.609     0.200
    14.101   199.309     0.200
    14.242   202.109     0.200
    14.550   205.609     0.200
    14.765   207.609     0.200
    14.806   209.809     0.200
    14.833   210.309     0.200
    15.045   213.809     0.200
    15.305   218.406     0.200
    15.486   218.508     0.200
    15.517   220.508     0.200
    15.537   218.109     0.200
    15.563   218.809     0.200
    15.611   220.707     0.200
    15.629   222.309     0.200
    15.660   219.309     0.200
    15.680   220.707     0.200
    15.672   221.906     0.200
    15.740   222.707     0.200
    15.792   222.809     0.200
    15.845   224.609     0.200
    16.053   226.508     0.200
    16.053   227.207     0.200
    16.091   229.109     0.200
    16.983   239.207     0.200
    17.528   244.508     0.200
    17.528   245.309     0.200
    17.629   245.809     0.200
    17.631   246.309     0.200
    17.799   248.629     0.200
    17.825   248.406     0.200
    17.884   248.508     0.200
    17.884   248.906     0.200
    18.052   252.008     0.200
    18.149   252.609     0.200
    18.283   254.406     0.200
    18.413   256.508     0.200
    18.413   256.809     0.200
    18.564   257.328     0.200
    18.566   258.809     0.200
    18.566   258.707     0.200
    18.554   259.008     0.200
    18.659   259.809     0.200
    18.659   259.707     0.200
    18.754   259.508     0.200
    18.763   261.109     0.200
    18.916   262.207     0.200
    19.031   263.809     0.200
    19.031   263.707     0.200
    20.193   275.738     0.200
    20.847   285.508     0.200
     2.374    39.520     0.200
     2.537    41.020     0.200
     3.327    52.520     0.200
     3.478    55.520     0.200
     3.845    61.020     0.200
     3.804    60.520     0.200
     4.214    64.820     0.200
     5.021    77.520     0.200
     5.289    78.719     0.200
     5.320    81.520     0.200
     5.395    81.520     0.200
     5.447    83.520     0.200
     5.621    84.020     0.200
     5.766    85.719     0.200
     5.533    83.020     0.200
     5.987    88.820     0.200
     6.061    90.520     0.200
     6.311    94.219     0.200
     6.513    96.020     0.200
     6.531    96.219     0.200
     6.616    97.918     0.200
     6.642    97.520     0.200
     6.718   100.621     0.200
     6.928   102.418     0.200
     7.029   103.418     0.200
     7.537   111.020     0.200
     7.749   114.129     0.200
     7.940   116.719     0.200
     7.986   116.020     0.200
     8.431   122.219     0.200
     8.447   122.520     0.200
     8.776   129.141     0.200
     8.925   128.719     0.200
     9.510   136.719     0.200
     9.548   138.219     0.200
    10.306   147.520     0.200
    10.329   150.520     0.200
    10.314   147.020     0.200
    11.190   159.020     0.200
    11.362   163.418     0.200
    11.441   164.219     0.200
    11.569   163.520     0.200
    11.625   165.020     0.200
    12.106   173.609     0.200
    12.136   177.219     0.200
    12.195   177.219     0.200
    12.205   178.020     0.200
    12.212   178.320     0.200
    12.235   173.520     0.200
    12.410   177.879     0.200
    12.342   174.520     0.200
    12.538   178.520     0.200
    13.042   185.520     0.200
    14.107   202.020     0.200
    14.247   203.418     0.200
    14.558   206.918     0.200
    14.771   209.719     0.200
    14.823   211.820     0.200
    14.850   212.418     0.200
    15.063   214.918     0.200
    15.507   220.719     0.200
    15.641   221.449     0.200
    15.666   221.219     0.200
    15.862   223.520     0.200
    15.891   224.621     0.200
    18.491   257.918     0.200
    18.577   258.410     0.200
    18.583   259.918     0.200
    18.627   259.320     0.200
    18.629   258.758     0.200
    18.577   259.621     0.200
    18.674   260.719     0.200
    18.693   259.320     0.200
    18.766   260.020     0.200
    18.789   261.918     0.200
    18.795   262.320     0.200
    18.930   262.219     0.200
    18.927   263.320     0.200
    19.048   265.820     0.200
    19.085   263.719     0.200
    19.109   263.949     0.200
    19.201   265.219     0.200
    19.294   265.918     0.200
    19.297   267.320     0.200
    19.321   266.320     0.200
    19.604   269.531     0.200
    19.962   273.520     0.200
    19.993   274.621     0.200
    20.032   275.020     0.200
    20.242   276.719     0.200
    20.548   280.520     0.200
    20.833   284.141     0.200
    20.855   284.820     0.200
    20.870   283.918     0.200
    20.953   284.520     0.200
    20.983   290.121     0.200
     1.761    29.688     0.200
     1.764    31.188     0.200
     1.839    32.188     0.200
     1.903    37.188     0.200
     2.042    32.887     0.200
     2.055    35.688     0.200
     2.689    43.688     0.200
     2.960    47.887     0.200
     3.134    49.688     0.200
     3.295    51.586     0.200
     3.790    59.688     0.200
     3.833    58.188     0.200
     4.255    64.688     0.200
     4.416    66.688     0.200
     4.631    69.188     0.200
     5.025    74.688     0.200
     5.813    86.887     0.200
     6.934   100.188     0.200
     6.934    99.988     0.200
     1.540    29.207     0.200
     1.776    32.707     0.200
     2.120    38.207     0.200
     2.587    42.207     0.200
     2.505    46.207     0.200
     2.769    45.906     0.200
     2.806    47.809     0.200
     2.961    49.707     0.200
     3.103    52.008     0.200
     3.339    54.809     0.200
     3.636    57.707     0.200
     3.858    61.105     0.200
     3.860    62.508     0.200
     4.332    67.406     0.200
     4.345    69.105     0.200
     4.804    74.207     0.200
     1.706    32.914     0.200
     2.095    39.414     0.200
     2.434    40.414     0.200
     2.803    46.914     0.200
     2.827    45.414     0.200
     2.999    49.414     0.200
     3.569    58.914     0.200
     3.874    60.812     0.200
     3.896    62.715     0.200
     4.327    65.914     0.200
     4.396    69.414     0.200
     4.733    75.414     0.200
     1.660    32.349     0.200
     1.896    31.349     0.200
     1.867    34.849     0.200
     2.325    38.349     0.200
     2.841    46.749     0.200
     2.874    46.999     0.200
     2.988    47.779     0.200
     3.049    49.559     0.200
     3.291    53.569     0.200
     3.535    55.429     0.200
     3.693    59.389     0.200
     3.780    59.069     0.200
     3.843    60.149     0.200
     3.813    61.349     0.200
     4.085    63.949     0.200
     4.102    63.459     0.200
     4.861    74.559     0.200
     5.224    77.349     0.200
     6.000    88.089     0.200
     6.252    93.729     0.200
     6.617    98.649     0.200
     7.019   103.879     0.200
     7.230   104.949     0.200
     7.855   114.509     0.200
    19.527   273.349     0.200
    20.126   279.149     0.200
     1.470    23.094     0.200
     2.304    38.094     0.200
     2.295    35.594     0.200
     2.936    46.992     0.200
     3.032    49.094     0.200
     3.072    50.391     0.200
     3.342    53.992     0.200
     3.453    55.094     0.200
     3.654    55.391     0.200
     3.717    56.094     0.200
     4.038    63.094     0.200
     4.127    63.594     0.200
     4.403    68.094     0.200
     4.925    75.094     0.200
    20.242   274.891     0.200
     1.939    33.066     0.200
     2.455    41.367     0.200
     2.604    41.367     0.200
     2.628    43.867     0.200
     2.713    45.066     0.200
     2.726    45.867     0.200
     3.215    52.367     0.200
     3.518    55.867     0.200
     3.649    57.867     0.200
     3.663    57.867     0.200
     3.716    58.566     0.200
     3.797    59.266     0.200
     3.913    61.168     0.200
     3.974    60.867     0.200
     4.216    66.367     0.200
     4.361    66.969     0.200
     4.450    67.367     0.200
     4.536    67.969     0.200
     4.572    69.367     0.200
     5.026    77.168     0.200
     6.853   100.566     0.200
     8.055   116.867     0.200
    20.984   287.168     0.200
    20.984   290.469     0.200
     1.988    35.164     0.200
     1.875    33.465     0.200
     1.923    35.445     0.200
     2.335    39.164     0.200
     2.167    35.062     0.200
     2.728    43.664     0.200
     2.830    44.965     0.200
     2.879    46.465     0.200
     3.575    54.465     0.200
     3.933    60.965     0.200
     4.252    67.164     0.200
     1.100    22.018     0.200
     1.716    30.018     0.200
     1.921    32.718     0.200
     2.087    34.018     0.200
     2.828    46.317     0.200
     2.866    47.817     0.200
     2.872    47.817     0.200
     2.891    46.018     0.200
     3.006    48.118     0.200
     3.070    50.317     0.200
     3.309    54.118     0.200
     3.464    55.417     0.200
     3.717    56.618     0.200
     3.806    57.618     0.200
     3.869    59.018     0.200
     4.100    65.018     0.200
     4.122    63.417     0.200
     4.246    64.718     0.200
     4.195    66.018     0.200
     4.464    67.018     0.200
     4.878    74.917     0.200
     5.588    83.417     0.200
    20.136   277.718     0.200
     1.933    33.754     0.200
     2.739    47.773     0.200
     2.942    48.953     0.200
     3.078    49.555     0.200
     3.194    51.652     0.200
     3.362    54.953     0.200
     3.460    56.055     0.200
     3.631    58.754     0.200
     3.681    57.754     0.200
     3.752    57.453     0.200
     3.872    61.852     0.200
     4.338    68.852     0.200
     4.397    67.555     0.200
     4.428    67.754     0.200
     4.497    69.953     0.200
     4.490    70.652     0.200
     4.706    72.254     0.200
     4.791    73.352     0.200
     5.071    77.152     0.200
     5.087    77.152     0.200
     5.094    77.754     0.200
     5.144    79.953     0.200
     5.241    79.254     0.200
     5.854    88.852     0.200
     5.865    87.754     0.200
     5.986    90.555     0.200
     6.539    97.453     0.200
     6.673    99.254     0.200
     6.950   103.453     0.200
     7.336   108.453     0.200
    16.920   239.352     0.200
    20.554   283.453     0.200
     3.190    51.852     0.200
     3.969    63.852     0.200
     4.023    62.852     0.200
     4.643    70.352     0.200
     4.850    73.551     0.200
     4.869    74.051     0.200
     4.854    73.652     0.200
     4.957    75.051     0.200
     5.068    76.752     0.200
     5.119    77.352     0.200
     5.192    78.652     0.200
     5.372    81.051     0.200
     5.503    82.451     0.200
     6.107    90.852     0.200
     6.894   101.752     0.200
     7.140   105.051     0.200
     8.066   118.252     0.200
     8.577   124.852     0.200
     8.973   130.352     0.200
     1.799    31.791     0.200
     2.435    39.791     0.200
     2.683    44.791     0.200
     3.203    49.791     0.200
     3.203    51.791     0.200
     3.685    58.990     0.200
     4.149    64.291     0.200
     4.440    69.891     0.200
     4.745    73.990     0.200
     4.777    71.592     0.200
     4.856    72.891     0.200
     4.945    73.791     0.200
     4.986    74.490     0.200
     4.991    74.490     0.200
     5.054    75.891     0.200
     5.095    75.990     0.200
     5.206    77.490     0.200
     5.257    78.291     0.200
     5.329    79.490     0.200
     5.532    85.291     0.200
     5.546    83.291     0.200
     6.313    94.092     0.200
     6.994   102.291     0.200
     7.313   106.791     0.200
     7.929   115.291     0.200
     8.472   124.191     0.200
     8.494   123.791     0.200
     1.790    31.037     0.200
     3.315    53.037     0.200
     3.797    58.537     0.200
     4.263    64.736     0.200
     4.451    66.438     0.200
     4.563    70.338     0.200
     4.861    71.736     0.200
     4.949    72.838     0.200
     5.045    73.938     0.200
     5.093    75.137     0.200
     5.172    76.137     0.200
     5.276    77.637     0.200
     5.332    78.438     0.200
     5.408    79.537     0.200
     5.668    83.938     0.200
     5.585    82.037     0.200
     5.726    83.736     0.200
     6.437    95.736     0.200
     7.368   106.236     0.200
     7.423   106.838     0.200
     2.516    43.307     0.200
     2.987    49.428     0.200
     3.393    54.328     0.200
     3.455    56.307     0.200
     3.456    54.328     0.200
     3.580    56.947     0.200
     3.727    59.361     0.200
     3.790    60.146     0.200
     3.815    59.646     0.200
     3.774    60.207     0.200
     3.808    60.801     0.200
     3.914    61.146     0.200
     3.896    61.848     0.200
     4.057    62.547     0.200
     4.086    63.348     0.200
     4.146    64.646     0.200
     4.505    70.748     0.200
     4.638    72.607     0.200
     5.035    77.047     0.200
     5.371    82.807     0.200
     5.900    88.947     0.200
     5.900    88.826     0.200
     6.119    91.088     0.200
     6.811   101.227     0.200
     7.469   110.367     0.200
     1.915    35.055     0.200
     2.491    41.117     0.200
     2.952    47.398     0.200
     3.183    49.820     0.200
     3.274    52.336     0.200
     3.306    53.531     0.200
     3.585    56.594     0.200
     3.682    58.734     0.200
     3.903    59.438     0.200
     3.466    55.055     0.200
     3.813    60.078     0.200
     3.978    60.453     0.200
     4.124    62.953     0.200
     4.361    67.320     0.200
     4.413    70.031     0.200
     4.350    65.758     0.200
     4.575    68.953     0.200
     4.553    68.555     0.200
     5.193    77.352     0.200
     5.797    86.414     0.200
     5.797    86.414     0.200
     2.714    44.516     0.200
     2.804    45.570     0.200
     2.815    46.311     0.200
     3.009    47.830     0.200
     3.103    48.808     0.200
     3.140    51.145     0.200
     3.413    55.167     0.200
     3.520    56.481     0.200
     3.691    57.103     0.200
     3.712    57.624     0.200
     3.713    57.859     0.200
     3.708    57.370     0.200
     3.725    59.752     0.200
     3.857    59.471     0.200
     3.920    60.370     0.200
     3.984    60.971     0.200
     4.075    62.219     0.200
     4.263    64.785     0.200
     4.265    65.009     0.200
     4.237    67.375     0.200
     4.298    65.471     0.200
     4.497    68.271     0.200
     4.506    68.183     0.200
     4.805    74.551     0.200
     4.998    76.902     0.200
     5.118    76.570     0.200
     5.384    81.771     0.200
     5.468    81.881     0.200
     5.638    84.420     0.200
     5.638    84.507     0.200
     5.766    86.570     0.200
     5.820    89.104     0.200
     5.960    88.870     0.200
     5.997    89.131     0.200
     6.025    89.471     0.200
     6.098    90.570     0.200
     6.413    96.144     0.200
     6.574    97.170     0.200
     6.956   102.166     0.200
     7.135   105.442     0.200
     7.207   105.370     0.200
     7.446   108.879     0.200
     7.792   113.670     0.200
     8.023   119.051     0.200
     8.058   119.771     0.200
     8.425   122.926     0.200
     8.556   127.030     0.200
     9.168   132.162     0.200
     9.474   136.715     0.200
     9.474   137.811     0.200
     9.482   139.170     0.200
     9.668   140.870     0.200
     9.688   141.870     0.200
     9.886   143.170     0.200
    10.007   146.271     0.200
    10.092   146.771     0.200
    10.406   152.271     0.200
    10.858   159.670     0.200
    11.728   169.471     0.200
    12.145   172.670     0.200
    13.878   196.370     0.200
    14.268   201.471     0.200
    14.498   205.271     0.200
    14.952   212.870     0.200
    15.050   212.971     0.200
    15.119   215.471     0.200
    18.597   257.960     0.200
    18.654   259.070     0.200
    18.654   259.170     0.200
    18.735   261.051     0.200
    18.759   260.570     0.200
    18.920   263.070     0.200
    19.040   263.670     0.200
    19.139   264.570     0.200
    19.400   268.271     0.200
    19.700   270.370     0.200
    19.700   270.370     0.200
    19.912   273.471     0.200
    19.984   274.070     0.200
    20.567   285.271     0.200
     1.359    26.261     0.200
     3.132    50.761     0.200
     3.778    59.963     0.200
     3.935    63.757     0.200
     3.920    63.969     0.200
     3.996    64.122     0.200
     4.447    69.362     0.200
     4.789    76.062     0.200
     5.516    84.781     0.200
     5.816    87.990     0.200
     5.945    90.949     0.200
     6.016    91.112     0.200
     6.016    90.961     0.200
     7.602   112.681     0.200
     1.247    22.629     0.200
     2.672    43.188     0.200
     2.852    46.070     0.200
     3.165    48.629     0.200
     3.415    52.230     0.200
     3.423    52.328     0.200
     3.306    51.629     0.200
     3.465    54.230     0.200
     3.492    53.688     0.200
     3.514    54.730     0.200
     3.752    57.707     0.200
     3.780    59.348     0.200
     3.835    60.070     0.200
     4.042    60.527     0.200
     3.915    60.270     0.200
     4.378    66.730     0.200
     4.490    68.410     0.200
     4.491    68.945     0.200
     4.840    72.230     0.200
     4.739    72.109     0.200
     5.071    75.457     0.200
     5.222    77.027     0.200
     5.449    79.629     0.200
     5.428    81.270     0.200
     5.427    81.629     0.200
     5.597    82.668     0.200
     5.524    83.336     0.200
     5.685    83.430     0.200
     5.732    84.230     0.200
     5.815    85.828     0.200
     5.815    85.777     0.200
     5.905    88.137     0.200
     6.292    92.199     0.200
     6.650    96.527     0.200
     6.690    99.168     0.200
     6.913   101.348     0.200
     7.177   103.730     0.200
     7.460   108.930     0.200
     7.629   110.430     0.200
     7.645   110.027     0.200
     7.804   112.406     0.200
     7.751   113.258     0.200
     7.905   109.828     0.200
     8.179   117.480     0.200
     8.234   118.707     0.200
     8.409   118.629     0.200
     8.534   123.469     0.200
     8.598   124.566     0.200
     8.761   121.730     0.200
     8.849   128.207     0.200
     8.945   129.430     0.200
     9.285   133.250     0.200
     9.261   134.309     0.200
     9.570   137.988     0.200
     9.734   140.148     0.200
     9.746   140.828     0.200
     9.783   140.527     0.200
     9.793   140.930     0.200
     9.818   141.730     0.200
     9.900   142.430     0.200
     9.933   143.230     0.200
     9.966   143.430     0.200
    10.027   144.430     0.200
    10.024   144.129     0.200
    10.085   145.027     0.200
    10.182   146.430     0.200
    10.203   141.168     0.200
    10.272   148.328     0.200
    10.407   149.230     0.200
    10.524   151.129     0.200
    10.795   155.230     0.200
    10.881   156.828     0.200
    12.057   171.328     0.200
    12.057   171.430     0.200
    12.539   177.527     0.200
    12.649   178.930     0.200
    12.659   182.027     0.200
    13.279   187.730     0.200
    13.742   193.930     0.200
    13.742   194.527     0.200
    13.939   195.629     0.200
    14.204   200.027     0.200
    14.339   200.527     0.200
    14.339   200.828     0.200
    14.354   201.328     0.200
    14.590   205.527     0.200
    14.785   208.027     0.200
    14.874   209.629     0.200
    15.139   212.828     0.200
    15.219   213.328     0.200
    15.598   219.629     0.200
    17.583   242.113     0.200
    18.332   254.930     0.200
    18.422   256.129     0.200
    18.498   256.430     0.200
    18.699   258.328     0.200
    18.865   262.328     0.200
    18.909   260.730     0.200
    18.925   261.527     0.200
    19.077   262.328     0.200
    19.081   264.828     0.200
    19.087   263.730     0.200
    19.305   263.828     0.200
    19.430   266.930     0.200
    20.202   274.430     0.200
    20.202   274.430     0.200
    20.641   279.730     0.200
     2.388    40.043     0.200
     2.840    46.203     0.200
     2.984    47.480     0.200
     3.086    50.461     0.200
     3.133    52.062     0.200
     3.296    53.301     0.200
     3.394    55.250     0.200
     3.518    57.262     0.200
     3.733    59.121     0.200
     3.677    58.582     0.200
     3.920    61.023     0.200
     3.911    60.852     0.200
     3.982    61.551     0.200
     4.028    64.426     0.200
     4.087    64.020     0.200
     4.188    65.281     0.200
     4.206    66.586     0.200
     4.582    69.922     0.200
     4.560    69.023     0.200
     4.759    74.043     0.200
     4.837    74.668     0.200
     4.973    76.562     0.200
     5.338    82.238     0.200
     5.473    82.512     0.200
     5.474    82.371     0.200
     5.639    83.660     0.200
     6.026    89.652     0.200
     8.064   119.711     0.200
     1.187    25.182     0.200
     1.489    27.182     0.200
     2.156    36.182     0.200
     2.617    45.041     0.200
     3.560    58.416     0.200
     3.840    60.682     0.200
     3.896    61.969     0.200
     3.708    61.682     0.200
     4.252    69.059     0.200
     4.218    67.047     0.200
     4.918    75.521     0.200
     1.414    26.398     0.200
     3.014    48.328     0.200
     4.096    62.539     0.200
     4.154    63.531     0.200
     4.602    69.109     0.200
     4.780    71.820     0.200
     5.173    76.750     0.200
     1.801    30.766     0.200
     1.801    30.467     0.200
     1.549    27.678     0.200
     2.157    32.938     0.200
     2.157    33.678     0.200
     2.157    33.287     0.200
     2.452    40.078     0.200
     2.693    43.709     0.200
     2.836    46.404     0.200
     2.745    42.877     0.200
     3.489    55.666     0.200
     3.489    56.178     0.200
     3.847    58.385     0.200
     3.847    58.117     0.200
     4.729    72.707     0.200
     4.729    73.178     0.200
     4.040    61.232     0.200
     5.227    78.852     0.200
     1.643    30.633     0.200
     1.856    32.633     0.200
     2.700    46.633     0.200
     2.851    49.375     0.200
     3.032    49.102     0.200
     3.032    49.266     0.200
     3.080    50.633     0.200
     3.276    54.031     0.200
     3.307    54.633     0.200
     3.378    55.633     0.200
     3.619    59.016     0.200
     3.619    58.656     0.200
     3.704    61.391     0.200
     3.726    60.812     0.200
     3.952    63.312     0.200
     3.995    65.383     0.200
     4.017    66.016     0.200
     4.094    65.992     0.200
     4.234    66.266     0.200
     4.234    66.086     0.200
     4.262    66.922     0.200
     4.484    70.461     0.200
     4.632    72.219     0.200
     4.632    72.336     0.200
     4.713    73.930     0.200
     4.660    74.438     0.200
     4.660    74.703     0.200
     4.805    74.031     0.200
     4.805    74.734     0.200
     4.781    75.375     0.200
     4.852    77.156     0.200
     4.852    78.031     0.200
     5.284    81.266     0.200
     5.314    80.734     0.200
     5.607    86.930     0.200
     5.992    92.711     0.200
     6.202    93.547     0.200
     6.422    96.633     0.200
     6.976   104.734     0.200
     7.029   105.352     0.200
     7.124   106.875     0.200
     7.885   118.352     0.200
     8.250   121.836     0.200
     8.250   121.234     0.200
     8.385   123.609     0.200
     8.385   123.914     0.200
     8.494   125.180     0.200
     8.494   124.391     0.200
     9.696   142.602     0.200
     9.765   143.781     0.200
     9.798   143.508     0.200
    10.083   148.336     0.200
    10.092   147.930     0.200
    10.494   153.930     0.200
    11.474   166.734     0.200
    14.421   205.531     0.200
    14.818   210.836     0.200
    14.827   211.031     0.200
     1.262    22.156     0.200
     1.801    31.656     0.200
     1.952    32.156     0.200
     1.979    33.645     0.200
     1.984    33.656     0.200
     2.087    36.156     0.200
     2.477    39.105     0.200
     2.477    39.355     0.200
     2.939    46.113     0.200
     3.051    49.336     0.200
     3.051    50.457     0.200
     3.111    50.789     0.200
     3.234    50.203     0.200
     3.234    50.758     0.200
     3.321    52.457     0.200
     3.355    53.715     0.200
     3.503    56.293     0.200
     3.961    58.863     0.200
     3.961    59.555     0.200
     4.010    61.262     0.200
     3.984    62.574     0.200
     3.984    63.156     0.200
     4.052    60.285     0.200
     4.052    60.457     0.200
     4.082    61.895     0.200
     4.163    64.895     0.200
     4.151    65.316     0.200
     4.137    63.156     0.200
     4.459    66.637     0.200
     4.630    69.758     0.200
     4.671    69.957     0.200
     4.760    72.957     0.200
     4.926    75.258     0.200
     4.977    73.746     0.200
     4.977    73.957     0.200
     5.120    76.258     0.200
     5.276    80.566     0.200
     5.276    79.855     0.200
     5.626    81.953     0.200
     5.781    87.156     0.200
     6.118    90.258     0.200
     6.216    91.656     0.200
     6.318    93.078     0.200
     6.318    94.055     0.200
     6.572    96.734     0.200
     6.572    97.258     0.200
     6.660    96.957     0.200
     7.048   103.055     0.200
     7.014   102.805     0.200
     7.014   104.457     0.200
     7.529   109.855     0.200
     7.851   113.156     0.200
     8.002   117.910     0.200
     8.172   117.688     0.200
     9.422   136.758     0.200
     9.452   136.656     0.200
     9.813   142.156     0.200
    10.764   154.855     0.200
     1.920    30.205     0.200
     1.924    30.183     0.200
     1.852    33.383     0.200
     2.455    38.123     0.200
     2.336    39.383     0.200
     2.421    40.383     0.200
     2.899    45.323     0.200
     3.015    47.583     0.200
     2.894    44.681     0.200
     3.080    48.663     0.200
     3.186    48.991     0.200
     3.281    51.781     0.200
     3.317    53.543     0.200
     3.474    55.623     0.200
     3.943    62.411     0.200
     4.058    62.391     0.200
     3.964    59.301     0.200
     4.131    62.963     0.200
     4.197    65.383     0.200
     4.707    72.841     0.200
     4.643    68.483     0.200
     4.695    69.183     0.200
     5.228    79.873     0.200
     7.048   101.783     0.200
     7.526   108.683     0.200
     1.925    34.117     0.200
     4.039    64.359     0.200
     4.264    66.688     0.200
     4.425    69.312     0.200
     5.204    78.828     0.200
     5.185    79.938     0.200
     5.335    80.539     0.200
     5.332    81.047     0.200
     5.523    84.016     0.200
     5.754    87.719     0.200
     5.854    87.797     0.200
     5.907    89.094     0.200
     6.024    90.719     0.200
     6.336    95.516     0.200
     6.344    94.625     0.200
     7.399   109.617     0.200
     7.467   110.914     0.200
     7.429   109.055     0.200
     1.283    25.828     0.200
     1.508    30.266     0.200
     1.963    34.266     0.200
     2.447    40.266     0.200
     4.253    67.066     0.200
     4.253    66.664     0.200
     4.424    68.812     0.200
     4.424    69.664     0.200
     4.491    70.016     0.200
     4.492    69.465     0.200
     5.216    79.016     0.200
     5.301    79.977     0.200
     5.162    79.664     0.200
     5.162    78.555     0.200
     5.223    81.395     0.200
     5.247    80.191     0.200
     5.247    82.164     0.200
     5.341    80.418     0.200
     5.320    81.344     0.200
     5.543    83.566     0.200
     5.650    85.215     0.200
     5.767    86.566     0.200
     5.845    87.895     0.200
     5.888    90.742     0.200
     5.888    90.266     0.200
     6.010    90.766     0.200
     6.010    89.965     0.200
     6.351    95.367     0.200
     6.351    94.465     0.200
     6.905   102.766     0.200
     7.218   106.789     0.200
     7.218   102.957     0.200
     7.204   108.574     0.200
     7.412   109.566     0.200
     7.475   110.164     0.200
     7.419   109.055     0.200
     7.419   109.066     0.200
     8.035   118.465     0.200
     8.035   117.527     0.200
     9.365   136.965     0.200
     9.501   138.133     0.200
     9.546   138.387     0.200
    10.866   157.266     0.200
    10.974   158.293     0.200
    10.974   160.066     0.200
     2.897    47.473     0.200
     3.347    54.473     0.200
     3.554    56.892     0.200
     4.878    74.255     0.200
     4.889    74.371     0.200
     5.162    79.059     0.200
     5.359    80.873     0.200
     5.450    82.173     0.200
     5.911    88.480     0.200
     6.060    90.973     0.200
     6.347    97.305     0.200
     7.051   103.973     0.200
     7.077   104.473     0.200
     7.603   111.772     0.200
     7.980   117.173     0.200
     8.483   123.873     0.200
     8.856   128.272     0.200
     8.962   130.473     0.200
     1.792    31.867     0.200
     2.419    42.367     0.200
     2.592    45.367     0.200
     2.610    44.367     0.200
     3.096    51.367     0.200
     3.119    52.367     0.200
     3.696    59.711     0.200
     3.696    59.461     0.200
     3.842    58.945     0.200
     4.051    62.766     0.200
     4.131    64.227     0.200
     4.150    65.117     0.200
     4.343    66.883     0.200
     4.454    69.555     0.200
     4.505    71.984     0.200
     4.621    71.984     0.200
     4.725    74.508     0.200
     4.759    75.484     0.200
     4.864    74.242     0.200
     5.077    77.141     0.200
     5.119    77.297     0.200
     5.280    79.648     0.200
     5.387    83.305     0.200
     5.448    82.516     0.200
     5.515    83.266     0.200
     5.560    84.727     0.200
     5.645    84.766     0.200
     6.141    91.883     0.200
     6.157    92.469     0.200
     6.249    93.469     0.200
     6.465    96.469     0.200
     6.660   101.758     0.200
     7.008   103.453     0.200
     7.280   107.070     0.200
     7.278   107.070     0.200
     7.833   114.766     0.200
     7.872   115.477     0.200
     7.942   116.883     0.200
     8.205   119.766     0.200
     8.308   124.562     0.200
     8.421   122.000     0.200
     9.191   133.664     0.200
     9.241   134.055     0.200
     9.350   135.938     0.200
     9.747   140.656     0.200
    10.538   151.938     0.200
    10.580   153.102     0.200
    10.654   153.703     0.200
    10.834   158.312     0.200
    10.826   158.070     0.200
    10.855   158.469     0.200
    10.892   158.258     0.200
    15.246   215.766     0.200
    15.654   221.570     0.200
     1.277    25.609     0.200
     1.266    27.609     0.200
     1.713    32.609     0.200
     1.695    31.609     0.200
     2.386    41.609     0.200
     2.952    47.949     0.200
     2.984    49.609     0.200
     3.027    49.418     0.200
     3.135    51.609     0.200
     3.337    54.680     0.200
     3.822    58.789     0.200
     3.929    60.398     0.200
     4.072    64.238     0.200
     4.221    64.809     0.200
     4.506    69.047     0.200
     4.694    73.668     0.200
     4.731    73.789     0.200
     4.941    74.738     0.200
     5.638    85.809     0.200
     6.067    90.211     0.200
     6.086    92.609     0.200
     1.735    31.461     0.200
     1.855    32.461     0.200
     2.064    36.961     0.200
     2.269    38.461     0.200
     2.409    40.461     0.200
     2.646    43.461     0.200
     4.753    72.758     0.200
     4.905    72.367     0.200
     5.177    77.320     0.200
     5.504    84.398     0.200
     5.564    85.344     0.200
     5.635    86.492     0.200
     5.805    88.859     0.200
     6.054    89.023     0.200
     6.141    89.742     0.200
     6.512    95.383     0.200
     7.077   106.148     0.200
     7.158   104.281     0.200
     7.665   114.102     0.200
     8.070   116.570     0.200
     8.070   116.922     0.200
     8.848   127.570     0.200
    10.282   147.438     0.200
    10.363   148.109     0.200
     1.455    26.609     0.200
     1.656    30.609     0.200
     2.121    36.609     0.200
     3.248    50.609     0.200
     4.018    61.938     0.200
     4.084    61.730     0.200
     4.556    68.875     0.200
     4.556    67.609     0.200
     4.743    71.152     0.200
     5.102    76.391     0.200
     1.506    29.398     0.200
     1.629    29.898     0.200
     2.064    35.898     0.200
     2.733    45.898     0.200
     4.513    69.055     0.200
     4.673    70.570     0.200
     4.934    75.312     0.200
     5.433    84.844     0.200
     5.552    84.633     0.200
     5.808    86.297     0.200
     5.894    87.055     0.200
     5.932    87.695     0.200
     6.172    91.297     0.200
     6.212    94.375     0.200
     6.279    93.250     0.200
     6.367    93.898     0.200
     6.393    94.055     0.200
     6.959   103.195     0.200
     7.115   104.602     0.200
     7.467   112.750     0.200
     7.634   111.898     0.200
     7.840   114.078     0.200
     8.044   117.195     0.200
     9.901   142.695     0.200
     1.757    32.543     0.200
     1.762    30.492     0.200
     1.766    30.441     0.200
     2.036    36.543     0.200
     2.147    34.762     0.200
     2.266    40.043     0.200
     2.248    36.430     0.200
     2.274    35.711     0.200
     2.603    42.543     0.200
     2.998    45.973     0.200
     3.090    48.719     0.200
     3.287    52.160     0.200
     3.752    56.852     0.200
     3.752    60.043     0.200
     3.821    58.191     0.200
     3.875    59.633     0.200
     3.917    61.066     0.200
     3.946    59.090     0.200
     4.831    71.613     0.200
     1.809    30.535     0.200
     2.001    33.535     0.200
     2.240    35.836     0.200
     2.280    34.684     0.200
     2.267    40.035     0.200
     2.566    41.535     0.200
     3.031    46.953     0.200
     3.114    48.023     0.200
     3.777    58.656     0.200
     3.806    57.402     0.200
     3.883    58.344     0.200
     3.922    58.184     0.200
     4.817    71.125     0.200
     5.073    76.566     0.200
     1.336    26.520     0.200
     1.529    28.520     0.200
     1.897    34.020     0.200
     4.234    64.035     0.200
     4.288    65.049     0.200
     4.711    71.982     0.200
     4.684    71.020     0.200
     5.308    78.789     0.200
     5.525    83.020     0.200
     2.091    37.375     0.200
     2.412    40.875     0.200
     2.509    39.375     0.200
     2.510    40.875     0.200
     2.688    42.875     0.200
     2.993    47.875     0.200
     3.290    53.875     0.200
     3.455    55.875     0.200
     3.899    60.875     0.200
     4.128    62.789     0.200
     4.199    64.273     0.200
     4.275    65.785     0.200
     4.374    68.309     0.200
     4.463    69.445     0.200
     4.551    68.633     0.200
     4.520    70.875     0.200
     4.646    70.820     0.200
     4.922    76.875     0.200
     5.139    75.977     0.200
     5.257    80.645     0.200
     5.313    82.180     0.200
     5.537    83.875     0.200
     5.613    82.879     0.200
     5.625    84.574     0.200
     5.667    84.453     0.200
     5.796    84.598     0.200
     5.922    86.352     0.200
     6.300    95.820     0.200
     6.499    94.273     0.200
     6.539    94.875     0.200
     6.800    98.621     0.200
     6.984   101.375     0.200
     7.104   102.875     0.200
     7.118   104.848     0.200
     7.123   103.773     0.200
     7.933   114.773     0.200
     8.861   127.574     0.200
    11.157   160.113     0.200
    19.902   272.316     0.200
     1.918    34.570     0.200
     2.252    40.570     0.200
     2.927    48.570     0.200
     3.377    54.570     0.200
     4.011    62.738     0.200
     4.394    70.309     0.200
     4.770    72.070     0.200
     4.872    74.340     0.200
     4.872    73.969     0.200
     4.879    73.785     0.200
     5.143    79.359     0.200
     5.143    78.070     0.200
     5.211    82.875     0.200
     5.240    80.332     0.200
     5.902    87.840     0.200
     6.143    91.270     0.200
     7.042   103.469     0.200
     1.928    34.822     0.200
     2.108    37.322     0.200
     2.350    39.322     0.200
     2.442    40.822     0.200
     2.455    41.322     0.200
     2.537    42.322     0.200
     2.724    44.580     0.200
     2.725    44.623     0.200
     3.096    50.322     0.200
     3.241    53.322     0.200
     3.326    54.521     0.200
     3.345    54.039     0.200
     3.413    56.322     0.200
     3.587    59.322     0.200
     3.651    58.322     0.200
     3.910    60.322     0.200
     3.979    65.322     0.200
     4.071    62.871     0.200
     4.146    65.623     0.200
     4.203    64.732     0.200
     4.211    64.672     0.200
     4.284    68.322     0.200
     4.308    66.266     0.200
     4.400    67.402     0.200
     4.485    68.182     0.200
     4.550    69.322     0.200
     4.549    70.322     0.200
     4.582    70.930     0.200
     4.583    71.322     0.200
     4.653    71.461     0.200
     4.657    73.322     0.200
     4.653    71.762     0.200
     4.864    73.322     0.200
     4.883    73.223     0.200
     4.972    77.342     0.200
     5.083    76.223     0.200
     5.192    80.170     0.200
     5.365    79.322     0.200
     5.381    80.361     0.200
     5.542    84.623     0.200
     5.606    84.371     0.200
     5.642    83.740     0.200
     5.746    85.330     0.200
     5.799    88.322     0.200
     5.859    87.223     0.200
     5.877    86.732     0.200
     5.880    87.223     0.200
     6.233    94.320     0.200
     6.260    92.322     0.200
     6.285    93.123     0.200
     6.454    95.021     0.200
     6.500    95.822     0.200
     6.649   100.311     0.200
     6.748    99.242     0.200
     6.766    99.723     0.200
     6.839    99.422     0.200
     6.938   101.922     0.200
     6.949   102.422     0.200
     6.982   101.922     0.200
     7.054   103.723     0.200
     7.055   104.984     0.200
     7.055   104.742     0.200
     7.079   104.322     0.200
     7.268   108.533     0.200
     7.529   111.551     0.200
     7.700   112.021     0.200
     7.860   115.123     0.200
     7.881   115.123     0.200
     8.029   117.803     0.200
     8.120   120.891     0.200
     8.277   122.682     0.200
     8.411   122.822     0.200
     8.700   128.322     0.200
     8.809   127.723     0.200
     8.793   129.939     0.200
     8.887   131.410     0.200
     8.917   130.322     0.200
     8.979   130.521     0.200
     9.259   135.445     0.200
     9.267   134.322     0.200
     9.471   139.682     0.200
     9.522   138.021     0.200
     9.758   141.223     0.200
     9.787   145.072     0.200
     9.878   145.322     0.200
     9.913   143.701     0.200
    10.122   147.643     0.200
    10.171   148.623     0.200
    10.361   150.223     0.200
    10.469   153.502     0.200
    10.601   154.322     0.200
    10.641   153.422     0.200
    10.652   157.223     0.200
    10.751   155.383     0.200
    10.842   155.922     0.200
    10.992   158.021     0.200
    11.067   160.053     0.200
    11.119   160.473     0.200
    13.044   185.521     0.200
    13.545   196.422     0.200
    14.029   202.521     0.200
    14.146   199.623     0.200
    14.212   201.723     0.200
    15.137   213.723     0.200
    17.868   250.170     0.200
     1.312    25.620     0.200
     1.578    28.133     0.200
     1.582    28.120     0.200
     2.032    35.620     0.200
     2.173    38.620     0.200
     2.372    38.461     0.200
     2.414    42.830     0.200
     2.545    41.850     0.200
     2.692    43.334     0.200
     2.834    47.270     0.200
     2.732    45.620     0.200
     2.931    47.860     0.200
     2.933    49.560     0.200
     3.076    50.317     0.200
     3.123    50.739     0.200
     3.259    51.470     0.200
     3.341    54.990     0.200
     3.729    59.470     0.200
     3.951    62.280     0.200
     3.970    63.679     0.200
     4.017    62.620     0.200
     4.179    63.330     0.200
     4.199    63.420     0.200
     4.200    63.620     0.200
     4.666    69.620     0.200
     4.667    70.420     0.200
     4.753    71.420     0.200
     4.966    77.400     0.200
     4.966    77.110     0.200
     4.866    73.120     0.200
     5.016    76.118     0.200
     5.275    78.320     0.200
     5.328    80.420     0.200
     5.460    82.808     0.200
     6.149    91.620     0.200
     6.421    95.244     0.200
     6.842   102.678     0.200
     7.077   104.820     0.200
     7.257   107.120     0.200
     7.811   114.820     0.200
     9.165   134.020     0.200
     9.216   134.120     0.200
     1.324    24.531     0.200
     2.414    41.531     0.200
     2.645    44.531     0.200
     2.822    45.531     0.200
     2.918    47.531     0.200
     3.311    52.531     0.200
     3.610    58.203     0.200
     3.610    56.449     0.200
     3.552    56.551     0.200
     3.727    56.961     0.200
     4.058    62.332     0.200
     4.191    64.293     0.200
     4.311    66.312     0.200
     4.373    67.293     0.200
     4.454    68.711     0.200
     4.574    70.121     0.200
     4.763    72.672     0.200
     4.946    74.133     0.200
     5.012    75.031     0.200
     5.054    75.383     0.200
     5.068    75.062     0.200
     5.235    78.133     0.200
     5.296    78.832     0.200
     5.296    79.230     0.200
     5.234    79.859     0.200
     5.334    79.641     0.200
     5.426    81.590     0.200
     5.528    82.230     0.200
     5.538    82.430     0.200
     5.626    84.133     0.200
     6.091    90.188     0.200
     6.135    90.730     0.200
     6.329    93.332     0.200
     6.489    97.121     0.200
     6.886   100.383     0.200
     6.958   102.633     0.200
     7.231   105.633     0.200
     8.159   118.832     0.200
     8.339   121.543     0.200
     8.662   125.730     0.200
     9.035   130.930     0.200
     9.169   132.383     0.200
     9.300   134.102     0.200
     9.705   139.453     0.200
    10.530   150.430     0.200
     1.038    19.820     0.200
     0.987    20.320     0.200
     1.168    23.820     0.200
     2.562    40.539     0.200
     2.865    45.242     0.200
     4.200    63.938     0.200
     4.351    65.203     0.200
     4.367    65.422     0.200
     4.695    69.719     0.200
     5.117    77.938     0.200
     2.154    38.084     0.200
     3.904    60.659     0.200
     3.878    59.484     0.200
     3.908    60.142     0.200
     4.084    64.244     0.200
     4.275    70.294     0.200
     4.275    68.914     0.200
     4.236    66.764     0.200
     4.236    66.272     0.200
     4.174    65.584     0.200
     4.214    65.384     0.200
     4.375    67.384     0.200
     4.438    68.884     0.200
     4.483    68.584     0.200
     4.926    74.984     0.200
     5.169    79.384     0.200
     1.329    25.664     0.200
     2.255    37.664     0.200
     2.283    35.930     0.200
     2.709    43.734     0.200
     2.997    46.391     0.200
     3.092    48.625     0.200
     3.754    59.531     0.200
     3.837    57.992     0.200
     3.883    60.016     0.200
     3.964    59.562     0.200
     3.974    60.461     0.200
     4.329    65.766     0.200
     4.540    68.266     0.200
     4.623    69.266     0.200
     4.846    73.141     0.200
     5.022    74.766     0.200
     5.039    78.156     0.200
     5.039    76.250     0.200
     5.142    76.961     0.200
     5.418    79.625     0.200
     1.253    21.867     0.200
     1.170    20.867     0.200
     1.667    27.867     0.200
     1.669    27.867     0.200
     1.639    29.703     0.200
     2.155    35.867     0.200
     2.203    36.527     0.200
     2.254    36.867     0.200
     2.226    36.867     0.200
     2.407    38.305     0.200
     2.417    37.855     0.200
     2.449    37.867     0.200
     2.598    41.367     0.200
     2.627    41.445     0.200
     2.435    39.867     0.200
     2.659    41.867     0.200
     2.681    41.969     0.200
     2.688    43.027     0.200
     3.121    48.566     0.200
     3.122    49.008     0.200
     3.404    51.355     0.200
     3.429    55.043     0.200
     3.438    54.426     0.200
     3.476    53.848     0.200
     3.549    53.266     0.200
     3.597    53.969     0.200
     3.626    54.426     0.200
     3.624    54.156     0.200
     3.588    54.867     0.200
     3.824    57.434     0.200
     3.908    57.969     0.200
     3.779    57.867     0.200
     3.943    58.266     0.200
     3.997    60.266     0.200
     4.094    60.766     0.200
     4.092    63.266     0.200
     4.165    61.566     0.200
     4.201    61.969     0.200
     4.172    63.168     0.200
     4.308    66.602     0.200
     4.646    68.293     0.200
     4.705    69.668     0.200
     4.705    69.266     0.200
     4.740    69.668     0.200
     4.817    70.969     0.200
     4.887    72.168     0.200
     5.038    75.469     0.200
     5.382    78.867     0.200
     5.463    82.074     0.200
     5.563    81.168     0.200
     5.571    81.305     0.200
     5.571    81.445     0.200
     5.571    81.668     0.200
     5.504    81.867     0.200
     5.786    84.266     0.200
     5.821    84.766     0.200
     6.338    92.168     0.200
     6.338    91.766     0.200
     6.486    94.508     0.200
     6.715    97.168     0.200
     7.001   101.168     0.200
     7.135   103.445     0.200
     7.218   103.969     0.200
     7.285   104.766     0.200
     7.602   109.367     0.200
     7.698   110.766     0.200
     7.737   111.344     0.200
     7.856   112.996     0.200
     8.226   117.867     0.200
     9.047   129.719     0.200
     9.086   129.797     0.200
     9.078   130.898     0.200
     9.128   130.695     0.200
     9.150   131.145     0.200
     9.243   133.406     0.200
     9.258   133.652     0.200
     9.485   135.469     0.200
     9.490   135.867     0.200
     9.508   136.457     0.200
     9.545   137.145     0.200
     9.916   141.367     0.200
    11.735   165.766     0.200
    12.181   172.367     0.200
    12.314   173.367     0.200
    13.014   182.668     0.200
    13.778   192.969     0.200
    14.178   198.766     0.200
    14.184   198.566     0.200
    14.564   203.867     0.200
    14.902   208.566     0.200
     1.278    26.692     0.200
     2.301    41.692     0.200
     2.610    43.692     0.200
     2.610    44.692     0.200
     4.640    72.292     0.200
     5.315    80.393     0.200
     5.412    81.893     0.200
     5.484    83.062     0.200
     5.505    82.792     0.200
     5.584    84.400     0.200
     5.837    87.692     0.200
     6.001    92.792     0.200
     6.018    90.551     0.200
     6.031    90.692     0.200
     6.168    94.992     0.200
     6.168    96.093     0.200
     6.557    97.992     0.200
     6.600    98.362     0.200
     6.630    99.492     0.200
     7.729   113.992     0.200
     7.729   113.792     0.200
     8.985   131.792     0.200
     9.600   139.992     0.200
     1.643    30.430     0.200
     1.844    33.930     0.200
     1.868    33.930     0.200
     2.206    38.930     0.200
     2.381    40.930     0.200
     2.357    41.930     0.200
     2.790    45.758     0.200
     2.790    46.828     0.200
     2.757    46.930     0.200
     2.950    48.930     0.200
     3.149    49.930     0.200
     3.346    54.086     0.200
     3.345    53.820     0.200
     3.384    55.930     0.200
     3.454    55.633     0.200
     3.469    53.906     0.200
     3.703    60.578     0.200
     3.794    60.102     0.200
     3.850    60.930     0.200
     3.954    61.352     0.200
     3.944    65.930     0.200
     4.068    63.086     0.200
     4.124    64.531     0.200
     4.232    65.695     0.200
     4.337    67.695     0.200
     4.372    69.312     0.200
     4.510    70.727     0.200
     4.579    69.484     0.200
     4.538    72.930     0.200
     4.571    70.328     0.200
     4.567    71.930     0.200
     4.697    72.031     0.200
     4.650    72.930     0.200
     4.759    73.133     0.200
     4.798    73.898     0.200
     4.806    72.977     0.200
     4.963    75.836     0.200
     5.000    76.430     0.200
     4.998    77.828     0.200
     5.056    77.031     0.200
     5.077    77.391     0.200
     5.158    80.609     0.200
     5.178    79.289     0.200
     5.277    80.133     0.200
     5.286    80.430     0.200
     5.208    81.930     0.200
     5.371    81.531     0.200
     5.635    84.633     0.200
     5.636    85.930     0.200
     5.723    87.055     0.200
     5.828    87.719     0.200
     5.879    88.328     0.200
     5.879    88.531     0.200
     5.843    89.430     0.200
     5.939    90.750     0.200
     5.982    90.328     0.200
     5.921    90.133     0.200
     6.069    91.133     0.200
     6.189    92.930     0.200
     6.205    92.930     0.200
     6.271    95.828     0.200
     6.452    96.703     0.200
     6.387    96.430     0.200
     6.464    95.828     0.200
     6.492    98.031     0.200
     6.555    97.633     0.200
     6.628    98.359     0.200
     6.631    98.516     0.200
     6.633    98.531     0.200
     6.711   100.133     0.200
     6.968   103.227     0.200
     6.997   103.828     0.200
     7.391   113.430     0.200
     7.520   110.633     0.200
     7.520   110.430     0.200
     7.570   111.352     0.200
     7.897   116.227     0.200
     7.933   118.734     0.200
     8.099   119.172     0.200
     8.176   119.227     0.200
     8.176   121.508     0.200
     8.169   117.234     0.200
     8.879   129.328     0.200
     8.905   129.141     0.200
     8.996   132.500     0.200
     9.263   136.250     0.200
     9.260   139.930     0.200
     9.346   136.031     0.200
     9.399   136.289     0.200
     9.385   137.125     0.200
     9.511   136.930     0.200
     9.630   141.570     0.200
     9.728   146.930     0.200
     9.858   143.328     0.200
    10.064   147.508     0.200
    10.066   147.570     0.200
    10.011   148.930     0.200
    10.116   146.727     0.200
    10.147   147.469     0.200
    10.180   146.500     0.200
    10.205   147.391     0.200
    10.125   150.930     0.200
    10.237   150.062     0.200
    10.268   148.578     0.200
    10.235   144.727     0.200
    10.320   149.305     0.200
    10.284   150.930     0.200
    10.437   151.727     0.200
    10.448   151.727     0.200
    10.451   151.609     0.200
    10.469   152.328     0.200
    10.506   152.633     0.200
    10.573   154.133     0.200
    10.606   150.516     0.200
    10.757   155.633     0.200
    10.824   156.930     0.200
    10.903   162.930     0.200
    10.903   162.930     0.200
    10.960   156.828     0.200
    10.943   161.930     0.200
    10.991   157.711     0.200
    11.114   158.789     0.200
    11.304   163.930     0.200
    11.458   163.242     0.200
    11.745   166.688     0.200
    11.759   170.930     0.200
    12.247   176.531     0.200
    12.292   178.477     0.200
    12.682   180.430     0.200
    13.033   188.133     0.200
    13.076   187.031     0.200
    13.241   188.430     0.200
    13.701   200.133     0.200
    13.729   197.031     0.200
    13.732   195.930     0.200
    13.757   197.430     0.200
    13.962   200.133     0.200
    14.023   198.430     0.200
    13.964   196.727     0.200
    14.119   201.633     0.200
    14.165   202.328     0.200
    14.296   205.930     0.200
    14.338   203.727     0.200
    14.425   205.227     0.200
    14.524   207.227     0.200
    14.776   210.930     0.200
    14.876   210.930     0.200
    15.145   214.430     0.200
    15.184   215.328     0.200
    15.264   215.828     0.200
    15.285   215.828     0.200
    15.290   220.227     0.200
    15.434   219.531     0.200
    15.613   221.227     0.200
    15.731   223.828     0.200
    15.936   226.133     0.200
    17.808   249.531     0.200
    18.209   255.141     0.200
    18.533   260.828     0.200
    18.571   259.531     0.200
    18.571   259.430     0.200
    18.720   262.602     0.200
    18.949   263.867     0.200
    18.957   265.336     0.200
    19.005   265.531     0.200
    19.026   265.656     0.200
    19.178   266.883     0.200
    19.340   268.758     0.200
    19.452   270.781     0.200
    19.514   272.430     0.200
    19.534   270.922     0.200
    19.823   274.039     0.200
    19.831   274.484     0.200
    19.886   274.883     0.200
    20.048   276.422     0.200
    20.026   277.156     0.200
    20.312   278.859     0.200
    20.572   282.531     0.200
    20.768   286.141     0.200
    21.001   287.617     0.200
     2.389    38.516     0.200
     3.338    53.250     0.200
     3.685    55.762     0.200
     3.707    55.906     0.200
     3.724    56.062     0.200
     3.743    55.906     0.200
     3.853    59.590     0.200
     3.991    62.562     0.200
     4.068    61.164     0.200
     4.185    63.363     0.200
     4.728    70.406     0.200
     2.099    36.715     0.200
     2.455    42.715     0.200
     2.529    40.715     0.200
     3.086    49.715     0.200
     5.118    77.836     0.200
     5.405    81.387     0.200
     5.446    81.715     0.200
     5.546    83.613     0.200
     5.623    83.816     0.200
     5.622    84.191     0.200
     5.718    84.914     0.200
     5.732    85.703     0.200
     5.960    89.316     0.200
     6.009    89.305     0.200
     6.176    92.016     0.200
     6.178    91.582     0.200
     6.693    97.914     0.200
     6.745    99.871     0.200
     6.762   100.816     0.200
     6.937   102.414     0.200
     7.425   110.316     0.200
     7.456   109.414     0.200
     7.873   115.715     0.200
     9.133   133.113     0.200
     1.633    29.734     0.200
     1.773    31.734     0.200
     2.578    41.734     0.200
     2.891    48.734     0.200
     3.013    49.734     0.200
     3.018    49.734     0.200
     3.335    53.734     0.200
     4.616    70.375     0.200
     4.857    71.867     0.200
     4.985    75.305     0.200
     4.985    76.234     0.200
     5.478    80.938     0.200
     5.468    81.031     0.200
     5.588    82.234     0.200
     5.598    82.234     0.200
     5.568    84.695     0.200
     5.701    83.836     0.200
     5.693    84.094     0.200
     5.786    85.680     0.200
     5.863    85.789     0.200
     5.845    87.805     0.200
     5.946    87.633     0.200
     6.231    91.234     0.200
     6.223    91.461     0.200
     6.287    91.836     0.200
     6.441    93.414     0.200
     6.510    96.695     0.200
     6.510    97.836     0.200
     6.621    96.156     0.200
     6.716    96.742     0.200
     6.748    98.336     0.200
     6.696    98.625     0.200
     6.696   100.336     0.200
     6.798    99.438     0.200
     6.863    99.719     0.200
     7.022   101.938     0.200
     7.420   108.633     0.200
     7.559   109.336     0.200
     7.829   114.422     0.200
     7.975   114.938     0.200
     8.018   115.000     0.200
     8.536   122.836     0.200
     9.265   133.336     0.200
    10.040   143.641     0.200
    10.032   143.820     0.200
    11.429   163.734     0.200
    11.429   164.344     0.200
     1.667    29.166     0.200
     2.273    38.467     0.200
     2.593    44.467     0.200
     3.852    61.467     0.200
     4.607    69.867     0.200
     4.772    71.867     0.200
     5.193    77.066     0.200
     5.342    79.066     0.200
     5.452    80.768     0.200
     5.502    82.574     0.200
     5.488    81.166     0.200
     5.537    82.105     0.200
     5.591    82.566     0.200
     5.678    83.975     0.200
     5.835    86.066     0.200
     6.084    89.666     0.200
     6.112    89.867     0.200
     6.199    90.775     0.200
     6.236    92.256     0.200
     6.363    93.586     0.200
     6.601    96.666     0.200
     6.661    98.768     0.200
     6.685    97.406     0.200
     6.860    99.768     0.200
     7.305   106.768     0.200
     7.389   107.367     0.200
     7.773   112.510     0.200
     7.805   113.066     0.200
     9.082   130.967     0.200
     9.315   134.117     0.200
     1.686    30.291     0.200
     2.001    36.791     0.200
     2.264    39.791     0.200
     2.613    44.791     0.200
     3.620    58.791     0.200
     5.560    82.791     0.200
     5.701    84.391     0.200
     6.708    98.990     0.200
     1.995    36.312     0.200
     2.361    40.312     0.200
     2.581    43.312     0.200
     2.715    47.312     0.200
     5.370    80.109     0.200
     5.468    81.711     0.200
     5.541    83.094     0.200
     5.555    82.812     0.200
     5.648    84.312     0.200
     5.645    83.922     0.200
     6.083    90.539     0.200
     6.091    90.711     0.200
     6.614    97.711     0.200
     6.660    98.570     0.200
     1.947    33.992     0.200
     4.766    71.793     0.200
     4.836    72.793     0.200
     4.883    73.516     0.200
     4.911    74.000     0.200
     5.047    75.492     0.200
     5.110    76.793     0.200
     5.163    78.793     0.200
     5.223    79.402     0.200
     5.334    80.922     0.200
     5.343    79.891     0.200
     5.933    88.102     0.200
     1.874    33.605     0.200
     2.908    46.777     0.200
     2.908    49.004     0.200
     3.390    54.375     0.200
     3.390    57.105     0.200
     3.573    57.723     0.200
     4.218    66.785     0.200
     4.333    68.406     0.200
     4.483    69.844     0.200
     4.483    71.207     0.200
     4.531    69.695     0.200
     4.672    71.805     0.200
     4.811    74.164     0.200
     5.026    76.707     0.200
     5.407    83.977     0.200
     5.537    83.637     0.200
     1.630    29.586     0.200
     1.630    30.586     0.200
     3.075    49.586     0.200
     4.173    65.586     0.200
     5.368    81.186     0.200
     5.422    81.387     0.200
     5.451    82.285     0.200
     5.560    86.016     0.200
     5.687    85.605     0.200
     5.687    86.586     0.200
     5.902    89.086     0.200
     7.174   106.586     0.200
     8.764   128.195     0.200
     9.648   140.125     0.200
     2.153    37.070     0.200
     4.001    60.801     0.200
     4.075    60.320     0.200
     4.359    65.551     0.200
     4.565    68.969     0.200
     5.092    75.379     0.200
     2.519    41.617     0.200
     5.171    78.016     0.200
     5.315    79.918     0.200
     5.282    79.816     0.200
     5.568    83.719     0.200
     5.947    89.016     0.200
     7.223   106.219     0.200
     5.350    79.762     0.200
     5.880    87.320     0.200
     5.895    87.852     0.200
     6.462    94.492     0.200
     1.976    35.008     0.200
     3.077    48.555     0.200
     4.034    63.008     0.200
     4.109    64.305     0.200
     4.162    64.922     0.200
     4.162    64.008     0.200
     4.222    64.805     0.200
     4.422    68.508     0.200
     4.479    68.727     0.200
     4.678    71.711     0.200
     4.666    71.070     0.200
     4.666    71.406     0.200
     4.745    72.867     0.200
     5.241    78.773     0.200
     1.990    34.062     0.200
     2.173    38.062     0.200
     2.233    39.562     0.200
     2.314    39.680     0.200
     2.853    47.102     0.200
     3.071    49.072     0.200
     3.256    52.152     0.200
     3.309    52.562     0.200
     3.707    57.582     0.200
     3.707    57.241     0.200
     3.784    61.082     0.200
     3.778    58.338     0.200
     4.022    60.962     0.200
     4.097    62.062     0.200
     4.151    63.142     0.200
     4.061    63.422     0.200
     4.079    64.770     0.200
     4.095    65.122     0.200
     4.141    64.362     0.200
     4.212    63.762     0.200
     4.297    65.562     0.200
     4.361    66.862     0.200
     4.409    66.662     0.200
     4.471    67.612     0.200
     4.594    69.962     0.200
     4.658    71.162     0.200
     4.668    70.162     0.200
     4.717    70.462     0.200
     4.660    70.862     0.200
     4.743    73.662     0.200
     4.836    73.762     0.200
     4.892    75.562     0.200
     4.947    76.742     0.200
     5.230    78.362     0.200
     5.230    77.962     0.200
     5.231    77.992     0.200
     5.258    78.362     0.200
     5.445    80.862     0.200
     5.690    85.902     0.200
     5.790    85.662     0.200
     5.949    88.262     0.200
     5.972    88.362     0.200
     5.972    88.232     0.200
     6.031    89.462     0.200
     6.031    90.162     0.200
     6.043    89.462     0.200
     6.096    91.812     0.200
     6.235    92.052     0.200
     6.235    91.882     0.200
     6.355    93.462     0.200
     6.365    93.762     0.200
     6.450    94.302     0.200
     6.801   102.352     0.200
     7.147   104.682     0.200
     7.128   104.742     0.200
     7.607   110.632     0.200
     7.981   117.312     0.200
     8.354   121.662     0.200
     8.438   122.362     0.200
     8.540   123.172     0.200
     8.828   128.862     0.200
     8.835   128.682     0.200
     8.817   128.222     0.200
     9.512   136.802     0.200
     9.654   139.152     0.200
     9.692   140.072     0.200
     9.763   141.502     0.200
     9.789   141.632     0.200
     9.896   143.602     0.200
     9.921   145.180     0.200
    10.115   146.962     0.200
    10.119   146.662     0.200
    10.149   146.362     0.200
    10.151   147.062     0.200
    10.172   147.322     0.200
    10.201   146.982     0.200
    10.573   152.262     0.200
    12.836   183.162     0.200
    12.973   184.462     0.200
    13.624   193.562     0.200
    13.679   193.862     0.200
    14.434   203.662     0.200
    14.669   208.462     0.200
    14.839   209.262     0.200
    14.836   208.762     0.200
    15.228   214.762     0.200
    15.567   219.162     0.200
    15.657   220.562     0.200
     2.413    41.539     0.200
     5.194    78.336     0.200
     5.298    80.141     0.200
     5.360    80.539     0.200
     5.360    80.297     0.200
     5.379    81.078     0.200
     5.458    82.242     0.200
     5.504    82.906     0.200
     5.504    82.641     0.200
     5.590    84.336     0.200
     5.700    85.938     0.200
     5.811    87.867     0.200
     5.811    88.141     0.200
     5.943    89.039     0.200
     6.515    96.086     0.200
     6.697   100.336     0.200
     7.222   107.039     0.200
     1.401    26.609     0.200
     3.327    53.609     0.200
     3.481    56.180     0.200
     3.979    61.992     0.200
     4.362    68.930     0.200
     4.674    71.211     0.200
     4.739    72.109     0.200
     4.796    73.109     0.200
     4.969    75.531     0.200
     5.028    76.336     0.200
     5.057    76.812     0.200
     5.088    78.086     0.200
     5.265    79.508     0.200
     5.259    79.906     0.200
     5.307    79.477     0.200
     5.307    80.328     0.200
     5.307    79.164     0.200
     5.352    81.312     0.200
     5.662    84.711     0.200
     5.819    87.297     0.200
     5.861    88.211     0.200
     6.055    90.609     0.200
     6.304    95.812     0.200
     6.544    97.406     0.200
     6.687    99.305     0.200
     6.958   103.109     0.200
     8.172   120.172     0.200
     8.903   129.711     0.200
     9.028   131.219     0.200
     1.965    35.199     0.200
     4.180    62.789     0.200
     4.466    67.918     0.200
     4.669    70.918     0.200
     4.785    72.938     0.200
     5.052    76.707     0.200
     5.052    78.598     0.200
     5.252    78.098     0.200
     5.334    79.301     0.200
     5.391    80.098     0.200
     5.447    80.469     0.200
     5.567    82.598     0.200
     5.642    83.801     0.200
     5.713    86.363     0.200
     5.713    87.500     0.200
     5.804    86.098     0.200
     5.787    85.898     0.200
     5.907    87.098     0.200
     5.956    88.598     0.200
     6.238    91.801     0.200
     6.470    94.598     0.200
     6.468    95.008     0.200
     6.686    98.301     0.200
     7.031   102.500     0.200
     7.188   105.098     0.200
     7.254   106.301     0.200
     7.345   106.789     0.200
     7.604   110.699     0.200
     8.160   118.398     0.200
     8.836   128.000     0.200
     8.816   126.879     0.200
     9.042   130.598     0.200
     9.151   132.098     0.200
     9.575   137.855     0.200
     9.676   139.059     0.200
    10.062   144.461     0.200
     4.810    73.785     0.200
     4.919    75.545     0.200
     5.263    79.525     0.200
     5.353    80.525     0.200
     5.419    81.416     0.200
     5.500    82.164     0.200
     5.560    84.726     0.200
     5.656    85.925     0.200
     5.799    87.025     0.200
     5.894    88.633     0.200
     5.953    89.425     0.200
     6.246    92.726     0.200
     6.518    96.715     0.200
     6.724   100.125     0.200
     7.234   106.726     0.200
     8.897   129.625     0.200
     2.593    43.906     0.200
     4.610    70.500     0.200
     5.346    79.906     0.200
     5.456    81.305     0.200
     5.493    81.805     0.200
     5.493    81.680     0.200
     5.542    82.430     0.200
     5.596    83.508     0.200
     5.682    83.867     0.200
     5.743    85.508     0.200
     5.983    88.586     0.200
     6.116    90.609     0.200
     6.202    91.359     0.200
     6.316    93.109     0.200
     6.689    98.023     0.200
     6.864   101.008     0.200
     7.166   105.109     0.200
     5.421    80.723     0.200
     5.504    81.723     0.200
     5.562    82.523     0.200
     5.618    83.340     0.200
     6.059    90.723     0.200
     6.078    90.121     0.200
     6.407    95.121     0.200
     6.639    97.441     0.200
     2.043    36.285     0.200
     2.524    41.988     0.200
     3.164    50.320     0.200
     3.441    54.641     0.200
     3.988    60.848     0.200
     4.105    65.242     0.200
     4.041    60.586     0.200
     4.053    61.465     0.200
     4.169    65.234     0.200
     4.374    66.785     0.200
     4.403    66.785     0.200
     4.403    67.086     0.200
     4.472    67.484     0.200
     4.644    70.184     0.200
     5.007    74.770     0.200
     4.989    74.484     0.200
     5.277    78.984     0.200
     5.410    82.605     0.200
     5.676    84.086     0.200
     1.319    23.676     0.200
     3.135    50.234     0.200
     3.307    52.234     0.200
     4.050    61.855     0.200
     4.106    61.477     0.200
     4.064    65.547     0.200
     4.131    61.676     0.200
     4.136    63.215     0.200
     4.514    66.875     0.200
     4.514    68.164     0.200
     4.538    68.277     0.200
     5.066    75.773     0.200
     5.082    75.074     0.200
     5.346    79.875     0.200
     1.790    31.990     0.200
     2.118    36.210     0.200
     3.521    57.990     0.200
     3.495    56.990     0.200
     3.642    57.990     0.200
     3.704    58.990     0.200
     4.013    62.990     0.200
     4.861    73.760     0.200
     4.921    74.240     0.200
     5.222    78.090     0.200
     5.322    80.510     0.200
     5.356    80.610     0.200
     5.475    80.990     0.200
     5.580    82.490     0.200
     5.516    83.940     0.200
     5.635    83.090     0.200
     5.635    83.480     0.200
     5.661    84.040     0.200
     5.603    84.648     0.200
     5.631    86.310     0.200
     5.735    84.590     0.200
     5.785    85.270     0.200
     5.871    86.690     0.200
     5.978    88.190     0.200
     6.211    91.090     0.200
     6.225    91.490     0.200
     6.263    92.120     0.200
     6.267    94.990     0.200
     6.448    94.290     0.200
     6.411    94.390     0.200
     6.437    97.030     0.200
     6.729    98.590     0.200
     6.748    98.590     0.200
     6.793    99.790     0.200
     6.796    99.310     0.200
     6.980   101.790     0.200
     7.012   105.860     0.200
     7.108   103.300     0.200
     7.289   105.990     0.200
     7.211   107.230     0.200
     7.446   108.790     0.200
     7.446   108.990     0.200
     7.504   109.090     0.200
     7.557   112.570     0.200
     7.649   110.390     0.200
     7.642   112.570     0.200
     7.834   113.540     0.200
     7.834   113.403     0.200
     7.920   114.790     0.200
     8.051   117.050     0.200
     8.480   122.790     0.200
     8.480   122.350     0.200
     8.804   127.990     0.200
     8.804   126.890     0.200
     8.806   126.890     0.200
     8.837   127.590     0.200
     9.188   132.490     0.200
     9.276   133.490     0.200
     9.365   134.590     0.200
     9.355   134.500     0.200
     9.471   135.990     0.200
     9.517   138.190     0.200
     9.461   137.650     0.200
     9.809   140.990     0.200
     9.832   141.290     0.200
     9.944   143.120     0.200
    10.116   145.690     0.200
    10.283   149.700     0.200
    11.188   160.410     0.200
    11.302   161.150     0.200
    11.349   163.550     0.200
    11.314   163.970     0.200
    11.395   163.870     0.200
    11.395   163.180     0.200
    11.463   165.060     0.200
    11.482   165.950     0.200
    11.691   169.630     0.200
    11.701   168.590     0.200
    11.718   168.990     0.200
    11.726   169.650     0.200
    11.749   168.870     0.200
    12.099   174.790     0.200
    13.271   190.380     0.200
     2.713    44.289     0.200
     3.169    50.289     0.200
     4.814    72.391     0.200
     4.886    73.391     0.200
     4.935    74.336     0.200
     4.970    74.906     0.200
     5.086    76.750     0.200
     5.200    77.891     0.200
     5.292    80.391     0.200
     5.386    80.586     0.200
     5.434    81.289     0.200
     5.991    88.766     0.200
     6.219    92.289     0.200
     6.575    97.188     0.200
     6.715    99.586     0.200
     2.862    44.512     0.200
     3.074    51.129     0.200
     3.330    54.582     0.200
     3.400    55.234     0.200
     3.947    62.402     0.200
     4.017    63.293     0.200
     4.086    65.734     0.200
     4.365    68.531     0.200
     4.632    71.152     0.200
     4.845    74.031     0.200
     4.879    74.414     0.200
     4.891    74.613     0.200
     5.379    81.582     0.200
     5.610    84.883     0.200
     5.833    87.312     0.200
     5.802    87.750     0.200
     6.777   101.312     0.200
     1.918    35.383     0.200
     5.508    82.398     0.200
     5.641    84.039     0.200
     5.828    85.953     0.200
     6.211    91.625     0.200
     6.822    99.938     0.200
     1.774    31.875     0.200
     5.155    77.477     0.200
     5.265    78.875     0.200
     5.492    81.844     0.200
     5.552    83.172     0.200
     5.792    86.328     0.200
     5.792    86.578     0.200
     5.821    86.453     0.200
     5.925    87.875     0.200
     6.125    90.672     0.200
     6.499    95.547     0.200
     7.202   105.578     0.200
     1.375    24.602     0.200
     1.768    33.102     0.200
     4.451    68.453     0.200
     4.466    68.148     0.200
     4.566    69.402     0.200
     4.582    69.141     0.200
     4.585    68.801     0.200
     4.959    73.902     0.200
     5.173    77.602     0.200
     5.213    77.902     0.200
     5.476    81.152     0.200
     5.538    82.102     0.200
     5.645    83.203     0.200
     5.771    86.301     0.200
     1.702    30.154     0.200
     3.077    46.449     0.200
     4.316    64.754     0.200
     4.371    65.055     0.200
     4.405    64.244     0.200
     4.402    64.455     0.200
     4.642    69.754     0.200
     4.642    67.564     0.200
     4.560    67.025     0.200
     4.690    68.854     0.200
     4.917    72.455     0.200
     4.875    71.654     0.200
     5.303    77.555     0.200
     5.424    79.076     0.200
     6.042    87.254     0.200
     6.152    89.254     0.200
     6.577    94.980     0.200
     7.116   102.854     0.200
     2.505    39.334     0.200
     2.723    42.022     0.200
     3.153    48.772     0.200
     3.625    53.354     0.200
     3.677    54.154     0.200
     3.716    54.398     0.200
     3.710    54.873     0.200
     3.923    59.292     0.200
     4.096    60.935     0.200
     4.184    61.254     0.200
     4.235    62.455     0.200
     4.253    61.895     0.200
     4.738    69.752     0.200
     4.789    70.254     0.200
     4.976    72.754     0.200
     5.463    79.455     0.200
     5.918    84.832     0.200
     7.096   101.470     0.200
     7.833   112.241     0.200
     5.241    78.367     0.200
     5.320    79.566     0.200
     5.375    80.434     0.200
     5.424    81.074     0.200
     5.488    82.566     0.200
     5.488    83.176     0.200
     5.563    82.688     0.200
     5.620    83.598     0.200
     5.630    84.066     0.200
     5.746    85.883     0.200
     5.879    87.266     0.200
     5.879    87.367     0.200
     5.886    87.469     0.200
     6.228    91.668     0.200
     6.445    95.445     0.200
     6.667    98.668     0.200
     7.015   102.566     0.200
     7.166   105.266     0.200
     7.630   111.789     0.200
     8.810   128.266     0.200
     9.546   138.469     0.200
     9.654   138.586     0.200
     5.329    78.426     0.200
     5.441    79.826     0.200
     5.726    84.127     0.200
     5.966    86.877     0.200
     5.966    87.727     0.200
     6.105    89.127     0.200
     6.298    91.426     0.200
     7.151   103.727     0.200
     1.664    31.104     0.200
     1.774    32.604     0.200
     2.252    38.104     0.200
     2.462    43.104     0.200
     5.171    77.803     0.200
     5.205    78.504     0.200
     5.205    77.924     0.200
     5.259    78.803     0.200
     5.309    79.674     0.200
     5.309    80.104     0.200
     5.407    80.461     0.200
     5.457    82.004     0.200
     5.552    83.203     0.200
     5.697    85.064     0.200
     5.748    85.863     0.200
     5.838    87.004     0.200
     5.961    88.742     0.200
     6.029    89.404     0.200
     6.412    93.863     0.200
     6.881   101.904     0.200
     1.442    26.102     0.200
     1.446    26.102     0.200
     2.296    39.500     0.200
     2.803    44.328     0.200
     2.870    45.938     0.200
     2.948    46.711     0.200
     2.869    46.500     0.200
     2.957    48.219     0.200
     3.007    49.133     0.200
     3.608    57.414     0.200
     3.739    59.672     0.200
     3.856    59.844     0.200
     3.874    59.461     0.200
     3.971    60.266     0.200
     4.037    62.625     0.200
     4.155    62.156     0.200
     4.183    62.398     0.200
     4.191    63.297     0.200
     4.469    67.398     0.200
     4.524    67.898     0.200
     4.667    69.602     0.200
     4.773    70.539     0.200
     4.773    71.102     0.200
     4.863    73.000     0.200
     4.835    74.531     0.200
     4.964    74.266     0.200
     5.138    76.203     0.200
     5.195    77.500     0.200
     5.223    77.672     0.200
     5.284    79.500     0.200
     5.696    84.797     0.200
     5.726    84.898     0.200
     6.094    89.898     0.200
     6.319    93.094     0.200
     6.721    99.047     0.200
     7.735   112.703     0.200
     8.120   118.125     0.200
     9.144   133.000     0.200
     1.964    35.195     0.200
     2.027    35.195     0.200
     2.316    40.195     0.200
     3.168    53.195     0.200
     3.237    53.195     0.200
     3.299    54.195     0.200
     3.637    60.195     0.200
     3.704    59.617     0.200
     3.754    60.195     0.200
     3.890    62.336     0.200
     3.893    62.297     0.200
     3.896    62.594     0.200
     3.954    63.195     0.200
     4.120    67.195     0.200
     4.300    68.195     0.200
     4.376    66.906     0.200
     4.434    67.102     0.200
     4.657    71.664     0.200
     4.687    71.195     0.200
     4.705    73.445     0.200
     5.262    80.414     0.200
     5.330    79.992     0.200
     5.305    82.180     0.200
     5.355    82.805     0.200
     5.385    82.438     0.200
     5.427    81.492     0.200
     5.500    82.742     0.200
     5.519    82.695     0.200
     5.519    82.164     0.200
     5.611    83.836     0.200
     5.601    83.672     0.200
     5.602    85.656     0.200
     5.724    85.797     0.200
     5.731    88.352     0.200
     5.852    87.695     0.200
     5.869    87.562     0.200
     5.968    88.984     0.200
     5.968    89.094     0.200
     6.018    91.766     0.200
     6.048    90.195     0.200
     6.036    90.070     0.200
     6.185    94.938     0.200
     6.309    93.695     0.200
     6.476    98.438     0.200
     6.572    97.594     0.200
     6.594    97.594     0.200
     6.616    97.875     0.200
     6.566    99.266     0.200
     6.660   100.078     0.200
     6.705   100.195     0.200
     6.753   102.297     0.200
     6.811   100.594     0.200
     7.006   101.797     0.200
     7.084   105.297     0.200
     7.315   107.898     0.200
     7.315   107.352     0.200
     7.335   104.641     0.200
     7.328   107.898     0.200
     7.302   109.195     0.200
     7.422   108.297     0.200
     7.604   110.992     0.200
     7.700   113.297     0.200
     7.745   113.695     0.200
     7.851   114.930     0.200
     7.918   117.984     0.200
     8.136   118.992     0.200
     8.304   121.492     0.200
     8.528   124.242     0.200
     8.665   126.094     0.200
     8.933   129.992     0.200
     8.934   129.992     0.200
     8.949   132.180     0.200
     9.001   130.594     0.200
     9.001   130.742     0.200
     9.111   132.141     0.200
     9.188   133.398     0.200
     9.201   133.594     0.200
     9.206   135.156     0.200
     9.295   134.898     0.200
     9.413   136.594     0.200
     9.616   139.492     0.200
     9.652   140.695     0.200
     9.658   139.695     0.200
     9.752   141.484     0.200
     9.817   140.016     0.200
     9.817   141.992     0.200
     9.945   143.898     0.200
    10.027   146.688     0.200
    10.273   150.141     0.200
    10.669   149.938     0.200
    10.662   155.617     0.200
    10.739   154.703     0.200
    11.022   158.117     0.200
    11.034   163.422     0.200
    11.049   160.938     0.200
    11.069   160.148     0.200
    11.093   162.812     0.200
    11.132   162.133     0.200
    11.159   160.367     0.200
    11.152   163.266     0.200
    11.169   162.039     0.200
    11.182   161.016     0.200
    11.220   161.125     0.200
    11.241   163.562     0.200
    11.315   164.469     0.200
    11.451   166.039     0.200
    11.454   166.297     0.200
    11.476   164.898     0.200
    11.509   165.414     0.200
    11.551   167.633     0.200
    11.588   167.750     0.200
    11.584   167.000     0.200
    11.601   167.594     0.200
    11.644   168.594     0.200
    11.849   171.898     0.200
    11.970   173.172     0.200
    13.049   189.547     0.200
    13.700   194.797     0.200
    13.725   193.289     0.200
    14.103   198.594     0.200
    14.263   200.297     0.200
    14.756   206.094     0.200
    15.023   210.594     0.200
    15.039   210.297     0.200
    15.602   217.898     0.200
    15.616   218.297     0.200
    15.824   221.594     0.200
    15.888   222.398     0.200
    16.171   225.195     0.200
    16.212   226.094     0.200
    16.230   228.094     0.200
    16.459   229.398     0.200
    16.456   229.594     0.200
    16.462   229.398     0.200
    16.595   231.398     0.200
    16.758   233.797     0.200
    16.926   237.797     0.200
    17.022   237.695     0.200
    17.039   236.992     0.200
    17.969   249.695     0.200
    18.228   250.594     0.200
    18.320   254.594     0.200
    18.876   263.555     0.200
    18.969   264.695     0.200
    19.237   267.203     0.200
    19.334   269.094     0.200
    19.330   268.297     0.200
    19.330   268.094     0.200
    19.553   271.695     0.200
    19.599   272.195     0.200
    19.599   270.992     0.200
    20.036   275.992     0.200
    20.885   286.695     0.200
     3.200    49.273     0.200
     3.778    56.973     0.200
     4.452    68.973     0.200
     4.676    69.172     0.200
     5.198    76.574     0.200
     5.236    76.973     0.200
     5.355    80.973     0.200
     5.435    79.672     0.200
     5.839    85.172     0.200
     5.922    86.773     0.200
     6.239    89.574     0.200
     6.271    90.074     0.200
     6.604    94.773     0.200
     6.609    93.871     0.200
     6.646    94.324     0.200
     6.646    94.871     0.200
     6.667    95.574     0.200
     6.857    97.613     0.200
     6.857    98.172     0.200
     6.856    98.074     0.200
     6.866    97.871     0.200
     6.761   101.973     0.200
     7.219   103.074     0.200
     7.347   104.871     0.200
     7.347   104.672     0.200
     7.536   108.992     0.200
     7.893   112.672     0.200
     7.917   112.871     0.200
     8.248   117.473     0.200
     8.320   119.273     0.200
     8.441   120.371     0.200
     8.854   126.672     0.200
     8.854   126.371     0.200
     9.249   131.574     0.200
     9.435   135.074     0.200
     9.828   139.273     0.200
    10.204   144.672     0.200
    10.509   149.074     0.200
    11.313   161.121     0.200
     0.239     9.742     0.200
     0.833    16.742     0.200
     1.221    22.742     0.200
     1.788    29.742     0.200
     2.333    38.742     0.200
     3.701    53.441     0.200
     3.734    54.141     0.200
     4.066    58.844     0.200
     4.119    60.641     0.200
     4.180    62.043     0.200
     4.335    62.742     0.200
     4.681    68.043     0.200
     1.976    33.648     0.200
     2.113    34.648     0.200
     5.701    83.250     0.200
     5.758    84.648     0.200
     5.808    84.117     0.200
     5.966    86.750     0.200
     6.424    92.660     0.200
     6.424    93.348     0.200
     6.513    94.449     0.200
     2.124    34.938     0.200
     5.317    80.141     0.200
     5.432    81.734     0.200
     5.523    82.336     0.200
     5.586    84.086     0.200
     5.682    84.719     0.200
     5.714    85.938     0.200
     5.952    89.578     0.200
     5.952    89.734     0.200
     6.030    89.977     0.200
     6.109    91.539     0.200
     6.281    93.734     0.200
     6.583    97.836     0.200
     6.685    99.133     0.200
     7.972   116.266     0.200
     9.085   132.492     0.200
     9.849   143.492     0.200
     2.837    45.528     0.200
     2.956    47.866     0.200
     4.721    71.396     0.200
     4.839    72.128     0.200
     4.905    73.528     0.200
     4.948    74.608     0.200
     4.964    74.777     0.200
     5.129    76.869     0.200
     5.160    77.818     0.200
     5.128    76.720     0.200
     5.244    79.026     0.200
     5.433    81.128     0.200
     5.986    88.358     0.200
     6.712    98.928     0.200
     7.146   105.288     0.200
     8.338   121.291     0.200
     1.152    20.535     0.200
     4.031    60.646     0.200
     4.360    64.627     0.200
     4.549    67.835     0.200
     4.658    68.775     0.200
     5.112    75.016     0.200
     2.302    39.422     0.200
     5.133    77.822     0.200
     5.242    79.322     0.200
     5.387    81.522     0.200
     5.468    81.820     0.200
     5.874    87.822     0.200
     5.901    88.422     0.200
     6.000    88.790     0.200
     6.104    91.022     0.200
     6.475    96.214     0.200
     1.348    24.115     0.200
     1.868    32.703     0.200
     2.178    36.703     0.200
     2.525    41.703     0.200
     3.364    54.703     0.200
     3.506    56.703     0.200
     3.776    59.703     0.200
     3.910    61.438     0.200
     3.955    62.703     0.200
     4.097    63.781     0.200
     4.103    64.135     0.200
     4.321    67.402     0.200
     4.361    68.322     0.200
     4.507    70.023     0.200
     4.523    70.043     0.200
     4.645    68.840     0.200
     4.819    72.992     0.200
     4.856    73.521     0.200
     4.900    72.572     0.200
     4.910    74.504     0.200
     5.303    79.648     0.200
     5.495    81.303     0.200
     5.519    84.477     0.200
     5.569    83.701     0.200
     5.598    82.803     0.200
     5.600    84.279     0.200
     5.666    83.604     0.200
     5.675    84.018     0.200
     5.763    84.963     0.200
     5.763    84.803     0.200
     5.790    85.291     0.200
     5.891    86.803     0.200
     5.945    89.332     0.200
     6.005    88.303     0.200
     6.073    89.111     0.200
     6.134    90.072     0.200
     6.228    91.402     0.200
     6.233    91.504     0.200
     6.233    93.439     0.200
     6.245    91.832     0.200
     6.471    94.703     0.200
     6.690   100.768     0.200
     6.745    98.803     0.200
     6.803    99.277     0.200
     6.964   104.951     0.200
     7.212   105.803     0.200
     7.306   106.803     0.200
     7.468   107.854     0.200
     7.513   109.104     0.200
     7.516   111.240     0.200
     7.632   110.104     0.200
     7.814   112.604     0.200
     7.814   113.004     0.200
     7.851   112.303     0.200
     7.873   114.303     0.200
     7.929   114.902     0.200
     8.049   116.520     0.200
     8.309   120.203     0.200
     8.489   122.902     0.200
     8.489   122.703     0.200
     8.737   125.941     0.200
     8.773   129.004     0.200
     8.847   127.303     0.200
     9.154   134.602     0.200
     9.192   132.504     0.200
     9.192   132.164     0.200
     9.248   129.766     0.200
     9.283   135.004     0.200
     9.325   134.021     0.200
     9.373   134.604     0.200
     9.358   134.703     0.200
     9.420   137.031     0.200
     9.480   136.104     0.200
     9.810   140.902     0.200
     9.842   141.004     0.200
     9.946   142.850     0.200
    10.001   143.160     0.200
    10.127   145.402     0.200
    10.240   148.570     0.200
    10.476   153.080     0.200
    10.875   157.252     0.200
    10.924   156.324     0.200
    11.201   159.396     0.200
    11.294   160.900     0.200
    11.351   162.541     0.200
    11.368   163.469     0.200
    11.378   162.352     0.200
    11.434   162.473     0.200
    11.664   166.793     0.200
    11.669   166.303     0.200
    11.690   167.203     0.200
    11.688   170.852     0.200
    11.722   167.311     0.200
    11.765   169.131     0.200
    11.802   169.775     0.200
    11.795   170.443     0.200
    12.063   171.203     0.200
    12.183   175.002     0.200
    13.004   183.703     0.200
    13.192   188.854     0.200
    13.192   189.703     0.200
    13.658   194.312     0.200
    14.317   201.004     0.200
    14.477   202.004     0.200
    14.464   206.504     0.200
    14.966   208.604     0.200
    15.236   212.203     0.200
    15.251   212.703     0.200
    15.808   220.303     0.200
    15.827   220.604     0.200
    15.825   220.604     0.200
    16.015   223.803     0.200
    16.032   223.104     0.200
    16.097   224.504     0.200
    16.386   227.703     0.200
    16.430   228.803     0.200
    16.426   228.203     0.200
    16.437   229.703     0.200
    16.584   230.004     0.200
    16.667   231.703     0.200
    16.674   231.504     0.200
    16.672   232.504     0.200
    16.806   234.504     0.200
    16.972   235.303     0.200
    17.138   239.104     0.200
    17.234   239.104     0.200
    17.252   239.203     0.200
    18.476   257.104     0.200
    18.491   257.504     0.200
    18.533   258.303     0.200
    18.607   260.793     0.200
    18.721   260.303     0.200
    19.084   264.762     0.200
    19.160   266.504     0.200
    19.182   265.902     0.200
    19.253   266.104     0.200
    19.447   268.416     0.200
    19.549   269.504     0.200
    19.543   269.504     0.200
    19.694   271.613     0.200
    19.768   271.803     0.200
    19.813   272.264     0.200
    19.813   272.803     0.200
    20.193   277.094     0.200
    20.990   285.004     0.200
     2.000    35.117     0.200
     2.627    43.117     0.200
     5.699    85.430     0.200
     5.798    86.008     0.200
     6.813   100.320     0.200
     2.614    44.505     0.200
     3.137    50.505     0.200
     5.227    78.295     0.200
     5.262    79.033     0.200
     6.284    92.965     0.200
     2.656    44.830     0.200
     3.215    53.830     0.200
     3.400    56.383     0.200
     4.070    63.645     0.200
     4.403    69.268     0.200
     4.765    75.516     0.200
     4.871    76.963     0.200
     5.265    80.330     0.200
     5.336    81.230     0.200
     5.384    82.248     0.200
     5.261    82.674     0.200
     5.409    82.180     0.200
     5.534    84.330     0.200
     5.602    85.080     0.200
     5.572    84.631     0.200
     5.651    85.830     0.200
     5.558    88.047     0.200
     5.678    86.340     0.200
     5.836    88.430     0.200
     5.877    88.830     0.200
     5.901    88.881     0.200
     5.901    89.131     0.200
     5.954    89.830     0.200
     6.253    93.830     0.200
     6.214    94.861     0.200
     6.431    96.381     0.200
     6.464    96.930     0.200
     6.796   104.113     0.200
     7.023   104.631     0.200
     7.156   106.631     0.200
     7.209   106.730     0.200
     7.227   107.643     0.200
     7.586   112.430     0.200
     7.592   112.141     0.200
     8.015   118.430     0.200
     8.124   120.131     0.200
     8.170   120.908     0.200
     8.785   128.930     0.200
     9.113   133.730     0.200
     9.380   137.131     0.200
     9.515   138.764     0.200
     9.641   140.941     0.200
    10.552   153.701     0.200
    10.788   157.607     0.200
    10.868   158.066     0.200
    10.802   157.842     0.200
    10.930   158.670     0.200
     1.993    35.484     0.200
     2.583    42.484     0.200
     4.497    66.715     0.200
     5.321    80.082     0.200
     5.388    79.684     0.200
     5.486    81.285     0.200
     5.559    82.414     0.200
     5.573    82.184     0.200
     5.573    81.965     0.200
     5.663    82.932     0.200
     5.666    83.635     0.200
     5.907    86.984     0.200
     5.932    87.430     0.200
     6.026    88.754     0.200
     6.079    90.604     0.200
     6.109    89.885     0.200
     6.099    89.777     0.200
     6.115    89.885     0.200
     6.366    93.084     0.200
     6.632    97.285     0.200
     6.678    97.912     0.200
     7.193   105.184     0.200
     7.389   107.584     0.200
     7.667   110.748     0.200
     7.759   113.184     0.200
     7.914   114.785     0.200
     9.063   130.885     0.200
     9.063   131.084     0.200
     9.814   141.043     0.200
     2.678    43.789     0.200
     5.000    74.590     0.200
     5.050    75.488     0.200
     5.084    76.043     0.200
     5.197    77.789     0.200
     5.264    78.289     0.200
     5.271    78.527     0.200
     5.314    79.688     0.200
     5.549    82.688     0.200
     5.564    82.391     0.200
     5.916    87.090     0.200
     6.106    90.020     0.200
     6.829   100.188     0.200
     3.313    53.430     0.200
     3.414    54.140     0.200
     3.752    58.978     0.200
     3.874    60.140     0.200
     3.879    61.540     0.200
     3.913    60.838     0.200
     4.051    63.340     0.200
     4.721    73.090     0.200
     4.817    74.140     0.200
     4.810    72.728     0.200
     4.856    73.240     0.200
     4.873    73.570     0.200
     4.862    73.820     0.200
     4.911    75.058     0.200
     5.186    78.740     0.200
     5.151    79.060     0.200
     5.162    78.070     0.200
     5.295    80.140     0.200
     5.439    81.680     0.200
     5.439    82.240     0.200
     5.354    81.828     0.200
     5.800    87.340     0.200
     5.828    87.040     0.200
     5.947    88.840     0.200
     5.939    90.480     0.200
     6.101    91.440     0.200
     6.560    97.340     0.200
     6.904   101.250     0.200
     8.132   118.490     0.200
     1.380    25.584     0.200
     1.243    23.584     0.200
     1.820    32.584     0.200
     2.186    37.375     0.200
     2.320    37.457     0.200
     2.365    40.584     0.200
     2.347    39.584     0.200
     2.977    48.760     0.200
     3.693    55.984     0.200
     3.682    56.525     0.200
     3.737    56.082     0.200
     3.777    59.584     0.200
     3.801    57.820     0.200
     4.011    62.584     0.200
     3.935    62.529     0.200
     4.164    61.984     0.200
     4.310    64.484     0.200
     4.672    69.184     0.200
     4.703    69.820     0.200
     1.801    31.211     0.200
     2.616    44.211     0.200
     2.979    48.211     0.200
     3.063    50.211     0.200
     3.666    57.541     0.200
     4.201    64.998     0.200
     4.237    66.111     0.200
     4.471    68.410     0.200
     4.476    68.824     0.200
     4.731    72.934     0.200
     4.812    72.721     0.200
     5.376    79.727     0.200
     5.488    81.125     0.200
     5.514    82.430     0.200
     5.773    85.531     0.200
     6.154    90.727     0.200
     6.343    92.727     0.200
     6.900   100.727     0.200
     7.198   104.828     0.200
     1.386    25.887     0.200
     2.554    42.887     0.200
     2.961    48.117     0.200
     2.989    49.887     0.200
     3.092    50.887     0.200
     3.701    58.367     0.200
     3.833    60.375     0.200
     4.265    66.086     0.200
     4.473    69.543     0.200
     4.515    69.285     0.200
     4.838    73.645     0.200
     1.671    29.525     0.200
     4.718    73.277     0.200
     4.754    74.168     0.200
     5.110    78.525     0.200
     5.174    79.025     0.200
     5.174    79.373     0.200
     5.244    80.125     0.200
     5.298    80.826     0.200
     5.298    81.326     0.200
     5.353    81.684     0.200
     5.544    84.725     0.200
     5.571    84.529     0.200
     5.975    90.125     0.200
     6.004    90.482     0.200
     6.053    91.525     0.200
     6.271    94.246     0.200
     6.391    96.225     0.200
     6.554    97.939     0.200
     6.687   100.125     0.200
     6.947   103.826     0.200
     7.235   107.426     0.200
     7.511   111.525     0.200
     8.960   131.725     0.200
     1.777    29.040     0.200
     3.528    56.550     0.200
     3.953    62.721     0.200
     4.051    63.740     0.200
     4.051    62.749     0.200
     4.110    64.340     0.200
     4.226    66.167     0.200
     4.342    67.940     0.200
     4.407    68.940     0.200
     4.431    68.864     0.200
     4.555    71.661     0.200
     4.753    73.440     0.200
     4.970    76.140     0.200
     4.971    76.079     0.200
     5.689    86.040     0.200
     5.775    87.488     0.200
     5.811    88.774     0.200
     1.388    25.598     0.200
     2.071    36.298     0.200
     2.644    43.298     0.200
     4.401    66.552     0.200
     4.949    75.809     0.200
     5.316    79.397     0.200
     5.411    80.598     0.200
     5.482    81.117     0.200
     5.579    82.430     0.200
     5.601    83.198     0.200
     5.841    87.098     0.200
     5.980    90.822     0.200
     6.003    87.707     0.200
     6.027    89.397     0.200
     6.296    93.298     0.200
     6.556    96.998     0.200
     6.594    96.356     0.200
     7.308   107.098     0.200
     7.390   107.188     0.200
     8.978   128.827     0.200
     2.640    42.961     0.200
     3.273    51.973     0.200
     3.758    57.543     0.200
     3.390    53.941     0.200
     3.813    57.543     0.200
     3.849    58.281     0.200
     3.860    58.059     0.200
     4.066    62.750     0.200
     4.137    63.941     0.200
     4.328    65.043     0.200
     4.363    66.941     0.200
     4.746    71.043     0.200
     4.882    73.102     0.200
     4.929    74.043     0.200
     5.118    77.043     0.200
     5.607    83.043     0.200
     5.620    82.629     0.200
     5.807    86.254     0.200
     6.064    89.289     0.200
     7.241   105.684     0.200
     2.903    46.977     0.200
     3.282    55.148     0.200
     3.459    55.602     0.200
     3.974    61.352     0.200
     4.138    64.750     0.200
     4.191    65.352     0.200
     4.216    65.258     0.200
     4.222    65.617     0.200
     4.377    67.562     0.200
     4.492    71.047     0.200
     4.508    70.250     0.200
     4.515    69.852     0.200
     4.689    71.750     0.200
     4.744    72.445     0.200
     4.766    71.547     0.200
     5.125    77.750     0.200
     5.238    78.992     0.200
     5.483    83.445     0.200
     5.965    89.148     0.200
     2.213    36.550     0.200
     2.217    36.550     0.200
     2.224    36.761     0.200
     2.483    38.090     0.200
     2.730    43.950     0.200
     3.049    46.860     0.200
     3.133    49.310     0.200
     3.374    51.898     0.200
     3.417    54.158     0.200
     3.736    57.450     0.200
     3.650    56.830     0.200
     3.833    57.550     0.200
     3.842    57.308     0.200
     3.805    61.890     0.200
     3.870    58.050     0.200
     3.887    58.358     0.200
     3.967    59.734     0.200
     4.089    61.918     0.200
     4.082    62.950     0.200
     4.201    62.650     0.200
     4.217    64.450     0.200
     4.217    64.284     0.200
     4.245    63.580     0.200
     4.322    65.250     0.200
     4.453    66.040     0.200
     4.453    66.250     0.200
     4.463    66.150     0.200
     4.555    70.070     0.200
     4.474    66.350     0.200
     4.815    71.150     0.200
     4.863    71.568     0.200
     4.962    73.050     0.200
     4.931    75.318     0.200
     5.124    75.750     0.200
     5.413    81.860     0.200
     5.477    81.368     0.200
     5.515    80.950     0.200
     5.594    82.050     0.200
     5.651    82.700     0.200
     5.651    82.588     0.200
     5.720    84.050     0.200
     5.844    85.450     0.200
     5.844    85.566     0.200
     5.990    87.560     0.200
     6.005    87.650     0.200
     6.070    88.950     0.200
     6.491    94.850     0.200
     6.449    94.080     0.200
     6.553    95.150     0.200
     6.935   100.650     0.200
     7.160   103.490     0.200
     7.194   104.050     0.200
     7.211   105.838     0.200
     7.428   107.150     0.200
     7.539   108.750     0.200
     7.782   112.050     0.200
     7.912   113.650     0.200
     8.069   115.720     0.200
     8.209   118.250     0.200
     8.560   125.748     0.200
     9.333   132.578     0.200
     9.552   138.070     0.200
     2.600    41.638     0.200
     3.072    47.786     0.200
     3.203    50.290     0.200
     3.440    55.100     0.200
     4.073    61.400     0.200
     4.146    63.911     0.200
     4.153    63.466     0.200
     4.131    63.869     0.200
     4.102    64.465     0.200
     4.205    64.109     0.200
     4.559    68.311     0.200
     4.733    71.011     0.200
     5.090    76.555     0.200
     5.367    80.411     0.200
     5.590    82.916     0.200
     5.771    86.111     0.200
     5.822    86.211     0.200
     6.230    91.811     0.200
     7.394   107.711     0.200
     7.756   112.911     0.200
     2.490    40.500     0.200
     2.371    40.031     0.200
     2.889    43.328     0.200
     3.226    50.281     0.200
     3.136    48.945     0.200
     3.509    53.680     0.200
     3.522    53.508     0.200
     3.749    57.180     0.200
     3.927    59.680     0.200
     4.005    61.609     0.200
     4.084    61.180     0.200
     4.074    63.805     0.200
     4.199    63.938     0.200
     4.339    65.633     0.200
     4.506    67.102     0.200
     4.710    71.141     0.200
     4.936    73.586     0.200
     5.192    77.383     0.200
     5.224    78.180     0.200
     5.670    82.883     0.200
     5.905    86.297     0.200
     6.148    90.719     0.200
     6.748    98.977     0.200
     9.897   142.898     0.200
     1.884    33.227     0.200
     2.772    46.664     0.200
     3.570    57.664     0.200
     4.220    65.336     0.200
     4.978    74.906     0.200
     5.023    75.781     0.200
     5.045    76.344     0.200
     5.191    78.211     0.200
     5.216    78.211     0.200
     5.254    78.648     0.200
     5.332    80.336     0.200
     5.487    82.305     0.200
     5.544    82.789     0.200
     5.544    83.211     0.200
     5.697    88.906     0.200
     6.067    90.125     0.200
     6.301    93.508     0.200
     6.720    99.219     0.200
     6.792   100.305     0.200
     6.887   101.773     0.200
     7.206   106.211     0.200
     8.421   122.781     0.200
     5.185    77.129     0.200
     5.271    78.229     0.200
     5.411    80.529     0.200
     5.492    80.898     0.200
     5.492    82.330     0.200
     5.730    84.629     0.200
     5.823    85.080     0.200
     5.823    86.529     0.200
     6.170    90.729     0.200
     6.633    97.229     0.200
     6.971   101.729     0.200
     7.140   104.330     0.200
     7.556   110.529     0.200
     8.113   117.830     0.200
     8.796   127.629     0.200
     2.201    37.258     0.200
     2.353    38.594     0.200
     2.431    39.156     0.200
     2.422    41.492     0.200
     2.761    44.672     0.200
     2.935    46.094     0.200
     3.230    50.758     0.200
     3.560    59.500     0.200
     3.680    59.141     0.200
     3.888    58.320     0.200
     3.816    61.617     0.200
     3.953    60.742     0.200
     3.970    60.695     0.200
     3.966    63.562     0.200
     4.038    62.055     0.200
     4.638    71.500     0.200
     5.272    81.336     0.200
     5.424    80.312     0.200
     1.682    27.953     0.200
     2.487    41.539     0.200
     3.224    49.688     0.200
     4.109    63.180     0.200
     4.275    64.562     0.200
     4.281    63.648     0.200
     4.304    65.891     0.200
     4.397    64.867     0.200
     4.400    65.578     0.200
     4.737    70.375     0.200
     5.292    77.688     0.200
     5.353    78.977     0.200
     1.979    34.844     0.200
     2.325    39.492     0.200
     2.421    41.258     0.200
     2.525    41.609     0.200
     2.616    44.547     0.200
     2.586    42.672     0.200
     2.635    44.305     0.200
     2.635    44.250     0.200
     2.676    44.172     0.200
     2.766    46.414     0.200
     3.139    51.273     0.200
     3.150    50.578     0.200
     3.192    52.320     0.200
     3.289    54.102     0.200
     3.294    50.664     0.200
     3.390    55.352     0.200
     3.520    54.602     0.200
     3.630    57.352     0.200
     3.639    57.102     0.200
     3.650    57.289     0.200
     3.774    58.594     0.200
     3.907    61.578     0.200
     3.960    60.438     0.200
     4.029    61.906     0.200
     4.141    65.453     0.200
     4.160    64.273     0.200
     4.366    68.180     0.200
     4.508    70.875     0.200
     4.569    69.125     0.200
     4.611    69.852     0.200
     4.664    70.852     0.200
     4.678    70.273     0.200
     4.695    70.711     0.200
     4.804    72.086     0.200
     4.801    75.023     0.200
     4.901    74.180     0.200
     4.940    74.352     0.200
     4.940    74.188     0.200
     4.988    74.734     0.200
     4.988    74.953     0.200
     4.988    75.352     0.200
     5.154    77.953     0.200
     5.250    81.969     0.200
     5.250    82.438     0.200
     5.444    83.664     0.200
     5.518    83.602     0.200
     5.598    84.055     0.200
     5.700    84.719     0.200
     5.951    88.453     0.200
     6.068    92.445     0.200
     6.288    92.914     0.200
     6.288    92.727     0.200
     6.330    93.453     0.200
     6.400    95.250     0.200
     6.429    95.055     0.200
     6.451    95.180     0.200
     6.451    95.352     0.200
     6.453    95.203     0.200
     6.527    95.422     0.200
     6.527    96.453     0.200
     6.506    98.273     0.200
     6.626    98.148     0.200
     6.626    97.820     0.200
     6.841   100.352     0.200
     6.888   101.453     0.200
     7.113   106.484     0.200
     7.171   106.711     0.200
     7.313   107.148     0.200
     7.390   107.852     0.200
     7.393   108.289     0.200
     7.771   113.055     0.200
     7.727   114.656     0.200
     7.905   115.844     0.200
     7.973   118.367     0.200
     8.035   116.555     0.200
     8.267   120.055     0.200
     8.348   121.555     0.200
     8.378   121.750     0.200
     8.624   125.055     0.200
     8.749   126.953     0.200
     8.758   127.133     0.200
     8.792   128.758     0.200
     8.907   128.656     0.200
     9.046   130.750     0.200
     9.058   132.570     0.200
     9.320   134.836     0.200
     9.812   141.289     0.200
     9.874   144.500     0.200
     9.979   144.352     0.200
     9.979   143.680     0.200
    10.016   144.281     0.200
    10.026   145.359     0.200
    10.079   146.781     0.200
    10.144   145.656     0.200
    10.174   146.133     0.200
    10.315   150.352     0.200
    10.318   149.914     0.200
    10.378   151.023     0.200
    12.129   173.977     0.200
    12.485   176.555     0.200
    13.995   200.469     0.200
    17.644   246.953     0.200
    18.606   260.109     0.200
    18.639   260.961     0.200
    20.325   281.492     0.200
     1.992    34.613     0.200
     1.981    36.141     0.200
     2.121    37.691     0.200
     2.301    39.387     0.200
     2.398    40.922     0.200
     2.546    43.996     0.200
     2.558    42.801     0.200
     2.612    43.910     0.200
     2.794    46.512     0.200
     3.111    50.504     0.200
     3.169    49.582     0.200
     3.176    50.660     0.200
     3.266    53.391     0.200
     3.269    50.391     0.200
     3.385    54.758     0.200
     3.494    55.812     0.200
     3.615    57.633     0.200
     3.628    56.781     0.200
     3.747    58.137     0.200
     3.881    60.512     0.200
     4.001    61.867     0.200
     3.987    60.734     0.200
     4.113    66.148     0.200
     4.182    65.859     0.200
     4.545    69.957     0.200
     4.596    69.621     0.200
     4.648    70.523     0.200
     4.658    70.090     0.200
     4.678    70.551     0.200
     4.780    72.750     0.200
     4.774    74.566     0.200
     4.876    73.879     0.200
     4.929    74.320     0.200
     4.975    74.434     0.200
     4.975    74.621     0.200
     5.135    77.820     0.200
     5.201    78.023     0.200
     5.223    82.426     0.200
     5.583    83.820     0.200
     5.680    84.852     0.200
     5.932    88.223     0.200
     5.932    88.574     0.200
     6.040    92.742     0.200
     6.262    92.012     0.200
     6.312    93.223     0.200
     6.409    95.023     0.200
     6.424    95.086     0.200
     6.611    97.523     0.200
     6.821   100.422     0.200
     7.370   108.023     0.200
     7.878   115.777     0.200
     8.014   117.023     0.200
     8.247   120.121     0.200
     8.357   121.523     0.200
     8.602   124.820     0.200
     8.729   126.523     0.200
     8.729   126.820     0.200
     8.736   126.645     0.200
     8.887   128.168     0.200
     9.026   130.621     0.200
     1.447    26.414     0.200
     1.531    27.137     0.200
     3.976    65.098     0.200
     4.043    61.328     0.200
     4.047    60.730     0.200
     4.384    66.328     0.200
     4.999    74.730     0.200
     5.583    83.531     0.200
     5.599    83.828     0.200
     2.376    41.152     0.200
     2.456    38.990     0.200
     2.683    43.561     0.200
     2.817    45.730     0.200
     2.852    46.338     0.200
     2.959    47.738     0.200
     3.074    51.100     0.200
     3.253    51.549     0.200
     3.327    54.174     0.200
     3.705    60.348     0.200
     3.910    59.893     0.200
     3.958    60.730     0.200
     3.984    60.930     0.200
     3.990    61.049     0.200
     3.978    60.861     0.200
     3.991    64.809     0.200
     4.063    62.643     0.200
     4.319    66.430     0.200
     4.367    67.430     0.200
     4.367    65.951     0.200
     4.387    67.150     0.200
     4.387    68.230     0.200
     4.453    71.824     0.200
     4.568    70.131     0.200
     4.790    76.262     0.200
     4.934    75.031     0.200
     4.927    74.520     0.200
     5.204    78.330     0.200
     5.295    82.549     0.200
     5.449    81.400     0.200
     5.608    83.631     0.200
     5.612    83.855     0.200
     5.660    84.531     0.200
     5.820    86.180     0.200
     5.963    89.830     0.200
     5.963    88.768     0.200
     6.068    89.930     0.200
     6.159    91.430     0.200
     6.576    97.230     0.200
     6.555    96.707     0.200
     6.612    97.631     0.200
     6.999   102.531     0.200
     7.084   104.865     0.200
     7.234   106.330     0.200
     7.234   105.635     0.200
     7.193   107.281     0.200
     7.592   110.930     0.200
     7.595   111.031     0.200
     7.813   113.730     0.200
     7.946   115.809     0.200
     7.969   116.031     0.200
     8.021   119.838     0.200
     8.126   118.309     0.200
     8.269   120.430     0.200
     9.426   139.730     0.200
     9.539   140.297     0.200
     9.823   144.830     0.200
     9.970   146.434     0.200
     1.993    32.275     0.200
     2.197    37.557     0.200
     2.396    40.543     0.200
     2.377    41.037     0.200
     2.476    39.898     0.200
     2.703    42.383     0.200
     2.718    44.867     0.200
     2.836    45.014     0.200
     2.871    45.695     0.200
     2.947    48.143     0.200
     2.978    46.646     0.200
     3.093    49.842     0.200
     3.271    51.752     0.200
     3.346    53.324     0.200
     3.518    56.314     0.200
     3.759    57.271     0.200
     3.660    57.346     0.200
     3.928    58.678     0.200
     3.974    60.113     0.200
     4.000    60.414     0.200
     4.007    60.193     0.200
     3.997    60.021     0.200
     4.009    63.857     0.200
     4.083    62.057     0.200
     4.334    65.914     0.200
     4.380    66.814     0.200
     4.380    65.512     0.200
     4.401    65.713     0.200
     4.414    67.113     0.200
     4.471    70.957     0.200
     4.471    70.027     0.200
     4.602    68.674     0.200
     4.806    74.787     0.200
     4.950    74.213     0.200
     4.946    73.311     0.200
     5.221    77.613     0.200
     5.313    81.080     0.200
     5.469    80.295     0.200
     5.625    83.014     0.200
     5.632    83.074     0.200
     5.632    83.451     0.200
     5.678    83.914     0.200
     6.087    89.414     0.200
     6.176    90.514     0.200
     6.354    95.070     0.200
     6.593    96.514     0.200
     6.630    96.414     0.200
     7.017   101.414     0.200
     7.103   104.145     0.200
     7.254   105.314     0.200
     7.254   105.164     0.200
     7.502   109.014     0.200
     7.613   110.414     0.200
     7.832   113.213     0.200
     7.987   115.713     0.200
     8.039   119.021     0.200
     8.144   117.719     0.200
     8.288   119.914     0.200
     1.976    32.426     0.200
     2.483    39.965     0.200
     2.708    44.574     0.200
     2.847    46.953     0.200
     2.979    47.477     0.200
     3.098    49.898     0.200
     3.347    53.727     0.200
     3.640    57.609     0.200
     3.518    56.609     0.200
     4.011    64.434     0.200
     3.942    60.352     0.200
     3.785    61.727     0.200
     4.007    61.918     0.200
     4.090    62.902     0.200
     3.991    59.953     0.200
     4.023    61.492     0.200
     4.017    60.254     0.200
     4.471    71.164     0.200
     4.352    65.852     0.200
     4.399    67.152     0.200
     4.419    67.652     0.200
     4.633    70.555     0.200
     4.605    70.219     0.200
     4.960    74.199     0.200
     4.968    74.352     0.200
     5.311    81.996     0.200
     5.237    77.754     0.200
     5.476    80.895     0.200
     5.641    83.055     0.200
     5.692    83.953     0.200
     6.101    89.453     0.200
     7.266   105.352     0.200
     7.627   110.453     0.200
     1.997    35.059     0.200
     2.023    32.703     0.200
     3.685    59.432     0.200
     3.920    59.824     0.200
     3.993    61.152     0.200
     3.997    61.529     0.200
     4.023    64.430     0.200
     4.087    64.391     0.200
     4.938    73.662     0.200
     5.330    81.650     0.200
     1.495    26.406     0.200
     1.898    32.488     0.200
     2.043    35.336     0.200
     2.300    36.812     0.200
     2.582    43.301     0.200
     3.070    47.637     0.200
     3.178    51.246     0.200
     3.589    58.176     0.200
     5.406    79.367     0.200
     5.468    80.367     0.200
     5.536    80.945     0.200
     5.712    84.168     0.200
     5.758    84.527     0.200
     5.864    87.270     0.200
     5.898    86.477     0.200
     6.305    91.867     0.200
     6.556    95.559     0.200
     6.768    98.570     0.200
     7.107   102.867     0.200
     7.274   105.168     0.200
     8.929   128.270     0.200
     8.929   127.793     0.200
     1.425    26.958     0.200
     1.484    26.958     0.200
     2.052    36.253     0.200
     2.390    42.137     0.200
     2.450    40.898     0.200
     2.656    45.233     0.200
     3.014    48.560     0.200
     3.112    50.229     0.200
     3.275    53.660     0.200
     3.794    62.264     0.200
     3.920    62.882     0.200
     3.978    64.249     0.200
     4.448    69.101     0.200
     4.605    70.889     0.200
     4.807    73.920     0.200
     4.837    74.590     0.200
     4.846    74.790     0.200
     5.179    78.790     0.200
     5.841    88.190     0.200
     1.933    37.387     0.200
     3.025    51.879     0.200
     3.004    49.242     0.200
     3.243    53.855     0.200
     3.414    57.148     0.200
     3.462    57.809     0.200
     4.163    63.156     0.200
     5.266    78.621     0.200
     5.345    79.723     0.200
     5.345    80.203     0.200
     5.417    80.863     0.200
     5.449    81.215     0.200
     5.512    82.621     0.200
     5.587    83.121     0.200
     5.655    84.324     0.200
     5.684    87.668     0.200
     5.770    86.551     0.200
     5.823    86.621     0.200
     5.904    87.434     0.200
     5.904    87.621     0.200
     5.911    87.922     0.200
     6.253    92.023     0.200
     7.040   102.922     0.200
     7.158   104.773     0.200
     7.192   105.422     0.200
     7.607   111.422     0.200
     7.655   111.605     0.200
     8.162   118.922     0.200
     8.835   128.324     0.200
     8.835   127.824     0.200
     9.153   132.523     0.200
     9.437   136.422     0.200
     9.572   138.074     0.200
     9.679   138.840     0.200
     9.813   142.223     0.200
     2.842    46.500     0.200
     3.447    54.500     0.200
     3.801    60.758     0.200
     5.403    79.023     0.200
     5.499    80.023     0.200
     5.594    81.922     0.200
     5.668    81.461     0.200
     5.685    82.508     0.200
     6.041    87.477     0.200
     6.041    88.023     0.200
     6.091    87.391     0.200
     6.382    92.125     0.200
     7.397   106.422     0.200
     1.589    28.488     0.200
     2.182    38.770     0.200
     6.095    91.547     0.200
     6.175    92.648     0.200
     6.223    93.848     0.200
     6.438    96.648     0.200
     6.469    96.648     0.200
     6.668   100.148     0.200
     6.982   103.750     0.200
     7.878   116.348     0.200
     7.943   118.547     0.200
     8.163   119.547     0.200
     1.815    32.484     0.200
     2.470    42.516     0.200
     2.985    48.859     0.200
     3.394    54.867     0.200
     3.790    60.305     0.200
     4.842    73.664     0.200
     5.053    77.484     0.200
     5.093    77.914     0.200
     7.010   103.734     0.200
     1.924    34.062     0.200
     2.053    36.055     0.200
     2.980    47.406     0.200
     3.078    49.625     0.200
     3.412    52.648     0.200
     3.384    52.602     0.200
     3.517    55.352     0.200
     3.601    55.648     0.200
     3.764    58.898     0.200
     3.766    58.430     0.200
     4.189    63.906     0.200
     4.389    65.953     0.200
     4.484    68.320     0.200
     4.773    73.047     0.200
     5.281    79.727     0.200
     5.459    81.250     0.200
     6.075    89.953     0.200
     6.193    92.250     0.200
     7.166   104.391     0.200
     1.815    31.562     0.200
     2.770    45.821     0.200
     3.564    56.665     0.200
     3.672    60.430     0.200
     4.322    68.154     0.200
     4.778    74.108     0.200
     4.783    74.168     0.200
     1.737    30.605     0.200
     1.768    31.810     0.200
     1.758    32.942     0.200
     1.959    36.750     0.200
     2.309    38.012     0.200
     2.550    45.702     0.200
     2.526    45.145     0.200
     2.891    47.777     0.200
     3.020    48.726     0.200
     3.117    51.155     0.200
     3.384    54.575     0.200
     3.566    59.795     0.200
     3.778    60.678     0.200
     3.860    59.936     0.200
     3.861    61.256     0.200
     3.909    61.546     0.200
     3.983    60.848     0.200
     3.984    61.298     0.200
     3.994    60.747     0.200
     4.231    66.667     0.200
     4.231    67.590     0.200
     4.332    65.947     0.200
     4.428    67.747     0.200
     4.428    66.928     0.200
     4.435    67.447     0.200
     4.543    70.025     0.200
     4.867    76.799     0.200
     4.870    77.033     0.200
     4.948    74.447     0.200
     5.062    78.048     0.200
     5.291    80.646     0.200
     5.585    84.247     0.200
     5.603    84.147     0.200
     5.907    88.237     0.200
     6.881   102.737     0.200
     9.020   132.088     0.200
     9.292   135.827     0.200
     1.810    32.416     0.200
     2.340    38.332     0.200
     3.164    51.699     0.200
     3.440    55.789     0.200
     3.826    60.912     0.200
     3.886    60.762     0.200
     3.869    59.629     0.200
     3.942    61.789     0.200
     3.983    60.891     0.200
     4.281    67.611     0.200
     1.763    29.195     0.200
     1.786    29.953     0.200
     2.004    32.559     0.200
     2.383    37.863     0.200
     2.968    46.746     0.200
     3.096    49.160     0.200
     3.195    50.148     0.200
     3.856    60.426     0.200
     3.919    58.867     0.200
     3.932    60.309     0.200
     3.984    61.363     0.200
     4.026    60.586     0.200
     4.034    60.391     0.200
     4.040    59.285     0.200
     4.378    64.883     0.200
     5.138    78.055     0.200
     5.367    79.539     0.200
     5.639    82.086     0.200
     1.571    26.688     0.200
     1.617    28.320     0.200
     1.883    33.152     0.200
     1.947    32.406     0.200
     2.026    32.473     0.200
     2.529    41.891     0.200
     2.569    39.762     0.200
     3.039    46.434     0.200
     3.340    50.480     0.200
     3.411    54.527     0.200
     3.506    54.398     0.200
     3.549    53.922     0.200
     3.697    57.262     0.200
     3.880    60.332     0.200
     4.339    66.852     0.200
     4.614    69.301     0.200
     4.618    69.223     0.200
     4.659    68.059     0.200
     4.786    70.371     0.200
     4.791    69.879     0.200
     5.196    76.191     0.200
     5.196    75.031     0.200
     5.213    75.230     0.200
     5.665    82.789     0.200
     1.982    36.186     0.200
     2.287    41.514     0.200
     3.047    48.246     0.200
     3.691    58.766     0.200
     4.067    62.135     0.200
     4.182    64.803     0.200
     4.228    66.695     0.200
     4.269    66.135     0.200
     4.269    65.824     0.200
     4.380    68.436     0.200
     4.443    68.855     0.200
     4.565    71.336     0.200
     4.634    71.152     0.200
     4.722    74.846     0.200
     4.980    76.135     0.200
     5.200    79.936     0.200
     5.201    78.766     0.200
     5.415    82.734     0.200
     5.920    88.635     0.200
     6.017    89.363     0.200
     6.210    92.223     0.200
     6.335    94.336     0.200
     6.421    95.535     0.200
     1.750    31.746     0.200
     1.714    31.771     0.200
     2.331    40.586     0.200
     2.444    43.628     0.200
     2.480    43.194     0.200
     2.572    42.376     0.200
     2.639    44.773     0.200
     2.875    46.864     0.200
     2.946    48.806     0.200
     3.620    55.966     0.200
     3.676    57.603     0.200
     3.950    62.539     0.200
     3.959    61.911     0.200
     4.108    63.036     0.200
     4.360    68.124     0.200
     4.475    71.484     0.200
     4.845    72.896     0.200
     4.909    73.996     0.200
     4.950    74.686     0.200
     4.961    74.724     0.200
     5.118    77.046     0.200
     5.139    77.696     0.200
     5.135    79.886     0.200
     5.228    79.496     0.200
     5.228    80.234     0.200
     5.430    81.996     0.200
     5.584    87.936     0.200
     5.983    88.855     0.200
     6.030    89.896     0.200
     6.030    89.416     0.200
     6.222    92.896     0.200
     6.398    98.306     0.200
     6.589    97.796     0.200
     6.615    97.924     0.200
     6.710    99.196     0.200
     6.780   100.020     0.200
     6.858   102.596     0.200
     6.858   101.144     0.200
     7.123   104.896     0.200
     7.138   104.526     0.200
     7.150   105.396     0.200
     7.675   112.396     0.200
     8.052   118.196     0.200
     8.332   121.696     0.200
     8.332   121.506     0.200
     8.665   126.296     0.200
     9.061   131.558     0.200
     9.193   133.096     0.200
    10.102   145.514     0.200
     2.543    41.833     0.200
     2.601    42.105     0.200
     2.903    46.365     0.200
     4.868    72.397     0.200
     4.931    74.397     0.200
     4.970    74.117     0.200
     4.976    74.456     0.200
     5.250    78.798     0.200
     5.999    88.287     0.200
     6.240    91.398     0.200
     6.725    99.297     0.200
     1.316    24.820     0.200
     1.220    22.438     0.200
     1.847    33.305     0.200
     2.090    35.547     0.200
     2.939    45.594     0.200
     3.109    46.992     0.200
     3.303    49.812     0.200
     3.739    56.359     0.200
     3.762    56.539     0.200
     4.077    61.172     0.200
     4.152    62.469     0.200
     4.082    62.273     0.200
     4.205    62.984     0.200
     4.263    63.547     0.200
     4.353    63.969     0.200
     4.464    66.773     0.200
     4.516    67.023     0.200
     4.649    68.773     0.200
     4.700    69.500     0.200
     4.771    72.633     0.200
     5.065    74.375     0.200
     5.284    78.070     0.200
     5.282    77.062     0.200
     6.001    86.969     0.200
     6.086    89.070     0.200
     6.086    88.305     0.200
     6.084    88.469     0.200
     6.274    90.531     0.200
     6.498    93.422     0.200
     7.658   109.891     0.200
     7.829   111.820     0.200
     8.403   120.094     0.200
     1.795    31.883     0.200
     2.337    38.570     0.200
     3.392    52.922     0.200
     3.443    54.023     0.200
     3.476    54.141     0.200
     3.489    55.031     0.200
     3.719    58.781     0.200
     4.020    62.430     0.200
     3.915    60.461     0.200
     4.056    65.258     0.200
     4.511    69.078     0.200
     5.113    77.922     0.200
     2.206    36.930     0.200
     2.710    45.977     0.200
     2.890    46.477     0.200
     2.989    50.273     0.200
     3.112    50.297     0.200
     3.546    55.828     0.200
     3.852    60.125     0.200
     3.923    61.125     0.200
     3.934    61.234     0.200
     3.973    59.953     0.200
     3.907    61.797     0.200
     4.026    60.516     0.200
     4.143    63.273     0.200
     4.237    65.625     0.200
     4.283    65.844     0.200
     4.487    67.922     0.200
     4.475    68.750     0.200
     4.575    70.812     0.200
     4.840    72.922     0.200
     5.045    75.609     0.200
     5.765    85.422     0.200
     5.858    86.453     0.200
     6.052    89.062     0.200
     7.420   108.516     0.200
     7.621   111.016     0.200
     2.810    46.129     0.200
     4.343    66.207     0.200
     4.399    66.371     0.200
     4.460    67.843     0.200
     4.654    70.808     0.200
     4.709    71.173     0.200
     4.903    73.808     0.200
     4.885    73.942     0.200
     5.254    78.007     0.200
     5.479    81.560     0.200
     1.807    32.984     0.200
     2.421    39.789     0.200
     2.489    40.695     0.200
     2.564    43.672     0.200
     2.774    46.711     0.200
     2.823    46.398     0.200
     2.933    48.852     0.200
     2.915    50.234     0.200
     2.998    50.195     0.200
     3.437    56.570     0.200
     3.884    62.422     0.200
     4.006    62.727     0.200
     4.253    65.344     0.200
     4.517    69.070     0.200
     4.570    69.766     0.200
     4.852    75.031     0.200
     5.157    78.367     0.200
     5.208    78.688     0.200
     5.519    83.070     0.200
     1.920    34.348     0.200
     2.376    40.137     0.200
     2.548    41.465     0.200
     2.619    45.113     0.200
     2.711    44.172     0.200
     2.567    43.320     0.200
     2.952    50.354     0.200
     3.019    49.432     0.200
     3.116    50.270     0.200
     3.718    61.098     0.200
     3.959    60.623     0.200
     4.370    67.674     0.200
     4.571    72.072     0.200
     5.252    78.107     0.200
     5.301    79.334     0.200
     5.360    80.033     0.200
     5.382    80.025     0.200
     5.395    80.461     0.200
     5.384    82.973     0.200
     5.490    82.793     0.200
     5.562    83.982     0.200
     5.606    83.533     0.200
     5.606    82.834     0.200
     5.663    84.184     0.200
     5.663    84.834     0.200
     5.893    87.734     0.200
     6.289    92.834     0.200
     6.404    94.217     0.200
     6.475    95.533     0.200
     6.591    99.543     0.200
     6.656    97.934     0.200
     6.945   103.342     0.200
     7.032   103.133     0.200
     7.133   104.434     0.200
     7.316   108.033     0.200
     7.546   110.234     0.200
     8.736   126.633     0.200
     1.949    34.451     0.200
     2.102    33.330     0.200
     2.924    44.855     0.200
     3.882    58.637     0.200
     3.954    59.936     0.200
     4.005    60.285     0.200
     4.060    60.539     0.200
     4.230    62.736     0.200
     4.268    64.137     0.200
     4.317    64.693     0.200
     4.461    66.035     0.200
     4.510    67.344     0.200
     4.871    71.535     0.200
     5.079    74.484     0.200
     5.296    78.236     0.200
     5.645    83.137     0.200
     5.798    84.336     0.200
     6.214    89.936     0.200
     6.296    91.256     0.200
     7.454   107.637     0.200
     7.454   107.455     0.200
     2.141    36.125     0.200
     2.957    46.746     0.200
     4.248    63.523     0.200
     4.367    65.125     0.200
     4.646    69.125     0.200
     5.212    76.723     0.200
     6.076    89.324     0.200
     3.841    62.836     0.200
     3.990    61.172     0.200
     4.063    62.172     0.200
     4.376    66.477     0.200
     4.567    69.070     0.200
     4.978    74.273     0.200
     1.749    32.680     0.200
     2.186    37.113     0.200
     2.420    42.430     0.200
     2.696    44.500     0.200
     2.835    45.680     0.200
     2.851    46.566     0.200
     3.638    55.727     0.200
     4.811    71.176     0.200
     4.877    71.977     0.200
     4.921    72.945     0.200
     4.939    73.422     0.200
     5.107    76.266     0.200
     5.195    77.875     0.200
     5.224    78.102     0.200
     5.392    79.477     0.200
     5.799    85.574     0.200
     5.961    87.559     0.200
     6.560    95.375     0.200
     6.686    97.477     0.200
     1.396    27.354     0.200
     2.050    37.180     0.200
     2.703    46.362     0.200
     3.329    55.007     0.200
     3.879    62.319     0.200
     5.449    83.594     0.200
     5.629    84.960     0.200
     5.905    89.476     0.200
     6.328    94.594     0.200
     7.355   109.694     0.200
     0.349    10.250     0.200
     0.750    16.453     0.200
     0.774    15.992     0.200
     0.791    16.398     0.200
     1.575    27.066     0.200
     1.669    29.766     0.200
     2.018    32.469     0.200
     2.080    32.488     0.200
     2.105    34.945     0.200
     4.535    67.035     0.200
     4.534    65.520     0.200
     4.638    67.012     0.200
     4.637    67.516     0.200
     4.972    71.914     0.200
     5.255    76.215     0.200
     5.547    79.543     0.200
     5.588    80.414     0.200
     6.250    89.215     0.200
     1.638    29.691     0.200
     1.638    29.289     0.200
     1.580    29.203     0.200
     2.025    34.766     0.200
     2.449    40.117     0.200
     2.511    41.586     0.200
     2.427    39.070     0.200
     2.517    39.676     0.200
     2.558    40.316     0.200
     2.738    42.469     0.200
     2.887    46.387     0.200
     2.928    45.777     0.200
     3.000    46.898     0.200
     3.281    50.707     0.200
     3.367    53.055     0.200
     3.648    55.383     0.200
     3.742    59.246     0.200
     3.989    59.277     0.200
     4.046    59.953     0.200
     4.042    59.887     0.200
     4.030    63.527     0.200
     4.073    60.266     0.200
     4.068    60.188     0.200
     4.123    62.184     0.200
     4.402    64.789     0.200
     4.476    66.988     0.200
     4.451    65.219     0.200
     4.451    65.688     0.200
     4.451    65.488     0.200
     4.471    65.977     0.200
     4.488    68.570     0.200
     4.650    68.586     0.200
     4.654    68.129     0.200
     4.684    68.988     0.200
     4.739    70.848     0.200
     4.739    71.199     0.200
     4.807    73.094     0.200
     5.005    73.637     0.200
     5.018    73.688     0.200
     5.284    77.527     0.200
     5.284    77.688     0.200
     5.323    81.074     0.200
     5.269    80.086     0.200
     5.508    80.691     0.200
     5.508    80.809     0.200
     5.668    82.645     0.200
     5.668    83.375     0.200
     5.668    81.449     0.200
     5.670    83.039     0.200
     5.690    82.988     0.200
     5.522    83.789     0.200
     5.540    83.789     0.200
     5.738    83.789     0.200
     5.792    88.027     0.200
     5.976    89.984     0.200
     6.046    88.086     0.200
     6.046    88.289     0.200
     6.085    88.816     0.200
     6.146    89.289     0.200
     6.240    90.586     0.200
     6.296    91.488     0.200
     6.613    96.145     0.200
     6.656    96.488     0.200
     6.689    97.188     0.200
     6.689    96.758     0.200
     6.766    98.188     0.200
     6.766    97.246     0.200
     7.077   101.688     0.200
     7.128   103.594     0.200
     7.061   103.766     0.200
     7.224   106.141     0.200
     7.309   105.332     0.200
     7.560   108.988     0.200
     7.885   113.086     0.200
     8.019   115.117     0.200
     8.046   115.789     0.200
     8.049   117.402     0.200
     8.202   117.645     0.200
     8.421   123.535     0.200
     8.404   122.566     0.200
     8.630   123.676     0.200
     8.691   126.465     0.200
     9.092   132.332     0.200
     9.247   133.316     0.200
     9.244   133.566     0.200
     9.343   135.641     0.200
     9.436   134.316     0.200
     9.450   134.551     0.200
     9.468   137.789     0.200
     9.497   137.789     0.200
     9.484   140.449     0.200
     9.603   138.777     0.200
     9.631   139.504     0.200
     9.860   143.586     0.200
     9.997   144.859     0.200
    10.811   155.988     0.200
    11.713   168.086     0.200
    12.115   173.789     0.200
    12.096   173.488     0.200
    12.815   182.387     0.200
    12.844   183.688     0.200
    13.051   186.586     0.200
    13.070   181.488     0.200
    13.371   190.586     0.200
    13.662   189.789     0.200
    13.698   189.988     0.200
    13.812   196.688     0.200
    13.806   196.887     0.200
    13.951   193.586     0.200
    14.141   198.078     0.200
    14.183   196.789     0.200
    14.225   197.188     0.200
    14.225   201.789     0.200
    14.382   199.289     0.200
    14.471   205.188     0.200
    14.769   204.887     0.200
    14.769   209.488     0.200
    15.066   208.688     0.200
    15.066   212.887     0.200
    15.981   221.086     0.200
    16.240   224.887     0.200
    16.343   226.289     0.200
    16.520   228.688     0.200
    17.347   239.988     0.200
    18.158   250.293     0.200
    18.174   251.152     0.200
    18.851   260.168     0.200
    18.950   261.211     0.200
    19.036   262.219     0.200
    19.300   265.387     0.200
     1.833    31.625     0.200
     1.836    31.625     0.200
     1.871    32.867     0.200
     2.133    36.422     0.200
     2.401    41.195     0.200
     2.402    39.797     0.200
     2.376    39.086     0.200
     2.301    39.273     0.200
     2.141    39.250     0.200
     2.291    38.797     0.200
     2.881    45.156     0.200
     2.892    46.797     0.200
     2.794    45.820     0.200
     3.037    48.469     0.200
     3.156    49.984     0.200
     3.315    52.477     0.200
     3.443    55.180     0.200
     3.511    55.594     0.200
     3.589    55.680     0.200
     3.842    61.500     0.200
     4.152    65.953     0.200
     4.445    69.242     0.200
     4.465    68.234     0.200
     4.537    69.312     0.200
     4.562    71.211     0.200
     4.606    70.070     0.200
     4.534    69.938     0.200
     4.534    70.289     0.200
     4.686    70.633     0.200
     4.692    70.367     0.200
     4.700    69.969     0.200
     4.700    70.805     0.200
     4.720    72.172     0.200
     4.823    74.070     0.200
     5.033    75.766     0.200
     5.039    76.164     0.200
     5.135    75.961     0.200
     5.135    77.156     0.200
     5.135    76.164     0.200
     5.143    76.195     0.200
     5.089    77.367     0.200
     5.105    77.367     0.200
     5.262    78.969     0.200
     5.290    78.508     0.200
     5.290    78.867     0.200
     5.324    81.453     0.200
     5.350    79.266     0.200
     5.286    80.469     0.200
     5.538    83.047     0.200
     5.655    83.867     0.200
     5.708    87.195     0.200
     5.809    87.305     0.200
     5.809    87.055     0.200
     5.847    87.367     0.200
     5.865    87.867     0.200
     5.935    89.391     0.200
     5.935    89.102     0.200
     6.271    93.070     0.200
     6.371    94.586     0.200
     6.517    96.664     0.200
     6.603    98.664     0.200
     6.671    98.570     0.200
     6.680    98.578     0.200
     6.817   100.469     0.200
     6.893   101.469     0.200
     6.901   102.039     0.200
     6.876   102.039     0.200
     7.201   105.664     0.200
     7.201   105.875     0.200
     7.224   105.969     0.200
     7.264   107.273     0.200
     7.325   107.766     0.200
     7.598   110.664     0.200
     7.776   113.820     0.200
     8.059   117.070     0.200
     8.034   118.312     0.200
     8.195   120.039     0.200
     8.326   121.570     0.200
     8.457   123.352     0.200
     8.549   124.469     0.200
     8.704   126.734     0.200
     8.855   129.070     0.200
     9.151   132.898     0.200
     9.305   136.000     0.200
     9.409   137.508     0.200
     9.503   139.023     0.200
     9.583   138.914     0.200
     9.569   140.570     0.200
     9.596   139.078     0.200
     9.544   138.867     0.200
     9.568   139.258     0.200
     9.638   140.969     0.200
     9.692   140.766     0.200
     9.874   143.375     0.200
     9.920   144.867     0.200
     9.965   143.883     0.200
    11.251   162.594     0.200
    11.804   171.070     0.200
    12.154   174.969     0.200
    12.680   182.266     0.200
    12.912   185.266     0.200
    13.208   190.469     0.200
    13.530   193.570     0.200
    13.550   194.164     0.200
    14.847   210.664     0.200
    14.942   212.914     0.200
    17.642   246.820     0.200
    17.634   246.195     0.200
     1.324    24.422     0.200
     2.007    31.715     0.200
     2.188    33.055     0.200
     2.229    36.168     0.200
     2.455    37.516     0.200
     2.963    44.402     0.200
     3.260    47.938     0.200
     3.901    58.051     0.200
     3.945    57.645     0.200
     3.973    59.789     0.200
     3.972    57.945     0.200
     3.979    59.113     0.200
     3.995    62.066     0.200
     4.062    62.043     0.200
     4.306    63.445     0.200
     4.558    65.938     0.200
     4.558    67.047     0.200
     4.586    67.746     0.200
     4.919    71.129     0.200
     4.922    71.848     0.200
     5.194    76.246     0.200
     5.303    79.754     0.200
     1.681    29.789     0.200
     1.757    31.180     0.200
     5.882    86.859     0.200
     5.963    87.961     0.200
     6.019    88.836     0.200
     6.064    89.016     0.200
     6.868   100.359     0.200
     7.086   103.859     0.200
     1.690    30.716     0.200
     2.021    36.232     0.200
     2.139    36.676     0.200
     2.662    45.724     0.200
     3.346    55.548     0.200
     3.321    53.810     0.200
     4.155    66.257     0.200
     4.595    70.477     0.200
     4.638    70.777     0.200
     4.660    70.107     0.200
     4.777    74.495     0.200
     4.950    74.277     0.200
     4.967    75.377     0.200
     4.989    75.277     0.200
     5.212    78.477     0.200
     5.219    78.477     0.200
     5.579    83.677     0.200
     5.635    84.145     0.200
     5.899    87.677     0.200
     6.289    93.477     0.200
     6.366    94.077     0.200
     6.776    99.977     0.200
     1.365    25.141     0.200
     1.611    29.168     0.200
     1.611    28.873     0.200
     1.816    32.352     0.200
     1.904    34.516     0.200
     2.028    35.465     0.200
     2.174    36.518     0.200
     2.189    37.053     0.200
     2.387    40.811     0.200
     2.388    40.232     0.200
     2.372    38.795     0.200
     2.503    40.549     0.200
     2.649    43.193     0.200
     2.538    42.109     0.200
     2.774    45.559     0.200
     3.003    48.967     0.200
     2.944    48.297     0.200
     2.967    48.312     0.200
     2.957    48.812     0.200
     3.044    49.812     0.200
     3.039    46.650     0.200
     3.095    50.523     0.200
     3.347    52.961     0.200
     3.264    50.162     0.200
     3.389    53.312     0.200
     3.436    55.041     0.200
     3.408    53.561     0.200
     3.521    54.652     0.200
     3.651    57.266     0.200
     3.784    59.051     0.200
     3.888    61.381     0.200
     4.163    62.777     0.200
     4.131    64.127     0.200
     4.296    65.693     0.200
     4.258    67.637     0.200
     4.258    67.213     0.200
     4.317    65.113     0.200
     4.413    66.412     0.200
     4.459    67.023     0.200
     4.459    66.773     0.200
     4.446    66.680     0.200
     4.482    67.320     0.200
     4.553    68.150     0.200
     4.553    69.172     0.200
     4.549    71.199     0.200
     4.645    70.170     0.200
     4.767    71.111     0.200
     4.767    71.213     0.200
     4.786    72.012     0.200
     4.806    71.992     0.200
     4.925    74.312     0.200
     5.029    75.412     0.200
     5.038    74.973     0.200
     5.058    76.012     0.200
     5.001    78.113     0.200
     5.001    77.234     0.200
     5.203    77.842     0.200
     5.280    81.355     0.200
     5.399    80.412     0.200
     5.467    81.000     0.200
     5.577    84.512     0.200
     5.726    85.053     0.200
     5.726    84.803     0.200
     5.825    88.898     0.200
     6.032    88.656     0.200
     6.032    89.002     0.200
     6.113    90.113     0.200
     6.197    91.213     0.200
     6.194    91.488     0.200
     6.194    91.350     0.200
     6.427    95.180     0.200
     6.584    96.725     0.200
     6.608    96.812     0.200
     6.669    97.912     0.200
     6.711    98.613     0.200
     6.915   101.922     0.200
     7.092   103.713     0.200
     7.064   108.012     0.200
     7.156   104.512     0.200
     7.156   104.203     0.200
     7.137   104.611     0.200
     7.207   105.412     0.200
     7.207   103.932     0.200
     7.390   107.861     0.200
     7.421   112.113     0.200
     7.539   109.412     0.200
     7.510   110.840     0.200
     7.651   112.660     0.200
     7.794   112.971     0.200
     8.507   124.898     0.200
     8.515   123.213     0.200
     8.513   123.301     0.200
     8.672   124.490     0.200
     8.813   127.213     0.200
     8.845   128.496     0.200
     9.089   130.354     0.200
     9.762   140.227     0.200
     9.762   140.602     0.200
     9.769   141.201     0.200
     9.912   142.256     0.200
     9.930   143.201     0.200
     9.988   145.812     0.200
    10.021   146.512     0.200
    10.060   145.936     0.200
    10.074   146.424     0.200
    10.125   147.158     0.200
    10.244   150.213     0.200
    10.244   148.652     0.200
    10.375   151.613     0.200
    11.191   161.852     0.200
    12.025   174.838     0.200
    12.025   174.562     0.200
    13.008   186.562     0.200
    13.293   186.812     0.200
    13.564   190.713     0.200
    13.852   196.643     0.200
    14.157   197.412     0.200
    14.229   199.812     0.200
    14.327   205.113     0.200
    14.697   210.512     0.200
    14.735   211.012     0.200
    14.988   209.713     0.200
    14.993   209.613     0.200
    15.282   218.012     0.200
    15.492   219.613     0.200
    15.563   221.812     0.200
    16.492   233.213     0.200
    16.800   237.512     0.200
    16.843   237.912     0.200
    17.030   239.812     0.200
    17.286   242.523     0.200
    17.497   244.883     0.200
    17.850   249.662     0.200
    18.084   251.113     0.200
    18.626   260.633     0.200
    20.114   278.652     0.200
    20.373   279.387     0.200
    20.712   283.211     0.200
     2.708    46.656     0.200
     2.816    47.773     0.200
     2.772    47.781     0.200
     3.755    61.707     0.200
     4.445    70.910     0.200
     1.903    33.754     0.200
     2.021    34.840     0.200
     2.021    34.227     0.200
     2.168    37.695     0.200
     2.373    38.199     0.200
     2.382    40.285     0.200
     2.507    40.066     0.200
     2.644    43.629     0.200
     2.777    46.305     0.200
     3.004    48.430     0.200
     2.938    46.965     0.200
     3.034    46.328     0.200
     3.345    52.398     0.200
     3.440    55.523     0.200
     3.384    53.656     0.200
     3.402    53.383     0.200
     3.518    53.945     0.200
     3.648    58.086     0.200
     3.783    57.672     0.200
     3.885    62.215     0.200
     4.161    62.613     0.200
     4.291    65.012     0.200
     4.312    65.160     0.200
     4.405    65.957     0.200
     4.439    66.305     0.200
     4.450    66.297     0.200
     4.450    66.555     0.200
     4.474    66.914     0.200
     4.547    68.703     0.200
     4.547    70.418     0.200
     4.641    69.703     0.200
     4.758    70.695     0.200
     4.758    71.559     0.200
     4.778    71.855     0.200
     4.797    71.246     0.200
     4.797    71.457     0.200
     4.918    73.758     0.200
     5.020    74.855     0.200
     4.999    77.016     0.200
     4.999    77.734     0.200
     5.030    74.266     0.200
     5.030    74.457     0.200
     5.050    75.457     0.200
     5.390    79.457     0.200
     5.460    81.023     0.200
     5.551    81.957     0.200
     5.719    84.465     0.200
     5.824    89.574     0.200
     6.028    88.535     0.200
     6.105    89.758     0.200
     6.190    90.957     0.200
     6.190    90.805     0.200
     6.190    91.270     0.200
     6.419    94.105     0.200
     6.419    94.855     0.200
     6.577    96.293     0.200
     6.601    96.656     0.200
     6.662    97.758     0.200
     6.703    98.355     0.200
     7.084   103.355     0.200
     7.149   104.457     0.200
     7.511   110.789     0.200
     7.532   109.355     0.200
     7.649   112.016     0.200
     7.787   112.688     0.200
     8.025   116.355     0.200
     8.373   120.758     0.200
     8.508   123.055     0.200
     8.507   122.766     0.200
     8.665   124.785     0.200
     8.806   126.957     0.200
     9.082   130.867     0.200
     9.757   139.766     0.200
     9.905   141.684     0.200
     9.924   142.746     0.200
    10.057   145.828     0.200
     2.135    36.270     0.200
     3.365    54.156     0.200
     4.500    67.062     0.200
     4.543    68.262     0.200
     4.857    72.961     0.200
     4.872    72.762     0.200
     5.117    76.363     0.200
     5.484    81.262     0.200
     5.641    82.863     0.200
     5.805    85.660     0.200
     6.194    90.062     0.200
     6.273    91.660     0.200
     1.637    29.740     0.200
     4.464    67.156     0.200
     4.508    67.857     0.200
     4.822    73.656     0.200
     4.836    73.256     0.200
     4.860    73.256     0.200
     5.082    76.857     0.200
     5.088    76.957     0.200
     5.106    77.557     0.200
     5.449    81.457     0.200
     5.606    83.256     0.200
     5.769    85.457     0.200
     6.159    90.857     0.200
     6.238    92.256     0.200
     6.649    97.656     0.200
     2.087    35.354     0.200
     2.479    42.165     0.200
     3.040    47.074     0.200
     3.389    56.113     0.200
     3.441    55.223     0.200
     3.507    53.984     0.200
     4.203    66.797     0.200
     4.468    67.452     0.200
     4.492    66.874     0.200
     4.513    67.644     0.200
     4.534    70.294     0.200
     4.562    69.214     0.200
     4.809    71.574     0.200
     4.809    71.674     0.200
     4.821    72.474     0.200
     4.846    72.874     0.200
     5.068    76.074     0.200
     5.073    74.854     0.200
     5.073    76.474     0.200
     5.434    80.874     0.200
     5.489    81.414     0.200
     5.752    85.074     0.200
     6.032    89.492     0.200
     6.220    91.674     0.200
     6.596    96.714     0.200
     6.630    97.074     0.200
     6.741    99.074     0.200
     1.847    34.957     0.200
     2.151    36.078     0.200
     2.184    40.129     0.200
     3.003    48.316     0.200
     3.003    47.730     0.200
     3.456    54.348     0.200
     3.705    57.816     0.200
     3.822    60.984     0.200
     4.453    68.570     0.200
     4.455    67.316     0.200
     4.492    68.570     0.200
     4.492    67.418     0.200
     4.510    68.398     0.200
     4.482    71.934     0.200
     4.608    70.945     0.200
     4.608    69.680     0.200
     4.822    71.613     0.200
     4.822    73.668     0.200
     4.822    73.668     0.200
     4.856    72.707     0.200
     4.856    73.570     0.200
     4.928    74.645     0.200
     5.077    77.070     0.200
     5.075    75.391     0.200
     5.075    77.168     0.200
     5.436    81.570     0.200
     5.474    82.266     0.200
     5.584    83.570     0.200
     5.742    86.570     0.200
     5.993    89.207     0.200
     6.136    91.168     0.200
     6.150    91.277     0.200
     6.206    92.367     0.200
     6.616    97.867     0.200
     6.738    99.367     0.200
     7.161   106.168     0.200
     7.161   104.590     0.200
     7.789   113.340     0.200
    17.043   239.578     0.200
     2.283    40.465     0.200
     5.204    78.797     0.200
     5.292    79.797     0.200
     5.507    84.000     0.200
     5.596    85.098     0.200
     6.188    93.098     0.200
     6.993   103.500     0.200
     7.166   106.797     0.200
     2.491    44.350     0.200
     2.572    44.569     0.200
     3.036    51.854     0.200
     3.087    51.613     0.200
     3.147    52.583     0.200
     3.293    54.078     0.200
     3.457    55.887     0.200
     3.568    56.995     0.200
     4.057    65.329     0.200
     4.225    65.907     0.200
     4.476    70.946     0.200
     4.472    69.959     0.200
     4.760    73.547     0.200
     4.871    76.059     0.200
     5.028    79.782     0.200
     5.127    80.873     0.200
     5.208    78.809     0.200
     5.297    79.809     0.200
     5.361    80.792     0.200
     5.425    81.880     0.200
     5.439    82.357     0.200
     5.508    82.879     0.200
     5.508    83.309     0.200
     5.600    85.409     0.200
     5.678    85.906     0.200
     5.747    87.009     0.200
     5.846    87.359     0.200
     5.846    87.909     0.200
     5.790    89.307     0.200
     5.829    87.351     0.200
     5.893    89.909     0.200
     6.191    92.209     0.200
     6.438    96.109     0.200
     6.457    96.230     0.200
     6.665    99.009     0.200
     6.999   103.609     0.200
     7.067   107.158     0.200
     7.174   106.109     0.200
     7.203   106.632     0.200
     7.203   106.909     0.200
     7.217   107.021     0.200
     7.394   109.766     0.200
     7.590   112.109     0.200
     8.148   119.409     0.200
     8.513   125.609     0.200
     8.835   129.329     0.200
     8.887   130.065     0.200
     9.031   131.909     0.200
     9.444   138.309     0.200
     9.504   139.109     0.200
     9.580   140.073     0.200
     9.663   141.313     0.200
     2.364    40.771     0.200
     2.364    40.649     0.200
     2.515    43.230     0.200
     2.958    49.587     0.200
     5.378    81.090     0.200
     5.436    81.689     0.200
     5.740    86.390     0.200
     6.009    89.890     0.200
     1.221    25.051     0.200
     1.623    29.973     0.200
     1.959    34.914     0.200
     2.303    39.797     0.200
     2.810    47.180     0.200
     3.121    51.555     0.200
     3.524    56.094     0.200
     3.487    55.250     0.200
     3.469    55.852     0.200
     3.696    58.953     0.200
     4.334    69.617     0.200
     4.568    70.684     0.200
     4.546    70.113     0.200
     4.489    72.570     0.200
     4.603    69.785     0.200
     4.603    71.488     0.200
     4.616    70.035     0.200
     4.598    71.574     0.200
     4.654    71.551     0.200
     4.947    75.164     0.200
     4.947    75.883     0.200
     4.935    75.184     0.200
     5.197    78.984     0.200
     5.550    83.582     0.200
     5.564    83.891     0.200
     5.689    85.582     0.200
     5.838    87.184     0.200
     6.036    91.457     0.200
     6.239    92.582     0.200
     6.704    99.383     0.200
     3.053    49.762     0.200
     4.697    68.703     0.200
     4.754    69.902     0.200
     4.789    71.113     0.200
     4.918    72.180     0.200
     5.066    74.801     0.200
     5.077    75.602     0.200
     5.294    78.602     0.200
     5.685    83.402     0.200
     5.804    84.160     0.200
     6.425    93.102     0.200
     6.945   100.203     0.200
     6.943    99.742     0.200
     1.496    28.313     0.200
     1.496    27.602     0.200
     1.450    27.083     0.200
     1.711    30.219     0.200
     1.566    29.007     0.200
     2.694    45.622     0.200
     2.728    45.638     0.200
     2.939    50.171     0.200
     3.374    53.941     0.200
     3.188    52.101     0.200
     3.399    56.562     0.200
     3.652    56.952     0.200
     3.719    57.952     0.200
     3.719    57.707     0.200
     3.765    59.069     0.200
     3.753    61.430     0.200
     3.813    58.850     0.200
     4.011    63.751     0.200
     4.073    64.421     0.200
     3.939    63.531     0.200
     4.240    66.651     0.200
     4.273    66.620     0.200
     4.400    70.832     0.200
     4.641    70.452     0.200
     4.846    73.751     0.200
     5.405    81.151     0.200
     5.553    83.452     0.200
     5.654    85.030     0.200
     5.777    89.211     0.200
     5.851    88.540     0.200
     5.968    89.651     0.200
     6.048    91.102     0.200
     7.207   106.802     0.200
     7.433   109.901     0.200
     7.952   117.030     0.200
     8.041   117.912     0.200
     1.817    29.238     0.200
     2.011    35.102     0.200
     2.083    33.184     0.200
     2.157    35.531     0.200
     2.188    36.961     0.200
     2.468    40.680     0.200
     2.806    45.258     0.200
     3.040    49.832     0.200
     3.490    54.043     0.200
     3.636    56.699     0.200
     4.677    70.145     0.200
     4.691    70.496     0.200
     4.719    71.094     0.200
     4.769    70.277     0.200
     1.900    30.809     0.200
     2.188    37.328     0.200
     2.365    38.371     0.200
     3.496    52.508     0.200
     3.564    56.102     0.200
     3.668    54.609     0.200
     4.512    68.266     0.200
     4.624    67.270     0.200
     4.659    69.547     0.200
     4.661    68.488     0.200
     4.693    70.180     0.200
     4.693    68.586     0.200
     4.702    70.395     0.200
     4.704    68.656     0.200
     5.026    73.789     0.200
     5.045    74.207     0.200
     5.045    74.387     0.200
     5.075    74.387     0.200
     5.641    82.188     0.200
     6.324    91.289     0.200
     6.373    92.289     0.200
     6.929   100.289     0.200
     2.083    34.375     0.200
     2.999    49.344     0.200
     3.364    52.750     0.200
     3.540    55.402     0.200
     4.178    64.168     0.200
     4.478    68.246     0.200
     4.501    67.426     0.200
     4.522    68.543     0.200
     4.544    68.117     0.200
     4.597    69.984     0.200
     4.681    70.273     0.200
     4.835    71.871     0.200
     4.835    72.543     0.200
     4.873    73.246     0.200
     5.096    76.543     0.200
     5.463    81.246     0.200
     6.173    90.645     0.200
     6.253    92.043     0.200
     6.664    97.645     0.200
     7.845   113.188     0.200
     2.878    45.051     0.200
     2.910    46.027     0.200
     2.958    47.234     0.200
     3.338    52.219     0.200
     3.567    54.582     0.200
     3.780    58.266     0.200
     4.115    61.484     0.200
     4.400    65.520     0.200
     1.552    27.992     0.200
     1.996    33.154     0.200
     2.664    43.779     0.200
     3.032    49.449     0.200
     3.725    56.566     0.200
     3.737    58.754     0.200
     3.849    59.334     0.200
     4.155    66.182     0.200
     1.643    29.875     0.200
     1.638    29.773     0.200
     2.042    35.477     0.200
     1.948    34.664     0.200
     2.498    41.016     0.200
     2.554    41.305     0.200
     2.685    44.914     0.200
     2.803    46.109     0.200
     2.902    48.297     0.200
     3.173    51.250     0.200
     3.533    57.938     0.200
     3.898    62.062     0.200
     3.977    62.516     0.200
     3.933    63.219     0.200
     4.159    64.516     0.200
     4.213    67.422     0.200
     4.389    67.242     0.200
     4.431    67.914     0.200
     4.452    67.914     0.200
     4.773    72.617     0.200
     4.689    73.758     0.200
     4.945    75.117     0.200
     4.963    74.328     0.200
     4.963    74.617     0.200
     5.134    77.320     0.200
     5.242    80.844     0.200
     5.383    81.117     0.200
     5.409    82.016     0.200
     5.861    88.219     0.200
     1.825    34.438     0.200
     2.081    35.682     0.200
     2.081    35.839     0.200
     2.173    37.982     0.200
     2.129    35.817     0.200
     2.328    39.974     0.200
     2.385    39.850     0.200
     2.453    40.898     0.200
     2.488    43.172     0.200
     2.793    46.483     0.200
     3.038    49.700     0.200
     3.247    52.919     0.200
     3.392    53.230     0.200
     3.410    54.367     0.200
     3.454    56.589     0.200
     3.496    55.089     0.200
     3.632    58.149     0.200
     3.753    60.257     0.200
     3.862    61.997     0.200
     4.433    66.999     0.200
     4.453    67.397     0.200
     4.476    67.600     0.200
     4.497    68.268     0.200
     4.523    71.739     0.200
     4.548    69.777     0.200
     4.632    70.688     0.200
     4.793    72.667     0.200
     4.793    72.799     0.200
     4.805    72.799     0.200
     4.831    72.749     0.200
     4.831    73.600     0.200
     4.934    74.899     0.200
     4.972    78.459     0.200
     5.052    76.999     0.200
     5.074    76.600     0.200
     5.418    81.699     0.200
     5.573    83.499     0.200
     5.573    82.969     0.200
     5.792    89.771     0.200
     6.018    89.447     0.200
     6.178    91.987     0.200
     6.204    92.199     0.200
     6.447    96.600     0.200
     6.581    97.180     0.200
     6.615    97.799     0.200
     6.725    99.600     0.200
     7.103   104.699     0.200
     7.162   104.899     0.200
     7.545   110.399     0.200
     7.627   112.579     0.200
     7.795   113.640     0.200
     7.795   113.799     0.200
     8.147   118.999     0.200
     8.378   122.100     0.200
     8.512   123.757     0.200
     8.520   123.899     0.200
     8.677   126.044     0.200
     8.818   128.299     0.200
     1.473    27.102     0.200
     2.692    43.614     0.200
     2.969    48.302     0.200
     3.059    49.902     0.200
     3.552    56.293     0.200
     3.597    58.312     0.200
     3.721    60.624     0.200
     3.796    59.154     0.200
     3.845    60.132     0.200
     3.816    62.233     0.200
     3.936    59.645     0.200
     4.089    64.039     0.200
     1.497    26.598     0.200
     1.555    27.516     0.200
     1.858    31.629     0.200
     2.028    34.625     0.200
     2.675    42.887     0.200
     2.968    47.992     0.200
     2.971    47.551     0.200
     3.043    48.418     0.200
     3.354    54.137     0.200
     3.707    58.809     0.200
     3.713    56.906     0.200
     3.831    57.598     0.200
     1.812    34.438     0.200
     2.109    38.102     0.200
     2.107    35.812     0.200
     2.161    39.945     0.200
     2.404    40.328     0.200
     2.785    45.406     0.200
     3.041    48.867     0.200
     3.405    51.938     0.200
     3.445    55.719     0.200
     3.500    55.031     0.200
     3.752    61.148     0.200
     3.866    62.062     0.200
     4.461    67.984     0.200
     4.503    67.281     0.200
     4.523    68.406     0.200
     4.564    69.562     0.200
     4.645    71.422     0.200
     4.823    72.984     0.200
     4.832    72.883     0.200
     4.860    72.883     0.200
     5.081    76.281     0.200
     5.445    80.984     0.200
     5.599    82.883     0.200
     6.151    90.484     0.200
     6.227    92.281     0.200
     2.733    46.172     0.200
     3.342    52.098     0.200
     3.391    54.695     0.200
     4.473    68.078     0.200
     4.518    68.377     0.200
     4.541    68.547     0.200
     4.603    69.898     0.200
     4.866    72.979     0.200
     5.089    76.877     0.200
     5.458    81.377     0.200
     6.254    91.877     0.200
     1.906    32.543     0.200
     2.151    37.514     0.200
     2.588    42.869     0.200
     2.902    48.058     0.200
     2.902    48.853     0.200
     3.386    52.303     0.200
     3.478    53.663     0.200
     3.604    57.019     0.200
     3.827    59.951     0.200
     3.846    60.837     0.200
     4.459    69.513     0.200
     4.793    73.411     0.200
     4.824    73.891     0.200
     4.898    73.554     0.200
     4.958    74.829     0.200
     5.037    74.693     0.200
     5.040    74.861     0.200
     5.050    74.893     0.200
     5.050    74.692     0.200
     5.388    80.293     0.200
     5.464    81.313     0.200
     5.464    81.493     0.200
     5.479    81.173     0.200
     5.479    81.693     0.200
     5.591    84.263     0.200
     5.616    83.293     0.200
     5.639    83.013     0.200
     5.689    83.893     0.200
     6.004    87.993     0.200
     6.097    89.493     0.200
     6.150    91.331     0.200
     6.208    91.493     0.200
     6.633    97.393     0.200
     6.636    97.293     0.200
     7.033   103.093     0.200
     7.251   105.793     0.200
     7.564   110.893     0.200
     7.961   116.293     0.200
     2.730    45.543     0.200
     3.319    52.652     0.200
     5.427    80.262     0.200
     5.525    81.762     0.200
     5.600    82.949     0.200
     5.705    84.027     0.200
     5.821    86.062     0.200
     5.944    87.859     0.200
     5.976    88.590     0.200
     6.143    90.641     0.200
     6.405    93.762     0.200
     6.580    99.301     0.200
     6.672    97.961     0.200
     7.233   105.160     0.200
     7.431   108.461     0.200
     7.848   114.160     0.200
     3.811    56.512     0.200
     3.847    57.191     0.200
     3.860    58.137     0.200
     4.069    61.078     0.200
     4.133    61.934     0.200
     4.133    61.512     0.200
     4.239    63.680     0.200
     4.358    65.613     0.200
     4.385    64.371     0.200
     4.742    69.512     0.200
     4.927    72.012     0.200
     5.117    75.113     0.200
     5.484    79.512     0.200
     5.607    81.812     0.200
     2.051    35.293     0.200
     3.561    55.416     0.200
     4.471    67.162     0.200
     4.517    67.662     0.200
     4.503    67.145     0.200
     4.540    68.264     0.200
     4.606    70.012     0.200
     4.694    71.246     0.200
     4.824    72.164     0.200
     4.824    72.363     0.200
     4.864    73.363     0.200
     5.087    76.764     0.200
     5.096    75.523     0.200
     5.096    76.863     0.200
     5.457    81.764     0.200
     5.617    83.363     0.200
     5.784    85.463     0.200
     6.171    90.662     0.200
     6.254    92.062     0.200
     6.638    97.082     0.200
     2.302    39.070     0.200
     2.854    47.781     0.200
     3.409    54.414     0.200
     3.775    57.234     0.200
     3.853    58.961     0.200
     4.046    61.613     0.200
     4.310    65.434     0.200
     4.413    68.211     0.200
     4.735    70.895     0.200
     4.800    71.695     0.200
     4.797    71.633     0.200
     4.843    72.652     0.200
     4.859    72.570     0.200
     5.028    74.855     0.200
     5.088    75.445     0.200
     5.118    76.195     0.200
     5.075    77.594     0.200
     5.146    76.793     0.200
     5.319    78.895     0.200
     5.328    79.293     0.200
     5.369    79.414     0.200
     5.414    80.195     0.200
     5.528    84.973     0.200
     5.723    84.395     0.200
     5.803    86.242     0.200
     5.923    87.492     0.200
     5.923    87.125     0.200
     6.118    89.992     0.200
     6.118    89.891     0.200
     6.350    95.254     0.200
     6.482    94.895     0.200
     6.534    95.461     0.200
     6.534    96.016     0.200
     6.607    96.992     0.200
     6.703    97.969     0.200
     6.748    98.480     0.200
     6.748    99.492     0.200
     7.021   102.594     0.200
     7.043   102.613     0.200
     7.067   103.293     0.200
     7.471   108.492     0.200
     7.574   110.293     0.200
     7.640   110.922     0.200
     7.949   115.594     0.200
     8.175   118.773     0.200
     8.234   119.402     0.200
     8.453   122.395     0.200
     8.516   122.895     0.200
     8.563   123.895     0.200
     8.830   127.094     0.200
     8.933   128.895     0.200
     8.965   128.492     0.200
     9.091   130.766     0.200
     9.227   132.895     0.200
     9.495   136.613     0.200
    10.001   143.363     0.200
    10.246   146.965     0.200
    10.276   147.543     0.200
    10.320   147.633     0.200
    10.379   149.160     0.200
     2.231    38.703     0.200
     2.305    40.250     0.200
     2.567    44.625     0.200
     3.020    49.242     0.200
     3.413    55.242     0.200
     3.131    52.422     0.200
     3.252    53.938     0.200
     3.130    52.352     0.200
     3.218    52.328     0.200
     3.467    55.891     0.200
     3.468    56.742     0.200
     3.611    58.500     0.200
     4.014    64.469     0.200
     4.190    64.312     0.200
     4.430    68.172     0.200
     4.737    72.492     0.200
     4.842    74.938     0.200
     5.147    77.977     0.200
     5.012    77.891     0.200
     5.105    79.820     0.200
     5.238    79.172     0.200
     5.238    78.945     0.200
     5.304    80.195     0.200
     5.361    80.352     0.200
     5.361    80.672     0.200
     5.361    80.547     0.200
     5.387    81.000     0.200
     5.414    81.711     0.200
     5.540    83.773     0.200
     5.684    85.672     0.200
     5.636    84.398     0.200
     5.839    87.375     0.200
     5.864    88.172     0.200
     5.793    87.000     0.200
     5.768    88.180     0.200
     6.256    93.672     0.200
     6.226    94.711     0.200
     6.226    95.156     0.200
     6.380    95.172     0.200
     6.609    97.977     0.200
     6.505    99.039     0.200
     6.941   102.672     0.200
     7.141   105.852     0.200
     7.120   105.273     0.200
     7.052   106.531     0.200
     7.181   105.391     0.200
     7.360   108.023     0.200
     7.360   108.133     0.200
     7.507   111.172     0.200
     7.537   110.977     0.200
     7.625   112.125     0.200
     7.941   116.773     0.200
     8.095   119.172     0.200
     8.101   119.070     0.200
     8.459   124.477     0.200
     8.784   128.062     0.200
     8.784   128.375     0.200
     8.861   129.273     0.200
     8.978   130.570     0.200
     9.086   132.273     0.200
     9.396   136.672     0.200
     9.451   137.172     0.200
     9.531   138.453     0.200
     9.728   140.742     0.200
     9.610   139.047     0.200
    10.529   152.359     0.200
    10.859   157.086     0.200
    10.940   157.555     0.200
    10.926   158.180     0.200
    12.878   186.945     0.200
    17.916   251.469     0.200
    20.346   281.102     0.200
     2.815    45.395     0.200
     3.884    60.309     0.200
     3.752    59.408     0.200
     3.960    61.209     0.200
     4.014    60.779     0.200
     4.080    62.117     0.200
     3.847    62.035     0.200
     4.352    65.764     0.200
     4.534    68.008     0.200
     4.551    68.982     0.200
     4.872    73.408     0.200
     2.848    47.930     0.200
     2.870    46.961     0.200
     2.975    49.547     0.200
     3.008    47.930     0.200
     3.357    53.750     0.200
     3.919    60.164     0.200
     3.829    62.156     0.200
     3.976    60.039     0.200
     4.337    65.977     0.200
     4.502    69.461     0.200
     4.546    69.281     0.200
     5.068    75.586     0.200
     1.932    34.844     0.200
     2.678    45.494     0.200
     2.680    44.418     0.200
     2.721    45.332     0.200
     2.821    45.016     0.200
     2.893    48.111     0.200
     3.100    50.928     0.200
     3.156    51.166     0.200
     3.687    60.879     0.200
     3.769    61.164     0.200
     4.207    66.824     0.200
     4.312    67.820     0.200
     4.639    70.885     0.200
     4.753    72.959     0.200
     4.794    73.555     0.200
     4.794    72.344     0.200
     4.815    73.754     0.200
     5.018    75.754     0.200
     5.137    77.953     0.200
     5.747    86.055     0.200
     6.215    93.154     0.200
     6.291    93.654     0.200
     2.003    35.234     0.200
     2.724    44.633     0.200
     2.855    45.938     0.200
     2.855    47.570     0.200
     2.886    46.547     0.200
     2.592    41.000     0.200
     3.232    52.070     0.200
     3.394    54.523     0.200
     4.886    72.258     0.200
     4.963    73.461     0.200
     4.963    74.102     0.200
     5.214    76.859     0.200
     5.526    81.562     0.200
     5.523    81.859     0.200
     5.873    86.461     0.200
     1.326    25.398     0.200
     1.353    26.539     0.200
     2.822    48.500     0.200
     3.954    60.414     0.200
     4.165    64.828     0.200
     4.297    65.789     0.200
     4.474    69.430     0.200
     4.501    68.766     0.200
     5.039    76.133     0.200
     1.420    24.922     0.200
     1.420    24.704     0.200
     2.748    43.551     0.200
     2.999    48.009     0.200
     3.817    58.275     0.200
     3.967    59.386     0.200
     3.900    62.524     0.200
     4.017    59.013     0.200
     4.072    59.745     0.200
     4.281    64.531     0.200
     4.143    62.943     0.200
     4.328    64.783     0.200
     4.473    67.031     0.200
     4.530    67.062     0.200
     4.530    67.832     0.200
     4.529    67.031     0.200
     4.519    67.802     0.200
     4.613    71.611     0.200
     5.091    74.229     0.200
     5.810    84.531     0.200
     6.307    90.793     0.200
     0.449    11.414     0.200
     0.955    18.484     0.200
     1.099    20.250     0.200
     1.079    19.367     0.200
     1.254    22.609     0.200
     1.386    24.672     0.200
     2.163    34.688     0.200
     2.555    41.164     0.200
     2.654    41.164     0.200
     2.543    40.875     0.200
     2.658    42.055     0.200
     3.476    50.305     0.200
     4.104    60.289     0.200
     4.195    61.391     0.200
     4.195    61.203     0.200
     4.407    64.414     0.200
     4.407    64.789     0.200
     4.497    66.594     0.200
     4.742    68.672     0.200
     5.087    73.492     0.200
     5.576    80.789     0.200
     6.094    87.594     0.200
     1.880    33.250     0.200
     1.880    32.969     0.200
     2.106    36.523     0.200
     2.443    41.164     0.200
     3.000    50.141     0.200
     3.017    50.086     0.200
     3.420    55.867     0.200
     3.420    55.039     0.200
     3.223    53.086     0.200
     3.641    56.109     0.200
     5.194    77.617     0.200
     5.275    78.719     0.200
     5.436    81.516     0.200
     5.436    80.484     0.200
     5.512    82.047     0.200
     5.584    83.219     0.200
     5.749    85.617     0.200
     5.846    86.719     0.200
     5.897    87.820     0.200
     6.180    91.016     0.200
     6.626    97.617     0.200
     6.875   102.117     0.200
     6.971   102.117     0.200
     7.127   104.719     0.200
     7.197   105.617     0.200
     7.543   110.219     0.200
     7.546   110.617     0.200
     8.099   118.117     0.200
     8.468   123.117     0.200
     8.774   127.719     0.200
     8.981   130.117     0.200
     9.089   131.617     0.200
     1.620    28.570     0.200
     1.749    32.016     0.200
     1.939    33.648     0.200
     2.063    35.164     0.200
     2.296    39.094     0.200
     2.447    39.523     0.200
     2.602    42.922     0.200
     2.842    46.664     0.200
     2.951    48.492     0.200
     3.002    48.781     0.200
     3.026    50.320     0.200
     3.167    50.984     0.200
     3.300    52.508     0.200
     3.252    50.211     0.200
     3.376    53.055     0.200
     3.541    54.414     0.200
     3.715    56.055     0.200
     3.722    58.391     0.200
     3.887    58.633     0.200
     4.135    62.375     0.200
     4.721    71.250     0.200
     4.890    72.766     0.200
     4.974    73.867     0.200
     4.974    73.375     0.200
     5.034    74.531     0.200
     5.102    75.242     0.200
     5.127    76.562     0.200
     5.127    76.359     0.200
     5.204    77.031     0.200
     5.204    77.266     0.200
     5.281    78.367     0.200
     5.336    78.727     0.200
     5.441    80.766     0.200
     5.470    81.992     0.200
     5.491    80.922     0.200
     5.528    81.438     0.200
     5.558    81.961     0.200
     5.598    83.062     0.200
     5.876    86.164     0.200
     6.112    89.867     0.200
     6.121    89.766     0.200
     6.333    92.461     0.200
     6.333    93.031     0.200
     6.673    97.367     0.200
     6.839    99.867     0.200
     7.057   102.000     0.200
     7.245   105.664     0.200
     7.255   105.461     0.200
     7.812   113.367     0.200
     8.179   117.766     0.200
     8.496   122.867     0.200
     8.695   125.266     0.200
     8.803   126.766     0.200
     9.104   131.062     0.200
     9.239   133.156     0.200
     1.678    28.664     0.200
     2.221    35.719     0.200
     2.442    38.273     0.200
     3.428    51.805     0.200
     3.468    52.375     0.200
     3.468    52.203     0.200
     3.797    57.406     0.200
     3.939    59.805     0.200
     4.050    60.141     0.200
     1.507    27.031     0.200
     2.205    38.312     0.200
     2.983    49.262     0.200
     3.257    52.109     0.200
     5.260    79.328     0.200
     5.350    79.887     0.200
     5.350    80.428     0.200
     5.417    80.107     0.200
     5.498    82.068     0.200
     5.653    85.928     0.200
     5.742    85.674     0.200
     5.899    88.629     0.200
     5.894    87.719     0.200
     5.951    89.328     0.200
     6.243    92.828     0.200
     6.516    96.125     0.200
     6.722    98.729     0.200
     7.232   106.629     0.200
     1.163    24.727     0.200
     1.163    23.914     0.200
     1.146    23.281     0.200
     1.239    23.836     0.200
     1.364    25.273     0.200
     1.412    25.883     0.200
     1.686    30.656     0.200
     1.731    29.000     0.200
     1.939    32.406     0.200
     2.329    38.055     0.200
     2.760    43.750     0.200
     2.906    46.672     0.200
     3.024    49.211     0.200
     3.127    49.469     0.200
     3.787    61.102     0.200
     3.889    59.523     0.200
     3.885    59.891     0.200
     3.928    61.586     0.200
     4.016    60.156     0.200
     4.016    59.766     0.200
     4.026    59.953     0.200
     4.026    60.156     0.200
     4.052    61.633     0.200
     4.365    65.555     0.200
     4.382    66.055     0.200
     4.462    67.156     0.200
     4.616    68.117     0.200
     4.616    68.961     0.200
     4.874    71.234     0.200
     4.898    72.516     0.200
     4.981    74.156     0.200
     5.075    75.461     0.200
     5.066    77.992     0.200
     5.194    77.461     0.200
     5.309    79.078     0.200
     5.616    83.055     0.200
     5.631    83.258     0.200
     6.036    88.758     0.200
     6.229    91.656     0.200
     1.767    32.277     0.200
     2.197    37.973     0.200
     2.197    38.652     0.200
     2.978    49.504     0.200
     3.262    53.590     0.200
     3.412    54.285     0.200
     3.662    59.215     0.200
     3.725    61.273     0.200
     5.333    80.676     0.200
     5.333    81.098     0.200
     5.400    80.758     0.200
     5.483    82.059     0.200
     5.538    83.875     0.200
     5.635    85.977     0.200
     5.729    85.461     0.200
     5.881    87.328     0.200
     5.881    88.176     0.200
     5.884    88.715     0.200
     5.935    89.277     0.200
     6.225    92.777     0.200
     6.501    97.332     0.200
     1.636    30.533     0.200
     1.758    33.158     0.200
     2.082    37.432     0.200
     2.516    42.516     0.200
     2.703    47.402     0.200
     2.703    46.152     0.200
     2.774    47.898     0.200
     3.084    52.604     0.200
     2.872    49.402     0.200
     2.872    47.674     0.200
     3.258    55.412     0.200
     3.258    55.086     0.200
     3.339    55.471     0.200
     3.366    55.402     0.200
     3.366    54.865     0.200
     3.555    58.553     0.200
     3.757    61.412     0.200
     3.757    61.584     0.200
     3.800    61.234     0.200
     3.868    61.316     0.200
     4.097    65.861     0.200
     4.113    66.465     0.200
     4.288    66.250     0.200
     4.545    71.203     0.200
     4.853    74.736     0.200
     4.949    76.955     0.200
     5.175    78.633     0.200
     5.137    79.848     0.200
     5.272    79.834     0.200
     5.344    81.086     0.200
     5.369    80.834     0.200
     5.369    81.779     0.200
     5.445    81.051     0.200
     5.459    82.164     0.200
     5.570    84.133     0.200
     5.699    85.734     0.200
     5.717    86.053     0.200
     5.814    87.133     0.200
     5.814    87.334     0.200
     5.891    88.334     0.200
     5.900    88.533     0.200
     5.888    88.193     0.200
     5.885    90.666     0.200
     6.155    91.834     0.200
     6.109    93.322     0.200
     6.417    95.873     0.200
     6.460    96.221     0.200
     6.463    97.092     0.200
     6.655    98.834     0.200
     6.655   100.279     0.200
     6.852   102.234     0.200
     6.931   103.533     0.200
     6.978   103.334     0.200
     7.162   106.434     0.200
     7.172   106.033     0.200
     7.178   109.285     0.200
     7.275   106.910     0.200
     7.458   109.426     0.200
     7.539   111.533     0.200
     7.589   111.834     0.200
     8.147   119.533     0.200
     8.204   120.334     0.200
     8.845   129.533     0.200
     8.973   131.012     0.200
     9.032   131.934     0.200
     9.139   133.033     0.200
     9.461   137.834     0.200
     9.596   139.256     0.200
    10.939   158.945     0.200
    11.003   159.854     0.200
    11.021   159.461     0.200
     1.525    27.500     0.200
     2.069    35.617     0.200
     2.069    36.938     0.200
     2.015    35.023     0.200
     3.418    53.617     0.200
     3.827    60.727     0.200
     3.763    60.172     0.200
     4.480    67.289     0.200
     5.017    73.406     0.200
     5.508    81.672     0.200
     5.579    82.414     0.200
     5.609    83.070     0.200
     5.672    83.359     0.200
     5.699    84.117     0.200
     5.699    84.367     0.200
     5.807    85.672     0.200
     5.939    87.867     0.200
     5.927    87.250     0.200
     6.052    89.117     0.200
     6.052    89.469     0.200
     6.084    89.422     0.200
     6.121    89.969     0.200
     6.394    93.672     0.200
     6.688    97.766     0.200
     7.214   105.766     0.200
     7.402   107.867     0.200
     7.819   113.867     0.200
     1.861    31.777     0.200
     2.013    35.902     0.200
     2.299    39.469     0.200
     2.423    39.609     0.200
     2.423    39.859     0.200
     4.405    67.773     0.200
     4.497    69.141     0.200
     4.878    73.164     0.200
     4.941    74.137     0.200
     4.941    74.000     0.200
     5.018    74.875     0.200
     5.101    76.664     0.200
     5.101    76.293     0.200
     5.269    79.387     0.200
     5.339    80.164     0.200
     5.430    80.844     0.200
     5.435    81.035     0.200
     5.435    81.527     0.200
     5.471    81.465     0.200
     5.471    81.297     0.200
     5.777    85.562     0.200
     6.753    99.262     0.200
     7.169   105.262     0.200
     7.256   105.988     0.200
     2.101    35.812     0.200
     2.101    35.008     0.200
     2.112    36.396     0.200
     2.174    38.762     0.200
     2.438    39.486     0.200
     2.793    47.162     0.200
     3.046    49.965     0.200
     3.405    53.723     0.200
     3.378    53.076     0.200
     4.489    68.305     0.200
     4.489    67.410     0.200
     4.809    72.506     0.200
     4.818    73.805     0.200
     4.846    73.305     0.200
     4.944    74.705     0.200
     5.067    76.605     0.200
     5.070    76.904     0.200
     5.070    76.256     0.200
     5.431    81.605     0.200
     5.585    83.506     0.200
     5.747    85.904     0.200
     5.747    85.023     0.200
     6.138    90.705     0.200
     6.214    92.205     0.200
     1.993    35.199     0.200
     2.443    40.656     0.200
     2.443    41.223     0.200
     2.475    42.211     0.200
     2.875    46.422     0.200
     2.919    48.430     0.200
     5.383    80.734     0.200
     5.383    79.637     0.200
     5.383    81.449     0.200
     5.865    86.234     0.200
     5.929    88.836     0.200
     5.959    88.133     0.200
     6.317    93.535     0.200
     6.665    98.633     0.200
     7.047   103.535     0.200
     1.503    28.672     0.200
     1.445    27.242     0.200
     1.445    28.758     0.200
     1.408    26.391     0.200
     1.408    26.758     0.200
     1.693    31.195     0.200
     1.619    30.375     0.200
     1.619    30.758     0.200
     1.758    33.133     0.200
     1.758    33.766     0.200
     1.982    35.539     0.200
     1.917    34.273     0.200
     1.917    34.777     0.200
     1.998    36.867     0.200
     2.056    36.199     0.200
     2.696    44.035     0.200
     2.902    48.949     0.200
     2.902    49.809     0.200
     2.973    50.094     0.200
     3.461    56.977     0.200
     3.395    55.195     0.200
     3.536    56.730     0.200
     3.544    56.789     0.200
     3.544    57.758     0.200
     3.901    62.711     0.200
     3.942    63.039     0.200
     3.948    63.199     0.200
     3.948    63.777     0.200
     4.489    67.926     0.200
     4.489    67.691     0.200
     5.057    76.988     0.200
     5.057    76.465     0.200
     5.153    78.789     0.200
     5.153    78.578     0.200
     5.330    80.090     0.200
     5.341    80.465     0.200
     5.341    81.242     0.200
     5.432    81.688     0.200
     5.432    81.223     0.200
     5.432    81.582     0.200
     5.425    82.961     0.200
     5.427    83.000     0.200
     5.505    82.488     0.200
     5.509    82.594     0.200
     5.509    82.949     0.200
     5.601    83.891     0.200
     5.623    84.070     0.200
     5.726    85.891     0.200
     5.842    87.590     0.200
     5.910    88.012     0.200
     5.910    88.367     0.200
     5.968    89.090     0.200
     5.968    88.961     0.200
     6.066    90.488     0.200
     6.066    90.301     0.200
     6.088    90.398     0.200
     6.088    90.188     0.200
     6.089    93.367     0.200
     6.307    93.590     0.200
     6.307    93.395     0.200
     6.579    97.188     0.200
     6.636    98.055     0.200
     6.636    98.172     0.200
     6.825   100.891     0.200
     6.825   100.672     0.200
     6.869   101.645     0.200
     7.140   104.988     0.200
     7.308   108.090     0.200
     7.346   108.090     0.200
     7.382   110.738     0.200
     7.474   109.078     0.200
     7.696   113.590     0.200
     7.762   113.891     0.200
     7.884   115.441     0.200
     8.322   120.590     0.200
     9.026   131.188     0.200
     9.178   133.707     0.200
     9.313   135.090     0.200
     9.644   139.891     0.200
     9.780   141.512     0.200
     9.834   142.000     0.200
     9.960   144.391     0.200
    11.220   161.445     0.200
     2.570    42.617     0.200
     2.651    43.641     0.200
     3.197    51.250     0.200
     3.477    53.633     0.200
     4.365    64.531     0.200
     4.529    67.578     0.200
     4.918    73.062     0.200
     4.918    72.797     0.200
     4.951    73.305     0.200
     5.175    75.562     0.200
     5.528    81.047     0.200
     5.528    80.820     0.200
     6.012    86.992     0.200
     6.543    94.539     0.200
     0.852    17.057     0.200
     1.036    20.402     0.200
     1.088    19.941     0.200
     1.220    22.957     0.200
     1.352    25.132     0.200
     2.454    40.062     0.200
     2.566    41.232     0.200
     3.126    48.195     0.200
     4.198    62.569     0.200
     4.292    64.169     0.200
     4.415    64.369     0.200
     4.496    65.569     0.200
     4.592    67.569     0.200
     4.735    69.069     0.200
     4.791    70.094     0.200
     4.837    70.969     0.200
     4.915    71.869     0.200
     5.180    75.269     0.200
     5.180    75.111     0.200
     5.436    78.669     0.200
     5.485    79.366     0.200
     1.695    29.602     0.200
     2.007    33.906     0.200
     2.262    38.938     0.200
     2.493    40.547     0.200
     2.435    41.562     0.200
     4.414    67.516     0.200
     4.485    67.344     0.200
     4.904    73.953     0.200
     5.036    76.078     0.200
     5.036    75.344     0.200
     5.303    78.391     0.200
     5.606    82.727     0.200
     1.606    25.133     0.200
     1.985    30.953     0.200
     1.906    30.352     0.200
     2.080    33.969     0.200
     2.857    44.953     0.200
     3.071    46.539     0.200
     2.953    44.766     0.200
     3.378    50.047     0.200
     3.378    49.109     0.200
     3.371    50.312     0.200
     4.378    64.555     0.200
     4.648    68.922     0.200
     4.648    68.672     0.200
     4.647    68.586     0.200
     4.682    69.008     0.200
     4.682    68.039     0.200
     4.789    70.664     0.200
     4.804    69.633     0.200
     4.807    69.766     0.200
     4.807    69.438     0.200
     5.144    75.164     0.200
     5.175    75.266     0.200
     5.175    75.102     0.200
     5.206    75.867     0.200
     5.224    76.461     0.200
     5.396    78.461     0.200
     5.396    77.766     0.200
     5.689    82.438     0.200
     5.760    83.266     0.200
     5.988    86.266     0.200
     6.408    92.062     0.200
     6.423    92.867     0.200
     6.699    96.180     0.200
     6.826    98.461     0.200
     7.020   101.562     0.200
     1.818    34.445     0.200
     4.173    66.875     0.200
     5.579    84.961     0.200
     5.977    90.266     0.200
     6.039    90.164     0.200
     6.398    96.562     0.200
     1.113    19.969     0.200
     1.221    22.207     0.200
     1.342    25.246     0.200
     1.735    30.145     0.200
     1.938    31.602     0.200
     2.214    36.254     0.200
     2.085    35.188     0.200
     2.702    43.539     0.200
     2.705    42.758     0.200
     2.908    44.395     0.200
     2.908    44.191     0.200
     2.971    45.117     0.200
     2.974    46.395     0.200
     2.956    47.684     0.200
     3.112    45.840     0.200
     3.104    49.113     0.200
     3.197    49.648     0.200
     3.552    53.340     0.200
     3.598    55.566     0.200
     3.900    58.020     0.200
     3.969    59.121     0.200
     3.969    59.598     0.200
     3.969    58.855     0.200
     4.018    59.957     0.200
     4.252    62.820     0.200
     4.252    62.652     0.200
     4.285    63.520     0.200
     4.311    63.781     0.200
     4.483    65.922     0.200
     4.535    67.020     0.200
     4.535    66.562     0.200
     4.524    66.223     0.200
     4.524    65.914     0.200
     4.497    65.887     0.200
     4.497    65.754     0.200
     4.582    68.875     0.200
     4.889    72.020     0.200
     5.085    73.613     0.200
     5.305    77.422     0.200
     5.305    76.824     0.200
     5.658    82.820     0.200
     5.880    84.160     0.200
     1.596    29.004     0.200
     1.899    33.779     0.200
     1.973    34.482     0.200
     1.975    34.605     0.200
     2.679    45.168     0.200
     2.679    45.510     0.200
     2.852    47.617     0.200
     3.066    47.799     0.200
     3.371    52.068     0.200
     3.854    61.309     0.200
     4.642    71.398     0.200
     4.644    71.775     0.200
     4.644    71.674     0.200
     4.680    71.273     0.200
     4.790    71.832     0.200
     4.804    72.277     0.200
     4.808    72.031     0.200
     4.808    71.773     0.200
     5.145    77.332     0.200
     5.173    77.832     0.200
     5.208    78.031     0.200
     5.226    79.432     0.200
     5.397    80.732     0.200
     5.397    79.961     0.200
     5.438    82.031     0.200
     5.549    83.324     0.200
     5.687    84.453     0.200
     5.687    83.869     0.200
     5.761    85.732     0.200
     5.865    87.131     0.200
     5.865    86.469     0.200
     5.986    88.932     0.200
     6.407    94.432     0.200
     6.421    94.732     0.200
     6.824   100.332     0.200
     7.019   103.332     0.200
     3.000    47.924     0.200
     3.905    59.763     0.200
     3.981    60.963     0.200
     4.542    68.263     0.200
     4.558    67.763     0.200
     4.893    73.363     0.200
     1.492    26.188     0.200
     1.560    26.000     0.200
     4.784    74.047     0.200
     6.204    90.453     0.200
     6.467    92.953     0.200
     6.697    97.656     0.200
     6.928   100.258     0.200
     8.191   117.852     0.200
     1.598    27.773     0.200
     4.216    62.988     0.200
     4.748    70.988     0.200
     4.877    72.488     0.200
     5.085    74.988     0.200
     6.153    89.388     0.200
     1.321    23.807     0.200
     2.446    39.490     0.200
     2.611    41.906     0.200
     3.330    49.768     0.200
     4.232    63.600     0.200
     4.314    64.928     0.200
     4.403    65.898     0.200
     4.524    67.898     0.200
     4.644    69.600     0.200
     4.766    71.498     0.200
     4.821    71.982     0.200
     4.887    73.199     0.200
     5.104    75.398     0.200
     5.461    80.611     0.200
     5.941    87.600     0.200
     1.489    25.734     0.200
     1.825    30.586     0.200
     2.348    39.070     0.200
     2.391    38.414     0.200
     3.064    48.539     0.200
     3.586    56.141     0.200
     5.832    87.281     0.200
     1.728    31.309     0.200
     1.979    34.168     0.200
     1.979    34.375     0.200
     2.251    38.609     0.200
     2.434    41.484     0.200
     2.530    43.621     0.200
     2.683    43.953     0.200
     2.808    44.852     0.200
     2.779    46.004     0.200
     2.898    47.336     0.200
     2.859    47.117     0.200
     2.966    48.434     0.200
     2.913    47.562     0.200
     3.454    53.980     0.200
     3.339    53.953     0.200
     3.561    55.590     0.200
     3.767    58.453     0.200
     4.036    62.102     0.200
     4.036    62.297     0.200
     4.174    64.539     0.200
     4.281    67.055     0.200
     4.402    68.453     0.200
     4.832    72.125     0.200
     4.892    73.223     0.200
     4.929    73.508     0.200
     4.929    73.867     0.200
     4.928    73.828     0.200
     4.928    74.090     0.200
     5.068    75.918     0.200
     5.068    76.371     0.200
     5.139    76.223     0.200
     5.169    78.227     0.200
     5.194    77.324     0.200
     5.213    77.723     0.200
     5.401    80.422     0.200
     5.423    80.723     0.200
     5.464    80.922     0.200
     5.820    86.422     0.200
     5.903    88.680     0.200
     5.950    88.043     0.200
     6.009    89.023     0.200
     6.009    88.273     0.200
     6.195    91.422     0.200
     6.195    91.246     0.200
     6.317    95.637     0.200
     6.566    96.223     0.200
     6.555    96.738     0.200
     7.091   103.824     0.200
     7.092   103.625     0.200
     8.167   120.238     0.200
     8.293   120.324     0.200
     8.630   124.824     0.200
     2.375    39.770     0.200
     3.027    51.184     0.200
     3.576    57.832     0.200
     5.572    83.492     0.200
     5.572    83.293     0.200
     6.085    90.391     0.200
     6.496    96.891     0.200
     1.771    31.445     0.200
     2.451    41.043     0.200
     2.583    43.691     0.200
     3.763    57.422     0.200
     3.813    58.023     0.200
     3.914    61.949     0.200
     4.024    62.711     0.200
     4.025    62.293     0.200
     4.152    64.422     0.200
     4.181    64.941     0.200
     4.311    66.223     0.200
     4.375    68.121     0.200
     4.390    67.523     0.200
     5.104    77.723     0.200
     5.479    82.820     0.200
     5.588    84.121     0.200
     1.911    31.422     0.200
     1.981    33.766     0.200
     2.137    34.938     0.200
     2.337    38.473     0.200
     2.761    44.477     0.200
     2.827    43.895     0.200
     2.876    45.387     0.200
     2.876    46.137     0.200
     2.932    44.758     0.200
     3.121    47.566     0.200
     3.196    49.641     0.200
     3.689    54.848     0.200
     3.789    56.809     0.200
     3.969    59.832     0.200
     3.969    60.238     0.200
     4.052    60.934     0.200
     4.052    60.641     0.200
     4.152    62.656     0.200
     4.198    62.402     0.200
     4.293    63.832     0.200
     4.359    65.633     0.200
     4.359    65.520     0.200
     4.491    67.188     0.200
     4.528    67.332     0.200
     4.607    68.832     0.200
     4.607    68.723     0.200
     4.647    69.230     0.200
     4.647    68.965     0.200
     4.700    69.242     0.200
     4.700    69.355     0.200
     4.818    72.926     0.200
     4.955    73.230     0.200
     5.214    76.559     0.200
     5.513    81.090     0.200
     5.751    83.832     0.200
     5.928    86.230     0.200
     6.079    88.035     0.200
     6.454    93.414     0.200
     7.181   103.910     0.200
     7.598   109.633     0.200
     1.439    25.594     0.200
     1.515    27.086     0.200
     1.545    26.930     0.200
     1.698    29.828     0.200
     1.730    29.867     0.200
     2.220    36.367     0.200
     2.579    42.273     0.200
     2.579    39.977     0.200
     2.724    43.328     0.200
     2.724    43.516     0.200
     2.814    42.938     0.200
     3.142    50.438     0.200
     3.599    56.711     0.200
     3.797    59.680     0.200
     3.801    57.836     0.200
     3.866    57.883     0.200
     3.977    63.586     0.200
     4.036    60.773     0.200
     4.036    60.297     0.200
     4.059    60.719     0.200
     4.059    60.492     0.200
     4.064    60.719     0.200
     4.363    66.625     0.200
     4.400    67.219     0.200
     4.535    69.523     0.200
     4.541    67.820     0.200
     4.650    69.320     0.200
     4.650    69.141     0.200
     4.852    75.891     0.200
     4.864    72.516     0.200
     5.015    74.320     0.200
     5.080    75.523     0.200
     5.112    77.578     0.200
     5.178    77.922     0.200
     5.597    82.922     0.200
     5.614    82.719     0.200
     5.997    88.422     0.200
     1.604    28.328     0.200
     1.628    28.451     0.200
     2.889    44.857     0.200
     2.889    44.971     0.200
     3.025    49.502     0.200
     2.987    49.452     0.200
     2.987    47.472     0.200
     2.967    47.146     0.200
     3.104    48.454     0.200
     3.104    48.709     0.200
     3.230    51.014     0.200
     3.344    55.250     0.200
     4.084    64.969     0.200
     4.431    68.780     0.200
     4.431    68.893     0.200
     4.480    69.946     0.200
     4.771    71.560     0.200
     4.771    71.697     0.200
     4.792    72.381     0.200
     4.792    72.112     0.200
     4.793    72.480     0.200
     4.793    71.861     0.200
     5.093    76.881     0.200
     5.093    76.575     0.200
     5.133    77.081     0.200
     5.133    76.979     0.200
     5.256    78.980     0.200
     5.256    78.681     0.200
     5.344    79.781     0.200
     5.383    80.581     0.200
     5.383    80.321     0.200
     5.458    81.581     0.200
     5.588    83.850     0.200
     5.748    85.480     0.200
     5.748    85.249     0.200
     5.908    88.081     0.200
     6.319    93.881     0.200
     6.348    94.480     0.200
     6.716    99.581     0.200
     6.967   102.980     0.200
     7.641   112.581     0.200
     1.646    28.891     0.200
     1.740    31.945     0.200
     1.903    33.141     0.200
     2.462    42.164     0.200
     2.705    44.406     0.200
     2.705    44.609     0.200
     3.687    57.547     0.200
     4.085    63.578     0.200
     4.085    63.008     0.200
     4.818    71.930     0.200
     4.882    73.133     0.200
     4.923    74.484     0.200
     5.091    76.461     0.200
     5.172    77.328     0.200
     5.404    80.531     0.200
     5.451    80.930     0.200
     5.451    80.750     0.200
     5.956    88.594     0.200
     6.003    88.734     0.200
     6.195    91.633     0.200
     6.682    98.328     0.200
     7.096   103.734     0.200
     2.019    34.953     0.200
     2.078    34.203     0.200
     2.291    38.336     0.200
     2.427    41.695     0.200
     2.672    43.797     0.200
     3.522    57.258     0.200
     3.699    58.227     0.200
     3.881    60.195     0.200
     3.942    60.508     0.200
     4.043    62.352     0.200
     4.336    65.797     0.200
     4.496    67.797     0.200
     4.579    70.055     0.200
     4.792    71.742     0.200
     1.990    35.305     0.200
     2.107    37.203     0.200
     2.436    41.859     0.200
     2.438    42.422     0.200
     2.494    41.531     0.200
     2.528    42.602     0.200
     2.528    42.945     0.200
     2.528    43.047     0.200
     2.521    42.859     0.200
     2.609    44.609     0.200
     2.694    46.320     0.200
     2.696    46.477     0.200
     2.778    47.008     0.200
     2.769    47.266     0.200
     2.769    47.602     0.200
     2.814    48.836     0.200
     2.822    47.102     0.200
     2.940    47.625     0.200
     3.031    49.281     0.200
     3.132    49.922     0.200
     3.229    50.797     0.200
     3.263    53.344     0.200
     3.473    55.969     0.200
     3.828    61.977     0.200
     4.029    63.562     0.200
     4.076    61.430     0.200
     4.076    61.586     0.200
     4.272    66.008     0.200
     4.272    67.141     0.200
     4.444    67.719     0.200
     4.444    67.438     0.200
     4.467    68.953     0.200
     4.503    69.289     0.200
     4.503    68.859     0.200
     4.618    70.336     0.200
     4.618    70.203     0.200
     4.633    71.883     0.200
     4.633    71.547     0.200
     4.803    74.625     0.200
     4.883    73.727     0.200
     5.120    81.898     0.200
     5.449    84.031     0.200
     5.495    81.898     0.200
     5.495    81.602     0.200
     5.548    82.383     0.200
     5.548    82.211     0.200
     5.549    82.797     0.200
     5.549    82.945     0.200
     5.579    83.125     0.200
     5.579    83.242     0.200
     5.624    83.648     0.200
     5.624    84.109     0.200
     5.673    84.938     0.200
     5.673    85.062     0.200
     5.673    85.969     0.200
     5.813    86.695     0.200
     5.813    86.859     0.200
     5.813    86.305     0.200
     5.866    87.297     0.200
     5.866    86.977     0.200
     5.873    87.398     0.200
     5.873    87.211     0.200
     5.873    88.617     0.200
     5.874    85.961     0.200
     5.874    87.016     0.200
     6.002    89.461     0.200
     6.002    89.719     0.200
     6.002    90.352     0.200
     6.028    89.297     0.200
     6.028    88.945     0.200
     6.094    90.297     0.200
     6.125    90.695     0.200
     6.125    90.266     0.200
     6.154    92.000     0.200
     6.359    95.016     0.200
     6.483    95.602     0.200
     6.483    95.469     0.200
     6.569    96.914     0.200
     6.569    96.602     0.200
     6.624   100.188     0.200
     6.657    98.195     0.200
     6.657    98.055     0.200
     6.657    98.438     0.200
     6.829   100.500     0.200
     6.829   100.852     0.200
     6.829   100.266     0.200
     6.829   101.062     0.200
     7.052   103.188     0.200
     7.052   103.789     0.200
     7.168   105.797     0.200
     7.194   104.969     0.200
     7.194   106.102     0.200
     7.196   105.820     0.200
     7.213   105.695     0.200
     7.299   107.000     0.200
     7.510   110.695     0.200
     7.510   110.477     0.200
     7.665   111.695     0.200
     7.710   112.602     0.200
     7.807   114.297     0.200
     7.883   115.953     0.200
     7.883   116.242     0.200
     8.107   119.125     0.200
     8.257   120.188     0.200
     8.257   120.586     0.200
     8.309   119.797     0.200
     8.563   125.602     0.200
     8.653   126.633     0.200
     9.599   138.742     0.200
     9.599   138.445     0.200
     9.773   141.445     0.200
    10.417   151.898     0.200
    11.105   159.016     0.200
    11.981   172.945     0.200
    12.744   179.086     0.200
    12.744   181.078     0.200
    13.151   186.930     0.200
    13.151   188.000     0.200
    13.278   187.797     0.200
    18.061   252.570     0.200
    18.050   251.711     0.200
    18.127   252.680     0.200
    18.424   256.305     0.200
    18.637   259.680     0.200
    18.871   262.398     0.200
    18.940   264.070     0.200
    18.989   263.305     0.200
    19.047   264.125     0.200
    19.100   264.719     0.200
    19.105   265.328     0.200
    19.267   267.000     0.200
    19.334   267.531     0.200
     0.453    10.877     0.200
     0.823    16.027     0.200
     0.962    18.426     0.200
     1.102    19.992     0.200
     1.102    19.693     0.200
     1.248    22.312     0.200
     1.380    24.115     0.200
     1.703    25.992     0.200
     2.163    34.658     0.200
     2.550    39.416     0.200
     2.659    41.711     0.200
     2.659    39.984     0.200
     4.111    60.229     0.200
     4.202    61.330     0.200
     4.202    61.195     0.200
     4.272    63.285     0.200
     4.336    63.430     0.200
     4.415    64.529     0.200
     4.415    64.318     0.200
     4.504    66.729     0.200
     4.652    68.529     0.200
     4.750    68.629     0.200
     4.821    69.729     0.200
     5.094    73.229     0.200
     5.391    77.932     0.200
     5.582    80.830     0.200
     5.907    85.529     0.200
     6.101    88.029     0.200
     1.531    27.445     0.200
     2.345    39.547     0.200
     2.600    44.242     0.200
     3.197    52.266     0.200
     3.297    53.891     0.200
     3.672    56.109     0.200
     3.672    55.867     0.200
     3.736    57.312     0.200
     3.736    56.508     0.200
     3.781    57.961     0.200
     3.729    57.680     0.200
     3.984    61.414     0.200
     3.879    62.055     0.200
     4.035    62.414     0.200
     4.035    61.578     0.200
     4.071    62.156     0.200
     4.118    64.344     0.200
     4.282    65.008     0.200
     4.282    64.898     0.200
     4.265    65.125     0.200
     4.305    65.133     0.200
     4.232    66.070     0.200
     4.660    70.609     0.200
     4.660    69.977     0.200
     4.842    73.344     0.200
     4.861    72.812     0.200
     4.861    72.930     0.200
     5.562    83.109     0.200
     5.978    89.211     0.200
     1.327    24.641     0.200
     1.654    28.930     0.200
     1.676    29.719     0.200
     1.676    29.828     0.200
     2.207    37.461     0.200
     2.862    47.930     0.200
     3.076    48.797     0.200
     3.076    48.695     0.200
     3.226    50.617     0.200
     3.226    50.797     0.200
     3.300    52.523     0.200
     3.695    59.242     0.200
     3.961    62.891     0.200
     4.378    68.156     0.200
     4.378    67.695     0.200
     4.409    69.055     0.200
     4.409    67.977     0.200
     4.501    68.867     0.200
     4.664    70.484     0.200
     4.679    71.086     0.200
     4.682    70.781     0.200
     4.682    70.023     0.200
     4.997    75.484     0.200
     5.022    75.281     0.200
     5.137    76.781     0.200
     5.232    79.039     0.200
     5.273    78.984     0.200
     5.273    78.312     0.200
     5.341    80.086     0.200
     5.498    82.383     0.200
     5.812    87.281     0.200
     6.230    92.484     0.200
     1.865    35.160     0.200
     2.147    38.559     0.200
     2.152    38.348     0.200
     2.233    39.730     0.200
     2.552    42.387     0.200
     2.495    42.783     0.200
     3.067    48.889     0.200
     3.184    51.762     0.200
     3.480    56.496     0.200
     3.482    57.527     0.200
     3.654    57.830     0.200
     5.402    81.514     0.200
     5.402    81.309     0.200
     5.459    82.262     0.200
     5.559    84.914     0.200
     5.559    83.828     0.200
     5.714    86.473     0.200
     5.873    89.414     0.200
     5.842    89.309     0.200
     5.973    89.314     0.200
     6.533    96.689     0.200
     7.098   105.613     0.200
     7.254   107.814     0.200
     7.670   113.113     0.200
     7.722   113.662     0.200
     1.726    32.957     0.200
     1.726    32.484     0.200
     1.863    33.992     0.200
     2.305    39.828     0.200
     2.670    45.188     0.200
     3.586    57.496     0.200
     4.482    69.445     0.200
     4.482    69.746     0.200
     5.061    77.578     0.200
     5.169    78.879     0.200
     5.169    78.477     0.200
     5.169    78.984     0.200
     5.220    79.777     0.200
     5.252    79.820     0.200
     5.252    78.699     0.200
     5.320    81.078     0.200
     5.320    80.848     0.200
     5.458    83.379     0.200
     5.562    84.578     0.200
     5.699    86.676     0.200
     5.713    86.219     0.200
     5.823    88.176     0.200
     5.823    87.727     0.200
     6.318    94.977     0.200
     6.396    95.547     0.200
     6.573    98.977     0.200
     6.878   102.277     0.200
     7.101   105.676     0.200
     7.298   107.547     0.200
     1.770    31.269     0.200
     1.770    31.490     0.200
     2.438    41.218     0.200
     2.369    39.858     0.200
     2.433    39.991     0.200
     3.292    54.411     0.200
     3.212    52.787     0.200
     3.212    49.854     0.200
     3.273    51.996     0.200
     3.439    54.308     0.200
     3.439    55.337     0.200
     3.780    58.190     0.200
     3.780    57.773     0.200
     3.830    59.190     0.200
     3.861    58.835     0.200
     3.898    62.143     0.200
     4.040    62.808     0.200
     4.040    62.523     0.200
     4.129    64.190     0.200
     4.129    64.489     0.200
     4.168    64.790     0.200
     4.282    66.883     0.200
     4.196    64.175     0.200
     4.196    63.615     0.200
     4.328    66.790     0.200
     4.328    66.690     0.200
     4.392    67.990     0.200
     4.407    67.090     0.200
     4.879    73.662     0.200
     4.940    74.990     0.200
     5.122    77.790     0.200
     5.122    78.553     0.200
     5.496    82.890     0.200
     5.605    84.390     0.200
     5.582    82.730     0.200
     6.045    90.033     0.200
     1.537    28.259     0.200
     2.342    41.274     0.200
     2.333    39.199     0.200
     2.865    47.351     0.200
     3.185    52.598     0.200
     3.306    54.282     0.200
     3.693    56.715     0.200
     3.757    58.615     0.200
     3.801    59.605     0.200
     4.057    63.715     0.200
     4.057    63.515     0.200
     4.086    63.688     0.200
     4.278    67.175     0.200
     4.301    66.615     0.200
     4.212    65.285     0.200
     4.861    73.651     0.200
     1.348    25.315     0.200
     1.848    33.124     0.200
     2.694    45.052     0.200
     2.811    47.312     0.200
     3.033    50.579     0.200
     3.070    49.430     0.200
     3.613    58.541     0.200
     3.749    58.964     0.200
     3.876    60.423     0.200
     3.847    61.464     0.200
     3.952    61.853     0.200
     3.952    61.720     0.200
     4.215    64.573     0.200
     4.448    68.193     0.200
     4.513    69.203     0.200
     4.527    69.183     0.200
     1.052    20.109     0.200
     1.375    24.812     0.200
     1.511    24.258     0.200
     1.507    26.508     0.200
     2.421    38.703     0.200
     2.430    36.539     0.200
     2.527    38.758     0.200
     3.221    46.906     0.200
     3.327    50.180     0.200
     4.207    61.781     0.200
     4.311    63.305     0.200
     4.311    62.891     0.200
     4.253    62.977     0.200
     4.392    64.492     0.200
     4.392    64.781     0.200
     4.603    67.781     0.200
     4.723    69.531     0.200
     4.845    70.555     0.200
     4.845    71.258     0.200
     4.964    72.992     0.200
     4.964    72.359     0.200
     5.459    80.031     0.200
     5.537    80.117     0.200
     5.537    79.461     0.200
     5.954    86.289     0.200
     6.020    87.352     0.200
     6.240    89.859     0.200
     2.329    38.395     0.200
     4.228    62.469     0.200
     4.228    61.426     0.200
     4.305    63.137     0.200
     4.305    63.434     0.200
     4.326    63.449     0.200
     4.326    62.352     0.200
     4.412    64.727     0.200
     4.523    66.586     0.200
     4.652    68.469     0.200
     4.766    69.727     0.200
     4.766    70.469     0.200
     4.784    71.000     0.200
     4.871    72.129     0.200
     4.871    71.352     0.200
     5.019    74.266     0.200
     5.019    74.664     0.200
     5.444    79.195     0.200
     5.444    79.359     0.200
     5.845    85.930     0.200
     5.936    86.520     0.200
     6.149    89.086     0.200
     1.306    24.312     0.200
     1.400    26.070     0.200
     1.532    27.805     0.200
     1.995    35.312     0.200
     1.974    33.938     0.200
     2.401    41.031     0.200
     2.482    39.062     0.200
     2.482    39.320     0.200
     2.585    41.898     0.200
     2.770    44.359     0.200
     3.264    47.000     0.200
     3.223    49.305     0.200
     3.602    55.930     0.200
     4.150    61.883     0.200
     4.253    63.578     0.200
     4.253    62.992     0.200
     4.209    62.789     0.200
     4.336    64.594     0.200
     4.336    64.203     0.200
     4.334    64.203     0.200
     4.426    65.734     0.200
     4.426    66.031     0.200
     4.545    67.625     0.200
     4.545    67.039     0.200
     4.667    69.641     0.200
     4.788    70.680     0.200
     4.788    71.031     0.200
     4.833    72.289     0.200
     4.884    72.062     0.200
     4.905    72.844     0.200
     4.905    72.094     0.200
     5.074    75.125     0.200
     5.401    79.289     0.200
     5.479    79.977     0.200
     5.962    86.922     0.200
     6.182    90.141     0.200
     6.599    96.148     0.200
     1.828    32.910     0.200
     1.828    33.336     0.200
     2.018    35.191     0.200
     2.247    40.473     0.200
     2.492    42.188     0.200
     2.492    41.805     0.200
     2.762    46.266     0.200
     2.683    44.363     0.200
     2.683    43.840     0.200
     3.146    52.016     0.200
     3.494    56.688     0.200
     3.481    54.941     0.200
     3.792    60.102     0.200
     4.925    74.336     0.200
     4.997    75.453     0.200
     5.046    76.266     0.200
     5.046    75.941     0.200
     5.080    76.375     0.200
     5.266    79.391     0.200
     5.266    78.789     0.200
     5.311    80.266     0.200
     5.391    80.918     0.200
     5.496    83.484     0.200
     5.545    83.363     0.200
     5.561    83.645     0.200
     6.102    90.750     0.200
     6.102    90.504     0.200
     6.330    94.055     0.200
     6.686    98.953     0.200
     6.825   101.023     0.200
     7.240   106.734     0.200
     1.988    34.252     0.200
     1.958    35.408     0.200
     2.380    40.652     0.200
     2.511    40.945     0.200
     2.401    40.484     0.200
     2.486    41.004     0.200
     2.486    40.639     0.200
     2.576    42.523     0.200
     2.755    46.115     0.200
     3.207    49.523     0.200
     3.216    51.254     0.200
     3.295    53.186     0.200
     3.274    49.201     0.200
     3.362    53.793     0.200
     4.160    63.996     0.200
     4.199    64.461     0.200
     4.199    65.537     0.200
     4.262    65.188     0.200
     4.262    65.086     0.200
     4.341    66.428     0.200
     4.341    67.074     0.200
     4.350    66.506     0.200
     4.439    67.666     0.200
     4.439    67.947     0.200
     4.479    68.160     0.200
     4.555    69.697     0.200
     4.555    69.467     0.200
     4.679    71.486     0.200
     4.798    72.756     0.200
     4.798    72.867     0.200
     4.833    74.018     0.200
     4.892    74.016     0.200
     4.911    74.727     0.200
     5.071    77.176     0.200
     5.096    77.771     0.200
     5.225    80.859     0.200
     5.410    81.557     0.200
     5.485    82.105     0.200
     5.898    88.875     0.200
     5.971    89.076     0.200
     6.142    92.127     0.200
     6.142    91.889     0.200
     6.188    92.156     0.200
     6.444    95.354     0.200
     6.605    97.996     0.200
     7.165   105.877     0.200
     7.882   115.846     0.200
     8.156   119.047     0.200
     8.253   120.461     0.200
     0.294     8.992     0.200
     0.874    16.625     0.200
     1.334    22.477     0.200
     1.409    24.961     0.200
     1.506    25.469     0.200
     1.540    26.547     0.200
     1.534    23.664     0.200
     2.032    33.109     0.200
     1.960    31.531     0.200
     2.431    37.953     0.200
     2.366    36.820     0.200
     2.552    39.758     0.200
     2.445    38.492     0.200
     2.445    36.789     0.200
     2.759    43.641     0.200
     2.806    43.711     0.200
     3.270    49.594     0.200
     3.226    46.148     0.200
     3.195    47.758     0.200
     3.413    51.758     0.200
     3.626    54.734     0.200
     3.626    52.867     0.200
     3.633    54.953     0.200
     3.724    55.391     0.200
     4.175    61.070     0.200
     4.279    62.648     0.200
     4.246    61.906     0.200
     4.246    62.031     0.200
     4.265    63.719     0.200
     4.265    63.930     0.200
     4.357    63.945     0.200
     4.357    63.555     0.200
     4.361    63.836     0.200
     4.361    64.219     0.200
     4.448    65.031     0.200
     4.448    65.234     0.200
     4.505    65.680     0.200
     4.571    67.000     0.200
     4.571    66.891     0.200
     4.611    67.875     0.200
     4.618    67.844     0.200
     4.618    67.062     0.200
     4.689    68.875     0.200
     4.813    69.922     0.200
     4.813    70.250     0.200
     4.868    71.055     0.200
     4.868    71.578     0.200
     4.868    71.336     0.200
     4.910    71.320     0.200
     4.936    71.852     0.200
     5.110    74.664     0.200
     5.110    74.555     0.200
     5.141    74.672     0.200
     5.272    78.039     0.200
     5.428    78.953     0.200
     5.510    79.555     0.200
     5.683    82.352     0.200
     5.940    86.195     0.200
     5.989    86.109     0.200
     6.153    88.992     0.200
     6.153    88.742     0.200
     6.212    89.602     0.200
     6.483    92.727     0.200
     6.541    94.578     0.200
     6.629    95.516     0.200
     6.690    95.867     0.200
     6.796    97.562     0.200
     7.580   108.250     0.200
     7.909   112.703     0.200
     8.179   116.141     0.200
     8.296   117.898     0.200
     1.828    30.162     0.200
     1.918    32.604     0.200
     2.099    35.136     0.200
     3.217    52.629     0.200
     3.687    58.903     0.200
     3.799    60.156     0.200
     4.177    63.889     0.200
     4.243    63.776     0.200
     4.241    63.113     0.200
     4.577    68.563     0.200
     4.636    69.523     0.200
     4.618    71.336     0.200
     4.632    69.634     0.200
     4.650    69.134     0.200
     4.829    72.104     0.200
     4.863    72.573     0.200
     4.942    74.870     0.200
     5.161    76.383     0.200
     5.310    78.523     0.200
     5.446    80.924     0.200
     5.856    85.964     0.200
     5.894    86.113     0.200
     6.299    92.174     0.200
     1.462    26.297     0.200
     1.663    29.656     0.200
     2.033    36.656     0.200
     2.338    39.727     0.200
     2.395    38.383     0.200
     2.395    39.320     0.200
     2.549    41.531     0.200
     2.909    46.875     0.200
     3.145    47.914     0.200
     3.212    50.953     0.200
     3.656    56.969     0.200
     3.756    59.984     0.200
     4.151    62.844     0.200
     4.261    63.906     0.200
     4.261    64.133     0.200
     4.350    65.414     0.200
     4.326    65.180     0.200
     4.513    68.031     0.200
     4.547    68.781     0.200
     4.650    69.758     0.200
     4.787    72.023     0.200
     4.903    73.289     0.200
     4.903    73.164     0.200
     4.936    73.914     0.200
     4.936    73.703     0.200
     5.161    77.203     0.200
     5.161    77.039     0.200
     5.349    80.914     0.200
     5.411    80.633     0.200
     5.512    81.172     0.200
     5.512    81.531     0.200
     5.675    85.359     0.200
     5.919    84.109     0.200
     5.971    88.078     0.200
     5.998    88.359     0.200
     6.209    90.914     0.200
     6.477    95.289     0.200
     6.528    95.000     0.200
     6.815    99.953     0.200
     1.304    24.402     0.200
     2.018    33.844     0.200
     2.863    46.852     0.200
     4.032    62.152     0.200
     4.230    64.453     0.200
     4.285    66.035     0.200
     4.387    66.227     0.200
     4.557    68.715     0.200
     4.592    69.078     0.200
     5.404    80.574     0.200
     5.692    81.004     0.200
     5.839    87.363     0.200
     1.677    31.055     0.200
     1.677    30.836     0.200
     1.889    33.727     0.200
     1.889    34.492     0.200
     1.889    34.344     0.200
     1.999    34.836     0.200
     1.999    34.664     0.200
     2.302    39.992     0.200
     2.047    36.336     0.200
     2.047    36.102     0.200
     2.047    37.664     0.200
     2.279    38.625     0.200
     2.461    40.852     0.200
     2.461    41.234     0.200
     2.554    43.297     0.200
     2.554    43.156     0.200
     2.861    47.273     0.200
     2.985    48.266     0.200
     2.985    49.680     0.200
     2.998    48.727     0.200
     3.213    51.734     0.200
     3.303    53.234     0.200
     3.366    54.016     0.200
     3.260    51.602     0.200
     3.260    52.664     0.200
     3.663    58.602     0.200
     3.663    59.664     0.200
     4.466    68.062     0.200
     4.574    71.188     0.200
     4.956    74.773     0.200
     5.039    75.836     0.200
     5.039    76.227     0.200
     5.097    76.805     0.200
     5.159    77.117     0.200
     5.197    78.352     0.200
     5.197    79.148     0.200
     5.273    79.203     0.200
     5.273    79.367     0.200
     5.384    81.180     0.200
     5.346    80.469     0.200
     5.497    84.922     0.200
     5.532    83.055     0.200
     5.509    82.812     0.200
     5.594    83.453     0.200
     5.594    83.648     0.200
     5.617    83.875     0.200
     5.662    84.828     0.200
     6.179    91.484     0.200
     6.175    92.172     0.200
     6.297    93.664     0.200
     6.394    94.898     0.200
     6.394    94.688     0.200
     6.781   102.719     0.200
     6.497    96.344     0.200
     6.736    99.227     0.200
     6.749    95.664     0.200
     6.919   101.164     0.200
     6.898   101.844     0.200
     6.959   102.977     0.200
     7.096   103.867     0.200
     7.223   106.586     0.200
     7.314   107.688     0.200
     7.309   107.789     0.200
     7.382   107.719     0.200
     7.870   115.352     0.200
     8.239   120.914     0.200
     8.551   124.703     0.200
     8.591   124.266     0.200
     8.862   129.062     0.200
     9.158   132.672     0.200
     9.228   133.242     0.200
     9.293   135.500     0.200
     1.699    31.539     0.200
     1.984    35.203     0.200
     1.905    34.680     0.200
     1.905    35.055     0.200
     2.053    37.055     0.200
     2.281    39.305     0.200
     2.299    40.188     0.200
     2.299    41.172     0.200
     2.457    41.570     0.200
     2.457    42.055     0.200
     2.569    43.695     0.200
     2.569    44.055     0.200
     2.569    45.055     0.200
     2.854    47.914     0.200
     2.983    49.602     0.200
     2.989    48.633     0.200
     2.989    51.055     0.200
     3.258    52.359     0.200
     3.301    54.109     0.200
     3.368    54.609     0.200
     3.680    59.445     0.200
     3.680    60.062     0.200
     4.170    64.859     0.200
     4.435    66.672     0.200
     4.456    68.828     0.200
     4.563    70.156     0.200
     4.936    75.328     0.200
     5.018    76.492     0.200
     5.018    77.133     0.200
     5.077    77.438     0.200
     5.141    78.102     0.200
     5.251    79.703     0.200
     5.251    79.938     0.200
     5.326    81.148     0.200
     5.369    81.273     0.200
     5.405    82.242     0.200
     5.488    83.508     0.200
     5.488    84.359     0.200
     5.518    83.312     0.200
     5.573    84.023     0.200
     5.573    84.242     0.200
     5.598    84.383     0.200
     5.642    85.734     0.200
     6.161    92.297     0.200
     6.285    94.438     0.200
     6.375    95.742     0.200
     6.375    96.070     0.200
     6.495    96.203     0.200
     6.716    99.953     0.200
     6.775   102.414     0.200
     6.880   102.453     0.200
     6.906   101.891     0.200
     6.938   103.469     0.200
     7.083   104.953     0.200
     7.203   107.133     0.200
     7.289   108.195     0.200
     7.295   108.156     0.200
     7.365   108.602     0.200
     7.852   115.734     0.200
     8.379   121.906     0.200
     8.533   125.438     0.200
     8.581   124.602     0.200
     8.735   127.938     0.200
     8.843   129.625     0.200
     9.141   133.648     0.200
     9.368   135.875     0.200
     1.871    31.889     0.200
     2.018    33.047     0.200
     2.218    36.562     0.200
     2.133    36.482     0.200
     2.657    41.992     0.200
     2.838    45.467     0.200
     2.870    46.314     0.200
     2.910    45.666     0.200
     2.986    46.432     0.200
     3.671    54.719     0.200
     3.916    58.521     0.200
     3.993    59.316     0.200
     4.048    61.143     0.200
     4.048    61.535     0.200
     4.117    61.984     0.200
     4.188    62.682     0.200
     4.188    64.088     0.200
     4.252    63.367     0.200
     4.304    64.576     0.200
     4.304    65.107     0.200
     4.392    65.041     0.200
     4.392    65.254     0.200
     4.485    67.447     0.200
     4.553    67.316     0.200
     4.571    67.688     0.200
     4.592    68.014     0.200
     5.135    75.189     0.200
     5.345    78.736     0.200
     5.401    78.945     0.200
     5.852    84.998     0.200
     7.515   109.018     0.200
     1.699    31.070     0.200
     1.875    33.496     0.200
     2.220    40.199     0.200
     2.271    38.684     0.200
     2.456    41.383     0.200
     2.539    42.516     0.200
     3.255    51.656     0.200
     3.655    58.887     0.200
     4.972    75.070     0.200
     5.054    76.211     0.200
     5.095    77.457     0.200
     5.113    77.098     0.200
     5.175    78.578     0.200
     5.289    80.980     0.200
     5.399    82.664     0.200
     5.525    83.730     0.200
     5.546    83.945     0.200
     5.610    85.070     0.200
     5.633    85.094     0.200
     6.195    92.297     0.200
     6.310    93.590     0.200
     6.752   100.121     0.200
     6.765    96.543     0.200
     6.914   102.672     0.200
     7.239   106.754     0.200
     7.397   108.484     0.200
     1.081    19.984     0.200
     1.425    25.383     0.200
     1.646    28.289     0.200
     1.687    29.070     0.200
     1.796    30.805     0.200
     2.184    34.969     0.200
     2.423    39.062     0.200
     2.515    41.391     0.200
     2.619    41.266     0.200
     2.691    44.273     0.200
     2.872    47.078     0.200
     3.397    50.445     0.200
     3.455    51.367     0.200
     3.495    52.078     0.200
     3.495    51.500     0.200
     3.528    52.367     0.200
     3.528    52.250     0.200
     3.523    54.078     0.200
     3.731    56.508     0.200
     3.569    55.102     0.200
     3.774    55.703     0.200
     3.774    56.555     0.200
     3.776    55.883     0.200
     3.776    56.008     0.200
     3.785    57.422     0.200
     3.785    57.297     0.200
     3.990    58.797     0.200
     3.999    58.766     0.200
     3.994    59.820     0.200
     3.994    59.711     0.200
     4.028    58.883     0.200
     4.028    59.359     0.200
     4.549    67.602     0.200
     4.774    70.062     0.200
     4.814    70.984     0.200
     0.942    17.457     0.200
     1.124    20.785     0.200
     1.692    28.598     0.200
     1.799    30.316     0.200
     2.652    41.488     0.200
     3.390    49.895     0.200
     3.483    52.277     0.200
     3.508    52.406     0.200
     3.564    53.547     0.200
     3.535    54.688     0.200
     3.755    55.809     0.200
     3.755    56.797     0.200
     3.972    57.953     0.200
     3.972    58.566     0.200
     3.959    57.879     0.200
     3.959    58.301     0.200
     4.020    58.395     0.200
     4.196    63.391     0.200
     4.380    64.449     0.200
     4.529    66.703     0.200
     4.529    67.047     0.200
     4.777    71.848     0.200
     5.121    74.387     0.200
     5.667    82.414     0.200
     1.901    35.256     0.200
     2.602    44.283     0.200
     2.602    43.719     0.200
     2.602    44.508     0.200
     2.594    44.070     0.200
     2.540    42.303     0.200
     2.645    43.908     0.200
     2.778    46.646     0.200
     2.778    46.758     0.200
     2.768    46.607     0.200
     2.776    45.939     0.200
     2.862    47.406     0.200
     2.864    47.459     0.200
     3.105    51.148     0.200
     3.105    51.289     0.200
     3.121    51.699     0.200
     3.064    49.398     0.200
     3.419    55.045     0.200
     3.404    55.686     0.200
     3.404    55.965     0.200
     3.445    54.857     0.200
     3.445    55.334     0.200
     3.495    54.398     0.200
     3.957    60.240     0.200
     3.957    60.439     0.200
     4.034    63.773     0.200
     4.165    65.418     0.200
     4.170    65.770     0.200
     4.170    65.629     0.200
     4.170    65.889     0.200
     4.259    65.604     0.200
     4.259    65.797     0.200
     4.316    67.498     0.200
     4.445    68.754     0.200
     4.445    68.871     0.200
     4.474    69.223     0.200
     4.474    69.930     0.200
     4.483    71.297     0.200
     4.555    69.799     0.200
     4.612    72.758     0.200
     4.613    71.787     0.200
     4.637    71.010     0.200
     4.637    71.555     0.200
     4.791    74.898     0.200
     4.921    74.896     0.200
     5.016    73.898     0.200
     5.232    82.938     0.200
     5.248    82.260     0.200
     5.296    79.799     0.200
     5.393    82.381     0.200
     5.425    83.297     0.200
     5.512    82.127     0.200
     5.529    82.385     0.200
     5.526    82.682     0.200
     5.526    83.383     0.200
     5.537    83.924     0.200
     5.537    84.143     0.200
     5.569    83.088     0.200
     5.569    82.859     0.200
     5.503    83.398     0.200
     5.585    83.230     0.200
     5.603    83.984     0.200
     5.603    83.469     0.200
     5.603    83.662     0.200
     5.742    86.420     0.200
     5.742    86.256     0.200
     5.884    87.219     0.200
     5.884    87.018     0.200
     5.884    87.418     0.200
     5.899    87.543     0.200
     5.925    87.609     0.200
     5.925    87.229     0.200
     5.925    87.498     0.200
     5.867    88.098     0.200
     6.000    88.840     0.200
     6.148    90.938     0.200
     6.151    90.949     0.200
     6.151    90.838     0.200
     6.162    90.938     0.200
     6.317    94.498     0.200
     6.383    96.902     0.200
     6.383    98.047     0.200
     6.528    96.186     0.200
     6.528    96.398     0.200
     6.658    97.992     0.200
     6.723   101.709     0.200
     6.783    99.709     0.200
     6.807    99.912     0.200
     6.807    99.738     0.200
     6.807   100.088     0.200
     6.775   100.398     0.200
     6.864   103.721     0.200
     6.906   102.357     0.200
     6.906   101.889     0.200
     6.906   103.609     0.200
     7.037   105.051     0.200
     7.037   104.299     0.200
     7.037   104.799     0.200
     7.116   108.598     0.200
     7.209   105.258     0.200
     7.286   107.668     0.200
     7.234   107.998     0.200
     7.427   111.262     0.200
     7.453   109.498     0.200
     7.542   110.264     0.200
     7.542   110.139     0.200
     7.575   111.631     0.200
     7.518   111.898     0.200
     7.659   111.789     0.200
     7.668   112.188     0.200
     7.812   113.938     0.200
     7.815   115.855     0.200
     7.815   115.592     0.200
     7.933   118.387     0.200
     7.960   117.699     0.200
     8.179   118.969     0.200
     8.209   119.738     0.200
     8.209   119.879     0.200
     8.209   119.398     0.200
     8.209   120.088     0.200
     8.220   124.250     0.200
     8.234   121.498     0.200
     8.551   124.896     0.200
     8.599   124.598     0.200
     8.816   127.809     0.200
     9.005   131.898     0.200
     9.077   131.699     0.200
     9.075   134.611     0.200
     9.106   133.469     0.200
     9.106   133.592     0.200
     9.189   133.299     0.200
     9.382   135.508     0.200
     9.367   137.598     0.200
     9.382   137.199     0.200
     9.514   137.568     0.200
     9.514   138.328     0.200
     9.565   138.359     0.200
     9.596   136.949     0.200
     9.679   142.764     0.200
     9.721   140.635     0.200
     9.677   144.199     0.200
     9.769   142.199     0.200
     9.866   142.348     0.200
     9.802   146.398     0.200
     9.967   143.959     0.200
     9.999   142.998     0.200
    10.060   149.398     0.200
    10.212   148.879     0.200
    10.310   149.898     0.200
    10.375   151.098     0.200
    10.573   153.469     0.200
    10.606   155.264     0.200
    10.711   155.018     0.200
    10.855   157.699     0.200
    10.945   158.502     0.200
    10.945   158.729     0.200
    10.945   157.195     0.200
    10.945   158.848     0.200
    10.932   157.654     0.200
    10.972   157.178     0.200
    10.994   159.852     0.200
    11.302   165.000     0.200
    11.302   164.148     0.200
    11.392   163.822     0.200
    11.644   168.348     0.200
    11.644   168.699     0.200
    12.946   185.719     0.200
    12.946   185.869     0.200
    12.946   186.059     0.200
    13.039   183.469     0.200
    13.039   183.148     0.200
    13.039   183.299     0.200
    14.338   203.969     0.200
    15.010   212.629     0.200
    15.010   214.438     0.200
    15.637   221.898     0.200
    15.992   228.762     0.200
    16.592   234.889     0.200
    16.988   240.098     0.200
    17.045   241.039     0.200
    17.298   243.488     0.200
    17.298   243.699     0.200
    17.835   250.498     0.200
    18.150   253.904     0.200
    18.150   254.119     0.200
    18.318   255.639     0.200
    18.318   255.934     0.200
    18.346   256.111     0.200
    18.693   260.996     0.200
    18.693   260.479     0.200
    19.032   264.629     0.200
    19.196   268.029     0.200
    19.228   268.539     0.200
    19.260   267.438     0.200
    19.251   267.498     0.200
    19.379   269.379     0.200
    19.379   270.139     0.200
    19.489   271.768     0.200
    19.825   275.398     0.200
    19.904   275.488     0.200
    20.210   278.539     0.200
    20.216   278.088     0.200
    20.668   284.098     0.200
    20.668   284.449     0.200
    20.842   285.338     0.200
     2.098    36.199     0.200
     2.194    37.965     0.200
     2.547    42.977     0.200
     2.583    44.391     0.200
     2.770    46.586     0.200
     2.770    46.195     0.200
     2.638    44.070     0.200
     3.106    50.727     0.200
     3.106    50.613     0.200
     3.419    55.281     0.200
     3.392    55.930     0.200
     4.248    65.547     0.200
     5.516    82.297     0.200
     5.500    81.559     0.200
     5.556    82.680     0.200
     5.556    83.863     0.200
     5.514    83.133     0.200
     5.572    82.812     0.200
     5.525    83.234     0.200
     5.734    86.312     0.200
     5.872    87.309     0.200
     5.886    87.957     0.200
     5.912    87.617     0.200
     5.987    88.578     0.200
     6.135    90.719     0.200
     6.138    90.598     0.200
     6.138    90.867     0.200
     6.149    90.738     0.200
     6.515    95.852     0.200
     6.645    98.188     0.200
     6.770    99.898     0.200
     6.795   100.879     0.200
     7.196   105.520     0.200
     7.529   111.617     0.200
     7.563   110.879     0.200
     7.646   111.688     0.200
     7.655   112.137     0.200
     7.799   114.199     0.200
     8.166   119.137     0.200
     8.196   119.859     0.200
     8.586   124.238     0.200
     8.803   128.629     0.200
     9.065   131.547     0.200
     9.177   133.117     0.200
     9.552   138.289     0.200
     9.853   142.879     0.200
     2.084    37.609     0.200
     2.178    37.965     0.200
     2.171    37.516     0.200
     2.171    37.777     0.200
     2.598    43.953     0.200
     2.583    43.742     0.200
     2.646    43.664     0.200
     2.563    42.832     0.200
     2.754    46.285     0.200
     2.754    46.648     0.200
     2.758    46.430     0.200
     2.858    47.996     0.200
     2.778    45.895     0.200
     3.100    51.500     0.200
     3.181    51.500     0.200
     3.093    50.664     0.200
     3.093    50.531     0.200
     3.404    55.191     0.200
     3.942    62.340     0.200
     3.942    61.906     0.200
     4.248    67.145     0.200
     4.426    68.500     0.200
     4.462    70.102     0.200
     4.462    70.531     0.200
     4.602    71.492     0.200
     4.604    72.195     0.200
     4.633    71.008     0.200
     4.633    71.148     0.200
     5.239    81.586     0.200
     5.493    81.754     0.200
     5.506    82.262     0.200
     5.510    83.312     0.200
     5.510    83.086     0.200
     5.523    84.277     0.200
     5.547    82.598     0.200
     5.547    82.711     0.200
     5.563    82.984     0.200
     5.563    82.762     0.200
     5.602    84.219     0.200
     5.602    83.965     0.200
     5.739    86.074     0.200
     5.739    87.094     0.200
     5.861    87.031     0.200
     5.861    87.270     0.200
     5.861    88.371     0.200
     5.877    88.020     0.200
     5.902    87.238     0.200
     5.902    88.047     0.200
     5.980    88.617     0.200
     6.125    90.617     0.200
     6.129    90.309     0.200
     6.129    90.867     0.200
     6.141    91.066     0.200
     6.180    92.570     0.200
     6.378    97.426     0.200
     6.509    95.934     0.200
     6.637    97.660     0.200
     6.637    97.926     0.200
     6.761    99.438     0.200
     6.787   100.152     0.200
     6.787   100.609     0.200
     6.893   102.426     0.200
     7.188   105.297     0.200
     7.365   109.480     0.200
     7.559   111.219     0.200
     7.639   111.746     0.200
     7.649   112.086     0.200
     7.791   114.199     0.200
     8.159   119.008     0.200
     8.190   119.816     0.200
     8.580   125.148     0.200
     8.798   128.328     0.200
     9.059   131.578     0.200
     9.171   132.918     0.200
     9.497   137.621     0.200
     9.702   140.359     0.200
     9.847   142.527     0.200
     2.974    47.316     0.200
     3.186    49.621     0.200
     3.464    54.363     0.200
     3.552    55.773     0.200
     3.617    59.820     0.200
     4.032    60.441     0.200
     4.032    60.953     0.200
     4.217    65.078     0.200
     4.354    64.758     0.200
     4.354    65.336     0.200
     4.502    68.621     0.200
     4.553    69.590     0.200
     4.562    69.375     0.200
     4.562    69.250     0.200
     4.438    71.820     0.200
     4.708    72.227     0.200
     4.710    72.238     0.200
     4.747    71.199     0.200
     4.747    70.660     0.200
     4.677    72.820     0.200
     4.913    79.020     0.200
     5.063    75.219     0.200
     5.137    77.020     0.200
     5.156    77.820     0.200
     5.327    81.309     0.200
     5.347    81.152     0.200
     5.555    82.172     0.200
     5.555    82.488     0.200
     5.562    81.980     0.200
     5.562    81.465     0.200
     5.526    83.648     0.200
     5.600    82.699     0.200
     5.600    82.949     0.200
     5.600    83.320     0.200
     5.504    82.551     0.200
     5.621    82.961     0.200
     5.621    82.719     0.200
     5.412    81.621     0.200
     5.596    83.168     0.200
     5.537    83.176     0.200
     5.619    83.969     0.200
     5.624    84.121     0.200
     5.719    84.426     0.200
     5.897    87.352     0.200
     5.897    86.988     0.200
     5.897    87.559     0.200
     5.897    88.051     0.200
     5.928    87.574     0.200
     5.928    87.449     0.200
     5.942    87.121     0.200
     5.942    87.609     0.200
     5.942    87.801     0.200
     5.856    86.340     0.200
     5.856    86.008     0.200
     5.856    87.141     0.200
     6.047    88.715     0.200
     6.047    88.898     0.200
     6.167    91.000     0.200
     6.180    90.738     0.200
     6.180    91.031     0.200
     6.197    91.289     0.200
     5.982    91.418     0.200
     6.189    92.258     0.200
     6.282    93.211     0.200
     6.493    97.340     0.200
     6.493    96.812     0.200
     6.580    95.965     0.200
     6.580    95.559     0.200
     6.438   100.320     0.200
     6.696    97.797     0.200
     6.696    98.121     0.200
     6.696    98.258     0.200
     6.817    99.809     0.200
     6.853   100.016     0.200
     6.853    99.711     0.200
     6.853   100.488     0.200
     6.853   100.961     0.200
     6.991   101.824     0.200
     6.991   102.031     0.200
     6.980   103.066     0.200
     6.892   101.219     0.200
     7.125   103.379     0.200
     7.125   103.699     0.200
     7.125   104.109     0.200
     7.126   104.711     0.200
     7.248   105.488     0.200
     7.194   106.199     0.200
     7.313   107.469     0.200
     7.569   110.066     0.200
     7.569   110.621     0.200
     7.643   111.066     0.200
     7.703   111.980     0.200
     7.721   112.238     0.200
     7.628   112.719     0.200
     7.849   114.469     0.200
     7.935   116.219     0.200
     8.028   116.531     0.200
     8.223   119.320     0.200
     8.264   119.398     0.200
     8.264   119.648     0.200
     8.264   120.559     0.200
     8.327   122.797     0.200
     8.459   123.281     0.200
     8.652   124.520     0.200
     8.625   123.109     0.200
     8.878   128.051     0.200
     9.246   133.219     0.200
     9.119   135.320     0.200
     9.227   133.758     0.200
     9.580   138.484     0.200
     9.580   138.000     0.200
     9.580   137.828     0.200
     9.620   138.680     0.200
     9.480   139.020     0.200
     9.777   139.566     0.200
     9.793   142.215     0.200
     9.921   142.949     0.200
    10.134   148.578     0.200
    10.671   152.879     0.200
    10.689   155.301     0.200
    10.865   157.648     0.200
    10.998   156.793     0.200
    10.967   156.508     0.200
    11.755   168.195     0.200
    11.755   168.648     0.200
    13.066   185.758     0.200
    13.066   186.270     0.200
    13.039   185.719     0.200
    13.039   187.371     0.200
    18.820   262.223     0.200
    18.972   262.328     0.200
    19.231   265.480     0.200
    20.071   276.332     0.200
     1.866    35.732     0.200
     2.120    36.457     0.200
     2.198    38.299     0.200
     2.205    38.889     0.200
     2.538    43.381     0.200
     2.538    43.869     0.200
     2.560    44.615     0.200
     2.612    44.816     0.200
     2.795    47.707     0.200
     2.795    46.498     0.200
     3.130    51.229     0.200
     3.130    50.723     0.200
     3.131    52.326     0.200
     3.440    55.051     0.200
     4.224    65.625     0.200
     5.484    82.223     0.200
     5.495    83.744     0.200
     5.505    82.564     0.200
     5.504    82.676     0.200
     5.544    82.939     0.200
     5.559    83.254     0.200
     5.708    85.752     0.200
     5.863    87.467     0.200
     5.874    88.227     0.200
     5.903    87.660     0.200
     5.971    88.830     0.200
     5.971    89.189     0.200
     6.125    91.141     0.200
     6.126    90.660     0.200
     6.126    91.270     0.200
     6.499    96.031     0.200
     6.499    96.205     0.200
     6.632    98.377     0.200
     6.779   100.012     0.200
     6.779   101.061     0.200
     6.779   100.895     0.200
     7.182   105.611     0.200
     7.632   112.131     0.200
     7.639   112.400     0.200
     7.786   114.490     0.200
     8.180   120.111     0.200
     8.570   125.180     0.200
     8.785   128.100     0.200
     1.919    35.841     0.200
     1.919    36.196     0.200
     2.067    36.245     0.200
     2.145    37.364     0.200
     2.215    37.236     0.200
     2.610    44.836     0.200
     2.564    43.095     0.200
     2.671    44.758     0.200
     2.671    44.506     0.200
     2.737    47.622     0.200
     3.093    52.366     0.200
     3.074    50.848     0.200
     3.074    50.411     0.200
     3.388    54.448     0.200
     3.962    64.001     0.200
     4.275    67.219     0.200
     5.526    82.292     0.200
     5.535    81.708     0.200
     5.567    82.888     0.200
     5.567    82.733     0.200
     5.584    83.220     0.200
     5.897    88.088     0.200
     5.920    89.308     0.200
     6.002    88.917     0.200
     6.002    90.078     0.200
     6.149    91.178     0.200
     6.161    91.708     0.200
     6.782   100.098     0.200
     6.809   100.958     0.200
     7.209   105.658     0.200
     7.661   112.078     0.200
     7.672   112.078     0.200
     8.823   128.178     0.200
     2.063    36.057     0.200
     2.176    37.641     0.200
     2.145    37.551     0.200
     2.216    37.551     0.200
     2.612    44.357     0.200
     2.646    44.740     0.200
     2.571    42.910     0.200
     2.571    43.551     0.200
     2.672    44.211     0.200
     2.748    46.166     0.200
     2.735    45.680     0.200
     2.735    46.561     0.200
     2.752    45.580     0.200
     3.071    50.354     0.200
     3.071    49.904     0.200
     3.200    52.133     0.200
     3.200    52.561     0.200
     5.264    81.486     0.200
     5.510    81.590     0.200
     5.510    81.359     0.200
     5.520    81.805     0.200
     5.520    82.062     0.200
     5.531    82.980     0.200
     5.531    82.699     0.200
     5.546    83.371     0.200
     5.561    82.312     0.200
     5.578    82.697     0.200
     5.578    82.445     0.200
     5.765    86.404     0.200
     5.871    86.672     0.200
     5.871    86.963     0.200
     5.891    87.668     0.200
     5.913    87.271     0.200
     5.997    88.334     0.200
     6.137    90.531     0.200
     6.143    90.043     0.200
     6.143    90.771     0.200
     6.156    90.883     0.200
     6.527    95.672     0.200
     6.527    95.279     0.200
     6.653    97.361     0.200
     6.653    97.871     0.200
     6.776    99.572     0.200
     6.804   100.502     0.200
     7.204   105.133     0.200
     7.260   106.031     0.200
     7.343   108.318     0.200
     7.656   111.553     0.200
     7.667   111.762     0.200
     7.806   113.822     0.200
     8.175   118.812     0.200
     8.209   119.572     0.200
     8.598   124.893     0.200
     8.818   127.852     0.200
     9.189   132.812     0.200
     1.831    30.191     0.200
     1.831    30.340     0.200
     2.101    35.867     0.200
     2.252    38.367     0.200
     2.154    37.391     0.200
     2.170    36.793     0.200
     2.570    42.352     0.200
     2.520    41.273     0.200
     2.443    39.297     0.200
     2.748    43.680     0.200
     2.724    44.293     0.200
     3.149    49.070     0.200
     2.993    47.785     0.200
     3.264    50.281     0.200
     3.309    50.340     0.200
     3.212    49.656     0.200
     3.573    55.398     0.200
     3.649    56.305     0.200
     3.651    56.191     0.200
     3.779    58.465     0.200
     3.746    58.008     0.200
     3.739    58.137     0.200
     3.819    59.004     0.200
     4.266    66.465     0.200
     4.280    64.195     0.200
     4.670    70.770     0.200
     4.702    70.066     0.200
     4.702    68.504     0.200
     4.743    71.566     0.200
     4.743    72.406     0.200
     4.882    73.125     0.200
     4.882    73.008     0.200
     5.066    74.844     0.200
     5.066    74.738     0.200
     5.089    75.105     0.200
     5.091    74.906     0.200
     5.091    75.016     0.200
     5.259    77.898     0.200
     5.354    80.297     0.200
     5.381    79.188     0.200
     5.381    79.836     0.200
     5.430    80.246     0.200
     5.554    80.887     0.200
     5.554    81.516     0.200
     5.551    81.258     0.200
     5.551    81.828     0.200
     5.639    83.098     0.200
     5.756    84.168     0.200
     5.871    86.906     0.200
     5.871    86.617     0.200
     6.011    89.160     0.200
     6.196    91.270     0.200
     6.196    91.547     0.200
     6.264    91.559     0.200
     6.601    96.426     0.200
     6.639    96.656     0.200
     6.996   102.066     0.200
     7.052   102.785     0.200
     7.066   102.887     0.200
     7.259   105.637     0.200
     7.572   110.148     0.200
     8.066   117.195     0.200
     1.469    26.527     0.200
     1.658    29.268     0.200
     1.765    30.684     0.200
     2.241    36.244     0.200
     2.241    37.012     0.200
     2.583    41.020     0.200
     2.684    47.191     0.200
     2.762    44.328     0.200
     2.907    48.418     0.200
     3.155    51.684     0.200
     3.397    55.604     0.200
     3.699    59.750     0.200
     3.818    60.029     0.200
     3.818    60.576     0.200
     3.822    60.520     0.200
     3.822    59.475     0.200
     3.901    59.848     0.200
     3.901    60.691     0.200
     3.988    65.920     0.200
     4.100    62.846     0.200
     4.100    62.738     0.200
     4.106    63.105     0.200
     4.398    66.455     0.200
     4.398    67.436     0.200
     4.442    67.117     0.200
     4.442    67.766     0.200
     4.579    69.445     0.200
     4.579    69.666     0.200
     4.648    70.646     0.200
     4.691    70.887     0.200
     4.691    71.105     0.200
     4.777    72.406     0.200
     4.897    73.785     0.200
     4.897    74.490     0.200
     5.273    79.807     0.200
     5.630    84.775     0.200
     5.651    84.605     0.200
     6.028    90.205     0.200
     6.069    90.455     0.200
     6.270    93.557     0.200
     6.557    97.686     0.200
     6.955   102.566     0.200
     2.078    35.512     0.200
     2.148    36.152     0.200
     2.378    40.320     0.200
     2.954    47.871     0.200
     3.400    53.258     0.200
     4.168    64.961     0.200
     4.309    66.031     0.200
     5.306    78.043     0.200
     1.333    24.914     0.200
     1.623    28.724     0.200
     1.946    33.364     0.200
     2.026    34.077     0.200
     3.179    52.363     0.200
     4.234    65.958     0.200
     1.855    34.176     0.200
     1.982    36.269     0.200
     2.254    38.299     0.200
     2.955    47.022     0.200
     3.106    50.263     0.200
     3.549    56.062     0.200
     3.978    63.084     0.200
     4.087    64.953     0.200
     4.206    64.993     0.200
     4.206    66.443     0.200
     4.186    65.438     0.200
     4.186    65.844     0.200
     4.469    69.881     0.200
     4.469    69.772     0.200
     4.697    72.663     0.200
     4.765    74.764     0.200
     4.782    73.435     0.200
     4.782    72.523     0.200
     5.231    76.004     0.200
     5.258    79.924     0.200
     5.325    80.864     0.200
     5.481    82.993     0.200
     5.714    86.405     0.200
     2.255    38.789     0.200
     2.998    49.281     0.200
     5.002    77.062     0.200
     5.085    78.695     0.200
     5.663    85.805     0.200
     1.568    28.062     0.200
     1.814    31.047     0.200
     1.768    32.500     0.200
     2.176    37.828     0.200
     2.391    41.734     0.200
     2.520    43.461     0.200
     2.626    43.445     0.200
     2.626    42.859     0.200
     2.657    44.227     0.200
     2.840    47.914     0.200
     3.028    49.727     0.200
     3.028    50.320     0.200
     3.500    56.719     0.200
     4.137    63.102     0.200
     4.137    63.586     0.200
     4.169    64.203     0.200
     4.795    72.094     0.200
     4.864    73.375     0.200
     4.933    74.391     0.200
     5.111    76.289     0.200
     5.111    76.734     0.200
     5.141    76.891     0.200
     5.141    77.742     0.200
     5.180    78.383     0.200
     5.180    78.234     0.200
     5.166    78.336     0.200
     5.234    78.781     0.200
     5.373    81.562     0.200
     5.401    80.570     0.200
     5.401    81.008     0.200
     5.430    80.781     0.200
     5.955    88.281     0.200
     5.989    88.883     0.200
     5.984    89.070     0.200
     6.188    91.016     0.200
     6.441    95.422     0.200
     6.622    97.383     0.200
     6.668    97.711     0.200
     6.680    98.523     0.200
     6.806   100.195     0.200
     7.026   103.820     0.200
     7.095   104.305     0.200
     7.124   104.422     0.200
     2.085    36.633     0.200
     2.188    36.164     0.200
     2.174    37.453     0.200
     2.580    43.602     0.200
     2.575    43.422     0.200
     2.575    43.844     0.200
     2.595    44.578     0.200
     2.564    41.945     0.200
     2.644    43.852     0.200
     2.753    45.781     0.200
     2.753    45.969     0.200
     2.760    46.484     0.200
     2.781    45.789     0.200
     2.873    46.062     0.200
     2.873    46.266     0.200
     3.069    50.172     0.200
     3.100    51.180     0.200
     3.095    50.617     0.200
     3.095    50.766     0.200
     3.178    52.055     0.200
     3.383    54.336     0.200
     3.383    55.000     0.200
     3.383    55.406     0.200
     3.435    55.773     0.200
     3.405    54.859     0.200
     3.497    54.469     0.200
     3.935    62.703     0.200
     4.012    63.609     0.200
     4.113    64.109     0.200
     4.113    64.664     0.200
     4.147    64.789     0.200
     4.147    64.648     0.200
     4.147    65.320     0.200
     4.154    65.484     0.200
     4.245    65.203     0.200
     4.323    68.172     0.200
     4.423    68.352     0.200
     4.423    68.141     0.200
     4.459    69.109     0.200
     4.459    68.711     0.200
     4.557    70.867     0.200
     4.562    70.375     0.200
     4.601    72.102     0.200
     4.630    70.742     0.200
     4.798    74.172     0.200
     4.898    73.180     0.200
     4.949    75.570     0.200
     5.236    81.164     0.200
     5.217    80.039     0.200
     5.308    80.273     0.200
     5.417    84.148     0.200
     5.442    81.070     0.200
     5.490    81.750     0.200
     5.490    81.062     0.200
     5.504    81.961     0.200
     5.504    82.148     0.200
     5.507    82.688     0.200
     5.520    83.539     0.200
     5.520    84.391     0.200
     5.510    83.875     0.200
     5.544    82.281     0.200
     5.544    82.641     0.200
     5.561    82.750     0.200
     5.599    83.805     0.200
     5.599    83.062     0.200
     5.599    84.039     0.200
     5.737    86.117     0.200
     5.737    86.695     0.200
     5.858    86.922     0.200
     5.858    87.359     0.200
     5.858    87.609     0.200
     5.874    87.070     0.200
     5.874    87.242     0.200
     5.899    87.422     0.200
     5.899    87.031     0.200
     5.899    87.234     0.200
     5.880    88.875     0.200
     5.977    88.594     0.200
     5.991    90.672     0.200
     6.122    90.555     0.200
     6.126    90.562     0.200
     6.126    90.344     0.200
     6.126    90.844     0.200
     6.138    91.109     0.200
     6.147    91.469     0.200
     6.287    93.273     0.200
     6.299    94.969     0.200
     6.314    94.570     0.200
     6.326    94.969     0.200
     6.375    96.789     0.200
     6.506    95.820     0.200
     6.634    98.016     0.200
     6.634    98.211     0.200
     6.646    98.773     0.200
     6.758    99.781     0.200
     6.784    99.461     0.200
     6.784    99.125     0.200
     6.784    99.969     0.200
     6.784    99.586     0.200
     6.786   100.773     0.200
     6.784   101.570     0.200
     6.890   101.312     0.200
     6.975   103.570     0.200
     7.021   103.469     0.200
     7.021   104.570     0.200
     7.022   103.141     0.200
     7.125   105.773     0.200
     7.185   105.125     0.200
     7.239   106.391     0.200
     7.261   106.820     0.200
     7.280   106.570     0.200
     7.420   110.789     0.200
     7.462   109.070     0.200
     7.516   109.945     0.200
     7.521   111.469     0.200
     7.532   112.969     0.200
     7.529   110.469     0.200
     7.636   111.695     0.200
     7.646   111.922     0.200
     7.692   113.680     0.200
     7.788   113.930     0.200
     7.814   115.508     0.200
     7.970   116.875     0.200
     8.156   118.781     0.200
     8.187   119.164     0.200
     8.187   119.664     0.200
     8.187   119.859     0.200
     8.245   121.570     0.200
     8.521   125.969     0.200
     8.577   124.500     0.200
     8.795   127.430     0.200
     9.018   131.773     0.200
     9.056   131.344     0.200
     9.107   133.734     0.200
     9.168   133.062     0.200
     9.172   132.945     0.200
     9.362   135.328     0.200
     9.395   136.672     0.200
     9.434   137.070     0.200
     9.494   137.945     0.200
     9.543   137.984     0.200
     9.844   142.164     0.200
    10.189   147.664     0.200
    10.569   154.430     0.200
    10.674   154.430     0.200
    10.688   155.000     0.200
    10.688   154.352     0.200
    10.922   157.695     0.200
    10.922   158.039     0.200
    11.659   167.773     0.200
    11.659   168.969     0.200
    12.954   185.273     0.200
    12.954   184.781     0.200
    13.066   184.219     0.200
    13.066   183.719     0.200
    16.006   225.945     0.200
    17.164   241.453     0.200
    18.699   260.195     0.200
    18.716   259.828     0.200
    18.952   262.719     0.200
    19.034   263.883     0.200
    19.549   269.688     0.200
    19.965   274.352     0.200
     1.731    31.609     0.200
     1.953    35.289     0.200
     2.093    37.406     0.200
     2.271    37.258     0.200
     2.610    44.195     0.200
     2.640    44.727     0.200
     2.655    44.656     0.200
     2.619    42.922     0.200
     2.704    45.398     0.200
     2.675    45.672     0.200
     2.725    44.047     0.200
     2.704    45.656     0.200
     2.932    48.734     0.200
     2.947    47.805     0.200
     3.011    50.117     0.200
     3.033    50.625     0.200
     3.211    51.828     0.200
     3.211    51.984     0.200
     3.418    54.422     0.200
     3.418    54.828     0.200
     3.971    62.586     0.200
     4.038    63.094     0.200
     4.165    64.078     0.200
     4.306    65.961     0.200
     4.306    66.945     0.200
     4.456    67.836     0.200
     4.456    68.016     0.200
     4.514    69.234     0.200
     4.514    69.047     0.200
     4.599    71.258     0.200
     4.703    71.375     0.200
     4.703    70.750     0.200
     5.301    81.875     0.200
     5.514    81.492     0.200
     5.514    81.617     0.200
     5.517    81.195     0.200
     5.549    82.938     0.200
     5.549    82.812     0.200
     5.558    82.055     0.200
     5.571    82.953     0.200
     5.571    82.789     0.200
     5.578    82.336     0.200
     5.677    85.055     0.200
     5.813    86.242     0.200
     5.859    86.508     0.200
     5.859    86.406     0.200
     5.887    87.359     0.200
     5.904    86.828     0.200
     5.904    86.727     0.200
     6.003    88.016     0.200
     6.128    90.266     0.200
     6.139    89.969     0.200
     6.139    90.219     0.200
     6.155    90.430     0.200
     6.448    97.172     0.200
     6.448    97.008     0.200
     6.535    95.250     0.200
     6.535    95.578     0.200
     6.653    97.281     0.200
     6.653    97.508     0.200
     6.775    98.766     0.200
     6.809    99.500     0.200
     6.809    99.633     0.200
     7.077   102.953     0.200
     7.090   103.469     0.200
     7.205   104.727     0.200
     7.267   105.867     0.200
     7.528   109.805     0.200
     7.596   110.109     0.200
     7.660   111.125     0.200
     7.676   111.297     0.200
     7.806   113.500     0.200
     7.896   117.109     0.200
     8.179   118.523     0.200
     8.218   119.164     0.200
     8.606   124.594     0.200
     8.832   127.648     0.200
     9.088   130.898     0.200
     9.189   134.977     0.200
     9.200   132.500     0.200
     9.401   135.203     0.200
     9.876   141.875     0.200
    11.739   167.555     0.200
     1.972    35.207     0.200
     2.079    37.112     0.200
     2.291    37.170     0.200
     2.589    44.576     0.200
     2.641    44.966     0.200
     2.655    44.576     0.200
     2.668    44.765     0.200
     2.668    45.544     0.200
     2.650    45.694     0.200
     2.983    49.875     0.200
     4.307    64.354     0.200
     4.461    68.613     0.200
     4.512    70.011     0.200
     5.502    80.396     0.200
     5.502    80.618     0.200
     5.492    81.247     0.200
     5.492    81.604     0.200
     5.540    82.667     0.200
     5.537    82.084     0.200
     5.566    83.093     0.200
     5.558    82.099     0.200
     5.558    82.233     0.200
     5.824    84.654     0.200
     5.865    86.926     0.200
     5.865    87.403     0.200
     5.986    88.403     0.200
     6.104    89.934     0.200
     6.118    90.874     0.200
     6.520    94.875     0.200
     6.520    95.134     0.200
     6.634    96.721     0.200
     6.634    97.354     0.200
     6.754    99.424     0.200
     6.792    98.991     0.200
     7.081   103.458     0.200
     7.187   104.834     0.200
     7.252   106.163     0.200
     7.642   111.283     0.200
     7.661   111.733     0.200
     1.551    28.508     0.200
     1.607    28.164     0.200
     1.743    31.766     0.200
     1.712    29.016     0.200
     1.713    29.914     0.200
     2.610    43.227     0.200
     3.475    52.312     0.200
     3.528    53.188     0.200
     3.528    53.000     0.200
     3.563    53.875     0.200
     3.563    53.625     0.200
     3.462    56.125     0.200
     3.579    53.758     0.200
     3.579    54.102     0.200
     3.576    55.570     0.200
     3.576    56.188     0.200
     3.809    57.508     0.200
     3.809    57.859     0.200
     3.820    57.344     0.200
     3.820    58.594     0.200
     3.852    57.680     0.200
     3.852    57.797     0.200
     3.860    57.727     0.200
     3.860    57.961     0.200
     4.001    60.930     0.200
     4.001    61.203     0.200
     4.045    60.492     0.200
     4.083    61.523     0.200
     4.103    60.953     0.200
     4.103    61.070     0.200
     4.643    68.609     0.200
     4.643    69.531     0.200
     4.750    70.484     0.200
     4.811    72.070     0.200
     4.834    72.086     0.200
     4.834    72.547     0.200
     4.834    72.953     0.200
     5.201    76.422     0.200
     5.325    78.383     0.200
     5.673    83.094     0.200
     5.740    84.445     0.200
     5.795    84.773     0.200
     6.965   101.984     0.200
     7.284   105.453     0.200
     1.360    25.770     0.200
     2.462    43.086     0.200
     3.500    57.434     0.200
     5.271    79.406     0.200
     5.352    80.617     0.200
     5.511    83.125     0.200
     5.588    84.617     0.200
     5.661    85.207     0.200
     5.909    88.145     0.200
     5.909    89.695     0.200
     5.924    88.426     0.200
     6.488    96.984     0.200
     6.576    98.547     0.200
     7.049   103.934     0.200
     7.205   106.785     0.200
     7.620   112.387     0.200
     8.851   129.297     0.200
     2.616    42.928     0.200
     2.616    41.750     0.200
     3.463    52.764     0.200
     3.517    53.625     0.200
     3.517    53.143     0.200
     3.467    56.244     0.200
     3.552    53.688     0.200
     3.482    56.793     0.200
     3.569    54.133     0.200
     3.808    58.334     0.200
     3.802    58.273     0.200
     3.840    58.174     0.200
     3.995    61.076     0.200
     4.035    60.994     0.200
     4.092    61.205     0.200
     4.092    61.324     0.200
     4.144    65.123     0.200
     4.739    70.645     0.200
     4.806    71.705     0.200
     5.190    77.023     0.200
     5.315    79.334     0.200
     5.356    78.676     0.200
     5.663    83.535     0.200
     1.667    30.703     0.200
     1.840    34.012     0.200
     2.095    35.680     0.200
     2.112    35.891     0.200
     2.226    39.059     0.200
     2.193    38.207     0.200
     2.373    39.406     0.200
     2.403    41.609     0.200
     2.809    46.918     0.200
     3.279    52.824     0.200
     3.399    52.855     0.200
     3.478    55.113     0.200
     3.615    56.777     0.200
     4.428    67.301     0.200
     4.428    67.531     0.200
     4.443    67.402     0.200
     4.470    66.973     0.200
     4.490    67.578     0.200
     4.490    68.340     0.200
     4.505    68.934     0.200
     4.534    69.566     0.200
     4.534    68.398     0.200
     4.617    70.984     0.200
     4.617    70.367     0.200
     4.790    71.949     0.200
     4.799    72.055     0.200
     4.799    73.023     0.200
     4.827    72.023     0.200
     4.827    72.852     0.200
     4.925    73.992     0.200
     4.925    74.402     0.200
     5.048    76.223     0.200
     5.051    74.922     0.200
     5.051    75.973     0.200
     5.345    80.520     0.200
     5.566    82.000     0.200
     5.566    82.691     0.200
     5.686    84.422     0.200
     5.727    84.387     0.200
     6.003    89.375     0.200
     6.087    89.719     0.200
     6.118    90.492     0.200
     6.194    91.723     0.200
     6.568    96.789     0.200
     6.576    96.711     0.200
     6.605    97.133     0.200
     7.784   113.434     0.200
     1.481    25.414     0.200
     1.657    29.145     0.200
     1.657    28.227     0.200
     1.709    29.984     0.200
     2.228    37.238     0.200
     2.567    41.711     0.200
     2.652    41.512     0.200
     3.157    49.129     0.200
     3.482    52.434     0.200
     3.539    53.273     0.200
     3.539    53.113     0.200
     3.577    53.941     0.200
     3.603    54.145     0.200
     3.818    58.637     0.200
     3.818    57.582     0.200
     3.846    58.465     0.200
     3.846    58.648     0.200
     3.861    57.871     0.200
     3.860    57.480     0.200
     3.860    57.723     0.200
     4.044    61.121     0.200
     4.044    60.945     0.200
     4.067    60.559     0.200
     4.085    60.863     0.200
     4.112    61.012     0.200
     4.112    61.141     0.200
     4.762    70.461     0.200
     5.216    76.730     0.200
     5.347    79.070     0.200
     5.691    83.254     0.200
     1.621    29.250     0.200
     1.563    27.914     0.200
     1.663    29.465     0.200
     1.825    33.121     0.200
     2.166    35.789     0.200
     2.592    41.805     0.200
     2.592    41.637     0.200
     2.657    43.898     0.200
     2.857    46.023     0.200
     3.526    53.141     0.200
     3.526    53.363     0.200
     3.572    54.043     0.200
     3.572    54.258     0.200
     3.593    54.172     0.200
     3.600    54.484     0.200
     3.511    57.508     0.200
     3.788    57.531     0.200
     3.891    58.586     0.200
     3.899    58.879     0.200
     3.899    59.172     0.200
     3.959    60.488     0.200
     4.053    62.109     0.200
     4.064    60.949     0.200
     4.145    62.383     0.200
     4.151    62.074     0.200
     4.679    69.352     0.200
     4.758    71.012     0.200
     4.792    71.203     0.200
     5.234    77.004     0.200
     5.341    79.691     0.200
     5.344    79.387     0.200
     5.540    81.898     0.200
     5.701    84.164     0.200
     5.755    85.574     0.200
     5.787    85.234     0.200
     6.162    89.754     0.200
     6.968   102.004     0.200
     1.634    30.031     0.200
     1.588    29.279     0.200
     1.692    29.605     0.200
     1.692    29.793     0.200
     1.651    29.338     0.200
     1.765    32.527     0.200
     1.757    32.742     0.200
     2.169    36.018     0.200
     2.625    43.814     0.200
     2.648    42.541     0.200
     2.695    43.660     0.200
     2.669    46.070     0.200
     2.778    45.080     0.200
     2.815    46.711     0.200
     2.867    47.143     0.200
     3.106    48.770     0.200
     3.106    49.619     0.200
     3.133    51.508     0.200
     3.431    52.887     0.200
     3.431    53.082     0.200
     3.487    53.941     0.200
     3.469    53.061     0.200
     3.523    54.590     0.200
     3.476    57.082     0.200
     3.501    55.818     0.200
     3.546    54.590     0.200
     3.546    54.797     0.200
     3.500    56.127     0.200
     3.585    56.152     0.200
     3.585    56.982     0.200
     3.774    57.430     0.200
     3.774    57.803     0.200
     3.774    57.668     0.200
     3.787    57.998     0.200
     3.787    58.332     0.200
     3.809    58.424     0.200
     3.814    58.082     0.200
     3.986    61.404     0.200
     3.986    61.678     0.200
     4.010    61.121     0.200
     4.010    61.262     0.200
     4.038    61.342     0.200
     4.061    61.572     0.200
     4.061    61.762     0.200
     4.096    62.412     0.200
     4.153    63.756     0.200
     4.162    65.078     0.200
     4.345    67.746     0.200
     4.604    69.354     0.200
     4.604    69.572     0.200
     4.709    71.152     0.200
     4.797    71.768     0.200
     4.797    72.182     0.200
     4.797    71.947     0.200
     4.800    72.994     0.200
     5.161    77.213     0.200
     5.290    79.043     0.200
     5.366    80.143     0.200
     5.446    80.852     0.200
     5.446    81.373     0.200
     5.515    83.098     0.200
     5.563    83.486     0.200
     5.635    83.691     0.200
     5.705    85.152     0.200
     5.750    85.652     0.200
     5.768    86.061     0.200
     6.259    92.633     0.200
     6.332    94.195     0.200
     6.536    97.461     0.200
     6.632    98.072     0.200
     6.934   102.012     0.200
     7.141   104.633     0.200
     7.151   104.250     0.200
     7.250   106.232     0.200
     7.777   112.900     0.200
     7.911   115.793     0.200
     1.382    24.676     0.200
     1.612    29.715     0.200
     1.848    33.477     0.200
     2.118    37.715     0.200
     2.118    35.922     0.200
     2.360    38.973     0.200
     2.277    38.062     0.200
     2.488    41.586     0.200
     3.104    49.770     0.200
     3.576    57.988     0.200
     4.469    67.809     0.200
     4.726    69.711     0.200
     4.709    70.078     0.200
     5.238    76.754     0.200
     5.238    77.512     0.200
     5.322    78.473     0.200
     5.322    78.996     0.200
     5.382    79.164     0.200
     5.382    80.191     0.200
     5.445    80.441     0.200
     5.445    80.758     0.200
     5.469    79.590     0.200
     5.469    80.863     0.200
     5.548    82.172     0.200
     5.628    82.430     0.200
     5.628    83.324     0.200
     5.663    83.141     0.200
     5.663    82.953     0.200
     5.801    85.270     0.200
     5.801    87.660     0.200
     5.876    86.555     0.200
     5.903    86.262     0.200
     5.903    86.941     0.200
     6.545    96.215     0.200
     6.557    96.551     0.200
     6.679    96.625     0.200
     6.679    98.004     0.200
     7.029    98.652     0.200
     7.020   102.203     0.200
     7.184   104.934     0.200
     8.836   127.664     0.200
     1.700    29.044     0.200
     2.498    39.887     0.200
     3.489    52.178     0.200
     3.535    52.974     0.200
     3.562    53.229     0.200
     4.027    60.624     0.200
     4.108    61.824     0.200
     1.286    23.348     0.200
     1.907    32.590     0.200
     2.044    34.051     0.200
     2.234    37.719     0.200
     2.884    44.957     0.200
     2.894    46.527     0.200
     2.990    46.641     0.200
     2.990    46.801     0.200
     2.956    48.293     0.200
     3.005    47.266     0.200
     3.005    47.570     0.200
     3.274    50.223     0.200
     3.667    55.883     0.200
     3.667    56.180     0.200
     3.613    56.602     0.200
     3.695    56.703     0.200
     3.695    58.414     0.200
     3.854    57.809     0.200
     3.933    60.211     0.200
     3.933    58.777     0.200
     3.991    59.879     0.200
     4.069    61.020     0.200
     4.121    62.227     0.200
     4.121    62.340     0.200
     4.187    62.598     0.200
     4.187    63.570     0.200
     4.357    65.000     0.200
     4.357    66.082     0.200
     4.420    67.078     0.200
     4.492    66.398     0.200
     4.519    67.363     0.200
     4.567    68.293     0.200
     4.567    68.426     0.200
     4.694    72.945     0.200
     5.070    74.789     0.200
     5.070    75.027     0.200
     5.085    75.781     0.200
     5.085    75.672     0.200
     5.157    76.719     0.200
     5.291    79.191     0.200
     5.291    79.008     0.200
     5.631    82.309     0.200
     5.801    85.449     0.200
     5.861    85.758     0.200
     5.861    86.320     0.200
     5.946    87.570     0.200
     6.118    89.539     0.200
     6.145    89.621     0.200
     6.146    90.066     0.200
     6.204    91.051     0.200
     6.217    91.020     0.200
     6.914   100.887     0.200
     7.468   108.078     0.200
     7.659   111.059     0.200
     7.766   112.270     0.200
     8.083   117.141     0.200
     8.219   118.988     0.200
     1.535    28.203     0.200
     1.720    31.195     0.200
     1.927    33.602     0.200
     2.643    44.469     0.200
     4.864    72.617     0.200
     4.879    73.078     0.200
     5.217    79.117     0.200
     5.234    79.156     0.200
     5.931    88.266     0.200
     6.048    90.828     0.200
     6.478    96.289     0.200
     1.240    22.734     0.200
     1.410    24.727     0.200
     1.275    24.367     0.200
     1.598    27.564     0.200
     1.667    28.588     0.200
     1.449    26.395     0.200
     1.450    26.465     0.200
     1.518    27.260     0.200
     1.518    27.010     0.200
     1.928    33.127     0.200
     1.933    32.850     0.200
     1.940    32.633     0.200
     1.940    32.854     0.200
     1.988    32.773     0.200
     2.175    36.602     0.200
     2.255    34.533     0.200
     2.255    34.900     0.200
     2.168    35.965     0.200
     2.272    37.098     0.200
     2.272    37.385     0.200
     2.272    37.234     0.200
     2.376    38.154     0.200
     2.376    38.523     0.200
     2.272    36.133     0.200
     2.654    41.773     0.200
     2.654    41.670     0.200
     2.599    44.240     0.200
     2.777    42.768     0.200
     2.880    44.623     0.200
     2.880    44.477     0.200
     2.862    45.072     0.200
     3.131    48.188     0.200
     3.131    47.645     0.200
     2.937    47.885     0.200
     3.089    47.500     0.200
     3.089    48.324     0.200
     3.145    50.383     0.200
     3.146    50.441     0.200
     3.481    54.305     0.200
     3.481    53.867     0.200
     3.716    55.029     0.200
     3.716    55.293     0.200
     3.551    55.957     0.200
     3.790    56.111     0.200
     3.775    56.406     0.200
     3.775    56.877     0.200
     3.809    56.785     0.200
     3.809    56.475     0.200
     3.809    56.152     0.200
     3.810    56.357     0.200
     3.810    56.604     0.200
     3.713    58.648     0.200
     3.810    60.580     0.200
     3.863    58.307     0.200
     3.790    59.209     0.200
     3.889    59.730     0.200
     3.889    60.625     0.200
     3.940    60.922     0.200
     4.146    61.170     0.200
     4.204    61.965     0.200
     4.204    62.244     0.200
     4.217    63.357     0.200
     4.217    61.744     0.200
     4.217    63.875     0.200
     4.217    62.645     0.200
     4.217    63.725     0.200
     4.230    62.064     0.200
     4.387    64.934     0.200
     4.398    64.494     0.200
     4.398    64.385     0.200
     4.398    64.635     0.200
     4.215    65.094     0.200
     4.439    65.104     0.200
     4.646    68.174     0.200
     4.606    68.916     0.200
     4.588    68.916     0.200
     4.588    68.730     0.200
     4.588    70.195     0.200
     4.732    69.391     0.200
     4.732    69.707     0.200
     4.641    71.133     0.200
     4.700    70.156     0.200
     4.876    71.312     0.200
     4.876    71.494     0.200
     4.763    71.832     0.200
     5.011    73.195     0.200
     5.013    73.725     0.200
     5.013    74.455     0.200
     5.013    74.324     0.200
     5.013    73.832     0.200
     5.129    78.266     0.200
     5.129    78.102     0.200
     5.250    76.994     0.200
     5.250    77.295     0.200
     5.422    79.254     0.200
     5.415    78.910     0.200
     5.415    79.686     0.200
     5.415    79.535     0.200
     5.416    79.527     0.200
     5.416    79.795     0.200
     5.465    80.055     0.200
     5.789    84.268     0.200
     5.789    84.404     0.200
     5.812    84.754     0.200
     5.866    85.215     0.200
     5.873    85.584     0.200
     5.832    86.338     0.200
     6.031    88.074     0.200
     6.143    90.586     0.200
     6.143    91.314     0.200
     6.167    91.260     0.200
     6.167    91.090     0.200
     6.386    92.674     0.200
     6.415    93.094     0.200
     6.415    92.725     0.200
     6.803    98.023     0.200
     7.034   101.844     0.200
     7.285   104.945     0.200
     7.399   106.584     0.200
     7.397   106.514     0.200
     7.612   109.484     0.200
     7.745   111.244     0.200
     7.771   111.414     0.200
     7.812   114.455     0.200
     8.072   115.504     0.200
     7.956   114.922     0.200
     8.269   120.867     0.200
     9.375   135.904     0.200
     9.436   136.523     0.200
     9.606   138.734     0.200
    10.097   143.412     0.200
    10.196   145.914     0.200
    10.310   147.621     0.200
    11.824   169.184     0.200
    12.592   179.414     0.200
    14.708   209.004     0.200
    14.890   211.424     0.200
    15.973   225.395     0.200
    16.123   227.295     0.200
    16.772   233.494     0.200
    16.861   236.184     0.200
    17.828   246.465     0.200
    17.964   248.645     0.200
    18.067   250.744     0.200
    18.067   250.904     0.200
    18.217   251.885     0.200
    18.449   255.965     0.200
    18.644   258.762     0.200
    18.681   258.635     0.200
    18.797   259.395     0.200
    18.797   259.195     0.200
    19.066   262.984     0.200
    19.323   265.201     0.200
    19.450   266.234     0.200
    19.854   271.484     0.200
    20.396   277.094     0.200
    20.698   281.535     0.200
    20.927   283.564     0.200
     1.629    29.766     0.200
     1.672    28.742     0.200
     1.960    33.320     0.200
     2.231    35.266     0.200
     2.231    34.867     0.200
     2.236    36.633     0.200
     2.746    43.156     0.200
     2.746    42.379     0.200
     2.894    45.398     0.200
     2.852    45.695     0.200
     3.096    50.816     0.200
     3.055    48.602     0.200
     3.055    46.855     0.200
     3.115    49.797     0.200
     3.705    55.809     0.200
     3.744    58.656     0.200
     3.790    56.379     0.200
     3.790    56.660     0.200
     3.807    56.781     0.200
     3.805    56.867     0.200
     3.805    57.812     0.200
     3.756    57.902     0.200
     3.756    58.371     0.200
     3.838    59.121     0.200
     3.838    58.480     0.200
     3.922    62.582     0.200
     3.975    60.578     0.200
     4.144    62.461     0.200
     4.222    64.297     0.200
     4.222    64.852     0.200
     4.194    62.973     0.200
     4.194    63.480     0.200
     4.383    65.793     0.200
     4.396    64.762     0.200
     4.396    66.172     0.200
     4.441    66.820     0.200
     4.644    69.262     0.200
     4.721    70.215     0.200
     4.870    72.504     0.200
     5.007    74.082     0.200
     5.004    74.410     0.200
     5.004    74.871     0.200
     5.415    79.691     0.200
     5.454    80.410     0.200
     5.858    85.602     0.200
     5.861    85.922     0.200
     7.384   107.152     0.200
     2.138    35.361     0.200
     2.879    45.606     0.200
     3.728    58.958     0.200
     3.806    55.981     0.200
     3.824    56.101     0.200
     3.962    60.621     0.200
     4.213    62.621     0.200
     5.876    85.151     0.200
     1.628    26.909     0.200
     1.908    32.973     0.200
     1.915    33.342     0.200
     1.958    32.351     0.200
     2.139    35.525     0.200
     2.255    34.611     0.200
     2.255    34.859     0.200
     2.298    36.868     0.200
     2.664    41.368     0.200
     2.767    42.885     0.200
     2.767    42.100     0.200
     2.875    45.305     0.200
     3.074    48.125     0.200
     3.074    48.298     0.200
     3.146    47.207     0.200
     3.729    55.315     0.200
     3.780    57.553     0.200
     3.799    58.206     0.200
     3.811    56.295     0.200
     3.827    56.896     0.200
     3.827    56.755     0.200
     3.829    56.355     0.200
     3.862    57.647     0.200
     4.218    62.066     0.200
     4.218    62.396     0.200
     4.417    65.996     0.200
     4.461    65.295     0.200
     4.602    68.710     0.200
     4.666    69.115     0.200
     4.893    71.896     0.200
     5.027    74.396     0.200
     5.115    77.360     0.200
     5.249    75.992     0.200
     5.438    79.755     0.200
     5.477    79.785     0.200
     5.881    85.535     0.200
     5.885    85.295     0.200
     6.047    87.875     0.200
     6.426    93.055     0.200
     6.815    98.365     0.200
     7.043   101.765     0.200
     7.296   104.565     0.200
     1.754    32.492     0.200
     1.900    34.836     0.200
     1.955    35.289     0.200
     2.448    40.500     0.200
     2.504    43.516     0.200
     2.459    41.383     0.200
     2.589    44.969     0.200
     2.698    44.406     0.200
     2.778    45.594     0.200
     2.900    47.633     0.200
     2.885    48.617     0.200
     3.071    49.977     0.200
     3.162    51.688     0.200
     4.304    66.320     0.200
     4.401    67.484     0.200
     5.389    80.078     0.200
     5.443    80.898     0.200
     5.443    81.242     0.200
     5.473    81.570     0.200
     5.526    81.977     0.200
     5.581    83.680     0.200
     5.760    85.109     0.200
     5.760    86.031     0.200
     5.767    86.961     0.200
     5.924    88.297     0.200
     5.988    89.289     0.200
     6.019    88.812     0.200
     6.019    90.359     0.200
     6.264    93.156     0.200
     6.724    99.781     0.200
     6.961   101.680     0.200
     7.107   104.570     0.200
     7.196   105.531     0.200
     7.571   111.570     0.200
     9.139   132.320     0.200
     1.945    32.418     0.200
     2.755    41.879     0.200
     3.774    56.285     0.200
     3.829    56.859     0.200
     3.854    56.539     0.200
     4.216    63.359     0.200
     1.681    29.883     0.200
     1.627    29.008     0.200
     1.734    30.586     0.200
     2.431    40.531     0.200
     2.602    42.852     0.200
     2.816    47.031     0.200
     3.125    49.477     0.200
     3.125    50.008     0.200
     3.455    52.477     0.200
     3.455    53.016     0.200
     3.511    53.969     0.200
     3.548    54.016     0.200
     3.548    54.641     0.200
     3.517    55.312     0.200
     3.452    56.484     0.200
     3.475    55.242     0.200
     3.528    55.391     0.200
     3.563    56.133     0.200
     3.811    58.641     0.200
     3.811    60.086     0.200
     3.833    58.352     0.200
     3.833    58.617     0.200
     3.837    58.320     0.200
     4.009    61.156     0.200
     4.009    60.734     0.200
     4.035    60.953     0.200
     4.035    61.125     0.200
     4.061    62.305     0.200
     4.085    61.766     0.200
     4.148    64.594     0.200
     4.592    69.430     0.200
     4.592    69.031     0.200
     4.628    69.367     0.200
     4.733    71.016     0.200
     4.822    71.203     0.200
     4.823    74.055     0.200
     5.186    77.297     0.200
     5.315    79.398     0.200
     5.660    83.508     0.200
     5.730    85.242     0.200
     1.742    30.602     0.200
     2.595    42.398     0.200
     3.543    54.668     0.200
     3.570    54.223     0.200
     3.815    58.664     0.200
     4.016    60.496     0.200
     4.591    69.461     0.200
     4.831    72.824     0.200
     2.426    40.141     0.200
     2.458    40.250     0.200
     2.459    40.727     0.200
     2.474    41.234     0.200
     3.207    51.531     0.200
     4.368    65.664     0.200
     4.910    72.641     0.200
     5.002    74.414     0.200
     6.054    85.570     0.200
     1.646    29.867     0.200
     1.808    32.336     0.200
     3.012    50.227     0.200
     3.578    57.445     0.200
     5.602    83.203     0.200
     5.700    84.547     0.200
     5.784    87.484     0.200
     5.997    88.938     0.200
     6.120    91.086     0.200
     6.322    93.719     0.200
     6.475    95.133     0.200
     7.086   104.594     0.200
     7.381   104.203     0.200
     7.407   108.062     0.200
     7.603   111.227     0.200
     8.020   117.086     0.200
     9.275   134.695     0.200
     9.570   138.398     0.200
     1.586    29.414     0.200
     2.434    41.406     0.200
     2.602    43.273     0.200
     2.585    44.742     0.200
     3.012    47.570     0.200
     3.012    47.711     0.200
     2.991    49.805     0.200
     3.119    50.945     0.200
     3.092    50.156     0.200
     3.139    49.594     0.200
     3.195    50.633     0.200
     3.195    50.320     0.200
     3.298    53.273     0.200
     3.298    53.680     0.200
     3.449    54.805     0.200
     3.634    57.969     0.200
     3.756    60.773     0.200
     4.045    64.742     0.200
     4.163    66.359     0.200
     4.542    70.820     0.200
     4.542    70.461     0.200
     4.605    70.883     0.200
     4.605    70.602     0.200
     4.635    70.914     0.200
     4.736    72.547     0.200
     4.736    72.375     0.200
     4.918    74.297     0.200
     4.918    74.156     0.200
     4.941    75.047     0.200
     4.943    74.250     0.200
     4.943    75.164     0.200
     5.143    78.297     0.200
     5.234    79.219     0.200
     5.282    79.281     0.200
     5.282    79.633     0.200
     5.274    81.477     0.200
     5.405    81.547     0.200
     5.407    80.977     0.200
     5.407    81.250     0.200
     5.491    82.812     0.200
     5.532    82.648     0.200
     5.532    82.844     0.200
     5.609    84.383     0.200
     5.726    86.055     0.200
     5.781    86.562     0.200
     5.888    88.688     0.200
     5.961    88.859     0.200
     6.050    90.617     0.200
     6.050    90.922     0.200
     6.116    91.312     0.200
     6.457    95.859     0.200
     6.492    96.367     0.200
     6.655    99.000     0.200
     6.852   101.188     0.200
     6.906   102.281     0.200
     7.111   105.562     0.200
     7.776   113.812     0.200
     1.853    32.872     0.200
     1.973    33.353     0.200
     2.071    37.242     0.200
     2.276    38.628     0.200
     2.280    39.089     0.200
     2.776    46.711     0.200
     3.088    50.089     0.200
     3.093    51.738     0.200
     3.188    51.768     0.200
     3.338    54.820     0.200
     3.338    55.023     0.200
     3.502    54.375     0.200
     3.503    55.822     0.200
     3.664    58.190     0.200
     4.311    67.304     0.200
     4.522    71.269     0.200
     4.579    69.586     0.200
     4.633    70.673     0.200
     4.633    70.310     0.200
     4.647    69.954     0.200
     4.689    72.177     0.200
     4.965    74.377     0.200
     5.006    76.033     0.200
     5.065    75.921     0.200
     5.394    81.870     0.200
     5.465    81.733     0.200
     5.597    82.646     0.200
     5.597    82.976     0.200
     5.871    87.317     0.200
     5.871    87.623     0.200
     6.071    90.402     0.200
     6.181    91.502     0.200
     6.271    92.683     0.200
     6.329    93.303     0.200
     6.674    97.721     0.200
     6.722    98.573     0.200
     1.285    25.523     0.200
     1.477    28.172     0.200
     1.535    27.574     0.200
     1.638    28.922     0.200
     1.761    29.848     0.200
     1.761    30.172     0.200
     2.430    38.727     0.200
     2.595    42.434     0.200
     2.708    41.598     0.200
     3.458    54.047     0.200
     3.469    53.203     0.200
     3.548    52.629     0.200
     3.548    53.008     0.200
     3.599    53.758     0.200
     3.630    53.980     0.200
     3.630    54.309     0.200
     3.634    54.133     0.200
     3.448    54.887     0.200
     3.559    54.172     0.200
     3.573    56.902     0.200
     3.842    58.035     0.200
     3.842    57.352     0.200
     3.924    58.887     0.200
     3.939    58.617     0.200
     4.019    60.543     0.200
     4.019    60.191     0.200
     4.103    60.543     0.200
     4.103    60.957     0.200
     4.176    61.805     0.200
     4.176    61.926     0.200
     4.204    62.977     0.200
     4.098    61.688     0.200
     4.422    65.027     0.200
     4.380    65.625     0.200
     4.656    69.039     0.200
     4.656    68.859     0.200
     4.821    71.879     0.200
     4.894    73.395     0.200
     4.894    73.027     0.200
     5.266    76.777     0.200
     5.381    79.035     0.200
     5.398    78.820     0.200
     5.403    80.246     0.200
     5.736    83.586     0.200
     5.795    84.984     0.200
     5.836    84.715     0.200
     1.368    25.812     0.200
     1.332    25.383     0.200
     2.582    44.320     0.200
     2.615    42.133     0.200
     2.615    42.914     0.200
     2.720    43.984     0.200
     2.750    44.266     0.200
     2.750    45.539     0.200
     3.091    50.383     0.200
     3.093    49.234     0.200
     3.347    54.445     0.200
     3.713    59.789     0.200
     4.207    65.961     0.200
     4.663    70.875     0.200
     4.589    70.672     0.200
     4.682    71.109     0.200
     5.370    81.391     0.200
     1.271    22.656     0.200
     1.849    32.113     0.200
     5.587    82.566     0.200
     5.683    83.988     0.200
     5.710    84.258     0.200
     5.800    85.906     0.200
     5.985    88.266     0.200
     6.045    89.586     0.200
     6.408    94.117     0.200
     6.443    94.156     0.200
     7.329   104.176     0.200
     7.419   108.125     0.200
     1.595    29.688     0.200
     1.747    32.812     0.200
     1.860    34.578     0.200
     2.665    46.070     0.200
     2.800    48.570     0.200
     2.910    50.258     0.200
     3.609    58.883     0.200
     4.704    72.680     0.200
     4.773    73.797     0.200
     5.049    77.328     0.200
     5.314    81.367     0.200
     5.582    85.344     0.200
     1.506    28.219     0.200
     1.597    29.789     0.200
     1.788    32.836     0.200
     1.923    34.527     0.200
     2.113    37.082     0.200
     2.298    40.055     0.200
     2.657    46.074     0.200
     2.907    48.016     0.200
     3.206    53.633     0.200
     3.278    54.188     0.200
     3.333    53.707     0.200
     3.492    57.449     0.200
     3.755    59.953     0.200
     3.879    62.184     0.200
     4.035    64.871     0.200
     4.228    64.895     0.200
     4.441    69.527     0.200
     4.486    69.285     0.200
     4.797    73.277     0.200
     4.891    75.242     0.200
     5.115    77.727     0.200
     5.084    79.375     0.200
     5.165    80.469     0.200
     5.166    80.965     0.200
     5.211    79.160     0.200
     5.283    80.258     0.200
     5.312    80.145     0.200
     5.370    81.219     0.200
     5.383    81.266     0.200
     5.401    81.570     0.200
     5.435    83.434     0.200
     5.510    83.277     0.200
     5.510    83.391     0.200
     5.641    85.121     0.200
     5.656    85.152     0.200
     5.656    84.980     0.200
     5.754    86.602     0.200
     5.754    86.711     0.200
     5.830    87.719     0.200
     5.839    87.770     0.200
     5.828    87.688     0.200
     5.828    87.805     0.200
     5.829    90.184     0.200
     5.990    89.609     0.200
     6.356    95.031     0.200
     6.398    95.430     0.200
     6.430    96.172     0.200
     6.594    98.293     0.200
     6.898    98.629     0.200
     6.589   100.965     0.200
     6.589   101.094     0.200
     6.842   102.449     0.200
     6.917   102.590     0.200
     7.103   105.391     0.200
     7.110   105.320     0.200
     7.126   107.973     0.200
     7.126   108.074     0.200
     7.210   106.613     0.200
     7.214   106.262     0.200
     7.413   109.449     0.200
     7.398   108.910     0.200
     7.398   108.793     0.200
     7.479   110.988     0.200
     7.527   111.320     0.200
     7.634   112.469     0.200
     7.919   116.852     0.200
     8.085   119.238     0.200
     8.145   119.758     0.200
     8.447   124.230     0.200
     8.653   126.316     0.200
     8.801   130.816     0.200
     8.801   130.652     0.200
     8.916   130.090     0.200
     8.970   130.789     0.200
     8.984   131.051     0.200
     9.077   132.590     0.200
     9.399   137.051     0.200
     9.440   137.500     0.200
     9.534   139.176     0.200
     9.599   139.395     0.200
     9.727   141.391     0.200
    10.521   152.371     0.200
    10.877   156.934     0.200
    10.941   158.141     0.200
    10.961   158.441     0.200
    11.310   164.242     0.200
    19.076   265.875     0.200
    19.305   268.270     0.200
    19.643   271.949     0.200
    19.681   272.340     0.200
    19.943   275.746     0.200
    20.046   277.254     0.200
    20.565   283.117     0.200
    20.588   283.773     0.200
     1.396    26.855     0.200
     1.802    33.031     0.200
     2.323    40.508     0.200
     2.455    41.331     0.200
     2.644    45.109     0.200
     2.660    43.972     0.200
     3.443    55.812     0.200
     3.522    57.352     0.200
     4.930    75.126     0.200
     5.004    76.106     0.200
     5.263    80.646     0.200
     5.557    84.207     0.200
     5.808    87.846     0.200
     2.608    40.488     0.200
     4.194    63.839     0.200
     4.353    65.493     0.200
     4.420    66.377     0.200
     4.498    67.479     0.200
     4.736    71.560     0.200
     4.762    71.438     0.200
     4.899    73.204     0.200
     4.899    73.489     0.200
     4.972    73.569     0.200
     5.070    75.419     0.200
     5.468    80.145     0.200
     6.179    90.810     0.200
     6.311    92.098     0.200
     1.921    34.418     0.200
     1.943    34.996     0.200
     2.585    44.578     0.200
     5.858    88.092     0.200
     5.948    89.521     0.200
     5.982    90.070     0.200
     6.048    91.490     0.200
     6.067    91.381     0.200
     6.067    91.580     0.200
     6.255    93.971     0.200
     6.489    97.691     0.200
     6.615    98.480     0.200
     6.681    99.771     0.200
     6.713   100.012     0.200
     7.132   105.771     0.200
     7.177   106.461     0.200
     7.597   109.621     0.200
     7.690   113.170     0.200
     7.951   116.641     0.200
     8.203   120.361     0.200
     8.220   120.561     0.200
     1.503    26.267     0.200
     1.790    31.274     0.200
     1.790    31.521     0.200
     1.742    31.797     0.200
     2.118    36.452     0.200
     2.327    41.266     0.200
     2.561    41.961     0.200
     2.561    42.477     0.200
     2.716    44.572     0.200
     2.734    44.198     0.200
     3.538    56.107     0.200
     4.828    72.366     0.200
     4.899    73.334     0.200
     4.947    74.031     0.200
     4.947    73.904     0.200
     5.164    77.362     0.200
     5.169    77.254     0.200
     5.214    78.464     0.200
     5.292    80.016     0.200
     5.292    80.264     0.200
     5.402    81.613     0.200
     5.444    81.333     0.200
     5.463    81.934     0.200
     5.706    85.514     0.200
     6.000    88.804     0.200
     6.000    88.519     0.200
     6.044    90.007     0.200
     6.586    96.714     0.200
     6.722    97.593     0.200
     6.724    99.224     0.200
     7.138   104.254     0.200
     1.982    34.984     0.200
     2.831    47.398     0.200
     2.919    49.477     0.200
     3.890    60.625     0.200
     3.972    62.766     0.200
     4.216    64.766     0.200
     4.528    69.703     0.200
     4.567    70.359     0.200
     4.768    73.336     0.200
     1.594    28.476     0.200
     1.954    33.890     0.200
     2.220    35.838     0.200
     2.316    40.077     0.200
     2.734    44.235     0.200
     2.734    44.001     0.200
     2.841    46.318     0.200
     2.841    45.087     0.200
     2.906    47.694     0.200
     3.043    50.302     0.200
     3.043    47.572     0.200
     3.756    61.126     0.200
     3.746    59.239     0.200
     3.746    58.489     0.200
     3.802    57.515     0.200
     3.802    58.061     0.200
     3.800    58.529     0.200
     3.800    58.968     0.200
     3.766    57.985     0.200
     3.827    59.314     0.200
     4.187    63.875     0.200
     4.187    64.085     0.200
     4.567    69.083     0.200
     4.713    71.049     0.200
     4.713    71.161     0.200
     4.997    74.652     0.200
     5.084    78.522     0.200
     5.446    81.415     0.200
     5.851    86.155     0.200
     1.230    22.488     0.200
     1.348    24.133     0.200
     1.320    23.793     0.200
     1.959    33.461     0.200
     2.194    35.715     0.200
     2.232    34.820     0.200
     2.336    39.484     0.200
     2.519    40.680     0.200
     2.873    43.703     0.200
     3.252    50.359     0.200
     3.372    52.289     0.200
     3.540    52.434     0.200
     3.587    55.250     0.200
     3.836    58.250     0.200
     3.922    57.965     0.200
     3.942    57.961     0.200
     3.942    58.297     0.200
     4.036    60.922     0.200
     4.036    61.227     0.200
     4.159    63.492     0.200
     4.159    62.586     0.200
     4.288    62.688     0.200
     4.383    65.270     0.200
     4.504    65.875     0.200
     4.923    73.016     0.200
     4.925    72.109     0.200
     5.138    75.648     0.200
     5.183    75.898     0.200
     5.183    76.156     0.200
     5.547    81.672     0.200
     5.592    81.801     0.200
     5.655    82.309     0.200
     6.031    87.727     0.200
     6.057    87.555     0.200
     6.067    87.918     0.200
     7.259   104.828     0.200
     1.373    23.867     0.200
     2.038    35.328     0.200
     2.038    34.586     0.200
     2.095    34.719     0.200
     2.173    36.789     0.200
     2.203    35.516     0.200
     2.379    37.516     0.200
     2.379    37.828     0.200
     2.397    38.891     0.200
     2.508    39.977     0.200
     2.491    39.945     0.200
     2.683    41.164     0.200
     2.629    43.594     0.200
     2.831    45.906     0.200
     2.955    46.508     0.200
     2.955    45.922     0.200
     3.034    48.703     0.200
     3.034    48.117     0.200
     3.289    53.078     0.200
     3.697    58.523     0.200
     3.744    56.094     0.200
     3.740    55.992     0.200
     3.778    56.375     0.200
     3.778    56.086     0.200
     3.792    56.047     0.200
     3.792    56.594     0.200
     3.862    58.523     0.200
     3.985    60.367     0.200
     3.985    61.672     0.200
     3.988    63.344     0.200
     4.109    60.539     0.200
     4.137    63.078     0.200
     4.162    63.344     0.200
     4.222    62.914     0.200
     4.222    63.688     0.200
     4.362    65.430     0.200
     4.378    66.734     0.200
     4.369    65.562     0.200
     4.761    69.977     0.200
     4.761    70.359     0.200
     4.990    73.781     0.200
     5.024    73.984     0.200
     5.024    74.219     0.200
     5.418    79.734     0.200
     5.418    79.477     0.200
     5.492    80.664     0.200
     5.873    85.758     0.200
     5.903    86.375     0.200
     7.089   102.508     0.200
     7.325   105.578     0.200
     7.436   107.242     0.200
     3.155    53.070     0.200
     5.303    80.454     0.200
     5.386    81.444     0.200
     5.616    85.964     0.200
     5.853    88.914     0.200
     5.961    89.685     0.200
     6.523    97.284     0.200
     6.740   100.635     0.200
     7.083   105.944     0.200
     7.243   107.464     0.200
     7.570   111.385     0.200
     1.113    19.348     0.200
     1.113    19.845     0.200
     1.060    20.100     0.200
     1.258    22.749     0.200
     1.449    25.672     0.200
     1.389    24.124     0.200
     1.740    26.535     0.200
     2.587    39.935     0.200
     2.685    40.848     0.200
     2.695    41.490     0.200
     3.425    50.982     0.200
     3.507    50.240     0.200
     4.080    60.311     0.200
     4.080    60.440     0.200
     4.170    61.320     0.200
     4.386    64.910     0.200
     4.472    65.557     0.200
     4.623    68.710     0.200
     4.657    68.583     0.200
     4.657    69.028     0.200
     4.718    69.320     0.200
     4.786    69.593     0.200
     4.786    69.870     0.200
     4.797    69.880     0.200
     4.875    71.408     0.200
     4.875    71.755     0.200
     5.000    72.672     0.200
     5.356    77.865     0.200
     5.391    79.450     0.200
     5.549    80.488     0.200
     5.549    80.330     0.200
     5.869    80.750     0.200
     5.691    82.576     0.200
     5.874    84.910     0.200
     6.066    87.590     0.200
     6.253    89.473     0.200
     6.368    92.141     0.200
     6.611    95.060     0.200
     2.167    36.066     0.200
     3.467    57.531     0.200
     3.747    58.354     0.200
     3.781    59.480     0.200
     3.734    56.807     0.200
     3.764    57.066     0.200
     4.135    63.986     0.200
     4.157    63.986     0.200
     4.198    63.887     0.200
     4.605    71.914     0.200
     4.975    74.896     0.200
     5.003    74.748     0.200
     5.399    80.367     0.200
     5.467    81.668     0.200
     5.853    86.797     0.200
     1.537    27.559     0.200
     2.352    40.455     0.200
     2.594    42.912     0.200
     2.676    44.141     0.200
     2.676    42.900     0.200
     2.684    43.588     0.200
     2.850    45.332     0.200
     2.850    46.623     0.200
     2.896    48.375     0.200
     3.224    51.992     0.200
     3.348    50.855     0.200
     3.348    52.879     0.200
     3.377    52.172     0.200
     3.322    53.738     0.200
     3.322    52.832     0.200
     3.668    56.381     0.200
     3.668    55.732     0.200
     3.732    56.723     0.200
     3.722    59.262     0.200
     3.722    58.408     0.200
     3.776    58.186     0.200
     3.776    57.658     0.200
     3.816    57.600     0.200
     3.816    58.043     0.200
     3.981    60.943     0.200
     3.981    61.303     0.200
     4.032    62.992     0.200
     4.050    61.664     0.200
     4.050    62.732     0.200
     4.064    61.184     0.200
     4.064    61.932     0.200
     4.125    64.881     0.200
     4.260    66.232     0.200
     4.259    65.025     0.200
     4.259    66.277     0.200
     4.276    64.232     0.200
     4.276    64.742     0.200
     4.301    64.543     0.200
     4.301    65.094     0.200
     4.232    66.637     0.200
     4.347    65.912     0.200
     4.374    66.938     0.200
     4.836    72.816     0.200
     4.836    73.344     0.200
     4.956    74.773     0.200
     5.059    75.354     0.200
     5.059    76.033     0.200
     5.067    76.576     0.200
     5.416    80.934     0.200
     5.557    83.104     0.200
     5.640    83.648     0.200
     5.894    86.963     0.200
     5.973    88.723     0.200
     6.045    89.355     0.200
     1.296    22.814     0.200
     2.133    36.433     0.200
     2.518    40.036     0.200
     2.657    41.424     0.200
     2.562    44.318     0.200
     2.814    44.615     0.200
     2.643    44.832     0.200
     2.920    44.860     0.200
     3.072    49.289     0.200
     3.180    50.302     0.200
     3.267    52.373     0.200
     3.615    57.680     0.200
     3.782    60.062     0.200
     4.170    65.104     0.200
     4.170    64.788     0.200
     4.251    63.569     0.200
     4.241    66.803     0.200
     4.423    65.270     0.200
     4.638    69.534     0.200
     4.674    69.455     0.200
     4.674    70.729     0.200
     4.689    70.685     0.200
     4.762    70.413     0.200
     4.922    73.555     0.200
     4.922    73.785     0.200
     4.907    76.415     0.200
     4.907    75.312     0.200
     5.016    75.405     0.200
     5.264    77.055     0.200
     5.264    77.995     0.200
     5.401    80.785     0.200
     5.401    79.512     0.200
     5.666    83.585     0.200
     5.737    86.024     0.200
     5.737    85.625     0.200
     6.190    91.405     0.200
     6.592    96.625     0.200
     7.442   108.695     0.200
     1.320    24.533     0.200
     1.744    30.896     0.200
     1.971    34.064     0.200
     2.162    36.729     0.200
     2.546    40.406     0.200
     2.648    42.628     0.200
     2.679    43.120     0.200
     2.679    41.332     0.200
     2.789    45.702     0.200
     2.825    44.153     0.200
     2.925    47.251     0.200
     2.925    46.781     0.200
     3.087    50.865     0.200
     3.087    48.644     0.200
     3.169    50.607     0.200
     3.208    50.518     0.200
     3.282    53.993     0.200
     3.619    59.550     0.200
     3.789    61.082     0.200
     4.187    65.322     0.200
     4.187    64.057     0.200
     4.272    63.819     0.200
     4.278    64.774     0.200
     4.668    70.485     0.200
     4.668    69.166     0.200
     4.704    69.887     0.200
     4.704    70.884     0.200
     4.720    71.268     0.200
     4.774    71.589     0.200
     4.949    74.616     0.200
     4.949    74.417     0.200
     4.907    76.423     0.200
     4.907    75.195     0.200
     5.046    74.807     0.200
     5.236    78.647     0.200
     5.294    77.728     0.200
     5.294    78.137     0.200
     5.426    80.295     0.200
     5.542    82.057     0.200
     5.694    84.228     0.200
     5.763    86.688     0.200
     6.155    91.237     0.200
     6.619    97.877     0.200
     2.717    43.449     0.200
     2.717    42.667     0.200
     2.819    45.010     0.200
     2.819    44.708     0.200
     2.893    48.082     0.200
     3.334    53.787     0.200
     3.379    55.637     0.200
     3.684    59.798     0.200
     4.204    64.174     0.200
     4.204    63.543     0.200
     4.308    64.600     0.200
     4.308    65.709     0.200
     4.436    69.600     0.200
     4.634    72.357     0.200
     4.787    70.914     0.200
     4.808    71.874     0.200
     5.013    75.334     0.200
     5.130    76.241     0.200
     5.130    77.424     0.200
     5.376    80.264     0.200
     5.488    82.484     0.200
     1.181    19.883     0.200
     1.152    20.933     0.200
     1.283    23.008     0.200
     2.123    35.372     0.200
     4.190    62.042     0.200
     4.190    62.329     0.200
     4.278    63.640     0.200
     4.423    64.740     0.200
     4.423    65.339     0.200
     4.465    66.760     0.200
     4.500    66.409     0.200
     4.582    68.005     0.200
     4.737    70.189     0.200
     4.738    70.276     0.200
     4.738    70.820     0.200
     4.829    71.089     0.200
     4.886    72.121     0.200
     4.886    71.789     0.200
     4.944    72.831     0.200
     5.067    74.260     0.200
     5.454    79.646     0.200
     5.454    80.120     0.200
     5.500    80.879     0.200
     5.652    81.774     0.200
     5.652    82.680     0.200
     5.980    83.159     0.200
     5.753    84.183     0.200
     5.981    87.060     0.200
     6.167    89.569     0.200
     6.700    97.166     0.200
     0.950    19.641     0.200
     1.018    20.076     0.200
     1.239    23.057     0.200
     1.370    24.990     0.200
     1.776    27.590     0.200
     2.091    35.215     0.200
     2.625    41.096     0.200
     2.737    41.412     0.200
     3.259    47.658     0.200
     3.553    51.070     0.200
     4.065    60.592     0.200
     4.153    61.771     0.200
     4.301    63.441     0.200
     4.301    64.418     0.200
     4.376    65.303     0.200
     4.457    67.002     0.200
     4.613    68.781     0.200
     4.622    67.346     0.200
     4.703    69.922     0.200
     4.762    70.131     0.200
     4.941    72.852     0.200
     5.330    77.434     0.200
     5.855    81.893     0.200
     6.042    87.062     0.200
     1.417    25.445     0.200
     1.461    26.039     0.200
     2.083    35.398     0.200
     2.232    37.852     0.200
     2.198    35.703     0.200
     2.389    39.742     0.200
     2.699    42.484     0.200
     2.940    46.109     0.200
     3.018    47.672     0.200
     3.274    53.023     0.200
     3.735    56.477     0.200
     3.768    56.805     0.200
     3.768    56.578     0.200
     3.847    58.148     0.200
     3.973    61.727     0.200
     4.100    62.141     0.200
     4.154    63.789     0.200
     4.209    64.047     0.200
     4.352    65.891     0.200
     4.600    68.750     0.200
     4.749    70.648     0.200
     4.736    71.766     0.200
     4.855    72.211     0.200
     4.979    74.180     0.200
     5.012    74.570     0.200
     5.012    73.719     0.200
     5.479    80.852     0.200
     5.862    86.336     0.200
     5.890    86.820     0.200
     2.209    37.461     0.200
     3.157    51.711     0.200
     3.499    56.109     0.200
     3.508    55.656     0.200
     5.417    79.578     0.200
     5.725    83.297     0.200
     5.972    88.562     0.200
     5.991    88.078     0.200
     6.212    90.422     0.200
     6.640    97.117     0.200
     7.114   103.641     0.200
     7.272   105.383     0.200
     1.987    34.168     0.200
     1.987    32.637     0.200
     2.522    40.809     0.200
     2.664    42.250     0.200
     2.756    42.414     0.200
     2.729    43.066     0.200
     2.734    42.309     0.200
     2.734    43.520     0.200
     2.921    46.730     0.200
     2.921    45.160     0.200
     2.955    47.039     0.200
     3.038    46.730     0.200
     3.041    48.297     0.200
     3.235    48.125     0.200
     3.241    52.031     0.200
     3.429    52.082     0.200
     3.459    53.477     0.200
     3.459    53.004     0.200
     3.517    53.305     0.200
     3.713    54.777     0.200
     3.713    55.312     0.200
     3.781    56.203     0.200
     3.829    56.965     0.200
     3.829    57.188     0.200
     3.794    57.578     0.200
     3.795    57.430     0.200
     3.803    57.430     0.200
     3.879    57.297     0.200
     3.879    57.676     0.200
     4.014    60.223     0.200
     4.069    60.562     0.200
     4.097    60.961     0.200
     4.139    61.191     0.200
     4.139    61.336     0.200
     4.337    63.941     0.200
     4.337    64.113     0.200
     4.347    64.773     0.200
     4.337    63.941     0.200
     4.337    64.344     0.200
     4.398    65.293     0.200
     4.456    67.219     0.200
     4.591    67.992     0.200
     4.899    71.957     0.200
     4.899    72.188     0.200
     5.005    74.152     0.200
     5.117    74.703     0.200
     5.117    75.281     0.200
     5.148    75.848     0.200
     5.469    80.051     0.200
     5.618    82.754     0.200
     5.692    82.777     0.200
     5.718    83.301     0.200
     5.829    87.070     0.200
     5.829    86.570     0.200
     5.914    85.086     0.200
     5.914    85.820     0.200
     5.950    86.453     0.200
     6.034    88.184     0.200
     6.050    88.711     0.200
     6.115    88.922     0.200
     6.590    96.152     0.200
     6.681    96.918     0.200
     6.959   100.551     0.200
     7.493   107.359     0.200
     7.581   109.172     0.200
     7.883   113.301     0.200
     7.948   114.852     0.200
     8.019   115.012     0.200
     8.019   114.812     0.200
     8.107   116.383     0.200
     8.239   118.223     0.200
     9.358   134.555     0.200
     9.463   135.211     0.200
     1.600    30.211     0.200
     1.983    35.469     0.200
     5.374    81.582     0.200
     5.656    85.672     0.200
     5.740    88.082     0.200
     6.050    90.863     0.200
     1.594    27.539     0.200
     2.251    38.352     0.200
     2.783    45.383     0.200
     2.783    44.609     0.200
     2.912    47.164     0.200
     3.025    47.266     0.200
     3.025    47.164     0.200
     4.014    63.602     0.200
     4.334    67.188     0.200
     4.334    66.609     0.200
     4.373    67.602     0.200
     4.476    68.086     0.200
     4.476    67.602     0.200
     4.648    70.297     0.200
     4.668    70.156     0.200
     4.668    70.273     0.200
     4.974    74.680     0.200
     4.974    74.133     0.200
     5.009    74.867     0.200
     5.131    76.453     0.200
     5.174    78.531     0.200
     5.471    81.438     0.200
     5.471    80.375     0.200
     5.693    84.539     0.200
     5.693    83.500     0.200
     5.789    86.047     0.200
     5.789    84.781     0.200
     6.203    91.586     0.200
     6.645    98.094     0.200
     1.816    31.787     0.200
     1.926    34.703     0.200
     2.266    39.678     0.200
     2.420    40.900     0.200
     2.450    42.199     0.200
     2.644    45.139     0.200
     2.871    46.682     0.200
     3.022    48.043     0.200
     3.459    56.059     0.200
     3.832    59.736     0.200
     3.883    61.492     0.200
     4.634    70.369     0.200
     4.694    71.318     0.200
     4.730    72.107     0.200
     4.731    71.918     0.200
     4.731    71.482     0.200
     4.881    74.393     0.200
     4.881    73.799     0.200
     4.946    73.588     0.200
     5.000    75.648     0.200
     5.015    75.930     0.200
     5.015    75.721     0.200
     4.991    76.527     0.200
     4.991    75.904     0.200
     5.203    78.680     0.200
     5.203    78.414     0.200
     5.228    79.219     0.200
     5.266    79.039     0.200
     5.266    79.199     0.200
     5.810    86.959     0.200
     5.997    89.398     0.200
     6.368    94.369     0.200
     6.379    95.387     0.200
     6.437    95.857     0.200
     6.480    96.469     0.200
     6.839   100.898     0.200
     6.894   102.078     0.200
     2.114    35.738     0.200
     2.150    35.693     0.200
     2.767    44.959     0.200
     2.948    48.199     0.200
     3.501    55.514     0.200
     3.621    56.883     0.200
     3.745    57.686     0.200
     3.816    58.930     0.200
     3.909    61.088     0.200
     4.640    69.938     0.200
     2.079    35.367     0.200
     2.363    38.508     0.200
     2.193    36.305     0.200
     2.701    45.758     0.200
     2.938    47.484     0.200
     3.016    48.883     0.200
     3.271    53.289     0.200
     3.305    53.719     0.200
     3.443    55.086     0.200
     3.554    57.664     0.200
     3.737    57.562     0.200
     3.769    57.102     0.200
     3.748    59.789     0.200
     3.847    58.922     0.200
     3.968    62.047     0.200
     3.970    62.352     0.200
     4.210    64.203     0.200
     4.749    70.688     0.200
     5.013    75.500     0.200
     5.408    81.312     0.200
     5.480    81.867     0.200
     1.387    24.754     0.200
     2.134    35.141     0.200
     2.806    43.652     0.200
     2.941    49.383     0.200
     3.931    59.039     0.200
     4.265    64.453     0.200
     4.362    65.594     0.200
     4.662    70.055     0.200
     4.714    70.035     0.200
     4.896    73.254     0.200
     5.119    75.895     0.200
     5.116    75.672     0.200
     5.165    76.555     0.200
     5.455    80.797     0.200
     5.583    83.172     0.200
     6.004    86.234     0.200
     6.099    89.652     0.200
     6.378    93.645     0.200
     1.978    35.398     0.200
     2.182    37.453     0.200
     3.361    54.336     0.200
     5.234    78.508     0.200
     5.674    85.375     0.200
     5.780    86.977     0.200
     5.842    87.945     0.200
     7.123   104.945     0.200
     2.491    42.283     0.200
     2.796    46.395     0.200
     2.832    46.197     0.200
     4.571    70.121     0.200
     4.690    72.890     0.200
     6.033    89.263     0.200
     6.098    89.813     0.200
     6.158    91.113     0.200
     6.364    93.193     0.200
     6.404    94.563     0.200
     6.595    97.553     0.200
     6.815    99.493     0.200
     6.814    99.463     0.200
     7.246   106.143     0.200
     7.284   106.573     0.200
     7.692   109.693     0.200
     7.535   110.673     0.200
     7.802   113.733     0.200
     8.080   117.333     0.200
     8.318   120.983     0.200
     1.415    27.141     0.200
     1.498    28.727     0.200
     1.596    31.172     0.200
     1.961    35.531     0.200
     2.077    37.164     0.200
     2.649    46.094     0.200
     2.734    44.805     0.200
     2.734    44.031     0.200
     2.734    44.211     0.200
     2.597    47.047     0.200
     2.833    47.508     0.200
     2.641    46.250     0.200
     2.844    46.461     0.200
     2.844    46.086     0.200
     2.681    45.523     0.200
     2.922    49.242     0.200
     2.922    48.375     0.200
     3.120    51.742     0.200
     3.181    52.695     0.200
     3.183    52.609     0.200
     3.311    52.922     0.200
     3.311    53.648     0.200
     3.416    55.352     0.200
     3.348    54.523     0.200
     3.795    61.453     0.200
     3.653    59.008     0.200
     3.966    65.398     0.200
     4.114    66.336     0.200
     4.225    66.211     0.200
     4.225    66.438     0.200
     4.126    67.906     0.200
     4.247    66.336     0.200
     4.247    67.203     0.200
     4.326    67.203     0.200
     4.524    70.797     0.200
     4.405    70.305     0.200
     4.405    69.391     0.200
     4.604    72.008     0.200
     4.753    72.531     0.200
     4.753    72.875     0.200
     4.793    72.938     0.200
     4.793    73.297     0.200
     4.812    72.641     0.200
     4.812    73.555     0.200
     4.888    77.484     0.200
     4.888    76.195     0.200
     5.024    76.953     0.200
     5.024    77.336     0.200
     5.135    77.328     0.200
     5.135    77.891     0.200
     5.299    80.219     0.200
     5.313    79.781     0.200
     5.313    80.242     0.200
     5.313    80.453     0.200
     5.382    81.148     0.200
     5.382    81.297     0.200
     5.491    82.617     0.200
     5.496    83.188     0.200
     5.496    83.789     0.200
     5.555    83.875     0.200
     5.555    84.812     0.200
     5.629    85.031     0.200
     5.655    86.156     0.200
     5.612    86.648     0.200
     5.775    87.648     0.200
     5.775    87.391     0.200
     5.806    88.117     0.200
     5.838    87.836     0.200
     5.942    89.617     0.200
     6.295    94.570     0.200
     6.367    95.375     0.200
     1.650    31.643     0.200
     1.828    30.207     0.200
     2.133    35.377     0.200
     2.099    36.443     0.200
     2.235    37.514     0.200
     2.253    38.281     0.200
     2.342    37.535     0.200
     2.444    41.143     0.200
     2.774    44.533     0.200
     2.634    43.719     0.200
     2.745    44.477     0.200
     2.725    45.359     0.200
     2.725    43.455     0.200
     2.725    46.113     0.200
     2.974    48.371     0.200
     2.974    49.016     0.200
     3.090    51.721     0.200
     3.198    52.406     0.200
     3.351    53.176     0.200
     3.504    53.082     0.200
     3.504    53.533     0.200
     3.395    55.996     0.200
     3.395    55.615     0.200
     3.395    55.729     0.200
     3.672    57.223     0.200
     3.672    56.965     0.200
     3.798    58.504     0.200
     3.798    58.775     0.200
     3.651    59.225     0.200
     3.945    60.762     0.200
     3.945    61.830     0.200
     4.014    61.824     0.200
     4.014    62.180     0.200
     4.017    62.189     0.200
     4.017    61.492     0.200
     4.152    63.619     0.200
     4.154    64.221     0.200
     4.197    64.041     0.200
     4.197    64.180     0.200
     4.519    68.516     0.200
     4.429    70.146     0.200
     4.790    74.078     0.200
     4.886    73.977     0.200
     5.079    76.273     0.200
     5.079    76.721     0.200
     5.079    75.164     0.200
     5.079    75.613     0.200
     5.096    75.783     0.200
     5.081    76.176     0.200
     5.163    76.619     0.200
     5.163    76.916     0.200
     5.192    76.896     0.200
     5.192    76.785     0.200
     5.183    77.096     0.200
     5.313    78.912     0.200
     5.313    79.166     0.200
     5.526    81.977     0.200
     5.526    81.727     0.200
     5.553    81.432     0.200
     5.553    81.875     0.200
     5.553    82.545     0.200
     5.553    82.336     0.200
     5.587    81.873     0.200
     5.587    82.695     0.200
     5.581    82.105     0.200
     5.581    82.855     0.200
     5.778    84.736     0.200
     5.778    85.316     0.200
     5.798    86.025     0.200
     5.940    89.420     0.200
     5.940    90.201     0.200
     6.026    88.715     0.200
     6.107    89.031     0.200
     6.107    89.730     0.200
     6.047    89.775     0.200
     6.167    94.076     0.200
     6.264    91.566     0.200
     6.264    91.191     0.200
     6.264    91.785     0.200
     6.398    93.555     0.200
     6.398    93.176     0.200
     6.398    93.965     0.200
     6.397    93.525     0.200
     6.447    93.375     0.200
     6.447    94.887     0.200
     6.447    94.529     0.200
     6.447    95.096     0.200
     6.576    96.258     0.200
     6.576    94.727     0.200
     6.612    96.998     0.200
     6.544    96.875     0.200
     6.585    98.076     0.200
     6.810    99.057     0.200
     6.841    99.535     0.200
     7.130   103.885     0.200
     7.170   104.619     0.200
     7.170   104.355     0.200
     7.245   106.566     0.200
     7.245   105.125     0.200
     7.252   105.266     0.200
     7.270   107.275     0.200
     7.315   107.875     0.200
     7.419   108.076     0.200
     7.772   112.816     0.200
     7.783   112.316     0.200
     7.783   113.006     0.200
     7.880   114.096     0.200
     8.175   117.557     0.200
     8.378   120.625     0.200
     8.448   125.176     0.200
     8.647   124.855     0.200
     8.759   126.355     0.200
     8.778   126.426     0.200
     8.938   128.766     0.200
     9.069   130.305     0.200
     9.069   130.486     0.200
     9.136   131.455     0.200
     9.439   135.576     0.200
    10.349   149.426     0.200
    10.418   148.076     0.200
    11.474   162.576     0.200
    11.474   164.416     0.200
    13.734   195.756     0.200
    15.793   221.156     0.200
    17.103   236.785     0.200
    17.356   242.557     0.200
    18.753   260.115     0.200
    19.187   268.193     0.200
    19.753   271.896     0.200
    19.966   276.869     0.200
    19.972   274.055     0.200
    20.123   275.227     0.200
    20.147   275.445     0.200
    20.178   276.016     0.200
    20.242   276.705     0.200
    20.276   280.537     0.200
    20.546   280.646     0.200
    20.575   284.570     0.200
     1.759    30.588     0.200
     1.781    32.320     0.200
     2.186    39.452     0.200
     2.147    37.421     0.200
     2.569    45.036     0.200
     2.569    41.376     0.200
     2.733    43.780     0.200
     3.013    49.603     0.200
     3.554    56.443     0.200
     3.539    54.866     0.200
     4.789    71.111     0.200
     4.789    71.625     0.200
     4.861    72.875     0.200
     4.861    73.138     0.200
     4.942    74.024     0.200
     5.064    76.015     0.200
     5.089    76.655     0.200
     5.133    77.776     0.200
     5.133    76.866     0.200
     5.129    76.405     0.200
     5.175    77.705     0.200
     5.208    79.318     0.200
     5.263    79.998     0.200
     5.263    78.688     0.200
     5.362    80.015     0.200
     5.407    80.922     0.200
     5.425    81.075     0.200
     5.478    81.805     0.200
     5.667    84.555     0.200
     5.964    87.767     0.200
     5.989    88.795     0.200
     6.085    90.335     0.200
     6.192    92.064     0.200
     6.192    92.507     0.200
     6.687    98.205     0.200
     7.028   103.295     0.200
     7.102   103.925     0.200
     7.656   111.765     0.200
     8.324   121.305     0.200
     8.538   124.075     0.200
     8.647   125.445     0.200
     2.154    37.577     0.200
     2.585    44.523     0.200
     5.188    77.786     0.200
     5.214    77.806     0.200
     5.549    82.386     0.200
     5.601    84.306     0.200
     5.801    86.546     0.200
     5.826    87.006     0.200
     6.283    92.856     0.200
     6.412    94.937     0.200
     6.828   100.876     0.200
     6.852   101.116     0.200
     7.256   106.626     0.200
     7.267   107.376     0.200
     2.056    36.715     0.200
     2.831    47.875     0.200
     2.790    47.070     0.200
     5.353    80.883     0.200
     5.451    82.215     0.200
     5.748    86.602     0.200
     5.874    88.422     0.200
     5.992    89.742     0.200
     6.072    91.613     0.200
     6.227    92.984     0.200
     6.596    98.074     0.200
     6.669    99.203     0.200
     7.134   102.102     0.200
     7.157   105.844     0.200
     7.352   108.902     0.200
     7.654   112.922     0.200
     7.769   114.523     0.200
     1.377    25.778     0.200
     1.481    26.743     0.200
     1.463    27.039     0.200
     2.020    33.815     0.200
     2.020    35.486     0.200
     2.114    35.056     0.200
     2.401    39.919     0.200
     2.401    40.646     0.200
     2.661    44.509     0.200
     2.978    48.294     0.200
     2.978    49.253     0.200
     3.056    48.010     0.200
     3.405    54.376     0.200
     3.675    57.095     0.200
     3.675    57.806     0.200
     3.708    58.702     0.200
     3.790    58.414     0.200
     3.790    58.832     0.200
     3.805    58.515     0.200
     3.805    58.049     0.200
     3.882    60.218     0.200
     3.882    59.834     0.200
     4.006    63.341     0.200
     4.006    62.400     0.200
     4.011    61.619     0.200
     3.912    60.392     0.200
     4.121    62.490     0.200
     4.121    64.254     0.200
     4.145    64.614     0.200
     4.237    64.761     0.200
     4.237    65.464     0.200
     4.374    67.224     0.200
     4.387    66.844     0.200
     4.621    70.174     0.200
     4.778    71.859     0.200
     4.778    72.451     0.200
     4.774    73.109     0.200
     5.040    76.914     0.200
     5.040    76.405     0.200
     5.394    80.360     0.200
     5.439    81.476     0.200
     1.603    27.062     0.200
     1.683    28.452     0.200
     1.801    30.780     0.200
     1.788    29.483     0.200
     2.535    40.390     0.200
     2.640    42.841     0.200
     2.822    43.587     0.200
     3.733    57.043     0.200
     4.499    67.183     0.200
     4.672    70.555     0.200
     4.738    70.407     0.200
     4.769    71.584     0.200
     4.888    73.071     0.200
     4.997    73.825     0.200
     5.262    77.905     0.200
     5.554    80.972     0.200
     5.781    84.544     0.200
     6.139    89.165     0.200
     6.277    91.385     0.200
     6.296    90.863     0.200
     1.158    23.908     0.200
     1.385    25.334     0.200
     1.739    30.578     0.200
     1.663    29.994     0.200
     2.097    37.057     0.200
     2.224    37.004     0.200
     2.224    37.498     0.200
     2.316    39.443     0.200
     2.449    41.398     0.200
     2.410    40.980     0.200
     2.410    40.330     0.200
     2.821    46.225     0.200
     3.180    52.814     0.200
     3.459    53.762     0.200
     4.177    61.562     0.200
     5.484    81.168     0.200
     5.529    80.727     0.200
     5.545    81.295     0.200
     5.691    82.857     0.200
     5.691    85.520     0.200
     5.755    84.828     0.200
     5.784    86.689     0.200
     5.784    87.855     0.200
     5.800    85.127     0.200
     5.800    85.719     0.200
     6.015    88.109     0.200
     6.015    88.789     0.200
     6.050    88.850     0.200
     6.292    92.680     0.200
     6.567    95.916     0.200
     6.567    96.475     0.200
     6.609    95.916     0.200
     7.168   104.600     0.200
     7.294   106.430     0.200
     2.046    36.117     0.200
     2.132    37.723     0.200
     2.641    45.531     0.200
     3.516    57.617     0.200
     5.957    88.512     0.200
     6.055    90.340     0.200
     6.136    91.762     0.200
     6.231    92.430     0.200
     6.231    92.801     0.200
     6.352    94.570     0.200
     6.473    97.320     0.200
     6.595    97.602     0.200
     6.595    97.922     0.200
     6.684    99.559     0.200
     6.674    99.832     0.200
     6.829   101.039     0.200
     7.201   106.609     0.200
     7.273   107.148     0.200
     7.762   114.020     0.200
     7.938   117.551     0.200
     7.955   117.070     0.200
     8.259   121.691     0.200
     8.322   122.832     0.200
     8.372   123.309     0.200
     8.930   130.391     0.200
     9.624   140.730     0.200
     9.922   144.270     0.200
    10.236   148.941     0.200
    10.572   153.898     0.200
     1.599    29.369     0.200
     2.038    35.327     0.200
     2.231    38.059     0.200
     2.576    42.707     0.200
     3.026    48.782     0.200
     3.096    51.088     0.200
     3.281    53.443     0.200
     3.272    53.026     0.200
     3.680    58.521     0.200
     6.060    89.041     0.200
     6.142    90.321     0.200
     6.290    93.371     0.200
     6.371    94.121     0.200
     6.450    95.081     0.200
     6.609    97.241     0.200
     6.698    97.671     0.200
     6.698    98.031     0.200
     6.708    98.341     0.200
     6.937   101.201     0.200
     7.056   103.171     0.200
     7.277   106.191     0.200
     7.365   107.881     0.200
     7.490   109.961     0.200
     7.838   113.851     0.200
     7.988   116.331     0.200
     8.061   117.501     0.200
     8.322   120.871     0.200
     8.404   121.961     0.200
     8.958   129.861     0.200
     1.119    22.486     0.200
     1.472    25.820     0.200
     1.618    28.689     0.200
     2.024    34.596     0.200
     2.530    41.551     0.200
     2.688    43.613     0.200
     2.729    43.688     0.200
     3.525    55.129     0.200
     5.021    75.107     0.200
     1.284    27.115     0.200
     1.307    25.694     0.200
     1.353    26.466     0.200
     1.352    26.745     0.200
     1.429    27.835     0.200
     1.538    29.396     0.200
     1.607    30.217     0.200
     1.638    30.736     0.200
     1.768    32.724     0.200
     1.693    31.680     0.200
     1.898    33.688     0.200
     2.022    34.341     0.200
     1.986    35.839     0.200
     2.117    38.104     0.200
     2.545    42.989     0.200
     3.030    49.456     0.200
     5.381    80.160     0.200
     5.381    80.918     0.200
     5.488    82.309     0.200
     5.537    83.088     0.200
     5.571    83.401     0.200
     5.638    84.278     0.200
     5.638    84.408     0.200
     5.702    85.130     0.200
     5.778    86.168     0.200
     5.881    87.918     0.200
     6.019    89.548     0.200
     6.019    89.729     0.200
     6.010    89.711     0.200
     6.139    91.302     0.200
     6.139    91.688     0.200
     6.198    92.190     0.200
     6.250    92.588     0.200
     6.361    94.389     0.200
     6.637    98.958     0.200
     6.700    99.948     0.200
     7.151   102.099     0.200
     7.198   106.258     0.200
     7.417   109.139     0.200
     7.701   113.118     0.200
     7.834   114.818     0.200
     1.225    22.230     0.200
     1.492    26.410     0.200
     1.791    30.195     0.200
     2.248    35.629     0.200
     5.701    83.672     0.200
     5.983    87.980     0.200
     6.377    93.441     0.200
     6.448    93.852     0.200
     7.342   104.004     0.200
     0.836    18.617     0.200
     0.835    17.734     0.200
     1.082    21.156     0.200
     1.082    22.031     0.200
     1.191    24.406     0.200
     2.191    35.914     0.200
     2.397    39.648     0.200
     2.397    38.945     0.200
     2.614    42.039     0.200
     2.614    41.602     0.200
     2.673    42.719     0.200
     3.091    48.547     0.200
     3.434    55.320     0.200
     3.434    53.719     0.200
     3.533    53.703     0.200
     3.533    54.062     0.200
     3.582    54.688     0.200
     3.611    54.656     0.200
     3.611    55.133     0.200
     3.610    54.711     0.200
     3.608    57.719     0.200
     3.812    57.734     0.200
     3.812    58.672     0.200
     3.879    58.922     0.200
     3.892    58.195     0.200
     3.892    58.953     0.200
     3.908    59.320     0.200
     3.908    59.438     0.200
     3.928    60.133     0.200
     3.987    60.906     0.200
     3.987    61.195     0.200
     4.080    61.109     0.200
     4.080    61.688     0.200
     4.085    61.805     0.200
     4.149    62.570     0.200
     4.160    62.672     0.200
     4.186    63.758     0.200
     4.406    66.141     0.200
     4.533    67.797     0.200
     4.632    69.781     0.200
     4.632    70.164     0.200
     4.690    69.375     0.200
     4.690    69.977     0.200
     4.802    71.742     0.200
     4.787    72.312     0.200
     4.872    72.477     0.200
     4.872    73.289     0.200
     5.246    77.594     0.200
     5.358    79.750     0.200
     5.368    79.633     0.200
     5.371    79.133     0.200
     5.548    82.391     0.200
     5.561    82.391     0.200
     5.563    82.391     0.200
     5.715    84.328     0.200
     5.772    85.461     0.200
     5.808    85.953     0.200
     5.839    86.312     0.200
     6.324    93.094     0.200
     6.987   102.562     0.200
     7.126   104.258     0.200
     7.204   105.297     0.200
     7.314   106.852     0.200
     7.588   110.367     0.200
     7.723   111.812     0.200
     7.842   113.328     0.200
     9.117   130.633     0.200
     1.195    23.805     0.200
     1.429    26.180     0.200
     1.448    26.914     0.200
     1.552    28.758     0.200
     1.660    30.445     0.200
     1.653    29.570     0.200
     2.189    34.531     0.200
     3.534    53.312     0.200
     3.582    54.055     0.200
     3.611    54.086     0.200
     3.611    54.500     0.200
     3.609    54.086     0.200
     3.810    58.453     0.200
     3.810    57.547     0.200
     3.894    58.641     0.200
     3.894    59.031     0.200
     3.908    58.734     0.200
     3.908    58.836     0.200
     3.929    59.359     0.200
     3.984    61.219     0.200
     3.984    60.445     0.200
     4.079    60.344     0.200
     4.079    61.023     0.200
     4.151    61.703     0.200
     4.160    61.945     0.200
     4.186    63.133     0.200
     4.407    65.359     0.200
     4.534    67.094     0.200
     4.631    68.547     0.200
     4.631    69.109     0.200
     4.691    69.461     0.200
     4.802    71.055     0.200
     4.784    71.289     0.200
     4.872    72.258     0.200
     4.872    72.086     0.200
     5.247    76.844     0.200
     5.357    79.461     0.200
     5.367    78.516     0.200
     5.369    78.961     0.200
     5.549    81.570     0.200
     5.559    81.312     0.200
     5.560    81.805     0.200
     5.715    83.719     0.200
     5.771    84.766     0.200
     5.807    85.195     0.200
     5.840    85.570     0.200
     6.324    92.289     0.200
     7.587   110.070     0.200
     2.082    37.973     0.200
     2.463    43.168     0.200
     2.888    48.395     0.200
     5.392    82.340     0.200
     5.419    83.199     0.200
     5.676    86.691     0.200
     5.768    88.070     0.200
     5.916    90.410     0.200
     6.058    91.848     0.200
     6.254    94.270     0.200
     7.042   102.141     0.200
     7.102   106.109     0.200
     7.334   109.691     0.200
     1.574    27.682     0.200
     1.639    29.163     0.200
     1.710    29.694     0.200
     2.081    35.130     0.200
     2.163    37.712     0.200
     2.232    38.342     0.200
     2.380    41.179     0.200
     3.021    49.457     0.200
     2.936    47.187     0.200
     3.530    57.924     0.200
     4.193    66.597     0.200
     4.558    71.194     0.200
     4.613    71.446     0.200
     4.732    71.947     0.200
     4.906    72.928     0.200
     4.926    73.989     0.200
     5.229    78.409     0.200
     5.267    78.479     0.200
     5.386    79.459     0.200
     5.589    82.500     0.200
     5.724    85.152     0.200
     5.901    87.179     0.200
     5.951    88.109     0.200
     6.045    89.669     0.200
     6.104    90.129     0.200
     6.456    95.169     0.200
     6.484    95.799     0.200
     6.852   101.299     0.200
     6.901   101.729     0.200
     7.103   104.000     0.200
     7.777   114.139     0.200
     1.598    31.285     0.200
     1.881    35.094     0.200
     2.039    36.703     0.200
     2.391    42.008     0.200
     5.324    81.188     0.200
     5.438    82.707     0.200
     5.455    82.730     0.200
     5.528    84.074     0.200
     5.721    86.867     0.200
     5.807    88.090     0.200
     6.023    91.004     0.200
     6.111    92.340     0.200
     6.188    92.660     0.200
     6.233    93.207     0.200
     6.296    94.250     0.200
     6.644    99.359     0.200
     6.686    99.695     0.200
     7.083   102.527     0.200
     7.148   106.090     0.200
     7.279   108.539     0.200
     8.994   130.508     0.200
     1.346    25.539     0.200
     2.167    37.812     0.200
     2.573    43.733     0.200
     5.305    79.605     0.200
     5.593    83.836     0.200
     5.963    88.806     0.200
     6.064    89.836     0.200
     6.174    91.716     0.200
     6.455    96.086     0.200
     6.515    97.735     0.200
     6.964   100.455     0.200
     2.165    38.969     0.200
     2.592    43.479     0.200
     5.200    78.920     0.200
     5.308    79.850     0.200
     5.355    81.479     0.200
     5.455    82.670     0.200
     5.596    84.229     0.200
     5.837    87.840     0.200
     5.963    90.229     0.200
     6.068    90.789     0.200
     6.179    92.740     0.200
     6.457    97.299     0.200
     6.519    98.389     0.200
     6.969   101.240     0.200
     1.522    28.364     0.200
     1.581    28.839     0.200
     2.434    41.892     0.200
     2.915    46.312     0.200
     3.049    50.749     0.200
     3.347    55.275     0.200
     3.821    61.179     0.200
     4.834    73.474     0.200
     4.860    73.685     0.200
     5.634    84.096     0.200
     1.257    25.637     0.200
     1.489    26.680     0.200
     1.572    27.406     0.200
     1.627    27.637     0.200
     2.244    40.049     0.200
     2.318    40.146     0.200
     2.527    42.045     0.200
     2.656    43.553     0.200
     2.941    45.973     0.200
     2.941    46.777     0.200
     3.045    50.869     0.200
     2.999    48.041     0.200
     3.057    47.584     0.200
     3.135    49.217     0.200
     3.135    49.850     0.200
     3.246    51.135     0.200
     3.246    51.771     0.200
     3.384    53.230     0.200
     3.384    54.092     0.200
     3.300    53.531     0.200
     3.480    56.447     0.200
     3.559    57.754     0.200
     3.669    59.285     0.200
     3.772    60.375     0.200
     3.921    61.984     0.200
     4.107    64.545     0.200
     4.055    62.658     0.200
     4.475    68.834     0.200
     4.475    69.342     0.200
     4.534    68.754     0.200
     4.534    69.369     0.200
     4.598    70.238     0.200
     4.662    70.672     0.200
     4.662    70.924     0.200
     4.843    72.746     0.200
     4.867    73.383     0.200
     4.867    72.932     0.200
     4.869    73.604     0.200
     5.081    78.391     0.200
     5.160    77.043     0.200
     5.160    77.654     0.200
     5.208    78.074     0.200
     5.230    80.398     0.200
     5.274    79.104     0.200
     5.334    79.754     0.200
     5.334    79.514     0.200
     5.333    80.393     0.200
     5.416    80.934     0.200
     5.458    81.303     0.200
     5.535    82.303     0.200
     5.652    84.078     0.200
     5.652    84.836     0.200
     5.706    84.854     0.200
     5.842    86.764     0.200
     5.886    86.809     0.200
     5.886    87.574     0.200
     5.975    88.418     0.200
     5.975    89.104     0.200
     5.975    87.834     0.200
     6.039    89.965     0.200
     6.383    94.623     0.200
     6.417    94.713     0.200
     6.584    97.385     0.200
     6.831   100.604     0.200
     7.352   108.223     0.200
     7.531   111.338     0.200
     1.936    32.408     0.200
     1.936    32.103     0.200
     2.260    36.937     0.200
     2.516    40.317     0.200
     2.548    40.798     0.200
     2.548    39.431     0.200
     2.750    44.128     0.200
     2.859    44.729     0.200
     2.859    45.177     0.200
     3.121    48.961     0.200
     3.369    53.522     0.200
     3.534    55.028     0.200
     3.534    54.262     0.200
     3.867    60.458     0.200
     3.886    59.016     0.200
     3.899    59.378     0.200
     3.920    59.195     0.200
     3.920    59.561     0.200
     3.924    60.681     0.200
     4.025    61.577     0.200
     4.153    62.965     0.200
     4.153    63.490     0.200
     4.212    64.578     0.200
     4.228    64.278     0.200
     4.231    62.898     0.200
     4.262    64.828     0.200
     4.364    65.545     0.200
     4.364    65.758     0.200
     4.346    65.140     0.200
     4.481    67.158     0.200
     4.482    67.908     0.200
     4.728    70.688     0.200
     4.857    72.918     0.200
     4.908    72.887     0.200
     4.908    73.390     0.200
     5.164    76.458     0.200
     5.164    76.948     0.200
     5.164    76.826     0.200
     5.550    82.258     0.200
     5.582    82.646     0.200
     5.638    82.928     0.200
     6.011    88.128     0.200
     6.049    88.698     0.200
     7.244   106.278     0.200
     7.835   112.958     0.200
     7.957   114.948     0.200
     8.254   120.078     0.200
     1.697    31.281     0.200
     1.876    33.125     0.200
     4.516    68.984     0.200
     4.565    69.949     0.200
     4.864    73.547     0.200
     4.866    72.891     0.200
     5.173    77.457     0.200
     5.207    77.320     0.200
     5.841    86.730     0.200
     5.988    88.578     0.200
     6.401    94.598     0.200
     6.426    94.988     0.200
     1.138    20.645     0.200
     1.571    28.586     0.200
     1.854    33.129     0.200
     1.840    32.402     0.200
     1.915    33.406     0.200
     1.878    32.879     0.200
     2.121    35.934     0.200
     2.236    38.387     0.200
     2.236    37.461     0.200
     2.220    38.234     0.200
     2.267    37.055     0.200
     2.508    40.840     0.200
     2.784    45.062     0.200
     3.036    48.082     0.200
     4.152    63.516     0.200
     4.213    65.184     0.200
     4.142    64.816     0.200
     4.326    66.672     0.200
     4.540    66.406     0.200
     4.583    69.246     0.200
     4.603    70.562     0.200
     5.278    77.523     0.200
     5.477    79.078     0.200
     6.053    87.645     0.200
     6.166    89.055     0.200
     6.183    89.195     0.200
     6.253    90.641     0.200
     6.269    91.316     0.200
     6.292    90.934     0.200
     6.292    91.375     0.200
     6.393    91.754     0.200
     6.450    92.418     0.200
     6.450    93.164     0.200
     6.536    94.824     0.200
     6.689    96.375     0.200
     6.689    96.484     0.200
     6.699    96.645     0.200
     6.798    97.785     0.200
     6.828    97.754     0.200
     6.828    98.203     0.200
     6.878    98.645     0.200
     6.918    99.055     0.200
     7.026   100.637     0.200
     7.316   105.496     0.200
     7.576   107.762     0.200
     7.576   108.543     0.200
     7.813   108.676     0.200
     7.876   113.094     0.200
     8.009   114.656     0.200
     8.009   115.355     0.200
     8.105   115.844     0.200
     8.381   119.594     0.200
     8.420   120.863     0.200
     8.522   121.703     0.200
     9.797   139.465     0.200
    10.072   143.324     0.200
    10.419   148.355     0.200
     1.412    27.289     0.200
     1.543    28.625     0.200
     2.229    38.141     0.200
     2.204    38.773     0.200
     2.520    42.492     0.200
     3.276    52.477     0.200
     3.342    54.555     0.200
     4.590    71.414     0.200
     4.967    75.703     0.200
     5.765    87.492     0.200
     1.590    29.406     0.200
     1.906    34.848     0.200
     2.076    37.371     0.200
     2.366    41.547     0.200
     2.456    43.116     0.200
     2.620    45.102     0.200
     2.941    47.733     0.200
     2.941    48.145     0.200
     3.054    50.710     0.200
     3.371    54.263     0.200
     3.371    54.162     0.200
     3.342    55.449     0.200
     3.461    54.263     0.200
     3.823    62.150     0.200
     3.960    63.727     0.200
     4.082    65.167     0.200
     4.466    70.020     0.200
     4.534    70.872     0.200
     4.534    70.546     0.200
     4.865    73.285     0.200
     4.865    74.683     0.200
     4.891    74.689     0.200
     4.895    74.421     0.200
     4.895    75.059     0.200
     5.173    78.680     0.200
     5.173    78.979     0.200
     5.118    79.403     0.200
     5.232    79.299     0.200
     5.303    80.679     0.200
     5.481    82.809     0.200
     5.564    84.269     0.200
     5.662    85.636     0.200
     5.865    87.649     0.200
     5.904    87.879     0.200
     5.989    89.894     0.200
     5.989    91.019     0.200
     6.434    95.859     0.200
     6.583    98.877     0.200
     6.845   102.009     0.200
     1.386    25.332     0.200
     1.633    28.059     0.200
     1.966    33.900     0.200
     2.155    36.693     0.200
     2.438    42.248     0.200
     2.557    42.080     0.200
     2.772    45.734     0.200
     2.692    44.463     0.200
     2.692    43.855     0.200
     2.899    47.748     0.200
     2.817    46.045     0.200
     2.888    46.066     0.200
     3.347    54.066     0.200
     3.543    55.305     0.200
     3.655    56.475     0.200
     3.655    56.066     0.200
     3.686    56.854     0.200
     4.899    72.332     0.200
     4.899    72.947     0.200
     4.962    73.836     0.200
     4.962    74.074     0.200
     5.002    74.189     0.200
     5.002    74.562     0.200
     5.009    74.658     0.200
     5.009    75.098     0.200
     5.158    76.719     0.200
     5.158    77.041     0.200
     5.196    78.678     0.200
     5.196    77.295     0.200
     5.255    77.826     0.200
     5.262    77.980     0.200
     5.262    78.262     0.200
     5.281    77.797     0.200
     5.281    78.607     0.200
     5.480    80.518     0.200
     5.480    81.387     0.200
     5.485    81.637     0.200
     5.532    81.598     0.200
     5.532    81.957     0.200
     5.900    86.877     0.200
     5.998    87.965     0.200
     6.031    88.129     0.200
     6.031    88.971     0.200
     6.082    88.787     0.200
     6.186    90.896     0.200
     6.272    91.309     0.200
     6.272    92.496     0.200
     6.640    97.178     0.200
     6.649    96.801     0.200
     6.649    98.141     0.200
     6.714    98.266     0.200
     6.758    99.256     0.200
     7.113   103.688     0.200
     7.172   104.807     0.200
     7.723   112.736     0.200
     8.378   121.807     0.200
     8.712   126.137     0.200
     9.241   132.867     0.200
     1.585    29.572     0.200
     1.765    31.533     0.200
     2.010    35.766     0.200
     2.106    39.592     0.200
     2.278    39.201     0.200
     2.419    40.916     0.200
     2.469    42.221     0.200
     2.560    42.980     0.200
     2.561    44.184     0.200
     2.850    46.830     0.200
     2.936    47.096     0.200
     3.011    48.475     0.200
     3.011    47.803     0.200
     3.154    51.729     0.200
     3.159    52.701     0.200
     3.370    55.758     0.200
     3.370    54.189     0.200
     3.477    56.688     0.200
     3.477    55.271     0.200
     3.532    59.521     0.200
     3.590    57.465     0.200
     3.592    58.852     0.200
     3.623    57.482     0.200
     3.785    61.510     0.200
     3.905    61.959     0.200
     4.116    63.027     0.200
     4.223    66.648     0.200
     4.560    72.076     0.200
     4.601    72.076     0.200
     4.601    71.738     0.200
     4.697    72.688     0.200
     4.697    72.252     0.200
     4.858    73.502     0.200
     4.858    73.174     0.200
     4.869    74.604     0.200
     4.874    74.193     0.200
     4.874    74.426     0.200
     4.913    76.139     0.200
     5.194    78.793     0.200
     5.194    79.174     0.200
     5.214    78.996     0.200
     5.214    79.514     0.200
     5.317    81.564     0.200
     5.317    80.021     0.200
     5.324    81.635     0.200
     5.433    82.943     0.200
     5.465    82.934     0.200
     5.529    83.914     0.200
     5.694    86.320     0.200
     5.694    85.627     0.200
     5.848    88.033     0.200
     5.908    88.055     0.200
     6.009    90.188     0.200
     6.009    90.604     0.200
     6.009    89.906     0.200
     6.058    91.014     0.200
     6.426    96.385     0.200
     6.443    96.225     0.200
     6.652    99.293     0.200
     6.824   101.764     0.200
     6.865   102.414     0.200
     7.061   104.965     0.200
     7.751   115.113     0.200
     7.917   117.424     0.200
     1.204    23.250     0.200
     1.314    23.969     0.200
     1.377    25.242     0.200
     1.946    33.195     0.200
     2.665    43.211     0.200
     5.558    83.008     0.200
     5.658    83.898     0.200
     5.835    86.117     0.200
     6.250    91.820     0.200
     6.296    92.867     0.200
     6.757    99.906     0.200
     7.184   101.938     0.200
     7.522   109.477     0.200
     1.108    21.727     0.200
     1.180    23.227     0.200
     5.335    79.410     0.200
     5.432    80.719     0.200
     5.523    82.289     0.200
     5.614    83.648     0.200
     5.729    85.289     0.200
     6.054    90.238     0.200
     6.322    93.098     0.200
     7.115   100.629     0.200
     7.139   104.641     0.200
     7.335   107.301     0.200
     1.125    19.141     0.200
     1.125    19.664     0.200
     1.794    30.297     0.200
     1.945    32.086     0.200
     2.143    35.391     0.200
     2.527    41.539     0.200
     2.557    39.984     0.200
     2.666    40.484     0.200
     2.670    41.102     0.200
     3.063    46.797     0.200
     3.327    50.148     0.200
     3.327    48.711     0.200
     4.030    60.969     0.200
     4.030    58.727     0.200
     4.207    62.430     0.200
     4.207    62.047     0.200
     4.345    63.398     0.200
     4.378    63.172     0.200
     4.423    65.352     0.200
     4.352    64.141     0.200
     4.352    63.938     0.200
     4.660    68.562     0.200
     4.689    68.875     0.200
     4.689    68.219     0.200
     4.688    67.727     0.200
     4.755    70.102     0.200
     4.755    70.273     0.200
     4.822    70.750     0.200
     4.904    71.648     0.200
     4.904    71.055     0.200
     5.023    73.641     0.200
     5.110    74.984     0.200
     5.391    78.516     0.200
     5.391    77.422     0.200
     5.906    81.734     0.200
     6.238    89.188     0.200
     6.282    89.789     0.200
     1.291    24.047     0.200
     1.318    25.192     0.200
     1.651    30.463     0.200
     1.903    35.317     0.200
     2.136    37.398     0.200
     2.131    37.814     0.200
     2.189    38.100     0.200
     2.189    36.427     0.200
     2.400    41.143     0.200
     2.682    45.581     0.200
     2.957    47.662     0.200
     3.020    49.188     0.200
     4.456    67.199     0.200
     4.487    67.549     0.200
     4.589    69.469     0.200
     4.832    72.709     0.200
     4.978    74.509     0.200
     5.110    76.236     0.200
     5.139    76.769     0.200
     5.316    79.349     0.200
     5.365    80.270     0.200
     5.540    82.063     0.200
     5.607    83.889     0.200
     5.716    84.753     0.200
     6.105    87.559     0.200
     6.411    94.159     0.200
     1.426    26.688     0.200
     1.882    33.422     0.200
     2.048    36.203     0.200
     2.048    35.703     0.200
     2.405    42.102     0.200
     2.645    45.555     0.200
     2.694    46.766     0.200
     2.941    48.812     0.200
     2.941    48.922     0.200
     3.065    49.953     0.200
     3.119    50.305     0.200
     3.293    53.898     0.200
     3.417    54.617     0.200
     3.923    61.852     0.200
     4.751    71.414     0.200
     4.751    71.812     0.200
     4.805    73.180     0.200
     4.805    72.641     0.200
     4.805    73.508     0.200
     4.934    75.547     0.200
     5.023    76.133     0.200
     5.078    77.219     0.200
     5.078    78.172     0.200
     5.127    77.719     0.200
     5.129    78.289     0.200
     5.293    79.672     0.200
     5.353    81.039     0.200
     5.752    86.281     0.200
     5.838    87.102     0.200
     6.567    97.055     0.200
     6.936   102.508     0.200
     6.979   103.273     0.200
     1.652    30.697     0.200
     1.652    30.697     0.200
     1.841    33.793     0.200
     1.977    35.029     0.200
     2.191    39.775     0.200
     2.177    36.875     0.200
     2.367    41.219     0.200
     2.736    46.023     0.200
     2.840    46.787     0.200
     2.840    46.980     0.200
     2.947    48.727     0.200
     2.948    48.438     0.200
     3.606    58.818     0.200
     3.744    61.234     0.200
     3.769    60.607     0.200
     3.769    60.193     0.200
     3.961    61.020     0.200
     3.961    61.787     0.200
     3.961    61.846     0.200
     3.961    61.607     0.200
     4.301    66.787     0.200
     4.281    67.002     0.200
     4.281    67.527     0.200
     4.551    70.947     0.200
     4.789    73.621     0.200
     4.935    76.049     0.200
     4.991    76.908     0.200
     4.881    76.490     0.200
     4.881    77.129     0.200
     5.282    80.336     0.200
     5.522    84.578     0.200
     5.923    89.729     0.200
     5.952    90.367     0.200
     1.495    27.078     0.200
     1.568    28.047     0.200
     1.755    31.078     0.200
     1.755    31.234     0.200
     4.044    61.648     0.200
     4.043    62.086     0.200
     4.043    61.383     0.200
     4.384    66.508     0.200
     4.359    66.352     0.200
     5.071    76.586     0.200
     5.597    83.930     0.200
     5.998    89.250     0.200
     1.543    28.564     0.200
     1.580    27.361     0.200
     1.903    31.895     0.200
     2.143    38.773     0.200
     2.712    46.066     0.200
     3.170    52.105     0.200
     3.817    60.830     0.200
     4.511    68.232     0.200
     4.526    68.033     0.200
     4.884    74.033     0.200
     1.081    20.695     0.200
     1.237    22.852     0.200
     1.319    23.602     0.200
     1.319    23.008     0.200
     1.429    25.508     0.200
     1.564    28.359     0.200
     2.201    37.961     0.200
     2.283    39.836     0.200
     2.290    38.523     0.200
     2.468    40.109     0.200
     2.443    39.891     0.200
     2.443    39.578     0.200
     2.515    39.984     0.200
     3.336    49.781     0.200
     3.602    55.312     0.200
     4.496    66.445     0.200
     4.584    67.180     0.200
     4.584    67.625     0.200
     4.727    69.227     0.200
     4.727    69.516     0.200
     4.727    69.398     0.200
     4.805    70.656     0.200
     4.888    72.031     0.200
     5.010    73.547     0.200
     5.010    73.656     0.200
     5.042    74.375     0.200
     5.135    75.188     0.200
     5.185    76.133     0.200
     5.185    76.297     0.200
     5.195    76.133     0.200
     5.210    76.586     0.200
     5.373    78.344     0.200
     5.491    80.047     0.200
     5.725    83.578     0.200
     5.725    83.812     0.200
     5.752    83.789     0.200
     5.752    84.055     0.200
     5.806    84.984     0.200
     5.954    86.992     0.200
     5.954    86.625     0.200
     6.287    87.391     0.200
     6.286    91.273     0.200
     6.286    91.094     0.200
     6.466    93.922     0.200
     6.495    93.820     0.200
     6.495    94.234     0.200
     6.495    94.008     0.200
     6.563    95.039     0.200
     6.579    94.844     0.200
     6.777    98.547     0.200
     6.883    99.695     0.200
     1.056    21.209     0.200
     1.457    26.233     0.200
     1.758    31.841     0.200
     1.869    32.420     0.200
     1.937    33.749     0.200
     1.934    36.077     0.200
     2.023    34.033     0.200
     2.038    33.615     0.200
     2.027    36.006     0.200
     2.511    43.229     0.200
     2.701    44.081     0.200
     2.701    43.976     0.200
     2.701    44.081     0.200
     2.712    45.004     0.200
     2.630    43.754     0.200
     2.891    46.672     0.200
     2.890    47.431     0.200
     2.890    46.265     0.200
     3.173    48.954     0.200
     3.235    51.733     0.200
     3.322    51.840     0.200
     3.322    51.665     0.200
     3.546    55.176     0.200
     3.546    55.353     0.200
     3.742    58.944     0.200
     3.742    58.472     0.200
     3.767    57.896     0.200
     3.769    58.846     0.200
     3.793    58.106     0.200
     3.764    57.582     0.200
     3.992    64.134     0.200
     4.399    68.958     0.200
     4.729    72.241     0.200
     4.729    72.519     0.200
     4.836    72.241     0.200
     4.980    74.096     0.200
     4.980    73.731     0.200
     4.981    73.890     0.200
     4.981    74.112     0.200
     4.991    74.096     0.200
     4.991    73.985     0.200
     5.330    79.042     0.200
     5.330    79.198     0.200
     5.332    79.248     0.200
     5.357    80.825     0.200
     5.424    81.233     0.200
     5.581    82.369     0.200
     5.581    82.250     0.200
     5.537    84.194     0.200
     5.633    82.631     0.200
     5.837    86.667     0.200
     5.964    87.559     0.200
     6.036    88.934     0.200
     6.036    88.481     0.200
     6.087    90.896     0.200
     6.146    90.788     0.200
     6.146    90.642     0.200
     6.279    92.804     0.200
     6.575    96.110     0.200
     1.622    27.750     0.200
     1.508    25.500     0.200
     1.795    30.785     0.200
     1.883    32.387     0.200
     1.879    30.727     0.200
     1.882    30.938     0.200
     2.008    36.789     0.200
     2.310    37.723     0.200
     2.162    38.617     0.200
     2.503    41.141     0.200
     2.743    45.332     0.200
     2.690    43.992     0.200
     3.000    46.938     0.200
     3.000    47.430     0.200
     3.162    50.492     0.200
     3.053    50.996     0.200
     3.448    54.355     0.200
     3.502    54.734     0.200
     3.546    55.180     0.200
     3.476    55.375     0.200
     3.747    59.602     0.200
     3.689    58.598     0.200
     3.944    61.840     0.200
     4.284    67.359     0.200
     4.570    69.680     0.200
     4.636    69.512     0.200
     4.767    70.922     0.200
     4.767    70.684     0.200
     4.772    70.547     0.200
     4.772    70.797     0.200
     4.780    70.340     0.200
     4.780    71.109     0.200
     4.745    73.137     0.200
     5.118    75.723     0.200
     5.118    76.070     0.200
     5.130    76.344     0.200
     5.196    76.344     0.200
     5.196    76.965     0.200
     5.196    76.148     0.200
     5.219    79.535     0.200
     5.348    78.660     0.200
     5.370    79.352     0.200
     5.370    79.582     0.200
     5.370    78.887     0.200
     5.419    81.070     0.200
     5.457    82.844     0.200
     5.618    83.109     0.200
     5.640    83.383     0.200
     5.752    84.633     0.200
     5.752    84.930     0.200
     5.944    87.941     0.200
     5.944    88.102     0.200
     5.944    87.223     0.200
     5.944    87.590     0.200
     5.936    86.980     0.200
     5.936    88.645     0.200
     5.973    88.051     0.200
     6.370    93.312     0.200
     6.370    93.613     0.200
     6.373    93.762     0.200
     6.760    98.125     0.200
     6.775    98.930     0.200
     7.321   107.121     0.200
     7.703   111.812     0.200
     1.873    32.633     0.200
     1.939    33.516     0.200
     2.137    36.633     0.200
     4.819    72.484     0.200
     4.831    72.258     0.200
     5.176    77.219     0.200
     5.251    78.648     0.200
     5.264    78.352     0.200
     5.803    85.562     0.200
     5.990    88.594     0.200
     6.022    88.617     0.200
     6.417    94.703     0.200
     6.846   100.055     0.200
     1.245    24.400     0.200
     1.347    26.006     0.200
     1.804    32.203     0.200
     1.804    31.605     0.200
     2.344    39.359     0.200
     2.311    39.359     0.200
     2.458    39.645     0.200
     2.387    39.650     0.200
     2.573    43.096     0.200
     2.624    42.293     0.200
     2.624    41.988     0.200
     2.896    45.891     0.200
     3.197    52.145     0.200
     3.292    51.586     0.200
     3.292    50.715     0.200
     3.274    52.824     0.200
     3.429    53.703     0.200
     3.429    53.930     0.200
     3.459    53.994     0.200
     3.561    57.730     0.200
     3.561    55.252     0.200
     3.590    56.305     0.200
     3.591    58.180     0.200
     3.840    57.881     0.200
     3.840    58.156     0.200
     3.840    57.533     0.200
     3.889    58.746     0.200
     3.889    58.896     0.200
     3.889    58.396     0.200
     3.907    59.379     0.200
     3.907    58.316     0.200
     3.918    59.080     0.200
     3.862    60.260     0.200
     4.183    64.688     0.200
     4.193    62.676     0.200
     4.193    64.006     0.200
     4.193    62.383     0.200
     4.215    64.025     0.200
     4.215    64.176     0.200
     4.215    63.369     0.200
     4.231    64.727     0.200
     4.231    64.436     0.200
     4.225    64.475     0.200
     4.225    64.621     0.200
     4.255    64.152     0.200
     4.283    64.775     0.200
     4.380    65.824     0.200
     4.380    66.457     0.200
     4.454    67.736     0.200
     4.454    67.393     0.200
     4.467    66.727     0.200
     4.467    68.236     0.200
     4.467    66.947     0.200
     4.713    70.197     0.200
     4.929    73.346     0.200
     4.929    73.549     0.200
     5.004    75.148     0.200
     5.109    76.236     0.200
     5.175    77.707     0.200
     5.175    77.527     0.200
     5.175    78.199     0.200
     5.552    82.287     0.200
     5.612    82.408     0.200
     5.598    84.559     0.200
     5.636    83.443     0.200
     5.657    84.307     0.200
     5.793    84.906     0.200
     5.793    84.695     0.200
     5.855    86.506     0.200
     5.855    85.996     0.200
     6.019    89.086     0.200
     6.070    89.906     0.200
     6.088    89.676     0.200
     6.541    95.648     0.200
     7.277   106.906     0.200
     8.008   115.232     0.200
     1.352    25.379     0.200
     1.329    24.941     0.200
     1.934    34.059     0.200
     2.073    35.336     0.200
     2.348    39.426     0.200
     2.808    46.906     0.200
     3.228    53.375     0.200
     3.890    60.363     0.200
     5.543    83.246     0.200
     5.543    82.820     0.200
     5.667    85.457     0.200
     5.667    85.562     0.200
     5.826    87.695     0.200
     6.122    91.414     0.200
     6.215    91.848     0.200
     6.293    93.078     0.200
     6.401    95.695     0.200
     6.790    99.977     0.200
     7.188   102.918     0.200
     7.253   106.547     0.200
     1.192    23.577     0.200
     1.192    23.108     0.200
     1.816    30.597     0.200
     2.367    39.918     0.200
     2.465    39.491     0.200
     2.765    45.019     0.200
     3.053    48.962     0.200
     3.941    61.536     0.200
     4.078    62.664     0.200
     4.096    61.004     0.200
     4.478    67.635     0.200
     4.727    70.794     0.200
     4.933    73.294     0.200
     5.066    75.334     0.200
     5.288    78.845     0.200
     5.702    84.834     0.200
     5.734    84.604     0.200
     1.048    21.506     0.200
     1.133    22.592     0.200
     1.217    24.244     0.200
     1.882    32.205     0.200
     2.593    43.674     0.200
     2.770    45.465     0.200
     3.189    51.113     0.200
     3.215    52.291     0.200
     3.358    55.494     0.200
     3.468    55.455     0.200
     3.638    57.893     0.200
     3.638    57.660     0.200
     3.860    61.566     0.200
     4.377    66.582     0.200
     5.325    78.660     0.200
     5.225    77.803     0.200
     5.225    77.549     0.200
     5.325    79.143     0.200
     5.325    78.961     0.200
     5.512    81.414     0.200
     5.401    79.602     0.200
     5.407    80.273     0.200
     5.407    79.859     0.200
     5.500    81.373     0.200
     5.500    80.885     0.200
     5.620    83.109     0.200
     5.512    81.656     0.200
     5.620    83.473     0.200
     5.620    83.324     0.200
     5.798    85.652     0.200
     5.742    85.014     0.200
     5.742    84.734     0.200
     5.798    85.762     0.200
     5.956    87.771     0.200
     5.864    86.473     0.200
     5.864    85.889     0.200
     5.975    88.406     0.200
     5.955    87.883     0.200
     5.956    88.084     0.200
     5.975    88.072     0.200
     6.098    89.703     0.200
     6.211    91.164     0.200
     6.526    96.035     0.200
     6.526    95.385     0.200
     6.542    96.113     0.200
     6.716    98.494     0.200
     6.716    98.080     0.200
     7.004    98.713     0.200
     6.758    99.107     0.200
     7.206   105.383     0.200
     7.206   105.137     0.200
     7.236   105.543     0.200
     7.352   107.062     0.200
     7.361   106.164     0.200
     7.531   109.744     0.200
     7.546   109.500     0.200
     7.652   111.564     0.200
     7.771   112.707     0.200
     8.914   129.074     0.200
     8.914   127.977     0.200
     9.668   138.756     0.200
     1.870    34.202     0.200
     2.356    41.249     0.200
     2.529    43.595     0.200
     2.609    45.680     0.200
     2.572    45.045     0.200
     2.602    44.181     0.200
     2.691    45.039     0.200
     2.691    45.301     0.200
     2.907    49.838     0.200
     2.907    50.205     0.200
     3.058    50.624     0.200
     3.230    54.154     0.200
     3.296    54.457     0.200
     3.296    55.327     0.200
     3.296    53.616     0.200
     3.371    55.442     0.200
     3.588    58.077     0.200
     3.588    57.334     0.200
     3.563    59.140     0.200
     3.563    58.503     0.200
     3.932    63.549     0.200
     4.023    64.117     0.200
     4.023    62.122     0.200
     4.097    66.419     0.200
     4.156    66.557     0.200
     4.267    68.678     0.200
     4.267    67.233     0.200
     4.447    69.291     0.200
     4.465    70.455     0.200
     4.538    71.666     0.200
     4.605    71.878     0.200
     4.660    73.202     0.200
     5.170    80.229     0.200
     5.150    80.886     0.200
     5.203    81.061     0.200
     5.426    83.928     0.200
     5.512    84.077     0.200
     5.559    85.058     0.200
     5.512    84.480     0.200
     5.614    86.029     0.200
     5.697    86.077     0.200
     5.811    87.815     0.200
     5.811    88.263     0.200
     5.811    87.461     0.200
     5.829    87.815     0.200
     5.832    88.358     0.200
     5.832    87.463     0.200
     5.832    87.983     0.200
     6.152    93.980     0.200
     6.168    92.843     0.200
     6.196    94.421     0.200
     6.185    93.713     0.200
     6.192    92.833     0.200
     6.213    92.997     0.200
     6.213    94.026     0.200
     6.213    93.289     0.200
     6.213    93.603     0.200
     6.238    94.149     0.200
     6.238    95.013     0.200
     6.406    97.053     0.200
     6.420    95.553     0.200
     6.420    96.193     0.200
     6.453    96.758     0.200
     6.453    97.403     0.200
     6.669   100.633     0.200
     6.699    99.865     0.200
     6.801   101.723     0.200
     6.903   104.250     0.200
     7.010   105.774     0.200
     7.006   104.835     0.200
     7.006   104.227     0.200
     7.006   104.553     0.200
     7.030   105.523     0.200
     7.431   109.600     0.200
     7.432   110.273     0.200
     7.832   115.973     0.200
     7.862   116.073     0.200
     1.100    22.660     0.200
     1.340    26.178     0.200
     1.685    31.000     0.200
     2.276    39.385     0.200
     2.276    40.012     0.200
     2.411    40.811     0.200
     2.562    42.646     0.200
     2.843    46.137     0.200
     2.924    48.664     0.200
     3.037    49.523     0.200
     3.108    51.242     0.200
     3.187    51.672     0.200
     3.505    55.752     0.200
     3.505    55.111     0.200
     3.557    56.205     0.200
     3.813    61.838     0.200
     3.728    59.760     0.200
     4.092    65.170     0.200
     4.193    65.773     0.200
     4.300    67.730     0.200
     4.429    68.941     0.200
     4.534    70.975     0.200
     4.665    71.557     0.200
     4.913    74.139     0.200
     4.959    74.746     0.200
     4.959    74.938     0.200
     4.858    75.547     0.200
     4.983    75.188     0.200
     5.165    78.289     0.200
     5.301    79.346     0.200
     5.478    81.488     0.200
     5.478    82.004     0.200
     5.478    82.549     0.200
     5.496    82.656     0.200
     5.627    84.203     0.200
     5.666    85.389     0.200
     5.794    86.648     0.200
     5.892    88.455     0.200
     5.931    87.809     0.200
     5.931    88.369     0.200
     5.977    89.049     0.200
     5.977    89.518     0.200
     6.098    91.068     0.200
     6.351    94.229     0.200
     6.264    95.203     0.200
     6.441    95.918     0.200
     6.830   100.658     0.200
     1.411    23.997     0.200
     1.669    28.467     0.200
     1.725    30.239     0.200
     2.029    34.904     0.200
     2.463    41.345     0.200
     2.698    43.803     0.200
     2.760    43.230     0.200
     2.760    45.454     0.200
     2.760    43.887     0.200
     2.887    46.808     0.200
     3.201    49.847     0.200
     3.322    53.901     0.200
     3.946    61.577     0.200
     3.946    61.477     0.200
     3.964    61.928     0.200
     3.995    62.009     0.200
     4.108    63.681     0.200
     4.282    66.445     0.200
     4.282    64.728     0.200
     4.508    68.024     0.200
     4.519    67.387     0.200
     4.519    67.499     0.200
     4.519    68.244     0.200
     4.524    67.387     0.200
     4.524    68.065     0.200
     4.524    68.394     0.200
     4.849    72.188     0.200
     4.849    72.714     0.200
     4.863    71.905     0.200
     4.863    72.828     0.200
     4.917    73.754     0.200
     4.918    74.904     0.200
     4.970    74.614     0.200
     4.975    73.999     0.200
     5.083    75.814     0.200
     5.180    77.094     0.200
     5.353    79.813     0.200
     5.363    79.794     0.200
     5.497    80.374     0.200
     5.497    81.324     0.200
     5.663    83.579     0.200
     5.663    85.203     0.200
     5.663    84.411     0.200
     5.663    84.534     0.200
     5.708    84.664     0.200
     6.086    90.034     0.200
     6.096    90.044     0.200
     6.520    96.214     0.200
     1.262    21.679     0.200
     1.990    32.102     0.200
     2.373    37.879     0.200
     3.473    51.152     0.200
     3.509    52.057     0.200
     3.509    51.902     0.200
     4.092    59.922     0.200
     5.154    75.762     0.200
     1.727    29.625     0.200
     2.042    33.375     0.200
     2.671    41.016     0.200
     2.896    46.734     0.200
     2.873    45.242     0.200
     3.041    46.344     0.200
     2.938    46.562     0.200
     3.536    54.219     0.200
     3.893    58.555     0.200
     4.084    61.219     0.200
     1.968    32.867     0.200
     1.961    34.305     0.200
     1.961    32.305     0.200
     2.500    42.031     0.200
     3.458    54.125     0.200
     3.568    55.953     0.200
     3.910    59.180     0.200
     4.827    71.703     0.200
     4.888    72.727     0.200
     5.072    76.430     0.200
     5.175    78.070     0.200
     5.188    77.773     0.200
     5.400    80.742     0.200
     5.460    81.570     0.200
     5.828    86.414     0.200
     5.950    87.727     0.200
     6.194    91.016     0.200
     1.836    30.555     0.200
     2.302    37.389     0.200
     2.469    39.746     0.200
     2.660    42.762     0.200
     3.579    53.193     0.200
     3.514    54.775     0.200
     3.596    53.758     0.200
     3.633    56.529     0.200
     3.644    55.773     0.200
     3.788    56.004     0.200
     3.907    58.182     0.200
     3.957    59.184     0.200
     4.159    61.604     0.200
     4.619    67.955     0.200
     0.696    14.758     0.200
     0.961    18.836     0.200
     1.708    28.758     0.200
     1.708    28.195     0.200
     2.237    37.156     0.200
     2.437    39.023     0.200
     2.461    38.703     0.200
     2.537    40.773     0.200
     2.741    44.352     0.200
     2.866    44.852     0.200
     2.967    47.180     0.200
     3.139    48.562     0.200
     3.139    48.891     0.200
     3.531    54.281     0.200
     4.183    60.961     0.200
     4.183    62.648     0.200
     4.183    62.828     0.200
     4.220    62.531     0.200
     4.227    62.367     0.200
     4.227    63.039     0.200
     4.360    64.836     0.200
     4.449    65.062     0.200
     4.449    66.648     0.200
     4.449    65.484     0.200
     4.409    65.062     0.200
     4.409    65.344     0.200
     4.497    66.906     0.200
     4.505    66.562     0.200
     4.505    67.656     0.200
     4.552    67.266     0.200
     4.552    67.922     0.200
     4.697    69.266     0.200
     4.725    69.961     0.200
     4.756    70.141     0.200
     5.250    76.469     0.200
     5.250    77.023     0.200
     5.324    77.742     0.200
     5.488    79.766     0.200
     5.488    80.734     0.200
     5.488    80.219     0.200
     5.857    84.836     0.200
     5.940    87.359     0.200
     5.940    86.062     0.200
     5.967    86.805     0.200
     1.511    26.062     0.200
     1.591    26.678     0.200
     1.552    26.938     0.200
     1.753    29.986     0.200
     2.288    36.201     0.200
     2.288    35.607     0.200
     2.658    41.369     0.200
     2.658    41.799     0.200
     2.829    45.084     0.200
     3.023    46.875     0.200
     3.620    55.877     0.200
     3.679    57.930     0.200
     3.873    58.951     0.200
     4.092    59.932     0.200
     4.092    60.623     0.200
     4.092    59.701     0.200
     4.111    62.041     0.200
     4.111    62.680     0.200
     4.214    63.088     0.200
     4.275    64.699     0.200
     4.557    68.334     0.200
     4.916    71.594     0.200
     5.122    74.883     0.200
     1.323    26.251     0.200
     1.971    35.388     0.200
     1.971    35.271     0.200
     2.540    43.787     0.200
     3.109    50.480     0.200
     3.143    52.821     0.200
     3.524    57.187     0.200
     3.618    58.942     0.200
     4.134    66.050     0.200
     5.350    80.668     0.200
     5.433    82.299     0.200
     5.433    80.862     0.200
     5.900    88.035     0.200
     6.346    94.406     0.200
     6.569    96.553     0.200
     1.912    33.047     0.200
     2.209    36.523     0.200
     2.209    35.703     0.200
     2.429    40.297     0.200
     2.969    47.172     0.200
     3.251    50.609     0.200
     3.500    53.727     0.200
     3.794    59.000     0.200
     3.794    58.383     0.200
     3.841    59.805     0.200
     4.313    64.672     0.200
     4.313    65.367     0.200
     4.428    66.695     0.200
     4.458    67.102     0.200
     4.458    66.859     0.200
     4.502    68.852     0.200
     4.520    68.312     0.200
     4.520    67.891     0.200
     4.515    69.109     0.200
     4.559    68.938     0.200
     4.559    68.539     0.200
     4.693    69.531     0.200
     4.693    69.961     0.200
     4.711    71.148     0.200
     4.711    70.867     0.200
     4.803    72.156     0.200
     4.865    74.148     0.200
     4.877    74.281     0.200
     5.113    76.617     0.200
     5.287    78.953     0.200
     5.346    79.656     0.200
     5.346    79.523     0.200
     5.526    83.922     0.200
     5.579    82.500     0.200
     5.690    83.703     0.200
     5.690    83.531     0.200
     5.848    86.297     0.200
     6.138    89.992     0.200
     6.182    90.258     0.200
     6.273    91.211     0.200
     6.623    96.844     0.200
     6.713    97.672     0.200
     6.925   101.812     0.200
     6.997   101.680     0.200
     8.543   122.828     0.200
     1.577    31.215     0.200
     1.734    32.715     0.200
     3.857    62.271     0.200
     4.012    62.746     0.200
     4.012    65.727     0.200
     4.112    66.934     0.200
     4.410    69.186     0.200
     4.524    69.387     0.200
     4.539    70.422     0.200
     4.780    71.717     0.200
     4.780    73.977     0.200
     4.851    73.787     0.200
     4.851    74.504     0.200
     4.910    74.047     0.200
     4.910    75.916     0.200
     5.053    77.596     0.200
     5.126    77.670     0.200
     5.126    78.936     0.200
     5.307    80.518     0.200
     5.411    81.293     0.200
     5.411    81.686     0.200
     5.400    80.775     0.200
     5.400    81.656     0.200
     5.468    82.588     0.200
     5.468    83.855     0.200
     5.527    82.070     0.200
     5.527    83.885     0.200
     5.527    83.225     0.200
     5.527    83.576     0.200
     5.530    83.623     0.200
     5.530    83.736     0.200
     5.530    83.225     0.200
     5.639    85.176     0.200
     5.710    85.693     0.200
     5.710    86.416     0.200
     5.791    86.469     0.200
     5.791    86.736     0.200
     5.768    87.504     0.200
     5.769    88.805     0.200
     6.076    91.904     0.200
     6.146    91.646     0.200
     6.215    92.805     0.200
     6.379    95.266     0.200
     6.364    95.010     0.200
     6.364    94.785     0.200
     6.433    95.529     0.200
     6.681    99.676     0.200
     6.681    99.410     0.200
     6.791   100.963     0.200
     6.791   100.625     0.200
     6.952   102.518     0.200
     6.952   103.135     0.200
     6.952   102.955     0.200
     7.097   105.105     0.200
     7.170   105.623     0.200
     7.240   107.174     0.200
     7.233   107.434     0.200
     7.357   107.951     0.200
     7.357   109.584     0.200
     7.692   112.352     0.200
     7.744   113.266     0.200
     7.744   114.916     0.200
     7.744   113.127     0.200
     7.753   115.199     0.200
     7.753   116.615     0.200
     7.941   115.199     0.200
     7.941   116.316     0.200
     7.941   115.926     0.200
     8.465   123.740     0.200
     8.465   124.146     0.200
     8.793   128.139     0.200
     8.845   128.656     0.200
     8.947   128.398     0.200
     9.110   132.539     0.200
     9.193   134.609     0.200
     9.454   137.197     0.200
     9.503   136.666     0.200
     9.456   137.715     0.200
     9.456   139.426     0.200
     9.502   136.939     0.200
     9.650   141.406     0.200
     9.959   145.096     0.200
     9.959   144.916     0.200
    10.102   142.893     0.200
    10.280   149.727     0.200
    11.487   167.385     0.200
    12.233   176.055     0.200
    13.616   195.641     0.200
    13.982   198.135     0.200
    19.954   275.789     0.200
    20.290   279.312     0.200
    20.330   279.562     0.200
    20.361   279.803     0.200
    20.576   282.424     0.200
    20.593   282.381     0.200
    21.245   289.494     0.200
     1.655    31.596     0.200
     1.655    31.576     0.200
     1.073    24.158     0.200
     2.138    37.414     0.200
     2.911    49.250     0.200
     2.911    46.215     0.200
     3.058    49.480     0.200
     3.878    61.551     0.200
     3.933    61.121     0.200
     4.142    65.121     0.200
     4.189    65.805     0.200
     4.282    67.082     0.200
     4.455    68.928     0.200
     4.455    69.570     0.200
     4.489    68.928     0.200
     4.801    73.281     0.200
     4.801    74.400     0.200
     5.019    76.594     0.200
     5.598    80.541     0.200
     5.736    86.701     0.200
     1.913    33.877     0.200
     1.913    33.719     0.200
     1.913    33.428     0.200
     2.739    45.686     0.200
     2.739    44.744     0.200
     2.812    45.756     0.200
     2.866    48.129     0.200
     2.866    47.607     0.200
     2.866    46.197     0.200
     3.018    48.088     0.200
     3.272    52.258     0.200
     3.272    51.262     0.200
     3.295    53.537     0.200
     3.388    54.229     0.200
     3.410    53.479     0.200
     3.641    57.258     0.200
     3.641    56.016     0.200
     3.744    58.771     0.200
     3.744    58.656     0.200
     3.747    58.480     0.200
     3.747    57.500     0.200
     3.902    59.992     0.200
     3.902    59.164     0.200
     4.030    62.078     0.200
     4.160    65.111     0.200
     4.160    63.361     0.200
     4.269    67.205     0.200
     4.270    66.152     0.200
     4.672    69.475     0.200
     4.672    70.438     0.200
     4.731    70.758     0.200
     4.731    71.348     0.200
     4.765    71.975     0.200
     4.765    70.621     0.200
     4.767    72.031     0.200
     4.767    71.346     0.200
     4.910    74.416     0.200
     4.910    73.619     0.200
     4.930    77.324     0.200
     4.985    74.883     0.200
     4.985    73.715     0.200
     4.994    74.768     0.200
     5.017    76.336     0.200
     5.017    76.568     0.200
     5.017    75.188     0.200
     5.038    75.229     0.200
     5.052    75.986     0.200
     5.052    74.975     0.200
     5.238    77.785     0.200
     5.238    78.607     0.200
     5.267    78.721     0.200
     5.267    78.607     0.200
     5.303    79.824     0.200
     5.303    78.957     0.200
     5.303    79.238     0.200
     5.341    80.398     0.200
     5.548    82.379     0.200
     5.561    83.809     0.200
     5.561    84.184     0.200
     5.673    84.088     0.200
     5.673    84.889     0.200
     5.758    86.572     0.200
     5.787    85.816     0.200
     5.787    85.297     0.200
     5.847    87.309     0.200
     5.847    87.150     0.200
     5.953    88.639     0.200
     6.032    89.189     0.200
     6.032    89.438     0.200
     6.032    88.484     0.200
     6.032    89.328     0.200
     6.199    94.539     0.200
     6.199    93.289     0.200
     6.405    94.828     0.200
     6.405    94.617     0.200
     6.404    94.365     0.200
     6.405    94.365     0.200
     6.466    94.947     0.200
     6.515    96.219     0.200
     6.570    95.865     0.200
     6.570    97.098     0.200
     6.686    99.076     0.200
     6.686    98.240     0.200
     6.686    99.357     0.200
     6.874   100.908     0.200
     6.928   101.988     0.200
     6.932   101.402     0.200
     7.390   108.027     0.200
     7.479   108.957     0.200
     7.479   109.428     0.200
     7.479   109.148     0.200
     7.510   109.951     0.200
     7.857   114.809     0.200
     8.131   118.035     0.200
     8.131   118.268     0.200
     8.357   121.648     0.200
     8.468   122.918     0.200
     8.720   126.318     0.200
     8.858   128.229     0.200
    10.688   153.357     0.200
    12.229   175.496     0.200
    16.760   235.008     0.200
     6.571    96.768     0.200
    12.229   174.707     0.200
     2.493    39.512     0.200
     2.538    39.381     0.200
     2.538    38.887     0.200
     2.748    43.426     0.200
     2.748    43.221     0.200
     2.987    45.410     0.200
     2.987    45.721     0.200
     3.127    47.742     0.200
     3.127    48.328     0.200
     3.250    50.195     0.200
     3.353    51.990     0.200
     3.741    57.482     0.200
     4.014    62.381     0.200
     4.081    61.139     0.200
     4.081    60.383     0.200
     4.125    60.109     0.200
     4.125    60.475     0.200
     4.125    60.297     0.200
     4.140    62.555     0.200
     4.147    61.084     0.200
     4.147    60.268     0.200
     4.146    60.381     0.200
     4.482    65.934     0.200
     4.482    65.521     0.200
     4.482    66.037     0.200
     4.504    66.447     0.200
     4.538    66.824     0.200
     4.538    66.686     0.200
     4.542    66.586     0.200
     4.559    67.217     0.200
     4.724    69.336     0.200
     4.734    68.627     0.200
     4.771    69.383     0.200
     4.771    69.566     0.200
     4.982    72.957     0.200
     5.063    73.711     0.200
     5.063    72.963     0.200
     5.115    73.576     0.200
     5.115    74.697     0.200
     5.213    75.812     0.200
     5.213    75.117     0.200
     5.291    79.771     0.200
     5.291    78.857     0.200
     5.348    77.576     0.200
     5.348    77.078     0.200
     5.348    77.686     0.200
     5.759    83.057     0.200
     5.796    83.807     0.200
     6.124    88.312     0.200
     6.201    89.117     0.200
     6.722    97.227     0.200
     6.743    97.186     0.200
     7.133   102.496     0.200
     7.355   105.486     0.200
     7.612   108.586     0.200
     8.099   115.436     0.200
     8.400   120.486     0.200
     1.495    27.766     0.200
     1.822    32.805     0.200
     2.734    44.082     0.200
     3.511    54.277     0.200
     3.388    55.262     0.200
     3.579    55.059     0.200
     3.627    55.621     0.200
     3.681    55.730     0.200
     3.959    60.582     0.200
     4.100    62.121     0.200
     4.146    63.129     0.200
     4.137    62.996     0.200
     4.174    63.609     0.200
     4.512    67.117     0.200
     4.700    69.965     0.200
     4.803    72.496     0.200
     4.916    74.051     0.200
     5.267    78.406     0.200
     5.524    82.445     0.200
     5.510    81.023     0.200
     5.551    83.754     0.200
     6.269    94.793     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.600    51.305     0.200
     3.212    62.305     0.200
     4.327    79.305     0.200
     4.815    91.992     0.200
     2.882    53.419     0.200
     3.309    63.819     0.200
     6.081   119.419     0.200
     2.751    52.121     0.200
     2.760    50.121     0.200
     5.042    93.121     0.200
     6.586   123.121     0.200
     7.009   132.215     0.200
     2.803    53.049     0.200
     2.846    54.349     0.200
     2.665    49.367     0.200
     3.230    58.875     0.200
     3.352    60.875     0.200
     4.436    79.875     0.200
     4.638    84.875     0.200
     2.721    51.082     0.200
     3.507    67.322     0.200
     4.121    79.322     0.200
     4.427    81.932     0.200
     4.279    78.973     0.200
     4.384    82.973     0.200
     3.107    57.895     0.200
     2.672    51.422     0.200
     2.920    56.498     0.200
     2.514    46.301     0.200
     2.982    54.426     0.200
     2.865    52.461     0.200
     2.912    57.898     0.200
     4.868    87.812     0.200
     3.034    59.156     0.200
     2.692    50.135     0.200
     3.629    67.984     0.200
     4.067    78.156     0.200
     4.291    81.086     0.200
     2.964    57.727     0.200
     3.402    64.105     0.200
     2.793    53.674     0.200
     3.046    56.674     0.200
     3.483    70.867     0.200
     4.645    83.898     0.200
     4.651    90.898     0.200
     3.260    60.781     0.200
     3.258    61.055     0.200
     4.335    82.898     0.200
     4.457    83.020     0.200
     2.795    52.869     0.200
     3.088    60.570     0.200
     2.873    55.258     0.200
     2.715    51.227     0.200
     2.881    53.922     0.200
     2.565    47.658     0.200
     3.554    67.576     0.200
     2.691    50.916     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.376    26.305     0.200
     4.327    76.305     0.200
     0.743    14.992     0.200
     1.458    29.992     0.200
     2.146    41.992     0.200
     2.374    44.992     0.200
     4.815    83.992     0.200
     0.614    12.828     0.200
     2.016    37.828     0.200
     1.672    31.419     0.200
     1.672    32.919     0.200
     2.017    38.419     0.200
     2.357    43.419     0.200
     0.189     5.621     0.200
     1.822    33.422     0.200
     2.751    47.121     0.200
     6.586   109.121     0.200
     0.603    12.215     0.200
     1.183    19.215     0.200
     3.055    54.215     0.200
     7.009   119.215     0.200
     0.609    13.648     0.200
     1.205    20.547     0.200
     1.769    34.047     0.200
     2.250    41.820     0.200
     4.957    83.520     0.200
     5.533    93.020     0.200
     5.533    94.020     0.200
     5.533    96.020     0.200
     0.149     5.688     0.200
     0.701    15.387     0.200
     1.070    20.188     0.200
     0.773    15.906     0.200
     0.998    21.008     0.200
     0.764    15.414     0.200
     0.779    15.914     0.200
     0.822    17.414     0.200
     0.899    19.914     0.200
     1.054    20.914     0.200
     0.523    12.549     0.200
     0.674    13.849     0.200
     1.198    23.849     0.200
     1.120    23.349     0.200
     1.557    30.349     0.200
     1.684    32.349     0.200
     1.704    32.349     0.200
     1.879    35.849     0.200
     1.917    34.629     0.200
     2.369    42.439     0.200
     2.434    44.349     0.200
     0.646    12.594     0.200
     0.746    16.391     0.200
     0.943    18.594     0.200
     1.128    22.594     0.200
     1.412    26.094     0.200
     1.486    28.094     0.200
     1.574    28.594     0.200
     1.642    30.594     0.200
     1.761    31.594     0.200
     2.083    37.297     0.200
     0.215     4.566     0.200
     0.274     6.066     0.200
     0.826    17.066     0.200
     1.138    22.867     0.200
     1.361    25.867     0.200
     1.644    29.867     0.200
     1.738    31.867     0.200
     2.046    36.867     0.200
     2.950    52.066     0.200
     0.645    14.664     0.200
     0.830    15.965     0.200
     0.956    18.664     0.200
     1.297    26.164     0.200
     0.220     5.018     0.200
     0.792    16.018     0.200
     1.205    22.018     0.200
     2.154    40.527     0.200
     2.110    38.018     0.200
     0.756    15.453     0.200
     1.890    36.453     0.200
     5.854   100.652     0.200
     0.700    14.852     0.200
     1.693    31.852     0.200
     1.693    32.852     0.200
     3.251    56.852     0.200
     0.783    15.791     0.200
     3.231    56.490     0.200
     0.906    17.236     0.200
     1.790    33.537     0.200
     0.667    13.947     0.200
     0.456    10.055     0.200
     2.064    37.670     0.200
     2.358    41.030     0.200
     0.750    15.761     0.200
     2.208    37.398     0.200
     2.293    38.539     0.200
     2.386    40.059     0.200
     2.422    40.859     0.200
     0.577    11.922     0.200
     2.150    40.422     0.200
     0.610    12.182     0.200
     0.897    19.398     0.200
     1.103    21.398     0.200
     1.392    25.898     0.200
     0.360     8.178     0.200
     1.374    26.074     0.200
     1.378    26.078     0.200
     0.705    14.633     0.200
     1.153    23.633     0.200
     1.243    24.633     0.200
     1.807    34.633     0.200
     2.021    37.633     0.200
     2.103    39.633     0.200
     2.301    42.633     0.200
     0.167     4.656     0.200
     1.059    22.156     0.200
     1.990    37.875     0.200
     1.091    20.883     0.200
     0.155     3.617     0.200
     0.424     8.617     0.200
     1.555    30.117     0.200
     1.792    33.617     0.200
     0.140     3.266     0.200
     0.461     8.766     0.200
     0.130     3.473     0.200
     0.390     8.973     0.200
     0.836    17.473     0.200
     1.055    21.473     0.200
     1.214    23.973     0.200
     1.880    36.973     0.200
     0.404    10.164     0.200
     0.651    13.977     0.200
     0.798    16.367     0.200
     1.110    23.367     0.200
     1.125    22.367     0.200
     2.157    41.367     0.200
     0.562    11.609     0.200
     0.946    18.461     0.200
     0.991    20.461     0.200
     1.051    20.461     0.200
     1.402    26.461     0.200
     0.766    16.609     0.200
     0.855    17.609     0.200
     0.983    20.609     0.200
     1.155    22.609     0.200
     1.352    25.609     0.200
     0.754    15.898     0.200
     0.804    16.898     0.200
     1.049    20.898     0.200
     1.191    23.898     0.200
     0.359     8.543     0.200
     0.842    16.543     0.200
     0.976    18.543     0.200
     1.280    24.543     0.200
     0.313     7.535     0.200
     0.815    15.535     0.200
     0.947    18.035     0.200
     1.082    20.535     0.200
     1.054    21.535     0.200
     1.166    22.535     0.200
     1.263    23.535     0.200
     0.765    16.020     0.200
     0.771    17.020     0.200
     0.996    20.020     0.200
     0.843    16.875     0.200
     0.926    18.012     0.200
     1.337    26.875     0.200
     1.966    35.875     0.200
     3.567    62.875     0.200
     5.421    92.875     0.200
     5.433    92.875     0.200
     0.104     2.570     0.200
     0.377     9.070     0.200
     0.866    17.570     0.200
     1.333    25.570     0.200
     1.425    28.070     0.200
     0.926    18.932     0.200
     1.332    26.322     0.200
     0.184     5.120     0.200
     1.064    20.620     0.200
     1.087    21.620     0.200
     2.032    40.030     0.200
     0.212     5.531     0.200
     0.569    11.531     0.200
     1.227    23.531     0.200
     1.053    20.531     0.200
     1.485    28.531     0.200
     2.105    37.531     0.200
     0.117     5.320     0.200
     0.626    14.320     0.200
     1.520    28.820     0.200
     1.594    28.320     0.200
     1.987    35.320     0.200
     0.345     7.084     0.200
     0.603    13.584     0.200
     1.062    20.584     0.200
     1.008    20.584     0.200
     0.943    21.584     0.200
     0.977    19.664     0.200
     1.116    22.664     0.200
     1.276    24.664     0.200
     0.662    11.867     0.200
     0.471    10.867     0.200
     0.885    18.867     0.200
     1.088    20.367     0.200
     1.290    24.867     0.200
     1.657    28.836     0.200
     2.404    42.496     0.200
     2.409    42.469     0.200
     0.599    12.692     0.200
     0.599    13.692     0.200
     1.028    22.692     0.200
     1.028    21.692     0.200
     1.232    24.692     0.200
     0.148     3.930     0.200
     0.305     6.930     0.200
     0.568    12.242     0.200
     0.884    18.930     0.200
     0.970    19.930     0.200
     1.296    24.930     0.200
     1.284    24.930     0.200
     1.449    27.930     0.200
     1.643    30.828     0.200
     0.275     7.062     0.200
     0.775    14.562     0.200
     0.964    18.562     0.200
     1.270    24.062     0.200
     1.204    24.562     0.200
     1.737    32.562     0.200
     2.277    39.562     0.200
     2.327    41.062     0.200
     0.553    11.715     0.200
     0.537    11.715     0.200
     1.181    22.715     0.200
     1.269    24.715     0.200
     1.439    28.215     0.200
     1.657    30.715     0.200
     1.807    33.715     0.200
     1.924    35.215     0.200
     2.099    40.516     0.200
     0.258     6.734     0.200
     0.757    15.734     0.200
     1.197    22.234     0.200
     1.404    26.734     0.200
     1.820    33.734     0.200
     2.010    35.734     0.200
     2.119    38.734     0.200
     2.119    38.031     0.200
     0.285     6.467     0.200
     1.331    25.467     0.200
     1.537    28.467     0.200
     1.530    28.967     0.200
     1.701    30.467     0.200
     1.600    28.768     0.200
     1.979    36.467     0.200
     0.286     6.791     0.200
     0.518    10.791     0.200
     1.351    27.291     0.200
     1.541    29.291     0.200
     1.553    30.791     0.200
     0.464    10.312     0.200
     0.581    12.312     0.200
     1.087    22.312     0.200
     1.240    24.312     0.200
     1.342    27.312     0.200
     0.250     5.992     0.200
     0.447     9.992     0.200
     0.714    14.992     0.200
     1.247    23.992     0.200
     1.471    27.992     0.200
     0.406     9.105     0.200
     0.874    17.605     0.200
     0.937    20.605     0.200
     1.336    25.605     0.200
     1.648    31.605     0.200
     0.610    12.586     0.200
     0.610    12.086     0.200
     0.554    12.586     0.200
     0.554    12.086     0.200
     1.183    23.586     0.200
     1.537    30.586     0.200
     0.672    15.070     0.200
     0.807    17.070     0.200
     1.020    20.070     0.200
     1.152    22.070     0.200
     1.150    22.070     0.200
     1.503    28.070     0.200
     1.642    30.070     0.200
     0.233     4.617     0.200
     0.368     7.617     0.200
     1.278    24.617     0.200
     1.618    30.617     0.200
     0.308     7.252     0.200
     0.636    13.252     0.200
     0.917    19.252     0.200
     1.254    24.252     0.200
     1.813    33.252     0.200
     0.775    17.508     0.200
     0.844    18.008     0.200
     1.039    21.008     0.200
     1.427    27.008     0.200
     1.559    29.008     0.200
     0.953    19.062     0.200
     0.779    17.562     0.200
     0.858    18.562     0.200
     1.045    19.562     0.200
     1.268    26.562     0.200
     1.435    28.562     0.200
     1.563    28.562     0.200
     1.914    34.562     0.200
     0.301     6.539     0.200
     0.396     8.539     0.200
     1.457    28.539     0.200
     0.201     4.609     0.200
     0.832    17.109     0.200
     0.984    19.609     0.200
     1.315    25.609     0.200
     1.340    26.109     0.200
     1.833    34.609     0.200
     0.560    12.199     0.200
     0.695    14.199     0.200
     0.954    19.199     0.200
     0.968    19.199     0.200
     1.684    31.199     0.200
     0.432     9.525     0.200
     0.862    17.525     0.200
     0.753    14.525     0.200
     1.117    22.525     0.200
     0.289     6.406     0.200
     0.497    10.406     0.200
     1.332    25.406     0.200
     1.534    28.906     0.200
     0.668    14.422     0.200
     0.832    16.422     0.200
     0.876    17.922     0.200
     0.967    19.422     0.200
     0.073     2.285     0.200
     0.621    13.285     0.200
     0.970    20.086     0.200
     1.663    31.285     0.200
     0.195     3.676     0.200
     0.666    14.676     0.200
     0.972    20.676     0.200
     1.734    31.676     0.200
     1.996    35.676     0.200
     0.457     9.990     0.200
     0.580    11.990     0.200
     1.303    24.990     0.200
     1.418    26.050     0.200
     1.418    27.402     0.200
     1.545    28.990     0.200
     1.386    25.990     0.200
     2.210    38.990     0.200
     2.576    45.990     0.200
     0.301     6.289     0.200
     0.518    11.289     0.200
     0.654    13.789     0.200
     1.211    23.289     0.200
     1.541    29.289     0.200
     0.550    12.613     0.200
     1.100    21.613     0.200
     1.295    26.113     0.200
     1.453    28.113     0.200
     1.482    29.613     0.200
     1.943    36.113     0.200
     0.242     6.383     0.200
     0.806    17.383     0.200
     1.294    24.383     0.200
     1.721    33.383     0.200
     0.276     5.875     0.200
     0.329     6.875     0.200
     1.588    29.875     0.200
     0.662    14.102     0.200
     0.747    16.602     0.200
     1.654    30.602     0.200
     1.671    31.102     0.200
     0.103     6.154     0.200
     1.132    21.654     0.200
     0.459    10.254     0.200
     2.129    38.254     0.200
     2.354    41.254     0.200
     0.605    12.367     0.200
     0.640    13.867     0.200
     0.932    18.867     0.200
     0.968    19.867     0.200
     1.017    20.867     0.200
     1.641    31.367     0.200
     0.244     6.727     0.200
     0.502    10.727     0.200
     1.359    26.227     0.200
     1.578    28.727     0.200
     1.240    25.104     0.200
     1.370    26.104     0.200
     0.228     7.500     0.200
     0.720    14.500     0.200
     1.223    23.500     0.200
     1.443    27.500     0.200
     0.429    10.195     0.200
     0.595    12.695     0.200
     1.169    22.281     0.200
     1.233    24.195     0.200
     1.295    26.195     0.200
     1.995    36.695     0.200
     7.105   123.898     0.200
     7.120   123.898     0.200
     0.671    13.973     0.200
     2.021    34.973     0.200
     2.478    41.973     0.200
     2.916    49.973     0.200
     5.730    96.973     0.200
     0.491    10.648     0.200
     1.061    20.648     0.200
     1.670    29.648     0.200
     0.556    11.938     0.200
     1.449    27.938     0.200
     1.567    29.938     0.200
     1.686    31.938     0.200
     0.172     4.528     0.200
     0.470    10.528     0.200
     0.784    16.528     0.200
     1.158    22.528     0.200
     1.335    25.528     0.200
     1.434    28.528     0.200
     0.605    13.535     0.200
     0.748    15.535     0.200
     0.963    19.535     0.200
     1.657    29.535     0.200
     0.295     5.922     0.200
     0.303     7.422     0.200
     1.214    24.422     0.200
     1.795    33.422     0.200
     2.005    36.422     0.200
     0.535    11.703     0.200
     0.589    12.203     0.200
     0.589    11.703     0.200
     1.509    28.203     0.200
     2.144    38.703     0.200
     2.144    37.504     0.200
     2.487    43.703     0.200
     6.297   107.703     0.200
     6.537   111.703     0.200
     0.627    13.117     0.200
     0.669    15.117     0.200
     1.169    24.117     0.200
     1.161    23.117     0.200
     1.455    29.117     0.200
     0.457    10.505     0.200
     0.645    13.505     0.200
     0.789    16.005     0.200
     0.976    19.505     0.200
     1.129    21.505     0.200
     0.542    11.830     0.200
     0.915    19.330     0.200
     1.199    24.830     0.200
     0.807    16.330     0.200
     0.483    10.484     0.200
     0.587    12.984     0.200
     1.097    21.484     0.200
     1.232    23.484     0.200
     0.336     7.789     0.200
     0.641    13.289     0.200
     1.117    21.789     0.200
     1.605    29.789     0.200
     1.230    24.140     0.200
     1.361    26.140     0.200
     2.473    45.702     0.200
     2.476    45.740     0.200
     0.783    15.584     0.200
     1.629    31.354     0.200
     0.321     6.711     0.200
     1.021    20.910     0.200
     1.064    23.211     0.200
     1.421    27.211     0.200
     1.507    30.211     0.200
     0.253     6.328     0.200
     0.552    11.328     0.200
     1.585    29.328     0.200
     1.634    30.328     0.200
     2.215    39.328     0.200
     0.391     8.387     0.200
     1.783    32.887     0.200
     0.380     7.525     0.200
     1.179    25.826     0.200
     1.797    35.525     0.200
     0.812    16.040     0.200
     0.425     9.298     0.200
     0.633    13.298     0.200
     1.201    23.298     0.200
     1.762    31.798     0.200
     1.986    35.298     0.200
     0.896    18.543     0.200
     1.066    21.344     0.200
     1.683    32.242     0.200
     0.234     4.750     0.200
     1.795    33.148     0.200
     0.083     4.150     0.200
     0.922    18.940     0.200
     1.007    19.850     0.200
     1.077    21.860     0.200
     1.308    24.950     0.200
     1.366    25.760     0.200
     1.536    27.850     0.200
     1.378    25.550     0.200
     1.378    25.750     0.200
     1.778    32.430     0.200
     1.795    32.319     0.200
     1.796    32.940     0.200
     0.937    19.401     0.200
     1.474    27.761     0.200
     3.735    65.221     0.200
     0.255     6.109     0.200
     1.079    21.984     0.200
     1.039    20.961     0.200
     1.954    36.344     0.200
     0.523    10.125     0.200
     0.671    14.359     0.200
     1.884    36.211     0.200
     2.081    37.859     0.200
     0.883    18.758     0.200
     0.792    16.385     0.200
     1.838    34.424     0.200
     1.794    33.111     0.200
     1.990    35.973     0.200
     2.450    45.070     0.200
     2.674    48.441     0.200
     3.640    61.010     0.200
     0.307     7.641     0.200
     0.451    10.266     0.200
     0.632    12.641     0.200
     1.272    24.555     0.200
     1.365    25.969     0.200
     1.568    29.258     0.200
     1.942    35.492     0.200
     2.217    40.086     0.200
     2.974    51.734     0.200
     0.336     7.914     0.200
     1.493    29.992     0.200
     1.825    33.727     0.200
     1.849    32.711     0.200
     3.500    58.859     0.200
     0.254     6.203     0.200
     0.444     9.867     0.200
     0.471     9.914     0.200
     0.582    11.703     0.200
     0.582    11.906     0.200
     0.860    17.984     0.200
     1.343    25.609     0.200
     1.564    31.086     0.200
     1.668    30.508     0.200
     1.668    30.281     0.200
     1.727    32.008     0.200
     1.847    34.117     0.200
     1.963    36.953     0.200
     0.234     6.012     0.200
     0.417     9.496     0.200
     0.486    10.012     0.200
     0.594    12.059     0.200
     0.840    18.035     0.200
     1.353    26.234     0.200
     1.555    29.992     0.200
     1.588    30.676     0.200
     1.710    31.871     0.200
     1.825    34.434     0.200
     0.479    10.145     0.200
     0.791    17.375     0.200
     0.933    17.738     0.200
     1.058    22.438     0.200
     1.269    25.691     0.200
     1.525    28.223     0.200
     1.557    28.945     0.200
     1.684    30.754     0.200
     3.472    59.676     0.200
     0.607    13.070     0.200
     1.318    25.355     0.200
     1.820    32.930     0.200
     1.820    33.568     0.200
     2.040    39.301     0.200
     2.205    41.850     0.200
     2.483    44.730     0.200
     0.408     9.006     0.200
     0.587    12.404     0.200
     1.069    22.102     0.200
     1.066    21.287     0.200
     1.228    23.773     0.200
     1.299    24.744     0.200
     1.584    28.877     0.200
     1.629    29.576     0.200
     1.817    34.514     0.200
     1.839    33.445     0.200
     1.839    32.504     0.200
     2.197    41.145     0.200
     0.397     8.695     0.200
     0.321     8.039     0.200
     0.584    12.102     0.200
     1.087    21.855     0.200
     1.399    26.273     0.200
     1.217    23.762     0.200
     1.286    24.656     0.200
     1.641    29.652     0.200
     1.559    30.109     0.200
     1.851    34.352     0.200
     2.211    40.574     0.200
     2.368    41.809     0.200
     2.706    46.668     0.200
     0.413    10.186     0.200
     0.579    11.623     0.200
     1.050    22.258     0.200
     2.168    41.193     0.200
     3.503    63.104     0.200
     3.758    64.342     0.200
     0.835    15.980     0.200
     0.754    15.539     0.200
     1.248    23.898     0.200
     1.477    27.699     0.200
     1.762    32.449     0.200
     1.898    34.828     0.200
     0.994    21.079     0.200
     1.045    20.740     0.200
     1.250    25.740     0.200
     1.291    26.641     0.200
     1.330    26.500     0.200
     1.599    30.904     0.200
     0.662    14.332     0.200
     0.661    14.332     0.200
     0.728    15.648     0.200
     0.782    16.309     0.200
     1.110    21.723     0.200
     1.327    26.188     0.200
     1.503    29.152     0.200
     1.365    26.848     0.200
     2.167    40.680     0.200
     2.423    45.621     0.200
     2.487    44.961     0.200
     2.683    46.609     0.200
     3.408    59.125     0.200
     0.799    16.586     0.200
     1.071    21.109     0.200
     1.105    21.461     0.200
     1.170    22.156     0.200
     1.476    28.062     0.200
     1.509    27.367     0.200
     1.502    29.109     0.200
     1.714    30.852     0.200
     1.855    34.672     0.200
     2.035    37.109     0.200
     2.733    45.453     0.200
     2.801    48.242     0.200
     3.304    54.148     0.200
     0.352     7.105     0.200
     0.927    18.477     0.200
     1.532    30.203     0.200
     1.630    31.383     0.200
     2.205    41.055     0.200
     2.304    44.168     0.200
     2.352    42.770     0.200
     0.084     2.812     0.200
     0.641    12.961     0.200
     1.383    27.039     0.200
     1.323    27.320     0.200
     1.769    33.453     0.200
     1.883    35.648     0.200
     2.416    43.852     0.200
     2.575    45.617     0.200
     2.599    47.125     0.200
     0.191     3.938     0.200
     0.546    10.891     0.200
     1.094    21.812     0.200
     1.504    28.438     0.200
     1.634    30.758     0.200
     2.347    42.344     0.200
     0.476    10.756     0.200
     0.807    16.526     0.200
     1.050    19.999     0.200
     1.164    23.331     0.200
     1.133    23.907     0.200
     1.236    24.632     0.200
     1.304    25.862     0.200
     1.359    27.165     0.200
     2.032    37.196     0.200
     2.537    46.016     0.200
     3.136    54.777     0.200
     0.542    11.464     0.200
     0.730    16.023     0.200
     1.008    20.573     0.200
     1.129    23.189     0.200
     1.144    23.607     0.200
     1.432    27.295     0.200
     1.710    32.492     0.200
     3.220    57.734     0.200
     3.764    64.495     0.200
     0.788    16.117     0.200
     0.768    16.492     0.200
     1.198    25.127     0.200
     1.209    24.574     0.200
     1.349    26.656     0.200
     1.403    27.365     0.200
     2.017    36.660     0.200
     2.556    46.150     0.200
     2.814    49.516     0.200
     3.712    64.648     0.200
     0.504    10.172     0.200
     0.742    14.395     0.200
     0.742    15.914     0.200
     0.779    14.531     0.200
     1.061    19.254     0.200
     1.050    21.664     0.200
     1.154    21.793     0.200
     1.173    23.375     0.200
     1.219    22.242     0.200
     1.307    24.484     0.200
     1.359    25.379     0.200
     0.559    11.613     0.200
     0.769    15.051     0.200
     0.810    16.035     0.200
     0.826    16.035     0.200
     0.872    17.852     0.200
     0.996    18.977     0.200
     1.074    20.973     0.200
     1.617    29.613     0.200
     1.674    30.328     0.200
     1.811    32.535     0.200
     3.283    56.305     0.200
     0.589    12.676     0.200
     0.802    17.584     0.200
     0.884    17.902     0.200
     1.240    26.523     0.200
     1.297    24.535     0.200
     0.134     3.964     0.200
     0.354     7.718     0.200
     0.485    10.045     0.200
     0.566    12.096     0.200
     1.157    23.776     0.200
     1.256    24.347     0.200
     1.999    38.102     0.200
     2.156    40.569     0.200
     2.351    42.027     0.200
     0.111     3.941     0.200
     0.315     7.871     0.200
     0.446     8.525     0.200
     1.245    24.242     0.200
     1.690    30.792     0.200
     2.461    42.314     0.200
     0.662    13.984     0.200
     0.804    16.141     0.200
     1.094    20.680     0.200
     0.423     9.539     0.200
     0.814    16.875     0.200
     1.185    23.508     0.200
     1.438    28.047     0.200
     1.548    29.789     0.200
     1.691    31.883     0.200
     0.631    13.703     0.200
     0.993    19.984     0.200
     1.275    24.734     0.200
     1.396    26.258     0.200
     1.854    34.125     0.200
     0.532    11.337     0.200
     0.669    14.695     0.200
     1.089    20.589     0.200
     2.597    46.784     0.200
     0.334     6.812     0.200
     1.024    22.250     0.200
     0.991    20.828     0.200
     0.273     6.201     0.200
     0.898    18.566     0.200
     2.431    42.412     0.200
     0.618    13.156     0.200
     1.114    22.219     0.200
     1.251    22.637     0.200
     1.373    24.754     0.200
     2.174    38.809     0.200
     0.339     8.238     0.200
     1.199    22.402     0.200
     1.638    29.926     0.200
     1.904    34.105     0.200
     2.031    37.488     0.200
     2.194    39.125     0.200
     2.287    40.672     0.200
     2.505    42.816     0.200
     2.679    46.312     0.200
     2.738    47.070     0.200
     0.584    12.508     0.200
     0.759    16.195     0.200
     0.760    16.461     0.200
     1.490    29.852     0.200
     1.796    34.164     0.200
     2.171    39.320     0.200
     2.574    46.414     0.200
     2.868    49.984     0.200
     3.017    52.289     0.200
     0.412     9.039     0.200
     0.542    11.699     0.200
     1.144    22.633     0.200
     1.275    23.816     0.200
     1.924    36.520     0.200
     1.975    35.637     0.200
     2.144    38.293     0.200
     0.882    18.687     0.200
     1.146    23.261     0.200
     1.219    24.946     0.200
     1.559    30.691     0.200
     1.744    33.627     0.200
     1.772    34.544     0.200
     1.978    36.440     0.200
     3.230    55.884     0.200
     0.363     9.363     0.200
     1.125    21.266     0.200
     0.966    18.465     0.200
     1.139    22.207     0.200
     1.226    22.727     0.200
     1.407    26.008     0.200
     1.684    29.387     0.200
     1.893    32.438     0.200
     1.893    32.871     0.200
     0.875    18.805     0.200
     1.072    22.383     0.200
     1.045    21.602     0.200
     1.018    20.180     0.200
     1.003    19.594     0.200
     1.003    19.805     0.200
     1.449    28.305     0.200
     1.491    28.969     0.200
     1.710    32.641     0.200
     1.826    33.719     0.200
     2.212    39.320     0.200
     3.066    55.578     0.200
     0.284     8.156     0.200
     0.434    10.785     0.200
     0.605    12.305     0.200
     1.039    19.883     0.200
     1.076    20.535     0.200
     1.253    23.793     0.200
     1.396    25.094     0.200
     1.539    29.004     0.200
     0.183     5.445     0.200
     0.857    17.328     0.200
     1.110    20.914     0.200
     1.079    20.961     0.200
     1.073    20.898     0.200
     1.204    23.391     0.200
     1.866    33.945     0.200
     2.068    36.883     0.200
     2.433    42.172     0.200
     0.384     8.534     0.200
     0.524    11.514     0.200
     0.604    13.169     0.200
     2.399    43.424     0.200
     2.713    49.229     0.200
     2.949    50.929     0.200
     0.103     4.543     0.200
     0.492    10.783     0.200
     0.688    13.553     0.200
     0.778    15.012     0.200
     1.371    26.064     0.200
     1.512    28.930     0.200
     1.602    30.572     0.200
     2.450    45.059     0.200
     2.458    46.361     0.200
     2.458    45.182     0.200
     4.282    75.812     0.200
     4.397    77.812     0.200
     5.144    88.812     0.200
     5.280    89.812     0.200
     0.938    19.348     0.200
     1.022    20.906     0.200
     1.151    23.305     0.200
     1.242    24.758     0.200
     1.442    29.020     0.200
     1.572    30.441     0.200
     2.195    39.996     0.200
     2.287    43.832     0.200
     2.980    53.945     0.200
     3.210    55.215     0.200
     0.096     4.098     0.200
     0.202     6.082     0.200
     0.496    10.496     0.200
     0.626    13.832     0.200
     1.364    25.715     0.200
     1.367    25.332     0.200
     1.504    27.625     0.200
     1.603    28.676     0.200
     1.596    29.598     0.200
     1.822    33.809     0.200
     1.742    31.895     0.200
     2.196    38.492     0.200
     2.451    44.141     0.200
     2.459    45.492     0.200
     2.459    46.027     0.200
     0.221     6.031     0.200
     0.448    10.375     0.200
     0.615    13.270     0.200
     0.716    14.559     0.200
     1.444    27.238     0.200
     1.357    26.039     0.200
     1.595    29.191     0.200
     1.671    31.926     0.200
     2.733    46.465     0.200
     2.994    51.961     0.200
     0.474    10.828     0.200
     0.649    13.607     0.200
     1.560    29.934     0.200
     1.901    35.568     0.200
     2.082    37.809     0.200
     2.139    37.553     0.200
     2.478    44.576     0.200
     2.760    49.449     0.200
     3.011    54.238     0.200
     4.187    72.346     0.200
     0.163     4.464     0.200
     0.495    11.326     0.200
     0.664    14.244     0.200
     0.668    13.619     0.200
     0.751    15.286     0.200
     1.544    29.668     0.200
     1.729    32.104     0.200
     1.881    34.746     0.200
     2.087    38.010     0.200
     2.188    38.604     0.200
     2.167    38.900     0.200
     2.334    42.165     0.200
     2.703    47.804     0.200
     2.780    48.100     0.200
     3.030    53.442     0.200
     0.226     5.309     0.200
     0.543    11.605     0.200
     0.667    14.789     0.200
     0.691    14.242     0.200
     0.764    15.785     0.200
     1.544    29.410     0.200
     1.825    35.773     0.200
     0.834    16.965     0.200
     0.874    18.711     0.200
     1.374    26.805     0.200
     1.505    29.230     0.200
     1.610    31.352     0.200
     1.796    34.359     0.200
     1.963    37.113     0.200
     2.274    40.926     0.200
     0.802    16.426     0.200
     0.880    19.074     0.200
     0.863    16.979     0.200
     0.943    18.881     0.200
     1.198    24.379     0.200
     1.517    29.362     0.200
     1.597    31.660     0.200
     1.770    34.042     0.200
     1.770    34.199     0.200
     1.770    34.360     0.200
     1.730    33.730     0.200
     1.938    36.299     0.200
     2.253    40.534     0.200
     2.260    40.754     0.200
     0.310     6.146     0.200
     0.336     7.373     0.200
     0.557    12.306     0.200
     0.840    17.851     0.200
     1.033    20.979     0.200
     1.185    22.435     0.200
     1.873    34.814     0.200
     2.351    42.921     0.200
     2.352    41.882     0.200
     2.506    45.688     0.200
     0.356     7.715     0.200
     0.551    11.973     0.200
     0.638    13.133     0.200
     1.657    32.586     0.200
     2.106    39.285     0.200
     0.126     5.355     0.200
     0.397     8.758     0.200
     0.521    11.285     0.200
     0.564    13.062     0.200
     0.967    18.719     0.200
     1.334    24.418     0.200
     2.651    44.867     0.200
     2.408    41.035     0.200
     2.770    47.176     0.200
     0.439     9.842     0.200
     0.867    17.500     0.200
     0.851    16.837     0.200
     0.766    16.142     0.200
     1.175    24.272     0.200
     2.312    43.431     0.200
     2.906    51.103     0.200
     3.221    58.190     0.200
     0.408    10.070     0.200
     0.628    12.074     0.200
     0.620    12.645     0.200
     0.632    13.219     0.200
     0.969    18.652     0.200
     1.181    21.801     0.200
     1.814    32.672     0.200
     1.824    31.523     0.200
     1.827    32.957     0.200
     1.817    32.672     0.200
     0.451    10.168     0.200
     0.565    12.555     0.200
     0.603    12.555     0.200
     0.636    13.340     0.200
     0.885    18.031     0.200
     1.215    23.246     0.200
     1.731    32.559     0.200
     1.750    31.070     0.200
     1.760    30.809     0.200
     1.839    31.852     0.200
     2.041    36.805     0.200
     2.203    38.109     0.200
     2.259    39.414     0.200
     2.788    47.234     0.200
     2.947    50.625     0.200
     0.165     4.605     0.200
     0.460    10.980     0.200
     0.634    13.289     0.200
     0.695    13.941     0.200
     1.355    25.844     0.200
     1.429    27.051     0.200
     1.574    29.574     0.200
     1.652    31.059     0.200
     2.474    42.395     0.200
     2.689    47.746     0.200
     0.631    13.055     0.200
     0.702    14.000     0.200
     0.818    16.141     0.200
     0.996    19.910     0.200
     1.192    22.863     0.200
     1.288    24.602     0.200
     1.288    25.121     0.200
     1.285    24.844     0.200
     1.412    25.719     0.200
     1.502    27.531     0.200
     1.912    33.945     0.200
     2.010    37.809     0.200
     2.044    35.770     0.200
     2.040    36.258     0.200
     2.146    37.770     0.200
     2.253    38.766     0.200
     2.677    45.324     0.200
     2.854    47.691     0.200
     0.522    11.023     0.200
     0.898    18.385     0.200
     0.893    17.654     0.200
     1.008    19.986     0.200
     1.091    21.643     0.200
     1.350    27.020     0.200
     1.403    27.094     0.200
     1.497    27.613     0.200
     1.693    30.604     0.200
     2.119    37.539     0.200
     2.443    44.885     0.200
     0.910    19.734     0.200
     0.952    19.508     0.200
     1.124    22.102     0.200
     1.206    25.672     0.200
     1.211    25.688     0.200
     1.211    25.805     0.200
     1.249    24.422     0.200
     1.741    34.484     0.200
     1.884    35.414     0.200
     2.041    37.750     0.200
     0.156     4.640     0.200
     0.507    11.062     0.200
     0.683    13.842     0.200
     0.766    15.279     0.200
     1.528    29.311     0.200
     1.718    31.899     0.200
     1.872    35.323     0.200
     0.873    18.024     0.200
     0.916    18.364     0.200
     1.096    21.990     0.200
     1.446    28.074     0.200
     1.497    28.590     0.200
     1.834    33.453     0.200
     1.766    32.532     0.200
     2.477    43.618     0.200
     2.614    47.019     0.200
     2.565    45.651     0.200
     0.494    11.027     0.200
     0.681    13.777     0.200
     0.888    16.918     0.200
     0.907    17.199     0.200
     1.111    20.781     0.200
     1.721    31.031     0.200
     0.185     4.383     0.200
     0.170     4.773     0.200
     0.675    14.008     0.200
     0.663    13.008     0.200
     0.743    14.664     0.200
     1.554    28.656     0.200
     0.632    13.510     0.200
     0.720    14.932     0.200
     1.571    30.801     0.200
     1.930    37.664     0.200
     2.167    38.486     0.200
     0.801    16.116     0.200
     0.858    17.267     0.200
     0.994    20.353     0.200
     1.801    32.983     0.200
     1.821    32.777     0.200
     0.825    16.777     0.200
     1.175    22.359     0.200
     1.241    24.141     0.200
     1.320    25.410     0.200
     1.434    26.430     0.200
     1.521    28.805     0.200
     1.505    27.895     0.200
     1.531    29.199     0.200
     1.810    32.906     0.200
     1.810    33.434     0.200
     1.810    33.551     0.200
     1.778    32.602     0.200
     1.975    34.750     0.200
     2.047    38.422     0.200
     0.251     7.926     0.200
     0.687    13.973     0.200
     0.896    18.539     0.200
     1.035    19.578     0.200
     0.137     4.502     0.200
     0.720    14.162     0.200
     1.384    26.471     0.200
     1.658    32.871     0.200
     1.783    32.973     0.200
     0.488     9.645     0.200
     0.579    12.395     0.200
     0.579    12.145     0.200
     1.643    30.496     0.200
     1.833    32.383     0.200
     2.270    40.375     0.200
     2.481    43.062     0.200
     0.802    16.781     0.200
     0.885    18.164     0.200
     0.973    19.070     0.200
     1.300    25.812     0.200
     1.176    23.922     0.200
     1.427    28.242     0.200
     1.701    33.422     0.200
     1.643    31.109     0.200
     1.778    33.242     0.200
     1.882    35.242     0.200
     1.587    30.250     0.200
     0.662    14.238     0.200
     0.852    17.875     0.200
     1.144    22.523     0.200
     0.986    20.602     0.200
     1.443    27.777     0.200
     1.273    24.004     0.200
     1.353    25.408     0.200
     1.397    26.658     0.200
     2.183    38.213     0.200
     2.110    38.277     0.200
     2.808    49.777     0.200
     2.949    49.906     0.200
     3.025    51.498     0.200
     0.726    15.203     0.200
     0.914    19.148     0.200
     1.128    24.328     0.200
     1.044    21.742     0.200
     1.332    26.594     0.200
     1.444    28.203     0.200
     1.457    28.203     0.200
     1.983    36.289     0.200
     2.214    40.492     0.200
     0.552    11.930     0.200
     0.831    16.445     0.200
     1.180    23.598     0.200
     1.186    22.900     0.200
     1.225    25.188     0.200
     1.250    24.404     0.200
     1.305    26.564     0.200
     1.448    28.363     0.200
     1.533    30.080     0.200
     1.572    30.385     0.200
     1.588    30.629     0.200
     1.631    32.070     0.200
     0.417     9.961     0.200
     0.417     9.812     0.200
     0.772    15.539     0.200
     0.584    12.180     0.200
     0.702    14.617     0.200
     0.702    14.188     0.200
     1.020    20.383     0.200
     1.020    20.547     0.200
     1.196    22.156     0.200
     2.164    39.227     0.200
     2.311    40.555     0.200
     0.705    13.758     0.200
     0.701    14.633     0.200
     0.876    18.328     0.200
     1.040    21.039     0.200
     1.089    23.859     0.200
     1.396    29.586     0.200
     2.128    40.797     0.200
     2.794    49.883     0.200
     3.061    54.953     0.200
     3.064    53.547     0.200
     3.882    67.664     0.200
     0.608    13.012     0.200
     0.788    15.931     0.200
     0.955    19.001     0.200
     1.239    22.710     0.200
     1.407    26.150     0.200
     1.959    34.757     0.200
     2.173    37.875     0.200
     0.675    13.727     0.200
     0.753    15.039     0.200
     1.070    21.289     0.200
     0.856    18.086     0.200
     1.297    25.648     0.200
     1.423    26.477     0.200
     1.631    30.164     0.200
     1.686    31.602     0.200
     1.937    35.508     0.200
     2.631    45.438     0.200
     2.351    41.086     0.200
     0.563    12.102     0.200
     0.727    14.531     0.200
     0.841    16.898     0.200
     1.125    21.117     0.200
     1.142    22.141     0.200
     1.163    22.891     0.200
     1.392    26.016     0.200
     1.620    30.133     0.200
     1.951    34.828     0.200
     2.150    39.930     0.200
     2.382    40.672     0.200
     0.519    11.469     0.200
     0.696    12.836     0.200
     0.918    17.867     0.200
     1.352    24.477     0.200
     1.259    23.570     0.200
     1.443    27.164     0.200
     1.520    28.312     0.200
     0.865    17.893     0.200
     0.915    17.936     0.200
     0.991    19.428     0.200
     1.264    25.729     0.200
     1.788    33.768     0.200
     1.788    33.928     0.200
     1.923    34.992     0.200
     0.570    11.727     0.200
     0.815    16.375     0.200
     1.040    20.742     0.200
     1.040    20.922     0.200
     1.764    32.117     0.200
     1.831    33.734     0.200
     1.831    33.609     0.200
     0.864    18.504     0.200
     0.920    18.629     0.200
     0.998    20.027     0.200
     1.386    27.445     0.200
     1.386    27.914     0.200
     1.502    30.500     0.200
     1.906    35.445     0.200
     1.906    35.859     0.200
     2.634    46.574     0.200
     2.776    48.770     0.200
     0.944    20.277     0.200
     1.034    20.525     0.200
     1.287    25.672     0.200
     1.287    26.025     0.200
     1.121    22.568     0.200
     1.299    26.264     0.200
     1.556    30.432     0.200
     1.636    32.123     0.200
     1.636    32.375     0.200
     1.758    33.441     0.200
     0.769    15.828     0.200
     0.769    15.938     0.200
     1.075    20.812     0.200
     1.139    21.812     0.200
     1.354    25.164     0.200
     1.443    27.344     0.200
     1.851    33.281     0.200
     1.892    33.688     0.200
     1.892    35.023     0.200
     0.805    16.676     0.200
     0.925    19.031     0.200
     0.925    18.590     0.200
     1.268    25.172     0.200
     1.268    25.832     0.200
     1.513    28.613     0.200
     1.874    33.828     0.200
     2.013    36.414     0.200
     2.086    37.551     0.200
     2.086    38.871     0.200
     0.176     5.072     0.200
     0.675    14.219     0.200
     0.756    15.961     0.200
     1.311    25.295     0.200
     1.311    25.713     0.200
     1.822    34.545     0.200
     2.719    46.855     0.200
     0.193     4.945     0.200
     0.252     5.621     0.200
     0.953    19.656     0.200
     1.250    24.148     0.200
     1.852    34.203     0.200
     1.993    38.203     0.200
     0.940    18.801     0.200
     0.940    19.758     0.200
     1.202    23.871     0.200
     1.416    27.316     0.200
     1.416    27.758     0.200
     1.693    32.988     0.200
     1.693    32.840     0.200
     1.705    32.383     0.200
     1.705    32.766     0.200
     0.236     6.609     0.200
     0.746    15.445     0.200
     0.746    15.305     0.200
     0.804    15.633     0.200
     1.380    25.500     0.200
     1.206    22.750     0.200
     1.333    24.484     0.200
     1.467    27.492     0.200
     1.528    28.289     0.200
     1.659    29.023     0.200
     2.022    36.117     0.200
     2.314    39.211     0.200
     2.323    41.273     0.200
     2.557    42.969     0.200
     0.463    10.770     0.200
     1.031    18.617     0.200
     0.856    17.742     0.200
     1.108    22.625     0.200
     1.130    21.883     0.200
     1.696    31.336     0.200
     1.759    32.961     0.200
     2.348    40.734     0.200
     2.472    43.703     0.200
     0.549    11.516     0.200
     0.748    15.180     0.200
     0.786    15.734     0.200
     0.770    15.516     0.200
     1.909    33.562     0.200
     0.893    19.320     0.200
     1.270    25.273     0.200
     1.321    26.602     0.200
     1.373    29.250     0.200
     1.669    33.227     0.200
     1.757    34.680     0.200
     1.832    35.055     0.200
     1.977    37.500     0.200
     2.066    38.539     0.200
     1.905    36.562     0.200
     0.496    11.551     0.200
     0.577    12.398     0.200
     0.749    14.930     0.200
     0.940    18.758     0.200
     1.383    25.180     0.200
     0.555    12.504     0.200
     0.756    15.842     0.200
     0.845    17.025     0.200
     1.080    22.252     0.200
     1.704    32.367     0.200
     1.895    34.725     0.200
     2.024    37.613     0.200
     2.086    38.301     0.200
     3.263    55.969     0.200
     3.381    57.582     0.200
     0.682    13.677     0.200
     0.618    13.106     0.200
     0.857    17.558     0.200
     0.973    20.641     0.200
     1.170    22.125     0.200
     1.261    24.864     0.200
     1.339    25.663     0.200
     1.386    25.663     0.200
     1.470    28.061     0.200
     2.884    49.751     0.200
     0.324     7.148     0.200
     0.937    17.562     0.200
     2.196    37.625     0.200
     2.208    38.930     0.200
     0.226     6.257     0.200
     0.829    16.773     0.200
     1.191    23.120     0.200
     1.214    23.154     0.200
     1.360    25.139     0.200
     1.467    26.581     0.200
     1.636    30.331     0.200
     2.414    41.005     0.200
     0.264     6.908     0.200
     0.871    16.662     0.200
     0.871    17.641     0.200
     1.063    21.002     0.200
     1.149    23.100     0.200
     1.186    23.025     0.200
     1.425    26.572     0.200
     1.556    28.271     0.200
     1.630    29.404     0.200
     2.414    41.441     0.200
     0.724    14.984     0.200
     0.807    16.891     0.200
     1.084    22.031     0.200
     1.379    26.125     0.200
     1.634    29.750     0.200
     1.825    32.477     0.200
     1.902    34.281     0.200
     2.045    36.188     0.200
     2.163    38.852     0.200
     2.441    41.992     0.200
     0.513    11.352     0.200
     0.705    15.332     0.200
     1.115    22.898     0.200
     1.381    25.688     0.200
     1.813    32.719     0.200
     1.969    34.965     0.200
     2.109    36.887     0.200
     2.402    41.312     0.200
     0.496    10.906     0.200
     0.516    11.078     0.200
     1.052    21.273     0.200
     1.330    26.754     0.200
     1.687    31.848     0.200
     1.795    33.293     0.200
     2.190    39.355     0.200
     2.297    40.801     0.200
     2.328    41.000     0.200
     0.153     4.043     0.200
     0.604    12.602     0.200
     0.633    13.695     0.200
     0.879    17.820     0.200
     1.068    21.520     0.200
     1.321    26.145     0.200
     1.423    27.422     0.200
     1.424    27.223     0.200
     1.771    33.812     0.200
     1.854    35.457     0.200
     0.749    15.758     0.200
     0.719    15.199     0.200
     0.825    16.031     0.200
     0.942    19.105     0.200
     1.233    22.312     0.200
     1.282    25.199     0.200
     1.259    23.320     0.200
     1.387    25.449     0.200
     1.963    34.895     0.200
     2.876    49.566     0.200
     0.467    10.219     0.200
     0.774    16.508     0.200
     0.803    16.648     0.200
     0.934    17.203     0.200
     1.037    20.141     0.200
     1.075    18.953     0.200
     1.287    25.109     0.200
     1.520    28.141     0.200
     1.551    28.422     0.200
     0.745    15.761     0.200
     1.069    21.673     0.200
     1.127    22.537     0.200
     1.158    22.652     0.200
     1.230    21.976     0.200
     1.451    27.589     0.200
     1.803    32.477     0.200
     1.958    34.878     0.200
     0.368     8.211     0.200
     0.540    11.867     0.200
     1.130    23.180     0.200
     1.314    25.062     0.200
     1.283    25.094     0.200
     1.881    33.914     0.200
     2.459    42.562     0.200
     0.212     4.844     0.200
     0.480    10.844     0.200
     0.972    19.469     0.200
     0.995    20.703     0.200
     1.062    21.602     0.200
     1.100    22.648     0.200
     1.291    24.844     0.200
     1.422    27.281     0.200
     1.483    28.297     0.200
     1.565    29.297     0.200
     0.336     7.750     0.200
     0.416     9.242     0.200
     0.679    14.117     0.200
     0.841    17.586     0.200
     1.134    23.164     0.200
     1.087    21.523     0.200
     2.528    43.945     0.200
     2.769    48.891     0.200
     0.401     9.117     0.200
     0.869    17.711     0.200
     0.735    15.375     0.200
     1.157    23.023     0.200
     1.152    23.062     0.200
     1.424    26.484     0.200
     1.539    28.516     0.200
     1.943    35.812     0.200
     2.341    41.742     0.200
     2.401    43.305     0.200
     0.719    14.953     0.200
     0.698    15.031     0.200
     0.957    19.492     0.200
     1.110    22.445     0.200
     1.114    22.266     0.200
     1.142    23.234     0.200
     1.413    27.836     0.200
     1.832    33.367     0.200
     0.735    15.424     0.200
     0.727    15.299     0.200
     1.108    22.047     0.200
     1.535    30.062     0.200
     1.969    37.863     0.200
     0.700    12.445     0.200
     1.133    24.246     0.200
     1.148    24.648     0.200
     1.233    25.879     0.200
     1.282    26.441     0.200
     1.391    28.535     0.200
     1.391    28.977     0.200
     1.429    28.000     0.200
     1.467    29.359     0.200
     1.554    30.551     0.200
     2.504    44.281     0.200
     0.587    11.842     0.200
     0.896    18.696     0.200
     1.130    21.754     0.200
     1.146    21.613     0.200
     1.056    22.264     0.200
     1.084    22.088     0.200
     1.304    26.097     0.200
     1.422    26.991     0.200
     1.653    31.740     0.200
     1.738    32.505     0.200
     1.868    34.937     0.200
     2.358    42.814     0.200
     2.553    46.594     0.200
     0.712    14.915     0.200
     0.815    17.114     0.200
     0.815    17.783     0.200
     1.130    23.392     0.200
     1.130    23.803     0.200
     1.402    26.740     0.200
     1.517    29.765     0.200
     0.845    16.945     0.200
     0.859    19.129     0.200
     0.995    20.793     0.200
     1.282    24.443     0.200
     1.440    28.545     0.200
     1.406    26.479     0.200
     1.986    35.665     0.200
     2.184    38.687     0.200
     2.174    40.188     0.200
     2.914    49.660     0.200
     0.331     9.117     0.200
     0.321     8.566     0.200
     0.984    19.574     0.200
     1.241    23.441     0.200
     1.360    24.734     0.200
     1.492    26.762     0.200
     0.892    17.039     0.200
     1.046    20.539     0.200
     0.477    10.441     0.200
     0.595    12.387     0.200
     0.735    15.418     0.200
     0.966    19.613     0.200
     1.135    23.141     0.200
     1.284    26.219     0.200
     1.651    30.547     0.200
     2.096    38.629     0.200
     2.303    41.832     0.200
     2.200    40.047     0.200
     0.915    19.156     0.200
     0.915    18.812     0.200
     1.377    26.750     0.200
     1.557    29.916     0.200
     1.509    28.812     0.200
     0.269     7.248     0.200
     0.529    11.329     0.200
     0.934    18.300     0.200
     1.060    19.870     0.200
     1.112    21.211     0.200
     1.283    24.603     0.200
     1.319    25.281     0.200
     1.436    26.977     0.200
     1.833    32.619     0.200
     2.227    39.963     0.200
     2.337    40.210     0.200
     3.038    53.154     0.200
     3.472    58.014     0.200
     0.222     5.977     0.200
     0.745    14.719     0.200
     0.790    15.953     0.200
     1.323    25.719     0.200
     1.263    25.258     0.200
     1.389    26.586     0.200
     1.532    27.617     0.200
     0.650    14.027     0.200
     0.647    13.734     0.200
     0.892    17.469     0.200
     0.994    20.258     0.200
     1.283    24.789     0.200
     1.409    27.133     0.200
     1.895    33.781     0.200
     0.549    11.664     0.200
     0.549    11.844     0.200
     0.549    12.672     0.200
     0.687    14.039     0.200
     0.795    15.883     0.200
     0.795    15.992     0.200
     1.156    23.664     0.200
     1.095    22.453     0.200
     1.095    21.945     0.200
     1.095    22.094     0.200
     1.197    23.820     0.200
     1.221    22.391     0.200
     1.221    22.812     0.200
     1.706    33.117     0.200
     2.302    40.664     0.200
     2.302    41.664     0.200
     2.985    50.664     0.200
     0.552    11.930     0.200
     0.552    12.383     0.200
     0.698    14.484     0.200
     0.808    16.258     0.200
     1.175    24.383     0.200
     1.175    25.062     0.200
     1.151    22.219     0.200
     1.151    24.055     0.200
     1.116    23.125     0.200
     1.116    22.633     0.200
     1.224    22.938     0.200
     1.224    23.055     0.200
     1.224    24.055     0.200
     1.684    31.531     0.200
     1.699    32.055     0.200
     1.699    33.141     0.200
     1.984    36.812     0.200
     1.984    37.062     0.200
     1.905    37.125     0.200
     2.053    37.477     0.200
     2.299    43.055     0.200
     0.661    13.471     0.200
     0.857    16.162     0.200
     0.857    16.383     0.200
     0.861    17.119     0.200
     1.184    22.627     0.200
     1.331    25.082     0.200
     1.255    23.986     0.200
     1.380    25.896     0.200
     2.078    37.451     0.200
     2.991    51.320     0.200
     0.555    12.199     0.200
     0.686    14.234     0.200
     0.793    16.258     0.200
     0.917    18.480     0.200
     1.079    22.383     0.200
     1.213    22.277     0.200
     1.213    22.820     0.200
     1.211    24.301     0.200
     1.662    31.277     0.200
     1.662    31.828     0.200
     1.699    32.824     0.200
     2.003    37.008     0.200
     2.037    36.703     0.200
     2.037    38.301     0.200
     2.271    41.152     0.200
     0.578    12.906     0.200
     0.900    17.977     0.200
     0.900    16.898     0.200
     0.977    19.031     0.200
     1.017    19.680     0.200
     0.552    12.441     0.200
     0.979    18.516     0.200
     1.006    19.344     0.200
     2.551    43.441     0.200
     0.393     8.773     0.200
     0.524    11.168     0.200
     0.524    11.268     0.200
     0.813    17.285     0.200
     1.116    22.543     0.200
     1.178    24.227     0.200
     1.190    22.904     0.200
     1.189    23.340     0.200
     2.098    38.299     0.200
     0.382     8.031     0.200
     0.514    10.793     0.200
     1.122    22.160     0.200
     1.201    23.535     0.200
     1.165    23.742     0.200
     1.177    22.664     0.200
     1.890    35.387     0.200
     2.179    38.504     0.200
     2.770    47.629     0.200
     0.367     7.973     0.200
     0.499    10.785     0.200
     1.154    23.719     0.200
     1.169    24.230     0.200
     1.114    22.164     0.200
     1.202    22.984     0.200
     1.892    34.512     0.200
     0.376     8.219     0.200
     0.499    11.129     0.200
     0.500    11.059     0.200
     2.576    44.629     0.200
     0.385     7.875     0.200
     0.385     8.676     0.200
     0.517    10.801     0.200
     1.148    22.850     0.200
     1.148    23.869     0.200
     1.157    23.930     0.200
     1.164    22.822     0.200
     2.120    38.869     0.200
     2.120    39.869     0.200
     2.198    40.898     0.200
     0.376     8.153     0.200
     0.506    10.711     0.200
     1.089    21.931     0.200
     1.089    22.276     0.200
     1.170    23.668     0.200
     1.190    22.826     0.200
     1.190    23.946     0.200
     1.176    22.967     0.200
     1.176    23.406     0.200
     2.183    40.216     0.200
     2.145    40.196     0.200
     0.369     8.232     0.200
     0.790    16.400     0.200
     1.164    23.336     0.200
     1.088    21.789     0.200
     1.184    23.699     0.200
     1.179    22.641     0.200
     1.916    36.561     0.200
     1.916    35.561     0.200
     1.916    34.551     0.200
     2.063    37.631     0.200
     2.176    38.590     0.200
     2.145    39.551     0.200
     2.607    44.584     0.200
     2.748    47.031     0.200
     1.035    20.461     0.200
     1.179    21.430     0.200
     1.104    21.012     0.200
     1.168    22.613     0.200
     1.252    24.133     0.200
     1.293    24.461     0.200
     1.681    29.848     0.200
     1.747    31.789     0.200
     0.429     9.049     0.200
     0.786    16.307     0.200
     0.930    17.896     0.200
     0.843    17.684     0.200
     1.053    20.986     0.200
     1.118    23.463     0.200
     1.334    27.604     0.200
     1.434    28.070     0.200
     1.582    29.715     0.200
     1.516    28.787     0.200
     1.542    28.834     0.200
     1.658    30.660     0.200
     0.225     5.973     0.200
     1.203    23.719     0.200
     1.756    32.961     0.200
     1.485    29.258     0.200
     1.629    30.762     0.200
     1.565    30.559     0.200
     1.855    34.223     0.200
     1.985    35.809     0.200
     1.189    23.215     0.200
     1.111    22.285     0.200
     1.401    26.175     0.200
     1.422    27.021     0.200
     1.505    28.136     0.200
     1.498    28.221     0.200
     1.574    29.629     0.200
     1.642    29.652     0.200
     1.789    32.481     0.200
     0.267     5.868     0.200
     0.999    19.898     0.200
     1.261    25.675     0.200
     1.427    29.424     0.200
     1.496    29.760     0.200
     1.564    30.344     0.200
     0.687    14.016     0.200
     0.790    15.852     0.200
     1.049    21.875     0.200
     1.197    23.461     0.200
     1.475    30.141     0.200
     1.635    31.289     0.200
     1.718    33.086     0.200
     1.846    34.695     0.200
     1.846    35.992     0.200
     2.017    37.016     0.200
     2.009    38.438     0.200
     2.329    42.055     0.200
     0.456     9.898     0.200
     0.578    12.766     0.200
     0.586    11.898     0.200
     0.815    17.508     0.200
     0.815    18.320     0.200
     1.279    25.438     0.200
     1.279    25.328     0.200
     1.568    29.320     0.200
     1.814    34.500     0.200
     1.969    36.117     0.200
     1.955    36.219     0.200
     2.148    38.297     0.200
     2.250    39.984     0.200
     0.366     8.219     0.200
     0.366     8.344     0.200
     0.497    10.703     0.200
     0.497    10.516     0.200
     0.498    10.625     0.200
     0.786    16.539     0.200
     1.151    23.594     0.200
     1.166    22.383     0.200
     1.117    22.227     0.200
     1.205    22.789     0.200
     1.717    31.914     0.200
     1.889    34.281     0.200
     2.626    45.305     0.200
     4.338    76.172     0.200
     0.343     7.734     0.200
     0.343     7.430     0.200
     0.470    10.266     0.200
     0.760    16.125     0.200
     1.036    21.375     0.200
     1.153    22.977     0.200
     1.187    23.406     0.200
     1.154    22.258     0.200
     0.314     6.844     0.200
     0.439    10.003     0.200
     1.128    22.762     0.200
     1.021    20.521     0.200
     1.170    23.330     0.200
     1.161    22.094     0.200
     0.367     8.367     0.200
     0.617    11.961     0.200
     0.894    18.109     0.200
     0.893    17.500     0.200
     0.918    18.094     0.200
     0.705    14.809     0.200
     0.780    16.617     0.200
     0.772    15.836     0.200
     1.122    21.887     0.200
     1.378    27.309     0.200
     1.613    30.766     0.200
     1.705    32.922     0.200
     1.891    35.398     0.200
     2.129    38.715     0.200
     2.278    40.680     0.200
     0.379     8.678     0.200
     0.607    12.385     0.200
     0.890    18.688     0.200
     1.559    28.822     0.200
     1.619    29.838     0.200
     1.709    30.504     0.200
     1.725    30.646     0.200
     2.556    45.621     0.200
     0.148     4.598     0.200
     0.171     4.676     0.200
     0.642    14.262     0.200
     0.694    14.137     0.200
     0.775    15.332     0.200
     1.521    29.422     0.200
     1.854    35.250     0.200
     2.161    39.051     0.200
     2.718    48.363     0.200
     0.395     8.641     0.200
     0.645    12.207     0.200
     0.942    18.297     0.200
     0.936    18.254     0.200
     0.891    17.609     0.200
     0.932    18.320     0.200
     1.340    25.289     0.200
     1.600    28.383     0.200
     1.601    28.953     0.200
     2.502    43.359     0.200
     0.271     7.043     0.200
     0.632    12.617     0.200
     0.835    17.105     0.200
     0.845    16.840     0.200
     1.111    20.555     0.200
     1.426    27.055     0.200
     0.416     9.289     0.200
     0.586    12.533     0.200
     0.886    18.816     0.200
     0.954    18.533     0.200
     0.938    18.391     0.200
     0.966    18.947     0.200
     0.966    19.721     0.200
     1.588    30.711     0.200
     2.545    45.256     0.200
     0.728    14.914     0.200
     0.761    15.879     0.200
     0.835    16.594     0.200
     0.823    18.254     0.200
     1.151    21.391     0.200
     1.434    26.012     0.200
     1.704    30.199     0.200
     1.863    33.172     0.200
     1.863    33.645     0.200
     2.053    35.594     0.200
     2.498    42.598     0.200
     0.306     8.006     0.200
     0.595    13.427     0.200
     0.871    17.473     0.200
     0.883    17.077     0.200
     1.235    23.056     0.200
     1.627    31.147     0.200
     1.600    29.044     0.200
     0.634    12.383     0.200
     0.653    13.898     0.200
     0.787    16.273     0.200
     0.787    15.332     0.200
     0.729    14.957     0.200
     0.922    18.422     0.200
     1.038    20.914     0.200
     1.148    22.648     0.200
     1.286    24.387     0.200
     1.326    24.555     0.200
     1.466    28.211     0.200
     1.452    26.609     0.200
     2.054    37.098     0.200
     0.646    13.703     0.200
     0.798    16.219     0.200
     0.829    16.930     0.200
     0.904    18.641     0.200
     1.030    20.484     0.200
     1.924    37.391     0.200
     2.111    38.141     0.200
     0.354     8.723     0.200
     0.852    15.766     0.200
     0.907    17.834     0.200
     0.802    15.852     0.200
     0.936    17.811     0.200
     1.598    28.055     0.200
     1.598    28.285     0.200
     1.637    29.281     0.200
     2.239    38.451     0.200
     0.389     8.812     0.200
     0.648    14.375     0.200
     0.842    16.391     0.200
     0.829    16.766     0.200
     0.915    18.082     0.200
     1.299    24.973     0.200
     1.205    23.199     0.200
     1.395    25.410     0.200
     1.469    27.414     0.200
     1.535    27.965     0.200
     0.381     9.390     0.200
     0.860    17.351     0.200
     0.928    18.776     0.200
     0.906    17.995     0.200
     1.217    22.729     0.200
     1.280    24.787     0.200
     1.414    25.774     0.200
     1.450    27.153     0.200
     1.516    27.076     0.200
     1.665    29.916     0.200
     0.378     9.355     0.200
     0.865    16.167     0.200
     0.806    16.088     0.200
     0.907    17.751     0.200
     1.221    22.250     0.200
     1.419    25.383     0.200
     1.511    27.547     0.200
     1.662    30.943     0.200
     0.311     6.797     0.200
     0.574    11.992     0.200
     0.909    17.781     0.200
     1.125    23.148     0.200
     1.630    31.422     0.200
     2.035    37.570     0.200
     0.393     8.922     0.200
     0.630    13.938     0.200
     0.863    17.441     0.200
     0.937    18.344     0.200
     0.893    18.188     0.200
     1.207    23.160     0.200
     1.284    24.445     0.200
     1.451    26.684     0.200
     1.516    27.703     0.200
     1.676    29.836     0.200
     0.402     8.727     0.200
     0.908    19.117     0.200
     0.951    19.344     0.200
     0.951    17.977     0.200
     0.915    18.188     0.200
     0.948    18.867     0.200
     1.099    21.383     0.200
     1.368    26.125     0.200
     1.588    29.203     0.200
     1.775    32.711     0.200
     2.431    41.883     0.200
     2.598    44.383     0.200
     2.530    44.672     0.200
     3.140    52.742     0.200
     0.418     9.141     0.200
     0.961    18.816     0.200
     1.084    21.457     0.200
     1.374    26.883     0.200
     1.607    30.875     0.200
     1.634    30.570     0.200
     1.665    30.754     0.200
     1.792    33.234     0.200
     3.445    59.488     0.200
     0.455    10.273     0.200
     0.967    19.445     0.200
     1.142    21.750     0.200
     1.198    22.297     0.200
     1.238    22.969     0.200
     1.369    25.055     0.200
     1.825    33.797     0.200
     2.349    40.016     0.200
     0.638    13.195     0.200
     0.701    14.477     0.200
     1.150    21.727     0.200
     1.245    24.766     0.200
     1.245    24.930     0.200
     1.345    26.500     0.200
     1.295    25.953     0.200
     1.381    26.219     0.200
     1.696    31.883     0.200
     1.914    34.883     0.200
     1.960    35.289     0.200
     1.969    36.312     0.200
     0.847    17.359     0.200
     0.933    19.570     0.200
     1.168    23.469     0.200
     1.121    23.070     0.200
     1.180    23.227     0.200
     1.169    23.508     0.200
     1.261    26.039     0.200
     1.383    26.969     0.200
     1.555    29.977     0.200
     1.586    29.531     0.200
     1.753    33.445     0.200
     1.755    33.367     0.200
     1.770    32.531     0.200
     1.953    36.164     0.200
     2.109    37.570     0.200
     0.253     5.727     0.200
     0.360     8.283     0.200
     0.603    12.406     0.200
     0.655    13.358     0.200
     0.815    17.022     0.200
     1.249    23.402     0.200
     1.623    30.138     0.200
     1.687    31.417     0.200
     1.773    34.586     0.200
     2.867    51.476     0.200
     0.278     7.062     0.200
     0.905    18.020     0.200
     0.819    16.141     0.200
     0.831    16.523     0.200
     1.057    19.793     0.200
     1.157    21.617     0.200
     0.436     9.375     0.200
     1.094    21.461     0.200
     1.524    29.141     0.200
     1.551    29.414     0.200
     2.640    48.133     0.200
     0.079     2.684     0.200
     0.879    16.547     0.200
     1.052    19.996     0.200
     1.281    24.824     0.200
     1.367    26.402     0.200
     1.814    32.113     0.200
     1.679    31.004     0.200
     1.922    34.086     0.200
     2.049    36.648     0.200
     0.527    10.836     0.200
     0.659    13.406     0.200
     1.156    23.930     0.200
     1.365    27.734     0.200
     2.245    41.086     0.200
     2.214    42.086     0.200
     2.428    44.500     0.200
     1.008    20.723     0.200
     1.030    21.379     0.200
     1.100    22.012     0.200
     1.100    22.453     0.200
     1.233    25.039     0.200
     1.246    24.957     0.200
     1.750    33.883     0.200
     1.736    33.758     0.200
     1.642    31.207     0.200
     1.700    32.199     0.200
     1.684    32.055     0.200
     2.714    47.473     0.200
     0.513    11.236     0.200
     0.628    13.358     0.200
     1.125    23.817     0.200
     1.267    26.034     0.200
     1.323    26.664     0.200
     1.653    31.221     0.200
     1.995    36.219     0.200
     2.131    38.817     0.200
     2.212    40.482     0.200
     0.797    17.051     0.200
     1.139    21.079     0.200
     0.626    12.867     0.200
     0.868    17.387     0.200
     1.061    20.957     0.200
     1.211    23.838     0.200
     1.331    27.031     0.200
     1.542    30.016     0.200
     1.966    38.303     0.200
     1.951    36.619     0.200
     2.009    37.525     0.200
     2.069    39.057     0.200
     0.278     6.967     0.200
     0.485    10.134     0.200
     0.611    12.541     0.200
     0.879    17.713     0.200
     1.225    23.109     0.200
     1.236    24.712     0.200
     2.014    37.178     0.200
     2.205    40.065     0.200
     0.576    12.492     0.200
     1.031    21.805     0.200
     0.959    20.156     0.200
     1.233    24.547     0.200
     1.321    26.109     0.200
     1.208    25.695     0.200
     1.449    28.469     0.200
     1.990    37.797     0.200
     1.965    37.727     0.200
     0.658    14.678     0.200
     0.834    16.950     0.200
     0.840    16.557     0.200
     0.914    17.927     0.200
     0.896    18.825     0.200
     1.193    23.749     0.200
     1.310    25.694     0.200
     1.479    27.818     0.200
     1.544    28.422     0.200
     1.683    31.030     0.200
     1.816    32.848     0.200
     2.127    37.248     0.200
     0.468    10.828     0.200
     0.523    11.453     0.200
     0.973    20.195     0.200
     1.074    21.406     0.200
     1.011    20.188     0.200
     1.232    22.781     0.200
     1.311    24.336     0.200
     1.592    27.914     0.200
     1.649    29.371     0.200
     1.959    35.941     0.200
     2.721    47.363     0.200
     0.603    12.719     0.200
     0.695    14.906     0.200
     0.833    16.203     0.200
     0.901    17.898     0.200
     1.182    23.039     0.200
     1.165    22.328     0.200
     1.373    26.086     0.200
     1.405    25.422     0.200
     1.393    25.484     0.200
     1.479    26.758     0.200
     1.476    26.281     0.200
     1.460    27.141     0.200
     1.691    30.219     0.200
     0.753    16.300     0.200
     0.752    15.204     0.200
     0.816    16.300     0.200
     1.078    21.810     0.200
     1.365    26.839     0.200
     1.506    29.954     0.200
     1.567    30.535     0.200
     1.843    35.345     0.200
     1.934    37.395     0.200
     2.125    39.289     0.200
     2.109    38.458     0.200
     2.384    42.410     0.200
     0.458    10.658     0.200
     0.812    16.119     0.200
     0.970    19.313     0.200
     0.620    13.887     0.200
     0.825    17.018     0.200
     1.122    22.994     0.200
     1.216    24.459     0.200
     1.420    26.375     0.200
     1.409    27.959     0.200
     1.502    27.600     0.200
     2.046    36.238     0.200
     2.543    45.150     0.200
     2.731    46.758     0.200
     0.736    14.684     0.200
     0.863    18.145     0.200
     0.894    17.805     0.200
     0.894    18.521     0.200
     0.835    17.744     0.200
     1.150    23.967     0.200
     1.156    23.469     0.200
     1.427    26.697     0.200
     1.537    28.676     0.200
     1.541    28.521     0.200
     1.697    32.092     0.200
     1.664    30.709     0.200
     1.909    34.035     0.200
     1.937    34.957     0.200
     2.348    43.551     0.200
     2.406    43.742     0.200
     2.890    51.600     0.200
     0.478     9.977     0.200
     1.023    19.159     0.200
     1.181    23.237     0.200
     1.309    24.445     0.200
     1.314    25.475     0.200
     1.393    26.294     0.200
     1.443    27.396     0.200
     1.470    27.757     0.200
     1.507    28.782     0.200
     1.712    31.167     0.200
     1.937    34.096     0.200
     0.499    10.470     0.200
     1.198    23.612     0.200
     1.306    24.763     0.200
     1.295    25.862     0.200
     1.451    27.853     0.200
     1.480    28.201     0.200
     1.523    28.295     0.200
     0.547    11.524     0.200
     1.221    25.499     0.200
     1.335    25.337     0.200
     1.530    28.963     0.200
     1.568    29.347     0.200
     1.626    30.479     0.200
     1.841    34.130     0.200
     2.083    38.093     0.200
     0.542    11.504     0.200
     0.752    16.050     0.200
     0.867    17.550     0.200
     1.014    19.837     0.200
     1.819    33.408     0.200
     2.527    42.134     0.200
     0.496    10.990     0.200
     0.614    13.281     0.200
     1.196    23.258     0.200
     1.156    22.359     0.200
     1.406    26.227     0.200
     1.446    26.422     0.200
     1.491    27.016     0.200
     0.720    15.039     0.200
     0.755    14.633     0.200
     0.815    17.391     0.200
     1.080    19.320     0.200
     1.332    25.398     0.200
     1.427    27.344     0.200
     1.544    28.875     0.200
     1.539    28.156     0.200
     1.836    32.852     0.200
     1.965    35.484     0.200
     2.123    37.617     0.200
     2.390    41.875     0.200
     0.722    14.930     0.200
     0.856    16.234     0.200
     0.933    17.672     0.200
     0.839    16.383     0.200
     0.848    17.316     0.200
     1.231    23.676     0.200
     1.469    26.609     0.200
     1.396    26.160     0.200
     1.514    27.863     0.200
     1.775    31.496     0.200
     0.425     8.605     0.200
     1.329    26.285     0.200
     1.362    28.641     0.200
     1.469    29.539     0.200
     1.278    27.004     0.200
     1.411    28.809     0.200
     1.256    26.250     0.200
     1.443    28.141     0.200
     1.519    30.258     0.200
     1.607    31.859     0.200
     1.501    29.195     0.200
     2.139    39.594     0.200
     2.105    38.168     0.200
     0.666    14.102     0.200
     0.743    15.781     0.200
     1.007    20.328     0.200
     1.133    23.375     0.200
     1.156    22.867     0.200
     1.364    26.305     0.200
     0.187     4.787     0.200
     0.560    11.711     0.200
     0.595    12.141     0.200
     0.922    19.797     0.200
     1.491    29.064     0.200
     1.708    31.877     0.200
     1.884    35.484     0.200
     2.407    42.613     0.200
     0.216     5.336     0.200
     1.411    26.400     0.200
     1.376    26.600     0.200
     1.485    28.148     0.200
     1.529    28.268     0.200
     2.017    35.502     0.200
     2.913    50.273     0.200
     0.148     4.656     0.200
     0.612    13.469     0.200
     1.152    22.523     0.200
     1.461    28.203     0.200
     1.443    27.922     0.200
     1.490    27.797     0.200
     0.476    10.363     0.200
     0.998    20.477     0.200
     1.847    33.875     0.200
     1.961    36.320     0.200
     0.844    18.469     0.200
     1.024    20.625     0.200
     0.973    20.789     0.200
     1.634    31.141     0.200
     1.832    33.992     0.200
     0.444     9.303     0.200
     0.647    12.840     0.200
     1.018    19.865     0.200
     1.115    20.908     0.200
     1.518    28.674     0.200
     1.525    28.502     0.200
     1.704    31.128     0.200
     2.090    38.664     0.200
     2.115    37.308     0.200
     2.183    39.578     0.200
     2.290    39.812     0.200
     2.979    53.073     0.200
     1.147    23.070     0.200
     1.241    25.094     0.200
     1.281    24.883     0.200
     1.365    27.133     0.200
     1.365    27.242     0.200
     1.367    27.469     0.200
     1.479    28.523     0.200
     1.841    34.703     0.200
     1.961    36.000     0.200
     0.459    10.168     0.200
     0.459    10.322     0.200
     0.539    11.406     0.200
     0.540    11.465     0.200
     0.733    15.666     0.200
     0.828    15.666     0.200
     0.907    17.898     0.200
     1.393    26.484     0.200
     4.734    82.275     0.200
     0.287     6.727     0.200
     0.616    12.591     0.200
     0.641    12.800     0.200
     0.863    17.645     0.200
     1.170    23.576     0.200
     1.189    23.038     0.200
     1.272    24.489     0.200
     1.979    37.446     0.200
     0.512    11.621     0.200
     0.791    15.774     0.200
     0.861    17.244     0.200
     1.425    27.833     0.200
     1.779    32.368     0.200
     2.406    42.883     0.200
     3.139    53.881     0.200
     0.716    14.188     0.200
     0.853    17.629     0.200
     1.061    22.535     0.200
     1.110    22.625     0.200
     1.181    24.020     0.200
     1.456    28.672     0.200
     1.400    27.309     0.200
     1.511    29.699     0.200
     1.528    29.723     0.200
     1.810    33.922     0.200
     1.770    33.227     0.200
     2.018    36.594     0.200
     0.108     3.383     0.200
     0.591    12.437     0.200
     0.676    14.651     0.200
     0.843    16.162     0.200
     1.163    22.980     0.200
     2.811    50.069     0.200
     0.644    13.803     0.200
     0.790    15.739     0.200
     0.963    19.303     0.200
     1.570    27.601     0.200
     2.191    37.642     0.200
     2.638    44.888     0.200
     0.527    11.162     0.200
     0.545    11.639     0.200
     0.651    13.146     0.200
     0.677    14.225     0.200
     1.137    21.957     0.200
     1.307    24.412     0.200
     1.738    32.930     0.200
     0.574    12.176     0.200
     0.802    15.480     0.200
     1.195    22.273     0.200
     1.199    23.840     0.200
     1.465    29.309     0.200
     1.518    29.758     0.200
     1.488    29.445     0.200
     1.967    36.379     0.200
     0.111     4.274     0.200
     0.755    14.998     0.200
     0.964    19.439     0.200
     1.225    23.349     0.200
     1.241    24.013     0.200
     1.379    26.955     0.200
     1.627    30.335     0.200
     2.013    36.256     0.200
     2.435    42.149     0.200
     2.540    44.668     0.200
     0.293     7.256     0.200
     0.420     9.658     0.200
     0.537    11.654     0.200
     1.305    24.426     0.200
     1.334    24.918     0.200
     2.257    39.590     0.200
     2.278    40.184     0.200
     0.479     9.720     0.200
     1.012    21.000     0.200
     1.453    28.546     0.200
     0.172     4.457     0.200
     0.995    18.496     0.200
     1.527    27.531     0.200
     1.129    21.168     0.200
     1.656    29.816     0.200
     1.598    29.785     0.200
     1.655    30.348     0.200
     1.723    31.688     0.200
     1.781    31.105     0.200
     0.647    13.797     0.200
     1.305    25.422     0.200
     1.551    29.367     0.200
     1.453    27.680     0.200
     1.453    27.805     0.200
     1.553    29.422     0.200
     1.665    31.336     0.200
     1.654    30.172     0.200
     1.793    31.719     0.200
     0.273     7.094     0.200
     0.647    12.766     0.200
     0.870    18.648     0.200
     0.834    17.047     0.200
     1.087    20.516     0.200
     1.087    20.711     0.200
     0.450     8.258     0.200
     1.347    27.738     0.200
     1.444    29.289     0.200
     1.177    24.996     0.200
     1.304    26.613     0.200
     1.522    31.117     0.200
     1.347    27.711     0.200
     1.491    29.223     0.200
     1.446    29.281     0.200
     1.466    28.863     0.200
     1.670    32.281     0.200
     1.531    30.559     0.200
     1.931    36.270     0.200
     1.858    35.324     0.200
     2.107    40.141     0.200
     0.882    18.339     0.200
     1.069    21.200     0.200
     1.115    22.015     0.200
     1.204    24.179     0.200
     1.342    25.894     0.200
     1.794    33.376     0.200
     1.794    34.270     0.200
     0.380     6.738     0.200
     1.201    24.539     0.200
     1.414    28.703     0.200
     1.417    27.719     0.200
     1.420    29.031     0.200
     1.432    27.941     0.200
     1.515    29.977     0.200
     1.600    31.188     0.200
     0.566    10.941     0.200
     1.265    24.247     0.200
     1.237    24.635     0.200
     1.166    23.730     0.200
     1.485    28.511     0.200
     1.479    28.640     0.200
     1.435    27.477     0.200
     1.420    27.735     0.200
     1.607    30.061     0.200
     1.540    29.285     0.200
     1.775    32.613     0.200
     0.578    11.131     0.200
     1.270    25.617     0.200
     1.218    25.283     0.200
     1.500    29.637     0.200
     1.501    29.822     0.200
     1.325    26.527     0.200
     1.430    28.227     0.200
     1.414    28.189     0.200
     1.622    31.037     0.200
     1.535    29.885     0.200
     1.795    33.648     0.200
     0.927    19.170     0.200
     1.135    21.651     0.200
     1.232    24.103     0.200
     1.305    27.115     0.200
     1.345    25.955     0.200
     1.456    28.350     0.200
     2.292    42.243     0.200
     2.360    41.713     0.200
     0.891    18.566     0.200
     1.135    22.139     0.200
     1.182    23.199     0.200
     1.483    28.602     0.200
     1.712    32.590     0.200
     0.072     3.603     0.200
     0.495    10.457     0.200
     0.539    11.871     0.200
     0.951    19.429     0.200
     1.026    20.759     0.200
     1.062    21.762     0.200
     1.249    23.736     0.200
     1.319    25.077     0.200
     1.341    25.129     0.200
     1.605    29.459     0.200
     1.637    29.676     0.200
     1.853    34.752     0.200
     1.998    37.372     0.200
     2.213    38.423     0.200
     2.483    41.987     0.200
     2.703    46.097     0.200
     3.203    53.395     0.200
     0.830    16.828     0.200
     1.066    21.074     0.200
     1.105    21.289     0.200
     1.180    23.445     0.200
     1.259    22.465     0.200
     1.282    25.207     0.200
     1.535    28.977     0.200
     1.649    30.098     0.200
     2.332    42.086     0.200
     0.479    10.711     0.200
     0.773    14.555     0.200
     0.720    13.805     0.200
     0.987    17.949     0.200
     1.138    20.824     0.200
     0.630    13.781     0.200
     0.677    13.719     0.200
     0.715    14.484     0.200
     1.201    22.938     0.200
     1.667    31.094     0.200
     1.922    35.312     0.200
     0.949    19.952     0.200
     1.124    22.194     0.200
     1.195    23.885     0.200
     1.191    23.902     0.200
     1.234    24.752     0.200
     1.315    26.662     0.200
     1.374    27.557     0.200
     1.478    29.033     0.200
     2.285    42.742     0.200
     0.136     4.564     0.200
     0.304     7.086     0.200
     0.433     9.516     0.200
     0.603    12.418     0.200
     0.802    16.260     0.200
     1.201    23.645     0.200
     1.212    23.867     0.200
     2.048    35.912     0.200
     2.387    41.627     0.200
     2.498    42.824     0.200
     0.782    16.084     0.200
     1.011    21.613     0.200
     1.109    22.789     0.200
     1.253    24.941     0.200
     1.329    25.518     0.200
     1.851    36.062     0.200
     1.866    37.689     0.200
     0.208     4.953     0.200
     1.045    20.203     0.200
     1.390    26.492     0.200
     1.580    30.562     0.200
     1.521    29.031     0.200
     1.726    32.555     0.200
     1.806    33.172     0.200
     2.219    39.484     0.200
     2.378    43.211     0.200
     0.871    18.168     0.200
     1.417    26.902     0.200
     1.797    33.340     0.200
     1.774    32.402     0.200
     2.016    36.336     0.200
     2.073    36.520     0.200
     0.475    10.609     0.200
     0.801    16.641     0.200
     0.940    18.617     0.200
     1.055    20.281     0.200
     1.229    22.750     0.200
     1.361    24.812     0.200
     0.411     8.964     0.200
     0.761    15.245     0.200
     0.761    15.622     0.200
     1.484    28.382     0.200
     1.563    29.214     0.200
     1.523    28.937     0.200
     0.123     3.297     0.200
     0.393     8.859     0.200
     0.332     7.117     0.200
     0.447     9.375     0.200
     0.550    12.031     0.200
     1.436    28.492     0.200
     1.648    31.367     0.200
     2.240    40.688     0.200
     2.549    45.578     0.200
     0.999    20.385     0.200
     0.746    15.641     0.200
     0.524    11.828     0.200
     0.977    19.281     0.200
     1.388    27.320     0.200
     1.487    28.094     0.200
     1.522    29.000     0.200
     2.020    36.867     0.200
     0.432    10.258     0.200
     0.824    16.727     0.200
     0.858    18.047     0.200
     0.951    19.600     0.200
     0.983    19.533     0.200
     0.997    19.848     0.200
     1.462    28.771     0.200
     1.629    31.412     0.200
     1.815    33.689     0.200
     0.753    14.383     0.200
     0.691    14.555     0.200
     0.763    14.758     0.200
     0.763    14.930     0.200
     0.950    18.898     0.200
     1.044    20.664     0.200
     1.130    21.758     0.200
     1.805    32.125     0.200
     2.080    36.094     0.200
     0.781    16.453     0.200
     0.838    16.559     0.200
     0.888    17.561     0.200
     0.974    19.691     0.200
     0.974    19.944     0.200
     0.997    20.262     0.200
     1.300    25.473     0.200
     2.098    37.437     0.200
     2.239    39.903     0.200
     0.594    12.832     0.200
     0.818    17.535     0.200
     0.818    16.914     0.200
     0.939    17.172     0.200
     0.936    18.906     0.200
     0.891    17.480     0.200
     0.872    17.141     0.200
     1.091    21.184     0.200
     1.623    31.410     0.200
     2.285    39.484     0.200
     0.651    13.750     0.200
     0.949    18.219     0.200
     0.877    17.664     0.200
     0.904    17.859     0.200
     0.966    19.531     0.200
     1.474    26.867     0.200
     1.641    29.656     0.200
     0.141     3.885     0.200
     0.528    11.232     0.200
     0.528    11.732     0.200
     0.553    12.498     0.200
     0.950    19.281     0.200
     1.118    22.967     0.200
     1.002    21.156     0.200
     1.198    23.260     0.200
     1.198    21.621     0.200
     1.198    22.834     0.200
     1.387    26.797     0.200
     1.497    28.486     0.200
     1.728    31.727     0.200
     1.906    33.602     0.200
     2.042    37.197     0.200
     0.297     6.203     0.200
     1.148    23.496     0.200
     1.352    25.742     0.200
     1.149    22.734     0.200
     1.498    29.426     0.200
     1.570    29.078     0.200
     1.473    29.492     0.200
     1.550    29.992     0.200
     1.626    31.074     0.200
     1.825    33.078     0.200
     0.419     8.909     0.200
     1.088    21.404     0.200
     1.224    23.625     0.200
     1.126    22.531     0.200
     1.278    24.379     0.200
     1.300    25.268     0.200
     1.825    32.483     0.200
     0.993    20.414     0.200
     1.516    28.648     0.200
     1.547    28.670     0.200
     1.626    30.771     0.200
     1.665    31.014     0.200
     1.626    30.318     0.200
     1.626    29.303     0.200
     1.775    32.260     0.200
     1.775    31.996     0.200
     1.658    30.990     0.200
     1.982    35.324     0.200
     2.167    37.764     0.200
     2.593    44.227     0.200
     0.897    18.713     0.200
     1.026    21.330     0.200
     1.340    26.168     0.200
     1.298    26.972     0.200
     1.511    29.649     0.200
     1.492    30.029     0.200
     2.056    38.240     0.200
     3.588    63.695     0.200
     0.705    14.074     0.200
     1.257    24.441     0.200
     1.339    26.229     0.200
     1.337    27.486     0.200
     1.607    30.844     0.200
     1.658    31.553     0.200
     1.744    33.357     0.200
     2.026    36.307     0.200
     2.663    47.953     0.200
     0.600    12.969     0.200
     0.662    12.974     0.200
     0.960    19.703     0.200
     1.125    22.395     0.200
     1.139    21.977     0.200
     1.141    21.771     0.200
     1.327    25.787     0.200
     1.533    28.468     0.200
     1.642    29.597     0.200
     1.669    29.982     0.200
     2.286    40.814     0.200
     0.328     8.651     0.200
     0.873    18.046     0.200
     1.301    24.048     0.200
     1.466    26.442     0.200
     1.646    29.763     0.200
     1.737    30.354     0.200
     0.532    12.086     0.200
     0.685    14.195     0.200
     0.825    16.969     0.200
     1.108    21.016     0.200
     1.215    22.062     0.200
     1.230    23.141     0.200
     1.466    26.047     0.200
     2.049    35.875     0.200
     2.113    35.820     0.200
     0.061     3.945     0.200
     0.716    15.578     0.200
     1.117    23.242     0.200
     1.704    31.234     0.200
     1.828    33.211     0.200
     1.968    35.297     0.200
     1.961    34.883     0.200
     2.242    39.992     0.200
     2.414    41.570     0.200
     2.515    45.523     0.200
     0.261     8.164     0.200
     0.638    12.713     0.200
     0.638    13.240     0.200
     0.826    17.551     0.200
     1.413    25.535     0.200
     1.557    27.760     0.200
     1.656    29.178     0.200
     1.836    31.711     0.200
     2.641    43.865     0.200
     0.454    10.484     0.200
     0.466    10.531     0.200
     1.074    21.016     0.200
     1.245    22.852     0.200
     1.544    27.586     0.200
     1.978    33.664     0.200
     0.527    10.244     0.200
     0.693    15.004     0.200
     0.749    15.328     0.200
     1.015    18.957     0.200
     1.286    23.736     0.200
     1.286    24.488     0.200
     1.442    26.852     0.200
     1.474    26.996     0.200
     4.092    70.848     0.200
     0.771    16.112     0.200
     0.780    17.005     0.200
     0.828    16.932     0.200
     1.068    21.440     0.200
     1.445    28.318     0.200
     1.550    30.191     0.200
     1.820    34.326     0.200
     1.793    34.352     0.200
     2.109    38.295     0.200
     2.109    38.798     0.200
     2.191    39.183     0.200
     0.384     8.711     0.200
     0.738    15.672     0.200
     0.738    15.219     0.200
     0.950    18.305     0.200
     0.950    19.773     0.200
     0.950    18.828     0.200
     1.290    24.594     0.200
     1.345    26.039     0.200
     1.477    28.359     0.200
     1.542    29.438     0.200
     1.567    29.438     0.200
     1.670    29.828     0.200
     2.150    38.805     0.200
     2.155    38.570     0.200
     2.209    39.023     0.200
     1.271    24.871     0.200
     1.577    30.496     0.200
     1.577    30.775     0.200
     2.051    39.365     0.200
     2.051    38.676     0.200
     0.724    14.844     0.200
     1.342    25.906     0.200
     1.342    25.773     0.200
     0.356     7.998     0.200
     0.356     7.857     0.200
     0.557    11.617     0.200
     0.431     9.318     0.200
     0.431     9.398     0.200
     0.590    13.004     0.200
     1.209    22.096     0.200
     0.750    15.543     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.662    75.383     0.200
     7.696   198.383     0.200
    24.363   597.383     0.200
     1.458    48.992     0.200
     1.474    48.992     0.200
     3.660    99.328     0.200
     7.497   190.328     0.200
    17.382   436.328     0.200
     1.672    52.419     0.200
     1.828    54.419     0.200
     7.309   190.619     0.200
     7.882   203.419     0.200
    17.486   437.419     0.200
     1.822    52.121     0.200
     1.822    54.121     0.200
     4.169   110.422     0.200
     6.219   157.922     0.200
     6.586   165.621     0.200
     7.300   184.621     0.200
     8.221   206.320     0.200
     9.343   237.223     0.200
     3.858   104.215     0.200
     3.860   106.047     0.200
     6.541   170.047     0.200
     7.010   182.547     0.200
     2.250    66.820     0.200
     4.599   123.820     0.200
     5.546   146.117     0.200
     5.458   144.617     0.200
     5.521   144.820     0.200
     5.778   147.820     0.200
     5.894   151.320     0.200
     7.089   183.820     0.200
     7.653   196.820     0.200
     8.156   205.820     0.200
     8.648   218.117     0.200
     8.657   217.320     0.200
     8.759   219.820     0.200
     9.578   240.320     0.200
    11.249   278.320     0.200
    20.812   521.922     0.200
     3.863   103.508     0.200
     5.302   140.109     0.200
     5.776   150.508     0.200
     6.062   155.508     0.200
     6.316   162.508     0.200
     6.535   167.508     0.200
     6.626   170.508     0.200
     6.930   176.508     0.200
     7.020   180.508     0.200
     7.534   192.508     0.200
     8.447   214.008     0.200
     8.769   220.508     0.200
    19.986   494.508     0.200
    20.581   512.508     0.200
    20.654   510.906     0.200
    23.127   569.508     0.200
     3.478    91.520     0.200
     3.845   103.520     0.200
     3.804   102.520     0.200
     4.214   108.918     0.200
     5.289   135.121     0.200
     5.621   142.621     0.200
     5.766   147.020     0.200
     5.533   144.520     0.200
     5.533   146.520     0.200
     5.987   152.918     0.200
     6.061   153.820     0.200
     6.311   160.219     0.200
     6.616   166.520     0.200
     6.642   166.520     0.200
     7.029   177.520     0.200
     7.940   199.520     0.200
     7.986   199.520     0.200
     9.510   235.020     0.200
     9.548   240.820     0.200
    10.306   252.418     0.200
    12.106   300.520     0.200
    12.410   306.520     0.200
    20.587   513.520     0.200
    20.793   513.520     0.200
    21.989   541.520     0.200
     1.761    51.688     0.200
     1.764    51.688     0.200
     2.342    65.688     0.200
     2.705    75.688     0.200
     3.295    90.188     0.200
     3.790   100.188     0.200
     3.833   102.688     0.200
     4.255   111.688     0.200
     4.416   116.188     0.200
     5.813   148.688     0.200
     6.934   173.887     0.200
     2.120    63.707     0.200
     2.587    75.207     0.200
     2.505    73.207     0.200
     2.769    76.809     0.200
     2.806    78.707     0.200
     2.961    81.508     0.200
     3.103    85.906     0.200
     3.339    91.105     0.200
     3.858   104.207     0.200
     3.860   103.906     0.200
     4.332   115.207     0.200
     4.345   114.906     0.200
     4.804   127.207     0.200
     1.706    52.914     0.200
     2.095    62.914     0.200
     2.434    67.914     0.200
     2.557    72.414     0.200
     2.803    78.914     0.200
     2.827    79.715     0.200
     2.999    83.016     0.200
     3.111    84.516     0.200
     3.569    97.914     0.200
     3.874   104.113     0.200
     4.327   114.914     0.200
     4.396   118.414     0.200
     4.733   126.914     0.200
     1.120    38.849     0.200
     1.684    51.849     0.200
     2.369    69.349     0.200
     2.325    67.349     0.200
     2.841    82.349     0.200
     2.874    81.949     0.200
     2.988    84.949     0.200
     3.049    85.349     0.200
     3.291    91.449     0.200
     3.442    93.949     0.200
     3.535    97.949     0.200
     3.693   101.349     0.200
     3.813   107.349     0.200
     4.085   111.749     0.200
     4.102   111.949     0.200
     4.618   125.049     0.200
     4.861   128.449     0.200
     5.224   134.149     0.200
     6.000   155.649     0.200
     6.617   168.149     0.200
     7.019   180.749     0.200
     1.128    37.594     0.200
     1.412    42.594     0.200
     1.574    47.594     0.200
     1.761    51.594     0.200
     2.304    63.891     0.200
     2.936    81.297     0.200
     3.032    84.195     0.200
     3.342    91.195     0.200
     3.654    97.594     0.200
     4.038   108.594     0.200
     4.127   108.391     0.200
     5.404   136.594     0.200
     6.527   166.094     0.200
     7.157   181.195     0.200
     1.361    42.367     0.200
     1.939    57.867     0.200
     2.243    65.867     0.200
     2.455    71.367     0.200
     2.604    72.867     0.200
     2.628    75.367     0.200
     3.215    90.367     0.200
     3.518    95.867     0.200
     3.649   100.367     0.200
     3.663    99.867     0.200
     3.716   103.066     0.200
     3.797   104.367     0.200
     3.913   106.168     0.200
     3.974   107.367     0.200
     3.972   106.766     0.200
     4.216   113.266     0.200
     4.361   116.867     0.200
     4.572   120.668     0.200
     5.026   134.266     0.200
     1.988    57.664     0.200
     2.335    65.664     0.200
     2.167    62.965     0.200
     2.641    74.664     0.200
     2.728    75.465     0.200
     2.830    78.465     0.200
     2.879    79.062     0.200
     3.575    94.164     0.200
     3.646    96.164     0.200
     4.252   113.164     0.200
     5.022   128.863     0.200
     1.100    39.018     0.200
     1.205    39.518     0.200
     1.583    47.018     0.200
     1.716    52.018     0.200
     2.866    81.417     0.200
     3.006    83.518     0.200
     3.070    87.018     0.200
     3.309    91.718     0.200
     3.464    96.118     0.200
     3.717   101.118     0.200
     3.867   102.018     0.200
     3.869   102.518     0.200
     3.802   103.518     0.200
     4.078   107.718     0.200
     4.100   111.018     0.200
     4.122   111.417     0.200
     4.246   110.817     0.200
     4.195   112.018     0.200
     4.464   116.917     0.200
     4.878   129.417     0.200
     1.890    55.453     0.200
     1.890    57.453     0.200
     1.890    58.453     0.200
     1.933    57.352     0.200
     2.010    60.453     0.200
     2.739    74.004     0.200
     2.942    80.754     0.200
     3.194    86.555     0.200
     3.362    91.055     0.200
     3.631    97.555     0.200
     3.681    98.055     0.200
     3.752    99.453     0.200
     4.338   116.352     0.200
     4.397   115.754     0.200
     4.490   118.852     0.200
     4.706   124.852     0.200
     4.791   126.453     0.200
     4.877   129.055     0.200
     5.071   133.754     0.200
     5.087   134.852     0.200
     5.094   133.254     0.200
     5.865   151.953     0.200
     6.539   167.352     0.200
     6.950   176.453     0.200
     7.207   186.953     0.200
     1.693    50.352     0.200
     1.693    51.852     0.200
     2.472    70.852     0.200
     2.472    72.852     0.200
     3.190    86.852     0.200
     3.969   109.852     0.200
     4.023   108.852     0.200
     4.850   126.652     0.200
     4.854   126.551     0.200
     4.957   129.852     0.200
     5.068   133.551     0.200
     5.119   133.551     0.200
     5.192   135.451     0.200
     5.372   139.652     0.200
     5.503   141.451     0.200
     6.107   158.352     0.200
     6.894   175.652     0.200
     7.695   197.051     0.200
     2.435    67.791     0.200
     2.683    74.791     0.200
     3.685    95.990     0.200
     4.149   106.891     0.200
     4.440   116.990     0.200
     4.491   118.592     0.200
     4.745   125.990     0.200
     4.777   123.691     0.200
     4.875   127.391     0.200
     4.986   128.391     0.200
     4.991   129.092     0.200
     5.054   129.490     0.200
     5.095   131.891     0.200
     5.206   134.592     0.200
     5.257   135.191     0.200
     5.329   137.490     0.200
     5.532   145.291     0.200
     5.546   143.191     0.200
     6.313   163.592     0.200
     6.994   175.092     0.200
     7.313   180.891     0.200
     7.929   196.891     0.200
     8.472   213.490     0.200
     3.315    87.537     0.200
     3.315    89.537     0.200
     3.315    91.537     0.200
     3.797    96.736     0.200
     4.263   109.438     0.200
     4.451   115.338     0.200
     4.613   121.236     0.200
     4.861   124.338     0.200
     4.996   128.236     0.200
     5.045   127.637     0.200
     5.093   129.537     0.200
     5.168   130.338     0.200
     5.172   132.736     0.200
     5.332   137.137     0.200
     5.408   138.438     0.200
     5.668   143.537     0.200
     6.437   163.137     0.200
     7.423   184.137     0.200
     2.516    72.467     0.200
     2.987    85.428     0.200
     3.393    93.188     0.200
     3.455    95.467     0.200
     3.727    99.969     0.200
     3.790   103.146     0.200
     3.774   102.668     0.200
     3.808   106.088     0.200
     3.896   105.168     0.200
     4.057   108.848     0.200
     4.086   109.748     0.200
     4.146   110.848     0.200
     4.505   121.168     0.200
     5.035   131.748     0.200
     5.371   142.348     0.200
     5.900   154.848     0.200
     5.900   151.998     0.200
     6.119   157.428     0.200
     6.811   174.188     0.200
     7.469   191.066     0.200
     2.491    68.734     0.200
     2.952    80.297     0.200
     3.183    88.391     0.200
     3.274    91.336     0.200
     3.306    89.453     0.200
     3.585    97.875     0.200
     3.682    99.812     0.200
     3.903   104.406     0.200
     3.854   103.031     0.200
     3.466    95.055     0.200
     3.813   100.812     0.200
     3.767    99.852     0.200
     3.934   103.555     0.200
     3.978   104.852     0.200
     4.361   115.672     0.200
     4.413   118.477     0.200
     4.307   114.352     0.200
     4.350   114.258     0.200
     4.575   119.258     0.200
     4.553   119.453     0.200
     5.172   136.516     0.200
     5.193   134.258     0.200
     5.797   148.812     0.200
     5.797   148.109     0.200
     6.127   156.914     0.200
     6.131   154.758     0.200
     3.712    96.650     0.200
     3.708    98.771     0.200
     3.857   101.870     0.200
     3.920   104.070     0.200
     3.984   105.070     0.200
     4.075   107.715     0.200
     4.263   111.616     0.200
     4.298   112.771     0.200
     4.497   116.570     0.200
     4.506   117.328     0.200
     5.118   133.070     0.200
     5.468   139.930     0.200
     5.628   146.070     0.200
     5.638   143.584     0.200
     5.638   143.835     0.200
     5.766   147.870     0.200
     5.960   153.170     0.200
     5.997   152.119     0.200
     6.098   154.471     0.200
     6.956   174.443     0.200
     7.207   183.070     0.200
     7.446   188.909     0.200
     7.792   196.070     0.200
     8.425   210.047     0.200
     9.404   231.870     0.200
     3.132    88.761     0.200
     3.132    90.761     0.200
     3.778   101.961     0.200
     3.935   108.141     0.200
     3.920   107.300     0.200
     3.996   107.082     0.200
     4.326   114.161     0.200
     4.447   115.862     0.200
     4.346   117.461     0.200
     4.635   122.544     0.200
     4.789   127.281     0.200
     5.516   144.661     0.200
     5.816   149.237     0.200
     5.945   155.629     0.200
     6.016   154.657     0.200
     6.016   154.362     0.200
     6.196   160.181     0.200
     6.919   176.208     0.200
     7.602   193.681     0.200
     2.208    63.578     0.200
     2.215    61.648     0.200
     2.293    62.859     0.200
     2.386    68.551     0.200
     2.422    69.148     0.200
     2.852    78.590     0.200
     3.165    82.129     0.200
     3.415    88.629     0.200
     3.423    88.930     0.200
     3.306    89.629     0.200
     3.465    93.688     0.200
     3.492    94.668     0.200
     3.780   101.090     0.200
     3.835   102.707     0.200
     4.042   104.430     0.200
     3.915   104.418     0.200
     4.378   115.770     0.200
     4.490   116.707     0.200
     4.491   118.766     0.200
     4.840   121.828     0.200
     4.739   124.590     0.200
     5.071   128.359     0.200
     5.222   131.629     0.200
     5.449   137.027     0.200
     5.428   139.309     0.200
     5.427   140.930     0.200
     5.597   141.656     0.200
     5.524   142.137     0.200
     5.685   142.930     0.200
     5.732   143.527     0.200
     5.815   146.582     0.200
     5.815   147.129     0.200
     5.887   149.027     0.200
     5.905   151.336     0.200
     6.214   155.328     0.200
     6.292   157.730     0.200
     6.650   165.930     0.200
     6.690   170.117     0.200
     6.913   175.930     0.200
     7.177   178.828     0.200
     7.460   187.570     0.200
     7.645   188.930     0.200
     7.804   193.926     0.200
     7.751   195.188     0.200
     8.179   202.551     0.200
     8.234   204.027     0.200
     8.534   214.207     0.200
     8.598   215.418     0.200
     8.849   221.367     0.200
     8.945   223.129     0.200
     9.285   229.270     0.200
     9.261   231.789     0.200
     9.570   237.488     0.200
     9.734   240.809     0.200
    10.272   254.230     0.200
    12.057   298.027     0.200
    12.649   308.430     0.200
    13.742   335.828     0.200
    14.204   345.527     0.200
    14.339   346.828     0.200
    14.785   358.328     0.200
    15.139   365.230     0.200
     2.388    69.281     0.200
     2.840    79.762     0.200
     2.984    83.715     0.200
     3.086    87.402     0.200
     3.133    88.301     0.200
     3.296    90.898     0.200
     3.394    94.645     0.200
     3.518    97.641     0.200
     3.733   101.684     0.200
     3.677   101.543     0.200
     3.920   103.820     0.200
     3.911   104.949     0.200
     3.982   106.320     0.200
     4.028   109.211     0.200
     4.087   110.277     0.200
     4.188   112.242     0.200
     4.206   113.703     0.200
     4.582   120.023     0.200
     4.560   119.320     0.200
     4.759   126.863     0.200
     4.837   128.941     0.200
     4.973   131.480     0.200
     5.338   141.469     0.200
     5.473   143.078     0.200
     5.474   143.469     0.200
     5.639   147.570     0.200
     5.639   147.172     0.200
     6.071   153.023     0.200
     1.187    42.182     0.200
     2.617    73.652     0.200
     2.887    81.668     0.200
     3.560   100.740     0.200
     3.896   104.258     0.200
     3.708   103.682     0.200
     4.252   114.865     0.200
     4.480   117.182     0.200
     4.440   116.682     0.200
     4.918   127.328     0.200
     0.897    32.898     0.200
     1.103    37.398     0.200
     1.392    42.898     0.200
     3.014    81.984     0.200
     4.096   108.617     0.200
     4.096   107.086     0.200
     4.084   106.836     0.200
     4.084   108.102     0.200
     4.154   109.133     0.200
     4.602   119.414     0.200
     4.602   118.695     0.200
     4.780   124.156     0.200
     5.173   133.242     0.200
     1.801    53.916     0.200
     2.452    67.877     0.200
     2.693    75.510     0.200
     2.836    79.105     0.200
     3.489    91.678     0.200
     3.489    92.197     0.200
     3.725    97.686     0.200
     3.725    96.678     0.200
     3.725    99.238     0.200
     3.742    97.070     0.200
     4.040   105.088     0.200
     4.040   105.578     0.200
     4.040   105.918     0.200
     1.643    50.633     0.200
     2.021    60.633     0.200
     2.700    79.633     0.200
     2.851    82.211     0.200
     2.851    79.430     0.200
     3.032    85.594     0.200
     3.032    84.859     0.200
     3.080    85.633     0.200
     3.276    92.578     0.200
     3.276    89.461     0.200
     3.378    91.633     0.200
     3.619    99.773     0.200
     3.704   102.555     0.200
     3.726   102.977     0.200
     3.952   108.359     0.200
     3.952   108.930     0.200
     3.995   111.023     0.200
     4.017   111.273     0.200
     4.094   110.672     0.200
     4.234   111.852     0.200
     4.262   115.117     0.200
     4.262   112.641     0.200
     4.609   122.633     0.200
     4.632   123.469     0.200
     4.713   123.930     0.200
     4.660   126.633     0.200
     4.660   124.906     0.200
     4.805   125.633     0.200
     4.805   125.734     0.200
     4.781   128.031     0.200
     4.781   127.555     0.200
     4.852   130.641     0.200
     5.284   138.680     0.200
     5.284   136.695     0.200
     5.314   139.930     0.200
     5.503   144.305     0.200
     5.607   147.875     0.200
     5.992   159.953     0.200
     6.202   161.047     0.200
     6.422   165.531     0.200
     6.422   164.133     0.200
     6.435   165.531     0.200
     6.435   165.430     0.200
     6.976   179.734     0.200
     7.124   181.711     0.200
     7.349   188.031     0.200
     7.858   200.234     0.200
     7.858   198.234     0.200
     8.142   205.078     0.200
     8.385   211.734     0.200
     8.494   215.078     0.200
     8.712   220.117     0.200
     9.696   244.266     0.200
     9.770   244.891     0.200
    10.083   254.336     0.200
     1.279    43.566     0.200
     1.952    55.156     0.200
     2.477    68.777     0.200
     2.897    79.695     0.200
     2.939    79.215     0.200
     2.939    81.855     0.200
     2.939    79.785     0.200
     3.051    84.035     0.200
     3.051    84.457     0.200
     3.234    87.953     0.200
     3.234    89.156     0.200
     3.321    91.395     0.200
     3.355    94.277     0.200
     3.503    98.355     0.200
     3.961   105.789     0.200
     4.010   107.219     0.200
     3.984   109.047     0.200
     4.052   105.953     0.200
     4.082   109.461     0.200
     4.151   113.516     0.200
     4.151   112.957     0.200
     4.137   110.156     0.200
     4.630   119.258     0.200
     4.671   120.156     0.200
     4.760   124.141     0.200
     4.977   127.328     0.200
     4.977   128.555     0.200
     5.120   132.457     0.200
     5.253   134.758     0.200
     5.276   140.305     0.200
     5.276   139.758     0.200
     5.626   146.113     0.200
     5.626   146.484     0.200
     5.781   150.156     0.200
     6.118   155.457     0.200
     6.216   158.457     0.200
     6.660   167.855     0.200
     7.048   180.758     0.200
     7.014   177.836     0.200
     7.177   186.383     0.200
     7.529   189.355     0.200
     7.984   200.914     0.200
     7.984   202.656     0.200
     8.172   206.191     0.200
     1.091    38.383     0.200
     2.455    67.383     0.200
     2.899    80.623     0.200
     3.015    83.123     0.200
     2.894    78.891     0.200
     2.894    79.383     0.200
     3.080    85.023     0.200
     3.186    87.151     0.200
     3.281    90.381     0.200
     3.317    88.763     0.200
     3.474    94.643     0.200
     3.474    95.883     0.200
     3.943   108.631     0.200
     4.058   107.131     0.200
     3.964   104.111     0.200
     4.131   110.943     0.200
     4.065   106.123     0.200
     4.197   114.883     0.200
     4.707   123.481     0.200
     4.643   120.283     0.200
     4.695   120.083     0.200
     4.978   126.523     0.200
     4.978   126.953     0.200
     5.228   136.623     0.200
     5.228   138.483     0.200
     6.118   155.983     0.200
     7.526   189.983     0.200
     1.925    58.117     0.200
     4.264   115.555     0.200
     4.425   117.898     0.200
     5.204   135.039     0.200
     5.185   137.867     0.200
     5.335   138.633     0.200
     5.332   141.477     0.200
     5.523   144.219     0.200
     5.754   150.320     0.200
     5.854   151.164     0.200
     5.907   154.367     0.200
     6.024   155.820     0.200
     6.336   163.820     0.200
     6.344   163.164     0.200
     7.399   189.914     0.200
     7.467   191.117     0.200
     7.429   188.305     0.200
     1.283    43.977     0.200
     1.963    58.266     0.200
     2.447    68.266     0.200
     4.253   114.832     0.200
     4.424   118.133     0.200
     4.492   120.266     0.200
     5.216   135.086     0.200
     5.162   137.633     0.200
     5.223   136.629     0.200
     5.247   140.066     0.200
     5.341   138.832     0.200
     5.320   140.164     0.200
     5.543   143.965     0.200
     5.650   146.176     0.200
     5.767   149.664     0.200
     5.845   151.605     0.200
     5.845   151.938     0.200
     5.888   154.328     0.200
     5.888   155.266     0.200
     6.010   155.266     0.200
     6.351   163.664     0.200
     6.351   162.137     0.200
     7.218   181.574     0.200
     7.204   185.266     0.200
     7.475   189.367     0.200
     7.419   187.145     0.200
     7.419   188.113     0.200
     7.419   187.664     0.200
     8.035   203.766     0.200
     8.035   205.246     0.200
     8.919   224.465     0.200
     9.501   238.422     0.200
     9.501   239.004     0.200
     9.546   238.586     0.200
     9.546   237.867     0.200
     1.395    45.473     0.200
     2.897    81.473     0.200
     3.347    93.473     0.200
     3.554    98.912     0.200
     4.878   128.092     0.200
     4.889   129.065     0.200
     5.162   136.188     0.200
     5.359   138.973     0.200
     5.450   141.473     0.200
     5.911   151.847     0.200
     6.060   156.373     0.200
     7.051   178.973     0.200
     1.792    53.867     0.200
     2.610    75.367     0.200
     3.096    87.367     0.200
     3.696    98.531     0.200
     3.842   102.906     0.200
     4.131   108.398     0.200
     4.150   111.977     0.200
     4.343   116.422     0.200
     4.505   120.727     0.200
     4.621   122.688     0.200
     4.725   126.266     0.200
     4.759   127.219     0.200
     4.864   126.203     0.200
     5.077   130.891     0.200
     5.119   133.164     0.200
     5.387   142.750     0.200
     5.387   143.961     0.200
     5.448   141.008     0.200
     5.515   142.766     0.200
     5.560   145.023     0.200
     5.560   146.477     0.200
     5.645   145.367     0.200
     6.141   156.789     0.200
     6.157   158.867     0.200
     6.249   161.766     0.200
     6.660   172.695     0.200
     6.660   175.469     0.200
     6.847   175.766     0.200
     7.008   175.336     0.200
     7.008   177.805     0.200
     7.280   183.664     0.200
     7.278   183.664     0.200
     7.833   197.266     0.200
     7.872   198.586     0.200
     7.942   199.703     0.200
     8.205   206.766     0.200
     9.191   230.570     0.200
     9.241   230.312     0.200
     9.350   233.250     0.200
     9.747   242.562     0.200
    10.538   261.977     0.200
    10.580   264.531     0.200
    10.654   264.508     0.200
    10.826   271.266     0.200
    10.855   271.664     0.200
    10.892   272.820     0.200
    15.246   375.367     0.200
    15.654   384.164     0.200
     0.923    33.609     0.200
     0.979    34.609     0.200
     1.277    41.609     0.200
     1.266    42.609     0.200
     1.695    51.609     0.200
     2.386    67.609     0.200
     2.952    82.570     0.200
     2.984    80.609     0.200
     3.027    82.949     0.200
     3.135    84.609     0.200
     3.337    91.859     0.200
     3.337    93.711     0.200
     3.676   100.055     0.200
     3.822   100.141     0.200
     3.929   102.438     0.200
     4.036   109.988     0.200
     4.072   110.219     0.200
     4.221   109.410     0.200
     4.382   114.309     0.200
     4.506   118.367     0.200
     4.694   124.230     0.200
     4.731   125.078     0.200
     4.731   124.211     0.200
     4.941   126.980     0.200
     5.638   145.750     0.200
     6.067   153.609     0.200
     6.086   158.090     0.200
     0.991    35.461     0.200
     4.753   125.500     0.200
     5.177   135.117     0.200
     5.635   148.414     0.200
     6.054   154.359     0.200
     6.141   156.664     0.200
     6.512   167.203     0.200
     7.158   179.859     0.200
     0.983    34.609     0.200
     3.248    86.609     0.200
     4.018   105.473     0.200
     4.084   105.473     0.200
     4.556   117.297     0.200
     4.743   124.109     0.200
     5.102   129.879     0.200
     5.102   132.711     0.200
     5.611   143.617     0.200
     1.191    41.398     0.200
     2.733    76.898     0.200
     4.513   122.016     0.200
     4.673   122.977     0.200
     4.934   131.109     0.200
     5.808   146.539     0.200
     5.894   149.984     0.200
     5.932   152.500     0.200
     6.172   157.797     0.200
     6.212   163.898     0.200
     6.279   161.703     0.200
     6.367   163.500     0.200
     6.959   178.297     0.200
     7.115   180.797     0.200
     7.840   196.805     0.200
     8.044   202.797     0.200
     1.037    35.543     0.200
     1.762    51.262     0.200
     1.766    51.242     0.200
     2.147    61.680     0.200
     2.266    65.543     0.200
     2.274    63.234     0.200
     2.741    75.383     0.200
     2.998    82.570     0.200
     3.090    83.141     0.200
     3.752   103.719     0.200
     3.752   102.332     0.200
     3.821    99.562     0.200
     3.875   103.320     0.200
     3.946   102.293     0.200
     4.831   124.031     0.200
     5.041   130.973     0.200
     1.054    35.535     0.200
     1.166    36.535     0.200
     1.809    51.535     0.200
     2.001    57.535     0.200
     2.240    61.094     0.200
     2.280    62.145     0.200
     2.267    64.535     0.200
     2.566    71.535     0.200
     3.031    81.953     0.200
     3.114    83.664     0.200
     3.777   102.824     0.200
     3.806    99.922     0.200
     3.883   102.324     0.200
     3.922   101.754     0.200
     4.817   123.066     0.200
     1.897    57.020     0.200
     4.077   108.541     0.200
     4.234   108.379     0.200
     4.288   110.111     0.200
     4.711   120.078     0.200
     4.684   121.219     0.200
     4.772   124.137     0.200
     5.308   135.244     0.200
     5.525   141.219     0.200
     6.285   157.729     0.200
     2.509    67.875     0.200
     2.510    71.875     0.200
     3.290    93.375     0.200
     3.899   104.875     0.200
     4.128   109.480     0.200
     4.374   115.645     0.200
     4.520   119.875     0.200
     5.257   140.535     0.200
     5.537   145.875     0.200
     5.667   147.863     0.200
     5.755   147.875     0.200
     5.796   147.855     0.200
     5.922   150.422     0.200
     6.300   164.934     0.200
     6.499   165.875     0.200
     6.539   166.977     0.200
     6.800   170.977     0.200
     6.984   176.074     0.200
     7.104   178.676     0.200
     7.123   181.074     0.200
     7.933   199.977     0.200
     1.333    44.070     0.200
     2.252    67.570     0.200
     2.927    82.570     0.200
     3.377    94.570     0.200
     3.391    93.109     0.200
     3.536    97.277     0.200
     3.866   105.098     0.200
     4.011   107.449     0.200
     4.394   117.340     0.200
     4.394   119.270     0.200
     4.770   124.371     0.200
     4.872   127.270     0.200
     4.879   128.137     0.200
     5.143   134.367     0.200
     5.359   138.570     0.200
     5.445   140.969     0.200
     5.902   151.480     0.200
     6.143   157.770     0.200
     7.042   179.270     0.200
     2.108    61.322     0.200
     2.350    68.322     0.200
     2.442    70.322     0.200
     2.455    71.322     0.200
     2.537    73.322     0.200
     2.626    74.322     0.200
     2.724    75.545     0.200
     2.725    75.521     0.200
     3.096    85.322     0.200
     3.241    91.322     0.200
     3.345    91.941     0.200
     3.651    98.322     0.200
     4.071   107.033     0.200
     4.146   113.332     0.200
     4.203   112.393     0.200
     4.211   112.852     0.200
     4.284   118.322     0.200
     4.308   115.211     0.200
     4.400   118.143     0.200
     4.485   119.963     0.200
     4.550   120.322     0.200
     4.582   122.951     0.200
     4.653   126.311     0.200
     5.192   137.662     0.200
     5.537   144.322     0.200
     5.542   144.902     0.200
     5.606   144.510     0.200
     5.746   148.420     0.200
     5.799   151.322     0.200
     5.859   150.123     0.200
     5.877   150.883     0.200
     5.880   150.521     0.200
     6.072   157.342     0.200
     6.233   161.752     0.200
     6.260   158.922     0.200
     6.285   159.623     0.200
     6.454   164.521     0.200
     6.500   165.322     0.200
     6.649   172.420     0.200
     6.748   172.383     0.200
     6.938   178.123     0.200
     7.054   179.521     0.200
     7.055   181.271     0.200
     7.079   179.822     0.200
     7.529   192.260     0.200
     7.700   189.963     0.200
     7.860   198.822     0.200
     7.881   198.822     0.200
     8.411   212.422     0.200
     8.809   221.123     0.200
     8.793   224.480     0.200
     8.887   227.121     0.200
     8.979   226.322     0.200
     9.267   232.422     0.200
     9.522   239.623     0.200
     9.652   242.561     0.200
     9.913   247.973     0.200
    10.842   271.123     0.200
     1.087    38.620     0.200
     1.312    44.620     0.200
     1.578    49.076     0.200
     1.582    49.120     0.200
     2.032    59.460     0.200
     2.173    63.620     0.200
     2.372    66.082     0.200
     2.692    76.105     0.200
     2.834    79.530     0.200
     2.834    78.380     0.200
     2.931    82.540     0.200
     2.931    81.148     0.200
     2.933    81.860     0.200
     2.922    83.880     0.200
     2.922    83.188     0.200
     3.076    86.401     0.200
     3.123    87.731     0.200
     3.259    89.650     0.200
     3.729   103.320     0.200
     3.729   105.400     0.200
     4.017   106.920     0.200
     4.017   106.528     0.200
     4.179   111.160     0.200
     4.199   109.620     0.200
     4.200   109.620     0.200
     4.216   115.620     0.200
     4.554   123.620     0.200
     4.666   120.920     0.200
     4.667   120.820     0.200
     4.753   123.620     0.200
     4.966   132.440     0.200
     4.866   125.520     0.200
     5.016   131.204     0.200
     5.275   135.920     0.200
     5.328   138.020     0.200
     5.378   139.620     0.200
     6.149   157.820     0.200
     7.077   180.920     0.200
     7.257   185.620     0.200
     1.227    40.531     0.200
     1.324    43.531     0.200
     2.105    62.531     0.200
     2.645    75.531     0.200
     2.822    77.531     0.200
     2.918    81.531     0.200
     3.311    89.531     0.200
     3.610    96.352     0.200
     3.552    96.051     0.200
     3.727    96.852     0.200
     3.727    99.902     0.200
     4.058   104.301     0.200
     4.058   107.699     0.200
     4.191   109.492     0.200
     4.191   111.508     0.200
     4.311   115.109     0.200
     4.373   116.293     0.200
     4.454   118.809     0.200
     4.574   120.375     0.200
     4.763   123.109     0.200
     4.763   125.613     0.200
     4.946   127.230     0.200
     5.012   128.332     0.200
     5.054   127.711     0.200
     5.054   131.070     0.200
     5.068   131.445     0.200
     5.235   135.031     0.200
     5.296   136.230     0.200
     5.296   136.430     0.200
     5.234   136.621     0.200
     5.334   136.043     0.200
     5.334   138.547     0.200
     5.426   140.242     0.200
     5.528   142.332     0.200
     5.538   141.230     0.200
     5.626   143.832     0.200
     6.091   155.332     0.200
     6.135   156.633     0.200
     6.329   160.633     0.200
     6.886   172.121     0.200
     6.886   175.359     0.200
     6.958   177.332     0.200
     7.231   181.832     0.200
     8.339   210.828     0.200
     8.662   216.430     0.200
     9.169   227.191     0.200
     9.169   229.633     0.200
     9.300   232.125     0.200
     1.038    35.320     0.200
     1.168    40.820     0.200
     1.594    47.320     0.200
     2.562    67.648     0.200
     2.865    75.484     0.200
     4.200   107.250     0.200
     4.351   112.312     0.200
     4.363   110.422     0.200
     4.367   111.023     0.200
     4.695   119.820     0.200
     4.816   123.023     0.200
     0.943    36.084     0.200
     2.154    63.584     0.200
     3.904   104.702     0.200
     3.878   102.884     0.200
     3.908   103.839     0.200
     4.084   110.014     0.200
     4.084   109.294     0.200
     4.275   119.204     0.200
     4.236   112.254     0.200
     4.174   112.984     0.200
     4.375   114.284     0.200
     4.438   115.984     0.200
     4.483   117.584     0.200
     4.926   129.374     0.200
     5.169   134.784     0.200
     1.029    37.664     0.200
     1.116    37.664     0.200
     1.276    42.664     0.200
     1.752    52.234     0.200
     1.756    52.266     0.200
     2.141    60.961     0.200
     2.255    64.664     0.200
     2.283    63.586     0.200
     2.709    74.781     0.200
     2.756    76.531     0.200
     2.997    82.805     0.200
     3.092    83.891     0.200
     3.754   105.125     0.200
     3.754   101.414     0.200
     3.837   100.484     0.200
     3.883   103.289     0.200
     3.964   102.203     0.200
     3.974   103.164     0.200
     4.329   112.164     0.200
     4.412   114.164     0.200
     4.540   117.461     0.200
     4.623   119.062     0.200
     4.846   124.805     0.200
     5.022   129.062     0.200
     5.039   132.773     0.200
     5.142   131.961     0.200
     5.418   141.602     0.200
     0.885    30.867     0.200
     1.170    34.867     0.200
     1.657    48.746     0.200
     1.667    47.867     0.200
     1.669    47.867     0.200
     2.155    59.918     0.200
     2.203    58.445     0.200
     2.226    63.867     0.200
     2.407    64.988     0.200
     2.449    66.867     0.200
     2.598    71.605     0.200
     2.627    71.324     0.200
     2.435    68.867     0.200
     2.681    72.367     0.200
     2.688    75.258     0.200
     3.121    84.461     0.200
     3.404    87.121     0.200
     3.438    92.496     0.200
     3.476    91.266     0.200
     3.549    91.969     0.200
     3.597    93.469     0.200
     3.626    92.996     0.200
     3.624    92.996     0.200
     3.588    95.867     0.200
     3.824    98.086     0.200
     3.908   100.969     0.200
     3.779    99.867     0.200
     3.943   101.766     0.200
     3.997   102.676     0.200
     4.094   104.969     0.200
     4.092   111.328     0.200
     4.165   107.168     0.200
     4.201   107.969     0.200
     4.172   109.527     0.200
     4.104   107.867     0.200
     4.308   113.605     0.200
     4.646   117.117     0.200
     4.705   120.066     0.200
     4.705   120.367     0.200
     4.740   120.066     0.200
     4.817   123.367     0.200
     4.887   124.766     0.200
     5.038   127.906     0.200
     5.463   141.676     0.200
     5.563   142.066     0.200
     5.571   141.957     0.200
     5.571   140.332     0.200
     5.571   140.848     0.200
     5.504   141.867     0.200
     5.786   145.066     0.200
     5.821   147.168     0.200
     6.338   160.668     0.200
     6.486   160.809     0.200
     6.715   169.066     0.200
     7.001   175.969     0.200
     7.135   180.180     0.200
     7.218   180.668     0.200
     7.285   181.969     0.200
     7.602   189.969     0.200
     7.737   191.625     0.200
     7.856   194.805     0.200
     9.047   222.258     0.200
     9.086   223.125     0.200
     9.128   225.684     0.200
     9.258   230.051     0.200
     9.485   235.469     0.200
     9.490   235.766     0.200
     9.508   235.207     0.200
     9.545   238.906     0.200
     9.916   246.766     0.200
    11.735   289.766     0.200
    12.181   301.266     0.200
    12.314   303.766     0.200
    13.014   320.469     0.200
    13.778   335.867     0.200
    14.178   347.469     0.200
    14.184   346.566     0.200
     1.028    38.192     0.200
     1.278    44.692     0.200
     2.301    69.692     0.200
     2.610    73.192     0.200
     2.610    74.692     0.200
     4.640   123.692     0.200
     5.315   139.093     0.200
     5.412   140.893     0.200
     5.484   142.232     0.200
     5.505   143.792     0.200
     5.505   143.292     0.200
     5.584   145.301     0.200
     5.837   151.692     0.200
     5.837   151.192     0.200
     6.001   157.192     0.200
     6.018   155.851     0.200
     6.031   155.692     0.200
     6.600   169.103     0.200
     6.630   170.593     0.200
     6.795   175.593     0.200
     7.729   196.893     0.200
     7.729   196.593     0.200
     1.449    46.930     0.200
     1.844    55.930     0.200
     2.206    63.930     0.200
     2.381    69.930     0.200
     2.357    67.930     0.200
     2.790    78.664     0.200
     2.757    77.930     0.200
     2.950    83.930     0.200
     3.149    85.930     0.200
     3.346    92.406     0.200
     3.345    92.500     0.200
     3.384    93.930     0.200
     3.469    91.789     0.200
     3.703   101.141     0.200
     3.794   102.234     0.200
     3.850   105.930     0.200
     3.954   106.188     0.200
     4.068   110.312     0.200
     4.124   112.312     0.200
     4.232   115.438     0.200
     4.337   118.367     0.200
     4.372   116.211     0.200
     4.510   120.367     0.200
     4.579   119.477     0.200
     4.538   121.930     0.200
     4.571   120.352     0.200
     4.567   121.930     0.200
     4.697   123.328     0.200
     4.759   124.633     0.200
     4.798   124.219     0.200
     4.806   126.641     0.200
     4.806   124.312     0.200
     4.963   128.219     0.200
     4.905   130.930     0.200
     5.000   130.727     0.200
     4.998   132.031     0.200
     5.056   132.031     0.200
     5.077   132.125     0.200
     5.158   138.672     0.200
     5.178   136.391     0.200
     5.277   137.633     0.200
     5.286   137.828     0.200
     5.371   140.227     0.200
     5.635   145.930     0.200
     5.723   149.461     0.200
     5.828   150.188     0.200
     5.879   151.133     0.200
     5.879   151.727     0.200
     5.939   156.328     0.200
     5.982   155.031     0.200
     6.069   156.227     0.200
     6.271   165.633     0.200
     6.464   164.531     0.200
     6.555   167.430     0.200
     6.628   165.938     0.200
     6.628   166.062     0.200
     6.631   168.539     0.200
     6.631   169.117     0.200
     6.633   169.133     0.200
     6.711   172.031     0.200
     6.890   180.359     0.200
     6.968   176.531     0.200
     6.997   178.227     0.200
     7.520   190.930     0.200
     7.520   189.828     0.200
     7.570   192.648     0.200
     7.897   199.727     0.200
     8.099   205.508     0.200
     8.176   207.531     0.200
     8.176   211.328     0.200
     8.169   204.102     0.200
     8.879   222.133     0.200
     8.905   222.219     0.200
     8.960   224.969     0.200
     9.038   225.281     0.200
     8.996   230.547     0.200
     9.399   235.711     0.200
     9.385   238.484     0.200
     9.858   249.633     0.200
    10.064   252.070     0.200
    10.066   253.602     0.200
    10.116   251.328     0.200
    10.147   255.719     0.200
    10.180   252.570     0.200
    10.205   255.602     0.200
    10.237   258.367     0.200
    10.240   258.273     0.200
    10.268   254.461     0.200
    10.235   253.961     0.200
    10.320   257.102     0.200
    10.448   260.633     0.200
    10.451   262.664     0.200
    10.469   264.227     0.200
    10.506   263.680     0.200
    10.606   262.188     0.200
    11.458   283.367     0.200
    11.745   289.570     0.200
    12.247   300.750     0.200
    12.682   316.133     0.200
    13.076   327.227     0.200
    13.241   329.930     0.200
    14.023   344.727     0.200
    14.776   364.531     0.200
    15.264   373.930     0.200
    15.285   371.531     0.200
    15.613   381.328     0.200
    15.936   388.227     0.200
    16.037   391.633     0.200
    22.532   556.930     0.200
     0.809    30.562     0.200
     1.204    41.562     0.200
     2.389    66.461     0.200
     2.681    74.230     0.200
     3.338    91.270     0.200
     3.685    96.262     0.200
     3.707    97.285     0.200
     3.724    96.762     0.200
     3.743    97.285     0.200
     3.680   102.562     0.200
     3.853   102.703     0.200
     3.853    99.461     0.200
     3.991   104.535     0.200
     4.068   107.461     0.200
     4.096   108.164     0.200
     4.185   108.062     0.200
     4.728   122.113     0.200
     4.819   123.863     0.200
     4.939   127.262     0.200
     1.269    43.715     0.200
     1.571    48.715     0.200
     2.099    61.715     0.200
     2.455    72.715     0.200
     2.529    71.715     0.200
     4.577   118.305     0.200
     4.794   124.320     0.200
     5.118   134.434     0.200
     5.118   131.824     0.200
     5.446   139.816     0.200
     5.546   142.215     0.200
     5.623   145.316     0.200
     5.622   144.848     0.200
     5.718   148.113     0.200
     5.732   147.090     0.200
     5.960   153.215     0.200
     6.009   154.031     0.200
     6.176   160.516     0.200
     6.176   157.016     0.200
     6.178   158.703     0.200
     6.178   156.906     0.200
     6.693   170.215     0.200
     6.745   172.156     0.200
     6.937   177.215     0.200
     7.456   189.016     0.200
     7.873   199.516     0.200
     2.578    72.734     0.200
     2.891    82.734     0.200
     3.013    83.734     0.200
     3.018    83.734     0.200
     3.335    90.734     0.200
     4.616   121.031     0.200
     4.857   125.977     0.200
     4.985   130.422     0.200
     5.478   140.031     0.200
     5.468   141.672     0.200
     5.468   142.617     0.200
     5.588   142.336     0.200
     5.598   142.734     0.200
     5.701   145.836     0.200
     5.693   145.266     0.200
     5.786   150.312     0.200
     5.863   148.461     0.200
     5.845   151.883     0.200
     5.946   152.336     0.200
     6.231   157.734     0.200
     6.223   158.773     0.200
     6.287   158.531     0.200
     6.441   163.203     0.200
     6.510   165.703     0.200
     6.621   167.578     0.200
     6.716   169.836     0.200
     6.748   170.938     0.200
     6.798   171.633     0.200
     6.863   172.281     0.200
     7.022   178.438     0.200
     7.420   188.031     0.200
     7.559   189.734     0.200
     7.829   199.273     0.200
     7.975   199.734     0.200
     8.018   201.094     0.200
     8.536   212.438     0.200
     9.265   230.234     0.200
    10.040   248.297     0.200
    10.040   247.812     0.200
    10.032   248.055     0.200
    11.429   282.922     0.200
     2.273    66.467     0.200
     3.852   100.895     0.200
     4.607   120.207     0.200
     4.772   122.734     0.200
     5.193   133.646     0.200
     5.342   136.768     0.200
     5.452   139.768     0.200
     5.502   141.445     0.200
     5.488   140.867     0.200
     5.537   141.428     0.200
     5.591   143.566     0.200
     5.678   143.965     0.200
     5.835   149.268     0.200
     6.084   155.268     0.200
     6.112   155.967     0.200
     6.199   157.994     0.200
     6.236   160.496     0.200
     6.363   162.646     0.200
     6.601   166.967     0.200
     6.661   170.166     0.200
     6.685   168.938     0.200
     6.860   174.166     0.200
     7.305   185.467     0.200
     7.389   186.268     0.200
     7.773   193.910     0.200
     7.805   196.367     0.200
     8.366   209.768     0.200
     9.082   227.467     0.200
     9.842   244.504     0.200
     1.351    45.291     0.200
     1.686    51.291     0.200
     2.001    60.791     0.200
     2.264    65.291     0.200
     2.613    76.291     0.200
     3.620    98.791     0.200
     5.560   142.592     0.200
     6.708   169.592     0.200
     1.995    60.812     0.200
     2.361    70.312     0.200
     2.581    73.312     0.200
     2.715    78.312     0.200
     5.370   138.016     0.200
     5.468   140.211     0.200
     5.541   143.180     0.200
     5.555   143.312     0.200
     5.648   146.109     0.200
     5.645   147.070     0.200
     5.889   152.414     0.200
     6.083   156.594     0.200
     6.091   156.516     0.200
     6.614   169.711     0.200
     6.660   171.797     0.200
     1.947    57.992     0.200
     3.224    89.992     0.200
     4.766   123.594     0.200
     4.836   125.094     0.200
     4.883   126.641     0.200
     4.911   127.324     0.200
     5.110   131.891     0.200
     5.223   135.082     0.200
     5.343   137.594     0.200
     5.933   151.090     0.200
     1.648    52.605     0.200
     2.908    80.715     0.200
     2.908    82.707     0.200
     3.390    94.145     0.200
     3.573    99.484     0.200
     3.573    99.906     0.200
     4.218   114.875     0.200
     4.333   118.746     0.200
     4.483   121.043     0.200
     4.483   122.004     0.200
     4.531   120.652     0.200
     4.672   122.207     0.200
     4.811   131.172     0.200
     5.026   131.805     0.200
     5.407   145.336     0.200
     5.537   145.656     0.200
     5.537   144.004     0.200
     1.183    42.586     0.200
     1.537    48.586     0.200
     3.075    86.586     0.200
     3.646   101.586     0.200
     3.961   108.596     0.200
     4.173   114.586     0.200
     4.319   118.205     0.200
     4.379   116.416     0.200
     4.527   122.646     0.200
     5.368   138.285     0.200
     5.422   139.695     0.200
     5.422   142.258     0.200
     5.422   139.387     0.200
     5.451   140.025     0.200
     5.451   143.621     0.200
     5.505   143.146     0.200
     5.505   146.416     0.200
     5.560   144.875     0.200
     5.687   149.068     0.200
     5.687   149.387     0.200
     6.443   164.945     0.200
     6.443   168.383     0.200
     6.530   167.387     0.200
     6.702   171.186     0.200
     1.150    38.070     0.200
     4.001   104.719     0.200
     4.075   105.660     0.200
     4.359   112.891     0.200
     4.565   118.020     0.200
     5.092   129.250     0.200
     5.171   134.418     0.200
     5.315   140.316     0.200
     5.282   137.117     0.200
     5.568   144.117     0.200
     5.947   152.516     0.200
     6.491   166.418     0.200
     7.223   183.516     0.200
     1.813    55.252     0.200
     5.185   134.852     0.200
     5.280   136.452     0.200
     5.350   137.462     0.200
     5.447   139.440     0.200
     5.880   150.670     0.200
     5.895   151.152     0.200
     6.462   165.352     0.200
     1.559    48.008     0.200
     1.976    60.008     0.200
     3.077    84.039     0.200
     4.034   105.711     0.200
     4.109   107.305     0.200
     4.162   108.508     0.200
     4.222   111.977     0.200
     4.422   114.805     0.200
     4.479   116.062     0.200
     4.678   121.211     0.200
     4.666   120.148     0.200
     4.666   122.008     0.200
     5.241   135.438     0.200
     5.241   135.906     0.200
     1.268    42.562     0.200
     1.563    46.562     0.200
     1.990    58.562     0.200
     2.173    64.562     0.200
     2.314    65.080     0.200
     2.853    79.962     0.200
     2.853    77.962     0.200
     2.877    81.562     0.200
     3.071    85.162     0.200
     3.256    87.972     0.200
     3.309    89.562     0.200
     3.345    90.662     0.200
     3.707    99.982     0.200
     3.784   102.662     0.200
     4.022   105.962     0.200
     4.097   106.962     0.200
     4.151   107.482     0.200
     4.151   107.842     0.200
     4.061   109.512     0.200
     4.061   108.680     0.200
     4.079   110.360     0.200
     4.095   111.762     0.200
     4.141   110.702     0.200
     4.212   110.722     0.200
     4.212   109.430     0.200
     4.297   112.462     0.200
     4.297   110.952     0.200
     4.297   111.842     0.200
     4.361   114.762     0.200
     4.409   114.562     0.200
     4.463   117.562     0.200
     4.471   116.392     0.200
     4.594   118.862     0.200
     4.658   120.102     0.200
     4.668   120.462     0.200
     4.717   121.762     0.200
     4.660   120.892     0.200
     4.743   126.792     0.200
     4.743   125.912     0.200
     4.836   126.722     0.200
     4.947   132.822     0.200
     4.947   131.422     0.200
     5.230   134.762     0.200
     5.231   134.472     0.200
     5.258   134.762     0.200
     5.445   139.962     0.200
     5.690   147.402     0.200
     5.790   150.362     0.200
     5.949   150.962     0.200
     5.972   151.562     0.200
     5.972   150.712     0.200
     6.031   154.462     0.200
     6.031   152.430     0.200
     6.043   154.232     0.200
     6.096   158.742     0.200
     6.235   157.472     0.200
     6.235   156.562     0.200
     6.355   163.562     0.200
     6.450   161.582     0.200
     6.450   163.202     0.200
     7.147   179.212     0.200
     7.607   192.762     0.200
     7.607   191.322     0.200
     7.968   200.140     0.200
     7.981   202.662     0.200
     8.354   209.522     0.200
     8.438   211.252     0.200
     8.540   213.032     0.200
     9.138   230.750     0.200
     9.692   241.162     0.200
     9.789   244.042     0.200
     9.896   247.922     0.200
     9.921   248.142     0.200
    10.115   251.522     0.200
    10.149   252.862     0.200
    10.151   252.762     0.200
    10.172   253.172     0.200
    10.201   254.192     0.200
    10.573   264.162     0.200
     1.457    47.539     0.200
     2.413    70.539     0.200
     5.194   137.141     0.200
     5.298   139.836     0.200
     5.360   141.039     0.200
     5.360   139.023     0.200
     5.379   141.602     0.200
     5.379   140.836     0.200
     5.458   143.836     0.200
     5.504   145.164     0.200
     5.504   143.141     0.200
     5.590   146.742     0.200
     5.700   149.438     0.200
     5.811   152.492     0.200
     5.811   153.336     0.200
     5.943   155.039     0.200
     6.001   157.367     0.200
     6.515   167.914     0.200
     6.697   174.641     0.200
     7.222   186.141     0.200
     1.401    46.609     0.200
     1.833    56.609     0.200
     3.327    90.609     0.200
     3.791   101.938     0.200
     3.979   106.008     0.200
     3.979   104.750     0.200
     4.362   118.281     0.200
     4.362   119.312     0.200
     4.526   120.648     0.200
     4.526   122.008     0.200
     4.674   122.508     0.200
     4.739   123.906     0.200
     4.796   125.383     0.200
     4.969   128.492     0.200
     4.969   130.406     0.200
     5.028   129.242     0.200
     5.028   131.109     0.200
     5.057   131.812     0.200
     5.088   132.750     0.200
     5.265   136.508     0.200
     5.259   137.211     0.200
     5.352   138.812     0.200
     5.662   146.312     0.200
     5.819   149.133     0.200
     5.861   151.109     0.200
     6.055   156.312     0.200
     6.544   168.312     0.200
     6.646   170.219     0.200
     6.958   178.008     0.200
     6.982   176.328     0.200
     8.172   205.680     0.200
     8.903   222.398     0.200
     0.954    34.199     0.200
     1.965    58.199     0.200
     4.180   109.801     0.200
     4.466   114.848     0.200
     4.669   123.480     0.200
     5.252   135.000     0.200
     5.334   137.199     0.200
     5.391   138.480     0.200
     5.447   138.727     0.200
     5.567   143.699     0.200
     5.642   145.098     0.200
     5.804   148.598     0.200
     5.787   148.766     0.200
     5.907   151.699     0.200
     5.956   152.699     0.200
     6.238   159.398     0.200
     6.468   164.363     0.200
     6.686   170.699     0.200
     7.031   179.398     0.200
     7.188   182.000     0.200
     7.254   185.000     0.200
     7.254   182.297     0.200
     7.604   191.199     0.200
     7.660   191.578     0.200
     8.836   222.098     0.200
     8.836   221.289     0.200
     9.575   239.605     0.200
     4.290   112.186     0.200
     5.263   137.025     0.200
     5.353   139.925     0.200
     5.419   140.695     0.200
     5.475   142.465     0.200
     5.500   142.263     0.200
     5.656   146.025     0.200
     5.894   151.553     0.200
     5.953   153.025     0.200
     6.246   161.925     0.200
     6.518   166.936     0.200
     6.724   172.125     0.200
     7.234   184.325     0.200
     2.593    74.906     0.200
     4.610   123.461     0.200
     5.346   138.305     0.200
     5.456   141.008     0.200
     5.493   143.109     0.200
     5.493   142.086     0.200
     5.542   143.312     0.200
     5.596   145.109     0.200
     5.682   145.102     0.200
     5.743   148.109     0.200
     6.088   156.305     0.200
     6.116   157.305     0.200
     6.202   159.000     0.200
     6.316   161.406     0.200
     6.689   170.828     0.200
     6.864   175.805     0.200
     7.166   182.906     0.200
     5.421   140.121     0.200
     5.504   142.820     0.200
     5.562   143.203     0.200
     5.618   146.102     0.200
     5.812   150.223     0.200
     6.059   154.070     0.200
     6.078   156.922     0.200
     6.639   170.371     0.200
     1.413    43.285     0.200
     2.043    60.285     0.200
     2.524    69.586     0.200
     2.938    82.832     0.200
     3.164    87.715     0.200
     3.368    92.043     0.200
     3.988   106.660     0.200
     4.010   104.785     0.200
     4.105   113.684     0.200
     4.041   105.387     0.200
     4.169   112.422     0.200
     4.374   114.086     0.200
     4.403   115.484     0.200
     4.403   115.617     0.200
     4.428   115.484     0.200
     4.472   115.984     0.200
     5.007   129.953     0.200
     4.989   129.484     0.200
     5.277   135.984     0.200
     1.319    40.676     0.200
     3.135    85.617     0.200
     3.307    90.605     0.200
     4.050   106.402     0.200
     4.106   105.777     0.200
     4.131   107.176     0.200
     4.136   105.977     0.200
     4.171   108.914     0.200
     4.466   114.977     0.200
     4.514   116.875     0.200
     4.534   116.277     0.200
     4.538   116.977     0.200
     5.066   127.496     0.200
     5.082   130.777     0.200
     5.346   137.277     0.200
     1.303    42.990     0.200
     1.790    53.990     0.200
     2.118    61.590     0.200
     2.403    67.990     0.200
     3.495    95.990     0.200
     3.642   100.990     0.200
     3.704    99.990     0.200
     4.013   108.990     0.200
     4.861   125.220     0.200
     5.222   136.870     0.200
     5.322   138.030     0.200
     5.356   138.090     0.200
     5.475   139.990     0.200
     5.580   142.790     0.200
     5.516   145.100     0.200
     5.635   145.590     0.200
     5.635   143.610     0.200
     5.661   144.810     0.200
     5.735   147.490     0.200
     5.785   147.220     0.200
     5.871   150.790     0.200
     5.978   154.290     0.200
     6.211   157.690     0.200
     6.225   158.990     0.200
     6.263   159.530     0.200
     6.267   162.370     0.200
     6.448   163.390     0.200
     6.411   163.650     0.200
     6.729   170.190     0.200
     6.729   170.390     0.200
     6.748   170.190     0.200
     6.793   172.490     0.200
     6.796   171.710     0.200
     6.980   178.190     0.200
     7.108   179.080     0.200
     7.289   184.690     0.200
     7.211   184.280     0.200
     7.446   190.290     0.200
     7.446   189.050     0.200
     7.504   188.690     0.200
     7.642   191.300     0.200
     7.834   196.890     0.200
     7.834   197.003     0.200
     7.920   198.390     0.200
     8.051   201.570     0.200
     8.480   212.690     0.200
     8.754   218.340     0.200
     8.804   215.590     0.200
     8.806   220.990     0.200
     8.837   222.690     0.200
     9.188   228.190     0.200
     9.276   234.690     0.200
     9.365   235.690     0.200
     9.355   233.220     0.200
     9.471   236.190     0.200
     9.517   241.590     0.200
     9.809   245.290     0.200
     9.832   244.390     0.200
     9.944   247.200     0.200
    10.116   252.590     0.200
    11.188   274.730     0.200
    11.302   279.430     0.200
    11.395   280.910     0.200
    11.701   288.390     0.200
    11.718   289.390     0.200
    12.099   297.890     0.200
     1.541    47.789     0.200
     2.713    77.289     0.200
     3.169    88.289     0.200
     4.814   124.688     0.200
     4.886   126.391     0.200
     4.935   127.531     0.200
     4.970   129.125     0.200
     5.086   131.477     0.200
     5.200   134.289     0.200
     5.292   137.297     0.200
     5.386   138.992     0.200
     5.434   139.789     0.200
     5.802   149.086     0.200
     5.991   152.336     0.200
     6.219   158.586     0.200
     6.575   168.188     0.200
     7.170   180.258     0.200
     1.295    44.113     0.200
     1.518    48.215     0.200
     1.943    59.113     0.200
     2.862    78.602     0.200
     2.958    82.113     0.200
     3.074    85.516     0.200
     3.330    91.520     0.200
     3.947   105.973     0.200
     4.017   107.574     0.200
     4.086   111.203     0.200
     4.365   115.750     0.200
     4.632   121.281     0.200
     4.845   125.992     0.200
     4.879   126.812     0.200
     4.891   127.215     0.200
     5.131   134.312     0.200
     5.379   139.082     0.200
     5.610   145.094     0.200
     0.806    29.484     0.200
     5.508   142.672     0.200
     5.641   146.430     0.200
     5.828   149.930     0.200
     6.211   160.555     0.200
     6.822   173.734     0.200
     5.155   134.578     0.200
     5.265   136.172     0.200
     5.350   138.477     0.200
     5.492   142.047     0.200
     5.552   143.875     0.200
     5.792   149.617     0.200
     5.792   151.172     0.200
     5.821   149.836     0.200
     5.925   152.875     0.200
     6.125   156.773     0.200
     6.499   165.273     0.200
     7.202   183.773     0.200
     1.654    51.102     0.200
     4.451   118.043     0.200
     4.466   117.109     0.200
     4.566   120.301     0.200
     4.582   118.043     0.200
     4.585   118.703     0.200
     4.959   127.102     0.200
     5.173   133.902     0.200
     5.476   140.211     0.200
     1.132    35.154     0.200
     3.077    81.805     0.200
     3.903   103.637     0.200
     4.316   110.154     0.200
     4.371   111.354     0.200
     4.405   111.594     0.200
     4.402   111.594     0.200
     4.642   117.854     0.200
     4.560   117.473     0.200
     4.690   120.254     0.200
     4.644   122.805     0.200
     4.917   125.254     0.200
     4.875   122.754     0.200
     5.303   134.754     0.200
     5.424   136.123     0.200
     6.042   152.654     0.200
     6.152   154.354     0.200
     6.577   163.783     0.200
     2.505    66.728     0.200
     2.723    72.144     0.200
     3.625    93.754     0.200
     3.677    94.955     0.200
     3.716    95.224     0.200
     3.710    93.979     0.200
     3.923   100.271     0.200
     4.001   102.654     0.200
     4.096   105.328     0.200
     4.184   106.455     0.200
     4.235   108.554     0.200
     4.253   109.154     0.200
     4.612   117.754     0.200
     4.738   119.052     0.200
     4.976   126.354     0.200
     5.346   135.754     0.200
     5.463   138.554     0.200
     5.918   148.044     0.200
     5.241   134.566     0.200
     5.320   136.566     0.200
     5.375   138.668     0.200
     5.424   141.113     0.200
     5.488   143.051     0.200
     5.563   142.945     0.200
     5.620   145.094     0.200
     5.630   144.668     0.200
     5.746   148.965     0.200
     5.879   149.426     0.200
     5.879   150.668     0.200
     5.886   150.867     0.200
     6.228   158.969     0.200
     6.445   164.578     0.200
     6.667   170.469     0.200
     7.015   178.469     0.200
     5.329   136.227     0.200
     5.441   138.426     0.200
     5.575   143.527     0.200
     5.726   146.127     0.200
     5.819   148.926     0.200
     6.105   153.426     0.200
     6.298   159.426     0.200
     1.240    43.104     0.200
     1.370    45.104     0.200
     1.774    53.104     0.200
     2.252    65.104     0.200
     5.171   133.904     0.200
     5.205   135.803     0.200
     5.205   134.123     0.200
     5.259   135.783     0.200
     5.309   136.734     0.200
     5.407   138.492     0.200
     5.457   141.504     0.200
     5.552   143.703     0.200
     5.697   145.994     0.200
     5.748   147.914     0.200
     5.838   150.904     0.200
     5.961   153.436     0.200
     6.412   163.053     0.200
     6.881   176.203     0.200
     1.223    39.500     0.200
     2.288    64.523     0.200
     2.803    77.727     0.200
     2.870    79.391     0.200
     2.948    82.398     0.200
     2.869    81.500     0.200
     2.957    81.844     0.200
     3.007    81.945     0.200
     3.608    99.242     0.200
     3.739   101.930     0.200
     3.856   104.070     0.200
     3.874   103.273     0.200
     3.971   103.445     0.200
     4.155   107.727     0.200
     4.183   108.203     0.200
     4.191   108.703     0.200
     4.469   116.000     0.200
     4.524   116.203     0.200
     4.667   121.297     0.200
     4.773   123.000     0.200
     4.863   126.703     0.200
     4.835   127.047     0.200
     4.964   127.719     0.200
     5.138   131.602     0.200
     5.195   133.203     0.200
     5.284   135.602     0.200
     5.696   146.797     0.200
     5.726   147.398     0.200
     5.925   150.648     0.200
     6.094   155.602     0.200
     7.020   179.297     0.200
     7.588   191.500     0.200
     1.964    59.195     0.200
     2.027    61.195     0.200
     2.316    69.195     0.200
     3.168    90.195     0.200
     3.237    91.195     0.200
     3.299    92.195     0.200
     3.637   100.195     0.200
     3.704   102.312     0.200
     3.754   103.195     0.200
     3.890   106.961     0.200
     3.893   106.992     0.200
     3.896   106.898     0.200
     3.954   107.195     0.200
     4.120   115.195     0.200
     4.300   113.195     0.200
     4.376   117.664     0.200
     4.434   117.727     0.200
     4.657   123.945     0.200
     5.262   139.211     0.200
     5.330   139.094     0.200
     5.305   139.633     0.200
     5.355   141.266     0.200
     5.385   142.039     0.200
     5.427   140.797     0.200
     5.500   142.383     0.200
     5.519   143.297     0.200
     5.519   140.664     0.200
     5.611   142.336     0.200
     5.611   146.492     0.200
     5.601   143.945     0.200
     5.602   147.930     0.200
     5.724   148.398     0.200
     5.852   151.195     0.200
     5.869   151.266     0.200
     5.968   156.094     0.200
     6.018   158.266     0.200
     6.048   155.297     0.200
     6.036   153.891     0.200
     6.185   160.539     0.200
     6.309   163.195     0.200
     6.616   168.242     0.200
     6.811   174.297     0.200
     7.006   178.898     0.200
     7.054   183.594     0.200
     7.084   182.695     0.200
     7.315   188.992     0.200
     7.315   185.336     0.200
     7.335   182.883     0.200
     7.328   186.195     0.200
     7.422   187.227     0.200
     7.604   192.680     0.200
     7.700   195.797     0.200
     7.745   195.297     0.200
     7.851   197.727     0.200
     8.100   202.336     0.200
     8.136   208.492     0.200
     8.304   211.094     0.200
     8.665   219.094     0.200
     8.933   223.594     0.200
     8.933   223.695     0.200
     8.934   223.695     0.200
     8.949   226.672     0.200
     9.001   227.492     0.200
     9.001   224.188     0.200
     9.188   231.695     0.200
     9.201   232.094     0.200
     9.206   233.352     0.200
     9.295   232.094     0.200
     9.413   235.492     0.200
     9.616   241.594     0.200
     9.652   241.703     0.200
     9.752   244.523     0.200
     9.817   240.336     0.200
     9.817   244.867     0.200
     9.945   249.094     0.200
    10.273   259.297     0.200
    10.669   262.547     0.200
    10.739   267.195     0.200
    11.034   274.023     0.200
    11.049   275.023     0.200
    11.069   275.648     0.200
    11.072   275.938     0.200
    11.093   278.055     0.200
    11.132   277.086     0.200
    11.159   276.250     0.200
    11.152   279.375     0.200
    11.169   276.898     0.200
    11.182   279.148     0.200
    11.220   279.703     0.200
    11.509   286.898     0.200
    11.588   290.234     0.200
     1.536    44.973     0.200
     1.893    53.973     0.200
     2.137    58.973     0.200
     2.478    67.973     0.200
     2.916    81.973     0.200
     3.667    98.973     0.200
     3.803   101.973     0.200
     5.000   127.973     0.200
     5.355   136.973     0.200
     5.576   141.973     0.200
     6.239   156.672     0.200
     6.271   156.574     0.200
     6.604   164.871     0.200
     6.609   167.574     0.200
     6.667   166.473     0.200
     6.857   171.672     0.200
     6.856   172.773     0.200
     6.866   172.973     0.200
     7.219   181.371     0.200
     7.347   182.871     0.200
     8.248   207.672     0.200
     8.320   205.871     0.200
     8.441   209.273     0.200
     8.854   219.773     0.200
     8.854   221.871     0.200
     9.249   229.172     0.200
     9.715   239.473     0.200
     9.828   241.473     0.200
    10.204   250.371     0.200
    10.509   257.871     0.200
     0.239    14.742     0.200
     0.833    27.742     0.200
     1.788    52.242     0.200
     2.333    65.742     0.200
     3.701    94.242     0.200
     3.734    94.844     0.200
     4.066   103.441     0.200
     4.119   104.844     0.200
     4.180   106.441     0.200
     4.319   109.141     0.200
     4.326   109.641     0.200
     4.335   109.543     0.200
     4.681   119.043     0.200
     4.823   121.344     0.200
     5.451   137.641     0.200
     1.061    35.648     0.200
     1.670    49.648     0.200
     1.976    57.648     0.200
     2.113    60.648     0.200
     5.568   140.750     0.200
     5.701   143.848     0.200
     5.758   147.047     0.200
     5.808   146.465     0.200
     5.966   150.449     0.200
     6.016   150.645     0.200
     6.196   156.449     0.200
     6.424   161.238     0.200
     6.424   161.250     0.200
     6.513   164.250     0.200
     1.567    49.938     0.200
     1.686    52.938     0.200
     2.124    59.938     0.200
     5.317   138.539     0.200
     5.432   140.734     0.200
     5.523   142.336     0.200
     5.682   146.953     0.200
     5.714   147.234     0.200
     6.030   155.219     0.200
     6.685   170.664     0.200
     7.972   201.031     0.200
     1.158    39.528     0.200
     2.837    77.528     0.200
     2.956    81.116     0.200
     4.839   125.328     0.200
     4.905   126.729     0.200
     4.948   128.148     0.200
     4.964   129.207     0.200
     5.129   132.090     0.200
     5.128   134.128     0.200
     5.128   132.430     0.200
     5.189   135.428     0.200
     5.222   134.428     0.200
     5.244   135.366     0.200
     5.316   137.208     0.200
     5.433   139.128     0.200
     5.473   141.028     0.200
     5.827   148.928     0.200
     5.986   153.528     0.200
     6.028   154.128     0.200
     7.146   180.958     0.200
     0.748    26.535     0.200
     0.963    32.535     0.200
     1.152    36.535     0.200
     1.657    46.535     0.200
     3.903    99.135     0.200
     3.978   101.535     0.200
     4.031   102.905     0.200
     4.093   105.513     0.200
     4.360   112.277     0.200
     4.549   117.936     0.200
     4.658   120.785     0.200
     5.112   128.535     0.200
     1.214    42.422     0.200
     1.795    53.422     0.200
     2.302    65.422     0.200
     5.133   133.022     0.200
     5.242   134.922     0.200
     5.387   140.122     0.200
     5.468   141.210     0.200
     5.901   152.022     0.200
     6.000   154.570     0.200
     6.104   157.322     0.200
     6.475   165.852     0.200
     2.144    60.004     0.200
     2.178    62.703     0.200
     2.487    71.703     0.200
     2.525    70.703     0.200
     3.364    93.703     0.200
     3.506    95.703     0.200
     3.910   105.955     0.200
     3.955   107.703     0.200
     4.097   110.648     0.200
     4.103   110.414     0.200
     4.361   117.703     0.200
     4.523   122.453     0.200
     4.645   120.555     0.200
     4.856   127.096     0.200
     4.910   128.703     0.200
     5.303   140.822     0.200
     5.495   140.604     0.200
     5.519   145.559     0.200
     5.569   147.619     0.200
     5.598   141.902     0.200
     5.600   148.848     0.200
     5.666   145.703     0.200
     5.666   143.797     0.200
     5.675   146.025     0.200
     5.763   146.834     0.200
     5.763   146.104     0.200
     5.790   146.344     0.200
     5.814   151.803     0.200
     5.891   149.803     0.200
     6.005   152.902     0.200
     6.073   155.762     0.200
     6.134   155.043     0.200
     6.228   157.203     0.200
     6.233   159.402     0.200
     6.233   162.537     0.200
     6.245   158.920     0.200
     6.471   164.504     0.200
     6.690   173.787     0.200
     6.803   171.363     0.200
     7.212   183.604     0.200
     7.513   189.703     0.200
     7.632   191.043     0.200
     7.814   194.312     0.200
     7.929   199.402     0.200
     8.049   201.975     0.200
     8.489   214.104     0.200
     8.737   217.988     0.200
     9.192   232.004     0.200
     9.192   229.178     0.200
     9.358   233.604     0.200
     9.420   237.934     0.200
     9.480   236.504     0.200
     9.600   240.803     0.200
     9.810   246.504     0.200
     9.946   248.324     0.200
    10.001   248.686     0.200
    10.127   253.004     0.200
    10.924   268.318     0.200
    11.294   280.516     0.200
    11.378   280.703     0.200
    11.434   283.178     0.200
    11.664   288.432     0.200
    11.669   286.604     0.200
    11.690   287.004     0.200
    11.722   290.852     0.200
    11.802   294.793     0.200
    15.188   370.902     0.200
    16.972   413.402     0.200
     2.627    73.117     0.200
     5.699   147.812     0.200
     5.717   148.031     0.200
     6.057   154.883     0.200
     6.813   173.039     0.200
     1.129    38.505     0.200
     2.614    72.505     0.200
     3.137    86.505     0.200
     5.227   134.245     0.200
     5.262   135.213     0.200
     5.445   139.415     0.200
     6.284   159.145     0.200
     1.199    42.830     0.200
     2.656    77.830     0.200
     4.070   109.020     0.200
     4.403   118.711     0.200
     4.681   127.473     0.200
     4.765   129.525     0.200
     4.871   134.502     0.200
     5.265   138.230     0.200
     5.336   139.830     0.200
     5.384   140.633     0.200
     5.409   141.096     0.200
     5.534   145.520     0.200
     5.572   145.018     0.200
     5.651   147.131     0.200
     5.678   149.537     0.200
     5.836   152.430     0.200
     5.877   153.730     0.200
     5.901   153.230     0.200
     5.954   154.930     0.200
     6.253   162.131     0.200
     6.431   166.732     0.200
     7.023   181.430     0.200
     7.156   184.330     0.200
     7.592   192.885     0.200
     8.124   207.230     0.200
     8.170   208.221     0.200
     8.785   223.730     0.200
     8.785   221.951     0.200
     9.113   231.430     0.200
     9.515   239.279     0.200
     9.641   243.135     0.200
     1.232    40.484     0.200
     1.993    57.484     0.200
     2.583    71.484     0.200
     4.497   119.064     0.200
     5.321   141.002     0.200
     5.388   138.885     0.200
     5.486   140.484     0.200
     5.559   142.215     0.200
     5.573   143.285     0.200
     5.663   144.352     0.200
     5.666   145.084     0.200
     5.783   148.084     0.200
     5.907   151.084     0.200
     5.932   151.305     0.200
     6.026   154.385     0.200
     6.079   159.965     0.200
     6.109   156.285     0.200
     6.099   155.633     0.200
     6.115   155.785     0.200
     6.366   160.885     0.200
     6.632   168.584     0.200
     6.678   170.834     0.200
     7.389   187.084     0.200
     7.667   192.098     0.200
     9.063   227.344     0.200
     1.178    40.789     0.200
     2.678    74.789     0.200
     5.000   129.789     0.200
     5.050   131.730     0.200
     5.084   133.156     0.200
     5.197   134.391     0.200
     5.197   134.832     0.200
     5.264   136.188     0.200
     5.271   136.723     0.200
     5.314   136.891     0.200
     5.396   140.117     0.200
     5.549   142.289     0.200
     5.564   144.391     0.200
     5.916   152.488     0.200
     6.106   156.633     0.200
     1.230    42.140     0.200
     2.473    73.215     0.200
     2.476    73.240     0.200
     3.313    91.230     0.200
     3.752   101.198     0.200
     3.879   105.730     0.200
     3.913   106.848     0.200
     4.051   109.580     0.200
     4.721   125.210     0.200
     4.817   126.340     0.200
     4.810   124.648     0.200
     4.856   126.440     0.200
     4.873   126.110     0.200
     4.862   127.130     0.200
     4.911   128.878     0.200
     5.186   134.740     0.200
     5.151   135.720     0.200
     5.295   136.340     0.200
     5.439   140.640     0.200
     5.439   141.540     0.200
     5.450   141.140     0.200
     5.800   150.140     0.200
     5.828   149.070     0.200
     5.947   153.540     0.200
     6.101   157.240     0.200
     6.438   165.877     0.200
     6.560   167.840     0.200
     6.904   175.730     0.200
     8.132   204.970     0.200
     0.783    29.584     0.200
     1.259    42.584     0.200
     1.243    39.584     0.200
     2.320    66.689     0.200
     2.365    68.584     0.200
     2.347    65.584     0.200
     3.693    96.684     0.200
     3.682    97.141     0.200
     3.725    96.885     0.200
     3.737    98.195     0.200
     3.777   100.584     0.200
     3.801   100.646     0.200
     4.011   106.584     0.200
     3.935   109.334     0.200
     4.057   106.084     0.200
     4.092   108.283     0.200
     4.164   108.184     0.200
     4.310   111.385     0.200
     4.329   112.184     0.200
     4.672   120.084     0.200
     4.703   120.477     0.200
     1.421    45.211     0.200
     1.801    55.211     0.200
     2.616    76.211     0.200
     2.979    82.211     0.200
     3.063    86.211     0.200
     3.491    93.910     0.200
     3.588    96.012     0.200
     3.666    97.791     0.200
     3.786   101.512     0.200
     3.809   100.822     0.200
     3.885   103.211     0.200
     4.201   108.725     0.200
     4.237   111.711     0.200
     4.471   117.910     0.200
     4.476   118.146     0.200
     4.731   124.650     0.200
     4.812   124.758     0.200
     5.514   143.512     0.200
     1.585    48.328     0.200
     2.215    65.328     0.200
     5.376   138.031     0.200
     5.488   141.125     0.200
     5.773   147.828     0.200
     6.154   157.227     0.200
     6.343   161.531     0.200
     1.386    45.887     0.200
     2.554    74.887     0.200
     2.940    81.387     0.200
     2.961    82.543     0.200
     2.989    85.887     0.200
     3.092    86.887     0.200
     3.533    94.285     0.200
     3.627    97.188     0.200
     3.701    99.195     0.200
     3.760   100.086     0.200
     3.760   102.715     0.200
     3.833   102.750     0.200
     3.926   105.387     0.200
     4.073   108.285     0.200
     4.207   111.289     0.200
     4.265   113.387     0.200
     4.473   118.305     0.200
     4.515   117.688     0.200
     4.709   124.879     0.200
     4.838   127.352     0.200
     5.334   137.488     0.200
     5.543   142.688     0.200
     1.671    50.525     0.200
     4.718   125.357     0.200
     4.754   125.402     0.200
     5.110   134.326     0.200
     5.174   135.125     0.200
     5.174   134.979     0.200
     5.244   136.926     0.200
     5.298   140.326     0.200
     5.353   140.318     0.200
     5.507   143.926     0.200
     5.544   146.725     0.200
     5.571   144.271     0.200
     5.875   153.326     0.200
     5.975   154.326     0.200
     6.004   155.365     0.200
     6.391   165.326     0.200
     6.554   167.953     0.200
     6.687   172.326     0.200
     6.947   179.426     0.200
     7.235   185.426     0.200
     8.960   227.426     0.200
     1.777    52.040     0.200
     2.852    80.484     0.200
     3.005    82.861     0.200
     3.528    96.098     0.200
     3.765   101.740     0.200
     3.890   103.940     0.200
     3.953   105.708     0.200
     4.051   109.040     0.200
     4.051   107.870     0.200
     4.110   110.540     0.200
     4.151   111.840     0.200
     4.226   111.927     0.200
     4.342   115.740     0.200
     4.407   116.540     0.200
     4.431   117.348     0.200
     4.555   120.850     0.200
     4.753   126.040     0.200
     4.970   130.540     0.200
     4.971   129.040     0.200
     5.184   135.640     0.200
     5.530   144.440     0.200
     5.689   147.040     0.200
     5.811   148.969     0.200
     2.071    60.298     0.200
     2.644    74.298     0.200
     4.401   116.267     0.200
     4.949   131.120     0.200
     5.316   138.098     0.200
     5.411   139.998     0.200
     5.482   140.799     0.200
     5.579   144.223     0.200
     5.601   145.198     0.200
     5.710   148.698     0.200
     5.841   149.074     0.200
     5.980   159.249     0.200
     6.003   153.618     0.200
     6.027   154.698     0.200
     6.296   161.198     0.200
     6.556   167.397     0.200
     6.594   168.543     0.200
     7.117   181.498     0.200
     7.303   184.646     0.200
     7.308   185.498     0.200
     7.390   185.686     0.200
     8.978   223.688     0.200
     1.066    36.641     0.200
     2.640    74.820     0.200
     3.273    92.352     0.200
     3.758    98.441     0.200
     3.813    99.641     0.200
     3.849   100.586     0.200
     3.860   101.852     0.200
     4.066   106.352     0.200
     4.094   107.844     0.200
     4.094   108.441     0.200
     4.136   107.844     0.200
     4.137   109.941     0.200
     4.328   112.441     0.200
     4.363   113.242     0.200
     4.388   114.742     0.200
     4.746   122.844     0.200
     4.882   126.555     0.200
     4.929   127.242     0.200
     5.118   131.844     0.200
     5.607   143.742     0.200
     5.620   142.059     0.200
     5.807   148.727     0.200
     6.021   154.141     0.200
     6.064   154.570     0.200
     7.241   182.730     0.200
     2.903    81.172     0.200
     3.459    94.070     0.200
     4.138   108.547     0.200
     4.191   111.445     0.200
     4.216   111.531     0.200
     4.222   110.570     0.200
     4.377   115.945     0.200
     4.492   122.555     0.200
     4.508   118.555     0.200
     4.515   118.547     0.200
     4.689   124.250     0.200
     4.744   123.750     0.200
     4.766   125.750     0.200
     5.125   134.547     0.200
     5.238   135.883     0.200
     5.483   142.047     0.200
     5.896   150.859     0.200
     5.965   154.148     0.200
     2.483    68.410     0.200
     2.730    76.650     0.200
     3.049    83.633     0.200
     3.133    88.690     0.200
     3.374    91.189     0.200
     3.736   101.450     0.200
     3.833   100.650     0.200
     3.842   101.048     0.200
     3.771    99.557     0.200
     3.870   100.450     0.200
     3.887   100.640     0.200
     3.967   105.120     0.200
     4.089   107.018     0.200
     4.201   108.750     0.200
     4.217   110.150     0.200
     4.217   109.550     0.200
     4.245   110.050     0.200
     4.322   112.050     0.200
     4.453   113.220     0.200
     4.453   115.650     0.200
     4.464   116.450     0.200
     4.463   115.550     0.200
     4.555   122.930     0.200
     4.815   123.950     0.200
     4.863   124.660     0.200
     4.962   127.550     0.200
     4.931   129.968     0.200
     5.124   131.450     0.200
     5.413   142.470     0.200
     5.477   138.148     0.200
     5.515   141.550     0.200
     5.594   142.750     0.200
     5.651   142.975     0.200
     5.651   144.563     0.200
     5.844   149.350     0.200
     5.844   148.288     0.200
     5.990   150.470     0.200
     6.005   151.850     0.200
     6.553   166.250     0.200
     7.160   181.670     0.200
     7.194   180.650     0.200
     7.194   180.110     0.200
     7.211   185.118     0.200
     7.428   186.250     0.200
     7.539   189.050     0.200
     7.782   195.850     0.200
     7.912   196.750     0.200
     8.069   201.040     0.200
     2.600    72.400     0.200
     3.072    84.716     0.200
     3.203    87.278     0.200
     3.346    92.622     0.200
     3.440    94.706     0.200
     4.073   106.495     0.200
     4.119   108.811     0.200
     4.146   106.911     0.200
     4.153   108.370     0.200
     4.131   109.679     0.200
     4.205   111.518     0.200
     4.480   116.311     0.200
     4.559   118.111     0.200
     4.557   124.850     0.200
     4.733   122.811     0.200
     4.731   123.411     0.200
     4.758   123.611     0.200
     5.090   131.326     0.200
     5.223   134.311     0.200
     5.367   137.611     0.200
     5.590   142.721     0.200
     5.771   147.511     0.200
     5.822   149.311     0.200
     7.756   194.811     0.200
     2.615    74.586     0.200
     3.113    84.086     0.200
     3.226    85.984     0.200
     3.136    87.797     0.200
     3.509    93.281     0.200
     3.522    94.891     0.200
     3.927   104.086     0.200
     4.339   113.609     0.200
     4.710   123.531     0.200
     6.748   168.336     0.200
     2.772    79.820     0.200
     3.570   100.023     0.200
     4.978   129.109     0.200
     5.023   128.828     0.200
     5.045   132.164     0.200
     5.191   132.805     0.200
     5.216   135.531     0.200
     5.254   135.711     0.200
     5.332   138.930     0.200
     5.487   142.305     0.200
     5.544   143.109     0.200
     5.593   145.508     0.200
     6.067   154.398     0.200
     6.103   158.211     0.200
     6.301   160.211     0.200
     6.720   171.656     0.200
     6.792   173.805     0.200
     6.920   174.875     0.200
     1.794    53.812     0.200
     5.185   133.330     0.200
     5.271   135.830     0.200
     5.411   139.129     0.200
     5.492   142.629     0.200
     5.823   150.830     0.200
     6.170   157.529     0.200
     6.633   167.830     0.200
     6.971   178.529     0.200
     7.140   180.229     0.200
     2.217    65.852     0.200
     2.431    68.594     0.200
     2.761    79.266     0.200
     2.935    81.914     0.200
     3.230    89.555     0.200
     3.680   102.203     0.200
     3.888   103.500     0.200
     3.953   105.102     0.200
     3.970   105.273     0.200
     3.966   110.250     0.200
     4.038   107.609     0.200
     4.905   126.312     0.200
     5.424   139.805     0.200
     1.682    48.672     0.200
     3.874   106.070     0.200
     1.668    51.031     0.200
     2.325    68.617     0.200
     2.421    71.422     0.200
     2.616    76.797     0.200
     2.635    73.523     0.200
     2.635    71.703     0.200
     2.665    75.148     0.200
     2.672    75.414     0.200
     3.139    87.883     0.200
     3.150    89.922     0.200
     3.192    87.727     0.200
     3.200    91.852     0.200
     3.294    87.680     0.200
     3.520    93.641     0.200
     3.630    97.852     0.200
     3.639    97.852     0.200
     3.650    98.711     0.200
     3.774   101.695     0.200
     3.907   106.953     0.200
     3.960   110.133     0.200
     4.029   109.562     0.200
     4.141   110.922     0.200
     4.160   114.203     0.200
     4.366   116.508     0.200
     4.508   120.906     0.200
     4.569   124.992     0.200
     4.611   121.648     0.200
     4.664   121.055     0.200
     4.678   121.211     0.200
     4.695   122.273     0.200
     4.804   124.992     0.200
     4.901   128.250     0.200
     4.940   128.148     0.200
     4.940   127.484     0.200
     4.988   128.172     0.200
     4.988   129.750     0.200
     4.988   129.750     0.200
     5.154   131.953     0.200
     5.214   134.852     0.200
     5.270   138.352     0.200
     5.250   141.430     0.200
     5.250   142.898     0.200
     5.518   143.500     0.200
     5.598   144.148     0.200
     5.700   146.617     0.200
     5.774   148.469     0.200
     5.951   153.555     0.200
     5.951   151.375     0.200
     6.288   160.750     0.200
     6.288   159.789     0.200
     6.330   162.148     0.200
     6.400   163.750     0.200
     6.429   163.555     0.200
     6.451   163.953     0.200
     6.451   164.789     0.200
     6.451   164.219     0.200
     6.453   165.664     0.200
     6.527   163.852     0.200
     6.527   165.648     0.200
     6.626   169.852     0.200
     6.841   172.953     0.200
     6.888   174.352     0.200
     7.113   183.141     0.200
     7.171   181.492     0.200
     7.313   185.750     0.200
     7.390   187.555     0.200
     7.390   186.430     0.200
     7.393   186.570     0.200
     7.771   195.852     0.200
     7.727   196.492     0.200
     7.905   200.461     0.200
     7.973   203.203     0.200
     8.035   202.055     0.200
     8.035   200.844     0.200
     8.267   206.250     0.200
     8.348   209.953     0.200
     8.378   209.250     0.200
     8.624   216.250     0.200
     8.749   218.648     0.200
     8.758   218.836     0.200
     8.907   221.828     0.200
     9.046   225.852     0.200
     9.320   231.664     0.200
     9.812   243.453     0.200
     9.979   249.250     0.200
    10.016   248.945     0.200
    10.026   250.578     0.200
    10.144   252.391     0.200
    10.174   253.062     0.200
    10.241   253.352     0.200
    10.276   254.852     0.200
    10.315   259.000     0.200
    10.378   258.766     0.200
    10.625   262.852     0.200
     1.353    44.680     0.200
     3.111    86.059     0.200
     3.169    85.656     0.200
     3.266    91.203     0.200
     3.269    86.758     0.200
     3.494    94.512     0.200
     3.615    98.492     0.200
     3.628    96.055     0.200
     3.747   101.586     0.200
     3.881   105.145     0.200
     4.001   109.156     0.200
     4.596   120.723     0.200
     4.648   120.820     0.200
     4.658   119.387     0.200
     4.678   120.633     0.200
     4.780   123.734     0.200
     4.774   127.684     0.200
     4.876   127.785     0.200
     4.929   128.320     0.200
     4.973   129.121     0.200
     4.975   128.344     0.200
     4.975   129.621     0.200
     5.135   132.023     0.200
     5.201   135.023     0.200
     5.253   138.023     0.200
     5.583   143.023     0.200
     5.680   146.121     0.200
     5.757   149.621     0.200
     5.932   152.223     0.200
     6.262   159.406     0.200
     6.312   161.723     0.200
     6.409   162.320     0.200
     6.424   164.609     0.200
     6.611   170.023     0.200
     6.821   172.121     0.200
     7.370   187.523     0.200
     7.751   194.723     0.200
     7.878   200.758     0.200
     8.014   201.320     0.200
     8.247   207.621     0.200
     8.357   209.320     0.200
     8.602   215.820     0.200
     8.729   218.422     0.200
     8.729   219.023     0.200
     8.736   218.258     0.200
     8.887   220.984     0.200
     9.026   226.023     0.200
     4.043   105.129     0.200
     4.047   104.930     0.200
     4.384   112.930     0.200
     4.999   128.629     0.200
     1.318    43.182     0.200
     1.820    52.348     0.200
     2.456    68.941     0.200
     2.683    75.791     0.200
     2.852    77.928     0.200
     2.959    82.676     0.200
     3.074    84.490     0.200
     3.253    89.094     0.200
     3.327    91.359     0.200
     3.910   102.117     0.200
     3.958   104.631     0.200
     3.984   104.830     0.200
     3.990   103.391     0.200
     3.978   105.490     0.200
     3.991   108.426     0.200
     4.063   107.879     0.200
     4.319   113.531     0.200
     4.367   116.531     0.200
     4.367   113.451     0.200
     4.387   115.131     0.200
     4.568   120.631     0.200
     4.600   120.430     0.200
     4.790   124.770     0.200
     4.934   128.031     0.200
     4.927   127.559     0.200
     5.204   135.531     0.200
     5.295   140.721     0.200
     5.449   141.486     0.200
     5.608   145.230     0.200
     5.612   146.242     0.200
     5.612   144.512     0.200
     5.660   145.930     0.200
     6.068   156.031     0.200
     6.159   157.631     0.200
     6.612   171.031     0.200
     6.999   178.930     0.200
     7.234   182.430     0.200
     7.234   182.037     0.200
     7.595   192.730     0.200
     7.813   198.031     0.200
     7.969   200.830     0.200
     9.426   231.230     0.200
     9.823   240.631     0.200
     1.228    40.184     0.200
     1.584    47.918     0.200
     1.993    57.510     0.200
     2.396    66.707     0.200
     2.476    71.188     0.200
     2.703    76.594     0.200
     2.718    77.865     0.200
     2.871    78.852     0.200
     2.978    83.516     0.200
     3.093    87.543     0.200
     3.271    89.404     0.200
     3.346    94.160     0.200
     3.660   102.061     0.200
     3.974   103.914     0.200
     4.000   104.014     0.200
     4.007   102.697     0.200
     3.997   105.199     0.200
     4.083   108.248     0.200
     4.334   112.713     0.200
     4.380   116.213     0.200
     4.380   115.150     0.200
     4.401   114.613     0.200
     4.471   120.414     0.200
     4.584   119.514     0.200
     4.614   119.713     0.200
     4.950   127.713     0.200
     4.946   124.104     0.200
     5.221   134.713     0.200
     5.313   139.600     0.200
     5.469   141.137     0.200
     5.625   144.613     0.200
     5.632   143.732     0.200
     5.678   146.914     0.200
     6.087   152.914     0.200
     6.176   157.814     0.200
     7.254   182.314     0.200
     7.502   188.314     0.200
     7.613   191.713     0.200
     1.087    36.047     0.200
     1.217    40.836     0.200
     1.286    42.516     0.200
     2.483    68.547     0.200
     2.708    76.703     0.200
     2.979    83.367     0.200
     3.098    88.641     0.200
     3.269    90.934     0.200
     4.011   109.516     0.200
     3.942   102.203     0.200
     4.007   104.922     0.200
     4.090   110.258     0.200
     3.991   104.555     0.200
     4.023   104.406     0.200
     4.017   104.055     0.200
     4.352   112.754     0.200
     4.399   116.953     0.200
     4.419   114.453     0.200
     4.601   119.754     0.200
     4.633   119.754     0.200
     4.960   128.188     0.200
     4.968   128.152     0.200
     5.237   135.754     0.200
     5.476   140.707     0.200
     5.641   144.652     0.200
     5.692   145.852     0.200
     6.101   152.254     0.200
     1.231    42.240     0.200
     1.997    59.488     0.200
     2.023    58.377     0.200
     2.480    69.477     0.200
     2.991    83.023     0.200
     3.288    92.098     0.200
     3.685   102.623     0.200
     3.920   104.980     0.200
     3.993   104.072     0.200
     3.997   107.186     0.200
     4.023   111.506     0.200
     4.087   110.703     0.200
     5.474   141.658     0.200
     1.248    40.078     0.200
     2.300    65.492     0.200
     3.070    84.863     0.200
     3.178    89.664     0.200
     5.406   138.070     0.200
     5.468   138.215     0.200
     5.545   144.270     0.200
     5.545   141.270     0.200
     5.536   141.324     0.200
     5.712   146.570     0.200
     5.758   145.676     0.200
     5.864   149.969     0.200
     5.898   150.297     0.200
     6.305   160.770     0.200
     6.556   164.711     0.200
     6.768   171.070     0.200
     7.274   182.570     0.200
     7.286   182.660     0.200
     1.250    43.120     0.200
     1.330    45.474     0.200
     2.390    70.934     0.200
     2.656    79.604     0.200
     2.855    79.340     0.200
     3.014    82.490     0.200
     3.112    86.326     0.200
     3.275    89.891     0.200
     3.978   108.388     0.200
     4.448   118.250     0.200
     4.605   120.788     0.200
     4.807   125.730     0.200
     4.837   127.690     0.200
     4.846   128.391     0.200
     5.179   136.090     0.200
     5.588   145.730     0.200
     5.792   150.990     0.200
     5.841   152.090     0.200
     1.327    44.305     0.200
     3.004    84.816     0.200
     3.690   105.238     0.200
     4.163   110.934     0.200
     5.266   135.824     0.200
     5.345   137.223     0.200
     5.449   138.879     0.200
     5.512   143.023     0.200
     5.655   145.223     0.200
     5.684   152.461     0.200
     5.770   149.039     0.200
     5.904   151.723     0.200
     6.253   160.223     0.200
     7.040   179.324     0.200
     7.158   180.824     0.200
     7.192   182.523     0.200
     7.607   192.621     0.200
     7.655   193.254     0.200
     9.572   240.133     0.200
     0.799    29.109     0.200
     1.071    37.109     0.200
     1.105    37.109     0.200
     5.403   135.922     0.200
     5.499   139.125     0.200
     5.594   142.227     0.200
     5.594   140.758     0.200
     5.668   142.930     0.200
     5.685   144.828     0.200
     5.797   146.828     0.200
     6.041   153.125     0.200
     6.091   154.273     0.200
     6.382   160.727     0.200
     7.205   182.523     0.200
     7.397   184.328     0.200
     6.095   157.047     0.200
     6.175   158.547     0.200
     6.223   161.648     0.200
     6.438   165.750     0.200
     6.668   171.750     0.200
     6.982   178.949     0.200
     1.031    38.391     0.200
     1.323    45.953     0.200
     2.470    72.211     0.200
     2.985    85.219     0.200
     3.394    96.984     0.200
     3.790   106.000     0.200
     4.745   124.359     0.200
     4.842   125.695     0.200
     5.053   132.359     0.200
     5.053   131.188     0.200
     5.108   133.359     0.200
     5.093   132.422     0.200
     5.126   133.953     0.200
     5.337   139.258     0.200
     5.377   139.555     0.200
     5.733   148.656     0.200
     6.479   167.258     0.200
     6.480   163.875     0.200
     7.010   177.234     0.200
     1.094    38.039     0.200
     2.160    61.531     0.200
     2.347    67.836     0.200
     2.980    82.211     0.200
     3.078    86.703     0.200
     3.412    91.352     0.200
     3.384    93.992     0.200
     3.517    93.750     0.200
     3.601    96.617     0.200
     3.764   103.258     0.200
     3.766   100.695     0.200
     3.808   101.453     0.200
     4.189   110.734     0.200
     4.389   114.852     0.200
     4.484   118.188     0.200
     4.773   125.320     0.200
     5.226   135.852     0.200
     5.459   141.453     0.200
     5.835   149.656     0.200
     6.075   155.648     0.200
     1.164    39.472     0.200
     1.133    39.310     0.200
     1.304    43.447     0.200
     1.359    46.013     0.200
     1.815    55.071     0.200
     2.770    81.609     0.200
     3.564    99.472     0.200
     3.688   104.806     0.200
     4.322   120.084     0.200
     4.778   129.444     0.200
     4.783   130.309     0.200
     1.251    45.076     0.200
     1.382    47.981     0.200
     1.779    54.968     0.200
     2.162    64.468     0.200
     2.309    68.397     0.200
     2.891    83.330     0.200
     3.020    86.716     0.200
     3.117    88.871     0.200
     3.384    94.005     0.200
     3.487    97.688     0.200
     3.617   102.218     0.200
     3.778   105.577     0.200
     3.860   104.893     0.200
     3.909   107.234     0.200
     3.983   104.447     0.200
     3.994   104.647     0.200
     4.231   116.088     0.200
     4.231   118.795     0.200
     4.435   116.348     0.200
     4.543   122.756     0.200
     4.867   134.845     0.200
     4.948   129.247     0.200
     5.062   135.518     0.200
     5.291   140.216     0.200
     5.585   144.947     0.200
     5.603   145.747     0.200
     1.011    37.469     0.200
     1.198    40.916     0.200
     1.106    40.643     0.200
     1.209    43.895     0.200
     1.349    46.500     0.200
     1.810    54.873     0.200
     2.340    68.172     0.200
     3.072    87.500     0.200
     3.164    88.959     0.200
     3.826   104.332     0.200
     3.886   104.832     0.200
     3.869   102.059     0.200
     3.942   105.840     0.200
     3.983   104.932     0.200
     4.281   116.371     0.200
     4.979   131.922     0.200
     5.326   139.750     0.200
     1.050    35.695     0.200
     1.154    38.840     0.200
     1.786    49.945     0.200
     1.841    53.953     0.200
     2.383    66.695     0.200
     2.968    82.520     0.200
     3.096    85.328     0.200
     3.195    87.613     0.200
     3.856   104.113     0.200
     3.919   101.820     0.200
     3.932   103.965     0.200
     3.984   105.555     0.200
     4.026   103.785     0.200
     4.034   104.105     0.200
     4.040   103.984     0.200
     5.138   134.285     0.200
     5.367   138.531     0.200
     0.810    28.770     0.200
     1.571    46.180     0.200
     2.030    58.070     0.200
     2.030    58.180     0.200
     2.569    68.730     0.200
     3.039    79.730     0.200
     3.340    88.211     0.200
     3.506    92.129     0.200
     3.549    96.371     0.200
     3.572    92.891     0.200
     3.697    99.891     0.200
     4.339   115.781     0.200
     4.614   120.949     0.200
     4.618   119.402     0.200
     4.659   119.391     0.200
     4.786   122.441     0.200
     5.196   130.633     0.200
     5.665   144.293     0.200
     2.287    65.133     0.200
     3.047    86.035     0.200
     3.691   100.465     0.200
     3.992   105.336     0.200
     4.067   107.135     0.200
     4.121   108.266     0.200
     4.182   109.414     0.200
     4.269   112.936     0.200
     4.269   111.186     0.200
     4.380   114.836     0.200
     4.443   115.266     0.200
     4.565   122.035     0.200
     4.634   120.723     0.200
     4.722   127.945     0.200
     4.980   130.535     0.200
     5.200   134.635     0.200
     5.201   133.955     0.200
     5.415   141.135     0.200
     5.761   149.436     0.200
     5.920   152.035     0.200
     6.017   152.742     0.200
     6.210   159.248     0.200
     6.335   162.336     0.200
     6.421   164.715     0.200
     6.756   173.734     0.200
     1.157    40.465     0.200
     1.714    53.228     0.200
     2.480    73.636     0.200
     2.572    74.164     0.200
     2.875    82.437     0.200
     2.946    80.846     0.200
     3.676   102.182     0.200
     3.950   106.579     0.200
     4.108   109.855     0.200
     4.360   118.184     0.200
     4.475   121.124     0.200
     4.845   125.596     0.200
     4.909   126.996     0.200
     4.950   128.145     0.200
     4.961   128.141     0.200
     5.118   131.906     0.200
     5.139   135.696     0.200
     5.135   134.806     0.200
     5.228   134.896     0.200
     5.228   135.631     0.200
     5.430   140.196     0.200
     5.522   144.896     0.200
     5.833   149.996     0.200
     5.983   152.716     0.200
     6.030   155.396     0.200
     6.030   155.166     0.200
     6.222   160.796     0.200
     6.398   163.565     0.200
     6.589   168.896     0.200
     6.615   167.116     0.200
     6.710   170.196     0.200
     6.780   171.834     0.200
     6.858   174.296     0.200
     6.858   172.884     0.200
     7.123   179.996     0.200
     7.138   179.306     0.200
     7.150   181.896     0.200
     7.675   195.196     0.200
     9.061   224.523     0.200
     9.193   229.236     0.200
     2.543    73.710     0.200
     2.903    81.856     0.200
     4.868   125.498     0.200
     4.931   126.797     0.200
     4.970   125.688     0.200
     4.976   129.436     0.200
     5.125   133.578     0.200
     5.250   134.998     0.200
     5.230   133.965     0.200
     5.999   153.217     0.200
     6.240   159.398     0.200
     6.725   171.098     0.200
     0.773    28.469     0.200
     2.939    81.312     0.200
     3.109    84.164     0.200
     3.303    85.609     0.200
     3.739    97.312     0.200
     3.762    99.961     0.200
     4.077   104.469     0.200
     4.152   104.969     0.200
     4.082   107.594     0.200
     4.205   106.312     0.200
     4.263   108.820     0.200
     4.353   110.773     0.200
     4.464   112.875     0.200
     4.516   116.102     0.200
     4.649   118.773     0.200
     4.700   120.062     0.200
     4.771   125.000     0.200
     5.065   127.969     0.200
     5.284   132.672     0.200
     5.282   133.641     0.200
     5.845   148.070     0.200
     6.001   150.070     0.200
     6.086   150.773     0.200
     6.084   151.281     0.200
     6.274   156.781     0.200
     1.185    42.008     0.200
     2.337    67.891     0.200
     3.392    91.117     0.200
     3.443    92.617     0.200
     3.476    92.648     0.200
     3.489    92.648     0.200
     3.768   101.117     0.200
     3.719    98.172     0.200
     4.020   105.539     0.200
     4.020   106.523     0.200
     3.915   103.336     0.200
     4.056   110.172     0.200
     4.379   116.320     0.200
     4.511   117.922     0.200
     4.745   124.617     0.200
     5.113   134.922     0.200
     5.296   134.797     0.200
     2.890    80.008     0.200
     3.112    86.844     0.200
     3.546    95.555     0.200
     3.852   101.328     0.200
     3.923   103.523     0.200
     3.934   107.164     0.200
     3.973   103.195     0.200
     3.907   105.805     0.200
     4.026   104.594     0.200
     4.143   106.664     0.200
     4.237   110.625     0.200
     4.283   110.742     0.200
     4.487   117.523     0.200
     4.475   115.953     0.200
     4.575   121.375     0.200
     4.840   125.328     0.200
     5.045   128.422     0.200
     5.262   136.023     0.200
     5.765   147.422     0.200
     5.858   148.633     0.200
     2.810    80.184     0.200
     3.290    90.682     0.200
     4.266   111.407     0.200
     4.343   113.607     0.200
     4.399   114.722     0.200
     4.460   117.849     0.200
     4.709   123.335     0.200
     4.903   126.808     0.200
     4.885   126.731     0.200
     5.479   141.344     0.200
     6.270   158.710     0.200
     2.165    61.312     0.200
     2.489    71.867     0.200
     2.564    74.023     0.200
     2.823    81.109     0.200
     4.006   107.609     0.200
     4.253   113.406     0.200
     4.570   120.164     0.200
     4.852   130.820     0.200
     5.157   134.570     0.200
     5.208   136.141     0.200
     5.519   144.070     0.200
     2.376    68.838     0.200
     2.548    73.045     0.200
     3.959   107.080     0.200
     4.370   118.412     0.200
     4.571   123.672     0.200
     5.301   137.234     0.200
     5.360   138.234     0.200
     5.382   139.496     0.200
     5.395   139.479     0.200
     5.384   143.311     0.200
     5.490   143.854     0.200
     5.562   146.262     0.200
     5.606   143.834     0.200
     5.663   145.334     0.200
     5.893   152.434     0.200
     6.289   161.033     0.200
     6.404   164.074     0.200
     6.475   165.633     0.200
     6.656   169.834     0.200
     7.032   178.834     0.200
     7.546   190.633     0.200
     2.162    59.824     0.200
     2.924    78.355     0.200
     3.102    81.635     0.200
     3.577    93.855     0.200
     3.882    99.836     0.200
     4.005   103.355     0.200
     4.060   104.293     0.200
     4.268   109.336     0.200
     4.317   111.076     0.200
     4.461   115.035     0.200
     4.510   115.793     0.200
     4.871   124.637     0.200
     5.079   128.646     0.200
     5.296   134.436     0.200
     5.798   145.836     0.200
     6.085   152.725     0.200
     6.214   155.535     0.200
     6.296   157.865     0.200
     7.454   185.156     0.200
     1.199    40.297     0.200
     2.141    60.883     0.200
     2.957    82.535     0.200
     4.248   110.023     0.200
     4.367   113.023     0.200
     5.212   132.625     0.200
     1.144    39.773     0.200
     1.275    40.953     0.200
     2.835    78.777     0.200
     3.638    99.758     0.200
     4.811   123.477     0.200
     4.877   125.074     0.200
     4.921   125.855     0.200
     4.939   126.793     0.200
     5.107   129.734     0.200
     5.195   133.176     0.200
     5.224   133.984     0.200
     5.392   137.977     0.200
     5.799   147.574     0.200
     5.961   151.523     0.200
     6.686   169.574     0.200
     3.329    92.550     0.200
     3.879   109.029     0.200
     5.350   139.394     0.200
     5.449   141.594     0.200
     5.629   147.320     0.200
     5.905   153.240     0.200
     6.075   158.152     0.200
     6.328   162.794     0.200
     0.349    15.754     0.200
     0.878    28.301     0.200
     1.575    45.387     0.200
     1.669    48.699     0.200
     2.018    54.855     0.200
     2.080    56.879     0.200
     2.970    79.754     0.200
     4.534   113.777     0.200
     4.613   116.617     0.200
     4.638   116.863     0.200
     4.637   116.715     0.200
     5.255   132.215     0.200
     5.547   139.125     0.200
     5.588   139.617     0.200
     6.250   157.414     0.200
     1.684    49.809     0.200
     1.893    53.516     0.200
     1.893    54.887     0.200
     1.944    56.262     0.200
     2.449    63.688     0.200
     2.511    67.688     0.200
     2.427    68.746     0.200
     2.517    69.066     0.200
     2.738    72.988     0.200
     2.887    78.688     0.200
     2.928    78.156     0.200
     3.000    80.465     0.200
     3.281    90.027     0.200
     3.367    91.141     0.200
     3.648    96.312     0.200
     3.742    99.527     0.200
     3.989   103.477     0.200
     4.046   105.566     0.200
     4.042   104.188     0.200
     4.073   104.219     0.200
     4.068   103.688     0.200
     4.068   104.508     0.200
     4.123   108.496     0.200
     4.402   113.188     0.200
     4.476   114.086     0.200
     4.451   113.746     0.200
     4.451   115.277     0.200
     4.471   113.199     0.200
     4.442   117.121     0.200
     4.650   118.586     0.200
     4.654   117.258     0.200
     4.684   119.289     0.200
     4.739   120.766     0.200
     4.807   125.895     0.200
     5.005   126.078     0.200
     5.018   127.188     0.200
     5.284   134.316     0.200
     5.284   134.188     0.200
     5.508   139.336     0.200
     5.508   139.957     0.200
     5.668   142.586     0.200
     5.668   144.559     0.200
     5.690   144.188     0.200
     5.738   142.988     0.200
     5.794   149.488     0.200
     5.792   152.016     0.200
     6.046   152.355     0.200
     6.046   153.988     0.200
     6.085   152.176     0.200
     6.146   155.188     0.200
     6.240   155.688     0.200
     6.296   159.387     0.200
     6.388   158.469     0.200
     6.613   163.457     0.200
     6.656   167.586     0.200
     6.689   165.086     0.200
     6.689   167.188     0.200
     6.766   169.887     0.200
     7.077   178.688     0.200
     7.061   180.227     0.200
     7.309   182.297     0.200
     7.309   181.988     0.200
     7.560   187.387     0.200
     7.885   196.387     0.200
     8.019   199.355     0.200
     8.046   198.086     0.200
     8.202   201.609     0.200
     8.421   212.254     0.200
     8.404   212.863     0.200
     8.630   212.418     0.200
     9.098   223.367     0.200
     9.247   229.316     0.200
     9.244   228.320     0.200
     9.436   232.379     0.200
     9.450   230.953     0.200
     9.468   231.188     0.200
     9.534   236.531     0.200
     9.603   241.359     0.200
     9.860   239.988     0.200
    10.811   262.586     0.200
    12.115   293.289     0.200
    12.096   293.988     0.200
    12.274   297.488     0.200
    13.051   317.086     0.200
    13.070   317.387     0.200
    13.371   323.688     0.200
    13.812   334.387     0.200
    13.806   335.289     0.200
    13.920   338.586     0.200
    14.225   344.086     0.200
    14.304   347.789     0.200
    14.331   348.488     0.200
    14.471   350.887     0.200
    14.645   355.887     0.200
    14.769   355.887     0.200
    15.068   363.488     0.200
    15.066   366.387     0.200
    16.295   395.586     0.200
    16.343   396.688     0.200
    16.520   399.988     0.200
    16.990   411.688     0.200
     1.072    38.312     0.200
     1.045    36.484     0.200
     1.833    52.938     0.200
     1.836    52.938     0.200
     1.871    56.984     0.200
     2.402    67.172     0.200
     2.402    67.758     0.200
     2.881    77.445     0.200
     2.881    78.477     0.200
     2.794    81.023     0.200
     3.037    83.469     0.200
     3.156    83.688     0.200
     3.443    92.406     0.200
     3.589    94.617     0.200
     4.152   108.711     0.200
     4.445   114.758     0.200
     4.465   115.750     0.200
     4.537   117.844     0.200
     4.534   120.062     0.200
     4.686   121.016     0.200
     4.692   122.266     0.200
     4.700   120.969     0.200
     4.700   120.586     0.200
     4.720   121.789     0.200
     5.033   130.469     0.200
     5.039   129.867     0.200
     5.135   132.484     0.200
     5.135   133.734     0.200
     5.143   130.836     0.200
     5.143   132.867     0.200
     5.262   135.469     0.200
     5.290   135.570     0.200
     5.324   139.414     0.200
     5.350   138.266     0.200
     5.538   141.141     0.200
     5.655   145.164     0.200
     5.708   149.586     0.200
     5.809   147.836     0.200
     5.847   149.469     0.200
     5.865   148.984     0.200
     5.935   150.680     0.200
     6.271   159.664     0.200
     6.517   165.086     0.200
     6.671   168.766     0.200
     6.680   169.586     0.200
     6.680   170.266     0.200
     6.817   172.469     0.200
     6.893   174.969     0.200
     6.876   173.758     0.200
     7.201   184.070     0.200
     7.201   184.359     0.200
     7.224   183.867     0.200
     7.264   181.844     0.200
     7.598   192.070     0.200
     7.776   194.398     0.200
     7.776   195.164     0.200
     8.059   200.766     0.200
     8.195   206.625     0.200
     8.326   210.070     0.200
     8.457   210.984     0.200
     8.549   213.766     0.200
     8.704   216.891     0.200
     8.855   221.766     0.200
     9.503   235.438     0.200
     9.583   237.406     0.200
     9.596   237.984     0.200
     9.692   241.148     0.200
     9.874   244.898     0.200
     9.965   246.453     0.200
    10.240   253.469     0.200
    10.243   256.367     0.200
    10.773   267.766     0.200
    10.994   273.766     0.200
    11.251   286.570     0.200
    13.550   330.766     0.200
     2.229    63.785     0.200
     2.455    67.066     0.200
     2.963    78.551     0.200
     3.260    86.363     0.200
     3.901   102.133     0.200
     3.945   101.746     0.200
     3.973   103.695     0.200
     3.972   101.348     0.200
     3.979   101.047     0.200
     3.995   108.422     0.200
     4.062   104.957     0.200
     4.306   110.145     0.200
     4.372   114.047     0.200
     4.558   114.477     0.200
     4.558   116.848     0.200
     4.586   116.645     0.200
     4.919   124.820     0.200
     4.922   125.348     0.200
     5.194   132.047     0.200
     5.449   138.020     0.200
     5.597   140.246     0.200
     5.613   141.836     0.200
     5.651   142.848     0.200
     5.783   147.613     0.200
     6.009   150.176     0.200
     1.073    36.758     0.200
     1.204    40.070     0.200
     2.068    59.977     0.200
     5.882   150.859     0.200
     5.963   152.062     0.200
     6.019   152.547     0.200
     6.064   154.008     0.200
     6.117   156.977     0.200
     6.117   157.258     0.200
     6.196   158.758     0.200
     6.272   160.062     0.200
     6.239   157.828     0.200
     6.520   166.961     0.200
     6.868   174.461     0.200
     7.086   177.211     0.200
     7.310   184.859     0.200
     7.808   197.156     0.200
     2.139    63.439     0.200
     2.662    78.265     0.200
     3.346    92.616     0.200
     3.321    95.213     0.200
     4.155   115.028     0.200
     4.595   120.877     0.200
     4.638   121.277     0.200
     4.642   124.787     0.200
     4.701   124.425     0.200
     4.777   125.185     0.200
     4.967   129.977     0.200
     4.989   130.977     0.200
     5.219   135.677     0.200
     5.635   143.227     0.200
     2.387    66.279     0.200
     2.388    70.162     0.200
     2.450    71.635     0.200
     2.503    71.076     0.200
     2.904    81.510     0.200
     2.904    80.742     0.200
     2.957    81.812     0.200
     3.039    81.801     0.200
     3.264    88.342     0.200
     3.408    92.143     0.200
     3.521    94.525     0.200
     3.651    99.082     0.200
     3.784   102.576     0.200
     3.784   103.812     0.200
     3.888   106.643     0.200
     4.131   109.459     0.200
     4.131   110.463     0.200
     4.413   115.012     0.200
     4.459   115.512     0.200
     4.459   115.402     0.200
     4.446   116.307     0.200
     4.482   116.184     0.200
     4.553   117.168     0.200
     4.553   119.512     0.200
     4.549   123.617     0.200
     4.645   120.529     0.200
     4.767   124.775     0.200
     4.767   125.693     0.200
     4.786   124.213     0.200
     4.806   125.412     0.200
     4.925   126.812     0.200
     5.029   130.812     0.200
     5.038   130.512     0.200
     5.058   129.812     0.200
     5.001   134.742     0.200
     5.203   133.682     0.200
     5.285   137.168     0.200
     5.399   139.113     0.200
     5.467   140.137     0.200
     5.726   147.312     0.200
     5.825   153.629     0.200
     6.032   152.811     0.200
     6.032   152.422     0.200
     6.113   156.812     0.200
     6.171   161.312     0.200
     6.197   156.912     0.200
     6.194   157.262     0.200
     6.273   166.492     0.200
     6.427   164.883     0.200
     6.584   164.928     0.200
     6.608   166.512     0.200
     6.669   170.412     0.200
     6.711   170.012     0.200
     7.092   178.912     0.200
     7.156   181.113     0.200
     7.156   181.232     0.200
     7.137   179.117     0.200
     7.207   182.213     0.200
     7.207   184.352     0.200
     7.539   190.012     0.200
     7.510   191.961     0.200
     7.510   193.072     0.200
     7.651   192.287     0.200
     7.729   197.625     0.200
     7.794   195.531     0.200
     8.031   201.312     0.200
     8.507   211.977     0.200
     8.515   212.213     0.200
     8.513   212.316     0.200
     8.672   216.465     0.200
     9.089   225.773     0.200
     9.494   234.613     0.200
     9.762   241.277     0.200
     9.769   241.984     0.200
     9.792   245.514     0.200
     9.912   246.072     0.200
    10.021   250.912     0.200
     9.988   246.512     0.200
    10.021   247.012     0.200
    10.060   249.793     0.200
    10.074   257.377     0.200
    10.125   253.748     0.200
    10.244   256.908     0.200
    10.244   256.613     0.200
    10.244   258.133     0.200
    10.375   255.113     0.200
    14.229   348.512     0.200
    14.444   352.412     0.200
    14.829   361.113     0.200
    14.854   361.412     0.200
    15.171   369.012     0.200
    15.492   377.312     0.200
     1.151    42.195     0.200
     1.242    45.031     0.200
     2.708    80.598     0.200
     2.186    64.031     0.200
     2.382    68.828     0.200
     2.904    80.332     0.200
     3.034    80.734     0.200
     3.384    91.656     0.200
     3.402    89.023     0.200
     3.518    93.707     0.200
     3.648    97.906     0.200
     3.783   101.562     0.200
     3.885   104.945     0.200
     4.405   115.055     0.200
     4.439   114.922     0.200
     4.450   115.656     0.200
     4.474   115.445     0.200
     4.547   116.406     0.200
     4.547   121.605     0.200
     4.641   119.797     0.200
     4.758   123.117     0.200
     4.758   124.355     0.200
     4.778   124.055     0.200
     4.797   122.727     0.200
     4.797   125.457     0.200
     4.918   126.855     0.200
     5.020   130.355     0.200
     4.999   132.938     0.200
     4.999   133.902     0.200
     5.030   127.555     0.200
     5.030   130.355     0.200
     5.050   130.156     0.200
     5.390   138.855     0.200
     5.460   138.984     0.200
     5.551   142.855     0.200
     5.719   147.457     0.200
     5.824   151.328     0.200
     6.028   151.773     0.200
     6.105   156.258     0.200
     6.190   156.855     0.200
     6.190   156.555     0.200
     6.190   156.793     0.200
     6.419   162.426     0.200
     6.577   164.457     0.200
     6.601   166.258     0.200
     6.662   168.656     0.200
     6.703   171.156     0.200
     7.084   180.457     0.200
     7.149   180.656     0.200
     7.532   190.457     0.200
     7.649   192.098     0.200
     7.787   195.957     0.200
     8.025   200.855     0.200
     8.373   210.457     0.200
     8.507   210.184     0.200
     8.665   213.445     0.200
     8.806   219.355     0.200
     9.757   240.117     0.200
    10.057   249.984     0.200
     3.365    93.438     0.200
     4.500   117.961     0.200
     4.543   116.262     0.200
     4.872   125.363     0.200
     5.484   141.961     0.200
     2.478    72.295     0.200
     4.464   118.857     0.200
     4.508   117.156     0.200
     4.860   129.756     0.200
     5.082   132.256     0.200
     5.088   132.457     0.200
     5.449   142.057     0.200
     6.159   157.756     0.200
     3.040    80.614     0.200
     3.389    96.475     0.200
     3.441    96.178     0.200
     3.507    92.104     0.200
     3.644    99.634     0.200
     3.762   100.932     0.200
     4.203   111.907     0.200
     4.468   114.642     0.200
     4.492   115.774     0.200
     4.513   115.244     0.200
     4.534   121.884     0.200
     4.562   116.634     0.200
     4.646   120.042     0.200
     4.809   123.084     0.200
     4.809   125.774     0.200
     4.821   125.474     0.200
     4.982   134.034     0.200
     5.068   131.874     0.200
     5.073   129.164     0.200
     5.073   131.474     0.200
     5.434   140.674     0.200
     5.489   139.774     0.200
     5.752   147.774     0.200
     6.032   152.070     0.200
     6.142   157.774     0.200
     6.220   158.774     0.200
     3.003    81.445     0.200
     3.456    94.121     0.200
     3.705   100.484     0.200
     3.822   105.566     0.200
     4.453   117.570     0.200
     4.455   115.906     0.200
     4.455   116.598     0.200
     4.492   116.867     0.200
     4.510   116.867     0.200
     4.482   123.363     0.200
     4.533   118.734     0.200
     4.608   120.246     0.200
     4.822   125.082     0.200
     4.822   127.270     0.200
     4.822   125.969     0.200
     4.856   127.668     0.200
     4.928   133.379     0.200
     5.075   133.070     0.200
     5.436   140.969     0.200
     5.474   140.891     0.200
     5.584   142.770     0.200
     5.742   148.367     0.200
     5.993   152.742     0.200
     6.150   156.598     0.200
     6.206   158.570     0.200
     7.097   179.266     0.200
     7.097   179.539     0.200
     7.789   195.137     0.200
     7.789   197.270     0.200
     5.596   146.797     0.200
     1.198    42.769     0.200
     2.985    87.959     0.200
     3.293    95.134     0.200
     3.457    95.880     0.200
     3.509   100.189     0.200
     4.057   109.309     0.200
     4.225   115.534     0.200
     4.476   122.748     0.200
     4.472   119.969     0.200
     4.760   129.496     0.200
     5.028   135.822     0.200
     5.127   138.817     0.200
     5.208   136.709     0.200
     5.297   139.209     0.200
     5.361   139.705     0.200
     5.425   141.500     0.200
     5.425   142.409     0.200
     5.439   142.471     0.200
     5.508   143.909     0.200
     5.600   146.609     0.200
     5.678   148.315     0.200
     5.747   149.809     0.200
     5.846   152.109     0.200
     5.829   152.117     0.200
     5.893   153.309     0.200
     6.191   160.909     0.200
     6.457   165.922     0.200
     6.665   172.209     0.200
     6.999   181.409     0.200
     7.174   183.509     0.200
     7.203   185.185     0.200
     7.203   186.509     0.200
     7.217   183.454     0.200
     7.394   189.735     0.200
     7.590   193.709     0.200
     7.672   196.676     0.200
     8.148   208.209     0.200
     8.835   224.322     0.200
     9.580   242.413     0.200
     9.663   243.226     0.200
     2.364    69.660     0.200
     5.378   139.790     0.200
     5.436   140.390     0.200
     5.740   148.790     0.200
     1.221    43.254     0.200
     1.959    59.609     0.200
     2.286    68.254     0.200
     3.053    87.164     0.200
     3.487    95.035     0.200
     3.469    96.676     0.200
     3.696   103.133     0.200
     4.568   118.883     0.200
     4.546   120.961     0.200
     4.489   122.074     0.200
     4.616   121.742     0.200
     4.598   122.734     0.200
     4.654   124.613     0.200
     4.947   129.922     0.200
     4.947   131.383     0.200
     4.935   128.582     0.200
     5.197   136.684     0.200
     5.550   143.684     0.200
     5.564   144.414     0.200
     5.689   146.984     0.200
     6.036   156.871     0.200
     6.239   160.785     0.200
     0.967    33.434     0.200
     1.334    40.840     0.200
     3.053    84.688     0.200
     4.697   120.902     0.200
     4.754   121.203     0.200
     4.789   122.422     0.200
     4.782   120.820     0.200
     5.014   129.602     0.200
     4.918   124.922     0.200
     5.066   129.402     0.200
     5.077   129.500     0.200
     5.294   135.102     0.200
     5.685   144.703     0.200
     5.804   145.992     0.200
     6.425   161.703     0.200
     1.175    43.577     0.200
     1.450    47.137     0.200
     1.711    51.717     0.200
     2.694    78.622     0.200
     2.854    82.800     0.200
     2.728    78.356     0.200
     2.939    84.569     0.200
     3.374    94.312     0.200
     3.399    95.151     0.200
     3.277    95.303     0.200
     3.652    98.552     0.200
     3.719   100.151     0.200
     3.765   101.052     0.200
     3.753   104.580     0.200
     3.813   101.740     0.200
     4.073   109.702     0.200
     3.939   111.022     0.200
     4.240   114.151     0.200
     4.400   120.162     0.200
     4.641   122.352     0.200
     4.846   128.151     0.200
     5.405   142.151     0.200
     5.553   144.151     0.200
     5.665   147.660     0.200
     5.654   144.750     0.200
     5.777   154.262     0.200
     5.851   151.464     0.200
     6.048   156.452     0.200
     7.207   182.751     0.200
     7.433   190.332     0.200
     7.952   201.819     0.200
     8.041   202.342     0.200
     0.969    32.465     0.200
     1.824    52.121     0.200
     1.817    51.164     0.200
     2.083    58.129     0.200
     2.806    76.723     0.200
     3.490    91.797     0.200
     3.452    94.457     0.200
     3.636   101.035     0.200
     4.677   118.992     0.200
     4.691   121.395     0.200
     4.769   119.855     0.200
     0.885    31.070     0.200
     1.731    50.367     0.200
     2.365    67.574     0.200
     3.496    91.156     0.200
     3.560    93.426     0.200
     3.668    98.906     0.200
     3.707   101.074     0.200
     4.512   119.379     0.200
     4.624   116.625     0.200
     4.659   119.957     0.200
     4.661   119.988     0.200
     4.693   120.289     0.200
     4.702   122.254     0.200
     4.704   118.906     0.200
     5.026   128.586     0.200
     5.045   129.238     0.200
     5.045   129.387     0.200
     5.075   129.988     0.200
     5.281   134.586     0.200
     5.293   135.387     0.200
     5.641   143.488     0.200
     6.082   152.547     0.200
     6.324   160.188     0.200
     6.373   161.688     0.200
     2.083    60.480     0.200
     2.143    63.305     0.200
     3.540    94.414     0.200
     4.178   115.578     0.200
     4.478   117.344     0.200
     4.501   116.785     0.200
     4.522   116.445     0.200
     4.544   117.270     0.200
     4.597   118.449     0.200
     4.681   120.465     0.200
     4.835   124.480     0.200
     4.835   123.145     0.200
     4.850   124.344     0.200
     4.873   127.145     0.200
     5.463   141.145     0.200
     6.173   157.043     0.200
     6.253   158.246     0.200
     0.996    33.520     0.200
     1.192    39.344     0.200
     2.878    80.227     0.200
     2.958    83.805     0.200
     3.338    92.746     0.200
     3.567    98.773     0.200
     3.780   102.910     0.200
     4.039   102.539     0.200
     4.115   105.180     0.200
     4.400   111.652     0.200
     6.367   159.590     0.200
     0.893    33.314     0.200
     1.008    35.740     0.200
     1.091    38.920     0.200
     2.664    75.393     0.200
     3.032    84.982     0.200
     3.725    96.348     0.200
     3.737    99.818     0.200
     3.849    99.545     0.200
     1.124    39.148     0.200
     1.206    42.414     0.200
     1.211    42.070     0.200
     1.249    43.023     0.200
     1.643    51.781     0.200
     1.741    54.273     0.200
     2.041    57.789     0.200
     2.042    58.758     0.200
     2.498    70.180     0.200
     2.554    71.445     0.200
     2.685    78.227     0.200
     2.803    77.211     0.200
     2.954    83.945     0.200
     3.051    84.336     0.200
     3.533    99.648     0.200
     3.898   104.969     0.200
     3.977   106.852     0.200
     3.933   108.914     0.200
     4.159   109.273     0.200
     4.389   113.820     0.200
     4.431   117.516     0.200
     4.452   117.117     0.200
     4.773   125.914     0.200
     4.689   125.625     0.200
     4.945   129.719     0.200
     4.963   128.367     0.200
     4.963   130.414     0.200
     5.134   134.719     0.200
     5.383   140.117     0.200
     5.354   139.508     0.200
     5.409   140.117     0.200
     5.861   151.414     0.200
     6.394   165.914     0.200
     6.554   170.016     0.200
     6.767   175.617     0.200
     2.081    61.759     0.200
     2.385    70.009     0.200
     3.247    88.100     0.200
     3.410    91.265     0.200
     3.496    96.159     0.200
     3.632    99.600     0.200
     3.753   102.377     0.200
     3.862   105.518     0.200
     4.095   111.938     0.200
     4.433   115.999     0.200
     4.453   116.117     0.200
     4.476   116.600     0.200
     4.497   116.659     0.200
     4.523   121.149     0.200
     4.548   118.060     0.200
     4.632   121.268     0.200
     4.793   125.329     0.200
     4.793   125.899     0.200
     4.805   125.399     0.200
     4.831   126.600     0.200
     4.934   127.299     0.200
     4.972   135.279     0.200
     5.052   131.199     0.200
     5.074   131.799     0.200
     5.418   140.799     0.200
     5.573   143.100     0.200
     5.573   142.770     0.200
     6.018   153.167     0.200
     6.178   157.812     0.200
     6.204   158.399     0.200
     6.581   166.579     0.200
     6.615   167.600     0.200
     6.725   172.299     0.200
     6.896   173.930     0.200
     7.162   182.699     0.200
     7.545   191.199     0.200
     7.627   194.369     0.200
     7.795   194.520     0.200
     7.795   197.999     0.200
     8.036   203.699     0.200
     8.147   205.600     0.200
     8.378   210.399     0.200
     8.512   213.377     0.200
     8.520   213.999     0.200
     8.677   216.569     0.200
     8.818   221.899     0.200
     1.096    39.853     0.200
     1.473    44.254     0.200
     2.692    75.464     0.200
     2.969    84.572     0.200
     3.059    87.442     0.200
     3.338    93.502     0.200
     3.796   100.204     0.200
     3.928   102.544     0.200
     3.845   103.643     0.200
     3.936   102.444     0.200
     2.675    75.918     0.200
     2.971    83.527     0.200
     3.707   101.387     0.200
     3.713    97.633     0.200
     3.733    98.566     0.200
     3.831    98.699     0.200
     2.109    61.445     0.200
     2.404    68.688     0.200
     3.500    93.883     0.200
     3.752   101.953     0.200
     3.866   103.109     0.200
     4.461   114.586     0.200
     4.475   115.234     0.200
     4.503   115.586     0.200
     4.523   116.695     0.200
     4.564   117.031     0.200
     4.645   121.062     0.200
     4.832   123.688     0.200
     4.974   130.156     0.200
     5.081   131.383     0.200
     5.445   141.383     0.200
     6.030   152.727     0.200
     6.151   157.086     0.200
     6.188   157.086     0.200
     6.227   158.281     0.200
     4.518   118.078     0.200
     4.541   116.518     0.200
     4.603   119.139     0.200
     4.690   121.205     0.200
     4.846   126.078     0.200
     4.866   127.777     0.200
     1.906    56.274     0.200
     2.902    82.185     0.200
     3.386    92.973     0.200
     3.478    93.403     0.200
     3.604    96.991     0.200
     3.846   101.621     0.200
     4.459   122.226     0.200
     4.793   125.989     0.200
     4.824   125.243     0.200
     4.898   126.761     0.200
     5.037   130.693     0.200
     5.040   131.303     0.200
     5.050   131.193     0.200
     5.388   139.293     0.200
     5.464   141.763     0.200
     5.479   141.993     0.200
     5.616   145.893     0.200
     5.639   142.613     0.200
     5.689   147.193     0.200
     6.004   153.993     0.200
     6.097   155.993     0.200
     6.208   158.793     0.200
     6.633   169.793     0.200
     6.636   169.793     0.200
     1.175    39.684     0.200
     1.241    43.012     0.200
     1.320    42.527     0.200
     5.427   140.359     0.200
     5.525   141.961     0.200
     5.600   142.508     0.200
     5.705   146.605     0.200
     5.821   149.262     0.200
     5.944   152.562     0.200
     5.976   151.887     0.200
     6.143   157.020     0.200
     6.405   162.762     0.200
     7.431   189.062     0.200
     7.530   190.508     0.200
     3.811    97.512     0.200
     3.847    97.961     0.200
     3.860    98.898     0.200
     4.069   105.449     0.200
     4.133   106.410     0.200
     4.133   106.312     0.200
     4.239   107.078     0.200
     4.742   120.012     0.200
     5.117   129.012     0.200
     5.484   137.910     0.200
     5.607   141.012     0.200
     2.051    60.953     0.200
     3.464    91.049     0.200
     3.561    95.510     0.200
     4.471   115.562     0.200
     4.517   115.764     0.200
     4.503   116.439     0.200
     4.540   117.318     0.200
     4.606   121.770     0.200
     4.588   124.201     0.200
     4.694   121.797     0.200
     4.824   124.799     0.200
     4.824   124.463     0.200
     4.844   125.863     0.200
     4.864   126.062     0.200
     5.087   130.363     0.200
     5.096   131.264     0.200
     5.457   140.363     0.200
     5.617   142.764     0.200
     5.784   147.264     0.200
     6.171   157.463     0.200
     6.638   167.885     0.200
     2.957    82.852     0.200
     3.409    93.043     0.200
     3.775   100.434     0.200
     3.853   102.602     0.200
     4.046   106.695     0.200
     4.310   112.773     0.200
     4.413   118.062     0.200
     4.651   123.191     0.200
     4.735   122.395     0.200
     4.800   123.695     0.200
     4.843   125.355     0.200
     4.859   125.582     0.200
     5.028   128.922     0.200
     5.028   128.492     0.200
     5.088   129.754     0.200
     5.088   130.895     0.200
     5.118   131.195     0.200
     5.075   135.902     0.200
     5.146   132.762     0.200
     5.319   136.992     0.200
     5.328   136.195     0.200
     5.369   136.312     0.200
     5.369   138.793     0.200
     5.414   138.992     0.200
     5.528   147.152     0.200
     5.723   145.094     0.200
     5.923   150.492     0.200
     5.923   151.473     0.200
     6.118   156.293     0.200
     6.482   165.094     0.200
     6.534   164.973     0.200
     6.607   167.293     0.200
     6.703   168.867     0.200
     6.748   169.641     0.200
     6.748   172.094     0.200
     7.021   175.793     0.200
     7.043   176.594     0.200
     7.574   192.195     0.200
     7.640   191.793     0.200
     7.949   198.793     0.200
     8.175   206.344     0.200
     8.234   206.773     0.200
     8.234   205.695     0.200
     8.453   212.492     0.200
     8.563   214.195     0.200
     8.830   220.195     0.200
     8.933   222.195     0.200
     8.965   224.590     0.200
     9.091   228.145     0.200
     9.227   230.492     0.200
     9.495   235.465     0.200
    10.001   248.211     0.200
    10.246   253.633     0.200
     1.587    50.508     0.200
     2.305    67.055     0.200
     3.467    96.695     0.200
     3.468    97.625     0.200
     4.014   109.984     0.200
     4.190   112.602     0.200
     4.430   118.492     0.200
     4.737   126.648     0.200
     4.842   128.422     0.200
     5.147   133.570     0.200
     5.012   135.523     0.200
     5.105   137.781     0.200
     5.238   134.977     0.200
     5.304   137.602     0.200
     5.361   137.852     0.200
     5.361   138.773     0.200
     5.387   139.969     0.200
     5.540   143.773     0.200
     5.684   147.070     0.200
     5.636   146.859     0.200
     5.839   150.570     0.200
     5.864   151.375     0.200
     5.793   149.539     0.200
     5.768   152.906     0.200
     6.380   163.875     0.200
     6.380   164.133     0.200
     6.609   169.477     0.200
     6.941   176.773     0.200
     7.141   182.836     0.200
     7.141   183.773     0.200
     7.120   182.172     0.200
     7.181   181.820     0.200
     7.518   188.164     0.200
     7.360   186.750     0.200
     7.507   192.273     0.200
     7.537   189.773     0.200
     7.625   192.281     0.200
     7.941   201.477     0.200
     8.101   205.867     0.200
     8.287   208.617     0.200
     8.784   221.945     0.200
     8.784   221.672     0.200
     8.861   225.484     0.200
     8.978   227.273     0.200
     9.086   228.273     0.200
     9.396   236.570     0.200
     9.531   238.945     0.200
     9.728   247.445     0.200
     9.610   241.125     0.200
    10.529   262.094     0.200
    10.859   271.680     0.200
    10.926   273.812     0.200
     1.144    38.277     0.200
     1.273    41.736     0.200
     2.808    80.547     0.200
     2.815    77.812     0.200
     3.884   102.107     0.200
     3.960   104.107     0.200
     4.014   103.430     0.200
     4.080   104.842     0.200
     4.161   107.734     0.200
     4.161   109.508     0.200
     4.352   113.438     0.200
     4.456   116.908     0.200
     4.534   116.107     0.200
     4.551   115.689     0.200
     4.660   124.049     0.200
     4.872   126.008     0.200
     5.309   135.709     0.200
     5.815   147.008     0.200
     5.933   148.920     0.200
     1.128    39.852     0.200
     1.302    44.227     0.200
     1.332    44.375     0.200
     2.870    81.562     0.200
     2.975    85.766     0.200
     3.008    85.117     0.200
     3.357    91.266     0.200
     3.919   102.664     0.200
     3.829   103.227     0.200
     4.337   113.062     0.200
     4.502   120.062     0.200
     4.546   118.375     0.200
     1.225    42.926     0.200
     1.305    44.514     0.200
     1.334    45.580     0.200
     2.404    70.334     0.200
     2.721    79.041     0.200
     2.821    81.529     0.200
     2.893    82.029     0.200
     3.100    90.113     0.200
     3.156    91.572     0.200
     3.450    97.113     0.200
     3.769   105.467     0.200
     4.312   117.711     0.200
     4.753   126.311     0.200
     4.794   126.254     0.200
     4.794   126.936     0.200
     4.815   127.854     0.200
     5.018   133.354     0.200
     5.137   135.654     0.200
     5.495   144.453     0.200
     5.747   148.754     0.200
     2.886    82.461     0.200
     2.592    74.039     0.200
     3.394    94.438     0.200
     4.886   124.758     0.200
     4.963   126.664     0.200
     5.274   133.859     0.200
     5.526   141.062     0.200
     5.523   143.258     0.200
     1.353    44.445     0.200
     3.061    88.344     0.200
     3.900   103.023     0.200
     3.954   103.344     0.200
     4.021   105.211     0.200
     4.165   111.727     0.200
     4.212   111.727     0.200
     4.297   112.328     0.200
     4.501   118.336     0.200
     5.039   130.172     0.200
     5.756   147.930     0.200
     2.748    77.999     0.200
     3.077    85.900     0.200
     3.626    96.705     0.200
     3.817   101.039     0.200
     3.895   102.432     0.200
     3.967   101.632     0.200
     3.900   105.506     0.200
     4.017   101.476     0.200
     4.072   102.615     0.200
     4.281   109.332     0.200
     4.328   110.721     0.200
     4.473   116.231     0.200
     4.530   114.622     0.200
     4.530   117.531     0.200
     4.519   115.388     0.200
     4.613   121.717     0.200
     4.883   126.531     0.200
     5.098   133.515     0.200
     5.308   134.932     0.200
     5.810   145.731     0.200
     5.902   149.085     0.200
     6.307   157.625     0.200
     0.449    18.188     0.200
     0.955    31.445     0.200
     1.099    33.805     0.200
     1.079    32.328     0.200
     1.254    37.633     0.200
     1.386    41.461     0.200
     2.163    59.141     0.200
     2.555    70.039     0.200
     2.654    70.922     0.200
     2.543    70.336     0.200
     2.658    72.102     0.200
     4.104   102.992     0.200
     4.195   105.094     0.200
     4.497   112.992     0.200
     4.742   116.773     0.200
     5.087   127.094     0.200
     6.094   150.789     0.200
     3.420    95.328     0.200
     5.194   134.117     0.200
     5.275   135.914     0.200
     5.436   140.117     0.200
     5.436   140.734     0.200
     5.512   139.594     0.200
     5.512   142.219     0.200
     5.584   143.617     0.200
     5.749   148.117     0.200
     5.846   149.320     0.200
     5.897   150.719     0.200
     6.180   157.820     0.200
     6.411   164.719     0.200
     6.626   168.414     0.200
     6.971   177.516     0.200
     7.127   180.016     0.200
     7.197   184.016     0.200
     7.543   189.719     0.200
     8.981   226.117     0.200
     9.089   228.320     0.200
     1.163    39.406     0.200
     1.620    48.273     0.200
     2.447    70.750     0.200
     2.602    74.578     0.200
     2.842    79.703     0.200
     2.951    83.258     0.200
     3.002    83.469     0.200
     3.252    90.609     0.200
     3.541    95.273     0.200
     3.715    99.031     0.200
     3.887   104.320     0.200
     4.135   107.773     0.200
     4.540   119.750     0.200
     4.721   124.586     0.200
     4.890   126.062     0.200
     4.974   127.961     0.200
     4.974   127.492     0.200
     5.034   128.594     0.200
     5.102   131.117     0.200
     5.127   132.961     0.200
     5.204   132.625     0.200
     5.204   133.961     0.200
     5.281   135.367     0.200
     5.336   137.227     0.200
     5.441   140.562     0.200
     5.470   142.133     0.200
     5.491   141.102     0.200
     5.528   140.375     0.200
     5.528   142.961     0.200
     5.558   141.367     0.200
     5.598   143.461     0.200
     5.876   150.062     0.200
     6.112   155.961     0.200
     6.121   154.422     0.200
     6.333   160.664     0.200
     6.673   169.766     0.200
     6.839   172.961     0.200
     7.057   178.727     0.200
     7.255   182.461     0.200
     8.496   213.766     0.200
     8.803   220.367     0.200
     9.239   228.438     0.200
     2.221    62.914     0.200
     3.428    91.102     0.200
     3.468    90.805     0.200
     3.797    98.906     0.200
     3.939   101.805     0.200
     4.050   104.203     0.200
     4.411   113.500     0.200
     1.264    43.008     0.200
     1.507    47.100     0.200
     1.788    53.957     0.200
     2.205    66.348     0.200
     2.983    86.119     0.200
     4.290   114.516     0.200
     5.260   137.428     0.200
     5.350   138.143     0.200
     5.417   141.482     0.200
     5.472   142.229     0.200
     5.498   142.957     0.200
     5.557   144.029     0.200
     5.653   146.428     0.200
     5.742   148.439     0.200
     5.899   153.129     0.200
     5.894   152.803     0.200
     5.951   152.828     0.200
     6.243   160.729     0.200
     6.492   166.828     0.200
     6.516   167.529     0.200
     6.722   172.328     0.200
     7.232   184.229     0.200
     1.040    37.055     0.200
     1.146    39.812     0.200
     1.239    41.758     0.200
     1.731    50.258     0.200
     2.329    65.000     0.200
     2.760    76.758     0.200
     2.906    80.539     0.200
     3.024    83.680     0.200
     3.127    87.336     0.200
     3.787   103.211     0.200
     3.889   100.789     0.200
     3.885   103.828     0.200
     3.928   104.430     0.200
     4.016   104.258     0.200
     4.016   102.977     0.200
     4.026   104.555     0.200
     4.365   113.555     0.200
     4.382   112.555     0.200
     4.616   118.016     0.200
     4.616   119.055     0.200
     4.898   124.945     0.200
     4.981   128.461     0.200
     5.075   130.758     0.200
     5.066   133.547     0.200
     5.194   133.461     0.200
     5.309   136.000     0.200
     5.460   140.336     0.200
     5.616   143.555     0.200
     5.631   144.359     0.200
     0.998    37.594     0.200
     1.502    47.645     0.200
     1.767    54.914     0.200
     2.197    64.727     0.200
     2.776    80.301     0.200
     2.978    83.992     0.200
     3.262    90.820     0.200
     3.412    94.629     0.200
     3.662   103.566     0.200
     3.725   105.535     0.200
     5.333   138.676     0.200
     5.400   140.617     0.200
     5.483   143.555     0.200
     5.538   144.477     0.200
     5.635   146.977     0.200
     5.729   147.895     0.200
     5.777   150.176     0.200
     5.881   151.137     0.200
     5.881   152.777     0.200
     5.884   150.789     0.200
     5.935   153.578     0.200
     6.225   159.977     0.200
     6.501   167.012     0.200
     7.037   181.477     0.200
     7.216   182.477     0.200
     1.636    52.055     0.200
     2.516    74.102     0.200
     2.774    80.650     0.200
     2.872    84.535     0.200
     3.258    92.811     0.200
     3.339    93.961     0.200
     3.366    93.516     0.200
     3.553    97.463     0.200
     3.757   106.115     0.200
     3.868   108.818     0.200
     4.097   112.963     0.200
     3.872   110.191     0.200
     4.288   115.359     0.200
     4.503   122.146     0.200
     4.545   121.363     0.200
     4.853   129.246     0.200
     4.949   134.023     0.200
     5.175   136.133     0.200
     5.137   138.186     0.200
     5.272   137.834     0.200
     5.344   138.279     0.200
     5.369   140.434     0.200
     5.445   141.355     0.200
     5.459   140.533     0.200
     5.459   142.734     0.200
     5.570   145.133     0.200
     5.699   148.434     0.200
     5.717   147.377     0.200
     5.814   148.734     0.200
     5.814   152.133     0.200
     5.891   152.734     0.200
     5.900   153.334     0.200
     5.888   152.334     0.200
     6.155   158.934     0.200
     6.417   164.303     0.200
     6.417   165.834     0.200
     6.460   165.889     0.200
     6.655   171.834     0.200
     6.852   177.734     0.200
     6.978   179.734     0.200
     7.162   185.334     0.200
     7.172   184.334     0.200
     7.275   184.863     0.200
     7.458   189.131     0.200
     7.539   193.633     0.200
     7.589   194.434     0.200
     8.147   208.934     0.200
     8.250   205.422     0.200
     8.845   225.434     0.200
     8.973   225.875     0.200
     9.032   229.033     0.200
     9.139   231.834     0.200
     9.461   239.834     0.200
     9.596   242.111     0.200
     9.661   241.924     0.200
    10.939   273.711     0.200
     1.075    38.031     0.200
     1.139    39.055     0.200
     1.354    41.969     0.200
     2.069    61.508     0.200
     2.015    60.070     0.200
     3.418    95.453     0.200
     3.827   106.281     0.200
     3.763   104.555     0.200
     4.480   117.289     0.200
     5.017   129.578     0.200
     5.508   140.469     0.200
     5.579   143.820     0.200
     5.609   143.469     0.200
     5.672   146.656     0.200
     5.699   146.469     0.200
     5.807   147.172     0.200
     5.939   151.469     0.200
     5.927   149.602     0.200
     6.052   155.766     0.200
     6.084   154.609     0.200
     6.121   156.070     0.200
     6.394   162.867     0.200
     6.688   169.289     0.200
     6.852   174.242     0.200
     7.402   188.766     0.200
     1.268    42.234     0.200
     2.423    68.598     0.200
     3.834   103.887     0.200
     4.405   117.586     0.200
     4.497   119.180     0.200
     4.878   126.062     0.200
     4.878   127.996     0.200
     4.941   130.516     0.200
     4.941   127.566     0.200
     5.022   130.562     0.200
     5.018   129.012     0.200
     5.101   132.762     0.200
     5.101   130.703     0.200
     5.183   133.965     0.200
     5.269   136.699     0.200
     5.269   134.695     0.200
     5.435   139.898     0.200
     5.435   140.324     0.200
     5.471   141.164     0.200
     5.471   140.938     0.200
     5.777   148.562     0.200
     6.243   160.562     0.200
     6.753   171.863     0.200
     6.821   171.406     0.200
     7.169   182.562     0.200
     1.311    43.430     0.200
     2.101    62.148     0.200
     2.112    60.496     0.200
     2.793    80.936     0.200
     3.405    95.537     0.200
     3.378    96.551     0.200
     4.489   116.506     0.200
     4.809   125.605     0.200
     4.818   125.805     0.200
     4.846   126.006     0.200
     4.944   127.105     0.200
     5.067   132.205     0.200
     5.070   132.105     0.200
     5.070   129.545     0.200
     5.585   143.506     0.200
     5.747   148.105     0.200
     6.138   157.805     0.200
     6.214   158.006     0.200
     5.383   139.133     0.200
     5.865   151.133     0.200
     5.959   153.434     0.200
     1.202    43.000     0.200
     1.278    44.688     0.200
     1.408    44.543     0.200
     2.696    78.285     0.200
     4.489   116.086     0.200
     5.057   133.602     0.200
     5.057   134.602     0.200
     5.330   138.188     0.200
     5.432   140.391     0.200
     5.505   141.891     0.200
     5.509   141.609     0.200
     5.601   144.488     0.200
     5.601   143.109     0.200
     5.623   144.578     0.200
     5.726   147.289     0.200
     5.726   147.984     0.200
     5.842   149.391     0.200
     5.910   151.703     0.200
     5.968   153.590     0.200
     6.062   156.188     0.200
     6.066   155.891     0.200
     6.066   156.461     0.200
     6.088   157.008     0.200
     6.089   159.434     0.200
     6.307   161.488     0.200
     6.307   161.328     0.200
     6.579   168.188     0.200
     6.579   167.551     0.200
     6.636   169.148     0.200
     6.825   174.590     0.200
     7.140   182.391     0.200
     7.308   186.988     0.200
     7.346   186.188     0.200
     7.474   187.645     0.200
     7.762   195.891     0.200
     7.884   197.781     0.200
     8.143   208.590     0.200
     8.322   210.688     0.200
     9.026   228.188     0.200
     0.804    28.578     0.200
     1.206    38.320     0.200
     2.314    64.273     0.200
     2.651    75.273     0.200
     3.197    88.828     0.200
     3.477    94.336     0.200
     3.625    94.836     0.200
     4.276   111.055     0.200
     4.365   112.750     0.200
     4.365   110.922     0.200
     4.529   116.523     0.200
     4.529   115.562     0.200
     4.918   125.672     0.200
     4.918   125.898     0.200
     4.951   126.500     0.200
     5.175   129.977     0.200
     5.528   140.250     0.200
     6.012   150.562     0.200
     6.543   163.578     0.200
     0.852    28.722     0.200
     2.454    68.262     0.200
     2.566    70.327     0.200
     2.566    70.739     0.200
     4.198   105.769     0.200
     4.415   111.369     0.200
     4.496   113.169     0.200
     4.837   121.369     0.200
     4.915   123.169     0.200
     1.108    38.438     0.200
     1.149    40.539     0.200
     2.262    65.023     0.200
     2.493    69.852     0.200
     2.435    71.086     0.200
     4.321   113.578     0.200
     4.414   113.242     0.200
     4.485   117.445     0.200
     4.535   118.883     0.200
     4.535   117.680     0.200
     4.714   123.281     0.200
     4.959   129.781     0.200
     4.904   126.977     0.200
     5.036   130.781     0.200
     5.036   129.945     0.200
     5.114   131.383     0.200
     5.303   137.680     0.200
     0.549    21.984     0.200
     0.748    26.477     0.200
     1.606    46.766     0.200
     1.982    53.922     0.200
     1.985    54.930     0.200
     3.071    79.727     0.200
     2.953    80.492     0.200
     3.590    97.695     0.200
     3.843   100.219     0.200
     4.378   116.625     0.200
     4.682   119.102     0.200
     4.789   122.867     0.200
     4.804   121.609     0.200
     5.175   131.266     0.200
     5.224   134.062     0.200
     5.396   137.766     0.200
     5.689   141.656     0.200
     5.760   146.164     0.200
     1.373    47.969     0.200
     1.977    61.648     0.200
     2.066    61.844     0.200
     5.579   145.266     0.200
     5.702   148.461     0.200
     5.977   155.062     0.200
     6.039   156.766     0.200
     6.398   165.664     0.200
     6.535   168.961     0.200
     0.749    27.449     0.200
     2.214    63.289     0.200
     2.908    77.492     0.200
     2.908    78.000     0.200
     3.112    82.438     0.200
     3.552    93.035     0.200
     3.900    97.621     0.200
     3.969    99.422     0.200
     4.018   100.926     0.200
     4.065   102.457     0.200
     4.195   107.820     0.200
     4.285   110.320     0.200
     4.311   109.035     0.200
     4.311   111.836     0.200
     4.483   114.820     0.200
     4.535   116.223     0.200
     4.524   116.422     0.200
     4.497   113.852     0.200
     4.497   114.180     0.200
     4.582   120.352     0.200
     4.889   124.922     0.200
     5.085   126.426     0.200
     5.085   127.473     0.200
     5.880   145.902     0.200
     2.679    78.119     0.200
     3.066    82.195     0.200
     3.371    91.357     0.200
     4.642   122.111     0.200
     4.644   122.111     0.200
     4.680   122.111     0.200
     4.790   124.531     0.200
     4.804   123.869     0.200
     4.804   123.234     0.200
     4.808   124.732     0.200
     4.808   124.057     0.200
     5.145   132.432     0.200
     5.173   133.432     0.200
     5.226   135.531     0.200
     5.397   139.131     0.200
     5.397   137.342     0.200
     5.438   142.232     0.200
     5.687   144.832     0.200
     5.761   147.932     0.200
     5.865   150.432     0.200
     5.986   153.232     0.200
     6.407   163.432     0.200
     6.421   162.932     0.200
     3.905   102.863     0.200
     3.981   104.663     0.200
     4.293   112.563     0.200
     4.475   115.863     0.200
     4.558   117.963     0.200
     4.893   127.363     0.200
     5.332   137.063     0.200
     6.204   156.953     0.200
     6.467   162.758     0.200
     6.499   162.453     0.200
     6.697   167.656     0.200
     6.928   172.555     0.200
     7.012   175.055     0.200
     7.645   191.055     0.200
     8.191   201.852     0.200
     0.829    29.466     0.200
     1.191    39.274     0.200
     1.214    38.562     0.200
     4.110   106.888     0.200
     4.216   108.188     0.200
     4.380   112.888     0.200
     4.506   115.388     0.200
     4.622   118.588     0.200
     4.748   121.688     0.200
     4.877   123.388     0.200
     5.085   128.788     0.200
     5.622   142.588     0.200
     6.153   155.388     0.200
     1.063    35.389     0.200
     1.149    37.742     0.200
     1.186    39.650     0.200
     2.611    74.373     0.200
     3.330    88.545     0.200
     4.128   106.299     0.200
     4.232   109.600     0.200
     4.314   112.287     0.200
     4.403   113.998     0.200
     4.524   115.898     0.200
     4.644   117.998     0.200
     4.766   122.600     0.200
     4.821   123.588     0.200
     4.887   124.299     0.200
     4.887   124.875     0.200
     5.104   130.498     0.200
     5.380   138.100     0.200
     5.461   138.467     0.200
     5.941   151.299     0.200
     2.348    66.078     0.200
     2.391    68.797     0.200
     3.064    84.367     0.200
     3.586    98.367     0.200
     5.170   133.688     0.200
     5.253   136.188     0.200
     5.561   142.781     0.200
     5.592   144.836     0.200
     5.832   149.883     0.200
     6.394   164.039     0.200
     1.728    51.742     0.200
     2.897    79.637     0.200
     3.454    93.266     0.200
     3.561    94.723     0.200
     4.036   105.914     0.200
     4.036   108.242     0.200
     4.174   111.477     0.200
     4.281   115.215     0.200
     4.402   117.594     0.200
     4.832   124.824     0.200
     4.892   126.523     0.200
     4.929   126.590     0.200
     4.929   127.531     0.200
     4.928   126.594     0.200
     4.928   127.398     0.200
     5.068   129.238     0.200
     5.068   131.363     0.200
     5.139   133.422     0.200
     5.169   134.039     0.200
     5.194   135.324     0.200
     5.213   134.324     0.200
     5.213   133.590     0.200
     5.401   138.125     0.200
     5.401   136.602     0.200
     5.423   140.625     0.200
     5.464   142.723     0.200
     5.502   141.824     0.200
     5.820   148.223     0.200
     5.903   152.410     0.200
     5.950   151.848     0.200
     5.950   152.398     0.200
     6.009   154.824     0.200
     6.009   153.133     0.200
     6.195   158.824     0.200
     6.195   157.727     0.200
     6.566   167.125     0.200
     6.555   166.570     0.200
     6.678   169.422     0.200
     7.091   179.125     0.200
     8.167   206.691     0.200
     2.375    68.996     0.200
     5.507   139.992     0.200
     5.572   143.992     0.200
     5.796   150.391     0.200
     5.858   149.891     0.200
     5.890   150.594     0.200
     6.085   155.793     0.200
     6.496   166.891     0.200
     7.249   184.191     0.200
     1.068    38.062     0.200
     1.321    44.578     0.200
     2.451    71.648     0.200
     3.813   100.820     0.200
     3.839   101.855     0.200
     3.843   103.578     0.200
     3.914   107.664     0.200
     4.024   104.832     0.200
     4.025   111.391     0.200
     4.181   109.562     0.200
     4.311   113.223     0.200
     4.390   116.723     0.200
     4.749   125.621     0.200
     5.104   132.922     0.200
     5.479   141.523     0.200
     0.749    27.035     0.200
     1.911    54.863     0.200
     2.876    77.465     0.200
     3.121    83.883     0.200
     3.264    86.207     0.200
     3.264    87.102     0.200
     3.789    99.398     0.200
     3.969   103.031     0.200
     4.052   103.730     0.200
     4.052   104.922     0.200
     4.152   109.680     0.200
     4.198   107.254     0.200
     4.223   107.332     0.200
     4.293   110.531     0.200
     4.293   109.703     0.200
     4.359   112.633     0.200
     4.359   112.207     0.200
     4.491   113.320     0.200
     4.491   114.449     0.200
     4.528   116.730     0.200
     4.607   118.832     0.200
     4.607   117.070     0.200
     4.647   118.031     0.200
     4.700   118.801     0.200
     4.700   119.453     0.200
     4.818   127.402     0.200
     4.955   125.934     0.200
     4.955   124.887     0.200
     5.190   130.426     0.200
     5.214   131.922     0.200
     5.513   138.820     0.200
     5.751   146.531     0.200
     5.928   150.832     0.200
     6.079   150.801     0.200
     6.183   160.133     0.200
     6.344   160.230     0.200
     6.454   161.145     0.200
     7.181   177.418     0.200
     7.598   189.531     0.200
     0.934    32.828     0.200
     1.075    36.961     0.200
     1.287    42.891     0.200
     2.220    62.641     0.200
     2.579    74.102     0.200
     2.579    73.727     0.200
     2.814    80.070     0.200
     3.797   101.289     0.200
     4.036   104.523     0.200
     4.059   106.320     0.200
     4.059   105.391     0.200
     4.064   106.023     0.200
     4.363   113.922     0.200
     4.363   113.328     0.200
     4.400   115.125     0.200
     4.535   118.219     0.200
     4.541   118.719     0.200
     4.650   120.320     0.200
     4.864   125.578     0.200
     4.864   125.398     0.200
     5.015   129.820     0.200
     5.080   130.820     0.200
     5.597   142.922     0.200
     5.614   144.719     0.200
     1.604    49.446     0.200
     1.803    55.109     0.200
     1.958    59.211     0.200
     2.341    69.047     0.200
     2.737    77.573     0.200
     2.889    77.953     0.200
     3.025    82.812     0.200
     2.987    83.634     0.200
     2.987    84.305     0.200
     2.967    83.431     0.200
     3.104    83.222     0.200
     3.230    88.143     0.200
     3.344    92.379     0.200
     3.923   107.762     0.200
     4.084   111.815     0.200
     4.480   118.046     0.200
     4.771   122.569     0.200
     4.771   122.282     0.200
     4.792   124.181     0.200
     4.793   124.181     0.200
     4.793   123.382     0.200
     5.093   131.381     0.200
     5.093   130.938     0.200
     5.133   131.881     0.200
     5.256   136.381     0.200
     5.254   135.581     0.200
     5.344   137.781     0.200
     5.383   139.480     0.200
     5.383   137.991     0.200
     5.458   141.681     0.200
     5.588   143.258     0.200
     5.588   144.210     0.200
     5.748   147.881     0.200
     5.748   146.555     0.200
     5.908   151.980     0.200
     6.319   161.781     0.200
     6.348   162.781     0.200
     1.130    39.695     0.200
     1.283    42.359     0.200
     1.728    50.930     0.200
     1.903    57.102     0.200
     2.705    77.492     0.200
     3.595    96.016     0.200
     4.085   106.969     0.200
     4.818   124.234     0.200
     4.882   126.234     0.200
     4.923   128.133     0.200
     5.091   131.312     0.200
     5.172   134.328     0.200
     5.172   132.555     0.200
     5.200   134.031     0.200
     5.404   139.031     0.200
     5.451   140.430     0.200
     5.451   138.602     0.200
     5.806   148.633     0.200
     5.956   152.664     0.200
     6.003   153.734     0.200
     6.195   158.031     0.200
     2.078    60.844     0.200
     2.672    77.117     0.200
     3.699   102.102     0.200
     3.910   103.297     0.200
     3.942   103.711     0.200
     4.043   105.688     0.200
     4.243   110.898     0.200
     4.336   112.492     0.200
     4.579   123.031     0.200
     4.792   125.398     0.200
     4.859   126.492     0.200
     4.871   125.336     0.200
     2.436    69.984     0.200
     2.494    72.633     0.200
     2.769    77.328     0.200
     3.115    85.930     0.200
     3.132    87.453     0.200
     4.029   110.352     0.200
     4.272   114.188     0.200
     4.444   119.273     0.200
     4.444   119.516     0.200
     4.503   120.414     0.200
     4.503   118.094     0.200
     4.618   122.602     0.200
     4.633   122.516     0.200
     4.803   130.266     0.200
     4.883   128.398     0.200
     4.883   127.500     0.200
     5.449   146.547     0.200
     5.495   142.297     0.200
     5.495   141.000     0.200
     5.548   143.227     0.200
     5.549   142.398     0.200
     5.549   142.586     0.200
     5.579   142.234     0.200
     5.624   146.383     0.200
     5.624   144.883     0.200
     5.673   147.055     0.200
     5.673   145.359     0.200
     5.813   150.195     0.200
     5.813   149.086     0.200
     5.866   153.602     0.200
     5.866   149.938     0.200
     5.873   151.695     0.200
     5.873   149.852     0.200
     5.873   154.523     0.200
     6.028   154.398     0.200
     6.094   157.695     0.200
     6.125   158.102     0.200
     6.125   155.891     0.200
     6.154   157.297     0.200
     6.359   163.539     0.200
     6.483   165.898     0.200
     6.483   165.195     0.200
     6.569   166.297     0.200
     6.569   167.648     0.200
     6.624   173.016     0.200
     6.829   174.398     0.200
     6.829   172.695     0.200
     7.052   178.555     0.200
     7.194   183.227     0.200
     7.213   183.898     0.200
     7.299   184.695     0.200
     7.510   192.398     0.200
     7.510   190.438     0.200
     7.710   194.398     0.200
     7.807   198.602     0.200
     8.193   209.102     0.200
     9.599   238.453     0.200
     9.599   238.336     0.200
     9.773   243.711     0.200
     0.453    17.982     0.200
     1.102    33.088     0.200
     1.248    37.682     0.200
     1.380    40.568     0.200
     2.550    69.969     0.200
     2.659    71.594     0.200
     2.659    70.221     0.200
     4.111   103.430     0.200
     4.202   105.229     0.200
     4.272   106.496     0.200
     4.336   109.129     0.200
     4.415   111.430     0.200
     4.504   112.830     0.200
     4.652   116.830     0.200
     4.750   118.330     0.200
     4.821   119.830     0.200
     4.821   119.650     0.200
     5.094   127.430     0.200
     5.582   139.330     0.200
     6.101   150.830     0.200
     1.152    39.156     0.200
     2.856    78.016     0.200
     3.297    94.195     0.200
     3.672    97.414     0.200
     3.736    99.414     0.200
     3.736    98.297     0.200
     3.781    99.555     0.200
     3.781    99.125     0.200
     3.821    99.383     0.200
     3.984   106.211     0.200
     4.035   106.812     0.200
     4.054   107.914     0.200
     4.071   106.766     0.200
     4.071   107.117     0.200
     4.118   114.445     0.200
     4.282   111.609     0.200
     4.282   111.156     0.200
     4.265   111.430     0.200
     4.265   110.953     0.200
     4.305   113.711     0.200
     4.660   121.508     0.200
     4.842   123.977     0.200
     4.842   123.500     0.200
     4.861   126.609     0.200
     4.861   125.906     0.200
     5.064   130.914     0.200
     5.562   143.414     0.200
     5.978   153.414     0.200
     1.142    40.461     0.200
     2.862    83.133     0.200
     3.076    83.109     0.200
     3.076    83.688     0.200
     3.226    87.516     0.200
     3.300    90.867     0.200
     4.378   115.820     0.200
     4.409   116.805     0.200
     4.409   117.312     0.200
     4.501   118.055     0.200
     4.664   122.180     0.200
     4.679   120.984     0.200
     4.682   120.680     0.200
     4.997   129.984     0.200
     5.022   129.984     0.200
     5.133   132.680     0.200
     5.137   133.281     0.200
     5.273   135.586     0.200
     5.341   138.086     0.200
     5.498   141.055     0.200
     1.535    48.500     0.200
     1.969    59.100     0.200
     2.552    74.537     0.200
     3.067    88.492     0.200
     3.184    91.113     0.200
     3.480    99.445     0.200
     3.654   101.611     0.200
     4.731   129.162     0.200
     5.402   140.715     0.200
     5.459   140.410     0.200
     5.512   144.854     0.200
     5.559   146.113     0.200
     5.637   146.113     0.200
     5.714   147.918     0.200
     5.873   152.113     0.200
     5.958   154.414     0.200
     5.973   154.715     0.200
     6.538   169.314     0.200
     6.533   166.770     0.200
     6.753   173.514     0.200
     7.098   182.014     0.200
     7.229   183.008     0.200
     7.254   184.814     0.200
     7.722   194.951     0.200
     1.148    43.043     0.200
     1.391    47.055     0.200
     1.391    47.852     0.200
     1.429    47.832     0.200
     1.726    53.941     0.200
     1.863    57.594     0.200
     2.305    69.332     0.200
     2.670    77.992     0.200
     3.586   100.426     0.200
     4.482   118.102     0.200
     5.061   133.078     0.200
     5.169   135.477     0.200
     5.169   134.414     0.200
     5.252   136.852     0.200
     5.252   135.566     0.200
     5.320   140.176     0.200
     5.320   137.809     0.200
     5.458   143.277     0.200
     5.562   146.578     0.200
     5.699   148.977     0.200
     5.713   147.359     0.200
     5.713   146.383     0.200
     5.823   150.477     0.200
     5.823   149.965     0.200
     5.916   152.203     0.200
     6.396   164.797     0.200
     6.573   169.277     0.200
     7.101   182.379     0.200
     7.298   185.715     0.200
     1.056    37.432     0.200
     1.084    39.006     0.200
     1.304    43.501     0.200
     1.770    53.165     0.200
     2.438    71.139     0.200
     2.433    71.556     0.200
     3.212    88.809     0.200
     3.273    90.951     0.200
     3.439    96.659     0.200
     3.559    96.333     0.200
     3.780    99.890     0.200
     3.780   100.124     0.200
     3.830   101.490     0.200
     3.830   101.368     0.200
     3.861   101.964     0.200
     3.861   100.897     0.200
     3.856   103.018     0.200
     3.898   107.504     0.200
     4.040   105.540     0.200
     4.040   107.048     0.200
     4.129   110.790     0.200
     4.155   110.090     0.200
     4.168   111.190     0.200
     4.282   117.359     0.200
     4.196   109.856     0.200
     4.196   109.734     0.200
     4.328   112.290     0.200
     4.328   112.181     0.200
     4.392   115.690     0.200
     4.407   116.790     0.200
     4.435   116.790     0.200
     4.879   125.406     0.200
     4.940   127.990     0.200
     5.122   134.090     0.200
     5.496   143.490     0.200
     5.605   145.590     0.200
     5.582   143.316     0.200
     6.045   156.301     0.200
     6.571   168.590     0.200
     1.660    51.608     0.200
     1.942    57.077     0.200
     2.676    75.031     0.200
     3.306    93.036     0.200
     3.306    94.302     0.200
     3.693    98.515     0.200
     3.757   100.215     0.200
     3.801   100.992     0.200
     4.057   109.115     0.200
     4.086   107.641     0.200
     4.076   108.015     0.200
     3.862   109.738     0.200
     4.278   113.694     0.200
     4.301   113.715     0.200
     4.326   114.815     0.200
     4.326   113.605     0.200
     4.113   113.229     0.200
     4.212   118.014     0.200
     4.861   126.305     0.200
     5.084   133.415     0.200
     5.582   144.115     0.200
     0.995    36.318     0.200
     1.282    43.555     0.200
     1.986    59.122     0.200
     2.811    80.730     0.200
     3.033    86.708     0.200
     3.070    86.553     0.200
     3.613   102.498     0.200
     3.749   103.628     0.200
     3.847   107.521     0.200
     4.215   111.333     0.200
     4.513   117.373     0.200
     4.527   118.433     0.200
     5.302   135.433     0.200
     5.808   147.893     0.200
     6.225   157.593     0.200
     1.511    42.680     0.200
     2.421    68.617     0.200
     2.430    64.758     0.200
     2.527    69.094     0.200
     3.221    83.977     0.200
     3.327    88.703     0.200
     4.207   105.680     0.200
     4.311   108.500     0.200
     4.253   108.938     0.200
     4.392   109.508     0.200
     4.392   109.359     0.200
     4.532   112.727     0.200
     4.603   115.164     0.200
     4.723   118.484     0.200
     4.845   119.148     0.200
     4.845   120.898     0.200
     4.889   122.242     0.200
     4.964   123.320     0.200
     4.964   122.375     0.200
     5.127   127.672     0.200
     5.152   129.195     0.200
     5.459   135.469     0.200
     5.537   136.398     0.200
     5.537   137.891     0.200
     5.954   146.641     0.200
     6.240   154.180     0.200
     6.500   160.477     0.200
     6.706   164.562     0.200
     4.128   105.238     0.200
     4.228   106.320     0.200
     4.305   109.199     0.200
     4.305   107.480     0.200
     4.326   109.008     0.200
     4.326   108.805     0.200
     4.437   111.051     0.200
     4.412   110.727     0.200
     4.412   111.578     0.200
     4.523   114.277     0.200
     4.652   118.816     0.200
     4.766   119.379     0.200
     4.766   120.117     0.200
     4.784   119.531     0.200
     4.871   122.246     0.200
     5.019   126.965     0.200
     5.019   126.223     0.200
     5.444   135.605     0.200
     5.444   136.039     0.200
     5.624   141.227     0.200
     5.624   140.648     0.200
     5.845   146.008     0.200
     5.936   149.168     0.200
     6.149   153.426     0.200
     6.393   158.352     0.200
     6.566   164.738     0.200
     1.046    33.883     0.200
     2.482    66.453     0.200
     2.585    72.688     0.200
     2.770    77.352     0.200
     3.264    88.188     0.200
     3.223    86.344     0.200
     3.602    97.672     0.200
     4.150   106.516     0.200
     4.253   108.328     0.200
     4.253   107.062     0.200
     4.209   108.680     0.200
     4.336   110.641     0.200
     4.336   109.445     0.200
     4.334   109.898     0.200
     4.426   112.523     0.200
     4.545   115.391     0.200
     4.545   115.555     0.200
     4.667   118.391     0.200
     4.788   119.945     0.200
     4.788   121.445     0.200
     4.833   122.633     0.200
     4.884   123.883     0.200
     4.905   123.148     0.200
     4.905   122.023     0.200
     5.074   127.688     0.200
     5.401   136.383     0.200
     5.479   136.180     0.200
     5.962   149.250     0.200
     6.182   154.523     0.200
     6.599   165.453     0.200
     1.651    51.918     0.200
     1.828    55.781     0.200
     2.018    60.488     0.200
     2.492    73.461     0.200
     2.492    73.340     0.200
     2.762    80.789     0.200
     2.683    77.539     0.200
     4.925   128.074     0.200
     5.046   129.707     0.200
     5.080   132.195     0.200
     5.195   135.914     0.200
     5.266   134.664     0.200
     5.266   135.621     0.200
     5.311   137.473     0.200
     5.391   140.723     0.200
     5.496   143.754     0.200
     5.545   142.094     0.200
     5.561   143.863     0.200
     6.102   155.988     0.200
     6.330   163.062     0.200
     6.686   171.473     0.200
     6.825   175.125     0.200
     7.240   183.574     0.200
     1.988    58.924     0.200
     2.380    68.967     0.200
     2.511    70.854     0.200
     2.401    70.736     0.200
     2.486    68.498     0.200
     2.486    68.793     0.200
     2.576    73.211     0.200
     2.755    79.342     0.200
     3.216    88.266     0.200
     3.295    89.371     0.200
     3.274    88.514     0.200
     3.362    93.486     0.200
     4.160   107.896     0.200
     4.199   109.889     0.200
     4.199   110.279     0.200
     4.341   111.871     0.200
     4.341   112.574     0.200
     4.350   111.916     0.200
     4.439   114.477     0.200
     4.479   117.133     0.200
     4.555   117.236     0.200
     4.555   117.098     0.200
     4.679   121.176     0.200
     4.798   123.457     0.200
     4.833   122.871     0.200
     4.833   124.535     0.200
     4.892   125.287     0.200
     4.911   125.207     0.200
     5.071   129.699     0.200
     5.071   130.209     0.200
     5.096   134.004     0.200
     5.225   136.104     0.200
     5.410   137.766     0.200
     5.485   139.400     0.200
     5.485   139.152     0.200
     5.898   151.158     0.200
     5.971   152.256     0.200
     6.188   156.277     0.200
     6.444   162.477     0.200
     6.605   166.227     0.200
     6.974   175.576     0.200
     7.165   178.797     0.200
     7.543   188.344     0.200
     7.882   196.846     0.200
     8.156   203.537     0.200
     8.253   207.262     0.200
     0.294    15.047     0.200
     1.334    39.070     0.200
     1.409    42.305     0.200
     1.534    42.023     0.200
     1.960    56.430     0.200
     2.366    65.484     0.200
     2.552    70.719     0.200
     2.445    65.883     0.200
     2.445    64.266     0.200
     2.759    73.125     0.200
     2.806    77.820     0.200
     3.270    86.695     0.200
     3.195    83.414     0.200
     3.344    87.867     0.200
     3.413    93.086     0.200
     3.626    92.047     0.200
     3.626    94.578     0.200
     3.633    98.094     0.200
     3.841    98.250     0.200
     4.175   104.781     0.200
     4.246   107.211     0.200
     4.246   107.852     0.200
     4.265   108.445     0.200
     4.265   111.797     0.200
     4.357   109.445     0.200
     4.357   110.102     0.200
     4.361   109.195     0.200
     4.361   109.766     0.200
     4.448   111.023     0.200
     4.448   111.953     0.200
     4.505   111.906     0.200
     4.505   112.219     0.200
     4.571   114.680     0.200
     4.571   114.484     0.200
     4.611   117.070     0.200
     4.618   117.555     0.200
     4.689   118.734     0.200
     4.813   119.430     0.200
     4.813   120.234     0.200
     4.868   121.344     0.200
     4.868   121.000     0.200
     4.910   122.898     0.200
     4.936   122.031     0.200
     4.936   122.367     0.200
     5.110   126.406     0.200
     5.110   127.039     0.200
     5.141   131.242     0.200
     5.272   134.188     0.200
     5.428   135.211     0.200
     5.510   137.211     0.200
     5.510   136.531     0.200
     5.683   141.625     0.200
     5.683   141.398     0.200
     5.940   147.305     0.200
     5.989   149.562     0.200
     6.153   153.195     0.200
     6.212   153.148     0.200
     6.483   160.727     0.200
     6.629   162.953     0.200
     6.690   164.727     0.200
     6.691   164.531     0.200
     6.796   168.109     0.200
     6.993   173.664     0.200
     7.542   185.852     0.200
     7.580   185.578     0.200
     7.909   195.250     0.200
     8.074   199.484     0.200
     8.179   200.562     0.200
     8.296   204.391     0.200
     8.821   216.719     0.200
     1.828    53.048     0.200
     2.099    61.604     0.200
     3.064    82.844     0.200
     3.875   108.510     0.200
     4.177   107.507     0.200
     4.231   110.457     0.200
     4.219   108.884     0.200
     4.243   108.846     0.200
     4.241   108.823     0.200
     4.636   117.863     0.200
     4.632   120.084     0.200
     4.650   120.613     0.200
     4.829   124.974     0.200
     4.863   124.714     0.200
     4.942   128.083     0.200
     5.161   131.051     0.200
     5.446   138.244     0.200
     5.894   150.104     0.200
     2.395    68.008     0.200
     2.909    83.211     0.200
     3.145    85.125     0.200
     3.212    89.375     0.200
     3.656    96.188     0.200
     3.756   104.711     0.200
     4.151   108.672     0.200
     4.261   110.891     0.200
     4.311   112.922     0.200
     4.350   113.508     0.200
     4.350   112.086     0.200
     4.326   111.703     0.200
     4.334   114.453     0.200
     4.408   114.570     0.200
     4.513   115.719     0.200
     4.547   117.812     0.200
     4.650   120.281     0.200
     4.787   124.305     0.200
     4.903   125.445     0.200
     4.903   123.305     0.200
     4.936   126.203     0.200
     4.936   127.500     0.200
     5.161   131.930     0.200
     5.161   131.336     0.200
     5.512   140.742     0.200
     5.512   138.477     0.200
     5.675   144.828     0.200
     5.919   145.250     0.200
     5.971   152.242     0.200
     5.998   151.031     0.200
     6.209   156.961     0.200
     6.477   163.914     0.200
     6.528   163.305     0.200
     6.740   167.484     0.200
     6.741   168.039     0.200
     6.815   170.164     0.200
     2.863    80.574     0.200
     3.896   100.562     0.200
     4.032   104.637     0.200
     4.105   106.613     0.200
     4.165   109.445     0.200
     4.230   112.184     0.200
     4.285   112.773     0.200
     4.387   113.117     0.200
     4.557   118.414     0.200
     4.592   117.398     0.200
     5.404   137.117     0.200
     2.279    67.820     0.200
     2.461    71.562     0.200
     2.554    75.500     0.200
     2.985    83.359     0.200
     2.998    85.711     0.200
     3.213    86.078     0.200
     3.260    91.453     0.200
     3.663   103.305     0.200
     4.574   121.766     0.200
     4.956   127.422     0.200
     5.039   129.977     0.200
     5.159   133.633     0.200
     5.197   134.836     0.200
     5.273   134.398     0.200
     5.273   135.719     0.200
     5.384   137.688     0.200
     5.346   137.969     0.200
     5.532   143.305     0.200
     5.509   141.695     0.200
     5.594   143.492     0.200
     5.617   143.805     0.200
     6.179   157.672     0.200
     6.297   161.102     0.200
     6.394   163.039     0.200
     6.497   170.766     0.200
     6.736   171.953     0.200
     6.919   174.219     0.200
     6.898   174.562     0.200
     6.959   177.023     0.200
     7.096   179.234     0.200
     7.223   182.562     0.200
     7.314   184.062     0.200
     7.870   198.352     0.200
     8.239   206.195     0.200
     8.551   215.078     0.200
     8.591   214.492     0.200
     8.862   221.938     0.200
     9.293   231.227     0.200
     1.116    39.805     0.200
     1.905    59.352     0.200
     2.281    68.234     0.200
     2.457    72.500     0.200
     2.569    76.023     0.200
     2.854    84.500     0.200
     2.989    84.984     0.200
     3.258    92.398     0.200
     3.301    95.734     0.200
     3.368    97.117     0.200
     3.680   104.594     0.200
     4.170   112.312     0.200
     4.435   120.109     0.200
     4.456   119.383     0.200
     4.563   122.305     0.200
     4.936   129.086     0.200
     5.018   130.547     0.200
     5.077   131.266     0.200
     5.141   135.047     0.200
     5.175   135.562     0.200
     5.251   136.328     0.200
     5.251   136.539     0.200
     5.326   138.914     0.200
     5.369   138.828     0.200
     5.405   143.273     0.200
     5.488   142.578     0.200
     5.488   147.062     0.200
     5.518   142.641     0.200
     5.573   143.609     0.200
     5.573   144.055     0.200
     5.598   144.234     0.200
     5.642   146.273     0.200
     6.156   157.859     0.200
     6.161   158.031     0.200
     6.285   162.141     0.200
     6.375   163.766     0.200
     6.716   172.336     0.200
     6.880   175.453     0.200
     6.906   174.867     0.200
     6.938   178.328     0.200
     7.083   180.898     0.200
     7.083   179.742     0.200
     7.084   181.039     0.200
     7.203   183.336     0.200
     7.289   187.359     0.200
     7.295   185.008     0.200
     7.365   186.391     0.200
     7.852   197.812     0.200
     8.012   201.375     0.200
     8.263   208.281     0.200
     8.379   211.664     0.200
     8.533   217.359     0.200
     8.581   218.562     0.200
     8.843   223.297     0.200
     9.276   233.547     0.200
     9.368   234.586     0.200
     1.184    38.455     0.200
     2.018    57.920     0.200
     2.242    62.316     0.200
     2.657    74.826     0.200
     2.838    79.863     0.200
     2.910    80.721     0.200
     2.986    81.854     0.200
     3.671    94.896     0.200
     3.916    99.867     0.200
     3.993   103.537     0.200
     4.048   103.219     0.200
     4.048   102.908     0.200
     4.117   104.793     0.200
     4.117   106.814     0.200
     4.188   107.844     0.200
     4.188   107.477     0.200
     4.252   107.717     0.200
     4.252   110.598     0.200
     4.304   110.713     0.200
     4.304   111.207     0.200
     4.392   112.559     0.200
     4.392   113.260     0.200
     4.485   116.668     0.200
     4.571   116.646     0.200
     4.571   116.057     0.200
     4.592   116.859     0.200
     4.592   118.340     0.200
     5.135   129.920     0.200
     5.135   130.842     0.200
     5.345   133.717     0.200
     5.401   135.529     0.200
     5.688   143.428     0.200
     5.852   146.236     0.200
     6.174   154.947     0.200
     6.268   157.316     0.200
     1.211    42.301     0.200
     2.271    67.805     0.200
     2.456    72.344     0.200
     2.539    74.984     0.200
     3.255    90.805     0.200
     3.655   101.652     0.200
     4.972   129.242     0.200
     5.054   130.703     0.200
     5.095   136.824     0.200
     5.113   131.473     0.200
     5.175   134.551     0.200
     5.212   136.133     0.200
     5.289   136.184     0.200
     5.289   137.094     0.200
     5.362   138.793     0.200
     5.399   138.293     0.200
     5.525   143.570     0.200
     5.546   143.242     0.200
     5.610   143.453     0.200
     5.610   145.070     0.200
     5.633   145.070     0.200
     6.195   157.949     0.200
     6.310   163.168     0.200
     6.410   164.223     0.200
     6.752   172.512     0.200
     6.914   176.301     0.200
     7.397   186.301     0.200
     0.578    21.562     0.200
     2.619    72.961     0.200
     3.397    86.750     0.200
     3.397    87.188     0.200
     3.455    88.406     0.200
     3.495    89.203     0.200
     3.495    88.422     0.200
     3.528    88.336     0.200
     3.569    94.156     0.200
     3.776    95.656     0.200
     3.776    96.180     0.200
     3.785    95.227     0.200
     3.990   100.906     0.200
     3.999   102.883     0.200
     3.994   100.312     0.200
     4.028   103.523     0.200
     4.549   113.086     0.200
     4.814   120.070     0.200
     0.552    21.297     0.200
     0.979    30.891     0.200
     2.139    59.184     0.200
     2.652    74.195     0.200
     3.390    86.199     0.200
     3.390    86.656     0.200
     3.446    88.125     0.200
     3.483    89.898     0.200
     3.508    92.637     0.200
     3.564    96.137     0.200
     3.535    96.824     0.200
     3.755    95.395     0.200
     3.755    97.461     0.200
     3.972   100.016     0.200
     3.959   100.422     0.200
     3.959   101.445     0.200
     4.020   102.125     0.200
     4.196   113.148     0.200
     4.380   116.145     0.200
     4.529   113.977     0.200
     4.529   114.980     0.200
     4.777   121.094     0.200
     5.121   129.426     0.200
     5.339   133.824     0.200
     1.178    40.215     0.200
     2.594    76.203     0.200
     2.645    77.467     0.200
     2.778    79.650     0.200
     2.776    80.873     0.200
     2.862    81.199     0.200
     2.864    81.975     0.200
     3.105    86.252     0.200
     3.404    91.730     0.200
     3.445    93.252     0.200
     4.259   114.906     0.200
     4.445   119.230     0.200
     4.445   115.959     0.200
     4.474   117.934     0.200
     4.612   124.752     0.200
     4.921   128.678     0.200
     5.232   136.500     0.200
     5.248   137.113     0.200
     5.393   142.293     0.200
     5.512   142.643     0.200
     5.512   140.186     0.200
     5.529   142.814     0.200
     5.529   143.789     0.200
     5.526   143.584     0.200
     5.526   142.293     0.200
     5.537   144.297     0.200
     5.537   143.873     0.200
     5.569   142.389     0.200
     5.585   143.840     0.200
     5.603   144.717     0.200
     5.884   150.688     0.200
     5.884   152.248     0.200
     5.899   151.092     0.200
     5.899   152.369     0.200
     5.925   152.008     0.200
     6.000   155.127     0.200
     6.000   154.598     0.200
     6.148   157.658     0.200
     6.151   159.219     0.200
     6.162   159.578     0.200
     6.192   161.252     0.200
     6.383   169.705     0.200
     6.528   165.135     0.200
     6.528   165.531     0.200
     6.658   169.070     0.200
     6.658   169.818     0.200
     6.783   174.898     0.200
     6.807   172.924     0.200
     6.807   173.389     0.200
     6.906   176.527     0.200
     7.037   180.740     0.200
     7.037   179.424     0.200
     7.038   181.793     0.200
     7.209   183.158     0.200
     7.286   188.139     0.200
     7.542   192.156     0.200
     7.542   192.559     0.200
     7.575   191.229     0.200
     7.659   193.789     0.200
     7.668   192.158     0.200
     7.812   197.559     0.200
     7.815   198.646     0.200
     8.209   206.908     0.200
     8.599   216.379     0.200
     8.816   221.449     0.200
     9.077   227.068     0.200
     9.189   228.629     0.200
     9.382   234.328     0.200
     9.514   239.900     0.200
     9.514   236.041     0.200
     9.565   237.818     0.200
     9.596   238.146     0.200
     9.721   241.307     0.200
    10.212   254.289     0.200
    10.606   261.814     0.200
    10.697   267.969     0.200
    10.711   267.988     0.200
    10.799   266.855     0.200
    10.945   277.168     0.200
    10.972   272.727     0.200
     1.122    39.863     0.200
     2.547    75.242     0.200
     2.784    79.539     0.200
     3.106    88.133     0.200
     3.419    95.969     0.200
     4.248   110.750     0.200
     4.432   118.348     0.200
     5.516   142.707     0.200
     5.500   141.105     0.200
     5.556   142.086     0.200
     5.525   142.906     0.200
     5.872   152.957     0.200
     5.886   152.297     0.200
     5.912   153.848     0.200
     5.987   153.617     0.200
     6.135   157.859     0.200
     6.138   156.277     0.200
     6.138   158.566     0.200
     6.149   158.938     0.200
     6.180   157.711     0.200
     6.515   163.652     0.200
     6.645   169.547     0.200
     6.770   172.887     0.200
     6.795   173.227     0.200
     7.196   183.609     0.200
     7.563   190.215     0.200
     7.646   193.148     0.200
     7.655   192.777     0.200
     8.803   222.168     0.200
     1.114    41.020     0.200
     2.646    77.105     0.200
     2.563    74.453     0.200
     2.754    78.559     0.200
     2.858    81.578     0.200
     3.404    97.824     0.200
     4.248   116.020     0.200
     4.426   118.738     0.200
     4.462   120.398     0.200
     4.633   125.988     0.200
     5.239   140.340     0.200
     5.493   141.203     0.200
     5.493   142.605     0.200
     5.506   142.020     0.200
     5.506   142.668     0.200
     5.510   142.402     0.200
     5.523   143.871     0.200
     5.523   145.625     0.200
     5.547   141.988     0.200
     5.563   141.176     0.200
     5.563   145.477     0.200
     5.861   150.258     0.200
     5.861   152.898     0.200
     5.877   150.547     0.200
     5.877   152.906     0.200
     5.902   153.867     0.200
     5.980   151.984     0.200
     5.980   154.109     0.200
     6.125   158.559     0.200
     6.129   155.609     0.200
     6.129   158.848     0.200
     6.141   158.418     0.200
     6.180   161.488     0.200
     6.509   165.820     0.200
     6.509   167.078     0.200
     6.637   168.340     0.200
     6.637   168.938     0.200
     6.761   174.289     0.200
     6.787   172.434     0.200
     6.787   173.289     0.200
     7.188   183.539     0.200
     7.559   193.363     0.200
     7.639   193.758     0.200
     7.649   192.418     0.200
     7.791   198.156     0.200
     8.798   220.438     0.200
     9.059   226.328     0.200
     9.497   239.586     0.200
     3.464    96.020     0.200
     4.032   110.156     0.200
     4.354   115.707     0.200
     4.502   118.289     0.200
     4.502   118.684     0.200
     4.562   122.652     0.200
     4.708   126.570     0.200
     4.747   127.508     0.200
     5.327   142.684     0.200
     5.347   144.094     0.200
     5.555   143.012     0.200
     5.555   144.219     0.200
     5.562   143.047     0.200
     5.562   143.719     0.200
     5.526   146.758     0.200
     5.600   142.180     0.200
     5.504   148.793     0.200
     5.621   144.516     0.200
     5.621   143.312     0.200
     5.596   144.188     0.200
     5.596   146.184     0.200
     5.537   148.352     0.200
     5.619   147.480     0.200
     5.619   146.145     0.200
     5.719   146.195     0.200
     5.897   153.391     0.200
     5.897   152.508     0.200
     5.928   152.367     0.200
     5.928   151.348     0.200
     5.942   150.621     0.200
     5.942   151.961     0.200
     5.856   153.660     0.200
     6.047   155.070     0.200
     6.047   154.488     0.200
     6.167   157.699     0.200
     6.180   156.980     0.200
     6.180   156.059     0.200
     6.197   158.801     0.200
     6.189   162.730     0.200
     6.282   164.152     0.200
     6.493   170.887     0.200
     6.580   167.730     0.200
     6.580   167.184     0.200
     6.696   170.023     0.200
     6.696   170.191     0.200
     6.817   173.031     0.200
     6.853   173.594     0.200
     6.853   173.469     0.200
     6.838   180.332     0.200
     6.980   182.234     0.200
     7.125   182.543     0.200
     7.194   188.613     0.200
     7.313   189.941     0.200
     7.569   192.863     0.200
     7.643   190.777     0.200
     7.703   193.609     0.200
     7.721   194.219     0.200
     7.849   197.758     0.200
     8.223   207.270     0.200
     8.264   207.461     0.200
     8.327   215.355     0.200
     8.396   217.113     0.200
     8.652   218.270     0.200
     8.625   213.695     0.200
     8.878   223.281     0.200
     9.134   227.051     0.200
     9.246   229.648     0.200
     9.187   235.945     0.200
     9.227   236.805     0.200
     9.448   236.301     0.200
     9.580   241.242     0.200
     9.580   236.816     0.200
     9.620   240.070     0.200
     9.777   242.922     0.200
    10.630   267.391     0.200
    10.998   273.320     0.200
     2.120    63.680     0.200
     4.224   114.414     0.200
     4.415   116.926     0.200
     5.484   141.281     0.200
     5.495   142.119     0.200
     5.495   143.260     0.200
     5.505   142.268     0.200
     5.505   143.781     0.200
     5.544   142.430     0.200
     5.559   144.359     0.200
     5.559   144.990     0.200
     5.863   153.350     0.200
     5.874   150.658     0.200
     5.874   152.510     0.200
     5.971   153.553     0.200
     5.971   154.131     0.200
     6.125   158.820     0.200
     6.126   157.830     0.200
     6.499   166.777     0.200
     6.499   166.627     0.200
     6.632   170.080     0.200
     6.779   172.303     0.200
     6.779   173.500     0.200
     7.632   194.100     0.200
     8.785   222.221     0.200
     1.089    39.067     0.200
     1.089    39.206     0.200
     2.215    64.810     0.200
     2.564    75.661     0.200
     3.074    88.117     0.200
     3.388    96.399     0.200
     5.526   141.917     0.200
     5.526   144.138     0.200
     5.567   142.548     0.200
     5.584   143.720     0.200
     5.897   152.698     0.200
     5.920   153.528     0.200
     6.002   153.717     0.200
     6.002   154.408     0.200
     6.149   158.528     0.200
     6.782   174.598     0.200
     6.809   174.828     0.200
     7.209   184.638     0.200
     7.661   194.698     0.200
     7.672   195.228     0.200
     1.088    38.605     0.200
     2.571    75.213     0.200
     2.752    79.969     0.200
     4.273   112.268     0.200
     5.264   138.832     0.200
     5.510   140.766     0.200
     5.510   141.961     0.200
     5.520   142.146     0.200
     5.520   143.393     0.200
     5.531   139.918     0.200
     5.546   143.402     0.200
     5.546   143.750     0.200
     5.561   143.342     0.200
     5.578   144.521     0.200
     5.578   142.408     0.200
     5.871   149.848     0.200
     5.891   150.104     0.200
     5.891   151.932     0.200
     5.913   153.223     0.200
     5.997   152.867     0.200
     5.997   153.723     0.200
     6.137   158.502     0.200
     6.143   158.312     0.200
     6.156   158.871     0.200
     6.527   166.004     0.200
     6.653   170.062     0.200
     6.653   170.172     0.200
     6.776   174.133     0.200
     6.804   174.092     0.200
     7.260   182.762     0.200
     7.656   193.422     0.200
     7.667   194.191     0.200
     7.806   198.611     0.200
     8.209   208.553     0.200
     8.818   220.701     0.200
     1.035    35.246     0.200
     1.104    36.820     0.200
     1.168    37.941     0.200
     1.252    41.242     0.200
     1.831    51.852     0.200
     1.831    52.242     0.200
     2.252    65.723     0.200
     2.170    62.301     0.200
     2.748    73.500     0.200
     2.748    75.121     0.200
     2.724    76.074     0.200
     3.149    83.445     0.200
     2.993    82.680     0.200
     3.264    89.230     0.200
     3.309    87.512     0.200
     3.309    87.004     0.200
     3.212    88.855     0.200
     3.573    95.879     0.200
     3.649    96.543     0.200
     3.651    96.656     0.200
     3.779    98.770     0.200
     3.779    98.910     0.200
     4.266   112.973     0.200
     4.280   115.555     0.200
     4.670   119.473     0.200
     4.702   120.789     0.200
     4.743   123.277     0.200
     4.743   121.582     0.200
     4.882   124.824     0.200
     4.882   124.051     0.200
     5.066   128.008     0.200
     5.066   128.895     0.200
     5.089   130.516     0.200
     5.091   129.270     0.200
     5.091   129.887     0.200
     5.381   136.676     0.200
     5.381   137.266     0.200
     5.430   138.262     0.200
     5.430   139.488     0.200
     5.554   141.426     0.200
     5.551   141.426     0.200
     5.551   141.559     0.200
     5.639   144.008     0.200
     5.756   146.066     0.200
     5.871   149.117     0.200
     6.011   153.414     0.200
     6.196   157.676     0.200
     6.196   156.637     0.200
     6.264   158.656     0.200
     6.601   166.445     0.200
     6.639   166.836     0.200
     6.791   172.914     0.200
     6.996   173.848     0.200
     7.052   176.598     0.200
     7.066   178.418     0.200
     7.259   183.148     0.200
     7.518   191.535     0.200
     7.572   188.578     0.200
     7.920   198.406     0.200
     8.066   201.566     0.200
     8.480   211.297     0.200
     9.166   229.238     0.200
     1.118    39.486     0.200
     1.485    47.090     0.200
     2.241    65.459     0.200
     3.818   103.445     0.200
     3.818   103.973     0.200
     3.822   103.600     0.200
     3.822   103.205     0.200
     3.901   102.814     0.200
     3.901   104.867     0.200
     4.100   107.936     0.200
     4.106   106.900     0.200
     4.106   108.705     0.200
     4.398   115.145     0.200
     4.398   116.156     0.200
     4.442   116.703     0.200
     4.442   116.875     0.200
     4.648   122.186     0.200
     4.691   123.166     0.200
     4.897   126.850     0.200
     4.897   127.771     0.200
     5.273   137.676     0.200
     5.630   145.715     0.200
     5.651   147.076     0.200
     6.028   155.006     0.200
     6.069   156.576     0.200
     1.203    40.789     0.200
     2.078    61.137     0.200
     2.148    63.043     0.200
     2.954    84.266     0.200
     3.530    94.102     0.200
     3.636    95.422     0.200
     3.636    95.879     0.200
     3.400    94.398     0.200
     4.309   112.113     0.200
     1.111    38.337     0.200
     1.946    57.927     0.200
     2.026    59.165     0.200
     4.234   116.607     0.200
     1.069    39.938     0.200
     1.019    39.608     0.200
     1.427    48.430     0.200
     2.254    66.900     0.200
     2.935    82.453     0.200
     2.955    82.983     0.200
     3.449    93.953     0.200
     3.549    95.424     0.200
     3.781   102.191     0.200
     3.844   103.653     0.200
     4.087   109.884     0.200
     4.206   111.421     0.200
     4.206   112.413     0.200
     4.186   111.198     0.200
     4.186   110.996     0.200
     4.469   120.085     0.200
     4.469   117.986     0.200
     4.697   123.214     0.200
     4.765   125.363     0.200
     4.782   126.526     0.200
     4.782   124.577     0.200
     5.325   138.354     0.200
     5.481   144.014     0.200
     5.714   146.650     0.200
     1.475    49.672     0.200
     1.846    58.273     0.200
     2.255    68.133     0.200
     2.329    71.031     0.200
     2.998    83.086     0.200
     5.002   131.180     0.200
     5.085   133.680     0.200
     5.663   146.953     0.200
     1.147    40.883     0.200
     1.147    40.453     0.200
     1.279    43.188     0.200
     1.568    48.688     0.200
     1.667    51.617     0.200
     1.814    54.523     0.200
     2.176    64.781     0.200
     2.626    74.500     0.200
     2.626    75.438     0.200
     2.657    76.555     0.200
     2.840    80.344     0.200
     3.500    98.445     0.200
     3.933   105.055     0.200
     4.137   109.469     0.200
     4.137   109.789     0.200
     4.169   110.414     0.200
     4.795   124.039     0.200
     4.864   126.508     0.200
     4.933   127.711     0.200
     5.078   132.391     0.200
     5.111   130.688     0.200
     5.111   131.492     0.200
     5.141   132.812     0.200
     5.180   132.672     0.200
     5.180   134.125     0.200
     5.166   134.430     0.200
     5.234   134.906     0.200
     5.373   138.172     0.200
     5.401   139.016     0.200
     5.401   139.648     0.200
     5.430   140.609     0.200
     5.479   142.031     0.200
     5.955   152.203     0.200
     5.989   153.633     0.200
     5.984   153.172     0.200
     6.088   156.953     0.200
     6.188   158.031     0.200
     6.188   158.469     0.200
     6.548   167.703     0.200
     6.622   167.602     0.200
     6.668   168.672     0.200
     6.680   170.781     0.200
     7.026   178.273     0.200
     7.095   179.773     0.200
     7.124   179.773     0.200
     1.117    39.586     0.200
     2.188    64.305     0.200
     2.575    73.734     0.200
     2.564    73.930     0.200
     2.644    77.547     0.200
     2.781    80.898     0.200
     3.178    91.109     0.200
     3.935   109.000     0.200
     4.113   110.211     0.200
     4.147   112.547     0.200
     4.154   116.039     0.200
     4.423   117.773     0.200
     4.557   123.641     0.200
     4.898   129.234     0.200
     5.417   146.625     0.200
     5.490   141.742     0.200
     5.490   141.414     0.200
     5.504   141.469     0.200
     5.504   141.805     0.200
     5.507   142.477     0.200
     5.520   144.406     0.200
     5.544   142.203     0.200
     5.561   143.367     0.200
     5.599   145.461     0.200
     5.858   150.406     0.200
     5.858   150.305     0.200
     5.874   150.555     0.200
     5.899   150.883     0.200
     5.899   151.500     0.200
     5.977   153.844     0.200
     6.122   156.844     0.200
     6.126   155.992     0.200
     6.126   157.266     0.200
     6.138   156.625     0.200
     6.506   166.562     0.200
     6.634   169.164     0.200
     6.758   172.805     0.200
     6.784   172.453     0.200
     6.784   173.750     0.200
     7.021   180.500     0.200
     7.185   183.102     0.200
     7.239   183.039     0.200
     7.261   185.711     0.200
     7.516   192.109     0.200
     7.636   193.133     0.200
     7.646   192.352     0.200
     7.788   196.398     0.200
     8.156   206.125     0.200
     8.187   205.992     0.200
     8.577   214.781     0.200
     8.795   220.555     0.200
     9.056   226.500     0.200
     9.168   230.133     0.200
     9.172   229.289     0.200
     9.362   233.500     0.200
     9.494   235.586     0.200
     9.543   238.484     0.200
     9.844   245.625     0.200
    10.189   254.094     0.200
    10.674   266.812     0.200
    10.688   266.484     0.200
    10.922   274.805     0.200
    11.659   295.000     0.200
    20.148   506.547     0.200
     2.271    66.148     0.200
     2.549    70.086     0.200
     2.932    81.875     0.200
     2.947    82.219     0.200
     4.306   116.430     0.200
     4.306   116.148     0.200
     4.456   117.023     0.200
     4.456   119.555     0.200
     4.514   120.523     0.200
     4.663   121.859     0.200
     4.703   124.648     0.200
     5.514   141.219     0.200
     5.517   142.000     0.200
     5.517   143.969     0.200
     5.549   142.164     0.200
     5.558   142.836     0.200
     5.571   143.977     0.200
     5.571   145.914     0.200
     5.578   141.734     0.200
     5.578   143.336     0.200
     5.859   150.344     0.200
     5.859   152.336     0.200
     5.887   151.156     0.200
     5.904   153.578     0.200
     6.003   153.086     0.200
     6.003   153.734     0.200
     6.128   158.203     0.200
     6.139   155.289     0.200
     6.139   157.945     0.200
     6.155   158.453     0.200
     6.535   164.547     0.200
     6.535   167.750     0.200
     6.653   168.453     0.200
     6.653   170.078     0.200
     6.775   172.969     0.200
     6.809   171.969     0.200
     6.809   173.859     0.200
     7.077   177.680     0.200
     7.090   181.039     0.200
     7.205   183.094     0.200
     7.267   185.414     0.200
     7.528   190.234     0.200
     7.528   192.094     0.200
     7.596   192.023     0.200
     7.676   194.812     0.200
     7.806   197.250     0.200
     7.896   203.156     0.200
     8.179   207.117     0.200
     8.218   208.062     0.200
     8.832   221.445     0.200
     9.088   227.609     0.200
     9.200   229.805     0.200
     9.534   240.961     0.200
     2.079    61.089     0.200
     2.291    65.762     0.200
     2.983    85.179     0.200
     4.307   113.938     0.200
     4.442   118.865     0.200
     5.502   142.997     0.200
     5.502   141.035     0.200
     5.492   142.572     0.200
     5.492   143.653     0.200
     5.540   142.288     0.200
     5.540   141.751     0.200
     5.537   144.094     0.200
     5.566   144.184     0.200
     5.558   143.708     0.200
     5.558   141.945     0.200
     5.834   152.793     0.200
     5.865   150.806     0.200
     5.865   152.073     0.200
     5.879   153.584     0.200
     5.986   153.786     0.200
     5.986   154.004     0.200
     6.104   158.714     0.200
     6.118   158.044     0.200
     6.520   166.421     0.200
     6.520   165.132     0.200
     6.634   169.401     0.200
     6.634   170.054     0.200
     6.754   173.874     0.200
     6.792   172.356     0.200
     7.081   178.488     0.200
     7.187   183.384     0.200
     7.252   185.184     0.200
     7.642   194.254     0.200
     3.475    90.062     0.200
     3.475    91.305     0.200
     3.528    92.625     0.200
     3.563    92.688     0.200
     3.579    93.102     0.200
     3.576    96.555     0.200
     3.809    97.703     0.200
     3.820   100.555     0.200
     3.852    99.344     0.200
     3.852   100.836     0.200
     3.860    99.602     0.200
     3.860   100.727     0.200
     4.001   104.172     0.200
     4.001   103.984     0.200
     4.045   104.305     0.200
     4.045   104.602     0.200
     4.083   106.453     0.200
     4.103   105.094     0.200
     4.103   107.391     0.200
     4.137   107.797     0.200
     4.643   119.758     0.200
     4.643   119.984     0.200
     4.750   122.203     0.200
     4.811   123.734     0.200
     4.834   123.680     0.200
     4.834   123.844     0.200
     5.201   133.203     0.200
     5.325   136.172     0.200
     5.673   143.984     0.200
     5.740   144.688     0.200
     5.795   146.172     0.200
     6.965   175.672     0.200
     7.175   180.367     0.200
     7.284   183.070     0.200
     7.946   199.516     0.200
     1.378    46.133     0.200
     2.278    68.449     0.200
     3.500    98.480     0.200
     5.271   137.645     0.200
     5.352   138.957     0.200
     5.588   148.457     0.200
     5.661   146.367     0.200
     5.909   153.996     0.200
     5.924   153.355     0.200
     7.049   179.816     0.200
     0.930    33.107     0.200
     3.103    84.023     0.200
     3.463    91.744     0.200
     3.517    93.164     0.200
     3.517    94.314     0.200
     3.552    94.295     0.200
     3.569    94.150     0.200
     3.808   100.514     0.200
     3.802    99.473     0.200
     3.840   100.764     0.200
     3.995   104.762     0.200
     4.035   105.164     0.200
     4.092   107.365     0.200
     4.739   123.555     0.200
     4.806   124.566     0.200
     5.190   134.494     0.200
     5.315   137.004     0.200
     5.356   137.258     0.200
     5.376   136.941     0.200
     5.663   144.674     0.200
     1.303    44.520     0.200
     2.112    62.699     0.200
     2.849    80.469     0.200
     2.809    80.648     0.200
     3.232    87.391     0.200
     3.399    90.988     0.200
     3.478    94.109     0.200
     3.586    96.008     0.200
     3.615    97.328     0.200
     3.734   100.098     0.200
     4.428   115.438     0.200
     4.428   116.172     0.200
     4.443   116.082     0.200
     4.470   116.402     0.200
     4.490   115.973     0.200
     4.490   117.219     0.200
     4.505   118.379     0.200
     4.534   117.008     0.200
     4.534   118.551     0.200
     4.617   120.965     0.200
     4.617   120.367     0.200
     4.790   125.539     0.200
     4.790   124.992     0.200
     4.799   124.535     0.200
     4.799   123.891     0.200
     4.827   125.504     0.200
     4.925   127.039     0.200
     4.925   127.602     0.200
     5.048   130.633     0.200
     5.051   129.941     0.200
     5.345   138.027     0.200
     5.566   142.590     0.200
     5.566   142.184     0.200
     5.686   146.082     0.200
     5.727   147.605     0.200
     5.727   146.773     0.200
     6.003   152.727     0.200
     6.087   154.609     0.200
     6.118   156.922     0.200
     6.194   158.211     0.200
     6.568   166.211     0.200
     6.576   167.324     0.200
     6.605   167.980     0.200
     2.228    63.621     0.200
     2.632    72.363     0.200
     2.652    74.219     0.200
     3.157    84.723     0.200
     3.482    90.980     0.200
     3.539    92.184     0.200
     3.577    93.383     0.200
     3.577    92.766     0.200
     3.603    92.871     0.200
     3.603    92.438     0.200
     3.818    99.414     0.200
     3.846    98.586     0.200
     3.861   100.254     0.200
     3.860    98.871     0.200
     3.860   100.641     0.200
     4.044   104.359     0.200
     4.067   104.355     0.200
     4.067   104.793     0.200
     4.085   105.980     0.200
     4.112   106.672     0.200
     4.150   107.512     0.200
     4.180   109.926     0.200
     4.762   122.293     0.200
     4.853   124.773     0.200
     4.857   124.582     0.200
     5.216   133.332     0.200
     5.347   136.391     0.200
     5.424   135.797     0.200
     5.691   144.023     0.200
     6.317   159.941     0.200
     6.992   175.922     0.200
     2.166    61.973     0.200
     2.592    71.012     0.200
     2.857    78.191     0.200
     3.526    92.977     0.200
     3.572    94.141     0.200
     3.593    94.086     0.200
     3.593    95.879     0.200
     3.600    94.961     0.200
     3.600    94.039     0.200
     3.788    99.031     0.200
     3.891   102.629     0.200
     3.891   101.793     0.200
     3.899   102.453     0.200
     3.959   103.754     0.200
     3.959   103.500     0.200
     4.053   105.254     0.200
     4.064   105.238     0.200
     4.064   105.883     0.200
     4.145   108.133     0.200
     4.151   108.883     0.200
     4.175   108.922     0.200
     4.679   121.223     0.200
     4.758   123.383     0.200
     4.792   124.344     0.200
     5.234   134.211     0.200
     5.341   137.602     0.200
     5.344   135.477     0.200
     5.540   142.668     0.200
     5.701   145.824     0.200
     5.787   147.176     0.200
     6.162   157.535     0.200
     0.966    34.344     0.200
     2.573    72.477     0.200
     2.573    72.590     0.200
     2.695    75.031     0.200
     2.778    78.297     0.200
     2.867    79.938     0.200
     3.106    85.111     0.200
     3.106    84.066     0.200
     3.431    91.215     0.200
     3.431    91.602     0.200
     3.487    92.873     0.200
     3.469    94.199     0.200
     3.523    94.055     0.200
     3.523    93.652     0.200
     3.501    95.582     0.200
     3.546    93.629     0.200
     3.585    97.461     0.200
     3.774   100.441     0.200
     3.787    99.307     0.200
     3.809   100.869     0.200
     3.809   100.422     0.200
     3.814   100.703     0.200
     3.814   101.453     0.200
     3.986   104.699     0.200
     3.986   104.590     0.200
     4.010   104.984     0.200
     4.010   105.422     0.200
     4.038   106.963     0.200
     4.061   106.402     0.200
     4.061   106.992     0.200
     4.096   107.902     0.200
     4.128   111.400     0.200
     4.153   114.250     0.200
     4.162   114.977     0.200
     4.604   120.316     0.200
     4.709   122.771     0.200
     4.797   123.865     0.200
     4.797   125.848     0.200
     4.800   124.076     0.200
     5.161   133.902     0.200
     5.290   134.963     0.200
     5.366   136.244     0.200
     5.446   141.184     0.200
     5.446   142.262     0.200
     5.515   144.113     0.200
     5.515   144.217     0.200
     5.563   141.133     0.200
     5.635   144.373     0.200
     5.705   145.143     0.200
     5.750   147.572     0.200
     5.768   146.924     0.200
     6.150   158.021     0.200
     6.259   159.732     0.200
     6.332   160.773     0.200
     6.632   167.223     0.200
     6.934   176.281     0.200
     7.141   180.191     0.200
     7.151   181.453     0.200
     7.250   183.662     0.200
     7.540   190.303     0.200
     7.618   191.053     0.200
     7.777   194.479     0.200
     7.911   199.342     0.200
     0.835    30.484     0.200
     0.823    31.219     0.200
     1.151    38.082     0.200
     1.151    38.566     0.200
     2.360    67.688     0.200
     3.104    87.035     0.200
     4.469   118.203     0.200
     4.469   117.406     0.200
     4.726   123.223     0.200
     4.709   124.449     0.200
     4.709   123.512     0.200
     5.238   133.676     0.200
     5.238   134.734     0.200
     5.322   136.852     0.200
     5.382   137.508     0.200
     5.382   138.688     0.200
     5.445   139.496     0.200
     5.445   140.375     0.200
     5.469   139.641     0.200
     5.469   139.844     0.200
     5.548   142.684     0.200
     5.628   143.188     0.200
     5.628   144.254     0.200
     5.663   143.473     0.200
     5.663   143.574     0.200
     5.786   148.004     0.200
     5.801   147.871     0.200
     5.801   146.129     0.200
     5.876   150.043     0.200
     5.903   149.148     0.200
     5.903   150.312     0.200
     6.545   166.773     0.200
     6.557   167.562     0.200
     6.679   168.598     0.200
     6.679   169.703     0.200
     7.020   179.172     0.200
     7.184   181.895     0.200
     0.871    29.206     0.200
     1.700    50.163     0.200
     2.498    68.935     0.200
     3.489    92.134     0.200
     3.535    91.364     0.200
     3.556    91.746     0.200
     3.562    91.479     0.200
     3.562    93.042     0.200
     3.755    94.268     0.200
     3.755    95.673     0.200
     3.930   100.680     0.200
     3.930   100.252     0.200
     4.027   102.052     0.200
     4.027   102.273     0.200
     4.641   117.662     0.200
     1.148    38.805     0.200
     2.044    59.598     0.200
     2.884    79.785     0.200
     2.990    82.051     0.200
     2.956    83.020     0.200
     3.005    83.941     0.200
     3.005    82.742     0.200
     3.132    83.539     0.200
     3.274    86.469     0.200
     3.667    97.047     0.200
     3.667    95.895     0.200
     3.613    99.586     0.200
     3.854    99.496     0.200
     3.854   100.570     0.200
     3.933   101.457     0.200
     3.991   102.859     0.200
     4.069   105.867     0.200
     4.121   107.141     0.200
     4.121   107.379     0.200
     4.187   106.910     0.200
     4.187   109.668     0.200
     4.243   108.871     0.200
     4.243   109.891     0.200
     4.357   111.992     0.200
     4.357   112.715     0.200
     4.420   114.168     0.200
     4.492   116.418     0.200
     4.519   115.145     0.200
     4.519   117.098     0.200
     4.556   118.430     0.200
     4.567   117.391     0.200
     4.567   116.840     0.200
     5.070   129.438     0.200
     5.070   130.199     0.200
     5.085   129.555     0.200
     5.157   132.688     0.200
     5.291   135.969     0.200
     5.631   144.000     0.200
     5.801   147.578     0.200
     5.861   147.621     0.200
     5.946   148.699     0.200
     6.118   154.918     0.200
     6.145   153.207     0.200
     6.146   152.871     0.200
     6.204   158.117     0.200
     6.217   157.129     0.200
     6.322   159.848     0.200
     6.914   173.250     0.200
     7.140   178.809     0.200
     7.468   187.098     0.200
     7.659   193.309     0.200
     7.766   195.617     0.200
     0.904    34.094     0.200
     1.535    47.453     0.200
     1.720    52.734     0.200
     4.864   126.906     0.200
     4.879   126.883     0.200
     5.234   137.078     0.200
     5.931   153.211     0.200
     6.478   165.383     0.200
     1.410    41.881     0.200
     1.598    47.361     0.200
     1.988    57.041     0.200
     2.175    61.629     0.200
     2.255    62.896     0.200
     2.272    64.846     0.200
     2.272    65.445     0.200
     2.654    72.955     0.200
     2.777    77.943     0.200
     2.880    78.102     0.200
     2.862    80.859     0.200
     3.089    86.021     0.200
     3.145    87.129     0.200
     3.481    94.418     0.200
     3.716    95.828     0.200
     3.716    96.951     0.200
     3.551    98.762     0.200
     3.790    98.967     0.200
     3.790    98.174     0.200
     3.775   100.119     0.200
     3.775    99.010     0.200
     3.809    99.344     0.200
     3.810    99.258     0.200
     3.810   102.496     0.200
     3.863   101.545     0.200
     3.790   105.266     0.200
     3.889   107.043     0.200
     3.889   106.381     0.200
     3.940   107.326     0.200
     4.146   107.785     0.200
     4.146   107.475     0.200
     4.204   108.551     0.200
     4.204   108.344     0.200
     4.217   109.352     0.200
     4.217   108.814     0.200
     4.217   111.320     0.200
     4.230   107.594     0.200
     4.230   109.535     0.200
     4.387   113.465     0.200
     4.398   111.045     0.200
     4.398   112.965     0.200
     4.215   115.455     0.200
     4.439   114.785     0.200
     4.646   120.014     0.200
     4.606   119.760     0.200
     4.732   120.668     0.200
     4.732   120.553     0.200
     4.700   125.195     0.200
     4.876   124.293     0.200
     4.876   125.494     0.200
     4.763   126.514     0.200
     5.011   127.984     0.200
     5.013   128.541     0.200
     5.013   127.945     0.200
     5.250   132.750     0.200
     5.415   138.859     0.200
     5.415   138.611     0.200
     5.416   138.768     0.200
     5.465   139.945     0.200
     5.789   148.334     0.200
     5.789   147.934     0.200
     5.812   147.006     0.200
     5.873   148.625     0.200
     6.031   151.625     0.200
     6.386   161.604     0.200
     6.415   161.635     0.200
     6.803   171.264     0.200
     7.034   176.844     0.200
     7.285   182.324     0.200
     7.399   185.664     0.200
     7.397   184.895     0.200
     7.612   191.795     0.200
     7.745   194.641     0.200
     7.771   193.395     0.200
     8.072   200.484     0.200
    19.757   493.510     0.200
    21.528   531.234     0.200
     1.960    57.348     0.200
     2.231    62.598     0.200
     2.231    62.352     0.200
     2.640    73.172     0.200
     2.894    79.012     0.200
     2.852    80.324     0.200
     3.790    99.023     0.200
     3.790    99.594     0.200
     3.807    97.133     0.200
     3.807    99.266     0.200
     3.805   100.258     0.200
     3.805    99.758     0.200
     3.756   100.727     0.200
     3.756    99.758     0.200
     3.838   102.324     0.200
     3.838   101.543     0.200
     4.144   108.145     0.200
     4.144   108.371     0.200
     4.222   108.812     0.200
     4.233   110.391     0.200
     4.194   107.582     0.200
     4.194   108.562     0.200
     4.383   114.262     0.200
     4.396   114.211     0.200
     4.441   115.184     0.200
     4.644   120.551     0.200
     4.721   122.395     0.200
     4.870   125.613     0.200
     5.007   129.762     0.200
     5.004   128.406     0.200
     5.004   128.012     0.200
     5.415   138.254     0.200
     5.454   139.453     0.200
     5.858   149.383     0.200
     0.928    31.548     0.200
     1.414    41.656     0.200
     3.806    99.321     0.200
     3.824    98.871     0.200
     4.213   108.921     0.200
     0.806    29.252     0.200
     1.419    41.315     0.200
     1.958    54.403     0.200
     2.139    59.732     0.200
     2.255    63.665     0.200
     2.255    61.132     0.200
     2.664    73.806     0.200
     2.664    71.507     0.200
     2.767    76.734     0.200
     2.767    75.565     0.200
     3.074    84.777     0.200
     3.463    93.167     0.200
     3.729    98.153     0.200
     3.780    98.735     0.200
     3.780    98.554     0.200
     3.811    99.476     0.200
     3.827    98.454     0.200
     3.827    98.812     0.200
     3.829    98.965     0.200
     3.862   101.180     0.200
     3.862   101.313     0.200
     4.218   108.326     0.200
     4.218   108.805     0.200
     4.417   113.055     0.200
     4.461   114.625     0.200
     4.602   120.807     0.200
     4.666   120.315     0.200
     4.744   122.358     0.200
     4.893   125.905     0.200
     5.027   129.555     0.200
     5.249   134.560     0.200
     5.438   139.045     0.200
     5.477   139.805     0.200
     6.426   163.396     0.200
     2.589    76.422     0.200
     2.778    81.180     0.200
     2.900    84.625     0.200
     3.071    88.141     0.200
     3.162    90.375     0.200
     3.982   105.422     0.200
     4.401   116.633     0.200
     5.389   138.609     0.200
     5.443   138.758     0.200
     5.444   142.414     0.200
     5.473   141.367     0.200
     5.526   142.664     0.200
     5.581   145.258     0.200
     5.707   148.461     0.200
     5.760   149.570     0.200
     5.767   148.523     0.200
     5.924   150.977     0.200
     5.988   154.781     0.200
     6.019   154.844     0.200
     6.264   161.250     0.200
     6.273   161.117     0.200
     6.465   164.547     0.200
     6.664   170.508     0.200
     6.724   172.117     0.200
     6.961   177.539     0.200
     7.107   181.398     0.200
     7.196   180.859     0.200
     7.571   191.742     0.200
     0.893    30.234     0.200
     1.945    55.250     0.200
     2.755    75.484     0.200
     3.774    98.008     0.200
     3.829    99.590     0.200
     3.827    96.602     0.200
     3.854   100.602     0.200
     4.216   109.852     0.200
     0.908    33.156     0.200
     1.099    38.758     0.200
     2.431    68.656     0.200
     2.602    74.719     0.200
     3.125    84.047     0.200
     3.125    83.922     0.200
     3.140    88.258     0.200
     3.455    91.195     0.200
     3.455    91.578     0.200
     3.511    93.242     0.200
     3.548    93.703     0.200
     3.517    96.898     0.200
     3.571    92.219     0.200
     3.475    96.422     0.200
     3.528    97.586     0.200
     3.563    98.422     0.200
     3.811    99.289     0.200
     3.811    98.906     0.200
     3.833   101.336     0.200
     3.833   100.688     0.200
     3.837   100.836     0.200
     3.837   101.242     0.200
     4.009   104.844     0.200
     4.009   105.805     0.200
     4.035   105.070     0.200
     4.061   107.070     0.200
     4.085   105.805     0.200
     4.085   107.508     0.200
     4.592   118.938     0.200
     4.592   116.781     0.200
     4.628   120.328     0.200
     4.733   122.477     0.200
     4.822   124.234     0.200
     4.822   124.867     0.200
     4.823   123.586     0.200
     5.186   133.828     0.200
     5.315   137.055     0.200
     5.660   144.656     0.200
     5.730   145.328     0.200
     6.285   160.578     0.200
     6.959   176.172     0.200
     1.084    37.852     0.200
     1.742    52.945     0.200
     3.543    94.004     0.200
     3.570    94.566     0.200
     3.815    99.496     0.200
     4.016   105.102     0.200
     4.591   118.996     0.200
     4.831   125.047     0.200
     1.142    38.102     0.200
     1.238    41.797     0.200
     2.459    70.781     0.200
     2.474    71.312     0.200
     3.207    88.117     0.200
     4.368   111.891     0.200
     4.665   119.352     0.200
     4.910   125.562     0.200
     5.002   127.711     0.200
     5.586   142.781     0.200
     1.245    42.633     0.200
     1.245    42.633     0.200
     1.381    43.109     0.200
     1.696    52.297     0.200
     1.960    59.570     0.200
     1.969    58.953     0.200
     3.012    86.477     0.200
     3.578    99.297     0.200
     5.602   143.984     0.200
     5.700   146.797     0.200
     5.997   154.938     0.200
     6.120   156.555     0.200
     6.240   160.312     0.200
     6.322   160.430     0.200
     6.475   164.000     0.200
     7.086   182.547     0.200
     7.584   191.758     0.200
     7.603   192.203     0.200
     9.275   233.500     0.200
     1.261    44.180     0.200
     1.753    54.773     0.200
     1.953    59.789     0.200
     2.109    63.867     0.200
     2.602    72.828     0.200
     2.585    75.820     0.200
     3.012    81.891     0.200
     3.119    83.773     0.200
     3.092    87.328     0.200
     3.139    87.797     0.200
     3.195    87.938     0.200
     3.298    90.789     0.200
     3.449    95.719     0.200
     3.634    97.508     0.200
     4.045   111.922     0.200
     4.163   112.719     0.200
     4.542   121.867     0.200
     4.542   120.922     0.200
     4.605   122.117     0.200
     4.605   122.016     0.200
     4.635   122.305     0.200
     4.736   124.266     0.200
     4.736   124.477     0.200
     4.918   128.914     0.200
     4.918   127.891     0.200
     4.941   128.602     0.200
     4.943   128.398     0.200
     5.234   136.180     0.200
     5.234   137.211     0.200
     5.282   137.953     0.200
     5.282   138.148     0.200
     5.274   138.719     0.200
     5.405   140.570     0.200
     5.407   141.367     0.200
     5.532   143.211     0.200
     5.609   145.578     0.200
     5.726   147.961     0.200
     5.726   147.719     0.200
     5.888   153.297     0.200
     5.961   153.664     0.200
     5.961   153.930     0.200
     6.050   155.039     0.200
     6.050   156.844     0.200
     6.116   158.398     0.200
     6.457   166.352     0.200
     6.492   167.172     0.200
     6.655   169.562     0.200
     6.906   177.672     0.200
     1.249    41.716     0.200
     1.853    56.524     0.200
     1.973    57.343     0.200
     3.188    90.616     0.200
     3.338    92.685     0.200
     4.598   119.491     0.200
     4.633   121.722     0.200
     4.633   122.021     0.200
     4.647   122.005     0.200
     5.006   130.773     0.200
     5.065   130.833     0.200
     5.394   142.046     0.200
     5.597   145.120     0.200
     5.871   150.973     0.200
     6.181   158.833     0.200
     1.057    35.621     0.200
     1.761    51.277     0.200
     1.761    51.629     0.200
     2.430    68.848     0.200
     2.641    70.801     0.200
     2.595    73.293     0.200
     2.708    76.172     0.200
     3.469    94.395     0.200
     3.548    92.594     0.200
     3.599    93.848     0.200
     3.630    94.523     0.200
     3.630    94.344     0.200
     3.634    96.547     0.200
     3.842   100.316     0.200
     3.842    99.258     0.200
     3.891   101.586     0.200
     3.924   101.895     0.200
     3.939   103.008     0.200
     4.019   104.562     0.200
     4.019   104.098     0.200
     4.103   105.141     0.200
     4.103   105.574     0.200
     4.176   106.305     0.200
     4.176   108.266     0.200
     4.204   109.168     0.200
     4.422   114.625     0.200
     4.656   119.043     0.200
     4.656   119.477     0.200
     4.821   123.020     0.200
     4.894   125.668     0.200
     5.266   134.535     0.200
     5.381   137.535     0.200
     5.398   136.660     0.200
     5.403   136.137     0.200
     5.736   145.816     0.200
     5.836   147.809     0.200
     5.858   148.867     0.200
     1.332    44.977     0.200
     2.615    71.664     0.200
     2.615    72.422     0.200
     2.720    77.344     0.200
     2.750    75.781     0.200
     2.750    76.914     0.200
     3.091    86.125     0.200
     3.093    86.992     0.200
     3.347    94.422     0.200
     3.713   102.406     0.200
     3.694   105.867     0.200
     4.207   112.820     0.200
     4.682   122.773     0.200
     5.006   131.250     0.200
     5.362   140.359     0.200
     5.370   138.938     0.200
     1.281    43.445     0.200
     5.683   144.137     0.200
     5.710   146.227     0.200
     5.985   152.816     0.200
     6.408   163.375     0.200
     6.443   164.137     0.200
     7.329   181.277     0.200
     7.419   187.578     0.200
     1.072    41.156     0.200
     1.156    42.234     0.200
     4.704   125.102     0.200
     4.773   126.641     0.200
     5.089   133.750     0.200
     5.314   139.852     0.200
     5.582   145.781     0.200
     6.101   159.000     0.200
     6.937   178.047     0.200
     1.506    47.895     0.200
     1.597    50.254     0.200
     1.923    59.949     0.200
     1.923    59.520     0.200
     2.113    64.531     0.200
     2.298    67.992     0.200
     2.907    83.004     0.200
     3.278    94.414     0.200
     3.333    92.340     0.200
     3.755   104.285     0.200
     3.879   111.656     0.200
     4.035   110.980     0.200
     4.228   113.035     0.200
     4.228   113.672     0.200
     4.441   118.137     0.200
     4.486   118.648     0.200
     4.797   127.684     0.200
     4.797   128.242     0.200
     4.891   128.598     0.200
     4.891   130.297     0.200
     5.115   133.074     0.200
     5.115   134.070     0.200
     5.211   136.219     0.200
     5.283   137.930     0.200
     5.283   137.207     0.200
     5.312   138.410     0.200
     5.312   138.582     0.200
     5.370   141.070     0.200
     5.383   140.473     0.200
     5.401   140.359     0.200
     5.510   143.477     0.200
     5.641   146.699     0.200
     5.656   147.676     0.200
     5.656   146.629     0.200
     5.754   146.789     0.200
     5.754   149.449     0.200
     5.830   150.051     0.200
     5.830   150.980     0.200
     5.839   151.281     0.200
     5.828   151.121     0.200
     5.828   152.344     0.200
     5.829   153.332     0.200
     5.990   155.102     0.200
     6.356   163.711     0.200
     6.398   163.723     0.200
     6.398   165.059     0.200
     6.430   166.301     0.200
     6.594   167.898     0.200
     6.594   170.191     0.200
     6.917   178.051     0.200
     7.103   183.672     0.200
     7.110   182.371     0.200
     7.210   182.512     0.200
     7.214   183.246     0.200
     7.398   188.496     0.200
     7.398   187.512     0.200
     7.479   192.070     0.200
     7.527   191.379     0.200
     7.634   193.398     0.200
     8.085   205.109     0.200
     8.145   207.223     0.200
     8.447   213.820     0.200
     8.653   218.945     0.200
     8.916   225.230     0.200
     8.970   227.340     0.200
     8.984   228.109     0.200
     9.077   229.570     0.200
     9.399   236.961     0.200
     9.534   237.332     0.200
     9.534   240.793     0.200
     9.599   241.172     0.200
    10.877   269.590     0.200
     1.125    41.289     0.200
     1.323    46.099     0.200
     2.323    70.126     0.200
     2.455    72.020     0.200
     2.644    76.783     0.200
     2.660    78.578     0.200
     3.443    95.872     0.200
     3.522    98.042     0.200
     4.930   128.697     0.200
     5.004   130.526     0.200
     5.263   137.286     0.200
     5.317   138.556     0.200
     5.557   143.796     0.200
     6.134   157.296     0.200
     3.393    89.828     0.200
     4.284   110.869     0.200
     4.353   111.853     0.200
     4.420   114.609     0.200
     4.762   121.537     0.200
     4.762   122.091     0.200
     4.899   125.444     0.200
     4.899   126.259     0.200
     4.972   127.171     0.200
     5.468   138.387     0.200
     5.468   138.868     0.200
     6.311   158.791     0.200
     6.352   159.445     0.200
     1.921    58.512     0.200
     2.585    75.654     0.200
     5.858   153.371     0.200
     5.948   154.561     0.200
     5.982   154.262     0.200
     6.048   157.521     0.200
     6.067   158.102     0.200
     6.255   161.842     0.200
     6.615   169.061     0.200
     6.681   171.471     0.200
     6.713   171.781     0.200
     7.132   183.012     0.200
     7.177   183.512     0.200
     7.597   190.361     0.200
     8.203   207.480     0.200
     1.790    54.520     0.200
     2.118    62.735     0.200
     2.561    73.067     0.200
     2.716    78.374     0.200
     2.734    78.315     0.200
     3.538    96.922     0.200
     4.828   124.157     0.200
     4.828   124.493     0.200
     4.899   126.063     0.200
     4.947   127.644     0.200
     5.103   132.044     0.200
     5.164   132.300     0.200
     5.164   133.029     0.200
     5.169   133.193     0.200
     5.214   134.023     0.200
     5.292   137.427     0.200
     5.292   137.938     0.200
     5.402   139.374     0.200
     5.444   140.038     0.200
     5.444   140.203     0.200
     5.463   140.104     0.200
     5.516   140.983     0.200
     5.706   145.474     0.200
     6.000   154.186     0.200
     6.000   152.774     0.200
     6.044   155.937     0.200
     6.123   156.604     0.200
     6.229   159.104     0.200
     6.586   167.653     0.200
     6.722   170.773     0.200
     6.724   171.434     0.200
     7.066   178.094     0.200
     1.982    60.312     0.200
     2.919    82.422     0.200
     3.890   103.383     0.200
     3.972   105.336     0.200
     4.280   113.391     0.200
     4.567   119.531     0.200
     1.310    43.045     0.200
     1.594    49.126     0.200
     1.954    58.203     0.200
     2.220    64.221     0.200
     2.220    63.523     0.200
     2.734    78.604     0.200
     2.734    75.946     0.200
     2.841    78.384     0.200
     2.906    82.755     0.200
     3.746   101.149     0.200
     3.746   100.797     0.200
     3.802    99.835     0.200
     3.800   100.757     0.200
     3.800   102.152     0.200
     3.827   102.505     0.200
     3.827   102.868     0.200
     4.187   109.798     0.200
     4.187   109.635     0.200
     4.567   118.680     0.200
     4.713   123.770     0.200
     4.864   127.045     0.200
     1.863    51.141     0.200
     1.864    51.941     0.200
     2.194    62.613     0.200
     2.232    61.832     0.200
     2.553    70.535     0.200
     2.519    71.191     0.200
     2.873    76.438     0.200
     3.252    88.406     0.200
     3.540    92.195     0.200
     3.882    99.059     0.200
     3.882    99.336     0.200
     3.922   100.148     0.200
     3.942   100.027     0.200
     3.942   100.227     0.200
     4.036   104.648     0.200
     4.036   104.309     0.200
     4.159   106.246     0.200
     4.159   105.512     0.200
     4.257   110.922     0.200
     4.288   109.957     0.200
     4.383   110.238     0.200
     4.383   110.695     0.200
     4.504   113.836     0.200
     4.508   114.586     0.200
     4.518   114.328     0.200
     4.923   127.855     0.200
     4.925   122.570     0.200
     5.018   126.527     0.200
     5.138   130.035     0.200
     5.183   130.203     0.200
     5.183   131.008     0.200
     5.547   138.188     0.200
     5.571   140.625     0.200
     5.592   141.793     0.200
     5.655   142.176     0.200
     6.031   150.516     0.200
     6.057   149.723     0.200
     6.067   150.738     0.200
     7.259   181.406     0.200
     0.901    31.914     0.200
     1.182    40.203     0.200
     1.165    38.977     0.200
     1.373    41.961     0.200
     2.038    59.562     0.200
     2.379    67.180     0.200
     2.379    65.867     0.200
     2.491    71.062     0.200
     2.683    74.719     0.200
     2.704    74.711     0.200
     2.955    81.523     0.200
     3.034    83.469     0.200
     3.289    91.891     0.200
     3.697   102.609     0.200
     3.744    97.078     0.200
     3.744    98.469     0.200
     3.778    98.750     0.200
     3.693    97.078     0.200
     3.792    97.078     0.200
     3.792   100.930     0.200
     3.862   100.727     0.200
     3.862   102.414     0.200
     3.985   104.859     0.200
     3.985   104.617     0.200
     3.988   109.570     0.200
     4.109   107.289     0.200
     4.109   107.844     0.200
     4.222   108.336     0.200
     4.222   110.539     0.200
     4.362   113.688     0.200
     4.378   114.523     0.200
     4.761   122.648     0.200
     4.751   121.570     0.200
     4.990   130.125     0.200
     5.024   128.445     0.200
     1.506    49.118     0.200
     1.934    58.939     0.200
     3.155    90.151     0.200
     5.303   138.095     0.200
     5.386   141.345     0.200
     5.853   153.395     0.200
     5.961   154.975     0.200
     6.740   172.864     0.200
     1.113    32.665     0.200
     1.740    48.193     0.200
     2.587    71.427     0.200
     2.685    71.420     0.200
     2.695    71.004     0.200
     3.425    87.090     0.200
     3.336    86.964     0.200
     3.507    89.416     0.200
     4.080   102.128     0.200
     4.170   105.440     0.200
     4.472   112.774     0.200
     4.472   112.490     0.200
     4.623   118.021     0.200
     4.657   116.811     0.200
     4.657   116.256     0.200
     4.786   119.434     0.200
     4.786   119.990     0.200
     4.875   122.864     0.200
     5.356   134.365     0.200
     5.356   134.229     0.200
     5.391   134.650     0.200
     5.549   137.796     0.200
     5.549   139.250     0.200
     5.691   142.631     0.200
     6.066   151.730     0.200
     6.253   154.792     0.200
     6.368   158.490     0.200
     6.611   162.615     0.200
     1.216    41.396     0.200
     2.167    63.770     0.200
     3.734    99.406     0.200
     3.764    99.018     0.200
     4.157   108.338     0.200
     4.198   110.268     0.200
     4.350   114.168     0.200
     4.371   116.947     0.200
     4.975   130.967     0.200
     1.156    39.760     0.200
     2.676    75.354     0.200
     2.676    75.832     0.200
     2.850    79.916     0.200
     2.850    80.547     0.200
     3.348    90.725     0.200
     3.348    90.100     0.200
     3.377    91.799     0.200
     3.322    94.939     0.200
     3.668    97.209     0.200
     3.668    96.793     0.200
     3.732    98.162     0.200
     3.722   100.092     0.200
     3.722   101.764     0.200
     3.776   100.125     0.200
     3.776    99.529     0.200
     3.816   100.125     0.200
     3.816    99.777     0.200
     3.981   105.979     0.200
     3.981   104.963     0.200
     3.988   104.582     0.200
     4.032   106.703     0.200
     4.050   105.615     0.200
     4.050   106.893     0.200
     4.064   107.223     0.200
     4.064   107.297     0.200
     4.064   108.959     0.200
     4.260   112.004     0.200
     4.259   111.859     0.200
     4.259   113.178     0.200
     4.276   111.441     0.200
     4.276   111.754     0.200
     4.301   113.463     0.200
     4.347   113.934     0.200
     4.374   119.381     0.200
     4.836   125.068     0.200
     4.836   126.328     0.200
     4.857   126.803     0.200
     4.956   128.412     0.200
     5.059   131.443     0.200
     5.067   132.160     0.200
     5.416   140.023     0.200
     5.557   143.254     0.200
     5.640   145.188     0.200
     5.894   151.893     0.200
     5.973   152.742     0.200
     6.045   154.865     0.200
     1.023    36.349     0.200
     1.309    44.562     0.200
     1.393    42.486     0.200
     1.712    51.990     0.200
     1.937    56.655     0.200
     2.133    62.128     0.200
     2.657    72.243     0.200
     2.814    76.564     0.200
     2.920    79.713     0.200
     3.072    86.047     0.200
     3.180    88.454     0.200
     3.267    90.875     0.200
     3.615   100.866     0.200
     3.782   101.976     0.200
     4.170   110.512     0.200
     4.251   111.199     0.200
     4.241   118.615     0.200
     4.423   116.598     0.200
     4.638   120.122     0.200
     4.674   122.615     0.200
     4.689   122.505     0.200
     4.762   124.767     0.200
     4.922   128.585     0.200
     4.907   129.105     0.200
     5.016   130.825     0.200
     5.264   136.695     0.200
     5.401   138.460     0.200
     5.511   142.314     0.200
     5.737   147.225     0.200
     6.592   167.765     0.200
     0.961    35.562     0.200
     1.306    45.067     0.200
     1.744    52.342     0.200
     2.162    63.014     0.200
     2.648    74.134     0.200
     2.679    74.101     0.200
     2.789    77.714     0.200
     2.825    78.488     0.200
     2.825    77.796     0.200
     2.925    81.328     0.200
     2.925    80.917     0.200
     3.087    84.230     0.200
     3.208    89.073     0.200
     3.208    88.768     0.200
     3.282    92.538     0.200
     3.619   103.033     0.200
     3.789   101.911     0.200
     4.187   112.026     0.200
     4.272   113.351     0.200
     4.278   115.532     0.200
     4.243   118.509     0.200
     4.450   116.875     0.200
     4.668   121.374     0.200
     4.704   123.167     0.200
     4.720   122.457     0.200
     4.774   126.140     0.200
     4.949   127.538     0.200
     4.949   129.127     0.200
     4.907   129.604     0.200
     5.046   131.677     0.200
     5.236   136.197     0.200
     5.294   136.787     0.200
     5.398   139.027     0.200
     5.426   139.930     0.200
     5.426   140.259     0.200
     5.542   143.518     0.200
     5.694   147.157     0.200
     5.763   148.191     0.200
     5.763   149.277     0.200
     5.859   152.747     0.200
     6.155   159.417     0.200
     6.218   160.387     0.200
     6.619   167.597     0.200
     1.221    41.215     0.200
     1.335    44.057     0.200
     2.083    61.809     0.200
     2.717    74.395     0.200
     2.717    74.790     0.200
     2.819    78.086     0.200
     2.819    77.432     0.200
     2.893    81.493     0.200
     2.893    82.151     0.200
     3.098    86.603     0.200
     3.334    92.491     0.200
     4.204   111.957     0.200
     4.308   113.002     0.200
     4.436   121.928     0.200
     4.746   123.464     0.200
     4.634   126.271     0.200
     4.787   124.154     0.200
     4.808   123.512     0.200
     4.808   124.014     0.200
     5.013   130.326     0.200
     5.013   129.344     0.200
     5.130   133.307     0.200
     5.130   132.194     0.200
     5.376   138.284     0.200
     5.483   142.250     0.200
     5.483   141.690     0.200
     5.623   145.614     0.200
     5.826   150.200     0.200
     5.934   153.754     0.200
     6.285   159.744     0.200
     6.680   170.134     0.200
     0.752    26.555     0.200
     0.867    29.569     0.200
     1.014    34.152     0.200
     2.594    68.856     0.200
     3.361    89.156     0.200
     4.190   106.476     0.200
     4.190   107.409     0.200
     4.278   109.159     0.200
     4.465   113.800     0.200
     4.500   115.739     0.200
     4.582   116.959     0.200
     4.737   119.819     0.200
     4.738   120.103     0.200
     4.738   120.807     0.200
     4.829   121.739     0.200
     4.886   123.083     0.200
     4.886   123.560     0.200
     4.944   125.497     0.200
     4.944   126.675     0.200
     5.067   130.279     0.200
     5.454   138.273     0.200
     5.454   137.603     0.200
     5.652   141.822     0.200
     5.652   143.459     0.200
     5.980   144.399     0.200
     5.753   146.097     0.200
     6.167   155.470     0.200
     6.700   169.334     0.200
     0.950    32.875     0.200
     1.776    48.502     0.200
     2.625    73.035     0.200
     2.737    72.381     0.200
     2.990    77.432     0.200
     3.259    83.150     0.200
     3.553    92.188     0.200
     4.153   104.932     0.200
     4.622   115.771     0.200
     4.762   120.602     0.200
     4.836   121.771     0.200
     5.330   133.428     0.200
     5.651   142.002     0.200
     1.196    40.406     0.200
     1.156    38.305     0.200
     1.461    44.000     0.200
     2.232    61.953     0.200
     2.198    63.906     0.200
     2.364    67.305     0.200
     2.699    75.641     0.200
     2.940    81.805     0.200
     3.018    82.031     0.200
     3.274    91.180     0.200
     3.768    99.219     0.200
     3.847   100.320     0.200
     3.970   104.344     0.200
     3.973   106.641     0.200
     4.100   108.055     0.200
     4.154   108.820     0.200
     4.209   110.180     0.200
     4.352   114.977     0.200
     4.749   122.633     0.200
     4.736   123.750     0.200
     4.979   130.641     0.200
     5.358   137.367     0.200
     0.720    26.711     0.200
     1.080    35.234     0.200
     5.417   139.398     0.200
     5.885   149.688     0.200
     5.972   153.102     0.200
     5.991   152.438     0.200
     6.212   159.367     0.200
     6.770   171.992     0.200
     0.722    26.152     0.200
     0.839    29.715     0.200
     1.775    51.754     0.200
     1.987    55.570     0.200
     1.987    56.367     0.200
     2.522    69.238     0.200
     2.664    75.484     0.200
     2.756    76.078     0.200
     2.756    75.195     0.200
     2.729    75.883     0.200
     2.734    73.332     0.200
     2.921    79.766     0.200
     2.921    78.500     0.200
     3.038    82.789     0.200
     3.041    82.789     0.200
     3.041    82.684     0.200
     3.235    85.113     0.200
     3.429    91.164     0.200
     3.429    91.574     0.200
     3.459    93.953     0.200
     3.459    92.488     0.200
     3.517    92.203     0.200
     3.713    97.449     0.200
     3.713    96.773     0.200
     3.781    98.402     0.200
     3.829    99.074     0.200
     3.794   101.250     0.200
     3.795   102.793     0.200
     3.803   100.699     0.200
     3.803   101.082     0.200
     3.879    99.438     0.200
     3.879   100.559     0.200
     4.014   104.191     0.200
     4.069   104.363     0.200
     4.069   106.301     0.200
     4.097   106.285     0.200
     4.139   106.980     0.200
     4.139   108.012     0.200
     4.229   111.402     0.200
     4.298   111.254     0.200
     4.337   110.887     0.200
     4.337   111.824     0.200
     4.347   110.613     0.200
     4.347   112.871     0.200
     4.337   112.492     0.200
     4.337   112.199     0.200
     4.398   113.461     0.200
     4.456   116.199     0.200
     4.591   118.453     0.200
     4.899   125.086     0.200
     4.899   124.488     0.200
     5.005   129.074     0.200
     5.117   129.438     0.200
     5.117   130.344     0.200
     5.148   131.941     0.200
     5.387   140.480     0.200
     5.469   140.184     0.200
     5.618   143.184     0.200
     5.692   143.969     0.200
     5.725   144.668     0.200
     5.725   146.023     0.200
     5.718   144.059     0.200
     5.829   150.688     0.200
     5.829   148.637     0.200
     5.914   149.164     0.200
     5.916   149.691     0.200
     5.950   150.512     0.200
     6.034   151.914     0.200
     6.050   154.344     0.200
     6.115   153.512     0.200
     6.463   162.672     0.200
     6.590   165.414     0.200
     6.681   167.684     0.200
     6.959   174.691     0.200
     7.493   187.770     0.200
     7.581   188.672     0.200
     7.883   196.914     0.200
     7.948   197.371     0.200
     8.019   200.664     0.200
     8.019   200.270     0.200
     8.107   201.629     0.200
     8.239   204.621     0.200
     8.815   219.062     0.200
     9.023   223.238     0.200
     9.358   232.223     0.200
     9.463   233.195     0.200
     9.860   243.379     0.200
     1.362    48.535     0.200
     1.278    45.461     0.200
     1.411    49.508     0.200
     1.256    43.848     0.200
     1.983    60.797     0.200
     2.105    64.465     0.200
     5.374   138.395     0.200
     5.656   145.973     0.200
     6.050   154.852     0.200
     6.579   168.824     0.200
     1.133    37.391     0.200
     1.156    38.539     0.200
     1.594    48.945     0.200
     2.783    75.609     0.200
     2.783    74.414     0.200
     3.025    82.203     0.200
     3.025    81.797     0.200
     4.014   107.414     0.200
     4.334   115.844     0.200
     4.334   115.727     0.200
     4.373   117.148     0.200
     4.373   114.734     0.200
     4.476   119.062     0.200
     4.648   120.836     0.200
     4.668   119.688     0.200
     4.668   120.188     0.200
     4.974   127.055     0.200
     4.974   129.211     0.200
     5.009   129.070     0.200
     5.129   131.508     0.200
     5.129   130.914     0.200
     5.131   132.758     0.200
     5.471   141.914     0.200
     5.471   140.852     0.200
     5.693   145.039     0.200
     1.816    54.982     0.200
     2.450    72.332     0.200
     2.871    82.420     0.200
     3.883   106.039     0.200
     4.634   121.340     0.200
     4.634   120.900     0.200
     4.694   122.629     0.200
     4.730   124.396     0.200
     4.730   124.832     0.200
     4.731   124.494     0.200
     4.731   124.953     0.200
     4.881   129.068     0.200
     4.881   126.428     0.200
     4.946   130.428     0.200
     5.000   129.340     0.200
     5.000   130.818     0.200
     5.015   130.578     0.200
     5.015   129.605     0.200
     4.991   131.125     0.200
     4.991   130.428     0.200
     5.203   135.068     0.200
     5.203   134.371     0.200
     5.228   135.189     0.200
     5.266   136.779     0.200
     5.810   150.309     0.200
     5.997   154.959     0.200
     5.997   154.268     0.200
     6.368   163.369     0.200
     6.379   164.262     0.200
     6.437   164.885     0.200
     6.839   174.359     0.200
     6.894   175.340     0.200
     2.114    62.502     0.200
     2.150    63.039     0.200
     2.767    78.854     0.200
     2.948    84.648     0.200
     3.501    97.404     0.200
     3.816   104.455     0.200
     3.909   109.434     0.200
     4.640   126.180     0.200
     2.363    67.430     0.200
     2.193    62.062     0.200
     2.938    82.656     0.200
     3.016    83.016     0.200
     3.271    91.758     0.200
     3.305    92.555     0.200
     3.443    96.680     0.200
     3.769    99.289     0.200
     3.748   105.984     0.200
     3.847   102.594     0.200
     3.968   106.461     0.200
     3.970   108.188     0.200
     4.210   110.172     0.200
     4.749   122.898     0.200
     0.998    34.719     0.200
     2.806    79.559     0.200
     3.931   103.676     0.200
     4.265   110.465     0.200
     4.393   113.164     0.200
     4.476   115.023     0.200
     4.662   118.473     0.200
     4.714   120.457     0.200
     4.896   125.484     0.200
     5.116   131.344     0.200
     5.165   132.648     0.200
     5.455   137.684     0.200
     5.583   142.453     0.200
     6.004   147.762     0.200
     6.685   167.188     0.200
     0.844    31.414     0.200
     0.973    35.375     0.200
     1.462    46.453     0.200
     1.978    60.133     0.200
     2.182    64.328     0.200
     5.141   133.531     0.200
     5.234   135.305     0.200
     5.535   142.641     0.200
     5.842   150.188     0.200
     6.454   165.039     0.200
     6.927   170.141     0.200
     7.123   181.461     0.200
     2.832    81.261     0.200
     5.967   151.373     0.200
     6.033   153.663     0.200
     6.098   154.173     0.200
     6.142   157.073     0.200
     6.158   156.303     0.200
     6.364   161.183     0.200
     6.404   161.743     0.200
     6.595   166.743     0.200
     6.730   169.493     0.200
     6.815   171.093     0.200
     6.814   172.023     0.200
     7.246   182.333     0.200
     7.284   183.093     0.200
     7.692   189.173     0.200
     7.535   189.043     0.200
     7.802   196.143     0.200
     8.080   202.493     0.200
     8.318   209.783     0.200
     1.147    40.453     0.200
     1.365    46.969     0.200
     1.367    46.594     0.200
     1.383    46.766     0.200
     1.961    58.164     0.200
     2.077    63.422     0.200
     2.248    67.984     0.200
     2.734    76.742     0.200
     2.734    77.992     0.200
     2.734    78.367     0.200
     2.833    80.211     0.200
     2.844    79.219     0.200
     2.844    80.219     0.200
     2.681    79.492     0.200
     2.922    82.445     0.200
     2.922    83.211     0.200
     3.120    87.445     0.200
     3.141    86.656     0.200
     3.141    87.195     0.200
     3.181    90.047     0.200
     3.183    89.094     0.200
     3.311    92.352     0.200
     3.311    93.812     0.200
     3.416    92.734     0.200
     3.416    94.805     0.200
     3.348    95.812     0.200
     3.795   105.109     0.200
     3.653   104.578     0.200
     4.129   111.094     0.200
     4.114   111.430     0.200
     4.225   113.477     0.200
     4.225   114.438     0.200
     4.247   112.422     0.200
     4.326   114.281     0.200
     4.326   115.758     0.200
     4.524   120.102     0.200
     4.524   120.805     0.200
     4.405   117.875     0.200
     4.405   122.844     0.200
     4.604   126.703     0.200
     4.753   124.562     0.200
     4.793   125.477     0.200
     4.812   125.305     0.200
     4.812   125.828     0.200
     4.888   131.000     0.200
     5.024   131.500     0.200
     5.135   133.234     0.200
     5.135   134.320     0.200
     5.299   138.281     0.200
     5.313   138.297     0.200
     5.313   141.789     0.200
     5.382   140.766     0.200
     5.491   142.336     0.200
     5.496   143.641     0.200
     5.496   144.102     0.200
     5.555   146.117     0.200
     5.629   145.711     0.200
     5.612   150.656     0.200
     5.806   150.867     0.200
     5.838   152.945     0.200
     5.942   155.469     0.200
     6.295   163.602     0.200
     2.133    61.703     0.200
     2.342    67.084     0.200
     2.774    78.748     0.200
     3.504    93.225     0.200
     3.504    93.615     0.200
     3.672    97.607     0.200
     3.798   102.033     0.200
     3.798   102.793     0.200
     3.945   105.256     0.200
     3.945   106.107     0.200
     4.014   106.803     0.200
     4.014   108.453     0.200
     4.017   107.168     0.200
     4.017   106.363     0.200
     4.152   110.912     0.200
     5.079   132.619     0.200
     5.079   131.992     0.200
     5.079   132.314     0.200
     5.163   133.932     0.200
     5.163   134.295     0.200
     5.192   133.086     0.200
     5.526   140.982     0.200
     5.526   143.105     0.200
     5.553   144.307     0.200
     5.553   143.535     0.200
     5.587   142.572     0.200
     5.587   143.035     0.200
     5.581   144.316     0.200
     5.731   149.633     0.200
     5.778   148.086     0.200
     5.798   148.986     0.200
     5.940   155.162     0.200
     6.026   154.625     0.200
     6.107   156.500     0.200
     6.107   156.629     0.200
     6.264   159.387     0.200
     6.264   159.545     0.200
     6.398   163.441     0.200
     6.398   164.236     0.200
     6.397   164.176     0.200
     6.576   166.617     0.200
     6.810   172.875     0.200
     6.841   173.496     0.200
     7.170   182.246     0.200
     7.170   183.137     0.200
     7.245   182.236     0.200
     7.252   183.195     0.200
     7.772   196.977     0.200
     7.783   197.465     0.200
     8.175   205.086     0.200
     8.378   211.865     0.200
     8.647   216.766     0.200
     8.759   219.766     0.200
     9.136   226.256     0.200
     9.439   234.535     0.200
     1.170    41.218     0.200
     1.513    47.276     0.200
     1.759    52.822     0.200
     1.759    53.064     0.200
     2.147    63.947     0.200
     2.569    73.988     0.200
     2.733    77.220     0.200
     3.554   100.020     0.200
     3.539    97.191     0.200
     4.789   123.125     0.200
     4.789   123.585     0.200
     4.861   125.165     0.200
     4.942   127.392     0.200
     5.064   131.125     0.200
     5.089   131.135     0.200
     5.133   133.054     0.200
     5.133   131.391     0.200
     5.129   132.365     0.200
     5.175   132.755     0.200
     5.208   139.835     0.200
     5.263   136.500     0.200
     5.263   135.790     0.200
     5.362   137.354     0.200
     5.407   139.872     0.200
     5.407   138.545     0.200
     5.425   139.135     0.200
     5.478   140.035     0.200
     5.667   144.354     0.200
     5.964   152.223     0.200
     5.989   152.835     0.200
     6.085   154.465     0.200
     6.192   157.415     0.200
     6.687   168.185     0.200
     7.028   177.715     0.200
     7.102   179.135     0.200
     7.656   193.915     0.200
     8.324   210.685     0.200
     1.779    53.206     0.200
     2.406    70.667     0.200
     2.585    75.396     0.200
     5.188   135.916     0.200
     5.214   135.746     0.200
     5.601   145.286     0.200
     5.826   151.296     0.200
     6.283   161.966     0.200
     1.181    42.078     0.200
     1.400    46.281     0.200
     1.770    55.219     0.200
     2.018    62.207     0.200
     2.056    62.312     0.200
     2.790    80.270     0.200
     5.353   137.984     0.200
     5.451   141.484     0.200
     5.748   149.082     0.200
     5.874   151.922     0.200
     5.992   155.625     0.200
     6.072   156.812     0.200
     6.227   160.973     0.200
     6.596   170.262     0.200
     6.669   171.715     0.200
     1.163    39.418     0.200
     2.114    61.961     0.200
     2.401    68.736     0.200
     2.401    68.535     0.200
     2.722    73.988     0.200
     2.722    74.242     0.200
     2.978    83.818     0.200
     3.405    96.105     0.200
     3.757    99.966     0.200
     3.675   103.230     0.200
     3.708   104.057     0.200
     3.790   100.224     0.200
     3.805   100.217     0.200
     3.716    99.966     0.200
     3.882   104.792     0.200
     3.882   104.580     0.200
     4.006   106.780     0.200
     4.006   106.911     0.200
     4.011   109.365     0.200
     4.118   109.664     0.200
     4.121   106.922     0.200
     4.121   107.624     0.200
     4.145   109.477     0.200
     4.145   109.024     0.200
     4.237   109.477     0.200
     4.237   111.224     0.200
     4.374   114.334     0.200
     4.387   115.174     0.200
     4.621   120.344     0.200
     4.778   124.382     0.200
     4.774   126.146     0.200
     4.880   126.494     0.200
     5.003   130.604     0.200
     5.040   130.486     0.200
     5.040   131.684     0.200
     5.432   141.224     0.200
     5.394   139.039     0.200
     5.439   140.489     0.200
     5.888   151.704     0.200
     0.773    28.562     0.200
     0.901    32.174     0.200
     1.788    52.064     0.200
     2.822    76.968     0.200
     4.384   112.575     0.200
     4.453   114.035     0.200
     4.499   114.169     0.200
     4.738   117.670     0.200
     4.769   121.854     0.200
     4.888   122.010     0.200
     4.997   125.745     0.200
     5.554   138.736     0.200
     5.781   144.595     0.200
     6.139   154.234     0.200
     6.277   155.995     0.200
     6.275   154.216     0.200
     6.296   156.330     0.200
     1.158    39.729     0.200
     1.307    40.877     0.200
     1.385    43.455     0.200
     2.224    65.680     0.200
     2.224    65.410     0.200
     2.316    68.045     0.200
     2.410    69.664     0.200
     3.459    95.576     0.200
     4.177   110.111     0.200
     4.531   121.145     0.200
     5.484   140.838     0.200
     5.529   142.727     0.200
     5.545   142.336     0.200
     5.691   146.168     0.200
     5.691   146.533     0.200
     5.755   147.488     0.200
     5.800   147.305     0.200
     6.015   152.982     0.200
     6.015   153.328     0.200
     6.050   154.508     0.200
     6.292   159.998     0.200
     6.567   166.186     0.200
     6.708   171.668     0.200
     6.805   172.857     0.200
     2.132    65.582     0.200
     3.516   100.340     0.200
     3.784   107.672     0.200
     5.957   154.281     0.200
     6.055   156.801     0.200
     6.136   157.590     0.200
     6.231   161.309     0.200
     6.352   163.641     0.200
     6.473   166.859     0.200
     6.595   169.910     0.200
     6.674   170.031     0.200
     6.829   175.750     0.200
     7.201   184.121     0.200
     7.273   186.262     0.200
     7.736   191.250     0.200
     7.938   203.332     0.200
     7.955   203.621     0.200
     8.259   210.199     0.200
     9.624   243.340     0.200
     1.225    41.591     0.200
     2.231    64.618     0.200
     6.060   154.841     0.200
     6.142   157.031     0.200
     6.290   162.121     0.200
     6.336   163.981     0.200
     6.371   162.791     0.200
     6.450   164.431     0.200
     6.609   168.141     0.200
     6.698   170.911     0.200
     6.708   171.001     0.200
     6.764   172.391     0.200
     6.937   175.991     0.200
     7.056   179.251     0.200
     7.277   184.251     0.200
     7.365   185.471     0.200
     7.490   189.401     0.200
     7.838   196.781     0.200
     7.988   200.051     0.200
     8.061   205.161     0.200
     8.322   209.931     0.200
     8.404   209.931     0.200
     2.688    76.518     0.200
     2.729    77.537     0.200
     3.525    96.658     0.200
     1.012    36.572     0.200
     1.353    45.886     0.200
     1.453    45.936     0.200
     1.352    44.885     0.200
     1.538    47.396     0.200
     1.768    54.882     0.200
     1.898    55.999     0.200
     2.545    73.404     0.200
     3.030    86.537     0.200
     5.381   138.497     0.200
     5.381   139.398     0.200
     5.488   142.099     0.200
     5.537   143.798     0.200
     5.537   145.908     0.200
     5.571   142.694     0.200
     5.638   144.938     0.200
     5.702   146.729     0.200
     5.778   149.086     0.200
     5.778   148.758     0.200
     5.881   152.258     0.200
     6.019   155.038     0.200
     6.010   153.005     0.200
     6.139   156.524     0.200
     6.139   157.948     0.200
     6.198   160.255     0.200
     6.250   160.418     0.200
     6.361   161.958     0.200
     6.700   171.559     0.200
     6.891   176.847     0.200
     7.151   176.519     0.200
     7.417   187.599     0.200
     7.834   197.628     0.200
     1.129    37.621     0.200
     1.492    45.250     0.200
     1.656    50.242     0.200
     2.248    64.574     0.200
     5.585   142.082     0.200
     5.701   144.352     0.200
     5.983   152.863     0.200
     6.377   161.133     0.200
     6.448   162.223     0.200
     6.556   165.391     0.200
     7.342   179.363     0.200
     1.082    36.258     0.200
     1.082    35.883     0.200
     1.191    40.945     0.200
     1.453    44.594     0.200
     2.191    61.805     0.200
     2.397    69.250     0.200
     2.397    66.984     0.200
     2.614    74.016     0.200
     2.614    72.031     0.200
     2.673    74.492     0.200
     3.091    84.414     0.200
     3.434    94.250     0.200
     3.434    93.250     0.200
     3.533    93.008     0.200
     3.533    93.680     0.200
     3.582    94.633     0.200
     3.611    95.336     0.200
     3.610    94.406     0.200
     3.610    95.039     0.200
     3.608   100.625     0.200
     3.812    99.188     0.200
     3.812   100.094     0.200
     3.879   102.430     0.200
     3.892   102.188     0.200
     3.892   102.031     0.200
     3.908   103.117     0.200
     3.908   102.789     0.200
     3.928   102.203     0.200
     3.928   103.180     0.200
     3.987   105.883     0.200
     3.987   104.641     0.200
     4.080   107.258     0.200
     4.080   106.469     0.200
     4.085   109.039     0.200
     4.149   108.539     0.200
     4.160   107.688     0.200
     4.160   108.969     0.200
     4.186   109.391     0.200
     4.406   115.398     0.200
     4.533   118.844     0.200
     4.632   121.008     0.200
     4.632   119.289     0.200
     4.690   121.812     0.200
     4.802   124.664     0.200
     4.787   124.594     0.200
     4.872   126.836     0.200
     4.872   126.727     0.200
     5.246   135.867     0.200
     5.358   137.648     0.200
     5.368   137.656     0.200
     5.371   137.398     0.200
     5.458   141.750     0.200
     5.548   144.539     0.200
     5.561   142.633     0.200
     5.563   142.000     0.200
     5.715   146.109     0.200
     5.772   146.578     0.200
     5.808   147.961     0.200
     5.839   149.344     0.200
     6.231   159.672     0.200
     6.324   160.609     0.200
     6.987   176.523     0.200
     7.126   180.164     0.200
     7.204   181.250     0.200
     7.314   186.008     0.200
     7.723   194.047     0.200
     7.842   196.758     0.200
     9.117   227.070     0.200
     0.870    32.266     0.200
     0.834    29.891     0.200
     0.834    29.180     0.200
     1.087    35.234     0.200
     2.189    60.891     0.200
     3.534    92.469     0.200
     3.534    92.812     0.200
     3.582    93.398     0.200
     3.611    94.422     0.200
     3.611    94.602     0.200
     3.609    94.555     0.200
     3.810    98.586     0.200
     3.810    98.891     0.200
     3.880   101.898     0.200
     3.894   101.805     0.200
     3.894   102.773     0.200
     3.908   101.805     0.200
     3.908   102.148     0.200
     3.929   102.266     0.200
     3.984   104.492     0.200
     3.984   103.883     0.200
     4.079   105.375     0.200
     4.079   106.570     0.200
     4.151   107.719     0.200
     4.160   108.992     0.200
     4.186   108.984     0.200
     4.407   114.242     0.200
     4.534   117.602     0.200
     4.631   119.844     0.200
     4.631   119.727     0.200
     4.691   121.031     0.200
     4.802   124.031     0.200
     4.784   123.273     0.200
     4.872   124.727     0.200
     4.872   125.484     0.200
     5.247   133.969     0.200
     5.357   136.211     0.200
     5.367   136.438     0.200
     5.369   135.773     0.200
     5.549   143.000     0.200
     5.559   140.477     0.200
     5.560   140.102     0.200
     5.715   145.391     0.200
     5.771   147.680     0.200
     5.807   146.961     0.200
     1.444    50.723     0.200
     1.304    47.410     0.200
     1.670    54.246     0.200
     1.931    60.367     0.200
     2.082    64.617     0.200
     2.463    73.570     0.200
     2.888    84.609     0.200
     5.392   140.840     0.200
     5.419   143.309     0.200
     5.676   148.180     0.200
     5.768   149.961     0.200
     5.916   153.879     0.200
     6.058   157.059     0.200
     6.254   160.980     0.200
     1.204    40.588     0.200
     1.342    44.364     0.200
     1.639    49.922     0.200
     1.710    52.005     0.200
     3.021    81.779     0.200
     2.936    84.575     0.200
     4.906   128.042     0.200
     4.926   127.750     0.200
     5.229   135.370     0.200
     5.267   137.830     0.200
     5.479   140.969     0.200
     5.589   144.280     0.200
     5.724   148.342     0.200
     5.901   150.689     0.200
     5.951   152.049     0.200
     6.045   155.809     0.200
     6.104   156.410     0.200
     1.414    48.789     0.200
     1.420    50.543     0.200
     5.324   139.328     0.200
     5.438   141.828     0.200
     5.455   142.879     0.200
     5.528   145.125     0.200
     5.682   148.395     0.200
     5.721   149.090     0.200
     6.111   158.410     0.200
     6.188   160.148     0.200
     6.296   161.859     0.200
     6.644   171.469     0.200
     6.686   172.309     0.200
     7.148   183.867     0.200
     1.166    41.558     0.200
     1.346    45.820     0.200
     1.485    47.370     0.200
     1.775    54.218     0.200
     2.167    64.423     0.200
     2.573    75.145     0.200
     5.196   135.165     0.200
     5.305   138.035     0.200
     5.593   145.136     0.200
     5.963   153.396     0.200
     6.174   159.436     0.200
     6.515   168.016     0.200
     6.964   172.546     0.200
     7.240   184.766     0.200
     1.430    49.467     0.200
     1.622    52.188     0.200
     1.535    50.105     0.200
     1.795    55.766     0.200
     2.592    76.295     0.200
     5.200   136.070     0.200
     5.308   138.529     0.200
     5.355   140.629     0.200
     5.596   146.070     0.200
     5.963   153.059     0.200
     6.179   160.520     0.200
     6.519   169.010     0.200
     6.969   174.119     0.200
     1.305    44.164     0.200
     2.915    83.039     0.200
     3.049    88.285     0.200
     3.347    95.868     0.200
     1.135    39.547     0.200
     1.182    41.496     0.200
     1.257    44.025     0.200
     1.489    45.730     0.200
     2.039    60.246     0.200
     2.941    80.174     0.200
     3.045    87.545     0.200
     3.057    86.865     0.200
     3.135    87.494     0.200
     3.135    87.898     0.200
     3.246    89.412     0.200
     3.246    90.576     0.200
     3.384    96.357     0.200
     3.480    96.404     0.200
     3.921   110.002     0.200
     4.107   112.596     0.200
     4.055   112.549     0.200
     4.475   119.418     0.200
     4.534   120.363     0.200
     4.534   121.477     0.200
     4.867   127.193     0.200
     4.867   126.797     0.200
     4.869   128.264     0.200
     5.160   133.977     0.200
     5.160   134.303     0.200
     5.208   136.123     0.200
     5.274   137.443     0.200
     5.334   139.504     0.200
     5.333   138.764     0.200
     5.333   138.299     0.200
     5.416   140.514     0.200
     5.458   141.943     0.200
     5.535   145.244     0.200
     5.652   146.746     0.200
     5.652   147.357     0.200
     5.706   149.104     0.200
     5.842   151.094     0.200
     5.886   152.104     0.200
     5.975   154.158     0.200
     5.975   154.963     0.200
     5.975   153.764     0.200
     6.417   164.643     0.200
     6.831   172.584     0.200
     0.951    32.644     0.200
     1.062    37.579     0.200
     1.249    40.490     0.200
     1.936    55.091     0.200
     1.998    57.628     0.200
     2.260    65.815     0.200
     2.516    70.616     0.200
     2.548    70.903     0.200
     2.859    78.287     0.200
     2.859    78.094     0.200
     3.121    85.140     0.200
     3.121    82.762     0.200
     3.534    96.245     0.200
     3.858    99.848     0.200
     3.867   107.078     0.200
     3.886   103.110     0.200
     3.899   101.208     0.200
     3.920   101.361     0.200
     3.920   101.900     0.200
     3.924   105.688     0.200
     4.025   103.147     0.200
     4.025   105.744     0.200
     4.153   107.512     0.200
     4.153   109.813     0.200
     4.212   109.588     0.200
     4.228   109.228     0.200
     4.231   111.998     0.200
     4.262   111.408     0.200
     4.364   111.183     0.200
     4.364   111.908     0.200
     4.346   114.388     0.200
     4.481   115.968     0.200
     4.482   115.738     0.200
     4.497   115.298     0.200
     4.728   122.128     0.200
     4.857   124.868     0.200
     4.908   125.569     0.200
     4.908   126.092     0.200
     4.997   127.608     0.200
     5.164   132.414     0.200
     5.164   132.198     0.200
     5.550   140.438     0.200
     5.582   140.142     0.200
     5.638   143.048     0.200
     5.871   151.828     0.200
     6.011   151.598     0.200
     6.049   152.778     0.200
     7.586   188.278     0.200
     1.180    41.242     0.200
     1.282    42.910     0.200
     2.973    81.449     0.200
     4.516   120.523     0.200
     4.565   121.125     0.200
     4.864   124.438     0.200
     4.866   124.438     0.200
     5.173   133.391     0.200
     5.207   132.719     0.200
     6.401   162.070     0.200
     6.426   163.250     0.200
     0.987    33.016     0.200
     2.508    71.129     0.200
     4.540   119.102     0.200
     5.278   136.223     0.200
     5.477   142.227     0.200
     6.053   151.746     0.200
     6.166   154.316     0.200
     6.183   154.934     0.200
     6.269   157.355     0.200
     6.292   159.836     0.200
     6.393   160.680     0.200
     6.450   161.125     0.200
     6.450   161.887     0.200
     6.536   165.105     0.200
     6.689   167.805     0.200
     6.699   166.461     0.200
     6.798   170.023     0.200
     6.828   169.797     0.200
     6.828   172.016     0.200
     6.878   172.465     0.200
     6.918   172.684     0.200
     7.026   175.387     0.200
     7.316   182.793     0.200
     7.576   188.031     0.200
     7.576   188.934     0.200
     7.813   189.344     0.200
     7.876   196.043     0.200
     8.009   199.371     0.200
     8.009   198.984     0.200
     8.105   201.195     0.200
     8.420   208.844     0.200
     8.522   211.023     0.200
     9.082   224.465     0.200
     9.797   242.605     0.200
    10.072   249.664     0.200
     1.412    45.258     0.200
     2.229    66.383     0.200
     2.204    65.594     0.200
     2.520    73.328     0.200
     3.276    91.828     0.200
     3.342    94.953     0.200
     4.590   123.117     0.200
     5.765   150.711     0.200
     2.076    63.934     0.200
     2.941    81.803     0.200
     2.941    83.110     0.200
     3.054    88.829     0.200
     3.217    89.894     0.200
     3.371    93.610     0.200
     3.960   111.907     0.200
     4.082   111.510     0.200
     4.466   120.117     0.200
     4.534   122.544     0.200
     4.534   121.379     0.200
     4.865   128.222     0.200
     4.865   128.598     0.200
     4.891   129.629     0.200
     5.173   137.024     0.200
     5.232   139.179     0.200
     5.365   140.289     0.200
     5.481   144.079     0.200
     5.662   148.380     0.200
     5.662   147.650     0.200
     5.904   153.065     0.200
     5.989   155.762     0.200
     1.201    40.676     0.200
     2.557    73.494     0.200
     2.692    76.822     0.200
     2.692    77.184     0.200
     2.817    80.695     0.200
     2.888    81.512     0.200
     3.543    96.135     0.200
     3.655    96.895     0.200
     4.377   116.922     0.200
     4.899   125.689     0.200
     4.899   126.156     0.200
     4.962   127.438     0.200
     5.002   128.072     0.200
     5.002   129.447     0.200
     5.009   128.711     0.200
     5.009   130.430     0.200
     5.158   132.465     0.200
     5.158   132.818     0.200
     5.158   135.961     0.200
     5.196   134.678     0.200
     5.255   133.357     0.200
     5.255   134.467     0.200
     5.262   135.592     0.200
     5.262   135.822     0.200
     5.281   135.283     0.200
     5.281   135.617     0.200
     5.480   140.162     0.200
     5.480   140.416     0.200
     5.485   140.357     0.200
     5.532   141.357     0.200
     5.574   143.816     0.200
     5.900   151.557     0.200
     5.998   155.010     0.200
     6.031   153.189     0.200
     6.031   155.012     0.200
     6.082   155.018     0.200
     6.186   157.447     0.200
     6.272   159.596     0.200
     6.272   161.566     0.200
     6.649   168.420     0.200
     6.714   170.553     0.200
     6.758   171.727     0.200
     7.113   180.188     0.200
     7.172   181.297     0.200
     7.180   179.961     0.200
     8.378   209.416     0.200
     9.105   228.059     0.200
     1.585    50.238     0.200
     1.765    54.539     0.200
     1.851    58.135     0.200
     2.419    71.570     0.200
     2.419    70.053     0.200
     2.560    75.703     0.200
     2.561    75.703     0.200
     2.936    84.592     0.200
     2.936    84.266     0.200
     3.011    83.064     0.200
     3.011    84.111     0.200
     3.370    94.461     0.200
     3.370    93.639     0.200
     3.477    99.059     0.200
     3.477    97.186     0.200
     3.590    98.146     0.200
     3.592    99.887     0.200
     4.116   113.943     0.200
     4.560   121.967     0.200
     4.601   124.574     0.200
     4.601   124.188     0.200
     4.697   124.982     0.200
     4.697   125.598     0.200
     4.858   128.408     0.200
     4.858   126.742     0.200
     4.869   128.805     0.200
     4.874   127.664     0.200
     5.194   136.377     0.200
     5.214   136.377     0.200
     5.214   137.305     0.200
     5.317   140.363     0.200
     5.317   142.627     0.200
     5.324   140.375     0.200
     5.465   143.023     0.200
     5.529   144.465     0.200
     5.694   148.586     0.200
     5.848   152.094     0.200
     5.908   152.705     0.200
     6.009   155.912     0.200
     6.009   155.744     0.200
     6.058   156.924     0.200
     6.443   168.225     0.200
     1.377    42.875     0.200
     1.946    55.703     0.200
     5.544   140.750     0.200
     5.558   141.117     0.200
     5.637   143.977     0.200
     5.658   143.398     0.200
     5.835   148.859     0.200
     5.903   150.359     0.200
     6.250   157.711     0.200
     6.296   159.156     0.200
     6.401   161.664     0.200
     6.709   169.367     0.200
     6.757   171.289     0.200
     7.184   175.984     0.200
     6.984   176.336     0.200
     7.522   188.977     0.200
     1.108    38.957     0.200
     1.180    41.578     0.200
     5.335   137.848     0.200
     5.432   139.379     0.200
     5.523   142.121     0.200
     6.054   154.398     0.200
     6.322   161.051     0.200
     7.335   185.668     0.200
     1.125    34.023     0.200
     1.709    46.461     0.200
     2.557    70.523     0.200
     2.670    71.008     0.200
     3.063    83.297     0.200
     3.327    87.195     0.200
     3.327    84.773     0.200
     3.458    88.734     0.200
     3.488    90.250     0.200
     4.030   104.625     0.200
     4.117   103.562     0.200
     4.207   106.453     0.200
     4.345   109.594     0.200
     4.345   109.742     0.200
     4.388   111.172     0.200
     4.378   110.961     0.200
     4.378   110.031     0.200
     4.423   110.953     0.200
     4.509   113.430     0.200
     4.660   118.133     0.200
     4.689   117.781     0.200
     4.689   117.430     0.200
     4.822   120.492     0.200
     4.904   124.031     0.200
     4.904   123.508     0.200
     5.110   127.609     0.200
     5.391   134.227     0.200
     6.238   154.719     0.200
     6.282   155.898     0.200
     2.136    61.948     0.200
     2.957    83.586     0.200
     3.020    84.418     0.200
     4.456   115.729     0.200
     4.487   117.559     0.200
     4.589   119.859     0.200
     4.832   126.119     0.200
     4.978   129.469     0.200
     5.110   132.046     0.200
     5.139   133.259     0.200
     5.316   136.259     0.200
     5.365   137.201     0.200
     5.540   143.029     0.200
     5.662   145.879     0.200
     5.716   145.494     0.200
     6.105   150.799     0.200
     6.411   163.699     0.200
     2.767    80.758     0.200
     4.751   123.930     0.200
     4.751   124.188     0.200
     4.805   125.812     0.200
     4.934   128.258     0.200
     4.934   129.719     0.200
     5.023   130.031     0.200
     5.023   132.414     0.200
     5.078   133.070     0.200
     5.127   134.930     0.200
     5.129   134.008     0.200
     5.293   135.930     0.200
     5.293   136.875     0.200
     5.353   138.984     0.200
     5.380   141.141     0.200
     5.752   148.312     0.200
     5.838   149.891     0.200
     6.936   176.750     0.200
     1.652    49.676     0.200
     1.977    61.020     0.200
     1.977    60.480     0.200
     2.177    62.877     0.200
     2.177    63.209     0.200
     2.367    69.684     0.200
     2.736    80.525     0.200
     2.840    83.092     0.200
     2.840    80.648     0.200
     2.947    84.350     0.200
     2.948    85.566     0.200
     3.606    98.893     0.200
     3.744   101.125     0.200
     3.786   100.359     0.200
     3.769   104.752     0.200
     3.961   104.752     0.200
     3.961   105.729     0.200
     3.961   105.598     0.200
     4.301   114.418     0.200
     4.281   114.238     0.200
     4.281   113.988     0.200
     4.515   120.408     0.200
     4.551   120.848     0.200
     4.935   129.658     0.200
     4.991   131.459     0.200
     4.881   132.805     0.200
     4.881   131.895     0.200
     5.282   138.586     0.200
     5.522   144.338     0.200
     5.952   154.408     0.200
     1.495    43.953     0.200
     1.568    47.352     0.200
     1.755    51.734     0.200
     4.044   105.266     0.200
     4.043   105.172     0.200
     4.384   113.633     0.200
     4.359   114.516     0.200
     5.071   131.391     0.200
     3.170    90.807     0.200
     3.817   107.262     0.200
     0.950    32.891     0.200
     1.081    35.297     0.200
     1.319    39.812     0.200
     2.515    71.508     0.200
     3.602    93.930     0.200
     3.602    96.859     0.200
     3.792   100.398     0.200
     4.496   114.477     0.200
     4.584   117.031     0.200
     4.584   117.688     0.200
     4.727   120.898     0.200
     4.727   120.656     0.200
     4.727   119.875     0.200
     4.805   122.844     0.200
     4.805   122.195     0.200
     4.888   124.242     0.200
     4.888   124.375     0.200
     4.888   123.930     0.200
     5.010   127.047     0.200
     5.010   126.922     0.200
     5.042   128.156     0.200
     5.135   130.367     0.200
     5.135   130.516     0.200
     5.185   130.602     0.200
     5.185   130.891     0.200
     5.195   131.469     0.200
     5.373   135.883     0.200
     5.491   138.492     0.200
     5.725   143.875     0.200
     5.725   144.938     0.200
     5.752   144.305     0.200
     5.752   145.086     0.200
     5.806   146.891     0.200
     5.954   150.570     0.200
     5.954   150.242     0.200
     6.286   159.070     0.200
     6.286   158.789     0.200
     6.466   162.562     0.200
     6.495   163.828     0.200
     6.495   163.312     0.200
     6.495   164.883     0.200
     6.563   163.641     0.200
     6.579   163.867     0.200
     6.777   170.266     0.200
     6.883   172.867     0.200
     0.974    33.911     0.200
     0.997    34.736     0.200
     1.056    37.416     0.200
     1.300    42.151     0.200
     1.457    45.156     0.200
     2.023    59.153     0.200
     2.469    71.085     0.200
     2.701    75.481     0.200
     2.701    74.748     0.200
     2.701    76.527     0.200
     2.890    81.342     0.200
     2.890    80.100     0.200
     3.173    84.812     0.200
     3.235    89.218     0.200
     3.322    89.964     0.200
     3.322    90.320     0.200
     3.546    96.414     0.200
     3.546    96.169     0.200
     3.742   101.019     0.200
     3.742   101.323     0.200
     3.767   102.654     0.200
     3.769   102.535     0.200
     3.793   100.810     0.200
     3.764   101.503     0.200
     4.283   112.741     0.200
     4.399   117.520     0.200
     4.729   125.204     0.200
     4.729   124.963     0.200
     4.836   124.379     0.200
     4.980   127.883     0.200
     4.980   128.534     0.200
     4.981   127.883     0.200
     4.981   127.263     0.200
     4.991   126.852     0.200
     4.991   127.390     0.200
     5.330   136.332     0.200
     5.330   135.909     0.200
     5.332   136.332     0.200
     5.357   140.346     0.200
     5.424   138.961     0.200
     5.581   142.267     0.200
     5.537   144.575     0.200
     5.537   144.824     0.200
     5.633   144.047     0.200
     5.837   148.697     0.200
     5.837   149.006     0.200
     6.036   153.643     0.200
     6.146   154.879     0.200
     6.146   155.150     0.200
     6.279   161.594     0.200
     6.575   166.680     0.200
     0.818    29.965     0.200
     0.936    33.480     0.200
     0.872    32.102     0.200
     1.622    48.801     0.200
     1.879    54.723     0.200
     1.882    55.367     0.200
     2.285    64.953     0.200
     2.310    66.859     0.200
     2.503    70.684     0.200
     3.000    82.344     0.200
     3.162    86.281     0.200
     3.448    94.625     0.200
     3.502    97.234     0.200
     3.546    96.512     0.200
     4.636   120.035     0.200
     4.636   119.719     0.200
     4.767   123.223     0.200
     4.767   122.844     0.200
     4.772   122.934     0.200
     4.772   123.289     0.200
     4.780   123.582     0.200
     4.780   123.066     0.200
     5.118   130.805     0.200
     5.118   131.352     0.200
     5.130   130.805     0.200
     5.130   131.941     0.200
     5.196   134.738     0.200
     5.196   135.383     0.200
     5.196   133.711     0.200
     5.348   137.750     0.200
     5.370   137.359     0.200
     5.419   140.152     0.200
     5.419   138.398     0.200
     5.457   143.531     0.200
     5.618   143.621     0.200
     5.640   144.680     0.200
     5.640   144.262     0.200
     5.752   146.801     0.200
     5.944   150.477     0.200
     5.944   150.871     0.200
     5.944   151.668     0.200
     5.973   152.180     0.200
     6.109   156.531     0.200
     6.370   162.590     0.200
     6.373   161.672     0.200
     6.634   168.805     0.200
     6.760   170.594     0.200
     6.800   172.031     0.200
     1.873    56.172     0.200
     4.819   124.367     0.200
     4.831   124.344     0.200
     5.176   133.352     0.200
     5.251   136.305     0.200
     5.264   135.078     0.200
     5.803   148.133     0.200
     1.118    39.107     0.200
     1.245    42.039     0.200
     2.042    60.428     0.200
     2.387    69.646     0.200
     2.420    68.734     0.200
     2.624    74.367     0.200
     2.624    74.055     0.200
     2.896    81.260     0.200
     2.896    80.783     0.200
     3.197    88.188     0.200
     3.292    91.602     0.200
     3.292    90.207     0.200
     3.429    95.199     0.200
     3.429    95.652     0.200
     3.561    96.529     0.200
     3.590    96.689     0.200
     3.591   100.445     0.200
     3.840   101.193     0.200
     3.840   101.926     0.200
     3.840   102.824     0.200
     3.889   101.967     0.200
     3.889   101.346     0.200
     3.907   103.893     0.200
     3.907   103.719     0.200
     3.918   101.881     0.200
     3.918   102.826     0.200
     3.862   104.096     0.200
     4.079   108.688     0.200
     4.183   110.768     0.200
     4.193   108.988     0.200
     4.193   111.557     0.200
     4.193   112.020     0.200
     4.193   110.018     0.200
     4.215   109.287     0.200
     4.215   110.938     0.200
     4.215   111.115     0.200
     4.231   112.268     0.200
     4.231   112.738     0.200
     4.225   111.236     0.200
     4.225   112.031     0.200
     4.255   113.125     0.200
     4.380   112.498     0.200
     4.380   112.656     0.200
     4.454   117.477     0.200
     4.454   117.146     0.200
     4.467   114.787     0.200
     4.467   117.756     0.200
     4.467   116.701     0.200
     4.493   119.076     0.200
     4.713   124.367     0.200
     4.929   126.568     0.200
     4.929   126.873     0.200
     5.004   130.592     0.200
     5.109   131.826     0.200
     5.175   132.518     0.200
     5.175   132.346     0.200
     5.175   132.973     0.200
     5.552   141.857     0.200
     5.552   141.553     0.200
     5.612   143.318     0.200
     5.598   145.061     0.200
     5.636   144.354     0.200
     5.657   143.867     0.200
     5.793   147.281     0.200
     5.793   148.283     0.200
     5.795   149.396     0.200
     5.855   150.502     0.200
     5.855   150.996     0.200
     5.855   149.361     0.200
     6.019   153.018     0.200
     6.088   154.824     0.200
     7.323   183.615     0.200
     8.008   200.758     0.200
     8.008   202.469     0.200
     1.825    56.270     0.200
     1.934    59.266     0.200
     2.073    61.504     0.200
     2.348    69.871     0.200
     2.808    81.348     0.200
     5.543   142.395     0.200
     5.543   142.551     0.200
     5.633   145.246     0.200
     5.667   146.617     0.200
     5.667   147.562     0.200
     5.826   148.945     0.200
     5.826   149.293     0.200
     6.065   154.656     0.200
     6.122   156.973     0.200
     6.215   157.395     0.200
     6.293   159.395     0.200
     6.401   162.508     0.200
     6.327   163.023     0.200
     6.790   172.332     0.200
     6.958   175.617     0.200
     7.188   177.355     0.200
     7.126   181.992     0.200
     7.253   183.535     0.200
     7.490   189.406     0.200
     1.224    39.915     0.200
     1.278    41.424     0.200
     1.816    53.943     0.200
     1.898    56.575     0.200
     2.465    68.683     0.200
     2.765    77.730     0.200
     3.053    83.915     0.200
     3.179    86.771     0.200
     3.941   104.437     0.200
     4.078   105.574     0.200
     4.096   106.314     0.200
     4.478   115.794     0.200
     4.684   120.374     0.200
     4.727   121.635     0.200
     5.066   129.494     0.200
     5.288   136.015     0.200
     5.702   146.154     0.200
     5.734   145.135     0.200
     1.048    37.365     0.200
     1.133    38.348     0.200
     1.882    55.496     0.200
     2.167    63.014     0.200
     2.593    74.303     0.200
     2.770    79.588     0.200
     3.468    96.279     0.200
     3.638    98.629     0.200
     4.377   114.680     0.200
     5.225   134.834     0.200
     5.225   133.367     0.200
     5.325   136.783     0.200
     5.325   136.574     0.200
     5.512   141.379     0.200
     5.401   139.270     0.200
     5.407   139.613     0.200
     5.407   138.756     0.200
     5.471   140.684     0.200
     5.500   142.564     0.200
     5.500   141.836     0.200
     5.620   142.650     0.200
     5.512   143.760     0.200
     5.620   144.404     0.200
     5.620   143.889     0.200
     5.798   147.736     0.200
     5.742   147.623     0.200
     5.742   148.508     0.200
     5.798   148.123     0.200
     5.956   150.914     0.200
     5.864   150.154     0.200
     5.864   150.049     0.200
     5.975   153.033     0.200
     5.955   152.664     0.200
     5.956   152.453     0.200
     5.975   153.512     0.200
     6.211   157.754     0.200
     6.526   164.900     0.200
     6.526   166.730     0.200
     6.542   167.193     0.200
     6.716   171.354     0.200
     6.716   171.990     0.200
     7.004   172.334     0.200
     6.758   171.605     0.200
     7.236   183.264     0.200
     7.352   185.977     0.200
     7.361   185.207     0.200
     7.531   190.514     0.200
     7.546   190.467     0.200
     7.652   193.324     0.200
     7.771   197.525     0.200
     8.914   224.473     0.200
     8.914   223.830     0.200
     1.298    45.578     0.200
     1.870    58.657     0.200
     2.356    72.212     0.200
     2.609    78.165     0.200
     2.602    78.479     0.200
     2.691    79.113     0.200
     2.684    77.892     0.200
     2.691    79.370     0.200
     2.907    83.635     0.200
     3.080    88.516     0.200
     3.058    86.262     0.200
     3.588   101.962     0.200
     4.023   111.575     0.200
     4.023   107.583     0.200
     4.267   116.824     0.200
     4.267   116.100     0.200
     4.447   120.934     0.200
     4.605   125.746     0.200
     5.150   137.807     0.200
     5.559   147.770     0.200
     5.512   146.337     0.200
     5.697   150.273     0.200
     5.697   148.998     0.200
     5.811   152.083     0.200
     5.811   152.463     0.200
     5.829   151.231     0.200
     5.829   151.358     0.200
     5.832   150.635     0.200
     6.168   159.274     0.200
     6.168   159.973     0.200
     6.196   161.015     0.200
     6.185   162.033     0.200
     6.192   160.453     0.200
     6.213   163.200     0.200
     6.213   162.047     0.200
     6.213   162.663     0.200
     6.192   158.728     0.200
     6.238   161.449     0.200
     6.238   161.553     0.200
     6.406   167.373     0.200
     6.420   165.383     0.200
     6.453   166.562     0.200
     6.453   168.483     0.200
     6.669   172.823     0.200
     6.699   173.888     0.200
     6.801   175.153     0.200
     7.006   182.105     0.200
     7.006   178.713     0.200
     7.030   180.973     0.200
     7.431   190.366     0.200
     7.432   190.793     0.200
     7.862   200.063     0.200
     1.100    38.439     0.200
     1.337    46.396     0.200
     1.340    46.750     0.200
     1.685    52.793     0.200
     2.026    59.699     0.200
     2.276    66.141     0.200
     2.411    70.398     0.200
     2.562    72.354     0.200
     2.843    80.078     0.200
     2.924    82.580     0.200
     3.037    86.994     0.200
     3.108    88.318     0.200
     3.187    91.408     0.200
     3.505    97.783     0.200
     3.557    98.766     0.200
     3.813   106.711     0.200
     4.193   113.699     0.200
     4.429   119.217     0.200
     4.332   120.340     0.200
     4.534   124.354     0.200
     4.665   124.367     0.200
     4.913   129.297     0.200
     4.959   130.475     0.200
     4.959   130.049     0.200
     4.858   131.799     0.200
     4.983   132.068     0.200
     5.165   135.498     0.200
     5.301   139.082     0.200
     5.301   138.578     0.200
     5.478   142.023     0.200
     5.478   144.238     0.200
     5.496   142.686     0.200
     5.496   141.688     0.200
     5.627   146.586     0.200
     5.666   148.119     0.200
     5.794   151.549     0.200
     5.931   154.449     0.200
     5.977   154.539     0.200
     6.098   157.908     0.200
     6.351   164.148     0.200
     6.264   164.684     0.200
     6.441   166.008     0.200
     6.441   166.258     0.200
     6.735   172.607     0.200
     6.830   176.068     0.200
     1.125    38.548     0.200
     1.411    42.082     0.200
     2.222    61.590     0.200
     2.698    74.116     0.200
     2.698    73.647     0.200
     3.170    86.257     0.200
     3.201    86.884     0.200
     3.946   109.738     0.200
     3.964   110.089     0.200
     3.995   106.053     0.200
     4.108   113.046     0.200
     4.282   114.173     0.200
     4.282   112.474     0.200
     4.508   115.796     0.200
     4.519   116.150     0.200
     4.519   115.570     0.200
     4.519   116.814     0.200
     4.524   116.339     0.200
     4.524   117.194     0.200
     4.849   124.529     0.200
     4.849   125.874     0.200
     4.863   124.751     0.200
     4.863   125.974     0.200
     4.970   128.054     0.200
     4.975   126.361     0.200
     4.975   129.024     0.200
     5.353   138.461     0.200
     5.353   136.481     0.200
     5.663   143.921     0.200
     5.663   144.895     0.200
     5.663   144.574     0.200
     5.708   147.154     0.200
     6.096   156.614     0.200
     1.990    56.773     0.200
     3.473    89.462     0.200
     3.509    90.112     0.200
     3.840    98.282     0.200
     3.967   101.393     0.200
     4.092   103.853     0.200
     4.470   114.312     0.200
     4.602   117.103     0.200
     4.723   119.802     0.200
     4.767   121.912     0.200
     5.154   130.652     0.200
     0.825    28.648     0.200
     2.042    58.125     0.200
     2.671    72.969     0.200
     2.873    79.336     0.200
     3.041    82.477     0.200
     2.938    82.352     0.200
     1.731    52.812     0.200
     1.968    58.641     0.200
     2.500    69.852     0.200
     3.458    95.781     0.200
     3.568    96.641     0.200
     3.910   104.836     0.200
     4.827   123.477     0.200
     4.888   125.328     0.200
     5.072   129.844     0.200
     5.175   133.750     0.200
     5.188   133.227     0.200
     5.400   137.039     0.200
     5.460   139.953     0.200
     5.828   148.773     0.200
     5.950   150.602     0.200
     6.194   157.586     0.200
     0.826    30.359     0.200
     2.469    69.352     0.200
     2.594    69.686     0.200
     3.579    91.980     0.200
     3.596    93.166     0.200
     3.606    93.504     0.200
     3.644    97.211     0.200
     3.788    96.229     0.200
     3.907   101.174     0.200
     3.957   101.320     0.200
     4.047   104.418     0.200
     4.159   105.982     0.200
     4.619   116.686     0.200
     4.754   120.584     0.200
     5.240   132.537     0.200
     0.961    32.430     0.200
     3.139    85.969     0.200
     4.126   105.961     0.200
     4.183   107.172     0.200
     4.183   106.844     0.200
     4.227   106.875     0.200
     4.227   108.336     0.200
     4.449   112.578     0.200
     4.449   114.789     0.200
     4.409   110.570     0.200
     4.409   111.734     0.200
     4.497   115.875     0.200
     4.505   113.477     0.200
     4.505   115.336     0.200
     4.552   115.875     0.200
     4.552   116.078     0.200
     4.697   118.375     0.200
     4.725   119.883     0.200
     5.250   131.875     0.200
     5.250   132.656     0.200
     5.324   136.234     0.200
     5.488   136.977     0.200
     5.488   139.602     0.200
     5.857   146.711     0.200
     5.940   148.477     0.200
     5.967   148.820     0.200
     1.552    45.666     0.200
     2.288    63.258     0.200
     2.288    64.520     0.200
     2.658    74.076     0.200
     2.829    78.018     0.200
     2.895    80.127     0.200
     3.679   101.674     0.200
     3.873   101.797     0.200
     4.092   104.908     0.200
     4.092   104.996     0.200
     4.557   119.203     0.200
     4.683   119.920     0.200
     4.916   125.709     0.200
     5.122   131.184     0.200
     1.323    45.357     0.200
     1.445    46.072     0.200
     3.109    88.556     0.200
     3.618   103.038     0.200
     5.350   138.242     0.200
     5.433   142.327     0.200
     5.900   153.039     0.200
     6.569   170.069     0.200
     0.950    33.492     0.200
     1.290    42.664     0.200
     1.567    47.391     0.200
     1.912    56.266     0.200
     2.969    84.523     0.200
     3.500    95.188     0.200
     3.794   100.102     0.200
     3.794   101.164     0.200
     3.841   101.117     0.200
     3.841   102.195     0.200
     4.313   111.445     0.200
     4.313   111.773     0.200
     4.428   114.070     0.200
     4.458   116.305     0.200
     4.458   115.070     0.200
     4.502   116.547     0.200
     4.520   116.906     0.200
     4.520   117.789     0.200
     4.515   118.688     0.200
     4.559   116.352     0.200
     4.693   120.961     0.200
     4.693   120.633     0.200
     4.711   122.375     0.200
     4.711   121.789     0.200
     4.803   123.812     0.200
     4.865   127.438     0.200
     4.877   126.758     0.200
     5.113   131.484     0.200
     5.346   136.344     0.200
     5.346   136.016     0.200
     5.526   142.859     0.200
     5.690   143.633     0.200
     5.848   149.117     0.200
     6.138   156.180     0.200
     6.182   155.914     0.200
     6.273   158.797     0.200
     6.623   165.742     0.200
     6.713   168.125     0.200
     6.925   173.492     0.200
     6.997   177.172     0.200
     7.809   194.750     0.200
     8.543   212.992     0.200
     4.539   123.998     0.200
     4.780   126.846     0.200
     4.910   129.434     0.200
     5.126   133.057     0.200
     5.202   136.939     0.200
     5.307   137.715     0.200
     5.411   139.527     0.200
     5.468   146.516     0.200
     5.527   143.928     0.200
     5.530   143.150     0.200
     5.639   147.551     0.200
     5.639   145.227     0.200
     5.791   149.199     0.200
     6.076   158.162     0.200
     6.146   157.127     0.200
     6.379   163.326     0.200
     6.364   165.205     0.200
     6.684   167.480     0.200
     6.766   170.068     0.200
     6.791   173.434     0.200
     6.944   174.467     0.200
     6.952   176.539     0.200
     6.996   174.467     0.200
     7.097   184.303     0.200
     7.170   181.227     0.200
     7.240   185.080     0.200
     7.357   187.408     0.200
     7.531   188.186     0.200
     7.636   190.514     0.200
     7.692   194.137     0.200
     7.744   194.656     0.200
     7.941   199.832     0.200
     7.941   200.566     0.200
     7.942   199.314     0.200
     8.084   205.525     0.200
     8.465   212.773     0.200
     8.457   218.547     0.200
     8.830   220.537     0.200
     8.873   220.279     0.200
     9.028   225.197     0.200
     9.110   228.561     0.200
     9.193   231.926     0.200
     9.250   229.297     0.200
     9.420   235.289     0.200
     9.454   236.842     0.200
     9.503   236.584     0.200
     9.529   238.914     0.200
     9.502   243.055     0.200
     9.543   238.914     0.200
     9.592   240.727     0.200
     9.619   239.689     0.200
     9.645   239.689     0.200
     9.673   242.020     0.200
     9.676   241.242     0.200
     9.733   243.572     0.200
     2.911    82.271     0.200
     3.058    85.881     0.200
     3.588    95.758     0.200
     3.802   101.010     0.200
     3.802   103.980     0.200
     3.933   103.992     0.200
     4.002   107.115     0.200
     4.079   107.824     0.200
     4.142   112.111     0.200
     4.189   110.096     0.200
     4.189   111.020     0.200
     4.282   111.799     0.200
     4.438   117.891     0.200
     4.455   116.057     0.200
     4.455   117.000     0.200
     4.680   122.391     0.200
     4.801   125.320     0.200
     4.801   126.580     0.200
     5.019   130.395     0.200
     5.102   133.641     0.200
     5.229   134.654     0.200
     5.229   135.791     0.200
     5.572   144.721     0.200
     5.736   148.230     0.200
     1.806    52.857     0.200
     1.913    56.793     0.200
     2.739    78.842     0.200
     2.739    75.975     0.200
     2.866    80.367     0.200
     3.272    91.633     0.200
     3.272    90.172     0.200
     3.295    88.338     0.200
     3.410    91.166     0.200
     3.641    96.617     0.200
     3.744    99.881     0.200
     3.747   101.053     0.200
     3.747   100.639     0.200
     3.902   104.949     0.200
     3.902   104.277     0.200
     4.142   108.451     0.200
     4.160   112.627     0.200
     4.160   111.098     0.200
     4.269   112.350     0.200
     4.270   114.365     0.200
     4.672   120.508     0.200
     4.672   121.658     0.200
     4.731   122.979     0.200
     4.731   122.074     0.200
     4.731   122.498     0.200
     4.765   124.666     0.200
     4.765   122.783     0.200
     4.767   124.260     0.200
     4.767   123.227     0.200
     4.910   127.574     0.200
     4.910   126.629     0.200
     4.930   129.549     0.200
     4.985   129.145     0.200
     4.985   128.412     0.200
     4.985   129.818     0.200
     4.994   130.299     0.200
     5.017   131.238     0.200
     5.017   130.451     0.200
     5.038   129.697     0.200
     5.052   131.471     0.200
     5.052   129.955     0.200
     5.052   132.389     0.200
     5.238   133.049     0.200
     5.238   134.799     0.200
     5.267   136.646     0.200
     5.303   137.752     0.200
     5.303   135.799     0.200
     5.341   138.059     0.200
     5.548   143.889     0.200
     5.673   144.787     0.200
     5.673   147.338     0.200
     5.758   149.615     0.200
     5.787   149.035     0.200
     5.787   147.045     0.200
     5.847   150.027     0.200
     5.847   150.479     0.200
     5.953   153.719     0.200
     6.032   154.561     0.200
     6.032   153.334     0.200
     6.032   154.008     0.200
     6.199   162.281     0.200
     6.404   163.342     0.200
     6.404   164.248     0.200
     6.405   162.410     0.200
     6.466   164.389     0.200
     6.515   165.707     0.200
     6.570   165.967     0.200
     6.686   171.020     0.200
     6.686   169.857     0.200
     6.686   171.357     0.200
     6.874   174.549     0.200
     6.928   175.338     0.200
     6.932   174.740     0.200
     7.390   186.338     0.200
     7.479   189.568     0.200
     7.510   189.514     0.200
     8.032   204.461     0.200
     8.131   204.229     0.200
     8.131   204.928     0.200
     8.357   210.408     0.200
     8.723   217.148     0.200
     8.858   221.344     0.200
     2.538    69.842     0.200
     2.538    68.291     0.200
     2.748    74.814     0.200
     2.748    72.699     0.200
     2.987    79.254     0.200
     2.987    78.926     0.200
     3.127    84.037     0.200
     3.127    81.100     0.200
     3.250    84.555     0.200
     3.353    89.836     0.200
     3.605    91.451     0.200
     3.741   101.766     0.200
     4.048   102.602     0.200
     4.081   106.416     0.200
     4.081   104.029     0.200
     4.125   105.195     0.200
     4.125   104.920     0.200
     4.140   106.471     0.200
     4.147   105.559     0.200
     4.147   104.936     0.200
     4.146   105.160     0.200
     4.146   103.713     0.200
     4.146   105.586     0.200
     4.482   113.275     0.200
     4.482   113.557     0.200
     4.482   113.816     0.200
     4.504   115.057     0.200
     4.538   114.637     0.200
     4.538   114.025     0.200
     4.542   115.686     0.200
     4.559   116.756     0.200
     4.724   119.727     0.200
     4.734   119.127     0.200
     4.771   120.549     0.200
     4.771   121.256     0.200
     4.982   126.256     0.200
     5.063   127.859     0.200
     5.063   127.283     0.200
     5.115   128.986     0.200
     5.213   131.232     0.200
     5.213   131.367     0.200
     5.291   134.975     0.200
     5.348   134.020     0.200
     5.348   133.418     0.200
     5.348   134.926     0.200
     5.348   135.387     0.200
     5.759   144.395     0.200
     5.796   145.807     0.200
     6.124   153.973     0.200
     6.201   155.996     0.200
     7.612   189.105     0.200
     1.822    54.043     0.200
     2.734    76.137     0.200
     3.511    92.379     0.200
     3.511    93.367     0.200
     3.388    92.750     0.200
     3.579    93.723     0.200
     3.579    94.496     0.200
     3.627    96.301     0.200
     3.681    95.742     0.200
     3.819   101.477     0.200
     3.959   103.617     0.200
     4.100   105.938     0.200
     4.146   108.578     0.200
     4.146   109.785     0.200
     4.137   108.188     0.200
     4.174   109.109     0.200
     4.389   114.965     0.200
     4.512   118.535     0.200
     4.700   121.516     0.200
     4.803   125.375     0.200
     4.916   125.328     0.200
     4.916   127.258     0.200
     5.267   135.922     0.200
     5.267   136.207     0.200
     5.510   140.195     0.200
     5.551   139.902     0.200
     5.748   147.105     0.200
     6.269   160.578     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.146    69.992     0.200
     0.614    22.328     0.200
     2.016    64.328     0.200
     1.828    56.919     0.200
     2.357    76.419     0.200
     0.189     9.121     0.200
     1.506    49.121     0.200
     3.206    92.121     0.200
     4.058   118.121     0.200
     5.042   146.621     0.200
     7.300   215.223     0.200
     0.603    23.215     0.200
     1.183    31.715     0.200
     1.183    35.215     0.200
     1.569    50.215     0.200
     1.801    58.715     0.200
     2.598    78.215     0.200
     7.009   209.215     0.200
     0.609    21.047     0.200
     1.205    35.547     0.200
     4.572   133.746     0.200
     7.010   208.547     0.200
     1.604    53.820     0.200
     1.940    61.820     0.200
     4.599   134.820     0.200
     0.149     9.188     0.200
     0.701    23.688     0.200
     1.839    56.188     0.200
     0.827    29.207     0.200
     0.998    33.105     0.200
     0.764    25.414     0.200
     0.899    30.914     0.200
     1.054    36.215     0.200
     0.523    17.849     0.200
     1.198    39.349     0.200
     1.557    48.849     0.200
     1.704    52.849     0.200
     1.660    52.349     0.200
     1.879    59.349     0.200
     1.917    59.949     0.200
     1.867    58.349     0.200
     2.434    73.349     0.200
     0.646    22.594     0.200
     0.746    26.594     0.200
     0.943    30.594     0.200
     1.486    46.094     0.200
     1.642    51.094     0.200
     0.215     7.867     0.200
     0.274    10.367     0.200
     0.274    10.867     0.200
     0.274    11.867     0.200
     0.826    29.367     0.200
     1.138    37.867     0.200
     1.644    51.867     0.200
     1.738    54.367     0.200
     2.046    62.867     0.200
     2.950    88.867     0.200
     0.645    22.664     0.200
     0.956    30.664     0.200
     1.297    42.164     0.200
     1.652    52.164     0.200
     1.875    56.664     0.200
     0.220     9.018     0.200
     0.658    23.518     0.200
     0.792    27.317     0.200
     1.921    59.218     0.200
     2.110    63.518     0.200
     2.329    69.018     0.200
     0.756    26.453     0.200
     1.890    60.453     0.200
     2.010    64.453     0.200
     2.010    65.453     0.200
     2.010    66.453     0.200
     0.700    23.852     0.200
     1.693    53.852     0.200
     2.472    75.852     0.200
     0.783    27.291     0.200
     0.783    28.291     0.200
     1.799    55.791     0.200
     2.683    80.791     0.200
     0.906    30.537     0.200
     2.317    69.537     0.200
     0.667    23.947     0.200
     0.456    17.055     0.200
     2.064    62.070     0.200
     0.750    25.761     0.200
     1.359    43.762     0.200
     1.247    39.129     0.200
     5.071   145.398     0.200
     0.577    20.922     0.200
     0.610    21.182     0.200
     1.414    44.898     0.200
     1.374    45.023     0.200
     1.378    44.979     0.200
     1.549    49.678     0.200
     1.153    39.633     0.200
     1.243    41.633     0.200
     2.103    65.633     0.200
     2.301    71.633     0.200
     0.167     8.156     0.200
     1.262    37.656     0.200
     1.666    52.656     0.200
     1.801    57.156     0.200
     1.979    61.449     0.200
     1.984    61.457     0.200
     1.990    59.836     0.200
     2.368    71.156     0.200
     3.111    91.578     0.200
     3.355    96.566     0.200
     1.599    50.383     0.200
     1.920    59.845     0.200
     1.930    58.553     0.200
     1.852    58.383     0.200
     2.421    73.383     0.200
     0.424    15.117     0.200
     1.087    38.117     0.200
     1.792    59.117     0.200
     0.140     6.266     0.200
     0.461    16.266     0.200
     1.047    35.266     0.200
     1.508    51.266     0.200
     0.130     7.473     0.200
     0.390    14.473     0.200
     1.055    35.473     0.200
     1.214    39.473     0.200
     1.880    60.973     0.200
     0.798    27.367     0.200
     1.110    38.367     0.200
     1.748    57.367     0.200
     2.419    75.367     0.200
     2.665    81.867     0.200
     2.592    77.367     0.200
     0.562    19.609     0.200
     1.713    53.609     0.200
     0.946    32.461     0.200
     1.051    35.461     0.200
     1.402    46.461     0.200
     1.735    53.461     0.200
     1.855    57.461     0.200
     2.064    62.461     0.200
     0.766    27.609     0.200
     0.855    28.609     0.200
     1.155    37.609     0.200
     1.352    43.609     0.200
     1.455    46.609     0.200
     1.656    52.609     0.200
     2.121    63.609     0.200
     0.804    28.898     0.200
     1.049    34.898     0.200
     1.506    49.898     0.200
     2.181    66.898     0.200
     0.842    28.043     0.200
     0.976    31.543     0.200
     1.280    41.543     0.200
     1.757    54.043     0.200
     2.036    61.543     0.200
     0.313    14.535     0.200
     0.815    27.535     0.200
     0.947    31.535     0.200
     1.082    34.535     0.200
     1.263    40.535     0.200
     0.765    26.020     0.200
     0.771    27.520     0.200
     0.996    33.020     0.200
     1.529    48.020     0.200
     0.843    28.875     0.200
     0.926    32.086     0.200
     1.337    44.875     0.200
     1.643    51.875     0.200
     1.966    61.875     0.200
     2.091    63.875     0.200
     2.412    70.875     0.200
     0.104     5.570     0.200
     0.866    31.570     0.200
     1.036    36.570     0.200
     1.918    60.070     0.200
     0.926    32.533     0.200
     1.332    43.322     0.200
     1.625    51.322     0.200
     4.099   122.322     0.200
     4.657   138.322     0.200
     7.055   206.463     0.200
     1.064    34.620     0.200
     2.933    85.800     0.200
     0.212     9.531     0.200
     0.569    20.531     0.200
     1.053    36.531     0.200
     1.485    48.531     0.200
     2.414    71.531     0.200
     0.117     8.320     0.200
     1.987    59.820     0.200
     0.345    11.584     0.200
     0.603    22.584     0.200
     1.008    35.584     0.200
     0.977    32.664     0.200
     0.471    18.867     0.200
     1.088    34.867     0.200
     1.290    39.867     0.200
     1.639    51.805     0.200
     2.254    66.047     0.200
     2.404    71.965     0.200
     2.409    71.969     0.200
     2.417    72.148     0.200
     3.429    97.258     0.200
     0.599    20.692     0.200
     0.599    21.192     0.200
     1.028    37.192     0.200
     1.232    42.692     0.200
     0.148     4.930     0.200
     0.305    11.930     0.200
     0.970    32.930     0.200
     1.284    41.930     0.200
     1.643    52.992     0.200
     1.868    58.930     0.200
     0.775    26.562     0.200
     0.964    31.562     0.200
     1.270    40.562     0.200
     2.327    68.562     0.200
     0.553    18.715     0.200
     0.537    18.715     0.200
     1.181    39.715     0.200
     1.439    46.715     0.200
     1.657    52.715     0.200
     1.807    56.715     0.200
     2.099    65.914     0.200
     0.258    11.734     0.200
     0.757    27.734     0.200
     1.197    37.234     0.200
     1.404    43.734     0.200
     1.633    51.734     0.200
     1.820    56.734     0.200
     1.773    55.734     0.200
     2.010    59.734     0.200
     2.119    63.734     0.200
     0.285    12.467     0.200
     1.537    48.467     0.200
     1.530    50.467     0.200
     1.701    52.467     0.200
     1.600    51.066     0.200
     1.667    53.666     0.200
     1.979    62.467     0.200
     0.286    11.291     0.200
     0.518    18.791     0.200
     1.541    49.791     0.200
     1.553    50.791     0.200
     0.464    17.812     0.200
     0.581    20.812     0.200
     1.087    37.312     0.200
     1.240    42.312     0.200
     1.342    45.312     0.200
     0.250     9.992     0.200
     0.447    16.992     0.200
     0.714    23.992     0.200
     1.247    39.992     0.200
     1.471    46.992     0.200
     0.937    32.605     0.200
     1.336    44.605     0.200
     0.610    19.586     0.200
     0.610    20.586     0.200
     0.554    19.586     0.200
     0.554    20.586     0.200
     1.537    51.586     0.200
     1.630    52.586     0.200
     0.672    25.070     0.200
     0.807    27.070     0.200
     1.020    34.070     0.200
     1.152    37.070     0.200
     1.503    47.070     0.200
     1.642    51.070     0.200
     2.153    64.070     0.200
     0.233     8.617     0.200
     0.368    14.617     0.200
     0.308    12.752     0.200
     0.636    21.752     0.200
     0.917    31.752     0.200
     1.254    40.252     0.200
     0.844    29.508     0.200
     1.427    47.008     0.200
     0.779    27.562     0.200
     0.858    28.562     0.200
     1.045    32.562     0.200
     1.435    46.562     0.200
     1.914    59.562     0.200
     2.233    66.562     0.200
     0.301    10.539     0.200
     0.396    15.539     0.200
     1.135    38.539     0.200
     0.201     8.609     0.200
     0.832    29.609     0.200
     0.695    26.199     0.200
     0.968    33.199     0.200
     0.432    16.525     0.200
     0.862    30.525     0.200
     0.753    24.525     0.200
     1.117    38.525     0.200
     0.289    10.906     0.200
     0.497    18.406     0.200
     1.332    42.906     0.200
     1.534    49.406     0.200
     0.668    23.422     0.200
     0.876    29.422     0.200
     0.967    32.422     0.200
     0.621    22.285     0.200
     0.970    33.285     0.200
     1.663    52.285     0.200
     0.666    24.676     0.200
     1.734    55.676     0.200
     1.996    61.676     0.200
     0.457    16.990     0.200
     0.580    21.990     0.200
     1.545    49.990     0.200
     1.386    44.990     0.200
     0.301    12.289     0.200
     0.518    19.289     0.200
     0.654    23.289     0.200
     1.219    40.289     0.200
     1.193    39.289     0.200
     1.211    40.289     0.200
     0.550    19.113     0.200
     1.100    36.113     0.200
     1.516    48.176     0.200
     1.482    48.113     0.200
     1.294    42.383     0.200
     1.721    54.383     0.200
     1.918    59.383     0.200
     0.276    10.875     0.200
     0.329    11.875     0.200
     1.588    50.875     0.200
     1.774    54.875     0.200
     0.662    24.102     0.200
     1.375    43.102     0.200
     1.671    52.102     0.200
     1.768    56.102     0.200
     2.336    69.602     0.200
     0.103    10.154     0.200
     0.589    21.154     0.200
     1.702    51.154     0.200
     0.459    18.254     0.200
     2.354    71.254     0.200
     0.605    20.867     0.200
     0.640    22.867     0.200
     0.932    30.867     0.200
     0.968    32.867     0.200
     1.017    34.867     0.200
     1.641    51.867     0.200
     0.244    10.727     0.200
     1.359    43.727     0.200
     1.578    48.727     0.200
     0.276    10.104     0.200
     1.664    53.104     0.200
     1.992    62.104     0.200
     1.442    44.875     0.200
     1.446    44.898     0.200
     1.451    44.883     0.200
     1.443    47.500     0.200
     2.275    69.500     0.200
     0.595    22.195     0.200
     1.043    35.195     0.200
     1.169    39.680     0.200
     1.233    41.195     0.200
     1.295    43.195     0.200
     1.995    62.195     0.200
     0.671    22.973     0.200
     0.491    18.648     0.200
     0.556    19.938     0.200
     1.449    47.938     0.200
     0.470    18.528     0.200
     0.784    28.528     0.200
     1.335    42.528     0.200
     0.295    11.422     0.200
     0.535    20.703     0.200
     0.589    21.703     0.200
     0.589    20.703     0.200
     1.348    43.590     0.200
     1.509    47.703     0.200
     1.868    56.703     0.200
     2.144    64.703     0.200
     0.627    22.117     0.200
     0.669    24.117     0.200
     1.169    41.117     0.200
     1.161    40.117     0.200
     1.455    48.117     0.200
     2.000    62.117     0.200
     0.457    16.505     0.200
     0.645    23.505     0.200
     0.789    27.505     0.200
     0.976    32.505     0.200
     0.542    18.830     0.200
     0.915    30.830     0.200
     0.483    17.484     0.200
     0.587    21.484     0.200
     0.336    12.789     0.200
     0.641    21.789     0.200
     1.117    35.789     0.200
     1.293    41.789     0.200
     1.605    49.789     0.200
     1.380    44.584     0.200
     1.820    57.584     0.200
     0.321    11.711     0.200
     1.021    35.711     0.200
     0.253    11.328     0.200
     0.552    19.328     0.200
     0.391    13.887     0.200
     1.783    55.887     0.200
     0.380    13.525     0.200
     1.179    42.426     0.200
     1.797    59.525     0.200
     0.812    28.040     0.200
     0.425    15.298     0.200
     0.633    23.298     0.200
     1.201    38.298     0.200
     1.388    44.198     0.200
     1.683    52.641     0.200
     0.234     8.148     0.200
     1.795    56.852     0.200
     0.083     6.950     0.200
     1.378    44.175     0.200
     1.378    44.850     0.200
     2.213    66.210     0.200
     2.217    66.250     0.200
     2.224    67.551     0.200
     2.224    65.450     0.200
     0.937    31.511     0.200
     1.474    47.641     0.200
     2.065    62.574     0.200
     2.069    62.611     0.200
     1.079    36.312     0.200
     0.523    19.250     0.200
     0.671    24.805     0.200
     1.884    58.891     0.200
     1.884    60.219     0.200
     2.081    65.633     0.200
     0.883    31.508     0.200
     1.504    49.959     0.200
     1.838    58.283     0.200
     1.990    62.289     0.200
     3.107    94.379     0.200
     3.640   105.572     0.200
     0.307    12.227     0.200
     0.451    15.500     0.200
     1.942    59.852     0.200
     2.974    90.555     0.200
     0.336    14.703     0.200
     2.177    64.977     0.200
     2.428    71.766     0.200
     2.487    74.828     0.200
     3.224    92.828     0.200
     3.500   102.000     0.200
     0.254    10.000     0.200
     0.444    16.586     0.200
     0.471    16.828     0.200
     0.582    20.805     0.200
     1.343    43.531     0.200
     1.727    54.445     0.200
     1.847    57.867     0.200
     1.963    60.945     0.200
     2.586    77.250     0.200
     2.676    80.016     0.200
     3.289    95.102     0.200
     3.390    98.680     0.200
     0.234     9.684     0.200
     0.417    15.133     0.200
     0.486    16.988     0.200
     0.594    20.770     0.200
     1.670    54.246     0.200
     1.588    52.023     0.200
     1.992    63.023     0.200
     1.992    62.441     0.200
     1.981    63.125     0.200
     0.479    17.016     0.200
     0.933    31.477     0.200
     1.531    48.105     0.200
     1.525    48.828     0.200
     1.557    49.914     0.200
     1.530    49.914     0.200
     1.684    56.059     0.200
     0.607    20.270     0.200
     2.040    64.811     0.200
     0.587    19.693     0.200
     1.299    42.555     0.200
     1.299    42.180     0.200
     1.839    56.941     0.200
     1.839    60.803     0.200
     0.321    12.902     0.200
     0.584    19.625     0.200
     1.641    52.980     0.200
     2.368    72.648     0.200
     3.518   105.836     0.200
     3.758   111.637     0.200
     0.835    28.047     0.200
     0.754    26.660     0.200
     1.495    45.812     0.200
     1.477    46.977     0.200
     1.388    46.887     0.200
     1.762    56.184     0.200
     1.898    56.488     0.200
     1.898    57.016     0.200
     2.043    62.039     0.200
     2.582    77.453     0.200
     3.589   103.273     0.200
     0.994    34.462     0.200
     1.045    33.953     0.200
     1.291    43.609     0.200
     1.484    51.116     0.200
     1.599    52.926     0.200
     2.052    64.431     0.200
     2.450    75.269     0.200
     0.662    24.539     0.200
     0.661    23.883     0.200
     0.728    27.184     0.200
     0.782    27.504     0.200
     1.110    37.613     0.200
     1.503    48.883     0.200
     1.365    45.945     0.200
     2.167    68.324     0.200
     2.487    77.242     0.200
     2.470    73.742     0.200
     2.683    82.508     0.200
     2.855    86.133     0.200
     3.243    95.027     0.200
     3.408   100.625     0.200
     3.462   100.953     0.200
     1.170    39.547     0.200
     1.509    47.195     0.200
     2.733    81.281     0.200
     2.801    82.328     0.200
     3.262    95.891     0.200
     3.304    95.891     0.200
     3.801   108.758     0.200
     0.352    11.770     0.200
     0.927    30.844     0.200
     1.532    50.910     0.200
     1.630    55.227     0.200
     2.205    68.902     0.200
     2.352    75.664     0.200
     0.084     5.172     0.200
     0.641    22.789     0.200
     1.383    45.438     0.200
     1.815    55.883     0.200
     2.416    74.758     0.200
     2.575    79.586     0.200
     2.599    79.977     0.200
     0.191     7.906     0.200
     1.504    48.305     0.200
     1.634    52.938     0.200
     1.855    58.898     0.200
     1.924    60.555     0.200
     2.053    65.188     0.200
     0.476    17.423     0.200
     0.807    27.404     0.200
     1.050    36.832     0.200
     2.032    62.810     0.200
     2.537    76.893     0.200
     3.136    95.831     0.200
     0.542    20.125     0.200
     0.730    25.344     0.200
     0.819    27.628     0.200
     1.008    33.081     0.200
     1.144    38.852     0.200
     1.536    51.001     0.200
     1.710    54.772     0.200
     1.768    55.900     0.200
     1.779    55.597     0.200
     1.758    56.414     0.200
     2.838    86.951     0.200
     3.566   104.354     0.200
     3.764   113.159     0.200
     0.768    27.111     0.200
     1.403    48.455     0.200
     1.838    58.000     0.200
     2.017    63.438     0.200
     2.556    78.010     0.200
     2.814    85.656     0.200
     3.712   113.070     0.200
     0.504    18.793     0.200
     0.742    26.254     0.200
     1.763    54.148     0.200
     1.841    55.672     0.200
     0.559    20.453     0.200
     0.769    26.941     0.200
     1.074    35.523     0.200
     1.617    50.391     0.200
     1.674    52.160     0.200
     1.895    58.395     0.200
     1.947    57.098     0.200
     2.529    74.871     0.200
     3.283    98.215     0.200
     3.411    99.086     0.200
     5.128   149.730     0.200
     0.589    20.314     0.200
     0.934    32.553     0.200
     2.097    64.652     0.200
     0.354    11.690     0.200
     0.566    19.516     0.200
     1.256    42.172     0.200
     1.750    55.189     0.200
     1.999    62.142     0.200
     2.351    73.229     0.200
     2.444    75.018     0.200
     2.639    80.517     0.200
     2.982    91.656     0.200
     0.111     7.216     0.200
     0.315    12.455     0.200
     0.446    15.982     0.200
     1.168    36.686     0.200
     1.690    53.713     0.200
     2.461    75.978     0.200
     2.601    77.497     0.200
     0.804    27.562     0.200
     1.094    34.922     0.200
     1.220    38.523     0.200
     2.090    63.000     0.200
     1.548    51.430     0.200
     1.691    54.805     0.200
     1.795    57.016     0.200
     0.631    23.156     0.200
     0.993    33.203     0.200
     2.710    79.398     0.200
     2.989    87.406     0.200
     0.669    24.519     0.200
     2.806    85.422     0.200
     3.125    93.936     0.200
     0.334    11.680     0.200
     0.916    31.570     0.200
     0.991    34.859     0.200
     1.807    57.727     0.200
     2.915    86.375     0.200
     0.273    10.512     0.200
     0.898    31.820     0.200
     1.920    61.691     0.200
     0.618    22.115     0.200
     1.251    40.080     0.200
     1.373    43.453     0.200
     1.949    57.680     0.200
     2.174    68.375     0.200
     2.974    90.211     0.200
     3.082    89.381     0.200
     0.339    13.012     0.200
     1.517    49.562     0.200
     1.638    51.047     0.200
     1.904    59.047     0.200
     2.031    65.258     0.200
     2.194    66.492     0.200
     2.287    69.473     0.200
     2.505    73.695     0.200
     2.679    80.348     0.200
     2.738    81.102     0.200
     3.117    88.969     0.200
     0.584    20.070     0.200
     0.760    27.602     0.200
     1.490    49.977     0.200
     1.796    57.133     0.200
     2.868    87.898     0.200
     3.017    90.008     0.200
     3.529   104.617     0.200
     4.084   118.492     0.200
     0.412    14.949     0.200
     0.542    19.086     0.200
     0.791    26.477     0.200
     1.858    56.555     0.200
     1.749    53.953     0.200
     1.975    61.344     0.200
     2.144    67.254     0.200
     2.186    66.660     0.200
     2.420    74.047     0.200
     2.696    78.184     0.200
     2.851    82.914     0.200
     1.146    40.356     0.200
     1.219    42.145     0.200
     1.396    46.702     0.200
     1.559    51.407     0.200
     1.744    56.885     0.200
     1.772    58.388     0.200
     1.978    63.215     0.200
     2.050    64.737     0.200
     2.752    83.265     0.200
     3.230    95.884     0.200
     0.363    15.832     0.200
     1.125    36.777     0.200
     0.966    31.230     0.200
     1.139    37.590     0.200
     1.407    43.762     0.200
     1.638    50.742     0.200
     1.580    50.750     0.200
     2.025    61.969     0.200
     5.668   162.688     0.200
     0.875    30.391     0.200
     1.018    34.289     0.200
     1.003    33.289     0.200
     1.003    33.156     0.200
     1.449    47.328     0.200
     2.133    67.195     0.200
     2.141    67.977     0.200
     2.291    69.953     0.200
     3.342    96.984     0.200
     0.284    12.953     0.200
     0.434    17.676     0.200
     0.605    20.816     0.200
     1.003    31.348     0.200
     1.076    35.945     0.200
     1.396    44.641     0.200
     1.324    42.727     0.200
     0.183     9.219     0.200
     0.857    29.422     0.200
     1.110    35.484     0.200
     1.079    35.367     0.200
     1.681    51.961     0.200
     1.757    55.727     0.200
     1.866    59.359     0.200
     2.278    69.820     0.200
     0.384    13.119     0.200
     0.524    17.679     0.200
     0.604    20.285     0.200
     1.690    55.433     0.200
     2.021    64.653     0.200
     2.713    82.914     0.200
     2.949    87.386     0.200
     0.103     7.043     0.200
     0.492    16.855     0.200
     1.371    44.943     0.200
     1.611    51.527     0.200
     1.602    53.047     0.200
     1.744    55.072     0.200
     1.816    55.766     0.200
     1.904    58.869     0.200
     2.174    67.748     0.200
     2.189    65.783     0.200
     2.372    72.568     0.200
     2.458    75.043     0.200
     2.774    84.961     0.200
     2.967    87.812     0.200
     3.044    90.812     0.200
     3.347   101.465     0.200
     0.938    32.234     0.200
     1.022    36.984     0.200
     1.572    52.023     0.200
     2.195    68.332     0.200
     2.350    74.359     0.200
     2.816    85.492     0.200
     2.772    85.258     0.200
     0.096     6.547     0.200
     0.202     9.336     0.200
     1.364    45.070     0.200
     1.822    56.402     0.200
     1.903    60.559     0.200
     2.196    65.859     0.200
     2.373    73.004     0.200
     2.451    75.871     0.200
     2.459    75.793     0.200
     2.459    74.984     0.200
     2.777    83.918     0.200
     0.448    17.129     0.200
     0.615    21.793     0.200
     0.716    24.273     0.200
     1.444    46.000     0.200
     1.357    44.215     0.200
     1.595    51.707     0.200
     1.671    52.477     0.200
     2.135    64.156     0.200
     2.733    79.887     0.200
     2.994    88.703     0.200
     0.474    17.453     0.200
     1.560    50.635     0.200
     1.637    53.951     0.200
     1.901    60.832     0.200
     2.082    64.826     0.200
     2.139    65.758     0.200
     2.692    82.768     0.200
     2.760    82.443     0.200
     3.011    91.545     0.200
     3.373    97.156     0.200
     3.421    99.285     0.200
     0.495    17.787     0.200
     0.664    24.248     0.200
     0.751    24.874     0.200
     1.328    44.836     0.200
     1.544    50.719     0.200
     1.881    60.862     0.200
     2.087    63.830     0.200
     2.087    65.294     0.200
     2.188    67.688     0.200
     2.167    68.281     0.200
     2.334    70.359     0.200
     2.479    73.920     0.200
     2.780    82.526     0.200
     3.030    92.023     0.200
     0.667    24.543     0.200
     1.493    49.707     0.200
     1.719    53.691     0.200
     1.847    58.191     0.200
     2.151    65.980     0.200
     2.165    70.527     0.200
     2.184    67.926     0.200
     0.776    27.953     0.200
     0.834    28.688     0.200
     0.874    31.598     0.200
     1.374    45.156     0.200
     1.610    53.465     0.200
     1.713    57.277     0.200
     1.796    58.770     0.200
     1.963    64.703     0.200
     2.283    70.758     0.200
     0.802    29.547     0.200
     0.863    30.062     0.200
     0.943    33.018     0.200
     1.770    59.775     0.200
     1.730    58.965     0.200
     1.938    63.905     0.200
     1.910    62.942     0.200
     3.147    92.868     0.200
     0.336    11.683     0.200
     0.557    21.125     0.200
     0.840    29.872     0.200
     1.033    34.300     0.200
     1.185    38.807     0.200
     2.351    71.786     0.200
     2.364    72.561     0.200
     2.515    76.531     0.200
     2.958    87.188     0.200
     3.717   111.920     0.200
     0.356    12.844     0.200
     0.551    21.590     0.200
     0.638    21.418     0.200
     0.787    29.547     0.200
     1.623    53.355     0.200
     1.657    55.277     0.200
     1.683    56.105     0.200
     1.821    59.234     0.200
     2.106    67.129     0.200
     2.278    71.898     0.200
     2.219    69.441     0.200
     2.303    71.793     0.200
     2.810    84.570     0.200
     3.465   101.957     0.200
     3.524   103.297     0.200
     4.334   125.867     0.200
     0.126    10.254     0.200
     0.397    16.082     0.200
     0.521    19.918     0.200
     0.564    20.336     0.200
     2.651    78.902     0.200
     2.408    73.531     0.200
     0.867    30.204     0.200
     0.851    30.909     0.200
     1.496    49.812     0.200
     1.566    51.288     0.200
     2.312    74.896     0.200
     2.414    78.436     0.200
     2.906    89.213     0.200
     3.188    96.465     0.200
     3.221    96.497     0.200
     0.620    21.676     0.200
     1.181    37.246     0.200
     1.814    54.695     0.200
     1.827    53.840     0.200
     1.817    56.125     0.200
     2.011    61.234     0.200
     2.157    62.703     0.200
     2.188    64.992     0.200
     2.468    71.859     0.200
     0.451    16.926     0.200
     0.603    21.160     0.200
     0.636    22.203     0.200
     1.215    39.672     0.200
     1.713    55.578     0.200
     1.750    53.492     0.200
     1.760    55.578     0.200
     1.839    57.406     0.200
     1.900    56.883     0.200
     2.041    63.922     0.200
     2.203    68.617     0.200
     2.188    65.227     0.200
     2.259    67.836     0.200
     2.788    82.699     0.200
     0.210     8.336     0.200
     0.460    17.168     0.200
     0.634    21.238     0.200
     0.695    23.824     0.200
     1.355    43.910     0.200
     1.429    45.320     0.200
     1.574    50.336     0.200
     1.652    52.520     0.200
     2.474    74.137     0.200
     2.999    90.969     0.200
     3.364    96.570     0.200
     0.631    22.605     0.200
     0.818    27.293     0.200
     1.288    41.246     0.200
     1.285    42.523     0.200
     1.412    45.070     0.200
     1.912    58.707     0.200
     2.044    62.910     0.200
     2.040    63.805     0.200
     2.146    66.324     0.200
     2.253    68.777     0.200
     2.677    76.812     0.200
     2.854    83.848     0.200
     2.910    83.090     0.200
     0.898    30.955     0.200
     1.350    44.883     0.200
     1.497    49.189     0.200
     1.552    49.334     0.200
     1.693    55.152     0.200
     0.910    32.539     0.200
     1.764    56.703     0.200
     1.884    61.094     0.200
     2.893    86.812     0.200
     3.173    96.945     0.200
     0.156     7.279     0.200
     0.507    17.543     0.200
     1.659    52.957     0.200
     1.825    57.969     0.200
     1.872    60.574     0.200
     0.873    31.395     0.200
     0.916    31.954     0.200
     1.446    48.399     0.200
     1.497    48.412     0.200
     1.834    58.871     0.200
     1.750    56.104     0.200
     1.766    56.799     0.200
     2.614    79.649     0.200
     2.565    77.792     0.200
     0.494    19.879     0.200
     0.681    23.879     0.200
     0.888    30.676     0.200
     0.907    30.977     0.200
     1.497    46.668     0.200
     1.555    49.602     0.200
     1.721    53.113     0.200
     1.858    56.262     0.200
     0.170     8.406     0.200
     0.675    24.336     0.200
     1.812    56.805     0.200
     2.109    65.812     0.200
     3.405   103.297     0.200
     0.632    21.744     0.200
     0.720    24.215     0.200
     1.930    62.857     0.200
     2.167    66.758     0.200
     2.733    83.436     0.200
     0.801    28.094     0.200
     0.858    29.474     0.200
     0.994    34.973     0.200
     1.821    58.087     0.200
     2.151    66.516     0.200
     2.588    75.789     0.200
     0.825    29.180     0.200
     1.434    47.285     0.200
     1.521    48.316     0.200
     1.505    49.785     0.200
     1.531    49.973     0.200
     1.810    56.773     0.200
     1.810    58.004     0.200
     1.810    57.422     0.200
     2.730    81.613     0.200
     0.251    12.879     0.200
     0.687    22.676     0.200
     0.137     6.943     0.200
     1.783    56.283     0.200
     0.488    16.516     0.200
     0.579    20.395     0.200
     1.643    50.863     0.200
     1.833    57.844     0.200
     0.802    29.391     0.200
     0.885    30.219     0.200
     0.973    33.672     0.200
     1.300    43.188     0.200
     1.176    40.695     0.200
     1.427    49.086     0.200
     1.701    55.906     0.200
     1.643    52.859     0.200
     1.778    56.578     0.200
     1.882    61.281     0.200
     2.231    69.852     0.200
     0.662    23.078     0.200
     0.986    32.898     0.200
     1.443    47.500     0.200
     1.353    43.299     0.200
     1.397    45.117     0.200
     2.183    65.586     0.200
     2.110    64.793     0.200
     0.726    24.367     0.200
     0.914    32.086     0.200
     1.044    34.672     0.200
     1.457    46.961     0.200
     1.983    65.070     0.200
     2.214    69.594     0.200
     2.848    86.086     0.200
     0.552    20.742     0.200
     0.831    28.318     0.200
     1.180    40.682     0.200
     1.186    38.787     0.200
     1.250    42.174     0.200
     1.533    51.018     0.200
     0.772    26.789     0.200
     0.584    20.828     0.200
     0.702    24.594     0.200
     1.727    53.852     0.200
     2.311    72.039     0.200
     2.003    60.734     0.200
     2.724    82.328     0.200
     2.855    83.258     0.200
     3.598   103.836     0.200
     0.705    24.500     0.200
     0.701    23.523     0.200
     0.876    31.703     0.200
     1.040    36.727     0.200
     1.353    43.430     0.200
     2.822    84.453     0.200
     3.064    93.242     0.200
     0.608    21.872     0.200
     0.955    32.890     0.200
     1.420    42.792     0.200
     1.239    40.499     0.200
     1.407    44.476     0.200
     1.959    59.540     0.200
     2.173    63.914     0.200
     2.743    80.531     0.200
     2.962    85.550     0.200
     3.234    93.098     0.200
     4.143   118.522     0.200
     0.675    23.195     0.200
     0.753    26.391     0.200
     1.070    36.773     0.200
     0.856    30.227     0.200
     1.880    57.500     0.200
     1.686    55.820     0.200
     1.937    63.094     0.200
     2.106    65.172     0.200
     0.563    20.789     0.200
     0.727    26.312     0.200
     0.841    28.266     0.200
     1.125    35.242     0.200
     1.142    35.867     0.200
     1.392    45.508     0.200
     1.620    51.055     0.200
     1.749    55.625     0.200
     1.951    60.883     0.200
     1.939    60.016     0.200
     2.063    63.484     0.200
     2.296    68.656     0.200
     2.382    71.820     0.200
     3.026    88.859     0.200
     0.519    19.523     0.200
     0.696    24.633     0.200
     0.918    30.961     0.200
     1.352    44.484     0.200
     1.259    41.102     0.200
     1.443    48.047     0.200
     1.520    48.141     0.200
     1.678    51.172     0.200
     2.442    72.969     0.200
     0.865    30.127     0.200
     0.915    32.287     0.200
     0.991    35.607     0.200
     1.788    58.219     0.200
     1.923    59.227     0.200
     3.708   108.678     0.200
     0.570    22.109     0.200
     0.815    28.547     0.200
     1.364    43.789     0.200
     1.412    45.828     0.200
     1.686    51.406     0.200
     1.764    56.984     0.200
     1.831    58.742     0.200
     1.939    58.414     0.200
     0.920    32.520     0.200
     1.386    43.949     0.200
     1.906    62.445     0.200
     0.944    32.170     0.200
     1.034    36.000     0.200
     1.121    39.062     0.200
     1.636    54.104     0.200
     1.636    52.684     0.200
     1.758    58.676     0.200
     2.082    64.863     0.200
     0.769    28.234     0.200
     0.769    27.938     0.200
     1.443    47.266     0.200
     1.851    57.109     0.200
     1.892    60.211     0.200
     2.069    64.984     0.200
     0.805    28.102     0.200
     0.925    31.484     0.200
     1.513    49.020     0.200
     1.874    59.188     0.200
     1.861    57.379     0.200
     2.013    64.551     0.200
     2.086    64.992     0.200
     0.176     7.525     0.200
     0.675    23.209     0.200
     0.756    25.873     0.200
     1.822    60.893     0.200
     2.101    63.371     0.200
     2.174    65.371     0.200
     3.046    91.242     0.200
     0.193     7.879     0.200
     0.953    32.699     0.200
     1.250    41.000     0.200
     0.940    34.371     0.200
     1.416    47.129     0.200
     1.503    48.855     0.200
     1.445    48.242     0.200
     1.693    54.121     0.200
     1.693    54.605     0.200
     1.705    55.785     0.200
     1.619    51.562     0.200
     1.758    56.125     0.200
     1.982    62.586     0.200
     1.917    59.293     0.200
     1.998    62.855     0.200
     2.056    64.797     0.200
     2.902    86.426     0.200
     2.973    90.453     0.200
     0.236    10.422     0.200
     0.746    23.641     0.200
     0.746    25.688     0.200
     1.333    43.461     0.200
     1.467    45.031     0.200
     1.528    48.109     0.200
     1.659    52.461     0.200
     2.022    61.359     0.200
     2.323    68.938     0.200
     2.570    73.883     0.200
     0.463    17.251     0.200
     1.220    37.621     0.200
     1.352    41.604     0.200
     0.856    28.688     0.200
     1.130    36.820     0.200
     1.696    54.656     0.200
     1.759    58.633     0.200
     2.348    70.977     0.200
     1.909    60.352     0.200
     1.906    56.383     0.200
     2.080    63.125     0.200
     2.857    82.164     0.200
     0.893    31.422     0.200
     1.270    41.328     0.200
     1.298    43.836     0.200
     1.321    45.344     0.200
     1.669    54.773     0.200
     1.757    59.664     0.200
     1.832    60.234     0.200
     1.905    61.609     0.200
     0.577    20.820     0.200
     1.113    35.195     0.200
     1.383    44.180     0.200
     1.735    54.441     0.200
     1.938    56.828     0.200
     2.085    63.719     0.200
     2.702    78.848     0.200
     2.705    78.715     0.200
     2.956    85.918     0.200
     3.104    90.355     0.200
     0.555    20.594     0.200
     0.756    25.961     0.200
     0.796    27.664     0.200
     0.845    28.680     0.200
     1.080    36.686     0.200
     1.596    50.746     0.200
     1.704    54.459     0.200
     1.895    58.340     0.200
     1.973    59.889     0.200
     1.975    60.529     0.200
     2.024    64.619     0.200
     2.086    64.586     0.200
     3.263    96.898     0.200
     3.381   100.055     0.200
     0.682    23.380     0.200
     0.618    21.896     0.200
     0.857    29.431     0.200
     0.973    32.513     0.200
     1.170    36.737     0.200
     1.261    40.618     0.200
     1.339    43.929     0.200
     1.386    45.070     0.200
     1.470    49.294     0.200
     0.324    12.711     0.200
     0.937    30.852     0.200
     1.492    45.398     0.200
     1.560    47.555     0.200
     2.196    65.961     0.200
     2.208    65.875     0.200
     2.318    71.203     0.200
     2.420    72.969     0.200
     0.226    10.316     0.200
     1.360    41.870     0.200
     1.467    46.435     0.200
     1.598    50.242     0.200
     2.414    71.583     0.200
     0.264    10.994     0.200
     0.871    28.555     0.200
     0.871    28.848     0.200
     1.321    41.609     0.200
     1.425    46.113     0.200
     1.556    48.096     0.200
     1.630    50.955     0.200
     2.414    73.020     0.200
     2.446    71.520     0.200
     2.491    76.545     0.200
     0.724    25.859     0.200
     0.807    29.391     0.200
     1.084    36.125     0.200
     1.379    43.836     0.200
     1.489    47.844     0.200
     1.634    53.305     0.200
     1.825    55.750     0.200
     1.825    56.273     0.200
     1.902    58.469     0.200
     2.045    63.086     0.200
     2.441    73.469     0.200
     0.513    17.840     0.200
     0.434    15.762     0.200
     0.705    24.035     0.200
     1.115    37.465     0.200
     1.381    45.516     0.200
     1.813    55.562     0.200
     0.496    17.793     0.200
     0.516    18.207     0.200
     1.052    35.883     0.200
     1.330    41.789     0.200
     1.510    50.059     0.200
     1.687    54.891     0.200
     1.795    57.836     0.200
     2.328    70.641     0.200
     0.604    21.688     0.200
     0.879    31.449     0.200
     1.423    46.898     0.200
     1.424    46.906     0.200
     1.771    56.016     0.200
     0.719    24.320     0.200
     0.825    25.750     0.200
     0.942    30.555     0.200
     1.233    37.699     0.200
     1.233    38.207     0.200
     1.282    41.062     0.200
     1.259    39.395     0.200
     1.387    44.473     0.200
     1.963    60.781     0.200
     0.803    27.617     0.200
     1.037    34.773     0.200
     1.439    46.930     0.200
     1.520    49.141     0.200
     1.515    47.242     0.200
     1.551    50.344     0.200
     1.545    50.930     0.200
     1.698    52.367     0.200
     1.069    34.989     0.200
     1.127    37.795     0.200
     1.158    39.001     0.200
     1.451    45.951     0.200
     1.628    52.188     0.200
     0.368    12.977     0.200
     1.314    42.367     0.200
     1.646    51.914     0.200
     1.740    55.070     0.200
     1.903    59.734     0.200
     2.459    74.422     0.200
     0.212     7.734     0.200
     0.972    34.078     0.200
     0.995    34.289     0.200
     1.062    34.477     0.200
     1.100    36.352     0.200
     1.291    42.203     0.200
     1.422    46.781     0.200
     1.565    49.336     0.200
     2.019    62.688     0.200
     2.291    69.305     0.200
     2.427    73.836     0.200
     0.336    12.172     0.200
     0.416    14.953     0.200
     0.679    23.930     0.200
     0.841    29.312     0.200
     1.134    37.008     0.200
     1.087    36.344     0.200
     1.735    56.273     0.200
     2.528    77.141     0.200
     2.521    76.078     0.200
     2.609    79.062     0.200
     2.696    81.078     0.200
     2.778    83.023     0.200
     2.822    83.102     0.200
     2.940    86.586     0.200
     3.031    88.180     0.200
     0.735    25.438     0.200
     1.531    47.852     0.200
     1.531    48.008     0.200
     1.669    54.844     0.200
     1.943    60.773     0.200
     2.341    74.242     0.200
     2.600    78.398     0.200
     3.197    94.578     0.200
     0.698    25.602     0.200
     0.957    32.078     0.200
     1.110    37.547     0.200
     1.114    37.500     0.200
     1.327    42.000     0.200
     1.413    47.914     0.200
     1.654    53.852     0.200
     1.676    53.492     0.200
     1.832    57.578     0.200
     2.207    68.852     0.200
     0.735    25.488     0.200
     0.727    25.459     0.200
     1.108    36.654     0.200
     1.865    61.500     0.200
     2.152    66.406     0.200
     2.233    69.521     0.200
     2.495    76.834     0.200
     3.482   102.881     0.200
     0.700    22.422     0.200
     1.133    39.297     0.200
     1.467    50.324     0.200
     0.587    21.359     0.200
     0.896    31.623     0.200
     1.130    39.254     0.200
     1.146    38.886     0.200
     1.422    47.688     0.200
     1.653    53.395     0.200
     1.738    57.332     0.200
     2.358    72.349     0.200
     2.369    71.680     0.200
     0.712    25.846     0.200
     1.537    50.120     0.200
     2.342    74.422     0.200
     2.333    71.108     0.200
     2.333    70.823     0.200
     2.865    85.835     0.200
     3.200    93.363     0.200
     0.845    26.906     0.200
     1.348    43.021     0.200
     1.440    47.396     0.200
     1.406    46.544     0.200
     1.848    57.362     0.200
     2.184    66.000     0.200
     2.174    68.938     0.200
     2.694    80.576     0.200
     2.914    86.680     0.200
     0.331    14.523     0.200
     1.052    33.328     0.200
     1.375    43.133     0.200
     1.507    46.234     0.200
     0.321    13.984     0.200
     0.984    32.883     0.200
     1.241    39.348     0.200
     1.360    41.406     0.200
     1.306    40.211     0.200
     1.400    42.969     0.200
     1.532    46.172     0.200
     1.974    59.609     0.200
     0.477    17.633     0.200
     0.595    21.426     0.200
     0.735    25.398     0.200
     0.966    31.977     0.200
     1.135    38.945     0.200
     1.828    58.914     0.200
     2.303    72.973     0.200
     2.200    70.543     0.200
     2.247    70.930     0.200
     0.312    11.613     0.200
     1.377    44.871     0.200
     1.557    50.941     0.200
     1.509    48.523     0.200
     1.958    60.291     0.200
     0.529    18.859     0.200
     0.914    28.752     0.200
     0.934    31.290     0.200
     1.112    36.696     0.200
     1.283    41.835     0.200
     1.833    56.420     0.200
     1.918    58.606     0.200
     2.227    69.072     0.200
     2.337    71.204     0.200
     2.524    74.839     0.200
     3.472   102.870     0.200
     0.745    24.516     0.200
     0.790    25.578     0.200
     1.323    44.570     0.200
     1.389    46.266     0.200
     1.462    47.070     0.200
     1.522    47.312     0.200
     2.033    64.242     0.200
     2.338    69.914     0.200
     2.395    72.211     0.200
     0.650    23.715     0.200
     0.647    22.746     0.200
     0.892    30.812     0.200
     0.994    34.863     0.200
     1.304    40.355     0.200
     1.283    42.195     0.200
     1.409    45.734     0.200
     1.895    60.082     0.200
     2.018    61.129     0.200
     0.549    20.148     0.200
     0.687    24.711     0.200
     0.795    28.695     0.200
     1.197    38.484     0.200
     1.221    39.469     0.200
     1.706    53.359     0.200
     1.677    54.570     0.200
     1.889    58.648     0.200
     1.999    64.281     0.200
     2.302    70.688     0.200
     2.047    65.742     0.200
     0.552    20.930     0.200
     0.698    24.820     0.200
     0.808    27.508     0.200
     1.175    39.375     0.200
     1.224    39.656     0.200
     1.699    54.688     0.200
     1.984    64.781     0.200
     1.984    65.070     0.200
     2.053    66.648     0.200
     2.053    67.055     0.200
     2.299    71.602     0.200
     0.661    23.543     0.200
     0.857    28.379     0.200
     0.861    28.465     0.200
     1.331    43.602     0.200
     1.255    40.605     0.200
     1.380    43.889     0.200
     2.078    65.461     0.200
     2.218    65.070     0.200
     2.133    63.793     0.200
     0.555    20.801     0.200
     0.686    25.090     0.200
     0.793    26.434     0.200
     0.917    31.387     0.200
     1.079    38.098     0.200
     1.213    38.699     0.200
     1.213    40.301     0.200
     1.211    41.367     0.200
     1.662    53.438     0.200
     1.699    54.777     0.200
     1.721    55.945     0.200
     1.875    58.148     0.200
     2.003    64.641     0.200
     2.003    64.301     0.200
     2.037    65.238     0.200
     2.037    65.352     0.200
     2.220    69.648     0.200
     2.271    70.906     0.200
     0.900    29.617     0.200
     0.900    28.047     0.200
     0.977    32.422     0.200
     1.017    34.062     0.200
     1.425    44.328     0.200
     1.646    50.344     0.200
     1.687    51.297     0.200
     1.796    54.281     0.200
     2.515    73.422     0.200
     2.508    75.562     0.200
     2.691    77.852     0.200
     2.872    83.000     0.200
     1.006    34.391     0.200
     1.124    36.773     0.200
     1.692    52.301     0.200
     1.799    55.219     0.200
     2.551    77.742     0.200
     0.393    14.123     0.200
     0.393    15.238     0.200
     0.524    20.066     0.200
     1.189    39.752     0.200
     0.382    13.777     0.200
     0.514    18.562     0.200
     1.201    39.445     0.200
     1.165    38.066     0.200
     1.177    38.406     0.200
     2.098    64.859     0.200
     2.179    67.496     0.200
     2.770    84.324     0.200
     2.583    77.125     0.200
     2.638    78.938     0.200
     0.367    13.816     0.200
     0.499    17.836     0.200
     1.154    39.168     0.200
     1.169    38.406     0.200
     1.202    39.719     0.200
     2.171    67.016     0.200
     2.583    76.605     0.200
     2.754    82.105     0.200
     2.778    81.867     0.200
     3.100    93.082     0.200
     0.376    13.770     0.200
     0.500    17.820     0.200
     1.191    39.223     0.200
     0.385    14.045     0.200
     0.517    17.797     0.200
     1.148    39.357     0.200
     1.157    39.080     0.200
     1.164    39.283     0.200
     1.223    39.338     0.200
     2.198    67.895     0.200
     3.130    95.750     0.200
     0.376    13.453     0.200
     0.506    18.222     0.200
     1.170    38.756     0.200
     1.190    38.620     0.200
     1.176    39.027     0.200
     2.067    64.100     0.200
     2.183    68.105     0.200
     2.145    64.991     0.200
     2.145    67.256     0.200
     2.610    78.281     0.200
     3.093    92.573     0.200
     0.369    13.832     0.200
     0.790    27.641     0.200
     1.164    37.516     0.200
     1.184    38.512     0.200
     1.179    38.391     0.200
     2.063    63.188     0.200
     2.145    68.580     0.200
     2.612    78.094     0.200
     2.607    78.176     0.200
     2.646    78.854     0.200
     2.672    79.410     0.200
     2.748    81.176     0.200
     1.179    36.879     0.200
     1.293    41.531     0.200
     1.747    53.008     0.200
     2.101    61.926     0.200
     2.154    64.207     0.200
     2.443    70.918     0.200
     0.930    32.791     0.200
     0.843    29.906     0.200
     1.053    35.459     0.200
     1.469    46.227     0.200
     1.434    48.414     0.200
     1.516    50.570     0.200
     1.542    51.412     0.200
     1.658    53.230     0.200
     0.225     9.848     0.200
     1.756    56.879     0.200
     1.485    49.855     0.200
     1.629    52.727     0.200
     1.565    52.719     0.200
     1.855    59.461     0.200
     1.985    62.773     0.200
     1.333    42.875     0.200
     1.401    43.969     0.200
     1.422    46.985     0.200
     1.505    48.484     0.200
     1.498    49.206     0.200
     1.623    50.642     0.200
     1.574    50.924     0.200
     1.642    51.821     0.200
     1.789    55.435     0.200
     0.267     8.983     0.200
     0.999    35.005     0.200
     1.261    43.224     0.200
     1.496    50.578     0.200
     1.564    52.208     0.200
     1.855    60.359     0.200
     1.982    62.482     0.200
     0.687    25.055     0.200
     0.790    28.602     0.200
     1.049    37.367     0.200
     1.197    40.562     0.200
     1.635    53.961     0.200
     1.718    56.828     0.200
     2.017    66.047     0.200
     2.009    65.602     0.200
     0.456    16.180     0.200
     0.578    20.953     0.200
     0.586    20.352     0.200
     0.815    28.234     0.200
     1.568    49.320     0.200
     1.814    58.070     0.200
     1.814    56.766     0.200
     1.768    54.781     0.200
     1.969    62.852     0.200
     2.148    67.180     0.200
     2.250    70.734     0.200
     2.250    71.320     0.200
     2.391    73.102     0.200
     2.520    76.359     0.200
     2.722    81.961     0.200
     0.366    13.070     0.200
     0.498    17.148     0.200
     1.151    37.859     0.200
     1.166    37.922     0.200
     1.205    39.078     0.200
     1.717    56.430     0.200
     2.085    64.570     0.200
     2.174    66.305     0.200
     2.580    77.109     0.200
     2.575    78.008     0.200
     2.626    78.875     0.200
     3.100    92.367     0.200
     3.383    99.047     0.200
     0.343    13.078     0.200
     0.470    17.133     0.200
     0.760    26.953     0.200
     1.153    38.117     0.200
     1.187    38.984     0.200
     1.154    38.023     0.200
     2.093    63.461     0.200
     2.610    77.898     0.200
     2.640    78.344     0.200
     2.655    79.258     0.200
     2.619    76.508     0.200
     2.704    80.891     0.200
     2.704    79.195     0.200
     3.033    91.125     0.200
     3.211    93.500     0.200
     0.314    12.868     0.200
     0.439    16.896     0.200
     1.128    38.660     0.200
     1.021    36.329     0.200
     1.710    54.061     0.200
     1.972    60.909     0.200
     2.641    80.296     0.200
     2.655    78.129     0.200
     2.650    80.588     0.200
     0.367    15.688     0.200
     0.617    20.281     0.200
     0.894    29.172     0.200
     0.893    29.789     0.200
     1.712    53.773     0.200
     0.705    25.207     0.200
     0.780    28.637     0.200
     0.772    26.723     0.200
     1.122    36.836     0.200
     1.360    43.492     0.200
     1.613    51.074     0.200
     1.705    54.812     0.200
     2.129    68.570     0.200
     2.462    74.941     0.200
     0.379    16.324     0.200
     0.607    22.020     0.200
     0.890    30.635     0.200
     1.559    48.414     0.200
     1.619    51.580     0.200
     1.709    52.645     0.200
     1.725    54.006     0.200
     3.467   101.160     0.200
     0.148     6.746     0.200
     0.642    23.516     0.200
     1.667    51.828     0.200
     1.854    58.586     0.200
     1.840    59.039     0.200
     2.095    65.770     0.200
     2.161    67.316     0.200
     2.226    67.785     0.200
     2.193    65.898     0.200
     0.395    15.555     0.200
     0.645    21.645     0.200
     0.942    32.266     0.200
     0.891    29.977     0.200
     1.481    45.668     0.200
     1.600    49.793     0.200
     1.657    50.602     0.200
     1.709    53.406     0.200
     0.271    13.039     0.200
     0.632    22.895     0.200
     0.845    29.773     0.200
     1.111    35.254     0.200
     1.426    44.145     0.200
     1.563    48.949     0.200
     1.663    51.473     0.200
     1.825    56.855     0.200
     0.416    15.559     0.200
     0.586    20.996     0.200
     0.886    30.883     0.200
     0.954    31.734     0.200
     0.954    30.531     0.200
     0.938    31.309     0.200
     1.423    46.092     0.200
     1.588    50.674     0.200
     1.692    52.959     0.200
     1.651    52.895     0.200
     1.757    55.938     0.200
     2.625    78.750     0.200
     2.669    80.336     0.200
     2.815    83.041     0.200
     0.728    25.977     0.200
     0.761    27.523     0.200
     1.065    32.621     0.200
     1.434    44.691     0.200
     1.382    43.332     0.200
     1.704    54.980     0.200
     1.612    52.164     0.200
     1.863    56.820     0.200
     2.053    63.004     0.200
     2.118    64.543     0.200
     2.277    67.672     0.200
     2.488    73.176     0.200
     2.498    76.520     0.200
     3.576   103.172     0.200
     0.306    12.941     0.200
     1.235    38.592     0.200
     1.437    44.661     0.200
     1.627    50.972     0.200
     1.600    49.758     0.200
     0.634    22.766     0.200
     0.653    24.414     0.200
     0.787    25.332     0.200
     0.729    24.414     0.200
     0.922    31.051     0.200
     1.038    35.184     0.200
     1.286    40.191     0.200
     1.326    42.594     0.200
     1.466    47.605     0.200
     1.452    46.164     0.200
     1.907    57.395     0.200
     2.054    65.215     0.200
     2.234    66.309     0.200
     0.646    23.594     0.200
     1.030    34.750     0.200
     1.927    60.008     0.200
     0.354    14.990     0.200
     0.852    26.824     0.200
     0.907    29.057     0.200
     0.936    30.947     0.200
     1.240    39.893     0.200
     1.275    42.482     0.200
     1.598    50.006     0.200
     1.928    59.887     0.200
     1.933    60.355     0.200
     1.940    60.020     0.200
     2.168    63.840     0.200
     2.272    66.420     0.200
     2.599    77.930     0.200
     2.937    84.197     0.200
     3.060    91.174     0.200
     0.389    14.684     0.200
     0.842    28.938     0.200
     1.299    41.906     0.200
     1.395    43.199     0.200
     1.469    46.629     0.200
     1.629    51.227     0.200
     1.672    51.062     0.200
     1.535    48.203     0.200
     2.236    66.586     0.200
     0.381    15.958     0.200
     0.860    28.306     0.200
     0.906    29.703     0.200
     1.217    38.562     0.200
     1.280    40.515     0.200
     1.450    45.002     0.200
     1.516    46.356     0.200
     0.378    15.661     0.200
     0.865    28.221     0.200
     1.628    50.228     0.200
     1.908    59.300     0.200
     1.915    59.010     0.200
     0.243    10.156     0.200
     0.311    11.438     0.200
     0.574    20.297     0.200
     1.125    36.391     0.200
     1.630    52.930     0.200
     1.754    54.859     0.200
     1.900    60.281     0.200
     1.955    60.680     0.200
     2.504    76.555     0.200
     2.459    77.047     0.200
     2.698    79.898     0.200
     0.393    16.164     0.200
     0.863    28.945     0.200
     0.937    30.758     0.200
     1.284    40.789     0.200
     1.451    45.023     0.200
     1.516    47.102     0.200
     1.676    52.348     0.200
     0.402    14.891     0.200
     0.951    32.250     0.200
     0.915    30.711     0.200
     0.948    32.516     0.200
     1.368    44.320     0.200
     1.588    51.031     0.200
     1.681    53.250     0.200
     1.681    52.102     0.200
     1.627    51.195     0.200
     1.734    53.984     0.200
     2.816    83.648     0.200
     0.418    15.723     0.200
     0.961    32.965     0.200
     1.374    45.477     0.200
     1.607    51.324     0.200
     1.634    50.980     0.200
     1.665    52.020     0.200
     1.792    58.871     0.200
     0.455    17.133     0.200
     0.967    32.125     0.200
     1.198    37.500     0.200
     1.369    44.711     0.200
     1.503    46.086     0.200
     1.825    57.844     0.200
     2.319    69.992     0.200
     2.426    70.922     0.200
     2.458    71.430     0.200
     0.638    22.906     0.200
     0.701    26.180     0.200
     1.150    36.859     0.200
     1.646    53.195     0.200
     1.808    55.797     0.200
     1.914    59.039     0.200
     2.196    66.641     0.200
     0.847    29.758     0.200
     0.933    32.219     0.200
     1.121    38.242     0.200
     1.180    38.023     0.200
     1.169    38.977     0.200
     1.586    50.930     0.200
     2.434    74.836     0.200
     0.253     9.951     0.200
     0.360    13.257     0.200
     0.655    22.941     0.200
     0.815    29.439     0.200
     1.687    53.549     0.200
     2.071    65.371     0.200
     2.280    70.597     0.200
     2.776    83.288     0.200
     3.431    98.653     0.200
     0.278    13.250     0.200
     0.905    30.195     0.200
     1.285    42.355     0.200
     1.477    45.328     0.200
     1.535    48.355     0.200
     1.638    51.043     0.200
     0.436    14.984     0.200
     1.094    35.875     0.200
     1.524    50.578     0.200
     1.551    50.477     0.200
     1.052    34.578     0.200
     1.271    39.207     0.200
     1.367    44.625     0.200
     1.814    57.039     0.200
     1.679    52.801     0.200
     1.849    57.828     0.200
     1.922    59.699     0.200
     2.049    63.738     0.200
     0.527    19.000     0.200
     0.659    22.430     0.200
     1.030    36.551     0.200
     1.100    37.234     0.200
     1.100    38.352     0.200
     1.233    42.531     0.200
     1.246    42.844     0.200
     1.750    57.945     0.200
     1.736    56.789     0.200
     1.642    53.820     0.200
     1.788    57.422     0.200
     1.700    56.457     0.200
     1.684    53.340     0.200
     0.513    17.490     0.200
     0.628    21.099     0.200
     1.267    42.662     0.200
     1.396    46.099     0.200
     1.653    54.233     0.200
     1.802    56.986     0.200
     1.995    62.128     0.200
     2.131    67.035     0.200
     2.212    71.384     0.200
     0.797    26.811     0.200
     0.626    22.051     0.200
     0.868    28.273     0.200
     1.061    34.818     0.200
     1.211    40.602     0.200
     1.331    44.633     0.200
     1.542    52.146     0.200
     1.943    61.402     0.200
     1.966    64.221     0.200
     1.951    63.014     0.200
     2.009    65.264     0.200
     2.069    66.822     0.200
     0.278    12.273     0.200
     0.485    17.083     0.200
     0.611    21.133     0.200
     0.879    29.780     0.200
     1.225    40.168     0.200
     1.503    47.368     0.200
     1.790    55.202     0.200
     1.742    54.542     0.200
     2.014    64.598     0.200
     2.205    69.065     0.200
     2.327    72.413     0.200
     0.576    21.086     0.200
     1.031    35.148     0.200
     0.959    33.289     0.200
     1.233    40.180     0.200
     1.321    44.562     0.200
     1.449    48.797     0.200
     1.965    63.531     0.200
     0.834    28.073     0.200
     0.840    30.734     0.200
     0.914    30.533     0.200
     1.479    47.765     0.200
     1.544    49.555     0.200
     1.816    56.725     0.200
     2.127    65.211     0.200
     0.468    17.836     0.200
     0.523    19.352     0.200
     1.074    37.188     0.200
     1.011    33.141     0.200
     1.232    37.938     0.200
     1.230    38.883     0.200
     1.348    43.051     0.200
     1.320    41.918     0.200
     1.592    49.160     0.200
     1.649    51.023     0.200
     1.959    60.383     0.200
     2.336    68.844     0.200
     0.833    28.266     0.200
     1.373    44.562     0.200
     1.405    44.531     0.200
     1.393    44.594     0.200
     1.479    46.297     0.200
     1.476    46.836     0.200
     2.095    63.539     0.200
     2.173    65.719     0.200
     2.203    65.336     0.200
     2.397    70.734     0.200
     2.831    83.625     0.200
     0.753    25.823     0.200
     0.816    29.355     0.200
     1.078    36.901     0.200
     1.365    43.249     0.200
     1.567    51.753     0.200
     1.843    60.616     0.200
     2.109    65.521     0.200
     2.384    72.742     0.200
     0.458    17.333     0.200
     0.838    26.006     0.200
     0.812    26.612     0.200
     0.970    33.276     0.200
     1.113    34.759     0.200
     1.258    39.670     0.200
     1.449    46.805     0.200
     1.389    43.368     0.200
     1.122    36.520     0.200
     1.420    46.965     0.200
     1.502    49.334     0.200
     2.046    64.340     0.200
     2.543    77.959     0.200
     0.736    25.803     0.200
     0.894    30.875     0.200
     0.894    29.457     0.200
     1.427    47.008     0.200
     1.537    48.820     0.200
     1.537    50.455     0.200
     1.697    55.396     0.200
     1.664    54.227     0.200
     1.937    63.256     0.200
     2.352    70.078     0.200
     2.406    74.867     0.200
     2.594    78.602     0.200
     2.684    78.785     0.200
     2.896    86.326     0.200
     2.890    85.379     0.200
     0.478    17.301     0.200
     0.988    33.541     0.200
     1.181    38.951     0.200
     1.443    46.967     0.200
     1.470    47.832     0.200
     1.507    48.083     0.200
     2.518    74.742     0.200
     2.562    78.002     0.200
     2.643    78.241     0.200
     0.499    17.721     0.200
     1.049    34.553     0.200
     1.451    48.709     0.200
     1.480    48.542     0.200
     1.523    49.337     0.200
     2.546    75.265     0.200
     2.648    79.521     0.200
     2.638    80.562     0.200
     0.547    19.495     0.200
     1.626    51.826     0.200
     1.841    56.304     0.200
     2.672    78.691     0.200
     3.684   105.770     0.200
     0.542    19.474     0.200
     0.953    29.394     0.200
     1.152    37.171     0.200
     1.283    39.732     0.200
     1.819    58.508     0.200
     0.496    18.314     0.200
     1.018    35.252     0.200
     1.239    39.672     0.200
     1.370    43.104     0.200
     2.091    63.012     0.200
     1.417    45.680     0.200
     1.406    46.055     0.200
     1.446    47.336     0.200
     1.491    48.375     0.200
     2.083    63.266     0.200
     2.389    71.023     0.200
     0.755    25.797     0.200
     0.815    29.617     0.200
     1.332    43.320     0.200
     1.544    49.781     0.200
     1.539    50.188     0.200
     0.856    28.590     0.200
     0.933    30.238     0.200
     0.848    28.172     0.200
     1.469    45.703     0.200
     1.396    44.824     0.200
     1.514    47.316     0.200
     0.425    13.613     0.200
     1.329    43.648     0.200
     1.469    50.590     0.200
     1.443    47.566     0.200
     1.600    52.211     0.200
     1.607    54.066     0.200
     1.501    49.852     0.200
     2.139    68.156     0.200
     0.666    23.891     0.200
     0.743    27.367     0.200
     1.364    43.758     0.200
     0.187     8.258     0.200
     0.595    20.453     0.200
     0.922    33.988     0.200
     1.884    60.324     0.200
     1.926    59.529     0.200
     2.266    70.289     0.200
     2.407    77.340     0.200
     2.420    72.631     0.200
     2.871    87.650     0.200
     0.216     9.283     0.200
     1.411    44.578     0.200
     1.376    45.658     0.200
     1.529    49.277     0.200
     2.017    62.250     0.200
     2.913    87.934     0.200
     0.612    22.609     0.200
     1.152    36.797     0.200
     1.461    50.039     0.200
     1.443    49.008     0.200
     1.490    48.047     0.200
     2.079    63.211     0.200
     2.701    79.898     0.200
     0.476    16.430     0.200
     1.847    56.504     0.200
     1.961    59.246     0.200
     2.134    63.348     0.200
     0.919    30.102     0.200
     1.024    35.898     0.200
     1.634    53.297     0.200
     1.832    59.594     0.200
     0.444    15.289     0.200
     1.018    33.408     0.200
     1.115    35.616     0.200
     1.518    49.845     0.200
     1.525    51.317     0.200
     1.704    52.915     0.200
     2.090    66.282     0.200
     2.115    66.961     0.200
     2.290    72.855     0.200
     2.491    74.884     0.200
     1.241    41.484     0.200
     1.281    42.453     0.200
     1.415    46.070     0.200
     1.479    48.734     0.200
     1.498    50.102     0.200
     1.596    53.211     0.200
     1.841    58.914     0.200
     1.961    61.812     0.200
     2.649    81.422     0.200
     2.641    80.219     0.200
     0.459    17.105     0.200
     0.540    20.436     0.200
     0.733    27.236     0.200
     0.828    28.158     0.200
     0.907    30.715     0.200
     1.393    45.498     0.200
     2.634    76.604     0.200
     2.725    81.326     0.200
     3.198    97.150     0.200
     0.287    11.948     0.200
     0.616    21.770     0.200
     0.641    21.556     0.200
     1.189    38.990     0.200
     1.781    56.455     0.200
     1.979    62.281     0.200
     2.186    68.886     0.200
     2.569    78.284     0.200
     0.512    19.633     0.200
     0.791    27.544     0.200
     1.425    46.742     0.200
     3.139    94.786     0.200
     0.716    23.715     0.200
     1.061    37.797     0.200
     1.110    38.664     0.200
     1.456    49.094     0.200
     1.528    51.367     0.200
     1.810    60.148     0.200
     0.108     5.744     0.200
     0.591    22.276     0.200
     0.676    24.729     0.200
     0.843    28.807     0.200
     1.360    43.184     0.200
     1.495    47.987     0.200
     1.377    45.615     0.200
     1.481    47.048     0.200
     1.463    47.515     0.200
     2.020    62.348     0.200
     2.020    62.835     0.200
     0.644    22.313     0.200
     0.790    27.312     0.200
     0.963    31.254     0.200
     1.570    48.962     0.200
     2.191    65.962     0.200
     2.535    73.343     0.200
     2.638    77.523     0.200
     0.527    19.301     0.200
     0.545    20.771     0.200
     0.651    23.221     0.200
     0.677    25.047     0.200
     1.137    37.432     0.200
     1.738    55.828     0.200
     1.739    54.053     0.200
     1.663    51.834     0.200
     2.097    66.051     0.200
     2.449    72.898     0.200
     2.410    72.777     0.200
     2.821    81.965     0.200
     3.180    92.270     0.200
     0.574    19.445     0.200
     0.802    27.387     0.200
     1.199    39.051     0.200
     1.465    48.590     0.200
     1.518    50.285     0.200
     1.465    48.363     0.200
     1.488    49.012     0.200
     2.641    81.488     0.200
     0.111     6.742     0.200
     0.755    25.247     0.200
     0.964    33.451     0.200
     1.241    40.146     0.200
     1.379    44.227     0.200
     2.013    61.224     0.200
     2.435    72.159     0.200
     2.540    75.840     0.200
     0.293    12.277     0.200
     0.420    15.850     0.200
     0.537    19.428     0.200
     1.305    41.777     0.200
     1.334    43.268     0.200
     1.472    46.562     0.200
     1.618    49.449     0.200
     2.024    60.225     0.200
     2.257    69.754     0.200
     2.278    70.621     0.200
     0.479    16.453     0.200
     1.429    47.252     0.200
     1.607    52.431     0.200
     1.638    54.030     0.200
     1.693    54.490     0.200
     0.172     8.621     0.200
     1.527    48.375     0.200
     1.598    52.121     0.200
     1.791    53.578     0.200
     1.305    42.391     0.200
     1.553    49.211     0.200
     1.654    51.766     0.200
     1.793    56.359     0.200
     0.273    11.945     0.200
     0.647    21.742     0.200
     1.087    34.383     0.200
     1.552    49.492     0.200
     1.653    51.656     0.200
     0.450    14.340     0.200
     1.347    45.676     0.200
     1.177    41.930     0.200
     1.522    52.457     0.200
     1.491    48.520     0.200
     1.466    48.820     0.200
     1.858    60.004     0.200
     2.107    66.426     0.200
     1.069    36.898     0.200
     1.115    38.163     0.200
     1.574    49.362     0.200
     2.163    68.502     0.200
     2.232    68.394     0.200
     2.380    72.874     0.200
     0.380    11.625     0.200
     1.417    46.629     0.200
     1.265    41.300     0.200
     1.237    42.074     0.200
     1.479    48.404     0.200
     1.435    47.888     0.200
     1.607    51.634     0.200
     0.578    18.404     0.200
     1.270    43.662     0.200
     1.218    42.701     0.200
     1.500    50.139     0.200
     1.325    45.346     0.200
     0.927    33.016     0.200
     1.232    42.035     0.200
     1.345    43.884     0.200
     1.456    48.075     0.200
     1.581    51.654     0.200
     2.292    72.320     0.200
     2.360    72.116     0.200
     2.434    74.740     0.200
     0.891    33.039     0.200
     1.324    43.135     0.200
     1.712    55.715     0.200
     2.318    71.676     0.200
     2.656    78.416     0.200
     0.072     7.401     0.200
     0.495    18.729     0.200
     0.539    19.610     0.200
     1.319    42.612     0.200
     1.341    43.235     0.200
     1.637    51.893     0.200
     1.936    60.287     0.200
     2.213    67.508     0.200
     2.287    67.101     0.200
     2.483    74.246     0.200
     2.703    79.709     0.200
     3.203    92.799     0.200
     0.830    29.555     0.200
     1.066    35.973     0.200
     1.105    37.762     0.200
     1.259    40.016     0.200
     1.535    50.652     0.200
     1.697    54.594     0.200
     2.332    72.855     0.200
     0.720    22.609     0.200
     1.138    37.055     0.200
     1.138    36.363     0.200
     1.309    41.734     0.200
     1.571    49.555     0.200
     1.915    57.645     0.200
     1.878    59.078     0.200
     2.220    66.211     0.200
     2.267    67.516     0.200
     2.689    80.191     0.200
     0.630    22.500     0.200
     0.630    22.703     0.200
     0.677    23.320     0.200
     0.715    25.781     0.200
     1.201    38.758     0.200
     1.543    49.141     0.200
     1.667    53.617     0.200
     1.922    61.438     0.200
     0.949    34.961     0.200
     1.195    40.636     0.200
     1.191    41.459     0.200
     1.234    42.948     0.200
     1.315    45.345     0.200
     1.374    46.920     0.200
     1.478    49.452     0.200
     1.590    51.946     0.200
     1.691    54.973     0.200
     1.906    60.012     0.200
     2.285    72.759     0.200
     2.456    76.320     0.200
     2.620    78.605     0.200
     0.136     7.805     0.200
     0.304    11.867     0.200
     0.433    16.029     0.200
     1.633    50.818     0.200
     1.966    59.820     0.200
     2.048    62.932     0.200
     2.155    64.545     0.200
     2.387    73.713     0.200
     2.498    74.910     0.200
     2.438    75.084     0.200
     2.772    80.943     0.200
     2.899    84.457     0.200
     0.782    28.846     0.200
     1.011    36.062     0.200
     0.995    35.336     0.200
     1.033    36.590     0.200
     1.109    39.152     0.200
     1.253    42.148     0.200
     1.585    51.688     0.200
     2.278    71.781     0.200
     2.690    80.604     0.200
     3.532   105.248     0.200
     0.208     7.867     0.200
     1.324    45.555     0.200
     1.204    36.758     0.200
     1.390    45.445     0.200
     1.806    57.859     0.200
     2.219    67.141     0.200
     2.378    74.750     0.200
     0.871    31.277     0.200
     1.417    45.883     0.200
     1.774    55.594     0.200
     2.016    61.801     0.200
     2.073    62.551     0.200
     0.475    16.922     0.200
     1.055    35.055     0.200
     1.229    39.289     0.200
     1.361    43.273     0.200
     1.945    57.586     0.200
     0.761    25.750     0.200
     0.761    26.856     0.200
     0.978    31.712     0.200
     1.291    41.081     0.200
     1.318    41.282     0.200
     1.563    49.881     0.200
     1.523    49.604     0.200
     1.651    52.933     0.200
     1.903    58.758     0.200
     2.131    65.555     0.200
     2.189    66.349     0.200
     2.400    70.964     0.200
     0.123     5.609     0.200
     0.393    14.562     0.200
     0.332    11.758     0.200
     0.447    15.844     0.200
     0.999    36.547     0.200
     1.426    47.812     0.200
     1.781    56.859     0.200
     2.048    64.328     0.200
     2.048    63.031     0.200
     2.941    89.414     0.200
     0.999    33.793     0.200
     1.652    54.627     0.200
     0.746    26.523     0.200
     0.524    18.570     0.200
     0.977    32.016     0.200
     1.388    45.633     0.200
     1.487    47.352     0.200
     1.522    49.617     0.200
     2.020    62.219     0.200
     0.824    28.742     0.200
     0.858    29.416     0.200
     0.951    34.180     0.200
     0.997    35.354     0.200
     1.543    49.848     0.200
     1.629    53.369     0.200
     1.815    57.900     0.200
     1.903    60.410     0.200
     2.143    67.258     0.200
     0.753    25.375     0.200
     0.691    24.289     0.200
     0.763    25.219     0.200
     0.763    25.344     0.200
     1.044    32.547     0.200
     1.237    39.133     0.200
     1.319    41.727     0.200
     1.319    41.539     0.200
     1.429    43.445     0.200
     1.805    56.273     0.200
     1.814    58.352     0.200
     2.283    69.656     0.200
     2.290    66.586     0.200
     2.443    71.711     0.200
     0.781    27.981     0.200
     0.838    28.946     0.200
     0.888    30.297     0.200
     1.758    55.031     0.200
     1.937    59.244     0.200
     2.098    63.296     0.200
     2.027    62.717     0.200
     2.239    70.051     0.200
     2.630    76.612     0.200
     0.818    28.512     0.200
     1.091    35.648     0.200
     1.573    50.047     0.200
     1.623    49.633     0.200
     1.883    57.035     0.200
     2.162    67.461     0.200
     2.690    80.375     0.200
     3.053    89.652     0.200
     3.341   101.266     0.200
     3.476   103.836     0.200
     3.689   105.492     0.200
     0.949    32.242     0.200
     0.877    30.859     0.200
     0.904    31.469     0.200
     0.966    33.312     0.200
     1.474    46.094     0.200
     1.641    52.000     0.200
     1.939    59.555     0.200
     2.137    66.828     0.200
     0.141     8.236     0.200
     0.528    19.461     0.200
     0.528    18.465     0.200
     0.950    32.592     0.200
     1.002    33.303     0.200
     1.198    38.096     0.200
     1.387    45.885     0.200
     1.347    44.207     0.200
     1.728    54.051     0.200
     1.804    55.828     0.200
     2.344    69.729     0.200
     2.417    71.219     0.200
     2.425    74.367     0.200
     2.573    78.166     0.200
     2.735    79.461     0.200
     0.297     9.395     0.200
     1.148    40.316     0.200
     1.352    43.559     0.200
     1.352    42.863     0.200
     1.149    38.570     0.200
     1.570    50.578     0.200
     1.626    53.145     0.200
     1.808    57.992     0.200
     0.419    15.881     0.200
     0.835    28.475     0.200
     1.825    57.480     0.200
     2.367    72.195     0.200
     0.993    34.240     0.200
     1.516    47.945     0.200
     1.547    51.758     0.200
     1.626    51.113     0.200
     1.665    51.418     0.200
     1.626    50.090     0.200
     1.775    55.000     0.200
     1.775    55.223     0.200
     1.658    51.168     0.200
     1.775    55.775     0.200
     1.882    59.801     0.200
     1.982    59.701     0.200
     2.861    85.963     0.200
     1.340    44.544     0.200
     1.492    50.548     0.200
     2.056    65.248     0.200
     2.572    78.668     0.200
     3.230    97.736     0.200
     0.705    24.320     0.200
     0.695    25.377     0.200
     1.257    41.072     0.200
     1.339    43.164     0.200
     1.607    53.949     0.200
     1.658    54.709     0.200
     1.744    57.088     0.200
     2.663    82.020     0.200
     0.600    21.937     0.200
     0.662    23.280     0.200
     0.960    32.338     0.200
     1.139    38.526     0.200
     1.141    37.329     0.200
     1.327    43.773     0.200
     1.533    49.229     0.200
     1.642    51.546     0.200
     1.669    52.279     0.200
     1.725    53.526     0.200
     2.029    60.966     0.200
     2.286    71.088     0.200
     2.463    72.759     0.200
     0.328    14.878     0.200
     1.301    40.916     0.200
     1.646    51.710     0.200
     1.737    54.121     0.200
     0.532    20.219     0.200
     0.685    24.781     0.200
     1.108    36.336     0.200
     1.215    38.695     0.200
     1.230    39.867     0.200
     1.466    45.430     0.200
     1.727    51.969     0.200
     2.049    61.859     0.200
     2.113    61.984     0.200
     0.061     7.094     0.200
     0.318    12.383     0.200
     0.450    15.422     0.200
     1.767    55.055     0.200
     1.828    57.836     0.200
     1.961    60.195     0.200
     1.961    61.945     0.200
     2.414    71.828     0.200
     2.763    82.016     0.200
     0.261    13.350     0.200
     0.638    20.969     0.200
     1.413    45.287     0.200
     1.656    52.240     0.200
     1.836    54.641     0.200
     1.836    54.137     0.200
     2.302    66.494     0.200
     2.641    75.418     0.200
     0.454    18.430     0.200
     0.466    17.336     0.200
     0.696    23.547     0.200
     1.074    35.430     0.200
     1.245    38.461     0.200
     1.708    52.164     0.200
     0.527    18.398     0.200
     1.442    44.965     0.200
     1.474    45.768     0.200
     1.511    46.289     0.200
     0.771    27.003     0.200
     0.780    28.206     0.200
     0.828    29.691     0.200
     1.068    36.669     0.200
     1.550    51.796     0.200
     1.793    58.568     0.200
     1.971    62.127     0.200
     1.971    62.616     0.200
     2.109    67.992     0.200
     2.191    67.827     0.200
     2.379    72.239     0.200
     2.540    78.066     0.200
     3.143    92.046     0.200
     0.384    14.203     0.200
     0.738    25.594     0.200
     0.950    32.070     0.200
     1.477    46.383     0.200
     1.542    49.688     0.200
     1.670    52.828     0.200
     2.150    64.227     0.200
     1.734    55.516     0.200
     2.941    89.705     0.200
     3.857   114.551     0.200
     1.655    53.166     0.200
     0.724    24.070     0.200
     0.797    27.336     0.200
     1.342    43.568     0.200
     1.342    43.377     0.200
     3.084    93.012     0.200
     0.356    13.068     0.200
     0.356    12.613     0.200
     0.557    19.594     0.200
     1.913    58.588     0.200
     1.913    59.547     0.200
     0.431    15.479     0.200
     0.590    22.162     0.200
     1.744    52.314     0.200
     0.790    26.145     0.200
     0.750    27.086     0.200
     1.495    46.930     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.526    79.305     0.200
     2.591    85.305     0.200
     2.600    83.305     0.200
     3.212   106.305     0.200
     4.327   135.305     0.200
     5.619   180.305     0.200
     2.525    80.992     0.200
     2.882    89.419     0.200
     2.882    93.919     0.200
     3.963   124.419     0.200
     2.751    85.121     0.200
     2.760    84.621     0.200
     5.042   158.121     0.200
     9.343   292.121     0.200
     3.055   100.215     0.200
     2.580    81.547     0.200
     5.588   179.118     0.200
     2.721    90.072     0.200
     4.427   147.602     0.200
    19.960   623.521     0.200
    19.813   619.318     0.200
    20.012   623.660     0.200
    25.219   798.879     0.200
     2.674    83.180     0.200
     3.159    97.242     0.200
     2.525    78.578     0.200
     2.672    83.000     0.200
     2.766    85.133     0.200
     2.546    79.695     0.200
     2.558    81.402     0.200
     2.794    86.184     0.200
     3.472   107.398     0.200
     2.817    89.730     0.200
     3.503   108.641     0.200
     2.550    79.514     0.200
     2.526    78.760     0.200
     3.220   100.145     0.200
     2.514    78.230     0.200
     2.723    86.227     0.200
     2.597    80.184     0.200
     3.242   101.914     0.200
     2.574    81.008     0.200
     3.003    92.994     0.200
     3.436   108.123     0.200
     4.163   127.639     0.200
     4.296   135.918     0.200
     2.980    92.285     0.200
     3.034    98.449     0.200
     2.507    77.051     0.200
     2.547    78.344     0.200
     3.004    93.621     0.200
     3.345   103.629     0.200
     3.440   105.980     0.200
     4.161   126.953     0.200
     4.291   135.781     0.200
     2.703    84.010     0.200
     2.506    80.287     0.200
     2.657    82.408     0.200
     2.877    89.586     0.200
     3.121    97.031     0.200
     2.770    86.789     0.200
     2.947    90.520     0.200
     2.689    83.512     0.200
     2.775    86.625     0.200
     3.821   118.203     0.200
     2.968    94.238     0.200
     3.629   112.266     0.200
     4.067   126.508     0.200
     2.494    77.307     0.200
     3.342   104.309     0.200
     2.902    95.753     0.200
     2.794    86.852     0.200
     3.402   109.246     0.200
     2.719    84.008     0.200
     2.724    85.625     0.200
     2.814    87.359     0.200
     2.553    79.250     0.200
     3.038    93.877     0.200
     2.991    92.588     0.200
     2.768    85.607     0.200
     2.591    81.730     0.200
     2.758    85.578     0.200
     3.093    96.773     0.200
     2.737    84.456     0.200
     3.074    95.116     0.200
     2.748    86.629     0.200
     2.735    84.391     0.200
     2.626    81.203     0.200
     2.760    85.758     0.200
     2.873    92.562     0.200
     3.095    95.414     0.200
     2.704    83.930     0.200
     2.675    82.953     0.200
     3.011    93.156     0.200
     2.556    79.531     0.200
     2.718    83.980     0.200
     2.502    77.359     0.200
     2.545    80.578     0.200
     2.530    79.438     0.200
     2.867    88.468     0.200
     3.093    95.241     0.200
     2.592    79.590     0.200
     2.640    82.320     0.200
     2.715    84.516     0.200
     2.721    83.164     0.200
     2.565    79.902     0.200
     2.628    81.894     0.200
     2.644    82.219     0.200
     2.979    92.065     0.200
     2.597    80.883     0.200
     2.584    79.291     0.200
     3.090    95.545     0.200
     2.811    88.084     0.200
     2.549    80.195     0.200
     2.691    89.559     0.200
     3.058    98.913     0.200
     3.296   107.386     0.200
     3.588   113.384     0.200
     2.670    83.266     0.200
     2.763    86.703     0.200
     3.644   114.496     0.200
     4.111   129.705     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.146    69.992     0.200
     0.614    22.328     0.200
     2.016    64.328     0.200
     1.828    56.919     0.200
     2.357    76.419     0.200
     0.189     9.121     0.200
     1.506    49.121     0.200
     3.206    92.121     0.200
     4.058   118.121     0.200
     5.042   146.621     0.200
     7.300   215.223     0.200
     0.603    23.215     0.200
     1.183    31.715     0.200
     1.183    35.215     0.200
     1.569    50.215     0.200
     1.801    58.715     0.200
     2.598    78.215     0.200
     7.009   209.215     0.200
     0.609    21.047     0.200
     1.205    35.547     0.200
     4.572   133.746     0.200
     7.010   208.547     0.200
     1.604    53.820     0.200
     1.940    61.820     0.200
     4.599   134.820     0.200
     0.149     9.188     0.200
     0.701    23.688     0.200
     1.839    56.188     0.200
     0.827    29.207     0.200
     0.998    33.105     0.200
     0.764    25.414     0.200
     0.899    30.914     0.200
     1.054    36.215     0.200
     0.523    17.849     0.200
     1.198    39.349     0.200
     1.557    48.849     0.200
     1.704    52.849     0.200
     1.660    52.349     0.200
     1.879    59.349     0.200
     1.917    59.949     0.200
     1.867    58.349     0.200
     2.434    73.349     0.200
     0.646    22.594     0.200
     0.746    26.594     0.200
     0.943    30.594     0.200
     1.486    46.094     0.200
     1.642    51.094     0.200
     0.215     7.867     0.200
     0.274    10.367     0.200
     0.274    10.867     0.200
     0.274    11.867     0.200
     0.826    29.367     0.200
     1.138    37.867     0.200
     1.644    51.867     0.200
     1.738    54.367     0.200
     2.046    62.867     0.200
     2.950    88.867     0.200
     0.645    22.664     0.200
     0.956    30.664     0.200
     1.297    42.164     0.200
     1.652    52.164     0.200
     1.875    56.664     0.200
     0.220     9.018     0.200
     0.658    23.518     0.200
     0.792    27.317     0.200
     1.921    59.218     0.200
     2.110    63.518     0.200
     2.329    69.018     0.200
     0.756    26.453     0.200
     1.890    60.453     0.200
     2.010    64.453     0.200
     2.010    65.453     0.200
     2.010    66.453     0.200
     0.700    23.852     0.200
     1.693    53.852     0.200
     2.472    75.852     0.200
     0.783    27.291     0.200
     0.783    28.291     0.200
     1.799    55.791     0.200
     2.683    80.791     0.200
     0.906    30.537     0.200
     2.317    69.537     0.200
     0.667    23.947     0.200
     0.456    17.055     0.200
     2.064    62.070     0.200
     0.750    25.761     0.200
     1.359    43.762     0.200
     1.247    39.129     0.200
     5.071   145.398     0.200
     0.577    20.922     0.200
     0.610    21.182     0.200
     1.414    44.898     0.200
     1.374    45.023     0.200
     1.378    44.979     0.200
     1.549    49.678     0.200
     1.153    39.633     0.200
     1.243    41.633     0.200
     2.103    65.633     0.200
     2.301    71.633     0.200
     0.167     8.156     0.200
     1.262    37.656     0.200
     1.666    52.656     0.200
     1.801    57.156     0.200
     1.979    61.449     0.200
     1.984    61.457     0.200
     1.990    59.836     0.200
     2.368    71.156     0.200
     3.111    91.578     0.200
     3.355    96.566     0.200
     1.599    50.383     0.200
     1.920    59.845     0.200
     1.930    58.553     0.200
     1.852    58.383     0.200
     2.421    73.383     0.200
     0.424    15.117     0.200
     1.087    38.117     0.200
     1.792    59.117     0.200
     0.140     6.266     0.200
     0.461    16.266     0.200
     1.047    35.266     0.200
     1.508    51.266     0.200
     0.130     7.473     0.200
     0.390    14.473     0.200
     1.055    35.473     0.200
     1.214    39.473     0.200
     1.880    60.973     0.200
     0.798    27.367     0.200
     1.110    38.367     0.200
     1.748    57.367     0.200
     2.419    75.367     0.200
     2.665    81.867     0.200
     2.592    77.367     0.200
     0.562    19.609     0.200
     1.713    53.609     0.200
     0.946    32.461     0.200
     1.051    35.461     0.200
     1.402    46.461     0.200
     1.735    53.461     0.200
     1.855    57.461     0.200
     2.064    62.461     0.200
     0.766    27.609     0.200
     0.855    28.609     0.200
     1.155    37.609     0.200
     1.352    43.609     0.200
     1.455    46.609     0.200
     1.656    52.609     0.200
     2.121    63.609     0.200
     0.804    28.898     0.200
     1.049    34.898     0.200
     1.506    49.898     0.200
     2.181    66.898     0.200
     0.842    28.043     0.200
     0.976    31.543     0.200
     1.280    41.543     0.200
     1.757    54.043     0.200
     2.036    61.543     0.200
     0.313    14.535     0.200
     0.815    27.535     0.200
     0.947    31.535     0.200
     1.082    34.535     0.200
     1.263    40.535     0.200
     0.765    26.020     0.200
     0.771    27.520     0.200
     0.996    33.020     0.200
     1.529    48.020     0.200
     0.843    28.875     0.200
     0.926    32.086     0.200
     1.337    44.875     0.200
     1.643    51.875     0.200
     1.966    61.875     0.200
     2.091    63.875     0.200
     2.412    70.875     0.200
     0.104     5.570     0.200
     0.866    31.570     0.200
     1.036    36.570     0.200
     1.918    60.070     0.200
     0.926    32.533     0.200
     1.332    43.322     0.200
     1.625    51.322     0.200
     4.099   122.322     0.200
     4.657   138.322     0.200
     7.055   206.463     0.200
     1.064    34.620     0.200
     2.933    85.800     0.200
     0.212     9.531     0.200
     0.569    20.531     0.200
     1.053    36.531     0.200
     1.485    48.531     0.200
     2.414    71.531     0.200
     0.117     8.320     0.200
     1.987    59.820     0.200
     0.345    11.584     0.200
     0.603    22.584     0.200
     1.008    35.584     0.200
     0.977    32.664     0.200
     0.471    18.867     0.200
     1.088    34.867     0.200
     1.290    39.867     0.200
     1.639    51.805     0.200
     2.254    66.047     0.200
     2.404    71.965     0.200
     2.409    71.969     0.200
     2.417    72.148     0.200
     3.429    97.258     0.200
     0.599    20.692     0.200
     0.599    21.192     0.200
     1.028    37.192     0.200
     1.232    42.692     0.200
     0.148     4.930     0.200
     0.305    11.930     0.200
     0.970    32.930     0.200
     1.284    41.930     0.200
     1.643    52.992     0.200
     1.868    58.930     0.200
     0.775    26.562     0.200
     0.964    31.562     0.200
     1.270    40.562     0.200
     2.327    68.562     0.200
     0.553    18.715     0.200
     0.537    18.715     0.200
     1.181    39.715     0.200
     1.439    46.715     0.200
     1.657    52.715     0.200
     1.807    56.715     0.200
     2.099    65.914     0.200
     0.258    11.734     0.200
     0.757    27.734     0.200
     1.197    37.234     0.200
     1.404    43.734     0.200
     1.633    51.734     0.200
     1.820    56.734     0.200
     1.773    55.734     0.200
     2.010    59.734     0.200
     2.119    63.734     0.200
     0.285    12.467     0.200
     1.537    48.467     0.200
     1.530    50.467     0.200
     1.701    52.467     0.200
     1.600    51.066     0.200
     1.667    53.666     0.200
     1.979    62.467     0.200
     0.286    11.291     0.200
     0.518    18.791     0.200
     1.541    49.791     0.200
     1.553    50.791     0.200
     0.464    17.812     0.200
     0.581    20.812     0.200
     1.087    37.312     0.200
     1.240    42.312     0.200
     1.342    45.312     0.200
     0.250     9.992     0.200
     0.447    16.992     0.200
     0.714    23.992     0.200
     1.247    39.992     0.200
     1.471    46.992     0.200
     0.937    32.605     0.200
     1.336    44.605     0.200
     0.610    19.586     0.200
     0.610    20.586     0.200
     0.554    19.586     0.200
     0.554    20.586     0.200
     1.537    51.586     0.200
     1.630    52.586     0.200
     0.672    25.070     0.200
     0.807    27.070     0.200
     1.020    34.070     0.200
     1.152    37.070     0.200
     1.503    47.070     0.200
     1.642    51.070     0.200
     2.153    64.070     0.200
     0.233     8.617     0.200
     0.368    14.617     0.200
     0.308    12.752     0.200
     0.636    21.752     0.200
     0.917    31.752     0.200
     1.254    40.252     0.200
     0.844    29.508     0.200
     1.427    47.008     0.200
     0.779    27.562     0.200
     0.858    28.562     0.200
     1.045    32.562     0.200
     1.435    46.562     0.200
     1.914    59.562     0.200
     2.233    66.562     0.200
     0.301    10.539     0.200
     0.396    15.539     0.200
     1.135    38.539     0.200
     0.201     8.609     0.200
     0.832    29.609     0.200
     0.695    26.199     0.200
     0.968    33.199     0.200
     0.432    16.525     0.200
     0.862    30.525     0.200
     0.753    24.525     0.200
     1.117    38.525     0.200
     0.289    10.906     0.200
     0.497    18.406     0.200
     1.332    42.906     0.200
     1.534    49.406     0.200
     0.668    23.422     0.200
     0.876    29.422     0.200
     0.967    32.422     0.200
     0.621    22.285     0.200
     0.970    33.285     0.200
     1.663    52.285     0.200
     0.666    24.676     0.200
     1.734    55.676     0.200
     1.996    61.676     0.200
     0.457    16.990     0.200
     0.580    21.990     0.200
     1.545    49.990     0.200
     1.386    44.990     0.200
     0.301    12.289     0.200
     0.518    19.289     0.200
     0.654    23.289     0.200
     1.219    40.289     0.200
     1.193    39.289     0.200
     1.211    40.289     0.200
     0.550    19.113     0.200
     1.100    36.113     0.200
     1.516    48.176     0.200
     1.482    48.113     0.200
     1.294    42.383     0.200
     1.721    54.383     0.200
     1.918    59.383     0.200
     0.276    10.875     0.200
     0.329    11.875     0.200
     1.588    50.875     0.200
     1.774    54.875     0.200
     0.662    24.102     0.200
     1.375    43.102     0.200
     1.671    52.102     0.200
     1.768    56.102     0.200
     2.336    69.602     0.200
     0.103    10.154     0.200
     0.589    21.154     0.200
     1.702    51.154     0.200
     0.459    18.254     0.200
     2.354    71.254     0.200
     0.605    20.867     0.200
     0.640    22.867     0.200
     0.932    30.867     0.200
     0.968    32.867     0.200
     1.017    34.867     0.200
     1.641    51.867     0.200
     0.244    10.727     0.200
     1.359    43.727     0.200
     1.578    48.727     0.200
     0.276    10.104     0.200
     1.664    53.104     0.200
     1.992    62.104     0.200
     1.442    44.875     0.200
     1.446    44.898     0.200
     1.451    44.883     0.200
     1.443    47.500     0.200
     2.275    69.500     0.200
     0.595    22.195     0.200
     1.043    35.195     0.200
     1.169    39.680     0.200
     1.233    41.195     0.200
     1.295    43.195     0.200
     1.995    62.195     0.200
     0.671    22.973     0.200
     0.491    18.648     0.200
     0.556    19.938     0.200
     1.449    47.938     0.200
     0.470    18.528     0.200
     0.784    28.528     0.200
     1.335    42.528     0.200
     0.295    11.422     0.200
     0.535    20.703     0.200
     0.589    21.703     0.200
     0.589    20.703     0.200
     1.348    43.590     0.200
     1.509    47.703     0.200
     1.868    56.703     0.200
     2.144    64.703     0.200
     0.627    22.117     0.200
     0.669    24.117     0.200
     1.169    41.117     0.200
     1.161    40.117     0.200
     1.455    48.117     0.200
     2.000    62.117     0.200
     0.457    16.505     0.200
     0.645    23.505     0.200
     0.789    27.505     0.200
     0.976    32.505     0.200
     0.542    18.830     0.200
     0.915    30.830     0.200
     0.483    17.484     0.200
     0.587    21.484     0.200
     0.336    12.789     0.200
     0.641    21.789     0.200
     1.117    35.789     0.200
     1.293    41.789     0.200
     1.605    49.789     0.200
     1.380    44.584     0.200
     1.820    57.584     0.200
     0.321    11.711     0.200
     1.021    35.711     0.200
     0.253    11.328     0.200
     0.552    19.328     0.200
     0.391    13.887     0.200
     1.783    55.887     0.200
     0.380    13.525     0.200
     1.179    42.426     0.200
     1.797    59.525     0.200
     0.812    28.040     0.200
     0.425    15.298     0.200
     0.633    23.298     0.200
     1.201    38.298     0.200
     1.388    44.198     0.200
     1.683    52.641     0.200
     0.234     8.148     0.200
     1.795    56.852     0.200
     0.083     6.950     0.200
     1.378    44.175     0.200
     1.378    44.850     0.200
     2.213    66.210     0.200
     2.217    66.250     0.200
     2.224    67.551     0.200
     2.224    65.450     0.200
     0.937    31.511     0.200
     1.474    47.641     0.200
     2.065    62.574     0.200
     2.069    62.611     0.200
     1.079    36.312     0.200
     0.523    19.250     0.200
     0.671    24.805     0.200
     1.884    58.891     0.200
     1.884    60.219     0.200
     2.081    65.633     0.200
     0.883    31.508     0.200
     1.504    49.959     0.200
     1.838    58.283     0.200
     1.990    62.289     0.200
     3.107    94.379     0.200
     3.640   105.572     0.200
     0.307    12.227     0.200
     0.451    15.500     0.200
     1.942    59.852     0.200
     2.974    90.555     0.200
     0.336    14.703     0.200
     2.177    64.977     0.200
     2.428    71.766     0.200
     2.487    74.828     0.200
     3.224    92.828     0.200
     3.500   102.000     0.200
     0.254    10.000     0.200
     0.444    16.586     0.200
     0.471    16.828     0.200
     0.582    20.805     0.200
     1.343    43.531     0.200
     1.727    54.445     0.200
     1.847    57.867     0.200
     1.963    60.945     0.200
     2.586    77.250     0.200
     2.676    80.016     0.200
     3.289    95.102     0.200
     3.390    98.680     0.200
     0.234     9.684     0.200
     0.417    15.133     0.200
     0.486    16.988     0.200
     0.594    20.770     0.200
     1.670    54.246     0.200
     1.588    52.023     0.200
     1.992    63.023     0.200
     1.992    62.441     0.200
     1.981    63.125     0.200
     0.479    17.016     0.200
     0.933    31.477     0.200
     1.531    48.105     0.200
     1.525    48.828     0.200
     1.557    49.914     0.200
     1.530    49.914     0.200
     1.684    56.059     0.200
     0.607    20.270     0.200
     2.040    64.811     0.200
     0.587    19.693     0.200
     1.299    42.555     0.200
     1.299    42.180     0.200
     1.839    56.941     0.200
     1.839    60.803     0.200
     0.321    12.902     0.200
     0.584    19.625     0.200
     1.641    52.980     0.200
     2.368    72.648     0.200
     3.518   105.836     0.200
     3.758   111.637     0.200
     0.835    28.047     0.200
     0.754    26.660     0.200
     1.495    45.812     0.200
     1.477    46.977     0.200
     1.388    46.887     0.200
     1.762    56.184     0.200
     1.898    56.488     0.200
     1.898    57.016     0.200
     2.043    62.039     0.200
     2.582    77.453     0.200
     3.589   103.273     0.200
     0.994    34.462     0.200
     1.045    33.953     0.200
     1.291    43.609     0.200
     1.484    51.116     0.200
     1.599    52.926     0.200
     2.052    64.431     0.200
     2.450    75.269     0.200
     0.662    24.539     0.200
     0.661    23.883     0.200
     0.728    27.184     0.200
     0.782    27.504     0.200
     1.110    37.613     0.200
     1.503    48.883     0.200
     1.365    45.945     0.200
     2.167    68.324     0.200
     2.487    77.242     0.200
     2.470    73.742     0.200
     2.683    82.508     0.200
     2.855    86.133     0.200
     3.243    95.027     0.200
     3.408   100.625     0.200
     3.462   100.953     0.200
     1.170    39.547     0.200
     1.509    47.195     0.200
     2.733    81.281     0.200
     2.801    82.328     0.200
     3.262    95.891     0.200
     3.304    95.891     0.200
     3.801   108.758     0.200
     0.352    11.770     0.200
     0.927    30.844     0.200
     1.532    50.910     0.200
     1.630    55.227     0.200
     2.205    68.902     0.200
     2.352    75.664     0.200
     0.084     5.172     0.200
     0.641    22.789     0.200
     1.383    45.438     0.200
     1.815    55.883     0.200
     2.416    74.758     0.200
     2.575    79.586     0.200
     2.599    79.977     0.200
     0.191     7.906     0.200
     1.504    48.305     0.200
     1.634    52.938     0.200
     1.855    58.898     0.200
     1.924    60.555     0.200
     2.053    65.188     0.200
     0.476    17.423     0.200
     0.807    27.404     0.200
     1.050    36.832     0.200
     2.032    62.810     0.200
     2.537    76.893     0.200
     3.136    95.831     0.200
     0.542    20.125     0.200
     0.730    25.344     0.200
     0.819    27.628     0.200
     1.008    33.081     0.200
     1.144    38.852     0.200
     1.536    51.001     0.200
     1.710    54.772     0.200
     1.768    55.900     0.200
     1.779    55.597     0.200
     1.758    56.414     0.200
     2.838    86.951     0.200
     3.566   104.354     0.200
     3.764   113.159     0.200
     0.768    27.111     0.200
     1.403    48.455     0.200
     1.838    58.000     0.200
     2.017    63.438     0.200
     2.556    78.010     0.200
     2.814    85.656     0.200
     3.712   113.070     0.200
     0.504    18.793     0.200
     0.742    26.254     0.200
     1.763    54.148     0.200
     1.841    55.672     0.200
     0.559    20.453     0.200
     0.769    26.941     0.200
     1.074    35.523     0.200
     1.617    50.391     0.200
     1.674    52.160     0.200
     1.895    58.395     0.200
     1.947    57.098     0.200
     2.529    74.871     0.200
     3.283    98.215     0.200
     3.411    99.086     0.200
     5.128   149.730     0.200
     0.589    20.314     0.200
     0.934    32.553     0.200
     2.097    64.652     0.200
     0.354    11.690     0.200
     0.566    19.516     0.200
     1.256    42.172     0.200
     1.750    55.189     0.200
     1.999    62.142     0.200
     2.351    73.229     0.200
     2.444    75.018     0.200
     2.639    80.517     0.200
     2.982    91.656     0.200
     0.111     7.216     0.200
     0.315    12.455     0.200
     0.446    15.982     0.200
     1.168    36.686     0.200
     1.690    53.713     0.200
     2.461    75.978     0.200
     2.601    77.497     0.200
     0.804    27.562     0.200
     1.094    34.922     0.200
     1.220    38.523     0.200
     2.090    63.000     0.200
     1.548    51.430     0.200
     1.691    54.805     0.200
     1.795    57.016     0.200
     0.631    23.156     0.200
     0.993    33.203     0.200
     2.710    79.398     0.200
     2.989    87.406     0.200
     0.669    24.519     0.200
     2.806    85.422     0.200
     3.125    93.936     0.200
     0.334    11.680     0.200
     0.916    31.570     0.200
     0.991    34.859     0.200
     1.807    57.727     0.200
     2.915    86.375     0.200
     0.273    10.512     0.200
     0.898    31.820     0.200
     1.920    61.691     0.200
     0.618    22.115     0.200
     1.251    40.080     0.200
     1.373    43.453     0.200
     1.949    57.680     0.200
     2.174    68.375     0.200
     2.974    90.211     0.200
     3.082    89.381     0.200
     0.339    13.012     0.200
     1.517    49.562     0.200
     1.638    51.047     0.200
     1.904    59.047     0.200
     2.031    65.258     0.200
     2.194    66.492     0.200
     2.287    69.473     0.200
     2.505    73.695     0.200
     2.679    80.348     0.200
     2.738    81.102     0.200
     3.117    88.969     0.200
     0.584    20.070     0.200
     0.760    27.602     0.200
     1.490    49.977     0.200
     1.796    57.133     0.200
     2.868    87.898     0.200
     3.017    90.008     0.200
     3.529   104.617     0.200
     4.084   118.492     0.200
     0.412    14.949     0.200
     0.542    19.086     0.200
     0.791    26.477     0.200
     1.858    56.555     0.200
     1.749    53.953     0.200
     1.975    61.344     0.200
     2.144    67.254     0.200
     2.186    66.660     0.200
     2.420    74.047     0.200
     2.696    78.184     0.200
     2.851    82.914     0.200
     1.146    40.356     0.200
     1.219    42.145     0.200
     1.396    46.702     0.200
     1.559    51.407     0.200
     1.744    56.885     0.200
     1.772    58.388     0.200
     1.978    63.215     0.200
     2.050    64.737     0.200
     2.752    83.265     0.200
     3.230    95.884     0.200
     0.363    15.832     0.200
     1.125    36.777     0.200
     0.966    31.230     0.200
     1.139    37.590     0.200
     1.407    43.762     0.200
     1.638    50.742     0.200
     1.580    50.750     0.200
     2.025    61.969     0.200
     5.668   162.688     0.200
     0.875    30.391     0.200
     1.018    34.289     0.200
     1.003    33.289     0.200
     1.003    33.156     0.200
     1.449    47.328     0.200
     2.133    67.195     0.200
     2.141    67.977     0.200
     2.291    69.953     0.200
     3.342    96.984     0.200
     0.284    12.953     0.200
     0.434    17.676     0.200
     0.605    20.816     0.200
     1.003    31.348     0.200
     1.076    35.945     0.200
     1.396    44.641     0.200
     1.324    42.727     0.200
     0.183     9.219     0.200
     0.857    29.422     0.200
     1.110    35.484     0.200
     1.079    35.367     0.200
     1.681    51.961     0.200
     1.757    55.727     0.200
     1.866    59.359     0.200
     2.278    69.820     0.200
     0.384    13.119     0.200
     0.524    17.679     0.200
     0.604    20.285     0.200
     1.690    55.433     0.200
     2.021    64.653     0.200
     2.713    82.914     0.200
     2.949    87.386     0.200
     0.103     7.043     0.200
     0.492    16.855     0.200
     1.371    44.943     0.200
     1.611    51.527     0.200
     1.602    53.047     0.200
     1.744    55.072     0.200
     1.816    55.766     0.200
     1.904    58.869     0.200
     2.174    67.748     0.200
     2.189    65.783     0.200
     2.372    72.568     0.200
     2.458    75.043     0.200
     2.774    84.961     0.200
     2.967    87.812     0.200
     3.044    90.812     0.200
     3.347   101.465     0.200
     0.938    32.234     0.200
     1.022    36.984     0.200
     1.572    52.023     0.200
     2.195    68.332     0.200
     2.350    74.359     0.200
     2.816    85.492     0.200
     2.772    85.258     0.200
     0.096     6.547     0.200
     0.202     9.336     0.200
     1.364    45.070     0.200
     1.822    56.402     0.200
     1.903    60.559     0.200
     2.196    65.859     0.200
     2.373    73.004     0.200
     2.451    75.871     0.200
     2.459    75.793     0.200
     2.459    74.984     0.200
     2.777    83.918     0.200
     0.448    17.129     0.200
     0.615    21.793     0.200
     0.716    24.273     0.200
     1.444    46.000     0.200
     1.357    44.215     0.200
     1.595    51.707     0.200
     1.671    52.477     0.200
     2.135    64.156     0.200
     2.733    79.887     0.200
     2.994    88.703     0.200
     0.474    17.453     0.200
     1.560    50.635     0.200
     1.637    53.951     0.200
     1.901    60.832     0.200
     2.082    64.826     0.200
     2.139    65.758     0.200
     2.692    82.768     0.200
     2.760    82.443     0.200
     3.011    91.545     0.200
     3.373    97.156     0.200
     3.421    99.285     0.200
     0.495    17.787     0.200
     0.664    24.248     0.200
     0.751    24.874     0.200
     1.328    44.836     0.200
     1.544    50.719     0.200
     1.881    60.862     0.200
     2.087    63.830     0.200
     2.087    65.294     0.200
     2.188    67.688     0.200
     2.167    68.281     0.200
     2.334    70.359     0.200
     2.479    73.920     0.200
     2.780    82.526     0.200
     3.030    92.023     0.200
     0.667    24.543     0.200
     1.493    49.707     0.200
     1.719    53.691     0.200
     1.847    58.191     0.200
     2.151    65.980     0.200
     2.165    70.527     0.200
     2.184    67.926     0.200
     0.776    27.953     0.200
     0.834    28.688     0.200
     0.874    31.598     0.200
     1.374    45.156     0.200
     1.610    53.465     0.200
     1.713    57.277     0.200
     1.796    58.770     0.200
     1.963    64.703     0.200
     2.283    70.758     0.200
     0.802    29.547     0.200
     0.863    30.062     0.200
     0.943    33.018     0.200
     1.770    59.775     0.200
     1.730    58.965     0.200
     1.938    63.905     0.200
     1.910    62.942     0.200
     3.147    92.868     0.200
     0.336    11.683     0.200
     0.557    21.125     0.200
     0.840    29.872     0.200
     1.033    34.300     0.200
     1.185    38.807     0.200
     2.351    71.786     0.200
     2.364    72.561     0.200
     2.515    76.531     0.200
     2.958    87.188     0.200
     3.717   111.920     0.200
     0.356    12.844     0.200
     0.551    21.590     0.200
     0.638    21.418     0.200
     0.787    29.547     0.200
     1.623    53.355     0.200
     1.657    55.277     0.200
     1.683    56.105     0.200
     1.821    59.234     0.200
     2.106    67.129     0.200
     2.278    71.898     0.200
     2.219    69.441     0.200
     2.303    71.793     0.200
     2.810    84.570     0.200
     3.465   101.957     0.200
     3.524   103.297     0.200
     4.334   125.867     0.200
     0.126    10.254     0.200
     0.397    16.082     0.200
     0.521    19.918     0.200
     0.564    20.336     0.200
     2.651    78.902     0.200
     2.408    73.531     0.200
     0.867    30.204     0.200
     0.851    30.909     0.200
     1.496    49.812     0.200
     1.566    51.288     0.200
     2.312    74.896     0.200
     2.414    78.436     0.200
     2.906    89.213     0.200
     3.188    96.465     0.200
     3.221    96.497     0.200
     0.620    21.676     0.200
     1.181    37.246     0.200
     1.814    54.695     0.200
     1.827    53.840     0.200
     1.817    56.125     0.200
     2.011    61.234     0.200
     2.157    62.703     0.200
     2.188    64.992     0.200
     2.468    71.859     0.200
     0.451    16.926     0.200
     0.603    21.160     0.200
     0.636    22.203     0.200
     1.215    39.672     0.200
     1.713    55.578     0.200
     1.750    53.492     0.200
     1.760    55.578     0.200
     1.839    57.406     0.200
     1.900    56.883     0.200
     2.041    63.922     0.200
     2.203    68.617     0.200
     2.188    65.227     0.200
     2.259    67.836     0.200
     2.788    82.699     0.200
     0.210     8.336     0.200
     0.460    17.168     0.200
     0.634    21.238     0.200
     0.695    23.824     0.200
     1.355    43.910     0.200
     1.429    45.320     0.200
     1.574    50.336     0.200
     1.652    52.520     0.200
     2.474    74.137     0.200
     2.999    90.969     0.200
     3.364    96.570     0.200
     0.631    22.605     0.200
     0.818    27.293     0.200
     1.288    41.246     0.200
     1.285    42.523     0.200
     1.412    45.070     0.200
     1.912    58.707     0.200
     2.044    62.910     0.200
     2.040    63.805     0.200
     2.146    66.324     0.200
     2.253    68.777     0.200
     2.677    76.812     0.200
     2.854    83.848     0.200
     2.910    83.090     0.200
     0.898    30.955     0.200
     1.350    44.883     0.200
     1.497    49.189     0.200
     1.552    49.334     0.200
     1.693    55.152     0.200
     0.910    32.539     0.200
     1.764    56.703     0.200
     1.884    61.094     0.200
     2.893    86.812     0.200
     3.173    96.945     0.200
     0.156     7.279     0.200
     0.507    17.543     0.200
     1.659    52.957     0.200
     1.825    57.969     0.200
     1.872    60.574     0.200
     0.873    31.395     0.200
     0.916    31.954     0.200
     1.446    48.399     0.200
     1.497    48.412     0.200
     1.834    58.871     0.200
     1.750    56.104     0.200
     1.766    56.799     0.200
     2.614    79.649     0.200
     2.565    77.792     0.200
     0.494    19.879     0.200
     0.681    23.879     0.200
     0.888    30.676     0.200
     0.907    30.977     0.200
     1.497    46.668     0.200
     1.555    49.602     0.200
     1.721    53.113     0.200
     1.858    56.262     0.200
     0.170     8.406     0.200
     0.675    24.336     0.200
     1.812    56.805     0.200
     2.109    65.812     0.200
     3.405   103.297     0.200
     0.632    21.744     0.200
     0.720    24.215     0.200
     1.930    62.857     0.200
     2.167    66.758     0.200
     2.733    83.436     0.200
     0.801    28.094     0.200
     0.858    29.474     0.200
     0.994    34.973     0.200
     1.821    58.087     0.200
     2.151    66.516     0.200
     2.588    75.789     0.200
     0.825    29.180     0.200
     1.434    47.285     0.200
     1.521    48.316     0.200
     1.505    49.785     0.200
     1.531    49.973     0.200
     1.810    56.773     0.200
     1.810    58.004     0.200
     1.810    57.422     0.200
     2.730    81.613     0.200
     0.251    12.879     0.200
     0.687    22.676     0.200
     0.137     6.943     0.200
     1.783    56.283     0.200
     0.488    16.516     0.200
     0.579    20.395     0.200
     1.643    50.863     0.200
     1.833    57.844     0.200
     0.802    29.391     0.200
     0.885    30.219     0.200
     0.973    33.672     0.200
     1.300    43.188     0.200
     1.176    40.695     0.200
     1.427    49.086     0.200
     1.701    55.906     0.200
     1.643    52.859     0.200
     1.778    56.578     0.200
     1.882    61.281     0.200
     2.231    69.852     0.200
     0.662    23.078     0.200
     0.986    32.898     0.200
     1.443    47.500     0.200
     1.353    43.299     0.200
     1.397    45.117     0.200
     2.183    65.586     0.200
     2.110    64.793     0.200
     0.726    24.367     0.200
     0.914    32.086     0.200
     1.044    34.672     0.200
     1.457    46.961     0.200
     1.983    65.070     0.200
     2.214    69.594     0.200
     2.848    86.086     0.200
     0.552    20.742     0.200
     0.831    28.318     0.200
     1.180    40.682     0.200
     1.186    38.787     0.200
     1.250    42.174     0.200
     1.533    51.018     0.200
     0.772    26.789     0.200
     0.584    20.828     0.200
     0.702    24.594     0.200
     1.727    53.852     0.200
     2.311    72.039     0.200
     2.003    60.734     0.200
     2.724    82.328     0.200
     2.855    83.258     0.200
     3.598   103.836     0.200
     0.705    24.500     0.200
     0.701    23.523     0.200
     0.876    31.703     0.200
     1.040    36.727     0.200
     1.353    43.430     0.200
     2.822    84.453     0.200
     3.064    93.242     0.200
     0.608    21.872     0.200
     0.955    32.890     0.200
     1.420    42.792     0.200
     1.239    40.499     0.200
     1.407    44.476     0.200
     1.959    59.540     0.200
     2.173    63.914     0.200
     2.743    80.531     0.200
     2.962    85.550     0.200
     3.234    93.098     0.200
     4.143   118.522     0.200
     0.675    23.195     0.200
     0.753    26.391     0.200
     1.070    36.773     0.200
     0.856    30.227     0.200
     1.880    57.500     0.200
     1.686    55.820     0.200
     1.937    63.094     0.200
     2.106    65.172     0.200
     0.563    20.789     0.200
     0.727    26.312     0.200
     0.841    28.266     0.200
     1.125    35.242     0.200
     1.142    35.867     0.200
     1.392    45.508     0.200
     1.620    51.055     0.200
     1.749    55.625     0.200
     1.951    60.883     0.200
     1.939    60.016     0.200
     2.063    63.484     0.200
     2.296    68.656     0.200
     2.382    71.820     0.200
     3.026    88.859     0.200
     0.519    19.523     0.200
     0.696    24.633     0.200
     0.918    30.961     0.200
     1.352    44.484     0.200
     1.259    41.102     0.200
     1.443    48.047     0.200
     1.520    48.141     0.200
     1.678    51.172     0.200
     2.442    72.969     0.200
     0.865    30.127     0.200
     0.915    32.287     0.200
     0.991    35.607     0.200
     1.788    58.219     0.200
     1.923    59.227     0.200
     3.708   108.678     0.200
     0.570    22.109     0.200
     0.815    28.547     0.200
     1.364    43.789     0.200
     1.412    45.828     0.200
     1.686    51.406     0.200
     1.764    56.984     0.200
     1.831    58.742     0.200
     1.939    58.414     0.200
     0.920    32.520     0.200
     1.386    43.949     0.200
     1.906    62.445     0.200
     0.944    32.170     0.200
     1.034    36.000     0.200
     1.121    39.062     0.200
     1.636    54.104     0.200
     1.636    52.684     0.200
     1.758    58.676     0.200
     2.082    64.863     0.200
     0.769    28.234     0.200
     0.769    27.938     0.200
     1.443    47.266     0.200
     1.851    57.109     0.200
     1.892    60.211     0.200
     2.069    64.984     0.200
     0.805    28.102     0.200
     0.925    31.484     0.200
     1.513    49.020     0.200
     1.874    59.188     0.200
     1.861    57.379     0.200
     2.013    64.551     0.200
     2.086    64.992     0.200
     0.176     7.525     0.200
     0.675    23.209     0.200
     0.756    25.873     0.200
     1.822    60.893     0.200
     2.101    63.371     0.200
     2.174    65.371     0.200
     3.046    91.242     0.200
     0.193     7.879     0.200
     0.953    32.699     0.200
     1.250    41.000     0.200
     0.940    34.371     0.200
     1.416    47.129     0.200
     1.503    48.855     0.200
     1.445    48.242     0.200
     1.693    54.121     0.200
     1.693    54.605     0.200
     1.705    55.785     0.200
     1.619    51.562     0.200
     1.758    56.125     0.200
     1.982    62.586     0.200
     1.917    59.293     0.200
     1.998    62.855     0.200
     2.056    64.797     0.200
     2.902    86.426     0.200
     2.973    90.453     0.200
     0.236    10.422     0.200
     0.746    23.641     0.200
     0.746    25.688     0.200
     1.333    43.461     0.200
     1.467    45.031     0.200
     1.528    48.109     0.200
     1.659    52.461     0.200
     2.022    61.359     0.200
     2.323    68.938     0.200
     2.570    73.883     0.200
     0.463    17.251     0.200
     1.220    37.621     0.200
     1.352    41.604     0.200
     0.856    28.688     0.200
     1.130    36.820     0.200
     1.696    54.656     0.200
     1.759    58.633     0.200
     2.348    70.977     0.200
     1.909    60.352     0.200
     1.906    56.383     0.200
     2.080    63.125     0.200
     2.857    82.164     0.200
     0.893    31.422     0.200
     1.270    41.328     0.200
     1.298    43.836     0.200
     1.321    45.344     0.200
     1.669    54.773     0.200
     1.757    59.664     0.200
     1.832    60.234     0.200
     1.905    61.609     0.200
     0.577    20.820     0.200
     1.113    35.195     0.200
     1.383    44.180     0.200
     1.735    54.441     0.200
     1.938    56.828     0.200
     2.085    63.719     0.200
     2.702    78.848     0.200
     2.705    78.715     0.200
     2.956    85.918     0.200
     3.104    90.355     0.200
     0.555    20.594     0.200
     0.756    25.961     0.200
     0.796    27.664     0.200
     0.845    28.680     0.200
     1.080    36.686     0.200
     1.596    50.746     0.200
     1.704    54.459     0.200
     1.895    58.340     0.200
     1.973    59.889     0.200
     1.975    60.529     0.200
     2.024    64.619     0.200
     2.086    64.586     0.200
     3.263    96.898     0.200
     3.381   100.055     0.200
     0.682    23.380     0.200
     0.618    21.896     0.200
     0.857    29.431     0.200
     0.973    32.513     0.200
     1.170    36.737     0.200
     1.261    40.618     0.200
     1.339    43.929     0.200
     1.386    45.070     0.200
     1.470    49.294     0.200
     0.324    12.711     0.200
     0.937    30.852     0.200
     1.492    45.398     0.200
     1.560    47.555     0.200
     2.196    65.961     0.200
     2.208    65.875     0.200
     2.318    71.203     0.200
     2.420    72.969     0.200
     0.226    10.316     0.200
     1.360    41.870     0.200
     1.467    46.435     0.200
     1.598    50.242     0.200
     2.414    71.583     0.200
     0.264    10.994     0.200
     0.871    28.555     0.200
     0.871    28.848     0.200
     1.321    41.609     0.200
     1.425    46.113     0.200
     1.556    48.096     0.200
     1.630    50.955     0.200
     2.414    73.020     0.200
     2.446    71.520     0.200
     2.491    76.545     0.200
     0.724    25.859     0.200
     0.807    29.391     0.200
     1.084    36.125     0.200
     1.379    43.836     0.200
     1.489    47.844     0.200
     1.634    53.305     0.200
     1.825    55.750     0.200
     1.825    56.273     0.200
     1.902    58.469     0.200
     2.045    63.086     0.200
     2.441    73.469     0.200
     0.513    17.840     0.200
     0.434    15.762     0.200
     0.705    24.035     0.200
     1.115    37.465     0.200
     1.381    45.516     0.200
     1.813    55.562     0.200
     0.496    17.793     0.200
     0.516    18.207     0.200
     1.052    35.883     0.200
     1.330    41.789     0.200
     1.510    50.059     0.200
     1.687    54.891     0.200
     1.795    57.836     0.200
     2.328    70.641     0.200
     0.604    21.688     0.200
     0.879    31.449     0.200
     1.423    46.898     0.200
     1.424    46.906     0.200
     1.771    56.016     0.200
     0.719    24.320     0.200
     0.825    25.750     0.200
     0.942    30.555     0.200
     1.233    37.699     0.200
     1.233    38.207     0.200
     1.282    41.062     0.200
     1.259    39.395     0.200
     1.387    44.473     0.200
     1.963    60.781     0.200
     0.803    27.617     0.200
     1.037    34.773     0.200
     1.439    46.930     0.200
     1.520    49.141     0.200
     1.515    47.242     0.200
     1.551    50.344     0.200
     1.545    50.930     0.200
     1.698    52.367     0.200
     1.069    34.989     0.200
     1.127    37.795     0.200
     1.158    39.001     0.200
     1.451    45.951     0.200
     1.628    52.188     0.200
     0.368    12.977     0.200
     1.314    42.367     0.200
     1.646    51.914     0.200
     1.740    55.070     0.200
     1.903    59.734     0.200
     2.459    74.422     0.200
     0.212     7.734     0.200
     0.972    34.078     0.200
     0.995    34.289     0.200
     1.062    34.477     0.200
     1.100    36.352     0.200
     1.291    42.203     0.200
     1.422    46.781     0.200
     1.565    49.336     0.200
     2.019    62.688     0.200
     2.291    69.305     0.200
     2.427    73.836     0.200
     0.336    12.172     0.200
     0.416    14.953     0.200
     0.679    23.930     0.200
     0.841    29.312     0.200
     1.134    37.008     0.200
     1.087    36.344     0.200
     1.735    56.273     0.200
     2.528    77.141     0.200
     2.521    76.078     0.200
     2.609    79.062     0.200
     2.696    81.078     0.200
     2.778    83.023     0.200
     2.822    83.102     0.200
     2.940    86.586     0.200
     3.031    88.180     0.200
     0.735    25.438     0.200
     1.531    47.852     0.200
     1.531    48.008     0.200
     1.669    54.844     0.200
     1.943    60.773     0.200
     2.341    74.242     0.200
     2.600    78.398     0.200
     3.197    94.578     0.200
     0.698    25.602     0.200
     0.957    32.078     0.200
     1.110    37.547     0.200
     1.114    37.500     0.200
     1.327    42.000     0.200
     1.413    47.914     0.200
     1.654    53.852     0.200
     1.676    53.492     0.200
     1.832    57.578     0.200
     2.207    68.852     0.200
     0.735    25.488     0.200
     0.727    25.459     0.200
     1.108    36.654     0.200
     1.865    61.500     0.200
     2.152    66.406     0.200
     2.233    69.521     0.200
     2.495    76.834     0.200
     3.482   102.881     0.200
     0.700    22.422     0.200
     1.133    39.297     0.200
     1.467    50.324     0.200
     0.587    21.359     0.200
     0.896    31.623     0.200
     1.130    39.254     0.200
     1.146    38.886     0.200
     1.422    47.688     0.200
     1.653    53.395     0.200
     1.738    57.332     0.200
     2.358    72.349     0.200
     2.369    71.680     0.200
     0.712    25.846     0.200
     1.537    50.120     0.200
     2.342    74.422     0.200
     2.333    71.108     0.200
     2.333    70.823     0.200
     2.865    85.835     0.200
     3.200    93.363     0.200
     0.845    26.906     0.200
     1.348    43.021     0.200
     1.440    47.396     0.200
     1.406    46.544     0.200
     1.848    57.362     0.200
     2.184    66.000     0.200
     2.174    68.938     0.200
     2.694    80.576     0.200
     2.914    86.680     0.200
     0.331    14.523     0.200
     1.052    33.328     0.200
     1.375    43.133     0.200
     1.507    46.234     0.200
     0.321    13.984     0.200
     0.984    32.883     0.200
     1.241    39.348     0.200
     1.360    41.406     0.200
     1.306    40.211     0.200
     1.400    42.969     0.200
     1.532    46.172     0.200
     1.974    59.609     0.200
     0.477    17.633     0.200
     0.595    21.426     0.200
     0.735    25.398     0.200
     0.966    31.977     0.200
     1.135    38.945     0.200
     1.828    58.914     0.200
     2.303    72.973     0.200
     2.200    70.543     0.200
     2.247    70.930     0.200
     0.312    11.613     0.200
     1.377    44.871     0.200
     1.557    50.941     0.200
     1.509    48.523     0.200
     1.958    60.291     0.200
     0.529    18.859     0.200
     0.914    28.752     0.200
     0.934    31.290     0.200
     1.112    36.696     0.200
     1.283    41.835     0.200
     1.833    56.420     0.200
     1.918    58.606     0.200
     2.227    69.072     0.200
     2.337    71.204     0.200
     2.524    74.839     0.200
     3.472   102.870     0.200
     0.745    24.516     0.200
     0.790    25.578     0.200
     1.323    44.570     0.200
     1.389    46.266     0.200
     1.462    47.070     0.200
     1.522    47.312     0.200
     2.033    64.242     0.200
     2.338    69.914     0.200
     2.395    72.211     0.200
     0.650    23.715     0.200
     0.647    22.746     0.200
     0.892    30.812     0.200
     0.994    34.863     0.200
     1.304    40.355     0.200
     1.283    42.195     0.200
     1.409    45.734     0.200
     1.895    60.082     0.200
     2.018    61.129     0.200
     0.549    20.148     0.200
     0.687    24.711     0.200
     0.795    28.695     0.200
     1.197    38.484     0.200
     1.221    39.469     0.200
     1.706    53.359     0.200
     1.677    54.570     0.200
     1.889    58.648     0.200
     1.999    64.281     0.200
     2.302    70.688     0.200
     2.047    65.742     0.200
     0.552    20.930     0.200
     0.698    24.820     0.200
     0.808    27.508     0.200
     1.175    39.375     0.200
     1.224    39.656     0.200
     1.699    54.688     0.200
     1.984    64.781     0.200
     1.984    65.070     0.200
     2.053    66.648     0.200
     2.053    67.055     0.200
     2.299    71.602     0.200
     0.661    23.543     0.200
     0.857    28.379     0.200
     0.861    28.465     0.200
     1.331    43.602     0.200
     1.255    40.605     0.200
     1.380    43.889     0.200
     2.078    65.461     0.200
     2.218    65.070     0.200
     2.133    63.793     0.200
     0.555    20.801     0.200
     0.686    25.090     0.200
     0.793    26.434     0.200
     0.917    31.387     0.200
     1.079    38.098     0.200
     1.213    38.699     0.200
     1.213    40.301     0.200
     1.211    41.367     0.200
     1.662    53.438     0.200
     1.699    54.777     0.200
     1.721    55.945     0.200
     1.875    58.148     0.200
     2.003    64.641     0.200
     2.003    64.301     0.200
     2.037    65.238     0.200
     2.037    65.352     0.200
     2.220    69.648     0.200
     2.271    70.906     0.200
     0.900    29.617     0.200
     0.900    28.047     0.200
     0.977    32.422     0.200
     1.017    34.062     0.200
     1.425    44.328     0.200
     1.646    50.344     0.200
     1.687    51.297     0.200
     1.796    54.281     0.200
     2.515    73.422     0.200
     2.508    75.562     0.200
     2.691    77.852     0.200
     2.872    83.000     0.200
     1.006    34.391     0.200
     1.124    36.773     0.200
     1.692    52.301     0.200
     1.799    55.219     0.200
     2.551    77.742     0.200
     0.393    14.123     0.200
     0.393    15.238     0.200
     0.524    20.066     0.200
     1.189    39.752     0.200
     0.382    13.777     0.200
     0.514    18.562     0.200
     1.201    39.445     0.200
     1.165    38.066     0.200
     1.177    38.406     0.200
     2.098    64.859     0.200
     2.179    67.496     0.200
     2.770    84.324     0.200
     2.583    77.125     0.200
     2.638    78.938     0.200
     0.367    13.816     0.200
     0.499    17.836     0.200
     1.154    39.168     0.200
     1.169    38.406     0.200
     1.202    39.719     0.200
     2.171    67.016     0.200
     2.583    76.605     0.200
     2.754    82.105     0.200
     2.778    81.867     0.200
     3.100    93.082     0.200
     0.376    13.770     0.200
     0.500    17.820     0.200
     1.191    39.223     0.200
     0.385    14.045     0.200
     0.517    17.797     0.200
     1.148    39.357     0.200
     1.157    39.080     0.200
     1.164    39.283     0.200
     1.223    39.338     0.200
     2.198    67.895     0.200
     3.130    95.750     0.200
     0.376    13.453     0.200
     0.506    18.222     0.200
     1.170    38.756     0.200
     1.190    38.620     0.200
     1.176    39.027     0.200
     2.067    64.100     0.200
     2.183    68.105     0.200
     2.145    64.991     0.200
     2.145    67.256     0.200
     2.610    78.281     0.200
     3.093    92.573     0.200
     0.369    13.832     0.200
     0.790    27.641     0.200
     1.164    37.516     0.200
     1.184    38.512     0.200
     1.179    38.391     0.200
     2.063    63.188     0.200
     2.145    68.580     0.200
     2.612    78.094     0.200
     2.607    78.176     0.200
     2.646    78.854     0.200
     2.672    79.410     0.200
     2.748    81.176     0.200
     1.179    36.879     0.200
     1.293    41.531     0.200
     1.747    53.008     0.200
     2.101    61.926     0.200
     2.154    64.207     0.200
     2.443    70.918     0.200
     0.930    32.791     0.200
     0.843    29.906     0.200
     1.053    35.459     0.200
     1.469    46.227     0.200
     1.434    48.414     0.200
     1.516    50.570     0.200
     1.542    51.412     0.200
     1.658    53.230     0.200
     0.225     9.848     0.200
     1.756    56.879     0.200
     1.485    49.855     0.200
     1.629    52.727     0.200
     1.565    52.719     0.200
     1.855    59.461     0.200
     1.985    62.773     0.200
     1.333    42.875     0.200
     1.401    43.969     0.200
     1.422    46.985     0.200
     1.505    48.484     0.200
     1.498    49.206     0.200
     1.623    50.642     0.200
     1.574    50.924     0.200
     1.642    51.821     0.200
     1.789    55.435     0.200
     0.267     8.983     0.200
     0.999    35.005     0.200
     1.261    43.224     0.200
     1.496    50.578     0.200
     1.564    52.208     0.200
     1.855    60.359     0.200
     1.982    62.482     0.200
     0.687    25.055     0.200
     0.790    28.602     0.200
     1.049    37.367     0.200
     1.197    40.562     0.200
     1.635    53.961     0.200
     1.718    56.828     0.200
     2.017    66.047     0.200
     2.009    65.602     0.200
     0.456    16.180     0.200
     0.578    20.953     0.200
     0.586    20.352     0.200
     0.815    28.234     0.200
     1.568    49.320     0.200
     1.814    58.070     0.200
     1.814    56.766     0.200
     1.768    54.781     0.200
     1.969    62.852     0.200
     2.148    67.180     0.200
     2.250    70.734     0.200
     2.250    71.320     0.200
     2.391    73.102     0.200
     2.520    76.359     0.200
     2.722    81.961     0.200
     0.366    13.070     0.200
     0.498    17.148     0.200
     1.151    37.859     0.200
     1.166    37.922     0.200
     1.205    39.078     0.200
     1.717    56.430     0.200
     2.085    64.570     0.200
     2.174    66.305     0.200
     2.580    77.109     0.200
     2.575    78.008     0.200
     2.626    78.875     0.200
     3.100    92.367     0.200
     3.383    99.047     0.200
     0.343    13.078     0.200
     0.470    17.133     0.200
     0.760    26.953     0.200
     1.153    38.117     0.200
     1.187    38.984     0.200
     1.154    38.023     0.200
     2.093    63.461     0.200
     2.610    77.898     0.200
     2.640    78.344     0.200
     2.655    79.258     0.200
     2.619    76.508     0.200
     2.704    80.891     0.200
     2.704    79.195     0.200
     3.033    91.125     0.200
     3.211    93.500     0.200
     0.314    12.868     0.200
     0.439    16.896     0.200
     1.128    38.660     0.200
     1.021    36.329     0.200
     1.710    54.061     0.200
     1.972    60.909     0.200
     2.641    80.296     0.200
     2.655    78.129     0.200
     2.650    80.588     0.200
     0.367    15.688     0.200
     0.617    20.281     0.200
     0.894    29.172     0.200
     0.893    29.789     0.200
     1.712    53.773     0.200
     0.705    25.207     0.200
     0.780    28.637     0.200
     0.772    26.723     0.200
     1.122    36.836     0.200
     1.360    43.492     0.200
     1.613    51.074     0.200
     1.705    54.812     0.200
     2.129    68.570     0.200
     2.462    74.941     0.200
     0.379    16.324     0.200
     0.607    22.020     0.200
     0.890    30.635     0.200
     1.559    48.414     0.200
     1.619    51.580     0.200
     1.709    52.645     0.200
     1.725    54.006     0.200
     3.467   101.160     0.200
     0.148     6.746     0.200
     0.642    23.516     0.200
     1.667    51.828     0.200
     1.854    58.586     0.200
     1.840    59.039     0.200
     2.095    65.770     0.200
     2.161    67.316     0.200
     2.226    67.785     0.200
     2.193    65.898     0.200
     0.395    15.555     0.200
     0.645    21.645     0.200
     0.942    32.266     0.200
     0.891    29.977     0.200
     1.481    45.668     0.200
     1.600    49.793     0.200
     1.657    50.602     0.200
     1.709    53.406     0.200
     0.271    13.039     0.200
     0.632    22.895     0.200
     0.845    29.773     0.200
     1.111    35.254     0.200
     1.426    44.145     0.200
     1.563    48.949     0.200
     1.663    51.473     0.200
     1.825    56.855     0.200
     0.416    15.559     0.200
     0.586    20.996     0.200
     0.886    30.883     0.200
     0.954    31.734     0.200
     0.954    30.531     0.200
     0.938    31.309     0.200
     1.423    46.092     0.200
     1.588    50.674     0.200
     1.692    52.959     0.200
     1.651    52.895     0.200
     1.757    55.938     0.200
     2.625    78.750     0.200
     2.669    80.336     0.200
     2.815    83.041     0.200
     0.728    25.977     0.200
     0.761    27.523     0.200
     1.065    32.621     0.200
     1.434    44.691     0.200
     1.382    43.332     0.200
     1.704    54.980     0.200
     1.612    52.164     0.200
     1.863    56.820     0.200
     2.053    63.004     0.200
     2.118    64.543     0.200
     2.277    67.672     0.200
     2.488    73.176     0.200
     2.498    76.520     0.200
     3.576   103.172     0.200
     0.306    12.941     0.200
     1.235    38.592     0.200
     1.437    44.661     0.200
     1.627    50.972     0.200
     1.600    49.758     0.200
     0.634    22.766     0.200
     0.653    24.414     0.200
     0.787    25.332     0.200
     0.729    24.414     0.200
     0.922    31.051     0.200
     1.038    35.184     0.200
     1.286    40.191     0.200
     1.326    42.594     0.200
     1.466    47.605     0.200
     1.452    46.164     0.200
     1.907    57.395     0.200
     2.054    65.215     0.200
     2.234    66.309     0.200
     0.646    23.594     0.200
     1.030    34.750     0.200
     1.927    60.008     0.200
     0.354    14.990     0.200
     0.852    26.824     0.200
     0.907    29.057     0.200
     0.936    30.947     0.200
     1.240    39.893     0.200
     1.275    42.482     0.200
     1.598    50.006     0.200
     1.928    59.887     0.200
     1.933    60.355     0.200
     1.940    60.020     0.200
     2.168    63.840     0.200
     2.272    66.420     0.200
     2.599    77.930     0.200
     2.937    84.197     0.200
     3.060    91.174     0.200
     0.389    14.684     0.200
     0.842    28.938     0.200
     1.299    41.906     0.200
     1.395    43.199     0.200
     1.469    46.629     0.200
     1.629    51.227     0.200
     1.672    51.062     0.200
     1.535    48.203     0.200
     2.236    66.586     0.200
     0.381    15.958     0.200
     0.860    28.306     0.200
     0.906    29.703     0.200
     1.217    38.562     0.200
     1.280    40.515     0.200
     1.450    45.002     0.200
     1.516    46.356     0.200
     0.378    15.661     0.200
     0.865    28.221     0.200
     1.628    50.228     0.200
     1.908    59.300     0.200
     1.915    59.010     0.200
     0.243    10.156     0.200
     0.311    11.438     0.200
     0.574    20.297     0.200
     1.125    36.391     0.200
     1.630    52.930     0.200
     1.754    54.859     0.200
     1.900    60.281     0.200
     1.955    60.680     0.200
     2.504    76.555     0.200
     2.459    77.047     0.200
     2.698    79.898     0.200
     0.393    16.164     0.200
     0.863    28.945     0.200
     0.937    30.758     0.200
     1.284    40.789     0.200
     1.451    45.023     0.200
     1.516    47.102     0.200
     1.676    52.348     0.200
     0.402    14.891     0.200
     0.951    32.250     0.200
     0.915    30.711     0.200
     0.948    32.516     0.200
     1.368    44.320     0.200
     1.588    51.031     0.200
     1.681    53.250     0.200
     1.681    52.102     0.200
     1.627    51.195     0.200
     1.734    53.984     0.200
     2.816    83.648     0.200
     0.418    15.723     0.200
     0.961    32.965     0.200
     1.374    45.477     0.200
     1.607    51.324     0.200
     1.634    50.980     0.200
     1.665    52.020     0.200
     1.792    58.871     0.200
     0.455    17.133     0.200
     0.967    32.125     0.200
     1.198    37.500     0.200
     1.369    44.711     0.200
     1.503    46.086     0.200
     1.825    57.844     0.200
     2.319    69.992     0.200
     2.426    70.922     0.200
     2.458    71.430     0.200
     0.638    22.906     0.200
     0.701    26.180     0.200
     1.150    36.859     0.200
     1.646    53.195     0.200
     1.808    55.797     0.200
     1.914    59.039     0.200
     2.196    66.641     0.200
     0.847    29.758     0.200
     0.933    32.219     0.200
     1.121    38.242     0.200
     1.180    38.023     0.200
     1.169    38.977     0.200
     1.586    50.930     0.200
     2.434    74.836     0.200
     0.253     9.951     0.200
     0.360    13.257     0.200
     0.655    22.941     0.200
     0.815    29.439     0.200
     1.687    53.549     0.200
     2.071    65.371     0.200
     2.280    70.597     0.200
     2.776    83.288     0.200
     3.431    98.653     0.200
     0.278    13.250     0.200
     0.905    30.195     0.200
     1.285    42.355     0.200
     1.477    45.328     0.200
     1.535    48.355     0.200
     1.638    51.043     0.200
     0.436    14.984     0.200
     1.094    35.875     0.200
     1.524    50.578     0.200
     1.551    50.477     0.200
     1.052    34.578     0.200
     1.271    39.207     0.200
     1.367    44.625     0.200
     1.814    57.039     0.200
     1.679    52.801     0.200
     1.849    57.828     0.200
     1.922    59.699     0.200
     2.049    63.738     0.200
     0.527    19.000     0.200
     0.659    22.430     0.200
     1.030    36.551     0.200
     1.100    37.234     0.200
     1.100    38.352     0.200
     1.233    42.531     0.200
     1.246    42.844     0.200
     1.750    57.945     0.200
     1.736    56.789     0.200
     1.642    53.820     0.200
     1.788    57.422     0.200
     1.700    56.457     0.200
     1.684    53.340     0.200
     0.513    17.490     0.200
     0.628    21.099     0.200
     1.267    42.662     0.200
     1.396    46.099     0.200
     1.653    54.233     0.200
     1.802    56.986     0.200
     1.995    62.128     0.200
     2.131    67.035     0.200
     2.212    71.384     0.200
     0.797    26.811     0.200
     0.626    22.051     0.200
     0.868    28.273     0.200
     1.061    34.818     0.200
     1.211    40.602     0.200
     1.331    44.633     0.200
     1.542    52.146     0.200
     1.943    61.402     0.200
     1.966    64.221     0.200
     1.951    63.014     0.200
     2.009    65.264     0.200
     2.069    66.822     0.200
     0.278    12.273     0.200
     0.485    17.083     0.200
     0.611    21.133     0.200
     0.879    29.780     0.200
     1.225    40.168     0.200
     1.503    47.368     0.200
     1.790    55.202     0.200
     1.742    54.542     0.200
     2.014    64.598     0.200
     2.205    69.065     0.200
     2.327    72.413     0.200
     0.576    21.086     0.200
     1.031    35.148     0.200
     0.959    33.289     0.200
     1.233    40.180     0.200
     1.321    44.562     0.200
     1.449    48.797     0.200
     1.965    63.531     0.200
     0.834    28.073     0.200
     0.840    30.734     0.200
     0.914    30.533     0.200
     1.479    47.765     0.200
     1.544    49.555     0.200
     1.816    56.725     0.200
     2.127    65.211     0.200
     0.468    17.836     0.200
     0.523    19.352     0.200
     1.074    37.188     0.200
     1.011    33.141     0.200
     1.232    37.938     0.200
     1.230    38.883     0.200
     1.348    43.051     0.200
     1.320    41.918     0.200
     1.592    49.160     0.200
     1.649    51.023     0.200
     1.959    60.383     0.200
     2.336    68.844     0.200
     0.833    28.266     0.200
     1.373    44.562     0.200
     1.405    44.531     0.200
     1.393    44.594     0.200
     1.479    46.297     0.200
     1.476    46.836     0.200
     2.095    63.539     0.200
     2.173    65.719     0.200
     2.203    65.336     0.200
     2.397    70.734     0.200
     2.831    83.625     0.200
     0.753    25.823     0.200
     0.816    29.355     0.200
     1.078    36.901     0.200
     1.365    43.249     0.200
     1.567    51.753     0.200
     1.843    60.616     0.200
     2.109    65.521     0.200
     2.384    72.742     0.200
     0.458    17.333     0.200
     0.838    26.006     0.200
     0.812    26.612     0.200
     0.970    33.276     0.200
     1.113    34.759     0.200
     1.258    39.670     0.200
     1.449    46.805     0.200
     1.389    43.368     0.200
     1.122    36.520     0.200
     1.420    46.965     0.200
     1.502    49.334     0.200
     2.046    64.340     0.200
     2.543    77.959     0.200
     0.736    25.803     0.200
     0.894    30.875     0.200
     0.894    29.457     0.200
     1.427    47.008     0.200
     1.537    48.820     0.200
     1.537    50.455     0.200
     1.697    55.396     0.200
     1.664    54.227     0.200
     1.937    63.256     0.200
     2.352    70.078     0.200
     2.406    74.867     0.200
     2.594    78.602     0.200
     2.684    78.785     0.200
     2.896    86.326     0.200
     2.890    85.379     0.200
     0.478    17.301     0.200
     0.988    33.541     0.200
     1.181    38.951     0.200
     1.443    46.967     0.200
     1.470    47.832     0.200
     1.507    48.083     0.200
     2.518    74.742     0.200
     2.562    78.002     0.200
     2.643    78.241     0.200
     0.499    17.721     0.200
     1.049    34.553     0.200
     1.451    48.709     0.200
     1.480    48.542     0.200
     1.523    49.337     0.200
     2.546    75.265     0.200
     2.648    79.521     0.200
     2.638    80.562     0.200
     0.547    19.495     0.200
     1.626    51.826     0.200
     1.841    56.304     0.200
     2.672    78.691     0.200
     3.684   105.770     0.200
     0.542    19.474     0.200
     0.953    29.394     0.200
     1.152    37.171     0.200
     1.283    39.732     0.200
     1.819    58.508     0.200
     0.496    18.314     0.200
     1.018    35.252     0.200
     1.239    39.672     0.200
     1.370    43.104     0.200
     2.091    63.012     0.200
     1.417    45.680     0.200
     1.406    46.055     0.200
     1.446    47.336     0.200
     1.491    48.375     0.200
     2.083    63.266     0.200
     2.389    71.023     0.200
     0.755    25.797     0.200
     0.815    29.617     0.200
     1.332    43.320     0.200
     1.544    49.781     0.200
     1.539    50.188     0.200
     0.856    28.590     0.200
     0.933    30.238     0.200
     0.848    28.172     0.200
     1.469    45.703     0.200
     1.396    44.824     0.200
     1.514    47.316     0.200
     0.425    13.613     0.200
     1.329    43.648     0.200
     1.469    50.590     0.200
     1.443    47.566     0.200
     1.600    52.211     0.200
     1.607    54.066     0.200
     1.501    49.852     0.200
     2.139    68.156     0.200
     0.666    23.891     0.200
     0.743    27.367     0.200
     1.364    43.758     0.200
     0.187     8.258     0.200
     0.595    20.453     0.200
     0.922    33.988     0.200
     1.884    60.324     0.200
     1.926    59.529     0.200
     2.266    70.289     0.200
     2.407    77.340     0.200
     2.420    72.631     0.200
     2.871    87.650     0.200
     0.216     9.283     0.200
     1.411    44.578     0.200
     1.376    45.658     0.200
     1.529    49.277     0.200
     2.017    62.250     0.200
     2.913    87.934     0.200
     0.612    22.609     0.200
     1.152    36.797     0.200
     1.461    50.039     0.200
     1.443    49.008     0.200
     1.490    48.047     0.200
     2.079    63.211     0.200
     2.701    79.898     0.200
     0.476    16.430     0.200
     1.847    56.504     0.200
     1.961    59.246     0.200
     2.134    63.348     0.200
     0.919    30.102     0.200
     1.024    35.898     0.200
     1.634    53.297     0.200
     1.832    59.594     0.200
     0.444    15.289     0.200
     1.018    33.408     0.200
     1.115    35.616     0.200
     1.518    49.845     0.200
     1.525    51.317     0.200
     1.704    52.915     0.200
     2.090    66.282     0.200
     2.115    66.961     0.200
     2.290    72.855     0.200
     2.491    74.884     0.200
     1.241    41.484     0.200
     1.281    42.453     0.200
     1.415    46.070     0.200
     1.479    48.734     0.200
     1.498    50.102     0.200
     1.596    53.211     0.200
     1.841    58.914     0.200
     1.961    61.812     0.200
     2.649    81.422     0.200
     2.641    80.219     0.200
     0.459    17.105     0.200
     0.540    20.436     0.200
     0.733    27.236     0.200
     0.828    28.158     0.200
     0.907    30.715     0.200
     1.393    45.498     0.200
     2.634    76.604     0.200
     2.725    81.326     0.200
     3.198    97.150     0.200
     0.287    11.948     0.200
     0.616    21.770     0.200
     0.641    21.556     0.200
     1.189    38.990     0.200
     1.781    56.455     0.200
     1.979    62.281     0.200
     2.186    68.886     0.200
     2.569    78.284     0.200
     0.512    19.633     0.200
     0.791    27.544     0.200
     1.425    46.742     0.200
     3.139    94.786     0.200
     0.716    23.715     0.200
     1.061    37.797     0.200
     1.110    38.664     0.200
     1.456    49.094     0.200
     1.528    51.367     0.200
     1.810    60.148     0.200
     0.108     5.744     0.200
     0.591    22.276     0.200
     0.676    24.729     0.200
     0.843    28.807     0.200
     1.360    43.184     0.200
     1.495    47.987     0.200
     1.377    45.615     0.200
     1.481    47.048     0.200
     1.463    47.515     0.200
     2.020    62.348     0.200
     2.020    62.835     0.200
     0.644    22.313     0.200
     0.790    27.312     0.200
     0.963    31.254     0.200
     1.570    48.962     0.200
     2.191    65.962     0.200
     2.535    73.343     0.200
     2.638    77.523     0.200
     0.527    19.301     0.200
     0.545    20.771     0.200
     0.651    23.221     0.200
     0.677    25.047     0.200
     1.137    37.432     0.200
     1.738    55.828     0.200
     1.739    54.053     0.200
     1.663    51.834     0.200
     2.097    66.051     0.200
     2.449    72.898     0.200
     2.410    72.777     0.200
     2.821    81.965     0.200
     3.180    92.270     0.200
     0.574    19.445     0.200
     0.802    27.387     0.200
     1.199    39.051     0.200
     1.465    48.590     0.200
     1.518    50.285     0.200
     1.465    48.363     0.200
     1.488    49.012     0.200
     2.641    81.488     0.200
     0.111     6.742     0.200
     0.755    25.247     0.200
     0.964    33.451     0.200
     1.241    40.146     0.200
     1.379    44.227     0.200
     2.013    61.224     0.200
     2.435    72.159     0.200
     2.540    75.840     0.200
     0.293    12.277     0.200
     0.420    15.850     0.200
     0.537    19.428     0.200
     1.305    41.777     0.200
     1.334    43.268     0.200
     1.472    46.562     0.200
     1.618    49.449     0.200
     2.024    60.225     0.200
     2.257    69.754     0.200
     2.278    70.621     0.200
     0.479    16.453     0.200
     1.429    47.252     0.200
     1.607    52.431     0.200
     1.638    54.030     0.200
     1.693    54.490     0.200
     0.172     8.621     0.200
     1.527    48.375     0.200
     1.598    52.121     0.200
     1.791    53.578     0.200
     1.305    42.391     0.200
     1.553    49.211     0.200
     1.654    51.766     0.200
     1.793    56.359     0.200
     0.273    11.945     0.200
     0.647    21.742     0.200
     1.087    34.383     0.200
     1.552    49.492     0.200
     1.653    51.656     0.200
     0.450    14.340     0.200
     1.347    45.676     0.200
     1.177    41.930     0.200
     1.522    52.457     0.200
     1.491    48.520     0.200
     1.466    48.820     0.200
     1.858    60.004     0.200
     2.107    66.426     0.200
     1.069    36.898     0.200
     1.115    38.163     0.200
     1.574    49.362     0.200
     2.163    68.502     0.200
     2.232    68.394     0.200
     2.380    72.874     0.200
     0.380    11.625     0.200
     1.417    46.629     0.200
     1.265    41.300     0.200
     1.237    42.074     0.200
     1.479    48.404     0.200
     1.435    47.888     0.200
     1.607    51.634     0.200
     0.578    18.404     0.200
     1.270    43.662     0.200
     1.218    42.701     0.200
     1.500    50.139     0.200
     1.325    45.346     0.200
     0.927    33.016     0.200
     1.232    42.035     0.200
     1.345    43.884     0.200
     1.456    48.075     0.200
     1.581    51.654     0.200
     2.292    72.320     0.200
     2.360    72.116     0.200
     2.434    74.740     0.200
     0.891    33.039     0.200
     1.324    43.135     0.200
     1.712    55.715     0.200
     2.318    71.676     0.200
     2.656    78.416     0.200
     0.072     7.401     0.200
     0.495    18.729     0.200
     0.539    19.610     0.200
     1.319    42.612     0.200
     1.341    43.235     0.200
     1.637    51.893     0.200
     1.936    60.287     0.200
     2.213    67.508     0.200
     2.287    67.101     0.200
     2.483    74.246     0.200
     2.703    79.709     0.200
     3.203    92.799     0.200
     0.830    29.555     0.200
     1.066    35.973     0.200
     1.105    37.762     0.200
     1.259    40.016     0.200
     1.535    50.652     0.200
     1.697    54.594     0.200
     2.332    72.855     0.200
     0.720    22.609     0.200
     1.138    37.055     0.200
     1.138    36.363     0.200
     1.309    41.734     0.200
     1.571    49.555     0.200
     1.915    57.645     0.200
     1.878    59.078     0.200
     2.220    66.211     0.200
     2.267    67.516     0.200
     2.689    80.191     0.200
     0.630    22.500     0.200
     0.630    22.703     0.200
     0.677    23.320     0.200
     0.715    25.781     0.200
     1.201    38.758     0.200
     1.543    49.141     0.200
     1.667    53.617     0.200
     1.922    61.438     0.200
     0.949    34.961     0.200
     1.195    40.636     0.200
     1.191    41.459     0.200
     1.234    42.948     0.200
     1.315    45.345     0.200
     1.374    46.920     0.200
     1.478    49.452     0.200
     1.590    51.946     0.200
     1.691    54.973     0.200
     1.906    60.012     0.200
     2.285    72.759     0.200
     2.456    76.320     0.200
     2.620    78.605     0.200
     0.136     7.805     0.200
     0.304    11.867     0.200
     0.433    16.029     0.200
     1.633    50.818     0.200
     1.966    59.820     0.200
     2.048    62.932     0.200
     2.155    64.545     0.200
     2.387    73.713     0.200
     2.498    74.910     0.200
     2.438    75.084     0.200
     2.772    80.943     0.200
     2.899    84.457     0.200
     0.782    28.846     0.200
     1.011    36.062     0.200
     0.995    35.336     0.200
     1.033    36.590     0.200
     1.109    39.152     0.200
     1.253    42.148     0.200
     1.585    51.688     0.200
     2.278    71.781     0.200
     2.690    80.604     0.200
     3.532   105.248     0.200
     0.208     7.867     0.200
     1.324    45.555     0.200
     1.204    36.758     0.200
     1.390    45.445     0.200
     1.806    57.859     0.200
     2.219    67.141     0.200
     2.378    74.750     0.200
     0.871    31.277     0.200
     1.417    45.883     0.200
     1.774    55.594     0.200
     2.016    61.801     0.200
     2.073    62.551     0.200
     0.475    16.922     0.200
     1.055    35.055     0.200
     1.229    39.289     0.200
     1.361    43.273     0.200
     1.945    57.586     0.200
     0.761    25.750     0.200
     0.761    26.856     0.200
     0.978    31.712     0.200
     1.291    41.081     0.200
     1.318    41.282     0.200
     1.563    49.881     0.200
     1.523    49.604     0.200
     1.651    52.933     0.200
     1.903    58.758     0.200
     2.131    65.555     0.200
     2.189    66.349     0.200
     2.400    70.964     0.200
     0.123     5.609     0.200
     0.393    14.562     0.200
     0.332    11.758     0.200
     0.447    15.844     0.200
     0.999    36.547     0.200
     1.426    47.812     0.200
     1.781    56.859     0.200
     2.048    64.328     0.200
     2.048    63.031     0.200
     2.941    89.414     0.200
     0.999    33.793     0.200
     1.652    54.627     0.200
     0.746    26.523     0.200
     0.524    18.570     0.200
     0.977    32.016     0.200
     1.388    45.633     0.200
     1.487    47.352     0.200
     1.522    49.617     0.200
     2.020    62.219     0.200
     0.824    28.742     0.200
     0.858    29.416     0.200
     0.951    34.180     0.200
     0.997    35.354     0.200
     1.543    49.848     0.200
     1.629    53.369     0.200
     1.815    57.900     0.200
     1.903    60.410     0.200
     2.143    67.258     0.200
     0.753    25.375     0.200
     0.691    24.289     0.200
     0.763    25.219     0.200
     0.763    25.344     0.200
     1.044    32.547     0.200
     1.237    39.133     0.200
     1.319    41.727     0.200
     1.319    41.539     0.200
     1.429    43.445     0.200
     1.805    56.273     0.200
     1.814    58.352     0.200
     2.283    69.656     0.200
     2.290    66.586     0.200
     2.443    71.711     0.200
     0.781    27.981     0.200
     0.838    28.946     0.200
     0.888    30.297     0.200
     1.758    55.031     0.200
     1.937    59.244     0.200
     2.098    63.296     0.200
     2.027    62.717     0.200
     2.239    70.051     0.200
     2.630    76.612     0.200
     0.818    28.512     0.200
     1.091    35.648     0.200
     1.573    50.047     0.200
     1.623    49.633     0.200
     1.883    57.035     0.200
     2.162    67.461     0.200
     2.690    80.375     0.200
     3.053    89.652     0.200
     3.341   101.266     0.200
     3.476   103.836     0.200
     3.689   105.492     0.200
     0.949    32.242     0.200
     0.877    30.859     0.200
     0.904    31.469     0.200
     0.966    33.312     0.200
     1.474    46.094     0.200
     1.641    52.000     0.200
     1.939    59.555     0.200
     2.137    66.828     0.200
     0.141     8.236     0.200
     0.528    19.461     0.200
     0.528    18.465     0.200
     0.950    32.592     0.200
     1.002    33.303     0.200
     1.198    38.096     0.200
     1.387    45.885     0.200
     1.347    44.207     0.200
     1.728    54.051     0.200
     1.804    55.828     0.200
     2.344    69.729     0.200
     2.417    71.219     0.200
     2.425    74.367     0.200
     2.573    78.166     0.200
     2.735    79.461     0.200
     0.297     9.395     0.200
     1.148    40.316     0.200
     1.352    43.559     0.200
     1.352    42.863     0.200
     1.149    38.570     0.200
     1.570    50.578     0.200
     1.626    53.145     0.200
     1.808    57.992     0.200
     0.419    15.881     0.200
     0.835    28.475     0.200
     1.825    57.480     0.200
     2.367    72.195     0.200
     0.993    34.240     0.200
     1.516    47.945     0.200
     1.547    51.758     0.200
     1.626    51.113     0.200
     1.665    51.418     0.200
     1.626    50.090     0.200
     1.775    55.000     0.200
     1.775    55.223     0.200
     1.658    51.168     0.200
     1.775    55.775     0.200
     1.882    59.801     0.200
     1.982    59.701     0.200
     2.861    85.963     0.200
     1.340    44.544     0.200
     1.492    50.548     0.200
     2.056    65.248     0.200
     2.572    78.668     0.200
     3.230    97.736     0.200
     0.705    24.320     0.200
     0.695    25.377     0.200
     1.257    41.072     0.200
     1.339    43.164     0.200
     1.607    53.949     0.200
     1.658    54.709     0.200
     1.744    57.088     0.200
     2.663    82.020     0.200
     0.600    21.937     0.200
     0.662    23.280     0.200
     0.960    32.338     0.200
     1.139    38.526     0.200
     1.141    37.329     0.200
     1.327    43.773     0.200
     1.533    49.229     0.200
     1.642    51.546     0.200
     1.669    52.279     0.200
     1.725    53.526     0.200
     2.029    60.966     0.200
     2.286    71.088     0.200
     2.463    72.759     0.200
     0.328    14.878     0.200
     1.301    40.916     0.200
     1.646    51.710     0.200
     1.737    54.121     0.200
     0.532    20.219     0.200
     0.685    24.781     0.200
     1.108    36.336     0.200
     1.215    38.695     0.200
     1.230    39.867     0.200
     1.466    45.430     0.200
     1.727    51.969     0.200
     2.049    61.859     0.200
     2.113    61.984     0.200
     0.061     7.094     0.200
     0.318    12.383     0.200
     0.450    15.422     0.200
     1.767    55.055     0.200
     1.828    57.836     0.200
     1.961    60.195     0.200
     1.961    61.945     0.200
     2.414    71.828     0.200
     2.763    82.016     0.200
     0.261    13.350     0.200
     0.638    20.969     0.200
     1.413    45.287     0.200
     1.656    52.240     0.200
     1.836    54.641     0.200
     1.836    54.137     0.200
     2.302    66.494     0.200
     2.641    75.418     0.200
     0.454    18.430     0.200
     0.466    17.336     0.200
     0.696    23.547     0.200
     1.074    35.430     0.200
     1.245    38.461     0.200
     1.708    52.164     0.200
     0.527    18.398     0.200
     1.442    44.965     0.200
     1.474    45.768     0.200
     1.511    46.289     0.200
     0.771    27.003     0.200
     0.780    28.206     0.200
     0.828    29.691     0.200
     1.068    36.669     0.200
     1.550    51.796     0.200
     1.793    58.568     0.200
     1.971    62.127     0.200
     1.971    62.616     0.200
     2.109    67.992     0.200
     2.191    67.827     0.200
     2.379    72.239     0.200
     2.540    78.066     0.200
     3.143    92.046     0.200
     0.384    14.203     0.200
     0.738    25.594     0.200
     0.950    32.070     0.200
     1.477    46.383     0.200
     1.542    49.688     0.200
     1.670    52.828     0.200
     2.150    64.227     0.200
     1.734    55.516     0.200
     2.941    89.705     0.200
     3.857   114.551     0.200
     1.655    53.166     0.200
     0.724    24.070     0.200
     0.797    27.336     0.200
     1.342    43.568     0.200
     1.342    43.377     0.200
     3.084    93.012     0.200
     0.356    13.068     0.200
     0.356    12.613     0.200
     0.557    19.594     0.200
     1.913    58.588     0.200
     1.913    59.547     0.200
     0.431    15.479     0.200
     0.590    22.162     0.200
     1.744    52.314     0.200
     0.790    26.145     0.200
     0.750    27.086     0.200
     1.495    46.930     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
