#!/bin/bash
gmt begin fes5.6_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source fes5.6'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.743    -0.420     0.200
     0.614     0.018     0.200
     0.189     0.267     0.200
     0.603    -0.463     0.200
     0.609     0.922     0.200
     0.149    -0.076     0.200
     0.701     1.021     0.200
     0.773    -0.130     0.200
     0.998     0.414     0.200
     0.764    -0.491     0.200
     0.779    -0.260     0.200
     0.822     0.386     0.200
     0.899     1.302     0.200
     0.523     1.409     0.200
     0.674    -0.214     0.200
     0.646    -0.963     0.200
     0.746     0.842     0.200
     0.943    -0.079     0.200
     0.215    -0.712     0.200
     0.274    -0.205     0.200
     0.826     0.015     0.200
     0.645     1.124     0.200
     0.830    -0.939     0.200
     0.956    -0.353     0.200
     0.220    -0.527     0.200
     0.792    -0.360     0.200
     0.756    -0.282     0.200
     0.700     0.209     0.200
     0.783    -0.406     0.200
     0.906    -0.452     0.200
     0.667     0.049     0.200
     0.456     0.239     0.200
     0.750     0.180     0.200
     0.577    -0.239     0.200
     0.610    -0.525     0.200
     0.897     1.049     0.200
     0.360    -0.172     0.200
     0.705    -0.033     0.200
     0.167    -0.303     0.200
     0.155     0.265     0.200
     0.424    -0.269     0.200
     0.140    -0.019     0.200
     0.461    -0.924     0.200
     0.130     0.157     0.200
     0.390     0.669     0.200
     0.836     0.137     0.200
     0.404     1.560     0.200
     0.651     0.399     0.200
     0.798    -0.227     0.200
     0.562    -0.196     0.200
     0.946    -0.642     0.200
     0.991     0.681     0.200
     0.766     0.775     0.200
     0.855     0.155     0.200
     0.983     0.834     0.200
     0.754     0.174     0.200
     0.804     0.120     0.200
     0.359     0.133     0.200
     0.842    -0.282     0.200
     0.976    -0.531     0.200
     0.313    -0.288     0.200
     0.815    -0.659     0.200
     0.947    -0.377     0.200
     0.765     0.161     0.200
     0.771     1.086     0.200
     0.996     0.161     0.200
     0.843    -0.350     0.200
     0.926    -0.533     0.200
     0.104    -0.491     0.200
     0.377     1.001     0.200
     0.866    -0.398     0.200
     0.926    -0.211     0.200
     0.184     0.496     0.200
     0.212     0.087     0.200
     0.569    -0.491     0.200
     0.117     0.228     0.200
     0.626     1.138     0.200
     0.345    -0.206     0.200
     0.603     0.967     0.200
     0.943     2.077     0.200
     0.977     0.206     0.200
     0.662    -1.750     0.200
     0.471     0.318     0.200
     0.885     1.452     0.200
     0.599     0.217     0.200
     0.599     1.217     0.200
     0.148     0.442     0.200
     0.305     0.384     0.200
     0.568     0.392     0.200
     0.884     0.632     0.200
     0.970    -0.138     0.200
     0.275     0.243     0.200
     0.775    -1.247     0.200
     0.964    -0.490     0.200
     0.553     0.057     0.200
     0.537     0.426     0.200
     0.258     0.199     0.200
     0.757     0.097     0.200
     0.285    -0.319     0.200
     0.286     0.556     0.200
     0.518    -0.071     0.200
     0.464     0.528     0.200
     0.581     0.126     0.200
     0.250     0.112     0.200
     0.447     0.361     0.200
     0.714     0.112     0.200
     0.406     0.570     0.200
     0.874    -0.534     0.200
     0.937     1.149     0.200
     0.610    -0.113     0.200
     0.610    -0.613     0.200
     0.554     1.005     0.200
     0.554     0.505     0.200
     0.672     0.833     0.200
     0.807     0.774     0.200
     0.233    -0.533     0.200
     0.368    -0.215     0.200
     0.308     0.463     0.200
     0.636    -0.143     0.200
     0.917     0.319     0.200
     0.775     1.401     0.200
     0.844     0.405     0.200
     0.953    -0.109     0.200
     0.779     1.478     0.200
     0.858     0.764     0.200
     0.301     0.222     0.200
     0.396     0.225     0.200
     0.201     0.106     0.200
     0.832    -0.152     0.200
     0.984    -0.765     0.200
     0.560     0.365     0.200
     0.695    -0.287     0.200
     0.954    -0.123     0.200
     0.968    -0.371     0.200
     0.432     0.461     0.200
     0.862    -0.420     0.200
     0.753    -1.152     0.200
     0.289    -0.036     0.200
     0.497    -0.139     0.200
     0.668     0.454     0.200
     0.832    -0.975     0.200
     0.876    -0.252     0.200
     0.967    -0.538     0.200
     0.073    -1.146     0.200
     0.621     0.251     0.200
     0.970     0.441     0.200
     0.195    -1.796     0.200
     0.666     0.727     0.200
     0.972     1.364     0.200
     0.457     0.153     0.200
     0.580    -0.228     0.200
     0.301    -0.386     0.200
     0.518     0.265     0.200
     0.654     0.076     0.200
     0.550     1.085     0.200
     0.242     0.876     0.200
     0.806     0.600     0.200
     0.276    -0.238     0.200
     0.329    -0.278     0.200
     0.662     0.302     0.200
     0.747     1.113     0.200
     0.103     0.174     0.200
     0.459    -0.360     0.200
     0.605    -0.354     0.200
     0.640     0.353     0.200
     0.932    -0.412     0.200
     0.968    -0.044     0.200
     0.244     0.203     0.200
     0.502    -0.199     0.200
     0.228     1.621     0.200
     0.720    -0.450     0.200
     0.429     1.126     0.200
     0.595     0.220     0.200
     0.671    -0.016     0.200
     0.491    -0.197     0.200
     0.556     0.340     0.200
     0.172    -0.056     0.200
     0.470     0.428     0.200
     0.784     0.286     0.200
     0.605     0.767     0.200
     0.748     0.511     0.200
     0.963     0.835     0.200
     0.295    -0.441     0.200
     0.303     0.924     0.200
     0.535     0.287     0.200
     0.589    -0.215     0.200
     0.589    -0.715     0.200
     0.627     0.060     0.200
     0.669     1.144     0.200
     0.457     0.645     0.200
     0.645    -0.031     0.200
     0.789    -0.368     0.200
     0.976    -0.401     0.200
     0.542     0.520     0.200
     0.915     0.362     0.200
     0.807    -0.395     0.200
     0.483     0.156     0.200
     0.587     0.607     0.200
     0.336     0.302     0.200
     0.641    -0.120     0.200
     0.783    -0.359     0.200
     0.321    -0.145     0.200
     0.253     0.167     0.200
     0.552    -0.360     0.200
     0.391     0.164     0.200
     0.380    -0.405     0.200
     0.812    -0.706     0.200
     0.425     0.145     0.200
     0.633    -0.063     0.200
     0.896     0.361     0.200
     0.234    -0.352     0.200
     0.083    -0.560     0.200
     0.922     0.976     0.200
     0.937     0.306     0.200
     0.255    -0.220     0.200
     0.523    -0.890     0.200
     0.671     0.318     0.200
     0.883     0.641     0.200
     0.792     0.044     0.200
     0.307     0.729     0.200
     0.451     0.538     0.200
     0.632    -0.598     0.200
     0.336    -0.153     0.200
     0.254     0.295     0.200
     0.444     0.304     0.200
     0.471    -0.157     0.200
     0.582    -0.615     0.200
     0.582    -0.412     0.200
     0.860     0.273     0.200
     0.234     0.548     0.200
     0.417     0.532     0.200
     0.486    -0.311     0.200
     0.594    -0.453     0.200
     0.840     0.658     0.200
     0.479    -0.113     0.200
     0.791     1.080     0.200
     0.933    -1.138     0.200
     0.607     0.270     0.200
     0.408    -0.105     0.200
     0.587    -0.040     0.200
     0.397    -0.081     0.200
     0.321     0.697     0.200
     0.584    -0.219     0.200
     0.413     1.288     0.200
     0.579    -0.604     0.200
     0.835    -0.757     0.200
     0.754     0.119     0.200
     0.994     0.515     0.200
     0.662     0.383     0.200
     0.661     0.465     0.200
     0.728     0.421     0.200
     0.782     0.034     0.200
     0.799     0.679     0.200
     0.352    -0.258     0.200
     0.927    -0.779     0.200
     0.084     0.300     0.200
     0.641    -0.404     0.200
     0.191    -0.875     0.200
     0.546    -0.661     0.200
     0.476     0.811     0.200
     0.807    -0.205     0.200
     0.542     0.148     0.200
     0.730     0.849     0.200
     0.788    -0.251     0.200
     0.768     0.481     0.200
     0.504    -0.957     0.200
     0.742    -0.690     0.200
     0.742     0.829     0.200
     0.779    -1.092     0.200
     0.559    -0.404     0.200
     0.769    -0.420     0.200
     0.810    -0.072     0.200
     0.826    -0.314     0.200
     0.872     0.629     0.200
     0.996    -0.159     0.200
     0.589     0.373     0.200
     0.802     0.916     0.200
     0.884    -0.483     0.200
     0.134     0.336     0.200
     0.354     0.117     0.200
     0.485    -0.201     0.200
     0.566     0.183     0.200
     0.111    -0.090     0.200
     0.315     0.738     0.200
     0.446    -1.086     0.200
     0.662     0.384     0.200
     0.804     0.024     0.200
     0.423     0.630     0.200
     0.814    -0.022     0.200
     0.631     0.471     0.200
     0.993    -0.134     0.200
     0.532     0.004     0.200
     0.669     0.654     0.200
     0.334    -0.263     0.200
     0.991     0.326     0.200
     0.273     0.069     0.200
     0.898     0.028     0.200
     0.618     0.209     0.200
     0.339     0.253     0.200
     0.584     0.208     0.200
     0.759     0.449     0.200
     0.760     0.665     0.200
     0.412    -0.108     0.200
     0.542     0.110     0.200
     0.882     0.449     0.200
     0.363     0.616     0.200
     0.966    -0.179     0.200
     0.875     0.764     0.200
     0.284     0.229     0.200
     0.434     0.604     0.200
     0.605    -0.570     0.200
     0.183     0.449     0.200
     0.857    -0.235     0.200
     0.384     0.274     0.200
     0.524     0.488     0.200
     0.604     0.512     0.200
     0.103     0.546     0.200
     0.492     0.260     0.200
     0.688    -0.759     0.200
     0.778    -1.070     0.200
     0.938    -0.052     0.200
     0.096    -0.132     0.200
     0.202     0.546     0.200
     0.496    -0.208     0.200
     0.626     0.700     0.200
     0.221     0.098     0.200
     0.448     0.501     0.200
     0.615     0.316     0.200
     0.716    -0.341     0.200
     0.474     0.665     0.200
     0.649    -0.002     0.200
     0.163    -0.280     0.200
     0.495     0.739     0.200
     0.664     0.397     0.200
     0.668    -0.305     0.200
     0.751    -0.260     0.200
     0.226     0.080     0.200
     0.543     0.099     0.200
     0.667     0.876     0.200
     0.691    -0.202     0.200
     0.764    -0.165     0.200
     0.834    -0.265     0.200
     0.874     0.617     0.200
     0.802    -0.248     0.200
     0.880     0.869     0.200
     0.863    -0.849     0.200
     0.943    -0.624     0.200
     0.310    -0.497     0.200
     0.336     0.214     0.200
     0.557     0.579     0.200
     0.840     0.404     0.200
     0.356     0.191     0.200
     0.551     0.424     0.200
     0.638    -0.114     0.200
     0.126    -0.313     0.200
     0.397    -0.478     0.200
     0.521    -0.010     0.200
     0.564     1.024     0.200
     0.967     0.132     0.200
     0.439     0.692     0.200
     0.867    -0.425     0.200
     0.851    -0.719     0.200
     0.766     0.232     0.200
     0.408     0.586     0.200
     0.628    -1.109     0.200
     0.620    -0.265     0.200
     0.632     0.084     0.200
     0.969     0.025     0.200
     0.451    -0.028     0.200
     0.565     0.415     0.200
     0.603    -0.073     0.200
     0.636     0.127     0.200
     0.885     0.796     0.200
     0.165    -0.289     0.200
     0.460     1.003     0.200
     0.634     0.013     0.200
     0.695    -0.510     0.200
     0.631    -0.109     0.200
     0.702    -0.415     0.200
     0.818    -0.053     0.200
     0.996     0.569     0.200
     0.522    -0.039     0.200
     0.898    -0.104     0.200
     0.893    -0.600     0.200
     0.910     0.910     0.200
     0.952    -0.159     0.200
     0.156     0.599     0.200
     0.507     0.273     0.200
     0.683    -0.431     0.200
     0.766    -0.710     0.200
     0.873     0.036     0.200
     0.916    -0.386     0.200
     0.494     0.380     0.200
     0.681    -0.445     0.200
     0.888    -0.937     0.200
     0.907    -0.837     0.200
     0.185    -0.577     0.200
     0.170     0.062     0.200
     0.675    -0.047     0.200
     0.663    -0.822     0.200
     0.743    -0.728     0.200
     0.632     0.216     0.200
     0.720    -0.070     0.200
     0.801    -0.396     0.200
     0.858    -0.410     0.200
     0.994     0.378     0.200
     0.825    -0.217     0.200
     0.251     0.616     0.200
     0.687    -0.156     0.200
     0.896     1.061     0.200
     0.137     0.099     0.200
     0.720    -0.793     0.200
     0.488    -0.881     0.200
     0.579     0.167     0.200
     0.579    -0.083     0.200
     0.802     0.076     0.200
     0.885    -0.167     0.200
     0.973    -1.081     0.200
     0.662     0.402     0.200
     0.852     0.352     0.200
     0.986     0.779     0.200
     0.726     0.003     0.200
     0.914     0.247     0.200
     0.552     0.455     0.200
     0.831    -0.812     0.200
     0.417     0.657     0.200
     0.417     0.508     0.200
     0.772    -0.396     0.200
     0.584    -0.196     0.200
     0.702    -0.024     0.200
     0.702    -0.453     0.200
     0.705    -0.912     0.200
     0.701     0.002     0.200
     0.876     0.122     0.200
     0.608     0.214     0.200
     0.788     0.178     0.200
     0.955     0.417     0.200
     0.675    -0.387     0.200
     0.753    -0.609     0.200
     0.856     0.437     0.200
     0.563     0.101     0.200
     0.727    -0.608     0.200
     0.841    -0.150     0.200
     0.519     0.171     0.200
     0.696    -1.421     0.200
     0.918    -0.103     0.200
     0.865    -0.139     0.200
     0.915    -1.037     0.200
     0.991    -1.106     0.200
     0.570    -0.394     0.200
     0.815    -0.270     0.200
     0.864     0.540     0.200
     0.920    -0.412     0.200
     0.998    -0.632     0.200
     0.944     0.672     0.200
     0.769    -0.068     0.200
     0.769     0.041     0.200
     0.805     0.027     0.200
     0.925     0.031     0.200
     0.925    -0.411     0.200
     0.176     0.594     0.200
     0.675     0.070     0.200
     0.756     0.192     0.200
     0.193     0.323     0.200
     0.252    -0.044     0.200
     0.953    -0.042     0.200
     0.940    -0.709     0.200
     0.940     0.248     0.200
     0.236    -0.036     0.200
     0.746     0.519     0.200
     0.746     0.378     0.200
     0.804    -0.246     0.200
     0.463     0.104     0.200
     0.856     0.041     0.200
     0.549    -0.491     0.200
     0.748    -0.034     0.200
     0.786    -0.036     0.200
     0.770    -0.019     0.200
     0.893     0.849     0.200
     0.496     0.526     0.200
     0.577    -0.026     0.200
     0.749    -0.264     0.200
     0.940     0.373     0.200
     0.555     0.726     0.200
     0.756     0.116     0.200
     0.845    -0.445     0.200
     0.682    -0.526     0.200
     0.618     0.154     0.200
     0.857    -0.053     0.200
     0.973     1.039     0.200
     0.324    -0.991     0.200
     0.937    -0.747     0.200
     0.226    -0.246     0.200
     0.829     0.476     0.200
     0.264     0.265     0.200
     0.871    -0.705     0.200
     0.871     0.274     0.200
     0.724    -0.031     0.200
     0.807     0.253     0.200
     0.513     0.417     0.200
     0.705     0.664     0.200
     0.496     0.435     0.200
     0.516     0.220     0.200
     0.153     0.369     0.200
     0.604    -0.059     0.200
     0.633     0.465     0.200
     0.879    -0.387     0.200
     0.749     0.768     0.200
     0.719     0.586     0.200
     0.825    -0.192     0.200
     0.942     0.820     0.200
     0.467     0.109     0.200
     0.774     0.453     0.200
     0.803     0.215     0.200
     0.934    -1.406     0.200
     0.745     0.205     0.200
     0.368     0.124     0.200
     0.540     0.405     0.200
     0.212    -0.356     0.200
     0.480     0.560     0.200
     0.972    -0.157     0.200
     0.995     0.666     0.200
     0.336     0.391     0.200
     0.416     0.309     0.200
     0.679    -0.196     0.200
     0.841     0.173     0.200
     0.401     0.413     0.200
     0.869    -0.113     0.200
     0.735     0.133     0.200
     0.719    -0.082     0.200
     0.698     0.388     0.200
     0.957    -0.189     0.200
     0.735     0.121     0.200
     0.727     0.246     0.200
     0.700    -1.973     0.200
     0.587    -0.493     0.200
     0.896     0.115     0.200
     0.712     0.063     0.200
     0.815     0.164     0.200
     0.815     0.833     0.200
     0.845    -0.586     0.200
     0.859     1.289     0.200
     0.995     0.308     0.200
     0.331     0.056     0.200
     0.321    -0.001     0.200
     0.984     0.514     0.200
     0.892    -0.307     0.200
     0.477     0.403     0.200
     0.595    -0.058     0.200
     0.735     0.090     0.200
     0.966    -0.443     0.200
     0.915     0.321     0.200
     0.915    -0.023     0.200
     0.269     0.357     0.200
     0.529    -0.063     0.200
     0.934    -0.204     0.200
     0.222     0.206     0.200
     0.745    -0.712     0.200
     0.790    -0.243     0.200
     0.650     0.477     0.200
     0.647     0.219     0.200
     0.892    -0.906     0.200
     0.994     0.117     0.200
     0.549     0.024     0.200
     0.549     0.203     0.200
     0.549     1.032     0.200
     0.687    -0.319     0.200
     0.795    -0.701     0.200
     0.795    -0.592     0.200
     0.552     0.380     0.200
     0.552     0.833     0.200
     0.698     0.018     0.200
     0.808    -0.492     0.200
     0.661    -0.173     0.200
     0.857    -0.588     0.200
     0.857    -0.367     0.200
     0.861     0.178     0.200
     0.555     0.530     0.200
     0.686    -0.029     0.200
     0.793    -0.209     0.200
     0.917    -0.554     0.200
     0.578     0.426     0.200
     0.900     0.386     0.200
     0.900    -0.692     0.200
     0.977     0.034     0.200
     0.552     0.376     0.200
     0.979    -0.510     0.200
     0.393     0.345     0.200
     0.524     0.117     0.200
     0.524     0.177     0.200
     0.813     0.281     0.200
     0.382    -0.190     0.200
     0.514    -0.054     0.200
     0.367     0.092     0.200
     0.499     0.277     0.200
     0.376    -0.061     0.200
     0.499     0.486     0.200
     0.500     0.389     0.200
     0.385    -0.275     0.200
     0.385     0.526     0.200
     0.517    -0.009     0.200
     0.376     0.097     0.200
     0.506     0.046     0.200
     0.369     0.124     0.200
     0.790     0.066     0.200
     0.429    -0.049     0.200
     0.786    -0.067     0.200
     0.930    -1.353     0.200
     0.843     0.210     0.200
     0.225     0.837     0.200
     0.267     0.289     0.200
     0.999    -0.707     0.200
     0.687    -0.187     0.200
     0.790    -0.501     0.200
     0.456     0.182     0.200
     0.578     0.555     0.200
     0.586    -0.449     0.200
     0.815     0.590     0.200
     0.815     1.402     0.200
     0.366     0.278     0.200
     0.366     0.403     0.200
     0.497     0.152     0.200
     0.497    -0.035     0.200
     0.498     0.037     0.200
     0.786     0.157     0.200
     0.343     0.014     0.200
     0.343    -0.291     0.200
     0.470     0.197     0.200
     0.760     0.367     0.200
     0.314    -0.145     0.200
     0.439     0.577     0.200
     0.367    -0.235     0.200
     0.617    -0.955     0.200
     0.894     0.579     0.200
     0.893    -0.073     0.200
     0.918     0.130     0.200
     0.705     0.182     0.200
     0.780     0.441     0.200
     0.772    -0.188     0.200
     0.379     0.155     0.200
     0.607    -0.423     0.200
     0.890     0.858     0.200
     0.148     0.320     0.200
     0.171     0.046     0.200
     0.642     0.855     0.200
     0.694    -0.300     0.200
     0.775    -0.694     0.200
     0.395    -0.506     0.200
     0.645    -1.094     0.200
     0.942     0.073     0.200
     0.936     0.207     0.200
     0.891     0.165     0.200
     0.932     0.205     0.200
     0.271     0.325     0.200
     0.632    -0.704     0.200
     0.835     0.222     0.200
     0.845    -0.220     0.200
     0.416     0.269     0.200
     0.586     0.201     0.200
     0.886     0.679     0.200
     0.954    -0.652     0.200
     0.938    -0.658     0.200
     0.966    -0.560     0.200
     0.966     0.213     0.200
     0.728    -0.357     0.200
     0.761     0.184     0.200
     0.835    -0.355     0.200
     0.823     1.510     0.200
     0.306     0.107     0.200
     0.595     0.916     0.200
     0.871     0.350     0.200
     0.883    -0.252     0.200
     0.634    -1.025     0.200
     0.653     0.220     0.200
     0.787     0.408     0.200
     0.787    -0.534     0.200
     0.729    -0.098     0.200
     0.922     0.198     0.200
     0.646     0.183     0.200
     0.798    -0.391     0.200
     0.829    -0.298     0.200
     0.904    -0.212     0.200
     0.354     0.112     0.200
     0.852    -0.995     0.200
     0.907     0.199     0.200
     0.802    -0.144     0.200
     0.936    -0.333     0.200
     0.389    -0.021     0.200
     0.648     0.685     0.200
     0.842    -0.455     0.200
     0.829     0.073     0.200
     0.915     0.054     0.200
     0.381     0.310     0.200
     0.860     0.448     0.200
     0.928     0.775     0.200
     0.906     0.342     0.200
     0.378     0.316     0.200
     0.865    -0.819     0.200
     0.806     0.018     0.200
     0.907     0.083     0.200
     0.311    -0.006     0.200
     0.574    -0.153     0.200
     0.909    -1.026     0.200
     0.393    -0.206     0.200
     0.630     0.809     0.200
     0.863     0.517     0.200
     0.937     0.224     0.200
     0.893     0.764     0.200
     0.402    -0.106     0.200
     0.908     0.810     0.200
     0.951     0.404     0.200
     0.951    -0.963     0.200
     0.915    -0.301     0.200
     0.948    -0.149     0.200
     0.418     0.055     0.200
     0.961    -0.507     0.200
     0.455     0.214     0.200
     0.967     0.408     0.200
     0.638    -0.114     0.200
     0.701    -0.184     0.200
     0.847    -0.205     0.200
     0.933     0.213     0.200
     0.253    -0.155     0.200
     0.360     0.403     0.200
     0.603    -0.313     0.200
     0.655    -0.383     0.200
     0.815     0.196     0.200
     0.278    -0.282     0.200
     0.905     0.392     0.200
     0.819    -0.117     0.200
     0.831     0.076     0.200
     0.436     0.172     0.200
     0.079    -0.841     0.200
     0.879    -1.411     0.200
     0.527    -0.072     0.200
     0.659    -0.231     0.200
     0.513     0.574     0.200
     0.628     0.306     0.200
     0.797     0.701     0.200
     0.626    -0.128     0.200
     0.868    -0.591     0.200
     0.278     0.503     0.200
     0.485    -0.222     0.200
     0.611    -0.291     0.200
     0.879    -0.338     0.200
     0.576     0.531     0.200
     0.959     0.289     0.200
     0.658     0.937     0.200
     0.834    -0.216     0.200
     0.840    -0.739     0.200
     0.914    -0.729     0.200
     0.896     0.431     0.200
     0.468     0.178     0.200
     0.523    -0.085     0.200
     0.973     1.431     0.200
     0.603    -0.053     0.200
     0.695     0.611     0.200
     0.833    -0.285     0.200
     0.901     0.251     0.200
     0.753     0.707     0.200
     0.752    -0.342     0.200
     0.816    -0.585     0.200
     0.458    -0.076     0.200
     0.812    -0.214     0.200
     0.970     0.345     0.200
     0.620     0.876     0.200
     0.825     0.046     0.200
     0.736    -0.589     0.200
     0.863     0.439     0.200
     0.894    -0.481     0.200
     0.894     0.235     0.200
     0.835     0.560     0.200
     0.478    -0.263     0.200
     0.499    -0.158     0.200
     0.547    -0.040     0.200
     0.542    -0.145     0.200
     0.752     0.870     0.200
     0.867     0.421     0.200
     0.496     0.018     0.200
     0.614     0.338     0.200
     0.720    -0.016     0.200
     0.755    -0.970     0.200
     0.815     0.781     0.200
     0.722     0.264     0.200
     0.856    -0.493     0.200
     0.933    -0.391     0.200
     0.839    -0.133     0.200
     0.848     0.594     0.200
     0.425    -0.177     0.200
     0.666     0.216     0.200
     0.743     0.376     0.200
     0.187     0.405     0.200
     0.560    -0.043     0.200
     0.595    -0.316     0.200
     0.922     0.727     0.200
     0.216    -0.101     0.200
     0.148     0.629     0.200
     0.612     0.534     0.200
     0.476     0.053     0.200
     0.998     0.869     0.200
     0.844     0.857     0.200
     0.973     0.614     0.200
     0.444    -0.276     0.200
     0.647    -0.691     0.200
     0.459     0.199     0.200
     0.459     0.353     0.200
     0.539    -0.082     0.200
     0.540    -0.020     0.200
     0.733     0.425     0.200
     0.828    -1.274     0.200
     0.907    -0.362     0.200
     0.287     0.094     0.200
     0.616    -0.354     0.200
     0.641    -0.604     0.200
     0.863    -0.097     0.200
     0.512     0.830     0.200
     0.791    -0.759     0.200
     0.861    -0.672     0.200
     0.716    -0.590     0.200
     0.853    -0.043     0.200
     0.108     0.076     0.200
     0.591    -0.038     0.200
     0.676     0.456     0.200
     0.843    -1.286     0.200
     0.644     0.435     0.200
     0.790     0.079     0.200
     0.963     0.731     0.200
     0.527    -0.037     0.200
     0.545     0.075     0.200
     0.651    -0.490     0.200
     0.677     0.107     0.200
     0.574     0.253     0.200
     0.802    -1.121     0.200
     0.111     0.516     0.200
     0.755    -0.630     0.200
     0.964    -0.084     0.200
     0.293     0.096     0.200
     0.420     0.355     0.200
     0.537     0.165     0.200
     0.479    -0.308     0.200
     0.172    -0.713     0.200
     0.995    -1.007     0.200
     0.647     0.252     0.200
     0.273     0.047     0.200
     0.647    -0.649     0.200
     0.870     1.523     0.200
     0.834     0.443     0.200
     0.450    -1.010     0.200
     0.882     0.176     0.200
     0.380    -1.102     0.200
     0.566    -0.859     0.200
     0.578    -0.796     0.200
     0.927    -0.071     0.200
     0.891     0.102     0.200
     0.072    -0.540     0.200
     0.495    -0.301     0.200
     0.539     0.293     0.200
     0.951     0.717     0.200
     0.830    -0.266     0.200
     0.479     0.112     0.200
     0.773    -0.943     0.200
     0.720    -0.800     0.200
     0.987    -1.072     0.200
     0.630     0.583     0.200
     0.677    -0.408     0.200
     0.715    -0.426     0.200
     0.949     0.305     0.200
     0.136    -0.039     0.200
     0.304     0.020     0.200
     0.433     0.075     0.200
     0.603    -0.285     0.200
     0.802    -0.344     0.200
     0.782    -0.121     0.200
     0.208    -0.322     0.200
     0.871     0.225     0.200
     0.475    -0.436     0.200
     0.801     0.447     0.200
     0.940     0.306     0.200
     0.411     0.039     0.200
     0.761    -0.481     0.200
     0.761    -0.104     0.200
     0.123     0.078     0.200
     0.393     0.526     0.200
     0.332     0.051     0.200
     0.447    -0.035     0.200
     0.550     0.511     0.200
     0.999    -0.296     0.200
     0.746     0.159     0.200
     0.524     0.698     0.200
     0.977    -0.529     0.200
     0.432     1.025     0.200
     0.824    -0.414     0.200
     0.858     0.272     0.200
     0.951    -0.163     0.200
     0.983    -0.630     0.200
     0.997    -0.570     0.200
     0.753    -0.724     0.200
     0.691     0.337     0.200
     0.763    -0.586     0.200
     0.763    -0.414     0.200
     0.950     0.523     0.200
     0.781     0.296     0.200
     0.838    -0.615     0.200
     0.888    -0.414     0.200
     0.974     0.226     0.200
     0.974     0.479     0.200
     0.997     0.350     0.200
     0.594     0.303     0.200
     0.818     0.745     0.200
     0.818     0.124     0.200
     0.939    -1.549     0.200
     0.936     0.099     0.200
     0.891    -0.452     0.200
     0.872    -0.508     0.200
     0.651     0.132     0.200
     0.949    -0.868     0.200
     0.877    -0.247     0.200
     0.904    -0.477     0.200
     0.966     0.042     0.200
     0.141    -0.534     0.200
     0.528     0.013     0.200
     0.528     0.513     0.200
     0.553     0.784     0.200
     0.950     0.299     0.200
     0.297    -0.248     0.200
     0.419    -0.330     0.200
     0.993     0.572     0.200
     0.897     0.165     0.200
     0.705    -0.570     0.200
     0.600     0.342     0.200
     0.662    -0.854     0.200
     0.960     0.578     0.200
     0.328     0.056     0.200
     0.873     0.816     0.200
     0.532     0.547     0.200
     0.685     0.069     0.200
     0.825     0.477     0.200
     0.061     0.204     0.200
     0.716     0.706     0.200
     0.261     0.433     0.200
     0.638    -0.625     0.200
     0.638    -0.098     0.200
     0.826     1.089     0.200
     0.454     0.268     0.200
     0.466     0.010     0.200
     0.527    -1.171     0.200
     0.693     0.810     0.200
     0.749     0.321     0.200
     0.771     0.133     0.200
     0.780     0.743     0.200
     0.828    -0.248     0.200
     0.384     0.138     0.200
     0.738     0.371     0.200
     0.738    -0.082     0.200
     0.950    -0.533     0.200
     0.950     0.935     0.200
     0.950    -0.010     0.200
     0.724    -0.210     0.200
     0.356     0.150     0.200
     0.356     0.009     0.200
     0.557    -0.157     0.200
     0.431    -0.005     0.200
     0.431     0.077     0.200
     0.590     0.245     0.200
     0.750     0.020     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.969    -0.583     0.200
     0.987     0.468     0.200
     0.239     0.775     0.200
     0.833     0.403     0.200
     0.349     0.303     0.200
     0.750     1.253     0.200
     0.774     0.644     0.200
     0.791     0.770     0.200
     0.449     0.079     0.200
     0.955     0.659     0.200
     0.852     0.194     0.200
     0.453    -0.065     0.200
     0.823    -0.041     0.200
     0.962     0.361     0.200
     0.294     0.103     0.200
     0.874     0.038     0.200
     0.942    -0.363     0.200
     0.950     1.007     0.200
     0.836     0.421     0.200
     0.835    -0.466     0.200
     0.696    -0.461     0.200
     0.961     0.153     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.614     0.705     0.200
     0.189     0.102     0.200
     0.603     1.869     0.200
     0.609    -0.436     0.200
     0.149    -0.510     0.200
     0.701    -0.671     0.200
     0.827     0.307     0.200
     0.998    -1.647     0.200
     0.764    -1.434     0.200
     0.899    -0.497     0.200
     0.523    -0.919     0.200
     0.646    -0.225     0.200
     0.746     0.505     0.200
     0.943    -1.117     0.200
     0.215    -1.028     0.200
     0.274    -0.201     0.200
     0.274     0.299     0.200
     0.274     1.299     0.200
     0.826     0.682     0.200
     0.645    -0.126     0.200
     0.956    -1.617     0.200
     0.220    -0.328     0.200
     0.658     0.359     0.200
     0.792    -0.231     0.200
     0.756    -0.106     0.200
     0.700    -0.864     0.200
     0.783     0.046     0.200
     0.783     1.046     0.200
     0.906     0.461     0.200
     0.667     0.488     0.200
     0.456     0.503     0.200
     0.750    -0.539     0.200
     0.577     0.392     0.200
     0.610    -0.269     0.200
     0.167    -0.200     0.200
     0.424     0.115     0.200
     0.140     0.728     0.200
     0.461    -0.093     0.200
     0.130     1.888     0.200
     0.390     0.450     0.200
     0.798    -0.642     0.200
     0.562    -0.312     0.200
     0.946     0.070     0.200
     0.766     0.972     0.200
     0.855    -0.897     0.200
     0.804     0.679     0.200
     0.842    -0.521     0.200
     0.976    -0.878     0.200
     0.313     1.370     0.200
     0.815     0.027     0.200
     0.947     0.221     0.200
     0.765    -0.659     0.200
     0.771     0.716     0.200
     0.996    -0.680     0.200
     0.843    -0.316     0.200
     0.926     0.618     0.200
     0.104     0.412     0.200
     0.866     1.245     0.200
     0.926     0.330     0.200
     0.212     0.357     0.200
     0.569     0.283     0.200
     0.117    -0.251     0.200
     0.345    -0.723     0.200
     0.603     1.284     0.200
     0.977    -0.360     0.200
     0.471     1.020     0.200
     0.599    -0.366     0.200
     0.599     0.134     0.200
     0.148    -0.938     0.200
     0.305     0.873     0.200
     0.970    -0.937     0.200
     0.775    -0.243     0.200
     0.964    -0.794     0.200
     0.553    -0.966     0.200
     0.537    -0.340     0.200
     0.258     0.729     0.200
     0.757     1.242     0.200
     0.285     1.036     0.200
     0.286     0.755     0.200
     0.518     0.457     0.200
     0.464     1.297     0.200
     0.581     0.241     0.200
     0.250     0.084     0.200
     0.447     0.726     0.200
     0.714    -1.053     0.200
     0.937    -0.236     0.200
     0.610    -1.851     0.200
     0.610    -0.851     0.200
     0.554     0.033     0.200
     0.554     1.033     0.200
     0.672     1.367     0.200
     0.807    -0.580     0.200
     0.233    -0.115     0.200
     0.368     1.395     0.200
     0.308     1.275     0.200
     0.636    -0.860     0.200
     0.917    -0.094     0.200
     0.844    -0.207     0.200
     0.779     0.505     0.200
     0.858    -1.140     0.200
     0.301    -0.125     0.200
     0.396     1.503     0.200
     0.201     1.058     0.200
     0.832     0.477     0.200
     0.695     1.821     0.200
     0.968     0.022     0.200
     0.432     1.225     0.200
     0.862     0.233     0.200
     0.753    -1.936     0.200
     0.289     0.073     0.200
     0.497     0.607     0.200
     0.668    -0.154     0.200
     0.876    -1.158     0.200
     0.967    -1.120     0.200
     0.621     0.342     0.200
     0.970    -0.013     0.200
     0.666     1.193     0.200
     0.457     0.427     0.200
     0.580     1.416     0.200
     0.301     1.001     0.200
     0.518     0.674     0.200
     0.654     0.143     0.200
     0.550    -0.349     0.200
     0.276     0.553     0.200
     0.329    -0.203     0.200
     0.662     0.875     0.200
     0.103     0.062     0.200
     0.589     0.063     0.200
     0.459     0.269     0.200
     0.605    -0.604     0.200
     0.640     0.050     0.200
     0.932    -1.430     0.200
     0.968    -0.644     0.200
     0.244    -0.255     0.200
     0.276    -0.222     0.200
     0.595     1.136     0.200
     0.671    -0.765     0.200
     0.491     0.330     0.200
     0.556     0.363     0.200
     0.470     1.472     0.200
     0.784     1.200     0.200
     0.295     0.673     0.200
     0.535     1.492     0.200
     0.589     0.789     0.200
     0.589    -0.211     0.200
     0.627     0.079     0.200
     0.669     0.531     0.200
     0.457    -0.149     0.200
     0.645     0.714     0.200
     0.789    -0.043     0.200
     0.976    -1.226     0.200
     0.542    -0.264     0.200
     0.915    -1.186     0.200
     0.483     0.075     0.200
     0.587     0.642     0.200
     0.336     0.214     0.200
     0.641    -0.783     0.200
     0.321     0.141     0.200
     0.253     0.946     0.200
     0.552    -0.358     0.200
     0.391     0.011     0.200
     0.380     0.136     0.200
     0.812    -0.218     0.200
     0.425    -0.154     0.200
     0.633     0.863     0.200
     0.234    -0.473     0.200
     0.083    -0.979     0.200
     0.937    -0.842     0.200
     0.523     0.657     0.200
     0.671     1.102     0.200
     0.883     1.035     0.200
     0.307     0.566     0.200
     0.451    -0.901     0.200
     0.336     1.127     0.200
     0.254     0.041     0.200
     0.444     0.439     0.200
     0.471    -0.172     0.200
     0.582     0.011     0.200
     0.234     0.474     0.200
     0.417    -0.004     0.200
     0.486    -0.437     0.200
     0.594    -0.350     0.200
     0.479    -0.273     0.200
     0.933    -0.528     0.200
     0.607    -1.338     0.200
     0.587    -1.243     0.200
     0.321     0.531     0.200
     0.584    -1.123     0.200
     0.835    -0.363     0.200
     0.754     0.518     0.200
     0.994    -0.245     0.200
     0.662     0.989     0.200
     0.661     0.478     0.200
     0.728     1.573     0.200
     0.782     0.114     0.200
     0.352    -0.662     0.200
     0.927    -1.661     0.200
     0.084     0.940     0.200
     0.641     0.230     0.200
     0.191    -0.214     0.200
     0.476     0.640     0.200
     0.807    -0.834     0.200
     0.542     1.028     0.200
     0.730    -0.267     0.200
     0.819    -1.139     0.200
     0.768     0.086     0.200
     0.504     0.117     0.200
     0.742     0.665     0.200
     0.559     0.103     0.200
     0.769     0.670     0.200
     0.589    -0.454     0.200
     0.934     0.013     0.200
     0.354    -1.142     0.200
     0.566    -0.595     0.200
     0.111     0.421     0.200
     0.315     0.430     0.200
     0.446    -0.225     0.200
     0.804     0.192     0.200
     0.631     0.880     0.200
     0.993    -0.894     0.200
     0.669     0.880     0.200
     0.334    -0.265     0.200
     0.916    -0.382     0.200
     0.991     0.259     0.200
     0.273     0.175     0.200
     0.898     0.636     0.200
     0.618     0.181     0.200
     0.339    -0.430     0.200
     0.584    -0.688     0.200
     0.760     1.022     0.200
     0.412    -0.451     0.200
     0.542    -0.418     0.200
     0.791    -1.037     0.200
     0.363     1.056     0.200
     0.966    -0.499     0.200
     0.875     0.046     0.200
     0.284    -0.455     0.200
     0.434     0.445     0.200
     0.605    -1.012     0.200
     0.183     0.797     0.200
     0.857    -0.175     0.200
     0.384    -0.834     0.200
     0.524    -0.932     0.200
     0.604    -1.079     0.200
     0.103     0.307     0.200
     0.492    -0.887     0.200
     0.938    -0.507     0.200
     0.096    -0.578     0.200
     0.202     0.010     0.200
     0.448     0.511     0.200
     0.615    -0.001     0.200
     0.716    -0.781     0.200
     0.474     0.290     0.200
     0.495    -0.062     0.200
     0.664     0.942     0.200
     0.751    -1.280     0.200
     0.667     1.063     0.200
     0.776     0.718     0.200
     0.834    -0.391     0.200
     0.874     1.059     0.200
     0.802     1.400     0.200
     0.863    -0.026     0.200
     0.943     0.098     0.200
     0.336    -0.403     0.200
     0.557     1.326     0.200
     0.840     0.426     0.200
     0.356     0.139     0.200
     0.551     2.093     0.200
     0.638    -0.940     0.200
     0.787     2.086     0.200
     0.126     0.710     0.200
     0.397     0.508     0.200
     0.521     0.818     0.200
     0.564    -0.037     0.200
     0.867    -0.046     0.200
     0.851     1.282     0.200
     0.620    -0.204     0.200
     0.451    -0.290     0.200
     0.603    -0.235     0.200
     0.636    -0.192     0.200
     0.210    -1.000     0.200
     0.460     0.375     0.200
     0.634    -1.109     0.200
     0.695    -0.492     0.200
     0.631     0.304     0.200
     0.818    -0.223     0.200
     0.898    -0.026     0.200
     0.910     0.771     0.200
     0.156     0.468     0.200
     0.507    -0.677     0.200
     0.873     1.139     0.200
     0.916     0.369     0.200
     0.494     1.953     0.200
     0.681    -0.057     0.200
     0.888     0.385     0.200
     0.907     0.351     0.200
     0.170     0.464     0.200
     0.675     0.682     0.200
     0.632    -0.610     0.200
     0.720    -1.034     0.200
     0.801     0.319     0.200
     0.858    -0.174     0.200
     0.994     1.097     0.200
     0.825     0.597     0.200
     0.251     0.527     0.200
     0.687    -1.297     0.200
     0.137    -0.476     0.200
     0.488    -1.201     0.200
     0.579    -0.185     0.200
     0.802     1.191     0.200
     0.885    -0.719     0.200
     0.973    -0.339     0.200
     0.662    -0.210     0.200
     0.986    -0.718     0.200
     0.726    -1.290     0.200
     0.914     0.287     0.200
     0.552     1.375     0.200
     0.831    -0.811     0.200
     0.772    -0.204     0.200
     0.584     0.004     0.200
     0.702    -0.041     0.200
     0.705    -0.258     0.200
     0.701    -1.173     0.200
     0.876     0.974     0.200
     0.608     0.192     0.200
     0.955     1.283     0.200
     0.675    -0.564     0.200
     0.753     0.059     0.200
     0.856     0.540     0.200
     0.563     0.600     0.200
     0.727     0.874     0.200
     0.841    -0.647     0.200
     0.519     0.465     0.200
     0.696     0.457     0.200
     0.918     0.412     0.200
     0.865    -0.312     0.200
     0.915     0.267     0.200
     0.991     1.094     0.200
     0.570     1.716     0.200
     0.815     0.335     0.200
     0.920     0.384     0.200
     0.944    -0.923     0.200
     0.769     1.493     0.200
     0.769     1.196     0.200
     0.805     0.092     0.200
     0.925    -0.448     0.200
     0.176    -0.025     0.200
     0.675    -0.671     0.200
     0.756    -0.668     0.200
     0.193     0.086     0.200
     0.953    -0.382     0.200
     0.940     1.443     0.200
     0.236    -0.762     0.200
     0.746    -1.711     0.200
     0.746     0.336     0.200
     0.463    -0.822     0.200
     0.856    -0.917     0.200
     0.893     0.247     0.200
     0.577    -0.238     0.200
     0.555     0.710     0.200
     0.756    -0.502     0.200
     0.796    -0.048     0.200
     0.845    -0.709     0.200
     0.682    -0.522     0.200
     0.618     0.092     0.200
     0.857    -0.203     0.200
     0.973    -0.725     0.200
     0.324    -1.011     0.200
     0.937    -0.277     0.200
     0.226    -0.627     0.200
     0.264    -0.192     0.200
     0.871    -0.932     0.200
     0.871    -0.639     0.200
     0.724     0.593     0.200
     0.807     1.407     0.200
     0.513    -0.584     0.200
     0.434    -0.060     0.200
     0.705    -0.648     0.200
     0.496     0.117     0.200
     0.516    -0.121     0.200
     0.604     0.316     0.200
     0.879     0.723     0.200
     0.719    -0.473     0.200
     0.825    -1.832     0.200
     0.942    -0.550     0.200
     0.803    -0.238     0.200
     0.368    -0.683     0.200
     0.212    -1.039     0.200
     0.972     0.802     0.200
     0.995     0.311     0.200
     0.336    -0.260     0.200
     0.416    -0.128     0.200
     0.679    -0.235     0.200
     0.841     0.015     0.200
     0.735    -0.208     0.200
     0.698     0.884     0.200
     0.957    -1.033     0.200
     0.735    -0.344     0.200
     0.727     0.054     0.200
     0.700    -1.909     0.200
     0.587     0.537     0.200
     0.896     0.339     0.200
     0.712     0.777     0.200
     0.845    -2.595     0.200
     0.331    -0.832     0.200
     0.321    -0.514     0.200
     0.984     0.443     0.200
     0.477     0.689     0.200
     0.595     0.420     0.200
     0.735    -0.474     0.200
     0.966    -1.752     0.200
     0.312     0.030     0.200
     0.529    -0.313     0.200
     0.914    -1.902     0.200
     0.934    -0.133     0.200
     0.745    -1.443     0.200
     0.790    -1.848     0.200
     0.650     0.906     0.200
     0.647    -0.005     0.200
     0.892     0.036     0.200
     0.994     0.728     0.200
     0.549     0.494     0.200
     0.687     0.478     0.200
     0.795     0.704     0.200
     0.552     1.431     0.200
     0.698     0.405     0.200
     0.808    -0.762     0.200
     0.661     0.414     0.200
     0.857    -0.108     0.200
     0.861    -0.331     0.200
     0.555     1.098     0.200
     0.686     1.016     0.200
     0.793    -1.360     0.200
     0.917    -0.740     0.200
     0.900    -0.324     0.200
     0.900    -1.895     0.200
     0.977     0.088     0.200
     0.393    -0.107     0.200
     0.393     1.008     0.200
     0.524     1.413     0.200
     0.382    -0.104     0.200
     0.514     0.254     0.200
     0.367     0.510     0.200
     0.499     0.098     0.200
     0.376    -0.178     0.200
     0.500    -0.160     0.200
     0.385     0.286     0.200
     0.517    -0.448     0.200
     0.376    -0.148     0.200
     0.506     0.221     0.200
     0.369     0.131     0.200
     0.790     0.164     0.200
     0.930     0.403     0.200
     0.843     0.419     0.200
     0.225     1.182     0.200
     0.267    -0.431     0.200
     0.999     0.233     0.200
     0.687     1.085     0.200
     0.790     1.002     0.200
     0.456    -0.222     0.200
     0.578     0.339     0.200
     0.586    -0.491     0.200
     0.815    -0.233     0.200
     0.366    -0.340     0.200
     0.498    -0.726     0.200
     0.343     0.070     0.200
     0.470     0.152     0.200
     0.760     0.444     0.200
     0.314     1.107     0.200
     0.439     0.984     0.200
     0.367     1.211     0.200
     0.617    -1.597     0.200
     0.894    -0.629     0.200
     0.893    -0.075     0.200
     0.705     0.521     0.200
     0.780     1.334     0.200
     0.772    -0.322     0.200
     0.379     1.971     0.200
     0.607     0.469     0.200
     0.890     0.378     0.200
     0.148    -0.468     0.200
     0.642     0.948     0.200
     0.395     0.126     0.200
     0.645    -0.910     0.200
     0.942     1.259     0.200
     0.891     0.319     0.200
     0.271     1.725     0.200
     0.632     0.483     0.200
     0.845     0.834     0.200
     0.416     0.347     0.200
     0.586     0.230     0.200
     0.886     0.330     0.200
     0.954    -0.809     0.200
     0.954    -2.012     0.200
     0.938    -0.977     0.200
     0.728     0.490     0.200
     0.761     0.933     0.200
     0.306    -0.395     0.200
     0.634     0.228     0.200
     0.653     1.290     0.200
     0.787    -1.593     0.200
     0.729    -1.095     0.200
     0.922     0.095     0.200
     0.646     0.772     0.200
     0.354     0.446     0.200
     0.852    -1.670     0.200
     0.907    -0.945     0.200
     0.936     0.076     0.200
     0.389    -0.188     0.200
     0.842     0.341     0.200
     0.381     0.608     0.200
     0.860    -0.434     0.200
     0.906    -0.327     0.200
     0.378     0.381     0.200
     0.865    -0.663     0.200
     0.243     0.878     0.200
     0.311    -0.051     0.200
     0.574    -0.210     0.200
     0.393     0.757     0.200
     0.863     0.171     0.200
     0.937    -0.075     0.200
     0.402     0.010     0.200
     0.951     0.101     0.200
     0.915    -0.639     0.200
     0.948     0.255     0.200
     0.418     0.412     0.200
     0.961     0.192     0.200
     0.455     0.203     0.200
     0.967    -0.214     0.200
     0.638     0.447     0.200
     0.701     1.435     0.200
     0.847     0.114     0.200
     0.933    -0.452     0.200
     0.253     0.035     0.200
     0.360    -0.059     0.200
     0.655    -0.195     0.200
     0.815     1.131     0.200
     0.278     0.867     0.200
     0.905     0.212     0.200
     0.436    -0.550     0.200
     0.527     0.590     0.200
     0.659    -0.588     0.200
     0.513    -0.506     0.200
     0.628    -0.932     0.200
     0.797    -0.895     0.200
     0.626     0.117     0.200
     0.868    -2.069     0.200
     0.278     1.383     0.200
     0.485    -0.370     0.200
     0.611    -0.472     0.200
     0.879    -0.573     0.200
     0.576     0.898     0.200
     0.959    -0.243     0.200
     0.834    -0.797     0.200
     0.840     1.645     0.200
     0.914    -0.904     0.200
     0.468    -0.189     0.200
     0.523    -0.187     0.200
     0.833     0.251     0.200
     0.753    -0.494     0.200
     0.816     0.858     0.200
     0.458    -0.865     0.200
     0.838    -2.260     0.200
     0.812    -1.154     0.200
     0.970     0.999     0.200
     0.736     0.107     0.200
     0.894     0.101     0.200
     0.894    -1.317     0.200
     0.478     0.040     0.200
     0.988    -0.040     0.200
     0.499    -0.188     0.200
     0.547     0.015     0.200
     0.542    -0.250     0.200
     0.953    -1.849     0.200
     0.496    -0.261     0.200
     0.755    -0.636     0.200
     0.815     1.459     0.200
     0.856     0.140     0.200
     0.933    -0.497     0.200
     0.848    -0.248     0.200
     0.425    -1.208     0.200
     0.666     0.520     0.200
     0.743     1.448     0.200
     0.187     0.882     0.200
     0.595    -0.573     0.200
     0.922     1.807     0.200
     0.216     0.117     0.200
     0.612     0.854     0.200
     0.476    -0.929     0.200
     0.919    -1.962     0.200
     0.444    -0.864     0.200
     0.459     0.321     0.200
     0.540     1.104     0.200
     0.733     1.594     0.200
     0.828    -0.549     0.200
     0.907    -0.258     0.200
     0.287     0.774     0.200
     0.616    -0.024     0.200
     0.641    -1.007     0.200
     0.512     1.417     0.200
     0.791    -0.367     0.200
     0.716    -1.222     0.200
     0.108     0.164     0.200
     0.591     1.218     0.200
     0.676     0.766     0.200
     0.843    -0.549     0.200
     0.644    -0.345     0.200
     0.790     0.700     0.200
     0.963    -0.353     0.200
     0.527     0.432     0.200
     0.545     1.292     0.200
     0.651     0.266     0.200
     0.677     1.288     0.200
     0.574    -0.679     0.200
     0.802    -0.633     0.200
     0.111     0.404     0.200
     0.755    -1.045     0.200
     0.964     0.356     0.200
     0.293     0.224     0.200
     0.420     0.186     0.200
     0.537     0.091     0.200
     0.479    -0.468     0.200
     0.172    -0.088     0.200
     0.273     0.085     0.200
     0.647    -0.992     0.200
     0.450    -1.299     0.200
     0.380    -1.605     0.200
     0.578    -1.722     0.200
     0.927     0.541     0.200
     0.891     1.974     0.200
     0.072     0.422     0.200
     0.495     0.624     0.200
     0.539     0.129     0.200
     0.830     0.805     0.200
     0.720    -2.183     0.200
     0.630     0.223     0.200
     0.630     0.426     0.200
     0.677    -0.522     0.200
     0.715     0.615     0.200
     0.949     1.801     0.200
     0.136     0.049     0.200
     0.304    -0.039     0.200
     0.433     0.130     0.200
     0.782     1.495     0.200
     0.995     0.615     0.200
     0.208    -1.027     0.200
     0.871     1.098     0.200
     0.475    -1.812     0.200
     0.761    -0.706     0.200
     0.761     0.400     0.200
     0.978    -1.519     0.200
     0.123     0.188     0.200
     0.393     0.492     0.200
     0.332    -0.171     0.200
     0.447    -0.042     0.200
     0.999     1.724     0.200
     0.999    -1.113     0.200
     0.746     0.470     0.200
     0.524    -0.217     0.200
     0.977    -1.570     0.200
     0.824    -0.091     0.200
     0.858    -0.494     0.200
     0.951     1.107     0.200
     0.997     0.754     0.200
     0.753    -0.281     0.200
     0.691     0.183     0.200
     0.763    -0.831     0.200
     0.763    -0.706     0.200
     0.781     0.803     0.200
     0.838    -0.152     0.200
     0.888    -0.182     0.200
     0.818     0.065     0.200
     0.949    -0.133     0.200
     0.877     0.509     0.200
     0.904     0.384     0.200
     0.966     0.268     0.200
     0.141     0.790     0.200
     0.528     0.549     0.200
     0.528    -0.447     0.200
     0.950     0.379     0.200
     0.297    -1.491     0.200
     0.419     0.325     0.200
     0.835    -0.374     0.200
     0.993     0.574     0.200
     0.705    -0.396     0.200
     0.695     0.896     0.200
     0.600     0.677     0.200
     0.662     0.009     0.200
     0.960    -0.125     0.200
     0.328     0.330     0.200
     0.532     0.664     0.200
     0.685     0.810     0.200
     0.061     0.789     0.200
     0.318     0.170     0.200
     0.450    -0.906     0.200
     0.261     0.269     0.200
     0.638    -1.669     0.200
     0.454     1.145     0.200
     0.466    -0.458     0.200
     0.696    -0.762     0.200
     0.527    -0.924     0.200
     0.771     0.034     0.200
     0.780     0.755     0.200
     0.828     0.696     0.200
     0.384    -0.236     0.200
     0.738    -0.146     0.200
     0.950     0.081     0.200
     0.724    -1.339     0.200
     0.797    -0.444     0.200
     0.356    -0.214     0.200
     0.356    -0.669     0.200
     0.557    -0.237     0.200
     0.431    -0.242     0.200
     0.590     0.519     0.200
     0.790    -1.256     0.200
     0.750     0.971     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.897    -0.146     0.200
     0.923    -0.854     0.200
     0.979    -0.972     0.200
     0.991     0.396     0.200
     0.983    -0.507     0.200
     0.943     0.253     0.200
     0.885     0.448     0.200
     0.809     0.486     0.200
     0.954    -0.288     0.200
     0.806    -2.208     0.200
     0.239    -0.513     0.200
     0.833    -0.239     0.200
     0.748    -0.796     0.200
     0.963    -0.220     0.200
     0.783     0.382     0.200
     0.799     0.482     0.200
     0.810     0.310     0.200
     0.773     0.847     0.200
     0.349    -1.181     0.200
     0.878    -0.344     0.200
     0.967     0.802     0.200
     0.969    -0.078     0.200
     0.885     0.550     0.200
     0.996    -0.515     0.200
     0.893     0.403     0.200
     0.449    -1.172     0.200
     0.955     0.812     0.200
     0.998     0.114     0.200
     0.804    -0.241     0.200
     0.852    -0.157     0.200
     0.549     0.284     0.200
     0.748    -0.037     0.200
     0.749     0.800     0.200
     0.829     0.049     0.200
     0.749    -0.362     0.200
     0.934    -0.371     0.200
     0.453    -0.643     0.200
     0.995    -0.154     0.200
     0.294    -0.039     0.200
     0.578    -0.431     0.200
     0.552    -0.057     0.200
     0.979    -0.894     0.200
     0.930     0.045     0.200
     0.966    -0.388     0.200
     0.835    -0.279     0.200
     0.823     0.773     0.200
     0.871    -0.904     0.200
     0.904    -0.423     0.200
     0.928     0.341     0.200
     0.806     0.823     0.200
     0.893    -0.582     0.200
     0.908     0.301     0.200
     0.901     0.404     0.200
     0.961     0.687     0.200
     0.752    -0.749     0.200
     0.867    -0.610     0.200
     0.950     0.954     0.200
     0.720    -1.280     0.200
     0.722    -0.689     0.200
     0.839     0.235     0.200
     0.998     0.142     0.200
     0.844    -1.921     0.200
     0.973    -0.802     0.200
     0.773     0.647     0.200
     0.901     1.115     0.200
     0.870     1.514     0.200
     0.834    -0.077     0.200
     0.834    -0.825     0.200
     0.951    -0.584     0.200
     0.987     0.282     0.200
     0.950     0.836     0.200
     0.974    -0.654     0.200
     0.997    -0.518     0.200
     0.818    -0.644     0.200
     0.936    -0.101     0.200
     0.872     0.284     0.200
     0.825    -0.123     0.200
     0.826     2.022     0.200
     0.961     0.412     0.200
     0.950    -0.016     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.039
 1.00    0.039
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00    0.257
 1.00    0.257
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.0
 1.00    0.0
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.1
 1.00   -0.1
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =   0.3 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.0 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.1 (dashed green line)
EOF
gmt end
