#!/bin/bash
gmt begin fes5.6_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic fes5.6'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.471
   135.500     1.553
   136.000     1.638
   136.500     1.726
   137.000     1.818
   137.500     1.913
   138.000     2.011
   138.500     2.112
   139.000     2.218
   139.500     2.327
   140.000     2.439
   140.500     2.556
   141.000     2.677
   141.500     2.803
   142.000     2.933
   142.500     3.068
   143.000     3.208
   143.500     3.354
   144.000     3.504
   144.500     3.661
   145.000     3.823
   145.500     3.991
   146.000     4.166
   146.500     4.348
   147.000     4.536
   147.500     4.732
   148.000     4.935
   148.500     5.146
   149.000     5.366
   149.500     5.594
   150.000     5.832
   150.500     6.080
   151.000     6.339
   151.500     6.607
   152.000     6.886
   152.500     7.175
   153.000     7.474
   153.500     7.783
   154.000     8.104
   154.500     8.435
   155.000     8.777
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.676
   145.500     0.289
   146.000     1.316
   146.500     2.386
   147.000     3.491
   147.500     4.625
   148.000     5.786
   148.500     6.973
   149.000     8.183
   149.500     9.416
   150.000    10.671
   150.500    11.948
   151.000    13.244
   151.500    14.561
   152.000    15.896
   152.500    17.250
   153.000    18.622
   153.500    20.011
   154.000    21.418
   154.500    22.843
   155.000    24.284
   155.500    25.743
   156.000    27.218
   156.500    28.711
   157.000    30.220
   157.500    31.745
   158.000    33.288
   158.500    34.846
   159.000    36.422
   159.500    38.013
   160.000    39.621
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.680
   145.500     0.084
   146.000     0.776
   146.500     1.418
   147.000     2.016
   147.500     2.575
   148.000     3.100
   148.500     3.592
   149.000     4.057
   149.500     4.503
   150.000     4.933
   150.500     5.350
   151.000     5.756
   151.500     6.153
   152.000     6.542
   152.500     6.923
   153.000     7.299
   153.500     7.670
   154.000     8.039
   154.500     8.405
   155.000     8.770
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   141.264     0.855     0.200
   143.861     0.826     0.200
   143.649     0.684     0.200
   143.580    -0.125     0.200
   142.918    -1.558     0.200
   144.091     0.630     0.200
   144.091     0.290     0.200
   152.887     1.337     0.200
   141.668    -2.263     0.200
   142.950    -1.079     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   151.339    11.602     0.200
   159.677    46.222     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   152.809    11.210     0.200
   151.944     7.383     0.200
   151.944     7.383     0.200
   142.305     5.951     0.200
   142.345     5.422     0.200
   145.993     5.066     0.200
   151.018     9.393     0.200
   152.059     9.316     0.200
   152.144    10.491     0.200
   142.465     3.166     0.200
   153.075    10.001     0.200
   140.426     3.598     0.200
   141.640     4.710     0.200
   141.727     2.837     0.200
   143.004     2.589     0.200
   145.501     3.052     0.200
   152.025     9.012     0.200
   152.025     8.637     0.200
   142.368     1.262     0.200
   143.560     1.632     0.200
   152.244     7.747     0.200
   152.406     8.530     0.200
   140.513     2.831     0.200
   141.681     3.172     0.200
   150.532     8.168     0.200
   142.477     2.398     0.200
   142.477     2.376     0.200
   152.383    10.045     0.200
   152.455     9.790     0.200
   141.306     1.763     0.200
   142.672     3.938     0.200
   151.421     7.781     0.200
   151.138     8.538     0.200
   141.078     3.343     0.200
   142.291     4.902     0.200
   142.221     3.094     0.200
   142.221     1.821     0.200
   151.162     8.396     0.200
   151.169     7.880     0.200
   152.887     8.751     0.200
   152.887     8.987     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
