#!/bin/bash
gmt begin fes5.6_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P fes5.6'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.694
    79.000     8.520
    80.000     7.430
    81.000     6.427
    82.000     5.509
    83.000     4.675
    84.000     3.925
    85.000     3.263
    86.000     2.687
    87.000     2.188
    88.000     1.793
    89.000     1.494
    90.000     1.237
    91.000     1.010
    92.000     0.810
    93.000     0.628
    94.000     0.463
    95.000     0.318
    96.000     0.198
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    17.325     5.149     0.200
    17.445     3.248     0.200
    17.551     3.339     0.200
    17.623     5.149     0.200
    17.774     2.977     0.200
    17.874     2.948     0.200
    18.262     2.575     0.200
    18.379     2.664     0.200
    19.257    -1.471     0.200
    20.516     1.803     0.200
    20.760     1.155     0.200
    20.894     1.409     0.200
    21.700     2.030     0.200
    21.915     1.732     0.200
    23.143    -0.307     0.200
    23.340     0.611     0.200
    23.588     1.110     0.200
    24.005     0.299     0.200
    24.002     1.533     0.200
    24.185     0.156     0.200
    24.189    -0.380     0.200
    24.363     2.036     0.200
    24.421    -0.493     0.200
    24.841     1.680     0.200
    25.067     1.623     0.200
    25.984     2.902     0.200
    26.829    -0.334     0.200
    26.967     1.424     0.200
    27.551     1.181     0.200
    31.583     0.431     0.200
    31.714    -0.218     0.200
    34.257     1.957     0.200
    35.486     1.948     0.200
    35.526     0.105     0.200
    36.449     0.203     0.200
    38.958     1.188     0.200
    39.051     3.206     0.200
    39.031     0.370     0.200
    40.718     4.344     0.200
    40.825     5.466     0.200
    42.683     0.656     0.200
    42.898     0.517     0.200
    42.975     0.888     0.200
    43.420     0.586     0.200
    47.157     4.638     0.200
    48.886     1.468     0.200
    54.794     1.186     0.200
    56.427     2.455     0.200
    59.015     2.255     0.200
    61.161     3.537     0.200
    64.989     1.110     0.200
    72.552     1.991     0.200
    74.675     3.715     0.200
    74.786     2.869     0.200
    77.798     1.869     0.200
    77.924     3.460     0.200
    79.246     2.777     0.200
    79.471     3.447     0.200
    79.546     2.143     0.200
    81.654     4.137     0.200
    83.905     5.745     0.200
    84.655     3.337     0.200
    19.844     1.101     0.200
    20.669     1.139     0.200
    20.920     0.417     0.200
    23.327     1.758     0.200
    29.187     4.186     0.200
    33.076     0.426     0.200
    35.527     0.389     0.200
    35.630     1.301     0.200
    36.374     5.238     0.200
    61.606     0.681     0.200
    67.201     1.062     0.200
    73.556     2.025     0.200
    80.896     2.248     0.200
    83.838     4.478     0.200
    84.700     3.402     0.200
    21.629    -1.313     0.200
    24.100     0.229     0.200
    78.283     2.902     0.200
    14.516     7.664     0.200
    14.516    11.664     0.200
    16.347     6.215     0.200
    16.388     5.696     0.200
    17.509     2.983     0.200
    20.456     1.406     0.200
    21.488     1.251     0.200
    21.489     1.747     0.200
    21.666     1.347     0.200
    21.782     1.096     0.200
    27.634     1.611     0.200
    28.662     0.354     0.200
    33.610     0.847     0.200
    36.135     1.755     0.200
    36.209     1.115     0.200
    36.198     0.213     0.200
    38.033    -0.080     0.200
    38.736     2.707     0.200
    39.841     2.476     0.200
    40.965     1.163     0.200
    48.284     4.532     0.200
    52.209     0.993     0.200
    59.930     1.856     0.200
    60.916     2.019     0.200
    61.888     1.443     0.200
    62.154     2.655     0.200
    62.549     0.009     0.200
    62.549     2.010     0.200
    64.287    -0.493     0.200
    76.817     3.053     0.200
    77.052     3.231     0.200
    78.309     1.719     0.200
    80.179     2.698     0.200
    20.141     0.918     0.200
    21.441     3.849     0.200
    21.529     2.908     0.200
    23.478     1.193     0.200
    27.301    -0.706     0.200
    28.717     0.150     0.200
    28.997     0.263     0.200
    38.029    -0.252     0.200
    61.844     0.825     0.200
    65.140     2.529     0.200
    67.422     1.396     0.200
    73.726     2.037     0.200
    81.093     1.288     0.200
    84.783     3.563     0.200
    14.619    11.693     0.200
    14.947     9.422     0.200
    17.076     3.115     0.200
    17.160     3.963     0.200
    17.736     3.112     0.200
    17.767     2.922     0.200
    18.241     1.999     0.200
    20.630    -0.128     0.200
    21.092     1.879     0.200
    21.647     0.210     0.200
    21.796     0.317     0.200
    22.025     0.864     0.200
    21.987     0.069     0.200
    22.130     1.745     0.200
    22.132     1.726     0.200
    22.338     3.527     0.200
    22.383     2.048     0.200
    22.383     2.650     0.200
    22.736     1.806     0.200
    22.906     2.507     0.200
    24.503     1.098     0.200
    24.839     2.043     0.200
    26.861     1.927     0.200
    27.404     5.349     0.200
    39.103     6.128     0.200
    59.625     3.215     0.200
    70.470     1.940     0.200
    74.951     4.312     0.200
    74.951     4.612     0.200
    75.513     3.973     0.200
    77.423     4.754     0.200
    77.956     3.481     0.200
    14.593     5.459     0.200
    15.350     6.478     0.200
    15.390     4.161     0.200
    15.638     7.812     0.200
    15.730     8.522     0.200
    21.010     0.267     0.200
    21.483     0.670     0.200
    22.166     0.859     0.200
    22.523     0.556     0.200
    22.755     1.590     0.200
    22.742     1.729     0.200
    22.847     1.018     0.200
    24.867     1.197     0.200
    29.965     1.258     0.200
    33.840     0.425     0.200
    37.347     1.297     0.200
    39.195    -0.265     0.200
    14.747     5.772     0.200
    16.278     4.637     0.200
    16.307     4.465     0.200
    16.421     5.207     0.200
    16.567     4.744     0.200
    16.645     3.552     0.200
    16.650     3.898     0.200
    16.796     5.043     0.200
    16.763     5.460     0.200
    16.862     3.818     0.200
    17.115     5.325     0.200
    17.222     5.191     0.200
    17.405     4.411     0.200
    17.448     5.476     0.200
    17.424     4.665     0.200
    17.685     4.430     0.200
    17.709     3.434     0.200
    17.910     4.152     0.200
    17.923     4.488     0.200
    18.079     3.067     0.200
    18.351     3.123     0.200
    18.373     3.064     0.200
    18.375     4.440     0.200
    19.617     1.753     0.200
    19.617     2.355     0.200
    20.193     0.375     0.200
    20.478     2.377     0.200
    20.458     2.095     0.200
    20.535     1.159     0.200
    20.592     2.138     0.200
    20.812     2.454     0.200
    20.821     2.659     0.200
    20.963     2.924     0.200
    21.153     1.471     0.200
    21.639     0.841     0.200
    21.939     3.130     0.200
    22.298     0.790     0.200
    22.528     1.345     0.200
    22.622     3.349     0.200
    22.833    -0.889     0.200
    22.909     0.303     0.200
    23.124     0.832     0.200
    23.344     0.016     0.200
    23.344     0.117     0.200
    23.349     0.661     0.200
    23.505     0.316     0.200
    23.604     0.835     0.200
    23.532     1.744     0.200
    23.691     2.243     0.200
    23.848     2.605     0.200
    23.961     1.274     0.200
    23.961     1.172     0.200
    24.193     1.556     0.200
    24.179     1.789     0.200
    24.702     2.015     0.200
    24.921     1.919     0.200
    24.921     1.622     0.200
    24.965     3.625     0.200
    25.087     1.508     0.200
    25.430     2.500     0.200
    25.579     5.039     0.200
    25.956     3.128     0.200
    26.100    -0.679     0.200
    26.100    -0.077     0.200
    26.337     3.178     0.200
    26.666     1.204     0.200
    26.666     2.001     0.200
    27.707     2.853     0.200
    30.917     1.360     0.200
    31.848     0.363     0.200
    35.324     3.096     0.200
    35.717     1.121     0.200
    36.756     1.531     0.200
    37.400     1.256     0.200
    38.185     2.525     0.200
    38.271     1.096     0.200
    38.379     1.890     0.200
    38.974     0.888     0.200
    39.819     2.838     0.200
    40.147     0.110     0.200
    42.001     3.848     0.200
    42.128     3.602     0.200
    45.376     2.669     0.200
    46.326     3.169     0.200
    46.908     4.606     0.200
    48.389     1.100     0.200
    49.795     1.626     0.200
    50.096     2.041     0.200
    50.947     3.610     0.200
    51.647     3.362     0.200
    52.866     2.697     0.200
    54.090     4.012     0.200
    56.859     4.379     0.200
    57.716     2.319     0.200
    57.796     4.257     0.200
    58.918     1.920     0.200
    58.918     2.319     0.200
    58.909     4.484     0.200
    59.374     1.759     0.200
    60.333     2.160     0.200
    60.333     2.363     0.200
    61.121     3.292     0.200
    61.307     2.530     0.200
    61.307     2.929     0.200
    61.682     3.204     0.200
    61.783     3.315     0.200
    62.236     2.273     0.200
    62.522     2.756     0.200
    63.484     1.966     0.200
    63.484     2.365     0.200
    63.674     2.705     0.200
    64.669     1.175     0.200
    65.037     3.278     0.200
    65.032     3.812     0.200
    65.149    -0.750     0.200
    65.996     1.573     0.200
    65.996     1.776     0.200
    66.006     1.510     0.200
    66.006     1.909     0.200
    68.209     1.514     0.200
    69.609     1.505     0.200
    70.355     0.217     0.200
    70.400     1.546     0.200
    71.875     2.005     0.200
    72.461     2.096     0.200
    74.755     3.009     0.200
    74.755     3.306     0.200
    75.916     1.833     0.200
    76.134     2.092     0.200
    76.134     2.193     0.200
    76.286     3.024     0.200
    76.333     2.752     0.200
    76.539     2.585     0.200
    76.668     3.062     0.200
    76.856     2.204     0.200
    77.196     1.084     0.200
    77.196     1.482     0.200
    77.996     3.615     0.200
    78.418     3.777     0.200
    79.158     3.208     0.200
    79.342     3.303     0.200
    79.601     1.996     0.200
    80.288     3.074     0.200
    80.400     1.868     0.200
    82.719     1.201     0.200
    82.550     2.081     0.200
    83.049     3.194     0.200
    83.806     1.593     0.200
    84.207     2.546     0.200
    85.266     3.705     0.200
    86.269     2.226     0.200
    91.700     3.025     0.200
    15.446     5.642     0.200
    15.856     5.447     0.200
    15.884     5.586     0.200
    16.016     5.077     0.200
    16.016     5.280     0.200
    16.268     5.056     0.200
    16.248     6.210     0.200
    16.460     5.915     0.200
    16.499     4.623     0.200
    16.624     4.944     0.200
    16.642     6.416     0.200
    16.649     6.222     0.200
    16.909     4.557     0.200
    16.962     3.486     0.200
    16.971     4.479     0.200
    17.184     5.612     0.200
    17.278     5.644     0.200
    17.335     2.935     0.200
    17.383     4.944     0.200
    17.512     3.541     0.200
    17.512     3.943     0.200
    17.534     5.070     0.200
    17.587     4.705     0.200
    17.825     3.269     0.200
    17.857     3.074     0.200
    17.857     4.574     0.200
    17.897     3.386     0.200
    17.897     3.784     0.200
    17.946     2.982     0.200
    17.946     3.482     0.200
    17.958     3.638     0.200
    17.958     3.529     0.200
    17.958     4.037     0.200
    18.021     3.666     0.200
    18.021     3.564     0.200
    18.219     2.938     0.200
    18.283     3.483     0.200
    18.301     5.394     0.200
    18.323     3.434     0.200
    18.460     2.333     0.200
    18.616     1.910     0.200
    18.545     1.995     0.200
    18.545     2.893     0.200
    18.617     2.431     0.200
    18.683     2.478     0.200
    18.757     2.764     0.200
    18.896     3.145     0.200
    19.073     2.596     0.200
    19.073     2.729     0.200
    19.096     2.485     0.200
    19.175     2.712     0.200
    19.187     2.752     0.200
    19.282     2.310     0.200
    19.278     2.555     0.200
    19.310     2.307     0.200
    19.569     3.272     0.200
    19.591     2.600     0.200
    19.624     2.668     0.200
    19.817     0.470     0.200
    19.914     1.807     0.200
    19.950     2.616     0.200
    19.986     2.599     0.200
    19.972     3.074     0.200
    19.959     1.719     0.200
    20.017     3.025     0.200
    20.144     1.813     0.200
    20.147     3.076     0.200
    20.169     1.542     0.200
    20.223     2.849     0.200
    20.293     2.259     0.200
    20.303     1.174     0.200
    20.307     2.336     0.200
    20.423     1.975     0.200
    20.520     2.426     0.200
    20.527     1.754     0.200
    20.581     2.769     0.200
    20.654     1.578     0.200
    20.654     1.418     0.200
    20.772     2.301     0.200
    20.847     1.787     0.200
    20.945     2.730     0.200
    21.058     0.614     0.200
    21.228     2.378     0.200
    21.228     1.628     0.200
    21.234     1.117     0.200
    21.340     0.967     0.200
    21.312     1.377     0.200
    21.324     1.620     0.200
    21.313     1.864     0.200
    21.474     0.733     0.200
    21.474     3.530     0.200
    21.451     1.582     0.200
    21.487     0.597     0.200
    21.485     2.189     0.200
    21.549     1.121     0.200
    21.603     1.629     0.200
    21.508     2.065     0.200
    21.545     1.595     0.200
    21.552     1.295     0.200
    21.668     1.114     0.200
    21.635     1.411     0.200
    21.647     2.543     0.200
    21.755     1.252     0.200
    21.713     1.269     0.200
    21.776     1.113     0.200
    21.781     1.122     0.200
    21.800     1.106     0.200
    21.813     1.301     0.200
    21.813     1.411     0.200
    21.839     1.256     0.200
    21.811     2.255     0.200
    21.834     2.336     0.200
    21.852     3.082     0.200
    21.907     1.189     0.200
    21.856     2.540     0.200
    21.895    -0.273     0.200
    21.862     1.975     0.200
    21.952     1.760     0.200
    22.113     4.300     0.200
    22.207     2.794     0.200
    22.245     0.692     0.200
    22.294     2.864     0.200
    22.290     2.342     0.200
    22.394     1.402     0.200
    22.377     2.717     0.200
    22.440     2.534     0.200
    22.736     4.680     0.200
    22.723     1.019     0.200
    22.796     3.739     0.200
    22.772     2.258     0.200
    22.931     2.217     0.200
    23.056     3.137     0.200
    23.127     0.851     0.200
    23.237     5.394     0.200
    23.244     4.315     0.200
    23.183     0.964     0.200
    23.248     1.114     0.200
    23.187     2.422     0.200
    23.370     1.990     0.200
    23.448     0.286     0.200
    23.448     0.704     0.200
    23.459     0.086     0.200
    23.413     1.940     0.200
    23.490     1.000     0.200
    23.567     1.619     0.200
    23.787     0.485     0.200
    23.839     0.612     0.200
    23.908     1.676     0.200
    23.895     2.298     0.200
    23.944     0.949     0.200
    23.952     2.580     0.200
    23.984     2.005     0.200
    24.114     1.096     0.200
    24.114     1.295     0.200
    24.228     2.932     0.200
    24.264     1.086     0.200
    24.316     1.256     0.200
    24.478     2.498     0.200
    24.468     2.450     0.200
    24.579     3.181     0.200
    24.625     3.442     0.200
    24.735     2.938     0.200
    24.701     2.749     0.200
    24.800     1.442     0.200
    24.845     0.737     0.200
    24.744     2.394     0.200
    24.885     2.428     0.200
    25.238     1.858     0.200
    25.286     3.426     0.200
    25.360     3.752     0.200
    25.441     4.018     0.200
    25.542     4.107     0.200
    25.753     1.891     0.200
    25.929     3.592     0.200
    26.103     2.022     0.200
    26.130     1.781     0.200
    26.124     2.835     0.200
    26.233     5.081     0.200
    26.245    -1.458     0.200
    26.302     2.222     0.200
    26.427     3.092     0.200
    26.580     1.709     0.200
    26.920     1.751     0.200
    27.145     3.624     0.200
    27.196     1.670     0.200
    28.103     3.057     0.200
    28.541     4.758     0.200
    29.339     3.366     0.200
    29.851     1.535     0.200
    31.299     1.050     0.200
    31.520     1.003     0.200
    31.607     3.840     0.200
    32.167     0.114     0.200
    32.618     0.157     0.200
    33.291     4.080     0.200
    33.437     4.104     0.200
    33.681     4.280     0.200
    33.770     4.506     0.200
    34.218     3.215     0.200
    36.084     1.750     0.200
    37.386     2.061     0.200
    38.827     3.219     0.200
    39.411     1.033     0.200
    40.312     2.545     0.200
    40.345     2.274     0.200
    40.499     2.003     0.200
    41.035     3.584     0.200
    41.632     2.677     0.200
    41.765     1.591     0.200
    42.399     1.421     0.200
    42.559     2.513     0.200
    42.954     3.912     0.200
    43.586     4.415     0.200
    45.209     5.138     0.200
    45.797     4.482     0.200
    48.533     3.851     0.200
    49.337     2.685     0.200
    49.744     2.081     0.200
    50.906     2.295     0.200
    51.150     1.957     0.200
    51.150     2.656     0.200
    52.398     2.946     0.200
    55.942     1.817     0.200
    55.942     2.516     0.200
    56.704     2.385     0.200
    57.823     4.781     0.200
    60.050     3.527     0.200
    60.213     4.112     0.200
    61.912     2.787     0.200
    62.680     5.243     0.200
    63.951     4.330     0.200
    64.241     2.927     0.200
    64.241     3.627     0.200
    64.666     4.146     0.200
    64.633     2.360     0.200
    65.543     2.950     0.200
    65.935     2.227     0.200
    68.200     0.540     0.200
    68.200     1.341     0.200
    68.797     1.620     0.200
    70.452     3.604     0.200
    70.577     1.881     0.200
    70.722     4.859     0.200
    71.020     2.149     0.200
    72.327     2.283     0.200
    72.549     2.243     0.200
    74.960     2.925     0.200
    75.323     2.772     0.200
    75.210     2.421     0.200
    75.196     2.464     0.200
    75.607     2.501     0.200
    75.761     2.986     0.200
    75.813     3.006     0.200
    76.111     2.628     0.200
    76.016     2.346     0.200
    76.079     3.108     0.200
    76.225     3.061     0.200
    76.546     5.561     0.200
    76.653     3.455     0.200
    77.347     4.054     0.200
    77.489     7.459     0.200
    77.755     3.974     0.200
    78.399     2.700     0.200
    79.516     3.579     0.200
    79.410     4.353     0.200
    79.944     1.955     0.200
    80.047     3.037     0.200
    80.198     2.910     0.200
    80.526     2.820     0.200
    80.699     1.891     0.200
    80.882     2.914     0.200
    81.514     2.555     0.200
    81.622     3.503     0.200
    81.826     1.907     0.200
    81.826     2.708     0.200
    81.881     2.500     0.200
    82.086     2.077     0.200
    82.507     3.238     0.200
    82.930     3.970     0.200
    83.489     2.257     0.200
    83.489     3.058     0.200
    83.479     3.249     0.200
    83.622     3.974     0.200
    84.128     2.312     0.200
    84.425     2.482     0.200
    84.425     2.584     0.200
    84.719     2.995     0.200
    84.719     3.393     0.200
    85.048     6.265     0.200
    85.027     3.949     0.200
    85.654     4.822     0.200
    87.690     3.366     0.200
    87.690     3.765     0.200
    88.375     2.117     0.200
    88.375     2.918     0.200
    89.493     2.461     0.200
    89.587     3.219     0.200
    90.158     2.252     0.200
    90.542     3.563     0.200
    91.160     3.291     0.200
    15.320     3.836     0.200
    15.322     4.503     0.200
    15.554     4.272     0.200
    15.628     3.907     0.200
    15.683     2.902     0.200
    15.660     3.628     0.200
    15.689     4.021     0.200
    15.757     3.931     0.200
    15.810     3.251     0.200
    15.861     3.793     0.200
    15.904     6.369     0.200
    15.912     5.064     0.200
    15.932     7.092     0.200
    16.014     7.138     0.200
    16.070     6.101     0.200
    16.204     6.489     0.200
    16.200     7.317     0.200
    16.263     7.317     0.200
    16.276     2.657     0.200
    16.286     5.019     0.200
    16.343     4.251     0.200
    16.478     6.782     0.200
    16.587     5.307     0.200
    16.532     4.098     0.200
    16.626     4.001     0.200
    16.633     4.320     0.200
    16.656     3.222     0.200
    16.664     2.926     0.200
    16.695     5.361     0.200
    16.763     4.582     0.200
    16.782     5.366     0.200
    16.917     3.540     0.200
    16.963     2.964     0.200
    16.979     3.252     0.200
    16.968     4.980     0.200
    17.016     4.598     0.200
    17.122     4.064     0.200
    17.204     3.646     0.200
    17.235     4.758     0.200
    17.275     5.263     0.200
    17.279     4.775     0.200
    17.254     4.901     0.200
    17.335     4.206     0.200
    17.389     4.435     0.200
    17.553     3.206     0.200
    17.664     2.126     0.200
    17.806     4.472     0.200
    17.827     4.500     0.200
    17.848     4.056     0.200
    17.880     4.836     0.200
    17.911     3.477     0.200
    17.968     5.871     0.200
    18.037     4.231     0.200
    18.086     3.036     0.200
    18.167     4.140     0.200
    18.231     2.550     0.200
    18.347     5.060     0.200
    19.847     1.428     0.200
    19.932     2.002     0.200
    19.976     1.619     0.200
    20.161     1.703     0.200
    20.168     1.526     0.200
    20.186     1.035     0.200
    20.299     1.753     0.200
    20.326     0.514     0.200
    20.334     2.026     0.200
    20.444     2.127     0.200
    20.587     1.883     0.200
    20.670     1.482     0.200
    20.670     1.111     0.200
    20.793     2.146     0.200
    20.855     2.183     0.200
    21.076     1.199     0.200
    21.239     3.334     0.200
    21.239     1.564     0.200
    21.249     0.749     0.200
    21.353     2.009     0.200
    21.343     2.416     0.200
    21.409     0.741     0.200
    21.483     3.409     0.200
    21.482     0.748     0.200
    21.474     2.313     0.200
    21.510     1.426     0.200
    21.514     1.484     0.200
    21.564     0.752     0.200
    21.541     1.094     0.200
    21.573     1.923     0.200
    21.586     5.105     0.200
    21.683     0.895     0.200
    21.666     2.246     0.200
    21.677     1.504     0.200
    21.770     0.956     0.200
    21.791     1.198     0.200
    21.744     1.808     0.200
    21.796     1.050     0.200
    21.815     1.346     0.200
    21.827     1.919     0.200
    21.827     1.130     0.200
    21.854     1.196     0.200
    21.839     1.665     0.200
    21.863     1.493     0.200
    21.922     1.201     0.200
    21.913    -0.401     0.200
    21.882    -0.167     0.200
    21.893     2.323     0.200
    22.105     4.552     0.200
    22.058     1.560     0.200
    22.148     1.593     0.200
    22.199     4.554     0.200
    22.262     0.979     0.200
    22.302     3.451     0.200
    22.318     1.498     0.200
    22.411     1.392     0.200
    22.406     1.657     0.200
    22.413     0.571     0.200
    22.469     1.700     0.200
    22.527     2.056     0.200
    22.578     1.020     0.200
    22.597     2.446     0.200
    22.728     0.931     0.200
    22.736     0.843     0.200
    22.803     2.171     0.200
    23.006     3.992     0.200
    22.963     2.443     0.200
    23.147     0.504     0.200
    23.260     1.030     0.200
    23.222     4.712     0.200
    23.394     0.908     0.200
    23.465     0.162     0.200
    23.465     1.861     0.200
    23.465     0.424     0.200
    23.475     0.051     0.200
    23.446     2.126     0.200
    23.511     0.317     0.200
    23.598     3.434     0.200
    23.801     0.459     0.200
    23.854     0.973     0.200
    23.821     1.873     0.200
    23.930     1.181     0.200
    23.963     0.878     0.200
    23.927     2.350     0.200
    23.986     3.866     0.200
    24.015     1.781     0.200
    24.103     4.199     0.200
    24.137     0.992     0.200
    24.260     3.486     0.200
    24.297     2.728     0.200
    24.553     5.196     0.200
    24.693     4.017     0.200
    24.748     2.420     0.200
    24.472     2.278     0.200
    24.814     1.321     0.200
    24.862     0.683     0.200
    24.867     0.333     0.200
    25.013     2.613     0.200
    24.748     1.577     0.200
    24.889     2.455     0.200
    25.233     5.612     0.200
    25.258     2.785     0.200
    25.311     3.298     0.200
    25.387     3.610     0.200
    25.709     5.588     0.200
    25.774     2.200     0.200
    26.077     2.359     0.200
    26.123     1.837     0.200
    26.149     1.599     0.200
    26.147     2.719     0.200
    26.278     1.539     0.200
    26.372     3.693     0.200
    26.372     4.693     0.200
    26.454     4.947     0.200
    26.603     1.600     0.200
    26.808     4.755     0.200
    26.808     5.755     0.200
    26.811    -1.272     0.200
    26.927     3.687     0.200
    27.157     5.614     0.200
    27.225     3.008     0.200
    27.225     3.508     0.200
    27.484     2.176     0.200
    27.717     3.593     0.200
    28.130     2.906     0.200
    28.732     3.043     0.200
    28.732     3.543     0.200
    28.842     2.569     0.200
    28.842     0.569     0.200
    28.814     2.714     0.200
    29.266     2.809     0.200
    29.375     2.843     0.200
    29.695     3.007     0.200
    29.877     1.388     0.200
    30.727     3.377     0.200
    31.071     3.347     0.200
    31.199     3.720     0.200
    31.306     1.378     0.200
    31.525     1.247     0.200
    31.643     3.804     0.200
    32.099     3.800     0.200
    32.177     3.721     0.200
    32.837     3.931     0.200
    32.889     0.875     0.200
    33.330     3.226     0.200
    33.402     4.495     0.200
    33.577     4.370     0.200
    33.609     5.595     0.200
    33.613     5.561     0.200
    33.787     4.042     0.200
    33.800     4.530     0.200
    33.846     3.431     0.200
    35.189     1.913     0.200
    36.092     0.361     0.200
    36.683    -1.386     0.200
    36.687     4.079     0.200
    37.049    -1.002     0.200
    37.407     2.962     0.200
    38.202     2.242     0.200
    38.858     2.732     0.200
    38.858     3.431     0.200
    39.130     3.455     0.200
    39.416     3.062     0.200
    40.190    -0.369     0.200
    40.345     1.947     0.200
    40.378     1.074     0.200
    40.506     1.512     0.200
    41.066     4.392     0.200
    41.666     4.467     0.200
    41.800     3.374     0.200
    42.405     3.438     0.200
    42.356     4.834     0.200
    42.568     2.105     0.200
    43.334     5.902     0.200
    45.831     4.471     0.200
    48.571     4.611     0.200
    49.371     4.477     0.200
    49.766     1.460     0.200
    50.927     1.675     0.200
    52.433     2.430     0.200
    55.377     3.144     0.200
    55.905     4.456     0.200
    56.728     2.245     0.200
    58.046     2.450     0.200
    60.249     2.792     0.200
    61.882     4.889     0.200
    61.969     4.027     0.200
    61.942     2.709     0.200
    63.278     3.820     0.200
    63.631     1.954     0.200
    63.625     1.997     0.200
    63.982     3.142     0.200
    64.202     4.478     0.200
    64.133     3.154     0.200
    64.555     3.890     0.200
    65.529     5.558     0.200
    65.957     3.193     0.200
    66.745     2.950     0.200
    67.907     5.589     0.200
    68.163     2.205     0.200
    68.760     1.139     0.200
    69.081     3.254     0.200
    70.480     2.942     0.200
    70.540     0.723     0.200
    71.042     1.019     0.200
    74.767     4.936     0.200
    74.923     2.533     0.200
    75.245     2.680     0.200
    75.290     2.580     0.200
    75.234     2.241     0.200
    75.571     2.408     0.200
    75.847     2.028     0.200
    76.051     2.669     0.200
    76.074     3.334     0.200
    76.186     2.798     0.200
    76.118     2.183     0.200
    76.259     2.983     0.200
    76.674     4.030     0.200
    77.389     1.309     0.200
    77.313     4.433     0.200
    77.540     4.968     0.200
    77.794     3.747     0.200
    79.443     3.864     0.200
    79.485     3.039     0.200
    80.032     3.938     0.200
    80.185     3.695     0.200
    80.553     3.464     0.200
    80.865     4.415     0.200
    81.485     2.575     0.200
    81.587     4.440     0.200
    81.643     6.864     0.200
    81.848     1.924     0.200
    81.907     1.620     0.200
    81.967     3.607     0.200
    82.052     1.748     0.200
    82.897     2.439     0.200
    83.200     2.229     0.200
    83.466     3.554     0.200
    83.456     2.946     0.200
    83.639     2.006     0.200
    84.099     1.961     0.200
    84.409     2.148     0.200
    84.685     3.323     0.200
    84.686     2.327     0.200
    85.055     3.792     0.200
    88.341     2.612     0.200
    88.211     3.769     0.200
    89.190     3.506     0.200
    89.615     3.267     0.200
    91.195     3.905     0.200
    20.126    -0.188     0.200
    20.984     0.280     0.200
    20.136    -0.447     0.200
    20.136    -0.147     0.200
    20.260    -0.498     0.200
    33.718    -1.020     0.200
    68.660     0.284     0.200
    20.340     1.786     0.200
    21.663    -0.498     0.200
    21.967     0.051     0.200
    28.953    -0.612     0.200
    33.906    -0.099     0.200
    68.028     0.106     0.200
    69.259     1.425     0.200
    77.805     1.038     0.200
    77.806     2.537     0.200
    78.813     2.155     0.200
    79.987     3.851     0.200
    18.166     3.184     0.200
    21.461     0.002     0.200
    21.589     0.626     0.200
    35.076     1.135     0.200
    14.019     9.949     0.200
    14.048    11.085     0.200
    14.070     9.786     0.200
    14.103    10.699     0.200
    14.114    11.133     0.200
    14.173    11.549     0.200
    14.212    11.298     0.200
    14.316     8.429     0.200
    14.356    10.050     0.200
    14.400     9.533     0.200
    14.436     9.509     0.200
    14.572     9.727     0.200
    14.653     5.386     0.200
    14.729     5.143     0.200
    14.834     8.229     0.200
    15.268     7.542     0.200
    15.271     7.384     0.200
    15.294     7.898     0.200
    15.311     8.666     0.200
    15.558     8.445     0.200
    16.013     5.037     0.200
    16.380     2.341     0.200
    16.309     5.137     0.200
    16.391     4.298     0.200
    16.323     6.760     0.200
    16.394     4.380     0.200
    16.402     6.250     0.200
    16.534     3.869     0.200
    16.509     7.196     0.200
    16.713     5.514     0.200
    16.784     7.013     0.200
    16.925     3.805     0.200
    16.896     6.107     0.200
    17.014     4.717     0.200
    17.015     4.813     0.200
    17.057     4.080     0.200
    17.068     3.639     0.200
    17.365     3.128     0.200
    17.441     3.293     0.200
    17.487     3.719     0.200
    17.701     1.868     0.200
    17.751     3.138     0.200
    17.989     2.012     0.200
    18.239     1.447     0.200
    18.254     2.360     0.200
    18.325     1.677     0.200
    18.200     6.220     0.200
    18.443     2.753     0.200
    19.938     1.971     0.200
    20.001     0.791     0.200
    20.363     1.652     0.200
    20.437     0.844     0.200
    20.567     0.734     0.200
    21.471     2.279     0.200
    21.653     0.725     0.200
    21.774     0.733     0.200
    22.108    -0.148     0.200
    22.589    -0.059     0.200
    22.880    -0.343     0.200
    23.242     0.335     0.200
    24.344     0.194     0.200
    25.696     1.198     0.200
    28.155    -0.524     0.200
    28.947     0.025     0.200
    28.947     0.326     0.200
    32.718    -0.940     0.200
    33.854    -0.151     0.200
    34.367     0.098     0.200
    39.327     0.100     0.200
    43.206     2.912     0.200
    45.499     1.783     0.200
    48.061     0.439     0.200
    51.941     3.842     0.200
    63.068     3.929     0.200
    66.275     2.385     0.200
    66.282     3.047     0.200
    68.539     2.127     0.200
    69.189     4.120     0.200
    70.942     2.410     0.200
    71.014     2.810     0.200
    71.075     2.803     0.200
    71.370     2.958     0.200
    72.242     2.779     0.200
    72.611     3.095     0.200
    73.394     0.547     0.200
    73.873     3.136     0.200
    74.152     2.972     0.200
    74.042     2.384     0.200
    74.715     1.987     0.200
    75.212     0.798     0.200
    75.273     3.007     0.200
    75.313     2.759     0.200
    75.706     2.835     0.200
    76.070     2.993     0.200
    76.750    -0.442     0.200
    77.000     3.069     0.200
    77.094     2.830     0.200
    78.083     4.497     0.200
    80.533     4.219     0.200
    81.472     3.836     0.200
    83.633     2.969     0.200
    84.458     3.557     0.200
    84.468     4.279     0.200
    84.893     5.703     0.200
    86.810     5.374     0.200
    88.274     2.284     0.200
    90.912     4.183     0.200
    14.269     9.437     0.200
    14.417     5.420     0.200
    14.641     6.867     0.200
    15.114     8.826     0.200
    15.118     8.583     0.200
    15.179     3.170     0.200
    16.061     7.826     0.200
    17.015     3.645     0.200
    17.052     4.292     0.200
    17.267     4.504     0.200
    17.484     4.700     0.200
    17.539     4.125     0.200
    17.672     2.885     0.200
    17.642     3.551     0.200
    18.121     1.656     0.200
    20.617    -0.506     0.200
    21.048     1.642     0.200
    21.017     0.572     0.200
    21.258     1.638     0.200
    21.277     2.568     0.200
    22.140     2.130     0.200
    22.290     1.733     0.200
    22.525     1.536     0.200
    27.399     2.887     0.200
    27.712     2.897     0.200
    27.834     2.274     0.200
    29.177     1.823     0.200
    34.249     0.320     0.200
    34.748     0.550     0.200
    39.552     2.945     0.200
    48.683     0.406     0.200
    62.306     1.764     0.200
    63.825     2.351     0.200
    63.891     3.344     0.200
    69.232     2.555     0.200
    76.195     1.122     0.200
    78.951     1.840     0.200
    88.988     2.849     0.200
    20.315     0.125     0.200
    21.675     2.768     0.200
    22.409     1.013     0.200
    22.465    -0.683     0.200
    25.549     0.621     0.200
    26.109    -0.394     0.200
    27.278     2.810     0.200
    68.666     0.253     0.200
    77.906     0.201     0.200
    20.475     2.266     0.200
    22.113     0.173     0.200
    25.662     1.764     0.200
    66.139     2.087     0.200
    20.555     1.592     0.200
    21.524     1.015     0.200
    21.653     0.662     0.200
    25.950     2.659     0.200
    35.161     1.215     0.200
    65.502     1.639     0.200
    19.902     1.183     0.200
    20.809     1.528     0.200
    15.130     4.231     0.200
    15.687     4.039     0.200
    17.480     3.677     0.200
    18.046     1.863     0.200
    19.960     2.376     0.200
    19.960     2.724     0.200
    20.299     1.073     0.200
    20.300     1.459     0.200
    20.300     1.459     0.200
    20.332     0.050     0.200
    20.586     0.454     0.200
    20.746     0.422     0.200
    20.746     0.461     0.200
    20.891     0.660     0.200
    20.893    -0.067     0.200
    21.199     1.188     0.200
    21.208     1.729     0.200
    21.221     0.699     0.200
    21.366     1.133     0.200
    21.906     0.542     0.200
    21.945    -0.283     0.200
    22.120     2.055     0.200
    22.196     2.238     0.200
    22.219     1.090     0.200
    22.274     2.412     0.200
    22.329     1.518     0.200
    22.329     1.268     0.200
    22.457     0.589     0.200
    22.716     2.614     0.200
    23.019     0.103     0.200
    23.127     0.263     0.200
    24.033     0.827     0.200
    24.650     1.998     0.200
    25.278     3.786     0.200
    26.144     4.341     0.200
    26.291     3.305     0.200
    28.424    -0.731     0.200
    30.680     3.823     0.200
    34.619     0.981     0.200
    60.843     0.754     0.200
    63.454     1.546     0.200
    64.413     1.420     0.200
    64.413     1.246     0.200
    70.475     0.764     0.200
    75.186     4.404     0.200
    21.153     2.248     0.200
    22.019     4.440     0.200
    33.895    -0.202     0.200
    39.298     0.470     0.200
    63.360     2.362     0.200
    14.464    11.183     0.200
    14.557     9.411     0.200
    14.587     6.205     0.200
    14.584     5.548     0.200
    14.636     5.837     0.200
    14.671     7.864     0.200
    14.731     8.231     0.200
    14.861     6.460     0.200
    15.058     6.680     0.200
    15.427     6.329     0.200
    15.432     4.962     0.200
    15.515     4.984     0.200
    16.008     5.375     0.200
    16.404     7.088     0.200
    16.589     4.865     0.200
    17.201     3.618     0.200
    17.246     5.053     0.200
    17.277     3.273     0.200
    17.289     4.729     0.200
    17.341     5.378     0.200
    17.373     3.480     0.200
    17.429     3.480     0.200
    17.732     3.218     0.200
    17.850     3.559     0.200
    17.850     3.571     0.200
    17.879     5.010     0.200
    18.298     2.849     0.200
    18.316     2.323     0.200
    18.316     2.529     0.200
    18.437     2.147     0.200
    18.460     1.108     0.200
    18.571     1.814     0.200
    18.775     1.846     0.200
    18.845     1.787     0.200
    19.005     1.850     0.200
    19.057     1.644     0.200
    19.075     1.995     0.200
    19.855     1.549     0.200
    19.960     0.195     0.200
    20.149     0.261     0.200
    20.159     2.348     0.200
    20.461     1.449     0.200
    20.530     2.320     0.200
    20.555     3.266     0.200
    20.572     2.346     0.200
    20.572     2.346     0.200
    20.799     0.425     0.200
    20.927     1.604     0.200
    20.839     2.077     0.200
    20.839     2.460     0.200
    21.066     1.003     0.200
    21.054     2.507     0.200
    21.131     2.385     0.200
    21.143    -0.329     0.200
    21.143     0.507     0.200
    21.180     0.880     0.200
    21.272     0.582     0.200
    21.360     2.831     0.200
    21.451     2.462     0.200
    21.509     2.127     0.200
    21.533     2.978     0.200
    21.705     1.132     0.200
    21.707     1.161     0.200
    21.853     2.919     0.200
    21.881     0.437     0.200
    22.119     2.263     0.200
    22.251     2.285     0.200
    22.270     0.940     0.200
    22.208     5.254     0.200
    22.312     0.246     0.200
    22.333     0.114     0.200
    22.479     2.133     0.200
    22.439     3.292     0.200
    22.439     3.589     0.200
    22.452     2.751     0.200
    22.532    -0.303     0.200
    22.532     2.900     0.200
    22.544     2.566     0.200
    22.521     3.031     0.200
    22.550     5.497     0.200
    22.559     6.112     0.200
    22.636     3.232     0.200
    22.709     2.912     0.200
    22.687     2.447     0.200
    22.740     1.487     0.200
    22.859     4.390     0.200
    22.881     2.599     0.200
    22.799     4.652     0.200
    22.799     4.464     0.200
    22.871     2.704     0.200
    22.913     0.130     0.200
    22.913     2.255     0.200
    22.975     3.744     0.200
    23.089     3.458     0.200
    23.308     3.455     0.200
    23.315     2.017     0.200
    23.317     1.970     0.200
    23.365     0.590     0.200
    23.418    -0.164     0.200
    23.479     2.395     0.200
    23.689     0.673     0.200
    23.689     0.220     0.200
    23.719     4.000     0.200
    23.719     3.508     0.200
    23.679     4.082     0.200
    23.999     3.740     0.200
    23.999     3.139     0.200
    24.003     4.702     0.200
    24.043     4.042     0.200
    24.081     4.198     0.200
    24.081     3.995     0.200
    24.237     3.269     0.200
    24.190     5.272     0.200
    24.252     5.529     0.200
    24.368     4.176     0.200
    24.474     5.910     0.200
    24.619     1.284     0.200
    24.984     2.965     0.200
    24.938     5.495     0.200
    25.138     2.562     0.200
    25.231     4.415     0.200
    25.388     3.088     0.200
    25.396     4.819     0.200
    25.396     5.319     0.200
    25.688     3.766     0.200
    25.762     0.762     0.200
    25.749     3.315     0.200
    25.834     6.508     0.200
    25.875     3.566     0.200
    26.035     5.652     0.200
    26.048     2.408     0.200
    26.304     2.309     0.200
    26.304     1.840     0.200
    26.328     2.172     0.200
    26.453     4.052     0.200
    26.613     2.198     0.200
    26.746     2.106     0.200
    27.302     1.998     0.200
    28.357     0.362     0.200
    28.994     4.167     0.200
    29.249     2.537     0.200
    29.670     3.127     0.200
    29.919     3.097     0.200
    29.919     2.573     0.200
    30.704     0.659     0.200
    30.704     2.456     0.200
    30.704     0.659     0.200
    31.109     3.790     0.200
    33.190     3.219     0.200
    34.776     1.240     0.200
    35.554     6.541     0.200
    36.354     5.382     0.200
    36.428     2.553     0.200
    36.428     3.147     0.200
    36.882     1.579     0.200
    38.508     1.018     0.200
    38.979     3.559     0.200
    39.197     4.230     0.200
    39.375    -1.014     0.200
    40.005     0.209     0.200
    40.106     6.058     0.200
    40.254     5.648     0.200
    40.254     2.586     0.200
    40.604     6.374     0.200
    44.195     3.512     0.200
    47.618     0.821     0.200
    48.840     2.758     0.200
    48.840     1.055     0.200
    49.986     5.702     0.200
    55.915    -0.760     0.200
    56.649     6.657     0.200
    56.847     2.561     0.200
    57.719     3.452     0.200
    57.719     3.233     0.200
    58.319     3.823     0.200
    60.331     1.907     0.200
    60.944     2.031     0.200
    60.959     3.623     0.200
    61.506     2.418     0.200
    61.506     1.340     0.200
    62.129     1.822     0.200
    62.825     2.970     0.200
    63.414     4.489     0.200
    63.996     2.518     0.200
    64.004     2.470     0.200
    64.004     2.470     0.200
    64.646     3.656     0.200
    65.150     3.063     0.200
    67.444     2.973     0.200
    67.840     2.270     0.200
    67.840     1.270     0.200
    69.394     1.861     0.200
    69.864     2.463     0.200
    70.104     3.694     0.200
    70.689     4.818     0.200
    71.874     2.446     0.200
    73.487     2.747     0.200
    73.914     3.745     0.200
    74.626     2.195     0.200
    75.131     5.365     0.200
    75.684     4.894     0.200
    75.832     3.044     0.200
    75.873     4.120     0.200
    76.111     0.556     0.200
    76.525     2.910     0.200
    76.649     1.810     0.200
    76.724     2.888     0.200
    76.743     2.778     0.200
    77.127    -0.430     0.200
    77.139     2.264     0.200
    77.270     2.406     0.200
    77.516     2.526     0.200
    77.617     1.964     0.200
    77.568     3.266     0.200
    77.568     3.048     0.200
    77.741     2.772     0.200
    77.822     3.626     0.200
    77.963     4.242     0.200
    78.074     3.222     0.200
    78.206     3.389     0.200
    78.417     3.021     0.200
    78.454     2.019     0.200
    78.454     1.816     0.200
    78.637     3.908     0.200
    78.756     2.457     0.200
    78.838     3.229     0.200
    79.209     4.164     0.200
    79.301     2.969     0.200
    79.426     3.083     0.200
    79.562     3.147     0.200
    79.733     4.013     0.200
    79.894     2.638     0.200
    79.895     2.839     0.200
    79.903     3.591     0.200
    80.070     3.486     0.200
    80.457     3.202     0.200
    80.671     4.453     0.200
    80.746     5.766     0.200
    80.854     2.179     0.200
    80.856     1.965     0.200
    80.946     3.783     0.200
    80.968     2.342     0.200
    81.676     3.509     0.200
    82.176     1.977     0.200
    82.203     3.438     0.200
    82.412     3.346     0.200
    82.622     3.351     0.200
    83.072     2.013     0.200
    84.367     3.776     0.200
    84.436     5.029     0.200
    85.397     3.394     0.200
    85.541     3.606     0.200
    86.131     0.348     0.200
    87.393     4.179     0.200
    87.398     3.953     0.200
    87.506     2.838     0.200
    90.275     2.186     0.200
    91.145     3.242     0.200
    91.350     1.579     0.200
    91.350     4.689     0.200
    92.251     3.214     0.200
    95.011     3.246     0.200
    95.011     2.019     0.200
    16.450     2.121     0.200
    20.040     1.582     0.200
    20.040     1.612     0.200
    25.219     2.167     0.200
    25.219     0.072     0.200
    62.727     1.541     0.200
    62.752     1.369     0.200
    65.273     1.727     0.200
    66.377     1.507     0.200
    18.507    -0.531     0.200
    19.461     2.567     0.200
    19.869     1.833     0.200
    20.079     1.893     0.200
    20.098     1.685     0.200
    20.159     0.585     0.200
    20.168     1.659     0.200
    20.525     2.512     0.200
    21.487     3.422     0.200
    21.602     3.082     0.200
    21.816     0.401     0.200
    21.959     3.462     0.200
    21.969     2.250     0.200
    22.096     2.791     0.200
    22.167     1.633     0.200
    22.167     0.055     0.200
    22.210     1.379     0.200
    22.297     0.949     0.200
    22.297     0.449     0.200
    22.547     1.883     0.200
    22.596     2.369     0.200
    22.678     1.907     0.200
    22.719     0.659     0.200
    22.973     3.178     0.200
    23.181     2.881     0.200
    23.200     3.580     0.200
    23.338     0.829     0.200
    23.341     2.796     0.200
    23.407     2.706     0.200
    23.421     2.454     0.200
    23.563     1.394     0.200
    23.666     0.978     0.200
    23.666     1.251     0.200
    23.716     1.705     0.200
    23.932     0.016     0.200
    23.932     2.125     0.200
    24.391     1.129     0.200
    24.442    -0.837     0.200
    24.499     0.949     0.200
    24.592     4.200     0.200
    24.708     2.241     0.200
    24.708     1.342     0.200
    24.888     2.597     0.200
    24.996     2.723     0.200
    25.042     3.799     0.200
    25.060    -0.060     0.200
    25.155     2.479     0.200
    25.155     3.377     0.200
    25.298     2.580     0.200
    25.416     1.358     0.200
    25.436     2.524     0.200
    25.619     4.560     0.200
    25.648     3.029     0.200
    25.648     4.397     0.200
    25.727     4.285     0.200
    26.873     3.720     0.200
    27.240     3.127     0.200
    27.856     2.925     0.200
    28.098     2.841     0.200
    30.924     3.708     0.200
    31.699     2.311     0.200
    32.584     2.443     0.200
    34.555     2.048     0.200
    35.801     0.761     0.200
    35.953     3.653     0.200
    36.352     3.865     0.200
    37.441     1.176     0.200
    49.684     1.511     0.200
    49.849     1.067     0.200
    49.849     1.224     0.200
    51.030     1.695     0.200
    51.723     2.340     0.200
    52.474     4.011     0.200
    56.978     1.736     0.200
    57.340     2.386     0.200
    61.882     2.572     0.200
    65.013     1.228     0.200
    66.120     1.752     0.200
    66.634     4.008     0.200
    67.296     1.524     0.200
    69.956     1.869     0.200
    74.669     2.139     0.200
    76.025     4.449     0.200
    76.155     2.652     0.200
    77.500     4.216     0.200
    77.575     2.294     0.200
    77.779     4.658     0.200
    77.866     4.079     0.200
    78.097     3.387     0.200
    78.106     2.941     0.200
    78.271     3.126     0.200
    78.675     2.348     0.200
    79.853     2.615     0.200
    80.080     6.025     0.200
    80.187     2.755     0.200
    80.872     4.177     0.200
    80.965     2.727     0.200
    82.570     3.811     0.200
    84.977     2.595     0.200
    85.343     4.464     0.200
    85.531     2.425     0.200
    86.113     5.415     0.200
    92.166     2.866     0.200
    92.706     3.216     0.200
    17.903     2.302     0.200
    19.500     1.885     0.200
    19.507     1.848     0.200
    21.163     1.332     0.200
    21.313     1.469     0.200
    21.654     4.004     0.200
    21.972     3.004     0.200
    22.133     4.184     0.200
    22.316     1.638     0.200
    22.367     0.902     0.200
    22.424     0.398     0.200
    22.760     1.965     0.200
    22.778     3.241     0.200
    22.862     1.622     0.200
    22.862     1.954     0.200
    23.199     1.443     0.200
    23.401     1.692     0.200
    23.434     0.784     0.200
    23.637     1.732     0.200
    25.343     3.884     0.200
    25.358     2.898     0.200
    25.660     5.605     0.200
    25.808     1.667     0.200
    26.420     3.007     0.200
    26.420     4.339     0.200
    27.786     3.563     0.200
    30.900     2.879     0.200
    35.067     1.316     0.200
    61.166     2.767     0.200
    64.746     2.443     0.200
    77.487     3.698     0.200
    16.296     8.992     0.200
    17.544     3.221     0.200
    17.575     5.210     0.200
    19.669     2.653     0.200
    19.729     1.150     0.200
    20.010     2.449     0.200
    20.007     1.529     0.200
    20.012     1.566     0.200
    20.012     1.476     0.200
    20.578     1.777     0.200
    20.639     2.421     0.200
    20.736     2.774     0.200
    21.051     3.542     0.200
    21.132     2.126     0.200
    21.214     1.643     0.200
    21.814     3.808     0.200
    22.021     0.836     0.200
    22.375     1.913     0.200
    22.375     0.714     0.200
    22.489     1.305     0.200
    22.506     1.725     0.200
    22.506     0.824     0.200
    22.751     2.724     0.200
    22.922     0.379     0.200
    23.405     0.309     0.200
    23.547     0.511     0.200
    23.547     2.213     0.200
    23.616     1.185     0.200
    23.616     6.080     0.200
    23.926     5.554     0.200
    24.138     0.940     0.200
    24.138     1.415     0.200
    24.405     1.681     0.200
    24.600     0.703     0.200
    24.914     1.342     0.200
    24.980     1.643     0.200
    25.112     2.038     0.200
    25.266     4.942     0.200
    25.219     2.388     0.200
    25.239     2.383     0.200
    25.329     4.068     0.200
    25.329     5.418     0.200
    25.531     2.534     0.200
    25.656     2.598     0.200
    25.778     3.928     0.200
    25.778     4.799     0.200
    26.263     4.104     0.200
    28.040     3.006     0.200
    28.040     3.237     0.200
    28.289     2.718     0.200
    28.291     2.704     0.200
    31.897    -0.588     0.200
    32.077     6.077     0.200
    32.739     1.323     0.200
    32.738     1.375     0.200
    34.433     1.168     0.200
    36.015     0.346     0.200
    36.015     0.396     0.200
    37.645     2.071     0.200
    41.246    -0.362     0.200
    41.517     0.389     0.200
    49.875     1.338     0.200
    50.051     1.186     0.200
    50.051     1.921     0.200
    57.107     4.386     0.200
    57.176     2.010     0.200
    61.020    -0.240     0.200
    62.664     1.768     0.200
    62.690     1.820     0.200
    64.704     2.040     0.200
    65.215     1.314     0.200
    65.216     1.805     0.200
    65.216     1.256     0.200
    66.311     2.443     0.200
    66.311     2.426     0.200
    66.327     2.246     0.200
    67.161     2.600     0.200
    70.096     0.355     0.200
    70.096     0.409     0.200
    71.016     3.001     0.200
    71.897     2.682     0.200
    76.359     3.726     0.200
    76.907     2.437     0.200
    77.356    -0.285     0.200
    77.665     3.488     0.200
    77.944     1.932     0.200
    77.944     2.033     0.200
    78.361     4.478     0.200
    78.845     1.901     0.200
    78.845     2.452     0.200
    80.054     3.265     0.200
    80.057     2.449     0.200
    80.057     2.490     0.200
    80.076     1.747     0.200
    80.391     1.648     0.200
    80.391     3.048     0.200
    80.453     3.715     0.200
    80.993     2.928     0.200
    80.993     2.879     0.200
    86.736     3.180     0.200
    87.335     0.969     0.200
    20.360    -0.505     0.200
    21.787     3.267     0.200
    39.347    -0.198     0.200
    64.514     0.605     0.200
    20.593    -0.134     0.200
    20.932     0.901     0.200
    20.937     0.601     0.200
    20.956     2.691     0.200
    20.956     1.449     0.200
    21.066     1.541     0.200
    21.066     1.080     0.200
    21.502     1.668     0.200
    22.106     2.317     0.200
    23.212     1.992     0.200
    26.469     1.315     0.200
    26.715     0.909     0.200
    31.582     4.047     0.200
    34.570     0.443     0.200
    38.628     1.669     0.200
    55.711     0.950     0.200
    63.439     5.584     0.200
    63.798     1.691     0.200
    64.949     3.046     0.200
    64.964     2.828     0.200
    69.305     1.359     0.200
    69.664     3.198     0.200
    76.876     5.389     0.200
    77.819     3.532     0.200
    85.927     0.384     0.200
    20.222    -0.336     0.200
    21.723     2.456     0.200
    20.238     0.040     0.200
    16.942     3.979     0.200
    17.294     2.582     0.200
    17.359     1.839     0.200
    17.395     3.026     0.200
    17.565     1.872     0.200
    17.533     2.338     0.200
    17.610     1.115     0.200
    17.894     1.354     0.200
    17.865     1.440     0.200
    17.910     1.784     0.200
    18.112     2.539     0.200
    18.104     4.521     0.200
    18.296     3.157     0.200
    19.640     0.629     0.200
    19.673     1.591     0.200
    19.830     1.819     0.200
    19.913     0.455     0.200
    20.239     0.544     0.200
    20.239     0.419     0.200
    20.239    -0.277     0.200
    20.266     0.421     0.200
    20.363     1.151     0.200
    20.363     0.241     0.200
    20.679     1.152     0.200
    20.833     0.166     0.200
    20.856     2.603     0.200
    20.856     1.912     0.200
    21.297     0.884     0.200
    21.303     0.881     0.200
    21.308     0.750     0.200
    21.315     0.338     0.200
    21.318     0.342     0.200
    21.321     1.918     0.200
    21.325     0.203     0.200
    21.328     0.565     0.200
    21.335     0.273     0.200
    21.358     0.205     0.200
    21.399     0.361     0.200
    21.471     0.285     0.200
    21.596     1.340     0.200
    21.675    -0.107     0.200
    21.710     0.753     0.200
    21.774    -0.060     0.200
    21.870    -0.085     0.200
    22.023     0.042     0.200
    22.023     0.198     0.200
    22.023    -0.130     0.200
    21.646     3.551     0.200
    22.456     0.868     0.200
    22.512    -0.229     0.200
    22.528     0.602     0.200
    22.588     0.468     0.200
    22.615     2.588     0.200
    22.799     0.919     0.200
    22.799     0.630     0.200
    22.799     0.122     0.200
    23.081     1.061     0.200
    23.155     1.049     0.200
    23.558     1.743     0.200
    23.555     1.884     0.200
    23.555     0.966     0.200
    23.990     2.136     0.200
    24.116     1.023     0.200
    24.256     0.258     0.200
    24.256     0.516     0.200
    24.427     1.986     0.200
    24.672     2.690     0.200
    25.231     2.437     0.200
    25.532     2.694     0.200
    25.596     2.154     0.200
    26.154     1.500     0.200
    26.154     2.851     0.200
    26.316     1.810     0.200
    26.316     3.102     0.200
    26.316     2.125     0.200
    26.725     3.440     0.200
    26.781     3.243     0.200
    27.138     4.227     0.200
    27.239     2.774     0.200
    28.947    -0.155     0.200
    29.860    -1.182     0.200
    29.860     0.014     0.200
    33.816    -0.301     0.200
    33.818    -1.613     0.200
    33.968     2.780     0.200
    34.878     4.046     0.200
    37.973     1.697     0.200
    39.327     0.186     0.200
    39.327     0.717     0.200
    43.242     0.137     0.200
    47.123     2.080     0.200
    47.123     2.287     0.200
    48.475     1.974     0.200
    50.271     3.046     0.200
    54.938     1.468     0.200
    55.070     1.164     0.200
    57.511     2.240     0.200
    57.511     2.877     0.200
    57.810     2.110     0.200
    57.810     1.973     0.200
    57.810     2.110     0.200
    58.307     2.630     0.200
    59.031     2.604     0.200
    59.036     3.302     0.200
    60.670     1.271     0.200
    60.726     2.384     0.200
    62.209     3.477     0.200
    62.736     1.635     0.200
    62.763     2.865     0.200
    62.923     2.788     0.200
    63.129     1.634     0.200
    63.129     1.384     0.200
    63.275     2.986     0.200
    63.421     2.289     0.200
    63.543     0.909     0.200
    63.741     2.319     0.200
    64.094     2.230     0.200
    64.139     1.498     0.200
    64.343     1.252     0.200
    64.343     1.845     0.200
    64.343     1.521     0.200
    65.289     4.233     0.200
    66.492     2.219     0.200
    66.770     1.401     0.200
    67.832     2.190     0.200
    68.688     2.252     0.200
    69.041     3.023     0.200
    69.070     3.359     0.200
    69.068     3.088     0.200
    69.350     2.304     0.200
    69.436     0.994     0.200
    70.161    -0.117     0.200
    70.719     2.503     0.200
    71.062     1.610     0.200
    74.232     1.639     0.200
    74.338     0.639     0.200
    74.358     2.082     0.200
    77.114     2.729     0.200
    77.114     2.061     0.200
    77.143     4.189     0.200
    77.143     1.295     0.200
    77.167     1.153     0.200
    77.303     1.819     0.200
    77.953     1.666     0.200
    77.953     1.854     0.200
    77.971     4.100     0.200
    78.284     2.040     0.200
    78.538     3.160     0.200
    79.100     2.620     0.200
    79.282     3.544     0.200
    80.421     2.276     0.200
    84.570     2.237     0.200
    85.268     1.214     0.200
    86.751     1.186     0.200
    90.747     4.185     0.200
    90.747     3.435     0.200
    95.587     0.992     0.200
    19.110     0.828     0.200
    19.569     0.563     0.200
    20.103     1.067     0.200
    20.103     1.778     0.200
    20.103     1.919     0.200
    20.237     2.279     0.200
    20.237     2.404     0.200
    21.159     1.643     0.200
    21.672     1.069     0.200
    21.860     0.837     0.200
    21.898     3.516     0.200
    25.691     4.308     0.200
    26.029     3.056     0.200
    27.255     1.311     0.200
    33.814    -0.063     0.200
    17.416     3.210     0.200
    17.773     5.201     0.200
    17.868     2.813     0.200
    19.388    -0.142     0.200
    20.007     0.941     0.200
    20.567     1.261     0.200
    20.711     2.150     0.200
    20.711     0.734     0.200
    20.711     2.029     0.200
    20.838     3.135     0.200
    20.838     1.766     0.200
    21.101     0.977     0.200
    21.409     0.824     0.200
    21.595     0.800     0.200
    21.825     0.723     0.200
    21.825     0.531     0.200
    21.843    -0.408     0.200
    21.947     3.209     0.200
    22.486     1.606     0.200
    22.667     3.201     0.200
    22.911     0.391     0.200
    23.060     0.083     0.200
    23.262     1.629     0.200
    25.082     3.608     0.200
    25.463     4.558     0.200
    26.534     0.905     0.200
    26.534     2.210     0.200
    26.722     2.093     0.200
    26.727     3.266     0.200
    27.030     1.393     0.200
    27.504     4.064     0.200
    29.316     1.500     0.200
    31.448     3.468     0.200
    31.448     3.259     0.200
    31.448     3.509     0.200
    34.324     0.912     0.200
    34.324     1.085     0.200
    38.313     1.187     0.200
    50.570     3.837     0.200
    50.570     3.786     0.200
    61.099     1.079     0.200
    61.096     3.209     0.200
    63.582     1.537     0.200
    64.754     1.946     0.200
    64.754     0.520     0.200
    64.754     1.786     0.200
    69.099     1.467     0.200
    77.585     3.013     0.200
    78.413     2.440     0.200
    20.711     0.884     0.200
    21.191     1.495     0.200
    16.693     3.593     0.200
    18.493     1.156     0.200
    20.792     3.524     0.200
    21.222     0.897     0.200
    26.239     3.260     0.200
    69.432     1.355     0.200
    21.923     1.705     0.200
    62.236     1.228     0.200
    15.293     6.927     0.200
    16.107     4.008     0.200
    17.037     5.214     0.200
    17.586     2.539     0.200
    17.586     3.797     0.200
    18.045     3.435     0.200
    18.391     2.617     0.200
    18.436     2.246     0.200
    19.009     1.706     0.200
    19.100     0.381     0.200
    19.120     1.445     0.200
    19.246     1.665     0.200
    19.268     1.214     0.200
    19.358     1.326     0.200
    19.374     3.201     0.200
    19.570     3.888     0.200
    19.694     1.762     0.200
    19.694     3.402     0.200
    19.732     2.987     0.200
    19.853     2.149     0.200
    19.871     1.121     0.200
    19.983     2.382     0.200
    19.983     2.546     0.200
    20.033     2.065     0.200
    20.142     1.086     0.200
    20.081     1.555     0.200
    20.081     1.290     0.200
    20.081     1.641     0.200
    20.272     2.506     0.200
    20.272     2.693     0.200
    20.283     1.356     0.200
    20.534     1.305     0.200
    20.640     0.718     0.200
    20.796     1.388     0.200
    20.813     1.495     0.200
    20.836     2.176     0.200
    20.838     1.872     0.200
    20.838     2.161     0.200
    20.868     2.014     0.200
    20.958     0.432     0.200
    20.958    -0.099     0.200
    21.252     1.801     0.200
    21.300     1.823     0.200
    21.342     0.832     0.200
    21.342     1.012     0.200
    21.342     0.144     0.200
    21.342     1.012     0.200
    21.480     0.981     0.200
    21.480     1.419     0.200
    21.620     2.021     0.200
    21.620     0.977     0.200
    21.732     1.327     0.200
    21.766     3.756     0.200
    21.766     1.365     0.200
    21.844     0.761     0.200
    21.908     1.426     0.200
    21.941     1.500     0.200
    21.984     1.324     0.200
    22.351     0.179     0.200
    22.486     0.815     0.200
    22.515     0.960     0.200
    22.528     2.134     0.200
    22.528     1.079     0.200
    22.591     2.253     0.200
    22.591     0.753     0.200
    22.671     1.703     0.200
    22.806     0.935     0.200
    22.824     0.390     0.200
    22.824     0.882     0.200
    22.867     2.208     0.200
    22.870     1.597     0.200
    22.884     2.306     0.200
    22.884     1.408     0.200
    23.080     0.380     0.200
    23.080     0.981     0.200
    23.080     0.739     0.200
    23.573     1.762     0.200
    23.573     2.121     0.200
    23.617     0.666     0.200
    23.647     1.386     0.200
    23.662     1.049     0.200
    23.702     1.280     0.200
    23.791     0.672     0.200
    23.791     1.188     0.200
    23.856     0.207     0.200
    23.856     1.378     0.200
    23.856     1.269     0.200
    25.482     1.462     0.200
    25.509     2.997     0.200
    25.682     2.073     0.200
    26.866     1.577     0.200
    30.184     1.402     0.200
    30.375     1.051     0.200
    30.780     0.413     0.200
    31.526     1.749     0.200
    33.484     1.813     0.200
    35.104     0.800     0.200
    38.524     1.976     0.200
    38.937     1.973     0.200
    48.959     0.537     0.200
    50.055     1.562     0.200
    53.217     1.731     0.200
    58.449     0.881     0.200
    58.697     1.950     0.200
    58.808     1.672     0.200
    59.556     1.267     0.200
    59.585     1.143     0.200
    61.531     1.771     0.200
    61.558     1.105     0.200
    63.504     2.246     0.200
    64.124     1.602     0.200
    64.951     1.510     0.200
    65.157     1.095     0.200
    65.157     0.963     0.200
    65.157     2.064     0.200
    67.041     2.276     0.200
    70.190     2.448     0.200
    73.646     1.497     0.200
    75.564     2.980     0.200
    75.687     1.115     0.200
    76.099     2.482     0.200
    76.452     1.784     0.200
    77.100     2.753     0.200
    77.743     3.286     0.200
    78.130     2.880     0.200
    78.347     2.702     0.200
    78.428     1.668     0.200
    78.685     1.935     0.200
    78.978     2.188     0.200
    79.009     2.588     0.200
    81.733     3.232     0.200
    86.227     1.883     0.200
    88.597     1.858     0.200
    91.104     2.036     0.200
    20.540     1.981     0.200
    21.657     1.070     0.200
    25.887     2.382     0.200
    65.648     2.291     0.200
    77.692     1.109     0.200
    20.560     0.917     0.200
    21.654     0.531     0.200
    14.301     5.969     0.200
    14.404     5.381     0.200
    15.864     4.458     0.200
    15.864     4.278     0.200
    16.114     7.882     0.200
    16.143     6.863     0.200
    17.126     5.075     0.200
    17.133     3.452     0.200
    17.298     5.179     0.200
    17.678     3.329     0.200
    17.772     3.245     0.200
    17.783     2.689     0.200
    17.783     3.339     0.200
    17.835     4.034     0.200
    17.927     2.425     0.200
    18.088    -0.195     0.200
    18.150     2.570     0.200
    18.318     3.425     0.200
    18.549     2.051     0.200
    18.639     1.475     0.200
    18.693     1.586     0.200
    18.693     2.025     0.200
    18.693     3.056     0.200
    18.701     1.516     0.200
    18.717     1.511     0.200
    18.756     1.677     0.200
    18.863     2.132     0.200
    18.863     2.452     0.200
    18.873     2.374     0.200
    18.953     1.493     0.200
    18.975     1.352     0.200
    19.015     2.133     0.200
    19.015     1.957     0.200
    19.122     2.138     0.200
    19.226     1.826     0.200
    19.226     2.867     0.200
    19.262     3.678     0.200
    19.342     2.363     0.200
    19.434     2.017     0.200
    19.489     5.570     0.200
    19.504     2.197     0.200
    19.547     2.341     0.200
    19.574     1.352     0.200
    19.681     1.706     0.200
    19.681     1.893     0.200
    19.708     2.131     0.200
    19.847     1.315     0.200
    19.928     1.918     0.200
    19.928     2.797     0.200
    19.963     2.295     0.200
    19.963     3.014     0.200
    20.000     1.839     0.200
    20.109     1.601     0.200
    20.127    -0.153     0.200
    20.161     1.794     0.200
    20.210     4.273     0.200
    20.231     1.870     0.200
    20.266     5.319     0.200
    20.235     1.802     0.200
    20.315     1.913     0.200
    20.331     1.918     0.200
    20.431     1.356     0.200
    20.506     5.516     0.200
    20.515     1.661     0.200
    20.545     1.919     0.200
    20.561     2.385     0.200
    20.561     1.360     0.200
    20.553     1.036     0.200
    20.553     5.597     0.200
    20.596     1.767     0.200
    20.596     3.062     0.200
    20.590     2.276     0.200
    20.668     5.334     0.200
    20.658     0.841     0.200
    20.658     1.161     0.200
    20.749     1.253     0.200
    20.842     5.571     0.200
    20.876     0.024     0.200
    20.876     2.139     0.200
    20.927     2.956     0.200
    20.944     2.027     0.200
    20.944     1.601     0.200
    20.944     1.877     0.200
    20.978     5.647     0.200
    20.966     2.184     0.200
    20.966     1.753     0.200
    20.966     1.893     0.200
    21.035     0.802     0.200
    21.049     1.442     0.200
    21.049     0.596     0.200
    21.113     4.838     0.200
    21.116     2.153     0.200
    21.157     0.693     0.200
    21.190     1.221     0.200
    21.190     1.102     0.200
    21.190     0.872     0.200
    21.190     2.301     0.200
    21.196     2.022     0.200
    21.196     2.471     0.200
    21.325     0.247     0.200
    21.377     1.858     0.200
    21.447     4.136     0.200
    21.447     3.825     0.200
    21.459     0.935     0.200
    21.459     1.665     0.200
    21.503     4.183     0.200
    21.503     2.416     0.200
    21.503     3.923     0.200
    21.539     0.863     0.200
    21.557     0.503     0.200
    21.563     1.576     0.200
    21.563     2.553     0.200
    21.539     2.588     0.200
    21.568     1.943     0.200
    21.628     3.314     0.200
    21.601     0.532     0.200
    21.630     0.754     0.200
    21.630     1.209     0.200
    21.633     0.849     0.200
    21.642     3.301     0.200
    21.670     3.554     0.200
    21.693     1.291     0.200
    21.686     3.041     0.200
    21.704     3.284     0.200
    21.720     1.832     0.200
    21.766     1.294     0.200
    21.775     3.314     0.200
    21.781     1.969     0.200
    21.881     1.619     0.200
    21.969     4.400     0.200
    21.969     5.749     0.200
    21.951     1.621     0.200
    21.963     1.179     0.200
    21.963     1.644     0.200
    21.982     0.429     0.200
    21.990     1.725     0.200
    22.023     2.432     0.200
    22.106     1.705     0.200
    22.105     2.257     0.200
    22.136     2.443     0.200
    22.166     0.845     0.200
    22.166     2.439     0.200
    22.166     3.128     0.200
    22.187     1.324     0.200
    22.168     1.194     0.200
    22.236     3.366     0.200
    22.219     1.267     0.200
    22.219     1.029     0.200
    22.201     2.123     0.200
    22.255     3.617     0.200
    22.239     0.760     0.200
    22.239     0.359     0.200
    22.246     2.581     0.200
    22.244     1.523     0.200
    22.245     2.659     0.200
    22.256     1.865     0.200
    22.295     2.176     0.200
    22.295     4.023     0.200
    22.276     2.327     0.200
    22.366    -0.947     0.200
    22.400     3.468     0.200
    22.400     3.298     0.200
    22.432     1.903     0.200
    22.485     3.329     0.200
    22.491     4.420     0.200
    22.531     0.253     0.200
    22.531     2.253     0.200
    22.531     0.448     0.200
    22.531     2.054     0.200
    22.531     0.964     0.200
    22.561     4.928     0.200
    22.524     0.836     0.200
    22.564     1.501     0.200
    22.564     1.721     0.200
    22.603     0.154     0.200
    22.603     1.297     0.200
    22.631     2.897     0.200
    22.659     2.134     0.200
    22.659     2.793     0.200
    22.713     2.502     0.200
    22.663     1.782     0.200
    22.700     2.322     0.200
    22.700     1.510     0.200
    22.700     2.193     0.200
    22.728     1.158     0.200
    22.781     0.721     0.200
    22.781     0.428     0.200
    22.781     0.602     0.200
    22.781     1.102     0.200
    22.781     0.891     0.200
    22.776     1.023     0.200
    22.868     0.294     0.200
    22.890     0.713     0.200
    23.016     1.490     0.200
    23.039    -0.208     0.200
    23.063     0.522     0.200
    23.063     1.832     0.200
    23.065     1.240     0.200
    23.060     2.589     0.200
    23.128     1.402     0.200
    23.159     2.424     0.200
    23.223     1.412     0.200
    23.223     2.090     0.200
    23.210     3.649     0.200
    23.221     1.515     0.200
    23.221     1.921     0.200
    23.243    -0.389     0.200
    23.253     1.275     0.200
    23.253     1.797     0.200
    23.282     0.609     0.200
    23.282     1.019     0.200
    23.324     0.567     0.200
    23.324     2.168     0.200
    23.324     1.028     0.200
    23.366     1.212     0.200
    23.411     0.050     0.200
    23.413     1.120     0.200
    23.450     0.846     0.200
    23.470    -0.450     0.200
    23.481     1.346     0.200
    23.487     0.251     0.200
    23.487     5.390     0.200
    23.484     1.004     0.200
    23.556     0.254     0.200
    23.556    -0.228     0.200
    23.556     0.865     0.200
    23.556     0.565     0.200
    23.605     4.340     0.200
    23.641     1.842     0.200
    23.641     0.682     0.200
    23.641     1.992     0.200
    23.688     0.026     0.200
    23.688     1.795     0.200
    23.737     0.957     0.200
    23.726     1.085     0.200
    23.724     0.990     0.200
    23.724     4.625     0.200
    23.747     0.861     0.200
    23.747     0.392     0.200
    23.747     1.783     0.200
    23.771     1.000     0.200
    23.768     0.603     0.200
    23.768     0.124     0.200
    23.768     0.913     0.200
    23.768     0.773     0.200
    23.797     1.648     0.200
    23.902     1.311     0.200
    23.925     1.431     0.200
    23.982     0.728     0.200
    24.047     0.376     0.200
    24.244     3.010     0.200
    24.244     0.610     0.200
    24.314     1.542     0.200
    24.383     1.464     0.200
    24.399     5.263     0.200
    24.399     5.452     0.200
    24.391     4.513     0.200
    24.410     1.549     0.200
    24.635     0.947     0.200
    24.637     3.136     0.200
    24.640     1.006     0.200
    24.679     1.026     0.200
    24.679     1.522     0.200
    24.669     2.682     0.200
    24.700     2.189     0.200
    24.703     1.007     0.200
    24.736     1.424     0.200
    24.753     1.651     0.200
    24.753     3.086     0.200
    24.753     2.942     0.200
    24.798     1.803     0.200
    24.798     2.133     0.200
    24.751     2.652     0.200
    24.836     2.367     0.200
    24.927     0.120     0.200
    24.927     1.470     0.200
    24.985     0.957     0.200
    24.985     1.697     0.200
    24.985     2.027     0.200
    25.010     2.076     0.200
    25.033     1.604     0.200
    25.080     2.234     0.200
    25.080     3.574     0.200
    25.176     1.496     0.200
    25.133     1.979     0.200
    25.171     2.926     0.200
    25.171     3.715     0.200
    25.171     3.905     0.200
    25.316     3.122     0.200
    25.342     2.209     0.200
    25.529     2.086     0.200
    25.572     2.663     0.200
    25.572     2.958     0.200
    25.623     2.379     0.200
    25.656     2.131     0.200
    25.741     0.216     0.200
    25.741     2.136     0.200
    25.730     1.321     0.200
    25.783     2.079     0.200
    25.787     1.208     0.200
    25.787     1.554     0.200
    25.783     1.840     0.200
    25.799     1.841     0.200
    25.832     2.186     0.200
    25.832     1.788     0.200
    25.832     2.356     0.200
    25.832     2.967     0.200
    25.812     1.581     0.200
    25.922     1.875     0.200
    25.922     2.321     0.200
    25.922     2.520     0.200
    25.922     2.631     0.200
    25.905     2.235     0.200
    26.087     2.461     0.200
    26.087     1.666     0.200
    26.087     1.832     0.200
    26.087     2.631     0.200
    26.087     2.733     0.200
    26.087     2.072     0.200
    26.191     1.787     0.200
    26.172     2.064     0.200
    26.176     2.058     0.200
    26.243     1.836     0.200
    26.243     2.416     0.200
    26.346     3.182     0.200
    26.384     0.842     0.200
    26.415     2.365     0.200
    26.446     2.494     0.200
    26.446     5.882     0.200
    26.536     1.792     0.200
    26.536     2.472     0.200
    26.536     2.651     0.200
    26.555     4.941     0.200
    26.629     1.914     0.200
    26.637     5.827     0.200
    26.822     2.308     0.200
    26.822     1.702     0.200
    26.822     2.189     0.200
    26.824     2.137     0.200
    26.821     1.158     0.200
    26.825     2.569     0.200
    26.833     1.974     0.200
    26.846     2.380     0.200
    26.843     4.207     0.200
    26.843     4.387     0.200
    27.107     1.741     0.200
    27.118     1.648     0.200
    27.175     1.524     0.200
    27.175     2.516     0.200
    27.175     3.766     0.200
    27.193     2.147     0.200
    27.332     0.611     0.200
    27.332     2.705     0.200
    27.332     1.615     0.200
    27.424     1.968     0.200
    27.686    -0.061     0.200
    27.924     0.700     0.200
    27.932     1.900     0.200
    27.932     3.728     0.200
    28.035     0.902     0.200
    28.551    -0.984     0.200
    28.734     3.890     0.200
    28.799     2.508     0.200
    28.834     2.301     0.200
    28.890     2.302     0.200
    28.911     0.066     0.200
    28.911     1.806     0.200
    28.911     2.906     0.200
    28.975     0.123     0.200
    29.289     2.161     0.200
    30.157     0.672     0.200
    30.157     0.598     0.200
    30.177     1.664     0.200
    30.357     2.607     0.200
    30.361     2.569     0.200
    30.368     2.603     0.200
    30.389     2.523     0.200
    30.393     2.583     0.200
    30.403     2.491     0.200
    30.420     2.345     0.200
    30.439     1.377     0.200
    30.452     2.448     0.200
    30.452     2.318     0.200
    30.464    -0.593     0.200
    30.464     2.852     0.200
    30.464     3.352     0.200
    30.464     1.352     0.200
    31.148     4.771     0.200
    31.187     2.605     0.200
    31.187     1.673     0.200
    31.187     3.275     0.200
    32.015    -0.707     0.200
    33.185     0.209     0.200
    33.185     1.340     0.200
    33.185     0.388     0.200
    33.185     0.728     0.200
    33.155     3.229     0.200
    33.357     6.488     0.200
    33.492     1.703     0.200
    34.332    -0.134     0.200
    34.843     0.692     0.200
    34.843     1.003     0.200
    34.845     1.030     0.200
    36.262     2.052     0.200
    36.565     1.760     0.200
    36.587    -0.524     0.200
    36.607    -0.695     0.200
    36.656     5.086     0.200
    36.721    -0.168     0.200
    36.793    -0.477     0.200
    37.316     1.516     0.200
    37.680     0.750     0.200
    38.013     1.276     0.200
    38.038     2.268     0.200
    38.042     3.636     0.200
    38.154     0.285     0.200
    38.187     1.882     0.200
    38.187     2.206     0.200
    38.694     3.151     0.200
    38.835     1.556     0.200
    39.205    -1.098     0.200
    39.700     3.139     0.200
    39.967    -0.982     0.200
    40.530     0.323     0.200
    40.530     0.778     0.200
    41.042     0.789     0.200
    41.234     0.449     0.200
    41.842     1.457     0.200
    41.962     0.680     0.200
    43.797     2.303     0.200
    44.009     1.100     0.200
    44.454     5.025     0.200
    44.454     4.845     0.200
    44.737     2.774     0.200
    46.680     2.974     0.200
    46.680     5.214     0.200
    46.680     4.154     0.200
    47.065     2.689     0.200
    48.538     1.205     0.200
    48.549     1.221     0.200
    48.549     1.491     0.200
    49.727     1.993     0.200
    49.727     1.723     0.200
    49.803     1.896     0.200
    51.552     4.777     0.200
    52.893     2.161     0.200
    54.522     4.326     0.200
    55.689     2.863     0.200
    55.735     2.258     0.200
    58.019     3.286     0.200
    58.044     6.496     0.200
    58.114     1.708     0.200
    58.114     1.449     0.200
    58.471     2.466     0.200
    58.929     2.057     0.200
    59.219     2.758     0.200
    60.667     1.445     0.200
    60.667     3.066     0.200
    61.044     2.308     0.200
    61.044     3.759     0.200
    61.044     3.169     0.200
    61.125     3.023     0.200
    61.211     1.705     0.200
    61.238     1.848     0.200
    62.613     2.719     0.200
    63.055     3.543     0.200
    63.153     3.668     0.200
    63.224     5.196     0.200
    63.167     2.510     0.200
    63.667     4.144     0.200
    63.814     1.831     0.200
    63.814     1.731     0.200
    63.814     1.461     0.200
    64.161     3.194     0.200
    64.155     2.842     0.200
    64.625     2.122     0.200
    64.831     1.170     0.200
    64.831     1.721     0.200
    64.831     1.530     0.200
    65.429     3.634     0.200
    66.111     1.548     0.200
    66.687     3.180     0.200
    66.896     1.270     0.200
    67.024     1.129     0.200
    67.024     1.805     0.200
    67.477     2.682     0.200
    68.003     2.215     0.200
    69.525     4.177     0.200
    70.087     3.990     0.200
    70.204     1.422     0.200
    70.204     0.338     0.200
    70.241     1.962     0.200
    71.003     1.630     0.200
    71.003     3.500     0.200
    72.286     2.000     0.200
    73.799     1.243     0.200
    74.859     2.578     0.200
    75.531     5.098     0.200
    76.297     3.281     0.200
    76.624     4.688     0.200
    76.624     4.108     0.200
    77.423     2.079     0.200
    77.423     2.229     0.200
    77.423     1.649     0.200
    78.073     3.508     0.200
    78.073     2.633     0.200
    78.073     3.248     0.200
    78.551     2.075     0.200
    78.551     1.814     0.200
    78.628     2.187     0.200
    78.628     1.786     0.200
    78.671     2.852     0.200
    78.699     2.505     0.200
    79.008     0.496     0.200
    79.373    -0.499     0.200
    79.578     2.286     0.200
    80.377     2.061     0.200
    80.746     1.913     0.200
    80.984     1.762     0.200
    81.379     1.701     0.200
    81.856     1.552     0.200
    81.884     3.305     0.200
    81.929     3.185     0.200
    83.180     5.661     0.200
    84.126     4.103     0.200
    84.076     4.198     0.200
    85.912     1.368     0.200
    88.260     3.481     0.200
    89.073    -0.753     0.200
    89.794     6.868     0.200
    90.565     5.565     0.200
    90.766     3.289     0.200
    90.766     1.840     0.200
    90.766     3.439     0.200
    91.818     1.660     0.200
    94.399     1.265     0.200
    96.174     0.658     0.200
    17.417     3.167     0.200
    20.119     3.887     0.200
    20.071     2.540     0.200
    20.748     1.880     0.200
    20.779     1.022     0.200
    20.779     0.662     0.200
    20.995     3.832     0.200
    21.169     0.660     0.200
    21.169     0.836     0.200
    21.310     0.678     0.200
    21.310     1.307     0.200
    21.310     0.866     0.200
    21.445     2.848     0.200
    21.660     1.409     0.200
    21.755     0.232     0.200
    21.813     4.103     0.200
    22.079     4.147     0.200
    22.305     3.159     0.200
    22.358     0.982     0.200
    22.358     1.635     0.200
    22.648     1.445     0.200
    22.648     1.605     0.200
    22.648     1.866     0.200
    22.645    -0.261     0.200
    22.645     0.079     0.200
    22.685     0.609     0.200
    22.685     2.296     0.200
    22.721     2.238     0.200
    22.801     2.762     0.200
    22.901     2.021     0.200
    22.901     0.033     0.200
    23.184     4.648     0.200
    23.402     3.549     0.200
    23.402     4.307     0.200
    23.444     2.614     0.200
    23.487     1.096     0.200
    23.531     2.823     0.200
    23.677     1.908     0.200
    23.677     2.787     0.200
    23.677     2.427     0.200
    24.023     1.436     0.200
    24.318     1.537     0.200
    24.863     1.837     0.200
    25.745     5.031     0.200
    25.745     4.566     0.200
    26.944     1.797     0.200
    30.061     1.307     0.200
    30.262     1.803     0.200
    34.958     0.526     0.200
    34.958     0.163     0.200
    40.636     0.509     0.200
    49.849     1.740     0.200
    58.234     2.420     0.200
    58.234     0.881     0.200
    61.333     1.517     0.200
    61.360     2.236     0.200
    63.286     2.190     0.200
    63.936     1.930     0.200
    64.953     1.806     0.200
    64.953     1.076     0.200
    68.059     1.782     0.200
    70.240     3.831     0.200
    73.651     2.011     0.200
    78.687     3.682     0.200
    78.792     2.182     0.200
    90.879     4.015     0.200
    14.399     5.936     0.200
    15.916     3.402     0.200
    16.912     3.808     0.200
    16.995     5.455     0.200
    17.050     2.697     0.200
    17.680     1.953     0.200
    17.771     3.528     0.200
    18.089     1.764     0.200
    18.149     1.973     0.200
    18.345     2.071     0.200
    18.755     1.366     0.200
    18.974     1.426     0.200
    19.071     4.787     0.200
    19.428     2.230     0.200
    19.574     1.270     0.200
    19.714     2.041     0.200
    20.148     0.827     0.200
    20.148     0.975     0.200
    20.428     2.251     0.200
    20.557     0.329     0.200
    20.559     4.805     0.200
    20.659     1.581     0.200
    20.946     2.060     0.200
    20.946     1.481     0.200
    20.975     1.374     0.200
    20.975     2.054     0.200
    21.049     0.889     0.200
    21.049     1.499     0.200
    21.049     0.842     0.200
    21.325     1.568     0.200
    21.540     1.218     0.200
    21.635     1.904     0.200
    21.692     3.517     0.200
    22.022     2.024     0.200
    22.170     2.187     0.200
    22.219     1.987     0.200
    22.219     1.393     0.200
    22.238     2.087     0.200
    22.366     2.317     0.200
    22.527     1.705     0.200
    22.524     0.839     0.200
    22.524     0.948     0.200
    22.566     1.098     0.200
    22.601     2.726     0.200
    22.601     2.991     0.200
    22.781     0.836     0.200
    22.781     1.328     0.200
    23.281     2.135     0.200
    23.281     2.494     0.200
    23.265     1.659     0.200
    23.557     1.308     0.200
    23.557     0.988     0.200
    23.557     1.925     0.200
    23.903     4.682     0.200
    24.739     0.658     0.200
    25.318     3.826     0.200
    25.848     1.296     0.200
    25.848     1.562     0.200
    26.543     1.652     0.200
    26.828     1.885     0.200
    31.201     3.485     0.200
    31.201     2.008     0.200
    34.838     0.545     0.200
    34.838    -0.455     0.200
    38.198     2.549     0.200
    48.511     2.139     0.200
    48.511     1.999     0.200
    48.552     0.851     0.200
    49.734     1.472     0.200
    55.739     1.357     0.200
    58.123     3.366     0.200
    58.123     3.093     0.200
    61.215     1.805     0.200
    61.242     1.489     0.200
    63.018     3.432     0.200
    63.817     1.133     0.200
    63.817     1.102     0.200
    64.631     1.861     0.200
    64.837     1.667     0.200
    64.837     1.495     0.200
    67.048     1.188     0.200
    67.048     1.524     0.200
    70.180     2.330     0.200
    70.180     1.252     0.200
    78.524     2.154     0.200
    78.524     1.552     0.200
    78.607     3.343     0.200
    78.607     2.250     0.200
    78.673     2.177     0.200
    78.673     1.552     0.200
    81.902     3.717     0.200
    81.902     2.772     0.200
    90.780     3.611     0.200
    90.780     1.916     0.200
    20.116     1.875     0.200
    21.130     0.541     0.200
    31.283     3.150     0.200
    64.922     1.600     0.200
    16.294     4.761     0.200
    16.294     3.292     0.200
    16.480     6.198     0.200
    16.861     5.020     0.200
    17.120     4.252     0.200
    17.120     3.020     0.200
    17.167     2.614     0.200
    17.228     3.709     0.200
    17.244     3.895     0.200
    17.366     2.674     0.200
    17.397     3.537     0.200
    17.503     3.414     0.200
    17.515     3.758     0.200
    17.561     2.683     0.200
    17.694     3.061     0.200
    17.769     4.340     0.200
    17.994     1.984     0.200
    18.067     2.942     0.200
    18.141     4.152     0.200
    18.309     2.237     0.200
    18.584     1.838     0.200
    19.438     0.735     0.200
    19.454     1.350     0.200
    19.476     1.945     0.200
    19.473     2.250     0.200
    19.500     1.843     0.200
    19.549     1.995     0.200
    19.531     2.095     0.200
    19.757     0.869     0.200
    19.757     0.395     0.200
    20.071     0.745     0.200
    20.071     1.338     0.200
    20.071     0.284     0.200
    20.121     2.520     0.200
    20.192     1.609     0.200
    20.192     2.148     0.200
    20.192     1.398     0.200
    20.322     1.602     0.200
    20.531     1.366     0.200
    20.603     1.609     0.200
    20.683     0.774     0.200
    20.806     1.787     0.200
    20.805     1.403     0.200
    20.901     1.817     0.200
    21.060     1.108     0.200
    21.077     2.429     0.200
    21.109     2.080     0.200
    21.226     2.620     0.200
    21.260     0.095     0.200
    21.260     1.645     0.200
    21.287     2.788     0.200
    21.407     0.916     0.200
    21.407     1.816     0.200
    21.407     3.086     0.200
    21.528     3.023     0.200
    21.528     4.642     0.200
    21.501     1.123     0.200
    21.501     0.514     0.200
    21.501     2.195     0.200
    21.616    -0.024     0.200
    21.616     0.185     0.200
    21.721     0.815     0.200
    21.721     1.145     0.200
    21.864     0.386     0.200
    21.864    -0.854     0.200
    21.864    -0.483     0.200
    21.864    -0.122     0.200
    21.920     3.150     0.200
    21.992     2.313     0.200
    22.202     4.046     0.200
    22.285     0.093     0.200
    22.343     1.209     0.200
    22.343     0.270     0.200
    22.413     1.070     0.200
    22.360     3.388     0.200
    22.564     1.269     0.200
    22.634     1.222     0.200
    22.640    -0.970     0.200
    22.640     0.065     0.200
    22.640     0.665     0.200
    22.640     0.915     0.200
    22.673     1.710     0.200
    22.984     2.642     0.200
    23.020     0.258     0.200
    23.020     2.682     0.200
    23.015     1.646     0.200
    23.364     2.226     0.200
    23.446     1.422     0.200
    23.491     2.377     0.200
    23.467     2.113     0.200
    23.889     1.746     0.200
    23.996     0.744     0.200
    24.311     1.028     0.200
    24.533     1.211     0.200
    24.714     0.825     0.200
    24.891     3.021     0.200
    24.891     3.303     0.200
    25.135     2.113     0.200
    25.455    -0.419     0.200
    25.436     1.997     0.200
    25.436     0.653     0.200
    25.436     1.583     0.200
    25.808     2.284     0.200
    26.058     2.602     0.200
    26.058     0.623     0.200
    26.058    -0.287     0.200
    26.058     2.742     0.200
    26.198     2.517     0.200
    26.199     1.318     0.200
    26.199     2.441     0.200
    26.627     2.434     0.200
    26.684     2.128     0.200
    26.684     1.386     0.200
    26.714     2.599     0.200
    27.505     2.362     0.200
    28.010     0.571     0.200
    28.063    -2.199     0.200
    28.366     1.140     0.200
    28.571     3.377     0.200
    28.712    -0.971     0.200
    28.890    -0.560     0.200
    29.118     2.319     0.200
    29.699    -2.232     0.200
    29.713     0.500     0.200
    29.725    -1.038     0.200
    31.111     2.693     0.200
    33.609    -0.526     0.200
    43.012     2.314     0.200
    43.012     1.445     0.200
    43.077    -0.235     0.200
    44.927    -0.150     0.200
    46.885     0.911     0.200
    47.696     2.607     0.200
    48.228     1.345     0.200
    48.938     1.899     0.200
    49.169     2.529     0.200
    50.261     1.953     0.200
    53.746     1.452     0.200
    58.970     1.585     0.200
    58.970     1.245     0.200
    60.537     0.733     0.200
    60.537     0.864     0.200
    60.636     1.750     0.200
    62.703     2.104     0.200
    62.976     0.687     0.200
    64.224     0.450     0.200
    64.224     0.781     0.200
    65.053     1.488     0.200
    68.422     1.059     0.200
    70.530     2.082     0.200
    70.530     2.492     0.200
    71.477     2.371     0.200
    73.607     2.112     0.200
    73.854     2.270     0.200
    74.161     2.877     0.200
    74.614     2.122     0.200
    76.118     3.024     0.200
    76.839     0.809     0.200
    76.935     1.533     0.200
    77.794     1.218     0.200
    78.103     2.628     0.200
    78.316     2.978     0.200
    80.552     2.878     0.200
    83.834     3.440     0.200
    85.121     1.197     0.200
    87.952     2.838     0.200
    20.381     1.292     0.200
    21.025     3.422     0.200
    21.237     4.163     0.200
    21.386     3.719     0.200
    21.997     3.104     0.200
    22.011     0.765     0.200
    22.140     0.372     0.200
    22.645     1.691     0.200
    22.684     3.051     0.200
    25.633     2.946     0.200
    62.340     1.738     0.200
    66.002     1.843     0.200
    69.751    -0.287     0.200
    21.802     3.743     0.200
    61.284     1.449     0.200
    17.747     4.316     0.200
    18.144     2.807     0.200
    18.419     2.116     0.200
    18.561     1.688     0.200
    18.894    -0.152     0.200
    19.457     2.094     0.200
    20.022     2.159     0.200
    20.146     1.073     0.200
    20.147     1.078     0.200
    20.276     0.527     0.200
    20.381     2.208     0.200
    20.655     1.208     0.200
    20.655     0.427     0.200
    20.655     0.869     0.200
    20.655     0.658     0.200
    20.559     2.447     0.200
    20.559     3.515     0.200
    20.793     0.666     0.200
    20.934     1.377     0.200
    21.042     2.539     0.200
    21.264     2.797     0.200
    21.297     3.130     0.200
    21.401     1.347     0.200
    21.522     2.318     0.200
    21.707     1.446     0.200
    21.707     2.737     0.200
    21.778     2.975     0.200
    21.840     2.813     0.200
    22.141     0.818     0.200
    22.141     1.377     0.200
    22.192     1.894     0.200
    22.192     2.427     0.200
    22.397     1.316     0.200
    22.397     1.556     0.200
    22.688     3.774     0.200
    22.886     2.134     0.200
    22.930    -0.215     0.200
    22.930     1.564     0.200
    22.960     3.061     0.200
    23.117     0.427     0.200
    23.117     0.273     0.200
    23.173     2.184     0.200
    26.293     2.523     0.200
    26.293     3.878     0.200
    26.493     0.381     0.200
    48.185     1.724     0.200
    49.414     1.735     0.200
    60.898     2.277     0.200
    60.898     2.167     0.200
    61.013     3.866     0.200
    63.450     1.628     0.200
    64.509     0.482     0.200
    64.509     2.150     0.200
    67.417     2.375     0.200
    69.211     3.638     0.200
    69.810     1.294     0.200
    69.810    -0.199     0.200
    78.254     1.480     0.200
    78.254     1.374     0.200
    78.300     0.895     0.200
    85.558     0.571     0.200
    61.003     0.716     0.200
    18.887     4.938     0.200
    18.887     0.858     0.200
    19.365     0.756     0.200
    19.429     3.168     0.200
    19.447     3.086     0.200
    19.670     1.658     0.200
    19.721     4.508     0.200
    19.790     3.918     0.200
    19.790     1.608     0.200
    19.790     2.547     0.200
    19.797     2.074     0.200
    20.022     0.764     0.200
    20.022     4.205     0.200
    20.132     4.312     0.200
    20.132     4.004     0.200
    20.390     3.969     0.200
    20.495     2.949     0.200
    20.841     3.173     0.200
    20.841     2.304     0.200
    20.943     2.574     0.200
    20.977     2.477     0.200
    21.032     2.393     0.200
    21.062     2.664     0.200
    21.091     2.826     0.200
    21.091     2.636     0.200
    21.125     3.544     0.200
    21.354     3.196     0.200
    21.354     3.020     0.200
    21.480     1.348     0.200
    21.480     0.957     0.200
    21.663     3.202     0.200
    21.684     3.392     0.200
    21.684     3.040     0.200
    21.684     2.888     0.200
    21.708     4.598     0.200
    21.775    -0.087     0.200
    21.838     1.387     0.200
    21.891     2.905     0.200
    22.054     2.874     0.200
    22.076     4.253     0.200
    22.185     3.279     0.200
    22.321     0.717     0.200
    22.321     1.243     0.200
    22.570     3.125     0.200
    22.634     2.696     0.200
    22.660     0.754     0.200
    22.655     2.257     0.200
    22.655     2.378     0.200
    22.655     1.423     0.200
    22.660     1.024     0.200
    22.733     4.216     0.200
    22.787     2.412     0.200
    22.787    -0.037     0.200
    22.787     2.281     0.200
    22.871     1.341     0.200
    23.011     2.097     0.200
    23.147     2.060     0.200
    23.231     2.289     0.200
    23.231     0.389     0.200
    23.231     0.682     0.200
    23.292     0.832     0.200
    23.342     0.859     0.200
    23.451     2.347     0.200
    23.451     2.219     0.200
    23.470     0.874     0.200
    23.440     0.199     0.200
    23.450     0.200     0.200
    23.567     3.181     0.200
    23.591     1.090     0.200
    23.767     3.831     0.200
    23.767     4.652     0.200
    23.767     2.652     0.200
    23.825     0.593     0.200
    23.960     1.274     0.200
    23.960     2.585     0.200
    24.140     2.188     0.200
    24.183     0.603     0.200
    24.183     0.343     0.200
    24.183     1.462     0.200
    24.238     3.649     0.200
    24.264     3.104     0.200
    24.264     1.614     0.200
    24.264     1.004     0.200
    24.287     3.066     0.200
    24.363     4.791     0.200
    24.435     0.950     0.200
    24.435     0.518     0.200
    24.435     0.205     0.200
    24.467     2.588     0.200
    24.841     4.700     0.200
    24.934     3.500     0.200
    24.993     1.704     0.200
    25.086     1.678     0.200
    25.124     1.933     0.200
    25.124     2.273     0.200
    25.211     0.776     0.200
    25.211     1.186     0.200
    25.210     3.592     0.200
    25.210     1.323     0.200
    25.210     1.493     0.200
    25.210     2.092     0.200
    25.302     2.406     0.200
    26.211     1.432     0.200
    26.495     0.471     0.200
    28.409     0.882     0.200
    32.220     2.597     0.200
    32.227    -0.351     0.200
    32.215     2.971     0.200
    32.761    -0.318     0.200
    33.152     0.281     0.200
    34.683     0.016     0.200
    35.330     4.991     0.200
    35.578     3.173     0.200
    36.236     1.561     0.200
    36.236     1.230     0.200
    36.802     3.405     0.200
    36.915     2.910     0.200
    40.044     4.745     0.200
    40.596     2.546     0.200
    41.150     3.448     0.200
    41.661     3.878     0.200
    45.252     2.768     0.200
    46.338     3.095     0.200
    46.338     2.466     0.200
    47.747     1.651     0.200
    47.747     0.397     0.200
    47.747     1.477     0.200
    47.778     3.786     0.200
    47.778     2.737     0.200
    50.227     1.832     0.200
    50.266     1.434     0.200
    51.578     1.861     0.200
    54.326     1.324     0.200
    54.832     2.255     0.200
    57.461     2.062     0.200
    57.497     1.023     0.200
    57.507     1.986     0.200
    57.498     2.866     0.200
    58.706     3.654     0.200
    61.275     3.195     0.200
    62.124     0.866     0.200
    62.948     2.658     0.200
    62.948     2.228     0.200
    62.948     2.439     0.200
    63.002     2.207     0.200
    63.027     2.132     0.200
    63.713     1.952     0.200
    63.513     0.159     0.200
    63.599     2.992     0.200
    64.379     2.232     0.200
    64.379     2.691     0.200
    64.766     0.514     0.200
    64.938     2.639     0.200
    64.969     3.177     0.200
    65.298     2.884     0.200
    65.528     1.791     0.200
    65.528     1.455     0.200
    65.570     3.449     0.200
    65.859     1.627     0.200
    66.459     2.526     0.200
    66.459     2.087     0.200
    66.663     1.117     0.200
    66.663     1.766     0.200
    66.802     3.294     0.200
    67.048     1.865     0.200
    67.352     2.020     0.200
    67.352     2.639     0.200
    67.724     3.475     0.200
    68.422     3.872     0.200
    68.858     0.706     0.200
    69.232     3.165     0.200
    69.876     0.851     0.200
    69.918     1.118     0.200
    72.638     0.904     0.200
    72.638     1.436     0.200
    72.908     1.397     0.200
    74.347     2.052     0.200
    75.332     0.733     0.200
    75.619     1.103     0.200
    75.619     1.702     0.200
    75.776     0.956     0.200
    76.126     3.276     0.200
    76.651     1.414     0.200
    77.313     2.295     0.200
    77.643     1.307     0.200
    78.755     0.796     0.200
    78.755     2.065     0.200
    79.525     2.203     0.200
    79.864     2.066     0.200
    79.993     3.088     0.200
    80.131     2.476     0.200
    80.168     2.876     0.200
    80.361     3.085     0.200
    80.361    -0.107     0.200
    80.622     3.104     0.200
    80.622     2.854     0.200
    80.694     3.919     0.200
    80.694     2.919     0.200
    80.694     0.149     0.200
    80.964     2.962     0.200
    84.175     3.626     0.200
    85.898     2.749     0.200
    85.945     5.554     0.200
    86.857     3.152     0.200
    92.735     2.371     0.200
    93.487     2.378     0.200
    78.840     1.887     0.200
    33.152     1.711     0.200
    79.174     1.775     0.200
    17.296     2.357     0.200
    17.299     2.818     0.200
    17.776     1.640     0.200
    18.138     1.695     0.200
    18.792     3.281     0.200
    18.971     1.379     0.200
    19.493     2.933     0.200
    19.886     2.287     0.200
    19.886     1.655     0.200
    20.085     2.732     0.200
    20.725     1.240     0.200
    21.069     0.751     0.200
    21.069     0.903     0.200
    21.069     1.072     0.200
    21.198     1.414     0.200
    21.703     0.892     0.200
    21.997     2.752     0.200
    22.194     1.435     0.200
    22.212    -1.030     0.200
    22.367     2.961     0.200
    22.587     0.543     0.200
    22.874     0.100     0.200
    23.344     1.981     0.200
    23.353     0.364     0.200
    23.403     0.912     0.200
    23.615     1.349     0.200
    26.359     1.917     0.200
    26.359     0.757     0.200
    28.285     0.763     0.200
    33.905     1.635     0.200
    34.700     1.259     0.200
    39.294     1.829     0.200
    40.232     1.076     0.200
    40.669     1.785     0.200
    41.795     0.832     0.200
    48.667     1.786     0.200
    48.737     1.392     0.200
    50.843     0.928     0.200
    55.864     0.817     0.200
    58.471     2.038     0.200
    61.406     2.241     0.200
    61.431     2.599     0.200
    62.954     1.301     0.200
    63.924     0.943     0.200
    63.929     1.811     0.200
    63.929     2.100     0.200
    65.076     2.451     0.200
    65.076     2.002     0.200
    77.616     1.488     0.200
    77.905     1.773     0.200
    78.823     1.861     0.200
    80.985     3.265     0.200
    78.251     1.262     0.200
    74.227     1.081     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   100.253     4.721     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    81.093     8.688     0.200
    61.682    40.001     0.200
    72.327    19.283     0.200
    80.526    10.218     0.200
    27.484   198.676     0.200
    36.710   151.883     0.200
    70.480    15.942     0.200
    80.553    10.061     0.200
    81.485    12.735     0.200
    81.587    11.799     0.200
    76.195    10.770     0.200
    79.904    10.687     0.200
    86.131     5.145     0.200
    35.801   148.839     0.200
    50.051    81.122     0.200
    84.520     4.872     0.200
    97.621     4.583     0.200
    35.104   152.722     0.200
    48.549    83.491     0.200
    69.525    30.177     0.200
    78.616     8.156     0.200
    69.211    28.338     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
