#!/bin/bash
gmt begin fes5.6_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times fes5.6'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   322.979
    25.500   327.522
    26.000   332.053
    26.500   336.574
    27.000   341.081
    27.500   345.572
    28.000   350.042
    28.500   354.498
    29.000   358.943
    29.500   363.379
    30.000   367.807
    30.500   372.227
    31.000   376.640
    31.500   381.045
    32.000   385.442
    32.500   389.829
    33.000   394.205
    33.500   398.569
    34.000   402.919
    34.500   407.254
    35.000   411.573
    35.500   415.878
    36.000   420.167
    36.500   424.441
    37.000   428.700
    37.500   432.943
    38.000   437.171
    38.500   441.382
    39.000   445.576
    39.500   449.753
    40.000   453.914
    40.500   458.057
    41.000   462.184
    41.500   466.293
    42.000   470.385
    42.500   474.460
    43.000   478.518
    43.500   482.558
    44.000   486.580
    44.500   490.585
    45.000   494.572
    45.500   498.540
    46.000   502.491
    46.500   506.424
    47.000   510.339
    47.500   514.235
    48.000   518.114
    48.500   521.974
    49.000   525.816
    49.500   529.640
    50.000   533.446
    50.500   537.233
    51.000   541.002
    51.500   544.753
    52.000   548.486
    52.500   552.201
    53.000   555.898
    53.500   559.578
    54.000   563.239
    54.500   566.882
    55.000   570.507
    55.500   574.112
    56.000   577.700
    56.500   581.269
    57.000   584.820
    57.500   588.352
    58.000   591.867
    58.500   595.364
    59.000   598.842
    59.500   602.302
    60.000   605.743
    60.500   609.167
    61.000   612.571
    61.500   615.958
    62.000   619.326
    62.500   622.676
    63.000   626.008
    63.500   629.323
    64.000   632.619
    64.500   635.898
    65.000   639.159
    65.500   642.401
    66.000   645.626
    66.500   648.833
    67.000   652.021
    67.500   655.191
    68.000   658.344
    68.500   661.478
    69.000   664.594
    69.500   667.692
    70.000   670.771
    70.500   673.833
    71.000   676.876
    71.500   679.901
    72.000   682.908
    72.500   685.897
    73.000   688.868
    73.500   691.820
    74.000   694.753
    74.500   697.667
    75.000   700.563
    75.500   703.440
    76.000   706.299
    76.500   709.140
    77.000   711.963
    77.500   714.768
    78.000   717.554
    78.500   720.322
    79.000   723.073
    79.500   725.805
    80.000   728.518
    80.500   731.212
    81.000   733.886
    81.500   736.542
    82.000   739.178
    82.500   741.796
    83.000   744.395
    83.500   746.975
    84.000   749.535
    84.500   752.076
    85.000   754.595
    85.500   757.095
    86.000   759.576
    86.500   762.040
    87.000   764.486
    87.500   766.909
    88.000   769.296
    88.500   771.662
    89.000   774.016
    89.500   776.362
    90.000   778.700
    90.500   781.030
    91.000   783.355
    91.500   785.674
    92.000   787.989
    92.500   790.300
    93.000   792.607
    93.500   794.911
    94.000   797.211
    94.500   799.506
    95.000   801.796
    95.500   804.080
    96.000   806.358
    96.500   808.630
    97.000   810.895
    97.500   813.153
    98.000   815.405
    98.500   817.649
    99.000   819.885
    99.500   822.114
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.107
   116.000  1122.069
   116.500  1123.031
   117.000  1123.993
   117.500  1124.955
   118.000  1125.917
   118.500  1126.879
   119.000  1127.840
   119.500  1128.802
   120.000  1129.763
   120.500  1130.724
   121.000  1131.685
   121.500  1132.645
   122.000  1133.606
   122.500  1134.565
   123.000  1135.525
   123.500  1136.484
   124.000  1137.443
   124.500  1138.401
   125.000  1139.359
   125.500  1140.316
   126.000  1141.272
   126.500  1142.228
   127.000  1143.183
   127.500  1144.138
   128.000  1145.091
   128.500  1146.044
   129.000  1146.996
   129.500  1147.947
   130.000  1148.897
   130.500  1149.846
   131.000  1150.793
   131.500  1151.740
   132.000  1152.685
   132.500  1153.628
   133.000  1154.570
   133.500  1155.511
   134.000  1156.450
   134.500  1157.387
   135.000  1158.322
   135.500  1159.255
   136.000  1160.186
   136.500  1161.115
   137.000  1162.042
   137.500  1162.965
   138.000  1163.887
   138.500  1164.806
   139.000  1165.721
   139.500  1166.634
   140.000  1167.543
   140.500  1168.449
   141.000  1169.352
   141.500  1170.251
   142.000  1171.145
   142.500  1172.036
   143.000  1172.922
   143.500  1173.803
   144.000  1174.679
   144.500  1175.550
   145.000  1176.416
   145.500  1177.276
   146.000  1178.129
   146.500  1178.977
   147.000  1179.818
   147.500  1180.652
   148.000  1181.479
   148.500  1182.299
   149.000  1183.110
   149.500  1183.912
   150.000  1184.706
   150.500  1185.489
   151.000  1186.262
   151.500  1187.026
   152.000  1187.779
   152.500  1188.522
   153.000  1189.256
   153.500  1189.979
   154.000  1190.691
   154.500  1191.392
   155.000  1192.083
   155.500  1192.761
   156.000  1193.429
   156.500  1194.084
   157.000  1194.728
   157.500  1195.359
   158.000  1195.978
   158.500  1196.585
   159.000  1197.179
   159.500  1197.760
   160.000  1198.328
   160.500  1198.884
   161.000  1199.426
   161.500  1199.955
   162.000  1200.472
   162.500  1200.974
   163.000  1201.464
   163.500  1201.940
   164.000  1202.402
   164.500  1202.850
   165.000  1203.285
   165.500  1203.706
   166.000  1204.112
   166.500  1204.505
   167.000  1204.885
   167.500  1205.250
   168.000  1205.601
   168.500  1205.938
   169.000  1206.260
   169.500  1206.569
   170.000  1206.864
   170.500  1207.144
   171.000  1207.410
   171.500  1207.662
   172.000  1207.899
   172.500  1208.123
   173.000  1208.331
   173.500  1208.526
   174.000  1208.706
   174.500  1208.872
   175.000  1209.024
   175.500  1209.161
   176.000  1209.283
   176.500  1209.391
   177.000  1209.485
   177.500  1209.565
   178.000  1209.630
   178.500  1209.680
   179.000  1209.716
   179.500  1209.738
   180.000  1209.745
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.044
     1.000   992.052
     1.500   992.066
     2.000   992.086
     2.500   992.111
     3.000   992.142
     3.500   992.178
     4.000   992.220
     4.500   992.268
     5.000   992.321
     5.500   992.379
     6.000   992.444
     6.500   992.514
     7.000   992.589
     7.500   992.670
     8.000   992.757
     8.500   992.849
     9.000   992.947
     9.500   993.050
    10.000   993.159
    10.500   993.273
    11.000   993.393
    11.500   993.519
    12.000   993.650
    12.500   993.787
    13.000   993.929
    13.500   994.077
    14.000   994.230
    14.500   994.389
    15.000   994.553
    15.500   994.723
    16.000   994.898
    16.500   995.079
    17.000   995.265
    17.500   995.457
    18.000   995.654
    18.500   995.857
    19.000   996.065
    19.500   996.278
    20.000   996.497
    20.500   996.722
    21.000   996.952
    21.500   997.187
    22.000   997.428
    22.500   997.674
    23.000   997.926
    23.500   998.183
    24.000   998.445
    24.500   998.713
    25.000   998.986
    25.500   999.265
    26.000   999.549
    26.500   999.838
    27.000  1000.132
    27.500  1000.432
    28.000  1000.737
    28.500  1001.048
    29.000  1001.363
    29.500  1001.684
    30.000  1002.011
    30.500  1002.342
    31.000  1002.679
    31.500  1003.021
    32.000  1003.368
    32.500  1003.720
    33.000  1004.078
    33.500  1004.441
    34.000  1004.809
    34.500  1005.182
    35.000  1005.560
    35.500  1005.944
    36.000  1006.332
    36.500  1006.726
    37.000  1007.124
    37.500  1007.528
    38.000  1007.937
    38.500  1008.351
    39.000  1008.770
    39.500  1009.194
    40.000  1009.623
    40.500  1010.057
    41.000  1010.496
    41.500  1010.940
    42.000  1011.389
    42.500  1011.843
    43.000  1012.302
    43.500  1012.765
    44.000  1013.234
    44.500  1013.707
    45.000  1014.186
    45.500  1014.669
    46.000  1015.157
    46.500  1015.650
    47.000  1016.147
    47.500  1016.650
    48.000  1017.157
    48.500  1017.669
    49.000  1018.186
    49.500  1018.707
    50.000  1019.233
    50.500  1019.764
    51.000  1020.299
    51.500  1020.840
    52.000  1021.384
    52.500  1021.934
    53.000  1022.488
    53.500  1023.046
    54.000  1023.609
    54.500  1024.177
    55.000  1024.749
    55.500  1025.326
    56.000  1025.907
    56.500  1026.493
    57.000  1027.083
    57.500  1027.677
    58.000  1028.276
    58.500  1028.880
    59.000  1029.487
    59.500  1030.099
    60.000  1030.716
    60.500  1031.337
    61.000  1031.962
    61.500  1032.591
    62.000  1033.225
    62.500  1033.862
    63.000  1034.504
    63.500  1035.151
    64.000  1035.801
    64.500  1036.456
    65.000  1037.115
    65.500  1037.777
    66.000  1038.444
    66.500  1039.116
    67.000  1039.791
    67.500  1040.470
    68.000  1041.153
    68.500  1041.840
    69.000  1042.531
    69.500  1043.226
    70.000  1043.926
    70.500  1044.629
    71.000  1045.335
    71.500  1046.046
    72.000  1046.761
    72.500  1047.479
    73.000  1048.201
    73.500  1048.927
    74.000  1049.657
    74.500  1050.391
    75.000  1051.128
    75.500  1051.869
    76.000  1052.614
    76.500  1053.362
    77.000  1054.114
    77.500  1054.869
    78.000  1055.629
    78.500  1056.391
    79.000  1057.157
    79.500  1057.927
    80.000  1058.701
    80.500  1059.477
    81.000  1060.257
    81.500  1061.041
    82.000  1061.828
    82.500  1062.619
    83.000  1063.412
    83.500  1064.210
    84.000  1065.010
    84.500  1065.814
    85.000  1066.621
    85.500  1067.431
    86.000  1068.245
    86.500  1069.061
    87.000  1069.881
    87.500  1070.704
    88.000  1071.531
    88.500  1072.360
    89.000  1073.192
    89.500  1074.028
    90.000  1074.866
    90.500  1075.708
    91.000  1076.552
    91.500  1077.400
    92.000  1078.250
    92.500  1079.104
    93.000  1079.960
    93.500  1080.819
    94.000  1081.681
    94.500  1082.546
    95.000  1083.413
    95.500  1084.284
    96.000  1085.157
    96.500  1086.033
    97.000  1086.911
    97.500  1087.793
    98.000  1088.677
    98.500  1089.563
    99.000  1090.453
    99.500  1091.344
   100.000  1092.239
   100.500  1093.136
   101.000  1094.035
   101.500  1094.937
   102.000  1095.841
   102.500  1096.748
   103.000  1097.658
   103.500  1098.569
   104.000  1099.483
   104.500  1100.400
   105.000  1101.318
   105.500  1102.240
   106.000  1103.163
   106.500  1104.088
   107.000  1105.016
   107.500  1105.946
   108.000  1106.878
   108.500  1107.813
   109.000  1108.749
   109.500  1109.688
   110.000  1110.629
   110.500  1111.571
   111.000  1112.516
   111.500  1113.463
   112.000  1114.412
   112.500  1115.362
   113.000  1116.315
   113.500  1117.270
   114.000  1118.226
   114.500  1119.185
   115.000  1120.145
   115.500  1121.107
   116.000  1122.071
   116.500  1123.036
   117.000  1124.004
   117.500  1124.973
   118.000  1125.943
   118.500  1126.916
   119.000  1127.890
   119.500  1128.866
   120.000  1129.843
   120.500  1130.822
   121.000  1131.803
   121.500  1132.785
   122.000  1133.768
   122.500  1134.753
   123.000  1135.740
   123.500  1136.728
   124.000  1137.717
   124.500  1138.708
   125.000  1139.700
   125.500  1140.693
   126.000  1141.688
   126.500  1142.684
   127.000  1143.681
   127.500  1144.680
   128.000  1145.680
   128.500  1146.681
   129.000  1147.683
   129.500  1148.686
   130.000  1149.691
   130.500  1150.696
   131.000  1151.703
   131.500  1152.711
   132.000  1153.720
   132.500  1154.729
   133.000  1155.740
   133.500  1156.752
   134.000  1157.765
   134.500  1158.778
   135.000  1159.793
   135.500  1160.808
   136.000  1161.825
   136.500  1162.842
   137.000  1163.859
   137.500  1164.878
   138.000  1165.898
   138.500  1166.918
   139.000  1167.939
   139.500  1168.960
   140.000  1169.983
   140.500  1171.006
   141.000  1172.029
   141.500  1173.054
   142.000  1174.078
   142.500  1175.104
   143.000  1176.130
   143.500  1177.156
   144.000  1178.183
   144.500  1179.211
   145.000  1180.239
   145.500  1181.267
   146.000  1182.296
   146.500  1183.325
   147.000  1184.354
   147.500  1185.384
   148.000  1186.414
   148.500  1187.445
   149.000  1188.475
   149.500  1189.506
   150.000  1190.538
   150.500  1191.569
   151.000  1192.601
   151.500  1193.633
   152.000  1194.665
   152.500  1195.697
   153.000  1196.729
   153.500  1197.762
   154.000  1198.794
   154.500  1199.827
   155.000  1200.860
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.740
   145.500  1177.564
   146.000  1179.445
   146.500  1181.363
   147.000  1183.309
   147.500  1185.277
   148.000  1187.266
   148.500  1189.272
   149.000  1191.293
   149.500  1193.329
   150.000  1195.377
   150.500  1197.437
   151.000  1199.507
   151.500  1201.587
   152.000  1203.675
   152.500  1205.772
   153.000  1207.877
   153.500  1209.990
   154.000  1212.109
   154.500  1214.235
   155.000  1216.367
   155.500  1218.504
   156.000  1220.647
   156.500  1222.795
   157.000  1224.947
   157.500  1227.104
   158.000  1229.266
   158.500  1231.431
   159.000  1233.600
   159.500  1235.773
   160.000  1237.950
   160.500  1240.129
   161.000  1242.312
   161.500  1244.497
   162.000  1246.686
   162.500  1248.876
   163.000  1251.070
   163.500  1253.265
   164.000  1255.463
   164.500  1257.662
   165.000  1259.864
   165.500  1262.067
   166.000  1264.272
   166.500  1266.479
   167.000  1268.687
   167.500  1270.897
   168.000  1273.108
   168.500  1275.320
   169.000  1277.534
   169.500  1279.748
   170.000  1281.964
   170.500  1284.180
   171.000  1286.397
   171.500  1288.615
   172.000  1290.834
   172.500  1293.053
   173.000  1295.273
   173.500  1297.494
   174.000  1299.715
   174.500  1301.936
   175.000  1304.158
   175.500  1306.380
   176.000  1308.603
   176.500  1310.825
   177.000  1313.048
   177.500  1315.271
   178.000  1317.493
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.736
   145.500  1177.360
   146.000  1178.906
   146.500  1180.395
   147.000  1181.834
   147.500  1183.227
   148.000  1184.579
   148.500  1185.890
   149.000  1187.167
   149.500  1188.415
   150.000  1189.639
   150.500  1190.839
   151.000  1192.019
   151.500  1193.179
   152.000  1194.321
   152.500  1195.445
   153.000  1196.554
   153.500  1197.649
   154.000  1198.729
   154.500  1199.798
   155.000  1200.852
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   508.919
     1.000   508.955
     1.500   509.015
     2.000   509.099
     2.500   509.207
     3.000   509.339
     3.500   509.495
     4.000   509.675
     4.500   509.879
     5.000   510.106
     5.500   510.358
     6.000   510.633
     6.500   510.932
     7.000   511.254
     7.500   511.600
     8.000   511.970
     8.500   512.362
     9.000   512.779
     9.500   513.218
    10.000   513.681
    10.500   514.167
    11.000   514.676
    11.500   515.208
    12.000   515.762
    12.500   516.340
    13.000   516.940
    13.500   517.562
    14.000   518.207
    14.500   518.874
    15.000   519.563
    15.500   520.275
    16.000   521.008
    16.500   521.763
    17.000   522.539
    17.500   523.337
    18.000   524.157
    18.500   524.997
    19.000   525.859
    19.500   526.742
    20.000   527.645
    20.500   528.569
    21.000   529.514
    21.500   530.479
    22.000   531.464
    22.500   532.469
    23.000   533.493
    23.500   534.538
    24.000   535.602
    24.500   536.685
    25.000   537.787
    25.500   538.909
    26.000   540.049
    26.500   541.208
    27.000   542.385
    27.500   543.580
    28.000   544.794
    28.500   546.025
    29.000   547.275
    29.500   548.541
    30.000   549.825
    30.500   551.127
    31.000   552.445
    31.500   553.780
    32.000   555.132
    32.500   556.500
    33.000   557.885
    33.500   559.285
    34.000   560.702
    34.500   562.134
    35.000   563.581
    35.500   565.044
    36.000   566.522
    36.500   568.015
    37.000   569.523
    37.500   571.045
    38.000   572.582
    38.500   574.133
    39.000   575.698
    39.500   577.277
    40.000   578.869
    40.500   580.475
    41.000   582.094
    41.500   583.727
    42.000   585.372
    42.500   587.030
    43.000   588.700
    43.500   590.383
    44.000   592.078
    44.500   593.785
    45.000   595.504
    45.500   597.235
    46.000   598.977
    46.500   600.730
    47.000   602.495
    47.500   604.270
    48.000   606.056
    48.500   607.853
    49.000   609.661
    49.500   611.478
    50.000   613.306
    50.500   615.144
    51.000   616.991
    51.500   618.848
    52.000   620.715
    52.500   622.591
    53.000   624.476
    53.500   626.370
    54.000   628.273
    54.500   630.184
    55.000   632.104
    55.500   634.033
    56.000   635.970
    56.500   637.914
    57.000   639.867
    57.500   641.827
    58.000   643.795
    58.500   645.771
    59.000   647.753
    59.500   649.743
    60.000   651.740
    60.500   653.744
    61.000   655.755
    61.500   657.772
    62.000   659.796
    62.500   661.826
    63.000   663.863
    63.500   665.905
    64.000   667.954
    64.500   670.008
    65.000   672.068
    65.500   674.133
    66.000   676.204
    66.500   678.281
    67.000   680.362
    67.500   682.449
    68.000   684.541
    68.500   686.637
    69.000   688.739
    69.500   690.844
    70.000   692.955
    70.500   695.070
    71.000   697.189
    71.500   699.312
    72.000   701.439
    72.500   703.571
    73.000   705.706
    73.500   707.845
    74.000   709.987
    74.500   712.133
    75.000   714.283
    75.500   716.436
    76.000   718.592
    76.500   720.752
    77.000   722.914
    77.500   725.079
    78.000   727.248
    78.500   729.419
    79.000   731.593
    79.500   733.769
    80.000   735.948
    80.500   738.129
    81.000   740.313
    81.500   742.499
    82.000   744.687
    82.500   746.878
    83.000   749.070
    83.500   751.264
    84.000   753.461
    84.500   755.659
    85.000   757.859
    85.500   760.060
    86.000   762.263
    86.500   764.468
    87.000   766.673
    87.500   768.881
    88.000   771.090
    88.500   773.299
    89.000   775.511
    89.500   777.723
    90.000   779.936
    90.500   782.150
    91.000   784.366
    91.500   786.582
    92.000   788.799
    92.500   791.016
    93.000   793.235
    93.500   795.454
    94.000   797.673
    94.500   799.893
    95.000   802.114
    95.500   804.335
    96.000   806.557
    96.500   808.778
    97.000   811.001
    97.500   813.223
    98.000   815.445
    98.500   817.668
    99.000   819.891
    99.500   822.114
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   418.879
    29.000   424.436
    29.500   429.993
    30.000   435.549
    30.500   441.104
    31.000   446.657
    31.500   452.209
    32.000   457.759
    32.500   463.306
    33.000   468.850
    33.500   474.391
    34.000   479.928
    34.500   485.461
    35.000   490.990
    35.500   496.513
    36.000   502.031
    36.500   507.542
    37.000   513.047
    37.500   518.545
    38.000   524.035
    38.500   529.517
    39.000   534.990
    39.500   540.453
    40.000   545.906
    40.500   551.349
    41.000   556.781
    41.500   562.201
    42.000   567.608
    42.500   573.003
    43.000   578.384
    43.500   583.751
    44.000   589.104
    44.500   594.442
    45.000   599.765
    45.500   605.072
    46.000   610.362
    46.500   615.636
    47.000   620.893
    47.500   625.602
    48.000   630.172
    48.500   634.738
    49.000   639.299
    49.500   643.855
    50.000   648.407
    50.500   652.953
    51.000   657.493
    51.500   662.029
    52.000   666.558
    52.500   671.082
    53.000   675.600
    53.500   680.112
    54.000   684.617
    54.500   689.114
    55.000   693.602
    55.500   698.079
    56.000   702.546
    56.500   707.006
    57.000   711.459
    57.500   715.907
    58.000   720.351
    58.500   724.789
    59.000   729.224
    59.500   733.654
    60.000   738.081
    60.500   742.504
    61.000   746.923
    61.500   751.338
    62.000   755.750
    62.500   760.157
    63.000   764.561
    63.500   768.960
    64.000   773.355
    64.500   777.746
    65.000   782.131
    65.500   786.512
    66.000   790.886
    66.500   795.254
    67.000   799.616
    67.500   803.970
    68.000   808.317
    68.500   812.657
    69.000   816.989
    69.500   821.313
    70.000   825.630
    70.500   829.940
    71.000   834.242
    71.500   838.536
    72.000   842.823
    72.500   847.102
    73.000   851.373
    73.500   855.637
    74.000   859.893
    74.500   864.142
    75.000   868.382
    75.500   872.614
    76.000   876.838
    76.500   881.055
    77.000   885.263
    77.500   889.462
    78.000   893.654
    78.500   897.837
    79.000   902.011
    79.500   906.177
    80.000   910.335
    80.500   914.484
    81.000   918.624
    81.500   922.756
    82.000   926.879
    82.500   930.994
    83.000   935.100
    83.500   939.198
    84.000   943.287
    84.500   947.367
    85.000   951.439
    85.500   955.503
    86.000   959.557
    86.500   963.603
    87.000   967.639
    87.500   971.667
    88.000   975.686
    88.500   979.697
    89.000   983.698
    89.500   987.690
    90.000   991.674
    90.500   995.648
    91.000   999.614
    91.500  1003.570
    92.000  1007.517
    92.500  1011.456
    93.000  1015.385
    93.500  1019.306
    94.000  1023.217
    94.500  1027.120
    95.000  1031.013
    95.500  1034.897
    96.000  1038.772
    96.500  1042.638
    97.000  1046.495
    97.500  1050.343
    98.000  1054.182
    98.500  1058.011
    99.000  1061.832
    99.500  1065.644
   100.000  1069.446
   100.500  1073.239
   101.000  1077.023
   101.500  1080.798
   102.000  1084.563
   102.500  1088.320
   103.000  1092.067
   103.500  1095.806
   104.000  1099.535
   104.500  1103.256
   105.000  1106.967
   105.500  1110.670
   106.000  1114.364
   106.500  1118.049
   107.000  1121.725
   107.500  1125.392
   108.000  1129.050
   108.500  1132.699
   109.000  1136.338
   109.500  1139.968
   110.000  1143.589
   110.500  1147.201
   111.000  1150.803
   111.500  1154.396
   112.000  1157.980
   112.500  1161.555
   113.000  1165.121
   113.500  1168.677
   114.000  1172.224
   114.500  1175.763
   115.000  1179.292
   115.500  1182.812
   116.000  1186.323
   116.500  1189.825
   117.000  1193.318
   117.500  1196.802
   118.000  1200.277
   118.500  1203.742
   119.000  1207.199
   119.500  1210.646
   120.000  1214.084
   120.500  1217.513
   121.000  1220.933
   121.500  1224.343
   122.000  1227.744
   122.500  1231.136
   123.000  1234.519
   123.500  1237.893
   124.000  1241.257
   124.500  1244.613
   125.000  1247.960
   125.500  1251.297
   126.000  1254.626
   126.500  1257.946
   127.000  1261.257
   127.500  1264.559
   128.000  1267.851
   128.500  1271.136
   129.000  1274.411
   129.500  1277.677
   130.000  1280.934
   130.500  1284.182
   131.000  1287.421
   131.500  1290.651
   132.000  1293.872
   132.500  1297.084
   133.000  1300.287
   133.500  1303.481
   134.000  1306.666
   134.500  1309.842
   135.000  1313.009
   135.500  1316.167
   136.000  1319.315
   136.500  1322.455
   137.000  1325.585
   137.500  1328.707
   138.000  1331.819
   138.500  1334.922
   139.000  1338.016
   139.500  1341.102
   140.000  1344.177
   140.500  1347.244
   141.000  1350.302
   141.500  1353.351
   142.000  1356.391
   142.500  1359.421
   143.000  1362.443
   143.500  1365.456
   144.000  1368.459
   144.500  1371.453
   145.000  1374.439
   145.500  1377.415
   146.000  1380.381
   146.500  1383.339
   147.000  1386.287
   147.500  1389.226
   148.000  1392.155
   148.500  1395.075
   149.000  1397.986
   149.500  1400.887
   150.000  1403.779
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   824.337
   100.500   826.559
   101.000   828.782
   101.500   831.005
   102.000   833.228
   102.500   835.451
   103.000   837.674
   103.500   839.896
   104.000   842.119
   104.500   844.342
   105.000   846.565
   105.500   848.788
   106.000   851.011
   106.500   853.233
   107.000   855.456
   107.500   857.679
   108.000   859.902
   108.500   862.125
   109.000   864.348
   109.500   866.570
   110.000   868.793
   110.500   871.016
   111.000   873.239
   111.500   875.462
   112.000   877.685
   112.500   879.907
   113.000   882.130
   113.500   884.353
   114.000   886.576
   114.500   888.799
   115.000   891.022
   115.500   893.244
   116.000   895.467
   116.500   897.690
   117.000   899.913
   117.500   902.136
   118.000   904.359
   118.500   906.581
   119.000   908.804
   119.500   911.027
   120.000   913.250
   120.500   915.473
   121.000   917.696
   121.500   919.918
   122.000   922.141
   122.500   924.364
   123.000   926.587
   123.500   928.810
   124.000   931.033
   124.500   933.255
   125.000   935.478
   125.500   937.701
   126.000   939.924
   126.500   942.147
   127.000   944.370
   127.500   946.592
   128.000   948.815
   128.500   951.038
   129.000   953.261
   129.500   955.484
   130.000   957.707
   130.500   959.929
   131.000   962.152
   131.500   964.375
   132.000   966.598
   132.500   968.821
   133.000   971.044
   133.500   973.266
   134.000   975.489
   134.500   977.712
   135.000   979.935
   135.500   982.158
   136.000   984.381
   136.500   986.603
   137.000   988.826
   137.500   991.049
   138.000   993.272
   138.500   995.495
   139.000   997.718
   139.500   999.940
   140.000  1002.163
   140.500  1004.386
   141.000  1006.609
   141.500  1008.832
   142.000  1011.055
   142.500  1013.277
   143.000  1015.500
   143.500  1017.723
   144.000  1019.946
   144.500  1022.169
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   384.363
    15.000   394.601
    15.500   404.836
    16.000   415.063
    16.500   425.279
    17.000   435.481
    17.500   445.665
    18.000   455.825
    18.500   465.956
    19.000   476.054
    19.500   486.111
    20.000   496.122
    20.500   506.082
    21.000   515.983
    21.500   525.821
    22.000   535.591
    22.500   545.289
    23.000   553.867
    23.500   562.008
    24.000   570.115
    24.500   578.190
    25.000   586.219
    25.500   594.168
    26.000   602.079
    26.500   609.979
    27.000   617.870
    27.500   625.753
    28.000   633.630
    28.500   641.500
    29.000   649.364
    29.500   657.221
    30.000   665.070
    30.500   672.911
    31.000   680.743
    31.500   688.563
    32.000   696.370
    32.500   704.164
    33.000   711.941
    33.500   719.702
    34.000   727.445
    34.500   735.169
    35.000   742.874
    35.500   750.560
    36.000   758.226
    36.500   765.872
    37.000   773.498
    37.500   781.103
    38.000   788.687
    38.500   796.250
    39.000   803.790
    39.500   811.308
    40.000   818.803
    40.500   826.274
    41.000   833.723
    41.500   841.147
    42.000   848.548
    42.500   855.925
    43.000   863.277
    43.500   870.605
    44.000   877.908
    44.500   885.186
    45.000   892.439
    45.500   899.667
    46.000   906.869
    46.500   914.045
    47.000   921.195
    47.500   928.319
    48.000   935.416
    48.500   942.486
    49.000   949.529
    49.500   956.545
    50.000   963.534
    50.500   970.496
    51.000   977.431
    51.500   984.339
    52.000   991.219
    52.500   998.071
    53.000  1004.896
    53.500  1011.695
    54.000  1018.468
    54.500  1025.215
    55.000  1031.935
    55.500  1038.628
    56.000  1045.294
    56.500  1051.932
    57.000  1058.541
    57.500  1065.123
    58.000  1071.677
    58.500  1078.202
    59.000  1084.700
    59.500  1091.171
    60.000  1097.614
    60.500  1104.029
    61.000  1110.416
    61.500  1116.776
    62.000  1123.106
    62.500  1129.409
    63.000  1135.683
    63.500  1141.929
    64.000  1148.146
    64.500  1154.335
    65.000  1160.495
    65.500  1166.628
    66.000  1172.732
    66.500  1178.808
    67.000  1184.855
    67.500  1190.874
    68.000  1196.865
    68.500  1202.827
    69.000  1208.760
    69.500  1214.665
    70.000  1220.540
    70.500  1226.388
    71.000  1232.206
    71.500  1237.996
    72.000  1243.756
    72.500  1249.487
    73.000  1255.188
    73.500  1260.859
    74.000  1266.500
    74.500  1272.111
    75.000  1277.693
    75.500  1283.245
    76.000  1288.767
    76.500  1294.261
    77.000  1299.725
    77.500  1305.158
    78.000  1310.562
    78.500  1315.935
    79.000  1321.278
    79.500  1326.591
    80.000  1331.876
    80.500  1337.131
    81.000  1342.356
    81.500  1347.550
    82.000  1352.711
    82.500  1357.841
    83.000  1362.939
    83.500  1368.005
    84.000  1373.041
    84.500  1378.045
    85.000  1383.019
    85.500  1387.961
    86.000  1392.871
    86.500  1397.749
    87.000  1402.596
    87.500  1407.409
    88.000  1412.190
    88.500  1416.937
    89.000  1421.651
    89.500  1426.332
    90.000  1430.979
    90.500  1435.593
    91.000  1440.172
    91.500  1444.718
    92.000  1449.230
    92.500  1453.708
    93.000  1458.152
    93.500  1462.562
    94.000  1466.946
    94.500  1471.314
    95.000  1475.669
    95.500  1480.012
    96.000  1484.343
    96.500  1488.661
    97.000  1492.963
    97.500  1497.244
    98.000  1501.505
    98.500  1505.747
    99.000  1509.970
    99.500  1514.172
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   719.089
     1.000   719.135
     1.500   719.213
     2.000   719.322
     2.500   719.462
     3.000   719.633
     3.500   719.836
     4.000   720.069
     4.500   720.333
     5.000   720.627
     5.500   720.953
     6.000   721.309
     6.500   721.696
     7.000   722.114
     7.500   722.561
     8.000   723.039
     8.500   723.548
     9.000   724.086
     9.500   724.654
    10.000   725.252
    10.500   725.880
    11.000   726.537
    11.500   727.224
    12.000   727.940
    12.500   728.684
    13.000   729.458
    13.500   730.260
    14.000   731.091
    14.500   731.949
    15.000   732.836
    15.500   733.751
    16.000   734.694
    16.500   735.664
    17.000   736.661
    17.500   737.685
    18.000   738.736
    18.500   739.813
    19.000   740.917
    19.500   742.046
    20.000   743.202
    20.500   744.383
    21.000   745.589
    21.500   746.820
    22.000   748.076
    22.500   749.356
    23.000   750.660
    23.500   751.989
    24.000   753.341
    24.500   754.716
    25.000   756.114
    25.500   757.535
    26.000   758.978
    26.500   760.444
    27.000   761.931
    27.500   763.440
    28.000   764.970
    28.500   766.521
    29.000   768.093
    29.500   769.684
    30.000   771.296
    30.500   772.927
    31.000   774.578
    31.500   776.248
    32.000   777.936
    32.500   779.642
    33.000   781.367
    33.500   783.109
    34.000   784.869
    34.500   786.646
    35.000   788.439
    35.500   790.248
    36.000   792.074
    36.500   793.915
    37.000   795.772
    37.500   797.644
    38.000   799.530
    38.500   801.431
    39.000   803.345
    39.500   805.273
    40.000   807.215
    40.500   809.170
    41.000   811.137
    41.500   813.117
    42.000   815.108
    42.500   817.111
    43.000   819.126
    43.500   821.151
    44.000   823.188
    44.500   825.234
    45.000   827.291
    45.500   829.357
    46.000   831.433
    46.500   833.517
    47.000   835.610
    47.500   837.712
    48.000   839.822
    48.500   841.940
    49.000   844.065
    49.500   846.197
    50.000   848.336
    50.500   850.481
    51.000   852.633
    51.500   854.791
    52.000   856.954
    52.500   859.123
    53.000   861.297
    53.500   863.475
    54.000   865.658
    54.500   867.846
    55.000   870.037
    55.500   872.232
    56.000   874.431
    56.500   876.632
    57.000   878.837
    57.500   881.044
    58.000   883.254
    58.500   885.466
    59.000   887.680
    59.500   889.896
    60.000   892.114
    60.500   894.333
    61.000   896.553
    61.500   898.773
    62.000   900.995
    62.500   903.217
    63.000   905.440
    63.500   907.663
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   931.143
     1.000   931.209
     1.500   931.320
     2.000   931.475
     2.500   931.674
     3.000   931.918
     3.500   932.205
     4.000   932.537
     4.500   932.913
     5.000   933.333
     5.500   933.796
     6.000   934.303
     6.500   934.855
     7.000   935.449
     7.500   936.088
     8.000   936.769
     8.500   937.494
     9.000   938.262
     9.500   939.072
    10.000   939.926
    10.500   940.822
    11.000   941.761
    11.500   942.742
    12.000   943.765
    12.500   944.831
    13.000   945.937
    13.500   947.086
    14.000   948.276
    14.500   949.507
    15.000   950.778
    15.500   952.091
    16.000   953.444
    16.500   954.837
    17.000   956.270
    17.500   957.743
    18.000   959.256
    18.500   960.807
    19.000   962.398
    19.500   964.027
    20.000   965.695
    20.500   967.401
    21.000   969.145
    21.500   970.926
    22.000   972.745
    22.500   974.600
    23.000   976.493
    23.500   978.421
    24.000   980.386
    24.500   982.387
    25.000   984.423
    25.500   986.494
    26.000   988.600
    26.500   990.741
    27.000   992.916
    27.500   995.125
    28.000   997.367
    28.500   999.643
    29.000  1001.951
    29.500  1004.292
    30.000  1006.666
    30.500  1009.071
    31.000  1011.508
    31.500  1013.976
    32.000  1016.476
    32.500  1019.005
    33.000  1021.565
    33.500  1024.155
    34.000  1026.775
    34.500  1029.423
    35.000  1032.101
    35.500  1034.807
    36.000  1037.542
    36.500  1040.304
    37.000  1043.094
    37.500  1045.911
    38.000  1048.755
    38.500  1051.626
    39.000  1054.523
    39.500  1057.446
    40.000  1060.394
    40.500  1063.367
    41.000  1066.366
    41.500  1069.389
    42.000  1072.436
    42.500  1075.507
    43.000  1078.602
    43.500  1081.719
    44.000  1084.860
    44.500  1088.024
    45.000  1091.209
    45.500  1094.417
    46.000  1097.646
    46.500  1100.897
    47.000  1104.168
    47.500  1107.461
    48.000  1110.774
    48.500  1114.106
    49.000  1117.459
    49.500  1120.831
    50.000  1124.223
    50.500  1127.633
    51.000  1131.061
    51.500  1134.508
    52.000  1137.973
    52.500  1141.456
    53.000  1144.956
    53.500  1148.473
    54.000  1152.007
    54.500  1155.558
    55.000  1159.125
    55.500  1162.708
    56.000  1166.306
    56.500  1169.920
    57.000  1173.550
    57.500  1177.194
    58.000  1180.852
    58.500  1184.526
    59.000  1188.213
    59.500  1191.914
    60.000  1195.629
    60.500  1199.357
    61.000  1203.098
    61.500  1206.852
    62.000  1210.619
    62.500  1214.397
    63.000  1218.189
    63.500  1221.991
    64.000  1225.806
    64.500  1229.632
    65.000  1233.469
    65.500  1237.317
    66.000  1241.176
    66.500  1245.045
    67.000  1248.925
    67.500  1252.814
    68.000  1256.714
    68.500  1260.623
    69.000  1264.541
    69.500  1268.469
    70.000  1272.405
    70.500  1276.350
    71.000  1280.304
    71.500  1284.266
    72.000  1288.237
    72.500  1292.215
    73.000  1296.201
    73.500  1300.195
    74.000  1304.195
    74.500  1308.204
    75.000  1312.219
    75.500  1316.241
    76.000  1320.269
    76.500  1324.304
    77.000  1328.346
    77.500  1332.393
    78.000  1336.446
    78.500  1340.505
    79.000  1344.570
    79.500  1348.640
    80.000  1352.715
    80.500  1356.796
    81.000  1360.881
    81.500  1364.971
    82.000  1369.066
    82.500  1373.165
    83.000  1377.268
    83.500  1381.375
    84.000  1385.487
    84.500  1389.602
    85.000  1393.721
    85.500  1397.844
    86.000  1401.970
    86.500  1406.099
    87.000  1410.231
    87.500  1414.366
    88.000  1418.505
    88.500  1422.645
    89.000  1426.789
    89.500  1430.935
    90.000  1435.083
    90.500  1439.233
    91.000  1443.386
    91.500  1447.540
    92.000  1451.696
    92.500  1455.854
    93.000  1460.014
    93.500  1464.175
    94.000  1468.338
    94.500  1472.501
    95.000  1476.666
    95.500  1480.832
    96.000  1484.998
    96.500  1489.166
    97.000  1493.334
    97.500  1497.503
    98.000  1501.672
    98.500  1505.842
    99.000  1510.012
    99.500  1514.182
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   772.317
    29.500   782.556
    30.000   792.795
    30.500   803.031
    31.000   813.265
    31.500   823.495
    32.000   833.721
    32.500   843.942
    33.000   854.157
    33.500   864.365
    34.000   874.565
    34.500   884.756
    35.000   894.937
    35.500   905.106
    36.000   915.263
    36.500   925.406
    37.000   935.533
    37.500   945.644
    38.000   955.736
    38.500   965.599
    39.000   975.861
    39.500   985.890
    40.000   995.895
    40.500  1005.874
    41.000  1015.826
    41.500  1025.749
    42.000  1035.643
    42.500  1045.505
    43.000  1055.334
    43.500  1065.130
    44.000  1074.890
    44.500  1084.614
    45.000  1094.300
    45.500  1103.580
    46.000  1111.750
    46.500  1119.902
    47.000  1128.037
    47.500  1136.156
    48.000  1144.258
    48.500  1152.344
    49.000  1160.413
    49.500  1168.460
    50.000  1176.482
    50.500  1184.465
    51.000  1192.393
    51.500  1200.309
    52.000  1208.218
    52.500  1216.120
    53.000  1224.018
    53.500  1231.912
    54.000  1239.802
    54.500  1247.687
    55.000  1255.570
    55.500  1263.449
    56.000  1271.324
    56.500  1279.197
    57.000  1287.066
    57.500  1294.931
    58.000  1302.794
    58.500  1310.653
    59.000  1318.509
    59.500  1326.361
    60.000  1334.209
    60.500  1342.053
    61.000  1349.893
    61.500  1357.728
    62.000  1365.557
    62.500  1373.381
    63.000  1381.199
    63.500  1389.011
    64.000  1396.816
    64.500  1404.615
    65.000  1412.405
    65.500  1420.188
    66.000  1427.963
    66.500  1435.729
    67.000  1443.487
    67.500  1451.236
    68.000  1458.976
    68.500  1466.706
    69.000  1474.428
    69.500  1482.139
    70.000  1489.841
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     2.163    61.383     0.150
     2.292    37.586     0.150
     7.696   111.383     0.150
     7.696   146.383     0.150
     9.347   143.383     0.150
     9.347   306.383     0.150
     9.915   156.383     0.150
     9.915   163.383     0.150
     9.915   256.383     0.150
     9.915   260.383     0.150
     9.915   297.383     0.150
    10.755   176.383     0.150
    10.755   352.383     0.150
    10.836   367.383     0.150
    13.486   360.383     0.150
    13.486   412.383     0.150
    19.058   257.383     0.150
    21.373   286.383     0.150
    21.373   292.383     0.150
    21.373    12.000     0.150
    21.915   294.383     0.150
    23.340   318.383     0.150
    23.340   326.383     0.150
    24.005    33.000     0.150
    24.185   582.383     0.150
    24.189   582.383     0.150
    24.363    54.000     0.150
    25.077   327.383     0.150
    40.873   462.086     0.150
    47.157   648.383     0.150
    80.336   733.383     0.150
     4.327    68.305     0.150
     7.878   172.305     0.150
    23.327   318.305     0.150
    23.327   347.305     0.150
    27.776   366.406     0.150
    37.511   422.305     0.150
    57.610   587.305     0.150
     0.743    14.992     0.150
     1.458  3629.992     0.150
     1.458  3648.992     0.150
     1.474  3628.992     0.150
     1.474  3648.992     0.150
     2.146  3637.992     0.150
     2.146  3669.992     0.150
     2.374    59.992     0.150
     4.815   158.992     0.150
     4.815   166.992     0.150
     5.673   154.992     0.150
     5.673    87.992     0.150
     2.471    37.625     0.150
     2.471   132.328     0.150
     5.573    99.531     0.150
     5.573   187.828     0.150
     5.817    97.328     0.150
     5.817   117.328     0.150
     5.817   181.328     0.150
     6.585   162.328     0.150
     7.497   105.328     0.150
     8.071   126.328     0.150
     8.929   143.328     0.150
    14.706   479.328     0.150
    17.046   241.625     0.150
    17.078   243.930     0.150
    17.509   450.328     0.150
    18.672   264.328     0.150
    18.672   273.328     0.150
    21.782   281.328     0.150
    21.782    60.000     0.150
    28.804   364.328     0.150
    32.725   413.328     0.150
    36.135   436.328     0.150
    36.209   436.328     0.150
    36.427   424.328     0.150
    36.826   424.328     0.150
     0.969    68.419     0.150
     1.672    48.419     0.150
     2.017    42.419     0.150
     2.017    71.419     0.150
     3.309   118.019     0.150
     3.963    74.919     0.150
     3.963   133.419     0.150
     6.081   184.719     0.150
     8.192   121.219     0.150
     8.192   207.119     0.150
    21.185   291.919     0.150
     2.760    54.121     0.150
     3.206    62.422     0.150
     3.206    70.820     0.150
     3.206   125.121     0.150
     4.140    62.121     0.150
     5.042    80.922     0.150
     5.042   166.121     0.150
     6.308   103.320     0.150
     6.586   104.621     0.150
     6.586   106.121     0.150
     6.586   109.121     0.150
     6.586   123.121     0.150
     6.586   165.621     0.150
     6.586   183.121     0.150
     6.586   183.121     0.150
     6.586   188.621     0.150
     6.586   188.621     0.150
     6.586   211.121     0.150
     7.272   124.820     0.150
     8.746   131.121     0.150
    14.163   198.723     0.150
    16.506   247.121     0.150
    17.531   245.121     0.150
    19.356   304.121     0.150
    20.042   281.020     0.150
    20.580   317.121     0.150
    21.255   289.621     0.150
    21.255   289.621     0.150
    21.671   296.422     0.150
    21.671   644.422     0.150
    21.796   307.121     0.150
    21.796   326.121     0.150
    21.796   291.121     0.150
    21.796     3.000     0.150
    21.987   297.121     0.150
    22.338   536.121     0.150
    22.448   302.020     0.150
    22.448   302.020     0.150
    22.736   307.020     0.150
    22.736  3206.121     0.150
    22.736  3372.621     0.150
    22.736  3759.121     0.150
    24.503    12.000     0.150
    24.503    16.000     0.150
    24.503    32.000     0.150
    24.676   335.121     0.150
    24.959   338.121     0.150
    29.542   361.121     0.150
    48.678   529.121     0.150
    48.678   529.922     0.150
    59.625   605.922     0.150
    69.160   673.121     0.150
    75.513   707.020     0.150
    94.723   790.320     0.150
    94.723   790.320     0.150
     1.569    54.215     0.150
     1.569    59.215     0.150
     3.055    92.215     0.150
     4.474    74.315     0.150
     4.720   110.715     0.150
     4.720   144.215     0.150
     4.720   149.215     0.150
     7.009   182.215     0.150
     7.009   194.215     0.150
     7.009   209.215     0.150
    13.914   443.315     0.150
    29.958   356.815     0.150
     1.769    52.047     0.150
     1.769    61.047     0.150
     3.591    54.047     0.150
     3.591   174.047     0.150
     6.541   100.746     0.150
     7.010   111.547     0.150
     7.010   124.047     0.150
     7.010   168.047     0.150
     7.010   195.047     0.150
     9.443   155.047     0.150
     9.768   157.945     0.150
     9.768   260.445     0.150
    13.939   190.148     0.150
    13.939   497.348     0.150
    21.660   300.047     0.150
    22.166     7.000     0.150
    22.166    13.000     0.150
    22.166    29.000     0.150
    24.867   328.047     0.150
    24.867    13.000     0.150
    24.867    35.000     0.150
    29.965   369.848     0.150
    29.965   369.848     0.150
    41.014   468.945     0.150
     4.599    85.820     0.150
     4.599   100.820     0.150
     4.599   163.820     0.150
     4.599   175.820     0.150
     5.448   150.820     0.150
     7.476   186.922     0.150
     8.014   200.320     0.150
     8.443   280.820     0.150
     9.578   233.320     0.150
    10.757   262.320     0.150
    12.134   178.922     0.150
    14.034   192.320     0.150
    14.385   208.023     0.150
    14.627   224.320     0.150
    14.732   214.219     0.150
    19.608   276.422     0.150
    19.608   485.820     0.150
    20.180   654.820     0.150
    20.529   221.820     0.150
    20.812   288.719     0.150
    20.812   320.023     0.150
    20.812   332.523     0.150
    21.153   287.219     0.150
    21.639   298.023     0.150
    21.787   291.523     0.150
    21.787   484.820     0.150
    21.939   301.523     0.150
    22.298   310.820     0.150
    22.298   597.820     0.150
    22.298   298.820     0.150
    22.298   597.320     0.150
    22.528   515.820     0.150
    22.528   301.820     0.150
    22.528   515.820     0.150
    22.528   301.820     0.150
    22.528   322.320     0.150
    22.448   295.422     0.150
    22.622   308.820     0.150
    22.833   317.023     0.150
    22.909     6.000     0.150
    22.909    14.000     0.150
    22.909    27.000     0.150
    23.124   324.117     0.150
    23.124   345.820     0.150
    23.124   417.820     0.150
    23.344   314.820     0.150
    23.344   372.820     0.150
    23.344   419.820     0.150
    23.344     5.602     0.150
    23.505   311.117     0.150
    23.604   312.617     0.150
    23.691   397.820     0.150
    23.691   314.820     0.150
    24.193     7.102     0.150
    24.193    30.102     0.150
    24.193   362.820     0.150
    24.193   318.719     0.150
    24.193   362.820     0.150
    24.748   324.320     0.150
    24.921   344.820     0.150
    24.921    37.102     0.150
    24.921   403.820     0.150
    25.787   322.320     0.150
    26.100   389.820     0.150
    26.100   389.922     0.150
    26.666   395.320     0.150
    36.756   429.719     0.150
    37.400   434.922     0.150
    38.185   442.820     0.150
    39.819   456.820     0.150
    42.001   475.820     0.150
    42.128   476.617     0.150
    49.795   535.117     0.150
    49.795     3.703     0.150
    50.947   545.820     0.150
    57.716   593.820     0.150
    61.682   622.023     0.150
    62.236   624.820     0.150
    71.875   685.820     0.150
    71.875     4.000     0.150
    72.974   689.820     0.150
    76.668   714.820     0.150
    76.856   715.023     0.150
    79.601   730.023     0.150
    80.400   734.219     0.150
    80.400     3.602     0.150
    81.463   748.422     0.150
    86.335   756.617     0.150
    86.269   764.820     0.150
     5.566   119.508     0.150
     5.566   123.508     0.150
     5.566   125.008     0.150
     5.566   128.008     0.150
     5.739    82.508     0.150
     6.553   170.309     0.150
     6.659   170.008     0.150
     7.534   109.707     0.150
     8.007   203.508     0.150
     9.394   135.969     0.150
     9.394   238.008     0.150
     9.526   239.508     0.150
     9.566   285.508     0.150
    12.172   172.508     0.150
    12.423   312.508     0.150
    14.765   207.609     0.150
    14.833   210.309     0.150
    16.618   235.906     0.150
    17.534   462.508     0.150
    17.748   247.207     0.150
    17.748   247.207     0.150
    18.371   248.066     0.150
    19.914   271.309     0.150
    19.959   271.707     0.150
    20.144   273.809     0.150
    20.169   273.809     0.150
    20.293     9.078     0.150
    20.945   816.508     0.150
    20.945   283.406     0.150
    20.990   293.609     0.150
    21.200   297.309     0.150
    21.497   300.406     0.150
    22.091   293.809     0.150
    22.091   293.828     0.150
    22.294   308.008     0.150
    22.294   327.508     0.150
    22.294   813.008     0.150
    22.294   298.008     0.150
    22.294    10.000     0.150
    22.294   327.508     0.150
    22.398   308.508     0.150
    22.394   329.008     0.150
    22.394   358.906     0.150
    22.394   297.609     0.150
    22.394    10.398     0.150
    22.394   329.008     0.150
    22.394   540.508     0.150
    22.723   300.707     0.150
    22.723   543.508     0.150
    22.723   300.707     0.150
    22.723   543.508     0.150
    23.127   304.809     0.150
    23.183    34.500     0.150
    23.183   351.508     0.150
    23.183   618.508     0.150
    23.183   647.008     0.150
    23.448   344.008     0.150
    23.448   307.609     0.150
    23.448   344.008     0.150
    23.448   558.508     0.150
    23.490    29.301     0.150
    23.490   347.008     0.150
    23.490   526.508     0.150
    23.490   308.707     0.150
    23.490   347.008     0.150
    23.787   310.906     0.150
    23.787   350.508     0.150
    23.787   566.508     0.150
    23.787   310.906     0.150
    23.787   566.508     0.150
    23.839   327.508     0.150
    23.839    36.000     0.150
    23.839   576.508     0.150
    23.839   311.508     0.150
    23.839    15.699     0.150
    23.908   628.906     0.150
    23.908   313.207     0.150
    23.908   566.406     0.150
    23.908   628.906     0.150
    23.944   327.309     0.150
    24.107   322.508     0.150
    24.107   322.508     0.150
    24.800   316.207     0.150
    24.845   595.508     0.150
    26.130   333.508     0.150
    26.344   341.508     0.150
    26.344   342.008     0.150
    26.580   344.707     0.150
    26.580   401.309     0.150
    26.580   337.508     0.150
    26.580   401.309     0.150
    26.780   337.508     0.150
    26.920   371.008     0.150
    27.457   350.508     0.150
    27.726   353.508     0.150
    29.851   366.508     0.150
    31.299   378.809     0.150
    32.618   389.508     0.150
    35.510   427.809     0.150
    37.038   424.508     0.150
    37.386   432.508     0.150
    37.386   780.508     0.150
    38.827   445.809     0.150
    41.035   464.508     0.150
    41.632   468.508     0.150
    48.428   534.008     0.150
    49.337   529.508     0.150
    49.337   703.508     0.150
    49.337   957.508     0.150
    49.744   547.008     0.150
    49.744   532.008     0.150
    49.744    15.000     0.150
    50.906   717.508     0.150
    50.906   541.008     0.150
    50.906   654.508     0.150
    50.906   717.508     0.150
    52.398  1012.508     0.150
    54.755   576.508     0.150
    54.878   571.309     0.150
    54.878   577.207     0.150
    56.704   583.508     0.150
    57.823    30.301     0.150
    61.912   628.508     0.150
    61.912   619.906     0.150
    62.680   634.508     0.150
    62.680   635.906     0.150
    62.680   636.809     0.150
    62.680   643.508     0.150
    63.951   874.508     0.150
    63.951  1151.508     0.150
    64.666   639.508     0.150
    65.756   657.508     0.150
    65.935   645.809     0.150
    65.935  1173.508     0.150
    68.797   663.309     0.150
    68.797     9.098     0.150
    71.020   677.508     0.150
    71.020  1232.508     0.150
    71.411   679.406     0.150
    72.327   685.508     0.150
    72.327   702.508     0.150
    75.323   703.508     0.150
    76.653   711.809     0.150
    78.399   720.809     0.150
    79.944   728.508     0.150
    79.944   907.508     0.150
    79.944  1330.508     0.150
    80.047   730.109     0.150
    80.198   730.809     0.150
    81.514   737.508     0.150
    81.514     8.102     0.150
    81.622   739.008     0.150
    82.930   746.309     0.150
    82.930     8.301     0.150
    83.479   748.406     0.150
    84.128   750.809     0.150
    85.027   757.008     0.150
    86.081   762.527     0.150
    86.081     9.590     0.150
    86.081   762.508     0.150
    86.081     9.602     0.150
    86.212   761.508     0.150
    87.953   771.109     0.150
    88.238   760.207     0.150
   142.305  1175.906     0.150
     5.480    85.020     0.150
     5.480   152.020     0.150
     5.727    81.520     0.150
     5.533   118.520     0.150
     6.513   178.020     0.150
     6.531   178.520     0.150
     6.718   169.719     0.150
     6.928   173.520     0.150
     7.986   204.520     0.150
     8.293   122.520     0.150
     8.293   143.520     0.150
     8.293   223.520     0.150
     8.293   244.520     0.150
     8.431   209.520     0.150
     8.431   221.520     0.150
     8.447   130.820     0.150
     8.447   222.520     0.150
     8.776   234.520     0.150
     8.928   127.918     0.150
     9.390   133.418     0.150
     9.390   229.520     0.150
     9.510   249.520     0.150
    11.445   159.320     0.150
    11.441   277.020     0.150
    12.176   177.418     0.150
    12.346   178.918     0.150
    12.449   186.469     0.150
    12.449   328.020     0.150
    12.381   188.020     0.150
    14.771   209.719     0.150
    14.850   212.418     0.150
    17.204   242.719     0.150
    17.397   248.219     0.150
    17.749   189.219     0.150
    17.749   189.219     0.150
    17.984   252.320     0.150
    17.984   251.039     0.150
    19.932   293.219     0.150
    19.932   272.520     0.150
    20.027   276.430     0.150
    20.161   274.719     0.150
    20.378   276.918     0.150
    20.855   310.520     0.150
    20.855   282.719     0.150
    20.855   310.520     0.150
    20.953   295.020     0.150
    20.953   284.520     0.150
    20.953   295.020     0.150
    21.076   291.520     0.150
    21.142   291.520     0.150
    21.192   295.820     0.150
    21.490   296.520     0.150
    21.732   298.020     0.150
    21.913   291.520     0.150
    21.913   537.918     0.150
    21.989   287.520     0.150
    21.989   287.520     0.150
    21.989   541.520     0.150
    22.107   294.820     0.150
    22.107   294.750     0.150
    22.262   299.621     0.150
    22.262   306.418     0.150
    22.411   304.520     0.150
    22.411   326.020     0.150
    22.411   378.520     0.150
    22.411   298.621     0.150
    22.411     9.898     0.150
    22.411   326.020     0.150
    22.736   301.520     0.150
    22.736   547.520     0.150
    22.736   301.520     0.150
    22.736   547.520     0.150
    23.090   321.051     0.150
    23.147   303.520     0.150
    23.147   303.520     0.150
    23.147     2.000     0.150
    23.147   557.520     0.150
    23.213   307.520     0.150
    23.213   317.520     0.150
    23.213   721.520     0.150
    23.465   316.219     0.150
    23.465    82.301     0.150
    23.465   557.520     0.150
    23.465   308.520     0.150
    23.465     1.699     0.150
    23.465     7.699     0.150
    23.465   557.520     0.150
    23.475   559.520     0.150
    23.801   319.820     0.150
    23.801   569.520     0.150
    23.801   311.918     0.150
    23.801     7.902     0.150
    23.801   569.520     0.150
    23.801   311.918     0.150
    23.801     7.902     0.150
    23.801   569.520     0.150
    23.854   319.320     0.150
    23.854   312.918     0.150
    23.854     6.402     0.150
    23.821   329.020     0.150
    23.930    10.500     0.150
    23.930   313.820     0.150
    23.930    10.500     0.150
    23.963   321.121     0.150
    23.963   388.520     0.150
    24.103   318.418     0.150
    24.547   325.621     0.150
    24.509   307.801     0.150
    24.610   326.219     0.150
    24.704   327.820     0.150
    24.746   313.520     0.150
    24.814   607.520     0.150
    25.774     9.199     0.150
    25.774   331.621     0.150
    25.774     9.199     0.150
    26.123     1.102     0.150
    26.149     1.102     0.150
    26.149   351.020     0.150
    26.149   625.520     0.150
    26.603     4.000     0.150
    26.603   399.020     0.150
    26.603   695.520     0.150
    26.603   338.520     0.150
    26.603     4.000     0.150
    26.603    10.000     0.150
    26.603   385.219     0.150
    26.603   399.020     0.150
    26.603   695.520     0.150
    26.836   350.520     0.150
    27.155   350.520     0.150
    27.526   354.520     0.150
    27.754   350.520     0.150
    27.887   360.320     0.150
    28.191   360.520     0.150
    28.191   360.520     0.150
    28.191   408.520     0.150
    28.191   641.520     0.150
    29.877   367.520     0.150
    29.877     8.000     0.150
    29.877   421.520     0.150
    29.877   666.520     0.150
    30.757   382.520     0.150
    30.841   384.020     0.150
    31.306   380.121     0.150
    33.878   411.020     0.150
    35.189   414.520     0.150
    35.189   745.520     0.150
    35.498   429.418     0.150
    36.683   424.020     0.150
    36.710   433.520     0.150
    36.710   526.520     0.150
    36.710   942.520     0.150
    36.710   433.520     0.150
    36.710   513.520     0.150
    36.710   526.520     0.150
    36.710   577.520     0.150
    36.710   773.520     0.150
    36.710   942.520     0.150
    36.687   429.520     0.150
    36.687   773.520     0.150
    37.407   923.520     0.150
    37.407   434.520     0.150
    37.407     6.000     0.150
    37.407   779.520     0.150
    37.407   923.520     0.150
    38.202   440.520     0.150
    38.202   524.520     0.150
    38.202   786.520     0.150
    38.858   801.020     0.150
    39.130   449.520     0.150
    39.130    10.000     0.150
    39.130   544.520     0.150
    39.130   797.520     0.150
    40.190   454.520     0.150
    40.190   827.520     0.150
    41.066   466.520     0.150
    41.066     9.000     0.150
    41.066   833.520     0.150
    41.666   471.520     0.150
    41.666   839.520     0.150
    42.356   477.520     0.150
    42.356   849.520     0.150
    42.991   488.520     0.150
    43.334   486.520     0.150
    43.334   870.520     0.150
    46.118   507.020     0.150
    48.392   535.020     0.150
    49.371   532.520     0.150
    49.371   959.520     0.150
    49.371   970.520     0.150
    49.766   542.020     0.150
    49.766   651.520     0.150
    49.766   973.520     0.150
    49.766   532.520     0.150
    49.766     7.000     0.150
    49.766   651.520     0.150
    49.766   962.520     0.150
    49.766   973.520     0.150
    50.680   549.520     0.150
    50.680  1007.520     0.150
    50.680  1217.520     0.150
    50.927   627.719     0.150
    50.927   541.520     0.150
    50.927   627.719     0.150
    50.927   652.520     0.150
    50.927   970.520     0.150
    54.855   577.621     0.150
    55.912   566.418     0.150
    55.912   608.020     0.150
    56.728   584.520     0.150
    56.728  1048.520     0.150
    59.031   614.520     0.150
    60.078   616.820     0.150
    60.078   664.621     0.150
    61.969   631.520     0.150
    61.969   622.520     0.150
    61.969     6.000     0.150
    61.969   754.520     0.150
    61.969  1127.520     0.150
    61.942   621.020     0.150
    61.942  1127.520     0.150
    63.982    11.500     0.150
    65.957  1605.520     0.150
    65.957   647.918     0.150
    65.957  1170.520     0.150
    65.957  1605.520     0.150
    67.620   668.520     0.150
    69.981   681.418     0.150
    70.602   683.719     0.150
    70.760   687.520     0.150
    70.760   688.020     0.150
    71.042   677.520     0.150
    71.042  1234.520     0.150
    70.946   687.121     0.150
    72.332   687.520     0.150
    72.332   687.520     0.150
    72.511   686.590     0.150
    75.795   706.418     0.150
    76.177   715.719     0.150
    76.177   715.719     0.150
    76.674   713.520     0.150
    76.674  1295.520     0.150
    76.674  1588.520     0.150
    77.389   714.820     0.150
    77.455   710.520     0.150
    78.365   733.520     0.150
    79.953   730.918     0.150
    79.953   730.918     0.150
    80.032   731.918     0.150
    80.900   741.520     0.150
    81.587   740.719     0.150
    81.587   748.121     0.150
    85.055   770.520     0.150
    86.046   762.328     0.150
    86.236   768.020     0.150
    86.994   768.520     0.150
    87.983   772.520     0.150
    90.181   789.520     0.150
    90.575   791.520     0.150
    92.661   800.520     0.150
   142.345  1176.520     0.150
   155.984  1210.520     0.150
     0.364     4.188     0.150
     0.364    13.688     0.150
     1.070    33.188     0.150
     1.903    64.188     0.150
     2.042    59.688     0.150
     2.055   119.688     0.150
     2.342    38.188     0.150
     2.705    47.289     0.150
     2.705    70.188     0.150
     3.134    83.188     0.150
     4.631   121.688     0.150
     5.025   116.988     0.150
     6.934   160.988     0.150
     0.773    26.207     0.150
     0.827    19.207     0.150
     0.827    31.207     0.150
     2.520    40.906     0.150
     0.779    26.414     0.150
     0.822    25.914     0.150
     2.557    41.016     0.150
     3.111    48.914     0.150
     0.674    31.849     0.150
     1.168    29.349     0.150
     1.168    49.349     0.150
     1.896    52.349     0.150
     2.128    42.349     0.150
     2.128    73.049     0.150
     2.309    46.849     0.150
     2.447    47.349     0.150
     2.482    49.349     0.150
     3.442    57.749     0.150
     3.843    99.049     0.150
     4.618    70.779     0.150
     6.252   163.749     0.150
    20.249   270.849     0.150
    20.249   285.349     0.150
    68.633   662.649     0.150
     1.470    40.094     0.150
     2.034    41.594     0.150
     2.128    32.797     0.150
     2.128    55.594     0.150
     2.224    44.594     0.150
     2.295    60.594     0.150
     2.406    48.594     0.150
     3.717    96.594     0.150
     4.403   117.594     0.150
     5.088    81.594     0.150
     5.088   127.094     0.150
     5.404   105.594     0.150
    20.242   272.594     0.150
    27.384   357.203     0.150
    27.668   356.188     0.150
    27.802   353.227     0.150
     0.274     8.367     0.150
     2.243    38.867     0.150
     3.310    54.867     0.150
     4.536   121.066     0.150
    69.310   667.168     0.150
     0.830    24.164     0.150
     1.191    29.664     0.150
     1.479    32.664     0.150
     1.479    52.164     0.150
     1.652    32.664     0.150
     1.923    47.355     0.150
     2.114    42.164     0.150
     2.114    68.664     0.150
     2.326    43.164     0.150
     2.326    73.664     0.150
     2.278    44.113     0.150
     2.278    61.664     0.150
     2.641    52.664     0.150
     3.931    59.664     0.150
     3.933   105.766     0.150
     5.022    80.164     0.150
     0.658    12.018     0.150
     1.583    27.018     0.150
     2.154    80.018     0.150
     2.087    57.518     0.150
     2.507    39.618     0.150
     2.891    83.018     0.150
     3.802    62.018     0.150
     5.251    79.417     0.150
     5.251   146.618     0.150
     5.588   148.018     0.150
     6.643    98.917     0.150
     6.643   172.018     0.150
    28.702   355.417     0.150
    39.236   446.417     0.150
     1.890    54.453     0.150
     2.010    36.953     0.150
     2.010    40.453     0.150
     3.068    52.555     0.150
     3.078    83.055     0.150
     3.356    55.453     0.150
     3.460    92.555     0.150
     3.872   102.754     0.150
     4.497   121.652     0.150
     5.854   154.852     0.150
     5.854   198.953     0.150
     5.986   158.652     0.150
     7.207   108.453     0.150
    19.667   271.652     0.150
    20.208   275.352     0.150
    20.554   283.453     0.150
    20.554   297.453     0.150
    21.585   292.453     0.150
    26.883   340.055     0.150
    75.004   705.742     0.150
     0.700    21.852     0.150
     0.700    26.852     0.150
     2.472    44.852     0.150
     3.190    79.852     0.150
     3.190    83.852     0.150
     3.251    91.852     0.150
     3.522    53.852     0.150
     3.522    93.852     0.150
     4.643   121.152     0.150
     7.139   106.252     0.150
     7.695   114.051     0.150
    21.589   298.352     0.150
    26.078   343.252     0.150
    69.494   666.152     0.150
    77.612   716.152     0.150
    78.106   716.252     0.150
     1.799    58.291     0.150
     2.683    52.791     0.150
     3.203    83.791     0.150
     3.203    93.791     0.150
     3.231    92.490     0.150
     4.328    67.990     0.150
     4.328   116.092     0.150
     4.491    71.592     0.150
     4.779   124.291     0.150
     4.856   121.291     0.150
     4.945   124.791     0.150
     7.824   185.490     0.150
     0.906    15.537     0.150
     0.906    33.537     0.150
     1.790    57.537     0.150
     2.317    41.537     0.150
     3.315    55.537     0.150
     4.563   114.537     0.150
     4.862   123.037     0.150
     4.949   124.537     0.150
     1.531    24.947     0.150
     1.531    40.447     0.150
     1.915    63.055     0.150
     3.854    58.055     0.150
     3.934    59.055     0.150
     4.307    66.453     0.150
     4.298    67.055     0.150
     5.172    80.336     0.150
     6.127    92.156     0.150
     6.131    89.352     0.150
     6.728   172.414     0.150
     0.586    16.070     0.150
     0.586    33.070     0.150
     0.586    39.070     0.150
     5.628    82.070     0.150
     6.025   155.271     0.150
     6.572    94.570     0.150
    12.295   181.370     0.150
    12.932   190.471     0.150
    12.932   192.170     0.150
    13.127   197.971     0.150
    13.392   194.771     0.150
    13.744   205.471     0.150
    13.787   205.670     0.150
    13.869   207.471     0.150
    13.933   207.370     0.150
    13.919   202.670     0.150
    14.026   206.670     0.150
    14.211   208.570     0.150
    14.258   208.271     0.150
    14.625   208.670     0.150
    14.572   210.170     0.150
    14.577   210.370     0.150
    15.311   224.170     0.150
    15.476   225.471     0.150
    16.832   238.070     0.150
    20.316   273.896     0.150
    20.437   300.070     0.150
    20.567   278.870     0.150
    20.567   285.271     0.150
    20.567   296.570     0.150
    21.653   352.070     0.150
    21.774   934.570     0.150
    21.770   289.771     0.150
    22.880   555.271     0.150
    23.421   310.070     0.150
    24.344     5.200     0.150
    35.635   415.870     0.150
    37.962   434.570     0.150
    39.698   459.431     0.150
    68.689   670.820     0.150
    72.861   691.971     0.150
    83.841   753.790     0.150
    86.883   767.570     0.150
    88.274     7.000     0.150
   152.070  1198.570     0.150
     4.326    68.961     0.150
     4.789   127.278     0.150
     6.196    93.901     0.150
     6.971   177.322     0.150
     1.202    24.629     0.150
     1.202    42.629     0.150
     2.215    38.008     0.150
     2.835    45.820     0.150
     3.514    95.367     0.150
     3.752    99.508     0.150
     5.071   128.391     0.150
     5.887    86.910     0.150
     7.629   188.230     0.150
     7.905   190.391     0.150
     8.409   202.230     0.150
     8.761   211.129     0.150
    10.203   244.551     0.150
    10.598   254.469     0.150
    11.328   166.027     0.150
    12.539   306.527     0.150
    13.561   198.930     0.150
    13.629   202.129     0.150
    14.601   214.430     0.150
    15.219   365.527     0.150
    16.849   242.828     0.150
    17.486   247.828     0.150
    17.499   247.828     0.150
    19.730   278.430     0.150
    19.668   267.828     0.150
    20.064   273.027     0.150
    20.202   282.129     0.150
    20.202   293.027     0.150
    20.202   282.129     0.150
    20.202   293.027     0.150
    20.891   280.453     0.150
    21.048    10.199     0.150
    21.048   283.430     0.150
    21.048    10.598     0.150
    21.277     7.602     0.150
    22.140   310.629     0.150
    23.146   304.129     0.150
    23.877   311.629     0.150
    36.875   424.312     0.150
    39.552   450.168     0.150
    46.191   512.980     0.150
    55.458   583.426     0.150
    60.388   614.688     0.150
    68.007   666.754     0.150
    69.920   669.430     0.150
    73.259   699.129     0.150
    79.621   738.027     0.150
   142.465  1169.105     0.150
   153.075  1208.277     0.150
     2.150    69.922     0.150
     5.639    83.461     0.150
     6.071    89.473     0.150
     2.156    61.182     0.150
     2.617    73.682     0.150
     2.887    81.682     0.150
     3.560    58.381     0.150
     3.560   100.781     0.150
     3.840   101.881     0.150
     3.840    60.682     0.150
     3.840   101.881     0.150
     3.896    61.982     0.150
     4.252   114.881     0.150
     4.252    69.082     0.150
     4.218   109.010     0.150
     4.218    67.082     0.150
     4.480   117.182     0.150
     4.440    70.582     0.150
     4.440    70.582     0.150
     4.440   116.682     0.150
     4.440   116.682     0.150
     4.918    75.482     0.150
     0.585    14.898     0.150
     0.585    22.898     0.150
     4.096    62.539     0.150
     4.096    62.500     0.150
     4.096   108.602     0.150
     4.154    63.500     0.150
     4.154   109.102     0.150
     5.173    76.750     0.150
     5.173   133.242     0.150
     5.173    76.695     0.150
     5.173   133.195     0.150
     0.667     7.678     0.150
     0.667    16.678     0.150
     0.360    18.178     0.150
     1.801    30.777     0.150
     2.157    54.309     0.150
     2.157    55.479     0.150
     2.157    55.697     0.150
     2.452    40.098     0.150
     2.452    67.838     0.150
     2.404    34.178     0.150
     2.404    63.678     0.150
     2.693    43.678     0.150
     2.693    75.479     0.150
     2.745    42.857     0.150
     3.489    55.707     0.150
     3.725    56.760     0.150
     3.725    56.777     0.150
     3.725    56.758     0.150
     3.742    97.078     0.150
     3.847   100.355     0.150
     3.847    58.377     0.150
     3.847   100.377     0.150
     3.847   101.008     0.150
     4.729    73.188     0.150
     4.040    61.277     0.150
     4.040    61.229     0.150
     5.227    79.717     0.150
     0.329    10.133     0.150
     0.329    13.633     0.150
     0.705    22.633     0.150
     1.807    57.633     0.150
     1.856    53.633     0.150
     2.740    48.750     0.150
     2.740    79.695     0.150
     2.851    49.375     0.150
     2.851    49.336     0.150
     2.851    79.430     0.150
     3.032    49.234     0.150
     3.032    84.836     0.150
     3.276    54.031     0.150
     3.276    54.031     0.150
     3.276    89.430     0.150
     3.307    84.383     0.150
     3.307    54.633     0.150
     3.619    99.773     0.150
     3.619    58.633     0.150
     3.619    99.734     0.150
     3.774    61.633     0.150
     3.774   101.633     0.150
     3.952    63.312     0.150
     3.952    63.336     0.150
     3.952   108.930     0.150
     4.234   115.492     0.150
     4.234    66.133     0.150
     4.234   111.836     0.150
     4.262    66.922     0.150
     4.262    66.930     0.150
     4.262   112.633     0.150
     4.484    71.070     0.150
     4.484   116.625     0.150
     4.484   116.641     0.150
     4.484    70.430     0.150
     4.484   116.633     0.150
     4.609    72.633     0.150
     4.632   123.477     0.150
     4.632    72.336     0.150
     4.632   123.430     0.150
     4.713    73.930     0.150
     4.713   123.836     0.150
     4.660    74.734     0.150
     4.660   124.930     0.150
     4.781    75.375     0.150
     4.781    75.336     0.150
     4.781   127.531     0.150
     5.284    81.266     0.150
     5.284    81.234     0.150
     5.284   136.734     0.150
     5.992    92.734     0.150
     6.202    93.531     0.150
     6.422    96.633     0.150
     6.976   104.734     0.150
     6.976   179.734     0.150
     7.124   183.211     0.150
     7.124   106.875     0.150
     7.858   117.734     0.150
     7.858   117.531     0.150
     7.858   200.234     0.150
     7.858   117.531     0.150
     7.885   118.336     0.150
     8.142   122.078     0.150
     8.142   122.086     0.150
     8.142   200.992     0.150
     8.142   122.031     0.150
     8.250   207.031     0.150
     8.385   123.930     0.150
     8.494   124.430     0.150
     9.696   142.633     0.150
     9.765   143.836     0.150
     9.798   143.531     0.150
     0.556     8.156     0.150
     0.556    15.656     0.150
     0.609    17.156     0.150
     0.609    25.156     0.150
     1.059    38.656     0.150
     1.262    22.156     0.150
     1.279    25.520     0.150
     1.666    28.156     0.150
     1.666    28.156     0.150
     1.801    31.656     0.150
     1.952    32.156     0.150
     1.990    37.855     0.150
     1.990    59.855     0.150
     2.144    39.156     0.150
     2.087    65.156     0.150
     2.477    68.855     0.150
     2.477    39.336     0.150
     2.477    68.887     0.150
     2.368    39.156     0.150
     2.368    39.156     0.150
     2.897    47.504     0.150
     2.897    47.457     0.150
     2.939    46.156     0.150
     2.939    46.117     0.150
     3.051    50.484     0.150
     3.051    84.465     0.150
     3.111    50.785     0.150
     3.111    89.688     0.150
     3.234    50.734     0.150
     3.355    53.758     0.150
     3.355    94.855     0.150
     3.355    53.715     0.150
     3.503    56.285     0.150
     3.503   100.215     0.150
     3.961   105.758     0.150
     3.961    59.555     0.150
     3.961   105.785     0.150
     4.010    61.258     0.150
     4.010   107.258     0.150
     3.984   109.055     0.150
     3.984    63.176     0.150
     3.984   109.047     0.150
     4.052   105.957     0.150
     4.082    61.855     0.150
     4.082   109.457     0.150
     4.163   112.961     0.150
     4.163    64.957     0.150
     4.163   112.957     0.150
     4.163    64.945     0.150
     4.163   112.957     0.150
     4.151    65.258     0.150
     4.151    65.277     0.150
     4.151   112.906     0.150
     4.459   112.516     0.150
     4.459   112.578     0.150
     4.630    69.758     0.150
     4.630   119.258     0.150
     4.760    69.984     0.150
     4.760   124.156     0.150
     4.760    72.938     0.150
     4.760   124.137     0.150
     4.926    76.055     0.150
     4.926    76.016     0.150
     4.977    73.957     0.150
     4.977   128.566     0.150
     5.276    79.855     0.150
     5.276   139.766     0.150
     5.626    85.320     0.150
     5.626    85.355     0.150
     5.626   146.457     0.150
     5.626    85.316     0.150
     5.626   146.117     0.150
     5.626   146.484     0.150
     6.118    90.258     0.150
     6.118   155.457     0.150
     6.216    91.656     0.150
     6.216   158.457     0.150
     6.318    94.078     0.150
     6.572   170.695     0.150
     6.572   169.258     0.150
     6.572    97.227     0.150
     6.572   169.297     0.150
     6.660    96.957     0.150
     6.660   167.855     0.150
     7.014   104.418     0.150
     7.014   177.836     0.150
     7.177   186.355     0.150
     7.984   117.148     0.150
     7.984   117.156     0.150
     7.984   117.145     0.150
     7.984   202.688     0.150
     8.002   117.957     0.150
     8.172   117.758     0.150
     8.172   117.785     0.150
     8.172   206.195     0.150
    20.191   272.215     0.150
    21.281   283.355     0.150
    21.976   290.844     0.150
    25.549   328.125     0.150
    64.297   633.906     0.150
     0.653    15.383     0.150
     0.653    25.383     0.150
     1.599    29.383     0.150
     1.930    39.813     0.150
     2.841    47.383     0.150
     2.894    44.683     0.150
     2.894    44.683     0.150
     2.894    79.343     0.150
     3.186    48.983     0.150
     3.186    87.183     0.150
     3.317    53.583     0.150
     3.317    93.483     0.150
     3.317    53.543     0.150
     3.317    93.523     0.150
     3.474    55.583     0.150
     3.474    55.623     0.150
     3.474    95.883     0.150
     3.943    62.383     0.150
     3.943   108.583     0.150
     4.058    62.383     0.150
     4.058   107.083     0.150
     3.964    59.283     0.150
     4.065    59.483     0.150
     4.707    72.883     0.150
     4.707   123.483     0.150
     4.978    72.753     0.150
     4.978    72.783     0.150
     4.978    72.753     0.150
     5.228    79.883     0.150
     5.228    79.873     0.150
     5.228   138.453     0.150
     6.118    88.783     0.150
     0.155     8.117     0.150
     0.155     3.617     0.150
     0.424     8.617     0.150
     1.087    21.117     0.150
     1.663    29.617     0.150
     1.663    50.617     0.150
     1.555    53.117     0.150
     2.402    39.117     0.150
     2.402    66.117     0.150
     2.402    39.117     0.150
     4.425   117.914     0.150
     5.204    78.820     0.150
     5.204   135.016     0.150
     5.281    78.547     0.150
     5.281   135.000     0.150
     5.281   135.000     0.150
     5.281    78.516     0.150
     5.281   135.000     0.150
     5.281    78.516     0.150
     5.281   135.016     0.150
     5.185   137.820     0.150
     5.335    80.516     0.150
     5.335   138.617     0.150
     5.332   141.516     0.150
     5.907    89.117     0.150
     5.907   154.320     0.150
     6.344    94.617     0.150
     7.227   107.016     0.150
     7.429   109.016     0.150
     0.140     3.266     0.150
     0.461     8.766     0.150
     1.047    19.766     0.150
     1.682    29.266     0.150
     1.682    48.266     0.150
     4.253   114.867     0.150
     4.253    66.637     0.150
     4.253   114.836     0.150
     4.424    68.766     0.150
     4.424   118.164     0.150
     4.424   118.137     0.150
     4.491    70.066     0.150
     5.216    79.066     0.150
     5.216   135.066     0.150
     5.216    79.074     0.150
     5.216   135.086     0.150
     5.301   134.496     0.150
     5.301   134.516     0.150
     5.301    79.965     0.150
     5.301   134.465     0.150
     5.162    79.664     0.150
     5.162   137.664     0.150
     5.162   137.637     0.150
     5.247    82.125     0.150
     5.247   140.105     0.150
     5.341    80.465     0.150
     5.341   138.867     0.150
     5.341    80.496     0.150
     5.341   138.836     0.150
     5.650    85.266     0.150
     5.650    85.297     0.150
     5.650   146.176     0.150
     5.845    87.965     0.150
     5.845    87.945     0.150
     5.888    90.285     0.150
     5.888   155.246     0.150
     6.010   155.266     0.150
     7.218   181.574     0.150
     7.204   108.566     0.150
     7.419   109.008     0.150
     7.419   108.965     0.150
     7.419   109.055     0.150
     7.419   187.625     0.150
     8.919   130.766     0.150
     9.501   138.164     0.150
     9.501   138.137     0.150
     9.546   138.367     0.150
     9.546   138.387     0.150
    10.285   144.715     0.150
    10.866   157.277     0.150
    10.974   160.074     0.150
    25.662   331.984     0.150
    66.139   649.926     0.150
     0.500    15.973     0.150
     0.500    22.473     0.150
     0.836    30.473     0.150
     1.395    25.473     0.150
     4.878    74.272     0.150
     4.878   128.072     0.150
     4.889    74.373     0.150
     4.889   129.072     0.150
     5.162    79.072     0.150
     5.162   136.173     0.150
     5.359    80.873     0.150
     5.359   138.973     0.150
     5.450    82.173     0.150
     5.450   141.473     0.150
     5.911    88.473     0.150
     5.911   151.873     0.150
     6.347    97.272     0.150
     0.404    18.367     0.150
     0.579    13.867     0.150
     0.579    23.367     0.150
     0.651    22.031     0.150
     1.125    33.867     0.150
     1.125    22.367     0.150
     1.748    23.867     0.150
     2.157    69.367     0.150
     3.119    89.367     0.150
     3.696    98.539     0.150
     3.696    59.469     0.150
     3.696    98.570     0.150
     4.051   107.164     0.150
     4.131    64.266     0.150
     4.131   108.367     0.150
     4.150    65.164     0.150
     4.150   111.969     0.150
     4.505    71.984     0.150
     4.505   123.086     0.150
     4.505    71.969     0.150
     4.505   123.070     0.150
     4.621    71.969     0.150
     4.621   122.664     0.150
     4.759    75.469     0.150
     4.759   127.164     0.150
     5.077    77.164     0.150
     5.077   130.867     0.150
     5.119    77.297     0.150
     5.119   130.289     0.150
     5.119    77.266     0.150
     5.280   134.055     0.150
     5.280   134.078     0.150
     5.280    79.664     0.150
     5.280   134.070     0.150
     5.387    83.297     0.150
     5.387    83.266     0.150
     5.387   143.969     0.150
     5.448    82.570     0.150
     5.448   140.969     0.150
     5.560    84.727     0.150
     5.560    84.766     0.150
     5.560   146.469     0.150
     6.141    91.867     0.150
     6.660   101.758     0.150
     6.660   101.766     0.150
     6.660   175.469     0.150
     6.847   175.766     0.150
     7.008   103.453     0.150
     7.872   115.477     0.150
     7.872   198.578     0.150
     8.308   124.555     0.150
     8.308   124.570     0.150
     8.421   216.508     0.150
     9.241   134.070     0.150
     9.350   135.969     0.150
    10.538   151.969     0.150
    10.580   153.109     0.150
    10.580   264.523     0.150
    10.580   153.070     0.150
    10.654   153.664     0.150
    10.826   158.070     0.150
    10.826   271.266     0.150
    10.855   158.469     0.150
    10.855   271.664     0.150
    15.246   215.766     0.150
    15.246   375.367     0.150
    15.654   221.570     0.150
    15.654   384.164     0.150
     0.923    22.609     0.150
     0.979    23.609     0.150
     2.386    41.609     0.150
     2.984    49.609     0.150
     3.027    49.410     0.150
     3.027    82.910     0.150
     3.135    51.609     0.150
     3.337    54.711     0.150
     3.676   100.008     0.150
     3.822    58.809     0.150
     3.822   100.109     0.150
     3.929    60.410     0.150
     3.929   102.410     0.150
     4.072    64.211     0.150
     4.072   110.211     0.150
     4.221    64.809     0.150
     4.221   109.410     0.150
     4.382   114.309     0.150
     4.506    69.008     0.150
     4.506   118.410     0.150
     4.694    73.711     0.150
     4.694   124.211     0.150
     4.731    73.789     0.150
     4.731    73.809     0.150
     4.731   124.211     0.150
     4.941    74.711     0.150
     4.941   127.008     0.150
     6.086   158.090     0.150
     2.409    71.461     0.150
     2.646    76.461     0.150
     4.753    72.758     0.150
     4.753   125.461     0.150
     4.905   123.492     0.150
     4.905    72.359     0.150
     4.905   123.461     0.150
     5.177    77.359     0.150
     5.177   135.164     0.150
     5.504    84.359     0.150
     5.564    85.359     0.150
     5.635    86.461     0.150
     5.635   148.461     0.150
     6.054    89.062     0.150
     6.054   154.359     0.150
     6.141    89.758     0.150
     6.141   156.664     0.150
     6.512    95.359     0.150
     6.512   167.164     0.150
     7.077   106.164     0.150
     7.158   104.258     0.150
     7.665   114.062     0.150
     8.070   116.562     0.150
     8.070   191.461     0.150
     8.070   116.961     0.150
    10.282   147.461     0.150
    10.363   148.164     0.150
     0.628    15.609     0.150
     0.628    25.609     0.150
     0.661    12.609     0.150
     3.248    50.609     0.150
     4.018    61.910     0.150
     4.018   105.508     0.150
     4.084    61.711     0.150
     4.084   105.508     0.150
     4.556   117.309     0.150
     4.743   120.414     0.150
     4.743    71.109     0.150
     5.102    76.410     0.150
     0.754    27.898     0.150
     0.754    15.898     0.150
     0.804    16.898     0.150
     1.049    20.898     0.150
     1.191    23.898     0.150
     1.506    29.398     0.150
     2.181    39.898     0.150
     2.181    39.898     0.150
     2.733    45.898     0.150
     4.934    75.297     0.150
     5.433    84.797     0.150
     5.932    87.695     0.150
     5.932   152.500     0.150
     6.212    94.398     0.150
     6.367    93.898     0.150
     6.367   163.500     0.150
     7.115   104.602     0.150
     7.115   180.797     0.150
     7.467   112.797     0.150
     0.359    15.543     0.150
     1.037    21.043     0.150
     1.095    22.543     0.150
     1.095    39.543     0.150
     2.147    34.762     0.150
     2.147    61.672     0.150
     2.147    34.742     0.150
     2.147    61.645     0.150
     2.603    75.543     0.150
     2.741    75.344     0.150
     2.998    45.941     0.150
     2.998    82.543     0.150
     3.752    56.852     0.150
     3.752   103.723     0.150
     3.752    56.844     0.150
     3.752   103.742     0.150
     3.821    58.145     0.150
     3.821    99.543     0.150
     3.875    59.645     0.150
     3.875   103.344     0.150
     3.946    59.043     0.150
     3.946   102.344     0.150
     4.831    71.645     0.150
     4.831   124.043     0.150
     5.041    74.211     0.150
     5.041    74.242     0.150
     5.041   130.941     0.150
     2.280    34.637     0.150
     2.280    62.137     0.150
     2.566    41.535     0.150
     3.031    46.934     0.150
     3.031    81.934     0.150
     3.777    58.637     0.150
     3.777   102.836     0.150
     3.806    57.434     0.150
     3.806    99.934     0.150
     3.883    58.336     0.150
     3.883   102.336     0.150
     3.922    58.137     0.150
     3.922   101.734     0.150
     4.817    71.137     0.150
     4.817   123.035     0.150
     5.073    76.535     0.150
     0.765    16.020     0.150
     0.771    17.020     0.150
     0.996    20.020     0.150
     1.336    46.520     0.150
     1.336    26.520     0.150
     1.529    28.520     0.150
     1.897    34.020     0.150
     4.234    64.020     0.150
     4.288    65.020     0.150
     4.711    72.020     0.150
     4.684    71.020     0.150
     4.684   121.219     0.150
     4.772    70.885     0.150
     5.308    78.820     0.150
     0.843    16.875     0.150
     1.337    26.875     0.150
     1.643    30.875     0.150
     1.643    30.875     0.150
     1.966    35.875     0.150
     2.091    37.375     0.150
     2.412    40.875     0.150
     2.509    39.375     0.150
     2.510    40.875     0.150
     2.993    86.875     0.150
     2.993    47.875     0.150
     3.111    51.875     0.150
     3.111    88.875     0.150
     3.111    51.875     0.150
     3.290    53.875     0.150
     3.455    98.875     0.150
     3.455    55.875     0.150
     3.899    60.875     0.150
     4.041    55.875     0.150
     4.374    68.273     0.150
     4.520    70.875     0.150
     4.646    70.773     0.150
     5.257    80.676     0.150
     5.537    83.875     0.150
     5.755    85.875     0.150
     6.137    94.828     0.150
     6.300    95.773     0.150
     6.499    94.273     0.150
     6.499   165.875     0.150
     7.118   197.301     0.150
     7.118   106.664     0.150
     7.118   106.676     0.150
    19.902   272.273     0.150
     0.104     2.570     0.150
     0.377    16.570     0.150
     0.377     9.070     0.150
     0.482     5.070     0.150
     1.036    21.570     0.150
     1.425    44.570     0.150
     1.903    37.070     0.150
     3.391    93.070     0.150
     3.536    97.270     0.150
     4.394    70.270     0.150
     4.770    72.070     0.150
     4.770   124.371     0.150
     4.879    73.770     0.150
     5.359   138.570     0.150
     5.359   138.570     0.150
     5.445   140.969     0.150
     5.445   140.969     0.150
     6.143    91.270     0.150
     6.143   157.770     0.150
     7.042   103.469     0.150
     7.042   179.270     0.150
     0.897    17.322     0.150
     0.897    29.322     0.150
     0.926    18.934     0.150
     0.926    32.535     0.150
     0.926    18.922     0.150
     1.625    29.322     0.150
     1.928    59.322     0.150
     3.326    95.322     0.150
     3.345    54.021     0.150
     3.345    91.922     0.150
     3.413    94.322     0.150
     3.413    56.322     0.150
     3.651    58.322     0.150
     4.071    62.822     0.150
     4.071   107.021     0.150
     4.099    68.322     0.150
     4.099    68.322     0.150
     4.146    65.623     0.150
     4.146   113.330     0.150
     4.146    65.623     0.150
     4.146   113.322     0.150
     4.203    64.723     0.150
     4.203   112.422     0.150
     4.211    64.674     0.150
     4.211   112.857     0.150
     4.211    64.723     0.150
     4.211   112.822     0.150
     4.308    66.223     0.150
     4.308   115.223     0.150
     4.379    66.322     0.150
     4.400    67.422     0.150
     4.400   118.123     0.150
     4.485    68.182     0.150
     4.485   119.963     0.150
     4.485    68.223     0.150
     4.485   119.922     0.150
     4.550    69.322     0.150
     4.549   129.322     0.150
     4.582    70.922     0.150
     4.582   122.922     0.150
     4.653    71.422     0.150
     4.653   126.322     0.150
     4.657    73.322     0.150
     4.653    71.762     0.150
     4.653    71.723     0.150
     4.972   135.643     0.150
     4.972    77.342     0.150
     4.972   135.643     0.150
     4.972    77.322     0.150
     4.972   135.623     0.150
     5.192    80.123     0.150
     5.192   137.623     0.150
     5.381   144.143     0.150
     5.381    80.322     0.150
     5.381   144.123     0.150
     5.377    79.322     0.150
     5.537    84.322     0.150
     5.537    84.322     0.150
     5.542    84.623     0.150
     5.542   144.902     0.150
     5.542    84.623     0.150
     5.542   144.922     0.150
     5.568    82.822     0.150
     5.606    84.422     0.150
     5.606   144.521     0.150
     5.642   142.953     0.150
     5.642    83.723     0.150
     5.746    85.322     0.150
     5.746   148.422     0.150
     5.859    87.223     0.150
     5.859   150.123     0.150
     5.877    86.723     0.150
     5.880    87.223     0.150
     5.880   150.521     0.150
     6.072    94.002     0.150
     6.072    94.002     0.150
     6.072   157.342     0.150
     6.072   157.322     0.150
     6.233    94.322     0.150
     6.233   161.723     0.150
     6.260    92.322     0.150
     6.260   158.922     0.150
     6.285    93.123     0.150
     6.285   159.623     0.150
     6.454    95.021     0.150
     6.454   164.521     0.150
     6.451    95.322     0.150
     6.500    95.822     0.150
     6.500   165.322     0.150
     6.649   100.322     0.150
     6.649   172.422     0.150
     6.748    99.223     0.150
     6.748   172.422     0.150
     6.949   181.623     0.150
     6.949   102.432     0.150
     6.949   181.633     0.150
     6.949   102.422     0.150
     6.949   181.623     0.150
     6.982   178.123     0.150
     7.054   103.723     0.150
     7.054   179.521     0.150
     7.031   103.223     0.150
     7.055   104.984     0.150
     7.055   192.385     0.150
     7.055   105.021     0.150
     7.055   181.322     0.150
     7.055   104.723     0.150
     7.079   104.322     0.150
     7.079   179.822     0.150
     7.268   108.533     0.150
     7.268   108.521     0.150
     7.529   111.521     0.150
     7.529   192.223     0.150
     7.700   189.852     0.150
     7.700   112.021     0.150
     7.700   189.922     0.150
     7.860   115.123     0.150
     7.860   198.822     0.150
     7.881   115.123     0.150
     7.881   198.822     0.150
     8.029   117.803     0.150
     8.029   117.822     0.150
     8.120   120.922     0.150
     8.209   126.322     0.150
     8.277   122.680     0.150
     8.277   122.723     0.150
     8.411   122.822     0.150
     8.383   129.322     0.150
     8.809   221.123     0.150
     8.809   127.723     0.150
     8.793   129.922     0.150
     8.793   224.521     0.150
     8.887   131.422     0.150
     8.887   227.123     0.150
     9.471   139.723     0.150
     9.511   133.322     0.150
     9.652   141.650     0.150
     9.652   141.623     0.150
     9.758   245.021     0.150
     9.913   143.723     0.150
    10.122   147.623     0.150
    10.171   148.643     0.150
    10.171   148.643     0.150
    10.171   148.623     0.150
    10.361   150.242     0.150
    10.361   150.242     0.150
    10.361   150.223     0.150
    10.469   153.521     0.150
    10.601   154.322     0.150
    10.641   269.223     0.150
    10.641   153.422     0.150
    10.641   269.223     0.150
    10.641   153.422     0.150
    10.641   269.223     0.150
    10.652   157.242     0.150
    10.652   157.242     0.150
    10.652   157.223     0.150
    10.710   158.270     0.150
    10.751   155.422     0.150
    10.842   155.922     0.150
    10.842   271.123     0.150
    10.842   155.922     0.150
    10.842   271.123     0.150
    10.992   158.012     0.150
    10.992   158.014     0.150
    10.992   158.021     0.150
    11.067   160.021     0.150
    11.174   161.611     0.150
    11.174   161.623     0.150
    11.630   170.922     0.150
    13.044   185.521     0.150
    13.044   185.521     0.150
    13.307   193.322     0.150
    14.146   199.623     0.150
    14.212   201.723     0.150
    14.212   201.723     0.150
    15.111   217.521     0.150
    15.137   213.723     0.150
    15.137   213.723     0.150
    15.687   224.822     0.150
    15.687   224.822     0.150
    16.296   229.922     0.150
    16.296   229.922     0.150
    16.296   229.922     0.150
    17.480   247.248     0.150
    17.480   247.223     0.150
    17.868   250.170     0.150
    17.868   250.123     0.150
    18.046   252.422     0.150
    18.076   250.123     0.150
    18.076   250.133     0.150
    18.076   250.123     0.150
    18.415   255.885     0.150
    18.415   255.885     0.150
    18.415   255.922     0.150
    18.458   255.805     0.150
    18.458   255.822     0.150
    19.960   494.723     0.150
    20.300   277.123     0.150
    20.300   277.123     0.150
    20.586   279.223     0.150
    20.746   280.922     0.150
    20.893   282.021     0.150
    21.208   287.123     0.150
    21.208   287.123     0.150
    21.906   293.521     0.150
    22.983   301.322     0.150
    23.127   306.223     0.150
    24.033   315.623     0.150
    24.225   313.623     0.150
    25.278   329.922     0.150
    25.874   335.723     0.150
    26.291   332.521     0.150
    26.291   332.521     0.150
    32.921   390.322     0.150
    35.917   417.922     0.150
    35.917   929.422     0.150
    40.393   460.641     0.150
    48.932   529.242     0.150
    48.932   529.248     0.150
    60.587   608.322     0.150
    60.843   612.893     0.150
    60.843   612.922     0.150
    75.186   722.322     0.150
    78.562   727.447     0.150
    78.965   728.758     0.150
    82.422   747.072     0.150
   140.426  1172.582     0.150
   140.426  1172.578     0.150
   141.640  1168.521     0.150
   141.640  1168.562     0.150
   141.640  1175.963     0.150
   141.640  1168.562     0.150
   141.640  1175.963     0.150
   150.580  1195.822     0.150
   150.580  1195.822     0.150
     0.184     9.620     0.150
     0.184     5.120     0.150
     0.603    14.120     0.150
     0.603    25.620     0.150
     0.603    14.120     0.150
     0.894    20.620     0.150
     0.894    34.620     0.150
     2.032    59.455     0.150
     2.032    40.020     0.150
     2.032    59.420     0.150
     2.414    42.820     0.150
     2.545    70.340     0.150
     2.545    41.820     0.150
     2.545    70.320     0.150
     2.834    47.271     0.150
     2.834    47.320     0.150
     2.834    79.520     0.150
     2.931    47.864     0.150
     2.931    47.820     0.150
     2.931    82.520     0.150
     2.933    49.562     0.150
     2.933    49.520     0.150
     2.933    85.820     0.150
     2.922    49.370     0.150
     2.922    49.367     0.150
     2.922    49.320     0.150
     2.922    83.920     0.150
     3.259    51.520     0.150
     3.259    89.620     0.150
     3.341    95.990     0.150
     3.341    54.989     0.150
     3.341    55.020     0.150
     3.341    96.020     0.150
     3.729    59.468     0.150
     3.729    59.420     0.150
     3.729   103.320     0.150
     3.951   108.600     0.150
     3.951    62.281     0.150
     3.951   108.938     0.150
     3.951    62.320     0.150
     3.951   108.620     0.150
     4.017    62.618     0.150
     4.017    62.620     0.150
     4.179    63.330     0.150
     4.179   111.165     0.150
     4.179    63.320     0.150
     4.199    63.420     0.150
     4.199   109.620     0.150
     4.200    63.620     0.150
     4.200   109.620     0.150
     4.666    69.620     0.150
     4.666   120.920     0.150
     4.667    70.420     0.150
     4.667   120.820     0.150
     4.753    71.420     0.150
     4.753   123.620     0.150
     4.966    77.420     0.150
     4.966   132.420     0.150
     4.866    73.120     0.150
     4.866   125.520     0.150
     5.016    76.120     0.150
     5.328    80.420     0.150
     5.328   138.020     0.150
     5.378   139.620     0.150
     5.378   139.620     0.150
     5.460    82.820     0.150
     6.149    91.620     0.150
     7.942   118.288     0.150
     7.942   118.320     0.150
     9.165   134.020     0.150
     9.216   134.120     0.150
     0.212     5.531     0.150
     0.569    11.531     0.150
     2.613    43.531     0.150
     2.613    73.531     0.150
     2.613    43.531     0.150
     2.822    45.531     0.150
     3.311    52.531     0.150
     3.610    92.180     0.150
     3.610    58.230     0.150
     3.552    56.531     0.150
     3.552    96.031     0.150
     3.727    56.961     0.150
     4.058    62.328     0.150
     4.058    62.332     0.150
     4.191    64.293     0.150
     4.373   119.652     0.150
     4.373    67.293     0.150
     4.373    67.332     0.150
     4.373   119.633     0.150
     4.454    68.730     0.150
     4.454   118.832     0.150
     4.763    72.672     0.150
     4.946    74.133     0.150
     4.946   127.230     0.150
     5.012    75.031     0.150
     5.012   128.332     0.150
     5.054    75.383     0.150
     5.054    75.430     0.150
     5.068   127.410     0.150
     5.068    75.059     0.150
     5.068    75.031     0.150
     5.235    78.133     0.150
     5.235   135.031     0.150
     5.296    78.832     0.150
     5.296   136.230     0.150
     5.296    78.832     0.150
     5.296   136.230     0.150
     5.234    79.832     0.150
     5.334    79.641     0.150
     5.334    79.633     0.150
     5.426   138.512     0.150
     5.426    81.590     0.150
     5.528    82.230     0.150
     5.528   142.332     0.150
     5.538    82.430     0.150
     5.538   141.230     0.150
     5.626    84.133     0.150
     5.626   143.832     0.150
     6.091    90.230     0.150
     6.135    90.730     0.150
     6.135   156.633     0.150
     6.489    97.133     0.150
     6.886   100.387     0.150
     7.231   105.633     0.150
     7.231   181.832     0.150
     8.662   125.730     0.150
     8.662   216.430     0.150
     9.169   132.379     0.150
     9.300   227.973     0.150
     9.300   134.102     0.150
     0.626    26.320     0.150
     0.987    37.320     0.150
     1.520    49.320     0.150
     4.200    63.922     0.150
     4.200   107.219     0.150
     4.351    65.219     0.150
     4.351   112.320     0.150
     4.367    65.422     0.150
     4.367   111.023     0.150
     4.367    65.422     0.150
     4.367   111.023     0.150
     4.695    69.719     0.150
     4.695   119.820     0.150
     4.695    69.719     0.150
     4.695   119.820     0.150
     5.117    77.922     0.150
     0.345     7.084     0.150
     0.603    13.584     0.150
     1.062    34.584     0.150
     3.237    54.734     0.150
     3.237    54.164     0.150
     3.237    54.684     0.150
     3.904    60.684     0.150
     3.878    59.484     0.150
     3.878   102.884     0.150
     3.878    59.484     0.150
     3.878   102.884     0.150
     3.908    60.184     0.150
     4.084    64.244     0.150
     4.084    64.284     0.150
     4.084   109.984     0.150
     4.275   119.904     0.150
     4.275    70.284     0.150
     4.275   119.884     0.150
     4.236   112.257     0.150
     4.236    66.784     0.150
     4.926    74.989     0.150
     4.926   129.374     0.150
     4.926    74.984     0.150
     1.029    22.664     0.150
     1.329    44.664     0.150
     2.756    76.562     0.150
     2.997    46.367     0.150
     2.997    82.766     0.150
     3.754    56.211     0.150
     3.754    59.531     0.150
     3.754    59.562     0.150
     3.754   105.164     0.150
     3.837    57.961     0.150
     3.837   100.461     0.150
     3.883    60.062     0.150
     3.883   103.266     0.150
     3.916    59.648     0.150
     3.916   109.344     0.150
     3.964    59.562     0.150
     3.964   102.164     0.150
     4.846    73.164     0.150
     4.846   124.766     0.150
     5.039    74.945     0.150
     5.039    74.961     0.150
     5.418    79.664     0.150
     5.418   141.562     0.150
     0.662    20.367     0.150
     1.253    35.867     0.150
     1.253    21.867     0.150
     1.657    28.867     0.150
     1.657    48.766     0.150
     2.155    35.867     0.150
     2.155    59.867     0.150
     2.254    36.867     0.150
     2.254    66.066     0.150
     2.226    36.867     0.150
     2.417    37.867     0.150
     2.598    41.367     0.150
     2.598    71.566     0.150
     2.627    41.469     0.150
     2.627    71.367     0.150
     2.659    75.008     0.150
     2.659    41.867     0.150
     2.659    74.969     0.150
     2.688    43.066     0.150
     2.688    75.266     0.150
     3.404    51.367     0.150
     3.404    87.066     0.150
     3.438    54.469     0.150
     3.438    92.469     0.150
     3.549    53.266     0.150
     3.549    91.969     0.150
     3.597    53.969     0.150
     3.597    93.469     0.150
     3.626    54.469     0.150
     3.626    92.969     0.150
     3.624    54.168     0.150
     3.624    92.969     0.150
     3.824    57.469     0.150
     3.824    98.066     0.150
     3.908    57.969     0.150
     3.908   100.969     0.150
     3.943    58.266     0.150
     3.943   101.766     0.150
     3.997    60.266     0.150
     3.997   102.668     0.150
     4.094    60.766     0.150
     4.094   104.969     0.150
     4.165    61.566     0.150
     4.165   107.168     0.150
     4.201    61.969     0.150
     4.201   107.969     0.150
     4.104    63.867     0.150
     4.646    68.266     0.150
     4.646   117.066     0.150
     4.646    68.289     0.150
     4.646   117.117     0.150
     4.705    69.266     0.150
     4.705   120.367     0.150
     4.887    72.168     0.150
     4.887   124.766     0.150
     5.382    78.836     0.150
     5.463    82.066     0.150
     5.463   141.668     0.150
     5.563    81.168     0.150
     5.563   142.066     0.150
     5.571    81.469     0.150
     5.571    81.676     0.150
     5.786    84.266     0.150
     5.786   145.066     0.150
     5.821    84.766     0.150
     5.821   147.168     0.150
     6.338    92.168     0.150
     6.338   160.668     0.150
     6.338   160.668     0.150
     6.338    91.797     0.150
     7.001   101.168     0.150
     7.001   175.969     0.150
     7.135   103.469     0.150
     7.135   180.168     0.150
     7.135   180.168     0.150
     7.218   103.969     0.150
     7.218   180.668     0.150
     7.602   109.367     0.150
     7.602   189.969     0.150
     7.698   192.469     0.150
     7.698   110.766     0.150
     7.698   192.469     0.150
     7.737   111.367     0.150
     7.856   112.969     0.150
     9.047   129.668     0.150
     9.086   129.766     0.150
     9.078   130.867     0.150
     9.128   130.668     0.150
     9.150   131.168     0.150
     9.243   133.367     0.150
     9.258   133.668     0.150
     9.485   135.469     0.150
     9.485   235.469     0.150
     9.490   135.867     0.150
     9.490   235.766     0.150
     9.916   141.367     0.150
     9.916   246.766     0.150
    11.735   165.766     0.150
    11.735   289.766     0.150
    12.181   172.367     0.150
    12.181   301.266     0.150
    12.314   173.367     0.150
    12.314   303.766     0.150
    13.014   182.668     0.150
    13.014   320.469     0.150
    13.778   192.969     0.150
    13.778   335.867     0.150
    14.178   198.766     0.150
    14.178   347.469     0.150
    14.184   198.566     0.150
    14.184   346.566     0.150
    14.564   357.266     0.150
    14.564   203.867     0.150
    14.564   357.266     0.150
    14.993   209.566     0.150
    20.437   274.680     0.150
    22.019   296.289     0.150
    28.800   355.512     0.150
    33.895   399.887     0.150
    46.576   511.043     0.150
     2.301    41.692     0.150
     2.301    69.692     0.150
     2.610    43.692     0.150
     2.610    74.692     0.150
     4.640    72.252     0.150
     5.315    80.393     0.150
     5.315   139.093     0.150
     5.412    81.893     0.150
     5.412   140.893     0.150
     5.505    82.692     0.150
     5.837    87.692     0.150
     5.837   151.692     0.150
     5.837    87.593     0.150
     6.031    90.692     0.150
     6.031   155.692     0.150
     6.168    96.053     0.150
     7.300   110.492     0.150
     7.729   113.992     0.150
     7.729   196.893     0.150
     0.415     5.930     0.150
     0.568    18.820     0.150
     0.884    29.930     0.150
     1.296    40.930     0.150
     1.643    51.430     0.150
     1.643    30.430     0.150
     1.643    32.828     0.150
     1.643    51.430     0.150
     1.643    30.797     0.150
     1.643    32.859     0.150
     2.790    78.633     0.150
     3.149    49.930     0.150
     3.345    53.828     0.150
     3.345    92.531     0.150
     3.384    55.930     0.150
     3.454    55.672     0.150
     3.794    60.133     0.150
     3.794   102.227     0.150
     4.232    65.727     0.150
     4.232   115.430     0.150
     4.538    72.930     0.150
     4.567    71.930     0.150
     4.697    72.031     0.150
     4.697   123.328     0.150
     4.759    73.133     0.150
     4.759   124.633     0.150
     4.798    73.930     0.150
     4.806    72.930     0.150
     4.806    72.977     0.150
     4.734    87.930     0.150
     4.963    75.828     0.150
     4.905    75.930     0.150
     5.056    77.031     0.150
     5.056   132.031     0.150
     5.077    77.430     0.150
     5.277    80.133     0.150
     5.277   137.633     0.150
     5.286    80.430     0.150
     5.286   137.828     0.150
     5.371    81.531     0.150
     5.371   140.227     0.150
     5.472    90.930     0.150
     5.635    84.586     0.150
     5.635   145.883     0.150
     5.723    87.031     0.150
     5.723   149.430     0.150
     5.828    87.727     0.150
     5.828   150.227     0.150
     5.879    88.531     0.150
     5.879   151.727     0.150
     5.911   151.133     0.150
     6.452   163.477     0.150
     6.452   163.562     0.150
     6.452    96.727     0.150
     6.452   163.430     0.150
     6.464    95.828     0.150
     6.464   164.531     0.150
     6.464    95.867     0.150
     6.464   164.547     0.150
     6.628    98.328     0.150
     6.628   165.930     0.150
     6.631    98.492     0.150
     6.631    98.531     0.150
     6.631   169.133     0.150
     6.633    98.539     0.150
     6.633   169.117     0.150
     6.890   103.539     0.150
     6.890   103.531     0.150
     6.890   180.328     0.150
     6.968   103.227     0.150
     6.968   176.531     0.150
     6.997   103.828     0.150
     6.997   178.227     0.150
     7.520   197.031     0.150
     7.520   110.633     0.150
     7.520   190.930     0.150
     7.520   110.461     0.150
     7.520   189.820     0.150
     7.698   121.930     0.150
     7.897   116.227     0.150
     7.897   199.727     0.150
     7.933   200.406     0.150
     7.933   118.727     0.150
     7.933   200.430     0.150
     8.176   119.227     0.150
     8.176   207.531     0.150
     8.176   121.531     0.150
     8.176   211.328     0.150
     8.169   117.227     0.150
     8.169   204.133     0.150
     8.724   125.133     0.150
     8.724   224.250     0.150
     8.879   129.328     0.150
     8.879   222.133     0.150
     8.905   129.133     0.150
     8.905   222.227     0.150
     8.960   127.047     0.150
     9.038   130.078     0.150
     9.038   130.031     0.150
     9.038   225.227     0.150
     8.996   132.531     0.150
     8.996   230.531     0.150
     9.263   136.227     0.150
     9.385   137.133     0.150
     9.385   238.531     0.150
     9.630   141.531     0.150
     9.858   143.328     0.150
     9.858   249.633     0.150
    10.116   146.750     0.150
    10.116   251.352     0.150
    10.180   146.531     0.150
    10.180   252.531     0.150
    10.205   147.430     0.150
    10.240   148.742     0.150
    10.268   148.531     0.150
    10.268   254.430     0.150
    10.235   144.727     0.150
    10.235   253.930     0.150
    10.320   149.328     0.150
    10.320   257.133     0.150
    10.340   157.930     0.150
    10.448   151.688     0.150
    10.448   260.609     0.150
    10.451   151.633     0.150
    10.451   262.633     0.150
    10.545   159.930     0.150
    10.606   150.531     0.150
    10.606   262.227     0.150
    10.824   273.430     0.150
    10.960   268.453     0.150
    11.304   163.883     0.150
    11.458   163.227     0.150
    11.458   283.328     0.150
    11.745   166.727     0.150
    11.745   289.531     0.150
    13.297   200.828     0.150
    13.732   200.633     0.150
    14.007   204.227     0.150
    13.964   196.703     0.150
    14.296   205.961     0.150
    14.876   360.031     0.150
    14.876   210.930     0.150
    14.876   360.031     0.150
    15.058   219.727     0.150
    15.058   219.758     0.150
    15.264   215.828     0.150
    15.264   373.930     0.150
    15.285   215.828     0.150
    15.285   371.531     0.150
    15.613   221.227     0.150
    15.613   381.328     0.150
    15.936   226.133     0.150
    15.936   388.227     0.150
    16.037   227.133     0.150
    16.037   227.133     0.150
    16.037   391.633     0.150
    17.341   247.727     0.150
    17.341   247.742     0.150
    17.373   246.203     0.150
    17.732   247.633     0.150
    17.732   247.609     0.150
    17.937   255.133     0.150
    18.298   257.031     0.150
    18.460   257.133     0.150
    18.571   259.102     0.150
    18.845   262.133     0.150
    19.005   263.969     0.150
    19.057   264.328     0.150
    19.075   264.828     0.150
    19.075   264.836     0.150
    19.514   276.531     0.150
    19.831   274.531     0.150
    19.855   272.930     0.150
    19.886   277.352     0.150
    19.886   280.586     0.150
    20.572   281.531     0.150
    20.572   281.531     0.150
    20.942   283.930     0.150
    20.942   283.930     0.150
    21.054   286.898     0.150
    21.143   285.031     0.150
    21.272     3.602     0.150
    21.451   295.930     0.150
    21.451   295.930     0.150
    21.533   292.570     0.150
    21.881   293.727     0.150
    21.955   298.633     0.150
    22.119   298.133     0.150
    22.251   301.773     0.150
    22.251   299.508     0.150
    22.312     5.094     0.150
    22.479   301.828     0.150
    22.532   305.227     0.150
    22.532   299.930     0.150
    22.532   299.930     0.150
    22.532     5.297     0.150
    22.532   329.930     0.150
    22.532   299.930     0.150
    22.532   303.133     0.150
    22.532   305.227     0.150
    22.532   556.930     0.150
    22.544   302.930     0.150
    22.636   300.328     0.150
    22.770   306.898     0.150
    22.770   306.930     0.150
    22.913   306.492     0.150
    23.089   309.633     0.150
    23.308   311.828     0.150
    23.365     4.594     0.150
    23.513   307.789     0.150
    23.689   316.031     0.150
    23.689   316.039     0.150
    23.999   318.203     0.150
    24.081   319.789     0.150
    24.252   322.922     0.150
    24.619   322.031     0.150
    24.984   330.133     0.150
    24.984   327.031     0.150
    24.984   330.133     0.150
    25.138     2.102     0.150
    25.231   330.773     0.150
    25.762   331.930     0.150
    25.749   390.531     0.150
    26.304   338.328     0.150
    26.453   341.430     0.150
    26.912   346.727     0.150
    26.912   346.773     0.150
    27.123   348.430     0.150
    27.123   348.469     0.150
    27.302   404.531     0.150
    27.545   353.031     0.150
    28.357   354.836     0.150
    29.764   368.625     0.150
    35.554   424.172     0.150
    37.204   425.227     0.150
    38.768   438.430     0.150
    44.195   492.930     0.150
    55.915   577.648     0.150
    56.847   587.602     0.150
    57.719   594.633     0.150
    58.319   599.250     0.150
    60.331   611.188     0.150
    60.944   615.500     0.150
    60.959   617.258     0.150
    61.506   619.727     0.150
    62.129   623.320     0.150
    64.004   636.383     0.150
    64.646   641.789     0.150
    65.150   639.727     0.150
    67.840   660.930     0.150
    70.689   681.133     0.150
    70.948   677.828     0.150
    70.948   677.820     0.150
    71.874   685.898     0.150
    73.487   695.828     0.150
    73.487   695.789     0.150
    73.768   704.531     0.150
    73.914   699.312     0.150
    74.626   701.930     0.150
    74.626   701.898     0.150
    75.131   712.227     0.150
    75.684   710.727     0.150
    75.832   709.703     0.150
    75.873   711.062     0.150
    76.111   708.828     0.150
    76.525   713.570     0.150
    76.525   736.328     0.150
    76.724   714.633     0.150
    76.724   714.648     0.150
    76.743   714.586     0.150
    77.139   716.328     0.150
    77.139   715.289     0.150
    77.270   717.227     0.150
    77.270   717.250     0.150
    77.516   718.727     0.150
    77.516   718.688     0.150
    77.617   718.688     0.150
    77.617   719.078     0.150
    77.568   719.727     0.150
    77.741   720.219     0.150
    77.963   722.969     0.150
    78.206   723.477     0.150
    78.417   724.211     0.150
    78.454   723.430     0.150
    78.637   726.367     0.150
    78.756   725.531     0.150
    78.756   725.492     0.150
    79.301   729.031     0.150
    79.301   729.047     0.150
    79.426   729.789     0.150
    79.562   730.586     0.150
    79.733   732.422     0.150
    79.894   731.898     0.150
    79.895   732.156     0.150
    79.903   732.906     0.150
    79.904   735.828     0.150
    79.904     7.602     0.150
    80.070   733.711     0.150
    80.132   722.719     0.150
    80.457   735.492     0.150
    80.671   737.938     0.150
    80.854   736.641     0.150
    80.856   736.453     0.150
    81.676   742.281     0.150
    82.176   743.430     0.150
    82.176   743.469     0.150
    82.412   746.023     0.150
    83.072   748.109     0.150
    84.367   756.531     0.150
    84.367   756.508     0.150
    84.436     8.797     0.150
    84.436   950.930     0.150
    85.397   761.328     0.150
    85.397   761.320     0.150
    86.131     7.102     0.150
    87.393   771.930     0.150
    87.393   771.953     0.150
    87.398   771.781     0.150
    87.506     4.797     0.150
    87.506     8.398     0.150
    90.275     5.195     0.150
    90.275     6.797     0.150
    91.145   788.617     0.150
    95.011   806.430     0.150
    95.011   805.188     0.150
   141.727  1168.562     0.150
   141.727  1174.930     0.150
   143.004  1173.078     0.150
   143.004  1176.930     0.150
   145.501  1181.773     0.150
     0.275    13.562     0.150
     0.275     7.062     0.150
     0.809    18.562     0.150
     1.737    56.562     0.150
     2.277    66.562     0.150
     3.338    53.262     0.150
     3.338    93.461     0.150
     3.338    53.254     0.150
     3.338    93.441     0.150
     3.685    55.762     0.150
     3.685    96.262     0.150
     3.707    55.863     0.150
     3.707    97.262     0.150
     3.724    56.062     0.150
     3.724    96.762     0.150
     3.743    55.863     0.150
     3.743    97.262     0.150
     3.680    60.562     0.150
     3.853    59.562     0.150
     3.853    59.594     0.150
     3.853    99.492     0.150
     3.991    62.562     0.150
     3.991   104.562     0.150
     4.096    63.562     0.150
     4.096    63.562     0.150
     4.096   108.164     0.150
     4.185    63.363     0.150
     4.185   108.062     0.150
     4.728    70.363     0.150
     4.728   122.062     0.150
     0.553    11.715     0.150
     0.537    11.715     0.150
     1.571    27.715     0.150
     1.924    56.715     0.150
     1.924    35.215     0.150
     2.099    36.715     0.150
     2.099    40.477     0.150
     2.099    65.953     0.150
     3.086    84.215     0.150
     3.086    49.715     0.150
     4.577    66.695     0.150
     5.118    75.414     0.150
     5.118    75.375     0.150
     5.446    81.715     0.150
     5.446   139.816     0.150
     5.546    83.613     0.150
     5.546   142.215     0.150
     5.623    83.816     0.150
     5.623   145.316     0.150
     5.718    84.914     0.150
     5.718   148.113     0.150
     5.960    89.316     0.150
     5.960   153.215     0.150
     6.176   160.516     0.150
     6.176    92.016     0.150
     6.176   157.016     0.150
     6.178    91.586     0.150
     6.693    97.914     0.150
     6.693   170.215     0.150
     6.937   102.414     0.150
     6.937   177.215     0.150
     7.456   109.414     0.150
     7.456   189.016     0.150
     2.119    38.734     0.150
     2.119    63.734     0.150
     2.119    66.234     0.150
     2.119    38.062     0.150
     2.119    66.188     0.150
     3.018    49.734     0.150
     4.985    76.203     0.150
     4.985   130.422     0.150
     5.478    80.938     0.150
     5.478   140.031     0.150
     5.468    81.031     0.150
     5.588    82.234     0.150
     5.588   142.336     0.150
     5.598    82.234     0.150
     5.598   142.734     0.150
     5.701    83.836     0.150
     5.701   145.836     0.150
     5.946    87.633     0.150
     5.946   152.336     0.150
     6.231    91.234     0.150
     6.231   157.734     0.150
     6.287    91.836     0.150
     6.287   158.531     0.150
     6.510    97.875     0.150
     6.748    98.336     0.150
     6.748   170.938     0.150
     6.696   100.375     0.150
     7.022   101.938     0.150
     7.022   178.438     0.150
     7.420   108.633     0.150
     7.420   188.031     0.150
     7.559   109.336     0.150
     7.559   189.734     0.150
     7.829   114.422     0.150
     7.975   114.938     0.150
     7.975   199.734     0.150
     8.536   122.836     0.150
     8.536   212.438     0.150
     9.265   133.336     0.150
     9.265   230.234     0.150
    10.040   141.906     0.150
    11.429   282.922     0.150
     0.285     6.467     0.150
     0.494    12.467     0.150
     0.494    12.467     0.150
     0.494    20.467     0.150
     1.331    45.467     0.150
     2.593    75.467     0.150
     3.852    61.455     0.150
     4.607    69.916     0.150
     4.772    71.896     0.150
     4.772   122.736     0.150
     5.342    79.066     0.150
     5.342   136.768     0.150
     5.452    80.768     0.150
     5.452   139.768     0.150
     5.488    81.166     0.150
     5.488   140.867     0.150
     5.591    82.566     0.150
     5.591   143.566     0.150
     5.835    86.066     0.150
     5.835   149.268     0.150
     6.084    89.666     0.150
     6.084   155.268     0.150
     6.112    89.867     0.150
     6.112   155.967     0.150
     6.601    96.666     0.150
     6.601   166.967     0.150
     7.389   107.367     0.150
     7.389   186.268     0.150
     8.366   119.367     0.150
     9.842   140.164     0.150
     5.560    82.842     0.150
     5.560   142.592     0.150
     5.701   144.291     0.150
     5.701    84.439     0.150
     5.701   144.260     0.150
     6.708    98.971     0.150
     6.708   169.561     0.150
     0.464    10.312     0.150
     0.464    17.812     0.150
     0.581    12.312     0.150
     0.581    20.812     0.150
     1.087    22.312     0.150
     1.087    37.312     0.150
     1.240    24.312     0.150
     1.240    42.312     0.150
     1.342    27.312     0.150
     1.342    45.312     0.150
     1.995    36.312     0.150
     1.995    60.812     0.150
     2.361    40.312     0.150
     2.361    70.312     0.150
     2.581    43.312     0.150
     2.581    73.312     0.150
     2.715    47.312     0.150
     2.715    78.312     0.150
     5.370    80.109     0.150
     5.370   138.016     0.150
     5.468    81.711     0.150
     5.468   140.211     0.150
     5.468    81.711     0.150
     5.468   140.211     0.150
     5.541    83.109     0.150
     5.541   143.211     0.150
     5.555    82.812     0.150
     5.555   143.312     0.150
     5.648    84.312     0.150
     5.648   146.109     0.150
     5.648    84.312     0.150
     5.648   146.109     0.150
     5.645    83.914     0.150
     5.645   147.109     0.150
     5.889   152.414     0.150
     5.889   152.414     0.150
     6.083    90.516     0.150
     6.083   156.609     0.150
     6.091    90.711     0.150
     6.091   156.516     0.150
     6.091    90.711     0.150
     6.091   156.516     0.150
     6.614    97.711     0.150
     6.614   169.711     0.150
     6.660    98.609     0.150
     6.660   171.812     0.150
     0.250     5.992     0.150
     0.250     9.992     0.150
     0.447     9.992     0.150
     0.447    16.992     0.150
     0.714    14.992     0.150
     0.714    23.992     0.150
     1.247    23.992     0.150
     1.247    39.992     0.150
     1.471    27.992     0.150
     1.471    46.992     0.150
     1.947    33.992     0.150
     1.947    57.992     0.150
     3.224    52.992     0.150
     3.224    52.992     0.150
     3.224    89.992     0.150
     3.616    96.191     0.150
     4.766    71.793     0.150
     4.766   123.594     0.150
     4.766    71.793     0.150
     4.766   123.594     0.150
     4.836    72.793     0.150
     4.836   125.094     0.150
     4.836    72.793     0.150
     4.836   125.094     0.150
     4.883    73.492     0.150
     4.883   126.594     0.150
     4.911    73.992     0.150
     4.911   127.293     0.150
     5.047    75.492     0.150
     5.110    76.793     0.150
     5.110   131.891     0.150
     5.110    76.793     0.150
     5.110   131.891     0.150
     5.223    79.391     0.150
     5.223   135.094     0.150
     5.334    80.891     0.150
     5.343    79.891     0.150
     5.343   137.594     0.150
     5.933    88.094     0.150
     6.657    96.992     0.150
     6.657    96.992     0.150
     0.406    15.605     0.150
     0.406     9.105     0.150
     0.406    15.605     0.150
     0.874    27.605     0.150
     0.874    17.605     0.150
     0.874    27.605     0.150
     0.937    20.605     0.150
     0.937    32.605     0.150
     1.336    25.605     0.150
     1.336    44.605     0.150
     1.648    31.605     0.150
     1.648    52.605     0.150
     1.874    54.605     0.150
     1.874    33.605     0.150
     1.874    54.605     0.150
     2.400    65.934     0.150
     2.941    46.746     0.150
     3.390    92.105     0.150
     3.573    57.707     0.150
     4.531    69.707     0.150
     4.531   120.605     0.150
     4.672    71.805     0.150
     4.672   122.207     0.150
     5.026    76.707     0.150
     5.026   131.805     0.150
     5.537    83.605     0.150
     0.610    12.086     0.150
     0.610    20.586     0.150
     0.610    12.586     0.150
     0.610    19.586     0.150
     0.554    12.086     0.150
     0.554    20.586     0.150
     0.554    12.586     0.150
     0.554    20.586     0.150
     1.183    37.586     0.150
     1.183    22.586     0.150
     1.183    22.586     0.150
     1.183    42.586     0.150
     1.183    23.586     0.150
     1.183    37.586     0.150
     1.537    30.586     0.150
     1.537    30.586     0.150
     1.537    51.586     0.150
     1.537    30.586     0.150
     1.537    48.586     0.150
     1.630    52.586     0.150
     1.630    30.586     0.150
     1.630    52.586     0.150
     1.630    29.586     0.150
     1.630    52.586     0.150
     3.075    49.586     0.150
     3.075    86.586     0.150
     3.075    49.586     0.150
     3.075    86.586     0.150
     3.961    64.875     0.150
     3.961    64.873     0.150
     3.961   108.596     0.150
     3.961    64.873     0.150
     3.961   108.596     0.150
     3.961    64.887     0.150
     3.961   108.586     0.150
     4.173    65.586     0.150
     4.173   114.586     0.150
     4.173    65.586     0.150
     4.173   114.586     0.150
     4.319    70.047     0.150
     4.319    70.047     0.150
     4.319   118.205     0.150
     4.319    70.047     0.150
     4.319   118.205     0.150
     4.319    70.086     0.150
     4.319   118.186     0.150
     4.379    71.506     0.150
     4.379    70.316     0.150
     4.379   116.414     0.150
     4.379    70.316     0.150
     4.379   116.414     0.150
     4.379    71.486     0.150
     4.379   116.387     0.150
     4.527    74.186     0.150
     4.527   122.645     0.150
     4.527   122.645     0.150
     4.527    74.186     0.150
     4.527   122.686     0.150
     5.368    81.186     0.150
     5.422    84.316     0.150
     5.422    84.318     0.150
     5.422    84.318     0.150
     5.422   142.258     0.150
     5.422    84.285     0.150
     5.422    81.387     0.150
     5.451    82.285     0.150
     5.451    82.285     0.150
     5.451   143.621     0.150
     5.451    82.285     0.150
     5.505    86.756     0.150
     5.505    86.762     0.150
     5.505    86.762     0.150
     5.505   146.416     0.150
     5.560    86.016     0.150
     5.560   144.873     0.150
     5.560    86.016     0.150
     5.560   144.873     0.150
     5.560    85.986     0.150
     5.687   145.467     0.150
     5.687    85.605     0.150
     5.687    85.605     0.150
     5.687   149.068     0.150
     5.687    85.586     0.150
     5.687   149.387     0.150
     5.746    83.586     0.150
     5.746   144.486     0.150
     5.902   150.686     0.150
     5.902    89.086     0.150
     6.443    97.467     0.150
     6.443    97.471     0.150
     6.443    97.471     0.150
     6.443   168.383     0.150
     6.443    97.486     0.150
     6.702   103.986     0.150
     7.174   106.586     0.150
     7.585   110.887     0.150
     7.585   110.887     0.150
     8.764   128.195     0.150
     8.764   128.195     0.150
     8.764   128.186     0.150
     8.764   128.186     0.150
     9.648   140.125     0.150
     9.648   140.125     0.150
     9.648   140.086     0.150
     0.672    15.070     0.150
     0.672    25.070     0.150
     0.807    17.070     0.150
     0.807    27.070     0.150
     1.020    20.070     0.150
     1.020    34.070     0.150
     1.152    22.070     0.150
     1.152    37.070     0.150
     1.150    22.070     0.150
     1.503    28.070     0.150
     1.503    47.070     0.150
     1.642    30.070     0.150
     1.642    51.070     0.150
     2.153    37.070     0.150
     2.153    64.070     0.150
     4.001    60.805     0.150
     4.001   104.715     0.150
     4.001    60.770     0.150
     4.001   104.770     0.150
     4.075    60.320     0.150
     4.075   105.660     0.150
     4.075    60.270     0.150
     4.075   105.672     0.150
     4.359    65.555     0.150
     4.359   112.891     0.150
     4.359    65.570     0.150
     4.359   112.871     0.150
     4.565    68.969     0.150
     4.565   118.023     0.150
     4.565    68.969     0.150
     4.565   118.070     0.150
     5.092    75.383     0.150
     5.092   129.246     0.150
     5.092    75.371     0.150
     5.092   129.270     0.150
     1.278    43.617     0.150
     1.618    54.617     0.150
     5.171    78.016     0.150
     5.171   134.418     0.150
     5.315    79.918     0.150
     5.315   140.316     0.150
     5.282    79.816     0.150
     5.282   137.117     0.150
     5.568    83.719     0.150
     5.568   144.117     0.150
     5.947    89.016     0.150
     7.223   106.219     0.150
     0.308     7.252     0.150
     0.308    12.752     0.150
     0.308     7.252     0.150
     0.308    12.752     0.150
     0.636    13.252     0.150
     0.636    21.752     0.150
     0.636    13.252     0.150
     0.636    21.752     0.150
     0.917    19.252     0.150
     0.917    31.752     0.150
     0.917    19.252     0.150
     0.917    31.752     0.150
     1.254    24.252     0.150
     1.254    40.252     0.150
     1.254    24.252     0.150
     1.254    40.252     0.150
     1.813    33.252     0.150
     1.813    55.252     0.150
     1.813    33.252     0.150
     1.813    55.252     0.150
     3.547    50.310     0.150
     3.547    50.310     0.150
     5.185   134.852     0.150
     5.280   136.452     0.150
     5.350    79.762     0.150
     5.350   137.462     0.150
     5.447   139.440     0.150
     5.880    87.320     0.150
     5.880   150.670     0.150
     5.895    87.852     0.150
     5.895   151.152     0.150
     6.462    94.492     0.150
     6.462   165.352     0.150
     0.775    29.008     0.150
     0.775    17.508     0.150
     0.775    29.008     0.150
     0.775    17.508     0.150
     0.775    29.008     0.150
     0.844    18.008     0.150
     0.844    29.508     0.150
     0.844    18.008     0.150
     0.844    29.508     0.150
     1.039    33.508     0.150
     1.039    21.008     0.150
     1.039    33.508     0.150
     1.039    21.008     0.150
     1.039    33.508     0.150
     1.427    27.008     0.150
     1.427    47.008     0.150
     1.427    27.008     0.150
     1.427    47.008     0.150
     1.559    29.008     0.150
     1.559    48.008     0.150
     1.559    29.008     0.150
     1.559    48.008     0.150
     1.976    35.008     0.150
     1.976    60.008     0.150
     1.976    35.008     0.150
     1.976    60.008     0.150
     3.077    48.555     0.150
     3.077    84.039     0.150
     4.034    63.008     0.150
     4.034   105.711     0.150
     4.034    63.008     0.150
     4.034   105.711     0.150
     4.034    63.008     0.150
     4.034   105.711     0.150
     4.109    64.305     0.150
     4.109   107.305     0.150
     4.109    64.305     0.150
     4.109   107.305     0.150
     4.109    64.305     0.150
     4.109   107.305     0.150
     4.162    64.922     0.150
     4.162   108.508     0.150
     4.222    64.805     0.150
     4.222   111.977     0.150
     4.222    64.805     0.150
     4.222   112.008     0.150
     4.422    68.508     0.150
     4.422   114.805     0.150
     4.422    68.508     0.150
     4.422   114.805     0.150
     4.422    68.508     0.150
     4.422   114.805     0.150
     4.479    68.727     0.150
     4.479   116.062     0.150
     4.479    68.711     0.150
     4.479   116.109     0.150
     4.678    71.711     0.150
     4.678   121.211     0.150
     4.678    71.711     0.150
     4.678   121.211     0.150
     4.678    71.711     0.150
     4.678   121.211     0.150
     4.666    71.070     0.150
     4.666   120.148     0.150
     4.745   121.609     0.150
     4.745    72.867     0.150
     4.745   121.609     0.150
     4.745    67.711     0.150
     5.241    78.773     0.150
     5.241   135.438     0.150
     5.241    78.805     0.150
     0.953    29.562     0.150
     0.953    19.062     0.150
     0.953    29.562     0.150
     0.953    19.062     0.150
     0.953    29.562     0.150
     0.779    17.562     0.150
     0.779    27.562     0.150
     0.779    17.562     0.150
     0.858    18.562     0.150
     0.858    28.562     0.150
     1.268    26.562     0.150
     1.268    42.562     0.150
     1.435    28.562     0.150
     1.435    46.562     0.150
     1.435    28.562     0.150
     1.435    46.562     0.150
     1.563    28.562     0.150
     1.914    34.562     0.150
     1.990    34.062     0.150
     1.990    58.562     0.150
     2.173    38.062     0.150
     2.173    64.562     0.150
     2.233    39.562     0.150
     2.233    66.562     0.150
     2.314    39.662     0.150
     2.314    65.062     0.150
     2.853    47.102     0.150
     2.853    47.062     0.150
     2.853    79.962     0.150
     2.877    48.562     0.150
     2.877    48.562     0.150
     2.877    81.562     0.150
     2.877    48.562     0.150
     2.877    81.562     0.150
     3.071    49.072     0.150
     3.071    85.160     0.150
     3.071    49.062     0.150
     3.071    85.162     0.150
     3.256    52.150     0.150
     3.256    87.970     0.150
     3.256    52.162     0.150
     3.256    87.962     0.150
     3.309    52.562     0.150
     3.309    89.562     0.150
     3.707    99.982     0.150
     3.707    57.562     0.150
     3.707    99.962     0.150
     3.784    61.082     0.150
     3.784   102.662     0.150
     3.784    61.062     0.150
     3.784   102.662     0.150
     4.022    60.962     0.150
     4.022   105.962     0.150
     4.022    60.962     0.150
     4.022   105.962     0.150
     4.097    62.062     0.150
     4.097   106.962     0.150
     4.097    62.062     0.150
     4.097   106.962     0.150
     4.151    63.140     0.150
     4.151    63.162     0.150
     4.151   107.462     0.150
     4.061    63.420     0.150
     4.061    63.462     0.150
     4.061   109.462     0.150
     4.079    64.762     0.150
     4.079   110.362     0.150
     4.095    65.122     0.150
     4.095   111.762     0.150
     4.095    65.162     0.150
     4.095   111.762     0.150
     4.141    64.362     0.150
     4.141   110.702     0.150
     4.141    64.362     0.150
     4.141   110.662     0.150
     4.212    63.760     0.150
     4.212    63.762     0.150
     4.212   110.762     0.150
     4.297    65.572     0.150
     4.297    65.570     0.150
     4.297    65.562     0.150
     4.297   110.962     0.150
     4.297   112.462     0.150
     4.361    66.862     0.150
     4.361   114.762     0.150
     4.361    66.862     0.150
     4.361   114.762     0.150
     4.409    66.662     0.150
     4.409   114.562     0.150
     4.409    66.662     0.150
     4.409   114.562     0.150
     4.463    68.562     0.150
     4.463    68.562     0.150
     4.463   117.562     0.150
     4.471    67.612     0.150
     4.471   116.392     0.150
     4.471    67.562     0.150
     4.471   116.362     0.150
     4.594    69.962     0.150
     4.594   118.862     0.150
     4.594    69.962     0.150
     4.594   118.862     0.150
     4.658   120.122     0.150
     4.668    70.162     0.150
     4.668   120.462     0.150
     4.668    70.162     0.150
     4.668   120.462     0.150
     4.717    70.462     0.150
     4.717   121.762     0.150
     4.717    70.462     0.150
     4.717   121.762     0.150
     4.660    70.860     0.150
     4.660   120.890     0.150
     4.660    70.862     0.150
     4.660   120.862     0.150
     4.743    73.660     0.150
     4.743    73.662     0.150
     4.743   126.762     0.150
     4.836    73.762     0.150
     4.836   126.722     0.150
     4.836    73.762     0.150
     4.836   126.762     0.150
     4.892   126.562     0.150
     4.892    75.562     0.150
     4.892   126.562     0.150
     4.892    75.562     0.150
     4.947    76.742     0.150
     4.947    76.762     0.150
     4.947   132.862     0.150
     5.230   137.562     0.150
     5.230    77.962     0.150
     5.230   137.562     0.150
     5.230    77.962     0.150
     5.230   137.562     0.150
     5.231    77.918     0.150
     5.231   134.472     0.150
     5.231    77.962     0.150
     5.231   134.462     0.150
     5.258    78.362     0.150
     5.258   134.762     0.150
     5.445    80.862     0.150
     5.445   139.962     0.150
     5.445    80.862     0.150
     5.445   139.962     0.150
     5.690    85.902     0.150
     5.690   147.402     0.150
     5.690    85.862     0.150
     5.690   147.362     0.150
     5.790    85.662     0.150
     5.790   150.362     0.150
     5.949    88.262     0.150
     5.949   150.962     0.150
     5.949    88.262     0.150
     5.949   150.962     0.150
     5.972    88.362     0.150
     5.972   151.562     0.150
     5.972    88.362     0.150
     5.972   151.562     0.150
     6.031    89.399     0.150
     6.031    89.462     0.150
     6.031   152.462     0.150
     6.031   154.462     0.150
     6.043    89.462     0.150
     6.096    91.810     0.150
     6.096   158.742     0.150
     6.096    91.762     0.150
     6.096   158.762     0.150
     6.235    92.050     0.150
     6.235   157.475     0.150
     6.235    92.062     0.150
     6.235    91.862     0.150
     6.355    93.462     0.150
     6.355   163.562     0.150
     6.355    93.462     0.150
     6.355   163.562     0.150
     6.365    93.762     0.150
     6.365    93.762     0.150
     6.450    94.281     0.150
     6.450    94.262     0.150
     6.801   102.350     0.150
     6.801   102.362     0.150
     7.147   104.682     0.150
     7.147   179.212     0.150
     7.147   104.662     0.150
     7.128   104.742     0.150
     7.128   104.762     0.150
     7.607   110.630     0.150
     7.607   191.322     0.150
     7.607   110.662     0.150
     7.607   192.762     0.150
     7.981   117.310     0.150
     7.981   202.660     0.150
     7.981   117.262     0.150
     8.354   121.660     0.150
     8.354   209.520     0.150
     8.354   121.662     0.150
     8.438   122.360     0.150
     8.438   211.252     0.150
     8.438   122.362     0.150
     8.540   127.162     0.150
     8.828   128.862     0.150
     8.828   128.862     0.150
     8.835   128.682     0.150
     8.835   128.662     0.150
     8.817   128.220     0.150
     8.817   128.262     0.150
     9.512   136.802     0.150
     9.512   136.762     0.150
     9.654   139.150     0.150
     9.654   139.162     0.150
     9.692   140.070     0.150
     9.692   241.162     0.150
     9.692   140.062     0.150
     9.763   141.500     0.150
     9.763   141.462     0.150
     9.789   141.630     0.150
     9.789   244.042     0.150
     9.789   141.662     0.150
     9.896   143.562     0.150
     9.921   145.162     0.150
    10.115   146.962     0.150
    10.115   251.522     0.150
    10.115   146.962     0.150
    10.119   146.665     0.150
    10.119   146.662     0.150
    10.149   146.362     0.150
    10.149   252.862     0.150
    10.149   146.362     0.150
    10.151   147.062     0.150
    10.151   252.762     0.150
    10.151   147.062     0.150
    10.172   147.322     0.150
    10.172   253.172     0.150
    10.172   147.362     0.150
    10.201   146.980     0.150
    10.201   254.190     0.150
    10.201   146.962     0.150
    10.573   152.262     0.150
    10.573   264.162     0.150
    10.573   152.262     0.150
    12.836   183.162     0.150
    12.836   183.162     0.150
    12.973   184.462     0.150
    12.973   184.462     0.150
    13.624   193.562     0.150
    13.624   193.562     0.150
    13.679   193.862     0.150
    13.679   193.862     0.150
    14.434   203.662     0.150
    14.434   203.662     0.150
    14.669   208.462     0.150
    14.669   208.462     0.150
    14.679   212.732     0.150
    14.679   212.762     0.150
    14.839   209.262     0.150
    14.839   209.262     0.150
    14.836   208.762     0.150
    14.836   208.762     0.150
    15.228   214.762     0.150
    15.228   214.762     0.150
    15.567   219.162     0.150
    15.657   220.562     0.150
    15.657   220.562     0.150
     0.301     6.539     0.150
     0.301    10.539     0.150
     0.396     8.539     0.150
     0.396    15.539     0.150
     1.135    24.539     0.150
     1.135    24.539     0.150
     1.135    38.539     0.150
     1.457    28.539     0.150
     1.457    47.539     0.150
     2.413    41.539     0.150
     2.413    70.539     0.150
     5.194    78.336     0.150
     5.194   137.141     0.150
     5.194    78.336     0.150
     5.194   137.141     0.150
     5.298    80.141     0.150
     5.298   139.836     0.150
     5.298    80.141     0.150
     5.298   139.836     0.150
     5.360    80.539     0.150
     5.360   141.039     0.150
     5.379    81.039     0.150
     5.458    82.242     0.150
     5.458   143.836     0.150
     5.458    82.242     0.150
     5.458   143.836     0.150
     5.590    84.336     0.150
     5.590   146.742     0.150
     5.590    84.336     0.150
     5.590   146.742     0.150
     5.700    85.938     0.150
     5.700   149.438     0.150
     5.700    85.938     0.150
     5.700   149.438     0.150
     5.943    89.039     0.150
     5.943   155.039     0.150
     5.943    89.039     0.150
     5.943   155.039     0.150
     6.001   157.336     0.150
     6.515    96.141     0.150
     6.697   100.336     0.150
     6.697   174.641     0.150
     6.697   100.336     0.150
     6.697   174.641     0.150
     7.222   107.039     0.150
     7.222   186.141     0.150
     7.222   107.039     0.150
     7.222   186.141     0.150
     0.201     4.609     0.150
     0.201     8.609     0.150
     0.832    17.109     0.150
     0.832    29.609     0.150
     0.984    32.609     0.150
     0.984    19.609     0.150
     0.984    32.609     0.150
     1.315    42.609     0.150
     1.315    25.609     0.150
     1.315    42.609     0.150
     1.340    42.609     0.150
     1.340    26.109     0.150
     1.340    42.609     0.150
     1.401    26.609     0.150
     1.401    46.609     0.150
     1.833    34.609     0.150
     1.833    56.609     0.150
     3.327    53.609     0.150
     3.327    90.609     0.150
     3.481    94.391     0.150
     3.481    56.180     0.150
     3.481    94.391     0.150
     3.481    56.211     0.150
     3.481    94.406     0.150
     3.791   101.938     0.150
     3.791   101.906     0.150
     3.979    61.992     0.150
     3.979    62.008     0.150
     3.979   106.008     0.150
     4.362    71.211     0.150
     4.739    72.109     0.150
     4.739   123.906     0.150
     4.781    73.789     0.150
     4.781    73.789     0.150
     4.781    73.812     0.150
     4.796    73.109     0.150
     4.796   125.375     0.150
     4.796    73.109     0.150
     4.796   125.406     0.150
     4.969    75.531     0.150
     4.969   128.492     0.150
     4.969    75.508     0.150
     4.969   128.508     0.150
     4.969    75.508     0.150
     5.024    79.648     0.150
     5.024   137.289     0.150
     5.024    79.648     0.150
     5.024   135.930     0.150
     5.024    79.609     0.150
     5.024   137.312     0.150
     5.028    76.406     0.150
     5.028    76.406     0.150
     5.028   131.109     0.150
     5.057    76.812     0.150
     5.057   131.812     0.150
     5.088    78.086     0.150
     5.088   132.750     0.150
     5.088    78.109     0.150
     5.088   132.711     0.150
     5.265    79.508     0.150
     5.265   136.508     0.150
     5.259    79.906     0.150
     5.259   137.211     0.150
     5.352    81.312     0.150
     5.352   138.812     0.150
     5.662    84.711     0.150
     5.819    87.297     0.150
     5.819   149.133     0.150
     5.819    87.312     0.150
     5.861    88.211     0.150
     6.055    90.609     0.150
     6.544    97.406     0.150
     6.958   103.109     0.150
     6.982   102.039     0.150
     6.982   102.039     0.150
     6.982   102.008     0.150
     8.172   120.164     0.150
     8.172   120.211     0.150
     8.905   131.953     0.150
     0.560    22.199     0.150
     1.684    51.199     0.150
     4.180    62.801     0.150
     4.180   109.801     0.150
     4.466    67.898     0.150
     4.466   114.801     0.150
     4.669    70.898     0.150
     4.669   123.500     0.150
     4.785    72.898     0.150
     4.840   131.578     0.150
     5.252    78.098     0.150
     5.252   135.000     0.150
     5.252    78.098     0.150
     5.252   135.000     0.150
     5.334    79.301     0.150
     5.334   137.199     0.150
     5.334    79.301     0.150
     5.334   137.199     0.150
     5.391    80.098     0.150
     5.391   138.500     0.150
     5.447    80.500     0.150
     5.447   138.699     0.150
     5.567    82.598     0.150
     5.567   143.699     0.150
     5.567    82.598     0.150
     5.567   143.699     0.150
     5.642    83.801     0.150
     5.642   145.098     0.150
     5.642    83.801     0.150
     5.642   145.098     0.150
     5.713   141.340     0.150
     5.804    86.098     0.150
     5.804   148.598     0.150
     5.804    86.098     0.150
     5.804   148.598     0.150
     5.787    85.898     0.150
     5.787   148.801     0.150
     5.907    87.098     0.150
     5.907   151.699     0.150
     5.907    87.098     0.150
     5.907   151.699     0.150
     5.956    88.598     0.150
     5.956   152.699     0.150
     5.956    88.598     0.150
     5.956   152.699     0.150
     6.238    91.801     0.150
     6.238   159.398     0.150
     6.470    94.598     0.150
     6.470    94.598     0.150
     6.468    95.000     0.150
     6.686    98.301     0.150
     6.686   170.699     0.150
     6.686    98.301     0.150
     6.686   170.699     0.150
     7.031   102.500     0.150
     7.031   179.398     0.150
     7.188   105.098     0.150
     7.188   182.000     0.150
     7.188   105.098     0.150
     7.188   182.000     0.150
     7.254   106.246     0.150
     7.254   106.199     0.150
     7.254   182.301     0.150
     7.254   185.000     0.150
     7.345   106.801     0.150
     7.604   110.699     0.150
     7.604   191.199     0.150
     7.604   110.699     0.150
     7.604   191.199     0.150
     7.660   110.379     0.150
     7.660   110.398     0.150
     7.660   191.598     0.150
     8.160   118.398     0.150
     8.160   118.398     0.150
     8.836   127.910     0.150
     8.836   127.898     0.150
     8.836   221.301     0.150
     8.836   222.098     0.150
     8.816   126.898     0.150
     9.042   130.598     0.150
     9.042   130.598     0.150
     9.151   132.098     0.150
     9.575   137.898     0.150
     9.575   239.598     0.150
     9.676   139.098     0.150
    10.062   144.500     0.150
     4.290   112.226     0.150
     4.810    73.825     0.150
     4.919    75.525     0.150
     5.263    79.525     0.150
     5.263   137.025     0.150
     5.263    79.525     0.150
     5.263   137.025     0.150
     5.353    80.525     0.150
     5.353   139.925     0.150
     5.353    80.525     0.150
     5.353   139.925     0.150
     5.419    81.425     0.150
     5.419   140.726     0.150
     5.475   142.425     0.150
     5.500    82.125     0.150
     5.500   142.226     0.150
     5.560    84.726     0.150
     5.560    84.726     0.150
     5.656    85.925     0.150
     5.656   146.025     0.150
     5.656    85.925     0.150
     5.656   146.025     0.150
     5.799    87.025     0.150
     5.799    87.025     0.150
     5.894    88.625     0.150
     5.894   151.525     0.150
     5.953    89.425     0.150
     5.953   153.025     0.150
     5.953    89.425     0.150
     5.953   153.025     0.150
     6.246    92.726     0.150
     6.246   161.925     0.150
     6.518    96.726     0.150
     6.518   166.925     0.150
     6.724   100.125     0.150
     6.724   172.125     0.150
     6.724   100.125     0.150
     6.724   172.125     0.150
     7.234   106.726     0.150
     7.234   184.325     0.150
     7.234   106.726     0.150
     7.234   184.325     0.150
     7.735   112.285     0.150
     7.735   112.325     0.150
     8.897   129.625     0.150
     4.610    70.508     0.150
     5.346    79.906     0.150
     5.346   138.305     0.150
     5.346    79.906     0.150
     5.346   138.305     0.150
     5.456    81.305     0.150
     5.456   141.008     0.150
     5.456    81.305     0.150
     5.456   141.008     0.150
     5.493    81.805     0.150
     5.493   142.109     0.150
     5.493   143.109     0.150
     5.542    82.406     0.150
     5.542   143.305     0.150
     5.596    83.508     0.150
     5.596   145.109     0.150
     5.596    83.508     0.150
     5.596   145.109     0.150
     5.682    83.906     0.150
     5.682   145.109     0.150
     5.743    85.508     0.150
     5.743   148.109     0.150
     5.743    85.508     0.150
     5.743   148.109     0.150
     5.983    88.609     0.150
     5.983    88.609     0.150
     6.088   156.305     0.150
     6.088   156.305     0.150
     6.116    90.609     0.150
     6.116   157.305     0.150
     6.116    90.609     0.150
     6.116   157.305     0.150
     6.202    91.406     0.150
     6.202   159.008     0.150
     6.316    93.109     0.150
     6.316   161.406     0.150
     6.689    98.008     0.150
     6.689   170.805     0.150
     6.864   101.008     0.150
     6.864   175.805     0.150
     6.864   101.008     0.150
     6.864   175.805     0.150
     7.166   105.109     0.150
     7.166   182.906     0.150
     0.668    14.422     0.150
     0.668    23.422     0.150
     0.832    26.422     0.150
     0.832    16.422     0.150
     0.832    26.422     0.150
     0.876    17.922     0.150
     0.876    29.422     0.150
     0.967    19.422     0.150
     0.967    32.422     0.150
     5.421    80.723     0.150
     5.421   140.121     0.150
     5.421    80.723     0.150
     5.421   140.121     0.150
     5.504    81.723     0.150
     5.504   142.820     0.150
     5.504    81.723     0.150
     5.504   142.820     0.150
     5.562    82.523     0.150
     5.562   143.223     0.150
     5.618    83.320     0.150
     5.618   146.121     0.150
     5.812   150.223     0.150
     5.812   150.223     0.150
     6.059    90.723     0.150
     6.059   154.023     0.150
     6.059    90.723     0.150
     6.059   154.023     0.150
     6.059    90.723     0.150
     6.078    90.121     0.150
     6.078   156.922     0.150
     6.078    90.121     0.150
     6.078   156.922     0.150
     6.407    95.121     0.150
     6.639    97.422     0.150
     6.639   170.320     0.150
     0.073     5.785     0.150
     0.073     2.285     0.150
     0.073     5.785     0.150
     0.621    13.285     0.150
     0.621    22.285     0.150
     0.970    20.086     0.150
     0.970    33.285     0.150
     1.413    24.285     0.150
     1.413    24.285     0.150
     1.413    43.285     0.150
     1.663    31.285     0.150
     1.663    52.285     0.150
     2.043    36.285     0.150
     2.043    60.285     0.150
     2.524    41.984     0.150
     2.938    82.785     0.150
     3.164    50.285     0.150
     3.164    87.684     0.150
     3.368    92.086     0.150
     3.441    54.684     0.150
     3.988    60.887     0.150
     3.988   106.684     0.150
     4.010   104.785     0.150
     4.010   104.785     0.150
     4.105    65.285     0.150
     4.041    60.586     0.150
     4.041   105.387     0.150
     4.041    60.586     0.150
     4.041   105.387     0.150
     4.053   108.926     0.150
     4.053    61.484     0.150
     4.053   108.887     0.150
     4.169    65.285     0.150
     4.169   112.387     0.150
     4.374    66.785     0.150
     4.374   114.086     0.150
     4.374    66.785     0.150
     4.374   114.086     0.150
     4.403    66.785     0.150
     4.403    67.086     0.150
     4.403   115.586     0.150
     4.428    68.184     0.150
     4.428    68.184     0.150
     4.428   115.484     0.150
     4.428    68.184     0.150
     4.428   115.484     0.150
     4.472    67.484     0.150
     4.472   115.984     0.150
     4.472    67.484     0.150
     4.472   115.984     0.150
     4.644   117.684     0.150
     4.644    70.184     0.150
     4.644   117.684     0.150
     4.644    70.184     0.150
     4.644   117.684     0.150
     5.007    74.785     0.150
     5.007   129.984     0.150
     4.989    74.484     0.150
     4.989   129.484     0.150
     5.277    78.984     0.150
     5.277   135.984     0.150
     5.277    78.984     0.150
     5.277   135.984     0.150
     5.410    82.586     0.150
     5.676    84.086     0.150
     0.195     7.477     0.150
     0.195     3.676     0.150
     0.195     7.477     0.150
     0.666    14.676     0.150
     0.666    24.676     0.150
     0.972    35.676     0.150
     0.972    20.676     0.150
     0.972    35.676     0.150
     1.319    23.676     0.150
     1.319    40.676     0.150
     1.734    31.676     0.150
     1.734    55.676     0.150
     1.996    35.676     0.150
     1.996    61.676     0.150
     3.135    50.277     0.150
     3.135    85.574     0.150
     3.307    52.277     0.150
     3.307    90.574     0.150
     4.050    61.875     0.150
     4.050   106.375     0.150
     4.106    61.477     0.150
     4.106   105.777     0.150
     4.106    61.477     0.150
     4.106   105.777     0.150
     4.064   113.266     0.150
     4.131    61.676     0.150
     4.131   107.176     0.150
     4.131    61.676     0.150
     4.131   107.176     0.150
     4.136    63.176     0.150
     4.136   105.977     0.150
     4.171    67.246     0.150
     4.171   108.875     0.150
     4.466   114.977     0.150
     4.466   114.977     0.150
     4.514   116.777     0.150
     4.514    66.875     0.150
     4.514    68.176     0.150
     4.514   116.875     0.150
     4.534   116.277     0.150
     4.534   116.277     0.150
     4.538    68.277     0.150
     4.538   116.977     0.150
     4.538    68.277     0.150
     4.538   116.977     0.150
     5.066    75.777     0.150
     5.082    75.074     0.150
     5.082   130.777     0.150
     5.346    79.875     0.150
     5.346   137.277     0.150
     5.346    79.875     0.150
     5.346   137.277     0.150
     0.457     9.990     0.150
     0.457    16.990     0.150
     0.457     9.990     0.150
     0.457    16.990     0.150
     0.580    12.990     0.150
     0.580    21.990     0.150
     0.580    11.990     0.150
     0.580    21.990     0.150
     1.303    24.990     0.150
     1.303    42.990     0.150
     1.303    24.990     0.150
     1.303    42.990     0.150
     1.418    47.450     0.150
     1.418    26.052     0.150
     1.418    47.452     0.150
     1.418    26.090     0.150
     1.418    47.490     0.150
     1.545    28.990     0.150
     1.545    49.990     0.150
     1.545    28.990     0.150
     1.545    49.990     0.150
     1.386    25.990     0.150
     1.386    44.990     0.150
     1.386    25.990     0.150
     1.386    44.990     0.150
     1.790    31.990     0.150
     1.790    53.990     0.150
     2.118    36.190     0.150
     2.118    61.590     0.150
     2.210    64.990     0.150
     2.210    64.990     0.150
     2.210    38.990     0.150
     2.210    64.990     0.150
     2.403    67.990     0.150
     2.576    73.990     0.150
     2.576    45.990     0.150
     2.576    73.990     0.150
     3.521    57.990     0.150
     3.521    98.990     0.150
     3.495    56.990     0.150
     3.495    95.990     0.150
     3.642    57.990     0.150
     3.642   100.990     0.150
     3.704    58.990     0.150
     3.704    99.990     0.150
     3.924    63.653     0.150
     3.924    63.690     0.150
     4.013    62.990     0.150
     4.013   108.990     0.150
     4.861    73.758     0.150
     4.861   125.218     0.150
     4.861    73.790     0.150
     4.861   125.190     0.150
     4.921    74.190     0.150
     5.222    78.086     0.150
     5.222   136.870     0.150
     5.222    78.090     0.150
     5.222   136.890     0.150
     5.322    80.510     0.150
     5.322   138.030     0.150
     5.322    80.490     0.150
     5.322   137.990     0.150
     5.356    80.610     0.150
     5.356   138.090     0.150
     5.356    80.590     0.150
     5.356   138.090     0.150
     5.475    80.990     0.150
     5.475   139.990     0.150
     5.475    80.990     0.150
     5.475   139.990     0.150
     5.580    82.490     0.150
     5.580   142.790     0.150
     5.580    82.490     0.150
     5.580   142.790     0.150
     5.516    83.938     0.150
     5.516   145.098     0.150
     5.516    83.890     0.150
     5.516   145.090     0.150
     5.635    83.475     0.150
     5.635   143.610     0.150
     5.635    83.090     0.150
     5.635    83.490     0.150
     5.635   143.590     0.150
     5.635   145.590     0.150
     5.661    84.038     0.150
     5.661   144.810     0.150
     5.661    83.990     0.150
     5.661   144.790     0.150
     5.603    84.690     0.150
     5.631    86.310     0.150
     5.631    86.290     0.150
     5.735    84.590     0.150
     5.735   147.490     0.150
     5.735    84.590     0.150
     5.735   147.490     0.150
     5.785    85.268     0.150
     5.785   147.218     0.150
     5.785    85.290     0.150
     5.785   147.190     0.150
     5.871    86.690     0.150
     5.871   150.790     0.150
     5.871    86.690     0.150
     5.871   150.790     0.150
     5.978    88.190     0.150
     5.978    88.190     0.150
     5.978   154.290     0.150
     6.211    91.090     0.150
     6.211   157.690     0.150
     6.211    91.090     0.150
     6.211   157.690     0.150
     6.225    91.490     0.150
     6.225   158.990     0.150
     6.225    91.490     0.150
     6.225   158.990     0.150
     6.263    92.118     0.150
     6.263   159.528     0.150
     6.263    92.090     0.150
     6.263   159.490     0.150
     6.267    94.990     0.150
     6.267   162.370     0.150
     6.267    94.990     0.150
     6.267   162.390     0.150
     6.448    94.290     0.150
     6.448   163.390     0.150
     6.411    94.390     0.150
     6.411   163.650     0.150
     6.411    94.390     0.150
     6.411   163.690     0.150
     6.437    97.030     0.150
     6.437    96.990     0.150
     6.729    98.490     0.150
     6.729    98.490     0.150
     6.729   170.390     0.150
     6.729    98.490     0.150
     6.729   170.390     0.150
     6.793    99.790     0.150
     6.793   172.490     0.150
     6.793    99.790     0.150
     6.793   172.490     0.150
     6.796    99.314     0.150
     6.796   171.710     0.150
     6.796    99.290     0.150
     6.796   171.690     0.150
     6.980   101.790     0.150
     6.980   178.190     0.150
     6.980   101.790     0.150
     6.980   178.190     0.150
     7.012   105.858     0.150
     7.012   105.890     0.150
     6.948   139.990     0.150
     6.948   139.990     0.150
     7.108   103.298     0.150
     7.108   179.078     0.150
     7.108   103.290     0.150
     7.081   137.990     0.150
     7.081   137.990     0.150
     7.289   105.990     0.150
     7.289   184.690     0.150
     7.211   107.230     0.150
     7.211   184.276     0.150
     7.211   107.190     0.150
     7.211   184.290     0.150
     7.446   108.988     0.150
     7.446   189.048     0.150
     7.446   108.790     0.150
     7.446   189.090     0.150
     7.446   190.290     0.150
     7.504   109.090     0.150
     7.504   188.690     0.150
     7.504   109.090     0.150
     7.504   188.690     0.150
     7.557   112.572     0.150
     7.557   112.590     0.150
     7.649   110.390     0.150
     7.642   112.590     0.150
     7.557   142.990     0.150
     7.557   142.990     0.150
     7.834   113.538     0.150
     7.834   196.890     0.150
     7.834   113.490     0.150
     7.834   196.890     0.150
     7.920   114.790     0.150
     7.920   198.390     0.150
     7.920   114.790     0.150
     8.051   117.046     0.150
     8.051   201.570     0.150
     8.051   117.090     0.150
     8.177   121.780     0.150
     8.177   121.778     0.150
     8.177   121.790     0.150
     8.480   122.790     0.150
     8.480   212.690     0.150
     8.480   122.390     0.150
     8.480   212.690     0.150
     8.513   147.990     0.150
     8.513   147.990     0.150
     8.754   125.320     0.150
     8.754   125.320     0.150
     8.754   218.340     0.150
     8.754   125.290     0.150
     8.804   127.990     0.150
     8.804   215.590     0.150
     8.804   126.890     0.150
     8.806   126.890     0.150
     8.806   220.990     0.150
     8.837   127.590     0.150
     8.837   222.690     0.150
     8.837   127.590     0.150
     8.837   222.690     0.150
     9.188   231.590     0.150
     9.188   132.540     0.150
     9.188   132.536     0.150
     9.188   228.190     0.150
     9.188   132.490     0.150
     9.188   231.590     0.150
     9.276   133.490     0.150
     9.276   133.490     0.150
     9.276   234.690     0.150
     9.365   134.590     0.150
     9.365   134.590     0.150
     9.365   235.690     0.150
     9.355   134.496     0.150
     9.355   233.220     0.150
     9.355   134.490     0.150
     9.471   135.990     0.150
     9.517   138.190     0.150
     9.517   241.590     0.150
     9.461   137.648     0.150
     9.461   137.690     0.150
     9.809   140.990     0.150
     9.809   245.290     0.150
     9.809   140.990     0.150
     9.809   245.290     0.150
     9.832   141.290     0.150
     9.832   244.390     0.150
     9.832   141.290     0.150
     9.944   143.118     0.150
     9.944   247.198     0.150
     9.944   143.090     0.150
    10.116   145.690     0.150
    10.116   252.590     0.150
    10.283   149.698     0.150
    10.283   149.690     0.150
    11.188   160.408     0.150
    11.188   274.728     0.150
    11.188   160.390     0.150
    11.302   161.150     0.150
    11.302   279.430     0.150
    11.302   161.190     0.150
    11.349   163.548     0.150
    11.349   163.590     0.150
    11.314   163.990     0.150
    11.395   163.868     0.150
    11.395   280.910     0.150
    11.395   163.890     0.150
    11.395   163.190     0.150
    11.463   165.090     0.150
    11.482   165.990     0.150
    11.691   169.630     0.150
    11.691   169.590     0.150
    11.701   168.590     0.150
    11.718   168.990     0.150
    11.726   169.648     0.150
    11.726   169.690     0.150
    11.749   168.870     0.150
    11.749   168.890     0.150
    12.099   169.390     0.150
    12.099   174.790     0.150
    13.046   181.890     0.150
    13.271   190.390     0.150
    13.271   190.390     0.150
    16.045   223.690     0.150
    16.045   223.690     0.150
    16.450   232.090     0.150
    16.446   228.990     0.150
    16.446   228.990     0.150
    20.040   273.690     0.150
    20.040   273.740     0.150
    20.040   273.790     0.150
    22.427   297.270     0.150
    22.427   297.273     0.150
    22.427   297.290     0.150
    25.219   326.990     0.150
    62.752   625.590     0.150
    65.273   642.517     0.150
    65.273   642.490     0.150
    66.377   649.415     0.150
    66.377   649.390     0.150
    77.885   719.940     0.150
    77.885   719.940     0.150
    77.885   719.990     0.150
     0.301     6.289     0.150
     0.301    12.289     0.150
     0.518    11.289     0.150
     0.518    19.289     0.150
     0.654    13.789     0.150
     0.654    23.289     0.150
     1.219    23.289     0.150
     1.219    23.289     0.150
     1.219    40.289     0.150
     1.193    23.789     0.150
     1.193    23.789     0.150
     1.193    39.289     0.150
     1.211    23.289     0.150
     1.211    40.289     0.150
     1.541    29.289     0.150
     1.541    47.789     0.150
     2.713    44.289     0.150
     2.713    77.289     0.150
     3.169    50.289     0.150
     3.169    88.289     0.150
     4.814    72.391     0.150
     4.814    72.391     0.150
     4.814   124.688     0.150
     4.886    73.391     0.150
     4.886    73.391     0.150
     4.886   126.391     0.150
     4.935    74.289     0.150
     4.935   127.492     0.150
     4.970    74.891     0.150
     4.970   129.086     0.150
     5.086    76.789     0.150
     5.086   131.492     0.150
     5.200    77.891     0.150
     5.200    77.891     0.150
     5.200   134.289     0.150
     5.292    80.391     0.150
     5.292   137.289     0.150
     5.386    80.586     0.150
     5.386    80.586     0.150
     5.434    81.289     0.150
     5.434    81.289     0.150
     5.802    86.891     0.150
     5.802    86.891     0.150
     5.991    88.789     0.150
     6.219    92.289     0.150
     6.219    92.289     0.150
     6.575    97.188     0.150
     6.715    99.586     0.150
     6.715    99.586     0.150
     7.170   103.758     0.150
     7.170   103.789     0.150
     0.550    12.613     0.150
     0.550    19.113     0.150
     1.100    21.613     0.150
     1.100    36.113     0.150
     1.295    26.113     0.150
     1.295    44.113     0.150
     1.453    46.113     0.150
     1.453    28.113     0.150
     1.453    46.113     0.150
     1.482    29.613     0.150
     1.482    48.113     0.150
     1.943    36.113     0.150
     1.943    59.113     0.150
     2.862    44.512     0.150
     2.862    78.613     0.150
     2.958    46.293     0.150
     2.958    46.312     0.150
     2.958    82.113     0.150
     3.074    51.113     0.150
     3.074    85.512     0.150
     3.330    54.613     0.150
     3.330    91.512     0.150
     3.400    55.215     0.150
     3.947    62.414     0.150
     3.947   106.012     0.150
     4.017    63.312     0.150
     4.017   107.613     0.150
     4.086    65.715     0.150
     4.086   111.215     0.150
     4.365    68.512     0.150
     4.365   115.715     0.150
     4.632    71.113     0.150
     4.632   121.312     0.150
     4.845    74.012     0.150
     4.845   126.012     0.150
     4.879    74.414     0.150
     4.879   126.812     0.150
     4.879    74.414     0.150
     4.879   126.812     0.150
     4.891    74.613     0.150
     4.891   127.215     0.150
     4.891    74.613     0.150
     4.891   127.215     0.150
     5.131    78.914     0.150
     5.131    78.914     0.150
     5.131   134.312     0.150
     5.131    78.914     0.150
     5.131   134.312     0.150
     5.379    81.613     0.150
     5.379   139.113     0.150
     5.610    84.914     0.150
     5.610   145.113     0.150
     5.833    87.312     0.150
     5.802    87.715     0.150
     6.777   101.312     0.150
     0.242    12.383     0.150
     0.242     6.383     0.150
     0.242    12.383     0.150
     0.806    17.383     0.150
     0.806    29.484     0.150
     1.294    24.383     0.150
     1.294    42.383     0.150
     1.721    33.383     0.150
     1.721    54.383     0.150
     1.918    35.383     0.150
     1.918    59.383     0.150
     5.508    82.383     0.150
     5.508   142.680     0.150
     5.641    84.086     0.150
     5.641   146.383     0.150
     5.828    85.984     0.150
     5.828   149.883     0.150
     6.211    91.586     0.150
     6.211   160.586     0.150
     6.822    99.984     0.150
     6.822   173.781     0.150
     0.276     5.875     0.150
     0.276    10.875     0.150
     0.329     6.875     0.150
     0.329    11.875     0.150
     1.588    29.875     0.150
     1.588    50.875     0.150
     1.774    31.875     0.150
     1.774    54.875     0.150
     5.155    77.477     0.150
     5.155   134.578     0.150
     5.155    77.477     0.150
     5.155   134.578     0.150
     5.265    78.875     0.150
     5.265   136.172     0.150
     5.265    78.875     0.150
     5.265   136.172     0.150
     5.350    78.984     0.150
     5.350    78.977     0.150
     5.350   138.477     0.150
     5.492    81.875     0.150
     5.492   142.078     0.150
     5.552    83.172     0.150
     5.552   143.875     0.150
     5.552    83.172     0.150
     5.552   143.875     0.150
     5.792    86.578     0.150
     5.792   151.172     0.150
     5.792    86.578     0.150
     5.792   151.172     0.150
     5.821    86.477     0.150
     5.821   149.875     0.150
     5.925    87.875     0.150
     5.925   152.875     0.150
     5.925    87.875     0.150
     5.925   152.875     0.150
     6.125    90.672     0.150
     6.125   156.773     0.150
     6.499    95.578     0.150
     7.202   105.578     0.150
     7.202   183.773     0.150
     7.202   105.578     0.150
     7.202   183.773     0.150
     0.662    14.102     0.150
     0.662    24.102     0.150
     0.747    29.102     0.150
     0.747    16.602     0.150
     0.747    29.102     0.150
     1.375    24.602     0.150
     1.375    43.102     0.150
     1.654    30.602     0.150
     1.654    51.102     0.150
     1.671    31.102     0.150
     1.671    52.102     0.150
     1.768    33.102     0.150
     1.768    56.102     0.150
     2.336    42.102     0.150
     2.336    42.102     0.150
     2.336    69.602     0.150
     4.451    68.402     0.150
     4.451   118.000     0.150
     4.466    68.102     0.150
     4.466   117.102     0.150
     4.566    69.402     0.150
     4.566   120.301     0.150
     4.566    69.402     0.150
     4.566   120.301     0.150
     4.582    69.102     0.150
     4.585    68.801     0.150
     4.585   118.703     0.150
     4.585    68.801     0.150
     4.585   118.703     0.150
     4.959    73.902     0.150
     4.959   127.102     0.150
     4.959    73.902     0.150
     4.959   127.102     0.150
     5.173    77.602     0.150
     5.173   133.902     0.150
     5.173    77.602     0.150
     5.173   133.902     0.150
     5.213    77.902     0.150
     5.213    77.902     0.150
     5.476    81.102     0.150
     5.538    82.102     0.150
     5.645    83.203     0.150
     5.645    83.203     0.150
     5.771    86.301     0.150
     0.103     6.154     0.150
     0.103    10.154     0.150
     0.589    11.154     0.150
     0.589    11.154     0.150
     0.589    21.154     0.150
     1.132    21.654     0.150
     1.132    35.154     0.150
     1.702    30.154     0.150
     1.702    51.154     0.150
     1.659    32.654     0.150
     1.659    55.154     0.150
     1.659    32.654     0.150
     1.659    55.154     0.150
     3.077    46.455     0.150
     3.077    81.854     0.150
     3.903   103.654     0.150
     4.316    64.754     0.150
     4.316   110.154     0.150
     4.316    64.754     0.150
     4.316   110.154     0.150
     4.371    65.055     0.150
     4.371   111.354     0.150
     4.371    65.055     0.150
     4.371   111.354     0.150
     4.405    64.254     0.150
     4.405   111.555     0.150
     4.402    64.455     0.150
     4.402   111.555     0.150
     4.642   117.883     0.150
     4.642    67.555     0.150
     4.642    69.754     0.150
     4.642   117.854     0.150
     4.560    67.055     0.150
     4.560   117.455     0.150
     4.690    68.854     0.150
     4.690   120.254     0.150
     4.690    68.854     0.150
     4.690   120.254     0.150
     4.644    72.393     0.150
     4.644    72.354     0.150
     4.644   122.754     0.150
     4.917    72.455     0.150
     4.917   125.254     0.150
     4.917    72.455     0.150
     4.917   125.254     0.150
     4.875    71.654     0.150
     4.875   122.754     0.150
     4.875    71.654     0.150
     4.875   122.754     0.150
     5.303    77.555     0.150
     5.303   134.754     0.150
     5.424    79.055     0.150
     5.424   136.154     0.150
     6.042    87.254     0.150
     6.042   152.654     0.150
     6.152    89.254     0.150
     6.152   154.354     0.150
     6.152    89.254     0.150
     6.577    94.955     0.150
     7.116   102.854     0.150
     7.116   102.854     0.150
     0.459    10.254     0.150
     0.459    18.254     0.150
     0.799    18.254     0.150
     0.799    32.254     0.150
     0.799    18.254     0.150
     0.799    32.254     0.150
     1.205    25.254     0.150
     1.205    25.254     0.150
     1.610    31.254     0.150
     1.610    53.754     0.150
     1.610    31.254     0.150
     1.610    53.754     0.150
     2.129    67.754     0.150
     2.129    38.254     0.150
     2.129    67.754     0.150
     2.505    39.354     0.150
     2.505    66.754     0.150
     2.354    41.254     0.150
     2.354    71.254     0.150
     2.723    42.054     0.150
     2.723    72.154     0.150
     3.153    48.754     0.150
     3.625    53.354     0.150
     3.625    93.754     0.150
     3.625    53.354     0.150
     3.625    93.754     0.150
     3.677    54.154     0.150
     3.677    94.955     0.150
     3.677    54.154     0.150
     3.677    94.955     0.150
     3.716    54.354     0.150
     3.716    95.254     0.150
     3.710    54.854     0.150
     3.710    93.955     0.150
     3.923    59.254     0.150
     3.923   100.254     0.150
     4.001   102.654     0.150
     4.001   102.654     0.150
     4.096    60.955     0.150
     4.096   105.354     0.150
     4.184    61.254     0.150
     4.184   106.455     0.150
     4.184    61.254     0.150
     4.184   106.455     0.150
     4.235    62.455     0.150
     4.235   108.554     0.150
     4.235    62.455     0.150
     4.235   108.554     0.150
     4.253   105.625     0.150
     4.253    61.955     0.150
     4.253    61.895     0.150
     4.253   109.154     0.150
     4.253    61.955     0.150
     4.253   109.154     0.150
     4.612    68.554     0.150
     4.612    68.554     0.150
     4.612   117.754     0.150
     4.738    69.754     0.150
     4.738   119.054     0.150
     4.789    70.254     0.150
     4.789    70.254     0.150
     4.976    72.754     0.150
     4.976   126.354     0.150
     5.346   135.754     0.150
     5.463    79.455     0.150
     5.463   138.554     0.150
     5.463    79.455     0.150
     5.463   138.554     0.150
     5.918    84.854     0.150
     5.918   148.054     0.150
     7.096   101.455     0.150
     7.833   112.254     0.150
     0.605    12.367     0.150
     0.605    20.867     0.150
     0.640    13.867     0.150
     0.640    22.867     0.150
     0.932    18.867     0.150
     0.932    30.867     0.150
     0.968    19.867     0.150
     0.968    32.867     0.150
     1.017    20.867     0.150
     1.017    34.867     0.150
     1.641    31.367     0.150
     1.641    51.867     0.150
     5.241    78.367     0.150
     5.241   134.566     0.150
     5.241    78.367     0.150
     5.241   134.566     0.150
     5.320    79.566     0.150
     5.320   136.566     0.150
     5.320    79.566     0.150
     5.320   136.566     0.150
     5.375    80.469     0.150
     5.375   138.668     0.150
     5.424    81.066     0.150
     5.424   141.066     0.150
     5.488    82.566     0.150
     5.488    83.168     0.150
     5.488   143.066     0.150
     5.563    82.668     0.150
     5.563   142.969     0.150
     5.563    82.668     0.150
     5.563   142.969     0.150
     5.563    82.668     0.150
     5.563   142.969     0.150
     5.620    83.566     0.150
     5.620   145.066     0.150
     5.630    84.066     0.150
     5.630   144.668     0.150
     5.630    84.066     0.150
     5.630   144.668     0.150
     5.746    85.867     0.150
     5.746   148.969     0.150
     5.879    87.367     0.150
     5.879   150.668     0.150
     5.879    87.367     0.150
     5.879   150.668     0.150
     5.886    87.469     0.150
     5.886   150.867     0.150
     5.886    87.469     0.150
     5.886   150.867     0.150
     6.228    91.668     0.150
     6.445    95.469     0.150
     6.667    98.668     0.150
     6.667   170.469     0.150
     7.015   102.566     0.150
     7.166   105.266     0.150
     7.166   105.266     0.150
     7.630   111.766     0.150
     8.810   128.266     0.150
     9.546   138.469     0.150
     9.654   138.566     0.150
     0.502    19.727     0.150
     5.329    78.426     0.150
     5.329   136.227     0.150
     5.441    79.826     0.150
     5.441   138.426     0.150
     5.575   143.527     0.150
     5.726    84.127     0.150
     5.726   146.127     0.150
     5.819   148.926     0.150
     5.966   147.938     0.150
     5.966    87.727     0.150
     6.105    89.127     0.150
     6.298    91.426     0.150
     6.298   159.426     0.150
     7.151   103.727     0.150
     0.276     4.904     0.150
     0.276     4.904     0.150
     0.276    10.104     0.150
     1.240    25.104     0.150
     1.240    43.104     0.150
     1.370    26.104     0.150
     1.370    45.104     0.150
     1.664    31.104     0.150
     1.664    53.104     0.150
     1.774    32.604     0.150
     1.774    53.104     0.150
     1.992    37.104     0.150
     1.992    37.104     0.150
     1.992    62.104     0.150
     2.252    38.104     0.150
     2.252    65.104     0.150
     2.462    74.104     0.150
     2.462    43.104     0.150
     2.462    74.104     0.150
     5.171    77.803     0.150
     5.171   133.904     0.150
     5.171    77.803     0.150
     5.171   133.904     0.150
     5.205    77.904     0.150
     5.205   134.104     0.150
     5.259    78.803     0.150
     5.259   135.803     0.150
     5.309    80.104     0.150
     5.309    80.104     0.150
     5.407    80.504     0.150
     5.457    82.004     0.150
     5.457   141.504     0.150
     5.457    82.004     0.150
     5.552    83.203     0.150
     5.552   143.703     0.150
     5.552    83.203     0.150
     5.748    85.904     0.150
     5.838    87.004     0.150
     5.838   150.904     0.150
     5.838    87.004     0.150
     5.961    88.703     0.150
     6.412    93.904     0.150
     0.228    12.500     0.150
     0.228     7.500     0.150
     0.228    12.500     0.150
     0.720    23.500     0.150
     0.720    14.500     0.150
     0.720    23.500     0.150
     0.760    14.500     0.150
     0.760    24.500     0.150
     0.760    14.500     0.150
     0.760    24.500     0.150
     1.223    23.500     0.150
     1.223    39.500     0.150
     1.451    44.898     0.150
     1.443    27.500     0.150
     1.443    47.500     0.150
     2.288    34.773     0.150
     2.288    34.797     0.150
     2.288    64.500     0.150
     2.296    67.500     0.150
     2.296    39.500     0.150
     2.296    67.500     0.150
     2.275    40.500     0.150
     2.275    40.500     0.150
     2.275    69.500     0.150
     2.803    44.297     0.150
     2.803    77.703     0.150
     2.870    45.898     0.150
     2.870    79.398     0.150
     2.948    46.703     0.150
     2.948    82.398     0.150
     2.869    46.500     0.150
     2.869    81.500     0.150
     2.957    48.203     0.150
     2.957    81.797     0.150
     3.007    49.102     0.150
     3.007    81.898     0.150
     3.608    57.398     0.150
     3.608    99.203     0.150
     3.739    59.703     0.150
     3.739   101.898     0.150
     3.856    59.797     0.150
     3.856   104.102     0.150
     3.874    59.500     0.150
     3.874   103.297     0.150
     3.971   103.398     0.150
     4.037   106.695     0.150
     4.037    62.602     0.150
     4.037   106.703     0.150
     4.155    62.203     0.150
     4.155   107.703     0.150
     4.183    62.398     0.150
     4.183   108.203     0.150
     4.183    62.398     0.150
     4.183   108.203     0.150
     4.191    63.297     0.150
     4.191   108.703     0.150
     4.191    63.297     0.150
     4.191   108.703     0.150
     4.469    67.398     0.150
     4.469   116.000     0.150
     4.469    67.398     0.150
     4.469   116.000     0.150
     4.524    67.898     0.150
     4.524   116.203     0.150
     4.524    67.898     0.150
     4.524   116.203     0.150
     4.667    68.641     0.150
     4.667    69.602     0.150
     4.667   121.297     0.150
     4.667    69.602     0.150
     4.667   121.297     0.150
     4.773    71.102     0.150
     4.773   123.000     0.150
     4.863    73.000     0.150
     4.863   126.703     0.150
     4.863    73.000     0.150
     4.863   126.703     0.150
     4.835    74.500     0.150
     4.964    74.297     0.150
     4.964   127.703     0.150
     5.195    77.500     0.150
     5.195   133.203     0.150
     5.195    77.500     0.150
     5.195   133.203     0.150
     5.223   137.375     0.150
     5.223    77.703     0.150
     5.223   137.398     0.150
     5.696    84.797     0.150
     5.696   146.797     0.150
     5.696    84.797     0.150
     5.696   146.797     0.150
     5.925    88.422     0.150
     5.925    88.398     0.150
     6.094    89.898     0.150
     6.094   155.602     0.150
     6.094    89.898     0.150
     6.094   155.602     0.150
     6.319    93.102     0.150
     6.621   169.898     0.150
     6.621   169.898     0.150
     6.621   169.898     0.150
     6.721    99.000     0.150
     7.020   179.297     0.150
     7.020   179.297     0.150
     7.735   112.703     0.150
     7.735   112.703     0.150
     8.120   118.102     0.150
     8.927   128.219     0.150
     8.927   128.203     0.150
     9.144   133.000     0.150
     9.184   135.273     0.150
     0.429    18.195     0.150
     0.429    10.195     0.150
     0.429    18.195     0.150
     0.595    12.695     0.150
     0.595    22.195     0.150
     1.043    20.195     0.150
     1.043    20.195     0.150
     1.043    35.195     0.150
     1.233    24.195     0.150
     1.233    41.195     0.150
     1.295    26.195     0.150
     1.295    43.195     0.150
     1.995    36.695     0.150
     1.964    35.195     0.150
     1.964    59.195     0.150
     2.027    35.195     0.150
     2.027    61.195     0.150
     2.316    40.195     0.150
     2.316    69.195     0.150
     3.168    53.195     0.150
     3.168    90.195     0.150
     3.237    53.195     0.150
     3.237    91.195     0.150
     3.299    54.195     0.150
     3.299    92.195     0.150
     3.637    60.195     0.150
     3.637   100.195     0.150
     3.704    59.594     0.150
     3.704   102.297     0.150
     3.754    60.195     0.150
     3.754   103.195     0.150
     3.954    63.195     0.150
     3.954   107.195     0.150
     4.165    69.195     0.150
     4.165   118.195     0.150
     4.165    69.195     0.150
     4.268    70.016     0.150
     4.268   108.727     0.150
     4.268    69.992     0.150
     4.268   108.695     0.150
     4.300    68.195     0.150
     4.300   113.195     0.150
     4.376    66.898     0.150
     4.376   117.695     0.150
     4.434    67.094     0.150
     4.434   117.695     0.150
     4.621    76.195     0.150
     4.621   131.195     0.150
     4.657    71.695     0.150
     4.657   123.898     0.150
     4.705   128.195     0.150
     4.705    73.398     0.150
     4.705   128.195     0.150
     5.262    80.398     0.150
     5.262   139.195     0.150
     5.330    79.992     0.150
     5.330   139.094     0.150
     5.330    79.992     0.150
     5.330   139.094     0.150
     5.305    82.195     0.150
     5.305   139.594     0.150
     5.355    82.797     0.150
     5.355   141.297     0.150
     5.385    82.398     0.150
     5.385   141.992     0.150
     5.427    81.492     0.150
     5.427   140.797     0.150
     5.427    81.492     0.150
     5.427   140.797     0.150
     5.500    82.695     0.150
     5.500   142.398     0.150
     5.519    82.195     0.150
     5.519    82.695     0.150
     5.519   143.297     0.150
     5.611    83.898     0.150
     5.611    83.898     0.150
     5.611   146.492     0.150
     5.611    83.898     0.150
     5.611   146.492     0.150
     5.601    83.695     0.150
     5.601   143.898     0.150
     5.602    85.695     0.150
     5.602   147.898     0.150
     5.601   121.195     0.150
     5.601   121.195     0.150
     5.640   103.195     0.150
     5.640   103.195     0.150
     5.724    85.797     0.150
     5.724   148.398     0.150
     5.724    85.797     0.150
     5.724   148.398     0.150
     5.731   148.938     0.150
     5.731    88.398     0.150
     5.731   148.898     0.150
     5.852    87.695     0.150
     5.852   151.195     0.150
     5.852    87.695     0.150
     5.852   151.195     0.150
     5.869    87.594     0.150
     5.869   151.297     0.150
     5.968   150.242     0.150
     5.968    89.094     0.150
     5.968   156.094     0.150
     5.968    89.094     0.150
     5.968   156.094     0.150
     6.018    91.797     0.150
     6.018   158.297     0.150
     6.048    90.195     0.150
     6.048   155.297     0.150
     6.048    90.195     0.150
     6.048   155.297     0.150
     6.036    90.094     0.150
     6.185    94.898     0.150
     6.185   160.492     0.150
     6.309    93.695     0.150
     6.309   163.195     0.150
     6.476   174.094     0.150
     6.476    98.398     0.150
     6.572   165.492     0.150
     6.594    97.594     0.150
     6.594   165.492     0.150
     6.616    97.898     0.150
     6.566    99.297     0.150
     6.645    95.695     0.150
     6.645   164.492     0.150
     6.645    95.695     0.150
     6.645   164.492     0.150
     6.660   163.156     0.150
     6.660   100.094     0.150
     6.705   100.195     0.150
     6.705   100.195     0.150
     6.753   179.891     0.150
     6.753   102.297     0.150
     6.811   100.594     0.150
     6.811   174.297     0.150
     6.831   105.594     0.150
     6.831   105.594     0.150
     6.831   105.594     0.150
     7.006   101.797     0.150
     7.006   178.898     0.150
     7.054   175.047     0.150
     7.054   106.797     0.150
     7.054   106.797     0.150
     7.054   183.594     0.150
     7.084   105.297     0.150
     7.084   182.695     0.150
     7.315   107.398     0.150
     7.315   107.898     0.150
     7.315   188.992     0.150
     7.328   107.898     0.150
     7.328   186.195     0.150
     7.328   107.898     0.150
     7.328   186.195     0.150
     7.302   109.195     0.150
     7.306   115.195     0.150
     7.422   108.297     0.150
     7.422   108.273     0.150
     7.604   188.000     0.150
     7.604   111.055     0.150
     7.604   111.094     0.150
     7.604   187.992     0.150
     7.700   113.297     0.150
     7.700   195.797     0.150
     7.700   113.297     0.150
     7.700   195.797     0.150
     7.745   113.695     0.150
     7.745   195.297     0.150
     7.745   113.695     0.150
     7.851   114.898     0.150
     7.918   117.992     0.150
     8.100   116.938     0.150
     8.136   118.992     0.150
     8.136   208.492     0.150
     8.304   121.492     0.150
     8.304   211.094     0.150
     8.304   121.492     0.150
     8.304   211.094     0.150
     8.304   121.516     0.150
     8.268   125.992     0.150
     8.268   125.992     0.150
     8.268   125.992     0.150
     8.528   210.195     0.150
     8.528   124.195     0.150
     8.665   126.094     0.150
     8.665   219.094     0.150
     8.665   126.094     0.150
     8.665   219.094     0.150
     8.933   129.992     0.150
     8.933   129.992     0.150
     8.934   129.992     0.150
     8.949   132.195     0.150
     9.001   130.695     0.150
     9.001   227.492     0.150
     9.111   226.125     0.150
     9.111   132.094     0.150
     9.188   133.398     0.150
     9.188   231.695     0.150
     9.188   133.398     0.150
     9.201   133.594     0.150
     9.201   232.094     0.150
     9.201   133.594     0.150
     9.201   232.094     0.150
     9.206   135.195     0.150
     9.295   134.898     0.150
     9.399   134.500     0.150
     9.399   231.492     0.150
     9.413   136.594     0.150
     9.413   235.492     0.150
     9.413   136.594     0.150
     9.616   139.492     0.150
     9.616   241.594     0.150
     9.616   139.492     0.150
     9.652   248.195     0.150
     9.652   140.789     0.150
     9.652   140.797     0.150
     9.652   248.195     0.150
     9.658   243.797     0.150
     9.658   139.695     0.150
     9.658   243.797     0.150
     9.658   139.695     0.150
     9.658   243.797     0.150
     9.752   141.492     0.150
     9.817   141.992     0.150
     9.945   143.898     0.150
    10.027   146.695     0.150
    10.089   153.195     0.150
    10.089   153.195     0.150
    10.273   150.094     0.150
    10.662   155.594     0.150
    10.739   154.695     0.150
    11.022   158.094     0.150
    11.049   160.898     0.150
    11.069   160.195     0.150
    11.072   163.594     0.150
    11.093   162.797     0.150
    11.132   162.094     0.150
    11.159   160.398     0.150
    11.152   163.297     0.150
    11.169   161.992     0.150
    11.182   160.992     0.150
    11.220   161.094     0.150
    11.241   163.594     0.150
    11.315   164.492     0.150
    11.451   165.992     0.150
    11.454   166.297     0.150
    11.454   166.297     0.150
    11.454   166.297     0.150
    11.476   279.094     0.150
    11.476   164.898     0.150
    11.476   279.094     0.150
    11.476   164.898     0.150
    11.476   164.898     0.150
    11.476   279.094     0.150
    11.509   165.398     0.150
    11.551   167.594     0.150
    11.588   167.797     0.150
    11.584   166.992     0.150
    11.849   171.898     0.150
    11.849   171.898     0.150
    11.849   171.898     0.150
    11.970   173.195     0.150
    12.790   180.492     0.150
    12.790   309.898     0.150
    12.790   180.492     0.150
    12.790   309.898     0.150
    12.790   180.492     0.150
    12.790   309.898     0.150
    13.700   331.898     0.150
    13.700   194.797     0.150
    13.700   331.898     0.150
    13.700   194.797     0.150
    13.700   194.797     0.150
    13.700   331.898     0.150
    14.065   197.398     0.150
    14.065   197.398     0.150
    14.065   197.398     0.150
    14.103   198.594     0.150
    14.103   198.594     0.150
    14.263   345.195     0.150
    14.263   200.297     0.150
    14.263   345.195     0.150
    14.263   200.297     0.150
    14.263   345.195     0.150
    14.751   205.797     0.150
    14.751   205.797     0.150
    14.751   205.797     0.150
    14.756   206.094     0.150
    14.756   206.094     0.150
    15.023   363.492     0.150
    15.023   210.594     0.150
    15.023   363.492     0.150
    15.023   210.594     0.150
    15.023   363.492     0.150
    15.039   210.297     0.150
    15.039   210.297     0.150
    15.360   214.695     0.150
    15.360   214.695     0.150
    15.360   214.695     0.150
    15.602   217.898     0.150
    15.602   217.898     0.150
    15.616   218.297     0.150
    15.616   218.297     0.150
    15.627   218.195     0.150
    15.627   218.195     0.150
    15.627   218.195     0.150
    15.801   219.992     0.150
    15.801   219.992     0.150
    15.801   219.992     0.150
    15.824   382.797     0.150
    15.824   221.594     0.150
    15.824   382.797     0.150
    15.824   221.594     0.150
    15.824   221.594     0.150
    15.824   382.797     0.150
    15.888   222.398     0.150
    15.888   222.398     0.150
    16.171   225.195     0.150
    16.171   225.195     0.150
    16.222   226.898     0.150
    16.222   391.898     0.150
    16.222   226.898     0.150
    16.222   391.898     0.150
    16.222   226.898     0.150
    16.222   226.898     0.150
    16.222   391.898     0.150
    16.212   226.094     0.150
    16.212   226.094     0.150
    16.230   392.492     0.150
    16.230   228.094     0.150
    16.230   392.492     0.150
    16.230   228.094     0.150
    16.230   228.094     0.150
    16.230   392.492     0.150
    16.459   229.398     0.150
    16.459   229.398     0.150
    16.456   229.594     0.150
    16.456   229.594     0.150
    16.462   229.398     0.150
    16.462   229.398     0.150
    16.595   400.898     0.150
    16.595   231.398     0.150
    16.595   400.898     0.150
    16.595   231.398     0.150
    16.595   400.898     0.150
    16.758   233.797     0.150
    16.758   233.797     0.150
    16.926   408.797     0.150
    16.926   237.797     0.150
    16.926   237.797     0.150
    16.926   408.797     0.150
    17.022   237.695     0.150
    17.022   237.695     0.150
    17.022   237.695     0.150
    17.039   236.992     0.150
    17.039   236.992     0.150
    17.969   249.695     0.150
    17.969   249.695     0.150
    17.969   249.695     0.150
    18.228   250.594     0.150
    18.228   250.594     0.150
    18.277   254.094     0.150
    18.277   254.094     0.150
    18.277   254.094     0.150
    18.277   254.094     0.150
    18.320   254.594     0.150
    18.320   254.594     0.150
    18.320   254.594     0.150
    18.507   255.797     0.150
    18.764   263.695     0.150
    18.764   263.648     0.150
    18.969   264.695     0.150
    18.969   264.695     0.150
    18.969   264.695     0.150
    19.237   267.195     0.150
    19.334   269.094     0.150
    19.334   269.094     0.150
    19.334   269.094     0.150
    19.330   268.055     0.150
    19.461   269.398     0.150
    19.553   271.695     0.150
    19.553   271.695     0.150
    19.553   271.695     0.150
    19.599   270.977     0.150
    19.869   273.094     0.150
    20.036   275.992     0.150
    20.079   275.398     0.150
    20.098   275.398     0.150
    20.168   274.797     0.150
    20.168   497.141     0.150
    20.168   621.648     0.150
    20.168   276.195     0.150
    20.525   280.898     0.150
    20.885   286.695     0.150
    21.487   292.195     0.150
    21.602   293.094     0.150
    21.816   292.695     0.150
    21.959   297.297     0.150
    21.969   296.195     0.150
    22.096   298.094     0.150
    22.167   297.695     0.150
    22.210   297.898     0.150
    22.297     4.297     0.150
    22.297   544.398     0.150
    22.297   297.867     0.150
    22.547   301.992     0.150
    22.596   302.992     0.150
    22.678   303.398     0.150
    22.719   302.594     0.150
    22.973   307.797     0.150
    23.181   309.719     0.150
    23.338     2.500     0.150
    23.338     5.297     0.150
    23.338   309.297     0.150
    23.338   560.492     0.150
    23.341   311.297     0.150
    23.407     3.000     0.150
    23.407   311.898     0.150
    23.407   561.594     0.150
    23.563   317.195     0.150
    23.563   327.195     0.150
    23.666   312.992     0.150
    23.716     3.000     0.150
    23.716   313.898     0.150
    23.716   568.094     0.150
    23.932   314.195     0.150
    24.391     2.406     0.150
    24.391   319.492     0.150
    24.391   579.797     0.150
    24.442     2.906     0.150
    24.499     2.695     0.150
    24.499   320.297     0.150
    24.592   324.398     0.150
    24.684   325.695     0.150
    24.684   325.695     0.150
    24.708   322.562     0.150
    24.888   325.492     0.150
    25.060     4.094     0.150
    25.060   596.492     0.150
    25.155   327.797     0.150
    25.298   329.195     0.150
    25.619   334.094     0.150
    25.648   334.148     0.150
    25.853   337.797     0.150
    26.664   342.398     0.150
    26.873   344.594     0.150
    27.856   352.695     0.150
    30.780   378.078     0.150
    35.801   420.195     0.150
    41.304   468.734     0.150
    49.849   534.508     0.150
    51.030   543.906     0.150
    57.340   590.555     0.150
    61.882   622.133     0.150
    66.120   649.195     0.150
    66.634   654.688     0.150
    70.950   681.297     0.150
    70.950   681.273     0.150
    74.669   701.789     0.150
    76.025   711.906     0.150
    77.500   719.984     0.150
    77.575   718.453     0.150
    77.779   722.039     0.150
    77.865   721.594     0.150
    77.866   721.914     0.150
    78.097   722.516     0.150
    78.106   722.102     0.150
    78.271   723.164     0.150
    80.080   735.984     0.150
    80.187   733.328     0.150
    80.872     4.594     0.150
    80.872   745.695     0.150
    82.570   746.945     0.150
    84.471   758.398     0.150
    84.977   758.133     0.150
    85.343   761.789     0.150
    85.531   760.727     0.150
    92.706   795.523     0.150
   142.368  1169.570     0.150
   143.560  1173.398     0.150
     1.118    18.234     0.150
     1.118    32.734     0.150
     1.536    26.473     0.150
     1.893    31.973     0.150
     2.021    58.973     0.150
     2.137    35.973     0.150
     2.302    40.973     0.150
     2.302    63.973     0.150
     2.830    48.973     0.150
     2.830    78.973     0.150
     3.591    79.973     0.150
     3.667    59.973     0.150
     3.803    61.973     0.150
     3.778    96.973     0.150
     4.452   112.973     0.150
     4.676   115.973     0.150
     5.000    71.973     0.150
     4.925    77.973     0.150
     4.925    77.973     0.150
     5.198    76.574     0.150
     5.236    76.973     0.150
     5.435    79.672     0.150
     5.576    84.973     0.150
     5.922    86.773     0.150
     6.239    89.574     0.150
     6.239   156.672     0.150
     6.271    90.074     0.150
     6.271   156.574     0.150
     6.604    94.773     0.150
     6.604   164.871     0.150
     6.609    93.871     0.150
     6.609   167.574     0.150
     6.646   169.273     0.150
     6.646    94.871     0.150
     6.646   169.273     0.150
     6.667    95.574     0.150
     6.667   166.473     0.150
     6.857    98.172     0.150
     6.857   171.672     0.150
     6.856    98.074     0.150
     6.856   172.773     0.150
     6.866    97.871     0.150
     6.866   172.973     0.150
     7.219   103.074     0.150
     7.219   181.371     0.150
     7.347   177.871     0.150
     7.347   104.672     0.150
     7.347   182.871     0.150
     7.389   104.871     0.150
     7.389   177.871     0.150
     7.536   196.148     0.150
     7.893   112.672     0.150
     7.917   199.871     0.150
     7.917   112.871     0.150
     7.917   199.871     0.150
     8.248   117.473     0.150
     8.248   207.672     0.150
     8.320   119.273     0.150
     8.320   205.871     0.150
     8.441   120.371     0.150
     8.441   209.273     0.150
     8.854   126.672     0.150
     8.854   219.773     0.150
     8.854   126.371     0.150
     8.854   221.871     0.150
     9.249   131.574     0.150
     9.249   229.172     0.150
     9.435   235.871     0.150
     9.435   135.074     0.150
     9.435   235.871     0.150
     9.715   141.172     0.150
     9.828   139.273     0.150
     9.984   144.172     0.150
     9.984   250.672     0.150
    10.204   144.672     0.150
    10.509   149.074     0.150
    11.012   151.273     0.150
    11.012   266.973     0.150
    11.012   151.273     0.150
    11.012   266.973     0.150
    11.121   152.773     0.150
    11.121   269.473     0.150
    11.121   152.773     0.150
    11.121   269.473     0.150
    11.314   155.574     0.150
    11.314   155.574     0.150
    19.500   618.715     0.150
    21.313    14.000     0.150
    22.316    13.801     0.150
    22.367    13.398     0.150
    23.401     5.602     0.150
    23.434     7.500     0.150
    23.434    14.598     0.150
    23.513   308.871     0.150
    25.391   329.473     0.150
    25.811   332.273     0.150
     0.900    15.742     0.150
     0.900    25.742     0.150
     3.701    53.441     0.150
     3.701    94.242     0.150
     3.734    54.141     0.150
     3.734    94.844     0.150
     4.066    58.844     0.150
     4.066   103.441     0.150
     4.119    60.641     0.150
     4.119   104.844     0.150
     4.180    62.043     0.150
     4.180   106.441     0.150
     4.319   109.141     0.150
     4.326   109.641     0.150
     4.335    62.742     0.150
     4.335   109.543     0.150
     4.681    68.043     0.150
     4.681   119.043     0.150
     4.823   121.344     0.150
     5.451   137.641     0.150
     0.491    10.648     0.150
     0.491    18.648     0.150
     1.046    17.148     0.150
     1.046    30.148     0.150
     1.061    20.648     0.150
     1.670    29.648     0.150
     1.670    49.648     0.150
     1.976    33.648     0.150
     1.976    57.648     0.150
     2.113    34.648     0.150
     2.113    60.648     0.150
     5.568   140.750     0.150
     5.568   140.750     0.150
     5.701    83.250     0.150
     5.701   143.848     0.150
     5.758    84.648     0.150
     5.758   147.047     0.150
     5.758    84.648     0.150
     5.758   147.047     0.150
     5.966    86.750     0.150
     5.966   150.449     0.150
     6.196   156.449     0.150
     6.196   156.449     0.150
     6.424    93.348     0.150
     6.424   161.250     0.150
     6.424    93.348     0.150
     6.424   161.250     0.150
     6.513    94.449     0.150
     6.513   164.250     0.150
     6.671   101.777     0.150
     6.671   166.777     0.150
     0.556    11.938     0.150
     0.556    19.938     0.150
     1.449    27.938     0.150
     1.449    47.938     0.150
     1.567    29.938     0.150
     1.567    49.938     0.150
     1.686    31.938     0.150
     1.686    52.938     0.150
     2.124    34.938     0.150
     2.124    59.938     0.150
     5.317    80.141     0.150
     5.317   138.539     0.150
     5.317    80.141     0.150
     5.317   138.539     0.150
     5.432    81.734     0.150
     5.432   140.734     0.150
     5.432    81.734     0.150
     5.432   140.734     0.150
     5.523    82.336     0.150
     5.523   142.336     0.150
     5.586    84.039     0.150
     5.682    84.734     0.150
     5.682   146.938     0.150
     5.714    85.938     0.150
     5.714   147.234     0.150
     5.714    85.938     0.150
     5.714   147.234     0.150
     5.952    89.734     0.150
     5.952    89.734     0.150
     6.030    89.938     0.150
     6.030   155.234     0.150
     6.109    91.539     0.150
     6.109    91.539     0.150
     6.281    93.734     0.150
     6.583    97.836     0.150
     6.583    97.836     0.150
     6.685    99.141     0.150
     6.685   170.641     0.150
     7.972   116.234     0.150
     7.972   201.039     0.150
     9.085   132.539     0.150
     9.849   143.539     0.150
     0.172     9.528     0.150
     0.172     4.528     0.150
     0.172     9.528     0.150
     0.470    10.528     0.150
     0.470    18.528     0.150
     0.784    16.528     0.150
     0.784    28.528     0.150
     1.158    22.528     0.150
     1.335    25.528     0.150
     1.335    42.528     0.150
     1.434    48.528     0.150
     2.837    45.528     0.150
     2.837    77.528     0.150
     2.956    47.828     0.150
     2.956    81.128     0.150
     4.721    71.428     0.150
     4.839    72.128     0.150
     4.839   125.328     0.150
     4.839    72.128     0.150
     4.839   125.328     0.150
     4.905    73.528     0.150
     4.905   126.729     0.150
     4.905    73.528     0.150
     4.905   126.729     0.150
     4.948    74.628     0.150
     4.948   128.128     0.150
     4.964    74.729     0.150
     4.964   129.229     0.150
     5.129    76.828     0.150
     5.129   132.128     0.150
     5.160   133.168     0.150
     5.160    77.828     0.150
     5.160   133.128     0.150
     5.128    76.729     0.150
     5.128   132.428     0.150
     5.128   134.128     0.150
     5.189    78.229     0.150
     5.189    78.229     0.150
     5.189   135.428     0.150
     5.189    78.229     0.150
     5.189   135.428     0.150
     5.222   134.428     0.150
     5.222   134.428     0.150
     5.244    79.028     0.150
     5.244   135.328     0.150
     5.316    79.148     0.150
     5.316    79.128     0.150
     5.316   137.229     0.150
     5.433    81.128     0.150
     5.433   139.128     0.150
     5.433    81.128     0.150
     5.433   139.128     0.150
     5.473   141.028     0.150
     5.473   141.028     0.150
     5.827   148.928     0.150
     5.986    88.328     0.150
     5.986   153.528     0.150
     6.028   154.128     0.150
     6.028   154.128     0.150
     6.712    98.928     0.150
     6.712    98.928     0.150
     7.146   105.328     0.150
     8.338   121.328     0.150
     0.605    24.535     0.150
     0.605    13.535     0.150
     0.605    24.535     0.150
     0.748    15.535     0.150
     0.748    26.535     0.150
     0.963    19.535     0.150
     0.963    32.535     0.150
     1.152    20.535     0.150
     1.152    36.535     0.150
     1.657    29.535     0.150
     1.657    46.535     0.150
     3.903    99.135     0.150
     3.978   101.535     0.150
     4.031    60.635     0.150
     4.031   102.936     0.150
     4.093   105.535     0.150
     4.360    64.635     0.150
     4.360   112.235     0.150
     4.549    67.835     0.150
     4.549   117.936     0.150
     4.658    68.735     0.150
     4.658   120.735     0.150
     5.112    75.035     0.150
     0.295     5.922     0.150
     0.295    11.422     0.150
     0.303    14.422     0.150
     0.303     7.422     0.150
     0.303    14.422     0.150
     1.214    24.422     0.150
     1.214    42.422     0.150
     1.795    33.422     0.150
     1.795    53.422     0.150
     2.005    60.422     0.150
     2.005    36.422     0.150
     2.005    60.422     0.150
     2.302    39.422     0.150
     2.302    65.422     0.150
     5.133    77.822     0.150
     5.133   133.022     0.150
     5.133    77.822     0.150
     5.133   133.022     0.150
     5.242    79.322     0.150
     5.242   134.922     0.150
     5.242    79.322     0.150
     5.242   134.922     0.150
     5.387    81.522     0.150
     5.387   140.122     0.150
     5.387    81.522     0.150
     5.387   140.122     0.150
     5.468    81.822     0.150
     5.468   141.222     0.150
     5.874    87.822     0.150
     5.874    87.822     0.150
     5.901    88.422     0.150
     5.901   152.022     0.150
     5.901    88.422     0.150
     5.901   152.022     0.150
     6.000    88.822     0.150
     6.000   154.522     0.150
     6.104    91.022     0.150
     6.475    96.222     0.150
     6.475   165.822     0.150
     0.535    11.703     0.150
     0.535    20.703     0.150
     0.535    11.703     0.150
     0.535    20.703     0.150
     0.589    12.203     0.150
     0.589    21.703     0.150
     1.302    22.703     0.150
     1.302    38.703     0.150
     1.302    22.703     0.150
     1.302    22.703     0.150
     1.302    38.703     0.150
     1.509    28.203     0.150
     1.509    47.703     0.150
     1.509    28.203     0.150
     1.509    47.703     0.150
     1.868    32.703     0.150
     1.868    56.703     0.150
     1.868    32.703     0.150
     1.868    56.703     0.150
     2.144    38.703     0.150
     2.144    64.703     0.150
     2.144    37.514     0.150
     2.144    60.043     0.150
     2.144    68.104     0.150
     2.178    36.703     0.150
     2.178    62.703     0.150
     2.487    43.703     0.150
     2.487    71.703     0.150
     2.525    41.703     0.150
     2.525    70.703     0.150
     3.364    54.703     0.150
     3.364    93.703     0.150
     3.506    56.703     0.150
     3.506    95.703     0.150
     3.776   103.703     0.150
     3.776    59.703     0.150
     3.776   103.703     0.150
     3.955    62.703     0.150
     3.955   107.703     0.150
     4.321    67.402     0.150
     4.361    68.303     0.150
     4.361   117.703     0.150
     4.462    72.764     0.150
     4.507    70.004     0.150
     4.523    70.004     0.150
     4.523   122.504     0.150
     4.819    73.004     0.150
     4.900   124.014     0.150
     4.900    72.604     0.150
     4.900   124.004     0.150
     4.910    74.504     0.150
     4.910   128.703     0.150
     5.495    81.303     0.150
     5.495   140.604     0.150
     5.495    81.303     0.150
     5.495   140.604     0.150
     5.598    82.803     0.150
     5.598   141.902     0.150
     5.598    82.803     0.150
     5.666    83.600     0.150
     5.666    83.604     0.150
     5.666   145.703     0.150
     5.666    83.664     0.150
     5.763    84.803     0.150
     5.763   146.104     0.150
     5.763    84.803     0.150
     5.814    89.309     0.150
     5.891    86.803     0.150
     5.891   149.803     0.150
     5.891    86.803     0.150
     5.891   149.803     0.150
     5.945   157.078     0.150
     6.005    88.303     0.150
     6.005    88.303     0.150
     6.005   152.902     0.150
     6.228    91.402     0.150
     6.233    91.504     0.150
     6.233   159.402     0.150
     6.297   107.703     0.150
     6.471    94.703     0.150
     6.471   164.504     0.150
     6.537   111.703     0.150
     6.745   172.803     0.150
     6.745    98.803     0.150
     6.745   172.803     0.150
     6.751   108.703     0.150
     6.751   108.703     0.150
     6.875   106.504     0.150
     6.875   106.504     0.150
     7.011   110.004     0.150
     7.011   110.004     0.150
     7.212   105.803     0.150
     7.212   183.604     0.150
     7.306   187.703     0.150
     7.306   106.803     0.150
     7.306   187.703     0.150
     7.286   112.803     0.150
     7.301   112.803     0.150
     7.513   109.104     0.150
     7.488   115.902     0.150
     7.632   110.123     0.150
     7.632   110.104     0.150
     7.632   191.004     0.150
     7.814   190.027     0.150
     7.814   112.572     0.150
     7.814   112.973     0.150
     7.851   112.303     0.150
     7.873   200.402     0.150
     7.873   114.303     0.150
     7.873   200.402     0.150
     7.929   114.902     0.150
     7.944   110.553     0.150
     8.309   213.004     0.150
     8.309   120.203     0.150
     8.309   213.004     0.150
     8.440   123.803     0.150
     8.440   123.803     0.150
     8.440   123.803     0.150
     8.489   214.104     0.150
     8.489   122.674     0.150
     8.489   214.004     0.150
     8.773   129.004     0.150
     8.773   129.004     0.150
     8.787   119.703     0.150
     8.787   119.703     0.150
     8.847   127.303     0.150
     9.054   131.303     0.150
     9.054   131.303     0.150
     9.054   131.303     0.150
     9.192   132.504     0.150
     9.192   232.004     0.150
     9.283   135.004     0.150
     9.283   135.004     0.150
     9.325   227.941     0.150
     9.373   236.504     0.150
     9.373   134.604     0.150
     9.373   236.504     0.150
     9.358   134.703     0.150
     9.480   136.104     0.150
     9.600   140.004     0.150
     9.600   140.004     0.150
     9.810   140.902     0.150
     9.810   246.504     0.150
     9.842   141.004     0.150
    10.127   145.402     0.150
    11.669   166.303     0.150
    11.690   167.203     0.150
    12.063   171.203     0.150
    13.004   183.703     0.150
    13.192   189.713     0.150
    13.658   348.703     0.150
    13.658   348.674     0.150
    13.658   194.303     0.150
    13.658   348.703     0.150
    13.914   194.004     0.150
    14.317   201.004     0.150
    14.464   206.482     0.150
    14.957   208.504     0.150
    15.188   211.703     0.150
    15.574   216.303     0.150
    16.015   223.803     0.150
    16.032   223.104     0.150
    16.296   236.703     0.150
    16.430   228.803     0.150
    16.437   229.703     0.150
    16.674   231.504     0.150
    16.672   232.504     0.150
    16.806   234.504     0.150
    16.972   235.303     0.150
    17.138   239.104     0.150
    17.234   239.104     0.150
    17.234   239.104     0.150
    17.252   239.203     0.150
    17.252   239.203     0.150
    17.544   246.703     0.150
    17.575     3.471     0.150
    18.443   257.402     0.150
    18.443   257.402     0.150
    18.443   257.402     0.150
    18.476   257.113     0.150
    18.491   257.504     0.150
    18.491   257.504     0.150
    18.533   258.303     0.150
    18.533   258.303     0.150
    18.721   260.303     0.150
    19.160   266.523     0.150
    19.182   265.902     0.150
    19.182   265.902     0.150
    19.253   266.062     0.150
    19.549   269.504     0.150
    19.549   269.504     0.150
    19.543   269.514     0.150
    19.543   269.504     0.150
    19.694   271.604     0.150
    19.729   269.604     0.150
    19.729     4.330     0.150
    19.768   271.803     0.150
    19.768   271.803     0.150
    19.813   272.854     0.150
    19.813   272.902     0.150
    20.010   274.004     0.150
    20.007   273.014     0.150
    20.012   273.123     0.150
    20.193   277.004     0.150
    20.578   279.402     0.150
    20.639     3.740     0.150
    20.639   280.703     0.150
    20.990   285.014     0.150
    21.759   300.043     0.150
    21.814   294.783     0.150
    21.814   294.803     0.150
    22.021   294.004     0.150
    22.375   298.924     0.150
    22.375   298.902     0.150
    22.506     3.900     0.150
    22.506   300.104     0.150
    22.506   300.104     0.150
    22.506   304.004     0.150
    22.751   303.703     0.150
    22.751   303.703     0.150
    22.922   303.203     0.150
    23.547     1.701     0.150
    23.547   309.803     0.150
    23.547   309.803     0.150
    23.616   311.104     0.150
    23.616   311.104     0.150
    23.616   316.004     0.150
    23.775   327.703     0.150
    23.775   331.703     0.150
    23.775   316.703     0.150
    23.926   318.303     0.150
    24.138   316.104     0.150
    24.138   316.104     0.150
    24.600     5.000     0.150
    24.600   319.604     0.150
    24.600   319.604     0.150
    24.600   324.604     0.150
    24.886   323.803     0.150
    24.886   323.803     0.150
    24.886   323.803     0.150
    24.914   323.203     0.150
    24.914   323.203     0.150
    24.914   323.104     0.150
    25.266   329.902     0.150
    25.219   326.902     0.150
    25.219   326.924     0.150
    25.219   326.902     0.150
    25.329   329.604     0.150
    25.778   334.402     0.150
    26.263   338.084     0.150
    27.623   352.402     0.150
    27.623     1.111     0.150
    28.040   353.004     0.150
    28.040   352.973     0.150
    28.040   353.203     0.150
    28.289   354.953     0.150
    28.291   354.902     0.150
    32.739   392.854     0.150
    36.015   420.254     0.150
    36.015   420.303     0.150
    37.645   443.902     0.150
    39.854   467.004     0.150
    50.051   708.604     0.150
    50.051  1263.902     0.150
    57.107   589.543     0.150
    57.107   589.604     0.150
    61.020   612.014     0.150
    61.020     1.650     0.150
    62.690   625.293     0.150
    62.690   625.303     0.150
    64.704     4.301     0.150
    64.704     6.900     0.150
    65.215   641.354     0.150
    65.216   641.854     0.150
    66.311   649.584     0.150
    66.327   649.533     0.150
    70.096   671.254     0.150
    77.665   718.732     0.150
    77.665   718.703     0.150
    77.944   718.723     0.150
    77.944   718.803     0.150
    77.944   718.652     0.150
    78.845   723.703     0.150
    78.845   724.254     0.150
    79.686   729.303     0.150
    80.054   731.623     0.150
    80.057   730.844     0.150
    80.391   731.793     0.150
    80.391     4.740     0.150
    80.453   734.174     0.150
    80.993   736.254     0.150
    80.993   736.303     0.150
    84.520   752.803     0.150
    84.520   752.793     0.150
    84.520   752.803     0.150
    84.520   756.604     0.150
    87.335    10.000     0.150
    88.620   772.604     0.150
   142.477  1173.883     0.150
     0.627    13.117     0.150
     0.627    22.117     0.150
     0.669    15.117     0.150
     0.669    24.117     0.150
     1.169    24.117     0.150
     1.169    41.117     0.150
     1.161    23.117     0.150
     1.161    40.117     0.150
     1.455    29.117     0.150
     1.455    48.117     0.150
     2.000    35.117     0.150
     2.000    62.117     0.150
     2.627    43.117     0.150
     2.627    73.117     0.150
     5.699    85.414     0.150
     5.798    86.016     0.150
     6.057    88.977     0.150
     6.057    89.016     0.150
     6.813   100.320     0.150
     0.457    10.505     0.150
     0.457    16.505     0.150
     0.645    13.505     0.150
     0.645    23.505     0.150
     0.789    16.005     0.150
     0.789    27.505     0.150
     0.976    19.505     0.150
     0.976    32.505     0.150
     1.129    21.505     0.150
     1.129    38.505     0.150
     2.614    44.505     0.150
     2.614    72.505     0.150
     3.137    50.505     0.150
     3.137    86.505     0.150
     5.227    78.305     0.150
     5.227   134.205     0.150
     5.262    79.005     0.150
     5.262   135.205     0.150
     5.445    79.595     0.150
     5.445    79.604     0.150
     5.445   139.405     0.150
     6.284    93.005     0.150
     6.284   159.104     0.150
     0.542    11.830     0.150
     0.542    18.830     0.150
     0.768    17.830     0.150
     0.768    30.830     0.150
     0.768    17.830     0.150
     0.768    30.830     0.150
     0.915    19.330     0.150
     0.915    30.830     0.150
     1.199    24.830     0.150
     1.199    42.830     0.150
     0.807    25.830     0.150
     0.807    16.330     0.150
     0.807    25.830     0.150
     2.656    44.830     0.150
     2.656    77.830     0.150
     3.215    53.830     0.150
     3.400    56.430     0.150
     4.070    63.631     0.150
     4.070   109.029     0.150
     4.403    69.230     0.150
     4.403   118.730     0.150
     4.681    75.900     0.150
     4.681    75.930     0.150
     4.681   127.430     0.150
     4.765    75.529     0.150
     4.765   129.529     0.150
     4.871    76.930     0.150
     4.871   134.529     0.150
     5.265    80.330     0.150
     5.265   138.230     0.150
     5.265    80.330     0.150
     5.265   138.230     0.150
     5.336    81.230     0.150
     5.336   139.830     0.150
     5.336    81.230     0.150
     5.336   139.830     0.150
     5.384    82.230     0.150
     5.384   140.631     0.150
     5.261    82.631     0.150
     5.409    82.131     0.150
     5.409   141.131     0.150
     5.534    84.311     0.150
     5.534    84.330     0.150
     5.534   145.529     0.150
     5.602   143.250     0.150
     5.602    85.029     0.150
     5.602    85.029     0.150
     5.602    85.029     0.150
     5.572    84.631     0.150
     5.572   145.029     0.150
     5.651    85.830     0.150
     5.651   147.131     0.150
     5.651    85.830     0.150
     5.651   147.131     0.150
     5.558   152.707     0.150
     5.558    88.029     0.150
     5.558   152.730     0.150
     5.678    86.330     0.150
     5.678   149.529     0.150
     5.836    88.430     0.150
     5.836   152.430     0.150
     5.836    88.430     0.150
     5.836   152.430     0.150
     5.877    88.830     0.150
     5.877   153.730     0.150
     5.877    88.830     0.150
     5.877   153.730     0.150
     5.901   150.580     0.150
     5.901    89.131     0.150
     5.901   153.230     0.150
     5.901    89.131     0.150
     5.901   153.230     0.150
     5.954    89.830     0.150
     5.954   154.930     0.150
     5.954    89.830     0.150
     5.954   154.930     0.150
     6.253    93.830     0.150
     6.253   162.131     0.150
     6.214    94.830     0.150
     6.431    96.430     0.150
     6.431   166.730     0.150
     6.464    96.930     0.150
     6.464    96.930     0.150
     6.796   104.131     0.150
     7.023   104.631     0.150
     7.023   181.430     0.150
     7.156   106.631     0.150
     7.156   184.330     0.150
     7.156   106.631     0.150
     7.156   184.330     0.150
     7.209   106.730     0.150
     7.209   106.730     0.150
     7.209   106.730     0.150
     7.227   180.568     0.150
     7.227   107.631     0.150
     7.227   180.529     0.150
     7.586   112.430     0.150
     7.586   112.430     0.150
     7.592   112.131     0.150
     7.592   192.930     0.150
     8.015   118.430     0.150
     8.124   120.131     0.150
     8.124   207.230     0.150
     8.124   120.131     0.150
     8.124   207.230     0.150
     8.170   120.930     0.150
     8.170   208.230     0.150
     8.785   128.992     0.150
     8.785   129.029     0.150
     8.785   221.930     0.150
     8.785   223.730     0.150
     9.113   133.730     0.150
     9.113   231.430     0.150
     9.380   137.131     0.150
     9.380   137.131     0.150
     9.515   138.730     0.150
     9.515   239.330     0.150
     9.641   140.930     0.150
     9.641   243.131     0.150
    10.552   153.730     0.150
    10.788   157.631     0.150
    10.868   158.029     0.150
    10.802   157.830     0.150
    10.930   158.631     0.150
     0.483    10.484     0.150
     0.483    17.484     0.150
     0.587    12.984     0.150
     0.587    21.484     0.150
     1.097    34.484     0.150
     1.097    21.484     0.150
     1.097    34.484     0.150
     1.232    23.484     0.150
     1.232    40.484     0.150
     1.993    35.484     0.150
     1.993    57.484     0.150
     2.583    42.484     0.150
     2.583    71.484     0.150
     4.497    66.684     0.150
     4.497   119.084     0.150
     5.321    80.084     0.150
     5.321   140.984     0.150
     5.388    79.684     0.150
     5.388   138.885     0.150
     5.388    79.684     0.150
     5.388   138.885     0.150
     5.486    81.285     0.150
     5.486   140.484     0.150
     5.486    81.285     0.150
     5.486   140.484     0.150
     5.559    82.385     0.150
     5.559   142.184     0.150
     5.573   140.395     0.150
     5.573    82.184     0.150
     5.573   143.285     0.150
     5.663    82.885     0.150
     5.663   144.385     0.150
     5.666    83.684     0.150
     5.666    83.684     0.150
     5.666   145.084     0.150
     5.666    83.684     0.150
     5.666   145.084     0.150
     5.783   148.084     0.150
     5.783   148.084     0.150
     5.907    86.984     0.150
     5.907   151.084     0.150
     5.907    86.984     0.150
     5.907   151.084     0.150
     5.932    87.385     0.150
     5.932   151.285     0.150
     6.026    88.684     0.150
     6.026    88.684     0.150
     6.026   154.385     0.150
     6.026    88.684     0.150
     6.026   154.385     0.150
     6.079    90.584     0.150
     6.109    89.885     0.150
     6.109   156.285     0.150
     6.109    89.885     0.150
     6.109   156.285     0.150
     6.099    89.785     0.150
     6.099   155.584     0.150
     6.115    89.885     0.150
     6.115   155.785     0.150
     6.115    89.885     0.150
     6.115   155.785     0.150
     6.366    93.084     0.150
     6.366   160.885     0.150
     6.632    97.285     0.150
     6.632   168.584     0.150
     6.632    97.285     0.150
     6.632   168.584     0.150
     6.678    97.885     0.150
     6.678   170.785     0.150
     7.193   105.184     0.150
     7.389   107.584     0.150
     7.389   187.084     0.150
     7.389   107.584     0.150
     7.389   187.084     0.150
     7.667   110.785     0.150
     7.759   113.184     0.150
     7.759   113.184     0.150
     7.914   114.785     0.150
     9.063   130.885     0.150
     9.063   227.385     0.150
     9.814   141.084     0.150
     0.336     7.789     0.150
     0.336    12.789     0.150
     0.641    13.289     0.150
     0.641    21.789     0.150
     1.117    21.789     0.150
     1.117    35.789     0.150
     1.178    24.789     0.150
     1.178    24.789     0.150
     1.178    40.789     0.150
     1.293    25.789     0.150
     1.293    25.789     0.150
     1.293    41.789     0.150
     1.605    29.789     0.150
     1.605    49.789     0.150
     2.678    43.789     0.150
     2.678    74.789     0.150
     5.000    74.590     0.150
     5.000   129.789     0.150
     5.000    74.590     0.150
     5.000   129.789     0.150
     5.050    75.488     0.150
     5.050   131.688     0.150
     5.084    76.090     0.150
     5.084   133.188     0.150
     5.197    77.691     0.150
     5.197    77.688     0.150
     5.197   134.391     0.150
     5.197   134.789     0.150
     5.264    78.289     0.150
     5.264   136.188     0.150
     5.264    78.289     0.150
     5.264   136.188     0.150
     5.271    78.488     0.150
     5.271   136.688     0.150
     5.314    79.688     0.150
     5.314   136.891     0.150
     5.314    79.688     0.150
     5.314   136.891     0.150
     5.396   140.090     0.150
     5.549    82.688     0.150
     5.549   142.289     0.150
     5.549    82.688     0.150
     5.564    82.391     0.150
     5.564   144.391     0.150
     5.564    82.391     0.150
     5.564   144.391     0.150
     5.916    87.090     0.150
     5.916   152.488     0.150
     6.106    89.988     0.150
     6.106   156.590     0.150
     6.829   100.188     0.150
     6.829   100.188     0.150
     0.407    19.140     0.150
     3.313    53.440     0.150
     3.313    91.240     0.150
     3.752    58.940     0.150
     3.752   101.240     0.150
     3.879    61.540     0.150
     3.879   105.740     0.150
     3.913    60.840     0.150
     3.913   106.840     0.150
     4.051    63.340     0.150
     4.051   109.540     0.150
     4.721    73.140     0.150
     4.721   125.240     0.150
     4.817    74.140     0.150
     4.817   126.340     0.150
     4.817    74.140     0.150
     4.817   126.340     0.150
     4.810    72.740     0.150
     4.810   124.640     0.150
     4.856    73.240     0.150
     4.856   126.440     0.150
     4.856    73.240     0.150
     4.856   126.440     0.150
     4.873    73.540     0.150
     4.873   126.140     0.150
     4.862    73.840     0.150
     4.862   127.140     0.150
     4.911    75.040     0.150
     4.911   128.840     0.150
     5.186    78.740     0.150
     5.186   134.740     0.150
     5.186    78.740     0.150
     5.186   134.740     0.150
     5.151    79.040     0.150
     5.151   135.740     0.150
     5.162    78.040     0.150
     5.295    80.140     0.150
     5.295   136.340     0.150
     5.295    80.140     0.150
     5.295   136.340     0.150
     5.439    83.240     0.150
     5.439    83.240     0.150
     5.439   140.640     0.150
     5.439    83.240     0.150
     5.439   140.640     0.150
     5.439    82.240     0.150
     5.439   141.540     0.150
     5.439    82.240     0.150
     5.439   141.540     0.150
     5.354    81.840     0.150
     5.450   141.140     0.150
     5.450   141.140     0.150
     5.800    87.340     0.150
     5.800   150.140     0.150
     5.828    87.040     0.150
     5.828   149.040     0.150
     5.947    88.840     0.150
     5.947   153.540     0.150
     5.947    88.840     0.150
     5.947   153.540     0.150
     5.939    90.440     0.150
     6.101    91.440     0.150
     6.101   157.240     0.150
     6.438   165.840     0.150
     6.560    97.340     0.150
     6.560   167.840     0.150
     6.560    97.340     0.150
     6.560   167.840     0.150
     6.904   101.240     0.150
     8.132   118.440     0.150
     0.783    15.584     0.150
     0.783    29.584     0.150
     1.259    24.584     0.150
     1.259    24.584     0.150
     1.259    42.584     0.150
     1.380    25.584     0.150
     1.380    44.584     0.150
     1.243    23.584     0.150
     1.820    32.584     0.150
     1.820    57.584     0.150
     2.186    37.385     0.150
     2.320    37.484     0.150
     2.320    66.684     0.150
     2.365    40.584     0.150
     2.365    68.584     0.150
     2.347    39.584     0.150
     2.977    48.783     0.150
     3.242    53.994     0.150
     3.242    92.961     0.150
     3.242    53.984     0.150
     3.693    55.984     0.150
     3.693    96.684     0.150
     3.693    55.984     0.150
     3.693    96.684     0.150
     3.682    56.484     0.150
     3.682    97.184     0.150
     3.725    54.684     0.150
     3.725    54.684     0.150
     3.725    96.885     0.150
     3.725    54.684     0.150
     3.725    96.885     0.150
     3.737    56.084     0.150
     3.737    98.184     0.150
     3.777    59.584     0.150
     3.777   100.584     0.150
     3.801    57.783     0.150
     3.801   100.684     0.150
     4.011    62.584     0.150
     4.011   106.584     0.150
     3.935    62.484     0.150
     4.057   106.084     0.150
     4.057   106.084     0.150
     4.092   108.283     0.150
     4.164    61.984     0.150
     4.164   108.184     0.150
     4.164    61.984     0.150
     4.164   108.184     0.150
     4.310    62.773     0.150
     4.310   108.584     0.150
     4.310    62.773     0.150
     4.310    64.484     0.150
     4.310   108.584     0.150
     4.310   111.385     0.150
     4.310    64.484     0.150
     4.310   111.385     0.150
     4.329   112.184     0.150
     4.329   112.184     0.150
     4.672    69.184     0.150
     4.672   120.084     0.150
     4.703    69.783     0.150
     4.703   120.484     0.150
     0.321     6.711     0.150
     0.321    11.711     0.150
     0.321     6.711     0.150
     0.321    11.711     0.150
     1.021    20.910     0.150
     1.021    35.711     0.150
     1.064    34.211     0.150
     1.064    23.211     0.150
     1.064    34.211     0.150
     1.064    23.211     0.150
     1.064    34.211     0.150
     1.421    27.211     0.150
     1.421    45.211     0.150
     1.421    27.211     0.150
     1.421    45.211     0.150
     1.507    52.211     0.150
     1.507    30.211     0.150
     1.507    30.211     0.150
     1.507    52.211     0.150
     1.801    31.211     0.150
     1.801    55.211     0.150
     1.801    31.211     0.150
     1.801    55.211     0.150
     2.616    44.211     0.150
     2.616    76.211     0.150
     2.616    44.211     0.150
     2.616    76.211     0.150
     2.979    48.211     0.150
     2.979    82.211     0.150
     2.979    48.211     0.150
     2.979    82.211     0.150
     3.063    50.211     0.150
     3.063    86.211     0.150
     3.063    50.211     0.150
     3.063    86.211     0.150
     3.491    93.910     0.150
     3.491    93.910     0.150
     3.588    96.012     0.150
     3.588    96.012     0.150
     3.666    57.512     0.150
     3.666    97.811     0.150
     3.786   101.512     0.150
     3.786   101.512     0.150
     3.809    60.471     0.150
     3.809    60.512     0.150
     3.809   100.811     0.150
     3.885   103.211     0.150
     3.885   103.211     0.150
     4.201    65.012     0.150
     4.237    66.111     0.150
     4.237   111.711     0.150
     4.237    66.111     0.150
     4.237   111.711     0.150
     4.471    68.410     0.150
     4.471   117.910     0.150
     4.476    68.811     0.150
     4.476   118.111     0.150
     4.731    72.910     0.150
     4.731   124.611     0.150
     4.812    72.711     0.150
     4.812   124.711     0.150
     5.514   143.512     0.150
     5.514   143.512     0.150
     1.634    50.328     0.150
     5.376    79.727     0.150
     5.376   138.031     0.150
     5.488    81.125     0.150
     5.488   141.125     0.150
     5.514    82.430     0.150
     5.773    85.531     0.150
     5.773   147.828     0.150
     6.154    90.727     0.150
     6.154   157.227     0.150
     6.343    92.727     0.150
     6.343   161.531     0.150
     6.900   100.727     0.150
     7.198   104.828     0.150
     0.391     8.387     0.150
     0.391    13.887     0.150
     1.386    25.887     0.150
     1.386    45.887     0.150
     1.783    32.887     0.150
     1.783    55.887     0.150
     2.554    42.887     0.150
     2.554    74.887     0.150
     2.940    81.387     0.150
     2.961    48.086     0.150
     2.961    82.586     0.150
     2.989    49.887     0.150
     2.989    85.887     0.150
     3.533    56.988     0.150
     3.533    56.988     0.150
     3.533    94.285     0.150
     3.533    56.988     0.150
     3.533    94.285     0.150
     3.627    97.188     0.150
     3.701    58.387     0.150
     3.701    99.188     0.150
     3.760   100.086     0.150
     3.760   102.688     0.150
     3.833    60.387     0.150
     3.833   102.785     0.150
     3.926   105.387     0.150
     3.926   105.387     0.150
     4.073   108.285     0.150
     4.073   108.285     0.150
     4.207    68.355     0.150
     4.207    68.387     0.150
     4.207   111.285     0.150
     4.265    66.086     0.150
     4.265   113.387     0.150
     4.265    66.086     0.150
     4.265   113.387     0.150
     4.473    69.586     0.150
     4.473   118.285     0.150
     4.515    69.285     0.150
     4.515   117.688     0.150
     4.709   124.887     0.150
     4.838    73.688     0.150
     4.838   127.387     0.150
     5.334    78.887     0.150
     5.334    78.887     0.150
     5.334   137.488     0.150
     5.543   142.688     0.150
     5.543   142.688     0.150
     2.815    44.525     0.150
     2.815    74.525     0.150
     3.208    48.525     0.150
     3.208    80.525     0.150
     4.718    73.326     0.150
     4.718   125.326     0.150
     4.754    74.125     0.150
     4.754   125.426     0.150
     5.110    78.525     0.150
     5.110   134.326     0.150
     5.174    79.326     0.150
     5.174   135.125     0.150
     5.244    80.125     0.150
     5.244   136.926     0.150
     5.298   137.076     0.150
     5.298    80.826     0.150
     5.298   137.076     0.150
     5.298    81.326     0.150
     5.298   137.025     0.150
     5.353    81.725     0.150
     5.353   140.326     0.150
     5.507   143.926     0.150
     5.544    84.725     0.150
     5.544   146.725     0.150
     5.571    84.525     0.150
     5.571   144.225     0.150
     5.875    91.326     0.150
     5.875    91.326     0.150
     5.875   153.326     0.150
     5.975    90.125     0.150
     5.975   154.326     0.150
     6.004    90.525     0.150
     6.004   155.326     0.150
     6.053   156.326     0.150
     6.053    91.525     0.150
     6.053   156.326     0.150
     6.271   160.787     0.150
     6.271    94.225     0.150
     6.271   160.826     0.150
     6.391    96.225     0.150
     6.391   165.326     0.150
     6.554    97.926     0.150
     6.554   167.926     0.150
     6.687   100.125     0.150
     6.687   172.326     0.150
     6.947   103.826     0.150
     6.947   179.426     0.150
     7.018   106.225     0.150
     7.018   106.344     0.150
     7.018   177.428     0.150
     7.018   106.225     0.150
     7.235   107.426     0.150
     7.235   185.426     0.150
     7.511   111.525     0.150
     8.960   131.725     0.150
     8.960   227.426     0.150
     1.284    22.040     0.150
     1.284    38.040     0.150
     2.852    80.440     0.150
     3.005    82.840     0.150
     3.528    56.540     0.150
     3.528    96.140     0.150
     3.765   101.740     0.150
     3.765   101.740     0.150
     3.890    62.194     0.150
     3.890    62.240     0.150
     3.890   103.940     0.150
     3.953    62.740     0.150
     3.953   105.740     0.150
     4.051    63.740     0.150
     4.051   109.040     0.150
     4.110    64.340     0.150
     4.110   110.540     0.150
     4.110    64.340     0.150
     4.110   110.540     0.150
     4.151   111.840     0.150
     4.151   111.840     0.150
     4.226    66.140     0.150
     4.226   111.940     0.150
     4.342    67.940     0.150
     4.342   115.740     0.150
     4.342    67.940     0.150
     4.342   115.740     0.150
     4.407    68.940     0.150
     4.407   116.540     0.150
     4.407    68.940     0.150
     4.407   116.540     0.150
     4.431    68.840     0.150
     4.431   117.340     0.150
     4.555    71.640     0.150
     4.555   120.840     0.150
     4.753    73.440     0.150
     4.753   126.040     0.150
     4.970    76.140     0.150
     4.970   130.540     0.150
     4.970    76.140     0.150
     4.970   130.540     0.150
     4.971    76.040     0.150
     4.971   129.040     0.150
     5.045   132.940     0.150
     5.045   132.940     0.150
     5.184   135.640     0.150
     5.530   144.440     0.150
     5.689    86.040     0.150
     5.689   147.040     0.150
     5.689    86.040     0.150
     5.689   147.040     0.150
     5.775    87.440     0.150
     5.811    88.740     0.150
     5.811   148.940     0.150
     4.401    66.598     0.150
     4.401   116.298     0.150
     4.949    75.798     0.150
     4.949   131.098     0.150
     5.482    81.098     0.150
     5.482   140.798     0.150
     5.579    82.397     0.150
     5.579   144.198     0.150
     5.710    86.198     0.150
     5.841    84.049     0.150
     5.841    84.098     0.150
     5.841   149.098     0.150
     5.954    85.268     0.150
     5.954   149.948     0.150
     5.954    85.268     0.150
     5.954   149.948     0.150
     6.003    87.698     0.150
     6.003   153.598     0.150
     6.594    96.397     0.150
     6.594   168.498     0.150
     6.792   175.298     0.150
     7.303   105.434     0.150
     7.303   105.397     0.150
     7.390   107.198     0.150
     8.978   128.798     0.150
     0.896    32.742     0.150
     1.957    45.844     0.150
     1.957    83.941     0.150
     2.640    42.941     0.150
     2.640    74.844     0.150
     3.273    51.941     0.150
     3.273    92.344     0.150
     3.758    57.543     0.150
     3.758    98.441     0.150
     3.758    57.543     0.150
     3.758    98.441     0.150
     3.390    98.844     0.150
     3.813    57.543     0.150
     3.813    99.641     0.150
     3.813    57.543     0.150
     3.813    99.641     0.150
     3.849    58.242     0.150
     3.849   100.543     0.150
     3.860    58.043     0.150
     3.860   101.844     0.150
     4.066    62.742     0.150
     4.066   106.344     0.150
     4.094    64.641     0.150
     4.094    64.641     0.150
     4.094   107.844     0.150
     4.136   107.844     0.150
     4.136   107.844     0.150
     4.137    63.941     0.150
     4.137   109.941     0.150
     4.137    63.941     0.150
     4.137   109.941     0.150
     4.328    65.043     0.150
     4.328   112.441     0.150
     4.328    65.043     0.150
     4.328   112.441     0.150
     4.363    66.941     0.150
     4.363   113.242     0.150
     4.363    66.941     0.150
     4.363   113.242     0.150
     4.388   114.742     0.150
     4.388   114.742     0.150
     4.746    71.043     0.150
     4.746   122.844     0.150
     4.882    73.141     0.150
     4.882   126.543     0.150
     4.929    74.043     0.150
     4.929   127.242     0.150
     4.929    74.043     0.150
     4.929   127.242     0.150
     5.118    77.043     0.150
     5.118   131.844     0.150
     5.607    83.043     0.150
     5.607   143.742     0.150
     5.607    83.043     0.150
     5.607   143.742     0.150
     5.620    82.641     0.150
     5.620   142.043     0.150
     5.807    86.242     0.150
     5.807   148.742     0.150
     6.021   154.141     0.150
     6.021   154.141     0.150
     6.064    89.242     0.150
     6.064   154.543     0.150
     0.694    12.648     0.150
     0.694    20.547     0.150
     1.258    27.750     0.150
     1.258    51.250     0.150
     1.628    82.047     0.150
     2.903    46.945     0.150
     2.903    81.148     0.150
     3.459    55.547     0.150
     3.459    94.047     0.150
     4.138    64.750     0.150
     4.138   108.547     0.150
     4.138    64.750     0.150
     4.138   108.547     0.150
     4.191    65.352     0.150
     4.191   111.445     0.150
     4.191    65.352     0.150
     4.191   111.445     0.150
     4.216    65.250     0.150
     4.216   111.547     0.150
     4.222    65.648     0.150
     4.222   110.547     0.150
     4.377    67.547     0.150
     4.377   115.945     0.150
     4.492    71.047     0.150
     4.492   122.547     0.150
     4.508    70.250     0.150
     4.508   118.547     0.150
     4.515    69.852     0.150
     4.515   118.547     0.150
     4.515    69.852     0.150
     4.515   118.547     0.150
     4.689    71.750     0.150
     4.689   124.250     0.150
     4.689    71.750     0.150
     4.689   124.250     0.150
     4.744    72.445     0.150
     4.744   123.750     0.150
     4.744    72.445     0.150
     4.744   123.750     0.150
     4.766    71.547     0.150
     4.766   125.750     0.150
     4.766    71.547     0.150
     4.766   125.750     0.150
     5.125    77.750     0.150
     5.125   134.547     0.150
     5.238    78.945     0.150
     5.238   135.852     0.150
     5.483    83.445     0.150
     5.483   142.047     0.150
     5.896   150.852     0.150
     5.965    89.148     0.150
     5.965   154.148     0.150
     5.965    89.148     0.150
     5.965   154.148     0.150
     0.922    32.920     0.150
     0.922    18.950     0.150
     1.077    37.770     0.150
     1.077    21.850     0.150
     1.077    37.750     0.150
     1.308    45.150     0.150
     1.366    46.300     0.150
     1.366    25.750     0.150
     1.536    48.380     0.150
     1.536    27.850     0.150
     1.536    48.350     0.150
     1.778    32.450     0.150
     1.795    32.350     0.150
     1.796    59.960     0.150
     1.796    32.950     0.150
     2.224    36.750     0.150
     2.483    38.050     0.150
     2.483    68.450     0.150
     3.049    46.850     0.150
     3.049    83.650     0.150
     3.133    49.350     0.150
     3.133    88.650     0.150
     3.374    51.850     0.150
     3.374    91.150     0.150
     3.417    96.434     0.150
     3.417    54.150     0.150
     3.650    56.850     0.150
     3.833    57.550     0.150
     3.833   100.650     0.150
     3.833    57.550     0.150
     3.833   100.650     0.150
     3.842    57.350     0.150
     3.842   101.050     0.150
     3.805   105.110     0.150
     3.870    58.050     0.150
     3.870   100.450     0.150
     3.870    57.950     0.150
     3.870   100.450     0.150
     3.887    58.350     0.150
     3.887   100.650     0.150
     3.967    59.750     0.150
     3.967   105.150     0.150
     4.089    61.950     0.150
     4.089   107.050     0.150
     4.082   113.080     0.150
     4.082    62.950     0.150
     4.201    62.650     0.150
     4.201   108.750     0.150
     4.201    62.650     0.150
     4.201   108.750     0.150
     4.217    64.250     0.150
     4.217   109.550     0.150
     4.217   110.150     0.150
     4.245    64.950     0.150
     4.245    63.580     0.150
     4.245   110.050     0.150
     4.245    63.550     0.150
     4.245    64.950     0.150
     4.245   110.050     0.150
     4.322    65.250     0.150
     4.322   112.050     0.150
     4.322    65.250     0.150
     4.322   112.050     0.150
     4.453    66.040     0.150
     4.453   113.220     0.150
     4.453    66.050     0.150
     4.453   115.650     0.150
     4.464    68.450     0.150
     4.464    68.450     0.150
     4.464   116.450     0.150
     4.464    68.450     0.150
     4.464   116.450     0.150
     4.463    66.150     0.150
     4.463   115.550     0.150
     4.463    66.150     0.150
     4.463   115.550     0.150
     4.555    70.050     0.150
     4.555   122.950     0.150
     4.815    71.150     0.150
     4.815   123.950     0.150
     4.863    71.550     0.150
     4.863   124.650     0.150
     4.962    73.050     0.150
     4.962   127.550     0.150
     4.962    73.050     0.150
     4.962   127.550     0.150
     4.931    75.350     0.150
     4.931   129.950     0.150
     5.124    75.650     0.150
     5.124   131.450     0.150
     5.413    81.850     0.150
     5.413   142.450     0.150
     5.477    81.350     0.150
     5.515    80.950     0.150
     5.515   141.550     0.150
     5.594    82.050     0.150
     5.594   142.750     0.150
     5.594    82.050     0.150
     5.594   142.750     0.150
     5.651    82.550     0.150
     5.720   147.750     0.150
     5.720    84.050     0.150
     5.720   147.750     0.150
     5.720    84.050     0.150
     5.720   147.750     0.150
     5.844    85.450     0.150
     5.844   148.250     0.150
     5.844   149.350     0.150
     5.990    87.550     0.150
     6.005    87.650     0.150
     6.005   151.850     0.150
     6.005    87.650     0.150
     6.070    88.950     0.150
     6.070    88.950     0.150
     6.491    94.850     0.150
     6.449    94.050     0.150
     6.553    95.150     0.150
     6.553   166.250     0.150
     6.553    95.150     0.150
     6.553   166.250     0.150
     6.935   100.650     0.150
     6.935   100.650     0.150
     7.160   103.450     0.150
     7.194   104.148     0.150
     7.194   104.150     0.150
     7.211   105.850     0.150
     7.428   107.150     0.150
     7.428   186.250     0.150
     7.428   107.150     0.150
     7.539   108.750     0.150
     7.782   112.050     0.150
     7.782   195.850     0.150
     7.782   112.050     0.150
     7.912   113.650     0.150
     7.912   196.750     0.150
     7.912   113.650     0.150
     8.069   115.750     0.150
     8.209   206.650     0.150
     8.209   118.250     0.150
     8.560   125.750     0.150
     9.333   132.550     0.150
     9.552   138.050     0.150
    60.805   610.073     0.150
     0.401    21.711     0.150
     0.937    19.411     0.150
     0.937    31.511     0.150
     1.212    26.901     0.150
     1.212    45.341     0.150
     1.209    44.511     0.150
     1.474    27.811     0.150
     1.474    47.611     0.150
     2.226    45.111     0.150
     2.226    74.311     0.150
     2.600    41.611     0.150
     2.600    72.411     0.150
     3.072    47.811     0.150
     3.072    84.711     0.150
     3.203    50.311     0.150
     3.203    87.311     0.150
     3.346    92.611     0.150
     3.440    55.111     0.150
     3.440    94.711     0.150
     3.735   107.911     0.150
     3.957    55.411     0.150
     4.073    61.411     0.150
     4.073   106.511     0.150
     4.119   108.811     0.150
     4.119   108.811     0.150
     4.146    63.911     0.150
     4.146   106.911     0.150
     4.146    63.911     0.150
     4.146   106.911     0.150
     4.153    63.511     0.150
     4.153   108.411     0.150
     4.131    63.911     0.150
     4.131   109.711     0.150
     4.102   115.063     0.150
     4.102    64.511     0.150
     4.205    64.111     0.150
     4.205   111.511     0.150
     4.480   116.311     0.150
     4.480   116.311     0.150
     4.559    68.311     0.150
     4.559   118.111     0.150
     4.559    68.311     0.150
     4.559   118.111     0.150
     4.733    71.011     0.150
     4.733   122.811     0.150
     4.733    71.011     0.150
     4.733   122.811     0.150
     4.731   123.411     0.150
     4.731   123.411     0.150
     4.758    73.311     0.150
     4.758    73.311     0.150
     4.758   123.611     0.150
     4.758    73.311     0.150
     4.758   123.611     0.150
     5.090    76.511     0.150
     5.090   131.311     0.150
     5.223   134.311     0.150
     5.223   134.311     0.150
     5.367    80.411     0.150
     5.367   137.611     0.150
     5.590    82.911     0.150
     5.822    86.211     0.150
     5.822   149.311     0.150
     6.230    91.811     0.150
     0.255    16.039     0.150
     0.255     6.117     0.150
     0.255    16.047     0.150
     1.079    21.992     0.150
     1.079    36.320     0.150
     1.954    64.133     0.150
     1.954    36.352     0.150
     1.954    64.141     0.150
     2.371    76.352     0.150
     3.226    50.281     0.150
     3.136    48.945     0.150
     3.509    53.680     0.150
     3.749   101.086     0.150
     3.749    57.180     0.150
     3.927    59.680     0.150
     4.376    67.383     0.150
     4.376    67.383     0.150
     2.081    37.859     0.150
     4.978    74.906     0.150
     4.978   129.109     0.150
     5.191    78.117     0.150
     5.191   132.727     0.150
     5.254    78.711     0.150
     5.254    78.648     0.150
     5.254   135.711     0.150
     5.487    82.305     0.150
     5.487   142.305     0.150
     5.544    83.211     0.150
     5.544   143.109     0.150
     5.593   145.508     0.150
     6.103    92.805     0.150
     6.103    92.805     0.150
     6.103   158.211     0.150
     6.792   100.305     0.150
     6.792   173.805     0.150
     7.206   106.211     0.150
     0.792    28.314     0.150
     1.504    30.311     0.150
     2.450    76.891     0.150
     0.632    25.234     0.150
     1.039    22.789     0.150
     1.039    39.023     0.150
     1.272    39.078     0.150
     1.365    47.141     0.150
     1.568    52.086     0.150
     2.201    69.023     0.150
     2.217    42.133     0.150
     2.217    71.602     0.150
     2.422    72.203     0.150
     3.560   101.148     0.150
     3.816   107.500     0.150
     4.638   127.969     0.150
     4.905    72.992     0.150
     0.715    17.086     0.150
     0.715    28.633     0.150
     1.007    31.008     0.150
     1.039    31.352     0.150
     1.438    27.609     0.150
     1.438    51.391     0.150
     1.425    28.969     0.150
     1.425    53.430     0.150
     1.493    53.430     0.150
     1.825    60.219     0.150
     1.849    61.242     0.150
     3.159    56.820     0.150
     3.874    62.602     0.150
     4.275   115.844     0.150
     4.281   114.016     0.150
     4.304   118.562     0.150
     4.397   115.844     0.150
     4.400   114.781     0.150
     4.737   125.477     0.150
     5.459    82.180     0.150
     5.459   143.875     0.150
     6.025    87.477     0.150
     0.582    19.180     0.150
     0.860    33.656     0.150
     1.564    52.516     0.150
     1.668    50.312     0.150
     1.979    63.203     0.150
     2.635    44.305     0.150
     2.635    73.523     0.150
     3.200    91.852     0.150
     3.289    54.102     0.150
     3.289    95.102     0.150
     3.630    57.352     0.150
     3.630    97.852     0.150
     3.639    57.102     0.150
     3.639    97.852     0.150
     4.664    70.852     0.150
     4.664   121.055     0.150
     4.801   131.195     0.150
     4.940    74.391     0.150
     4.940   131.641     0.150
     4.988    74.953     0.150
     4.988   129.750     0.150
     4.988    75.352     0.150
     4.988   129.750     0.150
     5.154    77.953     0.150
     5.154   131.953     0.150
     5.214    79.148     0.150
     5.214    79.148     0.150
     5.214   134.852     0.150
     5.270    80.250     0.150
     5.270    80.250     0.150
     5.270   138.352     0.150
     5.598    84.055     0.150
     5.598   144.148     0.150
     5.774    88.148     0.150
     5.774   150.453     0.150
     5.774    88.148     0.150
     5.774   150.453     0.150
     5.774    88.242     0.150
     5.951    88.398     0.150
     5.951    88.320     0.150
     5.951   155.719     0.150
     6.330    93.453     0.150
     6.330   162.148     0.150
     6.429    95.055     0.150
     6.429   163.555     0.150
     6.451    95.164     0.150
     6.527    96.453     0.150
     6.527   165.648     0.150
     6.626   169.758     0.150
     6.841   100.352     0.150
     6.841   172.953     0.150
     6.888   101.453     0.150
     6.888   174.352     0.150
     7.313   107.148     0.150
     7.313   185.750     0.150
     7.390   107.883     0.150
     7.390   107.852     0.150
     7.390   187.555     0.150
     7.771   113.055     0.150
     7.771   195.852     0.150
     8.035   116.555     0.150
     8.267   120.055     0.150
     8.267   206.250     0.150
     8.348   121.555     0.150
     8.348   209.953     0.150
     8.378   121.750     0.150
     8.378   209.250     0.150
     8.624   125.055     0.150
     8.624   216.250     0.150
     8.749   126.953     0.150
     8.749   218.648     0.150
     9.046   130.750     0.150
     9.046   225.852     0.150
     9.979   144.352     0.150
     9.979   249.250     0.150
     9.979   256.297     0.150
    10.241   145.055     0.150
    10.241   145.055     0.150
    10.241   253.352     0.150
    10.276   146.148     0.150
    10.276   146.148     0.150
    10.276   254.852     0.150
    10.625   150.250     0.150
    10.625   150.250     0.150
    10.625   262.852     0.150
    17.723   244.578     0.150
    18.231   257.383     0.150
    18.371   253.180     0.150
    18.851   266.070     0.150
    18.869   265.906     0.150
    18.973   266.156     0.150
    19.625   275.109     0.150
    20.926   282.156     0.150
    20.937   280.742     0.150
    21.066     8.898     0.150
    22.431   303.859     0.150
    22.535   303.453     0.150
    38.474   445.875     0.150
    61.303   619.359     0.150
    63.439     3.898     0.150
    63.439     6.500     0.150
    64.744   643.094     0.150
    64.949   643.953     0.150
    77.593   718.844     0.150
    84.236   750.148     0.150
    84.236   756.148     0.150
    84.236     9.000     0.150
   141.578  1175.977     0.150
     0.840    32.727     0.150
     1.555    53.797     0.150
     1.670    32.895     0.150
     1.710    57.660     0.150
     1.825    62.102     0.150
     1.992    34.691     0.150
     2.121    67.598     0.150
     2.301    70.473     0.150
     2.612    76.684     0.150
     2.612    43.910     0.150
     2.612    76.684     0.150
     3.266    53.391     0.150
     3.266    91.203     0.150
     3.615    57.633     0.150
     3.615    98.492     0.150
     4.596    69.621     0.150
     4.596   120.723     0.150
     4.648    70.523     0.150
     4.648   120.820     0.150
     4.929    74.227     0.150
     4.929   133.324     0.150
     4.973    75.723     0.150
     4.973    75.723     0.150
     4.973   129.121     0.150
     4.975    74.434     0.150
     4.975   128.344     0.150
     5.135    77.820     0.150
     5.135   132.023     0.150
     5.201    78.023     0.150
     5.201   135.023     0.150
     5.223   145.961     0.150
     5.253    80.023     0.150
     5.253    80.023     0.150
     5.253   138.023     0.150
     5.583    83.820     0.150
     5.583   143.023     0.150
     5.757    87.922     0.150
     5.757    87.922     0.150
     5.757   149.621     0.150
     6.312    93.223     0.150
     6.312   161.723     0.150
     6.409    95.023     0.150
     6.409   162.320     0.150
     6.821   100.422     0.150
     6.821   172.121     0.150
     6.871    98.820     0.150
     6.871    98.820     0.150
     7.295   108.422     0.150
     7.295   108.422     0.150
     7.370   108.023     0.150
     7.370   187.523     0.150
     7.751   194.723     0.150
     8.247   120.121     0.150
     8.247   207.621     0.150
     8.357   121.523     0.150
     8.357   209.320     0.150
     8.602   124.820     0.150
     8.602   215.820     0.150
     8.729   126.820     0.150
     8.729   218.422     0.150
     9.026   130.621     0.150
     9.026   226.023     0.150
     0.773    18.461     0.150
     0.773    32.922     0.150
     1.058    40.875     0.150
     1.269    46.297     0.150
     1.447    47.023     0.150
     1.530    29.309     0.150
     2.066    38.707     0.150
     2.066    70.160     0.150
     3.976   116.074     0.150
     1.820    64.641     0.150
     1.820    32.930     0.150
     1.820    64.641     0.150
     2.040    39.301     0.150
     2.040    67.730     0.150
     2.205    72.830     0.150
     2.483    44.730     0.150
     2.817    45.730     0.150
     2.817    89.730     0.150
     3.958    60.730     0.150
     3.958   104.631     0.150
     3.984    60.930     0.150
     3.984   104.830     0.150
     4.319    66.430     0.150
     4.319   113.531     0.150
     4.387    68.230     0.150
     4.387   115.131     0.150
     4.568    70.131     0.150
     4.568   120.631     0.150
     4.600    71.230     0.150
     4.600    71.230     0.150
     4.600   120.430     0.150
     4.934    75.031     0.150
     4.934   128.031     0.150
     5.608    83.631     0.150
     5.608   145.230     0.150
     5.612    83.869     0.150
     5.660    84.531     0.150
     5.660   145.930     0.150
     5.820    86.180     0.150
     6.068    89.930     0.150
     6.068   156.031     0.150
     6.159    91.430     0.150
     6.159   157.631     0.150
     6.576    97.230     0.150
     6.612    97.631     0.150
     6.612   171.031     0.150
     6.999   102.531     0.150
     6.999   178.930     0.150
     7.592   110.930     0.150
     7.595   111.031     0.150
     7.595   192.730     0.150
     7.813   113.730     0.150
     7.813   198.031     0.150
     7.969   116.031     0.150
     7.969   200.830     0.150
     8.269   120.430     0.150
     9.426   139.730     0.150
     9.426   231.230     0.150
     9.452   140.230     0.150
     9.452   232.930     0.150
     9.452   140.230     0.150
     9.452   232.930     0.150
     9.487   141.008     0.150
     9.823   144.830     0.150
     9.823   240.631     0.150
     1.299    24.666     0.150
     1.839    32.504     0.150
     1.839    60.803     0.150
     2.197    71.553     0.150
     2.836    82.014     0.150
     2.836    45.014     0.150
     2.836    82.014     0.150
     3.518    99.729     0.150
     3.928    98.039     0.150
     3.974    60.113     0.150
     3.974   103.914     0.150
     4.000    60.414     0.150
     4.000   104.014     0.150
     4.009   111.529     0.150
     4.334    65.914     0.150
     4.334   112.713     0.150
     4.380    66.758     0.150
     4.401    65.713     0.150
     4.401   114.613     0.150
     4.414    67.113     0.150
     4.584    70.014     0.150
     4.584    70.014     0.150
     4.584   119.514     0.150
     4.614    70.713     0.150
     4.614    70.713     0.150
     4.614   119.713     0.150
     4.806   123.250     0.150
     4.950    74.213     0.150
     4.950   127.713     0.150
     5.221    77.605     0.150
     5.625    83.014     0.150
     5.625   144.613     0.150
     5.678    83.914     0.150
     5.678   146.914     0.150
     6.087    89.414     0.150
     6.087   152.914     0.150
     6.176    90.514     0.150
     6.176   157.814     0.150
     6.593    96.514     0.150
     6.630    96.414     0.150
     7.017   101.414     0.150
     7.103   183.482     0.150
     7.502   109.014     0.150
     7.502   188.314     0.150
     7.613   110.414     0.150
     7.613   191.713     0.150
     7.832   113.213     0.150
     7.987   115.713     0.150
     8.288   119.914     0.150
    21.704   294.422     0.150
     1.399    40.840     0.150
     1.976    53.715     0.150
     1.851    63.172     0.150
     1.851    34.352     0.150
     1.851    63.172     0.150
     2.211    43.082     0.150
     2.211    72.422     0.150
     2.211    69.691     0.150
     2.847    46.953     0.150
     3.785   108.859     0.150
     3.991    59.953     0.150
     3.991   104.555     0.150
     4.017    60.254     0.150
     4.017   104.055     0.150
     4.471   123.305     0.150
     4.352    65.852     0.150
     4.352   112.754     0.150
     4.419    67.652     0.150
     4.419   114.453     0.150
     4.601   119.754     0.150
     4.633    70.555     0.150
     4.633   119.754     0.150
     4.605   129.195     0.150
     4.968    74.352     0.150
     4.968   128.152     0.150
     5.641    83.055     0.150
     5.641   144.652     0.150
     5.692    83.953     0.150
     5.692   145.852     0.150
     6.101    89.453     0.150
     6.101   152.254     0.150
     6.192    90.555     0.150
     6.192    90.555     0.150
     7.627   110.453     0.150
     0.413    18.564     0.150
     0.579    18.922     0.150
     1.050    40.404     0.150
     1.231    24.123     0.150
     2.168    71.223     0.150
     2.920    93.438     0.150
     4.580    76.045     0.150
     4.580   131.746     0.150
     1.388    27.500     0.150
     5.406    79.367     0.150
     5.406   138.070     0.150
     5.712    84.168     0.150
     5.712   146.570     0.150
     5.864    87.270     0.150
     5.864   149.969     0.150
     6.305    91.867     0.150
     6.305   160.770     0.150
     7.107   102.867     0.150
     7.274   105.168     0.150
     7.274   182.570     0.150
     1.425    44.923     0.150
     1.569   122.910     0.150
     3.794   111.496     0.150
     3.920   113.974     0.150
     4.837    74.590     0.150
     4.837   127.690     0.150
     4.846    74.790     0.150
     4.846   128.391     0.150
     5.179    78.790     0.150
     5.179   136.090     0.150
     5.588    85.601     0.150
     5.792   150.990     0.150
     5.841    88.190     0.150
     5.841   152.090     0.150
     1.933    65.055     0.150
     2.423    77.359     0.150
     2.470    44.305     0.150
     2.855    51.289     0.150
     3.025    88.770     0.150
     3.414    98.648     0.150
     3.690    61.102     0.150
     4.789    75.438     0.150
     5.266    78.621     0.150
     5.266   135.824     0.150
     5.345    79.723     0.150
     5.345   137.223     0.150
     5.512    79.785     0.150
     5.512   137.656     0.150
     5.587    83.121     0.150
     5.655    84.324     0.150
     5.655   145.223     0.150
     5.823    86.621     0.150
     5.904    87.434     0.150
     5.904   151.723     0.150
     5.911    87.922     0.150
     6.253    92.023     0.150
     6.253   160.223     0.150
     7.040   102.922     0.150
     7.040   179.324     0.150
     7.192   105.422     0.150
     7.192   182.523     0.150
     7.607   111.422     0.150
     7.607   192.621     0.150
     8.162   118.922     0.150
     9.153   132.523     0.150
     9.437   136.422     0.150
     9.813   142.223     0.150
     1.476    50.328     0.150
     1.502    52.758     0.150
     1.714    54.500     0.150
     1.855    62.500     0.150
     2.035    64.586     0.150
     2.842    81.977     0.150
     3.262    55.195     0.150
     3.304    54.148     0.150
     3.447    96.586     0.150
     5.403    79.023     0.150
     5.403   135.922     0.150
     5.499    80.023     0.150
     5.499   139.125     0.150
     5.685    82.523     0.150
     5.685    82.523     0.150
     5.685   144.828     0.150
     5.797   146.828     0.150
     6.041    88.023     0.150
     6.041   153.125     0.150
     6.382    92.125     0.150
     6.382   160.727     0.150
     7.205   102.328     0.150
     7.205   102.328     0.150
     7.205   182.523     0.150
     7.397   106.422     0.150
     7.397   184.328     0.150
     1.589    48.051     0.150
     2.182    66.332     0.150
     2.304    77.105     0.150
     0.375     6.688     0.150
     0.375    10.398     0.150
     1.031    24.359     0.150
     1.769    58.742     0.150
     1.883    61.875     0.150
     3.485    93.984     0.150
     4.745    73.656     0.150
     4.745    73.656     0.150
     4.745   124.359     0.150
     5.108   133.359     0.150
     5.126   133.953     0.150
     5.337   139.258     0.150
     5.377   139.555     0.150
     5.733   148.656     0.150
     6.479   167.258     0.150
     0.546    17.180     0.150
     1.102    23.805     0.150
     1.102    40.688     0.150
     1.537    32.406     0.150
     1.537    54.594     0.150
     1.855    36.383     0.150
     3.412    52.648     0.150
     3.412    91.352     0.150
     3.517    55.352     0.150
     3.517    93.750     0.150
     3.808    60.352     0.150
     3.808   101.453     0.150
     4.389    65.953     0.150
     4.389   114.852     0.150
     5.226   135.852     0.150
     5.459    81.250     0.150
     5.459   141.453     0.150
     0.495    13.032     0.150
     0.495    19.347     0.150
     1.236    43.229     0.150
     1.735    34.471     0.150
     1.735    58.330     0.150
     2.469    41.990     0.150
     2.469    73.218     0.150
     3.672   107.096     0.150
     3.688    59.543     0.150
     0.582    25.527     0.150
     0.819    15.128     0.150
     0.973    21.157     0.150
     0.973    37.558     0.150
     0.973    21.157     0.150
     0.973    37.558     0.150
     1.129    37.062     0.150
     1.251    27.486     0.150
     1.382    29.609     0.150
     1.432    49.574     0.150
     1.536    30.871     0.150
     1.814    36.463     0.150
     1.814    62.848     0.150
     1.959    63.330     0.150
     2.838    50.208     0.150
     3.487    55.548     0.150
     3.617    60.975     0.150
     3.861   106.249     0.150
     3.983    60.848     0.150
     3.984   107.167     0.150
     3.994    60.747     0.150
     4.332   115.447     0.150
     4.332    65.947     0.150
     4.332   115.447     0.150
     4.435    67.447     0.150
     4.435   116.348     0.150
     4.870   135.860     0.150
     4.948    74.447     0.150
     4.948   129.247     0.150
     5.443    82.985     0.150
     5.443   144.136     0.150
     5.585    84.247     0.150
     5.585   144.947     0.150
     5.603    84.147     0.150
     5.603   145.747     0.150
     0.485    20.996     0.150
     0.540    17.461     0.150
     0.540    25.533     0.150
     0.788    24.889     0.150
     1.020    21.602     0.150
     1.020    35.961     0.150
     1.020    21.602     0.150
     1.020    35.961     0.150
     1.011    23.082     0.150
     1.106    25.906     0.150
     1.549    33.422     0.150
     1.549    52.719     0.150
     1.838    55.051     0.150
     1.755    37.455     0.150
     1.755    64.121     0.150
     3.160    58.227     0.150
     3.160   101.365     0.150
     4.813    78.332     0.150
     4.813   136.227     0.150
     0.505     9.961     0.150
     0.505    22.711     0.150
     0.779    29.211     0.150
     1.061    38.824     0.150
     1.050    21.664     0.150
     1.050    35.695     0.150
     1.173    40.371     0.150
     1.219    41.531     0.150
     1.307    43.324     0.150
     1.359    44.668     0.150
     2.004    62.562     0.150
     4.026    60.586     0.150
     4.026   103.785     0.150
     4.040    59.285     0.150
     4.040   103.984     0.150
     4.378    64.883     0.150
     5.639    82.086     0.150
     0.769    16.863     0.150
     0.826    28.770     0.150
     0.872    32.008     0.150
     0.996    35.164     0.150
     1.617    28.320     0.150
     1.617    50.391     0.150
     1.811    56.770     0.150
     1.883    58.734     0.150
     1.895    30.762     0.150
     2.026    52.891     0.150
     2.037    35.266     0.150
     2.037    63.855     0.150
     2.529    74.871     0.150
     2.529    72.391     0.150
     4.775    68.531     0.150
     4.791    68.730     0.150
     4.791   118.832     0.150
     5.128    73.434     0.150
     5.196   134.262     0.150
     5.424    77.633     0.150
     5.424   134.531     0.150
     5.745    81.832     0.150
     5.745   142.230     0.150
     5.966    84.633     0.150
     5.966   146.332     0.150
     5.981   153.711     0.150
     6.388    90.531     0.150
     6.388   157.332     0.150
     6.932    98.133     0.150
     0.627    15.504     0.150
     0.713    13.514     0.150
     1.982    56.574     0.150
     1.982    36.186     0.150
     1.982    40.256     0.150
     1.982    56.574     0.150
     2.289    45.955     0.150
     2.289    81.555     0.150
     3.992    63.734     0.150
     3.992    63.734     0.150
     3.992   105.336     0.150
     4.067    62.135     0.150
     4.067   107.135     0.150
     4.121    65.002     0.150
     4.380    68.436     0.150
     4.380   114.836     0.150
     4.565    71.336     0.150
     4.565   122.035     0.150
     4.980    76.135     0.150
     4.980   130.535     0.150
     5.200    79.936     0.150
     5.200   134.635     0.150
     5.761   149.436     0.150
     5.920    88.635     0.150
     5.920   152.035     0.150
     6.335    94.336     0.150
     6.335   162.336     0.150
     6.756   173.734     0.150
     7.578   116.535     0.150
     7.883   116.635     0.150
     7.883   116.635     0.150
     0.134     7.763     0.150
     0.485    16.204     0.150
     2.156    66.596     0.150
     2.331    70.286     0.150
     2.331    40.586     0.150
     2.331    70.286     0.150
     2.946    48.806     0.150
     2.946    80.846     0.150
     3.620    96.565     0.150
     4.240    68.646     0.150
     4.240   117.366     0.150
     5.522    85.496     0.150
     5.584   145.076     0.150
     5.833    88.496     0.150
     6.030    89.416     0.150
     6.030   155.166     0.150
     6.630   175.596     0.150
     6.779   105.796     0.150
     7.721   193.056     0.150
     8.240   124.346     0.150
     8.240   204.956     0.150
     8.332   207.926     0.150
     1.168    20.969     0.150
     1.245    43.889     0.150
     4.868    72.397     0.150
     4.868   125.498     0.150
     4.931    74.397     0.150
     4.931   126.797     0.150
     5.250    78.798     0.150
     5.250   134.998     0.150
     6.725    99.297     0.150
     6.725   171.098     0.150
     0.736    13.008     0.150
     0.736    23.805     0.150
     0.662    24.445     0.150
     0.773    13.922     0.150
     1.316    44.234     0.150
     1.585    31.359     0.150
     1.585    53.711     0.150
     1.847    58.719     0.150
     2.774    45.633     0.150
     2.774    80.461     0.150
     4.077    61.172     0.150
     4.077   104.469     0.150
     4.152    62.469     0.150
     4.152   104.969     0.150
     4.353    63.930     0.150
     4.353   110.680     0.150
     4.464    66.773     0.150
     4.464   112.875     0.150
     4.649    68.773     0.150
     4.649   118.773     0.150
     5.065    74.375     0.150
     5.065   127.969     0.150
     5.284    78.070     0.150
     5.284   132.672     0.150
     5.251   134.016     0.150
     5.845    86.273     0.150
     5.845    86.273     0.150
     5.845   148.070     0.150
     6.001    86.969     0.150
     6.001   150.070     0.150
     6.086   150.289     0.150
     0.423    19.664     0.150
     0.814    31.188     0.150
     1.438    51.086     0.150
     3.392    52.922     0.150
     3.392    91.117     0.150
     3.443    54.023     0.150
     3.443    92.617     0.150
     3.768   101.117     0.150
     4.020    62.422     0.150
     4.020    62.422     0.150
     4.020   106.523     0.150
     4.379   116.320     0.150
     5.113    77.922     0.150
     5.113   134.922     0.150
     0.511    13.555     0.150
     0.511    22.711     0.150
     0.779    12.875     0.150
     0.779    22.734     0.150
     1.275    38.453     0.150
     1.396    42.352     0.150
     1.854    38.516     0.150
     1.854    65.406     0.150
     1.854    38.516     0.150
     1.854    65.406     0.150
     2.096    40.781     0.150
     2.096    71.266     0.150
     2.206    66.406     0.150
     2.723    49.664     0.150
     3.852    60.125     0.150
     3.852   101.328     0.150
     3.923    61.125     0.150
     3.923   103.523     0.150
     4.237    65.625     0.150
     4.237   110.625     0.150
     4.487    67.922     0.150
     4.487   117.523     0.150
     4.840    72.922     0.150
     4.840   125.328     0.150
     5.765    85.422     0.150
     5.765   147.422     0.150
     0.532    20.247     0.150
     0.817    18.624     0.150
     0.817    31.067     0.150
     0.958    17.969     0.150
     0.958    30.412     0.150
     1.089    34.341     0.150
     2.806    49.403     0.150
     3.125    53.987     0.150
     4.266   111.407     0.150
     4.343    66.207     0.150
     4.343   113.607     0.150
     4.654    70.808     0.150
     4.903    73.808     0.150
     4.903   126.808     0.150
     5.254    78.007     0.150
     0.916    16.836     0.150
     1.022    16.727     0.150
     1.022    31.930     0.150
     1.024    37.500     0.150
     1.606    28.156     0.150
     1.606    48.148     0.150
     1.815    31.500     0.150
     1.815    53.609     0.150
     2.421    68.219     0.150
     2.933    85.688     0.150
     2.998    87.039     0.150
     3.437    98.219     0.150
     3.884   108.695     0.150
     4.421    71.531     0.150
     4.421   125.688     0.150
     4.517   117.125     0.150
     1.641    33.279     0.150
     1.641    58.428     0.150
     2.567    80.232     0.150
     3.030    46.482     0.150
     5.301    79.334     0.150
     5.301   137.234     0.150
     5.360    80.033     0.150
     5.360   138.234     0.150
     5.663    84.184     0.150
     5.663   145.334     0.150
     5.893    87.734     0.150
     6.289    92.834     0.150
     6.289   161.033     0.150
     6.475    95.533     0.150
     6.475   165.633     0.150
     6.945   178.801     0.150
     7.032   103.133     0.150
     7.032   178.834     0.150
     7.133   185.133     0.150
     7.133   104.434     0.150
     7.546   110.234     0.150
     7.546   190.633     0.150
     1.114    38.738     0.150
     1.418    23.906     0.150
     1.418    41.986     0.150
     1.418    23.791     0.150
     1.418    41.277     0.150
     2.102    57.822     0.150
     2.974    45.229     0.150
     3.634   110.910     0.150
     3.882    58.637     0.150
     3.882    99.836     0.150
     3.954   104.336     0.150
     3.954    59.936     0.150
     4.230    62.736     0.150
     4.268    64.137     0.150
     4.268   109.336     0.150
     4.341   112.396     0.150
     4.461    66.035     0.150
     4.461   115.035     0.150
     4.606   118.217     0.150
     4.871    71.535     0.150
     4.871   124.637     0.150
     5.645    83.137     0.150
     5.798    84.336     0.150
     5.798   145.836     0.150
     6.214    89.936     0.150
     6.214   155.535     0.150
     1.517    30.266     0.150
     3.117    51.777     0.150
     0.759    28.820     0.150
     1.156    23.203     0.150
     1.156    37.586     0.150
     2.143    41.727     0.150
     2.143    71.039     0.150
     2.171    70.391     0.150
     2.865    90.188     0.150
     3.529    59.477     0.150
     3.841   110.516     0.150
     4.084    68.070     0.150
     5.907    86.672     0.150
     0.791    14.062     0.150
     1.858    37.375     0.150
     1.924    63.410     0.150
     4.811    71.176     0.150
     4.811   123.477     0.150
     4.877    71.977     0.150
     4.877   125.074     0.150
     5.195    77.875     0.150
     5.195   133.176     0.150
     5.392    79.477     0.150
     5.392   137.977     0.150
     5.799    85.574     0.150
     5.799   147.574     0.150
     6.560    95.375     0.150
     6.686    97.477     0.150
     6.686   169.574     0.150
     0.882    32.954     0.150
     2.703    82.416     0.150
     2.752    48.281     0.150
     5.350    82.494     0.150
     5.350    82.494     0.150
     5.350   139.394     0.150
     5.449    83.594     0.150
     5.449   141.594     0.150
     6.328    94.594     0.150
     6.328   162.794     0.150
     7.156   107.894     0.150
     7.156   107.894     0.150
     7.355   185.394     0.150
     7.355   109.694     0.150
     7.355   185.394     0.150
     0.878    16.000     0.150
     0.750    30.762     0.150
     1.033    16.621     0.150
     1.033    29.680     0.150
     0.774    28.734     0.150
     0.791    28.555     0.150
     1.575    27.066     0.150
     1.575    45.387     0.150
     1.674    30.137     0.150
     1.936    37.812     0.150
     1.936    65.320     0.150
     2.169    71.035     0.150
     2.493    47.465     0.150
     2.493    76.996     0.150
     2.970    47.012     0.150
     4.535   117.121     0.150
     4.560    69.418     0.150
     4.560   118.480     0.150
     4.613   116.617     0.150
     4.637    67.516     0.150
     4.637   116.715     0.150
     4.972    71.914     0.150
     5.255    76.215     0.150
     5.255   132.215     0.150
     5.588    80.414     0.150
     5.588   139.617     0.150
     5.936   151.164     0.150
     6.250    89.215     0.150
     6.250   157.414     0.150
     1.226    35.387     0.150
     1.226    22.727     0.150
     1.226    35.387     0.150
     1.016    23.836     0.150
     1.016    39.094     0.150
     1.178    25.375     0.150
     1.178    42.738     0.150
     1.244    26.211     0.150
     1.244    44.164     0.150
     1.244    26.230     0.150
     1.244    44.496     0.150
     2.449    40.117     0.150
     2.449    63.688     0.150
     2.235    43.879     0.150
     2.235    71.117     0.150
     2.511    41.586     0.150
     2.511    67.688     0.150
     2.558    40.316     0.150
     2.738    72.988     0.150
     2.887    46.387     0.150
     2.887    78.688     0.150
     4.042    59.887     0.150
     4.042   104.188     0.150
     4.030   109.277     0.150
     4.068    60.129     0.150
     4.068    60.188     0.150
     4.068   103.688     0.150
     4.402    64.789     0.150
     4.402   113.188     0.150
     4.476    66.988     0.150
     4.476   114.086     0.150
     4.451   113.688     0.150
     4.471    65.977     0.150
     4.471   113.199     0.150
     4.488   123.492     0.150
     4.650    68.586     0.150
     4.650   118.586     0.150
     4.654    68.129     0.150
     4.654   117.258     0.150
     4.684    68.988     0.150
     4.684   119.289     0.150
     4.739   120.766     0.150
     4.739   122.539     0.150
     5.018    73.688     0.150
     5.018   127.188     0.150
     5.323   140.457     0.150
     5.268    75.289     0.150
     5.268    75.289     0.150
     5.268    75.289     0.150
     5.269    80.086     0.150
     5.269    80.086     0.150
     5.668   146.199     0.150
     5.690    82.988     0.150
     5.690   144.188     0.150
     5.540    83.789     0.150
     5.738    83.789     0.150
     5.738   142.988     0.150
     5.794   149.488     0.150
     5.713    87.887     0.150
     5.713    87.887     0.150
     6.146    89.289     0.150
     6.146   155.188     0.150
     6.240    90.586     0.150
     6.240   155.688     0.150
     6.388    94.918     0.150
     6.388    94.918     0.150
     6.388   158.469     0.150
     6.656    96.488     0.150
     6.656   167.586     0.150
     6.689    97.188     0.150
     6.689   165.086     0.150
     6.766    98.188     0.150
     7.128   182.938     0.150
     7.224   185.484     0.150
     7.309   105.289     0.150
     9.098   131.180     0.150
     9.268   135.664     0.150
     9.268   233.219     0.150
     9.364   286.316     0.150
     9.468   132.586     0.150
     9.468   132.586     0.150
     9.468   231.188     0.150
     9.497   132.988     0.150
     9.497   230.789     0.150
     9.497   132.988     0.150
     9.497   230.789     0.150
     9.534   138.797     0.150
     9.569   139.051     0.150
     9.860   138.086     0.150
     9.860   138.086     0.150
     9.860   239.988     0.150
    10.143   146.488     0.150
    10.811   150.789     0.150
    10.811   150.789     0.150
    10.811   262.586     0.150
    11.713   162.688     0.150
    11.713   283.887     0.150
    11.713   162.688     0.150
    11.713   283.887     0.150
    11.810   172.887     0.150
    12.274   170.887     0.150
    12.815   182.387     0.150
    12.844   178.289     0.150
    12.844   178.289     0.150
    13.070   186.387     0.150
    13.070   181.488     0.150
    13.070   317.387     0.150
    13.071   181.289     0.150
    13.071   181.289     0.150
    13.662   194.289     0.150
    13.662   189.789     0.150
    13.698   189.988     0.150
    13.812   191.688     0.150
    13.812   191.688     0.150
    13.812   334.387     0.150
    13.920   193.387     0.150
    13.920   198.387     0.150
    13.920   193.387     0.150
    13.920   338.586     0.150
    13.951   198.488     0.150
    13.951   193.586     0.150
    14.183   196.789     0.150
    14.225   197.188     0.150
    14.225   344.086     0.150
    14.304   198.188     0.150
    14.304   203.188     0.150
    14.304   198.188     0.150
    14.304   347.789     0.150
    14.331   198.887     0.150
    14.331   203.988     0.150
    14.331   198.887     0.150
    14.331   348.488     0.150
    14.382   199.289     0.150
    14.645   202.988     0.150
    14.645   202.988     0.150
    14.645   355.887     0.150
    14.769   204.887     0.150
    14.769   355.887     0.150
    15.068   208.988     0.150
    15.068   212.789     0.150
    15.068   208.988     0.150
    15.068   363.488     0.150
    15.066   208.688     0.150
    15.066   366.387     0.150
    15.981   221.086     0.150
    16.240   224.887     0.150
    16.295   225.586     0.150
    16.295   225.586     0.150
    16.295   395.586     0.150
    16.343   226.289     0.150
    16.343   396.688     0.150
    16.785   235.367     0.150
    16.990   234.789     0.150
    16.990   234.789     0.150
    16.990   411.688     0.150
    17.347   420.086     0.150
    17.347   239.988     0.150
    17.347   420.086     0.150
    17.492   240.996     0.150
    17.565   424.586     0.150
    17.940   248.578     0.150
    19.672   269.055     0.150
    20.679   279.867     0.150
    21.596   298.086     0.150
    21.596   302.688     0.150
    21.596   311.688     0.150
    21.596   558.688     0.150
    21.710   303.137     0.150
    21.646   293.699     0.150
    21.646   293.711     0.150
    22.387   297.367     0.150
    22.578   298.289     0.150
    23.296   307.000     0.150
    23.511   319.789     0.150
    24.843   321.324     0.150
    25.028   322.586     0.150
    26.154   330.406     0.150
    27.239   348.887     0.150
    28.795   355.902     0.150
    43.282   479.688     0.150
    49.280   526.918     0.150
    62.923     7.402     0.150
    69.068     5.500     0.150
    77.167   715.336     0.150
    77.971   721.762     0.150
    79.100   729.789     0.150
    79.100     8.199     0.150
    80.741   737.188     0.150
    80.741   735.387     0.150
    93.906   803.488     0.150
     1.491    51.398     0.150
     1.710    58.781     0.150
     1.826    62.219     0.150
     2.401    70.164     0.150
     2.402    39.797     0.150
     2.881    45.156     0.150
     2.892    46.797     0.150
     2.912    57.898     0.150
     3.037    83.469     0.150
     3.066    55.578     0.150
     3.156    49.984     0.150
     3.156    83.688     0.150
     3.226    47.547     0.150
     3.342    55.266     0.150
     3.342    55.266     0.150
     3.342    96.984     0.150
     3.315    88.352     0.150
     3.315    52.477     0.150
     3.315    88.359     0.150
     3.443    55.125     0.150
     3.443    92.406     0.150
     3.511    93.062     0.150
     3.589    55.773     0.150
     3.589    94.617     0.150
     3.638    61.867     0.150
     3.638    61.867     0.150
     3.638    61.867     0.150
     3.842    98.797     0.150
     4.562   118.188     0.150
     4.692    70.367     0.150
     4.692   122.266     0.150
     4.700    69.969     0.150
     4.700   120.969     0.150
     4.823    74.070     0.150
     4.823    74.070     0.150
     5.033    75.766     0.150
     5.033   130.469     0.150
     5.039    76.164     0.150
     5.039   129.867     0.150
     5.135   132.570     0.150
     5.143    76.195     0.150
     5.143   130.836     0.150
     5.143    76.164     0.150
     5.105    77.367     0.150
     5.262    78.969     0.150
     5.262   135.469     0.150
     5.290   133.461     0.150
     5.290    78.508     0.150
     5.290   133.461     0.150
     5.350    79.266     0.150
     5.350   138.266     0.150
     5.286    80.469     0.150
     5.655    83.867     0.150
     5.655   145.164     0.150
     5.809   151.805     0.150
     5.935   155.914     0.150
     5.936    88.914     0.150
     6.271    93.070     0.150
     6.271   159.664     0.150
     6.277    91.070     0.150
     6.277   158.367     0.150
     6.277    91.070     0.150
     6.277   158.367     0.150
     6.371   160.273     0.150
     6.603   171.805     0.150
     6.603    98.664     0.150
     6.603   171.805     0.150
     6.671    98.570     0.150
     6.671   168.766     0.150
     6.680    98.570     0.150
     6.817   100.469     0.150
     6.817   172.469     0.150
     6.901   177.039     0.150
     7.201   105.664     0.150
     7.201   184.070     0.150
     7.224   105.969     0.150
     7.224   183.867     0.150
     7.232   106.734     0.150
     7.325   107.711     0.150
     7.325   107.766     0.150
     7.598   110.664     0.150
     7.598   192.070     0.150
     7.776   113.867     0.150
     8.059   117.070     0.150
     8.059   200.766     0.150
     8.195   120.039     0.150
     8.326   121.570     0.150
     8.326   210.070     0.150
     8.549   124.469     0.150
     8.549   213.766     0.150
     8.651   126.195     0.150
     8.855   129.070     0.150
     8.855   221.766     0.150
     9.569   230.266     0.150
     9.638   231.766     0.150
     9.716   143.203     0.150
     9.920   239.664     0.150
    10.994   161.266     0.150
    11.804   171.070     0.150
    12.154   169.469     0.150
    12.154   169.469     0.150
    12.680   176.367     0.150
    12.680   176.367     0.150
    12.680   182.266     0.150
    12.703   176.367     0.150
    12.703   176.367     0.150
    12.912   185.266     0.150
    13.208   190.469     0.150
    13.530   193.570     0.150
    13.550   187.867     0.150
    13.550   194.164     0.150
    13.550   330.766     0.150
    14.191   202.570     0.150
    14.191   202.570     0.150
    14.558   206.867     0.150
    14.558   206.867     0.150
    14.607   208.570     0.150
    14.607   208.570     0.150
    14.847   210.664     0.150
    17.310   239.625     0.150
    21.594   287.875     0.150
    26.029   333.656     0.150
     1.039    37.824     0.150
     1.003    15.973     0.150
     1.253    41.383     0.150
     1.539    53.109     0.150
     2.188    18.027     0.150
     3.945    57.645     0.150
     3.945   101.746     0.150
     3.972    57.945     0.150
     3.972   101.348     0.150
     4.306    63.445     0.150
     4.306   110.145     0.150
     4.372   114.047     0.150
     4.558    65.938     0.150
     4.558   114.477     0.150
     4.586    67.746     0.150
     4.586   116.645     0.150
     4.922    71.848     0.150
     4.922   125.348     0.150
     5.597    80.246     0.150
     5.597    80.246     0.150
     5.597   140.246     0.150
     5.651   142.848     0.150
     2.278    39.781     0.150
     6.117    94.586     0.150
     6.239    94.531     0.150
     4.595    70.477     0.150
     4.595   120.877     0.150
     4.615    71.665     0.150
     4.615   117.075     0.150
     4.638    70.777     0.150
     4.638   121.277     0.150
     4.660   118.617     0.150
     4.701    74.017     0.150
     4.967    75.377     0.150
     4.967   129.977     0.150
     4.989    75.277     0.150
     4.989   130.977     0.150
     5.212    78.477     0.150
     5.219    78.477     0.150
     5.219   135.677     0.150
     5.579    83.677     0.150
     6.289    93.477     0.150
     6.366    94.077     0.150
     6.776    99.977     0.150
     0.688    21.525     0.150
     0.778    23.863     0.150
     0.778    15.029     0.150
     0.778    24.109     0.150
     1.512    51.797     0.150
     1.611    51.502     0.150
     1.744    32.592     0.150
     2.028    35.432     0.150
     2.028    65.422     0.150
     2.387    40.812     0.150
     2.387    66.283     0.150
     2.453    46.143     0.150
     2.458    80.033     0.150
     2.458    46.363     0.150
     2.538    75.217     0.150
     2.944    48.293     0.150
     2.904    49.221     0.150
     2.904    49.223     0.150
     3.039    46.652     0.150
     3.039    81.803     0.150
     3.095    88.762     0.150
     3.095    47.092     0.150
     3.095    79.842     0.150
     3.264    50.162     0.150
     3.264    88.342     0.150
     3.408    53.562     0.150
     3.408    92.143     0.150
     3.521    54.652     0.150
     3.521    94.523     0.150
     3.651    57.262     0.150
     3.784    59.053     0.150
     3.897    76.812     0.150
     4.131    64.133     0.150
     4.258   116.014     0.150
     4.459    67.012     0.150
     4.446    66.682     0.150
     4.446   116.373     0.150
     4.482    67.322     0.150
     4.482   116.182     0.150
     4.645    70.172     0.150
     4.767    71.096     0.150
     4.767   124.812     0.150
     4.767    71.143     0.150
     4.806    72.012     0.150
     5.038    75.012     0.150
     5.203    77.822     0.150
     5.285    84.555     0.150
     5.280    81.352     0.150
     5.467    81.002     0.150
     5.726    85.012     0.150
     5.726   147.303     0.150
     6.036    96.912     0.150
     6.171    92.113     0.150
     6.194   157.275     0.150
     6.194    91.352     0.150
     6.273    97.588     0.150
     6.427    95.213     0.150
     6.427   164.912     0.150
     6.915   179.402     0.150
     7.510   110.842     0.150
     7.729   116.539     0.150
     7.731   115.613     0.150
     7.794   112.912     0.150
     7.794   195.613     0.150
     8.031   116.012     0.150
     8.513   123.303     0.150
     8.550   128.291     0.150
     8.813   218.312     0.150
     8.936   229.350     0.150
     9.070   229.314     0.150
     8.957   269.812     0.150
     9.089   130.352     0.150
     9.494   138.512     0.150
     9.769   141.203     0.150
     9.792   141.850     0.150
     9.912   142.252     0.150
     9.930   243.127     0.150
     9.930   143.203     0.150
    10.021   146.713     0.150
    10.060   145.932     0.150
    10.125   147.162     0.150
    13.533   189.412     0.150
    14.150   203.402     0.150
    14.147   203.012     0.150
    14.444   201.312     0.150
    14.444   263.912     0.150
    14.829   210.512     0.150
    14.829   271.613     0.150
    14.854   207.113     0.150
    14.854   272.312     0.150
    15.171   210.312     0.150
    15.171   278.613     0.150
    15.492   283.812     0.150
    15.563   221.812     0.150
    15.595   216.812     0.150
    15.595   221.213     0.150
    15.595   285.213     0.150
    15.595   379.713     0.150
    16.492   233.213     0.150
    16.800   237.512     0.150
    16.843   237.912     0.150
    17.491   246.412     0.150
    17.491   246.412     0.150
    17.868   250.512     0.150
    18.004   254.309     0.150
    18.084   251.113     0.150
    18.341   257.912     0.150
    18.380   257.838     0.150
    19.406   271.076     0.150
    21.285   288.875     0.150
    22.196   293.043     0.150
    22.319   301.613     0.150
    26.722   343.312     0.150
    26.747   342.713     0.150
    27.164   340.412     0.150
    39.851   454.512     0.150
     1.442    52.727     0.150
     2.287    75.973     0.150
     2.350    46.410     0.150
     3.210    95.672     0.150
     0.496    17.223     0.150
     0.626    23.855     0.150
     0.695    13.168     0.150
     0.695    21.543     0.150
     0.786    14.355     0.150
     0.786    23.855     0.150
     1.504    52.887     0.150
     1.603    52.117     0.150
     1.596    55.117     0.150
     1.742    34.445     0.150
     1.742    56.438     0.150
     2.021    64.027     0.150
     2.168    70.117     0.150
     2.186    34.418     0.150
     2.382    45.777     0.150
     2.938    77.426     0.150
     4.405    65.957     0.150
     4.405   115.055     0.150
     4.758   126.438     0.150
     4.758    70.758     0.150
     4.918    73.758     0.150
     4.918   126.855     0.150
     5.020    74.855     0.150
     5.030    74.457     0.150
     5.050    75.457     0.150
     5.390    79.457     0.150
     5.551    81.957     0.150
     5.719    84.555     0.150
     6.105    89.758     0.150
     6.190    90.957     0.150
     6.190   156.855     0.150
     6.601    96.656     0.150
     6.601   166.258     0.150
     6.662    97.758     0.150
     6.662   168.656     0.150
     7.084   103.355     0.150
     7.084   180.457     0.150
     7.133   178.059     0.150
     7.149   104.457     0.150
     7.149   180.656     0.150
     7.787   192.566     0.150
     7.787   112.656     0.150
     8.025   116.355     0.150
     8.025   200.855     0.150
     8.373   120.758     0.150
     8.508   123.055     0.150
     8.806   126.957     0.150
     8.806   219.355     0.150
     0.221    11.180     0.150
     1.761    34.219     0.150
     1.761    60.020     0.150
     0.649    20.980     0.150
     3.373    56.898     0.150
     3.373    97.156     0.150
     3.421    58.584     0.150
     4.187   118.662     0.150
     0.163     6.684     0.150
     0.668    22.164     0.150
     1.328    27.029     0.150
     1.431    28.810     0.150
     1.431    48.991     0.150
     1.618    31.481     0.150
     1.618    55.223     0.150
     1.729    56.644     0.150
     1.729    32.104     0.150
     1.729    56.644     0.150
     1.811    35.636     0.150
     1.811    59.675     0.150
     3.762    55.582     0.150
     4.492    66.874     0.150
     4.492   115.774     0.150
     4.821    72.474     0.150
     4.821   125.474     0.150
     4.846    72.874     0.150
     5.068    76.074     0.150
     5.068   131.874     0.150
     5.073    76.474     0.150
     5.073   131.474     0.150
     5.434    80.874     0.150
     5.434   140.674     0.150
     6.142    92.174     0.150
     6.142    92.174     0.150
     6.142   157.774     0.150
     6.220    91.674     0.150
     6.220   158.774     0.150
     6.596   163.164     0.150
     6.630    97.074     0.150
     0.226     7.699     0.150
     0.543    18.199     0.150
     0.691    22.625     0.150
     1.493    31.203     0.150
     1.544    51.980     0.150
     1.598    32.973     0.150
     1.598    57.391     0.150
     1.825    61.180     0.150
     2.165    42.117     0.150
     2.426    43.418     0.150
     3.003    81.449     0.150
     3.456    54.348     0.150
     3.456    94.117     0.150
     3.705    57.820     0.150
     3.705   100.488     0.150
     4.453    68.570     0.150
     4.453   117.570     0.150
     4.455    67.320     0.150
     4.492    68.570     0.150
     4.492   116.867     0.150
     4.510    68.398     0.150
     4.510   116.867     0.150
     4.482    71.930     0.150
     4.482   123.367     0.150
     4.533   118.738     0.150
     4.608   120.250     0.150
     4.822    71.570     0.150
     4.822   125.078     0.150
     4.822    73.668     0.150
     4.822   125.969     0.150
     4.856    73.570     0.150
     4.856   127.668     0.150
     4.938   130.770     0.150
     4.938   130.770     0.150
     4.928    74.648     0.150
     4.928   133.379     0.150
     5.077    77.070     0.150
     5.075    77.168     0.150
     5.075   133.070     0.150
     5.436    81.570     0.150
     5.436   140.969     0.150
     5.474    82.270     0.150
     5.474   140.891     0.150
     5.584    83.570     0.150
     5.584   142.770     0.150
     5.742    84.348     0.150
     6.136    91.168     0.150
     6.150   156.598     0.150
     6.206    92.367     0.150
     6.206   158.570     0.150
     6.616    97.867     0.150
     7.161   106.168     0.150
     7.789   115.570     0.150
     7.789   113.340     0.150
     7.789   195.141     0.150
    17.769   247.289     0.150
     1.505    50.340     0.150
     1.713    30.387     0.150
     5.292   139.699     0.150
     6.188   162.199     0.150
     0.880    33.967     0.150
     1.517    52.442     0.150
     1.597    54.142     0.150
     1.770    60.459     0.150
     2.985    52.929     0.150
     2.985    52.929     0.150
     2.985    87.959     0.150
     3.509    59.559     0.150
     3.509    59.559     0.150
     3.509   100.189     0.150
     4.871   134.559     0.150
     5.208    78.809     0.150
     5.208   136.709     0.150
     5.297    79.809     0.150
     5.297   139.209     0.150
     5.425    81.909     0.150
     5.508    83.309     0.150
     5.508   143.909     0.150
     5.600    85.409     0.150
     5.600   146.609     0.150
     5.747    87.009     0.150
     5.747   149.809     0.150
     5.846    87.909     0.150
     5.846   152.109     0.150
     5.893    89.909     0.150
     5.893   153.309     0.150
     6.191    92.209     0.150
     6.191   160.909     0.150
     6.438    96.109     0.150
     6.999   103.609     0.150
     6.999   181.409     0.150
     7.174   106.109     0.150
     7.174   183.509     0.150
     7.590   112.109     0.150
     7.590   193.709     0.150
     7.672   112.298     0.150
     8.148   119.409     0.150
     8.148   208.209     0.150
     8.513   125.609     0.150
     8.835   129.309     0.150
     9.031   131.909     0.150
     9.444   138.309     0.150
     9.504   139.109     0.150
     9.793   144.509     0.150
     9.793   144.509     0.150
     0.310    10.299     0.150
     1.873    57.749     0.150
     2.352    75.106     0.150
     2.657    45.886     0.150
     3.717    62.494     0.150
     0.690    26.156     0.150
     0.787    18.117     0.150
     1.683    33.961     0.150
     1.697    34.883     0.150
     1.697    59.043     0.150
     1.697    34.883     0.150
     1.697    59.043     0.150
     1.808    35.504     0.150
     1.808    63.332     0.150
     1.821    36.355     0.150
     2.278    45.555     0.150
     2.278    35.812     0.150
     2.278    61.684     0.150
     2.219    41.738     0.150
     2.286    40.941     0.150
     2.877    52.746     0.150
     3.465    61.875     0.150
     4.568    70.684     0.150
     4.568   118.883     0.150
     4.603   119.184     0.150
     4.603    69.785     0.150
     4.603   119.184     0.150
     4.935    75.184     0.150
     4.935   128.582     0.150
     5.197    78.984     0.150
     5.197   136.684     0.150
     5.550    83.582     0.150
     5.550   143.684     0.150
     5.689    85.582     0.150
     5.689   146.984     0.150
     6.239    92.582     0.150
     6.239   160.785     0.150
     6.704    99.383     0.150
     1.450    29.738     0.150
     1.450    52.066     0.150
     1.826    33.918     0.150
     1.826    57.848     0.150
     1.694    32.789     0.150
     1.694    57.688     0.150
     4.697    68.703     0.150
     4.697   120.902     0.150
     4.754    69.902     0.150
     4.754   121.203     0.150
     4.782    68.949     0.150
     5.066    74.801     0.150
     5.066   129.402     0.150
     5.077    75.602     0.150
     5.077   129.500     0.150
     5.020    72.961     0.150
     5.020   126.961     0.150
     5.294    78.602     0.150
     5.294   135.102     0.150
     5.685    83.402     0.150
     5.685   144.703     0.150
     6.425    93.102     0.150
     6.425   161.703     0.150
     6.407   158.859     0.150
     6.945   100.203     0.150
     0.439    20.005     0.150
     0.766    30.282     0.150
     1.496    49.762     0.150
     1.924    89.812     0.150
     2.414    46.388     0.150
     2.854    48.910     0.150
     3.277    55.839     0.150
     3.652    56.952     0.150
     3.652    98.552     0.150
     3.719    97.739     0.150
     3.719    57.952     0.150
     3.719   100.151     0.150
     3.859    59.021     0.150
     3.859   103.189     0.150
     4.011    63.751     0.150
     3.882    65.136     0.150
     3.882   112.236     0.150
     4.240    66.651     0.150
     4.240   114.151     0.150
     4.273   116.640     0.150
     4.641    70.452     0.150
     4.641   122.352     0.150
     4.846    73.751     0.150
     4.846   128.151     0.150
     5.405    81.151     0.150
     5.405   142.151     0.150
     5.553    83.452     0.150
     5.553   144.151     0.150
     5.968    89.651     0.150
     0.408    19.512     0.150
     0.628    24.555     0.150
     0.632    22.875     0.150
     3.040    88.449     0.150
     3.452    52.406     0.150
     4.719   117.926     0.150
     0.565    22.465     0.150
     1.731    32.559     0.150
     1.731    50.367     0.150
     1.713    32.371     0.150
     3.564    99.648     0.150
     4.693   125.461     0.150
     0.165     7.086     0.150
     1.776    33.805     0.150
     1.776    58.941     0.150
     2.083    27.855     0.150
     2.083    65.684     0.150
     4.850    73.844     0.150
     5.096   134.043     0.150
     0.667    12.801     0.150
     0.667    22.066     0.150
     0.702    22.730     0.150
     1.288    42.559     0.150
     1.502    49.914     0.150
     2.010    64.789     0.150
     2.010    37.809     0.150
     2.010    64.789     0.150
     3.697    95.309     0.150
     4.039    59.668     0.150
     4.607    67.863     0.150
     4.607   116.309     0.150
     7.764   110.805     0.150
     7.764   191.832     0.150
     0.522    21.902     0.150
     0.765    17.070     0.150
     0.765    30.965     0.150
     0.873    15.834     0.150
     0.873    31.002     0.150
     0.893    17.654     0.150
     0.893    33.314     0.150
     1.403    49.969     0.150
     1.806    29.361     0.150
     1.806    58.051     0.150
     2.443    77.555     0.150
     3.695    61.184     0.150
     3.795    61.102     0.150
     0.952    32.461     0.150
     0.952    19.508     0.150
     0.952    32.461     0.150
     1.273    23.586     0.150
     1.273    39.430     0.150
     1.211    42.117     0.150
     1.358    24.109     0.150
     1.358    39.797     0.150
     1.638    49.891     0.150
     2.041    37.750     0.150
     2.041    57.789     0.150
     2.498    41.016     0.150
     2.498    70.180     0.150
     2.902    80.258     0.150
     3.821    58.203     0.150
     4.431    67.914     0.150
     4.431   117.516     0.150
     4.452    67.914     0.150
     4.452   117.117     0.150
     4.773    72.617     0.150
     4.773   125.914     0.150
     4.945    75.117     0.150
     4.945   129.719     0.150
     5.134    77.320     0.150
     5.134   134.719     0.150
     5.242   139.453     0.150
     5.383    81.117     0.150
     5.383   140.117     0.150
     5.354    82.781     0.150
     5.409    82.016     0.150
     5.409   140.117     0.150
     5.861    88.219     0.150
     5.861   151.414     0.150
     6.554    98.516     0.150
     6.767   175.617     0.150
     0.683    22.134     0.150
     0.766    24.433     0.150
     1.528    52.294     0.150
     1.718    53.979     0.150
     1.718    31.899     0.150
     1.718    36.439     0.150
     1.718    53.979     0.150
     2.385    39.850     0.150
     2.385    70.009     0.150
     3.247    52.919     0.150
     3.247    88.100     0.150
     4.433    66.999     0.150
     4.433   115.999     0.150
     4.476    67.600     0.150
     4.476   116.600     0.150
     4.805    72.799     0.150
     4.805   125.399     0.150
     4.831    73.600     0.150
     4.831   126.600     0.150
     4.934    74.899     0.150
     4.934   127.299     0.150
     5.052    76.999     0.150
     5.052   131.199     0.150
     5.074    76.600     0.150
     5.074   131.799     0.150
     5.418    81.699     0.150
     5.418   140.799     0.150
     5.573    83.499     0.150
     5.573   143.100     0.150
     6.204    92.199     0.150
     6.204   158.399     0.150
     6.615    97.799     0.150
     6.615   167.600     0.150
     6.896   173.930     0.150
     7.103   104.699     0.150
     7.162   104.899     0.150
     7.162   182.699     0.150
     7.545   110.399     0.150
     7.545   191.199     0.150
     8.036   203.699     0.150
     8.147   118.999     0.150
     8.147   205.600     0.150
     8.378   122.100     0.150
     8.378   210.399     0.150
     8.520   123.899     0.150
     8.520   213.999     0.150
     8.818   128.299     0.150
     8.818   221.899     0.150
     3.721   105.975     0.150
     3.612    60.407     0.150
     1.111    40.293     0.150
     2.028    64.406     0.150
     0.185     6.844     0.150
     0.663    21.281     0.150
     0.743    23.828     0.150
     1.554    52.555     0.150
     1.723    32.742     0.150
     1.723    34.562     0.150
     1.723    55.508     0.150
     1.872    36.945     0.150
     2.109    38.008     0.150
     2.318    49.359     0.150
     1.571    52.211     0.150
     4.473    68.078     0.150
     4.518    68.377     0.150
     4.518   118.078     0.150
     4.846   126.078     0.150
     4.866    72.979     0.150
     4.866   127.777     0.150
     5.089    76.877     0.150
     5.458    81.377     0.150
     6.254    91.877     0.150
     1.801    58.113     0.150
     1.884    36.583     0.150
     1.884    62.695     0.150
     5.037    74.693     0.150
     5.037   130.693     0.150
     5.050    74.893     0.150
     5.050   131.193     0.150
     5.388    80.293     0.150
     5.388   139.293     0.150
     5.464   141.793     0.150
     5.479    81.173     0.150
     5.479   141.993     0.150
     5.616    83.293     0.150
     5.616   145.893     0.150
     5.639    83.013     0.150
     5.639   142.613     0.150
     5.689    83.893     0.150
     5.689   147.193     0.150
     6.004    87.993     0.150
     6.004   153.993     0.150
     6.097    89.493     0.150
     6.097   155.993     0.150
     6.150   160.951     0.150
     6.633    97.393     0.150
     6.633   169.793     0.150
     6.636    97.293     0.150
     6.636   169.793     0.150
     6.876   101.976     0.150
     7.033   103.093     0.150
     7.564   110.893     0.150
     7.585   110.193     0.150
     7.585   110.193     0.150
     3.319    52.652     0.150
     0.896    32.238     0.150
     3.811    56.512     0.150
     3.811    97.512     0.150
     4.133    61.934     0.150
     4.133    61.910     0.150
     4.133   106.410     0.150
     4.133    61.512     0.150
     4.133   106.312     0.150
     4.358    65.613     0.150
     4.385    64.371     0.150
     4.742    69.512     0.150
     4.742   120.012     0.150
     4.927    72.012     0.150
     5.484    79.512     0.150
     5.484   137.910     0.150
     5.607    81.812     0.150
     5.607   141.012     0.150
     1.570    32.432     0.150
     1.783    32.973     0.150
     1.783    56.283     0.150
     1.765    35.432     0.150
     4.471    67.162     0.150
     4.471   115.562     0.150
     4.517    67.662     0.150
     4.517   115.764     0.150
     4.503   116.439     0.150
     4.844   125.863     0.150
     4.864    73.363     0.150
     4.864   126.062     0.150
     5.087    76.764     0.150
     5.087   130.363     0.150
     5.096    75.523     0.150
     5.096   131.264     0.150
     5.457    81.764     0.150
     5.457   140.363     0.150
     5.617    83.363     0.150
     5.617   142.764     0.150
     6.171    90.662     0.150
     6.171   157.463     0.150
     6.254    92.062     0.150
     0.724    15.391     0.150
     1.355    27.641     0.150
     2.270    66.844     0.150
     2.270    40.375     0.150
     2.270    66.844     0.150
     2.854    73.172     0.150
     3.775    57.234     0.150
     3.775   100.434     0.150
     4.735    70.895     0.150
     4.735   122.395     0.150
     4.800    71.695     0.150
     4.800   123.695     0.150
     4.800    71.719     0.150
     5.028    74.793     0.150
     5.028    74.848     0.150
     5.088    75.492     0.150
     5.088    75.492     0.150
     5.088   130.895     0.150
     5.118    76.195     0.150
     5.118   131.195     0.150
     5.319    78.895     0.150
     5.319   136.992     0.150
     5.328    79.293     0.150
     5.328   136.195     0.150
     5.369    79.492     0.150
     5.369   136.312     0.150
     5.369    79.492     0.150
     5.414    80.195     0.150
     5.414   138.992     0.150
     5.723    84.395     0.150
     5.723   145.094     0.150
     5.803   146.383     0.150
     5.923    87.492     0.150
     5.923   150.492     0.150
     6.482    94.895     0.150
     6.482   165.094     0.150
     6.607    96.992     0.150
     6.607   167.293     0.150
     6.703    97.934     0.150
     6.703   168.867     0.150
     7.021   102.594     0.150
     7.021   175.793     0.150
     7.471   108.492     0.150
     7.574   110.293     0.150
     7.574   192.195     0.150
     7.949   115.594     0.150
     7.949   198.793     0.150
     8.234   119.395     0.150
     8.453   122.395     0.150
     8.453   212.492     0.150
     8.516   122.895     0.150
     8.563   123.895     0.150
     8.563   214.195     0.150
     8.830   127.094     0.150
     8.830   220.195     0.150
     8.933   128.895     0.150
     8.933   222.195     0.150
     9.227   132.895     0.150
     9.227   230.492     0.150
    10.276   256.465     0.150
    77.629   715.828     0.150
     2.443    49.242     0.150
     2.964   100.180     0.150
     2.964    57.727     0.150
     2.964   100.180     0.150
     3.468    56.742     0.150
     3.468    97.625     0.150
     3.653    70.180     0.150
     3.653   118.914     0.150
     3.653    70.180     0.150
     3.653   118.914     0.150
     5.147    77.977     0.150
     5.147   133.570     0.150
     5.238    79.172     0.150
     5.238   134.977     0.150
     5.540    83.773     0.150
     5.540   143.773     0.150
     5.684    85.672     0.150
     5.684   147.070     0.150
     5.839    87.375     0.150
     5.839   150.570     0.150
     5.864    88.172     0.150
     5.864   151.375     0.150
     6.380    95.172     0.150
     6.380    95.172     0.150
     6.380   163.875     0.150
     6.609    98.070     0.150
     6.941   102.672     0.150
     6.941   176.773     0.150
     7.141   105.875     0.150
     7.120   105.273     0.150
     7.120   182.172     0.150
     7.518   106.219     0.150
     7.360   184.180     0.150
     7.537   110.977     0.150
     7.537   189.773     0.150
     8.062   201.008     0.150
     7.941   116.773     0.150
     7.941   201.477     0.150
     8.095   119.172     0.150
     8.101   119.070     0.150
     8.101   205.867     0.150
     8.459   124.477     0.150
     8.978   130.570     0.150
     8.978   227.273     0.150
     9.086   132.273     0.150
     9.086   228.273     0.150
     9.396   136.672     0.150
     9.396   236.570     0.150
     9.451   137.172     0.150
     9.728   140.773     0.150
     9.728   247.477     0.150
     0.698    12.725     0.150
     0.698    21.562     0.150
     0.852    30.400     0.150
     2.949    80.570     0.150
     3.884    60.309     0.150
     3.884   102.107     0.150
     3.960    61.209     0.150
     3.960   104.107     0.150
     4.456   116.908     0.150
     4.534    68.008     0.150
     4.534   116.107     0.150
     4.872    73.408     0.150
     4.872   126.008     0.150
     5.815   147.008     0.150
     0.652    14.625     0.150
     0.652    24.000     0.150
     1.302    26.633     0.150
     1.444    50.516     0.150
     1.968    34.992     0.150
     1.968    64.297     0.150
     1.968    34.992     0.150
     1.968    64.297     0.150
     3.919    60.164     0.150
     3.919   102.664     0.150
     3.919    61.836     0.150
     3.919   110.984     0.150
     3.976   102.594     0.150
     4.502    69.461     0.150
     4.502   120.062     0.150
     5.068   128.812     0.150
     1.305    26.564     0.150
     1.305    44.514     0.150
     1.334    25.318     0.150
     1.334    18.734     0.150
     1.334    39.844     0.150
     1.448    44.555     0.150
     1.572    52.465     0.150
     1.588    52.006     0.150
     1.932    64.055     0.150
     2.404    70.334     0.150
     3.342   104.484     0.150
     4.207   116.051     0.150
     4.794    73.555     0.150
     4.794   126.254     0.150
     4.815    73.754     0.150
     4.815   127.854     0.150
     5.018    75.754     0.150
     5.018   133.354     0.150
     5.137    77.953     0.150
     5.137   135.654     0.150
     5.495   144.453     0.150
     5.747    86.055     0.150
     5.747   148.754     0.150
     6.215    93.154     0.150
     6.291    93.654     0.150
     0.417    17.945     0.150
     1.020    33.023     0.150
     1.196    39.445     0.150
     1.727    33.461     0.150
     2.104    39.891     0.150
     2.104    66.055     0.150
     2.164    69.602     0.150
     2.164    41.438     0.150
     3.232    93.219     0.150
     3.598    58.883     0.150
     4.963   134.891     0.150
     1.089    41.383     0.150
     1.353    26.586     0.150
     1.396    51.430     0.150
     1.449    30.164     0.150
     3.900    62.328     0.150
     3.900    62.328     0.150
     3.900   103.023     0.150
     4.165    64.828     0.150
     4.165   111.727     0.150
     4.212   111.727     0.150
     4.474    69.430     0.150
     5.756   147.930     0.150
     0.764    11.531     0.150
     0.764    21.425     0.150
     0.788    28.794     0.150
     1.420    40.442     0.150
     1.885    37.062     0.150
     1.885    64.222     0.150
     1.885    37.062     0.150
     1.885    64.222     0.150
     2.743    46.019     0.150
     2.962    50.487     0.150
     3.077    51.228     0.150
     2.999    84.946     0.150
     3.626    57.401     0.150
     3.895    59.731     0.150
     3.895    59.731     0.150
     3.895   102.432     0.150
     3.967    60.632     0.150
     3.967    60.632     0.150
     3.967   101.632     0.150
     4.281    64.531     0.150
     4.281   109.332     0.150
     4.473    67.031     0.150
     4.473   116.231     0.150
     4.530    67.832     0.150
     4.530   117.531     0.150
     4.529    67.031     0.150
     4.883   126.531     0.150
     5.091   126.261     0.150
     5.810    84.531     0.150
     5.810   145.731     0.150
     3.476    88.602     0.150
     4.195   108.344     0.150
     4.742    68.688     0.150
     4.742   116.789     0.150
     0.640    15.086     0.150
     0.640    23.445     0.150
     1.423    48.086     0.150
     1.880    65.516     0.150
     2.351    78.586     0.150
     3.526    59.086     0.150
     5.275    78.703     0.150
     5.512    82.117     0.150
     6.411    96.617     0.150
     6.626    97.539     0.150
     2.150    62.570     0.150
     2.668    45.734     0.150
     2.668    82.508     0.150
     3.167    90.031     0.150
     3.300    93.430     0.150
     3.376    96.078     0.150
     3.722   103.648     0.150
     4.540    67.023     0.150
     5.528    81.461     0.150
     6.892    94.664     0.150
     4.050    60.203     0.150
     4.050   101.102     0.150
     3.708    61.393     0.150
     0.570    11.742     0.150
     2.480    48.289     0.150
     2.480    80.117     0.150
     4.052   112.562     0.150
     4.874   132.742     0.150
     7.171   105.961     0.150
     0.864    18.473     0.150
     0.864    33.250     0.150
     0.998    20.027     0.150
     1.767    32.277     0.150
     1.906    62.445     0.150
     2.634    78.527     0.150
     5.333   142.777     0.150
     0.944    24.482     0.150
     1.287    39.898     0.150
     1.299    46.424     0.150
     2.082    37.486     0.150
     2.703    80.150     0.150
     3.084    93.473     0.150
     3.339    55.510     0.150
     3.555   101.473     0.150
     3.800   106.234     0.150
     3.872    64.551     0.150
     3.872    64.551     0.150
     4.503    71.914     0.150
     5.272    79.824     0.150
     5.272   141.939     0.150
     5.369   144.283     0.150
     5.459    82.133     0.150
     5.885   159.658     0.150
     6.417    95.934     0.150
     8.204   210.414     0.150
     9.661   139.135     0.150
    11.369   287.936     0.150
     1.354    25.086     0.150
     1.525    51.406     0.150
     2.015    34.938     0.150
     1.874    33.891     0.150
     2.299    74.406     0.150
     4.878    73.094     0.150
     5.183    79.262     0.150
     5.269    79.328     0.150
     0.756    28.355     0.150
     2.112    39.693     0.150
     2.438    72.602     0.150
     4.489   121.436     0.150
     4.846    73.205     0.150
     5.747   151.734     0.150
     0.193     7.711     0.150
     0.252     8.723     0.150
     1.992    37.828     0.150
     1.993    64.203     0.150
     2.632    41.805     0.150
     5.959    88.062     0.150
     1.278    27.938     0.150
     1.278    27.938     0.150
     2.056    59.703     0.150
     2.056    36.117     0.150
     3.461    99.828     0.150
     3.544   100.965     0.150
     4.692    64.430     0.150
     5.341   137.652     0.150
     5.432   140.297     0.150
     5.505    82.414     0.150
     5.509   135.266     0.150
     5.601    83.820     0.150
     5.623   140.816     0.150
     5.623    84.133     0.150
     5.726    85.922     0.150
     5.910   144.625     0.150
     6.062    88.488     0.150
     6.088   152.637     0.150
     6.636   165.230     0.150
     6.825   100.957     0.150
     6.825   174.629     0.150
     6.869   171.168     0.150
     7.658   185.574     0.150
     8.143   120.188     0.150
     8.680   122.891     0.150
     9.206   131.988     0.150
     1.380    45.984     0.150
     2.557    74.570     0.150
     4.292    64.094     0.150
     4.915    71.870     0.150
     0.541    10.250     0.150
     0.541    17.938     0.150
     1.031    29.812     0.150
     1.149    23.977     0.150
     1.281    26.539     0.150
     1.281    44.836     0.150
     1.695    49.469     0.150
     2.007    56.422     0.150
     2.472    71.914     0.150
     4.414    68.680     0.150
     4.414   116.578     0.150
     5.303    80.078     0.150
     5.303   133.961     0.150
     0.786    30.266     0.150
     0.770    31.641     0.150
     1.076    16.242     0.150
     1.076    29.500     0.150
     1.711    23.656     0.150
     1.711    45.828     0.150
     1.830    25.461     0.150
     1.830    46.164     0.150
     1.893    25.203     0.150
     1.893    47.250     0.150
     1.982    27.609     0.150
     3.378    91.070     0.150
     3.371    94.469     0.150
     3.590    51.969     0.150
     3.643    58.031     0.150
     3.643   102.383     0.150
     3.843    53.727     0.150
     4.648   120.688     0.150
     4.647   121.547     0.150
     4.804   121.703     0.150
     4.804    69.680     0.150
     4.807   123.367     0.150
     5.144    75.094     0.150
     5.304   138.586     0.150
     1.298    28.031     0.150
     1.818    54.805     0.150
     0.496    22.043     0.150
     0.807    11.543     0.150
     0.807    21.180     0.150
     0.946    11.477     0.150
     0.946    21.848     0.150
     0.940    33.297     0.150
     1.221    40.344     0.150
     1.342    43.531     0.150
     2.971    83.871     0.150
     2.974    82.543     0.150
     3.104    50.043     0.150
     3.104    87.938     0.150
     3.197    88.836     0.150
     3.598    99.707     0.150
     4.018    57.879     0.150
     4.065    58.703     0.150
     4.311    63.719     0.150
     5.085    73.699     0.150
     0.796    15.461     0.150
     2.679    77.539     0.150
     3.653   111.336     0.150
     3.653    66.375     0.150
     4.644   122.145     0.150
     4.804    72.242     0.150
     5.687   144.918     0.150
     7.019   181.432     0.150
     4.475    63.363     0.150
     5.839    85.463     0.150
     2.318    42.883     0.150
     2.420    40.797     0.150
     1.498    29.755     0.150
     1.498    51.390     0.150
     1.636    52.832     0.150
     4.748    70.938     0.150
     1.530    30.883     0.150
     1.530    53.098     0.150
     2.408    38.184     0.150
     2.408    69.055     0.150
     4.128    63.898     0.150
     4.232    63.598     0.150
     4.887    73.156     0.150
     5.104    75.369     0.150
     2.163    66.805     0.150
     5.561    84.984     0.150
     5.592    86.766     0.150
     6.394    96.625     0.150
     0.434    13.750     0.150
     2.779    85.750     0.150
     4.892    73.168     0.150
     4.892   123.062     0.150
     5.194    77.254     0.150
     5.213    77.645     0.150
     5.401    80.324     0.150
     5.464    80.844     0.150
     5.950    87.949     0.150
     1.510    29.430     0.150
     2.190    70.344     0.150
     2.518    43.430     0.150
     0.153     8.645     0.150
     0.633    24.215     0.150
     1.771    55.941     0.150
     2.445    34.410     0.150
     3.763   104.121     0.150
     3.843    57.641     0.150
     4.749    69.320     0.150
     1.233    22.332     0.150
     2.876    87.258     0.150
     3.121    47.605     0.150
     3.483    52.434     0.150
     3.789    56.871     0.150
     3.969   103.039     0.150
     4.052    62.027     0.150
     4.293    63.762     0.150
     4.491    67.172     0.150
     4.955    73.152     0.150
     5.214    76.535     0.150
     0.467    15.633     0.150
     0.774    29.875     0.150
     2.220    32.742     0.150
     3.599   101.703     0.150
     3.801    57.883     0.150
     3.801   104.180     0.150
     4.363    66.562     0.150
     4.480    70.633     0.150
     4.480   120.578     0.150
     4.852    75.867     0.150
     4.864    72.422     0.150
     0.745    28.008     0.150
     1.230    35.513     0.150
     2.341    37.968     0.150
     2.737    42.889     0.150
     2.889    77.864     0.150
     3.923    59.789     0.150
     4.431   121.534     0.150
     5.254    80.281     0.150
     5.588    83.907     0.150
     5.908    88.024     0.150
     6.531    97.612     0.150
     0.540    16.695     0.150
     1.881    62.023     0.150
     1.903    33.180     0.150
     5.172    77.250     0.150
     5.806    87.234     0.150
     0.480    20.000     0.150
     1.483    50.195     0.150
     3.522   101.781     0.150
     4.871    71.188     0.150
     1.134    23.242     0.150
     1.735    34.305     0.150
     1.759    34.375     0.150
     1.759    58.062     0.150
     1.990    63.633     0.150
     2.107    66.914     0.150
     2.436    48.766     0.150
     2.436    46.805     0.150
     2.438    77.758     0.150
     2.769    81.992     0.150
     4.076   111.773     0.150
     4.883    73.758     0.150
     5.348    95.898     0.150
     5.549    82.758     0.150
     5.579   139.984     0.150
     5.813    89.242     0.150
     5.813    89.289     0.150
     5.866    87.227     0.150
     6.028   152.758     0.150
     6.125    90.695     0.150
     6.624   100.156     0.150
     6.657   167.523     0.150
     6.829   100.859     0.150
     7.665   189.852     0.150
     8.193   120.195     0.150
     8.563   220.359     0.150
    11.981   172.852     0.150
    18.436   257.461     0.150
    19.246   266.156     0.150
    20.081   489.195     0.150
    21.252   287.711     0.150
    21.300   286.125     0.150
    22.515   300.305     0.150
    22.806   303.398     0.150
    22.806     4.102     0.150
    22.806     5.500     0.150
    22.870   308.898     0.150
    22.870   304.766     0.150
    22.884   309.781     0.150
    25.482   334.297     0.150
    25.509   327.508     0.150
    58.449   596.516     0.150
    63.504     3.500     0.150
    64.124   633.992     0.150
    78.427   722.875     0.150
     0.823    26.066     0.150
     0.962    31.018     0.150
     1.102    33.354     0.150
     1.703    45.338     0.150
     2.163    63.586     0.150
     4.336    63.395     0.150
     4.750    68.609     0.150
     4.821    69.705     0.150
     5.094    73.238     0.150
     0.401    16.531     0.150
     0.869    30.969     0.150
     0.891    15.430     0.150
     0.891    26.539     0.150
     1.157    40.633     0.150
     1.531    26.438     0.150
     1.424    47.148     0.150
     1.539    50.273     0.150
     1.669    32.273     0.150
     2.345    69.148     0.150
     2.401    74.641     0.150
     3.672    97.414     0.150
     3.781    56.859     0.150
     3.821    56.445     0.150
     4.071    58.844     0.150
     4.265    62.672     0.150
     4.842    70.773     0.150
     5.420    82.312     0.150
     0.719    27.109     0.150
     3.226    87.469     0.150
     3.695   108.453     0.150
     4.682   126.250     0.150
     0.731    30.391     0.150
     2.147    65.166     0.150
     4.731    77.104     0.150
     5.402   143.959     0.150
     5.559   148.484     0.150
     5.958    91.014     0.150
     6.753   104.215     0.150
     6.753    99.092     0.150
     1.233    45.777     0.150
     1.282    45.816     0.150
     1.554    53.285     0.150
     1.726    56.734     0.150
     2.504    76.215     0.150
     5.169   140.824     0.150
     5.713    84.590     0.150
     5.916    87.723     0.150
     6.396    95.625     0.150
     6.396   164.805     0.150
     1.770    58.630     0.150
     3.292    95.923     0.150
     3.830    57.828     0.150
     3.830    61.260     0.150
     3.830   104.582     0.150
     3.861    57.948     0.150
     5.122   137.007     0.150
     0.815    32.203     0.150
     0.815    17.783     0.150
     0.905    18.322     0.150
     0.905    31.950     0.150
     0.909    18.793     0.150
     0.909    33.833     0.150
     0.909    18.793     0.150
     0.909    33.833     0.150
     0.909    18.793     0.150
     0.909    33.833     0.150
     1.169    18.423     0.150
     1.169    32.022     0.150
     1.130    42.574     0.150
     1.130    23.803     0.150
     1.402    49.426     0.150
     1.537    47.256     0.150
     1.517    52.541     0.150
     1.517    29.765     0.150
     1.517    29.765     0.150
     1.660    28.186     0.150
     1.942    31.972     0.150
     2.333    70.823     0.150
     2.676    41.642     0.150
     3.185    95.249     0.150
     3.200    51.737     0.150
     3.306    52.319     0.150
     3.757    53.638     0.150
     3.757    97.478     0.150
     3.862    60.708     0.150
     4.113    62.518     0.150
     0.859    31.214     0.150
     3.876   100.033     0.150
     3.952   106.487     0.150
     0.903    14.984     0.150
     0.903    25.953     0.150
     4.253    60.281     0.150
     4.253   105.500     0.150
     4.392    64.742     0.150
     0.948    26.508     0.150
     0.948    15.371     0.150
     1.613    24.488     0.150
     1.613    40.633     0.150
     2.450    37.484     0.150
     2.539    65.371     0.150
     2.539    37.898     0.150
     2.539    38.133     0.150
     3.253    47.512     0.150
     4.412    64.746     0.150
     4.871   122.297     0.150
     7.840   190.727     0.150
     0.892    17.125     0.150
     0.892    27.531     0.150
     1.995    59.031     0.150
     2.482    66.547     0.150
     1.284    45.992     0.150
     2.096    67.707     0.150
     5.195    80.434     0.150
     5.545    83.344     0.150
     0.312    17.334     0.150
     0.915    29.822     0.150
     0.915    29.318     0.150
     4.262   106.697     0.150
     4.350    66.465     0.150
     4.798   121.307     0.150
     4.833    74.096     0.150
     4.911    74.664     0.150
     4.911   124.592     0.150
     5.071    77.133     0.150
     5.485    82.020     0.150
     6.526    97.336     0.150
     0.874    27.172     0.150
     0.874    15.875     0.150
     0.874    26.531     0.150
     1.072    33.156     0.150
     1.072    20.219     0.150
     1.506    46.875     0.150
     2.032    58.633     0.150
     2.431    67.938     0.150
     3.156    45.766     0.150
     4.279    62.617     0.150
     4.505    65.664     0.150
     4.868   121.070     0.150
     4.936    71.828     0.150
     5.510    79.555     0.150
     5.683    82.289     0.150
     6.993   101.094     0.150
     7.189    99.266     0.150
     0.269    14.016     0.150
     0.914    16.939     0.150
     1.060    34.145     0.150
     1.319    44.166     0.150
     1.436    46.060     0.150
     1.676    32.188     0.150
     1.676    56.811     0.150
     2.524    42.834     0.150
     3.064    49.882     0.150
     3.217    92.586     0.150
     3.687   104.481     0.150
     3.799   107.030     0.150
     3.875    60.901     0.150
     4.231    66.057     0.150
     4.219    64.674     0.150
     4.241    65.846     0.150
     4.241   116.470     0.150
     4.618   127.543     0.150
     5.310   134.084     0.150
     5.995    81.903     0.150
     5.995   140.334     0.150
     6.299   157.794     0.150
     0.222     9.828     0.150
     1.263    43.969     0.150
     1.532    50.359     0.150
     1.522    25.070     0.150
     1.663    54.109     0.150
     2.549    74.812     0.150
     4.311    66.812     0.150
     4.350    65.469     0.150
     5.349   136.250     0.150
     5.411   140.734     0.150
     3.896    61.074     0.150
     4.165    65.535     0.150
     0.549    11.844     0.150
     0.549    12.672     0.150
     0.549    12.672     0.150
     0.549    12.672     0.150
     0.795    25.727     0.150
     0.795    15.992     0.150
     0.795    15.992     0.150
     0.795    15.820     0.150
     0.795    15.820     0.150
     0.795    15.820     0.150
     0.795    15.820     0.150
     1.156    20.500     0.150
     1.156    36.500     0.150
     1.156    23.664     0.150
     1.156    23.664     0.150
     1.156    23.664     0.150
     1.156    25.664     0.150
     1.156    25.664     0.150
     1.095    40.211     0.150
     1.095    21.945     0.150
     1.095    21.945     0.150
     1.095    21.945     0.150
     1.095    22.094     0.150
     1.095    22.094     0.150
     1.095    22.094     0.150
     1.197    23.867     0.150
     1.197    23.867     0.150
     1.197    23.844     0.150
     1.197    23.844     0.150
     1.197    23.820     0.150
     1.197    23.820     0.150
     1.197    23.820     0.150
     1.197    23.820     0.150
     1.221    22.812     0.150
     1.221    22.812     0.150
     1.221    22.812     0.150
     1.221    22.812     0.150
     1.221    22.812     0.150
     1.706    33.117     0.150
     1.706    33.117     0.150
     1.706    33.117     0.150
     1.706    33.117     0.150
     1.706    33.117     0.150
     1.706    33.117     0.150
     1.706    33.117     0.150
     1.706    33.117     0.150
     1.677    30.836     0.150
     1.677    31.141     0.150
     1.677    31.141     0.150
     1.677    30.836     0.150
     1.677    30.836     0.150
     1.677    30.836     0.150
     1.677    30.836     0.150
     1.889    34.492     0.150
     1.889    34.492     0.150
     1.889    34.344     0.150
     1.889    34.492     0.150
     1.999    34.664     0.150
     1.999    41.664     0.150
     1.999    41.664     0.150
     1.999    41.664     0.150
     1.999    41.664     0.150
     2.302    40.664     0.150
     2.302    41.664     0.150
     2.302    41.664     0.150
     2.302    41.664     0.150
     2.047    36.102     0.150
     2.047    37.664     0.150
     2.047    37.664     0.150
     2.047    37.664     0.150
     2.461    41.234     0.150
     2.461    41.234     0.150
     2.461    41.234     0.150
     2.461    41.234     0.150
     2.461    41.234     0.150
     2.461    48.672     0.150
     2.461    48.672     0.150
     2.461    48.672     0.150
     2.461    48.672     0.150
     2.554    43.156     0.150
     2.554    43.156     0.150
     2.554    43.156     0.150
     2.861    83.227     0.150
     2.985    49.680     0.150
     2.985    49.680     0.150
     2.985    49.680     0.150
     2.985    50.664     0.150
     3.303    94.078     0.150
     3.303    55.664     0.150
     3.303    55.664     0.150
     3.303    55.664     0.150
     3.303    55.664     0.150
     3.366    95.922     0.150
     3.366    56.695     0.150
     3.366    56.695     0.150
     3.366    56.695     0.150
     3.366    56.695     0.150
     3.260    52.664     0.150
     3.260    52.664     0.150
     3.260    52.664     0.150
     3.260    60.781     0.150
     3.260    60.781     0.150
     3.260    60.781     0.150
     3.663    59.672     0.150
     3.663    59.664     0.150
     3.663    59.672     0.150
     4.466   113.023     0.150
     5.039    75.883     0.150
     5.039   134.508     0.150
     5.039    75.883     0.150
     5.039    75.883     0.150
     5.039    76.227     0.150
     5.097   130.195     0.150
     5.197   139.586     0.150
     5.197    79.148     0.150
     5.197    79.148     0.150
     5.197    79.148     0.150
     5.197    79.148     0.150
     5.497   146.742     0.150
     5.662   144.578     0.150
     6.175   157.156     0.150
     6.394   169.516     0.150
     6.394    94.688     0.150
     6.394    94.688     0.150
     6.749   165.258     0.150
     7.382   182.648     0.150
     9.518   139.398     0.150
     0.552    12.383     0.150
     0.552    13.195     0.150
     0.552    13.195     0.150
     0.552    13.195     0.150
     0.552    13.195     0.150
     0.808    18.484     0.150
     0.808    18.484     0.150
     0.808    18.484     0.150
     0.808    16.258     0.150
     1.175    24.383     0.150
     1.175    24.383     0.150
     1.175    25.062     0.150
     1.175    24.383     0.150
     1.175    24.383     0.150
     1.175    24.383     0.150
     1.175    24.383     0.150
     1.151    37.086     0.150
     1.151    24.055     0.150
     1.151    25.055     0.150
     1.151    25.055     0.150
     1.151    43.055     0.150
     1.151    24.055     0.150
     1.151    25.055     0.150
     1.151    24.055     0.150
     1.151    25.055     0.150
     1.151    25.055     0.150
     1.151    25.055     0.150
     1.151    43.055     0.150
     1.116    22.633     0.150
     1.116    23.070     0.150
     1.116    23.070     0.150
     1.116    23.070     0.150
     1.116    23.070     0.150
     1.224    23.055     0.150
     1.224    24.055     0.150
     1.224    23.055     0.150
     1.224    24.055     0.150
     1.224    23.055     0.150
     1.224    24.055     0.150
     1.684    58.508     0.150
     1.684    58.508     0.150
     1.684    58.508     0.150
     1.699    32.055     0.150
     1.699    32.055     0.150
     1.699    32.055     0.150
     1.699    32.055     0.150
     1.699    32.055     0.150
     1.699    33.141     0.150
     1.984    37.062     0.150
     1.984    65.070     0.150
     1.984    37.062     0.150
     1.984    35.203     0.150
     1.984    37.062     0.150
     1.905    35.055     0.150
     1.905    35.117     0.150
     1.905    35.055     0.150
     1.905    35.117     0.150
     1.905    37.125     0.150
     1.905    35.055     0.150
     1.905    35.055     0.150
     1.905    35.055     0.150
     2.053    37.055     0.150
     2.053    67.055     0.150
     2.053    37.055     0.150
     2.053    37.055     0.150
     2.299    41.172     0.150
     2.299    43.055     0.150
     2.299    43.055     0.150
     2.299    41.172     0.150
     2.299    41.172     0.150
     2.299    43.055     0.150
     2.299    43.055     0.150
     2.299    43.055     0.150
     2.457    42.055     0.150
     2.457    42.055     0.150
     2.457    42.055     0.150
     2.457    42.055     0.150
     2.457    42.055     0.150
     2.569    44.055     0.150
     2.569    44.055     0.150
     2.569    45.055     0.150
     2.569    44.055     0.150
     2.569    44.055     0.150
     2.569    44.055     0.150
     2.983    87.625     0.150
     2.989    51.055     0.150
     2.989    51.055     0.150
     2.989    51.055     0.150
     3.258    61.055     0.150
     3.680    60.062     0.150
     5.175    80.836     0.150
     5.175    80.789     0.150
     5.175    80.789     0.150
     5.175    80.789     0.150
     6.728    96.023     0.150
     6.728   165.430     0.150
     8.012   116.297     0.150
     9.276   134.000     0.150
     1.871    35.734     0.150
     1.871    54.893     0.150
     2.870    82.398     0.150
     3.916    56.797     0.150
     3.916    99.807     0.150
     4.117    62.004     0.150
     4.252    63.408     0.150
     4.614   113.598     0.150
     5.688    80.777     0.150
     6.174    88.307     0.150
     7.515   184.047     0.150
     0.793    16.258     0.150
     0.793    26.434     0.150
     0.793    16.258     0.150
     0.793    16.258     0.150
     0.793    16.258     0.150
     0.793    26.434     0.150
     1.079    22.359     0.150
     1.079    22.359     0.150
     1.079    22.359     0.150
     1.079    22.359     0.150
     1.167    21.617     0.150
     1.167    36.570     0.150
     1.213    22.820     0.150
     1.213    22.820     0.150
     1.213    22.820     0.150
     1.213    40.301     0.150
     1.211    24.301     0.150
     1.211    24.301     0.150
     1.211    24.301     0.150
     1.211    24.301     0.150
     1.211    42.301     0.150
     1.662    31.828     0.150
     1.662    31.828     0.150
     1.662    31.828     0.150
     1.699    54.758     0.150
     2.003    64.301     0.150
     2.037    38.301     0.150
     2.037    38.301     0.150
     2.037    38.301     0.150
     2.037    65.352     0.150
     2.456    41.480     0.150
     2.456    41.480     0.150
     5.212    80.543     0.150
     5.289    81.062     0.150
     5.362    82.941     0.150
     5.610    85.160     0.150
     6.765   165.371     0.150
     1.081    37.164     0.150
     2.508    42.719     0.150
     3.397    50.523     0.150
     3.990    58.883     0.150
     4.549    67.516     0.150
     5.193    70.859     0.150
     5.193   122.008     0.150
     0.942    27.793     0.150
     3.390    51.926     0.150
     3.972   100.055     0.150
     5.186    71.246     0.150
     5.186   121.273     0.150
     0.813    29.785     0.150
     1.116    40.633     0.150
     1.178    24.188     0.150
     1.901    61.703     0.150
     3.957   102.791     0.150
     4.170    65.598     0.150
     4.170    65.744     0.150
     4.170    65.648     0.150
     4.483   115.652     0.150
     4.637   127.180     0.150
     4.921    74.838     0.150
     5.261    73.898     0.150
     5.512    82.170     0.150
     5.529    82.379     0.150
     5.569    83.029     0.150
     5.569    83.049     0.150
     5.585    83.143     0.150
     5.585   140.713     0.150
     5.603    83.418     0.150
     5.603    83.658     0.150
     5.742   154.875     0.150
     5.742    86.469     0.150
     5.884    87.268     0.150
     5.899    87.559     0.150
     5.925   149.398     0.150
     5.925    87.609     0.150
     5.925    87.199     0.150
     5.878    88.398     0.150
     6.000    88.848     0.150
     6.151   155.018     0.150
     6.151    91.018     0.150
     6.151    90.898     0.150
     6.151   154.998     0.150
     6.151    90.959     0.150
     6.192    94.064     0.150
     6.658    98.059     0.150
     6.658    98.088     0.150
     6.807    99.859     0.150
     6.807    99.799     0.150
     7.319   101.459     0.150
     7.319   176.299     0.150
     6.906   101.898     0.150
     7.038   105.318     0.150
     7.038   105.658     0.150
     7.083   106.846     0.150
     7.286   106.918     0.150
     8.286   124.705     0.150
     8.357   124.787     0.150
     8.551   213.920     0.150
     8.509   129.898     0.150
     8.721   135.498     0.150
     9.186   139.398     0.150
     9.514   138.838     0.150
     9.488   147.898     0.150
     9.548   146.898     0.150
     9.866   244.559     0.150
    10.212   149.209     0.150
    10.501   156.326     0.150
    10.612   153.229     0.150
    10.799   153.439     0.150
    10.945   271.385     0.150
    10.945   160.688     0.150
    11.161   166.398     0.150
    11.831   175.258     0.150
    13.039   183.498     0.150
    14.338   203.998     0.150
    14.338   207.049     0.150
    15.010   212.598     0.150
    15.709   222.938     0.150
    17.298   246.459     0.150
    17.783   249.998     0.150
    17.783   249.949     0.150
    18.318   255.598     0.150
    18.693   259.699     0.150
    18.693   260.898     0.150
    18.953   263.809     0.150
    19.015   264.688     0.150
    19.226   265.799     0.150
    20.127   624.223     0.150
    20.944   284.658     0.150
    20.966   285.059     0.150
    21.049   283.051     0.150
    21.049   285.148     0.150
    21.190   286.598     0.150
    21.190   286.459     0.150
    21.325   286.998     0.150
    21.951   297.598     0.150
    22.219   297.598     0.150
    22.239   297.299     0.150
    22.239   540.398     0.150
    22.246   299.199     0.150
    22.400   299.238     0.150
    22.531   304.998     0.150
    22.531   299.898     0.150
    22.531     2.000     0.150
    22.531   549.898     0.150
    22.531   549.898     0.150
    22.531   549.898     0.150
    22.564   301.498     0.150
    22.696   306.668     0.150
    22.700   303.799     0.150
    22.700   303.578     0.150
    23.159   307.537     0.150
    23.282   308.199     0.150
    23.324   308.598     0.150
    23.324   562.098     0.150
    23.411   308.998     0.150
    23.556   310.199     0.150
    23.556   311.098     0.150
    23.747   312.998     0.150
    23.768   312.998     0.150
    23.768   313.299     0.150
    23.902   570.998     0.150
    24.399   323.398     0.150
    24.410   319.699     0.150
    24.679   321.699     0.150
    24.753   324.498     0.150
    24.753   324.539     0.150
    24.927   322.998     0.150
    24.985   325.469     0.150
    25.417   328.938     0.150
    25.572   331.699     0.150
    25.623   331.658     0.150
    25.730   331.498     0.150
    25.787   331.898     0.150
    25.832   333.498     0.150
    26.243   336.678     0.150
    26.536   339.299     0.150
    27.118   344.398     0.150
    27.175   344.799     0.150
    27.924   350.598     0.150
    27.932   351.898     0.150
    28.975   359.398     0.150
    29.953   368.318     0.150
    30.452   374.898     0.150
    31.187   381.498     0.150
    31.187   382.199     0.150
    31.452   377.908     0.150
    31.452   377.908     0.150
    31.452   377.908     0.150
    31.452   449.668     0.150
    31.452   807.938     0.150
    31.452   377.898     0.150
    31.452   449.598     0.150
    31.452   687.199     0.150
    31.452   793.498     0.150
    34.843   411.898     0.150
    35.876   418.898     0.150
    35.876   516.598     0.150
    35.876   926.199     0.150
    36.262   937.098     0.150
    37.049   427.699     0.150
    40.530   459.699     0.150
    41.042   463.998     0.150
    44.454   495.898     0.150
    47.065   514.088     0.150
    48.549   524.318     0.150
    52.893   561.059     0.150
    58.114   594.998     0.150
    58.114   594.799     0.150
    61.238   616.699     0.150
    61.238   616.658     0.150
    63.167     3.199     0.150
    63.814   633.898     0.150
    64.625   639.498     0.150
    64.625   639.549     0.150
    64.625   639.639     0.150
    67.024   654.699     0.150
    70.950   675.898     0.150
    78.616   721.199     0.150
    78.699   721.699     0.150
    79.578     4.000     0.150
    81.856   740.699     0.150
    87.102   771.799     0.150
   140.979  1166.949     0.150
   142.200  1169.949     0.150
     1.890    61.734     0.150
     2.194    70.477     0.150
     2.784    45.914     0.150
     2.784    45.926     0.150
     2.770    75.438     0.150
     2.770    80.539     0.150
     3.106    95.215     0.150
     3.116    52.172     0.150
     3.116    91.992     0.150
     4.248    67.773     0.150
     4.432   114.898     0.150
     5.514   139.793     0.150
     5.572   140.832     0.150
     5.912    87.566     0.150
     7.306   101.430     0.150
     7.306   176.488     0.150
     1.892    60.859     0.150
     2.084    65.652     0.150
     2.598    77.879     0.150
     3.942   109.523     0.150
     4.015    62.203     0.150
     4.462   116.074     0.150
     5.493    81.688     0.150
     5.506    82.246     0.150
     5.510   146.230     0.150
     5.523    84.207     0.150
     5.877    87.926     0.150
     5.980    88.688     0.150
     6.509    95.926     0.150
     6.787   100.227     0.150
     7.297   101.449     0.150
     7.297   176.848     0.150
     6.893   102.434     0.150
     6.893   179.164     0.150
     9.702   245.328     0.150
     1.191    23.922     0.150
     1.191    24.059     0.150
     2.974    85.684     0.150
     2.985    51.199     0.150
     2.985    51.211     0.150
     3.552   100.715     0.150
     4.354   118.250     0.150
     4.502    68.613     0.150
     4.553   123.266     0.150
     5.383    76.020     0.150
     5.596    83.191     0.150
     5.619    83.973     0.150
     6.180    90.719     0.150
     5.997    93.621     0.150
     6.106    94.320     0.150
     6.838   100.246     0.150
     7.348   101.730     0.150
     7.348   177.609     0.150
     6.991   173.863     0.150
     7.125   184.340     0.150
     7.126   105.258     0.150
     7.126   185.125     0.150
     7.353   115.918     0.150
     7.569   192.770     0.150
     7.633   117.418     0.150
     7.935   206.422     0.150
     8.028   205.559     0.150
     8.088   116.531     0.150
     8.088   208.281     0.150
     8.396   124.363     0.150
     8.459   216.926     0.150
     8.353   128.820     0.150
     9.134   131.230     0.150
     9.187   132.195     0.150
     9.448   137.789     0.150
     9.498   150.020     0.150
     9.793   255.281     0.150
     9.921   243.461     0.150
    10.630   157.379     0.150
    10.671   266.727     0.150
    10.865   159.629     0.150
    17.892   247.570     0.150
    18.269   253.328     0.150
    18.747   264.160     0.150
    18.972   262.320     0.150
    21.169   288.621     0.150
    21.748   293.859     0.150
    22.648   333.020     0.150
    22.648   548.020     0.150
    25.539   332.648     0.150
    49.849   533.191     0.150
    61.360   619.031     0.150
    63.286     4.199     0.150
    78.546   725.141     0.150
    81.895   744.277     0.150
   151.213  1198.746     0.150
     0.385     8.676     0.150
     0.385     7.875     0.150
     0.385     7.875     0.150
     0.385     7.875     0.150
     0.385     7.875     0.150
     1.148    23.869     0.150
     1.148    22.098     0.150
     1.148    22.098     0.150
     1.164    24.268     0.150
     1.164    24.268     0.150
     1.164    24.268     0.150
     1.164    24.268     0.150
     1.164    24.268     0.150
     1.164    24.268     0.150
     1.223    23.033     0.150
     1.223    23.119     0.150
     1.223    38.938     0.150
     1.223    23.119     0.150
     1.223    38.938     0.150
     1.223    23.119     0.150
     1.223    38.938     0.150
     1.223    23.119     0.150
     1.223    38.938     0.150
     1.223    23.209     0.150
     1.223    23.209     0.150
     1.866    36.869     0.150
     1.866    36.869     0.150
     1.866    36.869     0.150
     1.866    36.869     0.150
     1.866    37.869     0.150
     1.866    37.869     0.150
     2.120    38.869     0.150
     2.120    38.869     0.150
     2.120    38.869     0.150
     2.120    39.869     0.150
     2.120    39.869     0.150
     2.120    39.869     0.150
     2.198    40.898     0.150
     2.198    38.299     0.150
     2.198    38.299     0.150
     2.198    40.898     0.150
     2.198    40.898     0.150
     2.205    37.732     0.150
     2.205    65.369     0.150
     2.205    37.879     0.150
     2.205    37.879     0.150
     2.205    38.889     0.150
     2.538    43.869     0.150
     2.538    43.869     0.150
     2.538    43.869     0.150
     2.612    44.869     0.150
     2.612    44.869     0.150
     2.612    44.869     0.150
     2.612    44.869     0.150
     2.795    46.498     0.150
     2.795    52.869     0.150
     2.795    52.869     0.150
     2.795    52.869     0.150
     2.810    46.074     0.150
     2.810    46.059     0.150
     2.810    46.059     0.150
     2.810    50.869     0.150
     2.810    50.869     0.150
     2.810    50.869     0.150
     2.810    50.869     0.150
     5.484   144.537     0.150
     5.505    82.551     0.150
     5.504   145.268     0.150
     5.544    82.906     0.150
     5.544    82.906     0.150
     5.544    82.906     0.150
     5.559    83.322     0.150
     5.863    87.531     0.150
     5.874    88.230     0.150
     6.632   168.535     0.150
     6.632    98.461     0.150
     6.779   100.895     0.150
     6.779   100.895     0.150
     7.294   101.711     0.150
     7.294   176.631     0.150
     0.376     8.153     0.150
     0.376    13.453     0.150
     0.376    13.453     0.150
     0.376     8.153     0.150
     0.376    13.453     0.150
     0.376    13.453     0.150
     0.376     8.153     0.150
     0.376     8.153     0.150
     0.376     8.153     0.150
     0.376     8.153     0.150
     0.376     8.153     0.150
     0.376     8.153     0.150
     1.089    23.216     0.150
     1.089    23.216     0.150
     1.089    23.216     0.150
     1.089    23.216     0.150
     1.089    39.206     0.150
     1.089    22.276     0.150
     1.089    23.216     0.150
     1.089    39.206     0.150
     1.089    23.216     0.150
     1.089    39.206     0.150
     1.190    23.946     0.150
     1.190    23.946     0.150
     1.190    23.946     0.150
     1.190    23.946     0.150
     1.190    23.946     0.150
     1.176    22.946     0.150
     1.176    23.406     0.150
     1.176    22.946     0.150
     1.176    23.406     0.150
     1.176    23.406     0.150
     1.919    63.391     0.150
     1.919    36.196     0.150
     1.919    36.196     0.150
     1.919    36.196     0.150
     1.919    36.196     0.150
     1.919    36.196     0.150
     1.919    38.216     0.150
     1.919    38.216     0.150
     1.919    38.216     0.150
     1.919    38.216     0.150
     1.919    38.216     0.150
     1.919    38.216     0.150
     2.067    40.196     0.150
     2.067    40.196     0.150
     2.067    40.196     0.150
     2.067    40.196     0.150
     2.183    42.196     0.150
     2.183    42.196     0.150
     2.183    42.196     0.150
     2.183    42.196     0.150
     2.183    40.216     0.150
     2.183    40.216     0.150
     2.145    40.196     0.150
     2.145    40.196     0.150
     2.145    40.196     0.150
     2.145    67.256     0.150
     2.215    41.206     0.150
     2.215    71.266     0.150
     2.215    41.206     0.150
     2.215    71.266     0.150
     2.215    41.206     0.150
     2.215    71.266     0.150
     2.215    41.206     0.150
     2.215    71.266     0.150
     2.671    79.148     0.150
     2.671    44.506     0.150
     2.671    44.506     0.150
     2.671    44.506     0.150
     2.671    44.506     0.150
     2.671    44.506     0.150
     3.962   103.269     0.150
     4.275   108.385     0.150
     5.526    82.378     0.150
     5.535   129.900     0.150
     5.567    82.733     0.150
     5.567    82.733     0.150
     5.584    78.488     0.150
     5.584   125.515     0.150
     6.532    95.348     0.150
     7.317   101.638     0.150
     7.317   177.328     0.150
     7.812   116.698     0.150
     8.214   122.618     0.150
     0.369     7.207     0.150
     0.369     8.232     0.150
     0.369     8.133     0.150
     0.369     8.133     0.150
     0.369     8.133     0.150
     0.369     8.133     0.150
     0.369     7.207     0.150
     0.369     7.207     0.150
     0.790    16.400     0.150
     0.790    16.400     0.150
     0.790    16.400     0.150
     0.790    16.400     0.150
     1.088    21.789     0.150
     1.088    21.789     0.150
     1.184    23.699     0.150
     1.184    23.699     0.150
     1.184    23.699     0.150
     1.184    23.699     0.150
     1.179    22.641     0.150
     1.179    22.641     0.150
     1.179    22.641     0.150
     1.179    22.641     0.150
     1.916    63.004     0.150
     1.916    36.561     0.150
     1.916    36.561     0.150
     1.916    35.561     0.150
     1.916    34.551     0.150
     1.916    34.551     0.150
     1.916    34.551     0.150
     2.063    37.631     0.150
     2.176    71.551     0.150
     2.176    71.551     0.150
     2.176    38.590     0.150
     2.176    71.551     0.150
     2.176    37.641     0.150
     2.176    37.641     0.150
     2.176    37.641     0.150
     2.176    37.641     0.150
     2.145    37.551     0.150
     2.145    68.580     0.150
     2.145    37.551     0.150
     2.145    68.580     0.150
     2.145    39.551     0.150
     2.145    39.551     0.150
     2.145    39.551     0.150
     2.216    72.570     0.150
     2.216    37.551     0.150
     2.216    37.551     0.150
     2.216    37.551     0.150
     2.216    37.551     0.150
     2.571    42.910     0.150
     2.571    42.910     0.150
     2.571    43.551     0.150
     2.672    44.211     0.150
     2.672    44.211     0.150
     2.748    47.031     0.150
     2.748    47.031     0.150
     2.735    46.561     0.150
     2.752    45.580     0.150
     2.752    45.580     0.150
     2.752    48.561     0.150
     2.752    48.561     0.150
     2.752    48.561     0.150
     2.752    48.561     0.150
     3.088    92.521     0.150
     3.071    56.721     0.150
     3.071    94.715     0.150
     3.071    87.881     0.150
     3.200    52.561     0.150
     3.384    56.551     0.150
     3.384    56.551     0.150
     3.384    56.551     0.150
     4.273    68.076     0.150
     5.546    83.275     0.150
     5.561    82.338     0.150
     5.561    82.338     0.150
     5.891    87.682     0.150
     5.913    87.201     0.150
     5.997    88.422     0.150
     6.527   165.908     0.150
     6.747   179.701     0.150
     7.311   101.213     0.150
     7.311   176.312     0.150
     7.204   185.062     0.150
     0.976    35.875     0.150
     2.570    73.422     0.150
     2.748    43.664     0.150
     3.309    50.281     0.150
     3.573    55.336     0.150
     3.746   106.609     0.150
     3.739   106.625     0.150
     4.670    70.852     0.150
     5.259   140.070     0.150
     5.354    79.266     0.150
     5.354   135.973     0.150
     5.430    80.285     0.150
     5.871   149.129     0.150
     6.836    92.777     0.150
     6.836   160.457     0.150
     6.791   100.074     0.150
     7.518   110.637     0.150
     7.920   116.098     0.150
     8.480   123.965     0.150
     8.600   126.527     0.150
     8.859   128.648     0.150
     9.166   133.316     0.150
     0.429     9.049     0.150
     0.429    14.066     0.150
     0.786    31.389     0.150
     1.334    47.355     0.150
     1.582    53.904     0.150
     4.106    61.354     0.150
     5.845    80.596     0.150
     5.845   138.996     0.150
     0.870    15.598     0.150
     0.870    26.203     0.150
     1.113    23.586     0.150
     1.113    40.301     0.150
     2.378    70.582     0.150
     3.530    56.953     0.150
     3.636    57.934     0.150
     3.636    54.637     0.150
     3.926    62.562     0.150
     4.168   111.613     0.150
     5.306   131.262     0.150
     0.344     6.035     0.150
     0.344    10.055     0.150
     1.189    42.402     0.150
     3.179    91.637     0.150
     0.999    18.653     0.150
     0.999    30.680     0.150
     1.069    24.268     0.150
     1.019    23.411     0.150
     3.449    56.214     0.150
     3.549    57.754     0.150
     3.549    98.521     0.150
     3.844    62.014     0.150
     5.231   130.783     0.150
     1.188    21.656     0.150
     1.188    36.672     0.150
     6.795    96.156     0.150
     0.586    11.898     0.150
     0.586    11.898     0.150
     0.586    11.898     0.150
     0.586    11.898     0.150
     0.815    31.438     0.150
     0.815    18.320     0.150
     0.815    31.438     0.150
     0.815    18.320     0.150
     0.815    31.438     0.150
     0.815    18.320     0.150
     0.815    31.438     0.150
     1.147    24.320     0.150
     1.147    40.453     0.150
     1.147    40.453     0.150
     1.147    40.453     0.150
     1.279    25.328     0.150
     1.279    25.328     0.150
     1.279    25.328     0.150
     1.568    29.320     0.150
     1.568    49.320     0.150
     1.568    29.320     0.150
     1.568    49.320     0.150
     1.568    29.320     0.150
     1.568    49.320     0.150
     1.814    34.500     0.150
     1.814    34.500     0.150
     1.814    34.500     0.150
     1.814    34.500     0.150
     1.955    63.477     0.150
     1.955    37.508     0.150
     1.955    37.508     0.150
     1.955    37.508     0.150
     1.955    37.508     0.150
     2.250    71.320     0.150
     2.657    44.320     0.150
     2.657    44.320     0.150
     2.722    46.672     0.150
     3.028    88.516     0.150
     3.028    50.320     0.150
     3.028    50.320     0.150
     3.028    50.320     0.150
     4.864    76.422     0.150
     6.188    94.609     0.150
     6.592   160.625     0.150
     0.366    14.797     0.150
     0.497    20.312     0.150
     0.786    30.008     0.150
     1.151    23.562     0.150
     1.205    22.852     0.150
     1.889    62.000     0.150
     2.595    77.555     0.150
     2.753    75.594     0.150
     2.753    45.750     0.150
     2.753    46.023     0.150
     2.753    46.070     0.150
     3.095    56.031     0.150
     3.095    89.977     0.150
     3.095    50.766     0.150
     3.435    98.414     0.150
     3.405    98.383     0.150
     4.147   115.656     0.150
     4.245    65.234     0.150
     4.245   116.891     0.150
     4.423   117.781     0.150
     4.459   123.148     0.150
     4.630    70.828     0.150
     4.630   126.164     0.150
     5.236   145.648     0.150
     5.544    83.773     0.150
     5.544   147.477     0.150
     5.544    82.719     0.150
     5.599    83.734     0.150
     5.858   157.664     0.150
     5.858    87.305     0.150
     5.874   150.594     0.150
     5.888    88.070     0.150
     6.784   180.570     0.150
     6.784   100.031     0.150
     7.294   101.281     0.150
     7.294   175.109     0.150
     7.516   110.023     0.150
     7.692   116.461     0.150
    10.189   149.359     0.150
    10.848   159.609     0.150
    10.922   160.352     0.150
    19.682   271.180     0.150
    20.148   635.250     0.150
    20.543   284.250     0.150
    21.189   275.672     0.150
    21.627   289.562     0.150
    22.781   302.969     0.150
    25.421   326.102     0.150
    49.734   533.039     0.150
     0.343    13.141     0.150
     1.036    37.758     0.150
     1.731    56.133     0.150
     1.953    63.289     0.150
     2.003    36.891     0.150
     2.003    62.625     0.150
     2.704    45.453     0.150
     2.725    79.578     0.150
     3.211    52.039     0.150
     5.514   141.234     0.150
     5.517    81.258     0.150
     5.549   142.164     0.150
     5.558    82.008     0.150
     5.578    82.297     0.150
     5.813    86.219     0.150
     6.003    88.039     0.150
     7.307   100.930     0.150
     7.307   176.023     0.150
     7.528   111.219     0.150
     7.660   194.938     0.150
     7.896   117.148     0.150
     9.534   138.773     0.150
    61.300   617.328     0.150
     1.170    37.278     0.150
     1.161    38.597     0.150
     1.710    33.219     0.150
     1.956    36.329     0.150
     1.956    64.590     0.150
     2.589    76.980     0.150
     2.668    79.401     0.150
     2.668    77.994     0.150
     2.983    88.487     0.150
     5.540    82.584     0.150
     5.834   153.384     0.150
     5.986    87.352     0.150
     6.456    94.308     0.150
     7.285   100.754     0.150
     7.285   176.754     0.150
     0.918    34.703     0.150
     1.712    28.953     0.150
     2.558    45.133     0.150
     3.475    52.297     0.150
     3.563    92.727     0.150
     3.579    93.062     0.150
     3.809    97.727     0.150
     4.045    60.531     0.150
     5.270    72.453     0.150
     5.270   126.508     0.150
     1.891    62.816     0.150
     7.064    99.984     0.150
     7.064   172.566     0.150
     0.930    21.082     0.150
     3.848    60.314     0.150
     5.259    72.924     0.150
     5.259   127.225     0.150
     0.171     6.754     0.150
     0.694    22.430     0.150
     0.775    25.770     0.150
     1.303    25.945     0.150
     1.521    51.367     0.150
     1.592    32.320     0.150
     1.592    52.469     0.150
     4.790    71.973     0.150
     5.727    84.352     0.150
     6.219    86.273     0.150
     6.219   147.973     0.150
     8.136   119.453     0.150
     8.808   129.254     0.150
     0.936    31.363     0.150
     0.932    33.848     0.150
     1.340    44.574     0.150
     1.601    50.840     0.150
     1.657    52.949     0.150
     2.567    73.105     0.150
     3.539    94.680     0.150
     3.577    54.023     0.150
     3.603    54.199     0.150
     3.846    98.523     0.150
     4.044   104.402     0.150
     4.067    60.602     0.150
     5.278    72.621     0.150
     5.278   125.812     0.150
     0.835    31.312     0.150
     3.526    93.031     0.150
     3.593    54.090     0.150
     3.600    54.484     0.150
     3.788    57.457     0.150
     3.788    98.945     0.150
     3.899   102.402     0.150
     3.959    60.398     0.150
     4.064    61.023     0.150
     4.151    62.074     0.150
     5.319    73.012     0.150
     5.319   127.453     0.150
     0.954    17.703     0.150
     0.966    22.711     0.150
     0.966    22.711     0.150
     0.966    18.961     0.150
     0.966    18.961     0.150
     0.966    19.721     0.150
     0.966    19.721     0.150
     0.966    19.721     0.150
     0.966    22.711     0.150
     0.966    22.711     0.150
     1.115    24.711     0.150
     1.115    24.711     0.150
     1.115    24.711     0.150
     1.115    24.711     0.150
     1.115    24.711     0.150
     1.115    24.711     0.150
     1.115    24.711     0.150
     1.423    27.682     0.150
     1.423    29.770     0.150
     1.423    29.770     0.150
     1.423    29.770     0.150
     1.423    29.770     0.150
     1.423    29.770     0.150
     1.423    29.770     0.150
     1.588    29.189     0.150
     1.588    29.189     0.150
     1.588    30.711     0.150
     1.588    30.711     0.150
     1.588    30.711     0.150
     1.588    30.711     0.150
     1.588    30.711     0.150
     1.588    29.189     0.150
     1.588    29.189     0.150
     1.692    51.324     0.150
     1.692    29.793     0.150
     1.692    29.793     0.150
     1.692    32.293     0.150
     1.692    32.293     0.150
     1.692    32.293     0.150
     1.692    32.293     0.150
     1.692    29.793     0.150
     1.692    29.793     0.150
     1.765    57.096     0.150
     1.765    34.760     0.150
     1.765    34.760     0.150
     1.765    34.760     0.150
     1.765    34.760     0.150
     1.765    34.760     0.150
     1.765    34.760     0.150
     1.757    32.742     0.150
     1.757    32.742     0.150
     1.757    32.742     0.150
     1.757    32.742     0.150
     2.545    47.730     0.150
     2.545    47.730     0.150
     2.545    47.730     0.150
     2.545    47.730     0.150
     2.545    47.730     0.150
     2.545    47.730     0.150
     2.625    76.488     0.150
     2.625    78.750     0.150
     2.625    78.750     0.150
     2.625    78.750     0.150
     3.133    90.301     0.150
     3.523    54.648     0.150
     3.501    57.754     0.150
     3.546    93.652     0.150
     3.500    98.904     0.150
     3.585   100.803     0.150
     3.774   100.432     0.150
     3.774    57.668     0.150
     3.774    57.668     0.150
     3.774    57.668     0.150
     3.774    57.668     0.150
     3.787    99.250     0.150
     3.809    58.482     0.150
     3.814    57.992     0.150
     4.128    63.148     0.150
     4.604   120.373     0.150
     4.797   123.953     0.150
     4.797    71.947     0.150
     4.797    71.947     0.150
     4.797    71.947     0.150
     4.797   125.848     0.150
     4.797    71.947     0.150
     4.797   125.848     0.150
     5.227    73.143     0.150
     5.227   126.293     0.150
     5.515    82.414     0.150
     6.150    92.172     0.150
     6.200   166.121     0.150
     6.200   166.121     0.150
     6.536   165.031     0.150
     7.540   109.152     0.150
     1.065    18.715     0.150
     1.863    55.980     0.150
     1.848    59.613     0.150
     2.118    62.414     0.150
     4.709    70.121     0.150
     5.548    82.242     0.150
     5.876    86.594     0.150
     7.029   170.621     0.150
     0.595    24.432     0.150
     1.437    27.345     0.150
     1.829    35.668     0.150
     1.829    59.376     0.150
     2.617    37.746     0.150
     3.006    73.945     0.150
     3.489    52.214     0.150
     3.562    51.634     0.150
     3.755    53.835     0.150
     0.787    24.688     0.150
     1.286    41.918     0.150
     2.894    83.562     0.150
     3.132    87.023     0.150
     3.695   102.703     0.150
     3.854    59.484     0.150
     3.933   106.676     0.150
     4.069    62.176     0.150
     4.069   105.906     0.150
     4.243    64.902     0.150
     4.243    65.168     0.150
     4.492    66.488     0.150
     4.519    67.328     0.150
     4.556    69.148     0.150
     4.694   125.488     0.150
     5.649    78.660     0.150
     5.649   136.457     0.150
     5.861   147.707     0.150
     7.140   105.988     0.150
     8.420   124.148     0.150
     8.420   212.070     0.150
     0.798    30.414     0.150
     0.829    30.625     0.150
     1.924    63.977     0.150
     6.632    91.758     0.150
     6.632   159.250     0.150
     0.629    15.553     0.150
     0.629    28.137     0.150
     0.802    29.518     0.150
     0.802    15.924     0.150
     1.667    48.643     0.150
     1.450    26.520     0.150
     1.450    46.965     0.150
     1.637    52.236     0.150
     1.518    50.285     0.150
     1.518    48.764     0.150
     2.272    37.334     0.150
     2.272    36.203     0.150
     2.777    42.779     0.150
     3.060    50.689     0.150
     3.146    50.471     0.150
     3.790    56.125     0.150
     3.809   100.254     0.150
     3.809    56.824     0.150
     3.810    99.328     0.150
     3.713   105.832     0.150
     3.863    58.381     0.150
     3.889    59.674     0.150
     4.146    61.215     0.150
     4.230    62.064     0.150
     4.230    61.984     0.150
     4.588    70.645     0.150
     4.588   122.258     0.150
     5.013    74.555     0.150
     5.563    75.273     0.150
     5.563   130.414     0.150
     5.129   137.660     0.150
     5.250    79.875     0.150
     5.422   139.404     0.150
     5.415   164.459     0.150
     5.415   138.865     0.150
     5.866   149.414     0.150
     6.415    93.145     0.150
     7.745   112.865     0.150
    10.310   254.957     0.150
    10.310   145.518     0.150
    17.120   453.586     0.150
    17.269   239.354     0.150
    17.744   248.094     0.150
    17.994   250.717     0.150
    18.009   251.742     0.150
    18.067   256.619     0.150
    19.159   264.031     0.150
    19.159   263.994     0.150
    20.192   272.135     0.150
    21.407     2.000     0.150
    21.407   316.635     0.150
    21.920   294.064     0.150
    22.343   292.334     0.150
    22.413   297.875     0.150
    23.190   305.914     0.150
    23.970   310.135     0.150
    24.100   311.234     0.150
    24.991   322.705     0.150
    25.135   322.715     0.150
    27.303   336.434     0.150
    27.505   346.205     0.150
    28.567   352.758     0.150
    29.644   358.035     0.150
    29.713   360.135     0.150
    29.720   359.635     0.150
    29.725   362.564     0.150
    29.725   360.135     0.150
    37.904   433.660     0.150
    39.091   443.715     0.150
    39.091   443.715     0.150
    47.720   513.754     0.150
    47.720   513.764     0.150
    55.003   568.213     0.150
    60.514   607.209     0.150
    60.636   609.955     0.150
    77.794   715.674     0.150
    78.103   718.814     0.150
    78.316   720.334     0.150
     0.648    25.562     0.150
     0.829    30.383     0.150
     0.915    27.586     0.150
     0.905    18.609     0.150
     0.905    32.785     0.150
     1.205    41.969     0.150
     2.306    41.559     0.150
     2.306    66.637     0.150
     2.236    34.711     0.150
     2.236    57.812     0.150
     2.746    77.750     0.150
     2.746    70.977     0.150
     3.096    87.980     0.150
     3.055    86.812     0.150
     3.055    79.121     0.150
     3.705   100.262     0.150
     3.807    56.781     0.150
     3.778    56.262     0.150
     3.778    96.523     0.150
     3.922   108.180     0.150
     4.144    60.672     0.150
     4.233    64.461     0.150
     5.560    75.723     0.150
     5.560   131.973     0.150
     6.025    89.391     0.150
     0.629    15.222     0.150
     0.629    25.642     0.150
     5.577    74.981     0.150
     5.577   132.141     0.150
     0.623    15.460     0.150
     0.623    26.860     0.150
     0.907    27.655     0.150
     1.221    36.144     0.150
     1.275    25.018     0.150
     1.275    42.117     0.150
     1.444    27.848     0.150
     1.444    46.154     0.150
     1.511    47.848     0.150
     1.662    54.335     0.150
     2.253    34.894     0.150
     3.074    87.146     0.150
     3.780    57.613     0.150
     3.799   105.394     0.150
     3.862    57.583     0.150
     4.744    68.478     0.150
     5.582    75.226     0.150
     5.582   130.905     0.150
     5.881   150.335     0.150
     7.408   105.166     0.150
     0.243    10.023     0.150
     2.035    66.648     0.150
     2.762    44.695     0.150
     6.465    94.047     0.150
     7.185   100.406     0.150
     7.185   173.453     0.150
     0.630    26.039     0.150
     1.207    40.500     0.150
     3.829    56.820     0.150
     3.829   103.180     0.150
     3.827    55.105     0.150
     5.583    75.699     0.150
     5.583   132.070     0.150
     0.951    29.992     0.150
     1.681    31.867     0.150
     1.775    57.820     0.150
     2.431    68.656     0.150
     2.598    69.234     0.150
     2.598    40.469     0.150
     2.598    69.477     0.150
     3.548    93.688     0.150
     3.571    52.047     0.150
     3.571    55.523     0.150
     3.452   100.016     0.150
     4.035   105.016     0.150
     4.085    61.781     0.150
     5.251    73.078     0.150
     5.251   126.555     0.150
     5.470    79.375     0.150
     1.503    26.820     0.150
     1.628    31.820     0.150
     1.628    55.977     0.150
     2.349    71.875     0.150
     2.319    39.938     0.150
     6.054   145.742     0.150
     1.345    46.062     0.150
     1.295    46.680     0.150
     1.914    34.906     0.150
     2.196    38.922     0.150
     7.381   180.812     0.150
     7.584   112.805     0.150
     1.168    36.914     0.150
     1.383    43.617     0.150
     1.555    51.680     0.150
     1.770    56.867     0.150
     3.012    81.836     0.150
     2.991    87.914     0.150
     3.756   109.992     0.150
     5.143   139.055     0.150
     5.234    79.289     0.150
     5.726    85.961     0.150
     5.961    88.867     0.150
     6.688    92.219     0.150
     6.688   159.742     0.150
     7.426   110.062     0.150
     0.603    22.374     0.150
     1.623    54.720     0.150
     1.773    60.013     0.150
     2.276    64.087     0.150
     3.338    96.819     0.150
     3.502    54.393     0.150
     3.431    56.079     0.150
     3.503    99.747     0.150
     4.311   120.353     0.150
     4.579    70.094     0.150
     4.598    70.567     0.150
     4.647    69.998     0.150
     4.689    72.250     0.150
     4.689   125.398     0.150
     5.065    76.013     0.150
     6.385    87.973     0.150
     6.385   155.203     0.150
     6.271    92.589     0.150
     6.738    98.563     0.150
     0.819    29.848     0.150
     0.831    31.219     0.150
     1.157    39.609     0.150
     2.430    38.738     0.150
     2.430    69.332     0.150
     2.592    46.055     0.150
     3.548    92.574     0.150
     3.434    51.051     0.150
     3.939    58.625     0.150
     5.343    72.746     0.150
     5.343   127.746     0.150
     1.386    24.219     0.150
     1.386    40.000     0.150
     1.368    42.844     0.150
     2.582    75.133     0.150
     2.615    72.422     0.150
     3.243    49.234     0.150
     3.243    88.414     0.150
     4.319    70.750     0.150
     4.663   123.703     0.150
     0.079     5.605     0.150
     0.079     5.613     0.150
     0.879    30.340     0.150
     6.045   152.188     0.150
     1.072    24.016     0.150
     1.365    47.961     0.150
     1.595    52.742     0.150
     1.747    57.641     0.150
     2.649    45.766     0.150
     6.501   160.539     0.150
     0.866    15.543     0.150
     0.866    26.469     0.150
     1.008    36.043     0.150
     1.923    34.578     0.150
     2.657    79.375     0.150
     2.714    80.168     0.150
     3.206    93.684     0.150
     4.228    64.941     0.150
     4.441    69.508     0.150
     4.797    73.289     0.150
     4.891    75.176     0.150
     5.115    77.730     0.150
     5.084   132.781     0.150
     5.283    80.215     0.150
     5.312    80.148     0.150
     5.383    81.234     0.150
     5.401    81.609     0.150
     5.510   143.461     0.150
     5.830    87.789     0.150
     6.398    95.418     0.150
     6.594    98.352     0.150
     6.898   170.898     0.150
     7.103   178.711     0.150
     7.103   105.371     0.150
     7.413   190.199     0.150
     7.919   199.770     0.150
     8.049   208.488     0.150
     9.440   239.070     0.150
     9.534   139.117     0.150
    18.718   259.512     0.150
    20.699   284.262     0.150
    21.396   292.641     0.150
    21.667   295.352     0.150
    22.301   304.109     0.150
    22.575   303.590     0.150
     0.998    18.259     0.150
     0.998    30.421     0.150
     6.726   165.136     0.150
     1.139    33.376     0.150
     2.608    68.719     0.150
     4.284    66.159     0.150
     4.420    66.369     0.150
     4.498   112.779     0.150
     4.972    73.574     0.150
     5.427    81.600     0.150
     5.989    89.259     0.150
     0.231     9.135     0.150
     0.231    14.117     0.150
     1.236    42.655     0.150
     2.561    74.957     0.150
     4.828    72.323     0.150
     4.947   127.562     0.150
     5.103    74.273     0.150
     5.214   133.993     0.150
     5.444    81.394     0.150
     6.027    63.703     0.150
     6.027   127.884     0.150
     6.625    93.384     0.150
     6.625   160.693     0.150
     1.208    44.875     0.150
     1.990    66.055     0.150
     2.831    83.680     0.150
     0.658    28.322     0.150
     0.896    31.579     0.150
     1.193    41.546     0.150
     1.683    54.504     0.150
     2.220    35.920     0.150
     3.756   107.640     0.150
     3.802   103.219     0.150
     3.766    99.277     0.150
     3.827    59.256     0.150
     4.713   124.992     0.150
     5.556    76.215     0.150
     5.556   133.045     0.150
     0.973    34.293     0.150
     1.311    45.504     0.150
     1.959    57.859     0.150
     2.873    80.121     0.150
     4.383    65.316     0.150
     4.504    65.938     0.150
     5.672    76.566     0.150
     5.672   131.957     0.150
     0.603    23.102     0.150
     0.695    26.578     0.150
     1.460    47.156     0.150
     2.038    64.250     0.150
     2.508    72.852     0.150
     3.034    78.812     0.150
     3.744    55.023     0.150
     3.778   101.211     0.150
     3.862    58.586     0.150
     4.109    60.367     0.150
     5.530    75.539     0.150
     5.530   132.094     0.150
     0.752    23.063     0.150
     6.609   100.904     0.150
     7.095   100.734     0.150
     1.060    36.495     0.150
     3.336    48.986     0.150
     4.386    64.920     0.150
     4.472    65.551     0.150
     4.718    69.370     0.150
     4.875   122.825     0.150
     5.000   126.405     0.150
     5.356    77.953     0.150
     5.869   139.910     0.150
     0.620    24.613     0.150
     0.825    30.416     0.150
     0.869    20.289     0.150
     0.869    32.959     0.150
     1.409    48.393     0.150
     5.517    76.396     0.150
     5.517   131.197     0.150
     0.863    31.400     0.150
     0.835    31.662     0.150
     1.150    40.697     0.150
     1.541    50.924     0.150
     2.348    76.207     0.150
     3.224    92.873     0.150
     5.465    76.373     0.150
     5.465   132.652     0.150
     0.988    20.815     0.150
     1.314    46.100     0.150
     2.814    42.945     0.150
     4.638    68.010     0.150
     4.674   122.973     0.150
     5.511    82.975     0.150
     6.411    86.635     0.150
     6.411   152.735     0.150
     7.996   116.845     0.150
     1.049    19.555     0.150
     0.961    21.117     0.150
     1.198    37.762     0.150
     1.320    40.281     0.150
     1.295    47.677     0.150
     1.971    57.427     0.150
     2.679    74.130     0.150
     2.638    47.470     0.150
     2.825    44.106     0.150
     3.087    89.073     0.150
     3.342    95.270     0.150
     4.187   114.630     0.150
     4.243    68.577     0.150
     4.450    65.447     0.150
     4.907   129.635     0.150
     5.426    79.572     0.150
     5.763    88.040     0.150
     6.440    87.127     0.150
     6.440   152.637     0.150
     6.218    94.797     0.150
     0.838    21.201     0.150
     0.838    33.403     0.150
     1.251    28.114     0.150
     1.251    46.399     0.150
     1.191    26.886     0.150
     1.191    47.385     0.150
     1.441    25.137     0.150
     1.441    40.894     0.150
     2.813    42.312     0.150
     2.628    47.289     0.150
     2.893    45.010     0.150
     3.268    48.701     0.150
     3.334    49.837     0.150
     3.334    87.881     0.150
     3.379    96.031     0.150
     4.204   114.198     0.150
     4.308   115.846     0.150
     4.216    64.032     0.150
     4.746    69.143     0.150
     4.746    69.335     0.150
     4.808    70.704     0.150
     5.013    73.969     0.150
     5.488   138.184     0.150
     5.483    79.932     0.150
     5.483    80.052     0.150
     5.826    84.474     0.150
     6.519    88.034     0.150
     6.680   100.234     0.150
     0.953    16.333     0.150
     1.181    32.517     0.150
     2.123    61.930     0.150
     2.527    72.764     0.150
     2.642    67.722     0.150
     4.582    67.919     0.150
     4.944    72.784     0.150
     3.927    56.324     0.150
     3.927    99.408     0.150
     4.301   114.445     0.150
     4.956   124.506     0.150
     5.374    79.973     0.150
     5.856    86.922     0.150
     0.614    24.586     0.150
     4.369    67.469     0.150
     5.012   132.656     0.150
     5.520    75.969     0.150
     5.520   132.430     0.150
     5.406    81.516     0.150
     5.406   141.125     0.150
     7.127    99.219     0.150
     7.127   173.531     0.150
     0.856    15.559     0.150
     0.856    25.699     0.150
     1.119    23.078     0.150
     1.119    38.316     0.150
     1.469    48.137     0.150
     1.469    26.562     0.150
     1.514    27.887     0.150
     2.273    39.414     0.150
     2.756    42.508     0.150
     3.241    91.422     0.150
     3.429    52.090     0.150
     3.829    99.156     0.150
     3.803    57.414     0.150
     4.014    61.914     0.150
     4.014   104.281     0.150
     4.069    60.574     0.150
     4.097    60.941     0.150
     4.097   106.262     0.150
     4.298    65.301     0.150
     5.510    75.801     0.150
     5.510   132.363     0.150
     5.725    82.555     0.150
     5.725    85.473     0.150
     5.914   149.234     0.150
     5.916    85.953     0.150
     9.023   129.883     0.150
     9.860   140.344     0.150
    20.801   278.539     0.150
    65.005   641.453     0.150
     1.519    51.570     0.150
     1.007    33.680     0.150
     4.373    68.500     0.150
     4.668    71.500     0.150
     4.668   119.703     0.150
     6.416    87.758     0.150
     6.416   150.547     0.150
     6.227    92.953     0.150
     0.329     8.572     0.150
     0.329    13.547     0.150
     0.560    18.928     0.150
     1.491    50.641     0.150
     1.708    58.057     0.150
     2.871    46.705     0.150
     2.871    88.154     0.150
     4.634    70.332     0.150
     4.730    72.182     0.150
     4.730    72.197     0.150
     4.730   124.838     0.150
     5.000    75.668     0.150
     5.997    89.398     0.150
     6.431    90.549     0.150
     6.431   156.139     0.150
     0.644    15.594     0.150
     0.644    26.416     0.150
     1.485    50.258     0.150
     3.621   103.941     0.150
     3.745   102.100     0.150
     0.148     9.180     0.150
     0.887    19.594     0.150
     0.887    33.172     0.150
     1.421    50.891     0.150
     3.554   102.992     0.150
     3.737   102.344     0.150
     5.522    76.164     0.150
     5.522   133.023     0.150
     0.464     8.215     0.150
     0.464    13.156     0.150
     1.387    40.789     0.150
     2.941    84.953     0.150
     4.393    67.484     0.150
     0.919    16.672     0.150
     1.462    26.898     0.150
     6.927   170.141     0.150
     0.427    12.322     0.150
     0.427    20.849     0.150
     0.647    18.964     0.150
     2.036    38.592     0.150
     2.036    67.111     0.150
     2.183    71.089     0.150
     2.796    83.406     0.150
     4.571   126.928     0.150
     4.690   131.100     0.150
     5.967    90.073     0.150
     1.365    46.969     0.150
     2.248    40.172     0.150
     3.120    51.727     0.150
     3.966   115.562     0.150
     4.126   119.125     0.150
     4.247   112.352     0.150
     4.326    67.273     0.150
     4.524    70.742     0.150
     4.793   129.234     0.150
     4.796   132.156     0.150
     5.024   131.531     0.150
     5.313   136.203     0.150
     5.555   148.320     0.150
     5.775   147.602     0.150
     5.838   154.883     0.150
     6.525    90.531     0.150
     6.525   155.867     0.150
     6.692   100.570     0.150
     0.459    19.285     0.150
     0.907    17.865     0.150
     1.529    31.219     0.150
     1.529    55.168     0.150
     1.650    56.008     0.150
     1.828    51.873     0.150
     2.099    67.463     0.150
     2.235    65.816     0.150
     2.253    67.162     0.150
     2.352    41.436     0.150
     2.352    73.734     0.150
     2.584    45.227     0.150
     2.725    45.426     0.150
     3.521    56.648     0.150
     3.395    98.635     0.150
     3.651   104.564     0.150
     4.429   123.924     0.150
     5.079   132.910     0.150
     5.096   133.096     0.150
     5.096    76.918     0.150
     5.096   134.559     0.150
     5.313    79.207     0.150
     5.313   141.211     0.150
     5.625    83.477     0.150
     5.731    86.102     0.150
     5.778    83.865     0.150
     6.398    92.246     0.150
     6.447   168.275     0.150
     6.447   166.891     0.150
     6.945    95.215     0.150
     6.945   165.775     0.150
     6.577    94.307     0.150
     7.783   110.816     0.150
    15.793   221.160     0.150
    19.597   273.752     0.150
    21.165   289.170     0.150
    22.977   305.666     0.150
    23.173   307.676     0.150
    26.492   336.486     0.150
    48.185   517.264     0.150
    55.389   572.254     0.150
    55.389   572.256     0.150
    60.872   611.881     0.150
    63.450   627.508     0.150
    67.417   657.875     0.150
    75.366   705.545     0.150
    78.300   719.637     0.150
     0.863    27.017     0.150
     1.272    44.060     0.150
     1.513    26.251     0.150
     1.759    30.635     0.150
     3.013    86.848     0.150
     5.407    80.854     0.150
     6.586    92.125     0.150
     6.586   159.135     0.150
     8.925   127.415     0.150
     0.861    17.318     0.150
     0.861    28.895     0.150
     1.564    32.067     0.150
     1.564    53.979     0.150
     2.154    64.687     0.150
     6.968    96.586     0.150
     6.968   166.776     0.150
     0.853    31.309     0.150
     1.511    52.715     0.150
     2.831    84.770     0.150
     7.134   176.965     0.150
     1.360    23.452     0.150
     1.495    27.241     0.150
     2.722    43.006     0.150
     2.661    78.658     0.150
     2.978    86.622     0.150
     3.675    98.688     0.150
     3.912   106.784     0.150
     4.778   124.425     0.150
     5.541    78.074     0.150
     5.541   132.044     0.150
     5.432    82.324     0.150
     5.888    88.764     0.150
     0.482    13.082     0.150
     0.482    21.751     0.150
     0.773    17.772     0.150
     0.901    20.029     0.150
     1.603    44.775     0.150
     1.683    55.227     0.150
     1.801    57.084     0.150
     4.384    66.575     0.150
     4.453    67.294     0.150
     6.181    85.495     0.150
     6.181   146.455     0.150
     2.328    40.291     0.150
     2.328    72.488     0.150
     5.529    80.668     0.150
     5.545   145.484     0.150
     5.784   143.330     0.150
     5.784   143.627     0.150
     5.800   147.338     0.150
     6.505   169.484     0.150
     6.567   169.230     0.150
     6.609   169.592     0.150
     7.211   100.379     0.150
     7.211   175.180     0.150
     0.719    17.293     0.150
     0.719    28.195     0.150
     1.195    36.676     0.150
     1.560    28.195     0.150
     1.560    52.047     0.150
     1.465    27.449     0.150
     3.784    61.453     0.150
     7.440   111.430     0.150
     7.736   109.922     0.150
     0.111     4.359     0.150
     1.173    25.057     0.150
     1.173    42.234     0.150
     2.435    42.220     0.150
     2.776    81.751     0.150
     3.026    87.691     0.150
     6.336    95.621     0.150
     7.852   110.081     0.150
     7.852   190.871     0.150
     0.946    16.846     0.150
     0.946    28.055     0.150
     1.119    39.904     0.150
     2.530    72.928     0.150
     5.021   132.580     0.150
     1.284    46.543     0.150
     1.307    45.938     0.150
     1.538    29.489     0.150
     5.571    83.423     0.150
     7.701   192.958     0.150
     0.995    33.348     0.150
     1.225    35.977     0.150
     1.129    37.672     0.150
     1.190    21.492     0.150
     1.190    34.871     0.150
     1.655    53.445     0.150
     1.723    55.355     0.150
     1.781    50.988     0.150
     2.420    41.727     0.150
     2.420    71.527     0.150
     0.276     8.133     0.150
     0.276    13.758     0.150
     0.647    24.969     0.150
     0.872    20.062     0.150
     0.872    31.852     0.150
     0.836    31.023     0.150
     0.835    31.031     0.150
     1.431    27.430     0.150
     1.431    27.508     0.150
     1.551    47.914     0.150
     1.793    31.750     0.150
     3.582    54.695     0.150
     3.611    95.297     0.150
     3.610    54.633     0.150
     4.160    62.742     0.150
     4.690   121.750     0.150
     5.327    73.711     0.150
     5.327   128.477     0.150
     5.458    81.125     0.150
     0.273     7.094     0.150
     0.834    18.031     0.150
     1.195    42.375     0.150
     1.429    47.844     0.150
     1.448    47.969     0.150
     1.660    54.719     0.150
     3.534    53.305     0.150
     4.160    62.000     0.150
     5.328    73.016     0.150
     5.328   127.305     0.150
     1.347    51.059     0.150
     1.446    50.355     0.150
     1.531    53.570     0.150
     5.279   136.969     0.150
     7.042   175.918     0.150
     0.882    31.675     0.150
     1.794    49.245     0.150
     1.794    49.811     0.150
     2.081    62.305     0.150
     4.558   126.379     0.150
     4.613   125.289     0.150
     4.906    73.024     0.150
     4.926    73.916     0.150
     6.674    91.459     0.150
     6.674   158.250     0.150
     6.663    99.113     0.150
     1.201    43.871     0.150
     1.515    53.938     0.150
     1.600    53.418     0.150
     1.598    55.348     0.150
     5.438    84.023     0.150
     5.455    82.797     0.150
     6.070    92.867     0.150
     7.083   175.738     0.150
     7.655   112.590     0.150
     0.566    17.143     0.150
     1.540    50.601     0.150
     1.775    32.645     0.150
     2.573    43.754     0.150
     5.196    79.726     0.150
     6.712   101.165     0.150
     1.414    46.279     0.150
     1.135    35.282     0.150
     1.522    50.576     0.150
     4.834   128.793     0.150
     1.182    21.238     0.150
     1.182    36.209     0.150
     1.324    23.217     0.150
     1.483    51.547     0.150
     1.572    47.484     0.150
     1.627    27.680     0.150
     1.627    49.082     0.150
     1.879    31.432     0.150
     1.879    55.238     0.150
     2.039    33.182     0.150
     2.348    37.266     0.150
     2.348    65.857     0.150
     2.941    84.826     0.150
     2.999    87.736     0.150
     3.300    95.168     0.150
     3.559   100.629     0.150
     3.669   106.977     0.150
     3.772   109.906     0.150
     4.475   123.088     0.150
     4.662   125.830     0.150
     5.081   139.160     0.150
     5.208    76.883     0.150
     5.333    78.336     0.150
     5.458    81.283     0.150
     6.778   100.873     0.150
     6.843   104.094     0.150
     7.037   104.514     0.150
     1.026    33.507     0.150
     1.605    52.820     0.150
     2.348    40.311     0.150
     2.348    69.656     0.150
     2.548    66.965     0.150
     3.121    46.493     0.150
     3.369    95.875     0.150
     3.534    98.781     0.150
     3.899    60.176     0.150
     3.899   106.015     0.150
     4.025    61.521     0.150
     4.154    61.096     0.150
     4.154   108.138     0.150
     4.481    67.208     0.150
     5.164   138.222     0.150
     5.649    77.778     0.150
     5.649   133.358     0.150
     6.149    94.258     0.150
     7.586   113.288     0.150
     6.614    89.988     0.150
     6.614   155.230     0.150
     0.479    18.758     0.150
     0.773    28.121     0.150
     1.309    24.637     0.150
     1.854    58.781     0.150
     1.840    58.820     0.150
     2.236    67.070     0.150
     2.236    67.625     0.150
     2.689    45.504     0.150
     2.784    79.613     0.150
     4.213   116.020     0.150
     4.326   118.117     0.150
     4.541    67.070     0.150
     4.603   125.820     0.150
     8.381   205.484     0.150
     1.124    34.673     0.150
     2.366    71.166     0.150
     3.342    96.756     0.150
     3.728    63.711     0.150
     3.728   110.463     0.150
     3.823   112.710     0.150
     4.466   122.190     0.150
     4.466    70.098     0.150
     4.891    74.637     0.150
     4.891   133.656     0.150
     5.173   137.789     0.150
     5.118   140.190     0.150
     5.232    78.396     0.150
     5.662    85.564     0.150
     5.904    87.339     0.150
     6.635    92.199     0.150
     6.635   159.619     0.150
     0.603    19.990     0.150
     0.802    25.975     0.150
     1.212    42.635     0.150
     1.966    31.566     0.150
     1.966    53.426     0.150
     3.655    95.717     0.150
     4.377    64.938     0.150
     5.158    77.061     0.150
     5.255    77.836     0.150
     6.272    92.412     0.150
     6.696    93.438     0.150
     6.696   161.057     0.150
     7.180   103.658     0.150
     9.105   129.889     0.150
     0.995    19.018     0.150
     1.033    20.102     0.150
     1.329    41.555     0.150
     1.585    29.666     0.150
     1.866    58.037     0.150
     2.010    61.014     0.150
     2.106    69.047     0.150
     2.419    42.840     0.150
     2.690    44.555     0.150
     2.850    84.889     0.150
     3.159    93.004     0.150
     3.785   108.777     0.150
     4.560   125.326     0.150
     4.560    71.984     0.150
     4.874   131.141     0.150
     5.194   136.475     0.150
     5.694   148.498     0.150
     5.908    87.338     0.150
     5.908   150.812     0.150
     6.624    91.984     0.150
     6.624   159.805     0.150
     8.320   123.363     0.150
     8.461   125.734     0.150
     1.045    34.023     0.150
     1.324    26.219     0.150
     1.580    54.508     0.150
     1.726    55.930     0.150
     3.379    56.367     0.150
     0.719    12.996     0.150
     0.719    22.102     0.150
     0.871    18.227     0.150
     1.949    37.270     0.150
     7.115   174.648     0.150
     0.872    26.617     0.150
     0.801    27.148     0.150
     0.940    33.789     0.150
     1.125    32.461     0.150
     1.709    25.945     0.150
     2.143    35.422     0.150
     2.143    61.812     0.150
     2.527    72.656     0.150
     3.488    49.906     0.150
     4.117   103.469     0.150
     4.345    63.469     0.150
     4.423    65.328     0.150
     4.423   110.961     0.150
     4.509    67.211     0.150
     4.822    71.328     0.150
     4.822   120.430     0.150
     5.391   134.180     0.150
     5.906   140.797     0.150
     0.411    14.235     0.150
     1.484    51.684     0.150
     2.682    79.563     0.150
     0.999    20.758     0.150
     1.436    50.000     0.150
     1.648    55.453     0.150
     2.100    60.883     0.150
     3.417    92.094     0.150
     4.934    75.469     0.150
     5.023    76.172     0.150
     5.293    79.711     0.150
     6.547    91.883     0.150
     6.547   158.383     0.150
     0.804    14.857     0.150
     1.977    34.971     0.150
     2.177    35.648     0.150
     2.628    41.219     0.150
     2.628    77.922     0.150
     3.786    61.109     0.150
     3.769   104.668     0.150
     4.789   122.734     0.150
     0.728    18.398     0.150
     0.728    31.703     0.150
     3.930    65.344     0.150
     5.791    79.641     0.150
     5.791   133.945     0.150
     0.432    18.666     0.150
     0.983    34.223     0.150
     1.462    49.334     0.150
     1.580    46.559     0.150
     2.712    79.844     0.150
     4.511   115.473     0.150
     4.526   115.523     0.150
     6.278    85.873     0.150
     1.130    38.859     0.150
     1.319    23.070     0.150
     1.564    50.961     0.150
     1.814    34.602     0.150
     2.080    62.672     0.150
     2.443    69.688     0.150
     3.602    55.242     0.150
     4.584    67.656     0.150
     4.584    67.547     0.150
     4.727    69.562     0.150
     4.805    70.641     0.150
     4.805    70.555     0.150
     4.888    71.945     0.150
     4.888    71.883     0.150
     5.135    75.227     0.150
     5.135    75.211     0.150
     5.195    76.094     0.150
     5.195   131.406     0.150
     5.491    80.062     0.150
     5.725    83.656     0.150
     6.287   151.477     0.150
     0.974    28.916     0.150
     1.869    32.427     0.150
     1.869    59.611     0.150
     1.934    64.680     0.150
     2.038    58.944     0.150
     2.890    47.373     0.150
     4.836    72.205     0.150
     4.836   124.338     0.150
     5.537    84.157     0.150
     5.837    86.700     0.150
     6.036   153.711     0.150
     6.087   157.144     0.150
     0.594    22.480     0.150
     0.939    28.953     0.150
     0.891    32.301     0.150
     1.573    30.785     0.150
     1.508    42.250     0.150
     1.795    53.852     0.150
     2.085    36.176     0.150
     2.085    66.605     0.150
     2.008    66.172     0.150
     2.503    40.230     0.150
     2.743    80.223     0.150
     3.000    79.863     0.150
     3.162    87.750     0.150
     3.341    56.324     0.150
     3.747   106.004     0.150
     3.944   110.680     0.150
     4.284   117.227     0.150
     4.570   121.727     0.150
     4.636    69.520     0.150
     4.780    71.023     0.150
     4.780    71.078     0.150
     4.745   130.914     0.150
     5.118    75.766     0.150
     5.118   130.875     0.150
     5.130    76.262     0.150
     5.196    76.402     0.150
     5.219   137.879     0.150
     5.370   137.344     0.150
     5.419    79.273     0.150
     5.640    83.352     0.150
     5.936   153.691     0.150
     6.533    89.301     0.150
     6.533   154.539     0.150
     6.109    90.715     0.150
     6.370   162.555     0.150
     6.634    98.074     0.150
     8.280   118.000     0.150
     0.651    21.969     0.150
     6.583    89.898     0.150
     6.583   155.711     0.150
     7.349   101.984     0.150
     0.553    21.639     0.150
     1.198    37.061     0.150
     1.198    38.086     0.150
     1.347    25.982     0.150
     1.497    50.836     0.150
     1.804    55.900     0.150
     2.311    68.287     0.150
     2.420    38.543     0.150
     2.896    44.529     0.150
     3.561   100.145     0.150
     3.889    58.736     0.150
     3.889   105.125     0.150
     3.918    59.096     0.150
     4.193    62.600     0.150
     4.493    69.438     0.150
     5.175    75.115     0.150
     5.175   138.314     0.150
     5.634    77.717     0.150
     5.634   134.896     0.150
     5.552    80.867     0.150
     5.598    83.146     0.150
     5.795    84.471     0.150
     5.855    87.996     0.150
     6.541   168.486     0.150
     7.323   107.758     0.150
     7.610   109.416     0.150
     8.008   114.684     0.150
    20.552   276.826     0.150
    34.062   402.262     0.150
     1.329    42.453     0.150
     1.635    49.492     0.150
     1.473    50.324     0.150
     1.550    51.750     0.150
     1.808    34.789     0.150
     1.934    33.852     0.150
     3.228    95.477     0.150
     5.543    84.297     0.150
     5.633    85.176     0.150
     6.065    87.258     0.150
     6.293    93.078     0.150
     6.293   159.395     0.150
     7.490   111.625     0.150
     0.835    15.503     0.150
     1.088    34.809     0.150
     1.192    41.403     0.150
     1.300    44.985     0.150
     2.367    68.801     0.150
     2.367    42.296     0.150
     5.849    79.814     0.150
     5.849   138.305     0.150
     6.143   153.944     0.150
     0.717    12.188     0.150
     0.717    20.959     0.150
     1.626    53.518     0.150
     1.775    32.043     0.150
     1.887    36.064     0.150
     1.887    60.855     0.150
     2.807    47.240     0.150
     2.861    48.467     0.150
     3.358    96.980     0.150
     3.860   108.334     0.150
     5.500    81.453     0.150
     5.864    86.564     0.150
     6.211    91.184     0.150
    13.024    58.984     0.150
    13.024   103.111     0.150
     0.897    32.254     0.150
     1.026    36.580     0.150
     1.511    52.417     0.150
     2.529    75.427     0.150
     2.854    49.775     0.150
     2.854    86.005     0.150
     2.907    86.747     0.150
     3.080    51.361     0.150
     3.058    83.948     0.150
     3.296    95.455     0.150
     3.296    61.099     0.150
     3.296    91.807     0.150
     3.588    58.132     0.150
     3.588    97.243     0.150
     5.697    87.260     0.150
     5.811   148.998     0.150
     5.829    87.820     0.150
     5.832   150.563     0.150
     5.832    87.461     0.150
     5.832   149.424     0.150
     6.168    92.743     0.150
     6.192    92.146     0.150
     7.124   107.133     0.150
     7.585   105.913     0.150
     7.585   183.043     0.150
     7.431   109.663     0.150
     7.431   189.503     0.150
     7.665   114.454     0.150
     8.760   126.433     0.150
    11.143    84.818     0.150
     0.695    15.553     0.150
     2.276    66.100     0.150
     2.670    46.545     0.150
     3.505    94.203     0.150
     3.481    56.578     0.150
     3.481    97.750     0.150
     3.728   106.547     0.150
     4.300   117.305     0.150
     4.332    69.598     0.150
     5.301    79.357     0.150
     5.496    82.699     0.150
     6.685    91.229     0.150
     6.685   158.648     0.150
     6.441    96.826     0.150
     6.735    99.268     0.150
     1.669    47.195     0.150
     2.698    44.951     0.150
     2.760    79.196     0.150
     2.760    75.611     0.150
     2.887    83.672     0.150
     4.524    67.432     0.150
     4.524   116.421     0.150
     4.863    72.824     0.150
     4.975    73.964     0.150
     5.353    79.774     0.150
     6.273    85.784     0.150
     6.273   148.374     0.150
     0.561     9.085     0.150
     0.561    16.039     0.150
     0.873    32.168     0.150
     3.967    57.992     0.150
     5.260    71.712     0.150
     5.260   123.412     0.150
     2.896    82.523     0.150
     0.318     8.125     0.150
     0.450    10.477     0.150
     0.716    23.367     0.150
     1.297    26.953     0.150
     1.297    46.438     0.150
     1.731    33.516     0.150
     1.704    54.797     0.150
     1.767    34.102     0.150
     1.968    63.008     0.150
     1.961    55.406     0.150
     2.763    46.430     0.150
     2.763    46.133     0.150
     2.763    41.898     0.150
     2.763    71.586     0.150
     0.638    19.863     0.150
     1.557    50.414     0.150
     1.836    34.650     0.150
     1.836    58.838     0.150
     2.660    75.779     0.150
     3.579    53.248     0.150
     3.514   100.484     0.150
     3.644    66.531     0.150
     4.047    58.895     0.150
     1.708    32.375     0.150
     1.708    54.719     0.150
     2.115    33.195     0.150
     3.139    53.836     0.150
     3.139    95.133     0.150
     4.126    62.422     0.150
     4.220   110.211     0.150
     4.756   124.000     0.150
    12.884    74.305     0.150
     0.693    27.316     0.150
     1.103    19.088     0.150
     1.286    43.820     0.150
     2.288    63.250     0.150
     2.109    65.877     0.150
     2.080    67.447     0.150
     2.379    41.603     0.150
     6.786   102.850     0.150
     0.738    15.594     0.150
     0.738    26.680     0.150
     0.738    24.070     0.150
     0.950    32.008     0.150
     2.209    65.578     0.150
     2.209    62.141     0.150
     3.841    61.633     0.150
     4.428    66.727     0.150
     4.428   114.039     0.150
     5.579   141.180     0.150
     5.690   143.641     0.150
    13.708    63.211     0.150
     1.271    41.176     0.150
     1.271    24.805     0.150
     1.271    24.334     0.150
     1.271    24.855     0.150
     1.577    31.818     0.150
     1.577    46.312     0.150
     2.051    57.668     0.150
     4.012   114.293     0.150
     4.524   129.174     0.150
     4.851   132.332     0.150
     5.400   145.998     0.150
     5.639    85.227     0.150
     5.710   153.504     0.150
     5.768   155.832     0.150
     6.364    94.936     0.150
     6.433   176.279     0.150
     6.681   169.033     0.150
     6.681    99.484     0.150
     6.684    94.234     0.150
     6.766    96.045     0.150
     6.944    96.305     0.150
     6.952   102.926     0.150
     6.996    97.598     0.150
     7.048   104.070     0.150
     7.048   190.773     0.150
     7.233   194.914     0.150
     7.304    99.152     0.150
     7.304   181.455     0.150
     7.531   104.846     0.150
     7.636   108.098     0.150
     7.744   113.346     0.150
     7.753   208.115     0.150
     7.942   115.975     0.150
     8.084   117.270     0.150
     8.465   123.727     0.150
     8.457   123.998     0.150
     8.793   233.738     0.150
     8.830   123.480     0.150
     8.830   128.115     0.150
     8.845   231.926     0.150
     8.873   122.963     0.150
     8.947   237.879     0.150
     9.028   127.104     0.150
     9.250   129.533     0.150
     9.420   132.281     0.150
     9.503   133.574     0.150
     9.456   246.641     0.150
     9.529   132.281     0.150
     9.543   132.021     0.150
     9.592   134.092     0.150
     9.619   132.539     0.150
     9.645   132.539     0.150
     9.673   134.352     0.150
     9.676   135.387     0.150
     9.733   134.609     0.150
    10.102   252.113     0.150
    19.447   268.115     0.150
    19.721   272.793     0.150
    20.110   278.727     0.150
    20.498   282.465     0.150
    20.701   283.543     0.150
    21.217   289.000     0.150
    22.051   299.305     0.150
    22.454   302.846     0.150
    22.660   302.615     0.150
    22.871   306.676     0.150
    22.871   306.615     0.150
    23.292   309.115     0.150
    23.960   322.416     0.150
    24.183   319.715     0.150
    24.934   327.256     0.150
    24.996   326.596     0.150
    25.211   331.316     0.150
    25.210   327.541     0.150
    25.210   327.426     0.150
    26.211   336.625     0.150
    27.195   345.695     0.150
    27.399   347.086     0.150
    27.492   352.016     0.150
    28.409   355.805     0.150
   105.714   369.416     0.150
    31.171   379.604     0.150
    31.171   379.605     0.150
    32.227   388.326     0.150
    32.761   847.205     0.150
    50.266   537.506     0.150
    57.507   591.686     0.150
    60.022   607.326     0.150
    63.027   628.695     0.150
    66.459   651.916     0.150
    67.352   657.641     0.150
    67.352   657.646     0.150
    35.003   669.826     0.150
    69.918   672.715     0.150
    75.619   706.566     0.150
    75.776   707.316     0.150
    76.126   710.465     0.150
    76.126   710.465     0.150
    80.694   736.477     0.150
    22.377   762.355     0.150
    85.945     6.102     0.150
    90.478   784.016     0.150
    93.487   798.596     0.150
     7.942   116.166     0.150
    13.616   195.646     0.150
     0.797    13.850     0.150
     1.073    41.123     0.150
     3.084    45.730     0.150
     3.084    81.988     0.150
     3.084    84.260     0.150
     3.084    46.412     0.150
     2.911    85.639     0.150
     3.588    52.943     0.150
     3.802    57.145     0.150
     3.802    61.451     0.150
     3.878    59.418     0.150
     3.878   105.830     0.150
     3.960   105.268     0.150
     4.002    59.986     0.150
     4.189    66.400     0.150
     4.438    69.801     0.150
     4.489   116.057     0.150
     4.680    73.051     0.150
     5.102    79.250     0.150
     5.598   139.371     0.150
     5.572    86.111     0.150
     0.356     7.818     0.150
     1.657    33.178     0.150
     1.806    33.967     0.150
     1.913    33.867     0.150
     2.739    45.658     0.150
     2.739    45.736     0.150
     2.812    80.719     0.150
     2.866    83.488     0.150
     2.866    83.594     0.150
     2.866    47.645     0.150
     3.018    48.957     0.150
     4.731    72.496     0.150
     4.985    74.947     0.150
     4.985    74.809     0.150
     5.052    75.918     0.150
     5.267   136.629     0.150
     5.303   137.809     0.150
     5.847    87.068     0.150
     6.469    90.398     0.150
     6.469   156.768     0.150
     6.199   162.191     0.150
     6.404    94.309     0.150
     8.032   117.570     0.150
     8.723   124.768     0.150
     8.838   125.957     0.150
     8.858   126.662     0.150
     9.134   125.027     0.150
    13.967   201.268     0.150
    17.776   248.479     0.150
    21.069   283.629     0.150
    21.198   286.418     0.150
    29.696   365.066     0.150
    34.700   408.809     0.150
    61.431   617.309     0.150
    74.227   696.430     0.150
    77.616   717.496     0.150
    22.212   294.797     0.150
     1.209    35.123     0.150
     1.209    22.096     0.150
     1.209    35.123     0.150
     2.329    43.986     0.150
     2.329    75.137     0.150
     2.538    68.291     0.150
     2.538    38.887     0.150
     2.748    43.221     0.150
     2.748    72.699     0.150
     2.979    47.652     0.150
     2.979    82.076     0.150
     2.987    78.926     0.150
     2.987    45.721     0.150
     3.127    48.328     0.150
     3.127    81.100     0.150
     4.014   109.533     0.150
     4.048    60.943     0.150
     4.081    60.383     0.150
     4.081   104.029     0.150
     4.125    60.475     0.150
     4.125   104.920     0.150
     4.125   105.207     0.150
     4.147   104.936     0.150
     4.147    60.268     0.150
     4.146    60.406     0.150
     4.146   103.713     0.150
     4.146    60.406     0.150
     4.146    60.506     0.150
     4.482    65.521     0.150
     4.482   113.557     0.150
     4.538   114.637     0.150
     4.538    66.824     0.150
     4.734    68.627     0.150
     5.063    72.963     0.150
     5.063   127.283     0.150
     5.213   131.232     0.150
     5.213    75.117     0.150
     5.213    75.846     0.150
     5.291   134.975     0.150
     5.291    78.857     0.150
     5.348    77.078     0.150
     5.348   133.418     0.150
     5.348    77.605     0.150
     5.899    78.936     0.150
     5.899   136.137     0.150
     5.759    83.076     0.150
     5.759   144.377     0.150
     7.724   111.516     0.150
     0.790    26.145     0.150
     0.750    15.543     0.150
     0.750    27.086     0.150
     1.495    27.766     0.150
     1.495    46.930     0.150
     1.822    32.805     0.150
     1.822    54.043     0.150
     2.734    44.082     0.150
     2.734    76.137     0.150
     3.511    55.730     0.150
     3.511    55.730     0.150
     3.511    92.379     0.150
     3.388    55.262     0.150
     3.388    92.750     0.150
     3.579    55.059     0.150
     3.579    93.723     0.150
     3.579    55.027     0.150
     3.627    55.621     0.150
     3.627    96.301     0.150
     3.681    55.730     0.150
     3.681    95.742     0.150
     3.959    60.582     0.150
     3.959   103.617     0.150
     4.100    62.121     0.150
     4.100   105.938     0.150
     4.146    63.129     0.150
     4.146   108.578     0.150
     4.174    63.609     0.150
     4.174   109.109     0.150
     4.700    69.965     0.150
     4.700   121.516     0.150
     4.916    74.051     0.150
     4.916   125.328     0.150
     5.309    74.164     0.150
     5.309   129.406     0.150
     5.267    77.199     0.150
     5.267    77.199     0.150
     5.267   135.922     0.150
     5.524    82.445     0.150
     5.510    81.023     0.150
     5.510   140.195     0.150
     5.551    83.754     0.150
     5.551   139.902     0.150
     6.269    94.793     0.150
     6.269   160.578     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     2.163    35.781     0.150
     2.662    42.383     0.150
     2.662    75.383     0.150
     7.696   198.383     0.150
     8.367   123.383     0.150
     9.347   131.586     0.150
     9.915   143.180     0.150
    10.755   160.383     0.150
    10.836   157.383     0.150
    12.684   179.883     0.150
    13.486   189.383     0.150
    16.059   225.383     0.150
    17.325   246.383     0.150
    17.392   238.680     0.150
    17.399   248.781     0.150
    17.445   245.984     0.150
    17.551   247.383     0.150
    17.623   250.086     0.150
    17.774   249.781     0.150
    17.874   250.984     0.150
    18.262   255.383     0.150
    18.262   467.383     0.150
    18.379   256.883     0.150
    19.257   262.383     0.150
    20.162   276.383     0.150
    20.516   279.383     0.150
    20.760   281.383     0.150
    20.894   283.086     0.150
    21.700   292.383     0.150
    21.915   294.383     0.150
    23.143   305.383     0.150
    23.340   308.383     0.150
    23.340   560.383     0.150
    23.588   311.383     0.150
    23.588   568.383     0.150
    24.005   314.383     0.150
    24.005   580.383     0.150
    24.002   315.586     0.150
    24.002   582.383     0.150
    24.185   315.883     0.150
    24.189   315.383     0.150
    24.363   319.383     0.150
    24.363   597.383     0.150
    24.421   317.383     0.150
    24.841   323.383     0.150
    25.067   325.383     0.150
    25.984   334.984     0.150
    26.829   339.383     0.150
    26.967   342.383     0.150
    27.551   347.383     0.150
    31.583   382.383     0.150
    31.714   382.883     0.150
    34.257   407.281     0.150
    35.486   417.883     0.150
    35.526   416.383     0.150
    36.449   424.383     0.150
    38.958   446.586     0.150
    39.051   449.383     0.150
    39.031   446.383     0.150
    40.718   464.383     0.150
    40.825   466.383     0.150
    42.683   476.781     0.150
    42.683     7.602     0.150
    42.898   478.383     0.150
    42.975   479.383     0.150
    43.420   482.680     0.150
    47.157   516.383     0.150
    48.886   526.586     0.150
    54.794   570.383     0.150
    56.427   583.383     0.150
    59.015   601.383     0.150
    61.161   617.383     0.150
    64.989   640.383     0.150
    72.552   688.383     0.150
    74.675   702.586     0.150
    74.786   702.383     0.150
    77.798   718.484     0.150
    77.924   720.781     0.150
    79.246   727.383     0.150
    79.471   729.281     0.150
    79.546   728.383     0.150
    81.654   741.680     0.150
    83.905   754.984     0.150
    84.655   756.383     0.150
   152.809  1200.383     0.150
     1.376    24.305     0.150
     1.376    26.305     0.150
     2.526    40.305     0.150
     2.526    79.305     0.150
     2.591    43.305     0.150
     2.591    85.305     0.150
     2.600    41.305     0.150
     2.600    51.305     0.150
     2.600    83.305     0.150
     3.212    51.305     0.150
     3.212    62.305     0.150
     3.212   106.305     0.150
     4.327    64.105     0.150
     4.327    76.305     0.150
     4.327    79.305     0.150
     4.327   135.305     0.150
     5.619    84.504     0.150
     5.619   180.305     0.150
     7.360   108.305     0.150
     7.878   114.805     0.150
    18.955   263.305     0.150
    19.625   270.305     0.150
    19.844   270.305     0.150
    20.669   279.305     0.150
    20.859   284.305     0.150
    20.920   281.305     0.150
    23.327   308.305     0.150
    29.187   363.805     0.150
    33.076   394.305     0.150
    35.527   415.504     0.150
    35.630   417.305     0.150
    36.374   427.605     0.150
    37.511    10.000     0.150
    61.606   616.305     0.150
    67.201   653.305     0.150
    73.556   693.105     0.150
    80.896   734.504     0.150
    83.838   752.105     0.150
    84.700   755.406     0.150
     0.743    14.992     0.150
     1.458    29.992     0.150
     1.458    48.992     0.150
     1.474    28.992     0.150
     1.474    48.992     0.150
     2.146    37.992     0.150
     2.146    41.992     0.150
     2.146    69.992     0.150
     2.374    44.992     0.150
     2.525    42.992     0.150
     2.525    80.992     0.150
     4.815    73.992     0.150
     4.815    74.992     0.150
     4.815    83.992     0.150
     4.815    91.992     0.150
     5.673    87.492     0.150
     5.673    87.992     0.150
    19.016   265.992     0.150
    19.558   270.992     0.150
    20.301   298.195     0.150
    20.423   279.992     0.150
    21.629   289.992     0.150
    24.100   316.992     0.150
    78.283   724.195     0.150
     0.614    12.828     0.150
     0.614    22.328     0.150
     1.370    26.328     0.150
     2.016    37.828     0.150
     2.016    64.328     0.150
     3.660    57.531     0.150
     3.660    99.328     0.150
     5.573    84.727     0.150
     6.585    99.727     0.150
     7.497   190.328     0.150
    14.516   213.328     0.150
    14.516   217.328     0.150
    14.706   210.125     0.150
    16.347   236.031     0.150
    16.388   236.031     0.150
    17.382   436.328     0.150
    17.509   247.430     0.150
    17.509   256.328     0.150
    18.538   261.531     0.150
    18.538   478.328     0.150
    18.672   260.328     0.150
    19.094   267.328     0.150
    19.167   266.328     0.150
    19.167   482.328     0.150
    19.462   491.328     0.150
    19.714   272.328     0.150
    20.456   279.328     0.150
    20.580   282.828     0.150
    20.580   532.328     0.150
    21.488   290.328     0.150
    21.489   290.828     0.150
    21.666   292.328     0.150
    21.782   293.328     0.150
    27.634   349.625     0.150
    28.662   357.531     0.150
    33.610   401.625     0.150
    36.135   424.328     0.150
    36.209   424.328     0.150
    36.198   423.328     0.150
    38.033   438.625     0.150
    38.736   447.328     0.150
    39.841   456.328     0.150
    40.965   464.328     0.150
    48.284   526.125     0.150
    52.209   552.328     0.150
    59.930   608.430     0.150
    60.916   615.328     0.150
    61.888   621.328     0.150
    62.154   624.328     0.150
    62.549   624.328     0.150
    62.549   626.328     0.150
    64.287   635.328     0.150
    76.817   715.328     0.150
    77.052   716.828     0.150
    78.309   722.328     0.150
    80.179   733.531     0.150
     0.969    20.919     0.150
     1.672    29.919     0.150
     1.672    31.419     0.150
     1.672    32.919     0.150
     1.672    52.419     0.150
     1.828    31.419     0.150
     1.828    32.619     0.150
     1.828    54.419     0.150
     1.828    56.919     0.150
     2.017    38.419     0.150
     2.357    41.419     0.150
     2.357    43.419     0.150
     2.357    76.419     0.150
     2.882    48.219     0.150
     2.882    53.419     0.150
     2.882    89.419     0.150
     2.882    93.919     0.150
     3.309    63.819     0.150
     3.410    57.519     0.150
     3.963    61.919     0.150
     3.963   124.419     0.150
     6.081    93.419     0.150
     6.081   119.419     0.150
     7.309   106.719     0.150
     7.309   190.619     0.150
     7.882   116.419     0.150
     7.882   203.419     0.150
    17.486   437.419     0.150
    17.486   651.419     0.150
    19.476   269.419     0.150
    20.141   275.419     0.150
    20.365   278.419     0.150
    21.441   292.419     0.150
    21.529   292.419     0.150
    23.478   311.419     0.150
    27.301   344.319     0.150
    28.717   357.819     0.150
    28.717     3.399     0.150
    28.997   360.419     0.150
    38.029   438.419     0.150
    61.844   620.419     0.150
    65.140   643.919     0.150
    65.140     6.199     0.150
    67.422   657.419     0.150
    73.726   696.519     0.150
    81.093   737.019     0.150
    81.093   744.419     0.150
    84.783   758.419     0.150
     0.189     5.621     0.150
     0.189     9.121     0.150
     1.506    26.422     0.150
     1.506    49.121     0.150
     1.822    31.121     0.150
     1.822    33.422     0.150
     1.822    52.121     0.150
     1.822    54.121     0.150
     2.751    47.121     0.150
     2.751    52.121     0.150
     2.751    85.121     0.150
     2.760    44.621     0.150
     2.760    50.121     0.150
     2.760    84.621     0.150
     3.206    51.621     0.150
     3.206    92.121     0.150
     3.606    56.621     0.150
     4.058    64.621     0.150
     4.058   118.121     0.150
     4.169    67.922     0.150
     4.169   110.422     0.150
     5.042    77.121     0.150
     5.042    93.121     0.150
     5.042   146.621     0.150
     5.042   158.121     0.150
     6.219    92.121     0.150
     6.219   157.922     0.150
     6.249    92.121     0.150
     6.586    97.121     0.150
     6.586   123.121     0.150
     6.586   165.621     0.150
     7.272   106.621     0.150
     7.300   105.922     0.150
     7.300   184.621     0.150
     7.300   215.223     0.150
     8.221   119.121     0.150
     8.221   206.320     0.150
     9.343   137.223     0.150
     9.343   237.223     0.150
     9.343   292.121     0.150
    10.609   151.320     0.150
    10.804   156.621     0.150
    12.362   175.922     0.150
    12.461   174.922     0.150
    13.793   194.922     0.150
    14.120   199.621     0.150
    14.619   217.422     0.150
    14.932   213.422     0.150
    14.947   219.621     0.150
    14.974   212.820     0.150
    15.220   214.723     0.150
    15.313   216.520     0.150
    15.377   216.820     0.150
    15.519   218.723     0.150
    15.696   221.621     0.150
    15.802   221.820     0.150
    17.076   240.723     0.150
    17.160   242.621     0.150
    17.736   248.922     0.150
    17.767   249.121     0.150
    18.241   254.020     0.150
    19.315   265.621     0.150
    19.356   268.121     0.150
    19.732   273.422     0.150
    20.381   280.922     0.150
    20.574   282.121     0.150
    20.580   281.121     0.150
    20.630   278.121     0.150
    21.092   285.121     0.150
    21.647   289.422     0.150
    21.647   553.223     0.150
    21.796   291.121     0.150
    21.796   310.121     0.150
    22.025   294.121     0.150
    21.987   292.922     0.150
    22.130   296.121     0.150
    22.132   296.121     0.150
    22.338   300.121     0.150
    22.383   299.121     0.150
    22.383   299.723     0.150
    22.736   302.621     0.150
    22.906   305.121     0.150
    24.503   319.121     0.150
    24.839   323.121     0.150
    26.861   341.320     0.150
    27.404   349.621     0.150
    39.103   452.121     0.150
    59.625   605.922     0.150
    70.470   675.121     0.150
    74.951   704.121     0.150
    74.951   704.422     0.150
    75.513   707.020     0.150
    77.423   718.621     0.150
    77.956   720.320     0.150
     0.603    12.215     0.150
     0.603    23.215     0.150
     1.183    19.215     0.150
     1.183    31.715     0.150
     1.183    35.215     0.150
     1.569    28.415     0.150
     1.569    50.215     0.150
     1.801    32.215     0.150
     1.801    58.715     0.150
     2.598    42.215     0.150
     2.598    78.215     0.150
     3.055    46.215     0.150
     3.055    54.215     0.150
     3.055   100.215     0.150
     3.870    56.215     0.150
     3.858    59.215     0.150
     3.858   104.215     0.150
     4.720    73.215     0.150
     7.009   105.715     0.150
     7.009   119.215     0.150
     7.009   132.215     0.150
     7.665   111.615     0.150
    13.914   200.015     0.150
     0.609    13.648     0.150
     0.609    21.047     0.150
     1.205    20.547     0.150
     1.205    35.547     0.150
     1.769    34.047     0.150
     2.580    43.746     0.150
     2.580    81.547     0.150
     3.883    59.547     0.150
     3.860    60.047     0.150
     3.860   106.047     0.150
     4.481    72.848     0.150
     4.572    70.246     0.150
     4.572   133.746     0.150
     4.607    71.547     0.150
     6.541   170.047     0.150
     7.010   104.047     0.150
     7.010   182.547     0.150
     7.010   208.547     0.150
     7.655   113.047     0.150
     9.153   135.047     0.150
    10.249   148.047     0.150
    11.219   163.047     0.150
    14.593   212.047     0.150
    15.350   223.246     0.150
    15.390   221.445     0.150
    15.638   228.348     0.150
    15.730   230.246     0.150
    18.662   260.148     0.150
    20.783   283.047     0.150
    21.010   284.047     0.150
    21.483   289.547     0.150
    22.166   297.047     0.150
    22.523   300.547     0.150
    22.755   304.047     0.150
    22.742   304.047     0.150
    22.847   304.445     0.150
    24.867   324.047     0.150
    29.965   369.848     0.150
    33.840   403.047     0.150
    37.347   434.047     0.150
    39.195   448.047     0.150
     1.604    30.320     0.150
     1.604    53.820     0.150
     1.940    35.320     0.150
     1.940    61.820     0.150
     2.250    39.320     0.150
     2.250    41.820     0.150
     2.250    66.820     0.150
     2.454    41.820     0.150
     4.599    73.820     0.150
     4.599   123.820     0.150
     4.599   134.820     0.150
     4.857    75.023     0.150
     5.448    84.422     0.150
     5.546    84.922     0.150
     5.546   146.117     0.150
     5.458    84.422     0.150
     5.458   144.617     0.150
     5.521    86.219     0.150
     5.521   144.820     0.150
     5.656    86.320     0.150
     5.778    86.820     0.150
     5.778   147.820     0.150
     5.894    88.820     0.150
     5.894   151.320     0.150
     6.733   102.422     0.150
     7.089   106.820     0.150
     7.089   183.820     0.150
     7.073   106.820     0.150
     7.476   111.023     0.150
     7.653   114.820     0.150
     7.653   196.820     0.150
     7.703   115.320     0.150
     8.014   119.320     0.150
     8.156   119.617     0.150
     8.156   205.820     0.150
     8.443   126.820     0.150
     8.648   127.117     0.150
     8.648   218.117     0.150
     8.657   126.422     0.150
     8.657   217.320     0.150
     8.759   128.023     0.150
     8.759   219.820     0.150
     9.578   139.320     0.150
     9.578   240.320     0.150
    10.039   148.820     0.150
    10.757   159.320     0.150
    11.249   162.820     0.150
    11.249   278.320     0.150
    11.963   174.023     0.150
    13.510   195.320     0.150
    13.595   193.820     0.150
    13.722   199.617     0.150
    13.834   199.617     0.150
    14.207   204.422     0.150
    14.747   214.820     0.150
    15.257   219.117     0.150
    15.245   218.320     0.150
    15.481   221.820     0.150
    15.552   222.523     0.150
    15.642   224.117     0.150
    15.913   228.023     0.150
    16.278   233.820     0.150
    16.307   234.023     0.150
    16.421   236.219     0.150
    16.567   237.617     0.150
    16.645   237.422     0.150
    16.650   237.820     0.150
    16.796   240.820     0.150
    16.763   240.820     0.150
    16.862   240.422     0.150
    17.007   244.617     0.150
    17.115   245.117     0.150
    17.137   242.820     0.150
    17.222   246.320     0.150
    17.405   247.820     0.150
    17.448   249.422     0.150
    17.424   248.320     0.150
    17.604   251.820     0.150
    17.685   251.320     0.150
    17.709   250.617     0.150
    17.910   253.820     0.150
    17.923   254.320     0.150
    18.079   254.820     0.150
    18.351   258.219     0.150
    18.373   258.422     0.150
    18.375   259.820     0.150
    18.453   259.820     0.150
    18.523   260.617     0.150
    18.543   260.320     0.150
    18.736   263.023     0.150
    18.702   264.820     0.150
    18.978   265.320     0.150
    19.001   265.422     0.150
    19.035   265.617     0.150
    19.254   268.820     0.150
    19.608   272.219     0.150
    19.617   270.820     0.150
    19.617   271.422     0.150
    19.699   273.320     0.150
    19.896   275.820     0.150
    20.180   277.820     0.150
    20.180   281.820     0.150
    20.193   275.719     0.150
    20.478   280.820     0.150
    20.458   280.320     0.150
    20.535   280.219     0.150
    20.592   281.820     0.150
    20.592   286.320     0.150
    20.812   284.523     0.150
    20.812   521.922     0.150
    20.821   284.820     0.150
    20.963   286.617     0.150
    21.153   287.219     0.150
    21.639   291.820     0.150
    21.939   297.320     0.150
    22.298   298.820     0.150
    22.528   301.820     0.150
    22.528   322.820     0.150
    22.528   322.320     0.150
    22.622   304.820     0.150
    22.833   302.820     0.150
    22.909   304.820     0.150
    23.124   307.617     0.150
    23.344   309.117     0.150
    23.344   309.219     0.150
    23.349   309.820     0.150
    23.505   311.117     0.150
    23.604   312.617     0.150
    23.532   312.820     0.150
    23.691   314.820     0.150
    23.691   336.820     0.150
    23.848   316.617     0.150
    23.961   316.320     0.150
    23.961   316.219     0.150
    24.193   318.719     0.150
    24.193   348.820     0.150
    24.179   318.820     0.150
    24.702   323.820     0.150
    24.921   325.719     0.150
    24.921   325.422     0.150
    24.965   327.820     0.150
    25.087   326.820     0.150
    25.430   330.922     0.150
    25.579   334.820     0.150
    25.956   336.320     0.150
    26.100   333.820     0.150
    26.100   334.422     0.150
    26.337   339.820     0.150
    26.666   340.820     0.150
    26.666   341.617     0.150
    27.707   351.820     0.150
    30.917   378.820     0.150
    31.848   386.023     0.150
    35.324   419.023     0.150
    35.324   506.320     0.150
    35.717   420.422     0.150
    36.756   429.719     0.150
    37.400   434.922     0.150
    38.185   442.820     0.150
    38.271   442.117     0.150
    38.379   443.820     0.150
    38.974   447.820     0.150
    39.819   456.820     0.150
    40.147   456.820     0.150
    42.001   475.820     0.150
    42.128   476.617     0.150
    45.376   501.820     0.150
    46.326   509.820     0.150
    46.908   515.820     0.150
    48.389   523.820     0.150
    49.795   535.117     0.150
    49.795     3.703     0.150
    50.096   537.820     0.150
    50.947   545.820     0.150
    50.947   656.320     0.150
    51.647   550.820     0.150
    52.866   559.219     0.150
    54.090   569.523     0.150
    56.859   589.820     0.150
    57.716   593.820     0.150
    57.716   727.117     0.150
    57.796   596.320     0.150
    58.918   601.820     0.150
    58.918   602.219     0.150
    58.909   604.320     0.150
    59.374   604.820     0.150
    60.333   611.820     0.150
    60.333   612.023     0.150
    61.121   618.320     0.150
    61.307   618.820     0.150
    61.307   619.219     0.150
    61.682   622.023     0.150
    61.682   658.820     0.150
    61.783   622.820     0.150
    62.236   624.820     0.150
    62.522   627.219     0.150
    63.484   632.820     0.150
    63.484   633.219     0.150
    63.674   634.820     0.150
    64.669   639.820     0.150
    65.037   644.320     0.150
    65.032   644.820     0.150
    65.149   641.023     0.150
    65.996   648.820     0.150
    65.996   649.023     0.150
    66.006   648.820     0.150
    66.006   649.219     0.150
    68.209   662.820     0.150
    69.609   671.523     0.150
    70.355   674.820     0.150
    70.400   676.422     0.150
    71.875   685.820     0.150
    71.875     4.000     0.150
    72.461   689.422     0.150
    74.755   703.820     0.150
    74.755   704.117     0.150
    75.916   709.320     0.150
    76.134   710.820     0.150
    76.134   710.922     0.150
    76.286   712.617     0.150
    76.333   712.617     0.150
    76.539   713.617     0.150
    76.668   714.820     0.150
    76.856   715.023     0.150
    77.196   715.820     0.150
    77.196   716.219     0.150
    77.996   722.820     0.150
    78.418   725.320     0.150
    79.158   728.820     0.150
    79.342   729.922     0.150
    79.601   730.023     0.150
    80.288   734.820     0.150
    80.400   734.219     0.150
    80.400     3.602     0.150
    82.719   745.820     0.150
    82.550   745.820     0.150
    83.049   749.523     0.150
    83.806   751.820     0.150
    84.207   754.820     0.150
    85.266   761.320     0.150
    86.269   764.820     0.150
    91.700   791.320     0.150
   151.944  1196.820     0.150
   151.944  1196.820     0.150
     2.391    38.508     0.150
     2.576    40.508     0.150
     3.074    49.008     0.150
     3.362    52.008     0.150
     3.507    54.508     0.150
     3.844    58.508     0.150
     3.863    61.008     0.150
     3.863   103.508     0.150
     4.208    64.207     0.150
     4.368    67.508     0.150
     4.970    78.508     0.150
     5.035    77.508     0.150
     5.302    79.109     0.150
     5.302   140.109     0.150
     5.336    80.508     0.150
     5.408    80.508     0.150
     5.463    81.508     0.150
     5.485    81.508     0.150
     5.566    82.008     0.150
     5.621    82.008     0.150
     5.759    85.508     0.150
     5.776    85.207     0.150
     5.776   150.508     0.150
     5.980    87.109     0.150
     6.062    89.906     0.150
     6.062   155.508     0.150
     6.316    91.906     0.150
     6.316   162.508     0.150
     6.535    96.008     0.150
     6.535   167.508     0.150
     6.553    95.109     0.150
     6.626    95.809     0.150
     6.626   170.508     0.150
     6.659    96.309     0.150
     6.715    99.008     0.150
     6.930   101.508     0.150
     6.930   176.508     0.150
     7.020   102.406     0.150
     7.020   180.508     0.150
     7.534   192.508     0.150
     7.723   113.020     0.150
     7.929   114.707     0.150
     8.007   116.008     0.150
     8.447   122.008     0.150
     8.447   214.008     0.150
     8.469   121.508     0.150
     8.769   127.707     0.150
     8.769   220.508     0.150
     8.936   127.809     0.150
     9.526   135.309     0.150
     9.566   137.207     0.150
     9.737   139.508     0.150
    10.296   147.008     0.150
    10.319   150.508     0.150
    10.352   145.008     0.150
    10.329   147.180     0.150
    10.485   149.309     0.150
    11.155   159.008     0.150
    11.374   160.008     0.150
    11.457   162.906     0.150
    11.446   164.418     0.150
    11.533   163.508     0.150
    12.122   173.477     0.150
    12.098   173.207     0.150
    12.133   173.309     0.150
    12.189   173.707     0.150
    12.190   173.809     0.150
    12.202   173.609     0.150
    12.208   173.508     0.150
    12.295   175.207     0.150
    12.197   170.508     0.150
    12.307   177.508     0.150
    12.339   176.906     0.150
    12.423   178.457     0.150
    12.305   174.508     0.150
    12.436   176.746     0.150
    12.376   177.309     0.150
    12.501   177.008     0.150
    13.008   186.809     0.150
    13.853   195.609     0.150
    14.101   199.309     0.150
    14.242   202.109     0.150
    14.550   205.609     0.150
    14.765   207.609     0.150
    14.806   209.809     0.150
    14.833   210.309     0.150
    15.045   213.809     0.150
    15.305   218.406     0.150
    15.446   221.586     0.150
    15.486   218.508     0.150
    15.517   220.508     0.150
    15.537   218.109     0.150
    15.563   218.809     0.150
    15.611   220.707     0.150
    15.629   222.309     0.150
    15.660   219.309     0.150
    15.680   220.707     0.150
    15.672   221.906     0.150
    15.740   222.707     0.150
    15.792   222.809     0.150
    15.856   226.707     0.150
    15.845   224.609     0.150
    15.884   227.207     0.150
    16.053   226.508     0.150
    16.053   227.207     0.150
    16.016   228.406     0.150
    16.016   228.609     0.150
    16.091   229.109     0.150
    16.268   231.609     0.150
    16.248   232.508     0.150
    16.460   234.906     0.150
    16.499   234.109     0.150
    16.624   236.008     0.150
    16.642   237.707     0.150
    16.649   237.609     0.150
    16.909   239.207     0.150
    16.962   238.809     0.150
    16.971   239.906     0.150
    16.983   239.207     0.150
    17.184   243.707     0.150
    17.278   244.906     0.150
    17.335   242.906     0.150
    17.383   245.508     0.150
    17.512   245.707     0.150
    17.512   246.109     0.150
    17.534   247.508     0.150
    17.528   244.508     0.150
    17.528   245.309     0.150
    17.587   247.809     0.150
    17.629   245.809     0.150
    17.631   246.309     0.150
    17.799   248.629     0.150
    17.825   248.406     0.150
    17.825   249.309     0.150
    17.857   249.508     0.150
    17.857   251.008     0.150
    17.884   248.508     0.150
    17.884   248.906     0.150
    17.897   250.309     0.150
    17.897   250.707     0.150
    17.946   250.508     0.150
    17.946   251.008     0.150
    17.958   251.309     0.150
    17.958   251.199     0.150
    17.958   251.707     0.150
    18.021   252.109     0.150
    18.021   252.008     0.150
    18.052   252.008     0.150
    18.149   252.609     0.150
    18.219   253.809     0.150
    18.283   254.406     0.150
    18.283   255.109     0.150
    18.301   257.227     0.150
    18.323   255.508     0.150
    18.413   256.508     0.150
    18.413   256.809     0.150
    18.460   255.906     0.150
    18.564   257.328     0.150
    18.566   258.809     0.150
    18.566   258.707     0.150
    18.616   257.207     0.150
    18.545   256.508     0.150
    18.545   257.406     0.150
    18.617   257.738     0.150
    18.554   259.008     0.150
    18.659   259.809     0.150
    18.659   259.707     0.150
    18.683   258.508     0.150
    18.754   259.508     0.150
    18.757   259.609     0.150
    18.763   261.109     0.150
    18.916   262.207     0.150
    18.896   261.508     0.150
    19.031   263.809     0.150
    19.031   263.707     0.150
    19.073   262.906     0.150
    19.073   263.039     0.150
    19.096   263.039     0.150
    19.175   264.137     0.150
    19.187   264.309     0.150
    19.282   264.906     0.150
    19.278   265.109     0.150
    19.310   265.207     0.150
    19.569   269.008     0.150
    19.591   268.578     0.150
    19.624   269.008     0.150
    19.817   268.906     0.150
    19.914   271.309     0.150
    19.950   272.508     0.150
    19.986   272.879     0.150
    19.986   494.508     0.150
    19.972   273.207     0.150
    19.959   271.707     0.150
    20.017   273.648     0.150
    20.144   273.809     0.150
    20.193   275.738     0.150
    20.147   275.109     0.150
    20.169   273.809     0.150
    20.223   275.707     0.150
    20.293   275.879     0.150
    20.303   274.906     0.150
    20.307   276.109     0.150
    20.423   277.008     0.150
    20.520   278.508     0.150
    20.527   277.906     0.150
    20.581   279.508     0.150
    20.581   512.508     0.150
    20.654   279.109     0.150
    20.654   510.906     0.150
    20.654   278.949     0.150
    20.772   281.109     0.150
    20.772   508.508     0.150
    20.847   281.406     0.150
    20.847   285.508     0.150
    20.945   283.406     0.150
    21.058   282.508     0.150
    21.228   286.109     0.150
    21.228   285.359     0.150
    21.234   284.906     0.150
    21.340   285.898     0.150
    21.312   286.008     0.150
    21.324   286.387     0.150
    21.313   286.508     0.150
    21.474   287.109     0.150
    21.474   289.906     0.150
    21.451   287.707     0.150
    21.487   287.109     0.150
    21.485   288.680     0.150
    21.549   288.297     0.150
    21.603   289.387     0.150
    21.508   288.809     0.150
    21.545   288.727     0.150
    21.552   288.508     0.150
    21.668   289.566     0.150
    21.635   289.508     0.150
    21.647   290.777     0.150
    21.755   290.637     0.150
    21.713   290.207     0.150
    21.776   290.727     0.150
    21.781   290.789     0.150
    21.800   290.977     0.150
    21.813   291.309     0.150
    21.813   532.809     0.150
    21.813   291.418     0.150
    21.839   291.547     0.150
    21.811   292.238     0.150
    21.834   292.566     0.150
    21.852   293.508     0.150
    21.907   292.207     0.150
    21.856   293.008     0.150
    21.895   290.609     0.150
    21.862   292.508     0.150
    21.952   293.258     0.150
    22.113   297.508     0.150
    22.091   535.508     0.150
    22.207   297.008     0.150
    22.245   295.309     0.150
    22.294   298.008     0.150
    22.290   297.438     0.150
    22.394   297.609     0.150
    22.394   540.508     0.150
    22.377   298.738     0.150
    22.440   299.227     0.150
    22.736   304.508     0.150
    22.723   300.707     0.150
    22.723   543.508     0.150
    22.796   304.207     0.150
    22.772   302.469     0.150
    22.931   304.109     0.150
    23.056   306.348     0.150
    23.127   304.809     0.150
    23.127   569.508     0.150
    23.237   310.508     0.150
    23.244   309.508     0.150
    23.183   305.508     0.150
    23.183   557.508     0.150
    23.248   306.348     0.150
    23.187   307.008     0.150
    23.370   308.508     0.150
    23.448   307.609     0.150
    23.448   333.109     0.150
    23.448   558.508     0.150
    23.448   308.027     0.150
    23.459   307.508     0.150
    23.459   562.508     0.150
    23.413   308.906     0.150
    23.490   308.707     0.150
    23.490   338.008     0.150
    23.567   310.027     0.150
    23.787   310.906     0.150
    23.787   566.508     0.150
    23.839   311.508     0.150
    23.908   313.207     0.150
    23.908   566.406     0.150
    23.895   313.707     0.150
    23.944   312.809     0.150
    23.952   314.508     0.150
    23.952   572.508     0.150
    23.984   314.227     0.150
    24.114   314.508     0.150
    24.114   314.707     0.150
    24.228   317.387     0.150
    24.264   315.867     0.150
    24.316   316.508     0.150
    24.478   319.227     0.150
    24.468   319.086     0.150
    24.579   320.828     0.150
    24.625   321.508     0.150
    24.735   322.008     0.150
    24.701   321.508     0.150
    24.800   321.109     0.150
    24.845   320.809     0.150
    24.744   321.547     0.150
    24.744   589.508     0.150
    24.885   322.867     0.150
    25.238   325.508     0.150
    25.238   597.508     0.150
    25.286   327.508     0.150
    25.360   328.508     0.150
    25.441   329.508     0.150
    25.542   330.508     0.150
    25.753   330.207     0.150
    25.929   333.508     0.150
    26.103   333.508     0.150
    26.130   333.508     0.150
    26.124   334.508     0.150
    26.233   337.746     0.150
    26.245   331.309     0.150
    26.302   335.508     0.150
    26.427   337.508     0.150
    26.580   337.508     0.150
    26.580     7.199     0.150
    26.920   340.609     0.150
    27.145   344.508     0.150
    27.196   343.008     0.150
    28.103   352.508     0.150
    28.541   358.109     0.150
    29.339   363.809     0.150
    29.851   366.508     0.150
    31.299   378.809     0.150
    31.520   380.707     0.150
    31.607   384.309     0.150
    32.167   385.508     0.150
    32.167   694.508     0.150
    32.618   389.508     0.150
    33.291   399.309     0.150
    33.437   400.609     0.150
    33.681   402.906     0.150
    33.770   403.906     0.150
    34.218   406.508     0.150
    36.084   421.109     0.150
    37.386   432.508     0.150
    37.386   780.508     0.150
    38.827   445.809     0.150
    38.827   534.109     0.150
    39.411   448.508     0.150
    40.312   457.508     0.150
    40.345   457.508     0.150
    40.499   458.508     0.150
    41.035   464.508     0.150
    41.632   468.508     0.150
    41.765   468.508     0.150
    42.399   473.508     0.150
    42.559   475.906     0.150
    42.954   480.508     0.150
    43.586   486.109     0.150
    45.209   499.809     0.150
    45.797   503.809     0.150
    48.533   524.508     0.150
    49.337   529.508     0.150
    49.337   957.508     0.150
    49.337   647.508     0.150
    49.337  1114.508     0.150
    49.744   532.008     0.150
    50.906   541.008     0.150
    50.906   654.508     0.150
    51.150   542.508     0.150
    51.150   543.207     0.150
    52.398   552.809     0.150
    55.942   577.508     0.150
    55.942   578.207     0.150
    56.704   583.508     0.150
    57.823   593.809     0.150
    60.050   608.008     0.150
    60.213   609.707     0.150
    61.912   619.906     0.150
    61.912     8.602     0.150
    62.680   627.508     0.150
    63.951   635.008     0.150
    63.951    11.500     0.150
    63.951   774.508     0.150
    64.241   635.508     0.150
    64.241   636.207     0.150
    64.666   639.508     0.150
    64.633   637.508     0.150
    65.543   644.008     0.150
    65.935   645.809     0.150
    65.935  1173.508     0.150
    68.200   658.508     0.150
    68.200   659.309     0.150
    68.797   663.316     0.150
    68.797     9.180     0.150
    70.452   675.508     0.150
    70.452  1228.508     0.150
    70.577   674.547     0.150
    70.722   678.406     0.150
    71.020   677.508     0.150
    71.020  1232.508     0.150
    72.327   685.508     0.150
    72.327   702.508     0.150
    72.549   686.789     0.150
    72.549     9.320     0.150
    74.960   701.609     0.150
    75.323   703.547     0.150
    75.210   702.547     0.150
    75.196   702.508     0.150
    75.196     9.500     0.150
    75.607   704.906     0.150
    75.761   706.270     0.150
    75.813   706.586     0.150
    76.111   707.906     0.150
    76.016   707.086     0.150
    76.079   708.207     0.150
    76.225   708.988     0.150
    76.546   713.309     0.150
    76.653   711.809     0.150
    77.347   716.309     0.150
    77.489   720.508     0.150
    77.755   718.508     0.150
    78.399   720.809     0.150
    79.516   727.809     0.150
    79.410   728.008     0.150
    79.944   728.508     0.150
    79.944   907.508     0.150
    79.944  1330.508     0.150
    80.047   730.148     0.150
    80.198   730.836     0.150
    80.526   732.508     0.150
    80.526   739.906     0.150
    80.526    11.000     0.150
    80.526  1338.508     0.150
    80.526  1656.508     0.150
    80.699   732.508     0.150
    80.882   734.508     0.150
    81.514   737.508     0.150
    81.514     8.102     0.150
    81.622   739.027     0.150
    81.826   738.508     0.150
    81.826   739.309     0.150
    81.881   739.387     0.150
    81.881     8.691     0.150
    82.086   740.039     0.150
    82.507   743.406     0.150
    82.930   746.336     0.150
    82.930     8.293     0.150
    83.489   747.508     0.150
    83.489   748.309     0.150
    83.479   748.449     0.150
    83.622   749.906     0.150
    84.128   750.828     0.150
    84.425   752.508     0.150
    84.425   752.609     0.150
    84.719   754.508     0.150
    84.719     9.801     0.150
    84.719   754.906     0.150
    84.719     9.402     0.150
    85.048   759.430     0.150
    85.027   757.008     0.150
    85.027    14.000     0.150
    85.654   761.008     0.150
    87.690   769.508     0.150
    87.690   769.906     0.150
    88.375   771.508     0.150
    88.375   772.309     0.150
    89.493   777.109     0.150
    89.587   778.309     0.150
    89.587     8.398     0.150
    89.587    12.699     0.150
    90.158   780.008     0.150
    90.542   783.109     0.150
    91.160   785.707     0.150
   142.305  1175.906     0.150
     2.374    39.520     0.150
     2.537    41.020     0.150
     3.327    52.520     0.150
     3.478    55.520     0.150
     3.478    91.520     0.150
     3.845    61.020     0.150
     3.845   103.520     0.150
     3.804    60.520     0.150
     3.804   102.520     0.150
     4.214    64.820     0.150
     4.214   108.918     0.150
     4.957    83.520     0.150
     5.021    77.520     0.150
     5.289    78.719     0.150
     5.289   135.121     0.150
     5.320    81.520     0.150
     5.395    81.520     0.150
     5.447    83.520     0.150
     5.621    84.020     0.150
     5.621   142.621     0.150
     5.766    85.719     0.150
     5.766   147.020     0.150
     5.533    83.020     0.150
     5.533    93.020     0.150
     5.533    94.020     0.150
     5.533    96.020     0.150
     5.533   144.520     0.150
     5.533   146.520     0.150
     5.987    88.820     0.150
     5.987   152.918     0.150
     6.061    90.520     0.150
     6.061   153.820     0.150
     6.311    94.219     0.150
     6.311   160.219     0.150
     6.513    96.020     0.150
     6.531    96.219     0.150
     6.616    97.918     0.150
     6.616   166.520     0.150
     6.642    97.520     0.150
     6.642   166.520     0.150
     6.718   100.621     0.150
     6.928   102.418     0.150
     7.029   103.418     0.150
     7.029   177.520     0.150
     7.537   111.020     0.150
     7.749   114.129     0.150
     7.940   116.719     0.150
     7.940   199.520     0.150
     7.986   116.020     0.150
     7.986   199.520     0.150
     8.431   122.219     0.150
     8.447   122.520     0.150
     8.776   129.141     0.150
     8.925   128.719     0.150
     9.510   136.719     0.150
     9.510   235.020     0.150
     9.548   138.219     0.150
     9.548   240.820     0.150
    10.306   147.520     0.150
    10.306   252.418     0.150
    10.329   150.520     0.150
    10.314   147.020     0.150
    11.190   159.020     0.150
    11.362   163.418     0.150
    11.441   164.219     0.150
    11.569   163.520     0.150
    11.625   165.020     0.150
    12.106   173.609     0.150
    12.106   300.520     0.150
    12.136   177.219     0.150
    12.195   177.219     0.150
    12.205   178.020     0.150
    12.212   178.320     0.150
    12.235   173.520     0.150
    12.410   177.879     0.150
    12.410   306.520     0.150
    12.342   174.520     0.150
    12.538   178.520     0.150
    13.042   185.520     0.150
    14.107   202.020     0.150
    14.247   203.418     0.150
    14.558   206.918     0.150
    14.771   209.719     0.150
    14.823   211.820     0.150
    14.850   212.418     0.150
    15.063   214.918     0.150
    15.320   218.820     0.150
    15.322   219.520     0.150
    15.507   220.719     0.150
    15.554   222.320     0.150
    15.628   222.918     0.150
    15.641   221.449     0.150
    15.666   221.219     0.150
    15.683   222.621     0.150
    15.660   223.051     0.150
    15.689   223.820     0.150
    15.757   224.621     0.150
    15.810   224.621     0.150
    15.862   223.520     0.150
    15.861   225.820     0.150
    15.891   224.621     0.150
    15.904   228.949     0.150
    15.912   227.758     0.150
    15.932   230.039     0.150
    16.014   231.141     0.150
    16.070   230.820     0.150
    16.204   232.930     0.150
    16.200   233.711     0.150
    16.263   234.520     0.150
    16.276   230.020     0.150
    16.286   232.520     0.150
    16.343   232.469     0.150
    16.478   236.719     0.150
    16.587   236.629     0.150
    16.532   234.719     0.150
    16.626   235.820     0.150
    16.633   236.219     0.150
    16.656   235.418     0.150
    16.664   235.219     0.150
    16.695   238.051     0.150
    16.763   238.121     0.150
    16.782   239.148     0.150
    16.917   239.020     0.150
    16.963   239.020     0.150
    16.979   239.520     0.150
    16.968   241.098     0.150
    17.016   241.328     0.150
    17.122   242.121     0.150
    17.204   242.719     0.150
    17.198   245.219     0.150
    17.235   244.219     0.150
    17.275   245.219     0.150
    17.279   244.781     0.150
    17.254   244.598     0.150
    17.297   246.020     0.150
    17.335   244.918     0.150
    17.389   245.820     0.150
    17.533   250.020     0.150
    17.556   250.520     0.150
    17.553   246.621     0.150
    17.603   250.219     0.150
    17.664   246.918     0.150
    17.806   251.020     0.150
    17.827   251.301     0.150
    17.848   251.121     0.150
    17.880   252.289     0.150
    17.911   251.320     0.150
    17.968   254.418     0.150
    18.037   253.621     0.150
    18.086   253.020     0.150
    18.167   255.121     0.150
    18.231   254.320     0.150
    18.347   258.219     0.150
    18.491   257.918     0.150
    18.577   258.410     0.150
    18.583   259.918     0.150
    18.627   259.320     0.150
    18.629   258.758     0.150
    18.577   259.621     0.150
    18.674   260.719     0.150
    18.693   259.320     0.150
    18.766   260.020     0.150
    18.789   261.918     0.150
    18.795   262.320     0.150
    18.930   262.219     0.150
    18.927   263.320     0.150
    19.048   265.820     0.150
    19.085   263.719     0.150
    19.109   263.949     0.150
    19.201   265.219     0.150
    19.294   265.918     0.150
    19.297   267.320     0.150
    19.321   266.320     0.150
    19.604   269.531     0.150
    19.847   271.020     0.150
    19.932   272.520     0.150
    19.962   273.520     0.150
    19.993   274.621     0.150
    19.993   493.520     0.150
    19.976   272.621     0.150
    20.027   284.520     0.150
    20.032   275.020     0.150
    20.161   274.719     0.150
    20.168   274.621     0.150
    20.186   274.320     0.150
    20.186   287.219     0.150
    20.242   276.719     0.150
    20.299   276.270     0.150
    20.326   275.320     0.150
    20.334   276.918     0.150
    20.444   278.219     0.150
    20.548   280.520     0.150
    20.587   279.520     0.150
    20.587   513.520     0.150
    20.378   516.918     0.150
    20.670   280.020     0.150
    20.670   509.621     0.150
    20.670   279.648     0.150
    20.793   282.020     0.150
    20.793   513.520     0.150
    20.833   284.141     0.150
    20.855   282.719     0.150
    20.855   284.820     0.150
    20.870   283.918     0.150
    20.953   284.520     0.150
    20.983   290.121     0.150
    21.076   284.121     0.150
    21.239   288.020     0.150
    21.239   286.250     0.150
    21.249   285.539     0.150
    21.353   287.918     0.150
    21.343   288.219     0.150
    21.409   287.258     0.150
    21.483   290.719     0.150
    21.483   528.520     0.150
    21.482   288.039     0.150
    21.474   289.520     0.150
    21.510   289.020     0.150
    21.514   289.121     0.150
    21.564   288.930     0.150
    21.541   289.020     0.150
    21.573   290.191     0.150
    21.586   293.520     0.150
    21.683   290.348     0.150
    21.666   291.520     0.150
    21.677   290.891     0.150
    21.770   291.340     0.150
    21.791   291.809     0.150
    21.744   291.918     0.150
    21.796   291.719     0.150
    21.815   292.211     0.150
    21.827   292.918     0.150
    21.827   534.520     0.150
    21.827   292.129     0.150
    21.854   292.480     0.150
    21.839   292.789     0.150
    21.863   292.871     0.150
    21.922   293.211     0.150
    21.913   291.520     0.150
    21.913   537.918     0.150
    21.882   291.418     0.150
    21.893   294.020     0.150
    21.989   541.520     0.150
    22.105   298.520     0.150
    22.058   295.020     0.150
    22.148   296.020     0.150
    22.199   299.520     0.150
    22.262   296.621     0.150
    22.302   299.520     0.150
    22.318   297.730     0.150
    22.411   298.621     0.150
    22.411   541.520     0.150
    22.411   543.520     0.150
    22.406   298.828     0.150
    22.413   297.820     0.150
    22.469   299.539     0.150
    22.527   300.520     0.150
    22.578   300.020     0.150
    22.597   301.648     0.150
    22.728   301.520     0.150
    22.736   301.520     0.150
    22.736   547.520     0.150
    22.803   303.559     0.150
    23.006   307.520     0.150
    22.963   305.520     0.150
    23.147   305.520     0.150
    23.147   557.520     0.150
    23.260   307.230     0.150
    23.213   329.520     0.150
    23.213   559.520     0.150
    23.213   759.520     0.150
    23.222   310.520     0.150
    23.394   308.520     0.150
    23.465   308.520     0.150
    23.465   310.219     0.150
    23.465   308.781     0.150
    23.475   308.520     0.150
    23.446   310.281     0.150
    23.511   309.121     0.150
    23.598   313.039     0.150
    23.801   311.918     0.150
    23.854   312.918     0.150
    23.854   571.520     0.150
    23.821   313.520     0.150
    23.930   313.820     0.150
    23.963   313.820     0.150
    23.963   575.320     0.150
    23.927   314.961     0.150
    23.986   317.020     0.150
    24.015   315.199     0.150
    24.103   318.418     0.150
    24.137   315.520     0.150
    24.260   319.141     0.150
    24.297   318.719     0.150
    24.553   323.520     0.150
    24.693   323.621     0.150
    24.748   322.520     0.150
    24.472   319.859     0.150
    24.814   322.020     0.150
    24.814   591.020     0.150
    24.862   321.820     0.150
    24.867   321.520     0.150
    25.013   325.121     0.150
    24.748   321.680     0.150
    24.748   592.520     0.150
    24.889   323.840     0.150
    25.233   330.121     0.150
    25.258   327.520     0.150
    25.258   598.520     0.150
    25.311   328.520     0.150
    25.387   329.520     0.150
    25.709   334.418     0.150
    25.774   331.621     0.150
    26.077   334.520     0.150
    26.123   334.418     0.150
    26.149   334.418     0.150
    26.147   335.520     0.150
    26.278   335.520     0.150
    26.372   338.520     0.150
    26.372   339.520     0.150
    26.454   340.520     0.150
    26.603   338.520     0.150
    26.603    10.000     0.150
    26.603   385.219     0.150
    26.808   343.520     0.150
    26.808   344.520     0.150
    26.811   337.520     0.150
    26.927   343.520     0.150
    27.157   347.520     0.150
    27.225   345.520     0.150
    27.225   346.020     0.150
    27.484   347.020     0.150
    27.484   543.520     0.150
    27.717   350.520     0.150
    28.130   353.520     0.150
    28.191   641.520     0.150
    28.732   359.020     0.150
    28.732   359.520     0.150
    28.842   359.520     0.150
    28.842   357.520     0.150
    28.814   359.418     0.150
    29.266   363.520     0.150
    29.375   364.520     0.150
    29.695   367.520     0.150
    29.877   367.520     0.150
    29.877     8.000     0.150
    29.877   421.520     0.150
    29.877   666.520     0.150
    30.727   377.020     0.150
    31.071   380.020     0.150
    31.199   381.520     0.150
    31.306   380.121     0.150
    31.525   381.918     0.150
    31.643   385.520     0.150
    32.099   389.520     0.150
    32.177   390.121     0.150
    32.177   697.520     0.150
    32.837   396.121     0.150
    32.889   393.520     0.150
    33.330   399.719     0.150
    33.402   401.621     0.150
    33.577   403.020     0.150
    33.609   404.520     0.150
    33.609   728.520     0.150
    33.613   404.520     0.150
    33.787   404.520     0.150
    33.800   405.121     0.150
    33.846   404.418     0.150
    35.189   414.520     0.150
    35.189   745.520     0.150
    35.189   495.520     0.150
    35.189   897.520     0.150
    36.092   420.719     0.150
    36.092     9.602     0.150
    36.683   424.020     0.150
    36.710   513.520     0.150
    36.710   577.520     0.150
    36.710   773.520     0.150
    36.687   429.520     0.150
    36.687   773.520     0.150
    36.687   515.520     0.150
    37.049   427.520     0.150
    37.407   434.520     0.150
    37.407     6.000     0.150
    37.407   779.520     0.150
    38.202   440.520     0.150
    38.202   524.520     0.150
    38.202   786.520     0.150
    38.858   446.520     0.150
    38.858   801.020     0.150
    38.858   447.219     0.150
    39.130   449.520     0.150
    39.130    10.000     0.150
    39.130   544.520     0.150
    39.130   797.520     0.150
    39.416   451.520     0.150
    40.190   454.520     0.150
    40.190   827.520     0.150
    40.345   458.121     0.150
    40.345     9.398     0.150
    40.345   828.520     0.150
    40.345   991.520     0.150
    40.378   457.520     0.150
    40.378    10.000     0.150
    40.378   828.520     0.150
    40.506   459.020     0.150
    41.066   466.520     0.150
    41.066     9.000     0.150
    41.066   833.520     0.150
    41.666   471.520     0.150
    41.666   839.520     0.150
    41.800   471.520     0.150
    42.405   476.520     0.150
    42.356   477.520     0.150
    42.356   849.520     0.150
    42.568   476.520     0.150
    43.334   486.520     0.150
    43.334   870.520     0.150
    45.831   505.020     0.150
    48.571   526.520     0.150
    49.371   532.520     0.150
    49.371   959.520     0.150
    49.371   645.520     0.150
    49.766   532.520     0.150
    49.766     7.000     0.150
    49.766   962.520     0.150
    49.766     9.500     0.150
    50.680   667.520     0.150
    50.927   541.520     0.150
    50.927   652.520     0.150
    50.927   970.520     0.150
    52.433   553.520     0.150
    52.433  1003.520     0.150
    55.377   575.758     0.150
    55.905   580.859     0.150
    56.728   584.520     0.150
    56.728  1048.520     0.150
    58.046   594.020     0.150
    60.249   609.621     0.150
    60.078   742.219     0.150
    61.882   622.801     0.150
    61.969   622.520     0.150
    61.969     6.000     0.150
    61.969   754.520     0.150
    61.969  1127.520     0.150
    61.969     9.000     0.150
    61.942   621.020     0.150
    61.942  1127.520     0.150
    63.278   631.051     0.150
    63.631   631.520     0.150
    63.631  1148.520     0.150
    63.631  1393.520     0.150
    63.625   631.520     0.150
    63.625  1148.520     0.150
    63.625  1393.520     0.150
    63.982   635.020     0.150
    63.982  1151.520     0.150
    63.982  1160.520     0.150
    64.202   637.801     0.150
    64.133   636.020     0.150
    64.555   639.520     0.150
    65.529   647.520     0.150
    65.957   647.918     0.150
    65.957  1170.520     0.150
    66.745   652.719     0.150
    67.907   662.719     0.150
    68.163   660.941     0.150
    68.760   663.609     0.150
    69.081   667.719     0.150
    70.480   676.020     0.150
    70.480   689.020     0.150
    70.480   839.520     0.150
    70.540   674.168     0.150
    71.042   677.520     0.150
    71.042  1234.520     0.150
    74.767   703.520     0.150
    74.923   702.020     0.150
    75.245   704.020     0.150
    75.290   704.180     0.150
    75.234   703.520     0.150
    75.234     5.000     0.150
    75.234  1281.520     0.150
    75.571   705.621     0.150
    75.847   706.820     0.150
    76.051   708.621     0.150
    76.074   709.418     0.150
    76.186   709.520     0.150
    76.118   708.520     0.150
    76.259   710.121     0.150
    76.674   713.520     0.150
    76.674  1295.520     0.150
    76.674  1588.520     0.150
    77.389   714.820     0.150
    77.313   717.520     0.150
    77.313  1311.520     0.150
    77.540   719.320     0.150
    77.794   719.520     0.150
    79.443   728.719     0.150
    79.485   728.121     0.150
    80.032   731.988     0.150
    80.185   732.570     0.150
    80.553   734.320     0.150
    80.553   740.918     0.150
    80.553    10.000     0.150
    80.553  1337.520     0.150
    80.865   736.941     0.150
    81.485   738.398     0.150
    81.485   748.559     0.150
    81.587   740.801     0.150
    81.587   748.160     0.150
    81.643   743.520     0.150
    81.848   739.660     0.150
    81.907   739.668     0.150
    81.967   741.969     0.150
    82.052   740.559     0.150
    82.897   745.660     0.150
    83.200   747.020     0.150
    83.466   749.711     0.150
    83.456   749.051     0.150
    83.639   749.051     0.150
    84.099   751.359     0.150
    84.409   753.121     0.150
    84.409     5.328     0.150
    84.685   755.691     0.150
    84.686   754.699     0.150
    84.686     8.559     0.150
    85.055   758.020     0.150
    85.055     7.000     0.150
    85.055   951.520     0.150
    85.055  1378.520     0.150
    85.055  1393.520     0.150
    86.236   964.520     0.150
    87.983  1414.520     0.150
    88.341   772.879     0.150
    88.211   773.418     0.150
    89.190   777.770     0.150
    89.615   779.520     0.150
    90.575     6.500     0.150
    91.195   787.520     0.150
   141.264  1170.020     0.150
   142.345  1176.520     0.150
   145.993  1182.520     0.150
   151.018  1195.020     0.150
   151.339  1197.719     0.150
   152.059  1196.520     0.150
   152.144  1197.820     0.150
   159.677  1243.520     0.150
     0.149     5.688     0.150
     0.149     9.188     0.150
     0.701    15.387     0.150
     0.701    23.688     0.150
     1.070    20.188     0.150
     1.761    29.688     0.150
     1.761    51.688     0.150
     1.764    31.188     0.150
     1.764    51.688     0.150
     1.839    32.188     0.150
     1.839    56.188     0.150
     1.903    37.188     0.150
     2.042    32.887     0.150
     2.055    35.688     0.150
     2.342    65.688     0.150
     2.689    43.688     0.150
     2.705    75.688     0.150
     2.960    47.887     0.150
     3.134    49.688     0.150
     3.295    51.586     0.150
     3.295    90.188     0.150
     3.790    59.688     0.150
     3.790   100.188     0.150
     3.833    58.188     0.150
     3.833   102.688     0.150
     4.255    64.688     0.150
     4.255   111.688     0.150
     4.416    66.688     0.150
     4.416   116.188     0.150
     4.631    69.188     0.150
     5.025    74.688     0.150
     5.813    86.887     0.150
     5.813   148.688     0.150
     6.934   100.188     0.150
     6.934   173.887     0.150
     6.934    99.988     0.150
     0.773    15.906     0.150
     0.827    29.207     0.150
     0.998    21.008     0.150
     0.998    33.105     0.150
     1.540    29.207     0.150
     1.776    32.707     0.150
     2.120    38.207     0.150
     2.120    63.707     0.150
     2.587    42.207     0.150
     2.587    75.207     0.150
     2.505    46.207     0.150
     2.505    73.207     0.150
     2.769    45.906     0.150
     2.769    76.809     0.150
     2.806    47.809     0.150
     2.806    78.707     0.150
     2.961    49.707     0.150
     2.961    81.508     0.150
     3.103    52.008     0.150
     3.103    85.906     0.150
     3.339    54.809     0.150
     3.339    91.105     0.150
     3.636    57.707     0.150
     3.858    61.105     0.150
     3.858   104.207     0.150
     3.860    62.508     0.150
     3.860   103.906     0.150
     4.332    67.406     0.150
     4.332   115.207     0.150
     4.345    69.105     0.150
     4.345   114.906     0.150
     4.804    74.207     0.150
     4.804   127.207     0.150
     0.764    15.414     0.150
     0.764    25.414     0.150
     0.779    15.914     0.150
     0.822    17.414     0.150
     0.899    19.914     0.150
     0.899    30.914     0.150
     1.054    20.914     0.150
     1.054    36.215     0.150
     1.706    32.914     0.150
     1.706    52.914     0.150
     2.095    39.414     0.150
     2.095    62.914     0.150
     2.434    40.414     0.150
     2.434    67.914     0.150
     2.557    72.414     0.150
     2.803    46.914     0.150
     2.803    78.914     0.150
     2.827    45.414     0.150
     2.827    79.715     0.150
     2.999    49.414     0.150
     2.999    83.016     0.150
     3.111    84.516     0.150
     3.569    58.914     0.150
     3.569    97.914     0.150
     3.874    60.812     0.150
     3.874   104.113     0.150
     3.896    62.715     0.150
     4.327    65.914     0.150
     4.327   114.914     0.150
     4.396    69.414     0.150
     4.396   118.414     0.150
     4.733    75.414     0.150
     4.733   126.914     0.150
     0.523    12.549     0.150
     0.523    17.849     0.150
     0.674    13.849     0.150
     1.198    23.849     0.150
     1.198    39.349     0.150
     1.120    23.349     0.150
     1.120    38.849     0.150
     1.557    30.349     0.150
     1.557    48.849     0.150
     1.684    32.349     0.150
     1.684    51.849     0.150
     1.704    32.349     0.150
     1.704    52.849     0.150
     1.660    32.349     0.150
     1.660    52.349     0.150
     1.879    35.849     0.150
     1.879    59.349     0.150
     1.896    31.349     0.150
     1.917    34.629     0.150
     1.917    59.949     0.150
     1.867    34.849     0.150
     1.867    58.349     0.150
     2.369    42.439     0.150
     2.369    69.349     0.150
     2.325    38.349     0.150
     2.325    67.349     0.150
     2.434    44.349     0.150
     2.434    73.349     0.150
     2.803    53.049     0.150
     2.841    46.749     0.150
     2.841    82.349     0.150
     2.846    54.349     0.150
     2.874    46.999     0.150
     2.874    81.949     0.150
     2.988    47.779     0.150
     2.988    84.949     0.150
     3.049    49.559     0.150
     3.049    85.349     0.150
     3.291    53.569     0.150
     3.291    91.449     0.150
     3.442    93.949     0.150
     3.535    55.429     0.150
     3.535    97.949     0.150
     3.693    59.389     0.150
     3.693   101.349     0.150
     3.780    59.069     0.150
     3.843    60.149     0.150
     3.813    61.349     0.150
     3.813   107.349     0.150
     4.085    63.949     0.150
     4.085   111.749     0.150
     4.102    63.459     0.150
     4.102   111.949     0.150
     4.618   125.049     0.150
     4.861    74.559     0.150
     4.861   128.449     0.150
     5.224    77.349     0.150
     5.224   134.149     0.150
     6.000    88.089     0.150
     6.000   155.649     0.150
     6.252    93.729     0.150
     6.617    98.649     0.150
     6.617   168.149     0.150
     7.019   103.879     0.150
     7.019   180.749     0.150
     7.230   104.949     0.150
     7.855   114.509     0.150
    19.527   273.349     0.150
    20.126   273.149     0.150
    20.126   279.149     0.150
    20.126   294.349     0.150
     0.646    12.594     0.150
     0.646    22.594     0.150
     0.746    16.391     0.150
     0.746    26.594     0.150
     0.943    18.594     0.150
     0.943    30.594     0.150
     1.128    22.594     0.150
     1.128    37.594     0.150
     1.412    26.094     0.150
     1.412    42.594     0.150
     1.470    23.094     0.150
     1.486    28.094     0.150
     1.486    46.094     0.150
     1.574    28.594     0.150
     1.574    47.594     0.150
     1.642    30.594     0.150
     1.642    51.094     0.150
     1.761    31.594     0.150
     1.761    51.594     0.150
     2.083    37.297     0.150
     2.304    38.094     0.150
     2.304    63.891     0.150
     2.295    35.594     0.150
     2.936    46.992     0.150
     2.936    81.297     0.150
     3.032    49.094     0.150
     3.032    84.195     0.150
     3.072    50.391     0.150
     3.342    53.992     0.150
     3.342    91.195     0.150
     3.453    55.094     0.150
     3.654    55.391     0.150
     3.654    97.594     0.150
     3.717    56.094     0.150
     4.038    63.094     0.150
     4.038   108.594     0.150
     4.127    63.594     0.150
     4.127   108.391     0.150
     4.403    68.094     0.150
     4.925    75.094     0.150
     5.404   136.594     0.150
     6.527   166.094     0.150
     7.157   181.195     0.150
    20.242   274.891     0.150
    20.242   742.891     0.150
    20.242   750.391     0.150
     0.215     4.566     0.150
     0.215     7.867     0.150
     0.274     6.066     0.150
     0.274    10.367     0.150
     0.274    10.867     0.150
     0.274    11.867     0.150
     0.826    17.066     0.150
     0.826    29.367     0.150
     1.138    22.867     0.150
     1.138    37.867     0.150
     1.361    25.867     0.150
     1.361    42.367     0.150
     1.644    29.867     0.150
     1.644    51.867     0.150
     1.738    31.867     0.150
     1.738    54.367     0.150
     1.939    33.066     0.150
     1.939    57.867     0.150
     2.046    36.867     0.150
     2.046    62.867     0.150
     2.243    65.867     0.150
     2.455    41.367     0.150
     2.455    71.367     0.150
     2.604    41.367     0.150
     2.604    72.867     0.150
     2.628    43.867     0.150
     2.628    75.367     0.150
     2.713    45.066     0.150
     2.726    45.867     0.150
     2.950    52.066     0.150
     2.950    88.867     0.150
     3.215    52.367     0.150
     3.215    90.367     0.150
     3.518    55.867     0.150
     3.518    95.867     0.150
     3.649    57.867     0.150
     3.649   100.367     0.150
     3.663    57.867     0.150
     3.663    99.867     0.150
     3.716    58.566     0.150
     3.716   103.066     0.150
     3.797    59.266     0.150
     3.797   104.367     0.150
     3.913    61.168     0.150
     3.913   106.168     0.150
     3.974    60.867     0.150
     3.974   107.367     0.150
     3.972   106.766     0.150
     4.216    66.367     0.150
     4.216   113.266     0.150
     4.361    66.969     0.150
     4.361   116.867     0.150
     4.450    67.367     0.150
     4.536    67.969     0.150
     4.572    69.367     0.150
     4.572   120.668     0.150
     5.026    77.168     0.150
     5.026   134.266     0.150
     6.853   100.566     0.150
     8.055   116.867     0.150
    20.984   283.066     0.150
    20.984   287.168     0.150
    20.984   290.469     0.150
     0.645    14.664     0.150
     0.645    22.664     0.150
     0.830    15.965     0.150
     0.956    18.664     0.150
     0.956    30.664     0.150
     1.297    26.164     0.150
     1.297    42.164     0.150
     1.652    52.164     0.150
     1.988    35.164     0.150
     1.988    57.664     0.150
     1.875    33.465     0.150
     1.875    56.664     0.150
     1.923    35.445     0.150
     2.335    39.164     0.150
     2.335    65.664     0.150
     2.167    35.062     0.150
     2.167    62.965     0.150
     2.641    74.664     0.150
     2.728    43.664     0.150
     2.728    75.465     0.150
     2.830    44.965     0.150
     2.830    78.465     0.150
     2.879    46.465     0.150
     2.879    79.062     0.150
     3.575    54.465     0.150
     3.575    94.164     0.150
     3.646    96.164     0.150
     3.933    60.965     0.150
     4.252    67.164     0.150
     4.252   113.164     0.150
     5.022   128.863     0.150
     0.220     5.018     0.150
     0.220     9.018     0.150
     0.658    23.518     0.150
     0.792    16.018     0.150
     0.792    27.317     0.150
     1.100    22.018     0.150
     1.100    39.018     0.150
     1.205    22.018     0.150
     1.205    39.518     0.150
     1.583    47.018     0.150
     1.716    30.018     0.150
     1.716    52.018     0.150
     1.921    32.718     0.150
     1.921    59.218     0.150
     2.154    40.527     0.150
     2.087    34.018     0.150
     2.110    38.018     0.150
     2.110    63.518     0.150
     2.329    69.018     0.150
     2.828    46.317     0.150
     2.866    47.817     0.150
     2.866    81.417     0.150
     2.872    47.817     0.150
     2.891    46.018     0.150
     3.006    48.118     0.150
     3.006    83.518     0.150
     3.070    50.317     0.150
     3.070    87.018     0.150
     3.309    54.118     0.150
     3.309    91.718     0.150
     3.464    55.417     0.150
     3.464    96.118     0.150
     3.717    56.618     0.150
     3.717   101.118     0.150
     3.806    57.618     0.150
     3.867   102.018     0.150
     3.869    59.018     0.150
     3.869   102.518     0.150
     3.802   103.518     0.150
     4.078   107.718     0.150
     4.100    65.018     0.150
     4.100   111.018     0.150
     4.122    63.417     0.150
     4.122   111.417     0.150
     4.246    64.718     0.150
     4.246   110.817     0.150
     4.195    66.018     0.150
     4.195   112.018     0.150
     4.464    67.018     0.150
     4.464   116.917     0.150
     4.878    74.917     0.150
     4.878   129.417     0.150
     5.588    83.417     0.150
     5.588   179.118     0.150
    20.136   272.718     0.150
    20.136   277.718     0.150
    20.136   273.018     0.150
    20.260   274.018     0.150
    33.718   399.317     0.150
    68.660   662.618     0.150
     0.756    15.453     0.150
     0.756    26.453     0.150
     1.890    36.453     0.150
     1.890    55.453     0.150
     1.890    57.453     0.150
     1.890    58.453     0.150
     1.890    60.453     0.150
     1.933    33.754     0.150
     1.933    57.352     0.150
     2.010    60.453     0.150
     2.010    64.453     0.150
     2.010    65.453     0.150
     2.010    66.453     0.150
     2.739    47.773     0.150
     2.739    74.004     0.150
     2.942    48.953     0.150
     2.942    80.754     0.150
     3.078    49.555     0.150
     3.194    51.652     0.150
     3.194    86.555     0.150
     3.362    54.953     0.150
     3.362    91.055     0.150
     3.460    56.055     0.150
     3.631    58.754     0.150
     3.631    97.555     0.150
     3.681    57.754     0.150
     3.681    98.055     0.150
     3.752    57.453     0.150
     3.752    99.453     0.150
     3.872    61.852     0.150
     4.338    68.852     0.150
     4.338   116.352     0.150
     4.397    67.555     0.150
     4.397   115.754     0.150
     4.428    67.754     0.150
     4.497    69.953     0.150
     4.490    70.652     0.150
     4.490   118.852     0.150
     4.706    72.254     0.150
     4.706   124.852     0.150
     4.791    73.352     0.150
     4.791   126.453     0.150
     4.877   129.055     0.150
     5.071    77.152     0.150
     5.071   133.754     0.150
     5.087    77.152     0.150
     5.087   134.852     0.150
     5.094    77.754     0.150
     5.094   133.254     0.150
     5.144    79.953     0.150
     5.241    79.254     0.150
     5.854    88.852     0.150
     5.854   100.652     0.150
     5.865    87.754     0.150
     5.865   151.953     0.150
     5.986    90.555     0.150
     6.539    97.453     0.150
     6.539   167.352     0.150
     6.673    99.254     0.150
     6.950   103.453     0.150
     6.950   176.453     0.150
     7.207   186.953     0.150
     7.336   108.453     0.150
    16.920   239.352     0.150
    20.340   278.453     0.150
    20.554   283.453     0.150
    20.554   297.453     0.150
    21.663   290.453     0.150
    21.967   294.254     0.150
    28.953   359.152     0.150
    33.906   403.254     0.150
    68.028   659.953     0.150
    69.259   668.953     0.150
    77.805   718.852     0.150
    77.806   720.352     0.150
    78.813   725.543     0.150
    79.987   733.645     0.150
     0.700    14.852     0.150
     0.700    23.852     0.150
     1.693    31.852     0.150
     1.693    32.852     0.150
     1.693    50.352     0.150
     1.693    51.852     0.150
     1.693    53.852     0.150
     2.472    70.852     0.150
     2.472    72.852     0.150
     2.472    75.852     0.150
     3.190    51.852     0.150
     3.190    86.852     0.150
     3.251    56.852     0.150
     3.969    63.852     0.150
     3.969   109.852     0.150
     4.023    62.852     0.150
     4.023   108.852     0.150
     4.643    70.352     0.150
     4.850    73.551     0.150
     4.850   126.652     0.150
     4.869    74.051     0.150
     4.854    73.652     0.150
     4.854   126.551     0.150
     4.957    75.051     0.150
     4.957   129.852     0.150
     5.068    76.752     0.150
     5.068   133.551     0.150
     5.119    77.352     0.150
     5.119   133.551     0.150
     5.192    78.652     0.150
     5.192   135.451     0.150
     5.372    81.051     0.150
     5.372   139.652     0.150
     5.503    82.451     0.150
     5.503   141.451     0.150
     6.107    90.852     0.150
     6.107   158.352     0.150
     6.894   101.752     0.150
     6.894   175.652     0.150
     7.140   105.051     0.150
     7.695   197.051     0.150
     8.066   118.252     0.150
     8.577   124.852     0.150
     8.973   130.352     0.150
    18.166   255.352     0.150
    21.461   288.352     0.150
    21.589   290.352     0.150
    35.076   414.152     0.150
     0.783    15.791     0.150
     0.783    27.291     0.150
     0.783    28.291     0.150
     1.799    31.791     0.150
     1.799    55.791     0.150
     2.435    39.791     0.150
     2.435    67.791     0.150
     2.683    44.791     0.150
     2.683    74.791     0.150
     2.683    80.791     0.150
     3.203    49.791     0.150
     3.203    51.791     0.150
     3.231    56.490     0.150
     3.685    58.990     0.150
     3.685    95.990     0.150
     4.149    64.291     0.150
     4.149   106.891     0.150
     4.440    69.891     0.150
     4.440   116.990     0.150
     4.491   118.592     0.150
     4.745    73.990     0.150
     4.745   125.990     0.150
     4.777    71.592     0.150
     4.777   123.691     0.150
     4.875   127.391     0.150
     4.856    72.891     0.150
     4.945    73.791     0.150
     4.986    74.490     0.150
     4.986   128.391     0.150
     4.991    74.490     0.150
     4.991   129.092     0.150
     5.054    75.891     0.150
     5.054   129.490     0.150
     5.095    75.990     0.150
     5.095   131.891     0.150
     5.206    77.490     0.150
     5.206   134.592     0.150
     5.257    78.291     0.150
     5.257   135.191     0.150
     5.329    79.490     0.150
     5.329   137.490     0.150
     5.532    85.291     0.150
     5.532   145.291     0.150
     5.546    83.291     0.150
     5.546   143.191     0.150
     6.313    94.092     0.150
     6.313   163.592     0.150
     6.994   102.291     0.150
     6.994   175.092     0.150
     7.313   106.791     0.150
     7.313   180.891     0.150
     7.929   115.291     0.150
     7.929   196.891     0.150
     8.472   124.191     0.150
     8.472   213.490     0.150
     8.494   123.791     0.150
     0.906    17.236     0.150
     0.906    30.537     0.150
     1.790    31.037     0.150
     1.790    33.537     0.150
     2.317    69.537     0.150
     3.315    53.037     0.150
     3.315    87.537     0.150
     3.315    89.537     0.150
     3.315    91.537     0.150
     3.797    58.537     0.150
     3.797    96.736     0.150
     4.263    64.736     0.150
     4.263   109.438     0.150
     4.451    66.438     0.150
     4.451   115.338     0.150
     4.563    70.338     0.150
     4.613   121.236     0.150
     4.861    71.736     0.150
     4.861   124.338     0.150
     4.996   128.236     0.150
     4.949    72.838     0.150
     5.045    73.938     0.150
     5.045   127.637     0.150
     5.093    75.137     0.150
     5.093   129.537     0.150
     5.168   130.338     0.150
     5.172    76.137     0.150
     5.172   132.736     0.150
     5.276    77.637     0.150
     5.332    78.438     0.150
     5.332   137.137     0.150
     5.408    79.537     0.150
     5.408   138.438     0.150
     5.668    83.938     0.150
     5.668   143.537     0.150
     5.585    82.037     0.150
     5.726    83.736     0.150
     6.437    95.736     0.150
     6.437   163.137     0.150
     7.368   106.236     0.150
     7.423   106.838     0.150
     7.423   184.137     0.150
     0.667    13.947     0.150
     0.667    23.947     0.150
     2.516    43.307     0.150
     2.516    72.467     0.150
     2.987    49.428     0.150
     2.987    85.428     0.150
     3.393    54.328     0.150
     3.393    93.188     0.150
     3.455    56.307     0.150
     3.455    95.467     0.150
     3.456    54.328     0.150
     3.580    56.947     0.150
     3.727    59.361     0.150
     3.727    99.969     0.150
     3.790    60.146     0.150
     3.790   103.146     0.150
     3.815    59.646     0.150
     3.774    60.207     0.150
     3.774   102.668     0.150
     3.808    60.801     0.150
     3.808   106.088     0.150
     3.914    61.146     0.150
     3.896    61.848     0.150
     3.896   105.168     0.150
     4.057    62.547     0.150
     4.057   108.848     0.150
     4.086    63.348     0.150
     4.086   109.748     0.150
     4.146    64.646     0.150
     4.146   110.848     0.150
     4.505    70.748     0.150
     4.505   121.168     0.150
     4.638    72.607     0.150
     5.035    77.047     0.150
     5.035   131.748     0.150
     5.371    82.807     0.150
     5.371   142.348     0.150
     5.900    88.947     0.150
     5.900   154.848     0.150
     5.900    88.826     0.150
     5.900   151.998     0.150
     6.119    91.088     0.150
     6.119   157.428     0.150
     6.811   101.227     0.150
     6.811   174.188     0.150
     7.469   110.367     0.150
     7.469   191.066     0.150
     0.456    10.055     0.150
     0.456    17.055     0.150
     1.915    35.055     0.150
     2.491    41.117     0.150
     2.491    68.734     0.150
     2.952    47.398     0.150
     2.952    80.297     0.150
     3.183    49.820     0.150
     3.183    88.391     0.150
     3.274    52.336     0.150
     3.274    91.336     0.150
     3.306    53.531     0.150
     3.306    89.453     0.150
     3.585    56.594     0.150
     3.585    97.875     0.150
     3.682    58.734     0.150
     3.682    99.812     0.150
     3.903    59.438     0.150
     3.903   104.406     0.150
     3.854   103.031     0.150
     3.466    55.055     0.150
     3.466    95.055     0.150
     3.813    60.078     0.150
     3.813   100.812     0.150
     3.767    99.852     0.150
     3.934   103.555     0.150
     3.978    60.453     0.150
     3.978   104.852     0.150
     4.124    62.953     0.150
     4.361    67.320     0.150
     4.361   115.672     0.150
     4.413    70.031     0.150
     4.413   118.477     0.150
     4.307   114.352     0.150
     4.350    65.758     0.150
     4.350   114.258     0.150
     4.575    68.953     0.150
     4.575   119.258     0.150
     4.553    68.555     0.150
     4.553   119.453     0.150
     5.172   136.516     0.150
     5.193    77.352     0.150
     5.193   134.258     0.150
     5.797    86.414     0.150
     5.797   148.812     0.150
     5.797    86.414     0.150
     5.797   148.109     0.150
     6.127   156.914     0.150
     6.131   154.758     0.150
     2.064    37.670     0.150
     2.064    62.070     0.150
     2.358    41.030     0.150
     2.714    44.516     0.150
     2.804    45.570     0.150
     2.815    46.311     0.150
     3.009    47.830     0.150
     3.103    48.808     0.150
     3.140    51.145     0.150
     3.413    55.167     0.150
     3.520    56.481     0.150
     3.691    57.103     0.150
     3.712    57.624     0.150
     3.712    96.650     0.150
     3.713    57.859     0.150
     3.708    57.370     0.150
     3.708    98.771     0.150
     3.725    59.752     0.150
     3.857    59.471     0.150
     3.857   101.870     0.150
     3.920    60.370     0.150
     3.920   104.070     0.150
     3.984    60.971     0.150
     3.984   105.070     0.150
     4.075    62.219     0.150
     4.075   107.715     0.150
     4.263    64.785     0.150
     4.263   111.616     0.150
     4.265    65.009     0.150
     4.237    67.375     0.150
     4.298    65.471     0.150
     4.298   112.771     0.150
     4.497    68.271     0.150
     4.497   116.570     0.150
     4.506    68.183     0.150
     4.506   117.328     0.150
     4.805    74.551     0.150
     4.998    76.902     0.150
     5.118    76.570     0.150
     5.118   133.070     0.150
     5.384    81.771     0.150
     5.468    81.881     0.150
     5.468   139.930     0.150
     5.628   146.070     0.150
     5.638    84.420     0.150
     5.638   143.584     0.150
     5.638    84.507     0.150
     5.638   143.835     0.150
     5.766    86.570     0.150
     5.766   147.870     0.150
     5.820    89.104     0.150
     5.960    88.870     0.150
     5.960   153.170     0.150
     5.997    89.131     0.150
     5.997   152.119     0.150
     6.025    89.471     0.150
     6.098    90.570     0.150
     6.098   154.471     0.150
     6.413    96.144     0.150
     6.574    97.170     0.150
     6.956   102.166     0.150
     6.956   174.443     0.150
     7.135   105.442     0.150
     7.207   105.370     0.150
     7.207   183.070     0.150
     7.446   108.879     0.150
     7.446   188.909     0.150
     7.792   113.670     0.150
     7.792   196.070     0.150
     8.023   119.051     0.150
     8.058   119.771     0.150
     8.425   122.926     0.150
     8.425   210.047     0.150
     8.556   127.030     0.150
     9.168   132.162     0.150
     9.474   136.715     0.150
     9.474   137.811     0.150
     9.482   139.170     0.150
     9.404   231.870     0.150
     9.668   140.870     0.150
     9.688   141.870     0.150
     9.886   143.170     0.150
    10.007   146.271     0.150
    10.092   146.771     0.150
    10.406   152.271     0.150
    10.858   159.670     0.150
    11.728   169.471     0.150
    12.145   172.670     0.150
    13.878   196.370     0.150
    14.019   207.980     0.150
    14.048   209.521     0.150
    14.070   208.521     0.150
    14.103   209.880     0.150
    14.114   210.471     0.150
    14.173   211.690     0.150
    14.268   201.471     0.150
    14.212   211.971     0.150
    14.316   210.511     0.150
    14.356   212.681     0.150
    14.400   212.771     0.150
    14.436   213.230     0.150
    14.498   205.271     0.150
    14.572   215.301     0.150
    14.653   212.070     0.150
    14.729   212.860     0.150
    14.834   217.380     0.150
    14.952   212.870     0.150
    15.050   212.971     0.150
    15.119   215.471     0.150
    15.268   222.471     0.150
    15.271   222.360     0.150
    15.294   223.170     0.150
    15.311   224.170     0.150
    15.558   227.170     0.150
    16.013   229.670     0.150
    16.380   231.670     0.150
    16.309   233.570     0.150
    16.391   233.771     0.150
    16.323   235.370     0.150
    16.394   233.900     0.150
    16.402   235.870     0.150
    16.534   235.170     0.150
    16.509   238.170     0.150
    16.713   239.070     0.150
    16.784   241.471     0.150
    16.925   240.040     0.150
    16.896   241.971     0.150
    17.014   242.070     0.150
    17.015   242.170     0.150
    17.057   241.971     0.150
    17.068   241.670     0.150
    17.365   244.870     0.150
    17.441   245.971     0.150
    17.487   246.971     0.150
    17.547   253.971     0.150
    17.701   247.771     0.150
    17.751   249.660     0.150
    17.989   251.471     0.150
    18.239   253.971     0.150
    18.254   255.070     0.150
    18.325   255.261     0.150
    18.200   258.271     0.150
    18.443   257.670     0.150
    18.597   257.960     0.150
    18.654   259.070     0.150
    18.654   259.170     0.150
    18.735   261.051     0.150
    18.759   260.570     0.150
    18.759   271.070     0.150
    18.920   263.070     0.150
    19.040   263.670     0.150
    19.139   264.570     0.150
    19.400   268.271     0.150
    19.700   270.370     0.150
    19.700   270.370     0.150
    19.912   273.471     0.150
    19.938   273.271     0.150
    20.001   272.771     0.150
    19.984   274.070     0.150
    20.316   502.139     0.150
    20.363   277.570     0.150
    20.437   277.570     0.150
    20.567   278.870     0.150
    20.567   285.271     0.150
    20.567   296.570     0.150
    21.471   290.170     0.150
    21.653   290.570     0.150
    21.774   291.870     0.150
    22.108   294.570     0.150
    22.589   299.771     0.150
    22.880   302.570     0.150
    23.242   307.070     0.150
    24.344   317.370     0.150
    25.696   330.670     0.150
    28.155   351.070     0.150
    28.947   358.670     0.150
    28.947   358.971     0.150
    32.718   390.971     0.150
    33.854   401.670     0.150
    34.367   406.370     0.150
    39.327   448.583     0.150
    43.206   483.271     0.150
    45.499   500.490     0.150
    48.061   519.200     0.150
    48.061     8.870     0.150
    51.941   552.070     0.150
    63.068   630.570     0.150
    66.275   649.960     0.150
    66.282   650.670     0.150
    68.539   664.035     0.150
    69.189   670.070     0.150
    70.942   679.120     0.150
    71.014   679.960     0.150
    71.075   680.320     0.150
    71.370   682.261     0.150
    72.242   687.320     0.150
    72.611   689.840     0.150
    73.394   691.927     0.150
    73.873   697.330     0.150
    74.152   698.801     0.150
    74.042   697.570     0.150
    74.715   701.090     0.150
    75.212   702.771     0.150
    75.273   705.330     0.150
    75.313   705.311     0.150
    75.706   707.641     0.150
    76.070   709.880     0.150
    76.750   710.301     0.150
    77.000   715.221     0.150
    77.094   715.511     0.150
    78.083   722.700     0.150
    80.533   735.795     0.150
    81.472   740.420     0.150
    83.633   750.815     0.150
    84.458   755.610     0.150
    84.468   756.380     0.150
    84.893   759.949     0.150
    86.810   769.120     0.150
    88.274   773.070     0.150
    90.912   787.320     0.150
     0.750    15.761     0.150
     0.750    25.761     0.150
     1.359    26.261     0.150
     1.359    43.762     0.150
     3.132    50.761     0.150
     3.132    88.761     0.150
     3.132    90.761     0.150
     3.778    59.963     0.150
     3.778   101.961     0.150
     3.935    63.757     0.150
     3.935   108.141     0.150
     3.920    63.969     0.150
     3.920   107.300     0.150
     3.996    64.122     0.150
     3.996   107.082     0.150
     4.326   114.161     0.150
     4.447    69.362     0.150
     4.447   115.862     0.150
     4.346   117.461     0.150
     4.635   122.544     0.150
     4.789    76.062     0.150
     4.789   127.281     0.150
     5.516    84.781     0.150
     5.516   144.661     0.150
     5.816    87.990     0.150
     5.816   149.237     0.150
     5.945    90.949     0.150
     5.945   155.629     0.150
     6.016    91.112     0.150
     6.016   154.657     0.150
     6.016    90.961     0.150
     6.016   154.362     0.150
     6.196   160.181     0.150
     6.919   176.208     0.150
     7.602   112.681     0.150
     7.602   193.681     0.150
     1.247    22.629     0.150
     1.247    39.129     0.150
     2.208    37.398     0.150
     2.208    63.578     0.150
     2.215    61.648     0.150
     2.293    38.539     0.150
     2.293    62.859     0.150
     2.386    40.059     0.150
     2.386    68.551     0.150
     2.422    40.859     0.150
     2.422    69.148     0.150
     2.672    43.188     0.150
     2.852    46.070     0.150
     2.852    78.590     0.150
     3.165    48.629     0.150
     3.165    82.129     0.150
     3.415    52.230     0.150
     3.415    88.629     0.150
     3.423    52.328     0.150
     3.423    88.930     0.150
     3.306    51.629     0.150
     3.306    89.629     0.150
     3.465    54.230     0.150
     3.465    93.688     0.150
     3.492    53.688     0.150
     3.492    94.668     0.150
     3.514    54.730     0.150
     3.752    57.707     0.150
     3.780    59.348     0.150
     3.780   101.090     0.150
     3.835    60.070     0.150
     3.835   102.707     0.150
     4.042    60.527     0.150
     4.042   104.430     0.150
     3.915    60.270     0.150
     3.915   104.418     0.150
     4.378    66.730     0.150
     4.378   115.770     0.150
     4.490    68.410     0.150
     4.490   116.707     0.150
     4.491    68.945     0.150
     4.491   118.766     0.150
     4.840    72.230     0.150
     4.840   121.828     0.150
     4.739    72.109     0.150
     4.739   124.590     0.150
     5.071    75.457     0.150
     5.071   128.359     0.150
     5.071   145.398     0.150
     5.222    77.027     0.150
     5.222   131.629     0.150
     5.449    79.629     0.150
     5.449   137.027     0.150
     5.428    81.270     0.150
     5.428   139.309     0.150
     5.427    81.629     0.150
     5.427   140.930     0.150
     5.597    82.668     0.150
     5.597   141.656     0.150
     5.524    83.336     0.150
     5.524   142.137     0.150
     5.685    83.430     0.150
     5.685   142.930     0.150
     5.732    84.230     0.150
     5.732   143.527     0.150
     5.815    85.828     0.150
     5.815   146.582     0.150
     5.815    85.777     0.150
     5.815   147.129     0.150
     5.887   149.027     0.150
     5.905    88.137     0.150
     5.905   151.336     0.150
     6.214   155.328     0.150
     6.292    92.199     0.150
     6.292   157.730     0.150
     6.650    96.527     0.150
     6.650   165.930     0.150
     6.690    99.168     0.150
     6.690   170.117     0.150
     6.913   101.348     0.150
     6.913   175.930     0.150
     7.177   103.730     0.150
     7.177   178.828     0.150
     7.460   108.930     0.150
     7.460   187.570     0.150
     7.629   110.430     0.150
     7.645   110.027     0.150
     7.645   188.930     0.150
     7.804   112.406     0.150
     7.804   193.926     0.150
     7.751   113.258     0.150
     7.751   195.188     0.150
     7.905   109.828     0.150
     8.179   117.480     0.150
     8.179   202.551     0.150
     8.234   118.707     0.150
     8.234   204.027     0.150
     8.409   118.629     0.150
     8.534   123.469     0.150
     8.534   214.207     0.150
     8.598   124.566     0.150
     8.598   215.418     0.150
     8.761   121.730     0.150
     8.849   128.207     0.150
     8.849   221.367     0.150
     8.945   129.430     0.150
     8.945   223.129     0.150
     9.285   133.250     0.150
     9.285   229.270     0.150
     9.261   134.309     0.150
     9.261   231.789     0.150
     9.570   137.988     0.150
     9.570   237.488     0.150
     9.734   140.148     0.150
     9.734   240.809     0.150
     9.746   140.828     0.150
     9.783   140.527     0.150
     9.793   140.930     0.150
     9.818   141.730     0.150
     9.900   142.430     0.150
     9.933   143.230     0.150
     9.966   143.430     0.150
    10.027   144.430     0.150
    10.024   144.129     0.150
    10.085   145.027     0.150
    10.182   146.430     0.150
    10.203   141.168     0.150
    10.272   148.328     0.150
    10.272   254.230     0.150
    10.407   149.230     0.150
    10.524   151.129     0.150
    10.795   155.230     0.150
    10.881   156.828     0.150
    12.057   171.328     0.150
    12.057   171.430     0.150
    12.057   298.027     0.150
    12.539   177.527     0.150
    12.649   178.930     0.150
    12.649   308.430     0.150
    12.659   182.027     0.150
    13.279   187.730     0.150
    13.742   193.930     0.150
    13.742   194.527     0.150
    13.742   335.828     0.150
    13.939   195.629     0.150
    14.204   200.027     0.150
    14.204   345.527     0.150
    14.339   200.527     0.150
    14.339   200.828     0.150
    14.339   346.828     0.150
    14.269   209.629     0.150
    14.354   201.328     0.150
    14.417   207.629     0.150
    14.590   205.527     0.150
    14.641   212.129     0.150
    14.785   208.027     0.150
    14.785   358.328     0.150
    14.874   209.629     0.150
    15.139   212.828     0.150
    15.139   365.230     0.150
    15.114   220.430     0.150
    15.118   220.230     0.150
    15.179   215.629     0.150
    15.219   213.328     0.150
    15.598   219.629     0.150
    16.061   231.730     0.150
    17.015   239.629     0.150
    17.052   240.730     0.150
    17.267   243.629     0.150
    17.484   246.527     0.150
    17.539   246.629     0.150
    17.583   242.113     0.150
    17.672   247.027     0.150
    17.642   247.328     0.150
    17.911   257.230     0.150
    18.121   251.328     0.150
    18.332   254.930     0.150
    18.422   256.129     0.150
    18.498   256.430     0.150
    18.699   258.328     0.150
    18.865   262.328     0.150
    18.909   260.730     0.150
    18.925   261.527     0.150
    19.077   262.328     0.150
    19.081   264.828     0.150
    19.087   263.730     0.150
    19.305   263.828     0.150
    19.430   266.930     0.150
    19.430   280.629     0.150
    20.202   274.430     0.150
    20.202   285.430     0.150
    20.202   497.430     0.150
    20.202   274.430     0.150
    20.202   285.430     0.150
    20.202   497.430     0.150
    20.617   276.629     0.150
    20.641   279.730     0.150
    20.891   506.938     0.150
    21.048   283.430     0.150
    21.017   282.027     0.150
    21.258   285.688     0.150
    21.277   286.828     0.150
    22.140   295.629     0.150
    22.290   296.828     0.150
    22.525   299.129     0.150
    27.399   346.051     0.150
    27.399     8.352     0.150
    27.712   348.859     0.150
    27.834   349.328     0.150
    29.177   360.828     0.150
    29.177     8.816     0.150
    34.249   403.875     0.150
    34.249     9.914     0.150
    34.748   408.430     0.150
    36.875     7.766     0.150
    36.875    12.766     0.150
    39.552     8.074     0.150
    39.552    12.555     0.150
    39.552   451.590     0.150
    48.683   522.219     0.150
    48.683    10.961     0.150
    62.306   621.527     0.150
    63.825   632.199     0.150
    63.825    10.617     0.150
    63.891   633.629     0.150
    69.232   666.957     0.150
    69.232     9.000     0.150
    76.195   706.879     0.150
    76.195   716.527     0.150
    78.951   722.988     0.150
    88.988   775.129     0.150
   142.465  1173.406     0.150
   142.465  1184.789     0.150
   143.861  1173.527     0.150
   143.861  1183.930     0.150
   153.075  1197.629     0.150
     0.577    11.922     0.150
     0.577    20.922     0.150
     2.150    40.422     0.150
     2.388    40.043     0.150
     2.388    69.281     0.150
     2.840    46.203     0.150
     2.840    79.762     0.150
     2.984    47.480     0.150
     2.984    83.715     0.150
     3.086    50.461     0.150
     3.086    87.402     0.150
     3.133    52.062     0.150
     3.133    88.301     0.150
     3.296    53.301     0.150
     3.296    90.898     0.150
     3.394    55.250     0.150
     3.394    94.645     0.150
     3.518    57.262     0.150
     3.518    97.641     0.150
     3.733    59.121     0.150
     3.733   101.684     0.150
     3.677    58.582     0.150
     3.677   101.543     0.150
     3.920    61.023     0.150
     3.920   103.820     0.150
     3.911    60.852     0.150
     3.911   104.949     0.150
     3.982    61.551     0.150
     3.982   106.320     0.150
     4.028    64.426     0.150
     4.028   109.211     0.150
     4.087    64.020     0.150
     4.087   110.277     0.150
     4.188    65.281     0.150
     4.188   112.242     0.150
     4.206    66.586     0.150
     4.206   113.703     0.150
     4.582    69.922     0.150
     4.582   120.023     0.150
     4.560    69.023     0.150
     4.560   119.320     0.150
     4.759    74.043     0.150
     4.759   126.863     0.150
     4.837    74.668     0.150
     4.837   128.941     0.150
     4.973    76.562     0.150
     4.973   131.480     0.150
     5.338    82.238     0.150
     5.338   141.469     0.150
     5.473    82.512     0.150
     5.473   143.078     0.150
     5.474    82.371     0.150
     5.474   143.469     0.150
     5.639    83.660     0.150
     5.639   147.570     0.150
     5.639   147.172     0.150
     6.026    89.652     0.150
     6.071   153.023     0.150
     8.064   119.711     0.150
     0.610    12.182     0.150
     0.610    21.182     0.150
     1.187    25.182     0.150
     1.187    42.182     0.150
     1.489    27.182     0.150
     2.156    36.182     0.150
     2.617    45.041     0.150
     2.617    73.652     0.150
     2.887    81.668     0.150
     3.560    58.416     0.150
     3.560   100.740     0.150
     3.840    60.682     0.150
     3.896    61.969     0.150
     3.896   104.258     0.150
     3.708    61.682     0.150
     3.708   103.682     0.150
     4.252    69.059     0.150
     4.252   114.865     0.150
     4.218    67.047     0.150
     4.480   117.182     0.150
     4.440   116.682     0.150
     4.918    75.521     0.150
     4.918   127.328     0.150
     0.897    19.398     0.150
     0.897    32.898     0.150
     1.103    21.398     0.150
     1.103    37.398     0.150
     1.392    25.898     0.150
     1.392    42.898     0.150
     1.414    26.398     0.150
     1.414    44.898     0.150
     3.014    48.328     0.150
     3.014    81.984     0.150
     4.096    62.539     0.150
     4.096   108.617     0.150
     4.096   107.086     0.150
     4.084   106.836     0.150
     4.084   108.102     0.150
     4.154    63.531     0.150
     4.154   109.133     0.150
     4.602    69.109     0.150
     4.602   119.414     0.150
     4.602   118.695     0.150
     4.780    71.820     0.150
     4.780   124.156     0.150
     5.173    76.750     0.150
     5.173   133.242     0.150
     0.360     8.178     0.150
     1.374    26.074     0.150
     1.374    45.023     0.150
     1.378    26.078     0.150
     1.378    44.979     0.150
     1.801    30.766     0.150
     1.801    53.916     0.150
     1.801    30.467     0.150
     1.549    27.678     0.150
     1.549    49.678     0.150
     2.157    32.938     0.150
     2.157    33.678     0.150
     2.157    33.287     0.150
     2.452    40.078     0.150
     2.452    67.877     0.150
     2.693    43.709     0.150
     2.693    75.510     0.150
     2.836    46.404     0.150
     2.836    79.105     0.150
     2.745    42.877     0.150
     3.489    55.666     0.150
     3.489    56.178     0.150
     3.489    91.678     0.150
     3.489    92.197     0.150
     3.725    97.686     0.150
     3.725    96.678     0.150
     3.725    99.238     0.150
     3.742    97.070     0.150
     3.847    58.385     0.150
     3.847    58.117     0.150
     4.729    72.707     0.150
     4.729    73.178     0.150
     4.040    61.232     0.150
     4.040   105.088     0.150
     4.040   105.578     0.150
     4.040   105.918     0.150
     5.227    78.852     0.150
     0.705    14.633     0.150
     1.153    23.633     0.150
     1.153    39.633     0.150
     1.243    24.633     0.150
     1.243    41.633     0.150
     1.643    30.633     0.150
     1.643    50.633     0.150
     1.807    34.633     0.150
     1.856    32.633     0.150
     2.021    37.633     0.150
     2.021    60.633     0.150
     2.103    39.633     0.150
     2.103    65.633     0.150
     2.301    42.633     0.150
     2.301    71.633     0.150
     2.700    46.633     0.150
     2.700    79.633     0.150
     2.851    49.375     0.150
     2.851    82.211     0.150
     2.851    79.430     0.150
     3.032    49.102     0.150
     3.032    85.594     0.150
     3.032    49.266     0.150
     3.032    84.859     0.150
     3.080    50.633     0.150
     3.080    85.633     0.150
     3.276    54.031     0.150
     3.276    92.578     0.150
     3.276    89.461     0.150
     3.307    54.633     0.150
     3.378    55.633     0.150
     3.378    91.633     0.150
     3.619    59.016     0.150
     3.619    99.773     0.150
     3.619    58.656     0.150
     3.704    61.391     0.150
     3.704   102.555     0.150
     3.726    60.812     0.150
     3.726   102.977     0.150
     3.952    63.312     0.150
     3.952   108.359     0.150
     3.952   108.930     0.150
     3.995    65.383     0.150
     3.995   111.023     0.150
     4.017    66.016     0.150
     4.017   111.273     0.150
     4.094    65.992     0.150
     4.094   110.672     0.150
     4.234    66.266     0.150
     4.234    66.086     0.150
     4.234   111.852     0.150
     4.262    66.922     0.150
     4.262   115.117     0.150
     4.262   112.641     0.150
     4.484    70.461     0.150
     4.609   122.633     0.150
     4.632    72.219     0.150
     4.632   123.469     0.150
     4.632    72.336     0.150
     4.713    73.930     0.150
     4.713   123.930     0.150
     4.660    74.438     0.150
     4.660   126.633     0.150
     4.660    74.703     0.150
     4.660   124.906     0.150
     4.805    74.031     0.150
     4.805   125.633     0.150
     4.805    74.734     0.150
     4.805   125.734     0.150
     4.781    75.375     0.150
     4.781   128.031     0.150
     4.781   127.555     0.150
     4.852    77.156     0.150
     4.852   130.641     0.150
     4.852    78.031     0.150
     5.284    81.266     0.150
     5.284   138.680     0.150
     5.284   136.695     0.150
     5.314    80.734     0.150
     5.314   139.930     0.150
     5.503   144.305     0.150
     5.607    86.930     0.150
     5.607   147.875     0.150
     5.992    92.711     0.150
     5.992   159.953     0.150
     6.202    93.547     0.150
     6.202   161.047     0.150
     6.422    96.633     0.150
     6.422   165.531     0.150
     6.422   164.133     0.150
     6.435   165.531     0.150
     6.435   165.430     0.150
     6.976   104.734     0.150
     6.976   179.734     0.150
     7.029   105.352     0.150
     7.124   106.875     0.150
     7.124   181.711     0.150
     7.349   188.031     0.150
     7.858   200.234     0.150
     7.858   198.234     0.150
     7.885   118.352     0.150
     8.142   205.078     0.150
     8.250   121.836     0.150
     8.250   121.234     0.150
     8.385   123.609     0.150
     8.385   211.734     0.150
     8.385   123.914     0.150
     8.494   125.180     0.150
     8.494   215.078     0.150
     8.494   124.391     0.150
     8.712   220.117     0.150
     9.696   142.602     0.150
     9.696   244.266     0.150
     9.765   143.781     0.150
     9.798   143.508     0.150
     9.770   244.891     0.150
    10.083   148.336     0.150
    10.083   254.336     0.150
    10.092   147.930     0.150
    10.494   153.930     0.150
    11.474   166.734     0.150
    14.421   205.531     0.150
    14.818   210.836     0.150
    14.827   211.031     0.150
     0.167     4.656     0.150
     0.167     8.156     0.150
     1.059    22.156     0.150
     1.262    22.156     0.150
     1.262    37.656     0.150
     1.279    43.566     0.150
     1.666    52.656     0.150
     1.801    31.656     0.150
     1.801    57.156     0.150
     1.952    32.156     0.150
     1.952    55.156     0.150
     1.979    33.645     0.150
     1.979    61.449     0.150
     1.984    33.656     0.150
     1.984    61.457     0.150
     1.990    37.875     0.150
     1.990    59.836     0.150
     2.087    36.156     0.150
     2.477    39.105     0.150
     2.477    68.777     0.150
     2.477    39.355     0.150
     2.368    71.156     0.150
     2.897    79.695     0.150
     2.939    46.113     0.150
     2.939    79.215     0.150
     2.939    81.855     0.150
     2.939    79.785     0.150
     3.051    49.336     0.150
     3.051    84.035     0.150
     3.051    50.457     0.150
     3.051    84.457     0.150
     3.111    50.789     0.150
     3.111    91.578     0.150
     3.234    50.203     0.150
     3.234    87.953     0.150
     3.234    50.758     0.150
     3.234    89.156     0.150
     3.321    52.457     0.150
     3.321    91.395     0.150
     3.355    53.715     0.150
     3.355    94.277     0.150
     3.355    96.566     0.150
     3.503    56.293     0.150
     3.503    98.355     0.150
     3.961    58.863     0.150
     3.961   105.789     0.150
     3.961    59.555     0.150
     4.010    61.262     0.150
     4.010   107.219     0.150
     3.984    62.574     0.150
     3.984   109.047     0.150
     3.984    63.156     0.150
     4.052    60.285     0.150
     4.052   105.953     0.150
     4.052    60.457     0.150
     4.082    61.895     0.150
     4.082   109.461     0.150
     4.163    64.895     0.150
     4.151    65.316     0.150
     4.151   113.516     0.150
     4.151   112.957     0.150
     4.137    63.156     0.150
     4.137   110.156     0.150
     4.459    66.637     0.150
     4.630    69.758     0.150
     4.630   119.258     0.150
     4.671    69.957     0.150
     4.671   120.156     0.150
     4.760   124.141     0.150
     4.760    72.957     0.150
     4.926    75.258     0.150
     4.977    73.746     0.150
     4.977   127.328     0.150
     4.977    73.957     0.150
     4.977   128.555     0.150
     5.120    76.258     0.150
     5.120   132.457     0.150
     5.253   134.758     0.150
     5.276    80.566     0.150
     5.276   140.305     0.150
     5.276    79.855     0.150
     5.276   139.758     0.150
     5.626    81.953     0.150
     5.626   146.113     0.150
     5.626   146.484     0.150
     5.781    87.156     0.150
     5.781   150.156     0.150
     6.118    90.258     0.150
     6.118   155.457     0.150
     6.216    91.656     0.150
     6.216   158.457     0.150
     6.318    93.078     0.150
     6.318    94.055     0.150
     6.572    96.734     0.150
     6.572    97.258     0.150
     6.660    96.957     0.150
     6.660   167.855     0.150
     7.048   103.055     0.150
     7.048   180.758     0.150
     7.014   102.805     0.150
     7.014   177.836     0.150
     7.014   104.457     0.150
     7.177   186.383     0.150
     7.529   109.855     0.150
     7.529   189.355     0.150
     7.851   113.156     0.150
     7.984   200.914     0.150
     7.984   202.656     0.150
     8.002   117.910     0.150
     8.172   117.688     0.150
     8.172   206.191     0.150
     9.422   136.758     0.150
     9.452   136.656     0.150
     9.813   142.156     0.150
    10.764   154.855     0.150
    20.315   274.957     0.150
    21.675   292.281     0.150
    22.409   298.355     0.150
    22.465   297.258     0.150
    25.549   328.156     0.150
    26.109   332.215     0.150
    27.278   345.957     0.150
    68.666   662.301     0.150
    77.906   716.758     0.150
     1.091    20.883     0.150
     1.091    38.383     0.150
     1.599    50.383     0.150
     1.920    30.205     0.150
     1.920    59.845     0.150
     1.924    30.183     0.150
     1.930    58.553     0.150
     1.852    33.383     0.150
     1.852    58.383     0.150
     2.455    38.123     0.150
     2.455    67.383     0.150
     2.336    39.383     0.150
     2.421    40.383     0.150
     2.421    73.383     0.150
     2.899    45.323     0.150
     2.899    80.623     0.150
     3.015    47.583     0.150
     3.015    83.123     0.150
     2.894    44.681     0.150
     2.894    78.891     0.150
     2.894    79.383     0.150
     3.080    48.663     0.150
     3.080    85.023     0.150
     3.186    48.991     0.150
     3.186    87.151     0.150
     3.281    51.781     0.150
     3.281    90.381     0.150
     3.317    53.543     0.150
     3.317    88.763     0.150
     3.474    55.623     0.150
     3.474    94.643     0.150
     3.474    95.883     0.150
     3.943    62.411     0.150
     3.943   108.631     0.150
     4.058    62.391     0.150
     4.058   107.131     0.150
     3.964    59.301     0.150
     3.964   104.111     0.150
     4.131    62.963     0.150
     4.131   110.943     0.150
     4.065   106.123     0.150
     4.197    65.383     0.150
     4.197   114.883     0.150
     4.707    72.841     0.150
     4.707   123.481     0.150
     4.643    68.483     0.150
     4.643   120.283     0.150
     4.695    69.183     0.150
     4.695   120.083     0.150
     4.978   126.523     0.150
     4.978   126.953     0.150
     5.228    79.873     0.150
     5.228   136.623     0.150
     5.228   138.483     0.150
     6.118   155.983     0.150
     7.048   101.783     0.150
     7.526   108.683     0.150
     7.526   189.983     0.150
     0.155     3.617     0.150
     0.424     8.617     0.150
     0.424    15.117     0.150
     1.087    38.117     0.150
     1.555    30.117     0.150
     1.792    33.617     0.150
     1.792    59.117     0.150
     1.925    34.117     0.150
     1.925    58.117     0.150
     4.039    64.359     0.150
     4.264    66.688     0.150
     4.264   115.555     0.150
     4.425    69.312     0.150
     4.425   117.898     0.150
     5.204    78.828     0.150
     5.204   135.039     0.150
     5.185    79.938     0.150
     5.185   137.867     0.150
     5.335    80.539     0.150
     5.335   138.633     0.150
     5.332    81.047     0.150
     5.332   141.477     0.150
     5.523    84.016     0.150
     5.523   144.219     0.150
     5.754    87.719     0.150
     5.754   150.320     0.150
     5.854    87.797     0.150
     5.854   151.164     0.150
     5.907    89.094     0.150
     5.907   154.367     0.150
     6.024    90.719     0.150
     6.024   155.820     0.150
     6.336    95.516     0.150
     6.336   163.820     0.150
     6.344    94.625     0.150
     6.344   163.164     0.150
     7.399   109.617     0.150
     7.399   189.914     0.150
     7.467   110.914     0.150
     7.467   191.117     0.150
     7.429   109.055     0.150
     7.429   188.305     0.150
     0.140     3.266     0.150
     0.140     6.266     0.150
     0.461     8.766     0.150
     0.461    16.266     0.150
     1.047    35.266     0.150
     1.283    25.828     0.150
     1.283    43.977     0.150
     1.508    30.266     0.150
     1.508    51.266     0.150
     1.963    34.266     0.150
     1.963    58.266     0.150
     2.447    40.266     0.150
     2.447    68.266     0.150
     4.253    67.066     0.150
     4.253   114.832     0.150
     4.253    66.664     0.150
     4.424    68.812     0.150
     4.424   118.133     0.150
     4.424    69.664     0.150
     4.491    70.016     0.150
     4.492    69.465     0.150
     4.492   120.266     0.150
     5.216    79.016     0.150
     5.216   135.086     0.150
     5.301    79.977     0.150
     5.162    79.664     0.150
     5.162   137.633     0.150
     5.162    78.555     0.150
     5.223    81.395     0.150
     5.223   136.629     0.150
     5.247    80.191     0.150
     5.247    82.164     0.150
     5.247   140.066     0.150
     5.341    80.418     0.150
     5.341   138.832     0.150
     5.320    81.344     0.150
     5.320   140.164     0.150
     5.543    83.566     0.150
     5.543   143.965     0.150
     5.650    85.215     0.150
     5.650   146.176     0.150
     5.767    86.566     0.150
     5.767   149.664     0.150
     5.845    87.895     0.150
     5.845   151.605     0.150
     5.845   151.938     0.150
     5.888    90.742     0.150
     5.888   154.328     0.150
     5.888    90.266     0.150
     5.888   155.266     0.150
     6.010    90.766     0.150
     6.010   155.266     0.150
     6.010    89.965     0.150
     6.351    95.367     0.150
     6.351   163.664     0.150
     6.351    94.465     0.150
     6.351   162.137     0.150
     6.905   102.766     0.150
     7.218   106.789     0.150
     7.218   181.574     0.150
     7.218   102.957     0.150
     7.204   108.574     0.150
     7.204   185.266     0.150
     7.412   109.566     0.150
     7.475   110.164     0.150
     7.475   189.367     0.150
     7.419   109.055     0.150
     7.419   187.145     0.150
     7.419   188.113     0.150
     7.419   109.066     0.150
     7.419   187.664     0.150
     8.035   118.465     0.150
     8.035   203.766     0.150
     8.035   117.527     0.150
     8.035   205.246     0.150
     8.919   224.465     0.150
     9.365   136.965     0.150
     9.501   138.133     0.150
     9.501   238.422     0.150
     9.501   239.004     0.150
     9.546   138.387     0.150
     9.546   238.586     0.150
     9.546   237.867     0.150
    10.866   157.266     0.150
    10.974   158.293     0.150
    10.974   160.066     0.150
    20.475   280.391     0.150
    22.113   295.945     0.150
    25.662   331.992     0.150
    66.139   649.930     0.150
     0.130     3.473     0.150
     0.130     7.473     0.150
     0.390     8.973     0.150
     0.390    14.473     0.150
     0.836    17.473     0.150
     1.055    21.473     0.150
     1.055    35.473     0.150
     1.214    23.973     0.150
     1.214    39.473     0.150
     1.395    45.473     0.150
     1.880    36.973     0.150
     1.880    60.973     0.150
     2.897    47.473     0.150
     2.897    81.473     0.150
     3.347    54.473     0.150
     3.347    93.473     0.150
     3.554    56.892     0.150
     3.554    98.912     0.150
     4.878    74.255     0.150
     4.878   128.092     0.150
     4.889    74.371     0.150
     4.889   129.065     0.150
     5.162    79.059     0.150
     5.162   136.188     0.150
     5.359    80.873     0.150
     5.359   138.973     0.150
     5.450    82.173     0.150
     5.450   141.473     0.150
     5.911    88.480     0.150
     5.911   151.847     0.150
     6.060    90.973     0.150
     6.060   156.373     0.150
     6.347    97.305     0.150
     7.051   103.973     0.150
     7.051   178.973     0.150
     7.077   104.473     0.150
     7.603   111.772     0.150
     7.980   117.173     0.150
     8.483   123.873     0.150
     8.856   128.272     0.150
     8.962   130.473     0.150
     0.404    10.164     0.150
     0.651    13.977     0.150
     0.798    16.367     0.150
     0.798    27.367     0.150
     1.110    23.367     0.150
     1.110    38.367     0.150
     1.125    22.367     0.150
     1.748    57.367     0.150
     1.792    31.867     0.150
     1.792    53.867     0.150
     2.157    41.367     0.150
     2.419    42.367     0.150
     2.419    75.367     0.150
     2.665    49.367     0.150
     2.665    81.867     0.150
     2.592    45.367     0.150
     2.592    77.367     0.150
     2.610    44.367     0.150
     2.610    75.367     0.150
     3.096    51.367     0.150
     3.096    87.367     0.150
     3.119    52.367     0.150
     3.696    59.711     0.150
     3.696    98.531     0.150
     3.696    59.461     0.150
     3.842    58.945     0.150
     3.842   102.906     0.150
     4.051    62.766     0.150
     4.131    64.227     0.150
     4.131   108.398     0.150
     4.150    65.117     0.150
     4.150   111.977     0.150
     4.343    66.883     0.150
     4.343   116.422     0.150
     4.454    69.555     0.150
     4.505    71.984     0.150
     4.505   120.727     0.150
     4.621    71.984     0.150
     4.621   122.688     0.150
     4.725    74.508     0.150
     4.725   126.266     0.150
     4.759    75.484     0.150
     4.759   127.219     0.150
     4.864    74.242     0.150
     4.864   126.203     0.150
     5.077    77.141     0.150
     5.077   130.891     0.150
     5.119    77.297     0.150
     5.119   133.164     0.150
     5.280    79.648     0.150
     5.387    83.305     0.150
     5.387   142.750     0.150
     5.387   143.961     0.150
     5.448    82.516     0.150
     5.448   141.008     0.150
     5.515    83.266     0.150
     5.515   142.766     0.150
     5.560    84.727     0.150
     5.560   145.023     0.150
     5.560   146.477     0.150
     5.645    84.766     0.150
     5.645   145.367     0.150
     6.141    91.883     0.150
     6.141   156.789     0.150
     6.157    92.469     0.150
     6.157   158.867     0.150
     6.249    93.469     0.150
     6.249   161.766     0.150
     6.465    96.469     0.150
     6.660   101.758     0.150
     6.660   172.695     0.150
     6.660   175.469     0.150
     6.847   175.766     0.150
     7.008   103.453     0.150
     7.008   175.336     0.150
     7.008   177.805     0.150
     7.280   107.070     0.150
     7.280   183.664     0.150
     7.278   107.070     0.150
     7.278   183.664     0.150
     7.833   114.766     0.150
     7.833   197.266     0.150
     7.872   115.477     0.150
     7.872   198.586     0.150
     7.942   116.883     0.150
     7.942   199.703     0.150
     8.205   119.766     0.150
     8.205   206.766     0.150
     8.308   124.562     0.150
     8.421   122.000     0.150
     9.191   133.664     0.150
     9.191   230.570     0.150
     9.241   134.055     0.150
     9.241   230.312     0.150
     9.350   135.938     0.150
     9.350   233.250     0.150
     9.747   140.656     0.150
     9.747   242.562     0.150
    10.538   151.938     0.150
    10.538   261.977     0.150
    10.580   153.102     0.150
    10.580   264.531     0.150
    10.654   153.703     0.150
    10.654   264.508     0.150
    10.834   158.312     0.150
    10.826   158.070     0.150
    10.826   271.266     0.150
    10.855   158.469     0.150
    10.855   271.664     0.150
    10.892   158.258     0.150
    10.892   272.820     0.150
    15.246   215.766     0.150
    15.246   375.367     0.150
    15.654   221.570     0.150
    15.654   384.164     0.150
    20.555   280.445     0.150
    21.524   290.328     0.150
    21.653   291.367     0.150
    25.950   335.344     0.150
    35.161   415.273     0.150
    65.502   645.211     0.150
     0.562    11.609     0.150
     0.562    19.609     0.150
     0.923    33.609     0.150
     0.979    34.609     0.150
     1.277    25.609     0.150
     1.277    41.609     0.150
     1.266    27.609     0.150
     1.266    42.609     0.150
     1.713    32.609     0.150
     1.713    53.609     0.150
     1.695    31.609     0.150
     1.695    51.609     0.150
     2.386    41.609     0.150
     2.386    67.609     0.150
     2.952    47.949     0.150
     2.952    82.570     0.150
     2.984    49.609     0.150
     2.984    80.609     0.150
     3.027    49.418     0.150
     3.027    82.949     0.150
     3.135    51.609     0.150
     3.135    84.609     0.150
     3.337    54.680     0.150
     3.337    91.859     0.150
     3.337    93.711     0.150
     3.676   100.055     0.150
     3.822    58.789     0.150
     3.822   100.141     0.150
     3.929    60.398     0.150
     3.929   102.438     0.150
     4.036   109.988     0.150
     4.072    64.238     0.150
     4.072   110.219     0.150
     4.221    64.809     0.150
     4.221   109.410     0.150
     4.382   114.309     0.150
     4.506    69.047     0.150
     4.506   118.367     0.150
     4.694    73.668     0.150
     4.694   124.230     0.150
     4.731    73.789     0.150
     4.731   125.078     0.150
     4.731   124.211     0.150
     4.941    74.738     0.150
     4.941   126.980     0.150
     5.638    85.809     0.150
     5.638   145.750     0.150
     6.067    90.211     0.150
     6.067   153.609     0.150
     6.086   158.090     0.150
     6.086    92.609     0.150
     0.946    18.461     0.150
     0.946    32.461     0.150
     0.991    20.461     0.150
     0.991    35.461     0.150
     1.051    20.461     0.150
     1.051    35.461     0.150
     1.402    26.461     0.150
     1.402    46.461     0.150
     1.735    31.461     0.150
     1.735    53.461     0.150
     1.855    32.461     0.150
     1.855    57.461     0.150
     2.064    36.961     0.150
     2.064    62.461     0.150
     2.269    38.461     0.150
     2.409    40.461     0.150
     2.646    43.461     0.150
     4.753    72.758     0.150
     4.753   125.500     0.150
     4.905    72.367     0.150
     5.177    77.320     0.150
     5.177   135.117     0.150
     5.504    84.398     0.150
     5.564    85.344     0.150
     5.635    86.492     0.150
     5.635   148.414     0.150
     5.805    88.859     0.150
     6.054    89.023     0.150
     6.054   154.359     0.150
     6.141    89.742     0.150
     6.141   156.664     0.150
     6.512    95.383     0.150
     6.512   167.203     0.150
     7.077   106.148     0.150
     7.158   104.281     0.150
     7.158   179.859     0.150
     7.665   114.102     0.150
     8.070   116.570     0.150
     8.070   116.922     0.150
     8.848   127.570     0.150
    10.282   147.438     0.150
    10.363   148.109     0.150
     0.766    16.609     0.150
     0.766    27.609     0.150
     0.855    17.609     0.150
     0.855    28.609     0.150
     0.983    20.609     0.150
     0.983    34.609     0.150
     1.155    22.609     0.150
     1.155    37.609     0.150
     1.352    25.609     0.150
     1.352    43.609     0.150
     1.455    26.609     0.150
     1.455    46.609     0.150
     1.656    30.609     0.150
     1.656    52.609     0.150
     2.121    36.609     0.150
     2.121    63.609     0.150
     3.248    50.609     0.150
     3.248    86.609     0.150
     4.018    61.938     0.150
     4.018   105.473     0.150
     4.084    61.730     0.150
     4.084   105.473     0.150
     4.556    68.875     0.150
     4.556   117.297     0.150
     4.556    67.609     0.150
     4.743    71.152     0.150
     4.743   124.109     0.150
     5.102    76.391     0.150
     5.102   129.879     0.150
     5.102   132.711     0.150
     5.611   143.617     0.150
     0.754    15.898     0.150
     0.804    16.898     0.150
     0.804    28.898     0.150
     1.049    20.898     0.150
     1.049    34.898     0.150
     1.191    23.898     0.150
     1.191    41.398     0.150
     1.506    29.398     0.150
     1.506    49.898     0.150
     1.629    29.898     0.150
     2.064    35.898     0.150
     2.181    66.898     0.150
     2.733    45.898     0.150
     2.733    76.898     0.150
     4.513    69.055     0.150
     4.513   122.016     0.150
     4.673    70.570     0.150
     4.673   122.977     0.150
     4.934    75.312     0.150
     4.934   131.109     0.150
     5.433    84.844     0.150
     5.552    84.633     0.150
     5.808    86.297     0.150
     5.808   146.539     0.150
     5.894    87.055     0.150
     5.894   149.984     0.150
     5.932    87.695     0.150
     5.932   152.500     0.150
     6.172    91.297     0.150
     6.172   157.797     0.150
     6.212    94.375     0.150
     6.212   163.898     0.150
     6.279    93.250     0.150
     6.279   161.703     0.150
     6.367    93.898     0.150
     6.367   163.500     0.150
     6.393    94.055     0.150
     6.959   103.195     0.150
     6.959   178.297     0.150
     7.115   104.602     0.150
     7.115   180.797     0.150
     7.467   112.750     0.150
     7.634   111.898     0.150
     7.840   114.078     0.150
     7.840   196.805     0.150
     8.044   117.195     0.150
     8.044   202.797     0.150
     9.901   142.695     0.150
     0.359     8.543     0.150
     0.842    16.543     0.150
     0.842    28.043     0.150
     0.976    18.543     0.150
     0.976    31.543     0.150
     1.037    35.543     0.150
     1.280    24.543     0.150
     1.280    41.543     0.150
     1.757    32.543     0.150
     1.757    54.043     0.150
     1.762    30.492     0.150
     1.762    51.262     0.150
     1.766    30.441     0.150
     1.766    51.242     0.150
     2.036    36.543     0.150
     2.036    61.543     0.150
     2.147    34.762     0.150
     2.147    61.680     0.150
     2.266    40.043     0.150
     2.266    65.543     0.150
     2.248    36.430     0.150
     2.274    35.711     0.150
     2.274    63.234     0.150
     2.603    42.543     0.150
     2.741    75.383     0.150
     2.998    45.973     0.150
     2.998    82.570     0.150
     3.090    48.719     0.150
     3.090    83.141     0.150
     3.287    52.160     0.150
     3.752    56.852     0.150
     3.752   103.719     0.150
     3.752    60.043     0.150
     3.752   102.332     0.150
     3.821    58.191     0.150
     3.821    99.562     0.150
     3.875    59.633     0.150
     3.875   103.320     0.150
     3.917    61.066     0.150
     3.946    59.090     0.150
     3.946   102.293     0.150
     4.831    71.613     0.150
     4.831   124.031     0.150
     5.041   130.973     0.150
     0.313     7.535     0.150
     0.313    14.535     0.150
     0.815    15.535     0.150
     0.815    27.535     0.150
     0.947    18.035     0.150
     0.947    31.535     0.150
     1.082    20.535     0.150
     1.082    34.535     0.150
     1.054    21.535     0.150
     1.054    35.535     0.150
     1.166    22.535     0.150
     1.166    36.535     0.150
     1.263    23.535     0.150
     1.263    40.535     0.150
     1.809    30.535     0.150
     1.809    51.535     0.150
     2.001    33.535     0.150
     2.001    57.535     0.150
     2.240    35.836     0.150
     2.240    61.094     0.150
     2.280    34.684     0.150
     2.280    62.145     0.150
     2.267    40.035     0.150
     2.267    64.535     0.150
     2.566    41.535     0.150
     2.566    71.535     0.150
     3.031    46.953     0.150
     3.031    81.953     0.150
     3.114    48.023     0.150
     3.114    83.664     0.150
     3.777    58.656     0.150
     3.777   102.824     0.150
     3.806    57.402     0.150
     3.806    99.922     0.150
     3.883    58.344     0.150
     3.883   102.324     0.150
     3.922    58.184     0.150
     3.922   101.754     0.150
     4.817    71.125     0.150
     4.817   123.066     0.150
     5.073    76.566     0.150
     0.765    16.020     0.150
     0.765    26.020     0.150
     0.771    17.020     0.150
     0.771    27.520     0.150
     0.996    20.020     0.150
     0.996    33.020     0.150
     1.336    26.520     0.150
     1.529    28.520     0.150
     1.529    48.020     0.150
     1.897    34.020     0.150
     1.897    57.020     0.150
     4.077   108.541     0.150
     4.234    64.035     0.150
     4.234   108.379     0.150
     4.288    65.049     0.150
     4.288   110.111     0.150
     4.711    71.982     0.150
     4.711   120.078     0.150
     4.684    71.020     0.150
     4.684   121.219     0.150
     4.772   124.137     0.150
     5.308    78.789     0.150
     5.308   135.244     0.150
     5.525    83.020     0.150
     5.525   141.219     0.150
     6.285   157.729     0.150
     0.843    16.875     0.150
     0.843    28.875     0.150
     0.926    18.012     0.150
     0.926    32.086     0.150
     1.337    26.875     0.150
     1.337    44.875     0.150
     1.643    51.875     0.150
     1.966    35.875     0.150
     1.966    61.875     0.150
     2.091    37.375     0.150
     2.091    63.875     0.150
     2.412    40.875     0.150
     2.412    70.875     0.150
     2.509    39.375     0.150
     2.509    67.875     0.150
     2.510    40.875     0.150
     2.510    71.875     0.150
     2.688    42.875     0.150
     2.993    47.875     0.150
     3.230    58.875     0.150
     3.290    53.875     0.150
     3.290    93.375     0.150
     3.352    60.875     0.150
     3.455    55.875     0.150
     3.567    62.875     0.150
     3.899    60.875     0.150
     3.899   104.875     0.150
     4.128    62.789     0.150
     4.128   109.480     0.150
     4.199    64.273     0.150
     4.275    65.785     0.150
     4.374    68.309     0.150
     4.374   115.645     0.150
     4.436    79.875     0.150
     4.463    69.445     0.150
     4.551    68.633     0.150
     4.520    70.875     0.150
     4.520   119.875     0.150
     4.638    84.875     0.150
     4.646    70.820     0.150
     4.922    76.875     0.150
     5.139    75.977     0.150
     5.257    80.645     0.150
     5.257   140.535     0.150
     5.313    82.180     0.150
     5.421    92.875     0.150
     5.433    92.875     0.150
     5.537    83.875     0.150
     5.537   145.875     0.150
     5.613    82.879     0.150
     5.625    84.574     0.150
     5.667    84.453     0.150
     5.667   147.863     0.150
     5.755   147.875     0.150
     5.796    84.598     0.150
     5.796   147.855     0.150
     5.922    86.352     0.150
     5.922   150.422     0.150
     6.300    95.820     0.150
     6.300   164.934     0.150
     6.499    94.273     0.150
     6.499   165.875     0.150
     6.539    94.875     0.150
     6.539   166.977     0.150
     6.800    98.621     0.150
     6.800   170.977     0.150
     6.984   101.375     0.150
     6.984   176.074     0.150
     7.104   102.875     0.150
     7.104   178.676     0.150
     7.118   104.848     0.150
     7.123   103.773     0.150
     7.123   181.074     0.150
     7.933   114.773     0.150
     7.933   199.977     0.150
     8.861   127.574     0.150
    11.157   160.113     0.150
    19.902   272.316     0.150
    19.902   271.523     0.150
    20.809   281.715     0.150
     0.104     2.570     0.150
     0.104     5.570     0.150
     0.377     9.070     0.150
     0.866    17.570     0.150
     0.866    31.570     0.150
     1.036    36.570     0.150
     1.333    25.570     0.150
     1.333    44.070     0.150
     1.425    28.070     0.150
     1.918    34.570     0.150
     1.918    60.070     0.150
     2.252    40.570     0.150
     2.252    67.570     0.150
     2.927    48.570     0.150
     2.927    82.570     0.150
     3.377    54.570     0.150
     3.377    94.570     0.150
     3.391    93.109     0.150
     3.536    97.277     0.150
     3.866   105.098     0.150
     4.011    62.738     0.150
     4.011   107.449     0.150
     4.394    70.309     0.150
     4.394   117.340     0.150
     4.394   119.270     0.150
     4.770    72.070     0.150
     4.770   124.371     0.150
     4.872    74.340     0.150
     4.872   127.270     0.150
     4.872    73.969     0.150
     4.879    73.785     0.150
     4.879   128.137     0.150
     5.143    79.359     0.150
     5.143   134.367     0.150
     5.143    78.070     0.150
     5.211    82.875     0.150
     5.240    80.332     0.150
     5.359   138.570     0.150
     5.445   140.969     0.150
     5.902    87.840     0.150
     5.902   151.480     0.150
     6.143    91.270     0.150
     6.143   157.770     0.150
     7.042   103.469     0.150
     7.042   179.270     0.150
     0.926    18.932     0.150
     0.926    32.533     0.150
     1.332    26.322     0.150
     1.332    43.322     0.150
     1.625    51.322     0.150
     1.928    34.822     0.150
     2.108    37.322     0.150
     2.108    61.322     0.150
     2.350    39.322     0.150
     2.350    68.322     0.150
     2.442    40.822     0.150
     2.442    70.322     0.150
     2.455    41.322     0.150
     2.455    71.322     0.150
     2.537    42.322     0.150
     2.537    73.322     0.150
     2.626    74.322     0.150
     2.721    51.082     0.150
     2.721    90.072     0.150
     2.724    44.580     0.150
     2.724    75.545     0.150
     2.725    44.623     0.150
     2.725    75.521     0.150
     3.096    50.322     0.150
     3.096    85.322     0.150
     3.241    53.322     0.150
     3.241    91.322     0.150
     3.326    54.521     0.150
     3.345    54.039     0.150
     3.345    91.941     0.150
     3.413    56.322     0.150
     3.507    67.322     0.150
     3.587    59.322     0.150
     3.651    58.322     0.150
     3.651    98.322     0.150
     3.910    60.322     0.150
     3.979    65.322     0.150
     4.071    62.871     0.150
     4.071   107.033     0.150
     4.099   122.322     0.150
     4.121    79.322     0.150
     4.146    65.623     0.150
     4.146   113.332     0.150
     4.203    64.732     0.150
     4.203   112.393     0.150
     4.211    64.672     0.150
     4.211   112.852     0.150
     4.284    68.322     0.150
     4.284   118.322     0.150
     4.308    66.266     0.150
     4.308   115.211     0.150
     4.400    67.402     0.150
     4.400   118.143     0.150
     4.427    81.932     0.150
     4.427   147.602     0.150
     4.485    68.182     0.150
     4.485   119.963     0.150
     4.550    69.322     0.150
     4.550   120.322     0.150
     4.549    70.322     0.150
     4.582    70.930     0.150
     4.582   122.951     0.150
     4.583    71.322     0.150
     4.653    71.461     0.150
     4.653   126.311     0.150
     4.657    73.322     0.150
     4.657   138.322     0.150
     4.653    71.762     0.150
     4.864    73.322     0.150
     4.883    73.223     0.150
     4.972    77.342     0.150
     5.083    76.223     0.150
     5.192    80.170     0.150
     5.192   137.662     0.150
     5.365    79.322     0.150
     5.381    80.361     0.150
     5.537   144.322     0.150
     5.542    84.623     0.150
     5.542   144.902     0.150
     5.606    84.371     0.150
     5.606   144.510     0.150
     5.642    83.740     0.150
     5.746    85.330     0.150
     5.746   148.420     0.150
     5.799    88.322     0.150
     5.799   151.322     0.150
     5.859    87.223     0.150
     5.859   150.123     0.150
     5.877    86.732     0.150
     5.877   150.883     0.150
     5.880    87.223     0.150
     5.880   150.521     0.150
     6.072   157.342     0.150
     6.233    94.320     0.150
     6.233   161.752     0.150
     6.260    92.322     0.150
     6.260   158.922     0.150
     6.285    93.123     0.150
     6.285   159.623     0.150
     6.454    95.021     0.150
     6.454   164.521     0.150
     6.500    95.822     0.150
     6.500   165.322     0.150
     6.649   100.311     0.150
     6.649   172.420     0.150
     6.748    99.242     0.150
     6.748   172.383     0.150
     6.766    99.723     0.150
     6.839    99.422     0.150
     6.938   101.922     0.150
     6.938   178.123     0.150
     6.949   102.422     0.150
     6.982   101.922     0.150
     7.054   103.723     0.150
     7.054   179.521     0.150
     7.055   104.984     0.150
     7.055   181.271     0.150
     7.055   104.742     0.150
     7.055   206.463     0.150
     7.079   104.322     0.150
     7.079   179.822     0.150
     7.268   108.533     0.150
     7.529   111.551     0.150
     7.529   192.260     0.150
     7.700   112.021     0.150
     7.700   189.963     0.150
     7.860   115.123     0.150
     7.860   198.822     0.150
     7.881   115.123     0.150
     7.881   198.822     0.150
     8.029   117.803     0.150
     8.120   120.891     0.150
     8.277   122.682     0.150
     8.411   122.822     0.150
     8.411   212.422     0.150
     8.700   128.322     0.150
     8.809   127.723     0.150
     8.809   221.123     0.150
     8.793   129.939     0.150
     8.793   224.480     0.150
     8.887   131.410     0.150
     8.887   227.121     0.150
     8.917   130.322     0.150
     8.979   130.521     0.150
     8.979   226.322     0.150
     9.259   135.445     0.150
     9.267   134.322     0.150
     9.267   232.422     0.150
     9.471   139.682     0.150
     9.522   138.021     0.150
     9.522   239.623     0.150
     9.652   242.561     0.150
     9.758   141.223     0.150
     9.787   145.072     0.150
     9.878   145.322     0.150
     9.913   143.701     0.150
     9.913   247.973     0.150
    10.122   147.643     0.150
    10.171   148.623     0.150
    10.361   150.223     0.150
    10.469   153.502     0.150
    10.601   154.322     0.150
    10.641   153.422     0.150
    10.652   157.223     0.150
    10.751   155.383     0.150
    10.842   155.922     0.150
    10.842   271.123     0.150
    10.992   158.021     0.150
    11.067   160.053     0.150
    11.119   160.473     0.150
    13.044   185.521     0.150
    13.545   196.422     0.150
    14.029   202.521     0.150
    14.146   199.623     0.150
    14.212   201.723     0.150
    15.130   217.723     0.150
    15.137   213.723     0.150
    15.687   224.822     0.150
    17.480   247.242     0.150
    17.868   250.170     0.150
    18.046   252.424     0.150
    19.960   274.332     0.150
    19.960   489.883     0.150
    19.960   274.680     0.150
    19.960   623.521     0.150
    20.299   276.723     0.150
    20.300   277.123     0.150
    20.300   277.123     0.150
    20.332   276.062     0.150
    20.586   279.223     0.150
    20.746   280.922     0.150
    20.746   280.961     0.150
    20.891   282.723     0.150
    20.893   282.021     0.150
    21.199   286.584     0.150
    21.208   287.223     0.150
    21.221   286.322     0.150
    21.366   288.322     0.150
    21.906   293.521     0.150
    21.945   293.123     0.150
    22.120   297.322     0.150
    22.196   298.322     0.150
    22.219   297.422     0.150
    22.274   299.322     0.150
    22.274   544.322     0.150
    22.329   299.021     0.150
    22.329   298.771     0.150
    22.457   299.451     0.150
    22.716   304.223     0.150
    23.019   304.922     0.150
    23.127   306.223     0.150
    24.033   315.623     0.150
    24.650   322.422     0.150
    25.278   329.922     0.150
    26.144   338.322     0.150
    26.291   338.623     0.150
    28.424   353.723     0.150
    30.680   378.271     0.150
    34.619   409.896     0.150
    35.917   759.322     0.150
    60.843   612.922     0.150
    63.454   631.234     0.150
    64.413   637.422     0.150
    64.413   637.248     0.150
    70.475   675.117     0.150
    75.186   706.723     0.150
   140.426  1172.623     0.150
   141.640  1175.922     0.150
     0.184     5.120     0.150
     1.064    20.620     0.150
     1.064    34.620     0.150
     1.087    21.620     0.150
     1.087    38.620     0.150
     1.312    25.620     0.150
     1.312    44.620     0.150
     1.578    28.133     0.150
     1.578    49.076     0.150
     1.582    28.120     0.150
     1.582    49.120     0.150
     2.032    40.030     0.150
     2.032    59.460     0.150
     2.032    35.620     0.150
     2.173    38.620     0.150
     2.173    63.620     0.150
     2.372    38.461     0.150
     2.372    66.082     0.150
     2.414    42.830     0.150
     2.545    41.850     0.150
     2.692    43.334     0.150
     2.692    76.105     0.150
     2.834    47.270     0.150
     2.834    79.530     0.150
     2.834    78.380     0.150
     2.732    45.620     0.150
     2.931    47.860     0.150
     2.931    82.540     0.150
     2.931    81.148     0.150
     2.933    49.560     0.150
     2.933    85.800     0.150
     2.933    81.860     0.150
     2.922    83.880     0.150
     2.922    83.188     0.150
     3.076    50.317     0.150
     3.076    86.401     0.150
     3.123    50.739     0.150
     3.123    87.731     0.150
     3.259    51.470     0.150
     3.259    89.650     0.150
     3.341    54.990     0.150
     3.729    59.470     0.150
     3.729   103.320     0.150
     3.729   105.400     0.150
     3.951    62.280     0.150
     3.970    63.679     0.150
     4.017    62.620     0.150
     4.017   106.920     0.150
     4.017   106.528     0.150
     4.179    63.330     0.150
     4.179   111.160     0.150
     4.199    63.420     0.150
     4.199   109.620     0.150
     4.200    63.620     0.150
     4.200   109.620     0.150
     4.216   115.620     0.150
     4.554   123.620     0.150
     4.666    69.620     0.150
     4.666   120.920     0.150
     4.667    70.420     0.150
     4.667   120.820     0.150
     4.753    71.420     0.150
     4.753   123.620     0.150
     4.966    77.400     0.150
     4.966   132.440     0.150
     4.966    77.110     0.150
     4.866    73.120     0.150
     4.866   125.520     0.150
     5.016    76.118     0.150
     5.016   131.204     0.150
     5.275    78.320     0.150
     5.275   135.920     0.150
     5.328    80.420     0.150
     5.328   138.020     0.150
     5.378   139.620     0.150
     5.460    82.808     0.150
     6.149    91.620     0.150
     6.149   157.820     0.150
     6.421    95.244     0.150
     6.842   102.678     0.150
     7.077   104.820     0.150
     7.077   180.920     0.150
     7.257   107.120     0.150
     7.257   185.620     0.150
     7.811   114.820     0.150
     9.165   134.020     0.150
     9.216   134.120     0.150
     0.212     5.531     0.150
     0.212     9.531     0.150
     0.569    11.531     0.150
     0.569    20.531     0.150
     1.227    23.531     0.150
     1.227    40.531     0.150
     1.053    20.531     0.150
     1.053    36.531     0.150
     1.324    24.531     0.150
     1.324    43.531     0.150
     1.485    28.531     0.150
     1.485    48.531     0.150
     2.105    37.531     0.150
     2.105    62.531     0.150
     2.414    41.531     0.150
     2.414    71.531     0.150
     2.645    44.531     0.150
     2.645    75.531     0.150
     2.822    45.531     0.150
     2.822    77.531     0.150
     2.918    47.531     0.150
     2.918    81.531     0.150
     3.311    52.531     0.150
     3.311    89.531     0.150
     3.610    58.203     0.150
     3.610    56.449     0.150
     3.610    96.352     0.150
     3.552    56.551     0.150
     3.552    96.051     0.150
     3.727    56.961     0.150
     3.727    96.852     0.150
     3.727    99.902     0.150
     4.058    62.332     0.150
     4.058   104.301     0.150
     4.058   107.699     0.150
     4.191    64.293     0.150
     4.191   109.492     0.150
     4.191   111.508     0.150
     4.311    66.312     0.150
     4.311   115.109     0.150
     4.373    67.293     0.150
     4.373   116.293     0.150
     4.454    68.711     0.150
     4.454   118.809     0.150
     4.574    70.121     0.150
     4.574   120.375     0.150
     4.763    72.672     0.150
     4.763   123.109     0.150
     4.763   125.613     0.150
     4.946    74.133     0.150
     4.946   127.230     0.150
     5.012    75.031     0.150
     5.012   128.332     0.150
     5.054    75.383     0.150
     5.054   127.711     0.150
     5.054   131.070     0.150
     5.068    75.062     0.150
     5.068   131.445     0.150
     5.235    78.133     0.150
     5.235   135.031     0.150
     5.296    78.832     0.150
     5.296   136.230     0.150
     5.296    79.230     0.150
     5.296   136.430     0.150
     5.234    79.859     0.150
     5.234   136.621     0.150
     5.334    79.641     0.150
     5.334   136.043     0.150
     5.334   138.547     0.150
     5.426    81.590     0.150
     5.426   140.242     0.150
     5.528    82.230     0.150
     5.528   142.332     0.150
     5.538    82.430     0.150
     5.538   141.230     0.150
     5.626    84.133     0.150
     5.626   143.832     0.150
     6.091    90.188     0.150
     6.091   155.332     0.150
     6.135    90.730     0.150
     6.135   156.633     0.150
     6.329    93.332     0.150
     6.329   160.633     0.150
     6.489    97.121     0.150
     6.886   100.383     0.150
     6.886   172.121     0.150
     6.886   175.359     0.150
     6.958   102.633     0.150
     6.958   177.332     0.150
     7.231   105.633     0.150
     7.231   181.832     0.150
     8.159   118.832     0.150
     8.339   121.543     0.150
     8.339   210.828     0.150
     8.662   125.730     0.150
     8.662   216.430     0.150
     9.035   130.930     0.150
     9.169   132.383     0.150
     9.169   227.191     0.150
     9.169   229.633     0.150
     9.300   134.102     0.150
     9.300   232.125     0.150
     9.705   139.453     0.150
    10.530   150.430     0.150
     0.117     5.320     0.150
     0.117     8.320     0.150
     0.626    14.320     0.150
     1.038    19.820     0.150
     1.038    35.320     0.150
     0.987    20.320     0.150
     1.168    23.820     0.150
     1.168    40.820     0.150
     1.520    28.820     0.150
     1.594    28.320     0.150
     1.594    47.320     0.150
     1.987    35.320     0.150
     1.987    59.820     0.150
     2.562    40.539     0.150
     2.562    67.648     0.150
     2.865    45.242     0.150
     2.865    75.484     0.150
     4.200    63.938     0.150
     4.200   107.250     0.150
     4.351    65.203     0.150
     4.351   112.312     0.150
     4.363   110.422     0.150
     4.367    65.422     0.150
     4.367   111.023     0.150
     4.695    69.719     0.150
     4.695   119.820     0.150
     4.816   123.023     0.150
     5.117    77.938     0.150
     0.345     7.084     0.150
     0.345    11.584     0.150
     0.603    13.584     0.150
     0.603    22.584     0.150
     1.062    20.584     0.150
     1.008    20.584     0.150
     1.008    35.584     0.150
     0.943    21.584     0.150
     0.943    36.084     0.150
     2.154    38.084     0.150
     2.154    63.584     0.150
     3.904    60.659     0.150
     3.904   104.702     0.150
     3.878    59.484     0.150
     3.878   102.884     0.150
     3.908    60.142     0.150
     3.908   103.839     0.150
     4.084    64.244     0.150
     4.084   110.014     0.150
     4.084   109.294     0.150
     4.275    70.294     0.150
     4.275    68.914     0.150
     4.275   119.204     0.150
     4.236    66.764     0.150
     4.236   112.254     0.150
     4.236    66.272     0.150
     4.174    65.584     0.150
     4.174   112.984     0.150
     4.214    65.384     0.150
     4.375    67.384     0.150
     4.375   114.284     0.150
     4.438    68.884     0.150
     4.438   115.984     0.150
     4.483    68.584     0.150
     4.483   117.584     0.150
     4.926    74.984     0.150
     4.926   129.374     0.150
     5.169    79.384     0.150
     5.169   134.784     0.150
     0.977    19.664     0.150
     0.977    32.664     0.150
     1.029    37.664     0.150
     1.116    22.664     0.150
     1.116    37.664     0.150
     1.276    24.664     0.150
     1.276    42.664     0.150
     1.329    25.664     0.150
     1.752    52.234     0.150
     1.756    52.266     0.150
     2.141    60.961     0.150
     2.255    37.664     0.150
     2.255    64.664     0.150
     2.283    35.930     0.150
     2.283    63.586     0.150
     2.709    43.734     0.150
     2.709    74.781     0.150
     2.756    76.531     0.150
     2.997    46.391     0.150
     2.997    82.805     0.150
     3.092    48.625     0.150
     3.092    83.891     0.150
     3.754    59.531     0.150
     3.754   105.125     0.150
     3.754   101.414     0.150
     3.837    57.992     0.150
     3.837   100.484     0.150
     3.883    60.016     0.150
     3.883   103.289     0.150
     3.964    59.562     0.150
     3.964   102.203     0.150
     3.974    60.461     0.150
     3.974   103.164     0.150
     4.329    65.766     0.150
     4.329   112.164     0.150
     4.412   114.164     0.150
     4.540    68.266     0.150
     4.540   117.461     0.150
     4.623    69.266     0.150
     4.623   119.062     0.150
     4.846    73.141     0.150
     4.846   124.805     0.150
     5.022    74.766     0.150
     5.022   129.062     0.150
     5.039    78.156     0.150
     5.039   132.773     0.150
     5.039    76.250     0.150
     5.142    76.961     0.150
     5.142   131.961     0.150
     5.418    79.625     0.150
     5.418   141.602     0.150
     0.662    11.867     0.150
     0.471    10.867     0.150
     0.471    18.867     0.150
     0.885    18.867     0.150
     0.885    30.867     0.150
     1.088    20.367     0.150
     1.088    34.867     0.150
     1.253    21.867     0.150
     1.170    20.867     0.150
     1.170    34.867     0.150
     1.290    24.867     0.150
     1.290    39.867     0.150
     1.657    28.836     0.150
     1.657    48.746     0.150
     1.667    27.867     0.150
     1.667    47.867     0.150
     1.669    27.867     0.150
     1.669    47.867     0.150
     1.639    29.703     0.150
     1.639    51.805     0.150
     2.155    35.867     0.150
     2.155    59.918     0.150
     2.203    36.527     0.150
     2.203    58.445     0.150
     2.254    36.867     0.150
     2.254    66.047     0.150
     2.226    36.867     0.150
     2.226    63.867     0.150
     2.407    38.305     0.150
     2.407    64.988     0.150
     2.404    42.496     0.150
     2.404    71.965     0.150
     2.409    42.469     0.150
     2.409    71.969     0.150
     2.417    37.855     0.150
     2.417    72.148     0.150
     2.449    37.867     0.150
     2.449    66.867     0.150
     2.598    41.367     0.150
     2.598    71.605     0.150
     2.627    41.445     0.150
     2.627    71.324     0.150
     2.435    39.867     0.150
     2.435    68.867     0.150
     2.659    41.867     0.150
     2.681    41.969     0.150
     2.681    72.367     0.150
     2.688    43.027     0.150
     2.688    75.258     0.150
     3.121    48.566     0.150
     3.121    84.461     0.150
     3.122    49.008     0.150
     3.404    51.355     0.150
     3.404    87.121     0.150
     3.429    55.043     0.150
     3.429    97.258     0.150
     3.438    54.426     0.150
     3.438    92.496     0.150
     3.476    53.848     0.150
     3.476    91.266     0.150
     3.549    53.266     0.150
     3.549    91.969     0.150
     3.597    53.969     0.150
     3.597    93.469     0.150
     3.626    54.426     0.150
     3.626    92.996     0.150
     3.624    54.156     0.150
     3.624    92.996     0.150
     3.588    54.867     0.150
     3.588    95.867     0.150
     3.824    57.434     0.150
     3.824    98.086     0.150
     3.908    57.969     0.150
     3.908   100.969     0.150
     3.779    57.867     0.150
     3.779    99.867     0.150
     3.943    58.266     0.150
     3.943   101.766     0.150
     3.997    60.266     0.150
     3.997   102.676     0.150
     4.094    60.766     0.150
     4.094   104.969     0.150
     4.092    63.266     0.150
     4.092   111.328     0.150
     4.165    61.566     0.150
     4.165   107.168     0.150
     4.201    61.969     0.150
     4.201   107.969     0.150
     4.172    63.168     0.150
     4.172   109.527     0.150
     4.104   107.867     0.150
     4.308    66.602     0.150
     4.308   113.605     0.150
     4.646    68.293     0.150
     4.646   117.117     0.150
     4.705    69.668     0.150
     4.705   120.066     0.150
     4.705    69.266     0.150
     4.705   120.367     0.150
     4.740    69.668     0.150
     4.740   120.066     0.150
     4.817    70.969     0.150
     4.817   123.367     0.150
     4.887    72.168     0.150
     4.887   124.766     0.150
     5.038    75.469     0.150
     5.038   127.906     0.150
     5.382    78.867     0.150
     5.463    82.074     0.150
     5.463   141.676     0.150
     5.563    81.168     0.150
     5.563   142.066     0.150
     5.571    81.305     0.150
     5.571   141.957     0.150
     5.571    81.445     0.150
     5.571   140.332     0.150
     5.571    81.668     0.150
     5.571   140.848     0.150
     5.504    81.867     0.150
     5.504   141.867     0.150
     5.786    84.266     0.150
     5.786   145.066     0.150
     5.821    84.766     0.150
     5.821   147.168     0.150
     6.338    92.168     0.150
     6.338   160.668     0.150
     6.338    91.766     0.150
     6.486    94.508     0.150
     6.486   160.809     0.150
     6.715    97.168     0.150
     6.715   169.066     0.150
     7.001   101.168     0.150
     7.001   175.969     0.150
     7.135   103.445     0.150
     7.135   180.180     0.150
     7.218   103.969     0.150
     7.218   180.668     0.150
     7.285   104.766     0.150
     7.285   181.969     0.150
     7.602   109.367     0.150
     7.602   189.969     0.150
     7.698   110.766     0.150
     7.737   111.344     0.150
     7.737   191.625     0.150
     7.856   112.996     0.150
     7.856   194.805     0.150
     8.226   117.867     0.150
     9.047   129.719     0.150
     9.047   222.258     0.150
     9.086   129.797     0.150
     9.086   223.125     0.150
     9.078   130.898     0.150
     9.128   130.695     0.150
     9.128   225.684     0.150
     9.150   131.145     0.150
     9.243   133.406     0.150
     9.258   133.652     0.150
     9.258   230.051     0.150
     9.485   135.469     0.150
     9.485   235.469     0.150
     9.490   135.867     0.150
     9.490   235.766     0.150
     9.508   136.457     0.150
     9.508   235.207     0.150
     9.545   137.145     0.150
     9.545   238.906     0.150
     9.916   141.367     0.150
     9.916   246.766     0.150
    11.735   165.766     0.150
    11.735   289.766     0.150
    12.181   172.367     0.150
    12.181   301.266     0.150
    12.314   173.367     0.150
    12.314   303.766     0.150
    13.014   182.668     0.150
    13.014   320.469     0.150
    13.778   192.969     0.150
    13.778   335.867     0.150
    14.178   198.766     0.150
    14.178   347.469     0.150
    14.184   198.566     0.150
    14.184   346.566     0.150
    14.564   203.867     0.150
    14.902   208.566     0.150
    21.153   284.816     0.150
    22.019   296.293     0.150
    33.895   399.891     0.150
    39.298   446.594     0.150
    63.360   628.719     0.150
     0.599    12.692     0.150
     0.599    20.692     0.150
     0.599    13.692     0.150
     0.599    21.192     0.150
     1.028    22.692     0.150
     1.028    38.192     0.150
     1.028    21.692     0.150
     1.028    37.192     0.150
     1.232    24.692     0.150
     1.232    42.692     0.150
     1.278    26.692     0.150
     1.278    44.692     0.150
     2.301    41.692     0.150
     2.301    69.692     0.150
     2.610    43.692     0.150
     2.610    73.192     0.150
     2.610    74.692     0.150
     2.610    44.692     0.150
     4.640    72.292     0.150
     4.640   123.692     0.150
     5.315    80.393     0.150
     5.315   139.093     0.150
     5.412    81.893     0.150
     5.412   140.893     0.150
     5.484    83.062     0.150
     5.484   142.232     0.150
     5.505    82.792     0.150
     5.505   143.792     0.150
     5.505   143.292     0.150
     5.584    84.400     0.150
     5.584   145.301     0.150
     5.837    87.692     0.150
     5.837   151.692     0.150
     5.837   151.192     0.150
     6.001    92.792     0.150
     6.001   157.192     0.150
     6.018    90.551     0.150
     6.018   155.851     0.150
     6.031    90.692     0.150
     6.031   155.692     0.150
     6.168    94.992     0.150
     6.168    96.093     0.150
     6.557    97.992     0.150
     6.600    98.362     0.150
     6.600   169.103     0.150
     6.630    99.492     0.150
     6.630   170.593     0.150
     6.795   175.593     0.150
     7.729   113.992     0.150
     7.729   196.893     0.150
     7.729   113.792     0.150
     7.729   196.593     0.150
     8.985   131.792     0.150
     9.600   139.992     0.150
     0.148     3.930     0.150
     0.148     4.930     0.150
     0.305     6.930     0.150
     0.305    11.930     0.150
     0.568    12.242     0.150
     0.884    18.930     0.150
     0.970    19.930     0.150
     0.970    32.930     0.150
     1.296    24.930     0.150
     1.284    24.930     0.150
     1.284    41.930     0.150
     1.449    27.930     0.150
     1.449    46.930     0.150
     1.643    30.430     0.150
     1.643    30.828     0.150
     1.643    52.992     0.150
     1.844    33.930     0.150
     1.844    55.930     0.150
     1.868    33.930     0.150
     1.868    58.930     0.150
     2.206    38.930     0.150
     2.206    63.930     0.150
     2.381    40.930     0.150
     2.381    69.930     0.150
     2.357    41.930     0.150
     2.357    67.930     0.150
     2.790    45.758     0.150
     2.790    78.664     0.150
     2.790    46.828     0.150
     2.757    46.930     0.150
     2.757    77.930     0.150
     2.950    48.930     0.150
     2.950    83.930     0.150
     3.149    49.930     0.150
     3.149    85.930     0.150
     3.346    54.086     0.150
     3.346    92.406     0.150
     3.345    53.820     0.150
     3.345    92.500     0.150
     3.384    55.930     0.150
     3.384    93.930     0.150
     3.454    55.633     0.150
     3.469    53.906     0.150
     3.469    91.789     0.150
     3.703    60.578     0.150
     3.703   101.141     0.150
     3.794    60.102     0.150
     3.794   102.234     0.150
     3.850    60.930     0.150
     3.850   105.930     0.150
     3.954    61.352     0.150
     3.954   106.188     0.150
     3.944    65.930     0.150
     4.068    63.086     0.150
     4.068   110.312     0.150
     4.124    64.531     0.150
     4.124   112.312     0.150
     4.232    65.695     0.150
     4.232   115.438     0.150
     4.337    67.695     0.150
     4.337   118.367     0.150
     4.372    69.312     0.150
     4.372   116.211     0.150
     4.510    70.727     0.150
     4.510   120.367     0.150
     4.579    69.484     0.150
     4.579   119.477     0.150
     4.538    72.930     0.150
     4.538   121.930     0.150
     4.571    70.328     0.150
     4.571   120.352     0.150
     4.567    71.930     0.150
     4.567   121.930     0.150
     4.697    72.031     0.150
     4.697   123.328     0.150
     4.650    72.930     0.150
     4.759    73.133     0.150
     4.759   124.633     0.150
     4.798    73.898     0.150
     4.798   124.219     0.150
     4.806    72.977     0.150
     4.806   126.641     0.150
     4.806   124.312     0.150
     4.963    75.836     0.150
     4.963   128.219     0.150
     4.905   130.930     0.150
     5.000    76.430     0.150
     5.000   130.727     0.150
     4.998    77.828     0.150
     4.998   132.031     0.150
     5.056    77.031     0.150
     5.056   132.031     0.150
     5.077    77.391     0.150
     5.077   132.125     0.150
     5.158    80.609     0.150
     5.158   138.672     0.150
     5.178    79.289     0.150
     5.178   136.391     0.150
     5.277    80.133     0.150
     5.277   137.633     0.150
     5.286    80.430     0.150
     5.286   137.828     0.150
     5.208    81.930     0.150
     5.371    81.531     0.150
     5.371   140.227     0.150
     5.635    84.633     0.150
     5.635   145.930     0.150
     5.636    85.930     0.150
     5.723    87.055     0.150
     5.723   149.461     0.150
     5.828    87.719     0.150
     5.828   150.188     0.150
     5.879    88.328     0.150
     5.879   151.133     0.150
     5.879    88.531     0.150
     5.879   151.727     0.150
     5.843    89.430     0.150
     5.939    90.750     0.150
     5.939   156.328     0.150
     5.982    90.328     0.150
     5.982   155.031     0.150
     5.921    90.133     0.150
     6.069    91.133     0.150
     6.069   156.227     0.150
     6.189    92.930     0.150
     6.205    92.930     0.150
     6.271    95.828     0.150
     6.271   165.633     0.150
     6.452    96.703     0.150
     6.387    96.430     0.150
     6.464    95.828     0.150
     6.464   164.531     0.150
     6.492    98.031     0.150
     6.555    97.633     0.150
     6.555   167.430     0.150
     6.628    98.359     0.150
     6.628   165.938     0.150
     6.628   166.062     0.150
     6.631    98.516     0.150
     6.631   168.539     0.150
     6.631   169.117     0.150
     6.633    98.531     0.150
     6.633   169.133     0.150
     6.711   100.133     0.150
     6.711   172.031     0.150
     6.890   180.359     0.150
     6.968   103.227     0.150
     6.968   176.531     0.150
     6.997   103.828     0.150
     6.997   178.227     0.150
     7.391   113.430     0.150
     7.520   110.633     0.150
     7.520   190.930     0.150
     7.520   110.430     0.150
     7.520   189.828     0.150
     7.570   111.352     0.150
     7.570   192.648     0.150
     7.897   116.227     0.150
     7.897   199.727     0.150
     7.933   118.734     0.150
     8.099   119.172     0.150
     8.099   205.508     0.150
     8.176   119.227     0.150
     8.176   207.531     0.150
     8.176   121.508     0.150
     8.176   211.328     0.150
     8.169   117.234     0.150
     8.169   204.102     0.150
     8.879   129.328     0.150
     8.879   222.133     0.150
     8.905   129.141     0.150
     8.905   222.219     0.150
     8.960   224.969     0.150
     9.038   225.281     0.150
     8.996   132.500     0.150
     8.996   230.547     0.150
     9.263   136.250     0.150
     9.260   139.930     0.150
     9.346   136.031     0.150
     9.399   136.289     0.150
     9.399   235.711     0.150
     9.385   137.125     0.150
     9.385   238.484     0.150
     9.511   136.930     0.150
     9.630   141.570     0.150
     9.728   146.930     0.150
     9.858   143.328     0.150
     9.858   249.633     0.150
    10.064   147.508     0.150
    10.064   252.070     0.150
    10.066   147.570     0.150
    10.066   253.602     0.150
    10.011   148.930     0.150
    10.116   146.727     0.150
    10.116   251.328     0.150
    10.147   147.469     0.150
    10.147   255.719     0.150
    10.180   146.500     0.150
    10.180   252.570     0.150
    10.205   147.391     0.150
    10.205   255.602     0.150
    10.125   150.930     0.150
    10.237   150.062     0.150
    10.237   258.367     0.150
    10.240   258.273     0.150
    10.268   148.578     0.150
    10.268   254.461     0.150
    10.235   144.727     0.150
    10.235   253.961     0.150
    10.320   149.305     0.150
    10.320   257.102     0.150
    10.284   150.930     0.150
    10.437   151.727     0.150
    10.448   151.727     0.150
    10.448   260.633     0.150
    10.451   151.609     0.150
    10.451   262.664     0.150
    10.469   152.328     0.150
    10.469   264.227     0.150
    10.506   152.633     0.150
    10.506   263.680     0.150
    10.573   154.133     0.150
    10.606   150.516     0.150
    10.606   262.188     0.150
    10.757   155.633     0.150
    10.824   156.930     0.150
    10.903   162.930     0.150
    10.903   162.930     0.150
    10.960   156.828     0.150
    10.943   161.930     0.150
    10.991   157.711     0.150
    11.114   158.789     0.150
    11.304   163.930     0.150
    11.458   163.242     0.150
    11.458   283.367     0.150
    11.745   166.688     0.150
    11.745   289.570     0.150
    11.759   170.930     0.150
    12.247   176.531     0.150
    12.247   300.750     0.150
    12.292   178.477     0.150
    12.682   180.430     0.150
    12.682   316.133     0.150
    13.033   188.133     0.150
    13.076   187.031     0.150
    13.076   327.227     0.150
    13.241   188.430     0.150
    13.241   329.930     0.150
    13.701   200.133     0.150
    13.729   197.031     0.150
    13.732   195.930     0.150
    13.757   197.430     0.150
    13.962   200.133     0.150
    14.023   198.430     0.150
    14.023   344.727     0.150
    13.964   196.727     0.150
    14.119   201.633     0.150
    14.165   202.328     0.150
    14.296   205.930     0.150
    14.338   203.727     0.150
    14.425   205.227     0.150
    14.464   216.133     0.150
    14.524   207.227     0.150
    14.557   215.633     0.150
    14.587   212.828     0.150
    14.584   212.133     0.150
    14.636   213.133     0.150
    14.671   215.633     0.150
    14.731   216.828     0.150
    14.776   210.930     0.150
    14.776   364.531     0.150
    14.876   210.930     0.150
    14.861   216.828     0.150
    15.058   219.727     0.150
    15.145   214.430     0.150
    15.184   215.328     0.150
    15.264   215.828     0.150
    15.264   373.930     0.150
    15.285   215.828     0.150
    15.285   371.531     0.150
    15.290   220.227     0.150
    15.434   219.531     0.150
    15.427   224.227     0.150
    15.432   222.930     0.150
    15.515   224.031     0.150
    15.613   221.227     0.150
    15.613   381.328     0.150
    15.731   223.828     0.150
    15.936   226.133     0.150
    15.936   388.227     0.150
    16.008   230.828     0.150
    16.037   391.633     0.150
    16.404   237.633     0.150
    16.589   237.766     0.150
    17.201   244.227     0.150
    17.246   246.227     0.150
    17.277   244.828     0.150
    17.289   246.430     0.150
    17.341   247.727     0.150
    17.373   246.227     0.150
    17.429   246.930     0.150
    17.732   250.430     0.150
    17.808   249.531     0.150
    17.850   252.227     0.150
    17.850   252.242     0.150
    17.879   254.031     0.150
    18.209   255.141     0.150
    18.298   257.031     0.150
    18.316   256.727     0.150
    18.316   256.930     0.150
    18.437   257.984     0.150
    18.460   257.203     0.150
    18.533   260.828     0.150
    18.571   259.133     0.150
    18.571   259.531     0.150
    18.571   259.430     0.150
    18.720   262.602     0.150
    18.775   261.406     0.150
    18.845   262.109     0.150
    18.949   263.867     0.150
    18.957   265.336     0.150
    19.005   263.930     0.150
    19.005   265.531     0.150
    19.026   265.656     0.150
    19.057   264.297     0.150
    19.075   264.844     0.150
    19.178   266.883     0.150
    19.340   268.758     0.150
    19.452   270.781     0.150
    19.514   272.430     0.150
    19.514   284.633     0.150
    19.534   270.922     0.150
    19.823   274.039     0.150
    19.831   274.484     0.150
    19.855   272.930     0.150
    19.886   274.883     0.150
    19.960   272.727     0.150
    20.048   276.422     0.150
    20.026   277.156     0.150
    20.149   274.852     0.150
    20.159   277.047     0.150
    20.312   278.859     0.150
    20.461   279.430     0.150
    20.572   282.531     0.150
    20.530   281.047     0.150
    20.555   282.258     0.150
    20.572   281.531     0.150
    20.572   281.531     0.150
    20.768   286.141     0.150
    20.799   282.062     0.150
    20.927   284.633     0.150
    20.839   284.148     0.150
    20.839   515.141     0.150
    20.839   284.531     0.150
    21.001   287.617     0.150
    21.066   285.531     0.150
    21.054   286.906     0.150
    21.131   287.609     0.150
    21.143   285.031     0.150
    21.143   285.867     0.150
    21.180   286.633     0.150
    21.272   287.328     0.150
    21.360   290.531     0.150
    21.451   291.133     0.150
    21.509   291.430     0.150
    21.533   292.531     0.150
    21.705   292.539     0.150
    21.707   292.586     0.150
    21.853   295.906     0.150
    21.881   293.727     0.150
    22.119   298.102     0.150
    22.251   299.531     0.150
    22.270   298.383     0.150
    22.208   302.031     0.150
    22.312   298.133     0.150
    22.333   298.227     0.150
    22.479   301.797     0.150
    22.439   302.531     0.150
    22.439   302.828     0.150
    22.452   302.133     0.150
    22.532   299.930     0.150
    22.532   303.133     0.150
    22.532   556.930     0.150
    22.532   575.930     0.150
    22.544   302.930     0.150
    22.521   303.148     0.150
    22.550   305.922     0.150
    22.559   306.633     0.150
    22.636   304.570     0.150
    22.709   305.023     0.150
    22.687   304.328     0.150
    22.740   303.930     0.150
    22.859   308.086     0.150
    22.881   306.531     0.150
    22.799   307.719     0.150
    22.799   307.531     0.150
    22.871   306.531     0.150
    22.913   304.406     0.150
    22.913   306.531     0.150
    22.975   308.672     0.150
    23.089   309.586     0.150
    23.308   311.898     0.150
    23.315   310.531     0.150
    23.317   310.508     0.150
    23.365   309.633     0.150
    23.418   309.430     0.150
    23.479   312.633     0.150
    23.689   312.930     0.150
    23.689   312.477     0.150
    23.719   316.523     0.150
    23.719   316.031     0.150
    23.679   316.242     0.150
    23.999   318.828     0.150
    23.999   318.227     0.150
    24.003   319.828     0.150
    24.043   319.531     0.150
    24.081   320.031     0.150
    24.081   319.828     0.150
    24.237   320.531     0.150
    24.190   322.102     0.150
    24.252   322.930     0.150
    24.368   322.633     0.150
    24.474   325.328     0.150
    24.619   322.031     0.150
    24.984   327.031     0.150
    24.938   329.148     0.150
    25.138   328.031     0.150
    25.231   330.727     0.150
    25.388   330.828     0.150
    25.396   332.633     0.150
    25.396   333.133     0.150
    25.688   334.227     0.150
    25.762   331.898     0.150
    25.749   334.328     0.150
    25.834   338.297     0.150
    25.875   335.727     0.150
    26.035   339.258     0.150
    26.048   336.133     0.150
    26.304   338.352     0.150
    26.304   337.883     0.150
    26.328   338.430     0.150
    26.453   341.438     0.150
    26.613   341.031     0.150
    26.746   342.133     0.150
    27.302   347.031     0.150
    28.357   354.828     0.150
    28.994   364.297     0.150
    29.249   364.930     0.150
    29.670   369.258     0.150
    29.919   371.430     0.150
    29.919   370.906     0.150
    30.704   375.930     0.150
    30.704   377.727     0.150
    30.704   375.930     0.150
    31.109   382.633     0.150
    33.190   400.328     0.150
    34.776   412.133     0.150
    34.776   490.633     0.150
    35.554   424.133     0.150
    36.354   429.828     0.150
    36.428   427.633     0.150
    36.428   508.727     0.150
    36.428   428.227     0.150
    36.882   430.531     0.150
    38.508   443.727     0.150
    38.979   450.219     0.150
    39.197   452.719     0.150
    39.375   448.961     0.150
    40.005   455.430     0.150
    40.106   462.117     0.150
    40.254   462.930     0.150
    40.254   459.867     0.150
    40.604   466.555     0.150
    44.195   492.930     0.150
    47.618   517.258     0.150
    48.840   528.633     0.150
    48.840   639.828     0.150
    48.840   950.828     0.150
    48.840  1156.328     0.150
    48.840   526.930     0.150
    49.986   540.328     0.150
    55.915   577.633     0.150
    56.649   590.289     0.150
    56.847   587.602     0.150
    57.719   594.648     0.150
    57.719   594.430     0.150
    58.319   599.227     0.150
    60.331   611.227     0.150
    60.944   615.531     0.150
    60.959   617.227     0.150
    61.506   619.727     0.150
    61.506   618.648     0.150
    62.129   623.328     0.150
    62.825   629.133     0.150
    63.414   634.562     0.150
    63.996   636.430     0.150
    64.004   636.430     0.150
    64.004   636.430     0.150
    64.646   641.828     0.150
    65.150   644.516     0.150
    67.444   659.133     0.150
    67.840   660.930     0.150
    67.840   659.930     0.150
    69.394   670.227     0.150
    69.864   673.727     0.150
    70.104   676.430     0.150
    70.689   681.133     0.150
    71.874   685.930     0.150
    73.487   695.828     0.150
    73.914   699.328     0.150
    74.626   701.930     0.150
    75.131   708.023     0.150
    75.684   710.727     0.150
    75.832   709.727     0.150
    75.873   711.031     0.150
    76.111   708.828     0.150
    76.525   713.531     0.150
    76.649   713.133     0.150
    76.724   714.633     0.150
    76.743   714.633     0.150
    77.127   713.586     0.150
    77.139   716.352     0.150
    77.270   717.227     0.150
    77.516   718.727     0.150
    77.617   718.727     0.150
    77.568   719.758     0.150
    77.568   719.539     0.150
    77.741   720.227     0.150
    77.822   721.531     0.150
    77.963   722.930     0.150
    78.074   722.531     0.150
    78.206   723.430     0.150
    78.417   724.227     0.150
    78.454   723.430     0.150
    78.454   723.227     0.150
    78.637   726.328     0.150
    78.756   725.531     0.150
    78.838   726.758     0.150
    79.209   729.727     0.150
    79.301   729.031     0.150
    79.426   729.828     0.150
    79.562   730.633     0.150
    79.733   732.430     0.150
    79.894   731.930     0.150
    79.895   732.133     0.150
    79.903   732.930     0.150
    79.904   740.031     0.150
    80.070   733.727     0.150
    80.457   735.531     0.150
    80.671   737.930     0.150
    80.746   739.641     0.150
    80.854   736.633     0.150
    80.856   736.430     0.150
    80.946   738.727     0.150
    80.968   737.406     0.150
    81.676   742.328     0.150
    82.176   743.430     0.150
    82.203   745.031     0.150
    82.412   746.031     0.150
    82.622   747.133     0.150
    83.072   748.133     0.150
    84.367   756.531     0.150
    84.436   758.133     0.150
    85.397   761.328     0.150
    85.541   762.258     0.150
    86.131   761.930     0.150
    86.131   766.727     0.150
    86.131   962.828     0.150
    86.131  1384.727     0.150
    86.131  1393.031     0.150
    86.131  1733.133     0.150
    87.393   771.930     0.150
    87.398   771.727     0.150
    87.506   771.133     0.150
    87.506   977.531     0.150
    87.506  1395.430     0.150
    87.506  1408.633     0.150
    87.506  1416.633     0.150
    87.506  1755.531     0.150
    90.275   783.531     0.150
    90.275  1000.133     0.150
    90.275  1435.031     0.150
    90.275  1799.031     0.150
    91.145   788.633     0.150
    91.350   787.922     0.150
    91.350   791.031     0.150
    92.251   793.727     0.150
    92.251  1015.633     0.150
    92.251  1424.531     0.150
    92.251  1452.133     0.150
    92.251  1825.727     0.150
    95.011   806.453     0.150
    95.011   805.227     0.150
   141.727  1174.891     0.150
   143.004  1176.914     0.150
   145.501  1181.727     0.150
   152.025  1198.227     0.150
   152.025  1197.852     0.150
     0.275     7.062     0.150
     0.775    14.562     0.150
     0.775    26.562     0.150
     0.809    30.562     0.150
     0.964    18.562     0.150
     0.964    31.562     0.150
     1.270    24.062     0.150
     1.270    40.562     0.150
     1.204    24.562     0.150
     1.204    41.562     0.150
     1.737    32.562     0.150
     2.389    38.516     0.150
     2.389    66.461     0.150
     2.277    39.562     0.150
     2.327    41.062     0.150
     2.327    68.562     0.150
     2.681    74.230     0.150
     3.338    53.250     0.150
     3.338    91.270     0.150
     3.685    55.762     0.150
     3.685    96.262     0.150
     3.707    55.906     0.150
     3.707    97.285     0.150
     3.724    56.062     0.150
     3.724    96.762     0.150
     3.743    55.906     0.150
     3.743    97.285     0.150
     3.680   102.562     0.150
     3.853    59.590     0.150
     3.853   102.703     0.150
     3.853    99.461     0.150
     3.991    62.562     0.150
     3.991   104.535     0.150
     4.068    61.164     0.150
     4.068   107.461     0.150
     4.096   108.164     0.150
     4.185    63.363     0.150
     4.185   108.062     0.150
     4.728    70.406     0.150
     4.728   122.113     0.150
     4.819   123.863     0.150
     4.939   127.262     0.150
     0.553    11.715     0.150
     0.553    18.715     0.150
     0.537    11.715     0.150
     0.537    18.715     0.150
     1.181    22.715     0.150
     1.181    39.715     0.150
     1.269    24.715     0.150
     1.269    43.715     0.150
     1.439    28.215     0.150
     1.439    46.715     0.150
     1.571    48.715     0.150
     1.657    30.715     0.150
     1.657    52.715     0.150
     1.807    33.715     0.150
     1.807    56.715     0.150
     1.924    35.215     0.150
     2.099    36.715     0.150
     2.099    61.715     0.150
     2.099    40.516     0.150
     2.099    65.914     0.150
     2.455    42.715     0.150
     2.455    72.715     0.150
     2.529    40.715     0.150
     2.529    71.715     0.150
     3.086    49.715     0.150
     4.577   118.305     0.150
     4.794   124.320     0.150
     5.118    77.836     0.150
     5.118   134.434     0.150
     5.118   131.824     0.150
     5.405    81.387     0.150
     5.446    81.715     0.150
     5.446   139.816     0.150
     5.546    83.613     0.150
     5.546   142.215     0.150
     5.623    83.816     0.150
     5.623   145.316     0.150
     5.622    84.191     0.150
     5.622   144.848     0.150
     5.718    84.914     0.150
     5.718   148.113     0.150
     5.732    85.703     0.150
     5.732   147.090     0.150
     5.960    89.316     0.150
     5.960   153.215     0.150
     6.009    89.305     0.150
     6.009   154.031     0.150
     6.176   160.516     0.150
     6.176    92.016     0.150
     6.176   157.016     0.150
     6.178    91.582     0.150
     6.178   158.703     0.150
     6.178   156.906     0.150
     6.693    97.914     0.150
     6.693   170.215     0.150
     6.745    99.871     0.150
     6.745   172.156     0.150
     6.762   100.816     0.150
     6.937   102.414     0.150
     6.937   177.215     0.150
     7.425   110.316     0.150
     7.456   109.414     0.150
     7.456   189.016     0.150
     7.873   115.715     0.150
     7.873   199.516     0.150
     9.133   133.113     0.150
     0.258     6.734     0.150
     0.258    11.734     0.150
     0.757    15.734     0.150
     0.757    27.734     0.150
     1.197    22.234     0.150
     1.197    37.234     0.150
     1.404    26.734     0.150
     1.404    43.734     0.150
     1.633    29.734     0.150
     1.633    51.734     0.150
     1.820    33.734     0.150
     1.820    56.734     0.150
     1.773    31.734     0.150
     1.773    55.734     0.150
     2.010    35.734     0.150
     2.010    59.734     0.150
     2.119    38.734     0.150
     2.119    63.734     0.150
     2.119    38.031     0.150
     2.578    41.734     0.150
     2.578    72.734     0.150
     2.891    48.734     0.150
     2.891    82.734     0.150
     3.013    49.734     0.150
     3.013    83.734     0.150
     3.018    49.734     0.150
     3.018    83.734     0.150
     3.335    53.734     0.150
     3.335    90.734     0.150
     4.616    70.375     0.150
     4.616   121.031     0.150
     4.857    71.867     0.150
     4.857   125.977     0.150
     4.985    75.305     0.150
     4.985   130.422     0.150
     4.985    76.234     0.150
     5.478    80.938     0.150
     5.478   140.031     0.150
     5.468    81.031     0.150
     5.468   141.672     0.150
     5.468   142.617     0.150
     5.588    82.234     0.150
     5.588   142.336     0.150
     5.598    82.234     0.150
     5.598   142.734     0.150
     5.568    84.695     0.150
     5.701    83.836     0.150
     5.701   145.836     0.150
     5.693    84.094     0.150
     5.693   145.266     0.150
     5.786    85.680     0.150
     5.786   150.312     0.150
     5.863    85.789     0.150
     5.863   148.461     0.150
     5.845    87.805     0.150
     5.845   151.883     0.150
     5.946    87.633     0.150
     5.946   152.336     0.150
     6.231    91.234     0.150
     6.231   157.734     0.150
     6.223    91.461     0.150
     6.223   158.773     0.150
     6.287    91.836     0.150
     6.287   158.531     0.150
     6.441    93.414     0.150
     6.441   163.203     0.150
     6.510    96.695     0.150
     6.510    97.836     0.150
     6.510   165.703     0.150
     6.621    96.156     0.150
     6.621   167.578     0.150
     6.716    96.742     0.150
     6.716   169.836     0.150
     6.748    98.336     0.150
     6.748   170.938     0.150
     6.696    98.625     0.150
     6.696   100.336     0.150
     6.798    99.438     0.150
     6.798   171.633     0.150
     6.863    99.719     0.150
     6.863   172.281     0.150
     7.022   101.938     0.150
     7.022   178.438     0.150
     7.420   108.633     0.150
     7.420   188.031     0.150
     7.559   109.336     0.150
     7.559   189.734     0.150
     7.829   114.422     0.150
     7.829   199.273     0.150
     7.975   114.938     0.150
     7.975   199.734     0.150
     8.018   115.000     0.150
     8.018   201.094     0.150
     8.536   122.836     0.150
     8.536   212.438     0.150
     9.265   133.336     0.150
     9.265   230.234     0.150
    10.040   143.641     0.150
    10.040   248.297     0.150
    10.040   247.812     0.150
    10.032   143.820     0.150
    10.032   248.055     0.150
    11.429   163.734     0.150
    11.429   282.922     0.150
    11.429   164.344     0.150
     0.285     6.467     0.150
     0.285    12.467     0.150
     1.331    25.467     0.150
     1.537    28.467     0.150
     1.537    48.467     0.150
     1.530    28.967     0.150
     1.530    50.467     0.150
     1.701    30.467     0.150
     1.701    52.467     0.150
     1.600    28.768     0.150
     1.600    51.066     0.150
     1.667    29.166     0.150
     1.667    53.666     0.150
     1.979    36.467     0.150
     1.979    62.467     0.150
     2.273    38.467     0.150
     2.273    66.467     0.150
     2.593    44.467     0.150
     3.852    61.467     0.150
     3.852   100.895     0.150
     4.607    69.867     0.150
     4.607   120.207     0.150
     4.772    71.867     0.150
     4.772   122.734     0.150
     5.193    77.066     0.150
     5.193   133.646     0.150
     5.342    79.066     0.150
     5.342   136.768     0.150
     5.452    80.768     0.150
     5.452   139.768     0.150
     5.502    82.574     0.150
     5.502   141.445     0.150
     5.488    81.166     0.150
     5.488   140.867     0.150
     5.537    82.105     0.150
     5.537   141.428     0.150
     5.591    82.566     0.150
     5.591   143.566     0.150
     5.678    83.975     0.150
     5.678   143.965     0.150
     5.835    86.066     0.150
     5.835   149.268     0.150
     6.084    89.666     0.150
     6.084   155.268     0.150
     6.112    89.867     0.150
     6.112   155.967     0.150
     6.199    90.775     0.150
     6.199   157.994     0.150
     6.236    92.256     0.150
     6.236   160.496     0.150
     6.363    93.586     0.150
     6.363   162.646     0.150
     6.601    96.666     0.150
     6.601   166.967     0.150
     6.661    98.768     0.150
     6.661   170.166     0.150
     6.685    97.406     0.150
     6.685   168.938     0.150
     6.860    99.768     0.150
     6.860   174.166     0.150
     7.305   106.768     0.150
     7.305   185.467     0.150
     7.389   107.367     0.150
     7.389   186.268     0.150
     7.773   112.510     0.150
     7.773   193.910     0.150
     7.805   113.066     0.150
     7.805   196.367     0.150
     8.366   209.768     0.150
     9.082   130.967     0.150
     9.082   227.467     0.150
     9.315   134.117     0.150
     9.842   244.504     0.150
     0.286     6.791     0.150
     0.286    11.291     0.150
     0.518    10.791     0.150
     0.518    18.791     0.150
     1.351    27.291     0.150
     1.351    45.291     0.150
     1.541    29.291     0.150
     1.541    49.791     0.150
     1.553    30.791     0.150
     1.553    50.791     0.150
     1.686    30.291     0.150
     1.686    51.291     0.150
     2.001    36.791     0.150
     2.001    60.791     0.150
     2.264    39.791     0.150
     2.264    65.291     0.150
     2.613    44.791     0.150
     2.613    76.291     0.150
     3.620    58.791     0.150
     3.620    98.791     0.150
     5.560    82.791     0.150
     5.560   142.592     0.150
     5.701    84.391     0.150
     6.708    98.990     0.150
     6.708   169.592     0.150
     0.464    10.312     0.150
     0.464    17.812     0.150
     0.581    12.312     0.150
     0.581    20.812     0.150
     1.087    22.312     0.150
     1.087    37.312     0.150
     1.240    24.312     0.150
     1.240    42.312     0.150
     1.342    27.312     0.150
     1.342    45.312     0.150
     1.995    36.312     0.150
     1.995    60.812     0.150
     2.361    40.312     0.150
     2.361    70.312     0.150
     2.581    43.312     0.150
     2.581    73.312     0.150
     2.715    47.312     0.150
     2.715    78.312     0.150
     5.370    80.109     0.150
     5.370   138.016     0.150
     5.468    81.711     0.150
     5.468   140.211     0.150
     5.541    83.094     0.150
     5.541   143.180     0.150
     5.555    82.812     0.150
     5.555   143.312     0.150
     5.648    84.312     0.150
     5.648   146.109     0.150
     5.645    83.922     0.150
     5.645   147.070     0.150
     5.889   152.414     0.150
     6.083    90.539     0.150
     6.083   156.594     0.150
     6.091    90.711     0.150
     6.091   156.516     0.150
     6.614    97.711     0.150
     6.614   169.711     0.150
     6.660    98.570     0.150
     6.660   171.797     0.150
     0.250     5.992     0.150
     0.250     9.992     0.150
     0.447     9.992     0.150
     0.447    16.992     0.150
     0.714    14.992     0.150
     0.714    23.992     0.150
     1.247    23.992     0.150
     1.247    39.992     0.150
     1.471    27.992     0.150
     1.471    46.992     0.150
     1.947    33.992     0.150
     1.947    57.992     0.150
     3.224    89.992     0.150
     4.766    71.793     0.150
     4.766   123.594     0.150
     4.836    72.793     0.150
     4.836   125.094     0.150
     4.883    73.516     0.150
     4.883   126.641     0.150
     4.911    74.000     0.150
     4.911   127.324     0.150
     5.047    75.492     0.150
     5.110    76.793     0.150
     5.110   131.891     0.150
     5.163    78.793     0.150
     5.223    79.402     0.150
     5.223   135.082     0.150
     5.334    80.922     0.150
     5.343    79.891     0.150
     5.343   137.594     0.150
     5.933    88.102     0.150
     5.933   151.090     0.150
     0.406     9.105     0.150
     0.874    17.605     0.150
     0.937    20.605     0.150
     0.937    32.605     0.150
     1.336    25.605     0.150
     1.336    44.605     0.150
     1.648    31.605     0.150
     1.648    52.605     0.150
     1.874    33.605     0.150
     2.908    46.777     0.150
     2.908    80.715     0.150
     2.908    49.004     0.150
     2.908    82.707     0.150
     3.390    54.375     0.150
     3.390    94.145     0.150
     3.390    57.105     0.150
     3.573    57.723     0.150
     3.573    99.484     0.150
     3.573    99.906     0.150
     4.218    66.785     0.150
     4.218   114.875     0.150
     4.333    68.406     0.150
     4.333   118.746     0.150
     4.483    69.844     0.150
     4.483   121.043     0.150
     4.483    71.207     0.150
     4.483   122.004     0.150
     4.531    69.695     0.150
     4.531   120.652     0.150
     4.672    71.805     0.150
     4.672   122.207     0.150
     4.811    74.164     0.150
     4.811   131.172     0.150
     5.026    76.707     0.150
     5.026   131.805     0.150
     5.407    83.977     0.150
     5.407   145.336     0.150
     5.537    83.637     0.150
     5.537   145.656     0.150
     5.537   144.004     0.150
     0.610    12.586     0.150
     0.610    19.586     0.150
     0.610    12.086     0.150
     0.610    20.586     0.150
     0.554    12.586     0.150
     0.554    19.586     0.150
     0.554    12.086     0.150
     0.554    20.586     0.150
     1.183    23.586     0.150
     1.183    42.586     0.150
     1.537    30.586     0.150
     1.537    48.586     0.150
     1.537    51.586     0.150
     1.630    29.586     0.150
     1.630    52.586     0.150
     1.630    30.586     0.150
     3.075    49.586     0.150
     3.075    86.586     0.150
     3.646   101.586     0.150
     3.961   108.596     0.150
     4.173    65.586     0.150
     4.173   114.586     0.150
     4.319   118.205     0.150
     4.379   116.416     0.150
     4.527   122.646     0.150
     5.368    81.186     0.150
     5.368   138.285     0.150
     5.422   139.695     0.150
     5.422   142.258     0.150
     5.422    81.387     0.150
     5.422   139.387     0.150
     5.451    82.285     0.150
     5.451   140.025     0.150
     5.451   143.621     0.150
     5.505   143.146     0.150
     5.505   146.416     0.150
     5.560    86.016     0.150
     5.560   144.875     0.150
     5.687    85.605     0.150
     5.687   149.068     0.150
     5.687    86.586     0.150
     5.687   149.387     0.150
     5.902    89.086     0.150
     6.443   164.945     0.150
     6.443   168.383     0.150
     6.530   167.387     0.150
     6.702   171.186     0.150
     7.174   106.586     0.150
     8.764   128.195     0.150
     9.648   140.125     0.150
     0.672    15.070     0.150
     0.672    25.070     0.150
     0.807    17.070     0.150
     0.807    27.070     0.150
     1.020    20.070     0.150
     1.020    34.070     0.150
     1.152    22.070     0.150
     1.152    37.070     0.150
     1.150    22.070     0.150
     1.150    38.070     0.150
     1.503    28.070     0.150
     1.503    47.070     0.150
     1.642    30.070     0.150
     1.642    51.070     0.150
     2.153    37.070     0.150
     2.153    64.070     0.150
     4.001    60.801     0.150
     4.001   104.719     0.150
     4.075    60.320     0.150
     4.075   105.660     0.150
     4.359    65.551     0.150
     4.359   112.891     0.150
     4.565    68.969     0.150
     4.565   118.020     0.150
     5.092    75.379     0.150
     5.092   129.250     0.150
     0.233     4.617     0.150
     0.233     8.617     0.150
     0.368     7.617     0.150
     0.368    14.617     0.150
     1.278    24.617     0.150
     1.618    30.617     0.150
     2.519    41.617     0.150
     5.171    78.016     0.150
     5.171   134.418     0.150
     5.315    79.918     0.150
     5.315   140.316     0.150
     5.282    79.816     0.150
     5.282   137.117     0.150
     5.568    83.719     0.150
     5.568   144.117     0.150
     5.947    89.016     0.150
     5.947   152.516     0.150
     6.491   166.418     0.150
     7.223   106.219     0.150
     7.223   183.516     0.150
     0.308     7.252     0.150
     0.308    12.752     0.150
     0.636    13.252     0.150
     0.636    21.752     0.150
     0.917    19.252     0.150
     0.917    31.752     0.150
     1.254    24.252     0.150
     1.254    40.252     0.150
     1.813    33.252     0.150
     1.813    55.252     0.150
     5.185   134.852     0.150
     5.280   136.452     0.150
     5.350    79.762     0.150
     5.350   137.462     0.150
     5.447   139.440     0.150
     5.880    87.320     0.150
     5.880   150.670     0.150
     5.895    87.852     0.150
     5.895   151.152     0.150
     6.462    94.492     0.150
     6.462   165.352     0.150
     0.775    17.508     0.150
     0.844    18.008     0.150
     0.844    29.508     0.150
     1.039    21.008     0.150
     1.427    27.008     0.150
     1.427    47.008     0.150
     1.559    29.008     0.150
     1.559    48.008     0.150
     1.976    35.008     0.150
     1.976    60.008     0.150
     3.077    48.555     0.150
     3.077    84.039     0.150
     4.034    63.008     0.150
     4.034   105.711     0.150
     4.109    64.305     0.150
     4.109   107.305     0.150
     4.162    64.922     0.150
     4.162   108.508     0.150
     4.162    64.008     0.150
     4.222    64.805     0.150
     4.222   111.977     0.150
     4.422    68.508     0.150
     4.422   114.805     0.150
     4.479    68.727     0.150
     4.479   116.062     0.150
     4.678    71.711     0.150
     4.678   121.211     0.150
     4.666    71.070     0.150
     4.666   120.148     0.150
     4.666    71.406     0.150
     4.666   122.008     0.150
     4.745    72.867     0.150
     5.241    78.773     0.150
     5.241   135.438     0.150
     5.241   135.906     0.150
     0.953    19.062     0.150
     0.779    17.562     0.150
     0.779    27.562     0.150
     0.858    18.562     0.150
     0.858    28.562     0.150
     1.045    19.562     0.150
     1.045    32.562     0.150
     1.268    26.562     0.150
     1.268    42.562     0.150
     1.435    28.562     0.150
     1.435    46.562     0.150
     1.563    28.562     0.150
     1.563    46.562     0.150
     1.914    34.562     0.150
     1.914    59.562     0.150
     1.990    34.062     0.150
     1.990    58.562     0.150
     2.173    38.062     0.150
     2.173    64.562     0.150
     2.233    39.562     0.150
     2.233    66.562     0.150
     2.314    39.680     0.150
     2.314    65.080     0.150
     2.853    47.102     0.150
     2.853    79.962     0.150
     2.853    77.962     0.150
     2.877    81.562     0.150
     3.071    49.072     0.150
     3.071    85.162     0.150
     3.256    52.152     0.150
     3.256    87.972     0.150
     3.309    52.562     0.150
     3.309    89.562     0.150
     3.345    90.662     0.150
     3.707    57.582     0.150
     3.707    99.982     0.150
     3.707    57.241     0.150
     3.784    61.082     0.150
     3.784   102.662     0.150
     3.778    58.338     0.150
     4.022    60.962     0.150
     4.022   105.962     0.150
     4.097    62.062     0.150
     4.097   106.962     0.150
     4.151    63.142     0.150
     4.151   107.482     0.150
     4.151   107.842     0.150
     4.061    63.422     0.150
     4.061   109.512     0.150
     4.061   108.680     0.150
     4.079    64.770     0.150
     4.079   110.360     0.150
     4.095    65.122     0.150
     4.095   111.762     0.150
     4.141    64.362     0.150
     4.141   110.702     0.150
     4.212    63.762     0.150
     4.212   110.722     0.150
     4.212   109.430     0.150
     4.297    65.562     0.150
     4.297   112.462     0.150
     4.297   110.952     0.150
     4.297   111.842     0.150
     4.361    66.862     0.150
     4.361   114.762     0.150
     4.409    66.662     0.150
     4.409   114.562     0.150
     4.463   117.562     0.150
     4.471    67.612     0.150
     4.471   116.392     0.150
     4.594    69.962     0.150
     4.594   118.862     0.150
     4.658    71.162     0.150
     4.658   120.102     0.150
     4.668    70.162     0.150
     4.668   120.462     0.150
     4.717    70.462     0.150
     4.717   121.762     0.150
     4.660    70.862     0.150
     4.660   120.892     0.150
     4.743    73.662     0.150
     4.743   126.792     0.150
     4.743   125.912     0.150
     4.836    73.762     0.150
     4.836   126.722     0.150
     4.892    75.562     0.150
     4.947    76.742     0.150
     4.947   132.822     0.150
     4.947   131.422     0.150
     5.230    78.362     0.150
     5.230   134.762     0.150
     5.230    77.962     0.150
     5.231    77.992     0.150
     5.231   134.472     0.150
     5.258    78.362     0.150
     5.258   134.762     0.150
     5.445    80.862     0.150
     5.445   139.962     0.150
     5.690    85.902     0.150
     5.690   147.402     0.150
     5.790    85.662     0.150
     5.790   150.362     0.150
     5.949    88.262     0.150
     5.949   150.962     0.150
     5.972    88.362     0.150
     5.972   151.562     0.150
     5.972    88.232     0.150
     5.972   150.712     0.150
     6.031    89.462     0.150
     6.031   154.462     0.150
     6.031   152.430     0.150
     6.031    90.162     0.150
     6.043    89.462     0.150
     6.043   154.232     0.150
     6.096    91.812     0.150
     6.096   158.742     0.150
     6.235    92.052     0.150
     6.235   157.472     0.150
     6.235    91.882     0.150
     6.235   156.562     0.150
     6.355    93.462     0.150
     6.355   163.562     0.150
     6.365    93.762     0.150
     6.450    94.302     0.150
     6.450   161.582     0.150
     6.450   163.202     0.150
     6.801   102.352     0.150
     7.147   104.682     0.150
     7.147   179.212     0.150
     7.128   104.742     0.150
     7.607   192.762     0.150
     7.607   110.632     0.150
     7.607   191.322     0.150
     7.968   200.140     0.150
     7.981   117.312     0.150
     7.981   202.662     0.150
     8.354   121.662     0.150
     8.354   209.522     0.150
     8.438   122.362     0.150
     8.438   211.252     0.150
     8.540   123.172     0.150
     8.540   213.032     0.150
     8.828   128.862     0.150
     8.835   128.682     0.150
     8.817   128.222     0.150
     9.138   230.750     0.150
     9.512   136.802     0.150
     9.654   139.152     0.150
     9.692   140.072     0.150
     9.692   241.162     0.150
     9.763   141.502     0.150
     9.789   141.632     0.150
     9.789   244.042     0.150
     9.896   143.602     0.150
     9.896   247.922     0.150
     9.921   145.180     0.150
     9.921   248.142     0.150
    10.115   146.962     0.150
    10.115   251.522     0.150
    10.119   146.662     0.150
    10.149   146.362     0.150
    10.149   252.862     0.150
    10.151   147.062     0.150
    10.151   252.762     0.150
    10.172   147.322     0.150
    10.172   253.172     0.150
    10.201   146.982     0.150
    10.201   254.192     0.150
    10.573   152.262     0.150
    10.573   264.162     0.150
    12.836   183.162     0.150
    12.973   184.462     0.150
    13.624   193.562     0.150
    13.679   193.862     0.150
    14.434   203.662     0.150
    14.669   208.462     0.150
    14.839   209.262     0.150
    14.836   208.762     0.150
    15.228   214.762     0.150
    15.567   219.162     0.150
    15.657   220.562     0.150
     0.301     6.539     0.150
     0.301    10.539     0.150
     0.396     8.539     0.150
     0.396    15.539     0.150
     1.135    38.539     0.150
     1.457    28.539     0.150
     1.457    47.539     0.150
     2.413    41.539     0.150
     2.413    70.539     0.150
     5.194    78.336     0.150
     5.194   137.141     0.150
     5.298    80.141     0.150
     5.298   139.836     0.150
     5.360    80.539     0.150
     5.360   141.039     0.150
     5.360    80.297     0.150
     5.360   139.023     0.150
     5.379    81.078     0.150
     5.379   141.602     0.150
     5.379   140.836     0.150
     5.458    82.242     0.150
     5.458   143.836     0.150
     5.504    82.906     0.150
     5.504   145.164     0.150
     5.504    82.641     0.150
     5.504   143.141     0.150
     5.590    84.336     0.150
     5.590   146.742     0.150
     5.700    85.938     0.150
     5.700   149.438     0.150
     5.811    87.867     0.150
     5.811   152.492     0.150
     5.811    88.141     0.150
     5.811   153.336     0.150
     5.943    89.039     0.150
     5.943   155.039     0.150
     6.001   157.367     0.150
     6.515    96.086     0.150
     6.515   167.914     0.150
     6.697   100.336     0.150
     6.697   174.641     0.150
     7.222   107.039     0.150
     7.222   186.141     0.150
     0.201     4.609     0.150
     0.201     8.609     0.150
     0.832    17.109     0.150
     0.832    29.609     0.150
     0.984    19.609     0.150
     1.315    25.609     0.150
     1.340    26.109     0.150
     1.401    26.609     0.150
     1.401    46.609     0.150
     1.833    34.609     0.150
     1.833    56.609     0.150
     3.327    53.609     0.150
     3.327    90.609     0.150
     3.481    56.180     0.150
     3.791   101.938     0.150
     3.979    61.992     0.150
     3.979   106.008     0.150
     3.979   104.750     0.150
     4.362    68.930     0.150
     4.362   118.281     0.150
     4.362   119.312     0.150
     4.526   120.648     0.150
     4.526   122.008     0.150
     4.674    71.211     0.150
     4.674   122.508     0.150
     4.739    72.109     0.150
     4.739   123.906     0.150
     4.796    73.109     0.150
     4.796   125.383     0.150
     4.969    75.531     0.150
     4.969   128.492     0.150
     4.969   130.406     0.150
     5.028    76.336     0.150
     5.028   129.242     0.150
     5.028   131.109     0.150
     5.057    76.812     0.150
     5.057   131.812     0.150
     5.088    78.086     0.150
     5.088   132.750     0.150
     5.265    79.508     0.150
     5.265   136.508     0.150
     5.259    79.906     0.150
     5.259   137.211     0.150
     5.307    79.477     0.150
     5.307    80.328     0.150
     5.307    79.164     0.150
     5.352    81.312     0.150
     5.352   138.812     0.150
     5.662    84.711     0.150
     5.662   146.312     0.150
     5.819    87.297     0.150
     5.819   149.133     0.150
     5.861    88.211     0.150
     5.861   151.109     0.150
     6.055    90.609     0.150
     6.055   156.312     0.150
     6.304    95.812     0.150
     6.544    97.406     0.150
     6.544   168.312     0.150
     6.646   170.219     0.150
     6.687    99.305     0.150
     6.958   103.109     0.150
     6.958   178.008     0.150
     6.982   176.328     0.150
     8.172   120.172     0.150
     8.172   205.680     0.150
     8.903   129.711     0.150
     8.903   222.398     0.150
     9.028   131.219     0.150
     0.560    12.199     0.150
     0.695    14.199     0.150
     0.695    26.199     0.150
     0.954    19.199     0.150
     0.954    34.199     0.150
     0.968    19.199     0.150
     0.968    33.199     0.150
     1.684    31.199     0.150
     1.965    35.199     0.150
     1.965    58.199     0.150
     4.180    62.789     0.150
     4.180   109.801     0.150
     4.466    67.918     0.150
     4.466   114.848     0.150
     4.669    70.918     0.150
     4.669   123.480     0.150
     4.785    72.938     0.150
     5.052    76.707     0.150
     5.052    78.598     0.150
     5.252    78.098     0.150
     5.252   135.000     0.150
     5.334    79.301     0.150
     5.334   137.199     0.150
     5.391    80.098     0.150
     5.391   138.480     0.150
     5.447    80.469     0.150
     5.447   138.727     0.150
     5.567    82.598     0.150
     5.567   143.699     0.150
     5.642    83.801     0.150
     5.642   145.098     0.150
     5.713    86.363     0.150
     5.713    87.500     0.150
     5.804    86.098     0.150
     5.804   148.598     0.150
     5.787    85.898     0.150
     5.787   148.766     0.150
     5.907    87.098     0.150
     5.907   151.699     0.150
     5.956    88.598     0.150
     5.956   152.699     0.150
     6.238    91.801     0.150
     6.238   159.398     0.150
     6.470    94.598     0.150
     6.468    95.008     0.150
     6.468   164.363     0.150
     6.686    98.301     0.150
     6.686   170.699     0.150
     7.031   102.500     0.150
     7.031   179.398     0.150
     7.188   105.098     0.150
     7.188   182.000     0.150
     7.254   106.301     0.150
     7.254   185.000     0.150
     7.254   182.297     0.150
     7.345   106.789     0.150
     7.604   110.699     0.150
     7.604   191.199     0.150
     7.660   191.578     0.150
     8.160   118.398     0.150
     8.836   128.000     0.150
     8.836   222.098     0.150
     8.836   221.289     0.150
     8.816   126.879     0.150
     9.042   130.598     0.150
     9.151   132.098     0.150
     9.575   137.855     0.150
     9.575   239.605     0.150
     9.676   139.059     0.150
    10.062   144.461     0.150
     0.432     9.525     0.150
     0.432    16.525     0.150
     0.862    17.525     0.150
     0.862    30.525     0.150
     0.753    14.525     0.150
     0.753    24.525     0.150
     1.117    22.525     0.150
     1.117    38.525     0.150
     4.290   112.186     0.150
     4.810    73.785     0.150
     4.919    75.545     0.150
     5.263    79.525     0.150
     5.263   137.025     0.150
     5.353    80.525     0.150
     5.353   139.925     0.150
     5.419    81.416     0.150
     5.419   140.695     0.150
     5.475   142.465     0.150
     5.500    82.164     0.150
     5.500   142.263     0.150
     5.560    84.726     0.150
     5.656    85.925     0.150
     5.656   146.025     0.150
     5.799    87.025     0.150
     5.894    88.633     0.150
     5.894   151.553     0.150
     5.953    89.425     0.150
     5.953   153.025     0.150
     6.246    92.726     0.150
     6.246   161.925     0.150
     6.518    96.715     0.150
     6.518   166.936     0.150
     6.724   100.125     0.150
     6.724   172.125     0.150
     7.234   106.726     0.150
     7.234   184.325     0.150
     8.897   129.625     0.150
     0.289     6.406     0.150
     0.289    10.906     0.150
     0.497    10.406     0.150
     0.497    18.406     0.150
     1.332    25.406     0.150
     1.332    42.906     0.150
     1.534    28.906     0.150
     1.534    49.406     0.150
     2.593    43.906     0.150
     2.593    74.906     0.150
     4.610    70.500     0.150
     4.610   123.461     0.150
     5.346    79.906     0.150
     5.346   138.305     0.150
     5.456    81.305     0.150
     5.456   141.008     0.150
     5.493    81.805     0.150
     5.493   143.109     0.150
     5.493    81.680     0.150
     5.493   142.086     0.150
     5.542    82.430     0.150
     5.542   143.312     0.150
     5.596    83.508     0.150
     5.596   145.109     0.150
     5.682    83.867     0.150
     5.682   145.102     0.150
     5.743    85.508     0.150
     5.743   148.109     0.150
     5.983    88.586     0.150
     6.088   156.305     0.150
     6.116    90.609     0.150
     6.116   157.305     0.150
     6.202    91.359     0.150
     6.202   159.000     0.150
     6.316    93.109     0.150
     6.316   161.406     0.150
     6.689    98.023     0.150
     6.689   170.828     0.150
     6.864   101.008     0.150
     6.864   175.805     0.150
     7.166   105.109     0.150
     7.166   182.906     0.150
     0.668    14.422     0.150
     0.668    23.422     0.150
     0.832    16.422     0.150
     0.876    17.922     0.150
     0.876    29.422     0.150
     0.967    19.422     0.150
     0.967    32.422     0.150
     5.421    80.723     0.150
     5.421   140.121     0.150
     5.504    81.723     0.150
     5.504   142.820     0.150
     5.562    82.523     0.150
     5.562   143.203     0.150
     5.618    83.340     0.150
     5.618   146.102     0.150
     5.812   150.223     0.150
     6.059    90.723     0.150
     6.059   154.070     0.150
     6.078    90.121     0.150
     6.078   156.922     0.150
     6.407    95.121     0.150
     6.639    97.441     0.150
     6.639   170.371     0.150
     0.073     2.285     0.150
     0.621    13.285     0.150
     0.621    22.285     0.150
     0.970    20.086     0.150
     0.970    33.285     0.150
     1.413    43.285     0.150
     1.663    31.285     0.150
     1.663    52.285     0.150
     2.043    36.285     0.150
     2.043    60.285     0.150
     2.524    41.988     0.150
     2.524    69.586     0.150
     2.938    82.832     0.150
     3.164    50.320     0.150
     3.164    87.715     0.150
     3.368    92.043     0.150
     3.441    54.641     0.150
     3.988    60.848     0.150
     3.988   106.660     0.150
     4.010   104.785     0.150
     4.105    65.242     0.150
     4.105   113.684     0.150
     4.041    60.586     0.150
     4.041   105.387     0.150
     4.053    61.465     0.150
     4.169    65.234     0.150
     4.169   112.422     0.150
     4.374    66.785     0.150
     4.374   114.086     0.150
     4.403    66.785     0.150
     4.403   115.484     0.150
     4.403    67.086     0.150
     4.403   115.617     0.150
     4.428   115.484     0.150
     4.472    67.484     0.150
     4.472   115.984     0.150
     4.644    70.184     0.150
     5.007    74.770     0.150
     5.007   129.953     0.150
     4.989    74.484     0.150
     4.989   129.484     0.150
     5.277    78.984     0.150
     5.277   135.984     0.150
     5.410    82.605     0.150
     5.676    84.086     0.150
     0.195     3.676     0.150
     0.666    14.676     0.150
     0.666    24.676     0.150
     0.972    20.676     0.150
     1.319    23.676     0.150
     1.319    40.676     0.150
     1.734    31.676     0.150
     1.734    55.676     0.150
     1.996    35.676     0.150
     1.996    61.676     0.150
     3.135    50.234     0.150
     3.135    85.617     0.150
     3.307    52.234     0.150
     3.307    90.605     0.150
     4.050    61.855     0.150
     4.050   106.402     0.150
     4.106    61.477     0.150
     4.106   105.777     0.150
     4.064    65.547     0.150
     4.131    61.676     0.150
     4.131   107.176     0.150
     4.136    63.215     0.150
     4.136   105.977     0.150
     4.171   108.914     0.150
     4.466   114.977     0.150
     4.514    66.875     0.150
     4.514   116.875     0.150
     4.514    68.164     0.150
     4.534   116.277     0.150
     4.538    68.277     0.150
     4.538   116.977     0.150
     5.066    75.773     0.150
     5.066   127.496     0.150
     5.082    75.074     0.150
     5.082   130.777     0.150
     5.346    79.875     0.150
     5.346   137.277     0.150
     0.457     9.990     0.150
     0.457    16.990     0.150
     0.580    11.990     0.150
     0.580    21.990     0.150
     1.303    24.990     0.150
     1.303    42.990     0.150
     1.418    26.050     0.150
     1.418    27.402     0.150
     1.545    28.990     0.150
     1.545    49.990     0.150
     1.386    25.990     0.150
     1.386    44.990     0.150
     1.790    31.990     0.150
     1.790    53.990     0.150
     2.118    36.210     0.150
     2.118    61.590     0.150
     2.210    38.990     0.150
     2.403    67.990     0.150
     2.576    45.990     0.150
     3.521    57.990     0.150
     3.495    95.990     0.150
     3.495    56.990     0.150
     3.642    57.990     0.150
     3.642   100.990     0.150
     3.704    58.990     0.150
     3.704    99.990     0.150
     4.013   108.990     0.150
     4.013    62.990     0.150
     4.861    73.760     0.150
     4.861   125.220     0.150
     4.921    74.240     0.150
     5.222    78.090     0.150
     5.222   136.870     0.150
     5.322    80.510     0.150
     5.322   138.030     0.150
     5.356    80.610     0.150
     5.356   138.090     0.150
     5.475    80.990     0.150
     5.475   139.990     0.150
     5.580    82.490     0.150
     5.580   142.790     0.150
     5.516    83.940     0.150
     5.516   145.100     0.150
     5.635    83.090     0.150
     5.635   145.590     0.150
     5.635    83.480     0.150
     5.635   143.610     0.150
     5.661    84.040     0.150
     5.661   144.810     0.150
     5.603    84.648     0.150
     5.631    86.310     0.150
     5.735    84.590     0.150
     5.735   147.490     0.150
     5.785    85.270     0.150
     5.785   147.220     0.150
     5.871    86.690     0.150
     5.871   150.790     0.150
     5.978    88.190     0.150
     5.978   154.290     0.150
     6.211    91.090     0.150
     6.211   157.690     0.150
     6.225    91.490     0.150
     6.225   158.990     0.150
     6.263    92.120     0.150
     6.263   159.530     0.150
     6.267    94.990     0.150
     6.267   162.370     0.150
     6.448    94.290     0.150
     6.448   163.390     0.150
     6.411    94.390     0.150
     6.411   163.650     0.150
     6.437    97.030     0.150
     6.729    98.590     0.150
     6.729   170.190     0.150
     6.729   170.390     0.150
     6.748    98.590     0.150
     6.748   170.190     0.150
     6.793    99.790     0.150
     6.793   172.490     0.150
     6.796    99.310     0.150
     6.796   171.710     0.150
     6.980   101.790     0.150
     6.980   178.190     0.150
     7.012   105.860     0.150
     7.108   103.300     0.150
     7.108   179.080     0.150
     7.289   105.990     0.150
     7.289   184.690     0.150
     7.211   107.230     0.150
     7.211   184.280     0.150
     7.446   108.790     0.150
     7.446   190.290     0.150
     7.446   108.990     0.150
     7.446   189.050     0.150
     7.504   109.090     0.150
     7.504   188.690     0.150
     7.557   112.570     0.150
     7.649   110.390     0.150
     7.642   112.570     0.150
     7.642   191.300     0.150
     7.834   113.540     0.150
     7.834   196.890     0.150
     7.834   113.403     0.150
     7.834   197.003     0.150
     7.920   114.790     0.150
     7.920   198.390     0.150
     8.051   117.050     0.150
     8.051   201.570     0.150
     8.480   122.790     0.150
     8.480   212.690     0.150
     8.480   122.350     0.150
     8.754   218.340     0.150
     8.804   127.990     0.150
     8.804   215.590     0.150
     8.804   126.890     0.150
     8.806   126.890     0.150
     8.806   220.990     0.150
     8.837   127.590     0.150
     8.837   222.690     0.150
     9.188   132.490     0.150
     9.188   228.190     0.150
     9.276   133.490     0.150
     9.276   234.690     0.150
     9.365   134.590     0.150
     9.365   235.690     0.150
     9.355   134.500     0.150
     9.355   233.220     0.150
     9.471   135.990     0.150
     9.471   236.190     0.150
     9.517   138.190     0.150
     9.517   241.590     0.150
     9.461   137.650     0.150
     9.809   140.990     0.150
     9.809   245.290     0.150
     9.832   141.290     0.150
     9.832   244.390     0.150
     9.944   143.120     0.150
     9.944   247.200     0.150
    10.116   145.690     0.150
    10.116   252.590     0.150
    10.283   149.700     0.150
    11.188   160.410     0.150
    11.188   274.730     0.150
    11.302   161.150     0.150
    11.302   279.430     0.150
    11.349   163.550     0.150
    11.314   163.970     0.150
    11.395   163.870     0.150
    11.395   280.910     0.150
    11.395   163.180     0.150
    11.463   165.060     0.150
    11.482   165.950     0.150
    11.691   169.630     0.150
    11.701   168.590     0.150
    11.701   288.390     0.150
    11.718   168.990     0.150
    11.718   289.390     0.150
    11.726   169.650     0.150
    11.749   168.870     0.150
    12.099   174.790     0.150
    12.099   297.890     0.150
    13.271   190.380     0.150
    16.450   232.090     0.150
    20.040   273.710     0.150
    20.040   273.740     0.150
    25.219   327.010     0.150
    25.219   324.915     0.150
    62.727   625.590     0.150
    62.752   625.590     0.150
    65.273   642.520     0.150
    66.377   649.410     0.150
     0.301     6.289     0.150
     0.301    12.289     0.150
     0.518    11.289     0.150
     0.518    19.289     0.150
     0.654    13.789     0.150
     0.654    23.289     0.150
     1.219    40.289     0.150
     1.193    39.289     0.150
     1.211    23.289     0.150
     1.211    40.289     0.150
     1.541    29.289     0.150
     1.541    47.789     0.150
     2.713    44.289     0.150
     2.713    77.289     0.150
     3.169    50.289     0.150
     3.169    88.289     0.150
     4.814    72.391     0.150
     4.814   124.688     0.150
     4.886    73.391     0.150
     4.886   126.391     0.150
     4.935    74.336     0.150
     4.935   127.531     0.150
     4.970    74.906     0.150
     4.970   129.125     0.150
     5.086    76.750     0.150
     5.086   131.477     0.150
     5.200    77.891     0.150
     5.200   134.289     0.150
     5.292    80.391     0.150
     5.292   137.297     0.150
     5.386    80.586     0.150
     5.386   138.992     0.150
     5.434    81.289     0.150
     5.434   139.789     0.150
     5.802   149.086     0.150
     5.991    88.766     0.150
     5.991   152.336     0.150
     6.219    92.289     0.150
     6.219   158.586     0.150
     6.575    97.188     0.150
     6.575   168.188     0.150
     6.715    99.586     0.150
     7.170   180.258     0.150
     0.550    12.613     0.150
     0.550    19.113     0.150
     1.100    21.613     0.150
     1.100    36.113     0.150
     1.295    26.113     0.150
     1.295    44.113     0.150
     1.453    28.113     0.150
     1.516    48.176     0.150
     1.518    48.215     0.150
     1.482    29.613     0.150
     1.482    48.113     0.150
     1.943    36.113     0.150
     1.943    59.113     0.150
     2.862    44.512     0.150
     2.862    78.602     0.150
     2.958    82.113     0.150
     3.074    51.129     0.150
     3.074    85.516     0.150
     3.330    54.582     0.150
     3.330    91.520     0.150
     3.400    55.234     0.150
     3.947    62.402     0.150
     3.947   105.973     0.150
     4.017    63.293     0.150
     4.017   107.574     0.150
     4.086    65.734     0.150
     4.086   111.203     0.150
     4.365    68.531     0.150
     4.365   115.750     0.150
     4.632    71.152     0.150
     4.632   121.281     0.150
     4.845    74.031     0.150
     4.845   125.992     0.150
     4.879    74.414     0.150
     4.879   126.812     0.150
     4.891    74.613     0.150
     4.891   127.215     0.150
     5.131   134.312     0.150
     5.379    81.582     0.150
     5.379   139.082     0.150
     5.610    84.883     0.150
     5.610   145.094     0.150
     5.833    87.312     0.150
     5.802    87.750     0.150
     6.777   101.312     0.150
     0.242     6.383     0.150
     0.806    17.383     0.150
     0.806    29.484     0.150
     1.294    24.383     0.150
     1.294    42.383     0.150
     1.721    33.383     0.150
     1.721    54.383     0.150
     1.918    35.383     0.150
     1.918    59.383     0.150
     5.508    82.398     0.150
     5.508   142.672     0.150
     5.641    84.039     0.150
     5.641   146.430     0.150
     5.828    85.953     0.150
     5.828   149.930     0.150
     6.211    91.625     0.150
     6.211   160.555     0.150
     6.822    99.938     0.150
     6.822   173.734     0.150
     0.276     5.875     0.150
     0.276    10.875     0.150
     0.329     6.875     0.150
     0.329    11.875     0.150
     1.588    29.875     0.150
     1.588    50.875     0.150
     1.774    31.875     0.150
     1.774    54.875     0.150
     5.155    77.477     0.150
     5.155   134.578     0.150
     5.265    78.875     0.150
     5.265   136.172     0.150
     5.350   138.477     0.150
     5.492    81.844     0.150
     5.492   142.047     0.150
     5.552    83.172     0.150
     5.552   143.875     0.150
     5.792    86.328     0.150
     5.792   149.617     0.150
     5.792    86.578     0.150
     5.792   151.172     0.150
     5.821    86.453     0.150
     5.821   149.836     0.150
     5.925    87.875     0.150
     5.925   152.875     0.150
     6.125    90.672     0.150
     6.125   156.773     0.150
     6.499    95.547     0.150
     6.499   165.273     0.150
     7.202   105.578     0.150
     7.202   183.773     0.150
     0.662    14.102     0.150
     0.662    24.102     0.150
     0.747    16.602     0.150
     1.375    24.602     0.150
     1.375    43.102     0.150
     1.654    30.602     0.150
     1.654    51.102     0.150
     1.671    31.102     0.150
     1.671    52.102     0.150
     1.768    33.102     0.150
     1.768    56.102     0.150
     2.336    69.602     0.150
     4.451    68.453     0.150
     4.451   118.043     0.150
     4.466    68.148     0.150
     4.466   117.109     0.150
     4.566    69.402     0.150
     4.566   120.301     0.150
     4.582    69.141     0.150
     4.582   118.043     0.150
     4.585    68.801     0.150
     4.585   118.703     0.150
     4.959    73.902     0.150
     4.959   127.102     0.150
     5.173    77.602     0.150
     5.173   133.902     0.150
     5.213    77.902     0.150
     5.476    81.152     0.150
     5.476   140.211     0.150
     5.538    82.102     0.150
     5.645    83.203     0.150
     5.771    86.301     0.150
     0.103     6.154     0.150
     0.103    10.154     0.150
     0.589    21.154     0.150
     1.132    21.654     0.150
     1.132    35.154     0.150
     1.702    30.154     0.150
     1.702    51.154     0.150
     3.077    46.449     0.150
     3.077    81.805     0.150
     3.903   103.637     0.150
     4.316    64.754     0.150
     4.316   110.154     0.150
     4.371    65.055     0.150
     4.371   111.354     0.150
     4.405    64.244     0.150
     4.405   111.594     0.150
     4.402    64.455     0.150
     4.402   111.594     0.150
     4.642    69.754     0.150
     4.642   117.854     0.150
     4.642    67.564     0.150
     4.560    67.025     0.150
     4.560   117.473     0.150
     4.690    68.854     0.150
     4.690   120.254     0.150
     4.644   122.805     0.150
     4.917    72.455     0.150
     4.917   125.254     0.150
     4.875    71.654     0.150
     4.875   122.754     0.150
     5.303    77.555     0.150
     5.303   134.754     0.150
     5.424    79.076     0.150
     5.424   136.123     0.150
     6.042    87.254     0.150
     6.042   152.654     0.150
     6.152    89.254     0.150
     6.152   154.354     0.150
     6.577    94.980     0.150
     6.577   163.783     0.150
     7.116   102.854     0.150
     0.459    10.254     0.150
     0.459    18.254     0.150
     2.129    38.254     0.150
     2.505    39.334     0.150
     2.505    66.728     0.150
     2.354    41.254     0.150
     2.354    71.254     0.150
     2.723    42.022     0.150
     2.723    72.144     0.150
     3.153    48.772     0.150
     3.625    53.354     0.150
     3.625    93.754     0.150
     3.677    54.154     0.150
     3.677    94.955     0.150
     3.716    54.398     0.150
     3.716    95.224     0.150
     3.710    54.873     0.150
     3.710    93.979     0.150
     3.923    59.292     0.150
     3.923   100.271     0.150
     4.001   102.654     0.150
     4.096    60.935     0.150
     4.096   105.328     0.150
     4.184    61.254     0.150
     4.184   106.455     0.150
     4.235    62.455     0.150
     4.235   108.554     0.150
     4.253    61.895     0.150
     4.253   109.154     0.150
     4.612   117.754     0.150
     4.738    69.752     0.150
     4.738   119.052     0.150
     4.789    70.254     0.150
     4.976    72.754     0.150
     4.976   126.354     0.150
     5.346   135.754     0.150
     5.463    79.455     0.150
     5.463   138.554     0.150
     5.918    84.832     0.150
     5.918   148.044     0.150
     7.096   101.470     0.150
     7.833   112.241     0.150
     0.605    12.367     0.150
     0.605    20.867     0.150
     0.640    13.867     0.150
     0.640    22.867     0.150
     0.932    18.867     0.150
     0.932    30.867     0.150
     0.968    19.867     0.150
     0.968    32.867     0.150
     1.017    20.867     0.150
     1.017    34.867     0.150
     1.641    31.367     0.150
     1.641    51.867     0.150
     5.241    78.367     0.150
     5.241   134.566     0.150
     5.320    79.566     0.150
     5.320   136.566     0.150
     5.375    80.434     0.150
     5.375   138.668     0.150
     5.424    81.074     0.150
     5.424   141.113     0.150
     5.488    82.566     0.150
     5.488    83.176     0.150
     5.488   143.051     0.150
     5.563    82.688     0.150
     5.563   142.945     0.150
     5.620    83.598     0.150
     5.620   145.094     0.150
     5.630    84.066     0.150
     5.630   144.668     0.150
     5.746    85.883     0.150
     5.746   148.965     0.150
     5.879    87.266     0.150
     5.879   149.426     0.150
     5.879    87.367     0.150
     5.879   150.668     0.150
     5.886    87.469     0.150
     5.886   150.867     0.150
     6.228    91.668     0.150
     6.228   158.969     0.150
     6.445    95.445     0.150
     6.445   164.578     0.150
     6.667    98.668     0.150
     6.667   170.469     0.150
     7.015   102.566     0.150
     7.015   178.469     0.150
     7.166   105.266     0.150
     7.630   111.789     0.150
     8.810   128.266     0.150
     9.546   138.469     0.150
     9.654   138.586     0.150
     0.244     6.727     0.150
     0.244    10.727     0.150
     0.502    10.727     0.150
     1.359    26.227     0.150
     1.359    43.727     0.150
     1.578    28.727     0.150
     1.578    48.727     0.150
     5.329    78.426     0.150
     5.329   136.227     0.150
     5.441    79.826     0.150
     5.441   138.426     0.150
     5.575   143.527     0.150
     5.726    84.127     0.150
     5.726   146.127     0.150
     5.819   148.926     0.150
     5.966    86.877     0.150
     5.966    87.727     0.150
     6.105    89.127     0.150
     6.105   153.426     0.150
     6.298    91.426     0.150
     6.298   159.426     0.150
     7.151   103.727     0.150
     0.276    10.104     0.150
     1.240    25.104     0.150
     1.240    43.104     0.150
     1.370    26.104     0.150
     1.370    45.104     0.150
     1.664    31.104     0.150
     1.664    53.104     0.150
     1.774    32.604     0.150
     1.774    53.104     0.150
     1.992    62.104     0.150
     2.252    38.104     0.150
     2.252    65.104     0.150
     2.462    43.104     0.150
     5.171    77.803     0.150
     5.171   133.904     0.150
     5.205    78.504     0.150
     5.205   135.803     0.150
     5.205    77.924     0.150
     5.205   134.123     0.150
     5.259    78.803     0.150
     5.259   135.783     0.150
     5.309    79.674     0.150
     5.309   136.734     0.150
     5.309    80.104     0.150
     5.407    80.461     0.150
     5.407   138.492     0.150
     5.457    82.004     0.150
     5.457   141.504     0.150
     5.552    83.203     0.150
     5.552   143.703     0.150
     5.697    85.064     0.150
     5.697   145.994     0.150
     5.748    85.863     0.150
     5.748   147.914     0.150
     5.838    87.004     0.150
     5.838   150.904     0.150
     5.961    88.742     0.150
     5.961   153.436     0.150
     6.029    89.404     0.150
     6.412    93.863     0.150
     6.412   163.053     0.150
     6.881   101.904     0.150
     6.881   176.203     0.150
     0.228     7.500     0.150
     0.720    14.500     0.150
     1.223    23.500     0.150
     1.223    39.500     0.150
     1.442    26.102     0.150
     1.442    44.875     0.150
     1.446    26.102     0.150
     1.446    44.898     0.150
     1.451    44.883     0.150
     1.443    27.500     0.150
     1.443    47.500     0.150
     2.288    64.523     0.150
     2.296    39.500     0.150
     2.275    69.500     0.150
     2.803    44.328     0.150
     2.803    77.727     0.150
     2.870    45.938     0.150
     2.870    79.391     0.150
     2.948    46.711     0.150
     2.948    82.398     0.150
     2.869    46.500     0.150
     2.869    81.500     0.150
     2.957    48.219     0.150
     2.957    81.844     0.150
     3.007    49.133     0.150
     3.007    81.945     0.150
     3.608    57.414     0.150
     3.608    99.242     0.150
     3.739    59.672     0.150
     3.739   101.930     0.150
     3.856    59.844     0.150
     3.856   104.070     0.150
     3.874    59.461     0.150
     3.874   103.273     0.150
     3.971    60.266     0.150
     3.971   103.445     0.150
     4.037    62.625     0.150
     4.155    62.156     0.150
     4.155   107.727     0.150
     4.183    62.398     0.150
     4.183   108.203     0.150
     4.191    63.297     0.150
     4.191   108.703     0.150
     4.469    67.398     0.150
     4.469   116.000     0.150
     4.524    67.898     0.150
     4.524   116.203     0.150
     4.667    69.602     0.150
     4.667   121.297     0.150
     4.773    70.539     0.150
     4.773    71.102     0.150
     4.773   123.000     0.150
     4.863    73.000     0.150
     4.863   126.703     0.150
     4.835    74.531     0.150
     4.835   127.047     0.150
     4.964    74.266     0.150
     4.964   127.719     0.150
     5.138    76.203     0.150
     5.138   131.602     0.150
     5.195    77.500     0.150
     5.195   133.203     0.150
     5.223    77.672     0.150
     5.284    79.500     0.150
     5.284   135.602     0.150
     5.696    84.797     0.150
     5.696   146.797     0.150
     5.726    84.898     0.150
     5.726   147.398     0.150
     5.925   150.648     0.150
     6.094    89.898     0.150
     6.094   155.602     0.150
     6.319    93.094     0.150
     6.721    99.047     0.150
     7.020   179.297     0.150
     7.588   191.500     0.150
     7.735   112.703     0.150
     8.120   118.125     0.150
     9.144   133.000     0.150
     0.429    10.195     0.150
     0.595    12.695     0.150
     0.595    22.195     0.150
     1.043    35.195     0.150
     1.169    22.281     0.150
     1.169    39.680     0.150
     1.233    24.195     0.150
     1.233    41.195     0.150
     1.295    26.195     0.150
     1.295    43.195     0.150
     1.995    36.695     0.150
     1.995    62.195     0.150
     1.964    35.195     0.150
     1.964    59.195     0.150
     2.027    35.195     0.150
     2.027    61.195     0.150
     2.316    40.195     0.150
     2.316    69.195     0.150
     3.168    53.195     0.150
     3.168    90.195     0.150
     3.237    53.195     0.150
     3.237    91.195     0.150
     3.299    54.195     0.150
     3.299    92.195     0.150
     3.637    60.195     0.150
     3.637   100.195     0.150
     3.704    59.617     0.150
     3.704   102.312     0.150
     3.754    60.195     0.150
     3.754   103.195     0.150
     3.890    62.336     0.150
     3.890   106.961     0.150
     3.893    62.297     0.150
     3.893   106.992     0.150
     3.896    62.594     0.150
     3.896   106.898     0.150
     3.954    63.195     0.150
     3.954   107.195     0.150
     4.120   115.195     0.150
     4.120    67.195     0.150
     4.300    68.195     0.150
     4.300   113.195     0.150
     4.376    66.906     0.150
     4.376   117.664     0.150
     4.434    67.102     0.150
     4.434   117.727     0.150
     4.657    71.664     0.150
     4.657   123.945     0.150
     4.687    71.195     0.150
     4.705    73.445     0.150
     5.262    80.414     0.150
     5.262   139.211     0.150
     5.330    79.992     0.150
     5.330   139.094     0.150
     5.305    82.180     0.150
     5.305   139.633     0.150
     5.355    82.805     0.150
     5.355   141.266     0.150
     5.385    82.438     0.150
     5.385   142.039     0.150
     5.427    81.492     0.150
     5.427   140.797     0.150
     5.500    82.742     0.150
     5.500   142.383     0.150
     5.519    82.695     0.150
     5.519   143.297     0.150
     5.519    82.164     0.150
     5.519   140.664     0.150
     5.611    83.836     0.150
     5.611   142.336     0.150
     5.611   146.492     0.150
     5.601    83.672     0.150
     5.601   143.945     0.150
     5.602    85.656     0.150
     5.602   147.930     0.150
     5.724    85.797     0.150
     5.724   148.398     0.150
     5.731    88.352     0.150
     5.852    87.695     0.150
     5.852   151.195     0.150
     5.869    87.562     0.150
     5.869   151.266     0.150
     5.968    88.984     0.150
     5.968    89.094     0.150
     5.968   156.094     0.150
     6.018    91.766     0.150
     6.018   158.266     0.150
     6.048    90.195     0.150
     6.048   155.297     0.150
     6.036    90.070     0.150
     6.036   153.891     0.150
     6.185    94.938     0.150
     6.185   160.539     0.150
     6.309    93.695     0.150
     6.309   163.195     0.150
     6.476    98.438     0.150
     6.572    97.594     0.150
     6.594    97.594     0.150
     6.616    97.875     0.150
     6.616   168.242     0.150
     6.566    99.266     0.150
     6.660   100.078     0.150
     6.705   100.195     0.150
     6.753   102.297     0.150
     6.811   100.594     0.150
     6.811   174.297     0.150
     7.006   101.797     0.150
     7.006   178.898     0.150
     7.054   183.594     0.150
     7.084   105.297     0.150
     7.084   182.695     0.150
     7.105   123.898     0.150
     7.120   123.898     0.150
     7.315   107.898     0.150
     7.315   188.992     0.150
     7.315   107.352     0.150
     7.315   185.336     0.150
     7.335   104.641     0.150
     7.335   182.883     0.150
     7.328   107.898     0.150
     7.328   186.195     0.150
     7.302   109.195     0.150
     7.422   108.297     0.150
     7.422   187.227     0.150
     7.604   110.992     0.150
     7.604   192.680     0.150
     7.700   113.297     0.150
     7.700   195.797     0.150
     7.745   113.695     0.150
     7.745   195.297     0.150
     7.851   114.930     0.150
     7.851   197.727     0.150
     7.918   117.984     0.150
     8.100   202.336     0.150
     8.136   118.992     0.150
     8.136   208.492     0.150
     8.304   121.492     0.150
     8.304   211.094     0.150
     8.528   124.242     0.150
     8.665   126.094     0.150
     8.665   219.094     0.150
     8.933   129.992     0.150
     8.933   223.594     0.150
     8.933   223.695     0.150
     8.934   129.992     0.150
     8.934   223.695     0.150
     8.949   132.180     0.150
     8.949   226.672     0.150
     9.001   130.594     0.150
     9.001   227.492     0.150
     9.001   130.742     0.150
     9.001   224.188     0.150
     9.111   132.141     0.150
     9.188   133.398     0.150
     9.188   231.695     0.150
     9.201   133.594     0.150
     9.201   232.094     0.150
     9.206   135.156     0.150
     9.206   233.352     0.150
     9.295   134.898     0.150
     9.295   232.094     0.150
     9.413   136.594     0.150
     9.413   235.492     0.150
     9.616   139.492     0.150
     9.616   241.594     0.150
     9.652   140.695     0.150
     9.652   241.703     0.150
     9.658   139.695     0.150
     9.752   141.484     0.150
     9.752   244.523     0.150
     9.817   140.016     0.150
     9.817   240.336     0.150
     9.817   141.992     0.150
     9.817   244.867     0.150
     9.945   143.898     0.150
     9.945   249.094     0.150
    10.027   146.688     0.150
    10.273   150.141     0.150
    10.273   259.297     0.150
    10.669   149.938     0.150
    10.669   262.547     0.150
    10.662   155.617     0.150
    10.739   154.703     0.150
    10.739   267.195     0.150
    11.022   158.117     0.150
    11.034   163.422     0.150
    11.034   274.023     0.150
    11.049   160.938     0.150
    11.049   275.023     0.150
    11.069   160.148     0.150
    11.069   275.648     0.150
    11.072   275.938     0.150
    11.093   162.812     0.150
    11.093   278.055     0.150
    11.132   162.133     0.150
    11.132   277.086     0.150
    11.159   160.367     0.150
    11.159   276.250     0.150
    11.152   163.266     0.150
    11.152   279.375     0.150
    11.169   162.039     0.150
    11.169   276.898     0.150
    11.182   161.016     0.150
    11.182   279.148     0.150
    11.220   161.125     0.150
    11.220   279.703     0.150
    11.241   163.562     0.150
    11.315   164.469     0.150
    11.451   166.039     0.150
    11.454   166.297     0.150
    11.476   164.898     0.150
    11.509   165.414     0.150
    11.509   286.898     0.150
    11.551   167.633     0.150
    11.588   167.750     0.150
    11.588   290.234     0.150
    11.584   167.000     0.150
    11.601   167.594     0.150
    11.644   168.594     0.150
    11.849   171.898     0.150
    11.970   173.172     0.150
    13.049   189.547     0.150
    13.700   194.797     0.150
    13.725   193.289     0.150
    14.103   198.594     0.150
    14.263   200.297     0.150
    14.756   206.094     0.150
    15.023   210.594     0.150
    15.039   210.297     0.150
    15.602   217.898     0.150
    15.616   218.297     0.150
    15.824   221.594     0.150
    15.888   222.398     0.150
    16.171   225.195     0.150
    16.212   226.094     0.150
    16.230   228.094     0.150
    16.459   229.398     0.150
    16.456   229.594     0.150
    16.462   229.398     0.150
    16.595   231.398     0.150
    16.758   233.797     0.150
    16.926   237.797     0.150
    17.022   237.695     0.150
    17.039   236.992     0.150
    17.969   249.695     0.150
    18.228   250.594     0.150
    18.320   254.594     0.150
    18.507   255.797     0.150
    18.876   263.555     0.150
    18.969   264.695     0.150
    19.237   267.203     0.150
    19.334   269.094     0.150
    19.330   268.297     0.150
    19.330   268.094     0.150
    19.461   269.359     0.150
    19.553   271.695     0.150
    19.599   272.195     0.150
    19.599   270.992     0.150
    19.869   273.086     0.150
    20.036   275.992     0.150
    20.079   275.438     0.150
    20.098   275.430     0.150
    20.159   274.992     0.150
    20.168   276.172     0.150
    20.525   280.898     0.150
    20.885   286.695     0.150
    21.487   292.195     0.150
    21.602   293.094     0.150
    21.816   292.703     0.150
    21.959   297.297     0.150
    21.969   296.195     0.150
    22.096   298.094     0.150
    22.167   297.695     0.150
    22.167   296.117     0.150
    22.210   297.898     0.150
    22.297   298.398     0.150
    22.297   544.398     0.150
    22.297   297.898     0.150
    22.547   301.992     0.150
    22.596   302.992     0.150
    22.678   303.398     0.150
    22.719   302.586     0.150
    22.973   307.797     0.150
    23.181   309.695     0.150
    23.200   310.594     0.150
    23.338   309.297     0.150
    23.338   560.492     0.150
    23.341   311.297     0.150
    23.341   567.594     0.150
    23.407   311.898     0.150
    23.407   561.594     0.150
    23.421   311.797     0.150
    23.563   312.195     0.150
    23.666   312.719     0.150
    23.666   312.992     0.150
    23.716   313.898     0.150
    23.716   568.094     0.150
    23.932   314.188     0.150
    23.932   316.297     0.150
    24.391   319.492     0.150
    24.391   579.797     0.150
    24.442   317.992     0.150
    24.442   581.898     0.150
    24.499   320.297     0.150
    24.592   324.398     0.150
    24.708   323.492     0.150
    24.708   322.594     0.150
    24.888   325.492     0.150
    24.996   326.594     0.150
    25.042   328.094     0.150
    25.060   324.398     0.150
    25.155   327.797     0.150
    25.155   328.695     0.150
    25.298   329.195     0.150
    25.416   329.047     0.150
    25.436   330.398     0.150
    25.619   334.094     0.150
    25.648   332.828     0.150
    25.648   334.195     0.150
    25.727   334.797     0.150
    26.873   344.594     0.150
    27.240   347.297     0.150
    27.856   352.617     0.150
    28.098   354.695     0.150
    30.924   380.617     0.150
    31.699   386.047     0.150
    32.584   393.945     0.150
    34.555   410.719     0.150
    35.801   420.172     0.150
    35.801   568.250     0.150
    35.953   424.359     0.150
    36.352   427.992     0.150
    37.441   434.570     0.150
    49.684   533.523     0.150
    49.849   534.336     0.150
    49.849   534.492     0.150
    51.030   543.898     0.150
    51.723   549.734     0.150
    52.474   556.992     0.150
    56.978   587.383     0.150
    57.340   590.594     0.150
    61.882   622.094     0.150
    65.013   641.469     0.150
    66.120   649.148     0.150
    66.634   654.695     0.150
    67.296   656.422     0.150
    69.956   673.375     0.150
    74.669   701.797     0.150
    76.025   711.898     0.150
    76.155   710.844     0.150
    77.500   719.992     0.150
    77.575   718.492     0.150
    77.779   721.992     0.150
    77.866   721.898     0.150
    78.097   722.492     0.150
    78.106   722.094     0.150
    78.271   723.195     0.150
    78.675   724.648     0.150
    79.853   731.352     0.150
    80.080   735.992     0.150
    80.187   733.297     0.150
    80.872   738.398     0.150
    80.965   737.445     0.150
    82.570   746.992     0.150
    84.977   758.094     0.150
    85.343   761.797     0.150
    85.531   760.695     0.150
    86.113   766.570     0.150
    92.166   792.648     0.150
    92.706   795.492     0.150
   142.368  1174.117     0.150
   143.560  1176.594     0.150
   152.244  1196.945     0.150
   152.406  1197.969     0.150
     0.671    13.973     0.150
     0.671    22.973     0.150
     1.536    44.973     0.150
     1.893    53.973     0.150
     2.021    34.973     0.150
     2.137    58.973     0.150
     2.478    41.973     0.150
     2.478    67.973     0.150
     2.916    49.973     0.150
     2.916    81.973     0.150
     3.200    49.273     0.150
     3.667    98.973     0.150
     3.803   101.973     0.150
     3.778    56.973     0.150
     4.279    78.973     0.150
     4.384    82.973     0.150
     4.452    68.973     0.150
     4.676    69.172     0.150
     5.000   127.973     0.150
     5.198    76.574     0.150
     5.236    76.973     0.150
     5.355    80.973     0.150
     5.355   136.973     0.150
     5.435    79.672     0.150
     5.576   141.973     0.150
     5.730    96.973     0.150
     5.839    85.172     0.150
     5.922    86.773     0.150
     6.239    89.574     0.150
     6.239   156.672     0.150
     6.271    90.074     0.150
     6.271   156.574     0.150
     6.604    94.773     0.150
     6.604   164.871     0.150
     6.609    93.871     0.150
     6.609   167.574     0.150
     6.646    94.324     0.150
     6.646    94.871     0.150
     6.667    95.574     0.150
     6.667   166.473     0.150
     6.857    97.613     0.150
     6.857    98.172     0.150
     6.857   171.672     0.150
     6.856    98.074     0.150
     6.856   172.773     0.150
     6.866    97.871     0.150
     6.866   172.973     0.150
     6.761   101.973     0.150
     7.219   103.074     0.150
     7.219   181.371     0.150
     7.347   104.871     0.150
     7.347   104.672     0.150
     7.347   182.871     0.150
     7.536   108.992     0.150
     7.893   112.672     0.150
     7.917   112.871     0.150
     8.248   117.473     0.150
     8.248   207.672     0.150
     8.320   119.273     0.150
     8.320   205.871     0.150
     8.441   120.371     0.150
     8.441   209.273     0.150
     8.854   126.672     0.150
     8.854   219.773     0.150
     8.854   126.371     0.150
     8.854   221.871     0.150
     9.249   131.574     0.150
     9.249   229.172     0.150
     9.435   135.074     0.150
     9.715   239.473     0.150
     9.828   139.273     0.150
     9.828   241.473     0.150
    10.204   144.672     0.150
    10.204   250.371     0.150
    10.509   149.074     0.150
    10.509   257.871     0.150
    11.313   161.121     0.150
    17.903   248.555     0.150
    19.500   266.043     0.150
    19.500   475.293     0.150
    19.507   266.074     0.150
    21.163   283.523     0.150
    21.313   285.273     0.150
    21.654   291.473     0.150
    21.972   293.871     0.150
    22.133   296.773     0.150
    22.316   296.172     0.150
    22.367   295.973     0.150
    22.424   296.074     0.150
    22.760   301.203     0.150
    22.778   302.672     0.150
    22.862   301.941     0.150
    22.862   302.273     0.150
    23.199   305.309     0.150
    23.401   307.672     0.150
    23.434   307.074     0.150
    23.637   309.871     0.150
    25.343   327.574     0.150
    25.358   326.723     0.150
    25.660   332.172     0.150
    25.808   329.574     0.150
    26.420   336.441     0.150
    26.420   337.773     0.150
    27.786   349.273     0.150
    30.900   376.207     0.150
    35.067   411.016     0.150
    61.166   613.863     0.150
    64.746   637.328     0.150
    77.487   715.723     0.150
   140.513  1168.500     0.150
   141.681  1170.941     0.150
   150.532  1190.898     0.150
     0.239     9.742     0.150
     0.239    14.742     0.150
     0.833    16.742     0.150
     0.833    27.742     0.150
     1.221    22.742     0.150
     1.788    29.742     0.150
     1.788    52.242     0.150
     2.333    38.742     0.150
     2.333    65.742     0.150
     3.701    53.441     0.150
     3.701    94.242     0.150
     3.734    54.141     0.150
     3.734    94.844     0.150
     4.066    58.844     0.150
     4.066   103.441     0.150
     4.119    60.641     0.150
     4.119   104.844     0.150
     4.180    62.043     0.150
     4.180   106.441     0.150
     4.319   109.141     0.150
     4.326   109.641     0.150
     4.335    62.742     0.150
     4.335   109.543     0.150
     4.681    68.043     0.150
     4.681   119.043     0.150
     4.823   121.344     0.150
     5.451   137.641     0.150
     0.491    10.648     0.150
     0.491    18.648     0.150
     1.061    20.648     0.150
     1.061    35.648     0.150
     1.670    29.648     0.150
     1.670    49.648     0.150
     1.976    33.648     0.150
     1.976    57.648     0.150
     2.113    34.648     0.150
     2.113    60.648     0.150
     5.568   140.750     0.150
     5.701    83.250     0.150
     5.701   143.848     0.150
     5.758    84.648     0.150
     5.758   147.047     0.150
     5.808    84.117     0.150
     5.808   146.465     0.150
     5.966    86.750     0.150
     5.966   150.449     0.150
     6.016   150.645     0.150
     6.196   156.449     0.150
     6.424    92.660     0.150
     6.424   161.238     0.150
     6.424    93.348     0.150
     6.424   161.250     0.150
     6.513    94.449     0.150
     6.513   164.250     0.150
     0.556    11.938     0.150
     0.556    19.938     0.150
     1.449    27.938     0.150
     1.449    47.938     0.150
     1.567    29.938     0.150
     1.567    49.938     0.150
     1.686    31.938     0.150
     1.686    52.938     0.150
     2.124    34.938     0.150
     2.124    59.938     0.150
     5.317    80.141     0.150
     5.317   138.539     0.150
     5.432    81.734     0.150
     5.432   140.734     0.150
     5.523    82.336     0.150
     5.523   142.336     0.150
     5.586    84.086     0.150
     5.682    84.719     0.150
     5.682   146.953     0.150
     5.714    85.938     0.150
     5.714   147.234     0.150
     5.952    89.578     0.150
     5.952    89.734     0.150
     6.030    89.977     0.150
     6.030   155.219     0.150
     6.109    91.539     0.150
     6.281    93.734     0.150
     6.583    97.836     0.150
     6.685    99.133     0.150
     6.685   170.664     0.150
     7.972   116.266     0.150
     7.972   201.031     0.150
     9.085   132.492     0.150
     9.849   143.492     0.150
     0.172     4.528     0.150
     0.470    10.528     0.150
     0.470    18.528     0.150
     0.784    16.528     0.150
     0.784    28.528     0.150
     1.158    22.528     0.150
     1.158    39.528     0.150
     1.335    25.528     0.150
     1.335    42.528     0.150
     1.434    28.528     0.150
     2.837    45.528     0.150
     2.837    77.528     0.150
     2.956    47.866     0.150
     2.956    81.116     0.150
     4.721    71.396     0.150
     4.839    72.128     0.150
     4.839   125.328     0.150
     4.905    73.528     0.150
     4.905   126.729     0.150
     4.948    74.608     0.150
     4.948   128.148     0.150
     4.964    74.777     0.150
     4.964   129.207     0.150
     5.129    76.869     0.150
     5.129   132.090     0.150
     5.160    77.818     0.150
     5.128   134.128     0.150
     5.128    76.720     0.150
     5.128   132.430     0.150
     5.189   135.428     0.150
     5.222   134.428     0.150
     5.244    79.026     0.150
     5.244   135.366     0.150
     5.316   137.208     0.150
     5.433    81.128     0.150
     5.433   139.128     0.150
     5.473   141.028     0.150
     5.827   148.928     0.150
     5.986    88.358     0.150
     5.986   153.528     0.150
     6.028   154.128     0.150
     6.712    98.928     0.150
     7.146   105.288     0.150
     7.146   180.958     0.150
     8.338   121.291     0.150
     0.605    13.535     0.150
     0.748    15.535     0.150
     0.748    26.535     0.150
     0.963    19.535     0.150
     0.963    32.535     0.150
     1.152    20.535     0.150
     1.152    36.535     0.150
     1.657    29.535     0.150
     1.657    46.535     0.150
     3.903    99.135     0.150
     3.978   101.535     0.150
     4.031    60.646     0.150
     4.031   102.905     0.150
     4.093   105.513     0.150
     4.360    64.627     0.150
     4.360   112.277     0.150
     4.549    67.835     0.150
     4.549   117.936     0.150
     4.658    68.775     0.150
     4.658   120.785     0.150
     5.112    75.016     0.150
     5.112   128.535     0.150
     0.295     5.922     0.150
     0.295    11.422     0.150
     0.303     7.422     0.150
     1.214    24.422     0.150
     1.214    42.422     0.150
     1.795    33.422     0.150
     1.795    53.422     0.150
     2.005    36.422     0.150
     2.302    39.422     0.150
     2.302    65.422     0.150
     5.133    77.822     0.150
     5.133   133.022     0.150
     5.242    79.322     0.150
     5.242   134.922     0.150
     5.387    81.522     0.150
     5.387   140.122     0.150
     5.468    81.820     0.150
     5.468   141.210     0.150
     5.874    87.822     0.150
     5.901    88.422     0.150
     5.901   152.022     0.150
     6.000    88.790     0.150
     6.000   154.570     0.150
     6.104    91.022     0.150
     6.104   157.322     0.150
     6.475    96.214     0.150
     6.475   165.852     0.150
     0.535    11.703     0.150
     0.535    20.703     0.150
     0.589    12.203     0.150
     0.589    21.703     0.150
     0.589    11.703     0.150
     0.589    20.703     0.150
     1.348    24.115     0.150
     1.348    43.590     0.150
     1.509    28.203     0.150
     1.509    47.703     0.150
     1.868    32.703     0.150
     1.868    56.703     0.150
     2.144    38.703     0.150
     2.144    64.703     0.150
     2.144    37.504     0.150
     2.144    60.004     0.150
     2.178    36.703     0.150
     2.178    62.703     0.150
     2.487    43.703     0.150
     2.487    71.703     0.150
     2.525    41.703     0.150
     2.525    70.703     0.150
     3.364    54.703     0.150
     3.364    93.703     0.150
     3.506    56.703     0.150
     3.506    95.703     0.150
     3.776    59.703     0.150
     3.910    61.438     0.150
     3.910   105.955     0.150
     3.955    62.703     0.150
     3.955   107.703     0.150
     4.097    63.781     0.150
     4.097   110.648     0.150
     4.103    64.135     0.150
     4.103   110.414     0.150
     4.321    67.402     0.150
     4.361    68.322     0.150
     4.361   117.703     0.150
     4.507    70.023     0.150
     4.523    70.043     0.150
     4.523   122.453     0.150
     4.645    68.840     0.150
     4.645   120.555     0.150
     4.819    72.992     0.150
     4.856    73.521     0.150
     4.856   127.096     0.150
     4.900    72.572     0.150
     4.910    74.504     0.150
     4.910   128.703     0.150
     5.303    79.648     0.150
     5.303   140.822     0.150
     5.495    81.303     0.150
     5.495   140.604     0.150
     5.519    84.477     0.150
     5.519   145.559     0.150
     5.569    83.701     0.150
     5.569   147.619     0.150
     5.598    82.803     0.150
     5.598   141.902     0.150
     5.600    84.279     0.150
     5.600   148.848     0.150
     5.666    83.604     0.150
     5.666   145.703     0.150
     5.666   143.797     0.150
     5.675    84.018     0.150
     5.675   146.025     0.150
     5.763    84.963     0.150
     5.763   146.834     0.150
     5.763    84.803     0.150
     5.763   146.104     0.150
     5.790    85.291     0.150
     5.790   146.344     0.150
     5.814   151.803     0.150
     5.891    86.803     0.150
     5.891   149.803     0.150
     5.945    89.332     0.150
     6.005    88.303     0.150
     6.005   152.902     0.150
     6.073    89.111     0.150
     6.073   155.762     0.150
     6.134    90.072     0.150
     6.134   155.043     0.150
     6.228    91.402     0.150
     6.228   157.203     0.150
     6.233    91.504     0.150
     6.233   159.402     0.150
     6.233    93.439     0.150
     6.233   162.537     0.150
     6.245    91.832     0.150
     6.245   158.920     0.150
     6.297   107.703     0.150
     6.471    94.703     0.150
     6.471   164.504     0.150
     6.537   111.703     0.150
     6.690   100.768     0.150
     6.690   173.787     0.150
     6.745    98.803     0.150
     6.803    99.277     0.150
     6.803   171.363     0.150
     6.964   104.951     0.150
     7.212   105.803     0.150
     7.212   183.604     0.150
     7.306   106.803     0.150
     7.468   107.854     0.150
     7.513   109.104     0.150
     7.513   189.703     0.150
     7.516   111.240     0.150
     7.632   110.104     0.150
     7.632   191.043     0.150
     7.814   112.604     0.150
     7.814   194.312     0.150
     7.814   113.004     0.150
     7.851   112.303     0.150
     7.873   114.303     0.150
     7.929   114.902     0.150
     7.929   199.402     0.150
     8.049   116.520     0.150
     8.049   201.975     0.150
     8.309   120.203     0.150
     8.489   122.902     0.150
     8.489   214.104     0.150
     8.489   122.703     0.150
     8.737   125.941     0.150
     8.737   217.988     0.150
     8.773   129.004     0.150
     8.847   127.303     0.150
     9.154   134.602     0.150
     9.192   132.504     0.150
     9.192   232.004     0.150
     9.192   132.164     0.150
     9.192   229.178     0.150
     9.248   129.766     0.150
     9.283   135.004     0.150
     9.325   134.021     0.150
     9.373   134.604     0.150
     9.358   134.703     0.150
     9.358   233.604     0.150
     9.420   137.031     0.150
     9.420   237.934     0.150
     9.480   136.104     0.150
     9.480   236.504     0.150
     9.600   240.803     0.150
     9.810   140.902     0.150
     9.810   246.504     0.150
     9.842   141.004     0.150
     9.946   142.850     0.150
     9.946   248.324     0.150
    10.001   143.160     0.150
    10.001   248.686     0.150
    10.127   145.402     0.150
    10.127   253.004     0.150
    10.240   148.570     0.150
    10.476   153.080     0.150
    10.875   157.252     0.150
    10.924   156.324     0.150
    10.924   268.318     0.150
    11.201   159.396     0.150
    11.294   160.900     0.150
    11.294   280.516     0.150
    11.351   162.541     0.150
    11.368   163.469     0.150
    11.378   162.352     0.150
    11.378   280.703     0.150
    11.434   162.473     0.150
    11.434   283.178     0.150
    11.664   166.793     0.150
    11.664   288.432     0.150
    11.669   166.303     0.150
    11.669   286.604     0.150
    11.690   167.203     0.150
    11.690   287.004     0.150
    11.688   170.852     0.150
    11.722   167.311     0.150
    11.722   290.852     0.150
    11.765   169.131     0.150
    11.802   169.775     0.150
    11.802   294.793     0.150
    11.795   170.443     0.150
    12.063   171.203     0.150
    12.183   175.002     0.150
    13.004   183.703     0.150
    13.192   188.854     0.150
    13.192   189.703     0.150
    13.658   194.312     0.150
    14.317   201.004     0.150
    14.477   202.004     0.150
    14.464   206.504     0.150
    14.966   208.604     0.150
    15.188   370.902     0.150
    15.236   212.203     0.150
    15.251   212.703     0.150
    15.808   220.303     0.150
    15.827   220.604     0.150
    15.825   220.604     0.150
    16.015   223.803     0.150
    16.032   223.104     0.150
    16.097   224.504     0.150
    16.296   236.742     0.150
    16.386   227.703     0.150
    16.430   228.803     0.150
    16.426   228.203     0.150
    16.437   229.703     0.150
    16.584   230.004     0.150
    16.667   231.703     0.150
    16.674   231.504     0.150
    16.672   232.504     0.150
    16.806   234.504     0.150
    16.972   235.303     0.150
    16.972   413.402     0.150
    17.138   239.104     0.150
    17.234   239.104     0.150
    17.252   239.203     0.150
    17.544   246.652     0.150
    17.575   249.033     0.150
    18.476   257.104     0.150
    18.491   257.504     0.150
    18.533   258.303     0.150
    18.607   260.793     0.150
    18.721   260.303     0.150
    19.084   264.762     0.150
    19.160   266.504     0.150
    19.182   265.902     0.150
    19.253   266.104     0.150
    19.447   268.416     0.150
    19.549   269.504     0.150
    19.543   269.504     0.150
    19.669   270.445     0.150
    19.694   271.613     0.150
    19.729   269.604     0.150
    19.768   271.803     0.150
    19.813   272.264     0.150
    19.813   277.014     0.150
    19.813   272.803     0.150
    19.813   619.318     0.150
    20.010   273.965     0.150
    20.007   273.004     0.150
    20.007   488.482     0.150
    20.012   273.104     0.150
    20.012   273.014     0.150
    20.012   488.479     0.150
    20.012   623.660     0.150
    20.193   277.094     0.150
    20.578   279.463     0.150
    20.639   280.764     0.150
    20.736   282.164     0.150
    20.990   285.004     0.150
    21.051   286.336     0.150
    21.132   285.803     0.150
    21.214   286.193     0.150
    21.814   294.803     0.150
    22.021   294.049     0.150
    22.375   298.902     0.150
    22.375   297.703     0.150
    22.489   299.504     0.150
    22.506   300.104     0.150
    22.506   299.203     0.150
    22.751   303.703     0.150
    22.922   303.168     0.150
    23.405   308.178     0.150
    23.547   309.803     0.150
    23.547   311.504     0.150
    23.616   311.104     0.150
    23.616   316.004     0.150
    23.775   316.703     0.150
    23.775   340.703     0.150
    23.926   318.303     0.150
    24.138   315.629     0.150
    24.138   316.104     0.150
    24.405   318.803     0.150
    24.600   319.604     0.150
    24.914   323.104     0.150
    24.980   324.004     0.150
    25.112   325.604     0.150
    25.266   329.902     0.150
    25.219   326.928     0.150
    25.219   596.652     0.150
    25.219   798.879     0.150
    25.239   327.104     0.150
    25.329   329.604     0.150
    25.329   330.953     0.150
    25.531   329.902     0.150
    25.656   331.104     0.150
    25.778   333.531     0.150
    25.778   334.402     0.150
    26.263   338.104     0.150
    26.263     2.658     0.150
    28.040   352.973     0.150
    28.040   353.203     0.150
    28.289   354.902     0.150
    28.291   354.902     0.150
    31.897   383.514     0.150
    32.077   391.754     0.150
    32.077     2.340     0.150
    32.739   392.803     0.150
    32.738   392.854     0.150
    34.433   407.402     0.150
    36.015   420.203     0.150
    36.015   420.254     0.150
    37.645   435.803     0.150
    37.645   523.203     0.150
    41.246   463.402     0.150
    41.517   466.379     0.150
    49.875   533.379     0.150
    50.051   534.568     0.150
    50.051   535.303     0.150
    50.051   614.504     0.150
    50.051   649.703     0.150
    50.051   967.902     0.150
    50.051  1179.303     0.150
    57.107   589.504     0.150
    57.176   587.615     0.150
    61.020   612.004     0.150
    62.664   625.078     0.150
    62.690   625.303     0.150
    64.704   638.803     0.150
    64.704   782.803     0.150
    64.704  1157.604     0.150
    64.704  1165.104     0.150
    64.704  1409.004     0.150
    65.215   641.402     0.150
    65.216   641.902     0.150
    65.216   641.354     0.150
    66.311   649.604     0.150
    66.311   649.586     0.150
    66.327   649.504     0.150
    67.161   655.178     0.150
    70.096   671.248     0.150
    70.096   671.303     0.150
    71.016   679.504     0.150
    71.897   684.504     0.150
    76.359   711.594     0.150
    76.907   713.402     0.150
    77.356   713.203     0.150
    77.665   718.703     0.150
    77.944   718.703     0.150
    77.944   718.803     0.150
    78.361   723.562     0.150
    78.845   723.652     0.150
    78.845   724.203     0.150
    80.054   731.604     0.150
    80.057   730.803     0.150
    80.057   730.844     0.150
    80.076   730.203     0.150
    80.391   731.803     0.150
    80.391   733.203     0.150
    80.453   734.203     0.150
    80.993   736.303     0.150
    80.993   736.254     0.150
    84.520   756.572     0.150
    86.736   765.902     0.150
    87.335   766.604     0.150
    87.335  1405.303     0.150
    97.621   817.803     0.150
   100.253   829.703     0.150
   100.253  1525.104     0.150
   142.477  1173.902     0.150
   142.477  1173.879     0.150
   143.649  1174.258     0.150
   152.383  1197.902     0.150
   152.455  1197.754     0.150
     0.627    13.117     0.150
     0.627    22.117     0.150
     0.669    15.117     0.150
     0.669    24.117     0.150
     1.169    24.117     0.150
     1.169    41.117     0.150
     1.161    23.117     0.150
     1.161    40.117     0.150
     1.455    29.117     0.150
     1.455    48.117     0.150
     2.000    35.117     0.150
     2.000    62.117     0.150
     2.627    43.117     0.150
     2.627    73.117     0.150
     5.699    85.430     0.150
     5.699   147.812     0.150
     5.717   148.031     0.150
     5.798    86.008     0.150
     6.057   154.883     0.150
     6.813   100.320     0.150
     6.813   173.039     0.150
     0.457    10.505     0.150
     0.457    16.505     0.150
     0.645    13.505     0.150
     0.645    23.505     0.150
     0.789    16.005     0.150
     0.789    27.505     0.150
     0.976    19.505     0.150
     0.976    32.505     0.150
     1.129    21.505     0.150
     1.129    38.505     0.150
     2.614    44.505     0.150
     2.614    72.505     0.150
     3.137    50.505     0.150
     3.137    86.505     0.150
     5.227    78.295     0.150
     5.227   134.245     0.150
     5.262    79.033     0.150
     5.262   135.213     0.150
     5.445   139.415     0.150
     6.284    92.965     0.150
     6.284   159.145     0.150
     0.542    11.830     0.150
     0.542    18.830     0.150
     0.915    19.330     0.150
     0.915    30.830     0.150
     1.199    24.830     0.150
     1.199    42.830     0.150
     0.807    16.330     0.150
     2.656    44.830     0.150
     2.656    77.830     0.150
     3.215    53.830     0.150
     3.400    56.383     0.150
     4.070    63.645     0.150
     4.070   109.020     0.150
     4.403    69.268     0.150
     4.403   118.711     0.150
     4.681   127.473     0.150
     4.765    75.516     0.150
     4.765   129.525     0.150
     4.871    76.963     0.150
     4.871   134.502     0.150
     5.265    80.330     0.150
     5.265   138.230     0.150
     5.336    81.230     0.150
     5.336   139.830     0.150
     5.384    82.248     0.150
     5.384   140.633     0.150
     5.261    82.674     0.150
     5.409    82.180     0.150
     5.409   141.096     0.150
     5.534    84.330     0.150
     5.534   145.520     0.150
     5.602    85.080     0.150
     5.572    84.631     0.150
     5.572   145.018     0.150
     5.651    85.830     0.150
     5.651   147.131     0.150
     5.558    88.047     0.150
     5.678    86.340     0.150
     5.678   149.537     0.150
     5.836    88.430     0.150
     5.836   152.430     0.150
     5.877    88.830     0.150
     5.877   153.730     0.150
     5.901    88.881     0.150
     5.901    89.131     0.150
     5.901   153.230     0.150
     5.954    89.830     0.150
     5.954   154.930     0.150
     6.253    93.830     0.150
     6.253   162.131     0.150
     6.214    94.861     0.150
     6.431    96.381     0.150
     6.431   166.732     0.150
     6.464    96.930     0.150
     6.796   104.113     0.150
     7.023   104.631     0.150
     7.023   181.430     0.150
     7.156   106.631     0.150
     7.156   184.330     0.150
     7.209   106.730     0.150
     7.227   107.643     0.150
     7.586   112.430     0.150
     7.592   112.141     0.150
     7.592   192.885     0.150
     8.015   118.430     0.150
     8.124   120.131     0.150
     8.124   207.230     0.150
     8.170   120.908     0.150
     8.170   208.221     0.150
     8.785   128.930     0.150
     8.785   223.730     0.150
     8.785   221.951     0.150
     9.113   133.730     0.150
     9.113   231.430     0.150
     9.380   137.131     0.150
     9.515   138.764     0.150
     9.515   239.279     0.150
     9.641   140.941     0.150
     9.641   243.135     0.150
    10.552   153.701     0.150
    10.788   157.607     0.150
    10.868   158.066     0.150
    10.802   157.842     0.150
    10.930   158.670     0.150
     0.483    10.484     0.150
     0.483    17.484     0.150
     0.587    12.984     0.150
     0.587    21.484     0.150
     1.097    21.484     0.150
     1.232    23.484     0.150
     1.232    40.484     0.150
     1.993    35.484     0.150
     1.993    57.484     0.150
     2.583    42.484     0.150
     2.583    71.484     0.150
     4.497    66.715     0.150
     4.497   119.064     0.150
     5.321    80.082     0.150
     5.321   141.002     0.150
     5.388    79.684     0.150
     5.388   138.885     0.150
     5.486    81.285     0.150
     5.486   140.484     0.150
     5.559    82.414     0.150
     5.559   142.215     0.150
     5.573    82.184     0.150
     5.573   143.285     0.150
     5.573    81.965     0.150
     5.663    82.932     0.150
     5.663   144.352     0.150
     5.666    83.635     0.150
     5.666   145.084     0.150
     5.783   148.084     0.150
     5.907    86.984     0.150
     5.907   151.084     0.150
     5.932    87.430     0.150
     5.932   151.305     0.150
     6.026    88.754     0.150
     6.026   154.385     0.150
     6.079    90.604     0.150
     6.079   159.965     0.150
     6.109    89.885     0.150
     6.109   156.285     0.150
     6.099    89.777     0.150
     6.099   155.633     0.150
     6.115    89.885     0.150
     6.115   155.785     0.150
     6.366    93.084     0.150
     6.366   160.885     0.150
     6.632    97.285     0.150
     6.632   168.584     0.150
     6.678    97.912     0.150
     6.678   170.834     0.150
     7.193   105.184     0.150
     7.389   107.584     0.150
     7.389   187.084     0.150
     7.667   110.748     0.150
     7.667   192.098     0.150
     7.759   113.184     0.150
     7.914   114.785     0.150
     9.063   130.885     0.150
     9.063   131.084     0.150
     9.063   227.344     0.150
     9.814   141.043     0.150
     0.336     7.789     0.150
     0.336    12.789     0.150
     0.641    13.289     0.150
     0.641    21.789     0.150
     1.117    21.789     0.150
     1.117    35.789     0.150
     1.178    40.789     0.150
     1.293    41.789     0.150
     1.605    29.789     0.150
     1.605    49.789     0.150
     2.678    43.789     0.150
     2.678    74.789     0.150
     5.000    74.590     0.150
     5.000   129.789     0.150
     5.050    75.488     0.150
     5.050   131.730     0.150
     5.084    76.043     0.150
     5.084   133.156     0.150
     5.197    77.789     0.150
     5.197   134.391     0.150
     5.197   134.832     0.150
     5.264    78.289     0.150
     5.264   136.188     0.150
     5.271    78.527     0.150
     5.271   136.723     0.150
     5.314    79.688     0.150
     5.314   136.891     0.150
     5.396   140.117     0.150
     5.549    82.688     0.150
     5.549   142.289     0.150
     5.564    82.391     0.150
     5.564   144.391     0.150
     5.916    87.090     0.150
     5.916   152.488     0.150
     6.106    90.020     0.150
     6.106   156.633     0.150
     6.829   100.188     0.150
     1.230    24.140     0.150
     1.230    42.140     0.150
     1.361    26.140     0.150
     2.473    45.702     0.150
     2.473    73.215     0.150
     2.476    45.740     0.150
     2.476    73.240     0.150
     3.313    53.430     0.150
     3.313    91.230     0.150
     3.414    54.140     0.150
     3.752    58.978     0.150
     3.752   101.198     0.150
     3.874    60.140     0.150
     3.879    61.540     0.150
     3.879   105.730     0.150
     3.913    60.838     0.150
     3.913   106.848     0.150
     4.051    63.340     0.150
     4.051   109.580     0.150
     4.721    73.090     0.150
     4.721   125.210     0.150
     4.817    74.140     0.150
     4.817   126.340     0.150
     4.810    72.728     0.150
     4.810   124.648     0.150
     4.856    73.240     0.150
     4.856   126.440     0.150
     4.873    73.570     0.150
     4.873   126.110     0.150
     4.862    73.820     0.150
     4.862   127.130     0.150
     4.911    75.058     0.150
     4.911   128.878     0.150
     5.186    78.740     0.150
     5.186   134.740     0.150
     5.151    79.060     0.150
     5.151   135.720     0.150
     5.162    78.070     0.150
     5.295    80.140     0.150
     5.295   136.340     0.150
     5.439   140.640     0.150
     5.439    81.680     0.150
     5.439    82.240     0.150
     5.439   141.540     0.150
     5.354    81.828     0.150
     5.450   141.140     0.150
     5.800    87.340     0.150
     5.800   150.140     0.150
     5.828    87.040     0.150
     5.828   149.070     0.150
     5.947    88.840     0.150
     5.947   153.540     0.150
     5.939    90.480     0.150
     6.101    91.440     0.150
     6.101   157.240     0.150
     6.438   165.877     0.150
     6.560    97.340     0.150
     6.560   167.840     0.150
     6.904   101.250     0.150
     6.904   175.730     0.150
     8.132   118.490     0.150
     8.132   204.970     0.150
     0.783    15.584     0.150
     0.783    29.584     0.150
     1.259    42.584     0.150
     1.380    25.584     0.150
     1.380    44.584     0.150
     1.243    23.584     0.150
     1.243    39.584     0.150
     1.629    31.354     0.150
     1.820    32.584     0.150
     1.820    57.584     0.150
     2.186    37.375     0.150
     2.320    37.457     0.150
     2.320    66.689     0.150
     2.365    40.584     0.150
     2.365    68.584     0.150
     2.347    39.584     0.150
     2.347    65.584     0.150
     2.977    48.760     0.150
     3.693    55.984     0.150
     3.693    96.684     0.150
     3.682    56.525     0.150
     3.682    97.141     0.150
     3.725    96.885     0.150
     3.737    56.082     0.150
     3.737    98.195     0.150
     3.777    59.584     0.150
     3.777   100.584     0.150
     3.801    57.820     0.150
     3.801   100.646     0.150
     4.011    62.584     0.150
     4.011   106.584     0.150
     3.935    62.529     0.150
     3.935   109.334     0.150
     4.057   106.084     0.150
     4.092   108.283     0.150
     4.164    61.984     0.150
     4.164   108.184     0.150
     4.310    64.484     0.150
     4.310   111.385     0.150
     4.329   112.184     0.150
     4.672    69.184     0.150
     4.672   120.084     0.150
     4.703    69.820     0.150
     4.703   120.477     0.150
     0.321     6.711     0.150
     0.321    11.711     0.150
     1.021    20.910     0.150
     1.021    35.711     0.150
     1.064    23.211     0.150
     1.421    27.211     0.150
     1.421    45.211     0.150
     1.507    30.211     0.150
     1.801    31.211     0.150
     1.801    55.211     0.150
     2.616    44.211     0.150
     2.616    76.211     0.150
     2.979    48.211     0.150
     2.979    82.211     0.150
     3.063    50.211     0.150
     3.063    86.211     0.150
     3.491    93.910     0.150
     3.588    96.012     0.150
     3.666    57.541     0.150
     3.666    97.791     0.150
     3.786   101.512     0.150
     3.809   100.822     0.150
     3.885   103.211     0.150
     4.201    64.998     0.150
     4.201   108.725     0.150
     4.237    66.111     0.150
     4.237   111.711     0.150
     4.471    68.410     0.150
     4.471   117.910     0.150
     4.476    68.824     0.150
     4.476   118.146     0.150
     4.731    72.934     0.150
     4.731   124.650     0.150
     4.812    72.721     0.150
     4.812   124.758     0.150
     5.514   143.512     0.150
     0.253     6.328     0.150
     0.253    11.328     0.150
     0.552    11.328     0.150
     0.552    19.328     0.150
     1.585    29.328     0.150
     1.585    48.328     0.150
     1.634    30.328     0.150
     2.215    39.328     0.150
     2.215    65.328     0.150
     5.376    79.727     0.150
     5.376   138.031     0.150
     5.488    81.125     0.150
     5.488   141.125     0.150
     5.514    82.430     0.150
     5.773    85.531     0.150
     5.773   147.828     0.150
     6.154    90.727     0.150
     6.154   157.227     0.150
     6.343    92.727     0.150
     6.343   161.531     0.150
     6.900   100.727     0.150
     7.198   104.828     0.150
     0.391     8.387     0.150
     0.391    13.887     0.150
     1.386    25.887     0.150
     1.386    45.887     0.150
     1.783    32.887     0.150
     1.783    55.887     0.150
     2.554    42.887     0.150
     2.554    74.887     0.150
     2.940    81.387     0.150
     2.961    48.117     0.150
     2.961    82.543     0.150
     2.989    49.887     0.150
     2.989    85.887     0.150
     3.092    50.887     0.150
     3.092    86.887     0.150
     3.533    94.285     0.150
     3.627    97.188     0.150
     3.701    58.367     0.150
     3.701    99.195     0.150
     3.760   100.086     0.150
     3.760   102.715     0.150
     3.833    60.375     0.150
     3.833   102.750     0.150
     3.926   105.387     0.150
     4.073   108.285     0.150
     4.207   111.289     0.150
     4.265    66.086     0.150
     4.265   113.387     0.150
     4.473    69.543     0.150
     4.473   118.305     0.150
     4.515    69.285     0.150
     4.515   117.688     0.150
     4.709   124.879     0.150
     4.838    73.645     0.150
     4.838   127.352     0.150
     5.334   137.488     0.150
     5.543   142.688     0.150
     0.380     7.525     0.150
     0.380    13.525     0.150
     1.179    25.826     0.150
     1.179    42.426     0.150
     1.671    29.525     0.150
     1.671    50.525     0.150
     1.797    35.525     0.150
     1.797    59.525     0.150
     4.718    73.277     0.150
     4.718   125.357     0.150
     4.754    74.168     0.150
     4.754   125.402     0.150
     5.110    78.525     0.150
     5.110   134.326     0.150
     5.174    79.025     0.150
     5.174   135.125     0.150
     5.174    79.373     0.150
     5.174   134.979     0.150
     5.244    80.125     0.150
     5.244   136.926     0.150
     5.298    80.826     0.150
     5.298    81.326     0.150
     5.298   140.326     0.150
     5.353    81.684     0.150
     5.353   140.318     0.150
     5.507   143.926     0.150
     5.544    84.725     0.150
     5.544   146.725     0.150
     5.571    84.529     0.150
     5.571   144.271     0.150
     5.875   153.326     0.150
     5.975    90.125     0.150
     5.975   154.326     0.150
     6.004    90.482     0.150
     6.004   155.365     0.150
     6.053    91.525     0.150
     6.271    94.246     0.150
     6.391    96.225     0.150
     6.391   165.326     0.150
     6.554    97.939     0.150
     6.554   167.953     0.150
     6.687   100.125     0.150
     6.687   172.326     0.150
     6.947   103.826     0.150
     6.947   179.426     0.150
     7.235   107.426     0.150
     7.235   185.426     0.150
     7.511   111.525     0.150
     8.960   131.725     0.150
     8.960   227.426     0.150
     0.812    16.040     0.150
     0.812    28.040     0.150
     1.777    29.040     0.150
     1.777    52.040     0.150
     2.852    80.484     0.150
     3.005    82.861     0.150
     3.528    56.550     0.150
     3.528    96.098     0.150
     3.765   101.740     0.150
     3.890   103.940     0.150
     3.953    62.721     0.150
     3.953   105.708     0.150
     4.051    63.740     0.150
     4.051   109.040     0.150
     4.051    62.749     0.150
     4.051   107.870     0.150
     4.110    64.340     0.150
     4.110   110.540     0.150
     4.151   111.840     0.150
     4.226    66.167     0.150
     4.226   111.927     0.150
     4.342    67.940     0.150
     4.342   115.740     0.150
     4.407    68.940     0.150
     4.407   116.540     0.150
     4.431    68.864     0.150
     4.431   117.348     0.150
     4.555    71.661     0.150
     4.555   120.850     0.150
     4.753    73.440     0.150
     4.753   126.040     0.150
     4.970    76.140     0.150
     4.970   130.540     0.150
     4.971    76.079     0.150
     4.971   129.040     0.150
     5.184   135.640     0.150
     5.530   144.440     0.150
     5.689    86.040     0.150
     5.689   147.040     0.150
     5.775    87.488     0.150
     5.811    88.774     0.150
     5.811   148.969     0.150
     0.425     9.298     0.150
     0.425    15.298     0.150
     0.633    13.298     0.150
     0.633    23.298     0.150
     1.201    23.298     0.150
     1.201    38.298     0.150
     1.388    25.598     0.150
     1.388    44.198     0.150
     1.762    31.798     0.150
     1.986    35.298     0.150
     2.071    36.298     0.150
     2.071    60.298     0.150
     2.644    43.298     0.150
     2.644    74.298     0.150
     4.401    66.552     0.150
     4.401   116.267     0.150
     4.949    75.809     0.150
     4.949   131.120     0.150
     5.316    79.397     0.150
     5.316   138.098     0.150
     5.411    80.598     0.150
     5.411   139.998     0.150
     5.482    81.117     0.150
     5.482   140.799     0.150
     5.579    82.430     0.150
     5.579   144.223     0.150
     5.601    83.198     0.150
     5.601   145.198     0.150
     5.710   148.698     0.150
     5.841    87.098     0.150
     5.841   149.074     0.150
     5.980    90.822     0.150
     5.980   159.249     0.150
     6.003    87.707     0.150
     6.003   153.618     0.150
     6.027    89.397     0.150
     6.027   154.698     0.150
     6.296    93.298     0.150
     6.296   161.198     0.150
     6.556    96.998     0.150
     6.556   167.397     0.150
     6.594    96.356     0.150
     6.594   168.543     0.150
     7.117   181.498     0.150
     7.303   184.646     0.150
     7.308   107.098     0.150
     7.308   185.498     0.150
     7.390   107.188     0.150
     7.390   185.686     0.150
     8.978   128.827     0.150
     8.978   223.688     0.150
     0.896    18.543     0.150
     1.066    21.344     0.150
     1.066    36.641     0.150
     1.683    32.242     0.150
     1.683    52.641     0.150
     2.640    42.961     0.150
     2.640    74.820     0.150
     3.273    51.973     0.150
     3.273    92.352     0.150
     3.758    57.543     0.150
     3.758    98.441     0.150
     3.390    53.941     0.150
     3.813    57.543     0.150
     3.813    99.641     0.150
     3.849    58.281     0.150
     3.849   100.586     0.150
     3.860    58.059     0.150
     3.860   101.852     0.150
     4.066    62.750     0.150
     4.066   106.352     0.150
     4.094   107.844     0.150
     4.094   108.441     0.150
     4.136   107.844     0.150
     4.137    63.941     0.150
     4.137   109.941     0.150
     4.328    65.043     0.150
     4.328   112.441     0.150
     4.363    66.941     0.150
     4.363   113.242     0.150
     4.388   114.742     0.150
     4.746    71.043     0.150
     4.746   122.844     0.150
     4.882    73.102     0.150
     4.882   126.555     0.150
     4.929    74.043     0.150
     4.929   127.242     0.150
     5.118    77.043     0.150
     5.118   131.844     0.150
     5.607    83.043     0.150
     5.607   143.742     0.150
     5.620    82.629     0.150
     5.620   142.059     0.150
     5.807    86.254     0.150
     5.807   148.727     0.150
     6.021   154.141     0.150
     6.064    89.289     0.150
     6.064   154.570     0.150
     7.241   105.684     0.150
     7.241   182.730     0.150
     0.234     4.750     0.150
     0.234     8.148     0.150
     1.795    33.148     0.150
     1.795    56.852     0.150
     2.903    46.977     0.150
     2.903    81.172     0.150
     3.282    55.148     0.150
     3.459    55.602     0.150
     3.459    94.070     0.150
     3.974    61.352     0.150
     4.138    64.750     0.150
     4.138   108.547     0.150
     4.191    65.352     0.150
     4.191   111.445     0.150
     4.216    65.258     0.150
     4.216   111.531     0.150
     4.222    65.617     0.150
     4.222   110.570     0.150
     4.377    67.562     0.150
     4.377   115.945     0.150
     4.492    71.047     0.150
     4.492   122.555     0.150
     4.508    70.250     0.150
     4.508   118.555     0.150
     4.515    69.852     0.150
     4.515   118.547     0.150
     4.689    71.750     0.150
     4.689   124.250     0.150
     4.744    72.445     0.150
     4.744   123.750     0.150
     4.766    71.547     0.150
     4.766   125.750     0.150
     5.125    77.750     0.150
     5.125   134.547     0.150
     5.238    78.992     0.150
     5.238   135.883     0.150
     5.483    83.445     0.150
     5.483   142.047     0.150
     5.896   150.859     0.150
     5.965    89.148     0.150
     5.965   154.148     0.150
     0.083     4.150     0.150
     0.083     6.950     0.150
     0.922    18.940     0.150
     1.007    19.850     0.150
     1.077    21.860     0.150
     1.308    24.950     0.150
     1.366    25.760     0.150
     1.536    27.850     0.150
     1.378    25.550     0.150
     1.378    44.175     0.150
     1.378    25.750     0.150
     1.378    44.850     0.150
     1.778    32.430     0.150
     1.795    32.319     0.150
     1.796    32.940     0.150
     2.213    36.550     0.150
     2.213    66.210     0.150
     2.217    36.550     0.150
     2.217    66.250     0.150
     2.224    36.761     0.150
     2.224    67.551     0.150
     2.224    65.450     0.150
     2.483    38.090     0.150
     2.483    68.410     0.150
     2.730    43.950     0.150
     2.730    76.650     0.150
     3.049    46.860     0.150
     3.049    83.633     0.150
     3.133    49.310     0.150
     3.133    88.690     0.150
     3.374    51.898     0.150
     3.374    91.189     0.150
     3.417    54.158     0.150
     3.736    57.450     0.150
     3.736   101.450     0.150
     3.650    56.830     0.150
     3.833    57.550     0.150
     3.833   100.650     0.150
     3.842    57.308     0.150
     3.842   101.048     0.150
     3.771    99.557     0.150
     3.805    61.890     0.150
     3.870    58.050     0.150
     3.870   100.450     0.150
     3.887    58.358     0.150
     3.887   100.640     0.150
     3.967    59.734     0.150
     3.967   105.120     0.150
     4.089    61.918     0.150
     4.089   107.018     0.150
     4.082    62.950     0.150
     4.201    62.650     0.150
     4.201   108.750     0.150
     4.217    64.450     0.150
     4.217   110.150     0.150
     4.217    64.284     0.150
     4.217   109.550     0.150
     4.245    63.580     0.150
     4.245   110.050     0.150
     4.322    65.250     0.150
     4.322   112.050     0.150
     4.453    66.040     0.150
     4.453   113.220     0.150
     4.453    66.250     0.150
     4.453   115.650     0.150
     4.464   116.450     0.150
     4.463    66.150     0.150
     4.463   115.550     0.150
     4.555    70.070     0.150
     4.555   122.930     0.150
     4.474    66.350     0.150
     4.815    71.150     0.150
     4.815   123.950     0.150
     4.863    71.568     0.150
     4.863   124.660     0.150
     4.962    73.050     0.150
     4.962   127.550     0.150
     4.931    75.318     0.150
     4.931   129.968     0.150
     5.124    75.750     0.150
     5.124   131.450     0.150
     5.413    81.860     0.150
     5.413   142.470     0.150
     5.477    81.368     0.150
     5.477   138.148     0.150
     5.515    80.950     0.150
     5.515   141.550     0.150
     5.594    82.050     0.150
     5.594   142.750     0.150
     5.651    82.700     0.150
     5.651   142.975     0.150
     5.651    82.588     0.150
     5.651   144.563     0.150
     5.720    84.050     0.150
     5.844    85.450     0.150
     5.844   149.350     0.150
     5.844    85.566     0.150
     5.844   148.288     0.150
     5.990    87.560     0.150
     5.990   150.470     0.150
     6.005    87.650     0.150
     6.005   151.850     0.150
     6.070    88.950     0.150
     6.491    94.850     0.150
     6.449    94.080     0.150
     6.553    95.150     0.150
     6.553   166.250     0.150
     6.935   100.650     0.150
     7.160   103.490     0.150
     7.160   181.670     0.150
     7.194   104.050     0.150
     7.194   180.650     0.150
     7.194   180.110     0.150
     7.211   105.838     0.150
     7.211   185.118     0.150
     7.428   107.150     0.150
     7.428   186.250     0.150
     7.539   108.750     0.150
     7.539   189.050     0.150
     7.782   112.050     0.150
     7.782   195.850     0.150
     7.912   113.650     0.150
     7.912   196.750     0.150
     8.069   115.720     0.150
     8.069   201.040     0.150
     8.209   118.250     0.150
     8.560   125.748     0.150
     9.333   132.578     0.150
     9.552   138.070     0.150
    20.360   274.200     0.150
    21.787   293.358     0.150
    39.347   447.147     0.150
    64.514   635.400     0.150
     0.937    19.401     0.150
     0.937    31.511     0.150
     1.474    27.761     0.150
     1.474    47.641     0.150
     2.065    62.574     0.150
     2.069    62.611     0.150
     2.600    41.638     0.150
     2.600    72.400     0.150
     3.072    47.786     0.150
     3.072    84.716     0.150
     3.203    50.290     0.150
     3.203    87.278     0.150
     3.346    92.622     0.150
     3.440    55.100     0.150
     3.440    94.706     0.150
     3.735    65.221     0.150
     4.073    61.400     0.150
     4.073   106.495     0.150
     4.119   108.811     0.150
     4.146    63.911     0.150
     4.146   106.911     0.150
     4.153    63.466     0.150
     4.153   108.370     0.150
     4.131    63.869     0.150
     4.131   109.679     0.150
     4.102    64.465     0.150
     4.205    64.109     0.150
     4.205   111.518     0.150
     4.480   116.311     0.150
     4.559    68.311     0.150
     4.559   118.111     0.150
     4.557   124.850     0.150
     4.733    71.011     0.150
     4.733   122.811     0.150
     4.731   123.411     0.150
     4.758   123.611     0.150
     5.090    76.555     0.150
     5.090   131.326     0.150
     5.223   134.311     0.150
     5.367    80.411     0.150
     5.367   137.611     0.150
     5.590    82.916     0.150
     5.590   142.721     0.150
     5.771    86.111     0.150
     5.771   147.511     0.150
     5.822    86.211     0.150
     5.822   149.311     0.150
     6.230    91.811     0.150
     7.394   107.711     0.150
     7.756   112.911     0.150
     7.756   194.811     0.150
     0.255     6.109     0.150
     1.079    21.984     0.150
     1.079    36.312     0.150
     1.039    20.961     0.150
     1.954    36.344     0.150
     2.490    40.500     0.150
     2.371    40.031     0.150
     2.615    74.586     0.150
     2.889    43.328     0.150
     3.113    84.086     0.150
     3.226    50.281     0.150
     3.226    85.984     0.150
     3.136    48.945     0.150
     3.136    87.797     0.150
     3.509    53.680     0.150
     3.509    93.281     0.150
     3.522    53.508     0.150
     3.522    94.891     0.150
     3.749    57.180     0.150
     3.927    59.680     0.150
     3.927   104.086     0.150
     4.005    61.609     0.150
     4.084    61.180     0.150
     4.074    63.805     0.150
     4.199    63.938     0.150
     4.339    65.633     0.150
     4.339   113.609     0.150
     4.506    67.102     0.150
     4.710    71.141     0.150
     4.710   123.531     0.150
     4.936    73.586     0.150
     5.192    77.383     0.150
     5.224    78.180     0.150
     5.670    82.883     0.150
     5.905    86.297     0.150
     6.148    90.719     0.150
     6.748    98.977     0.150
     6.748   168.336     0.150
     9.897   142.898     0.150
     0.523    10.125     0.150
     0.523    19.250     0.150
     0.671    14.359     0.150
     0.671    24.805     0.150
     1.884    36.211     0.150
     1.884    58.891     0.150
     1.884    33.227     0.150
     1.884    60.219     0.150
     2.081    37.859     0.150
     2.081    65.633     0.150
     2.772    46.664     0.150
     2.772    79.820     0.150
     3.570    57.664     0.150
     3.570   100.023     0.150
     4.220    65.336     0.150
     4.978    74.906     0.150
     4.978   129.109     0.150
     5.023    75.781     0.150
     5.023   128.828     0.150
     5.045    76.344     0.150
     5.045   132.164     0.150
     5.191    78.211     0.150
     5.191   132.805     0.150
     5.216    78.211     0.150
     5.216   135.531     0.150
     5.254    78.648     0.150
     5.254   135.711     0.150
     5.332    80.336     0.150
     5.332   138.930     0.150
     5.487    82.305     0.150
     5.487   142.305     0.150
     5.544    82.789     0.150
     5.544    83.211     0.150
     5.544   143.109     0.150
     5.593   145.508     0.150
     5.697    88.906     0.150
     6.067    90.125     0.150
     6.067   154.398     0.150
     6.103   158.211     0.150
     6.301    93.508     0.150
     6.301   160.211     0.150
     6.720    99.219     0.150
     6.720   171.656     0.150
     6.792   100.305     0.150
     6.792   173.805     0.150
     6.887   101.773     0.150
     6.920   174.875     0.150
     7.206   106.211     0.150
     8.421   122.781     0.150
     0.883    18.758     0.150
     0.883    31.508     0.150
     0.792    16.385     0.150
     1.504    49.959     0.150
     1.838    34.424     0.150
     1.838    58.283     0.150
     1.794    33.111     0.150
     1.794    53.812     0.150
     1.990    35.973     0.150
     1.990    62.289     0.150
     2.450    45.070     0.150
     2.674    48.441     0.150
     2.674    83.180     0.150
     3.107    57.895     0.150
     3.107    94.379     0.150
     3.640    61.010     0.150
     3.640   105.572     0.150
     5.185    77.129     0.150
     5.185   133.330     0.150
     5.271    78.229     0.150
     5.271   135.830     0.150
     5.411    80.529     0.150
     5.411   139.129     0.150
     5.492    80.898     0.150
     5.492    82.330     0.150
     5.492   142.629     0.150
     5.730    84.629     0.150
     5.823    85.080     0.150
     5.823    86.529     0.150
     5.823   150.830     0.150
     6.170    90.729     0.150
     6.170   157.529     0.150
     6.633    97.229     0.150
     6.633   167.830     0.150
     6.971   101.729     0.150
     6.971   178.529     0.150
     7.140   104.330     0.150
     7.140   180.229     0.150
     7.556   110.529     0.150
     8.113   117.830     0.150
     8.796   127.629     0.150
     0.307     7.641     0.150
     0.307    12.227     0.150
     0.451    10.266     0.150
     0.451    15.500     0.150
     0.632    12.641     0.150
     1.272    24.555     0.150
     1.365    25.969     0.150
     1.568    29.258     0.150
     1.942    35.492     0.150
     1.942    59.852     0.150
     2.201    37.258     0.150
     2.217    40.086     0.150
     2.217    65.852     0.150
     2.353    38.594     0.150
     2.431    39.156     0.150
     2.431    68.594     0.150
     2.422    41.492     0.150
     2.761    44.672     0.150
     2.761    79.266     0.150
     2.935    46.094     0.150
     2.935    81.914     0.150
     2.974    51.734     0.150
     2.974    90.555     0.150
     3.230    50.758     0.150
     3.230    89.555     0.150
     3.560    59.500     0.150
     3.680    59.141     0.150
     3.680   102.203     0.150
     3.888    58.320     0.150
     3.888   103.500     0.150
     3.816    61.617     0.150
     3.953    60.742     0.150
     3.953   105.102     0.150
     3.970    60.695     0.150
     3.970   105.273     0.150
     3.966    63.562     0.150
     3.966   110.250     0.150
     4.038    62.055     0.150
     4.038   107.609     0.150
     4.638    71.500     0.150
     4.905   126.312     0.150
     5.272    81.336     0.150
     5.424    80.312     0.150
     5.424   139.805     0.150
     0.336     7.914     0.150
     0.336    14.703     0.150
     1.493    29.992     0.150
     1.682    27.953     0.150
     1.682    48.672     0.150
     1.825    33.727     0.150
     1.849    32.711     0.150
     2.177    64.977     0.150
     2.428    71.766     0.150
     2.487    41.539     0.150
     2.487    74.828     0.150
     3.224    49.688     0.150
     3.224    92.828     0.150
     3.159    97.242     0.150
     3.500    58.859     0.150
     3.500   102.000     0.150
     3.874   106.070     0.150
     4.109    63.180     0.150
     4.275    64.562     0.150
     4.281    63.648     0.150
     4.304    65.891     0.150
     4.397    64.867     0.150
     4.400    65.578     0.150
     4.737    70.375     0.150
     5.292    77.688     0.150
     5.353    78.977     0.150
     0.254     6.203     0.150
     0.254    10.000     0.150
     0.444     9.867     0.150
     0.444    16.586     0.150
     0.471     9.914     0.150
     0.471    16.828     0.150
     0.582    11.703     0.150
     0.582    11.906     0.150
     0.582    20.805     0.150
     0.860    17.984     0.150
     1.343    25.609     0.150
     1.343    43.531     0.150
     1.564    31.086     0.150
     1.668    30.508     0.150
     1.668    51.031     0.150
     1.668    30.281     0.150
     1.727    32.008     0.150
     1.727    54.445     0.150
     1.847    34.117     0.150
     1.847    57.867     0.150
     1.979    34.844     0.150
     1.963    36.953     0.150
     1.963    60.945     0.150
     2.325    39.492     0.150
     2.325    68.617     0.150
     2.421    41.258     0.150
     2.421    71.422     0.150
     2.525    41.609     0.150
     2.525    78.578     0.150
     2.616    44.547     0.150
     2.616    76.797     0.150
     2.586    42.672     0.150
     2.586    77.250     0.150
     2.635    44.305     0.150
     2.635    73.523     0.150
     2.635    44.250     0.150
     2.635    71.703     0.150
     2.665    75.148     0.150
     2.672    75.414     0.150
     2.672    51.422     0.150
     2.672    83.000     0.150
     2.676    44.172     0.150
     2.676    80.016     0.150
     2.766    46.414     0.150
     2.766    85.133     0.150
     3.139    51.273     0.150
     3.139    87.883     0.150
     3.150    50.578     0.150
     3.150    89.922     0.150
     3.192    52.320     0.150
     3.192    87.727     0.150
     3.200    91.852     0.150
     3.289    54.102     0.150
     3.289    95.102     0.150
     3.294    50.664     0.150
     3.294    87.680     0.150
     3.390    55.352     0.150
     3.390    98.680     0.150
     3.520    54.602     0.150
     3.520    93.641     0.150
     3.630    57.352     0.150
     3.630    97.852     0.150
     3.639    57.102     0.150
     3.639    97.852     0.150
     3.650    57.289     0.150
     3.650    98.711     0.150
     3.774    58.594     0.150
     3.774   101.695     0.150
     3.907    61.578     0.150
     3.907   106.953     0.150
     3.960    60.438     0.150
     3.960   110.133     0.150
     4.029    61.906     0.150
     4.029   109.562     0.150
     4.141    65.453     0.150
     4.141   110.922     0.150
     4.160    64.273     0.150
     4.160   114.203     0.150
     4.366    68.180     0.150
     4.366   116.508     0.150
     4.508    70.875     0.150
     4.508   120.906     0.150
     4.569    69.125     0.150
     4.569   124.992     0.150
     4.611    69.852     0.150
     4.611   121.648     0.150
     4.664    70.852     0.150
     4.664   121.055     0.150
     4.678    70.273     0.150
     4.678   121.211     0.150
     4.695    70.711     0.150
     4.695   122.273     0.150
     4.804    72.086     0.150
     4.804   124.992     0.150
     4.801    75.023     0.150
     4.901    74.180     0.150
     4.901   128.250     0.150
     4.940    74.352     0.150
     4.940   128.148     0.150
     4.940   127.484     0.150
     4.940    74.188     0.150
     4.988    74.734     0.150
     4.988   128.172     0.150
     4.988    74.953     0.150
     4.988   129.750     0.150
     4.988    75.352     0.150
     4.988   129.750     0.150
     5.154    77.953     0.150
     5.154   131.953     0.150
     5.214   134.852     0.150
     5.270   138.352     0.150
     5.250    81.969     0.150
     5.250   141.430     0.150
     5.250    82.438     0.150
     5.250   142.898     0.150
     5.444    83.664     0.150
     5.518    83.602     0.150
     5.518   143.500     0.150
     5.598    84.055     0.150
     5.598   144.148     0.150
     5.700    84.719     0.150
     5.700   146.617     0.150
     5.774   148.469     0.150
     5.951    88.453     0.150
     5.951   153.555     0.150
     5.951   151.375     0.150
     6.068    92.445     0.150
     6.288    92.914     0.150
     6.288   160.750     0.150
     6.288    92.727     0.150
     6.288   159.789     0.150
     6.330    93.453     0.150
     6.330   162.148     0.150
     6.400    95.250     0.150
     6.400   163.750     0.150
     6.429    95.055     0.150
     6.429   163.555     0.150
     6.451    95.180     0.150
     6.451   163.953     0.150
     6.451   164.789     0.150
     6.451    95.352     0.150
     6.451   164.219     0.150
     6.453    95.203     0.150
     6.453   165.664     0.150
     6.527    95.422     0.150
     6.527   163.852     0.150
     6.527    96.453     0.150
     6.527   165.648     0.150
     6.506    98.273     0.150
     6.626    98.148     0.150
     6.626   169.852     0.150
     6.626    97.820     0.150
     6.841   100.352     0.150
     6.841   172.953     0.150
     6.888   101.453     0.150
     6.888   174.352     0.150
     7.113   106.484     0.150
     7.113   183.141     0.150
     7.171   106.711     0.150
     7.171   181.492     0.150
     7.313   107.148     0.150
     7.313   185.750     0.150
     7.390   107.852     0.150
     7.390   187.555     0.150
     7.390   186.430     0.150
     7.393   108.289     0.150
     7.393   186.570     0.150
     7.771   113.055     0.150
     7.771   195.852     0.150
     7.727   114.656     0.150
     7.727   196.492     0.150
     7.905   115.844     0.150
     7.905   200.461     0.150
     7.973   118.367     0.150
     7.973   203.203     0.150
     8.035   116.555     0.150
     8.035   202.055     0.150
     8.035   200.844     0.150
     8.267   120.055     0.150
     8.267   206.250     0.150
     8.348   121.555     0.150
     8.348   209.953     0.150
     8.378   121.750     0.150
     8.378   209.250     0.150
     8.624   125.055     0.150
     8.624   216.250     0.150
     8.749   126.953     0.150
     8.749   218.648     0.150
     8.758   127.133     0.150
     8.758   218.836     0.150
     8.792   128.758     0.150
     8.907   128.656     0.150
     8.907   221.828     0.150
     9.046   130.750     0.150
     9.046   225.852     0.150
     9.058   132.570     0.150
     9.320   134.836     0.150
     9.320   231.664     0.150
     9.812   141.289     0.150
     9.812   243.453     0.150
     9.874   144.500     0.150
     9.979   144.352     0.150
     9.979   249.250     0.150
     9.979   143.680     0.150
    10.016   144.281     0.150
    10.016   248.945     0.150
    10.026   145.359     0.150
    10.026   250.578     0.150
    10.079   146.781     0.150
    10.144   145.656     0.150
    10.144   252.391     0.150
    10.174   146.133     0.150
    10.174   253.062     0.150
    10.241   253.352     0.150
    10.276   254.852     0.150
    10.315   150.352     0.150
    10.315   259.000     0.150
    10.318   149.914     0.150
    10.378   151.023     0.150
    10.378   258.766     0.150
    10.625   262.852     0.150
    12.129   173.977     0.150
    12.485   176.555     0.150
    13.995   200.469     0.150
    17.644   246.953     0.150
    18.606   260.109     0.150
    18.639   260.961     0.150
    20.325   281.492     0.150
    20.593   278.422     0.150
    20.932   283.125     0.150
    20.937   282.883     0.150
    20.956   285.172     0.150
    20.956   283.930     0.150
    21.066   285.211     0.150
    21.066   284.750     0.150
    21.502   290.031     0.150
    22.106   297.148     0.150
    23.212   308.555     0.150
    26.469   337.930     0.150
    26.715   339.750     0.150
    31.582   386.141     0.150
    34.570   408.633     0.150
    38.628   444.453     0.150
    55.711   576.922     0.150
    63.439   634.852     0.150
    63.798   633.328     0.150
    64.949   642.219     0.150
    64.964   642.102     0.150
    69.305   668.195     0.150
    69.664   672.250     0.150
    76.876   717.008     0.150
    77.819   720.430     0.150
    84.236   943.648     0.150
    85.927   759.953     0.150
     0.234     6.012     0.150
     0.234     9.684     0.150
     0.417     9.496     0.150
     0.417    15.133     0.150
     0.486    10.012     0.150
     0.486    16.988     0.150
     0.594    12.059     0.150
     0.594    20.770     0.150
     0.840    18.035     0.150
     1.353    26.234     0.150
     1.353    44.680     0.150
     1.555    29.992     0.150
     1.670    54.246     0.150
     1.588    30.676     0.150
     1.588    52.023     0.150
     1.710    31.871     0.150
     1.825    34.434     0.150
     1.992    34.613     0.150
     1.992    63.023     0.150
     1.992    62.441     0.150
     1.981    36.141     0.150
     1.981    63.125     0.150
     2.121    37.691     0.150
     2.301    39.387     0.150
     2.398    40.922     0.150
     2.546    43.996     0.150
     2.546    79.695     0.150
     2.558    42.801     0.150
     2.558    81.402     0.150
     2.612    43.910     0.150
     2.794    46.512     0.150
     2.794    86.184     0.150
     3.111    50.504     0.150
     3.111    86.059     0.150
     3.169    49.582     0.150
     3.169    85.656     0.150
     3.176    50.660     0.150
     3.266    53.391     0.150
     3.266    91.203     0.150
     3.269    50.391     0.150
     3.269    86.758     0.150
     3.385    54.758     0.150
     3.494    55.812     0.150
     3.494    94.512     0.150
     3.615    57.633     0.150
     3.615    98.492     0.150
     3.628    56.781     0.150
     3.628    96.055     0.150
     3.747    58.137     0.150
     3.747   101.586     0.150
     3.881    60.512     0.150
     3.881   105.145     0.150
     4.001    61.867     0.150
     4.001   109.156     0.150
     3.987    60.734     0.150
     4.113    66.148     0.150
     4.182    65.859     0.150
     4.545    69.957     0.150
     4.596    69.621     0.150
     4.596   120.723     0.150
     4.648    70.523     0.150
     4.648   120.820     0.150
     4.658    70.090     0.150
     4.658   119.387     0.150
     4.678    70.551     0.150
     4.678   120.633     0.150
     4.780    72.750     0.150
     4.780   123.734     0.150
     4.774    74.566     0.150
     4.774   127.684     0.150
     4.876    73.879     0.150
     4.876   127.785     0.150
     4.929    74.320     0.150
     4.929   128.320     0.150
     4.973   129.121     0.150
     4.975    74.434     0.150
     4.975   128.344     0.150
     4.975    74.621     0.150
     4.975   129.621     0.150
     5.135    77.820     0.150
     5.135   132.023     0.150
     5.201    78.023     0.150
     5.201   135.023     0.150
     5.223    82.426     0.150
     5.253   138.023     0.150
     5.583    83.820     0.150
     5.583   143.023     0.150
     5.680    84.852     0.150
     5.680   146.121     0.150
     5.757   149.621     0.150
     5.932    88.223     0.150
     5.932   152.223     0.150
     5.932    88.574     0.150
     6.040    92.742     0.150
     6.262    92.012     0.150
     6.262   159.406     0.150
     6.312    93.223     0.150
     6.312   161.723     0.150
     6.409    95.023     0.150
     6.409   162.320     0.150
     6.424    95.086     0.150
     6.424   164.609     0.150
     6.611    97.523     0.150
     6.611   170.023     0.150
     6.821   100.422     0.150
     6.821   172.121     0.150
     7.370   108.023     0.150
     7.370   187.523     0.150
     7.751   194.723     0.150
     7.878   115.777     0.150
     7.878   200.758     0.150
     8.014   117.023     0.150
     8.014   201.320     0.150
     8.247   120.121     0.150
     8.247   207.621     0.150
     8.357   121.523     0.150
     8.357   209.320     0.150
     8.602   124.820     0.150
     8.602   215.820     0.150
     8.729   126.523     0.150
     8.729   126.820     0.150
     8.729   218.422     0.150
     8.729   219.023     0.150
     8.736   126.645     0.150
     8.736   218.258     0.150
     8.887   128.168     0.150
     8.887   220.984     0.150
     9.026   130.621     0.150
     9.026   226.023     0.150
     0.479    10.145     0.150
     0.479    17.016     0.150
     0.791    17.375     0.150
     0.933    17.738     0.150
     0.933    31.477     0.150
     1.058    22.438     0.150
     1.269    25.691     0.150
     1.447    26.414     0.150
     1.531    27.137     0.150
     1.531    48.105     0.150
     1.525    28.223     0.150
     1.525    48.828     0.150
     1.557    28.945     0.150
     1.557    49.914     0.150
     1.530    49.914     0.150
     1.684    30.754     0.150
     1.684    56.059     0.150
     3.472    59.676     0.150
     3.472   107.398     0.150
     3.976    65.098     0.150
     4.043    61.328     0.150
     4.043   105.129     0.150
     4.047    60.730     0.150
     4.047   104.930     0.150
     4.384    66.328     0.150
     4.384   112.930     0.150
     4.999    74.730     0.150
     4.999   128.629     0.150
     5.583    83.531     0.150
     5.599    83.828     0.150
     0.607    13.070     0.150
     0.607    20.270     0.150
     1.318    25.355     0.150
     1.318    43.182     0.150
     1.820    32.930     0.150
     1.820    33.568     0.150
     1.820    52.348     0.150
     2.040    39.301     0.150
     2.040    64.811     0.150
     2.205    41.850     0.150
     2.376    41.152     0.150
     2.456    38.990     0.150
     2.456    68.941     0.150
     2.483    44.730     0.150
     2.683    43.561     0.150
     2.683    75.791     0.150
     2.817    45.730     0.150
     2.817    89.730     0.150
     2.852    46.338     0.150
     2.852    77.928     0.150
     2.959    47.738     0.150
     2.959    82.676     0.150
     3.074    51.100     0.150
     3.074    84.490     0.150
     3.253    51.549     0.150
     3.253    89.094     0.150
     3.327    54.174     0.150
     3.327    91.359     0.150
     3.705    60.348     0.150
     3.910    59.893     0.150
     3.910   102.117     0.150
     3.958    60.730     0.150
     3.958   104.631     0.150
     3.984    60.930     0.150
     3.984   104.830     0.150
     3.990    61.049     0.150
     3.990   103.391     0.150
     3.978    60.861     0.150
     3.978   105.490     0.150
     3.991    64.809     0.150
     3.991   108.426     0.150
     4.063    62.643     0.150
     4.063   107.879     0.150
     4.319    66.430     0.150
     4.319   113.531     0.150
     4.367    67.430     0.150
     4.367   116.531     0.150
     4.367    65.951     0.150
     4.367   113.451     0.150
     4.387    67.150     0.150
     4.387    68.230     0.150
     4.387   115.131     0.150
     4.453    71.824     0.150
     4.568    70.131     0.150
     4.568   120.631     0.150
     4.600   120.430     0.150
     4.790    76.262     0.150
     4.790   124.770     0.150
     4.934    75.031     0.150
     4.934   128.031     0.150
     4.927    74.520     0.150
     4.927   127.559     0.150
     5.204    78.330     0.150
     5.204   135.531     0.150
     5.295    82.549     0.150
     5.295   140.721     0.150
     5.449    81.400     0.150
     5.449   141.486     0.150
     5.608    83.631     0.150
     5.608   145.230     0.150
     5.612    83.855     0.150
     5.612   146.242     0.150
     5.612   144.512     0.150
     5.660    84.531     0.150
     5.660   145.930     0.150
     5.820    86.180     0.150
     5.963    89.830     0.150
     5.963    88.768     0.150
     6.068    89.930     0.150
     6.068   156.031     0.150
     6.159    91.430     0.150
     6.159   157.631     0.150
     6.576    97.230     0.150
     6.555    96.707     0.150
     6.612    97.631     0.150
     6.612   171.031     0.150
     6.999   102.531     0.150
     6.999   178.930     0.150
     7.084   104.865     0.150
     7.234   106.330     0.150
     7.234   182.430     0.150
     7.234   105.635     0.150
     7.234   182.037     0.150
     7.193   107.281     0.150
     7.592   110.930     0.150
     7.595   111.031     0.150
     7.595   192.730     0.150
     7.813   113.730     0.150
     7.813   198.031     0.150
     7.946   115.809     0.150
     7.969   116.031     0.150
     7.969   200.830     0.150
     8.021   119.838     0.150
     8.126   118.309     0.150
     8.269   120.430     0.150
     9.426   139.730     0.150
     9.426   231.230     0.150
     9.539   140.297     0.150
     9.823   144.830     0.150
     9.823   240.631     0.150
     9.970   146.434     0.150
    20.222   274.330     0.150
    21.723   293.338     0.150
     0.408     9.006     0.150
     0.587    12.404     0.150
     0.587    19.693     0.150
     1.069    22.102     0.150
     1.066    21.287     0.150
     1.228    23.773     0.150
     1.228    40.184     0.150
     1.299    24.744     0.150
     1.299    42.555     0.150
     1.299    42.180     0.150
     1.584    28.877     0.150
     1.584    47.918     0.150
     1.629    29.576     0.150
     1.817    34.514     0.150
     1.839    33.445     0.150
     1.839    56.941     0.150
     1.839    32.504     0.150
     1.839    60.803     0.150
     1.993    32.275     0.150
     1.993    57.510     0.150
     2.197    41.145     0.150
     2.197    37.557     0.150
     2.396    40.543     0.150
     2.396    66.707     0.150
     2.377    41.037     0.150
     2.476    39.898     0.150
     2.476    71.188     0.150
     2.703    42.383     0.150
     2.703    76.594     0.150
     2.718    44.867     0.150
     2.718    77.865     0.150
     2.836    45.014     0.150
     2.871    45.695     0.150
     2.871    78.852     0.150
     2.947    48.143     0.150
     2.978    46.646     0.150
     2.978    83.516     0.150
     3.093    49.842     0.150
     3.093    87.543     0.150
     3.271    51.752     0.150
     3.271    89.404     0.150
     3.346    53.324     0.150
     3.346    94.160     0.150
     3.518    56.314     0.150
     3.759    57.271     0.150
     3.660    57.346     0.150
     3.660   102.061     0.150
     3.928    58.678     0.150
     3.974    60.113     0.150
     3.974   103.914     0.150
     4.000    60.414     0.150
     4.000   104.014     0.150
     4.007    60.193     0.150
     4.007   102.697     0.150
     3.997    60.021     0.150
     3.997   105.199     0.150
     4.009    63.857     0.150
     4.083    62.057     0.150
     4.083   108.248     0.150
     4.334    65.914     0.150
     4.334   112.713     0.150
     4.380    66.814     0.150
     4.380   116.213     0.150
     4.380    65.512     0.150
     4.380   115.150     0.150
     4.401    65.713     0.150
     4.401   114.613     0.150
     4.414    67.113     0.150
     4.471    70.957     0.150
     4.471   120.414     0.150
     4.471    70.027     0.150
     4.584   119.514     0.150
     4.614   119.713     0.150
     4.602    68.674     0.150
     4.806    74.787     0.150
     4.950    74.213     0.150
     4.950   127.713     0.150
     4.946    73.311     0.150
     4.946   124.104     0.150
     5.221    77.613     0.150
     5.221   134.713     0.150
     5.313    81.080     0.150
     5.313   139.600     0.150
     5.469    80.295     0.150
     5.469   141.137     0.150
     5.625    83.014     0.150
     5.625   144.613     0.150
     5.632    83.074     0.150
     5.632    83.451     0.150
     5.632   143.732     0.150
     5.678    83.914     0.150
     5.678   146.914     0.150
     6.087    89.414     0.150
     6.087   152.914     0.150
     6.176    90.514     0.150
     6.176   157.814     0.150
     6.354    95.070     0.150
     6.593    96.514     0.150
     6.630    96.414     0.150
     7.017   101.414     0.150
     7.103   104.145     0.150
     7.254   105.314     0.150
     7.254   182.314     0.150
     7.254   105.164     0.150
     7.502   109.014     0.150
     7.502   188.314     0.150
     7.613   110.414     0.150
     7.613   191.713     0.150
     7.832   113.213     0.150
     7.987   115.713     0.150
     8.039   119.021     0.150
     8.144   117.719     0.150
     8.288   119.914     0.150
    20.238   273.891     0.150
     0.397     8.695     0.150
     0.321     8.039     0.150
     0.321    12.902     0.150
     0.584    12.102     0.150
     0.584    19.625     0.150
     1.087    21.855     0.150
     1.087    36.047     0.150
     1.399    26.273     0.150
     1.217    23.762     0.150
     1.217    40.836     0.150
     1.286    24.656     0.150
     1.286    42.516     0.150
     1.641    29.652     0.150
     1.641    52.980     0.150
     1.559    30.109     0.150
     1.976    32.426     0.150
     1.851    34.352     0.150
     2.211    40.574     0.150
     2.483    39.965     0.150
     2.483    68.547     0.150
     2.368    41.809     0.150
     2.368    72.648     0.150
     2.708    44.574     0.150
     2.708    76.703     0.150
     2.706    46.668     0.150
     2.847    46.953     0.150
     2.979    47.477     0.150
     2.979    83.367     0.150
     3.098    49.898     0.150
     3.098    88.641     0.150
     3.269    90.934     0.150
     3.347    53.727     0.150
     3.640    57.609     0.150
     3.518    56.609     0.150
     3.518   105.836     0.150
     4.011    64.434     0.150
     4.011   109.516     0.150
     3.942    60.352     0.150
     3.942   102.203     0.150
     3.785    61.727     0.150
     4.007    61.918     0.150
     4.007   104.922     0.150
     4.090    62.902     0.150
     4.090   110.258     0.150
     3.991    59.953     0.150
     3.991   104.555     0.150
     4.023    61.492     0.150
     4.023   104.406     0.150
     4.017    60.254     0.150
     4.017   104.055     0.150
     4.471    71.164     0.150
     4.352    65.852     0.150
     4.352   112.754     0.150
     4.399    67.152     0.150
     4.399   116.953     0.150
     4.419    67.652     0.150
     4.419   114.453     0.150
     4.601   119.754     0.150
     4.633    70.555     0.150
     4.633   119.754     0.150
     4.605    70.219     0.150
     4.960    74.199     0.150
     4.960   128.188     0.150
     4.968    74.352     0.150
     4.968   128.152     0.150
     5.311    81.996     0.150
     5.237    77.754     0.150
     5.237   135.754     0.150
     5.476    80.895     0.150
     5.476   140.707     0.150
     5.641    83.055     0.150
     5.641   144.652     0.150
     5.692    83.953     0.150
     5.692   145.852     0.150
     6.101    89.453     0.150
     6.101   152.254     0.150
     7.266   105.352     0.150
     7.627   110.453     0.150
     0.413    10.186     0.150
     0.579    11.623     0.150
     1.050    22.258     0.150
     1.231    42.240     0.150
     1.997    35.059     0.150
     1.997    59.488     0.150
     2.023    32.703     0.150
     2.023    58.377     0.150
     2.168    41.193     0.150
     2.480    69.477     0.150
     2.920    56.498     0.150
     2.991    83.023     0.150
     3.288    92.098     0.150
     3.503    63.104     0.150
     3.503   108.641     0.150
     3.685    59.432     0.150
     3.685   102.623     0.150
     3.758    64.342     0.150
     3.758   111.637     0.150
     3.920    59.824     0.150
     3.920   104.980     0.150
     3.993    61.152     0.150
     3.993   104.072     0.150
     3.997    61.529     0.150
     3.997   107.186     0.150
     4.023    64.430     0.150
     4.023   111.506     0.150
     4.087    64.391     0.150
     4.087   110.703     0.150
     4.938    73.662     0.150
     5.330    81.650     0.150
     5.474   141.658     0.150
     0.835    15.980     0.150
     0.835    28.047     0.150
     0.754    15.539     0.150
     0.754    26.660     0.150
     1.248    23.898     0.150
     1.248    40.078     0.150
     1.495    26.406     0.150
     1.495    45.812     0.150
     1.477    27.699     0.150
     1.477    46.977     0.150
     1.388    46.887     0.150
     1.762    32.449     0.150
     1.762    56.184     0.150
     1.898    34.828     0.150
     1.898    56.488     0.150
     1.898    32.488     0.150
     1.898    57.016     0.150
     2.043    35.336     0.150
     2.043    62.039     0.150
     2.300    36.812     0.150
     2.300    65.492     0.150
     2.582    43.301     0.150
     2.582    77.453     0.150
     3.070    47.637     0.150
     3.070    84.863     0.150
     3.178    51.246     0.150
     3.178    89.664     0.150
     3.589    58.176     0.150
     3.589   103.273     0.150
     5.406    79.367     0.150
     5.406   138.070     0.150
     5.468    80.367     0.150
     5.468   138.215     0.150
     5.545   144.270     0.150
     5.545   141.270     0.150
     5.536    80.945     0.150
     5.536   141.324     0.150
     5.712    84.168     0.150
     5.712   146.570     0.150
     5.758    84.527     0.150
     5.758   145.676     0.150
     5.864    87.270     0.150
     5.864   149.969     0.150
     5.898    86.477     0.150
     5.898   150.297     0.150
     6.305    91.867     0.150
     6.305   160.770     0.150
     6.556    95.559     0.150
     6.556   164.711     0.150
     6.768    98.570     0.150
     6.768   171.070     0.150
     7.107   102.867     0.150
     7.274   105.168     0.150
     7.274   182.570     0.150
     7.286   182.660     0.150
     8.929   128.270     0.150
     8.929   127.793     0.150
     0.994    21.079     0.150
     0.994    34.462     0.150
     1.045    20.740     0.150
     1.045    33.953     0.150
     1.250    25.740     0.150
     1.250    43.120     0.150
     1.291    26.641     0.150
     1.291    43.609     0.150
     1.330    26.500     0.150
     1.330    45.474     0.150
     1.425    26.958     0.150
     1.484    26.958     0.150
     1.484    51.116     0.150
     1.599    30.904     0.150
     1.599    52.926     0.150
     2.052    36.253     0.150
     2.052    64.431     0.150
     2.390    42.137     0.150
     2.390    70.934     0.150
     2.450    40.898     0.150
     2.450    75.269     0.150
     2.656    45.233     0.150
     2.656    79.604     0.150
     2.855    79.340     0.150
     3.014    48.560     0.150
     3.014    82.490     0.150
     3.112    50.229     0.150
     3.112    86.326     0.150
     3.275    53.660     0.150
     3.275    89.891     0.150
     3.794    62.264     0.150
     3.920    62.882     0.150
     3.978    64.249     0.150
     3.978   108.388     0.150
     4.448    69.101     0.150
     4.448   118.250     0.150
     4.605    70.889     0.150
     4.605   120.788     0.150
     4.807    73.920     0.150
     4.807   125.730     0.150
     4.837    74.590     0.150
     4.837   127.690     0.150
     4.846    74.790     0.150
     4.846   128.391     0.150
     5.179    78.790     0.150
     5.179   136.090     0.150
     5.588   145.730     0.150
     5.792   150.990     0.150
     5.841    88.190     0.150
     5.841   152.090     0.150
     0.662    14.332     0.150
     0.662    24.539     0.150
     0.661    14.332     0.150
     0.661    23.883     0.150
     0.728    15.648     0.150
     0.728    27.184     0.150
     0.782    16.309     0.150
     0.782    27.504     0.150
     1.110    21.723     0.150
     1.110    37.613     0.150
     1.327    26.188     0.150
     1.327    44.305     0.150
     1.503    29.152     0.150
     1.503    48.883     0.150
     1.365    26.848     0.150
     1.365    45.945     0.150
     1.933    37.387     0.150
     2.167    40.680     0.150
     2.167    68.324     0.150
     2.423    45.621     0.150
     2.487    44.961     0.150
     2.487    77.242     0.150
     2.470    73.742     0.150
     2.683    46.609     0.150
     2.683    82.508     0.150
     2.855    86.133     0.150
     3.025    51.879     0.150
     3.004    49.242     0.150
     3.004    84.816     0.150
     3.243    53.855     0.150
     3.243    95.027     0.150
     3.408    59.125     0.150
     3.408   100.625     0.150
     3.414    57.148     0.150
     3.462    57.809     0.150
     3.462   100.953     0.150
     3.690   105.238     0.150
     4.163    63.156     0.150
     4.163   110.934     0.150
     5.266    78.621     0.150
     5.266   135.824     0.150
     5.345    79.723     0.150
     5.345   137.223     0.150
     5.345    80.203     0.150
     5.417    80.863     0.150
     5.449    81.215     0.150
     5.449   138.879     0.150
     5.512    82.621     0.150
     5.512   143.023     0.150
     5.587    83.121     0.150
     5.655    84.324     0.150
     5.655   145.223     0.150
     5.684    87.668     0.150
     5.684   152.461     0.150
     5.770    86.551     0.150
     5.770   149.039     0.150
     5.823    86.621     0.150
     5.904    87.434     0.150
     5.904    87.621     0.150
     5.904   151.723     0.150
     5.911    87.922     0.150
     6.253    92.023     0.150
     6.253   160.223     0.150
     7.040   102.922     0.150
     7.040   179.324     0.150
     7.158   104.773     0.150
     7.158   180.824     0.150
     7.192   105.422     0.150
     7.192   182.523     0.150
     7.607   111.422     0.150
     7.607   192.621     0.150
     7.655   111.605     0.150
     7.655   193.254     0.150
     8.162   118.922     0.150
     8.835   128.324     0.150
     8.835   127.824     0.150
     9.153   132.523     0.150
     9.437   136.422     0.150
     9.572   138.074     0.150
     9.572   240.133     0.150
     9.679   138.840     0.150
     9.813   142.223     0.150
     0.799    16.586     0.150
     0.799    29.109     0.150
     1.071    21.109     0.150
     1.071    37.109     0.150
     1.105    21.461     0.150
     1.105    37.109     0.150
     1.170    22.156     0.150
     1.170    39.547     0.150
     1.476    28.062     0.150
     1.509    27.367     0.150
     1.509    47.195     0.150
     1.502    29.109     0.150
     1.714    30.852     0.150
     1.855    34.672     0.150
     2.035    37.109     0.150
     2.733    45.453     0.150
     2.733    81.281     0.150
     2.801    48.242     0.150
     2.801    82.328     0.150
     2.842    46.500     0.150
     3.262    95.891     0.150
     3.304    95.891     0.150
     3.447    54.500     0.150
     3.801    60.758     0.150
     3.801   108.758     0.150
     5.403    79.023     0.150
     5.403   135.922     0.150
     5.499    80.023     0.150
     5.499   139.125     0.150
     5.594    81.922     0.150
     5.594   142.227     0.150
     5.594   140.758     0.150
     5.668    81.461     0.150
     5.668   142.930     0.150
     5.685    82.508     0.150
     5.685   144.828     0.150
     5.797   146.828     0.150
     6.041    87.477     0.150
     6.041    88.023     0.150
     6.041   153.125     0.150
     6.091    87.391     0.150
     6.091   154.273     0.150
     6.382    92.125     0.150
     6.382   160.727     0.150
     7.205   182.523     0.150
     7.397   106.422     0.150
     7.397   184.328     0.150
     0.352     7.105     0.150
     0.352    11.770     0.150
     0.927    18.477     0.150
     0.927    30.844     0.150
     1.589    28.488     0.150
     1.532    30.203     0.150
     1.532    50.910     0.150
     1.630    31.383     0.150
     1.630    55.227     0.150
     2.205    41.055     0.150
     2.205    68.902     0.150
     2.182    38.770     0.150
     2.304    44.168     0.150
     2.352    42.770     0.150
     2.352    75.664     0.150
     6.095    91.547     0.150
     6.095   157.047     0.150
     6.175    92.648     0.150
     6.175   158.547     0.150
     6.223    93.848     0.150
     6.223   161.648     0.150
     6.438    96.648     0.150
     6.438   165.750     0.150
     6.469    96.648     0.150
     6.668   100.148     0.150
     6.668   171.750     0.150
     6.982   103.750     0.150
     6.982   178.949     0.150
     7.878   116.348     0.150
     7.943   118.547     0.150
     8.163   119.547     0.150
     0.084     2.812     0.150
     0.084     5.172     0.150
     0.641    12.961     0.150
     0.641    22.789     0.150
     1.031    38.391     0.150
     1.383    27.039     0.150
     1.383    45.438     0.150
     1.323    27.320     0.150
     1.323    45.953     0.150
     1.815    32.484     0.150
     1.815    55.883     0.150
     1.769    33.453     0.150
     1.883    35.648     0.150
     2.416    43.852     0.150
     2.416    74.758     0.150
     2.575    45.617     0.150
     2.575    79.586     0.150
     2.470    42.516     0.150
     2.470    72.211     0.150
     2.599    47.125     0.150
     2.599    79.977     0.150
     2.985    48.859     0.150
     2.985    85.219     0.150
     3.394    54.867     0.150
     3.394    96.984     0.150
     3.790    60.305     0.150
     3.790   106.000     0.150
     4.745   124.359     0.150
     4.842    73.664     0.150
     4.842   125.695     0.150
     5.053   132.359     0.150
     5.053    77.484     0.150
     5.053   131.188     0.150
     5.108   133.359     0.150
     5.093    77.914     0.150
     5.093   132.422     0.150
     5.126   133.953     0.150
     5.337   139.258     0.150
     5.377   139.555     0.150
     5.733   148.656     0.150
     6.479   167.258     0.150
     6.480   163.875     0.150
     7.010   103.734     0.150
     7.010   177.234     0.150
     0.191     3.938     0.150
     0.191     7.906     0.150
     0.546    10.891     0.150
     1.094    21.812     0.150
     1.094    38.039     0.150
     1.504    28.438     0.150
     1.504    48.305     0.150
     1.634    30.758     0.150
     1.634    52.938     0.150
     1.855    58.898     0.150
     1.924    34.062     0.150
     1.924    60.555     0.150
     2.053    36.055     0.150
     2.053    65.188     0.150
     2.160    61.531     0.150
     2.347    42.344     0.150
     2.347    67.836     0.150
     2.980    47.406     0.150
     2.980    82.211     0.150
     3.078    49.625     0.150
     3.078    86.703     0.150
     3.412    52.648     0.150
     3.412    91.352     0.150
     3.384    52.602     0.150
     3.384    93.992     0.150
     3.517    55.352     0.150
     3.517    93.750     0.150
     3.601    55.648     0.150
     3.601    96.617     0.150
     3.764    58.898     0.150
     3.764   103.258     0.150
     3.766    58.430     0.150
     3.766   100.695     0.150
     3.808   101.453     0.150
     4.189    63.906     0.150
     4.189   110.734     0.150
     4.389    65.953     0.150
     4.389   114.852     0.150
     4.484    68.320     0.150
     4.484   118.188     0.150
     4.773    73.047     0.150
     4.773   125.320     0.150
     5.226   135.852     0.150
     5.281    79.727     0.150
     5.459    81.250     0.150
     5.459   141.453     0.150
     5.835   149.656     0.150
     6.075    89.953     0.150
     6.075   155.648     0.150
     6.193    92.250     0.150
     7.166   104.391     0.150
     0.476    10.756     0.150
     0.476    17.423     0.150
     0.807    16.526     0.150
     0.807    27.404     0.150
     1.050    19.999     0.150
     1.050    36.832     0.150
     1.164    23.331     0.150
     1.164    39.472     0.150
     1.133    23.907     0.150
     1.133    39.310     0.150
     1.236    24.632     0.150
     1.304    25.862     0.150
     1.304    43.447     0.150
     1.359    27.165     0.150
     1.359    46.013     0.150
     1.815    31.562     0.150
     1.815    55.071     0.150
     2.032    37.196     0.150
     2.032    62.810     0.150
     2.537    46.016     0.150
     2.537    76.893     0.150
     2.770    45.821     0.150
     2.770    81.609     0.150
     3.136    54.777     0.150
     3.136    95.831     0.150
     3.564    56.665     0.150
     3.564    99.472     0.150
     3.672    60.430     0.150
     3.688   104.806     0.150
     4.322    68.154     0.150
     4.322   120.084     0.150
     4.778    74.108     0.150
     4.778   129.444     0.150
     4.783    74.168     0.150
     4.783   130.309     0.150
     0.542    11.464     0.150
     0.542    20.125     0.150
     0.730    16.023     0.150
     0.730    25.344     0.150
     0.819    27.628     0.150
     1.008    20.573     0.150
     1.008    33.081     0.150
     1.129    23.189     0.150
     1.144    23.607     0.150
     1.144    38.852     0.150
     1.251    45.076     0.150
     1.382    47.981     0.150
     1.432    27.295     0.150
     1.536    51.001     0.150
     1.710    32.492     0.150
     1.710    54.772     0.150
     1.737    30.605     0.150
     1.768    31.810     0.150
     1.768    55.900     0.150
     1.779    55.597     0.150
     1.779    54.968     0.150
     1.758    32.942     0.150
     1.758    56.414     0.150
     1.959    36.750     0.150
     2.162    64.468     0.150
     2.309    38.012     0.150
     2.309    68.397     0.150
     2.550    45.702     0.150
     2.550    79.514     0.150
     2.526    45.145     0.150
     2.526    78.760     0.150
     2.891    47.777     0.150
     2.891    83.330     0.150
     2.838    86.951     0.150
     3.020    48.726     0.150
     3.020    86.716     0.150
     3.117    51.155     0.150
     3.117    88.871     0.150
     3.220    57.734     0.150
     3.220   100.145     0.150
     3.384    54.575     0.150
     3.384    94.005     0.150
     3.487    97.688     0.150
     3.617   102.218     0.150
     3.566    59.795     0.150
     3.566   104.354     0.150
     3.764    64.495     0.150
     3.764   113.159     0.150
     3.778    60.678     0.150
     3.778   105.577     0.150
     3.860    59.936     0.150
     3.860   104.893     0.150
     3.861    61.256     0.150
     3.909    61.546     0.150
     3.909   107.234     0.150
     3.983    60.848     0.150
     3.983   104.447     0.150
     3.984    61.298     0.150
     3.994    60.747     0.150
     3.994   104.647     0.150
     4.231    66.667     0.150
     4.231   116.088     0.150
     4.231    67.590     0.150
     4.231   118.795     0.150
     4.332    65.947     0.150
     4.428    67.747     0.150
     4.428    66.928     0.150
     4.435    67.447     0.150
     4.435   116.348     0.150
     4.543    70.025     0.150
     4.543   122.756     0.150
     4.867    76.799     0.150
     4.867   134.845     0.150
     4.870    77.033     0.150
     4.948    74.447     0.150
     4.948   129.247     0.150
     5.062    78.048     0.150
     5.062   135.518     0.150
     5.291    80.646     0.150
     5.291   140.216     0.150
     5.585    84.247     0.150
     5.585   144.947     0.150
     5.603    84.147     0.150
     5.603   145.747     0.150
     5.907    88.237     0.150
     6.881   102.737     0.150
     9.020   132.088     0.150
     9.292   135.827     0.150
     0.788    16.117     0.150
     0.768    16.492     0.150
     0.768    27.111     0.150
     1.011    37.469     0.150
     1.198    25.127     0.150
     1.198    40.916     0.150
     1.106    40.643     0.150
     1.209    24.574     0.150
     1.209    43.895     0.150
     1.349    26.656     0.150
     1.349    46.500     0.150
     1.403    27.365     0.150
     1.403    48.455     0.150
     1.810    32.416     0.150
     1.810    54.873     0.150
     1.838    58.000     0.150
     2.017    36.660     0.150
     2.017    63.438     0.150
     2.340    38.332     0.150
     2.340    68.172     0.150
     2.556    46.150     0.150
     2.556    78.010     0.150
     2.514    46.301     0.150
     2.514    78.230     0.150
     2.814    49.516     0.150
     2.814    85.656     0.150
     3.072    87.500     0.150
     3.164    51.699     0.150
     3.164    88.959     0.150
     3.440    55.789     0.150
     3.712    64.648     0.150
     3.712   113.070     0.150
     3.826    60.912     0.150
     3.826   104.332     0.150
     3.886    60.762     0.150
     3.886   104.832     0.150
     3.869    59.629     0.150
     3.869   102.059     0.150
     3.942    61.789     0.150
     3.942   105.840     0.150
     3.983    60.891     0.150
     3.983   104.932     0.150
     4.281    67.611     0.150
     4.281   116.371     0.150
     4.979   131.922     0.150
     5.326   139.750     0.150
     0.504    10.172     0.150
     0.504    18.793     0.150
     0.742    14.395     0.150
     0.742    15.914     0.150
     0.742    26.254     0.150
     0.779    14.531     0.150
     1.061    19.254     0.150
     1.050    21.664     0.150
     1.050    35.695     0.150
     1.154    21.793     0.150
     1.154    38.840     0.150
     1.173    23.375     0.150
     1.219    22.242     0.150
     1.307    24.484     0.150
     1.359    25.379     0.150
     1.763    29.195     0.150
     1.763    54.148     0.150
     1.786    29.953     0.150
     1.786    49.945     0.150
     1.841    55.672     0.150
     1.841    53.953     0.150
     2.004    32.559     0.150
     2.383    37.863     0.150
     2.383    66.695     0.150
     2.968    46.746     0.150
     2.968    82.520     0.150
     3.096    49.160     0.150
     3.096    85.328     0.150
     3.195    50.148     0.150
     3.195    87.613     0.150
     3.856    60.426     0.150
     3.856   104.113     0.150
     3.919    58.867     0.150
     3.919   101.820     0.150
     3.932    60.309     0.150
     3.932   103.965     0.150
     3.984    61.363     0.150
     3.984   105.555     0.150
     4.026    60.586     0.150
     4.026   103.785     0.150
     4.034    60.391     0.150
     4.034   104.105     0.150
     4.040    59.285     0.150
     4.040   103.984     0.150
     4.378    64.883     0.150
     5.138    78.055     0.150
     5.138   134.285     0.150
     5.367    79.539     0.150
     5.367   138.531     0.150
     5.639    82.086     0.150
     0.559    11.613     0.150
     0.559    20.453     0.150
     0.769    15.051     0.150
     0.769    26.941     0.150
     0.810    16.035     0.150
     0.810    28.770     0.150
     0.826    16.035     0.150
     0.872    17.852     0.150
     0.996    18.977     0.150
     1.074    20.973     0.150
     1.074    35.523     0.150
     1.571    26.688     0.150
     1.571    46.180     0.150
     1.617    28.320     0.150
     1.617    29.613     0.150
     1.617    50.391     0.150
     1.674    30.328     0.150
     1.674    52.160     0.150
     1.811    32.535     0.150
     1.883    33.152     0.150
     1.895    58.395     0.150
     1.947    32.406     0.150
     1.947    57.098     0.150
     2.026    32.473     0.150
     2.030    58.070     0.150
     2.030    58.180     0.150
     2.529    74.871     0.150
     2.529    41.891     0.150
     2.569    39.762     0.150
     2.569    68.730     0.150
     3.039    46.434     0.150
     3.039    79.730     0.150
     3.340    50.480     0.150
     3.340    88.211     0.150
     3.283    56.305     0.150
     3.283    98.215     0.150
     3.411    54.527     0.150
     3.411    99.086     0.150
     3.506    54.398     0.150
     3.506    92.129     0.150
     3.549    53.922     0.150
     3.549    96.371     0.150
     3.572    92.891     0.150
     3.697    57.262     0.150
     3.697    99.891     0.150
     3.880    60.332     0.150
     4.339    66.852     0.150
     4.339   115.781     0.150
     4.614    69.301     0.150
     4.614   120.949     0.150
     4.618    69.223     0.150
     4.618   119.402     0.150
     4.659    68.059     0.150
     4.659   119.391     0.150
     4.786    70.371     0.150
     4.786   122.441     0.150
     4.791    69.879     0.150
     5.128   149.730     0.150
     5.196    76.191     0.150
     5.196    75.031     0.150
     5.196   130.633     0.150
     5.213    75.230     0.150
     5.665    82.789     0.150
     5.665   144.293     0.150
     0.589    12.676     0.150
     0.589    20.314     0.150
     0.802    17.584     0.150
     0.884    17.902     0.150
     0.934    32.553     0.150
     1.240    26.523     0.150
     1.297    24.535     0.150
     1.982    36.186     0.150
     2.097    64.652     0.150
     2.287    41.514     0.150
     2.287    65.133     0.150
     3.047    48.246     0.150
     3.047    86.035     0.150
     3.691    58.766     0.150
     3.691   100.465     0.150
     3.992   105.336     0.150
     4.067    62.135     0.150
     4.067   107.135     0.150
     4.121   108.266     0.150
     4.182    64.803     0.150
     4.182   109.414     0.150
     4.228    66.695     0.150
     4.269    66.135     0.150
     4.269   112.936     0.150
     4.269    65.824     0.150
     4.269   111.186     0.150
     4.380    68.436     0.150
     4.380   114.836     0.150
     4.443    68.855     0.150
     4.443   115.266     0.150
     4.565    71.336     0.150
     4.565   122.035     0.150
     4.634    71.152     0.150
     4.634   120.723     0.150
     4.722    74.846     0.150
     4.722   127.945     0.150
     4.980    76.135     0.150
     4.980   130.535     0.150
     5.200    79.936     0.150
     5.200   134.635     0.150
     5.201    78.766     0.150
     5.201   133.955     0.150
     5.415    82.734     0.150
     5.415   141.135     0.150
     5.761   149.436     0.150
     5.920    88.635     0.150
     5.920   152.035     0.150
     6.017    89.363     0.150
     6.017   152.742     0.150
     6.210    92.223     0.150
     6.210   159.248     0.150
     6.335    94.336     0.150
     6.335   162.336     0.150
     6.421    95.535     0.150
     6.421   164.715     0.150
     6.756   173.734     0.150
     0.134     3.964     0.150
     0.354     7.718     0.150
     0.354    11.690     0.150
     0.485    10.045     0.150
     0.566    12.096     0.150
     0.566    19.516     0.150
     1.157    23.776     0.150
     1.157    40.465     0.150
     1.256    24.347     0.150
     1.256    42.172     0.150
     1.750    31.746     0.150
     1.750    55.189     0.150
     1.714    31.771     0.150
     1.714    53.228     0.150
     1.999    38.102     0.150
     1.999    62.142     0.150
     2.156    40.569     0.150
     2.331    40.586     0.150
     2.351    42.027     0.150
     2.351    73.229     0.150
     2.444    43.628     0.150
     2.444    75.018     0.150
     2.480    43.194     0.150
     2.480    73.636     0.150
     2.572    42.376     0.150
     2.572    74.164     0.150
     2.639    44.773     0.150
     2.639    80.517     0.150
     2.875    46.864     0.150
     2.875    82.437     0.150
     2.946    48.806     0.150
     2.946    80.846     0.150
     2.982    54.426     0.150
     2.982    91.656     0.150
     3.620    55.966     0.150
     3.676    57.603     0.150
     3.676   102.182     0.150
     3.950    62.539     0.150
     3.950   106.579     0.150
     3.959    61.911     0.150
     4.108    63.036     0.150
     4.108   109.855     0.150
     4.360    68.124     0.150
     4.360   118.184     0.150
     4.475    71.484     0.150
     4.475   121.124     0.150
     4.845    72.896     0.150
     4.845   125.596     0.150
     4.909    73.996     0.150
     4.909   126.996     0.150
     4.950    74.686     0.150
     4.950   128.145     0.150
     4.961    74.724     0.150
     4.961   128.141     0.150
     5.118    77.046     0.150
     5.118   131.906     0.150
     5.139    77.696     0.150
     5.139   135.696     0.150
     5.135    79.886     0.150
     5.135   134.806     0.150
     5.228    79.496     0.150
     5.228   134.896     0.150
     5.228    80.234     0.150
     5.228   135.631     0.150
     5.430    81.996     0.150
     5.430   140.196     0.150
     5.522   144.896     0.150
     5.584    87.936     0.150
     5.833   149.996     0.150
     5.983    88.855     0.150
     5.983   152.716     0.150
     6.030    89.896     0.150
     6.030   155.396     0.150
     6.030    89.416     0.150
     6.030   155.166     0.150
     6.222    92.896     0.150
     6.222   160.796     0.150
     6.398    98.306     0.150
     6.398   163.565     0.150
     6.589    97.796     0.150
     6.589   168.896     0.150
     6.615    97.924     0.150
     6.615   167.116     0.150
     6.710    99.196     0.150
     6.710   170.196     0.150
     6.780   100.020     0.150
     6.780   171.834     0.150
     6.858   102.596     0.150
     6.858   174.296     0.150
     6.858   101.144     0.150
     6.858   172.884     0.150
     7.123   104.896     0.150
     7.123   179.996     0.150
     7.138   104.526     0.150
     7.138   179.306     0.150
     7.150   105.396     0.150
     7.150   181.896     0.150
     7.675   112.396     0.150
     7.675   195.196     0.150
     8.052   118.196     0.150
     8.332   121.696     0.150
     8.332   121.506     0.150
     8.665   126.296     0.150
     9.061   131.558     0.150
     9.061   224.523     0.150
     9.193   133.096     0.150
     9.193   229.236     0.150
    10.102   145.514     0.150
     0.111     3.941     0.150
     0.111     7.216     0.150
     0.315     7.871     0.150
     0.315    12.455     0.150
     0.446     8.525     0.150
     0.446    15.982     0.150
     1.168    36.686     0.150
     1.245    24.242     0.150
     1.690    30.792     0.150
     1.690    53.713     0.150
     2.461    42.314     0.150
     2.461    75.978     0.150
     2.543    41.833     0.150
     2.543    73.710     0.150
     2.601    42.105     0.150
     2.601    77.497     0.150
     2.903    46.365     0.150
     2.903    81.856     0.150
     4.868    72.397     0.150
     4.868   125.498     0.150
     4.931    74.397     0.150
     4.931   126.797     0.150
     4.970    74.117     0.150
     4.970   125.688     0.150
     4.976    74.456     0.150
     4.976   129.436     0.150
     5.125   133.578     0.150
     5.250    78.798     0.150
     5.250   134.998     0.150
     5.230   133.965     0.150
     5.999    88.287     0.150
     5.999   153.217     0.150
     6.240    91.398     0.150
     6.240   159.398     0.150
     6.725    99.297     0.150
     6.725   171.098     0.150
     0.662    13.984     0.150
     0.773    28.469     0.150
     0.804    16.141     0.150
     0.804    27.562     0.150
     1.094    20.680     0.150
     1.094    34.922     0.150
     1.316    24.820     0.150
     1.220    22.438     0.150
     1.220    38.523     0.150
     1.847    33.305     0.150
     2.090    35.547     0.150
     2.090    63.000     0.150
     2.939    45.594     0.150
     2.939    81.312     0.150
     3.109    46.992     0.150
     3.109    84.164     0.150
     3.303    49.812     0.150
     3.303    85.609     0.150
     3.739    56.359     0.150
     3.739    97.312     0.150
     3.762    56.539     0.150
     3.762    99.961     0.150
     4.077    61.172     0.150
     4.077   104.469     0.150
     4.152    62.469     0.150
     4.152   104.969     0.150
     4.082    62.273     0.150
     4.082   107.594     0.150
     4.205    62.984     0.150
     4.205   106.312     0.150
     4.263    63.547     0.150
     4.263   108.820     0.150
     4.353    63.969     0.150
     4.353   110.773     0.150
     4.464    66.773     0.150
     4.464   112.875     0.150
     4.516    67.023     0.150
     4.516   116.102     0.150
     4.649    68.773     0.150
     4.649   118.773     0.150
     4.700    69.500     0.150
     4.700   120.062     0.150
     4.771    72.633     0.150
     4.771   125.000     0.150
     5.065    74.375     0.150
     5.065   127.969     0.150
     5.284    78.070     0.150
     5.284   132.672     0.150
     5.282    77.062     0.150
     5.282   133.641     0.150
     5.845   148.070     0.150
     6.001    86.969     0.150
     6.001   150.070     0.150
     6.086    89.070     0.150
     6.086   150.773     0.150
     6.086    88.305     0.150
     6.084    88.469     0.150
     6.084   151.281     0.150
     6.274    90.531     0.150
     6.274   156.781     0.150
     6.498    93.422     0.150
     7.658   109.891     0.150
     7.829   111.820     0.150
     8.403   120.094     0.150
     0.423     9.539     0.150
     0.814    16.875     0.150
     1.185    23.508     0.150
     1.185    42.008     0.150
     1.438    28.047     0.150
     1.548    29.789     0.150
     1.548    51.430     0.150
     1.691    31.883     0.150
     1.691    54.805     0.150
     1.795    31.883     0.150
     1.795    57.016     0.150
     2.337    38.570     0.150
     2.337    67.891     0.150
     3.392    52.922     0.150
     3.392    91.117     0.150
     3.443    54.023     0.150
     3.443    92.617     0.150
     3.476    54.141     0.150
     3.476    92.648     0.150
     3.489    55.031     0.150
     3.489    92.648     0.150
     3.768   101.117     0.150
     3.719    58.781     0.150
     3.719    98.172     0.150
     4.020    62.430     0.150
     4.020   105.539     0.150
     4.020   106.523     0.150
     3.915    60.461     0.150
     3.915   103.336     0.150
     4.056    65.258     0.150
     4.056   110.172     0.150
     4.379   116.320     0.150
     4.511    69.078     0.150
     4.511   117.922     0.150
     4.745   124.617     0.150
     5.113    77.922     0.150
     5.113   134.922     0.150
     5.296   134.797     0.150
     0.631    13.703     0.150
     0.631    23.156     0.150
     0.993    19.984     0.150
     0.993    33.203     0.150
     1.275    24.734     0.150
     1.396    26.258     0.150
     1.854    34.125     0.150
     2.206    36.930     0.150
     2.710    45.977     0.150
     2.710    79.398     0.150
     2.723    86.227     0.150
     2.890    46.477     0.150
     2.890    80.008     0.150
     2.989    50.273     0.150
     2.989    87.406     0.150
     3.112    50.297     0.150
     3.112    86.844     0.150
     3.546    55.828     0.150
     3.546    95.555     0.150
     3.852    60.125     0.150
     3.852   101.328     0.150
     3.923    61.125     0.150
     3.923   103.523     0.150
     3.934    61.234     0.150
     3.934   107.164     0.150
     3.973    59.953     0.150
     3.973   103.195     0.150
     3.907    61.797     0.150
     3.907   105.805     0.150
     4.026    60.516     0.150
     4.026   104.594     0.150
     4.143    63.273     0.150
     4.143   106.664     0.150
     4.237    65.625     0.150
     4.237   110.625     0.150
     4.283    65.844     0.150
     4.283   110.742     0.150
     4.487    67.922     0.150
     4.487   117.523     0.150
     4.475    68.750     0.150
     4.475   115.953     0.150
     4.575    70.812     0.150
     4.575   121.375     0.150
     4.840    72.922     0.150
     4.840   125.328     0.150
     5.045    75.609     0.150
     5.045   128.422     0.150
     5.262   136.023     0.150
     5.765    85.422     0.150
     5.765   147.422     0.150
     5.858    86.453     0.150
     5.858   148.633     0.150
     6.052    89.062     0.150
     7.420   108.516     0.150
     7.621   111.016     0.150
     0.532    11.337     0.150
     0.669    14.695     0.150
     0.669    24.519     0.150
     1.089    20.589     0.150
     2.597    46.784     0.150
     2.597    80.184     0.150
     2.806    85.422     0.150
     2.810    46.129     0.150
     2.810    80.184     0.150
     3.125    93.936     0.150
     3.290    90.682     0.150
     4.266   111.407     0.150
     4.343    66.207     0.150
     4.343   113.607     0.150
     4.399    66.371     0.150
     4.399   114.722     0.150
     4.460    67.843     0.150
     4.460   117.849     0.150
     4.654    70.808     0.150
     4.709    71.173     0.150
     4.709   123.335     0.150
     4.903    73.808     0.150
     4.903   126.808     0.150
     4.885    73.942     0.150
     4.885   126.731     0.150
     5.254    78.007     0.150
     5.479    81.560     0.150
     5.479   141.344     0.150
     6.270   158.710     0.150
     0.334     6.812     0.150
     0.334    11.680     0.150
     0.916    31.570     0.150
     1.024    22.250     0.150
     0.991    20.828     0.150
     0.991    34.859     0.150
     1.807    32.984     0.150
     1.807    57.727     0.150
     2.165    61.312     0.150
     2.421    39.789     0.150
     2.489    40.695     0.150
     2.489    71.867     0.150
     2.564    43.672     0.150
     2.564    74.023     0.150
     2.774    46.711     0.150
     2.823    46.398     0.150
     2.823    81.109     0.150
     2.933    48.852     0.150
     2.915    50.234     0.150
     2.915    86.375     0.150
     2.998    50.195     0.150
     3.437    56.570     0.150
     3.884    62.422     0.150
     4.006    62.727     0.150
     4.006   107.609     0.150
     4.253    65.344     0.150
     4.253   113.406     0.150
     4.517    69.070     0.150
     4.570    69.766     0.150
     4.570   120.164     0.150
     4.852    75.031     0.150
     4.852   130.820     0.150
     5.157    78.367     0.150
     5.157   134.570     0.150
     5.208    78.688     0.150
     5.208   136.141     0.150
     5.519    83.070     0.150
     5.519   144.070     0.150
     0.273     6.201     0.150
     0.273    10.512     0.150
     0.898    18.566     0.150
     0.898    31.820     0.150
     1.920    34.348     0.150
     1.920    61.691     0.150
     2.431    42.412     0.150
     2.376    40.137     0.150
     2.376    68.838     0.150
     2.548    41.465     0.150
     2.548    73.045     0.150
     2.619    45.113     0.150
     2.711    44.172     0.150
     2.567    43.320     0.150
     2.952    50.354     0.150
     3.019    49.432     0.150
     3.116    50.270     0.150
     3.718    61.098     0.150
     3.959    60.623     0.150
     3.959   107.080     0.150
     4.370    67.674     0.150
     4.370   118.412     0.150
     4.571    72.072     0.150
     4.571   123.672     0.150
     5.252    78.107     0.150
     5.301    79.334     0.150
     5.301   137.234     0.150
     5.360    80.033     0.150
     5.360   138.234     0.150
     5.382    80.025     0.150
     5.382   139.496     0.150
     5.395    80.461     0.150
     5.395   139.479     0.150
     5.384    82.973     0.150
     5.384   143.311     0.150
     5.490    82.793     0.150
     5.490   143.854     0.150
     5.562    83.982     0.150
     5.562   146.262     0.150
     5.606    83.533     0.150
     5.606   143.834     0.150
     5.606    82.834     0.150
     5.663    84.184     0.150
     5.663    84.834     0.150
     5.663   145.334     0.150
     5.893    87.734     0.150
     5.893   152.434     0.150
     6.289    92.834     0.150
     6.289   161.033     0.150
     6.404    94.217     0.150
     6.404   164.074     0.150
     6.475    95.533     0.150
     6.475   165.633     0.150
     6.591    99.543     0.150
     6.656    97.934     0.150
     6.656   169.834     0.150
     6.945   103.342     0.150
     7.032   103.133     0.150
     7.032   178.834     0.150
     7.133   104.434     0.150
     7.316   108.033     0.150
     7.546   110.234     0.150
     7.546   190.633     0.150
     8.736   126.633     0.150
     0.618    13.156     0.150
     0.618    22.115     0.150
     1.114    22.219     0.150
     1.251    22.637     0.150
     1.251    40.080     0.150
     1.373    24.754     0.150
     1.373    43.453     0.150
     1.949    34.451     0.150
     1.949    57.680     0.150
     2.102    33.330     0.150
     2.162    59.824     0.150
     2.174    38.809     0.150
     2.174    68.375     0.150
     2.924    44.855     0.150
     2.924    78.355     0.150
     2.974    90.211     0.150
     3.082    89.381     0.150
     3.102    81.635     0.150
     3.242   101.914     0.150
     3.577    93.855     0.150
     3.882    58.637     0.150
     3.882    99.836     0.150
     3.954    59.936     0.150
     4.005    60.285     0.150
     4.005   103.355     0.150
     4.060    60.539     0.150
     4.060   104.293     0.150
     4.230    62.736     0.150
     4.268    64.137     0.150
     4.268   109.336     0.150
     4.317    64.693     0.150
     4.317   111.076     0.150
     4.461    66.035     0.150
     4.461   115.035     0.150
     4.510    67.344     0.150
     4.510   115.793     0.150
     4.871    71.535     0.150
     4.871   124.637     0.150
     5.079    74.484     0.150
     5.079   128.646     0.150
     5.296    78.236     0.150
     5.296   134.436     0.150
     5.645    83.137     0.150
     5.798    84.336     0.150
     5.798   145.836     0.150
     6.085   152.725     0.150
     6.214    89.936     0.150
     6.214   155.535     0.150
     6.296    91.256     0.150
     6.296   157.865     0.150
     7.454   107.637     0.150
     7.454   107.455     0.150
     7.454   185.156     0.150
     0.339     8.238     0.150
     0.339    13.012     0.150
     1.199    22.402     0.150
     1.199    40.297     0.150
     1.517    49.562     0.150
     1.638    29.926     0.150
     1.638    51.047     0.150
     1.904    34.105     0.150
     1.904    59.047     0.150
     2.141    36.125     0.150
     2.141    60.883     0.150
     2.031    37.488     0.150
     2.031    65.258     0.150
     2.194    39.125     0.150
     2.194    66.492     0.150
     2.287    40.672     0.150
     2.287    69.473     0.150
     2.505    42.816     0.150
     2.505    73.695     0.150
     2.679    46.312     0.150
     2.679    80.348     0.150
     2.957    46.746     0.150
     2.957    82.535     0.150
     2.738    47.070     0.150
     2.738    81.102     0.150
     3.117    88.969     0.150
     4.248    63.523     0.150
     4.248   110.023     0.150
     4.367    65.125     0.150
     4.367   113.023     0.150
     4.646    69.125     0.150
     5.212    76.723     0.150
     5.212   132.625     0.150
     6.076    89.324     0.150
     0.584    12.508     0.150
     0.584    20.070     0.150
     0.759    16.195     0.150
     0.760    16.461     0.150
     0.760    27.602     0.150
     1.490    29.852     0.150
     1.490    49.977     0.150
     1.796    34.164     0.150
     1.796    57.133     0.150
     2.171    39.320     0.150
     2.574    46.414     0.150
     2.574    81.008     0.150
     2.865    52.461     0.150
     2.868    49.984     0.150
     2.868    87.898     0.150
     3.017    52.289     0.150
     3.017    90.008     0.150
     3.529   104.617     0.150
     3.841    62.836     0.150
     3.990    61.172     0.150
     4.063    62.172     0.150
     4.084   118.492     0.150
     4.376    66.477     0.150
     4.567    69.070     0.150
     4.978    74.273     0.150
     0.412     9.039     0.150
     0.412    14.949     0.150
     0.542    11.699     0.150
     0.542    19.086     0.150
     0.791    26.477     0.150
     1.144    22.633     0.150
     1.144    39.773     0.150
     1.275    23.816     0.150
     1.275    40.953     0.150
     1.858    56.555     0.150
     1.749    32.680     0.150
     1.749    53.953     0.150
     1.924    36.520     0.150
     1.975    35.637     0.150
     1.975    61.344     0.150
     2.144    38.293     0.150
     2.144    67.254     0.150
     2.186    37.113     0.150
     2.186    66.660     0.150
     2.420    42.430     0.150
     2.420    74.047     0.150
     2.696    44.500     0.150
     2.696    78.184     0.150
     2.835    45.680     0.150
     2.835    78.777     0.150
     2.851    46.566     0.150
     2.851    82.914     0.150
     3.638    55.727     0.150
     3.638    99.758     0.150
     4.811    71.176     0.150
     4.811   123.477     0.150
     4.877    71.977     0.150
     4.877   125.074     0.150
     4.921    72.945     0.150
     4.921   125.855     0.150
     4.939    73.422     0.150
     4.939   126.793     0.150
     5.107    76.266     0.150
     5.107   129.734     0.150
     5.195    77.875     0.150
     5.195   133.176     0.150
     5.224    78.102     0.150
     5.224   133.984     0.150
     5.392    79.477     0.150
     5.392   137.977     0.150
     5.799    85.574     0.150
     5.799   147.574     0.150
     5.961    87.559     0.150
     5.961   151.523     0.150
     6.560    95.375     0.150
     6.686    97.477     0.150
     6.686   169.574     0.150
     0.882    18.687     0.150
     1.146    23.261     0.150
     1.146    40.356     0.150
     1.219    24.946     0.150
     1.219    42.145     0.150
     1.396    27.354     0.150
     1.396    46.702     0.150
     1.559    30.691     0.150
     1.559    51.407     0.150
     1.744    33.627     0.150
     1.744    56.885     0.150
     1.772    34.544     0.150
     1.772    58.388     0.150
     1.978    36.440     0.150
     1.978    63.215     0.150
     2.050    37.180     0.150
     2.050    64.737     0.150
     2.703    46.362     0.150
     2.752    83.265     0.150
     3.230    55.884     0.150
     3.230    95.884     0.150
     3.329    55.007     0.150
     3.329    92.550     0.150
     3.879    62.319     0.150
     3.879   109.029     0.150
     5.350   139.394     0.150
     5.449    83.594     0.150
     5.449   141.594     0.150
     5.629    84.960     0.150
     5.629   147.320     0.150
     5.905    89.476     0.150
     5.905   153.240     0.150
     6.075   158.152     0.150
     6.328    94.594     0.150
     6.328   162.794     0.150
     7.355   109.694     0.150
     0.349    10.250     0.150
     0.349    15.754     0.150
     0.878    28.301     0.150
     0.750    16.453     0.150
     0.774    15.992     0.150
     0.791    16.398     0.150
     1.575    27.066     0.150
     1.575    45.387     0.150
     1.669    29.766     0.150
     1.669    48.699     0.150
     2.018    32.469     0.150
     2.018    54.855     0.150
     2.080    32.488     0.150
     2.080    56.879     0.150
     2.105    34.945     0.150
     2.970    79.754     0.150
     4.535    67.035     0.150
     4.534    65.520     0.150
     4.534   113.777     0.150
     4.613   116.617     0.150
     4.638    67.012     0.150
     4.638   116.863     0.150
     4.637    67.516     0.150
     4.637   116.715     0.150
     4.972    71.914     0.150
     5.255    76.215     0.150
     5.255   132.215     0.150
     5.547    79.543     0.150
     5.547   139.125     0.150
     5.588    80.414     0.150
     5.588   139.617     0.150
     6.250    89.215     0.150
     6.250   157.414     0.150
     0.363     9.363     0.150
     0.363    15.832     0.150
     1.125    21.266     0.150
     1.125    36.777     0.150
     0.966    18.465     0.150
     0.966    31.230     0.150
     1.139    22.207     0.150
     1.139    37.590     0.150
     1.226    22.727     0.150
     1.407    26.008     0.150
     1.407    43.762     0.150
     1.684    29.387     0.150
     1.684    49.809     0.150
     1.638    29.691     0.150
     1.638    50.742     0.150
     1.638    29.289     0.150
     1.580    29.203     0.150
     1.580    50.750     0.150
     1.893    32.438     0.150
     1.893    53.516     0.150
     1.893    32.871     0.150
     1.893    54.887     0.150
     2.025    34.766     0.150
     2.025    61.969     0.150
     1.944    56.262     0.150
     2.449    40.117     0.150
     2.449    63.688     0.150
     2.511    41.586     0.150
     2.511    67.688     0.150
     2.427    39.070     0.150
     2.427    68.746     0.150
     2.517    39.676     0.150
     2.517    69.066     0.150
     2.558    40.316     0.150
     2.738    72.988     0.150
     2.738    42.469     0.150
     2.887    46.387     0.150
     2.887    78.688     0.150
     2.928    45.777     0.150
     2.928    78.156     0.150
     3.000    46.898     0.150
     3.000    80.465     0.150
     3.281    50.707     0.150
     3.281    90.027     0.150
     3.367    53.055     0.150
     3.367    91.141     0.150
     3.648    55.383     0.150
     3.648    96.312     0.150
     3.742    59.246     0.150
     3.742    99.527     0.150
     3.989    59.277     0.150
     3.989   103.477     0.150
     4.046    59.953     0.150
     4.046   105.566     0.150
     4.042    59.887     0.150
     4.042   104.188     0.150
     4.030    63.527     0.150
     4.073    60.266     0.150
     4.073   104.219     0.150
     4.068    60.188     0.150
     4.068   103.688     0.150
     4.068   104.508     0.150
     4.123    62.184     0.150
     4.123   108.496     0.150
     4.402    64.789     0.150
     4.402   113.188     0.150
     4.476    66.988     0.150
     4.476   114.086     0.150
     4.451    65.219     0.150
     4.451   113.746     0.150
     4.451    65.688     0.150
     4.451   115.277     0.150
     4.451    65.488     0.150
     4.471    65.977     0.150
     4.471   113.199     0.150
     4.442   117.121     0.150
     4.488    68.570     0.150
     4.650    68.586     0.150
     4.650   118.586     0.150
     4.654    68.129     0.150
     4.654   117.258     0.150
     4.684    68.988     0.150
     4.684   119.289     0.150
     4.739   120.766     0.150
     4.739    70.848     0.150
     4.739    71.199     0.150
     4.807    73.094     0.150
     4.807   125.895     0.150
     5.005    73.637     0.150
     5.005   126.078     0.150
     5.018    73.688     0.150
     5.018   127.188     0.150
     5.284    77.527     0.150
     5.284   134.316     0.150
     5.284    77.688     0.150
     5.284   134.188     0.150
     5.323    81.074     0.150
     5.269    80.086     0.150
     5.508    80.691     0.150
     5.508   139.336     0.150
     5.508    80.809     0.150
     5.508   139.957     0.150
     5.668    82.645     0.150
     5.668   142.586     0.150
     5.668   162.688     0.150
     5.668    83.375     0.150
     5.668    81.449     0.150
     5.668   144.559     0.150
     5.670    83.039     0.150
     5.690    82.988     0.150
     5.690   144.188     0.150
     5.522    83.789     0.150
     5.540    83.789     0.150
     5.738    83.789     0.150
     5.738   142.988     0.150
     5.794   149.488     0.150
     5.792    88.027     0.150
     5.792   152.016     0.150
     5.976    89.984     0.150
     6.046    88.086     0.150
     6.046   152.355     0.150
     6.046    88.289     0.150
     6.046   153.988     0.150
     6.085    88.816     0.150
     6.085   152.176     0.150
     6.146    89.289     0.150
     6.146   155.188     0.150
     6.240    90.586     0.150
     6.240   155.688     0.150
     6.296    91.488     0.150
     6.296   159.387     0.150
     6.388   158.469     0.150
     6.613    96.145     0.150
     6.613   163.457     0.150
     6.656    96.488     0.150
     6.656   167.586     0.150
     6.689    97.188     0.150
     6.689   165.086     0.150
     6.689    96.758     0.150
     6.689   167.188     0.150
     6.766    98.188     0.150
     6.766    97.246     0.150
     6.766   169.887     0.150
     7.077   101.688     0.150
     7.077   178.688     0.150
     7.128   103.594     0.150
     7.061   103.766     0.150
     7.061   180.227     0.150
     7.224   106.141     0.150
     7.309   105.332     0.150
     7.309   182.297     0.150
     7.309   181.988     0.150
     7.560   108.988     0.150
     7.560   187.387     0.150
     7.885   113.086     0.150
     7.885   196.387     0.150
     8.019   115.117     0.150
     8.019   199.355     0.150
     8.046   115.789     0.150
     8.046   198.086     0.150
     8.049   117.402     0.150
     8.202   117.645     0.150
     8.202   201.609     0.150
     8.421   123.535     0.150
     8.421   212.254     0.150
     8.404   122.566     0.150
     8.404   212.863     0.150
     8.630   123.676     0.150
     8.630   212.418     0.150
     8.691   126.465     0.150
     9.098   223.367     0.150
     9.092   132.332     0.150
     9.247   133.316     0.150
     9.247   229.316     0.150
     9.244   133.566     0.150
     9.244   228.320     0.150
     9.343   135.641     0.150
     9.436   134.316     0.150
     9.436   232.379     0.150
     9.450   134.551     0.150
     9.450   230.953     0.150
     9.468   137.789     0.150
     9.468   231.188     0.150
     9.497   137.789     0.150
     9.484   140.449     0.150
     9.534   236.531     0.150
     9.603   138.777     0.150
     9.603   241.359     0.150
     9.631   139.504     0.150
     9.860   143.586     0.150
     9.860   239.988     0.150
     9.997   144.859     0.150
    10.811   155.988     0.150
    10.811   262.586     0.150
    11.713   168.086     0.150
    12.115   173.789     0.150
    12.115   293.289     0.150
    12.096   173.488     0.150
    12.096   293.988     0.150
    12.274   297.488     0.150
    12.815   182.387     0.150
    12.844   183.688     0.150
    13.051   186.586     0.150
    13.051   317.086     0.150
    13.070   181.488     0.150
    13.070   317.387     0.150
    13.371   190.586     0.150
    13.371   323.688     0.150
    13.662   189.789     0.150
    13.698   189.988     0.150
    13.812   196.688     0.150
    13.812   334.387     0.150
    13.806   196.887     0.150
    13.806   335.289     0.150
    13.920   338.586     0.150
    13.951   193.586     0.150
    14.141   198.078     0.150
    14.183   196.789     0.150
    14.225   197.188     0.150
    14.225   201.789     0.150
    14.225   344.086     0.150
    14.304   347.789     0.150
    14.331   348.488     0.150
    14.382   199.289     0.150
    14.471   205.188     0.150
    14.471   350.887     0.150
    14.645   355.887     0.150
    14.769   204.887     0.150
    14.769   209.488     0.150
    14.769   355.887     0.150
    15.068   363.488     0.150
    15.066   208.688     0.150
    15.066   212.887     0.150
    15.066   366.387     0.150
    15.981   221.086     0.150
    16.240   224.887     0.150
    16.295   395.586     0.150
    16.343   226.289     0.150
    16.343   396.688     0.150
    16.520   228.688     0.150
    16.520   399.988     0.150
    16.942   238.836     0.150
    16.990   411.688     0.150
    17.294   241.836     0.150
    17.347   239.988     0.150
    17.359   241.898     0.150
    17.395   243.539     0.150
    17.565   244.488     0.150
    17.533   244.555     0.150
    17.610   244.289     0.150
    17.894   248.027     0.150
    17.865   247.758     0.150
    17.910   248.652     0.150
    18.112   251.887     0.150
    18.158   250.293     0.150
    18.174   251.152     0.150
    18.104   253.766     0.150
    18.296   254.691     0.150
    18.851   260.168     0.150
    18.950   261.211     0.150
    19.036   262.219     0.150
    19.300   265.387     0.150
    19.640   266.906     0.150
    19.673   268.219     0.150
    19.673   501.469     0.150
    19.830   270.168     0.150
    19.913   269.707     0.150
    20.239   273.336     0.150
    20.239   273.211     0.150
    20.239   272.516     0.150
    20.266   273.508     0.150
    20.363   275.289     0.150
    20.363   274.379     0.150
    20.679   278.719     0.150
    20.833   279.398     0.150
    20.856   282.078     0.150
    20.856   281.387     0.150
    21.297   285.117     0.150
    21.303   285.176     0.150
    21.308   285.098     0.150
    21.315   284.766     0.150
    21.318   284.797     0.150
    21.321   286.414     0.150
    21.325   284.738     0.150
    21.328   285.129     0.150
    21.335   284.918     0.150
    21.358   285.098     0.150
    21.399   285.688     0.150
    21.471   286.387     0.150
    21.596   288.789     0.150
    21.596   527.688     0.150
    21.675   288.188     0.150
    21.710   289.418     0.150
    21.710   530.688     0.150
    21.774   289.289     0.150
    21.870   290.289     0.150
    22.023   292.059     0.150
    22.023   292.215     0.150
    22.023   291.887     0.150
    21.646   291.527     0.150
    22.456   297.488     0.150
    22.512   296.988     0.150
    22.528   297.988     0.150
    22.588   298.488     0.150
    22.615   300.898     0.150
    22.799   301.176     0.150
    22.799   300.887     0.150
    22.799   300.379     0.150
    23.081   304.297     0.150
    23.155   305.059     0.150
    23.558   309.816     0.150
    23.555   309.926     0.150
    23.555   309.008     0.150
    23.990   314.156     0.150
    24.116   314.195     0.150
    24.256   314.699     0.150
    24.256   314.957     0.150
    24.427   317.988     0.150
    24.672   320.930     0.150
    25.231   325.762     0.150
    25.532   328.750     0.150
    25.596   328.789     0.150
    26.154   333.184     0.150
    26.154   334.535     0.150
    26.316   334.957     0.150
    26.316   336.254     0.150
    26.316   335.277     0.150
    26.725   340.277     0.150
    26.781   340.590     0.150
    27.138   344.781     0.150
    27.239   344.238     0.150
    28.947   356.547     0.150
    29.860   363.613     0.150
    29.860   364.809     0.150
    33.816   399.238     0.150
    33.818   397.938     0.150
    33.968   403.637     0.150
    34.878   412.777     0.150
    37.973   436.836     0.150
    39.327   446.688     0.150
    39.327   447.219     0.150
    43.242   478.789     0.150
    47.123   511.539     0.150
    47.123   511.746     0.150
    48.475   521.914     0.150
    50.271   536.695     0.150
    54.938   569.656     0.150
    55.070   570.309     0.150
    57.511   588.789     0.150
    57.511   589.426     0.150
    57.810   590.766     0.150
    57.810   590.629     0.150
    57.810   590.766     0.150
    58.307   594.766     0.150
    59.031   599.777     0.150
    59.036   600.508     0.150
    60.670   609.707     0.150
    60.726   611.199     0.150
    62.209   622.309     0.150
    62.736   623.988     0.150
    62.763   625.398     0.150
    62.923   626.387     0.150
    62.923   766.789     0.150
    62.923   905.887     0.150
    62.923  1131.988     0.150
    62.923  1213.688     0.150
    63.129   626.598     0.150
    63.129   626.348     0.150
    63.275   628.918     0.150
    63.421   629.188     0.150
    63.543   628.617     0.150
    63.741   631.328     0.150
    64.094   633.566     0.150
    64.139   633.129     0.150
    64.343   634.219     0.150
    64.343   634.812     0.150
    64.343   634.488     0.150
    65.289   643.363     0.150
    66.492   649.086     0.150
    66.770   650.047     0.150
    67.832   657.559     0.150
    68.688   662.988     0.150
    69.041   665.949     0.150
    69.070   666.469     0.150
    69.068   666.188     0.150
    69.350   667.148     0.150
    69.436   666.367     0.150
    70.161   669.719     0.150
    70.719   675.746     0.150
    71.062   676.938     0.150
    74.232   695.809     0.150
    74.338   695.426     0.150
    74.358   696.988     0.150
    77.114   713.387     0.150
    77.114   712.719     0.150
    77.143   715.012     0.150
    77.143   712.117     0.150
    77.167   712.109     0.150
    77.303   713.539     0.150
    77.953   717.012     0.150
    77.953   717.199     0.150
    77.971   719.547     0.150
    78.284   719.219     0.150
    78.538   721.746     0.150
    79.100   724.289     0.150
    79.282   726.207     0.150
    80.421   731.109     0.150
    84.570   752.699     0.150
    85.268   755.188     0.150
    86.751   762.488     0.150
    90.747   784.387     0.150
    90.747   783.637     0.150
    95.587   803.488     0.150
   141.306  1169.625     0.150
   142.672  1174.238     0.150
     0.875    18.805     0.150
     0.875    30.391     0.150
     1.072    22.383     0.150
     1.072    38.312     0.150
     1.045    21.602     0.150
     1.045    36.484     0.150
     1.018    20.180     0.150
     1.018    34.289     0.150
     1.003    19.594     0.150
     1.003    33.289     0.150
     1.003    19.805     0.150
     1.003    33.156     0.150
     1.449    28.305     0.150
     1.449    47.328     0.150
     1.491    28.969     0.150
     1.710    32.641     0.150
     1.826    33.719     0.150
     1.833    31.625     0.150
     1.833    52.938     0.150
     1.836    31.625     0.150
     1.836    52.938     0.150
     1.871    32.867     0.150
     1.871    56.984     0.150
     2.212    39.320     0.150
     2.133    36.422     0.150
     2.133    67.195     0.150
     2.401    41.195     0.150
     2.402    39.797     0.150
     2.402    67.172     0.150
     2.402    67.758     0.150
     2.376    39.086     0.150
     2.301    39.273     0.150
     2.141    39.250     0.150
     2.141    67.977     0.150
     2.291    38.797     0.150
     2.291    69.953     0.150
     2.881    45.156     0.150
     2.881    77.445     0.150
     2.881    78.477     0.150
     2.892    46.797     0.150
     2.912    57.898     0.150
     2.794    45.820     0.150
     2.794    81.023     0.150
     3.037    83.469     0.150
     3.037    48.469     0.150
     3.066    55.578     0.150
     3.156    49.984     0.150
     3.156    83.688     0.150
     3.342    96.984     0.150
     3.315    52.477     0.150
     3.443    55.180     0.150
     3.443    92.406     0.150
     3.511    55.594     0.150
     3.589    55.680     0.150
     3.589    94.617     0.150
     3.842    61.500     0.150
     4.152    65.953     0.150
     4.152   108.711     0.150
     4.445    69.242     0.150
     4.445   114.758     0.150
     4.465    68.234     0.150
     4.465   115.750     0.150
     4.537    69.312     0.150
     4.537   117.844     0.150
     4.562    71.211     0.150
     4.606    70.070     0.150
     4.534    69.938     0.150
     4.534   120.062     0.150
     4.534    70.289     0.150
     4.686    70.633     0.150
     4.686   121.016     0.150
     4.692    70.367     0.150
     4.692   122.266     0.150
     4.700    69.969     0.150
     4.700   120.969     0.150
     4.700    70.805     0.150
     4.700   120.586     0.150
     4.720    72.172     0.150
     4.720   121.789     0.150
     4.823    74.070     0.150
     5.033    75.766     0.150
     5.033   130.469     0.150
     5.039    76.164     0.150
     5.039   129.867     0.150
     5.135    75.961     0.150
     5.135   132.484     0.150
     5.135    77.156     0.150
     5.135   133.734     0.150
     5.135    76.164     0.150
     5.143    76.195     0.150
     5.143   130.836     0.150
     5.143   132.867     0.150
     5.089    77.367     0.150
     5.105    77.367     0.150
     5.262    78.969     0.150
     5.262   135.469     0.150
     5.290    78.508     0.150
     5.290    78.867     0.150
     5.290   135.570     0.150
     5.324    81.453     0.150
     5.324   139.414     0.150
     5.350    79.266     0.150
     5.350   138.266     0.150
     5.286    80.469     0.150
     5.538    83.047     0.150
     5.538   141.141     0.150
     5.655    83.867     0.150
     5.655   145.164     0.150
     5.708    87.195     0.150
     5.708   149.586     0.150
     5.809    87.305     0.150
     5.809   147.836     0.150
     5.809    87.055     0.150
     5.847    87.367     0.150
     5.847   149.469     0.150
     5.865    87.867     0.150
     5.865   148.984     0.150
     5.935    89.391     0.150
     5.935    89.102     0.150
     5.935   150.680     0.150
     6.271    93.070     0.150
     6.271   159.664     0.150
     6.371    94.586     0.150
     6.517    96.664     0.150
     6.517   165.086     0.150
     6.603    98.664     0.150
     6.671    98.570     0.150
     6.671   168.766     0.150
     6.680    98.578     0.150
     6.680   169.586     0.150
     6.680   170.266     0.150
     6.817   100.469     0.150
     6.817   172.469     0.150
     6.893   101.469     0.150
     6.893   174.969     0.150
     6.901   102.039     0.150
     6.876   102.039     0.150
     6.876   173.758     0.150
     7.201   105.664     0.150
     7.201   184.070     0.150
     7.201   105.875     0.150
     7.201   184.359     0.150
     7.224   105.969     0.150
     7.224   183.867     0.150
     7.264   107.273     0.150
     7.264   181.844     0.150
     7.325   107.766     0.150
     7.598   110.664     0.150
     7.598   192.070     0.150
     7.776   113.820     0.150
     7.776   194.398     0.150
     7.776   195.164     0.150
     8.059   117.070     0.150
     8.059   200.766     0.150
     8.034   118.312     0.150
     8.195   120.039     0.150
     8.195   206.625     0.150
     8.326   121.570     0.150
     8.326   210.070     0.150
     8.457   123.352     0.150
     8.457   210.984     0.150
     8.549   124.469     0.150
     8.549   213.766     0.150
     8.704   126.734     0.150
     8.704   216.891     0.150
     8.855   129.070     0.150
     8.855   221.766     0.150
     9.151   132.898     0.150
     9.305   136.000     0.150
     9.409   137.508     0.150
     9.503   139.023     0.150
     9.503   235.438     0.150
     9.583   138.914     0.150
     9.583   237.406     0.150
     9.569   140.570     0.150
     9.596   139.078     0.150
     9.596   237.984     0.150
     9.544   138.867     0.150
     9.568   139.258     0.150
     9.638   140.969     0.150
     9.692   140.766     0.150
     9.692   241.148     0.150
     9.874   143.375     0.150
     9.874   244.898     0.150
     9.920   144.867     0.150
     9.965   143.883     0.150
     9.965   246.453     0.150
    10.240   253.469     0.150
    10.243   256.367     0.150
    10.773   267.766     0.150
    10.994   273.766     0.150
    11.251   162.594     0.150
    11.251   286.570     0.150
    11.804   171.070     0.150
    12.154   174.969     0.150
    12.680   182.266     0.150
    12.912   185.266     0.150
    13.208   190.469     0.150
    13.530   193.570     0.150
    13.550   194.164     0.150
    13.550   330.766     0.150
    14.847   210.664     0.150
    14.942   212.914     0.150
    17.642   246.820     0.150
    17.634   246.195     0.150
    19.110   263.211     0.150
    19.569   267.969     0.150
    20.103   274.305     0.150
    20.103   275.016     0.150
    20.103   275.156     0.150
    20.237   276.969     0.150
    20.237   277.094     0.150
    21.159   286.320     0.150
    21.672   291.266     0.150
    21.860   293.039     0.150
    21.898   296.125     0.150
    25.691   333.891     0.150
    26.029   335.695     0.150
    27.255   345.008     0.150
    33.814   401.570     0.150
     0.284     8.156     0.150
     0.284    12.953     0.150
     0.434    10.785     0.150
     0.434    17.676     0.150
     0.605    12.305     0.150
     0.605    20.816     0.150
     1.039    19.883     0.150
     1.003    31.348     0.150
     1.076    20.535     0.150
     1.076    35.945     0.150
     1.253    23.793     0.150
     1.396    25.094     0.150
     1.396    44.641     0.150
     1.324    24.422     0.150
     1.324    42.727     0.150
     1.539    29.004     0.150
     2.007    31.715     0.150
     2.188    33.055     0.150
     2.229    36.168     0.150
     2.229    63.785     0.150
     2.455    37.516     0.150
     2.455    67.066     0.150
     2.963    44.402     0.150
     2.963    78.551     0.150
     3.260    47.938     0.150
     3.260    86.363     0.150
     3.901    58.051     0.150
     3.901   102.133     0.150
     3.945    57.645     0.150
     3.945   101.746     0.150
     3.973    59.789     0.150
     3.973   103.695     0.150
     3.972    57.945     0.150
     3.972   101.348     0.150
     3.979    59.113     0.150
     3.979   101.047     0.150
     3.995    62.066     0.150
     3.995   108.422     0.150
     4.062    62.043     0.150
     4.062   104.957     0.150
     4.306    63.445     0.150
     4.306   110.145     0.150
     4.372   114.047     0.150
     4.558    65.938     0.150
     4.558   114.477     0.150
     4.558    67.047     0.150
     4.558   116.848     0.150
     4.586    67.746     0.150
     4.586   116.645     0.150
     4.919    71.129     0.150
     4.919   124.820     0.150
     4.922    71.848     0.150
     4.922   125.348     0.150
     5.194    76.246     0.150
     5.194   132.047     0.150
     5.303    79.754     0.150
     5.449   138.020     0.150
     5.597   140.246     0.150
     5.613   141.836     0.150
     5.651   142.848     0.150
     5.783   147.613     0.150
     6.009   150.176     0.150
     0.183     5.445     0.150
     0.183     9.219     0.150
     0.857    17.328     0.150
     0.857    29.422     0.150
     1.110    20.914     0.150
     1.110    35.484     0.150
     1.079    20.961     0.150
     1.079    35.367     0.150
     1.073    20.898     0.150
     1.073    36.758     0.150
     1.204    23.391     0.150
     1.204    40.070     0.150
     1.681    29.789     0.150
     1.681    51.961     0.150
     1.757    31.180     0.150
     1.757    55.727     0.150
     1.866    33.945     0.150
     1.866    59.359     0.150
     2.068    36.883     0.150
     2.068    59.977     0.150
     2.278    69.820     0.150
     2.433    42.172     0.150
     5.882    86.859     0.150
     5.882   150.859     0.150
     5.963    87.961     0.150
     5.963   152.062     0.150
     6.019    88.836     0.150
     6.019   152.547     0.150
     6.064    89.016     0.150
     6.064   154.008     0.150
     6.117   156.977     0.150
     6.117   157.258     0.150
     6.196   158.758     0.150
     6.272   160.062     0.150
     6.239   157.828     0.150
     6.520   166.961     0.150
     6.868   100.359     0.150
     6.868   174.461     0.150
     7.086   103.859     0.150
     7.086   177.211     0.150
     7.310   184.859     0.150
     7.808   197.156     0.150
     0.384     8.534     0.150
     0.384    13.119     0.150
     0.524    11.514     0.150
     0.524    17.679     0.150
     0.604    13.169     0.150
     0.604    20.285     0.150
     1.690    30.716     0.150
     1.690    55.433     0.150
     2.021    36.232     0.150
     2.021    64.653     0.150
     2.139    36.676     0.150
     2.139    63.439     0.150
     2.399    43.424     0.150
     2.713    49.229     0.150
     2.713    82.914     0.150
     2.662    45.724     0.150
     2.662    78.265     0.150
     2.949    50.929     0.150
     2.949    87.386     0.150
     3.346    55.548     0.150
     3.346    92.616     0.150
     3.321    53.810     0.150
     3.321    95.213     0.150
     4.155    66.257     0.150
     4.155   115.028     0.150
     4.595    70.477     0.150
     4.595   120.877     0.150
     4.638    70.777     0.150
     4.638   121.277     0.150
     4.642   124.787     0.150
     4.660    70.107     0.150
     4.701   124.425     0.150
     4.777    74.495     0.150
     4.777   125.185     0.150
     4.950    74.277     0.150
     4.967    75.377     0.150
     4.967   129.977     0.150
     4.989    75.277     0.150
     4.989   130.977     0.150
     5.212    78.477     0.150
     5.219    78.477     0.150
     5.219   135.677     0.150
     5.579    83.677     0.150
     5.635    84.145     0.150
     5.635   143.227     0.150
     5.899    87.677     0.150
     6.289    93.477     0.150
     6.366    94.077     0.150
     6.776    99.977     0.150
     0.103     4.543     0.150
     0.103     7.043     0.150
     0.492    10.783     0.150
     0.492    16.855     0.150
     0.688    13.553     0.150
     0.778    15.012     0.150
     1.371    26.064     0.150
     1.371    44.943     0.150
     1.365    25.141     0.150
     1.512    28.930     0.150
     1.611    29.168     0.150
     1.611    51.527     0.150
     1.611    28.873     0.150
     1.602    30.572     0.150
     1.602    53.047     0.150
     1.744    55.072     0.150
     1.816    32.352     0.150
     1.816    55.766     0.150
     1.904    34.516     0.150
     1.904    58.869     0.150
     2.028    35.465     0.150
     2.174    36.518     0.150
     2.174    67.748     0.150
     2.189    37.053     0.150
     2.189    65.783     0.150
     2.387    40.811     0.150
     2.387    66.279     0.150
     2.388    40.232     0.150
     2.388    70.162     0.150
     2.372    38.795     0.150
     2.372    72.568     0.150
     2.450    45.059     0.150
     2.450    71.635     0.150
     2.458    46.361     0.150
     2.458    75.043     0.150
     2.458    45.182     0.150
     2.503    40.549     0.150
     2.503    71.076     0.150
     2.649    43.193     0.150
     2.538    42.109     0.150
     2.774    45.559     0.150
     2.774    84.961     0.150
     3.003    48.967     0.150
     3.003    92.994     0.150
     2.944    48.297     0.150
     2.904    81.510     0.150
     2.904    80.742     0.150
     2.967    48.312     0.150
     2.967    87.812     0.150
     2.957    48.812     0.150
     2.957    81.812     0.150
     3.044    49.812     0.150
     3.044    90.812     0.150
     3.039    46.650     0.150
     3.039    81.801     0.150
     3.095    50.523     0.150
     3.347    52.961     0.150
     3.347   101.465     0.150
     3.264    50.162     0.150
     3.264    88.342     0.150
     3.389    53.312     0.150
     3.436    55.041     0.150
     3.436   108.123     0.150
     3.408    53.561     0.150
     3.408    92.143     0.150
     3.521    54.652     0.150
     3.521    94.525     0.150
     3.651    57.266     0.150
     3.651    99.082     0.150
     3.784    59.051     0.150
     3.784   102.576     0.150
     3.784   103.812     0.150
     3.888    61.381     0.150
     3.888   106.643     0.150
     4.163    62.777     0.150
     4.163   127.639     0.150
     4.131    64.127     0.150
     4.131   109.459     0.150
     4.131   110.463     0.150
     4.296    65.693     0.150
     4.296   135.918     0.150
     4.258    67.637     0.150
     4.258    67.213     0.150
     4.317    65.113     0.150
     4.282    75.812     0.150
     4.413    66.412     0.150
     4.413   115.012     0.150
     4.459    67.023     0.150
     4.459   115.512     0.150
     4.459    66.773     0.150
     4.459   115.402     0.150
     4.446    66.680     0.150
     4.446   116.307     0.150
     4.397    77.812     0.150
     4.482    67.320     0.150
     4.482   116.184     0.150
     4.553    68.150     0.150
     4.553   117.168     0.150
     4.553    69.172     0.150
     4.553   119.512     0.150
     4.549    71.199     0.150
     4.549   123.617     0.150
     4.645    70.170     0.150
     4.645   120.529     0.150
     4.767    71.111     0.150
     4.767   124.775     0.150
     4.767    71.213     0.150
     4.767   125.693     0.150
     4.786    72.012     0.150
     4.786   124.213     0.150
     4.806    71.992     0.150
     4.806   125.412     0.150
     4.925    74.312     0.150
     4.925   126.812     0.150
     4.868    87.812     0.150
     5.029    75.412     0.150
     5.029   130.812     0.150
     5.038    74.973     0.150
     5.038   130.512     0.150
     5.058    76.012     0.150
     5.058   129.812     0.150
     5.001    78.113     0.150
     5.001   134.742     0.150
     5.001    77.234     0.150
     5.144    88.812     0.150
     5.203    77.842     0.150
     5.203   133.682     0.150
     5.285   137.168     0.150
     5.280    89.812     0.150
     5.280    81.355     0.150
     5.399    80.412     0.150
     5.399   139.113     0.150
     5.467    81.000     0.150
     5.467   140.137     0.150
     5.577    84.512     0.150
     5.726    85.053     0.150
     5.726   147.312     0.150
     5.726    84.803     0.150
     5.825    88.898     0.150
     5.825   153.629     0.150
     6.032    88.656     0.150
     6.032   152.811     0.150
     6.032    89.002     0.150
     6.032   152.422     0.150
     6.113    90.113     0.150
     6.113   156.812     0.150
     6.171   161.312     0.150
     6.197    91.213     0.150
     6.197   156.912     0.150
     6.194    91.488     0.150
     6.194   157.262     0.150
     6.194    91.350     0.150
     6.273   166.492     0.150
     6.427    95.180     0.150
     6.427   164.883     0.150
     6.584    96.725     0.150
     6.584   164.928     0.150
     6.608    96.812     0.150
     6.608   166.512     0.150
     6.669    97.912     0.150
     6.669   170.412     0.150
     6.711    98.613     0.150
     6.711   170.012     0.150
     6.915   101.922     0.150
     7.092   103.713     0.150
     7.092   178.912     0.150
     7.064   108.012     0.150
     7.156   104.512     0.150
     7.156   181.113     0.150
     7.156   104.203     0.150
     7.156   181.232     0.150
     7.137   104.611     0.150
     7.137   179.117     0.150
     7.207   105.412     0.150
     7.207   182.213     0.150
     7.207   103.932     0.150
     7.207   184.352     0.150
     7.390   107.861     0.150
     7.421   112.113     0.150
     7.539   109.412     0.150
     7.539   190.012     0.150
     7.510   110.840     0.150
     7.510   191.961     0.150
     7.510   193.072     0.150
     7.651   112.660     0.150
     7.651   192.287     0.150
     7.729   197.625     0.150
     7.794   112.971     0.150
     7.794   195.531     0.150
     8.031   201.312     0.150
     8.507   124.898     0.150
     8.507   211.977     0.150
     8.515   123.213     0.150
     8.515   212.213     0.150
     8.513   123.301     0.150
     8.513   212.316     0.150
     8.672   124.490     0.150
     8.672   216.465     0.150
     8.813   127.213     0.150
     8.845   128.496     0.150
     9.089   130.354     0.150
     9.089   225.773     0.150
     9.494   234.613     0.150
     9.762   140.227     0.150
     9.762   241.277     0.150
     9.762   140.602     0.150
     9.769   141.201     0.150
     9.769   241.984     0.150
     9.792   245.514     0.150
     9.912   142.256     0.150
     9.912   246.072     0.150
     9.930   143.201     0.150
    10.021   250.912     0.150
     9.988   145.812     0.150
     9.988   246.512     0.150
    10.021   146.512     0.150
    10.021   247.012     0.150
    10.060   145.936     0.150
    10.060   249.793     0.150
    10.074   146.424     0.150
    10.074   257.377     0.150
    10.125   147.158     0.150
    10.125   253.748     0.150
    10.244   256.908     0.150
    10.244   150.213     0.150
    10.244   256.613     0.150
    10.244   148.652     0.150
    10.244   258.133     0.150
    10.375   151.613     0.150
    10.375   255.113     0.150
    11.191   161.852     0.150
    12.025   174.838     0.150
    12.025   174.562     0.150
    13.008   186.562     0.150
    13.293   186.812     0.150
    13.564   190.713     0.150
    13.852   196.643     0.150
    14.157   197.412     0.150
    14.229   199.812     0.150
    14.229   348.512     0.150
    14.327   205.113     0.150
    14.444   352.412     0.150
    14.697   210.512     0.150
    14.735   211.012     0.150
    14.829   361.113     0.150
    14.854   361.412     0.150
    14.988   209.713     0.150
    14.993   209.613     0.150
    15.171   369.012     0.150
    15.282   218.012     0.150
    15.492   219.613     0.150
    15.492   377.312     0.150
    15.563   221.812     0.150
    16.492   233.213     0.150
    16.800   237.512     0.150
    16.843   237.912     0.150
    17.030   239.812     0.150
    17.286   242.523     0.150
    17.416   245.320     0.150
    17.497   244.883     0.150
    17.773   251.734     0.150
    17.868   250.512     0.150
    17.850   249.662     0.150
    18.084   251.113     0.150
    18.626   260.633     0.150
    19.388   264.863     0.150
    20.007   272.703     0.150
    20.114   278.652     0.150
    20.373   279.387     0.150
    20.567   279.113     0.150
    20.711   281.553     0.150
    20.711   280.137     0.150
    20.711   281.432     0.150
    20.712   283.211     0.150
    20.838   283.912     0.150
    20.838   282.543     0.150
    21.101   284.602     0.150
    21.409   287.762     0.150
    21.595   289.742     0.150
    21.825   292.123     0.150
    21.825   291.932     0.150
    21.843   291.188     0.150
    21.947   295.912     0.150
    22.486   300.057     0.150
    22.667   303.572     0.150
    22.911   303.352     0.150
    23.060   304.613     0.150
    23.262   308.283     0.150
    25.082   327.203     0.150
    25.463   331.613     0.150
    26.534   337.658     0.150
    26.534   338.963     0.150
    26.722   340.537     0.150
    26.727   341.752     0.150
    27.030   342.613     0.150
    27.504   349.543     0.150
    29.316   363.111     0.150
    31.448   383.922     0.150
    31.448   383.713     0.150
    31.448   383.963     0.150
    34.324   406.508     0.150
    34.324   406.682     0.150
    38.313   440.863     0.150
    50.570   541.463     0.150
    50.570   541.412     0.150
    61.099   614.182     0.150
    61.096   616.293     0.150
    63.582   631.262     0.150
    64.754   639.363     0.150
    64.754   637.938     0.150
    64.754   639.203     0.150
    69.099   666.537     0.150
    77.585   718.113     0.150
    78.413   722.139     0.150
     0.938    19.348     0.150
     0.938    32.234     0.150
     1.022    20.906     0.150
     1.022    36.984     0.150
     1.151    23.305     0.150
     1.151    42.195     0.150
     1.242    24.758     0.150
     1.242    45.031     0.150
     1.442    29.020     0.150
     1.572    30.441     0.150
     1.572    52.023     0.150
     2.195    39.996     0.150
     2.195    68.332     0.150
     2.287    43.832     0.150
     2.350    74.359     0.150
     2.708    46.656     0.150
     2.708    80.598     0.150
     2.816    47.773     0.150
     2.816    85.492     0.150
     2.772    47.781     0.150
     2.772    85.258     0.150
     2.980    53.945     0.150
     2.980    92.285     0.150
     3.034    59.156     0.150
     3.034    98.449     0.150
     3.210    55.215     0.150
     3.755    61.707     0.150
     4.445    70.910     0.150
     0.096     4.098     0.150
     0.096     6.547     0.150
     0.202     6.082     0.150
     0.202     9.336     0.150
     0.496    10.496     0.150
     0.626    13.832     0.150
     1.364    25.715     0.150
     1.364    45.070     0.150
     1.367    25.332     0.150
     1.504    27.625     0.150
     1.603    28.676     0.150
     1.596    29.598     0.150
     1.822    33.809     0.150
     1.822    56.402     0.150
     1.742    31.895     0.150
     1.903    33.754     0.150
     1.903    60.559     0.150
     2.021    34.840     0.150
     2.021    34.227     0.150
     2.196    38.492     0.150
     2.196    65.859     0.150
     2.168    37.695     0.150
     2.186    64.031     0.150
     2.373    38.199     0.150
     2.373    73.004     0.150
     2.382    40.285     0.150
     2.382    68.828     0.150
     2.451    44.141     0.150
     2.451    75.871     0.150
     2.459    45.492     0.150
     2.459    75.793     0.150
     2.459    46.027     0.150
     2.459    74.984     0.150
     2.507    40.066     0.150
     2.507    77.051     0.150
     2.547    78.344     0.150
     2.644    43.629     0.150
     2.777    46.305     0.150
     2.777    83.918     0.150
     2.904    80.332     0.150
     3.004    48.430     0.150
     3.004    93.621     0.150
     2.938    46.965     0.150
     3.034    46.328     0.150
     3.034    80.734     0.150
     3.345    52.398     0.150
     3.345   103.629     0.150
     3.440    55.523     0.150
     3.440   105.980     0.150
     3.384    53.656     0.150
     3.384    91.656     0.150
     3.402    53.383     0.150
     3.402    89.023     0.150
     3.518    53.945     0.150
     3.518    93.707     0.150
     3.648    58.086     0.150
     3.648    97.906     0.150
     3.783    57.672     0.150
     3.783   101.562     0.150
     3.885    62.215     0.150
     3.885   104.945     0.150
     4.161    62.613     0.150
     4.161   126.953     0.150
     4.291    65.012     0.150
     4.291   135.781     0.150
     4.312    65.160     0.150
     4.405    65.957     0.150
     4.405   115.055     0.150
     4.439    66.305     0.150
     4.439   114.922     0.150
     4.450    66.297     0.150
     4.450    66.555     0.150
     4.450   115.656     0.150
     4.474    66.914     0.150
     4.474   115.445     0.150
     4.547    68.703     0.150
     4.547   116.406     0.150
     4.547    70.418     0.150
     4.547   121.605     0.150
     4.641    69.703     0.150
     4.641   119.797     0.150
     4.758    70.695     0.150
     4.758   123.117     0.150
     4.758    71.559     0.150
     4.758   124.355     0.150
     4.778    71.855     0.150
     4.778   124.055     0.150
     4.797    71.246     0.150
     4.797   122.727     0.150
     4.797    71.457     0.150
     4.797   125.457     0.150
     4.918    73.758     0.150
     4.918   126.855     0.150
     5.020    74.855     0.150
     5.020   130.355     0.150
     4.999    77.016     0.150
     4.999   132.938     0.150
     4.999    77.734     0.150
     4.999   133.902     0.150
     5.030    74.266     0.150
     5.030   127.555     0.150
     5.030    74.457     0.150
     5.030   130.355     0.150
     5.050    75.457     0.150
     5.050   130.156     0.150
     5.390    79.457     0.150
     5.390   138.855     0.150
     5.460    81.023     0.150
     5.460   138.984     0.150
     5.551    81.957     0.150
     5.551   142.855     0.150
     5.719    84.465     0.150
     5.719   147.457     0.150
     5.824    89.574     0.150
     5.824   151.328     0.150
     6.028    88.535     0.150
     6.028   151.773     0.150
     6.105    89.758     0.150
     6.105   156.258     0.150
     6.190    90.957     0.150
     6.190   156.855     0.150
     6.190    90.805     0.150
     6.190   156.555     0.150
     6.190    91.270     0.150
     6.190   156.793     0.150
     6.419    94.105     0.150
     6.419   162.426     0.150
     6.419    94.855     0.150
     6.577    96.293     0.150
     6.577   164.457     0.150
     6.601    96.656     0.150
     6.601   166.258     0.150
     6.662    97.758     0.150
     6.662   168.656     0.150
     6.703    98.355     0.150
     6.703   171.156     0.150
     7.084   103.355     0.150
     7.084   180.457     0.150
     7.149   104.457     0.150
     7.149   180.656     0.150
     7.511   110.789     0.150
     7.532   109.355     0.150
     7.532   190.457     0.150
     7.649   112.016     0.150
     7.649   192.098     0.150
     7.787   112.688     0.150
     7.787   195.957     0.150
     8.025   116.355     0.150
     8.025   200.855     0.150
     8.373   120.758     0.150
     8.373   210.457     0.150
     8.508   123.055     0.150
     8.507   122.766     0.150
     8.507   210.184     0.150
     8.665   124.785     0.150
     8.665   213.445     0.150
     8.806   126.957     0.150
     8.806   219.355     0.150
     9.082   130.867     0.150
     9.757   139.766     0.150
     9.757   240.117     0.150
     9.905   141.684     0.150
     9.924   142.746     0.150
    10.057   145.828     0.150
    10.057   249.984     0.150
    20.711   280.008     0.150
    21.191   285.805     0.150
     0.221     6.031     0.150
     0.448    10.375     0.150
     0.448    17.129     0.150
     0.615    13.270     0.150
     0.615    21.793     0.150
     0.716    14.559     0.150
     0.716    24.273     0.150
     1.444    27.238     0.150
     1.444    46.000     0.150
     1.357    26.039     0.150
     1.357    44.215     0.150
     1.595    29.191     0.150
     1.595    51.707     0.150
     1.671    31.926     0.150
     1.671    52.477     0.150
     2.135    36.270     0.150
     2.135    64.156     0.150
     2.733    46.465     0.150
     2.733    79.887     0.150
     2.994    51.961     0.150
     2.994    88.703     0.150
     3.365    54.156     0.150
     3.365    93.438     0.150
     4.500    67.062     0.150
     4.500   117.961     0.150
     4.543    68.262     0.150
     4.543   116.262     0.150
     4.857    72.961     0.150
     4.872    72.762     0.150
     4.872   125.363     0.150
     5.117    76.363     0.150
     5.484    81.262     0.150
     5.484   141.961     0.150
     5.641    82.863     0.150
     5.805    85.660     0.150
     6.194    90.062     0.150
     6.273    91.660     0.150
     0.474    10.828     0.150
     0.474    17.453     0.150
     0.649    13.607     0.150
     1.560    29.934     0.150
     1.560    50.635     0.150
     1.637    29.740     0.150
     1.637    53.951     0.150
     1.901    35.568     0.150
     1.901    60.832     0.150
     2.082    37.809     0.150
     2.082    64.826     0.150
     2.139    37.553     0.150
     2.139    65.758     0.150
     2.478    44.576     0.150
     2.478    72.295     0.150
     2.692    50.135     0.150
     2.692    82.768     0.150
     2.760    49.449     0.150
     2.760    82.443     0.150
     3.011    54.238     0.150
     3.011    91.545     0.150
     3.421    99.285     0.150
     4.187    72.346     0.150
     4.464    67.156     0.150
     4.464   118.857     0.150
     4.508    67.857     0.150
     4.508   117.156     0.150
     4.822    73.656     0.150
     4.836    73.256     0.150
     4.860    73.256     0.150
     4.860   129.756     0.150
     5.082    76.857     0.150
     5.082   132.256     0.150
     5.088    76.957     0.150
     5.088   132.457     0.150
     5.106    77.557     0.150
     5.449    81.457     0.150
     5.449   142.057     0.150
     5.606    83.256     0.150
     5.769    85.457     0.150
     6.159    90.857     0.150
     6.159   157.756     0.150
     6.238    92.256     0.150
     6.649    97.656     0.150
     0.163     4.464     0.150
     0.495    11.326     0.150
     0.495    17.787     0.150
     0.664    14.244     0.150
     0.664    24.248     0.150
     0.668    13.619     0.150
     0.751    15.286     0.150
     0.751    24.874     0.150
     1.328    44.836     0.150
     1.544    29.668     0.150
     1.544    50.719     0.150
     1.729    32.104     0.150
     1.881    34.746     0.150
     1.881    60.862     0.150
     2.087    38.010     0.150
     2.087    63.830     0.150
     2.087    35.354     0.150
     2.087    65.294     0.150
     2.188    38.604     0.150
     2.188    67.688     0.150
     2.167    38.900     0.150
     2.167    68.281     0.150
     2.334    42.165     0.150
     2.334    70.359     0.150
     2.479    42.165     0.150
     2.479    73.920     0.150
     2.703    47.804     0.150
     2.703    84.010     0.150
     2.780    48.100     0.150
     2.780    82.526     0.150
     3.040    47.074     0.150
     3.040    80.614     0.150
     3.030    53.442     0.150
     3.030    92.023     0.150
     3.389    56.113     0.150
     3.389    96.475     0.150
     3.441    55.223     0.150
     3.441    96.178     0.150
     3.507    53.984     0.150
     3.507    92.104     0.150
     3.644    99.634     0.150
     3.762   100.932     0.150
     4.203    66.797     0.150
     4.203   111.907     0.150
     4.468    67.452     0.150
     4.468   114.642     0.150
     4.492    66.874     0.150
     4.492   115.774     0.150
     4.513    67.644     0.150
     4.513   115.244     0.150
     4.534    70.294     0.150
     4.534   121.884     0.150
     4.562    69.214     0.150
     4.562   116.634     0.150
     4.646   120.042     0.150
     4.809    71.574     0.150
     4.809   123.084     0.150
     4.809    71.674     0.150
     4.809   125.774     0.150
     4.821    72.474     0.150
     4.821   125.474     0.150
     4.846    72.874     0.150
     4.982   134.034     0.150
     5.068    76.074     0.150
     5.068   131.874     0.150
     5.073    74.854     0.150
     5.073   129.164     0.150
     5.073    76.474     0.150
     5.073   131.474     0.150
     5.434    80.874     0.150
     5.434   140.674     0.150
     5.489    81.414     0.150
     5.489   139.774     0.150
     5.752    85.074     0.150
     5.752   147.774     0.150
     6.032    89.492     0.150
     6.032   152.070     0.150
     6.142   157.774     0.150
     6.220    91.674     0.150
     6.220   158.774     0.150
     6.596    96.714     0.150
     6.630    97.074     0.150
     6.741    99.074     0.150
     0.226     5.309     0.150
     0.543    11.605     0.150
     0.667    14.789     0.150
     0.667    24.543     0.150
     0.691    14.242     0.150
     0.764    15.785     0.150
     1.493    49.707     0.150
     1.544    29.410     0.150
     1.719    53.691     0.150
     1.825    35.773     0.150
     1.847    34.957     0.150
     1.847    58.191     0.150
     2.151    36.078     0.150
     2.151    65.980     0.150
     2.165    70.527     0.150
     2.184    40.129     0.150
     2.184    67.926     0.150
     3.003    48.316     0.150
     3.003    81.445     0.150
     3.003    47.730     0.150
     3.456    54.348     0.150
     3.456    94.121     0.150
     3.705    57.816     0.150
     3.705   100.484     0.150
     3.822    60.984     0.150
     3.822   105.566     0.150
     4.453    68.570     0.150
     4.453   117.570     0.150
     4.455    67.316     0.150
     4.455   115.906     0.150
     4.455   116.598     0.150
     4.492    68.570     0.150
     4.492   116.867     0.150
     4.492    67.418     0.150
     4.510    68.398     0.150
     4.510   116.867     0.150
     4.482    71.934     0.150
     4.482   123.363     0.150
     4.533   118.734     0.150
     4.608    70.945     0.150
     4.608   120.246     0.150
     4.608    69.680     0.150
     4.822    71.613     0.150
     4.822   125.082     0.150
     4.822    73.668     0.150
     4.822   127.270     0.150
     4.822    73.668     0.150
     4.822   125.969     0.150
     4.856    72.707     0.150
     4.856    73.570     0.150
     4.856   127.668     0.150
     4.928    74.645     0.150
     4.928   133.379     0.150
     5.077    77.070     0.150
     5.075    75.391     0.150
     5.075    77.168     0.150
     5.075   133.070     0.150
     5.436    81.570     0.150
     5.436   140.969     0.150
     5.474    82.266     0.150
     5.474   140.891     0.150
     5.584    83.570     0.150
     5.584   142.770     0.150
     5.742    86.570     0.150
     5.742   148.367     0.150
     5.993   152.742     0.150
     5.993    89.207     0.150
     6.136    91.168     0.150
     6.150   156.598     0.150
     6.150    91.277     0.150
     6.206    92.367     0.150
     6.206   158.570     0.150
     6.616    97.867     0.150
     6.738    99.367     0.150
     7.097   179.266     0.150
     7.097   179.539     0.150
     7.161   106.168     0.150
     7.161   104.590     0.150
     7.789   113.340     0.150
     7.789   195.137     0.150
     7.789   197.270     0.150
    16.693   237.289     0.150
    17.043   239.578     0.150
     0.776    27.953     0.150
     0.834    16.965     0.150
     0.834    28.688     0.150
     0.874    18.711     0.150
     0.874    31.598     0.150
     1.374    26.805     0.150
     1.374    45.156     0.150
     1.505    29.230     0.150
     1.610    31.352     0.150
     1.610    53.465     0.150
     1.713    57.277     0.150
     1.796    34.359     0.150
     1.796    58.770     0.150
     1.963    37.113     0.150
     1.963    64.703     0.150
     2.274    40.926     0.150
     2.283    40.465     0.150
     2.283    70.758     0.150
     5.204    78.797     0.150
     5.292    79.797     0.150
     5.507    84.000     0.150
     5.596    85.098     0.150
     5.596   146.797     0.150
     6.188    93.098     0.150
     6.993   103.500     0.150
     7.166   106.797     0.150
     0.802    16.426     0.150
     0.802    29.547     0.150
     0.880    19.074     0.150
     0.863    16.979     0.150
     0.863    30.062     0.150
     0.943    18.881     0.150
     0.943    33.018     0.150
     1.198    24.379     0.150
     1.198    42.769     0.150
     1.517    29.362     0.150
     1.597    31.660     0.150
     1.770    34.042     0.150
     1.770    34.199     0.150
     1.770    34.360     0.150
     1.770    59.775     0.150
     1.730    33.730     0.150
     1.730    58.965     0.150
     1.938    36.299     0.150
     1.938    63.905     0.150
     1.910    62.942     0.150
     2.253    40.534     0.150
     2.260    40.754     0.150
     2.491    44.350     0.150
     2.572    44.569     0.150
     3.036    51.854     0.150
     2.985    87.959     0.150
     3.087    51.613     0.150
     3.147    52.583     0.150
     3.147    92.868     0.150
     3.293    54.078     0.150
     3.293    95.134     0.150
     3.457    55.887     0.150
     3.457    95.880     0.150
     3.509   100.189     0.150
     3.568    56.995     0.150
     4.057    65.329     0.150
     4.057   109.309     0.150
     4.225    65.907     0.150
     4.225   115.534     0.150
     4.476    70.946     0.150
     4.476   122.748     0.150
     4.472    69.959     0.150
     4.472   119.969     0.150
     4.760    73.547     0.150
     4.760   129.496     0.150
     4.871    76.059     0.150
     5.028    79.782     0.150
     5.028   135.822     0.150
     5.127    80.873     0.150
     5.127   138.817     0.150
     5.208    78.809     0.150
     5.208   136.709     0.150
     5.297    79.809     0.150
     5.297   139.209     0.150
     5.361    80.792     0.150
     5.361   139.705     0.150
     5.425    81.880     0.150
     5.425   141.500     0.150
     5.425   142.409     0.150
     5.439    82.357     0.150
     5.439   142.471     0.150
     5.508    82.879     0.150
     5.508    83.309     0.150
     5.508   143.909     0.150
     5.600    85.409     0.150
     5.600   146.609     0.150
     5.678    85.906     0.150
     5.678   148.315     0.150
     5.747    87.009     0.150
     5.747   149.809     0.150
     5.846    87.359     0.150
     5.846    87.909     0.150
     5.846   152.109     0.150
     5.790    89.307     0.150
     5.829    87.351     0.150
     5.829   152.117     0.150
     5.893    89.909     0.150
     5.893   153.309     0.150
     6.191    92.209     0.150
     6.191   160.909     0.150
     6.438    96.109     0.150
     6.457    96.230     0.150
     6.457   165.922     0.150
     6.665    99.009     0.150
     6.665   172.209     0.150
     6.999   103.609     0.150
     6.999   181.409     0.150
     7.067   107.158     0.150
     7.174   106.109     0.150
     7.174   183.509     0.150
     7.203   106.632     0.150
     7.203   185.185     0.150
     7.203   106.909     0.150
     7.203   186.509     0.150
     7.217   107.021     0.150
     7.217   183.454     0.150
     7.394   109.766     0.150
     7.394   189.735     0.150
     7.590   112.109     0.150
     7.590   193.709     0.150
     7.672   196.676     0.150
     8.148   119.409     0.150
     8.148   208.209     0.150
     8.513   125.609     0.150
     8.835   129.329     0.150
     8.835   224.322     0.150
     8.887   130.065     0.150
     9.031   131.909     0.150
     9.444   138.309     0.150
     9.504   139.109     0.150
     9.580   140.073     0.150
     9.580   242.413     0.150
     9.663   141.313     0.150
     9.663   243.226     0.150
     0.310     6.146     0.150
     0.336     7.373     0.150
     0.336    11.683     0.150
     0.557    12.306     0.150
     0.557    21.125     0.150
     0.840    17.851     0.150
     0.840    29.872     0.150
     1.033    20.979     0.150
     1.033    34.300     0.150
     1.185    22.435     0.150
     1.185    38.807     0.150
     1.873    34.814     0.150
     2.351    42.921     0.150
     2.351    71.786     0.150
     2.352    41.882     0.150
     2.364    40.771     0.150
     2.364    72.561     0.150
     2.364    40.649     0.150
     2.364    69.660     0.150
     2.515    43.230     0.150
     2.515    76.531     0.150
     2.506    45.688     0.150
     2.506    80.287     0.150
     2.657    82.408     0.150
     2.958    49.587     0.150
     2.958    87.188     0.150
     3.717   111.920     0.150
     5.378    81.090     0.150
     5.378   139.790     0.150
     5.436    81.689     0.150
     5.436   140.390     0.150
     5.740    86.390     0.150
     5.740   148.790     0.150
     6.009    89.890     0.150
     0.356     7.715     0.150
     0.356    12.844     0.150
     0.551    11.973     0.150
     0.551    21.590     0.150
     0.638    13.133     0.150
     0.638    21.418     0.150
     0.787    29.547     0.150
     1.221    25.051     0.150
     1.221    43.254     0.150
     1.623    29.973     0.150
     1.623    53.355     0.150
     1.657    32.586     0.150
     1.657    55.277     0.150
     1.683    56.105     0.150
     1.821    59.234     0.150
     1.959    34.914     0.150
     1.959    59.609     0.150
     2.106    39.285     0.150
     2.106    67.129     0.150
     2.278    71.898     0.150
     2.219    69.441     0.150
     2.286    68.254     0.150
     2.303    39.797     0.150
     2.303    71.793     0.150
     2.810    47.180     0.150
     2.810    84.570     0.150
     2.877    89.586     0.150
     3.121    51.555     0.150
     3.121    97.031     0.150
     3.053    87.164     0.150
     3.465   101.957     0.150
     3.524    56.094     0.150
     3.524   103.297     0.150
     3.487    55.250     0.150
     3.487    95.035     0.150
     3.469    55.852     0.150
     3.469    96.676     0.150
     3.696    58.953     0.150
     3.696   103.133     0.150
     4.334    69.617     0.150
     4.334   125.867     0.150
     4.568    70.684     0.150
     4.568   118.883     0.150
     4.546    70.113     0.150
     4.546   120.961     0.150
     4.489    72.570     0.150
     4.489   122.074     0.150
     4.603    69.785     0.150
     4.603    71.488     0.150
     4.616    70.035     0.150
     4.616   121.742     0.150
     4.598    71.574     0.150
     4.598   122.734     0.150
     4.654    71.551     0.150
     4.654   124.613     0.150
     4.947    75.164     0.150
     4.947   129.922     0.150
     4.947    75.883     0.150
     4.947   131.383     0.150
     4.935    75.184     0.150
     4.935   128.582     0.150
     5.197    78.984     0.150
     5.197   136.684     0.150
     5.550    83.582     0.150
     5.550   143.684     0.150
     5.564    83.891     0.150
     5.564   144.414     0.150
     5.689    85.582     0.150
     5.689   146.984     0.150
     5.838    87.184     0.150
     6.036    91.457     0.150
     6.036   156.871     0.150
     6.239    92.582     0.150
     6.239   160.785     0.150
     6.704    99.383     0.150
     0.126     5.355     0.150
     0.126    10.254     0.150
     0.397     8.758     0.150
     0.397    16.082     0.150
     0.521    11.285     0.150
     0.521    19.918     0.150
     0.564    13.062     0.150
     0.564    20.336     0.150
     0.967    18.719     0.150
     0.967    33.434     0.150
     1.334    24.418     0.150
     1.334    40.840     0.150
     2.651    44.867     0.150
     2.651    78.902     0.150
     2.408    41.035     0.150
     2.408    73.531     0.150
     3.053    49.762     0.150
     3.053    84.688     0.150
     2.770    47.176     0.150
     2.770    86.789     0.150
     4.697    68.703     0.150
     4.697   120.902     0.150
     4.754    69.902     0.150
     4.754   121.203     0.150
     4.789    71.113     0.150
     4.789   122.422     0.150
     4.782   120.820     0.150
     5.014   129.602     0.150
     4.918    72.180     0.150
     4.918   124.922     0.150
     5.066    74.801     0.150
     5.066   129.402     0.150
     5.077    75.602     0.150
     5.077   129.500     0.150
     5.294    78.602     0.150
     5.294   135.102     0.150
     5.685    83.402     0.150
     5.685   144.703     0.150
     5.804    84.160     0.150
     5.804   145.992     0.150
     6.425    93.102     0.150
     6.425   161.703     0.150
     6.945   100.203     0.150
     6.943    99.742     0.150
     0.439     9.842     0.150
     0.867    17.500     0.150
     0.867    30.204     0.150
     0.851    16.837     0.150
     0.851    30.909     0.150
     0.766    16.142     0.150
     1.175    24.272     0.150
     1.175    43.577     0.150
     1.496    28.313     0.150
     1.496    49.812     0.150
     1.496    27.602     0.150
     1.450    27.083     0.150
     1.450    47.137     0.150
     1.711    30.219     0.150
     1.711    51.717     0.150
     1.566    29.007     0.150
     1.566    51.288     0.150
     2.312    43.431     0.150
     2.312    74.896     0.150
     2.414    78.436     0.150
     2.694    45.622     0.150
     2.694    78.622     0.150
     2.854    82.800     0.150
     2.728    45.638     0.150
     2.728    78.356     0.150
     2.939    50.171     0.150
     2.939    84.569     0.150
     2.906    51.103     0.150
     2.906    89.213     0.150
     3.374    53.941     0.150
     3.374    94.312     0.150
     3.188    52.101     0.150
     3.188    96.465     0.150
     3.399    56.562     0.150
     3.399    95.151     0.150
     3.221    58.190     0.150
     3.221    96.497     0.150
     3.277    95.303     0.150
     3.652    56.952     0.150
     3.652    98.552     0.150
     3.719    57.952     0.150
     3.719   100.151     0.150
     3.719    57.707     0.150
     3.765    59.069     0.150
     3.765   101.052     0.150
     3.753    61.430     0.150
     3.753   104.580     0.150
     3.813    58.850     0.150
     3.813   101.740     0.150
     4.011    63.751     0.150
     4.073    64.421     0.150
     4.073   109.702     0.150
     3.939    63.531     0.150
     3.939   111.022     0.150
     4.240    66.651     0.150
     4.240   114.151     0.150
     4.273    66.620     0.150
     4.400    70.832     0.150
     4.400   120.162     0.150
     4.641    70.452     0.150
     4.641   122.352     0.150
     4.846    73.751     0.150
     4.846   128.151     0.150
     5.405    81.151     0.150
     5.405   142.151     0.150
     5.553    83.452     0.150
     5.553   144.151     0.150
     5.665   147.660     0.150
     5.654    85.030     0.150
     5.654   144.750     0.150
     5.777    89.211     0.150
     5.777   154.262     0.150
     5.851    88.540     0.150
     5.851   151.464     0.150
     5.968    89.651     0.150
     6.048    91.102     0.150
     6.048   156.452     0.150
     7.207   106.802     0.150
     7.207   182.751     0.150
     7.433   109.901     0.150
     7.433   190.332     0.150
     7.952   117.030     0.150
     7.952   201.819     0.150
     8.041   117.912     0.150
     8.041   202.342     0.150
     0.408    10.070     0.150
     0.628    12.074     0.150
     0.620    12.645     0.150
     0.620    21.676     0.150
     0.632    13.219     0.150
     0.969    18.652     0.150
     0.969    32.465     0.150
     1.181    21.801     0.150
     1.181    37.246     0.150
     1.814    32.672     0.150
     1.814    54.695     0.150
     1.824    31.523     0.150
     1.824    52.121     0.150
     1.827    32.957     0.150
     1.827    53.840     0.150
     1.817    32.672     0.150
     1.817    56.125     0.150
     1.817    29.238     0.150
     1.817    51.164     0.150
     2.011    35.102     0.150
     2.011    61.234     0.150
     2.083    33.184     0.150
     2.083    58.129     0.150
     2.157    35.531     0.150
     2.157    62.703     0.150
     2.188    36.961     0.150
     2.188    64.992     0.150
     2.468    40.680     0.150
     2.468    71.859     0.150
     2.806    45.258     0.150
     2.806    76.723     0.150
     3.040    49.832     0.150
     3.490    54.043     0.150
     3.490    91.797     0.150
     3.452    94.457     0.150
     3.636    56.699     0.150
     3.636   101.035     0.150
     4.677    70.145     0.150
     4.677   118.992     0.150
     4.691    70.496     0.150
     4.691   121.395     0.150
     4.719    71.094     0.150
     4.769    70.277     0.150
     4.769   119.855     0.150
     0.451    10.168     0.150
     0.451    16.926     0.150
     0.565    12.555     0.150
     0.603    12.555     0.150
     0.603    21.160     0.150
     0.636    13.340     0.150
     0.636    22.203     0.150
     0.885    18.031     0.150
     0.885    31.070     0.150
     1.215    23.246     0.150
     1.215    39.672     0.150
     1.731    32.559     0.150
     1.731    50.367     0.150
     1.713    55.578     0.150
     1.750    31.070     0.150
     1.750    53.492     0.150
     1.760    30.809     0.150
     1.760    55.578     0.150
     1.839    31.852     0.150
     1.839    57.406     0.150
     1.900    30.809     0.150
     1.900    56.883     0.150
     2.041    36.805     0.150
     2.041    63.922     0.150
     2.203    38.109     0.150
     2.203    68.617     0.150
     2.188    37.328     0.150
     2.188    65.227     0.150
     2.259    39.414     0.150
     2.259    67.836     0.150
     2.365    38.371     0.150
     2.365    67.574     0.150
     2.788    47.234     0.150
     2.788    82.699     0.150
     2.947    50.625     0.150
     2.947    90.520     0.150
     3.496    52.508     0.150
     3.496    91.156     0.150
     3.560    93.426     0.150
     3.564    56.102     0.150
     3.668    54.609     0.150
     3.668    98.906     0.150
     3.707   101.074     0.150
     4.512    68.266     0.150
     4.512   119.379     0.150
     4.624    67.270     0.150
     4.624   116.625     0.150
     4.659    69.547     0.150
     4.659   119.957     0.150
     4.661    68.488     0.150
     4.661   119.988     0.150
     4.693    70.180     0.150
     4.693    68.586     0.150
     4.693   120.289     0.150
     4.702    70.395     0.150
     4.702   122.254     0.150
     4.704    68.656     0.150
     4.704   118.906     0.150
     5.026    73.789     0.150
     5.026   128.586     0.150
     5.045    74.207     0.150
     5.045   129.238     0.150
     5.045    74.387     0.150
     5.045   129.387     0.150
     5.075    74.387     0.150
     5.075   129.988     0.150
     5.281   134.586     0.150
     5.293   135.387     0.150
     5.641    82.188     0.150
     5.641   143.488     0.150
     6.082   152.547     0.150
     6.324    91.289     0.150
     6.324   160.188     0.150
     6.373    92.289     0.150
     6.373   161.688     0.150
     6.929   100.289     0.150
     0.165     4.605     0.150
     0.210     8.336     0.150
     0.460    10.980     0.150
     0.460    17.168     0.150
     0.634    13.289     0.150
     0.634    21.238     0.150
     0.695    13.941     0.150
     0.695    23.824     0.150
     1.355    25.844     0.150
     1.355    43.910     0.150
     1.429    27.051     0.150
     1.429    45.320     0.150
     1.574    29.574     0.150
     1.574    50.336     0.150
     1.652    31.059     0.150
     1.652    52.520     0.150
     2.083    34.375     0.150
     2.083    60.480     0.150
     2.143    63.305     0.150
     2.474    42.395     0.150
     2.474    74.137     0.150
     2.689    47.746     0.150
     2.689    83.512     0.150
     2.999    49.344     0.150
     2.999    90.969     0.150
     3.364    52.750     0.150
     3.364    96.570     0.150
     3.540    55.402     0.150
     3.540    94.414     0.150
     4.178    64.168     0.150
     4.178   115.578     0.150
     4.478    68.246     0.150
     4.478   117.344     0.150
     4.501    67.426     0.150
     4.501   116.785     0.150
     4.522    68.543     0.150
     4.522   116.445     0.150
     4.544    68.117     0.150
     4.544   117.270     0.150
     4.597    69.984     0.150
     4.597   118.449     0.150
     4.681    70.273     0.150
     4.681   120.465     0.150
     4.835    71.871     0.150
     4.835   124.480     0.150
     4.835    72.543     0.150
     4.835   123.145     0.150
     4.850   124.344     0.150
     4.873    73.246     0.150
     4.873   127.145     0.150
     5.096    76.543     0.150
     5.463    81.246     0.150
     5.463   141.145     0.150
     6.173    90.645     0.150
     6.173   157.043     0.150
     6.253    92.043     0.150
     6.253   158.246     0.150
     6.664    97.645     0.150
     7.845   113.188     0.150
     0.631    13.055     0.150
     0.631    22.605     0.150
     0.702    14.000     0.150
     0.818    16.141     0.150
     0.818    27.293     0.150
     0.996    19.910     0.150
     0.996    33.520     0.150
     1.192    22.863     0.150
     1.192    39.344     0.150
     1.288    24.602     0.150
     1.288    41.246     0.150
     1.288    25.121     0.150
     1.285    24.844     0.150
     1.285    42.523     0.150
     1.412    25.719     0.150
     1.412    45.070     0.150
     1.502    27.531     0.150
     1.912    33.945     0.150
     1.912    58.707     0.150
     2.010    37.809     0.150
     2.044    35.770     0.150
     2.044    62.910     0.150
     2.040    36.258     0.150
     2.040    63.805     0.150
     2.146    37.770     0.150
     2.146    66.324     0.150
     2.253    38.766     0.150
     2.253    68.777     0.150
     2.677    45.324     0.150
     2.677    76.812     0.150
     2.854    47.691     0.150
     2.854    83.848     0.150
     2.878    45.051     0.150
     2.878    80.227     0.150
     2.910    46.027     0.150
     2.910    83.090     0.150
     2.958    47.234     0.150
     2.958    83.805     0.150
     3.338    52.219     0.150
     3.338    92.746     0.150
     3.567    54.582     0.150
     3.567    98.773     0.150
     3.780    58.266     0.150
     3.780   102.910     0.150
     4.039   102.539     0.150
     4.115    61.484     0.150
     4.115   105.180     0.150
     4.400    65.520     0.150
     4.400   111.652     0.150
     6.367   159.590     0.150
     0.522    11.023     0.150
     0.898    18.385     0.150
     0.898    30.955     0.150
     0.893    17.654     0.150
     0.893    33.314     0.150
     1.008    19.986     0.150
     1.008    35.740     0.150
     1.091    21.643     0.150
     1.091    38.920     0.150
     1.350    27.020     0.150
     1.350    44.883     0.150
     1.403    27.094     0.150
     1.497    27.613     0.150
     1.497    49.189     0.150
     1.552    27.992     0.150
     1.552    49.334     0.150
     1.693    30.604     0.150
     1.693    55.152     0.150
     1.996    33.154     0.150
     2.119    37.539     0.150
     2.443    44.885     0.150
     2.664    43.779     0.150
     2.664    75.393     0.150
     3.032    49.449     0.150
     3.032    84.982     0.150
     3.725    56.566     0.150
     3.725    96.348     0.150
     3.737    58.754     0.150
     3.737    99.818     0.150
     3.849    59.334     0.150
     3.849    99.545     0.150
     4.155    66.182     0.150
     0.910    19.734     0.150
     0.910    32.539     0.150
     0.952    19.508     0.150
     1.124    22.102     0.150
     1.124    39.148     0.150
     1.206    25.672     0.150
     1.206    42.414     0.150
     1.211    25.688     0.150
     1.211    42.070     0.150
     1.211    25.805     0.150
     1.249    24.422     0.150
     1.249    43.023     0.150
     1.643    29.875     0.150
     1.643    51.781     0.150
     1.638    29.773     0.150
     1.764    56.703     0.150
     1.741    34.484     0.150
     1.741    54.273     0.150
     1.884    35.414     0.150
     1.884    61.094     0.150
     2.041    37.750     0.150
     2.041    57.789     0.150
     2.042    35.477     0.150
     2.042    58.758     0.150
     1.948    34.664     0.150
     2.498    41.016     0.150
     2.498    70.180     0.150
     2.554    41.305     0.150
     2.554    71.445     0.150
     2.685    44.914     0.150
     2.685    78.227     0.150
     2.775    86.625     0.150
     2.803    46.109     0.150
     2.803    77.211     0.150
     2.893    86.812     0.150
     2.902    48.297     0.150
     2.954    83.945     0.150
     3.051    84.336     0.150
     3.173    51.250     0.150
     3.173    96.945     0.150
     3.533    57.938     0.150
     3.533    99.648     0.150
     3.821   118.203     0.150
     3.898    62.062     0.150
     3.898   104.969     0.150
     3.977    62.516     0.150
     3.977   106.852     0.150
     3.933    63.219     0.150
     3.933   108.914     0.150
     4.159    64.516     0.150
     4.159   109.273     0.150
     4.213    67.422     0.150
     4.389    67.242     0.150
     4.389   113.820     0.150
     4.431    67.914     0.150
     4.431   117.516     0.150
     4.452    67.914     0.150
     4.452   117.117     0.150
     4.773    72.617     0.150
     4.773   125.914     0.150
     4.689    73.758     0.150
     4.689   125.625     0.150
     4.945    75.117     0.150
     4.945   129.719     0.150
     4.963    74.328     0.150
     4.963   128.367     0.150
     4.963    74.617     0.150
     4.963   130.414     0.150
     5.134    77.320     0.150
     5.134   134.719     0.150
     5.242    80.844     0.150
     5.383    81.117     0.150
     5.383   140.117     0.150
     5.354   139.508     0.150
     5.409    82.016     0.150
     5.409   140.117     0.150
     5.861    88.219     0.150
     5.861   151.414     0.150
     6.394   165.914     0.150
     6.554   170.016     0.150
     6.767   175.617     0.150
     0.156     4.640     0.150
     0.156     7.279     0.150
     0.507    11.062     0.150
     0.507    17.543     0.150
     0.683    13.842     0.150
     0.766    15.279     0.150
     1.528    29.311     0.150
     1.659    52.957     0.150
     1.718    31.899     0.150
     1.825    34.438     0.150
     1.825    57.969     0.150
     1.872    35.323     0.150
     1.872    60.574     0.150
     2.081    35.682     0.150
     2.081    35.839     0.150
     2.081    61.759     0.150
     2.173    37.982     0.150
     2.129    35.817     0.150
     2.328    39.974     0.150
     2.385    39.850     0.150
     2.385    70.009     0.150
     2.453    40.898     0.150
     2.488    43.172     0.150
     2.793    46.483     0.150
     3.038    49.700     0.150
     3.247    52.919     0.150
     3.247    88.100     0.150
     3.392    53.230     0.150
     3.410    54.367     0.150
     3.410    91.265     0.150
     3.454    56.589     0.150
     3.496    55.089     0.150
     3.496    96.159     0.150
     3.632    58.149     0.150
     3.632    99.600     0.150
     3.753    60.257     0.150
     3.753   102.377     0.150
     3.862    61.997     0.150
     3.862   105.518     0.150
     4.095   111.938     0.150
     4.433    66.999     0.150
     4.433   115.999     0.150
     4.453    67.397     0.150
     4.453   116.117     0.150
     4.476    67.600     0.150
     4.476   116.600     0.150
     4.497    68.268     0.150
     4.497   116.659     0.150
     4.523    71.739     0.150
     4.523   121.149     0.150
     4.548    69.777     0.150
     4.548   118.060     0.150
     4.632    70.688     0.150
     4.632   121.268     0.150
     4.793    72.667     0.150
     4.793   125.329     0.150
     4.793    72.799     0.150
     4.793   125.899     0.150
     4.805    72.799     0.150
     4.805   125.399     0.150
     4.831    72.749     0.150
     4.831    73.600     0.150
     4.831   126.600     0.150
     4.934    74.899     0.150
     4.934   127.299     0.150
     4.972    78.459     0.150
     4.972   135.279     0.150
     5.052    76.999     0.150
     5.052   131.199     0.150
     5.074    76.600     0.150
     5.074   131.799     0.150
     5.418    81.699     0.150
     5.418   140.799     0.150
     5.573    83.499     0.150
     5.573   143.100     0.150
     5.573    82.969     0.150
     5.573   142.770     0.150
     5.792    89.771     0.150
     6.018    89.447     0.150
     6.018   153.167     0.150
     6.178    91.987     0.150
     6.178   157.812     0.150
     6.204    92.199     0.150
     6.204   158.399     0.150
     6.447    96.600     0.150
     6.581    97.180     0.150
     6.581   166.579     0.150
     6.615    97.799     0.150
     6.615   167.600     0.150
     6.725    99.600     0.150
     6.725   172.299     0.150
     6.896   173.930     0.150
     7.103   104.699     0.150
     7.162   104.899     0.150
     7.162   182.699     0.150
     7.545   110.399     0.150
     7.545   191.199     0.150
     7.627   112.579     0.150
     7.627   194.369     0.150
     7.795   113.640     0.150
     7.795   194.520     0.150
     7.795   113.799     0.150
     7.795   197.999     0.150
     8.036   203.699     0.150
     8.147   118.999     0.150
     8.147   205.600     0.150
     8.378   122.100     0.150
     8.378   210.399     0.150
     8.512   123.757     0.150
     8.512   213.377     0.150
     8.520   123.899     0.150
     8.520   213.999     0.150
     8.677   126.044     0.150
     8.677   216.569     0.150
     8.818   128.299     0.150
     8.818   221.899     0.150
     0.873    18.024     0.150
     0.873    31.395     0.150
     0.916    18.364     0.150
     0.916    31.954     0.150
     1.096    21.990     0.150
     1.096    39.853     0.150
     1.473    27.102     0.150
     1.473    44.254     0.150
     1.446    28.074     0.150
     1.446    48.399     0.150
     1.497    28.590     0.150
     1.497    48.412     0.150
     1.834    33.453     0.150
     1.834    58.871     0.150
     1.750    56.104     0.150
     1.766    32.532     0.150
     1.766    56.799     0.150
     2.477    43.618     0.150
     2.614    47.019     0.150
     2.614    79.649     0.150
     2.692    43.614     0.150
     2.692    75.464     0.150
     2.565    45.651     0.150
     2.565    77.792     0.150
     2.969    48.302     0.150
     2.969    84.572     0.150
     3.059    49.902     0.150
     3.059    87.442     0.150
     3.338    93.502     0.150
     3.552    56.293     0.150
     3.597    58.312     0.150
     3.721    60.624     0.150
     3.796    59.154     0.150
     3.796   100.204     0.150
     3.928   102.544     0.150
     3.845    60.132     0.150
     3.845   103.643     0.150
     3.816    62.233     0.150
     3.936    59.645     0.150
     3.936   102.444     0.150
     4.089    64.039     0.150
     0.494    11.027     0.150
     0.494    19.879     0.150
     0.681    13.777     0.150
     0.681    23.879     0.150
     0.888    16.918     0.150
     0.888    30.676     0.150
     0.907    17.199     0.150
     0.907    30.977     0.150
     1.111    20.781     0.150
     1.497    26.598     0.150
     1.497    46.668     0.150
     1.555    27.516     0.150
     1.555    49.602     0.150
     1.721    31.031     0.150
     1.721    53.113     0.150
     1.858    31.629     0.150
     1.858    56.262     0.150
     2.028    34.625     0.150
     2.675    42.887     0.150
     2.675    75.918     0.150
     2.968    47.992     0.150
     2.968    94.238     0.150
     2.971    47.551     0.150
     2.971    83.527     0.150
     3.043    48.418     0.150
     3.354    54.137     0.150
     3.629    67.984     0.150
     3.629   112.266     0.150
     3.707    58.809     0.150
     3.707   101.387     0.150
     3.713    56.906     0.150
     3.713    97.633     0.150
     3.733    98.566     0.150
     3.831    57.598     0.150
     3.831    98.699     0.150
     4.067    78.156     0.150
     4.067   126.508     0.150
     4.291    81.086     0.150
     0.185     4.383     0.150
     0.170     4.773     0.150
     0.170     8.406     0.150
     0.675    14.008     0.150
     0.675    24.336     0.150
     0.663    13.008     0.150
     0.743    14.664     0.150
     1.554    28.656     0.150
     1.812    34.438     0.150
     1.812    56.805     0.150
     2.109    38.102     0.150
     2.109    65.812     0.150
     2.109    61.445     0.150
     2.107    35.812     0.150
     2.161    39.945     0.150
     2.404    40.328     0.150
     2.404    68.688     0.150
     2.785    45.406     0.150
     3.041    48.867     0.150
     3.405    51.938     0.150
     3.405   103.297     0.150
     3.445    55.719     0.150
     3.500    55.031     0.150
     3.500    93.883     0.150
     3.752    61.148     0.150
     3.752   101.953     0.150
     3.866    62.062     0.150
     3.866   103.109     0.150
     4.461    67.984     0.150
     4.461   114.586     0.150
     4.475   115.234     0.150
     4.503    67.281     0.150
     4.503   115.586     0.150
     4.523    68.406     0.150
     4.523   116.695     0.150
     4.564    69.562     0.150
     4.564   117.031     0.150
     4.645    71.422     0.150
     4.645   121.062     0.150
     4.823    72.984     0.150
     4.832    72.883     0.150
     4.832   123.688     0.150
     4.860    72.883     0.150
     4.974   130.156     0.150
     5.081    76.281     0.150
     5.081   131.383     0.150
     5.445    80.984     0.150
     5.445   141.383     0.150
     5.599    82.883     0.150
     6.030   152.727     0.150
     6.151    90.484     0.150
     6.151   157.086     0.150
     6.188   157.086     0.150
     6.227    92.281     0.150
     6.227   158.281     0.150
     0.632    13.510     0.150
     0.632    21.744     0.150
     0.720    14.932     0.150
     0.720    24.215     0.150
     1.571    30.801     0.150
     1.930    37.664     0.150
     1.930    62.857     0.150
     2.167    38.486     0.150
     2.167    66.758     0.150
     2.494    77.307     0.150
     2.733    46.172     0.150
     2.733    83.436     0.150
     3.342    52.098     0.150
     3.342   104.309     0.150
     3.391    54.695     0.150
     4.473    68.078     0.150
     4.518    68.377     0.150
     4.518   118.078     0.150
     4.541    68.547     0.150
     4.541   116.518     0.150
     4.603    69.898     0.150
     4.603   119.139     0.150
     4.690   121.205     0.150
     4.846   126.078     0.150
     4.866    72.979     0.150
     4.866   127.777     0.150
     5.089    76.877     0.150
     5.458    81.377     0.150
     6.254    91.877     0.150
     0.801    16.116     0.150
     0.801    28.094     0.150
     0.858    17.267     0.150
     0.858    29.474     0.150
     0.994    20.353     0.150
     0.994    34.973     0.150
     1.801    32.983     0.150
     1.821    32.777     0.150
     1.821    58.087     0.150
     1.906    32.543     0.150
     1.906    56.274     0.150
     2.151    37.514     0.150
     2.151    66.516     0.150
     2.588    42.869     0.150
     2.588    75.789     0.150
     2.902    48.058     0.150
     2.902    82.185     0.150
     2.902    48.853     0.150
     2.902    95.753     0.150
     3.386    52.303     0.150
     3.386    92.973     0.150
     3.478    53.663     0.150
     3.478    93.403     0.150
     3.604    57.019     0.150
     3.604    96.991     0.150
     3.827    59.951     0.150
     3.846    60.837     0.150
     3.846   101.621     0.150
     4.459    69.513     0.150
     4.459   122.226     0.150
     4.793    73.411     0.150
     4.793   125.989     0.150
     4.824    73.891     0.150
     4.824   125.243     0.150
     4.898    73.554     0.150
     4.898   126.761     0.150
     4.958    74.829     0.150
     5.037    74.693     0.150
     5.037   130.693     0.150
     5.040    74.861     0.150
     5.040   131.303     0.150
     5.050    74.893     0.150
     5.050   131.193     0.150
     5.050    74.692     0.150
     5.388    80.293     0.150
     5.388   139.293     0.150
     5.464    81.313     0.150
     5.464   141.763     0.150
     5.464    81.493     0.150
     5.479    81.173     0.150
     5.479   141.993     0.150
     5.479    81.693     0.150
     5.591    84.263     0.150
     5.616    83.293     0.150
     5.616   145.893     0.150
     5.639    83.013     0.150
     5.639   142.613     0.150
     5.689    83.893     0.150
     5.689   147.193     0.150
     6.004    87.993     0.150
     6.004   153.993     0.150
     6.097    89.493     0.150
     6.097   155.993     0.150
     6.150    91.331     0.150
     6.208    91.493     0.150
     6.208   158.793     0.150
     6.633    97.393     0.150
     6.633   169.793     0.150
     6.636    97.293     0.150
     6.636   169.793     0.150
     7.033   103.093     0.150
     7.251   105.793     0.150
     7.564   110.893     0.150
     7.961   116.293     0.150
     0.825    16.777     0.150
     0.825    29.180     0.150
     1.175    22.359     0.150
     1.175    39.684     0.150
     1.241    24.141     0.150
     1.241    43.012     0.150
     1.320    25.410     0.150
     1.320    42.527     0.150
     1.434    26.430     0.150
     1.434    47.285     0.150
     1.521    28.805     0.150
     1.521    48.316     0.150
     1.505    27.895     0.150
     1.505    49.785     0.150
     1.531    29.199     0.150
     1.531    49.973     0.150
     1.810    32.906     0.150
     1.810    56.773     0.150
     1.810    33.434     0.150
     1.810    58.004     0.150
     1.810    33.551     0.150
     1.810    57.422     0.150
     1.778    32.602     0.150
     1.975    34.750     0.150
     2.047    38.422     0.150
     2.730    45.543     0.150
     2.730    81.613     0.150
     3.319    52.652     0.150
     5.427    80.262     0.150
     5.427   140.359     0.150
     5.525    81.762     0.150
     5.525   141.961     0.150
     5.600    82.949     0.150
     5.600   142.508     0.150
     5.705    84.027     0.150
     5.705   146.605     0.150
     5.821    86.062     0.150
     5.821   149.262     0.150
     5.944    87.859     0.150
     5.944   152.562     0.150
     5.976    88.590     0.150
     5.976   151.887     0.150
     6.143    90.641     0.150
     6.143   157.020     0.150
     6.405    93.762     0.150
     6.405   162.762     0.150
     6.580    99.301     0.150
     6.672    97.961     0.150
     7.233   105.160     0.150
     7.431   108.461     0.150
     7.431   189.062     0.150
     7.530   190.508     0.150
     7.848   114.160     0.150
     0.251     7.926     0.150
     0.251    12.879     0.150
     0.687    13.973     0.150
     0.687    22.676     0.150
     0.896    18.539     0.150
     1.035    19.578     0.150
     3.811    56.512     0.150
     3.811    97.512     0.150
     3.847    57.191     0.150
     3.847    97.961     0.150
     3.860    58.137     0.150
     3.860    98.898     0.150
     4.069    61.078     0.150
     4.069   105.449     0.150
     4.133    61.934     0.150
     4.133   106.410     0.150
     4.133    61.512     0.150
     4.133   106.312     0.150
     4.239    63.680     0.150
     4.239   107.078     0.150
     4.358    65.613     0.150
     4.385    64.371     0.150
     4.742    69.512     0.150
     4.742   120.012     0.150
     4.927    72.012     0.150
     5.117    75.113     0.150
     5.117   129.012     0.150
     5.484    79.512     0.150
     5.484   137.910     0.150
     5.607    81.812     0.150
     5.607   141.012     0.150
     0.137     4.502     0.150
     0.137     6.943     0.150
     0.720    14.162     0.150
     1.384    26.471     0.150
     1.658    32.871     0.150
     1.783    32.973     0.150
     1.783    56.283     0.150
     2.051    35.293     0.150
     2.051    60.953     0.150
     3.464    91.049     0.150
     3.561    55.416     0.150
     3.561    95.510     0.150
     4.471    67.162     0.150
     4.471   115.562     0.150
     4.517    67.662     0.150
     4.517   115.764     0.150
     4.503    67.145     0.150
     4.503   116.439     0.150
     4.540    68.264     0.150
     4.540   117.318     0.150
     4.606    70.012     0.150
     4.606   121.770     0.150
     4.588   124.201     0.150
     4.694    71.246     0.150
     4.694   121.797     0.150
     4.824    72.164     0.150
     4.824   124.799     0.150
     4.824    72.363     0.150
     4.824   124.463     0.150
     4.844   125.863     0.150
     4.864    73.363     0.150
     4.864   126.062     0.150
     5.087    76.764     0.150
     5.087   130.363     0.150
     5.096    75.523     0.150
     5.096   131.264     0.150
     5.096    76.863     0.150
     5.457    81.764     0.150
     5.457   140.363     0.150
     5.617    83.363     0.150
     5.617   142.764     0.150
     5.784    85.463     0.150
     5.784   147.264     0.150
     6.171    90.662     0.150
     6.171   157.463     0.150
     6.254    92.062     0.150
     6.638    97.082     0.150
     6.638   167.885     0.150
     0.488     9.645     0.150
     0.488    16.516     0.150
     0.579    12.395     0.150
     0.579    20.395     0.150
     0.579    12.145     0.150
     1.643    30.496     0.150
     1.643    50.863     0.150
     1.833    32.383     0.150
     1.833    57.844     0.150
     2.270    40.375     0.150
     2.302    39.070     0.150
     2.481    43.062     0.150
     2.854    47.781     0.150
     2.957    82.852     0.150
     3.409    54.414     0.150
     3.409    93.043     0.150
     3.775    57.234     0.150
     3.775   100.434     0.150
     3.853    58.961     0.150
     3.853   102.602     0.150
     4.046    61.613     0.150
     4.046   106.695     0.150
     4.310    65.434     0.150
     4.310   112.773     0.150
     4.413    68.211     0.150
     4.413   118.062     0.150
     4.651   123.191     0.150
     4.735    70.895     0.150
     4.735   122.395     0.150
     4.800    71.695     0.150
     4.800   123.695     0.150
     4.797    71.633     0.150
     4.843    72.652     0.150
     4.843   125.355     0.150
     4.859    72.570     0.150
     4.859   125.582     0.150
     5.028    74.855     0.150
     5.028   128.922     0.150
     5.028   128.492     0.150
     5.088    75.445     0.150
     5.088   129.754     0.150
     5.088   130.895     0.150
     5.118    76.195     0.150
     5.118   131.195     0.150
     5.075    77.594     0.150
     5.075   135.902     0.150
     5.146    76.793     0.150
     5.146   132.762     0.150
     5.319    78.895     0.150
     5.319   136.992     0.150
     5.328    79.293     0.150
     5.328   136.195     0.150
     5.369    79.414     0.150
     5.369   136.312     0.150
     5.369   138.793     0.150
     5.414    80.195     0.150
     5.414   138.992     0.150
     5.528    84.973     0.150
     5.528   147.152     0.150
     5.723    84.395     0.150
     5.723   145.094     0.150
     5.803    86.242     0.150
     5.923    87.492     0.150
     5.923   150.492     0.150
     5.923    87.125     0.150
     5.923   151.473     0.150
     6.118    89.992     0.150
     6.118   156.293     0.150
     6.118    89.891     0.150
     6.350    95.254     0.150
     6.482    94.895     0.150
     6.482   165.094     0.150
     6.534    95.461     0.150
     6.534   164.973     0.150
     6.534    96.016     0.150
     6.607    96.992     0.150
     6.607   167.293     0.150
     6.703    97.969     0.150
     6.703   168.867     0.150
     6.748    98.480     0.150
     6.748   169.641     0.150
     6.748    99.492     0.150
     6.748   172.094     0.150
     7.021   102.594     0.150
     7.021   175.793     0.150
     7.043   102.613     0.150
     7.043   176.594     0.150
     7.067   103.293     0.150
     7.471   108.492     0.150
     7.574   110.293     0.150
     7.574   192.195     0.150
     7.640   110.922     0.150
     7.640   191.793     0.150
     7.949   115.594     0.150
     7.949   198.793     0.150
     8.175   118.773     0.150
     8.175   206.344     0.150
     8.234   119.402     0.150
     8.234   206.773     0.150
     8.234   205.695     0.150
     8.453   122.395     0.150
     8.453   212.492     0.150
     8.516   122.895     0.150
     8.563   123.895     0.150
     8.563   214.195     0.150
     8.830   127.094     0.150
     8.830   220.195     0.150
     8.933   128.895     0.150
     8.933   222.195     0.150
     8.965   128.492     0.150
     8.965   224.590     0.150
     9.091   130.766     0.150
     9.091   228.145     0.150
     9.227   132.895     0.150
     9.227   230.492     0.150
     9.495   136.613     0.150
     9.495   235.465     0.150
    10.001   143.363     0.150
    10.001   248.211     0.150
    10.246   146.965     0.150
    10.246   253.633     0.150
    10.276   147.543     0.150
    10.320   147.633     0.150
    10.379   149.160     0.150
    18.493   256.062     0.150
    20.792   283.520     0.150
    21.222   285.543     0.150
    26.239   337.043     0.150
    69.432   668.156     0.150
     0.802    16.781     0.150
     0.802    29.391     0.150
     0.885    18.164     0.150
     0.885    30.219     0.150
     0.973    19.070     0.150
     0.973    33.672     0.150
     1.300    25.812     0.150
     1.300    43.188     0.150
     1.176    23.922     0.150
     1.176    40.695     0.150
     1.427    28.242     0.150
     1.427    49.086     0.150
     1.701    33.422     0.150
     1.701    55.906     0.150
     1.643    31.109     0.150
     1.643    52.859     0.150
     1.778    33.242     0.150
     1.778    56.578     0.150
     1.882    35.242     0.150
     1.882    61.281     0.150
     1.587    30.250     0.150
     1.587    50.508     0.150
     2.231    38.703     0.150
     2.231    69.852     0.150
     2.305    40.250     0.150
     2.305    67.055     0.150
     2.567    44.625     0.150
     3.020    49.242     0.150
     2.964    57.727     0.150
     3.413    55.242     0.150
     3.131    52.422     0.150
     3.252    53.938     0.150
     3.130    52.352     0.150
     3.218    52.328     0.150
     3.467    55.891     0.150
     3.467    96.695     0.150
     3.468    56.742     0.150
     3.468    97.625     0.150
     3.611    58.500     0.150
     4.014    64.469     0.150
     4.014   109.984     0.150
     4.190    64.312     0.150
     4.190   112.602     0.150
     4.430    68.172     0.150
     4.430   118.492     0.150
     4.737    72.492     0.150
     4.737   126.648     0.150
     4.842    74.938     0.150
     4.842   128.422     0.150
     5.147    77.977     0.150
     5.147   133.570     0.150
     5.012    77.891     0.150
     5.012   135.523     0.150
     5.105    79.820     0.150
     5.105   137.781     0.150
     5.238    79.172     0.150
     5.238   134.977     0.150
     5.238    78.945     0.150
     5.304    80.195     0.150
     5.304   137.602     0.150
     5.361    80.352     0.150
     5.361   137.852     0.150
     5.361    80.672     0.150
     5.361   138.773     0.150
     5.361    80.547     0.150
     5.387    81.000     0.150
     5.387   139.969     0.150
     5.414    81.711     0.150
     5.540    83.773     0.150
     5.540   143.773     0.150
     5.684    85.672     0.150
     5.684   147.070     0.150
     5.636    84.398     0.150
     5.636   146.859     0.150
     5.839    87.375     0.150
     5.839   150.570     0.150
     5.864    88.172     0.150
     5.864   151.375     0.150
     5.793    87.000     0.150
     5.793   149.539     0.150
     5.768    88.180     0.150
     5.768   152.906     0.150
     6.256    93.672     0.150
     6.226    94.711     0.150
     6.226    95.156     0.150
     6.380    95.172     0.150
     6.380   163.875     0.150
     6.380   164.133     0.150
     6.609    97.977     0.150
     6.609   169.477     0.150
     6.505    99.039     0.150
     6.941   102.672     0.150
     6.941   176.773     0.150
     7.141   105.852     0.150
     7.141   182.836     0.150
     7.141   183.773     0.150
     7.120   105.273     0.150
     7.120   182.172     0.150
     7.052   106.531     0.150
     7.181   105.391     0.150
     7.181   181.820     0.150
     7.518   188.164     0.150
     7.360   108.023     0.150
     7.360   186.750     0.150
     7.360   108.133     0.150
     7.507   111.172     0.150
     7.507   192.273     0.150
     7.537   110.977     0.150
     7.537   189.773     0.150
     7.625   112.125     0.150
     7.625   192.281     0.150
     7.941   116.773     0.150
     7.941   201.477     0.150
     8.095   119.172     0.150
     8.101   119.070     0.150
     8.101   205.867     0.150
     8.287   208.617     0.150
     8.459   124.477     0.150
     8.784   128.062     0.150
     8.784   221.945     0.150
     8.784   128.375     0.150
     8.784   221.672     0.150
     8.861   129.273     0.150
     8.861   225.484     0.150
     8.978   130.570     0.150
     8.978   227.273     0.150
     9.086   132.273     0.150
     9.086   228.273     0.150
     9.396   136.672     0.150
     9.396   236.570     0.150
     9.451   137.172     0.150
     9.531   138.453     0.150
     9.531   238.945     0.150
     9.728   140.742     0.150
     9.728   247.445     0.150
     9.610   139.047     0.150
     9.610   241.125     0.150
    10.529   152.359     0.150
    10.529   262.094     0.150
    10.859   157.086     0.150
    10.859   271.680     0.150
    10.940   157.555     0.150
    10.926   158.180     0.150
    10.926   273.812     0.150
    12.878   186.945     0.150
    17.916   251.469     0.150
    20.346   281.102     0.150
    21.923   295.438     0.150
    62.236   623.453     0.150
     0.662    14.238     0.150
     0.662    23.078     0.150
     0.852    17.875     0.150
     1.144    22.523     0.150
     1.144    38.277     0.150
     0.986    20.602     0.150
     0.986    32.898     0.150
     1.443    27.777     0.150
     1.443    47.500     0.150
     1.273    24.004     0.150
     1.273    41.736     0.150
     1.353    25.408     0.150
     1.353    43.299     0.150
     1.397    26.658     0.150
     1.397    45.117     0.150
     2.183    38.213     0.150
     2.183    65.586     0.150
     2.110    38.277     0.150
     2.110    64.793     0.150
     2.808    49.777     0.150
     2.808    80.547     0.150
     2.815    45.395     0.150
     2.815    77.812     0.150
     2.949    49.906     0.150
     3.025    51.498     0.150
     3.884    60.309     0.150
     3.884   102.107     0.150
     3.752    59.408     0.150
     3.960    61.209     0.150
     3.960   104.107     0.150
     4.014    60.779     0.150
     4.014   103.430     0.150
     4.080    62.117     0.150
     4.080   104.842     0.150
     3.847    62.035     0.150
     4.161   107.734     0.150
     4.161   109.508     0.150
     4.352    65.764     0.150
     4.352   113.438     0.150
     4.456   116.908     0.150
     4.534    68.008     0.150
     4.534   116.107     0.150
     4.551    68.982     0.150
     4.551   115.689     0.150
     4.660   124.049     0.150
     4.872    73.408     0.150
     4.872   126.008     0.150
     5.309   135.709     0.150
     5.815   147.008     0.150
     5.933   148.920     0.150
     0.726    15.203     0.150
     0.726    24.367     0.150
     0.914    19.148     0.150
     0.914    32.086     0.150
     1.128    24.328     0.150
     1.128    39.852     0.150
     1.044    21.742     0.150
     1.044    34.672     0.150
     1.302    44.227     0.150
     1.332    26.594     0.150
     1.332    44.375     0.150
     1.444    28.203     0.150
     1.457    28.203     0.150
     1.457    46.961     0.150
     1.983    36.289     0.150
     1.983    65.070     0.150
     2.214    40.492     0.150
     2.214    69.594     0.150
     2.848    47.930     0.150
     2.848    86.086     0.150
     2.870    46.961     0.150
     2.870    81.562     0.150
     2.975    49.547     0.150
     2.975    85.766     0.150
     3.008    47.930     0.150
     3.008    85.117     0.150
     3.357    53.750     0.150
     3.357    91.266     0.150
     3.919    60.164     0.150
     3.919   102.664     0.150
     3.829    62.156     0.150
     3.829   103.227     0.150
     3.976    60.039     0.150
     4.337    65.977     0.150
     4.337   113.062     0.150
     4.502    69.461     0.150
     4.502   120.062     0.150
     4.546    69.281     0.150
     4.546   118.375     0.150
     5.068    75.586     0.150
     0.552    11.930     0.150
     0.552    20.742     0.150
     0.831    16.445     0.150
     0.831    28.318     0.150
     1.180    23.598     0.150
     1.180    40.682     0.150
     1.186    22.900     0.150
     1.186    38.787     0.150
     1.225    25.188     0.150
     1.225    42.926     0.150
     1.250    24.404     0.150
     1.250    42.174     0.150
     1.305    26.564     0.150
     1.305    44.514     0.150
     1.334    45.580     0.150
     1.448    28.363     0.150
     1.533    30.080     0.150
     1.533    51.018     0.150
     1.572    30.385     0.150
     1.588    30.629     0.150
     1.631    32.070     0.150
     1.932    34.844     0.150
     2.404    70.334     0.150
     2.678    45.494     0.150
     2.680    44.418     0.150
     2.721    45.332     0.150
     2.721    79.041     0.150
     2.821    45.016     0.150
     2.821    81.529     0.150
     2.893    48.111     0.150
     2.893    82.029     0.150
     3.100    50.928     0.150
     3.100    90.113     0.150
     3.156    51.166     0.150
     3.156    91.572     0.150
     3.450    97.113     0.150
     3.687    60.879     0.150
     3.769    61.164     0.150
     3.769   105.467     0.150
     4.207    66.824     0.150
     4.312    67.820     0.150
     4.312   117.711     0.150
     4.639    70.885     0.150
     4.753    72.959     0.150
     4.753   126.311     0.150
     4.794    73.555     0.150
     4.794   126.254     0.150
     4.794    72.344     0.150
     4.794   126.936     0.150
     4.815    73.754     0.150
     4.815   127.854     0.150
     5.018    75.754     0.150
     5.018   133.354     0.150
     5.137    77.953     0.150
     5.137   135.654     0.150
     5.495   144.453     0.150
     5.747    86.055     0.150
     5.747   148.754     0.150
     6.215    93.154     0.150
     6.291    93.654     0.150
     0.417     9.961     0.150
     0.417     9.812     0.150
     0.772    15.539     0.150
     0.772    26.789     0.150
     0.584    12.180     0.150
     0.584    20.828     0.150
     0.702    14.617     0.150
     0.702    24.594     0.150
     0.702    14.188     0.150
     1.020    20.383     0.150
     1.020    20.547     0.150
     1.196    22.156     0.150
     1.727    53.852     0.150
     2.164    39.227     0.150
     2.311    40.555     0.150
     2.311    72.039     0.150
     2.003    35.234     0.150
     2.003    60.734     0.150
     2.724    44.633     0.150
     2.724    82.328     0.150
     2.855    45.938     0.150
     2.855    83.258     0.150
     2.855    47.570     0.150
     2.886    46.547     0.150
     2.886    82.461     0.150
     2.592    41.000     0.150
     2.592    74.039     0.150
     3.232    52.070     0.150
     3.598   103.836     0.150
     3.394    54.523     0.150
     3.394    94.438     0.150
     4.886    72.258     0.150
     4.886   124.758     0.150
     4.963    73.461     0.150
     4.963   126.664     0.150
     4.963    74.102     0.150
     5.214    76.859     0.150
     5.274   133.859     0.150
     5.526    81.562     0.150
     5.526   141.062     0.150
     5.523    81.859     0.150
     5.523   143.258     0.150
     5.873    86.461     0.150
     0.705    13.758     0.150
     0.705    24.500     0.150
     0.701    14.633     0.150
     0.701    23.523     0.150
     0.876    18.328     0.150
     0.876    31.703     0.150
     1.040    21.039     0.150
     1.040    36.727     0.150
     1.089    23.859     0.150
     1.326    25.398     0.150
     1.353    26.539     0.150
     1.353    44.445     0.150
     1.353    43.430     0.150
     1.396    29.586     0.150
     2.128    40.797     0.150
     2.794    49.883     0.150
     2.794    86.852     0.150
     2.822    48.500     0.150
     2.822    84.453     0.150
     3.061    54.953     0.150
     3.061    88.344     0.150
     3.064    53.547     0.150
     3.064    93.242     0.150
     3.882    67.664     0.150
     3.900   103.023     0.150
     3.954    60.414     0.150
     3.954   103.344     0.150
     4.021   105.211     0.150
     4.165    64.828     0.150
     4.165   111.727     0.150
     4.212   111.727     0.150
     4.297    65.789     0.150
     4.297   112.328     0.150
     4.474    69.430     0.150
     4.501    68.766     0.150
     4.501   118.336     0.150
     5.039    76.133     0.150
     5.039   130.172     0.150
     5.756   147.930     0.150
     0.608    13.012     0.150
     0.608    21.872     0.150
     0.788    15.931     0.150
     0.955    19.001     0.150
     0.955    32.890     0.150
     1.420    24.922     0.150
     1.420    42.792     0.150
     1.420    24.704     0.150
     1.239    22.710     0.150
     1.239    40.499     0.150
     1.407    26.150     0.150
     1.407    44.476     0.150
     1.959    34.757     0.150
     1.959    59.540     0.150
     2.173    37.875     0.150
     2.173    63.914     0.150
     2.743    80.531     0.150
     2.748    43.551     0.150
     2.748    77.999     0.150
     2.962    85.550     0.150
     3.077    85.900     0.150
     2.999    48.009     0.150
     3.234    93.098     0.150
     3.626    96.705     0.150
     3.817    58.275     0.150
     3.817   101.039     0.150
     3.895   102.432     0.150
     3.967   101.632     0.150
     3.967    59.386     0.150
     3.900    62.524     0.150
     3.900   105.506     0.150
     4.017    59.013     0.150
     4.017   101.476     0.150
     4.072    59.745     0.150
     4.072   102.615     0.150
     4.281    64.531     0.150
     4.281   109.332     0.150
     4.143    62.943     0.150
     4.143   118.522     0.150
     4.328    64.783     0.150
     4.328   110.721     0.150
     4.473    67.031     0.150
     4.473   116.231     0.150
     4.530    67.062     0.150
     4.530   114.622     0.150
     4.530    67.832     0.150
     4.530   117.531     0.150
     4.529    67.031     0.150
     4.519    67.802     0.150
     4.519   115.388     0.150
     4.613    71.611     0.150
     4.613   121.717     0.150
     4.883   126.531     0.150
     5.091    74.229     0.150
     5.098   133.515     0.150
     5.308   134.932     0.150
     5.810    84.531     0.150
     5.810   145.731     0.150
     5.902   149.085     0.150
     6.307    90.793     0.150
     6.307   157.625     0.150
     0.449    11.414     0.150
     0.449    18.188     0.150
     0.955    18.484     0.150
     0.955    31.445     0.150
     1.099    20.250     0.150
     1.099    33.805     0.150
     1.079    19.367     0.150
     1.079    32.328     0.150
     1.254    22.609     0.150
     1.254    37.633     0.150
     1.386    24.672     0.150
     1.386    41.461     0.150
     2.163    34.688     0.150
     2.163    59.141     0.150
     2.555    41.164     0.150
     2.555    70.039     0.150
     2.654    41.164     0.150
     2.654    70.922     0.150
     2.543    40.875     0.150
     2.543    70.336     0.150
     2.658    42.055     0.150
     2.658    72.102     0.150
     3.476    50.305     0.150
     4.104    60.289     0.150
     4.104   102.992     0.150
     4.195    61.391     0.150
     4.195   105.094     0.150
     4.195    61.203     0.150
     4.407    64.414     0.150
     4.407    64.789     0.150
     4.497    66.594     0.150
     4.497   112.992     0.150
     4.742    68.672     0.150
     4.742   116.773     0.150
     5.087    73.492     0.150
     5.087   127.094     0.150
     5.576    80.789     0.150
     6.094    87.594     0.150
     6.094   150.789     0.150
     0.675    13.727     0.150
     0.675    23.195     0.150
     0.753    15.039     0.150
     0.753    26.391     0.150
     1.070    21.289     0.150
     1.070    36.773     0.150
     0.856    18.086     0.150
     0.856    30.227     0.150
     1.297    25.648     0.150
     1.423    26.477     0.150
     1.631    30.164     0.150
     1.880    33.250     0.150
     1.880    57.500     0.150
     1.880    32.969     0.150
     1.686    31.602     0.150
     1.686    55.820     0.150
     1.937    35.508     0.150
     1.937    63.094     0.150
     2.106    36.523     0.150
     2.106    65.172     0.150
     2.631    45.438     0.150
     2.351    41.086     0.150
     2.443    41.164     0.150
     3.000    50.141     0.150
     3.017    50.086     0.150
     3.420    55.867     0.150
     3.420    95.328     0.150
     3.420    55.039     0.150
     3.223    53.086     0.150
     3.641    56.109     0.150
     5.194    77.617     0.150
     5.194   134.117     0.150
     5.275    78.719     0.150
     5.275   135.914     0.150
     5.436    81.516     0.150
     5.436   140.117     0.150
     5.436    80.484     0.150
     5.436   140.734     0.150
     5.512    82.047     0.150
     5.512   139.594     0.150
     5.512   142.219     0.150
     5.584    83.219     0.150
     5.584   143.617     0.150
     5.749    85.617     0.150
     5.749   148.117     0.150
     5.846    86.719     0.150
     5.846   149.320     0.150
     5.897    87.820     0.150
     5.897   150.719     0.150
     6.180    91.016     0.150
     6.180   157.820     0.150
     6.411   164.719     0.150
     6.626    97.617     0.150
     6.626   168.414     0.150
     6.875   102.117     0.150
     6.971   102.117     0.150
     6.971   177.516     0.150
     7.127   104.719     0.150
     7.127   180.016     0.150
     7.197   105.617     0.150
     7.197   184.016     0.150
     7.543   110.219     0.150
     7.543   189.719     0.150
     7.546   110.617     0.150
     8.099   118.117     0.150
     8.468   123.117     0.150
     8.774   127.719     0.150
     8.981   130.117     0.150
     8.981   226.117     0.150
     9.089   131.617     0.150
     9.089   228.320     0.150
     0.563    12.102     0.150
     0.563    20.789     0.150
     0.727    14.531     0.150
     0.727    26.312     0.150
     0.841    16.898     0.150
     0.841    28.266     0.150
     1.125    21.117     0.150
     1.125    35.242     0.150
     1.142    22.141     0.150
     1.142    35.867     0.150
     1.163    22.891     0.150
     1.163    39.406     0.150
     1.392    26.016     0.150
     1.392    45.508     0.150
     1.620    30.133     0.150
     1.620    51.055     0.150
     1.620    28.570     0.150
     1.620    48.273     0.150
     1.749    32.016     0.150
     1.749    55.625     0.150
     1.951    34.828     0.150
     1.951    60.883     0.150
     1.939    33.648     0.150
     1.939    60.016     0.150
     2.150    39.930     0.150
     2.063    35.164     0.150
     2.063    63.484     0.150
     2.296    39.094     0.150
     2.296    68.656     0.150
     2.382    40.672     0.150
     2.382    71.820     0.150
     2.447    39.523     0.150
     2.447    70.750     0.150
     2.602    42.922     0.150
     2.602    74.578     0.150
     2.842    46.664     0.150
     2.842    79.703     0.150
     2.951    48.492     0.150
     2.951    83.258     0.150
     3.002    48.781     0.150
     3.002    83.469     0.150
     3.026    50.320     0.150
     3.026    88.859     0.150
     3.167    50.984     0.150
     3.300    52.508     0.150
     3.252    50.211     0.150
     3.252    90.609     0.150
     3.376    53.055     0.150
     3.541    54.414     0.150
     3.541    95.273     0.150
     3.715    56.055     0.150
     3.715    99.031     0.150
     3.722    58.391     0.150
     3.887    58.633     0.150
     3.887   104.320     0.150
     4.135    62.375     0.150
     4.135   107.773     0.150
     4.540   119.750     0.150
     4.721    71.250     0.150
     4.721   124.586     0.150
     4.890    72.766     0.150
     4.890   126.062     0.150
     4.974    73.867     0.150
     4.974   127.961     0.150
     4.974    73.375     0.150
     4.974   127.492     0.150
     5.034    74.531     0.150
     5.034   128.594     0.150
     5.102    75.242     0.150
     5.102   131.117     0.150
     5.127    76.562     0.150
     5.127   132.961     0.150
     5.127    76.359     0.150
     5.204    77.031     0.150
     5.204   132.625     0.150
     5.204    77.266     0.150
     5.204   133.961     0.150
     5.281    78.367     0.150
     5.281   135.367     0.150
     5.336    78.727     0.150
     5.336   137.227     0.150
     5.441    80.766     0.150
     5.441   140.562     0.150
     5.470    81.992     0.150
     5.470   142.133     0.150
     5.491    80.922     0.150
     5.491   141.102     0.150
     5.528    81.438     0.150
     5.528   140.375     0.150
     5.528   142.961     0.150
     5.558    81.961     0.150
     5.558   141.367     0.150
     5.598    83.062     0.150
     5.598   143.461     0.150
     5.876    86.164     0.150
     5.876   150.062     0.150
     6.112    89.867     0.150
     6.112   155.961     0.150
     6.121    89.766     0.150
     6.121   154.422     0.150
     6.333    92.461     0.150
     6.333   160.664     0.150
     6.333    93.031     0.150
     6.673    97.367     0.150
     6.673   169.766     0.150
     6.839    99.867     0.150
     6.839   172.961     0.150
     7.057   102.000     0.150
     7.057   178.727     0.150
     7.245   105.664     0.150
     7.255   105.461     0.150
     7.255   182.461     0.150
     7.812   113.367     0.150
     8.179   117.766     0.150
     8.496   122.867     0.150
     8.496   213.766     0.150
     8.695   125.266     0.150
     8.803   126.766     0.150
     8.803   220.367     0.150
     9.104   131.062     0.150
     9.239   133.156     0.150
     9.239   228.438     0.150
     0.519    11.469     0.150
     0.519    19.523     0.150
     0.696    12.836     0.150
     0.696    24.633     0.150
     0.918    17.867     0.150
     0.918    30.961     0.150
     1.352    24.477     0.150
     1.352    44.484     0.150
     1.259    23.570     0.150
     1.259    41.102     0.150
     1.443    27.164     0.150
     1.443    48.047     0.150
     1.520    28.312     0.150
     1.520    48.141     0.150
     1.678    28.664     0.150
     1.678    51.172     0.150
     2.221    35.719     0.150
     2.221    62.914     0.150
     2.442    38.273     0.150
     2.442    72.969     0.150
     3.428    51.805     0.150
     3.428    91.102     0.150
     3.468    52.375     0.150
     3.468    52.203     0.150
     3.468    90.805     0.150
     3.797    57.406     0.150
     3.797    98.906     0.150
     3.939    59.805     0.150
     3.939   101.805     0.150
     4.050    60.141     0.150
     4.050   104.203     0.150
     4.411   113.500     0.150
     0.865    17.893     0.150
     0.865    30.127     0.150
     0.915    17.936     0.150
     0.915    32.287     0.150
     0.991    19.428     0.150
     0.991    35.607     0.150
     1.264    25.729     0.150
     1.264    43.008     0.150
     1.507    27.031     0.150
     1.507    47.100     0.150
     1.788    33.768     0.150
     1.788    58.219     0.150
     1.788    33.928     0.150
     1.788    53.957     0.150
     1.923    34.992     0.150
     1.923    59.227     0.150
     2.205    38.312     0.150
     2.205    66.348     0.150
     2.983    49.262     0.150
     2.983    86.119     0.150
     3.257    52.109     0.150
     3.708   108.678     0.150
     4.290   114.516     0.150
     5.260    79.328     0.150
     5.260   137.428     0.150
     5.350    79.887     0.150
     5.350   138.143     0.150
     5.350    80.428     0.150
     5.417    80.107     0.150
     5.417   141.482     0.150
     5.472   142.229     0.150
     5.498    82.068     0.150
     5.498   142.957     0.150
     5.557   144.029     0.150
     5.653    85.928     0.150
     5.653   146.428     0.150
     5.742    85.674     0.150
     5.742   148.439     0.150
     5.899    88.629     0.150
     5.899   153.129     0.150
     5.894    87.719     0.150
     5.894   152.803     0.150
     5.951    89.328     0.150
     5.951   152.828     0.150
     6.243    92.828     0.150
     6.243   160.729     0.150
     6.492   166.828     0.150
     6.516    96.125     0.150
     6.516   167.529     0.150
     6.722    98.729     0.150
     6.722   172.328     0.150
     7.232   106.629     0.150
     7.232   184.229     0.150
     0.570    11.727     0.150
     0.570    22.109     0.150
     0.815    16.375     0.150
     0.815    28.547     0.150
     1.040    20.742     0.150
     1.040    20.922     0.150
     1.040    37.055     0.150
     1.163    24.727     0.150
     1.163    23.914     0.150
     1.146    23.281     0.150
     1.146    39.812     0.150
     1.239    23.836     0.150
     1.239    41.758     0.150
     1.364    25.273     0.150
     1.364    43.789     0.150
     1.412    25.883     0.150
     1.412    45.828     0.150
     1.686    30.656     0.150
     1.686    51.406     0.150
     1.764    32.117     0.150
     1.764    56.984     0.150
     1.731    29.000     0.150
     1.731    50.258     0.150
     1.831    33.734     0.150
     1.831    33.609     0.150
     1.831    58.742     0.150
     1.939    32.406     0.150
     1.939    58.414     0.150
     2.329    38.055     0.150
     2.329    65.000     0.150
     2.760    43.750     0.150
     2.760    76.758     0.150
     2.906    46.672     0.150
     2.906    80.539     0.150
     3.024    49.211     0.150
     3.024    83.680     0.150
     3.127    49.469     0.150
     3.127    87.336     0.150
     3.787    61.102     0.150
     3.787   103.211     0.150
     3.889    59.523     0.150
     3.889   100.789     0.150
     3.885    59.891     0.150
     3.885   103.828     0.150
     3.928    61.586     0.150
     3.928   104.430     0.150
     4.016    60.156     0.150
     4.016   104.258     0.150
     4.016    59.766     0.150
     4.016   102.977     0.150
     4.026    59.953     0.150
     4.026    60.156     0.150
     4.026   104.555     0.150
     4.052    61.633     0.150
     4.365    65.555     0.150
     4.365   113.555     0.150
     4.382    66.055     0.150
     4.382   112.555     0.150
     4.462    67.156     0.150
     4.616    68.117     0.150
     4.616   118.016     0.150
     4.616    68.961     0.150
     4.616   119.055     0.150
     4.874    71.234     0.150
     4.898    72.516     0.150
     4.898   124.945     0.150
     4.981    74.156     0.150
     4.981   128.461     0.150
     5.075    75.461     0.150
     5.075   130.758     0.150
     5.066    77.992     0.150
     5.066   133.547     0.150
     5.194    77.461     0.150
     5.194   133.461     0.150
     5.309    79.078     0.150
     5.309   136.000     0.150
     5.460   140.336     0.150
     5.616    83.055     0.150
     5.616   143.555     0.150
     5.631    83.258     0.150
     5.631   144.359     0.150
     6.036    88.758     0.150
     6.229    91.656     0.150
     0.864    18.504     0.150
     0.920    18.629     0.150
     0.920    32.520     0.150
     0.998    20.027     0.150
     0.998    37.594     0.150
     1.386    27.445     0.150
     1.386    27.914     0.150
     1.386    43.949     0.150
     1.502    30.500     0.150
     1.502    47.645     0.150
     1.767    32.277     0.150
     1.767    54.914     0.150
     1.906    35.445     0.150
     1.906    62.445     0.150
     1.906    35.859     0.150
     2.197    37.973     0.150
     2.197    38.652     0.150
     2.197    64.727     0.150
     2.634    46.574     0.150
     2.776    48.770     0.150
     2.776    80.301     0.150
     2.978    49.504     0.150
     2.978    83.992     0.150
     3.262    53.590     0.150
     3.262    90.820     0.150
     3.412    54.285     0.150
     3.412    94.629     0.150
     3.662    59.215     0.150
     3.662   103.566     0.150
     3.725    61.273     0.150
     3.725   105.535     0.150
     5.333    80.676     0.150
     5.333   138.676     0.150
     5.333    81.098     0.150
     5.400    80.758     0.150
     5.400   140.617     0.150
     5.483    82.059     0.150
     5.483   143.555     0.150
     5.538    83.875     0.150
     5.538   144.477     0.150
     5.635    85.977     0.150
     5.635   146.977     0.150
     5.729    85.461     0.150
     5.729   147.895     0.150
     5.777   150.176     0.150
     5.881    87.328     0.150
     5.881   151.137     0.150
     5.881    88.176     0.150
     5.881   152.777     0.150
     5.884    88.715     0.150
     5.884   150.789     0.150
     5.935    89.277     0.150
     5.935   153.578     0.150
     6.225    92.777     0.150
     6.225   159.977     0.150
     6.501    97.332     0.150
     6.501   167.012     0.150
     7.037   181.477     0.150
     7.216   182.477     0.150
     0.944    20.277     0.150
     0.944    32.170     0.150
     1.034    20.525     0.150
     1.034    36.000     0.150
     1.287    25.672     0.150
     1.287    26.025     0.150
     1.121    22.568     0.150
     1.121    39.062     0.150
     1.299    26.264     0.150
     1.556    30.432     0.150
     1.636    32.123     0.150
     1.636    54.104     0.150
     1.636    30.533     0.150
     1.636    52.684     0.150
     1.636    32.375     0.150
     1.636    52.055     0.150
     1.758    33.441     0.150
     1.758    33.158     0.150
     1.758    58.676     0.150
     2.082    37.432     0.150
     2.082    64.863     0.150
     2.516    42.516     0.150
     2.516    74.102     0.150
     2.703    47.402     0.150
     2.703    46.152     0.150
     2.774    47.898     0.150
     2.774    80.650     0.150
     3.084    52.604     0.150
     2.872    49.402     0.150
     2.872    47.674     0.150
     2.872    84.535     0.150
     3.258    55.412     0.150
     3.258    55.086     0.150
     3.258    92.811     0.150
     3.339    55.471     0.150
     3.339    93.961     0.150
     3.366    55.402     0.150
     3.366    54.865     0.150
     3.366    93.516     0.150
     3.553    97.463     0.150
     3.555    58.553     0.150
     3.757    61.412     0.150
     3.757    61.584     0.150
     3.757   106.115     0.150
     3.800    61.234     0.150
     3.868    61.316     0.150
     3.868   108.818     0.150
     4.097    65.861     0.150
     4.097   112.963     0.150
     4.113    66.465     0.150
     3.872   110.191     0.150
     4.288    66.250     0.150
     4.288   115.359     0.150
     4.503   122.146     0.150
     4.545    71.203     0.150
     4.545   121.363     0.150
     4.853    74.736     0.150
     4.853   129.246     0.150
     4.949    76.955     0.150
     4.949   134.023     0.150
     5.175    78.633     0.150
     5.175   136.133     0.150
     5.137    79.848     0.150
     5.137   138.186     0.150
     5.272    79.834     0.150
     5.272   137.834     0.150
     5.344    81.086     0.150
     5.344   138.279     0.150
     5.369    80.834     0.150
     5.369   140.434     0.150
     5.369    81.779     0.150
     5.445    81.051     0.150
     5.445   141.355     0.150
     5.459    82.164     0.150
     5.459   140.533     0.150
     5.459   142.734     0.150
     5.570    84.133     0.150
     5.570   145.133     0.150
     5.699    85.734     0.150
     5.699   148.434     0.150
     5.717    86.053     0.150
     5.717   147.377     0.150
     5.814    87.133     0.150
     5.814   148.734     0.150
     5.814    87.334     0.150
     5.814   152.133     0.150
     5.891    88.334     0.150
     5.891   152.734     0.150
     5.900    88.533     0.150
     5.900   153.334     0.150
     5.888    88.193     0.150
     5.888   152.334     0.150
     5.885    90.666     0.150
     6.155    91.834     0.150
     6.155   158.934     0.150
     6.109    93.322     0.150
     6.417    95.873     0.150
     6.417   164.303     0.150
     6.417   165.834     0.150
     6.460    96.221     0.150
     6.460   165.889     0.150
     6.463    97.092     0.150
     6.655    98.834     0.150
     6.655   171.834     0.150
     6.655   100.279     0.150
     6.852   102.234     0.150
     6.852   177.734     0.150
     6.931   103.533     0.150
     6.978   103.334     0.150
     6.978   179.734     0.150
     7.162   106.434     0.150
     7.162   185.334     0.150
     7.172   106.033     0.150
     7.172   184.334     0.150
     7.178   109.285     0.150
     7.275   106.910     0.150
     7.275   184.863     0.150
     7.458   109.426     0.150
     7.458   189.131     0.150
     7.539   111.533     0.150
     7.539   193.633     0.150
     7.589   111.834     0.150
     7.589   194.434     0.150
     8.147   119.533     0.150
     8.147   208.934     0.150
     8.204   120.334     0.150
     8.250   205.422     0.150
     8.845   129.533     0.150
     8.845   225.434     0.150
     8.973   131.012     0.150
     8.973   225.875     0.150
     9.032   131.934     0.150
     9.032   229.033     0.150
     9.139   133.033     0.150
     9.139   231.834     0.150
     9.461   137.834     0.150
     9.461   239.834     0.150
     9.596   139.256     0.150
     9.596   242.111     0.150
     9.661   241.924     0.150
    10.939   158.945     0.150
    10.939   273.711     0.150
    11.003   159.854     0.150
    11.021   159.461     0.150
     0.769    15.828     0.150
     0.769    28.234     0.150
     0.769    15.938     0.150
     0.769    27.938     0.150
     1.075    20.812     0.150
     1.075    38.031     0.150
     1.139    21.812     0.150
     1.139    39.055     0.150
     1.354    25.164     0.150
     1.354    41.969     0.150
     1.443    27.344     0.150
     1.443    47.266     0.150
     1.525    27.500     0.150
     1.851    33.281     0.150
     1.851    57.109     0.150
     1.892    33.688     0.150
     1.892    60.211     0.150
     1.892    35.023     0.150
     2.069    35.617     0.150
     2.069    61.508     0.150
     2.069    36.938     0.150
     2.069    64.984     0.150
     2.015    35.023     0.150
     2.015    60.070     0.150
     3.418    53.617     0.150
     3.418    95.453     0.150
     3.827    60.727     0.150
     3.827   106.281     0.150
     3.763    60.172     0.150
     3.763   104.555     0.150
     4.480    67.289     0.150
     4.480   117.289     0.150
     5.017    73.406     0.150
     5.017   129.578     0.150
     5.508    81.672     0.150
     5.508   140.469     0.150
     5.579    82.414     0.150
     5.579   143.820     0.150
     5.609    83.070     0.150
     5.609   143.469     0.150
     5.672    83.359     0.150
     5.672   146.656     0.150
     5.699    84.117     0.150
     5.699    84.367     0.150
     5.699   146.469     0.150
     5.807    85.672     0.150
     5.807   147.172     0.150
     5.939    87.867     0.150
     5.939   151.469     0.150
     5.927    87.250     0.150
     5.927   149.602     0.150
     6.052    89.117     0.150
     6.052    89.469     0.150
     6.052   155.766     0.150
     6.084    89.422     0.150
     6.084   154.609     0.150
     6.121    89.969     0.150
     6.121   156.070     0.150
     6.394    93.672     0.150
     6.394   162.867     0.150
     6.688    97.766     0.150
     6.688   169.289     0.150
     6.852   174.242     0.150
     7.214   105.766     0.150
     7.402   107.867     0.150
     7.402   188.766     0.150
     7.819   113.867     0.150
     0.805    16.676     0.150
     0.805    28.102     0.150
     0.925    19.031     0.150
     0.925    31.484     0.150
     0.925    18.590     0.150
     1.268    25.172     0.150
     1.268    42.234     0.150
     1.268    25.832     0.150
     1.513    28.613     0.150
     1.513    49.020     0.150
     1.874    33.828     0.150
     1.874    59.188     0.150
     1.861    31.777     0.150
     1.861    57.379     0.150
     2.013    36.414     0.150
     2.013    64.551     0.150
     2.013    35.902     0.150
     2.086    37.551     0.150
     2.086    64.992     0.150
     2.086    38.871     0.150
     2.299    39.469     0.150
     2.423    39.609     0.150
     2.423    68.598     0.150
     2.423    39.859     0.150
     3.402    64.105     0.150
     3.402   109.246     0.150
     3.834   103.887     0.150
     4.405    67.773     0.150
     4.405   117.586     0.150
     4.497   119.180     0.150
     4.497    69.141     0.150
     4.878    73.164     0.150
     4.878   126.062     0.150
     4.878   127.996     0.150
     4.941   130.516     0.150
     4.941    74.137     0.150
     4.941    74.000     0.150
     4.941   127.566     0.150
     5.022   130.562     0.150
     5.018    74.875     0.150
     5.018   129.012     0.150
     5.101    76.664     0.150
     5.101   132.762     0.150
     5.101    76.293     0.150
     5.101   130.703     0.150
     5.183   133.965     0.150
     5.269   136.699     0.150
     5.269    79.387     0.150
     5.269   134.695     0.150
     5.339    80.164     0.150
     5.430    80.844     0.150
     5.435    81.035     0.150
     5.435   139.898     0.150
     5.435    81.527     0.150
     5.435   140.324     0.150
     5.471    81.465     0.150
     5.471   141.164     0.150
     5.471   140.938     0.150
     5.471    81.297     0.150
     5.777    85.562     0.150
     5.777   148.562     0.150
     6.243   160.562     0.150
     6.753    99.262     0.150
     6.753   171.863     0.150
     6.821   171.406     0.150
     7.169   105.262     0.150
     7.169   182.562     0.150
     7.256   105.988     0.150
     0.176     5.072     0.150
     0.176     7.525     0.150
     0.675    14.219     0.150
     0.675    23.209     0.150
     0.756    15.961     0.150
     0.756    25.873     0.150
     1.311    25.295     0.150
     1.311    43.430     0.150
     1.311    25.713     0.150
     1.822    34.545     0.150
     1.822    60.893     0.150
     2.101    35.812     0.150
     2.101    63.371     0.150
     2.101    62.148     0.150
     2.101    35.008     0.150
     2.112    36.396     0.150
     2.112    60.496     0.150
     2.174    38.762     0.150
     2.174    65.371     0.150
     2.438    39.486     0.150
     2.719    46.855     0.150
     2.719    84.008     0.150
     2.793    47.162     0.150
     2.793    80.936     0.150
     2.793    53.674     0.150
     3.046    49.965     0.150
     3.046    91.242     0.150
     3.046    56.674     0.150
     3.405    53.723     0.150
     3.405    95.537     0.150
     3.378    53.076     0.150
     3.378    96.551     0.150
     4.489    68.305     0.150
     4.489   116.506     0.150
     4.489    67.410     0.150
     4.809    72.506     0.150
     4.809   125.605     0.150
     4.818    73.805     0.150
     4.818   125.805     0.150
     4.846    73.305     0.150
     4.846   126.006     0.150
     4.944    74.705     0.150
     4.944   127.105     0.150
     5.067    76.605     0.150
     5.067   132.205     0.150
     5.070    76.904     0.150
     5.070   132.105     0.150
     5.070    76.256     0.150
     5.070   129.545     0.150
     5.431    81.605     0.150
     5.585    83.506     0.150
     5.585   143.506     0.150
     5.747    85.904     0.150
     5.747   148.105     0.150
     5.747    85.023     0.150
     6.138    90.705     0.150
     6.138   157.805     0.150
     6.214    92.205     0.150
     6.214   158.006     0.150
     0.193     4.945     0.150
     0.193     7.879     0.150
     0.252     5.621     0.150
     0.953    19.656     0.150
     0.953    32.699     0.150
     1.250    24.148     0.150
     1.250    41.000     0.150
     1.852    34.203     0.150
     1.993    35.199     0.150
     1.993    38.203     0.150
     2.443    40.656     0.150
     2.443    41.223     0.150
     2.475    42.211     0.150
     2.875    46.422     0.150
     2.919    48.430     0.150
     5.383    80.734     0.150
     5.383   139.133     0.150
     5.383    79.637     0.150
     5.383    81.449     0.150
     5.865    86.234     0.150
     5.865   151.133     0.150
     5.929    88.836     0.150
     5.959    88.133     0.150
     5.959   153.434     0.150
     6.317    93.535     0.150
     6.665    98.633     0.150
     7.047   103.535     0.150
     0.940    18.801     0.150
     0.940    34.371     0.150
     0.940    19.758     0.150
     1.202    23.871     0.150
     1.202    43.000     0.150
     1.278    44.688     0.150
     1.416    27.316     0.150
     1.416    47.129     0.150
     1.416    27.758     0.150
     1.503    48.855     0.150
     1.503    28.672     0.150
     1.445    27.242     0.150
     1.445    48.242     0.150
     1.445    28.758     0.150
     1.408    26.391     0.150
     1.408    44.543     0.150
     1.408    26.758     0.150
     1.693    32.988     0.150
     1.693    54.121     0.150
     1.693    32.840     0.150
     1.693    54.605     0.150
     1.693    31.195     0.150
     1.705    32.383     0.150
     1.705    55.785     0.150
     1.705    32.766     0.150
     1.619    30.375     0.150
     1.619    51.562     0.150
     1.619    30.758     0.150
     1.758    33.133     0.150
     1.758    56.125     0.150
     1.758    33.766     0.150
     1.982    35.539     0.150
     1.982    62.586     0.150
     1.917    34.273     0.150
     1.917    59.293     0.150
     1.917    34.777     0.150
     1.998    36.867     0.150
     1.998    62.855     0.150
     2.056    36.199     0.150
     2.056    64.797     0.150
     2.696    44.035     0.150
     2.696    78.285     0.150
     2.902    48.949     0.150
     2.902    86.426     0.150
     2.902    49.809     0.150
     2.973    50.094     0.150
     2.973    90.453     0.150
     3.461    56.977     0.150
     3.395    55.195     0.150
     3.536    56.730     0.150
     3.544    56.789     0.150
     3.544    57.758     0.150
     3.901    62.711     0.150
     3.942    63.039     0.150
     3.948    63.199     0.150
     3.948    63.777     0.150
     4.489    67.926     0.150
     4.489   116.086     0.150
     4.489    67.691     0.150
     5.057    76.988     0.150
     5.057   133.602     0.150
     5.057    76.465     0.150
     5.057   134.602     0.150
     5.153    78.789     0.150
     5.153    78.578     0.150
     5.330    80.090     0.150
     5.330   138.188     0.150
     5.341    80.465     0.150
     5.341    81.242     0.150
     5.432    81.688     0.150
     5.432   140.391     0.150
     5.432    81.223     0.150
     5.432    81.582     0.150
     5.425    82.961     0.150
     5.427    83.000     0.150
     5.505    82.488     0.150
     5.505   141.891     0.150
     5.509    82.594     0.150
     5.509    82.949     0.150
     5.509   141.609     0.150
     5.601    83.891     0.150
     5.601   144.488     0.150
     5.601   143.109     0.150
     5.623    84.070     0.150
     5.623   144.578     0.150
     5.726    85.891     0.150
     5.726   147.289     0.150
     5.726   147.984     0.150
     5.842    87.590     0.150
     5.842   149.391     0.150
     5.910    88.012     0.150
     5.910    88.367     0.150
     5.910   151.703     0.150
     5.968    89.090     0.150
     5.968   153.590     0.150
     5.968    88.961     0.150
     6.062   156.188     0.150
     6.066    90.488     0.150
     6.066   155.891     0.150
     6.066    90.301     0.150
     6.066   156.461     0.150
     6.088    90.398     0.150
     6.088    90.188     0.150
     6.088   157.008     0.150
     6.089    93.367     0.150
     6.089   159.434     0.150
     6.307    93.590     0.150
     6.307   161.488     0.150
     6.307    93.395     0.150
     6.307   161.328     0.150
     6.579    97.188     0.150
     6.579   168.188     0.150
     6.579   167.551     0.150
     6.636    98.055     0.150
     6.636    98.172     0.150
     6.636   169.148     0.150
     6.825   100.891     0.150
     6.825   174.590     0.150
     6.825   100.672     0.150
     6.869   101.645     0.150
     7.140   104.988     0.150
     7.140   182.391     0.150
     7.308   108.090     0.150
     7.308   186.988     0.150
     7.346   108.090     0.150
     7.346   186.188     0.150
     7.382   110.738     0.150
     7.474   109.078     0.150
     7.474   187.645     0.150
     7.696   113.590     0.150
     7.762   113.891     0.150
     7.762   195.891     0.150
     7.884   115.441     0.150
     7.884   197.781     0.150
     8.143   208.590     0.150
     8.322   120.590     0.150
     8.322   210.688     0.150
     9.026   131.188     0.150
     9.026   228.188     0.150
     9.178   133.707     0.150
     9.313   135.090     0.150
     9.644   139.891     0.150
     9.780   141.512     0.150
     9.834   142.000     0.150
     9.960   144.391     0.150
    11.220   161.445     0.150
     0.236     6.609     0.150
     0.236    10.422     0.150
     0.746    15.445     0.150
     0.746    23.641     0.150
     0.746    25.688     0.150
     0.746    15.305     0.150
     0.804    15.633     0.150
     0.804    28.578     0.150
     1.380    25.500     0.150
     1.206    38.320     0.150
     1.206    22.750     0.150
     1.333    24.484     0.150
     1.333    43.461     0.150
     1.467    27.492     0.150
     1.467    45.031     0.150
     1.528    28.289     0.150
     1.528    48.109     0.150
     1.659    29.023     0.150
     1.659    52.461     0.150
     2.022    36.117     0.150
     2.022    61.359     0.150
     2.314    39.211     0.150
     2.314    64.273     0.150
     2.323    41.273     0.150
     2.323    68.938     0.150
     2.570    42.617     0.150
     2.570    73.883     0.150
     2.557    42.969     0.150
     2.651    43.641     0.150
     2.651    75.273     0.150
     3.197    51.250     0.150
     3.197    88.828     0.150
     3.477    53.633     0.150
     3.477    94.336     0.150
     3.625    94.836     0.150
     4.276   111.055     0.150
     4.365    64.531     0.150
     4.365   112.750     0.150
     4.365   110.922     0.150
     4.529    67.578     0.150
     4.529   116.523     0.150
     4.529   115.562     0.150
     4.918    73.062     0.150
     4.918   125.672     0.150
     4.918   125.898     0.150
     4.918    72.797     0.150
     4.951   126.500     0.150
     4.951    73.305     0.150
     5.175    75.562     0.150
     5.175   129.977     0.150
     5.528    81.047     0.150
     5.528   140.250     0.150
     5.528    80.820     0.150
     6.012    86.992     0.150
     6.012   150.562     0.150
     6.543    94.539     0.150
     6.543   163.578     0.150
     0.463    10.770     0.150
     0.463    17.251     0.150
     0.852    28.722     0.150
     0.852    17.057     0.150
     1.036    20.402     0.150
     1.088    19.941     0.150
     1.220    22.957     0.150
     1.220    37.621     0.150
     1.352    25.132     0.150
     1.352    41.604     0.150
     2.454    40.062     0.150
     2.454    68.262     0.150
     2.566    70.327     0.150
     2.566    41.232     0.150
     2.566    70.739     0.150
     3.126    48.195     0.150
     4.198    62.569     0.150
     4.198   105.769     0.150
     4.292    64.169     0.150
     4.415    64.369     0.150
     4.415   111.369     0.150
     4.496    65.569     0.150
     4.496   113.169     0.150
     4.592    67.569     0.150
     4.735    69.069     0.150
     4.791    70.094     0.150
     4.837    70.969     0.150
     4.837   121.369     0.150
     4.915    71.869     0.150
     4.915   123.169     0.150
     5.180    75.269     0.150
     5.180    75.111     0.150
     5.436    78.669     0.150
     5.485    79.366     0.150
     1.031    18.617     0.150
     0.856    28.688     0.150
     0.856    17.742     0.150
     1.108    22.625     0.150
     1.108    38.438     0.150
     1.130    21.883     0.150
     1.130    36.820     0.150
     1.149    40.539     0.150
     1.696    31.336     0.150
     1.696    54.656     0.150
     1.695    29.602     0.150
     1.759    32.961     0.150
     1.759    58.633     0.150
     2.007    33.906     0.150
     2.262    38.938     0.150
     2.262    65.023     0.150
     2.348    40.734     0.150
     2.348    70.977     0.150
     2.493    40.547     0.150
     2.493    69.852     0.150
     2.472    43.703     0.150
     2.435    41.562     0.150
     2.435    71.086     0.150
     4.321   113.578     0.150
     4.414   113.242     0.150
     4.414    67.516     0.150
     4.485   117.445     0.150
     4.485    67.344     0.150
     4.535   118.883     0.150
     4.535   117.680     0.150
     4.714   123.281     0.150
     4.959   129.781     0.150
     4.904    73.953     0.150
     4.904   126.977     0.150
     5.036    76.078     0.150
     5.036   130.781     0.150
     5.036   129.945     0.150
     5.036    75.344     0.150
     5.114   131.383     0.150
     5.303   137.680     0.150
     5.303    78.391     0.150
     5.606    82.727     0.150
     0.549    11.516     0.150
     0.549    21.984     0.150
     0.748    26.477     0.150
     0.748    15.180     0.150
     0.786    15.734     0.150
     0.770    15.516     0.150
     1.606    25.133     0.150
     1.606    46.766     0.150
     1.982    53.922     0.150
     1.909    33.562     0.150
     1.909    60.352     0.150
     1.985    30.953     0.150
     1.985    54.930     0.150
     1.906    30.352     0.150
     1.906    56.383     0.150
     2.080    33.969     0.150
     2.080    63.125     0.150
     2.857    44.953     0.150
     2.857    82.164     0.150
     3.071    46.539     0.150
     3.071    79.727     0.150
     2.953    44.766     0.150
     2.953    80.492     0.150
     3.378    50.047     0.150
     3.378    49.109     0.150
     3.371    50.312     0.150
     3.590    97.695     0.150
     3.843   100.219     0.150
     4.378    64.555     0.150
     4.378   116.625     0.150
     4.648    68.922     0.150
     4.648    68.672     0.150
     4.647    68.586     0.150
     4.682    69.008     0.150
     4.682   119.102     0.150
     4.682    68.039     0.150
     4.789    70.664     0.150
     4.789   122.867     0.150
     4.804    69.633     0.150
     4.804   121.609     0.150
     4.807    69.766     0.150
     4.807    69.438     0.150
     5.144    75.164     0.150
     5.175    75.266     0.150
     5.175   131.266     0.150
     5.175    75.102     0.150
     5.206    75.867     0.150
     5.224    76.461     0.150
     5.224   134.062     0.150
     5.396    78.461     0.150
     5.396   137.766     0.150
     5.396    77.766     0.150
     5.689    82.438     0.150
     5.689   141.656     0.150
     5.760    83.266     0.150
     5.760   146.164     0.150
     5.988    86.266     0.150
     6.408    92.062     0.150
     6.423    92.867     0.150
     6.699    96.180     0.150
     6.826    98.461     0.150
     7.020   101.562     0.150
     0.893    19.320     0.150
     0.893    31.422     0.150
     1.270    25.273     0.150
     1.270    41.328     0.150
     1.298    43.836     0.150
     1.321    26.602     0.150
     1.321    45.344     0.150
     1.373    29.250     0.150
     1.373    47.969     0.150
     1.818    34.445     0.150
     1.669    33.227     0.150
     1.669    54.773     0.150
     1.757    34.680     0.150
     1.757    59.664     0.150
     1.832    35.055     0.150
     1.832    60.234     0.150
     1.977    37.500     0.150
     1.977    61.648     0.150
     2.066    38.539     0.150
     2.066    61.844     0.150
     1.905    36.562     0.150
     1.905    61.609     0.150
     4.173    66.875     0.150
     5.579    84.961     0.150
     5.579   145.266     0.150
     5.702   148.461     0.150
     5.977    90.266     0.150
     5.977   155.062     0.150
     6.039    90.164     0.150
     6.039   156.766     0.150
     6.398    96.562     0.150
     6.398   165.664     0.150
     6.535   168.961     0.150
     0.496    11.551     0.150
     0.577    20.820     0.150
     0.577    12.398     0.150
     0.749    14.930     0.150
     0.749    27.449     0.150
     1.113    19.969     0.150
     1.113    35.195     0.150
     0.940    18.758     0.150
     1.383    25.180     0.150
     1.383    44.180     0.150
     1.221    22.207     0.150
     1.342    25.246     0.150
     1.735    30.145     0.150
     1.735    54.441     0.150
     1.938    31.602     0.150
     1.938    56.828     0.150
     2.214    36.254     0.150
     2.214    63.289     0.150
     2.085    35.188     0.150
     2.085    63.719     0.150
     2.702    43.539     0.150
     2.702    78.848     0.150
     2.705    42.758     0.150
     2.705    78.715     0.150
     2.908    44.395     0.150
     2.908    77.492     0.150
     2.908    44.191     0.150
     2.908    78.000     0.150
     2.971    45.117     0.150
     2.974    46.395     0.150
     2.956    47.684     0.150
     2.956    85.918     0.150
     3.112    45.840     0.150
     3.112    82.438     0.150
     3.104    90.355     0.150
     3.104    49.113     0.150
     3.197    49.648     0.150
     3.552    53.340     0.150
     3.552    93.035     0.150
     3.598    55.566     0.150
     3.900    58.020     0.150
     3.900    97.621     0.150
     3.969    59.121     0.150
     3.969    99.422     0.150
     3.969    59.598     0.150
     3.969    58.855     0.150
     4.018   100.926     0.150
     4.018    59.957     0.150
     4.065   102.457     0.150
     4.195   107.820     0.150
     4.252    62.820     0.150
     4.252    62.652     0.150
     4.285    63.520     0.150
     4.285   110.320     0.150
     4.311    63.781     0.150
     4.311   109.035     0.150
     4.311   111.836     0.150
     4.483    65.922     0.150
     4.483   114.820     0.150
     4.535    67.020     0.150
     4.535   116.223     0.150
     4.535    66.562     0.150
     4.524    66.223     0.150
     4.524   116.422     0.150
     4.524    65.914     0.150
     4.497    65.887     0.150
     4.497   113.852     0.150
     4.497   114.180     0.150
     4.497    65.754     0.150
     4.582    68.875     0.150
     4.582   120.352     0.150
     4.889    72.020     0.150
     4.889   124.922     0.150
     5.085    73.613     0.150
     5.085   126.426     0.150
     5.085   127.473     0.150
     5.305    77.422     0.150
     5.305    76.824     0.150
     5.658    82.820     0.150
     5.880    84.160     0.150
     5.880   145.902     0.150
     0.555    12.504     0.150
     0.555    20.594     0.150
     0.756    15.842     0.150
     0.756    25.961     0.150
     0.796    27.664     0.150
     0.845    17.025     0.150
     0.845    28.680     0.150
     1.080    22.252     0.150
     1.080    36.686     0.150
     1.596    29.004     0.150
     1.596    50.746     0.150
     1.704    32.367     0.150
     1.704    54.459     0.150
     1.895    34.725     0.150
     1.895    58.340     0.150
     1.899    33.779     0.150
     1.973    34.482     0.150
     1.973    59.889     0.150
     1.975    34.605     0.150
     1.975    60.529     0.150
     2.024    37.613     0.150
     2.024    64.619     0.150
     2.086    38.301     0.150
     2.086    64.586     0.150
     2.679    45.168     0.150
     2.679    78.119     0.150
     2.679    45.510     0.150
     2.852    47.617     0.150
     3.066    47.799     0.150
     3.066    82.195     0.150
     3.263    55.969     0.150
     3.263    96.898     0.150
     3.371    52.068     0.150
     3.371    91.357     0.150
     3.381    57.582     0.150
     3.381   100.055     0.150
     3.854    61.309     0.150
     4.642    71.398     0.150
     4.642   122.111     0.150
     4.644    71.775     0.150
     4.644   122.111     0.150
     4.644    71.674     0.150
     4.680    71.273     0.150
     4.680   122.111     0.150
     4.790    71.832     0.150
     4.790   124.531     0.150
     4.804    72.277     0.150
     4.804   123.869     0.150
     4.804   123.234     0.150
     4.808    72.031     0.150
     4.808   124.732     0.150
     4.808   124.057     0.150
     4.808    71.773     0.150
     5.145    77.332     0.150
     5.145   132.432     0.150
     5.173    77.832     0.150
     5.173   133.432     0.150
     5.208    78.031     0.150
     5.226    79.432     0.150
     5.226   135.531     0.150
     5.397    80.732     0.150
     5.397   139.131     0.150
     5.397    79.961     0.150
     5.397   137.342     0.150
     5.438    82.031     0.150
     5.438   142.232     0.150
     5.549    83.324     0.150
     5.687    84.453     0.150
     5.687   144.832     0.150
     5.687    83.869     0.150
     5.761    85.732     0.150
     5.761   147.932     0.150
     5.865    87.131     0.150
     5.865   150.432     0.150
     5.865    86.469     0.150
     5.986    88.932     0.150
     5.986   153.232     0.150
     6.407    94.432     0.150
     6.407   163.432     0.150
     6.421    94.732     0.150
     6.421   162.932     0.150
     6.824   100.332     0.150
     7.019   103.332     0.150
     0.682    13.677     0.150
     0.682    23.380     0.150
     0.618    13.106     0.150
     0.618    21.896     0.150
     0.857    17.558     0.150
     0.857    29.431     0.150
     0.973    20.641     0.150
     0.973    32.513     0.150
     1.170    22.125     0.150
     1.170    36.737     0.150
     1.261    24.864     0.150
     1.261    40.618     0.150
     1.339    25.663     0.150
     1.339    43.929     0.150
     1.386    25.663     0.150
     1.386    45.070     0.150
     1.470    28.061     0.150
     1.470    49.294     0.150
     2.884    49.751     0.150
     3.000    47.924     0.150
     3.905    59.763     0.150
     3.905   102.863     0.150
     3.981    60.963     0.150
     3.981   104.663     0.150
     4.293   112.563     0.150
     4.475   115.863     0.150
     4.542    68.263     0.150
     4.558    67.763     0.150
     4.558   117.963     0.150
     4.893    73.363     0.150
     4.893   127.363     0.150
     5.332   137.063     0.150
     0.324     7.148     0.150
     0.324    12.711     0.150
     0.937    17.562     0.150
     0.937    30.852     0.150
     1.492    26.188     0.150
     1.492    45.398     0.150
     1.560    26.000     0.150
     1.560    47.555     0.150
     2.196    37.625     0.150
     2.196    65.961     0.150
     2.208    38.930     0.150
     2.208    65.875     0.150
     2.318    71.203     0.150
     2.420    72.969     0.150
     4.784    74.047     0.150
     6.204    90.453     0.150
     6.204   156.953     0.150
     6.467    92.953     0.150
     6.467   162.758     0.150
     6.499   162.453     0.150
     6.697    97.656     0.150
     6.697   167.656     0.150
     6.928   100.258     0.150
     6.928   172.555     0.150
     7.012   175.055     0.150
     7.645   191.055     0.150
     8.191   117.852     0.150
     8.191   201.852     0.150
     0.226     6.257     0.150
     0.226    10.316     0.150
     0.829    16.773     0.150
     0.829    29.466     0.150
     1.191    23.120     0.150
     1.191    39.274     0.150
     1.214    23.154     0.150
     1.214    38.562     0.150
     1.360    25.139     0.150
     1.360    41.870     0.150
     1.467    26.581     0.150
     1.467    46.435     0.150
     1.598    27.773     0.150
     1.598    50.242     0.150
     1.636    30.331     0.150
     2.414    41.005     0.150
     2.414    71.583     0.150
     4.110   106.888     0.150
     4.216    62.988     0.150
     4.216   108.188     0.150
     4.380   112.888     0.150
     4.506   115.388     0.150
     4.622   118.588     0.150
     4.748    70.988     0.150
     4.748   121.688     0.150
     4.877    72.488     0.150
     4.877   123.388     0.150
     5.085    74.988     0.150
     5.085   128.788     0.150
     5.622   142.588     0.150
     6.153    89.388     0.150
     6.153   155.388     0.150
     0.264     6.908     0.150
     0.264    10.994     0.150
     0.871    16.662     0.150
     0.871    28.555     0.150
     0.871    17.641     0.150
     0.871    28.848     0.150
     1.063    35.389     0.150
     1.063    21.002     0.150
     1.149    23.100     0.150
     1.149    37.742     0.150
     1.186    23.025     0.150
     1.186    39.650     0.150
     1.321    23.807     0.150
     1.321    41.609     0.150
     1.425    26.572     0.150
     1.425    46.113     0.150
     1.556    28.271     0.150
     1.556    48.096     0.150
     1.630    29.404     0.150
     1.630    50.955     0.150
     2.414    41.441     0.150
     2.414    73.020     0.150
     2.446    39.490     0.150
     2.446    71.520     0.150
     2.491    76.545     0.150
     2.611    41.906     0.150
     2.611    74.373     0.150
     3.330    49.768     0.150
     3.330    88.545     0.150
     4.128   106.299     0.150
     4.232    63.600     0.150
     4.232   109.600     0.150
     4.314   112.287     0.150
     4.314    64.928     0.150
     4.403    65.898     0.150
     4.403   113.998     0.150
     4.524    67.898     0.150
     4.524   115.898     0.150
     4.644    69.600     0.150
     4.644   117.998     0.150
     4.766    71.498     0.150
     4.766   122.600     0.150
     4.821   123.588     0.150
     4.821    71.982     0.150
     4.887    73.199     0.150
     4.887   124.299     0.150
     4.887   124.875     0.150
     5.104    75.398     0.150
     5.104   130.498     0.150
     5.380   138.100     0.150
     5.461    80.611     0.150
     5.461   138.467     0.150
     5.941    87.600     0.150
     5.941   151.299     0.150
     0.724    14.984     0.150
     0.724    25.859     0.150
     0.807    16.891     0.150
     0.807    29.391     0.150
     1.084    36.125     0.150
     1.084    22.031     0.150
     1.379    26.125     0.150
     1.379    43.836     0.150
     1.489    25.734     0.150
     1.489    47.844     0.150
     1.634    29.750     0.150
     1.634    53.305     0.150
     1.825    30.586     0.150
     1.825    55.750     0.150
     1.825    56.273     0.150
     1.825    32.477     0.150
     1.902    34.281     0.150
     1.902    58.469     0.150
     2.045    36.188     0.150
     2.045    63.086     0.150
     2.163    38.852     0.150
     2.348    39.070     0.150
     2.348    66.078     0.150
     2.391    38.414     0.150
     2.391    68.797     0.150
     2.441    41.992     0.150
     2.441    73.469     0.150
     3.064    48.539     0.150
     3.064    84.367     0.150
     3.586    56.141     0.150
     3.586    98.367     0.150
     5.170   133.688     0.150
     5.253   136.188     0.150
     5.561   142.781     0.150
     5.592   144.836     0.150
     5.832    87.281     0.150
     5.832   149.883     0.150
     6.394   164.039     0.150
     0.513    11.352     0.150
     0.513    17.840     0.150
     0.434    15.762     0.150
     0.705    15.332     0.150
     0.705    24.035     0.150
     1.115    22.898     0.150
     1.115    37.465     0.150
     1.381    25.688     0.150
     1.381    45.516     0.150
     1.813    32.719     0.150
     1.813    55.562     0.150
     1.728    31.309     0.150
     1.728    51.742     0.150
     1.969    34.965     0.150
     1.979    34.168     0.150
     1.979    34.375     0.150
     2.109    36.887     0.150
     2.251    38.609     0.150
     2.402    41.312     0.150
     2.434    41.484     0.150
     2.530    43.621     0.150
     2.683    43.953     0.150
     2.808    44.852     0.150
     2.779    46.004     0.150
     2.897    79.637     0.150
     2.898    47.336     0.150
     2.859    47.117     0.150
     2.966    48.434     0.150
     2.913    47.562     0.150
     3.454    53.980     0.150
     3.454    93.266     0.150
     3.339    53.953     0.150
     3.561    55.590     0.150
     3.561    94.723     0.150
     3.767    58.453     0.150
     4.036    62.102     0.150
     4.036   105.914     0.150
     4.036    62.297     0.150
     4.036   108.242     0.150
     4.174    64.539     0.150
     4.174   111.477     0.150
     4.281    67.055     0.150
     4.281   115.215     0.150
     4.402    68.453     0.150
     4.402   117.594     0.150
     4.832    72.125     0.150
     4.832   124.824     0.150
     4.892    73.223     0.150
     4.892   126.523     0.150
     4.929    73.508     0.150
     4.929   126.590     0.150
     4.929    73.867     0.150
     4.929   127.531     0.150
     4.928    73.828     0.150
     4.928   126.594     0.150
     4.928    74.090     0.150
     4.928   127.398     0.150
     5.068    75.918     0.150
     5.068   129.238     0.150
     5.068    76.371     0.150
     5.068   131.363     0.150
     5.139    76.223     0.150
     5.139   133.422     0.150
     5.169    78.227     0.150
     5.169   134.039     0.150
     5.194    77.324     0.150
     5.194   135.324     0.150
     5.213    77.723     0.150
     5.213   134.324     0.150
     5.213   133.590     0.150
     5.401    80.422     0.150
     5.401   138.125     0.150
     5.401   136.602     0.150
     5.423    80.723     0.150
     5.423   140.625     0.150
     5.464    80.922     0.150
     5.464   142.723     0.150
     5.502   141.824     0.150
     5.820    86.422     0.150
     5.820   148.223     0.150
     5.903    88.680     0.150
     5.903   152.410     0.150
     5.950    88.043     0.150
     5.950   151.848     0.150
     5.950   152.398     0.150
     6.009    89.023     0.150
     6.009   154.824     0.150
     6.009    88.273     0.150
     6.009   153.133     0.150
     6.195    91.422     0.150
     6.195   158.824     0.150
     6.195    91.246     0.150
     6.195   157.727     0.150
     6.317    95.637     0.150
     6.566    96.223     0.150
     6.566   167.125     0.150
     6.555    96.738     0.150
     6.555   166.570     0.150
     6.678   169.422     0.150
     7.091   103.824     0.150
     7.091   179.125     0.150
     7.092   103.625     0.150
     8.167   120.238     0.150
     8.167   206.691     0.150
     8.293   120.324     0.150
     8.630   124.824     0.150
     0.496    10.906     0.150
     0.496    17.793     0.150
     0.516    11.078     0.150
     0.516    18.207     0.150
     1.052    21.273     0.150
     1.052    35.883     0.150
     1.330    26.754     0.150
     1.330    41.789     0.150
     1.510    50.059     0.150
     1.687    31.848     0.150
     1.687    54.891     0.150
     1.795    33.293     0.150
     1.795    57.836     0.150
     2.190    39.355     0.150
     2.297    40.801     0.150
     2.328    41.000     0.150
     2.328    70.641     0.150
     2.375    39.770     0.150
     2.375    68.996     0.150
     3.027    51.184     0.150
     3.576    57.832     0.150
     5.507   139.992     0.150
     5.572    83.492     0.150
     5.572   143.992     0.150
     5.572    83.293     0.150
     5.796   150.391     0.150
     5.858   149.891     0.150
     5.890   150.594     0.150
     6.085    90.391     0.150
     6.085   155.793     0.150
     6.496    96.891     0.150
     6.496   166.891     0.150
     7.249   184.191     0.150
     0.153     4.043     0.150
     0.604    12.602     0.150
     0.604    21.688     0.150
     0.633    13.695     0.150
     0.879    17.820     0.150
     0.879    31.449     0.150
     1.068    21.520     0.150
     1.068    38.062     0.150
     1.321    26.145     0.150
     1.321    44.578     0.150
     1.423    27.422     0.150
     1.423    46.898     0.150
     1.424    27.223     0.150
     1.424    46.906     0.150
     1.771    56.016     0.150
     1.771    33.812     0.150
     1.771    31.445     0.150
     1.854    35.457     0.150
     2.451    41.043     0.150
     2.451    71.648     0.150
     2.583    43.691     0.150
     3.763    57.422     0.150
     3.813    58.023     0.150
     3.813   100.820     0.150
     3.839   101.855     0.150
     3.843   103.578     0.150
     3.914    61.949     0.150
     3.914   107.664     0.150
     4.024    62.711     0.150
     4.024   104.832     0.150
     4.025    62.293     0.150
     4.025   111.391     0.150
     4.152    64.422     0.150
     4.181    64.941     0.150
     4.181   109.562     0.150
     4.311    66.223     0.150
     4.311   113.223     0.150
     4.375    68.121     0.150
     4.390    67.523     0.150
     4.390   116.723     0.150
     4.749   125.621     0.150
     5.104    77.723     0.150
     5.104   132.922     0.150
     5.479    82.820     0.150
     5.479   141.523     0.150
     5.588    84.121     0.150
     0.749    15.758     0.150
     0.749    27.035     0.150
     0.719    15.199     0.150
     0.719    24.320     0.150
     0.825    25.750     0.150
     0.825    16.031     0.150
     0.942    19.105     0.150
     0.942    30.555     0.150
     1.233    22.312     0.150
     1.233    37.699     0.150
     1.233    38.207     0.150
     1.282    25.199     0.150
     1.282    41.062     0.150
     1.259    23.320     0.150
     1.259    39.395     0.150
     1.387    25.449     0.150
     1.387    44.473     0.150
     1.911    31.422     0.150
     1.911    54.863     0.150
     1.963    34.895     0.150
     1.963    60.781     0.150
     1.981    33.766     0.150
     2.137    34.938     0.150
     2.337    38.473     0.150
     2.761    44.477     0.150
     2.827    43.895     0.150
     2.876    45.387     0.150
     2.876    49.566     0.150
     2.876    77.465     0.150
     2.876    46.137     0.150
     2.932    44.758     0.150
     3.121    47.566     0.150
     3.121    83.883     0.150
     3.264    86.207     0.150
     3.264    87.102     0.150
     3.196    49.641     0.150
     3.689    54.848     0.150
     3.789    56.809     0.150
     3.789    99.398     0.150
     3.969    59.832     0.150
     3.969   103.031     0.150
     3.969    60.238     0.150
     4.052    60.934     0.150
     4.052   103.730     0.150
     4.052    60.641     0.150
     4.052   104.922     0.150
     4.152    62.656     0.150
     4.152   109.680     0.150
     4.198    62.402     0.150
     4.198   107.254     0.150
     4.223   107.332     0.150
     4.293    63.832     0.150
     4.293   110.531     0.150
     4.293   109.703     0.150
     4.359    65.633     0.150
     4.359   112.633     0.150
     4.359    65.520     0.150
     4.359   112.207     0.150
     4.491    67.188     0.150
     4.491   113.320     0.150
     4.491   114.449     0.150
     4.528    67.332     0.150
     4.528   116.730     0.150
     4.607    68.832     0.150
     4.607   118.832     0.150
     4.607    68.723     0.150
     4.607   117.070     0.150
     4.647    69.230     0.150
     4.647   118.031     0.150
     4.647    68.965     0.150
     4.700    69.242     0.150
     4.700   118.801     0.150
     4.700    69.355     0.150
     4.700   119.453     0.150
     4.818    72.926     0.150
     4.818   127.402     0.150
     4.955    73.230     0.150
     4.955   125.934     0.150
     4.955   124.887     0.150
     5.190   130.426     0.150
     5.214    76.559     0.150
     5.214   131.922     0.150
     5.513    81.090     0.150
     5.513   138.820     0.150
     5.751    83.832     0.150
     5.751   146.531     0.150
     5.928    86.230     0.150
     5.928   150.832     0.150
     6.079    88.035     0.150
     6.079   150.801     0.150
     6.183   160.133     0.150
     6.344   160.230     0.150
     6.454    93.414     0.150
     6.454   161.145     0.150
     7.181   103.910     0.150
     7.181   177.418     0.150
     7.598   109.633     0.150
     7.598   189.531     0.150
     0.467    10.219     0.150
     0.774    16.508     0.150
     0.803    16.648     0.150
     0.803    27.617     0.150
     0.934    17.203     0.150
     0.934    32.828     0.150
     1.037    20.141     0.150
     1.037    34.773     0.150
     1.075    18.953     0.150
     1.075    36.961     0.150
     1.287    25.109     0.150
     1.287    42.891     0.150
     1.439    25.594     0.150
     1.439    46.930     0.150
     1.520    28.141     0.150
     1.520    49.141     0.150
     1.515    27.086     0.150
     1.515    47.242     0.150
     1.551    28.422     0.150
     1.551    50.344     0.150
     1.545    26.930     0.150
     1.545    50.930     0.150
     1.698    29.828     0.150
     1.698    52.367     0.150
     1.730    29.867     0.150
     2.220    36.367     0.150
     2.220    62.641     0.150
     2.579    74.102     0.150
     2.579    42.273     0.150
     2.579    39.977     0.150
     2.579    73.727     0.150
     2.724    85.625     0.150
     2.724    43.328     0.150
     2.724    43.516     0.150
     2.814    42.938     0.150
     2.814    80.070     0.150
     3.142    50.438     0.150
     3.599    56.711     0.150
     3.797    59.680     0.150
     3.797   101.289     0.150
     3.801    57.836     0.150
     3.866    57.883     0.150
     3.977    63.586     0.150
     4.036    60.773     0.150
     4.036    60.297     0.150
     4.036   104.523     0.150
     4.059    60.719     0.150
     4.059   106.320     0.150
     4.059    60.492     0.150
     4.059   105.391     0.150
     4.064    60.719     0.150
     4.064   106.023     0.150
     4.363    66.625     0.150
     4.363   113.922     0.150
     4.363   113.328     0.150
     4.400    67.219     0.150
     4.400   115.125     0.150
     4.535    69.523     0.150
     4.535   118.219     0.150
     4.541    67.820     0.150
     4.541   118.719     0.150
     4.650    69.320     0.150
     4.650   120.320     0.150
     4.650    69.141     0.150
     4.852    75.891     0.150
     4.864    72.516     0.150
     4.864   125.578     0.150
     4.864   125.398     0.150
     5.015    74.320     0.150
     5.015   129.820     0.150
     5.080    75.523     0.150
     5.080   130.820     0.150
     5.112    77.578     0.150
     5.178    77.922     0.150
     5.597    82.922     0.150
     5.597   142.922     0.150
     5.614    82.719     0.150
     5.614   144.719     0.150
     5.997    88.422     0.150
     0.745    15.761     0.150
     1.069    21.673     0.150
     1.069    34.989     0.150
     1.127    22.537     0.150
     1.127    37.795     0.150
     1.158    22.652     0.150
     1.158    39.001     0.150
     1.230    21.976     0.150
     1.451    27.589     0.150
     1.451    45.951     0.150
     1.604    28.328     0.150
     1.604    49.446     0.150
     1.628    28.451     0.150
     1.628    52.188     0.150
     1.803    32.477     0.150
     1.803    55.109     0.150
     1.958    34.878     0.150
     1.958    59.211     0.150
     2.341    69.047     0.150
     2.737    77.573     0.150
     2.889    44.857     0.150
     2.889    77.953     0.150
     2.889    44.971     0.150
     3.025    49.502     0.150
     3.025    82.812     0.150
     2.987    49.452     0.150
     2.987    83.634     0.150
     2.987    47.472     0.150
     2.987    84.305     0.150
     2.967    47.146     0.150
     2.967    83.431     0.150
     3.104    48.454     0.150
     3.104    48.709     0.150
     3.104    83.222     0.150
     3.230    51.014     0.150
     3.230    88.143     0.150
     3.344    55.250     0.150
     3.344    92.379     0.150
     3.923   107.762     0.150
     4.084    64.969     0.150
     4.084   111.815     0.150
     4.431    68.780     0.150
     4.431    68.893     0.150
     4.480    69.946     0.150
     4.480   118.046     0.150
     4.771    71.560     0.150
     4.771   122.569     0.150
     4.771    71.697     0.150
     4.771   122.282     0.150
     4.792    72.381     0.150
     4.792   124.181     0.150
     4.792    72.112     0.150
     4.793    72.480     0.150
     4.793   124.181     0.150
     4.793    71.861     0.150
     4.793   123.382     0.150
     5.093    76.881     0.150
     5.093   131.381     0.150
     5.093    76.575     0.150
     5.093   130.938     0.150
     5.133    77.081     0.150
     5.133   131.881     0.150
     5.133    76.979     0.150
     5.256    78.980     0.150
     5.256   136.381     0.150
     5.256    78.681     0.150
     5.254   135.581     0.150
     5.344    79.781     0.150
     5.344   137.781     0.150
     5.383    80.581     0.150
     5.383   139.480     0.150
     5.383    80.321     0.150
     5.383   137.991     0.150
     5.458    81.581     0.150
     5.458   141.681     0.150
     5.588    83.850     0.150
     5.588   143.258     0.150
     5.588   144.210     0.150
     5.748    85.480     0.150
     5.748   147.881     0.150
     5.748    85.249     0.150
     5.748   146.555     0.150
     5.908    88.081     0.150
     5.908   151.980     0.150
     6.319    93.881     0.150
     6.319   161.781     0.150
     6.348    94.480     0.150
     6.348   162.781     0.150
     6.716    99.581     0.150
     6.967   102.980     0.150
     7.641   112.581     0.150
     0.368     8.211     0.150
     0.368    12.977     0.150
     0.540    11.867     0.150
     1.130    23.180     0.150
     1.130    39.695     0.150
     1.314    25.062     0.150
     1.314    42.367     0.150
     1.283    25.094     0.150
     1.283    42.359     0.150
     1.728    50.930     0.150
     1.646    28.891     0.150
     1.646    51.914     0.150
     1.740    31.945     0.150
     1.740    55.070     0.150
     1.881    33.914     0.150
     1.903    33.141     0.150
     1.903    57.102     0.150
     1.903    59.734     0.150
     2.459    42.562     0.150
     2.459    74.422     0.150
     2.462    42.164     0.150
     2.705    44.406     0.150
     2.705    77.492     0.150
     2.705    44.609     0.150
     3.595    96.016     0.150
     3.687    57.547     0.150
     4.085    63.578     0.150
     4.085    63.008     0.150
     4.085   106.969     0.150
     4.818    71.930     0.150
     4.818   124.234     0.150
     4.882    73.133     0.150
     4.882   126.234     0.150
     4.923    74.484     0.150
     4.923   128.133     0.150
     5.091    76.461     0.150
     5.091   131.312     0.150
     5.172    77.328     0.150
     5.172   134.328     0.150
     5.172   132.555     0.150
     5.200   134.031     0.150
     5.404    80.531     0.150
     5.404   139.031     0.150
     5.451    80.930     0.150
     5.451   140.430     0.150
     5.451    80.750     0.150
     5.451   138.602     0.150
     5.806   148.633     0.150
     5.956    88.594     0.150
     5.956   152.664     0.150
     6.003    88.734     0.150
     6.003   153.734     0.150
     6.195    91.633     0.150
     6.195   158.031     0.150
     6.682    98.328     0.150
     7.096   103.734     0.150
     0.212     4.844     0.150
     0.212     7.734     0.150
     0.480    10.844     0.150
     0.972    19.469     0.150
     0.972    34.078     0.150
     0.995    20.703     0.150
     0.995    34.289     0.150
     1.062    21.602     0.150
     1.062    34.477     0.150
     1.100    22.648     0.150
     1.100    36.352     0.150
     1.291    24.844     0.150
     1.291    42.203     0.150
     1.422    27.281     0.150
     1.422    46.781     0.150
     1.483    28.297     0.150
     1.565    29.297     0.150
     1.565    49.336     0.150
     2.019    34.953     0.150
     2.019    62.688     0.150
     2.078    34.203     0.150
     2.078    60.844     0.150
     2.291    38.336     0.150
     2.291    69.305     0.150
     2.427    41.695     0.150
     2.427    73.836     0.150
     2.672    43.797     0.150
     2.672    77.117     0.150
     3.522    57.258     0.150
     3.699    58.227     0.150
     3.699   102.102     0.150
     3.881    60.195     0.150
     3.910   103.297     0.150
     3.942    60.508     0.150
     3.942   103.711     0.150
     4.043    62.352     0.150
     4.043   105.688     0.150
     4.243   110.898     0.150
     4.336    65.797     0.150
     4.336   112.492     0.150
     4.496    67.797     0.150
     4.579    70.055     0.150
     4.579   123.031     0.150
     4.792    71.742     0.150
     4.792   125.398     0.150
     4.859   126.492     0.150
     4.871   125.336     0.150
     0.336     7.750     0.150
     0.336    12.172     0.150
     0.416     9.242     0.150
     0.416    14.953     0.150
     0.679    14.117     0.150
     0.679    23.930     0.150
     0.841    17.586     0.150
     0.841    29.312     0.150
     1.134    37.008     0.150
     1.134    23.164     0.150
     1.087    21.523     0.150
     1.087    36.344     0.150
     1.735    56.273     0.150
     1.990    35.305     0.150
     2.107    37.203     0.150
     2.436    41.859     0.150
     2.436    69.984     0.150
     2.438    42.422     0.150
     2.494    41.531     0.150
     2.494    72.633     0.150
     2.528    42.602     0.150
     2.528    42.945     0.150
     2.528    43.047     0.150
     2.528    77.141     0.150
     2.528    43.945     0.150
     2.521    42.859     0.150
     2.521    76.078     0.150
     2.609    44.609     0.150
     2.609    79.062     0.150
     2.694    46.320     0.150
     2.696    46.477     0.150
     2.696    81.078     0.150
     2.778    47.008     0.150
     2.778    83.023     0.150
     2.769    77.328     0.150
     2.769    47.266     0.150
     2.769    47.602     0.150
     2.769    48.891     0.150
     2.814    48.836     0.150
     2.814    87.359     0.150
     2.822    47.102     0.150
     2.822    83.102     0.150
     2.940    47.625     0.150
     2.940    86.586     0.150
     3.031    49.281     0.150
     3.031    88.180     0.150
     3.115    85.930     0.150
     3.132    87.453     0.150
     3.132    49.922     0.150
     3.229    50.797     0.150
     3.263    53.344     0.150
     3.473    55.969     0.150
     3.483    70.867     0.150
     3.828    61.977     0.150
     4.029    63.562     0.150
     4.029   110.352     0.150
     4.076    61.430     0.150
     4.076    61.586     0.150
     4.272   114.188     0.150
     4.272    66.008     0.150
     4.272    67.141     0.150
     4.444    67.719     0.150
     4.444   119.273     0.150
     4.444    67.438     0.150
     4.444   119.516     0.150
     4.467    68.953     0.150
     4.503    69.289     0.150
     4.503   120.414     0.150
     4.503    68.859     0.150
     4.503   118.094     0.150
     4.618    70.336     0.150
     4.618    70.203     0.150
     4.618   122.602     0.150
     4.633    71.883     0.150
     4.633    71.547     0.150
     4.633   122.516     0.150
     4.645    83.898     0.150
     4.651    90.898     0.150
     4.803    74.625     0.150
     4.803   130.266     0.150
     4.883    73.727     0.150
     4.883   128.398     0.150
     4.883   127.500     0.150
     5.120    81.898     0.150
     5.449    84.031     0.150
     5.449   146.547     0.150
     5.495    81.898     0.150
     5.495   142.297     0.150
     5.495    81.602     0.150
     5.495   141.000     0.150
     5.548    82.383     0.150
     5.548    82.211     0.150
     5.548   143.227     0.150
     5.549    82.797     0.150
     5.549   142.398     0.150
     5.549   142.586     0.150
     5.549    82.945     0.150
     5.579   142.234     0.150
     5.579    83.125     0.150
     5.579    83.242     0.150
     5.624    83.648     0.150
     5.624   146.383     0.150
     5.624    84.109     0.150
     5.624   144.883     0.150
     5.673    84.938     0.150
     5.673   147.055     0.150
     5.673    85.062     0.150
     5.673   145.359     0.150
     5.673    85.969     0.150
     5.813    86.695     0.150
     5.813   150.195     0.150
     5.813    86.859     0.150
     5.813    86.305     0.150
     5.813   149.086     0.150
     5.866    87.297     0.150
     5.866   153.602     0.150
     5.866    86.977     0.150
     5.866   149.938     0.150
     5.873    87.398     0.150
     5.873   151.695     0.150
     5.873    87.211     0.150
     5.873   149.852     0.150
     5.873    88.617     0.150
     5.873   154.523     0.150
     5.874    85.961     0.150
     5.874    87.016     0.150
     6.002    89.461     0.150
     6.002    89.719     0.150
     6.002    90.352     0.150
     6.028    89.297     0.150
     6.028   154.398     0.150
     6.028    88.945     0.150
     6.094    90.297     0.150
     6.094   157.695     0.150
     6.125    90.695     0.150
     6.125   158.102     0.150
     6.125    90.266     0.150
     6.125   155.891     0.150
     6.154    92.000     0.150
     6.154   157.297     0.150
     6.359    95.016     0.150
     6.359   163.539     0.150
     6.483    95.602     0.150
     6.483   165.898     0.150
     6.483    95.469     0.150
     6.483   165.195     0.150
     6.569    96.914     0.150
     6.569   166.297     0.150
     6.569    96.602     0.150
     6.569   167.648     0.150
     6.624   100.188     0.150
     6.624   173.016     0.150
     6.657    98.195     0.150
     6.657    98.055     0.150
     6.657    98.438     0.150
     6.829   100.500     0.150
     6.829   174.398     0.150
     6.829   100.852     0.150
     6.829   100.266     0.150
     6.829   172.695     0.150
     6.829   101.062     0.150
     7.052   103.188     0.150
     7.052   103.789     0.150
     7.052   178.555     0.150
     7.168   105.797     0.150
     7.194   104.969     0.150
     7.194   106.102     0.150
     7.194   183.227     0.150
     7.196   105.820     0.150
     7.213   105.695     0.150
     7.213   183.898     0.150
     7.299   107.000     0.150
     7.299   184.695     0.150
     7.510   110.695     0.150
     7.510   192.398     0.150
     7.510   190.438     0.150
     7.510   110.477     0.150
     7.665   111.695     0.150
     7.710   112.602     0.150
     7.710   194.398     0.150
     7.807   114.297     0.150
     7.807   198.602     0.150
     7.883   115.953     0.150
     7.883   116.242     0.150
     8.107   119.125     0.150
     8.193   209.102     0.150
     8.257   120.188     0.150
     8.257   120.586     0.150
     8.309   119.797     0.150
     8.563   125.602     0.150
     8.653   126.633     0.150
     9.599   238.453     0.150
     9.599   138.742     0.150
     9.599   138.445     0.150
     9.599   238.336     0.150
     9.773   141.445     0.150
     9.773   243.711     0.150
    10.417   151.898     0.150
    11.105   159.016     0.150
    11.981   172.945     0.150
    12.744   179.086     0.150
    12.744   181.078     0.150
    13.151   186.930     0.150
    13.151   188.000     0.150
    13.278   187.797     0.150
    15.293   222.438     0.150
    16.107   230.102     0.150
    17.037   243.109     0.150
    17.586   247.281     0.150
    17.586   248.539     0.150
    18.045   253.852     0.150
    18.061   252.570     0.150
    18.050   251.711     0.150
    18.127   252.680     0.150
    18.391   257.250     0.150
    18.424   256.305     0.150
    18.436   257.367     0.150
    18.637   259.680     0.150
    18.871   262.398     0.150
    18.940   264.070     0.150
    18.989   263.305     0.150
    19.009   263.125     0.150
    19.047   264.125     0.150
    19.100   264.719     0.150
    19.100   262.797     0.150
    19.105   265.328     0.150
    19.120   264.086     0.150
    19.246   265.688     0.150
    19.267   267.000     0.150
    19.268   265.469     0.150
    19.334   267.531     0.150
    19.358   266.570     0.150
    19.374   268.617     0.150
    19.570   271.445     0.150
    19.694   270.680     0.150
    19.694   272.320     0.150
    19.732   272.320     0.150
    19.853   272.797     0.150
    19.871   271.969     0.150
    19.983   274.445     0.150
    19.983   274.609     0.150
    20.033   274.680     0.150
    20.142   274.891     0.150
    20.081   274.695     0.150
    20.081   274.430     0.150
    20.081   274.781     0.150
    20.272   277.719     0.150
    20.272   277.906     0.150
    20.283   276.688     0.150
    20.534   279.367     0.150
    20.640   279.930     0.150
    20.796   282.281     0.150
    20.813   282.578     0.150
    20.836   283.508     0.150
    20.838   283.219     0.150
    20.838   283.508     0.150
    20.868   283.688     0.150
    20.958   283.086     0.150
    20.958   282.555     0.150
    21.252   287.617     0.150
    21.300   288.156     0.150
    21.342   287.617     0.150
    21.342   287.797     0.150
    21.342   286.930     0.150
    21.342   287.797     0.150
    21.480   289.258     0.150
    21.480   289.695     0.150
    21.620   291.797     0.150
    21.620   290.758     0.150
    21.732   292.305     0.150
    21.766   295.102     0.150
    21.766   292.711     0.150
    21.844   292.938     0.150
    21.908   294.289     0.150
    21.941   294.711     0.150
    21.984   295.000     0.150
    22.351   297.766     0.150
    22.486   299.836     0.150
    22.515   300.297     0.150
    22.528   301.602     0.150
    22.528   300.547     0.150
    22.591   302.398     0.150
    22.591   300.898     0.150
    22.671   302.695     0.150
    22.806   303.352     0.150
    22.824   303.000     0.150
    22.824   303.492     0.150
    22.867   305.273     0.150
    22.870   304.695     0.150
    22.884   305.555     0.150
    22.884   304.656     0.150
    23.080   305.695     0.150
    23.080   306.297     0.150
    23.080   306.055     0.150
    23.573   312.195     0.150
    23.573   312.555     0.150
    23.617   311.500     0.150
    23.647   312.500     0.150
    23.662   312.297     0.150
    23.702   312.898     0.150
    23.791   313.102     0.150
    23.791   313.617     0.150
    23.856   313.227     0.150
    23.856   314.398     0.150
    23.856   314.289     0.150
    25.482   329.297     0.150
    25.509   331.078     0.150
    25.682   331.727     0.150
    26.866   341.930     0.150
    30.184   371.320     0.150
    30.375   372.656     0.150
    30.780   375.594     0.150
    31.526   383.500     0.150
    33.484   400.727     0.150
    35.104   413.750     0.150
    35.104   565.672     0.150
    38.524   444.047     0.150
    38.937   447.508     0.150
    48.959   526.531     0.150
    50.055   535.922     0.150
    53.217   559.727     0.150
    58.449   596.391     0.150
    58.697   599.188     0.150
    58.808   599.688     0.150
    59.556   604.461     0.150
    59.585   604.539     0.150
    61.531   618.445     0.150
    61.558   617.961     0.150
    63.504   632.102     0.150
    64.124   635.547     0.150
    64.951   640.859     0.150
    65.157   641.781     0.150
    65.157   641.648     0.150
    65.157   642.750     0.150
    67.041   655.070     0.150
    70.190   674.898     0.150
    73.646   694.688     0.150
    75.564   707.305     0.150
    75.687   706.141     0.150
    76.099   709.859     0.150
    76.452   711.172     0.150
    77.100   715.797     0.150
    77.743   719.930     0.150
    78.130   721.672     0.150
    78.347   722.695     0.150
    78.428   722.109     0.150
    78.685   723.797     0.150
    78.978   725.656     0.150
    79.009   726.227     0.150
    81.733   741.523     0.150
    86.227   763.102     0.150
    88.597   774.500     0.150
    91.104   786.398     0.150
   151.421  1195.227     0.150
     0.453    10.877     0.150
     0.453    17.982     0.150
     0.823    16.027     0.150
     0.962    18.426     0.150
     1.102    19.992     0.150
     1.102    19.693     0.150
     1.102    33.088     0.150
     1.248    22.312     0.150
     1.248    37.682     0.150
     1.380    24.115     0.150
     1.380    40.568     0.150
     1.703    25.992     0.150
     2.163    34.658     0.150
     2.550    39.416     0.150
     2.550    69.969     0.150
     2.659    41.711     0.150
     2.659    71.594     0.150
     2.659    39.984     0.150
     2.659    70.221     0.150
     4.111    60.229     0.150
     4.111   103.430     0.150
     4.202    61.330     0.150
     4.202   105.229     0.150
     4.202    61.195     0.150
     4.272    63.285     0.150
     4.272   106.496     0.150
     4.336    63.430     0.150
     4.336   109.129     0.150
     4.415    64.529     0.150
     4.415   111.430     0.150
     4.415    64.318     0.150
     4.504    66.729     0.150
     4.504   112.830     0.150
     4.652    68.529     0.150
     4.652   116.830     0.150
     4.750    68.629     0.150
     4.750   118.330     0.150
     4.821    69.729     0.150
     4.821   119.830     0.150
     4.821   119.650     0.150
     5.094    73.229     0.150
     5.094   127.430     0.150
     5.391    77.932     0.150
     5.582    80.830     0.150
     5.582   139.330     0.150
     5.907    85.529     0.150
     6.101    88.029     0.150
     6.101   150.830     0.150
     0.401     9.117     0.150
     0.869    17.711     0.150
     0.735    15.375     0.150
     0.735    25.438     0.150
     1.157    23.023     0.150
     1.152    23.062     0.150
     1.152    39.156     0.150
     1.531    47.852     0.150
     1.531    27.445     0.150
     1.531    48.008     0.150
     1.424    26.484     0.150
     1.539    28.516     0.150
     1.669    54.844     0.150
     1.943    35.812     0.150
     1.943    60.773     0.150
     2.341    41.742     0.150
     2.341    74.242     0.150
     2.345    39.547     0.150
     2.401    43.305     0.150
     2.600    44.242     0.150
     2.600    78.398     0.150
     2.856    78.016     0.150
     3.197    52.266     0.150
     3.197    94.578     0.150
     3.297    53.891     0.150
     3.297    94.195     0.150
     3.672    56.109     0.150
     3.672    97.414     0.150
     3.672    55.867     0.150
     3.736    57.312     0.150
     3.736    99.414     0.150
     3.736    56.508     0.150
     3.736    98.297     0.150
     3.781    57.961     0.150
     3.781    99.555     0.150
     3.781    99.125     0.150
     3.729    57.680     0.150
     3.821    99.383     0.150
     3.984    61.414     0.150
     3.984   106.211     0.150
     3.879    62.055     0.150
     4.035    62.414     0.150
     4.035   106.812     0.150
     4.035    61.578     0.150
     4.054   107.914     0.150
     4.071    62.156     0.150
     4.071   106.766     0.150
     4.071   107.117     0.150
     4.118    64.344     0.150
     4.118   114.445     0.150
     4.282    65.008     0.150
     4.282   111.609     0.150
     4.282   111.156     0.150
     4.282    64.898     0.150
     4.265   111.430     0.150
     4.265    65.125     0.150
     4.265   110.953     0.150
     4.305   113.711     0.150
     4.305    65.133     0.150
     4.232    66.070     0.150
     4.660    70.609     0.150
     4.660   121.508     0.150
     4.660    69.977     0.150
     4.842   123.977     0.150
     4.842    73.344     0.150
     4.842   123.500     0.150
     4.861    72.812     0.150
     4.861   126.609     0.150
     4.861   125.906     0.150
     4.861    72.930     0.150
     5.064   130.914     0.150
     5.562    83.109     0.150
     5.562   143.414     0.150
     5.978    89.211     0.150
     5.978   153.414     0.150
     0.719    14.953     0.150
     0.698    15.031     0.150
     0.698    25.602     0.150
     0.957    19.492     0.150
     0.957    32.078     0.150
     1.110    22.445     0.150
     1.110    37.547     0.150
     1.114    22.266     0.150
     1.114    37.500     0.150
     1.142    23.234     0.150
     1.142    40.461     0.150
     1.327    24.641     0.150
     1.327    42.000     0.150
     1.413    27.836     0.150
     1.413    47.914     0.150
     1.654    28.930     0.150
     1.654    53.852     0.150
     1.676    29.719     0.150
     1.676    29.828     0.150
     1.676    53.492     0.150
     1.832    33.367     0.150
     1.832    57.578     0.150
     2.207    37.461     0.150
     2.207    68.852     0.150
     2.862    47.930     0.150
     2.862    83.133     0.150
     3.076    48.797     0.150
     3.076    83.109     0.150
     3.076    48.695     0.150
     3.076    83.688     0.150
     3.226    50.617     0.150
     3.226    87.516     0.150
     3.226    50.797     0.150
     3.300    52.523     0.150
     3.300    90.867     0.150
     3.695    59.242     0.150
     3.961    62.891     0.150
     4.378    68.156     0.150
     4.378    67.695     0.150
     4.378   115.820     0.150
     4.409    69.055     0.150
     4.409   116.805     0.150
     4.409    67.977     0.150
     4.409   117.312     0.150
     4.501    68.867     0.150
     4.501   118.055     0.150
     4.664    70.484     0.150
     4.664   122.180     0.150
     4.679    71.086     0.150
     4.679   120.984     0.150
     4.682    70.781     0.150
     4.682   120.680     0.150
     4.682    70.023     0.150
     4.997    75.484     0.150
     4.997   129.984     0.150
     5.022    75.281     0.150
     5.022   129.984     0.150
     5.133   132.680     0.150
     5.137    76.781     0.150
     5.137   133.281     0.150
     5.232    79.039     0.150
     5.273    78.984     0.150
     5.273   135.586     0.150
     5.273    78.312     0.150
     5.341    80.086     0.150
     5.341   138.086     0.150
     5.498    82.383     0.150
     5.498   141.055     0.150
     5.812    87.281     0.150
     6.230    92.484     0.150
     0.735    15.424     0.150
     0.735    25.488     0.150
     0.727    15.299     0.150
     0.727    25.459     0.150
     1.108    22.047     0.150
     1.108    36.654     0.150
     1.535    30.062     0.150
     1.535    48.500     0.150
     1.969    37.863     0.150
     1.969    59.100     0.150
     1.865    35.160     0.150
     1.865    61.500     0.150
     2.147    38.559     0.150
     2.152    38.348     0.150
     2.152    66.406     0.150
     2.233    39.730     0.150
     2.233    69.521     0.150
     2.552    42.387     0.150
     2.552    74.537     0.150
     2.495    42.783     0.150
     2.495    76.834     0.150
     3.067    48.889     0.150
     3.067    88.492     0.150
     3.184    51.762     0.150
     3.184    91.113     0.150
     3.480    56.496     0.150
     3.480    99.445     0.150
     3.482    57.527     0.150
     3.482   102.881     0.150
     3.654    57.830     0.150
     3.654   101.611     0.150
     4.731   129.162     0.150
     5.402    81.514     0.150
     5.402   140.715     0.150
     5.402    81.309     0.150
     5.459    82.262     0.150
     5.459   140.410     0.150
     5.512   144.854     0.150
     5.559    84.914     0.150
     5.559   146.113     0.150
     5.559    83.828     0.150
     5.637   146.113     0.150
     5.714    86.473     0.150
     5.714   147.918     0.150
     5.873    89.414     0.150
     5.873   152.113     0.150
     5.842    89.309     0.150
     5.958   154.414     0.150
     5.973    89.314     0.150
     5.973   154.715     0.150
     6.538   169.314     0.150
     6.533    96.689     0.150
     6.533   166.770     0.150
     6.753   173.514     0.150
     7.098   105.613     0.150
     7.098   182.014     0.150
     7.229   183.008     0.150
     7.254   107.814     0.150
     7.254   184.814     0.150
     7.670   113.113     0.150
     7.722   113.662     0.150
     7.722   194.951     0.150
     0.700    12.445     0.150
     0.700    22.422     0.150
     1.133    24.246     0.150
     1.133    39.297     0.150
     1.148    24.648     0.150
     1.148    43.043     0.150
     1.233    25.879     0.150
     1.282    26.441     0.150
     1.391    28.535     0.150
     1.391    47.055     0.150
     1.391    28.977     0.150
     1.391    47.852     0.150
     1.429    28.000     0.150
     1.429    47.832     0.150
     1.467    29.359     0.150
     1.467    50.324     0.150
     1.554    30.551     0.150
     1.726    32.957     0.150
     1.726    32.484     0.150
     1.726    53.941     0.150
     1.863    33.992     0.150
     1.863    57.594     0.150
     2.305    39.828     0.150
     2.305    69.332     0.150
     2.504    44.281     0.150
     2.670    45.188     0.150
     2.670    77.992     0.150
     3.586    57.496     0.150
     3.586   100.426     0.150
     4.482    69.445     0.150
     4.482    69.746     0.150
     4.482   118.102     0.150
     5.061    77.578     0.150
     5.061   133.078     0.150
     5.169    78.879     0.150
     5.169   135.477     0.150
     5.169    78.477     0.150
     5.169   134.414     0.150
     5.169    78.984     0.150
     5.220    79.777     0.150
     5.252    79.820     0.150
     5.252   136.852     0.150
     5.252    78.699     0.150
     5.252   135.566     0.150
     5.320    81.078     0.150
     5.320   140.176     0.150
     5.320    80.848     0.150
     5.320   137.809     0.150
     5.458    83.379     0.150
     5.458   143.277     0.150
     5.562    84.578     0.150
     5.562   146.578     0.150
     5.699    86.676     0.150
     5.699   148.977     0.150
     5.713    86.219     0.150
     5.713   147.359     0.150
     5.713   146.383     0.150
     5.823    88.176     0.150
     5.823   150.477     0.150
     5.823    87.727     0.150
     5.823   149.965     0.150
     5.916   152.203     0.150
     6.318    94.977     0.150
     6.396    95.547     0.150
     6.396   164.797     0.150
     6.573    98.977     0.150
     6.573   169.277     0.150
     6.878   102.277     0.150
     7.101   105.676     0.150
     7.101   182.379     0.150
     7.298   107.547     0.150
     7.298   185.715     0.150
     0.587    11.842     0.150
     0.587    21.359     0.150
     0.896    18.696     0.150
     0.896    31.623     0.150
     1.130    21.754     0.150
     1.130    39.254     0.150
     1.146    21.613     0.150
     1.146    38.886     0.150
     1.056    22.264     0.150
     1.056    37.432     0.150
     1.084    22.088     0.150
     1.084    39.006     0.150
     1.304    26.097     0.150
     1.304    43.501     0.150
     1.422    26.991     0.150
     1.422    47.688     0.150
     1.653    31.740     0.150
     1.653    53.395     0.150
     1.770    31.269     0.150
     1.770    31.490     0.150
     1.770    53.165     0.150
     1.738    32.505     0.150
     1.738    57.332     0.150
     1.868    34.937     0.150
     2.358    42.814     0.150
     2.358    72.349     0.150
     2.438    41.218     0.150
     2.438    71.139     0.150
     2.369    39.858     0.150
     2.369    71.680     0.150
     2.553    46.594     0.150
     2.553    79.250     0.150
     2.433    39.991     0.150
     2.433    71.556     0.150
     3.292    54.411     0.150
     3.212    52.787     0.150
     3.212    49.854     0.150
     3.212    88.809     0.150
     3.273    51.996     0.150
     3.273    90.951     0.150
     3.439    54.308     0.150
     3.439    96.659     0.150
     3.439    55.337     0.150
     3.559    96.333     0.150
     3.780    58.190     0.150
     3.780    99.890     0.150
     3.780    57.773     0.150
     3.780   100.124     0.150
     3.830    59.190     0.150
     3.830   101.490     0.150
     3.830   101.368     0.150
     3.861   101.964     0.150
     3.861    58.835     0.150
     3.861   100.897     0.150
     3.856   103.018     0.150
     3.898    62.143     0.150
     3.898   107.504     0.150
     4.040    62.808     0.150
     4.040   105.540     0.150
     4.040    62.523     0.150
     4.040   107.048     0.150
     4.129    64.190     0.150
     4.129   110.790     0.150
     4.129    64.489     0.150
     4.155   110.090     0.150
     4.168    64.790     0.150
     4.168   111.190     0.150
     4.282    66.883     0.150
     4.282   117.359     0.150
     4.196    64.175     0.150
     4.196   109.856     0.150
     4.196    63.615     0.150
     4.196   109.734     0.150
     4.328    66.790     0.150
     4.328   112.290     0.150
     4.328    66.690     0.150
     4.328   112.181     0.150
     4.392    67.990     0.150
     4.392   115.690     0.150
     4.407    67.090     0.150
     4.407   116.790     0.150
     4.435   116.790     0.150
     4.879    73.662     0.150
     4.879   125.406     0.150
     4.940    74.990     0.150
     4.940   127.990     0.150
     5.122    77.790     0.150
     5.122   134.090     0.150
     5.122    78.553     0.150
     5.496    82.890     0.150
     5.496   143.490     0.150
     5.605    84.390     0.150
     5.605   145.590     0.150
     5.582    82.730     0.150
     5.582   143.316     0.150
     6.045    90.033     0.150
     6.045   156.301     0.150
     6.571   168.590     0.150
     0.712    25.846     0.150
     0.712    14.915     0.150
     0.815    17.114     0.150
     0.815    17.783     0.150
     1.130    23.392     0.150
     1.130    23.803     0.150
     1.402    26.740     0.150
     1.537    28.259     0.150
     1.537    50.120     0.150
     1.517    29.765     0.150
     1.660    51.608     0.150
     1.942    57.077     0.150
     2.342    41.274     0.150
     2.342    74.422     0.150
     2.333    39.199     0.150
     2.333    71.108     0.150
     2.333    70.823     0.150
     2.676    75.031     0.150
     2.865    47.351     0.150
     2.865    85.835     0.150
     3.185    52.598     0.150
     3.200    93.363     0.150
     3.306    54.282     0.150
     3.306    93.036     0.150
     3.306    94.302     0.150
     3.693    56.715     0.150
     3.693    98.515     0.150
     3.757    58.615     0.150
     3.757   100.215     0.150
     3.801    59.605     0.150
     3.801   100.992     0.150
     4.057    63.715     0.150
     4.057   109.115     0.150
     4.057    63.515     0.150
     4.086    63.688     0.150
     4.086   107.641     0.150
     4.076   108.015     0.150
     3.862   109.738     0.150
     4.278    67.175     0.150
     4.278   113.694     0.150
     4.301    66.615     0.150
     4.301   113.715     0.150
     4.326   114.815     0.150
     4.326   113.605     0.150
     4.113   113.229     0.150
     4.212    65.285     0.150
     4.212   118.014     0.150
     4.861    73.651     0.150
     4.861   126.305     0.150
     5.084   133.415     0.150
     5.582   144.115     0.150
     0.845    16.945     0.150
     0.845    26.906     0.150
     0.859    19.129     0.150
     0.995    20.793     0.150
     0.995    36.318     0.150
     1.348    25.315     0.150
     1.348    43.021     0.150
     1.282    24.443     0.150
     1.282    43.555     0.150
     1.440    28.545     0.150
     1.440    47.396     0.150
     1.406    26.479     0.150
     1.406    46.544     0.150
     1.848    33.124     0.150
     1.848    57.362     0.150
     1.986    35.665     0.150
     1.986    59.122     0.150
     2.184    38.687     0.150
     2.184    66.000     0.150
     2.174    40.188     0.150
     2.174    68.938     0.150
     2.694    45.052     0.150
     2.694    80.576     0.150
     2.811    47.312     0.150
     2.811    80.730     0.150
     2.914    49.660     0.150
     2.914    86.680     0.150
     3.033    50.579     0.150
     3.033    86.708     0.150
     3.070    49.430     0.150
     3.070    86.553     0.150
     3.613    58.541     0.150
     3.613   102.498     0.150
     3.749    58.964     0.150
     3.749   103.628     0.150
     3.876    60.423     0.150
     3.847    61.464     0.150
     3.847   107.521     0.150
     3.952    61.853     0.150
     3.952    61.720     0.150
     4.215    64.573     0.150
     4.215   111.333     0.150
     4.448    68.193     0.150
     4.513    69.203     0.150
     4.513   117.373     0.150
     4.527    69.183     0.150
     4.527   118.433     0.150
     5.302   135.433     0.150
     5.808   147.893     0.150
     6.225   157.593     0.150
     0.331     9.117     0.150
     0.331    14.523     0.150
     1.052    20.109     0.150
     1.052    33.328     0.150
     1.375    24.812     0.150
     1.375    43.133     0.150
     1.511    24.258     0.150
     1.511    42.680     0.150
     1.507    26.508     0.150
     1.507    46.234     0.150
     2.421    38.703     0.150
     2.421    68.617     0.150
     2.430    36.539     0.150
     2.430    64.758     0.150
     2.527    38.758     0.150
     2.527    69.094     0.150
     3.221    46.906     0.150
     3.221    83.977     0.150
     3.327    50.180     0.150
     3.327    88.703     0.150
     4.207    61.781     0.150
     4.207   105.680     0.150
     4.311    63.305     0.150
     4.311   108.500     0.150
     4.311    62.891     0.150
     4.253    62.977     0.150
     4.253   108.938     0.150
     4.392    64.492     0.150
     4.392    64.781     0.150
     4.392   109.508     0.150
     4.392   109.359     0.150
     4.532   112.727     0.150
     4.603    67.781     0.150
     4.603   115.164     0.150
     4.723    69.531     0.150
     4.723   118.484     0.150
     4.845    70.555     0.150
     4.845   119.148     0.150
     4.845    71.258     0.150
     4.845   120.898     0.150
     4.889   122.242     0.150
     4.964    72.992     0.150
     4.964   123.320     0.150
     4.964    72.359     0.150
     4.964   122.375     0.150
     5.127   127.672     0.150
     5.152   129.195     0.150
     5.459    80.031     0.150
     5.459   135.469     0.150
     5.537    80.117     0.150
     5.537   136.398     0.150
     5.537    79.461     0.150
     5.537   137.891     0.150
     5.954    86.289     0.150
     5.954   146.641     0.150
     6.020    87.352     0.150
     6.240    89.859     0.150
     6.240   154.180     0.150
     6.500   160.477     0.150
     6.706   164.562     0.150
     0.321     8.566     0.150
     0.321    13.984     0.150
     0.984    32.883     0.150
     0.984    19.574     0.150
     1.241    23.441     0.150
     1.241    39.348     0.150
     1.360    24.734     0.150
     1.360    41.406     0.150
     1.492    26.762     0.150
     2.329    38.395     0.150
     4.128   105.238     0.150
     4.228    62.469     0.150
     4.228    61.426     0.150
     4.228   106.320     0.150
     4.305   109.199     0.150
     4.305    63.137     0.150
     4.305    63.434     0.150
     4.305   107.480     0.150
     4.326    63.449     0.150
     4.326   109.008     0.150
     4.326    62.352     0.150
     4.326   108.805     0.150
     4.437   111.051     0.150
     4.412    64.727     0.150
     4.412   110.727     0.150
     4.412   111.578     0.150
     4.523    66.586     0.150
     4.523   114.277     0.150
     4.652    68.469     0.150
     4.652   118.816     0.150
     4.766    69.727     0.150
     4.766   119.379     0.150
     4.766    70.469     0.150
     4.766   120.117     0.150
     4.784    71.000     0.150
     4.784   119.531     0.150
     4.871    72.129     0.150
     4.871   122.246     0.150
     4.871    71.352     0.150
     5.019    74.266     0.150
     5.019   126.965     0.150
     5.019    74.664     0.150
     5.019   126.223     0.150
     5.444    79.195     0.150
     5.444   135.605     0.150
     5.444    79.359     0.150
     5.444   136.039     0.150
     5.624   141.227     0.150
     5.624   140.648     0.150
     5.845    85.930     0.150
     5.845   146.008     0.150
     5.936    86.520     0.150
     5.936   149.168     0.150
     6.149    89.086     0.150
     6.149   153.426     0.150
     6.393   158.352     0.150
     6.566   164.738     0.150
     0.892    17.039     0.150
     1.046    20.539     0.150
     1.046    33.883     0.150
     1.306    24.312     0.150
     1.306    40.211     0.150
     1.400    26.070     0.150
     1.400    42.969     0.150
     1.532    27.805     0.150
     1.532    46.172     0.150
     1.995    35.312     0.150
     1.974    33.938     0.150
     1.974    59.609     0.150
     2.401    41.031     0.150
     2.482    39.062     0.150
     2.482    66.453     0.150
     2.482    39.320     0.150
     2.585    41.898     0.150
     2.585    72.688     0.150
     2.770    44.359     0.150
     2.770    77.352     0.150
     3.264    47.000     0.150
     3.264    88.188     0.150
     3.223    49.305     0.150
     3.223    86.344     0.150
     3.602    55.930     0.150
     3.602    97.672     0.150
     4.150    61.883     0.150
     4.150   106.516     0.150
     4.253    63.578     0.150
     4.253   108.328     0.150
     4.253   107.062     0.150
     4.253    62.992     0.150
     4.209    62.789     0.150
     4.209   108.680     0.150
     4.336    64.594     0.150
     4.336   110.641     0.150
     4.336    64.203     0.150
     4.336   109.445     0.150
     4.334    64.203     0.150
     4.334   109.898     0.150
     4.426    65.734     0.150
     4.426    66.031     0.150
     4.426   112.523     0.150
     4.545    67.625     0.150
     4.545   115.391     0.150
     4.545    67.039     0.150
     4.545   115.555     0.150
     4.667    69.641     0.150
     4.667   118.391     0.150
     4.788    70.680     0.150
     4.788   119.945     0.150
     4.788    71.031     0.150
     4.788   121.445     0.150
     4.833    72.289     0.150
     4.833   122.633     0.150
     4.884    72.062     0.150
     4.884   123.883     0.150
     4.905    72.844     0.150
     4.905   123.148     0.150
     4.905    72.094     0.150
     4.905   122.023     0.150
     5.074    75.125     0.150
     5.074   127.688     0.150
     5.401    79.289     0.150
     5.401   136.383     0.150
     5.479    79.977     0.150
     5.479   136.180     0.150
     5.962    86.922     0.150
     5.962   149.250     0.150
     6.182    90.141     0.150
     6.182   154.523     0.150
     6.599    96.148     0.150
     6.599   165.453     0.150
     0.477    10.441     0.150
     0.477    17.633     0.150
     0.595    12.387     0.150
     0.595    21.426     0.150
     0.735    15.418     0.150
     0.735    25.398     0.150
     0.966    19.613     0.150
     0.966    31.977     0.150
     1.135    23.141     0.150
     1.135    38.945     0.150
     1.284    26.219     0.150
     1.651    30.547     0.150
     1.651    51.918     0.150
     1.828    32.910     0.150
     1.828    55.781     0.150
     1.828    33.336     0.150
     1.828    58.914     0.150
     2.096    38.629     0.150
     2.018    35.191     0.150
     2.018    60.488     0.150
     2.303    41.832     0.150
     2.303    72.973     0.150
     2.200    40.047     0.150
     2.200    70.543     0.150
     2.247    40.473     0.150
     2.247    70.930     0.150
     2.492    42.188     0.150
     2.492    73.461     0.150
     2.492    41.805     0.150
     2.492    73.340     0.150
     2.762    46.266     0.150
     2.762    80.789     0.150
     2.683    44.363     0.150
     2.683    77.539     0.150
     2.683    43.840     0.150
     3.146    52.016     0.150
     3.494    56.688     0.150
     3.481    54.941     0.150
     3.792    60.102     0.150
     4.925    74.336     0.150
     4.925   128.074     0.150
     4.997    75.453     0.150
     5.046    76.266     0.150
     5.046    75.941     0.150
     5.046   129.707     0.150
     5.080    76.375     0.150
     5.080   132.195     0.150
     5.195   135.914     0.150
     5.266    79.391     0.150
     5.266   134.664     0.150
     5.266    78.789     0.150
     5.266   135.621     0.150
     5.311    80.266     0.150
     5.311   137.473     0.150
     5.391    80.918     0.150
     5.391   140.723     0.150
     5.496    83.484     0.150
     5.496   143.754     0.150
     5.545    83.363     0.150
     5.545   142.094     0.150
     5.561    83.645     0.150
     5.561   143.863     0.150
     6.102    90.750     0.150
     6.102    90.504     0.150
     6.102   155.988     0.150
     6.330    94.055     0.150
     6.330   163.062     0.150
     6.686    98.953     0.150
     6.686   171.473     0.150
     6.825   101.023     0.150
     6.825   175.125     0.150
     7.240   106.734     0.150
     7.240   183.574     0.150
     0.312    11.613     0.150
     0.915    19.156     0.150
     0.915    18.812     0.150
     1.377    26.750     0.150
     1.377    44.871     0.150
     1.557    29.916     0.150
     1.557    50.941     0.150
     1.509    28.812     0.150
     1.509    48.523     0.150
     1.988    34.252     0.150
     1.988    58.924     0.150
     1.958    35.408     0.150
     1.958    60.291     0.150
     2.380    40.652     0.150
     2.380    68.967     0.150
     2.511    40.945     0.150
     2.511    70.854     0.150
     2.401    40.484     0.150
     2.401    70.736     0.150
     2.486    41.004     0.150
     2.486    68.498     0.150
     2.486    40.639     0.150
     2.486    68.793     0.150
     2.576    42.523     0.150
     2.576    73.211     0.150
     2.755    46.115     0.150
     2.755    79.342     0.150
     3.207    49.523     0.150
     3.216    51.254     0.150
     3.216    88.266     0.150
     3.295    53.186     0.150
     3.295    89.371     0.150
     3.274    49.201     0.150
     3.274    88.514     0.150
     3.362    53.793     0.150
     3.362    93.486     0.150
     4.160    63.996     0.150
     4.160   107.896     0.150
     4.199    64.461     0.150
     4.199   109.889     0.150
     4.199    65.537     0.150
     4.199   110.279     0.150
     4.262    65.188     0.150
     4.262    65.086     0.150
     4.341    66.428     0.150
     4.341   111.871     0.150
     4.341    67.074     0.150
     4.341   112.574     0.150
     4.350    66.506     0.150
     4.350   111.916     0.150
     4.439    67.666     0.150
     4.439    67.947     0.150
     4.439   114.477     0.150
     4.479    68.160     0.150
     4.479   117.133     0.150
     4.555    69.697     0.150
     4.555   117.236     0.150
     4.555    69.467     0.150
     4.555   117.098     0.150
     4.679    71.486     0.150
     4.679   121.176     0.150
     4.798    72.756     0.150
     4.798    72.867     0.150
     4.798   123.457     0.150
     4.833    74.018     0.150
     4.833   122.871     0.150
     4.833   124.535     0.150
     4.892    74.016     0.150
     4.892   125.287     0.150
     4.911    74.727     0.150
     4.911   125.207     0.150
     5.071    77.176     0.150
     5.071   129.699     0.150
     5.071   130.209     0.150
     5.096    77.771     0.150
     5.096   134.004     0.150
     5.225    80.859     0.150
     5.225   136.104     0.150
     5.410    81.557     0.150
     5.410   137.766     0.150
     5.485    82.105     0.150
     5.485   139.400     0.150
     5.485   139.152     0.150
     5.898    88.875     0.150
     5.898   151.158     0.150
     5.971    89.076     0.150
     5.971   152.256     0.150
     6.142    92.127     0.150
     6.142    91.889     0.150
     6.188    92.156     0.150
     6.188   156.277     0.150
     6.444    95.354     0.150
     6.444   162.477     0.150
     6.605    97.996     0.150
     6.605   166.227     0.150
     6.974   175.576     0.150
     7.165   105.877     0.150
     7.165   178.797     0.150
     7.543   188.344     0.150
     7.882   115.846     0.150
     7.882   196.846     0.150
     8.156   119.047     0.150
     8.156   203.537     0.150
     8.253   120.461     0.150
     8.253   207.262     0.150
     0.294     8.992     0.150
     0.294    15.047     0.150
     0.874    16.625     0.150
     1.334    22.477     0.150
     1.334    39.070     0.150
     1.409    24.961     0.150
     1.409    42.305     0.150
     1.506    25.469     0.150
     1.540    26.547     0.150
     1.534    23.664     0.150
     1.534    42.023     0.150
     2.032    33.109     0.150
     1.960    31.531     0.150
     1.960    56.430     0.150
     2.431    37.953     0.150
     2.366    36.820     0.150
     2.366    65.484     0.150
     2.552    39.758     0.150
     2.552    70.719     0.150
     2.445    38.492     0.150
     2.445    65.883     0.150
     2.445    36.789     0.150
     2.445    64.266     0.150
     2.759    43.641     0.150
     2.759    73.125     0.150
     2.806    43.711     0.150
     2.806    77.820     0.150
     3.270    49.594     0.150
     3.270    86.695     0.150
     3.226    46.148     0.150
     3.195    47.758     0.150
     3.195    83.414     0.150
     3.344    87.867     0.150
     3.413    51.758     0.150
     3.413    93.086     0.150
     3.626    54.734     0.150
     3.626    92.047     0.150
     3.626    52.867     0.150
     3.626    94.578     0.150
     3.633    54.953     0.150
     3.633    98.094     0.150
     3.724    55.391     0.150
     3.841    98.250     0.150
     4.175    61.070     0.150
     4.175   104.781     0.150
     4.279    62.648     0.150
     4.246    61.906     0.150
     4.246   107.211     0.150
     4.246    62.031     0.150
     4.246   107.852     0.150
     4.265    63.719     0.150
     4.265   108.445     0.150
     4.265    63.930     0.150
     4.265   111.797     0.150
     4.357    63.945     0.150
     4.357   109.445     0.150
     4.357    63.555     0.150
     4.357   110.102     0.150
     4.361    63.836     0.150
     4.361   109.195     0.150
     4.361    64.219     0.150
     4.361   109.766     0.150
     4.448    65.031     0.150
     4.448   111.023     0.150
     4.448    65.234     0.150
     4.448   111.953     0.150
     4.505    65.680     0.150
     4.505   111.906     0.150
     4.505   112.219     0.150
     4.571    67.000     0.150
     4.571   114.680     0.150
     4.571    66.891     0.150
     4.571   114.484     0.150
     4.611    67.875     0.150
     4.611   117.070     0.150
     4.618    67.844     0.150
     4.618    67.062     0.150
     4.618   117.555     0.150
     4.689    68.875     0.150
     4.689   118.734     0.150
     4.813    69.922     0.150
     4.813   119.430     0.150
     4.813    70.250     0.150
     4.813   120.234     0.150
     4.868    71.055     0.150
     4.868   121.344     0.150
     4.868    71.578     0.150
     4.868   121.000     0.150
     4.868    71.336     0.150
     4.910    71.320     0.150
     4.910   122.898     0.150
     4.936    71.852     0.150
     4.936   122.031     0.150
     4.936   122.367     0.150
     5.110    74.664     0.150
     5.110   126.406     0.150
     5.110    74.555     0.150
     5.110   127.039     0.150
     5.141    74.672     0.150
     5.141   131.242     0.150
     5.272    78.039     0.150
     5.272   134.188     0.150
     5.428    78.953     0.150
     5.428   135.211     0.150
     5.510    79.555     0.150
     5.510   137.211     0.150
     5.510   136.531     0.150
     5.683    82.352     0.150
     5.683   141.625     0.150
     5.683   141.398     0.150
     5.940    86.195     0.150
     5.940   147.305     0.150
     5.989    86.109     0.150
     5.989   149.562     0.150
     6.153    88.992     0.150
     6.153    88.742     0.150
     6.153   153.195     0.150
     6.212    89.602     0.150
     6.212   153.148     0.150
     6.483    92.727     0.150
     6.483   160.727     0.150
     6.541    94.578     0.150
     6.629    95.516     0.150
     6.629   162.953     0.150
     6.690    95.867     0.150
     6.690   164.727     0.150
     6.691   164.531     0.150
     6.796    97.562     0.150
     6.796   168.109     0.150
     6.993   173.664     0.150
     7.542   185.852     0.150
     7.580   108.250     0.150
     7.580   185.578     0.150
     7.909   112.703     0.150
     7.909   195.250     0.150
     8.074   199.484     0.150
     8.179   116.141     0.150
     8.179   200.562     0.150
     8.296   117.898     0.150
     8.296   204.391     0.150
     8.821   216.719     0.150
     0.269     7.248     0.150
     0.529    11.329     0.150
     0.529    18.859     0.150
     0.914    28.752     0.150
     0.934    18.300     0.150
     0.934    31.290     0.150
     1.060    19.870     0.150
     1.112    21.211     0.150
     1.112    36.696     0.150
     1.283    24.603     0.150
     1.283    41.835     0.150
     1.319    25.281     0.150
     1.436    26.977     0.150
     1.828    30.162     0.150
     1.828    53.048     0.150
     1.833    32.619     0.150
     1.833    56.420     0.150
     1.918    32.604     0.150
     1.918    58.606     0.150
     2.099    35.136     0.150
     2.099    61.604     0.150
     2.227    39.963     0.150
     2.227    69.072     0.150
     2.337    40.210     0.150
     2.337    71.204     0.150
     2.524    74.839     0.150
     3.064    82.844     0.150
     3.038    53.154     0.150
     3.038    93.877     0.150
     3.217    52.629     0.150
     3.472    58.014     0.150
     3.472   102.870     0.150
     3.687    58.903     0.150
     3.799    60.156     0.150
     3.875   108.510     0.150
     4.177    63.889     0.150
     4.177   107.507     0.150
     4.231   110.457     0.150
     4.219   108.884     0.150
     4.243    63.776     0.150
     4.243   108.846     0.150
     4.241    63.113     0.150
     4.241   108.823     0.150
     4.577    68.563     0.150
     4.636    69.523     0.150
     4.636   117.863     0.150
     4.618    71.336     0.150
     4.632    69.634     0.150
     4.632   120.084     0.150
     4.650    69.134     0.150
     4.650   120.613     0.150
     4.829    72.104     0.150
     4.829   124.974     0.150
     4.863    72.573     0.150
     4.863   124.714     0.150
     4.942    74.870     0.150
     4.942   128.083     0.150
     5.161    76.383     0.150
     5.161   131.051     0.150
     5.310    78.523     0.150
     5.446    80.924     0.150
     5.446   138.244     0.150
     5.856    85.964     0.150
     5.894    86.113     0.150
     5.894   150.104     0.150
     6.299    92.174     0.150
     0.222     5.977     0.150
     0.745    14.719     0.150
     0.745    24.516     0.150
     0.790    15.953     0.150
     0.790    25.578     0.150
     1.323    25.719     0.150
     1.323    44.570     0.150
     1.263    25.258     0.150
     1.389    26.586     0.150
     1.389    46.266     0.150
     1.462    26.297     0.150
     1.462    47.070     0.150
     1.532    27.617     0.150
     1.522    47.312     0.150
     1.663    29.656     0.150
     2.033    36.656     0.150
     2.033    64.242     0.150
     2.338    39.727     0.150
     2.338    69.914     0.150
     2.395    38.383     0.150
     2.395    72.211     0.150
     2.395    39.320     0.150
     2.395    68.008     0.150
     2.549    41.531     0.150
     2.909    46.875     0.150
     2.909    83.211     0.150
     3.145    47.914     0.150
     3.145    85.125     0.150
     3.212    50.953     0.150
     3.212    89.375     0.150
     3.656    56.969     0.150
     3.656    96.188     0.150
     3.756    59.984     0.150
     3.756   104.711     0.150
     4.151    62.844     0.150
     4.151   108.672     0.150
     4.261    63.906     0.150
     4.261    64.133     0.150
     4.261   110.891     0.150
     4.311   112.922     0.150
     4.350    65.414     0.150
     4.350   113.508     0.150
     4.350   112.086     0.150
     4.326    65.180     0.150
     4.326   111.703     0.150
     4.334   114.453     0.150
     4.408   114.570     0.150
     4.513    68.031     0.150
     4.513   115.719     0.150
     4.547    68.781     0.150
     4.547   117.812     0.150
     4.650    69.758     0.150
     4.650   120.281     0.150
     4.787    72.023     0.150
     4.787   124.305     0.150
     4.903    73.289     0.150
     4.903   125.445     0.150
     4.903    73.164     0.150
     4.903   123.305     0.150
     4.936    73.914     0.150
     4.936   126.203     0.150
     4.936    73.703     0.150
     4.936   127.500     0.150
     5.161    77.203     0.150
     5.161   131.930     0.150
     5.161    77.039     0.150
     5.161   131.336     0.150
     5.349    80.914     0.150
     5.411    80.633     0.150
     5.512    81.172     0.150
     5.512   140.742     0.150
     5.512    81.531     0.150
     5.512   138.477     0.150
     5.675    85.359     0.150
     5.675   144.828     0.150
     5.919    84.109     0.150
     5.919   145.250     0.150
     5.971    88.078     0.150
     5.971   152.242     0.150
     5.998    88.359     0.150
     5.998   151.031     0.150
     6.209    90.914     0.150
     6.209   156.961     0.150
     6.477    95.289     0.150
     6.477   163.914     0.150
     6.528    95.000     0.150
     6.528   163.305     0.150
     6.740   167.484     0.150
     6.741   168.039     0.150
     6.815    99.953     0.150
     6.815   170.164     0.150
     0.650    14.027     0.150
     0.650    23.715     0.150
     0.647    13.734     0.150
     0.647    22.746     0.150
     0.892    17.469     0.150
     0.892    30.812     0.150
     0.994    20.258     0.150
     0.994    34.863     0.150
     1.304    24.402     0.150
     1.304    40.355     0.150
     1.283    24.789     0.150
     1.283    42.195     0.150
     1.409    27.133     0.150
     1.409    45.734     0.150
     1.895    33.781     0.150
     1.895    60.082     0.150
     2.018    33.844     0.150
     2.018    61.129     0.150
     2.863    46.852     0.150
     2.863    80.574     0.150
     3.896   100.562     0.150
     4.032    62.152     0.150
     4.032   104.637     0.150
     4.105   106.613     0.150
     4.165   109.445     0.150
     4.230    64.453     0.150
     4.230   112.184     0.150
     4.285    66.035     0.150
     4.285   112.773     0.150
     4.387    66.227     0.150
     4.387   113.117     0.150
     4.557    68.715     0.150
     4.557   118.414     0.150
     4.592    69.078     0.150
     4.592   117.398     0.150
     5.404    80.574     0.150
     5.404   137.117     0.150
     5.692    81.004     0.150
     5.839    87.363     0.150
     0.549    11.664     0.150
     0.549    20.148     0.150
     0.549    11.844     0.150
     0.549    12.672     0.150
     0.687    14.039     0.150
     0.687    24.711     0.150
     0.795    15.883     0.150
     0.795    15.992     0.150
     0.795    28.695     0.150
     1.156    23.664     0.150
     1.095    22.453     0.150
     1.095    21.945     0.150
     1.095    22.094     0.150
     1.197    23.820     0.150
     1.197    38.484     0.150
     1.221    22.391     0.150
     1.221    39.469     0.150
     1.221    22.812     0.150
     1.706    33.117     0.150
     1.706    53.359     0.150
     1.677    31.055     0.150
     1.677    54.570     0.150
     1.677    30.836     0.150
     1.889    33.727     0.150
     1.889    58.648     0.150
     1.889    34.492     0.150
     1.889    34.344     0.150
     1.999    34.836     0.150
     1.999    64.281     0.150
     1.999    34.664     0.150
     2.302    39.992     0.150
     2.302    70.688     0.150
     2.302    40.664     0.150
     2.302    41.664     0.150
     2.047    36.336     0.150
     2.047    65.742     0.150
     2.047    36.102     0.150
     2.047    37.664     0.150
     2.279    38.625     0.150
     2.279    67.820     0.150
     2.461    40.852     0.150
     2.461    71.562     0.150
     2.461    41.234     0.150
     2.554    43.297     0.150
     2.554    75.500     0.150
     2.554    43.156     0.150
     2.861    47.273     0.150
     2.985    48.266     0.150
     2.985    83.359     0.150
     2.985    49.680     0.150
     2.985    50.664     0.150
     2.998    48.727     0.150
     2.998    85.711     0.150
     3.213    51.734     0.150
     3.213    86.078     0.150
     3.303    53.234     0.150
     3.366    54.016     0.150
     3.260    51.602     0.150
     3.260    91.453     0.150
     3.260    52.664     0.150
     3.260    60.781     0.150
     3.663    58.602     0.150
     3.663   103.305     0.150
     3.663    59.664     0.150
     4.466    68.062     0.150
     4.574    71.188     0.150
     4.574   121.766     0.150
     4.956    74.773     0.150
     4.956   127.422     0.150
     5.039    75.836     0.150
     5.039   129.977     0.150
     5.039    76.227     0.150
     5.097    76.805     0.150
     5.159    77.117     0.150
     5.159   133.633     0.150
     5.197    78.352     0.150
     5.197   134.836     0.150
     5.197    79.148     0.150
     5.273    79.203     0.150
     5.273   134.398     0.150
     5.273    79.367     0.150
     5.273   135.719     0.150
     5.384    81.180     0.150
     5.384   137.688     0.150
     5.346    80.469     0.150
     5.346   137.969     0.150
     5.497    84.922     0.150
     5.532    83.055     0.150
     5.532   143.305     0.150
     5.509    82.812     0.150
     5.509   141.695     0.150
     5.594    83.453     0.150
     5.594    83.648     0.150
     5.594   143.492     0.150
     5.617    83.875     0.150
     5.617   143.805     0.150
     5.662    84.828     0.150
     6.179    91.484     0.150
     6.179   157.672     0.150
     6.175    92.172     0.150
     6.297    93.664     0.150
     6.297   161.102     0.150
     6.394    94.898     0.150
     6.394   163.039     0.150
     6.394    94.688     0.150
     6.781   102.719     0.150
     6.497    96.344     0.150
     6.497   170.766     0.150
     6.736    99.227     0.150
     6.736   171.953     0.150
     6.749    95.664     0.150
     6.919   101.164     0.150
     6.919   174.219     0.150
     6.898   101.844     0.150
     6.898   174.562     0.150
     6.959   102.977     0.150
     6.959   177.023     0.150
     7.096   103.867     0.150
     7.096   179.234     0.150
     7.223   106.586     0.150
     7.223   182.562     0.150
     7.314   107.688     0.150
     7.314   184.062     0.150
     7.309   107.789     0.150
     7.382   107.719     0.150
     7.870   115.352     0.150
     7.870   198.352     0.150
     8.239   120.914     0.150
     8.239   206.195     0.150
     8.551   124.703     0.150
     8.551   215.078     0.150
     8.591   124.266     0.150
     8.591   214.492     0.150
     8.862   129.062     0.150
     8.862   221.938     0.150
     9.158   132.672     0.150
     9.228   133.242     0.150
     9.293   135.500     0.150
     9.293   231.227     0.150
    20.540   280.242     0.150
    21.657   291.391     0.150
    25.887   334.039     0.150
    65.648   646.320     0.150
    77.692   717.633     0.150
     0.552    11.930     0.150
     0.552    20.930     0.150
     0.552    12.383     0.150
     0.698    14.484     0.150
     0.698    24.820     0.150
     0.808    27.508     0.150
     0.808    16.258     0.150
     1.175    24.383     0.150
     1.175    39.375     0.150
     1.175    25.062     0.150
     1.151    22.219     0.150
     1.151    24.055     0.150
     1.116    23.125     0.150
     1.116    39.805     0.150
     1.116    22.633     0.150
     1.224    22.938     0.150
     1.224    39.656     0.150
     1.224    23.055     0.150
     1.224    24.055     0.150
     1.684    31.531     0.150
     1.699    31.539     0.150
     1.699    54.688     0.150
     1.699    32.055     0.150
     1.699    33.141     0.150
     1.984    36.812     0.150
     1.984    64.781     0.150
     1.984    37.062     0.150
     1.984    65.070     0.150
     1.984    35.203     0.150
     1.905    34.680     0.150
     1.905    59.352     0.150
     1.905    35.055     0.150
     1.905    37.125     0.150
     2.053    37.477     0.150
     2.053    66.648     0.150
     2.053    37.055     0.150
     2.053    67.055     0.150
     2.281    39.305     0.150
     2.281    68.234     0.150
     2.299    40.188     0.150
     2.299    71.602     0.150
     2.299    41.172     0.150
     2.299    43.055     0.150
     2.457    41.570     0.150
     2.457    72.500     0.150
     2.457    42.055     0.150
     2.569    43.695     0.150
     2.569    76.023     0.150
     2.569    44.055     0.150
     2.569    45.055     0.150
     2.854    47.914     0.150
     2.854    84.500     0.150
     2.983    49.602     0.150
     2.989    48.633     0.150
     2.989    84.984     0.150
     2.989    51.055     0.150
     3.258    52.359     0.150
     3.258    92.398     0.150
     3.258    61.055     0.150
     3.301    54.109     0.150
     3.301    95.734     0.150
     3.368    54.609     0.150
     3.368    97.117     0.150
     3.680    59.445     0.150
     3.680   104.594     0.150
     3.680    60.062     0.150
     4.170    64.859     0.150
     4.170   112.312     0.150
     4.435    66.672     0.150
     4.435   120.109     0.150
     4.456    68.828     0.150
     4.456   119.383     0.150
     4.563    70.156     0.150
     4.563   122.305     0.150
     4.936    75.328     0.150
     4.936   129.086     0.150
     5.018    76.492     0.150
     5.018   130.547     0.150
     5.018    77.133     0.150
     5.077    77.438     0.150
     5.077   131.266     0.150
     5.141    78.102     0.150
     5.141   135.047     0.150
     5.175   135.562     0.150
     5.251    79.703     0.150
     5.251   136.328     0.150
     5.251    79.938     0.150
     5.251   136.539     0.150
     5.326    81.148     0.150
     5.326   138.914     0.150
     5.369    81.273     0.150
     5.369   138.828     0.150
     5.405    82.242     0.150
     5.405   143.273     0.150
     5.488    83.508     0.150
     5.488   142.578     0.150
     5.488    84.359     0.150
     5.488   147.062     0.150
     5.518    83.312     0.150
     5.518   142.641     0.150
     5.573    84.023     0.150
     5.573   143.609     0.150
     5.573    84.242     0.150
     5.573   144.055     0.150
     5.598    84.383     0.150
     5.598   144.234     0.150
     5.642    85.734     0.150
     5.642   146.273     0.150
     6.156   157.859     0.150
     6.161    92.297     0.150
     6.161   158.031     0.150
     6.285    94.438     0.150
     6.285   162.141     0.150
     6.375    95.742     0.150
     6.375   163.766     0.150
     6.375    96.070     0.150
     6.495    96.203     0.150
     6.716    99.953     0.150
     6.716   172.336     0.150
     6.775   102.414     0.150
     6.880   102.453     0.150
     6.880   175.453     0.150
     6.906   101.891     0.150
     6.906   174.867     0.150
     6.938   103.469     0.150
     6.938   178.328     0.150
     7.083   180.898     0.150
     7.083   104.953     0.150
     7.083   179.742     0.150
     7.084   181.039     0.150
     7.203   107.133     0.150
     7.203   183.336     0.150
     7.289   108.195     0.150
     7.289   187.359     0.150
     7.295   108.156     0.150
     7.295   185.008     0.150
     7.365   108.602     0.150
     7.365   186.391     0.150
     7.852   115.734     0.150
     7.852   197.812     0.150
     8.012   201.375     0.150
     8.263   208.281     0.150
     8.379   121.906     0.150
     8.379   211.664     0.150
     8.533   125.438     0.150
     8.533   217.359     0.150
     8.581   124.602     0.150
     8.581   218.562     0.150
     8.735   127.938     0.150
     8.843   129.625     0.150
     8.843   223.297     0.150
     9.141   133.648     0.150
     9.276   233.547     0.150
     9.368   135.875     0.150
     9.368   234.586     0.150
    20.560   280.250     0.150
    21.654   291.672     0.150
     0.661    23.543     0.150
     0.661    13.471     0.150
     0.857    16.162     0.150
     0.857    28.379     0.150
     0.857    16.383     0.150
     0.861    17.119     0.150
     0.861    28.465     0.150
     1.184    22.627     0.150
     1.184    38.455     0.150
     1.331    43.602     0.150
     1.331    25.082     0.150
     1.255    23.986     0.150
     1.255    40.605     0.150
     1.380    25.896     0.150
     1.380    43.889     0.150
     1.871    31.889     0.150
     2.078    37.451     0.150
     2.078    65.461     0.150
     2.018    33.047     0.150
     2.018    57.920     0.150
     2.242    62.316     0.150
     2.218    36.562     0.150
     2.218    65.070     0.150
     2.133    36.482     0.150
     2.133    63.793     0.150
     2.657    41.992     0.150
     2.657    74.826     0.150
     2.838    45.467     0.150
     2.838    79.863     0.150
     2.870    46.314     0.150
     2.910    45.666     0.150
     2.910    80.721     0.150
     2.986    46.432     0.150
     2.986    81.854     0.150
     2.991    51.320     0.150
     2.991    92.588     0.150
     3.671    54.719     0.150
     3.671    94.896     0.150
     3.916    99.867     0.150
     3.916    58.521     0.150
     3.993    59.316     0.150
     3.993   103.537     0.150
     4.048   103.219     0.150
     4.048    61.143     0.150
     4.048    61.535     0.150
     4.048   102.908     0.150
     4.117   104.793     0.150
     4.117    61.984     0.150
     4.117   106.814     0.150
     4.188   107.844     0.150
     4.188    62.682     0.150
     4.188    64.088     0.150
     4.188   107.477     0.150
     4.252    63.367     0.150
     4.252   107.717     0.150
     4.252   110.598     0.150
     4.304   110.713     0.150
     4.304    64.576     0.150
     4.304    65.107     0.150
     4.304   111.207     0.150
     4.392   112.559     0.150
     4.392    65.041     0.150
     4.392    65.254     0.150
     4.392   113.260     0.150
     4.485    67.447     0.150
     4.485   116.668     0.150
     4.553    67.316     0.150
     4.571   116.646     0.150
     4.571    67.688     0.150
     4.571   116.057     0.150
     4.592   116.859     0.150
     4.592    68.014     0.150
     4.592   118.340     0.150
     5.135   129.920     0.150
     5.135    75.189     0.150
     5.135   130.842     0.150
     5.345    78.736     0.150
     5.345   133.717     0.150
     5.401    78.945     0.150
     5.401   135.529     0.150
     5.688   143.428     0.150
     5.852    84.998     0.150
     5.852   146.236     0.150
     6.174   154.947     0.150
     6.268   157.316     0.150
     7.515   109.018     0.150
     0.555    12.199     0.150
     0.555    20.801     0.150
     0.686    14.234     0.150
     0.686    25.090     0.150
     0.793    16.258     0.150
     0.793    26.434     0.150
     0.917    18.480     0.150
     0.917    31.387     0.150
     1.079    22.383     0.150
     1.079    38.098     0.150
     1.213    22.277     0.150
     1.213    38.699     0.150
     1.213    22.820     0.150
     1.213    40.301     0.150
     1.211    24.301     0.150
     1.211    41.367     0.150
     1.211    42.301     0.150
     1.662    31.277     0.150
     1.662    53.438     0.150
     1.662    31.828     0.150
     1.699    54.777     0.150
     1.699    32.824     0.150
     1.699    31.070     0.150
     1.721    55.945     0.150
     1.875    33.496     0.150
     1.875    58.148     0.150
     2.003    37.008     0.150
     2.003    64.641     0.150
     2.003    64.301     0.150
     2.037    36.703     0.150
     2.037    65.238     0.150
     2.037    38.301     0.150
     2.037    65.352     0.150
     2.220    40.199     0.150
     2.220    69.648     0.150
     2.271    70.906     0.150
     2.271    41.152     0.150
     2.271    38.684     0.150
     2.271    67.805     0.150
     2.456    41.383     0.150
     2.456    72.344     0.150
     2.539    42.516     0.150
     2.539    74.984     0.150
     3.255    51.656     0.150
     3.255    90.805     0.150
     3.655    58.887     0.150
     3.655   101.652     0.150
     4.972    75.070     0.150
     4.972   129.242     0.150
     5.054    76.211     0.150
     5.054   130.703     0.150
     5.095    77.457     0.150
     5.095   136.824     0.150
     5.113    77.098     0.150
     5.113   131.473     0.150
     5.175    78.578     0.150
     5.175   134.551     0.150
     5.212   136.133     0.150
     5.289    80.980     0.150
     5.289   136.184     0.150
     5.289   137.094     0.150
     5.362   138.793     0.150
     5.399    82.664     0.150
     5.399   138.293     0.150
     5.525    83.730     0.150
     5.525   143.570     0.150
     5.546    83.945     0.150
     5.546   143.242     0.150
     5.610    85.070     0.150
     5.610   143.453     0.150
     5.610   145.070     0.150
     5.633    85.094     0.150
     5.633   145.070     0.150
     6.195    92.297     0.150
     6.195   157.949     0.150
     6.310    93.590     0.150
     6.310   163.168     0.150
     6.410   164.223     0.150
     6.752   100.121     0.150
     6.752   172.512     0.150
     6.765    96.543     0.150
     6.914   102.672     0.150
     6.914   176.301     0.150
     7.239   106.754     0.150
     7.397   108.484     0.150
     7.397   186.301     0.150
     0.578    12.906     0.150
     0.578    21.562     0.150
     0.900    17.977     0.150
     0.900    29.617     0.150
     0.900    16.898     0.150
     0.900    28.047     0.150
     0.977    19.031     0.150
     0.977    32.422     0.150
     1.017    19.680     0.150
     1.017    34.062     0.150
     1.081    19.984     0.150
     1.425    25.383     0.150
     1.425    44.328     0.150
     1.646    28.289     0.150
     1.646    50.344     0.150
     1.687    29.070     0.150
     1.687    51.297     0.150
     1.796    30.805     0.150
     1.796    54.281     0.150
     2.184    34.969     0.150
     2.423    39.062     0.150
     2.515    41.391     0.150
     2.515    73.422     0.150
     2.508    75.562     0.150
     2.619    41.266     0.150
     2.619    72.961     0.150
     2.691    44.273     0.150
     2.691    77.852     0.150
     2.872    47.078     0.150
     2.872    83.000     0.150
     3.397    50.445     0.150
     3.397    86.750     0.150
     3.397    87.188     0.150
     3.455    51.367     0.150
     3.455    88.406     0.150
     3.495    52.078     0.150
     3.495    89.203     0.150
     3.495    51.500     0.150
     3.495    88.422     0.150
     3.528    52.367     0.150
     3.528    52.250     0.150
     3.528    88.336     0.150
     3.523    54.078     0.150
     3.731    56.508     0.150
     3.569    55.102     0.150
     3.569    94.156     0.150
     3.774    55.703     0.150
     3.774    56.555     0.150
     3.776    55.883     0.150
     3.776    95.656     0.150
     3.776    56.008     0.150
     3.776    96.180     0.150
     3.785    57.422     0.150
     3.785    57.297     0.150
     3.785    95.227     0.150
     3.990    58.797     0.150
     3.990   100.906     0.150
     3.999    58.766     0.150
     3.999   102.883     0.150
     3.994    59.820     0.150
     3.994    59.711     0.150
     3.994   100.312     0.150
     4.028    58.883     0.150
     4.028    59.359     0.150
     4.028   103.523     0.150
     4.549    67.602     0.150
     4.549   113.086     0.150
     4.774    70.062     0.150
     4.814    70.984     0.150
     4.814   120.070     0.150
     0.552    12.441     0.150
     0.552    21.297     0.150
     0.942    17.457     0.150
     0.979    30.891     0.150
     0.979    18.516     0.150
     1.006    19.344     0.150
     1.006    34.391     0.150
     1.124    20.785     0.150
     1.124    36.773     0.150
     1.692    28.598     0.150
     1.692    52.301     0.150
     1.799    30.316     0.150
     1.799    55.219     0.150
     2.139    59.184     0.150
     2.551    43.441     0.150
     2.551    77.742     0.150
     2.652    41.488     0.150
     2.652    74.195     0.150
     3.390    86.199     0.150
     3.390    49.895     0.150
     3.390    86.656     0.150
     3.446    88.125     0.150
     3.483    52.277     0.150
     3.483    89.898     0.150
     3.508    52.406     0.150
     3.508    92.637     0.150
     3.564    53.547     0.150
     3.564    96.137     0.150
     3.535    54.688     0.150
     3.535    96.824     0.150
     3.755    95.395     0.150
     3.755    55.809     0.150
     3.755    56.797     0.150
     3.755    97.461     0.150
     3.972    57.953     0.150
     3.972   100.016     0.150
     3.972    58.566     0.150
     3.959    57.879     0.150
     3.959   100.422     0.150
     3.959    58.301     0.150
     3.959   101.445     0.150
     4.020    58.395     0.150
     4.020   102.125     0.150
     4.196    63.391     0.150
     4.196   113.148     0.150
     4.380    64.449     0.150
     4.380   116.145     0.150
     4.529    66.703     0.150
     4.529   113.977     0.150
     4.529    67.047     0.150
     4.529   114.980     0.150
     4.777    71.848     0.150
     4.777   121.094     0.150
     5.121    74.387     0.150
     5.121   129.426     0.150
     5.339   133.824     0.150
     5.667    82.414     0.150
     0.393     8.773     0.150
     0.393    14.123     0.150
     0.393    15.238     0.150
     0.524    11.168     0.150
     0.524    20.066     0.150
     0.524    11.268     0.150
     0.813    17.285     0.150
     1.116    22.543     0.150
     1.178    40.215     0.150
     1.178    24.227     0.150
     1.190    22.904     0.150
     1.189    23.340     0.150
     1.189    39.752     0.150
     1.901    35.256     0.150
     2.098    38.299     0.150
     2.602    44.283     0.150
     2.602    43.719     0.150
     2.602    44.508     0.150
     2.594    44.070     0.150
     2.594    76.203     0.150
     2.540    42.303     0.150
     2.645    43.908     0.150
     2.645    77.467     0.150
     2.778    79.650     0.150
     2.778    46.646     0.150
     2.778    46.758     0.150
     2.768    46.607     0.150
     2.768    85.607     0.150
     2.776    45.939     0.150
     2.776    80.873     0.150
     2.862    47.406     0.150
     2.862    81.199     0.150
     2.864    47.459     0.150
     2.864    81.975     0.150
     3.105    86.252     0.150
     3.105    51.148     0.150
     3.105    51.289     0.150
     3.121    51.699     0.150
     3.064    49.398     0.150
     3.419    55.045     0.150
     3.404    55.686     0.150
     3.404    55.965     0.150
     3.404    91.730     0.150
     3.445    54.857     0.150
     3.445    55.334     0.150
     3.445    93.252     0.150
     3.495    54.398     0.150
     3.957    60.240     0.150
     3.957    60.439     0.150
     4.034    63.773     0.150
     4.165    65.418     0.150
     4.170    65.770     0.150
     4.170    65.629     0.150
     4.170    65.889     0.150
     4.259    65.604     0.150
     4.259    65.797     0.150
     4.259   114.906     0.150
     4.316    67.498     0.150
     4.335    82.898     0.150
     4.445   119.230     0.150
     4.445    68.754     0.150
     4.445    68.871     0.150
     4.445   115.959     0.150
     4.474    69.223     0.150
     4.474    69.930     0.150
     4.474   117.934     0.150
     4.483    71.297     0.150
     4.555    69.799     0.150
     4.612    72.758     0.150
     4.612   124.752     0.150
     4.613    71.787     0.150
     4.637    71.010     0.150
     4.637    71.555     0.150
     4.791    74.898     0.150
     4.921    74.896     0.150
     4.921   128.678     0.150
     5.016    73.898     0.150
     5.232    82.938     0.150
     5.232   136.500     0.150
     5.248    82.260     0.150
     5.248   137.113     0.150
     5.296    79.799     0.150
     5.393    82.381     0.150
     5.393   142.293     0.150
     5.425    83.297     0.150
     5.512    82.127     0.150
     5.512   142.643     0.150
     5.512   140.186     0.150
     5.529    82.385     0.150
     5.529   142.814     0.150
     5.529   143.789     0.150
     5.526    82.682     0.150
     5.526   143.584     0.150
     5.526    83.383     0.150
     5.526   142.293     0.150
     5.537    83.924     0.150
     5.537   144.297     0.150
     5.537    84.143     0.150
     5.537   143.873     0.150
     5.569    83.088     0.150
     5.569   142.389     0.150
     5.569    82.859     0.150
     5.503    83.398     0.150
     5.585    83.230     0.150
     5.585   143.840     0.150
     5.603    83.984     0.150
     5.603   144.717     0.150
     5.603    83.469     0.150
     5.603    83.662     0.150
     5.742    86.420     0.150
     5.742    86.256     0.150
     5.884    87.219     0.150
     5.884   150.688     0.150
     5.884    87.018     0.150
     5.884   152.248     0.150
     5.884    87.418     0.150
     5.899    87.543     0.150
     5.899   151.092     0.150
     5.899   152.369     0.150
     5.925    87.609     0.150
     5.925    87.229     0.150
     5.925   152.008     0.150
     5.925    87.498     0.150
     5.867    88.098     0.150
     6.000    88.840     0.150
     6.000   155.127     0.150
     6.000   154.598     0.150
     6.148    90.938     0.150
     6.148   157.658     0.150
     6.151    90.949     0.150
     6.151    90.838     0.150
     6.151   159.219     0.150
     6.162    90.938     0.150
     6.162   159.578     0.150
     6.192   161.252     0.150
     6.317    94.498     0.150
     6.383    96.902     0.150
     6.383    98.047     0.150
     6.383   169.705     0.150
     6.528    96.186     0.150
     6.528   165.135     0.150
     6.528    96.398     0.150
     6.528   165.531     0.150
     6.658    97.992     0.150
     6.658   169.070     0.150
     6.658   169.818     0.150
     6.723   101.709     0.150
     6.783    99.709     0.150
     6.783   174.898     0.150
     6.807    99.912     0.150
     6.807   172.924     0.150
     6.807    99.738     0.150
     6.807   173.389     0.150
     6.807   100.088     0.150
     6.775   100.398     0.150
     6.864   103.721     0.150
     6.906   102.357     0.150
     6.906   176.527     0.150
     6.906   101.889     0.150
     6.906   103.609     0.150
     7.037   105.051     0.150
     7.037   180.740     0.150
     7.037   104.299     0.150
     7.037   179.424     0.150
     7.037   104.799     0.150
     7.038   181.793     0.150
     7.116   108.598     0.150
     7.209   105.258     0.150
     7.209   183.158     0.150
     7.286   107.668     0.150
     7.286   188.139     0.150
     7.234   107.998     0.150
     7.427   111.262     0.150
     7.453   109.498     0.150
     7.542   110.264     0.150
     7.542   192.156     0.150
     7.542   110.139     0.150
     7.542   192.559     0.150
     7.575   111.631     0.150
     7.575   191.229     0.150
     7.518   111.898     0.150
     7.659   111.789     0.150
     7.659   193.789     0.150
     7.668   112.188     0.150
     7.668   192.158     0.150
     7.812   113.938     0.150
     7.812   197.559     0.150
     7.815   115.855     0.150
     7.815   115.592     0.150
     7.815   198.646     0.150
     7.933   118.387     0.150
     7.960   117.699     0.150
     8.179   118.969     0.150
     8.209   119.738     0.150
     8.209   119.879     0.150
     8.209   206.908     0.150
     8.209   119.398     0.150
     8.209   120.088     0.150
     8.220   124.250     0.150
     8.234   121.498     0.150
     8.551   124.896     0.150
     8.599   124.598     0.150
     8.599   216.379     0.150
     8.816   127.809     0.150
     8.816   221.449     0.150
     9.005   131.898     0.150
     9.077   131.699     0.150
     9.077   227.068     0.150
     9.075   134.611     0.150
     9.106   133.469     0.150
     9.106   133.592     0.150
     9.189   133.2