#!/bin/bash
gmt begin fes5.6_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-78/78/-78/78
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation fes5.6'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    18.455    18.455
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.183    -0.384
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.668    -5.195
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.151   -10.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.072     0.969
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.120   -11.177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.439     3.158
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    22.543    -7.762
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    22.543    -7.762 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.111    -8.853
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.543    14.429
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.543    14.429 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.611     9.234
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.305    17.470
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.226    -2.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.587     8.463
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.197     3.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.551     6.298
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.814    -1.759
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.982    -1.914
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.557   -14.266
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.134     6.615
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.503     2.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.969    14.988
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.886    -8.806
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.759     3.775
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.398     9.230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.355    19.008
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.355    19.008 25
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.744    27.007
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.744    27.007 26
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.727     6.208
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.388    13.863
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.388    13.863 28
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.106    -7.567
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    24.774     7.104
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    24.774     7.104 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.607    10.451
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    76.696    -5.363
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    76.696    -5.363 32
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.787     3.714
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.169     9.176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    25.101     6.258
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    25.101     6.258 35
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.784     7.948
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.552    12.932
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -16.552    12.932 37
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.349     0.076
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.371     8.702
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.337     1.232
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.063    14.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.764     9.315
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.846    -8.684
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.297    -7.297
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.065    13.866
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.167    -4.471
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.091     1.818
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.167    -7.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.077     1.013
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.916     4.209
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.548    14.954
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.548    14.954 51
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.469     5.342
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.534    -2.183
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.974    -5.274
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.064    11.406
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.974    -9.726
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.647     7.493
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.917    10.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.171    -1.436
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.280     8.922
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.801   -12.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.329    -3.131
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.403    -3.830
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.887    -2.176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.507     4.916
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.581    -5.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.096     0.233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -36.551    18.623
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -36.551    18.623 68
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.530    -1.838
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.269    -2.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.845     4.078
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.195     3.961
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.648    -1.046
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.046     6.697
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.453    11.600
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.508    -4.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.363     4.262
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.720     3.927
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.907    11.401
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.910    14.405
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.910    14.405 80
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.474    -1.428
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.324    11.071
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.215    -4.070
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.758     1.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.193     4.198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.524     6.994
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -21.524     6.994 86
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.405    20.089
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.405    20.089 87
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.850    -5.843
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.975    23.381
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.975    23.381 89
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.035    -4.178
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.579     9.528
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.569     2.138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.713    15.079
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.530    13.013
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.988   -15.371
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.688     3.707
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.681    -1.254
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.116     3.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.279     8.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.760     5.758
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.570     0.480
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.856     4.753
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -24.051    24.905
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -24.051    24.905 103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.100     9.660
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.242     3.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.766     7.096
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.443     3.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.623     4.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.726    20.802
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.726    20.802 109
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.750     6.176
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.444   -12.723
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.168    -7.219
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.165    12.784
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.705    26.290
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.705    26.290 114
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.872     1.397
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.870    12.034
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.067     5.279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.079    11.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.567    11.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.302   -11.487
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.137     5.567
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.659   -14.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.118     3.998
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.030     4.174
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.079    -2.165
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.721     2.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.598     5.155
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.700     7.178
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.700     7.178 128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.879     2.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.908     7.672
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.329     1.345
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.605    11.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.256     1.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.906   -21.721
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.906   -21.721 134
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.213   -10.411
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.749     0.472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.652    -2.825
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.665     3.544
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.999     1.267
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.389     0.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.308     5.881
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.561    -1.927
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.162     3.206
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.355     6.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.092     6.133
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.968    -0.627
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.632     2.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.864     3.052
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.147     2.574
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.727    12.135
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.861     2.634
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.562     0.376
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -21.562     0.376 152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.761     5.372
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.495     9.311
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.066    -2.483
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.340    15.313
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.014    25.797
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.014    25.797 157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.234    22.669
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.234    22.669 158
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.647     6.146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.872     1.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.334     6.081
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.601    -2.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.094    -6.636
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.443    -5.009
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.095    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.505    -0.941
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.467     1.437
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.546     1.590
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.797    -2.314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.836    -1.330
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.453    -3.479
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.847    -2.735
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.663    -6.064
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -18.663    -6.064 173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.615    13.402
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.303     5.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.827     2.272
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.101     0.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.021     2.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.112    -4.950
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.986    -0.174
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.377     1.011
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.646     6.006
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.220    -8.282
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.650     2.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.295   -10.418
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.582     7.344
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.623    -1.991
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.591    -8.067
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.712    17.712
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -17.712    17.712 189
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.685    12.404
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -20.316    -2.135
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -20.316    -2.135 191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.509    14.590
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.124     7.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.018     0.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.755    34.020
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.755    34.020 195
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.865     0.349
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.371     7.143
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.163    -3.277
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.270    20.087
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.270    20.087 199
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.027     9.317
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.230    -3.941
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.222    11.433
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.497     0.937
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.307    -0.110
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.403    20.163
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.403    20.163 205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.541     9.996
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.250     3.815
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.299     6.763
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.794     4.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.636     9.380
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.843    -1.524
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.081     9.364
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.090     8.436
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -18.090     8.436 213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.773     8.633
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.282   -16.184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.177     7.291
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -17.177     7.291 216
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.176     1.581
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.022    -1.440
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.221   -17.873
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.221   -17.873 219
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.105    -6.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.918    -1.264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.579     0.138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.417     8.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.075    -0.285
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.602     4.652
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.344     5.979
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.311    -1.345
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.551     6.301
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.808     6.614
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.597     3.996
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.845     3.977
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.865     6.960
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.521     6.993
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.281     6.028
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.941    12.769
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.518     4.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.284    -1.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.479    13.708
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.184     3.115
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.029     8.315
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.636    23.391
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.636    23.391 241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.313     5.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.843     7.227
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.979     9.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.507    11.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.583     0.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.920     8.038
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.525    10.013
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.464    13.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.561     3.343
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.648    10.441
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.745    -0.705
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.750    10.892
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.681     8.236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.752     1.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.057    -7.534
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.868    10.182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.566    11.383
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.587    -0.991
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.560     5.125
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.288     5.063
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.118    12.012
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.597     4.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -24.352     2.990
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -24.352     2.990 264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.401    -6.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.131     2.579
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.361    -3.438
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.057     4.351
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.304     4.547
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.428     4.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.645     8.141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.804     6.291
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.148    -4.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.225     3.421
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.866     4.949
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.712     8.056
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.647     7.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.693     3.325
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.332     8.332
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.792     7.185
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.985     4.749
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.275     9.071
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.205     9.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.811    -0.259
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.242     0.952
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.602     6.876
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.247     7.445
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.012    -0.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.246     9.537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.295     5.626
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.050    -5.957
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.212    -6.078
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.383     7.591
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.217     6.217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.593    10.820
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.250     7.746
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -18.250     7.746 296
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.201    -9.535
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.731    -8.360
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.062     6.278
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.065    -2.635
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.255     0.562
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.582   -16.663
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.008     8.696
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.023   -11.821
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.876     0.413
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.096     5.503
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.834    -3.569
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.921    -2.450
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.925     5.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.982    -4.907
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.298     7.072
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.775    10.482
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.999    10.937
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.102    13.704
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -21.102    13.704 314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.503     8.251
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.211     3.352
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.817     2.030
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.199    -4.808
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.753    10.900
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.638    17.445
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.638    17.445 320
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.369     7.590
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.880     3.506
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.570     0.807
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.831     6.845
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -17.831     6.845 324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.373     8.349
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.603     8.091
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.772     2.410
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.837    12.147
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.488    12.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.669     6.361
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.960     2.877
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.495    14.713
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.495    14.713 332
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.955     5.815
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.309     7.045
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.383     7.302
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -24.860     9.048
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -24.860     9.048 336
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.101    10.474
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.673     0.606
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.211     5.588
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.935    12.159
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -21.935    12.159 340
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.696     9.116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.810     7.811
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.067     9.415
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.919     9.549
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.813     2.143
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.540     9.311
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.153     9.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.699     0.877
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.557     9.772
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.175     1.058
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.106     6.097
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.623     9.116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.713     0.579
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.421     5.304
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.312     8.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.244     7.489
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.146     9.648
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -18.146     9.648 357
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.206    16.206
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -16.206    16.206 358
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.879     6.879
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.616     8.558
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.336     4.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.145    -1.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -24.117     5.126
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -24.117     5.126 363
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.621     0.275
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.079    10.263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.937     6.937
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.151    11.958
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.560     8.004
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.233     6.046
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.230     6.961
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -17.230     6.961 370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.900     4.442
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.455     4.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.405   -12.732
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.404   -15.851
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -23.541     5.869
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -23.541     5.869 375
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.359    -2.591
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.785    -1.513
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.280    -2.690
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.980     3.737
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.030    -3.623
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.194     4.058
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.492    -2.313
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.961     1.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.482     3.038
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.146   -18.616
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.146   -18.616 385
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.453     1.396
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.924     7.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.894     8.373
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -4.014     3.995     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -76.000    76.000 Author: all ( 388 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -76.000   -76.000 Average =   5.7 km at 314.9 deg; median =    9.2 km
EOF
gmt end
