#!/bin/bash
gmt begin fes5.6_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-35/35/0/37
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya25f5+lCounts -BWeSn+t'Focal Depth Mislocation fes5.6' << EOF
    -0.000
   -14.000
    12.000
     4.000
     1.000
    -2.800
     7.700
     5.000
     9.700
    -2.500
    -5.400
   -25.000
    -7.000
    -8.000
    -2.900
     7.100
    -2.100
   -14.000
    -2.000
     5.200
     3.000
    12.000
     5.000
    -8.000
   -15.900
    -3.800
     0.300
    -0.000
     0.400
    -0.000
   -11.000
    -2.000
    12.800
    -1.100
   -23.000
    -5.000
     0.600
    -3.000
    19.200
     5.000
     5.000
    -0.000
   -12.000
   -23.000
   -25.000
    -0.000
    -1.200
    -9.000
     1.800
    -6.000
    -2.600
    -8.000
     2.000
   -12.000
    -4.200
    -2.000
     3.100
   -21.000
    -9.000
     7.600
   -18.000
   -10.000
   -10.000
   -12.000
     7.000
    -5.000
   -14.000
    -4.000
    -0.100
    -6.000
    -0.000
    -4.000
    -7.000
    -1.200
     7.700
   -12.900
     3.000
   -15.000
    -8.000
    16.100
    -9.000
     2.000
   -10.000
   -12.000
   -14.000
   -30.000
   -15.000
     4.000
   -17.000
   -12.000
   -18.000
    -2.500
   -20.100
   -18.000
   -25.000
    -3.400
     1.600
    -3.100
     4.600
    -8.100
    -1.600
    16.000
     4.300
    -6.500
     2.100
    -0.000
    11.900
     6.800
   -17.000
     6.100
     8.000
    25.000
    12.400
   -12.000
     2.000
    -5.000
    -1.000
   -10.000
     3.000
     4.000
    -7.200
   -18.000
     1.200
     4.200
    -8.100
     2.000
    -3.100
     3.700
    -1.500
     2.600
     0.100
    -3.200
   -17.000
     5.000
    -5.600
     2.500
    -4.900
    -0.900
    -5.000
     0.900
   -13.300
     2.000
     2.700
    -3.300
     5.000
    -3.600
     4.200
    -4.000
     4.600
    -3.000
   -17.000
     3.800
   -14.000
    -3.800
     2.000
   -28.800
    -0.400
     2.400
    -4.800
    -3.000
    -2.900
     4.100
    -0.000
     1.800
   -10.000
    -3.000
     1.000
     4.500
    -4.000
     6.000
    -9.000
    11.500
   -26.000
    10.800
   -10.200
     5.700
    -6.800
     9.100
     0.300
     6.000
    -2.000
     9.100
   -13.200
    -0.500
    -4.800
    -2.100
    -2.000
    -5.000
    -7.400
    -3.000
     4.000
    -7.000
     1.000
     9.300
   -16.900
    14.000
   -15.000
    -2.600
    -4.000
     7.100
   -12.000
     6.100
    10.100
     2.800
    16.100
    -5.500
     4.200
     1.700
     3.900
     4.700
     3.300
    12.500
    16.300
    -0.300
     7.400
   -16.000
    16.100
   -16.400
    -7.300
   -10.600
    -7.700
     0.100
    -7.000
    -7.700
     5.700
    -6.000
   -13.700
    -3.000
    -6.000
    -0.200
    -3.000
   -23.000
    -2.000
    -3.000
     1.000
     6.000
     2.700
     1.000
     2.200
    -3.000
   -24.000
     7.000
    -0.000
    -3.000
    -6.000
   -19.300
     8.000
    -2.000
     2.000
     1.000
   -13.000
    -2.000
    -4.000
    -4.000
    -2.000
    -2.000
    -1.000
    -6.000
     1.000
    -1.000
    -5.000
    -0.100
     8.600
    16.700
    -3.900
    14.300
     1.300
    -2.700
    -4.300
    -1.100
     5.200
     5.300
    -3.500
    -2.700
    -1.600
    -1.600
    -0.200
     6.300
     5.800
     0.100
     5.300
    -7.300
   -24.000
     4.800
    -2.300
    -5.200
    -2.000
    -0.900
    -9.100
    -0.300
   -15.600
     3.800
     2.200
     0.500
     0.100
     5.700
   -10.900
     1.000
     0.400
    -2.500
    -0.000
    -0.200
    -0.100
    -4.100
    -0.300
    -0.400
    -9.900
     1.800
    -2.000
    -9.500
    -3.000
   -11.800
    -4.600
    -2.500
     1.600
    29.600
   -10.100
   -19.400
   -15.200
    12.800
    -6.000
    -0.800
    -3.900
   -11.200
     2.600
    -2.200
     1.300
    -2.200
    -5.300
     4.300
     0.500
    -3.000
   -13.000
     5.200
     5.600
    -4.900
     0.300
    -1.300
    13.300
    -5.600
   -18.900
    -6.300
    13.200
     5.200
     7.400
    -5.500
    -1.000
    -6.700
    -8.800
     1.400
     0.200
   -19.500
    -2.500
     8.800
    -4.300
     8.100
     4.200
   -13.700
   -10.000
     8.900
    -2.300
     9.600
     1.100
    -8.200
     5.700
    15.300
    -7.900
     6.100
    -2.400
    20.000
     2.000
   -16.400
    18.900
    -8.900
   -18.000
    -4.800
    -8.200
    -4.000
   -14.100
    -6.900
    -7.900
    -3.000
     4.800
    -8.000
    -6.200
    -5.000
   -19.000
    -2.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -2.000    32.943 Median =  -2.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -2.0  0.
 -2.0  32.3
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -34.000    35.057 Author: all ( 388 samples)
EOF
gmt end
