#!/bin/bash
gmt begin fes5.6_dcal pdf,ps
proj=-JM16.0c+
reg=-R-9.2/-1.0/29.3/36.3
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration fes5.6'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
    -5.127    33.517
    -5.111    34.263
>
    -5.127    33.517
    -5.209    34.128
>
    -5.127    33.517
    -5.209    34.128
>
    -5.127    33.517
    -4.014    33.791
>
    -5.127    33.517
    -5.239    33.353
>
    -5.127    33.517
    -5.239    33.353
>
    -5.127    33.517
    -5.315    32.935
>
    -5.127    33.517
    -5.315    32.935
>
    -5.127    33.517
    -5.353    32.939
>
    -5.127    33.517
    -5.353    32.939
>
    -5.043    33.033
    -4.982    33.173
>
    -5.043    33.033
    -4.982    33.173
>
    -5.319    32.530
    -4.982    33.173
>
    -5.319    32.530
    -4.982    33.173
>
    -3.754    34.962
    -3.222    34.324
>
    -2.414    34.814
    -3.222    34.324
>
    -2.957    35.300
    -3.222    34.324
>
    -2.957    35.300
    -3.222    34.324
>
    -4.184    34.089
    -3.292    34.281
>
    -4.184    34.089
    -3.292    34.281
>
    -3.754    34.962
    -3.292    34.281
>
    -2.746    34.970
    -3.292    34.281
>
    -2.414    34.814
    -3.292    34.281
>
    -2.414    34.814
    -3.292    34.281
>
    -4.184    34.089
    -4.812    34.139
>
    -4.184    34.089
    -4.812    34.139
>
    -5.127    33.517
    -4.812    34.139
>
    -5.127    33.517
    -5.079    34.164
>
    -5.127    33.517
    -5.079    34.164
>
    -4.184    34.089
    -5.079    34.164
>
    -4.184    34.089
    -5.079    34.164
>
    -5.828    34.877
    -5.079    34.164
>
    -5.828    34.877
    -5.079    34.164
>
    -5.043    33.033
    -5.100    33.243
>
    -5.043    33.033
    -5.100    33.243
>
    -5.127    33.517
    -5.100    33.243
>
    -5.127    33.517
    -5.100    33.243
>
    -5.127    33.517
    -5.100    33.243
>
    -5.127    33.517
    -5.100    33.243
>
    -5.055    34.070
    -5.100    33.243
>
    -5.055    34.070
    -5.100    33.243
>
    -4.184    34.089
    -4.907    34.329
>
    -4.184    34.089
    -4.907    34.329
>
    -5.127    33.517
    -4.907    34.329
>
    -5.229    33.409
    -4.907    34.329
>
    -5.229    33.409
    -4.907    34.329
>
    -5.055    34.070
    -4.796    34.116
>
    -5.055    34.070
    -4.796    34.116
>
    -5.127    33.517
    -4.796    34.116
>
    -5.229    33.409
    -4.796    34.116
>
    -5.229    33.409
    -4.796    34.116
>
    -5.127    33.517
    -4.242    33.681
>
    -5.127    33.517
    -4.242    33.681
>
    -5.127    33.517
    -5.461    32.874
>
    -5.127    33.517
    -5.461    32.874
>
    -5.127    33.517
    -5.370    32.759
>
    -5.127    33.517
    -5.370    32.759
>
    -5.127    33.517
    -5.370    32.759
>
    -5.127    33.517
    -5.429    32.645
>
    -5.127    33.517
    -5.429    32.645
>
    -5.127    33.517
    -5.747    33.939
>
    -5.127    33.517
    -5.747    33.939
>
    -5.127    33.517
    -5.259    33.961
>
    -5.127    33.517
    -5.259    33.961
>
    -5.127    33.517
    -5.928    33.857
>
    -5.127    33.517
    -5.928    33.857
>
    -5.127    33.517
    -5.013    34.087
>
    -5.127    33.517
    -5.013    34.087
>
    -5.229    33.409
    -5.429    33.997
>
    -5.229    33.409
    -5.429    33.997
>
    -5.043    33.033
    -5.806    33.665
>
    -5.043    33.033
    -5.806    33.665
>
    -4.184    34.089
    -4.265    34.444
>
    -5.043    33.033
    -5.555    33.594
>
    -5.055    34.070
    -4.854    34.083
>
    -5.055    34.070
    -4.854    34.083
>
    -6.039    32.576
    -6.124    32.439
>
    -6.490    32.148
    -6.124    32.439
>
    -6.490    32.148
    -6.124    32.439
>
    -6.039    32.576
    -6.066    32.438
>
    -6.039    32.576
    -6.066    32.438
>
    -6.490    32.148
    -6.066    32.438
>
    -6.490    32.148
    -6.066    32.438
>
    -5.043    33.033
    -5.197    33.019
>
    -5.043    33.033
    -5.197    33.019
>
    -5.229    33.409
    -5.197    33.019
>
    -5.229    33.409
    -5.197    33.019
>
    -6.039    32.576
    -5.197    33.019
>
    -5.043    33.033
    -5.383    32.747
>
    -4.614    32.817
    -5.383    32.747
>
    -5.127    33.517
    -5.383    32.747
>
    -5.127    33.517
    -5.383    32.747
>
    -6.857    33.988
    -6.202    33.849
>
    -6.857    33.988
    -6.202    33.849
>
    -5.229    33.409
    -6.202    33.849
>
    -5.055    34.070
    -6.202    33.849
>
    -6.490    32.148
    -5.518    31.686
>
    -6.490    32.148
    -5.518    31.686
>
    -6.039    32.576
    -5.518    31.686
>
    -6.039    32.576
    -5.518    31.686
>
    -5.055    34.070
    -5.879    33.726
>
    -5.055    34.070
    -5.879    33.726
>
    -6.857    33.988
    -5.879    33.726
>
    -6.857    33.988
    -5.879    33.726
>
    -5.043    33.033
    -5.879    33.726
>
    -5.043    33.033
    -5.879    33.726
>
    -6.039    32.576
    -5.580    31.928
>
    -6.490    32.148
    -5.580    31.928
>
    -6.490    32.148
    -5.580    31.928
>
    -5.055    34.070
    -4.709    34.286
>
    -5.127    33.517
    -4.709    34.286
>
    -5.127    33.517
    -4.709    34.286
>
    -5.229    33.409
    -4.709    34.286
>
    -5.229    33.409
    -4.709    34.286
>
    -5.055    34.070
    -4.774    34.279
>
    -5.055    34.070
    -4.774    34.279
>
    -5.127    33.517
    -4.774    34.279
>
    -5.127    33.517
    -4.774    34.279
>
    -5.229    33.409
    -4.774    34.279
>
    -5.229    33.409
    -4.774    34.279
>
    -5.043    33.033
    -5.729    33.540
>
    -5.043    33.033
    -5.729    33.540
>
    -5.055    34.070
    -5.729    33.540
>
    -5.055    34.070
    -5.729    33.540
>
    -6.039    32.576
    -5.729    33.540
>
    -6.039    32.576
    -5.729    33.540
>
    -4.352    32.034
    -3.562    32.549
>
    -4.352    32.034
    -3.562    32.549
>
    -4.614    32.817
    -3.562    32.549
>
    -4.614    32.817
    -3.562    32.549
>
    -5.043    33.033
    -5.166    33.035
>
    -5.043    33.033
    -5.166    33.035
>
    -5.229    33.409
    -5.166    33.035
>
    -6.039    32.576
    -5.166    33.035
>
    -6.039    32.576
    -5.166    33.035
>
    -4.614    32.817
    -3.542    32.613
>
    -4.614    32.817
    -3.542    32.613
>
    -4.184    34.089
    -4.348    34.213
>
    -5.043    33.033
    -5.154    32.842
>
    -5.043    33.033
    -5.154    32.842
>
    -5.229    33.409
    -5.154    32.842
>
    -5.229    33.409
    -5.154    32.842
>
    -4.184    34.089
    -4.303    34.026
>
    -4.184    34.089
    -4.303    34.026
>
    -5.055    34.070
    -4.303    34.026
>
    -5.229    33.409
    -4.303    34.026
>
    -5.055    34.070
    -5.457    33.983
>
    -5.055    34.070
    -5.457    33.983
>
    -5.229    33.409
    -5.457    33.983
>
    -5.229    33.409
    -5.457    33.983
>
    -5.828    34.877
    -5.457    33.983
>
    -5.828    34.877
    -5.457    33.983
>
    -5.229    33.409
    -4.687    34.277
>
    -5.229    33.409
    -4.687    34.277
>
    -5.828    34.877
    -5.583    34.246
>
    -5.055    34.070
    -5.583    34.246
>
    -5.055    34.070
    -5.583    34.246
>
    -5.229    33.409
    -5.583    34.246
>
    -5.229    33.409
    -5.583    34.246
>
    -6.490    32.148
    -5.788    32.218
>
    -6.490    32.148
    -5.788    32.218
>
    -6.490    32.148
    -5.788    32.218
>
    -6.490    32.148
    -5.788    32.218
>
    -5.043    33.033
    -5.197    33.105
>
    -5.043    33.033
    -5.197    33.105
>
    -5.229    33.409
    -5.197    33.105
>
    -5.229    33.409
    -5.197    33.105
>
    -4.614    32.817
    -5.197    33.105
>
    -6.039    32.576
    -5.197    33.105
>
    -5.055    34.070
    -5.197    33.105
>
    -5.055    34.070
    -5.197    33.105
>
    -5.055    34.070
    -5.336    34.215
>
    -5.828    34.877
    -5.336    34.215
>
    -5.828    34.877
    -5.336    34.215
>
    -5.229    33.409
    -5.336    34.215
>
    -4.184    34.089
    -5.336    34.215
>
    -4.184    34.089
    -5.336    34.215
>
    -6.490    32.148
    -5.846    32.063
>
    -6.490    32.148
    -5.846    32.063
>
    -6.039    32.576
    -5.846    32.063
>
    -6.039    32.576
    -5.846    32.063
>
    -6.490    32.148
    -6.431    31.894
>
    -6.490    32.148
    -6.431    31.894
>
    -6.039    32.576
    -6.431    31.894
>
    -6.039    32.576
    -6.431    31.894
>
    -6.490    32.148
    -6.161    32.092
>
    -6.490    32.148
    -6.161    32.092
>
    -6.490    32.148
    -6.166    32.068
>
    -6.490    32.148
    -6.166    32.068
>
    -6.039    32.576
    -6.166    32.068
>
    -6.039    32.576
    -6.166    32.068
>
    -6.039    32.576
    -5.806    32.155
>
    -6.039    32.576
    -5.806    32.155
>
    -6.490    32.148
    -5.806    32.155
>
    -6.490    32.148
    -5.806    32.155
>
    -5.043    33.033
    -5.331    32.969
>
    -5.043    33.033
    -5.331    32.969
>
    -5.229    33.409
    -5.331    32.969
>
    -5.229    33.409
    -5.331    32.969
>
    -6.039    32.576
    -5.331    32.969
>
    -6.039    32.576
    -5.331    32.969
>
    -4.184    34.089
    -4.235    33.684
>
    -5.229    33.409
    -4.235    33.684
>
    -5.043    33.033
    -4.235    33.684
>
    -5.043    33.033
    -4.235    33.684
>
    -4.352    32.034
    -4.638    32.596
>
    -4.352    32.034
    -4.638    32.596
>
    -4.352    32.034
    -4.638    32.596
>
    -4.352    32.034
    -4.638    32.596
>
    -5.043    33.033
    -4.638    32.596
>
    -5.043    33.033
    -4.638    32.596
>
    -5.043    33.033
    -4.638    32.596
>
    -5.043    33.033
    -4.638    32.596
>
    -5.229    33.409
    -5.938    33.728
>
    -5.229    33.409
    -5.938    33.728
>
    -6.857    33.988
    -5.938    33.728
>
    -6.857    33.988
    -5.938    33.728
>
    -6.490    32.148
    -6.243    32.250
>
    -6.490    32.148
    -6.243    32.250
>
    -6.039    32.576
    -6.243    32.250
>
    -6.039    32.576
    -6.243    32.250
>
    -6.039    32.576
    -5.781    32.358
>
    -6.039    32.576
    -5.781    32.358
>
    -6.490    32.148
    -5.781    32.358
>
    -6.490    32.148
    -5.781    32.358
>
    -5.043    33.033
    -5.781    32.358
>
    -5.043    33.033
    -5.781    32.358
>
    -5.055    34.070
    -5.794    33.597
>
    -5.043    33.033
    -5.794    33.597
>
    -5.043    33.033
    -5.794    33.597
>
    -6.857    33.988
    -5.808    33.606
>
    -5.055    34.070
    -5.808    33.606
>
    -5.055    34.070
    -5.808    33.606
>
    -5.043    33.033
    -5.808    33.606
>
    -5.043    33.033
    -5.808    33.606
>
    -6.039    32.576
    -6.047    32.274
>
    -6.039    32.576
    -6.047    32.274
>
    -6.490    32.148
    -6.047    32.274
>
    -6.490    32.148
    -6.047    32.274
>
    -5.043    33.033
    -5.269    33.099
>
    -5.043    33.033
    -5.269    33.099
>
    -6.039    32.576
    -5.269    33.099
>
    -6.039    32.576
    -5.269    33.099
>
    -5.055    34.070
    -5.269    33.099
>
    -6.039    32.576
    -5.406    32.408
>
    -5.043    33.033
    -5.406    32.408
>
    -5.043    33.033
    -5.406    32.408
>
    -6.490    32.148
    -5.406    32.408
>
    -6.490    32.148
    -5.406    32.408
>
    -4.352    32.034
    -5.406    32.408
>
    -4.352    32.034
    -5.406    32.408
>
    -6.039    32.576
    -5.625    32.322
>
    -6.039    32.576
    -5.625    32.322
>
    -5.043    33.033
    -5.625    32.322
>
    -5.043    33.033
    -5.625    32.322
>
    -6.490    32.148
    -5.625    32.322
>
    -6.490    32.148
    -5.625    32.322
>
    -6.490    32.148
    -6.157    32.088
>
    -6.490    32.148
    -6.157    32.088
>
    -6.039    32.576
    -6.157    32.088
>
    -6.039    32.576
    -6.157    32.088
>
    -6.039    32.576
    -5.355    32.242
>
    -6.039    32.576
    -5.355    32.242
>
    -5.043    33.033
    -5.355    32.242
>
    -4.352    32.034
    -5.355    32.242
>
    -4.352    32.034
    -5.355    32.242
>
    -6.490    32.148
    -5.355    32.242
>
    -6.490    32.148
    -5.355    32.242
>
    -5.055    34.070
    -5.015    34.005
>
    -5.229    33.409
    -5.015    34.005
>
    -5.229    33.409
    -5.015    34.005
>
    -5.043    33.033
    -5.015    34.005
>
    -5.043    33.033
    -5.015    34.005
>
    -5.055    34.070
    -4.840    33.993
>
    -5.229    33.409
    -4.840    33.993
>
    -5.229    33.409
    -4.840    33.993
>
    -5.043    33.033
    -4.840    33.993
>
    -6.490    32.148
    -5.983    31.997
>
    -6.490    32.148
    -5.983    31.997
>
    -6.039    32.576
    -5.983    31.997
>
    -6.039    32.576
    -5.983    31.997
>
    -5.043    33.033
    -5.367    32.903
>
    -5.043    33.033
    -5.367    32.903
>
    -5.229    33.409
    -5.367    32.903
>
    -5.229    33.409
    -5.367    32.903
>
    -6.039    32.576
    -5.367    32.903
>
    -6.039    32.576
    -5.367    32.903
>
    -4.184    34.089
    -3.577    33.869
>
    -4.184    34.089
    -3.577    33.869
>
    -6.490    32.148
    -6.605    31.927
>
    -6.039    32.576
    -6.605    31.927
>
    -6.039    32.576
    -6.605    31.927
>
    -6.490    32.148
    -6.202    32.277
>
    -6.490    32.148
    -6.202    32.277
>
    -6.039    32.576
    -6.202    32.277
>
    -6.039    32.576
    -6.202    32.277
>
    -5.055    34.070
    -4.402    33.692
>
    -5.055    34.070
    -4.402    33.692
>
    -5.229    33.409
    -4.402    33.692
>
    -5.229    33.409
    -5.268    33.507
>
    -5.229    33.409
    -5.268    33.507
>
    -5.055    34.070
    -5.268    33.507
>
    -5.055    34.070
    -5.600    34.147
>
    -5.055    34.070
    -5.600    34.147
>
    -6.039    32.576
    -5.341    32.442
>
    -6.039    32.576
    -5.341    32.442
>
    -5.043    33.033
    -5.341    32.442
>
    -5.043    33.033
    -5.341    32.442
>
    -4.352    32.034
    -5.341    32.442
>
    -4.352    32.034
    -5.341    32.442
>
    -5.229    33.409
    -5.341    32.442
>
    -5.229    33.409
    -5.341    32.442
>
    -6.490    32.148
    -6.209    32.094
>
    -6.490    32.148
    -6.209    32.094
>
    -6.039    32.576
    -6.209    32.094
>
    -6.490    32.148
    -6.278    32.358
>
    -4.184    34.089
    -4.237    34.314
>
    -5.055    34.070
    -4.237    34.314
>
    -6.039    32.576
    -5.791    32.201
>
    -6.490    32.148
    -5.791    32.201
>
    -6.490    32.148
    -5.791    32.201
>
    -4.352    32.034
    -3.569    32.129
>
    -4.352    32.034
    -3.569    32.129
>
    -5.055    34.070
    -5.251    34.245
>
    -5.055    34.070
    -5.251    34.245
>
    -5.229    33.409
    -5.251    34.245
>
    -5.229    33.409
    -5.251    34.245
>
    -6.490    32.148
    -6.811    31.739
>
    -6.490    32.148
    -6.811    31.739
>
    -6.039    32.576
    -6.337    32.079
>
    -6.039    32.576
    -6.337    32.079
>
    -5.043    33.033
    -5.213    32.938
>
    -5.229    33.409
    -5.213    32.938
>
    -5.229    33.409
    -5.213    32.938
>
    -6.039    32.576
    -5.213    32.938
>
    -6.039    32.576
    -5.213    32.938
>
    -5.229    33.409
    -5.850    33.720
>
    -5.055    34.070
    -5.850    33.720
>
    -5.055    34.070
    -5.850    33.720
>
    -5.043    33.033
    -5.850    33.720
>
    -5.043    33.033
    -5.850    33.720
>
    -6.490    32.148
    -6.193    32.301
>
    -6.490    32.148
    -6.193    32.301
>
    -6.039    32.576
    -6.193    32.301
>
    -6.490    32.148
    -5.884    32.000
>
    -6.490    32.148
    -5.884    32.000
>
    -6.039    32.576
    -5.884    32.000
>
    -6.039    32.576
    -5.884    32.000
>
    -6.039    32.576
    -5.884    32.000
>
    -6.039    32.576
    -5.884    32.000
>
    -6.039    32.576
    -5.719    32.010
>
    -6.039    32.576
    -5.719    32.010
>
    -6.490    32.148
    -5.719    32.010
>
    -6.490    32.148
    -5.719    32.010
>
    -5.043    33.033
    -5.277    32.619
>
    -5.043    33.033
    -5.277    32.619
>
    -6.039    32.576
    -5.277    32.619
>
    -6.039    32.576
    -5.277    32.619
>
    -5.229    33.409
    -5.277    32.619
>
    -5.229    33.409
    -5.277    32.619
>
    -4.352    32.034
    -5.277    32.619
>
    -4.352    32.034
    -5.277    32.619
>
    -5.043    33.033
    -5.134    32.495
>
    -5.043    33.033
    -5.134    32.495
>
    -5.229    33.409
    -5.134    32.495
>
    -5.229    33.409
    -5.134    32.495
>
    -4.352    32.034
    -5.134    32.495
>
    -6.039    32.576
    -5.798    32.137
>
    -6.039    32.576
    -5.798    32.137
>
    -6.490    32.148
    -5.798    32.137
>
    -6.490    32.148
    -5.798    32.137
>
    -5.043    33.033
    -5.323    32.794
>
    -5.043    33.033
    -5.323    32.794
>
    -6.039    32.576
    -5.323    32.794
>
    -6.039    32.576
    -5.323    32.794
>
    -5.828    34.877
    -5.228    34.269
>
    -5.828    34.877
    -5.228    34.269
>
    -6.857    33.988
    -6.473    33.954
>
    -6.857    33.988
    -6.473    33.954
>
    -6.490    32.148
    -6.219    32.043
>
    -6.490    32.148
    -6.219    32.043
>
    -6.039    32.576
    -6.219    32.043
>
    -6.039    32.576
    -6.219    32.043
>
    -6.857    33.988
    -6.391    33.934
>
    -6.857    33.988
    -6.391    33.934
>
    -6.490    32.148
    -6.935    32.187
>
    -6.490    32.148
    -6.935    32.187
>
    -6.857    33.988
    -5.893    33.858
>
    -6.857    33.988
    -5.893    33.858
>
    -6.039    32.576
    -5.750    32.228
>
    -6.039    32.576
    -5.750    32.228
>
    -6.490    32.148
    -5.750    32.228
>
    -6.490    32.148
    -5.750    32.228
>
    -5.828    34.877
    -5.580    34.003
>
    -5.127    33.517
    -5.317    33.690
>
    -5.127    33.517
    -5.317    33.690
>
    -5.317    34.104
    -5.218    34.103
>
    -5.317    34.104
    -5.218    34.103
>
    -5.828    34.877
    -5.218    34.103
>
    -5.043    33.033
    -4.866    33.960
>
    -5.043    33.033
    -4.866    33.960
>
    -6.857    33.988
    -6.886    34.242
>
    -4.614    32.817
    -5.234    32.850
>
    -4.614    32.817
    -5.234    32.850
>
    -5.127    33.517
    -5.234    32.850
>
    -5.127    33.517
    -5.234    32.850
>
    -4.952    31.704
    -5.545    32.432
>
    -4.952    31.704
    -5.545    32.432
>
    -4.759    32.867
    -5.545    32.432
>
    -5.317    34.104
    -4.948    34.132
>
    -5.317    34.104
    -4.948    34.132
>
    -4.858    33.686
    -4.948    34.132
>
    -4.858    33.686
    -4.948    34.132
>
    -5.127    33.517
    -4.948    34.132
>
    -4.858    33.686
    -4.510    33.855
>
    -4.858    33.686
    -4.510    33.855
>
    -5.127    33.517
    -5.051    33.271
>
    -5.127    33.517
    -5.051    33.271
>
    -4.858    33.686
    -5.051    33.271
>
    -4.858    33.686
    -5.051    33.271
>
    -4.759    32.867
    -5.051    33.271
>
    -4.759    32.867
    -5.051    33.271
>
    -4.614    32.817
    -5.051    33.271
>
    -4.614    32.817
    -5.051    33.271
>
    -4.614    32.817
    -5.051    33.271
>
    -5.317    34.104
    -5.051    33.271
>
    -5.127    33.517
    -5.035    33.295
>
    -5.127    33.517
    -5.035    33.295
>
    -4.858    33.686
    -5.035    33.295
>
    -4.858    33.686
    -5.035    33.295
>
    -4.759    32.867
    -5.035    33.295
>
    -4.759    32.867
    -5.035    33.295
>
    -4.614    32.817
    -5.035    33.295
>
    -4.614    32.817
    -5.035    33.295
>
    -5.317    34.104
    -5.035    33.295
>
    -3.863    34.510
    -4.418    34.369
>
    -3.863    34.510
    -4.418    34.369
>
    -5.317    34.104
    -4.418    34.369
>
    -3.939    35.217
    -4.418    34.369
>
    -3.939    35.217
    -4.418    34.369
>
    -5.127    33.517
    -4.952    34.108
>
    -5.127    33.517
    -4.952    34.108
>
    -4.858    33.686
    -4.953    34.088
>
    -5.127    33.517
    -4.953    34.088
>
    -5.127    33.517
    -4.953    34.088
>
    -4.858    33.686
    -4.931    34.079
>
    -5.317    34.104
    -4.931    34.079
>
    -5.317    34.104
    -4.931    34.079
>
    -5.127    33.517
    -4.931    34.079
>
    -5.127    33.517
    -4.931    34.079
>
    -4.858    33.686
    -4.990    34.086
>
    -5.127    33.517
    -4.990    34.086
>
    -4.759    32.867
    -5.491    32.304
>
    -4.759    32.867
    -5.491    32.304
>
    -4.952    31.704
    -5.491    32.304
>
    -4.952    31.704
    -5.491    32.304
>
    -4.858    33.686
    -3.681    33.847
>
    -4.858    33.686
    -3.681    33.847
>
    -5.043    33.033
    -5.335    32.417
>
    -5.043    33.033
    -5.335    32.417
>
    -4.759    32.867
    -5.335    32.417
>
    -4.759    32.867
    -5.335    32.417
>
    -4.614    32.817
    -5.335    32.417
>
    -4.614    32.817
    -5.335    32.417
>
    -4.952    31.704
    -5.335    32.417
>
    -4.952    31.704
    -5.335    32.417
>
    -4.952    31.704
    -5.743    32.138
>
    -4.952    31.704
    -5.743    32.138
>
    -6.760    30.909
    -6.788    31.262
>
    -6.760    30.909
    -6.788    31.262
>
    -7.868    31.209
    -6.788    31.262
>
    -7.868    31.209
    -6.788    31.262
>
    -5.043    33.033
    -5.124    33.083
>
    -5.043    33.033
    -5.124    33.083
>
    -4.858    33.686
    -5.124    33.083
>
    -4.858    33.686
    -5.124    33.083
>
    -6.857    33.988
    -6.627    33.993
>
    -6.857    33.988
    -6.627    33.993
>
    -6.642    33.446
    -6.627    33.993
>
    -5.317    34.104
    -4.750    34.174
>
    -5.317    34.104
    -4.750    34.174
>
    -3.863    34.510
    -4.750    34.174
>
    -3.863    34.510
    -4.750    34.174
>
    -5.317    34.104
    -4.688    34.252
>
    -5.317    34.104
    -4.688    34.252
>
    -3.863    34.510
    -4.688    34.252
>
    -3.863    34.510
    -4.688    34.252
>
    -5.127    33.517
    -4.688    34.252
>
    -3.863    34.510
    -4.749    34.220
>
    -5.127    33.517
    -4.749    34.220
>
    -5.127    33.517
    -4.749    34.220
>
    -4.858    33.686
    -4.715    34.177
>
    -4.858    33.686
    -4.715    34.177
>
    -5.127    33.517
    -4.715    34.177
>
    -5.127    33.517
    -4.715    34.177
>
    -5.127    33.517
    -4.715    34.177
>
    -3.863    34.510
    -4.715    34.177
>
    -4.858    33.686
    -4.207    33.554
>
    -4.858    33.686
    -4.207    33.554
>
    -5.127    33.517
    -4.207    33.554
>
    -5.127    33.517
    -4.207    33.554
>
    -4.614    32.817
    -4.207    33.554
>
    -4.614    32.817
    -4.207    33.554
>
    -4.759    32.867
    -4.207    33.554
>
    -5.043    33.033
    -4.207    33.554
>
    -3.863    34.510
    -4.207    33.554
>
    -5.127    33.517
    -5.818    33.634
>
    -5.127    33.517
    -5.818    33.634
>
    -4.858    33.686
    -5.818    33.634
>
    -5.043    33.033
    -5.818    33.634
>
    -6.857    33.988
    -5.818    33.634
>
    -5.043    33.033
    -5.168    32.950
>
    -4.759    32.867
    -5.168    32.950
>
    -4.759    32.867
    -5.168    32.950
>
    -4.614    32.817
    -5.168    32.950
>
    -5.127    33.517
    -5.168    32.950
>
    -5.127    33.517
    -5.168    32.950
>
    -5.043    33.033
    -5.122    32.944
>
    -5.043    33.033
    -5.122    32.944
>
    -4.759    32.867
    -5.122    32.944
>
    -4.759    32.867
    -5.122    32.944
>
    -4.614    32.817
    -5.122    32.944
>
    -4.614    32.817
    -5.122    32.944
>
    -5.317    34.104
    -5.771    33.559
>
    -4.858    33.686
    -5.771    33.559
>
    -5.043    33.033
    -5.771    33.559
>
    -5.043    33.033
    -5.771    33.559
>
    -5.317    34.104
    -5.727    34.357
>
    -5.340    35.107
    -5.727    34.357
>
    -5.127    33.517
    -5.807    33.795
>
    -5.127    33.517
    -5.807    33.795
>
    -5.043    33.033
    -5.807    33.795
>
    -5.043    33.033
    -5.807    33.795
>
    -5.127    33.517
    -5.737    33.364
>
    -5.043    33.033
    -5.737    33.364
>
    -5.043    33.033
    -5.737    33.364
>
    -3.863    34.510
    -3.493    34.376
>
    -3.863    34.510
    -3.493    34.376
>
    -3.939    35.217
    -3.493    34.376
>
    -2.414    34.814
    -3.493    34.376
>
    -2.414    34.814
    -3.493    34.376
>
    -4.759    32.867
    -4.801    32.596
>
    -4.759    32.867
    -4.801    32.596
>
    -4.952    31.704
    -4.801    32.596
>
    -4.952    31.704
    -4.801    32.596
>
    -5.127    33.517
    -5.808    33.760
>
    -5.127    33.517
    -5.808    33.760
>
    -6.642    33.446
    -6.691    33.109
>
    -6.642    33.446
    -6.691    33.109
>
    -5.317    34.104
    -5.769    33.656
>
    -5.317    34.104
    -5.769    33.656
>
    -6.642    33.446
    -5.769    33.656
>
    -4.858    33.686
    -5.769    33.656
>
    -4.858    33.686
    -5.769    33.656
>
    -4.759    32.867
    -5.236    32.959
>
    -4.759    32.867
    -5.236    32.959
>
    -4.614    32.817
    -5.236    32.959
>
    -4.614    32.817
    -5.236    32.959
>
    -4.858    33.686
    -5.236    32.959
>
    -4.952    31.704
    -5.836    32.167
>
    -4.858    33.686
    -4.453    33.599
>
    -4.858    33.686
    -4.453    33.599
>
    -5.317    34.104
    -4.453    33.599
>
    -5.043    33.033
    -4.453    33.599
>
    -4.759    32.867
    -4.453    33.599
>
    -4.614    32.817
    -4.453    33.599
>
    -5.317    34.104
    -4.886    34.044
>
    -5.317    34.104
    -4.886    34.044
>
    -3.863    34.510
    -4.886    34.044
>
    -3.863    34.510
    -4.886    34.044
>
    -5.127    33.517
    -4.109    33.729
>
    -5.127    33.517
    -4.109    33.729
>
    -5.317    34.104
    -4.974    34.110
>
    -5.317    34.104
    -4.974    34.110
>
    -4.858    33.686
    -4.974    34.110
>
    -4.858    33.686
    -4.974    34.110
>
    -5.127    33.517
    -4.974    34.110
>
    -5.127    33.517
    -4.974    34.110
>
    -4.952    31.704
    -5.112    31.827
>
    -4.952    31.704
    -5.112    31.827
>
    -4.219    31.433
    -5.112    31.827
>
    -4.219    31.433
    -5.112    31.827
>
    -5.043    33.033
    -4.860    33.386
>
    -5.043    33.033
    -4.860    33.386
>
    -4.759    32.867
    -4.860    33.386
>
    -4.759    32.867
    -4.860    33.386
>
    -4.614    32.817
    -4.860    33.386
>
    -4.614    32.817
    -4.860    33.386
>
    -5.127    33.517
    -5.004    33.525
>
    -5.127    33.517
    -5.004    33.525
>
    -5.043    33.033
    -5.004    33.525
>
    -5.043    33.033
    -5.004    33.525
>
    -4.759    32.867
    -5.004    33.525
>
    -4.614    32.817
    -5.004    33.525
>
    -4.219    31.433
    -3.625    32.226
>
    -4.219    31.433
    -3.625    32.226
>
    -5.127    33.517
    -5.013    33.530
>
    -5.127    33.517
    -5.013    33.530
>
    -4.858    33.686
    -5.013    33.530
>
    -4.858    33.686
    -5.013    33.530
>
    -5.043    33.033
    -5.013    33.530
>
    -5.317    34.104
    -5.013    33.530
>
    -4.858    33.686
    -4.915    33.469
>
    -5.043    33.033
    -4.915    33.469
>
    -5.043    33.033
    -4.915    33.469
>
    -4.759    32.867
    -4.915    33.469
>
    -4.759    32.867
    -4.915    33.469
>
    -5.317    34.104
    -4.915    33.469
>
    -5.317    34.104
    -4.915    33.469
>
    -5.043    33.033
    -4.936    33.500
>
    -5.043    33.033
    -4.936    33.500
>
    -4.759    32.867
    -4.936    33.500
>
    -5.127    33.517
    -4.932    33.520
>
    -5.043    33.033
    -4.932    33.520
>
    -5.043    33.033
    -4.932    33.520
>
    -5.317    34.104
    -4.932    33.520
>
    -5.317    34.104
    -4.932    33.520
>
    -4.759    32.867
    -4.932    33.520
>
    -4.614    32.817
    -4.932    33.520
>
    -4.614    32.817
    -4.932    33.520
>
    -5.127    33.517
    -4.860    33.555
>
    -5.043    33.033
    -4.860    33.555
>
    -5.317    34.104
    -4.860    33.555
>
    -5.317    34.104
    -4.860    33.555
>
    -4.759    32.867
    -4.860    33.555
>
    -4.614    32.817
    -4.860    33.555
>
    -5.043    33.033
    -5.578    32.400
>
    -4.759    32.867
    -5.578    32.400
>
    -4.759    32.867
    -5.578    32.400
>
    -4.952    31.704
    -5.578    32.400
>
    -4.952    31.704
    -5.578    32.400
>
    -5.043    33.033
    -5.609    32.386
>
    -5.043    33.033
    -5.609    32.386
>
    -4.952    31.704
    -5.609    32.386
>
    -4.759    32.867
    -5.609    32.386
>
    -4.759    32.867
    -5.609    32.386
>
    -4.614    32.817
    -5.609    32.386
>
    -4.614    32.817
    -5.609    32.386
>
    -4.614    32.817
    -4.754    32.530
>
    -4.759    32.867
    -4.754    32.530
>
    -4.759    32.867
    -4.754    32.530
>
    -5.043    33.033
    -4.754    32.530
>
    -5.043    33.033
    -4.754    32.530
>
    -4.952    31.704
    -4.754    32.530
>
    -4.952    31.704
    -4.754    32.530
>
    -5.127    33.517
    -4.701    33.505
>
    -5.127    33.517
    -4.701    33.505
>
    -5.043    33.033
    -4.701    33.505
>
    -5.043    33.033
    -4.701    33.505
>
    -4.759    32.867
    -4.701    33.505
>
    -4.759    32.867
    -4.701    33.505
>
    -5.317    34.104
    -4.701    33.505
>
    -5.043    33.033
    -5.087    33.154
>
    -5.043    33.033
    -5.087    33.154
>
    -4.759    32.867
    -5.087    33.154
>
    -4.759    32.867
    -5.087    33.154
>
    -4.614    32.817
    -5.087    33.154
>
    -4.614    32.817
    -5.087    33.154
>
    -4.858    33.686
    -5.087    33.154
>
    -4.858    33.686
    -5.087    33.154
>
    -5.317    34.104
    -5.087    33.154
>
    -5.317    34.104
    -5.087    33.154
>
    -5.317    34.104
    -5.833    34.008
>
    -5.828    34.877
    -5.833    34.008
>
    -5.828    34.877
    -5.833    34.008
>
    -6.857    33.988
    -5.833    34.008
>
    -6.857    33.988
    -5.833    34.008
>
    -5.127    33.517
    -5.833    34.008
>
    -4.858    33.686
    -4.469    33.439
>
    -5.043    33.033
    -4.469    33.439
>
    -4.759    32.867
    -4.469    33.439
>
    -4.759    32.867
    -4.469    33.439
>
    -4.614    32.817
    -4.469    33.439
>
    -5.317    34.104
    -4.469    33.439
>
    -5.317    34.104
    -4.469    33.439
>
    -5.127    33.517
    -4.593    33.455
>
    -5.127    33.517
    -4.593    33.455
>
    -5.043    33.033
    -4.593    33.455
>
    -4.759    32.867
    -4.593    33.455
>
    -4.759    32.867
    -4.593    33.455
>
    -4.614    32.817
    -4.593    33.455
>
    -4.614    32.817
    -4.593    33.455
>
    -5.317    34.104
    -4.593    33.455
>
    -5.317    34.104
    -4.593    33.455
>
    -5.127    33.517
    -4.933    33.485
>
    -4.858    33.686
    -4.933    33.485
>
    -5.043    33.033
    -4.933    33.485
>
    -5.043    33.033
    -4.933    33.485
>
    -4.759    32.867
    -4.933    33.485
>
    -4.759    32.867
    -4.933    33.485
>
    -5.317    34.104
    -4.933    33.485
>
    -5.317    34.104
    -4.933    33.485
>
    -6.642    33.446
    -5.943    33.686
>
    -6.642    33.446
    -5.943    33.686
>
    -5.127    33.517
    -5.943    33.686
>
    -6.857    33.988
    -5.943    33.686
>
    -6.857    33.988
    -5.943    33.686
>
    -5.043    33.033
    -5.943    33.686
>
    -5.043    33.033
    -5.943    33.686
>
    -5.317    34.104
    -4.773    34.368
>
    -5.127    33.517
    -4.773    34.368
>
    -5.127    33.517
    -4.773    34.368
>
    -4.301    35.173
    -4.773    34.368
>
    -4.301    35.173
    -4.773    34.368
>
    -3.939    35.217
    -3.801    34.312
>
    -3.939    35.217
    -3.801    34.312
>
    -4.301    35.173
    -3.801    34.312
>
    -5.127    33.517
    -4.941    33.534
>
    -5.127    33.517
    -4.941    33.534
>
    -5.043    33.033
    -4.941    33.534
>
    -5.043    33.033
    -4.941    33.534
>
    -4.759    32.867
    -4.941    33.534
>
    -4.614    32.817
    -4.941    33.534
>
    -5.127    33.517
    -4.700    34.316
>
    -5.127    33.517
    -4.700    34.316
>
    -4.301    35.173
    -4.700    34.316
>
    -4.301    35.173
    -4.700    34.316
>
    -5.317    34.104
    -4.812    34.367
>
    -5.317    34.104
    -4.812    34.367
>
    -4.858    33.686
    -4.812    34.367
>
    -4.858    33.686
    -4.812    34.367
>
    -5.127    33.517
    -4.812    34.367
>
    -5.127    33.517
    -4.812    34.367
>
    -4.301    35.173
    -4.812    34.367
>
    -4.301    35.173
    -4.812    34.367
>
    -5.127    33.517
    -4.905    33.520
>
    -4.858    33.686
    -4.905    33.520
>
    -4.858    33.686
    -4.905    33.520
>
    -5.317    34.104
    -4.905    33.520
>
    -5.317    34.104
    -4.905    33.520
>
    -4.759    32.867
    -4.905    33.520
>
    -4.614    32.817
    -4.905    33.520
>
    -4.759    32.867
    -4.960    33.477
>
    -4.759    32.867
    -4.960    33.477
>
    -4.614    32.817
    -4.960    33.477
>
    -4.614    32.817
    -4.960    33.477
>
    -4.614    32.817
    -3.948    33.392
>
    -4.614    32.817
    -3.948    33.392
>
    -4.759    32.867
    -3.948    33.392
>
    -4.759    32.867
    -3.948    33.392
>
    -5.127    33.517
    -3.948    33.392
>
    -5.127    33.517
    -3.948    33.392
>
    -4.952    31.704
    -5.808    32.094
>
    -4.952    31.704
    -5.808    32.094
>
    -5.317    34.104
    -5.592    34.000
>
    -5.317    34.104
    -5.592    34.000
>
    -4.858    33.686
    -5.592    34.000
>
    -4.858    33.686
    -5.592    34.000
>
    -5.828    34.877
    -5.592    34.000
>
    -5.127    33.517
    -4.971    33.474
>
    -5.127    33.517
    -4.971    33.474
>
    -4.614    32.817
    -4.971    33.474
>
    -5.127    33.517
    -5.250    33.039
>
    -5.127    33.517
    -5.250    33.039
>
    -4.614    32.817
    -5.250    33.039
>
    -4.614    32.817
    -5.250    33.039
>
    -4.614    32.817
    -5.250    33.039
>
    -5.043    33.033
    -5.673    32.431
>
    -5.043    33.033
    -5.673    32.431
>
    -4.759    32.867
    -5.673    32.431
>
    -4.759    32.867
    -5.673    32.431
>
    -4.614    32.817
    -5.673    32.431
>
    -4.614    32.817
    -5.673    32.431
>
    -5.127    33.517
    -5.878    33.730
>
    -5.127    33.517
    -5.878    33.730
>
    -4.858    33.686
    -5.878    33.730
>
    -5.043    33.033
    -5.878    33.730
>
    -5.043    33.033
    -5.878    33.730
>
    -5.127    33.517
    -5.951    33.751
>
    -5.127    33.517
    -5.951    33.751
>
    -4.858    33.686
    -5.951    33.751
>
    -4.858    33.686
    -5.951    33.751
>
    -3.863    34.510
    -3.506    34.042
>
    -3.863    34.510
    -3.506    34.042
>
    -2.567    34.335
    -3.506    34.042
>
    -2.567    34.335
    -3.506    34.042
>
    -5.043    33.033
    -5.447    32.792
>
    -5.043    33.033
    -5.447    32.792
>
    -5.127    33.517
    -5.447    32.792
>
    -5.127    33.517
    -5.447    32.792
>
    -4.759    32.867
    -5.447    32.792
>
    -4.759    32.867
    -5.447    32.792
>
    -4.614    32.817
    -5.447    32.792
>
    -4.614    32.817
    -5.447    32.792
>
    -4.614    32.817
    -5.447    32.792
>
    -6.642    33.446
    -5.902    33.787
>
    -6.642    33.446
    -5.902    33.787
>
    -5.127    33.517
    -5.902    33.787
>
    -5.127    33.517
    -5.902    33.787
>
    -4.858    33.686
    -5.902    33.787
>
    -4.858    33.686
    -5.902    33.787
>
    -5.127    33.517
    -5.801    33.749
>
    -5.127    33.517
    -5.801    33.749
>
    -4.858    33.686
    -5.801    33.749
>
    -5.043    33.033
    -5.801    33.749
>
    -5.043    33.033
    -5.801    33.749
>
    -6.642    33.446
    -6.107    33.411
>
    -6.642    33.446
    -6.107    33.411
>
    -5.317    34.104
    -6.107    33.411
>
    -5.317    34.104
    -6.107    33.411
>
    -4.759    32.867
    -5.407    32.470
>
    -4.759    32.867
    -5.407    32.470
>
    -4.614    32.817
    -5.407    32.470
>
    -4.614    32.817
    -5.407    32.470
>
    -4.952    31.704
    -5.407    32.470
>
    -4.952    31.704
    -5.407    32.470
>
    -5.043    33.033
    -5.607    32.729
>
    -5.043    33.033
    -5.607    32.729
>
    -4.759    32.867
    -5.607    32.729
>
    -4.759    32.867
    -5.607    32.729
>
    -4.614    32.817
    -5.607    32.729
>
    -4.614    32.817
    -5.607    32.729
>
    -5.828    34.877
    -5.517    34.425
>
    -5.828    34.877
    -5.517    34.425
>
    -5.340    35.107
    -5.517    34.425
>
    -5.340    35.107
    -5.517    34.425
>
    -4.858    33.686
    -5.517    34.425
>
    -4.858    33.686
    -5.517    34.425
>
    -5.043    33.033
    -5.632    32.323
>
    -5.043    33.033
    -5.632    32.323
>
    -4.759    32.867
    -5.632    32.323
>
    -4.759    32.867
    -5.632    32.323
>
    -4.614    32.817
    -5.632    32.323
>
    -4.614    32.817
    -5.632    32.323
>
    -4.858    33.686
    -4.654    34.232
>
    -4.858    33.686
    -4.654    34.232
>
    -5.127    33.517
    -4.654    34.232
>
    -5.127    33.517
    -4.654    34.232
>
    -5.043    33.033
    -5.651    32.336
>
    -4.759    32.867
    -5.651    32.336
>
    -4.759    32.867
    -5.651    32.336
>
    -4.614    32.817
    -5.651    32.336
>
    -4.614    32.817
    -5.651    32.336
>
    -5.043    33.033
    -5.824    32.355
>
    -5.043    33.033
    -5.824    32.355
>
    -4.952    31.704
    -5.698    32.139
>
    -4.952    31.704
    -5.698    32.139
>
    -4.952    31.704
    -5.698    32.139
>
    -4.952    31.704
    -5.698    32.139
>
    -4.759    32.867
    -5.712    32.800
>
    -4.759    32.867
    -5.712    32.800
>
    -4.614    32.817
    -5.712    32.800
>
    -4.614    32.817
    -5.712    32.800
>
    -4.614    32.817
    -5.712    32.800
>
    -5.127    33.517
    -4.917    33.531
>
    -5.127    33.517
    -4.917    33.531
>
    -4.759    32.867
    -4.917    33.531
>
    -4.759    32.867
    -4.917    33.531
>
    -4.614    32.817
    -4.917    33.531
>
    -4.614    32.817
    -4.917    33.531
>
    -4.614    32.817
    -4.663    32.628
>
    -4.614    32.817
    -4.663    32.628
>
    -4.759    32.867
    -4.663    32.628
>
    -4.952    31.704
    -4.663    32.628
>
    -4.952    31.704
    -4.663    32.628
>
    -4.952    31.704
    -5.917    32.165
>
    -4.952    31.704
    -5.917    32.165
>
    -4.952    31.704
    -5.917    32.165
>
    -6.642    33.446
    -6.527    33.230
>
    -6.642    33.446
    -6.527    33.230
>
    -7.413    33.298
    -6.527    33.230
>
    -7.413    33.298
    -6.527    33.230
>
    -7.413    33.298
    -6.527    33.230
>
    -7.413    33.298
    -6.527    33.230
>
    -6.857    33.988
    -6.527    33.230
>
    -6.857    33.988
    -6.527    33.230
>
    -6.642    33.446
    -6.114    33.308
>
    -6.642    33.446
    -6.114    33.308
>
    -5.127    33.517
    -6.114    33.308
>
    -5.127    33.517
    -6.114    33.308
>
    -5.127    33.517
    -6.073    33.190
>
    -5.127    33.517
    -6.073    33.190
>
    -4.858    33.686
    -4.232    33.519
>
    -4.858    33.686
    -4.232    33.519
>
    -5.127    33.517
    -4.232    33.519
>
    -5.127    33.517
    -4.232    33.519
>
    -4.759    32.867
    -4.232    33.519
>
    -4.614    32.817
    -4.232    33.519
>
    -6.760    30.909
    -6.501    31.777
>
    -6.760    30.909
    -6.501    31.777
>
    -5.317    34.104
    -5.752    33.763
>
    -5.127    33.517
    -5.752    33.763
>
    -5.127    33.517
    -5.752    33.763
>
    -4.858    33.686
    -5.752    33.763
>
    -4.858    33.686
    -5.752    33.763
>
    -5.043    33.033
    -5.752    33.763
>
    -4.858    33.686
    -4.222    33.525
>
    -4.858    33.686
    -4.222    33.525
>
    -5.127    33.517
    -4.222    33.525
>
    -5.127    33.517
    -4.222    33.525
>
    -4.759    32.867
    -4.222    33.525
>
    -5.043    33.033
    -4.222    33.525
>
    -5.043    33.033
    -4.222    33.525
>
    -6.642    33.446
    -5.886    33.705
>
    -6.642    33.446
    -5.886    33.705
>
    -5.317    34.104
    -5.886    33.705
>
    -5.317    34.104
    -5.886    33.705
>
    -4.858    33.686
    -5.886    33.705
>
    -4.858    33.686
    -5.886    33.705
>
    -5.043    33.033
    -5.886    33.705
>
    -5.043    33.033
    -5.886    33.705
>
    -6.760    30.909
    -6.775    31.234
>
    -6.760    30.909
    -6.775    31.234
>
    -7.868    31.209
    -6.775    31.234
>
    -7.868    31.209
    -6.775    31.234
>
    -6.642    33.446
    -6.424    33.313
>
    -6.642    33.446
    -6.424    33.313
>
    -7.413    33.298
    -6.424    33.313
>
    -7.413    33.298
    -6.424    33.313
>
    -6.642    33.446
    -6.373    33.307
>
    -6.642    33.446
    -6.373    33.307
>
    -7.413    33.298
    -6.373    33.307
>
    -7.413    33.298
    -6.373    33.307
>
    -7.413    33.298
    -6.373    33.307
>
    -7.413    33.298
    -6.373    33.307
>
    -4.759    32.867
    -5.479    32.471
>
    -4.759    32.867
    -5.479    32.471
>
    -4.614    32.817
    -5.479    32.471
>
    -4.614    32.817
    -5.479    32.471
>
    -5.127    33.517
    -5.080    33.004
>
    -5.127    33.517
    -5.080    33.004
>
    -4.614    32.817
    -5.080    33.004
>
    -4.858    33.686
    -5.080    33.004
>
    -4.858    33.686
    -5.080    33.004
>
    -4.614    32.817
    -4.825    32.353
>
    -4.614    32.817
    -4.825    32.353
>
    -4.759    32.867
    -4.825    32.353
>
    -4.759    32.867
    -4.825    32.353
>
    -5.317    34.104
    -5.486    34.043
>
    -5.127    33.517
    -5.486    34.043
>
    -5.127    33.517
    -5.486    34.043
>
    -4.858    33.686
    -5.486    34.043
>
    -5.828    34.877
    -5.486    34.043
>
    -5.828    34.877
    -5.486    34.043
>
    -5.317    34.104
    -5.983    33.598
>
    -5.317    34.104
    -5.983    33.598
>
    -5.127    33.517
    -5.983    33.598
>
    -5.127    33.517
    -5.983    33.598
>
    -6.857    33.988
    -5.983    33.598
>
    -6.857    33.988
    -5.983    33.598
>
    -4.858    33.686
    -5.983    33.598
>
    -4.858    33.686
    -5.983    33.598
>
    -3.863    34.510
    -4.398    34.361
>
    -4.858    33.686
    -4.398    34.361
>
    -5.317    34.104
    -4.398    34.361
>
    -5.317    34.104
    -4.398    34.361
>
    -3.939    35.217
    -4.398    34.361
>
    -3.939    35.217
    -4.398    34.361
>
    -3.863    34.510
    -3.880    33.764
>
    -4.759    32.867
    -5.177    32.977
>
    -4.759    32.867
    -5.177    32.977
>
    -5.127    33.517
    -5.177    32.977
>
    -5.317    34.104
    -5.064    34.136
>
    -5.317    34.104
    -5.064    34.136
>
    -4.858    33.686
    -5.064    34.136
>
    -5.828    34.877
    -5.064    34.136
>
    -5.828    34.877
    -5.064    34.136
>
    -5.340    35.107
    -5.064    34.136
>
    -5.340    35.107
    -5.064    34.136
>
    -4.614    32.817
    -4.569    32.482
>
    -4.614    32.817
    -4.569    32.482
>
    -4.759    32.867
    -4.569    32.482
>
    -4.759    32.867
    -4.569    32.482
>
    -5.043    33.033
    -4.569    32.482
>
    -5.043    33.033
    -4.569    32.482
>
    -4.952    31.704
    -4.569    32.482
>
    -4.952    31.704
    -4.569    32.482
>
    -6.642    33.446
    -6.103    33.405
>
    -6.642    33.446
    -6.103    33.405
>
    -5.127    33.517
    -6.103    33.405
>
    -5.043    33.033
    -6.103    33.405
>
    -5.317    34.104
    -5.785    34.007
>
    -5.828    34.877
    -5.785    34.007
>
    -5.127    33.517
    -5.785    34.007
>
    -5.127    33.517
    -5.785    34.007
>
    -3.863    34.510
    -4.032    33.803
>
    -4.858    33.686
    -4.032    33.803
>
    -4.858    33.686
    -4.032    33.803
>
    -5.127    33.517
    -4.032    33.803
>
    -5.127    33.517
    -4.032    33.803
>
    -5.043    33.033
    -5.364    32.348
>
    -5.043    33.033
    -5.364    32.348
>
    -4.759    32.867
    -5.364    32.348
>
    -4.759    32.867
    -5.364    32.348
>
    -6.440    31.721
    -6.166    32.383
>
    -6.440    31.721
    -6.166    32.383
>
    -5.127    33.517
    -5.478    34.027
>
    -5.127    33.517
    -5.478    34.027
>
    -5.828    34.877
    -5.478    34.027
>
    -5.828    34.877
    -5.478    34.027
>
    -5.127    33.517
    -5.767    33.990
>
    -5.127    33.517
    -5.767    33.990
>
    -4.858    33.686
    -5.767    33.990
>
    -4.858    33.686
    -5.767    33.990
>
    -6.857    33.988
    -5.887    33.736
>
    -6.857    33.988
    -5.887    33.736
>
    -4.858    33.686
    -5.887    33.736
>
    -5.043    33.033
    -5.887    33.736
>
    -5.043    33.033
    -5.887    33.736
>
    -6.642    33.446
    -6.338    33.234
>
    -6.642    33.446
    -6.338    33.234
>
    -6.642    33.446
    -6.282    33.333
>
    -6.642    33.446
    -6.282    33.333
>
    -5.127    33.517
    -6.282    33.333
>
    -5.127    33.517
    -6.282    33.333
>
    -7.413    33.298
    -6.349    33.291
>
    -4.759    32.867
    -5.320    32.798
>
    -4.759    32.867
    -5.320    32.798
>
    -4.614    32.817
    -5.320    32.798
>
    -4.614    32.817
    -5.320    32.798
>
    -5.127    33.517
    -5.320    32.798
>
    -5.127    33.517
    -5.320    32.798
>
    -4.858    33.686
    -5.320    32.798
>
    -4.858    33.686
    -5.320    32.798
>
    -6.642    33.446
    -6.321    33.288
>
    -7.413    33.298
    -6.321    33.288
>
    -7.413    33.298
    -6.321    33.288
>
    -6.642    33.446
    -6.371    33.259
>
    -6.642    33.446
    -6.371    33.259
>
    -7.413    33.298
    -6.371    33.259
>
    -4.858    33.686
    -4.716    33.929
>
    -5.317    34.104
    -4.716    33.929
>
    -5.317    34.104
    -4.716    33.929
>
    -3.863    34.510
    -4.716    33.929
>
    -5.043    33.033
    -4.716    33.929
>
    -5.043    33.033
    -4.716    33.929
>
    -6.642    33.446
    -6.527    33.246
>
    -7.413    33.298
    -6.527    33.246
>
    -7.413    33.298
    -6.527    33.246
>
    -6.857    33.988
    -6.527    33.246
>
    -6.857    33.988
    -6.527    33.246
>
    -5.317    34.104
    -5.928    33.698
>
    -5.317    34.104
    -5.928    33.698
>
    -6.642    33.446
    -5.928    33.698
>
    -6.642    33.446
    -5.928    33.698
>
    -4.858    33.686
    -5.928    33.698
>
    -4.858    33.686
    -5.928    33.698
>
    -5.043    33.033
    -5.928    33.698
>
    -5.043    33.033
    -5.928    33.698
>
    -5.043    33.033
    -5.544    32.680
>
    -5.043    33.033
    -5.544    32.680
>
    -5.043    33.033
    -5.544    32.680
>
    -5.043    33.033
    -5.544    32.680
>
    -4.759    32.867
    -5.544    32.680
>
    -4.759    32.867
    -5.544    32.680
>
    -4.614    32.817
    -5.544    32.680
>
    -4.614    32.817
    -5.544    32.680
>
    -4.614    32.817
    -5.544    32.680
>
    -5.043    33.033
    -5.563    32.696
>
    -5.043    33.033
    -5.563    32.696
>
    -5.043    33.033
    -5.563    32.696
>
    -4.759    32.867
    -5.563    32.696
>
    -4.759    32.867
    -5.563    32.696
>
    -4.614    32.817
    -5.563    32.696
>
    -4.614    32.817
    -5.563    32.696
>
    -5.127    33.517
    -5.891    33.691
>
    -5.127    33.517
    -5.891    33.691
>
    -6.857    33.988
    -5.891    33.691
>
    -6.857    33.988
    -5.891    33.691
>
    -6.857    33.988
    -5.891    33.691
>
    -4.858    33.686
    -5.891    33.691
>
    -4.858    33.686
    -5.891    33.691
>
    -5.043    33.033
    -5.537    32.665
>
    -5.043    33.033
    -5.537    32.665
>
    -4.759    32.867
    -5.537    32.665
>
    -4.759    32.867
    -5.537    32.665
>
    -4.614    32.817
    -5.537    32.665
>
    -4.614    32.817
    -5.537    32.665
>
    -5.127    33.517
    -5.537    32.665
>
    -5.127    33.517
    -5.537    32.665
>
    -5.828    34.877
    -5.837    34.297
>
    -5.828    34.877
    -5.837    34.297
>
    -6.857    33.988
    -5.837    34.297
>
    -6.857    33.988
    -5.837    34.297
>
    -6.857    33.988
    -5.837    34.297
>
    -6.857    33.988
    -5.837    34.297
>
    -5.127    33.517
    -5.837    34.297
>
    -5.127    33.517
    -5.837    34.297
>
    -5.828    34.877
    -5.796    34.325
>
    -5.828    34.877
    -5.796    34.325
>
    -6.857    33.988
    -5.796    34.325
>
    -5.127    33.517
    -5.796    34.325
>
    -5.127    33.517
    -5.796    34.325
>
    -4.614    32.817
    -4.207    32.626
>
    -4.614    32.817
    -4.207    32.626
>
    -4.614    32.817
    -4.207    32.626
>
    -4.759    32.867
    -4.207    32.626
>
    -4.759    32.867
    -4.207    32.626
>
    -4.759    32.868
    -4.207    32.626
>
    -5.043    33.033
    -4.207    32.626
>
    -4.614    32.817
    -4.213    32.638
>
    -4.614    32.817
    -4.213    32.638
>
    -4.759    32.867
    -4.213    32.638
>
    -4.759    32.867
    -4.213    32.638
>
    -4.614    32.817
    -4.232    32.639
>
    -4.614    32.817
    -4.232    32.639
>
    -4.759    32.867
    -4.232    32.639
>
    -4.759    32.867
    -4.232    32.639
>
    -4.614    32.817
    -4.310    32.540
>
    -4.614    32.817
    -4.310    32.540
>
    -4.759    32.867
    -4.310    32.540
>
    -4.759    32.868
    -4.310    32.540
>
    -4.759    32.868
    -4.310    32.540
>
    -4.614    32.817
    -4.197    32.660
>
    -4.614    32.817
    -4.197    32.660
>
    -4.614    32.817
    -4.197    32.660
>
    -4.759    32.867
    -4.197    32.660
>
    -4.759    32.867
    -4.197    32.660
>
    -4.614    32.817
    -4.239    32.612
>
    -4.614    32.817
    -4.239    32.612
>
    -4.759    32.867
    -4.239    32.612
>
    -4.759    32.867
    -4.239    32.612
>
    -4.614    32.817
    -4.246    32.616
>
    -4.614    32.817
    -4.246    32.616
>
    -5.043    33.033
    -4.246    32.616
>
    -5.043    33.033
    -4.246    32.616
>
    -3.863    34.510
    -4.343    34.346
>
    -4.858    33.686
    -4.343    34.346
>
    -3.939    35.217
    -4.343    34.346
>
    -3.939    35.217
    -4.343    34.346
>
    -5.317    34.104
    -4.343    34.346
>
    -5.317    34.104
    -4.343    34.346
>
    -6.857    33.988
    -6.627    33.870
>
    -6.857    33.988
    -6.627    33.870
>
    -6.857    33.988
    -6.536    33.980
>
    -6.857    33.988
    -6.536    33.980
>
    -7.413    33.298
    -6.536    33.980
>
    -7.413    33.298
    -6.536    33.980
>
    -4.759    32.867
    -5.527    32.636
>
    -4.759    32.867
    -5.527    32.636
>
    -4.614    32.817
    -5.527    32.636
>
    -4.614    32.817
    -5.527    32.636
>
    -4.759    32.867
    -5.291    32.954
>
    -4.759    32.867
    -5.291    32.954
>
    -5.127    33.517
    -5.291    32.954
>
    -5.127    33.517
    -5.291    32.954
>
    -4.614    32.817
    -5.291    32.954
>
    -4.614    32.817
    -5.291    32.954
>
    -4.858    33.686
    -5.291    32.954
>
    -4.858    33.686
    -5.291    32.954
>
    -4.858    33.686
    -5.291    32.954
>
    -4.614    32.817
    -4.232    32.642
>
    -4.614    32.817
    -4.232    32.642
>
    -4.614    32.817
    -4.232    32.642
>
    -4.759    32.867
    -4.232    32.642
>
    -4.759    32.867
    -4.232    32.642
>
    -4.759    32.868
    -4.232    32.642
>
    -4.759    32.868
    -4.232    32.642
>
    -5.043    33.033
    -4.232    32.642
>
    -4.614    32.817
    -4.310    32.588
>
    -4.614    32.817
    -4.310    32.588
>
    -4.614    32.817
    -4.310    32.588
>
    -4.759    32.867
    -4.310    32.588
>
    -4.759    32.867
    -4.310    32.588
>
    -5.043    33.033
    -4.310    32.588
>
    -5.043    33.033
    -4.310    32.588
>
    -4.614    32.817
    -4.352    32.592
>
    -4.614    32.817
    -4.352    32.592
>
    -4.759    32.867
    -4.352    32.592
>
    -4.759    32.867
    -4.352    32.592
>
    -5.317    34.104
    -5.715    34.266
>
    -5.317    34.104
    -5.715    34.266
>
    -5.828    34.877
    -5.715    34.266
>
    -5.828    34.877
    -5.715    34.266
>
    -5.340    35.107
    -5.715    34.266
>
    -5.340    35.107
    -5.715    34.266
>
    -5.127    33.517
    -5.715    34.266
>
    -5.127    33.517
    -5.715    34.266
>
    -4.858    33.686
    -5.715    34.266
>
    -4.759    32.867
    -5.382    32.395
>
    -4.759    32.867
    -5.382    32.395
>
    -4.952    31.704
    -5.382    32.395
>
    -4.952    31.704
    -5.382    32.395
>
    -4.614    32.817
    -5.382    32.395
>
    -4.614    32.817
    -5.382    32.395
>
    -5.317    34.104
    -5.726    34.274
>
    -5.317    34.104
    -5.726    34.274
>
    -5.828    34.877
    -5.726    34.274
>
    -5.828    34.877
    -5.726    34.274
>
    -5.340    35.107
    -5.726    34.274
>
    -5.340    35.107
    -5.726    34.274
>
    -4.858    33.686
    -5.726    34.274
>
    -4.858    33.686
    -4.926    33.549
>
    -4.858    33.686
    -4.926    33.549
>
    -5.127    33.517
    -4.926    33.549
>
    -5.317    34.104
    -4.926    33.549
>
    -5.317    34.104
    -4.926    33.549
>
    -4.759    32.867
    -4.926    33.549
>
    -4.614    32.817
    -4.926    33.549
>
    -5.317    34.104
    -5.768    34.232
>
    -5.317    34.104
    -5.768    34.232
>
    -5.828    34.877
    -5.768    34.232
>
    -5.828    34.877
    -5.768    34.232
>
    -5.340    35.107
    -5.768    34.232
>
    -5.340    35.107
    -5.768    34.232
>
    -6.857    33.988
    -5.768    34.232
>
    -5.127    33.517
    -5.768    34.232
>
    -5.127    33.517
    -5.768    34.232
>
    -4.858    33.686
    -5.768    34.232
>
    -5.317    34.104
    -5.565    34.282
>
    -5.317    34.104
    -5.565    34.282
>
    -5.828    34.877
    -5.565    34.282
>
    -5.828    34.877
    -5.565    34.282
>
    -4.858    33.686
    -5.565    34.282
>
    -5.127    33.517
    -5.565    34.282
>
    -5.127    33.517
    -5.565    34.282
>
    -5.317    34.104
    -5.766    34.291
>
    -5.317    34.104
    -5.766    34.291
>
    -5.828    34.877
    -5.766    34.291
>
    -5.828    34.877
    -5.766    34.291
>
    -5.340    35.107
    -5.766    34.291
>
    -5.340    35.107
    -5.766    34.291
>
    -6.857    33.988
    -5.766    34.291
>
    -6.857    33.988
    -5.766    34.291
>
    -6.857    33.988
    -5.766    34.291
>
    -5.127    33.517
    -5.766    34.291
>
    -5.127    33.517
    -5.766    34.291
>
    -4.858    33.686
    -5.766    34.291
>
    -4.858    33.686
    -5.766    34.291
>
    -4.858    33.686
    -5.766    34.291
>
    -5.043    33.033
    -5.472    32.400
>
    -5.043    33.033
    -5.472    32.400
>
    -4.759    32.867
    -5.472    32.400
>
    -4.759    32.867
    -5.472    32.400
>
    -4.614    32.817
    -5.472    32.400
>
    -4.614    32.817
    -5.472    32.400
>
    -4.952    31.704
    -5.472    32.400
>
    -4.952    31.704
    -5.472    32.400
>
    -5.317    34.104
    -5.585    34.315
>
    -5.317    34.104
    -5.585    34.315
>
    -5.828    34.877
    -5.585    34.315
>
    -4.858    33.686
    -5.585    34.315
>
    -4.858    33.686
    -5.585    34.315
>
    -5.127    33.517
    -5.585    34.315
>
    -6.642    33.446
    -5.963    33.731
>
    -6.642    33.446
    -5.963    33.731
>
    -5.317    34.104
    -5.963    33.731
>
    -5.317    34.104
    -5.963    33.731
>
    -6.857    33.988
    -5.963    33.731
>
    -6.857    33.988
    -5.963    33.731
>
    -6.857    33.988
    -5.963    33.731
>
    -5.127    33.517
    -5.963    33.731
>
    -5.127    33.517
    -5.963    33.731
>
    -4.858    33.686
    -5.963    33.731
>
    -4.858    33.686
    -5.963    33.731
>
    -4.858    33.686
    -4.117    33.499
>
    -4.858    33.686
    -4.117    33.499
>
    -4.614    32.817
    -4.117    33.499
>
    -4.759    32.867
    -4.117    33.499
>
    -5.043    33.033
    -4.117    33.499
>
    -5.043    33.033
    -4.117    33.499
>
    -5.317    34.104
    -4.969    34.310
>
    -5.317    34.104
    -4.969    34.310
>
    -5.340    35.107
    -4.969    34.310
>
    -5.340    35.107
    -4.969    34.310
>
    -5.828    34.877
    -4.969    34.310
>
    -5.828    34.877
    -4.969    34.310
>
    -5.127    33.517
    -4.969    34.310
>
    -3.863    34.510
    -4.969    34.310
>
    -3.863    34.510
    -4.969    34.310
>
    -5.317    34.104
    -4.936    34.332
>
    -5.317    34.104
    -4.936    34.332
>
    -4.858    33.686
    -4.936    34.332
>
    -5.340    35.107
    -4.936    34.332
>
    -5.340    35.107
    -4.936    34.332
>
    -5.127    33.517
    -4.936    34.332
>
    -5.828    34.877
    -4.936    34.332
>
    -5.317    34.104
    -4.933    34.313
>
    -5.317    34.104
    -4.933    34.313
>
    -5.340    35.107
    -4.933    34.313
>
    -5.340    35.107
    -4.933    34.313
>
    -5.828    34.877
    -4.933    34.313
>
    -5.828    34.877
    -4.933    34.313
>
    -3.863    34.510
    -4.933    34.313
>
    -3.863    34.510
    -4.933    34.313
>
    -5.317    34.104
    -4.932    34.308
>
    -5.317    34.104
    -4.932    34.308
>
    -5.340    35.107
    -4.932    34.308
>
    -5.340    35.107
    -4.932    34.308
>
    -5.127    33.517
    -4.932    34.308
>
    -5.127    33.517
    -4.932    34.308
>
    -3.863    34.510
    -4.932    34.308
>
    -4.614    32.817
    -4.631    32.574
>
    -4.759    32.867
    -4.631    32.574
>
    -4.759    32.867
    -4.631    32.574
>
    -5.043    33.033
    -4.631    32.574
>
    -5.043    33.033
    -4.631    32.574
>
    -4.952    31.704
    -4.631    32.574
>
    -5.317    34.104
    -4.918    34.316
>
    -5.317    34.104
    -4.918    34.316
>
    -4.858    33.686
    -4.918    34.316
>
    -5.340    35.107
    -4.918    34.316
>
    -5.340    35.107
    -4.918    34.316
>
    -5.828    34.877
    -4.918    34.316
>
    -5.828    34.877
    -4.918    34.316
>
    -3.863    34.510
    -4.918    34.316
>
    -3.863    34.510
    -4.918    34.316
>
    -5.317    34.104
    -5.761    34.266
>
    -5.317    34.104
    -5.761    34.266
>
    -5.340    35.107
    -5.761    34.266
>
    -5.340    35.107
    -5.761    34.266
>
    -6.857    33.988
    -5.761    34.266
>
    -6.857    33.988
    -5.761    34.266
>
    -6.857    33.988
    -5.761    34.266
>
    -5.127    33.517
    -5.761    34.266
>
    -5.127    33.517
    -5.761    34.266
>
    -4.858    33.686
    -5.761    34.266
>
    -4.858    33.686
    -5.761    34.266
>
    -5.317    34.104
    -5.783    34.264
>
    -5.317    34.104
    -5.783    34.264
>
    -4.858    33.686
    -5.783    34.264
>
    -4.858    33.686
    -5.783    34.264
>
    -6.642    33.446
    -6.175    33.212
>
    -6.642    33.446
    -6.175    33.212
>
    -5.043    33.033
    -6.175    33.212
>
    -5.043    33.033
    -6.175    33.212
>
    -6.440    31.721
    -5.732    31.930
>
    -6.440    31.721
    -5.732    31.930
>
    -4.952    31.704
    -5.732    31.930
>
    -4.952    31.704
    -5.732    31.930
>
    -3.863    34.510
    -3.740    33.667
>
    -3.863    34.510
    -3.740    33.667
>
    -4.858    33.686
    -3.740    33.667
>
    -4.858    33.686
    -3.740    33.667
>
    -4.858    33.686
    -4.700    33.470
>
    -4.858    33.686
    -4.700    33.470
>
    -5.127    33.517
    -4.700    33.470
>
    -5.127    33.517
    -4.700    33.470
>
    -4.759    32.867
    -4.700    33.470
>
    -4.614    32.817
    -4.700    33.470
>
    -4.614    32.817
    -4.700    33.470
>
    -5.317    34.104
    -4.700    33.470
>
    -5.317    34.104
    -4.700    33.470
>
    -5.317    34.104
    -5.617    34.229
>
    -5.317    34.104
    -5.617    34.229
>
    -5.340    35.107
    -5.617    34.229
>
    -5.340    35.107
    -5.617    34.229
>
    -5.127    33.517
    -5.617    34.229
>
    -4.858    33.686
    -5.617    34.229
>
    -3.863    34.510
    -3.646    34.112
>
    -3.863    34.510
    -3.646    34.112
>
    -6.440    31.721
    -6.517    31.766
>
    -6.760    30.909
    -6.517    31.766
>
    -4.759    32.867
    -5.355    33.029
>
    -4.759    32.867
    -5.355    33.029
>
    -4.614    32.817
    -5.355    33.029
>
    -4.614    32.817
    -5.355    33.029
>
    -4.759    32.867
    -5.358    32.778
>
    -4.759    32.867
    -5.358    32.778
>
    -4.614    32.817
    -5.358    32.778
>
    -4.614    32.817
    -5.358    32.778
>
    -5.127    33.517
    -6.054    33.332
>
    -5.127    33.517
    -6.054    33.332
>
    -6.760    30.909
    -6.492    31.493
>
    -6.760    30.909
    -6.492    31.493
>
    -7.262    30.927
    -6.492    31.493
>
    -7.262    30.927
    -6.492    31.493
>
    -5.043    33.033
    -5.334    32.900
>
    -5.043    33.033
    -5.334    32.900
>
    -4.759    32.867
    -5.334    32.900
>
    -4.759    32.867
    -5.334    32.900
>
    -4.614    32.817
    -5.334    32.900
>
    -4.614    32.817
    -5.334    32.900
>
    -4.858    33.686
    -5.334    32.900
>
    -4.858    33.686
    -5.334    32.900
>
    -6.642    33.446
    -6.008    33.675
>
    -6.642    33.446
    -6.008    33.675
>
    -4.858    33.686
    -6.008    33.675
>
    -4.858    33.686
    -6.008    33.675
>
    -4.858    33.686
    -4.928    34.343
>
    -5.340    35.107
    -4.928    34.343
>
    -5.340    35.107
    -4.928    34.343
>
    -5.127    33.517
    -4.928    34.343
>
    -5.127    33.517
    -4.928    34.343
>
    -5.828    34.877
    -4.928    34.343
>
    -5.828    34.877
    -4.928    34.343
>
    -3.863    34.510
    -4.928    34.343
>
    -4.858    33.686
    -5.235    34.034
>
    -4.858    33.686
    -5.235    34.034
>
    -5.127    33.517
    -5.235    34.034
>
    -5.127    33.517
    -5.235    34.034
>
    -5.828    34.877
    -5.235    34.034
>
    -4.858    33.686
    -5.223    34.209
>
    -5.127    33.517
    -5.223    34.209
>
    -5.828    34.877
    -5.223    34.209
>
    -5.828    34.877
    -5.223    34.209
>
    -5.340    35.107
    -5.223    34.209
>
    -5.340    35.107
    -5.223    34.209
>
    -4.952    31.704
    -5.409    32.351
>
    -4.952    31.704
    -5.409    32.351
>
    -4.759    32.867
    -5.409    32.351
>
    -4.614    32.817
    -5.409    32.351
>
    -4.614    32.817
    -5.409    32.351
>
    -6.642    33.446
    -6.094    33.441
>
    -6.642    33.446
    -6.094    33.441
>
    -6.857    33.988
    -6.094    33.441
>
    -5.127    33.517
    -6.094    33.441
>
    -5.127    33.517
    -6.094    33.441
>
    -5.043    33.033
    -6.094    33.441
>
    -5.043    33.033
    -6.094    33.441
>
    -4.858    33.686
    -5.182    34.246
>
    -5.828    34.877
    -5.182    34.246
>
    -5.127    33.517
    -5.781    34.013
>
    -5.127    33.517
    -5.781    34.013
>
    -5.828    34.877
    -5.781    34.013
>
    -6.857    33.988
    -5.781    34.013
>
    -6.857    33.988
    -5.781    34.013
>
    -6.857    33.988
    -5.781    34.013
>
    -6.857    33.988
    -5.781    34.013
>
    -4.858    33.686
    -5.781    34.013
>
    -3.863    34.510
    -3.707    34.048
>
    -3.863    34.510
    -3.707    34.048
>
    -2.567    34.335
    -3.707    34.048
>
    -3.863    34.510
    -3.669    34.037
>
    -3.863    34.510
    -3.669    34.037
>
    -2.567    34.335
    -3.669    34.037
>
    -3.863    34.510
    -3.516    34.044
>
    -3.863    34.510
    -3.516    34.044
>
    -6.642    33.446
    -6.005    33.351
>
    -6.642    33.446
    -6.005    33.351
>
    -5.127    33.517
    -6.005    33.351
>
    -5.127    33.517
    -6.005    33.351
>
    -6.857    33.988
    -6.005    33.351
>
    -5.043    33.033
    -6.005    33.351
>
    -5.043    33.033
    -6.005    33.351
>
    -6.642    33.446
    -6.050    33.472
>
    -6.642    33.446
    -6.050    33.472
>
    -5.043    33.033
    -6.050    33.472
>
    -5.043    33.033
    -6.050    33.472
>
    -4.858    33.686
    -5.218    34.224
>
    -4.952    31.704
    -5.385    32.325
>
    -4.952    31.704
    -5.385    32.325
>
    -4.759    32.867
    -5.385    32.325
>
    -4.759    32.867
    -5.385    32.325
>
    -4.614    32.817
    -5.385    32.325
>
    -4.614    32.817
    -5.385    32.325
>
    -5.127    33.517
    -5.829    33.941
>
    -5.127    33.517
    -5.829    33.941
>
    -6.857    33.988
    -5.829    33.941
>
    -6.857    33.988
    -5.829    33.941
>
    -5.828    34.877
    -5.829    33.941
>
    -5.828    34.877
    -5.829    33.941
>
    -6.642    33.446
    -5.829    33.941
>
    -6.642    33.446
    -5.829    33.941
>
    -4.858    33.686
    -5.829    33.941
>
    -4.858    33.686
    -5.829    33.941
>
    -6.440    31.721
    -6.338    32.139
>
    -6.440    31.721
    -6.338    32.139
>
    -3.863    34.510
    -3.988    33.850
>
    -3.863    34.510
    -3.988    33.850
>
    -4.858    33.686
    -3.988    33.850
>
    -4.858    33.686
    -3.988    33.850
>
    -5.043    33.033
    -5.168    33.188
>
    -5.043    33.033
    -5.168    33.188
>
    -4.858    33.686
    -5.168    33.188
>
    -4.614    32.817
    -5.168    33.188
>
    -4.614    32.817
    -5.168    33.188
>
    -5.317    34.104
    -5.168    33.188
>
    -5.317    34.104
    -5.168    33.188
>
    -5.317    34.104
    -5.164    34.279
>
    -5.317    34.104
    -5.164    34.279
>
    -5.317    34.104
    -5.212    34.224
>
    -4.858    33.686
    -5.212    34.224
>
    -4.858    33.686
    -5.212    34.224
>
    -7.413    33.298
    -6.930    33.048
>
    -7.413    33.298
    -6.930    33.048
>
    -7.898    32.471
    -6.930    33.048
>
    -7.898    32.471
    -6.930    33.048
>
    -5.043    33.033
    -5.732    32.418
>
    -5.043    33.033
    -5.732    32.418
>
    -6.440    31.721
    -5.732    32.418
>
    -4.952    31.704
    -5.732    32.418
>
    -4.952    31.704
    -5.732    32.418
>
    -6.760    30.909
    -6.690    31.351
>
    -6.760    30.909
    -6.690    31.351
>
    -7.262    30.927
    -6.690    31.351
>
    -4.614    32.817
    -4.173    33.087
>
    -4.614    32.817
    -4.173    33.087
>
    -4.614    32.817
    -4.173    33.087
>
    -4.759    32.868
    -4.173    33.087
>
    -4.759    32.867
    -4.173    33.087
>
    -4.759    32.867
    -4.173    33.087
>
    -5.043    33.033
    -4.173    33.087
>
    -5.043    33.033
    -4.173    33.087
>
    -4.858    33.686
    -4.173    33.087
>
    -4.858    33.686
    -4.173    33.087
>
    -5.127    33.517
    -4.173    33.087
>
    -5.127    33.517
    -4.173    33.087
>
    -5.043    33.033
    -5.363    32.931
>
    -5.043    33.033
    -5.363    32.931
>
    -5.127    33.517
    -5.363    32.931
>
    -5.127    33.517
    -5.363    32.931
>
    -4.614    32.817
    -5.363    32.931
>
    -4.614    32.817
    -5.363    32.931
>
    -4.858    33.686
    -5.363    32.931
>
    -4.614    32.817
    -4.104    33.098
>
    -4.614    32.817
    -4.104    33.098
>
    -5.043    33.033
    -4.104    33.098
>
    -5.043    33.033
    -4.104    33.098
>
    -4.858    33.686
    -4.104    33.098
>
    -6.440    31.721
    -5.789    32.176
>
    -6.440    31.721
    -5.789    32.176
>
    -4.952    31.704
    -5.789    32.176
>
    -5.317    34.104
    -5.236    34.188
>
    -5.317    34.104
    -5.236    34.188
>
    -4.858    33.686
    -5.236    34.188
>
    -4.858    33.686
    -5.236    34.188
>
    -5.127    33.517
    -5.236    34.188
>
    -5.127    33.517
    -5.236    34.188
>
    -5.828    34.877
    -5.236    34.188
>
    -5.828    34.877
    -5.236    34.188
>
    -4.858    33.686
    -5.500    33.327
>
    -4.858    33.686
    -5.500    33.327
>
    -5.317    34.104
    -5.500    33.327
>
    -5.317    34.104
    -5.500    33.327
>
    -4.759    32.867
    -5.500    33.327
>
    -6.642    33.446
    -5.500    33.327
>
    -6.642    33.446
    -5.500    33.327
>
    -4.614    32.817
    -5.500    33.327
>
    -4.759    32.867
    -5.004    32.381
>
    -4.759    32.867
    -5.004    32.381
>
    -4.614    32.817
    -5.004    32.381
>
    -4.614    32.817
    -5.004    32.381
>
    -5.043    33.033
    -5.004    32.381
>
    -5.043    33.033
    -5.004    32.381
>
    -4.952    31.704
    -5.004    32.381
>
    -4.952    31.704
    -5.004    32.381
>
    -4.952    31.704
    -5.611    31.589
>
    -4.952    31.704
    -5.611    31.589
>
    -5.569    30.785
    -5.611    31.589
>
    -5.569    30.785
    -5.611    31.589
>
    -4.952    31.704
    -5.067    31.650
>
    -4.952    31.704
    -5.067    31.650
>
    -4.219    31.433
    -5.067    31.650
>
    -4.219    31.433
    -5.067    31.650
>
    -5.569    30.785
    -5.067    31.650
>
    -5.569    30.785
    -5.067    31.650
>
    -5.043    33.033
    -5.251    32.797
>
    -5.043    33.033
    -5.251    32.797
>
    -4.759    32.867
    -5.251    32.797
>
    -4.759    32.867
    -5.251    32.797
>
    -4.614    32.817
    -5.251    32.797
>
    -4.614    32.817
    -5.251    32.797
>
    -6.440    31.721
    -6.059    32.075
>
    -6.440    31.721
    -6.059    32.075
>
    -6.440    31.721
    -6.271    31.815
>
    -6.440    31.721
    -6.271    31.815
>
    -6.760    30.909
    -6.271    31.815
>
    -5.828    34.877
    -5.593    34.258
>
    -4.858    33.686
    -5.593    34.258
>
    -5.127    33.517
    -5.593    34.258
>
    -5.317    34.104
    -5.588    34.260
>
    -5.317    34.104
    -5.588    34.260
>
    -5.828    34.877
    -5.588    34.260
>
    -5.828    34.877
    -5.588    34.260
>
    -5.340    35.107
    -5.588    34.260
>
    -5.340    35.107
    -5.588    34.260
>
    -4.858    33.686
    -5.588    34.260
>
    -5.127    33.517
    -5.588    34.260
>
    -5.127    33.517
    -5.588    34.260
>
    -6.440    31.721
    -6.239    32.139
>
    -6.440    31.721
    -6.239    32.139
>
    -4.858    33.686
    -3.802    33.643
>
    -6.440    31.721
    -6.293    32.081
>
    -6.440    31.721
    -6.293    32.081
>
    -6.440    31.721
    -6.171    32.241
>
    -6.440    31.721
    -6.144    32.243
>
    -6.440    31.721
    -6.144    32.243
>
    -4.858    33.686
    -3.750    33.766
>
    -4.858    33.686
    -3.750    33.766
>
    -4.858    33.686
    -3.790    33.729
>
    -4.858    33.686
    -3.790    33.729
>
    -5.317    34.104
    -5.270    34.044
>
    -5.317    34.104
    -5.270    34.044
>
    -4.858    33.686
    -5.270    34.044
>
    -4.858    33.686
    -5.270    34.044
>
    -5.127    33.517
    -5.270    34.044
>
    -5.127    33.517
    -5.270    34.044
>
    -5.828    34.877
    -5.270    34.044
>
    -5.828    34.877
    -5.270    34.044
>
    -4.858    33.686
    -3.863    33.680
>
    -4.858    33.686
    -3.863    33.680
>
    -6.440    31.721
    -6.044    31.380
>
    -6.760    30.909
    -6.044    31.380
>
    -5.569    30.785
    -6.044    31.380
>
    -5.569    30.785
    -6.044    31.380
>
    -4.952    31.704
    -6.044    31.380
>
    -4.952    31.704
    -6.044    31.380
>
    -4.952    31.704
    -5.200    32.300
>
    -4.952    31.704
    -5.200    32.300
>
    -4.952    31.704
    -5.200    32.300
>
    -4.759    32.867
    -5.200    32.300
>
    -4.759    32.867
    -5.200    32.300
>
    -4.614    32.817
    -5.200    32.300
>
    -4.614    32.817
    -5.200    32.300
>
    -4.858    33.686
    -3.722    33.746
>
    -4.858    33.686
    -3.722    33.746
>
    -5.043    33.033
    -5.116    32.912
>
    -5.043    33.033
    -5.116    32.912
>
    -4.759    32.867
    -5.116    32.912
>
    -4.759    32.867
    -5.116    32.912
>
    -4.614    32.817
    -5.116    32.912
>
    -4.614    32.817
    -5.116    32.912
>
    -5.127    33.517
    -5.116    32.912
>
    -4.858    33.686
    -5.116    32.912
>
    -4.858    33.686
    -3.924    33.628
>
    -4.858    33.686
    -3.924    33.628
>
    -4.614    32.817
    -3.924    33.628
>
    -6.440    31.721
    -6.473    31.928
>
    -6.440    31.721
    -6.473    31.928
>
    -4.952    31.704
    -5.801    32.193
>
    -4.952    31.704
    -5.801    32.193
>
    -6.642    33.446
    -6.076    33.407
>
    -6.642    33.446
    -6.076    33.407
>
    -5.127    33.517
    -6.076    33.407
>
    -5.317    34.104
    -6.076    33.407
>
    -6.642    33.446
    -6.559    33.039
>
    -7.413    33.298
    -6.559    33.039
>
    -7.413    33.298
    -6.559    33.039
>
    -7.413    33.298
    -6.559    33.039
>
    -7.413    33.298
    -6.559    33.039
>
    -6.857    33.988
    -6.559    33.039
>
    -5.043    33.033
    -4.977    33.144
>
    -5.043    33.033
    -4.977    33.144
>
    -5.127    33.517
    -4.977    33.144
>
    -5.127    33.517
    -4.977    33.144
>
    -4.759    32.867
    -4.977    33.144
>
    -4.759    32.867
    -4.977    33.144
>
    -4.614    32.817
    -4.977    33.144
>
    -4.614    32.817
    -4.977    33.144
>
    -4.858    33.686
    -4.977    33.144
>
    -5.317    34.104
    -4.977    33.144
>
    -5.127    33.517
    -4.540    34.391
>
    -5.127    33.517
    -4.540    34.391
>
    -5.317    34.104
    -4.462    34.337
>
    -5.317    34.104
    -4.462    34.337
>
    -3.863    34.510
    -4.462    34.337
>
    -3.863    34.510
    -4.462    34.337
>
    -3.939    35.217
    -4.462    34.337
>
    -3.939    35.217
    -4.462    34.337
>
    -4.858    33.686
    -4.355    33.793
>
    -3.863    34.510
    -4.355    33.793
>
    -3.863    34.510
    -4.355    33.793
>
    -5.317    34.104
    -4.355    33.793
>
    -5.317    34.104
    -4.355    33.793
>
    -5.043    33.033
    -4.355    33.793
>
    -5.043    33.033
    -4.355    33.793
>
    -4.759    32.867
    -4.355    33.793
>
    -4.614    32.817
    -4.355    33.793
>
    -4.614    32.817
    -4.355    33.793
>
    -6.642    33.446
    -5.864    33.068
>
    -6.642    33.446
    -5.864    33.068
>
    -5.043    33.033
    -5.864    33.068
>
    -5.043    33.033
    -5.864    33.068
>
    -5.127    33.517
    -5.864    33.068
>
    -5.127    33.517
    -5.864    33.068
>
    -5.127    33.517
    -5.864    33.068
>
    -5.127    33.517
    -5.864    33.068
>
    -4.759    32.867
    -5.864    33.068
>
    -4.759    32.867
    -5.864    33.068
>
    -4.858    33.686
    -3.964    33.454
>
    -4.858    33.686
    -3.964    33.454
>
    -4.614    32.817
    -3.964    33.454
>
    -4.614    32.817
    -3.964    33.454
>
    -4.759    32.867
    -3.964    33.454
>
    -4.759    32.867
    -3.964    33.454
>
    -5.127    33.517
    -3.964    33.454
>
    -5.127    33.517
    -3.964    33.454
>
    -5.127    33.517
    -3.964    33.454
>
    -5.043    33.033
    -3.964    33.454
>
    -5.043    33.033
    -3.964    33.454
>
    -4.858    33.686
    -4.153    33.601
>
    -5.127    33.517
    -4.153    33.601
>
    -5.127    33.517
    -4.153    33.601
>
    -5.127    33.517
    -4.153    33.601
>
    -5.127    33.517
    -4.153    33.601
>
    -3.863    34.510
    -4.153    33.601
>
    -5.043    33.033
    -4.153    33.601
>
    -5.043    33.033
    -4.153    33.601
>
    -4.759    32.867
    -4.153    33.601
>
    -4.614    32.817
    -4.153    33.601
>
    -4.614    32.817
    -4.153    33.601
>
    -4.858    33.686
    -4.089    33.577
>
    -3.863    34.510
    -4.089    33.577
>
    -3.863    34.510
    -4.089    33.577
>
    -4.614    32.817
    -4.089    33.577
>
    -4.614    32.817
    -4.089    33.577
>
    -4.759    32.867
    -4.089    33.577
>
    -4.759    32.867
    -4.089    33.577
>
    -5.043    33.033
    -4.089    33.577
>
    -5.043    33.033
    -4.089    33.577
>
    -5.317    34.104
    -5.415    33.988
>
    -5.317    34.104
    -5.415    33.988
>
    -5.127    33.517
    -5.415    33.988
>
    -5.127    33.517
    -5.415    33.988
>
    -5.127    33.517
    -5.415    33.988
>
    -5.127    33.517
    -5.415    33.988
>
    -4.858    33.686
    -5.415    33.988
>
    -5.828    34.877
    -5.415    33.988
>
    -5.828    34.877
    -5.415    33.988
>
    -6.440    31.721
    -6.263    31.978
>
    -6.440    31.721
    -6.263    31.978
>
    -4.858    33.686
    -4.739    34.094
>
    -4.858    33.686
    -4.739    34.094
>
    -3.863    34.510
    -4.739    34.094
>
    -4.952    31.704
    -5.907    32.278
>
    -4.952    31.704
    -5.907    32.278
>
    -4.614    32.817
    -3.566    32.657
>
    -3.863    34.510
    -3.293    33.986
>
    -3.863    34.510
    -3.293    33.986
>
    -2.567    34.335
    -3.293    33.986
>
    -4.858    33.686
    -4.186    33.903
>
    -4.858    33.686
    -4.186    33.903
>
    -3.863    34.510
    -4.186    33.903
>
    -3.863    34.510
    -4.186    33.903
>
    -5.317    34.104
    -4.186    33.903
>
    -5.317    34.104
    -4.186    33.903
>
    -5.317    34.104
    -5.434    34.418
>
    -5.317    34.104
    -5.434    34.418
>
    -4.858    33.686
    -5.434    34.418
>
    -5.317    34.104
    -5.679    33.665
>
    -5.317    34.104
    -5.679    33.665
>
    -4.858    33.686
    -5.679    33.665
>
    -4.858    33.686
    -5.679    33.665
>
    -5.043    33.033
    -5.679    33.665
>
    -5.043    33.033
    -5.679    33.665
>
    -5.043    33.033
    -5.103    32.999
>
    -5.043    33.033
    -5.103    32.999
>
    -4.759    32.867
    -5.103    32.999
>
    -4.614    32.817
    -5.103    32.999
>
    -4.858    33.686
    -5.103    32.999
>
    -5.317    34.104
    -5.549    34.281
>
    -5.317    34.104
    -5.549    34.281
>
    -5.828    34.877
    -5.549    34.281
>
    -5.828    34.877
    -5.549    34.281
>
    -5.828    34.877
    -5.549    34.281
>
    -4.858    33.686
    -5.549    34.281
>
    -4.858    33.686
    -5.549    34.281
>
    -5.317    34.104
    -5.415    33.657
>
    -5.317    34.104
    -5.415    33.657
>
    -4.858    33.686
    -5.415    33.657
>
    -4.858    33.686
    -5.415    33.657
>
    -5.043    33.033
    -5.415    33.657
>
    -5.043    33.033
    -5.415    33.657
>
    -4.759    32.867
    -5.415    33.657
>
    -4.759    32.867
    -5.415    33.657
>
    -3.863    34.510
    -4.441    34.288
>
    -3.863    34.510
    -4.441    34.288
>
    -4.858    33.686
    -4.441    34.288
>
    -5.317    34.104
    -4.441    34.288
>
    -4.759    32.867
    -5.388    32.307
>
    -4.759    32.867
    -5.388    32.307
>
    -5.043    33.033
    -5.388    32.307
>
    -5.043    33.033
    -5.388    32.307
>
    -4.614    32.817
    -5.388    32.307
>
    -4.614    32.817
    -5.388    32.307
>
    -6.642    33.446
    -6.578    33.065
>
    -6.642    33.446
    -6.578    33.065
>
    -7.413    33.298
    -6.578    33.065
>
    -7.413    33.298
    -6.578    33.065
>
    -7.413    33.298
    -6.578    33.065
>
    -6.857    33.988
    -6.578    33.065
>
    -6.857    33.988
    -6.578    33.065
>
    -6.857    33.988
    -6.578    33.065
>
    -6.857    33.988
    -6.578    33.065
>
    -6.857    33.988
    -6.578    33.065
>
    -5.127    33.517
    -5.924    33.804
>
    -5.127    33.517
    -5.924    33.804
>
    -6.857    33.988
    -5.924    33.804
>
    -5.127    33.517
    -5.137    33.160
>
    -5.127    33.517
    -5.137    33.160
>
    -5.127    33.517
    -5.137    33.160
>
    -5.127    33.517
    -5.137    33.160
>
    -4.614    32.817
    -5.137    33.160
>
    -4.614    32.817
    -5.137    33.160
>
    -4.759    32.868
    -5.137    33.160
>
    -4.759    32.867
    -5.137    33.160
>
    -4.759    32.867
    -5.137    33.160
>
    -5.127    33.517
    -4.758    34.021
>
    -5.127    33.517
    -4.758    34.021
>
    -6.857    33.988
    -5.921    34.129
>
    -5.828    34.877
    -5.921    34.129
>
    -5.828    34.877
    -5.921    34.129
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
    -5.127    33.517     0.300
    -5.043    33.033     0.300
    -5.319    32.530     0.300
    -3.754    34.962     0.300
    -2.414    34.814     0.300
    -2.957    35.300     0.300
    -4.184    34.089     0.300
    -2.746    34.970     0.300
    -5.828    34.877     0.300
    -5.055    34.070     0.300
    -5.229    33.409     0.300
    -6.039    32.576     0.300
    -6.490    32.148     0.300
    -4.614    32.817     0.300
    -6.857    33.988     0.300
    -4.352    32.034     0.300
    -5.317    34.104     0.300
    -4.952    31.704     0.300
    -4.759    32.867     0.300
    -4.858    33.686     0.300
    -3.863    34.510     0.300
    -3.939    35.217     0.300
    -6.760    30.909     0.300
    -7.868    31.209     0.300
    -6.642    33.446     0.300
    -5.340    35.107     0.300
    -4.219    31.433     0.300
    -4.301    35.173     0.300
    -2.567    34.335     0.300
    -7.413    33.298     0.300
    -6.440    31.721     0.300
    -4.759    32.868     0.300
    -7.262    30.927     0.300
    -7.898    32.471     0.300
    -5.569    30.785     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
    -6.179    31.399     0.200
>
    -3.736    34.260     0.200
>
    -5.111    34.263     0.200
>
    -5.209    34.128     0.200
>
    -4.014    33.791     0.200
>
    -5.239    33.353     0.200
>
    -5.315    32.935     0.200
>
    -5.353    32.939     0.200
>
    -5.307    31.916     0.200
>
    -4.280    31.230     0.200
>
    -4.327    31.235     0.200
>
    -4.982    33.173     0.200
>
    -3.222    34.324     0.200
>
    -3.292    34.281     0.200
>
    -4.812    34.139     0.200
>
    -5.079    34.164     0.200
>
    -5.100    33.243     0.200
>
    -4.907    34.329     0.200
>
    -4.796    34.116     0.200
>
    -4.242    33.681     0.200
>
    -5.461    32.874     0.200
>
    -5.370    32.759     0.200
>
    -5.429    32.645     0.200
>
    -5.747    33.939     0.200
>
    -5.259    33.961     0.200
>
    -5.132    34.104     0.200
>
    -5.928    33.857     0.200
>
    -6.341    34.170     0.200
>
    -5.013    34.087     0.200
>
    -5.429    33.997     0.200
>
    -5.806    33.665     0.200
>
    -4.265    34.444     0.200
>
    -5.555    33.594     0.200
>
    -4.854    34.083     0.200
>
    -4.782    34.105     0.200
>
    -6.124    32.439     0.200
>
    -6.066    32.438     0.200
>
    -5.197    33.019     0.200
>
    -5.383    32.747     0.200
>
    -6.202    33.849     0.200
>
    -5.518    31.686     0.200
>
    -5.879    33.726     0.200
>
    -5.580    31.928     0.200
>
    -4.709    34.286     0.200
>
    -4.774    34.279     0.200
>
    -5.729    33.540     0.200
>
    -3.562    32.549     0.200
>
    -5.166    33.035     0.200
>
    -3.542    32.613     0.200
>
    -4.348    34.213     0.200
>
    -5.154    32.842     0.200
>
    -4.303    34.026     0.200
>
    -5.457    33.983     0.200
>
    -4.687    34.277     0.200
>
    -5.583    34.246     0.200
>
    -5.788    32.218     0.200
>
    -5.197    33.105     0.200
>
    -5.336    34.215     0.200
>
    -5.846    32.063     0.200
>
    -6.431    31.894     0.200
>
    -6.161    32.092     0.200
>
    -6.166    32.068     0.200
>
    -5.806    32.155     0.200
>
    -5.331    32.969     0.200
>
    -4.235    33.684     0.200
>
    -4.638    32.596     0.200
>
    -5.938    33.728     0.200
>
    -6.243    32.250     0.200
>
    -5.781    32.358     0.200
>
    -5.794    33.597     0.200
>
    -5.808    33.606     0.200
>
    -6.047    32.274     0.200
>
    -5.269    33.099     0.200
>
    -5.406    32.408     0.200
>
    -5.625    32.322     0.200
>
    -6.157    32.088     0.200
>
    -5.355    32.242     0.200
>
    -5.015    34.005     0.200
>
    -4.840    33.993     0.200
>
    -5.983    31.997     0.200
>
    -5.367    32.903     0.200
>
    -3.577    33.869     0.200
>
    -6.605    31.927     0.200
>
    -6.202    32.277     0.200
>
    -4.402    33.692     0.200
>
    -5.268    33.507     0.200
>
    -5.600    34.147     0.200
>
    -5.341    32.442     0.200
>
    -6.209    32.094     0.200
>
    -6.278    32.358     0.200
>
    -4.237    34.314     0.200
>
    -5.791    32.201     0.200
>
    -3.569    32.129     0.200
>
    -5.251    34.245     0.200
>
    -6.811    31.739     0.200
>
    -6.337    32.079     0.200
>
    -5.213    32.938     0.200
>
    -5.850    33.720     0.200
>
    -6.193    32.301     0.200
>
    -5.884    32.000     0.200
>
    -5.719    32.010     0.200
>
    -5.277    32.619     0.200
>
    -5.134    32.495     0.200
>
    -5.798    32.137     0.200
>
    -5.323    32.794     0.200
>
    -4.629    33.246     0.200
>
    -5.228    34.269     0.200
>
    -6.473    33.954     0.200
>
    -6.219    32.043     0.200
>
    -6.391    33.934     0.200
>
    -6.935    32.187     0.200
>
    -5.893    33.858     0.200
>
    -5.750    32.228     0.200
>
    -5.580    34.003     0.200
>
    -5.317    33.690     0.200
>
    -5.218    34.103     0.200
>
    -4.866    33.960     0.200
>
    -6.886    34.242     0.200
>
    -5.234    32.850     0.200
>
    -5.545    32.432     0.200
>
    -4.948    34.132     0.200
>
    -4.510    33.855     0.200
>
    -5.051    33.271     0.200
>
    -5.035    33.295     0.200
>
    -4.418    34.369     0.200
>
    -4.952    34.108     0.200
>
    -4.953    34.088     0.200
>
    -4.931    34.079     0.200
>
    -4.990    34.086     0.200
>
    -5.491    32.304     0.200
>
    -3.681    33.847     0.200
>
    -5.335    32.417     0.200
>
    -5.743    32.138     0.200
>
    -6.788    31.262     0.200
>
    -5.124    33.083     0.200
>
    -6.627    33.993     0.200
>
    -4.750    34.174     0.200
>
    -4.688    34.252     0.200
>
    -4.749    34.220     0.200
>
    -4.715    34.177     0.200
>
    -4.207    33.554     0.200
>
    -5.818    33.634     0.200
>
    -5.168    32.950     0.200
>
    -5.122    32.944     0.200
>
    -5.771    33.559     0.200
>
    -5.727    34.357     0.200
>
    -5.807    33.795     0.200
>
    -5.737    33.364     0.200
>
    -3.493    34.376     0.200
>
    -4.801    32.596     0.200
>
    -5.808    33.760     0.200
>
    -6.691    33.109     0.200
>
    -5.769    33.656     0.200
>
    -5.236    32.959     0.200
>
    -5.836    32.167     0.200
>
    -4.453    33.599     0.200
>
    -4.886    34.044     0.200
>
    -4.109    33.729     0.200
>
    -4.974    34.110     0.200
>
    -5.112    31.827     0.200
>
    -4.860    33.386     0.200
>
    -5.004    33.525     0.200
>
    -3.625    32.226     0.200
>
    -5.013    33.530     0.200
>
    -4.915    33.469     0.200
>
    -4.936    33.500     0.200
>
    -4.932    33.520     0.200
>
    -4.860    33.555     0.200
>
    -5.578    32.400     0.200
>
    -5.609    32.386     0.200
>
    -4.754    32.530     0.200
>
    -4.701    33.505     0.200
>
    -5.087    33.154     0.200
>
    -5.833    34.008     0.200
>
    -4.469    33.439     0.200
>
    -4.593    33.455     0.200
>
    -4.933    33.485     0.200
>
    -5.943    33.686     0.200
>
    -4.773    34.368     0.200
>
    -3.801    34.312     0.200
>
    -4.941    33.534     0.200
>
    -4.700    34.316     0.200
>
    -4.812    34.367     0.200
>
    -4.905    33.520     0.200
>
    -4.960    33.477     0.200
>
    -3.948    33.392     0.200
>
    -5.808    32.094     0.200
>
    -5.592    34.000     0.200
>
    -4.971    33.474     0.200
>
    -5.250    33.039     0.200
>
    -5.673    32.431     0.200
>
    -5.878    33.730     0.200
>
    -5.951    33.751     0.200
>
    -3.506    34.042     0.200
>
    -5.447    32.792     0.200
>
    -5.902    33.787     0.200
>
    -5.801    33.749     0.200
>
    -6.107    33.411     0.200
>
    -5.407    32.470     0.200
>
    -5.607    32.729     0.200
>
    -5.517    34.425     0.200
>
    -5.632    32.323     0.200
>
    -4.654    34.232     0.200
>
    -5.651    32.336     0.200
>
    -5.824    32.355     0.200
>
    -5.698    32.139     0.200
>
    -5.712    32.800     0.200
>
    -4.917    33.531     0.200
>
    -4.663    32.628     0.200
>
    -5.917    32.165     0.200
>
    -6.527    33.230     0.200
>
    -6.114    33.308     0.200
>
    -6.073    33.190     0.200
>
    -4.232    33.519     0.200
>
    -6.501    31.777     0.200
>
    -5.752    33.763     0.200
>
    -4.222    33.525     0.200
>
    -5.886    33.705     0.200
>
    -6.775    31.234     0.200
>
    -6.424    33.313     0.200
>
    -6.373    33.307     0.200
>
    -5.479    32.471     0.200
>
    -5.080    33.004     0.200
>
    -4.825    32.353     0.200
>
    -5.486    34.043     0.200
>
    -5.983    33.598     0.200
>
    -4.398    34.361     0.200
>
    -3.880    33.764     0.200
>
    -5.177    32.977     0.200
>
    -5.064    34.136     0.200
>
    -4.569    32.482     0.200
>
    -6.103    33.405     0.200
>
    -5.785    34.007     0.200
>
    -4.032    33.803     0.200
>
    -5.364    32.348     0.200
>
    -6.166    32.383     0.200
>
    -5.478    34.027     0.200
>
    -5.767    33.990     0.200
>
    -5.887    33.736     0.200
>
    -6.338    33.234     0.200
>
    -6.282    33.333     0.200
>
    -6.349    33.291     0.200
>
    -5.320    32.798     0.200
>
    -6.321    33.288     0.200
>
    -6.371    33.259     0.200
>
    -4.716    33.929     0.200
>
    -6.527    33.246     0.200
>
    -5.928    33.698     0.200
>
    -5.544    32.680     0.200
>
    -5.563    32.696     0.200
>
    -5.891    33.691     0.200
>
    -5.537    32.665     0.200
>
    -5.837    34.297     0.200
>
    -5.796    34.325     0.200
>
    -4.207    32.626     0.200
>
    -4.213    32.638     0.200
>
    -4.232    32.639     0.200
>
    -4.310    32.540     0.200
>
    -4.197    32.660     0.200
>
    -4.239    32.612     0.200
>
    -4.246    32.616     0.200
>
    -3.628    33.551     0.200
>
    -4.343    34.346     0.200
>
    -6.627    33.870     0.200
>
    -6.209    32.004     0.200
>
    -6.536    33.980     0.200
>
    -5.527    32.636     0.200
>
    -5.291    32.954     0.200
>
    -4.232    32.642     0.200
>
    -4.310    32.588     0.200
>
    -4.352    32.592     0.200
>
    -5.715    34.266     0.200
>
    -5.382    32.395     0.200
>
    -5.726    34.274     0.200
>
    -4.926    33.549     0.200
>
    -5.768    34.232     0.200
>
    -5.565    34.282     0.200
>
    -5.766    34.291     0.200
>
    -5.472    32.400     0.200
>
    -5.585    34.315     0.200
>
    -5.963    33.731     0.200
>
    -4.117    33.499     0.200
>
    -4.969    34.310     0.200
>
    -4.936    34.332     0.200
>
    -4.933    34.313     0.200
>
    -4.932    34.308     0.200
>
    -4.631    32.574     0.200
>
    -4.918    34.316     0.200
>
    -5.761    34.266     0.200
>
    -5.783    34.264     0.200
>
    -6.175    33.212     0.200
>
    -5.732    31.930     0.200
>
    -3.740    33.667     0.200
>
    -4.700    33.470     0.200
>
    -5.617    34.229     0.200
>
    -3.646    34.112     0.200
>
    -6.517    31.766     0.200
>
    -5.355    33.029     0.200
>
    -5.829    32.417     0.200
>
    -5.358    32.778     0.200
>
    -6.054    33.332     0.200
>
    -6.492    31.493     0.200
>
    -5.334    32.900     0.200
>
    -6.008    33.675     0.200
>
    -4.928    34.343     0.200
>
    -5.235    34.034     0.200
>
    -5.223    34.209     0.200
>
    -5.409    32.351     0.200
>
    -6.094    33.441     0.200
>
    -5.182    34.246     0.200
>
    -5.781    34.013     0.200
>
    -3.707    34.048     0.200
>
    -3.669    34.037     0.200
>
    -3.516    34.044     0.200
>
    -6.005    33.351     0.200
>
    -6.050    33.472     0.200
>
    -5.218    34.224     0.200
>
    -5.385    32.325     0.200
>
    -5.829    33.941     0.200
>
    -6.338    32.139     0.200
>
    -3.988    33.850     0.200
>
    -5.168    33.188     0.200
>
    -5.164    34.279     0.200
>
    -5.212    34.224     0.200
>
    -6.930    33.048     0.200
>
    -5.732    32.418     0.200
>
    -6.690    31.351     0.200
>
    -3.538    34.018     0.200
>
    -4.173    33.087     0.200
>
    -5.363    32.931     0.200
>
    -4.104    33.098     0.200
>
    -5.789    32.176     0.200
>
    -5.236    34.188     0.200
>
    -5.500    33.327     0.200
>
    -5.004    32.381     0.200
>
    -5.611    31.589     0.200
>
    -5.067    31.650     0.200
>
    -5.251    32.797     0.200
>
    -6.059    32.075     0.200
>
    -6.271    31.815     0.200
>
    -5.593    34.258     0.200
>
    -5.588    34.260     0.200
>
    -6.239    32.139     0.200
>
    -3.802    33.643     0.200
>
    -6.293    32.081     0.200
>
    -6.171    32.241     0.200
>
    -6.144    32.243     0.200
>
    -3.750    33.766     0.200
>
    -3.790    33.729     0.200
>
    -5.270    34.044     0.200
>
    -3.863    33.680     0.200
>
    -6.044    31.380     0.200
>
    -5.200    32.300     0.200
>
    -3.722    33.746     0.200
>
    -5.116    32.912     0.200
>
    -3.924    33.628     0.200
>
    -6.473    31.928     0.200
>
    -5.801    32.193     0.200
>
    -6.076    33.407     0.200
>
    -6.559    33.039     0.200
>
    -4.977    33.144     0.200
>
    -4.540    34.391     0.200
>
    -4.462    34.337     0.200
>
    -4.355    33.793     0.200
>
    -5.864    33.068     0.200
>
    -3.964    33.454     0.200
>
    -4.153    33.601     0.200
>
    -4.089    33.577     0.200
>
    -5.415    33.988     0.200
>
    -6.263    31.978     0.200
>
    -4.739    34.094     0.200
>
    -5.907    32.278     0.200
>
    -3.566    32.657     0.200
>
    -3.293    33.986     0.200
>
    -4.186    33.903     0.200
>
    -5.434    34.418     0.200
>
    -5.679    33.665     0.200
>
    -5.103    32.999     0.200
>
    -5.549    34.281     0.200
>
    -5.415    33.657     0.200
>
    -4.441    34.288     0.200
>
    -5.388    32.307     0.200
>
    -6.578    33.065     0.200
>
    -6.403    31.968     0.200
>
    -5.924    33.804     0.200
>
    -5.137    33.160     0.200
>
    -4.758    34.021     0.200
>
    -5.921    34.129     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
    -5.276    33.264     0.000   222.000   222.000
    -5.276    33.264     0.000   444.000   444.000
EOF
gmt end
