#!/bin/bash
gmt begin fes5.6_base pdf,ps
proj=-JM16.0c+
reg=-R-7.0/-3.1/31.1/34.5
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map fes5.6'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.179    31.399 1
    -3.736    34.260 2
    -5.111    34.263 3
    -5.209    34.128 4
    -4.014    33.791 5
    -5.239    33.353 6
    -5.315    32.935 7
    -5.353    32.939 8
    -5.307    31.916 9
    -4.280    31.230 10
    -4.327    31.235 11
    -4.982    33.173 12
    -3.222    34.324 13
    -3.292    34.281 14
    -4.812    34.139 15
    -5.079    34.164 16
    -5.100    33.243 17
    -4.907    34.329 18
    -4.796    34.116 19
    -4.242    33.681 20
    -5.461    32.874 21
    -5.370    32.759 22
    -5.429    32.645 23
    -5.747    33.939 24
    -5.259    33.961 25
    -5.132    34.104 26
    -5.928    33.857 27
    -6.341    34.170 28
    -5.013    34.087 29
    -5.429    33.997 30
    -5.806    33.665 31
    -4.265    34.444 32
    -5.555    33.594 33
    -4.854    34.083 34
    -4.782    34.105 35
    -6.124    32.439 36
    -6.066    32.438 37
    -5.197    33.019 38
    -5.383    32.747 39
    -6.202    33.849 40
    -5.518    31.686 41
    -5.879    33.726 42
    -5.580    31.928 43
    -4.709    34.286 44
    -4.774    34.279 45
    -5.729    33.540 46
    -3.562    32.549 47
    -5.166    33.035 48
    -3.542    32.613 49
    -4.348    34.213 50
    -5.154    32.842 51
    -4.303    34.026 52
    -5.457    33.983 53
    -4.687    34.277 54
    -5.583    34.246 55
    -5.788    32.218 56
    -5.197    33.105 57
    -5.336    34.215 58
    -5.846    32.063 59
    -6.431    31.894 60
    -6.161    32.092 61
    -6.166    32.068 62
    -5.806    32.155 63
    -5.331    32.969 64
    -4.235    33.684 65
    -4.638    32.596 66
    -5.938    33.728 67
    -6.243    32.250 68
    -5.781    32.358 69
    -5.794    33.597 70
    -5.808    33.606 71
    -6.047    32.274 72
    -5.269    33.099 73
    -5.406    32.408 74
    -5.625    32.322 75
    -6.157    32.088 76
    -5.355    32.242 77
    -5.015    34.005 78
    -4.840    33.993 79
    -5.983    31.997 80
    -5.367    32.903 81
    -3.577    33.869 82
    -6.605    31.927 83
    -6.202    32.277 84
    -4.402    33.692 85
    -5.268    33.507 86
    -5.600    34.147 87
    -5.341    32.442 88
    -6.209    32.094 89
    -6.278    32.358 90
    -4.237    34.314 91
    -5.791    32.201 92
    -3.569    32.129 93
    -5.251    34.245 94
    -6.811    31.739 95
    -6.337    32.079 96
    -5.213    32.938 97
    -5.850    33.720 98
    -6.193    32.301 99
    -5.884    32.000 100
    -5.719    32.010 101
    -5.277    32.619 102
    -5.134    32.495 103
    -5.798    32.137 104
    -5.323    32.794 105
    -4.629    33.246 106
    -5.228    34.269 107
    -6.473    33.954 108
    -6.219    32.043 109
    -6.391    33.934 110
    -6.935    32.187 111
    -5.893    33.858 112
    -5.750    32.228 113
    -5.580    34.003 114
    -5.317    33.690 115
    -5.218    34.103 116
    -4.866    33.960 117
    -6.886    34.242 118
    -5.234    32.850 119
    -5.545    32.432 120
    -4.948    34.132 121
    -4.510    33.855 122
    -5.051    33.271 123
    -5.035    33.295 124
    -4.418    34.369 125
    -4.952    34.108 126
    -4.953    34.088 127
    -4.931    34.079 128
    -4.990    34.086 129
    -5.491    32.304 130
    -3.681    33.847 131
    -5.335    32.417 132
    -5.743    32.138 133
    -6.788    31.262 134
    -5.124    33.083 135
    -6.627    33.993 136
    -4.750    34.174 137
    -4.688    34.252 138
    -4.749    34.220 139
    -4.715    34.177 140
    -4.207    33.554 141
    -5.818    33.634 142
    -5.168    32.950 143
    -5.122    32.944 144
    -5.771    33.559 145
    -5.727    34.357 146
    -5.807    33.795 147
    -5.737    33.364 148
    -3.493    34.376 149
    -4.801    32.596 150
    -5.808    33.760 151
    -6.691    33.109 152
    -5.769    33.656 153
    -5.236    32.959 154
    -5.836    32.167 155
    -4.453    33.599 156
    -4.886    34.044 157
    -4.109    33.729 158
    -4.974    34.110 159
    -5.112    31.827 160
    -4.860    33.386 161
    -5.004    33.525 162
    -3.625    32.226 163
    -5.013    33.530 164
    -4.915    33.469 165
    -4.936    33.500 166
    -4.932    33.520 167
    -4.860    33.555 168
    -5.578    32.400 169
    -5.609    32.386 170
    -4.754    32.530 171
    -4.701    33.505 172
    -5.087    33.154 173
    -5.833    34.008 174
    -4.469    33.439 175
    -4.593    33.455 176
    -4.933    33.485 177
    -5.943    33.686 178
    -4.773    34.368 179
    -3.801    34.312 180
    -4.941    33.534 181
    -4.700    34.316 182
    -4.812    34.367 183
    -4.905    33.520 184
    -4.960    33.477 185
    -3.948    33.392 186
    -5.808    32.094 187
    -5.592    34.000 188
    -4.971    33.474 189
    -5.250    33.039 190
    -5.673    32.431 191
    -5.878    33.730 192
    -5.951    33.751 193
    -3.506    34.042 194
    -5.447    32.792 195
    -5.902    33.787 196
    -5.801    33.749 197
    -6.107    33.411 198
    -5.407    32.470 199
    -5.607    32.729 200
    -5.517    34.425 201
    -5.632    32.323 202
    -4.654    34.232 203
    -5.651    32.336 204
    -5.824    32.355 205
    -5.698    32.139 206
    -5.712    32.800 207
    -4.917    33.531 208
    -4.663    32.628 209
    -5.917    32.165 210
    -6.527    33.230 211
    -6.114    33.308 212
    -6.073    33.190 213
    -4.232    33.519 214
    -6.501    31.777 215
    -5.752    33.763 216
    -4.222    33.525 217
    -5.886    33.705 218
    -6.775    31.234 219
    -6.424    33.313 220
    -6.373    33.307 221
    -5.479    32.471 222
    -5.080    33.004 223
    -4.825    32.353 224
    -5.486    34.043 225
    -5.983    33.598 226
    -4.398    34.361 227
    -3.880    33.764 228
    -5.177    32.977 229
    -5.064    34.136 230
    -4.569    32.482 231
    -6.103    33.405 232
    -5.785    34.007 233
    -4.032    33.803 234
    -5.364    32.348 235
    -6.166    32.383 236
    -5.478    34.027 237
    -5.767    33.990 238
    -5.887    33.736 239
    -6.338    33.234 240
    -6.282    33.333 241
    -6.349    33.291 242
    -5.320    32.798 243
    -6.321    33.288 244
    -6.371    33.259 245
    -4.716    33.929 246
    -6.527    33.246 247
    -5.928    33.698 248
    -5.544    32.680 249
    -5.563    32.696 250
    -5.891    33.691 251
    -5.537    32.665 252
    -5.837    34.297 253
    -5.796    34.325 254
    -4.207    32.626 255
    -4.213    32.638 256
    -4.232    32.639 257
    -4.310    32.540 258
    -4.197    32.660 259
    -4.239    32.612 260
    -4.246    32.616 261
    -3.628    33.551 262
    -4.343    34.346 263
    -6.627    33.870 264
    -6.209    32.004 265
    -6.536    33.980 266
    -5.527    32.636 267
    -5.291    32.954 268
    -4.232    32.642 269
    -4.310    32.588 270
    -4.352    32.592 271
    -5.715    34.266 272
    -5.382    32.395 273
    -5.726    34.274 274
    -4.926    33.549 275
    -5.768    34.232 276
    -5.565    34.282 277
    -5.766    34.291 278
    -5.472    32.400 279
    -5.585    34.315 280
    -5.963    33.731 281
    -4.117    33.499 282
    -4.969    34.310 283
    -4.936    34.332 284
    -4.933    34.313 285
    -4.932    34.308 286
    -4.631    32.574 287
    -4.918    34.316 288
    -5.761    34.266 289
    -5.783    34.264 290
    -6.175    33.212 291
    -5.732    31.930 292
    -3.740    33.667 293
    -4.700    33.470 294
    -5.617    34.229 295
    -3.646    34.112 296
    -6.517    31.766 297
    -5.355    33.029 298
    -5.829    32.417 299
    -5.358    32.778 300
    -6.054    33.332 301
    -6.492    31.493 302
    -5.334    32.900 303
    -6.008    33.675 304
    -4.928    34.343 305
    -5.235    34.034 306
    -5.223    34.209 307
    -5.409    32.351 308
    -6.094    33.441 309
    -5.182    34.246 310
    -5.781    34.013 311
    -3.707    34.048 312
    -3.669    34.037 313
    -3.516    34.044 314
    -6.005    33.351 315
    -6.050    33.472 316
    -5.218    34.224 317
    -5.385    32.325 318
    -5.829    33.941 319
    -6.338    32.139 320
    -3.988    33.850 321
    -5.168    33.188 322
    -5.164    34.279 323
    -5.212    34.224 324
    -6.930    33.048 325
    -5.732    32.418 326
    -6.690    31.351 327
    -3.538    34.018 328
    -4.173    33.087 329
    -5.363    32.931 330
    -4.104    33.098 331
    -5.789    32.176 332
    -5.236    34.188 333
    -5.500    33.327 334
    -5.004    32.381 335
    -5.611    31.589 336
    -5.067    31.650 337
    -5.251    32.797 338
    -6.059    32.075 339
    -6.271    31.815 340
    -5.593    34.258 341
    -5.588    34.260 342
    -6.239    32.139 343
    -3.802    33.643 344
    -6.293    32.081 345
    -6.171    32.241 346
    -6.144    32.243 347
    -3.750    33.766 348
    -3.790    33.729 349
    -5.270    34.044 350
    -3.863    33.680 351
    -6.044    31.380 352
    -5.200    32.300 353
    -3.722    33.746 354
    -5.116    32.912 355
    -3.924    33.628 356
    -6.473    31.928 357
    -5.801    32.193 358
    -6.076    33.407 359
    -6.559    33.039 360
    -4.977    33.144 361
    -4.540    34.391 362
    -4.462    34.337 363
    -4.355    33.793 364
    -5.864    33.068 365
    -3.964    33.454 366
    -4.153    33.601 367
    -4.089    33.577 368
    -5.415    33.988 369
    -6.263    31.978 370
    -4.739    34.094 371
    -5.907    32.278 372
    -3.566    32.657 373
    -3.293    33.986 374
    -4.186    33.903 375
    -5.434    34.418 376
    -5.679    33.665 377
    -5.103    32.999 378
    -5.549    34.281 379
    -5.415    33.657 380
    -4.441    34.288 381
    -5.388    32.307 382
    -6.578    33.065 383
    -6.403    31.968 384
    -5.924    33.804 385
    -5.137    33.160 386
    -4.758    34.021 387
    -5.921    34.129 388
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    -6.167    31.395
    -6.179    31.399
>
    -3.609    34.212
    -3.736    34.260
>
    -4.989    34.173
    -5.111    34.263
>
    -5.329    34.136
    -5.209    34.128
>
    -3.928    33.689
    -4.014    33.791
>
    -5.319    33.382
    -5.239    33.353
>
    -5.074    32.866
    -5.315    32.935
>
    -5.299    32.859
    -5.353    32.939
>
    -5.441    32.045
    -5.307    31.916
>
    -4.370    31.313
    -4.280    31.230
>
    -4.325    31.392
    -4.327    31.235
>
    -4.980    33.150
    -4.982    33.173
>
    -3.250    34.400
    -3.222    34.324
>
    -3.370    34.310
    -3.292    34.281
>
    -4.817    34.196
    -4.812    34.139
>
    -5.110    34.148
    -5.079    34.164
>
    -5.121    33.226
    -5.100    33.243
>
    -4.870    34.200
    -4.907    34.329
>
    -4.841    34.176
    -4.796    34.116
>
    -4.269    33.708
    -4.242    33.681
>
    -5.375    33.008
    -5.461    32.874
>
    -5.200    32.680
    -5.370    32.759
>
    -5.240    32.680
    -5.429    32.645
>
    -5.870    34.023
    -5.747    33.939
>
    -5.062    34.133
    -5.259    33.961
>
    -5.216    34.348
    -5.132    34.104
>
    -6.066    33.914
    -5.928    33.857
>
    -6.485    34.296
    -6.341    34.170
>
    -5.155    34.019
    -5.013    34.087
>
    -5.160    34.060
    -5.429    33.997
>
    -5.930    33.760
    -5.806    33.665
>
    -3.430    34.400
    -4.265    34.444
>
    -5.671    33.628
    -5.555    33.594
>
    -4.932    34.166
    -4.854    34.083
>
    -4.510    34.160
    -4.782    34.105
>
    -6.250    32.510
    -6.124    32.439
>
    -6.243    32.554
    -6.066    32.438
>
    -5.150    33.020
    -5.197    33.019
>
    -5.494    32.825
    -5.383    32.747
>
    -6.260    33.860
    -6.202    33.849
>
    -5.570    31.819
    -5.518    31.686
>
    -5.920    33.810
    -5.879    33.726
>
    -5.560    31.850
    -5.580    31.928
>
    -4.630    34.220
    -4.709    34.286
>
    -4.852    34.404
    -4.774    34.279
>
    -5.630    33.500
    -5.729    33.540
>
    -3.540    32.565
    -3.562    32.549
>
    -5.090    32.970
    -5.166    33.035
>
    -3.564    32.622
    -3.542    32.613
>
    -4.240    34.250
    -4.348    34.213
>
    -5.290    32.976
    -5.154    32.842
>
    -4.265    34.074
    -4.303    34.026
>
    -5.288    33.964
    -5.457    33.983
>
    -4.730    34.230
    -4.687    34.277
>
    -5.649    34.348
    -5.583    34.246
>
    -5.820    32.130
    -5.788    32.218
>
    -5.257    33.173
    -5.197    33.105
>
    -5.357    34.313
    -5.336    34.215
>
    -5.890    32.050
    -5.846    32.063
>
    -6.561    31.974
    -6.431    31.894
>
    -6.120    31.980
    -6.161    32.092
>
    -6.180    32.040
    -6.166    32.068
>
    -5.810    32.120
    -5.806    32.155
>
    -5.300    32.950
    -5.331    32.969
>
    -4.381    33.728
    -4.235    33.684
>
    -4.610    32.550
    -4.638    32.596
>
    -5.950    33.730
    -5.938    33.728
>
    -6.630    32.420
    -6.243    32.250
>
    -5.808    32.341
    -5.781    32.358
>
    -5.840    33.570
    -5.794    33.597
>
    -5.935    33.644
    -5.808    33.606
>
    -6.070    32.310
    -6.047    32.274
>
    -5.230    33.090
    -5.269    33.099
>
    -5.460    32.468
    -5.406    32.408
>
    -5.578    32.427
    -5.625    32.322
>
    -6.258    32.048
    -6.157    32.088
>
    -5.330    32.280
    -5.355    32.242
>
    -4.910    34.040
    -5.015    34.005
>
    -4.936    34.095
    -4.840    33.993
>
    -6.130    32.126
    -5.983    31.997
>
    -5.340    32.890
    -5.367    32.903
>
    -3.688    33.970
    -3.577    33.869
>
    -6.650    31.890
    -6.605    31.927
>
    -6.210    32.290
    -6.202    32.277
>
    -4.270    33.730
    -4.402    33.692
>
    -5.500    33.570
    -5.268    33.507
>
    -5.616    34.328
    -5.600    34.147
>
    -5.310    32.390
    -5.341    32.442
>
    -6.305    32.304
    -6.209    32.094
>
    -6.310    32.320
    -6.278    32.358
>
    -4.330    34.400
    -4.237    34.314
>
    -5.850    32.220
    -5.791    32.201
>
    -3.641    32.265
    -3.569    32.129
>
    -5.223    34.362
    -5.251    34.245
>
    -6.780    31.600
    -6.811    31.739
>
    -6.408    32.112
    -6.337    32.079
>
    -5.163    32.927
    -5.213    32.938
>
    -5.927    33.749
    -5.850    33.720
>
    -6.302    32.377
    -6.193    32.301
>
    -5.903    32.052
    -5.884    32.000
>
    -5.735    32.014
    -5.719    32.010
>
    -5.246    32.662
    -5.277    32.619
>
    -5.390    32.721
    -5.134    32.495
>
    -5.841    32.225
    -5.798    32.137
>
    -5.337    32.828
    -5.323    32.794
>
    -4.734    33.309
    -4.629    33.246
>
    -5.352    34.298
    -5.228    34.269
>
    -6.534    33.993
    -6.473    33.954
>
    -6.227    32.231
    -6.219    32.043
>
    -6.421    33.989
    -6.391    33.934
>
    -6.932    32.072
    -6.935    32.187
>
    -5.938    33.792
    -5.893    33.858
>
    -5.805    32.343
    -5.750    32.228
>
    -5.705    34.240
    -5.580    34.003
>
    -5.264    33.702
    -5.317    33.690
>
    -5.282    34.211
    -5.218    34.103
>
    -5.007    34.007
    -4.866    33.960
>
    -6.909    34.348
    -6.886    34.242
>
    -5.250    32.951
    -5.234    32.850
>
    -5.643    32.328
    -5.545    32.432
>
    -4.972    34.182
    -4.948    34.132
>
    -4.448    33.729
    -4.510    33.855
>
    -5.106    33.306
    -5.051    33.271
>
    -5.078    33.333
    -5.035    33.295
>
    -4.330    34.349
    -4.418    34.369
>
    -5.057    34.126
    -4.952    34.108
>
    -5.025    34.134
    -4.953    34.088
>
    -4.728    34.143
    -4.931    34.079
>
    -5.032    34.105
    -4.990    34.086
>
    -5.564    32.374
    -5.491    32.304
>
    -3.717    33.859
    -3.681    33.847
>
    -5.427    32.520
    -5.335    32.417
>
    -5.740    32.154
    -5.743    32.138
>
    -6.872    31.066
    -6.788    31.262
>
    -5.147    32.989
    -5.124    33.083
>
    -6.700    33.998
    -6.627    33.993
>
    -4.757    34.149
    -4.750    34.174
>
    -4.760    34.284
    -4.688    34.252
>
    -4.662    34.231
    -4.749    34.220
>
    -4.752    34.184
    -4.715    34.177
>
    -4.204    33.607
    -4.207    33.554
>
    -5.835    33.617
    -5.818    33.634
>
    -5.191    32.979
    -5.168    32.950
>
    -5.200    33.002
    -5.122    32.944
>
    -5.869    33.614
    -5.771    33.559
>
    -5.922    34.350
    -5.727    34.357
>
    -5.922    33.815
    -5.807    33.795
>
    -5.832    33.391
    -5.737    33.364
>
    -3.614    34.400
    -3.493    34.376
>
    -4.874    32.705
    -4.801    32.596
>
    -5.882    33.784
    -5.808    33.760
>
    -6.922    33.113
    -6.691    33.109
>
    -5.831    33.704
    -5.769    33.656
>
    -5.262    33.044
    -5.236    32.959
>
    -5.803    32.145
    -5.836    32.167
>
    -4.438    33.737
    -4.453    33.599
>
    -4.942    34.276
    -4.886    34.044
>
    -4.166    33.933
    -4.109    33.729
>
    -4.992    34.165
    -4.974    34.110
>
    -5.258    31.838
    -5.112    31.827
>
    -4.885    33.441
    -4.860    33.386
>
    -5.086    33.504
    -5.004    33.525
>
    -3.658    32.166
    -3.625    32.226
>
    -5.040    33.485
    -5.013    33.530
>
    -5.045    33.470
    -4.915    33.469
>
    -4.953    33.492
    -4.936    33.500
>
    -4.937    33.533
    -4.932    33.520
>
    -4.920    33.569
    -4.860    33.555
>
    -5.587    32.379
    -5.578    32.400
>
    -5.724    32.375
    -5.609    32.386
>
    -4.707    32.499
    -4.754    32.530
>
    -4.829    33.480
    -4.701    33.505
>
    -5.287    33.099
    -5.087    33.154
>
    -5.883    34.129
    -5.833    34.008
>
    -4.494    33.490
    -4.469    33.439
>
    -4.584    33.475
    -4.593    33.455
>
    -4.988    33.489
    -4.933    33.485
>
    -5.955    33.706
    -5.943    33.686
>
    -4.839    34.323
    -4.773    34.368
>
    -3.910    34.311
    -3.801    34.312
>
    -4.988    33.544
    -4.941    33.534
>
    -4.870    34.371
    -4.700    34.316
>
    -4.767    34.293
    -4.812    34.367
>
    -4.966    33.543
    -4.905    33.520
>
    -5.039    33.384
    -4.960    33.477
>
    -3.987    33.458
    -3.948    33.392
>
    -5.900    32.076
    -5.808    32.094
>
    -5.553    33.928
    -5.592    34.000
>
    -5.160    33.635
    -4.971    33.474
>
    -5.342    33.151
    -5.250    33.039
>
    -5.889    32.413
    -5.673    32.431
>
    -5.885    33.862
    -5.878    33.730
>
    -5.950    33.815
    -5.951    33.751
>
    -3.506    34.043
    -3.506    34.042
>
    -5.341    33.098
    -5.447    32.792
>
    -5.912    33.791
    -5.902    33.787
>
    -5.934    33.815
    -5.801    33.749
>
    -6.173    33.381
    -6.107    33.411
>
    -5.360    32.651
    -5.407    32.470
>
    -5.640    32.813
    -5.607    32.729
>
    -5.574    34.389
    -5.517    34.425
>
    -5.657    32.426
    -5.632    32.323
>
    -4.692    34.241
    -4.654    34.232
>
    -5.718    32.335
    -5.651    32.336
>
    -5.882    32.537
    -5.824    32.355
>
    -5.757    32.229
    -5.698    32.139
>
    -5.768    32.835
    -5.712    32.800
>
    -4.952    33.592
    -4.917    33.531
>
    -4.703    32.666
    -4.663    32.628
>
    -5.977    32.250
    -5.917    32.165
>
    -6.643    33.216
    -6.527    33.230
>
    -6.180    33.392
    -6.114    33.308
>
    -6.266    33.267
    -6.073    33.190
>
    -4.316    33.596
    -4.232    33.519
>
    -6.499    31.631
    -6.501    31.777
>
    -5.938    33.829
    -5.752    33.763
>
    -4.245    33.539
    -4.222    33.525
>
    -5.940    33.692
    -5.886    33.705
>
    -6.851    31.073
    -6.775    31.234
>
    -6.423    33.259
    -6.424    33.313
>
    -6.383    33.296
    -6.373    33.307
>
    -5.495    32.472
    -5.479    32.471
>
    -5.128    33.078
    -5.080    33.004
>
    -4.868    32.350
    -4.825    32.353
>
    -5.469    34.085
    -5.486    34.043
>
    -6.030    33.652
    -5.983    33.598
>
    -4.395    34.349
    -4.398    34.361
>
    -3.886    33.820
    -3.880    33.764
>
    -5.208    33.036
    -5.177    32.977
>
    -5.114    34.172
    -5.064    34.136
>
    -4.578    32.518
    -4.569    32.482
>
    -6.122    33.467
    -6.103    33.405
>
    -5.856    34.069
    -5.785    34.007
>
    -4.046    33.857
    -4.032    33.803
>
    -5.459    32.463
    -5.364    32.348
>
    -6.193    32.421
    -6.166    32.383
>
    -5.579    34.011
    -5.478    34.027
>
    -5.762    34.114
    -5.767    33.990
>
    -5.943    33.764
    -5.887    33.736
>
    -6.424    33.309
    -6.338    33.234
>
    -6.264    33.543
    -6.282    33.333
>
    -6.470    33.342
    -6.349    33.291
>
    -5.278    32.863
    -5.320    32.798
>
    -6.385    33.378
    -6.321    33.288
>
    -6.430    33.361
    -6.371    33.259
>
    -4.656    33.938
    -4.716    33.929
>
    -6.569    33.318
    -6.527    33.246
>
    -5.934    33.788
    -5.928    33.698
>
    -5.444    32.803
    -5.544    32.680
>
    -5.632    32.726
    -5.563    32.696
>
    -5.942    33.785
    -5.891    33.691
>
    -5.556    32.659
    -5.537    32.665
>
    -5.879    34.395
    -5.837    34.297
>
    -5.880    34.399
    -5.796    34.325
>
    -4.268    32.639
    -4.207    32.626
>
    -4.342    32.570
    -4.213    32.638
>
    -4.305    32.731
    -4.232    32.639
>
    -4.455    32.643
    -4.310    32.540
>
    -4.214    32.651
    -4.197    32.660
>
    -4.309    32.658
    -4.239    32.612
>
    -4.281    32.661
    -4.246    32.616
>
    -3.652    33.660
    -3.628    33.551
>
    -4.304    34.391
    -4.343    34.346
>
    -6.890    33.896
    -6.627    33.870
>
    -6.245    31.949
    -6.209    32.004
>
    -6.667    34.003
    -6.536    33.980
>
    -5.523    32.605
    -5.527    32.636
>
    -5.334    32.994
    -5.291    32.954
>
    -4.246    32.683
    -4.232    32.642
>
    -4.315    32.625
    -4.310    32.588
>
    -4.324    32.666
    -4.352    32.592
>
    -5.734    34.323
    -5.715    34.266
>
    -5.383    32.357
    -5.382    32.395
>
    -5.772    34.305
    -5.726    34.274
>
    -4.968    33.593
    -4.926    33.549
>
    -5.786    34.305
    -5.768    34.232
>
    -5.572    34.348
    -5.565    34.282
>
    -5.806    34.321
    -5.766    34.291
>
    -5.561    32.475
    -5.472    32.400
>
    -5.566    34.380
    -5.585    34.315
>
    -6.006    33.774
    -5.963    33.731
>
    -4.132    33.581
    -4.117    33.499
>
    -5.069    34.399
    -4.969    34.310
>
    -5.097    34.329
    -4.936    34.332
>
    -4.957    34.322
    -4.933    34.313
>
    -4.926    34.370
    -4.932    34.308
>
    -4.698    32.641
    -4.631    32.574
>
    -4.983    34.311
    -4.918    34.316
>
    -5.806    34.353
    -5.761    34.266
>
    -5.786    34.314
    -5.783    34.264
>
    -6.186    33.158
    -6.175    33.212
>
    -5.729    31.875
    -5.732    31.930
>
    -3.787    33.735
    -3.740    33.667
>
    -4.702    33.526
    -4.700    33.470
>
    -5.667    34.326
    -5.617    34.229
>
    -3.843    34.183
    -3.646    34.112
>
    -6.494    31.680
    -6.517    31.766
>
    -5.347    32.954
    -5.355    33.029
>
    -5.894    32.474
    -5.829    32.417
>
    -5.370    32.754
    -5.358    32.778
>
    -6.078    33.337
    -6.054    33.332
>
    -6.498    31.343
    -6.492    31.493
>
    -5.355    32.979
    -5.334    32.900
>
    -6.074    33.569
    -6.008    33.675
>
    -5.014    34.347
    -4.928    34.343
>
    -5.234    34.083
    -5.235    34.034
>
    -5.319    34.176
    -5.223    34.209
>
    -5.367    32.329
    -5.409    32.351
>
    -6.157    33.487
    -6.094    33.441
>
    -5.160    34.202
    -5.182    34.246
>
    -5.807    34.077
    -5.781    34.013
>
    -3.813    34.143
    -3.707    34.048
>
    -3.821    34.135
    -3.669    34.037
>
    -3.745    34.166
    -3.516    34.044
>
    -6.043    33.426
    -6.005    33.351
>
    -6.149    33.502
    -6.050    33.472
>
    -5.357    34.241
    -5.218    34.224
>
    -5.397    32.282
    -5.385    32.325
>
    -5.870    34.040
    -5.829    33.941
>
    -6.492    32.297
    -6.338    32.139
>
    -4.057    33.919
    -3.988    33.850
>
    -5.242    33.220
    -5.168    33.188
>
    -5.235    34.286
    -5.164    34.279
>
    -5.406    34.286
    -5.212    34.224
>
    -6.966    33.123
    -6.930    33.048
>
    -5.771    32.491
    -5.732    32.418
>
    -6.719    31.372
    -6.690    31.351
>
    -3.645    34.128
    -3.538    34.018
>
    -4.188    33.197
    -4.173    33.087
>
    -5.371    32.989
    -5.363    32.931
>
    -4.062    33.124
    -4.104    33.098
>
    -5.911    32.309
    -5.789    32.176
>
    -5.333    34.240
    -5.236    34.188
>
    -5.556    33.391
    -5.500    33.327
>
    -5.000    32.447
    -5.004    32.381
>
    -5.874    31.669
    -5.611    31.589
>
    -5.079    31.745
    -5.067    31.650
>
    -5.244    32.803
    -5.251    32.797
>
    -6.115    32.125
    -6.059    32.075
>
    -6.502    31.926
    -6.271    31.815
>
    -5.656    34.340
    -5.593    34.258
>
    -5.630    34.330
    -5.588    34.260
>
    -6.399    32.223
    -6.239    32.139
>
    -3.834    33.729
    -3.802    33.643
>
    -6.344    32.100
    -6.293    32.081
>
    -6.251    32.325
    -6.171    32.241
>
    -6.305    32.326
    -6.144    32.243
>
    -3.721    33.774
    -3.750    33.766
>
    -3.839    33.817
    -3.790    33.729
>
    -5.258    34.053
    -5.270    34.044
>
    -3.862    33.735
    -3.863    33.680
>
    -6.114    31.462
    -6.044    31.380
>
    -5.250    32.305
    -5.200    32.300
>
    -3.737    33.794
    -3.722    33.746
>
    -5.173    32.986
    -5.116    32.912
>
    -3.980    33.696
    -3.924    33.628
>
    -6.665    32.015
    -6.473    31.928
>
    -5.973    32.339
    -5.801    32.193
>
    -6.149    33.470
    -6.076    33.407
>
    -6.587    33.117
    -6.559    33.039
>
    -5.034    33.188
    -4.977    33.144
>
    -4.694    34.380
    -4.540    34.391
>
    -4.724    34.384
    -4.462    34.337
>
    -4.327    33.796
    -4.355    33.793
>
    -5.875    33.160
    -5.864    33.068
>
    -4.039    33.517
    -3.964    33.454
>
    -4.274    33.708
    -4.153    33.601
>
    -4.095    33.649
    -4.089    33.577
>
    -5.461    34.042
    -5.415    33.988
>
    -6.446    32.040
    -6.263    31.978
>
    -4.879    34.133
    -4.739    34.094
>
    -5.944    32.318
    -5.907    32.278
>
    -3.623    32.542
    -3.566    32.657
>
    -3.361    33.843
    -3.293    33.986
>
    -4.440    33.958
    -4.186    33.903
>
    -5.612    34.396
    -5.434    34.418
>
    -5.763    33.651
    -5.679    33.665
>
    -5.046    32.975
    -5.103    32.999
>
    -5.614    34.314
    -5.549    34.281
>
    -5.481    33.624
    -5.415    33.657
>
    -4.497    34.325
    -4.441    34.288
>
    -5.383    32.287
    -5.388    32.307
>
    -6.599    33.075
    -6.578    33.065
>
    -6.461    31.995
    -6.403    31.968
>
    -6.002    33.636
    -5.924    33.804
>
    -5.142    33.172
    -5.137    33.160
>
    -4.790    34.086
    -4.758    34.021
>
    -6.060    34.205
    -5.921    34.129
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    -6.186    31.390
    -6.179    31.399
>
    -3.705    34.242
    -3.736    34.260
>
    -5.126    34.269
    -5.111    34.263
>
    -5.206    34.129
    -5.209    34.128
>
    -3.998    33.778
    -4.014    33.791
>
    -5.235    33.350
    -5.239    33.353
>
    -5.327    32.939
    -5.315    32.935
>
    -5.324    32.926
    -5.353    32.939
>
    -5.307    31.914
    -5.307    31.916
>
    -4.279    31.228
    -4.280    31.230
>
    -4.326    31.234
    -4.327    31.235
>
    -4.991    33.175
    -4.982    33.173
>
    -3.221    34.322
    -3.222    34.324
>
    -3.291    34.280
    -3.292    34.281
>
    -4.811    34.138
    -4.812    34.139
>
    -5.081    34.164
    -5.079    34.164
>
    -5.101    33.242
    -5.100    33.243
>
    -4.907    34.328
    -4.907    34.329
>
    -4.796    34.116
    -4.796    34.116
>
    -4.241    33.680
    -4.242    33.681
>
    -5.461    32.873
    -5.461    32.874
>
    -5.370    32.758
    -5.370    32.759
>
    -5.428    32.644
    -5.429    32.645
>
    -5.747    33.939
    -5.747    33.939
>
    -5.259    33.961
    -5.259    33.961
>
    -5.132    34.103
    -5.132    34.104
>
    -5.928    33.857
    -5.928    33.857
>
    -6.341    34.169
    -6.341    34.170
>
    -5.013    34.087
    -5.013    34.087
>
    -5.428    33.996
    -5.429    33.997
>
    -5.806    33.665
    -5.806    33.665
>
    -4.265    34.443
    -4.265    34.444
>
    -5.555    33.594
    -5.555    33.594
>
    -4.854    34.082
    -4.854    34.083
>
    -4.783    34.104
    -4.782    34.105
>
    -6.124    32.439
    -6.124    32.439
>
    -6.067    32.437
    -6.066    32.438
>
    -5.196    33.019
    -5.197    33.019
>
    -5.383    32.746
    -5.383    32.747
>
    -6.201    33.847
    -6.202    33.849
>
    -5.518    31.686
    -5.518    31.686
>
    -5.879    33.726
    -5.879    33.726
>
    -5.580    31.927
    -5.580    31.928
>
    -4.709    34.286
    -4.709    34.286
>
    -4.773    34.279
    -4.774    34.279
>
    -5.730    33.539
    -5.729    33.540
>
    -3.562    32.549
    -3.562    32.549
>
    -5.166    33.035
    -5.166    33.035
>
    -3.541    32.613
    -3.542    32.613
>
    -4.348    34.213
    -4.348    34.213
>
    -5.155    32.842
    -5.154    32.842
>
    -4.302    34.026
    -4.303    34.026
>
    -5.456    33.984
    -5.457    33.983
>
    -4.686    34.277
    -4.687    34.277
>
    -5.583    34.246
    -5.583    34.246
>
    -5.788    32.217
    -5.788    32.218
>
    -5.197    33.104
    -5.197    33.105
>
    -5.336    34.215
    -5.336    34.215
>
    -5.845    32.063
    -5.846    32.063
>
    -6.433    31.894
    -6.431    31.894
>
    -6.162    32.091
    -6.161    32.092
>
    -6.166    32.068
    -6.166    32.068
>
    -5.806    32.153
    -5.806    32.155
>
    -5.331    32.969
    -5.331    32.969
>
    -4.237    33.684
    -4.235    33.684
>
    -4.636    32.596
    -4.638    32.596
>
    -5.939    33.728
    -5.938    33.728
>
    -6.243    32.249
    -6.243    32.250
>
    -5.782    32.356
    -5.781    32.358
>
    -5.794    33.597
    -5.794    33.597
>
    -5.807    33.606
    -5.808    33.606
>
    -6.047    32.273
    -6.047    32.274
>
    -5.269    33.099
    -5.269    33.099
>
    -5.407    32.407
    -5.406    32.408
>
    -5.625    32.321
    -5.625    32.322
>
    -6.158    32.087
    -6.157    32.088
>
    -5.356    32.240
    -5.355    32.242
>
    -5.016    34.005
    -5.015    34.005
>
    -4.838    33.993
    -4.840    33.993
>
    -5.982    31.997
    -5.983    31.997
>
    -5.367    32.903
    -5.367    32.903
>
    -3.577    33.869
    -3.577    33.869
>
    -6.604    31.925
    -6.605    31.927
>
    -6.203    32.276
    -6.202    32.277
>
    -4.383    33.697
    -4.402    33.692
>
    -5.269    33.507
    -5.268    33.507
>
    -5.601    34.147
    -5.600    34.147
>
    -5.341    32.442
    -5.341    32.442
>
    -6.210    32.093
    -6.209    32.094
>
    -6.277    32.357
    -6.278    32.358
>
    -4.238    34.313
    -4.237    34.314
>
    -5.791    32.200
    -5.791    32.201
>
    -3.572    32.128
    -3.569    32.129
>
    -5.263    34.241
    -5.251    34.245
>
    -6.811    31.738
    -6.811    31.739
>
    -6.337    32.078
    -6.337    32.079
>
    -5.213    32.938
    -5.213    32.938
>
    -5.850    33.720
    -5.850    33.720
>
    -6.193    32.301
    -6.193    32.301
>
    -5.884    32.000
    -5.884    32.000
>
    -5.719    32.008
    -5.719    32.010
>
    -5.277    32.619
    -5.277    32.619
>
    -5.134    32.495
    -5.134    32.495
>
    -5.799    32.136
    -5.798    32.137
>
    -5.323    32.793
    -5.323    32.794
>
    -4.628    33.245
    -4.629    33.246
>
    -5.227    34.269
    -5.228    34.269
>
    -6.473    33.953
    -6.473    33.954
>
    -6.219    32.043
    -6.219    32.043
>
    -6.391    33.933
    -6.391    33.934
>
    -6.935    32.187
    -6.935    32.187
>
    -5.893    33.857
    -5.893    33.858
>
    -5.750    32.227
    -5.750    32.228
>
    -5.579    34.003
    -5.580    34.003
>
    -5.317    33.690
    -5.317    33.690
>
    -5.217    34.103
    -5.218    34.103
>
    -4.865    33.960
    -4.866    33.960
>
    -6.885    34.242
    -6.886    34.242
>
    -5.234    32.850
    -5.234    32.850
>
    -5.545    32.431
    -5.545    32.432
>
    -4.948    34.133
    -4.948    34.132
>
    -4.510    33.854
    -4.510    33.855
>
    -5.050    33.270
    -5.051    33.271
>
    -5.035    33.295
    -5.035    33.295
>
    -4.418    34.369
    -4.418    34.369
>
    -4.952    34.108
    -4.952    34.108
>
    -4.953    34.088
    -4.953    34.088
>
    -4.931    34.079
    -4.931    34.079
>
    -4.990    34.085
    -4.990    34.086
>
    -5.491    32.304
    -5.491    32.304
>
    -3.680    33.848
    -3.681    33.847
>
    -5.335    32.417
    -5.335    32.417
>
    -5.741    32.139
    -5.743    32.138
>
    -6.789    31.261
    -6.788    31.262
>
    -5.124    33.082
    -5.124    33.083
>
    -6.628    33.993
    -6.627    33.993
>
    -4.750    34.175
    -4.750    34.174
>
    -4.688    34.251
    -4.688    34.252
>
    -4.747    34.220
    -4.749    34.220
>
    -4.714    34.177
    -4.715    34.177
>
    -4.207    33.554
    -4.207    33.554
>
    -5.818    33.634
    -5.818    33.634
>
    -5.167    32.950
    -5.168    32.950
>
    -5.122    32.944
    -5.122    32.944
>
    -5.771    33.559
    -5.771    33.559
>
    -5.727    34.357
    -5.727    34.357
>
    -5.807    33.795
    -5.807    33.795
>
    -5.737    33.363
    -5.737    33.364
>
    -3.494    34.375
    -3.493    34.376
>
    -4.801    32.596
    -4.801    32.596
>
    -5.812    33.759
    -5.808    33.760
>
    -6.693    33.108
    -6.691    33.109
>
    -5.769    33.655
    -5.769    33.656
>
    -5.236    32.959
    -5.236    32.959
>
    -5.835    32.167
    -5.836    32.167
>
    -4.453    33.599
    -4.453    33.599
>
    -4.886    34.043
    -4.886    34.044
>
    -4.109    33.729
    -4.109    33.729
>
    -4.975    34.110
    -4.974    34.110
>
    -5.112    31.826
    -5.112    31.827
>
    -4.860    33.386
    -4.860    33.386
>
    -5.004    33.525
    -5.004    33.525
>
    -3.626    32.225
    -3.625    32.226
>
    -5.012    33.529
    -5.013    33.530
>
    -4.916    33.469
    -4.915    33.469
>
    -4.934    33.502
    -4.936    33.500
>
    -4.931    33.520
    -4.932    33.520
>
    -4.860    33.555
    -4.860    33.555
>
    -5.578    32.399
    -5.578    32.400
>
    -5.609    32.385
    -5.609    32.386
>
    -4.754    32.530
    -4.754    32.530
>
    -4.702    33.504
    -4.701    33.505
>
    -5.088    33.154
    -5.087    33.154
>
    -5.833    34.008
    -5.833    34.008
>
    -4.469    33.438
    -4.469    33.439
>
    -4.592    33.454
    -4.593    33.455
>
    -4.934    33.485
    -4.933    33.485
>
    -5.944    33.686
    -5.943    33.686
>
    -4.773    34.368
    -4.773    34.368
>
    -3.802    34.311
    -3.801    34.312
>
    -4.941    33.534
    -4.941    33.534
>
    -4.700    34.316
    -4.700    34.316
>
    -4.812    34.366
    -4.812    34.367
>
    -4.905    33.520
    -4.905    33.520
>
    -4.968    33.477
    -4.960    33.477
>
    -3.948    33.391
    -3.948    33.392
>
    -5.808    32.093
    -5.808    32.094
>
    -5.593    34.000
    -5.592    34.000
>
    -4.971    33.474
    -4.971    33.474
>
    -5.250    33.039
    -5.250    33.039
>
    -5.673    32.430
    -5.673    32.431
>
    -5.878    33.730
    -5.878    33.730
>
    -5.951    33.751
    -5.951    33.751
>
    -3.506    34.042
    -3.506    34.042
>
    -5.447    32.791
    -5.447    32.792
>
    -5.901    33.789
    -5.902    33.787
>
    -5.801    33.749
    -5.801    33.749
>
    -6.107    33.410
    -6.107    33.411
>
    -5.407    32.469
    -5.407    32.470
>
    -5.607    32.728
    -5.607    32.729
>
    -5.517    34.425
    -5.517    34.425
>
    -5.632    32.322
    -5.632    32.323
>
    -4.654    34.232
    -4.654    34.232
>
    -5.651    32.336
    -5.651    32.336
>
    -5.824    32.354
    -5.824    32.355
>
    -5.698    32.139
    -5.698    32.139
>
    -5.712    32.800
    -5.712    32.800
>
    -4.917    33.531
    -4.917    33.531
>
    -4.662    32.628
    -4.663    32.628
>
    -5.917    32.165
    -5.917    32.165
>
    -6.527    33.230
    -6.527    33.230
>
    -6.115    33.307
    -6.114    33.308
>
    -6.073    33.190
    -6.073    33.190
>
    -4.231    33.519
    -4.232    33.519
>
    -6.520    31.796
    -6.501    31.777
>
    -5.754    33.762
    -5.752    33.763
>
    -4.222    33.524
    -4.222    33.525
>
    -5.886    33.705
    -5.886    33.705
>
    -6.775    31.234
    -6.775    31.234
>
    -6.424    33.313
    -6.424    33.313
>
    -6.374    33.307
    -6.373    33.307
>
    -5.479    32.471
    -5.479    32.471
>
    -5.080    33.003
    -5.080    33.004
>
    -4.823    32.352
    -4.825    32.353
>
    -5.486    34.043
    -5.486    34.043
>
    -5.983    33.598
    -5.983    33.598
>
    -4.398    34.361
    -4.398    34.361
>
    -3.882    33.764
    -3.880    33.764
>
    -5.177    32.977
    -5.177    32.977
>
    -5.064    34.135
    -5.064    34.136
>
    -4.569    32.482
    -4.569    32.482
>
    -6.103    33.404
    -6.103    33.405
>
    -5.785    34.007
    -5.785    34.007
>
    -4.032    33.803
    -4.032    33.803
>
    -5.364    32.347
    -5.364    32.348
>
    -6.166    32.382
    -6.166    32.383
>
    -5.478    34.027
    -5.478    34.027
>
    -5.768    33.990
    -5.767    33.990
>
    -5.887    33.736
    -5.887    33.736
>
    -6.338    33.234
    -6.338    33.234
>
    -6.283    33.332
    -6.282    33.333
>
    -6.349    33.291
    -6.349    33.291
>
    -5.320    32.798
    -5.320    32.798
>
    -6.321    33.288
    -6.321    33.288
>
    -6.369    33.258
    -6.371    33.259
>
    -4.716    33.929
    -4.716    33.929
>
    -6.526    33.245
    -6.527    33.246
>
    -5.928    33.698
    -5.928    33.698
>
    -5.544    32.679
    -5.544    32.680
>
    -5.564    32.696
    -5.563    32.696
>
    -5.890    33.692
    -5.891    33.691
>
    -5.537    32.665
    -5.537    32.665
>
    -5.837    34.297
    -5.837    34.297
>
    -5.796    34.325
    -5.796    34.325
>
    -4.206    32.626
    -4.207    32.626
>
    -4.213    32.637
    -4.213    32.638
>
    -4.233    32.638
    -4.232    32.639
>
    -4.307    32.542
    -4.310    32.540
>
    -4.197    32.660
    -4.197    32.660
>
    -4.240    32.612
    -4.239    32.612
>
    -4.246    32.615
    -4.246    32.616
>
    -3.628    33.551
    -3.628    33.551
>
    -4.343    34.346
    -4.343    34.346
>
    -6.626    33.869
    -6.627    33.870
>
    -6.211    32.006
    -6.209    32.004
>
    -6.535    33.980
    -6.536    33.980
>
    -5.527    32.636
    -5.527    32.636
>
    -5.290    32.954
    -5.291    32.954
>
    -4.232    32.641
    -4.232    32.642
>
    -4.310    32.588
    -4.310    32.588
>
    -4.352    32.592
    -4.352    32.592
>
    -5.715    34.266
    -5.715    34.266
>
    -5.382    32.394
    -5.382    32.395
>
    -5.726    34.274
    -5.726    34.274
>
    -4.926    33.549
    -4.926    33.549
>
    -5.768    34.232
    -5.768    34.232
>
    -5.565    34.281
    -5.565    34.282
>
    -5.766    34.291
    -5.766    34.291
>
    -5.472    32.398
    -5.472    32.400
>
    -5.586    34.315
    -5.585    34.315
>
    -5.963    33.731
    -5.963    33.731
>
    -4.117    33.499
    -4.117    33.499
>
    -4.969    34.309
    -4.969    34.310
>
    -4.936    34.332
    -4.936    34.332
>
    -4.933    34.313
    -4.933    34.313
>
    -4.932    34.308
    -4.932    34.308
>
    -4.632    32.574
    -4.631    32.574
>
    -4.917    34.315
    -4.918    34.316
>
    -5.761    34.266
    -5.761    34.266
>
    -5.783    34.263
    -5.783    34.264
>
    -6.176    33.211
    -6.175    33.212
>
    -5.731    31.929
    -5.732    31.930
>
    -3.739    33.666
    -3.740    33.667
>
    -4.700    33.469
    -4.700    33.470
>
    -5.617    34.228
    -5.617    34.229
>
    -3.646    34.112
    -3.646    34.112
>
    -6.512    31.766
    -6.517    31.766
>
    -5.355    33.029
    -5.355    33.029
>
    -5.829    32.417
    -5.829    32.417
>
    -5.358    32.777
    -5.358    32.778
>
    -6.053    33.331
    -6.054    33.332
>
    -6.492    31.493
    -6.492    31.493
>
    -5.333    32.900
    -5.334    32.900
>
    -6.008    33.675
    -6.008    33.675
>
    -4.929    34.343
    -4.928    34.343
>
    -5.235    34.034
    -5.235    34.034
>
    -5.223    34.209
    -5.223    34.209
>
    -5.408    32.351
    -5.409    32.351
>
    -6.094    33.441
    -6.094    33.441
>
    -5.183    34.245
    -5.182    34.246
>
    -5.781    34.013
    -5.781    34.013
>
    -3.706    34.048
    -3.707    34.048
>
    -3.668    34.037
    -3.669    34.037
>
    -3.515    34.044
    -3.516    34.044
>
    -6.004    33.351
    -6.005    33.351
>
    -6.050    33.471
    -6.050    33.472
>
    -5.217    34.224
    -5.218    34.224
>
    -5.386    32.326
    -5.385    32.325
>
    -5.829    33.941
    -5.829    33.941
>
    -6.339    32.138
    -6.338    32.139
>
    -3.988    33.851
    -3.988    33.850
>
    -5.168    33.188
    -5.168    33.188
>
    -5.165    34.280
    -5.164    34.279
>
    -5.213    34.224
    -5.212    34.224
>
    -6.929    33.048
    -6.930    33.048
>
    -5.734    32.419
    -5.732    32.418
>
    -6.689    31.352
    -6.690    31.351
>
    -3.538    34.018
    -3.538    34.018
>
    -4.173    33.086
    -4.173    33.087
>
    -5.363    32.931
    -5.363    32.931
>
    -4.103    33.097
    -4.104    33.098
>
    -5.788    32.176
    -5.789    32.176
>
    -5.236    34.188
    -5.236    34.188
>
    -5.499    33.327
    -5.500    33.327
>
    -5.004    32.381
    -5.004    32.381
>
    -5.611    31.589
    -5.611    31.589
>
    -5.067    31.650
    -5.067    31.650
>
    -5.251    32.797
    -5.251    32.797
>
    -6.060    32.075
    -6.059    32.075
>
    -6.271    31.798
    -6.271    31.815
>
    -5.593    34.258
    -5.593    34.258
>
    -5.588    34.260
    -5.588    34.260
>
    -6.239    32.138
    -6.239    32.139
>
    -3.802    33.643
    -3.802    33.643
>
    -6.292    32.081
    -6.293    32.081
>
    -6.170    32.241
    -6.171    32.241
>
    -6.144    32.243
    -6.144    32.243
>
    -3.751    33.766
    -3.750    33.766
>
    -3.790    33.729
    -3.790    33.729
>
    -5.272    34.043
    -5.270    34.044
>
    -3.864    33.680
    -3.863    33.680
>
    -6.044    31.380
    -6.044    31.380
>
    -5.200    32.300
    -5.200    32.300
>
    -3.721    33.746
    -3.722    33.746
>
    -5.116    32.912
    -5.116    32.912
>
    -3.923    33.628
    -3.924    33.628
>
    -6.473    31.927
    -6.473    31.928
>
    -5.799    32.192
    -5.801    32.193
>
    -6.076    33.406
    -6.076    33.407
>
    -6.559    33.039
    -6.559    33.039
>
    -4.978    33.144
    -4.977    33.144
>
    -4.541    34.391
    -4.540    34.391
>
    -4.462    34.337
    -4.462    34.337
>
    -4.356    33.793
    -4.355    33.793
>
    -5.864    33.067
    -5.864    33.068
>
    -3.964    33.454
    -3.964    33.454
>
    -4.152    33.600
    -4.153    33.601
>
    -4.087    33.576
    -4.089    33.577
>
    -5.415    33.988
    -5.415    33.988
>
    -6.263    31.978
    -6.263    31.978
>
    -4.739    34.094
    -4.739    34.094
>
    -5.905    32.278
    -5.907    32.278
>
    -3.566    32.657
    -3.566    32.657
>
    -3.293    33.986
    -3.293    33.986
>
    -4.187    33.903
    -4.186    33.903
>
    -5.434    34.418
    -5.434    34.418
>
    -5.680    33.665
    -5.679    33.665
>
    -5.103    32.998
    -5.103    32.999
>
    -5.548    34.281
    -5.549    34.281
>
    -5.416    33.657
    -5.415    33.657
>
    -4.441    34.288
    -4.441    34.288
>
    -5.386    32.306
    -5.388    32.307
>
    -6.578    33.065
    -6.578    33.065
>
    -6.403    31.968
    -6.403    31.968
>
    -5.924    33.804
    -5.924    33.804
>
    -5.137    33.159
    -5.137    33.160
>
    -4.757    34.021
    -4.758    34.021
>
    -5.920    34.129
    -5.921    34.129
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    -6.179    31.399   -16.500     4.570     8.174
    -3.736    34.260   -56.808     3.040     9.202
    -5.111    34.263    77.345     6.596     8.483
    -5.209    34.128   -28.605     3.338     5.056
    -4.014    33.791    43.310     4.675    10.600
    -5.239    33.353    40.940     2.842     4.723
    -5.315    32.935    25.712     6.088     9.042
    -5.353    32.939    17.811     4.798     7.307
    -5.307    31.916   -19.264     2.425     2.965
    -4.280    31.230    -7.342     1.899     2.370
    -4.327    31.235   -15.948     2.147     2.566
    -4.982    33.173    18.527     2.522     5.119
    -3.222    34.324    68.358     5.437     8.664
    -3.292    34.281    60.681     5.120     9.327
    -4.812    34.139    17.680     3.351     6.684
    -5.079    34.164    11.242     3.138     6.400
    -5.100    33.243     4.760     2.006     2.835
    -4.907    34.329     2.098     4.467     7.160
    -4.796    34.116   -12.950     2.226     4.287
    -4.242    33.681    68.558     4.453     5.553
    -5.461    32.874    81.186     4.338     5.583
    -5.370    32.759    57.530     5.027     5.720
    -5.429    32.645   -30.544     5.285     5.926
    -5.747    33.939   -59.136     3.566     5.733
    -5.259    33.961   -23.836     3.427     5.914
    -5.132    34.104   -67.634     2.095     3.606
    -5.928    33.857   -32.450     5.653     7.435
    -6.341    34.170   -60.875     2.262     2.750
    -5.013    34.087    -9.613     3.943     4.709
    -5.429    33.997   -10.555     8.807    15.185
    -5.806    33.665    -5.826     5.344     8.070
    -4.265    34.444    38.968     6.773     7.882
    -5.555    33.594    41.860     2.739     4.315
    -4.854    34.083    21.684     2.957     5.048
    -4.782    34.105    17.864     5.402     9.005
    -6.124    32.439    21.959     2.369     2.989
    -6.066    32.438    39.855     4.158     5.261
    -5.197    33.019   -26.613     2.098     5.292
    -5.383    32.747   -28.944     1.843     3.941
    -6.202    33.849   -51.100     4.357     5.221
    -5.518    31.686   -66.918     3.435     8.165
    -5.879    33.726    -2.837     4.991     6.138
    -5.580    31.928   -59.385     2.961     8.143
    -4.709    34.286    13.924     3.693     8.811
    -4.774    34.279    14.777     3.784     7.916
    -5.729    33.540   -13.518     4.594     8.225
    -3.562    32.549    33.182     2.709     4.836
    -5.166    33.035    32.815     4.486     5.954
    -3.542    32.613    63.716     2.317     2.978
    -4.348    34.213    -0.696     4.819     5.205
    -5.154    32.842   -24.031     1.654     4.567
    -4.303    34.026    -9.534     3.515     8.008
    -5.457    33.983   -25.288     4.349    10.076
    -4.687    34.277     0.869     4.150     6.309
    -5.583    34.246     9.201     1.650     2.311
    -5.788    32.218   -54.484     2.146     3.928
    -5.197    33.105     9.750     1.252     1.477
    -5.336    34.215   -12.736     2.070     7.062
    -5.846    32.063    41.447     2.512     2.979
    -6.431    31.894    27.379     1.594     3.913
    -6.161    32.092   -53.944     2.232     4.665
    -6.166    32.068    76.716     2.711     3.975
    -5.806    32.155   -53.531     2.318     5.316
    -5.331    32.969   -28.801     1.659     3.331
    -4.235    33.684    -0.401     2.705     7.690
    -4.638    32.596   -28.275     2.184     5.021
    -5.938    33.728   -20.159     3.364     5.502
    -6.243    32.250   -49.637     3.306     6.842
    -5.781    32.358   -44.529     2.713     5.000
    -5.794    33.597   -23.657     5.157     9.357
    -5.808    33.606    22.022     1.828     2.692
    -6.047    32.274   -48.622     3.173     7.154
    -5.269    33.099   -26.992     1.642     4.273
    -5.406    32.408   -42.944     1.656     4.713
    -5.625    32.322   -50.127     2.507     6.135
    -6.157    32.088   -52.975     2.279     6.334
    -5.355    32.242   -55.427     3.075    10.026
    -5.015    34.005    -2.915     3.290     7.089
    -4.840    33.993   -16.397     2.899     9.407
    -5.983    31.997    75.784     1.847     1.917
    -5.367    32.903    34.271     3.116     4.407
    -3.577    33.869     1.493     2.840     6.751
    -6.605    31.927    59.924     7.747    11.742
    -6.202    32.277   -48.337     2.221     4.568
    -4.402    33.692   -15.448     2.651     9.909
    -5.268    33.507     5.835     4.605    10.012
    -5.600    34.147   -22.109     2.140     9.171
    -5.341    32.442   -42.481     1.949     4.759
    -6.209    32.094   -54.346     2.466     7.621
    -6.278    32.358    61.781     5.197     5.542
    -4.237    34.314    14.086     3.343     4.897
    -5.791    32.201   -29.648     1.653     1.777
    -3.569    32.129   -68.418     3.004     3.746
    -5.251    34.245    68.165     1.876     4.107
    -6.811    31.739    48.923     2.732     7.057
    -6.337    32.079   -52.486     3.228     7.258
    -5.213    32.938   -25.945     2.042     4.732
    -5.850    33.720   -27.899     5.943     8.000
    -6.193    32.301    40.247     5.407     9.898
    -5.884    32.000    21.072     1.715     2.258
    -5.719    32.010   -61.960     3.235     6.731
    -5.277    32.619   -38.479     2.689     4.554
    -5.134    32.495   -37.633     1.259     4.212
    -5.798    32.137   -53.259     2.050     5.625
    -5.323    32.794   -32.751     2.068     4.443
    -4.629    33.246   -13.337     1.995     6.226
    -5.228    34.269    -6.085     4.837     9.301
    -6.473    33.954   -10.332     3.864     6.590
    -6.219    32.043   -88.191     2.137     3.539
    -6.391    33.934    -6.843     4.827     9.038
    -6.935    32.187   -40.447     6.629    10.325
    -5.893    33.858    59.181     9.102    10.386
    -5.750    32.228   -51.124     2.825     6.995
    -5.580    34.003   -14.719     4.717     7.911
    -5.317    33.690   -30.653     4.894     9.182
    -5.218    34.103   -25.161     3.105     4.524
    -4.866    33.960     2.379     4.471     6.539
    -6.886    34.242   -17.941     5.921     9.260
    -5.234    32.850   -66.889     4.691     6.288
    -5.545    32.432   -72.519     1.965     3.636
    -4.948    34.132    15.390     3.538     5.083
    -4.510    33.855   -55.766     2.637     6.225
    -5.051    33.271   -43.190     1.276     1.964
    -5.035    33.295    -4.807     1.876     3.189
    -4.418    34.369    -4.512     4.561     6.481
    -4.952    34.108    -8.954     3.598     4.874
    -4.953    34.088    -9.995     2.612     5.162
    -4.931    34.079    -7.770     3.066     6.400
    -4.990    34.086    10.826     4.058     9.197
    -5.491    32.304   -64.855     2.201     5.592
    -3.681    33.847   -57.688     3.070     4.111
    -5.335    32.417   -63.429     1.885     4.243
    -5.743    32.138    88.312     2.551     4.052
    -6.788    31.262   -79.748     6.209     8.293
    -5.124    33.083   -49.231     2.751     4.156
    -6.627    33.993    -7.298     2.140     4.021
    -4.750    34.174    84.226     3.749     4.855
    -4.688    34.252   -18.141     1.752     2.607
    -4.749    34.220    11.021     2.050     3.963
    -4.715    34.177     7.240     3.758     6.550
    -4.207    33.554    19.431     2.511     5.493
    -5.818    33.634   -48.039     4.481     9.920
    -5.168    32.950   -39.922     2.870     4.230
    -5.122    32.944   -41.341     3.883     7.496
    -5.771    33.559   -34.789     3.267     6.690
    -5.727    34.357   -25.413     3.007     6.835
    -5.807    33.795   -30.970     3.460     8.267
    -5.737    33.364    -4.527     2.750     4.186
    -3.493    34.376   -38.422     1.567     5.616
    -4.801    32.596     1.217     4.110     7.537
    -5.808    33.760   -30.523     2.844     7.800
    -6.691    33.109   -11.703     3.761     5.303
    -5.769    33.656   -59.828     2.600     5.130
    -5.236    32.959   -44.561     2.972     4.866
    -5.836    32.167   -63.067     3.937     4.583
    -4.453    33.599   -25.719     6.434     8.710
    -4.886    34.044   -71.326     1.970     2.691
    -4.109    33.729    10.363     2.164     2.837
    -4.974    34.110    -9.968     3.438     6.615
    -5.112    31.827   -13.527     3.627     5.659
    -4.860    33.386   -32.194     2.628     4.172
    -5.004    33.525    29.989     1.420     1.946
    -3.625    32.226    66.970     3.015     6.320
    -5.013    33.530    27.557     1.573     2.692
    -4.915    33.469    -7.934     3.686     7.503
    -4.936    33.500   -16.459     2.664     3.049
    -4.932    33.520    -7.392     2.640     4.542
    -4.860    33.555    -8.842     3.451     6.037
    -5.578    32.400    -3.094     2.323     4.376
    -5.609    32.386    -1.752     2.049     3.690
    -4.754    32.530   -51.613     2.823     3.369
    -4.701    33.505    10.978     2.611     4.939
    -5.087    33.154   -33.624     3.533     6.834
    -5.833    34.008   -23.073     3.144     4.957
    -4.469    33.439    13.103     4.641     7.142
    -4.593    33.455     2.277     3.376     4.859
    -4.933    33.485    -1.363     3.175     5.344
    -5.943    33.686   -29.301     4.312     4.906
    -4.773    34.368     8.929     3.912     7.136
    -3.801    34.312     8.930     1.600     4.665
    -4.941    33.534    -6.035     2.232     3.930
    -4.700    34.316     9.920     2.122     4.628
    -4.812    34.367    19.426     1.510     5.788
    -4.905    33.520    -9.998     4.289     8.062
    -4.960    33.477   -19.056     3.880     7.210
    -3.948    33.392   -52.762     1.722     4.069
    -5.808    32.094    -8.217     2.084     4.237
    -5.592    34.000   -42.853     5.002     7.678
    -4.971    33.474    40.481     2.954     5.376
    -5.250    33.039   -46.353     2.861     4.261
    -5.673    32.431    88.523     2.643     2.863
    -5.878    33.730   -35.379     3.584     6.074
    -5.951    33.751   -35.088     4.202     8.217
    -3.506    34.042   -33.604     2.623     3.665
    -5.447    32.792   -62.166     1.989     5.642
    -5.902    33.787    30.643     3.763     4.721
    -5.801    33.749   -48.926     2.231     5.891
    -6.107    33.411     0.638     2.120     4.333
    -5.407    32.470    -3.815     1.888     3.815
    -5.607    32.729   -48.803     2.363     3.041
    -5.517    34.425   -22.202     3.805     7.514
    -5.632    32.323   -67.099     2.211     6.229
    -4.654    34.232     2.825     2.710     4.754
    -5.651    32.336    84.179     4.337     7.261
    -5.824    32.355    80.914     2.853     4.362
    -5.698    32.139   -41.527     3.258     4.889
    -5.712    32.800   -35.831     2.656     4.135
    -4.917    33.531   -15.151     2.892     5.291
    -4.663    32.628    -4.964     4.979    10.306
    -5.917    32.165   -38.853     2.535     3.521
    -6.527    33.230   -42.785     3.348     4.495
    -6.114    33.308    -1.086     2.820     5.003
    -6.073    33.190    13.384     2.753     5.416
    -4.232    33.519   -51.221     2.056     4.993
    -6.501    31.777    41.699     3.026     5.002
    -5.752    33.763   -38.111     3.744     5.377
    -4.222    33.525    28.123     3.529     4.870
    -5.886    33.705   -39.385     3.506     5.271
    -6.775    31.234   -27.951     7.544     8.984
    -6.424    33.313   -52.365     2.976     5.836
    -6.373    33.307   -53.545     2.833     4.424
    -5.479    32.471    36.989     3.454     6.312
    -5.080    33.004   -16.158     3.298     4.115
    -4.825    32.353     3.902     2.917     8.572
    -5.486    34.043   -27.491     2.934     6.433
    -5.983    33.598     1.856     1.812     3.074
    -4.398    34.361    -1.152     3.496     5.380
    -3.880    33.764    16.346     3.594     5.521
    -5.177    32.977   -26.822     2.812     4.135
    -5.064    34.136    -8.632     2.644     3.993
    -4.569    32.482   -73.498     1.221     1.485
    -6.103    33.405    -2.842     2.281     5.619
    -5.785    34.007   -26.196     2.510     4.655
    -4.032    33.803    32.339     3.350     4.960
    -5.364    32.348   -69.009     1.915     3.856
    -6.166    32.383    -5.755     3.852     4.742
    -5.478    34.027   -12.804     2.664     4.446
    -5.767    33.990   -27.585     2.919     5.802
    -5.887    33.736   -31.946     3.810     6.319
    -6.338    33.234   -41.630     5.266     8.442
    -6.282    33.333   -51.664     3.733     8.647
    -6.349    33.291   -41.096     3.836     6.618
    -5.320    32.798   -40.800     2.646     3.129
    -6.321    33.288    -3.639     2.923     5.576
    -6.371    33.259    -0.903     1.907     4.399
    -4.716    33.929    -3.673     2.530     4.779
    -6.527    33.246   -18.925     3.324     4.745
    -5.928    33.698   -38.660     3.970     5.481
    -5.544    32.680     2.791     2.171     2.427
    -5.563    32.696    22.145     2.023     2.519
    -5.891    33.691    -3.193     2.200     3.947
    -5.537    32.665    21.508     1.880     2.896
    -5.837    34.297   -27.579     3.114     5.585
    -5.796    34.325   -17.557     3.048     7.345
    -4.207    32.626   -85.601     1.276     1.584
    -4.213    32.638     8.916     3.251     4.570
    -4.232    32.639    20.051     2.735     4.270
    -4.310    32.540   -65.744     2.374     4.979
    -4.197    32.660     8.379     3.000     4.083
    -4.239    32.612    13.258     2.659     4.568
    -4.246    32.616    16.514     2.629     4.388
    -3.628    33.551   -46.811     1.568     3.198
    -4.343    34.346    -0.715     2.507     4.482
    -6.627    33.870    -4.531     3.511     5.653
    -6.209    32.004    51.579     2.469     5.618
    -6.536    33.980   -36.701     3.413     5.606
    -5.527    32.636    35.171     4.130     4.352
    -5.291    32.954   -20.917     2.135     2.842
    -4.232    32.642   -83.435     1.411     1.972
    -4.310    32.588   -65.101     1.559     2.574
    -4.352    32.592   -61.677     2.176     5.598
    -5.715    34.266   -28.615     2.594     5.528
    -5.382    32.395     0.733     2.247     4.298
    -5.726    34.274   -23.970     2.749     5.206
    -4.926    33.549    -4.502     2.392     3.764
    -5.768    34.232   -28.316     1.937     3.554
    -5.565    34.282   -26.905     2.520     5.298
    -5.766    34.291   -23.626     1.574     2.532
    -5.472    32.400   -63.237     2.106     3.982
    -5.585    34.315   -26.416     3.112     6.846
    -5.963    33.731   -33.382     2.069     2.982
    -4.117    33.499    17.484     4.472     8.684
    -4.969    34.310   -55.689     1.962     2.112
    -4.936    34.332    -7.603     2.338     4.710
    -4.933    34.313   -10.733     3.546     6.749
    -4.932    34.308     3.008     3.906     5.452
    -4.631    32.574     3.803     3.751     7.195
    -4.918    34.316    -6.678     4.050     6.888
    -5.761    34.266   -20.156     2.037     3.035
    -5.783    34.264   -22.667     3.386     5.307
    -6.175    33.212   -38.858     3.333     4.738
    -5.732    31.930   -26.171     4.386     4.585
    -3.740    33.667    29.895     2.401     3.514
    -4.700    33.470     6.489     2.366     4.510
    -5.617    34.229   -17.713     2.534     4.307
    -3.646    34.112    19.422     1.716     6.258
    -6.517    31.766     9.971     2.355     3.375
    -5.355    33.029   -46.131     2.616     4.697
    -5.829    32.417   -64.879     2.003     2.505
    -5.358    32.778   -39.318     3.322     3.938
    -6.054    33.332   -69.968     7.096     9.625
    -6.492    31.493    31.266     1.802     4.118
    -5.334    32.900   -47.815     2.579     3.208
    -6.008    33.675   -48.752     3.517     5.273
    -4.928    34.343    -7.306     2.757     5.085
    -5.235    34.034   -11.602     2.239     4.140
    -5.223    34.209   -12.748     3.035     4.506
    -5.409    32.351    24.125     2.703     4.659
    -6.094    33.441    -3.305     2.404     4.363
    -5.182    34.246   -21.284     3.491     7.437
    -5.781    34.013   -26.300     2.325     3.787
    -3.707    34.048    16.065     3.674     7.006
    -3.669    34.037    10.344     2.130     6.752
    -3.516    34.044     8.044     2.165     8.626
    -6.005    33.351   -55.963     3.233     5.792
    -6.050    33.472    -0.260     3.466     6.738
    -5.218    34.224   -20.227     2.928     5.415
    -5.385    32.325    23.600     3.386     5.768
    -5.829    33.941   -32.169     2.131     3.339
    -6.338    32.139    15.017     3.000     4.888
    -3.988    33.850    22.983     5.241     9.479
    -5.168    33.188    -5.730     2.008     3.510
    -5.164    34.279    29.515     4.060     5.673
    -5.212    34.224    -9.475     3.747     6.258
    -6.930    33.048   -26.591     5.089     6.007
    -5.732    32.418   -11.546     4.145     4.904
    -6.690    31.351    30.769     2.201     5.114
    -3.538    34.018    19.710     1.525     3.818
    -4.173    33.087   -73.033     1.391     1.491
    -5.363    32.931   -33.534     2.989     3.669
    -4.104    33.098    41.444     5.438     8.069
    -5.789    32.176    25.647     1.514     2.737
    -5.236    34.188   -10.872     2.596     5.109
    -5.500    33.327    -8.214     5.362     6.897
    -5.004    32.381   -63.726     1.998     3.639
    -5.611    31.589   -73.299     4.857     5.179
    -5.067    31.650    30.678     2.126     4.213
    -5.251    32.797    69.663     3.226     4.238
    -6.059    32.075   -14.870     3.059     3.848
    -6.271    31.815   -10.694     2.529     4.731
    -5.593    34.258   -20.382     2.303     3.572
    -5.588    34.260   -27.115     2.418     4.379
    -6.239    32.139    16.212     1.883     3.771
    -3.802    33.643    17.957     4.081     8.286
    -6.293    32.081    15.657     1.644     3.683
    -6.171    32.241    18.241     1.954     3.442
    -6.144    32.243    15.697     1.635     3.916
    -3.750    33.766    26.185     4.190     6.624
    -3.790    33.729   -45.909     1.699     3.897
    -5.270    34.044   -17.005     2.197     3.749
    -3.863    33.680    27.378     4.002     6.694
    -6.044    31.380    33.024     2.589     5.485
    -5.200    32.300    27.468     3.109     4.982
    -3.722    33.746   -47.950     1.539     2.926
    -5.116    32.912   -28.247     2.694     3.553
    -3.924    33.628   -50.118     1.702     3.253
    -6.473    31.928    -2.077     4.942     6.713
    -5.801    32.193     4.232     1.578     2.680
    -6.076    33.407    -0.913     2.389     3.909
    -6.559    33.039   -35.313     2.578     3.606
    -4.977    33.144   -17.836     2.265     4.111
    -4.540    34.391    21.311     5.506     7.828
    -4.462    34.337     1.325     3.273     4.903
    -4.355    33.793    19.429     3.990     6.281
    -5.864    33.068   -48.875     2.184     2.799
    -3.964    33.454   -53.438     1.435     2.773
    -4.153    33.601    16.395     2.158     4.850
    -4.089    33.577    20.946     2.692     4.669
    -5.415    33.988   -23.621     2.398     3.897
    -6.263    31.978    21.511     2.314     4.707
    -4.739    34.094    -7.409     2.752     4.876
    -5.907    32.278     7.825     1.331     2.926
    -3.566    32.657    22.268     2.338     5.013
    -3.293    33.986    13.605     1.837     5.310
    -4.186    33.903     6.262     2.901     5.086
    -5.434    34.418   -27.210     2.987     8.235
    -5.679    33.665    -6.390     4.016     6.664
    -5.103    32.999   -39.557     4.571     5.282
    -5.549    34.281   -24.261     3.821     6.197
    -5.415    33.657   -27.419     3.072     5.197
    -4.441    34.288     5.399     3.361     5.651
    -5.388    32.307    25.066     2.248     4.234
    -6.578    33.065     3.914     1.723     3.266
    -6.403    31.968    42.340     2.096     2.959
    -5.924    33.804   -38.225     6.254     8.100
    -5.137    33.160   -37.125     1.602     3.504
    -4.758    34.021    11.913     4.336     5.244
    -5.921    34.129    21.300     5.731     7.279
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    -6.972    31.182    12.886     0.790     0.990
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    -6.950    31.182   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    -6.972    31.182     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    -6.972    31.182     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    -6.972    31.137   5 km
EOF
gmt end
