#!/bin/bash
gmt begin elmayor5.35_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases elmayor5.35'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     0.500     2.612
     1.000    -0.791
     1.500    -4.194
     2.000    -7.597
     2.500   -11.000
     3.000   -14.403
     3.500   -17.806
     4.000   -21.212
     4.500   -24.621
     5.000   -28.030
     5.500   -31.443
     6.000   -34.858
     6.500   -38.276
     7.000   -41.696
     7.500   -45.120
     8.000   -48.546
     8.500   -51.976
     9.000   -55.410
     9.500   -58.849
    10.000   -62.291
    10.500   -65.739
    11.000   -69.191
    11.500   -72.648
    12.000   -76.110
    12.500   -79.578
    13.000   -83.156
    13.500   -86.879
    14.000   -90.608
    14.500   -94.338
    15.000   -98.072
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -80.156 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.406
     1.000    -0.026
     1.500    -0.459
     2.000    -0.891
     2.500    -1.324
     3.000    -1.759
     3.500    -2.195
     4.000    -2.633
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -5.633 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.793     0.253     0.200
     7.445     4.263     0.200
     7.475     1.333     0.200
     8.343     1.379     0.200
     8.419     5.372     0.200
     7.789    -2.361     0.200
    11.321     5.245     0.200
     3.754     0.199     0.200
     8.342     1.034     0.200
     7.335    -1.038     0.200
     7.718    -0.473     0.200
    11.286     2.961     0.200
    15.912     0.711     0.200
     2.594    -1.213     0.200
     3.723    -0.872     0.200
     4.674     1.151     0.200
     6.482     0.151     0.200
     7.678     0.028     0.200
     8.004     6.234     0.200
    11.300     2.778     0.200
     4.140    -2.556     0.200
     4.479     1.583     0.200
     7.343    -2.224     0.200
     7.699    -1.083     0.200
     7.904    -3.004     0.200
     8.111     2.000     0.200
     8.590     2.774     0.200
     9.414     4.048     0.200
    10.981     0.248     0.200
    11.259     2.475     0.200
    23.974    -7.588     0.200
    26.268    -4.721     0.200
     6.455     3.673     0.200
    10.472    -1.978     0.200
    10.990     2.193     0.200
     2.619     1.239     0.200
     2.884    -0.724     0.200
     3.558     1.814     0.200
     3.618     3.256     0.200
     4.126    -1.108     0.200
     4.482     2.147     0.200
     5.813     3.182     0.200
     6.932     2.510     0.200
     2.890    -1.901     0.200
     3.618    -0.735     0.200
     3.851     2.919     0.200
     4.495     1.202     0.200
     5.344    -0.395     0.200
    11.271     0.506     0.200
    26.286    -4.011     0.200
     3.846     1.369     0.200
     7.346     2.265     0.200
     7.698     3.300     0.200
    10.494    -1.855     0.200
     2.629     0.522     0.200
     3.834     2.499     0.200
     4.143    -0.767     0.200
     7.345     0.331     0.200
     7.789     0.329     0.200
     8.281     1.743     0.200
     7.796    -3.685     0.200
     8.283    -1.500     0.200
     2.622     3.572     0.200
     2.881    -0.314     0.200
     3.613    -1.284     0.200
     3.853     1.247     0.200
     4.125     0.146     0.200
     4.489     2.867     0.200
     6.569    -1.159     0.200
     6.622     2.184     0.200
     7.353     0.969     0.200
     7.602     1.648     0.200
     7.704     1.952     0.200
     7.933     2.153     0.200
     7.986     2.189     0.200
     8.103     6.008     0.200
     8.579     2.942     0.200
     8.653     2.807     0.200
     9.427     2.735     0.200
    10.495    -2.611     0.200
    22.892    -3.992     0.200
     2.627    -0.852     0.200
     5.547    -2.007     0.200
     6.574    -2.626     0.200
     6.932    -3.544     0.200
     7.360    -2.993     0.200
     7.489     0.078     0.200
     7.608    -0.381     0.200
     7.711    -3.761     0.200
     7.810    -6.109     0.200
     7.810    -5.580     0.200
     7.919    -1.506     0.200
     7.939     0.180     0.200
     8.278    -4.494     0.200
     8.485    -0.237     0.200
     9.425     4.897     0.200
     6.489     0.537     0.200
     8.326    -4.521     0.200
     3.253     1.834     0.200
    10.407     0.740     0.200
     2.856     3.832     0.200
     6.788     0.802     0.200
     7.517    -1.955     0.200
     7.897    -0.387     0.200
     8.507    -1.003     0.200
     3.791    -1.520     0.200
     4.128    -0.541     0.200
     7.038    -0.817     0.200
     7.367    -0.559     0.200
     7.656     0.716     0.200
     7.778    -4.430     0.200
     7.939    -5.304     0.200
    11.320     2.334     0.200
     6.302     5.610     0.200
     3.002    -1.363     0.200
     4.526    -1.696     0.200
     5.637    -3.050     0.200
     6.653    -3.427     0.200
     7.386    -4.728     0.200
     7.788    -5.054     0.200
    10.408    -3.491     0.200
    11.224    -2.045     0.200
    11.346    -1.524     0.200
    10.735     1.126     0.200
    10.436    -1.837     0.200
    15.934    -0.056     0.200
     4.137     1.398     0.200
     7.801    -1.311     0.200
    10.431    -0.389     0.200
     3.865     0.181     0.200
    10.442    -2.245     0.200
     6.144     0.512     0.200
     7.977    -3.545     0.200
     8.069    -2.371     0.200
    10.801    -2.598     0.200
    11.171     1.658     0.200
     2.725    -0.762     0.200
     3.844     2.069     0.200
     5.647     1.885     0.200
     6.499    -2.028     0.200
     3.055     2.354     0.200
     3.112    -1.403     0.200
     3.678    -1.617     0.200
     4.100    -0.129     0.200
     5.555     4.819     0.200
     5.951     4.034     0.200
     6.209     3.307     0.200
     6.975     2.658     0.200
     7.266     1.618     0.200
     7.663    -4.058     0.200
     7.674    -0.609     0.200
     7.766     3.945     0.200
     7.849     2.642     0.200
     8.333     0.438     0.200
    10.312    -2.168     0.200
     7.708    -2.289     0.200
    10.388    -2.685     0.200
    10.402    -1.702     0.200
     5.577     1.610     0.200
     7.715     2.287     0.200
    10.359    -2.411     0.200
     7.832    -1.479     0.200
     8.439    -1.750     0.200
    10.421     0.589     0.200
     6.051     1.151     0.200
     7.831    -4.198     0.200
     2.994    -1.110     0.200
     3.788     0.647     0.200
     4.141     1.603     0.200
     8.373     1.957     0.200
    10.409    -0.795     0.200
     7.844     0.962     0.200
     8.455     0.301     0.200
    10.425     0.370     0.200
     3.090     0.133     0.200
     6.359     0.473     0.200
     6.904    -0.434     0.200
     7.911    -3.528     0.200
     2.548     0.535     0.200
     3.115    -0.337     0.200
    11.479     0.266     0.200
     6.682     6.200     0.200
     9.189     3.880     0.200
    10.399    -2.551     0.200
     6.586     4.825     0.200
     8.452     0.277     0.200
    10.491    -4.557     0.200
     8.307     0.963     0.200
    10.677    -4.187     0.200
     4.561     2.482     0.200
     7.007     4.562     0.200
     7.007     4.558     0.200
    10.128    -3.826     0.200
    16.384    -2.553     0.200
    23.186    -2.559     0.200
     4.658    -1.079     0.200
     7.844    -1.739     0.200
     8.592    -2.556     0.200
    10.338    -6.132     0.200
    23.113    -6.500     0.200
     3.793    -1.198     0.200
     4.618    -1.632     0.200
     5.778    -2.833     0.200
     7.472    -1.650     0.200
     2.548    -1.504     0.200
     2.853     0.138     0.200
     4.667     0.650     0.200
     5.530    -1.075     0.200
     5.608     3.360     0.200
     6.196     0.148     0.200
     6.630    -0.966     0.200
     7.538    -1.728     0.200
     7.647     3.419     0.200
     8.067    -3.564     0.200
     8.090     1.344     0.200
     8.159    -1.379     0.200
     8.159    -1.724     0.200
    10.866    -2.070     0.200
     4.021    -2.101     0.200
     4.474     5.582     0.200
     5.561     2.655     0.200
     5.579     1.880     0.200
     6.753    -1.138     0.200
     7.515     0.546     0.200
     8.023    -3.515     0.200
     8.058    -2.889     0.200
     8.242    -4.880     0.200
    10.746    -4.267     0.200
     2.805    -0.748     0.200
     3.909     0.908     0.200
     4.662     0.201     0.200
     5.303    -0.569     0.200
     5.500     1.294     0.200
     5.717     2.841     0.200
     6.752     0.915     0.200
     7.533     2.130     0.200
     7.880     0.674     0.200
    10.903    -2.959     0.200
     4.352    -0.569     0.200
     6.354    -0.959     0.200
     4.642    -1.113     0.200
     5.900     3.104     0.200
     7.510    -3.228     0.200
     7.703    -1.126     0.200
    10.676    -4.196     0.200
     3.041     4.517     0.200
     3.317    -0.584     0.200
     3.659     2.577     0.200
     3.989    -1.770     0.200
     4.591    -2.005     0.200
     5.688     5.642     0.200
     6.280     3.758     0.200
     6.318     3.089     0.200
     7.133     4.461     0.200
     7.445     4.058     0.200
     7.495     2.935     0.200
     7.773    -2.470     0.200
     7.907     2.734     0.200
     8.276     5.265     0.200
    10.193    -5.338     0.200
    11.580     1.626     0.200
    23.135    -3.216     0.200
     2.533    -0.146     0.200
     3.906     0.008     0.200
     5.612     1.309     0.200
     5.714     3.754     0.200
     6.145     1.842     0.200
     8.102    -2.437     0.200
     3.647     0.898     0.200
     3.864     0.250     0.200
     4.607     2.630     0.200
     5.488     3.812     0.200
     5.697    -0.711     0.200
     6.041     3.968     0.200
     6.577     2.566     0.200
     7.468     2.233     0.200
     8.431    -2.500     0.200
     6.098     1.569     0.200
     8.073    -2.701     0.200
     6.141     0.048     0.200
    10.896    -1.836     0.200
    11.245    -1.110     0.200
     7.855    -5.545     0.200
     7.824    -0.883     0.200
     8.585     1.185     0.200
    10.321    -2.394     0.200
     3.011    -1.310     0.200
     3.284    -1.536     0.200
     4.556    -1.953     0.200
     5.663    -1.284     0.200
     5.877    -1.286     0.200
     6.288     2.432     0.200
     6.851     2.119     0.200
     7.777    -4.849     0.200
     8.252    -0.062     0.200
     8.669     0.026     0.200
     3.855    -1.185     0.200
     4.252    -0.244     0.200
     2.839    -1.080     0.200
     3.802    -2.248     0.200
     3.934    -2.268     0.200
     5.745    -0.326     0.200
     6.183    -0.544     0.200
     6.566    -2.620     0.200
     7.533    -3.162     0.200
     8.061    -5.470     0.200
     8.147    -1.819     0.200
     2.613    -1.461     0.200
     4.242    -1.054     0.200
     5.543    -0.507     0.200
     5.605     1.260     0.200
     6.125     0.082     0.200
     8.096     0.169     0.200
     7.876    -4.221     0.200
    10.413    -1.200     0.200
     7.755    -2.380     0.200
    10.193     0.440     0.200
     2.556     0.651     0.200
     3.920     0.438     0.200
     3.973    -0.950     0.200
     4.192    -0.289     0.200
     5.302     1.458     0.200
     8.066    -5.337     0.200
     4.046     0.682     0.200
     5.724     5.548     0.200
     7.504    -3.597     0.200
     7.761     0.281     0.200
     8.746     2.682     0.200
     8.051    -0.305     0.200
    11.012    -4.366     0.200
     8.726    -0.482     0.200
    10.203    -2.270     0.200
     4.290     0.081     0.200
     4.339    -2.319     0.200
     7.509     1.538     0.200
    10.394    -4.653     0.200
    10.394    -4.649     0.200
    11.474     5.063     0.200
     2.775    -0.784     0.200
     5.457     0.324     0.200
     5.533    -1.256     0.200
     5.578     1.406     0.200
     5.678     1.128     0.200
     6.732     1.355     0.200
     7.406     3.563     0.200
     7.493    -6.843     0.200
     7.580     0.771     0.200
     7.712    -2.679     0.200
     8.017    -2.919     0.200
     8.080    -1.429     0.200
     8.072    -0.834     0.200
    10.876    -2.522     0.200
     3.814     3.112     0.200
     4.214     0.621     0.200
     5.764     3.726     0.200
     6.675     3.539     0.200
     7.487    -0.020     0.200
     7.854    -4.193     0.200
     8.882     7.168     0.200
     9.738     2.631     0.200
    11.471     2.084     0.200
    13.224    -4.288     0.200
    23.072    -5.049     0.200
    10.496     0.654     0.200
     7.891    -4.870     0.200
     8.537    -4.777     0.200
    10.422    -3.349     0.200
     6.066    -2.102     0.200
     3.796    -1.754     0.200
     7.844    -3.821     0.200
     8.534    -5.186     0.200
    11.481     1.427     0.200
    11.481     1.427     0.200
     3.880    -1.669     0.200
     5.271     0.765     0.200
     5.584     0.321     0.200
     5.690    -0.298     0.200
     6.565    -0.779     0.200
     8.077    -5.765     0.200
     8.077    -2.858     0.200
    10.892    -0.894     0.200
     6.387     0.661     0.200
     8.434    -0.157     0.200
    10.455    -3.191     0.200
     7.720     0.806     0.200
     8.075    -0.440     0.200
     8.090     1.036     0.200
     8.595    -1.331     0.200
     7.764    -2.828     0.200
     8.682    -1.102     0.200
    10.195    -1.016     0.200
    10.190    -3.426     0.200
     2.946     0.659     0.200
     3.439     0.720     0.200
     3.746     0.938     0.200
     4.645     0.413     0.200
     5.447     1.769     0.200
     5.619     0.597     0.200
     3.663    -0.296     0.200
     4.407     1.209     0.200
     7.883    -0.346     0.200
     8.458     1.224     0.200
    10.464    -0.967     0.200
     7.934    -2.746     0.200
     2.742    -0.887     0.200
     3.866     0.517     0.200
     5.470    -1.574     0.200
     5.668     2.782     0.200
     8.058    -0.505     0.200
    10.740    -0.148     0.200
     2.781    -0.594     0.200
     3.885    -0.009     0.200
     3.917    -1.346     0.200
     5.542     1.456     0.200
     6.124     2.644     0.200
     8.096    -3.332     0.200
     8.100    -2.392     0.200
     8.096    -4.416     0.200
     8.104    -1.661     0.200
     2.987    -0.369     0.200
     3.847    -0.600     0.200
     5.692     1.228     0.200
     2.523    -0.813     0.200
     4.280    -0.225     0.200
     5.629     2.498     0.200
     5.674     0.146     0.200
     6.094     2.382     0.200
     6.171    -2.725     0.200
     8.078    -1.525     0.200
     8.127    -2.340     0.200
     3.566    -1.264     0.200
     4.328    -1.864     0.200
     3.032     1.188     0.200
     3.705     1.413     0.200
     3.830     1.719     0.200
     4.303     0.650     0.200
     7.857    -3.638     0.200
     8.052    -1.095     0.200
    10.423    -2.293     0.200
    11.443     3.362     0.200
     3.638    -2.223     0.200
     7.754    -0.159     0.200
    10.172    -0.761     0.200
     8.046     0.234     0.200
     6.541    -0.980     0.200
     6.545    -0.855     0.200
     7.728    -0.713     0.200
     8.037    -5.061     0.200
     8.083    -3.417     0.200
     9.795     2.803     0.200
    10.600    -2.144     0.200
    10.685    16.044     0.200
    10.941    -0.891     0.200
    11.392     9.729     0.200
    11.583    11.216     0.200
     8.101    -3.846     0.200
     8.113    -4.835     0.200
     9.786     2.211     0.200
    10.610    -3.146     0.200
     6.549    -1.667     0.200
     6.560    -2.292     0.200
     6.777     2.120     0.200
     7.748    -1.652     0.200
     7.912     0.551     0.200
     8.097    -2.298     0.200
     8.097    -3.771     0.200
     8.119     0.629     0.200
     8.119    -3.813     0.200
     3.863    -1.540     0.200
     6.500     0.310     0.200
     3.806    -0.621     0.200
     4.370    -0.580     0.200
    10.380    -2.821     0.200
    11.492     0.728     0.200
     3.834     8.693     0.200
     8.130    -4.615     0.200
    10.606    -4.112     0.200
     8.096    -3.526     0.200
     8.150    -0.885     0.200
    10.968    -3.414     0.200
     2.705    -1.386     0.200
     3.865    -0.851     0.200
     6.464    -2.150     0.200
     8.063    -1.121     0.200
     6.189     0.476     0.200
     6.725     3.981     0.200
     8.151    -3.153     0.200
    10.880    -2.289     0.200
     3.889    -0.391     0.200
     3.906     1.474     0.200
     4.274     0.491     0.200
     5.536    -0.835     0.200
     7.871    -1.743     0.200
     4.375    -2.232     0.200
     5.456     2.706     0.200
     8.608    -1.360     0.200
    10.312    -2.107     0.200
     3.665    -0.720     0.200
     3.958    -0.029     0.200
     4.428     1.122     0.200
     4.682     2.642     0.200
     5.654     0.119     0.200
     6.209     4.456     0.200
     6.281     3.648     0.200
     6.842     3.061     0.200
     6.860     0.891     0.200
     2.972     1.341     0.200
     4.180    -1.312     0.200
     4.583     0.415     0.200
     5.435     0.044     0.200
     6.384     1.560     0.200
     7.444     0.603     0.200
     4.107    -2.311     0.200
     7.560    11.344     0.200
    11.283     0.934     0.200
     4.279     0.538     0.200
     7.508     3.508     0.200
     7.883    -2.313     0.200
     8.086    -3.424     0.200
     8.090     0.142     0.200
    12.737     6.599     0.200
     8.073    -3.468     0.200
     8.188    -2.290     0.200
     9.861     2.663     0.200
    11.021     0.143     0.200
    15.600    -3.566     0.200
    26.696    -6.054     0.200
     2.748     5.192     0.200
     3.836     1.236     0.200
     3.868     0.359     0.200
     6.468    -0.733     0.200
     6.575    -1.362     0.200
     7.547     5.847     0.200
     8.066    -1.457     0.200
     8.066    -2.183     0.200
     8.210    -3.686     0.200
     4.715     0.453     0.200
     5.683     1.969     0.200
     6.081    -0.058     0.200
     7.920     2.649     0.200
     8.075    -0.493     0.200
     8.087    -1.391     0.200
     8.183    -0.307     0.200
     2.812     0.087     0.200
     3.917     0.030     0.200
     3.948     1.375     0.200
     6.155     0.451     0.200
     6.587    -2.044     0.200
     8.044    -0.082     0.200
     8.128    -1.635     0.200
    10.903    -1.159     0.200
     6.627     0.379     0.200
     8.483    -0.208     0.200
     3.875    -1.285     0.200
     4.258    -2.200     0.200
     8.187     6.158     0.200
     4.643     1.204     0.200
     4.905     5.547     0.200
     5.477     0.728     0.200
     5.925     4.183     0.200
     6.801     2.834     0.200
     6.953     2.484     0.200
     7.110     5.593     0.200
     7.760    10.353     0.200
     8.085    -3.258     0.200
     8.499    -0.107     0.200
    16.201    -2.859     0.200
    23.107    -7.032     0.200
    26.252    -5.869     0.200
     7.847    -2.296     0.200
    10.371    -0.536     0.200
     2.827     0.866     0.200
     3.685    -0.057     0.200
     4.634    -0.023     0.200
     5.475    -0.288     0.200
     6.088    -0.313     0.200
     7.493    -2.747     0.200
     8.072    -2.378     0.200
     8.475     1.166     0.200
     5.663     2.716     0.200
     7.786    -4.106     0.200
    10.228    -1.001     0.200
     3.339     1.129     0.200
     3.820    -2.287     0.200
     4.294     1.849     0.200
     5.566     1.027     0.200
     6.360    -0.348     0.200
     7.169     3.606     0.200
     7.840    -1.614     0.200
     7.894    -4.145     0.200
     7.944    -3.720     0.200
     7.944    12.100     0.200
     8.198    -4.337     0.200
     3.810    -1.066     0.200
     4.365    -1.995     0.200
     6.698     1.191     0.200
     7.499    -2.252     0.200
     7.546     0.593     0.200
     9.172     1.835     0.200
    10.490    21.584     0.200
     2.773    -1.283     0.200
     5.294     0.028     0.200
     6.544    -1.413     0.200
     3.306    -1.472     0.200
     7.448     1.639     0.200
     7.775    -0.350     0.200
     8.113     0.876     0.200
    10.202     1.141     0.200
     6.478     3.609     0.200
     4.458    -1.656     0.200
     6.553     4.713     0.200
    10.357    -1.827     0.200
    11.290     1.436     0.200
     6.545     1.852     0.200
     8.360     0.188     0.200
    10.392    -2.259     0.200
    11.311    -0.548     0.200
    15.942    -1.536     0.200
     3.761     0.286     0.200
     4.603    -1.463     0.200
     4.444    -1.575     0.200
     4.655    -0.096     0.200
     4.927     0.383     0.200
     5.461    -0.023     0.200
     5.621    -0.990     0.200
    10.052     9.186     0.200
     4.826    -0.724     0.200
     7.605    -3.447     0.200
    10.863    -3.884     0.200
    10.863    -3.889     0.200
     3.283    -0.731     0.200
     7.755     7.446     0.200
    10.257    -4.578     0.200
    10.257    -4.575     0.200
     3.910     1.494     0.200
     4.647     2.294     0.200
     6.700     5.368     0.200
    10.388    -1.149     0.200
    11.494     1.033     0.200
     7.785    -0.536     0.200
    10.407    -2.917     0.200
    10.293    -4.910     0.200
    11.339    -0.821     0.200
     3.830    -1.474     0.200
     6.370     0.415     0.200
     7.873    -0.693     0.200
     8.086    -2.555     0.200
     9.756     3.692     0.200
     5.642     2.174     0.200
     6.292    -1.480     0.200
     3.748     0.746     0.200
     6.257     4.000     0.200
     6.373     1.204     0.200
     8.107    -0.427     0.200
    10.408     0.226     0.200
     6.669     0.606     0.200
     6.741     2.364     0.200
     8.650     2.048     0.200
    10.739     1.425     0.200
     3.837    -2.156     0.200
     8.385     5.168     0.200
     8.140     3.137     0.200
     8.276    -0.993     0.200
     6.137    -0.169     0.200
     4.212     3.790     0.200
     2.535    -1.157     0.200
    10.746    -3.900     0.200
     4.482     0.268     0.200
     4.665    -1.274     0.200
     6.677     0.800     0.200
     7.887     3.172     0.200
     7.891    -4.127     0.200
     8.235    -2.510     0.200
     8.531    -4.032     0.200
     9.770    -0.982     0.200
     9.775    -8.344     0.200
    10.469    17.024     0.200
    11.696    -2.173     0.200
    14.043    -5.944     0.200
    14.833   -16.788     0.200
     6.682     2.052     0.200
     7.882    -1.152     0.200
     8.532    -0.539     0.200
    10.416    -1.476     0.200
     3.067     0.834     0.200
     6.677     1.843     0.200
     7.865    -2.278     0.200
     8.521     0.212     0.200
     6.409    -3.063     0.200
     3.825    -1.872     0.200
     7.099     1.814     0.200
     8.340    -1.029     0.200
     2.951     4.418     0.200
     3.170    -1.310     0.200
     4.374    -0.025     0.200
     4.810     6.725     0.200
     4.890     4.977     0.200
     5.144     0.354     0.200
     5.270     5.228     0.200
     5.736     0.546     0.200
     7.512    -0.807     0.200
     8.377     2.513     0.200
    10.325    -3.614     0.200
     7.784    -3.909     0.200
     4.919     6.862     0.200
     6.543    -0.972     0.200
     7.761    -2.177     0.200
    11.312     1.706     0.200
     8.354    -4.055     0.200
    10.379    -3.908     0.200
    11.301     0.539     0.200
     6.541     1.450     0.200
     7.763    -4.818     0.200
    10.400    -4.763     0.200
    11.312    -3.193     0.200
     2.906     1.592     0.200
     7.743    -6.279     0.200
     8.345    -1.440     0.200
    10.388    -3.853     0.200
    11.294     1.320     0.200
     7.858    -2.485     0.200
     8.544    -2.827     0.200
     9.166     2.645     0.200
    10.383    -5.113     0.200
    11.227    -3.770     0.200
    16.123    -5.618     0.200
     6.089     3.496     0.200
     7.875    -0.561     0.200
     7.979    -3.264     0.200
    11.059     4.252     0.200
     6.554     0.800     0.200
     8.428    -0.437     0.200
    10.522    -1.986     0.200
    10.974    -1.526     0.200
     7.795    -0.320     0.200
     8.378    -5.085     0.200
    11.340     1.658     0.200
     6.567     2.558     0.200
     7.850    -2.954     0.200
     8.414    -1.768     0.200
    10.456    -4.510     0.200
     8.356     0.802     0.200
    10.383    -0.224     0.200
     7.746    -4.340     0.200
    10.390    -0.920     0.200
     7.937    -2.870     0.200
     8.249    -5.893     0.200
     7.898    -5.152     0.200
     8.046    -1.131     0.200
    10.731    -0.329     0.200
    11.121     0.630     0.200
     8.021    -1.961     0.200
    11.005    -3.112     0.200
    11.198     0.171     0.200
     7.893    -1.571     0.200
     7.950    -5.267     0.200
     6.065     0.486     0.200
     7.963    -1.459     0.200
     6.526     0.226     0.200
     7.772    -5.521     0.200
     8.347    -2.270     0.200
    10.416    -2.363     0.200
     7.760    -2.484     0.200
    10.414    -2.476     0.200
    11.053    -3.939     0.200
    11.290     0.621     0.200
    11.052    -2.351     0.200
     8.340    -0.707     0.200
    10.424     1.045     0.200
    11.054    -4.708     0.200
     7.745    -2.305     0.200
     8.320    -4.092     0.200
     3.715     2.693     0.200
     6.535     0.969     0.200
     7.733    -1.395     0.200
    10.379    -2.273     0.200
    15.925    -3.065     0.200
     7.711    -2.639     0.200
     8.330    -4.995     0.200
    11.269    -1.518     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.720     1.850     0.200
     0.760     0.156     0.200
     0.733     1.320     0.200
     0.713     0.915     0.200
     0.716     1.494     0.200
     0.765     1.670     0.200
     8.379   -50.115     0.200
     0.755     1.167     0.200
     0.734     0.630     0.200
     0.734     1.267     0.200
     0.734     1.708     0.200
     0.759     0.597     0.200
     0.987    -1.797     0.200
     0.987    -1.063     0.200
     1.090    -1.894     0.200
     1.126    -5.168     0.200
     2.114    -6.367     0.200
     2.125    -6.164     0.200
     2.145    -6.004     0.200
     2.897   -12.029     0.200
     2.977   -12.270     0.200
     3.525   -16.898     0.200
     9.092   -56.212     0.200
     0.957    -0.427     0.200
     0.964    -1.082     0.200
     1.257    -4.608     0.200
     2.143    -5.800     0.200
     2.180    -5.799     0.200
     2.594    -9.682     0.200
     3.024   -11.584     0.200
     3.534   -14.016     0.200
     4.674   -22.075     0.200
     0.671     0.883     0.200
     0.999    -1.636     0.200
     0.999    -0.996     0.200
     1.121    -4.774     0.200
     1.121    -2.852     0.200
     2.986   -12.642     0.200
     5.335   -28.995     0.200
     6.419   -34.073     0.200
     7.627   -44.479     0.200
     7.678   -46.300     0.200
     7.666   -44.097     0.200
     7.825   -45.248     0.200
     8.004   -45.376     0.200
     9.084   -54.333     0.200
     0.696     0.096     0.200
     1.206    -2.795     0.200
     1.505    -5.032     0.200
     1.505    -5.833     0.200
     2.438   -12.325     0.200
     2.652   -10.744     0.200
     3.321   -17.421     0.200
     3.551   -18.803     0.200
     3.962   -21.305     0.200
     4.180   -23.995     0.200
     7.503   -49.136     0.200
     9.414   -59.512     0.200
    19.368  -132.525     0.200
     0.455     2.705     0.200
     0.701     0.153     0.200
     1.344    -2.946     0.200
     1.514    -5.181     0.200
     2.100    -9.059     0.200
     2.174    -8.252     0.200
     6.602   -40.007     0.200
    10.021   -64.988     0.200
    15.798  -102.805     0.200
    17.741  -118.374     0.200
     0.475     1.784     0.200
     0.742     1.551     0.200
     1.197    -3.857     0.200
     1.491    -5.254     0.200
     2.884   -10.365     0.200
     2.939   -10.490     0.200
     3.618   -15.291     0.200
     4.126   -20.015     0.200
     4.482   -22.205     0.200
     6.932   -38.701     0.200
     0.729     1.152     0.200
     1.361    -2.917     0.200
     2.207    -8.205     0.200
     0.475     1.221     0.200
     0.683     0.420     0.200
     0.743     0.628     0.200
     1.492    -4.754     0.200
     2.190    -9.480     0.200
     0.473     1.469     0.200
     0.679     0.235     0.200
     0.737     0.818     0.200
     1.491    -5.216     0.200
     1.555    -3.816     0.200
     0.463     1.168     0.200
     0.463     2.049     0.200
     0.665     0.418     0.200
     0.697     0.047     0.200
     0.744     0.793     0.200
     1.170    -2.890     0.200
     1.210    -3.821     0.200
     1.508    -5.326     0.200
     1.508    -5.484     0.200
     1.711    -6.169     0.200
     3.575   -13.580     0.200
     0.461     1.829     0.200
     0.461     2.779     0.200
     0.737     1.270     0.200
     1.506    -4.694     0.200
     1.569    -3.974     0.200
     0.645     0.527     0.200
     0.732    -1.253     0.200
     0.732    -0.815     0.200
     2.881   -10.166     0.200
     3.091   -12.330     0.200
     3.613   -15.261     0.200
     3.853   -17.761     0.200
     4.489   -23.047     0.200
     5.542   -29.001     0.200
     6.569   -37.948     0.200
     6.622   -36.941     0.200
     6.931   -39.137     0.200
     7.121   -40.930     0.200
     7.602   -44.688     0.200
     7.912   -47.544     0.200
     7.915   -46.145     0.200
     7.933   -46.269     0.200
     8.114   -49.551     0.200
     8.592   -50.006     0.200
     8.653   -51.170     0.200
     9.132   -52.503     0.200
     9.199   -53.150     0.200
     9.629   -57.052     0.200
     9.963   -58.067     0.200
    10.742   -66.126     0.200
    10.823   -64.519     0.200
    11.447   -72.590     0.200
    11.565   -72.963     0.200
    11.632   -73.088     0.200
    11.743   -73.534     0.200
    11.837   -75.321     0.200
    11.932   -73.537     0.200
    12.473   -78.475     0.200
    12.482   -75.633     0.200
    12.504   -77.732     0.200
    12.661   -81.411     0.200
    12.768   -83.264     0.200
    13.062   -80.180     0.200
    13.406   -90.306     0.200
    13.497   -86.201     0.200
    13.533   -87.809     0.200
    14.287   -93.027     0.200
    14.395   -94.529     0.200
    14.623   -94.981     0.200
    14.835   -96.933     0.200
    15.070   -99.275     0.200
    16.116  -106.402     0.200
    16.567  -109.545     0.200
    16.872  -112.787     0.200
    18.499  -125.599     0.200
     0.626    -0.047     0.200
     0.648    -0.070     0.200
     0.674     0.378     0.200
     0.739    -1.450     0.200
     0.739    -1.182     0.200
     1.147    -3.384     0.200
     1.204    -2.996     0.200
     1.490    -4.894     0.200
     8.278   -52.444     0.200
     0.711     0.411     0.200
    15.880  -107.351     0.200
     0.405     1.519     0.200
     0.744    -1.512     0.200
     1.269    -3.694     0.200
     0.586     3.429     0.200
     0.788     0.451     0.200
     0.935    -1.260     0.200
     8.480   -52.471     0.200
     0.724     1.931     0.200
     0.728     2.025     0.200
     0.732     0.301     0.200
     1.293    -3.899     0.200
     8.416   -51.231     0.200
     0.668     0.502     0.200
     0.676     0.745     0.200
     0.795    -1.375     0.200
     1.253    -4.145     0.200
     1.403    -4.988     0.200
     1.514    -5.787     0.200
     1.649    -5.421     0.200
     2.846   -12.396     0.200
     0.708     0.227     0.200
     0.773    -1.080     0.200
     1.332    -4.179     0.200
     7.608   -46.310     0.200
     7.633   -44.814     0.200
     9.438   -59.066     0.200
     9.819   -60.672     0.200
    10.662   -68.577     0.200
     0.755    -0.388     0.200
     0.708     1.152     0.200
     0.776     0.155     0.200
     1.333    -2.764     0.200
     2.734   -12.426     0.200
     7.788   -47.724     0.200
    10.408   -64.201     0.200
     0.825     0.541     0.200
     0.876     0.689     0.200
     0.977    -0.611     0.200
     0.984    -1.088     0.200
     1.200    -2.398     0.200
     1.200    -3.574     0.200
     3.541   -12.753     0.200
    10.735   -68.675     0.200
     0.716    -0.137     0.200
     0.707     0.629     0.200
     0.707     1.200     0.200
     0.744     0.358     0.200
     1.342    -3.674     0.200
     1.580    -4.530     0.200
     3.018   -10.412     0.200
     5.689   -32.790     0.200
     9.968   -66.025     0.200
     0.713     0.204     0.200
     0.702     0.861     0.200
     0.751    -0.095     0.200
     1.302    -4.714     0.200
     1.347    -3.392     0.200
     1.593    -4.922     0.200
     3.029   -13.109     0.200
     3.811   -20.273     0.200
     5.002   -26.410     0.200
     5.674   -31.486     0.200
     6.559   -39.281     0.200
     9.960   -61.986     0.200
    10.431   -62.388     0.200
    10.431   -62.389     0.200
     0.573     0.781     0.200
     0.601     0.350     0.200
     0.743     0.234     0.200
     0.762     0.215     0.200
     0.960    -1.437     0.200
     0.458     2.818     0.200
     0.758     0.227     0.200
     0.998    -2.821     0.200
     1.164    -2.506     0.200
     1.624    -3.787     0.200
     2.463    -7.479     0.200
     2.463    -7.478     0.200
     5.433   -29.770     0.200
     6.092   -34.262     0.200
     6.937   -39.679     0.200
     0.606     2.991     0.200
     0.799     0.104     0.200
     0.862    -0.065     0.200
     1.011    -1.897     0.200
     1.057    -1.709     0.200
     1.091    -1.405     0.200
     1.742    -5.642     0.200
     2.282    -6.127     0.200
     7.095   -41.362     0.200
     0.418     1.134     0.200
     1.209    -3.241     0.200
     1.649    -5.847     0.200
     0.976    -1.805     0.200
     1.118    -2.941     0.200
     1.118    -2.928     0.200
     1.661    -4.759     0.200
     5.008   -26.923     0.200
     5.717   -31.177     0.200
     6.519   -36.502     0.200
     9.362   -55.840     0.200
     9.946   -59.532     0.200
    12.052   -75.578     0.200
     0.741     0.144     0.200
     0.741     1.816     0.200
     0.741     3.144     0.200
     0.829     0.389     0.200
     0.399     1.820     0.200
     0.759    -0.197     0.200
     1.261    -3.096     0.200
     1.356    -2.972     0.200
     4.959   -27.318     0.200
     6.261   -33.518     0.200
     0.734     1.779     0.200
     0.841    -0.043     0.200
     3.818   -18.295     0.200
     0.734     2.350     0.200
     0.840    -0.331     0.200
     0.856    -0.526     0.200
     1.375    -3.747     0.200
     1.643    -5.617     0.200
     3.818   -19.583     0.200
     4.962   -25.918     0.200
     6.546   -37.780     0.200
     0.719     1.398     0.200
     1.326    -2.875     0.200
     2.719   -13.072     0.200
     2.262    -5.520     0.200
     2.403    -7.465     0.200
     2.522    -8.297     0.200
     0.611     2.091     0.200
     0.796     0.430     0.200
     0.876     0.847     0.200
     1.232    -3.588     0.200
     1.386    -3.025     0.200
     1.614    -4.533     0.200
     1.646    -3.563     0.200
     2.076    -6.218     0.200
     2.133    -6.612     0.200
     3.075   -12.012     0.200
     4.953   -23.654     0.200
     5.602   -28.713     0.200
     6.360   -34.894     0.200
     6.577   -39.628     0.200
     7.890   -46.806     0.200
    11.144   -66.776     0.200
    13.717   -84.847     0.200
    15.123  -102.301     0.200
    17.481  -115.500     0.200
    17.512  -116.669     0.200
     0.880     0.526     0.200
     1.473    -4.673     0.200
     4.005   -19.548     0.200
     3.924   -16.981     0.200
     5.108   -28.405     0.200
     5.559   -32.980     0.200
     6.339   -38.749     0.200
     1.246    -1.941     0.200
     1.341    -3.209     0.200
     1.758    -4.253     0.200
     2.239    -5.270     0.200
     2.911    -8.991     0.200
    16.322  -107.165     0.200
     0.932    -1.122     0.200
     0.932    -2.497     0.200
     1.406    -4.161     0.200
     2.584   -10.936     0.200
     2.619   -11.672     0.200
     0.754     0.600     0.200
     0.754     0.115     0.200
     0.903    -0.904     0.200
     0.903    -1.083     0.200
     1.376    -4.214     0.200
     1.449    -4.684     0.200
     1.795    -6.808     0.200
     2.512   -12.064     0.200
     2.762   -11.683     0.200
     2.921   -13.533     0.200
     3.078   -16.131     0.200
     0.882    -1.813     0.200
     1.164    -8.195     0.200
     1.557    -5.121     0.200
     2.394    -9.898     0.200
     2.466   -12.304     0.200
     0.933    -1.224     0.200
     1.123    -2.615     0.200
     1.748    -7.658     0.200
     2.211   -11.586     0.200
     2.261   -10.942     0.200
     2.463    -8.375     0.200
     2.808   -12.376     0.200
     2.842   -14.493     0.200
     0.497     1.908     0.200
     0.539     0.957     0.200
     0.711     0.059     0.200
     0.871    -2.466     0.200
     1.433    -5.185     0.200
     2.299    -9.342     0.200
     2.757   -10.859     0.200
     5.047   -27.342     0.200
     5.470   -30.578     0.200
     6.422   -40.753     0.200
     0.910    -2.164     0.200
     0.910    -1.736     0.200
     1.357    -5.018     0.200
     1.482    -4.847     0.200
     1.573    -5.131     0.200
     1.573    -5.820     0.200
     1.573    -6.016     0.200
     2.557   -13.292     0.200
     0.938    -2.194     0.200
     0.975    -3.423     0.200
     0.975    -2.159     0.200
     1.255    -2.947     0.200
     1.392    -4.383     0.200
     1.526    -5.722     0.200
     1.797    -7.487     0.200
     2.065    -9.425     0.200
     3.775   -21.267     0.200
     4.431   -24.653     0.200
     5.026   -29.441     0.200
     6.902   -44.668     0.200
     0.927    -2.035     0.200
     1.220    -2.480     0.200
     1.367    -4.162     0.200
     0.498     3.209     0.200
     0.816     0.297     0.200
     1.101    -2.901     0.200
     1.188    -2.918     0.200
     1.556    -4.216     0.200
     1.653    -4.932     0.200
     1.684    -5.400     0.200
     2.582    -6.570     0.200
     8.837   -51.643     0.200
     0.900    -0.981     0.200
     1.168    -3.306     0.200
     1.315    -3.518     0.200
     1.315    -3.687     0.200
     1.315    -3.848     0.200
     1.535    -5.591     0.200
     1.596    -5.395     0.200
     1.717    -5.080     0.200
     2.448   -11.223     0.200
     6.627   -39.407     0.200
     0.805     0.522     0.200
     1.068    -2.806     0.200
     1.139    -2.443     0.200
     1.387    -3.816     0.200
     1.544    -4.728     0.200
     1.707    -5.568     0.200
     1.893    -6.304     0.200
     2.168    -9.674     0.200
     2.250   -10.045     0.200
     0.930    -1.725     0.200
     1.401    -4.111     0.200
     1.455    -4.303     0.200
     1.671    -5.994     0.200
     1.718    -5.604     0.200
     0.857    -0.607     0.200
     1.378    -2.448     0.200
     1.395    -4.590     0.200
     1.395    -4.763     0.200
     1.551    -5.171     0.200
     0.557     0.736     0.200
     1.043    -2.833     0.200
     1.043    -1.450     0.200
     1.094    -2.431     0.200
     1.338    -3.595     0.200
     1.650    -6.277     0.200
     1.935    -6.438     0.200
     1.956    -7.698     0.200
     2.242    -9.571     0.200
     2.402   -11.303     0.200
     0.783     0.290     0.200
     0.806    -0.189     0.200
     0.911    -1.568     0.200
     0.911    -0.998     0.200
     1.065    -2.637     0.200
     1.136    -2.466     0.200
     1.136    -3.056     0.200
     1.384    -4.543     0.200
     1.542    -5.006     0.200
     1.707    -5.956     0.200
     2.157    -9.070     0.200
     2.348   -10.123     0.200
     2.354    -8.884     0.200
     2.604   -13.587     0.200
     2.802   -10.118     0.200
     3.155   -11.712     0.200
     5.300   -27.427     0.200
     6.753   -39.436     0.200
     7.620   -42.582     0.200
     0.861    -0.543     0.200
     1.357    -4.584     0.200
     1.416    -2.689     0.200
     1.610    -5.456     0.200
     2.179    -8.418     0.200
     3.024   -11.459     0.200
     5.458   -30.925     0.200
     7.182   -42.465     0.200
     7.568   -44.565     0.200
     7.750   -46.357     0.200
     0.905    -1.091     0.200
     0.906    -1.337     0.200
     1.026    -1.743     0.200
     1.089    -2.652     0.200
     1.089    -2.824     0.200
     1.338    -3.422     0.200
     1.492    -4.131     0.200
     1.521    -4.518     0.200
     1.720    -5.863     0.200
     1.843    -5.861     0.200
     2.113    -8.753     0.200
     2.141    -9.441     0.200
     2.331    -8.253     0.200
     2.663   -11.816     0.200
     0.819     0.572     0.200
     0.819     0.064     0.200
     1.054    -2.299     0.200
     1.134    -2.037     0.200
     1.134    -2.330     0.200
     1.134    -2.447     0.200
     1.378    -2.963     0.200
     1.529    -4.134     0.200
     1.696    -4.607     0.200
     1.888    -5.386     0.200
     2.149    -7.924     0.200
     2.241    -8.828     0.200
     2.363    -6.360     0.200
     0.802    -0.129     0.200
     0.802     1.968     0.200
     0.945    -1.754     0.200
     1.399    -4.297     0.200
     2.100    -8.047     0.200
     2.285    -8.487     0.200
     0.865    -0.307     0.200
     0.962    -2.189     0.200
     1.372    -3.784     0.200
     1.346    -3.610     0.200
     1.522    -5.284     0.200
    10.321   -62.944     0.200
     0.394     1.407     0.200
     0.587     0.627     0.200
     0.721     0.873     0.200
     1.017    -2.736     0.200
     1.017    -2.366     0.200
     1.337    -3.978     0.200
     1.618    -6.025     0.200
     1.954    -7.574     0.200
     1.921    -8.419     0.200
     2.239    -9.800     0.200
     2.380   -10.467     0.200
     3.284   -11.996     0.200
     3.869   -21.972     0.200
     4.643   -23.831     0.200
     5.422   -31.229     0.200
    10.217   -62.013     0.200
     0.698     0.109     0.200
     0.698     1.439     0.200
     1.361    -3.990     0.200
     1.618    -5.685     0.200
     1.618    -6.172     0.200
     5.698   -32.523     0.200
     0.744     0.361     0.200
     0.817     0.221     0.200
     1.089    -2.784     0.200
     1.175    -3.025     0.200
     1.175    -2.881     0.200
     1.268    -2.025     0.200
     1.419    -4.882     0.200
     1.687    -5.516     0.200
     2.574   -12.101     0.200
     3.194   -10.425     0.200
     4.212   -24.742     0.200
    10.873   -66.379     0.200
     0.811     0.199     0.200
     0.811     0.308     0.200
     0.802     1.837     0.200
     1.046    -2.558     0.200
     1.116    -2.005     0.200
     1.116    -1.587     0.200
     1.136    -1.640     0.200
     1.363    -3.247     0.200
     1.529    -3.549     0.200
     1.709    -5.118     0.200
     2.152    -8.889     0.200
     2.331   -10.391     0.200
     2.517    -8.904     0.200
     3.139   -13.549     0.200
     4.650   -20.434     0.200
     8.099   -51.051     0.200
     9.633   -57.602     0.200
    10.972   -72.872     0.200
     0.765     1.366     0.200
     0.940    -2.012     0.200
     1.420    -4.171     0.200
     0.586     0.896     0.200
     0.744     1.196     0.200
     1.012    -1.523     0.200
     1.317    -2.789     0.200
     1.367    -3.541     0.200
     1.622    -6.007     0.200
     1.750    -4.439     0.200
     1.930    -6.674     0.200
     1.935    -7.467     0.200
     1.935    -6.455     0.200
     2.219    -9.127     0.200
     3.650   -18.754     0.200
     0.491     3.297     0.200
     0.698     0.785     0.200
     0.741     0.098     0.200
     0.840     0.361     0.200
     1.073    -2.369     0.200
     1.176    -2.614     0.200
     1.176    -2.411     0.200
     1.410    -3.769     0.200
     1.527    -4.461     0.200
     1.570    -6.628     0.200
     1.580    -4.271     0.200
     1.664    -5.246     0.200
     1.929    -7.117     0.200
     2.153    -8.768     0.200
     2.175    -8.940     0.200
     2.580    -8.845     0.200
     3.202   -13.007     0.200
     0.764     1.646     0.200
     1.071    -0.885     0.200
     1.081    -0.671     0.200
     1.081    -1.450     0.200
     1.411    -2.893     0.200
     1.961    -4.261     0.200
     2.800    -9.670     0.200
     4.607   -23.664     0.200
     0.654     2.614     0.200
     0.754     0.973     0.200
     0.754     0.633     0.200
     0.766     0.510     0.200
     0.965    -1.315     0.200
     0.965    -1.106     0.200
     1.029    -1.552     0.200
     1.029    -1.195     0.200
     1.304    -2.717     0.200
     1.794    -6.191     0.200
     2.251    -8.392     0.200
     3.038   -13.109     0.200
     0.448     0.995     0.200
     0.715     1.011     0.200
     1.073    -2.481     0.200
     1.367    -4.524     0.200
     1.675    -6.394     0.200
     1.811    -6.605     0.200
     1.950    -8.316     0.200
     2.272   -10.167     0.200
     2.434   -12.132     0.200
     8.726   -55.457     0.200
     0.766     0.057     0.200
     0.933    -1.858     0.200
     1.706    -6.639     0.200
     3.063   -10.102     0.200
     3.331   -15.427     0.200
     4.645   -23.014     0.200
     0.626     1.286     0.200
     0.760     0.682     0.200
     0.779    -0.248     0.200
     0.854    -0.994     0.200
     1.397    -4.584     0.200
     1.449    -4.832     0.200
     1.664    -6.743     0.200
     1.714    -7.023     0.200
     2.865   -10.445     0.200
     3.123   -12.422     0.200
     3.336   -13.689     0.200
     4.287   -21.219     0.200
     4.632   -23.682     0.200
     4.795   -25.322     0.200
     6.131   -33.001     0.200
    16.271  -108.292     0.200
     0.746     0.003     0.200
     0.801     0.365     0.200
     0.838     0.378     0.200
     0.838    -0.253     0.200
     1.025    -2.166     0.200
     1.116    -2.584     0.200
     1.116    -1.933     0.200
     1.116    -3.129     0.200
     1.352    -3.378     0.200
     1.580    -4.131     0.200
     1.684    -5.465     0.200
     1.869    -5.823     0.200
     0.815     0.385     0.200
     1.089    -2.532     0.200
     1.173    -3.012     0.200
     1.550    -4.221     0.200
     1.569    -4.356     0.200
     1.641    -5.242     0.200
     1.689    -5.639     0.200
     0.775     0.189     0.200
     0.921    -0.396     0.200
     1.398    -3.001     0.200
     1.445    -3.506     0.200
     1.709    -4.478     0.200
     3.070    -9.608     0.200
     3.814   -20.098     0.200
     4.909   -25.070     0.200
     4.909   -27.871     0.200
     5.548   -28.534     0.200
     5.548   -26.511     0.200
     9.254   -55.403     0.200
     0.663     2.064     0.200
     0.723    -0.183     0.200
     0.883    -1.355     0.200
     0.883    -2.252     0.200
     0.896    -1.655     0.200
     1.353    -4.263     0.200
     1.441    -4.534     0.200
     1.592    -5.740     0.200
     2.207    -9.336     0.200
     0.588     1.472     0.200
     0.752    -0.420     0.200
     0.761     0.146     0.200
     0.955    -2.654     0.200
     1.435    -4.818     0.200
     2.144    -9.805     0.200
     2.318   -11.057     0.200
    10.422   -66.581     0.200
     0.682     0.237     0.200
     0.682     2.073     0.200
     0.843     0.555     0.200
     0.903    -1.376     0.200
     1.381    -4.323     0.200
     1.444    -4.638     0.200
     1.619    -5.330     0.200
     0.742     0.158     0.200
     0.801    -0.246     0.200
     0.931    -1.217     0.200
     1.388    -3.043     0.200
     1.466    -3.844     0.200
     1.735    -6.647     0.200
     6.497   -38.874     0.200
    12.900   -84.230     0.200
    16.290  -109.807     0.200
     0.450     2.263     0.200
     0.792    -0.210     0.200
     0.884    -1.490     0.200
     0.884    -1.065     0.200
     1.125    -2.987     0.200
     1.686    -5.014     0.200
     4.220   -24.399     0.200
     4.631   -24.454     0.200
     8.026   -49.768     0.200
     0.855    -0.104     0.200
     1.405    -3.526     0.200
     2.166    -8.625     0.200
     2.663   -11.232     0.200
     3.046   -13.516     0.200
     0.534     3.126     0.200
     0.834     0.511     0.200
     0.882    -0.206     0.200
     1.035    -2.000     0.200
     1.124    -1.990     0.200
     1.124    -1.643     0.200
     1.685    -4.878     0.200
     2.369    -6.712     0.200
     2.592   -11.774     0.200
     5.583   -31.428     0.200
     0.626     2.126     0.200
     0.679     0.891     0.200
     0.679     2.024     0.200
     0.982    -3.398     0.200
     0.982    -2.523     0.200
     1.100    -2.384     0.200
     1.402    -5.230     0.200
     3.148   -10.990     0.200
     3.196   -13.090     0.200
     3.917   -20.799     0.200
     0.738     1.789     0.200
     1.026    -2.332     0.200
     1.026    -1.418     0.200
     1.081    -2.104     0.200
     1.327    -3.319     0.200
     1.634    -5.527     0.200
     8.682   -54.927     0.200
     0.741     1.057     0.200
     1.318    -3.983     0.200
     0.748     1.104     0.200
     1.011    -3.116     0.200
     1.313    -3.195     0.200
     1.622    -4.921     0.200
     1.926    -6.706     0.200
     2.216    -8.935     0.200
     3.847   -20.109     0.200
     0.663     0.738     0.200
     0.663     1.660     0.200
     0.661     0.756     0.200
     0.975    -1.955     0.200
     2.946   -11.102     0.200
     3.231   -13.119     0.200
     4.645   -23.266     0.200
     5.447   -27.481     0.200
     6.288   -33.789     0.200
     0.700     2.305     0.200
     0.773     0.413     0.200
     1.384    -3.353     0.200
     1.427    -4.188     0.200
     1.631    -5.327     0.200
     2.177    -7.667     0.200
     3.040   -13.148     0.200
     4.628   -22.607     0.200
     0.639     0.876     0.200
     0.978    -2.843     0.200
     3.230   -13.321     0.200
     4.387   -20.941     0.200
     8.309   -50.154     0.200
     0.522     3.088     0.200
     0.606     1.436     0.200
     0.746     0.751     0.200
     0.746     1.311     0.200
     0.780     0.201     0.200
     0.936    -1.537     0.200
     0.936    -1.297     0.200
     1.070    -2.210     0.200
     1.070    -0.792     0.200
     1.084    -1.549     0.200
     2.476    -8.587     0.200
     0.873    -1.964     0.200
     2.442   -10.762     0.200
     6.621   -39.944     0.200
     0.469     2.596     0.200
     0.809     0.489     0.200
     0.809    -0.058     0.200
     0.809     0.270     0.200
     0.906    -1.367     0.200
     1.046    -2.562     0.200
     1.115    -2.182     0.200
     1.115    -2.678     0.200
     1.134    -1.728     0.200
     1.620    -4.023     0.200
     2.331    -7.063     0.200
     2.345    -6.785     0.200
     2.781   -10.445     0.200
     3.743   -14.978     0.200
     3.917   -17.155     0.200
     4.651   -22.124     0.200
     6.531   -36.403     0.200
     6.558   -35.242     0.200
     8.044   -45.875     0.200
     0.725     0.739     0.200
     0.805     0.898     0.200
     0.805    -0.102     0.200
     0.805     0.128     0.200
     0.910    -1.349     0.200
     2.341    -7.894     0.200
     2.669   -11.601     0.200
     0.704     2.462     0.200
     1.131    -1.636     0.200
     2.987   -11.611     0.200
     3.038   -13.931     0.200
     3.239   -14.945     0.200
     3.847   -16.428     0.200
     4.254   -20.555     0.200
     4.595   -22.276     0.200
     5.483   -28.765     0.200
     6.383   -35.168     0.200
     0.510     3.144     0.200
     0.594     1.809     0.200
     0.741     1.078     0.200
     0.786     0.355     0.200
     0.786     0.246     0.200
     1.080    -1.989     0.200
     1.080    -1.661     0.200
     1.095    -1.617     0.200
     1.362    -3.250     0.200
     2.290    -6.108     0.200
     2.307    -6.404     0.200
     2.425    -7.350     0.200
     2.654   -11.669     0.200
     2.751   -10.076     0.200
     3.098   -13.758     0.200
     3.706   -17.704     0.200
     3.871   -19.314     0.200
     5.277   -30.489     0.200
     5.629   -31.510     0.200
     7.859   -48.200     0.200
     7.880   -48.662     0.200
     7.898   -46.996     0.200
     8.127   -50.410     0.200
     8.910   -54.089     0.200
     9.148   -51.945     0.200
    11.983   -77.329     0.200
    14.690   -97.847     0.200
     0.568     3.979     0.200
     0.910     0.319     0.200
     1.091    -1.827     0.200
     1.543    -3.280     0.200
     0.628     1.416     0.200
     0.742     0.385     0.200
     0.809    -0.888     0.200
     0.896    -1.885     0.200
     0.896    -1.178     0.200
     2.826   -11.715     0.200
     4.247   -21.438     0.200
     4.441   -21.674     0.200
     4.617   -21.292     0.200
     5.454   -29.829     0.200
     5.454   -30.454     0.200
     6.090   -33.663     0.200
     6.368   -35.028     0.200
     6.732   -38.158     0.200
     6.750   -38.371     0.200
     7.165   -41.678     0.200
     7.240   -41.739     0.200
     7.475   -43.299     0.200
     7.857   -46.126     0.200
     8.121   -48.257     0.200
     8.180   -48.701     0.200
     8.299   -47.786     0.200
     8.449   -53.411     0.200
     8.479   -50.552     0.200
     8.850   -55.703     0.200
     9.718   -57.510     0.200
     9.806   -56.291     0.200
    10.505   -62.377     0.200
    10.652   -66.289     0.200
    11.316   -68.428     0.200
    11.637   -72.528     0.200
    11.666   -71.937     0.200
    11.755   -75.990     0.200
    11.932   -72.710     0.200
    12.124   -73.893     0.200
    12.318   -76.475     0.200
    12.354   -77.599     0.200
    12.500   -79.501     0.200
    12.920   -82.010     0.200
    13.732   -88.807     0.200
    18.287  -122.164     0.200
     0.553     2.455     0.200
     0.553     2.634     0.200
     0.755     1.144     0.200
     1.041    -2.434     0.200
     0.764     0.309     0.200
     0.764     1.610     0.200
     0.764     1.770     0.200
     0.955    -1.275     0.200
     1.030    -1.417     0.200
     3.043   -11.656     0.200
     0.623     2.741     0.200
     0.749     0.125     0.200
     0.767     1.512     0.200
     0.767     0.583     0.200
     0.949    -0.909     0.200
     0.949    -1.522     0.200
     1.035    -2.511     0.200
     1.058    -1.914     0.200
     1.067    -1.442     0.200
     1.811    -4.647     0.200
     2.397    -6.704     0.200
     3.070   -10.056     0.200
     0.738     1.082     0.200
     0.812     0.317     0.200
     1.103    -1.953     0.200
     1.103    -1.765     0.200
     1.129    -1.459     0.200
     1.340    -2.685     0.200
     2.341    -7.258     0.200
     2.506    -9.518     0.200
     0.720     1.080     0.200
     0.796     0.162     0.200
     0.919    -0.523     0.200
     1.053    -2.264     0.200
     1.113    -2.028     0.200
     1.123    -1.396     0.200
     0.487     1.679     0.200
     0.487     3.448     0.200
     0.791     0.332     0.200
     0.924    -1.270     0.200
     1.106    -2.226     0.200
     1.115    -1.486     0.200
     1.337    -2.344     0.200
     1.730    -6.142     0.200
     2.450    -7.164     0.200
     3.910   -17.008     0.200
     7.748   -44.851     0.200
     8.893   -53.612     0.200
     0.537     1.692     0.200
     0.622     2.162     0.200
     0.772    -0.006     0.200
     0.772     0.623     0.200
     0.772     0.404     0.200
     1.057    -1.636     0.200
     1.386    -2.542     0.200
     0.839    -0.103     0.200
     0.839     0.126     0.200
     1.401    -4.648     0.200
     1.473    -3.934     0.200
     1.683    -4.427     0.200
     1.909    -5.811     0.200
     2.104    -7.512     0.200
     8.421   -47.501     0.200
     0.624     1.411     0.200
     0.799     0.388     0.200
     0.799     1.247     0.200
     0.841     0.176     0.200
     0.841    -0.094     0.200
     1.399    -4.369     0.200
     2.285    -9.803     0.200
     8.419   -49.608     0.200
     0.714     0.658     0.200
     0.780     0.129     0.200
     1.109    -1.763     0.200
     4.272   -24.375     0.200
     0.722     0.821     0.200
     0.761     0.391     0.200
     1.081    -1.484     0.200
     1.086    -1.905     0.200
     1.357    -3.152     0.200
     0.711     0.471     0.200
     0.755     0.167     0.200
     1.010    -1.698     0.200
     0.997    -1.544     0.200
     1.019    -1.630     0.200
     1.019    -1.515     0.200
     1.051    -3.014     0.200
     1.429    -3.677     0.200
     1.597    -4.505     0.200
     3.011   -11.065     0.200
     0.904    -0.787     0.200
     1.093    -2.315     0.200
     1.182    -2.969     0.200
     1.182    -2.669     0.200
     1.174    -3.468     0.200
     1.261    -3.967     0.200
     1.578    -4.152     0.200
    10.868   -68.235     0.200
    11.967   -72.013     0.200
    12.059   -75.394     0.200
    13.489   -88.018     0.200
    15.954  -108.520     0.200
     1.085    -2.826     0.200
     1.177    -3.935     0.200
     1.168    -1.678     0.200
     1.168    -2.859     0.200
     1.168    -3.132     0.200
     2.376    -6.971     0.200
     0.676     1.971     0.200
     0.818     0.390     0.200
     1.094    -2.903     0.200
     6.727   -42.930     0.200
     0.496     3.946     0.200
     0.782     0.383     0.200
     0.933    -1.755     0.200
     1.054    -3.150     0.200
     1.100    -2.643     0.200
     1.342    -4.108     0.200
     1.612    -4.548     0.200
     2.442    -8.143     0.200
     2.492    -9.463     0.200
     2.772   -11.025     0.200
     3.889   -21.540     0.200
     4.274   -21.278     0.200
     4.674   -24.861     0.200
     5.633   -34.639     0.200
     6.544   -39.117     0.200
     6.787   -41.300     0.200
     8.066   -48.796     0.200
     8.903   -54.153     0.200
     0.753     0.017     0.200
     0.794    -0.376     0.200
     0.923    -1.988     0.200
     1.414    -3.867     0.200
     0.659     0.441     0.200
     0.653     0.835     0.200
     0.983    -2.749     0.200
     0.963    -1.401     0.200
     7.200   -46.888     0.200
     0.573     1.451     0.200
     0.573     2.970     0.200
     0.981    -1.577     0.200
     0.981    -1.858     0.200
     1.044    -2.159     0.200
     1.038    -1.742     0.200
     1.038    -2.699     0.200
     1.030    -1.346     0.200
     2.226    -5.900     0.200
     2.243    -6.498     0.200
     0.731     1.138     0.200
     1.008    -1.998     0.200
     1.008    -0.886     0.200
     1.612    -5.184     0.200
     1.921    -6.775     0.200
     1.945    -7.517     0.200
     2.751   -13.705     0.200
     3.286   -10.453     0.200
     3.335   -11.732     0.200
     3.665   -17.161     0.200
     4.428   -19.667     0.200
     4.556   -20.861     0.200
     4.632   -22.054     0.200
     5.411   -29.529     0.200
     6.209   -37.034     0.200
     6.242   -33.623     0.200
     6.281   -34.561     0.200
     6.330   -37.578     0.200
     6.842   -36.490     0.200
     6.860   -36.359     0.200
     7.063   -38.077     0.200
     7.475   -43.774     0.200
     7.953   -45.872     0.200
     8.076   -49.298     0.200
     8.662   -51.870     0.200
    10.210   -63.666     0.200
     0.648     1.450     0.200
     0.693     2.068     0.200
     1.085    -0.875     0.200
     4.180   -19.742     0.200
     5.435   -27.815     0.200
     6.384   -35.050     0.200
     7.444   -41.897     0.200
     0.767     1.458     0.200
     0.775     0.857     0.200
     0.780     0.437     0.200
     0.785     0.671     0.200
     3.848   -20.098     0.200
     3.848   -16.137     0.200
     4.279   -19.442     0.200
     4.463   -20.453     0.200
     4.650   -20.920     0.200
     5.484   -27.563     0.200
     5.558   -27.441     0.200
     6.046   -32.859     0.200
     6.120   -31.092     0.200
     6.387   -37.417     0.200
     6.766   -39.314     0.200
     7.908   -45.079     0.200
     8.086   -44.275     0.200
     9.752   -61.168     0.200
     9.762   -58.897     0.200
     0.414     1.587     0.200
     0.574     3.038     0.200
     0.659     0.907     0.200
     0.730     0.586     0.200
     0.871    -0.938     0.200
     0.988    -1.403     0.200
     2.224    -7.180     0.200
     2.239    -7.187     0.200
     6.064   -38.500     0.200
     6.064   -34.760     0.200
     6.213   -34.439     0.200
     7.155   -43.884     0.200
     9.861   -58.945     0.200
     1.001    -1.174     0.200
     1.023    -1.416     0.200
     1.023    -0.989     0.200
     1.008    -2.065     0.200
     2.213    -5.735     0.200
     0.608     2.283     0.200
     0.712     1.456     0.200
     0.995    -1.221     0.200
     1.014    -1.328     0.200
     1.014    -1.088     0.200
     1.010    -1.747     0.200
     1.308    -3.953     0.200
     1.433    -4.993     0.200
     1.690    -3.438     0.200
     1.691    -4.054     0.200
     2.158    -8.767     0.200
     2.190    -6.296     0.200
     2.207    -6.295     0.200
     2.701   -12.027     0.200
     0.730     1.313     0.200
     0.732     1.751     0.200
     0.984    -1.781     0.200
     1.061    -2.419     0.200
     1.040    -1.408     0.200
     1.059    -1.782     0.200
     1.059    -1.650     0.200
     1.651    -7.166     0.200
     1.812    -5.137     0.200
     2.238    -6.330     0.200
     0.610     1.659     0.200
     1.010    -1.422     0.200
     0.993    -1.375     0.200
     1.009    -1.677     0.200
     1.044    -2.279     0.200
     2.154    -8.880     0.200
     2.188    -5.906     0.200
     2.206    -5.988     0.200
     0.696     1.583     0.200
     0.800     0.109     0.200
     0.918    -1.785     0.200
     0.918    -0.982     0.200
     1.145    -3.042     0.200
     1.145    -1.674     0.200
     1.298    -2.538     0.200
     1.899    -5.799     0.200
     0.757     0.040     0.200
     0.810     0.656     0.200
     0.914    -1.746     0.200
     0.914    -1.172     0.200
     0.602     1.207     0.200
     0.840    -0.034     0.200
     0.898    -1.385     0.200
     3.875   -20.406     0.200
     0.741     1.996     0.200
     0.994    -0.501     0.200
     1.612    -5.450     0.200
     4.687   -26.357     0.200
     0.675     0.359     0.200
     0.647     1.177     0.200
     0.948    -1.831     0.200
     0.983    -2.176     0.200
     0.982    -2.522     0.200
     1.308    -3.280     0.200
     1.803    -5.538     0.200
     2.959   -12.276     0.200
     3.877   -16.598     0.200
     8.927   -54.627     0.200
    10.286   -63.245     0.200
    10.626   -71.488     0.200
     0.731     0.314     0.200
     0.850    -0.044     0.200
     0.886    -0.996     0.200
     0.941    -2.185     0.200
     0.941    -1.779     0.200
     0.606     0.953     0.200
     0.719     0.077     0.200
     0.719    -0.272     0.200
     0.760    -0.411     0.200
     0.907    -2.302     0.200
     0.907    -1.911     0.200
     3.685   -17.607     0.200
     4.247   -20.633     0.200
     5.475   -29.349     0.200
     0.710     2.025     0.200
     8.291   -49.365     0.200
     0.756     0.389     0.200
     0.756     1.689     0.200
     0.818    -0.366     0.200
     0.818     0.204     0.200
     1.177    -2.032     0.200
     8.436   -50.400     0.200
     0.731     1.604     0.200
     0.784     0.060     0.200
     0.810    -0.400     0.200
     0.845    -1.704     0.200
     0.845    -1.025     0.200
     0.934    -1.154     0.200
     1.138    -2.022     0.200
     1.863    -4.589     0.200
     2.101    -6.307     0.200
     7.944   -44.197     0.200
    13.232   -82.904     0.200
    16.179  -108.823     0.200
     0.504     2.691     0.200
     0.681     0.941     0.200
     0.819     0.390     0.200
     0.904    -1.397     0.200
     1.090    -2.897     0.200
     1.548    -4.167     0.200
     1.642    -4.676     0.200
     8.839   -52.695     0.200
     0.621     1.583     0.200
     0.741     0.611     0.200
     0.792     0.583     0.200
     0.834     0.543     0.200
     0.873    -0.393     0.200
     0.940    -1.767     0.200
     6.350   -39.624     0.200
    10.387   -64.567     0.200
     0.782     0.282     0.200
     0.933    -1.911     0.200
     0.933    -1.204     0.200
     1.102    -3.064     0.200
     1.102    -2.408     0.200
     1.106    -1.609     0.200
     0.783     1.111     0.200
     1.133    -1.111     0.200
     4.276   -24.217     0.200
     8.469   -50.845     0.200
     0.558     2.578     0.200
     0.688     0.596     0.200
     1.033    -1.324     0.200
     1.027    -1.789     0.200
     1.120    -1.774     0.200
     1.603    -4.086     0.200
     1.604    -5.044     0.200
     1.604    -4.099     0.200
     2.239    -6.845     0.200
     9.952   -59.865     0.200
     0.771     0.527     0.200
     0.813    -0.236     0.200
     0.939    -2.161     0.200
     1.160    -2.037     0.200
     1.713    -6.201     0.200
     1.713    -6.536     0.200
     1.957    -6.752     0.200
     4.297   -23.056     0.200
    13.731   -88.263     0.200
     1.035    -1.309     0.200
     1.358    -3.017     0.200
     1.395    -2.951     0.200
     4.674   -25.235     0.200
     5.317   -28.775     0.200
     5.517   -30.507     0.200
     0.686     0.938     0.200
     0.845    -0.568     0.200
     0.931    -1.631     0.200
     0.973    -2.110     0.200
     0.973    -2.415     0.200
     1.743    -4.423     0.200
     2.196    -7.686     0.200
     4.834   -27.190     0.200
     6.323   -34.451     0.200
     6.478   -36.821     0.200
     8.107   -45.431     0.200
     0.766    -0.266     0.200
     0.784     0.079     0.200
     1.160    -2.145     0.200
     1.295    -4.221     0.200
     1.347    -2.604     0.200
     1.630    -5.819     0.200
     2.433    -9.855     0.200
     3.082   -12.579     0.200
     8.355   -49.209     0.200
     0.747    -0.056     0.200
     0.750     0.008     0.200
     3.649   -18.424     0.200
     0.804    -0.324     0.200
     0.826    -0.439     0.200
     0.853     0.217     0.200
     1.057    -3.041     0.200
     1.167    -3.230     0.200
     1.167    -2.948     0.200
     1.584    -5.009     0.200
     1.585    -3.420     0.200
     0.648     1.528     0.200
     0.998    -2.829     0.200
     1.279    -3.264     0.200
     1.557    -5.652     0.200
     1.739    -5.589     0.200
     1.831    -6.261     0.200
     2.368   -10.435     0.200
     0.670     0.467     0.200
     0.950    -1.480     0.200
     0.979    -1.880     0.200
     0.979    -2.232     0.200
     1.385    -4.347     0.200
     1.720    -4.344     0.200
     1.810    -7.314     0.200
     3.029   -13.019     0.200
     9.255   -60.612     0.200
    10.052   -59.626     0.200
    16.070  -105.069     0.200
     0.820    -0.311     0.200
     1.048    -2.293     0.200
     1.146    -3.181     0.200
     1.146    -2.336     0.200
     1.153    -2.598     0.200
     1.153    -2.422     0.200
     1.153    -2.164     0.200
     1.508    -5.796     0.200
     2.396    -7.681     0.200
     3.248   -14.256     0.200
    13.368   -87.934     0.200
     0.629     0.649     0.200
     0.989    -2.968     0.200
     0.989    -1.557     0.200
     1.345    -3.961     0.200
     1.575    -5.215     0.200
     1.730    -7.064     0.200
     1.730    -3.743     0.200
     1.989    -7.281     0.200
     1.989    -6.425     0.200
     2.356   -11.542     0.200
     2.622   -12.250     0.200
     2.700   -14.170     0.200
     3.004   -12.814     0.200
     3.482   -16.862     0.200
     3.872   -19.998     0.200
     4.636   -22.041     0.200
     4.981   -27.838     0.200
     6.247   -37.666     0.200
     8.093   -44.818     0.200
     0.959     0.931     0.200
     1.236    -1.696     0.200
     1.242    -2.508     0.200
     1.470    -1.914     0.200
     1.567    -2.837     0.200
     1.573    -2.806     0.200
     1.573    -5.009     0.200
     1.631    -4.791     0.200
     1.631    -5.236     0.200
     1.778    -5.068     0.200
     1.979    -6.790     0.200
     2.293    -8.127     0.200
     2.429   -10.007     0.200
     2.612    -8.447     0.200
     2.631   -10.146     0.200
     2.943   -14.354     0.200
     2.943   -14.019     0.200
     3.705   -15.307     0.200
     4.354   -18.596     0.200
     4.721   -25.081     0.200
     4.744   -27.600     0.200
     4.900   -29.838     0.200
     5.582   -30.165     0.200
     0.625     1.164     0.200
     0.625     2.344     0.200
     1.018    -2.886     0.200
     1.018    -3.425     0.200
     1.399    -5.627     0.200
     2.673   -10.267     0.200
     4.218   -21.015     0.200
     9.621   -65.139     0.200
    13.382   -89.716     0.200
     0.792    -0.306     0.200
     0.944    -2.385     0.200
     0.944    -2.201     0.200
     1.405    -3.871     0.200
     1.733    -7.742     0.200
     2.589   -10.664     0.200
     3.090   -12.555     0.200
     3.812   -17.997     0.200
     5.471   -28.707     0.200
     6.352   -40.855     0.200
     0.780     0.550     0.200
     0.780     0.699     0.200
     0.888     0.430     0.200
     1.317    -3.409     0.200
     1.616    -4.722     0.200
    10.407   -64.464     0.200
     0.546     0.864     0.200
     0.633     1.010     0.200
     0.804    -0.033     0.200
     1.001    -2.653     0.200
     1.379    -3.820     0.200
     2.598   -13.695     0.200
     3.207   -11.983     0.200
     8.308   -52.260     0.200
     8.301   -46.179     0.200
     8.350   -50.271     0.200
     0.852    -0.382     0.200
     0.938    -1.678     0.200
     2.130   -10.843     0.200
     2.130    -8.373     0.200
     3.114   -13.898     0.200
     6.370   -37.885     0.200
     6.370   -37.785     0.200
    12.900   -80.439     0.200
     0.640     1.325     0.200
     0.795     1.702     0.200
     0.998    -1.516     0.200
     0.998    -2.096     0.200
     0.998    -1.207     0.200
     1.382    -4.479     0.200
     1.839    -9.380     0.200
     3.245   -13.378     0.200
     4.275   -17.876     0.200
     6.292   -38.600     0.200
     0.742     0.914     0.200
     0.742     1.969     0.200
     0.866    -0.557     0.200
    12.041   -75.894     0.200
     0.712     0.095     0.200
     0.806     0.548     0.200
     0.898    -1.587     0.200
     0.970    -3.203     0.200
     0.970    -2.809     0.200
     1.710    -5.070     0.200
     0.735     1.442     0.200
     1.228    -3.315     0.200
     1.410    -2.059     0.200
     1.410    -1.911     0.200
     2.540    -7.903     0.200
     2.615    -8.716     0.200
     0.663     1.426     0.200
     0.863     0.524     0.200
     1.261    -2.644     0.200
     1.543    -5.605     0.200
     1.733    -5.224     0.200
     2.363   -12.087     0.200
     2.691   -12.718     0.200
     3.026   -12.403     0.200
     1.223    -3.094     0.200
     1.223    -2.352     0.200
     1.409    -2.010     0.200
     1.409    -1.790     0.200
     1.577    -5.321     0.200
     2.540    -7.849     0.200
     2.614    -8.650     0.200
     0.758     0.582     0.200
     0.775     1.116     0.200
     0.822    -0.338     0.200
     0.415     1.662     0.200
     0.814    -0.541     0.200
     0.839    -1.152     0.200
     0.839    -1.453     0.200
     0.847    -0.769     0.200
     1.019    -2.505     0.200
     1.141    -2.982     0.200
     1.143    -2.632     0.200
     1.143    -3.136     0.200
     1.475    -3.457     0.200
     1.896    -6.970     0.200
     2.413    -7.950     0.200
     3.259   -16.342     0.200
     4.174   -22.531     0.200
     0.810     0.685     0.200
     0.852     0.731     0.200
     0.982    -0.471     0.200
     1.024    -1.466     0.200
     1.236    -3.516     0.200
     1.236    -3.391     0.200
     1.635    -4.890     0.200
     1.920    -7.826     0.200
     2.587   -12.273     0.200
     2.603    -8.543     0.200
     2.691   -13.581     0.200
     2.835   -13.641     0.200
     0.763     1.782     0.200
     0.904     0.290     0.200
     1.026    -1.274     0.200
     1.236    -3.587     0.200
     1.236    -3.337     0.200
     1.407    -1.841     0.200
     1.407    -1.927     0.200
     1.803    -4.321     0.200
     1.953    -6.633     0.200
     2.611    -8.674     0.200
     2.838   -12.623     0.200
     2.889   -10.501     0.200
     2.925   -11.403     0.200
     3.035   -13.948     0.200
     3.333   -14.755     0.200
     0.802    -0.120     0.200
     0.760     0.315     0.200
     1.435    -5.179     0.200
     2.609   -12.834     0.200
     3.055   -10.627     0.200
     3.849   -17.112     0.200
     8.465   -50.438     0.200
     1.412    -3.950     0.200
     1.957    -5.488     0.200
     0.812    -0.256     0.200
     2.319    -9.800     0.200
     2.629   -12.138     0.200
     0.762     1.881     0.200
     0.770     0.381     0.200
     0.817     0.024     0.200
     1.408    -4.267     0.200
     0.684     0.923     0.200
     0.890     0.055     0.200
     0.979    -3.087     0.200
     0.979    -2.262     0.200
     1.244    -2.976     0.200
     1.524    -4.968     0.200
     1.720    -7.160     0.200
     1.770    -6.084     0.200
     2.017    -5.187     0.200
     2.077    -7.784     0.200
     2.351   -11.769     0.200
     2.909   -11.558     0.200
     3.787   -20.647     0.200
     0.989    -3.067     0.200
     0.989    -2.641     0.200
     1.217    -2.367     0.200
     1.249    -3.109     0.200
     1.746    -4.304     0.200
     1.731    -4.966     0.200
     0.586     2.571     0.200
     0.638     0.572     0.200
     0.875    -1.842     0.200
     1.049    -3.132     0.200
     1.139    -3.650     0.200
     1.668    -5.085     0.200
     2.008    -5.861     0.200
     2.034    -6.502     0.200
     8.067   -47.777     0.200
     0.986    -2.785     0.200
     8.377   -50.828     0.200
    10.325   -66.189     0.200
     0.747     0.193     0.200
     1.497    -4.986     0.200
     1.570    -5.272     0.200
     2.011    -8.399     0.200
     0.809    -0.229     0.200
     0.947    -1.794     0.200
     0.947    -2.615     0.200
     1.428    -4.798     0.200
     1.686    -4.430     0.200
     2.460   -11.711     0.200
     2.604   -11.776     0.200
     2.879   -11.222     0.200
     3.060   -12.154     0.200
     3.131   -13.783     0.200
     3.108   -12.238     0.200
     3.732   -18.089     0.200
     3.841   -19.838     0.200
     3.928   -21.343     0.200
     4.300   -24.070     0.200
     4.340   -22.582     0.200
     4.660   -23.878     0.200
     5.204   -27.369     0.200
     7.517   -44.569     0.200
     7.540   -47.113     0.200
     8.457   -51.783     0.200
     0.785     0.383     0.200
     0.765    -0.031     0.200
     1.607    -5.464     0.200
     2.102    -9.150     0.200
     6.305   -38.178     0.200
     0.866    -0.204     0.200
     0.950    -2.559     0.200
     1.229    -2.284     0.200
     1.393    -4.498     0.200
     1.489    -4.232     0.200
     2.087    -8.273     0.200
     3.792   -21.122     0.200
     8.406   -52.417     0.200
     0.616     1.795     0.200
     0.677     1.122     0.200
     0.737     0.374     0.200
     1.231    -2.664     0.200
     1.383    -5.098     0.200
     1.383    -4.474     0.200
     1.440    -2.719     0.200
     2.001    -6.298     0.200
     2.012    -6.291     0.200
     2.156    -7.157     0.200
     2.962   -14.081     0.200
     3.025   -12.616     0.200
     7.170   -44.633     0.200
     0.619     1.581     0.200
     0.619     0.380     0.200
     0.679     1.095     0.200
     0.751    -0.057     0.200
     0.764     0.532     0.200
     0.764     0.313     0.200
     0.786     0.603     0.200
     1.169    -2.119     0.200
     1.295    -4.543     0.200
     1.320    -3.735     0.200
     1.427    -3.188     0.200
     1.581    -5.384     0.200
     1.588    -4.915     0.200
     1.594    -5.266     0.200
     1.635    -5.888     0.200
     1.634    -5.492     0.200
     1.718    -5.045     0.200
     0.638     0.574     0.200
     0.714     1.593     0.200
     0.749    -0.324     0.200
     0.870    -2.074     0.200
     1.541    -4.353     0.200
     2.089   -10.816     0.200
     2.089   -10.378     0.200
     0.579     0.797     0.200
     0.752    -0.057     0.200
     0.752    -0.495     0.200
     0.720     1.272     0.200
     0.752    -0.284     0.200
     0.876    -1.976     0.200
     1.347    -5.428     0.200
     2.083   -10.670     0.200
     3.753   -21.257     0.200
     6.285   -38.745     0.200
     0.699     1.289     0.200
     0.765    -0.918     0.200
     0.800    -1.025     0.200
     0.858    -2.009     0.200
     1.293    -3.817     0.200
     1.637    -4.977     0.200
     1.647    -4.147     0.200
     0.492     1.697     0.200
     0.580     2.568     0.200
     0.591     2.066     0.200
     0.610     2.161     0.200
     0.667     0.561     0.200
     0.667     0.371     0.200
     0.815    -0.566     0.200
     0.807     0.101     0.200
     0.819    -1.080     0.200
     0.841    -1.148     0.200
     0.840    -0.803     0.200
     0.843    -1.631     0.200
     0.850    -0.856     0.200
     0.858    -1.833     0.200
     0.967    -1.325     0.200
     0.988    -2.448     0.200
     0.980    -1.404     0.200
     1.127    -3.492     0.200
     1.127    -3.711     0.200
     1.149    -2.384     0.200
     2.001    -5.960     0.200
     0.418     1.227     0.200
     0.412     1.914     0.200
     0.483     1.849     0.200
     0.503     1.846     0.200
     0.503     3.154     0.200
     0.533     2.034     0.200
     0.533     2.955     0.200
     0.552     1.347     0.200
     0.543     1.657     0.200
     0.564     0.309     0.200
     0.542     2.410     0.200
     0.573     2.601     0.200
     0.559     1.334     0.200
     0.587     1.625     0.200
     0.670     0.664     0.200
     0.707     0.352     0.200
     0.731     1.889     0.200
     0.783    -1.140     0.200
     0.934    -1.929     0.200
     1.338    -5.541     0.200
     6.187   -39.111     0.200
     0.460     2.971     0.200
     0.487     1.897     0.200
     0.509     2.376     0.200
     0.568     1.762     0.200
     0.589     2.213     0.200
     0.630     1.860     0.200
     0.645     0.114     0.200
     0.719     1.277     0.200
     0.740    -0.620     0.200
     0.746    -0.775     0.200
     1.227    -2.823     0.200
     1.349    -3.486     0.200
     1.551    -9.028     0.200
     3.760   -23.529     0.200
     0.407     2.143     0.200
     0.437     1.093     0.200
     0.447     2.270     0.200
     0.469     2.379     0.200
     0.503     2.082     0.200
     0.503     2.472     0.200
     0.510     2.086     0.200
     0.518     2.012     0.200
     0.555     1.080     0.200
     0.598     1.307     0.200
     0.605     1.481     0.200
     0.636     2.537     0.200
     0.691     1.340     0.200
     0.689     2.162     0.200
     0.716     0.007     0.200
     0.716     0.593     0.200
     0.717     0.005     0.200
     0.735     0.297     0.200
     0.755     0.462     0.200
     0.797    -1.387     0.200
     0.879    -1.516     0.200
     1.211    -2.687     0.200
     6.347   -39.106     0.200
     0.366     2.217     0.200
     0.375     0.886     0.200
     0.377     1.627     0.200
     0.427     1.972     0.200
     0.443     3.433     0.200
     0.469     0.569     0.200
     0.482     0.674     0.200
     0.478     1.855     0.200
     0.591     2.436     0.200
     0.604     2.287     0.200
     0.626     1.360     0.200
     0.638     0.749     0.200
     0.678    -1.004     0.200
     0.889    -1.907     0.200
     0.902    -1.781     0.200
     1.144    -2.591     0.200
    10.748   -67.739     0.200
     0.421     1.640     0.200
     0.459     2.801     0.200
     0.494     1.681     0.200
     0.509     2.187     0.200
     0.587     1.804     0.200
     0.624     1.493     0.200
     0.718     1.193     0.200
     0.704     1.057     0.200
     0.735    -0.409     0.200
     0.757    -0.215     0.200
     0.756    -0.209     0.200
     0.796    -0.844     0.200
     1.550    -5.477     0.200
     3.774   -20.862     0.200
     5.259   -30.933     0.200
     6.529   -36.400     0.200
     0.503     2.329     0.200
     0.559     1.978     0.200
     0.566     1.138     0.200
     0.609     1.486     0.200
     0.611     1.854     0.200
     0.611     1.092     0.200
     0.661     1.932     0.200
     0.749     0.175     0.200
     0.896    -0.945     0.200
     0.939    -2.300     0.200
     1.524    -6.711     0.200
     1.465    -3.273     0.200
     0.445     1.799     0.200
     0.514     1.432     0.200
     0.588     1.165     0.200
     0.548     1.626     0.200
     0.626     0.679     0.200
     0.616     1.106     0.200
     0.612     0.295     0.200
     0.639     0.560     0.200
     0.628     1.431     0.200
     0.640     0.829     0.200
     0.665     0.084     0.200
     0.705    -0.012     0.200
     0.753    -0.123     0.200
     0.728    -0.079     0.200
     0.742    -0.132     0.200
     0.736     1.306     0.200
     0.730     0.625     0.200
     0.730     1.515     0.200
     0.772     0.538     0.200
     0.800     0.104     0.200
     0.826    -0.568     0.200
     0.813     0.187     0.200
     0.864    -0.851     0.200
     0.894    -1.674     0.200
     0.908    -1.526     0.200
     0.944    -1.725     0.200
     0.976    -1.964     0.200
     0.997    -1.751     0.200
     1.022    -1.975     0.200
     0.494     2.093     0.200
     0.609     1.883     0.200
     0.595     2.912     0.200
     0.740     0.868     0.200
     0.760     1.210     0.200
     0.811    -0.334     0.200
     0.896     0.379     0.200
     0.896     1.210     0.200
     1.531    -5.185     0.200
     1.604    -4.480     0.200
     3.802   -22.075     0.200
     0.444     2.398     0.200
     0.491     2.090     0.200
     0.500     3.260     0.200
     0.514     1.026     0.200
     0.554     2.092     0.200
     0.547     1.199     0.200
     0.575     1.780     0.200
     0.602     0.384     0.200
     0.618     1.617     0.200
     0.608     2.450     0.200
     0.608     2.134     0.200
     0.633     1.646     0.200
     0.726     1.208     0.200
     0.740     0.202     0.200
     0.787     0.815     0.200
     0.805     0.673     0.200
     0.832     0.895     0.200
     0.922    -1.632     0.200
     1.511    -5.459     0.200
     1.606    -5.264     0.200
     0.417     1.539     0.200
     0.471     2.187     0.200
     0.497     1.599     0.200
     0.520     2.727     0.200
     0.549     1.871     0.200
     0.600     1.963     0.200
     0.640     1.470     0.200
     0.716     1.416     0.200
     0.751    -0.207     0.200
     0.799     0.089     0.200
     0.866    -1.617     0.200
     1.221    -2.409     0.200
     5.241   -26.846     0.200
     0.552     1.718     0.200
     0.589     1.742     0.200
     0.594     0.491     0.200
     0.625     0.034     0.200
     0.629     1.425     0.200
     0.643     0.197     0.200
     0.748    -0.512     0.200
     0.761    -0.116     0.200
     1.067    -2.242     0.200
     1.551    -6.728     0.200
     1.604    -5.657     0.200
     3.762   -19.124     0.200
     4.981   -29.325     0.200
     0.415     2.154     0.200
     0.446     2.013     0.200
     0.493     1.830     0.200
     0.507     0.566     0.200
     0.513     2.198     0.200
     0.503     2.291     0.200
     0.513     2.605     0.200
     0.539     2.345     0.200
     0.602     0.835     0.200
     0.650     0.267     0.200
     0.681     0.155     0.200
     0.652    -0.095     0.200
     0.730    -0.198     0.200
     0.772    -0.433     0.200
     0.727    -0.001     0.200
     0.740     0.480     0.200
     0.777     0.519     0.200
     0.821    -0.912     0.200
     0.864    -1.447     0.200
     0.863    -1.123     0.200
     0.864    -1.457     0.200
     0.864    -1.267     0.200
     0.873    -1.554     0.200
     0.904    -1.344     0.200
     0.911    -1.588     0.200
     0.754     4.221     0.200
     0.944    -1.466     0.200
     0.950    -1.455     0.200
     1.179    -3.357     0.200
     1.317    -2.907     0.200
     0.407     1.244     0.200
     0.438     1.831     0.200
     0.595     0.987     0.200
     0.533     2.329     0.200
     0.559     2.165     0.200
     0.555     2.405     0.200
     0.697     0.665     0.200
     0.698     0.497     0.200
     0.685     0.950     0.200
     0.685     1.104     0.200
     0.720     1.335     0.200
     0.775     0.891     0.200
     0.752     2.042     0.200
     0.784     0.135     0.200
     0.930    -1.185     0.200
     0.974    -2.088     0.200
     1.053    -2.402     0.200
     1.197    -3.006     0.200
     0.485     1.852     0.200
     0.471     2.253     0.200
     0.444     3.331     0.200
     0.482     1.347     0.200
     0.482     1.786     0.200
     0.591     1.157     0.200
     0.535     2.012     0.200
     0.558     1.858     0.200
     0.556     2.060     0.200
     0.596     0.435     0.200
     0.681     0.827     0.200
     0.692     1.268     0.200
     0.694     0.690     0.200
     0.686     0.604     0.200
     0.697     0.622     0.200
     0.690     0.763     0.200
     0.722     1.158     0.200
     0.776     0.768     0.200
     0.787     0.028     0.200
     0.758    -0.051     0.200
     0.840     0.361     0.200
     0.927    -1.100     0.200
     0.969    -1.945     0.200
     1.023    -2.556     0.200
     1.195    -3.158     0.200
     1.209    -2.078     0.200
     1.367    -2.609     0.200
     1.426    -3.352     0.200
     0.573     2.374     0.200
     0.671     2.289     0.200
     0.728     0.265     0.200
     0.705     2.466     0.200
     0.752     0.780     0.200
     0.720     1.024     0.200
     0.729     1.418     0.200
     0.729     1.769     0.200
     0.759     1.865     0.200
     0.766    -0.001     0.200
     0.773     0.525     0.200
     0.781     0.122     0.200
     0.824     0.124     0.200
     0.824     1.034     0.200
     0.896    -0.388     0.200
     0.928    -0.964     0.200
     0.950    -2.027     0.200
     0.942    -1.287     0.200
     0.936    -1.188     0.200
     0.994    -1.969     0.200
     0.995    -1.033     0.200
     1.009    -1.041     0.200
     1.010    -1.177     0.200
     1.012    -2.037     0.200
     1.010    -1.332     0.200
     1.059    -1.416     0.200
     1.107    -1.777     0.200
     1.208    -2.497     0.200
     1.210    -2.827     0.200
     1.292    -2.333     0.200
     1.348    -2.504     0.200
     1.360    -2.329     0.200
     1.408    -3.143     0.200
     1.409    -3.138     0.200
     1.432    -4.026     0.200
     2.073    -8.809     0.200
    11.005   -68.604     0.200
     0.453     1.501     0.200
     0.497     2.095     0.200
     0.538     1.958     0.200
     0.569     1.388     0.200
     0.587     1.244     0.200
     0.651     0.875     0.200
     0.657     0.848     0.200
     0.664     0.508     0.200
     0.675     1.747     0.200
     0.675     2.608     0.200
     0.673     1.367     0.200
     0.673     0.898     0.200
     0.753     1.851     0.200
     0.753     1.655     0.200
     0.882    -0.070     0.200
     0.901    -0.323     0.200
     0.986    -2.216     0.200
     1.041    -2.280     0.200
     1.290    -2.640     0.200
     1.609    -7.975     0.200
     1.813    -4.310     0.200
     3.986   -21.413     0.200
     6.730   -40.552     0.200
     6.730   -38.091     0.200
     0.453     1.354     0.200
     0.453     2.345     0.200
     0.461     0.793     0.200
     0.461     1.322     0.200
     0.670     0.538     0.200
     0.366     2.032     0.200
     0.696     0.965     0.200
     0.696     0.125     0.200
     0.430     1.052     0.200
     0.437     2.628     0.200
     0.435     2.448     0.200
     0.630     1.550     0.200
     0.630     2.600     0.200
     0.630     1.891     0.200
     0.645     2.328     0.200
     0.627     1.221     0.200
     0.632     1.034     0.200
     0.423     1.710     0.200
     0.386     1.888     0.200
     0.613     0.831     0.200
     0.398     1.462     0.200
     0.693     0.846     0.200
     0.597     1.071     0.200
     0.848    -1.074     0.200
     0.493     1.228     0.200
     0.591     0.735     0.200
     1.103    -2.761     0.200
     1.103    -2.833     0.200
     0.400     1.814     0.200
     0.392     1.263     0.200
     0.374     1.727     0.200
     0.413     1.652     0.200
     0.439     1.656     0.200
     0.504     1.166     0.200
     0.457     1.263     0.200
     0.603     0.193     0.200
     0.611     1.016     0.200
     0.626     0.608     0.200
     0.619     1.645     0.200
     0.638     0.654     0.200
     0.616     1.943     0.200
     0.676     0.731     0.200
     0.706     0.613     0.200
     0.683     0.710     0.200
     0.729     0.729     0.200
     0.995    -1.577     0.200
     1.033    -1.784     0.200
     1.116    -2.959     0.200
     0.394     1.399     0.200
     0.402     1.941     0.200
     0.373     1.963     0.200
     0.421     2.159     0.200
     0.438     1.325     0.200
     0.464     0.768     0.200
     0.484     1.436     0.200
     0.524     0.318     0.200
     0.606     0.770     0.200
     0.627     0.716     0.200
     0.618     1.049     0.200
     0.614     1.779     0.200
     0.638     0.197     0.200
     0.707     0.504     0.200
     0.675     0.529     0.200
     0.681     0.313     0.200
     0.852    -1.104     0.200
     0.888    -2.219     0.200
     0.862    -1.213     0.200
     0.937    -2.153     0.200
     1.047    -2.590     0.200
     1.110    -3.464     0.200
     1.118    -2.778     0.200
     1.118    -2.910     0.200
     0.426     1.446     0.200
     0.426     1.336     0.200
     0.451     2.714     0.200
     0.465     2.216     0.200
     0.495     1.643     0.200
     0.495     2.453     0.200
     0.489     2.375     0.200
     0.502     2.537     0.200
     0.502     2.137     0.200
     0.502     3.027     0.200
     0.531     1.519     0.200
     0.531     2.219     0.200
     0.579     1.582     0.200
     0.577     1.936     0.200
     0.577     3.116     0.200
     0.612     0.982     0.200
     0.607     2.677     0.200
     0.693     1.262     0.200
     0.723     0.042     0.200
     0.737     1.457     0.200
     0.744     0.052     0.200
     0.750     1.238     0.200
     0.762    -0.386     0.200
     0.765     0.093     0.200
     0.782     0.101     0.200
     0.816     0.576     0.200
     1.049    -1.742     0.200
     1.212    -2.482     0.200
     1.281    -4.247     0.200
     1.557    -5.145     0.200
     3.790   -16.516     0.200
     0.409     1.510     0.200
     0.439     2.896     0.200
     0.456     2.601     0.200
     0.471     0.743     0.200
     0.481     2.425     0.200
     0.478     1.690     0.200
     0.478     2.315     0.200
     0.489     1.857     0.200
     0.468     1.397     0.200
     0.468     1.054     0.200
     0.566     2.203     0.200
     0.566     2.219     0.200
     0.604     1.502     0.200
     0.547     1.827     0.200
     0.618     0.303     0.200
     0.613     1.813     0.200
     0.735     1.376     0.200
     0.707     1.021     0.200
     0.773     1.053     0.200
     0.777    -0.067     0.200
     0.777    -0.246     0.200
     0.766     0.231     0.200
     0.766     0.754     0.200
     0.814    -1.362     0.200
     0.843    -1.730     0.200
     0.921    -1.654     0.200
     1.571    -6.156     0.200
     3.738   -17.018     0.200
     3.783   -20.337     0.200
     5.007   -25.323     0.200
     5.274   -28.139     0.200
     5.274   -26.108     0.200
     5.696   -30.159     0.200
     5.872   -30.682     0.200
     8.685   -50.616     0.200
     9.956   -59.390     0.200
    10.379   -60.501     0.200
    12.738   -77.725     0.200
     0.536     1.464     0.200
     0.536     1.628     0.200
     0.610     0.998     0.200
     0.617     2.570     0.200
     0.618     2.509     0.200
     0.695     1.201     0.200
     0.983    -1.463     0.200
     1.569    -8.343     0.200
     0.442     2.548     0.200
     0.456     2.523     0.200
     0.616     2.368     0.200
     0.480     2.364     0.200
     0.489     1.895     0.200
     0.493     2.373     0.200
     0.568     1.637     0.200
     0.572     1.710     0.200
     0.603     1.110     0.200
     0.729     1.256     0.200
     0.757     0.443     0.200
     0.741     1.398     0.200
     0.773     0.433     0.200
     0.777     1.130     0.200
     0.807     0.552     0.200
     0.985    -1.401     0.200
     1.578    -4.954     0.200
     1.744    -5.859     0.200
     3.795   -16.099     0.200
     5.010   -27.437     0.200
     5.283   -28.672     0.200
     5.694   -30.614     0.200
     5.874   -32.163     0.200
     0.394     1.480     0.200
     0.394     1.649     0.200
     0.433     2.946     0.200
     0.456     2.657     0.200
     0.465     1.792     0.200
     0.465     1.632     0.200
     0.454     1.277     0.200
     0.482     2.240     0.200
     0.480     2.238     0.200
     0.554     1.503     0.200
     0.562     2.176     0.200
     0.562     2.156     0.200
     0.564     1.435     0.200
     0.564     1.555     0.200
     0.604     1.483     0.200
     0.604     0.160     0.200
     0.730     0.861     0.200
     0.723     1.327     0.200
     0.767     1.206     0.200
     0.830    -0.991     0.200
     0.838    -1.105     0.200
     1.050    -1.880     0.200
     1.181    -2.254     0.200
     1.257    -4.488     0.200
     1.578    -8.504     0.200
     1.579    -5.081     0.200
     3.771   -19.967     0.200
     5.872   -33.839     0.200
     6.534   -38.111     0.200
     8.894   -56.387     0.200
     0.401     1.510     0.200
     0.401     1.398     0.200
     0.401     1.750     0.200
     0.401     2.558     0.200
     0.436     1.434     0.200
     0.436     1.745     0.200
     0.461     3.214     0.200
     0.461     1.354     0.200
     0.481     1.749     0.200
     0.481     1.640     0.200
     0.481     2.269     0.200
     0.486     2.867     0.200
     0.509     2.320     0.200
     0.509     2.070     0.200
     0.505     1.614     0.200
     0.505     2.305     0.200
     0.505     1.124     0.200
     0.578     1.591     0.200
     0.591     2.360     0.200
     0.591     1.511     0.200
     0.583     1.925     0.200
     0.564     2.142     0.200
     0.634     1.803     0.200
     0.634     1.383     0.200
     0.652     0.895     0.200
     0.652     1.065     0.200
     0.744     0.198     0.200
     0.890    -1.234     0.200
     1.552    -8.706     0.200
     1.608    -5.334     0.200
     3.750   -19.290     0.200
     5.843   -29.208     0.200
     0.357     1.613     0.200
     0.467     1.904     0.200
     0.506     2.136     0.200
     0.515     1.082     0.200
     0.515     1.914     0.200
     0.579     1.529     0.200
     0.590     2.079     0.200
     0.587     1.541     0.200
     0.639     1.207     0.200
     0.665     0.093     0.200
     0.665     0.996     0.200
     0.665     1.496     0.200
     0.720    -1.039     0.200
     0.730    -1.461     0.200
     1.612    -6.663     0.200
     3.719   -15.554     0.200
     4.969   -24.260     0.200
     5.226   -26.424     0.200
     0.391     1.688     0.200
     0.488     2.031     0.200
     0.508     2.163     0.200
     0.513     2.270     0.200
     0.513     1.589     0.200
     0.564     1.880     0.200
     0.569     2.097     0.200
     0.607     0.669     0.200
     0.607     1.341     0.200
     0.644     1.717     0.200
     0.644     1.730     0.200
     0.614     1.167     0.200
     0.614     0.085     0.200
     0.623     1.252     0.200
     0.623     1.447     0.200
     0.623     1.427     0.200
     0.668     1.045     0.200
     0.695     0.849     0.200
     0.701    -0.188     0.200
     0.701     1.300     0.200
     0.765    -0.068     0.200
     0.774     0.086     0.200
     0.896    -1.147     0.200
     0.926    -2.486     0.200
     3.905   -21.481     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.103     2.646     0.200
     0.720    -0.020     0.200
     1.186    -0.453     0.200
     1.286     0.348     0.200
     1.290     1.860     0.200
     1.345     0.138     0.200
     1.347     1.993     0.200
     0.777    -0.645     0.200
     1.173     0.531     0.200
     1.271     0.421     0.200
     1.275     1.886     0.200
     1.333     0.118     0.200
     0.758     0.538     0.200
     1.225     0.073     0.200
     1.324     0.126     0.200
     1.354     1.705     0.200
     1.379     0.406     0.200
     1.432     0.094     0.200
     0.740    -1.253     0.200
     1.205    -0.003     0.200
     1.308    -0.100     0.200
     1.362     0.189     0.200
     1.367     0.232     0.200
     1.418    -0.010     0.200
     3.775    -4.602     0.200
     0.052     1.467     0.200
     0.086     1.189     0.200
     0.333    -0.264     0.200
     0.378    -0.527     0.200
     0.639     0.489     0.200
     0.681     0.407     0.200
     0.914    -1.339     0.200
     0.954     0.128     0.200
     0.973     0.392     0.200
     1.102     0.098     0.200
     1.126    -0.036     0.200
     1.327    -1.646     0.200
     0.203    -0.851     0.200
     0.179     0.904     0.200
     0.216     1.127     0.200
     0.396     0.023     0.200
     0.674     0.514     0.200
     0.762     0.451     0.200
     0.912    -0.691     0.200
     0.912    -1.097     0.200
     0.867     0.108     0.200
     0.990    -0.712     0.200
     0.990    -1.305     0.200
     1.013     0.010     0.200
     1.086     0.058     0.200
     1.201    -1.154     0.200
     1.234     0.280     0.200
     1.306    -1.200     0.200
     1.257     0.228     0.200
     1.537    -1.365     0.200
     1.532    -0.654     0.200
     1.665    -2.183     0.200
     2.254    -1.515     0.200
     3.534    -3.704     0.200
     3.759    -3.052     0.200
     5.934    -6.195     0.200
     6.350    -5.945     0.200
     0.080     1.486     0.200
     0.535    -0.378     0.200
     0.535    -0.121     0.200
     0.640     0.359     0.200
     0.749     0.282     0.200
     0.950     0.198     0.200
     1.098     0.081     0.200
     1.121     0.031     0.200
     1.697     0.135     0.200
     0.625    -0.152     0.200
     0.641    -0.301     0.200
     0.725    -0.917     0.200
     0.725    -0.678     0.200
     1.033    -1.204     0.200
     1.151    -0.978     0.200
     1.392    -0.435     0.200
     1.408    -1.967     0.200
     2.189    -4.432     0.200
     2.776    -4.588     0.200
     2.800    -4.582     0.200
     2.855    -5.244     0.200
     2.899    -4.218     0.200
     2.913    -5.059     0.200
     3.102    -5.128     0.200
     3.297    -5.536     0.200
     3.573    -7.163     0.200
     0.024     2.992     0.200
     0.075     2.667     0.200
     0.625    -0.190     0.200
     0.650    -0.179     0.200
     0.733    -0.996     0.200
     0.991     0.787     0.200
     1.039    -0.906     0.200
     1.151     0.602     0.200
     1.398     1.821     0.200
     1.577    -1.566     0.200
     1.850    -2.468     0.200
     1.960    -2.173     0.200
     2.192    -2.906     0.200
     2.444    -3.375     0.200
     2.478    -3.629     0.200
     2.785    -4.642     0.200
     2.780    -4.048     0.200
     2.780    -3.642     0.200
     2.807    -3.072     0.200
     0.046     2.820     0.200
     0.627    -0.102     0.200
     0.726    -0.971     0.200
     1.012     1.000     0.200
     1.139    -0.134     0.200
     1.156    -0.526     0.200
     1.354    -2.179     0.200
     1.342     0.404     0.200
     1.384    -0.161     0.200
     1.558    -1.738     0.200
     1.701    -1.686     0.200
     1.937    -1.895     0.200
     2.090    -2.968     0.200
     2.469    -3.647     0.200
     0.642    -0.238     0.200
     0.636     0.044     0.200
     0.683     0.336     0.200
     0.740    -1.039     0.200
     0.999     0.188     0.200
     1.021    -0.530     0.200
     1.134     0.764     0.200
     1.155    -0.556     0.200
     1.331    -0.723     0.200
     1.400    -0.881     0.200
     1.400     2.981     0.200
     1.559    -1.485     0.200
     1.715    -1.544     0.200
     1.860    -2.446     0.200
     1.943    -1.710     0.200
     2.105    -3.304     0.200
     2.248    -2.064     0.200
     2.455    -3.761     0.200
     2.644    -2.624     0.200
     2.762    -3.741     0.200
     2.789    -4.076     0.200
     2.944    -2.849     0.200
     0.045     2.500     0.200
     0.635    -0.061     0.200
     0.628     0.183     0.200
     0.726    -0.860     0.200
     1.011     0.964     0.200
     1.020    -1.071     0.200
     1.140     0.072     0.200
     1.157    -0.805     0.200
     1.352    -2.289     0.200
     1.343     0.288     0.200
     1.386     0.117     0.200
     1.414     0.892     0.200
     1.560    -1.575     0.200
     1.846    -2.711     0.200
     1.939    -2.041     0.200
     2.090    -3.265     0.200
     2.196    -2.972     0.200
     2.443    -3.281     0.200
     2.469    -3.412     0.200
     2.762    -4.168     0.200
     2.940    -2.777     0.200
     0.045     1.286     0.200
     0.473     0.969     0.200
     0.627    -0.346     0.200
     0.641    -0.003     0.200
     0.732    -1.085     0.200
     1.010     1.087     0.200
     1.016    -1.247     0.200
     1.134     0.236     0.200
     1.152    -1.256     0.200
     1.201    -1.581     0.200
     1.337     0.063     0.200
     1.359    -2.492     0.200
     1.379     0.355     0.200
     1.411    -1.432     0.200
     1.852    -2.484     0.200
     1.936    -1.939     0.200
     2.095    -3.684     0.200
     2.203    -3.092     0.200
     2.475    -3.608     0.200
     2.758    -4.245     0.200
     2.783    -3.495     0.200
     2.883    -2.703     0.200
     0.031     2.395     0.200
     0.031     2.545     0.200
     0.643    -0.359     0.200
     0.626    -0.608     0.200
     0.728    -0.886     0.200
     0.998     0.807     0.200
     1.035    -1.444     0.200
     1.344    -1.875     0.200
     1.346     0.189     0.200
     1.390    -0.018     0.200
     1.574    -1.780     0.200
     1.846    -2.728     0.200
     1.954    -2.219     0.200
     2.094    -3.753     0.200
     2.776    -4.188     0.200
     2.802    -3.646     0.200
     2.901    -2.010     0.200
     2.956    -3.822     0.200
     0.031     1.479     0.200
     0.632     0.091     0.200
     0.642    -0.349     0.200
     0.659     0.665     0.200
     0.692     0.283     0.200
     0.734    -1.283     0.200
     0.997     0.999     0.200
     1.031    -1.112     0.200
     1.144    -0.542     0.200
     1.165    -0.700     0.200
     1.350    -2.424     0.200
     1.339     0.293     0.200
     1.383    -0.209     0.200
     1.852    -2.398     0.200
     1.951    -1.858     0.200
     2.197    -2.633     0.200
     2.478    -3.416     0.200
     2.772    -3.289     0.200
     0.626    -0.549     0.200
     0.643    -0.273     0.200
     0.677    -0.313     0.200
     0.736     0.883     0.200
     1.015    -0.897     0.200
     1.133     0.295     0.200
     1.133     0.545     0.200
     1.151    -0.078     0.200
     1.460    -2.089     0.200
     1.411     0.154     0.200
     1.853    -2.485     0.200
     2.096    -3.509     0.200
     2.475    -3.771     0.200
     2.756    -4.648     0.200
     2.757    -3.856     0.200
     2.782    -3.638     0.200
     3.555    -3.877     0.200
     0.729     1.823     0.200
     1.012    -0.797     0.200
     1.466    -2.370     0.200
     1.551    -1.504     0.200
     1.709    -1.977     0.200
     1.934    -2.230     0.200
     2.102    -3.786     0.200
     2.481    -3.544     0.200
     2.754    -3.727     0.200
     2.754    -3.606     0.200
     2.780    -3.994     0.200
     3.083    -4.779     0.200
     3.281    -4.745     0.200
     0.018     2.925     0.200
     0.018     3.425     0.200
     0.678    -0.042     0.200
     0.635     0.121     0.200
     0.767    -1.081     0.200
     1.053    -0.735     0.200
     1.144     0.303     0.200
     1.179    -0.878     0.200
     1.357    -2.173     0.200
     1.499    -2.080     0.200
     1.586    -1.622     0.200
     1.607    -2.344     0.200
     0.580    -0.177     0.200
     0.744    -0.434     0.200
     0.769     0.211     0.200
     0.752     1.925     0.200
     0.934     0.477     0.200
     1.203    -1.387     0.200
     1.303    -2.257     0.200
     1.561    -2.487     0.200
     1.645    -1.902     0.200
     2.026    -3.996     0.200
     2.163    -4.296     0.200
     0.198    -0.873     0.200
     0.248     1.076     0.200
     1.122     0.280     0.200
     1.213    -1.427     0.200
     1.177     0.757     0.200
     1.206    -0.876     0.200
     1.206     0.575     0.200
     1.268     0.093     0.200
     3.027    -3.717     0.200
     3.075    -4.185     0.200
     0.060     0.821     0.200
     0.601    -0.058     0.200
     0.774    -0.842     0.200
     1.109    -1.666     0.200
     1.187    -0.510     0.200
     1.230    -1.359     0.200
     1.330    -0.530     0.200
     1.330     3.150     0.200
     1.587    -2.062     0.200
     1.639    -1.861     0.200
     1.879    -2.587     0.200
     2.046    -3.356     0.200
     2.146    -3.600     0.200
     2.188    -4.154     0.200
     4.507    -3.583     0.200
     0.139     2.641     0.200
     0.652    -0.446     0.200
     0.965    -0.407     0.200
     1.013    -0.941     0.200
     1.097     0.041     0.200
     1.324    -0.082     0.200
     1.354     0.850     0.200
     1.354     1.076     0.200
     1.522    -2.543     0.200
     1.541    -1.356     0.200
     1.944    -1.966     0.200
     2.130    -3.461     0.200
     2.651    -4.033     0.200
     2.748    -4.807     0.200
     2.781    -2.817     0.200
     3.092    -4.352     0.200
     3.302    -5.008     0.200
     3.533    -5.461     0.200
     3.584    -5.676     0.200
     0.481     0.427     0.200
     0.987    -0.493     0.200
     0.997    -0.089     0.200
     2.712    -2.590     0.200
     2.765    -4.954     0.200
     0.799    -1.464     0.200
     0.799    -1.000     0.200
     1.123    -0.904     0.200
     1.187    -0.057     0.200
     1.238    -0.770     0.200
     1.537    -1.893     0.200
     1.815    -1.479     0.200
     2.054    -1.623     0.200
     2.171    -3.225     0.200
     2.856    -4.818     0.200
     2.891    -4.030     0.200
     2.981    -3.651     0.200
     3.055    -3.979     0.200
     3.791    -3.789     0.200
     4.254    -4.477     0.200
     0.265     0.880     0.200
     0.632    -0.622     0.200
     1.088     0.879     0.200
     1.403    -1.900     0.200
     2.671    -4.131     0.200
     2.877    -2.492     0.200
     2.914    -2.913     0.200
     3.059    -4.431     0.200
     4.216    -2.480     0.200
     0.082     2.997     0.200
     0.086     2.903     0.200
     0.119     2.789     0.200
     0.499     0.101     0.200
     0.779    -1.318     0.200
     1.089    -0.795     0.200
     1.089    -0.779     0.200
     1.167    -0.094     0.200
     1.199     0.064     0.200
     1.210    -0.629     0.200
     1.333    -0.864     0.200
     1.333     1.105     0.200
     1.618    -1.358     0.200
     2.150    -3.393     0.200
     2.825    -4.083     0.200
     2.857    -4.525     0.200
     3.166    -3.629     0.200
     0.090     1.816     0.200
     0.135     2.635     0.200
     0.084     2.944     0.200
     0.502     0.740     0.200
     0.793    -1.227     0.200
     0.793    -0.918     0.200
     1.098    -0.653     0.200
     1.097    -0.637     0.200
     1.167    -0.242     0.200
     1.214    -1.619     0.200
     1.316    -1.287     0.200
     1.317     0.278     0.200
     2.831    -4.370     0.200
     2.865    -4.179     0.200
     3.811    -3.723     0.200
     0.223     0.714     0.200
     0.226     0.570     0.200
     1.041     0.512     0.200
     1.124     0.257     0.200
     1.149     1.149     0.200
     1.150     0.343     0.200
     1.150     2.382     0.200
     1.150     3.472     0.200
     1.193     0.153     0.200
     1.223    -1.656     0.200
     1.257    -0.016     0.200
     1.697    -2.205     0.200
     1.697    -1.934     0.200
     3.045    -4.407     0.200
     0.371     0.322     0.200
     0.371     0.799     0.200
     0.384     0.194     0.200
     0.381     1.898     0.200
     0.692    -0.333     0.200
     0.692    -0.320     0.200
     0.788    -0.811     0.200
     0.778    -0.357     0.200
     1.250    -1.714     0.200
     1.294    -0.553     0.200
     1.624    -2.631     0.200
     2.439    -3.279     0.200
     2.454    -3.847     0.200
     2.601    -4.010     0.200
     2.749    -4.347     0.200
     0.253    -0.444     0.200
     0.537    -0.206     0.200
     0.536    -0.193     0.200
     0.523     1.440     0.200
     0.709    -0.080     0.200
     0.799    -0.056     0.200
     0.918    -0.913     0.200
     1.057    -0.877     0.200
     1.385    -1.195     0.200
     1.459    -1.657     0.200
     1.671    -0.861     0.200
     1.672     1.818     0.200
     1.811    -1.304     0.200
     2.170    -3.219     0.200
     2.408    -3.318     0.200
     2.460    -4.163     0.200
     2.607    -3.515     0.200
     3.052    -4.139     0.200
     3.081    -2.495     0.200
     3.684    -4.663     0.200
     0.149     2.241     0.200
     0.702    -1.062     0.200
     0.832     0.779     0.200
     0.828    -0.198     0.200
     0.861     0.004     0.200
     0.924    -0.675     0.200
     1.333    -1.471     0.200
     1.443    -2.277     0.200
     1.448     0.265     0.200
     1.504    -0.116     0.200
     2.075    -4.482     0.200
     2.074    -4.118     0.200
     5.343    -3.397     0.200
     0.084     2.546     0.200
     0.035     3.196     0.200
     0.688    -1.224     0.200
     0.784    -0.646     0.200
     0.806     0.268     0.200
     0.806     0.885     0.200
     1.238     0.050     0.200
     1.426    -1.811     0.200
     1.409    -2.652     0.200
     1.409    -0.946     0.200
     1.570    -1.841     0.200
     2.060    -2.892     0.200
     2.113    -2.242     0.200
     2.870    -4.192     0.200
     2.865    -5.283     0.200
     2.865    -5.282     0.200
     3.716    -3.426     0.200
     0.101     2.149     0.200
     0.430     0.689     0.200
     0.494     0.557     0.200
     0.528     0.265     0.200
     1.017    -0.742     0.200
     1.239    -0.298     0.200
     1.321     0.248     0.200
     1.435    -0.599     0.200
     1.449     1.415     0.200
     1.481    -0.659     0.200
     0.022     3.918     0.200
     0.101     1.952     0.200
     0.416     0.038     0.200
     0.731    -1.564     0.200
     0.784     1.185     0.200
     0.919    -0.555     0.200
     1.692    -1.558     0.200
     2.062    -1.276     0.200
     2.896    -3.804     0.200
     0.128     0.027     0.200
     0.142     0.346     0.200
     0.658     1.072     0.200
     0.734     0.369     0.200
     0.856    -0.981     0.200
     1.137     0.590     0.200
     1.126    -0.905     0.200
     1.161    -0.220     0.200
     1.229    -1.163     0.200
     1.249    -0.512     0.200
     1.249     1.012     0.200
     1.275     0.121     0.200
     1.642    -2.059     0.200
     1.643    -1.026     0.200
     2.065    -1.987     0.200
     0.129     0.725     0.200
     0.658     0.724     0.200
     0.856    -1.614     0.200
     1.127    -1.017     0.200
     1.137     0.246     0.200
     1.161    -0.296     0.200
     1.248    -0.676     0.200
     1.229    -0.884     0.200
     1.249    -0.060     0.200
     1.276    -0.179     0.200
     1.334    -0.318     0.200
     1.643    -0.119     0.200
     2.066    -2.025     0.200
     2.132    -1.513     0.200
     2.853    -4.232     0.200
     2.894    -4.082     0.200
     3.213    -4.448     0.200
     0.073     0.569     0.200
     0.784    -1.210     0.200
     1.317    -0.710     0.200
     1.646    -1.189     0.200
     2.157    -3.233     0.200
     0.144     0.182     0.200
     0.160     0.474     0.200
     0.289     1.194     0.200
     0.791    -1.026     0.200
     0.873    -0.540     0.200
     1.129    -0.502     0.200
     1.227    -0.787     0.200
     1.232     0.048     0.200
     1.384    -0.847     0.200
     1.387    -1.818     0.200
     1.652    -0.822     0.200
     1.652    -2.048     0.200
     1.611    -1.333     0.200
     1.819    -2.937     0.200
     2.137    -1.305     0.200
     2.782    -2.617     0.200
     0.162     0.173     0.200
     0.876    -0.996     0.200
     1.135    -0.731     0.200
     1.228     0.734     0.200
     1.252     1.260     0.200
     1.398    -0.170     0.200
     2.306    -1.987     0.200
     2.967    -2.999     0.200
     3.031    -4.689     0.200
     3.028    -4.353     0.200
     3.096    -4.971     0.200
     3.254    -3.838     0.200
     3.299    -5.127     0.200
     0.230     1.202     0.200
     0.190     1.431     0.200
     0.928    -0.096     0.200
     1.149     0.690     0.200
     1.149     2.219     0.200
     1.349    -1.480     0.200
     1.780    -2.273     0.200
     1.976    -0.873     0.200
     2.936    -4.607     0.200
     2.970    -3.627     0.200
     3.018    -4.847     0.200
     3.344    -3.847     0.200
     3.820    -4.640     0.200
     3.888    -2.296     0.200
     4.140    -6.377     0.200
     4.415    -3.184     0.200
     0.218     0.190     0.200
     1.163    -0.029     0.200
     1.164     4.339     0.200
     1.169    -0.542     0.200
     1.238    -0.811     0.200
     1.261    -1.345     0.200
     1.678    -2.647     0.200
     1.715    -0.522     0.200
     1.715    -1.022     0.200
     2.123    -2.835     0.200
     2.839    -4.490     0.200
     2.890    -4.181     0.200
     2.940    -4.418     0.200
     3.073    -2.178     0.200
     3.122    -4.222     0.200
     3.269    -4.311     0.200
     3.745    -6.108     0.200
     0.202    -0.268     0.200
     0.312     0.849     0.200
     1.087    -0.047     0.200
     1.163    -1.029     0.200
     1.230     0.168     0.200
     1.230     0.610     0.200
     1.527    -2.637     0.200
     1.578    -2.616     0.200
     0.312    -0.252     0.200
     0.361     0.259     0.200
     0.654    -1.024     0.200
     0.936     0.714     0.200
     0.968    -0.678     0.200
     1.378    -1.817     0.200
     1.378    -2.415     0.200
     1.379     0.027     0.200
     1.802    -2.371     0.200
     2.518    -4.733     0.200
     2.587    -3.275     0.200
     2.626    -3.790     0.200
     2.948    -4.937     0.200
     0.185    -0.390     0.200
     0.488     1.337     0.200
     0.964     1.269     0.200
     0.964     0.459     0.200
     1.512    -1.815     0.200
     1.573    -1.354     0.200
     1.888    -1.441     0.200
     1.993    -1.759     0.200
     3.148    -3.369     0.200
     3.205    -3.854     0.200
     3.267    -4.196     0.200
     3.460    -2.454     0.200
     0.888    -0.354     0.200
     1.057    -0.693     0.200
     1.156    -1.100     0.200
     1.264     2.527     0.200
     1.264     1.517     0.200
     1.585    -1.470     0.200
     1.998    -1.897     0.200
     2.240    -2.710     0.200
     2.337    -2.325     0.200
     2.712    -4.126     0.200
     2.780    -4.916     0.200
     2.822    -4.422     0.200
     3.145    -4.341     0.200
     3.368    -4.294     0.200
     3.621    -6.008     0.200
     4.219    -5.844     0.200
     0.226    -1.313     0.200
     0.720    -0.100     0.200
     1.028    -0.960     0.200
     1.045    -0.030     0.200
     1.045     0.400     0.200
     1.118    -1.173     0.200
     1.246     0.330     0.200
     1.534    -2.506     0.200
     1.975    -2.661     0.200
     2.247    -0.924     0.200
     2.692    -4.604     0.200
     2.718    -2.911     0.200
     2.745    -3.607     0.200
     2.791    -4.529     0.200
     2.924    -3.216     0.200
     2.973    -4.472     0.200
     3.120    -4.134     0.200
     3.596    -6.312     0.200
     3.596    -4.685     0.200
     4.206    -3.639     0.200
     4.205    -6.378     0.200
     0.148     0.594     0.200
     0.272    -0.268     0.200
     1.105     0.835     0.200
     1.105     2.693     0.200
     1.224     0.057     0.200
     1.224    -0.193     0.200
     1.717    -2.527     0.200
     1.797    -1.462     0.200
     2.204    -2.567     0.200
     2.348    -3.040     0.200
     2.962    -4.790     0.200
     3.016    -5.046     0.200
     3.153    -3.554     0.200
     3.201    -5.048     0.200
     3.825    -7.136     0.200
     0.927    -0.963     0.200
     1.155     0.300     0.200
     1.227    -1.543     0.200
     1.756    -3.275     0.200
     2.068    -2.321     0.200
     2.171    -2.223     0.200
     2.254    -3.007     0.200
     2.300    -3.558     0.200
     2.558    -3.752     0.200
     2.885    -3.373     0.200
     2.885    -4.303     0.200
     2.942    -4.090     0.200
     2.990    -4.603     0.200
     3.120    -3.715     0.200
     3.170    -4.102     0.200
     3.317    -4.414     0.200
     3.541    -4.217     0.200
     3.770    -5.004     0.200
     6.096    -4.623     0.200
     0.366    -0.505     0.200
     0.646    -0.625     0.200
     0.784    -0.530     0.200
     0.816    -1.163     0.200
     0.909    -1.330     0.200
     1.188    -1.453     0.200
     1.182    -1.417     0.200
     1.583    -1.691     0.200
     1.549    -2.040     0.200
     1.549     0.850     0.200
     1.550    -0.322     0.200
     2.298    -3.502     0.200
     2.567    -2.720     0.200
     3.205    -4.082     0.200
     3.815    -4.429     0.200
     5.613    -8.015     0.200
     0.473    -0.661     0.200
     0.601    -1.129     0.200
     0.778    -0.511     0.200
     0.876    -1.368     0.200
     0.893    -0.066     0.200
     0.893     0.094     0.200
     1.131    -1.341     0.200
     1.305    -1.899     0.200
     1.450    -0.838     0.200
     1.451     0.024     0.200
     2.448    -0.423     0.200
     2.432    -3.993     0.200
     2.545    -4.239     0.200
     2.666    -3.424     0.200
     2.716    -4.078     0.200
     2.864    -4.535     0.200
     2.977    -4.842     0.200
     2.967    -2.966     0.200
     3.091    -5.201     0.200
     3.339    -6.154     0.200
     3.339    -3.531     0.200
     3.945    -4.473     0.200
     0.602    -0.554     0.200
     0.752    -0.419     0.200
     0.781    -0.229     0.200
     0.913    -1.364     0.200
     1.145    -1.325     0.200
     1.304    -0.754     0.200
     1.594    -0.368     0.200
     1.595    -0.200     0.200
     2.249    -3.923     0.200
     2.344    -3.620     0.200
     2.484    -3.389     0.200
     2.535    -4.913     0.200
     3.157    -2.363     0.200
     3.766    -4.950     0.200
     6.581    -9.653     0.200
     0.930    -0.994     0.200
     1.181    -0.941     0.200
     1.173    -0.570     0.200
     1.164     0.479     0.200
     1.266    -1.015     0.200
     1.683    -1.714     0.200
     2.114    -1.694     0.200
     2.127    -2.445     0.200
     2.895    -4.202     0.200
     2.944    -4.425     0.200
     3.077    -3.144     0.200
     3.126    -3.262     0.200
     3.814    -3.018     0.200
     4.293    -3.415     0.200
     4.638    -3.764     0.200
     0.969    -0.432     0.200
     1.388    -0.527     0.200
     1.798    -2.533     0.200
     2.513    -4.206     0.200
     2.586    -3.595     0.200
     2.624    -4.396     0.200
     2.747    -2.978     0.200
     2.797    -3.224     0.200
     2.945    -3.985     0.200
     3.041    -2.490     0.200
     3.172    -5.678     0.200
     3.420    -5.678     0.200
     3.420    -3.322     0.200
     4.026    -2.382     0.200
     4.044    -3.298     0.200
     1.033     1.192     0.200
     1.367    -0.159     0.200
     1.367    -1.098     0.200
     1.419    -1.739     0.200
     1.490    -0.966     0.200
     1.909    -2.508     0.200
     1.956    -3.421     0.200
     2.368    -2.584     0.200
     3.084    -4.090     0.200
     3.073    -4.251     0.200
     3.121    -4.289     0.200
     3.178    -4.424     0.200
     3.257    -5.790     0.200
     3.365    -5.238     0.200
     5.425    -8.884     0.200
     6.204    -7.560     0.200
     0.320    -0.484     0.200
     0.600    -0.521     0.200
     0.751    -0.413     0.200
     1.136    -1.400     0.200
     1.144    -1.585     0.200
     1.307    -0.321     0.200
     1.597    -2.456     0.200
     2.247    -4.036     0.200
     2.368    -3.902     0.200
     0.321     0.278     0.200
     0.871    -1.426     0.200
     1.114    -0.001     0.200
     1.083    -0.869     0.200
     1.252     1.015     0.200
     1.596    -2.123     0.200
     1.610    -0.837     0.200
     1.606    -2.926     0.200
     1.863    -1.906     0.200
     2.025    -1.620     0.200
     2.241    -3.489     0.200
     2.738    -3.434     0.200
     2.807    -4.347     0.200
     2.849    -4.100     0.200
     2.781    -7.146     0.200
     3.172    -4.201     0.200
     3.647    -6.647     0.200
     0.567    -0.073     0.200
     0.733    -0.658     0.200
     0.809    -0.049     0.200
     1.089    -0.606     0.200
     1.118    -1.478     0.200
     1.644    -2.286     0.200
     2.204    -3.291     0.200
     2.312    -3.299     0.200
     2.333    -3.367     0.200
     2.441    -3.147     0.200
     0.313    -0.564     0.200
     0.449     1.786     0.200
     0.606    -0.358     0.200
     0.761    -0.541     0.200
     0.898    -0.856     0.200
     1.153    -1.273     0.200
     1.536    -0.616     0.200
     1.603    -1.764     0.200
     2.249    -2.463     0.200
     0.194    -0.329     0.200
     0.237     0.945     0.200
     0.624     0.693     0.200
     0.732    -0.978     0.200
     0.945    -0.980     0.200
     1.082     0.372     0.200
     1.145    -0.059     0.200
     1.145    -0.311     0.200
     1.145     2.568     0.200
     1.188    -0.710     0.200
     1.188    -0.421     0.200
     1.204    -1.083     0.200
     1.244    -0.217     0.200
     1.285    -1.565     0.200
     1.312    -0.043     0.200
     1.703    -1.976     0.200
     1.742    -2.271     0.200
     2.150    -2.106     0.200
     2.867    -4.196     0.200
     2.915    -4.507     0.200
     2.965    -4.355     0.200
     3.296    -4.396     0.200
     3.772    -6.749     0.200
     0.156    -0.581     0.200
     0.683    -0.856     0.200
     0.656     1.256     0.200
     1.115    -0.419     0.200
     1.100     0.837     0.200
     1.115     1.381     0.200
     1.115     2.471     0.200
     1.115     3.861     0.200
     1.242    -0.326     0.200
     1.274     0.196     0.200
     1.347    -0.577     0.200
     1.764    -2.793     0.200
     2.213    -1.891     0.200
     2.929    -3.399     0.200
     2.976    -3.594     0.200
     3.028    -4.412     0.200
     3.163    -3.805     0.200
     3.359    -4.202     0.200
     0.134     0.800     0.200
     0.984     0.173     0.200
     1.056    -0.212     0.200
     1.056    -0.046     0.200
     1.056     3.983     0.200
     1.132     0.036     0.200
     1.330    -1.018     0.200
     1.343    -1.785     0.200
     1.343    -0.945     0.200
     1.343     0.825     0.200
     1.387    -0.782     0.200
     1.461    -1.940     0.200
     1.880    -2.293     0.200
     1.921    -1.928     0.200
     2.334    -2.392     0.200
     3.050    -4.314     0.200
     3.092    -4.187     0.200
     3.147    -4.644     0.200
     3.332    -4.452     0.200
     3.480    -4.830     0.200
     3.674    -2.998     0.200
     3.706    -5.038     0.200
     3.956    -6.792     0.200
     6.218    -5.746     0.200
     0.127     0.570     0.200
     0.315    -0.628     0.200
     0.629     0.762     0.200
     0.758    -1.000     0.200
     0.855    -1.103     0.200
     0.870    -1.153     0.200
     1.093    -0.865     0.200
     1.113     0.305     0.200
     1.123    -0.253     0.200
     1.192    -1.084     0.200
     1.245    -0.146     0.200
     1.606    -1.710     0.200
     1.866    -2.223     0.200
     2.034    -1.927     0.200
     2.747    -3.847     0.200
     2.793    -3.739     0.200
     2.816    -4.140     0.200
     2.859    -3.951     0.200
     3.181    -4.132     0.200
     3.402    -4.042     0.200
     3.656    -5.805     0.200
     3.656    -3.961     0.200
     4.204    -4.254     0.200
     5.490    -4.242     0.200
     7.063    -5.245     0.200
     0.273     0.365     0.200
     0.353    -0.094     0.200
     0.636    -0.377     0.200
     0.681     0.732     0.200
     0.778    -0.466     0.200
     0.817    -0.709     0.200
     0.906    -1.200     0.200
     1.162    -0.061     0.200
     1.175    -1.340     0.200
     1.562    -1.107     0.200
     1.563     2.451     0.200
     2.286    -3.899     0.200
     2.521    -2.985     0.200
     2.571    -4.120     0.200
     6.618    -8.727     0.200
     0.249     0.670     0.200
     0.299    -0.594     0.200
     0.588    -0.250     0.200
     0.727     0.361     0.200
     0.802    -0.183     0.200
     0.905    -1.130     0.200
     1.201    -0.087     0.200
     1.201     0.372     0.200
     1.201     0.650     0.200
     1.326    -1.243     0.200
     1.618     0.186     0.200
     1.870    -2.089     0.200
     2.230    -3.263     0.200
     2.332    -3.949     0.200
     0.220    -0.256     0.200
     0.216     0.975     0.200
     0.604     1.071     0.200
     0.759    -0.751     0.200
     0.765    -0.204     0.200
     0.850    -1.066     0.200
     1.070    -0.191     0.200
     1.160     1.297     0.200
     1.160     3.981     0.200
     1.154    -1.304     0.200
     1.154    -0.234     0.200
     1.166    -0.756     0.200
     1.224    -0.072     0.200
     1.249    -1.623     0.200
     1.289    -0.118     0.200
     1.666    -2.565     0.200
     1.708    -3.129     0.200
     2.133    -2.682     0.200
     2.133    -1.783     0.200
     2.114    -1.730     0.200
     2.830    -3.934     0.200
     2.843    -3.119     0.200
     2.878    -3.840     0.200
     2.928    -3.930     0.200
     0.155     1.427     0.200
     1.004     0.268     0.200
     1.073    -1.357     0.200
     1.063     1.444     0.200
     1.063     0.862     0.200
     1.063     0.410     0.200
     1.153     0.416     0.200
     1.367    -0.201     0.200
     1.406    -1.262     0.200
     1.901    -2.029     0.200
     2.352    -1.703     0.200
     3.070    -4.122     0.200
     3.114    -4.066     0.200
     3.167    -4.509     0.200
     0.293     0.667     0.200
     0.344    -0.565     0.200
     0.649    -0.456     0.200
     0.798    -0.559     0.200
     0.882    -1.190     0.200
     0.882    -1.440     0.200
     1.181     0.645     0.200
     1.192    -1.527     0.200
     1.197     0.254     0.200
     1.205     0.187     0.200
     1.268    -1.384     0.200
     1.571     0.185     0.200
     2.292    -3.604     0.200
     2.529    -3.087     0.200
     2.728    -4.216     0.200
     2.924    -5.531     0.200
     2.951    -4.647     0.200
     3.805    -2.732     0.200
     1.001     2.941     0.200
     1.411    -0.944     0.200
     1.475     0.117     0.200
     1.542     0.050     0.200
     3.421    -2.879     0.200
     0.181     1.064     0.200
     0.261    -0.380     0.200
     0.261    -0.266     0.200
     0.486    -0.099     0.200
     0.656    -0.323     0.200
     0.896    -1.277     0.200
     1.026    -0.534     0.200
     1.038    -0.946     0.200
     1.416    -1.309     0.200
     1.414    -1.139     0.200
     1.685    -1.094     0.200
     2.132    -3.116     0.200
     2.171    -2.993     0.200
     2.253    -2.297     0.200
     2.564    -3.596     0.200
     2.794    -3.614     0.200
     0.116     0.663     0.200
     0.530    -0.035     0.200
     1.001     0.571     0.200
     1.018    -0.773     0.200
     1.001     1.457     0.200
     1.001     2.678     0.200
     1.001     3.117     0.200
     1.109    -1.468     0.200
     1.316     0.299     0.200
     1.357    -0.639     0.200
     1.424    -1.121     0.200
     1.908    -1.781     0.200
     1.969    -1.876     0.200
     2.374    -2.505     0.200
     3.067    -4.189     0.200
     3.093    -4.138     0.200
     3.120    -4.337     0.200
     3.179    -4.687     0.200
     0.165     2.368     0.200
     0.193     0.561     0.200
     0.210     0.966     0.200
     0.218    -0.007     0.200
     0.294     1.493     0.200
     0.363     1.740     0.200
     0.454     1.302     0.200
     0.610     1.129     0.200
     1.077     0.521     0.200
     1.166    -0.374     0.200
     1.158    -0.023     0.200
     1.166     0.666     0.200
     1.166     3.463     0.200
     1.230     0.337     0.200
     1.295    -0.150     0.200
     1.620    -1.645     0.200
     2.033    -2.480     0.200
     0.210     0.060     0.200
     0.209     0.378     0.200
     0.223     1.948     0.200
     1.170    -1.847     0.200
     1.170     2.669     0.200
     1.175    -0.498     0.200
     1.175     0.242     0.200
     1.265    -1.254     0.200
     1.714    -2.232     0.200
     2.113    -2.747     0.200
     2.125    -1.909     0.200
     2.280    -3.428     0.200
     2.466    -2.609     0.200
     2.575    -3.340     0.200
     4.449    -5.838     0.200
     0.286    -0.433     0.200
     0.274     0.331     0.200
     0.455     0.836     0.200
     0.538     0.221     0.200
     0.604    -0.462     0.200
     0.769    -0.633     0.200
     1.156    -1.397     0.200
     1.228    -0.283     0.200
     1.226     0.021     0.200
     1.223    -0.414     0.200
     1.329    -0.369     0.200
     1.526    -1.775     0.200
     1.629    -3.169     0.200
     1.629    -3.030     0.200
     2.474    -4.038     0.200
     2.527    -4.200     0.200
     3.148    -4.069     0.200
     3.746    -4.027     0.200
     3.913    -3.314     0.200
     4.220    -3.380     0.200
     6.560    -5.744     0.200
     0.270     0.477     0.200
     0.352    -0.188     0.200
     0.422     1.311     0.200
     0.633    -0.576     0.200
     0.746    -0.305     0.200
     0.776    -0.742     0.200
     1.172    -1.703     0.200
     1.162     0.068     0.200
     1.175     0.016     0.200
     1.181    -0.144     0.200
     1.270    -1.237     0.200
     2.284    -3.776     0.200
     2.402    -3.664     0.200
     2.518    -3.515     0.200
     2.716    -4.381     0.200
     0.205     0.740     0.200
     0.205    -1.330     0.200
     0.207    -1.006     0.200
     0.227    -1.226     0.200
     0.765    -0.975     0.200
     0.850    -1.019     0.200
     1.175    -1.139     0.200
     1.172    -0.478     0.200
     1.172     0.132     0.200
     1.174     1.616     0.200
     2.120    -1.919     0.200
     2.115    -1.368     0.200
     2.294    -3.235     0.200
     2.835    -3.613     0.200
     2.858    -3.989     0.200
     2.890    -4.543     0.200
     2.938    -4.226     0.200
     3.106    -5.738     0.200
     3.119    -4.574     0.200
     3.266    -4.840     0.200
     3.742    -6.563     0.200
     4.283    -4.922     0.200
     4.343    -2.690     0.200
     6.353    -5.386     0.200
     0.134     1.382     0.200
     0.134     1.942     0.200
     0.188     0.531     0.200
     0.332     0.756     0.200
     0.604     0.861     0.200
     0.663     0.194     0.200
     0.734    -0.564     0.200
     0.872     0.115     0.200
     1.059    -0.945     0.200
     1.086    -0.607     0.200
     1.086     0.413     0.200
     1.091     0.032     0.200
     1.155    -0.883     0.200
     1.217    -0.228     0.200
     1.252    -1.313     0.200
     1.252    -0.303     0.200
     1.270    -0.400     0.200
     1.570    -1.871     0.200
     1.592    -1.029     0.200
     2.002    -2.115     0.200
     2.252    -3.645     0.200
     2.717    -4.018     0.200
     2.756    -3.717     0.200
     2.780    -4.227     0.200
     2.824    -4.605     0.200
     0.213     0.671     0.200
     0.240    -0.622     0.200
     0.854    -0.491     0.200
     0.955    -1.170     0.200
     1.148    -0.645     0.200
     1.148     2.929     0.200
     1.148     0.138     0.200
     1.144    -0.789     0.200
     1.144    -0.240     0.200
     1.163    -1.378     0.200
     1.694    -1.935     0.200
     1.660    -1.794     0.200
     1.710    -1.558     0.200
     1.710    -1.296     0.200
     2.112    -1.930     0.200
     2.328    -3.243     0.200
     2.612    -3.712     0.200
     2.830    -3.752     0.200
     2.834    -4.236     0.200
     2.872    -3.965     0.200
     2.924    -3.954     0.200
     3.062    -2.717     0.200
     3.109    -4.882     0.200
     3.257    -4.785     0.200
     3.490    -5.094     0.200
     3.846    -3.839     0.200
     0.157     0.262     0.200
     0.304     0.870     0.200
     0.762    -0.570     0.200
     1.081    -1.415     0.200
     1.095     0.295     0.200
     1.076     0.311     0.200
     1.172    -1.044     0.200
     1.209    -0.207     0.200
     1.225    -0.539     0.200
     1.225     0.372     0.200
     1.225     1.974     0.200
     1.265    -0.281     0.200
     1.587    -1.689     0.200
     1.619    -1.424     0.200
     1.890    -2.079     0.200
     2.026    -1.930     0.200
     2.196    -2.657     0.200
     2.273    -3.068     0.200
     2.568    -2.921     0.200
     2.742    -3.557     0.200
     2.798    -3.954     0.200
     3.025    -3.831     0.200
     3.172    -4.530     0.200
     3.400    -4.418     0.200
     3.885    -5.056     0.200
     4.252    -4.083     0.200
     0.220    -0.842     0.200
     0.226     0.309     0.200
     0.206     0.553     0.200
     0.635     0.737     0.200
     0.876    -0.379     0.200
     1.095     0.602     0.200
     1.158    -1.074     0.200
     1.158     0.809     0.200
     1.158     1.530     0.200
     1.158     2.905     0.200
     1.158    -1.228     0.200
     1.201    -1.304     0.200
     1.193    -1.296     0.200
     1.193    -0.757     0.200
     1.255     0.410     0.200
     1.286    -1.415     0.200
     1.322    -0.354     0.200
     1.703    -1.503     0.200
     1.735    -1.327     0.200
     1.735    -1.694     0.200
     2.147    -1.384     0.200
     2.862    -3.685     0.200
     3.145    -4.309     0.200
     0.271     0.456     0.200
     0.298    -0.234     0.200
     0.533     0.742     0.200
     0.607    -0.280     0.200
     0.734     0.258     0.200
     0.769    -0.331     0.200
     0.832     0.101     0.200
     0.832    -0.009     0.200
     1.157    -1.500     0.200
     1.211    -0.170     0.200
     1.216    -0.504     0.200
     1.218    -0.624     0.200
     1.319    -1.070     0.200
     1.533    -1.791     0.200
     1.617    -2.154     0.200
     1.617    -0.283     0.200
     1.618     0.236     0.200
     1.879    -2.362     0.200
     2.243    -3.515     0.200
     2.352    -3.755     0.200
     2.448    -2.614     0.200
     2.533    -4.940     0.200
     2.681    -4.395     0.200
     2.901    -4.270     0.200
     3.155    -5.424     0.200
     0.125     1.126     0.200
     0.160     0.610     0.200
     0.315     0.597     0.200
     0.633     0.857     0.200
     0.701    -0.148     0.200
     0.759    -0.943     0.200
     0.867    -0.970     0.200
     1.116     0.618     0.200
     1.096    -0.791     0.200
     1.127    -0.136     0.200
     1.195    -1.073     0.200
     1.250    -1.226     0.200
     1.251     2.983     0.200
     1.251    -0.267     0.200
     1.249    -0.065     0.200
     1.609    -1.767     0.200
     1.619    -1.235     0.200
     2.036    -2.048     0.200
     2.166    -2.160     0.200
     2.238    -3.756     0.200
     2.748    -3.393     0.200
     2.796    -5.560     0.200
     2.819    -4.592     0.200
     2.862    -4.840     0.200
     3.036    -3.535     0.200
     3.183    -4.015     0.200
     3.851    -6.103     0.200
     3.851    -4.045     0.200
     0.272     0.861     0.200
     0.450     0.782     0.200
     0.607    -0.370     0.200
     0.736     0.221     0.200
     0.769    -0.360     0.200
     0.793    -0.103     0.200
     0.834    -0.348     0.200
     1.157    -1.187     0.200
     1.214     0.282     0.200
     1.218     0.043     0.200
     1.220     0.270     0.200
     1.320    -1.130     0.200
     1.361    -1.795     0.200
     1.532    -1.339     0.200
     1.619     0.117     0.200
     1.619    -1.695     0.200
     1.877    -2.258     0.200
     2.242    -3.177     0.200
     2.480    -3.213     0.200
     2.532    -4.814     0.200
     3.154    -4.371     0.200
     0.144     1.637     0.200
     0.288     0.136     0.200
     0.846    -0.137     0.200
     1.100    -0.591     0.200
     1.215     0.434     0.200
     1.215     0.114     0.200
     1.215    -1.355     0.200
     1.324    -1.916     0.200
     1.699    -1.988     0.200
     1.743    -2.425     0.200
     1.794    -2.496     0.200
     2.075    -2.332     0.200
     2.111    -1.833     0.200
     2.119    -2.183     0.200
     2.158    -2.302     0.200
     2.765    -2.824     0.200
     2.955    -4.274     0.200
     3.181    -3.269     0.200
     3.820    -7.440     0.200
     0.145     0.608     0.200
     0.415    -0.010     0.200
     0.573    -0.096     0.200
     1.008     0.073     0.200
     1.049     0.778     0.200
     1.049    -0.964     0.200
     1.049     3.174     0.200
     1.049    -0.974     0.200
     1.143     0.782     0.200
     1.345    -0.175     0.200
     1.365    -1.441     0.200
     1.365     0.231     0.200
     1.411    -1.565     0.200
     1.428    -0.627     0.200
     1.904    -2.135     0.200
     2.386    -3.159     0.200
     3.171    -4.017     0.200
     0.153     0.253     0.200
     0.399     0.653     0.200
     0.590    -0.158     0.200
     0.998    -0.119     0.200
     1.065     1.376     0.200
     1.065     0.696     0.200
     1.065     0.744     0.200
     1.065     2.701     0.200
     1.041    -0.261     0.200
     1.151     0.334     0.200
     1.349    -0.013     0.200
     1.361    -0.262     0.200
     1.361     0.027     0.200
     1.400    -0.924     0.200
     1.432    -0.434     0.200
     1.934    -4.319     0.200
     0.158    -0.425     0.200
     0.406     0.710     0.200
     0.406     1.799     0.200
     0.586    -0.067     0.200
     1.007    -0.008     0.200
     1.064     0.728     0.200
     1.065     0.867     0.200
     1.065     4.027     0.200
     1.156     0.331     0.200
     1.356     0.375     0.200
     1.370     0.168     0.200
     1.370     0.859     0.200
     1.409    -1.396     0.200
     1.439    -0.099     0.200
     2.355    -1.864     0.200
     3.069    -3.457     0.200
     3.117    -2.964     0.200
     3.170    -4.317     0.200
     3.501    -4.776     0.200
     3.724    -5.792     0.200
     3.977    -6.774     0.200
     0.142     0.770     0.200
     0.305     1.356     0.200
     0.884    -0.459     0.200
     1.100     1.347     0.200
     1.100     0.233     0.200
     1.100     0.425     0.200
     1.099    -0.014     0.200
     1.100     0.896     0.200
     1.256     0.457     0.200
     1.256    -0.664     0.200
     1.256    -1.082     0.200
     1.278    -0.098     0.200
     1.353    -0.347     0.200
     1.823    -0.908     0.200
     0.152     0.571     0.200
     0.188     0.040     0.200
     0.607     1.653     0.200
     0.700     0.074     0.200
     0.739     0.080     0.200
     0.895    -0.753     0.200
     1.089     0.672     0.200
     1.097    -0.933     0.200
     1.113    -0.102     0.200
     1.190    -0.619     0.200
     1.224     0.079     0.200
     1.225    -1.215     0.200
     1.225     0.035     0.200
     1.225     0.787     0.200
     1.282     0.063     0.200
     1.605    -1.694     0.200
     2.041    -2.334     0.200
     2.266    -2.868     0.200
     2.299    -3.149     0.200
     2.789    -3.976     0.200
     2.816    -4.052     0.200
     2.862    -3.855     0.200
     0.146     2.438     0.200
     0.302     1.943     0.200
     0.338     0.292     0.200
     0.702     0.951     0.200
     0.933     0.610     0.200
     1.094     0.542     0.200
     1.094     1.055     0.200
     1.094     2.985     0.200
     1.130     0.116     0.200
     1.305    -0.269     0.200
     1.305    -0.569     0.200
     1.317    -0.532     0.200
     1.394    -0.258     0.200
     3.230    -2.391     0.200
     3.279    -3.685     0.200
     3.700    -3.879     0.200
     4.500    -5.180     0.200
     6.193    -5.256     0.200
     6.238    -6.675     0.200
     0.210     0.723     0.200
     0.210     0.888     0.200
     0.534    -0.325     0.200
     0.522     0.238     0.200
     0.699    -0.277     0.200
     0.780    -0.439     0.200
     0.851    -0.723     0.200
     1.191    -0.425     0.200
     1.197    -0.049     0.200
     1.211    -0.078     0.200
     1.373    -1.786     0.200
     1.373     0.544     0.200
     1.464    -2.163     0.200
     1.653    -1.969     0.200
     1.654     0.207     0.200
     2.178    -3.299     0.200
     2.301    -3.625     0.200
     2.413    -3.319     0.200
     2.464    -3.963     0.200
     2.611    -3.799     0.200
     2.839    -4.446     0.200
     3.086    -4.828     0.200
     3.487    -5.219     0.200
     3.695    -4.545     0.200
     3.876    -4.512     0.200
     5.635    -7.565     0.200
     6.511    -8.172     0.200
     0.279     1.047     0.200
     0.369     0.681     0.200
     0.401     0.844     0.200
     0.432    -0.118     0.200
     0.784    -0.834     0.200
     0.898    -0.041     0.200
     0.898     0.178     0.200
     1.120    -0.054     0.200
     1.173     0.368     0.200
     1.197    -0.050     0.200
     1.320    -1.484     0.200
     1.320    -1.370     0.200
     1.311    -1.850     0.200
     1.447    -1.499     0.200
     1.447    -2.538     0.200
     1.448     0.453     0.200
     1.448     2.344     0.200
     1.723    -1.702     0.200
     2.074    -1.684     0.200
     2.437    -3.879     0.200
     2.552    -3.939     0.200
     2.640    -2.152     0.200
     2.722    -3.055     0.200
     2.870    -4.121     0.200
     3.097    -4.092     0.200
     0.247     0.468     0.200
     0.256     0.368     0.200
     0.299    -0.471     0.200
     0.469     1.846     0.200
     0.554     0.431     0.200
     0.587    -0.505     0.200
     0.727     0.451     0.200
     1.115    -1.002     0.200
     1.200    -0.231     0.200
     1.200    -0.075     0.200
     1.201    -0.282     0.200
     1.516    -2.020     0.200
     1.619    -1.913     0.200
     2.228    -3.213     0.200
     2.354    -2.754     0.200
     2.664    -3.782     0.200
     2.888    -4.504     0.200
     0.252     0.450     0.200
     0.299    -0.361     0.200
     0.557     0.054     0.200
     0.583    -0.475     0.200
     1.114    -1.341     0.200
     1.130    -1.586     0.200
     1.197    -0.201     0.200
     1.197     0.305     0.200
     1.199    -0.072     0.200
     1.199     1.089     0.200
     1.619    -1.848     0.200
     1.620    -0.150     0.200
     1.620     0.440     0.200
     1.620     1.881     0.200
     2.226    -3.469     0.200
     2.351    -3.772     0.200
     2.661    -3.920     0.200
     2.886    -4.422     0.200
     3.102    -4.752     0.200
     3.135    -4.936     0.200
     0.122     0.378     0.200
     0.122     0.776     0.200
     0.155     0.439     0.200
     0.638     0.902     0.200
     0.704     0.302     0.200
     1.131    -0.108     0.200
     1.131     0.001     0.200
     1.199    -0.756     0.200
     1.254    -1.017     0.200
     1.254     2.638     0.200
     1.254     3.427     0.200
     1.619    -1.677     0.200
     1.619    -0.318     0.200
     2.162    -4.543     0.200
     0.220     0.037     0.200
     0.217     0.695     0.200
     0.280    -0.386     0.200
     0.546    -0.317     0.200
     0.709    -0.223     0.200
     0.929    -0.598     0.200
     1.037    -0.695     0.200
     1.080    -1.204     0.200
     1.362     0.078     0.200
     1.645    -0.594     0.200
     1.645     0.546     0.200
     1.646     3.200     0.200
     1.646    -1.069     0.200
     2.623    -2.797     0.200
     0.161     0.782     0.200
     0.234    -0.403     0.200
     0.568     1.239     0.200
     0.600    -0.439     0.200
     0.600    -0.299     0.200
     0.910    -1.151     0.200
     0.903    -1.767     0.200
     1.025    -0.163     0.200
     1.025     0.857     0.200
     1.268     0.578     0.200
     1.269     0.026     0.200
     1.269     1.216     0.200
     2.270    -0.696     0.200
     2.894    -2.353     0.200
     2.942    -4.253     0.200
     3.953    -3.831     0.200
     4.174    -3.295     0.200
     4.185    -4.437     0.200
     0.182     0.171     0.200
     0.782    -0.267     0.200
     0.805    -0.510     0.200
     0.805    -0.408     0.200
     1.140    -0.979     0.200
     1.152    -0.735     0.200
     1.152    -0.227     0.200
     1.208    -0.290     0.200
     1.208    -0.942     0.200
     1.232    -1.306     0.200
     1.247    -0.086     0.200
     1.308    -0.008     0.200
     1.669    -1.592     0.200
     2.830    -3.856     0.200
     2.859    -3.827     0.200
     2.904    -4.215     0.200
     2.975    -4.729     0.200
     3.705    -5.774     0.200
     0.440     0.833     0.200
     0.553     0.767     0.200
     1.037     1.668     0.200
     1.037     1.147     0.200
     1.037     3.338     0.200
     1.035     0.052     0.200
     1.152     0.354     0.200
     1.358    -0.320     0.200
     1.388    -0.492     0.200
     1.444    -0.900     0.200
     1.511    -1.213     0.200
     3.335    -3.173     0.200
     0.140     0.969     0.200
     0.192     0.813     0.200
     0.564     1.217     0.200
     0.666    -0.106     0.200
     0.764    -0.140     0.200
     1.413    -1.302     0.200
     1.687    -0.111     0.200
     1.688    -0.284     0.200
     2.421    -5.336     0.200
     0.138     1.196     0.200
     0.196     0.971     0.200
     0.273    -0.518     0.200
     0.517    -0.238     0.200
     0.682    -0.413     0.200
     0.682    -0.173     0.200
     1.385    -0.492     0.200
     1.385     0.368     0.200
     1.448    -1.590     0.200
     2.163    -3.704     0.200
     2.284    -3.577     0.200
     2.595    -3.277     0.200
     2.825    -4.464     0.200
     3.035    -4.897     0.200
     3.070    -3.883     0.200
     3.681    -5.452     0.200
     0.253     0.480     0.200
     0.247     0.740     0.200
     0.477     1.796     0.200
     0.561     1.098     0.200
     0.579    -0.418     0.200
     0.742    -0.548     0.200
     0.903    -0.916     0.200
     1.209     0.164     0.200
     1.211     0.215     0.200
     1.506    -1.133     0.200
     1.631    -2.779     0.200
     1.632    -2.538     0.200
     1.857    -1.490     0.200
     2.218    -3.084     0.200
     2.324    -3.278     0.200
     2.346    -2.980     0.200
     2.654    -3.882     0.200
     2.768    -2.616     0.200
     2.877    -4.271     0.200
     3.128    -4.827     0.200
     3.222    -3.667     0.200
     3.731    -3.896     0.200
     0.234     0.819     0.200
     0.478     0.084     0.200
     0.563     0.959     0.200
     0.577    -0.407     0.200
     0.919    -1.124     0.200
     1.190     0.281     0.200
     1.192     0.197     0.200
     1.330    -1.614     0.200
     1.616    -1.931     0.200
     1.618     2.802     0.200
     0.133     0.859     0.200
     0.228     0.524     0.200
     0.569    -0.374     0.200
     0.572     0.214     0.200
     0.725    -0.525     0.200
     0.723     0.413     0.200
     1.187    -0.146     0.200
     1.189     0.043     0.200
     1.194     0.279     0.200
     1.337     0.926     0.200
     1.500    -1.367     0.200
     1.622    -1.916     0.200
     1.623    -2.919     0.200
     1.623     0.281     0.200
     1.859    -1.211     0.200
     2.215    -3.538     0.200
     2.312    -3.443     0.200
     2.450    -2.374     0.200
     2.496    -2.431     0.200
     2.500    -3.912     0.200
     2.775    -2.844     0.200
     2.876    -4.535     0.200
     3.123    -2.509     0.200
     3.910    -2.728     0.200
     5.538    -7.584     0.200
     5.625    -6.183     0.200
     0.134     0.860     0.200
     0.198     0.461     0.200
     0.200     0.797     0.200
     0.685    -0.476     0.200
     1.189    -0.044     0.200
     1.197    -0.116     0.200
     1.215     0.278     0.200
     1.386    -1.142     0.200
     1.664    -1.048     0.200
     1.665     0.307     0.200
     2.397    -2.982     0.200
     2.448    -4.343     0.200
     0.230    -0.252     0.200
     0.233    -0.005     0.200
     0.622     1.436     0.200
     0.622     1.196     0.200
     0.737    -0.387     0.200
     0.797    -0.290     0.200
     1.082     0.731     0.200
     1.149     1.023     0.200
     1.149     4.062     0.200
     1.184    -0.551     0.200
     1.198    -0.638     0.200
     1.243     0.413     0.200
     1.280    -1.195     0.200
     1.310    -0.480     0.200
     1.698    -2.401     0.200
     1.736    -1.372     0.200
     2.145    -1.787     0.200
     2.315    -2.216     0.200
     2.488    -1.864     0.200
     2.861    -3.758     0.200
     3.094    -3.473     0.200
     3.143    -4.542     0.200
     0.230    -0.185     0.200
     0.233     0.096     0.200
     0.736    -0.276     0.200
     1.083     0.558     0.200
     1.148     1.438     0.200
     1.186    -0.023     0.200
     1.200    -1.273     0.200
     1.244     0.209     0.200
     1.283    -1.230     0.200
     1.312    -0.169     0.200
     1.700    -1.700     0.200
     1.738    -1.465     0.200
     2.147    -2.394     0.200
     2.876    -4.672     0.200
     2.912    -3.763     0.200
     0.144     1.038     0.200
     0.228     0.736     0.200
     0.228     0.507     0.200
     0.218     0.679     0.200
     0.565    -0.296     0.200
     0.717    -0.614     0.200
     0.717    -0.424     0.200
     0.780    -0.131     0.200
     0.948    -0.642     0.200
     1.109    -0.732     0.200
     1.108    -1.482     0.200
     1.175    -0.431     0.200
     1.177    -0.659     0.200
     1.183    -0.018     0.200
     1.499    -2.025     0.200
     1.615    -2.183     0.200
     1.617    -1.497     0.200
     1.617     2.243     0.200
     2.215    -3.419     0.200
     2.307    -3.460     0.200
     2.333    -3.575     0.200
     2.646    -4.282     0.200
     2.694    -3.912     0.200
     2.877    -4.756     0.200
     3.084    -5.451     0.200
     4.066    -3.628     0.200
     0.151     1.119     0.200
     0.194     0.405     0.200
     0.299    -0.393     0.200
     0.519     1.252     0.200
     0.690    -0.544     0.200
     0.761    -1.121     0.200
     1.167     0.114     0.200
     1.172     0.154     0.200
     1.186     0.429     0.200
     1.472    -1.793     0.200
     1.633     0.288     0.200
     1.840    -1.649     0.200
     2.189    -3.485     0.200
     2.278    -3.563     0.200
     0.126     1.262     0.200
     0.139     1.379     0.200
     0.195     1.443     0.200
     0.286    -0.374     0.200
     0.605    -0.831     0.200
     0.612    -0.063     0.200
     1.150    -0.547     0.200
     1.165    -0.337     0.200
     1.201    -0.319     0.200
     1.389    -2.121     0.200
     1.613    -1.984     0.200
     1.687    -0.901     0.200
     1.771    -1.920     0.200
     2.107    -1.497     0.200
     2.109    -3.823     0.200
     2.218    -3.709     0.200
     2.338    -3.452     0.200
     2.387    -3.814     0.200
     2.752    -2.081     0.200
     3.011    -2.104     0.200
     3.634    -4.523     0.200
     3.832    -3.166     0.200
     4.378    -6.376     0.200
     6.452    -7.794     0.200
     0.171     0.742     0.200
     0.278     0.523     0.200
     0.298     0.388     0.200
     0.359    -0.631     0.200
     0.414     1.324     0.200
     0.500     0.994     0.200
     0.678     0.569     0.200
     0.783    -0.689     0.200
     0.819    -0.014     0.200
     1.181    -1.472     0.200
     1.159     0.360     0.200
     1.174    -0.082     0.200
     1.181    -0.175     0.200
     1.556    -2.668     0.200
     1.557    -2.719     0.200
     1.557     0.402     0.200
     2.176    -2.998     0.200
     2.293    -3.587     0.200
     2.411    -3.332     0.200
     2.507    -3.850     0.200
     2.578    -4.527     0.200
     2.725    -3.489     0.200
     2.954    -3.924     0.200
     3.603    -4.595     0.200
     0.162     0.998     0.200
     0.267     0.745     0.200
     0.286     0.363     0.200
     0.347    -0.507     0.200
     0.686     0.877     0.200
     0.772    -0.402     0.200
     0.814     0.312     0.200
     0.907    -1.398     0.200
     1.166    -0.142     0.200
     1.177    -0.365     0.200
     1.570    -0.519     0.200
     1.564    -2.219     0.200
     2.174    -3.365     0.200
     2.278    -4.161     0.200
     3.795    -4.442     0.200
     0.276     0.729     0.200
     0.297     0.410     0.200
     0.415     1.975     0.200
     0.782    -0.798     0.200
     1.182    -1.091     0.200
     1.158     0.251     0.200
     1.179    -1.533     0.200
     1.172     0.141     0.200
     1.179     0.050     0.200
     1.261    -0.957     0.200
     1.261    -0.308     0.200
     1.577    -1.936     0.200
     1.557     0.248     0.200
     1.557     2.443     0.200
     2.527    -3.662     0.200
     2.577    -5.559     0.200
     0.138     1.247     0.200
     0.218     0.741     0.200
     0.226     0.586     0.200
     0.299    -0.296     0.200
     0.496     0.205     0.200
     0.559    -0.339     0.200
     0.715    -0.537     0.200
     0.722    -0.242     0.200
     0.933    -0.671     0.200
     0.946    -0.873     0.200
     1.105    -1.590     0.200
     1.342    -0.137     0.200
     1.492    -1.641     0.200
     1.624     0.125     0.200
     1.625    -0.258     0.200
     2.207    -3.388     0.200
     2.302    -3.393     0.200
     2.327    -4.020     0.200
     0.196     0.887     0.200
     0.563    -0.206     0.200
     0.611     0.800     0.200
     0.779    -0.807     0.200
     0.832    -0.998     0.200
     0.923    -0.949     0.200
     1.081     0.169     0.200
     1.150     0.142     0.200
     1.153    -0.695     0.200
     1.179    -0.011     0.200
     1.180     2.177     0.200
     1.180     1.802     0.200
     1.231    -0.038     0.200
     1.239    -1.338     0.200
     1.294    -0.319     0.200
     1.655    -2.173     0.200
     1.690    -2.625     0.200
     2.099    -1.740     0.200
     2.296    -3.197     0.200
     0.308     0.765     0.200
     0.881     0.011     0.200
     0.924    -0.441     0.200
     1.094     0.443     0.200
     1.090     0.225     0.200
     1.284    -1.217     0.200
     1.270    -0.040     0.200
     1.345    -0.488     0.200
     1.360    -1.865     0.200
     2.231    -2.339     0.200
     2.354    -3.801     0.200
     2.948    -3.743     0.200
     2.990    -4.820     0.200
     3.044    -5.364     0.200
     3.229    -3.991     0.200
     3.377    -4.574     0.200
     3.606    -4.347     0.200
     3.753    -2.947     0.200
     0.168     1.202     0.200
     0.164     0.781     0.200
     0.164     0.930     0.200
     0.279    -0.389     0.200
     0.483    -0.221     0.200
     0.645    -0.540     0.200
     0.737    -0.490     0.200
     0.737     0.319     0.200
     1.165    -0.086     0.200
     1.176     0.091     0.200
     1.204    -0.058     0.200
     1.418    -1.110     0.200
     1.673    -0.330     0.200
     2.135    -3.085     0.200
     2.251    -2.943     0.200
     2.565    -3.331     0.200
     2.800    -3.381     0.200
     3.002    -4.708     0.200
     0.392     0.938     0.200
     0.594     0.465     0.200
     0.988     0.396     0.200
     1.030    -0.359     0.200
     1.065     2.194     0.200
     1.065     1.220     0.200
     1.390    -0.295     0.200
     1.466    -1.085     0.200
     1.885    -2.306     0.200
     1.945    -3.110     0.200
     2.336    -1.924     0.200
     3.097    -4.171     0.200
     3.150    -3.912     0.200
     3.482    -4.442     0.200
     0.144     0.675     0.200
     0.693    -0.120     0.200
     0.729    -0.168     0.200
     0.847    -1.066     0.200
     0.847    -1.191     0.200
     0.876    -0.563     0.200
     1.128    -0.687     0.200
     1.128    -0.379     0.200
     1.190    -1.272     0.200
     1.273    -1.697     0.200
     1.602    -2.175     0.200
     2.023    -2.103     0.200
     2.168    -4.913     0.200
     2.217    -2.967     0.200
     2.734    -3.302     0.200
     0.019     3.477     0.200
     0.087     1.874     0.200
     0.734    -0.993     0.200
     0.734    -1.165     0.200
     0.924    -0.433     0.200
     1.236    -1.175     0.200
     1.236    -0.144     0.200
     1.272    -0.832     0.200
     1.357     0.185     0.200
     1.358    -1.030     0.200
     1.474    -1.885     0.200
     1.678    -1.351     0.200
     1.764    -1.194     0.200
     2.107    -3.215     0.200
     0.200    -0.234     0.200
     0.743     0.312     0.200
     1.070     1.140     0.200
     1.175     0.953     0.200
     1.138    -1.101     0.200
     1.138     0.069     0.200
     1.176     0.257     0.200
     1.176     1.597     0.200
     1.144     0.014     0.200
     1.218     1.050     0.200
     1.281     0.401     0.200
     1.645    -1.848     0.200
     1.685    -0.315     0.200
     2.091    -1.775     0.200
     2.150    -2.846     0.200
     2.304    -3.618     0.200
     2.808    -3.788     0.200
     2.857    -3.779     0.200
     2.906    -4.134     0.200
     3.237    -4.033     0.200
     3.467    -3.746     0.200
     3.713    -6.093     0.200
     0.174     1.433     0.200
     0.286    -0.542     0.200
     0.482    -0.439     0.200
     0.641    -0.333     0.200
     0.730    -0.384     0.200
     1.028    -1.349     0.200
     1.042    -1.396     0.200
     1.042    -1.139     0.200
     1.418    -1.719     0.200
     1.667    -2.706     0.200
     1.668    -2.291     0.200
     1.794    -1.862     0.200
     2.137    -2.453     0.200
     2.250    -3.229     0.200
     2.565    -3.659     0.200
     2.755    -1.954     0.200
     2.802    -3.122     0.200
     3.001    -3.769     0.200
     3.040    -3.086     0.200
     3.160    -3.717     0.200
     3.231    -4.565     0.200
     3.446    -4.881     0.200
     3.630    -4.441     0.200
     3.660    -5.195     0.200
     3.872    -5.842     0.200
     4.294    -6.882     0.200
     0.193     0.922     0.200
     0.288    -0.562     0.200
     0.455    -0.139     0.200
     0.615    -0.018     0.200
     0.601     1.214     0.200
     0.752     0.204     0.200
     0.844    -0.436     0.200
     1.053    -0.823     0.200
     1.149     0.021     0.200
     1.164     0.087     0.200
     1.199    -0.110     0.200
     1.393    -1.186     0.200
     1.683     0.307     0.200
     2.113    -2.032     0.200
     2.223    -2.160     0.200
     2.539    -3.118     0.200
     2.779    -3.824     0.200
     2.974    -4.349     0.200
     3.141    -3.819     0.200
     3.422    -4.672     0.200
     4.374    -6.677     0.200
     0.126     0.815     0.200
     0.283    -0.364     0.200
     0.448    -0.124     0.200
     0.611    -0.176     0.200
     0.693    -0.044     0.200
     0.712     0.026     0.200
     0.712     0.665     0.200
     0.840    -0.858     0.200
     1.048    -0.807     0.200
     1.205     0.024     0.200
     1.385    -1.890     0.200
     1.433    -1.544     0.200
     2.105    -3.423     0.200
     2.216    -3.738     0.200
     2.350    -2.592     0.200
     2.531    -3.458     0.200
     2.771    -4.501     0.200
     3.007    -5.982     0.200
     3.413    -4.701     0.200
     0.174     0.904     0.200
     0.161     0.470     0.200
     0.162     0.351     0.200
     0.162     0.838     0.200
     0.297    -0.508     0.200
     0.558     0.591     0.200
     0.497    -0.401     0.200
     0.651    -0.269     0.200
     0.730     0.093     0.200
     0.732    -0.120     0.200
     0.732     0.271     0.200
     1.152     0.181     0.200
     1.161     0.147     0.200
     1.185     0.619     0.200
     1.386    -1.438     0.200
     1.435    -1.527     0.200
     1.652    -0.340     0.200
     2.129    -0.985     0.200
     2.154    -3.436     0.200
     2.265    -3.442     0.200
     2.582    -3.487     0.200
     2.820    -4.130     0.200
     3.017    -3.805     0.200
     3.463    -5.061     0.200
     0.143     1.016     0.200
     0.194     1.251     0.200
     0.279    -0.245     0.200
     0.445    -0.213     0.200
     0.610    -0.365     0.200
     0.714     0.550     0.200
     1.382    -1.357     0.200
     1.437     0.180     0.200
     1.694     0.642     0.200
     1.695    -0.375     0.200
     1.695     2.528     0.200
     2.101    -2.992     0.200
     2.213    -2.341     0.200
     2.767    -3.891     0.200
     3.410    -4.876     0.200
     0.152     1.037     0.200
     0.247     0.653     0.200
     0.263     0.384     0.200
     0.331    -0.257     0.200
     0.451     1.457     0.200
     0.604    -0.441     0.200
     0.751    -0.443     0.200
     0.751    -0.613     0.200
     1.145    -1.604     0.200
     1.172     0.117     0.200
     1.176    -0.287     0.200
     1.179    -0.105     0.200
     1.539    -1.932     0.200
     1.587     0.070     0.200
     2.254    -3.962     0.200
     2.372    -4.419     0.200
     2.488    -3.302     0.200
     2.538    -3.067     0.200
     2.915    -4.641     0.200
     3.771    -5.487     0.200
     3.771    -4.012     0.200
     6.586    -3.964     0.200
     0.175     1.667     0.200
     0.175     0.140     0.200
     0.203     0.199     0.200
     0.599     1.162     0.200
     0.717     0.116     0.200
     0.797    -0.373     0.200
     1.120     0.079     0.200
     1.120    -0.081     0.200
     1.116    -0.806     0.200
     1.200     0.719     0.200
     1.200     1.020     0.200
     1.204    -1.063     0.200
     1.201     0.296     0.200
     1.201     0.862     0.200
     1.217    -0.103     0.200
     1.277    -0.186     0.200
     1.655    -1.986     0.200
     2.062    -1.905     0.200
     2.778    -3.855     0.200
     2.832    -3.414     0.200
     3.012    -3.638     0.200
     3.060    -5.017     0.200
     3.208    -3.931     0.200
     3.436    -4.351     0.200
     3.684    -5.890     0.200
     0.153     0.442     0.200
     0.691    -0.210     0.200
     0.731    -0.075     0.200
     0.767    -0.292     0.200
     1.089    -1.015     0.200
     1.084     0.741     0.200
     1.182    -1.158     0.200
     1.218    -0.035     0.200
     1.226     0.727     0.200
     1.275    -0.061     0.200
     1.597    -2.191     0.200
     2.034    -1.846     0.200
     2.185    -4.156     0.200
     2.808    -4.164     0.200
     2.983    -3.945     0.200
     3.032    -4.723     0.200
     3.180    -4.275     0.200
     3.407    -4.236     0.200
     3.656    -4.905     0.200
     7.070    -4.977     0.200
     0.394     1.409     0.200
     0.596     0.967     0.200
     0.994     0.649     0.200
     1.037     0.295     0.200
     1.070     1.260     0.200
     1.070     1.176     0.200
     1.152     0.980     0.200
     1.350     0.597     0.200
     1.359     1.056     0.200
     1.396    -0.621     0.200
     1.432     0.200     0.200
     1.474    -0.571     0.200
     1.892    -2.461     0.200
     2.342    -1.473     0.200
     3.056    -3.054     0.200
     3.157    -4.884     0.200
     0.295    -0.248     0.200
     0.323     0.280     0.200
     0.905    -0.921     0.200
     0.982    -0.960     0.200
     1.107    -0.137     0.200
     1.091     0.069     0.200
     1.091     0.901     0.200
     1.091     0.171     0.200
     1.091     0.901     0.200
     1.091     2.823     0.200
     1.275    -0.768     0.200
     1.275    -1.331     0.200
     1.290    -0.780     0.200
     1.385    -1.372     0.200
     2.040    -2.401     0.200
     2.016    -3.849     0.200
     2.352    -2.294     0.200
     2.974    -5.072     0.200
     3.068    -5.265     0.200
     3.253    -4.062     0.200
     3.400    -5.584     0.200
     3.628    -5.659     0.200
     4.478    -4.703     0.200
     6.470    -6.706     0.200
     7.288    -5.296     0.200
     0.230     1.823     0.200
     0.237     1.091     0.200
     1.147    -0.372     0.200
     1.147    -0.614     0.200
     1.147    -0.225     0.200
     1.147     0.455     0.200
     1.147     2.665     0.200
     1.195    -0.777     0.200
     1.209    -1.093     0.200
     1.292    -1.014     0.200
     1.746    -1.344     0.200
     2.092    -2.295     0.200
     2.155    -2.123     0.200
     2.871    -4.644     0.200
     2.886    -4.655     0.200
     2.971    -5.117     0.200
     0.169     0.628     0.200
     0.196     0.481     0.200
     0.813     0.492     0.200
     1.118    -1.370     0.200
     1.126    -1.025     0.200
     1.126    -0.244     0.200
     1.208    -1.218     0.200
     1.624    -2.280     0.200
     2.063    -2.038     0.200
     2.163    -3.523     0.200
     2.778    -3.819     0.200
     2.882    -5.539     0.200
     3.013    -3.710     0.200
     3.062    -3.755     0.200
     3.209    -4.535     0.200
     3.685    -5.943     0.200
     4.247    -3.354     0.200
     4.288    -2.677     0.200
     6.394    -6.417     0.200
     0.350    -1.005     0.200
     0.387    -0.822     0.200
     0.591     1.336     0.200
     0.973    -0.119     0.200
     1.055     2.896     0.200
     1.016     0.523     0.200
     1.017    -0.632     0.200
     1.332    -0.749     0.200
     1.376    -0.102     0.200
     1.869    -1.487     0.200
     2.324    -1.692     0.200
     3.040    -2.967     0.200
     3.136    -4.338     0.200
     3.469    -4.009     0.200
     3.946    -6.880     0.200
     0.219    -0.016     0.200
     0.216     0.939     0.200
     0.216    -0.352     0.200
     0.616     0.817     0.200
     0.776    -0.733     0.200
     1.162    -0.338     0.200
     1.163     4.597     0.200
     1.163    -0.973     0.200
     1.168    -0.399     0.200
     1.168     1.031     0.200
     1.236    -0.576     0.200
     1.261    -0.745     0.200
     1.261    -1.154     0.200
     1.425    -1.522     0.200
     1.678    -2.300     0.200
     1.715    -2.217     0.200
     1.715    -1.758     0.200
     1.752    -1.052     0.200
     2.120    -1.968     0.200
     2.123    -1.980     0.200
     2.467    -2.738     0.200
     2.839    -4.420     0.200
     2.939    -4.406     0.200
     3.073    -3.922     0.200
     3.122    -4.806     0.200
     3.269    -4.865     0.200
     3.497    -3.656     0.200
     3.745    -6.324     0.200
     3.745    -6.596     0.200
     7.160    -8.987     0.200
     0.185     0.354     0.200
     0.185     0.503     0.200
     0.214     0.882     0.200
     0.214     0.593     0.200
     0.265     0.093     0.200
     0.361     0.091     0.200
     0.597    -0.298     0.200
     0.807    -0.917     0.200
     0.914    -0.674     0.200
     0.929     0.653     0.200
     1.248    -1.635     0.200
     1.477    -1.838     0.200
     1.519    -1.244     0.200
     1.598    -1.959     0.200
     1.598    -1.689     0.200
     1.598    -0.540     0.200
     1.955    -3.307     0.200
     2.105    -3.066     0.200
     2.114    -2.831     0.200
     2.222    -2.752     0.200
     2.249    -4.463     0.200
     2.397    -3.721     0.200
     2.614    -4.287     0.200
     2.852    -4.126     0.200
     2.869    -4.480     0.200
     3.248    -4.088     0.200
     3.265    -4.486     0.200
     0.275    -0.275     0.200
     0.295     0.240     0.200
     0.417     1.294     0.200
     0.639    -0.536     0.200
     0.781    -0.517     0.200
     0.795    -0.493     0.200
     1.014    -0.862     0.200
     1.177    -1.403     0.200
     1.178    -1.659     0.200
     1.265    -1.272     0.200
     1.574    -1.737     0.200
     1.560    -0.465     0.200
     1.931    -2.268     0.200
     2.175    -3.905     0.200
     2.289    -3.432     0.200
     2.379    -3.172     0.200
     2.407    -3.506     0.200
     2.523    -3.327     0.200
     2.574    -3.884     0.200
     2.721    -4.108     0.200
     2.950    -4.734     0.200
     3.159    -5.023     0.200
     3.196    -4.730     0.200
     3.296    -4.428     0.200
     3.805    -5.342     0.200
     0.229    -0.035     0.200
     0.228    -0.143     0.200
     0.792    -0.847     0.200
     1.151     0.537     0.200
     1.180    -0.208     0.200
     1.152     3.395     0.200
     1.193    -1.509     0.200
     1.276    -0.788     0.200
     1.469    -1.470     0.200
     1.693    -1.914     0.200
     1.681    -1.217     0.200
     2.140    -1.688     0.200
     2.314    -3.111     0.200
     2.483    -2.000     0.200
     2.856    -4.425     0.200
     3.089    -4.285     0.200
     3.138    -4.786     0.200
     7.177    -5.183     0.200
     0.218     0.311     0.200
     0.495     0.551     0.200
     0.561    -0.529     0.200
     1.341    -0.781     0.200
     1.494    -2.469     0.200
     1.855    -2.011     0.200
     1.869    -2.591     0.200
     2.209    -3.814     0.200
     2.209    -2.325     0.200
     2.287    -2.692     0.200
     2.304    -3.948     0.200
     2.329    -3.906     0.200
     2.474    -3.594     0.200
     2.493    -4.285     0.200
     2.493    -4.064     0.200
     2.641    -4.093     0.200
     2.871    -4.666     0.200
     3.727    -6.188     0.200
     0.198     0.811     0.200
     0.198    -0.160     0.200
     0.739    -0.478     0.200
     0.780    -0.044     0.200
     0.780     0.194     0.200
     0.824    -0.701     0.200
     0.931    -0.865     0.200
     1.139    -0.702     0.200
     1.133     0.328     0.200
     1.177     1.239     0.200
     1.177     0.720     0.200
     1.178     1.194     0.200
     1.178     3.924     0.200
     1.178     0.453     0.200
     1.224    -0.529     0.200
     1.216     0.523     0.200
     1.278    -0.145     0.200
     1.640    -1.486     0.200
     1.681    -2.028     0.200
     1.681    -1.549     0.200
     2.086    -1.554     0.200
     2.154    -1.433     0.200
     2.433    -2.129     0.200
     2.803    -3.745     0.200
     2.852    -3.785     0.200
     2.902    -3.530     0.200
     3.036    -3.143     0.200
     3.084    -4.078     0.200
     3.852    -4.724     0.200
     0.152     0.829     0.200
     0.355    -0.660     0.200
     0.507    -0.463     0.200
     0.655    -0.039     0.200
     0.646    -0.366     0.200
     1.099    -1.258     0.200
     1.127     0.036     0.200
     1.456    -1.935     0.200
     1.604     0.237     0.200
     1.850    -2.093     0.200
     2.180    -3.580     0.200
     2.850    -4.066     0.200
     0.218    -0.149     0.200
     0.225    -0.158     0.200
     0.771    -0.723     0.200
     1.160    -0.154     0.200
     1.159    -0.835     0.200
     1.172    -1.537     0.200
     1.255    -1.267     0.200
     1.672    -2.318     0.200
     2.119    -2.485     0.200
     2.127    -3.211     0.200
     2.312    -3.417     0.200
     2.465    -1.959     0.200
     2.836    -3.913     0.200
     2.884    -4.276     0.200
     0.378    -0.425     0.200
     0.418     0.933     0.200
     0.532     0.378     0.200
     1.005     0.181     0.200
     1.048     0.502     0.200
     1.039     1.702     0.200
     1.039     0.940     0.200
     1.131     0.254     0.200
     1.408    -0.048     0.200
     1.480    -0.089     0.200
     1.899    -1.047     0.200
     2.356    -1.418     0.200
     2.396    -2.954     0.200
     3.111    -3.656     0.200
     3.354    -3.449     0.200
     3.978    -3.452     0.200
     0.268    -0.312     0.200
     0.282     0.630     0.200
     0.282     0.755     0.200
     0.888    -0.300     0.200
     1.078    -0.463     0.200
     1.108     0.490     0.200
     1.108     2.838     0.200
     1.108     0.260     0.200
     1.249    -1.739     0.200
     1.248    -1.888     0.200
     1.790    -1.680     0.200
     1.790    -1.532     0.200
     2.071    -2.186     0.200
     2.913    -3.991     0.200
     3.008    -4.206     0.200
     0.032     3.799     0.200
     0.105     1.596     0.200
     0.105     1.236     0.200
     0.740    -1.052     0.200
     0.909    -0.937     0.200
     1.249    -1.537     0.200
     1.249    -0.617     0.200
     1.257    -1.141     0.200
     1.346    -1.092     0.200
     1.346    -1.602     0.200
     1.481    -2.150     0.200
     1.630    -0.579     0.200
     1.777    -2.255     0.200
     2.060    -3.139     0.200
     2.060    -3.903     0.200
     2.081    -2.210     0.200
     2.114    -3.615     0.200
     2.435    -2.592     0.200
     2.900    -4.179     0.200
     3.730    -3.467     0.200
     0.076     1.541     0.200
     0.763    -1.406     0.200
     0.781    -0.269     0.200
     0.907    -0.262     0.200
     1.211    -0.329     0.200
     1.211    -0.516     0.200
     1.220    -1.147     0.200
     1.227     0.048     0.200
     1.333    -0.146     0.200
     1.333    -0.427     0.200
     1.333     2.073     0.200
     1.334    -0.269     0.200
     1.334     2.099     0.200
     1.358    -0.526     0.200
     1.411    -0.677     0.200
     1.611    -0.833     0.200
     1.661    -1.331     0.200
     2.867    -4.648     0.200
     2.898    -3.015     0.200
     0.140     1.230     0.200
     0.301     0.224     0.200
     0.316     0.513     0.200
     0.406     1.708     0.200
     0.490    -1.015     0.200
     0.650    -0.437     0.200
     0.868    -1.491     0.200
     0.868    -1.075     0.200
     1.196    -1.584     0.200
     1.197    -0.254     0.200
     1.278    -1.059     0.200
     1.511    -1.216     0.200
     1.584    -2.009     0.200
     2.287    -3.899     0.200
     2.417    -3.366     0.200
     2.525    -3.385     0.200
     2.725    -4.185     0.200
     2.945    -4.180     0.200
     3.199    -2.813     0.200
     0.300    -0.171     0.200
     0.320     0.316     0.200
     0.320     1.226     0.200
     0.883    -0.559     0.200
     0.931    -0.394     0.200
     0.972    -0.154     0.200
     1.078     0.738     0.200
     1.079     0.197     0.200
     1.079     0.247     0.200
     1.079     2.867     0.200
     1.287    -1.308     0.200
     1.778    -1.923     0.200
     2.047    -3.757     0.200
     2.047    -2.290     0.200
     2.236    -2.403     0.200
     2.990    -4.689     0.200
     4.668    -3.784     0.200
     0.279    -0.567     0.200
     0.297    -0.048     0.200
     0.866     0.252     0.200
     0.914    -0.255     0.200
     1.085     0.246     0.200
     1.099     0.423     0.200
     1.099     0.743     0.200
     1.099     0.842     0.200
     1.099     2.459     0.200
     1.237    -1.106     0.200
     1.237    -0.442     0.200
     1.269    -1.889     0.200
     1.269    -1.116     0.200
     2.053    -2.352     0.200
     2.934    -3.699     0.200
     2.976    -3.600     0.200
     3.167    -3.801     0.200
     3.215    -3.857     0.200
     3.362    -4.741     0.200
     3.839    -6.341     0.200
     3.839    -5.567     0.200
     3.903    -2.563     0.200
     5.115    -3.437     0.200
     5.818    -7.351     0.200
     0.319    -1.171     0.200
     0.294     0.055     0.200
     0.319     0.461     0.200
     0.319     0.332     0.200
     0.419     1.096     0.200
     0.637    -0.216     0.200
     0.794    -1.133     0.200
     0.849     0.355     0.200
     0.849     0.222     0.200
     0.870    -1.000     0.200
     1.185    -1.260     0.200
     1.204    -0.510     0.200
     1.204     0.951     0.200
     1.292    -1.836     0.200
     1.563    -1.430     0.200
     1.596     0.683     0.200
     1.597    -0.606     0.200
     1.597     0.343     0.200
     2.273    -3.534     0.200
     2.404    -2.977     0.200
     2.511    -4.472     0.200
     2.564    -4.662     0.200
     2.711    -3.952     0.200
     2.931    -4.198     0.200
     3.185    -6.597     0.200
     0.346     1.034     0.200
     0.936    -0.162     0.200
     0.983     0.069     0.200
     0.983     0.222     0.200
     1.083    -0.158     0.200
     1.121     0.278     0.200
     1.304    -0.555     0.200
     1.304    -0.098     0.200
     1.338    -1.425     0.200
     1.337    -1.735     0.200
     1.415    -0.963     0.200
     1.833    -2.052     0.200
     1.871    -1.199     0.200
     3.046    -4.909     0.200
     3.099    -5.241     0.200
     3.234    -3.566     0.200
     3.430    -5.671     0.200
     3.906    -6.076     0.200
     0.387    -1.110     0.200
     0.387    -0.040     0.200
     0.437     0.857     0.200
     0.439     0.692     0.200
     0.485    -0.642     0.200
     0.606     0.612     0.200
     1.015    -0.805     0.200
     1.038    -1.051     0.200
     2.342    -4.293     0.200
     3.081    -5.697     0.200
     3.407    -4.696     0.200
     0.567    -0.410     0.200
     0.899    -0.249     0.200
     0.948    -0.775     0.200
     0.993    -0.561     0.200
     1.057     0.373     0.200
     1.057    -0.595     0.200
     1.058     1.223     0.200
     1.058    -0.855     0.200
     1.069     0.860     0.200
     1.253    -0.827     0.200
     1.373    -1.551     0.200
     1.844    -1.524     0.200
     2.167    -2.137     0.200
     2.215    -2.396     0.200
     2.254    -2.415     0.200
     2.973    -3.375     0.200
     2.957    -3.908     0.200
     3.004    -4.352     0.200
     3.061    -4.347     0.200
     3.398    -4.635     0.200
     4.282    -5.926     0.200
     0.231     0.880     0.200
     0.231     1.653     0.200
     0.231     0.098     0.200
     0.839     0.004     0.200
     1.148     1.014     0.200
     1.149    -0.524     0.200
     1.193    -1.438     0.200
     1.206    -0.983     0.200
     1.275    -0.802     0.200
     1.692    -1.681     0.200
     1.684    -3.197     0.200
     1.726    -2.519     0.200
     4.309    -5.692     0.200
     0.082     0.364     0.200
     0.081     1.091     0.200
     0.752     0.039     0.200
     0.794    -0.530     0.200
     0.794    -0.636     0.200
     1.122    -0.281     0.200
     1.189     0.912     0.200
     1.189     0.592     0.200
     1.200     0.139     0.200
     1.195     0.701     0.200
     1.307     1.204     0.200
     1.307     0.721     0.200
     1.649    -1.124     0.200
     1.810    -1.801     0.200
     2.052    -1.210     0.200
     2.166    -2.859     0.200
     2.757    -2.745     0.200
     2.844    -4.356     0.200
     2.856    -3.850     0.200
     2.890    -3.177     0.200
     3.201    -4.572     0.200
     3.642    -6.610     0.200
     3.674    -5.516     0.200
     0.311     0.980     0.200
     0.335    -0.367     0.200
     0.335     1.665     0.200
     0.954    -0.557     0.200
     1.073     1.337     0.200
     1.073     0.375     0.200
     1.073     2.328     0.200
     1.089    -0.167     0.200
     1.267    -0.662     0.200
     1.301    -1.697     0.200
     1.352    -0.863     0.200
     1.801    -2.022     0.200
     1.848    -1.697     0.200
     1.851    -1.681     0.200
     2.026    -2.219     0.200
     0.223    -0.239     0.200
     0.215    -0.445     0.200
     0.768     0.262     0.200
     0.768    -0.358     0.200
     0.815    -0.354     0.200
     1.073     0.432     0.200
     1.161     0.111     0.200
     1.161     0.791     0.200
     1.161    -0.384     0.200
     1.161    -0.254     0.200
     1.158    -0.126     0.200
     1.158     0.054     0.200
     1.169    -1.372     0.200
     1.184    -1.123     0.200
     1.252    -0.977     0.200
     1.669    -1.625     0.200
     2.116    -1.953     0.200
     2.311    -2.899     0.200
     2.462    -2.157     0.200
     2.833    -3.264     0.200
     2.846    -3.635     0.200
     2.881    -4.588     0.200
     2.931    -3.706     0.200
     3.066    -3.543     0.200
     3.122    -5.692     0.200
     3.114    -3.698     0.200
     3.261    -3.279     0.200
     3.491    -4.081     0.200
     3.684    -5.328     0.200
     4.650    -3.756     0.200
     6.138    -5.268     0.200
     7.506    -8.959     0.200
     0.327     0.081     0.200
     0.944    -0.256     0.200
     1.077     1.454     0.200
     1.085     0.713     0.200
     1.140     1.174     0.200
     1.258    -0.234     0.200
     1.299    -0.720     0.200
     1.372    -1.219     0.200
     1.372    -0.459     0.200
     1.598    -1.582     0.200
     1.721    -1.487     0.200
     1.748    -1.340     0.200
     1.791    -2.007     0.200
     1.951    -0.740     0.200
     2.556    -3.859     0.200
     3.184    -4.500     0.200
     3.197    -3.373     0.200
     3.245    -3.939     0.200
     4.475    -2.931     0.200
     0.776     0.406     0.200
     0.823    -0.219     0.200
     1.143     0.871     0.200
     1.143     0.387     0.200
     1.158     0.001     0.200
     1.158     0.188     0.200
     1.178    -1.108     0.200
     1.185    -1.062     0.200
     1.257    -0.755     0.200
     1.674    -1.453     0.200
     3.076    -4.341     0.200
     0.259     0.290     0.200
     0.259     2.339     0.200
     0.806    -1.503     0.200
     0.854    -0.298     0.200
     1.060     0.572     0.200
     1.121     0.587     0.200
     1.121     0.288     0.200
     1.121    -0.087     0.200
     1.209    -1.803     0.200
     1.211    -1.798     0.200
     1.285    -1.285     0.200
     1.710    -2.695     0.200
     1.703    -2.060     0.200
     1.755    -2.065     0.200
     2.158    -1.870     0.200
     2.507    -2.606     0.200
     2.876    -3.300     0.200
     2.915    -4.453     0.200
     2.969    -3.653     0.200
     3.303    -4.497     0.200
     3.536    -4.429     0.200
     3.779    -5.384     0.200
     0.489     0.549     0.200
     0.592     0.968     0.200
     0.647    -0.597     0.200
     0.735     0.652     0.200
     0.858    -0.414     0.200
     0.843    -0.013     0.200
     0.993    -0.711     0.200
     0.992    -0.907     0.200
     1.062     0.122     0.200
     1.063    -0.279     0.200
     1.640    -1.861     0.200
     2.388    -1.364     0.200
     2.687    -3.812     0.200
     2.698    -3.475     0.200
     3.072    -3.905     0.200
     3.368    -3.998     0.200
     3.450    -4.073     0.200
     0.911    -0.171     0.200
     1.072     0.051     0.200
     1.088     0.317     0.200
     1.089    -0.386     0.200
     1.267    -1.193     0.200
     1.340    -1.116     0.200
     1.571    -1.321     0.200
     1.759    -1.789     0.200
     1.759    -1.722     0.200
     1.809    -1.354     0.200
     1.811    -1.439     0.200
     2.216    -2.262     0.200
     2.934    -4.043     0.200
     2.971    -4.741     0.200
     3.360    -4.729     0.200
     0.644    -0.488     0.200
     0.739     0.103     0.200
     0.854    -0.144     0.200
     0.845    -0.306     0.200
     0.823     0.294     0.200
     0.823     0.925     0.200
     0.823    -0.786     0.200
     0.871    -1.414     0.200
     0.991    -0.540     0.200
     0.991    -0.752     0.200
     1.066     1.371     0.200
     1.066     0.041     0.200
     1.067     0.907     0.200
     1.067    -0.004     0.200
     1.634    -0.667     0.200
     1.636    -1.445     0.200
     1.636    -0.896     0.200
     1.946    -2.003     0.200
     2.385    -2.767     0.200
     2.685    -3.661     0.200
     2.696    -2.968     0.200
     2.888    -3.655     0.200
     2.924    -2.978     0.200
     3.070    -4.552     0.200
     3.365    -3.826     0.200
     3.448    -4.081     0.200
     0.214     0.615     0.200
     0.855    -0.970     0.200
     1.167    -0.336     0.200
     1.167    -0.547     0.200
     1.163     0.606     0.200
     1.164     1.111     0.200
     1.175    -0.868     0.200
     1.192    -1.013     0.200
     1.260    -1.320     0.200
     1.676    -1.847     0.200
     1.673    -2.678     0.200
     1.713    -2.078     0.200
     2.122    -1.802     0.200
     2.306    -3.332     0.200
     2.465    -2.209     0.200
     3.071    -3.691     0.200
     0.105     1.238     0.200
     0.299    -0.342     0.200
     0.318    -0.044     0.200
     0.318     0.265     0.200
     0.340     0.495     0.200
     0.647    -0.360     0.200
     0.814    -0.709     0.200
     0.869     0.055     0.200
     0.878    -0.049     0.200
     1.201    -1.518     0.200
     1.201    -1.811     0.200
     1.236    -0.653     0.200
     1.618    -2.009     0.200
     1.619    -2.261     0.200
     2.270    -3.760     0.200
     2.412    -3.525     0.200
     0.499     0.071     0.200
     0.586     0.157     0.200
     0.640    -0.435     0.200
     0.670     0.896     0.200
     0.852    -1.316     0.200
     0.859    -0.498     0.200
     0.985    -0.470     0.200
     1.029     1.066     0.200
     1.065     1.396     0.200
     1.066     0.588     0.200
     1.227    -0.957     0.200
     1.359    -1.231     0.200
     1.388    -1.273     0.200
     1.399    -1.809     0.200
     1.399    -1.699     0.200
     1.578    -0.795     0.200
     1.575    -0.807     0.200
     1.633    -0.249     0.200
     1.694    -0.811     0.200
     1.940    -2.383     0.200
     2.679    -4.257     0.200
     2.687    -3.389     0.200
     3.062    -4.567     0.200
     3.361    -4.294     0.200
     3.977    -5.580     0.200
     4.680    -6.672     0.200
     0.498     0.604     0.200
     0.648    -0.576     0.200
     0.676     0.863     0.200
     0.863    -0.691     0.200
     0.817     0.131     0.200
     0.844    -0.523     0.200
     0.867    -0.494     0.200
     0.844    -0.035     0.200
     0.993    -0.384     0.200
     0.990    -0.910     0.200
     1.035     0.932     0.200
     1.059     0.476     0.200
     1.060     0.527     0.200
     1.060     3.355     0.200
     1.060     5.566     0.200
     1.060    -0.512     0.200
     1.235    -1.039     0.200
     1.314    -0.865     0.200
     1.367    -1.274     0.200
     1.396    -1.527     0.200
     1.642    -0.879     0.200
     1.641    -0.215     0.200
     1.702    -0.258     0.200
     1.879    -1.723     0.200
     1.895    -2.502     0.200
     1.941    -1.679     0.200
     2.390    -2.169     0.200
     2.695    -3.141     0.200
     3.070    -4.454     0.200
     3.203    -4.323     0.200
     3.368    -3.432     0.200
     3.447    -4.399     0.200
     3.756    -3.809     0.200
     3.985    -5.731     0.200
     0.220    -0.559     0.200
     0.235    -0.228     0.200
     1.056     0.218     0.200
     1.140    -0.098     0.200
     1.140    -0.777     0.200
     1.157    -0.501     0.200
     1.167    -1.046     0.200
     1.154    -0.339     0.200
     1.154     1.911     0.200
     1.155     2.545     0.200
     1.236    -0.809     0.200
     1.654    -3.111     0.200
     1.703    -2.729     0.200
     2.105    -1.595     0.200
     3.133    -2.293     0.200
     3.849    -3.452     0.200
     6.804    -7.166     0.200
     7.148    -4.889     0.200
     0.218    -0.451     0.200
     0.223    -0.137     0.200
     0.755     0.229     0.200
     0.821    -0.168     0.200
     0.856    -0.511     0.200
     1.164    -0.170     0.200
     1.164     0.509     0.200
     1.159     2.082     0.200
     1.160     2.827     0.200
     1.160     1.878     0.200
     1.175    -0.326     0.200
     1.190    -0.251     0.200
     1.258    -0.870     0.200
     1.675    -2.094     0.200
     1.675    -1.679     0.200
     1.678    -2.402     0.200
     1.715    -1.376     0.200
     2.122    -1.541     0.200
     3.071    -2.035     0.200
     3.120    -4.383     0.200
     3.122    -3.095     0.200
     0.221    -0.460     0.200
     0.231    -0.175     0.200
     0.756     0.105     0.200
     0.764    -0.702     0.200
     0.852    -0.600     0.200
     1.064    -0.195     0.200
     1.151    -0.246     0.200
     1.151    -0.484     0.200
     1.155    -0.218     0.200
     1.155    -0.532     0.200
     1.166    -0.700     0.200
     1.177    -0.741     0.200
     1.247    -0.871     0.200
     1.664    -1.491     0.200
     1.710    -1.888     0.200
     2.114    -2.821     0.200
     2.831    -4.091     0.200
     0.216    -0.505     0.200
     0.210    -0.309     0.200
     0.762    -0.029     0.200
     0.850    -0.640     0.200
     1.167     1.485     0.200
     1.168     1.621     0.200
     1.164    -0.111     0.200
     1.164     0.209     0.200
     1.171    -0.827     0.200
     1.189    -0.577     0.200
     1.672    -1.694     0.200
     1.708    -1.988     0.200
     1.708    -1.265     0.200
     2.833    -3.387     0.200
     2.884    -4.102     0.200
     3.115    -3.280     0.200
     0.284     1.319     0.200
     0.284     2.100     0.200
     1.104     0.325     0.200
     1.104     0.055     0.200
     1.104    -0.550     0.200
     1.212    -0.108     0.200
     1.245    -1.010     0.200
     1.320    -1.017     0.200
     2.951    -4.350     0.200
     3.005    -3.935     0.200
     3.338    -5.463     0.200
     3.571    -5.494     0.200
     3.815    -6.811     0.200
     4.123    -4.096     0.200
     6.952    -6.272     0.200
     0.296     0.572     0.200
     0.899    -0.040     0.200
     0.943    -0.216     0.200
     1.092     0.787     0.200
     1.092     0.795     0.200
     1.217    -0.328     0.200
     1.255    -1.126     0.200
     1.328    -1.133     0.200
     1.781    -1.821     0.200
     1.731    -1.349     0.200
     1.801    -1.757     0.200
     2.204    -2.152     0.200
     2.361    -3.320     0.200
     2.916    -3.168     0.200
     2.922    -3.725     0.200
     2.959    -4.278     0.200
     3.013    -4.164     0.200
     3.348    -3.956     0.200
     3.582    -4.401     0.200
     4.434    -6.007     0.200
     0.129     1.652     0.200
     0.129     1.505     0.200
     0.263     0.031     0.200
     0.263    -0.111     0.200
     0.333    -0.390     0.200
     0.333    -0.277     0.200
     0.457     0.012     0.200
     0.565     0.080     0.200
     0.676    -0.607     0.200
     0.819    -1.235     0.200
     0.819    -1.251     0.200
     1.207    -1.644     0.200
     1.619    -2.313     0.200
     1.932    -3.248     0.200
     2.031    -2.162     0.200
     2.156    -2.906     0.200
     2.203    -3.338     0.200
     2.211    -2.709     0.200
     2.350    -4.026     0.200
     2.605    -3.973     0.200
     2.659    -2.795     0.200
     2.782    -4.391     0.200
     2.827    -3.313     0.200
     2.984    -4.400     0.200
     0.286    -0.710     0.200
     0.304     1.708     0.200
     0.869    -1.269     0.200
     0.917     0.023     0.200
     0.917    -0.626     0.200
     1.092     1.397     0.200
     1.092     0.857     0.200
     1.236     0.046     0.200
     1.236    -0.464     0.200
     1.269    -1.754     0.200
     1.272    -1.129     0.200
     1.765    -2.513     0.200
     1.796    -1.341     0.200
     2.221    -1.895     0.200
     2.357    -3.738     0.200
     2.935    -4.581     0.200
     2.977    -4.634     0.200
     3.031    -4.176     0.200
     3.365    -5.083     0.200
     3.597    -4.273     0.200
     3.766    -3.273     0.200
     3.842    -7.392     0.200
     3.842    -6.286     0.200
     0.034     1.916     0.200
     0.072     0.995     0.200
     0.706    -0.282     0.200
     0.762    -0.906     0.200
     0.936     0.972     0.200
     1.085    -0.775     0.200
     1.173    -1.290     0.200
     1.350    -0.648     0.200
     1.350    -0.593     0.200
     1.350     1.735     0.200
     1.618    -1.602     0.200
     2.133    -3.279     0.200
     2.138    -2.341     0.200
     0.232    -0.332     0.200
     0.220     0.827     0.200
     0.579    -0.224     0.200
     0.761    -1.272     0.200
     1.155     0.418     0.200
     1.155    -0.828     0.200
     1.155     2.632     0.200
     1.147    -1.199     0.200
     1.147    -0.619     0.200
     1.163    -1.641     0.200
     1.174    -1.065     0.200
     1.243    -0.976     0.200
     1.661    -2.019     0.200
     1.661    -1.915     0.200
     2.140    -2.755     0.200
     2.111    -1.960     0.200
     2.320    -3.995     0.200
     2.873    -4.782     0.200
     2.924    -5.457     0.200
     3.256    -4.725     0.200
     3.732    -7.053     0.200
     0.072     0.831     0.200
     0.053     1.130     0.200
     0.745    -1.104     0.200
     0.765    -0.395     0.200
     0.909     1.435     0.200
     1.124    -0.100     0.200
     1.205    -0.255     0.200
     1.214    -0.020     0.200
     1.248    -0.478     0.200
     1.308    -2.069     0.200
     1.333     0.992     0.200
     1.504    -1.842     0.200
     1.656    -1.224     0.200
     1.656    -2.540     0.200
     2.138    -3.024     0.200
     2.862    -3.082     0.200
     2.892    -2.854     0.200
     0.241     1.874     0.200
     0.250     0.566     0.200
     0.818    -1.176     0.200
     0.898    -0.262     0.200
     1.201    -0.512     0.200
     1.201    -1.621     0.200
     1.220    -0.815     0.200
     1.229    -1.593     0.200
     1.718    -1.985     0.200
     1.758    -1.879     0.200
     2.166    -2.239     0.200
     2.323    -4.347     0.200
     2.882    -4.105     0.200
     2.930    -4.462     0.200
     2.981    -4.218     0.200
     3.312    -3.814     0.200
     3.788    -6.241     0.200
     0.261     0.688     0.200
     0.261     1.398     0.200
     0.268     0.470     0.200
     0.295     0.180     0.200
     0.340     0.053     0.200
     0.340    -0.077     0.200
     0.467     0.746     0.200
     0.467     0.636     0.200
     0.521    -0.632     0.200
     0.521    -0.450     0.200
     0.585     0.564     0.200
     0.602     0.110     0.200
     0.682    -0.697     0.200
     0.682    -0.517     0.200
     0.668    -0.589     0.200
     0.668    -0.419     0.200
     0.701    -1.018     0.200
     0.701    -0.888     0.200
     0.834    -1.266     0.200
     0.865    -1.473     0.200
     0.867    -1.123     0.200
     0.905    -2.120     0.200
     1.074     0.336     0.200
     1.233    -1.097     0.200
     1.501    -1.332     0.200
     1.501    -1.102     0.200
     1.502    -0.339     0.200
     1.949    -1.896     0.200
     2.556    -2.924     0.200
     2.542    -4.584     0.200
     2.875    -4.039     0.200
     0.059     3.719     0.200
     0.073     0.804     0.200
     0.073     0.704     0.200
     0.150     2.159     0.200
     0.176     2.430     0.200
     0.303     1.621     0.200
     0.477     0.287     0.200
     0.653    -0.352     0.200
     0.730    -0.533     0.200
     0.730    -1.227     0.200
     0.723    -0.932     0.200
     0.779    -0.777     0.200
     0.882    -0.787     0.200
     1.093    -1.479     0.200
     1.105    -0.621     0.200
     1.190    -1.426     0.200
     1.225    -0.475     0.200
     2.841    -3.798     0.200
     3.797    -5.144     0.200
     0.042     1.651     0.200
     0.121     1.699     0.200
     0.318     2.470     0.200
     0.504    -0.078     0.200
     0.634    -0.202     0.200
     0.756    -0.551     0.200
     0.757    -0.961     0.200
     0.797     0.131     0.200
     0.910    -0.831     0.200
     1.135    -0.315     0.200
     1.185    -0.135     0.200
     1.219    -0.129     0.200
     1.260    -0.279     0.200
     1.338     1.468     0.200
     1.338     1.015     0.200
     1.339     1.190     0.200
     1.339     2.119     0.200
     1.339     2.362     0.200
     1.462    -1.339     0.200
     1.460    -0.616     0.200
     1.576    -1.852     0.200
     1.601    -2.068     0.200
     1.668    -1.595     0.200
     2.873    -3.885     0.200
     0.085     1.320     0.200
     0.117     2.024     0.200
     0.139     2.637     0.200
     0.752    -0.612     0.200
     0.762    -1.283     0.200
     0.802     0.415     0.200
     0.802     0.165     0.200
     0.815     0.747     0.200
     0.899     1.440     0.200
     0.910     0.700     0.200
     1.111     0.666     0.200
     1.140    -0.571     0.200
     1.191    -0.258     0.200
     1.234    -0.479     0.200
     1.266    -0.575     0.200
     1.341    -1.300     0.200
     1.341     1.404     0.200
     1.458    -0.608     0.200
     1.491    -0.954     0.200
     1.467    -1.038     0.200
     1.500    -0.938     0.200
     2.125    -2.598     0.200
     2.433    -1.564     0.200
     2.879    -3.152     0.200
     0.132     2.045     0.200
     0.158     2.358     0.200
     0.311     2.678     0.200
     0.641    -0.314     0.200
     0.740    -0.309     0.200
     0.740    -0.684     0.200
     0.742    -0.863     0.200
     0.782    -0.266     0.200
     0.782    -0.070     0.200
     1.122    -0.704     0.200
     1.122    -0.861     0.200
     1.169    -0.190     0.200
     1.203     0.383     0.200
     1.212    -0.429     0.200
     1.245    -0.504     0.200
     1.334    -0.584     0.200
     1.334     1.237     0.200
     1.448    -1.066     0.200
     1.444    -0.663     0.200
     1.562    -2.433     0.200
     1.587    -1.184     0.200
     1.653    -2.014     0.200
     2.048    -2.720     0.200
     2.137    -3.482     0.200
     2.859    -4.934     0.200
     2.890    -4.431     0.200
     3.197    -4.466     0.200
     0.162     1.190     0.200
     0.243     0.426     0.200
     0.243     0.408     0.200
     0.254     0.203     0.200
     0.254     0.415     0.200
     0.299    -0.083     0.200
     0.313    -0.072     0.200
     0.345     1.550     0.200
     0.345     1.454     0.200
     0.382     0.879     0.200
     0.393    -0.528     0.200
     0.393    -0.427     0.200
     0.403     1.096     0.200
     0.484     0.102     0.200
     0.472    -0.167     0.200
     0.465     0.272     0.200
     0.470     0.095     0.200
     0.513    -1.027     0.200
     0.578    -0.525     0.200
     0.576    -0.201     0.200
     0.603    -0.654     0.200
     0.684    -0.601     0.200
     0.684    -0.721     0.200
     0.703    -0.763     0.200
     0.700    -0.483     0.200
     0.775    -0.831     0.200
     0.820     0.358     0.200
     0.831     0.296     0.200
     0.860    -0.839     0.200
     0.844    -0.650     0.200
     0.880    -0.524     0.200
     0.905    -1.010     0.200
     0.987    -0.120     0.200
     1.017    -1.198     0.200
     1.041    -0.060     0.200
     1.041    -0.280     0.200
     1.094    -1.482     0.200
     1.101    -1.272     0.200
     1.111    -1.494     0.200
     1.153    -1.867     0.200
     1.181    -1.247     0.200
     1.186    -1.229     0.200
     1.186    -1.388     0.200
     1.272    -1.706     0.200
     1.377    -2.065     0.200
     1.589    -1.760     0.200
     1.909    -2.889     0.200
     2.020    -2.034     0.200
     2.019    -1.922     0.200
     2.180    -2.418     0.200
     2.332    -3.029     0.200
     2.579    -3.791     0.200
     2.624    -3.169     0.200
     2.808    -4.590     0.200
     2.954    -3.275     0.200
     3.083    -2.952     0.200
     3.216    -4.252     0.200
     3.426    -3.478     0.200
     3.441    -3.583     0.200
     0.111     2.315     0.200
     0.111     2.506     0.200
     0.097     2.561     0.200
     0.285     1.434     0.200
     0.291     1.852     0.200
     0.291     2.114     0.200
     0.371    -0.005     0.200
     0.371     2.008     0.200
     0.755     0.441     0.200
     0.813     1.444     0.200
     0.885    -0.977     0.200
     0.963    -0.831     0.200
     0.979    -0.273     0.200
     1.018     0.129     0.200
     1.342     0.059     0.200
     1.427    -0.695     0.200
     1.487    -0.962     0.200
     1.553    -0.590     0.200
     1.614    -1.416     0.200
     1.660    -1.587     0.200
     1.761    -1.752     0.200
     0.033     3.043     0.200
     0.075     2.398     0.200
     0.113     2.253     0.200
     0.129     3.158     0.200
     0.150     2.763     0.200
     0.227     1.506     0.200
     0.253     2.086     0.200
     0.409     1.549     0.200
     0.447     1.301     0.200
     0.753    -1.192     0.200
     0.753     0.167     0.200
     0.793    -0.084     0.200
     0.803     0.633     0.200
     0.855    -0.893     0.200
     0.050     3.196     0.200
     0.050     3.461     0.200
     0.127     1.605     0.200
     0.234     2.355     0.200
     0.234     1.332     0.200
     0.232     0.338     0.200
     0.267     2.515     0.200
     0.309     1.633     0.200
     0.362     1.406     0.200
     0.767     0.715     0.200
     0.845     0.048     0.200
     0.901     0.938     0.200
     0.890    -0.141     0.200
     0.898     0.380     0.200
     0.913     0.339     0.200
     1.038    -1.110     0.200
     1.146    -0.576     0.200
     1.737    -1.422     0.200
     0.102     2.592     0.200
     0.099     3.411     0.200
     0.152     2.808     0.200
     0.177     2.251     0.200
     0.190     2.757     0.200
     0.284     1.804     0.200
     0.331     0.900     0.200
     0.330     1.085     0.200
     0.330     1.405     0.200
     0.469     0.359     0.200
     0.525    -0.762     0.200
     0.530    -0.186     0.200
     0.650    -0.060     0.200
     0.734    -0.542     0.200
     0.757     0.800     0.200
     0.757     2.360     0.200
     0.774     1.535     0.200
     0.910    -0.172     0.200
     0.938    -0.694     0.200
     0.947    -0.129     0.200
     0.947    -0.530     0.200
     0.954    -0.770     0.200
     0.970    -0.253     0.200
     1.022    -1.702     0.200
     1.042    -0.427     0.200
     1.098    -1.169     0.200
     0.048     1.645     0.200
     0.065     1.550     0.200
     0.105     2.182     0.200
     0.108     2.804     0.200
     0.106     2.026     0.200
     0.160     2.746     0.200
     0.242     1.249     0.200
     0.245     1.239     0.200
     0.359     2.113     0.200
     0.489     0.486     0.200
     0.741    -1.122     0.200
     0.854    -0.412     0.200
     0.884     0.915     0.200
     1.204     0.106     0.200
     1.212    -0.721     0.200
     1.342     0.977     0.200
     0.148     1.204     0.200
     0.210    -0.749     0.200
     0.199     0.543     0.200
     0.216     1.495     0.200
     0.275     0.661     0.200
     0.298     1.658     0.200
     0.285     1.928     0.200
     0.285     2.198     0.200
     0.326     1.861     0.200
     0.356     1.781     0.200
     0.365     1.748     0.200
     0.386     1.166     0.200
     0.411     0.926     0.200
     0.405     2.022     0.200
     0.406     2.166     0.200
     0.436     0.201     0.200
     0.553     0.020     0.200
     0.542     0.439     0.200
     0.684    -0.018     0.200
     0.763    -0.757     0.200
     0.883     1.464     0.200
     0.882     0.089     0.200
     0.961     1.004     0.200
     1.060    -0.063     0.200
     1.079    -0.453     0.200
     1.076    -0.642     0.200
     1.130    -1.299     0.200
     1.146    -0.213     0.200
     1.191    -1.018     0.200
     1.266    -1.054     0.200
     1.283    -1.345     0.200
     1.319    -1.156     0.200
     1.345    -1.249     0.200
     1.373    -0.624     0.200
     1.535    -1.328     0.200
     1.575    -0.491     0.200
     1.765    -3.317     0.200
     0.151     1.075     0.200
     0.110     1.257     0.200
     0.125     1.087     0.200
     0.154     1.616     0.200
     0.191     0.324     0.200
     0.216    -0.336     0.200
     0.224    -0.308     0.200
     0.205     0.550     0.200
     0.227     0.584     0.200
     0.243     0.785     0.200
     0.289     1.829     0.200
     0.240     0.944     0.200
     0.240     1.276     0.200
     0.240     1.046     0.200
     0.290     1.031     0.200
     0.338     1.930     0.200
     0.362     2.011     0.200
     0.375     1.145     0.200
     0.346     1.808     0.200
     0.385     1.403     0.200
     0.451     0.525     0.200
     0.483     0.471     0.200
     0.486     0.206     0.200
     0.452     0.502     0.200
     0.507     0.158     0.200
     0.546     0.019     0.200
     0.553     0.179     0.200
     0.573    -0.468     0.200
     0.590     0.120     0.200
     0.676    -0.824     0.200
     0.690    -0.893     0.200
     0.669    -0.187     0.200
     0.687    -0.352     0.200
     0.724    -0.687     0.200
     0.744    -0.663     0.200
     0.763    -0.709     0.200
     0.868    -0.558     0.200
     0.864    -0.363     0.200
     0.931    -0.324     0.200
     0.932     0.191     0.200
     0.924    -0.232     0.200
     0.917    -0.570     0.200
     0.931    -0.871     0.200
     0.930    -0.933     0.200
     0.967    -1.106     0.200
     0.128     1.561     0.200
     0.175     2.455     0.200
     0.215     1.689     0.200
     0.297     2.025     0.200
     0.319     1.527     0.200
     0.297     2.134     0.200
     0.389     1.785     0.200
     0.644     0.031     0.200
     1.187    -0.136     0.200
     0.106     1.303     0.200
     0.107     0.036     0.200
     0.144    -0.135     0.200
     0.150     1.861     0.200
     0.150     2.031     0.200
     0.214     2.011     0.200
     0.214     2.171     0.200
     0.332     2.049     0.200
     0.330     1.662     0.200
     0.473     0.796     0.200
     0.701    -0.317     0.200
     0.865    -1.253     0.200
     0.902     0.060     0.200
     0.872     0.197     0.200
     0.998     1.046     0.200
     1.031    -0.286     0.200
     1.111    -0.536     0.200
     1.124     0.284     0.200
     1.134    -0.363     0.200
     1.131    -0.388     0.200
     1.145    -0.699     0.200
     1.193    -0.489     0.200
     1.245    -0.977     0.200
     1.270    -1.133     0.200
     1.795    -1.218     0.200
     0.040     1.331     0.200
     0.040     1.480     0.200
     0.082     2.342     0.200
     0.118     2.385     0.200
     0.142     2.267     0.200
     0.227     1.529     0.200
     0.256     1.919     0.200
     0.242     1.573     0.200
     0.345     0.690     0.200
     0.446     1.174     0.200
     0.469     1.000     0.200
     0.506     0.736     0.200
     0.599    -0.075     0.200
     0.633     0.055     0.200
     0.759    -1.273     0.200
     0.755    -0.878     0.200
     0.762    -0.684     0.200
     0.849    -0.576     0.200
     0.898     0.963     0.200
     0.909     1.326     0.200
     1.005    -0.204     0.200
     1.081    -1.199     0.200
     1.089     1.661     0.200
     1.187    -0.441     0.200
     1.191    -0.289     0.200
     1.230    -1.382     0.200
     1.263    -0.365     0.200
     1.285    -0.483     0.200
     1.299    -0.766     0.200
     1.333    -0.406     0.200
     1.336    -0.554     0.200
     1.339    -0.752     0.200
     1.357    -2.093     0.200
     1.456    -0.912     0.200
     1.464    -1.111     0.200
     1.462    -0.664     0.200
     1.550    -1.233     0.200
     1.615    -2.864     0.200
     1.757    -1.715     0.200
     0.036     2.225     0.200
     0.073     2.137     0.200
     0.073     4.149     0.200
     0.129     2.874     0.200
     0.151     2.589     0.200
     0.250     1.919     0.200
     0.278     2.303     0.200
     0.251     1.558     0.200
     0.251     2.118     0.200
     0.309     2.484     0.200
     0.313     2.170     0.200
     0.345     1.495     0.200
     0.336     1.016     0.200
     0.348     2.362     0.200
     0.459     1.012     0.200
     0.757    -1.224     0.200
     0.764    -0.956     0.200
     0.791     0.445     0.200
     0.802     0.282     0.200
     1.217    -1.516     0.200
     1.224    -1.250     0.200
     1.348     0.402     0.200
     1.884    -3.305     0.200
     0.052     2.237     0.200
     0.074     2.693     0.200
     0.177     1.311     0.200
     0.229     0.214     0.200
     0.241     0.194     0.200
     0.268     1.477     0.200
     0.352    -0.097     0.200
     0.350     1.279     0.200
     0.358     0.144     0.200
     0.344     0.402     0.200
     0.318     0.706     0.200
     0.412     0.046     0.200
     0.384     2.537     0.200
     0.420     0.551     0.200
     0.411     0.611     0.200
     0.472     0.220     0.200
     0.507     0.212     0.200
     0.498    -0.076     0.200
     0.534     0.198     0.200
     0.547    -1.016     0.200
     0.574    -0.272     0.200
     0.537     0.262     0.200
     0.547     0.052     0.200
     0.610    -0.078     0.200
     0.633    -0.369     0.200
     0.660    -0.533     0.200
     0.674    -0.922     0.200
     0.686    -0.483     0.200
     0.679    -0.484     0.200
     0.776    -0.802     0.200
     0.783    -0.492     0.200
     0.835    -0.857     0.200
     0.868    -0.699     0.200
     0.816     0.136     0.200
     0.850    -0.702     0.200
     0.863    -0.217     0.200
     0.869    -0.338     0.200
     0.893    -0.079     0.200
     0.877    -0.506     0.200
     0.883     0.084     0.200
     0.906    -0.021     0.200
     0.944    -0.741     0.200
     0.922    -0.685     0.200
     0.970    -1.247     0.200
     1.005    -0.938     0.200
     1.083    -1.121     0.200
     1.440     0.238     0.200
     0.077     1.580     0.200
     0.098     1.272     0.200
     0.099     2.137     0.200
     0.073     2.074     0.200
     0.154     1.461     0.200
     0.154     1.499     0.200
     0.107     2.563     0.200
     0.100     1.871     0.200
     0.205     0.639     0.200
     0.205     1.537     0.200
     0.154     1.907     0.200
     0.146     1.435     0.200
     0.219     1.455     0.200
     0.219     1.455     0.200
     0.146     1.909     0.200
     0.146     2.018     0.200
     0.222     1.750     0.200
     0.341     1.123     0.200
     0.333     0.228     0.200
     0.333    -0.041     0.200
     0.356     1.392     0.200
     0.353     0.471     0.200
     0.392     1.658     0.200
     0.403     0.710     0.200
     0.396     1.816     0.200
     0.448     0.078     0.200
     0.497     0.721     0.200
     0.488     1.739     0.200
     0.485     1.641     0.200
     0.485     1.533     0.200
     0.468     0.797     0.200
     0.567    -0.408     0.200
     0.605    -0.029     0.200
     0.592     0.919     0.200
     0.670    -0.690     0.200
     0.721    -0.782     0.200
     0.716    -1.422     0.200
     0.777    -0.984     0.200
     0.842    -0.015     0.200
     0.840    -0.103     0.200
     0.894    -0.193     0.200
     0.929     0.018     0.200
     0.941    -0.247     0.200
     1.017    -0.751     0.200
     0.995    -0.043     0.200
     1.011     0.068     0.200
     1.005     0.370     0.200
     1.052    -0.828     0.200
     1.031     0.256     0.200
     1.077    -1.106     0.200
     1.092    -0.959     0.200
     1.106    -0.913     0.200
     1.152    -0.537     0.200
     1.161    -0.247     0.200
     1.170    -0.491     0.200
     1.208    -0.783     0.200
     1.205    -0.841     0.200
     1.276     0.229     0.200
     1.301     0.310     0.200
     0.074     1.897     0.200
     0.093     1.430     0.200
     0.097     2.321     0.200
     0.072     1.858     0.200
     0.104     1.744     0.200
     0.148     1.689     0.200
     0.148     1.625     0.200
     0.107     2.316     0.200
     0.150     1.459     0.200
     0.200     1.618     0.200
     0.151     1.589     0.200
     0.214     1.672     0.200
     0.214     1.672     0.200
     0.351     0.453     0.200
     0.410     1.923     0.200
     0.403     0.759     0.200
     0.398     1.571     0.200
     0.389     1.426     0.200
     0.403     1.163     0.200
     0.451    -0.199     0.200
     0.451     0.184     0.200
     0.451     0.309     0.200
     0.470     0.710     0.200
     0.492     0.955     0.200
     0.471     0.589     0.200
     0.562    -0.470     0.200
     0.667    -0.846     0.200
     0.717    -0.607     0.200
     0.711    -1.785     0.200
     0.776    -0.519     0.200
     0.906    -0.175     0.200
     0.897    -0.236     0.200
     0.944    -0.311     0.200
     1.010    -0.137     0.200
     1.279    -0.646     0.200
     1.306    -0.600     0.200
     1.506    -2.172     0.200
     0.086     1.437     0.200
     0.177     1.004     0.200
     0.149     0.591     0.200
     0.197     0.592     0.200
     0.229    -0.029     0.200
     0.229     0.361     0.200
     0.234    -0.521     0.200
     0.209     1.071     0.200
     0.320     2.056     0.200
     0.312     0.419     0.200
     0.312     1.208     0.200
     0.347     2.237     0.200
     0.376     1.765     0.200
     0.494     0.465     0.200
     0.502     0.736     0.200
     0.505     0.205     0.200
     0.512     0.404     0.200
     0.519     0.172     0.200
     0.561     0.354     0.200
     0.558     0.009     0.200
     0.589     0.022     0.200
     0.571     0.115     0.200
     0.638     0.070     0.200
     0.635    -0.056     0.200
     0.635     0.436     0.200
     0.657    -0.435     0.200
     0.655    -0.508     0.200
     0.705    -0.680     0.200
     0.672    -0.006     0.200
     0.707    -0.820     0.200
     0.702    -0.528     0.200
     0.740    -0.303     0.200
     0.733    -0.296     0.200
     0.797    -0.387     0.200
     0.802    -0.672     0.200
     0.827    -0.483     0.200
     0.832    -0.563     0.200
     0.920    -0.304     0.200
     0.980    -0.593     0.200
     0.981    -0.677     0.200
     1.004     0.126     0.200
     1.025    -0.305     0.200
     1.064    -0.083     0.200
     1.106    -0.897     0.200
     1.142    -1.307     0.200
     1.166    -1.320     0.200
     1.710    -3.162     0.200
     0.169     0.794     0.200
     0.186     0.440     0.200
     0.186     1.190     0.200
     0.269     1.853     0.200
     0.298     1.620     0.200
     0.290    -0.020     0.200
     0.344     0.525     0.200
     0.413     2.016     0.200
     0.440     2.417     0.200
     0.593     0.326     0.200
     0.633    -0.014     0.200
     0.746    -0.497     0.200
     0.766    -0.973     0.200
     0.823    -0.298     0.200
     0.885    -1.335     0.200
     0.914    -0.316     0.200
     0.963    -0.745     0.200
     0.967     0.124     0.200
     0.967    -0.565     0.200
     0.966     0.405     0.200
     0.992    -0.081     0.200
     1.002    -0.718     0.200
     1.044    -0.445     0.200
     1.238    -1.084     0.200
     1.256    -1.190     0.200
     1.278    -1.127     0.200
     1.375    -1.209     0.200
     0.835     0.487     0.200
     0.781     0.073     0.200
     0.781     1.964     0.200
     0.781     0.175     0.200
     0.314     1.046     0.200
     0.314     1.487     0.200
     1.024    -0.249     0.200
     0.247     1.974     0.200
     0.247     1.824     0.200
     0.178     1.594     0.200
     0.983    -0.527     0.200
     0.887    -0.216     0.200
     0.033     4.057     0.200
     0.035     4.229     0.200
     0.921    -0.345     0.200
     0.921    -0.095     0.200
     0.338     1.135     0.200
     0.338     0.987     0.200
     0.136     2.354     0.200
     0.795     0.161     0.200
     0.241     0.660     0.200
     0.241     0.629     0.200
     0.262     0.676     0.200
     0.120     2.686     0.200
     1.147    -1.238     0.200
     0.119     1.962     0.200
     0.119     2.022     0.200
     0.718     1.284     0.200
     0.148     2.023     0.200
     1.143    -1.320     0.200
     0.773     0.298     0.200
     1.065    -1.622     0.200
     1.065    -0.013     0.200
     0.284     1.273     0.200
     0.509     0.286     0.200
     0.900    -0.387     0.200
     0.316     2.055     0.200
     0.336     2.062     0.200
     0.393     0.867     0.200
     0.983    -1.464     0.200
     0.812    -0.658     0.200
     0.812     1.351     0.200
     0.850    -0.931     0.200
     0.546    -0.325     0.200
     0.837    -0.149     0.200
     0.678    -0.657     0.200
     0.809     0.490     0.200
     0.692    -1.074     0.200
     1.057    -0.901     0.200
     1.095    -1.687     0.200
     0.922    -0.492     0.200
     0.875    -0.737     0.200
     0.922    -0.163     0.200
     1.312    -1.946     0.200
     0.114     2.090     0.200
     0.147     1.785     0.200
     0.149     2.048     0.200
     0.176     1.696     0.200
     0.254     0.638     0.200
     0.254     0.559     0.200
     0.254     1.008     0.200
     0.285     1.064     0.200
     0.276     0.657     0.200
     0.236     1.813     0.200
     0.325     1.873     0.200
     0.318     0.488     0.200
     0.318     1.678     0.200
     0.318     1.258     0.200
     0.349     0.829     0.200
     0.457     0.993     0.200
     0.466     0.473     0.200
     0.466     0.723     0.200
     0.522     0.409     0.200
     0.542    -0.454     0.200
     0.671    -0.782     0.200
     0.689    -1.583     0.200
     0.706    -0.977     0.200
     0.750     0.144     0.200
     0.785     0.135     0.200
     0.777     0.080     0.200
     0.822     0.504     0.200
     0.772     1.201     0.200
     0.772     0.972     0.200
     0.800    -0.166     0.200
     0.804     0.407     0.200
     0.799     1.197     0.200
     0.851    -0.522     0.200
     0.829     0.439     0.200
     0.934    -0.269     0.200
     0.912     0.042     0.200
     0.893    -0.404     0.200
     0.928    -0.651     0.200
     1.109    -1.864     0.200
     0.131     1.875     0.200
     0.116     2.192     0.200
     0.149     1.792     0.200
     0.150     2.025     0.200
     0.178     2.969     0.200
     0.174     1.601     0.200
     0.255     0.789     0.200
     0.287     1.120     0.200
     0.277     0.681     0.200
     0.233     1.996     0.200
     0.233     1.714     0.200
     0.316     1.053     0.200
     0.316     1.333     0.200
     0.316     1.903     0.200
     0.349     0.989     0.200
     0.544    -0.358     0.200
     0.632    -0.350     0.200
     0.672    -0.785     0.200
     0.691    -1.170     0.200
     0.753     0.097     0.200
     0.729     0.363     0.200
     0.786     0.047     0.200
     0.800     1.441     0.200
     0.776     0.086     0.200
     0.769     0.867     0.200
     0.769     1.037     0.200
     0.797     0.254     0.200
     0.803     0.423     0.200
     0.826     0.396     0.200
     0.892    -0.243     0.200
     0.927    -0.193     0.200
     0.051     1.511     0.200
     0.053     1.853     0.200
     0.059     0.751     0.200
     0.059     0.871     0.200
     0.059     1.551     0.200
     0.145     1.686     0.200
     0.145     1.718     0.200
     0.143     2.264     0.200
     0.143     1.474     0.200
     0.143     1.784     0.200
     0.175     2.313     0.200
     0.265     1.978     0.200
     0.257     1.547     0.200
     0.246     0.979     0.200
     0.294     1.953     0.200
     0.312     1.406     0.200
     0.312     1.096     0.200
     0.356     1.464     0.200
     0.474     0.905     0.200
     0.477     1.085     0.200
     0.495     1.323     0.200
     0.613    -0.146     0.200
     0.619    -0.315     0.200
     0.636    -0.297     0.200
     0.762    -0.996     0.200
     0.791    -1.077     0.200
     0.873     0.927     0.200
     0.934    -0.414     0.200
     0.971     0.067     0.200
     1.082     1.572     0.200
     1.157     0.290     0.200
     1.153    -0.266     0.200
     1.189     0.551     0.200
     1.197    -0.827     0.200
     1.229    -1.265     0.200
     1.229    -0.375     0.200
     1.299    -0.298     0.200
     1.302    -0.615     0.200
     1.343     0.931     0.200
     1.545    -2.042     0.200
     1.874    -0.628     0.200
     0.048     2.702     0.200
     0.049     1.763     0.200
     0.132     1.922     0.200
     0.132     1.360     0.200
     0.152     2.932     0.200
     0.152     1.775     0.200
     0.177     2.583     0.200
     0.177     2.412     0.200
     0.247     2.103     0.200
     0.247     1.608     0.200
     0.310     1.027     0.200
     0.310     1.277     0.200
     0.263     1.031     0.200
     0.263     1.578     0.200
     0.338     1.495     0.200
     0.409     1.260     0.200
     0.596    -0.078     0.200
     0.619    -0.244     0.200
     0.836    -0.590     0.200
     0.781    -0.832     0.200
     0.863     0.541     0.200
     0.973     0.476     0.200
     0.938     0.350     0.200
     0.938     1.171     0.200
     1.197    -0.270     0.200
     1.203    -0.802     0.200
     1.359     1.172     0.200
     1.579    -2.199     0.200
     1.892    -4.109     0.200
     0.041     2.465     0.200
     0.043     2.121     0.200
     0.060     1.477     0.200
     0.060     1.337     0.200
     0.060     1.774     0.200
     0.144     1.763     0.200
     0.144     2.208     0.200
     0.154     2.044     0.200
     0.258     1.873     0.200
     0.184     1.718     0.200
     0.259     1.417     0.200
     0.303     1.017     0.200
     0.303     0.806     0.200
     0.257     1.232     0.200
     0.479     0.927     0.200
     0.608    -0.630     0.200
     0.755    -0.792     0.200
     0.793    -1.375     0.200
     0.935     1.103     0.200
     0.935     0.189     0.200
     1.185    -0.489     0.200
     1.192    -1.155     0.200
     1.353     0.320     0.200
     1.884    -0.531     0.200
     0.152     2.048     0.200
     0.044     1.881     0.200
     0.147     1.865     0.200
     0.261     1.441     0.200
     0.262     1.488     0.200
     0.303     0.906     0.200
     0.303     1.063     0.200
     0.424     1.230     0.200
     0.424     1.254     0.200
     0.466     0.717     0.200
     0.610     0.216     0.200
     0.714    -0.152     0.200
     0.795    -0.993     0.200
     0.759    -0.428     0.200
     0.932    -0.185     0.200
     0.932     0.362     0.200
     0.864     0.562     0.200
     0.964    -0.096     0.200
     1.184     0.265     0.200
     1.191    -1.397     0.200
     1.349    -1.187     0.200
     0.035     2.341     0.200
     0.035     2.241     0.200
     0.035     3.101     0.200
     0.056     2.251     0.200
     0.057     2.413     0.200
     0.117     2.080     0.200
     0.117     2.101     0.200
     0.173     2.645     0.200
     0.232     2.050     0.200
     0.234     1.873     0.200
     0.234     1.733     0.200
     0.275     1.306     0.200
     0.316     1.370     0.200
     0.316     1.491     0.200
     0.324     1.656     0.200
     0.337     1.158     0.200
     0.476     0.857     0.200
     0.625    -0.532     0.200
     0.779    -0.066     0.200
     0.779     0.614     0.200
     0.774     0.246     0.200
     0.766    -1.086     0.200
     0.861     0.153     0.200
     0.947     0.155     0.200
     0.947     0.686     0.200
     0.947     1.572     0.200
     0.982     0.218     0.200
     1.209    -0.547     0.200
     1.214    -0.991     0.200
     1.372    -1.276     0.200
     1.906    -3.116     0.200
     0.024     3.297     0.200
     0.024     4.596     0.200
     0.108     1.543     0.200
     0.082     2.672     0.200
     0.144     2.649     0.200
     0.217     1.663     0.200
     0.240     1.371     0.200
     0.336     1.239     0.200
     0.308     2.120     0.200
     0.583    -0.725     0.200
     0.617    -0.347     0.200
     0.739    -0.696     0.200
     0.751    -0.987     0.200
     0.794     1.186     0.200
     0.801     0.820     0.200
     0.923    -0.528     0.200
     0.923     0.611     0.200
     1.229     0.541     0.200
     1.280    -2.244     0.200
     1.236    -0.669     0.200
     1.354     1.193     0.200
     1.892    -2.705     0.200
     0.010     4.238     0.200
     0.010     5.050     0.200
     0.097     2.952     0.200
     0.137     2.811     0.200
     0.196     1.844     0.200
     0.222     2.263     0.200
     0.304     1.967     0.200
     0.315     2.401     0.200
     0.416     1.365     0.200
     0.416     1.572     0.200
     0.748    -0.056     0.200
     0.817    -0.139     0.200
     0.932    -0.567     0.200
     0.932     0.202     0.200
     1.249     0.485     0.200
     1.255    -0.837     0.200
     1.369     0.310     0.200
     1.909    -1.230     0.200
     0.147     1.934     0.200
     0.148     1.359     0.200
     0.290     0.729     0.200
     0.290     1.350     0.200
     0.389     1.374     0.200
     0.340     1.250     0.200
     0.451     0.212     0.200
     0.564     0.958     0.200
     0.564     0.778     0.200
     0.569    -0.332     0.200
     0.735    -0.214     0.200
     0.735    -0.093     0.200
     0.755    -1.293     0.200
     0.869     0.772     0.200
     0.869     0.340     0.200
     0.811    -0.097     0.200
     0.894    -0.305     0.200
     0.897     1.201     0.200
     0.902     0.451     0.200
     0.985    -0.204     0.200
     1.011    -0.129     0.200
     1.006    -0.238     0.200
     1.146    -1.317     0.200
     1.244    -0.400     0.200
EOF
gmt end
