#!/bin/bash
gmt begin elmayor5.35_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional elmayor5.35'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.664
    15.000    42.385
    15.500    42.104
    16.000    41.820
    16.500    41.530
    17.000    41.234
    17.500    40.930
    18.000    40.615
    18.500    40.288
    19.000    39.946
    19.500    39.588
    20.000    39.211
    20.500    38.812
    21.000    38.390
    21.500    37.942
    22.000    37.466
    22.500    36.961
    23.000    36.424
    23.500    35.853
    24.000    34.640
    24.500    33.368
    25.000    32.087
    25.500    30.795
    26.000    29.492
    26.500    28.178
    27.000    26.851
    27.500    25.508
    28.000    24.145
    28.500    22.766
    29.000    21.376
    29.500    19.978
    30.000    18.571
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.145 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500     4.631
     1.000     5.898
     1.500     7.164
     2.000     8.430
     2.500     9.696
     3.000    10.963
     3.500    12.229
     4.000    13.494
     4.500    14.756
     5.000    16.018
     5.500    17.279
     6.000    18.539
     6.500    19.797
     7.000    21.053
     7.500    22.307
     8.000    23.560
     8.500    24.811
     9.000    26.059
     9.500    27.305
    10.000    28.406
    10.500    29.337
    11.000    30.253
    11.500    31.153
    12.000    32.033
    12.500    32.890
    13.000    33.721
    13.500    34.525
    14.000    35.299
    14.500    36.043
    15.000    36.755
    15.500    37.433
    16.000    38.013
    16.500    38.522
    17.000    38.971
    17.500    39.783
    18.000    40.131
    18.500    40.420
    19.000    40.651
    19.500    40.825
    20.000    40.939
    20.500    40.995
    21.000    40.991
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    30.721 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.367
     1.000     6.273
     1.500     9.179
     2.000    12.085
     2.500    14.990
     3.000    17.894
     3.500    20.798
     4.000    23.700
     4.500    26.601
     5.000    29.501
     5.500    32.399
     6.000    35.296
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    27.501 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500    12.627
     1.000    19.239
     1.500    25.851
     2.000    32.463
     2.500    39.075
     3.000    45.687
     3.500    52.299
     4.000    58.908
     4.500    65.514
     5.000    72.120
     5.500    78.722
     6.000    85.322
     6.500    91.919
     7.000    98.514
     7.500   105.105
     8.000   111.694
     8.500   118.279
     9.000   124.860
     9.500   131.436
    10.000   138.009
    10.500   144.576
    11.000   151.139
    11.500   157.697
    12.000   164.250
    12.500   170.797
    13.000   177.234
    13.500   183.526
    14.000   189.812
    14.500   196.097
    15.000   202.378
    15.500   208.656
    16.000   214.927
    16.500   221.192
    17.000   227.450
    17.500   234.595
    18.000   240.866
    18.500   247.126
    19.000   253.372
    19.500   259.605
    20.000   265.824
    20.500   272.028
    21.000   278.218
    21.500   284.393
    22.000   290.552
    22.500   296.695
    23.000   302.822
    23.500   308.932
    24.000   315.025
    24.500   321.100
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    56.908 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.421
     1.000    20.004
     1.500    29.586
     2.000    39.169
     2.500    48.751
     3.000    58.331
     3.500    67.910
     4.000    77.487
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    65.910 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    17.513    46.390     0.150
    15.070   345.117     0.150
    20.068   254.676     0.150
    21.057   271.735     0.150
    21.158   273.088     0.150
     5.237   877.898     0.150
     5.401   882.880     0.150
    15.149   346.231     0.150
     4.137   890.888     0.150
     8.567   627.607     0.150
    15.159   349.085     0.150
    28.341  -325.534     0.150
    17.602    47.727     0.150
    19.344    57.138     0.150
    19.430    51.025     0.150
    24.556   292.973     0.150
    28.977   316.037     0.150
    29.439   313.348     0.150
    29.490   309.644     0.150
    14.219   568.930     0.150
    16.322   546.426     0.150
    16.341   545.630     0.150
    16.341   553.240     0.150
     4.371   675.728     0.150
    16.591    49.364     0.150
    16.591   239.594     0.150
    15.609   336.294     0.150
    23.248   485.696     0.150
    23.514   476.331     0.150
    29.851   205.613     0.150
    15.128   221.175     0.150
    15.208   226.974     0.150
     1.485   919.260     0.150
    15.625   338.240     0.150
    15.662   343.855     0.150
     1.286   919.276     0.150
     2.058   912.464     0.150
    16.290   328.063     0.150
    16.290   548.273     0.150
    16.309   335.270     0.150
    16.309   545.918     0.150
    16.309   766.988     0.150
     0.770   929.410     0.150
    15.115   344.363     0.150
    22.660   284.024     0.150
    29.586    27.804     0.150
    29.848   202.698     0.150
    29.848   202.294     0.150
     9.647   613.792     0.150
     6.403   648.336     0.150
    16.411   237.647     0.150
    16.411   546.272     0.150
    18.244   529.353     0.150
    28.423    89.958     0.150
    15.549   218.539     0.150
    16.355   332.272     0.150
    23.214   287.799     0.150
    24.225   296.852     0.150
    29.487   204.206     0.150
    14.728   208.198     0.150
    14.769   209.054     0.150
    15.735   221.073     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.161    39.899     0.200
    14.369    40.018     0.200
    14.548    40.211     0.200
    14.649    42.208     0.200
    15.216    41.225     0.200
    16.117    42.272     0.200
    16.688    41.275     0.200
    17.380    42.125     0.200
    17.868    44.269     0.200
    18.504    40.716     0.200
    19.242    40.662     0.200
    20.400    38.995     0.200
    20.871    38.990     0.200
    21.029    37.552     0.200
    21.275    38.685     0.200
    21.427    36.158     0.200
    21.663    38.748     0.200
    21.722    38.633     0.200
    21.778    38.510     0.200
    22.123    39.125     0.200
    22.655    38.621     0.200
    22.750    37.172     0.200
    22.951    37.418     0.200
    23.193    37.489     0.200
    23.770    34.664     0.200
    24.237    34.218     0.200
    24.219    34.122     0.200
    24.295    34.434     0.200
    24.500    34.090     0.200
    26.411    30.838     0.200
    26.389    30.367     0.200
    27.059    27.296     0.200
    27.909    25.986     0.200
    27.909    26.261     0.200
    28.401    23.023     0.200
    28.599    23.132     0.200
    28.648    23.063     0.200
    28.913    22.244     0.200
    29.359    19.765     0.200
    29.413    20.312     0.200
    29.441    21.468     0.200
    29.993    19.243     0.200
    14.606    44.155     0.200
    15.935    40.726     0.200
    15.935    41.515     0.200
    15.925    41.944     0.200
    16.514    42.052     0.200
    16.770    43.274     0.200
    20.867    38.826     0.200
    14.533    42.889     0.200
    14.628    40.577     0.200
    15.912    41.662     0.200
    15.912    41.428     0.200
    16.527    42.036     0.200
    16.674    41.701     0.200
    16.792    40.734     0.200
    17.374    43.875     0.200
    18.202    40.687     0.200
    20.378    39.597     0.200
    20.858    38.385     0.200
    21.007    39.051     0.200
    22.729    37.401     0.200
    22.930    37.700     0.200
    23.749    35.483     0.200
    27.902    27.266     0.200
    27.902    27.040     0.200
    22.720    36.742     0.200
    14.083    39.359     0.200
    14.212    39.468     0.200
    14.280    39.576     0.200
    14.762    40.207     0.200
    14.990    40.412     0.200
    15.123    40.414     0.200
    15.148    40.126     0.200
    15.425    40.542     0.200
    15.720    40.368     0.200
    15.897    40.431     0.200
    15.978    40.396     0.200
    16.116    40.805     0.200
    16.141    43.526     0.200
    16.565    40.798     0.200
    16.599    40.903     0.200
    16.624    41.481     0.200
    16.715    40.129     0.200
    16.854    40.621     0.200
    17.012    41.616     0.200
    17.262    42.592     0.200
    17.304    43.248     0.200
    18.067    40.762     0.200
    18.067    40.611     0.200
    19.368    40.178     0.200
    20.411    39.101     0.200
    20.808    38.477     0.200
    21.041    38.751     0.200
    21.285    39.010     0.200
    21.356    40.372     0.200
    21.444    38.687     0.200
    21.471    36.240     0.200
    21.588    38.074     0.200
    21.811    37.440     0.200
    21.959    38.050     0.200
    22.142    38.520     0.200
    22.342    37.376     0.200
    22.368    37.681     0.200
    22.773    37.002     0.200
    22.886    35.825     0.200
    22.954    36.724     0.200
    22.971    36.933     0.200
    23.206    37.637     0.200
    23.748    34.440     0.200
    23.798    35.944     0.200
    23.974    35.546     0.200
    24.027    36.415     0.200
    24.187    33.736     0.200
    24.229    34.552     0.200
    24.287    34.147     0.200
    24.308    33.927     0.200
    24.523    33.160     0.200
    25.667    30.402     0.200
    26.268    30.030     0.200
    26.430    29.018     0.200
    26.696    27.659     0.200
    26.806    27.379     0.200
    26.876    26.955     0.200
    27.066    26.782     0.200
    27.834    26.828     0.200
    28.929    21.698     0.200
    29.422    20.253     0.200
    29.468    20.915     0.200
    29.947    19.233     0.200
    14.166    42.234     0.200
    14.500    42.099     0.200
    14.547    40.500     0.200
    14.560    40.531     0.200
    14.624    40.976     0.200
    14.627    43.480     0.200
    14.871    42.861     0.200
    15.436    41.850     0.200
    15.798    41.565     0.200
    16.151    43.825     0.200
    16.295    44.374     0.200
    16.634    41.980     0.200
    16.662    46.478     0.200
    16.762    41.681     0.200
    16.848    42.012     0.200
    16.852    41.187     0.200
    16.967    41.734     0.200
    17.004    42.003     0.200
    17.189    41.652     0.200
    17.306    41.971     0.200
    17.315    44.381     0.200
    17.741    43.289     0.200
    18.249    41.483     0.200
    20.818    38.694     0.200
    20.945    40.620     0.200
    21.044    40.363     0.200
    21.288    38.215     0.200
    21.595    38.291     0.200
    22.346    37.562     0.200
    22.894    35.970     0.200
    22.956    37.951     0.200
    22.972    36.553     0.200
    23.755    37.513     0.200
    23.799    38.317     0.200
    24.027    37.673     0.200
    24.197    33.867     0.200
    24.232    33.856     0.200
    24.292    33.929     0.200
    26.269    29.881     0.200
    27.069    27.016     0.200
    27.845    27.601     0.200
    14.283    39.753     0.200
    14.311    40.068     0.200
    14.552    40.201     0.200
    14.846    39.737     0.200
    14.852    40.673     0.200
    15.125    40.922     0.200
    15.149    39.990     0.200
    15.860    40.540     0.200
    16.126    40.648     0.200
    16.142    43.858     0.200
    16.284    43.936     0.200
    16.570    41.970     0.200
    16.631    41.668     0.200
    16.870    40.455     0.200
    17.306    43.001     0.200
    17.531    40.513     0.200
    18.080    41.794     0.200
    20.429    39.215     0.200
    20.815    39.112     0.200
    21.059    38.266     0.200
    21.303    39.525     0.200
    21.603    38.809     0.200
    21.977    38.424     0.200
    22.359    38.097     0.200
    22.386    37.966     0.200
    22.791    37.499     0.200
    22.900    38.326     0.200
    22.989    37.849     0.200
    23.816    37.084     0.200
    23.984    35.953     0.200
    24.044    36.868     0.200
    24.199    34.524     0.200
    24.303    34.854     0.200
    27.836    27.058     0.200
    14.286    40.257     0.200
    14.392    42.577     0.200
    15.847    39.571     0.200
    14.288    40.130     0.200
    14.528    42.505     0.200
    15.849    41.399     0.200
    21.595    38.599     0.200
    23.991    36.425     0.200
    14.300    39.726     0.200
    15.137    41.228     0.200
    15.294    42.440     0.200
    16.493    41.672     0.200
    16.620    40.687     0.200
    17.294    40.620     0.200
    18.499    38.895     0.200
    19.944    37.634     0.200
    20.427    39.187     0.200
    20.804    38.487     0.200
    20.963    38.506     0.200
    21.057    36.735     0.200
    21.158    37.963     0.200
    21.595    38.365     0.200
    21.706    37.867     0.200
    22.354    34.899     0.200
    22.790    36.760     0.200
    22.892    38.018     0.200
    22.969    36.062     0.200
    22.987    36.112     0.200
    23.222    37.023     0.200
    23.992    36.079     0.200
    24.045    35.858     0.200
    24.189    33.134     0.200
    24.540    32.754     0.200
    25.683    29.759     0.200
    27.081    27.466     0.200
    27.825    26.983     0.200
    27.825    26.780     0.200
    14.303    39.739     0.200
    14.400    42.480     0.200
    14.494    40.243     0.200
    14.533    38.663     0.200
    14.840    39.106     0.200
    15.075    42.971     0.200
    15.116    40.376     0.200
    15.141    40.376     0.200
    15.234    40.826     0.200
    15.299    43.198     0.200
    15.388    39.955     0.200
    15.427    41.157     0.200
    15.604    42.784     0.200
    15.628    40.046     0.200
    15.853    40.171     0.200
    16.062    40.731     0.200
    16.121    41.202     0.200
    16.496    41.642     0.200
    16.573    39.676     0.200
    16.625    41.428     0.200
    16.877    39.941     0.200
    17.297    43.517     0.200
    17.537    41.367     0.200
    18.077    40.840     0.200
    18.271    40.266     0.200
    19.951    38.801     0.200
    20.433    38.151     0.200
    20.809    37.702     0.200
    21.063    38.360     0.200
    22.796    36.270     0.200
    22.899    37.377     0.200
    22.975    36.576     0.200
    22.993    36.744     0.200
    23.994    35.498     0.200
    24.195    34.319     0.200
    27.827    25.658     0.200
    29.956    19.161     0.200
    14.188    44.509     0.200
    14.343    40.310     0.200
    14.355    40.066     0.200
    14.538    40.179     0.200
    15.436    40.886     0.200
    15.656    42.630     0.200
    15.903    41.407     0.200
    16.163    41.143     0.200
    16.186    43.582     0.200
    17.350    41.879     0.200
    18.112    41.611     0.200
    19.279    39.962     0.200
    20.432    40.208     0.200
    20.856    38.132     0.200
    20.952    39.978     0.200
    21.856    41.727     0.200
    21.978    37.879     0.200
    22.927    36.094     0.200
    22.975    38.010     0.200
    22.987    34.971     0.200
    23.785    36.120     0.200
    23.949    35.372     0.200
    27.089    26.646     0.200
    29.992    19.761     0.200
    23.062    35.950     0.200
    14.386    39.792     0.200
    14.398    40.797     0.200
    14.609    45.104     0.200
    15.154    42.280     0.200
    15.215    40.947     0.200
    15.233    40.000     0.200
    15.379    40.085     0.200
    15.470    40.579     0.200
    15.700    42.427     0.200
    15.894    39.473     0.200
    15.941    40.964     0.200
    16.186    39.988     0.200
    16.377    42.053     0.200
    16.556    42.294     0.200
    16.704    41.317     0.200
    16.807    41.563     0.200
    17.397    43.895     0.200
    17.476    41.747     0.200
    18.225    40.069     0.200
    20.888    38.344     0.200
    21.033    38.852     0.200
    21.628    37.794     0.200
    22.932    36.883     0.200
    22.954    37.045     0.200
    23.892    36.927     0.200
    24.310    34.016     0.200
    27.926    27.379     0.200
    27.926    26.949     0.200
    14.335    40.190     0.200
    14.692    39.095     0.200
    14.901    39.517     0.200
    15.162    39.651     0.200
    15.613    39.620     0.200
    15.901    40.497     0.200
    16.052    42.166     0.200
    16.232    39.741     0.200
    16.526    40.379     0.200
    16.531    39.898     0.200
    16.620    40.201     0.200
    16.670    40.300     0.200
    16.677    41.271     0.200
    16.678    40.404     0.200
    16.896    40.947     0.200
    18.033    40.731     0.200
    18.133    40.707     0.200
    20.999    40.811     0.200
    21.657    37.962     0.200
    22.955    35.218     0.200
    23.986    34.580     0.200
    24.164    32.830     0.200
    15.969    42.337     0.200
    16.569    42.796     0.200
    16.804    39.537     0.200
    18.230    41.259     0.200
    22.962    35.799     0.200
    23.356    36.788     0.200
    14.474    39.715     0.200
    15.362    40.018     0.200
    15.464    40.945     0.200
    15.562    40.451     0.200
    15.635    40.945     0.200
    15.657    41.373     0.200
    15.682    40.378     0.200
    15.934    40.860     0.200
    15.934    40.454     0.200
    15.985    41.607     0.200
    16.570    40.608     0.200
    16.792    41.668     0.200
    17.385    40.491     0.200
    18.243    41.882     0.200
    19.957    38.660     0.200
    20.884    38.842     0.200
    20.913    39.746     0.200
    20.931    39.798     0.200
    21.295    38.888     0.200
    21.632    40.415     0.200
    21.636    38.371     0.200
    21.683    36.184     0.200
    22.368    35.908     0.200
    22.385    36.704     0.200
    22.770    37.772     0.200
    22.964    37.778     0.200
    22.972    37.968     0.200
    23.214    36.137     0.200
    23.788    36.404     0.200
    23.990    37.627     0.200
    24.011    37.465     0.200
    24.240    35.275     0.200
    24.321    34.693     0.200
    15.950    43.035     0.200
    21.803    38.553     0.200
    14.932    40.503     0.200
    15.159    41.132     0.200
    15.431    41.103     0.200
    15.477    41.571     0.200
    15.612    42.000     0.200
    16.325    42.224     0.200
    16.292    44.167     0.200
    16.629    41.200     0.200
    16.743    43.747     0.200
    17.342    44.629     0.200
    18.430    43.107     0.200
    18.467    40.931     0.200
    18.479    40.535     0.200
    18.494    40.972     0.200
    18.486    40.664     0.200
    18.690    40.575     0.200
    18.801    40.094     0.200
    18.820    40.899     0.200
    18.849    39.693     0.200
    18.957    40.798     0.200
    19.107    39.826     0.200
    19.188    39.287     0.200
    19.182    41.323     0.200
    19.412    39.889     0.200
    19.522    40.171     0.200
    19.840    39.887     0.200
    19.915    40.102     0.200
    19.978    40.252     0.200
    20.372    39.545     0.200
    20.438    39.155     0.200
    20.812    38.455     0.200
    20.802    39.002     0.200
    21.207    39.048     0.200
    21.363    42.029     0.200
    21.542    38.303     0.200
    21.542    37.834     0.200
    21.537    41.448     0.200
    21.604    37.922     0.200
    21.660    39.990     0.200
    21.853    38.867     0.200
    21.880    38.264     0.200
    22.274    40.198     0.200
    22.294    39.519     0.200
    22.845    35.536     0.200
    22.845    35.763     0.200
    22.889    37.030     0.200
    23.712    35.808     0.200
    23.900    36.589     0.200
    23.900    34.980     0.200
    23.939    36.853     0.200
    24.168    34.003     0.200
    24.152    34.984     0.200
    24.439    34.652     0.200
    25.583    31.581     0.200
    26.232    31.767     0.200
    26.185    30.707     0.200
    26.348    33.463     0.200
    26.764    29.957     0.200
    26.990    27.569     0.200
    27.869    27.059     0.200
    27.869    26.309     0.200
    28.205    23.273     0.200
    28.341    23.599     0.200
    29.290    20.224     0.200
    29.922    19.446     0.200
    15.928    43.156     0.200
    16.017    41.029     0.200
    15.954    41.204     0.200
    22.941    36.464     0.200
    14.758    40.941     0.200
    15.126    40.323     0.200
    15.250    42.238     0.200
    15.474    43.758     0.200
    16.032    41.841     0.200
    16.032    43.498     0.200
    18.277    42.593     0.200
    21.723    38.857     0.200
    23.013    38.834     0.200
    23.029    39.472     0.200
    28.007    27.128     0.200
    14.812    42.920     0.200
    17.358    42.423     0.200
    17.512    42.909     0.200
    17.812    46.176     0.200
    18.062    42.587     0.200
    18.135    42.895     0.200
    18.160    42.687     0.200
    18.178    43.015     0.200
    18.210    42.049     0.200
    18.227    42.225     0.200
    18.423    42.640     0.200
    18.435    42.508     0.200
    18.603    41.384     0.200
    18.663    41.527     0.200
    19.475    40.676     0.200
    19.598    40.925     0.200
    19.709    40.421     0.200
    19.735    40.231     0.200
    19.777    42.198     0.200
    19.780    36.608     0.200
    20.025    39.522     0.200
    20.102    40.630     0.200
    20.164    39.869     0.200
    20.365    41.366     0.200
    20.558    39.556     0.200
    20.624    39.804     0.200
    20.988    38.763     0.200
    21.032    44.962     0.200
    21.044    43.301     0.200
    21.238    44.660     0.200
    21.515    37.194     0.200
    21.710    38.511     0.200
    21.716    39.077     0.200
    21.725    39.142     0.200
    21.985    39.362     0.200
    22.189    42.021     0.200
    23.031    37.628     0.200
    23.560    40.301     0.200
    23.815    35.892     0.200
    23.860    38.346     0.200
    24.046    35.636     0.200
    24.398    34.459     0.200
    24.556    33.075     0.200
    25.386    36.461     0.200
    26.305    30.845     0.200
    26.898    28.323     0.200
    28.012    27.160     0.200
    28.012    25.371     0.200
    28.323    24.125     0.200
    28.400    26.911     0.200
    28.977    21.631     0.200
    29.490    20.847     0.200
    22.270    38.900     0.200
    23.245    37.280     0.200
    28.301    25.669     0.200
    15.048    42.693     0.200
    15.568    41.933     0.200
    15.695    43.496     0.200
    15.866    42.280     0.200
    16.574    43.163     0.200
    16.893    42.375     0.200
    17.001    43.427     0.200
    18.608    41.931     0.200
    19.239    40.925     0.200
    20.011    40.839     0.200
    20.882    40.995     0.200
    21.077    39.943     0.200
    21.311    39.103     0.200
    21.443    39.557     0.200
    21.657    38.867     0.200
    21.714    38.862     0.200
    21.750    38.766     0.200
    21.790    38.891     0.200
    21.972    39.029     0.200
    22.101    40.712     0.200
    22.423    37.827     0.200
    22.961    38.049     0.200
    22.978    37.495     0.200
    23.064    36.847     0.200
    23.220    36.933     0.200
    23.750    36.742     0.200
    23.741    38.271     0.200
    23.889    36.455     0.200
    23.956    37.633     0.200
    24.018    36.684     0.200
    24.257    34.933     0.200
    24.324    35.341     0.200
    24.416    34.567     0.200
    24.502    34.789     0.200
    26.253    30.635     0.200
    26.253    31.909     0.200
    26.656    29.729     0.200
    27.102    27.633     0.200
    28.124    26.346     0.200
    28.268    24.803     0.200
    29.412    21.858     0.200
    29.428    21.419     0.200
    15.366    40.917     0.200
    15.819    41.038     0.200
    16.103    41.107     0.200
    16.103    41.607     0.200
    16.352    41.304     0.200
    16.956    42.798     0.200
    17.540    41.914     0.200
    17.546    43.670     0.200
    18.644    40.557     0.200
    19.306    41.163     0.200
    20.057    38.724     0.200
    20.954    40.510     0.200
    21.054    38.729     0.200
    21.369    38.559     0.200
    21.725    38.708     0.200
    21.751    38.686     0.200
    21.774    37.648     0.200
    22.032    38.016     0.200
    22.469    37.123     0.200
    23.025    36.429     0.200
    23.036    36.813     0.200
    23.083    36.757     0.200
    23.280    35.456     0.200
    23.820    35.109     0.200
    23.818    36.520     0.200
    23.919    35.717     0.200
    24.029    36.654     0.200
    24.072    34.959     0.200
    24.383    33.977     0.200
    24.415    34.705     0.200
    24.415    34.103     0.200
    24.438    33.973     0.200
    26.318    29.106     0.200
    26.318    29.426     0.200
    26.725    28.054     0.200
    26.900    27.748     0.200
    26.961    28.637     0.200
    27.158    26.750     0.200
    28.077    25.926     0.200
    28.077    26.316     0.200
    28.334    22.984     0.200
    28.361    23.013     0.200
    28.994    21.878     0.200
    29.347    20.343     0.200
    29.465    20.175     0.200
    29.497    20.330     0.200
    16.024    43.630     0.200
    23.063    37.710     0.200
    27.984    26.696     0.200
    15.865    41.508     0.200
    20.847    38.592     0.200
    21.738    38.172     0.200
    23.025    36.998     0.200
    24.136    36.462     0.200
    27.798    26.193     0.200
    14.895    40.567     0.200
    15.391    41.055     0.200
    15.452    45.780     0.200
    15.683    41.271     0.200
    15.799    41.479     0.200
    15.895    41.075     0.200
    15.998    44.398     0.200
    16.034    41.376     0.200
    16.135    42.241     0.200
    16.384    41.088     0.200
    16.384    41.363     0.200
    16.847    43.919     0.200
    17.123    41.385     0.200
    17.266    43.248     0.200
    17.723    42.403     0.200
    17.851    42.601     0.200
    18.438    41.496     0.200
    18.668    40.527     0.200
    19.158    40.576     0.200
    21.306    38.350     0.200
    21.572    38.638     0.200
    21.773    38.578     0.200
    21.855    37.873     0.200
    21.927    38.551     0.200
    22.445    39.048     0.200
    22.896    38.592     0.200
    22.944    37.787     0.200
    23.186    37.506     0.200
    23.177    37.984     0.200
    23.488    37.798     0.200
    23.649    36.964     0.200
    23.970    33.951     0.200
    24.002    35.456     0.200
    24.282    35.013     0.200
    24.454    33.931     0.200
    24.595    32.362     0.200
    24.595    33.062     0.200
    26.182    29.545     0.200
    26.182    30.270     0.200
    27.079    27.475     0.200
    27.286    27.438     0.200
    28.193    24.787     0.200
    28.392    25.422     0.200
    28.392    25.637     0.200
    28.877    22.995     0.200
    29.400    21.286     0.200
    29.582    20.893     0.200
    15.990    40.325     0.200
    23.032    36.076     0.200
    16.003    41.077     0.200
    23.070    37.628     0.200
    27.956    25.338     0.200
    14.300    39.824     0.200
    14.533    39.636     0.200
    14.617    39.408     0.200
    15.384    39.804     0.200
    15.444    40.574     0.200
    15.609    40.004     0.200
    15.736    40.317     0.200
    15.752    41.187     0.200
    15.870    40.384     0.200
    15.896    40.520     0.200
    16.174    40.156     0.200
    16.174    40.881     0.200
    16.406    40.161     0.200
    16.934    41.027     0.200
    18.326    40.641     0.200
    18.655    38.832     0.200
    19.680    39.612     0.200
    20.056    37.532     0.200
    21.118    38.354     0.200
    21.353    38.314     0.200
    21.693    37.840     0.200
    21.761    38.454     0.200
    21.799    37.858     0.200
    22.012    37.602     0.200
    22.469    38.488     0.200
    22.999    36.997     0.200
    23.019    36.555     0.200
    23.113    36.149     0.200
    23.261    36.749     0.200
    23.741    35.963     0.200
    23.784    35.752     0.200
    23.937    34.290     0.200
    24.298    33.940     0.200
    24.365    33.865     0.200
    24.447    33.180     0.200
    24.463    33.415     0.200
    26.290    28.190     0.200
    26.290    28.666     0.200
    26.691    27.421     0.200
    27.144    26.945     0.200
    28.155    25.409     0.200
    28.155    25.804     0.200
    28.305    23.216     0.200
    29.463    20.891     0.200
    16.122    40.205     0.200
    22.984    37.096     0.200
    29.939    20.554     0.200
    15.050    40.635     0.200
    15.354    40.554     0.200
    17.123    41.271     0.200
    21.717    38.329     0.200
    21.940    38.751     0.200
    22.999    36.629     0.200
    24.218    34.817     0.200
    27.289    26.037     0.200
    27.718    27.253     0.200
    15.151    40.445     0.200
    15.284    40.843     0.200
    15.659    40.120     0.200
    15.842    40.199     0.200
    16.049    40.222     0.200
    17.261    41.278     0.200
    18.081    41.510     0.200
    18.600    39.512     0.200
    20.665    39.252     0.200
    21.696    38.138     0.200
    22.040    37.797     0.200
    22.965    36.952     0.200
    23.252    36.819     0.200
    23.303    37.168     0.200
    24.398    36.954     0.200
    24.523    35.022     0.200
    27.351    27.114     0.200
    27.559    27.917     0.200
    29.898    19.193     0.200
    16.104    41.217     0.200
    21.771    37.488     0.200
    23.080    36.527     0.200
    26.313    31.399     0.200
    28.079    26.419     0.200
    23.015    37.246     0.200
    27.790    27.148     0.200
    14.932    39.990     0.200
    15.710    41.869     0.200
    15.805    41.688     0.200
    16.642    40.058     0.200
    22.913    37.359     0.200
    26.201    28.842     0.200
    28.292    25.783     0.200
    22.963    37.567     0.200
    16.005    40.183     0.200
    23.030    38.078     0.200
    14.350    39.675     0.200
    14.673    44.686     0.200
    14.886    39.942     0.200
    15.105    41.574     0.200
    15.185    41.498     0.200
    15.230    40.507     0.200
    15.249    41.318     0.200
    15.363    41.381     0.200
    15.448    41.166     0.200
    15.610    40.553     0.200
    15.610    40.655     0.200
    15.897    41.803     0.200
    16.006    40.849     0.200
    16.435    41.852     0.200
    16.553    43.859     0.200
    16.814    40.948     0.200
    17.280    41.866     0.200
    18.045    41.897     0.200
    20.618    39.411     0.200
    21.233    38.854     0.200
    21.335    41.215     0.200
    22.046    37.742     0.200
    22.558    38.667     0.200
    22.935    38.673     0.200
    22.935    37.770     0.200
    23.306    38.145     0.200
    24.120    35.740     0.200
    24.174    36.578     0.200
    24.244    36.450     0.200
    24.438    37.018     0.200
    24.519    35.483     0.200
    24.613    35.691     0.200
    24.870    33.832     0.200
    26.608    29.401     0.200
    26.608    28.378     0.200
    27.063    28.200     0.200
    27.345    27.195     0.200
    27.509    26.673     0.200
    28.780    23.563     0.200
    28.973    23.357     0.200
    29.249    22.081     0.200
    29.851    19.711     0.200
    15.220    40.448     0.200
    15.500    43.846     0.200
    16.553    41.798     0.200
    18.067    42.275     0.200
    18.588    40.808     0.200
    19.603    37.728     0.200
    20.653    39.307     0.200
    21.681    38.664     0.200
    21.761    38.429     0.200
    22.028    38.861     0.200
    22.256    38.202     0.200
    22.557    38.189     0.200
    22.950    36.795     0.200
    23.238    37.048     0.200
    23.290    37.228     0.200
    23.502    36.163     0.200
    24.146    34.346     0.200
    24.153    35.956     0.200
    24.237    35.229     0.200
    24.396    34.574     0.200
    24.601    34.331     0.200
    26.592    29.793     0.200
    27.551    26.451     0.200
    29.887    19.492     0.200
    14.795    45.097     0.200
    16.126    41.462     0.200
    21.074    38.478     0.200
    21.781    37.542     0.200
    23.091    36.299     0.200
    16.168    41.690     0.200
    21.110    38.963     0.200
    21.782    38.900     0.200
    23.097    35.633     0.200
    23.097    36.678     0.200
    16.258    40.516     0.200
    22.920    36.867     0.200
    23.119    36.401     0.200
    26.209    28.890     0.200
    20.966    38.473     0.200
    23.029    36.192     0.200
    24.407    34.649     0.200
    15.688    43.170     0.200
    18.097    40.781     0.200
    21.704    37.878     0.200
    22.976    36.453     0.200
    24.362    35.539     0.200
    27.342    27.052     0.200
    29.926    18.988     0.200
    15.635    40.705     0.200
    16.027    41.393     0.200
    21.679    38.904     0.200
    22.948    37.414     0.200
    27.344    27.611     0.200
    29.874    21.073     0.200
    16.104    41.778     0.200
    21.784    38.540     0.200
    23.092    36.025     0.200
    16.260    40.874     0.200
    28.265    24.650     0.200
    22.954    37.008     0.200
    15.528    41.362     0.200
    15.755    41.386     0.200
    16.339    43.595     0.200
    16.339    41.200     0.200
    16.519    42.250     0.200
    21.262    38.995     0.200
    21.827    39.531     0.200
    22.894    39.791     0.200
    23.155    38.845     0.200
    15.084    40.779     0.200
    16.358    40.631     0.200
    20.597    39.314     0.200
    21.695    39.047     0.200
    22.956    36.527     0.200
    29.826    19.698     0.200
    15.738    39.715     0.200
    16.316    40.457     0.200
    16.098    42.217     0.200
    16.271    39.440     0.200
    15.192    40.024     0.200
    15.622    40.081     0.200
    16.441    41.840     0.200
    18.627    39.747     0.200
    20.625    38.818     0.200
    21.653    38.404     0.200
    22.923    35.728     0.200
    27.317    26.945     0.200
    27.528    26.760     0.200
    29.859    19.497     0.200
    14.720    40.637     0.200
    14.758    41.533     0.200
    14.768    40.334     0.200
    14.787    41.740     0.200
    15.084    41.015     0.200
    15.086    40.781     0.200
    15.357    40.882     0.200
    15.579    41.439     0.200
    15.625    41.341     0.200
    15.662    41.987     0.200
    15.734    41.400     0.200
    15.795    42.011     0.200
    15.810    42.367     0.200
    16.341    42.159     0.200
    16.416    41.826     0.200
    16.515    41.614     0.200
    16.817    42.343     0.200
    16.860    42.316     0.200
    16.948    43.571     0.200
    17.505    42.587     0.200
    17.531    43.812     0.200
    17.538    42.036     0.200
    18.274    42.104     0.200
    18.470    40.928     0.200
    18.515    40.299     0.200
    18.537    40.594     0.200
    18.634    39.685     0.200
    18.696    40.708     0.200
    18.702    40.192     0.200
    18.713    41.138     0.200
    18.729    41.201     0.200
    19.022    40.651     0.200
    19.053    40.260     0.200
    19.185    40.805     0.200
    19.338    40.018     0.200
    19.420    41.136     0.200
    19.514    40.756     0.200
    19.639    40.920     0.200
    19.751    40.620     0.200
    20.047    40.617     0.200
    20.064    38.942     0.200
    20.145    39.155     0.200
    20.600    39.691     0.200
    20.664    39.151     0.200
    21.029    38.376     0.200
    21.360    39.227     0.200
    21.718    36.053     0.200
    21.740    38.147     0.200
    21.740    40.369     0.200
    21.763    37.498     0.200
    21.763    37.686     0.200
    21.787    38.046     0.200
    22.024    38.915     0.200
    22.459    36.900     0.200
    23.018    37.985     0.200
    23.027    35.598     0.200
    23.072    37.355     0.200
    23.072    36.152     0.200
    23.272    39.066     0.200
    23.814    35.795     0.200
    23.820    35.189     0.200
    24.023    37.648     0.200
    24.063    34.711     0.200
    24.305    36.357     0.200
    24.375    34.439     0.200
    24.404    34.901     0.200
    24.404    33.901     0.200
    26.310    30.156     0.200
    26.310    30.281     0.200
    26.718    28.900     0.200
    26.894    27.430     0.200
    27.149    27.593     0.200
    28.069    26.540     0.200
    28.327    23.087     0.200
    28.327    24.767     0.200
    28.362    20.689     0.200
    29.456    21.210     0.200
    16.113    40.261     0.200
    23.107    35.915     0.200
    14.105    42.665     0.200
    14.556    39.934     0.200
    14.568    40.619     0.200
    14.736    40.649     0.200
    15.405    40.091     0.200
    15.602    40.905     0.200
    15.869    41.332     0.200
    16.114    40.287     0.200
    18.633    39.427     0.200
    21.740    36.612     0.200
    21.767    38.112     0.200
    22.455    36.989     0.200
    23.005    35.933     0.200
    23.077    36.476     0.200
    24.416    33.789     0.200
    28.092    25.827     0.200
    28.092    24.100     0.200
    14.029    39.183     0.200
    14.377    39.404     0.200
    14.591    39.402     0.200
    14.679    39.541     0.200
    15.633    39.759     0.200
    15.633    40.048     0.200
    16.018    40.152     0.200
    16.018    40.961     0.200
    16.159    40.301     0.200
    16.198    39.483     0.200
    16.213    40.582     0.200
    16.336    39.636     0.200
    16.435    39.488     0.200
    16.453    41.742     0.200
    16.583    39.955     0.200
    16.589    40.192     0.200
    16.606    40.476     0.200
    16.768    40.016     0.200
    16.807    40.707     0.200
    16.839    39.606     0.200
    16.926    40.866     0.200
    17.025    40.774     0.200
    17.087    40.475     0.200
    17.097    40.399     0.200
    17.130    40.168     0.200
    17.240    40.408     0.200
    17.244    41.797     0.200
    17.286    40.017     0.200
    17.511    40.320     0.200
    17.548    39.816     0.200
    17.610    42.066     0.200
    17.921    41.296     0.200
    17.948    40.915     0.200
    18.049    41.034     0.200
    18.049    41.347     0.200
    18.276    41.680     0.200
    18.359    39.997     0.200
    20.637    38.838     0.200
    21.491    41.693     0.200
    21.663    38.396     0.200
    21.663    37.857     0.200
    22.243    37.650     0.200
    22.933    36.060     0.200
    24.128    35.482     0.200
    27.323    26.716     0.200
    27.539    27.872     0.200
    29.871    20.487     0.200
    16.009    42.963     0.200
    16.009    41.811     0.200
    21.722    37.979     0.200
    23.026    37.031     0.200
    15.631    41.664     0.200
    29.869    18.217     0.200
    16.176    39.298     0.200
    28.155    23.103     0.200
    15.467    42.232     0.200
    15.567    41.201     0.200
    15.694    45.569     0.200
    16.273    40.892     0.200
    17.018    42.251     0.200
    21.201    38.402     0.200
    21.928    38.559     0.200
    22.906    37.757     0.200
    22.941    37.638     0.200
    23.586    36.577     0.200
    24.282    35.304     0.200
    26.194    30.966     0.200
    28.277    25.911     0.200
    14.627    40.918     0.200
    14.719    40.728     0.200
    14.939    41.205     0.200
    15.265    40.166     0.200
    15.774    40.606     0.200
    15.771    41.278     0.200
    15.909    41.528     0.200
    16.260    41.162     0.200
    16.260    40.486     0.200
    16.409    42.128     0.200
    16.450    41.881     0.200
    16.491    41.987     0.200
    16.721    45.607     0.200
    17.482    43.480     0.200
    17.605    44.145     0.200
    17.725    43.244     0.200
    17.755    42.951     0.200
    21.187    39.053     0.200
    21.780    38.771     0.200
    22.248    39.581     0.200
    22.894    37.628     0.200
    22.928    37.324     0.200
    23.104    37.894     0.200
    24.492    33.521     0.200
    28.266    26.328     0.200
    15.634    40.544     0.200
    22.948    36.663     0.200
    27.535    26.543     0.200
    29.874    19.332     0.200
    22.951    36.675     0.200
    24.419    35.840     0.200
    29.875    18.698     0.200
    16.007    44.116     0.200
    23.021    37.937     0.200
    15.819    40.485     0.200
    16.837    40.730     0.200
    21.686    38.909     0.200
    21.777    39.744     0.200
    22.653    36.327     0.200
    22.952    36.491     0.200
    24.456    36.425     0.200
    27.506    26.999     0.200
    29.855    20.328     0.200
    15.979    43.242     0.200
    23.062    39.250     0.200
    14.599    40.424     0.200
    14.687    39.889     0.200
    15.274    40.460     0.200
    15.317    40.063     0.200
    15.498    41.090     0.200
    15.696    40.848     0.200
    15.770    41.251     0.200
    16.056    40.098     0.200
    16.056    40.945     0.200
    16.377    40.517     0.200
    18.248    41.426     0.200
    18.287    41.315     0.200
    20.970    38.791     0.200
    21.727    38.665     0.200
    21.728    38.655     0.200
    21.745    38.017     0.200
    22.453    38.195     0.200
    22.459    37.696     0.200
    23.024    37.529     0.200
    23.029    36.908     0.200
    23.051    35.339     0.200
    23.051    35.714     0.200
    23.825    36.051     0.200
    23.855    33.621     0.200
    23.893    34.025     0.200
    24.038    37.095     0.200
    24.062    36.337     0.200
    24.376    33.352     0.200
    24.417    33.457     0.200
    24.568    33.057     0.200
    27.149    26.668     0.200
    28.029    25.424     0.200
    14.194    39.852     0.200
    14.224    41.453     0.200
    14.265    40.194     0.200
    14.897    41.982     0.200
    15.049    42.092     0.200
    15.115    42.277     0.200
    15.196    41.285     0.200
    15.248    40.232     0.200
    15.262    41.163     0.200
    15.332    40.624     0.200
    15.555    41.260     0.200
    15.557    41.181     0.200
    15.575    40.044     0.200
    15.622    40.083     0.200
    15.810    40.268     0.200
    15.850    41.195     0.200
    15.881    42.038     0.200
    15.948    40.415     0.200
    16.093    40.784     0.200
    16.158    40.176     0.200
    16.225    40.221     0.200
    16.233    40.447     0.200
    16.445    42.428     0.200
    16.524    43.669     0.200
    16.604    42.412     0.200
    16.609    42.347     0.200
    16.623    41.209     0.200
    16.659    41.485     0.200
    16.687    40.896     0.200
    16.773    41.270     0.200
    16.818    42.245     0.200
    16.811    40.515     0.200
    16.881    43.308     0.200
    16.920    42.491     0.200
    16.933    41.570     0.200
    16.934    40.527     0.200
    16.983    41.014     0.200
    17.094    43.101     0.200
    17.132    41.635     0.200
    17.119    40.468     0.200
    17.249    41.788     0.200
    17.260    41.040     0.200
    17.271    40.781     0.200
    17.318    42.889     0.200
    17.476    41.280     0.200
    17.604    41.834     0.200
    17.621    41.456     0.200
    17.620    42.588     0.200
    17.765    42.842     0.200
    17.922    41.650     0.200
    18.052    41.798     0.200
    18.079    41.227     0.200
    18.364    41.364     0.200
    20.537    39.470     0.200
    20.893    39.473     0.200
    21.228    39.405     0.200
    21.327    40.635     0.200
    21.672    39.090     0.200
    21.672    38.481     0.200
    21.757    39.313     0.200
    22.040    36.493     0.200
    22.940    36.272     0.200
    22.940    36.616     0.200
    23.245    37.406     0.200
    23.300    37.483     0.200
    24.128    34.810     0.200
    24.167    36.436     0.200
    24.242    35.278     0.200
    24.242    35.512     0.200
    24.425    36.227     0.200
    24.516    35.496     0.200
    26.603    30.245     0.200
    27.056    27.713     0.200
    27.342    27.160     0.200
    27.522    27.420     0.200
    27.522    29.139     0.200
    29.862    20.209     0.200
    29.911    20.394     0.200
    14.816    40.134     0.200
    14.914    41.700     0.200
    15.133    41.903     0.200
    15.213    40.647     0.200
    15.266    44.379     0.200
    15.331    40.686     0.200
    15.638    40.778     0.200
    15.638    40.419     0.200
    15.638    41.004     0.200
    15.960    40.359     0.200
    16.034    43.048     0.200
    16.463    42.091     0.200
    16.828    40.835     0.200
    16.935    42.524     0.200
    16.953    41.898     0.200
    16.996    41.223     0.200
    17.113    45.163     0.200
    17.203    42.865     0.200
    17.268    42.566     0.200
    17.338    42.747     0.200
    17.624    41.692     0.200
    17.639    41.577     0.200
    17.639    42.327     0.200
    17.640    42.350     0.200
    17.784    43.460     0.200
    17.845    43.144     0.200
    17.941    43.379     0.200
    18.030    42.054     0.200
    18.099    41.281     0.200
    18.384    41.902     0.200
    20.646    39.630     0.200
    20.912    39.918     0.200
    21.691    38.208     0.200
    21.691    38.958     0.200
    22.959    36.740     0.200
    24.147    34.407     0.200
    24.179    35.431     0.200
    24.424    36.116     0.200
    27.535    27.586     0.200
    29.879    20.395     0.200
    29.931    20.552     0.200
    15.634    40.433     0.200
    16.121    40.490     0.200
    18.275    40.859     0.200
    21.070    38.819     0.200
    16.122    41.614     0.200
    14.030    39.360     0.200
    14.248    39.158     0.200
    14.395    39.562     0.200
    14.695    39.695     0.200
    14.920    42.984     0.200
    15.138    45.069     0.200
    15.260    40.362     0.200
    15.641    39.935     0.200
    15.641    40.545     0.200
    15.641    39.528     0.200
    15.926    40.285     0.200
    15.933    40.454     0.200
    16.042    39.807     0.200
    16.060    40.034     0.200
    16.266    40.276     0.200
    16.259    39.980     0.200
    16.468    42.035     0.200
    16.844    41.345     0.200
    16.876    40.648     0.200
    17.295    41.500     0.200
    17.514    41.619     0.200
    17.861    40.936     0.200
    17.951    40.180     0.200
    18.411    39.836     0.200
    18.638    39.651     0.200
    18.683    39.893     0.200
    21.260    38.896     0.200
    21.355    40.981     0.200
    21.704    39.128     0.200
    21.704    36.909     0.200
    21.791    39.502     0.200
    21.791    37.838     0.200
    22.070    39.437     0.200
    22.591    38.482     0.200
    22.660    37.674     0.200
    22.971    36.601     0.200
    22.971    36.761     0.200
    23.277    37.215     0.200
    23.331    36.640     0.200
    24.435    33.660     0.200
    24.548    34.772     0.200
    27.375    27.335     0.200
    27.535    26.573     0.200
    29.883    19.416     0.200
    29.883    19.412     0.200
    15.628    40.976     0.200
    21.711    38.360     0.200
    14.291    39.719     0.200
    14.653    41.209     0.200
    14.963    40.920     0.200
    15.694    40.348     0.200
    16.512    42.257     0.200
    17.230    41.884     0.200
    18.099    41.057     0.200
    21.216    39.639     0.200
    21.705    38.110     0.200
    21.777    39.226     0.200
    22.020    37.651     0.200
    22.567    37.735     0.200
    22.628    35.820     0.200
    22.977    36.525     0.200
    22.977    35.998     0.200
    23.239    35.717     0.200
    23.286    38.961     0.200
    23.898    34.425     0.200
    24.142    36.387     0.200
    24.181    33.718     0.200
    24.241    35.568     0.200
    24.356    35.354     0.200
    27.340    26.830     0.200
    27.599    26.986     0.200
    27.599    26.462     0.200
    29.233    19.377     0.200
    29.625    21.073     0.200
    29.931    19.775     0.200
    29.962    20.388     0.200
    14.953    43.911     0.200
    15.172    40.158     0.200
    15.305    41.319     0.200
    15.682    43.339     0.200
    17.241    41.008     0.200
    20.686    38.926     0.200
    21.777    38.369     0.200
    22.569    37.716     0.200
    22.974    35.995     0.200
    24.175    35.070     0.200
    24.370    35.798     0.200
    16.084    41.406     0.200
    16.839    41.316     0.200
    21.769    39.726     0.200
    23.077    38.549     0.200
    16.197    39.952     0.200
    16.416    40.404     0.200
    16.512    41.170     0.200
    16.375    43.015     0.200
    16.681    41.878     0.200
    21.583    38.512     0.200
    23.865    35.989     0.200
    26.830    29.501     0.200
    27.920    27.077     0.200
    14.763    42.027     0.200
    16.085    41.797     0.200
    16.461    40.936     0.200
    17.556    42.000     0.200
    17.794    41.350     0.200
    17.877    41.200     0.200
    18.009    42.747     0.200
    18.190    44.487     0.200
    18.309    42.130     0.200
    21.043    40.369     0.200
    21.040    39.722     0.200
    21.779    39.717     0.200
    21.779    39.288     0.200
    23.049    38.534     0.200
    15.219    40.351     0.200
    15.663    44.451     0.200
    16.026    41.037     0.200
    16.375    41.537     0.200
    16.437    41.505     0.200
    16.475    41.902     0.200
    16.624    41.287     0.200
    16.719    41.569     0.200
    16.856    41.313     0.200
    16.938    40.791     0.200
    16.953    40.825     0.200
    17.107    41.232     0.200
    17.189    41.716     0.200
    17.372    41.394     0.200
    17.567    41.307     0.200
    17.640    41.237     0.200
    17.791    41.463     0.200
    17.826    41.061     0.200
    17.944    41.052     0.200
    18.081    41.263     0.200
    18.081    41.584     0.200
    18.124    41.331     0.200
    18.253    41.753     0.200
    18.462    40.395     0.200
    18.491    40.995     0.200
    18.623    40.794     0.200
    18.646    40.197     0.200
    18.688    40.749     0.200
    18.695    40.851     0.200
    18.771    40.938     0.200
    18.981    40.486     0.200
    19.004    39.775     0.200
    19.085    39.751     0.200
    19.262    40.412     0.200
    19.459    39.970     0.200
    19.550    40.119     0.200
    19.550    40.752     0.200
    19.634    40.479     0.200
    19.998    39.019     0.200
    20.018    40.702     0.200
    20.106    39.695     0.200
    20.491    39.932     0.200
    20.581    39.463     0.200
    20.620    38.889     0.200
    20.935    39.169     0.200
    21.319    38.744     0.200
    21.421    39.214     0.200
    21.426    39.708     0.200
    21.660    38.956     0.200
    21.721    37.655     0.200
    21.721    38.299     0.200
    21.821    38.333     0.200
    21.821    39.120     0.200
    21.856    38.845     0.200
    22.135    38.307     0.200
    22.167    38.687     0.200
    22.216    38.518     0.200
    22.353    37.675     0.200
    22.559    38.567     0.200
    22.631    38.016     0.200
    22.709    37.767     0.200
    23.331    37.471     0.200
    23.392    37.737     0.200
    23.598    36.780     0.200
    23.929    35.202     0.200
    24.147    34.031     0.200
    24.147    34.431     0.200
    24.264    36.219     0.200
    24.324    34.745     0.200
    24.324    34.910     0.200
    24.514    35.543     0.200
    24.517    35.755     0.200
    24.601    34.328     0.200
    24.697    34.017     0.200
    24.958    33.250     0.200
    25.786    30.969     0.200
    26.098    30.027     0.200
    26.335    30.050     0.200
    26.696    28.311     0.200
    26.696    29.045     0.200
    26.845    28.264     0.200
    27.084    27.563     0.200
    27.201    27.488     0.200
    27.369    27.500     0.200
    27.369    27.853     0.200
    27.426    27.224     0.200
    27.478    26.502     0.200
    27.478    27.142     0.200
    27.585    25.186     0.200
    27.585    26.895     0.200
    28.721    23.900     0.200
    28.721    22.464     0.200
    28.888    22.960     0.200
    28.868    22.334     0.200
    29.335    21.989     0.200
    29.687    20.659     0.200
    29.755    19.841     0.200
    29.848    18.999     0.200
    29.848    18.223     0.200
    29.936    19.377     0.200
    14.212    40.371     0.200
    15.234    40.164     0.200
    15.590    40.351     0.200
    15.590    40.458     0.200
    15.843    40.645     0.200
    17.238    40.828     0.200
    17.277    40.959     0.200
    17.398    40.868     0.200
    17.799    41.046     0.200
    18.101    41.153     0.200
    18.132    42.999     0.200
    18.305    41.972     0.200
    20.613    39.556     0.200
    21.730    39.879     0.200
    22.159    40.025     0.200
    27.463    27.972     0.200
    14.313    40.782     0.200
    15.583    41.492     0.200
    21.727    38.864     0.200
    14.625    40.248     0.200
    15.048    40.116     0.200
    15.118    39.967     0.200
    15.615    40.654     0.200
    15.854    40.814     0.200
    15.667    43.930     0.200
    15.845    40.000     0.200
    16.058    40.590     0.200
    14.662    40.811     0.200
    14.728    40.049     0.200
    14.869    40.743     0.200
    14.893    39.389     0.200
    15.199    40.328     0.200
    15.497    40.174     0.200
    15.699    41.417     0.200
    15.791    42.048     0.200
    15.846    40.981     0.200
    15.933    41.493     0.200
    16.201    40.843     0.200
    16.416    40.763     0.200
    16.958    40.734     0.200
    17.068    44.672     0.200
    17.546    40.486     0.200
    18.008    40.471     0.200
    18.118    41.387     0.200
    18.161    41.170     0.200
    18.200    40.514     0.200
    18.234    40.550     0.200
    18.242    41.257     0.200
    18.329    40.950     0.200
    18.433    40.356     0.200
    18.538    38.708     0.200
    18.531    39.430     0.200
    18.581    40.072     0.200
    18.637    40.183     0.200
    18.732    40.316     0.200
    18.814    40.075     0.200
    18.969    39.497     0.200
    19.011    39.810     0.200
    19.049    39.952     0.200
    19.262    39.733     0.200
    19.381    38.768     0.200
    19.469    39.714     0.200
    19.544    39.727     0.200
    19.648    38.549     0.200
    19.675    40.046     0.200
    20.019    39.663     0.200
    20.019    39.845     0.200
    20.060    38.471     0.200
    20.096    38.995     0.200
    20.187    38.733     0.200
    20.244    38.999     0.200
    20.439    38.150     0.200
    20.519    38.505     0.200
    20.579    38.200     0.200
    20.639    38.811     0.200
    20.699    37.454     0.200
    20.870    38.503     0.200
    20.913    39.196     0.200
    20.998    38.083     0.200
    21.047    37.801     0.200
    21.058    37.919     0.200
    21.066    36.685     0.200
    21.374    37.930     0.200
    21.487    38.893     0.200
    21.503    36.798     0.200
    21.518    37.323     0.200
    21.573    37.406     0.200
    21.699    40.126     0.200
    21.743    37.781     0.200
    21.789    36.924     0.200
    22.001    37.336     0.200
    22.168    38.782     0.200
    22.431    36.778     0.200
    22.555    36.912     0.200
    23.107    35.846     0.200
    23.688    35.456     0.200
    23.923    34.285     0.200
    23.923    35.426     0.200
    26.252    28.977     0.200
    26.916    28.593     0.200
    28.191    23.766     0.200
    28.266    23.403     0.200
    28.392    24.348     0.200
    21.775    37.586     0.200
    23.086    34.547     0.200
    14.317    42.370     0.200
    14.963    42.652     0.200
    16.024    43.087     0.200
    16.255    41.553     0.200
    22.930    36.718     0.200
    15.004    41.682     0.200
    15.412    41.022     0.200
    14.557    40.379     0.200
    14.657    39.669     0.200
    14.662    40.904     0.200
    14.775    40.837     0.200
    15.109    42.175     0.200
    15.332    44.613     0.200
    15.557    41.849     0.200
    15.648    41.392     0.200
    16.063    40.199     0.200
    16.117    39.954     0.200
    16.117    41.215     0.200
    16.363    41.588     0.200
    16.440    41.060     0.200
    16.655    40.192     0.200
    16.883    42.267     0.200
    18.278    42.891     0.200
    21.067    39.033     0.200
    21.779    39.385     0.200
    23.020    38.391     0.200
    23.089    36.349     0.200
    23.802    36.313     0.200
    24.425    34.184     0.200
    24.562    36.309     0.200
    26.312    28.756     0.200
    28.093    25.551     0.200
    16.083    43.376     0.200
    14.219    41.106     0.200
    14.737    40.812     0.200
    15.011    40.825     0.200
    15.048    41.166     0.200
    15.571    41.591     0.200
    15.796    41.453     0.200
    16.073    41.923     0.200
    16.280    42.049     0.200
    16.280    41.373     0.200
    16.595    41.459     0.200
    16.921    41.971     0.200
    16.983    41.587     0.200
    17.026    42.113     0.200
    17.054    41.198     0.200
    17.096    43.525     0.200
    17.223    41.633     0.200
    17.399    41.909     0.200
    17.492    41.682     0.200
    17.578    41.891     0.200
    17.697    41.497     0.200
    17.749    41.413     0.200
    17.753    42.298     0.200
    18.021    41.394     0.200
    18.144    41.471     0.200
    18.161    42.075     0.200
    18.192    41.764     0.200
    18.257    41.536     0.200
    18.368    42.428     0.200
    18.373    41.523     0.200
    18.583    40.174     0.200
    18.612    40.749     0.200
    18.608    40.173     0.200
    18.637    40.540     0.200
    18.637    39.950     0.200
    18.697    40.096     0.200
    18.720    40.599     0.200
    18.767    40.839     0.200
    18.772    41.489     0.200
    18.779    41.043     0.200
    19.067    40.824     0.200
    19.185    40.984     0.200
    19.563    40.858     0.200
    19.564    40.333     0.200
    19.605    40.077     0.200
    19.624    40.211     0.200
    19.654    40.422     0.200
    19.849    40.070     0.200
    19.935    40.629     0.200
    19.954    40.243     0.200
    20.028    40.414     0.200
    20.103    38.717     0.200
    20.117    39.628     0.200
    20.158    40.441     0.200
    20.217    40.947     0.200
    20.236    40.132     0.200
    20.282    39.722     0.200
    20.369    40.034     0.200
    20.389    40.706     0.200
    20.539    39.881     0.200
    20.721    40.722     0.200
    20.764    40.879     0.200
    21.020    41.061     0.200
    21.018    40.628     0.200
    21.056    40.826     0.200
    21.071    41.610     0.200
    21.091    41.199     0.200
    21.170    40.727     0.200
    21.209    38.795     0.200
    21.286    39.159     0.200
    21.360    38.959     0.200
    21.386    39.730     0.200
    21.487    40.444     0.200
    21.502    40.618     0.200
    21.511    41.206     0.200
    21.537    39.631     0.200
    21.601    39.315     0.200
    21.635    40.842     0.200
    21.743    39.794     0.200
    21.743    41.173     0.200
    21.807    39.760     0.200
    21.807    38.932     0.200
    21.914    37.854     0.200
    21.928    38.775     0.200
    22.145    38.423     0.200
    22.430    38.490     0.200
    22.464    36.948     0.200
    22.545    37.069     0.200
    22.563    36.913     0.200
    22.952    36.922     0.200
    23.188    37.823     0.200
    23.589    37.047     0.200
    24.293    36.699     0.200
    24.518    32.568     0.200
    26.085    32.722     0.200
    26.205    29.448     0.200
    27.082    27.759     0.200
    28.218    24.176     0.200
    28.281    26.264     0.200
    29.432    21.437     0.200
    29.738    20.558     0.200
    14.298    40.037     0.200
    14.611    39.851     0.200
    14.624    40.388     0.200
    14.704    39.636     0.200
    14.830    40.869     0.200
    14.833    39.832     0.200
    15.142    39.955     0.200
    15.162    39.887     0.200
    15.157    40.245     0.200
    15.379    40.250     0.200
    15.437    41.212     0.200
    15.605    41.628     0.200
    15.659    41.554     0.200
    15.696    41.077     0.200
    15.811    40.542     0.200
    15.866    41.009     0.200
    15.890    42.186     0.200
    15.925    41.045     0.200
    15.949    40.958     0.200
    16.168    40.244     0.200
    16.168    41.072     0.200
    16.383    41.665     0.200
    16.403    41.507     0.200
    16.493    40.929     0.200
    16.504    40.299     0.200
    16.930    42.137     0.200
    17.027    44.372     0.200
    17.546    40.283     0.200
    18.240    41.085     0.200
    18.258    42.299     0.200
    18.325    40.675     0.200
    18.325    41.862     0.200
    18.639    40.124     0.200
    18.842    40.109     0.200
    19.336    39.744     0.200
    19.419    39.336     0.200
    19.468    39.800     0.200
    19.725    37.533     0.200
    19.771    39.130     0.200
    19.795    39.613     0.200
    19.895    38.869     0.200
    20.019    38.579     0.200
    20.033    39.074     0.200
    20.103    39.167     0.200
    20.111    38.896     0.200
    20.165    38.125     0.200
    20.248    39.475     0.200
    20.323    38.668     0.200
    20.400    38.684     0.200
    20.527    38.667     0.200
    20.643    39.397     0.200
    20.647    38.169     0.200
    20.704    39.060     0.200
    21.005    38.896     0.200
    21.029    38.549     0.200
    21.061    38.567     0.200
    21.070    38.730     0.200
    21.114    38.501     0.200
    21.115    38.786     0.200
    21.384    37.989     0.200
    21.387    38.673     0.200
    21.516    38.321     0.200
    21.526    37.638     0.200
    21.649    36.704     0.200
    21.799    37.593     0.200
    21.799    38.258     0.200
    21.900    37.291     0.200
    21.921    37.467     0.200
    22.156    36.473     0.200
    22.419    36.019     0.200
    22.454    36.688     0.200
    22.569    36.186     0.200
    23.023    38.011     0.200
    23.112    35.313     0.200
    23.112    36.508     0.200
    24.461    33.895     0.200
    24.543    35.947     0.200
    26.295    29.748     0.200
    28.149    24.966     0.200
    28.149    26.685     0.200
    15.938    39.753     0.200
    27.936    25.204     0.200
    15.942    42.422     0.200
    15.942    42.148     0.200
    16.783    41.747     0.200
    19.627    39.425     0.200
    21.484    37.037     0.200
    21.614    38.175     0.200
    22.919    36.531     0.200
    23.873    35.317     0.200
    24.292    34.124     0.200
    24.485    31.889     0.200
    27.932    24.271     0.200
    14.849    40.751     0.200
    17.025    41.209     0.200
    21.662    38.028     0.200
    16.218    40.175     0.200
    15.046    45.074     0.200
    15.964    43.790     0.200
    14.259    39.088     0.200
    14.577    39.421     0.200
    14.547    40.129     0.200
    14.681    40.029     0.200
    14.746    39.349     0.200
    14.882    40.501     0.200
    15.493    40.688     0.200
    15.712    40.389     0.200
    15.680    40.568     0.200
    15.803    42.560     0.200
    15.861    40.553     0.200
    15.945    41.334     0.200
    16.001    40.834     0.200
    16.216    40.891     0.200
    16.216    40.544     0.200
    16.437    41.138     0.200
    16.496    40.423     0.200
    16.545    40.534     0.200
    16.652    41.302     0.200
    16.973    41.680     0.200
    16.977    40.361     0.200
    17.019    40.353     0.200
    17.081    42.474     0.200
    17.434    41.375     0.200
    17.674    43.587     0.200
    17.630    41.949     0.200
    17.693    40.965     0.200
    17.830    40.339     0.200
    17.985    41.294     0.200
    18.064    41.932     0.200
    18.219    40.446     0.200
    18.227    41.180     0.200
    18.270    40.592     0.200
    18.348    41.215     0.200
    18.348    42.043     0.200
    18.382    40.655     0.200
    18.424    39.550     0.200
    18.422    38.858     0.200
    18.445    39.581     0.200
    18.453    39.711     0.200
    18.466    38.796     0.200
    18.550    39.523     0.200
    18.615    38.796     0.200
    18.657    39.981     0.200
    18.671    39.603     0.200
    18.752    39.220     0.200
    18.772    40.113     0.200
    18.778    39.325     0.200
    18.782    39.601     0.200
    18.833    38.918     0.200
    18.824    36.945     0.200
    18.838    39.615     0.200
    18.836    38.497     0.200
    18.878    39.062     0.200
    18.881    39.784     0.200
    18.914    40.041     0.200
    18.935    39.788     0.200
    18.944    39.428     0.200
    18.980    39.844     0.200
    19.030    39.199     0.200
    19.022    38.852     0.200
    19.068    39.877     0.200
    19.103    39.391     0.200
    19.103    39.271     0.200
    19.116    39.786     0.200
    19.134    39.092     0.200
    19.313    40.099     0.200
    19.349    39.898     0.200
    19.342    39.721     0.200
    19.454    39.352     0.200
    19.461    39.387     0.200
    19.482    38.132     0.200
    19.509    38.827     0.200
    19.521    39.354     0.200
    19.576    39.655     0.200
    19.597    39.933     0.200
    19.609    38.000     0.200
    19.629    38.456     0.200
    19.643    38.489     0.200
    19.648    39.267     0.200
    19.667    38.342     0.200
    19.692    38.731     0.200
    19.704    37.881     0.200
    19.709    38.339     0.200
    19.732    38.857     0.200
    19.763    38.908     0.200
    19.836    38.106     0.200
    19.884    38.780     0.200
    19.891    38.857     0.200
    19.897    38.291     0.200
    19.940    38.655     0.200
    19.976    39.110     0.200
    19.988    38.237     0.200
    20.001    36.603     0.200
    20.039    38.144     0.200
    20.017    36.902     0.200
    20.050    38.360     0.200
    20.050    39.680     0.200
    20.067    38.649     0.200
    20.080    39.155     0.200
    20.076    37.041     0.200
    20.080    38.584     0.200
    20.105    38.962     0.200
    20.090    39.380     0.200
    20.107    38.438     0.200
    20.148    39.128     0.200
    20.196    38.023     0.200
    20.189    39.009     0.200
    20.241    38.122     0.200
    20.255    38.007     0.200
    20.315    38.148     0.200
    20.395    38.569     0.200
    20.393    38.671     0.200
    20.423    38.136     0.200
    20.421    38.104     0.200
    20.431    38.269     0.200
    20.428    38.293     0.200
    20.459    35.744     0.200
    20.451    36.423     0.200
    20.539    38.235     0.200
    20.598    38.400     0.200
    20.601    36.588     0.200
    20.602    37.341     0.200
    20.627    38.154     0.200
    20.634    38.794     0.200
    20.640    38.041     0.200
    20.665    36.797     0.200
    20.738    37.670     0.200
    20.748    37.114     0.200
    20.762    37.590     0.200
    20.761    37.876     0.200
    20.812    37.643     0.200
    20.798    36.789     0.200
    20.843    38.144     0.200
    20.861    37.922     0.200
    20.864    37.982     0.200
    20.882    38.553     0.200
    20.903    36.152     0.200
    20.912    38.934     0.200
    20.922    37.515     0.200
    20.921    38.831     0.200
    20.929    39.468     0.200
    20.971    36.369     0.200
    21.018    37.336     0.200
    21.032    37.975     0.200
    21.016    37.712     0.200
    21.067    35.580     0.200
    21.058    36.913     0.200
    21.078    35.595     0.200
    21.073    36.837     0.200
    21.073    38.050     0.200
    21.082    39.065     0.200
    21.110    38.100     0.200
    21.162    38.244     0.200
    21.159    37.424     0.200
    21.164    36.550     0.200
    21.188    37.500     0.200
    21.198    39.409     0.200
    21.236    39.970     0.200
    21.263    38.471     0.200
    21.246    38.206     0.200
    21.290    37.509     0.200
    21.299    37.260     0.200
    21.336    39.694     0.200
    21.340    37.627     0.200
    21.332    37.909     0.200
    21.339    38.455     0.200
    21.382    38.811     0.200
    21.394    38.904     0.200
    21.412    38.669     0.200
    21.428    38.398     0.200
    21.442    38.691     0.200
    21.477    38.340     0.200
    21.494    38.139     0.200
    21.506    39.127     0.200
    21.512    38.810     0.200
    21.522    37.081     0.200
    21.513    38.288     0.200
    21.537    36.229     0.200
    21.574    37.800     0.200
    21.630    38.246     0.200
    21.629    36.918     0.200
    21.651    37.819     0.200
    21.667    37.406     0.200
    21.667    39.136     0.200
    21.682    36.494     0.200
    21.758    36.637     0.200
    21.762    38.310     0.200
    21.762    39.771     0.200
    21.759    36.316     0.200
    21.774    37.435     0.200
    21.779    37.331     0.200
    21.809    37.626     0.200
    21.809    38.396     0.200
    21.804    37.111     0.200
    21.828    37.306     0.200
    21.849    37.752     0.200
    21.892    36.644     0.200
    21.879    35.409     0.200
    21.913    37.073     0.200
    21.932    35.610     0.200
    21.961    37.524     0.200
    21.961    37.304     0.200
    21.973    35.791     0.200
    21.993    38.261     0.200
    22.006    36.412     0.200
    22.021    37.057     0.200
    22.047    36.620     0.200
    22.075    37.168     0.200
    22.067    36.803     0.200
    22.077    36.610     0.200
    22.118    38.572     0.200
    22.116    37.134     0.200
    22.159    37.800     0.200
    22.143    37.427     0.200
    22.170    36.902     0.200
    22.233    37.357     0.200
    22.302    36.762     0.200
    22.318    34.888     0.200
    22.325    36.806     0.200
    22.321    36.968     0.200
    22.345    35.579     0.200
    22.347    35.978     0.200
    22.371    33.754     0.200
    22.426    36.191     0.200
    22.449    35.893     0.200
    22.449    37.389     0.200
    22.465    35.067     0.200
    22.463    35.658     0.200
    22.463    37.549     0.200
    22.467    35.139     0.200
    22.491    36.516     0.200
    22.511    36.459     0.200
    22.509    34.936     0.200
    22.549    35.364     0.200
    22.574    37.074     0.200
    22.572    35.505     0.200
    22.576    34.597     0.200
    22.632    34.943     0.200
    22.685    32.103     0.200
    22.689    36.524     0.200
    22.706    37.312     0.200
    22.723    36.620     0.200
    22.724    36.080     0.200
    22.733    36.843     0.200
    22.760    37.870     0.200
    22.800    34.303     0.200
    22.809    35.366     0.200
    22.844    35.955     0.200
    22.918    35.403     0.200
    22.956    37.754     0.200
    22.948    36.474     0.200
    22.974    34.517     0.200
    22.985    36.302     0.200
    22.976    33.704     0.200
    22.977    36.089     0.200
    22.977    37.749     0.200
    22.982    35.430     0.200
    22.980    35.921     0.200
    23.002    37.140     0.200
    23.020    35.555     0.200
    23.042    35.155     0.200
    23.085    34.839     0.200
    23.127    36.076     0.200
    23.127    36.701     0.200
    23.138    35.092     0.200
    23.153    35.851     0.200
    23.174    35.599     0.200
    23.206    34.959     0.200
    23.219    36.197     0.200
    23.242    37.935     0.200
    23.237    35.410     0.200
    23.255    34.274     0.200
    23.259    36.014     0.200
    23.282    33.563     0.200
    23.314    31.774     0.200
    23.363    34.404     0.200
    23.375    34.376     0.200
    23.391    35.069     0.200
    23.402    35.449     0.200
    23.415    34.653     0.200
    23.433    35.348     0.200
    23.426    35.965     0.200
    23.499    35.060     0.200
    23.551    35.601     0.200
    23.544    35.849     0.200
    23.571    35.572     0.200
    23.602    35.860     0.200
    23.617    35.385     0.200
    23.621    35.281     0.200
    23.696    34.381     0.200
    23.695    35.193     0.200
    23.718    35.743     0.200
    23.688    35.393     0.200
    23.755    35.502     0.200
    23.755    36.323     0.200
    23.772    34.531     0.200
    23.785    35.264     0.200
    23.805    34.001     0.200
    23.826    33.101     0.200
    23.945    33.288     0.200
    23.973    32.591     0.200
    24.032    32.752     0.200
    24.047    33.521     0.200
    24.047    36.822     0.200
    24.130    33.531     0.200
    24.170    30.942     0.200
    24.177    32.864     0.200
    24.176    32.088     0.200
    24.212    30.500     0.200
    24.282    36.220     0.200
    24.313    31.278     0.200
    24.324    30.310     0.200
    24.346    31.981     0.200
    24.346    36.567     0.200
    24.420    32.160     0.200
    24.489    33.697     0.200
    24.482    32.500     0.200
    24.491    31.009     0.200
    24.514    34.191     0.200
    24.617    31.533     0.200
    24.632    30.868     0.200
    24.657    30.453     0.200
    24.694    30.590     0.200
    24.736    30.587     0.200
    24.773    32.101     0.200
    25.197    30.670     0.200
    25.209    29.158     0.200
    25.662    31.175     0.200
    26.184    31.964     0.200
    26.267    29.480     0.200
    26.267    29.355     0.200
    26.441    29.381     0.200
    26.663    28.135     0.200
    26.980    28.357     0.200
    27.129    26.188     0.200
    27.129    27.809     0.200
    27.142    27.866     0.200
    27.587    26.358     0.200
    28.204    25.922     0.200
    28.281    22.842     0.200
    28.281    24.303     0.200
    28.406    23.886     0.200
    28.950    18.787     0.200
    28.950    22.740     0.200
    29.435    20.449     0.200
    29.435    21.875     0.200
    29.478    22.934     0.200
    29.540    21.483     0.200
    29.782    20.051     0.200
    18.301    40.275     0.200
    23.384    38.328     0.200
    18.941    37.860     0.200
    14.541    40.048     0.200
    14.699    41.035     0.200
    15.094    40.757     0.200
    15.362    41.400     0.200
    15.551    42.176     0.200
    15.745    40.938     0.200
    15.815    42.294     0.200
    16.106    41.226     0.200
    16.106    40.630     0.200
    16.877    41.869     0.200
    16.851    40.849     0.200
    17.540    40.844     0.200
    18.139    41.509     0.200
    18.170    41.398     0.200
    18.302    42.196     0.200
    18.302    41.454     0.200
    18.314    41.302     0.200
    18.482    40.108     0.200
    18.478    39.626     0.200
    18.503    39.988     0.200
    18.519    39.587     0.200
    18.556    39.543     0.200
    18.601    38.226     0.200
    18.669    39.687     0.200
    18.685    40.366     0.200
    18.813    39.988     0.200
    18.827    40.274     0.200
    18.837    40.512     0.200
    18.880    40.388     0.200
    18.926    39.876     0.200
    18.926    40.570     0.200
    18.977    40.448     0.200
    18.993    40.514     0.200
    19.009    40.264     0.200
    19.019    40.562     0.200
    19.118    40.409     0.200
    19.114    39.937     0.200
    19.177    40.493     0.200
    19.191    40.320     0.200
    19.312    40.389     0.200
    19.382    40.358     0.200
    19.386    40.342     0.200
    19.464    40.290     0.200
    19.535    40.098     0.200
    19.533    40.284     0.200
    19.596    40.457     0.200
    19.662    40.385     0.200
    19.685    40.489     0.200
    19.692    40.494     0.200
    19.766    39.425     0.200
    19.766    40.417     0.200
    19.767    39.535     0.200
    19.795    39.386     0.200
    19.801    39.753     0.200
    19.913    39.555     0.200
    19.922    39.667     0.200
    19.924    39.634     0.200
    19.967    39.754     0.200
    20.024    39.461     0.200
    20.022    39.536     0.200
    20.055    39.844     0.200
    20.058    39.189     0.200
    20.073    39.954     0.200
    20.084    40.301     0.200
    20.132    39.511     0.200
    20.155    40.180     0.200
    20.189    40.376     0.200
    20.193    40.240     0.200
    20.210    40.139     0.200
    20.239    39.265     0.200
    20.266    39.106     0.200
    20.284    39.771     0.200
    20.316    39.097     0.200
    20.348    39.409     0.200
    20.419    39.015     0.200
    20.441    39.639     0.200
    20.455    39.261     0.200
    20.481    39.067     0.200
    20.499    38.464     0.200
    20.499    39.414     0.200
    20.512    39.557     0.200
    20.519    39.710     0.200
    20.539    39.771     0.200
    20.604    39.393     0.200
    20.667    39.054     0.200
    20.670    38.983     0.200
    20.686    38.612     0.200
    20.692    39.053     0.200
    20.747    38.880     0.200
    20.763    38.859     0.200
    20.831    38.667     0.200
    20.829    39.069     0.200
    20.841    38.715     0.200
    20.863    39.393     0.200
    20.905    38.310     0.200
    20.906    38.797     0.200
    20.903    39.954     0.200
    20.959    39.885     0.200
    20.976    39.300     0.200
    20.983    39.214     0.200
    20.983    41.080     0.200
    21.006    38.757     0.200
    21.002    38.962     0.200
    21.012    39.637     0.200
    21.020    39.419     0.200
    21.037    38.759     0.200
    21.066    39.124     0.200
    21.114    38.915     0.200
    21.107    38.559     0.200
    21.136    38.419     0.200
    21.145    38.448     0.200
    21.147    40.448     0.200
    21.199    38.859     0.200
    21.215    38.701     0.200
    21.218    38.355     0.200
    21.294    38.116     0.200
    21.355    38.307     0.200
    21.368    37.846     0.200
    21.370    38.111     0.200
    21.387    39.302     0.200
    21.399    39.301     0.200
    21.437    38.227     0.200
    21.496    39.322     0.200
    21.518    38.890     0.200
    21.534    38.210     0.200
    21.530    38.721     0.200
    21.577    38.263     0.200
    21.658    38.187     0.200
    21.658    41.054     0.200
    21.658    37.542     0.200
    21.666    38.904     0.200
    21.701    37.900     0.200
    21.754    38.328     0.200
    21.754    39.423     0.200
    21.776    37.987     0.200
    21.776    41.284     0.200
    21.770    37.516     0.200
    21.796    37.932     0.200
    21.796    38.419     0.200
    21.801    37.762     0.200
    21.807    37.862     0.200
    21.830    37.483     0.200
    21.846    37.729     0.200
    21.836    37.530     0.200
    21.863    37.461     0.200
    21.885    37.472     0.200
    21.933    37.902     0.200
    21.986    38.601     0.200
    21.984    37.672     0.200
    22.020    37.584     0.200
    22.020    37.291     0.200
    22.029    37.695     0.200
    22.045    37.264     0.200
    22.061    39.057     0.200
    22.130    37.696     0.200
    22.127    37.761     0.200
    22.163    37.301     0.200
    22.165    37.437     0.200
    22.168    37.766     0.200
    22.211    37.624     0.200
    22.235    37.351     0.200
    22.234    37.167     0.200
    22.310    37.943     0.200
    22.332    37.482     0.200
    22.353    36.919     0.200
    22.382    37.318     0.200
    22.389    37.294     0.200
    22.421    37.176     0.200
    22.450    37.930     0.200
    22.434    37.603     0.200
    22.487    37.199     0.200
    22.496    37.562     0.200
    22.496    37.409     0.200
    22.499    36.926     0.200
    22.499    37.737     0.200
    22.539    36.810     0.200
    22.559    36.257     0.200
    22.575    36.368     0.200
    22.575    35.837     0.200
    22.602    37.071     0.200
    22.595    37.221     0.200
    22.612    36.723     0.200
    22.612    37.676     0.200
    22.610    37.122     0.200
    22.679    36.477     0.200
    22.691    37.125     0.200
    22.700    36.344     0.200
    22.762    36.857     0.200
    22.781    36.376     0.200
    22.783    36.804     0.200
    22.814    36.710     0.200
    22.813    36.910     0.200
    22.826    36.658     0.200
    22.821    36.995     0.200
    22.821    38.684     0.200
    22.844    38.042     0.200
    22.865    36.425     0.200
    22.948    38.630     0.200
    22.939    36.592     0.200
    22.963    34.891     0.200
    23.027    36.605     0.200
    23.042    36.333     0.200
    23.035    36.052     0.200
    23.044    35.709     0.200
    23.049    35.985     0.200
    23.055    36.379     0.200
    23.055    37.477     0.200
    23.065    38.011     0.200
    23.083    36.065     0.200
    23.077    35.778     0.200
    23.071    35.562     0.200
    23.103    35.171     0.200
    23.165    36.062     0.200
    23.165    37.419     0.200
    23.214    36.027     0.200
    23.214    37.279     0.200
    23.236    36.193     0.200
    23.243    36.261     0.200
    23.269    36.083     0.200
    23.299    36.741     0.200
    23.299    36.503     0.200
    23.299    38.936     0.200
    23.322    36.513     0.200
    23.337    36.813     0.200
    23.353    36.621     0.200
    23.408    35.826     0.200
    23.413    35.775     0.200
    23.411    35.433     0.200
    23.434    35.571     0.200
    23.434    36.714     0.200
    23.457    35.748     0.200
    23.459    35.857     0.200
    23.459    37.815     0.200
    23.502    35.598     0.200
    23.522    35.645     0.200
    23.604    35.677     0.200
    23.617    35.513     0.200
    23.634    35.451     0.200
    23.675    35.660     0.200
    23.675    38.214     0.200
    23.708    34.915     0.200
    23.708    35.250     0.200
    23.708    35.862     0.200
    23.747    35.054     0.200
    23.747    36.777     0.200
    23.767    34.761     0.200
    23.765    35.008     0.200
    23.779    35.180     0.200
    23.850    34.793     0.200
    23.850    36.611     0.200
    23.866    35.200     0.200
    23.866    36.572     0.200
    23.872    35.031     0.200
    23.884    35.098     0.200
    23.914    34.627     0.200
    23.914    35.390     0.200
    23.908    35.725     0.200
    23.948    33.934     0.200
    23.993    33.879     0.200
    24.066    34.372     0.200
    24.070    34.791     0.200
    24.100    36.839     0.200
    24.108    34.566     0.200
    24.141    34.569     0.200
    24.225    35.732     0.200
    24.224    32.951     0.200
    24.236    32.811     0.200
    24.250    32.921     0.200
    24.266    32.836     0.200
    24.267    33.457     0.200
    24.299    33.485     0.200
    24.331    35.544     0.200
    24.327    32.581     0.200
    24.343    35.777     0.200
    24.387    32.673     0.200
    24.430    34.898     0.200
    24.413    32.869     0.200
    24.413    33.292     0.200
    24.463    34.509     0.200
    24.470    32.697     0.200
    24.552    31.754     0.200
    24.568    32.192     0.200
    24.597    34.555     0.200
    24.613    32.143     0.200
    24.662    32.478     0.200
    24.720    31.795     0.200
    24.714    33.059     0.200
    24.729    32.291     0.200
    24.721    31.976     0.200
    24.726    32.852     0.200
    24.826    32.653     0.200
    24.859    32.006     0.200
    24.938    32.422     0.200
    25.058    32.320     0.200
    25.105    32.406     0.200
    25.237    32.119     0.200
    25.261    31.861     0.200
    25.268    31.593     0.200
    25.283    32.007     0.200
    25.296    31.019     0.200
    25.306    31.829     0.200
    25.343    30.947     0.200
    25.382    31.973     0.200
    25.507    30.477     0.200
    25.744    31.737     0.200
    25.797    30.669     0.200
    25.797    31.206     0.200
    25.797    30.710     0.200
    25.797    31.359     0.200
    25.875    30.130     0.200
    25.875    30.829     0.200
    25.987    29.645     0.200
    26.215    29.406     0.200
    26.215    30.258     0.200
    26.298    28.150     0.200
    26.347    30.262     0.200
    26.375    29.035     0.200
    26.491    28.698     0.200
    26.488    28.635     0.200
    26.517    28.669     0.200
    26.613    28.478     0.200
    26.638    27.143     0.200
    26.691    27.903     0.200
    26.754    27.856     0.200
    26.793    27.598     0.200
    26.865    27.895     0.200
    26.974    26.422     0.200
    27.030    26.950     0.200
    27.064    28.865     0.200
    27.097    26.600     0.200
    27.131    25.954     0.200
    27.130    26.285     0.200
    27.153    26.557     0.200
    27.186    26.316     0.200
    27.186    26.852     0.200
    27.294    26.283     0.200
    27.303    25.295     0.200
    27.354    26.483     0.200
    27.686    24.849     0.200
    27.784    24.986     0.200
    27.883    24.673     0.200
    28.074    26.139     0.200
    28.074    25.323     0.200
    28.181    22.641     0.200
    28.364    22.660     0.200
    29.023    22.047     0.200
    29.532    19.194     0.200
    29.670    19.657     0.200
    29.834    19.448     0.200
    14.464    40.972     0.200
    14.545    40.466     0.200
    14.652    41.075     0.200
    14.689    40.537     0.200
    14.740    43.171     0.200
    15.366    41.476     0.200
    15.552    44.684     0.200
    15.590    42.057     0.200
    15.671    40.698     0.200
    15.748    41.405     0.200
    15.819    42.270     0.200
    16.108    40.904     0.200
    16.108    41.279     0.200
    16.363    42.409     0.200
    16.428    41.143     0.200
    16.522    44.840     0.200
    16.840    41.279     0.200
    16.878    42.408     0.200
    16.958    45.181     0.200
    17.529    41.803     0.200
    18.159    41.290     0.200
    18.304    41.195     0.200
    18.473    39.838     0.200
    18.509    40.327     0.200
    18.546    39.832     0.200
    18.595    39.477     0.200
    18.662    39.947     0.200
    18.675    39.721     0.200
    18.744    40.407     0.200
    18.827    40.116     0.200
    18.849    40.554     0.200
    18.871    40.103     0.200
    18.916    39.852     0.200
    18.925    40.608     0.200
    18.967    39.768     0.200
    18.971    40.774     0.200
    18.983    39.960     0.200
    19.009    39.175     0.200
    19.104    39.447     0.200
    19.109    40.099     0.200
    19.167    39.683     0.200
    19.373    39.309     0.200
    19.377    39.737     0.200
    19.387    40.778     0.200
    19.415    40.757     0.200
    19.454    39.580     0.200
    19.523    39.382     0.200
    19.527    39.852     0.200
    19.557    39.498     0.200
    19.682    40.333     0.200
    19.757    39.923     0.200
    19.757    40.650     0.200
    19.757    39.430     0.200
    19.787    39.753     0.200
    19.791    39.410     0.200
    19.905    39.594     0.200
    19.913    40.562     0.200
    19.958    39.508     0.200
    20.045    39.211     0.200
    20.049    39.542     0.200
    20.124    39.240     0.200
    20.145    38.845     0.200
    20.169    39.166     0.200
    20.179    39.551     0.200
    20.192    39.345     0.200
    20.192    40.270     0.200
    20.230    40.250     0.200
    20.259    39.486     0.200
    20.274    40.209     0.200
    20.307    38.945     0.200
    20.340    40.030     0.200
    20.412    38.740     0.200
    20.433    39.863     0.200
    20.446    37.957     0.200
    20.472    38.842     0.200
    20.489    38.980     0.200
    20.489    39.701     0.200
    20.502    39.324     0.200
    20.510    40.103     0.200
    20.529    39.461     0.200
    20.658    39.727     0.200
    20.662    40.317     0.200
    20.683    39.427     0.200
    20.756    39.428     0.200
    20.819    38.377     0.200
    20.824    39.522     0.200
    20.852    39.548     0.200
    20.893    38.891     0.200
    20.897    38.572     0.200
    20.897    38.850     0.200
    20.948    39.465     0.200
    20.967    39.289     0.200
    20.973    38.270     0.200
    20.992    39.250     0.200
    20.998    38.626     0.200
    21.009    38.366     0.200
    21.030    39.623     0.200
    21.059    38.701     0.200
    21.096    38.041     0.200
    21.106    38.511     0.200
    21.129    38.626     0.200
    21.135    38.053     0.200
    21.138    40.433     0.200
    21.192    38.283     0.200
    21.206    38.396     0.200
    21.209    38.361     0.200
    21.286    38.195     0.200
    21.358    38.416     0.200
    21.378    38.493     0.200
    21.378    38.999     0.200
    21.427    38.294     0.200
    21.487    38.810     0.200
    21.487    39.353     0.200
    21.519    39.508     0.200
    21.522    38.597     0.200
    21.522    38.814     0.200
    21.527    39.056     0.200
    21.567    39.164     0.200
    21.650    37.829     0.200
    21.652    38.233     0.200
    21.652    41.057     0.200
    21.656    38.981     0.200
    21.691    37.559     0.200
    21.744    36.891     0.200
    21.744    39.356     0.200
    21.760    37.062     0.200
    21.769    38.201     0.200
    21.769    39.591     0.200
    21.790    38.444     0.200
    21.790    39.078     0.200
    21.792    38.307     0.200
    21.799    37.452     0.200
    21.826    37.770     0.200
    21.854    37.980     0.200
    21.923    37.670     0.200
    21.973    37.780     0.200
    21.973    40.187     0.200
    21.979    36.985     0.200
    21.979    42.173     0.200
    22.011    37.330     0.200
    22.019    36.894     0.200
    22.036    37.306     0.200
    22.051    38.443     0.200
    22.155    39.814     0.200
    22.157    36.896     0.200
    22.200    37.362     0.200
    22.224    37.376     0.200
    22.225    36.589     0.200
    22.324    37.027     0.200
    22.334    37.414     0.200
    22.372    37.232     0.200
    22.415    36.864     0.200
    22.424    37.057     0.200
    22.445    37.861     0.200
    22.480    37.013     0.200
    22.488    37.873     0.200
    22.488    39.018     0.200
    22.490    36.843     0.200
    22.490    37.155     0.200
    22.533    37.663     0.200
    22.550    37.036     0.200
    22.568    37.925     0.200
    22.585    37.345     0.200
    22.594    37.584     0.200
    22.599    38.248     0.200
    22.603    37.497     0.200
    22.693    37.363     0.200
    22.751    37.166     0.200
    22.772    36.857     0.200
    22.803    37.104     0.200
    22.806    36.958     0.200
    22.811    37.306     0.200
    22.811    38.660     0.200
    22.819    36.349     0.200
    22.834    37.704     0.200
    22.855    36.921     0.200
    22.928    36.742     0.200
    22.942    38.588     0.200
    22.954    37.330     0.200
    22.981    37.117     0.200
    23.018    36.273     0.200
    23.025    37.257     0.200
    23.035    36.972     0.200
    23.034    35.608     0.200
    23.039    36.842     0.200
    23.045    37.180     0.200
    23.045    38.148     0.200
    23.055    37.424     0.200
    23.060    36.373     0.200
    23.069    36.743     0.200
    23.077    36.685     0.200
    23.157    37.159     0.200
    23.157    37.463     0.200
    23.207    36.650     0.200
    23.207    37.254     0.200
    23.226    36.372     0.200
    23.233    36.621     0.200
    23.262    36.403     0.200
    23.289    36.269     0.200
    23.289    38.754     0.200
    23.289    36.556     0.200
    23.314    36.146     0.200
    23.327    37.245     0.200
    23.342    36.799     0.200
    23.399    35.944     0.200
    23.400    36.061     0.200
    23.404    35.808     0.200
    23.426    36.187     0.200
    23.426    36.394     0.200
    23.447    36.245     0.200
    23.450    35.692     0.200
    23.450    37.616     0.200
    23.492    36.069     0.200
    23.515    36.892     0.200
    23.608    35.399     0.200
    23.608    36.276     0.200
    23.624    35.811     0.200
    23.666    36.380     0.200
    23.666    38.132     0.200
    23.698    35.292     0.200
    23.698    36.027     0.200
    23.701    35.404     0.200
    23.739    35.385     0.200
    23.739    36.744     0.200
    23.756    34.656     0.200
    23.756    35.544     0.200
    23.759    35.411     0.200
    23.769    35.432     0.200
    23.839    35.673     0.200
    23.839    36.696     0.200
    23.856    35.207     0.200
    23.856    36.514     0.200
    23.862    35.011     0.200
    23.875    35.861     0.200
    23.898    34.825     0.200
    23.941    34.833     0.200
    24.048    35.298     0.200
    24.048    36.972     0.200
    24.059    34.001     0.200
    24.091    35.316     0.200
    24.091    36.818     0.200
    24.098    35.217     0.200
    24.134    34.979     0.200
    24.213    35.053     0.200
    24.217    34.375     0.200
    24.217    35.648     0.200
    24.227    34.262     0.200
    24.241    33.534     0.200
    24.257    34.198     0.200
    24.257    35.856     0.200
    24.258    34.254     0.200
    24.289    34.100     0.200
    24.317    34.342     0.200
    24.324    34.128     0.200
    24.333    35.230     0.200
    24.377    34.224     0.200
    24.428    35.933     0.200
    24.456    34.469     0.200
    24.462    33.680     0.200
    24.543    33.792     0.200
    24.580    33.411     0.200
    24.580    35.308     0.200
    24.587    34.409     0.200
    24.703    32.953     0.200
    24.715    32.591     0.200
    24.715    34.705     0.200
    24.750    33.259     0.200
    24.760    33.394     0.200
    24.816    32.759     0.200
    24.849    32.232     0.200
    24.928    32.869     0.200
    25.095    31.696     0.200
    25.095    33.069     0.200
    25.251    32.709     0.200
    25.258    31.601     0.200
    25.286    31.666     0.200
    25.296    31.879     0.200
    25.372    31.417     0.200
    25.480    32.050     0.200
    25.497    32.037     0.200
    25.734    31.459     0.200
    25.787    30.348     0.200
    25.787    31.352     0.200
    25.786    30.962     0.200
    25.786    33.206     0.200
    25.865    30.358     0.200
    25.865    31.341     0.200
    25.977    30.433     0.200
    26.205    29.823     0.200
    26.288    28.684     0.200
    26.337    28.703     0.200
    26.337    31.054     0.200
    26.365    28.738     0.200
    26.365    30.054     0.200
    26.478    29.368     0.200
    26.481    28.728     0.200
    26.602    29.793     0.200
    26.671    28.248     0.200
    26.744    27.707     0.200
    26.783    28.282     0.200
    26.855    28.769     0.200
    26.919    27.272     0.200
    27.120    27.367     0.200
    27.122    27.366     0.200
    27.177    26.868     0.200
    27.177    28.004     0.200
    27.284    26.605     0.200
    27.344    26.777     0.200
    27.676    25.545     0.200
    28.078    26.316     0.200
    28.078    26.730     0.200
    28.242    23.350     0.200
    28.354    22.444     0.200
    28.787    21.199     0.200
    29.474    19.591     0.200
    29.505    19.875     0.200
    29.523    20.705     0.200
    29.825    19.851     0.200
    29.973    18.900     0.200
    15.020    44.093     0.200
    15.489    39.837     0.200
    17.017    40.355     0.200
    21.762    38.069     0.200
    23.008    35.155     0.200
    23.008    36.491     0.200
    23.304    36.797     0.200
    23.550    36.941     0.200
    23.988    34.056     0.200
    24.027    36.159     0.200
    17.803    41.666     0.200
    21.090    38.503     0.200
    21.805    37.959     0.200
    23.099    38.387     0.200
    15.941    40.576     0.200
    15.938    40.510     0.200
    22.906    36.793     0.200
    26.932    24.081     0.200
    29.503    17.243     0.200
    15.940    40.720     0.200
    18.481    37.171     0.200
    18.865    36.056     0.200
    19.437    37.663     0.200
    19.614    36.510     0.200
    19.844    36.914     0.200
    20.879    35.394     0.200
    20.998    33.688     0.200
    21.221    34.912     0.200
    21.523    35.254     0.200
    21.597    36.153     0.200
    22.902    36.655     0.200
    16.367    41.048     0.200
    16.808    39.431     0.200
    18.220    41.210     0.200
    18.276    40.173     0.200
    18.297    40.969     0.200
    19.360    38.065     0.200
    20.486    39.822     0.200
    21.113    36.098     0.200
    21.632    34.209     0.200
    21.754    36.983     0.200
    21.781    37.720     0.200
    21.994    33.590     0.200
    22.468    33.999     0.200
    23.018    37.367     0.200
    23.032    34.346     0.200
    23.091    35.734     0.200
    23.091    36.000     0.200
    23.194    32.525     0.200
    23.797    36.322     0.200
    23.810    33.549     0.200
    24.228    31.677     0.200
    24.231    31.791     0.200
    24.572    30.754     0.200
    25.469    30.381     0.200
    25.757    28.833     0.200
    26.913    23.452     0.200
    26.913    24.257     0.200
    27.154    25.226     0.200
    28.099    23.525     0.200
    28.099    25.728     0.200
    28.554    23.981     0.200
    15.538    41.140     0.200
    15.932    39.544     0.200
    22.914    35.921     0.200
    15.997    41.851     0.200
    22.901    36.216     0.200
    15.958    41.667     0.200
    21.050    35.588     0.200
    22.952    37.992     0.200
    15.939    42.142     0.200
    15.450    40.815     0.200
    18.656    40.069     0.200
    19.071    39.334     0.200
    19.283    39.550     0.200
    19.360    39.392     0.200
    19.715    39.455     0.200
    19.966    38.226     0.200
    19.984    39.175     0.200
    20.379    38.148     0.200
    21.383    37.993     0.200
    21.391    37.761     0.200
    21.533    37.014     0.200
    21.613    36.985     0.200
    21.663    37.777     0.200
    21.711    37.381     0.200
    21.926    36.526     0.200
    22.276    37.173     0.200
    22.317    37.436     0.200
    22.593    37.114     0.200
    22.659    36.997     0.200
    22.726    35.934     0.200
    22.924    36.595     0.200
    23.178    34.755     0.200
    23.947    35.075     0.200
    24.554    33.250     0.200
    24.992    31.922     0.200
    27.158    25.921     0.200
    28.720    22.816     0.200
    28.959    22.107     0.200
    29.361    20.368     0.200
    29.797    18.282     0.200
    14.474    39.096     0.200
    18.404    41.598     0.200
    18.435    37.736     0.200
    18.821    37.607     0.200
    19.018    37.714     0.200
    19.110    36.726     0.200
    19.049    37.526     0.200
    19.038    37.368     0.200
    19.587    37.131     0.200
    19.570    36.692     0.200
    19.735    35.097     0.200
    20.133    35.340     0.200
    20.405    35.836     0.200
    20.624    35.436     0.200
    21.562    35.542     0.200
    21.142    35.259     0.200
    21.133    35.307     0.200
    21.418    37.182     0.200
    21.290    35.020     0.200
    22.026    33.513     0.200
    22.414    33.509     0.200
    22.564    32.615     0.200
    22.738    35.376     0.200
    23.424    31.883     0.200
    23.578    31.563     0.200
    24.353    35.148     0.200
    23.629    32.020     0.200
    23.661    36.621     0.200
    25.218    27.268     0.200
    27.450    27.260     0.200
    29.732    20.424     0.200
    23.932    34.471     0.200
    23.958    34.049     0.200
    26.397    28.035     0.200
    27.463    26.927     0.200
    29.743    20.334     0.200
    15.806    40.608     0.200
    18.909    39.332     0.200
    20.875    38.309     0.200
    21.617    37.773     0.200
    14.728    39.534     0.200
    14.769    39.554     0.200
    14.769    40.195     0.200
    15.913    39.465     0.200
    16.534    41.044     0.200
    16.800    40.431     0.200
    16.800    40.166     0.200
    17.372    41.607     0.200
    17.714    39.688     0.200
    17.678    40.125     0.200
    17.868    43.493     0.200
    18.033    39.522     0.200
    18.210    40.927     0.200
    18.488    40.867     0.200
    18.704    39.955     0.200
    18.847    42.154     0.200
    18.823    39.098     0.200
    18.886    40.289     0.200
    18.898    39.713     0.200
    20.859    38.156     0.200
    20.822    38.164     0.200
    21.297    41.210     0.200
    21.402    40.501     0.200
    21.600    38.177     0.200
    21.710    39.905     0.200
    21.880    39.299     0.200
    21.880    38.276     0.200
    21.842    40.203     0.200
    22.246    39.253     0.200
    22.275    37.948     0.200
    22.903    35.915     0.200
    22.840    37.422     0.200
    22.938    37.339     0.200
    22.938    36.706     0.200
    22.938    36.933     0.200
    23.562    33.584     0.200
    23.754    34.228     0.200
    23.757    35.718     0.200
    23.902    36.323     0.200
    23.902    35.370     0.200
    24.222    33.596     0.200
    24.281    34.297     0.200
    24.281    33.648     0.200
    24.281    33.359     0.200
    24.267    35.325     0.200
    24.506    33.555     0.200
    26.387    29.027     0.200
    26.656    28.045     0.200
    16.075    39.931     0.200
    20.567    36.723     0.200
    20.912    36.988     0.200
    15.920    41.288     0.200
    16.812    42.105     0.200
    18.050    39.833     0.200
    18.503    41.503     0.200
    18.719    39.196     0.200
    18.837    39.333     0.200
    18.912    39.183     0.200
    18.852    42.110     0.200
    18.984    39.361     0.200
    19.464    38.905     0.200
    20.070    39.204     0.200
    20.116    38.880     0.200
    20.914    37.546     0.200
    21.030    38.187     0.200
    21.615    38.289     0.200
    21.615    36.969     0.200
    22.258    36.596     0.200
    22.952    39.795     0.200
    23.479    34.912     0.200
    23.907    33.770     0.200
    26.897    27.748     0.200
    19.614    37.235     0.200
    21.584    37.052     0.200
    19.603    38.551     0.200
    20.869    36.952     0.200
    22.815    34.335     0.200
    14.603    40.637     0.200
    14.729    40.154     0.200
    15.915    40.772     0.200
    18.449    36.911     0.200
    18.848    37.089     0.200
    18.857    42.043     0.200
    19.175    37.294     0.200
    19.235    36.948     0.200
    19.813    35.944     0.200
    19.876    36.984     0.200
    20.008    35.710     0.200
    20.848    36.358     0.200
    21.491    35.022     0.200
    22.873    36.472     0.200
    23.553    32.559     0.200
    23.701    31.967     0.200
    23.718    37.078     0.200
    20.007    36.989     0.200
    20.392    37.205     0.200
    21.032    36.686     0.200
    21.306    35.830     0.200
    25.845    27.887     0.200
    29.675    18.572     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.286     6.566     0.200
     1.286     8.256     0.200
     1.290     9.192     0.200
     1.345     8.329     0.200
     1.347     7.775     0.200
     1.582     6.898     0.200
     3.275    14.171     0.200
     5.244    17.467     0.200
     6.612    21.688     0.200
     6.713    19.420     0.200
     7.088    21.267     0.200
     7.167    20.750     0.200
     7.445    21.576     0.200
     7.475    21.467     0.200
     7.642    25.500     0.200
     7.738    24.160     0.200
     7.774    23.360     0.200
     7.774    23.036     0.200
     7.774    23.185     0.200
     8.030    25.270     0.200
     8.160    27.275     0.200
     8.183    26.262     0.200
     8.343    24.694     0.200
     8.419    22.455     0.200
     8.561    24.760     0.200
     8.637    28.165     0.200
     8.759    26.374     0.200
     9.187    29.447     0.200
     9.247    26.793     0.200
     9.231    25.785     0.200
     9.336    28.978     0.200
     9.336    29.615     0.200
     9.552    28.853     0.200
     9.585    28.501     0.200
     9.627    27.045     0.200
     9.667    27.347     0.200
     9.637    27.129     0.200
    10.312    32.614     0.200
    10.381    30.908     0.200
    10.421    28.247     0.200
    10.751    31.489     0.200
    10.874    33.180     0.200
    11.058    34.816     0.200
    11.305    34.200     0.200
    11.305    32.429     0.200
    11.497    33.775     0.200
    11.595    32.755     0.200
    11.595    30.751     0.200
    11.642    35.066     0.200
    11.793    34.294     0.200
    11.885    33.534     0.200
    11.888    33.599     0.200
    11.984    34.444     0.200
    12.043    34.400     0.200
    12.215    34.354     0.200
    12.535    37.829     0.200
    12.550    36.864     0.200
    12.566    37.288     0.200
    12.715    35.763     0.200
    12.741    37.476     0.200
    12.781    35.425     0.200
    12.830    39.263     0.200
    13.490    37.530     0.200
    13.947    34.700     0.200
    14.069    38.432     0.200
    14.461    39.465     0.200
    14.593    38.894     0.200
    14.770    39.528     0.200
    15.924    40.355     0.200
    15.924    39.830     0.200
    16.170    39.011     0.200
    16.549    40.269     0.200
    16.809    39.193     0.200
    17.477    40.819     0.200
    18.223    40.499     0.200
    19.426    45.661     0.200
    19.979    43.308     0.200
    20.639    41.107     0.200
     0.777     4.143     0.200
     1.173     7.514     0.200
     1.271     7.744     0.200
     1.278     7.785     0.200
     1.328     7.195     0.200
     1.333     7.932     0.200
     1.380     8.394     0.200
     1.584     6.359     0.200
     3.288    10.934     0.200
     3.805    10.812     0.200
     4.340    13.782     0.200
     4.634    14.194     0.200
     7.754    24.257     0.200
     7.789    21.035     0.200
     7.789    21.406     0.200
     7.945    22.591     0.200
     8.430    22.884     0.200
    10.768    30.060     0.200
    11.192    34.539     0.200
    11.321    35.023     0.200
    11.512    34.068     0.200
    13.137    36.158     0.200
     0.765     6.079     0.200
     1.327     9.471     0.200
     1.379     8.057     0.200
     1.432     8.881     0.200
     3.754    12.845     0.200
     4.349    14.632     0.200
     4.630    16.412     0.200
     5.273    18.295     0.200
     5.372    18.496     0.200
     5.582    17.305     0.200
     6.596    22.205     0.200
     7.050    21.853     0.200
     7.129    21.609     0.200
     7.327    22.804     0.200
     7.407    21.566     0.200
     7.437    21.775     0.200
     7.624    22.808     0.200
     7.737    22.254     0.200
     7.737    22.572     0.200
     7.717    23.429     0.200
     7.820    24.715     0.200
     8.145    24.103     0.200
     8.379    22.668     0.200
     8.342    25.285     0.200
     8.621    25.698     0.200
    10.723    28.884     0.200
    11.780    32.127     0.200
    11.875    33.457     0.200
    13.116    37.180     0.200
    14.625    37.632     0.200
    15.925    39.104     0.200
    16.684    38.409     0.200
     0.755     5.582     0.200
     1.308     8.025     0.200
     1.315     8.119     0.200
     1.362     7.734     0.200
     1.367     7.513     0.200
     1.418     8.619     0.200
     1.584     6.331     0.200
     3.174    11.208     0.200
     3.775    11.240     0.200
     4.330    14.061     0.200
     4.615    15.289     0.200
     5.577    17.882     0.200
     5.646    20.202     0.200
     6.472    25.656     0.200
     6.593    19.868     0.200
     7.066    21.862     0.200
     7.146    20.561     0.200
     7.335    23.075     0.200
     7.424    21.649     0.200
     7.454    21.032     0.200
     7.622    24.241     0.200
     7.718    23.810     0.200
     7.752    23.190     0.200
     7.752    23.394     0.200
     7.824    24.278     0.200
     8.141    27.404     0.200
     8.401    22.758     0.200
     8.619    27.836     0.200
     9.212    26.196     0.200
     9.229    28.638     0.200
     9.607    27.370     0.200
    10.730    31.732     0.200
    11.286    33.183     0.200
    11.480    33.123     0.200
    11.573    29.533     0.200
    11.578    32.841     0.200
    11.775    34.104     0.200
    11.870    34.028     0.200
    11.967    34.610     0.200
    12.197    35.672     0.200
    12.550    37.431     0.200
    13.108    38.088     0.200
    13.325    36.407     0.200
    13.474    35.903     0.200
    14.052    39.282     0.200
    14.447    35.941     0.200
    14.578    38.898     0.200
    19.221    40.670     0.200
     0.987     5.525     0.200
     0.987     5.627     0.200
     1.090     5.680     0.200
     1.090     5.856     0.200
     1.327     7.184     0.200
     1.651     7.438     0.200
     1.661     7.434     0.200
     1.735     8.579     0.200
     2.054     8.532     0.200
     2.114     9.594     0.200
     2.125     9.704     0.200
     2.153     8.761     0.200
     2.173     8.718     0.200
     2.267     9.215     0.200
     2.324     9.438     0.200
     2.470    10.007     0.200
     2.654    10.402     0.200
     2.686    10.077     0.200
     2.686    10.253     0.200
     2.691     9.790     0.200
     2.726    10.700     0.200
     2.746    10.221     0.200
     2.787    10.384     0.200
     2.838    10.429     0.200
     2.977    11.570     0.200
     2.977    11.203     0.200
     3.005    11.492     0.200
     3.101    11.257     0.200
     3.180    11.516     0.200
     3.192    11.471     0.200
     3.213    11.251     0.200
     3.220    11.746     0.200
     3.525    12.670     0.200
     3.570    12.355     0.200
     3.588    12.087     0.200
     3.588    12.422     0.200
     3.653    12.555     0.200
     3.666    12.017     0.200
     3.805    12.839     0.200
     3.827    12.140     0.200
     3.830    13.712     0.200
     3.940    14.180     0.200
     4.008    14.486     0.200
     4.436    15.040     0.200
     4.462    12.796     0.200
     4.549    14.515     0.200
     4.679    15.376     0.200
     4.797    15.941     0.200
     4.797    16.242     0.200
     4.941    16.183     0.200
     5.095    16.600     0.200
     5.109    16.905     0.200
     5.120    16.681     0.200
     5.259    17.168     0.200
     5.330    17.242     0.200
     5.350    17.590     0.200
     5.431    17.421     0.200
     5.463    16.602     0.200
     5.520    17.618     0.200
     5.544    17.962     0.200
     5.596    18.489     0.200
     5.606    18.459     0.200
     5.665    20.536     0.200
     5.855    17.304     0.200
     6.027    19.121     0.200
     6.407    18.935     0.200
     6.613    22.830     0.200
     7.631    22.480     0.200
     7.666    23.743     0.200
     7.727    21.940     0.200
     7.821    24.214     0.200
     7.964    23.447     0.200
     8.009    22.932     0.200
     8.030    22.764     0.200
     8.293    23.445     0.200
     9.092    24.425     0.200
     9.595    27.231     0.200
     9.799    29.066     0.200
     9.994    27.614     0.200
    12.378    36.311     0.200
    14.372    38.979     0.200
    15.584    37.203     0.200
     0.990     5.514     0.200
     0.990     5.287     0.200
     1.201     6.145     0.200
     1.532     8.662     0.200
     1.665     8.842     0.200
     1.798    11.204     0.200
     1.999     8.638     0.200
     2.017     8.937     0.200
     2.143    10.085     0.200
     2.525    10.606     0.200
     2.594    11.385     0.200
     2.874    12.086     0.200
     3.064    12.192     0.200
     3.059    11.508     0.200
     3.151    11.630     0.200
     3.396    12.702     0.200
     3.534    12.780     0.200
     3.537    12.855     0.200
     3.723    13.441     0.200
     3.759    13.763     0.200
     4.401    13.971     0.200
     4.674    16.781     0.200
     5.934    17.675     0.200
     6.350    22.291     0.200
     6.482    22.440     0.200
     9.721    29.576     0.200
    11.095    29.269     0.200
    11.164    32.840     0.200
     0.999     5.537     0.200
     1.093     5.576     0.200
     1.086     5.812     0.200
     1.086     5.672     0.200
     1.323     6.433     0.200
     1.656     7.828     0.200
     1.662     7.258     0.200
     1.747     8.561     0.200
     1.697    10.449     0.200
     2.066     9.232     0.200
     2.124     9.349     0.200
     2.128     8.601     0.200
     2.134     8.598     0.200
     2.163     8.858     0.200
     2.172     8.669     0.200
     2.336     8.767     0.200
     2.656     9.969     0.200
     2.697    10.154     0.200
     2.697    10.014     0.200
     2.687     9.655     0.200
     2.738     9.775     0.200
     2.756    10.179     0.200
     2.835    10.267     0.200
     2.986    11.556     0.200
     3.008    10.970     0.200
     3.213    11.235     0.200
     3.354    10.965     0.200
     3.527    12.486     0.200
     3.582    12.271     0.200
     3.600    12.619     0.200
     3.600    12.322     0.200
     3.651    12.815     0.200
     3.659    12.148     0.200
     3.743    13.139     0.200
     3.824    13.392     0.200
     4.004    12.794     0.200
     4.104    13.556     0.200
     4.213    14.197     0.200
     4.267    14.794     0.200
     4.267    14.091     0.200
     4.416    14.769     0.200
     4.454    13.228     0.200
     4.472    14.422     0.200
     4.604    15.103     0.200
     4.692    15.382     0.200
     4.675    15.868     0.200
     4.796    16.613     0.200
     4.977    17.208     0.200
     5.004    16.694     0.200
     5.131    16.571     0.200
     5.118    15.061     0.200
     5.209    16.840     0.200
     5.256    17.092     0.200
     5.273    16.966     0.200
     5.335    17.472     0.200
     6.031    17.286     0.200
     6.419    18.250     0.200
     7.627    21.710     0.200
     7.678    21.262     0.200
     7.666    24.859     0.200
     7.825    22.112     0.200
     8.004    23.276     0.200
     8.288    23.659     0.200
     8.288    24.651     0.200
     9.084    24.658     0.200
    11.124    31.380     0.200
    11.300    34.547     0.200
    15.594    39.641     0.200
     1.170     6.301     0.200
     1.206     5.799     0.200
     1.284     8.106     0.200
     1.348     7.361     0.200
     1.343     6.133     0.200
     1.392     8.542     0.200
     1.408     8.082     0.200
     1.505     6.737     0.200
     1.505     6.315     0.200
     1.505     6.186     0.200
     1.573     7.468     0.200
     1.648     6.765     0.200
     1.707     7.024     0.200
     1.844     7.095     0.200
     1.952     7.635     0.200
     2.091     8.099     0.200
     2.178     7.641     0.200
     2.189     8.293     0.200
     2.252     8.547     0.200
     2.345     8.457     0.200
     2.382     8.475     0.200
     2.438     9.219     0.200
     2.470     9.199     0.200
     2.520     8.931     0.200
     2.617     9.272     0.200
     2.625    10.594     0.200
     2.652     9.857     0.200
     2.776     9.494     0.200
     2.775     9.266     0.200
     2.784     9.592     0.200
     2.800     9.441     0.200
     2.796     9.207     0.200
     2.855     9.792     0.200
     2.866     9.766     0.200
     2.899    13.523     0.200
     2.896    10.142     0.200
     2.913     9.941     0.200
     2.954    13.063     0.200
     3.051     9.935     0.200
     3.276    11.542     0.200
     3.289    11.328     0.200
     3.298    10.350     0.200
     3.321    11.818     0.200
     3.380    11.246     0.200
     3.387    10.641     0.200
     3.518    11.534     0.200
     3.531    11.599     0.200
     3.551    11.143     0.200
     3.573    15.118     0.200
     3.567    11.212     0.200
     3.632    11.103     0.200
     3.632    12.683     0.200
     3.666    11.717     0.200
     3.719    12.978     0.200
     3.785    12.720     0.200
     3.834    11.638     0.200
     3.866    11.672     0.200
     3.875    11.349     0.200
     3.936    11.821     0.200
     3.952    12.170     0.200
     3.962    13.217     0.200
     4.022    12.729     0.200
     4.046    12.631     0.200
     4.046    13.484     0.200
     4.108    13.362     0.200
     4.107    13.896     0.200
     4.140    12.066     0.200
     4.140    13.025     0.200
     4.160    12.786     0.200
     4.180    14.619     0.200
     4.205    11.857     0.200
     4.250    14.596     0.200
     4.292    13.916     0.200
     4.332    14.328     0.200
     4.479    14.323     0.200
     4.479    15.898     0.200
     4.490    12.823     0.200
     4.490    12.927     0.200
     4.517    12.995     0.200
     4.605    15.171     0.200
     4.636    13.429     0.200
     4.642    14.897     0.200
     4.702    15.018     0.200
     4.779    15.365     0.200
     4.829    13.774     0.200
     4.937    15.384     0.200
     4.951    15.814     0.200
     5.034    15.094     0.200
     5.054    16.980     0.200
     5.081    14.593     0.200
     5.082    14.253     0.200
     5.155    16.614     0.200
     5.157    15.298     0.200
     5.159    16.337     0.200
     5.240    14.953     0.200
     5.254    16.505     0.200
     5.296    16.445     0.200
     5.352    17.072     0.200
     5.502    15.237     0.200
     5.523    17.292     0.200
     5.559    17.359     0.200
     5.580    17.471     0.200
     5.602    17.790     0.200
     5.644    18.719     0.200
     5.746    18.394     0.200
     5.820    18.110     0.200
     5.824    18.636     0.200
     5.860    19.384     0.200
     5.880    17.738     0.200
     5.889    17.367     0.200
     5.892    17.774     0.200
     5.951    18.415     0.200
     5.991    19.932     0.200
     6.077    19.248     0.200
     6.127    18.948     0.200
     6.134    18.312     0.200
     6.268    18.831     0.200
     6.310    19.682     0.200
     6.358    19.861     0.200
     6.386    19.237     0.200
     6.421    19.367     0.200
     6.444    19.374     0.200
     6.469    20.102     0.200
     6.548    20.280     0.200
     6.566    20.981     0.200
     6.574    19.734     0.200
     6.586    19.685     0.200
     6.607    19.314     0.200
     6.607    20.151     0.200
     6.639    19.629     0.200
     6.729    20.096     0.200
     6.740    17.669     0.200
     6.777    20.730     0.200
     6.805    21.957     0.200
     6.913    20.903     0.200
     6.933    21.208     0.200
     6.945    19.620     0.200
     6.955    19.306     0.200
     7.015    20.821     0.200
     7.021    19.183     0.200
     7.039    20.876     0.200
     7.067    21.095     0.200
     7.096    21.102     0.200
     7.214    21.664     0.200
     7.233    21.562     0.200
     7.238    21.514     0.200
     7.278    22.120     0.200
     7.314    22.939     0.200
     7.343    22.891     0.200
     7.352    21.028     0.200
     7.390    22.635     0.200
     7.494    21.584     0.200
     7.503    22.472     0.200
     7.517    23.324     0.200
     7.599    23.529     0.200
     7.640    23.385     0.200
     7.669    21.622     0.200
     7.699    23.152     0.200
     7.699    22.652     0.200
     7.727    19.557     0.200
     7.731    22.323     0.200
     7.739    22.268     0.200
     7.788    22.869     0.200
     7.788    22.500     0.200
     7.814    21.899     0.200
     7.820    23.487     0.200
     7.850    23.332     0.200
     7.857    23.056     0.200
     7.883    23.746     0.200
     7.904    24.323     0.200
     7.906    24.068     0.200
     7.926    23.763     0.200
     7.931    25.396     0.200
     7.986    23.829     0.200
     7.986    24.152     0.200
     8.053    24.634     0.200
     8.112    25.879     0.200
     8.142    24.448     0.200
     8.151    24.237     0.200
     8.213    24.601     0.200
     8.252    24.572     0.200
     8.277    23.726     0.200
     8.283    23.113     0.200
     8.387    22.591     0.200
     8.435    22.110     0.200
     8.448    25.419     0.200
     8.515    25.845     0.200
     8.555    23.977     0.200
     8.562    25.766     0.200
     8.570    21.377     0.200
     8.578    25.953     0.200
     8.590    27.258     0.200
     8.616    25.548     0.200
     8.639    23.399     0.200
     8.708    26.954     0.200
     8.715    26.833     0.200
     8.815    26.438     0.200
     8.809    25.120     0.200
     8.939    24.807     0.200
     8.955    27.271     0.200
     8.971    22.059     0.200
     8.975    27.219     0.200
     8.993    26.275     0.200
     9.041    24.129     0.200
     9.058    26.518     0.200
     9.106    25.638     0.200
     9.116    26.322     0.200
     9.132    27.928     0.200
     9.170    25.308     0.200
     9.204    27.438     0.200
     9.282    27.100     0.200
     9.283    26.138     0.200
     9.308    27.591     0.200
     9.360    27.754     0.200
     9.414    25.855     0.200
     9.414    28.505     0.200
     9.414    28.994     0.200
     9.438    27.565     0.200
     9.504    27.306     0.200
     9.528    27.707     0.200
     9.555    27.394     0.200
     9.616    27.394     0.200
     9.653    25.148     0.200
     9.680    26.624     0.200
     9.681    26.433     0.200
     9.704    27.738     0.200
     9.707    26.457     0.200
     9.732    28.245     0.200
     9.739    28.039     0.200
     9.757    27.758     0.200
     9.816    27.996     0.200
     9.891    28.308     0.200
     9.977    29.065     0.200
     9.998    23.875     0.200
    10.015    29.506     0.200
    10.027    26.286     0.200
    10.033    27.982     0.200
    10.073    29.907     0.200
    10.099    28.432     0.200
    10.172    28.289     0.200
    10.217    28.663     0.200
    10.227    27.881     0.200
    10.236    29.768     0.200
    10.257    29.738     0.200
    10.287    29.956     0.200
    10.308    31.812     0.200
    10.318    29.709     0.200
    10.347    29.813     0.200
    10.382    30.176     0.200
    10.387    29.792     0.200
    10.407    30.408     0.200
    10.451    29.943     0.200
    10.476    27.945     0.200
    10.564    31.202     0.200
    10.667    31.106     0.200
    10.686    30.882     0.200
    10.732    31.599     0.200
    10.733    29.897     0.200
    10.773    31.713     0.200
    10.782    30.250     0.200
    10.853    31.842     0.200
    10.953    32.305     0.200
    10.954    32.489     0.200
    10.965    31.401     0.200
    10.981    33.638     0.200
    10.981    32.779     0.200
    10.992    31.573     0.200
    11.018    32.542     0.200
    11.034    32.238     0.200
    11.046    31.851     0.200
    11.115    31.793     0.200
    11.115    32.596     0.200
    11.167    33.974     0.200
    11.163    31.663     0.200
    11.169    32.844     0.200
    11.191    33.165     0.200
    11.259    33.089     0.200
    11.259    32.520     0.200
    11.259    32.660     0.200
    11.326    33.581     0.200
    11.323    33.138     0.200
    11.328    32.991     0.200
    11.349    29.018     0.200
    11.407    30.730     0.200
    11.437    32.606     0.200
    11.446    33.294     0.200
    11.454    32.909     0.200
    11.480    27.311     0.200
    11.549    27.950     0.200
    11.551    31.708     0.200
    11.589    33.921     0.200
    11.615    30.752     0.200
    11.660    33.740     0.200
    11.675    33.850     0.200
    11.722    34.954     0.200
    11.741    34.513     0.200
    11.742    33.369     0.200
    11.794    33.781     0.200
    11.807    35.379     0.200
    11.934    35.146     0.200
    12.033    28.343     0.200
    12.038    34.030     0.200
    12.067    35.533     0.200
    12.085    35.466     0.200
    12.099    36.185     0.200
    12.123    35.827     0.200
    12.171    29.906     0.200
    12.246    33.246     0.200
    12.325    35.627     0.200
    12.332    28.811     0.200
    12.479    36.937     0.200
    12.481    37.435     0.200
    12.506    37.458     0.200
    12.567    29.180     0.200
    12.638    34.461     0.200
    12.651    37.182     0.200
    12.767    36.292     0.200
    12.854    37.275     0.200
    12.873    38.130     0.200
    12.884    37.302     0.200
    12.899    36.088     0.200
    12.950    36.917     0.200
    13.046    37.290     0.200
    13.064    37.781     0.200
    13.129    37.470     0.200
    13.235    38.101     0.200
    13.332    38.248     0.200
    13.337    38.408     0.200
    13.341    36.802     0.200
    13.387    35.573     0.200
    13.417    38.605     0.200
    13.427    37.306     0.200
    13.433    35.440     0.200
    13.433    38.109     0.200
    13.496    35.729     0.200
    13.496    36.589     0.200
    13.547    37.381     0.200
    13.584    36.739     0.200
    13.593    38.293     0.200
    13.595    38.743     0.200
    13.599    37.232     0.200
    13.603    35.281     0.200
    13.629    38.696     0.200
    13.760    39.107     0.200
    13.890    39.321     0.200
    13.897    39.139     0.200
    13.903    38.217     0.200
    13.908    39.174     0.200
    13.952    39.259     0.200
    13.970    34.373     0.200
    13.999    38.596     0.200
    14.017    38.571     0.200
    14.105    38.414     0.200
    14.112    38.673     0.200
    14.296    39.153     0.200
    14.314    39.235     0.200
    14.338    39.131     0.200
    14.398    38.665     0.200
    14.405    39.449     0.200
    14.490    38.267     0.200
    14.514    39.464     0.200
    14.599    39.296     0.200
    14.616    36.929     0.200
    14.639    38.997     0.200
    14.662    38.780     0.200
    14.677    38.843     0.200
    14.693    39.198     0.200
    14.730    39.684     0.200
    14.728    39.132     0.200
    14.771    38.849     0.200
    14.846    39.125     0.200
    14.843    38.969     0.200
    14.880    36.445     0.200
    15.102    39.754     0.200
    15.145    39.282     0.200
    15.221    39.846     0.200
    15.241    38.974     0.200
    15.318    39.923     0.200
    15.316    39.385     0.200
    15.346    39.738     0.200
    15.388    39.730     0.200
    15.435    39.784     0.200
    15.443    39.815     0.200
    15.496    39.637     0.200
    15.554    39.613     0.200
    15.570    39.278     0.200
    15.576    39.638     0.200
    15.643    40.001     0.200
    15.803    38.540     0.200
    15.834    38.506     0.200
    15.855    40.179     0.200
    15.861    38.818     0.200
    15.918    40.134     0.200
    15.980    40.075     0.200
    16.097    40.256     0.200
    16.116    37.992     0.200
    16.178    39.335     0.200
    16.175    39.616     0.200
    16.187    38.333     0.200
    16.284    38.435     0.200
    16.399    39.495     0.200
    16.468    37.537     0.200
    16.466    39.440     0.200
    16.503    39.487     0.200
    16.509    38.972     0.200
    16.553    39.822     0.200
    16.607    37.661     0.200
    16.623    39.170     0.200
    16.689    39.844     0.200
    16.715    36.180     0.200
    16.752    38.634     0.200
    16.778    38.809     0.200
    16.838    38.955     0.200
    16.957    38.424     0.200
    17.295    40.392     0.200
    17.514    40.286     0.200
    18.248    40.350     0.200
    19.266    42.342     0.200
    19.931    40.323     0.200
    20.945    40.391     0.200
     1.217     5.707     0.200
     1.344     6.204     0.200
     1.343     7.693     0.200
     1.388     8.508     0.200
     1.398     8.690     0.200
     1.514     6.376     0.200
     1.514     6.133     0.200
     1.577     7.303     0.200
     1.659     6.700     0.200
     1.718     6.925     0.200
     1.850     7.586     0.200
     1.960     7.754     0.200
     2.100     7.927     0.200
     2.174     7.700     0.200
     2.192     8.285     0.200
     2.261     8.806     0.200
     2.356     8.488     0.200
     2.391     8.755     0.200
     2.444     8.960     0.200
     2.478     9.348     0.200
     2.531     9.093     0.200
     2.617     8.926     0.200
     2.660     9.570     0.200
     2.785     9.611     0.200
     2.780     9.567     0.200
     2.780     9.823     0.200
     2.805    10.151     0.200
     2.807    10.145     0.200
     2.861    10.155     0.200
     2.876     9.707     0.200
     2.905     9.965     0.200
     2.906    10.926     0.200
     2.917     9.532     0.200
     3.051     9.854     0.200
     3.109     9.803     0.200
     3.112    10.334     0.200
     3.112    11.201     0.200
     3.281    11.488     0.200
     3.296    10.335     0.200
     3.300    10.861     0.200
     3.306    11.604     0.200
     3.329    11.323     0.200
     3.389    10.687     0.200
     3.390    11.239     0.200
     3.521    11.124     0.200
     3.541    11.283     0.200
     3.557    11.549     0.200
     3.576    11.647     0.200
     3.580    12.732     0.200
     3.580    13.318     0.200
     3.636    12.674     0.200
     3.674    11.961     0.200
     3.726    12.622     0.200
     3.789    12.331     0.200
     3.833    11.517     0.200
     3.865    11.618     0.200
     3.872    11.961     0.200
     3.941    12.948     0.200
     3.954    12.008     0.200
     3.970    12.554     0.200
     4.032    12.771     0.200
     4.033    13.070     0.200
     4.057    13.605     0.200
     4.057    13.446     0.200
     4.113    13.603     0.200
     4.118    13.628     0.200
     4.149    13.280     0.200
     4.149    12.764     0.200
     4.161    13.312     0.200
     4.217    13.742     0.200
     4.258    14.196     0.200
     4.303    14.117     0.200
     4.341    14.391     0.200
     4.485    14.718     0.200
     4.485    15.046     0.200
     4.487    13.103     0.200
     4.491    14.533     0.200
     4.516    13.581     0.200
     4.614    14.992     0.200
     4.632    13.497     0.200
     4.647    15.131     0.200
     4.712    15.327     0.200
     4.789    15.665     0.200
     4.849    15.976     0.200
     4.940    15.301     0.200
     4.961    15.750     0.200
     5.061    17.260     0.200
     5.073    17.990     0.200
     5.081    14.638     0.200
     5.158    15.966     0.200
     5.164    16.753     0.200
     5.169    16.455     0.200
     5.237    15.079     0.200
     5.264    16.558     0.200
     5.298    16.810     0.200
     5.356    17.560     0.200
     5.499    17.924     0.200
     5.510    17.977     0.200
     5.528    18.357     0.200
     5.590    17.821     0.200
     5.606    18.002     0.200
     5.644    16.205     0.200
     5.651    18.401     0.200
     5.755    18.367     0.200
     5.830    18.341     0.200
     5.867    18.857     0.200
     5.890    18.353     0.200
     5.899    17.994     0.200
     5.902    18.209     0.200
     5.962    19.998     0.200
     5.997    19.780     0.200
     6.085    19.562     0.200
     6.136    18.661     0.200
     6.139    19.389     0.200
     6.271    19.297     0.200
     6.366    20.645     0.200
     6.397    19.624     0.200
     6.431    20.449     0.200
     6.476    20.924     0.200
     6.584    20.435     0.200
     6.596    20.777     0.200
     6.602    19.578     0.200
     6.615    20.884     0.200
     6.739    20.745     0.200
     6.782    21.466     0.200
     6.813    21.628     0.200
     6.916    21.504     0.200
     7.021    20.249     0.200
     7.025    21.073     0.200
     7.078    21.240     0.200
     7.106    22.071     0.200
     7.189    20.794     0.200
     7.214    21.872     0.200
     7.225    21.953     0.200
     7.235    21.948     0.200
     7.287    23.169     0.200
     7.321    22.881     0.200
     7.348    22.994     0.200
     7.348    23.275     0.200
     7.362    22.257     0.200
     7.397    22.618     0.200
     7.496    21.999     0.200
     7.505    23.076     0.200
     7.577    23.202     0.200
     7.647    23.856     0.200
     7.680    22.884     0.200
     7.708    22.911     0.200
     7.708    23.747     0.200
     7.740    23.826     0.200
     7.790    23.105     0.200
     7.790    23.003     0.200
     7.824    23.024     0.200
     7.866    23.302     0.200
     7.911    25.193     0.200
     7.934    23.978     0.200
     7.996    25.530     0.200
     7.996    24.311     0.200
     8.059    24.613     0.200
     8.150    24.158     0.200
     8.152    23.881     0.200
     8.224    24.312     0.200
     8.261    24.568     0.200
     8.288    23.921     0.200
     8.288    23.828     0.200
     8.398    24.288     0.200
     8.445    24.891     0.200
     8.458    25.676     0.200
     8.565    25.871     0.200
     8.571    26.418     0.200
     8.587    30.671     0.200
     8.599    28.493     0.200
     8.646    25.152     0.200
     8.716    28.759     0.200
     8.817    26.049     0.200
     8.949    26.974     0.200
     8.961    26.445     0.200
     8.981    27.054     0.200
     8.984    27.288     0.200
     9.001    26.483     0.200
     9.052    27.791     0.200
     9.064    26.705     0.200
     9.117    26.668     0.200
     9.142    29.414     0.200
     9.180    26.837     0.200
     9.213    27.144     0.200
     9.268    26.261     0.200
     9.291    27.718     0.200
     9.318    27.675     0.200
     9.366    27.857     0.200
     9.448    28.160     0.200
     9.511    27.649     0.200
     9.538    30.431     0.200
     9.563    27.710     0.200
     9.663    27.787     0.200
     9.690    27.678     0.200
     9.691    28.862     0.200
     9.715    29.073     0.200
     9.717    28.605     0.200
     9.766    29.048     0.200
     9.826    29.110     0.200
    10.021    30.201     0.200
    10.026    30.087     0.200
    10.043    29.755     0.200
    10.083    30.352     0.200
    10.107    28.750     0.200
    10.182    30.093     0.200
    10.228    29.942     0.200
    10.237    30.200     0.200
    10.267    30.421     0.200
    10.328    31.219     0.200
    10.356    30.578     0.200
    10.395    30.061     0.200
    10.393    30.758     0.200
    10.418    30.959     0.200
    10.461    30.704     0.200
    10.472    27.836     0.200
    10.575    31.873     0.200
    10.675    31.702     0.200
    10.696    32.043     0.200
    10.739    31.424     0.200
    10.783    32.014     0.200
    10.792    32.375     0.200
    10.832    32.469     0.200
    10.863    32.006     0.200
    10.956    32.840     0.200
    10.961    32.892     0.200
    10.964    32.727     0.200
    10.975    33.034     0.200
    11.001    31.449     0.200
    11.057    32.405     0.200
    11.126    33.045     0.200
    11.126    34.467     0.200
    11.173    32.893     0.200
    11.177    33.893     0.200
    11.180    33.912     0.200
    11.201    32.860     0.200
    11.268    32.650     0.200
    11.268    33.846     0.200
    11.268    32.797     0.200
    11.336    33.513     0.200
    11.336    33.997     0.200
    11.360    33.829     0.200
    11.415    33.031     0.200
    11.447    34.371     0.200
    11.455    34.061     0.200
    11.490    33.272     0.200
    11.494    34.675     0.200
    11.533    32.898     0.200
    11.552    34.592     0.200
    11.562    34.286     0.200
    11.598    34.451     0.200
    11.617    32.488     0.200
    11.670    35.197     0.200
    11.733    34.579     0.200
    11.751    34.278     0.200
    11.804    34.145     0.200
    11.817    36.865     0.200
    11.845    32.704     0.200
    12.047    34.172     0.200
    12.078    34.897     0.200
    12.095    35.450     0.200
    12.110    34.952     0.200
    12.133    35.589     0.200
    12.181    35.330     0.200
    12.256    35.852     0.200
    12.335    35.828     0.200
    12.343    35.583     0.200
    12.496    36.039     0.200
    12.647    35.756     0.200
    12.661    36.866     0.200
    12.735    37.038     0.200
    12.764    38.417     0.200
    12.777    38.091     0.200
    12.864    37.265     0.200
    12.884    37.169     0.200
    12.894    36.789     0.200
    12.910    37.674     0.200
    12.961    36.808     0.200
    13.056    37.621     0.200
    13.074    38.524     0.200
    13.139    38.133     0.200
    13.246    38.188     0.200
    13.342    38.023     0.200
    13.347    38.216     0.200
    13.351    37.869     0.200
    13.385    36.141     0.200
    13.428    37.276     0.200
    13.437    37.653     0.200
    13.443    37.784     0.200
    13.505    37.498     0.200
    13.505    37.311     0.200
    13.544    38.790     0.200
    13.557    37.589     0.200
    13.604    38.010     0.200
    13.606    37.995     0.200
    13.609    37.562     0.200
    13.626    38.675     0.200
    13.770    36.289     0.200
    13.900    39.105     0.200
    13.907    38.724     0.200
    13.914    38.095     0.200
    13.917    38.194     0.200
    13.962    38.030     0.200
    13.971    35.700     0.200
    14.010    38.647     0.200
    14.027    38.674     0.200
    14.094    38.152     0.200
    14.115    38.391     0.200
    14.122    38.502     0.200
    14.222    39.152     0.200
    14.306    40.173     0.200
    14.318    40.131     0.200
    14.324    39.353     0.200
    14.349    39.279     0.200
    14.408    39.557     0.200
    14.415    39.474     0.200
    14.524    39.213     0.200
    14.541    39.697     0.200
    14.610    39.013     0.200
    14.650    39.310     0.200
    14.673    38.917     0.200
    14.688    39.221     0.200
    14.703    39.424     0.200
    14.738    39.756     0.200
    14.741    39.779     0.200
    14.781    39.128     0.200
    14.835    40.108     0.200
    14.848    40.037     0.200
    14.853    39.446     0.200
    14.857    39.278     0.200
    14.898    39.315     0.200
    15.084    38.895     0.200
    15.112    39.433     0.200
    15.134    40.632     0.200
    15.155    39.879     0.200
    15.158    39.624     0.200
    15.231    39.502     0.200
    15.251    39.457     0.200
    15.308    39.605     0.200
    15.326    39.353     0.200
    15.328    39.636     0.200
    15.398    39.853     0.200
    15.445    39.100     0.200
    15.454    39.422     0.200
    15.506    40.410     0.200
    15.580    39.879     0.200
    15.587    39.621     0.200
    15.654    40.149     0.200
    15.730    39.110     0.200
    15.865    40.799     0.200
    15.907    39.808     0.200
    15.990    39.658     0.200
    15.989    39.216     0.200
    16.108    40.484     0.200
    16.125    40.599     0.200
    16.125    41.083     0.200
    16.185    39.946     0.200
    16.188    39.905     0.200
    16.409    40.512     0.200
    16.475    40.755     0.200
    16.478    41.028     0.200
    16.519    41.002     0.200
    16.576    41.264     0.200
    16.610    40.571     0.200
    16.618    40.187     0.200
    16.633    40.717     0.200
    16.700    41.247     0.200
    16.725    41.167     0.200
    17.022    41.235     0.200
    18.076    41.102     0.200
    18.076    41.219     0.200
    19.936    42.534     0.200
    20.043    43.445     0.200
    20.414    41.010     0.200
     1.012     7.308     0.200
     1.139     7.365     0.200
     1.156     6.232     0.200
     1.197     5.557     0.200
     1.354     6.014     0.200
     1.342     7.511     0.200
     1.384     8.218     0.200
     1.491     6.223     0.200
     1.491     6.356     0.200
     1.558     7.110     0.200
     1.701     7.036     0.200
     1.847     7.099     0.200
     1.937     7.546     0.200
     2.192     7.654     0.200
     2.336     8.077     0.200
     2.629     8.892     0.200
     2.761     9.417     0.200
     2.920     9.766     0.200
     2.939    10.344     0.200
     3.064    10.096     0.200
     3.312    10.581     0.200
     3.526    11.092     0.200
     3.558    14.049     0.200
     3.618    13.607     0.200
     3.879    11.673     0.200
     3.889    11.779     0.200
     4.482    15.767     0.200
     4.503    13.395     0.200
     4.650    13.565     0.200
     5.094    14.873     0.200
     5.164    14.770     0.200
     5.254    15.174     0.200
     5.658    16.110     0.200
     5.813    16.386     0.200
     6.932    19.733     0.200
     7.347    22.519     0.200
     7.797    23.305     0.200
    10.491    28.075     0.200
     1.021     5.483     0.200
     1.211     5.618     0.200
     1.361     6.121     0.200
     1.331     7.608     0.200
     1.374     8.540     0.200
     1.500     6.097     0.200
     1.500     6.583     0.200
     1.559     7.465     0.200
     1.649     6.856     0.200
     1.715     6.662     0.200
     1.860     7.289     0.200
     1.943     7.866     0.200
     2.105     8.009     0.200
     2.207     8.055     0.200
     2.193     7.798     0.200
     2.248     9.022     0.200
     2.350     8.664     0.200
     2.392     9.075     0.200
     2.455     8.856     0.200
     2.484     9.093     0.200
     2.521     8.935     0.200
     2.633    11.279     0.200
     2.634     9.060     0.200
     2.644     9.795     0.200
     2.762     9.778     0.200
     2.761     9.956     0.200
     2.801     9.500     0.200
     2.871    10.331     0.200
     2.875    10.495     0.200
     2.909     9.997     0.200
     2.890    12.011     0.200
     2.931     9.774     0.200
     2.944    13.846     0.200
     3.024    10.417     0.200
     3.068    10.335     0.200
     3.102    10.461     0.200
     3.102    12.149     0.200
     3.298    10.804     0.200
     3.291    11.086     0.200
     3.314    10.586     0.200
     3.336    11.050     0.200
     3.386    11.396     0.200
     3.405    10.813     0.200
     3.536    11.465     0.200
     3.533    11.753     0.200
     3.578    12.051     0.200
     3.564    13.575     0.200
     3.618    11.925     0.200
     3.618    13.357     0.200
     3.680    12.348     0.200
     3.735    13.745     0.200
     3.803    13.211     0.200
     3.851    12.189     0.200
     3.891    12.047     0.200
     3.923    14.535     0.200
     3.969    14.383     0.200
     3.970    12.051     0.200
     3.954    12.866     0.200
     4.031    12.668     0.200
     4.022    12.585     0.200
     4.053    13.943     0.200
     4.049    13.125     0.200
     4.124    13.214     0.200
     4.135    13.101     0.200
     4.177    14.133     0.200
     4.231    14.378     0.200
     4.265    15.378     0.200
     4.301    14.808     0.200
     4.344    15.121     0.200
     4.495    15.508     0.200
     4.508    13.782     0.200
     4.506    13.678     0.200
     4.534    14.034     0.200
     4.556    13.654     0.200
     4.599    14.632     0.200
     4.659    16.546     0.200
     4.651    14.108     0.200
     4.712    14.919     0.200
     4.786    15.161     0.200
     4.839    15.937     0.200
     4.955    15.909     0.200
     4.964    16.276     0.200
     5.028    16.709     0.200
     5.099    14.866     0.200
     5.167    17.436     0.200
     5.167    14.931     0.200
     5.175    14.871     0.200
     5.265    16.216     0.200
     5.256    15.345     0.200
     5.314    16.870     0.200
     5.344    17.929     0.200
     5.369    17.635     0.200
     5.491    18.101     0.200
     5.516    18.450     0.200
     5.540    18.471     0.200
     5.570    22.636     0.200
     5.592    18.160     0.200
     5.620    18.040     0.200
     5.662    16.551     0.200
     5.826    19.336     0.200
     5.895    17.708     0.200
     5.954    17.113     0.200
     6.008    19.869     0.200
     6.091    20.075     0.200
     6.152    20.104     0.200
     6.286    19.691     0.200
     6.373    20.320     0.200
     6.392    20.166     0.200
     6.425    20.344     0.200
     6.444    19.370     0.200
     6.485    20.490     0.200
     6.578    23.060     0.200
     6.583    20.674     0.200
     6.594    20.969     0.200
     6.620    20.985     0.200
     6.631    19.146     0.200
     6.742    21.405     0.200
     6.941    20.323     0.200
     7.038    21.076     0.200
     7.053    21.699     0.200
     7.076    21.601     0.200
     7.123    21.651     0.200
     7.205    21.472     0.200
     7.231    21.948     0.200
     7.359    23.583     0.200
     7.363    21.513     0.200
     7.484    22.239     0.200
     7.675    23.480     0.200
     7.713    24.314     0.200
     7.806    23.259     0.200
     7.806    23.124     0.200
     7.835    23.538     0.200
     7.920    25.043     0.200
     7.922    23.293     0.200
     7.997    23.004     0.200
     8.114    25.742     0.200
     8.124    27.742     0.200
     8.284    24.390     0.200
     8.394    23.818     0.200
     8.589    30.416     0.200
     8.719    29.159     0.200
     9.143    29.172     0.200
     9.286    26.174     0.200
     9.538    29.416     0.200
     9.633    27.095     0.200
    10.236    28.949     0.200
    10.310    30.407     0.200
    10.491    28.148     0.200
    10.748    31.593     0.200
    10.833    29.662     0.200
    10.978    33.915     0.200
    11.123    32.930     0.200
    11.271    32.488     0.200
    11.334    34.247     0.200
    11.457    32.607     0.200
    11.554    34.155     0.200
    11.575    34.942     0.200
    11.599    32.641     0.200
    11.633    32.157     0.200
    11.753    33.321     0.200
    12.735    37.566     0.200
    12.732    38.142     0.200
    12.753    38.031     0.200
    13.073    38.079     0.200
    13.403    36.209     0.200
    13.543    38.757     0.200
    13.600    39.712     0.200
    13.620    37.768     0.200
    13.760    39.392     0.200
    13.988    34.889     0.200
    14.179    35.254     0.200
    14.299    38.441     0.200
    14.406    37.860     0.200
    14.631    36.580     0.200
    15.081    38.512     0.200
    15.305    39.477     0.200
    15.847    38.091     0.200
    18.266    39.967     0.200
    19.284    43.141     0.200
    19.949    41.263     0.200
    20.962    41.414     0.200
     1.157     6.194     0.200
     1.198     5.583     0.200
     1.352     6.097     0.200
     1.343     7.195     0.200
     1.386     8.518     0.200
     1.414     8.595     0.200
     1.492     6.185     0.200
     1.560     7.413     0.200
     1.701     6.818     0.200
     1.846     7.251     0.200
     2.190     7.539     0.200
     2.196     7.962     0.200
     2.336     8.250     0.200
     2.469     9.296     0.200
     2.627     8.881     0.200
     2.619    10.535     0.200
     2.762     9.551     0.200
     2.792     9.744     0.200
     2.860     9.924     0.200
     2.894    10.303     0.200
     2.885    14.126     0.200
     2.919    10.188     0.200
     3.062    10.089     0.200
     3.280    11.767     0.200
     3.284    10.291     0.200
     3.311    10.189     0.200
     3.321    12.393     0.200
     3.372    11.211     0.200
     3.396    10.767     0.200
     3.525    12.015     0.200
     3.563    12.920     0.200
     3.665    12.891     0.200
     3.791    13.135     0.200
     3.846    11.910     0.200
     3.888    11.835     0.200
     3.960    12.623     0.200
     4.017    13.842     0.200
     4.039    13.720     0.200
     4.111    13.679     0.200
     4.104    13.814     0.200
     4.220    14.228     0.200
     4.251    13.798     0.200
     4.330    14.236     0.200
     4.482    16.085     0.200
     4.500    13.610     0.200
     4.528    13.827     0.200
     4.543    13.955     0.200
     4.648    13.294     0.200
     4.698    15.457     0.200
     5.162    14.936     0.200
     5.154    16.107     0.200
     5.153    16.951     0.200
     5.253    15.203     0.200
     5.656    16.470     0.200
     6.433    19.525     0.200
     6.563    23.505     0.200
     7.008    20.909     0.200
     7.346    23.747     0.200
     7.796    22.027     0.200
     7.906    25.889     0.200
     7.982    27.498     0.200
     8.270    25.444     0.200
     9.128    30.043     0.200
    10.489    27.319     0.200
    10.735    32.334     0.200
    11.257    33.675     0.200
    11.257    33.506     0.200
    11.319    34.160     0.200
    11.442    34.493     0.200
    13.399    35.698     0.200
    13.492    36.173     0.200
    20.801    40.938     0.200
     1.010     7.379     0.200
     1.201     5.548     0.200
     1.337     7.403     0.200
     1.359     6.113     0.200
     1.491     6.199     0.200
     1.555     7.443     0.200
     1.638     6.484     0.200
     1.705     6.881     0.200
     1.852     7.406     0.200
     1.936     8.046     0.200
     2.195     7.705     0.200
     2.203     8.242     0.200
     2.239     8.689     0.200
     2.339     8.475     0.200
     2.382     8.840     0.200
     2.449     9.116     0.200
     2.475     9.130     0.200
     2.511     9.232     0.200
     2.622    10.607     0.200
     2.636     9.923     0.200
     2.633     9.358     0.200
     2.758     9.663     0.200
     2.799     9.646     0.200
     2.864     9.676     0.200
     2.864    10.166     0.200
     2.899    10.450     0.200
     2.926    10.296     0.200
     3.013    10.476     0.200
     3.068     9.989     0.200
     3.282    11.677     0.200
     3.287    11.434     0.200
     3.287    11.579     0.200
     3.316    10.771     0.200
     3.327    12.361     0.200
     3.375    12.098     0.200
     3.403    10.662     0.200
     3.532    11.275     0.200
     3.557    15.703     0.200
     3.568    12.341     0.200
     3.670    13.150     0.200
     3.797    13.137     0.200
     3.851    12.555     0.200
     3.893    11.674     0.200
     3.966    12.087     0.200
     4.021    13.757     0.200
     4.108    13.773     0.200
     4.118    14.292     0.200
     4.126    13.845     0.200
     4.126    13.235     0.200
     4.227    13.547     0.200
     4.257    14.287     0.200
     4.290    14.707     0.200
     4.335    13.953     0.200
     4.506    14.448     0.200
     4.507    13.728     0.200
     4.534    13.766     0.200
     4.653    13.743     0.200
     4.702    15.190     0.200
     4.954    15.837     0.200
     5.156    16.718     0.200
     5.159    16.786     0.200
     5.168    15.016     0.200
     5.173    15.582     0.200
     5.254    16.649     0.200
     5.258    15.238     0.200
     5.311    16.738     0.200
     5.364    17.287     0.200
     5.662    16.046     0.200
     7.352    23.517     0.200
     7.802    22.924     0.200
     7.802    22.037     0.200
    10.494    27.361     0.200
    10.968    34.304     0.200
    11.262    33.908     0.200
    20.805    40.331     0.200
     0.444     3.396     0.200
     0.531     3.698     0.200
     0.697     4.661     0.200
     0.744     5.426     0.200
     1.170     6.304     0.200
     1.210     5.767     0.200
     1.344     6.119     0.200
     1.346     7.205     0.200
     1.390     8.272     0.200
     1.508     6.303     0.200
     1.574     7.397     0.200
     1.651     6.565     0.200
     1.711     6.897     0.200
     1.846     7.348     0.200
     1.954     7.599     0.200
     2.177     7.462     0.200
     2.191     8.225     0.200
     2.348     8.320     0.200
     2.440     8.930     0.200
     2.473     9.034     0.200
     2.629    11.025     0.200
     2.617     9.158     0.200
     2.776     9.630     0.200
     2.777     9.700     0.200
     2.785     9.575     0.200
     2.901    10.672     0.200
     2.915     9.394     0.200
     2.956    11.400     0.200
     3.023     9.887     0.200
     3.052     9.765     0.200
     3.278    11.505     0.200
     3.293    12.384     0.200
     3.388    10.617     0.200
     3.519    11.255     0.200
     3.570    13.023     0.200
     3.575    13.114     0.200
     3.669    12.856     0.200
     3.787    12.745     0.200
     3.834    11.327     0.200
     3.867    11.366     0.200
     3.875    11.692     0.200
     3.953    11.893     0.200
     4.026    13.407     0.200
     4.111    13.896     0.200
     4.110    14.262     0.200
     4.143    13.916     0.200
     4.161    12.602     0.200
     4.215    14.038     0.200
     4.253    14.976     0.200
     4.335    15.050     0.200
     4.481    15.621     0.200
     4.481    15.461     0.200
     4.491    13.458     0.200
     4.489    13.232     0.200
     4.517    13.136     0.200
     4.644    15.466     0.200
     4.635    13.246     0.200
     4.705    15.351     0.200
     4.782    15.558     0.200
     4.939    15.639     0.200
     5.057    17.100     0.200
     5.082    14.789     0.200
     5.162    17.128     0.200
     5.158    16.053     0.200
     5.240    14.836     0.200
     5.298    16.691     0.200
     5.353    17.394     0.200
     5.525    18.012     0.200
     5.604    17.885     0.200
     5.646    18.724     0.200
     5.645    15.952     0.200
     5.827    17.421     0.200
     5.863    19.263     0.200
     5.993    19.795     0.200
     6.136    19.357     0.200
     6.270    19.168     0.200
     6.472    20.697     0.200
     6.779    21.378     0.200
     7.018    20.696     0.200
     7.345    22.975     0.200
     7.345    22.698     0.200
     7.789    22.070     0.200
     8.281    27.458     0.200
    10.475    27.868     0.200
    10.983    34.007     0.200
     1.031     5.596     0.200
     1.144     6.854     0.200
     1.165     6.508     0.200
     1.212     5.561     0.200
     1.350     6.244     0.200
     1.339     7.243     0.200
     1.506     6.238     0.200
     1.506     6.620     0.200
     1.569     7.268     0.200
     1.714     6.887     0.200
     1.852     7.246     0.200
     1.951     7.773     0.200
     2.182     7.806     0.200
     2.197     8.150     0.200
     2.350     8.328     0.200
     2.624     9.225     0.200
     2.904    10.436     0.200
     2.921    10.417     0.200
     3.296    11.807     0.200
     3.304    10.609     0.200
     3.526    11.488     0.200
     3.572    16.343     0.200
     3.840    11.751     0.200
     3.873    11.864     0.200
     3.959    11.987     0.200
     4.487    15.121     0.200
     4.523    13.543     0.200
     4.640    13.816     0.200
     5.088    14.800     0.200
     5.245    15.248     0.200
     5.651    16.214     0.200
    10.481    27.401     0.200
    11.267    34.400     0.200
     0.732     4.040     0.200
     1.200     5.714     0.200
     1.360     6.198     0.200
     1.335     8.064     0.200
     1.460     6.474     0.200
     1.411     7.841     0.200
     1.490     6.261     0.200
     1.490     6.058     0.200
     1.554     7.477     0.200
     1.638     6.709     0.200
     1.704     7.079     0.200
     1.853     7.479     0.200
     1.935     7.609     0.200
     2.096     8.229     0.200
     2.091     8.249     0.200
     2.197     7.651     0.200
     2.237     8.273     0.200
     2.338     8.618     0.200
     2.382     8.797     0.200
     2.450     8.937     0.200
     2.475     9.382     0.200
     2.510     8.781     0.200
     2.622    10.579     0.200
     2.635     9.392     0.200
     2.635     9.423     0.200
     2.757     9.863     0.200
     2.782    10.254     0.200
     2.800     9.802     0.200
     2.864    10.022     0.200
     2.865     9.934     0.200
     2.881    11.250     0.200
     2.900    10.380     0.200
     2.927     9.885     0.200
     3.012    10.128     0.200
     3.091     9.907     0.200
     3.091    10.321     0.200
     3.070     9.768     0.200
     3.287    10.749     0.200
     3.288    10.689     0.200
     3.328    11.776     0.200
     3.318    10.112     0.200
     3.375    10.958     0.200
     3.404    10.712     0.200
     3.533    11.468     0.200
     3.568    12.687     0.200
     3.555    14.040     0.200
     3.613    13.906     0.200
     3.671    12.754     0.200
     3.728    13.343     0.200
     3.799    13.241     0.200
     3.853    10.506     0.200
     3.885    11.439     0.200
     3.894    11.718     0.200
     3.968    12.196     0.200
     4.021    13.039     0.200
     4.042    13.209     0.200
     4.109    13.327     0.200
     4.118    14.148     0.200
     4.125    12.531     0.200
     4.177    12.973     0.200
     4.228    13.505     0.200
     4.258    13.960     0.200
     4.335    14.278     0.200
     4.489    14.928     0.200
     4.508    13.642     0.200
     4.509    12.932     0.200
     4.545    13.695     0.200
     4.535    13.443     0.200
     4.655    15.126     0.200
     4.655    13.483     0.200
     4.702    14.706     0.200
     4.775    15.140     0.200
     4.954    15.952     0.200
     4.952    15.245     0.200
     5.100    14.724     0.200
     5.156    16.549     0.200
     5.160    16.238     0.200
     5.175    15.510     0.200
     5.169    14.408     0.200
     5.259    15.052     0.200
     5.313    16.297     0.200
     5.334    17.484     0.200
     5.479    16.703     0.200
     5.542    18.000     0.200
     5.551    17.327     0.200
     5.559    21.556     0.200
     5.616    17.432     0.200
     5.663    16.298     0.200
     5.815    18.142     0.200
     5.819    17.571     0.200
     5.883    17.739     0.200
     5.889    17.891     0.200
     5.942    17.667     0.200
     6.147    18.954     0.200
     6.414    19.387     0.200
     6.433    19.619     0.200
     6.479    20.153     0.200
     6.569    22.017     0.200
     6.573    19.625     0.200
     6.583    19.664     0.200
     6.622    21.998     0.200
     6.729    19.937     0.200
     6.931    20.891     0.200
     7.011    21.142     0.200
     7.040    20.036     0.200
     7.090    21.217     0.200
     7.121    20.471     0.200
     7.204    20.491     0.200
     7.230    21.464     0.200
     7.250    21.358     0.200
     7.352    22.292     0.200
     7.353    22.780     0.200
     7.483    20.746     0.200
     7.511    21.113     0.200
     7.518    22.700     0.200
     7.557    22.513     0.200
     7.602    23.836     0.200
     7.664    21.973     0.200
     7.704    23.489     0.200
     7.804    22.378     0.200
     7.804    22.182     0.200
     7.912    24.654     0.200
     7.915    23.807     0.200
     8.062    24.245     0.200
     8.103    24.812     0.200
     8.114    21.793     0.200
     8.273    22.227     0.200
     8.273    23.352     0.200
     8.296    23.659     0.200
     8.383    23.557     0.200
     8.579    24.372     0.200
     8.592    28.195     0.200
     8.653    25.764     0.200
     9.069    26.420     0.200
     9.132    25.785     0.200
     9.169    26.424     0.200
     9.288    25.897     0.200
     9.427    30.029     0.200
     9.528    25.367     0.200
     9.629    26.487     0.200
     9.963    26.500     0.200
    10.225    27.384     0.200
    10.299    29.587     0.200
    10.495    27.714     0.200
    10.742    29.275     0.200
    10.967    32.465     0.200
    10.967    30.005     0.200
    11.112    31.252     0.200
    11.262    31.346     0.200
    11.447    31.903     0.200
    11.632    30.934     0.200
    11.743    31.837     0.200
    11.837    32.680     0.200
    11.932    33.419     0.200
    12.473    35.551     0.200
    12.482    33.088     0.200
    12.504    37.397     0.200
    12.661    33.813     0.200
    12.725    37.711     0.200
    13.432    37.128     0.200
    13.406    33.721     0.200
    13.497    34.088     0.200
    13.533    36.255     0.200
    13.749    36.241     0.200
    13.987    33.795     0.200
    14.287    35.876     0.200
    14.395    36.543     0.200
    14.488    37.482     0.200
    14.528    38.441     0.200
    14.623    35.317     0.200
    14.835    36.800     0.200
    15.070    36.961     0.200
    15.113    38.899     0.200
    15.383    37.818     0.200
    15.423    39.690     0.200
    15.838    37.963     0.200
    15.849    39.818     0.200
    16.116    40.080     0.200
    16.273    38.434     0.200
    16.567    39.399     0.200
    16.872    39.270     0.200
    17.532    40.416     0.200
    18.071    40.116     0.200
    18.265    40.620     0.200
    20.068    44.769     0.200
     0.739     3.951     0.200
     1.204     5.612     0.200
     1.366     6.142     0.200
     1.329     6.835     0.200
     1.372     7.309     0.200
     1.466     6.238     0.200
     1.490     6.186     0.200
     1.406     7.738     0.200
     1.551     7.353     0.200
     1.640     6.646     0.200
     1.709     6.686     0.200
     1.859     7.332     0.200
     1.934     7.658     0.200
     2.102     8.188     0.200
     2.096     8.092     0.200
     2.210     8.226     0.200
     2.238     8.622     0.200
     2.201     7.599     0.200
     2.342     8.406     0.200
     2.387     8.752     0.200
     2.457     8.840     0.200
     2.481     9.150     0.200
     2.513     8.833     0.200
     2.627    10.457     0.200
     2.634     9.511     0.200
     2.640     9.320     0.200
     2.754     9.703     0.200
     2.806     9.522     0.200
     2.869     9.544     0.200
     2.871     9.782     0.200
     2.880    10.260     0.200
     2.906     9.877     0.200
     2.933     9.659     0.200
     2.935    13.613     0.200
     3.016     9.932     0.200
     3.093    10.045     0.200
     3.093    10.148     0.200
     3.075     9.663     0.200
     3.292    10.587     0.200
     3.281    10.843     0.200
     3.294    11.021     0.200
     3.379    11.364     0.200
     3.322    10.043     0.200
     3.410    10.618     0.200
     3.539    11.347     0.200
     3.574    12.800     0.200
     3.554    13.614     0.200
     3.610    13.070     0.200
     3.677    12.969     0.200
     3.735    12.194     0.200
     3.805    12.425     0.200
     3.858    12.117     0.200
     3.890    11.776     0.200
     3.898    11.801     0.200
     3.945    12.052     0.200
     3.974    12.080     0.200
     4.013    12.075     0.200
     4.026    12.341     0.200
     4.042    12.493     0.200
     4.047    13.366     0.200
     4.114    12.724     0.200
     4.126    12.327     0.200
     4.126    12.646     0.200
     4.125    13.672     0.200
     4.183    12.816     0.200
     4.234    13.798     0.200
     4.264    14.565     0.200
     4.295    14.418     0.200
     4.341    14.801     0.200
     4.495    15.345     0.200
     4.495    14.984     0.200
     4.513    13.360     0.200
     4.513    12.942     0.200
     4.540    13.458     0.200
     4.661    15.283     0.200
     4.708    15.213     0.200
     4.659    13.648     0.200
     4.779    15.187     0.200
     4.960    15.982     0.200
     4.958    15.384     0.200
     5.070    16.611     0.200
     5.105    14.603     0.200
     5.161    16.838     0.200
     5.166    16.942     0.200
     5.180    15.658     0.200
     5.174    14.356     0.200
     5.260    16.350     0.200
     5.263    14.673     0.200
     5.340    16.858     0.200
     5.319    16.391     0.200
     5.372    17.179     0.200
     5.515    17.433     0.200
     5.547    17.197     0.200
     5.555    17.248     0.200
     5.541    17.788     0.200
     5.622    17.432     0.200
     5.659    18.714     0.200
     5.668    16.060     0.200
     5.756    19.111     0.200
     5.825    18.038     0.200
     5.874    19.263     0.200
     5.888    17.588     0.200
     5.894    18.009     0.200
     6.008    19.781     0.200
     6.154    19.092     0.200
     6.289    18.561     0.200
     6.372    20.350     0.200
     6.418    19.685     0.200
     6.485    20.391     0.200
     6.574    23.080     0.200
     6.578    19.375     0.200
     6.621    19.104     0.200
     6.735    19.993     0.200
     6.820    21.738     0.200
     6.901    24.847     0.200
     6.932    18.210     0.200
     7.016    20.807     0.200
     7.095    21.463     0.200
     7.127    20.268     0.200
     7.210    20.706     0.200
     7.236    20.955     0.200
     7.255    21.338     0.200
     7.360    23.105     0.200
     7.489    20.703     0.200
     7.517    20.994     0.200
     7.711    22.462     0.200
     7.810    22.467     0.200
     7.810    21.896     0.200
     7.919    24.521     0.200
     7.922    23.836     0.200
     7.939    21.601     0.200
     8.120    22.895     0.200
     8.278    23.205     0.200
     8.278    22.785     0.200
     8.584    26.836     0.200
     8.598    28.481     0.200
     8.658    27.323     0.200
     8.715    30.633     0.200
     9.138    24.556     0.200
     9.293    25.506     0.200
     9.533    24.034     0.200
     9.425    29.358     0.200
     9.635    26.495     0.200
    10.302    31.789     0.200
    10.499    27.832     0.200
    10.748    31.201     0.200
    10.829    30.681     0.200
    10.969    33.091     0.200
    11.117    32.201     0.200
    11.268    33.729     0.200
    11.268    33.608     0.200
    11.330    32.379     0.200
    11.452    32.107     0.200
    11.549    32.656     0.200
    11.595    30.122     0.200
    11.638    30.571     0.200
    11.748    31.280     0.200
    11.842    33.366     0.200
    11.937    33.214     0.200
    12.509    37.062     0.200
    12.667    36.262     0.200
    12.695    34.066     0.200
    13.067    37.432     0.200
    13.411    35.363     0.200
    13.503    36.303     0.200
    13.538    37.640     0.200
    13.752    33.528     0.200
    13.993    33.980     0.200
    14.291    35.641     0.200
    14.629    35.159     0.200
    18.506    39.582     0.200
    20.968    39.462     0.200
     1.254     5.777     0.200
     1.319     7.463     0.200
     1.357     6.361     0.200
     1.366     7.743     0.200
     1.359     8.346     0.200
     1.499     6.285     0.200
     1.542     6.438     0.200
     1.586     7.723     0.200
     1.607     6.977     0.200
     1.693     6.664     0.200
     1.756     7.074     0.200
     1.881     7.501     0.200
     1.980     7.871     0.200
     2.083     8.245     0.200
     2.135     8.186     0.200
     2.170     7.859     0.200
     2.212     8.430     0.200
     2.393     8.725     0.200
     2.429     9.011     0.200
     2.470     9.136     0.200
     2.513     9.301     0.200
     2.565     9.220     0.200
     2.674    10.523     0.200
     2.625     9.450     0.200
     2.683     9.873     0.200
     2.791    10.295     0.200
     2.785    10.791     0.200
     2.801     9.820     0.200
     2.891    10.379     0.200
     2.914    10.646     0.200
     2.927    10.274     0.200
     2.941    10.597     0.200
     2.941     9.887     0.200
     3.067    10.643     0.200
     3.056     9.926     0.200
     3.146    12.270     0.200
     3.146    10.794     0.200
     3.295    10.288     0.200
     3.601    11.621     0.200
     3.642    10.847     0.200
     3.836    10.535     0.200
     4.095    13.887     0.200
     4.177    14.886     0.200
     4.514    15.269     0.200
     5.380    16.927     0.200
     5.588    16.989     0.200
     6.611    23.120     0.200
     6.984    20.836     0.200
     7.122    20.298     0.200
     7.203    20.928     0.200
     7.377    23.564     0.200
     7.481    20.885     0.200
     7.510    21.097     0.200
     7.643    23.420     0.200
     7.743    23.137     0.200
     7.807    22.922     0.200
     7.807    22.516     0.200
     7.943    24.294     0.200
     7.943    24.669     0.200
     7.997    27.098     0.200
     8.158    23.803     0.200
     8.158    26.853     0.200
     8.326    23.596     0.200
     8.436    23.656     0.200
     8.483    23.266     0.200
     8.625    25.398     0.200
     8.636    26.807     0.200
     8.701    25.518     0.200
     8.753    27.415     0.200
     8.755    28.875     0.200
     8.988    24.850     0.200
     9.180    28.521     0.200
     9.273    26.208     0.200
     9.372    26.975     0.200
     9.576    26.934     0.200
     9.646    27.382     0.200
    10.354    29.612     0.200
    10.768    31.796     0.200
    10.869    32.751     0.200
    11.021    34.850     0.200
    11.305    32.920     0.200
    11.305    32.778     0.200
    11.300    31.963     0.200
    11.371    33.046     0.200
    11.492    33.195     0.200
    11.590    33.725     0.200
    11.610    33.234     0.200
    11.636    33.575     0.200
    11.630    31.804     0.200
    11.788    32.577     0.200
    11.883    33.728     0.200
    11.978    34.290     0.200
    12.529    36.386     0.200
    12.554    36.900     0.200
    12.708    34.739     0.200
    12.735    38.051     0.200
    12.773    37.386     0.200
    12.814    36.129     0.200
    13.112    38.134     0.200
    13.386    36.172     0.200
    13.481    38.092     0.200
    13.542    36.097     0.200
    13.582    36.416     0.200
    13.805    39.735     0.200
    14.064    35.988     0.200
    14.447    37.745     0.200
    14.579    39.448     0.200
    14.886    38.053     0.200
    15.122    39.059     0.200
    15.169    39.651     0.200
    15.192    40.073     0.200
    15.346    39.473     0.200
    15.474    39.155     0.200
    15.880    39.334     0.200
    16.578    39.052     0.200
    16.672    40.035     0.200
    16.853    39.484     0.200
    18.260    40.394     0.200
    18.523    41.914     0.200
    19.960    44.077     0.200
     0.721     3.817     0.200
     0.744     3.972     0.200
     1.110     5.687     0.200
     1.203     6.578     0.200
     1.269     5.826     0.200
     1.303     5.506     0.200
     1.364     8.248     0.200
     1.358     7.622     0.200
     1.482     6.215     0.200
     1.561     6.467     0.200
     1.586     6.433     0.200
     1.586     6.331     0.200
     1.645     7.096     0.200
     1.722     6.673     0.200
     1.760     6.684     0.200
     1.849     6.711     0.200
     2.026     7.987     0.200
     2.032     7.664     0.200
     2.110     7.457     0.200
     2.163     7.755     0.200
     2.567     8.476     0.200
     2.679    10.773     0.200
     2.979    11.883     0.200
     2.998     9.814     0.200
     3.235    10.137     0.200
     3.253    10.796     0.200
     3.268    11.040     0.200
     3.338    10.094     0.200
     3.340     9.742     0.200
     3.490    10.306     0.200
     3.604    10.688     0.200
     3.653    14.767     0.200
     3.688    10.815     0.200
     3.776    11.470     0.200
     3.812    10.791     0.200
     3.810    11.257     0.200
     3.917    11.927     0.200
     4.070    11.464     0.200
     4.102    13.888     0.200
     4.148    12.842     0.200
     4.190    12.005     0.200
     4.262    12.904     0.200
     4.428    13.341     0.200
     4.444    12.371     0.200
     4.464    13.277     0.200
     4.478    15.629     0.200
     4.569    13.669     0.200
     4.902    15.663     0.200
     4.984    16.254     0.200
     5.030    13.720     0.200
     5.112    15.748     0.200
     5.180    17.437     0.200
     5.174    14.613     0.200
     5.260    16.428     0.200
     5.333    16.041     0.200
     5.371    17.724     0.200
     5.377    15.875     0.200
     5.719    15.903     0.200
     6.307    16.726     0.200
     6.439    19.280     0.200
     6.473    20.370     0.200
     6.547    19.842     0.200
     7.148    20.643     0.200
     7.339    23.007     0.200
     7.339    22.531     0.200
     7.426    21.814     0.200
     7.721    23.265     0.200
     7.755    23.297     0.200
     7.967    24.418     0.200
     8.145    23.148     0.200
     8.402    22.224     0.200
     8.443    23.838     0.200
     8.990    27.168     0.200
     9.653    26.262     0.200
    10.407    28.163     0.200
     0.705     4.705     0.200
     0.935     4.614     0.200
     1.268     7.931     0.200
     1.674     6.772     0.200
     2.856    11.442     0.200
     3.027    12.353     0.200
     3.305    13.133     0.200
     3.863    12.078     0.200
     4.307    15.557     0.200
     4.659    16.421     0.200
     5.560    17.816     0.200
     6.788    23.994     0.200
     7.204    21.211     0.200
     7.278    21.591     0.200
     7.517    23.247     0.200
     7.555    21.705     0.200
     7.588    22.132     0.200
     7.897    22.581     0.200
     7.913    23.099     0.200
     8.094    23.972     0.200
     8.098    25.127     0.200
     8.480    22.783     0.200
     9.773    28.428     0.200
    10.447    28.638     0.200
    11.481    34.041     0.200
     1.187     8.041     0.200
     1.293     5.914     0.200
     1.325     6.185     0.200
     1.512     6.327     0.200
     1.587     6.822     0.200
     1.596     6.503     0.200
     1.596     6.331     0.200
     1.639     7.900     0.200
     1.741     6.951     0.200
     1.787     7.050     0.200
     1.879     7.458     0.200
     2.046     7.937     0.200
     2.120     7.639     0.200
     2.146     8.054     0.200
     2.188     8.209     0.200
     2.433     8.720     0.200
     2.453     9.032     0.200
     2.458     9.232     0.200
     2.522     9.085     0.200
     2.585     9.300     0.200
     2.613     9.190     0.200
     2.706    10.664     0.200
     2.771     9.836     0.200
     2.922     9.593     0.200
     2.984    10.891     0.200
     3.109    10.221     0.200
     3.195    11.313     0.200
     3.247    10.446     0.200
     3.367    10.968     0.200
     3.371    10.894     0.200
     3.464    11.954     0.200
     3.515    11.467     0.200
     3.634    12.854     0.200
     3.658    11.386     0.200
     3.718    12.886     0.200
     3.791    11.545     0.200
     3.795    12.615     0.200
     3.821    11.922     0.200
     3.829    12.329     0.200
     3.940    12.039     0.200
     4.128    13.926     0.200
     4.138    13.537     0.200
     4.177    13.917     0.200
     4.215    14.181     0.200
     4.232    14.100     0.200
     4.292    14.860     0.200
     4.392    14.774     0.200
     4.441    13.538     0.200
     4.507    15.148     0.200
     4.579    13.772     0.200
     4.609    14.684     0.200
     4.736    15.469     0.200
     4.861    15.652     0.200
     5.104    14.595     0.200
     5.184    15.264     0.200
     5.210    16.734     0.200
     5.283    16.656     0.200
     5.400    17.781     0.200
     5.607    16.126     0.200
     5.610    17.477     0.200
     7.005    19.701     0.200
     7.038    20.380     0.200
     7.091    20.645     0.200
     7.170    20.998     0.200
     7.367    23.172     0.200
     7.448    21.163     0.200
     7.478    21.536     0.200
     7.656    22.041     0.200
     7.778    22.303     0.200
     7.778    23.108     0.200
     7.939    23.730     0.200
     7.941    25.059     0.200
     7.997    20.934     0.200
     8.416    22.677     0.200
     8.652    27.162     0.200
     8.726    25.936     0.200
     8.771    27.419     0.200
     9.203    29.444     0.200
     9.229    26.354     0.200
     9.563    29.208     0.200
     9.601    28.156     0.200
     9.631    27.364     0.200
     9.635    23.758     0.200
     9.682    29.638     0.200
    10.415    28.559     0.200
    10.762    31.755     0.200
    11.196    35.094     0.200
    11.320    29.654     0.200
    11.320    33.747     0.200
    11.393    33.507     0.200
    11.513    33.892     0.200
    11.597    29.792     0.200
    11.611    33.924     0.200
    11.631    33.401     0.200
    11.809    33.927     0.200
    11.903    31.360     0.200
    12.000    34.561     0.200
    12.230    34.950     0.200
    12.582    38.041     0.200
    12.823    38.367     0.200
    13.139    38.904     0.200
    13.145    38.815     0.200
    13.339    36.085     0.200
    13.506    37.654     0.200
    13.561    36.409     0.200
    13.610    38.335     0.200
    13.852    38.543     0.200
    13.949    36.239     0.200
    14.478    38.422     0.200
    14.662    38.366     0.200
    16.233    33.862     0.200
    16.594    38.152     0.200
    18.125    39.339     0.200
    18.514    39.619     0.200
    20.912    40.528     0.200
     0.795     4.126     0.200
     0.795     3.642     0.200
     0.965     4.539     0.200
     1.253     5.749     0.200
     1.279     7.209     0.200
     1.324     8.353     0.200
     1.354     7.995     0.200
     1.403     6.271     0.200
     1.514     6.452     0.200
     1.514     6.319     0.200
     1.522     6.322     0.200
     1.541     7.605     0.200
     1.649     6.699     0.200
     1.680     6.774     0.200
     1.762     7.158     0.200
     1.944     7.814     0.200
     2.130     8.285     0.200
     2.159     8.013     0.200
     2.216     7.815     0.200
     2.255     8.082     0.200
     2.265     9.214     0.200
     2.389     8.677     0.200
     2.443     8.988     0.200
     2.508     9.114     0.200
     2.552     9.383     0.200
     2.651     9.848     0.200
     2.679    10.712     0.200
     2.672     9.424     0.200
     2.739     9.885     0.200
     2.748     9.728     0.200
     2.846     9.465     0.200
     2.892     9.616     0.200
     2.962     9.847     0.200
     2.981    10.137     0.200
     3.062    10.176     0.200
     3.092    10.668     0.200
     3.104     9.766     0.200
     3.130    10.585     0.200
     3.302    11.193     0.200
     3.342    10.165     0.200
     3.533    11.180     0.200
     3.566    11.348     0.200
     3.566    12.512     0.200
     3.584    11.399     0.200
     3.622    11.679     0.200
     3.854    12.974     0.200
     3.883    10.859     0.200
     3.918    11.516     0.200
     3.916    11.491     0.200
     3.961    12.900     0.200
     4.015    12.318     0.200
     4.048    12.523     0.200
     4.150    12.816     0.200
     4.150    13.121     0.200
     4.177    13.415     0.200
     4.219    13.145     0.200
     4.280    13.807     0.200
     4.320    14.657     0.200
     4.459    14.427     0.200
     4.549    15.415     0.200
     4.549    15.986     0.200
     4.535    13.095     0.200
     4.547    14.043     0.200
     4.675    13.612     0.200
     4.686    14.280     0.200
     4.821    14.606     0.200
     4.977    16.116     0.200
     5.003    16.158     0.200
     5.124    17.332     0.200
     5.136    15.138     0.200
     5.197    14.486     0.200
     5.215    15.920     0.200
     5.280    15.084     0.200
     5.359    16.720     0.200
     5.396    17.378     0.200
     5.420    17.704     0.200
     5.594    23.097     0.200
     5.592    18.769     0.200
     5.603    17.663     0.200
     5.670    17.664     0.200
     5.697    16.308     0.200
     5.755    17.179     0.200
     5.826    16.923     0.200
     5.879    18.088     0.200
     5.930    19.018     0.200
     5.937    18.127     0.200
     6.056    18.439     0.200
     6.128    19.124     0.200
     6.145    19.306     0.200
     6.203    19.608     0.200
     6.335    19.520     0.200
     6.407    20.069     0.200
     6.428    20.327     0.200
     6.413    18.254     0.200
     6.448    18.279     0.200
     6.540    20.323     0.200
     6.543    19.327     0.200
     6.631    21.073     0.200
     6.636    18.791     0.200
     6.648    19.997     0.200
     6.655    20.868     0.200
     6.662    20.007     0.200
     6.674    20.950     0.200
     6.875    21.889     0.200
     6.912    21.810     0.200
     6.958    20.680     0.200
     7.074    20.374     0.200
     7.107    21.695     0.200
     7.128    20.325     0.200
     7.168    21.167     0.200
     7.213    20.537     0.200
     7.249    20.894     0.200
     7.257    21.967     0.200
     7.274    21.827     0.200
     7.345    22.794     0.200
     7.413    22.744     0.200
     7.413    23.236     0.200
     7.459    23.319     0.200
     7.527    21.755     0.200
     7.533    23.123     0.200
     7.556    21.353     0.200
     7.665    23.294     0.200
     7.710    23.155     0.200
     7.697    21.009     0.200
     7.740    21.830     0.200
     7.750    23.039     0.200
     7.767    22.624     0.200
     7.767    22.101     0.200
     7.839    23.133     0.200
     7.852    21.722     0.200
     7.852    21.597     0.200
     7.893    23.240     0.200
     7.912    22.169     0.200
     7.926    23.436     0.200
     7.959    21.508     0.200
     7.974    24.763     0.200
     7.976    23.681     0.200
     7.973    22.823     0.200
     7.993    23.852     0.200
     8.047    24.436     0.200
     8.047    26.725     0.200
     8.079    24.104     0.200
     8.123    24.722     0.200
     8.134    24.384     0.200
     8.152    25.144     0.200
     8.155    23.899     0.200
     8.176    27.297     0.200
     8.204    22.688     0.200
     8.212    24.413     0.200
     8.320    23.441     0.200
     8.352    23.389     0.200
     8.350    21.933     0.200
     8.391    25.210     0.200
     8.378    22.130     0.200
     8.460    22.327     0.200
     8.468    22.830     0.200
     8.539    24.829     0.200
     8.576    24.650     0.200
     8.628    27.064     0.200
     8.655    27.017     0.200
     8.709    26.238     0.200
     8.713    25.074     0.200
     8.728    26.626     0.200
     8.752    24.613     0.200
     8.771    25.168     0.200
     8.798    25.424     0.200
     8.878    25.803     0.200
     8.903    24.233     0.200
     8.939    24.575     0.200
     8.960    27.684     0.200
     8.966    25.910     0.200
     9.011    25.882     0.200
     9.008    25.540     0.200
     9.004    26.932     0.200
     9.025    27.359     0.200
     9.038    27.631     0.200
     9.063    26.921     0.200
     9.081    24.826     0.200
     9.195    26.069     0.200
     9.269    28.501     0.200
     9.342    28.339     0.200
     9.430    28.315     0.200
     9.503    26.365     0.200
     9.552    26.248     0.200
     9.553    26.609     0.200
     9.587    26.638     0.200
     9.588    26.061     0.200
     9.601    28.476     0.200
     9.624    27.296     0.200
     9.625    26.061     0.200
     9.678    29.020     0.200
     9.685    27.695     0.200
     9.702    28.056     0.200
     9.764    26.950     0.200
     9.750    26.553     0.200
     9.804    29.064     0.200
     9.825    27.912     0.200
     9.832    28.315     0.200
     9.833    26.636     0.200
     9.876    28.548     0.200
     9.892    27.100     0.200
     9.896    29.379     0.200
     9.936    29.527     0.200
    10.006    28.644     0.200
    10.067    28.506     0.200
    10.055    27.292     0.200
    10.096    29.639     0.200
    10.111    28.658     0.200
    10.146    27.446     0.200
    10.167    29.191     0.200
    10.177    30.370     0.200
    10.202    29.917     0.200
    10.275    29.148     0.200
    10.267    29.044     0.200
    10.321    30.579     0.200
    10.311    25.576     0.200
    10.322    27.437     0.200
    10.354    30.086     0.200
    10.342    30.678     0.200
    10.386    29.998     0.200
    10.397    30.852     0.200
    10.398    31.784     0.200
    10.412    32.579     0.200
    10.456    30.350     0.200
    10.488    29.334     0.200
    10.516    30.574     0.200
    10.512    28.125     0.200
    10.578    30.314     0.200
    10.588    28.931     0.200
    10.674    30.501     0.200
    10.701    28.887     0.200
    10.728    29.106     0.200
    10.799    31.652     0.200
    10.802    31.898     0.200
    10.802    30.866     0.200
    10.884    31.970     0.200
    10.899    31.931     0.200
    10.916    32.010     0.200
    10.951    29.343     0.200
    11.002    32.135     0.200
    11.002    33.493     0.200
    11.002    32.587     0.200
    10.995    30.074     0.200
    11.019    31.369     0.200
    11.023    31.420     0.200
    11.056    29.937     0.200
    11.104    29.055     0.200
    11.169    32.608     0.200
    11.192    31.240     0.200
    11.222    30.855     0.200
    11.252    31.077     0.200
    11.324    33.411     0.200
    11.324    30.722     0.200
    11.359    32.482     0.200
    11.377    33.172     0.200
    11.385    33.491     0.200
    11.508    32.970     0.200
    11.537    32.830     0.200
    11.588    32.488     0.200
    11.605    33.520     0.200
    11.607    33.770     0.200
    11.615    32.249     0.200
    11.654    31.868     0.200
    11.804    32.794     0.200
    11.855    32.498     0.200
    11.898    30.740     0.200
    11.935    31.246     0.200
    11.956    31.904     0.200
    11.993    34.349     0.200
    12.100    34.190     0.200
    12.104    35.571     0.200
    12.136    34.687     0.200
    12.176    35.994     0.200
    12.224    34.361     0.200
    12.297    35.576     0.200
    12.373    33.948     0.200
    12.400    33.242     0.200
    12.543    32.519     0.200
    12.584    33.905     0.200
    12.698    34.394     0.200
    12.704    36.006     0.200
    12.709    36.468     0.200
    12.722    34.668     0.200
    12.767    35.633     0.200
    12.942    33.269     0.200
    13.033    33.072     0.200
    13.039    36.071     0.200
    13.040    34.986     0.200
    13.224    34.895     0.200
    13.337    37.503     0.200
    13.365    36.627     0.200
    13.393    35.959     0.200
    13.394    36.334     0.200
    13.425    35.537     0.200
    13.433    33.195     0.200
    13.433    36.523     0.200
    13.452    36.785     0.200
    13.482    36.888     0.200
    13.492    37.909     0.200
    13.492    37.721     0.200
    13.559    36.837     0.200
    13.559    37.048     0.200
    13.591    38.367     0.200
    13.604    36.261     0.200
    13.662    35.387     0.200
    13.954    35.684     0.200
    13.968    37.939     0.200
    14.052    38.251     0.200
    14.071    37.845     0.200
    14.162    38.617     0.200
    14.255    38.538     0.200
    14.347    38.424     0.200
    14.397    35.491     0.200
    14.452    38.186     0.200
    14.452    35.467     0.200
    14.498    37.176     0.200
    14.552    38.309     0.200
    14.586    38.887     0.200
    14.685    36.527     0.200
    14.732    37.668     0.200
    14.754    37.761     0.200
    14.784    38.967     0.200
    14.841    38.162     0.200
    14.892    38.375     0.200
    14.926    37.341     0.200
    14.933    38.543     0.200
    15.127    38.489     0.200
    15.143    38.244     0.200
    15.187    39.221     0.200
    15.273    38.267     0.200
    15.499    38.921     0.200
    15.557    38.218     0.200
    15.679    38.546     0.200
    15.778    38.758     0.200
    15.900    39.126     0.200
    15.900    37.548     0.200
    15.901    38.255     0.200
    16.021    38.102     0.200
    16.036    37.885     0.200
    16.052    37.982     0.200
    16.061    38.010     0.200
    16.318    38.750     0.200
    16.517    38.875     0.200
    16.619    38.911     0.200
    16.755    37.841     0.200
    16.945    39.031     0.200
    17.389    39.355     0.200
    17.392    39.267     0.200
    17.747    39.760     0.200
    18.133    36.473     0.200
    18.307    39.344     0.200
    18.559    40.700     0.200
     0.773     3.935     0.200
     1.272     6.748     0.200
     1.332     6.125     0.200
     2.555    10.271     0.200
     2.712    10.796     0.200
     3.386    11.362     0.200
     3.967    11.625     0.200
     4.006    11.578     0.200
     4.543    15.490     0.200
     5.417    17.069     0.200
     6.454    18.799     0.200
     6.777    18.618     0.200
     7.328    21.195     0.200
     7.574    20.694     0.200
     7.608    21.610     0.200
     7.633    21.762     0.200
     7.916    22.737     0.200
     7.916    21.817     0.200
     8.635    22.626     0.200
     9.842    25.525     0.200
    10.662    28.040     0.200
     1.187     7.479     0.200
     1.238     6.884     0.200
     1.333     6.279     0.200
     1.321     6.019     0.200
     1.302     7.636     0.200
     1.323     7.543     0.200
     1.378     8.322     0.200
     1.537     6.491     0.200
     1.619     6.426     0.200
     1.767     7.061     0.200
     1.815     7.359     0.200
     2.054     8.248     0.200
     2.114     7.677     0.200
     2.201     8.453     0.200
     2.460     8.939     0.200
     2.734    11.202     0.200
     2.759    10.109     0.200
     3.002    11.404     0.200
     3.055    12.547     0.200
     3.791    11.555     0.200
     4.254    15.311     0.200
     4.526    15.485     0.200
     5.427    17.941     0.200
     5.637    18.124     0.200
     6.521    20.950     0.200
     6.653    23.807     0.200
     7.100    21.582     0.200
     7.178    21.093     0.200
     7.386    22.803     0.200
     7.455    21.475     0.200
     7.486    21.755     0.200
     7.682    24.962     0.200
     7.776    25.462     0.200
     7.788    22.876     0.200
     7.788    22.276     0.200
     8.084    24.766     0.200
     8.388    23.777     0.200
     8.414    22.609     0.200
     8.797    23.455     0.200
     9.230    25.103     0.200
     9.583    27.952     0.200
     9.636    27.452     0.200
    10.408    28.487     0.200
    10.782    31.759     0.200
    11.224    33.915     0.200
    11.346    28.952     0.200
    11.346    32.261     0.200
    11.420    34.838     0.200
    11.605    33.960     0.200
    11.638    34.896     0.200
    11.930    35.371     0.200
    13.955    37.447     0.200
    14.637    36.643     0.200
    14.685    36.725     0.200
    14.945    38.372     0.200
    15.497    37.050     0.200
    15.969    38.512     0.200
     1.037     5.872     0.200
     1.200     6.142     0.200
     1.200     5.986     0.200
     1.403     8.084     0.200
     1.553     7.331     0.200
     1.618     7.493     0.200
     1.775     7.722     0.200
     1.896     8.484     0.200
     1.916     8.063     0.200
     2.610    10.694     0.200
     2.648     9.892     0.200
     2.914    14.343     0.200
     3.000    12.861     0.200
     3.306    12.467     0.200
     3.541    15.374     0.200
     4.187    12.640     0.200
     4.216    14.963     0.200
     4.959    17.923     0.200
     5.759    19.050     0.200
     5.962    20.127     0.200
     6.626    21.207     0.200
     6.646    22.352     0.200
     6.989    22.375     0.200
     7.009    25.448     0.200
     7.037    24.359     0.200
     7.539    23.284     0.200
     7.614    22.953     0.200
     7.823    24.644     0.200
     7.890    23.907     0.200
     8.161    26.302     0.200
     8.232    22.758     0.200
     9.627    27.261     0.200
    10.011    30.735     0.200
    10.735    29.061     0.200
    11.702    33.682     0.200
    14.759    37.189     0.200
     1.178     5.170     0.200
     1.199     7.471     0.200
     1.210     7.320     0.200
     1.286     5.998     0.200
     1.342     6.188     0.200
     1.323     8.251     0.200
     1.333     7.564     0.200
     1.333     7.316     0.200
     1.390     5.733     0.200
     1.375     8.232     0.200
     1.413     7.136     0.200
     1.515     6.424     0.200
     1.528     8.047     0.200
     1.573     6.903     0.200
     1.580     6.784     0.200
     1.580     6.580     0.200
     1.620     7.121     0.200
     1.618     7.804     0.200
     1.641     7.253     0.200
     1.647     7.445     0.200
     1.703     7.317     0.200
     1.729     6.944     0.200
     1.783     7.297     0.200
     1.842     7.390     0.200
     1.923     7.746     0.200
     1.927     7.913     0.200
     2.017     8.132     0.200
     2.140     7.470     0.200
     2.150     8.286     0.200
     2.203     8.354     0.200
     2.425     8.979     0.200
     2.425     8.862     0.200
     2.469     9.503     0.200
     2.601     9.157     0.200
     2.721    10.002     0.200
     2.724    10.388     0.200
     2.965    13.049     0.200
     3.018    11.051     0.200
     3.100    10.426     0.200
     3.182    11.011     0.200
     3.611    11.514     0.200
     3.808    13.029     0.200
     3.811    10.791     0.200
     4.031    13.117     0.200
     4.103    12.619     0.200
     4.123    13.471     0.200
     4.123    13.055     0.200
     4.215    13.427     0.200
     4.215    13.091     0.200
     4.517    15.477     0.200
     4.533    15.293     0.200
     4.742    15.775     0.200
     4.952    15.638     0.200
     5.205    15.010     0.200
     5.237    16.242     0.200
     5.373    17.781     0.200
     5.373    17.461     0.200
     5.627    16.540     0.200
     5.689    16.777     0.200
     5.753    16.494     0.200
     5.842    16.963     0.200
     5.967    18.446     0.200
     5.967    18.009     0.200
     5.995    18.153     0.200
     6.283    19.023     0.200
     6.343    17.994     0.200
     6.343    18.244     0.200
     6.477    19.166     0.200
     6.586    19.847     0.200
     6.604    19.920     0.200
     6.609    20.254     0.200
     6.610    22.897     0.200
     6.707    18.959     0.200
     6.871    21.631     0.200
     6.940    19.002     0.200
     7.005    19.722     0.200
     6.991    21.406     0.200
     7.022    20.050     0.200
     7.061    20.273     0.200
     7.108    20.814     0.200
     7.150    20.447     0.200
     7.187    20.889     0.200
     7.209    22.587     0.200
     7.212    21.071     0.200
     7.237    22.222     0.200
     7.378    23.258     0.200
     7.378    23.156     0.200
     7.465    21.404     0.200
     7.489    22.727     0.200
     7.495    21.507     0.200
     7.628    20.985     0.200
     7.659    25.154     0.200
     7.756    23.142     0.200
     7.790    23.095     0.200
     7.795    22.902     0.200
     7.795    22.753     0.200
     7.862    23.547     0.200
     7.896    21.466     0.200
     7.998    23.581     0.200
     8.033    24.658     0.200
     8.056    21.603     0.200
     8.094    24.790     0.200
     8.099    24.429     0.200
     8.098    23.717     0.200
     8.191    24.137     0.200
     8.278    22.331     0.200
     8.309    21.876     0.200
     8.355    24.947     0.200
     8.387    22.301     0.200
     8.402    22.740     0.200
     8.404    22.816     0.200
     8.436    22.256     0.200
     8.491    24.530     0.200
     8.516    23.856     0.200
     8.654    27.461     0.200
     8.684    26.053     0.200
     8.697    26.309     0.200
     8.695    24.385     0.200
     8.725    24.260     0.200
     8.761    25.646     0.200
     8.830    23.605     0.200
     8.861    25.941     0.200
     8.868    24.094     0.200
     8.929    24.547     0.200
     8.941    24.439     0.200
     8.957    26.498     0.200
     8.981    24.909     0.200
     8.997    27.041     0.200
     9.017    24.652     0.200
     9.042    26.664     0.200
     9.093    26.442     0.200
     9.134    25.456     0.200
     9.249    26.235     0.200
     9.335    27.708     0.200
     9.335    28.419     0.200
     9.400    27.330     0.200
     9.426    26.525     0.200
     9.445    26.120     0.200
     9.550    28.166     0.200
     9.558    26.610     0.200
     9.606    29.057     0.200
     9.644    28.632     0.200
     9.655    26.624     0.200
     9.677    26.494     0.200
     9.758    26.670     0.200
     9.830    26.852     0.200
     9.861    27.214     0.200
     9.979    28.424     0.200
     9.979    27.306     0.200
    10.077    28.277     0.200
    10.077    27.106     0.200
    10.152    28.717     0.200
    10.236    27.150     0.200
    10.248    27.691     0.200
    10.316    28.092     0.200
    10.365    29.910     0.200
    10.438    30.137     0.200
    10.435    28.289     0.200
    10.435    28.281     0.200
    10.436    28.280     0.200
    10.491    29.002     0.200
    10.528    28.310     0.200
    10.609    29.960     0.200
    10.609    29.147     0.200
    10.625    28.603     0.200
    10.655    31.353     0.200
    10.741    30.883     0.200
    10.772    31.666     0.200
    10.772    31.041     0.200
    10.814    29.195     0.200
    10.877    29.395     0.200
    10.890    31.892     0.200
    11.028    29.198     0.200
    11.031    30.914     0.200
    11.038    29.549     0.200
    11.059    34.077     0.200
    11.322    32.926     0.200
    11.322    32.838     0.200
    11.322    32.838     0.200
    11.335    30.794     0.200
    11.462    31.720     0.200
    11.513    32.828     0.200
    11.564    30.770     0.200
    11.611    33.244     0.200
    11.631    33.719     0.200
    11.647    32.035     0.200
    11.680    30.302     0.200
    11.734    34.040     0.200
    11.904    34.077     0.200
    11.932    33.535     0.200
    11.946    32.230     0.200
    12.000    34.704     0.200
    12.034    32.424     0.200
    12.058    33.406     0.200
    12.087    33.066     0.200
    12.140    32.445     0.200
    12.157    32.949     0.200
    12.220    32.810     0.200
    12.231    31.283     0.200
    12.550    35.031     0.200
    12.579    33.913     0.200
    12.638    34.684     0.200
    12.682    33.661     0.200
    12.690    34.448     0.200
    12.731    35.544     0.200
    12.802    35.588     0.200
    12.849    36.760     0.200
    12.974    34.168     0.200
    12.974    35.176     0.200
    13.210    32.396     0.200
    13.210    35.606     0.200
    13.250    34.743     0.200
    13.289    35.308     0.200
    13.328    35.197     0.200
    13.350    36.585     0.200
    13.359    36.678     0.200
    13.359    36.147     0.200
    13.367    36.247     0.200
    13.372    35.378     0.200
    13.414    36.691     0.200
    13.562    36.539     0.200
    13.608    36.249     0.200
    13.663    36.790     0.200
    13.672    35.895     0.200
    13.689    36.152     0.200
    13.967    35.523     0.200
    14.085    35.284     0.200
    14.376    34.709     0.200
    14.474    38.059     0.200
    14.617    38.041     0.200
    14.668    36.019     0.200
    14.913    39.592     0.200
    14.930    38.929     0.200
    14.926    36.864     0.200
    14.936    39.385     0.200
    15.107    37.395     0.200
    15.107    38.317     0.200
    15.149    36.106     0.200
    15.204    38.289     0.200
    15.424    39.180     0.200
    15.515    38.096     0.200
    15.575    38.658     0.200
    15.896    38.684     0.200
    16.186    35.693     0.200
    16.365    39.064     0.200
    16.386    36.791     0.200
    16.519    39.985     0.200
    16.700    38.471     0.200
    16.827    39.860     0.200
    17.376    40.285     0.200
    17.496    39.887     0.200
    18.128    38.187     0.200
    18.525    41.839     0.200
    19.505    42.313     0.200
     1.194     5.202     0.200
     1.214     7.064     0.200
     1.188     7.524     0.200
     1.302     6.053     0.200
     1.316     6.005     0.200
     1.347     6.293     0.200
     1.315     8.212     0.200
     1.316     7.715     0.200
     1.317     7.750     0.200
     1.367     8.258     0.200
     1.530     6.430     0.200
     1.585     6.919     0.200
     1.593     6.635     0.200
     1.632     7.179     0.200
     1.624     7.884     0.200
     1.653     7.275     0.200
     1.657     7.506     0.200
     1.744     6.965     0.200
     1.799     7.367     0.200
     1.857     7.418     0.200
     1.934     7.784     0.200
     1.939     7.939     0.200
     2.028     8.095     0.200
     2.137     7.718     0.200
     2.210     8.342     0.200
     2.441     8.925     0.200
     2.480     9.179     0.200
     2.733    10.044     0.200
     2.735    10.386     0.200
     2.976    11.209     0.200
     3.029    14.392     0.200
     3.116    10.437     0.200
     3.198    11.997     0.200
     3.382    11.649     0.200
     3.817    13.303     0.200
     3.811    11.931     0.200
     4.043    12.957     0.200
     4.140    13.705     0.200
     4.137    13.098     0.200
     4.228    13.690     0.200
     4.228    12.984     0.200
     4.528    15.858     0.200
     4.543    14.764     0.200
     4.756    15.894     0.200
     4.959    15.323     0.200
     5.002    15.925     0.200
     5.202    15.518     0.200
     5.248    18.950     0.200
     5.382    17.669     0.200
     5.382    17.483     0.200
     5.417    17.623     0.200
     5.627    16.493     0.200
     5.691    16.931     0.200
     5.674    17.591     0.200
     5.752    17.417     0.200
     5.840    17.591     0.200
     5.983    19.088     0.200
     5.983    17.505     0.200
     5.999    18.266     0.200
     6.078    18.837     0.200
     6.291    18.672     0.200
     6.344    18.130     0.200
     6.480    19.174     0.200
     6.540    21.261     0.200
     6.559    18.977     0.200
     6.591    19.897     0.200
     6.626    19.582     0.200
     6.609    20.313     0.200
     6.618    20.322     0.200
     6.881    21.168     0.200
     7.006    20.554     0.200
     7.035    22.162     0.200
     7.064    20.036     0.200
     7.113    21.263     0.200
     7.154    20.515     0.200
     7.192    21.065     0.200
     7.216    20.586     0.200
     7.242    21.827     0.200
     7.352    24.024     0.200
     7.389    23.223     0.200
     7.389    22.765     0.200
     7.470    21.414     0.200
     7.498    22.416     0.200
     7.500    21.209     0.200
     7.675    26.173     0.200
     7.676    21.668     0.200
     7.801    23.109     0.200
     7.801    23.364     0.200
     7.821    22.780     0.200
     7.900    21.629     0.200
     8.014    26.727     0.200
     8.041    23.649     0.200
     8.072    21.712     0.200
     8.110    23.819     0.200
     8.105    23.312     0.200
     8.192    27.453     0.200
     8.278    22.450     0.200
     8.310    22.254     0.200
     8.371    21.612     0.200
     8.408    22.703     0.200
     8.405    22.581     0.200
     8.435    22.477     0.200
     8.499    24.007     0.200
     8.521    23.856     0.200
     8.701    23.905     0.200
     8.788    24.132     0.200
     8.828    24.007     0.200
     8.868    24.915     0.200
     8.927    25.023     0.200
     8.943    25.042     0.200
     8.982    24.908     0.200
     9.020    24.578     0.200
     9.138    25.506     0.200
     9.249    23.964     0.200
     9.411    27.047     0.200
     9.451    26.585     0.200
     9.584    27.968     0.200
     9.616    26.806     0.200
     9.619    27.916     0.200
     9.655    25.295     0.200
     9.756    27.169     0.200
     9.960    28.036     0.200
     9.975    27.206     0.200
    10.233    28.105     0.200
    10.431    28.211     0.200
    10.431    28.221     0.200
    10.612    27.130     0.200
    10.784    29.957     0.200
    11.647    32.014     0.200
    11.825    35.328     0.200
    12.016    35.019     0.200
    12.800    36.688     0.200
    13.153    37.576     0.200
    13.349    36.882     0.200
    13.358    36.461     0.200
    13.578    37.955     0.200
    13.606    36.703     0.200
    14.951    38.727     0.200
    15.108    35.475     0.200
    15.950    38.005     0.200
    16.826    38.311     0.200
     0.960     4.746     0.200
     1.223     6.939     0.200
     1.257     7.747     0.200
     1.697     7.041     0.200
     2.883    11.463     0.200
     3.045    13.175     0.200
     3.330    11.706     0.200
     3.717    13.515     0.200
     3.865    11.376     0.200
     4.304    14.567     0.200
     4.329    13.935     0.200
     4.679    16.076     0.200
     5.511    17.813     0.200
     5.587    18.295     0.200
     6.144    18.367     0.200
     6.564    19.807     0.200
     6.795    19.302     0.200
     7.287    21.376     0.200
     7.536    22.582     0.200
     7.564    21.184     0.200
     7.597    21.913     0.200
     7.785    24.683     0.200
     7.908    22.897     0.200
     8.115    24.847     0.200
     8.311    25.937     0.200
     8.481    22.292     0.200
     9.738    27.983     0.200
    10.442    29.245     0.200
    11.507    33.236     0.200
     0.998     5.161     0.200
     1.164     5.756     0.200
     1.250     6.800     0.200
     1.267     8.022     0.200
     1.362     6.296     0.200
     1.294     7.784     0.200
     1.291     8.143     0.200
     1.300     8.144     0.200
     1.432     6.498     0.200
     1.544     6.879     0.200
     1.587     7.022     0.200
     1.599     7.196     0.200
     1.624     8.975     0.200
     1.624     8.433     0.200
     2.232     8.546     0.200
     2.300     9.127     0.200
     2.502     8.591     0.200
     2.546     9.247     0.200
     2.799     9.864     0.200
     2.799    10.035     0.200
     2.950    10.448     0.200
     3.220    11.286     0.200
     3.798    11.985     0.200
     3.798    12.407     0.200
     3.850    13.234     0.200
     3.921    13.657     0.200
     4.123    11.989     0.200
     4.543    14.657     0.200
     4.543    15.000     0.200
     4.662    16.324     0.200
     5.102    16.565     0.200
     5.219    17.190     0.200
     5.433    16.509     0.200
     5.489    18.034     0.200
     5.489    18.175     0.200
     5.547    17.285     0.200
     5.670    17.071     0.200
     5.919    17.062     0.200
     5.950    17.707     0.200
     6.076    17.576     0.200
     6.105    20.818     0.200
     6.092    19.121     0.200
     6.211    18.758     0.200
     6.250    19.498     0.200
     6.460    23.114     0.200
     6.635    18.864     0.200
     6.716    21.055     0.200
     6.796    20.654     0.200
     6.804    20.450     0.200
     6.937    20.646     0.200
     7.218    22.965     0.200
     7.249    20.409     0.200
     7.332    22.355     0.200
     7.320    20.859     0.200
     7.376    21.308     0.200
     7.402    21.029     0.200
     7.435    22.123     0.200
     7.683    21.123     0.200
     7.921    23.206     0.200
     7.933    22.320     0.200
     7.977    22.889     0.200
     8.583    23.204     0.200
     8.591    22.823     0.200
     8.638    23.760     0.200
     8.661    23.248     0.200
     8.712    23.576     0.200
     8.753    23.317     0.200
     8.814    25.153     0.200
     9.155    24.655     0.200
     9.169    25.448     0.200
     9.202    25.040     0.200
     9.264    25.550     0.200
     9.348    25.926     0.200
    10.801    29.503     0.200
    10.849    28.497     0.200
    11.171    31.819     0.200
     1.011     5.566     0.200
     1.057     5.787     0.200
     1.312     6.466     0.200
     1.385     7.355     0.200
     1.459     7.312     0.200
     1.521     7.070     0.200
     1.671     9.633     0.200
     1.672     9.611     0.200
     1.742     7.799     0.200
     1.811     8.500     0.200
     2.091     8.680     0.200
     2.172     8.800     0.200
     2.408    11.766     0.200
     2.460    11.672     0.200
     2.514     9.783     0.200
     2.660     9.354     0.200
     2.673    10.096     0.200
     2.725    10.188     0.200
     3.684    12.727     0.200
     3.844    13.808     0.200
     4.281    13.105     0.200
     4.648    15.669     0.200
     5.252    17.967     0.200
     5.447    18.787     0.200
     5.489    18.177     0.200
     5.616    18.518     0.200
     6.499    20.986     0.200
     6.504    22.925     0.200
     6.791    19.893     0.200
     7.095    19.621     0.200
     7.454    22.316     0.200
     7.519    24.640     0.200
     7.549    22.032     0.200
     7.830    22.606     0.200
     7.955    25.446     0.200
     8.036    25.104     0.200
     8.118    23.063     0.200
     8.911    23.985     0.200
    10.999    32.582     0.200
     0.828     4.388     0.200
     0.924     5.033     0.200
     1.209     5.846     0.200
     1.198     6.235     0.200
     1.198     6.240     0.200
     1.285     5.839     0.200
     1.333     7.130     0.200
     1.443     6.196     0.200
     1.448     7.708     0.200
     1.504     7.602     0.200
     1.649     6.648     0.200
     1.757     7.067     0.200
     2.014     7.597     0.200
     2.014     7.232     0.200
     2.075     7.989     0.200
     2.423     8.792     0.200
     3.055    13.115     0.200
     3.112    14.242     0.200
     3.730    11.506     0.200
     4.100    14.067     0.200
     4.281    15.170     0.200
     4.408    15.461     0.200
     4.408    15.599     0.200
     4.656    15.905     0.200
     5.249    17.185     0.200
     5.343    17.386     0.200
     5.555    17.584     0.200
     5.951    18.669     0.200
     6.209    17.672     0.200
     6.554    21.990     0.200
     6.975    20.951     0.200
     7.054    20.724     0.200
     7.081    21.078     0.200
     7.266    22.519     0.200
     7.331    21.883     0.200
     7.585    23.735     0.200
     7.663    22.682     0.200
     7.663    21.961     0.200
     7.674    23.789     0.200
     7.766    22.395     0.200
     7.844    24.165     0.200
     7.849    24.384     0.200
     8.304    22.525     0.200
     8.333    26.466     0.200
     1.024     4.631     0.200
     0.976     4.767     0.200
     1.145     5.109     0.200
     1.309     5.719     0.200
     1.260     5.777     0.200
     1.352     5.686     0.200
     1.377     5.644     0.200
     1.294     7.679     0.200
     1.426     6.063     0.200
     1.452     6.979     0.200
     1.416     8.400     0.200
     1.409     7.942     0.200
     1.465     8.588     0.200
     1.409     8.085     0.200
     1.570     6.214     0.200
     1.570     6.112     0.200
     1.570     6.839     0.200
     1.573     6.653     0.200
     1.563     7.119     0.200
     1.618     6.951     0.200
     1.639     7.011     0.200
     1.662     7.246     0.200
     1.661     7.750     0.200
     1.661     7.774     0.200
     1.705     7.066     0.200
     1.712     6.866     0.200
     1.803     7.344     0.200
     1.932     7.527     0.200
     1.934     7.626     0.200
     2.030     7.887     0.200
     2.060     8.029     0.200
     2.094     8.504     0.200
     2.113     7.994     0.200
     2.195     8.637     0.200
     2.089     7.161     0.200
     2.294     9.260     0.200
     2.313     9.263     0.200
     2.313     9.075     0.200
     2.367     8.698     0.200
     2.371     8.967     0.200
     2.375     9.329     0.200
     2.560     9.037     0.200
     2.631    10.477     0.200
     2.724     9.894     0.200
     2.728    10.318     0.200
     2.795     9.490     0.200
     2.849    10.089     0.200
     2.862     9.524     0.200
     2.870    10.043     0.200
     2.865    10.250     0.200
     2.865    10.250     0.200
     2.884     9.471     0.200
     2.975    10.222     0.200
     3.031    10.225     0.200
     3.045    10.479     0.200
     3.045    10.354     0.200
     3.126    10.888     0.200
     3.147    10.915     0.200
     3.179    10.491     0.200
     3.364    11.073     0.200
     3.561    11.165     0.200
     3.634    10.550     0.200
     3.649    12.768     0.200
     3.649    11.854     0.200
     3.662    11.622     0.200
     3.677    13.263     0.200
     3.716    12.553     0.200
     3.745    10.629     0.200
     4.019    12.114     0.200
     4.033    12.807     0.200
     4.021    12.092     0.200
     4.054    12.931     0.200
     4.072    12.796     0.200
     4.204    12.883     0.200
     4.242    13.030     0.200
     4.262    13.047     0.200
     4.422    14.996     0.200
     4.422    14.645     0.200
     4.550    14.170     0.200
     4.577    15.020     0.200
     4.577    14.770     0.200
     4.595    14.486     0.200
     4.641    14.680     0.200
     4.672    14.129     0.200
     4.650    15.324     0.200
     4.814    15.130     0.200
     4.878    15.295     0.200
     4.905    14.817     0.200
     4.862    15.317     0.200
     4.969    16.054     0.200
     5.008    17.076     0.200
     5.132    16.497     0.200
     5.230    15.805     0.200
     5.151    14.846     0.200
     5.317    17.160     0.200
     5.281    16.846     0.200
     5.281    16.401     0.200
     5.489    18.032     0.200
     5.527    17.138     0.200
     5.857    18.792     0.200
     5.717    17.997     0.200
     5.787    17.261     0.200
     5.902    17.725     0.200
     5.902    17.185     0.200
     5.970    17.868     0.200
     5.964    19.557     0.200
     6.273    17.480     0.200
     6.273    17.996     0.200
     6.311    18.163     0.200
     6.400    19.348     0.200
     6.442    19.866     0.200
     6.486    19.964     0.200
     6.486    19.573     0.200
     6.523    20.117     0.200
     6.574    20.283     0.200
     6.519    19.888     0.200
     6.711    24.017     0.200
     6.874    18.957     0.200
     7.005    20.395     0.200
     6.985    19.794     0.200
     7.024    20.547     0.200
     7.105    20.345     0.200
     7.130    20.301     0.200
     7.283    22.822     0.200
     7.283    22.166     0.200
     7.383    20.707     0.200
     7.412    21.172     0.200
     7.453    22.383     0.200
     7.521    25.652     0.200
     7.570    23.395     0.200
     7.557    20.875     0.200
     7.598    21.329     0.200
     7.665    23.088     0.200
     7.699    22.076     0.200
     7.708    22.979     0.200
     7.708    22.253     0.200
     7.708    21.854     0.200
     7.771    23.386     0.200
     7.814    23.972     0.200
     7.855    24.721     0.200
     7.854    24.104     0.200
     7.815    21.356     0.200
     7.829    21.672     0.200
     7.913    25.156     0.200
     7.975    24.676     0.200
     7.975    22.614     0.200
     7.940    23.019     0.200
     8.011    22.819     0.200
     8.090    25.783     0.200
     8.137    24.880     0.200
     8.178    23.117     0.200
     8.287    23.535     0.200
     8.274    25.620     0.200
     8.212    21.951     0.200
     8.237    21.858     0.200
     8.324    22.443     0.200
     8.327    22.298     0.200
     8.325    21.821     0.200
     8.400    23.102     0.200
     8.465    26.559     0.200
     8.372    22.076     0.200
     8.498    27.188     0.200
     8.567    26.959     0.200
     8.646    26.396     0.200
     8.609    24.308     0.200
     8.666    24.925     0.200
     8.741    26.931     0.200
     8.820    27.471     0.200
     8.768    23.563     0.200
     8.828    24.715     0.200
     8.885    27.203     0.200
     8.868    24.888     0.200
     8.866    24.350     0.200
     8.873    24.041     0.200
     8.910    24.349     0.200
     8.937    24.531     0.200
     9.051    25.200     0.200
     9.121    27.824     0.200
     9.181    25.388     0.200
     9.305    26.340     0.200
     9.360    26.485     0.200
     9.434    27.744     0.200
     9.359    25.334     0.200
     9.409    26.318     0.200
     9.476    28.070     0.200
     9.477    28.400     0.200
     9.512    28.710     0.200
     9.520    27.037     0.200
     9.447    26.553     0.200
     9.513    27.785     0.200
     9.513    26.481     0.200
     9.483    26.096     0.200
     9.571    26.189     0.200
     9.586    26.784     0.200
     9.615    26.427     0.200
     9.655    26.599     0.200
     9.696    26.491     0.200
     9.740    27.906     0.200
     9.701    25.985     0.200
     9.755    26.655     0.200
     9.748    26.207     0.200
     9.905    29.756     0.200
     9.808    26.527     0.200
     9.884    27.559     0.200
     9.885    26.989     0.200
     9.982    27.521     0.200
     9.930    27.151     0.200
     9.946    28.648     0.200
    10.060    27.319     0.200
    10.005    26.097     0.200
    10.037    27.832     0.200
    10.042    28.122     0.200
    10.068    27.152     0.200
    10.103    26.773     0.200
    10.125    27.440     0.200
    10.199    27.350     0.200
    10.182    26.981     0.200
    10.188    27.117     0.200
    10.249    27.861     0.200
    10.271    27.914     0.200
    10.256    28.151     0.200
    10.339    31.388     0.200
    10.344    27.855     0.200
    10.396    28.275     0.200
    10.447    28.189     0.200
    10.387    27.440     0.200
    10.388    28.211     0.200
    10.444    28.054     0.200
    10.530    28.854     0.200
    10.530    29.002     0.200
    10.584    28.878     0.200
    10.576    29.958     0.200
    10.591    28.610     0.200
    10.650    29.015     0.200
    10.717    28.701     0.200
    10.677    31.732     0.200
    10.677    29.490     0.200
    10.686    28.851     0.200
    10.777    28.455     0.200
    10.806    31.751     0.200
    10.822    31.366     0.200
    10.743    28.418     0.200
    10.842    34.340     0.200
    10.777    31.295     0.200
    10.817    29.022     0.200
    10.818    28.774     0.200
    10.907    28.788     0.200
    10.966    32.877     0.200
    10.923    29.407     0.200
    10.919    29.709     0.200
    11.034    34.069     0.200
    11.034    33.428     0.200
    10.968    29.826     0.200
    10.960    30.047     0.200
    10.978    28.818     0.200
    11.120    31.806     0.200
    11.062    29.965     0.200
    11.198    33.409     0.200
    11.203    30.060     0.200
    11.235    30.931     0.200
    11.235    30.727     0.200
    11.241    29.471     0.200
    11.236    30.730     0.200
    11.285    30.242     0.200
    11.256    31.031     0.200
    11.259    30.088     0.200
    11.264    30.750     0.200
    11.276    29.892     0.200
    11.419    30.253     0.200
    11.359    30.292     0.200
    11.386    30.410     0.200
    11.349    29.413     0.200
    11.361    30.266     0.200
    11.387    30.218     0.200
    11.419    32.080     0.200
    11.436    30.692     0.200
    11.460    30.765     0.200
    11.491    30.904     0.200
    11.547    33.375     0.200
    11.505    30.082     0.200
    11.533    31.056     0.200
    11.651    33.201     0.200
    11.596    31.351     0.200
    11.725    32.348     0.200
    11.685    31.390     0.200
    11.732    31.740     0.200
    11.770    32.694     0.200
    11.768    30.932     0.200
    11.774    31.819     0.200
    11.821    31.879     0.200
    11.788    35.261     0.200
    11.820    33.191     0.200
    11.859    36.031     0.200
    11.844    32.092     0.200
    11.845    32.458     0.200
    11.917    33.653     0.200
    11.871    32.253     0.200
    11.940    30.265     0.200
    11.967    30.755     0.200
    12.022    32.594     0.200
    11.959    32.113     0.200
    11.969    30.955     0.200
    12.099    36.513     0.200
    12.025    31.453     0.200
    12.057    31.772     0.200
    12.025    32.406     0.200
    12.146    34.570     0.200
    12.147    34.319     0.200
    12.079    32.160     0.200
    12.190    37.051     0.200
    12.083    31.309     0.200
    12.138    36.092     0.200
    12.138    32.436     0.200
    12.180    32.611     0.200
    12.253    32.942     0.200
    12.260    32.370     0.200
    12.293    32.327     0.200
    12.293    31.585     0.200
    12.343    31.617     0.200
    12.363    33.219     0.200
    12.411    34.409     0.200
    12.468    38.242     0.200
    12.472    35.589     0.200
    12.472    34.409     0.200
    12.442    35.099     0.200
    12.485    33.306     0.200
    12.503    36.564     0.200
    12.472    33.433     0.200
    12.481    34.344     0.200
    12.558    33.500     0.200
    12.507    33.090     0.200
    12.594    33.982     0.200
    12.649    36.420     0.200
    12.666    35.377     0.200
    12.666    37.222     0.200
    12.576    33.611     0.200
    12.645    34.012     0.200
    12.682    36.113     0.200
    12.612    33.670     0.200
    12.647    34.335     0.200
    12.617    33.638     0.200
    12.627    32.173     0.200
    12.716    35.946     0.200
    12.727    34.877     0.200
    12.682    34.349     0.200
    12.709    34.852     0.200
    12.760    34.162     0.200
    12.746    34.713     0.200
    12.787    36.090     0.200
    12.785    32.930     0.200
    12.743    34.443     0.200
    12.842    34.089     0.200
    12.930    33.119     0.200
    12.941    33.169     0.200
    12.959    34.022     0.200
    12.893    32.960     0.200
    12.917    34.089     0.200
    12.928    34.155     0.200
    12.920    34.847     0.200
    13.002    34.477     0.200
    12.987    34.330     0.200
    13.060    37.532     0.200
    13.156    37.531     0.200
    13.138    36.025     0.200
    13.150    34.834     0.200
    13.152    33.672     0.200
    13.144    34.509     0.200
    13.182    34.932     0.200
    13.187    35.564     0.200
    13.138    34.720     0.200
    13.138    33.603     0.200
    13.160    35.681     0.200
    13.184    33.800     0.200
    13.231    34.620     0.200
    13.198    34.313     0.200
    13.278    34.605     0.200
    13.266    34.743     0.200
    13.226    34.022     0.200
    13.253    34.769     0.200
    13.272    35.754     0.200
    13.323    34.363     0.200
    13.324    34.729     0.200
    13.379    38.611     0.200
    13.294    34.546     0.200
    13.291    35.039     0.200
    13.298    35.851     0.200
    13.298    35.258     0.200
    13.426    37.863     0.200
    13.452    38.627     0.200
    13.477    35.993     0.200
    13.447    34.787     0.200
    13.531    37.776     0.200
    13.503    35.644     0.200
    13.551    34.137     0.200
    13.544    35.320     0.200
    13.544    35.718     0.200
    13.603    38.091     0.200
    13.590    34.712     0.200
    13.576    35.266     0.200
    13.584    35.518     0.200
    13.671    34.001     0.200
    13.680    33.820     0.200
    13.671    35.709     0.200
    13.637    34.930     0.200
    13.733    34.465     0.200
    13.713    34.318     0.200
    13.805    35.609     0.200
    13.751    34.688     0.200
    13.806    36.209     0.200
    13.792    35.528     0.200
    13.867    35.271     0.200
    13.789    35.258     0.200
    13.815    34.441     0.200
    13.834    35.356     0.200
    13.851    34.972     0.200
    13.842    35.343     0.200
    13.877    35.836     0.200
    13.914    37.071     0.200
    13.886    34.784     0.200
    13.962    36.571     0.200
    14.001    38.611     0.200
    13.944    34.558     0.200
    13.981    35.381     0.200
    13.972    35.306     0.200
    14.024    36.728     0.200
    14.057    36.910     0.200
    14.057    35.931     0.200
    14.100    35.161     0.200
    14.037    35.866     0.200
    14.144    36.668     0.200
    14.076    36.155     0.200
    14.102    34.988     0.200
    14.201    36.097     0.200
    14.195    35.746     0.200
    14.234    38.634     0.200
    14.186    37.267     0.200
    14.211    37.134     0.200
    14.182    34.798     0.200
    14.202    36.742     0.200
    14.324    39.102     0.200
    14.317    39.679     0.200
    14.253    37.232     0.200
    14.402    38.466     0.200
    14.402    36.310     0.200
    14.373    35.970     0.200
    14.412    35.868     0.200
    14.410    37.596     0.200
    14.439    37.517     0.200
    14.416    36.659     0.200
    14.485    39.135     0.200
    14.459    35.820     0.200
    14.477    36.470     0.200
    14.514    35.780     0.200
    14.532    38.515     0.200
    14.499    35.665     0.200
    14.543    39.646     0.200
    14.458    36.007     0.200
    14.461    35.754     0.200
    14.464    36.123     0.200
    14.576    39.289     0.200
    14.575    35.550     0.200
    14.518    36.182     0.200
    14.525    36.043     0.200
    14.560    35.391     0.200
    14.643    35.816     0.200
    14.624    36.167     0.200
    14.664    37.095     0.200
    14.657    35.659     0.200
    14.656    36.906     0.200
    14.706    38.826     0.200
    14.690    38.026     0.200
    14.749    35.741     0.200
    14.707    36.719     0.200
    14.692    36.200     0.200
    14.757    36.306     0.200
    14.840    39.333     0.200
    14.827    36.437     0.200
    14.845    36.931     0.200
    14.871    39.043     0.200
    14.845    36.609     0.200
    14.774    37.898     0.200
    14.766    39.185     0.200
    14.812    39.211     0.200
    14.927    36.958     0.200
    14.987    36.835     0.200
    15.007    36.001     0.200
    14.999    35.836     0.200
    15.002    36.170     0.200
    15.011    37.983     0.200
    15.059    37.395     0.200
    15.078    39.212     0.200
    15.036    36.618     0.200
    15.079    36.735     0.200
    15.023    36.819     0.200
    15.018    37.157     0.200
    15.037    37.116     0.200
    15.037    36.639     0.200
    15.141    38.417     0.200
    15.159    37.046     0.200
    15.116    36.426     0.200
    15.115    36.291     0.200
    15.157    36.836     0.200
    15.215    37.712     0.200
    15.214    36.666     0.200
    15.232    38.342     0.200
    15.272    36.823     0.200
    15.303    39.346     0.200
    15.237    37.626     0.200
    15.348    37.522     0.200
    15.272    38.347     0.200
    15.280    37.870     0.200
    15.395    39.774     0.200
    15.403    37.400     0.200
    15.479    38.732     0.200
    15.397    38.385     0.200
    15.517    39.355     0.200
    15.483    38.256     0.200
    15.518    38.476     0.200
    15.524    38.561     0.200
    15.565    39.866     0.200
    15.547    37.846     0.200
    15.548    38.070     0.200
    15.545    37.591     0.200
    15.597    38.370     0.200
    15.560    39.498     0.200
    15.641    38.748     0.200
    15.684    37.817     0.200
    15.679    38.002     0.200
    15.700    38.112     0.200
    15.715    40.519     0.200
    15.754    37.833     0.200
    15.808    37.700     0.200
    15.718    40.629     0.200
    15.797    39.060     0.200
    15.871    39.922     0.200
    15.871    38.023     0.200
    15.898    38.442     0.200
    15.787    41.333     0.200
    15.902    39.032     0.200
    15.938    39.738     0.200
    15.964    39.112     0.200
    15.976    39.960     0.200
    16.014    38.526     0.200
    16.027    38.402     0.200
    16.104    41.055     0.200
    16.104    39.375     0.200
    16.202    40.257     0.200
    16.207    38.963     0.200
    16.227    38.730     0.200
    16.231    39.932     0.200
    16.224    39.826     0.200
    16.292    39.925     0.200
    16.395    38.642     0.200
    16.426    39.754     0.200
    16.463    39.819     0.200
    16.472    39.203     0.200
    16.436    38.983     0.200
    16.436    38.710     0.200
    16.480    40.081     0.200
    16.480    39.737     0.200
    16.513    40.493     0.200
    16.521    39.069     0.200
    16.555    39.474     0.200
    16.576    39.371     0.200
    16.681    40.398     0.200
    16.712    39.023     0.200
    16.801    39.914     0.200
    16.835    39.820     0.200
    16.847    39.486     0.200
    16.764    41.898     0.200
    16.847    38.885     0.200
    16.876    40.349     0.200
    16.867    40.173     0.200
    17.090    38.908     0.200
    17.125    40.159     0.200
    17.127    39.804     0.200
    17.159    40.187     0.200
    17.172    40.060     0.200
    17.268    39.511     0.200
    17.305    40.228     0.200
    17.311    40.781     0.200
    17.396    39.962     0.200
    17.401    40.218     0.200
    17.445    40.193     0.200
    17.461    38.518     0.200
    17.536    40.156     0.200
    17.665    40.162     0.200
    17.751    40.844     0.200
    17.766    40.842     0.200
    17.772    41.005     0.200
    17.947    40.133     0.200
    17.975    40.152     0.200
    17.991    40.722     0.200
    18.039    41.334     0.200
    18.039    40.693     0.200
    18.163    40.777     0.200
    18.235    40.787     0.200
    18.247    40.138     0.200
    18.296    39.780     0.200
    18.306    40.073     0.200
    18.430    41.279     0.200
    19.864    42.885     0.200
     1.017     5.560     0.200
     1.239     7.365     0.200
     1.321     8.313     0.200
     1.435     8.751     0.200
     1.449     9.284     0.200
     1.481     8.899     0.200
     1.537     6.709     0.200
     2.947    13.119     0.200
     3.004    11.828     0.200
     5.263    16.909     0.200
     5.816    17.928     0.200
     5.861    17.501     0.200
     6.275    17.885     0.200
     7.631    24.923     0.200
     8.246    27.419     0.200
     8.378    23.124     0.200
    10.402    28.407     0.200
     1.156     6.033     0.200
     1.261     5.928     0.200
     1.249     7.509     0.200
     1.285     5.685     0.200
     1.286     6.852     0.200
     1.356     8.088     0.200
     1.357     8.133     0.200
     1.622     6.364     0.200
     1.692     7.770     0.200
     1.747     6.787     0.200
     1.767     6.959     0.200
     2.062     7.060     0.200
     2.062     7.510     0.200
     2.075     7.831     0.200
     2.424     8.518     0.200
     2.896    10.179     0.200
     3.021    10.522     0.200
     3.076     9.715     0.200
     3.204    10.517     0.200
     3.695    10.545     0.200
     3.734    13.164     0.200
     3.729    10.015     0.200
     4.451    16.217     0.200
     4.451    15.258     0.200
     4.635    16.068     0.200
     4.690    15.855     0.200
     4.873    15.716     0.200
     4.959    16.263     0.200
     5.298    17.704     0.200
     5.298    17.493     0.200
     5.577    17.482     0.200
     6.261    17.814     0.200
     6.261    18.021     0.200
     6.570    23.901     0.200
     6.979    19.526     0.200
     7.310    23.219     0.200
     7.383    20.913     0.200
     7.814    21.639     0.200
     7.889    26.446     0.200
     9.508    28.398     0.200
    10.359    28.334     0.200
    11.533    30.827     0.200
    13.436    39.136     0.200
     1.229     6.874     0.200
     1.249     7.897     0.200
     1.249     7.942     0.200
     1.275     8.276     0.200
     1.333     8.369     0.200
     1.368     6.335     0.200
     1.375     6.736     0.200
     1.643     7.007     0.200
     2.065     8.543     0.200
     2.132     8.158     0.200
     2.132     7.720     0.200
     3.014    14.805     0.200
     3.065    14.300     0.200
     3.258    12.746     0.200
     4.581    16.146     0.200
     5.423    17.673     0.200
     5.483    18.277     0.200
     6.050    19.384     0.200
     6.354    18.884     0.200
     6.601    22.118     0.200
     6.691    23.971     0.200
     7.440    22.083     0.200
     8.018    26.097     0.200
     8.439    27.178     0.200
    10.421    28.862     0.200
    11.402    35.064     0.200
     1.248     7.929     0.200
     1.229     7.645     0.200
     1.249     7.924     0.200
     1.276     8.291     0.200
     1.375     6.619     0.200
     1.334     8.305     0.200
     1.369     6.214     0.200
     1.643     6.774     0.200
     1.642     8.192     0.200
     1.806     7.362     0.200
     1.867     7.804     0.200
     2.066     8.453     0.200
     2.132     8.056     0.200
     2.132     7.913     0.200
     2.247     8.928     0.200
     2.508     9.272     0.200
     2.786    11.418     0.200
     2.776    10.433     0.200
     3.015    12.646     0.200
     3.066    14.382     0.200
     3.182    10.936     0.200
     3.258    12.977     0.200
     3.688    13.110     0.200
     3.818    13.625     0.200
     4.207    14.629     0.200
     4.279    15.318     0.200
     4.410    15.333     0.200
     4.581    15.104     0.200
     4.715    16.977     0.200
     4.962    16.828     0.200
     5.423    16.904     0.200
     5.692    18.679     0.200
     6.051    18.917     0.200
     6.546    19.587     0.200
     6.691    21.147     0.200
     7.217    21.534     0.200
     7.831    22.639     0.200
     8.439    23.346     0.200
     8.439    27.371     0.200
     9.638    29.544     0.200
    10.421    29.091     0.200
    10.632    27.973     0.200
    11.402    35.684     0.200
     1.237     7.180     0.200
     1.307     6.052     0.200
     1.326     6.258     0.200
     1.609     6.740     0.200
     1.646     8.186     0.200
     2.047     8.248     0.200
     2.114     7.652     0.200
     2.191     8.655     0.200
     2.719    11.385     0.200
     3.048    11.745     0.200
     3.788    11.924     0.200
     3.799    13.401     0.200
     4.141    14.326     0.200
     4.514    15.613     0.200
     4.746    15.419     0.200
     4.940    15.581     0.200
     5.364    17.579     0.200
     5.364    17.059     0.200
     5.928    16.709     0.200
     5.986    17.472     0.200
     6.321    18.775     0.200
     6.619    19.296     0.200
     7.171    21.103     0.200
     7.374    23.236     0.200
     7.374    22.119     0.200
     7.479    21.885     0.200
     7.779    22.687     0.200
     7.780    24.168     0.200
     8.373    25.672     0.200
     8.412    22.597     0.200
    10.409    28.291     0.200
    10.901    28.705     0.200
    11.051    30.742     0.200
    16.803    36.905     0.200
     1.232     8.037     0.200
     1.384     6.392     0.200
     1.387     6.769     0.200
     1.642     8.648     0.200
     1.652     7.263     0.200
     1.652     7.575     0.200
     1.611     7.471     0.200
     1.883     8.186     0.200
     2.070     8.779     0.200
     2.137     8.596     0.200
     2.137     8.353     0.200
     2.245     9.202     0.200
     2.262     9.201     0.200
     2.522    10.269     0.200
     2.552    10.812     0.200
     2.544    10.420     0.200
     2.782    11.094     0.200
     2.802    11.311     0.200
     2.852    11.161     0.200
     2.895    11.120     0.200
     3.019    12.811     0.200
     3.070    12.927     0.200
     3.270    12.155     0.200
     3.692    14.512     0.200
     3.826    11.816     0.200
     3.875    13.784     0.200
     4.188    13.903     0.200
     4.223    14.645     0.200
     4.597    15.167     0.200
     4.597    16.018     0.200
     5.009    16.284     0.200
     5.438    18.035     0.200
     5.500    17.587     0.200
     5.998    18.435     0.200
     6.066    18.521     0.200
     6.362    18.883     0.200
     6.613    21.512     0.200
     6.708    23.866     0.200
     7.074    25.879     0.200
     7.096    24.014     0.200
     7.153    20.854     0.200
     7.455    23.916     0.200
     7.850    24.358     0.200
     7.844    23.999     0.200
     8.032    24.513     0.200
     8.097    27.652     0.200
     8.275    25.762     0.200
     8.455    26.327     0.200
     8.752    27.889     0.200
     9.700    30.361     0.200
     9.696    30.883     0.200
     9.782    31.795     0.200
    10.425    30.439     0.200
    10.853    31.766     0.200
    10.989    33.622     0.200
    11.420    33.919     0.200
    12.680    36.507     0.200
    13.365    37.099     0.200
    15.163    39.047     0.200
    16.834    40.193     0.200
    20.984    40.614     0.200
     1.262     8.903     0.200
     1.386     6.692     0.200
     1.389     6.554     0.200
     1.614     7.070     0.200
     1.646     8.327     0.200
     1.657     7.456     0.200
     1.657     7.159     0.200
     1.824     7.509     0.200
     1.888     7.917     0.200
     2.076     8.731     0.200
     2.133     8.274     0.200
     2.133     8.656     0.200
     2.248     8.662     0.200
     2.261     8.857     0.200
     2.527     9.290     0.200
     2.556     9.768     0.200
     2.788    10.632     0.200
     2.806    11.721     0.200
     2.832    10.085     0.200
     2.857    10.682     0.200
     2.900    10.561     0.200
     2.961    10.826     0.200
     3.025    11.302     0.200
     3.058    10.223     0.200
     3.075    12.590     0.200
     3.223    10.914     0.200
     3.275    11.576     0.200
     3.275    10.975     0.200
     3.443    11.646     0.200
     3.698    12.246     0.200
     3.698    12.589     0.200
     3.711    11.981     0.200
     3.767    11.981     0.200
     3.822    12.188     0.200
     4.026    12.897     0.200
     4.193    13.511     0.200
     4.228    13.843     0.200
     4.283    13.005     0.200
     4.292    14.114     0.200
     4.292    13.364     0.200
     4.383    13.779     0.200
     4.427    14.137     0.200
     4.598    15.741     0.200
     4.586    14.772     0.200
     4.734    16.653     0.200
     4.734    16.036     0.200
     4.751    15.199     0.200
     4.953    17.250     0.200
     4.952    16.094     0.200
     5.014    17.007     0.200
     5.198    15.892     0.200
     5.184    16.831     0.200
     5.350    17.230     0.200
     5.437    17.601     0.200
     5.437    17.765     0.200
     5.504    18.445     0.200
     5.602    18.988     0.200
     5.713    18.727     0.200
     6.003    20.343     0.200
     6.071    18.959     0.200
     6.086    18.858     0.200
     6.360    18.769     0.200
     6.545    20.732     0.200
     6.577    19.537     0.200
     6.619    23.175     0.200
     6.771    22.580     0.200
     7.102    22.417     0.200
     7.227    21.418     0.200
     7.250    21.233     0.200
     7.456    23.775     0.200
     7.536    22.046     0.200
     7.759    25.856     0.200
     7.843    24.678     0.200
     7.843    23.053     0.200
     7.853    24.861     0.200
     7.890    24.224     0.200
     8.033    23.124     0.200
     8.160    27.173     0.200
     8.160    25.204     0.200
     8.278    27.678     0.200
     8.292    28.231     0.200
     8.323    24.597     0.200
     8.443    23.147     0.200
     8.443    22.694     0.200
     8.459    24.883     0.200
     8.552    24.636     0.200
     8.533    26.563     0.200
     8.743    24.912     0.200
     8.755    28.829     0.200
     8.829    28.323     0.200
     8.836    25.819     0.200
     8.836    25.936     0.200
     8.877    29.861     0.200
     8.988    25.863     0.200
     9.219    24.129     0.200
     9.256    26.579     0.200
     9.249    29.722     0.200
     9.249    29.535     0.200
     9.263    26.609     0.200
     9.356    26.929     0.200
     9.366    26.725     0.200
     9.462    25.955     0.200
     9.491    26.654     0.200
     9.549    26.151     0.200
     9.656    29.257     0.200
     9.669    24.720     0.200
     9.698    28.290     0.200
     9.698    30.017     0.200
     9.704    29.957     0.200
     9.714    26.970     0.200
     9.739    27.968     0.200
     9.853    30.274     0.200
     9.786    29.396     0.200
     9.857    26.997     0.200
     9.901    27.192     0.200
     9.924    28.234     0.200
    10.012    27.561     0.200
    10.064    28.996     0.200
    10.155    28.847     0.200
    10.179    28.852     0.200
    10.191    29.067     0.200
    10.234    30.388     0.200
    10.400    30.543     0.200
    10.407    30.031     0.200
    10.420    29.098     0.200
    10.446    30.545     0.200
    10.526    31.421     0.200
    10.577    30.741     0.200
    10.618    30.116     0.200
    10.640    29.779     0.200
    10.747    31.406     0.200
    10.768    29.277     0.200
    10.801    30.921     0.200
    10.833    29.517     0.200
    10.835    31.610     0.200
    10.854    31.309     0.200
    10.911    30.366     0.200
    10.917    30.542     0.200
    10.929    33.258     0.200
    10.956    32.025     0.200
    10.993    30.926     0.200
    11.069    30.582     0.200
    11.074    32.266     0.200
    11.089    32.734     0.200
    11.097    31.760     0.200
    11.110    31.700     0.200
    11.144    33.844     0.200
    11.144    35.039     0.200
    11.170    32.010     0.200
    11.179    30.342     0.200
    11.296    31.250     0.200
    11.296    34.282     0.200
    11.349    31.922     0.200
    11.355    32.171     0.200
    11.380    33.560     0.200
    11.391    33.271     0.200
    11.397    33.059     0.200
    11.401    31.468     0.200
    11.403    32.926     0.200
    11.422    33.131     0.200
    11.423    33.667     0.200
    11.423    33.892     0.200
    11.441    32.098     0.200
    11.469    32.815     0.200
    11.486    31.660     0.200
    11.513    32.997     0.200
    11.544    32.412     0.200
    11.535    33.507     0.200
    11.557    31.986     0.200
    11.559    32.845     0.200
    11.565    31.090     0.200
    11.576    32.207     0.200
    11.653    31.153     0.200
    11.656    32.600     0.200
    11.720    31.735     0.200
    11.843    33.275     0.200
    11.879    32.836     0.200
    11.877    35.064     0.200
    11.942    33.550     0.200
    11.953    35.294     0.200
    11.953    35.301     0.200
    11.953    35.589     0.200
    11.971    32.621     0.200
    11.975    33.411     0.200
    11.977    37.866     0.200
    12.031    34.553     0.200
    12.032    33.741     0.200
    12.040    32.480     0.200
    12.042    32.091     0.200
    12.090    33.280     0.200
    12.109    34.311     0.200
    12.116    33.570     0.200
    12.102    36.921     0.200
    12.137    33.162     0.200
    12.154    34.805     0.200
    12.187    34.172     0.200
    12.207    34.474     0.200
    12.209    36.253     0.200
    12.201    35.831     0.200
    12.255    33.628     0.200
    12.301    34.617     0.200
    12.318    34.004     0.200
    12.399    35.593     0.200
    12.424    35.222     0.200
    12.441    35.427     0.200
    12.444    34.946     0.200
    12.480    34.487     0.200
    12.508    34.562     0.200
    12.516    34.239     0.200
    12.567    34.635     0.200
    12.595    34.415     0.200
    12.599    34.153     0.200
    12.609    34.421     0.200
    12.611    34.100     0.200
    12.641    34.156     0.200
    12.658    35.713     0.200
    12.658    37.642     0.200
    12.673    35.443     0.200
    12.690    34.266     0.200
    12.684    36.546     0.200
    12.709    34.380     0.200
    12.720    34.643     0.200
    12.746    35.674     0.200
    12.777    36.013     0.200
    12.796    34.886     0.200
    12.796    34.352     0.200
    12.801    34.101     0.200
    12.792    36.820     0.200
    12.819    35.178     0.200
    12.805    38.877     0.200
    12.824    35.522     0.200
    12.834    36.069     0.200
    12.871    34.673     0.200
    12.921    36.235     0.200
    12.948    35.982     0.200
    12.945    37.381     0.200
    12.967    34.118     0.200
    12.970    35.352     0.200
    13.009    35.023     0.200
    13.012    36.224     0.200
    13.059    35.450     0.200
    13.048    37.773     0.200
    13.083    35.215     0.200
    13.109    35.430     0.200
    13.117    35.779     0.200
    13.129    35.609     0.200
    13.146    36.276     0.200
    13.166    35.550     0.200
    13.229    34.770     0.200
    13.259    35.411     0.200
    13.280    35.136     0.200
    13.288    36.304     0.200
    13.291    35.514     0.200
    13.295    35.196     0.200
    13.325    36.950     0.200
    13.326    37.655     0.200
    13.350    36.603     0.200
    13.353    36.142     0.200
    13.362    35.672     0.200
    13.363    37.380     0.200
    13.365    36.191     0.200
    13.389    36.294     0.200
    13.402    35.760     0.200
    13.406    35.752     0.200
    13.434    36.279     0.200
    13.445    39.975     0.200
    13.466    36.832     0.200
    13.510    36.885     0.200
    13.511    36.823     0.200
    13.527    40.083     0.200
    13.560    35.244     0.200
    13.603    36.313     0.200
    13.654    36.843     0.200
    13.666    35.892     0.200
    13.664    35.948     0.200
    13.678    35.787     0.200
    13.717    36.893     0.200
    13.717    34.362     0.200
    13.724    36.715     0.200
    13.734    37.151     0.200
    13.739    36.605     0.200
    13.770    36.661     0.200
    13.772    37.701     0.200
    13.823    36.345     0.200
    13.843    36.220     0.200
    13.847    37.174     0.200
    13.865    37.982     0.200
    13.883    37.529     0.200
    13.900    36.462     0.200
    13.910    36.625     0.200
    13.911    36.768     0.200
    13.918    37.132     0.200
    13.921    37.239     0.200
    13.950    36.597     0.200
    13.945    40.701     0.200
    13.963    36.366     0.200
    13.992    37.109     0.200
    14.022    36.782     0.200
    14.054    37.547     0.200
    14.076    36.822     0.200
    14.079    36.948     0.200
    14.080    36.977     0.200
    14.097    37.154     0.200
    14.128    37.365     0.200
    14.150    38.223     0.200
    14.185    37.450     0.200
    14.188    34.715     0.200
    14.207    37.275     0.200
    14.215    37.193     0.200
    14.234    37.493     0.200
    14.245    36.516     0.200
    14.286    37.150     0.200
    14.290    36.380     0.200
    14.302    36.250     0.200
    14.325    37.097     0.200
    14.328    38.203     0.200
    14.329    38.546     0.200
    14.384    37.499     0.200
    14.383    38.300     0.200
    14.428    38.053     0.200
    14.461    37.132     0.200
    14.461    40.915     0.200
    14.504    38.385     0.200
    14.541    37.480     0.200
    14.542    37.293     0.200
    14.542    37.855     0.200
    14.550    36.974     0.200
    14.565    37.648     0.200
    14.579    37.592     0.200
    14.579    38.663     0.200
    14.597    37.354     0.200
    14.603    37.668     0.200
    14.600    38.334     0.200
    14.641    37.627     0.200
    14.644    37.109     0.200
    14.653    37.630     0.200
    14.661    36.934     0.200
    14.678    37.766     0.200
    14.702    38.212     0.200
    14.723    40.298     0.200
    14.769    38.265     0.200
    14.782    38.093     0.200
    14.789    37.980     0.200
    14.799    37.576     0.200
    14.820    37.124     0.200
    14.827    37.075     0.200
    14.827    38.792     0.200
    14.836    37.210     0.200
    14.843    36.887     0.200
    14.856    37.485     0.200
    14.873    38.101     0.200
    14.877    37.740     0.200
    14.938    38.389     0.200
    15.014    38.306     0.200
    15.033    37.936     0.200
    15.032    38.366     0.200
    15.056    36.364     0.200
    15.089    37.755     0.200
    15.115    37.690     0.200
    15.123    37.459     0.200
    15.123    36.896     0.200
    15.143    37.823     0.200
    15.161    37.824     0.200
    15.164    37.619     0.200
    15.177    38.909     0.200
    15.181    38.450     0.200
    15.195    39.080     0.200
    15.216    37.830     0.200
    15.235    38.263     0.200
    15.247    38.248     0.200
    15.246    38.300     0.200
    15.263    38.772     0.200
    15.269    38.355     0.200
    15.314    38.850     0.200
    15.328    38.612     0.200
    15.327    41.140     0.200
    15.342    38.371     0.200
    15.343    38.208     0.200
    15.345    38.443     0.200
    15.361    38.138     0.200
    15.372    37.807     0.200
    15.402    38.644     0.200
    15.446    38.011     0.200
    15.460    38.756     0.200
    15.535    38.738     0.200
    15.591    38.793     0.200
    15.603    37.903     0.200
    15.647    37.660     0.200
    15.665    38.930     0.200
    15.697    37.267     0.200
    15.699    38.007     0.200
    15.700    38.010     0.200
    15.704    38.300     0.200
    15.714    37.678     0.200
    15.717    40.591     0.200
    15.720    38.332     0.200
    15.732    38.512     0.200
    15.761    38.647     0.200
    15.785    38.052     0.200
    15.817    38.139     0.200
    15.852    36.874     0.200
    15.854    36.531     0.200
    15.861    37.279     0.200
    15.867    37.832     0.200
    15.865    37.916     0.200
    15.872    37.692     0.200
    15.883    37.369     0.200
    15.908    37.616     0.200
    15.941    38.075     0.200
    15.951    37.588     0.200
    15.996    38.653     0.200
    16.037    41.606     0.200
    16.037    38.973     0.200
    16.065    37.799     0.200
    16.086    38.607     0.200
    16.090    37.019     0.200
    16.119    39.828     0.200
    16.152    38.340     0.200
    16.162    39.664     0.200
    16.189    38.928     0.200
    16.205    39.629     0.200
    16.289    40.083     0.200
    16.317    39.538     0.200
    16.335    39.959     0.200
    16.394    38.897     0.200
    16.395    39.362     0.200
    16.399    38.629     0.200
    16.394    40.381     0.200
    16.415    39.691     0.200
    16.418    39.947     0.200
    16.458    38.775     0.200
    16.506    38.455     0.200
    16.515    37.729     0.200
    16.560    38.919     0.200
    16.582    40.920     0.200
    16.606    40.149     0.200
    16.630    39.805     0.200
    16.639    39.807     0.200
    16.654    39.825     0.200
    16.697    41.244     0.200
    16.707    40.827     0.200
    16.743    40.573     0.200
    16.764    40.184     0.200
    16.899    40.932     0.200
    16.975    39.194     0.200
    16.984    40.623     0.200
    17.016    39.833     0.200
    17.020    40.101     0.200
    17.030    39.596     0.200
    17.032    39.939     0.200
    17.035    41.833     0.200
    17.049    40.333     0.200
    17.063    39.642     0.200
    17.063    39.903     0.200
    17.063    41.905     0.200
    17.096    39.510     0.200
    17.266    41.370     0.200
    17.276    41.340     0.200
    17.312    41.534     0.200
    17.315    41.140     0.200
    17.347    41.852     0.200
    17.455    41.408     0.200
    17.481    40.595     0.200
    17.492    41.340     0.200
    17.497    41.753     0.200
    17.578    41.440     0.200
    17.585    41.381     0.200
    17.624    41.161     0.200
    17.642    40.682     0.200
    17.647    41.342     0.200
    17.659    40.831     0.200
    17.723    41.443     0.200
    17.852    41.602     0.200
    17.938    41.653     0.200
    17.952    41.544     0.200
    17.954    41.819     0.200
    18.478    42.811     0.200
    18.654    42.226     0.200
    18.682    42.910     0.200
    18.878    42.143     0.200
    18.984    42.003     0.200
    19.008    42.103     0.200
    19.033    42.045     0.200
    19.294    42.032     0.200
    19.361    46.851     0.200
    19.376    42.291     0.200
    19.379    45.140     0.200
    19.440    45.813     0.200
    19.833    46.257     0.200
     3.254    14.247     0.200
     3.299    14.334     0.200
     3.559    13.486     0.200
     4.005    14.398     0.200
     3.924    15.390     0.200
     5.063    17.727     0.200
     5.108    16.695     0.200
     5.559    18.014     0.200
     6.339    18.829     0.200
     6.904    20.082     0.200
     7.911    22.702     0.200
     8.745    24.864     0.200
     8.976    31.763     0.200
    11.671    33.024     0.200
     1.349     7.263     0.200
     1.709     9.075     0.200
     2.041     8.764     0.200
     2.198     9.526     0.200
     2.895    12.820     0.200
     2.936    10.155     0.200
     3.115    12.193     0.200
     3.147    13.580     0.200
     3.197    14.250     0.200
     4.319    15.263     0.200
     4.415    14.429     0.200
     4.516    17.134     0.200
     4.609    16.233     0.200
     4.609    16.678     0.200
     5.212    17.580     0.200
     5.421    17.699     0.200
     5.421    18.402     0.200
     6.286    18.086     0.200
     7.106    20.872     0.200
     7.178    21.295     0.200
     7.224    23.199     0.200
     7.461    22.941     0.200
     7.454    22.039     0.200
     7.723    25.315     0.200
     7.810    22.782     0.200
     7.803    23.215     0.200
     7.803    21.989     0.200
     7.896    23.858     0.200
     7.977    24.718     0.200
     8.022    24.951     0.200
     8.164    26.915     0.200
     8.231    27.244     0.200
     8.338    27.197     0.200
     8.398    25.504     0.200
     8.552    26.710     0.200
     8.814    28.756     0.200
     8.835    26.329     0.200
     8.905    28.849     0.200
     8.941    27.958     0.200
     9.128    29.772     0.200
     9.186    25.138     0.200
     9.429    28.046     0.200
     9.593    28.067     0.200
     9.670    28.701     0.200
     9.732    30.265     0.200
     9.705    29.642     0.200
     9.730    29.456     0.200
     9.851    31.393     0.200
    10.171    32.063     0.200
    10.320    29.870     0.200
    10.320    29.846     0.200
    10.526    32.559     0.200
    10.597    32.039     0.200
    10.582    33.098     0.200
    10.620    29.823     0.200
    10.866    31.702     0.200
    11.059    32.996     0.200
    11.231    34.865     0.200
    11.265    32.644     0.200
    11.384    36.051     0.200
    11.457    34.809     0.200
    11.440    32.124     0.200
    11.445    33.798     0.200
    11.479    31.689     0.200
    11.602    32.802     0.200
    11.683    34.249     0.200
    11.781    34.464     0.200
    11.906    34.585     0.200
    11.977    34.317     0.200
    12.094    34.742     0.200
    12.172    35.262     0.200
    12.292    35.133     0.200
    12.357    35.267     0.200
    12.401    37.248     0.200
    12.442    36.672     0.200
    12.723    36.492     0.200
    12.726    37.337     0.200
    12.763    39.219     0.200
    12.765    38.213     0.200
    13.008    36.966     0.200
    13.158    37.165     0.200
    13.275    37.090     0.200
    13.322    37.919     0.200
    13.417    38.522     0.200
    13.627    38.428     0.200
    13.685    38.409     0.200
    13.707    36.654     0.200
    13.727    38.186     0.200
    13.792    39.953     0.200
    13.867    40.308     0.200
    13.947    36.441     0.200
    14.497    39.261     0.200
    14.584    39.933     0.200
    14.666    40.893     0.200
    14.795    40.428     0.200
    14.793    39.271     0.200
    14.826    40.038     0.200
    14.825    38.922     0.200
    15.104    41.546     0.200
    15.133    39.487     0.200
    15.114    37.777     0.200
    15.204    39.133     0.200
    15.342    41.263     0.200
    15.413    41.531     0.200
    15.632    40.956     0.200
    15.660    41.693     0.200
    15.725    41.766     0.200
    15.780    40.385     0.200
    15.829    41.937     0.200
    16.050    39.116     0.200
    16.136    41.204     0.200
    16.136    40.274     0.200
    16.341    39.810     0.200
    16.361    41.818     0.200
    16.464    41.833     0.200
    16.453    40.403     0.200
    16.512    39.539     0.200
    16.745    40.888     0.200
    17.437    41.867     0.200
    17.585    42.073     0.200
    18.217    41.210     0.200
    18.279    41.890     0.200
     0.932     4.652     0.200
     0.932     4.957     0.200
     0.956     5.129     0.200
     1.231     5.413     0.200
     1.261     7.295     0.200
     1.406     7.062     0.200
     1.455     6.523     0.200
     1.425     6.661     0.200
     1.529     6.683     0.200
     1.672     6.968     0.200
     1.678     8.352     0.200
     1.715     6.622     0.200
     1.715     7.122     0.200
     1.715     7.419     0.200
     1.889     7.374     0.200
     1.953     7.826     0.200
     2.119     8.437     0.200
     2.081     9.138     0.200
     2.123     8.681     0.200
     2.289     9.227     0.200
     2.305     8.853     0.200
     2.584     9.404     0.200
     2.593     9.580     0.200
     2.619     9.454     0.200
     2.761     9.701     0.200
     2.872    11.503     0.200
     2.839    10.264     0.200
     2.856    10.358     0.200
     2.890    10.905     0.200
     2.940    12.750     0.200
     3.117    11.263     0.200
     3.103    12.118     0.200
     3.267    11.549     0.200
     3.497    12.360     0.200
     3.745    12.308     0.200
     3.745    16.738     0.200
     3.907    13.597     0.200
     4.061    14.180     0.200
     4.149    14.206     0.200
     4.293    14.677     0.200
     4.349    14.393     0.200
     4.383    15.559     0.200
     4.641    15.377     0.200
     4.641    16.103     0.200
     4.630    15.079     0.200
     4.800    15.858     0.200
     4.805    15.830     0.200
     4.891    16.668     0.200
     5.035    16.231     0.200
     4.999    17.027     0.200
     5.062    16.960     0.200
     5.183    15.968     0.200
     5.215    17.472     0.200
     5.378    17.704     0.200
     5.468    17.316     0.200
     5.468    17.886     0.200
     5.565    18.226     0.200
     5.775    18.838     0.200
     6.137    18.429     0.200
     6.137    19.508     0.200
     6.359    18.426     0.200
     6.682    23.970     0.200
     6.817    21.735     0.200
     6.821    24.531     0.200
     7.168    20.625     0.200
     7.160    24.077     0.200
     7.241    20.987     0.200
     7.264    21.437     0.200
     7.497    23.266     0.200
     7.517    21.866     0.200
     7.551    22.014     0.200
     7.749    25.475     0.200
     7.816    27.027     0.200
     7.862    22.880     0.200
     7.862    22.778     0.200
     7.862    22.481     0.200
     7.908    23.748     0.200
     8.001    24.537     0.200
     8.045    24.917     0.200
     8.078    25.178     0.200
     8.223    27.973     0.200
     8.348    23.824     0.200
     8.338    26.424     0.200
     8.358    26.992     0.200
     8.435    22.811     0.200
     8.525    26.247     0.200
     8.525    25.747     0.200
     8.581    24.317     0.200
     8.763    24.957     0.200
     8.815    26.665     0.200
     8.874    25.012     0.200
     8.893    28.129     0.200
     8.938    27.361     0.200
     9.020    25.797     0.200
     9.189    28.895     0.200
     9.260    24.527     0.200
     9.283    25.818     0.200
     9.426    28.298     0.200
     9.509    26.709     0.200
     9.572    26.915     0.200
     9.667    27.679     0.200
     9.671    27.495     0.200
     9.700    29.038     0.200
     9.793    29.356     0.200
     9.748    27.626     0.200
     9.749    28.605     0.200
     9.777    27.222     0.200
     9.767    29.146     0.200
     9.847    29.585     0.200
    10.029    27.323     0.200
    10.221    29.030     0.200
    10.195    32.951     0.200
    10.399    28.772     0.200
    10.399    28.795     0.200
    10.439    28.470     0.200
    10.474    32.784     0.200
    10.553    31.278     0.200
    10.649    29.187     0.200
    10.658    29.226     0.200
    10.765    27.343     0.200
    10.833    29.226     0.200
    10.898    30.752     0.200
    11.054    33.012     0.200
    11.190    29.427     0.200
    11.201    34.374     0.200
    11.205    33.672     0.200
    11.205    34.594     0.200
    11.362    34.870     0.200
    11.404    34.545     0.200
    11.470    31.392     0.200
    11.482    32.252     0.200
    11.482    31.095     0.200
    11.482    32.141     0.200
    11.667    30.664     0.200
    11.678    34.111     0.200
    11.776    33.991     0.200
    11.795    33.683     0.200
    11.973    34.500     0.200
    12.018    33.946     0.200
    12.035    34.838     0.200
    12.165    33.595     0.200
    12.336    33.378     0.200
    12.312    36.585     0.200
    12.395    35.205     0.200
    12.392    36.272     0.200
    12.533    32.524     0.200
    12.716    35.160     0.200
    12.720    35.741     0.200
    12.728    36.959     0.200
    12.749    37.716     0.200
    13.002    37.436     0.200
    13.230    34.950     0.200
    13.306    38.181     0.200
    13.351    35.321     0.200
    13.376    35.884     0.200
    13.574    38.110     0.200
    13.673    39.176     0.200
    13.660    38.809     0.200
    13.725    35.319     0.200
    13.776    38.440     0.200
    13.833    37.948     0.200
    14.013    34.603     0.200
    14.460    39.544     0.200
    14.542    39.106     0.200
    14.644    39.283     0.200
    14.731    38.816     0.200
    14.775    40.031     0.200
    14.812    35.878     0.200
    14.776    38.021     0.200
    14.889    37.662     0.200
    15.083    38.177     0.200
    15.121    37.276     0.200
    15.094    39.692     0.200
    15.177    37.906     0.200
    15.265    37.596     0.200
    15.320    39.876     0.200
    15.544    40.449     0.200
    15.588    39.930     0.200
    15.635    40.948     0.200
    15.672    40.768     0.200
    15.672    40.067     0.200
    15.744    40.231     0.200
    15.805    39.566     0.200
    16.054    39.091     0.200
    16.274    40.508     0.200
    16.425    40.913     0.200
    16.495    39.390     0.200
    16.575    38.803     0.200
    16.522    40.815     0.200
    16.657    39.255     0.200
    16.687    34.687     0.200
    16.822    38.426     0.200
    16.870    41.163     0.200
    17.510    39.677     0.200
    17.669    41.126     0.200
    18.284    40.755     0.200
    18.285    40.630     0.200
    19.650    41.318     0.200
     0.530     3.929     0.200
     0.522     3.864     0.200
     0.564     4.109     0.200
     0.624     4.139     0.200
     0.588     4.500     0.200
     0.641     4.412     0.200
     1.230     8.079     0.200
     1.376     6.299     0.200
     1.230     7.971     0.200
     1.449     6.712     0.200
     1.610     7.333     0.200
     1.578     7.452     0.200
     2.017     8.480     0.200
     2.762    10.374     0.200
     2.789    10.895     0.200
     3.639    13.427     0.200
     3.928    13.594     0.200
     4.243    14.020     0.200
     4.642    16.418     0.200
     6.429    18.758     0.200
     7.292    21.705     0.200
     7.905    24.317     0.200
     8.513    23.828     0.200
     0.882     4.944     0.200
     0.882     4.412     0.200
     1.230     5.754     0.200
     1.401     6.468     0.200
     1.378     7.767     0.200
     1.585     7.022     0.200
     1.612     6.872     0.200
     1.763     7.567     0.200
     1.802     8.019     0.200
     2.220     8.490     0.200
     2.394     9.121     0.200
     2.466     9.133     0.200
     2.574    10.100     0.200
     2.587     9.960     0.200
     3.981    14.148     0.200
     4.047    13.283     0.200
     4.652    16.068     0.200
     4.823    15.544     0.200
     5.140    16.739     0.200
     5.446    16.981     0.200
     5.548    18.104     0.200
     7.426    21.473     0.200
     7.997    24.360     0.200
    10.677    28.326     0.200
    11.365    32.368     0.200
    15.865    38.907     0.200
     1.082     5.901     0.200
     1.195     6.086     0.200
     1.408     8.372     0.200
     1.434     7.821     0.200
     1.434     7.971     0.200
     1.512     7.685     0.200
     1.573     8.623     0.200
     1.748     7.005     0.200
     1.993     8.979     0.200
     2.057     8.185     0.200
     2.057     7.958     0.200
     2.211     8.420     0.200
     2.568    10.926     0.200
     2.887     9.820     0.200
     3.205    11.288     0.200
     4.557    15.589     0.200
     4.570    16.368     0.200
     4.693    16.220     0.200
     5.204    16.662     0.200
     5.384    17.555     0.200
     5.442    17.342     0.200
     5.765    18.164     0.200
     5.980    19.196     0.200
     6.247    19.816     0.200
     7.007    26.160     0.200
     7.058    21.143     0.200
     7.120    21.246     0.200
     7.392    22.217     0.200
     7.433    21.958     0.200
     7.476    25.945     0.200
     7.527    23.623     0.200
     7.768    24.333     0.200
     7.768    23.083     0.200
     7.821    25.910     0.200
     7.973    26.208     0.200
     8.043    24.825     0.200
     8.081    25.655     0.200
     8.130    26.819     0.200
     8.139    26.189     0.200
     8.216    21.969     0.200
     8.350    26.413     0.200
     8.432    27.083     0.200
     8.516    27.201     0.200
     8.658    29.150     0.200
     8.790    26.007     0.200
     8.790    25.307     0.200
     8.886    25.953     0.200
     8.851    28.663     0.200
     8.989    28.286     0.200
     9.057    26.299     0.200
     9.112    28.347     0.200
     9.127    28.640     0.200
     9.455    28.870     0.200
     9.455    29.160     0.200
     9.467    24.257     0.200
     9.612    27.493     0.200
     9.739    26.867     0.200
     9.756    28.919     0.200
     9.851    30.596     0.200
     9.987    29.842     0.200
    10.041    29.512     0.200
    10.128    28.491     0.200
    10.128    28.465     0.200
    10.178    29.770     0.200
    10.498    30.589     0.200
    10.799    34.529     0.200
    10.862    32.431     0.200
    10.944    31.468     0.200
    11.249    32.334     0.200
    11.474    33.984     0.200
    11.545    31.460     0.200
    11.537    32.259     0.200
    11.542    35.385     0.200
    11.614    34.546     0.200
    11.649    32.726     0.200
    11.649    32.795     0.200
    11.649    32.795     0.200
    11.730    35.957     0.200
    11.873    33.023     0.200
    11.973    33.250     0.200
    11.989    33.841     0.200
    12.093    34.395     0.200
    12.166    33.172     0.200
    12.323    35.021     0.200
    12.365    34.474     0.200
    12.371    37.811     0.200
    12.593    34.857     0.200
    12.622    38.263     0.200
    12.648    33.334     0.200
    12.713    38.004     0.200
    12.917    36.840     0.200
    12.918    37.384     0.200
    12.981    38.412     0.200
    13.016    38.964     0.200
    13.042    35.849     0.200
    13.119    34.987     0.200
    13.176    37.764     0.200
    13.203    37.369     0.200
    13.537    38.689     0.200
    13.678    37.798     0.200
    13.892    39.170     0.200
    13.871    36.010     0.200
    13.909    37.602     0.200
    13.900    38.902     0.200
    13.975    40.266     0.200
    14.007    38.503     0.200
    14.117    39.085     0.200
    14.444    38.667     0.200
    14.752    38.922     0.200
    14.756    37.789     0.200
    14.845    37.939     0.200
    14.914    36.235     0.200
    14.957    39.699     0.200
    14.923    38.120     0.200
    15.018    40.172     0.200
    15.056    38.637     0.200
    15.098    39.118     0.200
    15.156    38.640     0.200
    15.329    39.786     0.200
    15.571    40.118     0.200
    15.897    40.570     0.200
    15.925    39.277     0.200
    16.061    37.811     0.200
    16.213    40.601     0.200
    16.451    38.958     0.200
    16.560    40.793     0.200
    16.592    39.258     0.200
    18.133    41.076     0.200
    19.755    41.779     0.200
    20.031    41.221     0.200
    20.768    41.238     0.200
     0.871     4.168     0.200
     1.156     7.033     0.200
     1.264     7.567     0.200
     1.342     5.886     0.200
     1.433     6.419     0.200
     1.585     6.708     0.200
     1.998     8.150     0.200
     2.204     7.934     0.200
     2.299     8.445     0.200
     2.567     9.632     0.200
     2.757    10.076     0.200
     3.887    11.010     0.200
     3.905    13.191     0.200
     4.614    15.840     0.200
     4.834    16.014     0.200
     5.047    15.799     0.200
     5.269    15.370     0.200
     5.470    17.549     0.200
     6.422    18.004     0.200
     7.302    21.517     0.200
     7.476    22.500     0.200
     7.888    23.205     0.200
     8.509    22.628     0.200
     8.789    24.585     0.200
     9.538    25.874     0.200
    10.494    27.843     0.200
     1.357     5.750     0.200
     1.482     6.778     0.200
     1.534     8.231     0.200
     1.573     6.575     0.200
     1.573     6.091     0.200
     1.767     7.345     0.200
     1.873     7.279     0.200
     2.718    11.318     0.200
     2.924    11.763     0.200
     2.973    11.808     0.200
     3.211    12.800     0.200
     3.596    13.049     0.200
     3.933    13.167     0.200
     3.952    13.145     0.200
     4.206    15.141     0.200
     4.205    12.596     0.200
     5.095    15.700     0.200
     5.517    17.200     0.200
     6.469    18.485     0.200
     6.469    17.797     0.200
     7.018    20.818     0.200
     7.248    21.393     0.200
     7.326    21.184     0.200
     7.936    23.941     0.200
     8.088    26.283     0.200
    10.535    29.917     0.200
    11.441    34.394     0.200
     0.975     4.616     0.200
     1.392     6.530     0.200
     1.526     6.488     0.200
     1.717     7.143     0.200
     1.750     8.173     0.200
     2.017     7.884     0.200
     2.065     7.995     0.200
     2.162     8.436     0.200
     2.204     8.653     0.200
     2.284     8.438     0.200
     2.348     8.554     0.200
     2.675     9.726     0.200
     2.665     9.649     0.200
     2.936    11.764     0.200
     2.921    10.354     0.200
     2.962    10.770     0.200
     3.162    11.237     0.200
     3.775    12.946     0.200
     3.908    13.215     0.200
     4.134    13.362     0.200
     4.359    15.139     0.200
     4.657    15.798     0.200
     4.827    14.743     0.200
     4.926    16.448     0.200
     5.026    15.631     0.200
     5.127    15.673     0.200
     5.259    17.123     0.200
     5.419    17.792     0.200
     5.466    17.281     0.200
     5.466    17.591     0.200
     5.459    17.419     0.200
     5.617    18.256     0.200
     5.783    19.028     0.200
     5.828    18.689     0.200
     6.206    18.620     0.200
     6.206    19.132     0.200
     6.248    20.637     0.200
     6.317    17.558     0.200
     6.762    20.090     0.200
     6.762    20.090     0.200
     6.854    20.970     0.200
     7.146    20.606     0.200
     7.217    20.463     0.200
     7.222    25.630     0.200
     7.492    21.120     0.200
     7.509    22.326     0.200
     7.509    23.031     0.200
     7.527    21.210     0.200
     7.716    22.170     0.200
     7.771    26.504     0.200
     7.844    22.657     0.200
     7.844    22.557     0.200
     7.858    24.427     0.200
     7.945    24.088     0.200
     8.025    23.549     0.200
     8.070    24.753     0.200
     8.098    24.331     0.200
     8.210    25.917     0.200
     8.385    25.051     0.200
     8.387    21.919     0.200
     8.575    23.783     0.200
     8.592    24.460     0.200
     8.745    24.239     0.200
     8.861    27.098     0.200
     8.882    24.956     0.200
     8.949    25.966     0.200
     8.988    27.643     0.200
     9.107    29.794     0.200
     9.215    25.218     0.200
     9.475    27.996     0.200
     9.490    24.092     0.200
     9.489    25.402     0.200
     9.557    25.927     0.200
     9.623    27.956     0.200
     9.711    29.261     0.200
     9.719    28.195     0.200
     9.778    26.360     0.200
     9.824    25.456     0.200
     9.898    29.256     0.200
    10.215    28.057     0.200
    10.338    28.758     0.200
    10.338    28.708     0.200
    10.554    32.421     0.200
    10.617    29.235     0.200
    10.667    27.304     0.200
    10.914    30.735     0.200
    11.105    32.604     0.200
    11.270    32.501     0.200
    11.426    32.582     0.200
    11.493    31.394     0.200
    11.484    36.014     0.200
    11.526    31.281     0.200
    11.526    30.820     0.200
    11.526    31.790     0.200
    11.640    31.697     0.200
    11.729    33.697     0.200
    11.827    33.627     0.200
    11.846    33.926     0.200
    11.951    34.028     0.200
    12.024    32.695     0.200
    12.217    34.194     0.200
    12.338    33.658     0.200
    12.389    36.036     0.200
    12.447    35.534     0.200
    12.470    36.940     0.200
    12.565    32.514     0.200
    12.769    35.752     0.200
    12.771    35.879     0.200
    12.800    37.259     0.200
    12.808    37.428     0.200
    13.018    36.269     0.200
    13.054    37.280     0.200
    13.190    33.929     0.200
    13.300    35.390     0.200
    13.365    37.779     0.200
    13.450    37.324     0.200
    13.654    37.188     0.200
    13.738    38.149     0.200
    13.773    37.218     0.200
    13.836    38.509     0.200
    13.904    38.283     0.200
    13.984    33.109     0.200
    14.708    39.241     0.200
    14.789    39.161     0.200
    14.842    35.299     0.200
    14.837    38.807     0.200
    14.863    37.093     0.200
    15.078    37.677     0.200
    15.146    39.281     0.200
    15.153    37.059     0.200
    15.168    38.485     0.200
    15.244    36.805     0.200
    15.701    39.855     0.200
    15.816    39.435     0.200
    16.097    37.977     0.200
    16.499    38.256     0.200
    16.499    39.908     0.200
    16.551    38.375     0.200
    16.771    39.985     0.200
    17.033    38.285     0.200
    18.253    39.688     0.200
    20.914    39.836     0.200
     0.895     4.687     0.200
     0.927     4.637     0.200
     1.155     7.675     0.200
     1.220     7.137     0.200
     1.367     6.607     0.200
     1.475     6.557     0.200
     1.730     7.952     0.200
     1.756     7.337     0.200
     1.756     6.959     0.200
     1.756     7.227     0.200
     2.068     7.586     0.200
     2.068     7.778     0.200
     2.254     8.857     0.200
     2.615     9.460     0.200
     2.885    11.902     0.200
     3.120    11.535     0.200
     3.170    12.518     0.200
     3.770    12.562     0.200
     3.793    13.545     0.200
     3.876    13.581     0.200
     4.618    15.572     0.200
     4.618    15.463     0.200
     4.880    16.469     0.200
     4.999    15.476     0.200
     6.096    17.699     0.200
     6.154    18.811     0.200
     6.154    19.108     0.200
     7.472    23.482     0.200
     7.822    21.391     0.200
     8.540    24.313     0.200
    10.347    28.657     0.200
    11.478    35.091     0.200
     0.498     5.103     0.200
     1.101     5.784     0.200
     1.188     6.050     0.200
     1.432     6.631     0.200
     1.556     6.929     0.200
     1.583     7.620     0.200
     1.549     8.810     0.200
     1.550     9.689     0.200
     1.653     7.327     0.200
     1.684     7.605     0.200
     2.183     9.035     0.200
     2.377     9.538     0.200
     2.384     9.707     0.200
     2.484     9.312     0.200
     2.853    12.221     0.200
     3.205    13.853     0.200
     3.815    13.940     0.200
     3.946    14.762     0.200
     4.207    13.134     0.200
     4.378    16.706     0.200
     4.667    15.970     0.200
     5.331    17.846     0.200
     5.530    18.073     0.200
     5.613    19.051     0.200
     5.608    17.625     0.200
     6.196    20.182     0.200
     6.280    20.109     0.200
     6.630    25.509     0.200
     6.631    21.636     0.200
     6.726    19.694     0.200
     7.510    21.810     0.200
     7.538    24.290     0.200
     7.647    25.099     0.200
     7.775    23.949     0.200
     8.067    25.147     0.200
     8.090    23.781     0.200
     8.090    23.661     0.200
     8.159    26.676     0.200
     8.159    24.435     0.200
     8.837    23.968     0.200
     9.666    27.681     0.200
    10.866    29.286     0.200
    11.286    32.085     0.200
     1.131     6.043     0.200
     1.168     5.686     0.200
     1.305     7.410     0.200
     1.315     6.215     0.200
     1.450     8.389     0.200
     1.451     8.429     0.200
     1.535     6.914     0.200
     1.560     6.744     0.200
     1.596     7.070     0.200
     1.709     7.385     0.200
     1.717     7.892     0.200
     2.193     8.701     0.200
     2.418     9.332     0.200
     2.420     9.479     0.200
     2.448     8.985     0.200
     2.506    10.052     0.200
     2.511     9.705     0.200
     2.614    10.745     0.200
     2.666     9.521     0.200
     2.716     8.308     0.200
     3.339    12.999     0.200
     3.945    12.694     0.200
     4.021    14.267     0.200
     4.102    13.023     0.200
     4.474    16.161     0.200
     4.646    15.265     0.200
     5.377    17.773     0.200
     5.561    17.680     0.200
     5.579    17.842     0.200
     6.312    20.764     0.200
     6.627    19.074     0.200
     6.753    20.267     0.200
     7.347    21.494     0.200
     7.434    21.486     0.200
     7.515    23.731     0.200
     7.677    24.765     0.200
     7.739    22.079     0.200
     7.796    23.154     0.200
     8.023    23.118     0.200
     8.023    23.363     0.200
     8.014    26.919     0.200
     8.058    24.707     0.200
     8.242    26.848     0.200
     8.730    23.701     0.200
     9.657    29.054     0.200
     9.809    26.150     0.200
    10.746    29.223     0.200
    10.869    30.113     0.200
    11.324    30.821     0.200
    15.270    38.731     0.200
    15.794    40.306     0.200
    15.905    38.760     0.200
    18.500    41.521     0.200
     1.068     5.588     0.200
     1.139     5.893     0.200
     1.145     7.031     0.200
     1.387     6.565     0.200
     1.535     7.709     0.200
     1.544     7.357     0.200
     1.623     7.181     0.200
     1.594     9.148     0.200
     1.707     7.857     0.200
     1.893     8.876     0.200
     2.160     8.676     0.200
     2.168     9.279     0.200
     2.250     8.952     0.200
     2.351     9.587     0.200
     2.497     9.713     0.200
     2.603     9.427     0.200
     2.805    10.211     0.200
     3.157    13.175     0.200
     3.766    13.345     0.200
     3.909    14.852     0.200
     4.237    13.602     0.200
     4.662    16.332     0.200
     5.303    17.811     0.200
     5.567    17.893     0.200
     5.613    18.610     0.200
     5.717    19.358     0.200
     6.148    18.806     0.200
     6.231    19.109     0.200
     6.581    24.177     0.200
     6.581    19.291     0.200
     6.752    19.727     0.200
     7.533    23.581     0.200
     7.623    23.508     0.200
     7.755    22.581     0.200
     7.831    22.494     0.200
     7.880    23.119     0.200
     8.103    24.198     0.200
     9.664    27.298     0.200
    10.067    29.212     0.200
    10.903    29.443     0.200
    10.973    30.275     0.200
    11.260    31.107     0.200
    12.601    35.503     0.200
    12.653    36.738     0.200
    13.431    38.373     0.200
    14.406    38.380     0.200
    14.707    37.747     0.200
    14.703    37.168     0.200
    14.933    39.526     0.200
    15.179    38.982     0.200
    15.232    39.345     0.200
    15.513    38.509     0.200
    16.569    39.744     0.200
    16.848    39.615     0.200
    18.668    40.455     0.200
     0.592     3.960     0.200
     0.616     4.465     0.200
     0.627     4.502     0.200
     0.671     4.746     0.200
     0.859     4.613     0.200
     0.930     4.742     0.200
     1.164     7.878     0.200
     1.401     6.745     0.200
     1.455     6.554     0.200
     1.671     7.093     0.200
     1.718     7.452     0.200
     1.718     7.129     0.200
     1.683     8.295     0.200
     1.890     7.386     0.200
     1.953     7.673     0.200
     2.114     7.953     0.200
     2.127     8.512     0.200
     2.285     8.865     0.200
     2.581     9.572     0.200
     2.594     9.027     0.200
     2.872    11.416     0.200
     2.843     9.917     0.200
     2.861    10.535     0.200
     2.895    10.804     0.200
     3.077    11.982     0.200
     3.126     9.633     0.200
     3.341    11.463     0.200
     3.500    11.495     0.200
     3.749    11.655     0.200
     3.814    11.118     0.200
     4.293    14.613     0.200
     4.352    13.884     0.200
     4.638    16.143     0.200
     4.801    14.760     0.200
     5.464    17.558     0.200
     6.070    17.973     0.200
     6.137    19.576     0.200
     6.354    17.668     0.200
     7.163    21.002     0.200
     7.546    21.092     0.200
     7.814    24.684     0.200
     7.858    22.822     0.200
     7.858    21.877     0.200
     7.906    22.820     0.200
     8.222    21.702     0.200
     8.430    22.066     0.200
     8.525    24.884     0.200
     8.892    23.990     0.200
     9.425    25.657     0.200
     9.746    27.639     0.200
     9.745    27.557     0.200
    10.395    28.744     0.200
    10.644    29.229     0.200
    11.480    31.576     0.200
    15.544    37.575     0.200
    18.280    39.545     0.200
     1.220     5.663     0.200
     1.378     7.838     0.200
     1.395     6.558     0.200
     1.603     6.777     0.200
     2.456     9.147     0.200
     2.663    10.842     0.200
     2.747    12.213     0.200
     2.797    12.893     0.200
     3.041    10.982     0.200
     4.538    15.136     0.200
     4.642    15.941     0.200
     5.413    18.028     0.200
     5.788    18.155     0.200
     5.900    18.908     0.200
     6.830    23.316     0.200
     7.394    21.631     0.200
    10.676    29.664     0.200
    10.824    32.056     0.200
    11.355    31.347     0.200
     1.043     5.246     0.200
     1.094     5.267     0.200
     1.338     5.947     0.200
     1.367     8.388     0.200
     1.650     7.032     0.200
     1.780     7.359     0.200
     1.935     7.644     0.200
     1.956     7.955     0.200
     2.110     8.279     0.200
     2.123     7.726     0.200
     2.242     8.895     0.200
     2.368     9.572     0.200
     2.402     9.322     0.200
     2.586     9.396     0.200
     2.759     9.729     0.200
     2.789     9.701     0.200
     3.084    10.940     0.200
     3.365    16.107     0.200
     3.659    11.018     0.200
     4.465    15.406     0.200
     4.654    15.590     0.200
     5.425    17.785     0.200
     5.688    18.325     0.200
     5.902    18.742     0.200
     6.204    17.686     0.200
     6.318    19.555     0.200
     7.133    20.836     0.200
     7.400    23.599     0.200
     7.445    20.738     0.200
     7.495    23.021     0.200
     7.773    22.545     0.200
     7.773    22.309     0.200
     7.907    25.742     0.200
     7.982    26.205     0.200
     8.276    27.759     0.200
     8.262    22.576     0.200
     8.353    26.378     0.200
     8.445    25.466     0.200
     8.699    28.153     0.200
     9.718    28.947     0.200
    10.193    27.678     0.200
    10.521    29.739     0.200
    10.762    31.192     0.200
    11.381    32.408     0.200
    11.580    35.684     0.200
    12.897    37.356     0.200
    13.170    33.938     0.200
    15.069    37.339     0.200
    16.466    38.530     0.200
    18.157    39.153     0.200
     0.911     5.070     0.200
     0.911     4.756     0.200
     1.065     5.668     0.200
     1.136     5.563     0.200
     1.136     5.413     0.200
     1.307     8.612     0.200
     1.384     6.367     0.200
     1.533     7.175     0.200
     1.542     6.834     0.200
     1.620     7.080     0.200
     1.597     8.683     0.200
     1.598     8.771     0.200
     1.707     7.494     0.200
     2.157     8.398     0.200
     2.165     8.652     0.200
     2.247     8.530     0.200
     2.247     8.987     0.200
     2.348     8.902     0.200
     2.482    11.897     0.200
     2.496     9.164     0.200
     2.511    10.759     0.200
     2.533     9.635     0.200
     2.604     8.972     0.200
     2.604     8.767     0.200
     2.671     9.766     0.200
     2.802    10.080     0.200
     3.906    12.920     0.200
     4.237    12.950     0.200
     4.660    16.067     0.200
     5.300    17.848     0.200
     5.497    17.619     0.200
     5.564    18.512     0.200
     5.612    18.539     0.200
     5.714    19.147     0.200
     6.753    19.098     0.200
     7.526    21.708     0.200
     7.531    23.604     0.200
     7.620    24.343     0.200
     7.752    23.843     0.200
     7.830    22.254     0.200
     8.102    23.846     0.200
     9.647    27.896     0.200
    10.904    29.370     0.200
    10.972    29.872     0.200
    11.257    31.922     0.200
     1.114     7.026     0.200
     1.252     7.787     0.200
     1.252     8.150     0.200
     1.357     6.222     0.200
     1.416     6.726     0.200
     1.610     6.758     0.200
     2.025     8.654     0.200
     2.179     8.401     0.200
     2.179     8.268     0.200
     2.284     9.043     0.200
     2.361     9.602     0.200
     2.494     9.268     0.200
     2.738    10.419     0.200
     2.781    10.858     0.200
     2.974    12.500     0.200
     3.024    12.445     0.200
     3.049    11.632     0.200
     3.393    11.939     0.200
     3.647    13.317     0.200
     3.864    12.961     0.200
     3.894    13.667     0.200
     4.048    13.824     0.200
     4.201    14.686     0.200
     4.607    16.167     0.200
     5.458    18.085     0.200
     5.488    17.477     0.200
     6.041    18.768     0.200
     6.400    18.739     0.200
     7.182    20.841     0.200
     7.259    21.460     0.200
     7.568    21.699     0.200
     7.750    22.101     0.200
     7.871    22.031     0.200
     7.871    21.517     0.200
     7.848    22.542     0.200
    10.468    29.351     0.200
    11.412    32.816     0.200
     0.906     5.020     0.200
     1.026     5.257     0.200
     1.089     5.512     0.200
     1.338     6.213     0.200
     1.354     6.554     0.200
     1.492     6.855     0.200
     1.521     6.928     0.200
     1.583     7.015     0.200
     1.644     8.250     0.200
     1.644     8.929     0.200
     1.644     8.418     0.200
     1.645     9.746     0.200
     1.720     7.334     0.200
     1.843     8.375     0.200
     2.113     8.206     0.200
     2.141     8.302     0.200
     2.200     8.487     0.200
     2.204     8.667     0.200
     2.314     8.820     0.200
     2.312     9.262     0.200
     2.333     9.022     0.200
     2.414     8.667     0.200
     2.492    12.694     0.200
     2.498     8.891     0.200
     2.631     8.989     0.200
     2.631     9.407     0.200
     2.663     9.500     0.200
     2.755     9.876     0.200
     2.761     9.759     0.200
     2.863    10.252     0.200
     3.114    10.698     0.200
     3.114    14.710     0.200
     3.513    11.689     0.200
     3.657    11.895     0.200
     3.717    12.144     0.200
     3.717    12.035     0.200
     3.864    13.213     0.200
     4.285    15.414     0.200
     4.256    12.953     0.200
     4.644    16.330     0.200
     5.193    17.449     0.200
     5.265    17.363     0.200
     5.461    17.496     0.200
     5.517    18.144     0.200
     5.606    18.345     0.200
     5.670    17.817     0.200
     6.098    18.737     0.200
     6.187    19.922     0.200
     6.531    22.187     0.200
     6.532    23.195     0.200
     6.768    19.164     0.200
     7.515    24.021     0.200
     7.531    21.461     0.200
     7.588    23.076     0.200
     7.723    23.797     0.200
     7.834    22.264     0.200
     7.868    23.236     0.200
     7.887    22.484     0.200
     8.073    25.816     0.200
     8.103    23.265     0.200
     8.103    23.562     0.200
     8.534    25.338     0.200
     8.642    25.687     0.200
     8.886    23.723     0.200
     8.918    26.345     0.200
     9.136    26.212     0.200
     9.408    26.234     0.200
     9.539    27.480     0.200
     9.621    27.453     0.200
     9.662    29.403     0.200
     9.680    26.975     0.200
     9.809    34.022     0.200
    10.361    29.727     0.200
    10.685    30.278     0.200
    10.728    29.695     0.200
    10.742    30.383     0.200
    10.873    30.837     0.200
    10.930    33.167     0.200
    10.931    28.983     0.200
    10.980    30.283     0.200
    11.223    31.401     0.200
    11.223    31.650     0.200
    11.364    33.620     0.200
    11.389    34.082     0.200
    11.456    34.028     0.200
    11.575    34.102     0.200
    11.663    33.526     0.200
    11.840    34.564     0.200
    12.075    35.222     0.200
    12.356    36.528     0.200
    12.373    33.918     0.200
    12.398    35.929     0.200
    12.417    35.734     0.200
    12.560    37.323     0.200
    12.611    37.385     0.200
    12.672    38.338     0.200
    12.916    37.349     0.200
    12.985    38.192     0.200
    13.332    39.065     0.200
    13.387    38.435     0.200
    13.429    36.541     0.200
    13.621    36.691     0.200
    13.769    36.184     0.200
    13.817    36.977     0.200
    13.933    37.865     0.200
    13.943    39.678     0.200
    14.001    39.678     0.200
    14.214    39.115     0.200
    14.322    36.186     0.200
    14.361    39.373     0.200
    14.661    39.406     0.200
    14.795    37.459     0.200
    15.182    39.013     0.200
    15.806    39.942     0.200
    16.850    39.926     0.200
    18.606    41.187     0.200
    18.648    42.190     0.200
    19.621    41.183     0.200
     1.054     5.710     0.200
     1.134     5.784     0.200
     1.134     6.210     0.200
     1.134     5.944     0.200
     1.378     6.583     0.200
     1.536     7.559     0.200
     1.529     7.152     0.200
     1.609     7.451     0.200
     1.603     8.596     0.200
     1.604    10.194     0.200
     1.696     7.770     0.200
     1.888     8.659     0.200
     2.149     8.743     0.200
     2.152     8.991     0.200
     2.241     8.852     0.200
     2.249     9.266     0.200
     2.336     9.525     0.200
     2.374    10.792     0.200
     2.363    10.869     0.200
     2.459     9.320     0.200
     2.485    11.524     0.200
     2.501    10.801     0.200
     2.484     9.419     0.200
     2.536    13.356     0.200
     2.596     9.452     0.200
     2.596     9.299     0.200
     2.658     9.988     0.200
     2.798    10.373     0.200
     2.798    10.037     0.200
     2.799    10.123     0.200
     2.908    10.671     0.200
     3.158    11.473     0.200
     3.158    11.891     0.200
     3.558    12.109     0.200
     3.701    12.290     0.200
     3.763    12.613     0.200
     3.763    12.441     0.200
     3.896    13.493     0.200
     4.227    12.494     0.200
     5.289    17.834     0.200
     5.486    17.903     0.200
     5.558    17.961     0.200
     5.599    18.486     0.200
     5.706    18.448     0.200
     6.141    18.980     0.200
     6.231    19.205     0.200
     6.577    20.168     0.200
     6.742    19.622     0.200
     7.518    24.005     0.200
     7.514    21.796     0.200
     7.608    23.677     0.200
     7.740    24.003     0.200
     7.892    23.924     0.200
     7.914    24.165     0.200
     8.088    22.067     0.200
     8.108    23.706     0.200
     8.089    24.122     0.200
     8.563    24.562     0.200
     9.160    26.568     0.200
     9.437    26.796     0.200
     9.565    27.107     0.200
     9.634    28.269     0.200
     9.930    31.727     0.200
    10.044    27.510     0.200
    10.765    28.727     0.200
    10.768    32.161     0.200
    10.879    31.068     0.200
    10.896    29.546     0.200
    10.964    29.972     0.200
    10.960    30.456     0.200
    11.245    31.362     0.200
    11.245    32.001     0.200
    11.941    31.470     0.200
    12.388    36.441     0.200
    12.389    32.239     0.200
    12.588    33.869     0.200
    13.419    37.600     0.200
    13.597    34.574     0.200
    13.773    36.446     0.200
    13.787    36.330     0.200
    14.304    35.196     0.200
    14.695    36.714     0.200
    14.688    36.620     0.200
    14.921    39.291     0.200
    15.139    39.051     0.200
    15.166    38.712     0.200
    15.272    37.910     0.200
    15.433    37.924     0.200
    15.500    38.213     0.200
    15.503    38.255     0.200
    15.648    38.810     0.200
    15.648    39.635     0.200
    15.828    39.845     0.200
    16.035    38.246     0.200
    16.469    39.941     0.200
    16.834    40.038     0.200
    17.251    40.410     0.200
    18.653    41.630     0.200
    20.150    40.704     0.200
     0.945     4.820     0.200
     0.945     4.640     0.200
     1.244     7.926     0.200
     1.285     7.175     0.200
     1.312     8.190     0.200
     1.399     6.723     0.200
     1.478     6.425     0.200
     1.686     7.006     0.200
     1.742     7.558     0.200
     1.973     7.973     0.200
     2.100     8.091     0.200
     2.100     8.251     0.200
     2.150     8.922     0.200
     2.285     8.922     0.200
     2.318     8.920     0.200
     2.586     9.562     0.200
     3.148    13.344     0.200
     3.365    10.450     0.200
     3.803    13.475     0.200
     3.772    15.815     0.200
     3.906    13.362     0.200
     4.645    15.971     0.200
     5.466    17.486     0.200
     5.581    17.726     0.200
     5.791    18.520     0.200
     6.159    18.893     0.200
     6.344    18.604     0.200
     7.159    21.029     0.200
     7.231    20.945     0.200
     7.499    23.045     0.200
     7.541    21.516     0.200
     7.829    25.202     0.200
     7.855    23.086     0.200
     7.855    22.781     0.200
     8.546    26.739     0.200
    10.378    29.112     0.200
    11.495    32.126     0.200
    19.659    42.671     0.200
     0.962     4.804     0.200
     1.242     7.282     0.200
     1.274     7.884     0.200
     1.372     6.901     0.200
     1.347     8.112     0.200
     1.522     6.586     0.200
     1.704     7.059     0.200
     1.764     8.905     0.200
     1.802     7.217     0.200
     2.047     8.042     0.200
     2.213     9.193     0.200
     2.264     8.792     0.200
     2.661     9.692     0.200
     3.163    14.860     0.200
     3.419    13.666     0.200
     4.870    16.383     0.200
     5.447    18.095     0.200
     5.884    18.517     0.200
     6.199    18.959     0.200
     8.368    23.014     0.200
     8.585    26.987     0.200
     9.701    29.197     0.200
    10.321    29.025     0.200
    10.896    31.710     0.200
    11.513    32.092     0.200
    12.024    31.916     0.200
    13.826    37.077     0.200
    14.779    37.763     0.200
    18.637    42.654     0.200
     1.017     4.855     0.200
     1.017     4.674     0.200
     1.337     5.960     0.200
     1.330     8.298     0.200
     1.343     7.501     0.200
     1.343     7.751     0.200
     1.412     8.381     0.200
     1.461     8.073     0.200
     1.618     6.709     0.200
     1.756     7.000     0.200
     1.954     7.401     0.200
     1.880     8.335     0.200
     1.921     7.181     0.200
     1.921     7.419     0.200
     2.076     8.204     0.200
     2.093     7.720     0.200
     2.239     8.548     0.200
     2.334     9.102     0.200
     2.576     9.066     0.200
     2.732     9.536     0.200
     2.757     9.475     0.200
     3.011    11.019     0.200
     3.284    13.783     0.200
     3.332    12.527     0.200
     3.674    10.652     0.200
     3.869    13.140     0.200
     3.956    14.797     0.200
     4.435    15.085     0.200
     4.556    15.597     0.200
     4.643    15.533     0.200
     4.643    15.655     0.200
     4.942    15.948     0.200
     4.972    15.717     0.200
     5.012    15.189     0.200
     4.968    15.586     0.200
     4.968    15.822     0.200
     5.422    17.240     0.200
     5.663    17.719     0.200
     5.999    22.250     0.200
     6.218    17.617     0.200
     6.218    17.179     0.200
     6.247    19.385     0.200
     6.288    18.612     0.200
     6.851    20.182     0.200
     6.872    19.908     0.200
     7.140    20.765     0.200
     7.486    23.210     0.200
     7.777    22.097     0.200
     7.886    21.563     0.200
     7.964    25.231     0.200
     8.022    23.765     0.200
     8.252    29.733     0.200
     8.279    22.007     0.200
     8.422    23.969     0.200
     8.669    24.062     0.200
     9.706    28.721     0.200
     9.879    28.864     0.200
    10.217    28.300     0.200
    10.531    29.030     0.200
    10.898    31.570     0.200
    11.351    30.973     0.200
    11.559    31.884     0.200
    11.873    34.768     0.200
    11.998    34.388     0.200
    18.167    38.352     0.200
     1.301     8.201     0.200
     1.361     6.373     0.200
     1.409     6.801     0.200
     1.618     7.080     0.200
     1.618     6.938     0.200
     2.034     8.542     0.200
     3.656    13.126     0.200
     3.888    13.346     0.200
     4.204    14.714     0.200
     4.252    12.651     0.200
     4.604    15.880     0.200
     5.490    17.463     0.200
     5.698    17.819     0.200
     5.971    17.465     0.200
     6.391    19.072     0.200
     7.063    21.673     0.200
     7.252    21.098     0.200
     7.464    23.272     0.200
     7.847    22.283     0.200
     7.864    22.608     0.200
    10.459    29.210     0.200
    15.456    38.967     0.200
     1.089     5.780     0.200
     1.175     5.940     0.200
     1.175     7.142     0.200
     1.182     7.750     0.200
     1.268     5.896     0.200
     1.419     6.768     0.200
     1.549     7.076     0.200
     1.562     8.760     0.200
     1.563     9.379     0.200
     1.571     7.376     0.200
     1.642     7.472     0.200
     1.687     7.669     0.200
     1.929     8.840     0.200
     2.175     8.973     0.200
     2.187     8.442     0.200
     2.286     9.356     0.200
     2.367     9.409     0.200
     2.376     9.832     0.200
     2.483     9.263     0.200
     2.536    11.068     0.200
     2.574     9.429     0.200
     2.521    11.663     0.200
     2.571    10.726     0.200
     2.667     9.788     0.200
     2.839    10.634     0.200
     3.194    11.700     0.200
     3.802    12.625     0.200
     3.934    13.840     0.200
     4.212    13.144     0.200
     4.662    15.475     0.200
     5.321    17.724     0.200
     5.606    18.529     0.200
     5.599    18.203     0.200
     6.183    18.400     0.200
     6.268    19.372     0.200
     6.566    20.932     0.200
     6.618    19.093     0.200
     7.420    21.794     0.200
     7.511    21.636     0.200
     7.533    22.434     0.200
     7.637    24.775     0.200
     7.766    23.657     0.200
     7.954    23.691     0.200
     8.061    24.705     0.200
     8.090    23.796     0.200
     8.090    23.931     0.200
     8.147    23.783     0.200
     9.658    24.738     0.200
    10.801    29.048     0.200
    10.873    29.514     0.200
    10.955    29.747     0.200
    11.276    31.938     0.200
    12.414    31.802     0.200
    12.424    35.008     0.200
    13.455    37.857     0.200
    14.431    37.725     0.200
    14.959    38.249     0.200
    15.858    39.815     0.200
    18.583    41.215     0.200
     1.046     5.707     0.200
     1.116     5.885     0.200
     1.326     6.763     0.200
     1.363     6.676     0.200
     1.517     7.487     0.200
     1.529     7.188     0.200
     1.601     7.496     0.200
     1.618     8.904     0.200
     1.619    10.490     0.200
     1.709     7.755     0.200
     1.870     8.834     0.200
     2.137     8.738     0.200
     2.152     9.000     0.200
     2.226     8.885     0.200
     2.230     9.400     0.200
     2.331     9.509     0.200
     2.347    10.606     0.200
     2.442     9.783     0.200
     2.493     9.458     0.200
     2.613     9.396     0.200
     2.613     9.154     0.200
     2.664    10.175     0.200
     2.782    10.348     0.200
     2.782    10.083     0.200
     2.786    10.324     0.200
     2.890    10.611     0.200
     3.139    12.729     0.200
     3.886    13.766     0.200
     4.242    12.532     0.200
     4.650    16.280     0.200
     5.282    17.570     0.200
     5.479    17.774     0.200
     5.543    17.896     0.200
     5.605    18.709     0.200
     5.694    17.887     0.200
     6.125    18.227     0.200
     8.044    24.084     0.200
     8.096    23.281     0.200
     8.099    23.877     0.200
     8.099    23.752     0.200
     9.633    25.755     0.200
    10.880    29.281     0.200
    10.913    29.162     0.200
    10.972    29.898     0.200
    11.240    31.548     0.200
    15.128    38.471     0.200
    15.208    38.165     0.200
    18.599    41.962     0.200
     0.940     4.905     0.200
     1.224     7.982     0.200
     1.249     7.304     0.200
     1.420     7.123     0.200
     1.455     6.806     0.200
     1.679     7.063     0.200
     1.666     8.217     0.200
     1.708     7.375     0.200
     1.708     7.484     0.200
     1.708     7.055     0.200
     1.955     8.102     0.200
     2.133     8.501     0.200
     2.133     7.865     0.200
     2.114     9.014     0.200
     2.302     8.960     0.200
     2.313     8.884     0.200
     2.596     9.967     0.200
     2.623     9.850     0.200
     2.843    10.551     0.200
     2.874    11.719     0.200
     2.878    11.124     0.200
     3.063    14.128     0.200
     3.124    11.153     0.200
     3.111    12.795     0.200
     3.735    14.475     0.200
     3.834    12.430     0.200
     4.295    14.339     0.200
     4.341    14.656     0.200
     4.485    16.400     0.200
     4.652    15.794     0.200
     5.481    17.728     0.200
     5.571    17.877     0.200
     5.780    18.500     0.200
     6.138    18.817     0.200
     6.373    18.248     0.200
     7.182    20.881     0.200
     7.255    21.285     0.200
     7.509    23.409     0.200
     7.876    22.291     0.200
     7.876    23.029     0.200
     7.916    22.586     0.200
     8.089    25.179     0.200
     8.527    23.799     0.200
    10.413    29.103     0.200
    10.909    30.439     0.200
    11.488    31.602     0.200
     1.012     5.165     0.200
     1.012     4.930     0.200
     1.073     5.174     0.200
     1.317     6.378     0.200
     1.367     7.094     0.200
     1.367     8.411     0.200
     1.353     8.407     0.200
     1.406     7.212     0.200
     1.435     8.323     0.200
     1.622     6.990     0.200
     1.750     7.449     0.200
     1.930     7.753     0.200
     1.930     7.390     0.200
     1.901     8.921     0.200
     1.935     7.798     0.200
     2.093     7.808     0.200
     2.219     8.725     0.200
     2.372     9.031     0.200
     2.352     9.428     0.200
     2.560     9.408     0.200
     2.728     9.987     0.200
     2.761    10.017     0.200
     3.191    11.963     0.200
     3.351    15.069     0.200
     4.627    15.793     0.200
     4.695    16.642     0.200
     5.403    17.420     0.200
     5.657    17.831     0.200
     6.195    17.410     0.200
     6.289    19.210     0.200
     6.881    22.110     0.200
     7.117    21.182     0.200
     7.470    22.168     0.200
     7.755    23.553     0.200
     8.669    24.238     0.200
    10.193    28.988     0.200
    11.550    32.526     0.200
     1.073     5.805     0.200
     1.176     6.037     0.200
     1.181     7.646     0.200
     1.192     7.329     0.200
     1.197     7.808     0.200
     1.205     7.278     0.200
     1.268     6.957     0.200
     1.410     6.756     0.200
     1.527     7.115     0.200
     1.580     7.547     0.200
     1.624     7.373     0.200
     1.664     7.623     0.200
     1.929     8.710     0.200
     2.175     8.743     0.200
     2.275     8.885     0.200
     2.292     9.272     0.200
     2.348     9.348     0.200
     2.391    10.069     0.200
     2.460     8.942     0.200
     2.529    11.902     0.200
     2.556     9.397     0.200
     2.556     9.616     0.200
     3.202    11.678     0.200
     3.805    12.414     0.200
     3.920    14.452     0.200
     3.973    14.028     0.200
     4.192    12.248     0.200
     4.638    15.168     0.200
     5.302    18.565     0.200
     5.501    17.563     0.200
     5.582    18.165     0.200
     5.592    17.823     0.200
     5.733    19.255     0.200
     6.179    19.529     0.200
     6.547    20.296     0.200
     6.616    19.672     0.200
     6.708    19.465     0.200
     8.066    23.001     0.200
     8.066    23.767     0.200
    10.856    29.196     0.200
    11.257    30.290     0.200
    15.678    38.124     0.200
    15.678    36.570     0.200
     1.071     6.089     0.200
     1.081     5.402     0.200
     1.081     5.672     0.200
     1.152     6.225     0.200
     1.360     8.648     0.200
     1.411     7.966     0.200
     1.411     8.497     0.200
     1.411     8.386     0.200
     1.475     7.842     0.200
     1.449     9.002     0.200
     1.542     8.137     0.200
     1.702     8.005     0.200
     1.816     8.071     0.200
     1.961     9.022     0.200
     2.014     8.427     0.200
     2.014     8.854     0.200
     1.900     7.854     0.200
     2.435     9.398     0.200
     2.841    11.102     0.200
     3.087    13.131     0.200
     3.173    11.908     0.200
     3.421    13.482     0.200
     3.629    13.866     0.200
     4.046    15.938     0.200
     4.512    16.003     0.200
     4.667    16.731     0.200
     4.607    15.470     0.200
     4.607    11.510     0.200
     5.425    18.113     0.200
     5.724    19.738     0.200
     6.334    20.350     0.200
     6.175    19.076     0.200
     6.367    21.073     0.200
     6.906    24.147     0.200
     6.962    23.081     0.200
     7.504    24.980     0.200
     7.761    23.825     0.200
     7.761    24.516     0.200
     8.009    26.962     0.200
     8.052    26.045     0.200
     8.113    27.216     0.200
     8.311    27.486     0.200
     8.478    27.113     0.200
     9.573    29.751     0.200
     9.820    28.212     0.200
    10.149    29.673     0.200
    10.754    30.277     0.200
    10.816    31.282     0.200
    10.919    30.313     0.200
    11.571    34.102     0.200
    11.612    33.763     0.200
    12.939    37.522     0.200
    13.871    35.969     0.200
    15.851    40.304     0.200
    18.134    41.717     0.200
     0.965     5.496     0.200
     0.965     5.369     0.200
     1.029     5.713     0.200
     1.029     5.574     0.200
     1.304     6.507     0.200
     1.416     6.890     0.200
     1.414     7.610     0.200
     1.557     6.981     0.200
     1.587     7.137     0.200
     1.685     9.033     0.200
     1.686     9.870     0.200
     1.783     7.910     0.200
     1.794     7.909     0.200
     2.132     8.637     0.200
     2.160     8.502     0.200
     2.171     8.940     0.200
     2.253     9.253     0.200
     2.365    11.701     0.200
     2.564     9.585     0.200
     2.707     9.765     0.200
     2.707    10.288     0.200
     2.718     9.824     0.200
     2.712     9.997     0.200
     3.651    12.555     0.200
     3.838    13.052     0.200
     3.848    13.934     0.200
     4.253    14.812     0.200
     4.334    12.547     0.200
     4.688    16.107     0.200
     5.269    18.419     0.200
     5.476    18.424     0.200
     5.662    18.926     0.200
     6.049    18.953     0.200
     6.468    20.967     0.200
     6.474    21.855     0.200
     6.524    22.916     0.200
     6.844    19.927     0.200
     7.504    22.282     0.200
     7.558    24.431     0.200
     7.599    22.201     0.200
     7.742    24.492     0.200
     7.871    22.808     0.200
     7.884    22.305     0.200
     8.051    23.149     0.200
     8.072    24.890     0.200
     8.167    23.845     0.200
     8.167    24.270     0.200
     8.964    26.770     0.200
     8.964    24.687     0.200
     9.401    27.956     0.200
     9.647    27.829     0.200
     9.698    28.415     0.200
     9.880    27.950     0.200
    10.416    31.990     0.200
    10.910    32.196     0.200
    11.012    30.321     0.200
    11.051    31.233     0.200
    11.231    31.469     0.200
    11.663    32.286     0.200
    14.344    37.092     0.200
    14.644    35.965     0.200
    14.866    38.014     0.200
    15.162    37.926     0.200
    15.580    39.562     0.200
    15.580    36.924     0.200
    18.676    41.928     0.200
     0.448     3.901     0.200
     0.715     5.583     0.200
     1.073     5.317     0.200
     1.367     6.412     0.200
     1.316     7.659     0.200
     1.357     7.564     0.200
     1.424     7.009     0.200
     1.402     7.881     0.200
     1.675     7.085     0.200
     1.811     7.492     0.200
     1.950     7.336     0.200
     1.908     8.711     0.200
     1.969     7.811     0.200
     2.130     7.768     0.200
     2.150     8.353     0.200
     2.272     9.014     0.200
     2.374     9.197     0.200
     2.434     9.055     0.200
     2.617     9.493     0.200
     2.788     9.981     0.200
     2.814     9.999     0.200
     3.093    11.174     0.200
     3.120    10.865     0.200
     3.253    11.174     0.200
     3.492    11.520     0.200
     3.584    13.412     0.200
     3.678    10.660     0.200
     4.493    14.971     0.200
     4.685    16.005     0.200
     5.455    17.736     0.200
     5.933    18.589     0.200
     6.223    17.384     0.200
     6.303    18.309     0.200
     6.345    18.919     0.200
     6.905    22.722     0.200
     6.926    20.654     0.200
     7.093    21.026     0.200
     7.158    20.543     0.200
     7.526    22.951     0.200
     7.939    24.555     0.200
     8.014    24.725     0.200
     8.130    24.871     0.200
     8.384    23.676     0.200
     8.476    25.575     0.200
     8.726    24.527     0.200
     9.084    27.047     0.200
     9.570    28.789     0.200
     9.831    29.350     0.200
    10.203    27.994     0.200
    11.612    31.050     0.200
    12.625    33.987     0.200
    12.927    36.816     0.200
    14.904    37.790     0.200
    16.316    39.283     0.200
     1.077     7.235     0.200
     1.225     5.376     0.200
     1.293     2.531     0.200
     1.687     7.607     0.200
     1.706     7.475     0.200
     1.736     8.103     0.200
     1.742     8.299     0.200
     1.757     8.188     0.200
     2.071     9.040     0.200
     3.829    12.883     0.200
     4.339    14.405     0.200
     4.645    15.776     0.200
     4.795    15.251     0.200
     5.215    17.753     0.200
     5.474    17.950     0.200
     6.368    18.839     0.200
     7.526    22.137     0.200
     7.752    27.361     0.200
     7.870    23.417     0.200
     8.004    25.894     0.200
     8.048    25.683     0.200
     8.673    23.343     0.200
     8.879    26.472     0.200
     9.704    29.128     0.200
    14.021    33.379     0.200
    16.268    36.040     0.200
     0.626     5.104     0.200
     0.804     4.080     0.200
     0.854     4.468     0.200
     0.891     4.785     0.200
     0.952     4.800     0.200
     1.014     5.362     0.200
     1.175     6.971     0.200
     1.179     6.082     0.200
     1.227     4.949     0.200
     1.246     7.776     0.200
     1.265     7.992     0.200
     1.312     7.883     0.200
     1.397     6.446     0.200
     1.449     6.156     0.200
     1.485     7.090     0.200
     1.607     7.752     0.200
     1.633     7.830     0.200
     1.664     6.813     0.200
     1.682     7.774     0.200
     1.682     7.971     0.200
     1.697     7.271     0.200
     1.714     7.170     0.200
     1.714     6.962     0.200
     1.745     7.680     0.200
     1.753     7.642     0.200
     1.766     7.796     0.200
     1.824     7.800     0.200
     1.947     7.387     0.200
     2.113     7.831     0.200
     2.113     7.564     0.200
     2.125     8.156     0.200
     2.280     8.733     0.200
     2.575     9.274     0.200
     2.588     8.887     0.200
     2.861     9.579     0.200
     2.894    10.165     0.200
     3.074     9.975     0.200
     3.109    11.572     0.200
     3.123    11.033     0.200
     3.263    10.466     0.200
     3.336    12.063     0.200
     3.397    15.461     0.200
     3.747    11.248     0.200
     3.812    11.714     0.200
     3.898    13.028     0.200
     4.260    13.129     0.200
     4.449    14.012     0.200
     5.207    17.419     0.200
     5.460    17.607     0.200
     6.131    17.908     0.200
     6.352    17.508     0.200
     6.679    24.643     0.200
     7.488    23.283     0.200
     7.509    21.497     0.200
     7.854    22.791     0.200
     7.993    25.506     0.200
     8.036    26.335     0.200
     8.865    26.486     0.200
     9.692    29.009     0.200
    10.394    28.871     0.200
    10.394    28.870     0.200
    10.889    31.966     0.200
    12.753    33.222     0.200
     1.025     5.448     0.200
     1.031     5.464     0.200
     1.116     5.714     0.200
     1.228     8.044     0.200
     1.226     8.116     0.200
     1.223     7.809     0.200
     1.352     6.414     0.200
     1.329     8.694     0.200
     1.503     6.726     0.200
     1.526     7.186     0.200
     1.580     7.329     0.200
     1.629     8.802     0.200
     1.630     9.681     0.200
     1.684     7.427     0.200
     1.869     8.559     0.200
     2.121     8.372     0.200
     2.125     8.455     0.200
     2.216     8.622     0.200
     2.236     8.909     0.200
     2.472    10.500     0.200
     2.474    11.524     0.200
     2.467     8.885     0.200
     2.527    12.382     0.200
     2.594     8.995     0.200
     2.637     9.488     0.200
     2.775    10.061     0.200
     3.148    12.933     0.200
     3.746    12.304     0.200
     3.913    12.804     0.200
     4.220    12.467     0.200
     4.622    15.596     0.200
     5.260    17.684     0.200
     5.457    17.742     0.200
     5.533    18.096     0.200
     5.578    17.394     0.200
     5.678    17.234     0.200
     6.118    17.807     0.200
     6.507    21.247     0.200
     6.555    22.371     0.200
     6.560    20.537     0.200
     6.732    19.257     0.200
     7.406    21.656     0.200
     7.493    22.783     0.200
     7.499    21.561     0.200
     7.712    23.165     0.200
     7.845    25.982     0.200
     7.863    22.235     0.200
     7.885    22.397     0.200
     7.907    24.271     0.200
     8.017    24.424     0.200
     8.072    23.543     0.200
     8.535    23.431     0.200
     9.131    26.938     0.200
     9.408    26.445     0.200
     9.536    27.576     0.200
     9.607    26.944     0.200
    10.853    31.221     0.200
    10.894    28.530     0.200
    10.936    32.472     0.200
    10.946    30.034     0.200
    11.217    29.711     0.200
    11.925    34.339     0.200
    12.359    37.339     0.200
    14.289    34.526     0.200
    14.365    38.994     0.200
    14.660    36.727     0.200
    14.667    36.918     0.200
    15.111    38.439     0.200
    15.622    39.196     0.200
    15.799    38.514     0.200
     1.089     5.745     0.200
     1.173     5.874     0.200
     1.173     5.666     0.200
     1.172     7.002     0.200
     1.270     6.677     0.200
     1.417     6.694     0.200
     1.550     7.012     0.200
     1.569     7.419     0.200
     1.564     8.632     0.200
     1.641     7.416     0.200
     1.689     7.583     0.200
     1.927     8.572     0.200
     2.176     8.767     0.200
     2.186     8.634     0.200
     2.281     8.807     0.200
     2.284     9.399     0.200
     2.367     9.515     0.200
     2.373     9.558     0.200
     2.380     9.568     0.200
     2.485     9.267     0.200
     2.518    11.930     0.200
     2.568     9.843     0.200
     2.576     9.085     0.200
     2.576     8.905     0.200
     2.838    10.023     0.200
     3.191    13.917     0.200
     3.740    12.223     0.200
     3.800    12.661     0.200
     3.933    13.820     0.200
     3.974    12.356     0.200
     4.039    13.509     0.200
     4.214    11.846     0.200
     4.663    15.632     0.200
     5.321    17.725     0.200
     5.518    17.705     0.200
     5.607    18.181     0.200
     5.744    17.748     0.200
     6.181    19.321     0.200
     6.566    23.472     0.200
     6.615    22.179     0.200
     6.732    19.277     0.200
     7.422    21.001     0.200
     7.513    21.500     0.200
     7.533    23.182     0.200
     7.637    24.994     0.200
     7.766    23.694     0.200
     7.955    23.923     0.200
     8.092    23.701     0.200
     8.092    23.587     0.200
     9.643    26.904     0.200
     9.659    27.652     0.200
    10.876    29.182     0.200
    10.957    32.014     0.200
     0.947     5.304     0.200
     1.009     5.779     0.200
     1.222     5.273     0.200
     1.328     6.006     0.200
     1.311     8.070     0.200
     1.398     7.265     0.200
     1.445     6.687     0.200
     1.481     8.145     0.200
     1.541     6.794     0.200
     1.555     6.648     0.200
     1.603     8.158     0.200
     1.661     7.337     0.200
     1.678     8.789     0.200
     1.678     8.864     0.200
     1.692     7.634     0.200
     1.709     7.157     0.200
     1.741     7.762     0.200
     1.749     8.196     0.200
     1.762     8.090     0.200
     1.820     8.084     0.200
     1.880     7.825     0.200
     1.880     8.087     0.200
     1.943     8.119     0.200
     1.993     8.207     0.200
     2.031     8.773     0.200
     2.039     8.659     0.200
     2.120     8.996     0.200
     2.115     8.201     0.200
     2.115     7.642     0.200
     2.280     9.350     0.200
     2.294     9.211     0.200
     2.419     9.755     0.200
     2.461    10.185     0.200
     2.461    10.642     0.200
     2.496    10.274     0.200
     2.574    10.349     0.200
     2.584     9.942     0.200
     2.608    10.176     0.200
     2.753    10.277     0.200
     2.835    10.867     0.200
     2.836    11.545     0.200
     2.861    11.800     0.200
     2.858    10.790     0.200
     2.890    10.703     0.200
     2.938    10.856     0.200
     2.985    13.682     0.200
     3.001    10.824     0.200
     3.015    11.083     0.200
     3.070    11.279     0.200
     3.106    11.085     0.200
     3.119    11.663     0.200
     3.258    11.400     0.200
     3.266    11.622     0.200
     3.290    12.436     0.200
     3.331    11.328     0.200
     3.331    11.762     0.200
     3.492    12.687     0.200
     3.742    12.986     0.200
     3.742    13.521     0.200
     3.768    12.194     0.200
     3.820    12.738     0.200
     3.814    11.692     0.200
     3.844    13.958     0.200
     3.898    14.062     0.200
     4.060    13.846     0.200
     4.145    13.991     0.200
     4.214    17.677     0.200
     4.248    13.903     0.200
     4.283    14.567     0.200
     4.322    13.715     0.200
     4.343    13.917     0.200
     4.440    14.369     0.200
     4.482    14.595     0.200
     4.631    16.106     0.200
     4.631    16.500     0.200
     4.791    16.194     0.200
     4.800    14.976     0.200
     4.880    16.482     0.200
     4.909    17.265     0.200
     4.996    15.584     0.200
     5.026    16.527     0.200
     5.051    17.729     0.200
     5.070    16.519     0.200
     5.180    16.080     0.200
     5.204    17.868     0.200
     5.235    16.943     0.200
     5.366    17.944     0.200
     5.405    17.312     0.200
     5.459    18.111     0.200
     5.459    17.974     0.200
     5.554    18.183     0.200
     5.548    19.489     0.200
     5.725    19.745     0.200
     5.764    18.533     0.200
     6.060    18.885     0.200
     6.127    19.097     0.200
     6.127    19.199     0.200
     6.141    20.856     0.200
     6.170    20.040     0.200
     6.197    21.007     0.200
     6.353    18.764     0.200
     6.353    17.846     0.200
     6.675    21.335     0.200
     6.759    22.530     0.200
     6.778    21.602     0.200
     6.806    22.057     0.200
     6.817    19.139     0.200
     7.134    25.280     0.200
     7.154    21.614     0.200
     7.160    21.443     0.200
     7.234    21.302     0.200
     7.256    22.040     0.200
     7.487    23.614     0.200
     7.487    22.880     0.200
     7.510    22.210     0.200
     7.738    27.415     0.200
     7.805    24.744     0.200
     7.854    23.741     0.200
     7.854    23.116     0.200
     7.854    22.804     0.200
     7.897    24.347     0.200
     7.991    24.809     0.200
     8.034    25.799     0.200
     8.212    27.773     0.200
     8.212    26.206     0.200
     8.327    24.207     0.200
     8.349    24.869     0.200
     8.431    23.164     0.200
     8.515    25.132     0.200
     8.515    24.983     0.200
     8.803    27.663     0.200
     8.864    25.979     0.200
     8.864    26.330     0.200
     8.882    27.139     0.200
     8.927    26.858     0.200
     8.978    28.568     0.200
     9.011    26.960     0.200
     9.195    29.862     0.200
     9.254    26.013     0.200
     9.274    27.947     0.200
     9.415    28.342     0.200
     9.483    29.071     0.200
     9.563    28.300     0.200
     9.662    27.689     0.200
     9.690    29.561     0.200
     9.738    29.219     0.200
     9.739    27.737     0.200
     9.757    28.641     0.200
     9.767    28.247     0.200
     9.836    30.266     0.200
     9.881    28.948     0.200
     9.917    30.169     0.200
    10.021    29.258     0.200
    10.099    29.361     0.200
    10.189    29.591     0.200
    10.186    28.893     0.200
    10.191    28.634     0.200
    10.211    30.197     0.200
    10.211    31.552     0.200
    10.260    29.254     0.200
    10.288    30.116     0.200
    10.397    28.990     0.200
    10.416    30.009     0.200
    10.430    31.672     0.200
    10.466    32.129     0.200
    10.478    30.482     0.200
    10.491    34.245     0.200
    10.544    30.951     0.200
    10.579    32.030     0.200
    10.614    30.494     0.200
    10.647    30.740     0.200
    10.647    30.365     0.200
    10.642    31.895     0.200
    10.642    29.505     0.200
    10.760    30.547     0.200
    10.771    31.198     0.200
    10.820    31.979     0.200
    10.827    30.147     0.200
    10.890    33.520     0.200
    10.887    31.247     0.200
    10.887    30.317     0.200
    10.915    31.073     0.200
    10.922    31.023     0.200
    10.982    33.075     0.200
    10.991    31.237     0.200
    11.043    32.005     0.200
    11.070    32.053     0.200
    11.095    32.080     0.200
    11.127    31.195     0.200
    11.127    33.105     0.200
    11.124    33.277     0.200
    11.191    32.467     0.200
    11.183    32.957     0.200
    11.198    33.217     0.200
    11.198    32.471     0.200
    11.197    31.365     0.200
    11.304    31.615     0.200
    11.351    33.117     0.200
    11.351    33.410     0.200
    11.338    32.473     0.200
    11.349    32.640     0.200
    11.396    36.702     0.200
    11.401    33.318     0.200
    11.413    32.992     0.200
    11.420    33.419     0.200
    11.420    32.658     0.200
    11.433    32.852     0.200
    11.459    33.121     0.200
    11.459    34.371     0.200
    11.470    31.602     0.200
    11.471    31.940     0.200
    11.484    32.572     0.200
    11.509    33.709     0.200
    11.533    32.393     0.200
    11.544    32.580     0.200
    11.572    32.085     0.200
    11.590    33.612     0.200
    11.586    31.223     0.200
    11.579    31.657     0.200
    11.667    34.408     0.200
    11.659    32.547     0.200
    11.659    31.266     0.200
    11.682    33.251     0.200
    11.727    32.565     0.200
    11.765    34.808     0.200
    11.784    35.465     0.200
    11.865    32.519     0.200
    11.888    35.072     0.200
    11.895    33.110     0.200
    11.962    35.242     0.200
    11.973    35.023     0.200
    11.969    34.326     0.200
    11.988    34.154     0.200
    11.991    35.585     0.200
    11.986    33.967     0.200
    12.009    35.156     0.200
    12.007    36.589     0.200
    12.028    35.195     0.200
    12.031    34.051     0.200
    12.031    33.153     0.200
    12.072    34.379     0.200
    12.080    34.476     0.200
    12.076    34.239     0.200
    12.110    33.473     0.200
    12.121    34.346     0.200
    12.136    34.165     0.200
    12.154    35.622     0.200
    12.156    36.065     0.200
    12.197    32.800     0.200
    12.187    33.576     0.200
    12.225    33.606     0.200
    12.256    35.178     0.200
    12.259    33.715     0.200
    12.258    33.696     0.200
    12.303    38.292     0.200
    12.326    34.985     0.200
    12.326    34.625     0.200
    12.330    34.041     0.200
    12.384    36.936     0.200
    12.432    34.058     0.200
    12.460    35.338     0.200
    12.484    34.255     0.200
    12.487    34.107     0.200
    12.522    33.895     0.200
    12.522    34.860     0.200
    12.524    34.423     0.200
    12.546    35.220     0.200
    12.588    34.793     0.200
    12.594    33.957     0.200
    12.601    34.590     0.200
    12.620    35.080     0.200
    12.635    34.908     0.200
    12.627    34.603     0.200
    12.679    34.895     0.200
    12.705    35.363     0.200
    12.709    34.382     0.200
    12.709    36.042     0.200
    12.718    37.739     0.200
    12.701    33.742     0.200
    12.718    35.478     0.200
    12.721    34.157     0.200
    12.738    37.927     0.200
    12.794    34.979     0.200
    12.785    35.647     0.200
    12.794    34.325     0.200
    12.815    35.821     0.200
    12.813    35.227     0.200
    12.826    36.551     0.200
    12.832    34.796     0.200
    12.847    36.589     0.200
    12.860    38.520     0.200
    12.859    35.648     0.200
    12.886    37.804     0.200
    12.894    34.940     0.200
    12.953    35.107     0.200
    12.964    38.157     0.200
    12.948    34.169     0.200
    12.988    39.345     0.200
    12.990    37.491     0.200
    12.995    35.824     0.200
    13.001    36.879     0.200
    13.010    33.918     0.200
    13.013    34.480     0.200
    13.040    35.954     0.200
    13.074    34.341     0.200
    13.102    35.170     0.200
    13.103    34.875     0.200
    13.115    34.902     0.200
    13.160    35.536     0.200
    13.174    35.222     0.200
    13.196    35.797     0.200
    13.192    35.079     0.200
    13.224    35.661     0.200
    13.224    34.372     0.200
    13.249    35.774     0.200
    13.272    35.560     0.200
    13.295    39.537     0.200
    13.282    36.334     0.200
    13.297    35.392     0.200
    13.307    34.800     0.200
    13.334    36.489     0.200
    13.355    35.095     0.200
    13.366    39.634     0.200
    13.351    35.417     0.200
    13.347    36.337     0.200
    13.347    35.528     0.200
    13.375    35.907     0.200
    13.373    35.635     0.200
    13.398    35.717     0.200
    13.400    36.018     0.200
    13.403    35.493     0.200
    13.411    34.784     0.200
    13.417    35.480     0.200
    13.461    35.880     0.200
    13.514    35.555     0.200
    13.555    35.830     0.200
    13.567    38.979     0.200
    13.562    34.632     0.200
    13.585    35.288     0.200
    13.652    40.252     0.200
    13.657    35.838     0.200
    13.673    35.753     0.200
    13.672    35.989     0.200
    13.713    37.726     0.200
    13.738    35.406     0.200
    13.747    35.027     0.200
    13.747    34.312     0.200
    13.766    38.386     0.200
    13.763    35.950     0.200
    13.771    35.606     0.200
    13.804    36.108     0.200
    13.801    35.646     0.200
    13.828    36.411     0.200
    13.850    38.670     0.200
    13.838    35.931     0.200
    13.879    36.001     0.200
    13.905    36.202     0.200
    13.892    35.599     0.200
    13.900    36.116     0.200
    13.912    35.801     0.200
    13.926    35.373     0.200
    13.948    35.885     0.200
    13.967    36.423     0.200
    13.984    37.064     0.200
    14.006    35.853     0.200
    14.035    36.188     0.200
    14.037    36.687     0.200
    14.081    36.351     0.200
    14.087    37.017     0.200
    14.082    36.784     0.200
    14.103    36.403     0.200
    14.105    36.623     0.200
    14.111    36.653     0.200
    14.195    36.727     0.200
    14.208    36.808     0.200
    14.218    35.675     0.200
    14.225    36.592     0.200
    14.238    38.306     0.200
    14.224    36.934     0.200
    14.268    37.301     0.200
    14.268    36.549     0.200
    14.307    36.528     0.200
    14.327    37.206     0.200
    14.339    35.875     0.200
    14.366    36.789     0.200
    14.384    36.829     0.200
    14.414    37.028     0.200
    14.430    37.473     0.200
    14.477    36.926     0.200
    14.476    36.375     0.200
    14.533    39.790     0.200
    14.531    35.943     0.200
    14.547    36.504     0.200
    14.539    35.926     0.200
    14.545    35.947     0.200
    14.550    36.292     0.200
    14.569    36.841     0.200
    14.565    36.556     0.200
    14.585    36.496     0.200
    14.585    36.543     0.200
    14.634    37.147     0.200
    14.634    40.276     0.200
    14.628    36.471     0.200
    14.619    37.094     0.200
    14.648    36.778     0.200
    14.659    35.866     0.200
    14.679    36.685     0.200
    14.685    37.106     0.200
    14.713    36.721     0.200
    14.747    37.157     0.200
    14.765    40.084     0.200
    14.772    36.977     0.200
    14.801    36.773     0.200
    14.799    36.770     0.200
    14.804    36.562     0.200
    14.799    37.278     0.200
    14.801    35.708     0.200
    14.826    36.873     0.200
    14.840    36.425     0.200
    14.867    37.826     0.200
    14.865    36.268     0.200
    14.873    37.145     0.200
    14.882    36.943     0.200
    14.882    36.017     0.200
    14.900    36.315     0.200
    14.985    37.412     0.200
    15.035    38.070     0.200
    15.056    36.773     0.200
    15.072    40.394     0.200
    15.079    38.166     0.200
    15.077    37.065     0.200
    15.082    37.620     0.200
    15.110    37.435     0.200
    15.116    37.061     0.200
    15.116    38.565     0.200
    15.158    36.943     0.200
    15.169    37.667     0.200
    15.169    38.440     0.200
    15.170    37.668     0.200
    15.183    37.225     0.200
    15.204    37.606     0.200
    15.211    38.059     0.200
    15.214    37.556     0.200
    15.241    37.561     0.200
    15.225    37.201     0.200
    15.246    37.670     0.200
    15.257    37.322     0.200
    15.257    38.057     0.200
    15.296    38.383     0.200
    15.302    38.246     0.200
    15.309    40.803     0.200
    15.311    36.740     0.200
    15.316    37.806     0.200
    15.329    37.418     0.200
    15.345    37.759     0.200
    15.385    37.229     0.200
    15.377    37.366     0.200
    15.394    37.532     0.200
    15.427    38.110     0.200
    15.505    38.376     0.200
    15.534    40.590     0.200
    15.583    38.348     0.200
    15.638    37.566     0.200
    15.673    37.924     0.200
    15.716    39.669     0.200
    15.706    37.704     0.200
    15.704    38.307     0.200
    15.715    37.946     0.200
    15.738    39.747     0.200
    15.739    38.327     0.200
    15.749    38.752     0.200
    15.747    38.203     0.200
    15.771    38.886     0.200
    15.834    38.411     0.200
    15.850    37.742     0.200
    15.841    38.044     0.200
    15.842    38.764     0.200
    15.868    37.431     0.200
    15.884    37.482     0.200
    15.907    39.081     0.200
    15.892    38.198     0.200
    15.910    38.931     0.200
    15.919    38.005     0.200
    15.971    37.803     0.200
    15.985    38.974     0.200
    16.043    40.405     0.200
    16.064    37.447     0.200
    16.093    37.889     0.200
    16.093    40.741     0.200
    16.090    37.734     0.200
    16.124    38.605     0.200
    16.134    39.061     0.200
    16.155    38.147     0.200
    16.198    38.217     0.200
    16.213    38.651     0.200
    16.220    37.743     0.200
    16.239    38.679     0.200
    16.341    39.112     0.200
    16.358    39.584     0.200
    16.381    38.743     0.200
    16.388    37.968     0.200
    16.424    39.526     0.200
    16.444    39.116     0.200
    16.461    40.060     0.200
    16.463    39.790     0.200
    16.472    38.564     0.200
    16.485    38.870     0.200
    16.485    41.226     0.200
    16.501    38.237     0.200
    16.508    38.266     0.200
    16.527    38.782     0.200
    16.567    37.986     0.200
    16.567    40.607     0.200
    16.627    40.377     0.200
    16.641    39.105     0.200
    16.648    38.779     0.200
    16.648    40.540     0.200
    16.692    38.955     0.200
    16.737    38.560     0.200
    16.748    38.593     0.200
    16.792    38.975     0.200
    16.810    38.484     0.200
    16.918    39.125     0.200
    16.942    39.953     0.200
    16.965    38.751     0.200
    17.008    38.991     0.200
    17.061    39.785     0.200
    17.051    36.761     0.200
    17.066    39.012     0.200
    17.059    39.675     0.200
    17.080    39.169     0.200
    17.085    38.359     0.200
    17.089    39.494     0.200
    17.249    38.358     0.200
    17.318    39.317     0.200
    17.393    39.427     0.200
    17.409    39.529     0.200
    17.499    39.945     0.200
    17.541    39.376     0.200
    17.548    39.672     0.200
    17.615    39.840     0.200
    17.625    39.271     0.200
    17.636    39.909     0.200
    17.658    40.166     0.200
    17.658    39.951     0.200
    17.650    39.948     0.200
    17.688    39.106     0.200
    17.766    40.579     0.200
    17.765    39.881     0.200
    17.902    41.234     0.200
    17.983    40.979     0.200
    17.988    40.862     0.200
    18.001    41.029     0.200
    18.100    40.303     0.200
    18.184    40.425     0.200
    18.192    39.680     0.200
    18.200    40.811     0.200
    18.202    40.796     0.200
    18.220    39.916     0.200
    18.274    40.940     0.200
    18.277    41.402     0.200
    18.480    41.355     0.200
    18.922    41.728     0.200
    19.073    41.651     0.200
    20.948    41.938     0.200
     0.883     4.863     0.200
     0.883     4.437     0.200
     1.120     4.668     0.200
     1.155     6.260     0.200
     1.214     5.571     0.200
     1.217     7.904     0.200
     1.252     7.690     0.200
     1.253     7.723     0.200
     1.302     5.551     0.200
     1.270     8.007     0.200
     1.353     6.328     0.200
     1.370     6.757     0.200
     1.441     7.004     0.200
     1.570     7.818     0.200
     1.592     7.016     0.200
     1.616     7.109     0.200
     1.774     7.338     0.200
     1.863     7.544     0.200
     2.002     8.039     0.200
     2.207     8.328     0.200
     2.308     8.938     0.200
     2.489     9.085     0.200
     2.578     9.395     0.200
     2.780    10.235     0.200
    10.496    29.083     0.200
     0.588     5.038     0.200
     0.854     4.438     0.200
     0.955     4.728     0.200
     1.209     7.870     0.200
     1.274     7.953     0.200
     1.435     6.685     0.200
     1.465     6.390     0.200
     1.694     6.952     0.200
     1.660     7.850     0.200
     1.710     7.098     0.200
     1.710     6.947     0.200
     1.892     7.235     0.200
     1.967     7.791     0.200
     2.144     7.959     0.200
     2.144     7.787     0.200
     2.112     8.320     0.200
     2.318     8.879     0.200
     2.328     8.740     0.200
     2.463     9.344     0.200
     2.612     9.772     0.200
     2.602     9.260     0.200
     3.062    12.555     0.200
     3.733    12.004     0.200
     3.846    11.424     0.200
     4.306    14.599     0.200
     4.343    13.333     0.200
     4.489    13.801     0.200
     4.668    15.927     0.200
     4.808    16.946     0.200
     5.497    17.314     0.200
     5.584    18.326     0.200
     5.794    18.420     0.200
     6.074    19.573     0.200
     6.148    18.794     0.200
     6.386    18.229     0.200
     6.791    24.051     0.200
     7.270    21.153     0.200
     7.525    23.481     0.200
     7.580    21.190     0.200
     7.891    22.612     0.200
     7.891    21.964     0.200
     7.931    24.610     0.200
     8.105    24.699     0.200
     8.461    22.859     0.200
     8.537    23.773     0.200
     8.537    23.882     0.200
     8.902    25.871     0.200
     9.727    29.078     0.200
    10.422    29.052     0.200
    10.677    30.710     0.200
    10.925    31.502     0.200
    11.202    33.603     0.200
    11.503    30.866     0.200
    11.918    35.180     0.200
     0.903     4.607     0.200
     0.903     4.506     0.200
     1.209     7.871     0.200
     1.225     7.612     0.200
     1.225     7.629     0.200
     1.265     7.922     0.200
     1.381     6.225     0.200
     1.444     6.720     0.200
     1.587     7.985     0.200
     1.619     6.958     0.200
     1.638     6.810     0.200
     1.802     7.225     0.200
     1.890     7.607     0.200
     2.026     8.371     0.200
     2.196     8.127     0.200
     2.196     7.900     0.200
     2.315     8.996     0.200
     2.518     9.572     0.200
     2.568     9.733     0.200
     2.590     9.607     0.200
     2.798    10.803     0.200
     2.976    13.806     0.200
     3.025    10.204     0.200
     3.249    12.174     0.200
     3.885    12.119     0.200
     4.252    13.549     0.200
     4.398    13.768     0.200
     4.640    15.633     0.200
     5.489    17.946     0.200
     5.519    17.665     0.200
     5.727    17.691     0.200
     6.066    18.679     0.200
     6.422    18.796     0.200
     6.731    22.006     0.200
     7.286    21.085     0.200
     7.500    23.221     0.200
     7.880    22.180     0.200
     7.900    23.932     0.200
    10.482    28.969     0.200
    11.444    34.397     0.200
     0.876     4.697     0.200
     0.931     4.755     0.200
     0.931     4.856     0.200
     0.931     5.083     0.200
     0.970     5.148     0.200
     1.246     5.309     0.200
     1.255     7.947     0.200
     1.286     7.619     0.200
     1.352     5.854     0.200
     1.322     8.116     0.200
     1.388     6.730     0.200
     1.447     6.996     0.200
     1.466     6.698     0.200
     1.507     6.597     0.200
     1.565     6.349     0.200
     1.628     7.896     0.200
     1.672     7.100     0.200
     1.655     7.920     0.200
     1.703     8.357     0.200
     1.703     8.427     0.200
     1.719     7.530     0.200
     1.735     7.357     0.200
     1.735     7.005     0.200
     1.768     7.818     0.200
     1.775     8.072     0.200
     1.788     7.966     0.200
     1.846     7.999     0.200
     1.904     7.681     0.200
     1.961     7.871     0.200
     1.961     8.050     0.200
     2.017     8.011     0.200
     2.058     8.386     0.200
     2.065     8.561     0.200
     2.095     7.955     0.200
     2.103     8.679     0.200
     2.147     9.001     0.200
     2.273     8.572     0.200
     2.304     8.972     0.200
     2.439     9.560     0.200
     2.487     9.844     0.200
     2.573     9.668     0.200
     2.605     9.585     0.200
     2.623     9.637     0.200
     2.777     9.813     0.200
     2.862    10.265     0.200
     2.879    11.202     0.200
     2.863    11.256     0.200
     2.881    10.199     0.200
     2.915    10.956     0.200
     3.117    10.588     0.200
     3.126    12.332     0.200
     3.145    14.809     0.200
     3.280    11.122     0.200
     3.356    11.583     0.200
     3.519    11.762     0.200
     3.769    13.494     0.200
     3.790    12.640     0.200
     3.796    11.100     0.200
     3.893    13.542     0.200
     4.086    14.100     0.200
     4.172    14.448     0.200
     4.273    14.160     0.200
     4.302    14.557     0.200
     4.370    14.162     0.200
     4.370    13.943     0.200
     4.507    14.552     0.200
     4.631    15.990     0.200
     4.631    16.638     0.200
     4.813    14.962     0.200
     4.813    16.446     0.200
     4.887    16.760     0.200
     5.022    17.797     0.200
     5.065    16.965     0.200
     5.159    15.870     0.200
     5.215    17.019     0.200
     5.376    17.950     0.200
     5.369    18.669     0.200
     5.454    17.807     0.200
     5.454    18.042     0.200
     5.567    18.076     0.200
     5.778    18.260     0.200
     6.083    18.872     0.200
     6.147    18.355     0.200
     6.336    18.065     0.200
     6.497    19.194     0.200
     6.770    20.467     0.200
     6.814    21.465     0.200
     7.149    21.089     0.200
     7.159    21.240     0.200
     7.180    19.423     0.200
     7.222    20.982     0.200
     7.244    21.224     0.200
     7.486    22.472     0.200
     7.486    23.151     0.200
     7.498    21.815     0.200
     7.531    22.022     0.200
     7.741    25.467     0.200
     7.844    23.194     0.200
     7.844    22.913     0.200
     7.905    25.137     0.200
     7.994    24.577     0.200
     8.038    25.679     0.200
     8.162    24.020     0.200
     8.226    24.193     0.200
     8.338    25.872     0.200
     8.371    25.428     0.200
     8.412    22.719     0.200
     8.534    25.168     0.200
     8.534    24.004     0.200
     8.815    27.102     0.200
     8.862    25.668     0.200
     8.897    24.839     0.200
     8.940    26.642     0.200
     9.169    27.847     0.200
     9.236    24.655     0.200
     9.428    24.848     0.200
     9.691    28.815     0.200
     9.735    27.696     0.200
     9.743    25.945     0.200
     9.772    28.051     0.200
     9.849    28.189     0.200
    10.205    29.661     0.200
    10.374    28.985     0.200
    10.374    28.992     0.200
    10.425    25.810     0.200
    10.491    32.589     0.200
    10.628    31.096     0.200
    10.888    31.849     0.200
    11.056    30.037     0.200
    11.211    28.776     0.200
    11.224    33.595     0.200
    11.224    32.806     0.200
    11.369    32.040     0.200
    11.481    33.882     0.200
    11.481    30.881     0.200
    11.481    30.881     0.200
    11.647    30.146     0.200
    11.680    31.400     0.200
    11.778    32.489     0.200
    11.902    33.419     0.200
    11.975    31.221     0.200
    12.053    30.493     0.200
    12.398    34.015     0.200
    12.722    33.519     0.200
    12.900    35.266     0.200
    13.208    35.165     0.200
    13.328    36.905     0.200
    13.389    37.260     0.200
    13.591    37.125     0.200
    13.726    36.939     0.200
    13.782    34.901     0.200
    13.852    35.717     0.200
    13.875    34.613     0.200
    14.472    38.927     0.200
    14.651    37.627     0.200
    14.759    36.945     0.200
    14.774    38.952     0.200
    14.782    38.899     0.200
    14.792    36.972     0.200
    14.806    37.622     0.200
    15.090    37.995     0.200
    15.106    38.661     0.200
    15.157    36.984     0.200
    15.381    37.683     0.200
    15.834    39.094     0.200
    16.053    38.627     0.200
    16.114    39.475     0.200
    16.438    39.461     0.200
    16.556    37.930     0.200
    16.798    38.330     0.200
    16.878    38.715     0.200
    17.562    37.541     0.200
    18.263    39.155     0.200
     0.884     4.929     0.200
     1.037     5.393     0.200
     1.125     5.806     0.200
     1.125     5.669     0.200
     1.319     7.112     0.200
     1.363     6.382     0.200
     1.512     6.751     0.200
     1.533     6.928     0.200
     1.591     7.129     0.200
     1.617     8.878     0.200
     1.618     9.546     0.200
     1.618     8.155     0.200
     1.686     7.426     0.200
     1.879     8.490     0.200
     2.135     8.664     0.200
     2.133     8.385     0.200
     2.228     8.618     0.200
     2.243     8.916     0.200
     2.319     9.252     0.200
     2.352     8.541     0.200
     2.369     9.082     0.200
     2.374     8.640     0.200
     2.448     9.086     0.200
     2.471     9.193     0.200
     2.484    10.432     0.200
     2.533    12.106     0.200
     2.592     8.978     0.200
     2.643     9.785     0.200
     2.784     9.976     0.200
     2.785    10.044     0.200
     2.785     9.802     0.200
     2.900    10.796     0.200
     2.901    10.428     0.200
     3.155    11.374     0.200
     3.510    11.412     0.200
     3.553    12.089     0.200
     3.689    12.149     0.200
     3.755    12.263     0.200
     3.755    12.579     0.200
     3.880    13.310     0.200
     3.924    12.782     0.200
     4.017    13.235     0.200
     4.220    12.414     0.200
     4.209    13.322     0.200
     4.309    14.316     0.200
     4.410    14.131     0.200
     4.534    14.772     0.200
     4.631    15.690     0.200
     4.631    15.960     0.200
     4.735    15.983     0.200
     5.200    16.381     0.200
     5.271    17.400     0.200
     5.469    17.340     0.200
     5.545    17.622     0.200
     5.584    18.013     0.200
     5.649    16.326     0.200
     5.690    17.222     0.200
     5.690    17.327     0.200
     6.092    18.608     0.200
     6.129    18.558     0.200
     6.227    17.763     0.200
     6.519    20.928     0.200
     6.565    20.653     0.200
     6.569    19.641     0.200
     6.733    19.407     0.200
     6.733    19.071     0.200
     7.410    21.586     0.200
     7.502    21.505     0.200
     7.501    23.849     0.200
     7.591    23.846     0.200
     7.722    23.683     0.200
     7.856    21.506     0.200
     7.875    21.013     0.200
     7.897    22.018     0.200
     7.897    21.510     0.200
     8.026    24.050     0.200
     8.077    23.012     0.200
     8.077    23.368     0.200
     8.070    24.568     0.200
     8.092    23.083     0.200
     8.546    24.284     0.200
     8.554    24.859     0.200
     8.650    24.796     0.200
     8.850    23.439     0.200
     8.903    26.189     0.200
     9.111    26.466     0.200
     9.143    27.744     0.200
     9.427    27.116     0.200
     9.420    25.869     0.200
     9.446    26.962     0.200
     9.598    27.573     0.200
     9.617    27.634     0.200
     9.617    28.525     0.200
     9.759    27.487     0.200
     9.811    27.808     0.200
     9.814    27.175     0.200
     9.968    28.111     0.200
    10.049    27.486     0.200
    10.086    27.379     0.200
    10.142    27.295     0.200
    10.320    28.405     0.200
    10.341    28.322     0.200
    10.400    28.325     0.200
    10.466    28.994     0.200
    10.532    28.815     0.200
    10.547    28.601     0.200
    10.594    28.960     0.200
    10.622    32.888     0.200
    10.671    28.701     0.200
    10.751    31.297     0.200
    10.853    28.618     0.200
    10.862    29.710     0.200
    10.862    31.488     0.200
    10.892    29.077     0.200
    10.941    30.648     0.200
    10.950    30.069     0.200
    10.950    29.788     0.200
    10.948    30.052     0.200
    10.948    29.395     0.200
    10.962    29.770     0.200
    11.039    30.234     0.200
    11.133    29.107     0.200
    11.149    28.093     0.200
    11.195    29.854     0.200
    11.217    29.330     0.200
    11.228    31.023     0.200
    11.228    29.502     0.200
    11.244    28.359     0.200
    11.254    29.214     0.200
    11.313    29.827     0.200
    11.382    29.876     0.200
    11.382    29.437     0.200
    11.395    29.484     0.200
    11.467    30.245     0.200
    11.511    30.350     0.200
    11.580    30.465     0.200
    11.716    30.992     0.200
    11.744    30.613     0.200
    11.749    30.784     0.200
    11.825    30.977     0.200
    11.825    31.338     0.200
    11.842    31.670     0.200
    11.842    31.923     0.200
    11.859    32.300     0.200
    11.869    32.203     0.200
    11.900    32.587     0.200
    11.929    31.998     0.200
    11.929    32.611     0.200
    11.942    31.323     0.200
    11.968    32.833     0.200
    11.965    33.458     0.200
    11.987    32.215     0.200
    11.991    31.831     0.200
    12.027    31.623     0.200
    12.060    32.575     0.200
    12.174    32.214     0.200
    12.213    33.927     0.200
    12.275    34.042     0.200
    12.308    31.910     0.200
    12.289    31.884     0.200
    12.372    33.408     0.200
    12.371    32.400     0.200
    12.371    30.415     0.200
    12.372    33.750     0.200
    12.371    37.510     0.200
    12.392    34.815     0.200
    12.408    34.556     0.200
    12.424    32.417     0.200
    12.442    31.731     0.200
    12.477    32.283     0.200
    12.458    33.415     0.200
    12.503    33.886     0.200
    12.507    32.524     0.200
    12.524    33.997     0.200
    12.543    31.327     0.200
    12.550    33.439     0.200
    12.573    32.789     0.200
    12.570    34.334     0.200
    12.623    34.996     0.200
    12.688    33.643     0.200
    12.704    33.752     0.200
    12.724    34.063     0.200
    12.769    33.867     0.200
    12.858    33.824     0.200
    12.881    34.136     0.200
    12.915    33.660     0.200
    12.956    33.433     0.200
    12.969    33.837     0.200
    12.973    34.048     0.200
    12.980    32.303     0.200
    13.034    34.081     0.200
    13.038    34.702     0.200
    13.058    34.980     0.200
    13.090    34.143     0.200
    13.089    33.642     0.200
    13.112    34.993     0.200
    13.132    34.288     0.200
    13.231    34.182     0.200
    13.280    34.780     0.200
    13.300    34.911     0.200
    13.293    35.929     0.200
    13.373    35.670     0.200
    13.380    35.694     0.200
    13.416    35.114     0.200
    13.436    34.044     0.200
    13.517    33.137     0.200
    13.587    34.354     0.200
    13.587    33.717     0.200
    13.636    34.181     0.200
    13.654    35.267     0.200
    13.660    33.467     0.200
    13.689    34.216     0.200
    13.703    35.490     0.200
    13.716    35.415     0.200
    13.778    35.569     0.200
    13.780    36.081     0.200
    13.780    34.171     0.200
    13.811    36.332     0.200
    13.850    36.019     0.200
    13.860    35.897     0.200
    13.943    35.524     0.200
    14.045    36.860     0.200
    14.137    36.875     0.200
    14.200    35.969     0.200
    14.197    36.506     0.200
    14.210    36.678     0.200
    14.232    35.870     0.200
    14.274    35.602     0.200
    14.287    36.226     0.200
    14.293    32.802     0.200
    14.291    36.361     0.200
    14.298    36.560     0.200
    14.303    36.530     0.200
    14.320    36.589     0.200
    14.372    35.522     0.200
    14.365    38.897     0.200
    14.394    36.734     0.200
    14.513    36.533     0.200
    14.522    37.542     0.200
    14.568    37.768     0.200
    14.579    37.498     0.200
    14.660    38.303     0.200
    14.670    37.319     0.200
    14.698    35.660     0.200
    14.700    38.174     0.200
    14.754    37.989     0.200
    14.799    37.809     0.200
    14.797    38.205     0.200
    14.891    37.062     0.200
    14.898    36.736     0.200
    14.907    37.021     0.200
    14.907    39.103     0.200
    14.919    36.747     0.200
    14.931    37.218     0.200
    14.994    36.641     0.200
    15.000    37.689     0.200
    15.003    37.626     0.200
    15.023    36.358     0.200
    15.026    36.455     0.200
    15.025    38.114     0.200
    15.066    38.232     0.200
    15.119    38.300     0.200
    15.154    38.689     0.200
    15.154    37.436     0.200
    15.251    37.853     0.200
    15.307    38.510     0.200
    15.410    37.578     0.200
    15.420    37.270     0.200
    15.420    36.825     0.200
    15.471    38.449     0.200
    15.487    38.100     0.200
    15.494    37.552     0.200
    15.494    38.369     0.200
    15.502    38.360     0.200
    15.518    38.509     0.200
    15.550    38.091     0.200
    15.555    39.216     0.200
    15.583    38.980     0.200
    15.624    38.488     0.200
    15.633    39.247     0.200
    15.648    39.293     0.200
    15.696    38.426     0.200
    15.740    38.281     0.200
    15.761    37.381     0.200
    15.762    39.249     0.200
    15.805    39.062     0.200
    15.810    36.944     0.200
    15.879    38.365     0.200
    15.907    38.113     0.200
    15.962    38.398     0.200
    16.019    38.004     0.200
    16.058    39.076     0.200
    16.084    39.320     0.200
    16.098    39.181     0.200
    16.647    39.256     0.200
    16.667    38.243     0.200
    17.251    39.467     0.200
    17.370    39.468     0.200
    17.397    39.607     0.200
    18.531    41.204     0.200
    18.577    40.961     0.200
    18.585    39.993     0.200
    18.636    41.325     0.200
    18.636    41.927     0.200
    18.923    41.828     0.200
    19.403    41.378     0.200
    19.500    40.561     0.200
    19.589    40.552     0.200
    20.445    40.697     0.200
    20.886    39.181     0.200
     1.116     7.541     0.200
     1.195     6.778     0.200
     1.250     7.588     0.200
     1.360     6.133     0.200
     1.405     6.700     0.200
     1.609     7.500     0.200
     1.603     6.823     0.200
     1.619     6.918     0.200
     1.619     6.664     0.200
     1.790     7.603     0.200
     1.864     7.515     0.200
     2.036     8.171     0.200
     2.166     8.099     0.200
     2.238     8.591     0.200
     2.274     8.707     0.200
     2.498     9.034     0.200
     2.550     9.920     0.200
     2.663     9.739     0.200
     2.748    10.296     0.200
     2.782    11.347     0.200
     2.985    12.648     0.200
     3.036    13.233     0.200
     3.658    12.365     0.200
     3.851    11.893     0.200
     4.203    14.161     0.200
     4.254    13.559     0.200
     4.391    15.188     0.200
     4.600    15.744     0.200
     5.448    17.484     0.200
     5.487    17.490     0.200
     5.696    18.665     0.200
     6.044    18.904     0.200
     6.387    18.871     0.200
     6.698    20.644     0.200
     7.043    23.639     0.200
     7.064    22.693     0.200
     7.248    21.168     0.200
     7.460    23.586     0.200
     7.747    27.186     0.200
     7.861    23.807     0.200
     7.861    23.267     0.200
     7.844    22.140     0.200
     8.033    24.669     0.200
     8.085    22.691     0.200
     8.434    24.670     0.200
     8.810    24.128     0.200
     9.286    29.567     0.200
     9.685    26.899     0.200
     9.693    29.583     0.200
     9.770    26.447     0.200
    10.455    28.801     0.200
    10.664    28.071     0.200
    10.976    30.315     0.200
    11.410    32.816     0.200
    11.410    35.385     0.200
    12.473    32.406     0.200
    15.151    35.116     0.200
    16.781    37.548     0.200
    18.298    38.985     0.200
    20.965    39.422     0.200
     1.035     5.718     0.200
     1.124     6.016     0.200
     1.124     5.856     0.200
     1.214     8.133     0.200
     1.218     8.058     0.200
     1.220     8.089     0.200
     1.320     7.450     0.200
     1.361     6.763     0.200
     1.510     7.162     0.200
     1.532     7.545     0.200
     1.589     7.372     0.200
     1.619     9.032     0.200
     1.619     9.232     0.200
     1.685     7.819     0.200
     1.877     8.916     0.200
     2.130     8.693     0.200
     2.225     8.873     0.200
     2.242     9.242     0.200
     2.369    10.977     0.200
     2.470     9.575     0.200
     2.481    10.920     0.200
     2.480    11.815     0.200
     2.592     9.420     0.200
     2.592     9.299     0.200
     2.782    10.256     0.200
     2.900    10.846     0.200
     3.241    11.229     0.200
     3.687    12.159     0.200
     3.753    12.186     0.200
     3.753    12.815     0.200
     3.878    13.677     0.200
     3.922    13.042     0.200
     4.015    14.485     0.200
     4.307    14.170     0.200
     4.409    13.986     0.200
     4.532    14.573     0.200
     5.269    17.627     0.200
     5.466    17.567     0.200
     5.583    18.755     0.200
     6.127    18.897     0.200
     6.516    23.404     0.200
     6.733    19.697     0.200
     6.733    19.521     0.200
     7.500    23.039     0.200
     7.720    24.666     0.200
     8.024    23.703     0.200
     8.075    23.966     0.200
     8.090    26.997     0.200
    10.892    29.573     0.200
    10.949    31.207     0.200
     0.877     4.514     0.200
     0.936     4.410     0.200
     0.936     4.581     0.200
     0.982     4.706     0.200
     1.100     8.614     0.200
     1.144     5.804     0.200
     1.215     6.606     0.200
     1.250     6.400     0.200
     1.308     5.216     0.200
     1.360     4.373     0.200
     1.402     6.268     0.200
     1.414     5.697     0.200
     1.528     6.439     0.200
     1.549     6.705     0.200
     1.605     6.499     0.200
     1.723     6.880     0.200
     1.699     7.762     0.200
     1.743     8.029     0.200
     1.743     8.365     0.200
     1.775     7.421     0.200
     1.794     7.032     0.200
     1.794     7.142     0.200
     1.845     7.868     0.200
     1.902     7.874     0.200
     1.967     7.506     0.200
     2.021     7.776     0.200
     2.075     7.494     0.200
     2.111     8.281     0.200
     2.119     8.439     0.200
     2.158     8.534     0.200
     2.199     8.476     0.200
     2.293     8.549     0.200
     2.605     9.276     0.200
     2.680     9.144     0.200
     2.667     9.247     0.200
     2.940    11.333     0.200
     2.916    10.412     0.200
     2.955    10.797     0.200
     3.169     9.890     0.200
     3.148    13.324     0.200
     3.196    14.025     0.200
     4.875    16.278     0.200
     5.266    17.219     0.200
     6.255    20.529     0.200
     6.761    21.846     0.200
     6.761    21.846     0.200
     6.862    21.488     0.200
     7.156    21.065     0.200
     7.227    20.656     0.200
     7.502    21.545     0.200
     7.779    27.246     0.200
     7.854    21.487     0.200
     8.033    24.290     0.200
     8.595    25.370     0.200
     8.891    26.813     0.200
     9.727    28.912     0.200
    10.347    26.802     0.200
    10.630    33.075     0.200
    11.284    34.602     0.200
    11.483    35.912     0.200
    11.533    31.133     0.200
    11.533    31.133     0.200
    12.389    37.192     0.200
    13.653    39.008     0.200
     1.026     5.218     0.200
     1.081     5.405     0.200
     1.327     6.492     0.200
     1.345     8.083     0.200
     1.365     7.533     0.200
     1.365     7.967     0.200
     1.411     7.251     0.200
     1.428     8.297     0.200
     1.634     7.180     0.200
     1.764     7.389     0.200
     1.904     8.708     0.200
     1.933     7.441     0.200
     1.944     7.995     0.200
     2.095     8.080     0.200
     2.106     8.209     0.200
     2.231     8.844     0.200
     2.358     9.588     0.200
     2.386     9.162     0.200
     2.572     9.554     0.200
     2.742    10.198     0.200
     2.773     9.987     0.200
     3.024    11.954     0.200
     3.073    11.417     0.200
     3.070    10.714     0.200
     3.116    11.268     0.200
     3.205    10.973     0.200
     3.453    11.384     0.200
     3.656    11.534     0.200
     4.449    15.609     0.200
     4.640    15.778     0.200
     4.984    16.308     0.200
     5.414    17.935     0.200
     5.671    18.556     0.200
     5.886    18.394     0.200
     6.200    17.228     0.200
     6.302    18.965     0.200
     6.857    24.600     0.200
     7.060    21.348     0.200
     7.126    20.319     0.200
     7.360    24.393     0.200
     7.437    22.233     0.200
     7.482    22.400     0.200
     7.764    22.117     0.200
     7.891    22.758     0.200
     7.967    25.153     0.200
     8.085    24.909     0.200
     8.260    22.638     0.200
     8.337    25.848     0.200
     8.429    25.115     0.200
     8.682    25.006     0.200
     8.847    26.452     0.200
     9.014    25.670     0.200
     9.703    29.133     0.200
     9.949    27.588     0.200
    10.195    28.029     0.200
    10.515    32.375     0.200
    10.683    33.523     0.200
    10.894    30.870     0.200
    11.365    34.887     0.200
    11.427    35.588     0.200
    11.509    32.952     0.200
    11.546    33.780     0.200
    11.564    32.271     0.200
    11.781    34.384     0.200
    11.881    33.937     0.200
    12.006    35.126     0.200
    12.075    35.826     0.200
    12.501    35.723     0.200
    12.578    34.161     0.200
    13.073    35.468     0.200
    13.885    38.107     0.200
    13.907    40.171     0.200
    14.915    37.194     0.200
    14.959    38.289     0.200
    15.062    38.920     0.200
    16.465    39.058     0.200
    18.151    38.778     0.200
    18.626    42.831     0.200
     0.911     4.734     0.200
     0.953     5.350     0.200
     1.009     5.138     0.200
     1.065     7.912     0.200
     1.067     5.181     0.200
     1.318     6.356     0.200
     1.349     8.127     0.200
     1.361     7.745     0.200
     1.400     7.251     0.200
     1.432     8.247     0.200
     1.617     6.954     0.200
     1.747     7.399     0.200
     1.934     7.511     0.200
     1.929     7.653     0.200
     1.929     7.809     0.200
     2.089     8.220     0.200
     2.079     8.169     0.200
     2.221     8.836     0.200
     2.756     9.832     0.200
     3.108    11.382     0.200
     3.654    11.626     0.200
     4.627    16.115     0.200
     5.404    17.878     0.200
     5.869    18.946     0.200
     6.199    17.406     0.200
     6.319    19.067     0.200
     6.285    19.272     0.200
     6.841    23.020     0.200
     6.875    21.818     0.200
     7.120    20.261     0.200
     7.758    23.868     0.200
    10.199    28.329     0.200
     0.805     5.890     0.200
     1.356     8.633     0.200
     1.370     8.452     0.200
     1.439     8.873     0.200
     1.926     8.444     0.200
     1.937     7.688     0.200
     5.577    21.819     0.200
     6.011    22.914     0.200
     6.881    23.112     0.200
     7.114    21.783     0.200
     7.351    26.951     0.200
     7.425    21.808     0.200
     7.381    22.269     0.200
     7.751    22.333     0.200
     8.413    24.293     0.200
     8.669    24.030     0.200
     8.887    25.684     0.200
     8.934    30.451     0.200
     9.768    25.584     0.200
     9.874    29.802     0.200
    10.190    28.877     0.200
    10.504    28.389     0.200
    10.673    34.108     0.200
    10.735    34.133     0.200
    10.879    34.048     0.200
    11.216    34.528     0.200
    11.471    34.424     0.200
    11.419    34.608     0.200
    11.419    34.490     0.200
    11.495    34.743     0.200
    11.535    32.280     0.200
    11.549    31.271     0.200
    11.766    35.528     0.200
    11.865    34.601     0.200
    11.991    34.821     0.200
    12.059    34.749     0.200
    12.277    33.436     0.200
    12.257    35.563     0.200
    12.247    37.023     0.200
    12.485    35.801     0.200
    12.562    36.406     0.200
    13.064    36.893     0.200
    13.065    38.066     0.200
    13.162    35.296     0.200
    13.422    37.576     0.200
    13.874    34.122     0.200
    14.776    39.778     0.200
    14.843    39.415     0.200
    14.901    38.636     0.200
    14.950    37.760     0.200
    15.050    39.056     0.200
    15.211    37.588     0.200
    15.452    36.394     0.200
    16.447    38.835     0.200
    18.140    39.741     0.200
    18.342    39.956     0.200
     0.975     4.728     0.200
     1.256     7.698     0.200
     1.256     7.346     0.200
     1.278     7.983     0.200
     1.353     8.309     0.200
     1.823     6.940     0.200
     2.034     7.469     0.200
     2.946    11.364     0.200
     3.231    11.745     0.200
     3.439    13.483     0.200
     3.746    11.037     0.200
     4.369    15.619     0.200
     4.645    15.678     0.200
     5.619    17.589     0.200
     6.217    19.244     0.200
     7.821    23.277     0.200
     8.602    28.159     0.200
    10.306    28.671     0.200
    11.525    34.554     0.200
     1.224     7.977     0.200
     1.282     8.125     0.200
     1.384     6.341     0.200
     1.427     6.902     0.200
     1.605     7.995     0.200
     1.631     7.177     0.200
     1.631     7.065     0.200
     1.809     7.423     0.200
     1.890     7.705     0.200
     2.041     8.471     0.200
     2.177     8.307     0.200
     2.177     8.487     0.200
     2.299     8.811     0.200
     2.521     9.324     0.200
     2.565     9.757     0.200
     2.577     9.728     0.200
     2.756    10.079     0.200
     2.789     9.887     0.200
     3.040    12.815     0.200
     3.663    14.331     0.200
     4.228    14.500     0.200
     4.265    14.942     0.200
     4.407    14.586     0.200
     4.628    16.362     0.200
     5.474    18.209     0.200
     5.724    18.397     0.200
     6.068    19.145     0.200
     6.404    18.930     0.200
     7.883    23.857     0.200
    10.464    30.346     0.200
    11.121    35.135     0.200
    11.438    36.547     0.200
     0.731     3.998     0.200
     1.305     7.254     0.200
     1.317     7.861     0.200
     1.394     8.087     0.200
     1.865     7.056     0.200
     1.986     6.960     0.200
     3.230    13.287     0.200
     4.387    14.400     0.200
     4.626    15.107     0.200
     5.419    16.941     0.200
     5.837    18.160     0.200
     6.193    18.800     0.200
     6.243    17.570     0.200
     6.816    19.715     0.200
     7.084    20.268     0.200
     7.309    21.532     0.200
     7.474    22.140     0.200
     7.934    22.675     0.200
     8.001    24.857     0.200
     8.069    22.929     0.200
     8.309    21.589     0.200
    10.256    28.776     0.200
     0.936     4.949     0.200
     0.936     5.086     0.200
     1.034     5.360     0.200
     1.070     5.458     0.200
     1.191     7.750     0.200
     1.197     7.688     0.200
     1.211     7.956     0.200
     1.331     6.301     0.200
     1.373     6.058     0.200
     1.464     6.825     0.200
     1.543     6.962     0.200
     1.593     7.143     0.200
     1.653     8.599     0.200
     1.824     8.447     0.200
     2.113     8.349     0.200
     2.190     8.577     0.200
     2.296    10.377     0.200
     2.413    11.240     0.200
     2.464    11.115     0.200
     2.476    10.247     0.200
     2.665     9.038     0.200
     2.665     8.917     0.200
     2.742    10.307     0.200
     3.086    12.075     0.200
     3.487    12.126     0.200
     3.641    12.326     0.200
     3.695    13.687     0.200
     3.866    13.345     0.200
     3.876    13.638     0.200
     4.290    13.108     0.200
     4.670    15.824     0.200
     5.470    17.291     0.200
     5.507    18.039     0.200
     5.635    18.149     0.200
     5.668    18.158     0.200
     6.160    20.242     0.200
     6.511    20.227     0.200
     6.527    20.597     0.200
     6.802    19.237     0.200
     7.470    22.273     0.200
     7.540    23.645     0.200
     7.564    21.876     0.200
     7.602    24.539     0.200
     7.739    23.274     0.200
     7.946    25.072     0.200
     8.058    24.459     0.200
     8.134    22.909     0.200
     8.920    23.718     0.200
    11.013    32.780     0.200
     0.562     3.751     0.200
     0.873     4.579     0.200
     0.873     4.372     0.200
     1.170     5.595     0.200
     1.197     7.807     0.200
     1.320     6.089     0.200
     1.311     7.156     0.200
     1.447     7.912     0.200
     1.590     6.967     0.200
     1.709     7.254     0.200
     1.723     7.473     0.200
     2.074     8.936     0.200
     2.288     8.464     0.200
     2.413     8.906     0.200
     2.420     9.478     0.200
     2.442     8.368     0.200
     2.442     8.532     0.200
     2.672     9.914     0.200
     2.722     9.822     0.200
     2.977    10.647     0.200
     2.971    10.474     0.200
     3.345    11.894     0.200
     3.951    12.846     0.200
     4.023    13.571     0.200
     4.096    11.944     0.200
     4.113    13.248     0.200
     4.643    16.710     0.200
     5.377    17.483     0.200
     5.557    18.439     0.200
     5.579    17.760     0.200
     5.723    17.823     0.200
     6.316    18.918     0.200
     6.621    18.691     0.200
     7.342    21.413     0.200
     7.429    21.566     0.200
     7.513    23.747     0.200
     8.019    23.465     0.200
     8.019    22.992     0.200
     8.725    22.673     0.200
    10.740    28.837     0.200
    10.864    31.836     0.200
    11.324    34.270     0.200
     1.046     5.564     0.200
     1.115     5.680     0.200
     1.363     6.466     0.200
     1.516     7.110     0.200
     1.530     7.060     0.200
     1.601     7.320     0.200
     1.619     9.181     0.200
     1.620    10.130     0.200
     1.620     8.817     0.200
     1.710     7.707     0.200
     1.869     8.637     0.200
     2.136     8.579     0.200
     2.225     8.820     0.200
     2.228     9.077     0.200
     2.331     9.453     0.200
     2.345    10.722     0.200
     2.441     9.518     0.200
     2.495     9.350     0.200
     2.614     9.229     0.200
     2.665    10.050     0.200
     2.781    10.160     0.200
     2.785    10.104     0.200
     2.888    10.565     0.200
     2.915    10.894     0.200
     3.538    12.280     0.200
     3.683    12.199     0.200
     3.743    12.250     0.200
     3.885    13.305     0.200
     3.917    13.008     0.200
     4.039    14.007     0.200
     4.243    12.850     0.200
     4.310    14.343     0.200
     4.530    14.917     0.200
     4.651    15.907     0.200
     4.751    16.437     0.200
     5.223    16.701     0.200
     5.282    17.527     0.200
     5.542    18.292     0.200
     5.607    18.552     0.200
     5.672    16.751     0.200
     6.124    18.730     0.200
     6.531    20.662     0.200
     6.558    20.060     0.200
     6.757    19.501     0.200
     7.521    22.816     0.200
     8.044    24.084     0.200
     8.096    23.369     0.200
     8.100    22.546     0.200
     8.873    24.004     0.200
    10.914    29.429     0.200
    11.240    32.402     0.200
     0.910     5.075     0.200
     0.910     4.966     0.200
     1.047     5.555     0.200
     1.059     5.549     0.200
     1.114     5.694     0.200
     1.197     7.726     0.200
     1.199     7.867     0.200
     1.363     6.507     0.200
     1.513     7.057     0.200
     1.533     6.957     0.200
     1.603     7.234     0.200
     1.619     8.727     0.200
     1.620    10.055     0.200
     1.620     8.715     0.200
     1.714     7.571     0.200
     1.868     8.592     0.200
     2.137     8.537     0.200
     2.155     8.804     0.200
     2.225     8.712     0.200
     2.226     8.961     0.200
     2.333     9.237     0.200
     2.341    10.555     0.200
     2.440     9.554     0.200
     2.499     9.351     0.200
     2.618     9.132     0.200
     2.669     9.980     0.200
     2.780    10.183     0.200
     2.786    10.137     0.200
     2.886    10.562     0.200
     3.102    10.614     0.200
     3.232    11.252     0.200
     3.536    12.172     0.200
     3.682    12.214     0.200
     3.741    12.264     0.200
     4.043    13.846     0.200
     4.194    13.495     0.200
     4.248    12.434     0.200
     4.310    14.488     0.200
     4.529    14.888     0.200
     4.654    15.832     0.200
     4.754    16.331     0.200
     5.227    16.699     0.200
     5.611    18.360     0.200
     5.694    17.684     0.200
     5.676    16.607     0.200
     6.123    18.684     0.200
     6.761    19.541     0.200
     8.096    23.303     0.200
     8.104    23.817     0.200
     8.877    23.884     0.200
     8.927    25.958     0.200
     9.637    27.386     0.200
     9.835    27.940     0.200
     9.839    27.411     0.200
    10.488    30.975     0.200
    10.568    30.988     0.200
    10.885    31.778     0.200
    10.918    29.160     0.200
    10.962    32.135     0.200
    10.978    32.453     0.200
    11.242    30.453     0.200
    11.223    30.335     0.200
    15.635    38.808     0.200
     1.121     7.595     0.200
     1.131     7.374     0.200
     1.254     8.053     0.200
     1.619     6.820     0.200
     2.162     8.400     0.200
     2.779    11.277     0.200
     2.987    13.419     0.200
     3.038    12.521     0.200
     3.239    13.257     0.200
     4.200    14.655     0.200
     4.254    14.053     0.200
     4.390    14.766     0.200
     4.595    15.605     0.200
     5.443    18.006     0.200
     5.483    17.356     0.200
     5.692    18.253     0.200
     6.041    18.208     0.200
     6.383    17.656     0.200
     6.694    20.673     0.200
     7.855    23.668     0.200
     8.431    27.151     0.200
    10.451    29.719     0.200
    11.406    35.833     0.200
     1.037     5.580     0.200
     1.080     5.817     0.200
     1.208     7.972     0.200
     1.339     6.622     0.200
     1.362     5.041     0.200
     1.475     7.258     0.200
     1.541     7.137     0.200
     1.595     7.370     0.200
     1.645     9.077     0.200
     1.645     8.968     0.200
     1.646    10.155     0.200
     1.646     9.124     0.200
     1.744     7.911     0.200
     2.118     8.742     0.200
     2.160     9.029     0.200
     2.189     9.204     0.200
     2.199     8.905     0.200
     2.290     9.801     0.200
     2.313    10.579     0.200
     2.307    10.715     0.200
     2.408     9.659     0.200
     2.425    11.866     0.200
     2.480    10.870     0.200
     2.476    10.708     0.200
     2.523     9.645     0.200
     2.654     9.432     0.200
     2.654     9.307     0.200
     2.687    10.191     0.200
     2.751    10.308     0.200
     2.764    10.364     0.200
     2.850    10.697     0.200
     2.918    11.105     0.200
     3.064    11.722     0.200
     3.098    11.980     0.200
     3.199    11.394     0.200
     3.247    11.492     0.200
     3.499    11.921     0.200
     3.651    12.357     0.200
     3.706    12.383     0.200
     3.871    13.419     0.200
     3.885    13.037     0.200
     3.887    13.132     0.200
     4.062    13.780     0.200
     4.158    13.464     0.200
     4.287    14.670     0.200
     4.280    12.910     0.200
     4.501    15.031     0.200
     4.666    15.819     0.200
     4.666    15.186     0.200
     4.756    16.236     0.200
     5.249    16.889     0.200
     5.277    17.533     0.200
     5.516    17.411     0.200
     5.629    18.267     0.200
     5.629    18.817     0.200
     5.674    18.103     0.200
     5.674    17.966     0.200
     5.711    17.033     0.200
     6.094    19.040     0.200
     6.171    17.417     0.200
     6.522    19.842     0.200
     6.524    18.056     0.200
     6.529    18.979     0.200
     6.792    19.761     0.200
     6.792    19.601     0.200
     7.345    19.917     0.200
     7.462    21.975     0.200
     7.537    24.322     0.200
     7.537    23.197     0.200
     7.556    21.932     0.200
     7.603    20.219     0.200
     7.586    22.486     0.200
     7.739    23.923     0.200
     7.859    22.536     0.200
     7.880    21.028     0.200
     7.898    22.432     0.200
     8.056    24.197     0.200
     8.078    23.795     0.200
     8.078    22.787     0.200
     8.127    23.344     0.200
     8.127    22.317     0.200
     8.667    23.597     0.200
     8.910    24.473     0.200
     8.910    24.020     0.200
     8.940    25.821     0.200
     9.148    25.602     0.200
     9.485    27.220     0.200
     9.551    29.960     0.200
     9.639    28.089     0.200
     9.639    26.511     0.200
     9.848    28.298     0.200
     9.853    27.330     0.200
    10.078    28.943     0.200
    10.161    29.528     0.200
    10.229    29.983     0.200
    10.358    29.010     0.200
    10.385    30.342     0.200
    10.498    31.034     0.200
    10.574    30.496     0.200
    10.706    30.688     0.200
    10.893    31.483     0.200
    10.936    32.490     0.200
    10.969    29.436     0.200
    10.954    29.378     0.200
    11.006    31.761     0.200
    11.005    30.744     0.200
    11.005    30.252     0.200
    11.064    31.006     0.200
    11.208    31.196     0.200
    11.236    31.109     0.200
    11.260    31.355     0.200
    11.254    30.818     0.200
    11.983    30.843     0.200
    12.390    30.867     0.200
    12.440    32.408     0.200
    13.395    39.165     0.200
    13.841    36.475     0.200
    14.367    37.200     0.200
    14.347    36.422     0.200
    14.668    38.116     0.200
    14.690    35.313     0.200
    14.792    36.223     0.200
    14.892    36.338     0.200
    15.110    37.006     0.200
    15.190    36.745     0.200
    15.244    35.347     0.200
    15.537    38.257     0.200
    15.553    38.095     0.200
    15.613    39.665     0.200
    15.613    39.822     0.200
    16.874    38.336     0.200
    17.304    38.722     0.200
    18.059    39.789     0.200
    18.631    41.454     0.200
    18.669    41.733     0.200
     1.062     7.660     0.200
     1.174     8.400     0.200
     1.223     8.399     0.200
     1.269     8.298     0.200
     1.325     8.083     0.200
     1.543     6.861     0.200
     2.270     8.390     0.200
     2.768    11.780     0.200
     2.894    10.316     0.200
     2.942    11.699     0.200
     3.566    14.351     0.200
     3.953    12.531     0.200
     4.174    13.949     0.200
     4.185    14.651     0.200
     4.328    14.243     0.200
     4.657    16.712     0.200
     4.666    16.068     0.200
     5.496    18.281     0.200
     5.523    18.485     0.200
     6.488    18.894     0.200
     6.715    19.052     0.200
     7.520    24.066     0.200
     7.647    22.414     0.200
     7.873    24.211     0.200
     7.947    23.949     0.200
     7.947    23.814     0.200
     7.998    24.508     0.200
     8.576    23.887     0.200
    10.560    30.030     0.200
     0.805     4.594     0.200
     0.809     4.315     0.200
     0.896     4.360     0.200
     1.400     6.469     0.200
     1.407     6.149     0.200
     1.635     6.673     0.200
     1.647     7.936     0.200
     1.669     6.640     0.200
     1.669     6.987     0.200
     1.840     7.250     0.200
     1.907     7.521     0.200
     2.083     8.244     0.200
     2.137     7.873     0.200
     2.269     8.641     0.200
     2.277     8.681     0.200
     2.421     9.510     0.200
     2.546     9.087     0.200
     2.563     9.354     0.200
     2.713     9.464     0.200
     2.797    10.211     0.200
     2.826    11.010     0.200
     2.830    10.279     0.200
     2.859    10.523     0.200
     3.032    12.532     0.200
     3.079    10.490     0.200
     3.219    10.668     0.200
     3.290    11.917     0.200
     3.453    11.744     0.200
     3.705    13.623     0.200
     3.830    11.419     0.200
     3.891    13.155     0.200
     4.107    13.619     0.200
     4.208    12.922     0.200
     4.247    13.603     0.200
     4.303    13.999     0.200
     4.441    13.486     0.200
     4.617    15.361     0.200
     4.617    15.806     0.200
     4.752    15.462     0.200
     4.857    16.308     0.200
     4.959    16.347     0.200
     5.024    15.754     0.200
     5.202    15.565     0.200
     5.305    19.879     0.200
     5.454    17.431     0.200
     6.020    20.765     0.200
     6.090    18.509     0.200
     6.090    18.111     0.200
     6.368    18.102     0.200
     6.368    18.442     0.200
     6.732    21.878     0.200
     6.750    20.641     0.200
     7.093    21.799     0.200
     7.114    22.796     0.200
     7.165    21.046     0.200
     7.240    20.912     0.200
     7.263    21.042     0.200
     7.475    23.048     0.200
     7.475    22.614     0.200
     7.549    21.624     0.200
     7.779    25.264     0.200
     7.857    21.606     0.200
     7.857    22.430     0.200
     7.857    22.289     0.200
     7.873    23.439     0.200
     8.121    25.380     0.200
     8.180    27.054     0.200
     8.299    22.785     0.200
     8.449    22.167     0.200
     8.449    22.542     0.200
     8.479    24.422     0.200
     8.479    24.274     0.200
     8.854    25.519     0.200
     8.850    26.445     0.200
     8.894    26.401     0.200
     9.235    28.909     0.200
     9.386    27.570     0.200
     9.718    26.775     0.200
     9.731    27.428     0.200
     9.731    26.608     0.200
     9.757    26.771     0.200
     9.806    29.878     0.200
    10.208    30.265     0.200
    10.423    28.534     0.200
    10.505    32.631     0.200
    10.597    30.487     0.200
    10.636    29.740     0.200
    10.652    29.395     0.200
    10.652    30.395     0.200
    10.776    31.363     0.200
    10.817    31.372     0.200
    10.873    31.228     0.200
    10.873    31.009     0.200
    11.013    32.181     0.200
    11.154    34.605     0.200
    11.158    33.474     0.200
    11.158    34.208     0.200
    11.316    35.251     0.200
    11.356    35.962     0.200
    11.442    32.660     0.200
    11.443    31.686     0.200
    11.637    33.245     0.200
    11.735    33.804     0.200
    11.755    34.043     0.200
    11.858    34.165     0.200
    11.932    32.995     0.200
    11.990    35.089     0.200
    12.027    32.830     0.200
    12.318    34.084     0.200
    12.354    35.124     0.200
    12.500    33.564     0.200
    12.704    37.080     0.200
    12.920    36.426     0.200
    13.238    36.676     0.200
    13.262    38.141     0.200
    13.327    38.458     0.200
    13.367    36.220     0.200
    13.526    39.016     0.200
    13.732    36.400     0.200
    14.014    35.576     0.200
    14.494    37.396     0.200
    14.730    37.244     0.200
    14.780    37.032     0.200
    15.038    39.327     0.200
    15.131    37.994     0.200
    15.260    37.790     0.200
    15.589    38.897     0.200
    16.573    38.958     0.200
    16.837    39.931     0.200
    18.622    41.262     0.200
    20.961    40.998     0.200
     1.037     7.305     0.200
     1.037     7.507     0.200
     1.041     5.369     0.200
     1.152     7.899     0.200
     1.511     8.083     0.200
     1.913     7.374     0.200
     1.970     8.089     0.200
     3.335    12.836     0.200
     3.575    13.821     0.200
     3.638    10.837     0.200
     4.468    15.608     0.200
     4.642    16.063     0.200
     4.730    15.020     0.200
     5.409    17.853     0.200
     6.183    17.515     0.200
     6.322    19.633     0.200
     6.887    22.197     0.200
     7.426    21.274     0.200
     7.482    22.899     0.200
     7.754    23.132     0.200
     7.754    22.800     0.200
    10.172    28.752     0.200
     0.955     5.404     0.200
     1.030     5.736     0.200
     1.228     7.936     0.200
     1.413     7.579     0.200
     1.687     9.625     0.200
     1.688     9.991     0.200
     2.370    12.981     0.200
     2.706    10.547     0.200
     2.704     9.276     0.200
     3.043    13.945     0.200
     3.843    13.800     0.200
     4.325    13.579     0.200
     4.678    16.007     0.200
     5.651    18.629     0.200
     6.048    18.070     0.200
     6.517    23.700     0.200
     6.537    24.619     0.200
     6.834    19.771     0.200
     7.494    21.864     0.200
     7.548    24.450     0.200
     7.733    24.234     0.200
     7.892    22.963     0.200
     8.062    25.295     0.200
     8.156    23.858     0.200
     8.955    24.659     0.200
    11.003    30.138     0.200
    11.041    31.003     0.200
    11.223    34.566     0.200
     0.949     5.295     0.200
     1.035     5.531     0.200
     1.058     5.562     0.200
     1.058     5.698     0.200
     1.184     7.704     0.200
     1.192     7.700     0.200
     1.211     7.915     0.200
     1.325     6.458     0.200
     1.448     7.418     0.200
     1.552     7.126     0.200
     1.661     9.029     0.200
     1.661     9.228     0.200
     1.662     9.136     0.200
     1.811     8.621     0.200
     2.109     8.616     0.200
     2.169     9.034     0.200
     2.279    10.716     0.200
     2.683     9.406     0.200
     2.733    10.445     0.200
     3.070    12.821     0.200
     3.631    12.174     0.200
     3.681    12.525     0.200
     3.863    13.240     0.200
     3.865    13.009     0.200
     4.274    14.295     0.200
     4.308    13.263     0.200
     4.680    15.792     0.200
     4.680    15.968     0.200
     5.648    18.546     0.200
     6.497    19.491     0.200
     6.551    23.648     0.200
     6.819    19.796     0.200
     7.485    22.175     0.200
     7.550    23.842     0.200
     7.550    24.032     0.200
     7.609    22.223     0.200
     8.149    23.737     0.200
     8.937    23.944     0.200
     8.937    24.215     0.200
     9.869    27.521     0.200
     9.869    27.771     0.200
    11.029    30.912     0.200
     1.034     5.592     0.200
     1.103     5.663     0.200
     1.103     5.843     0.200
     1.208     7.982     0.200
     1.209     7.929     0.200
     1.211     8.074     0.200
     1.350     6.588     0.200
     1.340     5.359     0.200
     1.523     7.025     0.200
     1.506     7.427     0.200
     1.591     7.414     0.200
     1.631     8.870     0.200
     1.632     8.890     0.200
     1.632    10.015     0.200
     1.857     8.780     0.200
     2.124     8.830     0.200
     2.144     8.961     0.200
     2.212     8.892     0.200
     2.218     9.712     0.200
     2.341    10.922     0.200
     2.455    12.104     0.200
     2.480    10.918     0.200
     2.506    13.010     0.200
     2.620     9.293     0.200
     2.620     9.402     0.200
     2.768    10.228     0.200
     2.773    10.405     0.200
     2.877    10.746     0.200
     3.128    11.349     0.200
     3.670    12.441     0.200
     3.731    12.501     0.200
     3.905    13.012     0.200
     4.247    13.363     0.200
     4.297    15.446     0.200
     4.297    15.211     0.200
     4.645    16.302     0.200
     4.645    15.193     0.200
     4.727    17.080     0.200
     4.987    17.126     0.200
     5.530    17.619     0.200
     5.603    18.674     0.200
     5.603    18.049     0.200
     5.681    17.532     0.200
     5.681    18.274     0.200
     6.111    20.298     0.200
     6.111    19.704     0.200
     6.201    22.465     0.200
     6.521    20.993     0.200
     6.541    21.544     0.200
     6.545    24.215     0.200
     6.546    19.224     0.200
     6.759    19.212     0.200
     6.759    19.540     0.200
     7.432    22.334     0.200
     7.516    22.981     0.200
     7.516    24.426     0.200
     7.526    21.888     0.200
     7.555    22.620     0.200
     7.594    24.062     0.200
     7.688    26.667     0.200
     7.728    23.817     0.200
     7.807    22.472     0.200
     7.829    22.708     0.200
     7.843    23.632     0.200
     7.927    23.952     0.200
     7.960    25.292     0.200
     8.037    22.992     0.200
     8.072    23.904     0.200
     8.083    23.893     0.200
     8.098    22.971     0.200
     8.098    24.088     0.200
     8.543    26.864     0.200
     8.661    23.903     0.200
     8.877    24.254     0.200
     8.877    23.957     0.200
     8.918    26.713     0.200
     8.918    25.729     0.200
     9.143    28.646     0.200
     9.417    25.505     0.200
     9.584    26.023     0.200
     9.625    25.956     0.200
     9.664    28.429     0.200
     9.671    27.212     0.200
     9.826    28.456     0.200
     9.830    27.879     0.200
     9.830    27.449     0.200
     9.795    30.289     0.200
    10.016    30.642     0.200
    10.061    29.476     0.200
    10.148    29.444     0.200
    10.208    30.299     0.200
    10.401    31.290     0.200
    10.478    31.146     0.200
    10.558    31.019     0.200
    10.600    31.975     0.200
    10.685    31.019     0.200
    10.685    30.894     0.200
    10.740    31.449     0.200
    10.874    31.854     0.200
    10.874    32.299     0.200
    10.941    32.970     0.200
    10.919    29.826     0.200
    10.920    30.044     0.200
    10.974    31.187     0.200
    10.974    31.546     0.200
    11.175    28.737     0.200
    11.230    32.278     0.200
    11.221    29.980     0.200
    11.334    32.339     0.200
    11.372    32.933     0.200
    11.583    35.432     0.200
    11.600    31.243     0.200
    11.671    33.794     0.200
    11.759    32.745     0.200
    11.770    37.918     0.200
    11.776    31.645     0.200
    11.848    35.483     0.200
    11.870    32.021     0.200
    11.952    33.054     0.200
    11.952    33.562     0.200
    12.018    32.260     0.200
    12.083    34.197     0.200
    12.080    33.386     0.200
    12.189    35.082     0.200
    12.233    38.057     0.200
    12.269    36.466     0.200
    12.279    34.175     0.200
    12.333    34.166     0.200
    12.366    36.544     0.200
    12.378    34.435     0.200
    12.378    33.435     0.200
    12.406    36.533     0.200
    12.534    34.810     0.200
    12.568    36.618     0.200
    12.574    34.214     0.200
    12.619    36.543     0.200
    12.600    34.403     0.200
    12.722    33.682     0.200
    12.826    38.619     0.200
    12.926    38.749     0.200
    12.977    34.417     0.200
    12.998    37.583     0.200
    13.058    35.608     0.200
    13.085    36.431     0.200
    13.109    38.742     0.200
    13.258    36.102     0.200
    13.324    34.957     0.200
    13.374    36.472     0.200
    13.384    39.194     0.200
    13.397    39.018     0.200
    13.436    38.121     0.200
    13.443    36.241     0.200
    13.534    35.576     0.200
    13.574    39.803     0.200
    13.613    36.325     0.200
    13.613    36.114     0.200
    13.681    36.395     0.200
    13.686    35.593     0.200
    13.714    35.550     0.200
    13.730    36.833     0.200
    13.740    36.519     0.200
    13.805    37.166     0.200
    13.807    37.109     0.200
    13.883    36.839     0.200
    13.955    39.788     0.200
    13.966    36.850     0.200
    14.014    39.486     0.200
    14.073    37.500     0.200
    14.226    36.292     0.200
    14.315    37.034     0.200
    14.300    36.893     0.200
    14.316    36.142     0.200
    14.312    36.659     0.200
    14.319    37.629     0.200
    14.330    37.124     0.200
    14.371    38.356     0.200
    14.346    37.202     0.200
    14.418    37.722     0.200
    14.537    39.567     0.200
    14.602    37.668     0.200
    14.672    39.556     0.200
    14.677    37.723     0.200
    14.671    37.373     0.200
    14.728    39.440     0.200
    14.809    39.706     0.200
    14.932    37.302     0.200
    14.945    37.304     0.200
    14.958    37.614     0.200
    15.027    38.268     0.200
    15.042    38.857     0.200
    15.027    37.847     0.200
    15.030    38.400     0.200
    15.048    38.192     0.200
    15.063    37.843     0.200
    15.090    38.269     0.200
    15.140    37.664     0.200
    15.177    38.855     0.200
    15.258    39.307     0.200
    15.443    39.033     0.200
    15.443    38.806     0.200
    15.497    38.847     0.200
    15.509    38.203     0.200
    15.509    38.578     0.200
    15.520    38.833     0.200
    15.520    39.090     0.200
    15.622    39.841     0.200
    15.794    38.783     0.200
    15.812    39.361     0.200
    15.905    39.826     0.200
    15.905    39.613     0.200
    16.015    38.353     0.200
    16.028    39.411     0.200
    16.396    39.773     0.200
    16.439    40.002     0.200
    16.435    38.786     0.200
    16.811    40.062     0.200
    16.845    40.032     0.200
    17.089    39.165     0.200
    17.831    39.788     0.200
    18.536    41.676     0.200
    18.580    41.090     0.200
    18.598    41.058     0.200
    18.600    41.146     0.200
    18.649    41.896     0.200
    18.649    41.075     0.200
    18.842    42.213     0.200
    18.931    41.830     0.200
    19.228    41.625     0.200
    19.411    41.246     0.200
    19.506    42.222     0.200
    19.506    41.792     0.200
    19.594    41.320     0.200
    19.598    41.335     0.200
    19.952    40.594     0.200
    19.980    41.325     0.200
    20.064    41.003     0.200
    20.151    43.992     0.200
    20.450    40.336     0.200
    20.629    40.185     0.200
     1.053     5.669     0.200
     1.113     5.755     0.200
     1.113     5.943     0.200
     1.330     6.450     0.200
     1.365     6.714     0.200
     1.509     7.480     0.200
     1.542     7.186     0.200
     1.610     7.488     0.200
     1.616     8.956     0.200
     1.618     9.100     0.200
     1.618     9.850     0.200
     1.867     8.865     0.200
     2.141     8.761     0.200
     2.164     9.071     0.200
     2.223     9.372     0.200
     2.227     8.966     0.200
     2.340     9.403     0.200
     2.334    10.906     0.200
     2.440     9.772     0.200
     2.499    10.615     0.200
     2.509    12.678     0.200
     2.625     9.205     0.200
     2.625     9.369     0.200
     2.781    10.193     0.200
     2.781    10.373     0.200
     2.884    10.823     0.200
     3.274    11.727     0.200
     3.532    12.558     0.200
     3.682    12.390     0.200
     3.739    12.544     0.200
     3.915    13.364     0.200
     3.916    12.608     0.200
     4.191    14.668     0.200
     4.256    12.608     0.200
     4.313    14.566     0.200
     4.663    16.057     0.200
     5.544    17.553     0.200
     5.620    18.456     0.200
     5.698    16.935     0.200
     6.124    19.104     0.200
     6.205    19.683     0.200
     6.540    21.071     0.200
     6.555    18.853     0.200
     6.556    23.723     0.200
     6.561    22.794     0.200
     6.770    19.489     0.200
     6.770    19.794     0.200
     7.447    21.668     0.200
     7.534    23.555     0.200
     7.539    21.945     0.200
     7.614    25.428     0.200
     7.747    24.347     0.200
     7.843    22.412     0.200
     7.858    23.642     0.200
     7.914    26.533     0.200
     7.946    24.338     0.200
     8.056    25.529     0.200
     8.101    24.489     0.200
     8.113    23.288     0.200
     8.562    27.443     0.200
     8.680    26.662     0.200
     8.886    23.938     0.200
     8.886    24.438     0.200
     9.435    27.420     0.200
     9.593    28.843     0.200
     9.645    28.870     0.200
     9.682    26.984     0.200
     9.683    29.091     0.200
     9.786    29.740     0.200
     9.844    28.987     0.200
     9.848    27.782     0.200
     9.848    28.243     0.200
    10.030    32.272     0.200
    10.053    28.789     0.200
    10.085    28.764     0.200
    10.610    32.417     0.200
    10.756    30.215     0.200
    10.893    31.744     0.200
    10.925    29.846     0.200
    10.958    32.578     0.200
    10.987    30.645     0.200
    11.185    29.851     0.200
    11.232    29.617     0.200
    11.249    32.271     0.200
    11.391    34.594     0.200
    11.419    33.374     0.200
    11.445    33.010     0.200
    11.453    33.402     0.200
    11.483    34.036     0.200
    11.510    34.133     0.200
    11.690    34.407     0.200
    11.688    34.436     0.200
    11.778    34.608     0.200
    11.863    33.571     0.200
    11.867    35.895     0.200
    11.877    31.833     0.200
    11.966    31.485     0.200
    12.026    31.788     0.200
    12.052    33.422     0.200
    12.096    34.017     0.200
    12.102    36.171     0.200
    12.207    33.588     0.200
    12.233    36.215     0.200
    12.298    34.284     0.200
    12.296    37.652     0.200
    12.345    33.854     0.200
    12.384    37.308     0.200
    12.397    35.348     0.200
    12.425    36.882     0.200
    12.587    33.777     0.200
    12.608    33.742     0.200
    12.716    37.482     0.200
    12.739    33.951     0.200
    12.944    37.966     0.200
    12.997    36.010     0.200
    13.071    35.724     0.200
    13.094    35.954     0.200
    13.266    34.883     0.200
    13.302    37.051     0.200
    13.415    37.860     0.200
    13.587    39.645     0.200
    13.624    34.999     0.200
    13.690    35.172     0.200
    13.726    33.988     0.200
    13.739    35.665     0.200
    13.813    37.195     0.200
    13.816    34.649     0.200
    13.897    37.247     0.200
    13.960    36.478     0.200
    13.980    36.125     0.200
    14.029    39.473     0.200
    14.311    36.535     0.200
    14.324    36.260     0.200
    14.330    35.069     0.200
    14.389    39.452     0.200
    14.689    39.318     0.200
    14.734    39.675     0.200
    14.944    38.342     0.200
    14.956    38.125     0.200
    14.968    38.482     0.200
    15.036    38.448     0.200
    15.063    38.173     0.200
    15.103    39.574     0.200
    15.391    39.319     0.200
    15.524    37.528     0.200
    15.660    39.790     0.200
    15.829    40.306     0.200
    15.888    39.632     0.200
    15.924    38.081     0.200
    17.280    37.395     0.200
    18.522    41.968     0.200
    18.556    41.136     0.200
    18.599    41.019     0.200
    18.614    41.038     0.200
    18.668    41.467     0.200
    19.247    41.921     0.200
    19.526    42.299     0.200
    20.083    42.080     0.200
    20.470    41.624     0.200
     1.052     5.627     0.200
     1.106     5.772     0.200
     1.187     7.586     0.200
     1.194     8.006     0.200
     1.337     5.994     0.200
     1.361     6.610     0.200
     1.500     7.355     0.200
     1.544     7.089     0.200
     1.609     7.640     0.200
     1.622     9.009     0.200
     1.623     8.877     0.200
     1.623     9.997     0.200
     1.730     7.697     0.200
     2.450    11.819     0.200
     2.514     9.460     0.200
     2.634     9.120     0.200
     2.634     9.337     0.200
     2.775    10.350     0.200
     2.926    10.967     0.200
     3.123    12.225     0.200
     3.910    13.277     0.200
     4.057    14.159     0.200
     4.263    13.301     0.200
     4.308    16.296     0.200
     4.666    16.318     0.200
     4.666    16.065     0.200
     5.242    16.873     0.200
     5.625    18.827     0.200
     5.625    18.354     0.200
     6.118    18.426     0.200
     6.540    20.343     0.200
     6.547    20.261     0.200
     6.549    19.383     0.200
     6.560    19.755     0.200
     6.777    19.696     0.200
     7.453    22.122     0.200
     7.537    23.477     0.200
     7.537    24.039     0.200
     7.546    22.218     0.200
     7.748    23.968     0.200
     7.912    22.628     0.200
     8.059    24.019     0.200
     8.119    23.619     0.200
     8.119    23.068     0.200
     8.893    24.570     0.200
     8.893    24.443     0.200
     8.940    26.847     0.200
     9.686    29.624     0.200
    10.934    29.770     0.200
    10.993    28.664     0.200
    11.248    32.794     0.200
     1.057     5.545     0.200
     1.189     7.811     0.200
     1.197     7.777     0.200
     1.215     8.039     0.200
     1.386     5.825     0.200
     1.664     9.071     0.200
     1.665    10.260     0.200
     2.680     9.070     0.200
     3.070    14.832     0.200
     3.863    13.031     0.200
     4.304    13.174     0.200
     6.526    23.542     0.200
     6.546    23.481     0.200
     7.545    24.200     0.200
     8.062    25.093     0.200
     9.689    29.177     0.200
     1.310     8.336     0.200
     1.401     6.697     0.200
     1.473     6.675     0.200
     1.683     7.234     0.200
     1.698     8.276     0.200
     1.736     7.334     0.200
     1.736     7.486     0.200
     1.909     8.482     0.200
     1.969     8.161     0.200
     2.104     8.078     0.200
     2.104     8.310     0.200
     2.145     8.996     0.200
     2.286     9.284     0.200
     2.315     9.363     0.200
     2.488    10.786     0.200
     2.612     9.740     0.200
     2.632    10.070     0.200
     2.861    11.068     0.200
     2.874    10.704     0.200
     2.888    11.415     0.200
     2.910    11.067     0.200
     3.128    11.946     0.200
     3.286    11.542     0.200
     3.359    13.054     0.200
     3.519    12.868     0.200
     3.713    13.519     0.200
     3.806    11.698     0.200
     3.906    13.526     0.200
     4.081    14.154     0.200
     4.310    14.669     0.200
     4.644    16.450     0.200
     5.466    18.034     0.200
     6.088    21.408     0.200
     6.154    18.416     0.200
     6.347    18.192     0.200
     6.703    21.198     0.200
     6.781    23.758     0.200
     6.800    23.573     0.200
     7.161    21.130     0.200
     7.234    21.112     0.200
     7.499    24.335     0.200
     7.856    23.164     0.200
     7.916    24.445     0.200
     8.421    22.759     0.200
     9.704    29.272     0.200
     9.748    27.910     0.200
    10.382    29.219     0.200
    10.640    30.624     0.200
    11.226    33.156     0.200
    11.464    27.048     0.200
    11.492    36.013     0.200
    15.386    37.895     0.200
    15.561    36.974     0.200
     1.244     8.090     0.200
     1.283     7.130     0.200
     1.312     8.210     0.200
     1.399     6.802     0.200
     1.474     6.736     0.200
     1.683     7.344     0.200
     1.700     8.451     0.200
     1.738     7.499     0.200
     1.738     7.601     0.200
     1.970     8.094     0.200
     2.102     8.173     0.200
     2.147     8.940     0.200
     2.285     9.230     0.200
     2.613     9.721     0.200
     2.876    10.727     0.200
     2.889    11.519     0.200
     2.912    10.934     0.200
     3.361    12.359     0.200
     3.905    13.867     0.200
     4.311    15.013     0.200
     4.643    16.611     0.200
     4.643    16.250     0.200
     4.898    17.006     0.200
     5.030    16.292     0.200
     5.165    15.641     0.200
     5.465    17.619     0.200
     5.465    17.951     0.200
     6.345    18.454     0.200
     6.345    18.216     0.200
     6.704    21.811     0.200
     6.781    23.959     0.200
     6.800    23.294     0.200
     7.232    21.223     0.200
     7.855    22.694     0.200
     7.855    22.512     0.200
     8.082    24.587     0.200
     8.419    22.583     0.200
     8.419    23.046     0.200
    10.380    29.171     0.200
    11.228    33.911     0.200
    11.492    34.672     0.200
     1.025     5.047     0.200
     1.062     5.545     0.200
     1.076     5.765     0.200
     1.080     5.477     0.200
     1.109     5.490     0.200
     1.109     5.637     0.200
     1.127     6.051     0.200
     1.202     6.300     0.200
     1.175     7.845     0.200
     1.177     7.830     0.200
     1.183     8.030     0.200
     1.368     6.426     0.200
     1.410     6.663     0.200
     1.418     6.794     0.200
     1.457     6.909     0.200
     1.477     6.812     0.200
     1.499     7.096     0.200
     1.556     7.148     0.200
     1.556     7.078     0.200
     1.619     7.332     0.200
     1.615     8.455     0.200
     1.617     8.432     0.200
     1.617     8.042     0.200
     1.739     7.706     0.200
     1.801     8.078     0.200
     1.812     8.307     0.200
     1.862     8.476     0.200
     2.029     8.637     0.200
     2.146     8.570     0.200
     2.177     8.788     0.200
     2.215     8.839     0.200
     2.215     9.219     0.200
     2.228     8.689     0.200
     2.306    10.852     0.200
     2.307     9.223     0.200
     2.318     9.396     0.200
     2.350     9.516     0.200
     2.371    10.805     0.200
     2.437     9.221     0.200
     2.448     9.286     0.200
     2.479    10.182     0.200
     2.498    11.000     0.200
     2.506    10.449     0.200
     2.525     9.528     0.200
     2.706    10.126     0.200
     2.640     9.218     0.200
     2.694    10.140     0.200
     2.780    10.011     0.200
     2.793    10.084     0.200
     2.877    10.477     0.200
     2.907    12.356     0.200
     2.938    11.042     0.200
     3.084    11.062     0.200
     3.228    11.120     0.200
     3.263    11.196     0.200
     3.276    11.215     0.200
     3.440    11.687     0.200
     3.467    12.682     0.200
     3.495    11.586     0.200
     3.524    12.221     0.200
     3.524    11.869     0.200
     3.680    11.991     0.200
     3.713    13.876     0.200
     3.733    12.332     0.200
     3.898    13.310     0.200
     3.914    12.948     0.200
     3.916    13.483     0.200
     4.069    13.570     0.200
     4.184    13.174     0.200
     4.226    13.614     0.200
     4.316    14.412     0.200
     4.272    12.647     0.200
     4.375    14.035     0.200
     4.530    14.623     0.200
     4.678    15.592     0.200
     4.765    15.779     0.200
     4.775    15.941     0.200
     4.830    15.311     0.200
     5.018    16.995     0.200
     5.204    17.491     0.200
     5.253    16.693     0.200
     5.497    17.948     0.200
     5.509    18.925     0.200
     5.545    17.521     0.200
     5.636    18.666     0.200
     5.636    18.393     0.200
     5.703    17.918     0.200
     5.703    17.320     0.200
     5.698    16.632     0.200
     5.924    18.966     0.200
     6.044    20.497     0.200
     6.123    18.346     0.200
     6.123    18.775     0.200
     6.196    21.751     0.200
     6.549    19.570     0.200
     6.551    21.126     0.200
     6.572    22.097     0.200
     6.667    21.040     0.200
     6.786    19.602     0.200
     7.339    21.632     0.200
     7.463    21.641     0.200
     7.549    23.770     0.200
     7.549    23.104     0.200
     7.556    21.749     0.200
     7.585    22.104     0.200
     7.686    22.792     0.200
     7.722    26.237     0.200
     7.759    24.026     0.200
     7.860    23.534     0.200
     7.837    22.298     0.200
     7.859    22.308     0.200
     7.960    24.043     0.200
     7.993    24.718     0.200
     8.071    24.692     0.200
     8.106    24.710     0.200
     8.106    23.475     0.200
     8.101    27.225     0.200
     8.130    23.030     0.200
     8.282    26.104     0.200
     8.342    26.799     0.200
     8.570    28.028     0.200
     8.901    24.037     0.200
     8.901    23.934     0.200
     8.952    26.631     0.200
     8.952    25.934     0.200
     9.443    29.405     0.200
     9.496    26.420     0.200
     9.575    30.085     0.200
     9.658    28.074     0.200
     9.658    26.852     0.200
     9.697    28.688     0.200
     9.859    27.536     0.200
     9.863    27.673     0.200
    10.397    31.661     0.200
    10.392    29.601     0.200
    10.392    28.680     0.200
    10.512    29.306     0.200
    10.606    31.493     0.200
    10.591    29.242     0.200
    10.719    30.188     0.200
    10.719    29.440     0.200
    10.908    31.595     0.200
    10.908    30.601     0.200
    10.964    33.169     0.200
    10.939    29.568     0.200
    10.940    29.359     0.200
    10.940    29.359     0.200
    10.985    31.114     0.200
    11.003    30.090     0.200
    11.201    29.712     0.200
    11.259    32.132     0.200
    11.259    31.290     0.200
    11.259    31.292     0.200
    11.248    30.198     0.200
    11.308    30.340     0.200
    11.400    34.482     0.200
    11.452    31.295     0.200
    11.425    34.520     0.200
    11.425    33.342     0.200
    11.436    31.850     0.200
    11.521    31.168     0.200
    11.632    31.739     0.200
    11.699    34.600     0.200
    11.682    31.429     0.200
    11.787    34.019     0.200
    11.769    31.659     0.200
    11.793    28.530     0.200
    11.801    29.406     0.200
    11.823    30.169     0.200
    11.876    35.428     0.200
    11.874    29.700     0.200
    11.878    30.435     0.200
    11.878    30.527     0.200
    11.913    32.994     0.200
    11.923    31.464     0.200
    11.983    30.045     0.200
    12.019    33.539     0.200
    12.040    31.157     0.200
    12.042    32.482     0.200
    12.113    32.741     0.200
    12.252    37.108     0.200
    12.222    33.420     0.200
    12.278    34.428     0.200
    12.309    33.093     0.200
    12.391    37.838     0.200
    12.362    32.398     0.200
    12.410    33.298     0.200
    12.410    31.770     0.200
    12.452    33.283     0.200
    12.424    32.335     0.200
    12.494    32.289     0.200
    12.559    33.588     0.200
    12.530    32.270     0.200
    12.557    33.757     0.200
    12.559    35.502     0.200
    12.623    32.653     0.200
    12.801    33.062     0.200
    12.867    37.771     0.200
    12.920    31.767     0.200
    13.008    32.456     0.200
    13.027    33.501     0.200
    13.091    33.680     0.200
    13.109    34.563     0.200
    13.142    33.516     0.200
    13.142    33.563     0.200
    13.276    33.996     0.200
    13.312    34.074     0.200
    13.282    34.944     0.200
    13.312    33.592     0.200
    13.371    33.659     0.200
    13.354    33.261     0.200
    13.409    35.772     0.200
    13.422    38.573     0.200
    13.407    34.738     0.200
    13.434    33.392     0.200
    13.567    34.559     0.200
    13.593    36.711     0.200
    13.640    36.562     0.200
    13.640    34.945     0.200
    13.729    36.385     0.200
    13.706    34.655     0.200
    13.713    33.115     0.200
    13.743    35.102     0.200
    13.755    34.285     0.200
    13.829    37.524     0.200
    13.881    36.713     0.200
    13.832    37.330     0.200
    13.832    35.478     0.200
    13.973    39.161     0.200
    14.095    38.095     0.200
    14.217    38.233     0.200
    14.225    37.898     0.200
    14.248    38.953     0.200
    14.186    35.818     0.200
    14.253    35.125     0.200
    14.348    35.569     0.200
    14.327    35.306     0.200
    14.341    36.769     0.200
    14.346    36.296     0.200
    14.356    36.870     0.200
    14.371    37.205     0.200
    14.423    36.686     0.200
    14.448    37.141     0.200
    14.596    38.947     0.200
    14.709    36.877     0.200
    14.926    34.544     0.200
    14.960    36.908     0.200
    14.972    35.924     0.200
    14.984    37.558     0.200
    15.057    36.890     0.200
    15.048    35.987     0.200
    15.052    37.201     0.200
    15.075    36.898     0.200
    15.054    36.744     0.200
    15.079    37.212     0.200
    15.095    35.654     0.200
    15.120    37.340     0.200
    15.218    38.388     0.200
    15.169    37.962     0.200
    15.167    38.431     0.200
    15.207    38.747     0.200
    15.290    38.517     0.200
    15.474    38.637     0.200
    15.474    38.053     0.200
    15.525    38.533     0.200
    15.540    38.315     0.200
    15.540    37.081     0.200
    15.547    38.481     0.200
    15.547    38.337     0.200
    15.590    37.625     0.200
    15.567    39.708     0.200
    15.677    38.551     0.200
    15.823    37.783     0.200
    15.874    37.447     0.200
    15.869    39.407     0.200
    15.936    38.412     0.200
    16.016    38.226     0.200
    16.126    39.842     0.200
    16.109    39.845     0.200
    16.151    39.899     0.200
    16.243    39.186     0.200
    16.326    38.489     0.200
    16.340    39.678     0.200
    16.387    39.507     0.200
    16.428    39.953     0.200
    16.470    38.949     0.200
    16.546    39.253     0.200
    16.528    39.952     0.200
    16.719    37.618     0.200
    16.805    39.269     0.200
    16.844    38.752     0.200
    16.876    39.893     0.200
    17.122    38.804     0.200
    17.119    37.524     0.200
    17.149    36.787     0.200
    17.293    39.675     0.200
    17.422    38.761     0.200
    17.450    38.222     0.200
    17.484    38.767     0.200
    17.504    39.211     0.200
    18.000    39.896     0.200
    18.630    41.363     0.200
    18.683    41.362     0.200
    20.651    40.995     0.200
     1.059     5.530     0.200
     1.086     5.680     0.200
     1.186     7.830     0.200
     1.354     6.485     0.200
     1.357     5.006     0.200
     1.472     7.268     0.200
     1.566     7.072     0.200
     1.632     8.279     0.200
     1.633     8.965     0.200
     1.633     9.555     0.200
     1.764     7.735     0.200
     1.840     8.622     0.200
     2.137     8.552     0.200
     2.189     9.363     0.200
     2.185     8.923     0.200
     2.291    10.614     0.200
     2.546     9.494     0.200
     2.668     9.233     0.200
     2.711    10.097     0.200
     2.762    10.314     0.200
     2.852    10.506     0.200
     2.942    10.928     0.200
     3.660    12.218     0.200
     3.894    12.991     0.200
     3.890    13.379     0.200
     4.087    13.677     0.200
     4.298    13.150     0.200
     4.512    14.920     0.200
     4.691    16.082     0.200
     4.691    15.839     0.200
     4.781    16.067     0.200
     5.273    16.797     0.200
     5.654    18.523     0.200
     5.654    18.648     0.200
     5.692    17.323     0.200
     5.692    17.729     0.200
     5.726    17.089     0.200
     6.104    18.828     0.200
     6.552    19.916     0.200
     6.812    19.478     0.200
     7.485    21.998     0.200
     7.562    23.901     0.200
     7.578    21.850     0.200
     7.608    22.359     0.200
     7.764    24.529     0.200
     7.882    22.292     0.200
     8.057    24.903     0.200
     8.081    24.163     0.200
     8.150    24.119     0.200
     8.928    24.132     0.200
     8.928    24.319     0.200
     8.965    26.241     0.200
     9.573    25.828     0.200
     9.708    28.280     0.200
     9.873    28.405     0.200
     9.878    26.607     0.200
     9.878    27.560     0.200
    10.968    30.116     0.200
    11.027    30.090     0.200
    11.260    33.685     0.200
    12.005    32.010     0.200
    13.858    36.389     0.200
    15.843    38.033     0.200
     1.010     5.057     0.200
     1.010     5.363     0.200
     1.019     5.298     0.200
     1.019     4.998     0.200
     1.051     5.352     0.200
     1.150     7.469     0.200
     1.165     7.569     0.200
     1.201     7.848     0.200
     1.312     6.166     0.200
     1.389     6.733     0.200
     1.429     5.668     0.200
     1.597     6.938     0.200
     1.687     9.432     0.200
     1.771     8.269     0.200
     1.839     7.712     0.200
     2.387    12.085     0.200
     2.610     9.428     0.200
     2.762    10.041     0.200
     2.752     9.106     0.200
     2.752     9.262     0.200
     3.011    12.500     0.200
     3.634    12.786     0.200
     3.832    12.788     0.200
     3.865    13.198     0.200
     4.139    13.893     0.200
     4.378    13.038     0.200
     4.799    16.114     0.200
     5.330    17.006     0.200
     5.477    17.409     0.200
     5.658    16.365     0.200
     5.706    18.192     0.200
     6.044    17.336     0.200
     6.452    18.744     0.200
     6.464    19.643     0.200
     6.888    19.449     0.200
     6.888    19.585     0.200
     7.550    20.871     0.200
     7.599    22.976     0.200
     7.907    21.981     0.200
     8.212    22.153     0.200
     9.008    23.558     0.200
     9.008    24.763     0.200
    11.258    29.954     0.200
     1.093     5.706     0.200
     1.182     6.002     0.200
     1.182     5.732     0.200
     1.182     5.838     0.200
     1.174     7.770     0.200
     1.279     7.511     0.200
     1.424     6.674     0.200
     1.550     7.055     0.200
     1.578     7.217     0.200
     1.556     8.668     0.200
     1.557     8.727     0.200
     1.645     7.486     0.200
     1.682     7.748     0.200
     1.863     9.355     0.200
     1.888     9.434     0.200
     1.936     8.724     0.200
     1.953     9.594     0.200
     2.067     9.938     0.200
     2.143    10.131     0.200
     2.176     8.955     0.200
     2.192     8.839     0.200
     2.288     8.884     0.200
     2.293     9.108     0.200
     2.293    10.497     0.200
     2.370     9.450     0.200
     2.382     9.082     0.200
     2.388     9.913     0.200
     2.411    10.881     0.200
     2.448    11.627     0.200
     2.481     9.492     0.200
     2.507     9.559     0.200
     2.527     9.397     0.200
     2.540    10.206     0.200
     2.558    11.177     0.200
     2.578     9.790     0.200
     2.568     8.973     0.200
     2.568     9.211     0.200
     2.665     9.985     0.200
     2.712    11.598     0.200
     2.725    11.649     0.200
     2.725    10.251     0.200
     2.777    11.733     0.200
     2.845    10.395     0.200
     2.845    10.122     0.200
     2.844    10.417     0.200
     2.954    10.672     0.200
     2.946    11.116     0.200
     3.162    10.785     0.200
     3.200    10.908     0.200
     3.200    11.392     0.200
     3.603    12.068     0.200
     3.748    12.271     0.200
     3.792    12.302     0.200
     3.809    12.161     0.200
     3.809    12.673     0.200
     3.838    14.618     0.200
     3.915    14.716     0.200
     3.938    13.193     0.200
     3.983    12.686     0.200
     4.036    13.851     0.200
     4.090    13.665     0.200
     4.207    12.265     0.200
     4.261    13.673     0.200
     4.370    15.047     0.200
     4.370    14.809     0.200
     4.454    15.005     0.200
     4.594    15.453     0.200
     4.661    15.921     0.200
     4.778    16.027     0.200
     4.800    13.712     0.200
     5.032    16.891     0.200
     5.215    16.669     0.200
     5.604    18.003     0.200
     5.604    18.460     0.200
     5.628    16.770     0.200
     5.750    17.764     0.200
     5.750    18.280     0.200
     6.189    19.165     0.200
     6.189    19.298     0.200
     6.589    20.100     0.200
     6.623    21.756     0.200
     6.624    17.227     0.200
     6.725    19.082     0.200
     6.725    19.539     0.200
     7.417    21.453     0.200
     7.508    21.307     0.200
     7.532    23.483     0.200
     7.532    23.757     0.200
     7.536    21.714     0.200
     7.639    23.014     0.200
     7.715    26.912     0.200
     7.768    22.891     0.200
     7.788    22.313     0.200
     7.812    22.276     0.200
     7.917    21.892     0.200
     7.927    24.245     0.200
     7.952    22.607     0.200
     7.952    25.400     0.200
     7.989    25.217     0.200
     8.042    25.228     0.200
     8.061    24.435     0.200
     8.087    23.889     0.200
     8.122    22.942     0.200
     8.151    25.175     0.200
     8.151    21.976     0.200
     8.602    24.645     0.200
     8.712    26.177     0.200
     8.837    23.880     0.200
     8.932    26.576     0.200
     8.932    26.225     0.200
     9.195    27.968     0.200
     9.476    25.581     0.200
     9.473    26.531     0.200
     9.659    27.217     0.200
     9.659    26.947     0.200
     9.839    27.558     0.200
     9.839    27.301     0.200
    10.012    28.424     0.200
    10.086    28.821     0.200
    10.186    28.503     0.200
    10.361    31.524     0.200
    10.361    28.149     0.200
    10.585    29.223     0.200
    10.679    32.614     0.200
    10.679    30.294     0.200
    10.702    30.553     0.200
    10.702    28.983     0.200
    10.804    30.585     0.200
    10.810    29.036     0.200
    10.867    29.248     0.200
    10.868    29.367     0.200
    10.897    30.447     0.200
    10.951    30.115     0.200
    10.981    30.493     0.200
    11.007    31.030     0.200
    11.140    31.519     0.200
    11.189    31.275     0.200
    11.238    30.890     0.200
    11.278    30.494     0.200
    11.279    31.922     0.200
    11.426    31.384     0.200
    11.513    30.783     0.200
    11.520    33.480     0.200
    11.545    34.137     0.200
    11.639    34.445     0.200
    11.725    33.440     0.200
    11.814    34.028     0.200
    11.904    32.874     0.200
    11.935    33.348     0.200
    13.076    38.091     0.200
    13.376    38.595     0.200
    13.459    36.294     0.200
    13.489    35.451     0.200
    13.582    33.339     0.200
    14.089    39.108     0.200
    14.421    37.245     0.200
    14.713    34.286     0.200
    14.737    38.799     0.200
    14.886    35.897     0.200
    15.182    35.283     0.200
    15.160    38.596     0.200
    15.315    36.496     0.200
    15.487    37.204     0.200
    15.497    37.086     0.200
    15.694    38.156     0.200
    16.812    39.485     0.200
    17.061    38.354     0.200
    18.580    41.200     0.200
    18.669    40.586     0.200
     1.168     5.976     0.200
     1.168     5.722     0.200
     1.548     7.245     0.200
     1.570    10.421     0.200
     1.570     9.151     0.200
     1.564     7.401     0.200
     1.691     7.422     0.200
     2.368    10.707     0.200
     2.376    10.837     0.200
     2.580     9.328     0.200
     2.942    11.289     0.200
     5.027    16.394     0.200
     5.220    16.875     0.200
     5.608    17.918     0.200
     5.608    18.180     0.200
     6.583    19.289     0.200
     6.735    19.627     0.200
     7.533    22.381     0.200
     7.543    22.035     0.200
     7.795    22.548     0.200
     7.819    22.174     0.200
     8.061    25.131     0.200
     8.093    23.385     0.200
     8.141    23.713     0.200
     8.847    24.063     0.200
     8.933    26.206     0.200
     9.841    27.609     0.200
    10.880    29.538     0.200
    14.304    33.920     0.200
    14.426    39.374     0.200
    15.682    38.597     0.200
    16.502    39.120     0.200
    17.048    40.043     0.200
    18.587    41.361     0.200
     1.094     5.736     0.200
     1.182     5.910     0.200
     1.158     7.793     0.200
     1.179     7.112     0.200
     1.172     7.787     0.200
     1.179     7.330     0.200
     1.425     6.746     0.200
     1.552     7.001     0.200
     1.577     7.442     0.200
     1.557     9.287     0.200
     1.647     7.425     0.200
     1.684     7.556     0.200
     2.483     9.365     0.200
     2.527    11.840     0.200
     2.569     8.735     0.200
     2.569     9.055     0.200
     2.577     9.090     0.200
     2.846    10.451     0.200
     3.809    12.588     0.200
     3.940    12.846     0.200
     3.983    12.900     0.200
     4.209    12.814     0.200
     4.779    16.483     0.200
     5.217    16.963     0.200
     5.606    16.532     0.200
     5.606    17.672     0.200
     6.190    18.784     0.200
     6.591    20.065     0.200
     6.624    17.594     0.200
     6.727    19.219     0.200
     6.727    19.453     0.200
     7.534    23.281     0.200
     7.770    23.756     0.200
     8.089    23.321     0.200
     0.933     5.037     0.200
     1.054     5.343     0.200
     1.100     5.448     0.200
     1.181     7.614     0.200
     1.184     7.561     0.200
     1.191     7.806     0.200
     1.359     6.301     0.200
     1.342     4.718     0.200
     1.492     6.855     0.200
     1.551     6.848     0.200
     1.612     7.092     0.200
     1.624     9.238     0.200
     1.624     8.469     0.200
     1.625     8.966     0.200
     1.625     9.566     0.200
     1.740     7.422     0.200
     1.854     8.330     0.200
     2.171     8.667     0.200
     2.343     9.094     0.200
     2.442    11.070     0.200
     2.492    10.401     0.200
     2.523     9.219     0.200
     2.644     8.952     0.200
     2.691     9.879     0.200
     2.772     9.878     0.200
     2.869    10.307     0.200
     2.931    10.764     0.200
     3.517    11.927     0.200
     3.671    11.864     0.200
     3.725    11.864     0.200
     3.889    14.435     0.200
     3.906    13.144     0.200
     4.066    13.759     0.200
     4.274    13.411     0.200
     4.521    14.490     0.200
     4.674    15.848     0.200
     4.674    15.666     0.200
     4.769    15.925     0.200
     5.251    16.607     0.200
     5.536    16.750     0.200
     5.633    18.434     0.200
     5.633    18.223     0.200
     6.114    18.737     0.200
     6.544    20.195     0.200
     6.544    19.507     0.200
     6.564    20.697     0.200
     6.787    19.337     0.200
     6.787    18.897     0.200
     7.545    23.647     0.200
     8.683    24.135     0.200
     8.903    23.988     0.200
    10.943    29.179     0.200
    11.252    31.501     0.200
     0.923     4.668     0.200
     1.180     9.059     0.200
     1.180     7.848     0.200
     1.239     7.198     0.200
     1.294     8.211     0.200
     1.414     6.773     0.200
     1.435     6.512     0.200
     1.655     7.892     0.200
     1.690     7.284     0.200
     1.866     7.560     0.200
     2.099     8.633     0.200
     2.137     7.829     0.200
     2.137     8.017     0.200
     3.910    13.648     0.200
     4.275    14.980     0.200
     4.324    14.205     0.200
     4.639    15.615     0.200
     4.639    15.795     0.200
     4.931    18.523     0.200
     5.040    16.045     0.200
     5.472    17.865     0.200
     5.472    17.748     0.200
     6.374    18.000     0.200
     6.374    18.273     0.200
     6.659    20.864     0.200
     7.117    22.252     0.200
     7.135    21.466     0.200
     7.252    21.039     0.200
     7.497    23.671     0.200
     7.561    21.185     0.200
     7.871    23.251     0.200
     7.899    22.126     0.200
     8.209    23.792     0.200
     8.452    23.011     0.200
     8.507    26.757     0.200
     9.817    30.447     0.200
    10.420    29.057     0.200
    10.661    32.037     0.200
    10.896    29.860     0.200
    11.180    32.596     0.200
    11.381    36.034     0.200
    11.471    32.893     0.200
    11.886    34.321     0.200
    12.010    37.471     0.200
    12.369    37.538     0.200
    13.369    33.965     0.200
    13.658    38.208     0.200
    14.759    38.725     0.200
    16.084    38.452     0.200
    16.404    39.196     0.200
    18.296    39.435     0.200
     0.983     4.973     0.200
     0.963     4.918     0.200
     1.250     7.559     0.200
     1.284     6.853     0.200
     1.270     7.990     0.200
     1.345     8.166     0.200
     1.360     7.547     0.200
     1.545     6.869     0.200
     1.724     7.276     0.200
     1.778     8.694     0.200
     1.823     7.586     0.200
     1.990     7.795     0.200
     2.041     7.750     0.200
     2.033     8.081     0.200
     2.231     8.908     0.200
     2.684     9.727     0.200
     2.948    10.894     0.200
     2.990    10.809     0.200
     3.181    13.529     0.200
     3.229    11.921     0.200
     3.361    11.295     0.200
     3.442    12.305     0.200
     3.753    11.128     0.200
     3.853    15.088     0.200
     4.375    15.050     0.200
     4.457    14.788     0.200
     4.594    15.814     0.200
     4.653    16.015     0.200
     4.893    15.242     0.200
     5.456    17.534     0.200
     5.456    18.081     0.200
     6.223    18.597     0.200
     6.223    18.836     0.200
     6.296    17.697     0.200
     6.296    17.822     0.200
     6.823    20.459     0.200
     6.841    22.168     0.200
     7.130    20.847     0.200
     7.200    21.053     0.200
     7.829    22.994     0.200
     8.106    25.371     0.200
     8.363    22.591     0.200
     8.363    21.942     0.200
     8.608    24.052     0.200
    10.312    28.165     0.200
    11.306    30.293     0.200
    11.533    31.758     0.200
    12.710    34.122     0.200
    12.869    32.353     0.200
    13.184    34.860     0.200
    13.213    35.481     0.200
    13.261    35.320     0.200
    13.829    35.563     0.200
    14.467    37.421     0.200
    14.479    37.297     0.200
    14.517    37.424     0.200
     0.981     5.371     0.200
     1.044     5.554     0.200
     1.038     5.529     0.200
     1.038     5.369     0.200
     1.176     7.815     0.200
     1.319     6.387     0.200
     1.418     7.369     0.200
     1.576     7.117     0.200
     1.605     7.400     0.200
     2.109     8.599     0.200
     2.173     8.773     0.200
     2.243    10.477     0.200
     2.719    10.237     0.200
     2.719    10.016     0.200
     2.719     9.856     0.200
     3.615    12.170     0.200
     3.658    12.498     0.200
     3.866    13.432     0.200
     4.344    14.508     0.200
     4.706    15.349     0.200
     5.287    16.988     0.200
     5.678    17.752     0.200
     5.678    18.444     0.200
     6.543    22.126     0.200
     6.855    19.813     0.200
     6.855    19.914     0.200
     7.576    23.715     0.200
     7.761    21.816     0.200
     8.064    25.397     0.200
     8.090    25.249     0.200
     8.182    24.256     0.200
     8.974    24.817     0.200
    11.064    31.570     0.200
     1.008     5.003     0.200
     1.008     5.483     0.200
     1.058     5.436     0.200
     1.340     8.611     0.200
     1.350     8.262     0.200
     1.390     7.442     0.200
     1.422     8.489     0.200
     1.466     8.382     0.200
     1.612     7.084     0.200
     1.885     8.778     0.200
     1.921     7.870     0.200
     1.921     8.098     0.200
     1.945     7.536     0.200
     1.945     7.782     0.200
     2.086     8.637     0.200
     3.097    11.802     0.200
     3.286    15.689     0.200
     3.335    13.998     0.200
     3.665    11.275     0.200
     3.958    14.731     0.200
     4.428    15.752     0.200
     4.632    16.557     0.200
     4.632    16.750     0.200
     4.682    15.946     0.200
     5.411    18.015     0.200
     5.654    19.211     0.200
     6.209    18.025     0.200
     6.209    18.283     0.200
     6.242    21.214     0.200
     6.281    20.364     0.200
     6.330    17.637     0.200
     6.842    21.239     0.200
     6.868    20.028     0.200
     7.063    22.120     0.200
     7.475    23.394     0.200
     7.475    23.615     0.200
     7.766    24.802     0.200
     8.076    26.004     0.200
     8.092    26.602     0.200
     8.152    23.275     0.200
     8.662    26.900     0.200
    10.210    28.909     0.200
     1.262     8.143     0.200
     1.273     7.854     0.200
     1.273     7.848     0.200
     1.316     8.222     0.200
     1.338     5.930     0.200
     1.424     8.191     0.200
     1.582     6.762     0.200
     1.602     6.677     0.200
     1.842     7.862     0.200
     2.023     8.321     0.200
     2.168     7.948     0.200
     2.168     8.280     0.200
     2.972    11.555     0.200
     4.180    14.519     0.200
     4.583    15.915     0.200
     4.583    16.110     0.200
     5.435    17.854     0.200
     5.435    17.659     0.200
     5.465    17.214     0.200
     6.384    18.618     0.200
     7.851    23.210     0.200
    10.658    28.383     0.200
     0.892     4.955     0.200
     1.074     4.948     0.200
     1.142     6.004     0.200
     1.236     6.925     0.200
     1.236     7.472     0.200
     1.280     5.779     0.200
     1.272     6.989     0.200
     1.272     6.872     0.200
     1.258     7.924     0.200
     1.344     6.303     0.200
     1.365     6.302     0.200
     1.357     7.809     0.200
     1.358     7.867     0.200
     1.358     7.656     0.200
     1.389     8.470     0.200
     1.442     8.813     0.200
     1.474     6.342     0.200
     1.471     6.837     0.200
     1.474     6.358     0.200
     1.584     7.107     0.200
     1.610     6.958     0.200
     1.611     6.350     0.200
     1.611     6.529     0.200
     1.609     7.148     0.200
     1.656     7.066     0.200
     1.678     7.938     0.200
     1.678     8.040     0.200
     1.693     7.534     0.200
     1.739     6.981     0.200
     1.764     7.153     0.200
     1.852     7.396     0.200
     1.965     7.923     0.200
     1.969     7.917     0.200
     2.003     7.996     0.200
     2.062     8.195     0.200
     2.077     7.384     0.200
     2.419     9.013     0.200
     3.008    13.098     0.200
     3.063    11.227     0.200
     3.195    11.561     0.200
     3.333    11.446     0.200
     3.682    13.177     0.200
     3.706    12.561     0.200
     3.743    11.222     0.200
     4.107    14.069     0.200
     4.245    12.341     0.200
     4.352    13.899     0.200
     4.458    16.097     0.200
     4.458    15.933     0.200
     4.629    15.203     0.200
     4.938    15.143     0.200
     5.017    16.135     0.200
     5.279    15.530     0.200
     5.308    17.864     0.200
     5.308    17.372     0.200
     5.367    17.092     0.200
     5.955    18.745     0.200
     6.274    18.223     0.200
     6.274    17.606     0.200
     6.535    19.303     0.200
     6.590    21.140     0.200
     7.039    21.737     0.200
     7.118    20.924     0.200
     7.318    22.849     0.200
     7.396    20.751     0.200
     7.618    21.633     0.200
     7.710    24.651     0.200
     7.726    23.061     0.200
     7.726    22.147     0.200
     7.812    23.519     0.200
     7.854    23.692     0.200
     7.895    26.342     0.200
     7.962    22.828     0.200
     8.189    22.158     0.200
     8.339    24.000     0.200
     8.735    27.497     0.200
     9.555    24.210     0.200
     9.572    25.823     0.200
     9.918    29.228     0.200
    10.373    29.552     0.200
    10.373    28.019     0.200
    10.540    32.332     0.200
    10.540    29.691     0.200
    11.283    30.213     0.200
    11.283    34.829     0.200
    11.967    33.567     0.200
    13.428    36.638     0.200
    13.582    36.102     0.200
    14.584    36.313     0.200
    14.618    36.378     0.200
    15.130    37.438     0.200
    15.210    35.574     0.200
    15.356    35.789     0.200
    15.448    35.193     0.200
    15.924    38.638     0.200
    20.865    43.126     0.200
     1.070     7.376     0.200
     1.175     7.615     0.200
     1.138     7.881     0.200
     1.138     7.331     0.200
     1.176     7.757     0.200
     1.144     6.374     0.200
     1.228     7.445     0.200
     1.437     6.437     0.200
     1.461     7.781     0.200
     1.645     8.151     0.200
     1.669     7.233     0.200
     1.685     7.145     0.200
     1.865     7.587     0.200
     1.939     8.005     0.200
     2.091     8.681     0.200
     2.150     8.175     0.200
     2.150     8.324     0.200
     2.438    10.029     0.200
     2.574     9.819     0.200
     2.808    10.599     0.200
     2.823    10.639     0.200
     2.857    10.780     0.200
     3.247    11.378     0.200
     3.467    12.437     0.200
     3.798    13.031     0.200
     3.848    11.519     0.200
     4.028    14.398     0.200
     4.229    14.316     0.200
     4.279    14.448     0.200
     4.319    14.317     0.200
     4.463    16.397     0.200
     4.597    15.505     0.200
     4.650    16.325     0.200
     4.650    16.153     0.200
     4.780    15.684     0.200
     5.484    17.944     0.200
     5.484    18.188     0.200
     5.558    18.784     0.200
     6.046    20.633     0.200
     6.120    18.569     0.200
     6.387    18.650     0.200
     6.387    18.257     0.200
     6.766    22.947     0.200
     6.785    23.127     0.200
     7.287    21.490     0.200
     7.508    23.378     0.200
     7.508    23.786     0.200
     7.883    22.591     0.200
     7.908    24.905     0.200
     8.086    25.227     0.200
     8.090    24.473     0.200
     8.510    25.007     0.200
     8.886    25.880     0.200
     8.929    25.178     0.200
     9.752    29.580     0.200
     9.762    28.882     0.200
     9.758    27.315     0.200
     9.789    27.514     0.200
     9.840    29.711     0.200
    10.117    29.770     0.200
    10.237    29.284     0.200
    10.431    28.653     0.200
    10.631    30.354     0.200
    10.674    29.812     0.200
    10.674    31.292     0.200
    10.861    28.798     0.200
    10.907    31.425     0.200
    10.907    31.919     0.200
    10.948    31.680     0.200
    11.009    31.565     0.200
    11.102    32.450     0.200
    11.152    33.044     0.200
    11.214    33.609     0.200
    11.383    33.873     0.200
    11.447    31.958     0.200
    11.445    34.449     0.200
    11.476    34.597     0.200
    11.478    33.291     0.200
    11.517    31.872     0.200
    11.690    34.649     0.200
    11.890    34.289     0.200
    11.923    34.586     0.200
    11.991    37.704     0.200
    12.065    35.362     0.200
    12.110    35.197     0.200
    12.290    33.671     0.200
    12.388    33.599     0.200
    12.497    34.642     0.200
    12.661    35.911     0.200
    12.713    35.610     0.200
    12.753    34.776     0.200
    12.819    36.907     0.200
    12.829    37.777     0.200
    12.982    35.678     0.200
    13.044    34.312     0.200
    13.283    34.658     0.200
    13.316    35.309     0.200
    13.369    37.327     0.200
    13.382    36.959     0.200
    13.522    36.703     0.200
    13.871    35.861     0.200
    13.933    37.267     0.200
    14.145    38.783     0.200
    14.338    38.806     0.200
    14.367    38.795     0.200
    14.599    38.877     0.200
    14.619    38.689     0.200
    14.654    39.147     0.200
    14.804    39.145     0.200
    14.869    38.539     0.200
    14.913    39.169     0.200
    15.199    39.331     0.200
    15.636    39.943     0.200
    15.891    39.836     0.200
    16.141    39.727     0.200
    16.598    38.939     0.200
    16.607    39.872     0.200
    17.281    38.691     0.200
    18.655    43.191     0.200
    18.655    42.570     0.200
    20.157    41.062     0.200
     1.042     5.669     0.200
     1.042     5.564     0.200
     1.051     5.552     0.200
     1.325     6.497     0.200
     1.418     6.943     0.200
     1.583     7.019     0.200
     1.612     7.266     0.200
     1.667     9.219     0.200
     1.668     9.546     0.200
     1.668     9.176     0.200
     1.794     8.496     0.200
     2.115     8.449     0.200
     2.137     9.004     0.200
     2.137     9.140     0.200
     2.178     8.686     0.200
     2.198     9.083     0.200
     2.224     8.708     0.200
     2.239     9.804     0.200
     2.250     8.772     0.200
     2.350     9.257     0.200
     2.374     9.441     0.200
     2.475     9.732     0.200
     2.565     9.612     0.200
     2.724    10.109     0.200
     2.755    10.110     0.200
     2.721     9.341     0.200
     2.802    10.462     0.200
     3.001    10.207     0.200
     3.040    11.038     0.200
     3.160    11.162     0.200
     3.231    11.205     0.200
     3.384    11.134     0.200
     3.446    12.167     0.200
     3.508    13.112     0.200
     3.619    12.181     0.200
     3.630    12.022     0.200
     3.660    12.198     0.200
     3.681    12.514     0.200
     3.853    12.860     0.200
     3.864    12.487     0.200
     3.872    12.807     0.200
     3.929    13.378     0.200
     4.074    14.760     0.200
     4.108    13.378     0.200
     4.161    13.774     0.200
     4.274    14.452     0.200
     4.274    14.294     0.200
     4.294    13.621     0.200
     4.348    12.884     0.200
     4.474    14.655     0.200
     4.548    14.415     0.200
     4.641    14.778     0.200
     4.713    15.522     0.200
     4.767    15.492     0.200
     4.754    16.411     0.200
     5.022    16.819     0.200
     5.211    17.138     0.200
     5.295    17.518     0.200
     5.494    18.199     0.200
     5.494    17.411     0.200
     5.488    17.676     0.200
     5.508    18.395     0.200
     5.610    16.344     0.200
     5.669    17.616     0.200
     5.669    17.803     0.200
     5.685    18.010     0.200
     5.685    18.162     0.200
     5.918    18.790     0.200
     6.064    18.966     0.200
     6.064    18.631     0.200
     6.051    19.808     0.200
     6.213    19.559     0.200
     6.477    19.034     0.200
     6.487    24.454     0.200
     6.550    21.111     0.200
     6.571    20.939     0.200
     6.676    21.342     0.200
     6.860    19.691     0.200
     7.002    21.836     0.200
     7.155    19.652     0.200
     7.236    22.682     0.200
     7.323    21.410     0.200
     7.358    22.889     0.200
     7.525    22.451     0.200
     7.584    22.687     0.200
     7.584    23.524     0.200
     7.628    25.289     0.200
     7.619    21.877     0.200
     7.650    22.098     0.200
     7.746    26.646     0.200
     7.768    24.073     0.200
     7.813    23.144     0.200
     7.882    23.128     0.200
     7.897    25.187     0.200
     7.909    23.822     0.200
     7.909    22.837     0.200
     7.901    23.032     0.200
     7.922    23.094     0.200
     7.983    25.105     0.200
     8.014    25.497     0.200
     8.073    23.037     0.200
     8.073    23.212     0.200
     8.071    25.892     0.200
     8.097    25.298     0.200
     8.098    25.525     0.200
     8.188    23.469     0.200
     8.188    23.870     0.200
     8.289    25.246     0.200
     8.285    24.144     0.200
     8.346    25.355     0.200
     8.553    24.554     0.200
     8.574    23.367     0.200
     8.671    25.124     0.200
     8.685    27.140     0.200
     8.716    21.117     0.200
     8.828    26.381     0.200
     8.833    26.217     0.200
     8.951    26.562     0.200
     8.989    25.227     0.200
     8.989    26.036     0.200
     9.139    26.889     0.200
     9.165    27.251     0.200
     9.380    27.337     0.200
     9.426    26.827     0.200
     9.429    26.734     0.200
     9.460    27.722     0.200
     9.517    27.468     0.200
     9.536    26.316     0.200
     9.566    28.546     0.200
     9.639    29.313     0.200
     9.673    27.691     0.200
     9.673    28.489     0.200
     9.693    28.852     0.200
     9.725    29.321     0.200
     9.803    27.680     0.200
     9.772    28.217     0.200
     9.809    28.910     0.200
     9.833    28.149     0.200
     9.909    28.382     0.200
     9.861    27.152     0.200
     9.861    29.291     0.200
     9.897    27.787     0.200
     9.904    27.231     0.200
     9.904    27.890     0.200
     9.979    28.971     0.200
     9.980    30.451     0.200
    10.119    30.508     0.200
    10.175    29.617     0.200
    10.243    27.969     0.200
    10.305    31.961     0.200
    10.275    30.214     0.200
    10.315    30.113     0.200
    10.468    31.154     0.200
    10.440    28.987     0.200
    10.440    30.073     0.200
    10.537    31.318     0.200
    10.537    31.547     0.200
    10.542    30.955     0.200
    10.576    27.617     0.200
    10.724    30.860     0.200
    10.779    32.784     0.200
    10.767    31.029     0.200
    10.754    29.708     0.200
    10.754    30.731     0.200
    10.934    31.846     0.200
    10.934    30.512     0.200
    10.955    31.601     0.200
    10.962    33.723     0.200
    10.936    31.303     0.200
    10.936    31.760     0.200
    11.021    29.810     0.200
    11.020    30.209     0.200
    11.021    29.834     0.200
    11.062    29.676     0.200
    11.070    30.174     0.200
    11.263    32.203     0.200
    11.256    31.993     0.200
    11.257    32.111     0.200
    11.257    32.111     0.200
    11.254    30.918     0.200
    11.275    31.156     0.200
    11.320    30.325     0.200
    11.374    34.172     0.200
    11.356    31.066     0.200
    11.391    31.660     0.200
    11.389    32.279     0.200
    11.377    30.469     0.200
    11.420    31.264     0.200
    11.446    31.752     0.200
    11.446    33.470     0.200
    11.480    32.098     0.200
    11.510    33.636     0.200
    11.508    31.735     0.200
    11.502    31.577     0.200
    11.598    33.251     0.200
    11.622    33.874     0.200
    11.585    31.377     0.200
    11.604    31.702     0.200
    11.689    33.870     0.200
    11.668    31.912     0.200
    11.683    32.348     0.200
    11.732    35.268     0.200
    11.740    32.787     0.200
    11.776    33.301     0.200
    11.760    31.797     0.200
    11.832    32.182     0.200
    11.863    34.144     0.200
    11.841    32.264     0.200
    11.872    32.449     0.200
    11.878    33.073     0.200
    11.877    31.825     0.200
    11.947    32.282     0.200
    11.952    32.681     0.200
    11.992    32.423     0.200
    11.971    31.893     0.200
    11.980    32.704     0.200
    11.987    32.355     0.200
    12.046    32.110     0.200
    12.063    32.964     0.200
    12.098    33.516     0.200
    12.102    32.404     0.200
    12.159    35.444     0.200
    12.119    31.977     0.200
    12.164    33.295     0.200
    12.215    35.398     0.200
    12.259    34.141     0.200
    12.311    33.474     0.200
    12.324    33.760     0.200
    12.393    36.117     0.200
    12.408    36.266     0.200
    12.422    35.444     0.200
    12.422    34.585     0.200
    12.420    32.520     0.200
    12.456    33.743     0.200
    12.431    32.511     0.200
    12.473    34.100     0.200
    12.491    33.653     0.200
    12.491    34.900     0.200
    12.563    33.226     0.200
    12.569    34.585     0.200
    12.581    36.188     0.200
    12.551    33.320     0.200
    12.569    34.099     0.200
    12.605    35.812     0.200
    12.626    36.479     0.200
    12.629    36.835     0.200
    12.602    33.221     0.200
    12.637    35.280     0.200
    12.624    34.699     0.200
    12.657    36.213     0.200
    12.643    34.033     0.200
    12.636    34.256     0.200
    12.694    36.900     0.200
    12.669    33.697     0.200
    12.721    36.433     0.200
    12.702    34.960     0.200
    12.775    34.235     0.200
    12.801    34.647     0.200
    12.818    37.273     0.200
    12.801    34.226     0.200
    12.801    34.001     0.200
    12.878    37.102     0.200
    12.928    37.906     0.200
    12.948    36.713     0.200
    12.934    33.327     0.200
    12.970    34.844     0.200
    12.980    35.218     0.200
    13.011    34.304     0.200
    13.019    34.971     0.200
    13.067    37.776     0.200
    13.072    34.424     0.200
    13.071    33.634     0.200
    13.081    33.980     0.200
    13.136    35.544     0.200
    13.152    34.824     0.200
    13.147    33.933     0.200
    13.155    34.834     0.200
    13.214    35.621     0.200
    13.231    35.792     0.200
    13.187    34.977     0.200
    13.216    34.444     0.200
    13.217    34.466     0.200
    13.255    34.491     0.200
    13.320    37.730     0.200
    13.310    35.486     0.200
    13.323    37.951     0.200
    13.322    35.152     0.200
    13.322    35.606     0.200
    13.347    34.801     0.200
    13.365    33.828     0.200
    13.399    37.020     0.200
    13.360    35.340     0.200
    13.392    34.878     0.200
    13.415    34.712     0.200
    13.418    35.529     0.200
    13.439    36.730     0.200
    13.439    35.959     0.200
    13.456    35.833     0.200
    13.455    33.470     0.200
    13.496    35.683     0.200
    13.545    35.742     0.200
    13.572    34.793     0.200
    13.591    35.484     0.200
    13.611    35.823     0.200
    13.653    35.631     0.200
    13.755    34.794     0.200
    13.712    35.034     0.200
    13.712    35.488     0.200
    13.749    35.594     0.200
    13.746    34.553     0.200
    13.789    34.404     0.200
    13.781    34.477     0.200
    13.787    34.652     0.200
    13.824    35.694     0.200
    13.812    34.671     0.200
    13.836    33.280     0.200
    13.836    36.549     0.200
    13.831    35.864     0.200
    13.836    35.439     0.200
    13.876    35.719     0.200
    13.928    38.337     0.200
    13.923    35.678     0.200
    13.911    35.108     0.200
    13.907    36.407     0.200
    13.909    36.807     0.200
    13.909    35.850     0.200
    13.936    36.234     0.200
    13.932    36.477     0.200
    13.957    36.527     0.200
    13.980    38.841     0.200
    13.991    38.933     0.200
    13.979    35.714     0.200
    14.022    35.257     0.200
    14.039    35.413     0.200
    14.036    35.313     0.200
    14.059    36.052     0.200
    14.158    38.041     0.200
    14.192    39.031     0.200
    14.191    36.078     0.200
    14.174    36.234     0.200
    14.218    38.392     0.200
    14.218    38.284     0.200
    14.192    35.315     0.200
    14.233    36.204     0.200
    14.242    35.726     0.200
    14.253    36.939     0.200
    14.267    36.459     0.200
    14.289    36.685     0.200
    14.304    38.427     0.200
    14.318    37.281     0.200
    14.325    36.406     0.200
    14.364    39.593     0.200
    14.367    38.679     0.200
    14.390    37.354     0.200
    14.411    36.236     0.200
    14.419    35.399     0.200
    14.400    36.022     0.200
    14.411    36.155     0.200
    14.410    36.197     0.200
    14.422    36.226     0.200
    14.462    37.483     0.200
    14.421    35.698     0.200
    14.430    36.465     0.200
    14.490    38.382     0.200
    14.448    37.065     0.200
    14.472    35.647     0.200
    14.498    37.117     0.200
    14.548    38.547     0.200
    14.515    37.118     0.200
    14.577    35.393     0.200
    14.631    36.513     0.200
    14.667    39.155     0.200
    14.652    37.542     0.200
    14.640    35.937     0.200
    14.651    38.214     0.200
    14.691    37.270     0.200
    14.696    36.444     0.200
    14.723    37.912     0.200
    14.697    38.516     0.200
    14.728    36.734     0.200
    14.765    38.417     0.200
    14.742    36.168     0.200
    14.755    35.810     0.200
    14.777    36.371     0.200
    14.786    35.967     0.200
    14.800    36.972     0.200
    14.803    36.309     0.200
    14.829    38.453     0.200
    14.889    39.477     0.200
    14.883    37.311     0.200
    14.931    36.234     0.200
    14.912    36.802     0.200
    14.945    35.855     0.200
    14.961    36.186     0.200
    15.011    39.359     0.200
    15.001    37.252     0.200
    15.032    37.374     0.200
    15.058    35.799     0.200
    15.031    36.684     0.200
    15.045    36.724     0.200
    15.058    37.315     0.200
    15.106    40.356     0.200
    15.124    35.441     0.200
    15.117    37.012     0.200
    15.128    37.637     0.200
    15.137    36.501     0.200
    15.131    37.676     0.200
    15.151    35.625     0.200
    15.184    40.245     0.200
    15.215    39.203     0.200
    15.185    37.665     0.200
    15.203    37.797     0.200
    15.241    40.069     0.200
    15.244    39.087     0.200
    15.255    38.289     0.200
    15.236    36.891     0.200
    15.286    39.963     0.200
    15.248    38.168     0.200
    15.270    37.672     0.200
    15.270    38.785     0.200
    15.284    37.914     0.200
    15.303    37.675     0.200
    15.345    36.375     0.200
    15.365    40.309     0.200
    15.416    37.454     0.200
    15.412    36.776     0.200
    15.398    38.663     0.200
    15.421    35.119     0.200
    15.409    38.104     0.200
    15.450    36.061     0.200
    15.538    38.693     0.200
    15.534    38.688     0.200
    15.534    38.530     0.200
    15.600    39.471     0.200
    15.600    40.171     0.200
    15.597    37.774     0.200
    15.598    37.691     0.200
    15.598    38.564     0.200
    15.596    37.338     0.200
    15.620    37.926     0.200
    15.620    38.361     0.200
    15.640    37.061     0.200
    15.648    39.043     0.200
    15.673    37.608     0.200
    15.708    39.111     0.200
    15.709    38.891     0.200
    15.728    37.293     0.200
    15.711    38.446     0.200
    15.749    38.533     0.200
    15.751    37.937     0.200
    15.811    38.193     0.200
    15.823    37.389     0.200
    15.840    38.539     0.200
    15.847    37.382     0.200
    15.843    40.011     0.200
    15.879    39.937     0.200
    15.898    39.991     0.200
    15.904    39.192     0.200
    15.870    39.721     0.200
    15.902    39.948     0.200
    15.889    37.650     0.200
    15.891    39.069     0.200
    15.890    39.461     0.200
    15.952    36.931     0.200
    15.951    40.222     0.200
    15.969    37.991     0.200
    16.026    40.702     0.200
    16.022    38.004     0.200
    15.999    37.389     0.200
    16.039    38.580     0.200
    16.020    40.552     0.200
    16.065    37.837     0.200
    16.077    39.912     0.200
    16.076    38.285     0.200
    16.147    39.220     0.200
    16.176    39.739     0.200
    16.163    37.505     0.200
    16.192    37.405     0.200
    16.198    38.104     0.200
    16.188    40.780     0.200
    16.251    38.854     0.200
    16.225    39.231     0.200
    16.251    39.338     0.200
    16.268    39.496     0.200
    16.278    39.090     0.200
    16.289    39.837     0.200
    16.305    39.004     0.200
    16.344    39.206     0.200
    16.379    39.419     0.200
    16.398    39.403     0.200
    16.405    38.468     0.200
    16.474    39.205     0.200
    16.465    40.834     0.200
    16.489    37.927     0.200
    16.485    38.384     0.200
    16.524    39.869     0.200
    16.545    39.205     0.200
    16.528    38.232     0.200
    16.617    40.604     0.200
    16.595    39.446     0.200
    16.622    38.851     0.200
    16.624    39.386     0.200
    16.607    41.004     0.200
    16.651    38.953     0.200
    16.650    40.096     0.200
    16.665    39.426     0.200
    16.670    40.568     0.200
    16.704    41.074     0.200
    16.773    38.861     0.200
    16.811    39.871     0.200
    16.835    40.787     0.200
    16.864    38.990     0.200
    16.893    39.185     0.200
    16.893    39.467     0.200
    16.914    39.825     0.200
    16.921    39.222     0.200
    16.936    39.348     0.200
    16.936    39.528     0.200
    16.931    40.306     0.200
    16.935    40.350     0.200
    16.977    39.781     0.200
    16.985    40.457     0.200
    16.982    39.409     0.200
    17.004    38.898     0.200
    17.008    39.605     0.200
    17.007    39.263     0.200
    17.044    39.453     0.200
    17.076    40.140     0.200
    17.107    40.637     0.200
    17.095    40.476     0.200
    17.084    40.688     0.200
    17.160    40.622     0.200
    17.183    39.556     0.200
    17.209    40.007     0.200
    17.215    39.187     0.200
    17.214    39.583     0.200
    17.257    39.303     0.200
    17.311    40.049     0.200
    17.354    40.166     0.200
    17.347    39.348     0.200
    17.454    39.835     0.200
    17.497    40.237     0.200
    17.536    39.755     0.200
    17.523    40.963     0.200
    17.536    39.864     0.200
    17.536    40.396     0.200
    17.594    40.375     0.200
    17.573    39.878     0.200
    17.599    40.824     0.200
    17.586    40.084     0.200
    17.597    40.872     0.200
    17.643    40.533     0.200
    17.718    40.006     0.200
    17.733    40.098     0.200
    17.761    40.434     0.200
    17.778    39.829     0.200
    17.828    40.910     0.200
    17.925    40.276     0.200
    17.983    40.072     0.200
    18.007    40.733     0.200
    18.061    39.977     0.200
    18.053    40.023     0.200
    18.063    40.686     0.200
    18.082    40.797     0.200
    18.086    40.265     0.200
    18.113    40.635     0.200
    18.118    40.237     0.200
    18.131    40.620     0.200
    18.152    40.695     0.200
    18.163    41.202     0.200
    18.245    40.664     0.200
    18.269    41.121     0.200
    18.313    40.458     0.200
    18.401    40.633     0.200
    18.407    40.991     0.200
    18.575    41.950     0.200
    18.713    41.096     0.200
    18.713    41.581     0.200
    18.711    41.324     0.200
    18.776    41.659     0.200
    18.873    41.261     0.200
    18.873    41.789     0.200
    19.205    40.971     0.200
    19.634    40.993     0.200
    19.710    41.241     0.200
     1.023     5.681     0.200
     1.008     5.446     0.200
     1.053     5.465     0.200
     1.199     7.923     0.200
     1.315     6.424     0.200
     1.683    10.476     0.200
     1.775     8.653     0.200
     2.166     8.826     0.200
     2.213    10.486     0.200
     2.709    10.123     0.200
     2.746    10.189     0.200
     2.748     9.952     0.200
     3.602    12.478     0.200
     3.638    12.303     0.200
     3.836    13.479     0.200
     3.868    13.819     0.200
     4.263    14.670     0.200
     4.374    13.338     0.200
     4.459    14.949     0.200
     4.728    16.240     0.200
     5.297    17.594     0.200
     5.481    18.066     0.200
     5.661    17.660     0.200
     5.704    18.587     0.200
     5.704    18.480     0.200
     6.048    19.083     0.200
     6.456    19.642     0.200
     6.554    21.237     0.200
     6.575    21.184     0.200
     6.885    19.822     0.200
     7.547    22.278     0.200
     7.598    24.148     0.200
     7.598    24.552     0.200
     7.633    21.214     0.200
     7.642    22.289     0.200
     7.673    22.951     0.200
     7.801    23.672     0.200
     7.775    25.594     0.200
     7.945    22.778     0.200
     7.994    25.115     0.200
     8.066    24.007     0.200
     8.083    25.390     0.200
     8.110    23.269     0.200
     8.210    23.682     0.200
     8.210    24.057     0.200
     8.551    27.594     0.200
     8.687    27.175     0.200
     9.004    26.622     0.200
     9.566    27.456     0.200
     9.682    27.216     0.200
     9.737    28.826     0.200
     9.912    28.427     0.200
     9.921    27.639     0.200
    10.517    31.470     0.200
    10.949    32.777     0.200
    10.949    32.043     0.200
    11.048    29.732     0.200
    11.081    31.297     0.200
    11.093    30.803     0.200
    11.093    30.604     0.200
    11.259    33.108     0.200
    11.259    33.016     0.200
    11.301    31.801     0.200
    11.389    35.444     0.200
    11.346    30.563     0.200
    11.402    31.418     0.200
    11.440    32.496     0.200
    11.526    32.393     0.200
    11.621    31.745     0.200
    11.608    33.161     0.200
    11.702    32.555     0.200
    11.875    33.804     0.200
    11.972    32.293     0.200
    12.004    34.753     0.200
    11.998    32.832     0.200
    12.068    33.575     0.200
    12.146    32.231     0.200
    12.184    33.957     0.200
    12.315    35.875     0.200
    12.651    36.174     0.200
    12.648    35.637     0.200
    12.728    36.113     0.200
    12.819    35.006     0.200
    12.924    38.579     0.200
    13.016    36.230     0.200
    13.179    35.841     0.200
    13.213    36.806     0.200
    13.279    35.372     0.200
    13.340    36.159     0.200
    13.395    36.773     0.200
    13.387    37.134     0.200
    13.457    37.538     0.200
    13.441    35.295     0.200
    13.519    36.768     0.200
    13.572    36.870     0.200
    13.674    38.462     0.200
    13.807    36.868     0.200
    13.812    36.323     0.200
    13.836    35.691     0.200
    13.857    37.204     0.200
    13.933    37.746     0.200
    13.935    37.586     0.200
    13.935    37.769     0.200
    14.002    36.848     0.200
    14.036    37.220     0.200
    14.081    37.293     0.200
    14.212    38.964     0.200
    14.201    36.982     0.200
    14.269    38.555     0.200
    14.311    38.871     0.200
    14.362    38.100     0.200
    14.350    37.695     0.200
    14.425    36.859     0.200
    14.434    37.559     0.200
    14.456    36.975     0.200
    14.474    37.444     0.200
    14.538    37.911     0.200
    14.677    38.541     0.200
    14.731    36.308     0.200
    14.821    39.165     0.200
    14.883    36.160     0.200
    15.100    39.052     0.200
    15.084    38.694     0.200
    15.177    37.100     0.200
    15.154    38.673     0.200
    15.158    39.005     0.200
    15.275    39.950     0.200
    15.430    40.083     0.200
    15.590    38.216     0.200
    15.645    38.535     0.200
    15.777    40.135     0.200
    16.099    39.142     0.200
    16.423    40.459     0.200
    16.507    39.802     0.200
    17.029    40.516     0.200
    17.185    40.051     0.200
    18.727    42.777     0.200
    18.719    41.066     0.200
    20.113    43.338     0.200
    20.589    41.905     0.200
    20.942    40.582     0.200
     0.608     5.476     0.200
     1.014     5.736     0.200
     1.010     5.654     0.200
     1.048     5.616     0.200
     1.205     7.988     0.200
     1.308     6.491     0.200
     1.385     7.301     0.200
     1.595     7.236     0.200
     1.610     7.435     0.200
     1.691     8.306     0.200
     1.691    10.097     0.200
     1.766     8.738     0.200
     2.103     8.630     0.200
     2.105     9.137     0.200
     2.158     8.857     0.200
     2.206     9.057     0.200
     2.207    10.467     0.200
     2.701    10.271     0.200
     2.739    10.187     0.200
     2.771    10.728     0.200
     2.754     9.480     0.200
     3.133    11.365     0.200
     3.213    11.352     0.200
     3.413    12.454     0.200
     3.593    12.344     0.200
     3.630    12.454     0.200
     3.828    13.332     0.200
     3.895    13.950     0.200
     4.077    13.679     0.200
     4.256    14.538     0.200
     4.379    13.497     0.200
     4.451    15.018     0.200
     4.727    16.107     0.200
     5.292    17.837     0.200
     5.473    17.902     0.200
     5.705    18.742     0.200
     6.040    19.017     0.200
     6.448    19.725     0.200
     6.460    20.684     0.200
     6.550    21.794     0.200
     6.571    23.221     0.200
     6.889    19.907     0.200
     7.550    21.737     0.200
     7.597    23.963     0.200
     7.645    22.404     0.200
     7.675    22.533     0.200
     8.059    24.744     0.200
     8.212    23.690     0.200
     9.912    28.188     0.200
     9.921    27.914     0.200
     9.921    27.693     0.200
    10.509    33.311     0.200
    10.554    29.079     0.200
    11.054    29.867     0.200
    11.097    30.703     0.200
    11.255    31.964     0.200
    11.350    30.134     0.200
    11.442    31.477     0.200
    11.529    31.744     0.200
    11.703    33.051     0.200
    12.007    34.470     0.200
    12.184    34.093     0.200
    12.273    34.622     0.200
    12.424    32.436     0.200
    12.631    33.995     0.200
    12.651    35.739     0.200
    13.812    35.054     0.200
    13.862    36.346     0.200
    13.939    36.559     0.200
    14.084    37.690     0.200
    14.205    38.985     0.200
    14.407    38.258     0.200
    14.438    37.391     0.200
    14.461    37.381     0.200
    14.541    38.268     0.200
    15.074    38.515     0.200
    15.089    38.499     0.200
    15.211    38.960     0.200
    20.109    42.376     0.200
    20.494    40.732     0.200
     0.984     5.436     0.200
     1.061     5.560     0.200
     1.059     5.601     0.200
     1.059     5.355     0.200
     1.152     7.577     0.200
     1.161     7.542     0.200
     1.185     7.891     0.200
     1.386     7.018     0.200
     1.340     6.468     0.200
     1.435     7.375     0.200
     1.586     7.152     0.200
     1.651     8.890     0.200
     1.622     7.452     0.200
     1.812     8.606     0.200
     2.129     8.772     0.200
     2.154     9.329     0.200
     2.202     9.153     0.200
     2.194     8.964     0.200
     2.251    10.331     0.200
     2.358     9.954     0.200
     2.708     9.436     0.200
     2.708     9.801     0.200
     2.769    10.158     0.200
     3.178    11.668     0.200
     3.247    11.447     0.200
     3.636    12.477     0.200
     3.870    12.640     0.200
     3.885    13.457     0.200
     3.880    13.502     0.200
     4.126    13.594     0.200
     4.337    14.319     0.200
     4.289    14.364     0.200
     4.491    14.701     0.200
     4.715    15.864     0.200
     4.715    16.276     0.200
     5.304    17.593     0.200
     5.510    17.892     0.200
     5.683    18.537     0.200
     6.081    19.633     0.200
     6.559    23.849     0.200
     6.580    23.877     0.200
     6.850    19.504     0.200
     6.850    19.917     0.200
     8.075    26.277     0.200
     8.183    23.684     0.200
     9.576    30.265     0.200
    11.008    31.303     0.200
    11.063    31.271     0.200
    11.063    32.025     0.200
    11.266    31.564     0.200
    13.533    37.664     0.200
    13.896    38.378     0.200
    15.714    39.930     0.200
    16.037    39.563     0.200
    18.716    44.130     0.200
    20.112    42.796     0.200
    20.942    41.089     0.200
     1.010     5.728     0.200
     1.009     5.475     0.200
     1.044     5.637     0.200
     1.172     7.687     0.200
     1.209     7.882     0.200
     1.303     6.483     0.200
     1.382     7.264     0.200
     1.437     8.739     0.200
     1.592     7.229     0.200
     1.606     7.463     0.200
     1.762     8.772     0.200
     1.695     9.937     0.200
     2.098     8.597     0.200
     2.101     9.252     0.200
     2.154     8.841     0.200
     2.203     9.050     0.200
     2.206    10.381     0.200
     2.696    10.315     0.200
     2.756     9.298     0.200
     3.823    12.946     0.200
     3.857    14.501     0.200
     4.380    13.821     0.200
     4.725    15.873     0.200
     5.468    17.549     0.200
     5.650    17.182     0.200
     5.703    18.277     0.200
     6.546    22.933     0.200
     6.890    19.927     0.200
     7.595    24.372     0.200
     7.644    22.091     0.200
     8.078    25.509     0.200
     8.211    23.801     0.200
     9.919    28.002     0.200
    11.096    33.139     0.200
     0.918     4.749     0.200
     0.918     4.906     0.200
     1.076     5.475     0.200
     1.145     5.600     0.200
     1.298     5.934     0.200
     1.395     6.432     0.200
     1.539     7.195     0.200
     1.551     6.890     0.200
     1.587     8.525     0.200
     1.631     7.150     0.200
     1.899     8.393     0.200
     2.168     8.834     0.200
     2.175     8.691     0.200
     2.345     9.415     0.200
     2.354    10.680     0.200
     2.603     8.898     0.200
     2.915    10.575     0.200
     3.917    14.607     0.200
     3.948    13.734     0.200
     4.238    12.736     0.200
     4.342    15.455     0.200
     4.669    15.808     0.200
     4.669    15.567     0.200
     5.311    17.307     0.200
     5.574    19.086     0.200
     5.619    18.480     0.200
     6.155    21.145     0.200
     6.559    22.999     0.200
     6.579    20.983     0.200
     6.586    22.454     0.200
     6.754    19.300     0.200
     7.439    21.446     0.200
     7.539    23.611     0.200
     7.539    23.745     0.200
     7.631    24.867     0.200
     7.762    23.192     0.200
     7.835    22.091     0.200
     8.044    25.337     0.200
     8.065    24.994     0.200
     8.107    23.223     0.200
     8.107    23.448     0.200
     8.941    26.250     0.200
     9.657    28.500     0.200
     9.657    28.109     0.200
     9.691    28.580     0.200
     9.850    27.207     0.200
     9.850    27.071     0.200
    10.709    29.967     0.200
    10.903    29.221     0.200
    10.976    32.427     0.200
    10.976    31.669     0.200
    11.268    32.321     0.200
    11.408    33.183     0.200
    11.885    34.307     0.200
    11.958    35.171     0.200
    12.094    33.921     0.200
    13.722    37.018     0.200
    13.971    36.921     0.200
    14.296    36.445     0.200
    14.312    36.937     0.200
    14.320    36.069     0.200
    20.673    42.099     0.200
     1.204     7.463     0.200
     1.409     6.293     0.200
     1.437     8.396     0.200
     1.620     8.529     0.200
     1.655     7.201     0.200
     1.835     7.809     0.200
     1.914     8.129     0.200
     2.062     8.846     0.200
     2.168     8.297     0.200
     2.168     7.578     0.200
     2.547     9.841     0.200
     2.801    10.825     0.200
     2.832    11.105     0.200
     4.253    14.309     0.200
     4.288    14.227     0.200
     4.432    15.153     0.200
     4.642    16.779     0.200
     4.642    16.416     0.200
     5.483    17.713     0.200
     5.483    18.365     0.200
     5.537    18.489     0.200
     6.093    18.618     0.200
     6.093    18.829     0.200
     6.400    18.455     0.200
     6.627    19.207     0.200
     6.766    21.599     0.200
     7.501    24.104     0.200
     7.887    24.844     0.200
     8.076    26.438     0.200
     8.079    26.460     0.200
     8.483    24.723     0.200
     8.880    26.215     0.200
    10.452    29.563     0.200
    10.683    32.686     0.200
     1.084     7.295     0.200
     1.182     7.028     0.200
     1.182     7.368     0.200
     1.226     7.754     0.200
     1.381     6.339     0.200
     1.415     8.246     0.200
     1.597     8.171     0.200
     1.633     7.010     0.200
     1.625     7.048     0.200
     1.889     7.704     0.200
     2.185     8.252     0.200
     2.185     8.045     0.200
     2.806    11.475     0.200
     3.656    14.063     0.200
     3.875    11.886     0.200
     4.226    15.207     0.200
     4.258    15.623     0.200
     4.402    14.662     0.200
     5.174    17.322     0.200
     5.256    15.009     0.200
     5.480    18.247     0.200
     5.516    17.880     0.200
     6.066    18.308     0.200
     6.249    18.286     0.200
     6.412    18.794     0.200
     6.727    22.519     0.200
     6.746    23.698     0.200
     7.053    27.021     0.200
     7.070    19.620     0.200
     7.492    23.321     0.200
     7.553    22.380     0.200
     7.733    25.151     0.200
     7.875    22.027     0.200
     7.984    23.719     0.200
     8.065    24.714     0.200
     8.067    24.980     0.200
    10.472    29.435     0.200
    11.439    34.091     0.200
     1.004     5.553     0.200
     1.061     5.576     0.200
     1.287     8.470     0.200
     1.350     8.631     0.200
     1.359     8.145     0.200
     1.396     7.485     0.200
     1.416     7.395     0.200
     1.432     8.769     0.200
     1.474     8.099     0.200
     1.612     7.386     0.200
     1.742     7.805     0.200
     1.892     9.347     0.200
     1.892     9.749     0.200
     1.936     7.985     0.200
     1.936     7.850     0.200
     1.924     8.153     0.200
     2.039    10.020     0.200
     2.083     8.542     0.200
     2.297    10.750     0.200
     2.750    10.215     0.200
     3.430    11.768     0.200
     4.426    15.930     0.200
     4.623    16.695     0.200
     4.962    17.906     0.200
     5.277    18.135     0.200
     5.402    18.691     0.200
     5.649    19.164     0.200
     6.279    18.864     0.200
     6.854    23.974     0.200
     7.053    20.833     0.200
     7.394    21.526     0.200
     7.467    24.285     0.200
     7.756    21.756     0.200
     7.870    24.643     0.200
     7.947    26.761     0.200
     8.003    26.746     0.200
     8.050    26.304     0.200
     8.068    27.067     0.200
     8.084    27.469     0.200
    10.200    29.226     0.200
     0.983     4.970     0.200
     0.983     5.322     0.200
     0.982     5.216     0.200
     1.275     7.530     0.200
     1.290     8.263     0.200
     1.308     7.025     0.200
     1.343     5.834     0.200
     1.367     8.314     0.200
     1.385     7.646     0.200
     1.385     7.529     0.200
     1.556     7.177     0.200
     1.556     7.010     0.200
     1.638     7.166     0.200
     1.759     8.116     0.200
     1.803     8.501     0.200
     1.803     8.547     0.200
     1.827     7.847     0.200
     1.844     7.615     0.200
     1.876     7.945     0.200
     1.883     8.403     0.200
     1.897     8.002     0.200
     1.955     8.195     0.200
     2.005     8.030     0.200
     2.040     8.263     0.200
     2.040     8.068     0.200
     2.118     8.293     0.200
     2.167     8.837     0.200
     2.174     8.822     0.200
     2.212     8.896     0.200
     2.255     9.246     0.200
     2.352     9.440     0.200
     2.524     9.304     0.200
     2.595    10.204     0.200
     2.631     9.975     0.200
     2.695     9.880     0.200
     2.695     9.735     0.200
     2.877    10.173     0.200
     2.971    10.275     0.200
     2.971    10.845     0.200
     2.971    10.876     0.200
     2.959    11.825     0.200
     2.974    10.565     0.200
     3.068    11.595     0.200
     3.147    11.014     0.200
     3.235    11.521     0.200
     3.253    12.899     0.200
     3.373    11.415     0.200
     3.400    11.823     0.200
     3.458    10.626     0.200
     3.628    12.236     0.200
     3.822    12.482     0.200
     3.877    12.960     0.200
     3.877    14.569     0.200
     3.953    12.819     0.200
     4.187    13.174     0.200
     4.280    14.134     0.200
     4.378    13.754     0.200
     4.452    13.289     0.200
     4.478    14.222     0.200
     4.562    13.274     0.200
     4.611    14.469     0.200
     4.643    15.686     0.200
     4.643    15.561     0.200
     4.760    15.107     0.200
     4.905    16.539     0.200
     4.905    15.289     0.200
     4.936    15.478     0.200
     4.940    15.576     0.200
     5.130    16.520     0.200
     5.131    17.505     0.200
     5.195    16.283     0.200
     5.264    17.849     0.200
     5.421    17.974     0.200
     5.477    18.024     0.200
     5.440    18.217     0.200
     5.613    18.033     0.200
     5.627    18.584     0.200
     5.790    19.625     0.200
     5.839    18.937     0.200
     6.231    18.545     0.200
     6.272    19.678     0.200
     6.249    21.021     0.200
     6.272    18.256     0.200
     6.470    21.297     0.200
     6.801    23.536     0.200
     6.801    21.063     0.200
     6.854    21.783     0.200
     6.953    22.146     0.200
     7.110    21.448     0.200
     7.200    21.369     0.200
     7.288    21.227     0.200
     7.454    21.833     0.200
     7.491    23.422     0.200
     7.491    23.696     0.200
     7.760    26.943     0.200
     7.810    21.712     0.200
     7.810    22.938     0.200
     7.810    22.786     0.200
     8.015    24.715     0.200
     8.061    25.620     0.200
     8.085    24.912     0.200
     8.180    25.464     0.200
     8.289    24.470     0.200
     8.339    22.813     0.200
     8.499    26.267     0.200
     8.560    27.003     0.200
     8.813    24.381     0.200
     8.862    25.185     0.200
     8.862    25.486     0.200
     9.063    26.362     0.200
     9.667    29.740     0.200
     9.772    27.682     0.200
     9.973    30.639     0.200
    10.050    30.532     0.200
    10.286    28.397     0.200
    10.286    28.689     0.200
    10.577    28.954     0.200
    10.648    28.685     0.200
    10.675    29.030     0.200
    10.747    28.402     0.200
    10.842    28.908     0.200
    10.877    30.168     0.200
    10.899    30.043     0.200
    11.020    28.650     0.200
    11.004    30.460     0.200
    11.086    30.898     0.200
    11.123    30.636     0.200
    11.252    30.896     0.200
    11.248    29.565     0.200
    11.269    29.202     0.200
    11.330    30.957     0.200
    11.281    31.211     0.200
    11.354    30.907     0.200
    11.346    31.201     0.200
    11.410    30.964     0.200
    11.452    30.967     0.200
    11.483    32.074     0.200
    11.483    33.926     0.200
    11.523    35.606     0.200
    11.524    35.916     0.200
    11.477    31.104     0.200
    11.518    30.974     0.200
    11.532    31.352     0.200
    11.602    31.483     0.200
    11.602    32.846     0.200
    11.719    30.113     0.200
    11.672    31.977     0.200
    11.895    32.521     0.200
    11.962    34.915     0.200
    11.939    33.305     0.200
    11.941    32.585     0.200
    11.945    32.239     0.200
    11.980    33.328     0.200
    12.020    31.693     0.200
    12.030    32.485     0.200
    12.135    31.880     0.200
    12.133    32.596     0.200
    12.119    33.057     0.200
    12.287    36.911     0.200
    12.288    32.563     0.200
    12.314    33.229     0.200
    12.385    33.623     0.200
    12.423    37.699     0.200
    12.489    33.057     0.200
    12.515    32.760     0.200
    12.549    32.858     0.200
    12.561    32.239     0.200
    12.531    33.400     0.200
    12.546    32.587     0.200
    12.567    33.416     0.200
    12.570    33.407     0.200
    12.588    33.578     0.200
    12.628    33.295     0.200
    12.615    32.919     0.200
    12.653    34.125     0.200
    12.685    33.804     0.200
    12.720    33.624     0.200
    12.782    33.490     0.200
    12.782    33.084     0.200
    12.789    33.407     0.200
    12.856    32.966     0.200
    12.844    34.347     0.200
    12.875    33.501     0.200
    12.880    33.615     0.200
    12.976    32.716     0.200
    13.039    33.479     0.200
    13.036    33.904     0.200
    13.109    38.706     0.200
    13.058    34.123     0.200
    13.080    34.071     0.200
    13.126    34.276     0.200
    13.145    33.444     0.200
    13.160    33.404     0.200
    13.182    33.883     0.200
    13.233    32.806     0.200
    13.187    33.628     0.200
    13.189    34.334     0.200
    13.245    34.593     0.200
    13.236    34.654     0.200
    13.251    36.339     0.200
    13.251    34.870     0.200
    13.275    33.762     0.200
    13.277    34.073     0.200
    13.335    34.696     0.200
    13.359    33.950     0.200
    13.371    34.346     0.200
    13.392    34.128     0.200
    13.410    34.278     0.200
    13.421    33.802     0.200
    13.483    39.204     0.200
    13.456    34.466     0.200
    13.483    35.577     0.200
    13.498    34.082     0.200
    13.571    34.036     0.200
    13.549    35.864     0.200
    13.614    34.764     0.200
    13.646    35.272     0.200
    13.693    39.030     0.200
    13.705    39.325     0.200
    13.699    34.640     0.200
    13.690    35.967     0.200
    13.774    39.809     0.200
    13.750    35.517     0.200
    13.750    34.866     0.200
    13.781    35.282     0.200
    13.758    35.275     0.200
    13.795    34.296     0.200
    13.820    35.361     0.200
    13.805    35.471     0.200
    13.808    34.443     0.200
    13.810    35.197     0.200
    13.873    35.382     0.200
    13.874    35.356     0.200
    13.910    34.250     0.200
    13.952    34.954     0.200
    13.963    34.278     0.200
    13.984    36.002     0.200
    14.013    35.226     0.200
    14.009    36.114     0.200
    14.040    35.740     0.200
    14.096    35.407     0.200
    14.117    36.031     0.200
    14.155    35.561     0.200
    14.159    36.154     0.200
    14.192    34.883     0.200
    14.196    36.049     0.200
    14.220    36.046     0.200
    14.241    35.214     0.200
    14.249    36.454     0.200
    14.299    35.626     0.200
    14.395    36.728     0.200
    14.418    35.962     0.200
    14.441    36.433     0.200
    14.442    37.137     0.200
    14.513    33.805     0.200
    14.455    36.532     0.200
    14.466    36.690     0.200
    14.467    36.558     0.200
    14.497    36.865     0.200
    14.492    36.905     0.200
    14.507    36.902     0.200
    14.562    35.830     0.200
    14.586    35.634     0.200
    14.617    36.807     0.200
    14.694    36.096     0.200
    14.704    35.464     0.200
    14.696    36.185     0.200
    14.730    37.062     0.200
    14.709    37.177     0.200
    14.724    35.802     0.200
    14.731    36.707     0.200
    14.751    36.936     0.200
    14.786    36.803     0.200
    14.798    35.666     0.200
    14.824    37.126     0.200
    14.844    35.668     0.200
    14.867    35.339     0.200
    14.900    36.748     0.200
    14.894    36.372     0.200
    14.926    37.830     0.200
    15.031    35.899     0.200
    15.033    37.456     0.200
    15.078    38.023     0.200
    15.099    37.568     0.200
    15.119    37.185     0.200
    15.115    37.482     0.200
    15.137    37.871     0.200
    15.140    36.574     0.200
    15.135    37.651     0.200
    15.158    37.532     0.200
    15.206    35.932     0.200
    15.244    39.361     0.200
    15.223    37.389     0.200
    15.224    36.646     0.200
    15.208    37.389     0.200
    15.202    37.639     0.200
    15.210    37.867     0.200
    15.233    37.564     0.200
    15.330    38.633     0.200
    15.327    36.799     0.200
    15.324    37.784     0.200
    15.350    35.387     0.200
    15.345    37.469     0.200
    15.374    37.626     0.200
    15.421    37.407     0.200
    15.403    36.677     0.200
    15.430    37.411     0.200
    15.476    39.202     0.200
    15.546    37.761     0.200
    15.604    38.097     0.200
    15.617    37.961     0.200
    15.651    37.487     0.200
    15.663    36.641     0.200
    15.652    37.936     0.200
    15.688    38.090     0.200
    15.751    38.204     0.200
    15.756    38.701     0.200
    15.729    39.858     0.200
    15.763    38.673     0.200
    15.750    39.693     0.200
    15.803    38.507     0.200
    15.778    38.265     0.200
    15.793    39.675     0.200
    15.815    38.729     0.200
    15.829    37.784     0.200
    15.833    38.056     0.200
    15.827    38.265     0.200
    15.859    37.741     0.200
    15.868    37.691     0.200
    15.894    37.832     0.200
    15.904    36.739     0.200
    15.944    38.842     0.200
    15.925    37.916     0.200
    15.920    39.131     0.200
    15.947    37.832     0.200
    15.953    38.560     0.200
    15.948    38.669     0.200
    16.078    37.359     0.200
    16.100    38.745     0.200
    16.073    38.051     0.200
    16.110    38.362     0.200
    16.153    38.381     0.200
    16.201    39.034     0.200
    16.176    38.255     0.200
    16.226    39.323     0.200
    16.253    39.318     0.200
    16.273    37.807     0.200
    16.286    39.814     0.200
    16.298    39.387     0.200
    16.316    38.104     0.200
    16.392    38.772     0.200
    16.375    39.289     0.200
    16.418    38.862     0.200
    16.424    39.002     0.200
    16.423    38.996     0.200
    16.432    39.238     0.200
    16.426    38.669     0.200
    16.440    39.116     0.200
    16.477    37.780     0.200
    16.502    39.085     0.200
    16.506    39.170     0.200
    16.501    39.593     0.200
    16.508    38.663     0.200
    16.513    38.485     0.200
    16.613    38.950     0.200
    16.619    38.413     0.200
    16.631    39.514     0.200
    16.642    38.918     0.200
    16.636    39.293     0.200
    16.682    39.026     0.200
    16.690    38.710     0.200
    16.716    39.186     0.200
    16.720    38.156     0.200
    16.725    38.179     0.200
    16.734    39.350     0.200
    16.769    38.260     0.200
    16.786    38.252     0.200
    16.863    39.453     0.200
    16.875    40.520     0.200
    16.964    37.769     0.200
    16.922    40.508     0.200
    16.943    39.126     0.200
    16.986    39.535     0.200
    16.967    38.942     0.200
    16.981    40.273     0.200
    17.002    39.408     0.200
    17.007    40.345     0.200
    17.048    39.345     0.200
    17.034    39.728     0.200
    17.041    39.467     0.200
    17.080    39.731     0.200
    17.096    39.592     0.200
    17.106    39.512     0.200
    17.106    38.985     0.200
    17.125    39.335     0.200
    17.187    39.274     0.200
    17.193    39.666     0.200
    17.185    39.488     0.200
    17.225    38.965     0.200
    17.217    39.305     0.200
    17.338    38.844     0.200
    17.358    39.783     0.200
    17.402    39.664     0.200
    17.419    39.290     0.200
    17.426    39.881     0.200
    17.422    40.317     0.200
    17.463    40.121     0.200
    17.468    40.132     0.200
    17.536    40.013     0.200
    17.531    39.309     0.200
    17.565    39.722     0.200
    17.555    39.806     0.200
    17.566    39.326     0.200
    17.564    40.308     0.200
    17.600    39.924     0.200
    17.638    39.035     0.200
    17.623    39.751     0.200
    17.655    39.459     0.200
    17.660    40.278     0.200
    17.674    40.416     0.200
    17.688    40.177     0.200
    17.724    40.365     0.200
    17.712    39.633     0.200
    17.714    40.417     0.200
    17.728    40.131     0.200
    17.775    40.266     0.200
    17.808    39.219     0.200
    17.816    39.397     0.200
    17.912    39.947     0.200
    17.944    40.160     0.200
    18.031    39.628     0.200
    18.126    39.635     0.200
    18.152    39.823     0.200
    18.160    40.029     0.200
    18.158    39.940     0.200
    18.212    40.493     0.200
    18.286    40.388     0.200
    18.530    40.526     0.200
    18.577    40.493     0.200
    18.738    40.709     0.200
    18.749    40.430     0.200
    19.084    40.431     0.200
    19.106    40.994     0.200
    19.223    40.817     0.200
    19.713    40.730     0.200
    19.792    40.521     0.200
    19.825    40.478     0.200
     0.886     4.463     0.200
     0.941     4.361     0.200
     0.941     5.146     0.200
     1.195     7.205     0.200
     1.195     7.056     0.200
     1.209     6.762     0.200
     1.292     7.847     0.200
     1.477     6.358     0.200
     1.709     8.479     0.200
     1.746     7.194     0.200
     1.916     7.980     0.200
     1.972     7.883     0.200
     2.092     7.878     0.200
     2.092     8.181     0.200
     2.155     8.749     0.200
     2.314     8.761     0.200
     2.497     9.812     0.200
     2.616     9.439     0.200
     2.871    10.830     0.200
     2.891    11.480     0.200
     2.886    10.613     0.200
     3.291    11.089     0.200
     3.367    13.116     0.200
     3.725    12.969     0.200
     3.777    14.935     0.200
     4.313    14.662     0.200
     4.518    13.420     0.200
     5.459    18.048     0.200
     5.578    18.100     0.200
     6.158    19.029     0.200
     7.191    24.172     0.200
     7.847    23.187     0.200
     9.159    28.228     0.200
    10.371    29.339     0.200
     0.907     4.650     0.200
     1.126     6.950     0.200
     1.208     7.114     0.200
     1.206     7.458     0.200
     1.644     7.037     0.200
     1.624     8.174     0.200
     1.654     6.974     0.200
     1.654     6.709     0.200
     1.832     7.370     0.200
     1.909     7.793     0.200
     2.063     8.211     0.200
     2.163     7.973     0.200
     2.163     7.719     0.200
     2.542     9.279     0.200
     2.778    10.223     0.200
     2.827    10.850     0.200
     3.013    10.693     0.200
     3.062    10.030     0.200
     3.280    12.147     0.200
     3.685    12.054     0.200
     4.247    14.232     0.200
     4.288    13.734     0.200
     4.634    15.388     0.200
     5.475    16.786     0.200
     5.531    17.523     0.200
     6.088    17.958     0.200
     6.394    17.385     0.200
     6.759    23.249     0.200
     7.099    22.354     0.200
     7.493    23.327     0.200
     7.880    22.719     0.200
     7.885    24.096     0.200
     8.069    24.898     0.200
     8.475    22.358     0.200
     8.478    24.269     0.200
    11.939    29.958     0.200
    16.053    38.528     0.200
     1.055     7.690     0.200
     1.055     7.790     0.200
     1.016     6.683     0.200
     1.017     5.298     0.200
     1.017     5.913     0.200
     1.051     5.508     0.200
     1.123     8.028     0.200
     1.376     7.501     0.200
     1.757     7.752     0.200
     1.869     9.323     0.200
     1.965     7.958     0.200
     1.912     8.109     0.200
     1.912     8.228     0.200
     2.069     8.684     0.200
     2.090     8.518     0.200
     2.324    10.009     0.200
     2.752    10.174     0.200
     3.008    12.421     0.200
     3.274    14.431     0.200
     3.322    13.347     0.200
     3.431    11.975     0.200
     3.523    12.847     0.200
     3.523    13.360     0.200
     4.432    15.418     0.200
     4.547    16.331     0.200
     4.648    16.633     0.200
     4.677    16.374     0.200
     4.829    16.857     0.200
     4.963    16.738     0.200
     5.199    18.570     0.200
     5.430    18.775     0.200
     5.430    18.599     0.200
     5.663    19.167     0.200
     6.229    18.534     0.200
     6.284    19.597     0.200
     6.284    19.431     0.200
     6.870    21.687     0.200
     7.083    21.767     0.200
     7.461    22.174     0.200
     7.492    24.302     0.200
     7.492    23.248     0.200
     7.786    23.407     0.200
     7.888    25.550     0.200
     7.966    26.029     0.200
     8.092    26.120     0.200
     8.291    22.897     0.200
     8.253    23.955     0.200
     8.327    24.974     0.200
     8.666    27.245     0.200
     8.859    25.903     0.200
     9.004    25.369     0.200
     9.474    27.046     0.200
     9.721    28.633     0.200
     9.879    29.171     0.200
     9.942    29.362     0.200
    10.228    28.837     0.200
    10.541    28.287     0.200
    10.705    29.106     0.200
    10.657    29.429     0.200
    10.903    31.621     0.200
    11.347    30.441     0.200
    11.398    34.360     0.200
    12.200    37.689     0.200
    12.918    35.593     0.200
    13.027    36.500     0.200
    13.041    39.058     0.200
    13.112    36.494     0.200
    13.139    36.342     0.200
    13.183    36.792     0.200
    13.174    39.261     0.200
    13.687    39.562     0.200
    13.755    36.722     0.200
    13.763    36.563     0.200
    13.766    40.520     0.200
    14.709    36.269     0.200
    14.988    36.022     0.200
    15.452    37.630     0.200
    15.679    38.654     0.200
    15.772    38.530     0.200
    16.483    38.736     0.200
    18.177    40.508     0.200
     0.933     4.792     0.200
     1.236     7.551     0.200
     1.261     7.094     0.200
     1.261     6.985     0.200
     1.674     7.069     0.200
     1.678     8.148     0.200
     1.678     8.259     0.200
     1.715     7.172     0.200
     1.889     7.421     0.200
     1.954     7.831     0.200
     2.120     8.143     0.200
     2.594     9.412     0.200
     2.839    10.699     0.200
     2.855    10.527     0.200
     2.873    11.277     0.200
     3.073    14.439     0.200
     3.122    12.022     0.200
     3.268    10.833     0.200
     3.339    13.033     0.200
     3.395    13.797     0.200
     3.717    13.834     0.200
     3.745    14.423     0.200
     3.820    11.634     0.200
     4.294    14.596     0.200
     4.490    15.396     0.200
     4.642    15.942     0.200
     4.801    15.882     0.200
     4.801    16.735     0.200
     5.379    17.860     0.200
     5.470    17.840     0.200
     5.470    17.121     0.200
     5.566    18.072     0.200
     5.801    21.029     0.200
     6.138    18.422     0.200
     6.210    20.865     0.200
     6.360    18.139     0.200
     6.790    21.470     0.200
     7.169    20.970     0.200
     7.160    22.001     0.200
     7.265    21.246     0.200
     7.498    24.135     0.200
     7.518    21.740     0.200
     7.552    21.550     0.200
     7.750    23.075     0.200
     7.817    21.392     0.200
     7.863    22.525     0.200
     7.863    22.905     0.200
     7.909    24.393     0.200
     8.003    25.740     0.200
     8.080    24.872     0.200
     8.086    24.882     0.200
     8.436    22.696     0.200
     8.436    22.983     0.200
     8.463    25.766     0.200
    10.399    29.553     0.200
    10.400    28.948     0.200
    10.650    30.606     0.200
    13.255    35.802     0.200
    13.287    36.312     0.200
    13.339    37.532     0.200
    13.352    36.999     0.200
    13.904    37.166     0.200
     0.914     4.962     0.200
     1.001     5.225     0.200
     1.138     5.740     0.200
     1.248     6.391     0.200
     1.477     6.734     0.200
     1.519     6.628     0.200
     1.598     7.901     0.200
     1.598     9.122     0.200
     1.863     9.240     0.200
     1.864     9.367     0.200
     1.941     7.862     0.200
     1.955     8.303     0.200
     1.985     8.082     0.200
     2.114     8.383     0.200
     2.149    10.065     0.200
     2.195    10.827     0.200
     2.332     9.484     0.200
     2.527     9.505     0.200
     2.571     9.405     0.200
     2.614     9.875     0.200
     2.840     9.078     0.200
     2.852    11.316     0.200
     2.964     9.940     0.200
     3.042    10.317     0.200
     3.248    11.953     0.200
     3.265    11.350     0.200
     3.421    11.529     0.200
     3.469    11.551     0.200
     3.469    11.676     0.200
     3.655    12.098     0.200
     3.702    12.891     0.200
     3.964    13.213     0.200
     4.085    13.786     0.200
     4.085    13.590     0.200
     4.278    14.272     0.200
     4.433    13.044     0.200
     4.658    15.400     0.200
     4.658    15.556     0.200
     4.953    16.034     0.200
     5.093    17.078     0.200
     5.153    17.173     0.200
     5.375    18.340     0.200
     5.457    17.018     0.200
     5.488    17.200     0.200
     5.667    17.892     0.200
     5.867    17.377     0.200
     5.867    18.150     0.200
     6.439    23.045     0.200
     6.562    20.977     0.200
     6.929    19.256     0.200
     6.929    19.131     0.200
     7.525    24.063     0.200
     7.545    22.159     0.200
     7.621    22.724     0.200
     7.652    24.605     0.200
     7.664    26.372     0.200
     7.894    21.545     0.200
     7.894    22.138     0.200
     7.896    24.262     0.200
     7.925    24.836     0.200
     7.929    22.107     0.200
     7.946    22.148     0.200
     8.021    24.912     0.200
     8.195    25.198     0.200
     8.198    23.572     0.200
     8.198    23.962     0.200
     8.895    27.463     0.200
     9.061    23.801     0.200
     9.061    23.989     0.200
     9.843    26.870     0.200
     9.863    26.857     0.200
    11.107    33.047     0.200
    11.119    33.501     0.200
    11.135    28.779     0.200
    11.136    29.183     0.200
    12.447    34.832     0.200
    12.750    36.937     0.200
    15.412    39.131     0.200
    18.727    41.760     0.200
    20.793    40.560     0.200
     1.090     5.678     0.200
     1.177     5.935     0.200
     1.178     7.128     0.200
     1.176     7.309     0.200
     1.265     6.324     0.200
     1.420     6.639     0.200
     1.548     7.075     0.200
     1.574     7.449     0.200
     1.560     8.871     0.200
     1.642     7.469     0.200
     1.931     8.688     0.200
     2.175     8.565     0.200
     2.284     8.746     0.200
     2.289     9.088     0.200
     2.379     9.601     0.200
     2.385    10.861     0.200
     2.571     9.252     0.200
     2.571     9.109     0.200
     2.950    10.368     0.200
     3.196    14.882     0.200
     3.744    12.418     0.200
     4.209    13.189     0.200
     4.661    15.655     0.200
     4.661    16.301     0.200
     4.796    13.809     0.200
     5.212    17.496     0.200
     5.281    21.853     0.200
     5.321    18.094     0.200
     5.604    17.832     0.200
     5.604    18.762     0.200
     6.586    22.709     0.200
     6.727    19.348     0.200
     7.531    24.051     0.200
     7.713    26.957     0.200
     7.790    22.538     0.200
     7.988    25.463     0.200
     8.041    25.484     0.200
     8.060    26.199     0.200
     8.088    24.207     0.200
     8.839    23.191     0.200
     8.931    26.543     0.200
    10.952    31.757     0.200
     0.940     5.284     0.200
     0.940     4.807     0.200
     1.241     7.723     0.200
     1.276     7.495     0.200
     1.276     7.143     0.200
     1.308     8.009     0.200
     1.308     7.857     0.200
     1.469     6.548     0.200
     1.693     8.924     0.200
     1.681     7.371     0.200
     1.731     7.087     0.200
     1.731     7.279     0.200
     1.966     7.922     0.200
     2.140     8.987     0.200
     2.108     8.123     0.200
     2.108     7.916     0.200
     2.314     9.551     0.200
     2.483    10.461     0.200
     2.608    10.013     0.200
     2.630    10.447     0.200
     2.777    10.364     0.200
     2.856    10.817     0.200
     2.905    11.483     0.200
     3.089    13.851     0.200
     3.138    11.206     0.200
     3.355    13.175     0.200
     3.762    14.657     0.200
     3.810    11.505     0.200
     4.307    14.864     0.200
     4.365    14.210     0.200
     4.505    15.452     0.200
     4.644    16.186     0.200
     4.815    16.103     0.200
     5.073    16.832     0.200
     5.386    17.742     0.200
     5.525    21.271     0.200
     5.575    18.216     0.200
     5.746    19.651     0.200
     5.786    18.724     0.200
     6.151    18.905     0.200
     6.216    21.301     0.200
     6.355    22.982     0.200
     6.350    18.399     0.200
     6.698    19.849     0.200
     6.798    20.903     0.200
     6.838    23.409     0.200
     6.824    21.763     0.200
     7.163    21.289     0.200
     7.258    21.963     0.200
     7.499    22.316     0.200
     7.512    21.847     0.200
     7.546    21.195     0.200
     7.753    26.845     0.200
     7.824    22.111     0.200
     7.858    23.188     0.200
     7.915    23.105     0.200
     8.050    25.522     0.200
     8.082    25.527     0.200
     8.089    25.686     0.200
     8.147    25.835     0.200
     8.171    25.203     0.200
     8.233    23.191     0.200
     8.347    27.902     0.200
     8.373    28.548     0.200
     8.425    22.722     0.200
     8.469    26.265     0.200
     8.538    24.060     0.200
     8.875    25.990     0.200
     8.904    28.155     0.200
     8.948    28.669     0.200
     9.172    29.451     0.200
     9.658    28.625     0.200
     9.776    30.373     0.200
     9.704    29.850     0.200
     9.755    29.719     0.200
     9.749    27.698     0.200
     9.779    28.484     0.200
     9.857    30.211     0.200
    10.219    29.655     0.200
    10.386    29.140     0.200
    10.387    28.853     0.200
    10.490    33.362     0.200
    10.568    33.801     0.200
    10.642    31.296     0.200
    10.901    32.190     0.200
    11.064    33.633     0.200
    11.221    34.233     0.200
    11.221    35.151     0.200
    11.215    35.174     0.200
    11.375    34.974     0.200
    11.431    35.513     0.200
    11.475    33.783     0.200
    11.490    32.490     0.200
    11.490    31.695     0.200
    11.661    31.569     0.200
    11.688    33.895     0.200
    11.983    34.578     0.200
    12.022    34.832     0.200
    12.336    37.384     0.200
    12.406    35.918     0.200
    12.539    32.821     0.200
    12.742    38.462     0.200
    12.761    37.928     0.200
    12.907    37.993     0.200
    13.222    37.998     0.200
    13.318    39.125     0.200
    13.341    37.254     0.200
    13.590    39.294     0.200
    13.734    37.734     0.200
    14.818    39.249     0.200
    14.884    38.861     0.200
    15.112    39.291     0.200
    15.171    38.914     0.200
    15.260    38.797     0.200
    18.646    43.455     0.200
    20.486    41.717     0.200
    20.968    39.818     0.200
     0.933     4.819     0.200
     0.933     5.254     0.200
     1.055     5.303     0.200
     1.102     5.406     0.200
     1.180     7.310     0.200
     1.183     7.219     0.200
     1.196     7.172     0.200
     1.190     7.488     0.200
     1.341     8.027     0.200
     1.360     6.270     0.200
     1.494     7.008     0.200
     1.551     6.819     0.200
     1.600     8.658     0.200
     1.612     7.078     0.200
     1.806     9.193     0.200
     1.855     8.357     0.200
     1.869     9.351     0.200
     2.022     9.662     0.200
     2.059     9.891     0.200
     2.139     8.322     0.200
     2.220     8.499     0.200
     2.317    10.327     0.200
     2.425    10.902     0.200
     2.474    10.941     0.200
     2.499    10.294     0.200
     2.627    11.355     0.200
     2.642     8.888     0.200
     2.642     8.650     0.200
     2.766    11.687     0.200
     2.773     9.537     0.200
     3.256    12.889     0.200
     3.518    11.943     0.200
     3.673    11.849     0.200
     3.727    12.049     0.200
     3.727    14.207     0.200
     3.765    14.227     0.200
     3.890    13.356     0.200
     4.273    12.636     0.200
     4.308    15.581     0.200
     4.522    14.598     0.200
     4.674    15.743     0.200
     4.674    16.063     0.200
     5.294    17.696     0.200
     5.633    18.316     0.200
     5.633    18.462     0.200
     5.695    18.417     0.200
     6.565    23.893     0.200
     6.661    21.382     0.200
     6.786    19.291     0.200
     7.462    22.120     0.200
     7.545    23.922     0.200
     7.545    22.902     0.200
     7.618    23.239     0.200
     7.753    24.027     0.200
     7.836    22.353     0.200
     7.858    22.524     0.200
     7.955    25.276     0.200
     8.043    25.058     0.200
     8.066    26.081     0.200
     8.128    23.787     0.200
     8.902    24.086     0.200
     8.947    25.951     0.200
     8.947    26.371     0.200
    11.002    32.720     0.200
     1.177     8.378     0.200
     1.178     8.382     0.200
     1.224     7.458     0.200
     1.224     7.618     0.200
     1.216     8.221     0.200
     1.278     8.308     0.200
     1.434     6.913     0.200
     1.456     8.084     0.200
     1.640     8.655     0.200
     1.681     7.494     0.200
     1.861     8.712     0.200
     1.938     8.948     0.200
     2.086     9.209     0.200
     2.154     8.597     0.200
     2.303     9.673     0.200
     2.572    10.412     0.200
     2.852    10.818     0.200
     3.036    13.506     0.200
     3.084    13.832     0.200
     3.708    11.591     0.200
     3.852    12.047     0.200
     4.276    15.059     0.200
     4.651    15.586     0.200
     4.651    16.852     0.200
     5.487    17.737     0.200
     6.391    18.706     0.200
     6.654    22.411     0.200
     6.784    19.110     0.200
     7.193    21.499     0.200
     7.509    23.615     0.200
     7.577    21.501     0.200
     7.886    23.552     0.200
     8.469    23.171     0.200
    10.436    29.296     0.200
    13.386    36.079     0.200
     1.027     5.362     0.200
     1.027     5.463     0.200
     1.099     5.681     0.200
     1.099     5.501     0.200
     1.120     5.574     0.200
     1.393     6.454     0.200
     1.456     7.142     0.200
     1.603     8.807     0.200
     1.604     8.371     0.200
     1.639     7.370     0.200
     1.680     7.359     0.200
     1.850     8.579     0.200
     1.828     7.744     0.200
     2.185     8.547     0.200
     2.239    10.206     0.200
     2.245     8.806     0.200
     2.716     9.372     0.200
     2.716     9.528     0.200
     2.787    10.299     0.200
     2.785    10.273     0.200
     2.850    10.594     0.200
     3.012    11.557     0.200
     3.217    11.221     0.200
     3.488    12.346     0.200
     3.679    12.182     0.200
     3.710    12.239     0.200
     3.942    13.881     0.200
     4.160    14.432     0.200
     4.356    13.430     0.200
     4.852    16.682     0.200
     4.919    16.405     0.200
     5.345    17.150     0.200
     5.363    17.934     0.200
     5.738    18.305     0.200
     5.727    18.651     0.200
     6.544    20.402     0.200
     6.638    20.191     0.200
     6.873    19.904     0.200
     8.154    23.926     0.200
     0.939     4.751     0.200
     0.939     4.869     0.200
     1.172     6.616     0.200
     1.415     6.804     0.200
     1.457     6.499     0.200
     1.672     8.286     0.200
     1.713     7.254     0.200
     1.889     7.592     0.200
     1.957     8.043     0.200
     2.127     8.083     0.200
     2.593     9.841     0.200
     2.876    11.409     0.200
     3.124    12.445     0.200
     3.270    11.016     0.200
     3.339    10.928     0.200
     3.494    12.095     0.200
     3.828    11.368     0.200
     3.828    11.571     0.200
     3.916    13.498     0.200
     4.297    14.032     0.200
     4.650    16.050     0.200
     4.650    15.862     0.200
     4.898    16.714     0.200
     5.044    16.106     0.200
     5.191    16.544     0.200
     5.478    17.677     0.200
     5.478    17.576     0.200
     5.542    16.681     0.200
     5.571    17.447     0.200
     5.781    21.922     0.200
     6.140    18.345     0.200
     6.140    18.540     0.200
     6.363    22.603     0.200
     6.368    17.985     0.200
     6.795    19.588     0.200
     7.177    21.296     0.200
     7.273    21.898     0.200
     7.506    23.297     0.200
     7.527    21.397     0.200
     7.560    21.584     0.200
     7.872    22.629     0.200
     8.444    22.890     0.200
     8.444    22.343     0.200
     8.883    25.471     0.200
     8.883    25.963     0.200
    10.406    29.012     0.200
    10.658    32.837     0.200
     1.035     5.311     0.200
     1.035     5.151     0.200
     1.082     5.567     0.200
     1.334     8.508     0.200
     1.358     8.531     0.200
     1.395     8.107     0.200
     1.408     7.669     0.200
     1.418     8.651     0.200
     1.480     8.638     0.200
     1.480     7.896     0.200
     1.640     7.310     0.200
     1.773     7.555     0.200
     1.899     9.847     0.200
     1.944     8.221     0.200
     1.944     7.971     0.200
     1.942     7.715     0.200
     1.942     7.567     0.200
     2.099     8.834     0.200
     2.113     8.633     0.200
     2.356     9.980     0.200
     2.396     9.699     0.200
     2.695    10.831     0.200
     2.751    10.680     0.200
     2.779    10.494     0.200
     2.970    10.842     0.200
     3.032    12.180     0.200
     3.072    12.033     0.200
     3.111    12.280     0.200
     3.245    12.239     0.200
     3.306    13.492     0.200
     3.354    14.488     0.200
     3.458    12.125     0.200
     3.501    11.768     0.200
     3.553    11.704     0.200
     3.553    12.430     0.200
     3.665    12.341     0.200
     3.665    10.927     0.200
     3.729    12.552     0.200
     3.921    12.519     0.200
     3.926    16.899     0.200
     3.974    12.968     0.200
     3.978    13.543     0.200
     3.978    14.527     0.200
     4.052    13.972     0.200
     4.456    15.215     0.200
     4.474    14.634     0.200
     4.579    15.101     0.200
     4.579    14.031     0.200
     4.654    15.395     0.200
     4.651    16.347     0.200
     4.651    15.988     0.200
     4.674    14.795     0.200
     4.674    14.193     0.200
     4.708    14.659     0.200
     4.990    16.617     0.200
     5.037    16.668     0.200
     5.231    17.340     0.200
     5.289    17.524     0.200
     5.317    18.285     0.200
     5.317    18.633     0.200
     5.426    18.062     0.200
     5.426    17.921     0.200
     5.471    18.549     0.200
     5.517    17.516     0.200
     5.632    18.648     0.200
     6.210    17.896     0.200
     6.210    17.708     0.200
     6.309    19.565     0.200
     6.309    19.397     0.200
     6.895    21.571     0.200
     7.054    20.275     0.200
     7.071    21.470     0.200
     7.448    21.656     0.200
     7.494    22.835     0.200
     7.775    21.545     0.200
     7.775    22.186     0.200
     8.113    24.832     0.200
     8.269    22.865     0.200
     8.269    22.405     0.200
     8.346    26.332     0.200
     8.858    26.172     0.200
     8.964    28.817     0.200
     8.964    26.227     0.200
     9.104    25.699     0.200
     9.714    29.051     0.200
     9.718    28.539     0.200
     9.718    26.980     0.200
     9.795    30.707     0.200
     9.959    27.083     0.200
    10.168    31.094     0.200
    10.202    28.329     0.200
    10.526    30.874     0.200
    10.526    29.156     0.200
    10.647    30.768     0.200
    10.687    29.953     0.200
    10.752    33.245     0.200
    10.812    32.067     0.200
    10.906    31.662     0.200
    10.906    31.076     0.200
    11.118    33.685     0.200
    11.167    31.666     0.200
    11.214    32.678     0.200
    11.372    33.649     0.200
    11.429    34.683     0.200
    11.498    33.624     0.200
    11.517    34.569     0.200
    11.517    34.995     0.200
    11.557    32.662     0.200
    11.557    30.217     0.200
    11.574    33.729     0.200
    11.574    31.935     0.200
    11.790    32.527     0.200
    12.046    34.311     0.200
    12.173    35.507     0.200
    12.230    36.526     0.200
    12.282    33.993     0.200
    12.303    36.301     0.200
    12.303    34.258     0.200
    12.461    35.307     0.200
    12.481    35.425     0.200
    12.510    34.906     0.200
    12.549    34.826     0.200
    12.589    34.980     0.200
    12.589    33.538     0.200
    12.756    34.932     0.200
    12.757    34.677     0.200
    12.835    35.041     0.200
    12.835    33.189     0.200
    12.867    36.825     0.200
    13.061    37.433     0.200
    13.072    37.598     0.200
    13.083    36.874     0.200
    13.083    33.049     0.200
    13.177    36.284     0.200
    13.177    34.542     0.200
    13.335    36.086     0.200
    13.376    36.043     0.200
    13.448    36.038     0.200
    13.568    36.424     0.200
    13.606    37.587     0.200
    13.624    37.157     0.200
    13.667    37.098     0.200
    13.697    36.677     0.200
    13.733    35.944     0.200
    13.750    36.517     0.200
    13.750    34.932     0.200
    13.741    35.685     0.200
    13.743    35.881     0.200
    13.830    35.476     0.200
    13.817    35.910     0.200
    13.831    35.306     0.200
    13.908    36.749     0.200
    13.930    37.064     0.200
    13.946    35.768     0.200
    13.960    37.071     0.200
    13.974    36.479     0.200
    14.003    36.996     0.200
    14.044    37.147     0.200
    14.036    37.558     0.200
    14.087    37.003     0.200
    14.076    37.487     0.200
    14.105    36.918     0.200
    14.172    37.636     0.200
    14.178    37.801     0.200
    14.203    36.392     0.200
    14.267    37.072     0.200
    14.374    37.041     0.200
    14.391    37.269     0.200
    14.392    36.430     0.200
    14.415    36.906     0.200
    14.404    37.057     0.200
    14.412    37.530     0.200
    14.418    38.023     0.200
    14.421    36.664     0.200
    14.421    37.643     0.200
    14.455    36.919     0.200
    14.447    40.060     0.200
    14.560    36.915     0.200
    14.606    37.423     0.200
    14.659    37.839     0.200
    14.677    37.528     0.200
    14.720    36.987     0.200
    14.764    37.048     0.200
    14.778    36.985     0.200
    14.778    36.610     0.200
    14.819    36.900     0.200
    14.843    36.984     0.200
    14.859    36.453     0.200
    14.859    35.465     0.200
    14.922    37.572     0.200
    14.968    38.596     0.200
    14.968    36.503     0.200
    14.970    38.149     0.200
    15.007    39.185     0.200
    15.050    39.436     0.200
    15.069    38.258     0.200
    15.073    38.039     0.200
    15.073    37.438     0.200
    15.087    37.957     0.200
    15.083    38.492     0.200
    15.089    39.050     0.200
    15.115    37.222     0.200
    15.136    39.488     0.200
    15.133    36.566     0.200
    15.158    37.610     0.200
    15.169    39.832     0.200
    15.244    38.580     0.200
    15.273    37.441     0.200
    15.319    37.787     0.200
    15.357    37.399     0.200
    15.351    37.779     0.200
    15.394    38.656     0.200
    15.427    38.053     0.200
    15.445    38.242     0.200
    15.499    38.718     0.200
    15.550    38.149     0.200
    15.569    38.194     0.200
    15.608    38.906     0.200
    15.654    39.178     0.200
    15.642    40.347     0.200
    15.666    39.643     0.200
    15.679    40.369     0.200
    15.717    39.474     0.200
    15.716    40.546     0.200
    15.750    40.082     0.200
    15.750    40.153     0.200
    15.767    39.684     0.200
    15.780    39.098     0.200
    15.769    39.480     0.200
    15.793    39.306     0.200
    15.797    39.464     0.200
    15.854    38.455     0.200
    15.864    39.018     0.200
    15.867    38.797     0.200
    15.875    39.324     0.200
    15.898    39.682     0.200
    15.899    39.399     0.200
    15.927    39.170     0.200
    15.970    39.736     0.200
    16.026    39.279     0.200
    16.067    38.906     0.200
    16.073    39.045     0.200
    16.141    39.788     0.200
    16.141    40.480     0.200
    16.172    40.221     0.200
    16.190    39.462     0.200
    16.213    40.881     0.200
    16.256    39.542     0.200
    16.280    38.670     0.200
    16.292    39.219     0.200
    16.332    39.398     0.200
    16.340    40.483     0.200
    16.362    40.430     0.200
    16.362    39.879     0.200
    16.373    39.947     0.200
    16.399    40.181     0.200
    16.452    39.825     0.200
    16.469    40.546     0.200
    16.469    39.898     0.200
    16.474    39.768     0.200
    16.474    40.752     0.200
    16.470    39.602     0.200
    16.592    39.919     0.200
    16.591    40.635     0.200
    16.595    39.736     0.200
    16.599    39.677     0.200
    16.661    40.624     0.200
    16.669    39.722     0.200
    16.674    39.977     0.200
    16.683    41.066     0.200
    16.735    38.845     0.200
    16.732    40.426     0.200
    16.791    40.632     0.200
    16.812    41.250     0.200
    16.805    41.218     0.200
    16.858    41.120     0.200
    16.855    40.416     0.200
    16.886    40.741     0.200
    16.925    40.424     0.200
    16.940    39.877     0.200
    16.944    40.244     0.200
    16.969    40.135     0.200
    16.990    40.625     0.200
    17.017    40.557     0.200
    17.084    40.031     0.200
    17.120    40.910     0.200
    17.135    40.293     0.200
    17.170    39.855     0.200
    17.178    41.012     0.200
    17.187    40.505     0.200
    17.323    40.749     0.200
    17.357    40.605     0.200
    17.357    38.680     0.200
    17.365    40.491     0.200
    17.386    40.946     0.200
    17.400    41.053     0.200
    17.415    40.758     0.200
    17.498    41.142     0.200
    17.554    41.311     0.200
    17.567    41.224     0.200
    17.579    40.840     0.200
    17.656    41.318     0.200
    17.717    41.333     0.200
    17.721    41.518     0.200
    17.793    40.926     0.200
    17.838    41.278     0.200
    17.840    40.838     0.200
    17.928    40.788     0.200
    18.052    41.505     0.200
    18.088    41.482     0.200
    18.093    41.584     0.200
    18.129    40.765     0.200
    18.139    40.734     0.200
    18.161    40.719     0.200
    18.199    41.315     0.200
    18.197    41.304     0.200
    18.253    40.681     0.200
    18.311    41.527     0.200
    18.368    40.741     0.200
    18.387    41.325     0.200
    18.411    41.098     0.200
    18.521    42.029     0.200
    18.561    41.777     0.200
    18.742    42.112     0.200
    18.746    42.282     0.200
    18.752    41.846     0.200
    18.774    41.830     0.200
    18.763    42.198     0.200
    18.886    41.703     0.200
    18.898    41.989     0.200
    18.974    42.683     0.200
    18.999    41.474     0.200
    19.025    42.121     0.200
    19.067    42.327     0.200
    19.088    41.609     0.200
    19.143    42.372     0.200
    19.217    42.372     0.200
    19.249    42.089     0.200
    19.258    41.626     0.200
    19.285    41.917     0.200
    19.344    41.547     0.200
    19.481    42.333     0.200
    19.503    42.105     0.200
    19.699    41.950     0.200
    19.699    41.711     0.200
    19.732    42.149     0.200
    19.820    41.660     0.200
    20.666    41.066     0.200
    20.722    40.924     0.200
    20.728    41.517     0.200
    20.788    41.670     0.200
    20.809    41.414     0.200
     0.931     4.669     0.200
     0.973     4.939     0.200
     1.249     7.050     0.200
     1.248     6.647     0.200
     1.323     7.606     0.200
     1.325     7.229     0.200
     1.325     7.487     0.200
     1.521     6.579     0.200
     1.548     8.157     0.200
     1.556     7.941     0.200
     1.599     7.133     0.200
     1.622     7.292     0.200
     1.671     8.386     0.200
     1.715     7.597     0.200
     1.715     7.167     0.200
     1.715     7.019     0.200
     1.743     8.444     0.200
     1.743     8.413     0.200
     1.771     7.908     0.200
     1.790     7.223     0.200
     1.790     6.918     0.200
     1.790     7.325     0.200
     1.820     8.005     0.200
     1.824     8.607     0.200
     1.841     8.059     0.200
     1.961     7.695     0.200
     2.013     8.001     0.200
     2.074     8.228     0.200
     2.071     7.960     0.200
     2.109     8.962     0.200
     2.116     8.927     0.200
     2.155     8.993     0.200
     2.196     8.926     0.200
     2.346     8.901     0.200
     2.493     9.242     0.200
     2.597     9.855     0.200
     2.660     9.605     0.200
     2.671     9.851     0.200
     2.833    10.272     0.200
     2.914    10.677     0.200
     2.913    10.791     0.200
     2.914    10.981     0.200
     2.932    11.113     0.200
     2.955    10.727     0.200
     3.008    11.748     0.200
     3.146    11.798     0.200
     3.160    11.084     0.200
     3.341    12.298     0.200
     3.336    10.832     0.200
     3.412    11.996     0.200
     3.412    12.894     0.200
     3.468    12.539     0.200
     3.761    12.408     0.200
     3.776    12.218     0.200
     3.776    13.765     0.200
     3.781    11.177     0.200
     3.781    11.380     0.200
     3.818    13.705     0.200
     3.818    15.338     0.200
     3.901    13.621     0.200
     3.910    13.279     0.200
     4.127    13.785     0.200
     4.223    14.032     0.200
     4.330    14.247     0.200
     4.355    14.806     0.200
     4.392    14.695     0.200
     4.423    14.120     0.200
     4.423    14.269     0.200
     4.563    15.217     0.200
     4.658    15.900     0.200
     4.658    15.713     0.200
     4.834    14.882     0.200
     4.868    15.657     0.200
     4.868    16.063     0.200
     4.880    16.100     0.200
     5.151    17.137     0.200
     5.418    18.033     0.200
     5.468    17.450     0.200
     5.468    17.801     0.200
     5.614    18.098     0.200
     5.814    19.531     0.200
     6.201    18.599     0.200
     6.323    17.934     0.200
     6.323    17.824     0.200
     6.398    21.518     0.200
     6.755    19.626     0.200
     6.832    22.309     0.200
     7.150    21.239     0.200
     7.215    22.244     0.200
     7.242    21.352     0.200
     7.242    21.493     0.200
     7.496    21.778     0.200
     7.510    23.187     0.200
     7.510    23.429     0.200
     7.531    21.596     0.200
     7.771    26.391     0.200
     7.848    22.532     0.200
     7.848    22.985     0.200
     7.856    23.764     0.200
     7.943    24.100     0.200
     8.025    24.396     0.200
     8.070    25.082     0.200
     8.098    25.403     0.200
     8.107    25.357     0.200
     8.178    25.005     0.200
     8.208    26.585     0.200
     8.273    26.855     0.200
     8.393    22.668     0.200
     8.498    25.618     0.200
     8.587    23.422     0.200
     8.587    24.429     0.200
     8.883    25.624     0.200
     8.883    25.944     0.200
     8.946    24.925     0.200
     8.979    24.659     0.200
     9.718    29.690     0.200
     9.719    28.446     0.200
     9.777    28.084     0.200
     9.777    29.748     0.200
     9.820    27.716     0.200
     9.895    26.825     0.200
    10.218    32.334     0.200
    10.344    28.545     0.200
    10.345    29.114     0.200
    10.623    31.184     0.200
    10.622    33.047     0.200
    10.915    30.517     0.200
    10.915    31.634     0.200
    11.102    32.757     0.200
    11.265    34.155     0.200
    11.279    33.815     0.200
    11.279    32.940     0.200
    11.421    34.329     0.200
    11.493    32.132     0.200
    11.524    32.226     0.200
    11.524    32.194     0.200
    11.524    30.920     0.200
    11.726    33.745     0.200
    11.843    33.608     0.200
    12.021    32.865     0.200
    12.117    33.427     0.200
    12.564    30.155     0.200
    12.768    37.320     0.200
    12.947    33.635     0.200
    12.970    38.261     0.200
    13.015    36.476     0.200
    13.081    33.691     0.200
    13.195    33.071     0.200
    13.306    36.053     0.200
    13.361    37.978     0.200
    13.732    36.539     0.200
    13.771    36.993     0.200
    13.771    37.477     0.200
    13.832    39.184     0.200
    13.859    35.257     0.200
    13.899    39.912     0.200
    14.161    34.385     0.200
    14.714    36.877     0.200
    14.841    36.251     0.200
    14.841    36.454     0.200
    14.906    36.232     0.200
    15.426    38.027     0.200
    15.948    38.251     0.200
    15.970    37.518     0.200
    16.095    38.990     0.200
    16.095    39.771     0.200
    16.161    39.125     0.200
    16.168    39.400     0.200
    16.403    39.390     0.200
    16.555    38.993     0.200
    16.674    39.784     0.200
    16.726    39.775     0.200
    16.776    39.530     0.200
    16.790    39.966     0.200
    17.101    39.233     0.200
    17.810    39.325     0.200
    17.813    39.665     0.200
    18.258    40.065     0.200
    18.582    40.912     0.200
    18.656    40.990     0.200
    18.656    42.709     0.200
    18.740    40.410     0.200
    18.740    40.682     0.200
    18.794    40.429     0.200
     0.909     4.962     0.200
     1.160     6.132     0.200
     1.249     7.683     0.200
     1.249     7.523     0.200
     1.257     7.246     0.200
     1.257     7.135     0.200
     1.259     7.730     0.200
     1.295     5.921     0.200
     1.288     7.101     0.200
     1.346     8.252     0.200
     1.346     7.742     0.200
     1.347     7.818     0.200
     1.347     8.308     0.200
     1.394     8.348     0.200
     1.448     8.400     0.200
     1.481     6.595     0.200
     1.630     6.632     0.200
     1.695     7.972     0.200
     1.757     7.184     0.200
     1.777     7.348     0.200
     2.060     7.853     0.200
     2.081     8.285     0.200
     2.375     9.339     0.200
     2.433     9.366     0.200
     2.435     9.205     0.200
     2.900    10.401     0.200
     3.730    11.578     0.200
     4.370    13.202     0.200
     4.458    15.014     0.200
     5.969    18.208     0.200
     6.262    18.201     0.200
     6.553    21.003     0.200
     7.067    22.668     0.200
     7.317    22.731     0.200
     7.719    24.028     0.200
     7.719    21.428     0.200
     8.353    24.750     0.200
     8.355    21.515     0.200
     9.559    26.714     0.200
    10.357    28.664     0.200
    10.529    29.621     0.200
    11.290    32.694     0.200
     1.227     7.449     0.200
     1.253     7.101     0.200
     1.296     5.936     0.200
     1.333     8.137     0.200
     1.334     8.116     0.200
     1.334     8.475     0.200
     1.358     8.100     0.200
     1.411     8.147     0.200
     1.502     6.418     0.200
     1.611     6.268     0.200
     1.611     6.533     0.200
     1.611     6.377     0.200
     1.661     7.723     0.200
     1.749     6.776     0.200
     1.786     7.114     0.200
     2.055     8.245     0.200
     2.096     7.764     0.200
     2.136     7.739     0.200
     2.436     8.630     0.200
     2.447     9.289     0.200
     2.621     9.450     0.200
     2.756     9.668     0.200
     2.859    10.558     0.200
     2.867    10.540     0.200
     3.113     9.948     0.200
     3.204    10.354     0.200
     3.403    11.738     0.200
     3.626    12.025     0.200
     3.767    10.995     0.200
     4.490    15.300     0.200
     4.572    14.964     0.200
     4.976    14.646     0.200
     5.339    17.186     0.200
     5.974    17.214     0.200
     5.974    17.464     0.200
     6.300    17.686     0.200
     6.300    17.999     0.200
     6.545    19.505     0.200
     6.743    22.752     0.200
     7.350    23.027     0.200
     7.923    24.636     0.200
     7.926    24.682     0.200
     8.051    23.662     0.200
     8.360    27.511     0.200
     8.360    26.206     0.200
     8.392    22.142     0.200
     9.546    27.234     0.200
     9.675    28.058     0.200
    10.392    28.117     0.200
    10.567    30.835     0.200
    11.038    32.216     0.200
    11.085    32.368     0.200
    11.194    33.230     0.200
    11.311    35.017     0.200
    11.574    31.044     0.200
    11.802    31.901     0.200
    13.315    35.237     0.200
    14.546    35.845     0.200
    15.064    37.017     0.200
     0.853     5.983     0.200
     1.057     5.386     0.200
     1.167     5.657     0.200
     1.167     5.516     0.200
     1.278     6.791     0.200
     1.397     6.350     0.200
     1.511     6.695     0.200
     1.577     7.061     0.200
     1.584     8.611     0.200
     1.584     8.140     0.200
     1.585     8.729     0.200
     1.585     8.190     0.200
     1.608     7.042     0.200
     1.655     7.333     0.200
     1.921     8.456     0.200
     2.332     8.982     0.200
     2.406    10.055     0.200
     2.505    10.688     0.200
     2.552     8.919     0.200
     2.629     9.721     0.200
     2.823    10.352     0.200
     2.907    10.272     0.200
     3.199    13.511     0.200
     3.798    14.058     0.200
     3.963    13.163     0.200
     4.000    14.067     0.200
     4.185    13.672     0.200
     4.185    13.206     0.200
     4.341    15.170     0.200
     4.623    16.428     0.200
     4.738    16.174     0.200
     4.833    15.981     0.200
     5.176    17.252     0.200
     5.181    16.522     0.200
     5.489    18.743     0.200
     5.567    19.032     0.200
     5.568    17.917     0.200
     5.568    18.470     0.200
     6.015    20.168     0.200
     6.700    19.285     0.200
     7.385    22.403     0.200
     7.494    23.810     0.200
     7.676    23.717     0.200
     7.758    22.380     0.200
     7.890    21.320     0.200
     7.915    24.812     0.200
     7.916    24.723     0.200
     7.950    25.172     0.200
     8.022    25.489     0.200
     8.054    23.252     0.200
     8.054    23.828     0.200
     8.084    21.623     0.200
     8.277    23.569     0.200
     8.674    24.155     0.200
     8.814    23.926     0.200
     8.814    24.116     0.200
     8.894    25.829     0.200
     8.894    26.257     0.200
     9.620    28.274     0.200
     9.802    27.803     0.200
    10.767    30.896     0.200
    10.922    32.158     0.200
    10.922    33.183     0.200
     0.972     4.881     0.200
     0.998     5.048     0.200
     1.079     7.537     0.200
     1.079     7.523     0.200
     1.557     6.757     0.200
     1.739     7.017     0.200
     1.778     8.418     0.200
     1.823     7.567     0.200
     1.831     7.643     0.200
     2.047     7.890     0.200
     2.047     7.553     0.200
     3.761    13.381     0.200
     4.603    16.185     0.200
     4.668    15.593     0.200
     6.236    19.946     0.200
     6.304    17.763     0.200
     8.120    25.182     0.200
    10.608    28.960     0.200
     0.950     4.974     0.200
     0.979     4.858     0.200
     1.269     6.806     0.200
     1.262     7.756     0.200
     1.345     7.603     0.200
     1.336     7.853     0.200
     1.385     6.398     0.200
     1.535     6.724     0.200
     1.720     7.141     0.200
     1.720     7.359     0.200
     1.764     7.957     0.200
     1.803     7.549     0.200
     1.810     7.427     0.200
     1.978     7.892     0.200
     2.025     7.958     0.200
     2.053     7.875     0.200
     2.217     8.836     0.200
     2.350     8.822     0.200
     2.593    10.343     0.200
     2.675     9.420     0.200
     2.680     9.419     0.200
     3.116    11.224     0.200
     3.166    11.222     0.200
     3.167    11.802     0.200
     3.430    12.419     0.200
     3.903    13.534     0.200
     4.367    14.868     0.200
     4.444    14.611     0.200
     4.582    14.158     0.200
     4.655    15.946     0.200
     4.883    15.919     0.200
     4.927    16.481     0.200
     5.020    15.766     0.200
     5.137    16.720     0.200
     5.262    17.150     0.200
     5.461    17.620     0.200
     5.621    18.098     0.200
     5.818    18.308     0.200
     6.214    19.157     0.200
     6.403    20.859     0.200
     6.488    19.515     0.200
     7.535    19.759     0.200
    10.324    28.812     0.200
    14.305    38.571     0.200
     1.048     5.631     0.200
     1.146     6.058     0.200
     1.153     6.051     0.200
     1.153     5.906     0.200
     1.204     7.436     0.200
     1.217     7.456     0.200
     1.222     7.477     0.200
     1.292     6.156     0.200
     1.384     6.797     0.200
     1.508     6.977     0.200
     1.563     7.406     0.200
     1.600     7.340     0.200
     1.596     8.865     0.200
     1.597     8.842     0.200
     1.663     7.547     0.200
     1.907     8.236     0.200
     2.149     8.614     0.200
     2.133     8.721     0.200
     2.250     8.830     0.200
     2.273     9.289     0.200
     2.325     9.554     0.200
     2.396    10.071     0.200
     2.474     9.581     0.200
     2.496    10.720     0.200
     2.511    11.653     0.200
     2.564    11.217     0.200
     2.563     9.147     0.200
     2.631     9.845     0.200
     2.803    10.234     0.200
     2.810    10.152     0.200
     2.810    10.304     0.200
     2.902    10.905     0.200
     2.931    10.531     0.200
     3.155    12.195     0.200
     3.185    12.063     0.200
     3.248    12.742     0.200
     3.270    11.370     0.200
     3.583    12.325     0.200
     3.715    12.494     0.200
     3.784    12.654     0.200
     3.784    12.888     0.200
     3.894    14.034     0.200
     3.949    13.245     0.200
     4.003    13.799     0.200
     4.110    13.994     0.200
     4.194    12.568     0.200
     4.329    14.625     0.200
     4.329    14.942     0.200
     4.440    15.210     0.200
     4.558    15.217     0.200
     4.623    15.551     0.200
     4.734    16.264     0.200
     4.826    16.383     0.200
     4.987    17.163     0.200
     5.184    16.754     0.200
     5.279    17.760     0.200
     5.562    18.718     0.200
     5.571    17.808     0.200
     5.571    18.554     0.200
     5.621    16.593     0.200
     6.085    19.507     0.200
     6.116    19.008     0.200
     6.127    20.634     0.200
     6.154    19.067     0.200
     6.154    19.083     0.200
     6.544    22.464     0.200
     6.592    21.084     0.200
     6.597    21.142     0.200
     6.709    19.491     0.200
     7.391    22.052     0.200
     7.493    23.987     0.200
     7.512    21.683     0.200
     7.605    23.921     0.200
     7.653    23.325     0.200
     7.673    23.935     0.200
     7.724    24.117     0.200
     7.763    22.303     0.200
     7.786    22.377     0.200
     7.877    24.329     0.200
     7.882    22.190     0.200
     7.907    24.742     0.200
     7.913    24.376     0.200
     7.947    24.858     0.200
     8.021    24.291     0.200
     8.059    24.088     0.200
     8.059    23.588     0.200
     8.108    23.741     0.200
     8.272    24.122     0.200
     8.557    27.892     0.200
     8.571    21.093     0.200
     8.667    25.812     0.200
     8.824    23.757     0.200
     8.894    25.879     0.200
     9.150    26.264     0.200
     9.647    28.749     0.200
     9.803    27.645     0.200
     9.992    28.528     0.200
    10.327    29.791     0.200
    10.663    29.505     0.200
    10.759    30.232     0.200
    10.862    28.669     0.200
    10.863    29.207     0.200
    10.863    29.206     0.200
    10.963    33.539     0.200
    10.928    31.690     0.200
    11.233    34.097     0.200
    11.234    34.236     0.200
    11.234    33.685     0.200
    11.379    34.259     0.200
    13.444    35.176     0.200
    13.564    37.723     0.200
    13.754    37.833     0.200
    16.803    38.115     0.200
    18.556    41.138     0.200
     0.989     4.867     0.200
     0.989     5.035     0.200
     1.009     5.224     0.200
     1.304     7.947     0.200
     1.345     6.409     0.200
     1.338     7.096     0.200
     1.337     7.757     0.200
     1.415     7.961     0.200
     1.575     6.813     0.200
     1.730     7.197     0.200
     1.730     7.622     0.200
     1.833     9.069     0.200
     1.864     7.677     0.200
     1.871     7.727     0.200
     1.989     7.522     0.200
     2.028     7.932     0.200
     2.054     7.872     0.200
     2.571     9.838     0.200
     2.973    11.651     0.200
     3.000    11.049     0.200
     3.046    10.923     0.200
     3.174    11.203     0.200
     3.234    13.069     0.200
     3.704    11.012     0.200
     3.704    11.133     0.200
     3.872    13.269     0.200
     4.397    15.910     0.200
     4.636    15.289     0.200
     4.636    16.492     0.200
     4.924    16.920     0.200
     4.925    15.230     0.200
     4.925    17.359     0.200
     4.981    16.032     0.200
     5.049    16.027     0.200
     5.148    16.723     0.200
     5.269    17.682     0.200
     5.427    17.647     0.200
     5.427    18.092     0.200
     5.635    17.802     0.200
     5.740    19.038     0.200
     5.822    20.499     0.200
     6.247    17.815     0.200
     6.247    17.569     0.200
     6.248    19.648     0.200
     6.408    22.507     0.200
     6.845    24.210     0.200
     6.927    20.475     0.200
     6.928    21.196     0.200
     7.091    21.630     0.200
     7.434    22.149     0.200
     7.470    21.373     0.200
     7.483    23.608     0.200
     7.755    23.062     0.200
     7.792    22.885     0.200
     8.011    25.468     0.200
     8.079    24.805     0.200
     8.093    26.727     0.200
     8.183    22.083     0.200
     8.225    22.556     0.200
     8.313    22.286     0.200
     8.313    22.981     0.200
     9.699    29.092     0.200
    10.257    28.666     0.200
    10.257    28.786     0.200
    10.257    28.785     0.200
    11.535    32.733     0.200
     1.038     6.676     0.200
     1.236     6.315     0.200
     1.298     7.197     0.200
     1.320     7.058     0.200
     1.345     7.313     0.200
     1.485     7.033     0.200
     1.567     8.393     0.200
     1.573     8.191     0.200
     1.631     7.759     0.200
     1.683     7.802     0.200
     1.769     8.532     0.200
     1.757     8.916     0.200
     1.778     8.442     0.200
     1.979     8.686     0.200
     2.077     9.570     0.200
     2.086     8.078     0.200
     2.298     9.834     0.200
     2.293     9.729     0.200
     2.341    10.072     0.200
     2.612    11.083     0.200
     2.631    10.833     0.200
     2.723    12.133     0.200
     2.784    11.419     0.200
     2.799    11.309     0.200
     2.910    12.072     0.200
     2.943    10.023     0.200
     3.001    10.747     0.200
     3.081    11.990     0.200
     3.081    10.470     0.200
     3.203    12.766     0.200
     3.252    10.758     0.200
     3.279    12.997     0.200
     3.279    13.106     0.200
     3.406    13.936     0.200
     3.678    13.721     0.200
     3.696    14.054     0.200
     3.910    14.508     0.200
     4.563    16.521     0.200
     4.721    14.400     0.200
     4.744    16.339     0.200
     4.900    17.591     0.200
     4.900    18.216     0.200
     5.400    18.204     0.200
     5.476    18.635     0.200
     5.540    18.689     0.200
     5.517    18.840     0.200
     5.582    19.106     0.200
     5.571    16.910     0.200
     5.754    19.828     0.200
     5.902    18.923     0.200
     5.942    20.154     0.200
     6.021    20.522     0.200
     6.054    19.170     0.200
     6.157    21.128     0.200
     6.239    21.592     0.200
     6.312    19.951     0.200
     6.312    20.849     0.200
     6.892    24.704     0.200
     7.263    21.338     0.200
     7.302    26.754     0.200
     8.064    24.151     0.200
     8.270    26.899     0.200
     8.419    24.616     0.200
     8.450    24.674     0.200
     8.458    29.339     0.200
     8.699    27.488     0.200
     8.733    27.708     0.200
     8.751    25.441     0.200
     8.751    26.347     0.200
     8.805    28.360     0.200
     9.328    25.891     0.200
     9.328    25.789     0.200
     9.666    28.303     0.200
    11.239    31.237     0.200
    11.556    34.813     0.200
    14.238    40.224     0.200
    14.918    38.876     0.200
    15.059    39.471     0.200
    15.433    38.717     0.200
    19.191    43.049     0.200
     0.625     4.439     0.200
     0.733     3.692     0.200
     0.713     4.229     0.200
     0.781     3.954     0.200
     0.761     5.575     0.200
     0.805     4.698     0.200
     0.948     5.633     0.200
     1.018     4.441     0.200
     0.993     4.621     0.200
     1.399     6.068     0.200
     1.363     5.244     0.200
     1.760     6.638     0.200
     1.832     7.530     0.200
     1.844     7.241     0.200
     1.851     7.362     0.200
     1.851     7.190     0.200
     2.041     7.333     0.200
     2.023     7.554     0.200
     2.069     7.411     0.200
     2.215     8.719     0.200
     2.254     8.604     0.200
     2.618     9.604     0.200
     2.720     9.250     0.200
     2.973    10.645     0.200
     3.004    10.579     0.200
     3.204    11.192     0.200
     3.396    10.962     0.200
     3.759    10.482     0.200
     3.819    14.943     0.200
     3.923    12.992     0.200
     4.175    14.201     0.200
     4.342    17.284     0.200
     4.411    14.404     0.200
     4.445    12.765     0.200
     4.485    15.069     0.200
     4.682    16.069     0.200
     4.677    11.227     0.200
     4.778    14.927     0.200
     4.929    15.139     0.200
     4.962    16.309     0.200
     4.908    17.913     0.200
     5.034    15.502     0.200
     5.101    15.756     0.200
     5.177    16.140     0.200
     5.301    16.844     0.200
     5.479    17.160     0.200
     5.548    19.422     0.200
     5.662    17.070     0.200
     5.769    18.052     0.200
     5.855    17.263     0.200
     6.259    18.625     0.200
     6.302    16.875     0.200
     7.489    21.677     0.200
     7.619    18.174     0.200
     8.366    22.313     0.200
     0.874     4.644     0.200
     0.944     4.598     0.200
     1.193     6.238     0.200
     1.405     6.614     0.200
     1.472     6.464     0.200
     1.692     8.148     0.200
     1.684     6.732     0.200
     1.726     7.170     0.200
     1.730     7.303     0.200
     1.733     7.194     0.200
     1.907     7.458     0.200
     1.969     7.983     0.200
     2.109     7.875     0.200
     2.109     8.000     0.200
     2.140     8.481     0.200
     2.317     8.596     0.200
     2.589    10.217     0.200
     2.610     9.323     0.200
     2.868    10.381     0.200
     2.904    11.015     0.200
     2.887    11.707     0.200
     3.090    12.036     0.200
     3.129    11.307     0.200
     3.762    11.730     0.200
     3.812    11.659     0.200
     3.910    13.323     0.200
     4.309    14.222     0.200
     4.507    15.021     0.200
     4.647    15.458     0.200
     4.901    16.161     0.200
     5.035    16.020     0.200
     5.098    16.261     0.200
     5.173    15.567     0.200
     5.471    17.412     0.200
     5.579    18.110     0.200
     5.689    18.315     0.200
     6.153    18.843     0.200
     6.352    18.126     0.200
     6.813    20.866     0.200
     7.502    23.010     0.200
     7.514    21.060     0.200
     7.548    21.165     0.200
     7.756    24.546     0.200
     7.861    22.773     0.200
     7.861    23.355     0.200
     8.009    24.806     0.200
     8.053    24.633     0.200
     8.085    23.696     0.200
     8.092    24.309     0.200
     8.307    24.376     0.200
     8.427    22.561     0.200
     8.878    25.781     0.200
     9.170    29.262     0.200
    10.387    26.994     0.200
    10.388    29.036     0.200
    11.494    34.802     0.200
     1.189     8.387     0.200
     1.239     7.440     0.200
     1.239     7.589     0.200
     1.317     5.975     0.200
     1.307     8.747     0.200
     1.327     7.958     0.200
     1.330     6.866     0.200
     1.532     6.553     0.200
     1.613     6.583     0.200
     1.616     6.675     0.200
     1.649     7.923     0.200
     1.763     7.207     0.200
     1.810     7.419     0.200
     2.052     8.275     0.200
     2.113     8.060     0.200
     2.113     8.271     0.200
     2.166     8.562     0.200
     2.475     9.650     0.200
     2.471     9.924     0.200
     2.635    10.016     0.200
     2.729    10.923     0.200
     2.844     9.962     0.200
     2.856    10.483     0.200
     2.890    10.723     0.200
     2.976    11.565     0.200
     3.674    13.541     0.200
     3.702    15.141     0.200
     3.789    11.932     0.200
     3.789    12.822     0.200
     3.805    13.368     0.200
     4.151    14.872     0.200
     4.521    15.915     0.200
     4.521    16.524     0.200
     4.665    16.522     0.200
     4.755    16.708     0.200
     4.943    17.086     0.200
     5.178    15.700     0.200
     5.422    18.574     0.200
     5.533    18.485     0.200
     5.996    19.730     0.200
     6.280    22.086     0.200
     6.322    18.730     0.200
     6.322    18.937     0.200
     6.517    24.007     0.200
     6.648    24.591     0.200
     7.381    22.065     0.200
     7.771    24.515     0.200
     7.785    24.227     0.200
     7.785    21.360     0.200
     7.874    23.886     0.200
     8.413    23.442     0.200
    10.406    27.197     0.200
    10.407    29.187     0.200
    10.593    32.418     0.200
    11.341    36.422     0.200
     0.991     5.045     0.200
     1.001     5.072     0.200
     1.267     7.739     0.200
     1.274     7.796     0.200
     1.309     7.056     0.200
     1.301     7.562     0.200
     1.379     6.850     0.200
     1.352     7.975     0.200
     1.382     7.700     0.200
     1.382     7.872     0.200
     1.571     6.900     0.200
     1.613     8.356     0.200
     1.743     7.419     0.200
     1.801     8.869     0.200
     1.801     8.795     0.200
     1.848     7.660     0.200
     1.851     7.640     0.200
     2.017     7.895     0.200
     2.026     7.995     0.200
     2.056     8.115     0.200
     2.258     9.036     0.200
     2.371     9.187     0.200
     2.598    10.119     0.200
     2.602    10.289     0.200
     2.707    10.061     0.200
     2.710     9.739     0.200
     2.889    10.068     0.200
     2.975    11.575     0.200
     2.975    10.977     0.200
     2.969    10.302     0.200
     3.013    10.566     0.200
     3.068    10.119     0.200
     3.156    10.830     0.200
     3.187    11.331     0.200
     3.207    11.360     0.200
     3.255    13.892     0.200
     3.387    11.338     0.200
     3.402    11.133     0.200
     3.469    11.430     0.200
     3.469    11.602     0.200
     3.633    12.282     0.200
     3.741    11.366     0.200
     3.741    11.725     0.200
     3.821    12.138     0.200
     3.831    12.473     0.200
     3.879    12.686     0.200
     3.879    13.417     0.200
     3.900    12.461     0.200
     3.903    13.682     0.200
     3.961    12.719     0.200
     4.185    12.883     0.200
     4.285    13.589     0.200
     4.388    14.044     0.200
     4.399    14.211     0.200
     4.452    13.796     0.200
     4.485    14.179     0.200
     4.575    15.955     0.200
     4.622    15.355     0.200
     4.662    15.806     0.200
     4.662    16.278     0.200
     4.762    15.186     0.200
     4.919    15.625     0.200
     4.919    15.879     0.200
     4.943    16.601     0.200
     4.941    15.463     0.200
     5.014    16.124     0.200
     5.086    15.557     0.200
     5.132    15.165     0.200
     5.160    16.606     0.200
     5.376    15.667     0.200
     5.441    17.594     0.200
     5.459    17.338     0.200
     5.459    17.815     0.200
     5.552    19.271     0.200
     5.646    18.303     0.200
     5.614    19.794     0.200
     5.753    18.426     0.200
     5.810    19.242     0.200
     5.858    18.625     0.200
     6.206    18.979     0.200
     6.247    18.578     0.200
     6.247    18.820     0.200
     6.285    18.157     0.200
     6.381    21.174     0.200
     6.423    21.099     0.200
     6.414    19.365     0.200
     6.516    20.073     0.200
     6.770    21.967     0.200
     6.812    20.410     0.200
     6.812    20.609     0.200
     6.859    21.743     0.200
     6.874    21.574     0.200
     6.874    21.523     0.200
     6.956    21.311     0.200
     7.063    18.760     0.200
     7.126    20.967     0.200
     7.195    21.545     0.200
     7.215    20.219     0.200
     7.215    21.387     0.200
     7.216    20.139     0.200
     7.274    25.475     0.200
     7.296    21.647     0.200
     7.333    22.113     0.200
     7.389    20.554     0.200
     7.469    21.210     0.200
     7.511    21.841     0.200
     7.511    23.259     0.200
     7.506    21.218     0.200
     7.553    19.879     0.200
     7.780    26.880     0.200
     7.827    22.569     0.200
     7.827    21.951     0.200
     7.827    23.041     0.200
     7.846    25.642     0.200
     7.880    24.172     0.200
     7.963    23.955     0.200
     8.035    24.883     0.200
     8.081    24.987     0.200
     8.104    23.838     0.200
     8.200    25.443     0.200
     8.238    26.623     0.200
     8.308    24.058     0.200
     8.308    26.640     0.200
     8.320    28.322     0.200
     8.350    22.546     0.200
     8.350    22.417     0.200
     8.411    25.927     0.200
     8.478    24.846     0.200
     8.519    24.955     0.200
     8.720    25.701     0.200
     8.811    28.354     0.200
     8.881    25.232     0.200
     8.881    25.677     0.200
     8.982    27.071     0.200
     9.008    27.675     0.200
     9.015    27.400     0.200
     9.032    27.779     0.200
     9.054    25.401     0.200
     9.125    28.603     0.200
     9.181    23.966     0.200
     9.454    28.583     0.200
     9.502    29.207     0.200
     9.658    28.970     0.200
     9.725    29.003     0.200
     9.747    26.955     0.200
     9.747    27.232     0.200
     9.768    26.516     0.200
     9.792    27.244     0.200
     9.792    25.732     0.200
     9.760    28.502     0.200
     9.856    28.963     0.200
    10.001    27.835     0.200
    10.178    29.315     0.200
    10.206    28.768     0.200
    10.206    28.995     0.200
    10.293    28.612     0.200
    10.293    28.591     0.200
    10.604    32.409     0.200
    10.591    28.680     0.200
    10.591    29.410     0.200
    10.667    29.609     0.200
    10.677    30.191     0.200
    10.720    29.788     0.200
    10.919    29.412     0.200
    10.919    31.869     0.200
    11.030    29.821     0.200
    11.124    28.685     0.200
    11.311    32.644     0.200
    11.339    34.474     0.200
    11.464    33.665     0.200
    11.502    29.797     0.200
    11.502    33.196     0.200
    11.504    32.708     0.200
    11.538    35.122     0.200
    11.535    35.117     0.200
    11.550    30.545     0.200
    11.550    31.768     0.200
    11.550    31.857     0.200
    11.550    32.396     0.200
    11.550    31.505     0.200
    11.617    30.690     0.200
    11.617    30.233     0.200
    11.730    30.245     0.200
    11.757    33.890     0.200
    11.856    33.477     0.200
    11.875    32.021     0.200
    11.981    34.192     0.200
    12.072    31.756     0.200
    12.148    34.218     0.200
    12.147    35.626     0.200
    12.247    34.849     0.200
    12.333    31.042     0.200
    12.333    34.984     0.200
    12.395    31.831     0.200
    12.581    32.293     0.200
    12.581    33.098     0.200
    12.633    35.905     0.200
    12.798    34.952     0.200
    12.800    32.588     0.200
    12.844    37.051     0.200
    12.968    37.587     0.200
    12.980    37.007     0.200
    12.987    35.485     0.200
    13.001    34.262     0.200
    13.015    36.837     0.200
    13.084    37.270     0.200
    13.138    34.372     0.200
    13.157    33.792     0.200
    13.157    35.401     0.200
    13.243    34.816     0.200
    13.261    34.995     0.200
    13.261    35.730     0.200
    13.400    38.343     0.200
    13.497    38.959     0.200
    13.705    38.944     0.200
    13.762    36.955     0.200
    13.762    37.490     0.200
    13.769    34.409     0.200
    13.769    33.881     0.200
    13.787    38.859     0.200
    13.800    35.470     0.200
    13.800    35.872     0.200
    13.947    38.940     0.200
    13.965    34.932     0.200
    13.959    34.367     0.200
    13.959    35.285     0.200
    14.056    36.003     0.200
    14.167    34.466     0.200
    14.259    35.340     0.200
    14.524    36.662     0.200
    14.746    38.188     0.200
    14.855    35.932     0.200
    14.855    36.327     0.200
    15.045    37.596     0.200
    15.045    37.045     0.200
    15.089    37.241     0.200
    15.213    39.160     0.200
    15.565    38.921     0.200
    15.604    38.276     0.200
    15.621    38.111     0.200
    15.666    38.102     0.200
    15.666    38.512     0.200
    15.741    38.574     0.200
    15.846    37.074     0.200
    15.912    38.188     0.200
    16.120    39.104     0.200
    16.120    38.338     0.200
    16.127    36.721     0.200
    16.216    38.977     0.200
    16.291    37.113     0.200
    16.334    39.602     0.200
    16.392    38.860     0.200
    16.437    39.646     0.200
    16.449    38.377     0.200
    16.496    37.403     0.200
    16.529    38.728     0.200
    16.529    38.849     0.200
    16.631    37.873     0.200
    16.637    38.819     0.200
    16.637    39.929     0.200
    16.652    38.906     0.200
    16.660    39.190     0.200
    16.708    38.662     0.200
    16.739    37.548     0.200
    16.749    38.696     0.200
    16.749    39.270     0.200
    16.883    38.700     0.200
    16.961    38.507     0.200
    16.984    38.909     0.200
    17.049    38.743     0.200
    17.141    39.349     0.200
    17.206    39.242     0.200
    17.211    38.216     0.200
    17.234    38.472     0.200
    17.244    39.640     0.200
    17.357    38.398     0.200
    17.390    39.060     0.200
    17.438    37.923     0.200
    17.434    39.296     0.200
    17.478    38.654     0.200
    17.549    38.740     0.200
    17.549    39.414     0.200
    17.584    39.660     0.200
    17.617    39.361     0.200
    17.638    39.289     0.200
    17.707    38.479     0.200
    17.728    39.983     0.200
    17.745    39.373     0.200
    17.782    40.039     0.200
    17.834    39.295     0.200
    17.894    39.712     0.200
    17.931    38.079     0.200
    17.962    39.407     0.200
    18.087    39.442     0.200
    18.171    39.251     0.200
    18.164    39.450     0.200
    18.175    39.117     0.200
    18.178    39.335     0.200
    18.227    39.395     0.200
    18.252    39.766     0.200
    18.305    39.766     0.200
    18.305    39.666     0.200
    18.452    40.689     0.200
    18.597    40.062     0.200
    18.609    41.040     0.200
    18.657    41.094     0.200
    18.671    41.177     0.200
    18.825    40.331     0.200
    19.010    40.097     0.200
    19.151    42.094     0.200
    19.257    40.279     0.200
    19.250    41.064     0.200
    19.276    40.605     0.200
    19.281    41.071     0.200
    19.314    40.621     0.200
    19.331    40.327     0.200
    19.397    40.563     0.200
    19.694    40.483     0.200
    19.720    41.066     0.200
    20.038    40.070     0.200
    20.455    39.977     0.200
    20.882    41.022     0.200
    20.863    40.374     0.200
     0.938     5.032     0.200
     0.938     5.250     0.200
     1.184     7.190     0.200
     1.202     8.179     0.200
     1.227     7.922     0.200
     1.252     7.366     0.200
     1.293     7.830     0.200
     1.416     7.016     0.200
     1.455     6.616     0.200
     1.678     7.033     0.200
     1.669     8.134     0.200
     1.707     7.656     0.200
     1.710     7.377     0.200
     1.710     7.095     0.200
     1.886     7.546     0.200
     1.955     7.911     0.200
     2.130     8.314     0.200
     2.116     8.756     0.200
     2.311     9.178     0.200
     2.593     9.414     0.200
     2.593     9.457     0.200
     2.622     9.776     0.200
     2.833    10.927     0.200
     2.873    11.842     0.200
     2.881    10.999     0.200
     3.122    12.637     0.200
     3.114    11.485     0.200
     3.267    11.217     0.200
     3.830    11.488     0.200
     3.830    12.330     0.200
     3.917    13.515     0.200
     4.295    15.034     0.200
     4.486    14.367     0.200
     4.650    15.725     0.200
     4.897    17.346     0.200
     4.914    18.992     0.200
     5.045    16.393     0.200
     5.090    17.115     0.200
     5.478    17.494     0.200
     5.680    19.224     0.200
     5.779    20.759     0.200
     6.064    21.461     0.200
     6.370    18.538     0.200
     6.370    18.070     0.200
     6.794    24.879     0.200
     7.178    22.022     0.200
     7.506    22.785     0.200
     7.506    23.202     0.200
     7.528    22.181     0.200
     7.562    22.401     0.200
     7.873    23.034     0.200
     8.009    26.079     0.200
     8.086    24.396     0.200
     8.092    26.510     0.200
     8.446    22.734     0.200
     8.446    22.618     0.200
     8.883    26.832     0.200
     9.709    30.165     0.200
    10.410    29.044     0.200
    10.409    29.902     0.200
    10.410    29.043     0.200
    10.660    33.244     0.200
    10.906    31.650     0.200
    14.024    33.818     0.200
     0.998     5.111     0.200
     0.982     5.071     0.200
     1.017     5.642     0.200
     1.077     7.637     0.200
     1.193     8.255     0.200
     1.258     7.721     0.200
     1.299     7.030     0.200
     1.382     6.682     0.200
     1.372     7.690     0.200
     1.564     7.003     0.200
     1.740     7.433     0.200
     1.740     7.733     0.200
     1.791     8.871     0.200
     1.839     7.249     0.200
     1.841     7.711     0.200
     2.034     7.897     0.200
     2.034     7.698     0.200
     2.599    10.583     0.200
     2.703     9.980     0.200
     3.184    12.534     0.200
     3.245    12.684     0.200
     3.749    13.408     0.200
     3.905    13.860     0.200
     4.393    15.658     0.200
     4.475    15.629     0.200
     4.942    17.215     0.200
     5.018    16.729     0.200
     5.094    16.054     0.200
     5.157    17.162     0.200
     5.281    17.808     0.200
     5.462    17.115     0.200
     5.749    18.793     0.200
     5.835    19.188     0.200
     6.241    18.732     0.200
     6.292    17.789     0.200
     7.680    25.373     0.200
    10.302    29.317     0.200
     0.955     4.769     0.200
     0.955     4.871     0.200
     1.060     7.153     0.200
     1.143     7.790     0.200
     1.143     7.597     0.200
     1.143     7.815     0.200
     1.158     7.476     0.200
     1.178     6.745     0.200
     1.185     7.143     0.200
     1.218     7.939     0.200
     1.472     6.465     0.200
     1.695     7.002     0.200
     1.720     7.501     0.200
     1.723     7.259     0.200
     1.723     7.485     0.200
     1.903     7.928     0.200
     1.973     7.930     0.200
     2.126     8.835     0.200
     2.130     8.042     0.200
     2.130     8.206     0.200
     3.833    11.636     0.200
     4.313    15.647     0.200
     4.664    16.079     0.200
     5.108    16.911     0.200
     5.238    17.357     0.200
     5.797    21.839     0.200
     6.373    18.388     0.200
     6.811    24.612     0.200
     7.187    21.327     0.200
     7.520    23.691     0.200
     7.536    21.755     0.200
     7.569    21.728     0.200
     7.772    26.949     0.200
     7.882    23.223     0.200
     8.024    25.831     0.200
     8.068    25.672     0.200
     8.107    25.254     0.200
     8.448    23.044     0.200
     9.723    29.614     0.200
    10.407    29.612     0.200
    10.408    29.407     0.200
    10.921    32.111     0.200
     0.898     4.368     0.200
     0.970     4.560     0.200
     0.970     4.663     0.200
     1.209     6.538     0.200
     1.211     7.130     0.200
     1.285     7.269     0.200
     1.295     7.812     0.200
     1.418     6.269     0.200
     1.499     6.458     0.200
     1.710     6.781     0.200
     1.703     8.281     0.200
     1.703     8.441     0.200
     1.752     7.238     0.200
     1.755     7.095     0.200
     1.755     7.197     0.200
     1.997     7.691     0.200
     2.108     7.535     0.200
     2.158     8.725     0.200
     2.609     9.568     0.200
     2.638     9.352     0.200
     2.915    11.547     0.200
     3.108    12.634     0.200
     3.156    11.802     0.200
     3.155    13.276     0.200
     3.779    13.373     0.200
     3.927    13.115     0.200
     4.337    15.092     0.200
     4.668    16.297     0.200
     4.926    16.736     0.200
     5.050    16.265     0.200
     5.125    16.692     0.200
     5.170    16.118     0.200
     5.254    17.359     0.200
     5.606    18.129     0.200
     5.716    18.466     0.200
     5.811    19.432     0.200
     6.394    21.137     0.200
     6.467    21.643     0.200
     6.828    22.100     0.200
     6.840    21.161     0.200
     7.523    22.349     0.200
     8.076    23.928     0.200
     8.115    25.871     0.200
     9.027    25.007     0.200
    10.382    28.549     0.200
     1.228     6.245     0.200
     1.581     7.690     0.200
     1.637     8.079     0.200
     1.640     7.987     0.200
     1.794     8.178     0.200
     1.922     8.911     0.200
     1.949     9.221     0.200
     1.945     8.479     0.200
     2.122     9.271     0.200
     2.388    10.835     0.200
     2.483     9.044     0.200
     2.615    10.685     0.200
     2.691    10.740     0.200
     3.028    12.934     0.200
     3.329    13.667     0.200
     3.376    12.825     0.200
     4.234    15.128     0.200
     4.199    14.049     0.200
     4.280    14.755     0.200
     4.433    15.039     0.200
     4.456    16.621     0.200
     4.869    17.368     0.200
     4.985    17.733     0.200
     5.182    18.064     0.200
     5.324    17.918     0.200
     5.418    17.714     0.200
     5.472    18.624     0.200
     5.540    16.094     0.200
     5.788    19.547     0.200
     5.844    19.289     0.200
     5.909    19.838     0.200
     6.039    20.582     0.200
     6.179    18.525     0.200
     6.249    20.854     0.200
     6.612    21.856     0.200
     6.613    22.343     0.200
     7.037    25.324     0.200
     7.848    24.678     0.200
     7.908    23.162     0.200
     8.078    24.107     0.200
     8.077    25.215     0.200
     8.189    25.683     0.200
     8.251    24.123     0.200
     8.325    26.200     0.200
     8.365    25.976     0.200
     8.410    27.456     0.200
     8.409    26.091     0.200
     8.413    26.312     0.200
     8.741    26.998     0.200
     8.808    23.600     0.200
     9.233    28.642     0.200
    10.037    31.195     0.200
    10.739    30.919     0.200
    10.739    30.340     0.200
    11.730    33.628     0.200
     0.953     4.864     0.200
     0.991     4.964     0.200
     0.991     5.479     0.200
     1.072     7.607     0.200
     1.088     7.704     0.200
     1.088     7.593     0.200
     1.089     7.710     0.200
     1.267     6.976     0.200
     1.261     7.236     0.200
     1.340     7.616     0.200
     1.398     6.614     0.200
     1.543     6.801     0.200
     1.759     8.613     0.200
     1.759     9.072     0.200
     1.809     7.646     0.200
     1.811     7.548     0.200
     1.811     7.274     0.200
     2.216     8.925     0.200
     2.606     9.846     0.200
     2.682     9.701     0.200
     2.953    11.871     0.200
     3.213    12.108     0.200
     3.775    11.729     0.200
     3.917    13.982     0.200
     4.376    15.545     0.200
     4.445    15.522     0.200
     4.586    14.769     0.200
     4.669    15.953     0.200
     4.669    16.317     0.200
     4.891    17.521     0.200
     4.940    16.957     0.200
     5.124    15.378     0.200
     5.149    17.593     0.200
     5.275    17.849     0.200
     5.475    17.704     0.200
     5.741    19.509     0.200
     5.830    19.534     0.200
     6.222    19.968     0.200
     6.318    17.908     0.200
     7.151    20.572     0.200
     7.520    23.257     0.200
     7.531    21.952     0.200
     8.038    25.003     0.200
     8.083    24.975     0.200
     8.110    24.823     0.200
     8.293    23.798     0.200
     8.385    22.592     0.200
    10.332    29.087     0.200
     1.103     5.898     0.200
     1.223     6.325     0.200
     1.223     6.219     0.200
     1.409     8.477     0.200
     1.409     8.349     0.200
     1.577     7.798     0.200
     1.634     8.324     0.200
     1.636     8.041     0.200
     1.791     8.072     0.200
     1.918     8.835     0.200
     1.940     8.340     0.200
     1.940     8.625     0.200
     1.946     9.167     0.200
     2.118     9.247     0.200
     2.385    11.008     0.200
     2.481     9.001     0.200
     2.614    10.687     0.200
     2.938    11.665     0.200
     3.371    13.912     0.200
     4.276    14.923     0.200
     4.428    16.705     0.200
     4.452    16.319     0.200
     4.865    18.292     0.200
     5.178    18.150     0.200
     5.225    19.126     0.200
     5.319    18.098     0.200
     5.414    17.741     0.200
     5.467    18.834     0.200
     5.783    19.574     0.200
     5.840    19.449     0.200
     5.905    20.059     0.200
     5.882    20.477     0.200
     6.035    20.720     0.200
     6.609    22.311     0.200
     6.608    21.664     0.200
     7.033    24.142     0.200
     7.555    23.198     0.200
     7.844    25.120     0.200
     7.905    23.320     0.200
     8.074    24.255     0.200
     8.185    24.299     0.200
     8.320    25.588     0.200
     8.385    23.548     0.200
     8.408    27.158     0.200
     9.229    27.827     0.200
    12.337    34.196     0.200
     0.932     4.661     0.200
     1.407     6.456     0.200
     1.454     6.450     0.200
     1.676     8.651     0.200
     1.676     8.444     0.200
     1.711     7.275     0.200
     1.713     7.123     0.200
     1.713     7.283     0.200
     1.888     7.538     0.200
     1.953     7.924     0.200
     2.122     8.806     0.200
     2.121     7.990     0.200
     2.465     9.476     0.200
     2.593     9.573     0.200
     2.838    10.853     0.200
     2.854    10.739     0.200
     2.888    10.770     0.200
     2.871    11.610     0.200
     3.117    12.347     0.200
     3.337    12.181     0.200
     3.821    12.342     0.200
     3.908    13.679     0.200
     4.293    15.031     0.200
     4.642    17.035     0.200
     4.799    16.360     0.200
     4.891    16.718     0.200
     5.036    16.482     0.200
     5.085    16.681     0.200
     5.185    16.861     0.200
     5.470    17.920     0.200
     5.565    17.941     0.200
     5.676    18.179     0.200
     5.774    18.746     0.200
     6.136    17.448     0.200
     6.249    22.541     0.200
     6.357    22.597     0.200
     6.789    19.888     0.200
     7.169    21.463     0.200
     7.498    23.795     0.200
     8.437    22.689     0.200
    10.400    28.436     0.200
     1.019     5.308     0.200
     1.141     5.637     0.200
     1.143     5.782     0.200
     1.143     5.536     0.200
     1.201     6.754     0.200
     1.201     6.778     0.200
     1.236     7.705     0.200
     1.250     7.728     0.200
     1.255     7.729     0.200
     1.363     6.494     0.200
     1.475     6.651     0.200
     1.570     6.984     0.200
     1.564     7.125     0.200
     1.640     7.245     0.200
     1.619     8.694     0.200
     1.896     8.263     0.200
     2.100     8.438     0.200
     2.124     8.233     0.200
     2.270     9.020     0.200
     2.293     9.035     0.200
     2.393     9.119     0.200
     2.412     9.156     0.200
     2.467    10.163     0.200
     2.512    11.124     0.200
     2.565    11.680     0.200
     2.549     8.954     0.200
     2.793    10.097     0.200
     2.870    10.852     0.200
     2.925    10.501     0.200
     3.186     9.851     0.200
     3.700    12.028     0.200
     3.776    12.117     0.200
     3.776    12.332     0.200
     3.867    13.464     0.200
     3.934    12.628     0.200
     3.972    13.952     0.200
     4.174    12.561     0.200
     4.174    11.487     0.200
     4.306    14.096     0.200
     4.306    14.557     0.200
     4.590    15.309     0.200
     4.590    15.512     0.200
     4.701    15.773     0.200
     4.794    15.750     0.200
     5.155    16.660     0.200
     5.248    17.268     0.200
     5.375    16.621     0.200
     5.507    16.603     0.200
     5.529    19.334     0.200
     5.540    18.174     0.200
     5.540    17.877     0.200
     5.634    19.193     0.200
     5.605    16.057     0.200
     5.681    16.355     0.200
     5.681    16.015     0.200
     5.774    15.779     0.200
     6.056    18.779     0.200
     6.095    19.485     0.200
     6.099    16.213     0.200
     6.137    18.669     0.200
     6.137    19.141     0.200
     6.145    19.675     0.200
     6.221    20.990     0.200
     6.256    17.865     0.200
     6.385    18.691     0.200
     6.506    19.475     0.200
     6.512    20.473     0.200
     6.579    20.534     0.200
     6.588    20.473     0.200
     6.670    20.313     0.200
     6.687    19.344     0.200
     6.868    19.410     0.200
     6.937    20.070     0.200
     7.363    21.489     0.200
     7.485    21.169     0.200
     7.595    20.452     0.200
     7.640    24.487     0.200
     7.691    23.333     0.200
     7.737    21.931     0.200
     7.759    22.017     0.200
     7.851    23.409     0.200
     7.855    22.658     0.200
     7.876    26.000     0.200
     7.880    22.906     0.200
     7.901    22.195     0.200
     7.968    24.377     0.200
     7.988    22.554     0.200
     8.030    23.967     0.200
     8.030    23.353     0.200
     8.082    25.409     0.200
     8.145    23.900     0.200
     8.177    24.132     0.200
     8.804    23.715     0.200
     8.804    23.484     0.200
     8.862    24.540     0.200
     9.525    26.545     0.200
     9.599    26.129     0.200
     9.771    26.141     0.200
    10.638    29.853     0.200
    10.848    28.359     0.200
    10.849    29.096     0.200
    10.903    27.504     0.200
    11.202    32.403     0.200
    11.202    30.024     0.200
    14.968    39.205     0.200
    15.448    35.553     0.200
    15.537    34.611     0.200
     1.024     5.699     0.200
     1.201     7.571     0.200
     1.236     6.024     0.200
     1.236     5.892     0.200
     1.227     7.679     0.200
     1.314     6.410     0.200
     1.399     8.317     0.200
     1.578     8.051     0.200
     1.589     7.554     0.200
     1.635     7.868     0.200
     1.806     7.778     0.200
     1.951     8.071     0.200
     1.940     9.185     0.200
     2.528    11.226     0.200
     2.603    10.993     0.200
     2.691    10.303     0.200
     2.679    10.547     0.200
     2.679    10.648     0.200
     2.952    11.594     0.200
     3.382    13.381     0.200
     3.439    12.555     0.200
     3.684    16.646     0.200
     4.212    15.083     0.200
     4.291    15.287     0.200
     4.680    13.389     0.200
     4.995    17.853     0.200
     5.429    17.954     0.200
     5.477    18.886     0.200
     5.792    19.743     0.200
     5.917    24.463     0.200
     7.852    25.898     0.200
    12.804    38.539     0.200
    16.064    35.763     0.200
     1.026     6.115     0.200
     1.071     6.223     0.200
     1.236     6.172     0.200
     1.320     6.498     0.200
     1.367     8.333     0.200
     1.396     8.495     0.200
     1.407     8.380     0.200
     1.407     8.357     0.200
     1.595     7.500     0.200
     1.586     8.111     0.200
     1.642     7.940     0.200
     1.803     7.916     0.200
     1.895     9.297     0.200
     1.926     8.865     0.200
     1.953     8.434     0.200
     1.953     8.582     0.200
     1.948     9.154     0.200
     2.035     9.277     0.200
     2.129     9.157     0.200
     2.111     9.650     0.200
     2.611    11.183     0.200
     2.697    10.396     0.200
     2.786    10.602     0.200
     2.838    10.997     0.200
     2.889    14.447     0.200
     2.951    11.550     0.200
     2.925    11.826     0.200
     3.035    12.367     0.200
     3.333    12.834     0.200
     3.328    10.667     0.200
     3.384    12.517     0.200
     3.368    12.660     0.200
     3.447    13.197     0.200
     4.289    15.088     0.200
     4.439    16.337     0.200
     4.458    16.012     0.200
     4.794    17.690     0.200
     4.874    16.990     0.200
     4.874    17.428     0.200
     4.994    17.153     0.200
     4.994    17.801     0.200
     5.191    17.728     0.200
     5.226    19.476     0.200
     5.332    18.107     0.200
     5.427    18.404     0.200
     5.480    18.809     0.200
     5.795    19.672     0.200
     5.853    18.708     0.200
     5.853    19.482     0.200
     5.917    20.036     0.200
     6.047    19.841     0.200
     6.621    21.446     0.200
     6.672    20.963     0.200
     6.672    20.346     0.200
     6.916    21.938     0.200
     7.045    23.508     0.200
     8.260    26.354     0.200
     8.298    25.457     0.200
     8.310    25.448     0.200
     8.347    23.356     0.200
     8.353    28.574     0.200
     8.368    26.924     0.200
     8.374    25.648     0.200
     8.404    23.827     0.200
     8.420    25.677     0.200
     8.503    25.924     0.200
     8.585    25.826     0.200
    10.746    29.959     0.200
    12.745    34.279     0.200
     0.950     4.964     0.200
     1.209     7.519     0.200
     1.236     7.448     0.200
     1.236     7.227     0.200
     1.274     7.660     0.200
     1.458     6.631     0.200
     1.435     6.911     0.200
     1.469     8.029     0.200
     1.654     8.497     0.200
     1.654     8.526     0.200
     1.700     7.237     0.200
     1.703     7.400     0.200
     1.689     7.193     0.200
     1.885     7.700     0.200
     1.960     8.078     0.200
     2.105     8.727     0.200
     2.148     8.077     0.200
     2.323     8.877     0.200
     2.455    10.122     0.200
     2.595     9.630     0.200
     2.609    10.034     0.200
     2.630    10.041     0.200
     2.757     9.945     0.200
     2.823    10.659     0.200
     2.829    10.624     0.200
     2.866    11.178     0.200
     2.879    11.382     0.200
     2.917    10.112     0.200
     3.014    10.786     0.200
     3.055    14.039     0.200
     3.103    15.350     0.200
     3.133    11.243     0.200
     3.250    11.077     0.200
     3.268    11.065     0.200
     3.333    11.448     0.200
     3.483    12.141     0.200
     3.671    13.184     0.200
     3.691    12.652     0.200
     3.727    12.411     0.200
     3.727    13.566     0.200
     3.776    12.610     0.200
     3.816    12.064     0.200
     3.849    11.828     0.200
     3.849    11.444     0.200
     3.934    13.493     0.200
     4.037    13.039     0.200
     4.132    13.072     0.200
     4.248    13.396     0.200
     4.300    14.801     0.200
     4.335    13.877     0.200
     4.335    14.332     0.200
     4.445    14.947     0.200
     4.482    14.702     0.200
     4.609    15.014     0.200
     4.665    16.503     0.200
     4.665    15.962     0.200
     4.791    15.397     0.200
     4.801    16.155     0.200
     4.801    16.362     0.200
     4.806    15.572     0.200
     4.910    16.888     0.200
     4.979    15.985     0.200
     5.074    16.403     0.200
     5.063    16.253     0.200
     5.100    16.711     0.200
     5.232    17.484     0.200
     5.496    17.865     0.200
     5.496    17.970     0.200
     5.579    18.655     0.200
     5.690    18.962     0.200
     5.791    19.898     0.200
     6.053    19.967     0.200
     6.141    18.634     0.200
     6.237    21.492     0.200
     6.373    21.287     0.200
     6.388    18.334     0.200
     6.435    20.301     0.200
     6.636    23.343     0.200
     6.677    24.396     0.200
     6.804    24.199     0.200
     6.805    24.667     0.200
     7.132    25.945     0.200
     7.148    20.502     0.200
     7.197    21.315     0.200
     7.271    20.876     0.200
     7.293    21.418     0.200
     7.293    21.896     0.200
     7.293    21.318     0.200
     7.510    25.797     0.200
     7.504    22.521     0.200
     7.522    23.336     0.200
     7.522    23.654     0.200
     7.547    21.953     0.200
     7.580    22.013     0.200
     7.772    27.241     0.200
     7.800    27.357     0.200
     7.906    29.005     0.200
     7.889    22.753     0.200
     7.891    23.188     0.200
     7.891    22.689     0.200
     7.892    22.767     0.200
     7.926    25.057     0.200
     8.024    25.930     0.200
     8.035    25.685     0.200
     8.061    25.760     0.200
     8.067    25.623     0.200
     8.102    25.389     0.200
     8.107    25.860     0.200
     8.157    26.184     0.200
     8.235    25.336     0.200
     8.235    27.049     0.200
     8.277    26.233     0.200
     8.298    26.197     0.200
     8.358    26.896     0.200
     8.480    26.722     0.200
     8.465    23.005     0.200
     8.531    28.535     0.200
     8.669    28.277     0.200
     8.904    29.801     0.200
     8.900    25.815     0.200
     8.949    29.755     0.200
     8.952    30.162     0.200
     9.381    30.053     0.200
     9.622    27.215     0.200
     9.724    29.556     0.200
     9.803    30.200     0.200
     9.778    30.192     0.200
     9.770    28.389     0.200
     9.770    29.875     0.200
     9.775    26.220     0.200
     9.775    27.972     0.200
     9.861    30.444     0.200
    10.248    29.042     0.200
    10.248    30.537     0.200
    10.469    33.549     0.200
    10.426    29.285     0.200
    10.427    29.106     0.200
    10.482    34.040     0.200
    10.574    30.582     0.200
    10.683    28.793     0.200
    10.679    30.636     0.200
    10.888    31.990     0.200
    10.922    31.656     0.200
    10.922    31.988     0.200
    10.978    33.503     0.200
    11.068    33.367     0.200
    11.195    34.423     0.200
    11.195    34.685     0.200
    11.206    33.916     0.200
    11.369    32.254     0.200
    11.369    33.054     0.200
    11.399    35.885     0.200
    11.415    36.091     0.200
    11.497    32.179     0.200
    11.498    32.491     0.200
    11.498    34.550     0.200
    11.493    33.483     0.200
    11.493    34.438     0.200
    11.590    29.521     0.200
    11.691    34.261     0.200
    11.696    32.697     0.200
    11.696    31.302     0.200
    11.789    35.171     0.200
    11.912    34.891     0.200
    11.987    35.361     0.200
    12.011    35.279     0.200
    12.025    34.250     0.200
    12.082    35.485     0.200
    12.178    35.899     0.200
    12.256    36.008     0.200
    12.362    33.649     0.200
    12.362    36.737     0.200
    12.389    38.050     0.200
    12.408    36.189     0.200
    12.553    32.848     0.200
    12.553    34.818     0.200
    12.564    37.199     0.200
    12.758    38.341     0.200
    12.822    36.678     0.200
    12.848    37.782     0.200
    12.942    38.112     0.200
    13.004    38.109     0.200
    13.101    36.961     0.200
    13.260    33.653     0.200
    13.260    36.646     0.200
    13.375    39.169     0.200
    13.381    35.028     0.200
    13.381    36.236     0.200
    13.569    38.890     0.200
    13.657    39.824     0.200
    13.683    37.091     0.200
    13.739    36.435     0.200
    13.739    36.024     0.200
    13.786    39.464     0.200
    13.782    36.434     0.200
    13.782    34.306     0.200
    13.833    36.757     0.200
    13.835    40.052     0.200
    14.043    34.980     0.200
    14.299    34.722     0.200
    14.651    38.419     0.200
    14.651    39.875     0.200
    14.833    37.321     0.200
    15.151    36.217     0.200
    15.204    36.202     0.200
    15.204    38.730     0.200
    16.071    38.865     0.200
    16.071    38.710     0.200
    16.364    38.374     0.200
    16.364    40.188     0.200
    16.517    40.572     0.200
    16.521    38.540     0.200
    16.605    38.425     0.200
    16.605    39.811     0.200
    16.685    38.960     0.200
    16.685    39.213     0.200
    17.419    40.084     0.200
    17.540    40.288     0.200
    17.870    40.266     0.200
    17.963    40.384     0.200
    18.170    39.921     0.200
    18.229    39.500     0.200
    18.267    40.230     0.200
    18.314    40.023     0.200
    18.330    39.865     0.200
    18.369    39.849     0.200
    18.370    39.821     0.200
    18.462    40.700     0.200
    18.669    40.799     0.200
    18.754    40.743     0.200
    18.754    42.079     0.200
    18.837    41.210     0.200
    18.860    41.319     0.200
    18.860    43.241     0.200
    18.936    40.827     0.200
    18.935    40.914     0.200
    18.975    40.762     0.200
    18.975    41.793     0.200
    18.977    42.874     0.200
    18.981    41.042     0.200
    18.981    42.594     0.200
    18.993    41.109     0.200
    19.118    41.249     0.200
    19.163    40.627     0.200
    19.304    40.651     0.200
    19.397    40.715     0.200
    19.425    40.635     0.200
    19.425    40.794     0.200
    19.579    40.599     0.200
    19.567    41.050     0.200
    19.591    40.726     0.200
    19.585    41.071     0.200
    19.624    40.976     0.200
    19.811    42.097     0.200
    19.913    41.955     0.200
    20.084    42.175     0.200
    20.127    40.514     0.200
    20.180    40.827     0.200
    20.201    40.467     0.200
    20.201    40.840     0.200
    20.239    41.867     0.200
    20.539    40.497     0.200
    20.670    40.318     0.200
    20.831    41.555     0.200
    20.903    41.967     0.200
     1.412     7.005     0.200
     1.458     6.813     0.200
     1.490     8.414     0.200
     1.675     8.550     0.200
     1.675     9.079     0.200
     1.712     7.606     0.200
     1.715     7.565     0.200
     1.957     8.631     0.200
     2.122     9.255     0.200
     2.124     8.352     0.200
     2.596     9.866     0.200
     2.838    11.129     0.200
     3.824    13.064     0.200
     3.914    14.434     0.200
     4.297    15.469     0.200
     4.647    16.769     0.200
     4.896    17.524     0.200
     5.041    16.538     0.200
     5.221    18.079     0.200
     7.247    21.498     0.200
     7.503    24.280     0.200
     7.524    22.285     0.200
    10.403    29.261     0.200
    11.487    30.735     0.200
     0.946     4.767     0.200
     0.946     5.101     0.200
     1.426     6.796     0.200
     1.460     6.651     0.200
     1.664     8.537     0.200
     1.685     7.102     0.200
     1.707     7.801     0.200
     1.710     7.499     0.200
     1.710     7.760     0.200
     1.889     7.703     0.200
     1.961     7.953     0.200
     2.114     8.861     0.200
     2.137     8.151     0.200
     2.319     8.833     0.200
     2.462    10.194     0.200
     2.598     9.571     0.200
     2.629     9.745     0.200
     2.761     9.950     0.200
     2.831    10.701     0.200
     2.840    10.295     0.200
     2.876    10.297     0.200
     2.879    11.973     0.200
     2.927    10.427     0.200
     3.019    10.384     0.200
     3.130    11.433     0.200
     3.259    11.043     0.200
     3.271    11.061     0.200
     3.338    11.352     0.200
     3.490    12.002     0.200
     3.680    12.676     0.200
     3.702    12.444     0.200
     3.702    16.103     0.200
     3.735    12.275     0.200
     3.735    14.609     0.200
     3.822    12.322     0.200
     3.838    11.491     0.200
     3.926    14.344     0.200
     4.047    13.212     0.200
     4.141    13.290     0.200
     4.254    13.303     0.200
     4.300    14.987     0.200
     4.343    13.806     0.200
     4.343    15.064     0.200
     4.487    15.375     0.200
     4.619    14.839     0.200
     4.659    16.143     0.200
     4.659    16.735     0.200
     4.798    15.261     0.200
     4.803    15.578     0.200
     4.803    17.055     0.200
     4.905    17.534     0.200
     4.916    15.106     0.200
     4.916    19.198     0.200
     4.988    14.400     0.200
     5.054    16.740     0.200
     5.079    15.983     0.200
     5.097    17.175     0.200
     5.228    17.875     0.200
     5.410    16.685     0.200
     5.488    17.553     0.200
     5.488    18.373     0.200
     5.577    19.062     0.200
     5.688    19.135     0.200
     5.787    19.112     0.200
     6.062    19.571     0.200
     6.143    18.179     0.200
     6.143    19.167     0.200
     6.195    21.650     0.200
     6.243    21.477     0.200
     6.369    22.340     0.200
     6.378    18.281     0.200
     6.434    20.736     0.200
     6.641    21.004     0.200
     6.682    25.254     0.200
     6.682    21.287     0.200
     6.802    24.646     0.200
     7.138    26.231     0.200
     7.155    21.786     0.200
     7.188    21.082     0.200
     7.261    20.966     0.200
     7.283    21.207     0.200
     7.283    21.209     0.200
     7.494    21.600     0.200
     7.515    22.241     0.200
     7.515    22.911     0.200
     7.537    21.853     0.200
     7.571    21.872     0.200
     7.766    26.815     0.200
     7.880    22.466     0.200
     7.882    23.148     0.200
     7.882    22.672     0.200
     7.882    22.638     0.200
     7.911    28.535     0.200
     7.922    26.519     0.200
     8.018    25.872     0.200
     8.029    25.660     0.200
     8.055    26.105     0.200
     8.062    25.684     0.200
     8.095    25.487     0.200
     8.101    26.203     0.200
     8.153    27.660     0.200
     8.271    26.527     0.200
     8.292    26.144     0.200
     8.350    27.665     0.200
     8.454    22.530     0.200
     8.454    22.716     0.200
     8.532    26.298     0.200
     8.675    28.086     0.200
     8.892    25.023     0.200
     8.892    25.811     0.200
     8.903    27.779     0.200
     8.946    29.469     0.200
     8.950    29.624     0.200
     9.192    28.582     0.200
     9.278    26.972     0.200
     9.379    29.684     0.200
     9.628    26.863     0.200
     9.797    30.501     0.200
     9.718    29.405     0.200
     9.765    27.619     0.200
     9.765    29.869     0.200
     9.767    27.509     0.200
     9.777    29.499     0.200
     9.858    30.463     0.200
    10.240    30.612     0.200
    10.415    28.764     0.200
    10.416    29.055     0.200
    10.473    33.397     0.200
    10.669    30.509     0.200
    10.915    31.820     0.200
    11.066    33.834     0.200
    11.201    34.244     0.200
    11.201    34.586     0.200
    11.207    34.074     0.200
    11.369    33.861     0.200
    11.369    35.083     0.200
    11.404    35.732     0.200
    11.418    35.608     0.200
    11.494    34.731     0.200
    11.495    36.390     0.200
    11.495    31.919     0.200
    11.495    33.310     0.200
    11.686    30.569     0.200
    11.686    31.733     0.200
    11.689    34.339     0.200
    11.787    34.948     0.200
    11.807    34.665     0.200
    11.910    34.107     0.200
    11.933    34.465     0.200
    11.985    35.711     0.200
    12.016    35.204     0.200
    12.031    36.195     0.200
    12.080    34.652     0.200
    12.176    35.225     0.200
    12.261    32.846     0.200
    12.393    37.600     0.200
    12.407    35.865     0.200
    12.562    36.954     0.200
    12.731    35.036     0.200
    12.732    38.118     0.200
    12.758    38.180     0.200
    12.828    38.167     0.200
    12.853    34.210     0.200
    12.907    38.953     0.200
    12.941    37.914     0.200
    13.009    37.679     0.200
    13.249    35.726     0.200
    13.249    36.363     0.200
    13.315    38.866     0.200
    13.370    35.538     0.200
    13.370    36.376     0.200
    13.378    39.686     0.200
    13.574    38.557     0.200
    13.682    37.096     0.200
    13.737    34.468     0.200
    13.737    37.726     0.200
    13.786    40.014     0.200
    14.033    34.524     0.200
    14.033    35.891     0.200
    14.652    37.864     0.200
    15.140    36.696     0.200
    15.140    37.923     0.200
    15.193    37.318     0.200
    15.193    38.760     0.200
    16.068    39.073     0.200
    16.068    39.302     0.200
    16.108    39.183     0.200
    16.363    38.866     0.200
    16.595    38.624     0.200
    16.595    39.800     0.200
    17.529    39.891     0.200
    17.860    40.217     0.200
    17.953    40.331     0.200
    18.129    40.407     0.200
    18.159    39.954     0.200
    18.304    40.532     0.200
    18.320    40.047     0.200
    18.360    40.083     0.200
    18.662    41.115     0.200
    18.744    41.471     0.200
    18.827    41.165     0.200
    18.849    42.540     0.200
    18.925    41.313     0.200
    18.967    41.820     0.200
    18.971    42.671     0.200
    18.983    41.199     0.200
    19.109    41.127     0.200
    19.415    41.552     0.200
    19.557    42.953     0.200
    19.613    40.732     0.200
    19.905    41.237     0.200
    20.179    41.575     0.200
    20.230    41.641     0.200
    20.510    40.620     0.200
    20.529    40.791     0.200
    20.824    41.347     0.200
    20.893    41.446     0.200
    20.973    41.428     0.200
     1.167     8.663     0.200
     1.168     8.398     0.200
     1.236     7.765     0.200
     1.255     7.772     0.200
     1.255     8.042     0.200
     1.301     7.926     0.200
     1.408     7.150     0.200
     1.450     6.765     0.200
     1.670     7.343     0.200
     1.670     7.556     0.200
     1.706     7.668     0.200
     1.708     7.553     0.200
     1.883     7.730     0.200
     1.949     8.084     0.200
     2.124     7.932     0.200
     2.117     9.053     0.200
     2.460    10.095     0.200
     2.588     9.854     0.200
     2.615    10.034     0.200
     2.833    11.063     0.200
     2.867    11.940     0.200
     2.884    11.231     0.200
     3.115    12.785     0.200
     3.333    13.340     0.200
     3.908    14.202     0.200
     4.289    15.022     0.200
     4.483    16.484     0.200
     4.641    16.642     0.200
     4.889    16.928     0.200
     5.036    16.608     0.200
     5.082    17.080     0.200
     5.188    16.889     0.200
     5.213    17.339     0.200
     5.562    18.664     0.200
     5.673    18.870     0.200
     6.132    19.121     0.200
     6.421    20.622     0.200
     6.677    23.249     0.200
     6.786    25.096     0.200
     7.244    21.305     0.200
     7.497    23.810     0.200
     7.520    22.091     0.200
     7.865    24.752     0.200
     8.012    25.606     0.200
     8.044    25.877     0.200
     8.078    25.805     0.200
     8.084    26.668     0.200
     8.254    26.412     0.200
     8.275    27.120     0.200
     8.440    23.291     0.200
     8.521    28.054     0.200
     8.671    29.578     0.200
     8.931    29.437     0.200
     9.844    32.295     0.200
     9.892    27.612     0.200
    10.404    29.419     0.200
    10.405    29.263     0.200
    11.198    34.817     0.200
    11.198    35.268     0.200
    11.398    36.245     0.200
    11.479    35.343     0.200
    11.773    35.167     0.200
    11.896    34.655     0.200
    12.388    38.169     0.200
    13.356    37.445     0.200
    13.568    39.589     0.200
     0.931     4.859     0.200
     0.979     4.913     0.200
     0.979     5.195     0.200
     1.104     7.500     0.200
     1.104     7.445     0.200
     1.212     7.550     0.200
     1.245     6.814     0.200
     1.244     7.304     0.200
     1.320     7.850     0.200
     1.524     6.856     0.200
     1.720     7.072     0.200
     1.739     8.618     0.200
     1.739     9.048     0.200
     1.770     7.725     0.200
     1.786     7.751     0.200
     1.789     7.564     0.200
     1.789     7.720     0.200
     1.962     7.743     0.200
     2.017     7.914     0.200
     2.077     7.772     0.200
     2.663     9.527     0.200
     3.787    11.362     0.200
     4.358    15.315     0.200
     4.665    16.301     0.200
     5.136    17.138     0.200
     5.476    17.967     0.200
     5.619    18.726     0.200
     5.728    18.526     0.200
     5.819    19.397     0.200
     6.204    18.140     0.200
     6.409    20.799     0.200
     6.952    20.238     0.200
     7.157    21.312     0.200
     7.503    22.003     0.200
     7.855    24.369     0.200
     7.986    25.672     0.200
     8.001    25.798     0.200
     8.003    25.829     0.200
     8.032    25.510     0.200
     8.037    26.322     0.200
     8.041    25.401     0.200
     8.047    25.880     0.200
     8.061    26.127     0.200
     8.066    25.814     0.200
     8.112    25.774     0.200
     8.204    26.764     0.200
     8.281    26.597     0.200
     8.399    22.641     0.200
     9.726    29.117     0.200
    10.349    28.712     0.200
     0.943     4.817     0.200
     0.989     4.957     0.200
     0.989     5.074     0.200
     1.092     8.048     0.200
     1.092     8.548     0.200
     1.217     7.534     0.200
     1.217     7.385     0.200
     1.249     7.236     0.200
     1.328     7.518     0.200
     1.536     6.699     0.200
     1.746     8.510     0.200
     1.746     8.693     0.200
     1.781     7.653     0.200
     1.798     7.521     0.200
     1.801     7.556     0.200
     2.029     8.294     0.200
     2.074     7.702     0.200
     2.204     8.725     0.200
     2.675     9.546     0.200
     2.959    10.808     0.200
     2.948    11.808     0.200
     3.154    10.834     0.200
     3.201    12.467     0.200
     4.370    15.283     0.200
     4.672    15.543     0.200
     4.672    16.246     0.200
     5.147    17.393     0.200
     5.480    17.039     0.200
     5.480    17.993     0.200
     6.328    17.633     0.200
     7.523    24.148     0.200
     8.119    26.782     0.200
    10.344    29.264     0.200
     0.868     4.461     0.200
     1.049     5.188     0.200
     1.139     5.631     0.200
     1.139     5.490     0.200
     1.227     5.888     0.200
     1.181     7.126     0.200
     1.264     7.290     0.200
     1.610     6.946     0.200
     1.619     8.043     0.200
     1.596     7.194     0.200
     1.668     6.905     0.200
     1.818     9.537     0.200
     1.820     9.532     0.200
     1.932     8.373     0.200
     2.008     8.533     0.200
     2.001     7.789     0.200
     2.031     9.234     0.200
     2.043     8.069     0.200
     2.054     8.217     0.200
     2.034     9.043     0.200
     2.156    10.649     0.200
     2.203    11.318     0.200
     2.211     8.968     0.200
     2.261     8.710     0.200
     2.357     8.917     0.200
     2.451     9.794     0.200
     2.579     9.612     0.200
     2.605    10.037     0.200
     2.659     9.673     0.200
     2.782    10.621     0.200
     2.827    13.112     0.200
     2.870    10.179     0.200
     2.881    10.909     0.200
     2.984    10.653     0.200
     2.934     9.668     0.200
     2.981    10.571     0.200
     3.118    10.723     0.200
     3.165    11.657     0.200
     3.239    11.348     0.200
     3.402    11.596     0.200
     3.412    11.895     0.200
     3.458    11.679     0.200
     3.468    11.650     0.200
     3.468    11.422     0.200
     3.712    12.843     0.200
     3.730    11.748     0.200
     3.807    12.696     0.200
     3.816    13.068     0.200
     3.909    12.785     0.200
     3.989    13.106     0.200
     4.080    13.433     0.200
     4.164    13.897     0.200
     4.251    14.132     0.200
     4.329    14.460     0.200
     4.501    17.784     0.200
     4.548    14.362     0.200
     4.548    13.583     0.200
     4.600    14.982     0.200
     4.806    15.929     0.200
     4.806    15.699     0.200
     4.832    16.066     0.200
     5.451    16.980     0.200
     5.579    17.332     0.200
     5.579    16.460     0.200
     5.813    18.444     0.200
     5.813    18.340     0.200
     5.909    18.708     0.200
     5.909    18.278     0.200
     5.906    18.404     0.200
     5.988    17.215     0.200
     6.152    18.824     0.200
     6.287    18.826     0.200
     6.313    20.170     0.200
     6.460    19.414     0.200
     6.403    20.371     0.200
     6.686    19.870     0.200
     6.895    21.425     0.200
     7.052    19.913     0.200
     7.099    21.447     0.200
     7.300    22.502     0.200
     7.395    22.172     0.200
     7.689    22.463     0.200
     7.673    22.459     0.200
     7.685    21.725     0.200
     7.784    21.853     0.200
     7.810    25.625     0.200
     7.851    24.540     0.200
     7.873    24.967     0.200
     8.031    25.875     0.200
     8.025    24.449     0.200
     8.030    24.648     0.200
     8.030    24.604     0.200
     8.033    24.265     0.200
     8.042    23.503     0.200
     8.049    24.198     0.200
     8.061    24.369     0.200
     8.069    25.337     0.200
     8.071    25.088     0.200
     8.075    24.697     0.200
     8.067    22.485     0.200
     8.089    24.823     0.200
     8.085    22.323     0.200
     8.108    25.024     0.200
     8.111    25.070     0.200
     8.143    25.031     0.200
     8.167    25.444     0.200
     8.203    24.880     0.200
     8.221    25.599     0.200
     8.295    24.969     0.200
     8.340    24.276     0.200
     9.085    27.159     0.200
     9.145    28.008     0.200
     9.177    24.538     0.200
     9.378    26.211     0.200
     9.538    28.356     0.200
     9.712    28.064     0.200
     9.794    28.366     0.200
    10.011    28.331     0.200
    10.737    32.983     0.200
    11.008    30.183     0.200
    11.247    31.821     0.200
    11.247    31.929     0.200
    11.247    32.188     0.200
    11.243    30.916     0.200
    11.233    29.729     0.200
    11.234    29.790     0.200
    11.499    33.282     0.200
    11.563    33.380     0.200
    11.658    33.084     0.200
    11.743    32.467     0.200
    12.064    32.572     0.200
    12.303    37.092     0.200
    12.786    37.367     0.200
    13.335    33.793     0.200
    13.431    34.052     0.200
    13.806    37.282     0.200
    13.846    37.001     0.200
    14.136    38.328     0.200
    14.303    38.768     0.200
    15.831    39.337     0.200
    18.864    39.973     0.200
    19.494    42.668     0.200
    20.957    41.669     0.200
     0.955     4.921     0.200
     0.986     5.007     0.200
     1.236     7.557     0.200
     1.236     7.407     0.200
     1.269     7.157     0.200
     1.272     6.874     0.200
     1.347     7.396     0.200
     1.542     6.852     0.200
     1.571     7.665     0.200
     1.728     7.356     0.200
     1.765     8.414     0.200
     1.796     7.663     0.200
     1.812     7.520     0.200
     1.814     7.479     0.200
     1.984     7.810     0.200
     2.032     7.929     0.200
     2.054     8.048     0.200
     2.221     8.887     0.200
     2.357     8.972     0.200
     2.566    10.234     0.200
     2.681    10.075     0.200
     2.938    11.057     0.200
     2.951    11.829     0.200
     2.977    10.880     0.200
     3.170    12.738     0.200
     3.766    11.518     0.200
     3.766    11.173     0.200
     3.797    15.640     0.200
     4.247    13.968     0.200
     4.374    15.461     0.200
     4.448    15.592     0.200
     4.587    16.271     0.200
     4.662    15.832     0.200
     4.662    16.246     0.200
     4.725    15.456     0.200
     4.810    17.060     0.200
     4.890    16.563     0.200
     5.095    16.923     0.200
     5.144    16.837     0.200
     5.270    17.437     0.200
     5.466    17.913     0.200
     5.628    17.792     0.200
     5.736    17.692     0.200
     5.825    18.695     0.200
     6.221    19.128     0.200
     6.309    18.171     0.200
     6.345    20.103     0.200
     6.410    19.411     0.200
     6.495    20.978     0.200
     6.737    21.010     0.200
     6.845    20.956     0.200
     6.859    20.332     0.200
     7.142    21.292     0.200
     7.212    21.167     0.200
     7.487    22.107     0.200
     7.512    23.540     0.200
     7.523    21.432     0.200
     7.590    22.459     0.200
     7.776    25.203     0.200
     7.841    22.110     0.200
     7.841    22.786     0.200
     7.868    25.167     0.200
     7.953    23.580     0.200
     7.984    24.506     0.200
     8.000    24.376     0.200
     8.001    24.058     0.200
     8.010    24.880     0.200
     8.031    24.113     0.200
     8.037    23.957     0.200
     8.040    24.132     0.200
     8.042    24.775     0.200
     8.046    24.787     0.200
     8.059    24.499     0.200
     8.064    24.522     0.200
     8.076    24.355     0.200
     8.103    24.596     0.200
     8.102    24.578     0.200
     8.110    25.625     0.200
     8.188    25.025     0.200
     8.204    24.945     0.200
     8.280    25.261     0.200
     8.289    23.523     0.200
     8.377    22.614     0.200
     8.508    25.364     0.200
     8.992    25.843     0.200
     9.723    28.233     0.200
     9.752    27.512     0.200
    10.325    28.036     0.200
    10.325    29.302     0.200
    10.918    31.828     0.200
    10.918    31.472     0.200
    11.536    31.593     0.200
     1.210     6.616     0.200
     1.210     7.389     0.200
     1.215     7.493     0.200
     1.269     5.974     0.200
     1.337     8.013     0.200
     1.332     6.193     0.200
     1.350     7.891     0.200
     1.350     7.944     0.200
     1.387     8.069     0.200
     1.567     6.365     0.200
     1.570     6.274     0.200
     1.570     6.500     0.200
     1.618     7.637     0.200
     1.618     7.516     0.200
     1.766     7.027     0.200
     2.011     8.015     0.200
     2.138     7.708     0.200
     2.409     8.633     0.200
     2.941    11.044     0.200
     3.795    12.932     0.200
     3.806    11.441     0.200
     4.106    12.925     0.200
     4.501    15.462     0.200
     4.725    16.219     0.200
     5.039    16.495     0.200
     5.202    15.131     0.200
     5.383    17.503     0.200
     5.496    17.949     0.200
     6.239    22.728     0.200
     7.011    22.156     0.200
     7.178    20.510     0.200
     7.363    22.567     0.200
     7.549    24.138     0.200
     7.863    23.183     0.200
     7.933    24.389     0.200
     8.014    23.499     0.200
     8.020    24.841     0.200
     8.745    24.333     0.200
    10.435    29.249     0.200
    11.047    33.965     0.200
     0.881     4.983     0.200
     0.947     4.654     0.200
     1.155     7.570     0.200
     1.155     7.484     0.200
     1.155     7.655     0.200
     1.174     7.069     0.200
     1.215     6.626     0.200
     1.243     7.219     0.200
     1.243     7.328     0.200
     1.428     6.690     0.200
     1.458     6.392     0.200
     1.465     7.851     0.200
     1.686     7.052     0.200
     1.686     6.947     0.200
     1.661     8.237     0.200
     1.661     8.349     0.200
     1.707     7.017     0.200
     1.707     7.131     0.200
     1.960     7.629     0.200
     2.140     7.803     0.200
     2.140     7.941     0.200
     2.111     8.662     0.200
     2.604     9.637     0.200
     2.596     9.300     0.200
     2.629     9.336     0.200
     2.828    10.525     0.200
     2.879    11.835     0.200
     2.873    10.794     0.200
     3.131    12.254     0.200
     3.108    12.963     0.200
     3.336    12.520     0.200
     3.732    13.081     0.200
     3.841    11.591     0.200
     3.928    13.363     0.200
     4.300    15.191     0.200
     4.340    14.840     0.200
     4.485    13.675     0.200
     4.660    16.131     0.200
     4.660    15.794     0.200
     4.802    17.067     0.200
     4.919    15.078     0.200
     4.906    16.720     0.200
     5.057    16.198     0.200
     5.204    15.647     0.200
     5.490    17.792     0.200
     5.490    17.350     0.200
     6.142    20.003     0.200
     6.142    18.570     0.200
     6.381    18.101     0.200
     6.680    22.204     0.200
     6.929    20.263     0.200
     7.190    21.186     0.200
     7.264    21.129     0.200
     7.286    21.108     0.200
     7.517    23.186     0.200
     7.540    21.566     0.200
     7.885    23.273     0.200
     7.885    22.433     0.200
     8.457    21.793     0.200
     8.457    22.815     0.200
     9.719    29.223     0.200
    10.419    28.963     0.200
    10.419    28.992     0.200
    10.420    28.963     0.200
    11.495    31.769     0.200
    18.299    36.907     0.200
     1.124     6.144     0.200
     1.205     7.497     0.200
     1.214     7.095     0.200
     1.248     6.781     0.200
     1.248     6.882     0.200
     1.295     5.956     0.200
     1.308     6.163     0.200
     1.333     8.213     0.200
     1.450     7.067     0.200
     1.482     7.486     0.200
     1.504     6.407     0.200
     1.600     6.515     0.200
     1.607     6.527     0.200
     1.656     7.859     0.200
     1.746     7.003     0.200
     1.785     7.162     0.200
     2.102     7.592     0.200
     2.138     8.761     0.200
     2.434     8.842     0.200
     2.862    10.628     0.200
     2.948    11.359     0.200
     2.997    11.311     0.200
     3.051    12.532     0.200
     3.051    14.141     0.200
     3.111    10.609     0.200
     3.202    12.817     0.200
     3.671    13.536     0.200
     3.779    13.160     0.200
     3.773    12.315     0.200
     3.773    12.999     0.200
     4.127    13.039     0.200
     4.357    12.777     0.200
     4.493    15.739     0.200
     4.493    15.954     0.200
     4.644    15.447     0.200
     4.726    16.433     0.200
     4.915    16.352     0.200
     4.920    15.573     0.200
     5.046    17.120     0.200
     5.167    14.628     0.200
     5.343    17.529     0.200
     5.343    16.681     0.200
     5.394    17.285     0.200
     5.506    18.192     0.200
     5.606    17.959     0.200
     5.973    18.448     0.200
     5.973    18.674     0.200
     6.122    16.715     0.200
     6.254    17.414     0.200
     6.305    18.894     0.200
     6.305    17.179     0.200
     6.305    18.437     0.200
     6.500    18.730     0.200
     6.543    19.404     0.200
     6.543    18.775     0.200
     6.619    18.880     0.200
     6.794    19.429     0.200
     7.013    20.057     0.200
     7.047    19.720     0.200
     7.152    20.931     0.200
     7.177    21.260     0.200
     7.353    23.159     0.200
     7.430    22.291     0.200
     7.761    20.981     0.200
    10.398    27.395     0.200
    11.312    33.793     0.200
    11.312    33.793     0.200
     0.898     4.756     0.200
     0.950     4.832     0.200
     1.201     7.524     0.200
     1.220     6.850     0.200
     1.229     7.270     0.200
     1.393     6.791     0.200
     1.691     7.373     0.200
     1.718     8.365     0.200
     1.718     8.560     0.200
     1.758     7.337     0.200
     1.983     8.061     0.200
     2.087     8.073     0.200
     2.585     9.924     0.200
     2.629     9.794     0.200
     2.930    10.962     0.200
     3.136    12.578     0.200
     3.164    13.368     0.200
     3.792    11.556     0.200
     3.792    13.220     0.200
     3.902    13.608     0.200
     4.325    15.288     0.200
     4.645    15.767     0.200
     4.645    15.368     0.200
     4.904    16.666     0.200
     5.025    15.670     0.200
     5.150    16.297     0.200
     5.106    16.276     0.200
     5.234    17.008     0.200
     5.462    17.886     0.200
     5.462    17.347     0.200
     5.588    18.217     0.200
     5.698    17.268     0.200
     5.791    17.597     0.200
     6.333    18.297     0.200
     6.333    18.574     0.200
     7.224    20.740     0.200
     7.498    22.733     0.200
     7.848    23.094     0.200
     8.406    23.068     0.200
     8.873    24.652     0.200
    10.363    28.832     0.200
    10.363    28.818     0.200
     0.922     5.052     0.200
     0.962     4.585     0.200
     1.128     5.419     0.200
     1.143     5.109     0.200
     1.115     5.825     0.200
     1.198     6.632     0.200
     1.216     6.702     0.200
     1.231     6.286     0.200
     1.233     6.274     0.200
     1.240     6.838     0.200
     1.287     5.890     0.200
     1.383     6.163     0.200
     1.385     7.026     0.200
     1.420     6.230     0.200
     1.406     7.135     0.200
     1.409     7.331     0.200
     1.438     6.489     0.200
     1.440     7.488     0.200
     1.457     7.343     0.200
     1.501     8.829     0.200
     1.554     7.223     0.200
     1.502     8.852     0.200
     1.626     7.188     0.200
     1.682     7.589     0.200
     1.678     7.937     0.200
     1.699     8.130     0.200
     1.724     7.499     0.200
     1.790     8.573     0.200
     1.980     9.562     0.200
     1.851     8.728     0.200
     1.835     9.446     0.200
     1.949     8.950     0.200
     1.949     9.145     0.200
     1.965     9.373     0.200
     1.998     7.990     0.200
     2.001     8.134     0.200
     2.012     9.339     0.200
     2.012     8.397     0.200
     2.071     8.360     0.200
     2.072     8.380     0.200
     2.114     9.583     0.200
     2.145     8.601     0.200
     2.156     8.744     0.200
     2.176     9.566     0.200
     2.184     9.075     0.200
     2.227     9.480     0.200
     2.326     9.750     0.200
     2.364     9.436     0.200
     2.368     9.750     0.200
     2.398    10.378     0.200
     2.437     9.429     0.200
     2.445     9.391     0.200
     2.452    10.512     0.200
     2.556     9.833     0.200
     2.542     9.882     0.200
     2.745     9.854     0.200
     2.874    10.560     0.200
     2.907    10.487     0.200
     2.942    10.830     0.200
     2.962     9.976     0.200
     3.025    11.350     0.200
     3.025    11.983     0.200
     3.055    10.796     0.200
     3.248    11.592     0.200
     3.302    11.926     0.200
     3.355    12.130     0.200
     3.468    12.588     0.200
     3.504    11.914     0.200
     3.747    13.063     0.200
     3.800    12.785     0.200
     3.870    13.628     0.200
     4.210    14.238     0.200
     4.261    13.862     0.200
     4.312    14.400     0.200
     4.516    14.971     0.200
     4.552    14.965     0.200
     4.641    14.021     0.200
     4.687    15.506     0.200
     4.696    16.030     0.200
     4.929    16.659     0.200
     5.126    16.450     0.200
     5.126    17.237     0.200
     5.201    17.222     0.200
     5.421    17.586     0.200
     5.677    18.187     0.200
     5.676    19.542     0.200
     5.719    19.778     0.200
     5.975    18.092     0.200
     5.975    18.474     0.200
     6.001    20.164     0.200
     6.027    17.359     0.200
     6.084    18.995     0.200
     6.109    17.804     0.200
     6.494    20.112     0.200
     6.556    21.400     0.200
     6.566    20.309     0.200
     6.629    23.330     0.200
     6.815    20.643     0.200
     6.963    22.916     0.200
     7.014    21.898     0.200
     7.170    20.356     0.200
     7.170    20.707     0.200
     7.215    22.830     0.200
     7.583    19.620     0.200
     7.981    22.870     0.200
     8.164    22.594     0.200
     8.261    23.962     0.200
     8.275    23.661     0.200
     8.383    24.297     0.200
     8.566    23.721     0.200
     8.566    25.138     0.200
     9.266    25.218     0.200
     9.401    27.855     0.200
    10.313    27.371     0.200
    11.246    31.148     0.200
    11.246    30.926     0.200
    12.788    32.727     0.200
    12.788    33.293     0.200
     0.839     3.585     0.200
     1.079     4.684     0.200
     1.149     6.375     0.200
     1.225     6.840     0.200
     1.295     5.946     0.200
     1.331     6.308     0.200
     1.320     5.895     0.200
     1.327     7.885     0.200
     1.327     6.719     0.200
     1.374     6.000     0.200
     1.545     4.569     0.200
     1.427     7.026     0.200
     1.424     7.994     0.200
     1.516     8.194     0.200
     1.544     7.127     0.200
     1.570     7.684     0.200
     1.588     6.797     0.200
     1.592     6.636     0.200
     1.594     6.606     0.200
     1.635     7.081     0.200
     1.634     8.059     0.200
     1.634     7.770     0.200
     1.656     7.317     0.200
     1.736     5.426     0.200
     1.741     7.363     0.200
     1.789     7.491     0.200
     2.033     8.412     0.200
     2.125     7.899     0.200
     2.125     7.675     0.200
     2.125     8.095     0.200
     2.434     8.987     0.200
     2.463     9.514     0.200
     2.960    11.391     0.200
     2.981    11.046     0.200
     3.034    11.682     0.200
     3.195    11.327     0.200
     3.654    12.453     0.200
     3.800    12.850     0.200
     3.800    13.140     0.200
     3.797    11.897     0.200
     3.797    12.121     0.200
     4.130    13.892     0.200
     4.230    13.818     0.200
     4.512    15.782     0.200
     4.642    14.255     0.200
     4.926    15.479     0.200
     5.058    15.751     0.200
     5.516    16.452     0.200
     5.618    17.414     0.200
     5.975    17.994     0.200
     5.975    18.265     0.200
     6.064    17.567     0.200
     6.113    16.904     0.200
     6.261    17.764     0.200
     6.329    17.910     0.200
     7.338    19.428     0.200
     7.373    23.043     0.200
     7.784    23.555     0.200
     7.784    20.847     0.200
     7.834    20.427     0.200
     7.843    20.949     0.200
     7.985    20.752     0.200
     8.000    20.295     0.200
     8.039    20.592     0.200
     8.774    22.383     0.200
     9.384    24.119     0.200
     9.604    23.792     0.200
    10.419    25.848     0.200
    12.558    32.418     0.200
    12.866    32.175     0.200
     0.810     4.628     0.200
     0.870     3.812     0.200
     0.910     4.443     0.200
     1.084     4.859     0.200
     1.293     5.985     0.200
     1.338     7.864     0.200
     1.339     7.922     0.200
     1.541     7.424     0.200
     1.454     6.759     0.200
     1.462     7.256     0.200
     1.606     6.569     0.200
     1.613     6.487     0.200
     1.613     6.635     0.200
     1.668     7.923     0.200
     1.689     7.895     0.200
     1.967     7.841     0.200
     2.089     7.668     0.200
     2.089     8.059     0.200
     2.089     7.543     0.200
     3.006    12.461     0.200
     3.162    14.157     0.200
     3.759    12.542     0.200
     4.481    15.197     0.200
     4.973    15.810     0.200
     5.038    16.043     0.200
     5.330    17.033     0.200
     5.387    16.496     0.200
     5.498    17.542     0.200
     5.597    17.339     0.200
     5.919    17.125     0.200
     6.248    19.239     0.200
     6.291    18.275     0.200
     6.611    18.065     0.200
     7.847    24.341     0.200
     7.852    22.300     0.200
     7.915    24.766     0.200
     8.384    22.352     0.200
     9.578    24.291     0.200
    11.795    30.482     0.200
    11.851    29.714     0.200
     0.815     4.478     0.200
     0.910     4.713     0.200
     1.085     4.678     0.200
     1.111     5.282     0.200
     1.140     5.937     0.200
     1.195     5.325     0.200
     1.191     6.777     0.200
     1.225     7.451     0.200
     1.266     6.563     0.200
     1.293     6.012     0.200
     1.347     5.668     0.200
     1.326     8.017     0.200
     1.341     7.923     0.200
     1.377     5.925     0.200
     1.341     8.028     0.200
     1.540     5.515     0.200
     1.458     6.605     0.200
     1.467     6.910     0.200
     1.558     8.438     0.200
     1.581     7.389     0.200
     1.601     6.424     0.200
     1.613     6.421     0.200
     1.614     6.720     0.200
     1.606     7.451     0.200
     1.616     6.669     0.200
     1.616     6.310     0.200
     1.651     7.407     0.200
     1.660     6.964     0.200
     1.681     7.564     0.200
     1.673     7.645     0.200
     1.673     8.013     0.200
     1.694     7.616     0.200
     1.700     6.878     0.200
     1.749     6.960     0.200
     1.744     7.181     0.200
     1.780     7.371     0.200
     1.941     7.854     0.200
     1.968     8.093     0.200
     1.971     7.778     0.200
     2.006     8.008     0.200
     2.063     7.968     0.200
     2.125     8.337     0.200
     2.303     9.073     0.200
     2.433     8.823     0.200
     3.110    10.589     0.200
     3.165     8.413     0.200
     3.753    12.344     0.200
     3.753    11.235     0.200
     4.476    15.745     0.200
     5.034    15.664     0.200
     5.238    18.162     0.200
     5.324    17.652     0.200
     5.920    17.510     0.200
     6.246    17.111     0.200
     6.546    19.907     0.200
     6.650    16.615     0.200
     7.312    19.334     0.200
     7.335    22.873     0.200
     7.741    22.095     0.200
     7.788    18.418     0.200
     7.810    19.040     0.200
     7.847    20.312     0.200
     7.912    19.726     0.200
     7.959    19.889     0.200
     8.080    21.711     0.200
     8.084    23.844     0.200
     8.354    24.714     0.200
    10.378    27.383     0.200
    10.379    29.040     0.200
    11.301    31.639     0.200
    12.002    28.925     0.200
     0.858     3.632     0.200
     0.911     4.832     0.200
     1.081     4.630     0.200
     1.101     5.189     0.200
     1.122     5.650     0.200
     1.181     5.557     0.200
     1.245     6.320     0.200
     1.245     7.007     0.200
     1.293     6.090     0.200
     1.333     5.929     0.200
     1.334     7.852     0.200
     1.374     6.085     0.200
     1.335     7.909     0.200
     1.406     6.383     0.200
     1.543     5.404     0.200
     1.442     6.920     0.200
     1.448     7.092     0.200
     1.444     7.753     0.200
     1.480     7.615     0.200
     1.562     7.423     0.200
     1.587     7.359     0.200
     1.590     6.135     0.200
     1.600     6.918     0.200
     1.600     6.668     0.200
     1.602     6.409     0.200
     1.605     6.610     0.200
     1.605     6.329     0.200
     1.637     7.086     0.200
     1.647     7.158     0.200
     1.653     7.864     0.200
     1.653     8.098     0.200
     1.678     7.492     0.200
     1.731     7.272     0.200
     1.718     5.947     0.200
     1.956     7.942     0.200
     2.048     7.699     0.200
     2.104     7.623     0.200
     2.433     8.675     0.200
     2.834    13.141     0.200
     2.859     9.844     0.200
     2.995    12.051     0.200
     3.049    12.624     0.200
     3.669    11.796     0.200
     3.775     9.944     0.200
     4.125    13.536     0.200
     4.494    15.715     0.200
     5.027    16.244     0.200
     4.984    16.936     0.200
     5.338    16.997     0.200
     5.344    16.686     0.200
     5.505    18.252     0.200
     5.971    18.032     0.200
     6.253    18.161     0.200
     6.307    18.457     0.200
     6.307    17.355     0.200
     6.443    18.594     0.200
     6.498    19.383     0.200
     6.619    17.953     0.200
     6.629    17.690     0.200
     6.655    19.862     0.200
     7.045    20.912     0.200
     7.357    20.282     0.200
     7.354    22.876     0.200
     7.432    21.734     0.200
     7.595    23.853     0.200
     7.763    22.691     0.200
     7.763    22.371     0.200
     7.805    21.572     0.200
     7.859    23.806     0.200
     7.863    25.361     0.200
     7.878    24.312     0.200
     7.929    24.270     0.200
     7.929    21.374     0.200
     8.100    21.133     0.200
     8.400    22.918     0.200
    10.399    27.861     0.200
    10.399    27.875     0.200
    10.400    28.742     0.200
    10.400    28.274     0.200
    11.312    32.499     0.200
    15.245    33.312     0.200
     0.850     4.516     0.200
     0.854     4.788     0.200
     0.858     4.691     0.200
     0.891     4.456     0.200
     0.987     4.831     0.200
     0.972     5.284     0.200
     0.988     4.896     0.200
     1.017     5.176     0.200
     1.127     5.412     0.200
     1.192     5.883     0.200
     1.366     6.834     0.200
     1.377     8.224     0.200
     1.577     6.847     0.200
     1.589     7.597     0.200
     1.643     6.930     0.200
     1.909     8.045     0.200
     2.008     8.073     0.200
     2.001     8.049     0.200
     2.020     8.220     0.200
     2.184    11.185     0.200
     2.879    11.806     0.200
     2.939     9.444     0.200
     3.096    11.663     0.200
     3.204    12.373     0.200
     3.395    12.229     0.200
     3.441    12.933     0.200
     3.455    13.035     0.200
     3.772    13.140     0.200
     3.992    14.268     0.200
     4.129    14.006     0.200
     4.782    15.926     0.200
     4.790    14.869     0.200
     4.802    15.677     0.200
     5.001    16.078     0.200
     5.333    16.568     0.200
     5.435    17.065     0.200
     6.345    19.378     0.200
     7.047    19.939     0.200
     7.951    22.264     0.200
    11.213    31.313     0.200
    11.238    29.671     0.200
    11.470    28.723     0.200
     0.783     4.142     0.200
     0.786     4.462     0.200
     0.841     4.432     0.200
     0.885     4.580     0.200
     0.934     4.782     0.200
     0.963     4.387     0.200
     0.979     5.230     0.200
     1.016     4.968     0.200
     0.995     7.051     0.200
     1.018     4.951     0.200
     1.112     5.425     0.200
     1.338     5.835     0.200
     1.188     6.964     0.200
     1.254     6.263     0.200
     1.327     7.126     0.200
     1.327     6.369     0.200
     1.341     7.522     0.200
     1.342     7.200     0.200
     1.367     7.036     0.200
     1.378     7.544     0.200
     1.402     5.892     0.200
     1.492     6.418     0.200
     1.464     8.042     0.200
     1.504     5.937     0.200
     1.520     5.823     0.200
     1.487     7.449     0.200
     1.553     6.276     0.200
     1.582     6.416     0.200
     1.570     6.263     0.200
     1.624     6.856     0.200
     1.642     7.656     0.200
     1.656     7.239     0.200
     1.660     8.078     0.200
     1.696     8.447     0.200
     1.747     8.890     0.200
     1.813     6.581     0.200
     1.825     6.903     0.200
     1.827     6.917     0.200
     1.842     8.584     0.200
     1.844     9.490     0.200
     1.868     7.453     0.200
     1.892     7.873     0.200
     1.945     7.271     0.200
     1.945     7.131     0.200
     2.046    10.484     0.200
     2.446     9.488     0.200
     2.630     9.263     0.200
     2.906     9.328     0.200
     3.067    12.027     0.200
     3.646    11.150     0.200
     3.646    10.811     0.200
     4.194    13.267     0.200
     4.303    14.643     0.200
     4.531    15.860     0.200
     4.817    16.133     0.200
     4.841    15.083     0.200
     4.889    15.252     0.200
     5.042    16.031     0.200
     5.162    16.691     0.200
     5.202    16.681     0.200
     5.530    17.727     0.200
     5.715    18.693     0.200
     6.157    18.446     0.200
     6.187    16.951     0.200
     6.187    17.111     0.200
     6.292    17.551     0.200
     6.660    18.848     0.200
     6.820    19.347     0.200
     7.707    22.076     0.200
     0.753     4.142     0.200
     0.855     4.339     0.200
     0.878     3.688     0.200
     1.066     4.905     0.200
     1.097     6.968     0.200
     1.184     5.526     0.200
     1.182     6.732     0.200
     1.219     7.295     0.200
     1.227     6.826     0.200
     1.290     6.252     0.200
     1.349     7.826     0.200
     1.551     4.476     0.200
     1.551     3.416     0.200
     1.551     4.666     0.200
     1.448     6.727     0.200
     1.457     6.963     0.200
     1.458     7.411     0.200
     1.485     6.558     0.200
     1.492     7.414     0.200
     1.551     7.971     0.200
     1.551     8.441     0.200
     1.605     6.464     0.200
     1.711     8.591     0.200
     1.711     6.278     0.200
     1.711     6.501     0.200
     2.238     8.209     0.200
     2.930     9.920     0.200
     3.054    12.395     0.200
     3.113     8.928     0.200
     3.194    10.447     0.200
     3.349    11.475     0.200
     3.610    11.525     0.200
     3.721    14.101     0.200
     3.760    11.745     0.200
     3.977    12.381     0.200
     4.112    14.219     0.200
     4.239    13.736     0.200
     4.324    13.704     0.200
     4.474    15.472     0.200
     4.548    14.449     0.200
     4.632    14.416     0.200
     4.707    15.716     0.200
     4.897    15.570     0.200
     4.901    15.271     0.200
     4.980    14.911     0.200
     5.028    16.642     0.200
     5.189    15.499     0.200
     5.462    16.830     0.200
     5.488    17.037     0.200
     5.587    17.507     0.200
     5.673    16.650     0.200
     5.959    17.214     0.200
     6.291    18.435     0.200
     6.291    18.305     0.200
     6.368    18.249     0.200
     6.535    19.453     0.200
     6.535    17.163     0.200
     6.641    18.179     0.200
     7.051    19.492     0.200
     7.160    20.625     0.200
     7.334    22.885     0.200
     7.743    21.204     0.200
     7.743    22.973     0.200
     7.922    19.116     0.200
     7.954    21.312     0.200
     8.045    21.766     0.200
     8.150    22.591     0.200
     8.191    22.211     0.200
     8.345    23.685     0.200
     9.318    25.243     0.200
    10.388    28.319     0.200
    11.077    33.036     0.200
    11.294    31.301     0.200
    14.102    32.128     0.200
    14.265    33.464     0.200
    14.632    34.579     0.200
    15.042    34.845     0.200
    15.616    34.768     0.200
    15.665    37.325     0.200
    15.928    37.380     0.200
    15.928    36.634     0.200
    16.468    37.915     0.200
    16.711    37.007     0.200
    17.039    36.534     0.200
    17.661    38.580     0.200
    18.098    38.033     0.200
    18.190    37.838     0.200
     0.797     4.358     0.200
     0.879     4.661     0.200
     0.898     4.798     0.200
     1.191     6.769     0.200
     1.374     4.069     0.200
     1.211     6.956     0.200
     1.281     7.079     0.200
     1.540     8.393     0.200
     1.665     5.763     0.200
     1.685     7.002     0.200
     1.737     7.138     0.200
     2.325     9.024     0.200
     2.587     9.632     0.200
     3.035     9.501     0.200
     3.144    11.526     0.200
     3.361    11.187     0.200
     3.551    11.388     0.200
     3.735    12.048     0.200
     3.740    11.337     0.200
     3.908    13.156     0.200
     4.156    13.958     0.200
     4.312    14.635     0.200
     4.646    16.041     0.200
     4.731    15.606     0.200
     4.780    16.477     0.200
     4.821    15.338     0.200
     4.884    14.737     0.200
     4.884    17.533     0.200
     5.220    17.094     0.200
     5.628    17.622     0.200
     5.727    18.249     0.200
     5.786    18.623     0.200
     6.156    18.690     0.200
     6.347    18.487     0.200
     6.474    18.778     0.200
     6.704    20.697     0.200
     6.843    21.075     0.200
     6.851    19.031     0.200
     7.383    20.471     0.200
     7.501    23.108     0.200
     7.501    23.373     0.200
     7.511    21.445     0.200
     7.858    23.044     0.200
     7.858    22.833     0.200
     7.858    23.278     0.200
     7.918    23.587     0.200
     7.978    25.137     0.200
     8.238    26.623     0.200
     8.422    22.723     0.200
     8.473    25.476     0.200
     8.544    24.202     0.200
     8.897    25.660     0.200
     8.952    26.144     0.200
     9.166    26.511     0.200
     9.547    26.567     0.200
     9.729    27.590     0.200
     9.861    29.950     0.200
     9.865    25.355     0.200
    10.220    27.808     0.200
    10.383    28.319     0.200
    10.574    29.327     0.200
    10.661    29.223     0.200
    10.903    31.368     0.200
    11.069    32.533     0.200
    11.227    31.752     0.200
    11.380    32.973     0.200
    11.477    31.182     0.200
    11.494    31.744     0.200
    12.542    32.728     0.200
    14.005    32.232     0.200
    14.005    36.044     0.200
    14.821    36.240     0.200
    15.110    33.872     0.200
    15.576    37.544     0.200
    15.609    40.526     0.200
    16.066    39.106     0.200
    16.123    40.839     0.200
    16.123    39.073     0.200
    16.159    37.795     0.200
    16.808    37.970     0.200
    17.040    36.851     0.200
    18.648    40.680     0.200
     0.678     3.622     0.200
     0.734     4.113     0.200
     0.889     4.414     0.200
     0.902     4.619     0.200
     0.954     4.702     0.200
     0.958     4.417     0.200
     0.970     4.449     0.200
     1.022     5.516     0.200
     1.042     6.072     0.200
     1.098     5.820     0.200
     1.128     4.856     0.200
     1.141     5.281     0.200
     1.144     5.296     0.200
     1.144     5.177     0.200
     1.150     5.566     0.200
     1.172     6.334     0.200
     1.190     5.787     0.200
     1.193     5.824     0.200
     1.194     5.713     0.200
     1.214     5.631     0.200
     1.252     6.173     0.200
     1.269     6.708     0.200
     1.281     5.986     0.200
     1.297     5.221     0.200
     1.315     6.449     0.200
     1.314     5.370     0.200
     1.383     5.972     0.200
     1.410     6.196     0.200
     1.465     6.671     0.200
     1.478     6.472     0.200
     1.486     6.335     0.200
     1.513     6.542     0.200
     1.513     6.620     0.200
     1.504     6.337     0.200
     1.545     6.584     0.200
     1.807     7.335     0.200
     1.988     7.276     0.200
     1.883     8.424     0.200
     2.137     7.131     0.200
     2.153     8.448     0.200
     2.300     8.752     0.200
     2.452     8.152     0.200
     2.556     9.815     0.200
     2.616    10.117     0.200
     2.718     9.844     0.200
     2.723    10.692     0.200
     2.746    10.010     0.200
     3.021    10.809     0.200
     3.074    10.875     0.200
     3.146    10.883     0.200
     3.230    11.348     0.200
     3.242    10.830     0.200
     3.262    11.094     0.200
     3.382    11.300     0.200
     3.491    10.985     0.200
     3.545    11.831     0.200
     3.756    11.913     0.200
     3.778    12.428     0.200
     3.811    12.268     0.200
     3.858    11.610     0.200
     4.051    12.196     0.200
     4.226    13.051     0.200
     4.426    13.705     0.200
     4.486    14.046     0.200
     4.651    14.322     0.200
     4.746    14.130     0.200
     4.996    14.916     0.200
     5.211    15.235     0.200
     5.498    15.918     0.200
     5.718    15.716     0.200
     6.089    19.261     0.200
     6.089    16.857     0.200
     6.309    17.405     0.200
     6.555    18.293     0.200
    10.748    28.475     0.200
    10.748    27.840     0.200
    15.128    35.664     0.200
     0.854     4.476     0.200
     0.860     4.313     0.200
     0.864     3.474     0.200
     1.096     5.228     0.200
     1.204     7.269     0.200
     1.212     6.874     0.200
     1.244     6.991     0.200
     1.286     6.000     0.200
     1.306     5.908     0.200
     1.308     8.039     0.200
     1.329     5.767     0.200
     1.342     7.815     0.200
     1.550     4.593     0.200
     1.550     4.743     0.200
     1.560     7.365     0.200
     1.585     6.606     0.200
     1.600     6.507     0.200
     1.600     6.619     0.200
     1.721     5.262     0.200
     2.105     7.854     0.200
     2.230     9.236     0.200
     3.774    11.582     0.200
     4.988    18.459     0.200
     5.259    13.978     0.200
     6.529    19.883     0.200
     6.534    18.421     0.200
     7.759    22.354     0.200
     8.350    23.333     0.200
    10.401    28.504     0.200
    11.304    32.123     0.200
     0.896     4.552     0.200
     0.896     5.072     0.200
     0.939     4.583     0.200
     0.984     5.260     0.200
     1.079     5.567     0.200
     1.082     4.917     0.200
     1.093     5.180     0.200
     1.114     4.910     0.200
     1.146     7.359     0.200
     1.191     7.425     0.200
     1.266     6.774     0.200
     1.319     7.915     0.200
     1.345     7.052     0.200
     1.350     5.951     0.200
     1.373     6.869     0.200
     1.524     4.780     0.200
     1.465     6.948     0.200
     1.466     6.631     0.200
     1.575     7.292     0.200
     1.575     6.794     0.200
     1.625     7.723     0.200
     1.764     7.690     0.200
     1.765     8.869     0.200
     1.795     6.920     0.200
     1.817     6.581     0.200
     2.195     9.354     0.200
     2.330     9.529     0.200
     2.597     9.328     0.200
     2.930     9.900     0.200
     2.979    10.959     0.200
     3.177    10.250     0.200
     3.209    10.465     0.200
     3.483    11.886     0.200
     3.689    12.455     0.200
     3.805    12.576     0.200
     3.919    11.449     0.200
     3.919    12.088     0.200
     3.937    14.118     0.200
     4.012    12.288     0.200
     4.591    14.474     0.200
     4.643    16.305     0.200
     4.680    15.268     0.200
     4.687    15.790     0.200
     5.027    16.343     0.200
     5.048    15.506     0.200
     5.102    16.441     0.200
     5.165    16.581     0.200
     5.500    17.108     0.200
     5.616    16.904     0.200
     5.624    17.537     0.200
     6.554    20.629     0.200
     7.920    24.166     0.200
     8.428    24.274     0.200
    10.521    29.143     0.200
    10.522    29.161     0.200
    11.429    34.667     0.200
     0.894     4.691     0.200
     0.908     4.911     0.200
     0.939     5.181     0.200
     0.918     5.034     0.200
     0.944     4.620     0.200
     0.976     5.156     0.200
     0.938     0.922     0.200
     1.009     5.326     0.200
     1.022     5.296     0.200
     1.021     5.141     0.200
     1.009     1.272     0.200
     1.050     7.248     0.200
     1.108     7.444     0.200
     1.199     6.302     0.200
     1.274     6.126     0.200
     1.336     8.105     0.200
     1.470     7.097     0.200
     1.499     6.780     0.200
     1.536     6.973     0.200
     1.616     7.367     0.200
     1.745     7.458     0.200
     1.964     8.195     0.200
     2.140     8.672     0.200
     2.330     8.165     0.200
     2.379     8.902     0.200
     2.432     9.634     0.200
     2.579     9.638     0.200
     2.660     9.822     0.200
     2.688     9.926     0.200
     2.675     8.997     0.200
     2.757     9.849     0.200
     2.866    10.514     0.200
     2.924    10.766     0.200
     3.061    11.037     0.200
     3.053     9.353     0.200
     3.337    11.456     0.200
     3.335    11.575     0.200
     3.405    11.528     0.200
     3.485    12.945     0.200
     3.514    11.927     0.200
     3.806    13.048     0.200
     4.037    13.905     0.200
     4.104    12.685     0.200
     4.105    13.629     0.200
     4.137    13.624     0.200
     4.152    13.278     0.200
     4.249    14.773     0.200
     4.289    13.416     0.200
     4.629    15.969     0.200
     4.709    15.650     0.200
     4.707    16.217     0.200
     4.733    15.253     0.200
     4.773    15.887     0.200
     4.762    14.392     0.200
     4.942    16.699     0.200
     5.228    16.926     0.200
     5.320    17.249     0.200
     5.548    17.330     0.200
     5.539    17.275     0.200
     5.695    16.844     0.200
     5.728    16.524     0.200
     6.796    19.340     0.200
     7.545    21.280     0.200
     7.714    21.755     0.200
     8.111    23.510     0.200
    10.974    29.120     0.200
    11.179    31.026     0.200
    15.547    36.225     0.200
     1.176     7.685     0.200
     1.176     7.804     0.200
     1.176     7.064     0.200
     1.244     6.356     0.200
     1.225     7.860     0.200
     1.225     6.960     0.200
     1.256     6.876     0.200
     1.310     6.542     0.200
     1.272     8.321     0.200
     1.272     7.870     0.200
     1.293     7.378     0.200
     1.299     7.233     0.200
     1.328     6.165     0.200
     1.340     6.216     0.200
     1.531     4.676     0.200
     1.531     4.157     0.200
     1.431     7.171     0.200
     1.460     5.863     0.200
     1.460     7.664     0.200
     1.532     7.217     0.200
     1.513     8.875     0.200
     1.547     7.426     0.200
     1.591     6.327     0.200
     1.604     6.590     0.200
     1.604     6.722     0.200
     1.633     7.186     0.200
     1.569     8.076     0.200
     1.671     9.672     0.200
     1.726     7.375     0.200
     1.724     8.069     0.200
     1.754     7.219     0.200
     1.733     7.260     0.200
     1.805     8.088     0.200
     1.805     8.303     0.200
     1.817     7.439     0.200
     1.844     7.966     0.200
     1.842     9.616     0.200
     1.927     9.339     0.200
     1.922     7.894     0.200
     1.989     8.451     0.200
     2.039     8.269     0.200
     2.195     8.951     0.200
     2.227     9.547     0.200
     2.223     9.849     0.200
     2.283     9.056     0.200
     2.439     9.627     0.200
     2.744    11.223     0.200
     2.976    10.726     0.200
     2.987    14.017     0.200
     3.702    15.930     0.200
     3.813    13.129     0.200
     3.802    12.082     0.200
     4.527    15.653     0.200
     4.757    16.194     0.200
     4.942    16.452     0.200
     4.954    15.938     0.200
     5.275    15.326     0.200
     5.850    16.412     0.200
     6.550    20.426     0.200
     7.795    23.780     0.200
     8.147    22.693     0.200
     8.378    24.602     0.200
    10.421    29.563     0.200
    11.340    33.406     0.200
    11.320    34.632     0.200
    14.311    33.283     0.200
    15.229    34.634     0.200
    15.560    35.829     0.200
    17.085    37.462     0.200
     0.922     4.558     0.200
     0.998     6.800     0.200
     1.116     4.866     0.200
     1.245     6.710     0.200
     1.270     7.700     0.200
     1.342     6.153     0.200
     1.511     6.666     0.200
     1.511     6.096     0.200
     1.395     6.762     0.200
     1.522     7.853     0.200
     1.584     7.106     0.200
     1.596     6.785     0.200
     1.606     6.948     0.200
     1.661     7.544     0.200
     1.758     6.908     0.200
     1.795     9.107     0.200
     2.027     8.966     0.200
     2.209     9.058     0.200
     2.318     9.261     0.200
     2.535     9.937     0.200
     2.737    10.672     0.200
     3.521    13.658     0.200
     3.871    13.628     0.200
     4.686    15.399     0.200
     5.010    16.057     0.200
     5.230    16.209     0.200
     7.850    22.779     0.200
     8.414    26.197     0.200
    10.456    28.472     0.200
     0.866     4.436     0.200
     0.872     3.639     0.200
     1.081     5.792     0.200
     1.221     7.293     0.200
     1.221     7.485     0.200
     1.230     7.122     0.200
     1.263     7.583     0.200
     1.285     6.850     0.200
     1.294     5.948     0.200
     1.291     6.250     0.200
     1.299     8.128     0.200
     1.333     8.355     0.200
     1.339     7.814     0.200
     1.540     5.965     0.200
     1.540     7.394     0.200
     1.554     7.210     0.200
     1.555     7.673     0.200
     1.578     7.529     0.200
     1.615     6.221     0.200
     1.615     6.482     0.200
     1.691     8.038     0.200
     1.703     5.345     0.200
     1.832     7.792     0.200
     1.829     7.631     0.200
     2.047     8.335     0.200
     2.431    12.113     0.200
     2.443    12.229     0.200
     2.474    11.190     0.200
     2.538    12.249     0.200
     2.761     9.954     0.200
     2.940    12.199     0.200
     3.398    13.784     0.200
     3.757    12.775     0.200
     3.764    12.457     0.200
     3.763    12.255     0.200
     4.089    13.858     0.200
     4.100    14.479     0.200
     4.123    14.929     0.200
     4.479    15.603     0.200
     4.715    15.992     0.200
     4.904    15.400     0.200
     8.356    26.846     0.200
    10.383    29.765     0.200
    11.303    33.134     0.200
     0.941     4.709     0.200
     1.010     4.884     0.200
     1.224     5.094     0.200
     1.217     7.226     0.200
     1.224     6.937     0.200
     1.283     6.029     0.200
     1.293     6.109     0.200
     1.335     5.766     0.200
     1.326     7.104     0.200
     1.348     8.079     0.200
     1.551     4.837     0.200
     1.551     6.368     0.200
     1.549     8.880     0.200
     1.604     6.456     0.200
     1.712     7.097     0.200
     1.712     6.367     0.200
     1.712     6.443     0.200
     1.738     7.410     0.200
     1.772     7.700     0.200
     1.884     9.735     0.200
     1.955     8.097     0.200
     1.959     7.806     0.200
     1.991     7.785     0.200
     2.036     7.909     0.200
     2.093     7.637     0.200
     2.237     8.808     0.200
     2.282     9.334     0.200
     2.421     8.698     0.200
     2.426     8.993     0.200
     2.751     9.622     0.200
     3.393    11.728     0.200
     3.762    13.019     0.200
     3.764    12.198     0.200
     3.762    11.875     0.200
     3.762    11.686     0.200
     4.476    15.732     0.200
     4.709    15.997     0.200
     4.899    15.915     0.200
     6.293    18.054     0.200
    10.390    28.625     0.200
    15.929    38.814     0.200
     0.835     4.543     0.200
     0.868     4.558     0.200
     0.911     4.823     0.200
     0.950     4.852     0.200
     0.970     5.173     0.200
     1.179     5.768     0.200
     1.317     6.760     0.200
     1.440     9.019     0.200
     1.532     6.762     0.200
     1.576     6.916     0.200
     1.805     7.539     0.200
     1.861     7.768     0.200
     1.896     7.612     0.200
     1.919     7.866     0.200
     1.955     6.930     0.200
     2.223     5.026     0.200
     2.241     7.508     0.200
     2.423     9.430     0.200
     2.556     9.711     0.200
     2.743    10.497     0.200
     2.864    10.237     0.200
     2.863    12.344     0.200
     2.896    10.897     0.200
     2.867     9.449     0.200
     3.079    10.635     0.200
     3.158    10.844     0.200
     3.179    11.196     0.200
     3.254    10.944     0.200
     3.398    11.499     0.200
     3.558    12.620     0.200
     3.702    13.702     0.200
     3.749    12.841     0.200
     3.983    13.357     0.200
     4.015    12.421     0.200
     4.012    13.184     0.200
     4.158    14.091     0.200
     4.184    14.733     0.200
     4.307    14.512     0.200
     4.301    13.148     0.200
     4.470    13.298     0.200
     4.566    14.774     0.200
     4.569    13.548     0.200
     4.591    13.804     0.200
     4.715    15.329     0.200
     4.747    15.506     0.200
     4.821    15.693     0.200
     4.886    15.108     0.200
     4.954    15.818     0.200
     4.966    15.179     0.200
     5.187    14.371     0.200
     5.271    16.139     0.200
     5.349    18.081     0.200
     5.359    16.554     0.200
     5.391    16.452     0.200
     5.419    16.640     0.200
     5.535    17.153     0.200
     5.567    17.381     0.200
     5.693    17.228     0.200
     5.779    16.899     0.200
     5.859    16.690     0.200
     5.893    18.037     0.200
     5.893    16.041     0.200
     5.893    16.913     0.200
     5.869    16.716     0.200
     5.937    16.690     0.200
     5.917    16.051     0.200
     5.974    16.153     0.200
     6.309    18.360     0.200
     6.438    18.342     0.200
     6.677    18.851     0.200
     6.893    19.750     0.200
     6.970    19.095     0.200
     7.303    17.261     0.200
     7.387    19.851     0.200
     7.452    18.759     0.200
     7.695    20.001     0.200
     7.819    20.034     0.200
     7.937    21.655     0.200
     7.937    20.506     0.200
     7.973    19.936     0.200
     8.021    19.055     0.200
     8.044    24.319     0.200
     8.249    22.583     0.200
     8.871    23.478     0.200
     9.098    24.050     0.200
     9.627    24.435     0.200
     9.919    26.907     0.200
    11.173    27.976     0.200
    11.173    30.993     0.200
    11.165    29.134     0.200
    12.594    31.872     0.200
    13.041    30.817     0.200
     0.842     4.294     0.200
     0.930     4.676     0.200
     0.937     5.050     0.200
     0.974     4.721     0.200
     1.026     4.972     0.200
     1.027     4.923     0.200
     1.017     4.959     0.200
     1.011     6.075     0.200
     1.053     4.754     0.200
     1.060     5.339     0.200
     1.052     5.770     0.200
     1.031     6.264     0.200
     1.077     5.547     0.200
     1.112     5.536     0.200
     1.152     6.068     0.200
     1.184     5.341     0.200
     1.190     6.040     0.200
     1.197     5.501     0.200
     1.196     5.599     0.200
     1.197     5.597     0.200
     1.197     5.638     0.200
     1.196     5.610     0.200
     1.195     5.849     0.200
     1.244     5.819     0.200
     1.276     5.717     0.200
     1.261     6.254     0.200
     1.285     6.444     0.200
     1.326     6.289     0.200
     1.343     5.933     0.200
     1.333     6.530     0.200
     1.332     6.392     0.200
     1.366     6.200     0.200
     1.361     6.324     0.200
     1.413     6.295     0.200
     1.413     6.337     0.200
     1.392     6.854     0.200
     1.444     6.259     0.200
     1.426     6.872     0.200
     1.439     6.559     0.200
     1.484     6.929     0.200
     1.491     6.785     0.200
     1.523     6.797     0.200
     1.549     6.689     0.200
     1.549     6.941     0.200
     1.555     6.927     0.200
     1.562     7.307     0.200
     1.561     6.759     0.200
     1.586     6.922     0.200
     1.632     7.342     0.200
     1.625     7.257     0.200
     1.652     7.163     0.200
     1.701     7.445     0.200
     1.784     5.334     0.200
     1.820     8.057     0.200
     1.841     7.927     0.200
     1.874     8.586     0.200
     1.868     7.813     0.200
     1.893     8.299     0.200
     1.986     8.497     0.200
     2.101     7.329     0.200
    15.610    35.793     0.200
     0.926     4.622     0.200
     1.023     5.066     0.200
     1.015     4.793     0.200
     1.195     5.966     0.200
     1.195     5.358     0.200
     1.209     6.379     0.200
     1.279     7.207     0.200
     1.284     8.293     0.200
     1.306     8.692     0.200
     1.367     6.388     0.200
     1.369     8.701     0.200
     1.426     6.846     0.200
     1.506     6.966     0.200
     1.508     7.065     0.200
     1.630     6.933     0.200
     1.925     7.930     0.200
     1.873     7.385     0.200
     2.052     7.791     0.200
     2.122     8.761     0.200
     2.217     8.632     0.200
     2.267     9.351     0.200
     2.344     8.767     0.200
     2.492    10.733     0.200
     2.653     9.779     0.200
     2.777    10.801     0.200
     2.808    11.721     0.200
     3.121    12.397     0.200
     3.823    11.772     0.200
     6.152    20.083     0.200
     7.898    24.468     0.200
    10.731    28.326     0.200
    11.121    31.596     0.200
     0.933     4.821     0.200
     0.950     4.751     0.200
     0.942     4.988     0.200
     0.942     5.187     0.200
     0.994     5.512     0.200
     1.001     5.413     0.200
     0.995     5.592     0.200
     1.010     5.406     0.200
     1.009     5.571     0.200
     1.010     5.607     0.200
     1.012     5.390     0.200
     1.010     5.636     0.200
     1.059     5.875     0.200
     1.107     5.904     0.200
     1.166     6.293     0.200
     1.208     6.355     0.200
     1.210     6.452     0.200
     1.277     6.640     0.200
     1.292     6.503     0.200
     1.300     6.932     0.200
     1.291     6.554     0.200
     1.309     6.972     0.200
     1.317     6.865     0.200
     1.314     7.532     0.200
     1.348     7.007     0.200
     1.360     7.055     0.200
     1.347     8.615     0.200
     1.332     8.986     0.200
     1.409     7.549     0.200
     1.442     7.936     0.200
     1.460     7.346     0.200
     1.414     8.951     0.200
     1.432     9.849     0.200
     1.432     7.303     0.200
     1.472     7.499     0.200
     1.554     7.727     0.200
     1.593     8.482     0.200
     1.710     9.251     0.200
     1.779     7.775     0.200
     1.952     8.726     0.200
     2.073     6.078     0.200
     1.966     8.140     0.200
     2.120     9.422     0.200
     2.140     8.868     0.200
     2.142    10.710     0.200
     2.292     9.436     0.200
     2.419     9.509     0.200
     2.409    10.901     0.200
     2.544    10.495     0.200
     2.569    10.014     0.200
     2.684    10.320     0.200
     2.692    10.662     0.200
     2.766    10.581     0.200
     2.890    11.453     0.200
     2.906    11.271     0.200
     3.017    11.096     0.200
     3.031    12.178     0.200
     3.053    11.465     0.200
     3.129    11.649     0.200
     3.184    11.109     0.200
     3.250    11.999     0.200
     3.319    11.994     0.200
     3.348    12.891     0.200
     3.514    12.266     0.200
     3.513    13.158     0.200
     3.731    14.402     0.200
     3.817    13.119     0.200
     3.821    13.247     0.200
     4.070    14.350     0.200
     4.088    13.362     0.200
     4.105    14.183     0.200
     4.128    13.939     0.200
     4.156    15.263     0.200
     4.178    14.095     0.200
     4.181    14.226     0.200
     4.186    13.910     0.200
     4.225    14.658     0.200
     4.241    14.894     0.200
     4.300    14.944     0.200
     4.322    13.430     0.200
     4.720    15.663     0.200
     4.732    16.192     0.200
     4.793    16.130     0.200
     4.942    15.944     0.200
     4.964    16.403     0.200
     5.008    16.227     0.200
     5.021    16.327     0.200
     5.055    16.407     0.200
     5.142    17.098     0.200
     5.237    16.946     0.200
     5.262    16.703     0.200
     5.354    16.538     0.200
     5.370    17.804     0.200
     5.450    17.305     0.200
     5.545    17.413     0.200
     5.573    17.957     0.200
     5.636    17.877     0.200
     5.655    18.140     0.200
     5.728    17.280     0.200
     5.760    17.412     0.200
     6.026    18.131     0.200
     6.026    19.020     0.200
     6.050    19.198     0.200
     6.102    20.260     0.200
     6.565    19.953     0.200
     6.682    20.704     0.200
     6.829    19.898     0.200
     6.938    20.556     0.200
     7.383    21.900     0.200
     7.556    21.689     0.200
     7.710    23.016     0.200
     7.748    22.085     0.200
     8.021    22.851     0.200
     8.021    24.044     0.200
     8.144    22.234     0.200
     8.144    23.375     0.200
     8.145    23.140     0.200
     8.145    23.490     0.200
     8.952    23.962     0.200
     9.473    26.136     0.200
    10.442    27.942     0.200
    10.702    28.740     0.200
    10.829    29.069     0.200
    11.004    29.786     0.200
    11.005    29.077     0.200
    11.005    29.436     0.200
    11.198    31.355     0.200
    11.218    29.006     0.200
    11.930    29.449     0.200
    12.091    30.042     0.200
    13.679    33.015     0.200
    14.149    36.253     0.200
    14.314    36.389     0.200
    14.357    36.139     0.200
    14.371    36.762     0.200
    14.396    36.180     0.200
    14.436    36.010     0.200
    14.464    35.397     0.200
    14.568    36.500     0.200
    14.599    37.172     0.200
    14.612    36.548     0.200
    14.682    35.948     0.200
    14.779    36.256     0.200
    14.848    36.725     0.200
    14.981    37.680     0.200
    15.054    36.779     0.200
    15.075    37.752     0.200
    15.126    36.766     0.200
    15.145    36.564     0.200
    15.179    36.615     0.200
    15.277    36.551     0.200
    15.283    37.573     0.200
    15.330    38.054     0.200
    15.551    39.423     0.200
    15.588    37.870     0.200
    15.637    37.374     0.200
    15.880    37.765     0.200
    15.925    37.811     0.200
    15.958    37.818     0.200
    16.086    37.788     0.200
    16.122    38.896     0.200
    17.168    38.621     0.200
    17.346    38.931     0.200
    17.414    39.272     0.200
    19.270    40.267     0.200
    20.586    39.998     0.200
     0.986     4.999     0.200
     1.041     5.023     0.200
     1.045     5.781     0.200
     1.190     6.096     0.200
     1.287     6.346     0.200
     1.290     6.935     0.200
     1.327     8.820     0.200
     1.346     6.668     0.200
     1.609     6.831     0.200
     1.485     6.947     0.200
     1.512     6.820     0.200
     1.603     7.140     0.200
     1.649     7.883     0.200
     1.685     7.629     0.200
     1.811     7.949     0.200
     1.813     9.261     0.200
     1.887     7.310     0.200
     1.929     8.610     0.200
     1.906     7.001     0.200
     2.068     8.891     0.200
     2.240     9.694     0.200
     2.311     8.760     0.200
     2.376     8.805     0.200
     2.505     9.221     0.200
     2.603    10.569     0.200
     2.816    10.076     0.200
     2.886     9.592     0.200
     3.026    11.057     0.200
     3.038    12.148     0.200
     3.111    11.151     0.200
     3.126    11.502     0.200
     3.389    11.687     0.200
     3.494    12.603     0.200
     3.584    11.101     0.200
     3.718    14.212     0.200
     3.933    14.789     0.200
     3.960    13.820     0.200
     3.980    12.949     0.200
     3.986    13.291     0.200
     3.986    11.092     0.200
     4.116    13.546     0.200
     4.139    15.343     0.200
     4.197    15.736     0.200
     4.227    15.315     0.200
     4.245    15.327     0.200
     4.291    15.444     0.200
     4.407    15.687     0.200
     4.568    15.548     0.200
     4.648    16.341     0.200
     4.840    16.476     0.200
     4.992    16.407     0.200
     5.112    16.568     0.200
     5.135    17.193     0.200
     5.142    16.619     0.200
     5.197    16.703     0.200
     5.259    17.907     0.200
     5.346    18.086     0.200
     5.339    17.552     0.200
     5.416    16.378     0.200
     5.461    18.435     0.200
     5.526    18.227     0.200
     5.529    20.332     0.200
     6.518    19.294     0.200
     6.730    20.876     0.200
     6.999    22.127     0.200
     7.152    22.092     0.200
     7.322    21.916     0.200
     7.513    24.003     0.200
     7.513    21.960     0.200
     7.849    23.928     0.200
     7.996    26.176     0.200
    13.325    32.366     0.200
    13.361    33.187     0.200
     0.773     4.620     0.200
     1.065     5.654     0.200
     1.170     6.308     0.200
     1.035     5.620     0.200
     1.160     5.731     0.200
     1.236     6.151     0.200
     0.848     4.327     0.200
     0.983     5.288     0.200
     0.850     4.400     0.200
     0.837     4.038     0.200
     0.809     4.078     0.200
     0.737     3.912     0.200
     1.212     6.003     0.200
     0.826     4.207     0.200
     1.108     5.414     0.200
     0.954     4.319     0.200
     1.247     4.562     0.200
     1.057     4.946     0.200
     1.355     6.217     0.200
     1.251     5.930     0.200
     1.095     5.396     0.200
     1.173     5.752     0.200
     1.250     6.053     0.200
     1.103     4.918     0.200
     1.103     5.117     0.200
     1.103     5.103     0.200
     0.957     4.750     0.200
     1.087     4.844     0.200
     1.240     5.805     0.200
     0.922     4.326     0.200
     0.875     4.619     0.200
     0.922     4.642     0.200
     1.141     5.269     0.200
     1.222     5.681     0.200
     0.965     5.572     0.200
     1.239     5.394     0.200
     1.343     5.816     0.200
     1.261     5.733     0.200
     1.767     7.149     0.200
     1.534     6.659     0.200
     1.533     6.474     0.200
     1.312     5.799     0.200
     1.418     6.296     0.200
     2.258     8.651     0.200
     1.951     7.957     0.200
     2.046     7.987     0.200
     1.937     8.053     0.200
     2.489     8.125     0.200
     2.136     8.400     0.200
     2.661     9.180     0.200
     2.391     8.343     0.200
     2.639     9.325     0.200
     2.707     9.303     0.200
     3.033    10.407     0.200
     2.693     9.597     0.200
     3.107     9.943     0.200
     2.707    10.023     0.200
     3.106    10.573     0.200
     4.083    12.109     0.200
     6.051    18.653     0.200
     7.301    23.063     0.200
     7.893    22.855     0.200
     7.893    23.761     0.200
     7.950    21.652     0.200
     8.712    23.222     0.200
    10.784    28.425     0.200
    10.575    33.597     0.200
    11.044    28.411     0.200
    15.083    34.730     0.200
    15.078    34.463     0.200
    15.184    33.490     0.200
    15.137    32.865     0.200
    15.342    35.201     0.200
    15.250    33.961     0.200
    15.257    34.561     0.200
    15.428    35.285     0.200
    15.615    35.325     0.200
    15.581    34.776     0.200
    15.583    35.255     0.200
    15.507    38.776     0.200
    15.628    34.575     0.200
    15.706    35.330     0.200
    15.674    34.523     0.200
    15.655    34.298     0.200
    15.834    34.674     0.200
    15.871    34.934     0.200
    15.954    35.146     0.200
    15.849    35.447     0.200
    16.029    37.394     0.200
    16.012    37.776     0.200
    16.190    36.265     0.200
    16.406    37.800     0.200
    16.423    35.703     0.200
    16.338    34.804     0.200
    16.642    38.153     0.200
    16.599    37.780     0.200
     0.822     4.397     0.200
     0.851     4.088     0.200
     0.863     4.431     0.200
     0.861     4.361     0.200
     0.934     4.981     0.200
     0.945     5.125     0.200
     0.995     5.302     0.200
     0.995     5.292     0.200
     1.075     5.641     0.200
     1.117     5.795     0.200
     1.116     5.161     0.200
     1.225     6.004     0.200
     1.367     6.448     0.200
     1.547     7.747     0.200
     1.940    10.664     0.200
     1.964    10.219     0.200
     2.060    10.599     0.200
     2.272     8.873     0.200
     2.478     8.418     0.200
     4.542    15.614     0.200
     5.314    16.496     0.200
     6.065    18.322     0.200
     7.960    25.917     0.200
    10.773    28.778     0.200
    15.518    36.539     0.200
     0.753     3.891     0.200
     0.824     4.205     0.200
     0.852     4.090     0.200
     0.888     4.669     0.200
     0.864     4.507     0.200
     0.862     4.431     0.200
     0.937     4.337     0.200
     0.947     4.288     0.200
     0.969     4.393     0.200
     1.047     4.948     0.200
     1.102     4.900     0.200
     1.096     5.708     0.200
     1.118     5.337     0.200
     1.118     5.231     0.200
     1.120     5.210     0.200
     1.123     5.453     0.200
     1.157     5.316     0.200
     1.255     4.690     0.200
     1.187     5.857     0.200
     1.170     5.951     0.200
     1.219     5.574     0.200
     1.237     5.697     0.200
     1.225     6.076     0.200
     1.276     5.783     0.200
     1.255     5.882     0.200
     1.265     6.207     0.200
     1.265     6.002     0.200
     1.246     6.278     0.200
     1.317     6.287     0.200
     1.290     5.902     0.200
     1.286     8.837     0.200
     1.325     6.321     0.200
     1.337     5.844     0.200
     1.337     5.906     0.200
     1.358     5.850     0.200
     1.362     6.088     0.200
     1.345     6.325     0.200
     1.333     8.826     0.200
     1.368     6.523     0.200
     1.356     6.484     0.200
     1.429     6.213     0.200
     1.369     6.153     0.200
     1.462     6.178     0.200
     1.439     6.560     0.200
     1.431     7.029     0.200
     1.452     6.339     0.200
     1.440     6.404     0.200
     1.440     6.539     0.200
     1.472     6.444     0.200
     1.486     6.457     0.200
     1.486     6.390     0.200
     1.501     6.858     0.200
     1.502     6.321     0.200
     1.526     6.609     0.200
     1.516     6.465     0.200
     1.549     6.806     0.200
     1.574     6.865     0.200
     1.533     8.245     0.200
     1.572     7.436     0.200
     1.589     6.802     0.200
     1.636     6.830     0.200
     1.648     7.116     0.200
     1.780     7.273     0.200
     1.894     6.213     0.200
     1.943     8.189     0.200
     1.966     8.008     0.200
     2.062     8.743     0.200
     2.146     8.212     0.200
     2.273     8.828     0.200
     2.406    11.149     0.200
     6.067    18.281     0.200
     7.963    24.963     0.200
    10.773    28.633     0.200
    11.053    32.590     0.200
     0.994     4.019     0.200
     1.134     6.005     0.200
     1.164     5.392     0.200
     1.212     5.444     0.200
     1.281     6.066     0.200
     1.320     6.273     0.200
     1.391     5.613     0.200
     1.557     7.319     0.200
     1.499     6.426     0.200
     1.545     7.383     0.200
     1.587     6.734     0.200
     1.729     6.802     0.200
     1.797     7.600     0.200
     1.874     9.538     0.200
     2.021     8.391     0.200
     3.790    12.149     0.200
     5.001    19.468     0.200
     5.275    18.615     0.200
     6.526    19.509     0.200
     7.772    22.356     0.200
     8.347    26.226     0.200
     8.347    25.210     0.200
    10.416    28.228     0.200
    11.307    33.916     0.200
    11.307    31.025     0.200
    15.113    38.922     0.200
    15.366    37.315     0.200
    15.482    37.780     0.200
    15.928    40.602     0.200
    15.928    39.843     0.200
    16.055    37.885     0.200
    16.548    39.017     0.200
    16.548    38.617     0.200
    17.801    39.549     0.200
     0.836     4.613     0.200
     0.843     4.488     0.200
     0.921     4.894     0.200
     0.986     4.856     0.200
     1.035     4.993     0.200
     1.053     4.780     0.200
     1.046     5.594     0.200
     1.194     5.797     0.200
     1.266     5.979     0.200
     1.309     5.773     0.200
     1.308     6.192     0.200
     1.378     5.430     0.200
     1.571     4.496     0.200
     1.482     6.511     0.200
     1.545     8.317     0.200
     1.579     6.937     0.200
     1.579     6.806     0.200
     1.758     7.698     0.200
     1.794     8.068     0.200
     1.892     8.978     0.200
     2.011     8.472     0.200
     2.117     9.026     0.200
     2.257    10.131     0.200
     2.400    10.032     0.200
     2.516    10.423     0.200
     2.524     9.719     0.200
     2.726    11.279     0.200
     2.828    11.899     0.200
     2.926    10.591     0.200
     3.027    11.443     0.200
     3.089    10.706     0.200
     3.738    13.490     0.200
     3.783    11.050     0.200
     3.783    12.768     0.200
     3.783    11.253     0.200
     5.007    15.032     0.200
     5.274    16.293     0.200
     5.274    16.926     0.200
     5.696    20.749     0.200
     5.696    19.155     0.200
     5.872    18.486     0.200
     6.513    18.913     0.200
     6.543    19.726     0.200
     7.760    22.519     0.200
     7.760    21.980     0.200
     7.760    23.261     0.200
     8.163    22.444     0.200
     8.331    23.345     0.200
     8.685    23.486     0.200
     9.342    26.177     0.200
     9.652    28.951     0.200
     9.956    26.510     0.200
    10.372    32.369     0.200
    10.379    31.923     0.200
    10.412    27.215     0.200
    10.413    27.496     0.200
    10.414    27.792     0.200
    10.736    30.794     0.200
    10.859    31.216     0.200
    11.290    32.214     0.200
    11.334    32.998     0.200
    12.738    34.610     0.200
    13.934    35.362     0.200
    15.070    37.185     0.200
    15.078    36.989     0.200
    15.102    36.905     0.200
    15.111    37.484     0.200
    15.190    35.755     0.200
    15.146    37.072     0.200
    15.159    36.426     0.200
    15.271    37.017     0.200
    15.419    37.745     0.200
    15.480    37.466     0.200
    15.682    37.215     0.200
    15.734    38.143     0.200
    15.735    38.174     0.200
    15.864    37.463     0.200
    15.913    40.863     0.200
    15.908    38.162     0.200
    16.023    37.001     0.200
    16.239    37.213     0.200
    16.232    38.251     0.200
    16.462    38.707     0.200
     0.983     4.511     0.200
     1.039     5.490     0.200
     1.090     8.274     0.200
     1.202     5.822     0.200
     1.270     5.771     0.200
     1.305     5.718     0.200
     1.293     8.189     0.200
     1.320     5.981     0.200
     1.398     8.433     0.200
     1.569     4.386     0.200
     1.537     8.294     0.200
     1.576     6.456     0.200
     1.576     6.723     0.200
     1.718     8.150     0.200
     1.787     8.367     0.200
     2.009     9.066     0.200
     2.253    10.307     0.200
     2.401    10.631     0.200
     2.516    11.527     0.200
     2.721    11.659     0.200
     2.831    11.598     0.200
     3.021    12.666     0.200
     3.405    13.465     0.200
     3.501    14.123     0.200
     3.737    13.408     0.200
     3.794    11.421     0.200
     5.012    16.475     0.200
     7.772    22.892     0.200
     8.336    23.815     0.200
    10.423    28.018     0.200
    15.917    40.164     0.200
    15.917    37.555     0.200
    15.918    35.166     0.200
    15.920    36.333     0.200
    15.981    35.371     0.200
    16.025    36.691     0.200
    16.847    37.620     0.200
    17.072    39.805     0.200
     0.985     4.894     0.200
     1.040     5.644     0.200
     1.206     6.137     0.200
     1.566     4.539     0.200
     1.323     6.375     0.200
     1.273     5.864     0.200
     1.306     5.780     0.200
     1.382     5.396     0.200
     1.515     8.500     0.200
     1.495     6.616     0.200
     1.537     7.253     0.200
     1.578     6.576     0.200
     1.675     8.495     0.200
     1.744     6.565     0.200
     1.788     7.536     0.200
     2.012     7.947     0.200
     2.130    10.152     0.200
     2.206     9.494     0.200
     2.255    10.045     0.200
     2.404    11.166     0.200
     2.519    11.403     0.200
     2.723    10.626     0.200
     2.834    11.937     0.200
     3.022    12.654     0.200
     3.735    12.511     0.200
     3.795    11.920     0.200
     5.010    15.287     0.200
     5.283    15.570     0.200
     5.694    17.575     0.200
     5.874    18.194     0.200
     6.517    18.550     0.200
     7.775    23.057     0.200
     7.775    23.159     0.200
     8.340    23.094     0.200
     9.664    29.585     0.200
    10.424    28.152     0.200
    10.751    30.814     0.200
    11.303    33.244     0.200
    13.698    38.238     0.200
    13.948    37.821     0.200
    14.924    36.315     0.200
    15.091    35.940     0.200
    15.125    34.910     0.200
    15.158    35.789     0.200
    15.074    34.664     0.200
    15.173    36.713     0.200
    15.195    36.380     0.200
    15.455    36.793     0.200
    15.544    38.121     0.200
    15.697    36.670     0.200
    15.647    39.067     0.200
    15.749    37.323     0.200
    15.772    38.118     0.200
    15.809    37.598     0.200
    15.920    40.757     0.200
    16.028    38.334     0.200
    16.168    38.245     0.200
    16.246    38.230     0.200
    16.357    38.797     0.200
    16.550    38.805     0.200
    16.812    38.777     0.200
    17.718    39.147     0.200
    18.047    39.254     0.200
    18.224    39.286     0.200
    15.285    36.199     0.200
     0.914     4.670     0.200
     0.985     4.487     0.200
     1.047     4.645     0.200
     1.050     5.154     0.200
     1.159     5.336     0.200
     1.181     6.009     0.200
     1.257     5.374     0.200
     1.311     5.656     0.200
     1.294     6.040     0.200
     1.578     4.393     0.200
     1.467     6.328     0.200
     1.551     7.303     0.200
     1.579     6.307     0.200
     1.579     6.412     0.200
     1.711     7.381     0.200
     1.746     7.239     0.200
     1.798     7.580     0.200
     1.906     9.601     0.200
     2.010     8.077     0.200
     3.771    11.303     0.200
     5.005    18.623     0.200
     6.508    19.696     0.200
     7.103    20.801     0.200
     7.745    23.736     0.200
     8.320    24.341     0.200
     8.708    24.418     0.200
     8.894    21.074     0.200
     9.555    27.264     0.200
     9.873    26.915     0.200
    10.120    24.488     0.200
    10.405    26.975     0.200
    10.563    28.814     0.200
    11.276    30.654     0.200
    14.568    35.694     0.200
    15.667    36.620     0.200
    15.781    37.139     0.200
    15.903    39.248     0.200
    15.903    38.195     0.200
    15.638    37.918     0.200
     0.794     4.499     0.200
     0.809     4.522     0.200
     0.858     4.849     0.200
     0.865     4.733     0.200
     0.890     4.953     0.200
     1.014     4.862     0.200
     1.067     5.057     0.200
     1.196     6.430     0.200
     1.229     7.119     0.200
     1.280     6.223     0.200
     1.281     5.835     0.200
     1.266     6.700     0.200
     1.341     5.711     0.200
     1.400     5.547     0.200
     1.354     7.637     0.200
     1.552     4.465     0.200
     1.579     6.862     0.200
     1.608     6.261     0.200
     1.608     6.377     0.200
     1.704     6.359     0.200
     1.706     6.435     0.200
     1.738     6.903     0.200
     1.767     7.204     0.200
     1.827     7.531     0.200
     1.892     9.454     0.200
     2.039     8.126     0.200
     2.112     8.257     0.200
     2.249     8.935     0.200
     2.244     8.738     0.200
     2.287     9.011     0.200
     2.426     9.161     0.200
     2.757    10.060     0.200
     3.612    12.556     0.200
     3.678    14.453     0.200
     3.750    12.079     0.200
     4.891    15.921     0.200
     4.975    18.219     0.200
     5.147    15.429     0.200
     5.184    17.014     0.200
     5.240    16.701     0.200
     5.240    17.332     0.200
     5.371    17.430     0.200
     5.843    19.724     0.200
     6.508    20.090     0.200
     6.535    18.914     0.200
     7.088    20.526     0.200
     7.733    23.655     0.200
     8.132    24.483     0.200
     8.375    22.422     0.200
    10.096    27.287     0.200
    10.378    28.063     0.200
    10.379    28.360     0.200
    10.379    28.864     0.200
    11.287    33.727     0.200
    13.428    33.489     0.200
    14.590    35.304     0.200
    14.623    35.757     0.200
    15.501    36.255     0.200
    15.766    36.260     0.200
    15.925    37.211     0.200
     0.720     3.825     0.200
     0.720     4.012     0.200
     0.730     4.175     0.200
     0.748     3.859     0.200
     0.776     4.118     0.200
     0.817     4.469     0.200
     1.017     4.319     0.200
     1.180     6.076     0.200
     1.258     5.759     0.200
     1.272     5.770     0.200
     1.348     5.297     0.200
     1.559     4.657     0.200
     1.397     5.649     0.200
     1.460     6.126     0.200
     1.592     6.875     0.200
     1.612     6.055     0.200
     1.612     6.338     0.200
     1.693     6.309     0.200
     1.698     6.338     0.200
     1.735     6.660     0.200
     1.754     6.881     0.200
     1.836     7.275     0.200
     1.909     9.337     0.200
     2.066     7.540     0.200
     2.040     7.430     0.200
     2.093     7.139     0.200
     2.238     8.231     0.200
     2.253     8.005     0.200
     2.292     8.059     0.200
     2.410     9.032     0.200
     2.415     8.343     0.200
     2.763     9.752     0.200
     2.840     8.971     0.200
     2.905     9.877     0.200
     3.092    10.286     0.200
     3.142    10.418     0.200
     3.170    10.714     0.200
     3.192    10.824     0.200
     3.686    11.084     0.200
     3.727    12.565     0.200
     3.731    11.103     0.200
     3.731    11.915     0.200
     3.731    10.384     0.200
     3.719    16.732     0.200
     4.010    11.476     0.200
     4.053    13.659     0.200
     4.087    14.033     0.200
     4.096    13.862     0.200
     4.245    12.947     0.200
     4.275    14.856     0.200
     4.395    13.622     0.200
     4.622    14.493     0.200
     4.713    15.162     0.200
     4.839    13.354     0.200
     4.873    16.051     0.200
     4.845    15.685     0.200
     4.969    19.944     0.200
     5.003    16.548     0.200
     4.997    16.372     0.200
     5.084    16.039     0.200
     5.130    14.928     0.200
     5.165    17.045     0.200
     5.169    16.613     0.200
     5.226    17.802     0.200
     5.229    17.332     0.200
     5.253    16.599     0.200
     5.354    17.406     0.200
     5.398    15.884     0.200
     5.673    19.589     0.200
     5.672    17.541     0.200
     5.839    18.746     0.200
     6.027    18.894     0.200
     6.217    18.282     0.200
     6.261    17.712     0.200
     6.531    18.812     0.200
     6.618    19.942     0.200
     6.897    20.420     0.200
     7.066    19.967     0.200
     7.258    20.154     0.200
     7.302    23.156     0.200
     7.696    22.733     0.200
     7.711    23.764     0.200
     8.013    25.898     0.200
     8.330    23.021     0.200
     8.357    21.721     0.200
     9.636    28.812     0.200
     9.832    26.793     0.200
    10.221    27.213     0.200
    10.362    28.234     0.200
    10.363    26.866     0.200
    10.363    29.718     0.200
    10.364    28.056     0.200
    10.698    31.252     0.200
    11.269    31.240     0.200
    13.883    33.351     0.200
    13.984    31.674     0.200
    14.017    30.421     0.200
    14.094    30.855     0.200
    14.311    33.664     0.200
    14.365    34.442     0.200
    14.434    34.214     0.200
    14.603    38.129     0.200
    15.915    38.393     0.200
    16.938    36.831     0.200
    17.008    36.397     0.200
    17.387    37.788     0.200
    18.037    37.221     0.200
    18.072    36.518     0.200
    18.072    36.659     0.200
    15.603    36.416     0.200
     0.811     4.543     0.200
     0.841     4.760     0.200
     0.896     4.498     0.200
     0.896     4.388     0.200
     0.926     4.598     0.200
     0.985     6.481     0.200
     1.006     5.022     0.200
     1.074     6.820     0.200
     1.091     6.537     0.200
     1.190     8.743     0.200
     1.146     6.949     0.200
     1.244     7.188     0.200
     1.256     7.848     0.200
     1.511     4.021     0.200
     1.335     7.314     0.200
     1.329     6.376     0.200
     1.360     5.794     0.200
     1.379     8.536     0.200
     1.419     8.249     0.200
     1.456     6.224     0.200
     1.482     8.089     0.200
     1.573     8.629     0.200
     1.591     6.520     0.200
     2.264    10.824     0.200
     2.466    12.123     0.200
     2.508    12.002     0.200
     2.560    11.537     0.200
     2.601    10.014     0.200
     2.903    11.012     0.200
     3.905    11.123     0.200
    15.132    36.793     0.200
    15.204    34.920     0.200
    15.446    34.650     0.200
    15.459    36.354     0.200
    15.830    36.412     0.200
    15.940    35.715     0.200
    16.007    38.604     0.200
    16.095    37.452     0.200
    16.526    38.499     0.200
    16.915    36.764     0.200
    17.433    38.507     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.179    23.361     0.200
     3.275    23.872     0.200
     3.793    28.982     0.200
     4.217    31.945     0.200
     5.385    36.828     0.200
     6.612    47.287     0.200
     6.713    49.289     0.200
     7.167    50.559     0.200
     7.642    55.310     0.200
     7.738    53.761     0.200
     8.030    60.250     0.200
     8.041    59.482     0.200
     8.343    62.294     0.200
     3.288    24.372     0.200
     4.220    30.163     0.200
     5.907    45.224     0.200
     8.342    62.615     0.200
     5.520    38.055     0.200
     3.723    27.644     0.200
     4.674    32.813     0.200
     5.020    33.400     0.200
     6.350    45.611     0.200
     2.835    20.720     0.200
     3.179    23.115     0.200
     4.008    29.430     0.200
     4.604    32.642     0.200
     5.121    34.426     0.200
     5.256    35.163     0.200
     7.678    55.668     0.200
     2.625    20.364     0.200
     3.834    26.058     0.200
     4.479    33.007     0.200
     5.824    44.318     0.200
     6.444    45.225     0.200
     6.566    48.461     0.200
     7.599    52.288     0.200
     7.699    55.172     0.200
     7.904    54.723     0.200
     7.931    55.806     0.200
     7.986    57.593     0.200
     8.111    63.309     0.200
     8.277    59.017     0.200
     8.578    63.042     0.200
     8.590    60.758     0.200
     9.132    67.799     0.200
     9.528    70.347     0.200
     9.616    68.933     0.200
    10.732    75.820     0.200
    11.115    79.224     0.200
     2.619    21.222     0.200
     2.939    21.758     0.200
     3.090    24.079     0.200
     3.558    26.189     0.200
     3.618    27.989     0.200
     4.126    31.198     0.200
     4.482    32.385     0.200
     5.813    44.285     0.200
     6.932    50.936     0.200
     7.347    52.433     0.200
     6.433    48.603     0.200
     7.796    55.101     0.200
     8.270    61.393     0.200
     2.629    18.645     0.200
     2.901    19.672     0.200
     2.956    19.320     0.200
     3.575    23.504     0.200
     3.834    27.538     0.200
     4.143    29.375     0.200
     4.481    33.289     0.200
     8.281    59.333     0.200
     2.622    18.845     0.200
     2.881    19.539     0.200
     3.091    22.462     0.200
     3.613    28.234     0.200
     3.853    27.318     0.200
     4.489    31.670     0.200
     5.334    36.531     0.200
     5.542    40.094     0.200
     5.815    40.923     0.200
     6.569    48.697     0.200
     6.931    50.109     0.200
     7.353    53.968     0.200
     7.483    55.715     0.200
     7.602    55.820     0.200
     7.704    56.934     0.200
     7.933    57.908     0.200
     8.273    60.993     0.200
     8.579    62.154     0.200
     8.653    63.271     0.200
     2.627    17.727     0.200
     4.549    31.452     0.200
     5.340    38.448     0.200
     5.547    39.167     0.200
     6.574    47.240     0.200
     6.621    48.914     0.200
     6.932    49.100     0.200
     7.127    52.078     0.200
     7.489    52.443     0.200
     7.608    53.265     0.200
     7.711    53.932     0.200
     7.810    55.626     0.200
     7.919    55.760     0.200
     7.922    55.276     0.200
     7.944    53.867     0.200
     7.992    55.028     0.200
     8.107    57.929     0.200
     8.120    56.285     0.200
     8.278    60.230     0.200
     8.326    60.291     0.200
     2.679    21.851     0.200
     3.253    22.093     0.200
    11.290    82.602     0.200
     2.856    22.522     0.200
     3.027    21.174     0.200
     3.305    25.563     0.200
     4.307    28.198     0.200
     4.659    34.141     0.200
     5.560    41.215     0.200
     6.649    45.439     0.200
     6.788    49.393     0.200
     8.507    60.861     0.200
     3.658    24.737     0.200
     4.128    30.106     0.200
     4.232    27.710     0.200
     4.507    29.797     0.200
     5.610    40.040     0.200
     6.627    45.671     0.200
     7.005    48.560     0.200
     7.038    47.411     0.200
     7.367    54.047     0.200
     7.656    54.682     0.200
     7.820    59.684     0.200
     7.939    53.675     0.200
     7.941    53.536     0.200
     7.997    57.434     0.200
     8.057    58.929     0.200
     2.734    19.343     0.200
     3.002    20.024     0.200
     3.055    20.657     0.200
     3.221    21.826     0.200
     3.791    25.805     0.200
     4.254    27.941     0.200
     4.526    30.805     0.200
     5.427    37.921     0.200
     5.637    40.004     0.200
     5.690    41.384     0.200
     6.521    47.679     0.200
     6.634    46.365     0.200
     6.653    44.807     0.200
     7.788    53.196     0.200
     8.201    57.620     0.200
     8.228    58.268     0.200
     8.388    60.427     0.200
     8.797    59.056     0.200
     3.306    22.279     0.200
     3.182    22.620     0.200
     4.123    29.791     0.200
     7.795    53.503     0.200
     3.922    25.742     0.200
     3.844    28.568     0.200
     5.162    34.887     0.200
     5.647    40.709     0.200
     6.500    45.054     0.200
     3.216    23.165     0.200
     3.678    26.687     0.200
     3.730    24.817     0.200
     4.281    30.850     0.200
     5.343    37.697     0.200
     5.555    38.905     0.200
     7.081    51.588     0.200
     7.844    52.386     0.200
     7.849    52.474     0.200
     6.925    52.548     0.200
     6.969    52.388     0.200
     7.697    57.647     0.200
    11.198    85.614     0.200
    11.281    84.080     0.200
     5.984    45.036     0.200
     5.985    45.189     0.200
     6.601    45.556     0.200
     7.738    55.431     0.200
     8.139    60.663     0.200
     2.994    20.258     0.200
     3.208    23.081     0.200
     4.363    33.738     0.200
     4.228    32.210     0.200
     3.090    22.346     0.200
     4.715    34.546     0.200
     3.132    20.538     0.200
     3.460    24.262     0.200
     3.622    23.603     0.200
     2.789    19.463     0.200
     4.206    32.021     0.200
     4.205    28.296     0.200
     5.718    41.459     0.200
     5.951    45.033     0.200
     3.800    24.900     0.200
     2.885    21.342     0.200
     3.770    27.222     0.200
     4.823    36.440     0.200
     5.567    42.298     0.200
     5.778    38.434     0.200
     6.096    46.179     0.200
     6.154    43.228     0.200
     2.548    18.547     0.200
     3.946    28.291     0.200
     4.378    31.896     0.200
     5.331    40.096     0.200
     5.530    38.033     0.200
     5.613    40.111     0.200
     5.758    42.252     0.200
     6.630    44.448     0.200
     6.631    46.986     0.200
     7.538    53.590     0.200
     8.159    56.975     0.200
     3.945    26.963     0.200
     4.021    27.567     0.200
     5.579    42.052     0.200
     5.843    43.500     0.200
     6.753    47.297     0.200
     8.014    59.938     0.200
     8.058    55.437     0.200
     2.805    18.461     0.200
     3.909    28.412     0.200
     4.662    33.642     0.200
     5.303    36.832     0.200
     5.500    39.402     0.200
     5.717    40.779     0.200
     7.533    54.831     0.200
     2.663    19.652     0.200
     3.041    20.452     0.200
     4.026    27.575     0.200
     4.074    29.884     0.200
     4.538    32.605     0.200
     5.413    38.628     0.200
     5.788    42.565     0.200
     5.900    41.408     0.200
     7.703    53.419     0.200
     3.041    24.442     0.200
     3.565    27.970     0.200
     4.591    32.887     0.200
     5.688    41.034     0.200
     5.902    42.140     0.200
     6.318    47.564     0.200
     7.773    55.030     0.200
     7.907    59.142     0.200
     7.982    55.785     0.200
     8.276    61.399     0.200
     8.353    58.808     0.200
     8.699    65.073     0.200
     3.155    22.033     0.200
     6.578    47.664     0.200
     5.697    41.495     0.200
     5.965    44.995     0.200
     6.577    44.863     0.200
     7.035    49.813     0.200
     7.871    56.431     0.200
     8.431    64.176     0.200
    11.412    83.465     0.200
     6.093    44.767     0.200
     6.159    45.503     0.200
     6.708    47.788     0.200
     7.855    56.285     0.200
     2.929    22.988     0.200
     6.143    47.565     0.200
     6.199    45.589     0.200
     6.762    48.838     0.200
     8.585    61.013     0.200
     3.956    27.187     0.200
     4.556    32.457     0.200
     5.663    40.719     0.200
     6.247    46.234     0.200
     6.288    43.532     0.200
     6.851    45.522     0.200
     4.252    30.381     0.200
     5.698    40.909     0.200
     5.971    45.465     0.200
     6.584    48.629     0.200
     7.464    52.922     0.200
     7.847    54.163     0.200
     2.536    16.728     0.200
     3.934    29.580     0.200
     6.183    40.675     0.200
     6.125    40.774     0.200
     8.096    57.082     0.200
     3.335    23.550     0.200
     6.066    45.492     0.200
     6.679    46.267     0.200
     6.881    51.153     0.200
     3.805    26.649     0.200
     3.920    29.327     0.200
     4.638    33.723     0.200
     3.629    27.976     0.200
     6.962    52.298     0.200
     7.761    56.175     0.200
     8.746    64.081     0.200
     5.137    34.367     0.200
     7.794    58.741     0.200
     8.051    59.125     0.200
     8.167    59.444     0.200
     6.133    42.730     0.200
     6.770    48.906     0.200
     6.679    49.953     0.200
     6.679    49.948     0.200
     3.746    24.994     0.200
     3.913    25.514     0.200
     4.220    28.288     0.200
     4.622    33.655     0.200
     5.260    34.984     0.200
     5.457    40.183     0.200
     5.578    37.604     0.200
     5.678    40.213     0.200
     6.118    41.082     0.200
     6.507    46.837     0.200
     6.555    44.451     0.200
     7.493    54.194     0.200
     7.580    54.043     0.200
     7.845    57.882     0.200
     7.885    57.106     0.200
     8.017    56.265     0.200
     8.535    63.471     0.200
     2.835    18.414     0.200
     2.836    18.674     0.200
     2.861    21.140     0.200
     3.002    20.108     0.200
     3.331    22.957     0.200
     3.814    25.570     0.200
     4.214    28.587     0.200
     6.060    44.912     0.200
     6.127    45.988     0.200
     5.800    41.209     0.200
     6.685    46.421     0.200
     8.537    60.597     0.200
     6.066    41.851     0.200
     6.594    44.364     0.200
     7.900    58.510     0.200
     2.879    20.093     0.200
     3.796    28.100     0.200
     4.302    31.197     0.200
     4.370    29.631     0.200
     4.507    31.888     0.200
     7.815    53.278     0.200
     8.534    62.621     0.200
     8.534    61.989     0.200
     8.092    56.278     0.200
     2.782    22.871     0.200
     2.985    21.379     0.200
     3.036    21.573     0.200
     3.851    28.241     0.200
     6.543    47.488     0.200
     6.761    47.565     0.200
     6.761    47.564     0.200
     8.216    61.790     0.200
     8.282    61.773     0.200
     8.595    63.183     0.200
     3.307    22.187     0.200
     2.946    21.352     0.200
     3.439    25.573     0.200
     3.746    27.748     0.200
     4.369    32.779     0.200
     4.645    33.686     0.200
     5.447    40.082     0.200
     5.619    41.152     0.200
     3.867    28.317     0.200
     4.407    32.598     0.200
     6.068    44.977     0.200
     6.602    47.237     0.200
     2.963    19.921     0.200
     3.230    20.948     0.200
     3.279    21.986     0.200
     3.700    26.020     0.200
     4.387    29.851     0.200
     4.500    30.277     0.200
     4.628    32.177     0.200
     6.193    46.220     0.200
     6.816    46.975     0.200
     7.084    51.289     0.200
     7.474    51.010     0.200
     7.854    54.656     0.200
     2.665    19.396     0.200
     3.866    27.406     0.200
     3.876    25.558     0.200
     4.670    33.514     0.200
     5.470    36.751     0.200
     5.668    40.558     0.200
     6.527    45.427     0.200
     8.058    57.189     0.200
     6.316    42.829     0.200
     2.781    19.832     0.200
     3.743    27.692     0.200
     3.885    29.168     0.200
     3.917    28.340     0.200
     4.243    30.639     0.200
     5.282    37.484     0.200
     6.558    48.053     0.200
     7.521    56.386     0.200
     8.044    58.912     0.200
     6.123    40.485     0.200
     8.096    58.854     0.200
     2.779    20.777     0.200
     2.987    21.399     0.200
     3.038    21.122     0.200
     3.239    22.886     0.200
     3.847    28.247     0.200
     4.200    29.847     0.200
     4.254    30.362     0.200
     4.390    31.926     0.200
     4.595    33.742     0.200
     5.692    41.921     0.200
     6.583    47.466     0.200
     6.694    48.673     0.200
     6.094    40.063     0.200
     8.078    59.221     0.200
     8.127    60.594     0.200
     3.182    21.510     0.200
     3.953    27.631     0.200
     4.185    30.440     0.200
     4.328    28.713     0.200
     5.924    44.675     0.200
     6.019    45.677     0.200
     6.527    47.750     0.200
     4.441    33.689     0.200
     8.052    57.731     0.200
     3.043    24.099     0.200
     4.007    27.482     0.200
     4.468    33.631     0.200
     4.605    31.596     0.200
     6.288    46.825     0.200
     6.048    39.941     0.200
     8.046    58.720     0.200
     5.681    39.305     0.200
     3.739    24.997     0.200
     2.634    17.271     0.200
     3.910    25.557     0.200
     4.666    31.037     0.200
     4.722    36.115     0.200
     6.118    40.420     0.200
     6.549    45.732     0.200
     8.097    57.453     0.200
     3.863    25.441     0.200
     5.661    39.094     0.200
     6.500    44.374     0.200
     2.888    22.665     0.200
     3.359    24.344     0.200
     3.806    27.638     0.200
     4.310    30.749     0.200
     4.370    29.286     0.200
     6.154    45.357     0.200
     6.781    48.909     0.200
     3.361    23.019     0.200
     6.155    45.639     0.200
     3.834    25.316     0.200
     4.066    26.720     0.200
     2.705    17.508     0.200
     3.865    26.598     0.200
     5.658    39.164     0.200
     3.938    29.232     0.200
     3.977    27.880     0.200
     3.983    26.205     0.200
     4.207    31.293     0.200
     4.297    29.633     0.200
     4.661    35.073     0.200
     7.917    58.732     0.200
     7.952    55.958     0.200
     7.955    58.028     0.200
     8.042    55.459     0.200
     2.594    17.761     0.200
     3.689    24.491     0.200
     4.358    31.796     0.200
     4.662    32.121     0.200
     3.889    29.304     0.200
     3.906    28.224     0.200
     5.536    40.039     0.200
     3.835    30.279     0.200
     3.442    23.817     0.200
     4.375    32.468     0.200
     6.167    46.880     0.200
     6.223    46.097     0.200
     6.785    48.905     0.200
     2.719    17.917     0.200
     5.662    40.542     0.200
     7.902    58.478     0.200
     3.665    27.644     0.200
     5.654    41.551     0.200
     6.842    49.860     0.200
     6.860    49.571     0.200
     7.953    59.205     0.200
     4.180    31.590     0.200
     4.583    33.798     0.200
     5.465    39.964     0.200
     6.384    47.313     0.200
     3.848    28.509     0.200
     4.279    32.809     0.200
     4.463    33.467     0.200
     5.558    39.973     0.200
     6.046    47.172     0.200
     6.120    45.907     0.200
     6.657    47.497     0.200
     6.766    50.515     0.200
     6.785    51.978     0.200
     7.908    54.286     0.200
     8.086    59.288     0.200
     8.090    58.245     0.200
     8.929    65.858     0.200
     6.064    40.306     0.200
     8.073    58.487     0.200
     2.748    20.521     0.200
     3.836    25.290     0.200
     3.868    26.718     0.200
     4.374    29.338     0.200
     4.728    34.176     0.200
     5.297    36.854     0.200
     5.661    40.240     0.200
     6.048    40.208     0.200
     6.468    43.371     0.200
     7.598    58.242     0.200
     7.633    55.714     0.200
     8.066    57.282     0.200
     6.040    39.759     0.200
     8.059    58.267     0.200
     2.708    19.051     0.200
     3.870    25.361     0.200
     3.885    29.178     0.200
     5.683    40.529     0.200
     6.081    40.344     0.200
     6.504    45.519     0.200
     7.920    56.915     0.200
     8.075    58.277     0.200
     8.087    58.359     0.200
     6.455    43.170     0.200
     2.603    19.460     0.200
     2.812    18.539     0.200
     3.917    29.527     0.200
     4.238    29.936     0.200
     5.574    39.516     0.200
     5.725    40.825     0.200
     6.586    46.975     0.200
     6.587    46.663     0.200
     8.044    54.956     0.200
     8.065    60.953     0.200
     4.432    32.641     0.200
     5.713    39.288     0.200
     6.066    44.128     0.200
     7.200    51.986     0.200
     3.057    19.997     0.200
     3.964    26.942     0.200
     8.187    59.486     0.200
     2.959    23.883     0.200
     4.643    34.280     0.200
     6.158    45.830     0.200
     2.827    21.149     0.200
     3.280    21.997     0.200
     4.247    29.122     0.200
     4.288    28.433     0.200
     4.430    31.929     0.200
     5.531    38.504     0.200
     6.088    42.507     0.200
     2.873    21.876     0.200
     3.820    26.823     0.200
     4.294    31.735     0.200
     4.490    31.516     0.200
     5.566    37.671     0.200
     5.801    41.840     0.200
     6.138    45.623     0.200
     7.817    53.831     0.200
     3.372    22.016     0.200
     3.655    24.215     0.200
     3.702    27.922     0.200
     4.085    29.098     0.200
     5.488    38.520     0.200
     5.867    38.744     0.200
     5.939    45.916     0.200
     7.621    53.724     0.200
     7.753    58.512     0.200
     7.848    58.336     0.200
     7.894    53.795     0.200
     7.894    55.795     0.200
     8.198    58.572     0.200
     8.393    61.999     0.200
     2.603    17.354     0.200
     7.713    56.478     0.200
     2.642    21.419     0.200
     2.773    18.146     0.200
     3.487    23.208     0.200
     3.626    23.883     0.200
     3.890    29.237     0.200
     5.695    40.157     0.200
     6.654    46.486     0.200
     2.558    19.268     0.200
     2.716    20.856     0.200
     5.208    34.031     0.200
     5.738    41.258     0.200
     5.777    44.888     0.200
     6.091    43.993     0.200
     6.151    43.182     0.200
     6.544    44.355     0.200
     7.804    59.202     0.200
     7.979    61.046     0.200
     8.041    54.812     0.200
     8.074    57.983     0.200
     6.755    49.469     0.200
     5.969    41.089     0.200
     2.505    18.737     0.200
     3.258    22.146     0.200
     3.304    22.344     0.200
     3.952    26.670     0.200
     4.341    31.094     0.200
     4.623    35.588     0.200
     5.567    40.001     0.200
     6.606    45.869     0.200
     3.761    26.461     0.200
     4.603    32.304     0.200
     4.668    32.743     0.200
     6.236    45.876     0.200
     3.430    24.763     0.200
     4.444    31.775     0.200
     4.582    32.955     0.200
     4.655    33.196     0.200
     4.883    36.255     0.200
     5.115    39.466     0.200
     6.214    43.157     0.200
     6.773    50.451     0.200
     6.915    48.680     0.200
     3.292    23.242     0.200
     3.939    27.806     0.200
     4.329    32.024     0.200
     4.623    34.078     0.200
     4.826    36.840     0.200
     4.987    36.182     0.200
     5.562    42.620     0.200
     5.707    40.525     0.200
     5.707    41.083     0.200
     6.116    45.067     0.200
     6.127    42.935     0.200
     6.154    43.626     0.200
     7.933    58.970     0.200
     8.108    58.601     0.200
     6.927    52.955     0.200
     6.928    51.196     0.200
     4.485    30.553     0.200
     6.700    49.596     0.200
     6.135    45.050     0.200
     7.027    49.113     0.200
     7.078    53.973     0.200
     7.374    56.524     0.200
     7.676    54.776     0.200
     3.336    22.828     0.200
     3.830    25.190     0.200
     5.779    45.329     0.200
     6.138    43.099     0.200
     6.638    49.905     0.200
     6.680    51.024     0.200
     7.137    53.499     0.200
     7.155    54.360     0.200
     7.498    50.082     0.200
     7.757    56.483     0.200
     3.245    21.284     0.200
     4.275    33.749     0.200
     4.475    29.739     0.200
     4.613    31.914     0.200
     4.912    36.330     0.200
     5.642    41.343     0.200
     5.835    42.117     0.200
     6.241    45.253     0.200
     4.356    30.423     0.200
     4.501    29.597     0.200
     6.257    47.524     0.200
     6.654    51.460     0.200
     6.696    50.856     0.200
     7.168    54.152     0.200
     7.772    55.598     0.200
     2.876    19.117     0.200
     3.536    25.048     0.200
     6.179    42.564     0.200
     6.634    47.144     0.200
     6.669    47.838     0.200
     6.669    46.939     0.200
     6.913    49.441     0.200
     7.873    55.946     0.200
     8.038    57.233     0.200
     3.024    21.741     0.200
     4.221    31.234     0.200
     6.245    48.180     0.200
     3.337    24.630     0.200
     4.347    31.207     0.200
     4.799    36.251     0.200
     6.136    45.866     0.200
     6.357    46.777     0.200
     4.227    28.405     0.200
     4.451    31.798     0.200
     7.043    49.259     0.200
     3.328    22.425     0.200
     3.691    25.032     0.200
     3.849    28.294     0.200
     4.482    32.102     0.200
     4.665    33.903     0.200
     5.551    40.717     0.200
     7.887    55.913     0.200
     2.875    23.319     0.200
     3.071    20.322     0.200
     3.120    20.766     0.200
     3.340    26.390     0.200
     4.138    27.790     0.200
     4.348    32.741     0.200
     4.490    34.725     0.200
     4.803    35.698     0.200
     5.681    40.358     0.200
     6.140    45.210     0.200
     6.429    50.861     0.200
     7.913    57.357     0.200
     5.412    42.601     0.200
     6.635    49.152     0.200
     6.677    49.019     0.200
     7.135    53.442     0.200
     7.199    51.486     0.200
     7.748    59.171     0.200
     8.001    56.925     0.200
     4.370    29.865     0.200
     4.883    37.741     0.200
     5.738    42.400     0.200
     5.829    44.437     0.200
     8.119    56.262     0.200
     3.455    22.962     0.200
     5.909    39.868     0.200
     5.909    38.936     0.200
     6.313    42.541     0.200
     6.460    43.563     0.200
     6.686    44.759     0.200
     6.895    49.324     0.200
     7.873    56.187     0.200
     8.340    57.626     0.200
     2.951    23.130     0.200
     3.436    26.290     0.200
     3.766    24.509     0.200
     4.587    32.711     0.200
     4.662    32.412     0.200
     4.890    36.019     0.200
     5.628    39.603     0.200
     6.737    48.310     0.200
     6.779    51.633     0.200
     7.029    49.556     0.200
     7.239    51.339     0.200
     6.680    49.329     0.200
     3.034    20.782     0.200
     3.654    24.212     0.200
     2.763    19.135     0.200
     2.903    20.466     0.200
     3.624    26.281     0.200
     3.714    25.559     0.200
     5.969    44.152     0.200
     2.597    17.208     0.200
     3.177    21.700     0.200
     3.209    23.145     0.200
     3.601    23.649     0.200
     3.660    25.271     0.200
     3.805    27.436     0.200
     3.919    27.498     0.200
     4.012    27.438     0.200
     4.591    31.924     0.200
     6.554    47.792     0.200
     8.378    57.526     0.200
     6.567    45.203     0.200
     6.546    44.854     0.200
     7.745    54.918     0.200
     8.356    60.768     0.200
     7.937    55.256     0.200
     6.152    42.560     0.200
     8.046    57.435     0.200
     4.262    30.226     0.200
     6.241    41.349     0.200
     6.051    41.006     0.200
     7.893    56.259     0.200
     7.950    53.469     0.200
     6.065    39.979     0.200
     7.888    57.896     0.200
     7.960    57.038     0.200
     7.890    56.703     0.200
     7.963    56.314     0.200
     6.526    42.934     0.200
     7.772    54.656     0.200
     8.347    60.650     0.200
     6.513    43.437     0.200
     7.760    52.902     0.200
     8.331    57.994     0.200
     7.772    55.142     0.200
     8.336    57.659     0.200
     7.775    56.463     0.200
     8.340    57.844     0.200
     6.508    46.646     0.200
     8.320    59.266     0.200
     8.341    59.581     0.200
     8.330    57.521     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.103     0.754     0.200
     0.073     1.211     0.200
     0.340     3.073     0.200
     0.425     3.158     0.200
     0.469     2.905     0.200
     0.605     3.731     0.200
     0.614     3.843     0.200
     0.720     4.921     0.200
     0.760     4.186     0.200
     0.733     5.398     0.200
     0.733     5.718     0.200
     1.186     7.744     0.200
     0.467     2.980     0.200
     0.609     3.798     0.200
     0.713     4.832     0.200
     0.716     4.869     0.200
     0.750     4.919     0.200
     0.776     4.495     0.200
     1.275     8.619     0.200
     1.328     7.996     0.200
     5.654    34.138     0.200
     0.403     2.999     0.200
     0.501     3.229     0.200
     0.517     3.788     0.200
     0.570     3.934     0.200
     0.630     4.141     0.200
     0.649     4.022     0.200
     0.740     4.138     0.200
     0.758     5.127     0.200
     0.793     5.127     0.200
     0.806     4.636     0.200
     1.225     8.013     0.200
     1.324     8.311     0.200
     1.330     8.626     0.200
     1.354     8.211     0.200
     1.379     8.868     0.200
     0.477     3.072     0.200
     0.625     3.834     0.200
     0.734     4.896     0.200
     0.740     3.935     0.200
     1.205     7.177     0.200
     1.312     9.191     0.200
     1.367     8.552     0.200
     7.023    43.119     0.200
     0.052     1.066     0.200
     0.086     1.245     0.200
     0.111     0.767     0.200
     0.212     0.912     0.200
     0.274     1.974     0.200
     0.316     2.275     0.200
     0.333     1.906     0.200
     0.378     2.242     0.200
     0.527     3.322     0.200
     0.639     4.487     0.200
     0.681     4.868     0.200
     0.759     5.127     0.200
     0.798     4.971     0.200
     0.914     5.340     0.200
     0.954     6.395     0.200
     0.973     6.305     0.200
     1.102     7.329     0.200
     1.126     7.246     0.200
     2.686    17.018     0.200
     3.805    24.210     0.200
     0.153     0.986     0.200
     0.203     0.626     0.200
     0.179     1.351     0.200
     0.207     1.356     0.200
     0.216     1.632     0.200
     0.250     1.632     0.200
     0.396     2.281     0.200
     0.674     4.578     0.200
     0.762     5.012     0.200
     0.912     5.342     0.200
     0.912     5.162     0.200
     0.867     5.590     0.200
     0.957     5.666     0.200
     0.964     5.617     0.200
     1.013     6.417     0.200
     1.086     6.957     0.200
     1.234     7.862     0.200
     1.306     7.738     0.200
     1.257     7.997     0.200
     2.254    13.247     0.200
     2.594    16.572     0.200
     3.534    22.655     0.200
     5.934    34.425     0.200
     0.055     1.033     0.200
     0.055     0.721     0.200
     0.080     1.316     0.200
     0.100     0.820     0.200
     0.219     1.061     0.200
     0.271     2.108     0.200
     0.265     1.955     0.200
     0.314     2.310     0.200
     0.336     1.825     0.200
     0.390     2.250     0.200
     0.535     3.325     0.200
     0.640     4.395     0.200
     0.671     3.799     0.200
     0.749     4.963     0.200
     0.793     4.837     0.200
     0.950     6.333     0.200
     0.999     5.842     0.200
     1.098     7.243     0.200
     1.121     7.305     0.200
     2.156    12.266     0.200
     2.163    13.936     0.200
     2.289    13.023     0.200
     2.336    14.971     0.200
     2.482    14.030     0.200
     2.518    14.307     0.200
     2.738    16.080     0.200
     2.960    16.130     0.200
     3.213    16.946     0.200
     3.582    18.583     0.200
     3.582    23.021     0.200
     3.743    24.334     0.200
     5.107    31.255     0.200
     0.034     1.302     0.200
     0.070     1.387     0.200
     0.143     2.408     0.200
     0.400     2.788     0.200
     0.422     3.513     0.200
     0.441     3.424     0.200
     0.466     3.676     0.200
     0.528     3.676     0.200
     0.551     3.513     0.200
     0.565     3.783     0.200
     0.625     3.673     0.200
     0.641     3.680     0.200
     0.657     3.981     0.200
     0.696     4.379     0.200
     0.696     4.635     0.200
     0.703     4.326     0.200
     0.711     4.279     0.200
     0.746     5.697     0.200
     0.725     3.692     0.200
     0.725     4.099     0.200
     0.725     3.909     0.200
     0.909     5.323     0.200
     1.002     5.564     0.200
     1.033     5.643     0.200
     1.348     8.562     0.200
     1.811    13.916     0.200
     2.178    12.555     0.200
     0.024     1.252     0.200
     0.075     0.864     0.200
     0.136     2.364     0.200
     0.406     2.774     0.200
     0.433     3.465     0.200
     0.450     3.181     0.200
     0.455     3.717     0.200
     0.537     3.652     0.200
     0.556     3.557     0.200
     0.625     3.752     0.200
     0.650     3.635     0.200
     0.658     3.779     0.200
     0.701     4.694     0.200
     0.711     4.329     0.200
     0.733     4.000     0.200
     0.733     3.656     0.200
     0.740     5.593     0.200
     0.991     5.786     0.200
     1.039     5.809     0.200
     1.151     7.254     0.200
     1.173     6.517     0.200
     1.343     8.529     0.200
     0.046     1.509     0.200
     0.385     2.596     0.200
     0.412     3.334     0.200
     0.439     3.182     0.200
     0.475     3.648     0.200
     0.514     3.477     0.200
     0.536     3.322     0.200
     0.637     3.709     0.200
     0.627     3.522     0.200
     0.669     3.795     0.200
     0.682     4.473     0.200
     0.688     4.115     0.200
     0.726     3.922     0.200
     0.742     5.378     0.200
     1.018     5.489     0.200
     1.342     8.128     0.200
     2.884    14.853     0.200
     6.432    35.254     0.200
     0.036     1.321     0.200
     0.088     1.452     0.200
     0.152     2.729     0.200
     0.425     3.006     0.200
     0.454     2.932     0.200
     0.462     3.846     0.200
     0.538     3.220     0.200
     0.642     3.398     0.200
     0.636     3.546     0.200
     0.675     3.701     0.200
     0.683     4.273     0.200
     0.694     4.052     0.200
     0.740     3.812     0.200
     0.740     4.488     0.200
     0.729     5.743     0.200
     0.999     5.928     0.200
     1.134     7.608     0.200
     1.155     7.238     0.200
     1.331     8.627     0.200
     0.045     0.962     0.200
     0.413     3.232     0.200
     0.439     3.118     0.200
     0.475     3.480     0.200
     0.538     3.324     0.200
     0.635     3.694     0.200
     0.628     3.511     0.200
     0.668     3.757     0.200
     0.683     4.287     0.200
     0.690     4.189     0.200
     0.726     3.932     0.200
     0.743     5.377     0.200
     1.011     6.847     0.200
     1.020     5.644     0.200
     1.140     6.982     0.200
     1.343     8.425     0.200
     2.940    16.875     0.200
     0.045     0.203     0.200
     0.414     3.195     0.200
     0.444     3.109     0.200
     0.473     3.696     0.200
     0.533     3.475     0.200
     0.627     3.498     0.200
     0.641     3.787     0.200
     0.679     4.508     0.200
     0.674     3.869     0.200
     0.687     4.152     0.200
     0.732     3.957     0.200
     0.737     5.563     0.200
     1.016     5.688     0.200
     1.134     7.033     0.200
     1.152     6.374     0.200
     1.337     8.255     0.200
     1.379     8.426     0.200
     2.883    14.788     0.200
     0.031     1.410     0.200
     0.401     2.820     0.200
     0.463     3.574     0.200
     0.552     3.531     0.200
     0.643     3.707     0.200
     0.626     3.756     0.200
     0.705     4.332     0.200
     0.728     4.019     0.200
     0.728     4.136     0.200
     0.998     7.172     0.200
     1.035     5.688     0.200
     1.150     6.930     0.200
     1.346     8.266     0.200
     1.405     9.473     0.200
     0.031     0.406     0.200
     0.398     2.686     0.200
     0.427     3.295     0.200
     0.449     3.205     0.200
     0.461     3.878     0.200
     0.529     3.532     0.200
     0.547     3.547     0.200
     0.642     3.182     0.200
     0.664     4.032     0.200
     0.659     4.641     0.200
     0.702     4.280     0.200
     0.734     3.893     0.200
     0.737     4.920     0.200
     0.997     6.560     0.200
     1.339     8.733     0.200
     1.383     8.581     0.200
     2.898    14.589     0.200
     2.952    17.460     0.200
     0.046     1.342     0.200
     0.085     1.548     0.200
     0.161     2.485     0.200
     0.381     2.643     0.200
     0.414     3.390     0.200
     0.444     3.316     0.200
     0.513     3.532     0.200
     0.532     3.348     0.200
     0.626     3.622     0.200
     0.643     3.450     0.200
     0.645     4.446     0.200
     0.675     3.895     0.200
     0.686     4.192     0.200
     0.677     4.401     0.200
     0.736     5.326     0.200
     1.015     5.675     0.200
     1.133     6.890     0.200
     1.151     6.892     0.200
     2.936    15.666     0.200
     0.380     2.624     0.200
     0.417     3.346     0.200
     0.450     3.300     0.200
     0.513     3.475     0.200
     0.529     3.379     0.200
     0.626     3.508     0.200
     0.641     4.433     0.200
     0.648     3.790     0.200
     0.685     4.360     0.200
     0.674     4.468     0.200
     0.680     3.834     0.200
     0.729     5.363     0.200
     1.012     5.661     0.200
     1.147     6.349     0.200
     1.128     6.926     0.200
     2.880    16.820     0.200
     3.554    22.904     0.200
     5.547    29.937     0.200
     6.574    35.470     0.200
     0.018     0.979     0.200
     0.104     0.969     0.200
     0.119     2.389     0.200
     0.424     2.886     0.200
     0.449     3.341     0.200
     0.487     3.360     0.200
     0.564     3.710     0.200
     0.568     3.697     0.200
     0.678     3.733     0.200
     0.635     3.873     0.200
     0.675     4.798     0.200
     0.669     4.024     0.200
     0.711     4.871     0.200
     0.733     4.410     0.200
     0.767     4.051     0.200
     0.712     5.782     0.200
     1.053     6.036     0.200
     1.144     7.474     0.200
     1.179     6.558     0.200
     1.319     8.119     0.200
     2.981    17.609     0.200
     0.408     2.917     0.200
     0.405     2.796     0.200
     0.479     3.425     0.200
     0.478     3.138     0.200
     0.493     3.821     0.200
     0.495     3.936     0.200
     0.580     3.401     0.200
     0.609     4.096     0.200
     0.626     3.862     0.200
     0.734     4.919     0.200
     0.769     4.797     0.200
     0.784     4.519     0.200
     0.752     5.351     0.200
     0.934     5.902     0.200
     1.238     7.674     0.200
     1.364     8.709     0.200
     1.415     8.582     0.200
     1.849    11.484     0.200
     2.032    11.188     0.200
     2.116    13.069     0.200
     2.492    15.812     0.200
     2.998    16.158     0.200
     3.177    20.390     0.200
     3.268    17.313     0.200
     3.688    19.370     0.200
     3.723    19.719     0.200
     0.198     0.282     0.200
     0.248     2.080     0.200
     0.535     3.510     0.200
     0.586     4.276     0.200
     0.649     4.040     0.200
     0.667     4.210     0.200
     0.729     4.537     0.200
     0.753     4.483     0.200
     0.788     5.367     0.200
     1.122     7.285     0.200
     1.213     7.266     0.200
     1.177     7.549     0.200
     1.206     7.817     0.200
     1.206     7.297     0.200
     3.075    18.902     0.200
     3.863    24.488     0.200
     0.480     3.245     0.200
     0.508     3.463     0.200
     0.514     3.896     0.200
     0.601     3.557     0.200
     0.619     4.126     0.200
     0.623     4.038     0.200
     0.635     3.574     0.200
     0.724     5.441     0.200
     0.728     4.812     0.200
     0.732     4.003     0.200
     0.765     5.200     0.200
     0.774     4.042     0.200
     0.789     4.692     0.200
     1.109     6.154     0.200
     1.230     6.885     0.200
     1.288     8.066     0.200
     1.337     8.449     0.200
     1.330     8.049     0.200
     1.390     8.554     0.200
     3.037    18.062     0.200
     5.400    32.547     0.200
     6.726    37.744     0.200
     0.059     0.689     0.200
     0.139     1.808     0.200
     0.162     2.354     0.200
     0.388     2.614     0.200
     0.463     3.482     0.200
     0.507     3.432     0.200
     0.527     3.398     0.200
     0.538     3.499     0.200
     0.652     3.596     0.200
     0.668     4.584     0.200
     0.676     5.099     0.200
     0.715     4.029     0.200
     1.013     5.774     0.200
     1.097     7.259     0.200
     1.279     8.374     0.200
     2.781    15.391     0.200
     4.239    23.818     0.200
     0.209     1.590     0.200
     0.329     2.754     0.200
     0.358     2.644     0.200
     0.362     2.362     0.200
     0.463     3.403     0.200
     0.481     3.423     0.200
     0.517     3.475     0.200
     0.708     5.034     0.200
     0.987     6.181     0.200
     0.997     6.740     0.200
     1.272     8.226     0.200
     1.299     8.247     0.200
     0.085     0.474     0.200
     0.535     3.593     0.200
     0.498     3.257     0.200
     0.541     3.867     0.200
     0.643     3.858     0.200
     0.675     3.762     0.200
     0.641     4.231     0.200
     0.799     4.194     0.200
     0.755     4.127     0.200
     0.708     5.143     0.200
     0.776     5.279     0.200
     0.808     4.756     0.200
     1.123     6.271     0.200
     1.323     8.263     0.200
     7.100    43.912     0.200
     0.265     2.361     0.200
     0.464     2.246     0.200
     0.534     3.343     0.200
     0.559     3.319     0.200
     0.629     4.452     0.200
     0.632     4.008     0.200
     0.643     4.380     0.200
     0.799     5.194     0.200
     0.831     5.144     0.200
     0.825     5.667     0.200
     0.839     6.125     0.200
     0.901     5.313     0.200
     0.876     6.280     0.200
     0.876     5.698     0.200
     0.904     6.014     0.200
     0.933     6.542     0.200
     0.977     6.200     0.200
     0.984     6.141     0.200
     1.088     7.385     0.200
     1.934    11.110     0.200
     2.671    14.943     0.200
     2.877    15.937     0.200
     3.059    16.886     0.200
     3.351    19.844     0.200
     3.541    20.203     0.200
     0.046     0.381     0.200
     0.086     0.987     0.200
     0.119     1.168     0.200
     0.444     3.235     0.200
     0.461     2.946     0.200
     0.499     2.663     0.200
     0.487     3.585     0.200
     0.507     3.484     0.200
     0.602     3.954     0.200
     0.603     3.821     0.200
     0.639     3.886     0.200
     0.716     3.993     0.200
     0.707     4.693     0.200
     0.712     4.818     0.200
     0.744     5.001     0.200
     0.779     4.245     0.200
     0.779     4.120     0.200
     0.770     4.564     0.200
     0.791     4.563     0.200
     0.868     5.100     0.200
     0.969     5.617     0.200
     1.089     5.999     0.200
     1.089     6.005     0.200
     1.167     7.488     0.200
     1.923    13.800     0.200
     2.857    16.262     0.200
     2.965    18.322     0.200
     3.370    18.262     0.200
     0.062     0.216     0.200
     0.135     1.383     0.200
     0.084     0.955     0.200
     0.458     3.348     0.200
     0.467     3.764     0.200
     0.500     3.583     0.200
     0.524     3.615     0.200
     0.502     3.060     0.200
     0.616     3.948     0.200
     0.611     3.913     0.200
     0.729     3.996     0.200
     0.713     4.675     0.200
     0.702     4.986     0.200
     0.751     4.951     0.200
     0.782     4.652     0.200
     0.793     4.216     0.200
     0.807     4.582     0.200
     0.882     5.129     0.200
     0.978     5.661     0.200
     1.098     6.066     0.200
     1.097     6.071     0.200
     1.167     7.509     0.200
     1.419     8.950     0.200
     1.530     9.600     0.200
     1.536     9.455     0.200
     2.831    15.815     0.200
     2.865    16.488     0.200
     2.976    16.439     0.200
     3.029    17.462     0.200
     3.176    18.177     0.200
     0.223     1.558     0.200
     0.226     1.706     0.200
     0.573     4.500     0.200
     0.601     3.874     0.200
     0.623     4.123     0.200
     0.652     4.436     0.200
     0.667     4.083     0.200
     0.693     4.219     0.200
     0.729     4.793     0.200
     0.743     4.751     0.200
     0.762     4.531     0.200
     1.041     6.949     0.200
     1.124     6.974     0.200
     1.149     7.248     0.200
     1.150     7.184     0.200
     1.193     7.622     0.200
     3.092    17.391     0.200
     0.194     1.576     0.200
     0.235     1.615     0.200
     0.306     1.753     0.200
     0.350     2.228     0.200
     0.371     2.526     0.200
     0.384     2.680     0.200
     0.381     3.231     0.200
     0.482     3.544     0.200
     0.458     3.851     0.200
     0.692     4.537     0.200
     0.692     4.541     0.200
     0.788     4.107     0.200
     0.788     4.428     0.200
     0.758     4.635     0.200
     0.778     4.978     0.200
     0.866     5.406     0.200
     2.463    13.248     0.200
     2.463    13.248     0.200
     2.546    15.520     0.200
     2.601    13.471     0.200
     3.610    19.875     0.200
     0.089     0.819     0.200
     0.100     0.874     0.200
     0.179     1.285     0.200
     0.230     1.418     0.200
     0.253     1.027     0.200
     0.537     3.204     0.200
     0.536     3.209     0.200
     0.523     4.143     0.200
     0.606     4.736     0.200
     0.709     4.486     0.200
     0.799     5.404     0.200
     0.799     5.523     0.200
     0.862     5.177     0.200
     0.918     5.124     0.200
     1.091     6.518     0.200
     2.454    16.598     0.200
     2.460    14.182     0.200
     2.607    15.096     0.200
     2.725    17.149     0.200
     3.081    18.138     0.200
     3.684    23.577     0.200
     0.149     2.249     0.200
     0.418     3.168     0.200
     0.466     3.160     0.200
     0.519     2.935     0.200
     0.563     3.811     0.200
     0.702     3.692     0.200
     0.716     4.447     0.200
     0.787     4.101     0.200
     0.832     5.079     0.200
     0.861     5.231     0.200
     2.074    11.979     0.200
     2.354    14.085     0.200
     2.404    14.745     0.200
     4.408    28.681     0.200
     0.084     2.368     0.200
     0.035     2.094     0.200
     0.351     2.516     0.200
     0.488     3.379     0.200
     0.483     3.505     0.200
     0.543     3.972     0.200
     0.569     3.572     0.200
     0.564     3.240     0.200
     0.453     2.993     0.200
     0.597     4.094     0.200
     0.638     4.137     0.200
     0.572     3.218     0.200
     0.708     3.906     0.200
     0.688     3.513     0.200
     0.688     3.864     0.200
     0.747     4.344     0.200
     0.752     5.250     0.200
     0.780     4.503     0.200
     0.784     5.099     0.200
     0.806     5.643     0.200
     0.992     5.491     0.200
     1.118     5.932     0.200
     1.118     5.936     0.200
     1.238     7.630     0.200
     1.570    11.284     0.200
     0.101     1.616     0.200
     0.320     2.258     0.200
     0.430     2.836     0.200
     0.494     2.792     0.200
     0.463     3.042     0.200
     0.460     3.591     0.200
     0.517     3.614     0.200
     0.528     3.378     0.200
     0.569     3.337     0.200
     0.622     3.738     0.200
     0.654     3.457     0.200
     0.741     4.715     0.200
     0.829     5.243     0.200
     1.537     9.357     0.200
     0.022     2.237     0.200
     0.101     2.203     0.200
     0.416     2.158     0.200
     0.399     3.551     0.200
     0.523     3.649     0.200
     0.571     3.498     0.200
     0.612     3.359     0.200
     0.647     4.106     0.200
     0.672     4.336     0.200
     0.731     3.987     0.200
     0.731     3.642     0.200
     0.759     3.842     0.200
     0.781     5.099     0.200
     0.784     6.054     0.200
     0.816     5.127     0.200
     0.919     5.165     0.200
     1.266     8.041     0.200
     1.399     8.669     0.200
     1.471     8.250     0.200
     1.453     8.701     0.200
     1.622    10.879     0.200
     2.772    14.821     0.200
     0.128     0.684     0.200
     0.142     1.190     0.200
     0.512     3.363     0.200
     0.590     4.016     0.200
     0.658     4.783     0.200
     0.641     4.021     0.200
     0.667     4.383     0.200
     0.686     4.416     0.200
     0.734     4.690     0.200
     0.781     4.261     0.200
     0.841     4.970     0.200
     0.825     4.997     0.200
     0.856     4.598     0.200
     0.856     4.457     0.200
     1.137     7.604     0.200
     1.126     6.420     0.200
     1.161     7.565     0.200
     0.142     1.127     0.200
     0.129     0.678     0.200
     0.658     4.868     0.200
     0.734     4.643     0.200
     0.781     4.228     0.200
     0.840     5.011     0.200
     0.856     4.474     0.200
     0.856     4.964     0.200
     1.127     6.420     0.200
     1.137     7.579     0.200
     1.161     7.520     0.200
     0.073     1.152     0.200
     0.366     2.660     0.200
     0.744     4.212     0.200
     0.784     4.085     0.200
     0.898     6.414     0.200
     1.118     6.400     0.200
     1.317     8.493     0.200
     1.318     8.136     0.200
     2.157    13.117     0.200
     3.399    18.047     0.200
     0.144     0.853     0.200
     0.160     1.302     0.200
     0.289     2.227     0.200
     0.644     4.216     0.200
     0.677     4.379     0.200
     0.699     4.268     0.200
     0.791     4.507     0.200
     0.827     5.247     0.200
     0.873     4.672     0.200
     1.129     6.579     0.200
     1.154     7.633     0.200
     1.227     7.537     0.200
     0.148     0.939     0.200
     0.162     1.325     0.200
     0.222     2.118     0.200
     0.284     1.505     0.200
     0.305     3.405     0.200
     0.538     3.868     0.200
     0.524     3.530     0.200
     0.549     4.260     0.200
     0.565     4.018     0.200
     0.611     3.980     0.200
     0.611     4.255     0.200
     0.650     4.193     0.200
     0.698     4.265     0.200
     0.683     4.525     0.200
     0.796     4.504     0.200
     0.837     5.207     0.200
     0.876     5.181     0.200
     0.876     4.595     0.200
     1.135     6.650     0.200
     1.158     8.210     0.200
     1.228     8.030     0.200
     1.228     8.173     0.200
     1.232     8.187     0.200
     0.840     5.781     0.200
     0.880     6.299     0.200
     1.864    10.555     0.200
     2.112    13.108     0.200
     0.230     1.678     0.200
     0.190     1.231     0.200
     0.689     4.190     0.200
     0.918     5.434     0.200
     0.928     4.970     0.200
     0.928     5.407     0.200
     0.218     2.476     0.200
     0.577     3.679     0.200
     0.674     4.379     0.200
     0.695     4.571     0.200
     0.742     4.788     0.200
     0.856     4.605     0.200
     1.163     7.949     0.200
     1.164     8.014     0.200
     1.169     7.348     0.200
     1.238     7.729     0.200
     2.839    18.108     0.200
     3.073    18.170     0.200
     3.122    18.461     0.200
     3.269    18.287     0.200
     3.395    20.353     0.200
     3.697    23.548     0.200
     3.727    20.158     0.200
     0.202     1.859     0.200
     0.312     1.911     0.200
     0.745     4.449     0.200
     0.773     4.125     0.200
     0.754     4.576     0.200
     0.785     5.013     0.200
     0.870     5.058     0.200
     0.903     4.888     0.200
     0.962     6.180     0.200
     1.087     7.405     0.200
     1.163     7.478     0.200
     1.527     9.535     0.200
     0.374     2.381     0.200
     0.444     2.998     0.200
     0.555     3.075     0.200
     0.575     3.463     0.200
     0.572     3.493     0.200
     0.654     3.073     0.200
     0.714     3.368     0.200
     0.723     4.270     0.200
     0.738     4.096     0.200
     0.968     6.435     0.200
     2.518    14.334     0.200
     2.626    15.045     0.200
     2.948    16.937     0.200
     3.424    18.972     0.200
     3.753    21.731     0.200
     0.185     0.356     0.200
     0.488     3.271     0.200
     0.799     5.119     0.200
     0.925     5.576     0.200
     0.933     6.140     0.200
     0.964     6.325     0.200
     1.010     5.770     0.200
     0.964     6.423     0.200
     1.234     6.956     0.200
     1.957    13.055     0.200
     3.413    20.560     0.200
     3.666    23.101     0.200
     0.178     2.003     0.200
     0.497     3.716     0.200
     0.495     3.726     0.200
     0.539     3.716     0.200
     0.613     4.025     0.200
     0.711     3.820     0.200
     0.727     3.982     0.200
     0.888     5.094     0.200
     0.944     6.102     0.200
     1.057     6.484     0.200
     1.091     6.784     0.200
     1.570     9.302     0.200
     2.712    15.645     0.200
     2.780    15.503     0.200
     2.822    15.777     0.200
     3.145    17.808     0.200
     3.368    20.324     0.200
     3.621    19.854     0.200
     0.226     1.335     0.200
     0.720     4.083     0.200
     0.910     5.296     0.200
     1.028     6.355     0.200
     1.045     6.718     0.200
     1.118     6.827     0.200
     1.246     7.591     0.200
     2.692    15.854     0.200
     2.745    15.825     0.200
     2.791    15.682     0.200
     2.973    19.088     0.200
     3.120    18.194     0.200
     3.352    18.720     0.200
     3.596    20.004     0.200
     4.001    22.812     0.200
     0.148     0.529     0.200
     0.272     2.744     0.200
     0.824     5.372     0.200
     1.105     7.100     0.200
     1.105     7.246     0.200
     1.224     7.522     0.200
     1.255     7.080     0.200
     2.124    14.516     0.200
     2.921    18.761     0.200
     3.016    17.107     0.200
     3.153    18.903     0.200
     3.201    19.263     0.200
     3.349    19.557     0.200
     3.825    21.190     0.200
     0.221     1.890     0.200
     3.170    19.438     0.200
     3.793    23.875     0.200
     0.269     1.873     0.200
     0.366     1.814     0.200
     0.646     4.074     0.200
     0.731     3.493     0.200
     0.784     5.068     0.200
     0.816     5.708     0.200
     0.909     5.186     0.200
     1.188     7.546     0.200
     1.182     7.128     0.200
     2.532    14.014     0.200
     2.582    13.910     0.200
     2.853    18.091     0.200
     3.815    24.030     0.200
     0.364     2.543     0.200
     0.473     2.739     0.200
     0.486     2.936     0.200
     0.565     3.904     0.200
     0.601     2.538     0.200
     0.778     4.848     0.200
     0.876     4.702     0.200
     0.893     5.877     0.200
     0.893     5.767     0.200
     0.900     5.658     0.200
     0.232     1.548     0.200
     0.307     1.912     0.200
     0.323     1.610     0.200
     0.602     4.004     0.200
     0.607     3.433     0.200
     0.752     5.007     0.200
     0.781     4.438     0.200
     0.805     5.879     0.200
     0.913     5.201     0.200
     1.304     7.823     0.200
     1.594     9.258     0.200
     1.595     9.516     0.200
     2.484    12.248     0.200
     2.484    16.469     0.200
     2.535    13.468     0.200
     3.157    19.564     0.200
     3.766    23.475     0.200
     0.718     4.242     0.200
     1.181     6.560     0.200
     1.173     7.784     0.200
     1.266     7.514     0.200
     3.814    22.278     0.200
     0.872     4.743     0.200
     0.857     5.434     0.200
     0.940     6.251     0.200
     0.969     6.037     0.200
     1.798    10.988     0.200
     2.148    11.379     0.200
     2.380    15.239     0.200
     0.138     1.091     0.200
     0.557     4.044     0.200
     1.033     7.277     0.200
     0.119     1.106     0.200
     0.229     1.715     0.200
     0.305     1.826     0.200
     0.320     1.816     0.200
     0.600     3.936     0.200
     0.751     4.934     0.200
     0.783     5.380     0.200
     0.806     5.619     0.200
     1.144     6.851     0.200
     0.321     1.777     0.200
     0.474     3.066     0.200
     0.598     3.803     0.200
     0.636     4.149     0.200
     0.861     4.770     0.200
     0.750     4.123     0.200
     0.871     4.706     0.200
     0.871     4.522     0.200
     1.083     5.968     0.200
     0.069     1.109     0.200
     0.103     1.147     0.200
     0.191     1.627     0.200
     0.258     1.680     0.200
     0.275     1.630     0.200
     0.330     2.934     0.200
     0.442     3.191     0.200
     0.567     3.753     0.200
     0.605     4.053     0.200
     0.733     4.799     0.200
     0.809     5.491     0.200
     0.905     5.386     0.200
     1.118     6.652     0.200
     2.441    14.439     0.200
     2.471    13.765     0.200
     0.131     0.679     0.200
     0.219     1.515     0.200
     0.304     1.704     0.200
     0.313     1.695     0.200
     0.323     2.972     0.200
     0.449     3.813     0.200
     0.606     3.895     0.200
     0.593     4.283     0.200
     0.761     4.888     0.200
     0.819     5.532     0.200
     0.819     5.681     0.200
     0.898     5.207     0.200
     1.153     6.925     0.200
     2.485    15.204     0.200
     0.194     0.215     0.200
     0.237     1.806     0.200
     0.606     4.014     0.200
     0.604     3.880     0.200
     0.624     4.613     0.200
     0.640     4.560     0.200
     0.651     4.802     0.200
     0.691     4.308     0.200
     0.718     4.249     0.200
     0.695     4.729     0.200
     0.732     3.536     0.200
     0.722     4.383     0.200
     0.769     4.966     0.200
     0.802     5.000     0.200
     0.883     4.911     0.200
     0.918     5.739     0.200
     1.082     7.263     0.200
     1.145     7.499     0.200
     1.145     7.373     0.200
     1.188     7.290     0.200
     1.204     6.767     0.200
     1.703     9.864     0.200
     0.156    -0.549     0.200
     0.285     1.841     0.200
     0.683     2.839     0.200
     0.698     4.341     0.200
     0.656     4.879     0.200
     0.666     4.267     0.200
     0.722     4.276     0.200
     0.828     5.175     0.200
     0.865     5.524     0.200
     0.980     5.935     0.200
     1.115     7.415     0.200
     1.100     7.273     0.200
     1.115     7.501     0.200
     0.134     1.134     0.200
     0.394     3.066     0.200
     0.587     4.092     0.200
     0.721     5.454     0.200
     0.906     5.497     0.200
     0.984     6.300     0.200
     1.056     6.980     0.200
     1.056     7.068     0.200
     1.101     6.704     0.200
     1.132     7.382     0.200
     0.127     0.844     0.200
     0.315     0.776     0.200
     0.483     3.022     0.200
     0.608     3.740     0.200
     0.596     4.076     0.200
     0.629     4.490     0.200
     0.698     4.426     0.200
     0.719     4.586     0.200
     0.758     3.924     0.200
     0.855     3.703     0.200
     0.870     4.797     0.200
     0.870     4.657     0.200
     1.093     6.512     0.200
     1.113     7.531     0.200
     1.123     7.096     0.200
     1.192     7.504     0.200
     1.245     8.085     0.200
     1.249     7.806     0.200
     2.169    13.304     0.200
     2.278    13.358     0.200
     3.656    22.726     0.200
     0.151     1.003     0.200
     0.257     2.003     0.200
     0.273     2.008     0.200
     0.353     2.136     0.200
     0.420     3.600     0.200
     0.636     4.155     0.200
     0.681     4.588     0.200
     0.744     4.679     0.200
     0.778     5.049     0.200
     0.817     5.728     0.200
     0.906     5.184     0.200
     1.162     7.757     0.200
     1.175     7.734     0.200
     2.404    13.433     0.200
     2.839    18.313     0.200
     3.802    24.195     0.200
     0.144     1.330     0.200
     0.210     1.514     0.200
     0.249     1.781     0.200
     0.285     1.683     0.200
     0.299     1.769     0.200
     0.468     3.918     0.200
     0.588     3.881     0.200
     0.727     4.806     0.200
     0.811     5.615     0.200
     0.802     4.554     0.200
     0.905     5.190     0.200
     1.136     6.729     0.200
     1.201     7.867     0.200
     1.201     7.950     0.200
     1.201     7.921     0.200
     2.517    13.787     0.200
     0.220     0.520     0.200
     0.216     1.696     0.200
     0.604     4.772     0.200
     0.678     4.349     0.200
     0.685     4.364     0.200
     0.737     4.848     0.200
     0.759     3.546     0.200
     0.765     4.978     0.200
     0.850     4.712     0.200
     0.883     5.213     0.200
     1.070     7.201     0.200
     1.160     7.564     0.200
     1.154     7.264     0.200
     1.154     7.057     0.200
     1.166     7.576     0.200
     1.289     8.441     0.200
     1.886    12.370     0.200
     2.830    16.645     0.200
     4.341    26.527     0.200
     0.155     1.694     0.200
     0.405     3.455     0.200
     0.586     4.521     0.200
     0.670     4.199     0.200
     0.803     4.702     0.200
     0.744     5.606     0.200
     0.803     4.953     0.200
     0.924     5.308     0.200
     1.004     5.992     0.200
     1.063     7.027     0.200
     1.063     7.050     0.200
     1.153     7.292     0.200
     0.168     1.153     0.200
     0.244     1.670     0.200
     0.293     2.107     0.200
     0.344     1.965     0.200
     0.346     2.084     0.200
     0.491     4.296     0.200
     0.649     4.314     0.200
     0.698     4.981     0.200
     0.741     4.027     0.200
     0.798     4.801     0.200
     0.840     5.623     0.200
     0.882     5.115     0.200
     0.882     4.575     0.200
     1.571     9.880     0.200
     2.580    13.687     0.200
     0.166     1.354     0.200
     0.442     2.451     0.200
     0.486     2.405     0.200
     0.764     5.681     0.200
     0.711     3.826     0.200
     1.001     7.535     0.200
     1.001     7.544     0.200
     1.145     7.658     0.200
     0.151     1.087     0.200
     0.201     0.983     0.200
     0.181     1.697     0.200
     0.208     1.350     0.200
     0.261     1.380     0.200
     0.424     2.967     0.200
     0.486     3.342     0.200
     0.570     4.363     0.200
     0.656     4.355     0.200
     0.654     5.089     0.200
     0.754     4.976     0.200
     0.766     5.142     0.200
     0.896     4.409     0.200
     1.026     5.895     0.200
     1.038     6.273     0.200
     2.416    13.261     0.200
     0.116     0.407     0.200
     0.412     3.748     0.200
     0.530     2.615     0.200
     1.001     6.868     0.200
     1.018     5.757     0.200
     1.001     6.896     0.200
     1.107     7.136     0.200
     0.165     2.232     0.200
     0.193     1.339     0.200
     0.202     2.770     0.200
     0.210     1.389     0.200
     0.218     2.077     0.200
     0.294     1.657     0.200
     0.363     3.367     0.200
     0.352     3.263     0.200
     0.363     4.090     0.200
     0.454     3.433     0.200
     0.610     4.706     0.200
     0.766     5.145     0.200
     1.166     7.808     0.200
     1.158     7.139     0.200
     1.166     7.771     0.200
     1.230     8.015     0.200
     1.295     8.250     0.200
     1.471     9.472     0.200
     1.593    10.206     0.200
     1.668    10.125     0.200
     1.815    12.236     0.200
     2.033    13.339     0.200
     2.588    14.929     0.200
     0.210     2.095     0.200
     0.209     1.798     0.200
     0.223     2.520     0.200
     0.586     3.916     0.200
     0.577     3.847     0.200
     0.611     4.342     0.200
     0.623     4.424     0.200
     0.667     4.010     0.200
     0.696     4.314     0.200
     0.713     4.158     0.200
     0.741     4.625     0.200
     0.760     4.995     0.200
     0.779     5.094     0.200
     1.070     7.014     0.200
     1.091     7.167     0.200
     1.170     7.337     0.200
     1.170     7.401     0.200
     1.664    10.967     0.200
     2.043    13.676     0.200
     2.081    13.661     0.200
     2.466    13.629     0.200
     2.612    15.127     0.200
     2.758    15.154     0.200
     2.840    16.843     0.200
     2.840    17.651     0.200
     2.942    16.554     0.200
     0.286     1.417     0.200
     0.274     1.967     0.200
     0.455     3.390     0.200
     0.538     4.213     0.200
     0.574     3.988     0.200
     0.604     3.629     0.200
     0.769     4.753     0.200
     0.746     4.748     0.200
     0.801     5.130     0.200
     0.838     5.421     0.200
     2.472    16.761     0.200
     2.527    14.882     0.200
     2.775    17.380     0.200
     3.148    18.013     0.200
     6.560    39.797     0.200
     0.149     0.982     0.200
     0.256     1.894     0.200
     0.270     2.001     0.200
     0.342     2.091     0.200
     0.352     2.122     0.200
     0.422     3.478     0.200
     0.633     4.096     0.200
     0.682     4.627     0.200
     0.746     4.070     0.200
     0.776     4.803     0.200
     0.815     5.646     0.200
     1.162     7.723     0.200
     1.175     7.716     0.200
     1.181     7.708     0.200
     0.205     1.712     0.200
     0.207     1.892     0.200
     0.227     0.116     0.200
     0.572     3.841     0.200
     0.583     4.130     0.200
     0.618     4.661     0.200
     0.626     4.495     0.200
     0.663     4.304     0.200
     0.662     4.719     0.200
     0.692     4.315     0.200
     0.713     4.419     0.200
     0.736     4.790     0.200
     0.775     4.900     0.200
     0.799     4.539     0.200
     0.765     3.601     0.200
     0.800     4.331     0.200
     0.850     5.067     0.200
     0.850     4.696     0.200
     0.886     5.351     0.200
     0.921     4.951     0.200
     1.065     6.675     0.200
     1.092     7.286     0.200
     1.175     7.034     0.200
     1.172     7.551     0.200
     1.172     7.860     0.200
     1.174     8.410     0.200
     1.246     8.058     0.200
     3.119    18.894     0.200
     0.134     1.284     0.200
     0.134     1.504     0.200
     0.188     1.958     0.200
     0.332     2.224     0.200
     0.454     3.116     0.200
     0.507     3.824     0.200
     0.503     3.878     0.200
     0.546     3.377     0.200
     0.603     4.169     0.200
     0.603     3.709     0.200
     0.604     4.560     0.200
     0.663     4.339     0.200
     0.723     3.303     0.200
     0.752     3.966     0.200
     0.734     4.334     0.200
     0.734     4.174     0.200
     0.751     3.978     0.200
     0.848     4.851     0.200
     0.896     5.289     0.200
     0.872     5.462     0.200
     0.948     5.681     0.200
     1.059     6.120     0.200
     1.086     7.094     0.200
     1.091     7.283     0.200
     0.213     1.217     0.200
     0.227     1.884     0.200
     0.240     1.944     0.200
     0.571     3.926     0.200
     0.692     4.222     0.200
     0.683     4.434     0.200
     0.751     4.303     0.200
     0.752     3.883     0.200
     0.741     4.491     0.200
     0.761     5.045     0.200
     1.054     7.223     0.200
     1.148     7.498     0.200
     1.148     7.502     0.200
     1.144     6.958     0.200
     1.144     7.167     0.200
     1.163     6.240     0.200
     0.157     0.891     0.200
     0.304     2.377     0.200
     0.626     3.971     0.200
     0.593     4.371     0.200
     0.649     4.199     0.200
     0.682     4.100     0.200
     0.762     4.237     0.200
     0.774     4.109     0.200
     0.754     4.400     0.200
     0.794     4.767     0.200
     0.843     5.367     0.200
     1.081     6.174     0.200
     1.095     7.047     0.200
     1.076     7.182     0.200
     1.172     6.474     0.200
     0.220     1.602     0.200
     0.226     1.497     0.200
     0.206     0.650     0.200
     0.592     4.074     0.200
     0.599     3.877     0.200
     0.629     4.604     0.200
     0.644     4.532     0.200
     0.678     4.205     0.200
     0.635     4.670     0.200
     0.689     4.696     0.200
     0.706     4.238     0.200
     0.706     4.098     0.200
     0.719     4.427     0.200
     0.762     4.795     0.200
     0.742     4.099     0.200
     0.813     4.274     0.200
     0.817     3.806     0.200
     0.801     5.133     0.200
     0.913     5.215     0.200
     1.034     5.774     0.200
     1.092     6.247     0.200
     1.095     7.230     0.200
     1.158     7.396     0.200
     1.158     7.461     0.200
     1.201     6.823     0.200
     1.193     7.354     0.200
     1.672    10.873     0.200
     1.775    11.658     0.200
     2.058    13.418     0.200
     2.863    18.037     0.200
     2.964    16.642     0.200
     3.096    18.334     0.200
     3.293    18.182     0.200
     3.419    20.430     0.200
     3.769    21.994     0.200
     0.031     1.376     0.200
     0.136     1.413     0.200
     0.203     1.654     0.200
     0.271     2.254     0.200
     0.298     1.785     0.200
     0.295     1.913     0.200
     0.450     3.830     0.200
     0.533     4.456     0.200
     0.580     4.006     0.200
     0.607     4.045     0.200
     0.734     5.046     0.200
     0.792     4.748     0.200
     0.769     5.070     0.200
     0.832     5.957     0.200
     1.157     6.607     0.200
     1.211     8.113     0.200
     1.216     8.037     0.200
     1.218     8.094     0.200
     1.617     9.565     0.200
     2.681    14.257     0.200
     3.155    16.277     0.200
     0.125     0.838     0.200
     0.125     0.990     0.200
     0.160     1.411     0.200
     0.315     2.267     0.200
     0.484     3.304     0.200
     0.633     4.939     0.200
     0.594     3.785     0.200
     0.610     3.885     0.200
     0.645     4.170     0.200
     0.715     4.316     0.200
     0.701     4.536     0.200
     0.759     4.173     0.200
     0.855     4.823     0.200
     0.867     4.478     0.200
     1.096     6.071     0.200
     1.127     7.098     0.200
     1.127     7.446     0.200
     1.251     7.902     0.200
     1.249     8.061     0.200
     1.305     8.137     0.200
     2.985    17.848     0.200
     3.036    18.299     0.200
     3.658    22.755     0.200
     0.030     0.493     0.200
     0.137     1.003     0.200
     0.200     1.521     0.200
     0.272     2.043     0.200
     0.450     3.623     0.200
     0.534     3.880     0.200
     0.607     4.018     0.200
     0.736     4.928     0.200
     0.769     5.072     0.200
     0.769     4.822     0.200
     0.793     4.718     0.200
     0.834     5.869     0.200
     0.882     5.233     0.200
     1.157     7.052     0.200
     2.373    13.579     0.200
     2.532    13.648     0.200
     3.154    18.245     0.200
     6.127    38.249     0.200
     0.144     1.777     0.200
     0.277     2.796     0.200
     0.288     2.547     0.200
     0.626     5.398     0.200
     0.679     4.949     0.200
     1.100     6.806     0.200
     1.100     6.832     0.200
     1.628    11.291     0.200
     2.917    18.666     0.200
     0.145     0.632     0.200
     0.373     3.466     0.200
     0.415     3.566     0.200
     0.573     3.118     0.200
     0.683     4.048     0.200
     0.696     4.569     0.200
     0.738     5.902     0.200
     0.816     4.784     0.200
     0.810     5.188     0.200
     1.008     6.182     0.200
     1.049     6.935     0.200
     1.049     7.107     0.200
     1.049     7.106     0.200
     1.049     6.845     0.200
     1.143     7.500     0.200
     0.153     0.531     0.200
     0.356     3.170     0.200
     0.399     3.268     0.200
     0.399     3.127     0.200
     0.590     3.306     0.200
     0.670     4.105     0.200
     0.741     5.419     0.200
     0.798     4.678     0.200
     0.797     4.817     0.200
     0.918     5.273     0.200
     0.998     6.054     0.200
     1.065     7.014     0.200
     1.065     6.993     0.200
     1.041     6.846     0.200
     1.151     7.288     0.200
     0.158     0.133     0.200
     0.406     3.222     0.200
     0.586     3.258     0.200
     0.748     5.351     0.200
     0.802     5.090     0.200
     0.891     6.112     0.200
     1.007     6.580     0.200
     1.064     7.050     0.200
     1.065     7.119     0.200
     1.156     7.531     0.200
     0.142     0.897     0.200
     0.281     2.393     0.200
     0.305     2.345     0.200
     0.305     2.493     0.200
     0.663     4.347     0.200
     0.661     4.774     0.200
     0.686     4.342     0.200
     0.700     4.058     0.200
     0.739     4.320     0.200
     0.804     4.776     0.200
     0.884     5.540     0.200
     1.100     6.563     0.200
     1.100     7.282     0.200
     1.099     7.434     0.200
     1.100     7.267     0.200
     1.100     7.579     0.200
     0.152     1.132     0.200
     0.188     1.399     0.200
     0.493     3.333     0.200
     0.607     4.566     0.200
     0.622     4.131     0.200
     0.700     4.559     0.200
     0.739     4.847     0.200
     0.738     4.461     0.200
     0.773     4.517     0.200
     0.895     4.781     0.200
     1.089     7.297     0.200
     1.097     6.405     0.200
     1.113     7.257     0.200
     1.190     7.293     0.200
     1.225     7.523     0.200
     1.225     7.625     0.200
     0.146     2.347     0.200
     0.302     1.949     0.200
     0.338     2.593     0.200
     0.639     4.496     0.200
     0.702     5.663     0.200
     0.933     5.499     0.200
     0.933     5.258     0.200
     0.978     5.371     0.200
     1.094     7.171     0.200
     1.094     7.159     0.200
     1.130     7.243     0.200
     1.865    12.607     0.200
     0.071     1.129     0.200
     0.103     1.197     0.200
     0.202     1.676     0.200
     0.210     1.761     0.200
     0.210     1.799     0.200
     0.239     1.460     0.200
     0.275     1.319     0.200
     0.534     3.216     0.200
     0.522     2.939     0.200
     0.522     3.979     0.200
     0.606     4.635     0.200
     0.699     4.595     0.200
     0.746     4.918     0.200
     0.780     5.138     0.200
     0.780     5.398     0.200
     0.851     4.381     0.200
     1.070     6.731     0.200
     1.084     6.196     0.200
     1.654    10.986     0.200
     2.301    13.241     0.200
     2.398    15.153     0.200
     2.476    17.307     0.200
     2.611    14.682     0.200
     2.742    17.637     0.200
     2.742    16.867     0.200
     3.695    23.117     0.200
     0.279     2.261     0.200
     0.298     1.813     0.200
     0.369     3.108     0.200
     0.368     2.643     0.200
     0.401     2.663     0.200
     0.432     2.888     0.200
     0.477     2.790     0.200
     0.491     3.065     0.200
     0.623     4.238     0.200
     0.784     4.973     0.200
     0.906     5.770     0.200
     0.898     6.019     0.200
     1.120     7.410     0.200
     1.173     7.828     0.200
     1.448     9.593     0.200
     0.055     0.961     0.200
     0.112     0.990     0.200
     0.210     1.563     0.200
     0.247     1.934     0.200
     0.256     1.965     0.200
     0.284     1.697     0.200
     0.299     1.467     0.200
     0.469     3.865     0.200
     0.554     3.449     0.200
     0.587     3.508     0.200
     0.603     4.238     0.200
     0.745     4.865     0.200
     0.727     4.877     0.200
     0.809     5.604     0.200
     0.906     4.947     0.200
     1.134     6.794     0.200
     1.200     7.871     0.200
     1.200     7.721     0.200
     1.201     7.769     0.200
     3.138    17.188     0.200
     0.059     0.857     0.200
     0.108     0.934     0.200
     0.212     1.636     0.200
     0.243     1.851     0.200
     0.252     1.916     0.200
     0.282     1.732     0.200
     0.299     1.753     0.200
     0.473     3.712     0.200
     0.557     4.264     0.200
     0.583     3.788     0.200
     0.607     4.165     0.200
     0.741     4.793     0.200
     0.725     4.749     0.200
     0.805     5.508     0.200
     1.130     6.750     0.200
     1.197     7.662     0.200
     1.620    10.313     0.200
     3.135    17.302     0.200
     0.122     0.621     0.200
     0.155     1.392     0.200
     0.486     3.174     0.200
     0.612     3.852     0.200
     0.638     4.839     0.200
     0.590     3.953     0.200
     0.645     4.139     0.200
     0.704     4.554     0.200
     0.710     4.537     0.200
     1.199     7.642     0.200
     1.199     7.071     0.200
     1.254     8.262     0.200
     1.254     8.001     0.200
     1.310     8.338     0.200
     1.619    11.820     0.200
     0.079     0.731     0.200
     0.092     0.904     0.200
     0.204     1.441     0.200
     0.220     1.652     0.200
     0.249     1.300     0.200
     0.217     1.583     0.200
     0.280     1.207     0.200
     0.510     4.338     0.200
     0.510     4.209     0.200
     0.546     3.194     0.200
     0.594     4.853     0.200
     0.629     4.394     0.200
     0.709     4.598     0.200
     0.741     4.990     0.200
     0.786     5.301     0.200
     0.786     5.493     0.200
     0.929     5.372     0.200
     0.929     5.161     0.200
     1.080     6.254     0.200
     1.095     6.523     0.200
     1.192     7.896     0.200
     1.197     7.872     0.200
     2.623    15.289     0.200
     3.449    19.902     0.200
     0.161     1.193     0.200
     0.234     2.254     0.200
     0.402     2.399     0.200
     0.460     3.347     0.200
     0.486     3.589     0.200
     0.568     4.446     0.200
     0.499     3.404     0.200
     0.515     3.020     0.200
     0.578     3.949     0.200
     0.600     3.765     0.200
     0.577     4.157     0.200
     0.612     4.106     0.200
     0.690     4.067     0.200
     0.804     4.863     0.200
     0.903     4.711     0.200
     1.025     6.918     0.200
     1.091     6.590     0.200
     1.268     8.257     0.200
     2.270    14.299     0.200
     2.894    15.546     0.200
     2.942    17.879     0.200
     3.566    22.731     0.200
     3.953    21.891     0.200
     4.174    25.919     0.200
     4.666    28.509     0.200
     0.168     1.429     0.200
     0.182     1.623     0.200
     0.533     3.747     0.200
     0.559     3.739     0.200
     0.622     4.245     0.200
     0.631     3.799     0.200
     0.628     5.271     0.200
     0.655     4.281     0.200
     0.696     4.339     0.200
     0.712     4.005     0.200
     0.742     4.970     0.200
     0.764     4.042     0.200
     0.782     5.223     0.200
     1.102     7.435     0.200
     1.140     6.209     0.200
     1.152     7.108     0.200
     1.152     7.218     0.200
     1.208     7.683     0.200
     1.232     6.830     0.200
     1.247     8.059     0.200
     1.308     8.156     0.200
     0.396     3.305     0.200
     0.440     3.693     0.200
     0.553     3.564     0.200
     0.684     3.967     0.200
     0.713     4.550     0.200
     0.755     5.782     0.200
     0.837     5.247     0.200
     0.836     4.709     0.200
     0.924     5.740     0.200
     1.035     6.488     0.200
     1.358     8.620     0.200
     1.388     8.551     0.200
     1.388     8.293     0.200
     1.444     8.524     0.200
     1.970    13.370     0.200
     3.335    21.637     0.200
     0.062     0.683     0.200
     0.140     1.030     0.200
     0.190     1.628     0.200
     0.192     1.421     0.200
     0.200     1.100     0.200
     0.198     1.381     0.200
     0.254     1.340     0.200
     0.382     3.170     0.200
     0.564     4.019     0.200
     0.648     4.521     0.200
     0.666     4.344     0.200
     0.764     5.118     0.200
     0.764     5.229     0.200
     0.771     4.831     0.200
     0.894     5.513     0.200
     1.193     7.609     0.200
     1.204     7.752     0.200
     1.687    10.885     0.200
     1.688    11.042     0.200
     2.421    13.785     0.200
     2.458    13.505     0.200
     0.138     0.998     0.200
     0.194     1.449     0.200
     0.196     1.480     0.200
     0.273     1.257     0.200
     0.374     3.146     0.200
     0.539     4.224     0.200
     0.517     3.231     0.200
     0.623     4.777     0.200
     0.682     4.190     0.200
     0.682     4.380     0.200
     0.749     4.928     0.200
     0.767     5.353     0.200
     0.911     5.461     0.200
     1.067     6.320     0.200
     1.385     7.808     0.200
     2.284    13.287     0.200
     2.387    15.238     0.200
     2.397    13.764     0.200
     2.595    14.725     0.200
     2.733    17.537     0.200
     0.058     0.581     0.200
     0.113     0.646     0.200
     0.110     0.785     0.200
     0.199     1.337     0.200
     0.272     1.455     0.200
     0.286     1.236     0.200
     0.253     1.805     0.200
     0.247     1.794     0.200
     0.327     2.945     0.200
     0.477     3.897     0.200
     0.561     4.677     0.200
     0.579     3.685     0.200
     0.742     4.663     0.200
     0.738     4.882     0.200
     0.812     5.639     0.200
     0.903     4.964     0.200
     0.903     5.175     0.200
     0.972     5.966     0.200
     1.129     6.776     0.200
     6.111    34.102     0.200
     0.100     0.694     0.200
     0.133     0.731     0.200
     0.218     1.468     0.200
     0.234     1.744     0.200
     0.244     1.530     0.200
     0.281     1.536     0.200
     0.303     1.564     0.200
     0.343     3.039     0.200
     0.478     2.881     0.200
     0.478     3.967     0.200
     0.563     4.670     0.200
     0.577     3.701     0.200
     0.616     4.304     0.200
     0.720     4.867     0.200
     0.733     4.818     0.200
     0.796     5.639     0.200
     0.919     5.069     0.200
     0.919     5.241     0.200
     0.964     5.955     0.200
     1.123     6.777     0.200
     1.189     7.902     0.200
     1.190     7.836     0.200
     1.192     8.047     0.200
     2.656    15.134     0.200
     0.075     0.770     0.200
     0.092     0.850     0.200
     0.133     0.883     0.200
     0.216     1.542     0.200
     0.228     1.830     0.200
     0.236     1.848     0.200
     0.274     1.555     0.200
     0.299     1.369     0.200
     0.348     3.052     0.200
     0.487     3.966     0.200
     0.569     3.712     0.200
     0.572     4.625     0.200
     0.621     4.323     0.200
     0.705     4.899     0.200
     0.725     4.495     0.200
     0.723     4.947     0.200
     0.791     5.606     0.200
     0.924     5.101     0.200
     1.115     6.730     0.200
     1.189     7.483     0.200
     2.215    13.246     0.200
     2.312    13.377     0.200
     2.336    13.501     0.200
     2.450    14.640     0.200
     2.450    16.300     0.200
     2.500    14.118     0.200
     2.648    15.102     0.200
     2.775    17.610     0.200
     3.123    19.116     0.200
     5.625    34.647     0.200
     0.062     0.846     0.200
     0.118     1.071     0.200
     0.134     1.076     0.200
     0.198     1.620     0.200
     0.177     1.683     0.200
     0.200     1.609     0.200
     0.202     1.485     0.200
     0.537     4.155     0.200
     0.622     4.721     0.200
     0.647     4.474     0.200
     0.685     4.289     0.200
     0.685     4.498     0.200
     0.753     5.027     0.200
     0.740     5.045     0.200
     0.772     5.350     0.200
     0.914     5.604     0.200
     2.397    13.657     0.200
     2.448    13.964     0.200
     0.230     1.793     0.200
     0.230     2.053     0.200
     0.233     1.634     0.200
     0.233     1.954     0.200
     0.599     3.860     0.200
     0.603     4.215     0.200
     0.622     4.914     0.200
     0.688     4.371     0.200
     0.690     4.827     0.200
     0.719     4.251     0.200
     0.716     4.379     0.200
     0.737     4.170     0.200
     0.797     5.376     0.200
     0.839     5.579     0.200
     1.082     7.607     0.200
     1.148     7.607     0.200
     1.149     7.843     0.200
     1.184     7.171     0.200
     1.184     7.392     0.200
     1.198     6.793     0.200
     1.243     8.035     0.200
     1.280     7.305     0.200
     2.104    14.437     0.200
     3.094    18.006     0.200
     3.143    17.500     0.200
     0.230     2.114     0.200
     0.233     1.894     0.200
     0.603     4.248     0.200
     0.601     4.089     0.200
     0.601     3.559     0.200
     0.624     5.027     0.200
     0.688     4.420     0.200
     0.717     4.377     0.200
     0.692     4.768     0.200
     0.736     4.046     0.200
     0.766     5.074     0.200
     0.799     5.294     0.200
     0.841     5.536     0.200
     0.914     5.539     0.200
     1.083     7.436     0.200
     1.148     7.649     0.200
     1.186     7.470     0.200
     1.200     6.694     0.200
     3.096    18.115     0.200
     3.145    18.528     0.200
     3.769    21.189     0.200
     0.084     1.085     0.200
     0.084     1.192     0.200
     0.144     1.281     0.200
     0.172     1.816     0.200
     0.227     1.770     0.200
     0.228     1.885     0.200
     0.218     1.918     0.200
     0.277     1.709     0.200
     0.446     3.238     0.200
     0.491     4.061     0.200
     0.565     3.734     0.200
     0.561     4.140     0.200
     0.576     4.652     0.200
     0.631     4.129     0.200
     0.632     4.397     0.200
     0.717     4.583     0.200
     0.715     4.938     0.200
     0.779     4.150     0.200
     0.714     4.997     0.200
     0.803     4.706     0.200
     0.780     5.328     0.200
     0.897     5.426     0.200
     0.948     5.921     0.200
     1.008     6.087     0.200
     1.032     6.266     0.200
     1.038     6.002     0.200
     1.108     6.704     0.200
     1.108     6.694     0.200
     1.128     6.319     0.200
     1.148     6.290     0.200
     1.875    11.364     0.200
     2.064    12.729     0.200
     2.215    13.442     0.200
     2.333    13.104     0.200
     2.538    16.383     0.200
     2.646    14.632     0.200
     2.871    14.525     0.200
     3.121    16.814     0.200
     3.121    16.976     0.200
     0.151     1.202     0.200
     0.194     1.719     0.200
     0.201     1.352     0.200
     0.227     1.707     0.200
     0.299     1.471     0.200
     0.378     3.260     0.200
     0.519     2.734     0.200
     0.519     4.004     0.200
     0.563     4.058     0.200
     0.605     4.703     0.200
     0.653     4.442     0.200
     0.690     4.502     0.200
     0.690     4.604     0.200
     0.722     4.903     0.200
     0.761     4.777     0.200
     0.761     5.437     0.200
     0.739     4.978     0.200
     0.921     5.716     0.200
     1.081     6.347     0.200
     1.167     7.721     0.200
     1.172     7.704     0.200
     2.304    12.658     0.200
     2.471    12.950     0.200
     0.043     1.274     0.200
     0.126     1.484     0.200
     0.139     1.624     0.200
     0.195     1.726     0.200
     0.190     1.674     0.200
     0.246     1.909     0.200
     0.286     1.473     0.200
     0.438     3.648     0.200
     0.605     3.405     0.200
     0.612     3.954     0.200
     0.612     4.064     0.200
     0.711     4.999     0.200
     0.755     5.049     0.200
     0.841     5.091     0.200
     0.997     5.865     0.200
     2.107    13.177     0.200
     2.338    13.216     0.200
     2.352    14.981     0.200
     2.486    16.999     0.200
     2.775    16.569     0.200
     3.011    19.170     0.200
     3.634    23.267     0.200
     3.832    24.698     0.200
     4.378    28.309     0.200
     0.157     1.155     0.200
     0.157     1.045     0.200
     0.171     1.173     0.200
     0.171     1.321     0.200
     0.172     1.579     0.200
     0.278     2.015     0.200
     0.298     2.161     0.200
     0.350     2.211     0.200
     0.335     3.039     0.200
     0.359     2.179     0.200
     0.414     3.615     0.200
     0.525     3.510     0.200
     0.525     3.631     0.200
     0.500     4.315     0.200
     0.582     4.344     0.200
     0.596     4.167     0.200
     0.615     4.141     0.200
     0.663     4.708     0.200
     0.678     4.635     0.200
     0.783     5.070     0.200
     0.817     4.626     0.200
     0.819     5.660     0.200
     0.872     5.578     0.200
     0.904     4.879     0.200
     0.971     6.055     0.200
     1.016     6.382     0.200
     1.083     6.461     0.200
     1.084     6.635     0.200
     1.091     6.759     0.200
     1.108     6.751     0.200
     1.121     6.907     0.200
     1.153     6.855     0.200
     1.181     7.082     0.200
     1.159     7.821     0.200
     1.204     7.106     0.200
     1.207     7.450     0.200
     1.181     7.757     0.200
     2.411    13.338     0.200
     2.527    14.959     0.200
     3.200    17.376     0.200
     0.144     1.103     0.200
     0.162     1.267     0.200
     0.251     1.952     0.200
     0.267     1.970     0.200
     0.286     1.997     0.200
     0.347     2.070     0.200
     0.427     3.424     0.200
     0.686     4.555     0.200
     0.772     4.785     0.200
     0.772     4.988     0.200
     0.814     5.601     0.200
     0.907     5.020     0.200
     1.005     6.209     0.200
     1.166     7.714     0.200
     1.177     7.377     0.200
     1.168     6.939     0.200
     1.182     7.482     0.200
     1.569    10.721     0.200
     1.939    11.439     0.200
     2.278    13.985     0.200
     2.397    13.420     0.200
     2.513    14.452     0.200
     2.563    14.114     0.200
     2.711    14.344     0.200
     2.934    18.799     0.200
     3.163    20.176     0.200
     3.186    16.619     0.200
     3.795    24.295     0.200
     3.969    25.317     0.200
     0.173     1.307     0.200
     0.156     1.089     0.200
     0.262     2.008     0.200
     0.276     2.014     0.200
     0.297     2.082     0.200
     0.337     2.900     0.200
     0.351     2.213     0.200
     0.359     2.141     0.200
     0.415     3.709     0.200
     0.676     4.624     0.200
     0.782     5.056     0.200
     0.782     5.197     0.200
     0.818     5.749     0.200
     0.906     5.024     0.200
     1.261     6.832     0.200
     0.085     1.172     0.200
     0.082     1.116     0.200
     0.138     1.332     0.200
     0.168     1.768     0.200
     0.219     1.814     0.200
     0.218     1.822     0.200
     0.226     1.709     0.200
     0.269     1.732     0.200
     0.299     1.810     0.200
     0.357     3.138     0.200
     0.496     3.836     0.200
     0.496     2.747     0.200
     0.559     3.530     0.200
     0.715     4.701     0.200
     0.722     4.775     0.200
     0.782     5.016     0.200
     0.782     5.397     0.200
     0.946     5.863     0.200
     1.105     6.553     0.200
     0.196     2.064     0.200
     0.196     1.494     0.200
     0.552     3.726     0.200
     0.563     3.432     0.200
     0.600     4.420     0.200
     0.611     4.457     0.200
     0.644     4.449     0.200
     0.660     3.950     0.200
     0.670     4.163     0.200
     0.718     4.469     0.200
     0.728     4.029     0.200
     0.753     4.589     0.200
     0.794     4.915     0.200
     0.779     4.059     0.200
     0.832     4.716     0.200
     1.081     7.010     0.200
     1.150     7.211     0.200
     1.153     6.944     0.200
     1.179     8.073     0.200
     1.231     7.879     0.200
     3.097    18.061     0.200
     0.308     2.638     0.200
     0.645     4.282     0.200
     0.659     4.180     0.200
     0.708     4.268     0.200
     0.653     5.349     0.200
     0.686     4.497     0.200
     0.713     4.934     0.200
     0.745     4.441     0.200
     0.732     4.863     0.200
     0.777     4.930     0.200
     0.803     4.989     0.200
     0.881     5.654     0.200
     0.924     5.748     0.200
     1.094     7.350     0.200
     1.090     7.259     0.200
     2.041    12.265     0.200
     3.181    18.862     0.200
     3.229    19.050     0.200
     0.035     0.962     0.200
     0.168     1.369     0.200
     0.158     1.134     0.200
     0.164     1.479     0.200
     0.213     1.081     0.200
     0.215     1.922     0.200
     0.227     1.607     0.200
     0.279     1.418     0.200
     0.408     3.409     0.200
     0.483     2.972     0.200
     0.573     4.291     0.200
     0.658     3.617     0.200
     0.645     4.044     0.200
     0.645     4.263     0.200
     0.737     4.856     0.200
     0.737     5.157     0.200
     0.750     4.978     0.200
     0.875     5.336     0.200
     1.030     6.170     0.200
     1.165     7.690     0.200
     1.204     8.003     0.200
     1.673     9.934     0.200
     2.135    12.579     0.200
     2.367    13.457     0.200
     2.417    13.857     0.200
     3.040    16.377     0.200
     0.392     3.362     0.200
     0.392     3.544     0.200
     0.594     3.961     0.200
     0.675     4.012     0.200
     0.678     4.386     0.200
     0.731     5.685     0.200
     0.787     5.296     0.200
     0.794     5.669     0.200
     0.795     4.585     0.200
     0.874     5.788     0.200
     0.908     5.338     0.200
     0.988     6.496     0.200
     1.030     6.442     0.200
     1.065     7.254     0.200
     1.065     7.015     0.200
     1.065     7.573     0.200
     1.065     6.993     0.200
     4.449    24.605     0.200
     0.144     1.246     0.200
     0.469     3.178     0.200
     0.496     3.734     0.200
     0.512     3.717     0.200
     0.509     3.765     0.200
     0.555     3.866     0.200
     0.572     3.758     0.200
     0.599     3.775     0.200
     0.627     4.012     0.200
     0.648     4.979     0.200
     0.693     4.511     0.200
     0.729     4.812     0.200
     0.741     4.018     0.200
     0.847     4.381     0.200
     0.847     4.256     0.200
     0.876     4.968     0.200
     1.085     6.153     0.200
     1.128     7.271     0.200
     1.133     7.448     0.200
     1.190     7.454     0.200
     0.019     1.476     0.200
     0.087     1.771     0.200
     0.396     2.745     0.200
     0.396     2.870     0.200
     0.462     3.781     0.200
     0.478     2.965     0.200
     0.478     3.371     0.200
     0.509     3.411     0.200
     0.523     3.749     0.200
     0.523     3.968     0.200
     0.577     3.707     0.200
     0.577     4.152     0.200
     0.583     3.445     0.200
     0.621     3.545     0.200
     0.635     4.299     0.200
     0.658     4.166     0.200
     0.734     3.700     0.200
     0.734     3.942     0.200
     0.747     3.862     0.200
     0.747     4.276     0.200
     0.767     5.072     0.200
     0.797     5.014     0.200
     0.775     5.933     0.200
     0.796     5.042     0.200
     0.813     4.774     0.200
     0.924     5.172     0.200
     1.018     5.679     0.200
     2.760    14.970     0.200
     0.200     1.412     0.200
     0.547     3.651     0.200
     0.593     4.104     0.200
     0.594     4.376     0.200
     0.596     4.381     0.200
     0.639     4.501     0.200
     0.665     4.203     0.200
     0.662     4.210     0.200
     0.740     4.431     0.200
     0.780     4.598     0.200
     0.743     4.873     0.200
     0.785     5.218     0.200
     0.828     4.574     0.200
     0.931     4.777     0.200
     1.218     8.222     0.200
     1.281     8.066     0.200
     2.906    16.258     0.200
     3.237    19.007     0.200
     0.153     1.184     0.200
     0.158     1.567     0.200
     0.174     1.433     0.200
     0.217     1.157     0.200
     0.234     1.703     0.200
     0.221     2.004     0.200
     0.286     1.165     0.200
     0.414     3.460     0.200
     0.482     2.802     0.200
     0.574     4.370     0.200
     0.641     4.265     0.200
     0.659     4.891     0.200
     0.730     5.197     0.200
     0.744     5.001     0.200
     0.871     5.354     0.200
     0.952     7.652     0.200
     0.988     5.491     0.200
     1.028     5.827     0.200
     1.157     7.721     0.200
     1.169     7.733     0.200
     1.197     7.978     0.200
     0.129     1.080     0.200
     0.140     1.272     0.200
     0.193     1.188     0.200
     0.288     1.301     0.200
     0.288     1.445     0.200
     0.455     2.844     0.200
     0.435     3.323     0.200
     0.615     4.035     0.200
     0.601     4.305     0.200
     0.712     4.975     0.200
     0.752     4.874     0.200
     0.844     5.158     0.200
     1.001     5.914     0.200
     1.149     7.626     0.200
     1.164     7.850     0.200
     0.126     0.901     0.200
     0.141     1.308     0.200
     0.197     0.839     0.200
     0.195     1.406     0.200
     0.245     1.646     0.200
     0.246     2.079     0.200
     0.283     1.183     0.200
     0.283     1.484     0.200
     0.438     3.412     0.200
     0.448     2.861     0.200
     0.611     4.009     0.200
     0.608     4.396     0.200
     0.693     5.120     0.200
     0.712     4.758     0.200
     0.712     5.020     0.200
     0.760     4.994     0.200
     0.840     5.160     0.200
     0.995     5.874     0.200
     1.152     7.661     0.200
     1.168     7.707     0.200
     2.216    12.955     0.200
     2.348    15.028     0.200
     2.531    14.378     0.200
     0.022     0.813     0.200
     0.148     1.183     0.200
     0.174     1.161     0.200
     0.161     1.349     0.200
     0.162     1.158     0.200
     0.162     1.340     0.200
     0.217     1.862     0.200
     0.239     1.634     0.200
     0.234     1.144     0.200
     0.297     1.523     0.200
     0.409     3.380     0.200
     0.558     4.156     0.200
     0.497     2.959     0.200
     0.644     4.095     0.200
     0.651     4.265     0.200
     0.730     4.895     0.200
     0.732     5.147     0.200
     0.882     5.363     0.200
     1.040     6.134     0.200
     1.652    11.107     0.200
     2.265    12.740     0.200
     2.582    14.750     0.200
     2.741    17.652     0.200
     2.820    16.951     0.200
     0.051     0.673     0.200
     0.126     0.867     0.200
     0.193     0.796     0.200
     0.143     1.253     0.200
     0.194     1.441     0.200
     0.242     1.667     0.200
     0.246     2.126     0.200
     0.279     1.192     0.200
     0.279     1.450     0.200
     0.437     3.623     0.200
     0.445     2.557     0.200
     0.610     3.810     0.200
     0.610     3.959     0.200
     0.610     4.691     0.200
     0.714     4.992     0.200
     0.764     5.024     0.200
     0.839     5.124     0.200
     0.993     5.881     0.200
     1.694    11.438     0.200
     2.213    13.289     0.200
     2.331    13.405     0.200
     2.381    12.851     0.200
     2.478    13.018     0.200
     0.063     0.948     0.200
     0.121     1.091     0.200
     0.152     1.250     0.200
     0.166     1.619     0.200
     0.240     1.893     0.200
     0.247     1.944     0.200
     0.263     1.716     0.200
     0.313     1.981     0.200
     0.331     1.701     0.200
     0.331     1.986     0.200
     0.344     2.981     0.200
     0.451     3.559     0.200
     0.485     3.444     0.200
     0.569     3.954     0.200
     0.604     3.606     0.200
     0.612     4.118     0.200
     0.696     4.640     0.200
     0.751     4.739     0.200
     0.751     4.860     0.200
     0.800     5.523     0.200
     0.983     6.028     0.200
     1.145     6.784     0.200
     1.172     7.785     0.200
     1.176     7.663     0.200
     1.179     7.624     0.200
     2.372    13.412     0.200
     2.488    14.033     0.200
     2.522    14.645     0.200
     2.538    14.487     0.200
     3.771    23.601     0.200
     0.175     1.281     0.200
     0.175     1.129     0.200
     0.203     1.747     0.200
     0.516     3.253     0.200
     0.566     4.118     0.200
     0.565     4.167     0.200
     0.578     4.100     0.200
     0.599     4.530     0.200
     0.608     4.227     0.200
     0.634     3.735     0.200
     0.644     4.101     0.200
     0.684     4.506     0.200
     0.717     4.624     0.200
     0.757     4.801     0.200
     0.797     4.484     0.200
     0.797     4.711     0.200
     0.810     5.248     0.200
     0.830     5.123     0.200
     0.914     4.727     0.200
     0.914     5.145     0.200
     0.959     5.630     0.200
     1.120     7.413     0.200
     1.116     6.797     0.200
     1.200     7.611     0.200
     1.200     7.759     0.200
     1.201     7.745     0.200
     1.217     8.075     0.200
     1.277     8.433     0.200
     2.168    14.207     0.200
     3.012    17.394     0.200
     3.060    16.864     0.200
     3.684    21.548     0.200
     0.153     1.014     0.200
     0.487     3.138     0.200
     0.537     3.994     0.200
     0.535     3.979     0.200
     0.563     4.096     0.200
     0.578     4.075     0.200
     0.606     3.715     0.200
     0.602     4.475     0.200
     0.654     4.309     0.200
     0.691     4.377     0.200
     0.731     4.597     0.200
     0.767     4.279     0.200
     0.840     5.138     0.200
     0.898     4.719     0.200
     0.898     4.519     0.200
     1.089     6.255     0.200
     1.218     7.974     0.200
     1.275     8.027     0.200
     2.983    16.541     0.200
     3.032    17.377     0.200
     0.350     3.471     0.200
     0.394     3.605     0.200
     0.596     4.404     0.200
     0.667     4.550     0.200
     0.741     5.834     0.200
     0.795     5.752     0.200
     0.792     5.160     0.200
     0.831     5.564     0.200
     0.878     5.651     0.200
     0.914     5.619     0.200
     0.994     6.415     0.200
     1.037     6.439     0.200
     1.037     6.783     0.200
     1.070     7.519     0.200
     1.070     7.418     0.200
     1.105     6.989     0.200
     1.132     6.653     0.200
     1.152     7.642     0.200
     2.260    15.661     0.200
     3.340    19.589     0.200
     3.529    22.381     0.200
     0.295     2.894     0.200
     0.295     3.082     0.200
     0.323     2.835     0.200
     0.646     4.511     0.200
     0.675     5.448     0.200
     0.708     4.402     0.200
     0.647     4.925     0.200
     0.727     5.003     0.200
     0.694     4.599     0.200
     0.751     4.675     0.200
     0.751     4.183     0.200
     0.751     4.581     0.200
     0.797     4.650     0.200
     0.797     5.072     0.200
     0.826     5.071     0.200
     0.826     4.880     0.200
     0.905     5.824     0.200
     0.948     5.742     0.200
     0.948     6.090     0.200
     0.948     5.879     0.200
     1.021     5.798     0.200
     1.067     6.169     0.200
     1.107     7.576     0.200
     1.091     7.547     0.200
     1.091     7.622     0.200
     1.200     6.568     0.200
     2.355    16.083     0.200
     2.631    16.796     0.200
     2.971    19.075     0.200
     3.527    21.536     0.200
     3.829    23.870     0.200
     0.230     2.107     0.200
     0.230     2.247     0.200
     0.237     2.095     0.200
     0.602     3.969     0.200
     0.640     4.510     0.200
     0.631     4.969     0.200
     0.689     4.125     0.200
     0.711     4.170     0.200
     0.727     4.422     0.200
     0.731     4.689     0.200
     0.772     4.981     0.200
     0.850     5.484     0.200
     1.147     7.264     0.200
     1.147     7.329     0.200
     2.971    16.966     0.200
     3.105    17.730     0.200
     0.169     1.601     0.200
     0.196     2.097     0.200
     0.516     3.457     0.200
     0.571     3.937     0.200
     0.561     4.068     0.200
     0.607     4.360     0.200
     0.638     4.047     0.200
     0.606     4.635     0.200
     0.635     4.008     0.200
     0.682     4.435     0.200
     0.719     4.674     0.200
     0.760     5.020     0.200
     0.796     4.309     0.200
     0.813     5.483     0.200
     1.118     6.101     0.200
     2.163    13.359     0.200
     3.013    18.402     0.200
     3.062    19.259     0.200
     3.685    22.435     0.200
     0.350     3.418     0.200
     0.387     3.488     0.200
     0.387     1.328     0.200
     0.591     4.652     0.200
     0.528     3.305     0.200
     0.692     4.356     0.200
     0.685     4.713     0.200
     0.791     5.449     0.200
     0.799     4.900     0.200
     0.820     5.620     0.200
     0.866     5.571     0.200
     0.895     5.606     0.200
     1.016     6.417     0.200
     1.332     8.703     0.200
     1.450     8.923     0.200
     0.219     2.080     0.200
     0.219     2.230     0.200
     0.216     1.786     0.200
     0.577     3.903     0.200
     0.595     4.127     0.200
     0.616     4.550     0.200
     0.616     4.544     0.200
     0.625     3.971     0.200
     0.675     4.205     0.200
     0.669     4.489     0.200
     0.669     3.999     0.200
     0.695     4.452     0.200
     0.723     4.434     0.200
     0.756     5.010     0.200
     0.776     4.709     0.200
     0.818     5.332     0.200
     0.818     5.466     0.200
     0.856     4.446     0.200
     0.856     4.997     0.200
     0.891     5.432     0.200
     0.957     6.212     0.200
     1.016     5.990     0.200
     1.069     6.790     0.200
     1.162     7.499     0.200
     1.163     7.604     0.200
     1.168     7.193     0.200
     1.177     6.444     0.200
     1.752    11.737     0.200
     2.035    13.489     0.200
     2.120    13.976     0.200
     3.395    20.267     0.200
     4.349    26.889     0.200
     0.035     0.939     0.200
     0.185     0.867     0.200
     0.185     1.203     0.200
     0.214     1.855     0.200
     0.226     1.961     0.200
     0.220     1.962     0.200
     0.220     1.648     0.200
     0.244     2.117     0.200
     0.265     1.457     0.200
     0.310     2.270     0.200
     0.465     3.705     0.200
     0.597     3.794     0.200
     0.731     4.806     0.200
     0.731     4.431     0.200
     0.784     5.163     0.200
     0.810     4.783     0.200
     0.807     4.926     0.200
     0.845     4.825     0.200
     0.845     4.927     0.200
     0.934     5.613     0.200
     2.105    12.046     0.200
     2.277    14.625     0.200
     2.397    13.245     0.200
     2.527    16.122     0.200
     2.869    14.612     0.200
     3.469    21.535     0.200
     0.062     0.690     0.200
     0.168     1.243     0.200
     0.154     1.213     0.200
     0.258     1.944     0.200
     0.275     1.710     0.200
     0.295     2.146     0.200
     0.335     2.998     0.200
     0.346     2.170     0.200
     0.355     2.069     0.200
     0.417     3.626     0.200
     0.504     3.786     0.200
     0.504     3.306     0.200
     0.639     4.201     0.200
     0.681     4.446     0.200
     0.781     5.211     0.200
     0.795     5.346     0.200
     0.819     5.878     0.200
     0.904     5.168     0.200
     1.014     6.403     0.200
     1.177     7.440     0.200
     1.162     7.421     0.200
     2.289    14.315     0.200
     2.407    13.823     0.200
     2.523    14.235     0.200
     2.574    14.926     0.200
     0.229     1.784     0.200
     0.228     2.078     0.200
     0.228     2.328     0.200
     0.594     3.993     0.200
     0.621     4.700     0.200
     0.602     3.989     0.200
     0.685     4.640     0.200
     0.711     4.444     0.200
     0.685     4.081     0.200
     0.741     5.055     0.200
     0.720     4.231     0.200
     0.759     4.704     0.200
     0.792     4.928     0.200
     0.792     4.811     0.200
     0.834     5.704     0.200
     0.873     4.997     0.200
     1.151     7.557     0.200
     1.180     7.435     0.200
     1.152     7.681     0.200
     1.193     7.830     0.200
     0.083     1.186     0.200
     0.084     1.226     0.200
     0.138     1.272     0.200
     0.138     1.153     0.200
     0.168     1.614     0.200
     0.218     1.456     0.200
     0.227     1.595     0.200
     0.227     1.949     0.200
     0.220     1.721     0.200
     0.300     1.712     0.200
     0.441     3.182     0.200
     0.471     3.024     0.200
     0.495     3.766     0.200
     0.561     3.370     0.200
     0.554     4.127     0.200
     0.627     4.027     0.200
     0.630     4.103     0.200
     0.716     4.763     0.200
     0.714     4.654     0.200
     0.721     4.460     0.200
     0.771     4.346     0.200
     0.782     5.496     0.200
     0.797     5.027     0.200
     0.812     5.258     0.200
     0.895     5.757     0.200
     0.947     5.855     0.200
     1.005     6.324     0.200
     1.017     6.134     0.200
     1.029     6.434     0.200
     1.031     6.440     0.200
     1.070     6.508     0.200
     1.072     6.614     0.200
     1.106     6.461     0.200
     1.106     6.579     0.200
     1.122     7.119     0.200
     1.121     6.767     0.200
     1.142     6.875     0.200
     1.624    11.004     0.200
     2.209    13.428     0.200
     2.209    13.615     0.200
     2.329    12.663     0.200
     2.493    14.228     0.200
     2.499    18.374     0.200
     2.641    14.903     0.200
     2.773    17.709     0.200
     3.727    23.176     0.200
     3.765    21.329     0.200
     0.198     0.729     0.200
     0.198     1.408     0.200
     0.591     4.418     0.200
     0.635     4.696     0.200
     0.739     4.595     0.200
     0.780     5.361     0.200
     0.824     4.839     0.200
     0.783     5.703     0.200
     0.931     5.169     0.200
     1.139     6.948     0.200
     1.133     7.819     0.200
     1.669     9.956     0.200
     3.232    17.855     0.200
     3.462    19.036     0.200
     3.708    19.902     0.200
     0.043     0.910     0.200
     0.152     1.505     0.200
     0.152     1.138     0.200
     0.175     1.370     0.200
     0.225     1.669     0.200
     0.261     2.155     0.200
     0.296     2.160     0.200
     0.355     1.799     0.200
     0.451     3.624     0.200
     0.507     2.992     0.200
     0.558     4.257     0.200
     0.634     4.328     0.200
     0.634     4.070     0.200
     0.655     4.540     0.200
     0.646     4.876     0.200
     0.688     5.132     0.200
     0.867     5.466     0.200
     1.033     6.263     0.200
     1.096     6.879     0.200
     1.104     6.821     0.200
     1.127     7.391     0.200
     1.604    10.325     0.200
     2.180    13.008     0.200
     2.237    12.687     0.200
     2.405    12.117     0.200
     2.434    15.410     0.200
     2.452    13.900     0.200
     3.077    16.760     0.200
     0.218     1.520     0.200
     0.225     1.751     0.200
     0.574     3.867     0.200
     0.601     4.090     0.200
     0.666     4.622     0.200
     0.679     4.356     0.200
     0.690     4.411     0.200
     0.741     4.747     0.200
     0.731     4.225     0.200
     0.771     4.533     0.200
     0.813     5.366     0.200
     0.813     5.233     0.200
     0.855     4.588     0.200
     1.160     7.304     0.200
     1.159     7.589     0.200
     1.186     7.075     0.200
     1.255     7.342     0.200
     1.294     8.144     0.200
     1.679    10.688     0.200
     1.679     9.266     0.200
     3.828    22.110     0.200
     0.378     3.599     0.200
     0.418     3.667     0.200
     0.418     3.768     0.200
     0.532     3.393     0.200
     0.694     4.488     0.200
     0.705     4.775     0.200
     0.809     5.313     0.200
     0.823     5.006     0.200
     0.898     5.781     0.200
     0.927     5.846     0.200
     0.969     6.103     0.200
     1.005     6.306     0.200
     1.048     6.909     0.200
     1.048     6.655     0.200
     1.039     7.675     0.200
     1.131     7.515     0.200
     1.944    13.896     0.200
     7.775    45.268     0.200
     0.268     2.704     0.200
     0.282     2.371     0.200
     0.282     2.566     0.200
     0.686     4.676     0.200
     0.743     4.874     0.200
     0.845     4.917     0.200
     0.869     4.519     0.200
     0.888     5.621     0.200
     0.888     5.418     0.200
     1.078     6.865     0.200
     1.108     7.420     0.200
     1.108     7.545     0.200
     1.108     7.541     0.200
     1.325     7.659     0.200
     1.790    11.747     0.200
     1.824    12.467     0.200
     2.300    16.170     0.200
     2.914    18.692     0.200
     3.008    17.021     0.200
     3.008    17.154     0.200
     3.146    19.579     0.200
     3.194    16.050     0.200
     3.341    19.673     0.200
     3.468    20.961     0.200
     0.032     1.616     0.200
     0.105     2.029     0.200
     0.402     2.823     0.200
     0.480     3.680     0.200
     0.490     3.415     0.200
     0.528     3.595     0.200
     0.542     4.036     0.200
     0.574     3.593     0.200
     0.596     4.088     0.200
     0.654     4.236     0.200
     0.676     4.366     0.200
     0.740     4.076     0.200
     0.766     4.059     0.200
     0.784     4.585     0.200
     0.814     5.255     0.200
     0.814     5.068     0.200
     2.627    14.504     0.200
     2.779    15.222     0.200
     0.076     1.047     0.200
     0.426     3.095     0.200
     0.503     3.541     0.200
     0.500     3.292     0.200
     0.572     3.860     0.200
     0.612     3.848     0.200
     0.634     4.138     0.200
     0.645     4.064     0.200
     0.747     4.012     0.200
     0.750     4.495     0.200
     0.763     4.158     0.200
     0.781     5.194     0.200
     0.907     5.513     0.200
     1.130     6.144     0.200
     1.211     7.474     0.200
     1.211     7.708     0.200
     1.220     7.923     0.200
     2.898    17.144     0.200
     3.056    17.505     0.200
     3.649    20.174     0.200
     0.030     1.119     0.200
     0.134     1.372     0.200
     0.140     1.189     0.200
     0.172     1.472     0.200
     0.230     1.792     0.200
     0.301     1.933     0.200
     0.297     2.663     0.200
     0.316     2.445     0.200
     0.316     2.192     0.200
     0.328     2.498     0.200
     0.332     1.596     0.200
     0.406     3.411     0.200
     0.406     3.891     0.200
     0.490     4.148     0.200
     0.577     3.614     0.200
     0.650     4.240     0.200
     0.633     4.448     0.200
     0.804     5.329     0.200
     0.826     5.493     0.200
     0.868     4.618     0.200
     0.868     4.770     0.200
     1.036     6.494     0.200
     1.196     7.052     0.200
     1.197     7.549     0.200
     1.220     7.592     0.200
     2.289    14.205     0.200
     2.525    15.299     0.200
     2.577    15.213     0.200
     2.725    15.994     0.200
     2.945    17.520     0.200
     3.168    16.185     0.200
     3.285    20.958     0.200
     3.597    22.288     0.200
     3.798    23.958     0.200
     3.798    23.849     0.200
     3.963    25.782     0.200
     0.300     2.613     0.200
     0.300     2.433     0.200
     0.320     2.937     0.200
     0.320     1.807     0.200
     0.320     2.797     0.200
     0.660     4.383     0.200
     0.692     4.546     0.200
     0.722     4.342     0.200
     0.648     4.759     0.200
     0.759     4.601     0.200
     0.784     4.808     0.200
     0.883     5.464     0.200
     0.931     5.853     0.200
     0.931     6.029     0.200
     1.078     7.102     0.200
     1.246     7.622     0.200
     1.287     6.936     0.200
     1.279     7.359     0.200
     1.335     8.116     0.200
     2.047    13.603     0.200
     0.279     2.582     0.200
     0.297     2.500     0.200
     0.641     4.207     0.200
     0.672     4.373     0.200
     0.670     4.588     0.200
     0.713     4.174     0.200
     0.702     4.983     0.200
     0.738     4.382     0.200
     0.763     5.063     0.200
     0.788     5.066     0.200
     0.866     5.427     0.200
     0.914     5.797     0.200
     1.085     6.991     0.200
     1.099     7.329     0.200
     1.099     7.372     0.200
     1.237     7.574     0.200
     0.128     0.907     0.200
     0.127     1.141     0.200
     0.162     1.213     0.200
     0.218     1.717     0.200
     0.319     1.561     0.200
     0.324     2.079     0.200
     0.294     1.714     0.200
     0.319     2.349     0.200
     0.419     3.469     0.200
     0.503     4.061     0.200
     0.503     4.170     0.200
     0.637     3.962     0.200
     0.794     5.241     0.200
     0.820     5.411     0.200
     0.849     5.930     0.200
     0.870     4.949     0.200
     1.026     6.399     0.200
     1.146     6.463     0.200
     1.185     7.189     0.200
     2.274    14.580     0.200
     2.404    13.471     0.200
     3.185    18.520     0.200
     0.346     2.909     0.200
     0.629     4.112     0.200
     0.655     4.350     0.200
     0.684     4.018     0.200
     0.736     4.857     0.200
     0.750     5.222     0.200
     0.764     4.518     0.200
     0.778     5.285     0.200
     0.825     5.186     0.200
     0.856     5.219     0.200
     0.896     5.483     0.200
     0.936     5.740     0.200
     0.983     6.214     0.200
     1.083     7.175     0.200
     1.121     7.151     0.200
     3.000    19.325     0.200
     3.099    17.781     0.200
     3.283    18.450     0.200
     3.482    22.068     0.200
     0.387     2.300     0.200
     0.387     2.729     0.200
     0.437     3.158     0.200
     0.439     3.009     0.200
     0.485     2.834     0.200
     0.485     2.584     0.200
     0.855     4.752     0.200
     0.863     5.335     0.200
     0.886     6.379     0.200
     0.909     6.149     0.200
     0.904     5.530     0.200
     0.959     6.383     0.200
     1.015     6.253     0.200
     1.470     8.483     0.200
     1.544     9.504     0.200
     1.640    10.764     0.200
     2.342    12.988     0.200
     2.429    13.979     0.200
     2.457    13.145     0.200
     0.343     2.493     0.200
     0.567     3.418     0.200
     0.805     5.487     0.200
     1.057     7.036     0.200
     1.057     6.903     0.200
     1.058     7.040     0.200
     1.069     7.186     0.200
     1.199     6.376     0.200
     1.253     7.459     0.200
     1.253     7.349     0.200
     1.255     7.956     0.200
     1.304     6.773     0.200
     1.289     7.254     0.200
     1.289     7.051     0.200
     1.333     7.897     0.200
     1.792    11.733     0.200
     3.203    19.171     0.200
     3.251    18.581     0.200
     0.231     2.043     0.200
     0.231     2.330     0.200
     0.605     3.900     0.200
     0.633     4.649     0.200
     0.642     4.676     0.200
     0.686     4.383     0.200
     0.688     4.034     0.200
     0.739     5.049     0.200
     0.723     4.139     0.200
     0.761     4.988     0.200
     0.792     5.011     0.200
     0.839     5.286     0.200
     1.148     7.623     0.200
     1.149     7.587     0.200
     1.178     7.362     0.200
     1.178     7.241     0.200
     1.206     6.993     0.200
     1.238     7.805     0.200
     1.305     7.727     0.200
     1.684    10.209     0.200
     2.485    13.750     0.200
     0.082     0.748     0.200
     0.081     0.059     0.200
     0.457     3.238     0.200
     0.485     3.836     0.200
     0.523     3.711     0.200
     0.530     3.594     0.200
     0.574     3.763     0.200
     0.636     4.102     0.200
     0.639     4.104     0.200
     0.640     3.932     0.200
     0.752     4.162     0.200
     0.780     5.219     0.200
     0.806     4.760     0.200
     0.794     4.224     0.200
     0.794     4.466     0.200
     0.888     5.661     0.200
     1.122     6.283     0.200
     1.189     7.719     0.200
     1.200     7.926     0.200
     1.195     7.599     0.200
     1.327     8.188     0.200
     3.000    15.506     0.200
     3.053    18.535     0.200
     0.311     2.625     0.200
     0.311     2.394     0.200
     0.335     1.636     0.200
     0.546     4.001     0.200
     0.665     4.319     0.200
     0.633     5.132     0.200
     0.713     4.385     0.200
     0.740     4.943     0.200
     0.768     4.451     0.200
     0.759     4.935     0.200
     0.804     4.964     0.200
     0.829     5.048     0.200
     0.905     5.332     0.200
     0.954     5.923     0.200
     1.073     6.858     0.200
     1.089     7.251     0.200
     0.223     2.127     0.200
     0.215     0.781     0.200
     0.600     4.106     0.200
     0.614     4.500     0.200
     0.677     4.281     0.200
     0.663     4.715     0.200
     0.687     4.305     0.200
     0.732     4.553     0.200
     0.738     4.820     0.200
     0.759     5.283     0.200
     0.768     4.513     0.200
     0.811     4.638     0.200
     0.815     5.356     0.200
     0.852     4.707     0.200
     1.073     7.243     0.200
     1.161     7.809     0.200
     1.161     7.930     0.200
     1.161     6.844     0.200
     1.158     7.284     0.200
     1.158     7.454     0.200
     1.169     6.749     0.200
     2.130    14.113     0.200
     2.931    16.752     0.200
     3.066    16.370     0.200
     3.114    19.505     0.200
     3.491    18.979     0.200
     3.738    19.544     0.200
     4.486    27.626     0.200
     0.305     2.790     0.200
     0.327     2.076     0.200
     0.661     4.469     0.200
     0.640     4.742     0.200
     0.715     4.467     0.200
     0.704     4.673     0.200
     0.732     5.084     0.200
     0.762     4.648     0.200
     0.795     5.101     0.200
     0.819     5.160     0.200
     0.896     5.033     0.200
     0.896     5.434     0.200
     0.944     5.893     0.200
     1.085     7.230     0.200
     1.269     8.287     0.200
     1.346     8.481     0.200
     1.748    11.422     0.200
     1.791    11.476     0.200
     3.184    20.153     0.200
     3.197    20.502     0.200
     3.860    24.014     0.200
     4.275    24.059     0.200
     0.584     3.889     0.200
     0.577     3.987     0.200
     0.617     4.108     0.200
     0.631     4.487     0.200
     0.677     4.724     0.200
     0.697     4.487     0.200
     0.695     4.161     0.200
     0.742     5.043     0.200
     0.776     4.238     0.200
     0.776     4.347     0.200
     0.823     5.430     0.200
     0.866     4.580     0.200
     1.218     7.603     0.200
     1.257     8.169     0.200
     1.257     7.380     0.200
     1.284     7.659     0.200
     3.076    18.472     0.200
     3.124    19.663     0.200
     0.259     2.047     0.200
     0.616     4.131     0.200
     0.712     4.884     0.200
     0.716     4.107     0.200
     0.709     4.575     0.200
     0.729     4.651     0.200
     0.784     5.124     0.200
     0.806     4.561     0.200
     0.854     5.364     0.200
     1.060     6.662     0.200
     1.121     7.431     0.200
     1.121     7.465     0.200
     1.710     9.486     0.200
     0.489     3.427     0.200
     0.561     3.575     0.200
     0.582     3.544     0.200
     0.592     3.304     0.200
     0.647     4.176     0.200
     0.670     4.629     0.200
     0.755     5.404     0.200
     0.735     5.240     0.200
     0.858     5.468     0.200
     0.853     6.017     0.200
     0.843     5.132     0.200
     0.913     6.278     0.200
     0.993     6.516     0.200
     0.992     6.331     0.200
     1.062     7.701     0.200
     1.063     7.719     0.200
     1.212     7.402     0.200
     1.410     8.401     0.200
     1.410     8.420     0.200
     2.687    15.029     0.200
     2.890    15.140     0.200
     2.926    16.558     0.200
     3.554    20.148     0.200
     0.304     2.767     0.200
     0.673     4.490     0.200
     0.663     4.933     0.200
     0.708     4.894     0.200
     0.726     4.297     0.200
     0.721     4.867     0.200
     0.748     4.453     0.200
     0.765     4.926     0.200
     0.787     4.992     0.200
     0.863     4.951     0.200
     0.911     5.767     0.200
     1.089     7.589     0.200
     1.249     8.165     0.200
     1.340     7.985     0.200
     1.733    12.115     0.200
     2.934    18.863     0.200
     0.485     3.472     0.200
     0.556     3.651     0.200
     0.579     3.640     0.200
     0.644     4.232     0.200
     0.739     5.268     0.200
     0.845     5.145     0.200
     0.823     5.930     0.200
     0.823     5.670     0.200
     0.871     5.737     0.200
     0.857     6.064     0.200
     0.991     6.586     0.200
     0.991     6.380     0.200
     1.066     7.694     0.200
     1.067     7.640     0.200
     2.540    14.926     0.200
     2.685    15.194     0.200
     2.696    15.732     0.200
     2.888    16.563     0.200
     2.924    15.947     0.200
     3.365    19.415     0.200
     3.403    17.934     0.200
     3.552    18.527     0.200
     0.214     1.460     0.200
     0.576     3.853     0.200
     0.614     4.411     0.200
     0.623     4.430     0.200
     0.667     4.578     0.200
     0.674     4.088     0.200
     0.693     4.411     0.200
     0.723     4.178     0.200
     0.758     4.807     0.200
     0.775     4.106     0.200
     0.775     4.535     0.200
     0.822     5.427     0.200
     0.855     4.538     0.200
     1.081     7.012     0.200
     1.167     7.384     0.200
     1.163     7.582     0.200
     1.164     7.585     0.200
     1.175     6.774     0.200
     1.192     7.131     0.200
     1.260     7.488     0.200
     1.260     7.660     0.200
     3.071    18.776     0.200
     3.120    18.270     0.200
     3.117    19.718     0.200
     5.676    33.480     0.200
     0.017     1.314     0.200
     0.105     1.032     0.200
     0.194     1.608     0.200
     0.182     1.539     0.200
     0.265     2.644     0.200
     0.299     1.696     0.200
     0.319     2.103     0.200
     0.318     2.155     0.200
     0.340     2.626     0.200
     0.415     3.517     0.200
     0.543     3.586     0.200
     0.534     3.938     0.200
     0.647     4.238     0.200
     0.814     5.495     0.200
     0.814     5.362     0.200
     0.839     4.758     0.200
     0.839     4.875     0.200
     0.847     5.574     0.200
     0.869     5.420     0.200
     0.878     6.104     0.200
     1.045     6.507     0.200
     1.475     9.327     0.200
     2.272    14.332     0.200
     3.186    16.910     0.200
     0.499     3.121     0.200
     0.563     3.870     0.200
     0.561     3.440     0.200
     0.579     3.488     0.200
     0.586     4.177     0.200
     0.640     4.107     0.200
     0.658     4.598     0.200
     0.670     5.109     0.200
     0.819     5.429     0.200
     0.810     5.783     0.200
     0.810     5.501     0.200
     0.857     5.314     0.200
     0.852     4.501     0.200
     0.842     5.760     0.200
     0.859     5.574     0.200
     0.916     6.263     0.200
     0.936     5.408     0.200
     0.901     6.092     0.200
     0.985     6.501     0.200
     0.982     6.263     0.200
     1.065     7.092     0.200
     1.066     7.165     0.200
     1.359     8.466     0.200
     1.388     9.143     0.200
     1.399     8.504     0.200
     1.575    10.178     0.200
     1.694    11.590     0.200
     1.951    12.243     0.200
     1.933    12.531     0.200
     2.674    15.672     0.200
     2.735    16.256     0.200
     2.881    16.408     0.200
     2.917    16.638     0.200
     3.343    20.912     0.200
     4.680    28.030     0.200
     0.498     3.292     0.200
     0.562     4.176     0.200
     0.566     3.556     0.200
     0.586     3.634     0.200
     0.663     4.736     0.200
     0.648     4.182     0.200
     0.676     4.474     0.200
     0.676     5.045     0.200
     0.763     5.260     0.200
     0.763     5.416     0.200
     0.726     4.966     0.200
     0.863     5.440     0.200
     0.817     5.832     0.200
     0.817     5.622     0.200
     0.844     4.743     0.200
     0.867     5.665     0.200
     0.844     5.867     0.200
     0.938     5.642     0.200
     0.924     6.338     0.200
     0.993     6.534     0.200
     0.990     6.318     0.200
     0.990     6.420     0.200
     1.059     7.327     0.200
     1.060     7.353     0.200
     1.209     7.339     0.200
     1.235     7.835     0.200
     1.583    10.266     0.200
     1.702    12.352     0.200
     1.879    12.004     0.200
     1.941    12.292     0.200
     2.390    13.406     0.200
     2.682    16.064     0.200
     2.687    15.369     0.200
     2.743    15.967     0.200
     2.953    18.137     0.200
     3.070    17.193     0.200
     3.552    20.005     0.200
     3.552    20.122     0.200
     3.788    22.224     0.200
     0.220     0.855     0.200
     0.235     2.022     0.200
     0.235     1.892     0.200
     0.657     4.631     0.200
     0.676     4.466     0.200
     0.686     4.354     0.200
     0.755     4.151     0.200
     0.750     4.463     0.200
     0.802     5.429     0.200
     0.760     4.968     0.200
     0.846     4.759     0.200
     1.056     6.842     0.200
     1.140     7.375     0.200
     1.140     7.955     0.200
     1.157     6.710     0.200
     1.167     7.091     0.200
     1.167     7.572     0.200
     1.154     7.695     0.200
     1.155     7.609     0.200
     1.703    11.956     0.200
     2.823    18.129     0.200
     3.849    23.324     0.200
     0.218     0.772     0.200
     0.223     2.156     0.200
     0.223     1.717     0.200
     0.617     4.760     0.200
     0.668     4.857     0.200
     0.671     4.644     0.200
     0.774     4.213     0.200
     0.755     5.218     0.200
     0.821     5.524     0.200
     0.856     4.927     0.200
     0.938     5.043     0.200
     1.164     7.646     0.200
     1.164     7.816     0.200
     1.159     7.689     0.200
     1.160     7.472     0.200
     1.160     8.003     0.200
     1.175     6.821     0.200
     1.190     7.379     0.200
     1.258     7.504     0.200
     1.258     7.946     0.200
     1.678    10.868     0.200
     2.590    15.224     0.200
     3.122    20.146     0.200
     0.221     0.614     0.200
     0.231     1.881     0.200
     0.618     4.563     0.200
     0.621     4.566     0.200
     0.663     4.808     0.200
     0.684     4.246     0.200
     0.685     4.500     0.200
     0.739     4.896     0.200
     0.741     4.352     0.200
     0.756     5.103     0.200
     0.764     4.213     0.200
     0.812     5.501     0.200
     0.852     4.833     0.200
     1.064     7.128     0.200
     1.151     7.613     0.200
     1.155     7.757     0.200
     1.155     7.732     0.200
     1.166     6.828     0.200
     1.177     7.432     0.200
     1.218     7.836     0.200
     1.247     7.523     0.200
     1.247     8.273     0.200
     1.284     8.002     0.200
     3.063    18.792     0.200
     3.111    19.011     0.200
     0.216     1.807     0.200
     0.216     1.477     0.200
     0.210     0.684     0.200
     0.610     4.749     0.200
     0.618     4.531     0.200
     0.670     4.291     0.200
     0.662     4.789     0.200
     0.688     4.438     0.200
     0.724     4.288     0.200
     0.762     5.119     0.200
     0.770     4.162     0.200
     0.817     5.369     0.200
     0.850     4.816     0.200
     0.930     4.780     0.200
     0.930     5.030     0.200
     1.081     7.123     0.200
     1.167     7.423     0.200
     1.168     7.437     0.200
     1.164     7.695     0.200
     1.171     6.895     0.200
     1.189     7.449     0.200
     1.708    12.451     0.200
     2.834    18.187     0.200
     3.067    18.708     0.200
     3.115    18.589     0.200
     3.739    21.820     0.200
     0.273     2.755     0.200
     0.273     2.626     0.200
     0.284     2.567     0.200
     0.699     4.840     0.200
     0.727     4.195     0.200
     0.684     4.705     0.200
     0.765     4.982     0.200
     0.817     4.991     0.200
     0.890     5.730     0.200
     6.952    39.597     0.200
     0.296     2.589     0.200
     0.284     2.658     0.200
     0.284     2.537     0.200
     0.711     4.868     0.200
     0.700     4.871     0.200
     0.754     4.814     0.200
     0.775     4.901     0.200
     0.731     4.249     0.200
     0.829     5.461     0.200
     0.851     4.803     0.200
     0.899     5.687     0.200
     1.255     6.830     0.200
     1.731    10.615     0.200
     1.731    10.798     0.200
     0.129     1.558     0.200
     0.263     1.660     0.200
     0.225     1.688     0.200
     0.333     1.858     0.200
     0.333     1.594     0.200
     0.346     2.711     0.200
     0.357     2.565     0.200
     0.405     3.336     0.200
     0.457     2.982     0.200
     0.457     2.870     0.200
     0.565     3.284     0.200
     0.604     3.583     0.200
     0.586     4.559     0.200
     0.638     4.507     0.200
     0.676     3.970     0.200
     0.814     4.827     0.200
     0.819     4.692     0.200
     0.819     4.631     0.200
     0.792     4.932     0.200
     0.875     5.002     0.200
     0.877     5.348     0.200
     1.144     6.741     0.200
     1.207     6.500     0.200
     0.286     2.796     0.200
     0.304     2.650     0.200
     0.708     4.991     0.200
     0.718     4.370     0.200
     0.724     4.889     0.200
     0.768     5.092     0.200
     0.869     4.784     0.200
     0.917     5.641     0.200
     1.092     7.370     0.200
     1.092     7.490     0.200
     1.092     7.496     0.200
     3.170    19.048     0.200
     3.842    22.715     0.200
     4.448    28.203     0.200
     0.034     0.829     0.200
     0.278     2.624     0.200
     0.456     3.085     0.200
     0.529     3.706     0.200
     0.600     3.896     0.200
     0.643     3.912     0.200
     0.706     3.989     0.200
     0.707     3.986     0.200
     0.707     4.345     0.200
     0.747     4.985     0.200
     0.762     3.882     0.200
     0.762     4.089     0.200
     0.936     6.698     0.200
     1.085     6.071     0.200
     1.173     7.351     0.200
     1.180     6.994     0.200
     1.180     7.482     0.200
     1.445     8.700     0.200
     2.958    18.879     0.200
     3.012    16.612     0.200
     4.617    25.023     0.200
     6.511    35.518     0.200
     0.232     1.739     0.200
     0.220     1.718     0.200
     0.447     3.567     0.200
     0.579     3.346     0.200
     0.616     4.466     0.200
     0.618     4.490     0.200
     0.661     4.674     0.200
     0.682     4.432     0.200
     0.761     4.248     0.200
     0.809     5.392     0.200
     0.850     4.469     0.200
     0.850     5.007     0.200
     1.147     7.040     0.200
     1.147     7.220     0.200
     1.163     6.474     0.200
     1.163     6.828     0.200
     3.060    18.214     0.200
     0.072     1.234     0.200
     0.568     3.855     0.200
     0.745     4.170     0.200
     0.743     3.997     0.200
     0.785     5.066     0.200
     0.802     4.679     0.200
     0.765     4.084     0.200
     0.909     6.873     0.200
     1.599    10.687     0.200
     2.618    15.031     0.200
     2.752    15.870     0.200
     3.398    19.487     0.200
     0.241     2.440     0.200
     0.241     2.327     0.200
     0.250     2.314     0.200
     0.486     3.653     0.200
     0.818     4.742     0.200
     0.866     5.485     0.200
     2.882    17.072     0.200
     0.261     2.253     0.200
     0.268     2.157     0.200
     0.295     2.174     0.200
     0.348     3.072     0.200
     0.348     2.782     0.200
     0.450     3.137     0.200
     0.512     3.501     0.200
     0.467     3.076     0.200
     0.521     3.339     0.200
     0.559     3.613     0.200
     0.585     4.055     0.200
     0.602     3.935     0.200
     0.649     4.493     0.200
     0.682     4.268     0.200
     0.616     4.981     0.200
     0.668     4.015     0.200
     0.677     4.936     0.200
     0.701     4.093     0.200
     0.815     4.680     0.200
     0.834     4.706     0.200
     0.865     4.871     0.200
     0.888     5.216     0.200
     0.867     4.880     0.200
     0.905     6.418     0.200
     1.087     6.033     0.200
     1.141     6.331     0.200
     1.152     6.547     0.200
     1.980    10.502     0.200
     0.059     2.752     0.200
     0.059     0.611     0.200
     0.150     1.391     0.200
     0.176     2.000     0.200
     0.303     2.393     0.200
     0.303     2.873     0.200
     0.443     3.163     0.200
     0.463     3.711     0.200
     0.463     3.851     0.200
     0.477     3.143     0.200
     0.511     3.506     0.200
     0.514     3.843     0.200
     0.553     3.550     0.200
     0.619     3.938     0.200
     0.619     3.984     0.200
     0.653     3.643     0.200
     0.679     5.400     0.200
     0.720     4.098     0.200
     0.730     4.087     0.200
     0.723     4.252     0.200
     0.751     4.280     0.200
     0.779     4.097     0.200
     0.764     5.086     0.200
     0.786     4.747     0.200
     0.882     5.042     0.200
     0.911     5.583     0.200
     0.985     5.748     0.200
     1.066     7.072     0.200
     1.105     6.269     0.200
     1.105     6.386     0.200
     1.149     7.485     0.200
     1.190     7.438     0.200
     1.225     7.790     0.200
     1.283     8.213     0.200
     1.283     8.683     0.200
     1.402    10.490     0.200
     1.634    10.391     0.200
     2.434    13.729     0.200
     2.456    15.920     0.200
     0.080     1.297     0.200
     0.121     1.039     0.200
     0.318     2.494     0.200
     0.318     2.876     0.200
     0.418     2.925     0.200
     0.470     4.059     0.200
     0.497     3.488     0.200
     0.504     3.272     0.200
     0.519     3.867     0.200
     0.603     3.718     0.200
     0.575     4.081     0.200
     0.634     3.575     0.200
     0.638     4.185     0.200
     0.650     4.108     0.200
     0.729     4.261     0.200
     0.714     5.582     0.200
     0.756     4.016     0.200
     0.749     4.089     0.200
     0.757     4.256     0.200
     0.757     4.366     0.200
     0.797     5.110     0.200
     0.897     5.223     0.200
     1.013     5.654     0.200
     1.135     6.067     0.200
     1.185     7.786     0.200
     1.219     7.534     0.200
     1.260     7.171     0.200
     1.260     7.335     0.200
     1.320     8.468     0.200
     1.339     8.258     0.200
     1.541     7.924     0.200
     1.495     9.004     0.200
     1.552     9.605     0.200
     1.668     9.735     0.200
     1.705     9.529     0.200
     1.748    11.912     0.200
     1.781    10.931     0.200
     5.024    31.201     0.200
     5.970    36.484     0.200
     6.179    33.625     0.200
     0.085     1.008     0.200
     0.117     1.202     0.200
     0.139     2.108     0.200
     0.321     2.797     0.200
     0.360     3.172     0.200
     0.414     3.045     0.200
     0.472     3.808     0.200
     0.472     3.941     0.200
     0.495     3.476     0.200
     0.509     3.124     0.200
     0.579     3.723     0.200
     0.597     3.701     0.200
     0.630     3.637     0.200
     0.642     3.974     0.200
     0.655     3.867     0.200
     0.730     4.221     0.200
     0.752     4.118     0.200
     0.720     5.345     0.200
     0.752     3.896     0.200
     0.762     3.986     0.200
     0.802     4.912     0.200
     0.899     5.100     0.200
     1.018     5.512     0.200
     1.234     7.797     0.200
     1.466     9.175     0.200
     1.500     9.154     0.200
     2.872    16.704     0.200
     3.408    18.601     0.200
     0.069     1.014     0.200
     0.132     1.270     0.200
     0.158     1.927     0.200
     0.428     3.095     0.200
     0.466     3.851     0.200
     0.492     3.280     0.200
     0.502     3.595     0.200
     0.516     3.945     0.200
     0.565     3.716     0.200
     0.629     4.101     0.200
     0.637     4.109     0.200
     0.641     3.654     0.200
     0.619     3.809     0.200
     0.699     5.431     0.200
     0.740     4.072     0.200
     0.742     4.183     0.200
     0.761     4.362     0.200
     0.765     4.092     0.200
     0.782     5.212     0.200
     0.800     4.755     0.200
     0.890     4.963     0.200
     1.001     5.807     0.200
     1.122     6.103     0.200
     1.169     7.566     0.200
     1.203     7.454     0.200
     1.212     7.054     0.200
     1.304     8.272     0.200
     1.503     9.342     0.200
     1.653    10.458     0.200
     2.521    12.572     0.200
     2.749    15.329     0.200
     4.240    26.162     0.200
     5.917    32.582     0.200
     6.187    34.243     0.200
     0.162     1.593     0.200
     0.243     1.767     0.200
     0.243     1.720     0.200
     0.254     1.826     0.200
     0.299     1.798     0.200
     0.313     1.780     0.200
     0.345     2.498     0.200
     0.345     2.667     0.200
     0.382     2.677     0.200
     0.393     2.243     0.200
     0.403     2.790     0.200
     0.425     2.883     0.200
     0.472     3.009     0.200
     0.465     3.196     0.200
     0.492     3.931     0.200
     0.470     3.188     0.200
     0.518     3.803     0.200
     0.580     4.444     0.200
     0.580     4.314     0.200
     0.578     3.673     0.200
     0.591     3.986     0.200
     0.576     3.687     0.200
     0.591     3.887     0.200
     0.610     4.703     0.200
     0.603     3.606     0.200
     0.667     4.460     0.200
     0.667     4.590     0.200
     0.684     4.101     0.200
     0.703     4.176     0.200
     0.700     4.422     0.200
     0.775     4.600     0.200
     0.804     5.071     0.200
     0.789     5.366     0.200
     0.807     5.716     0.200
     0.819     4.726     0.200
     0.820     5.431     0.200
     0.843     4.877     0.200
     0.831     5.555     0.200
     0.831     5.764     0.200
     0.860     5.464     0.200
     0.880     5.674     0.200
     0.967     5.858     0.200
     1.029     6.613     0.200
     1.041     6.581     0.200
     1.094     6.271     0.200
     1.101     6.076     0.200
     1.186     6.524     0.200
     2.019    11.497     0.200
     2.332    13.028     0.200
     0.109     1.980     0.200
     0.111     1.709     0.200
     0.097     1.658     0.200
     0.235     2.504     0.200
     0.235     3.433     0.200
     0.285     2.031     0.200
     0.291     2.774     0.200
     0.291     2.657     0.200
     0.371     1.632     0.200
     0.371     3.457     0.200
     0.418     3.252     0.200
     0.412     3.333     0.200
     0.483     3.842     0.200
     0.503     3.906     0.200
     0.533     3.841     0.200
     0.533     4.044     0.200
     0.552     3.910     0.200
     0.530     3.993     0.200
     0.539     4.051     0.200
     0.543     3.932     0.200
     0.564     3.701     0.200
     0.542     3.666     0.200
     0.573     4.071     0.200
     0.559     4.590     0.200
     0.587     4.068     0.200
     0.602     4.931     0.200
     0.670     4.060     0.200
     0.673     4.506     0.200
     0.755     5.193     0.200
     0.841     5.238     0.200
     0.883     5.779     0.200
     0.963     5.325     0.200
     0.995     6.422     0.200
     1.378     9.552     0.200
     1.553     9.820     0.200
     1.642    10.637     0.200
     1.961    12.853     0.200
     1.951    12.357     0.200
     2.250    14.162     0.200
     0.033     1.631     0.200
     0.043     2.058     0.200
     0.075     1.131     0.200
     0.113     1.257     0.200
     0.129     1.970     0.200
     0.150     2.049     0.200
     0.227     1.983     0.200
     0.248     2.258     0.200
     0.253     2.213     0.200
     0.309     2.945     0.200
     0.312     3.110     0.200
     0.323     2.939     0.200
     0.337     2.447     0.200
     0.364     3.218     0.200
     0.409     3.119     0.200
     0.447     3.308     0.200
     0.460     3.919     0.200
     0.487     3.612     0.200
     0.509     3.917     0.200
     0.555     4.578     0.200
     0.568     3.901     0.200
     0.589     4.228     0.200
     0.587     4.527     0.200
     0.624     3.744     0.200
     0.630     4.149     0.200
     0.645     4.077     0.200
     0.645     4.020     0.200
     0.719     4.382     0.200
     0.719     5.496     0.200
     0.740     4.060     0.200
     0.746     4.222     0.200
     0.794     4.625     0.200
     0.793     5.071     0.200
     0.803     4.685     0.200
     0.921     5.586     0.200
     1.097     7.147     0.200
     1.130     6.126     0.200
     1.323     7.956     0.200
     1.323     8.176     0.200
     1.351     8.138     0.200
     1.425     8.532     0.200
     1.885     9.959     0.200
     0.050     1.555     0.200
     0.127     1.359     0.200
     0.234     2.071     0.200
     0.234     2.321     0.200
     0.232     2.521     0.200
     0.267     2.734     0.200
     0.309     2.524     0.200
     0.362     2.720     0.200
     0.407     3.950     0.200
     0.437     3.200     0.200
     0.447     3.656     0.200
     0.469     3.984     0.200
     0.506     4.137     0.200
     0.503     4.264     0.200
     0.510     4.020     0.200
     0.518     4.131     0.200
     0.555     3.972     0.200
     0.573     4.196     0.200
     0.598     4.854     0.200
     0.605     3.990     0.200
     0.636     4.592     0.200
     0.691     4.788     0.200
     0.689     4.580     0.200
     0.690     4.187     0.200
     0.717     3.554     0.200
     0.716     4.697     0.200
     0.717     4.417     0.200
     0.735     5.093     0.200
     0.755     4.855     0.200
     0.767     4.668     0.200
     0.845     5.407     0.200
     0.901     6.287     0.200
     0.890     4.994     0.200
     0.913     5.215     0.200
     1.038     5.805     0.200
     1.146     7.285     0.200
     1.183     7.182     0.200
     1.737    12.341     0.200
     3.552    18.083     0.200
     0.099     2.138     0.200
     0.113     2.152     0.200
     0.142     2.008     0.200
     0.152     2.083     0.200
     0.153     2.421     0.200
     0.177     1.949     0.200
     0.190     2.390     0.200
     0.219     2.270     0.200
     0.282     1.938     0.200
     0.284     2.478     0.200
     0.331     2.502     0.200
     0.330     2.538     0.200
     0.366     3.059     0.200
     0.375     2.672     0.200
     0.377     2.970     0.200
     0.396     3.170     0.200
     0.414     3.411     0.200
     0.443     4.315     0.200
     0.458     3.851     0.200
     0.469     3.332     0.200
     0.482     3.650     0.200
     0.478     3.595     0.200
     0.525     2.910     0.200
     0.530     3.154     0.200
     0.589     4.018     0.200
     0.591     4.114     0.200
     0.615     3.580     0.200
     0.604     4.003     0.200
     0.626     3.583     0.200
     0.638     3.733     0.200
     0.650     3.360     0.200
     0.658     4.299     0.200
     0.678     3.952     0.200
     0.757     5.309     0.200
     0.820     5.497     0.200
     0.910     6.216     0.200
     0.938     5.328     0.200
     0.947     5.505     0.200
     0.947     5.665     0.200
     1.037     6.496     0.200
     1.172     6.638     0.200
     1.291     7.457     0.200
     1.291     7.893     0.200
     0.048     1.028     0.200
     0.065     0.843     0.200
     0.105     1.171     0.200
     0.108     1.221     0.200
     0.106     0.742     0.200
     0.132     1.778     0.200
     0.155     2.092     0.200
     0.160     2.077     0.200
     0.242     2.050     0.200
     0.259     2.230     0.200
     0.255     2.160     0.200
     0.245     2.065     0.200
     0.276     2.589     0.200
     0.305     2.836     0.200
     0.303     2.747     0.200
     0.314     3.160     0.200
     0.319     3.111     0.200
     0.327     2.061     0.200
     0.356     3.707     0.200
     0.344     2.705     0.200
     0.359     2.994     0.200
     0.421     3.126     0.200
     0.459     3.773     0.200
     0.494     3.564     0.200
     0.489     3.228     0.200
     0.514     3.715     0.200
     0.509     3.841     0.200
     0.541     4.346     0.200
     0.561     3.859     0.200
     0.587     4.067     0.200
     0.594     4.475     0.200
     0.633     3.693     0.200
     0.624     4.009     0.200
     0.634     4.007     0.200
     0.634     4.161     0.200
     0.694     4.980     0.200
     0.718     4.289     0.200
     0.704     5.325     0.200
     0.735     3.956     0.200
     0.757     4.296     0.200
     0.741     3.988     0.200
     0.756     4.362     0.200
     0.781     5.051     0.200
     0.796     4.620     0.200
     0.918     5.582     0.200
     1.086     7.328     0.200
     1.315     8.343     0.200
     1.444     9.210     0.200
     0.148     1.003     0.200
     0.199     1.351     0.200
     0.216     1.699     0.200
     0.234     2.264     0.200
     0.275     1.913     0.200
     0.283     2.630     0.200
     0.298     2.443     0.200
     0.306     2.571     0.200
     0.285     2.584     0.200
     0.323     2.806     0.200
     0.326     2.682     0.200
     0.356     2.796     0.200
     0.365     2.872     0.200
     0.386     3.185     0.200
     0.411     2.951     0.200
     0.405     3.419     0.200
     0.406     3.433     0.200
     0.406     3.313     0.200
     0.436     2.932     0.200
     0.503     3.866     0.200
     0.538     4.091     0.200
     0.553     3.439     0.200
     0.552     3.515     0.200
     0.542     3.840     0.200
     0.559     4.114     0.200
     0.549     4.356     0.200
     0.566     3.880     0.200
     0.609     4.162     0.200
     0.611     4.376     0.200
     0.611     3.915     0.200
     0.618     4.100     0.200
     0.638     3.240     0.200
     0.684     4.535     0.200
     0.661     4.903     0.200
     0.720     4.263     0.200
     0.739     4.349     0.200
     0.749     4.743     0.200
     0.748     4.664     0.200
     0.763     4.024     0.200
     0.829     4.909     0.200
     0.883     5.319     0.200
     0.884     5.094     0.200
     0.882     5.151     0.200
     0.961     6.513     0.200
     0.961     6.633     0.200
     1.045     6.921     0.200
     1.060     7.012     0.200
     1.076     6.797     0.200
     1.130     7.156     0.200
     1.363     8.300     0.200
     1.425    11.155     0.200
     1.535     9.576     0.200
     1.751    10.720     0.200
     2.930    18.090     0.200
     2.979    17.709     0.200
     3.483    22.256     0.200
     4.687    25.530     0.200
     0.110     1.260     0.200
     0.125     1.119     0.200
     0.154     1.741     0.200
     0.191     1.169     0.200
     0.163     1.412     0.200
     0.216     1.018     0.200
     0.224     1.152     0.200
     0.205     1.994     0.200
     0.227     1.721     0.200
     0.244     2.236     0.200
     0.243     2.004     0.200
     0.289     2.401     0.200
     0.240     2.166     0.200
     0.290     2.164     0.200
     0.315     2.800     0.200
     0.338     2.811     0.200
     0.338     2.780     0.200
     0.323     2.856     0.200
     0.362     2.957     0.200
     0.375     2.797     0.200
     0.346     3.094     0.200
     0.385     2.790     0.200
     0.372     3.257     0.200
     0.383     3.284     0.200
     0.395     3.266     0.200
     0.397     3.507     0.200
     0.445     3.291     0.200
     0.448     3.326     0.200
     0.451     3.106     0.200
     0.483     3.223     0.200
     0.452     3.241     0.200
     0.507     3.248     0.200
     0.514     3.817     0.200
     0.562     3.706     0.200
     0.539     3.551     0.200
     0.588     3.875     0.200
     0.548     3.795     0.200
     0.546     3.862     0.200
     0.559     4.609     0.200
     0.553     3.796     0.200
     0.573     3.558     0.200
     0.626     3.859     0.200
     0.590     3.905     0.200
     0.616     3.977     0.200
     0.612     4.196     0.200
     0.639     3.810     0.200
     0.628     4.326     0.200
     0.640     4.506     0.200
     0.638     5.128     0.200
     0.676     3.731     0.200
     0.690     3.666     0.200
     0.665     4.374     0.200
     0.672     4.981     0.200
     0.669     4.509     0.200
     0.687     4.465     0.200
     0.724     4.330     0.200
     0.640     4.646     0.200
     0.705     4.619     0.200
     0.753     4.165     0.200
     0.744     4.213     0.200
     0.742     4.638     0.200
     0.763     4.170     0.200
     0.736     4.750     0.200
     0.730     5.057     0.200
     0.756     4.751     0.200
     0.772     4.842     0.200
     0.774     4.912     0.200
     0.827     4.293     0.200
     0.800     5.080     0.200
     0.826     5.444     0.200
     0.826     5.417     0.200
     0.813     5.567     0.200
     0.854     5.529     0.200
     0.864     5.271     0.200
     0.927     5.234     0.200
     0.932     5.235     0.200
     0.924     5.900     0.200
     0.917     5.888     0.200
     0.917     6.118     0.200
     0.931     5.684     0.200
     0.931     5.711     0.200
     0.930     5.978     0.200
     0.948     6.370     0.200
     0.967     5.949     0.200
     0.996     5.555     0.200
     0.997     5.534     0.200
     1.018     6.886     0.200
     1.067     5.905     0.200
     1.058     7.237     0.200
     1.108     7.642     0.200
     6.030    33.039     0.200
     0.072     0.542     0.200
     0.073     0.490     0.200
     0.139     1.287     0.200
     0.128     1.031     0.200
     0.165     1.227     0.200
     0.175     1.842     0.200
     0.215     1.431     0.200
     0.292     2.512     0.200
     0.297     2.312     0.200
     0.315     2.692     0.200
     0.319     2.110     0.200
     0.324     2.851     0.200
     0.389     2.911     0.200
     0.476     3.850     0.200
     0.476     3.869     0.200
     0.483     3.731     0.200
     0.483     3.182     0.200
     0.494     3.292     0.200
     0.494     3.462     0.200
     0.528     3.511     0.200
     0.502     3.956     0.200
     0.533     4.402     0.200
     0.600     4.184     0.200
     0.595     4.385     0.200
     0.595     4.543     0.200
     0.629     4.063     0.200
     0.622     4.070     0.200
     0.644     3.851     0.200
     0.663     4.774     0.200
     0.733     4.311     0.200
     0.724     3.858     0.200
     0.740     4.111     0.200
     0.760     4.345     0.200
     0.776     4.485     0.200
     0.766     5.091     0.200
     0.795     4.043     0.200
     0.811     4.242     0.200
     0.873     5.246     0.200
     0.881     5.222     0.200
     0.854     6.477     0.200
     0.896     5.380     0.200
     0.896     5.620     0.200
     0.961     5.849     0.200
     0.930     7.003     0.200
     0.969     6.489     0.200
     1.049     6.720     0.200
     1.141     7.496     0.200
     1.147     7.470     0.200
     1.159     7.603     0.200
     0.106     0.467     0.200
     0.107     0.430     0.200
     0.144     0.455     0.200
     0.150     1.261     0.200
     0.182     1.369     0.200
     0.214     2.120     0.200
     0.308     1.901     0.200
     0.332     2.709     0.200
     0.330     2.452     0.200
     0.352     2.664     0.200
     0.345     2.766     0.200
     0.345     3.276     0.200
     0.369     2.910     0.200
     0.441     2.927     0.200
     0.444     3.599     0.200
     0.473     3.135     0.200
     0.491     3.637     0.200
     0.500     3.804     0.200
     0.500     3.824     0.200
     0.514     3.694     0.200
     0.514     3.654     0.200
     0.554     4.086     0.200
     0.547     3.259     0.200
     0.575     3.992     0.200
     0.575     3.842     0.200
     0.602     3.833     0.200
     0.618     4.330     0.200
     0.608     4.551     0.200
     0.608     4.639     0.200
     0.633     4.137     0.200
     0.696     3.633     0.200
     0.701     3.790     0.200
     0.720     3.994     0.200
     0.726     5.304     0.200
     0.744     4.161     0.200
     0.744     4.161     0.200
     0.740     4.839     0.200
     0.787     4.920     0.200
     0.800     4.586     0.200
     0.805     5.372     0.200
     0.832     4.915     0.200
     0.848     4.379     0.200
     0.865     4.594     0.200
     0.902     5.350     0.200
     0.872     5.603     0.200
     0.939     6.223     0.200
     1.031     6.746     0.200
     1.131     7.396     0.200
     1.131     7.256     0.200
     1.145     7.402     0.200
     1.193     7.570     0.200
     1.217     8.186     0.200
     1.257     7.259     0.200
     1.472     9.335     0.200
     1.924    12.361     0.200
     1.936    12.518     0.200
     2.325    14.275     0.200
     2.348    14.255     0.200
     0.040     1.697     0.200
     0.082     1.135     0.200
     0.118     1.787     0.200
     0.142     1.772     0.200
     0.227     1.720     0.200
     0.256     2.066     0.200
     0.242     2.159     0.200
     0.302     2.967     0.200
     0.319     2.838     0.200
     0.345     2.305     0.200
     0.417     2.923     0.200
     0.417     2.970     0.200
     0.446     3.285     0.200
     0.471     3.816     0.200
     0.471     3.847     0.200
     0.469     3.546     0.200
     0.497     3.429     0.200
     0.506     3.199     0.200
     0.520     3.973     0.200
     0.549     4.416     0.200
     0.578     4.358     0.200
     0.599     3.302     0.200
     0.600     3.957     0.200
     0.633     3.513     0.200
     0.640     4.028     0.200
     0.759     4.329     0.200
     0.716     5.049     0.200
     0.751     4.127     0.200
     0.751     4.077     0.200
     0.755     4.099     0.200
     0.762     4.194     0.200
     0.770     5.074     0.200
     0.799     5.094     0.200
     0.799     5.222     0.200
     0.812     4.776     0.200
     0.849     5.135     0.200
     0.898     5.188     0.200
     0.909     5.633     0.200
     0.909     5.855     0.200
     1.005     6.517     0.200
     1.100     7.065     0.200
     1.089     6.965     0.200
     1.187     7.624     0.200
     1.191     7.639     0.200
     1.212     6.493     0.200
     1.336     8.799     0.200
     1.357     8.776     0.200
     1.411    10.552     0.200
     1.615     8.955     0.200
     2.263    12.080     0.200
     0.036     1.580     0.200
     0.073     1.143     0.200
     0.075     1.054     0.200
     0.129     1.906     0.200
     0.151     1.970     0.200
     0.229     1.891     0.200
     0.250     2.171     0.200
     0.278     2.678     0.200
     0.251     2.207     0.200
     0.309     2.915     0.200
     0.313     3.016     0.200
     0.345     2.495     0.200
     0.336     2.399     0.200
     0.348     3.014     0.200
     0.411     3.031     0.200
     0.411     3.021     0.200
     0.449     3.135     0.200
     0.459     3.439     0.200
     0.488     3.522     0.200
     0.497     3.248     0.200
     0.510     3.829     0.200
     0.552     4.521     0.200
     0.589     4.135     0.200
     0.589     4.135     0.200
     0.594     3.402     0.200
     0.588     4.305     0.200
     0.588     4.313     0.200
     0.625     3.658     0.200
     0.629     4.091     0.200
     0.643     4.029     0.200
     0.719     4.297     0.200
     0.717     5.450     0.200
     0.748     4.124     0.200
     0.757     4.526     0.200
     0.761     4.420     0.200
     0.764     4.259     0.200
     0.794     4.588     0.200
     0.791     5.017     0.200
     0.802     4.613     0.200
     0.839     4.969     0.200
     0.887     4.994     0.200
     0.997     6.555     0.200
     1.095     7.165     0.200
     1.456     9.119     0.200
     2.433    13.916     0.200
     2.951    16.790     0.200
     0.052     1.338     0.200
     0.074     1.661     0.200
     0.177     1.818     0.200
     0.229     1.443     0.200
     0.268     2.155     0.200
     0.352     2.104     0.200
     0.350     2.601     0.200
     0.358     2.253     0.200
     0.344     2.434     0.200
     0.318     2.472     0.200
     0.412     2.606     0.200
     0.384     3.426     0.200
     0.420     2.988     0.200
     0.415     3.626     0.200
     0.411     3.048     0.200
     0.446     3.503     0.200
     0.472     3.247     0.200
     0.493     3.770     0.200
     0.507     3.568     0.200
     0.498     3.351     0.200
     0.513     3.889     0.200
     0.503     4.118     0.200
     0.547     3.217     0.200
     0.574     3.644     0.200
     0.539     4.512     0.200
     0.537     3.783     0.200
     0.547     3.661     0.200
     0.602     3.838     0.200
     0.610     3.991     0.200
     0.633     4.171     0.200
     0.650     4.080     0.200
     0.660     4.377     0.200
     0.674     3.734     0.200
     0.652     4.326     0.200
     0.730     4.894     0.200
     0.772     4.920     0.200
     0.727     5.096     0.200
     0.740     4.692     0.200
     0.761     4.731     0.200
     0.776     4.761     0.200
     0.777     4.707     0.200
     0.783     4.835     0.200
     0.830     5.131     0.200
     0.864     4.958     0.200
     0.864     5.319     0.200
     0.816     5.588     0.200
     0.850     5.207     0.200
     0.877     5.307     0.200
     0.883     5.804     0.200
     0.754     7.546     0.200
     0.906     6.333     0.200
     0.944     5.441     0.200
     0.922     5.758     0.200
     0.966     6.587     0.200
     1.005     6.147     0.200
     1.083     6.776     0.200
     1.123     7.470     0.200
     0.098     0.449     0.200
     0.153     0.781     0.200
     0.100     1.247     0.200
     0.154     1.839     0.200
     0.146     1.386     0.200
     0.146     1.485     0.200
     0.222     1.771     0.200
     0.341     2.564     0.200
     0.333     1.928     0.200
     0.356     2.617     0.200
     0.353     2.138     0.200
     0.339     2.786     0.200
     0.337     2.777     0.200
     0.415     3.018     0.200
     0.392     3.047     0.200
     0.407     2.866     0.200
     0.403     2.615     0.200
     0.438     3.206     0.200
     0.396     3.242     0.200
     0.408     3.094     0.200
     0.448     2.865     0.200
     0.497     3.436     0.200
     0.488     3.508     0.200
     0.444     4.060     0.200
     0.503     3.196     0.200
     0.469     3.291     0.200
     0.485     3.603     0.200
     0.485     3.604     0.200
     0.468     3.336     0.200
     0.567     3.214     0.200
     0.595     3.552     0.200
     0.533     4.043     0.200
     0.605     3.763     0.200
     0.555     4.127     0.200
     0.592     4.011     0.200
     0.670     3.657     0.200
     0.697     4.275     0.200
     0.698     4.132     0.200
     0.685     4.625     0.200
     0.721     3.692     0.200
     0.716     3.916     0.200
     0.685     4.981     0.200
     0.720     4.660     0.200
     0.777     4.396     0.200
     0.775     4.935     0.200
     0.752     5.271     0.200
     0.784     5.276     0.200
     0.840     5.136     0.200
     0.904     5.515     0.200
     0.894     5.795     0.200
     0.929     5.578     0.200
     0.941     5.870     0.200
     1.005     6.696     0.200
     1.106     6.095     0.200
     1.170     6.591     0.200
     1.208     6.434     0.200
     1.282     8.567     0.200
     1.294     9.019     0.200
     1.337     7.729     0.200
     1.301     7.884     0.200
     1.356     8.732     0.200
     1.364     9.003     0.200
     1.469     7.782     0.200
     1.458     8.412     0.200
     2.025    11.297     0.200
     0.093     0.613     0.200
     0.072     0.836     0.200
     0.104     1.220     0.200
     0.147     0.921     0.200
     0.107     1.370     0.200
     0.150     1.324     0.200
     0.151     1.376     0.200
     0.214     1.704     0.200
     0.214     1.704     0.200
     0.181     1.640     0.200
     0.220     1.823     0.200
     0.331     2.006     0.200
     0.331     2.030     0.200
     0.336     2.506     0.200
     0.351     2.297     0.200
     0.339     2.472     0.200
     0.410     3.074     0.200
     0.403     2.576     0.200
     0.398     3.181     0.200
     0.389     2.945     0.200
     0.403     2.735     0.200
     0.396     3.443     0.200
     0.451     2.790     0.200
     0.410     3.455     0.200
     0.485     3.757     0.200
     0.470     3.254     0.200
     0.492     3.437     0.200
     0.471     3.289     0.200
     0.498     3.138     0.200
     0.444     3.878     0.200
     0.482     3.488     0.200
     0.482     3.496     0.200
     0.562     3.178     0.200
     0.535     3.859     0.200
     0.602     3.610     0.200
     0.558     3.907     0.200
     0.558     3.758     0.200
     0.556     3.839     0.200
     0.556     3.948     0.200
     0.596     3.793     0.200
     0.681     3.881     0.200
     0.694     4.185     0.200
     0.686     4.458     0.200
     0.667     3.571     0.200
     0.697     4.139     0.200
     0.717     3.619     0.200
     0.711     3.732     0.200
     0.690     4.769     0.200
     0.776     4.455     0.200
     0.776     4.955     0.200
     0.752     5.017     0.200
     0.787     5.196     0.200
     0.758     5.079     0.200
     0.840     5.232     0.200
     0.906     5.534     0.200
     0.897     5.785     0.200
     0.944     5.996     0.200
     1.029     5.880     0.200
     1.010     6.726     0.200
     1.464     9.349     0.200
     0.086     0.955     0.200
     0.122     1.386     0.200
     0.177     0.989     0.200
     0.179     0.785     0.200
     0.149     1.082     0.200
     0.197     1.429     0.200
     0.190     1.470     0.200
     0.229     0.942     0.200
     0.229     0.993     0.200
     0.234     1.059     0.200
     0.220     1.863     0.200
     0.209     1.762     0.200
     0.239     2.027     0.200
     0.209     1.969     0.200
     0.320     2.589     0.200
     0.320     2.589     0.200
     0.330     2.525     0.200
     0.312     2.274     0.200
     0.347     2.987     0.200
     0.371     3.054     0.200
     0.372     3.092     0.200
     0.393     2.696     0.200
     0.399     2.977     0.200
     0.395     3.175     0.200
     0.376     3.365     0.200
     0.455     2.573     0.200
     0.418     3.017     0.200
     0.473     3.573     0.200
     0.494     3.038     0.200
     0.502     3.345     0.200
     0.505     3.367     0.200
     0.512     3.422     0.200
     0.524     3.800     0.200
     0.519     3.591     0.200
     0.561     3.486     0.200
     0.558     3.736     0.200
     0.589     4.360     0.200
     0.607     3.866     0.200
     0.573     4.485     0.200
     0.571     4.463     0.200
     0.638     3.844     0.200
     0.650     4.021     0.200
     0.635     4.172     0.200
     0.650     4.289     0.200
     0.635     4.343     0.200
     0.657     4.262     0.200
     0.662     4.606     0.200
     0.655     3.603     0.200
     0.671     4.944     0.200
     0.705     3.925     0.200
     0.672     4.470     0.200
     0.707     4.268     0.200
     0.702     4.651     0.200
     0.728     4.504     0.200
     0.705     5.242     0.200
     0.705     5.253     0.200
     0.758     4.317     0.200
     0.752     4.902     0.200
     0.752     4.873     0.200
     0.740     4.720     0.200
     0.720     5.032     0.200
     0.733     4.910     0.200
     0.729     5.106     0.200
     0.759     5.233     0.200
     0.759     5.464     0.200
     0.766     4.936     0.200
     0.797     4.496     0.200
     0.802     5.201     0.200
     0.773     5.187     0.200
     0.831     4.616     0.200
     0.781     5.475     0.200
     0.797     5.447     0.200
     0.827     5.282     0.200
     0.824     5.350     0.200
     0.824     5.131     0.200
     0.832     5.116     0.200
     0.899     5.982     0.200
     0.920     5.503     0.200
     0.896     5.695     0.200
     0.928     4.953     0.200
     0.931     6.143     0.200
     0.936     5.689     0.200
     0.980     5.843     0.200
     0.981     5.824     0.200
     0.954     6.202     0.200
     1.007     6.331     0.200
     1.004     6.447     0.200
     1.014     6.706     0.200
     1.013     7.037     0.200
     1.038     6.405     0.200
     1.038     6.635     0.200
     1.016     7.082     0.200
     1.051     6.243     0.200
     1.030     7.433     0.200
     1.084     6.192     0.200
     1.064     6.570     0.200
     1.082     6.765     0.200
     1.102     6.441     0.200
     1.080     7.538     0.200
     1.106     6.369     0.200
     1.120     6.699     0.200
     1.142     6.400     0.200
     1.150     7.701     0.200
     1.150     8.111     0.200
     1.174     7.214     0.200
     1.197     7.532     0.200
     1.215     7.121     0.200
     1.238     6.786     0.200
     1.229     7.207     0.200
     1.255     7.268     0.200
     1.215     8.185     0.200
     6.026    36.381     0.200
     0.169     0.944     0.200
     0.168     0.947     0.200
     0.186     1.005     0.200
     0.253     2.064     0.200
     0.269     2.185     0.200
     0.298     2.208     0.200
     0.290     1.704     0.200
     0.344     2.237     0.200
     0.336     2.545     0.200
     0.336     2.555     0.200
     0.359     3.113     0.200
     0.413     3.201     0.200
     0.414     3.211     0.200
     0.400     2.967     0.200
     0.440     3.490     0.200
     0.441     3.470     0.200
     0.453     3.295     0.200
     0.481     3.416     0.200
     0.497     3.797     0.200
     0.493     4.028     0.200
     0.538     4.036     0.200
     0.538     4.036     0.200
     0.569     3.996     0.200
     0.587     3.931     0.200
     0.585     4.263     0.200
     0.593     3.852     0.200
     0.633     3.910     0.200
     0.633     3.901     0.200
     0.651     4.098     0.200
     0.657     4.326     0.200
     0.664     4.496     0.200
     0.675     4.622     0.200
     0.673     4.373     0.200
     0.731     4.791     0.200
     0.746     4.119     0.200
     0.766     4.072     0.200
     0.753     5.388     0.200
     0.753     5.354     0.200
     0.799     5.379     0.200
     0.790     5.272     0.200
     0.823     4.911     0.200
     0.885     4.660     0.200
     0.882     5.785     0.200
     0.903     5.211     0.200
     0.901     5.804     0.200
     0.972     5.612     0.200
     0.963     6.341     0.200
     0.982     6.442     0.200
     0.986     6.483     0.200
     0.967     5.618     0.200
     0.966     5.683     0.200
     0.992     6.655     0.200
     1.016     5.904     0.200
     1.002     6.363     0.200
     1.002     6.819     0.200
     1.044     6.668     0.200
     1.067     7.110     0.200
     1.098     6.656     0.200
     1.109     7.156     0.200
     1.117     7.151     0.200
     1.173     7.656     0.200
     1.217     8.200     0.200
     1.238     7.853     0.200
     1.256     8.068     0.200
     1.279     8.393     0.200
     1.278     7.965     0.200
     1.375     7.587     0.200
     0.835     5.668     0.200
     0.781     5.287     0.200
     0.453     3.253     0.200
     0.461     3.469     0.200
     0.314     2.521     0.200
     1.024     6.538     0.200
     0.247     2.247     0.200
     0.670     4.697     0.200
     0.178     1.906     0.200
     0.983     5.867     0.200
     0.366     3.271     0.200
     0.771     5.174     0.200
     0.887     5.511     0.200
     0.696     4.251     0.200
     0.430     3.258     0.200
     0.437     3.183     0.200
     0.435     3.215     0.200
     0.194     2.475     0.200
     0.033     2.006     0.200
     0.921     5.510     0.200
     0.630     4.017     0.200
     0.338     2.454     0.200
     1.017     5.863     0.200
     0.499     3.813     0.200
     0.136     1.675     0.200
     0.136     1.786     0.200
     0.795     5.060     0.200
     0.988     5.619     0.200
     0.082     1.075     0.200
     0.241     1.749     0.200
     0.262     1.875     0.200
     0.627     4.044     0.200
     0.524     3.848     0.200
     0.524     3.857     0.200
     1.147     6.417     0.200
     0.718     4.487     0.200
     0.884     5.176     0.200
     0.452     3.649     0.200
     1.143     6.143     0.200
     0.632     4.045     0.200
     0.215     1.895     0.200
     0.253     2.192     0.200
     0.423     3.297     0.200
     0.386     3.201     0.200
     0.613     3.703     0.200
     0.284     2.168     0.200
     0.509     3.362     0.200
     0.316     2.631     0.200
     0.336     2.818     0.200
     0.398     2.960     0.200
     0.693     3.978     0.200
     0.509     3.590     0.200
     0.393     2.753     0.200
     0.399     2.724     0.200
     0.597     3.746     0.200
     0.983     5.329     0.200
     0.493     3.143     0.200
     0.546     3.074     0.200
     0.580     3.399     0.200
     0.678     3.670     0.200
     0.617     3.440     0.200
     0.692     3.829     0.200
     0.027     1.890     0.200
     0.149     1.965     0.200
     0.223     1.779     0.200
     0.180     2.344     0.200
     0.176     1.818     0.200
     0.264     2.094     0.200
     0.254     1.698     0.200
     0.254     1.640     0.200
     0.285     2.115     0.200
     0.276     1.844     0.200
     0.236     2.121     0.200
     0.325     2.549     0.200
     0.347     2.802     0.200
     0.318     2.419     0.200
     0.318     2.529     0.200
     0.349     2.358     0.200
     0.404     2.699     0.200
     0.410     2.688     0.200
     0.392     2.818     0.200
     0.374     3.160     0.200
     0.413     3.254     0.200
     0.439     3.171     0.200
     0.421     3.103     0.200
     0.423     3.081     0.200
     0.440     3.569     0.200
     0.504     3.057     0.200
     0.457     3.127     0.200
     0.466     3.396     0.200
     0.499     3.778     0.200
     0.522     3.390     0.200
     0.542     2.990     0.200
     0.511     4.192     0.200
     0.511     3.812     0.200
     0.592     3.753     0.200
     0.611     3.793     0.200
     0.629     3.286     0.200
     0.626     3.655     0.200
     0.619     4.127     0.200
     0.638     4.120     0.200
     0.616     4.234     0.200
     0.632     4.443     0.200
     0.671     3.687     0.200
     0.689     3.718     0.200
     0.676     4.610     0.200
     0.706     3.902     0.200
     0.683     4.192     0.200
     0.750     4.281     0.200
     0.729     4.465     0.200
     0.785     4.548     0.200
     0.777     5.076     0.200
     0.772     5.164     0.200
     0.800     4.918     0.200
     0.804     5.062     0.200
     0.839     5.443     0.200
     0.799     5.234     0.200
     0.885     5.026     0.200
     0.829     5.565     0.200
     0.894     5.098     0.200
     0.935     5.548     0.200
     0.912     5.125     0.200
     0.893     5.620     0.200
     0.893     5.450     0.200
     0.969     5.769     0.200
     0.969     5.939     0.200
     0.928     5.472     0.200
     0.928     5.972     0.200
     0.996     5.647     0.200
     1.046     5.934     0.200
     1.027     6.534     0.200
     1.109     6.996     0.200
     1.170     6.577     0.200
     1.274     7.234     0.200
     1.314     7.320     0.200
     1.426     7.768     0.200
     1.416     8.497     0.200
     1.525     8.252     0.200
     1.779     8.920     0.200
     0.150     1.705     0.200
     0.226     1.843     0.200
     0.178     2.413     0.200
     0.174     1.908     0.200
     0.267     2.169     0.200
     0.267     2.160     0.200
     0.255     1.735     0.200
     0.255     1.735     0.200
     0.287     2.101     0.200
     0.277     1.889     0.200
     0.233     2.223     0.200
     0.328     2.573     0.200
     0.349     2.846     0.200
     0.316     2.492     0.200
     0.349     2.497     0.200
     0.394     2.908     0.200
     0.407     2.797     0.200
     0.413     2.775     0.200
     0.402     3.266     0.200
     0.373     3.293     0.200
     0.414     3.297     0.200
     0.440     3.649     0.200
     0.421     3.171     0.200
     0.419     3.193     0.200
     0.438     3.291     0.200
     0.507     3.132     0.200
     0.500     3.586     0.200
     0.455     3.200     0.200
     0.464     3.446     0.200
     0.484     3.828     0.200
     0.524     3.451     0.200
     0.544     3.047     0.200
     0.510     3.845     0.200
     0.510     3.864     0.200
     0.595     4.023     0.200
     0.606     3.883     0.200
     0.613     3.801     0.200
     0.632     3.273     0.200
     0.627     3.723     0.200
     0.618     4.005     0.200
     0.614     4.005     0.200
     0.638     4.192     0.200
     0.630     3.960     0.200
     0.672     3.710     0.200
     0.691     3.764     0.200
     0.707     3.961     0.200
     0.675     4.708     0.200
     0.681     4.248     0.200
     0.729     4.525     0.200
     0.786     4.675     0.200
     0.776     5.231     0.200
     0.769     5.270     0.200
     0.841     5.005     0.200
     0.803     5.121     0.200
     0.826     5.620     0.200
     0.936     5.287     0.200
     0.894     5.214     0.200
     0.912     5.203     0.200
     0.892     5.579     0.200
     0.972     5.625     0.200
     0.972     5.886     0.200
     0.927     5.635     0.200
     0.994     5.720     0.200
     1.023     5.950     0.200
     1.024     6.619     0.200
     1.074     5.727     0.200
     1.110     6.876     0.200
     1.151     6.218     0.200
     1.255     6.959     0.200
     1.268     7.200     0.200
     1.315     7.182     0.200
     1.325     6.904     0.200
     0.051     0.722     0.200
     0.053     0.661     0.200
     0.059     0.600     0.200
     0.145     1.211     0.200
     0.145     1.211     0.200
     0.143     1.555     0.200
     0.175     1.889     0.200
     0.265     2.196     0.200
     0.257     1.918     0.200
     0.246     1.830     0.200
     0.294     2.632     0.200
     0.312     2.063     0.200
     0.356     2.621     0.200
     0.333     2.940     0.200
     0.426     3.087     0.200
     0.426     3.087     0.200
     0.451     3.819     0.200
     0.451     3.849     0.200
     0.465     3.648     0.200
     0.474     3.097     0.200
     0.477     3.171     0.200
     0.477     3.301     0.200
     0.495     3.527     0.200
     0.489     3.767     0.200
     0.502     3.787     0.200
     0.531     4.192     0.200
     0.577     4.197     0.200
     0.577     4.147     0.200
     0.613     3.450     0.200
     0.612     4.050     0.200
     0.612     3.860     0.200
     0.619     3.864     0.200
     0.619     3.984     0.200
     0.607     4.572     0.200
     0.607     4.569     0.200
     0.636     3.617     0.200
     0.709     3.820     0.200
     0.693     5.178     0.200
     0.723     4.005     0.200
     0.723     4.015     0.200
     0.737     5.061     0.200
     0.744     4.345     0.200
     0.750     4.484     0.200
     0.762     4.079     0.200
     0.765     5.062     0.200
     0.785     4.627     0.200
     0.782     4.599     0.200
     0.791     4.300     0.200
     0.816     4.990     0.200
     0.873     5.038     0.200
     0.971     6.439     0.200
     1.189     7.316     0.200
     1.197     7.636     0.200
     1.229     7.115     0.200
     1.266     7.920     0.200
     1.299     8.406     0.200
     1.302     8.600     0.200
     1.343     7.664     0.200
     0.048     1.069     0.200
     0.049     0.942     0.200
     0.048     1.092     0.200
     0.132     1.083     0.200
     0.132     1.170     0.200
     0.152     1.830     0.200
     0.152     1.931     0.200
     0.177     2.012     0.200
     0.247     2.129     0.200
     0.247     1.904     0.200
     0.247     2.029     0.200
     0.310     2.154     0.200
     0.310     2.029     0.200
     0.338     2.309     0.200
     0.263     2.207     0.200
     0.338     3.075     0.200
     0.409     2.817     0.200
     0.409     2.989     0.200
     0.439     3.593     0.200
     0.456     3.619     0.200
     0.471     3.048     0.200
     0.471     3.181     0.200
     0.481     3.695     0.200
     0.478     3.495     0.200
     0.489     3.806     0.200
     0.468     3.473     0.200
     0.468     3.372     0.200
     0.566     4.256     0.200
     0.566     4.295     0.200
     0.604     3.964     0.200
     0.547     4.510     0.200
     0.596     3.345     0.200
     0.619     3.488     0.200
     0.618     3.844     0.200
     0.618     3.953     0.200
     0.697     4.486     0.200
     0.613     4.703     0.200
     0.613     4.685     0.200
     0.715     4.235     0.200
     0.715     3.977     0.200
     0.727     3.947     0.200
     0.735     5.108     0.200
     0.745     4.316     0.200
     0.745     4.066     0.200
     0.707     5.435     0.200
     0.773     4.592     0.200
     0.777     4.623     0.200
     0.766     4.989     0.200
     0.814     5.025     0.200
     0.781     4.375     0.200
     0.863     5.046     0.200
     0.973     6.431     0.200
     0.938     5.746     0.200
     1.197     7.324     0.200
     1.203     6.830     0.200
     1.231     7.256     0.200
     1.303     7.010     0.200
     1.347     8.050     0.200
     1.359     7.800     0.200
     0.041     0.834     0.200
     0.043     0.821     0.200
     0.060     0.406     0.200
     0.060     0.546     0.200
     0.144     1.160     0.200
     0.144     1.246     0.200
     0.154     1.592     0.200
     0.258     2.116     0.200
     0.184     1.924     0.200
     0.259     1.963     0.200
     0.303     2.122     0.200
     0.257     1.989     0.200
     0.420     3.031     0.200
     0.420     2.984     0.200
     0.343     3.021     0.200
     0.439     3.653     0.200
     0.465     3.068     0.200
     0.486     3.576     0.200
     0.486     3.365     0.200
     0.490     3.741     0.200
     0.479     3.533     0.200
     0.566     4.064     0.200
     0.601     3.901     0.200
     0.608     3.284     0.200
     0.536     4.300     0.200
     0.628     3.406     0.200
     0.610     3.912     0.200
     0.617     4.631     0.200
     0.618     4.598     0.200
     0.712     3.918     0.200
     0.738     4.472     0.200
     0.728     5.004     0.200
     0.755     4.036     0.200
     0.774     4.494     0.200
     0.695     5.475     0.200
     0.772     4.559     0.200
     0.757     4.941     0.200
     0.807     4.959     0.200
     0.793     4.094     0.200
     0.861     4.925     0.200
     0.935     5.409     0.200
     0.935     5.430     0.200
     1.185     7.222     0.200
     1.192     6.823     0.200
     1.222     7.406     0.200
     1.336     7.999     0.200
     1.884     9.503     0.200
     0.152     1.702     0.200
     0.062     0.503     0.200
     0.042     0.795     0.200
     0.044     0.672     0.200
     0.183     1.938     0.200
     0.253     2.001     0.200
     0.147     1.246     0.200
     0.147     1.277     0.200
     0.261     2.049     0.200
     0.342     2.981     0.200
     0.262     2.088     0.200
     0.303     2.077     0.200
     0.352     2.874     0.200
     0.532     4.295     0.200
     0.481     3.198     0.200
     0.424     2.948     0.200
     0.424     2.987     0.200
     0.466     3.098     0.200
     0.442     3.666     0.200
     0.456     3.674     0.200
     0.483     3.661     0.200
     0.489     3.477     0.200
     0.493     3.698     0.200
     0.568     4.299     0.200
     0.568     4.197     0.200
     0.610     3.980     0.200
     0.610     3.839     0.200
     0.611     3.234     0.200
     0.603     3.871     0.200
     0.632     3.424     0.200
     0.729     5.146     0.200
     0.700     4.267     0.200
     0.714     4.076     0.200
     0.714     4.131     0.200
     0.757     5.098     0.200
     0.795     4.217     0.200
     0.741     4.422     0.200
     0.759     4.179     0.200
     0.773     4.591     0.200
     0.932     5.475     0.200
     0.932     5.556     0.200
     0.777     4.804     0.200
     0.807     4.921     0.200
     0.864     5.305     0.200
     0.964     6.402     0.200
     1.184     7.326     0.200
     1.191     6.900     0.200
     1.221     6.989     0.200
     1.349     7.733     0.200
     1.880     9.532     0.200
     0.035     1.505     0.200
     0.056     1.208     0.200
     0.057     1.164     0.200
     0.117     1.224     0.200
     0.117     1.234     0.200
     0.156     2.074     0.200
     0.173     2.107     0.200
     0.232     2.074     0.200
     0.234     1.959     0.200
     0.275     2.251     0.200
     0.316     2.267     0.200
     0.324     2.421     0.200
     0.337     3.263     0.200
     0.394     3.025     0.200
     0.394     2.945     0.200
     0.433     3.833     0.200
     0.433     3.873     0.200
     0.456     4.089     0.200
     0.465     3.407     0.200
     0.454     3.237     0.200
     0.476     3.166     0.200
     0.482     3.760     0.200
     0.480     3.742     0.200
     0.562     4.031     0.200
     0.562     4.281     0.200
     0.580     3.356     0.200
     0.564     4.513     0.200
     0.604     3.987     0.200
     0.604     4.187     0.200
     0.604     3.566     0.200
     0.625     3.769     0.200
     0.625     3.910     0.200
     0.613     4.649     0.200
     0.613     4.667     0.200
     0.692     4.247     0.200
     0.715     4.080     0.200
     0.715     3.840     0.200
     0.730     4.428     0.200
     0.730     3.445     0.200
     0.730     4.055     0.200
     0.735     4.016     0.200
     0.741     5.266     0.200
     0.723     5.450     0.200
     0.767     4.499     0.200
     0.779     4.534     0.200
     0.774     5.078     0.200
     0.766     3.786     0.200
     0.819     4.948     0.200
     0.838     4.853     0.200
     0.861     4.994     0.200
     0.947     5.430     0.200
     0.947     5.473     0.200
     0.982     6.588     0.200
     1.115     7.022     0.200
     1.209     7.166     0.200
     1.214     7.266     0.200
     1.313     7.050     0.200
     1.363     7.918     0.200
     0.024     2.266     0.200
     0.108     1.271     0.200
     0.082     1.634     0.200
     0.144     1.951     0.200
     0.217     1.892     0.200
     0.240     2.175     0.200
     0.258     2.408     0.200
     0.312     3.017     0.200
     0.336     2.546     0.200
     0.308     2.981     0.200
     0.344     2.512     0.200
     0.401     3.020     0.200
     0.401     3.041     0.200
     0.436     3.096     0.200
     0.461     3.819     0.200
     0.461     3.959     0.200
     0.481     3.433     0.200
     0.486     3.994     0.200
     0.509     3.695     0.200
     0.510     3.966     0.200
     0.505     3.332     0.200
     0.583     3.326     0.200
     0.591     4.189     0.200
     0.591     4.179     0.200
     0.617     3.550     0.200
     0.583     4.314     0.200
     0.564     4.796     0.200
     0.634     4.062     0.200
     0.652     4.219     0.200
     0.720     4.281     0.200
     0.720     4.210     0.200
     0.739     3.969     0.200
     0.751     4.312     0.200
     0.744     3.895     0.200
     0.744     3.896     0.200
     0.761     4.134     0.200
     0.769     4.986     0.200
     0.801     4.987     0.200
     0.848     4.918     0.200
     0.923     5.723     0.200
     0.923     5.402     0.200
     1.236     7.054     0.200
     1.601     8.321     0.200
     0.010     1.725     0.200
     0.010     2.748     0.200
     0.085     1.227     0.200
     0.097     1.760     0.200
     0.137     2.035     0.200
     0.196     1.831     0.200
     0.222     2.135     0.200
     0.275     2.608     0.200
     0.304     3.118     0.200
     0.315     3.111     0.200
     0.357     2.610     0.200
     0.416     3.270     0.200
     0.467     3.474     0.200
     0.459     4.027     0.200
     0.506     3.776     0.200
     0.515     3.430     0.200
     0.579     4.502     0.200
     0.590     4.177     0.200
     0.587     4.859     0.200
     0.639     4.047     0.200
     0.665     4.179     0.200
     0.717     4.249     0.200
     0.932     5.387     0.200
     0.932     5.246     0.200
     1.255     6.848     0.200
     1.604     8.833     0.200
     3.731    19.302     0.200
     6.531    40.960     0.200
     0.147     1.445     0.200
     0.148     1.425     0.200
     0.201     2.092     0.200
     0.271     2.778     0.200
     0.288     2.733     0.200
     0.288     2.741     0.200
     0.290     2.163     0.200
     0.389     3.579     0.200
     0.390     3.524     0.200
     0.340     2.980     0.200
     0.391     3.093     0.200
     0.403     3.118     0.200
     0.451     3.134     0.200
     0.513     3.865     0.200
     0.564     3.885     0.200
     0.569     3.685     0.200
     0.569     4.037     0.200
     0.607     4.155     0.200
     0.644     4.762     0.200
     0.644     4.772     0.200
     0.614     3.877     0.200
     0.623     4.150     0.200
     0.623     4.403     0.200
     0.623     4.372     0.200
     0.655     3.382     0.200
     0.701     4.655     0.200
     0.735     4.119     0.200
     0.735     4.100     0.200
     0.755     3.934     0.200
     0.753     4.707     0.200
     0.764     3.992     0.200
     0.765     4.545     0.200
     0.774     5.182     0.200
     0.869     5.221     0.200
     0.894     6.005     0.200
     0.897     5.127     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.720    16.281     0.200
     0.760    15.386     0.200
     0.733    15.998     0.200
     0.713    15.203     0.200
     0.716    15.838     0.200
     0.765    16.999     0.200
     8.379   117.717     0.200
     0.755    16.293     0.200
     0.734    15.337     0.200
     0.734    15.974     0.200
     0.734    16.415     0.200
     0.759    15.807     0.200
     0.987    17.978     0.200
     0.987    18.713     0.200
     1.090    19.934     0.200
     1.126    17.386     0.200
     2.114    35.973     0.200
     2.125    36.408     0.200
     2.145    36.958     0.200
     2.897    46.002     0.200
     2.977    47.355     0.200
     3.525    53.705     0.200
     9.092   125.898     0.200
     0.957    18.745     0.200
     0.964    18.227     0.200
     1.257    20.567     0.200
     2.143    37.124     0.200
     2.180    37.865     0.200
     2.594    42.275     0.200
     3.024    48.980     0.200
     3.534    56.772     0.200
     4.674    71.547     0.200
     0.671    14.315     0.200
     0.999    18.373     0.200
     0.999    19.014     0.200
     1.121    17.672     0.200
     1.121    19.594     0.200
     2.986    47.173     0.200
     5.335    77.870     0.200
     6.419    94.508     0.200
     7.627   108.280     0.200
     7.678   107.496     0.200
     7.666   109.452     0.200
     7.825   111.487     0.200
     8.004   114.940     0.200
     9.084   127.612     0.200
     0.696    14.045     0.200
     1.206    21.365     0.200
     1.505    25.118     0.200
     1.505    24.317     0.200
     2.438    36.514     0.200
     2.652    42.367     0.200
     3.321    49.099     0.200
     3.551    52.322     0.200
     3.962    58.061     0.200
     4.180    59.722     0.200
     7.503   101.144     0.200
     9.414   129.044     0.200
    19.368   255.417     0.200
     0.455    11.826     0.200
     0.701    14.194     0.200
     1.344    23.978     0.200
     1.514    25.149     0.200
     2.100    32.997     0.200
     2.174    35.293     0.200
     6.602    92.234     0.200
    10.021   135.724     0.200
    15.798   213.619     0.200
    17.741   236.968     0.200
     0.475    11.305     0.200
     0.742    16.417     0.200
     1.197    20.128     0.200
     1.491    24.614     0.200
     2.884    47.400     0.200
     2.939    48.375     0.200
     3.618    57.177     0.200
     4.126    62.635     0.200
     4.482    67.580     0.200
     6.932   100.139     0.200
     0.729    15.763     0.200
     1.361    24.339     0.200
     2.207    36.000     0.200
     0.475    10.730     0.200
     0.683    14.107     0.200
     0.743    15.509     0.200
     1.492    25.139     0.200
     2.190    34.395     0.200
     0.473    10.935     0.200
     0.679    13.832     0.200
     0.737    15.574     0.200
     1.491    24.653     0.200
     1.555    27.337     0.200
     0.463    10.434     0.200
     0.463    11.314     0.200
     0.665    13.728     0.200
     0.697    14.014     0.200
     0.744    15.686     0.200
     1.170    20.554     0.200
     1.210    20.406     0.200
     1.508    24.875     0.200
     1.508    24.717     0.200
     1.711    28.094     0.200
     3.575    58.024     0.200
     0.461    11.058     0.200
     0.461    12.009     0.200
     0.737    16.040     0.200
     1.506    25.473     0.200
     1.569    27.451     0.200
     0.645    13.438     0.200
     0.732    13.415     0.200
     0.732    13.853     0.200
     2.881    47.547     0.200
     3.091    49.579     0.200
     3.613    57.109     0.200
     3.853    59.412     0.200
     4.489    66.865     0.200
     5.542    82.000     0.200
     6.569    93.619     0.200
     6.622    95.693     0.200
     6.931    99.687     0.200
     7.121   101.713     0.200
     7.602   107.586     0.200
     7.912   110.943     0.200
     7.915   112.401     0.200
     7.933   112.627     0.200
     8.114   112.973     0.200
     8.592   122.101     0.200
     8.653   122.146     0.200
     9.132   130.418     0.200
     9.199   131.113     0.200
     9.629   135.807     0.200
     9.963   141.500     0.200
    10.742   149.033     0.200
    10.823   152.271     0.200
    11.447   156.684     0.200
    11.565   158.675     0.200
    11.632   159.902     0.200
    11.743   161.673     0.200
    11.837   161.765     0.200
    11.932   165.458     0.200
    12.473   171.356     0.200
    12.482   174.377     0.200
    12.504   172.725     0.200
    12.661   172.195     0.200
    12.768   172.471     0.200
    13.062   181.450     0.200
    13.406   178.221     0.200
    13.497   184.150     0.200
    13.533   183.247     0.200
    14.287   193.149     0.200
    14.395   193.801     0.200
    14.623   197.919     0.200
    14.835   200.207     0.200
    15.070   202.578     0.200
    16.116   216.392     0.200
    16.567   222.290     0.200
    16.872   225.168     0.200
    18.499   244.942     0.200
     0.626    12.496     0.200
     0.648    12.914     0.200
     0.674    13.881     0.200
     0.739    13.346     0.200
     0.739    13.614     0.200
     1.147    19.589     0.200
     1.204    21.124     0.200
     1.490    24.960     0.200
     8.278   113.355     0.200
     0.711    14.645     0.200
    15.880   210.717     0.200
     0.405     9.632     0.200
     0.744    13.394     0.200
     1.269    21.733     0.200
     0.586    15.175     0.200
     0.788    16.227     0.200
     0.935    17.474     0.200
     8.480   117.392     0.200
     0.724    16.433     0.200
     0.728    16.601     0.200
     0.732    14.964     0.200
     1.293    22.008     0.200
     8.416   117.341     0.200
     0.668    13.873     0.200
     0.676    14.279     0.200
     0.795    14.540     0.200
     1.253    20.945     0.200
     1.403    23.122     0.200
     1.514    24.546     0.200
     1.649    27.613     0.200
     2.846    44.613     0.200
     0.708    14.415     0.200
     0.773    14.394     0.200
     1.332    22.504     0.200
     7.608   106.071     0.200
     7.633   108.080     0.200
     9.438   129.973     0.200
     9.819   135.997     0.200
    10.662   144.991     0.200
     0.755    14.726     0.200
     0.708    15.333     0.200
     0.776    15.706     0.200
     1.333    23.944     0.200
     2.734    42.332     0.200
     7.788   108.276     0.200
    10.408   144.267     0.200
     0.825    17.069     0.200
     0.876    18.230     0.200
     0.977    18.966     0.200
     0.984    18.629     0.200
     1.200    21.642     0.200
     1.200    20.466     0.200
     3.541    58.175     0.200
    10.735   146.350     0.200
     0.716    14.196     0.200
     0.707    14.794     0.200
     0.707    15.364     0.200
     0.744    15.267     0.200
     1.342    23.211     0.200
     1.580    27.112     0.200
     3.018    50.043     0.200
     5.689    81.153     0.200
     9.968   133.639     0.200
     0.713    14.485     0.200
     0.702    14.916     0.200
     0.751    14.950     0.200
     1.302    21.368     0.200
     1.347    23.591     0.200
     1.593    26.985     0.200
     3.029    47.552     0.200
     3.811    56.061     0.200
     5.002    73.775     0.200
     5.674    82.161     0.200
     6.559    92.086     0.200
     9.960   137.506     0.200
    10.431   146.551     0.200
    10.431   146.551     0.200
     0.573    12.250     0.200
     0.601    12.393     0.200
     0.743    15.112     0.200
     0.762    15.472     0.200
     0.960    17.795     0.200
     0.458    11.991     0.200
     0.758    15.416     0.200
     0.998    17.177     0.200
     1.164    20.802     0.200
     1.624    28.733     0.200
     2.463    41.857     0.200
     2.463    41.857     0.200
     5.433    79.056     0.200
     6.092    87.754     0.200
     6.937    99.271     0.200
     0.606    15.124     0.200
     0.799    16.103     0.200
     0.862    17.197     0.200
     1.011    18.347     0.200
     1.057    19.467     0.200
     1.091    20.442     0.200
     1.742    29.244     0.200
     2.282    39.589     0.200
     7.095   100.742     0.200
     0.418     9.498     0.200
     1.209    20.975     0.200
     1.649    27.180     0.200
     0.976    17.743     0.200
     1.118    19.463     0.200
     1.118    19.468     0.200
     1.661    28.508     0.200
     5.008    73.381     0.200
     5.717    83.341     0.200
     6.519    94.068     0.200
     9.362   131.687     0.200
     9.946   139.688     0.200
    12.052   165.818     0.200
     0.741    14.981     0.200
     0.741    16.653     0.200
     0.741    17.981     0.200
     0.829    17.001     0.200
     0.399     9.811     0.200
     0.759    14.998     0.200
     1.261    22.159     0.200
     1.356    24.198     0.200
     4.959    72.013     0.200
     6.261    91.885     0.200
     0.734    16.471     0.200
     0.841    16.798     0.200
     3.818    58.184     0.200
     0.734    17.053     0.200
     0.840    16.502     0.200
     0.856    16.612     0.200
     1.375    23.793     0.200
     1.643    27.301     0.200
     3.818    56.886     0.200
     4.962    73.478     0.200
     6.546    93.337     0.200
     0.719    15.795     0.200
     1.326    23.688     0.200
     2.719    41.385     0.200
     2.262    39.779     0.200
     2.403    40.663     0.200
     2.522    42.222     0.200
     0.611    14.325     0.200
     0.796    16.379     0.200
     0.876    18.384     0.200
     1.232    21.085     0.200
     1.386    24.738     0.200
     1.614    27.797     0.200
     1.646    29.413     0.200
     2.076    35.356     0.200
     2.133    36.110     0.200
     3.075    49.582     0.200
     4.953    75.547     0.200
     5.602    83.488     0.200
     6.360    92.487     0.200
     6.577    92.107     0.200
     7.890   111.224     0.200
    11.144   156.445     0.200
    13.717   189.901     0.200
    15.123   200.615     0.200
    17.481   234.650     0.200
    17.512   234.096     0.200
     0.880    18.142     0.200
     1.473    24.828     0.200
     4.005    60.679     0.200
     3.924    61.624     0.200
     5.108    73.906     0.200
     5.559    78.358     0.200
     6.339    88.220     0.200
     1.246    23.020     0.200
     1.341    23.654     0.200
     1.758    30.955     0.200
     2.239    39.575     0.200
     2.911    49.312     0.200
    16.322   219.770     0.200
     0.932    17.551     0.200
     0.932    16.176     0.200
     1.406    23.999     0.200
     2.584    40.826     0.200
     2.619    40.783     0.200
     0.754    15.701     0.200
     0.754    15.217     0.200
     0.903    17.177     0.200
     0.903    16.997     0.200
     1.376    23.338     0.200
     1.449    24.345     0.200
     1.795    29.146     0.200
     2.512    38.244     0.200
     2.762    43.632     0.200
     2.921    44.980     0.200
     3.078    45.528     0.200
     0.882    15.850     0.200
     1.164    15.119     0.200
     1.557    26.060     0.200
     2.394    38.059     0.200
     2.466    37.094     0.200
     0.933    17.460     0.200
     1.123    19.880     0.200
     1.748    27.357     0.200
     2.211    32.698     0.200
     2.261    34.348     0.200
     2.463    40.961     0.200
     2.808    43.862     0.200
     2.842    42.440     0.200
     0.497    11.856     0.200
     0.539    11.746     0.200
     0.711    14.310     0.200
     0.871    14.988     0.200
     1.433    23.525     0.200
     2.299    36.700     0.200
     2.757    44.373     0.200
     5.047    73.753     0.200
     5.470    78.990     0.200
     6.422    87.881     0.200
     0.910    16.055     0.200
     0.910    16.483     0.200
     1.357    22.156     0.200
     1.482    24.832     0.200
     1.573    26.376     0.200
     1.573    25.687     0.200
     1.573    25.491     0.200
     2.557    37.933     0.200
     0.938    16.589     0.200
     0.975    16.116     0.200
     0.975    17.381     0.200
     1.255    22.200     0.200
     1.392    23.492     0.200
     1.526    24.849     0.200
     1.797    28.506     0.200
     2.065    31.940     0.200
     3.775    54.347     0.200
     4.431    64.094     0.200
     5.026    71.221     0.200
     6.902    93.576     0.200
     0.927    16.530     0.200
     1.220    21.947     0.200
     1.367    23.223     0.200
     0.498    13.183     0.200
     0.816    16.648     0.200
     1.101    19.148     0.200
     1.188    20.885     0.200
     1.556    26.953     0.200
     1.653    28.174     0.200
     1.684    28.330     0.200
     2.582    45.150     0.200
     8.837   125.358     0.200
     0.900    17.038     0.200
     1.168    20.093     0.200
     1.315    22.827     0.200
     1.315    22.658     0.200
     1.315    22.497     0.200
     1.535    25.151     0.200
     1.596    26.568     0.200
     1.717    29.309     0.200
     2.448    37.809     0.200
     6.627    93.324     0.200
     0.805    16.638     0.200
     1.068    18.578     0.200
     1.139    20.368     0.200
     1.387    23.972     0.200
     1.544    26.201     0.200
     1.707    28.627     0.200
     1.893    31.605     0.200
     2.168    33.745     0.200
     2.250    35.018     0.200
     0.930    16.909     0.200
     1.401    23.960     0.200
     1.455    24.848     0.200
     1.671    27.469     0.200
     1.718    28.802     0.200
     0.857    16.557     0.200
     1.378    25.158     0.200
     1.395    23.343     0.200
     1.395    23.170     0.200
     1.551    25.897     0.200
     0.557    11.884     0.200
     1.043    18.049     0.200
     1.043    19.431     0.200
     1.094    19.481     0.200
     1.338    23.203     0.200
     1.650    26.780     0.200
     1.935    32.316     0.200
     1.956    31.476     0.200
     2.242    35.336     0.200
     2.402    36.816     0.200
     0.783    15.980     0.200
     0.806    15.949     0.200
     0.911    16.685     0.200
     0.911    17.256     0.200
     1.065    18.687     0.200
     1.136    20.288     0.200
     1.136    19.698     0.200
     1.384    23.181     0.200
     1.542    25.879     0.200
     1.707    28.237     0.200
     2.157    34.135     0.200
     2.348    36.906     0.200
     2.354    38.261     0.200
     2.604    38.578     0.200
     2.802    46.009     0.200
     3.155    51.482     0.200
     5.300    78.736     0.200
     6.753    95.818     0.200
     7.620   110.052     0.200
     0.861    16.700     0.200
     1.357    22.593     0.200
     1.416    25.672     0.200
     1.610    26.783     0.200
     2.179    35.227     0.200
     3.024    49.114     0.200
     5.458    78.394     0.200
     7.182   101.392     0.200
     7.568   107.019     0.200
     7.750   108.881     0.200
     0.905    17.046     0.200
     0.906    16.805     0.200
     1.026    18.808     0.200
     1.089    19.164     0.200
     1.089    18.992     0.200
     1.338    23.373     0.200
     1.492    25.753     0.200
     1.521    25.944     0.200
     1.720    28.580     0.200
     1.843    31.054     0.200
     2.113    33.574     0.200
     2.141    33.446     0.200
     2.331    38.433     0.200
     2.663    41.532     0.200
     0.819    16.970     0.200
     0.819    16.462     0.200
     1.054    18.815     0.200
     1.134    20.687     0.200
     1.134    20.394     0.200
     1.134    20.276     0.200
     1.378    24.630     0.200
     1.529    26.488     0.200
     1.696    29.356     0.200
     1.888    32.436     0.200
     2.149    35.111     0.200
     2.241    36.059     0.200
     2.363    40.971     0.200
     0.802    15.941     0.200
     0.802    18.039     0.200
     0.945    17.167     0.200
     1.399    23.727     0.200
     2.100    34.009     0.200
     2.285    37.285     0.200
     0.865    17.014     0.200
     0.962    17.090     0.200
     1.372    23.692     0.200
     1.346    23.356     0.200
     1.522    25.196     0.200
    10.321   143.787     0.200
     0.394     9.305     0.200
     0.587    12.392     0.200
     0.721    15.314     0.200
     1.017    17.644     0.200
     1.017    18.013     0.200
     1.337    22.794     0.200
     1.618    26.381     0.200
     1.954    31.555     0.200
     1.921    30.065     0.200
     2.239    35.038     0.200
     2.380    37.208     0.200
     3.284    53.783     0.200
     3.869    55.531     0.200
     4.643    69.166     0.200
     5.422    77.379     0.200
    10.217   142.625     0.200
     0.698    14.096     0.200
     0.698    15.426     0.200
     1.361    23.277     0.200
     1.618    26.721     0.200
     1.618    26.235     0.200
     5.698    81.610     0.200
     0.744    15.259     0.200
     0.817    16.579     0.200
     1.089    19.034     0.200
     1.175    20.515     0.200
     1.175    20.658     0.200
     1.268    23.366     0.200
     1.419    23.531     0.200
     1.687    28.265     0.200
     2.574    39.449     0.200
     3.194    53.541     0.200
     4.212    59.625     0.200
    10.873   151.411     0.200
     0.811    16.435     0.200
     0.811    16.544     0.200
     0.802    17.902     0.200
     1.046    18.387     0.200
     1.116    20.358     0.200
     1.116    20.775     0.200
     1.136    21.111     0.200
     1.363    24.059     0.200
     1.529    27.083     0.200
     1.709    29.107     0.200
     2.152    34.207     0.200
     2.331    36.290     0.200
     2.517    41.518     0.200
     3.139    49.330     0.200
     4.650    72.702     0.200
     8.099   111.162     0.200
     9.633   135.345     0.200
    10.972   146.898     0.200
     0.765    16.689     0.200
     0.940    16.811     0.200
     1.420    24.267     0.200
     0.586    12.634     0.200
     0.744    16.106     0.200
     1.012    18.751     0.200
     1.317    23.581     0.200
     1.367    23.833     0.200
     1.622    26.487     0.200
     1.750    30.613     0.200
     1.930    31.979     0.200
     1.935    31.298     0.200
     1.935    32.309     0.200
     2.219    35.327     0.200
     3.650    54.362     0.200
     0.491    13.140     0.200
     0.698    14.762     0.200
     0.741    14.949     0.200
     0.840    17.193     0.200
     1.073    19.125     0.200
     1.176    20.935     0.200
     1.176    21.139     0.200
     1.410    24.474     0.200
     1.527    26.115     0.200
     1.570    24.829     0.200
     1.580    27.375     0.200
     1.664    28.092     0.200
     1.929    31.530     0.200
     2.153    34.358     0.200
     2.175    34.625     0.200
     2.580    42.835     0.200
     3.202    51.132     0.200
     0.764    16.941     0.200
     1.071    20.558     0.200
     1.081    20.990     0.200
     1.081    20.212     0.200
     1.411    25.367     0.200
     1.961    35.025     0.200
     2.800    46.416     0.200
     4.607    68.611     0.200
     0.654    15.720     0.200
     0.754    16.076     0.200
     0.754    15.736     0.200
     0.766    15.861     0.200
     0.965    18.021     0.200
     0.965    18.230     0.200
     1.029    19.064     0.200
     1.029    19.422     0.200
     1.304    23.408     0.200
     1.794    29.751     0.200
     2.251    36.703     0.200
     3.038    47.748     0.200
     0.448     9.959     0.200
     0.715    15.323     0.200
     1.073    19.010     0.200
     1.367    22.854     0.200
     1.675    27.147     0.200
     1.811    29.674     0.200
     1.950    30.752     0.200
     2.272    35.333     0.200
     2.434    36.616     0.200
     8.726   119.328     0.200
     0.766    15.403     0.200
     0.933    16.825     0.200
     1.706    27.530     0.200
     3.063    51.248     0.200
     3.331    51.297     0.200
     4.645    70.026     0.200
     0.626    13.824     0.200
     0.760    15.915     0.200
     0.779    15.364     0.200
     0.854    16.117     0.200
     1.397    23.405     0.200
     1.449    24.201     0.200
     1.664    26.593     0.200
     1.714    27.304     0.200
     2.865    46.950     0.200
     3.123    50.133     0.200
     3.336    53.123     0.200
     4.287    64.656     0.200
     4.632    69.101     0.200
     4.795    70.728     0.200
     6.131    89.808     0.200
    16.271   217.610     0.200
     0.746    14.938     0.200
     0.801    16.410     0.200
     0.838    17.161     0.200
     0.838    16.530     0.200
     1.025    18.373     0.200
     1.116    19.764     0.200
     1.116    20.415     0.200
     1.116    19.219     0.200
     1.352    23.700     0.200
     1.580    27.511     0.200
     1.684    28.272     0.200
     1.869    31.621     0.200
     0.815    16.708     0.200
     1.089    19.273     0.200
     1.173    20.483     0.200
     1.550    26.821     0.200
     1.569    27.067     0.200
     1.641    27.634     0.200
     1.689    28.184     0.200
     0.775    15.720     0.200
     0.921    18.052     0.200
     1.398    24.992     0.200
     1.445    25.437     0.200
     1.709    29.755     0.200
     3.070    51.877     0.200
     3.814    56.293     0.200
     4.909    73.253     0.200
     4.909    70.452     0.200
     5.548    82.586     0.200
     5.548    84.610     0.200
     9.254   129.962     0.200
     0.663    15.339     0.200
     0.723    14.303     0.200
     0.883    16.335     0.200
     0.883    15.437     0.200
     0.896    16.289     0.200
     1.353    22.838     0.200
     1.441    24.334     0.200
     1.592    26.145     0.200
     2.207    34.864     0.200
     0.588    13.257     0.200
     0.752    14.652     0.200
     0.761    15.385     0.200
     0.955    16.464     0.200
     1.435    23.923     0.200
     2.144    33.134     0.200
     2.318    35.365     0.200
    10.422   142.177     0.200
     0.682    13.904     0.200
     0.682    15.740     0.200
     0.843    17.437     0.200
     0.903    16.717     0.200
     1.381    23.342     0.200
     1.444    24.283     0.200
     1.619    27.099     0.200
     0.742    15.020     0.200
     0.801    15.805     0.200
     0.931    17.427     0.200
     1.388    24.761     0.200
     1.466    25.518     0.200
     1.735    28.114     0.200
     6.497    91.264     0.200
    12.900   174.149     0.200
    16.290   216.477     0.200
     0.450    11.271     0.200
     0.792    15.650     0.200
     0.884    16.210     0.200
     0.884    16.636     0.200
     1.125    19.552     0.200
     1.686    28.762     0.200
     4.220    60.125     0.200
     4.631    68.299     0.200
     8.026   110.988     0.200
     0.855    17.015     0.200
     1.405    24.611     0.200
     2.166    34.759     0.200
     2.663    42.102     0.200
     3.046    47.496     0.200
     0.534    13.818     0.200
     0.834    17.209     0.200
     0.882    17.463     0.200
     1.035    18.726     0.200
     1.124    20.516     0.200
     1.124    20.864     0.200
     1.685    28.881     0.200
     2.369    40.735     0.200
     2.592    40.142     0.200
     5.583    80.396     0.200
     0.626    14.664     0.200
     0.679    14.495     0.200
     0.679    15.628     0.200
     0.982    16.268     0.200
     0.982    17.143     0.200
     1.100    19.653     0.200
     1.402    22.846     0.200
     3.148    52.066     0.200
     3.196    50.923     0.200
     3.917    57.666     0.200
     0.738    16.574     0.200
     1.026    18.218     0.200
     1.026    19.132     0.200
     1.081    19.554     0.200
     1.327    23.265     0.200
     1.634    27.211     0.200
     8.682   118.979     0.200
     0.741    15.892     0.200
     1.318    22.418     0.200
     0.748    16.089     0.200
     1.011    17.130     0.200
     1.313    23.106     0.200
     1.622    27.575     0.200
     1.926    31.874     0.200
     2.216    35.452     0.200
     3.847    56.956     0.200
     0.663    14.027     0.200
     0.663    14.949     0.200
     0.661    14.004     0.200
     0.975    17.580     0.200
     2.946    47.903     0.200
     3.231    51.596     0.200
     4.645    69.768     0.200
     5.447    81.629     0.200
     6.288    92.166     0.200
     0.700    16.317     0.200
     0.773    15.892     0.200
     1.384    24.368     0.200
     1.427    24.394     0.200
     1.631    27.342     0.200
     2.177    35.936     0.200
     3.040    47.745     0.200
     4.628    70.092     0.200
     0.639    13.666     0.200
     0.978    16.751     0.200
     3.230    51.368     0.200
     4.387    66.931     0.200
     8.309   116.279     0.200
     0.522    13.538     0.200
     0.606    13.575     0.200
     0.746    15.698     0.200
     0.746    16.259     0.200
     0.780    15.818     0.200
     0.936    17.206     0.200
     0.936    17.447     0.200
     1.070    19.222     0.200
     1.070    20.640     0.200
     1.084    20.168     0.200
     2.476    41.016     0.200
     0.873    15.520     0.200
     2.442    38.146     0.200
     6.621    92.672     0.200
     0.469    11.994     0.200
     0.809    16.702     0.200
     0.809    16.155     0.200
     0.809    16.483     0.200
     0.906    16.779     0.200
     1.046    18.380     0.200
     1.115    20.157     0.200
     1.115    19.661     0.200
     1.134    20.993     0.200
     1.620    28.419     0.200
     2.331    39.621     0.200
     2.345    40.195     0.200
     2.781    45.250     0.200
     3.743    59.992     0.200
     3.917    61.301     0.200
     4.651    71.028     0.200
     6.531    94.412     0.200
     6.558    96.111     0.200
     8.044   115.252     0.200
     0.725    15.269     0.200
     0.805    17.028     0.200
     0.805    16.028     0.200
     0.805    16.258     0.200
     0.910    16.880     0.200
     2.341    39.004     0.200
     2.669    41.863     0.200
     0.704    16.562     0.200
     1.131    21.027     0.200
     2.987    48.219     0.200
     3.038    46.911     0.200
     3.239    49.936     0.200
     3.847    60.626     0.200
     4.254    64.655     0.200
     4.595    69.765     0.200
     5.483    81.067     0.200
     6.383    92.675     0.200
     0.510    13.358     0.200
     0.594    13.713     0.200
     0.741    15.919     0.200
     0.786    16.090     0.200
     0.786    15.981     0.200
     1.080    19.653     0.200
     1.080    19.981     0.200
     1.095    20.320     0.200
     1.362    24.033     0.200
     2.290    39.770     0.200
     2.307    39.809     0.200
     2.425    41.213     0.200
     2.654    41.487     0.200
     2.751    45.030     0.200
     3.098    48.288     0.200
     3.706    56.528     0.200
     3.871    58.216     0.200
     5.277    75.213     0.200
     5.629    81.239     0.200
     7.859   109.216     0.200
     7.880   109.176     0.200
     7.898   111.194     0.200
     8.127   112.376     0.200
     8.910   124.379     0.200
     9.148   131.289     0.200
    11.983   162.683     0.200
    14.690   196.402     0.200
     0.568    15.356     0.200
     0.910    18.545     0.200
     1.091    20.030     0.200
     1.543    27.621     0.200
     0.628    13.990     0.200
     0.742    15.247     0.200
     0.809    15.319     0.200
     0.896    16.063     0.200
     0.896    16.770     0.200
     2.826    44.888     0.200
     4.247    63.634     0.200
     4.441    67.286     0.200
     4.617    71.181     0.200
     5.454    79.412     0.200
     5.454    78.787     0.200
     6.090    88.318     0.200
     6.368    92.524     0.200
     6.732    96.679     0.200
     6.750    96.840     0.200
     7.165   101.828     0.200
     7.240   103.271     0.200
     7.475   106.419     0.200
     7.857   111.242     0.200
     8.121   114.400     0.200
     8.180   115.152     0.200
     8.299   118.433     0.200
     8.449   115.827     0.200
     8.479   119.274     0.200
     8.850   121.554     0.200
     9.718   137.134     0.200
     9.806   140.128     0.200
    10.505   148.029     0.200
    10.652   147.063     0.200
    11.316   158.231     0.200
    11.637   160.558     0.200
    11.666   161.728     0.200
    11.755   159.453     0.200
    11.932   166.296     0.200
    12.124   168.946     0.200
    12.318   170.263     0.200
    12.354   169.854     0.200
    12.500   170.872     0.200
    12.920   176.786     0.200
    13.732   186.251     0.200
    18.287   244.116     0.200
     0.553    13.541     0.200
     0.553    13.721     0.200
     0.755    16.262     0.200
     1.041    18.408     0.200
     0.764    15.618     0.200
     0.764    16.919     0.200
     0.764    17.079     0.200
     0.955    17.853     0.200
     1.030    19.217     0.200
     3.043    49.296     0.200
     0.623    15.229     0.200
     0.749    15.137     0.200
     0.767    16.874     0.200
     0.767    15.944     0.200
     0.949    18.105     0.200
     0.949    17.492     0.200
     1.035    18.210     0.200
     1.058    19.271     0.200
     1.067    19.923     0.200
     1.811    31.631     0.200
     2.397    41.303     0.200
     3.070    51.430     0.200
     0.738    15.874     0.200
     0.812    16.584     0.200
     1.103    20.147     0.200
     1.103    20.335     0.200
     1.129    21.159     0.200
     1.340    24.148     0.200
     2.341    39.633     0.200
     2.506    40.682     0.200
     0.720    15.508     0.200
     0.796    16.108     0.200
     0.919    17.890     0.200
     1.053    18.833     0.200
     1.113    20.263     0.200
     1.123    21.098     0.200
     0.487    11.426     0.200
     0.487    13.196     0.200
     0.791    16.175     0.200
     0.924    17.241     0.200
     1.106    19.922     0.200
     1.115    20.844     0.200
     1.337    24.434     0.200
     1.730    28.514     0.200
     2.450    41.899     0.200
     3.910    61.307     0.200
     7.748   110.338     0.200
     8.893   124.521     0.200
     0.537    12.454     0.200
     0.622    14.612     0.200
     0.772    15.450     0.200
     0.772    16.079     0.200
     0.772    15.860     0.200
     1.057    19.526     0.200
     1.386    25.226     0.200
     0.839    16.698     0.200
     0.839    16.926     0.200
     1.401    23.404     0.200
     1.473    25.568     0.200
     1.683    29.281     0.200
     1.909    32.426     0.200
     2.104    34.623     0.200
     8.421   121.179     0.200
     0.624    13.908     0.200
     0.799    16.393     0.200
     0.799    17.253     0.200
     0.841    17.016     0.200
     0.841    16.747     0.200
     1.399    23.654     0.200
     2.285    35.959     0.200
     8.419   119.034     0.200
     0.714    14.957     0.200
     0.780    15.748     0.200
     1.109    20.442     0.200
     4.272    61.187     0.200
     0.722    15.282     0.200
     0.761    15.637     0.200
     1.081    20.160     0.200
     1.086    19.856     0.200
     1.357    24.025     0.200
     0.711    14.710     0.200
     0.755    15.299     0.200
     1.010    18.537     0.200
     0.997    18.419     0.200
     1.019    18.773     0.200
     1.019    18.888     0.200
     1.051    18.044     0.200
     1.429    24.947     0.200
     1.597    27.475     0.200
     3.011    49.240     0.200
     0.904    17.328     0.200
     1.093    19.577     0.200
     1.182    20.701     0.200
     1.182    21.002     0.200
     1.174    20.051     0.200
     1.261    21.294     0.200
     1.578    27.456     0.200
    10.868   149.442     0.200
    11.967   167.693     0.200
    12.059   166.144     0.200
    13.489   182.173     0.200
    15.954   211.039     0.200
     1.085    18.903     0.200
     1.177    19.635     0.200
     1.168    21.724     0.200
     1.168    20.527     0.200
     1.168    20.254     0.200
     2.376    40.630     0.200
     0.676    15.515     0.200
     0.818    16.764     0.200
     1.094    19.017     0.200
     6.727    91.805     0.200
     0.496    13.878     0.200
     0.782    16.047     0.200
     0.933    16.931     0.200
     1.054    17.960     0.200
     1.100    19.397     0.200
     1.342    22.779     0.200
     1.612    27.731     0.200
     2.442    40.761     0.200
     2.492    40.452     0.200
     2.772    44.490     0.200
     3.889    56.365     0.200
     4.274    64.321     0.200
     4.674    68.758     0.200
     5.633    78.194     0.200
     6.544    91.957     0.200
     6.787    94.647     0.200
     8.066   112.758     0.200
     8.903   124.182     0.200
     0.753    15.097     0.200
     0.794    15.525     0.200
     0.923    16.496     0.200
     1.414    24.453     0.200
     0.659    13.649     0.200
     0.653    13.920     0.200
     0.983    16.934     0.200
     0.963    17.895     0.200
     7.200    97.323     0.200
     0.573    12.920     0.200
     0.573    14.439     0.200
     0.981    18.082     0.200
     0.981    17.800     0.200
     1.044    18.753     0.200
     1.038    19.053     0.200
     1.038    18.096     0.200
     1.030    19.295     0.200
     2.226    38.689     0.200
     2.243    38.422     0.200
     0.731    15.775     0.200
     1.008    18.202     0.200
     1.008    19.313     0.200
     1.612    27.111     0.200
     1.921    31.694     0.200
     1.945    31.446     0.200
     2.751    41.405     0.200
     3.286    55.359     0.200
     3.335    55.059     0.200
     3.665    56.244     0.200
     4.428    69.034     0.200
     4.556    70.388     0.200
     4.632    70.719     0.200
     5.411    78.855     0.200
     6.209    87.333     0.200
     6.242    91.413     0.200
     6.281    91.245     0.200
     6.330    89.217     0.200
     6.842   100.550     0.200
     6.860   101.040     0.200
     7.063   103.390     0.200
     7.475   105.957     0.200
     7.953   113.435     0.200
     8.076   112.465     0.200
     8.662   121.625     0.200
    10.210   140.835     0.200
     0.648    14.420     0.200
     0.693    15.948     0.200
     1.085    20.853     0.200
     4.180    63.992     0.200
     5.435    81.049     0.200
     6.384    92.825     0.200
     7.444   107.206     0.200
     0.767    16.822     0.200
     0.775    16.379     0.200
     0.780    16.058     0.200
     0.785    16.394     0.200
     3.848    56.968     0.200
     3.848    60.929     0.200
     4.279    66.258     0.200
     4.463    68.938     0.200
     4.650    72.223     0.200
     5.484    82.287     0.200
     5.558    83.893     0.200
     6.046    88.242     0.200
     6.120    91.497     0.200
     6.387    90.507     0.200
     6.766    96.216     0.200
     7.908   113.315     0.200
     8.086   117.686     0.200
     9.752   134.170     0.200
     9.762   136.643     0.200
     0.414     9.870     0.200
     0.574    14.530     0.200
     0.659    14.112     0.200
     0.730    15.207     0.200
     0.871    16.503     0.200
     0.988    18.382     0.200
     2.224    37.368     0.200
     2.239    37.665     0.200
     6.064    82.966     0.200
     6.064    86.706     0.200
     6.213    90.009     0.200
     7.155    99.422     0.200
     9.861   138.563     0.200
     1.001    18.867     0.200
     1.023    19.070     0.200
     1.023    19.498     0.200
     1.008    18.132     0.200
     2.213    38.582     0.200
     0.608    14.456     0.200
     0.712    15.719     0.200
     0.995    18.704     0.200
     1.014    18.990     0.200
     1.014    19.230     0.200
     1.010    18.478     0.200
     1.308    22.241     0.200
     1.433    23.714     0.200
     1.690    30.409     0.200
     1.691    29.815     0.200
     2.158    34.458     0.200
     2.190    37.577     0.200
     2.207    37.914     0.200
     2.701    42.070     0.200
     0.730    15.936     0.200
     0.732    16.407     0.200
     0.984    17.936     0.200
     1.061    18.839     0.200
     1.040    19.431     0.200
     1.059    19.431     0.200
     1.059    19.564     0.200
     1.651    25.899     0.200
     1.812    31.154     0.200
     2.238    38.504     0.200
     0.610    13.882     0.200
     1.010    18.810     0.200
     0.993    18.521     0.200
     1.009    18.526     0.200
     1.044    18.633     0.200
     2.154    34.255     0.200
     2.188    37.927     0.200
     2.206    38.198     0.200
     0.696    15.519     0.200
     0.800    16.133     0.200
     0.918    16.603     0.200
     0.918    17.406     0.200
     1.145    19.891     0.200
     1.145    21.262     0.200
     1.298    23.455     0.200
     1.899    32.233     0.200
     0.757    15.212     0.200
     0.810    16.877     0.200
     0.914    16.570     0.200
     0.914    17.145     0.200
     0.602    13.257     0.200
     0.840    16.786     0.200
     0.898    16.597     0.200
     3.875    57.207     0.200
     0.741    16.834     0.200
     0.994    19.415     0.200
     1.612    26.831     0.200
     4.687    67.528     0.200
     0.675    13.870     0.200
     0.647    14.144     0.200
     0.948    17.156     0.200
     0.983    17.505     0.200
     0.982    17.154     0.200
     1.308    22.912     0.200
     1.803    30.579     0.200
     2.959    46.985     0.200
     3.877    61.050     0.200
     8.927   124.181     0.200
    10.286   142.790     0.200
    10.626   141.348     0.200
     0.731    14.948     0.200
     0.850    16.980     0.200
     0.886    16.750     0.200
     0.941    16.659     0.200
     0.941    17.066     0.200
     0.606    13.094     0.200
     0.719    14.485     0.200
     0.719    14.135     0.200
     0.760    14.804     0.200
     0.907    15.871     0.200
     0.907    16.262     0.200
     3.685    56.204     0.200
     4.247    64.443     0.200
     5.475    80.316     0.200
     0.710    16.254     0.200
     8.291   116.694     0.200
     0.756    15.529     0.200
     0.756    16.829     0.200
     0.818    16.017     0.200
     0.818    16.586     0.200
     1.177    21.546     0.200
     8.436   118.573     0.200
     0.731    16.244     0.200
     0.784    15.764     0.200
     0.810    15.822     0.200
     0.845    15.223     0.200
     0.845    15.903     0.200
     0.934    17.559     0.200
     1.138    20.779     0.200
     1.863    32.732     0.200
     2.101    35.778     0.200
     7.944   114.915     0.200
    13.232   182.141     0.200
    16.179   215.249     0.200
     0.504    12.776     0.200
     0.681    14.577     0.200
     0.819    16.788     0.200
     0.904    16.716     0.200
     1.090    18.932     0.200
     1.548    26.847     0.200
     1.642    28.217     0.200
     8.839   124.349     0.200
     0.621    14.012     0.200
     0.741    15.454     0.200
     0.792    16.448     0.200
     0.834    17.243     0.200
     0.873    17.083     0.200
     0.940    17.069     0.200
     6.350    87.567     0.200
    10.387   143.478     0.200
     0.782    15.955     0.200
     0.933    16.768     0.200
     0.933    17.475     0.200
     1.102    19.004     0.200
     1.102    19.660     0.200
     1.106    20.545     0.200
     0.783    16.803     0.200
     1.133    21.590     0.200
     4.276    61.440     0.200
     8.469   118.791     0.200
     0.558    13.749     0.200
     0.688    14.382     0.200
     1.033    19.372     0.200
     1.027    18.776     0.200
     1.120    20.652     0.200
     1.603    28.025     0.200
     1.604    27.090     0.200
     1.604    28.035     0.200
     2.239    38.003     0.200
     9.952   139.481     0.200
     0.771    15.971     0.200
     0.813    16.045     0.200
     0.939    16.650     0.200
     1.160    21.202     0.200
     1.713    28.106     0.200
     1.713    27.770     0.200
     1.957    32.449     0.200
     4.297    63.016     0.200
    13.731   186.763     0.200
     1.035    19.424     0.200
     1.358    24.184     0.200
     1.395    24.998     0.200
     4.674    68.385     0.200
     5.317    77.734     0.200
     5.517    79.997     0.200
     0.686    14.676     0.200
     0.845    16.363     0.200
     0.931    17.013     0.200
     0.973    17.384     0.200
     0.973    17.079     0.200
     1.743    30.483     0.200
     2.196    36.301     0.200
     4.834    69.639     0.200
     6.323    92.192     0.200
     6.478    92.943     0.200
     8.107   116.958     0.200
     0.766    15.079     0.200
     0.784    15.784     0.200
     1.160    21.091     0.200
     1.295    21.721     0.200
     1.347    24.369     0.200
     1.630    26.831     0.200
     2.433    38.880     0.200
     3.082    49.161     0.200
     8.355   118.134     0.200
     0.747    14.902     0.200
     0.750    15.034     0.200
     3.649    54.666     0.200
     0.804    15.780     0.200
     0.826    16.104     0.200
     0.853    17.293     0.200
     1.057    18.140     0.200
     1.167    20.155     0.200
     1.167    20.436     0.200
     1.584    26.711     0.200
     1.585    28.319     0.200
     0.648    14.499     0.200
     0.998    17.152     0.200
     1.279    22.359     0.200
     1.557    25.544     0.200
     1.739    29.248     0.200
     1.831    30.405     0.200
     2.368    37.006     0.200
     0.670    13.885     0.200
     0.950    17.552     0.200
     0.979    17.726     0.200
     0.979    17.374     0.200
     1.385    23.398     0.200
     1.720    30.117     0.200
     1.810    28.935     0.200
     3.029    47.657     0.200
     9.255   124.767     0.200
    10.052   141.711     0.200
    16.070   216.809     0.200
     0.820    16.114     0.200
     1.048    18.701     0.200
     1.146    19.764     0.200
     1.146    20.621     0.200
     1.153    20.500     0.200
     1.153    20.676     0.200
     1.153    20.933     0.200
     1.508    24.407     0.200
     2.396    40.309     0.200
     3.248    50.793     0.200
    13.368   179.835     0.200
     0.629    13.241     0.200
     0.989    16.844     0.200
     0.989    18.254     0.200
     1.345    22.987     0.200
     1.575    26.329     0.200
     1.730    27.583     0.200
     1.730    30.904     0.200
     1.989    32.553     0.200
     1.989    33.409     0.200
     2.356    35.650     0.200
     2.622    40.266     0.200
     2.700    39.902     0.200
     3.004    47.347     0.200
     3.482    52.889     0.200
     3.872    57.562     0.200
     4.636    70.824     0.200
     4.981    71.931     0.200
     6.247    87.471     0.200
     8.093   117.277     0.200
     0.959    20.133     0.200
     1.236    23.065     0.200
     1.242    22.367     0.200
     1.470    27.522     0.200
     1.567    28.549     0.200
     1.573    28.699     0.200
     1.573    26.496     0.200
     1.631    27.884     0.200
     1.631    27.439     0.200
     1.778    30.552     0.200
     1.979    32.850     0.200
     2.293    37.808     0.200
     2.429    38.651     0.200
     2.612    43.880     0.200
     2.631    42.544     0.200
     2.943    44.593     0.200
     2.943    44.929     0.200
     3.705    58.899     0.200
     4.354    68.617     0.200
     4.721    69.478     0.200
     4.744    67.425     0.200
     4.900    68.309     0.200
     5.582    81.645     0.200
     0.625    13.673     0.200
     0.625    14.853     0.200
     1.018    17.503     0.200
     1.018    16.964     0.200
     1.399    22.389     0.200
     2.673    43.265     0.200
     4.218    63.476     0.200
     9.621   127.568     0.200
    13.382   178.320     0.200
     0.792    15.558     0.200
     0.944    16.516     0.200
     0.944    16.699     0.200
     1.405    24.274     0.200
     1.733    26.963     0.200
     2.589    41.198     0.200
     3.090    49.333     0.200
     3.812    58.350     0.200
     5.471    80.869     0.200
     6.352    86.376     0.200
     0.780    16.164     0.200
     0.780    16.313     0.200
     0.888    18.223     0.200
     1.317    22.963     0.200
     1.616    27.648     0.200
    10.407   143.988     0.200
     0.546    11.810     0.200
     0.633    13.690     0.200
     0.804    16.073     0.200
     1.001    17.404     0.200
     1.379    23.792     0.200
     2.598    38.342     0.200
     3.207    52.259     0.200
     8.308   114.140     0.200
     8.301   120.099     0.200
     8.350   116.976     0.200
     0.852    16.674     0.200
     0.938    17.108     0.200
     2.130    31.812     0.200
     2.130    34.282     0.200
     3.114    48.475     0.200
     6.370    89.700     0.200
     6.370    89.800     0.200
    12.900   177.957     0.200
     0.640    14.152     0.200
     0.795    17.621     0.200
     0.998    18.477     0.200
     0.998    17.897     0.200
     0.998    18.787     0.200
     1.382    23.212     0.200
     1.839    27.449     0.200
     3.245    51.624     0.200
     4.275    67.749     0.200
     6.292    87.428     0.200
     0.742    15.778     0.200
     0.742    16.832     0.200
     0.866    16.791     0.200
    12.041   165.287     0.200
     0.712    14.364     0.200
     0.806    16.692     0.200
     0.898    16.393     0.200
     0.970    16.218     0.200
     0.970    16.612     0.200
     1.710    29.191     0.200
     0.735    16.162     0.200
     1.228    21.272     0.200
     1.410    26.190     0.200
     1.410    26.338     0.200
     2.540    42.977     0.200
     2.615    43.657     0.200
     0.663    14.712     0.200
     0.863    17.811     0.200
     1.261    22.617     0.200
     1.543    25.303     0.200
     1.733    29.478     0.200
     2.363    35.236     0.200
     2.691    41.181     0.200
     3.026    48.198     0.200
     1.223    21.407     0.200
     1.223    22.149     0.200
     1.409    26.218     0.200
     1.409    26.438     0.200
     1.577    26.259     0.200
     2.540    43.031     0.200
     2.614    43.709     0.200
     0.758    15.757     0.200
     0.775    16.637     0.200
     0.822    16.126     0.200
     0.415     9.974     0.200
     0.814    15.772     0.200
     0.839    15.656     0.200
     0.839    15.355     0.200
     0.847    16.195     0.200
     1.019    17.905     0.200
     1.141    19.867     0.200
     1.143    20.270     0.200
     1.143    19.766     0.200
     1.475    26.085     0.200
     1.896    31.016     0.200
     2.413    40.385     0.200
     3.259    48.934     0.200
     4.174    61.077     0.200
     0.810    16.908     0.200
     0.852    17.798     0.200
     0.982    19.192     0.200
     1.024    19.043     0.200
     1.236    21.235     0.200
     1.236    21.360     0.200
     1.635    27.853     0.200
     1.920    30.632     0.200
     2.587    39.554     0.200
     2.603    43.603     0.200
     2.691    40.327     0.200
     2.835    43.138     0.200
     0.763    17.065     0.200
     0.904    18.406     0.200
     1.026    19.286     0.200
     1.236    21.180     0.200
     1.236    21.430     0.200
     1.407    26.349     0.200
     1.407    26.263     0.200
     1.803    31.799     0.200
     1.953    32.488     0.200
     2.611    43.629     0.200
     2.838    44.223     0.200
     2.889    47.369     0.200
     2.925    47.185     0.200
     3.035    46.836     0.200
     3.333    51.998     0.200
     0.802    15.950     0.200
     0.760    15.537     0.200
     1.435    23.562     0.200
     2.609    39.434     0.200
     3.055    50.558     0.200
     3.849    59.974     0.200
     8.465   119.106     0.200
     1.412    24.335     0.200
     1.957    33.707     0.200
     0.812    16.003     0.200
     2.319    36.650     0.200
     2.629    40.522     0.200
     0.762    17.148     0.200
     0.770    15.812     0.200
     0.817    16.398     0.200
     1.408    23.939     0.200
     0.684    14.623     0.200
     0.890    17.883     0.200
     0.979    16.519     0.200
     0.979    17.343     0.200
     1.244    21.933     0.200
     1.524    25.551     0.200
     1.720    27.299     0.200
     1.770    29.366     0.200
     2.017    35.207     0.200
     2.077    33.827     0.200
     2.351    35.326     0.200
     2.909    46.716     0.200
     3.787    55.210     0.200
     0.989    16.746     0.200
     0.989    17.172     0.200
     1.217    22.007     0.200
     1.249    21.916     0.200
     1.746    30.678     0.200
     1.731    29.701     0.200
     0.586    14.309     0.200
     0.638    13.359     0.200
     0.875    15.680     0.200
     1.049    17.886     0.200
     1.139    19.172     0.200
     1.668    28.319     0.200
     2.008    34.356     0.200
     2.034    34.242     0.200
     8.067   113.805     0.200
     0.986    16.964     0.200
     8.377   116.963     0.200
    10.325   140.627     0.200
     0.747    15.149     0.200
     1.497    25.009     0.200
     1.570    26.172     0.200
     2.011    31.882     0.200
     0.809    15.966     0.200
     0.947    17.169     0.200
     0.947    16.348     0.200
     1.428    23.811     0.200
     1.686    29.342     0.200
     2.460    37.553     0.200
     2.604    40.387     0.200
     2.879    46.436     0.200
     3.060    49.144     0.200
     3.131    48.923     0.200
     3.108    50.023     0.200
     3.732    56.671     0.200
     3.841    57.101     0.200
     3.928    57.343     0.200
     4.300    62.052     0.200
     4.340    64.350     0.200
     4.660    69.471     0.200
     5.204    76.868     0.200
     7.517   105.995     0.200
     7.540   103.915     0.200
     8.457   117.614     0.200
     0.785    16.105     0.200
     0.765    15.291     0.200
     1.607    26.726     0.200
     2.102    32.951     0.200
     6.305    88.117     0.200
     0.866    17.133     0.200
     0.950    16.469     0.200
     1.229    22.341     0.200
     1.393    23.404     0.200
     1.489    25.602     0.200
     2.087    33.526     0.200
     3.792    54.825     0.200
     8.406   115.951     0.200
     0.616    14.141     0.200
     0.677    14.676     0.200
     0.737    15.128     0.200
     1.231    21.996     0.200
     1.383    22.607     0.200
     1.383    23.232     0.200
     1.440    26.123     0.200
     2.001    33.776     0.200
     2.012    34.004     0.200
     2.156    36.020     0.200
     2.962    45.241     0.200
     3.025    47.973     0.200
     7.170    98.987     0.200
     0.619    13.978     0.200
     0.619    12.784     0.200
     0.679    14.690     0.200
     0.751    14.980     0.200
     0.764    15.834     0.200
     0.764    15.615     0.200
     0.786    16.347     0.200
     1.169    21.297     0.200
     1.295    21.388     0.200
     1.320    22.705     0.200
     1.427    25.396     0.200
     1.581    26.288     0.200
     1.588    26.896     0.200
     1.594    26.671     0.200
     1.635    26.861     0.200
     1.634    27.239     0.200
     1.718    29.370     0.200
     0.638    13.357     0.200
     0.714    15.894     0.200
     0.749    14.675     0.200
     0.870    15.359     0.200
     1.541    26.510     0.200
     2.089    31.027     0.200
     2.089    31.465     0.200
     0.579    12.402     0.200
     0.752    15.000     0.200
     0.752    14.563     0.200
     0.720    15.697     0.200
     0.752    14.779     0.200
     0.876    15.568     0.200
     1.347    21.558     0.200
     2.083    31.051     0.200
     3.753    53.914     0.200
     6.285    87.140     0.200
     0.699    15.299     0.200
     0.765    14.397     0.200
     0.800    14.990     0.200
     0.858    15.171     0.200
     1.293    22.082     0.200
     1.637    27.821     0.200
     1.647    28.837     0.200
     0.492    11.561     0.200
     0.580    14.194     0.200
     0.591    13.896     0.200
     0.610    14.373     0.200
     0.667    13.930     0.200
     0.667    13.740     0.200
     0.815    15.751     0.200
     0.807    16.256     0.200
     0.819    15.333     0.200
     0.841    15.695     0.200
     0.840    16.018     0.200
     0.843    15.252     0.200
     0.850    16.176     0.200
     0.858    15.361     0.200
     0.967    18.037     0.200
     0.988    17.346     0.200
     0.980    18.229     0.200
     1.127    19.072     0.200
     1.127    18.853     0.200
     1.149    20.630     0.200
     2.001    34.129     0.200
     0.418     9.591     0.200
     0.412    10.173     0.200
     0.483    11.514     0.200
     0.503    11.917     0.200
     0.503    13.226     0.200
     0.533    12.712     0.200
     0.533    13.634     0.200
     0.552    12.410     0.200
     0.543    12.541     0.200
     0.564    11.611     0.200
     0.542    13.268     0.200
     0.573    14.071     0.200
     0.559    12.531     0.200
     0.587    13.389     0.200
     0.670    14.091     0.200
     0.707    14.514     0.200
     0.731    16.526     0.200
     0.783    14.552     0.200
     0.934    16.782     0.200
     1.338    21.253     0.200
     6.187    84.814     0.200
     0.460    12.189     0.200
     0.487    11.642     0.200
     0.509    12.577     0.200
     0.568    13.141     0.200
     0.589    14.009     0.200
     0.630    14.478     0.200
     0.645    13.039     0.200
     0.719    15.685     0.200
     0.740    14.210     0.200
     0.746    14.172     0.200
     1.227    21.746     0.200
     1.349    23.536     0.200
     1.551    22.046     0.200
     3.760    51.776     0.200
     0.407    10.302     0.200
     0.437     9.841     0.200
     0.447    11.227     0.200
     0.469    11.765     0.200
     0.503    12.155     0.200
     0.503    12.545     0.200
     0.510    12.309     0.200
     0.518    12.381     0.200
     0.555    12.191     0.200
     0.598    13.291     0.200
     0.605    13.607     0.200
     0.636    15.279     0.200
     0.691    15.179     0.200
     0.689    15.970     0.200
     0.716    14.353     0.200
     0.716    14.939     0.200
     0.717    14.362     0.200
     0.735    15.022     0.200
     0.755    15.582     0.200
     0.797    14.585     0.200
     0.879    16.083     0.200
     1.211    21.565     0.200
     6.347    88.034     0.200
     0.366     9.549     0.200
     0.375     8.402     0.200
     0.377     9.180     0.200
     0.427    10.520     0.200
     0.443    12.315     0.200
     0.469     9.972     0.200
     0.482    10.320     0.200
     0.478    11.425     0.200
     0.591    14.274     0.200
     0.604    14.383     0.200
     0.626    13.903     0.200
     0.638    13.533     0.200
     0.678    12.571     0.200
     0.889    15.904     0.200
     0.902    16.279     0.200
     1.144    20.329     0.200
    10.748   147.547     0.200
     0.421    10.066     0.200
     0.459    12.003     0.200
     0.494    11.584     0.200
     0.509    12.390     0.200
     0.587    13.557     0.200
     0.624    13.999     0.200
     0.718    15.568     0.200
     0.704    15.165     0.200
     0.735    14.316     0.200
     0.757    14.956     0.200
     0.756    14.932     0.200
     0.796    15.091     0.200
     1.550    25.573     0.200
     3.774    54.731     0.200
     5.259    74.410     0.200
     6.529    94.373     0.200
     0.503    12.406     0.200
     0.559    13.174     0.200
     0.566    12.480     0.200
     0.609    13.682     0.200
     0.611    14.096     0.200
     0.611    13.335     0.200
     0.661    15.173     0.200
     0.749    15.183     0.200
     0.896    17.002     0.200
     0.939    16.503     0.200
     1.524    23.820     0.200
     1.465    26.078     0.200
     0.445    10.720     0.200
     0.514    11.735     0.200
     0.588    12.945     0.200
     0.548    12.604     0.200
     0.626    13.223     0.200
     0.616    13.449     0.200
     0.612    12.556     0.200
     0.639    13.349     0.200
     0.628    14.018     0.200
     0.640    13.638     0.200
     0.665    13.394     0.200
     0.705    14.119     0.200
     0.753    14.954     0.200
     0.728    14.511     0.200
     0.742    14.736     0.200
     0.736    16.050     0.200
     0.730    15.237     0.200
     0.730    16.127     0.200
     0.772    16.002     0.200
     0.800    16.131     0.200
     0.826    15.967     0.200
     0.813    16.465     0.200
     0.864    16.451     0.200
     0.894    16.241     0.200
     0.908    16.669     0.200
     0.944    17.190     0.200
     0.976    17.594     0.200
     0.997    18.217     0.200
     1.022    18.488     0.200
     0.494    11.991     0.200
     0.609    14.081     0.200
     0.595    14.832     0.200
     0.740    15.691     0.200
     0.760    16.437     0.200
     0.811    15.912     0.200
     0.896    18.329     0.200
     0.896    19.159     0.200
     1.531    25.487     0.200
     1.604    27.648     0.200
     3.802    54.072     0.200
     0.444    11.289     0.200
     0.491    11.927     0.200
     0.500    13.274     0.200
     0.514    11.314     0.200
     0.554    13.185     0.200
     0.547    12.149     0.200
     0.575    13.292     0.200
     0.602    12.443     0.200
     0.618    13.990     0.200
     0.608    14.631     0.200
     0.608    14.319     0.200
     0.633    14.317     0.200
     0.726    15.754     0.200
     0.740    15.029     0.200
     0.787    16.569     0.200
     0.805    16.802     0.200
     0.832    17.566     0.200
     0.922    16.838     0.200
     1.511    24.805     0.200
     1.606    26.899     0.200
     0.417     9.891     0.200
     0.471    11.628     0.200
     0.497    11.550     0.200
     0.520    13.153     0.200
     0.549    12.877     0.200
     0.600    13.977     0.200
     0.640    14.289     0.200
     0.716    15.760     0.200
     0.751    14.827     0.200
     0.799    16.094     0.200
     0.866    15.737     0.200
     1.221    22.055     0.200
     5.241    78.133     0.200
     0.552    12.781     0.200
     0.589    13.535     0.200
     0.594    12.392     0.200
     0.625    12.559     0.200
     0.629    14.031     0.200
     0.643    13.080     0.200
     0.748    14.474     0.200
     0.761    15.120     0.200
     1.067    19.120     0.200
     1.551    24.337     0.200
     1.604    26.471     0.200
     3.762    56.225     0.200
     4.981    70.446     0.200
     0.415    10.466     0.200
     0.446    10.945     0.200
     0.493    11.699     0.200
     0.507    10.728     0.200
     0.513    12.479     0.200
     0.503    12.368     0.200
     0.513    12.876     0.200
     0.539    13.133     0.200
     0.602    12.900     0.200
     0.650    13.291     0.200
     0.681    13.792     0.200
     0.652    12.955     0.200
     0.730    14.433     0.200
     0.772    15.030     0.200
     0.727    14.557     0.200
     0.740    15.302     0.200
     0.777    16.074     0.200
     0.821    15.542     0.200
     0.864    15.856     0.200
     0.863    16.158     0.200
     0.864    15.843     0.200
     0.864    16.036     0.200
     0.873    15.926     0.200
     0.904    16.773     0.200
     0.911    16.651     0.200
     0.754    19.327     0.200
     0.944    17.441     0.200
     0.950    17.571     0.200
     1.179    20.260     0.200
     1.317    23.471     0.200
     0.407     9.405     0.200
     0.438    10.608     0.200
     0.595    12.912     0.200
     0.533    13.004     0.200
     0.559    13.353     0.200
     0.555    13.518     0.200
     0.697    14.627     0.200
     0.698    14.484     0.200
     0.685    14.675     0.200
     0.685    14.821     0.200
     0.720    15.757     0.200
     0.775    16.416     0.200
     0.752    17.111     0.200
     0.784    15.846     0.200
     0.930    17.446     0.200
     0.974    17.424     0.200
     1.053    18.691     0.200
     1.197    20.972     0.200
     0.485    11.562     0.200
     0.471    11.680     0.200
     0.444    12.230     0.200
     0.482    10.996     0.200
     0.482    11.434     0.200
     0.591    12.989     0.200
     0.535    12.726     0.200
     0.558    13.040     0.200
     0.556    13.198     0.200
     0.596    12.363     0.200
     0.681    14.467     0.200
     0.692    15.128     0.200
     0.694    14.599     0.200
     0.686    14.340     0.200
     0.697    14.584     0.200
     0.690    14.582     0.200
     0.722    15.611     0.200
     0.776    16.306     0.200
     0.787    15.797     0.200
     0.758    15.126     0.200
     0.840    17.193     0.200
     0.927    17.465     0.200
     0.969    17.470     0.200
     1.023    17.941     0.200
     1.195    20.780     0.200
     1.209    22.145     0.200
     1.367    24.778     0.200
     1.426    25.205     0.200
     0.573    13.844     0.200
     0.671    15.735     0.200
     0.728    14.844     0.200
     0.705    16.583     0.200
     0.752    15.842     0.200
     0.720    15.451     0.200
     0.729    16.026     0.200
     0.729    16.377     0.200
     0.759    17.063     0.200
     0.766    15.346     0.200
     0.773    16.007     0.200
     0.781    15.764     0.200
     0.824    16.631     0.200
     0.824    17.541     0.200
     0.896    17.554     0.200
     0.928    17.632     0.200
     0.950    17.001     0.200
     0.942    17.578     0.200
     0.936    17.570     0.200
     0.994    17.932     0.200
     0.995    18.902     0.200
     1.009    19.171     0.200
     1.010    19.058     0.200
     1.012    18.230     0.200
     1.010    18.906     0.200
     1.059    19.805     0.200
     1.107    20.404     0.200
     1.208    21.707     0.200
     1.210    21.402     0.200
     1.292    23.542     0.200
     1.348    24.497     0.200
     1.360    24.914     0.200
     1.408    25.058     0.200
     1.409    25.078     0.200
     1.432    24.662     0.200
     2.073    32.709     0.200
    11.005   151.831     0.200
     0.453    10.575     0.200
     0.497    12.057     0.200
     0.538    12.728     0.200
     0.569    12.777     0.200
     0.587    13.002     0.200
     0.651    13.909     0.200
     0.657    14.006     0.200
     0.664    13.804     0.200
     0.675    15.271     0.200
     0.675    16.132     0.200
     0.673    14.853     0.200
     0.673    14.385     0.200
     0.753    16.927     0.200
     0.753    16.735     0.200
     0.882    17.603     0.200
     0.901    17.726     0.200
     0.986    17.528     0.200
     1.041    18.572     0.200
     1.290    23.204     0.200
     1.609    24.260     0.200
     1.813    32.011     0.200
     3.986    58.432     0.200
     6.730    94.245     0.200
     6.730    96.706     0.200
     0.453    10.423     0.200
     0.453    11.414     0.200
     0.461    10.020     0.200
     0.461    10.550     0.200
     0.670    13.958     0.200
     0.366     9.371     0.200
     0.696    14.912     0.200
     0.696    14.072     0.200
     0.430     9.668     0.200
     0.437    11.372     0.200
     0.435    11.154     0.200
     0.630    14.165     0.200
     0.630    15.216     0.200
     0.630    14.507     0.200
     0.645    15.255     0.200
     0.627    13.773     0.200
     0.632    13.686     0.200
     0.423    10.188     0.200
     0.386     9.621     0.200
     0.613    13.111     0.200
     0.398     9.438     0.200
     0.693    14.728     0.200
     0.597    13.035     0.200
     0.848    15.917     0.200
     0.493    11.103     0.200
     0.591    12.571     0.200
     1.103    19.328     0.200
     1.103    19.253     0.200
     0.400     9.820     0.200
     0.392     9.118     0.200
     0.374     9.219     0.200
     0.413     9.924     0.200
     0.439    10.451     0.200
     0.504    11.256     0.200
     0.457    10.407     0.200
     0.603    12.275     0.200
     0.611    13.254     0.200
     0.626    13.155     0.200
     0.619    14.035     0.200
     0.638    13.431     0.200
     0.616    14.284     0.200
     0.676    14.280     0.200
     0.706    14.761     0.200
     0.683    14.393     0.200
     0.729    15.336     0.200
     0.995    18.353     0.200
     1.033    18.902     0.200
     1.116    19.402     0.200
     0.394     9.288     0.200
     0.402     9.986     0.200
     0.373     9.432     0.200
     0.421    10.591     0.200
     0.438    10.101     0.200
     0.464    10.067     0.200
     0.484    11.127     0.200
     0.524    10.811     0.200
     0.606    12.905     0.200
     0.627    13.282     0.200
     0.618    13.425     0.200
     0.614    14.085     0.200
     0.638    12.972     0.200
     0.707    14.670     0.200
     0.675    14.048     0.200
     0.681    13.950     0.200
     0.852    15.961     0.200
     0.888    15.570     0.200
     0.862    16.060     0.200
     0.937    16.618     0.200
     1.047    18.377     0.200
     1.110    18.777     0.200
     1.118    19.617     0.200
     1.118    19.481     0.200
     0.426     9.987     0.200
     0.426     9.877     0.200
     0.451    11.749     0.200
     0.465    11.528     0.200
     0.495    11.557     0.200
     0.495    12.367     0.200
     0.489    12.167     0.200
     0.502    12.587     0.200
     0.502    12.187     0.200
     0.502    13.077     0.200
     0.531    12.162     0.200
     0.531    12.862     0.200
     0.579    13.183     0.200
     0.577    13.497     0.200
     0.577    14.677     0.200
     0.612    13.241     0.200
     0.607    14.831     0.200
     0.693    15.138     0.200
     0.723    14.525     0.200
     0.737    16.221     0.200
     0.744    14.945     0.200
     0.750    16.254     0.200
     0.762    14.879     0.200
     0.765    15.422     0.200
     0.782    15.760     0.200
     0.816    16.920     0.200
     1.049    19.264     0.200
     1.212    21.784     0.200
     1.281    21.406     0.200
     1.557    26.049     0.200
     3.790    59.389     0.200
     0.409     9.708     0.200
     0.439    11.679     0.200
     0.456    11.744     0.200
     0.471    10.181     0.200
     0.481    12.054     0.200
     0.478    11.260     0.200
     0.478    11.885     0.200
     0.489    11.642     0.200
     0.468    10.762     0.200
     0.468    10.419     0.200
     0.566    13.537     0.200
     0.566    13.553     0.200
     0.604    13.605     0.200
     0.547    12.792     0.200
     0.618    12.680     0.200
     0.613    14.099     0.200
     0.735    16.101     0.200
     0.707    15.185     0.200
     0.773    16.530     0.200
     0.777    15.491     0.200
     0.777    15.311     0.200
     0.766    15.575     0.200
     0.766    16.099     0.200
     0.814    14.940     0.200
     0.843    15.160     0.200
     0.921    16.792     0.200
     1.571    25.309     0.200
     3.738    57.849     0.200
     3.783    55.433     0.200
     5.007    74.962     0.200
     5.274    77.504     0.200
     5.274    79.535     0.200
     5.696    83.928     0.200
     5.872    86.939     0.200
     8.685   123.338     0.200
     9.956   140.026     0.200
    10.379   147.392     0.200
    12.738   177.422     0.200
     0.536    12.199     0.200
     0.536    12.363     0.200
     0.610    13.217     0.200
     0.617    14.936     0.200
     0.618    14.879     0.200
     0.695    15.123     0.200
     0.983    18.230     0.200
     1.569    23.082     0.200
     0.442    11.408     0.200
     0.456    11.651     0.200
     0.616    14.709     0.200
     0.480    11.972     0.200
     0.489    11.696     0.200
     0.493    12.252     0.200
     0.568    13.018     0.200
     0.572    13.158     0.200
     0.603    13.184     0.200
     0.729    15.849     0.200
     0.757    15.614     0.200
     0.741    16.242     0.200
     0.773    15.911     0.200
     0.777    16.686     0.200
     0.807    16.726     0.200
     0.985    18.331     0.200
     1.578    26.654     0.200
     1.744    29.081     0.200
     3.795    59.920     0.200
     5.010    72.920     0.200
     5.283    77.140     0.200
     5.694    83.435     0.200
     5.874    85.491     0.200
     0.394     9.365     0.200
     0.394     9.535     0.200
     0.433    11.623     0.200
     0.456    11.789     0.200
     0.465    11.098     0.200
     0.465    10.937     0.200
     0.454    10.377     0.200
     0.482    11.901     0.200
     0.480    11.862     0.200
     0.554    12.609     0.200
     0.562    13.432     0.200
     0.562    13.411     0.200
     0.564    12.723     0.200
     0.564    12.843     0.200
     0.604    13.587     0.200
     0.604    12.266     0.200
     0.730    15.487     0.200
     0.723    15.810     0.200
     0.767    16.569     0.200
     0.830    15.640     0.200
     0.838    15.673     0.200
     1.050    19.154     0.200
     1.181    21.398     0.200
     1.257    20.683     0.200
     1.578    23.104     0.200
     1.579    26.537     0.200
     3.771    55.563     0.200
     5.872    83.787     0.200
     6.534    92.767     0.200
     8.894   121.763     0.200
     0.401     9.541     0.200
     0.401     9.430     0.200
     0.401     9.781     0.200
     0.401    10.590     0.200
     0.436    10.176     0.200
     0.436    10.487     0.200
     0.461    12.449     0.200
     0.461    10.590     0.200
     0.481    11.392     0.200
     0.481    11.282     0.200
     0.481    11.911     0.200
     0.486    12.593     0.200
     0.509    12.525     0.200
     0.509    12.275     0.200
     0.505    11.721     0.200
     0.505    12.412     0.200
     0.505    11.231     0.200
     0.578    13.172     0.200
     0.591    14.189     0.200
     0.591    13.339     0.200
     0.583    13.605     0.200
     0.564    13.444     0.200
     0.634    14.502     0.200
     0.634    14.082     0.200
     0.652    13.959     0.200
     0.652    14.129     0.200
     0.744    15.104     0.200
     0.890    16.594     0.200
     1.552    22.385     0.200
     1.608    26.877     0.200
     3.750    55.820     0.200
     5.843    87.824     0.200
     0.357     8.759     0.200
     0.467    11.255     0.200
     0.506    12.269     0.200
     0.515    11.399     0.200
     0.515    12.231     0.200
     0.579    13.131     0.200
     0.590    13.896     0.200
     0.587    13.288     0.200
     0.639    14.000     0.200
     0.665    13.417     0.200
     0.665    14.319     0.200
     0.665    14.819     0.200
     0.720    13.375     0.200
     0.730    13.156     0.200
     1.612    25.616     0.200
     3.719    58.939     0.200
     4.969    75.264     0.200
     5.226    78.259     0.200
     0.391     9.527     0.200
     0.488    11.800     0.200
     0.508    12.343     0.200
     0.513    12.545     0.200
     0.513    11.865     0.200
     0.564    13.186     0.200
     0.569    13.486     0.200
     0.607    12.834     0.200
     0.607    13.506     0.200
     0.644    14.622     0.200
     0.644    14.639     0.200
     0.614    13.467     0.200
     0.614    12.385     0.200
     0.623    13.732     0.200
     0.623    13.923     0.200
     0.623    13.903     0.200
     0.668    14.431     0.200
     0.695    14.771     0.200
     0.701    13.846     0.200
     0.701    15.335     0.200
     0.765    15.256     0.200
     0.774    15.584     0.200
     0.896    16.798     0.200
     0.926    16.059     0.200
     3.905    56.732     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.793    76.232     0.200
     7.445   153.386     0.200
     7.475   151.056     0.200
     8.343   168.494     0.200
     8.419   173.995     0.200
     7.789   153.660     0.200
    11.321   232.000     0.200
     3.754    75.384     0.200
     8.342   168.115     0.200
     7.335   145.884     0.200
     7.718   154.111     0.200
    11.286   229.027     0.200
    15.912   319.436     0.200
     2.594    50.744     0.200
     3.723    73.691     0.200
     4.674    94.774     0.200
     6.482   129.987     0.200
     7.678   153.824     0.200
     8.004   166.549     0.200
    11.300   229.125     0.200
     4.140    80.374     0.200
     4.479    91.288     0.200
     7.343   144.846     0.200
     7.699   153.133     0.200
     7.904   155.313     0.200
     8.111   164.460     0.200
     8.590   174.829     0.200
     9.414   192.605     0.200
    10.981   220.189     0.200
    11.259   227.994     0.200
    23.974   472.620     0.200
    26.268   521.428     0.200
     6.455   132.957     0.200
    10.472   207.781     0.200
    10.990   222.329     0.200
     2.619    53.691     0.200
     2.884    57.040     0.200
     3.558    73.080     0.200
     3.618    75.724     0.200
     4.126    81.541     0.200
     4.482    91.931     0.200
     5.813   119.621     0.200
     6.932   141.350     0.200
     2.890    55.982     0.200
     3.618    71.728     0.200
     3.851    80.048     0.200
     4.495    91.239     0.200
     5.344   106.650     0.200
    11.271   226.274     0.200
    26.286   522.495     0.200
     3.846    78.398     0.200
     7.346   149.408     0.200
     7.698   157.499     0.200
    10.494   208.337     0.200
     2.629    53.176     0.200
     3.834    79.298     0.200
     4.143    82.215     0.200
     7.345   147.448     0.200
     7.789   156.344     0.200
     8.281   167.606     0.200
     7.796   152.461     0.200
     8.283   164.417     0.200
     2.622    56.095     0.200
     2.881    57.399     0.200
     3.613    71.085     0.200
     3.853    78.420     0.200
     4.125    82.773     0.200
     4.489    92.779     0.200
     6.569   130.408     0.200
     6.622   134.818     0.200
     7.353   148.257     0.200
     7.602   153.922     0.200
     7.704   156.270     0.200
     7.933   161.048     0.200
     7.986   162.157     0.200
     8.103   168.312     0.200
     8.579   174.771     0.200
     8.653   176.123     0.200
     9.427   191.553     0.200
    10.495   207.612     0.200
    22.892   454.542     0.200
     2.627    51.767     0.200
     5.547   109.107     0.200
     6.574   129.060     0.200
     6.932   135.300     0.200
     7.360   144.425     0.200
     7.489   150.073     0.200
     7.608   152.015     0.200
     7.711   150.682     0.200
     7.810   150.317     0.200
     7.810   150.846     0.200
     7.919   157.110     0.200
     7.939   159.191     0.200
     8.278   161.305     0.200
     8.485   169.709     0.200
     9.425   193.682     0.200
     6.489   130.504     0.200
     8.326   162.244     0.200
     3.253    66.991     0.200
    10.407   209.187     0.200
     2.856    61.032     0.200
     6.788   136.764     0.200
     7.517   148.608     0.200
     7.897   157.781     0.200
     8.507   169.386     0.200
     3.791    74.420     0.200
     4.128    82.145     0.200
     7.038   140.145     0.200
     7.367   147.008     0.200
     7.656   154.072     0.200
     7.778   151.373     0.200
     7.939   153.722     0.200
    11.320   229.075     0.200
     6.302   131.847     0.200
     3.002    58.764     0.200
     4.526    88.964     0.200
     5.637   109.855     0.200
     6.653   129.828     0.200
     7.386   143.212     0.200
     7.788   150.946     0.200
    10.408   204.977     0.200
    11.224   222.766     0.200
    11.346   225.731     0.200
    10.735   216.151     0.200
    10.436   207.186     0.200
    15.934   319.094     0.200
     4.137    84.258     0.200
     7.801   154.939     0.200
    10.431   208.551     0.200
     3.865    77.597     0.200
    10.442   206.905     0.200
     6.144   123.579     0.200
     7.977   156.241     0.200
     8.069   159.245     0.200
    10.801   213.753     0.200
    11.171   225.405     0.200
     2.725    53.829     0.200
     3.844    79.058     0.200
     5.647   115.000     0.200
     6.499   128.156     0.200
     3.055    63.554     0.200
     3.112    60.933     0.200
     3.678    72.056     0.200
     4.100    81.987     0.200
     5.555   116.084     0.200
     5.951   123.239     0.200
     6.209   127.672     0.200
     6.975   142.371     0.200
     7.266   147.150     0.200
     7.663   149.436     0.200
     7.674   153.097     0.200
     7.766   159.494     0.200
     7.849   159.855     0.200
     8.333   167.346     0.200
    10.312   204.380     0.200
     7.708   152.112     0.200
    10.388   205.383     0.200
    10.402   206.649     0.200
     5.577   113.322     0.200
     7.715   156.809     0.200
    10.359   205.084     0.200
     7.832   155.387     0.200
     8.439   167.275     0.200
    10.421   209.331     0.200
     6.051   122.347     0.200
     7.831   152.662     0.200
     2.994    58.868     0.200
     3.788    76.526     0.200
     4.141    84.549     0.200
     8.373   169.672     0.200
    10.409   207.693     0.200
     7.844   158.077     0.200
     8.455   169.647     0.200
    10.425   209.174     0.200
     3.090    62.026     0.200
     6.359   127.840     0.200
     6.904   137.848     0.200
     7.911   154.929     0.200
     2.548    51.570     0.200
     3.115    62.060     0.200
    11.479   230.189     0.200
     6.682   140.048     0.200
     9.189   187.926     0.200
    10.399   205.748     0.200
     6.586   136.743     0.200
     8.452   169.564     0.200
    10.491   205.578     0.200
     8.307   167.358     0.200
    10.677   209.678     0.200
     4.561    93.839     0.200
     7.007   144.920     0.200
     7.007   144.916     0.200
    10.128   199.040     0.200
    16.384   325.613     0.200
    23.186   461.856     0.200
     4.658    92.219     0.200
     7.844   155.382     0.200
     8.592   169.536     0.200
    10.338   200.936     0.200
    23.113   456.449     0.200
     3.793    74.775     0.200
     4.618    90.873     0.200
     5.778   112.894     0.200
     7.472   148.012     0.200
     2.548    49.536     0.200
     2.853    57.281     0.200
     4.667    94.130     0.200
     5.530   109.683     0.200
     5.608   115.695     0.200
     6.196   124.261     0.200
     6.630   131.839     0.200
     7.538   149.250     0.200
     7.647   156.579     0.200
     8.067   158.027     0.200
     8.090   163.391     0.200
     8.159   162.051     0.200
     8.159   161.705     0.200
    10.866   215.578     0.200
     4.021    78.447     0.200
     4.474    95.201     0.200
     5.561   114.040     0.200
     5.579   113.623     0.200
     6.753   134.127     0.200
     7.515   151.081     0.200
     8.023   157.193     0.200
     8.058   158.517     0.200
     8.242   160.197     0.200
    10.746   210.970     0.200
     2.805    55.441     0.200
     3.909    79.202     0.200
     4.662    93.582     0.200
     5.303   105.652     0.200
     5.500   111.462     0.200
     5.717   117.358     0.200
     6.752   136.167     0.200
     7.533   153.011     0.200
     7.880   158.509     0.200
    10.903   215.432     0.200
     4.352    86.594     0.200
     6.354   126.309     0.200
     4.642    91.870     0.200
     5.900   121.288     0.200
     7.510   147.195     0.200
     7.703   153.169     0.200
    10.676   209.648     0.200
     3.041    65.423     0.200
     3.317    65.858     0.200
     3.659    75.867     0.200
     3.989    78.135     0.200
     4.591    89.945     0.200
     5.688   119.565     0.200
     6.280   129.555     0.200
     6.318   129.645     0.200
     7.133   147.336     0.200
     7.445   153.178     0.200
     7.495   153.062     0.200
     7.773   153.219     0.200
     7.907   161.113     0.200
     8.276   171.030     0.200
    10.193   198.825     0.200
    11.580   233.583     0.200
    23.135   460.172     0.200
     2.533    50.584     0.200
     3.906    78.240     0.200
     5.612   113.718     0.200
     5.714   118.207     0.200
     6.145   124.934     0.200
     8.102   159.846     0.200
     3.647    73.946     0.200
     3.864    77.651     0.200
     4.607    94.917     0.200
     5.488   113.746     0.200
     5.697   113.395     0.200
     6.041   124.969     0.200
     6.577   134.302     0.200
     7.468   151.816     0.200
     8.431   166.375     0.200
     6.098   123.709     0.200
     8.073   158.992     0.200
     6.141   123.058     0.200
    10.896   216.405     0.200
    11.245   224.134     0.200
     7.855   151.785     0.200
     7.824   155.837     0.200
     8.585   173.138     0.200
    10.321   204.337     0.200
     3.011    58.999     0.200
     3.284    64.243     0.200
     4.556    89.307     0.200
     5.663   112.149     0.200
     5.877   116.432     0.200
     6.288   128.372     0.200
     6.851   139.352     0.200
     7.777   150.921     0.200
     8.252   165.233     0.200
     8.669   173.662     0.200
     3.855    76.035     0.200
     4.252    84.931     0.200
     2.839    55.793     0.200
     3.802    73.915     0.200
     3.934    76.530     0.200
     5.745   114.745     0.200
     6.183   123.300     0.200
     6.566   128.902     0.200
     7.533   147.714     0.200
     8.061   155.995     0.200
     8.147   161.358     0.200
     2.613    50.872     0.200
     4.242    83.911     0.200
     5.543   110.517     0.200
     5.605   113.537     0.200
     6.125   122.762     0.200
     8.096   162.332     0.200
     7.876   153.541     0.200
    10.413   207.377     0.200
     7.755   152.955     0.200
    10.193   204.613     0.200
     2.556    51.850     0.200
     3.920    78.952     0.200
     3.973    78.638     0.200
     4.192    83.670     0.200
     5.302   107.667     0.200
     8.066   156.227     0.200
     4.046    81.718     0.200
     5.724   120.208     0.200
     7.504   146.709     0.200
     7.761   155.726     0.200
     8.746   177.856     0.200
     8.051   160.949     0.200
    11.012   216.196     0.200
     8.726   174.303     0.200
    10.203   202.094     0.200
     4.290    86.002     0.200
     4.339    84.600     0.200
     7.509   151.947     0.200
    10.394   203.541     0.200
    10.394   203.545     0.200
    11.474   234.881     0.200
     2.775    54.790     0.200
     5.457   109.633     0.200
     5.533   109.576     0.200
     5.578   113.133     0.200
     5.678   114.864     0.200
     6.732   136.197     0.200
     7.406   151.896     0.200
     7.493   143.244     0.200
     7.580   152.593     0.200
     7.712   151.785     0.200
     8.017   157.655     0.200
     8.080   160.415     0.200
     8.072   160.842     0.200
    10.876   215.319     0.200
     3.814    79.504     0.200
     4.214    85.036     0.200
     5.764   119.182     0.200
     6.675   137.230     0.200
     7.487   149.939     0.200
     7.854   153.124     0.200
     8.882   185.069     0.200
     9.738   197.680     0.200
    11.471   231.838     0.200
    13.224   260.594     0.200
    23.072   457.077     0.200
    10.496   210.883     0.200
     7.891   153.192     0.200
     8.537   166.228     0.200
    10.422   205.409     0.200
     6.066   119.398     0.200
     3.796    74.279     0.200
     7.844   153.296     0.200
     8.534   165.746     0.200
    11.481   231.397     0.200
    11.481   231.397     0.200
     3.880    76.048     0.200
     5.271   106.353     0.200
     5.584   112.177     0.200
     5.690   113.675     0.200
     6.565   130.723     0.200
     8.077   156.009     0.200
     8.077   158.915     0.200
    10.892   217.268     0.200
     6.387   128.597     0.200
     8.434   168.768     0.200
    10.455   206.226     0.200
     7.720   155.436     0.200
     8.075   161.306     0.200
     8.090   163.071     0.200
     8.595   170.823     0.200
     7.764   152.691     0.200
     8.682   172.803     0.200
    10.195   203.182     0.200
    10.190   200.678     0.200
     2.946    59.665     0.200
     3.439    69.612     0.200
     3.746    75.966     0.200
     4.645    93.448     0.200
     5.447   110.879     0.200
     5.619   113.140     0.200
     3.663    73.081     0.200
     4.407    89.488     0.200
     7.883   157.556     0.200
     8.458   170.646     0.200
    10.464   208.620     0.200
     7.934   156.175     0.200
     2.742    54.037     0.200
     3.866    77.946     0.200
     5.470   107.991     0.200
     5.668   116.318     0.200
     8.058   160.899     0.200
    10.740   214.966     0.200
     2.781    55.101     0.200
     3.885    77.817     0.200
     3.917    77.110     0.200
     5.542   112.464     0.200
     6.124   125.304     0.200
     8.096   158.822     0.200
     8.100   159.847     0.200
     8.096   157.756     0.200
     8.104   160.661     0.200
     2.987    59.462     0.200
     3.847    76.454     0.200
     5.692   115.241     0.200
     2.523    49.719     0.200
     4.280    85.507     0.200
     5.629   115.247     0.200
     5.674   113.806     0.200
     6.094   124.438     0.200
     6.171   120.889     0.200
     8.078   160.272     0.200
     8.127   160.446     0.200
     3.566    70.161     0.200
     4.328    84.833     0.200
     3.032    61.923     0.200
     3.705    75.623     0.200
     3.830    78.438     0.200
     4.303    86.846     0.200
     7.857   153.731     0.200
     8.052   160.188     0.200
    10.423   206.476     0.200
    11.443   232.573     0.200
     3.638    70.646     0.200
     7.754   155.160     0.200
    10.172   202.974     0.200
     8.046   161.396     0.200
     6.541   130.044     0.200
     6.545   130.239     0.200
     7.728   154.075     0.200
     8.037   155.930     0.200
     8.083   158.495     0.200
     9.795   198.992     0.200
    10.600   210.178     0.200
    10.685   230.074     0.200
    10.941   218.251     0.200
    11.392   237.908     0.200
    11.583   243.229     0.200
     8.101   158.411     0.200
     8.113   157.671     0.200
     9.786   198.216     0.200
    10.610   209.370     0.200
     6.549   129.503     0.200
     6.560   129.115     0.200
     6.777   137.866     0.200
     7.748   153.538     0.200
     7.912   159.037     0.200
     8.097   159.886     0.200
     8.097   158.413     0.200
     8.119   163.250     0.200
     8.119   158.808     0.200
     3.863    75.841     0.200
     6.500   130.515     0.200
     3.806    75.618     0.200
     4.370    86.956     0.200
    10.380   205.096     0.200
    11.492   230.920     0.200
     3.834    85.486     0.200
     8.130   158.223     0.200
    10.606   208.318     0.200
     8.096   158.632     0.200
     8.150   162.369     0.200
    10.968   216.269     0.200
     2.705    52.797     0.200
     3.865    76.569     0.200
     6.464   127.322     0.200
     8.063   160.387     0.200
     6.189   124.442     0.200
     6.725   138.683     0.200
     8.151   160.117     0.200
    10.880   215.632     0.200
     3.889    77.513     0.200
     3.906    79.704     0.200
     4.274    86.090     0.200
     5.536   110.049     0.200
     7.871   155.907     0.200
     4.375    85.398     0.200
     5.456   111.991     0.200
     8.608   171.052     0.200
    10.312   204.439     0.200
     3.665    72.685     0.200
     3.958    79.252     0.200
     4.428    89.823     0.200
     4.682    96.417     0.200
     5.654   113.369     0.200
     6.209   128.824     0.200
     6.281   129.454     0.200
     6.842   140.101     0.200
     6.860   138.290     0.200
     2.972    60.871     0.200
     4.180    82.422     0.200
     4.583    92.220     0.200
     5.435   108.909     0.200
     6.384   129.434     0.200
     7.444   149.706     0.200
     4.107    79.944     0.200
     7.560   162.778     0.200
    11.283   226.930     0.200
     4.279    86.239     0.200
     7.508   153.886     0.200
     7.883   155.591     0.200
     8.086   158.538     0.200
     8.090   162.194     0.200
    12.737   261.726     0.200
     8.073   158.237     0.200
     8.188   161.719     0.200
     9.861   200.171     0.200
    11.021   220.895     0.200
    15.600   308.906     0.200
    26.696   528.662     0.200
     2.748    60.241     0.200
     3.836    78.069     0.200
     3.868    77.829     0.200
     6.468   128.822     0.200
     6.575   130.334     0.200
     7.547   157.018     0.200
     8.066   160.108     0.200
     8.066   159.382     0.200
     8.210   160.756     0.200
     4.715    94.886     0.200
     5.683   115.796     0.200
     6.081   121.748     0.200
     7.920   161.294     0.200
     8.075   161.255     0.200
     8.087   160.593     0.200
     8.183   163.608     0.200
     2.812    56.418     0.200
     3.917    78.488     0.200
     3.948    80.455     0.200
     6.155   123.744     0.200
     6.587   129.903     0.200
     8.044   161.036     0.200
     8.128   161.161     0.200
    10.903   217.227     0.200
     6.627   133.122     0.200
     8.483   169.712     0.200
     3.875    76.328     0.200
     4.258    83.092     0.200
     8.187   170.146     0.200
     4.643    94.198     0.200
     4.905   103.796     0.200
     5.477   110.434     0.200
     5.925   122.852     0.200
     6.801   139.055     0.200
     6.953   141.743     0.200
     7.110   148.007     0.200
     7.760   165.782     0.200
     8.085   158.681     0.200
     8.499   170.126     0.200
    16.201   321.643     0.200
    23.107   455.800     0.200
    26.252   519.949     0.200
     7.847   154.886     0.200
    10.371   207.189     0.200
     2.827    57.489     0.200
     3.685    73.755     0.200
     4.634    92.799     0.200
     5.475   109.376     0.200
     6.088   121.638     0.200
     7.493   147.337     0.200
     8.072   159.300     0.200
     8.475   170.917     0.200
     5.663   116.147     0.200
     7.786   151.847     0.200
    10.228   203.872     0.200
     3.339    68.012     0.200
     3.820    74.224     0.200
     4.294    87.865     0.200
     5.566   112.521     0.200
     6.360   127.034     0.200
     7.169   147.199     0.200
     7.840   155.426     0.200
     7.894   153.966     0.200
     7.944   155.391     0.200
     7.944   171.212     0.200
     8.198   159.869     0.200
     3.810    75.243     0.200
     4.365    85.441     0.200
     6.698   135.361     0.200
     7.499   147.957     0.200
     7.546   151.734     0.200
     9.172   185.549     0.200
    10.490   231.701     0.200
     2.773    54.258     0.200
     5.294   106.067     0.200
     6.544   129.668     0.200
     3.306    64.742     0.200
     7.448   150.828     0.200
     7.775   155.393     0.200
     8.113   163.375     0.200
    10.202   205.481     0.200
     6.478   133.373     0.200
     4.458    87.645     0.200
     6.553   135.970     0.200
    10.357   205.623     0.200
    11.290   227.583     0.200
     6.545   132.958     0.200
     8.360   167.636     0.200
    10.392   205.891     0.200
    11.311   226.010     0.200
    15.942   317.789     0.200
     3.761    75.611     0.200
     4.603    90.745     0.200
     4.444    87.431     0.200
     4.655    93.149     0.200
     4.927    99.067     0.200
     5.461   109.363     0.200
     5.621   111.598     0.200
    10.052   210.524     0.200
     4.826    95.942     0.200
     7.605   148.882     0.200
    10.863   213.707     0.200
    10.863   213.702     0.200
     3.283    65.020     0.200
     7.755   162.785     0.200
    10.257   200.876     0.200
    10.257   200.879     0.200
     3.910    79.812     0.200
     4.647    95.379     0.200
     6.700   139.576     0.200
    10.388   206.919     0.200
    11.494   231.252     0.200
     7.785   155.391     0.200
    10.407   205.535     0.200
    10.293   201.267     0.200
    11.339   226.306     0.200
     3.830    75.239     0.200
     6.370   128.000     0.200
     7.873   156.999     0.200
     8.086   159.416     0.200
     9.756   199.103     0.200
     5.642   115.183     0.200
     6.292   124.548     0.200
     3.748    75.817     0.200
     6.257   129.321     0.200
     6.373   128.864     0.200
     8.107   161.965     0.200
    10.408   208.696     0.200
     6.669   134.178     0.200
     6.741   137.389     0.200
     8.650   175.298     0.200
    10.739   216.535     0.200
     3.837    74.704     0.200
     8.385   173.127     0.200
     8.140   166.177     0.200
     8.276   164.770     0.200
     6.137   122.758     0.200
     4.212    88.153     0.200
     2.535    49.624     0.200
    10.746   211.334     0.200
     4.482    90.042     0.200
     4.665    92.172     0.200
     6.677   134.541     0.200
     7.887   161.153     0.200
     7.891   153.938     0.200
     8.235   162.429     0.200
     8.531   166.835     0.200
     9.770   194.705     0.200
     9.775   187.451     0.200
    10.469   226.709     0.200
    11.696   232.102     0.200
    14.043   275.329     0.200
    14.833   280.310     0.200
     6.682   135.888     0.200
     7.882   156.724     0.200
     8.532   170.349     0.200
    10.416   207.159     0.200
     3.067    62.257     0.200
     6.677   135.573     0.200
     7.865   155.252     0.200
     8.521   170.878     0.200
     6.409   125.319     0.200
     3.825    74.752     0.200
     7.099   143.998     0.200
     8.340   166.026     0.200
     2.951    63.519     0.200
     3.170    62.188     0.200
     4.374    87.581     0.200
     4.810   103.070     0.200
     4.890   102.919     0.200
     5.144   103.397     0.200
     5.270   110.777     0.200
     5.736   115.442     0.200
     7.512   149.664     0.200
     8.377   170.304     0.200
    10.325   203.202     0.200
     7.784   152.002     0.200
     4.919   105.399     0.200
     6.543   130.079     0.200
     7.761   153.282     0.200
    11.312   228.293     0.200
     8.354   163.285     0.200
    10.379   203.985     0.200
    11.301   226.889     0.200
     6.541   132.460     0.200
     7.763   150.668     0.200
    10.400   203.547     0.200
    11.312   223.382     0.200
     2.906    59.801     0.200
     7.743   148.823     0.200
     8.345   165.710     0.200
    10.388   204.216     0.200
    11.294   227.543     0.200
     7.858   154.903     0.200
     8.544   168.303     0.200
     9.166   186.237     0.200
    10.383   202.851     0.200
    11.227   221.111     0.200
    16.123   317.323     0.200
     6.089   125.467     0.200
     7.875   157.168     0.200
     7.979   156.546     0.200
    11.059   225.760     0.200
     6.554   132.076     0.200
     8.428   168.368     0.200
    10.522   208.774     0.200
    10.974   218.292     0.200
     7.795   155.805     0.200
     8.378   162.727     0.200
    11.340   228.806     0.200
     6.567   134.103     0.200
     7.850   154.279     0.200
     8.414   166.773     0.200
    10.456   204.923     0.200
     8.356   168.171     0.200
    10.383   207.738     0.200
     7.746   150.810     0.200
    10.390   207.187     0.200
     7.937   156.104     0.200
     8.249   159.333     0.200
     7.898   153.038     0.200
     8.046   160.037     0.200
    10.731   214.623     0.200
    11.121   223.393     0.200
     8.021   158.698     0.200
    11.005   217.323     0.200
    11.198   224.476     0.200
     7.893   156.527     0.200
     7.950   153.970     0.200
     6.065   121.959     0.200
     7.963   158.047     0.200
     6.526   130.934     0.200
     7.772   150.156     0.200
     8.347   164.925     0.200
    10.416   206.278     0.200
     7.760   152.949     0.200
    10.414   206.112     0.200
    11.053   217.450     0.200
    11.290   226.761     0.200
    11.052   219.017     0.200
     8.340   166.344     0.200
    10.424   209.832     0.200
    11.054   216.708     0.200
     7.745   152.825     0.200
     8.320   162.565     0.200
     3.715    77.112     0.200
     6.535   131.863     0.200
     7.733   153.499     0.200
    10.379   205.624     0.200
    15.925   315.920     0.200
     7.711   151.811     0.200
     8.330   161.845     0.200
    11.269   224.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.103     4.714     0.200
     0.720    14.411     0.200
     1.186    23.294     0.200
     1.286    26.116     0.200
     1.290    27.703     0.200
     1.345    27.069     0.200
     1.347    28.965     0.200
     0.777    14.913     0.200
     1.173    24.033     0.200
     1.271    25.881     0.200
     1.275    27.420     0.200
     1.333    26.819     0.200
     0.758    15.717     0.200
     1.225    24.613     0.200
     1.324    26.641     0.200
     1.354    28.822     0.200
     1.379    28.028     0.200
     1.432    28.772     0.200
     0.740    13.575     0.200
     1.205    24.126     0.200
     1.308    26.107     0.200
     1.362    27.464     0.200
     1.367    27.611     0.200
     1.418    28.388     0.200
     3.775    71.009     0.200
     0.052     2.507     0.200
     0.086     2.913     0.200
     0.333     6.402     0.200
     0.378     7.043     0.200
     0.639    13.296     0.200
     0.681    14.056     0.200
     0.914    16.977     0.200
     0.954    19.235     0.200
     0.973    19.883     0.200
     1.102    22.168     0.200
     1.126    22.519     0.200
     1.327    24.942     0.200
     0.203     3.211     0.200
     0.179     4.484     0.200
     0.216     5.460     0.200
     0.396     7.961     0.200
     0.674    14.016     0.200
     0.762    15.716     0.200
     0.912    17.576     0.200
     0.912    17.170     0.200
     0.867    17.465     0.200
     0.990    19.123     0.200
     0.990    18.530     0.200
     1.013    20.292     0.200
     1.086    21.801     0.200
     1.201    22.895     0.200
     1.234    24.987     0.200
     1.306    24.956     0.200
     1.257    25.403     0.200
     1.537    29.417     0.200
     1.532    30.029     0.200
     1.665    31.170     0.200
     2.254    43.638     0.200
     3.534    67.085     0.200
     3.759    72.232     0.200
     5.934   112.659     0.200
     6.350   121.252     0.200
     0.080     3.089     0.200
     0.535    10.341     0.200
     0.535    10.598     0.200
     0.640    13.184     0.200
     0.749    15.283     0.200
     0.950    19.231     0.200
     1.098    22.071     0.200
     1.121    22.477     0.200
     1.697    34.121     0.200
     0.625    12.368     0.200
     0.641    12.535     0.200
     0.725    13.610     0.200
     0.725    13.849     0.200
     1.033    19.495     0.200
     1.151    22.072     0.200
     1.392    27.440     0.200
     1.408    26.232     0.200
     2.189    39.415     0.200
     2.776    51.023     0.200
     2.800    51.512     0.200
     2.855    51.941     0.200
     2.899    53.844     0.200
     2.913    53.291     0.200
     3.102    56.999     0.200
     3.297    60.498     0.200
     3.573    64.401     0.200
     0.024     3.471     0.200
     0.075     4.161     0.200
     0.625    12.330     0.200
     0.650    12.838     0.200
     0.733    13.687     0.200
     0.991    20.638     0.200
     1.039    19.911     0.200
     1.151    23.660     0.200
     1.398    29.815     0.200
     1.577    30.029     0.200
     1.850    34.594     0.200
     1.960    37.082     0.200
     2.192    41.003     0.200
     2.444    45.569     0.200
     2.478    46.004     0.200
     2.785    51.150     0.200
     2.780    51.645     0.200
     2.780    52.042     0.200
     2.807    53.145     0.200
     0.046     3.743     0.200
     0.627    12.451     0.200
     0.726    13.578     0.200
     1.012    21.269     0.200
     1.139    22.678     0.200
     1.156    22.622     0.200
     1.354    24.936     0.200
     1.342    27.284     0.200
     1.384    27.570     0.200
     1.558    29.477     0.200
     1.701    32.379     0.200
     1.937    36.913     0.200
     2.090    38.902     0.200
     2.469    45.815     0.200
     0.642    12.630     0.200
     0.636    12.773     0.200
     0.683    14.009     0.200
     0.740    13.786     0.200
     0.999    20.198     0.200
     1.021    19.926     0.200
     1.134    23.468     0.200
     1.155    22.578     0.200
     1.331    25.928     0.200
     1.400    27.159     0.200
     1.400    31.020     0.200
     1.559    29.740     0.200
     1.715    32.812     0.200
     1.860    34.803     0.200
     1.943    37.207     0.200
     2.105    38.853     0.200
     2.248    42.954     0.200
     2.455    45.422     0.200
     2.644    50.334     0.200
     2.762    51.585     0.200
     2.789    51.784     0.200
     2.944    56.125     0.200
     0.045     3.404     0.200
     0.635    12.667     0.200
     0.628    12.761     0.200
     0.726    13.678     0.200
     1.011    21.219     0.200
     1.020    19.359     0.200
     1.140    22.912     0.200
     1.157    22.374     0.200
     1.352    24.800     0.200
     1.343    27.187     0.200
     1.386    27.870     0.200
     1.414    29.216     0.200
     1.560    29.671     0.200
     1.846    34.263     0.200
     1.939    36.795     0.200
     2.090    38.598     0.200
     2.196    41.021     0.200
     2.443    45.649     0.200
     2.469    46.042     0.200
     2.762    51.157     0.200
     2.940    56.117     0.200
     0.045     2.191     0.200
     0.473    10.435     0.200
     0.627    12.209     0.200
     0.641    12.846     0.200
     0.732    13.571     0.200
     1.010    21.308     0.200
     1.016    19.106     0.200
     1.134    22.955     0.200
     1.152    21.823     0.200
     1.201    22.466     0.200
     1.337    26.833     0.200
     1.359    24.722     0.200
     1.379    27.977     0.200
     1.411    26.820     0.200
     1.852    34.613     0.200
     1.936    36.842     0.200
     2.095    38.288     0.200
     2.203    41.031     0.200
     2.475    45.958     0.200
     2.758    50.995     0.200
     2.783    52.256     0.200
     2.883    55.038     0.200
     0.031     3.019     0.200
     0.031     3.169     0.200
     0.643    12.527     0.200
     0.626    11.923     0.200
     0.728    13.698     0.200
     0.998    20.803     0.200
     1.035    19.282     0.200
     1.344    25.045     0.200
     1.346    27.147     0.200
     1.390    27.822     0.200
     1.574    29.743     0.200
     1.846    34.250     0.200
     1.954    36.926     0.200
     2.094    38.192     0.200
     2.776    51.425     0.200
     2.802    52.477     0.200
     2.901    56.092     0.200
     2.956    55.380     0.200
     0.031     2.096     0.200
     0.632    12.749     0.200
     0.642    12.504     0.200
     0.659    13.871     0.200
     0.692    14.153     0.200
     0.734    13.413     0.200
     0.997    20.970     0.200
     1.031    19.530     0.200
     1.144    22.374     0.200
     1.165    22.638     0.200
     1.350    24.625     0.200
     1.339    27.123     0.200
     1.383    27.501     0.200
     1.852    34.700     0.200
     1.951    37.223     0.200
     2.197    41.376     0.200
     2.478    46.216     0.200
     2.772    52.232     0.200
     0.626    11.981     0.200
     0.643    12.606     0.200
     0.677    13.253     0.200
     0.736    15.623     0.200
     1.015    19.425     0.200
     1.133    22.984     0.200
     1.133    23.234     0.200
     1.151    22.970     0.200
     1.460    27.146     0.200
     1.411    28.411     0.200
     1.853    34.627     0.200
     2.096    38.471     0.200
     2.475    45.804     0.200
     2.756    50.560     0.200
     2.757    51.371     0.200
     2.782    52.083     0.200
     3.555    67.337     0.200
     0.729    16.432     0.200
     1.012    19.480     0.200
     1.466    26.989     0.200
     1.551    29.554     0.200
     1.709    32.260     0.200
     1.934    36.501     0.200
     2.102    38.318     0.200
     2.481    46.157     0.200
     2.754    51.426     0.200
     2.754    51.547     0.200
     2.780    51.685     0.200
     3.083    56.970     0.200
     3.281    60.976     0.200
     0.018     3.283     0.200
     0.018     3.783     0.200
     0.678    13.530     0.200
     0.635    12.850     0.200
     0.767    14.278     0.200
     1.053    20.364     0.200
     1.144    23.224     0.200
     1.179    22.730     0.200
     1.357    25.017     0.200
     1.499    27.949     0.200
     1.586    30.137     0.200
     1.607    29.852     0.200
     0.580    11.432     0.200
     0.744    14.472     0.200
     0.769    15.618     0.200
     0.752    16.984     0.200
     0.934    19.191     0.200
     1.203    22.710     0.200
     1.303    23.841     0.200
     1.561    28.772     0.200
     1.645    31.041     0.200
     2.026    36.589     0.200
     2.163    39.020     0.200
     0.198     3.103     0.200
     0.248     6.051     0.200
     1.122    22.754     0.200
     1.213    22.865     0.200
     1.177    24.339     0.200
     1.206    23.277     0.200
     1.206    24.727     0.200
     1.268    25.491     0.200
     3.027    56.914     0.200
     3.075    57.411     0.200
     0.060     2.030     0.200
     0.601    11.979     0.200
     0.774    14.667     0.200
     1.109    20.544     0.200
     1.187    23.260     0.200
     1.230    23.283     0.200
     1.330    26.111     0.200
     1.330    29.791     0.200
     1.587    29.728     0.200
     1.639    30.962     0.200
     1.879    35.044     0.200
     2.046    37.624     0.200
     2.146    39.390     0.200
     2.188    39.670     0.200
     4.507    86.687     0.200
     0.139     5.425     0.200
     0.652    12.611     0.200
     0.965    18.929     0.200
     1.013    19.345     0.200
     1.097    22.017     0.200
     1.324    26.439     0.200
     1.354    27.972     0.200
     1.354    28.198     0.200
     1.522    27.947     0.200
     1.541    29.519     0.200
     1.944    36.971     0.200
     2.130    39.199     0.200
     2.651    49.059     0.200
     2.748    50.235     0.200
     2.781    52.883     0.200
     3.092    57.590     0.200
     3.302    61.130     0.200
     3.533    65.298     0.200
     3.584    66.102     0.200
     0.481    10.052     0.200
     0.987    19.280     0.200
     0.997    19.891     0.200
     2.712    51.726     0.200
     2.765    50.438     0.200
     0.799    14.534     0.200
     0.799    14.998     0.200
     1.123    21.587     0.200
     1.187    23.709     0.200
     1.238    24.034     0.200
     1.537    28.895     0.200
     1.815    34.875     0.200
     2.054    39.515     0.200
     2.171    40.265     0.200
     2.856    52.394     0.200
     2.891    53.875     0.200
     2.981    56.066     0.200
     3.055    57.207     0.200
     3.791    72.145     0.200
     4.254    80.731     0.200
     0.265     6.194     0.200
     0.632    12.043     0.200
     1.088    22.666     0.200
     1.403    26.209     0.200
     2.671    49.376     0.200
     2.877    55.128     0.200
     2.914    55.452     0.200
     3.059    56.851     0.200
     4.216    81.974     0.200
     0.082     4.638     0.200
     0.086     4.628     0.200
     0.119     5.168     0.200
     0.499    10.093     0.200
     0.779    14.285     0.200
     1.089    21.023     0.200
     1.089    21.029     0.200
     1.167    23.285     0.200
     1.199    24.089     0.200
     1.210    23.601     0.200
     1.333    25.830     0.200
     1.333    27.809     0.200
     1.618    31.054     0.200
     2.150    39.669     0.200
     2.825    52.496     0.200
     2.857    52.699     0.200
     3.166    59.787     0.200
     0.090     3.616     0.200
     0.135     5.333     0.200
     0.084     4.625     0.200
     0.502    10.790     0.200
     0.793    14.666     0.200
     0.793    14.974     0.200
     1.098    21.331     0.200
     1.097    21.336     0.200
     1.167    23.129     0.200
     1.214    22.704     0.200
     1.316    25.075     0.200
     1.317    26.650     0.200
     2.831    52.340     0.200
     2.865    53.209     0.200
     3.811    72.611     0.200
     0.223     5.179     0.200
     0.226     5.095     0.200
     1.041    21.369     0.200
     1.124    22.772     0.200
     1.149    24.168     0.200
     1.150    23.373     0.200
     1.150    25.412     0.200
     1.150    26.502     0.200
     1.193    24.042     0.200
     1.223    22.839     0.200
     1.257    25.169     0.200
     1.697    31.780     0.200
     1.697    32.051     0.200
     3.045    56.585     0.200
     0.371     7.760     0.200
     0.371     8.237     0.200
     0.384     7.891     0.200
     0.381     9.520     0.200
     0.692    13.537     0.200
     0.692    13.541     0.200
     0.788    14.975     0.200
     0.778    15.236     0.200
     1.250    23.315     0.200
     1.294    25.362     0.200
     1.624    29.889     0.200
     2.439    45.580     0.200
     2.454    45.297     0.200
     2.601    48.080     0.200
     2.749    50.706     0.200
     0.253     4.625     0.200
     0.537    10.540     0.200
     0.536    10.545     0.200
     0.523    11.912     0.200
     0.709    14.127     0.200
     0.799    15.943     0.200
     0.918    17.468     0.200
     1.057    20.299     0.200
     1.385    26.556     0.200
     1.459    27.566     0.200
     1.671    32.612     0.200
     1.672    35.310     0.200
     1.811    34.971     0.200
     2.170    40.255     0.200
     2.408    44.907     0.200
     2.460    45.102     0.200
     2.607    48.709     0.200
     3.052    56.989     0.200
     3.081    59.218     0.200
     3.684    69.137     0.200
     0.149     5.229     0.200
     0.702    12.993     0.200
     0.832    17.448     0.200
     0.828    16.388     0.200
     0.861    17.257     0.200
     0.924    17.824     0.200
     1.333    25.239     0.200
     1.443    26.632     0.200
     1.448    29.278     0.200
     1.504    30.003     0.200
     2.075    37.081     0.200
     2.074    37.430     0.200
     5.343   103.626     0.200
     0.084     4.235     0.200
     0.035     3.906     0.200
     0.688    12.552     0.200
     0.784    15.060     0.200
     0.806    16.409     0.200
     0.806    17.026     0.200
     1.238    24.849     0.200
     1.426    26.750     0.200
     1.409    25.567     0.200
     1.409    27.281     0.200
     1.570    29.612     0.200
     2.060    38.372     0.200
     2.113    40.088     0.200
     2.870    53.300     0.200
     2.865    52.109     0.200
     2.865    52.109     0.200
     3.716    70.998     0.200
     0.101     4.163     0.200
     0.430     9.312     0.200
     0.494    10.448     0.200
     0.528    10.839     0.200
     1.017    19.630     0.200
     1.239    24.513     0.200
     1.321    26.703     0.200
     1.435    28.149     0.200
     1.449    30.440     0.200
     1.481    29.001     0.200
     0.022     4.366     0.200
     0.101     3.984     0.200
     0.416     8.379     0.200
     0.731    13.077     0.200
     0.784    16.894     0.200
     0.919    17.847     0.200
     1.692    32.329     0.200
     2.062    40.031     0.200
     2.896    54.204     0.200
     0.128     2.594     0.200
     0.142     3.198     0.200
     0.658    14.251     0.200
     0.734    15.061     0.200
     0.856    16.156     0.200
     1.137    23.362     0.200
     1.126    21.659     0.200
     1.161    23.026     0.200
     1.229    23.444     0.200
     1.249    24.498     0.200
     1.249    26.032     0.200
     1.275    25.667     0.200
     1.642    30.830     0.200
     1.643    31.882     0.200
     2.065    39.379     0.200
     0.129     3.299     0.200
     0.658    13.907     0.200
     0.856    15.524     0.200
     1.127    21.557     0.200
     1.137    23.020     0.200
     1.161    22.959     0.200
     1.248    24.330     0.200
     1.229    23.735     0.200
     1.249    24.955     0.200
     1.276    25.371     0.200
     1.334    26.395     0.200
     1.643    32.799     0.200
     2.066    39.352     0.200
     2.132    41.183     0.200
     2.853    52.906     0.200
     2.894    53.876     0.200
     3.213    59.916     0.200
     0.073     2.031     0.200
     0.784    14.500     0.200
     1.317    25.672     0.200
     1.646    31.780     0.200
     2.157    39.965     0.200
     0.144     3.064     0.200
     0.160     3.670     0.200
     0.289     6.985     0.200
     0.791    14.812     0.200
     0.873    16.945     0.200
     1.129    22.118     0.200
     1.227    23.795     0.200
     1.232    24.724     0.200
     1.384    26.868     0.200
     1.387    25.973     0.200
     1.652    32.263     0.200
     1.652    31.036     0.200
     1.611    30.939     0.200
     1.819    33.494     0.200
     2.137    41.494     0.200
     2.782    53.110     0.200
     0.162     3.411     0.200
     0.876    16.540     0.200
     1.135    21.994     0.200
     1.228    25.327     0.200
     1.252    26.335     0.200
     1.398    27.833     0.200
     2.306    44.195     0.200
     2.967    56.425     0.200
     3.031    56.015     0.200
     3.028    56.306     0.200
     3.096    57.041     0.200
     3.254    61.349     0.200
     3.299    60.943     0.200
     0.230     5.818     0.200
     0.190     5.246     0.200
     0.928    18.501     0.200
     1.149    23.707     0.200
     1.149    25.242     0.200
     1.349    25.544     0.200
     1.780    33.382     0.200
     1.976    38.716     0.200
     2.936    54.194     0.200
     2.970    55.853     0.200
     3.018    55.597     0.200
     3.344    63.137     0.200
     3.820    71.869     0.200
     3.888    75.580     0.200
     4.140    76.546     0.200
     4.415    85.250     0.200
     0.218     4.562     0.200
     1.163    23.269     0.200
     1.164    27.647     0.200
     1.169    22.863     0.200
     1.238    23.979     0.200
     1.261    23.920     0.200
     1.678    30.969     0.200
     1.715    33.825     0.200
     1.715    33.325     0.200
     2.123    39.697     0.200
     2.839    52.381     0.200
     2.890    53.709     0.200
     2.940    54.461     0.200
     3.073    59.373     0.200
     3.122    58.305     0.200
     3.269    61.170     0.200
     3.745    68.910     0.200
     0.202     3.781     0.200
     0.312     7.090     0.200
     1.087    21.718     0.200
     1.163    22.260     0.200
     1.230    24.798     0.200
     1.230    25.252     0.200
     1.527    27.942     0.200
     1.578    28.991     0.200
     0.312     5.989     0.200
     0.361     7.490     0.200
     0.654    12.073     0.200
     0.936    19.456     0.200
     0.968    18.716     0.200
     1.378    25.790     0.200
     1.378    25.185     0.200
     1.379    27.644     0.200
     1.802    33.722     0.200
     2.518    45.701     0.200
     2.587    48.539     0.200
     2.626    48.803     0.200
     2.948    54.117     0.200
     0.185     3.316     0.200
     0.488    11.111     0.200
     0.964    20.583     0.200
     0.964    19.773     0.200
     1.512    28.475     0.200
     1.573    30.163     0.200
     1.888    36.368     0.200
     1.993    38.165     0.200
     3.148    59.680     0.200
     3.205    60.337     0.200
     3.267    61.236     0.200
     3.460    66.842     0.200
     0.888    17.424     0.200
     1.057    20.471     0.200
     1.156    22.053     0.200
     1.264    27.837     0.200
     1.264    26.827     0.200
     1.585    30.283     0.200
     1.998    38.130     0.200
     2.240    42.152     0.200
     2.337    44.489     0.200
     2.712    50.192     0.200
     2.780    50.765     0.200
     2.822    52.110     0.200
     3.145    58.659     0.200
     3.368    63.173     0.200
     3.621    66.512     0.200
     4.219    78.667     0.200
     0.226     3.205     0.200
     0.720    14.318     0.200
     1.028    19.633     0.200
     1.045    20.908     0.200
     1.045    21.338     0.200
     1.118    21.227     0.200
     1.246    25.281     0.200
     1.534    28.212     0.200
     1.975    36.889     0.200
     2.247    44.079     0.200
     2.692    49.312     0.200
     2.718    51.522     0.200
     2.745    51.372     0.200
     2.791    51.381     0.200
     2.924    55.353     0.200
     2.973    55.068     0.200
     3.120    58.359     0.200
     3.596    65.722     0.200
     3.596    67.349     0.200
     4.206    80.611     0.200
     4.205    77.846     0.200
     0.148     3.549     0.200
     0.272     5.184     0.200
     1.105    22.960     0.200
     1.105    24.826     0.200
     1.224    24.582     0.200
     1.224    24.332     0.200
     1.717    31.868     0.200
     1.797    34.530     0.200
     2.204    41.571     0.200
     2.348    43.981     0.200
     2.962    54.544     0.200
     3.016    55.355     0.200
     3.153    59.604     0.200
     3.201    59.073     0.200
     3.825    69.484     0.200
     0.927    17.602     0.200
     1.155    23.445     0.200
     1.227    23.025     0.200
     1.756    31.897     0.200
     2.068    39.097     0.200
     2.171    41.261     0.200
     2.254    42.150     0.200
     2.300    42.501     0.200
     2.558    47.494     0.200
     2.885    54.412     0.200
     2.885    53.482     0.200
     2.942    54.832     0.200
     2.990    55.285     0.200
     3.120    58.785     0.200
     3.170    59.388     0.200
     3.317    62.031     0.200
     3.541    66.704     0.200
     3.770    70.512     0.200
     6.096   117.479     0.200
     0.366     6.834     0.200
     0.646    12.310     0.200
     0.784    15.168     0.200
     0.816    15.188     0.200
     0.909    16.877     0.200
     1.188    22.350     0.200
     1.182    22.263     0.200
     1.583    30.012     0.200
     1.549    28.980     0.200
     1.549    31.870     0.200
     1.550    30.719     0.200
     2.298    42.535     0.200
     2.567    48.691     0.200
     3.205    60.113     0.200
     3.815    71.990     0.200
     5.613   104.412     0.200
     0.473     8.813     0.200
     0.601    10.918     0.200
     0.778    15.067     0.200
     0.876    16.178     0.200
     0.893    17.817     0.200
     0.893    17.977     0.200
     1.131    21.303     0.200
     1.305    24.245     0.200
     1.450    28.199     0.200
     1.451    29.078     0.200
     2.448    48.609     0.200
     2.432    44.715     0.200
     2.545    46.745     0.200
     2.666    49.981     0.200
     2.716    50.328     0.200
     2.864    52.828     0.200
     2.977    54.795     0.200
     2.967    56.468     0.200
     3.091    56.721     0.200
     3.339    60.728     0.200
     3.339    63.350     0.200
     3.945    74.553     0.200
     0.602    11.502     0.200
     0.752    14.636     0.200
     0.781    15.408     0.200
     0.913    16.917     0.200
     1.145    21.606     0.200
     1.304    25.362     0.200
     1.594    31.558     0.200
     1.595    31.746     0.200
     2.249    41.132     0.200
     2.344    43.325     0.200
     2.484    46.369     0.200
     2.535    45.858     0.200
     3.157    60.875     0.200
     3.766    70.475     0.200
     6.581   122.161     0.200
     0.930    17.641     0.200
     1.181    22.720     0.200
     1.173    22.934     0.200
     1.164    23.787     0.200
     1.266    24.343     0.200
     1.683    31.992     0.200
     2.114    40.648     0.200
     2.127    40.163     0.200
     2.895    53.779     0.200
     2.944    54.540     0.200
     3.077    58.482     0.200
     3.126    59.343     0.200
     3.814    73.377     0.200
     4.293    82.583     0.200
     4.638    89.133     0.200
     0.969    18.977     0.200
     1.388    27.270     0.200
     1.798    33.481     0.200
     2.513    46.132     0.200
     2.586    48.206     0.200
     2.624    48.158     0.200
     2.747    52.053     0.200
     2.797    52.803     0.200
     2.945    54.997     0.200
     3.041    58.412     0.200
     3.172    57.865     0.200
     3.420    62.827     0.200
     3.420    65.183     0.200
     4.026    78.255     0.200
     4.044    77.703     0.200
     1.033    21.877     0.200
     1.367    27.218     0.200
     1.367    26.278     0.200
     1.419    26.689     0.200
     1.490    28.887     0.200
     1.909    35.736     0.200
     1.956    35.754     0.200
     2.368    44.838     0.200
     3.084    57.678     0.200
     3.073    57.308     0.200
     3.121    58.234     0.200
     3.178    59.231     0.200
     3.257    59.438     0.200
     3.365    62.167     0.200
     5.425    99.785     0.200
     6.204   116.708     0.200
     0.320     5.926     0.200
     0.600    11.504     0.200
     0.751    14.634     0.200
     1.136    21.354     0.200
     1.144    21.328     0.200
     1.307    25.852     0.200
     1.597    29.533     0.200
     2.247    40.971     0.200
     2.368    43.533     0.200
     0.321     6.716     0.200
     0.871    16.018     0.200
     1.114    22.315     0.200
     1.083    20.831     0.200
     1.252    26.101     0.200
     1.596    29.848     0.200
     1.610    31.402     0.200
     1.606    29.238     0.200
     1.863    35.403     0.200
     2.025    38.936     0.200
     2.241    41.402     0.200
     2.738    51.401     0.200
     2.807    51.868     0.200
     2.849    52.969     0.200
     2.781    48.547     0.200
     3.172    59.329     0.200
     3.647    66.401     0.200
     0.567    11.280     0.200
     0.733    14.021     0.200
     0.809    16.159     0.200
     1.089    21.211     0.200
     1.118    20.922     0.200
     1.644    30.640     0.200
     2.204    40.847     0.200
     2.312    43.016     0.200
     2.333    43.366     0.200
     2.441    45.740     0.200
     0.313     5.699     0.200
     0.449    10.782     0.200
     0.606    11.790     0.200
     0.761    14.709     0.200
     0.898    17.133     0.200
     1.153    21.812     0.200
     1.536    30.149     0.200
     1.603    30.346     0.200
     2.249    42.578     0.200
     0.194     3.566     0.200
     0.237     5.696     0.200
     0.624    13.191     0.200
     0.732    13.677     0.200
     0.945    17.941     0.200
     1.082    22.052     0.200
     1.145    22.866     0.200
     1.145    22.623     0.200
     1.145    25.501     0.200
     1.188    23.083     0.200
     1.188    23.372     0.200
     1.204    23.025     0.200
     1.244    24.704     0.200
     1.285    24.182     0.200
     1.312    26.241     0.200
     1.703    32.129     0.200
     1.742    32.620     0.200
     2.150    40.965     0.200
     2.867    53.220     0.200
     2.915    53.876     0.200
     2.965    55.040     0.200
     3.296    61.620     0.200
     3.772    68.807     0.200
     0.156     2.552     0.200
     0.683    12.819     0.200
     0.656    14.399     0.200
     1.115    21.915     0.200
     1.100    22.863     0.200
     1.115    23.721     0.200
     1.115    24.811     0.200
     1.115    26.201     0.200
     1.242    24.552     0.200
     1.274    25.724     0.200
     1.347    26.412     0.200
     1.764    32.540     0.200
     2.213    42.435     0.200
     2.929    55.262     0.200
     2.976    56.017     0.200
     3.028    56.234     0.200
     3.163    59.540     0.200
     3.359    63.071     0.200
     0.134     3.484     0.200
     0.984    19.890     0.200
     1.056    20.930     0.200
     1.056    21.098     0.200
     1.056    25.128     0.200
     1.132    22.702     0.200
     1.330    25.618     0.200
     1.343    25.121     0.200
     1.343    25.961     0.200
     1.343    27.731     0.200
     1.387    27.002     0.200
     1.461    27.332     0.200
     1.880    35.364     0.200
     1.921    36.556     0.200
     2.334    44.367     0.200
     3.050    56.778     0.200
     3.092    57.751     0.200
     3.147    58.391     0.200
     3.332    62.297     0.200
     3.480    64.873     0.200
     3.674    70.592     0.200
     3.706    69.202     0.200
     3.956    72.453     0.200
     6.218   118.809     0.200
     0.127     3.114     0.200
     0.315     5.687     0.200
     0.629    13.370     0.200
     0.758    14.180     0.200
     0.855    16.013     0.200
     0.870    16.266     0.200
     1.093    21.030     0.200
     1.113    22.591     0.200
     1.123    22.247     0.200
     1.192    22.794     0.200
     1.245    24.795     0.200
     1.606    30.459     0.200
     1.866    35.146     0.200
     2.034    38.818     0.200
     2.747    51.170     0.200
     2.793    52.208     0.200
     2.816    52.274     0.200
     2.859    53.313     0.200
     3.181    59.589     0.200
     3.402    64.105     0.200
     3.656    67.432     0.200
     3.656    69.276     0.200
     4.204    79.954     0.200
     5.490   105.713     0.200
     7.063   136.223     0.200
     0.273     5.827     0.200
     0.353     6.980     0.200
     0.636    12.363     0.200
     0.681    14.378     0.200
     0.778    15.119     0.200
     0.817    15.648     0.200
     0.906    16.946     0.200
     1.162    23.217     0.200
     1.175    22.193     0.200
     1.562    30.180     0.200
     1.563    33.759     0.200
     2.286    41.895     0.200
     2.521    47.503     0.200
     2.571    47.376     0.200
     6.618   123.822     0.200
     0.249     5.652     0.200
     0.299     5.401     0.200
     0.588    11.533     0.200
     0.727    14.915     0.200
     0.802    15.882     0.200
     0.905    16.995     0.200
     1.201    23.969     0.200
     1.201    24.427     0.200
     1.201    24.702     0.200
     1.326    25.325     0.200
     1.618    32.592     0.200
     1.870    35.373     0.200
     2.230    41.400     0.200
     2.332    42.767     0.200
     0.220     4.149     0.200
     0.216     5.298     0.200
     0.604    13.162     0.200
     0.759    14.456     0.200
     0.765    15.119     0.200
     0.850    15.962     0.200
     1.070    21.240     0.200
     1.160    24.530     0.200
     1.160    27.224     0.200
     1.154    21.815     0.200
     1.154    22.885     0.200
     1.166    22.607     0.200
     1.224    24.443     0.200
     1.249    23.386     0.200
     1.289    25.702     0.200
     1.666    30.799     0.200
     1.708    31.078     0.200
     2.133    40.044     0.200
     2.133    40.943     0.200
     2.114    40.604     0.200
     2.830    52.758     0.200
     2.843    53.816     0.200
     2.878    53.800     0.200
     2.928    54.717     0.200
     0.155     4.526     0.200
     1.004    20.382     0.200
     1.073    20.127     0.200
     1.063    22.731     0.200
     1.063    22.149     0.200
     1.063    21.698     0.200
     1.153    23.503     0.200
     1.367    27.172     0.200
     1.406    26.903     0.200
     1.901    36.054     0.200
     2.352    45.413     0.200
     3.070    57.362     0.200
     3.114    58.298     0.200
     3.167    58.927     0.200
     0.293     6.544     0.200
     0.344     6.333     0.200
     0.649    12.548     0.200
     0.798    15.418     0.200
     0.882    16.474     0.200
     0.882    16.224     0.200
     1.181    24.302     0.200
     1.192    22.353     0.200
     1.197    24.238     0.200
     1.205    24.317     0.200
     1.268    24.019     0.200
     1.571    31.661     0.200
     2.292    42.311     0.200
     2.529    47.566     0.200
     2.728    50.424     0.200
     2.924    53.029     0.200
     2.951    54.466     0.200
     3.805    73.485     0.200
     1.001    22.984     0.200
     1.411    27.316     0.200
     1.475    29.660     0.200
     1.542    30.936     0.200
     3.421    65.653     0.200
     0.181     4.697     0.200
     0.261     4.847     0.200
     0.261     4.961     0.200
     0.486     9.639     0.200
     0.656    12.826     0.200
     0.896    16.669     0.200
     1.026    20.008     0.200
     1.038    19.849     0.200
     1.416    27.056     0.200
     1.414    27.190     0.200
     1.685    32.653     0.200
     2.132    39.581     0.200
     2.171    40.499     0.200
     2.253    42.833     0.200
     2.564    47.753     0.200
     2.794    52.358     0.200
     0.116     2.987     0.200
     0.530    10.584     0.200
     1.001    20.627     0.200
     1.018    19.626     0.200
     1.001    21.515     0.200
     1.001    22.736     0.200
     1.001    23.175     0.200
     1.109    20.735     0.200
     1.316    26.650     0.200
     1.357    26.545     0.200
     1.424    27.394     0.200
     1.908    36.432     0.200
     1.969    37.561     0.200
     2.374    45.048     0.200
     3.067    57.244     0.200
     3.093    57.807     0.200
     3.120    58.149     0.200
     3.179    58.996     0.200
     0.165     5.670     0.200
     0.193     4.417     0.200
     0.210     5.179     0.200
     0.218     4.366     0.200
     0.294     7.391     0.200
     0.363     9.008     0.200
     0.454    10.402     0.200
     0.610    13.354     0.200
     1.077    22.095     0.200
     1.166    22.980     0.200
     1.158    23.178     0.200
     1.166    24.029     0.200
     1.166    26.826     0.200
     1.230    24.984     0.200
     1.295    25.797     0.200
     1.620    30.800     0.200
     2.033    38.238     0.200
     0.210     4.274     0.200
     0.209     4.568     0.200
     0.223     6.410     0.200
     1.170    21.587     0.200
     1.170    26.112     0.200
     1.175    23.031     0.200
     1.175    23.771     0.200
     1.265    24.092     0.200
     1.714    32.095     0.200
     2.113    39.571     0.200
     2.125    40.646     0.200
     2.280    42.240     0.200
     2.466    46.775     0.200
     2.575    48.242     0.200
     4.449    83.272     0.200
     0.286     5.302     0.200
     0.274     5.827     0.200
     0.455     9.949     0.200
     0.538    10.993     0.200
     0.604    11.629     0.200
     0.769    14.773     0.200
     1.156    21.748     0.200
     1.228    24.304     0.200
     1.226    24.587     0.200
     1.223    24.079     0.200
     1.329    26.244     0.200
     1.526    28.790     0.200
     1.629    29.453     0.200
     1.629    29.592     0.200
     2.474    45.524     0.200
     2.527    46.412     0.200
     3.148    58.983     0.200
     3.746    71.004     0.200
     3.913    75.063     0.200
     4.220    81.137     0.200
     6.560   125.647     0.200
     0.270     5.892     0.200
     0.352     6.856     0.200
     0.422     9.771     0.200
     0.633    12.112     0.200
     0.746    14.640     0.200
     0.776    14.795     0.200
     1.172    21.779     0.200
     1.162    23.352     0.200
     1.175    23.548     0.200
     1.181    23.508     0.200
     1.270    24.197     0.200
     2.284    41.969     0.200
     2.402    44.439     0.200
     2.518    46.922     0.200
     2.716    50.022     0.200
     0.205     4.841     0.200
     0.205     2.771     0.200
     0.207     3.142     0.200
     0.227     3.327     0.200
     0.765    14.351     0.200
     0.850    15.996     0.200
     1.175    22.397     0.200
     1.172    23.001     0.200
     1.172    23.610     0.200
     1.174    25.129     0.200
     2.120    40.547     0.200
     2.115    41.002     0.200
     2.294    42.718     0.200
     2.835    53.175     0.200
     2.858    53.247     0.200
     2.890    53.344     0.200
     2.938    54.626     0.200
     3.106    56.476     0.200
     3.119    57.894     0.200
     3.266    60.582     0.200
     3.742    68.392     0.200
     4.283    80.868     0.200
     4.343    84.304     0.200
     6.353   121.869     0.200
     0.134     4.074     0.200
     0.134     4.634     0.200
     0.188     4.298     0.200
     0.332     7.414     0.200
     0.604    12.950     0.200
     0.663    13.469     0.200
     0.734    14.144     0.200
     0.872    17.572     0.200
     1.059    20.270     0.200
     1.086    21.154     0.200
     1.086    22.174     0.200
     1.091    21.882     0.200
     1.155    22.260     0.200
     1.217    24.144     0.200
     1.252    23.770     0.200
     1.252    24.780     0.200
     1.270    25.047     0.200
     1.570    29.570     0.200
     1.592    30.856     0.200
     2.002    37.991     0.200
     2.252    41.454     0.200
     2.717    50.397     0.200
     2.756    51.487     0.200
     2.780    51.464     0.200
     2.824    51.963     0.200
     0.213     4.938     0.200
     0.240     4.184     0.200
     0.854    16.612     0.200
     0.955    17.949     0.200
     1.148    22.348     0.200
     1.148    25.932     0.200
     1.148    23.141     0.200
     1.144    22.118     0.200
     1.144    22.667     0.200
     1.163    21.925     0.200
     1.694    31.991     0.200
     1.660    31.447     0.200
     1.710    32.695     0.200
     1.710    32.957     0.200
     2.112    40.373     0.200
     2.328    43.377     0.200
     2.612    48.604     0.200
     2.830    52.935     0.200
     2.834    52.535     0.200
     2.872    53.554     0.200
     2.924    54.607     0.200
     3.062    58.606     0.200
     3.109    57.398     0.200
     3.257    60.447     0.200
     3.490    64.811     0.200
     3.846    73.193     0.200
     0.157     3.399     0.200
     0.304     6.955     0.200
     0.762    14.698     0.200
     1.081    20.237     0.200
     1.095    22.219     0.200
     1.076    21.869     0.200
     1.172    22.427     0.200
     1.209    24.004     0.200
     1.225    23.995     0.200
     1.225    24.918     0.200
     1.225    26.519     0.200
     1.265    25.062     0.200
     1.587    30.102     0.200
     1.619    31.005     0.200
     1.890    35.779     0.200
     2.026    38.653     0.200
     2.196    41.322     0.200
     2.273    42.464     0.200
     2.568    48.506     0.200
     2.742    51.362     0.200
     2.798    52.100     0.200
     3.025    56.751     0.200
     3.172    59.006     0.200
     3.400    63.687     0.200
     3.885    72.768     0.200
     4.252    81.088     0.200
     0.220     3.555     0.200
     0.226     4.833     0.200
     0.206     4.681     0.200
     0.635    13.451     0.200
     0.876    17.158     0.200
     1.095    22.534     0.200
     1.158    22.115     0.200
     1.158    23.997     0.200
     1.158    24.727     0.200
     1.158    26.102     0.200
     1.158    21.969     0.200
     1.201    22.761     0.200
     1.193    22.596     0.200
     1.193    23.135     0.200
     1.255    25.549     0.200
     1.286    24.354     0.200
     1.322    26.131     0.200
     1.703    32.614     0.200
     1.735    33.435     0.200
     1.735    33.068     0.200
     2.147    41.618     0.200
     2.862    53.640     0.200
     3.145    58.692     0.200
     0.271     5.887     0.200
     0.298     5.734     0.200
     0.533    11.424     0.200
     0.607    11.885     0.200
     0.734    14.956     0.200
     0.769    15.062     0.200
     0.832    16.769     0.200
     0.832    16.660     0.200
     1.157    21.674     0.200
     1.211    24.094     0.200
     1.216    23.857     0.200
     1.218    23.774     0.200
     1.319    25.342     0.200
     1.533    28.905     0.200
     1.617    30.237     0.200
     1.617    32.108     0.200
     1.618    32.648     0.200
     1.879    35.275     0.200
     2.243    41.416     0.200
     2.352    43.361     0.200
     2.448    46.422     0.200
     2.533    45.798     0.200
     2.681    49.304     0.200
     2.901    53.842     0.200
     3.155    57.761     0.200
     0.125     3.631     0.200
     0.160     3.813     0.200
     0.315     6.916     0.200
     0.633    13.540     0.200
     0.701    13.896     0.200
     0.759    14.255     0.200
     0.867    16.392     0.200
     1.116    22.975     0.200
     1.096    21.153     0.200
     1.127    22.438     0.200
     1.195    22.868     0.200
     1.250    23.818     0.200
     1.251    28.039     0.200
     1.251    24.789     0.200
     1.249    24.952     0.200
     1.609    30.461     0.200
     1.619    31.195     0.200
     2.036    38.737     0.200
     2.166    41.224     0.200
     2.238    41.068     0.200
     2.748    51.660     0.200
     2.796    50.452     0.200
     2.819    51.879     0.200
     2.862    52.477     0.200
     3.036    57.272     0.200
     3.183    59.748     0.200
     3.851    71.042     0.200
     3.851    73.100     0.200
     0.272     6.312     0.200
     0.450     9.803     0.200
     0.607    11.788     0.200
     0.736    14.967     0.200
     0.769    15.044     0.200
     0.793    15.788     0.200
     0.834    16.350     0.200
     1.157    21.989     0.200
     1.214    24.593     0.200
     1.218    24.449     0.200
     1.220    24.710     0.200
     1.320    25.318     0.200
     1.361    25.470     0.200
     1.532    29.338     0.200
     1.619    32.552     0.200
     1.619    30.739     0.200
     1.877    35.345     0.200
     2.242    41.730     0.200
     2.480    46.463     0.200
     2.532    45.906     0.200
     3.154    58.795     0.200
     0.144     4.527     0.200
     0.288     5.915     0.200
     0.846    16.817     0.200
     1.100    21.438     0.200
     1.215    24.778     0.200
     1.215    24.457     0.200
     1.215    22.989     0.200
     1.324    24.614     0.200
     1.699    32.051     0.200
     1.743    32.482     0.200
     1.794    33.439     0.200
     2.075    39.220     0.200
     2.111    40.460     0.200
     2.119    40.267     0.200
     2.158    40.925     0.200
     2.765    52.550     0.200
     2.955    54.914     0.200
     3.181    60.443     0.200
     3.820    69.076     0.200
     0.145     3.519     0.200
     0.415     8.297     0.200
     0.573    11.380     0.200
     1.008    20.264     0.200
     1.049    21.787     0.200
     1.049    20.045     0.200
     1.049    24.185     0.200
     1.049    20.036     0.200
     1.143    23.672     0.200
     1.345    26.762     0.200
     1.365    25.904     0.200
     1.365    27.576     0.200
     1.411    26.693     0.200
     1.428    27.981     0.200
     1.904    35.993     0.200
     2.386    44.635     0.200
     3.171    59.491     0.200
     0.153     3.312     0.200
     0.399     8.647     0.200
     0.590    11.666     0.200
     0.998    19.875     0.200
     1.065    22.713     0.200
     1.065    22.033     0.200
     1.065    22.083     0.200
     1.065    24.040     0.200
     1.041    20.580     0.200
     1.151    23.378     0.200
     1.349    27.017     0.200
     1.361    27.007     0.200
     1.361    27.296     0.200
     1.400    27.119     0.200
     1.432    28.239     0.200
     1.934    34.428     0.200
     0.158     2.746     0.200
     0.406     8.843     0.200
     0.406     9.933     0.200
     0.586    11.679     0.200
     1.007    20.162     0.200
     1.064    22.050     0.200
     1.065    22.190     0.200
     1.065    25.350     0.200
     1.156    23.488     0.200
     1.356    27.543     0.200
     1.370    27.612     0.200
     1.370    28.303     0.200
     1.409    26.822     0.200
     1.439    28.721     0.200
     2.355    45.299     0.200
     3.069    58.009     0.200
     3.117    59.461     0.200
     3.170    59.175     0.200
     3.501    65.342     0.200
     3.724    68.792     0.200
     3.977    72.878     0.200
     0.142     3.608     0.200
     0.305     7.462     0.200
     0.884    17.239     0.200
     1.100    23.383     0.200
     1.100    22.270     0.200
     1.100    22.462     0.200
     1.099    22.004     0.200
     1.100    22.939     0.200
     1.256    25.608     0.200
     1.256    24.487     0.200
     1.256    24.069     0.200
     1.278    25.510     0.200
     1.353    26.758     0.200
     1.823    35.601     0.200
     0.152     3.624     0.200
     0.188     3.801     0.200
     0.607    13.816     0.200
     0.700    14.086     0.200
     0.739    14.886     0.200
     0.895    17.183     0.200
     1.089    22.476     0.200
     1.097    21.046     0.200
     1.113    22.199     0.200
     1.190    23.215     0.200
     1.224    24.598     0.200
     1.225    23.312     0.200
     1.225    24.562     0.200
     1.225    25.325     0.200
     1.282    25.735     0.200
     1.605    30.456     0.200
     2.041    38.553     0.200
     2.266    42.528     0.200
     2.299    42.901     0.200
     2.789    51.887     0.200
     2.816    52.357     0.200
     2.862    53.464     0.200
     0.146     5.356     0.200
     0.302     7.998     0.200
     0.338     7.062     0.200
     0.702    15.014     0.200
     0.933    19.298     0.200
     1.094    22.451     0.200
     1.094    22.969     0.200
     1.094    24.899     0.200
     1.130    22.743     0.200
     1.305    25.874     0.200
     1.305    25.575     0.200
     1.317    25.841     0.200
     1.394    27.667     0.200
     3.230    62.297     0.200
     3.279    61.986     0.200
     3.700    70.230     0.200
     4.500    84.947     0.200
     6.193   118.780     0.200
     6.238   118.264     0.200
     0.210     4.935     0.200
     0.210     5.089     0.200
     0.534    10.378     0.200
     0.522    10.689     0.200
     0.699    13.715     0.200
     0.780    15.178     0.200
     0.851    16.331     0.200
     1.191    23.429     0.200
     1.197    23.928     0.200
     1.211    24.176     0.200
     1.373    25.709     0.200
     1.373    28.039     0.200
     1.464    27.155     0.200
     1.653    31.139     0.200
     1.654    33.336     0.200
     2.178    40.324     0.200
     2.301    42.473     0.200
     2.413    45.010     0.200
     2.464    45.386     0.200
     2.611    48.508     0.200
     2.839    52.423     0.200
     3.086    56.982     0.200
     3.487    64.635     0.200
     3.695    69.466     0.200
     3.876    73.118     0.200
     5.635   105.300     0.200
     6.511   122.238     0.200
     0.279     6.640     0.200
     0.369     8.065     0.200
     0.401     8.870     0.200
     0.432     8.529     0.200
     0.784    14.868     0.200
     0.898    17.949     0.200
     0.898    18.167     0.200
     1.120    22.379     0.200
     1.173    23.867     0.200
     1.197    23.928     0.200
     1.320    24.960     0.200
     1.320    25.074     0.200
     1.311    24.418     0.200
     1.447    27.482     0.200
     1.447    26.443     0.200
     1.448    29.452     0.200
     1.448    31.343     0.200
     1.723    32.805     0.200
     2.074    39.854     0.200
     2.437    44.942     0.200
     2.552    47.169     0.200
     2.640    50.722     0.200
     2.722    51.471     0.200
     2.870    53.361     0.200
     3.097    57.938     0.200
     0.247     5.422     0.200
     0.256     5.496     0.200
     0.299     5.513     0.200
     0.469    11.244     0.200
     0.554    11.520     0.200
     0.587    11.247     0.200
     0.727    15.010     0.200
     1.115    21.337     0.200
     1.200    23.812     0.200
     1.200    23.971     0.200
     1.201    23.769     0.200
     1.516    28.337     0.200
     1.619    30.509     0.200
     2.228    41.421     0.200
     2.354    44.396     0.200
     2.664    49.569     0.200
     2.888    53.346     0.200
     0.252     5.495     0.200
     0.299     5.635     0.200
     0.557    11.213     0.200
     0.583    11.206     0.200
     1.114    20.967     0.200
     1.130    21.055     0.200
     1.197    23.776     0.200
     1.197    24.291     0.200
     1.199    23.937     0.200
     1.199    25.098     0.200
     1.619    30.575     0.200
     1.620    32.293     0.200
     1.620    32.883     0.200
     1.620    34.324     0.200
     2.226    41.117     0.200
     2.351    43.311     0.200
     2.661    49.372     0.200
     2.886    53.386     0.200
     3.102    57.372     0.200
     3.135    57.857     0.200
     0.122     2.812     0.200
     0.122     3.211     0.200
     0.155     3.541     0.200
     0.638    13.690     0.200
     0.704    14.402     0.200
     1.131    22.554     0.200
     1.131    22.663     0.200
     1.199    23.251     0.200
     1.254    24.090     0.200
     1.254    27.756     0.200
     1.254    28.545     0.200
     1.619    30.761     0.200
     1.619    32.120     0.200
     2.162    38.759     0.200
     0.220     4.441     0.200
     0.217     5.044     0.200
     0.280     5.226     0.200
     0.546    10.620     0.200
     0.709    13.969     0.200
     0.929    18.020     0.200
     1.037    20.072     0.200
     1.080    20.438     0.200
     1.362    27.362     0.200
     1.645    32.347     0.200
     1.645    33.487     0.200
     1.646    36.163     0.200
     1.646    31.893     0.200
     2.623    49.746     0.200
     0.161     4.012     0.200
     0.234     4.284     0.200
     0.568    12.616     0.200
     0.600    11.575     0.200
     0.600    11.715     0.200
     0.910    17.076     0.200
     0.903    16.311     0.200
     1.025    20.358     0.200
     1.025    21.378     0.200
     1.268    25.976     0.200
     1.269    25.439     0.200
     1.269    26.629     0.200
     2.270    44.779     0.200
     2.894    55.606     0.200
     2.942    54.679     0.200
     3.953    75.351     0.200
     4.174    80.319     0.200
     4.185    79.381     0.200
     0.182     3.815     0.200
     0.782    15.387     0.200
     0.805    15.614     0.200
     0.805    15.715     0.200
     1.140    21.846     0.200
     1.152    22.331     0.200
     1.152    22.839     0.200
     1.208    23.902     0.200
     1.208    23.259     0.200
     1.232    23.369     0.200
     1.247    24.887     0.200
     1.308    26.187     0.200
     1.669    31.839     0.200
     2.830    52.834     0.200
     2.859    53.430     0.200
     2.904    53.953     0.200
     2.975    54.860     0.200
     3.705    68.435     0.200
     0.440     9.654     0.200
     0.553    11.853     0.200
     1.037    22.445     0.200
     1.037    21.925     0.200
     1.037    24.117     0.200
     1.035    20.777     0.200
     1.152    23.423     0.200
     1.358    26.889     0.200
     1.388    27.312     0.200
     1.444    28.016     0.200
     1.511    29.044     0.200
     3.335    63.617     0.200
     0.140     3.780     0.200
     0.192     4.652     0.200
     0.564    12.509     0.200
     0.666    13.235     0.200
     0.764    15.169     0.200
     1.413    26.999     0.200
     1.687    33.674     0.200
     1.688    33.522     0.200
     2.421    43.156     0.200
     0.138     3.969     0.200
     0.196     4.890     0.200
     0.273     4.947     0.200
     0.517    10.116     0.200
     0.682    13.239     0.200
     0.682    13.480     0.200
     1.385    27.257     0.200
     1.385    28.116     0.200
     1.448    27.404     0.200
     2.163    39.613     0.200
     2.284    42.176     0.200
     2.595    48.702     0.200
     2.825    52.117     0.200
     3.035    55.897     0.200
     3.070    57.604     0.200
     3.681    68.282     0.200
     0.253     5.548     0.200
     0.247     5.693     0.200
     0.477    11.358     0.200
     0.561    12.341     0.200
     0.579    11.185     0.200
     0.742    14.311     0.200
     0.903    17.167     0.200
     1.209    24.382     0.200
     1.211    24.480     0.200
     1.506    29.029     0.200
     1.631    29.894     0.200
     1.632    30.155     0.200
     1.857    35.710     0.200
     2.218    41.337     0.200
     2.324    43.275     0.200
     2.346    44.012     0.200
     2.654    49.278     0.200
     2.768    52.829     0.200
     2.877    53.355     0.200
     3.128    57.825     0.200
     3.222    60.864     0.200
     3.731    70.845     0.200
     0.234     5.510     0.200
     0.478     9.662     0.200
     0.563    12.240     0.200
     0.577    11.155     0.200
     0.919    17.288     0.200
     1.190    24.109     0.200
     1.192    24.078     0.200
     1.330    25.021     0.200
     1.616    30.448     0.200
     1.618    35.202     0.200
     0.133     3.523     0.200
     0.228     5.080     0.200
     0.569    11.018     0.200
     0.572    11.665     0.200
     0.725    13.995     0.200
     0.723    14.897     0.200
     1.187    23.626     0.200
     1.189    23.853     0.200
     1.194    24.186     0.200
     1.337    27.704     0.200
     1.500    28.685     0.200
     1.622    30.569     0.200
     1.623    29.587     0.200
     1.623    32.787     0.200
     1.859    36.034     0.200
     2.215    40.824     0.200
     2.312    42.865     0.200
     2.450    46.690     0.200
     2.496    47.572     0.200
     2.500    46.168     0.200
     2.775    52.740     0.200
     2.876    53.070     0.200
     3.123    60.036     0.200
     3.910    75.587     0.200
     5.538   103.352     0.200
     5.625   106.477     0.200
     0.134     3.536     0.200
     0.198     4.419     0.200
     0.200     4.808     0.200
     0.685    13.248     0.200
     1.189    23.770     0.200
     1.197    23.857     0.200
     1.215    24.609     0.200
     1.386    26.626     0.200
     1.664    32.272     0.200
     1.665    33.649     0.200
     2.397    45.038     0.200
     2.448    44.695     0.200
     0.230     4.354     0.200
     0.233     4.653     0.200
     0.622    13.904     0.200
     0.622    13.664     0.200
     0.737    14.370     0.200
     0.797    15.675     0.200
     1.082    22.408     0.200
     1.149    24.032     0.200
     1.149    27.071     0.200
     1.184    23.161     0.200
     1.198    23.361     0.200
     1.243    25.304     0.200
     1.280    24.453     0.200
     1.310    25.766     0.200
     1.698    31.604     0.200
     1.736    33.408     0.200
     2.145    41.173     0.200
     2.315    44.160     0.200
     2.488    47.977     0.200
     2.861    53.547     0.200
     3.094    58.506     0.200
     3.143    58.410     0.200
     0.230     4.424     0.200
     0.233     4.773     0.200
     0.736    14.456     0.200
     1.083    22.256     0.200
     1.148    24.438     0.200
     1.186    23.730     0.200
     1.200    22.766     0.200
     1.244    25.129     0.200
     1.283    24.460     0.200
     1.312    26.108     0.200
     1.700    32.346     0.200
     1.738    33.349     0.200
     2.147    40.604     0.200
     2.876    52.932     0.200
     2.912    54.559     0.200
     0.144     3.932     0.200
     0.228     5.305     0.200
     0.228     5.076     0.200
     0.218     5.038     0.200
     0.565    11.013     0.200
     0.717    13.743     0.200
     0.717    13.933     0.200
     0.780    15.488     0.200
     0.948    18.351     0.200
     1.109    21.473     0.200
     1.108    20.717     0.200
     1.175    23.105     0.200
     1.177    22.920     0.200
     1.183    23.680     0.200
     1.499    27.999     0.200
     1.615    30.175     0.200
     1.617    30.882     0.200
     1.617    34.622     0.200
     2.215    40.942     0.200
     2.307    42.741     0.200
     2.333    43.146     0.200
     2.646    48.720     0.200
     2.694    50.056     0.200
     2.87