#!/bin/bash
gmt begin elmayor5.35_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance elmayor5.35'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6  0.000
  0.6 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    10.466
     0.600    11.887
     0.700    13.307
     0.800    14.727
     0.900    16.147
     1.000    17.568
     1.100    18.988
     1.200    20.408
     1.300    21.828
     1.400    23.249
     1.500    24.669
     1.600    26.089
     1.700    27.509
     1.800    28.930
     1.900    30.350
     2.000    31.770
     2.100    33.190
     2.200    34.611
     2.300    36.031
     2.400    37.451
     2.500    38.871
     2.600    40.292
     2.700    41.712
     2.800    43.132
     2.900    44.552
     3.000    45.973
     3.100    47.393
     3.200    48.813
     3.300    50.233
     3.400    51.654
     3.500    53.074
     3.600    54.494
     3.700    55.914
     3.800    57.333
     3.900    58.754
     4.000    60.174
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    52.494 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.499
     0.200     4.020
     0.300     5.714
     0.400     7.455
     0.500     9.202
     0.600    10.950
     0.700    12.698
     0.800    14.447
     0.900    16.195
     1.000    17.943
     1.100    19.691
     1.200    21.439
     1.300    23.187
     1.400    24.936
     1.500    26.684
     1.600    28.432
     1.700    30.180
     1.800    31.928
     1.900    33.677
     2.000    35.425
     2.100    37.173
     2.200    38.921
     2.300    40.669
     2.400    42.417
     2.500    44.165
     2.600    45.913
     2.700    47.661
     2.800    49.409
     2.900    51.156
     3.000    52.904
     3.100    54.652
     3.200    56.400
     3.300    58.147
     3.400    59.895
     3.500    61.643
     3.600    63.390
     3.700    65.138
     3.800    66.886
     3.900    68.633
     4.000    70.380
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    62.390 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    18.462
     0.600    20.951
     0.700    23.440
     0.800    25.930
     0.900    28.419
     1.000    30.909
     1.100    33.398
     1.200    35.888
     1.300    38.377
     1.400    40.866
     1.500    43.356
     1.600    45.845
     1.700    48.335
     1.800    50.824
     1.900    53.314
     2.000    55.803
     2.100    58.292
     2.200    60.782
     2.300    63.271
     2.400    65.761
     2.500    68.250
     2.600    70.740
     2.700    73.229
     2.800    75.718
     2.900    78.208
     3.000    80.697
     3.100    83.187
     3.200    85.676
     3.300    88.165
     3.400    90.655
     3.500    93.144
     3.600    95.634
     3.700    98.122
     3.800   100.611
     3.900   103.100
     4.000   105.588
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    93.634 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.419
     0.200     7.106
     0.300    10.101
     0.400    13.174
     0.500    16.256
     0.600    19.339
     0.700    22.423
     0.800    25.506
     0.900    28.590
     1.000    31.674
     1.100    34.757
     1.200    37.841
     1.300    40.924
     1.400    44.008
     1.500    47.091
     1.600    50.175
     1.700    53.259
     1.800    56.342
     1.900    59.426
     2.000    62.509
     2.100    65.593
     2.200    68.676
     2.300    71.759
     2.400    74.843
     2.500    77.926
     2.600    81.009
     2.700    84.092
     2.800    87.175
     2.900    90.258
     3.000    93.341
     3.100    96.424
     3.200    99.507
     3.300   102.590
     3.400   105.673
     3.500   108.755
     3.600   111.838
     3.700   114.920
     3.800   118.003
     3.900   121.085
     4.000   124.167
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   110.838 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    12.875
     0.700    14.295
     0.800    15.716
     0.900    17.136
     1.000    18.556
     1.100    19.976
     1.200    21.397
     1.300    22.817
     1.400    24.237
     1.500    25.657
     1.600    27.078
     1.700    28.498
     1.800    29.918
     1.900    31.338
     2.000    32.759
     2.100    34.179
     2.200    35.599
     2.300    37.020
     2.400    38.440
     2.500    39.860
     2.600    41.280
     2.700    42.701
     2.800    44.121
     2.900    45.541
     3.000    46.961
     3.100    48.382
     3.200    49.802
     3.300    51.222
     3.400    52.642
     3.500    54.063
     3.600    55.483
     3.700    56.903
     3.800    58.323
     3.900    59.743
     4.000    61.162
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.827
     0.200     3.648
     0.300     5.470
     0.400     7.292
     0.500     9.115
     0.600    10.937
     0.700    12.760
     0.800    14.583
     0.900    16.405
     1.000    18.228
     1.100    20.050
     1.200    21.862
     1.300    23.611
     1.400    25.359
     1.500    27.107
     1.600    28.855
     1.700    30.604
     1.800    32.352
     1.900    34.100
     2.000    35.848
     2.100    37.597
     2.200    39.345
     2.300    41.093
     2.400    42.841
     2.500    44.589
     2.600    46.337
     2.700    48.086
     2.800    49.834
     2.900    51.582
     3.000    53.330
     3.100    55.077
     3.200    56.825
     3.300    58.573
     3.400    60.321
     3.500    62.069
     3.600    63.817
     3.700    65.565
     3.800    67.312
     3.900    69.060
     4.000    70.808
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    22.722
     0.700    25.211
     0.800    27.700
     0.900    30.190
     1.000    32.679
     1.100    35.169
     1.200    37.658
     1.300    40.148
     1.400    42.637
     1.500    45.126
     1.600    47.616
     1.700    50.105
     1.800    52.595
     1.900    55.084
     2.000    57.573
     2.100    60.063
     2.200    62.552
     2.300    65.042
     2.400    67.531
     2.500    70.021
     2.600    72.510
     2.700    74.999
     2.800    77.489
     2.900    79.978
     3.000    82.468
     3.100    84.957
     3.200    87.446
     3.300    89.936
     3.400    92.425
     3.500    94.915
     3.600    97.404
     3.700    99.894
     3.800   102.383
     3.900   104.872
     4.000   107.360
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.231
     0.200     6.450
     0.300     9.671
     0.400    12.893
     0.500    16.116
     0.600    19.338
     0.700    22.561
     0.800    25.783
     0.900    29.006
     1.000    32.229
     1.100    35.451
     1.200    38.610
     1.300    41.693
     1.400    44.777
     1.500    47.861
     1.600    50.945
     1.700    54.029
     1.800    57.113
     1.900    60.196
     2.000    63.280
     2.100    66.364
     2.200    69.448
     2.300    72.531
     2.400    75.614
     2.500    78.697
     2.600    81.781
     2.700    84.864
     2.800    87.947
     2.900    91.032
     3.000    94.115
     3.100    97.198
     3.200   100.281
     3.300   103.364
     3.400   106.447
     3.500   109.530
     3.600   112.613
     3.700   115.696
     3.800   118.778
     3.900   121.861
     4.000   124.944
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.400     8.393
     0.500     9.814
     0.600    11.234
     0.700    12.654
     0.800    14.074
     0.900    15.495
     1.000    16.915
     1.100    18.335
     1.200    19.755
     1.300    21.176
     1.400    22.596
     1.500    24.016
     1.600    25.436
     1.700    26.857
     1.800    28.277
     1.900    29.697
     2.000    31.117
     2.100    32.538
     2.200    33.958
     2.300    35.378
     2.400    36.798
     2.500    38.218
     2.600    39.639
     2.700    41.059
     2.800    42.479
     2.900    43.899
     3.000    45.320
     3.100    46.740
     3.200    48.160
     3.300    49.580
     3.400    51.001
     3.500    52.421
     3.600    53.841
     3.700    55.261
     3.800    56.681
     3.900    58.100
     4.000    59.520
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     3.353
     0.200     4.565
     0.300     6.067
     0.400     7.688
     0.500     9.366
     0.600    11.071
     0.700    12.792
     0.800    14.521
     0.900    16.256
     1.000    17.994
     1.100    19.734
     1.200    21.476
     1.300    23.219
     1.400    24.962
     1.500    26.707
     1.600    28.451
     1.700    30.196
     1.800    31.941
     1.900    33.687
     2.000    35.432
     2.100    37.178
     2.200    38.924
     2.300    40.670
     2.400    42.416
     2.500    44.162
     2.600    45.908
     2.700    47.654
     2.800    49.401
     2.900    51.147
     3.000    52.893
     3.100    54.639
     3.200    56.386
     3.300    58.132
     3.400    59.878
     3.500    61.624
     3.600    63.370
     3.700    65.117
     3.800    66.863
     3.900    68.609
     4.000    70.355
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.400    14.806
     0.500    17.296
     0.600    19.785
     0.700    22.274
     0.800    24.764
     0.900    27.253
     1.000    29.743
     1.100    32.232
     1.200    34.721
     1.300    37.211
     1.400    39.700
     1.500    42.190
     1.600    44.679
     1.700    47.169
     1.800    49.658
     1.900    52.147
     2.000    54.637
     2.100    57.126
     2.200    59.616
     2.300    62.105
     2.400    64.594
     2.500    67.084
     2.600    69.573
     2.700    72.063
     2.800    74.552
     2.900    77.042
     3.000    79.531
     3.100    82.020
     3.200    84.510
     3.300    86.999
     3.400    89.489
     3.500    91.978
     3.600    94.467
     3.700    96.956
     3.800    99.445
     3.900   101.933
     4.000   104.421
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.923
     0.200     8.063
     0.300    10.715
     0.400    13.578
     0.500    16.539
     0.600    19.549
     0.700    22.585
     0.800    25.637
     0.900    28.697
     1.000    31.763
     1.100    34.833
     1.200    37.905
     1.300    40.979
     1.400    44.054
     1.500    47.131
     1.600    50.208
     1.700    53.286
     1.800    56.365
     1.900    59.443
     2.000    62.522
     2.100    65.602
     2.200    68.681
     2.300    71.761
     2.400    74.841
     2.500    77.921
     2.600    81.001
     2.700    84.081
     2.800    87.161
     2.900    90.241
     3.000    93.321
     3.100    96.402
     3.200    99.482
     3.300   102.562
     3.400   105.642
     3.500   108.722
     3.600   111.802
     3.700   114.883
     3.800   117.963
     3.900   121.043
     4.000   124.123
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     1.485   936.590     0.150
     1.286   934.289     0.150
     2.058   936.484     0.150
     0.770   938.391     0.150
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.286    21.579     0.200
     1.286    23.270     0.200
     1.290    24.249     0.200
     1.345    24.020     0.200
     1.347    23.489     0.200
     1.582    25.359     0.200
     3.275    52.390     0.200
     5.244    78.659     0.200
     6.612    98.850     0.200
     6.713    97.760     0.200
     7.088   103.979     0.200
     7.167   104.390     0.200
     7.445   108.459     0.200
     7.475   108.699     0.200
     7.642   114.680     0.200
     7.738   114.459     0.200
     7.774   114.084     0.200
     7.774   113.760     0.200
     7.774   113.909     0.200
     8.030   118.979     0.200
     8.160   122.499     0.200
     8.183   121.760     0.200
     8.343   122.060     0.200
     8.419   120.699     0.200
     8.561   124.669     0.200
     8.637   128.959     0.200
     8.759   128.590     0.200
     9.187   136.659     0.200
     9.247   134.709     0.200
     9.231   133.510     0.200
     9.336   137.933     0.200
     9.336   138.569     0.200
     9.552   140.319     0.200
     9.585   140.359     0.200
     9.627   139.390     0.200
     9.667   140.159     0.200
     9.637   139.590     0.200
    10.312   152.959     0.200
    10.381   152.060     0.200
    10.421   149.859     0.200
    10.751   156.959     0.200
    10.874   160.079     0.200
    11.058   163.863     0.200
    11.305   166.129     0.200
    11.305   164.359     0.200
    11.497   167.949     0.200
    11.595   168.069     0.200
    11.595   166.060     0.200
    11.642   170.930     0.200
    11.793   171.919     0.200
    11.885   172.229     0.200
    11.888   172.329     0.200
    11.984   174.300     0.200
    12.043   174.939     0.200
    12.215   176.899     0.200
    12.535   184.109     0.200
    12.550   183.319     0.200
    12.566   183.930     0.200
    12.715   184.149     0.200
    12.741   186.159     0.200
    12.781   184.579     0.200
    12.830   188.989     0.200
    13.490   194.959     0.200
    13.947   197.459     0.200
    14.069   202.619     0.200
    14.461   208.229     0.200
    14.593   209.189     0.200
    14.770   211.899     0.200
    15.924   226.185     0.200
    15.924   225.659     0.200
    16.170   227.720     0.200
    16.549   233.399     0.200
    16.809   235.359     0.200
    17.477   244.779     0.200
    18.223   253.159     0.200
    19.426   272.359     0.200
    19.979   276.459     0.200
    20.639   281.970     0.200
     0.777    13.207     0.200
     1.173    21.207     0.200
     1.271    22.578     0.200
     1.278    22.695     0.200
     1.328    22.695     0.200
     1.333    23.488     0.200
     1.380    24.496     0.200
     1.584    24.848     0.200
     3.288    49.309     0.200
     3.805    55.215     0.200
     4.340    64.426     0.200
     4.634    68.277     0.200
     7.754   114.746     0.200
     7.789   111.938     0.200
     7.789   112.309     0.200
     7.945   115.309     0.200
     8.430   121.258     0.200
    10.768   155.727     0.200
    11.192   165.148     0.200
    11.321   167.137     0.200
    11.512   168.418     0.200
    13.137   189.465     0.200
     0.765    15.010     0.200
     1.327    24.961     0.200
     1.379    24.150     0.200
     1.432    25.590     0.200
     3.754    56.650     0.200
     4.349    65.391     0.200
     4.630    70.439     0.200
     5.273    79.830     0.200
     5.372    81.189     0.200
     5.582    82.451     0.200
     6.596    99.180     0.200
     7.050   104.121     0.200
     7.129   104.801     0.200
     7.327   108.311     0.200
     7.407   108.000     0.200
     7.437   108.561     0.200
     7.624   111.779     0.200
     7.737   112.541     0.200
     7.737   112.859     0.200
     7.717   113.490     0.200
     7.820   115.971     0.200
     8.145   119.150     0.200
     8.379   120.451     0.200
     8.342   122.631     0.200
     8.621   126.311     0.200
    10.723   154.020     0.200
    11.780   169.600     0.200
    11.875   172.041     0.200
    13.116   190.240     0.200
    14.625   208.311     0.200
    15.925   224.951     0.200
    16.684   233.109     0.200
     0.755    14.395     0.200
     1.308    23.293     0.200
     1.315    23.465     0.200
     1.362    23.625     0.200
     1.367    23.465     0.200
     1.418    25.164     0.200
     1.584    24.812     0.200
     3.174    48.254     0.200
     3.775    55.293     0.200
     4.330    64.594     0.200
     4.615    69.145     0.200
     5.577    82.965     0.200
     5.646    86.094     0.200
     6.472   101.184     0.200
     6.593    96.812     0.200
     7.066   104.324     0.200
     7.146   103.953     0.200
     7.335   108.676     0.200
     7.424   108.285     0.200
     7.454   108.016     0.200
     7.622   113.195     0.200
     7.718   113.875     0.200
     7.752   113.660     0.200
     7.752   113.863     0.200
     7.824   115.586     0.200
     8.141   122.414     0.200
     8.401   120.793     0.200
     8.619   128.414     0.200
     9.212   133.703     0.200
     9.229   136.344     0.200
     9.607   139.484     0.200
    10.730   156.945     0.200
    11.286   164.895     0.200
    11.480   167.094     0.200
    11.573   164.594     0.200
    11.578   167.953     0.200
    11.775   171.523     0.200
    11.870   172.555     0.200
    11.967   174.266     0.200
    12.197   178.016     0.200
    12.550   183.895     0.200
    13.108   191.055     0.200
    13.325   191.906     0.200
    13.474   193.145     0.200
    14.052   203.266     0.200
    14.447   204.543     0.200
    14.578   209.023     0.200
    19.221   264.984     0.200
     0.987    17.047     0.200
     0.987    17.148     0.200
     1.090    18.398     0.200
     1.090    18.574     0.200
     1.327    22.676     0.200
     1.651    26.707     0.200
     1.661    26.820     0.200
     1.735    28.824     0.200
     2.054    32.500     0.200
     2.114    34.262     0.200
     2.125    34.508     0.200
     2.153    33.883     0.200
     2.173    34.082     0.200
     2.267    35.676     0.200
     2.324    36.559     0.200
     2.470    38.836     0.200
     2.654    41.375     0.200
     2.686    41.418     0.200
     2.686    41.594     0.200
     2.691    41.199     0.200
     2.726    42.508     0.200
     2.746    42.270     0.200
     2.787    42.906     0.200
     2.838    43.543     0.200
     2.977    46.309     0.200
     2.977    45.941     0.200
     3.005    46.562     0.200
     3.101    47.441     0.200
     3.180    48.621     0.200
     3.192    48.723     0.200
     3.213    48.742     0.200
     3.220    49.324     0.200
     3.525    53.805     0.200
     3.570    54.020     0.200
     3.588    53.957     0.200
     3.588    54.293     0.200
     3.653    55.184     0.200
     3.666    54.805     0.200
     3.805    57.238     0.200
     3.827    56.797     0.200
     3.830    58.410     0.200
     3.940    60.160     0.200
     4.008    61.258     0.200
     4.436    66.809     0.200
     4.462    64.867     0.200
     4.549    67.598     0.200
     4.679    69.984     0.200
     4.797    71.918     0.200
     4.797    72.219     0.200
     4.941    73.840     0.200
     5.095    76.059     0.200
     5.109    76.531     0.200
     5.120    76.430     0.200
     5.259    78.539     0.200
     5.330    79.438     0.200
     5.350    80.027     0.200
     5.431    80.797     0.200
     5.463    80.359     0.200
     5.520    82.039     0.200
     5.544    82.660     0.200
     5.596    83.789     0.200
     5.606    83.875     0.200
     5.665    86.648     0.200
     5.855    85.633     0.200
     6.027    89.457     0.200
     6.407    93.707     0.200
     6.613   100.008     0.200
     7.631   111.539     0.200
     7.666   113.207     0.200
     7.727   112.117     0.200
     7.821   115.488     0.200
     7.964   116.387     0.200
     8.009   116.398     0.200
     8.030   116.469     0.200
     8.293   120.219     0.200
     9.092   130.527     0.200
     9.595   139.207     0.200
     9.799   143.418     0.200
     9.994   144.238     0.200
    12.378   180.758     0.200
    14.372   206.699     0.200
    15.584   219.070     0.200
     0.990    17.070     0.200
     0.990    16.844     0.200
     1.201    20.156     0.200
     1.532    26.539     0.200
     1.665    28.273     0.200
     1.798    32.188     0.200
     1.999    31.961     0.200
     2.017    32.477     0.200
     2.143    35.094     0.200
     2.525    40.078     0.200
     2.594    41.656     0.200
     2.874    45.625     0.200
     3.064    47.953     0.200
     3.059    47.211     0.200
     3.151    48.398     0.200
     3.396    52.336     0.200
     3.534    54.023     0.200
     3.537    54.133     0.200
     3.723    56.883     0.200
     3.759    57.625     0.200
     4.401    65.336     0.200
     4.674    71.328     0.200
     5.934    86.922     0.200
     6.350    96.398     0.200
     6.482    98.086     0.200
     9.721   143.016     0.200
    11.095   158.750     0.200
    11.164   163.125     0.200
     0.999    17.195     0.200
     1.093    18.336     0.200
     1.086    18.484     0.200
     1.086    18.344     0.200
     1.323    21.867     0.200
     1.656    27.156     0.200
     1.662    26.648     0.200
     1.747    28.945     0.200
     1.697    30.250     0.200
     2.066    33.344     0.200
     2.124    34.141     0.200
     2.128    33.430     0.200
     2.134    33.508     0.200
     2.163    34.102     0.200
     2.172    34.016     0.200
     2.336    36.023     0.200
     2.656    40.961     0.200
     2.697    41.625     0.200
     2.697    41.484     0.200
     2.687    41.008     0.200
     2.738    41.727     0.200
     2.756    42.336     0.200
     2.835    43.352     0.200
     2.986    46.406     0.200
     3.008    46.078     0.200
     3.213    48.727     0.200
     3.354    50.102     0.200
     3.527    53.641     0.200
     3.582    54.070     0.200
     3.600    54.633     0.200
     3.600    54.336     0.200
     3.651    55.422     0.200
     3.659    54.844     0.200
     3.743    56.820     0.200
     3.824    58.016     0.200
     4.004    59.516     0.200
     4.104    61.453     0.200
     4.213    63.367     0.200
     4.267    64.594     0.200
     4.267    63.891     0.200
     4.416    66.305     0.200
     4.454    65.203     0.200
     4.472    66.609     0.200
     4.604    68.836     0.200
     4.692    70.133     0.200
     4.675    70.422     0.200
     4.796    72.586     0.200
     4.977    75.289     0.200
     5.004    75.094     0.200
     5.131    76.445     0.200
     5.118    74.789     0.200
     5.209    77.633     0.200
     5.256    78.430     0.200
     5.273    78.500     0.200
     5.335    79.734     0.200
     6.031    87.672     0.200
     6.419    93.164     0.200
     7.627   110.711     0.200
     7.678   110.867     0.200
     7.666   114.320     0.200
     7.825   113.430     0.200
     8.004   116.680     0.200
     8.288   120.383     0.200
     8.288   121.375     0.200
     9.084   130.664     0.200
    11.124   161.195     0.200
    11.300   166.422     0.200
    15.594   221.625     0.200
     1.170    19.953     0.200
     1.206    19.875     0.200
     1.284    23.092     0.200
     1.348    23.092     0.200
     1.343    21.807     0.200
     1.392    24.783     0.200
     1.408    24.512     0.200
     1.505    24.303     0.200
     1.505    23.881     0.200
     1.505    23.752     0.200
     1.573    25.824     0.200
     1.648    26.000     0.200
     1.707    26.947     0.200
     1.844    28.609     0.200
     1.952    30.420     0.200
     2.091    32.502     0.200
     2.178    33.055     0.200
     2.189    33.840     0.200
     2.252    34.828     0.200
     2.345    35.822     0.200
     2.382    36.270     0.200
     2.438    37.674     0.200
     2.470    38.020     0.200
     2.520    38.342     0.200
     2.617    39.811     0.200
     2.625    41.232     0.200
     2.652    40.801     0.200
     2.776    41.895     0.200
     2.775    41.654     0.200
     2.784    42.076     0.200
     2.800    42.123     0.200
     2.796    41.832     0.200
     2.855    43.109     0.200
     2.866    43.213     0.200
     2.899    47.352     0.200
     2.896    43.939     0.200
     2.913    43.938     0.200
     2.954    47.533     0.200
     3.051    45.545     0.200
     3.276    49.771     0.200
     3.289    49.715     0.200
     3.298    48.844     0.200
     3.321    50.574     0.200
     3.380    50.689     0.200
     3.387    50.172     0.200
     3.518    52.586     0.200
     3.531    52.803     0.200
     3.551    52.582     0.200
     3.573    56.812     0.200
     3.567    52.836     0.200
     3.632    53.492     0.200
     3.632    55.072     0.200
     3.666    54.494     0.200
     3.719    56.379     0.200
     3.785    56.893     0.200
     3.834    56.383     0.200
     3.866    56.791     0.200
     3.875    56.572     0.200
     3.936    57.752     0.200
     3.952    58.285     0.200
     3.962    59.457     0.200
     4.022    59.668     0.200
     4.046    59.852     0.200
     4.046    60.703     0.200
     4.108    61.301     0.200
     4.107    61.828     0.200
     4.140    60.383     0.200
     4.140    61.342     0.200
     4.160    61.330     0.200
     4.180    63.395     0.200
     4.205    60.934     0.200
     4.250    64.195     0.200
     4.292    64.008     0.200
     4.332    64.879     0.200
     4.479    66.588     0.200
     4.479    68.162     0.200
     4.490    65.217     0.200
     4.490    65.328     0.200
     4.517    65.705     0.200
     4.605    68.912     0.200
     4.636    67.527     0.200
     4.642    69.068     0.200
     4.702    69.889     0.200
     4.779    71.133     0.200
     4.829    70.127     0.200
     4.937    72.998     0.200
     4.951    73.598     0.200
     5.034    73.836     0.200
     5.054    75.961     0.200
     5.081    73.883     0.200
     5.082    73.559     0.200
     5.155    76.775     0.200
     5.157    75.482     0.200
     5.159    76.543     0.200
     5.240    76.107     0.200
     5.254    77.824     0.200
     5.296    78.254     0.200
     5.352    79.525     0.200
     5.502    79.441     0.200
     5.523    81.742     0.200
     5.559    82.232     0.200
     5.580    82.594     0.200
     5.602    83.164     0.200
     5.644    84.582     0.200
     5.746    85.453     0.200
     5.820    86.035     0.200
     5.824    86.602     0.200
     5.860    87.770     0.200
     5.880    86.355     0.200
     5.889    86.086     0.200
     5.892    86.531     0.200
     5.951    87.865     0.200
     5.991    89.848     0.200
     6.077    90.166     0.200
     6.127    90.449     0.200
     6.134    89.900     0.200
     6.268    91.979     0.200
     6.310    93.324     0.200
     6.358    94.062     0.200
     6.386    93.764     0.200
     6.421    94.295     0.200
     6.444    94.578     0.200
     6.469    95.600     0.200
     6.548    96.689     0.200
     6.566    97.602     0.200
     6.574    96.455     0.200
     6.586    96.545     0.200
     6.607    96.412     0.200
     6.607    97.252     0.200
     6.639    97.102     0.200
     6.729    98.627     0.200
     6.740    96.330     0.200
     6.777    99.812     0.200
     6.805   101.377     0.200
     6.913   101.582     0.200
     6.933   102.119     0.200
     6.945   100.672     0.200
     6.955   100.475     0.200
     7.015   102.682     0.200
     7.021   101.121     0.200
     7.039   103.016     0.200
     7.067   103.572     0.200
     7.096   103.908     0.200
     7.214   105.854     0.200
     7.233   105.975     0.200
     7.238   105.980     0.200
     7.278   107.053     0.200
     7.314   108.299     0.200
     7.343   108.578     0.200
     7.352   106.828     0.200
     7.390   108.873     0.200
     7.494   109.043     0.200
     7.503   110.029     0.200
     7.517   111.049     0.200
     7.599   112.203     0.200
     7.640   112.539     0.200
     7.669   111.123     0.200
     7.699   113.002     0.200
     7.699   112.502     0.200
     7.727   109.730     0.200
     7.731   112.539     0.200
     7.739   112.586     0.200
     7.788   113.752     0.200
     7.788   113.383     0.200
     7.814   113.090     0.200
     7.820   114.742     0.200
     7.850   114.939     0.200
     7.857   114.752     0.200
     7.883   115.736     0.200
     7.904   116.562     0.200
     7.906   116.332     0.200
     7.926   116.254     0.200
     7.931   117.953     0.200
     7.986   117.029     0.200
     7.986   117.352     0.200
     8.053   118.607     0.200
     8.112   120.543     0.200
     8.142   119.467     0.200
     8.151   119.359     0.200
     8.213   120.449     0.200
     8.252   120.873     0.200
     8.277   120.322     0.200
     8.283   119.775     0.200
     8.387   120.471     0.200
     8.435   120.545     0.200
     8.448   124.010     0.200
     8.515   125.211     0.200
     8.555   123.818     0.200
     8.562   125.689     0.200
     8.570   121.387     0.200
     8.578   126.053     0.200
     8.590   127.502     0.200
     8.616   126.098     0.200
     8.639   124.211     0.200
     8.708   128.582     0.200
     8.715   128.541     0.200
     8.815   129.312     0.200
     8.809   127.924     0.200
     8.939   129.127     0.200
     8.955   131.771     0.200
     8.971   126.750     0.200
     8.975   131.955     0.200
     8.993   131.229     0.200
     9.041   129.641     0.200
     9.058   132.221     0.200
     9.106   131.910     0.200
     9.116   132.705     0.200
     9.132   134.502     0.200
     9.170   132.322     0.200
     9.204   134.852     0.200
     9.282   135.416     0.200
     9.283   134.467     0.200
     9.308   136.215     0.200
     9.360   136.986     0.200
     9.414   135.713     0.200
     9.414   138.363     0.200
     9.414   138.852     0.200
     9.438   137.705     0.200
     9.504   138.223     0.200
     9.528   138.902     0.200
     9.555   138.898     0.200
     9.616   139.613     0.200
     9.653   137.793     0.200
     9.680   139.590     0.200
     9.681   139.412     0.200
     9.704   140.988     0.200
     9.707   139.734     0.200
     9.732   141.820     0.200
     9.739   141.697     0.200
     9.757   141.627     0.200
     9.816   142.545     0.200
     9.891   143.732     0.200
     9.977   145.502     0.200
     9.998   140.547     0.200
    10.015   146.383     0.200
    10.027   143.303     0.200
    10.033   145.068     0.200
    10.073   147.457     0.200
    10.099   146.283     0.200
    10.172   146.996     0.200
    10.217   147.900     0.200
    10.227   147.225     0.200
    10.236   149.223     0.200
    10.257   149.441     0.200
    10.287   150.002     0.200
    10.308   152.102     0.200
    10.318   150.117     0.200
    10.347   150.559     0.200
    10.382   151.334     0.200
    10.387   151.008     0.200
    10.407   151.857     0.200
    10.451   151.904     0.200
    10.476   150.203     0.200
    10.564   154.488     0.200
    10.667   155.588     0.200
    10.686   155.584     0.200
    10.732   156.842     0.200
    10.733   155.152     0.200
    10.773   157.438     0.200
    10.782   156.074     0.200
    10.853   158.498     0.200
    10.953   160.127     0.200
    10.954   160.316     0.200
    10.965   159.363     0.200
    10.981   161.781     0.200
    10.981   160.922     0.200
    10.992   159.844     0.200
    11.018   161.117     0.200
    11.034   161.008     0.200
    11.046   160.760     0.200
    11.115   161.510     0.200
    11.115   162.312     0.200
    11.167   164.289     0.200
    11.163   161.936     0.200
    11.169   163.191     0.200
    11.191   163.770     0.200
    11.259   164.480     0.200
    11.259   163.912     0.200
    11.259   164.053     0.200
    11.326   165.752     0.200
    11.323   165.283     0.200
    11.328   165.193     0.200
    11.349   161.465     0.200
    11.407   163.846     0.200
    11.437   166.074     0.200
    11.446   166.863     0.200
    11.454   166.572     0.200
    11.480   161.287     0.200
    11.549   162.727     0.200
    11.551   166.514     0.200
    11.589   169.162     0.200
    11.615   166.303     0.200
    11.660   169.811     0.200
    11.675   170.094     0.200
    11.722   171.752     0.200
    11.741   171.531     0.200
    11.742   170.393     0.200
    11.794   171.420     0.200
    11.807   173.172     0.200
    11.934   174.412     0.200
    12.033   168.766     0.200
    12.038   174.512     0.200
    12.067   176.357     0.200
    12.085   176.496     0.200
    12.099   177.385     0.200
    12.123   177.297     0.200
    12.171   171.938     0.200
    12.246   176.154     0.200
    12.325   179.455     0.200
    12.332   172.730     0.200
    12.479   182.572     0.200
    12.481   183.092     0.200
    12.506   183.402     0.200
    12.567   175.836     0.200
    12.638   181.941     0.200
    12.651   184.820     0.200
    12.767   185.283     0.200
    12.854   187.281     0.200
    12.873   188.363     0.200
    12.884   187.660     0.200
    12.899   186.619     0.200
    12.950   188.049     0.200
    13.046   189.537     0.200
    13.064   190.232     0.200
    13.129   190.684     0.200
    13.235   192.557     0.200
    13.332   193.830     0.200
    13.337   194.049     0.200
    13.341   192.492     0.200
    13.387   191.803     0.200
    13.417   195.184     0.200
    13.427   193.994     0.200
    13.433   192.203     0.200
    13.433   194.873     0.200
    13.496   193.223     0.200
    13.496   194.082     0.200
    13.547   195.479     0.200
    13.584   195.266     0.200
    13.593   196.926     0.200
    13.595   197.400     0.200
    13.599   195.934     0.200
    13.603   194.033     0.200
    13.629   197.742     0.200
    13.760   199.682     0.200
    13.890   201.414     0.200
    13.897   201.318     0.200
    13.903   200.469     0.200
    13.908   201.475     0.200
    13.952   202.076     0.200
    13.970   197.402     0.200
    13.999   201.969     0.200
    14.017   202.145     0.200
    14.105   203.021     0.200
    14.112   203.363     0.200
    14.296   205.982     0.200
    14.314   206.275     0.200
    14.338   206.461     0.200
    14.398   206.691     0.200
    14.405   207.555     0.200
    14.490   207.363     0.200
    14.514   208.840     0.200
    14.599   209.668     0.200
    14.616   207.502     0.200
    14.639   209.840     0.200
    14.662   209.889     0.200
    14.677   210.127     0.200
    14.693   210.668     0.200
    14.730   211.588     0.200
    14.728   211.008     0.200
    14.771   211.223     0.200
    14.846   212.381     0.200
    14.843   212.188     0.200
    14.880   210.092     0.200
    15.102   215.994     0.200
    15.145   216.021     0.200
    15.221   217.473     0.200
    15.241   216.832     0.200
    15.318   218.680     0.200
    15.316   218.121     0.200
    15.346   218.824     0.200
    15.388   219.303     0.200
    15.435   219.908     0.200
    15.443   220.039     0.200
    15.496   220.471     0.200
    15.554   221.123     0.200
    15.570   220.977     0.200
    15.576   221.410     0.200
    15.643   222.557     0.200
    15.803   222.963     0.200
    15.834   223.293     0.200
    15.855   225.203     0.200
    15.861   223.912     0.200
    15.918   225.898     0.200
    15.980   226.564     0.200
    16.097   228.109     0.200
    16.116   226.061     0.200
    16.178   228.127     0.200
    16.175   228.381     0.200
    16.187   227.240     0.200
    16.284   228.473     0.200
    16.399   230.867     0.200
    16.468   229.715     0.200
    16.466   231.594     0.200
    16.503   232.072     0.200
    16.509   231.629     0.200
    16.553   232.992     0.200
    16.607   231.469     0.200
    16.623   233.162     0.200
    16.689   234.607     0.200
    16.715   231.246     0.200
    16.752   234.127     0.200
    16.778   234.609     0.200
    16.838   235.451     0.200
    16.957   236.316     0.200
    17.295   242.229     0.200
    17.514   244.672     0.200
    18.248   253.303     0.200
    19.266   267.182     0.200
    19.931   272.922     0.200
    20.945   284.822     0.200
     1.217    19.906     0.200
     1.344    21.891     0.200
     1.343    23.367     0.200
     1.388    24.703     0.200
     1.398    25.000     0.200
     1.514    24.047     0.200
     1.514    23.805     0.200
     1.577    25.711     0.200
     1.659    26.055     0.200
     1.718    26.969     0.200
     1.850    29.180     0.200
     1.960    30.625     0.200
     2.100    32.430     0.200
     2.174    33.070     0.200
     2.192    33.867     0.200
     2.261    35.195     0.200
     2.356    35.977     0.200
     2.391    36.664     0.200
     2.444    37.477     0.200
     2.478    38.266     0.200
     2.531    38.625     0.200
     2.617    39.461     0.200
     2.660    40.609     0.200
     2.785    42.117     0.200
     2.780    42.016     0.200
     2.780    42.266     0.200
     2.805    42.891     0.200
     2.807    42.898     0.200
     2.861    43.547     0.200
     2.876    43.273     0.200
     2.905    43.867     0.200
     2.906    44.844     0.200
     2.917    43.578     0.200
     3.051    45.453     0.200
     3.109    46.086     0.200
     3.112    46.656     0.200
     3.112    47.523     0.200
     3.281    49.781     0.200
     3.296    48.797     0.200
     3.300    49.367     0.200
     3.306    50.180     0.200
     3.329    50.172     0.200
     3.389    50.234     0.200
     3.390    50.805     0.200
     3.521    52.211     0.200
     3.541    52.609     0.200
     3.557    53.062     0.200
     3.576    53.383     0.200
     3.580    54.516     0.200
     3.580    55.102     0.200
     3.636    55.109     0.200
     3.674    54.836     0.200
     3.726    56.102     0.200
     3.789    56.555     0.200
     3.833    56.242     0.200
     3.865    56.727     0.200
     3.872    57.148     0.200
     3.941    58.945     0.200
     3.954    58.148     0.200
     3.970    58.883     0.200
     4.032    59.828     0.200
     4.033    60.141     0.200
     4.057    60.945     0.200
     4.057    60.789     0.200
     4.113    61.602     0.200
     4.118    61.680     0.200
     4.149    61.703     0.200
     4.149    61.188     0.200
     4.161    61.867     0.200
     4.217    62.953     0.200
     4.258    63.883     0.200
     4.303    64.328     0.200
     4.341    65.047     0.200
     4.485    67.055     0.200
     4.485    67.383     0.200
     4.487    65.469     0.200
     4.491    66.938     0.200
     4.516    66.281     0.200
     4.614    68.836     0.200
     4.632    67.555     0.200
     4.647    69.359     0.200
     4.712    70.312     0.200
     4.789    71.555     0.200
     4.849    72.562     0.200
     4.940    72.953     0.200
     4.961    73.641     0.200
     5.061    76.320     0.200
     5.073    77.188     0.200
     5.081    73.938     0.200
     5.158    76.156     0.200
     5.164    77.016     0.200
     5.169    76.781     0.200
     5.237    76.195     0.200
     5.264    77.992     0.200
     5.298    78.641     0.200
     5.356    80.062     0.200
     5.499    82.102     0.200
     5.510    82.273     0.200
     5.528    82.867     0.200
     5.590    83.055     0.200
     5.606    83.422     0.200
     5.644    82.070     0.200
     5.651    84.344     0.200
     5.755    85.531     0.200
     5.830    86.383     0.200
     5.867    87.328     0.200
     5.890    87.094     0.200
     5.899    86.836     0.200
     5.902    87.086     0.200
     5.962    89.570     0.200
     5.997    89.766     0.200
     6.085    90.578     0.200
     6.136    90.273     0.200
     6.139    91.031     0.200
     6.271    92.484     0.200
     6.366    94.938     0.200
     6.397    94.273     0.200
     6.431    95.500     0.200
     6.476    96.500     0.200
     6.584    97.273     0.200
     6.596    97.758     0.200
     6.602    96.625     0.200
     6.615    98.086     0.200
     6.739    99.391     0.200
     6.782   100.617     0.200
     6.813   101.133     0.200
     6.916   102.219     0.200
     7.021   102.180     0.200
     7.025   103.055     0.200
     7.078   103.836     0.200
     7.106   105.000     0.200
     7.189   104.688     0.200
     7.214   106.062     0.200
     7.225   106.266     0.200
     7.235   106.383     0.200
     7.287   108.203     0.200
     7.321   108.320     0.200
     7.348   108.750     0.200
     7.348   109.031     0.200
     7.362   108.172     0.200
     7.397   108.945     0.200
     7.496   109.477     0.200
     7.505   110.664     0.200
     7.577   111.625     0.200
     7.647   113.094     0.200
     7.680   112.508     0.200
     7.708   112.859     0.200
     7.708   113.695     0.200
     7.740   114.148     0.200
     7.790   114.016     0.200
     7.790   113.914     0.200
     7.824   114.336     0.200
     7.866   115.094     0.200
     7.911   117.516     0.200
     7.934   116.570     0.200
     7.996   118.844     0.200
     7.996   117.625     0.200
     8.059   118.664     0.200
     8.150   119.266     0.200
     8.152   119.016     0.200
     8.224   120.281     0.200
     8.261   120.969     0.200
     8.288   120.641     0.200
     8.288   120.547     0.200
     8.398   122.289     0.200
     8.445   123.445     0.200
     8.458   124.383     0.200
     8.565   125.828     0.200
     8.571   126.445     0.200
     8.587   130.883     0.200
     8.599   128.844     0.200
     8.646   126.047     0.200
     8.716   130.477     0.200
     8.817   128.945     0.200
     8.949   131.414     0.200
     8.961   131.023     0.200
     8.981   131.867     0.200
     8.984   132.133     0.200
     9.001   131.523     0.200
     9.052   133.422     0.200
     9.064   132.477     0.200
     9.117   133.062     0.200
     9.142   136.102     0.200
     9.180   133.969     0.200
     9.213   134.664     0.200
     9.268   134.422     0.200
     9.291   136.148     0.200
     9.318   136.422     0.200
     9.366   137.164     0.200
     9.448   138.422     0.200
     9.511   138.648     0.200
     9.538   141.742     0.200
     9.563   139.305     0.200
     9.663   140.555     0.200
     9.690   140.766     0.200
     9.691   141.961     0.200
     9.715   142.445     0.200
     9.717   142.000     0.200
     9.766   143.016     0.200
     9.826   143.773     0.200
    10.021   147.141     0.200
    10.026   147.086     0.200
    10.043   146.953     0.200
    10.083   148.023     0.200
    10.107   146.695     0.200
    10.182   148.922     0.200
    10.228   149.297     0.200
    10.237   149.664     0.200
    10.267   150.234     0.200
    10.328   151.750     0.200
    10.356   151.430     0.200
    10.395   151.367     0.200
    10.393   152.039     0.200
    10.418   152.531     0.200
    10.461   152.781     0.200
    10.472   150.047     0.200
    10.575   155.281     0.200
    10.675   156.281     0.200
    10.696   156.867     0.200
    10.739   156.742     0.200
    10.783   157.852     0.200
    10.792   158.320     0.200
    10.832   158.875     0.200
    10.863   158.773     0.200
    10.956   160.695     0.200
    10.961   160.805     0.200
    10.964   160.672     0.200
    10.975   161.117     0.200
    11.001   159.828     0.200
    11.057   161.438     0.200
    11.126   162.883     0.200
    11.126   164.305     0.200
    11.173   163.281     0.200
    11.177   164.328     0.200
    11.180   164.383     0.200
    11.201   163.578     0.200
    11.268   164.148     0.200
    11.268   165.344     0.200
    11.268   164.297     0.200
    11.336   165.805     0.200
    11.336   166.289     0.200
    11.360   166.398     0.200
    11.415   166.242     0.200
    11.447   167.961     0.200
    11.455   167.742     0.200
    11.490   167.359     0.200
    11.494   168.805     0.200
    11.533   167.492     0.200
    11.552   169.406     0.200
    11.562   169.211     0.200
    11.598   169.805     0.200
    11.617   168.055     0.200
    11.670   171.391     0.200
    11.733   171.500     0.200
    11.751   171.414     0.200
    11.804   171.898     0.200
    11.817   174.773     0.200
    11.845   170.938     0.200
    12.047   174.766     0.200
    12.078   175.844     0.200
    12.095   176.602     0.200
    12.110   176.273     0.200
    12.133   177.180     0.200
    12.181   177.484     0.200
    12.256   178.883     0.200
    12.335   179.773     0.200
    12.343   179.625     0.200
    12.496   181.867     0.200
    12.647   183.352     0.200
    12.661   184.625     0.200
    12.735   185.656     0.200
    12.764   187.367     0.200
    12.777   187.195     0.200
    12.864   187.391     0.200
    12.884   187.523     0.200
    12.894   187.266     0.200
    12.910   188.328     0.200
    12.961   188.062     0.200
    13.056   189.984     0.200
    13.074   191.094     0.200
    13.139   191.469     0.200
    13.246   192.766     0.200
    13.342   193.719     0.200
    13.347   193.977     0.200
    13.351   193.680     0.200
    13.385   192.344     0.200
    13.428   193.977     0.200
    13.437   194.461     0.200
    13.443   194.664     0.200
    13.505   195.102     0.200
    13.505   194.914     0.200
    13.544   196.852     0.200
    13.557   195.805     0.200
    13.604   196.766     0.200
    13.606   196.773     0.200
    13.609   196.375     0.200
    13.626   197.688     0.200
    13.770   196.984     0.200
    13.900   201.320     0.200
    13.907   201.023     0.200
    13.914   200.469     0.200
    13.917   200.609     0.200
    13.962   200.969     0.200
    13.971   198.742     0.200
    14.010   202.141     0.200
    14.027   202.367     0.200
    14.094   202.625     0.200
    14.115   203.117     0.200
    14.122   203.305     0.200
    14.222   205.125     0.200
    14.306   207.125     0.200
    14.318   207.227     0.200
    14.324   206.516     0.200
    14.349   206.727     0.200
    14.408   207.703     0.200
    14.415   207.695     0.200
    14.524   208.711     0.200
    14.541   209.391     0.200
    14.610   209.508     0.200
    14.650   210.273     0.200
    14.673   210.148     0.200
    14.688   210.625     0.200
    14.703   211.008     0.200
    14.738   211.750     0.200
    14.741   211.805     0.200
    14.781   211.625     0.200
    14.835   213.234     0.200
    14.848   213.312     0.200
    14.853   212.781     0.200
    14.857   212.656     0.200
    14.898   213.180     0.200
    15.084   214.922     0.200
    15.112   215.789     0.200
    15.134   217.242     0.200
    15.155   216.742     0.200
    15.158   216.523     0.200
    15.231   217.250     0.200
    15.251   217.438     0.200
    15.308   218.250     0.200
    15.326   218.203     0.200
    15.328   218.516     0.200
    15.398   219.547     0.200
    15.445   219.344     0.200
    15.454   219.766     0.200
    15.506   221.367     0.200
    15.580   221.695     0.200
    15.587   221.516     0.200
    15.654   222.828     0.200
    15.730   222.680     0.200
    15.865   225.945     0.200
    15.907   225.445     0.200
    15.990   226.266     0.200
    15.989   225.805     0.200
    16.108   228.461     0.200
    16.125   228.781     0.200
    16.125   229.266     0.200
    16.185   228.828     0.200
    16.188   228.820     0.200
    16.409   232.008     0.200
    16.475   233.023     0.200
    16.478   233.328     0.200
    16.519   233.781     0.200
    16.576   234.703     0.200
    16.610   234.406     0.200
    16.618   234.117     0.200
    16.633   234.828     0.200
    16.700   236.133     0.200
    16.725   236.352     0.200
    17.022   239.883     0.200
    18.076   252.047     0.200
    18.076   252.164     0.200
    19.936   275.188     0.200
    20.043   277.352     0.200
    20.414   279.242     0.200
     1.012    19.117     0.200
     1.139    20.656     0.200
     1.156    19.719     0.200
     1.197    19.531     0.200
     1.354    21.812     0.200
     1.342    23.172     0.200
     1.384    24.375     0.200
     1.491    23.625     0.200
     1.491    23.758     0.200
     1.558    25.297     0.200
     1.701    26.883     0.200
     1.847    28.648     0.200
     1.937    30.156     0.200
     2.192    33.234     0.200
     2.336    35.336     0.200
     2.629    39.570     0.200
     2.761    41.633     0.200
     2.920    43.844     0.200
     2.939    44.641     0.200
     3.064    45.852     0.200
     3.312    49.234     0.200
     3.526    52.242     0.200
     3.558    55.570     0.200
     3.618    55.828     0.200
     3.879    56.938     0.200
     3.889    57.164     0.200
     4.482    68.078     0.200
     4.503    65.945     0.200
     4.650    67.828     0.200
     5.094    74.320     0.200
     5.164    75.031     0.200
     5.254    76.492     0.200
     5.658    82.133     0.200
     5.813    84.227     0.200
     6.932   100.625     0.200
     7.347   108.258     0.200
     7.797   114.297     0.200
    10.491   150.500     0.200
     1.021    17.401     0.200
     1.211    19.754     0.200
     1.361    22.001     0.200
     1.331    23.136     0.200
     1.374    24.575     0.200
     1.500    23.601     0.200
     1.500    24.086     0.200
     1.559    25.657     0.200
     1.649    26.097     0.200
     1.715    26.679     0.200
     1.860    28.991     0.200
     1.943    30.540     0.200
     2.105    32.571     0.200
     2.207    33.810     0.200
     2.193    33.386     0.200
     2.248    35.251     0.200
     2.350    36.083     0.200
     2.392    36.991     0.200
     2.455    37.511     0.200
     2.484    38.077     0.200
     2.521    38.354     0.200
     2.633    42.007     0.200
     2.634    39.800     0.200
     2.644    40.649     0.200
     2.762    42.013     0.200
     2.761    42.183     0.200
     2.801    42.192     0.200
     2.871    43.839     0.200
     2.875    44.044     0.200
     2.909    43.944     0.200
     2.890    45.735     0.200
     2.931    43.976     0.200
     2.944    48.206     0.200
     3.024    45.702     0.200
     3.068    46.144     0.200
     3.102    46.659     0.200
     3.102    48.347     0.200
     3.298    49.290     0.200
     3.291    49.487     0.200
     3.314    49.263     0.200
     3.336    49.978     0.200
     3.386    50.911     0.200
     3.405    50.552     0.200
     3.536    52.726     0.200
     3.533    52.989     0.200
     3.578    53.808     0.200
     3.564    55.165     0.200
     3.618    54.144     0.200
     3.618    55.575     0.200
     3.680    55.288     0.200
     3.735    57.333     0.200
     3.803    57.589     0.200
     3.851    57.126     0.200
     3.891    57.450     0.200
     3.923    60.321     0.200
     3.969    60.698     0.200
     3.970    58.376     0.200
     3.954    59.011     0.200
     4.031    59.714     0.200
     4.022    59.522     0.200
     4.053    61.245     0.200
     4.049    60.382     0.200
     4.124    61.343     0.200
     4.135    61.358     0.200
     4.177    62.884     0.200
     4.231    63.755     0.200
     4.265    65.155     0.200
     4.301    64.999     0.200
     4.344    65.819     0.200
     4.495    67.966     0.200
     4.508    66.388     0.200
     4.506    66.259     0.200
     4.534    66.942     0.200
     4.556    66.825     0.200
     4.599    68.302     0.200
     4.659    70.921     0.200
     4.651    68.382     0.200
     4.712    69.911     0.200
     4.786    71.009     0.200
     4.839    72.409     0.200
     4.955    73.731     0.200
     4.964    74.202     0.200
     5.028    75.388     0.200
     5.099    74.372     0.200
     5.167    77.733     0.200
     5.167    75.226     0.200
     5.175    75.261     0.200
     5.265    77.653     0.200
     5.256    76.677     0.200
     5.314    78.888     0.200
     5.344    80.296     0.200
     5.369    80.294     0.200
     5.491    82.177     0.200
     5.516    82.827     0.200
     5.540    83.122     0.200
     5.570    87.636     0.200
     5.592    83.415     0.200
     5.620    83.620     0.200
     5.662    82.626     0.200
     5.826    87.325     0.200
     5.895    86.497     0.200
     5.954    86.593     0.200
     6.008    89.979     0.200
     6.091    91.155     0.200
     6.152    91.897     0.200
     6.286    93.046     0.200
     6.373    94.694     0.200
     6.392    94.763     0.200
     6.425    95.323     0.200
     6.444    94.575     0.200
     6.485    96.175     0.200
     6.578    99.825     0.200
     6.583    97.501     0.200
     6.594    97.917     0.200
     6.620    98.243     0.200
     6.631    96.526     0.200
     6.742   100.081     0.200
     6.941   101.325     0.200
     7.038   103.214     0.200
     7.053   104.005     0.200
     7.076   104.183     0.200
     7.123   104.776     0.200
     7.205   105.556     0.200
     7.231   106.331     0.200
     7.359   109.466     0.200
     7.363   107.435     0.200
     7.484   109.575     0.200
     7.675   113.052     0.200
     7.713   114.325     0.200
     7.806   114.351     0.200
     7.806   114.216     0.200
     7.835   114.976     0.200
     7.920   117.466     0.200
     7.922   115.745     0.200
     7.997   116.325     0.200
     8.114   120.437     0.200
     8.124   122.546     0.200
     8.284   121.065     0.200
     8.394   121.780     0.200
     8.589   130.646     0.200
     8.719   130.905     0.200
     9.143   135.866     0.200
     9.286   134.546     0.200
     9.538   140.726     0.200
     9.633   139.517     0.200
    10.236   148.405     0.200
    10.310   150.726     0.200
    10.491   150.575     0.200
    10.748   157.026     0.200
    10.833   156.087     0.200
    10.978   162.026     0.200
    11.123   162.735     0.200
    11.271   164.026     0.200
    11.334   166.517     0.200
    11.457   166.306     0.200
    11.554   168.985     0.200
    11.575   170.017     0.200
    11.599   168.007     0.200
    11.633   167.915     0.200
    11.753   170.476     0.200
    12.735   186.187     0.200
    12.732   186.726     0.200
    12.753   186.856     0.200
    13.073   190.636     0.200
    13.403   192.626     0.200
    13.543   196.806     0.200
    13.600   198.427     0.200
    13.620   196.716     0.200
    13.760   199.976     0.200
    13.988   198.126     0.200
    14.179   200.726     0.200
    14.299   205.306     0.200
    14.406   205.976     0.200
    14.631   207.325     0.200
    15.081   214.507     0.200
    15.305   218.087     0.200
    15.847   223.026     0.200
    18.266   253.126     0.200
    19.284   268.187     0.200
    19.949   274.065     0.200
    20.962   286.046     0.200
     1.157    19.699     0.200
     1.198    19.562     0.200
     1.352    21.879     0.200
     1.343    22.867     0.200
     1.386    24.688     0.200
     1.414    25.098     0.200
     1.492    23.602     0.200
     1.560    25.617     0.200
     1.701    26.668     0.200
     1.846    28.793     0.200
     2.190    33.102     0.200
     2.196    33.594     0.200
     2.336    35.516     0.200
     2.469    38.109     0.200
     2.627    39.543     0.200
     2.619    41.098     0.200
     2.762    41.785     0.200
     2.792    42.328     0.200
     2.860    43.305     0.200
     2.894    44.078     0.200
     2.885    47.797     0.200
     2.919    44.254     0.200
     3.062    45.828     0.200
     3.280    50.047     0.200
     3.284    48.609     0.200
     3.311    48.824     0.200
     3.321    51.152     0.200
     3.372    50.566     0.200
     3.396    50.402     0.200
     3.525    53.152     0.200
     3.563    54.504     0.200
     3.665    55.660     0.200
     3.791    57.375     0.200
     3.846    56.789     0.200
     3.888    57.203     0.200
     3.960    58.836     0.200
     4.017    60.719     0.200
     4.039    60.859     0.200
     4.111    61.656     0.200
     4.104    61.707     0.200
     4.220    63.477     0.200
     4.251    63.410     0.200
     4.330    64.762     0.200
     4.482    68.387     0.200
     4.500    66.129     0.200
     4.528    66.664     0.200
     4.543    66.977     0.200
     4.648    67.539     0.200
     4.698    70.277     0.200
     5.162    75.180     0.200
     5.154    76.254     0.200
     5.153    77.082     0.200
     5.253    76.504     0.200
     5.656    82.477     0.200
     6.433    94.602     0.200
     6.563   100.098     0.200
     7.008   102.691     0.200
     7.346   109.477     0.200
     7.796   113.004     0.200
     7.906   118.148     0.200
     7.982   120.648     0.200
     8.270   121.957     0.200
     9.128   136.566     0.200
    10.489   149.727     0.200
    10.735   157.609     0.200
    11.257   165.039     0.200
    11.257   164.871     0.200
    11.319   166.258     0.200
    11.442   168.020     0.200
    13.399   192.066     0.200
    13.492   193.629     0.200
    20.801   283.688     0.200
     1.010    19.160     0.200
     1.201    19.559     0.200
     1.337    23.000     0.200
     1.359    21.969     0.200
     1.491    23.602     0.200
     1.555    25.594     0.200
     1.638    25.605     0.200
     1.705    26.773     0.200
     1.852    29.020     0.200
     1.936    30.641     0.200
     2.195    33.324     0.200
     2.203    33.949     0.200
     2.239    34.812     0.200
     2.339    35.770     0.200
     2.382    36.637     0.200
     2.449    37.699     0.200
     2.475    38.008     0.200
     2.511    38.531     0.200
     2.622    41.211     0.200
     2.636    40.688     0.200
     2.633    40.090     0.200
     2.758    41.848     0.200
     2.799    42.305     0.200
     2.864    43.102     0.200
     2.864    43.590     0.200
     2.899    44.285     0.200
     2.926    44.438     0.200
     3.013    45.637     0.200
     3.068    45.797     0.200
     3.282    49.980     0.200
     3.287    49.797     0.200
     3.287    49.934     0.200
     3.316    49.469     0.200
     3.327    51.188     0.200
     3.375    51.488     0.200
     3.403    50.371     0.200
     3.532    52.488     0.200
     3.557    57.211     0.200
     3.568    53.980     0.200
     3.670    55.984     0.200
     3.797    57.453     0.200
     3.851    57.500     0.200
     3.893    57.102     0.200
     3.966    58.375     0.200
     4.021    60.680     0.200
     4.108    61.719     0.200
     4.118    62.344     0.200
     4.126    62.000     0.200
     4.126    61.391     0.200
     4.227    62.871     0.200
     4.257    63.969     0.200
     4.290    64.773     0.200
     4.335    64.539     0.200
     4.506    67.039     0.200
     4.507    66.324     0.200
     4.534    66.672     0.200
     4.653    68.047     0.200
     4.702    70.062     0.200
     4.954    73.648     0.200
     5.156    76.891     0.200
     5.159    76.996     0.200
     5.168    75.324     0.200
     5.173    75.953     0.200
     5.254    77.965     0.200
     5.258    76.598     0.200
     5.311    78.723     0.200
     5.364    79.887     0.200
     5.662    82.121     0.200
     7.352   109.320     0.200
     7.802   113.977     0.200
     7.802   113.090     0.200
    10.494   149.824     0.200
    10.968   162.305     0.200
    11.262   165.332     0.200
    20.805   283.121     0.200
     0.444     8.582     0.200
     0.531     9.893     0.200
     0.697    12.799     0.200
     0.744    14.104     0.200
     1.170    19.963     0.200
     1.210    19.883     0.200
     1.344    21.803     0.200
     1.346    22.912     0.200
     1.390    24.492     0.200
     1.508    23.898     0.200
     1.574    25.764     0.200
     1.651    25.836     0.200
     1.711    26.859     0.200
     1.846    28.893     0.200
     1.954    30.406     0.200
     2.177    32.869     0.200
     2.191    33.789     0.200
     2.348    35.725     0.200
     2.440    37.410     0.200
     2.473    37.889     0.200
     2.629    41.703     0.200
     2.617    39.701     0.200
     2.776    42.031     0.200
     2.777    42.107     0.200
     2.785    42.072     0.200
     2.901    44.523     0.200
     2.915    43.412     0.200
     2.956    45.893     0.200
     3.023    45.166     0.200
     3.052    45.379     0.200
     3.278    49.760     0.200
     3.293    50.811     0.200
     3.388    50.160     0.200
     3.519    52.324     0.200
     3.570    54.686     0.200
     3.575    54.832     0.200
     3.669    55.668     0.200
     3.787    56.939     0.200
     3.834    56.072     0.200
     3.867    56.488     0.200
     3.875    56.910     0.200
     3.953    58.023     0.200
     4.026    60.385     0.200
     4.111    61.873     0.200
     4.110    62.221     0.200
     4.143    62.264     0.200
     4.161    61.156     0.200
     4.215    63.227     0.200
     4.253    64.607     0.200
     4.335    65.637     0.200
     4.481    67.914     0.200
     4.481    67.754     0.200
     4.491    65.867     0.200
     4.489    65.623     0.200
     4.517    65.850     0.200
     4.644    69.662     0.200
     4.635    67.338     0.200
     4.705    70.260     0.200
     4.782    71.365     0.200
     4.939    73.271     0.200
     5.057    76.111     0.200
     5.082    74.100     0.200
     5.162    77.373     0.200
     5.158    76.246     0.200
     5.240    75.984     0.200
     5.298    78.514     0.200
     5.353    79.869     0.200
     5.525    82.486     0.200
     5.604    83.279     0.200
     5.646    84.617     0.200
     5.645    81.832     0.200
     5.827    85.424     0.200
     5.863    87.680     0.200
     5.993    89.738     0.200
     6.136    90.969     0.200
     6.270    92.334     0.200
     6.472    96.225     0.200
     6.779   100.488     0.200
     7.018   102.596     0.200
     7.345   108.689     0.200
     7.345   108.412     0.200
     7.789   112.969     0.200
     8.281   124.094     0.200
    10.475   150.117     0.200
    10.983   162.184     0.200
     1.031    17.622     0.200
     1.144    20.205     0.200
     1.165    20.105     0.200
     1.212    19.701     0.200
     1.350    22.003     0.200
     1.339    22.875     0.200
     1.506    23.813     0.200
     1.506    24.195     0.200
     1.569    25.577     0.200
     1.714    26.887     0.200
     1.852    28.860     0.200
     1.951    30.543     0.200
     2.182    33.274     0.200
     2.197    33.791     0.200
     2.350    35.755     0.200
     2.624    39.842     0.200
     2.904    44.327     0.200
     2.921    44.511     0.200
     3.296    50.272     0.200
     3.304    49.164     0.200
     3.526    52.634     0.200
     3.572    58.025     0.200
     3.840    56.565     0.200
     3.873    57.058     0.200
     3.959    58.193     0.200
     4.487    67.485     0.200
     4.523    66.328     0.200
     4.640    67.970     0.200
     5.088    74.183     0.200
     5.245    76.460     0.200
     5.651    82.165     0.200
    10.481   149.710     0.200
    11.267   165.886     0.200
     0.732    12.586     0.200
     1.200    19.719     0.200
     1.360    22.070     0.200
     1.335    23.648     0.200
     1.460    23.508     0.200
     1.411    24.305     0.200
     1.490    23.648     0.200
     1.490    23.445     0.200
     1.554    25.609     0.200
     1.638    25.820     0.200
     1.704    26.969     0.200
     1.853    29.102     0.200
     1.935    30.188     0.200
     2.096    32.688     0.200
     2.091    32.648     0.200
     2.197    33.289     0.200
     2.237    34.383     0.200
     2.338    35.906     0.200
     2.382    36.594     0.200
     2.450    37.531     0.200
     2.475    38.266     0.200
     2.510    38.070     0.200
     2.622    41.180     0.200
     2.635    40.141     0.200
     2.635    40.172     0.200
     2.757    42.039     0.200
     2.782    42.719     0.200
     2.800    42.477     0.200
     2.864    43.445     0.200
     2.865    43.367     0.200
     2.881    44.875     0.200
     2.900    44.219     0.200
     2.927    44.039     0.200
     3.012    45.281     0.200
     3.091    45.977     0.200
     3.091    46.391     0.200
     3.070    45.594     0.200
     3.287    49.109     0.200
     3.288    49.055     0.200
     3.328    50.609     0.200
     3.318    48.828     0.200
     3.375    50.344     0.200
     3.404    50.438     0.200
     3.533    52.695     0.200
     3.568    54.328     0.200
     3.555    55.531     0.200
     3.613    56.070     0.200
     3.671    55.594     0.200
     3.728    56.852     0.200
     3.799    57.570     0.200
     3.853    55.469     0.200
     3.885    56.773     0.200
     3.894    57.164     0.200
     3.968    58.500     0.200
     4.021    59.961     0.200
     4.042    60.383     0.200
     4.109    61.273     0.200
     4.118    62.211     0.200
     4.125    60.672     0.200
     4.177    61.719     0.200
     4.228    62.844     0.200
     4.258    63.648     0.200
     4.335    64.867     0.200
     4.489    67.312     0.200
     4.508    66.250     0.200
     4.509    65.547     0.200
     4.545    66.734     0.200
     4.535    66.367     0.200
     4.655    69.445     0.200
     4.655    67.805     0.200
     4.702    69.578     0.200
     4.775    70.859     0.200
     4.954    73.766     0.200
     4.952    73.031     0.200
     5.100    74.242     0.200
     5.156    76.719     0.200
     5.160    76.453     0.200
     5.175    75.898     0.200
     5.169    74.734     0.200
     5.259    76.430     0.200
     5.313    78.297     0.200
     5.334    79.734     0.200
     5.479    80.648     0.200
     5.542    82.672     0.200
     5.551    82.109     0.200
     5.559    86.430     0.200
     5.616    82.969     0.200
     5.663    82.391     0.200
     5.815    86.000     0.200
     5.819    85.484     0.200
     5.883    86.398     0.200
     5.889    86.617     0.200
     5.942    87.016     0.200
     6.147    90.695     0.200
     6.414    94.234     0.200
     6.433    94.695     0.200
     6.479    95.758     0.200
     6.569    98.672     0.200
     6.573    96.328     0.200
     6.583    96.484     0.200
     6.622    99.273     0.200
     6.729    98.469     0.200
     6.931   101.773     0.200
     7.011   102.961     0.200
     7.040   102.188     0.200
     7.090   103.961     0.200
     7.121   103.578     0.200
     7.204   104.562     0.200
     7.230   105.836     0.200
     7.250   105.961     0.200
     7.352   108.094     0.200
     7.353   108.594     0.200
     7.483   108.070     0.200
     7.511   108.766     0.200
     7.518   110.438     0.200
     7.557   110.703     0.200
     7.602   112.555     0.200
     7.664   111.414     0.200
     7.704   113.398     0.200
     7.804   113.445     0.200
     7.804   113.250     0.200
     7.912   116.992     0.200
     7.915   116.180     0.200
     8.062   118.328     0.200
     8.103   119.375     0.200
     8.114   116.484     0.200
     8.273   118.773     0.200
     8.273   119.898     0.200
     8.296   120.469     0.200
     8.383   121.391     0.200
     8.579   124.484     0.200
     8.592   128.469     0.200
     8.653   126.742     0.200
     9.069   132.250     0.200
     9.132   132.359     0.200
     9.169   133.422     0.200
     9.288   134.289     0.200
     9.427   140.039     0.200
     9.528   136.555     0.200
     9.629   138.852     0.200
     9.963   142.773     0.200
    10.225   146.711     0.200
    10.299   149.773     0.200
    10.495   150.195     0.200
    10.742   154.633     0.200
    10.967   160.453     0.200
    10.967   157.992     0.200
    11.112   160.930     0.200
    11.262   162.773     0.200
    11.447   165.484     0.200
    11.632   166.680     0.200
    11.743   168.875     0.200
    11.837   170.812     0.200
    11.932   172.664     0.200
    12.473   181.109     0.200
    12.482   178.750     0.200
    12.504   183.320     0.200
    12.661   181.570     0.200
    12.725   186.211     0.200
    13.432   193.883     0.200
    13.406   190.172     0.200
    13.497   191.602     0.200
    13.533   194.180     0.200
    13.749   196.695     0.200
    13.987   197.023     0.200
    14.287   202.609     0.200
    14.395   204.531     0.200
    14.488   206.562     0.200
    14.528   207.984     0.200
    14.623   205.969     0.200
    14.835   209.922     0.200
    15.070   212.828     0.200
    15.113   215.273     0.200
    15.383   217.344     0.200
    15.423   219.672     0.200
    15.838   222.789     0.200
    15.849   224.773     0.200
    16.116   228.148     0.200
    16.273   228.344     0.200
    16.567   232.734     0.200
    16.872   236.172     0.200
    17.532   245.016     0.200
    18.071   251.000     0.200
    18.265   253.773     0.200
    20.068   278.969     0.200
     0.739    12.571     0.200
     1.204    19.665     0.200
     1.366    22.080     0.200
     1.329    22.344     0.200
     1.372    23.314     0.200
     1.466    23.343     0.200
     1.490    23.580     0.200
     1.406    24.145     0.200
     1.551    25.448     0.200
     1.640    25.789     0.200
     1.709    26.633     0.200
     1.859    29.030     0.200
     1.934    30.224     0.200
     2.102    32.719     0.200
     2.096    32.554     0.200
     2.210    34.020     0.200
     2.238    34.742     0.200
     2.201    33.279     0.200
     2.342    35.740     0.200
     2.387    36.613     0.200
     2.457    37.510     0.200
     2.481    38.106     0.200
     2.513    38.154     0.200
     2.627    41.114     0.200
     2.634    40.255     0.200
     2.640    40.129     0.200
     2.754    41.836     0.200
     2.806    42.266     0.200
     2.869    43.027     0.200
     2.871    43.292     0.200
     2.880    43.875     0.200
     2.906    43.787     0.200
     2.933    43.887     0.200
     2.935    47.864     0.200
     3.016    45.128     0.200
     3.093    46.142     0.200
     3.093    46.245     0.200
     3.075    45.545     0.200
     3.292    49.006     0.200
     3.281    49.134     0.200
     3.294    49.462     0.200
     3.379    50.801     0.200
     3.322    48.808     0.200
     3.410    50.410     0.200
     3.539    52.646     0.200
     3.574    54.508     0.200
     3.554    55.094     0.200
     3.610    55.194     0.200
     3.677    55.881     0.200
     3.735    55.778     0.200
     3.805    56.829     0.200
     3.858    57.134     0.200
     3.890    57.167     0.200
     3.898    57.293     0.200
     3.945    58.086     0.200
     3.974    58.453     0.200
     4.013    58.909     0.200
     4.026    59.323     0.200
     4.042    59.658     0.200
     4.047    60.594     0.200
     4.114    60.735     0.200
     4.126    60.476     0.200
     4.126    60.794     0.200
     4.125    61.811     0.200
     4.183    61.626     0.200
     4.234    63.209     0.200
     4.264    64.329     0.200
     4.295    64.542     0.200
     4.341    65.460     0.200
     4.495    67.806     0.200
     4.495    67.444     0.200
     4.513    66.030     0.200
     4.513    65.607     0.200
     4.540    66.439     0.200
     4.661    69.677     0.200
     4.708    70.150     0.200
     4.659    68.014     0.200
     4.779    70.960     0.200
     4.960    73.864     0.200
     4.958    73.243     0.200
     5.070    75.775     0.200
     5.105    74.180     0.200
     5.161    77.064     0.200
     5.166    77.229     0.200
     5.180    76.110     0.200
     5.174    74.733     0.200
     5.260    77.729     0.200
     5.263    76.096     0.200
     5.340    79.174     0.200
     5.319    78.459     0.200
     5.372    79.865     0.200
     5.515    81.790     0.200
     5.547    81.935     0.200
     5.555    82.071     0.200
     5.541    82.455     0.200
     5.622    83.042     0.200
     5.659    84.758     0.200
     5.668    82.209     0.200
     5.756    86.282     0.200
     5.825    86.013     0.200
     5.874    87.817     0.200
     5.888    86.298     0.200
     5.894    86.792     0.200
     6.008    89.896     0.200
     6.154    90.907     0.200
     6.289    91.951     0.200
     6.372    94.706     0.200
     6.418    94.578     0.200
     6.485    96.072     0.200
     6.574    99.804     0.200
     6.578    96.138     0.200
     6.621    96.375     0.200
     6.735    98.589     0.200
     6.820   101.328     0.200
     6.901   105.384     0.200
     6.932    99.104     0.200
     7.016   102.680     0.200
     7.095   104.257     0.200
     7.127   103.444     0.200
     7.210   104.844     0.200
     7.236   105.394     0.200
     7.255   106.009     0.200
     7.360   108.995     0.200
     7.489   108.094     0.200
     7.517   108.714     0.200
     7.711   112.444     0.200
     7.810   113.604     0.200
     7.810   113.034     0.200
     7.919   116.935     0.200
     7.922   116.284     0.200
     7.939   114.245     0.200
     8.120   117.654     0.200
     8.278   119.804     0.200
     8.278   119.384     0.200
     8.584   127.014     0.200
     8.598   128.824     0.200
     8.658   128.364     0.200
     8.715   132.334     0.200
     9.138   131.194     0.200
     9.293   133.955     0.200
     9.533   135.284     0.200
     9.425   139.349     0.200
     9.635   138.935     0.200
    10.302   152.014     0.200
    10.499   150.354     0.200
    10.748   156.634     0.200
    10.829   157.054     0.200
    10.969   161.096     0.200
    11.117   161.935     0.200
    11.268   165.225     0.200
    11.268   165.104     0.200
    11.330   164.594     0.200
    11.452   165.754     0.200
    11.549   167.435     0.200
    11.595   165.435     0.200
    11.638   166.384     0.200
    11.748   168.384     0.200
    11.842   171.564     0.200
    11.937   172.524     0.200
    12.509   183.044     0.200
    12.667   184.084     0.200
    12.695   182.214     0.200
    13.067   189.924     0.200
    13.411   191.864     0.200
    13.503   193.884     0.200
    13.538   195.625     0.200
    13.752   194.014     0.200
    13.993   197.274     0.200
    14.291   202.415     0.200
    14.629   205.884     0.200
    18.506   255.544     0.200
    20.968   284.165     0.200
     1.254    20.414     0.200
     1.319    22.852     0.200
     1.357    22.203     0.200
     1.366    23.688     0.200
     1.359    24.211     0.200
     1.499    23.781     0.200
     1.542    24.430     0.200
     1.586    26.227     0.200
     1.607    25.734     0.200
     1.693    26.422     0.200
     1.756    27.562     0.200
     1.881    29.453     0.200
     1.980    30.977     0.200
     2.083    32.555     0.200
     2.135    33.102     0.200
     2.170    33.180     0.200
     2.212    34.242     0.200
     2.393    36.648     0.200
     2.429    37.359     0.200
     2.470    37.961     0.200
     2.513    38.625     0.200
     2.565    39.156     0.200
     2.674    41.727     0.200
     2.625    40.078     0.200
     2.683    41.188     0.200
     2.791    42.867     0.200
     2.785    43.289     0.200
     2.801    42.508     0.200
     2.891    44.117     0.200
     2.914    44.656     0.200
     2.927    44.438     0.200
     2.941    44.922     0.200
     2.941    44.203     0.200
     3.067    46.438     0.200
     3.056    45.594     0.200
     3.146    48.984     0.200
     3.146    47.508     0.200
     3.295    48.742     0.200
     3.601    53.648     0.200
     3.642    53.352     0.200
     3.836    55.297     0.200
     4.095    61.672     0.200
     4.177    63.633     0.200
     4.514    67.945     0.200
     5.380    79.711     0.200
     5.588    82.203     0.200
     6.611   100.273     0.200
     6.984   102.336     0.200
     7.122   103.414     0.200
     7.203   104.984     0.200
     7.377   109.648     0.200
     7.481   108.188     0.200
     7.510   108.742     0.200
     7.643   112.617     0.200
     7.743   113.492     0.200
     7.807   114.031     0.200
     7.807   113.625     0.200
     7.943   116.984     0.200
     7.943   117.367     0.200
     7.997   120.422     0.200
     8.158   119.008     0.200
     8.158   122.055     0.200
     8.326   120.758     0.200
     8.436   122.102     0.200
     8.483   122.266     0.200
     8.625   126.047     0.200
     8.636   127.586     0.200
     8.701   127.062     0.200
     8.753   129.562     0.200
     8.755   131.047     0.200
     8.988   129.734     0.200
     9.180   135.648     0.200
     9.273   134.422     0.200
     9.372   136.352     0.200
     9.576   138.688     0.200
     9.646   139.953     0.200
    10.354   150.445     0.200
    10.768   157.461     0.200
    10.869   159.594     0.200
    11.021   163.469     0.200
    11.305   164.844     0.200
    11.305   164.703     0.200
    11.300   163.836     0.200
    11.371   165.742     0.200
    11.492   167.312     0.200
    11.590   168.977     0.200
    11.610   168.727     0.200
    11.636   169.367     0.200
    11.630   167.531     0.200
    11.788   170.148     0.200
    11.883   172.398     0.200
    11.978   174.078     0.200
    12.529   182.594     0.200
    12.554   183.406     0.200
    12.708   183.047     0.200
    12.735   186.672     0.200
    12.773   186.445     0.200
    12.814   185.672     0.200
    13.112   191.148     0.200
    13.386   192.383     0.200
    13.481   195.414     0.200
    13.542   194.133     0.200
    13.582   194.922     0.200
    13.805   200.836     0.200
    14.064   200.117     0.200
    14.447   206.336     0.200
    14.579   209.586     0.200
    14.886   211.773     0.200
    15.122   215.531     0.200
    15.169   216.672     0.200
    15.192   217.367     0.200
    15.346   218.562     0.200
    15.474   219.742     0.200
    15.880   224.648     0.200
    16.578   232.516     0.200
    16.672   234.602     0.200
    16.853   236.156     0.200
    18.260   253.492     0.200
    18.523   258.078     0.200
    19.960   277.016     0.200
     0.721    12.234     0.200
     0.744    12.656     0.200
     1.110    18.641     0.200
     1.203    20.617     0.200
     1.269    20.641     0.200
     1.303    20.711     0.200
     1.364    24.164     0.200
     1.358    23.469     0.200
     1.482    23.508     0.200
     1.561    24.680     0.200
     1.586    24.938     0.200
     1.586    24.836     0.200
     1.645    26.289     0.200
     1.722    26.766     0.200
     1.760    27.227     0.200
     1.849    28.289     0.200
     2.026    31.633     0.200
     2.032    31.383     0.200
     2.110    32.078     0.200
     2.163    32.992     0.200
     2.567    38.430     0.200
     2.679    42.039     0.200
     2.979    46.648     0.200
     2.998    44.797     0.200
     3.235    47.891     0.200
     3.253    48.758     0.200
     3.268    49.180     0.200
     3.338    49.047     0.200
     3.340    48.719     0.200
     3.490    51.039     0.200
     3.604    52.750     0.200
     3.653    57.398     0.200
     3.688    53.852     0.200
     3.776    55.539     0.200
     3.812    55.281     0.200
     3.810    55.719     0.200
     3.917    57.641     0.200
     4.070    58.961     0.200
     4.102    61.758     0.200
     4.148    61.250     0.200
     4.190    60.898     0.200
     4.262    62.641     0.200
     4.428    65.016     0.200
     4.444    64.227     0.200
     4.464    65.367     0.200
     4.478    67.883     0.200
     4.569    66.984     0.200
     4.902    72.867     0.200
     4.984    74.422     0.200
     5.030    72.422     0.200
     5.112    75.406     0.200
     5.180    77.891     0.200
     5.174    74.992     0.200
     5.260    77.812     0.200
     5.333    78.273     0.200
     5.371    80.406     0.200
     5.377    78.625     0.200
     5.719    82.648     0.200
     6.307    90.328     0.200
     6.439    94.422     0.200
     6.473    95.914     0.200
     6.547    96.250     0.200
     7.148   104.062     0.200
     7.339   108.648     0.200
     7.339   108.172     0.200
     7.426   108.477     0.200
     7.721   113.375     0.200
     7.755   113.797     0.200
     7.967   117.398     0.200
     8.145   118.203     0.200
     8.402   120.273     0.200
     8.443   122.367     0.200
     8.990   132.086     0.200
     9.653   138.914     0.200
    10.407   149.609     0.200
     0.705    12.929     0.200
     0.935    15.528     0.200
     1.268    22.729     0.200
     1.674    26.309     0.200
     2.856    44.769     0.200
     3.027    47.679     0.200
     3.305    51.699     0.200
     3.863    57.159     0.200
     4.307    65.818     0.200
     4.659    70.789     0.200
     5.560    82.699     0.200
     6.788   103.209     0.200
     7.204   105.278     0.200
     7.278   106.528     0.200
     7.517   110.969     0.200
     7.555   109.869     0.200
     7.588   110.679     0.200
     7.897   114.733     0.200
     7.913   115.438     0.200
     8.094   118.429     0.200
     8.098   119.629     0.200
     8.480   121.749     0.200
     9.773   142.479     0.200
    10.447   150.559     0.200
    11.481   168.024     0.200
     1.187    21.891     0.200
     1.293    21.008     0.200
     1.325    21.648     0.200
     1.512    23.969     0.200
     1.587    25.344     0.200
     1.596    25.133     0.200
     1.596    24.961     0.200
     1.639    27.023     0.200
     1.741    27.266     0.200
     1.787    27.906     0.200
     1.879    29.383     0.200
     2.046    31.812     0.200
     2.120    32.375     0.200
     2.146    33.102     0.200
     2.188    33.742     0.200
     2.433    37.109     0.200
     2.453    37.656     0.200
     2.458    37.914     0.200
     2.522    38.516     0.200
     2.585    39.469     0.200
     2.613    39.680     0.200
     2.706    42.242     0.200
     2.771    42.172     0.200
     2.922    43.695     0.200
     2.984    45.711     0.200
     3.109    46.500     0.200
     3.195    48.602     0.200
     3.247    48.344     0.200
     3.367    50.266     0.200
     3.371    50.234     0.200
     3.464    52.383     0.200
     3.515    52.492     0.200
     3.634    55.258     0.200
     3.658    54.070     0.200
     3.718    56.273     0.200
     3.791    55.789     0.200
     3.795    56.898     0.200
     3.821    56.516     0.200
     3.829    57.016     0.200
     3.940    58.023     0.200
     4.128    62.102     0.200
     4.138    61.828     0.200
     4.177    62.664     0.200
     4.215    63.375     0.200
     4.232    63.484     0.200
     4.292    64.945     0.200
     4.392    66.023     0.200
     4.441    65.367     0.200
     4.507    67.742     0.200
     4.579    67.203     0.200
     4.609    68.477     0.200
     4.736    70.742     0.200
     4.861    72.383     0.200
     5.104    74.156     0.200
     5.184    75.766     0.200
     5.210    77.539     0.200
     5.283    78.305     0.200
     5.400    80.805     0.200
     5.607    81.562     0.200
     5.610    82.945     0.200
     7.005   101.453     0.200
     7.038   102.508     0.200
     7.091   103.398     0.200
     7.170   104.672     0.200
     7.367   109.148     0.200
     7.448   108.078     0.200
     7.478   108.805     0.200
     7.656   111.391     0.200
     7.778   113.078     0.200
     7.778   113.883     0.200
     7.939   116.383     0.200
     7.941   117.734     0.200
     7.997   114.258     0.200
     8.416   120.891     0.200
     8.652   128.133     0.200
     8.726   127.773     0.200
     8.771   129.773     0.200
     9.203   136.844     0.200
     9.229   134.062     0.200
     9.563   140.805     0.200
     9.601   140.203     0.200
     9.631   139.758     0.200
     9.635   136.203     0.200
     9.682   142.633     0.200
    10.415   150.102     0.200
    10.762   157.352     0.200
    11.196   165.750     0.200
    11.320   161.758     0.200
    11.320   165.852     0.200
    11.393   166.461     0.200
    11.513   168.250     0.200
    11.597   165.133     0.200
    11.611   169.422     0.200
    11.631   169.133     0.200
    11.809   171.734     0.200
    11.903   170.273     0.200
    12.000   174.602     0.200
    12.230   177.680     0.200
    12.582   184.875     0.200
    12.823   188.008     0.200
    13.139   192.242     0.200
    13.145   192.211     0.200
    13.339   191.750     0.200
    13.506   195.273     0.200
    13.561   194.664     0.200
    13.610   197.164     0.200
    13.852   200.195     0.200
    13.949   199.023     0.200
    14.478   207.383     0.200
    14.662   209.469     0.200
    16.233   223.305     0.200
    16.594   231.805     0.200
    18.125   250.859     0.200
    18.514   255.680     0.200
    20.912   284.570     0.200
     0.795    13.398     0.200
     0.795    12.914     0.200
     0.965    15.805     0.200
     1.253    20.367     0.200
     1.279    22.133     0.200
     1.324    23.805     0.200
     1.354    23.797     0.200
     1.403    22.648     0.200
     1.514    24.125     0.200
     1.514    23.992     0.200
     1.522    24.086     0.200
     1.541    25.594     0.200
     1.649    25.945     0.200
     1.680    26.375     0.200
     1.762    27.719     0.200
     1.944    30.500     0.200
     2.130    33.141     0.200
     2.159    33.203     0.200
     2.216    33.672     0.200
     2.255    34.398     0.200
     2.265    35.641     0.200
     2.389    36.562     0.200
     2.443    37.492     0.200
     2.508    38.383     0.200
     2.552    39.164     0.200
     2.651    40.781     0.200
     2.679    41.977     0.200
     2.672    40.602     0.200
     2.739    41.852     0.200
     2.748    41.797     0.200
     2.846    42.680     0.200
     2.892    43.367     0.200
     2.962    44.414     0.200
     2.981    44.930     0.200
     3.062    45.906     0.200
     3.092    46.758     0.200
     3.104    45.984     0.200
     3.130    47.109     0.200
     3.302    49.727     0.200
     3.342    49.164     0.200
     3.533    52.406     0.200
     3.566    52.961     0.200
     3.566    54.125     0.200
     3.584    53.219     0.200
     3.622    53.945     0.200
     3.854    57.945     0.200
     3.883    56.172     0.200
     3.918    57.242     0.200
     3.916    57.195     0.200
     3.961    59.125     0.200
     4.015    59.172     0.200
     4.048    59.758     0.200
     4.150    61.242     0.200
     4.150    61.547     0.200
     4.177    62.164     0.200
     4.219    62.383     0.200
     4.280    63.758     0.200
     4.320    65.070     0.200
     4.459    66.461     0.200
     4.549    68.500     0.200
     4.549    69.070     0.200
     4.535    66.016     0.200
     4.547    67.109     0.200
     4.675    68.164     0.200
     4.686    68.961     0.200
     4.821    70.867     0.200
     4.977    74.195     0.200
     5.003    74.547     0.200
     5.124    77.133     0.200
     5.136    75.070     0.200
     5.197    75.133     0.200
     5.215    76.781     0.200
     5.280    76.703     0.200
     5.359    79.258     0.200
     5.396    80.344     0.200
     5.420    80.953     0.200
     5.594    88.375     0.200
     5.592    84.031     0.200
     5.603    83.047     0.200
     5.670    83.828     0.200
     5.697    82.789     0.200
     5.755    84.344     0.200
     5.826    84.914     0.200
     5.879    86.695     0.200
     5.930    88.219     0.200
     5.937    87.414     0.200
     6.056    89.109     0.200
     6.128    90.633     0.200
     6.145    91.016     0.200
     6.203    92.000     0.200
     6.335    93.445     0.200
     6.407    94.836     0.200
     6.428    95.336     0.200
     6.413    93.094     0.200
     6.448    93.523     0.200
     6.540    96.641     0.200
     6.543    95.680     0.200
     6.631    98.453     0.200
     6.636    96.234     0.200
     6.648    97.578     0.200
     6.655    98.531     0.200
     6.662    97.750     0.200
     6.674    98.836     0.200
     6.875   102.125     0.200
     6.912   102.477     0.200
     6.958   101.883     0.200
     7.074   102.930     0.200
     7.107   104.633     0.200
     7.128   103.508     0.200
     7.168   104.812     0.200
     7.213   104.711     0.200
     7.249   105.484     0.200
     7.257   106.656     0.200
     7.274   106.711     0.200
     7.345   108.508     0.200
     7.413   109.250     0.200
     7.413   109.742     0.200
     7.459   110.367     0.200
     7.527   109.594     0.200
     7.533   111.031     0.200
     7.556   109.531     0.200
     7.665   112.742     0.200
     7.710   113.125     0.200
     7.697   110.836     0.200
     7.740   112.156     0.200
     7.750   113.484     0.200
     7.767   113.266     0.200
     7.767   112.742     0.200
     7.839   114.617     0.200
     7.852   113.352     0.200
     7.852   113.227     0.200
     7.893   115.352     0.200
     7.912   114.500     0.200
     7.926   115.930     0.200
     7.959   114.391     0.200
     7.974   117.820     0.200
     7.976   116.766     0.200
     7.973   115.867     0.200
     7.993   117.125     0.200
     8.047   118.344     0.200
     8.047   120.633     0.200
     8.079   118.383     0.200
     8.123   119.516     0.200
     8.134   119.305     0.200
     8.152   120.273     0.200
     8.155   119.062     0.200
     8.176   122.711     0.200
     8.204   118.430     0.200
     8.212   120.242     0.200
     8.320   120.531     0.200
     8.352   120.859     0.200
     8.350   119.375     0.200
     8.391   123.133     0.200
     8.378   119.898     0.200
     8.460   121.055     0.200
     8.468   121.648     0.200
     8.539   124.484     0.200
     8.576   124.734     0.200
     8.628   127.758     0.200
     8.655   128.016     0.200
     8.709   127.867     0.200
     8.713   126.750     0.200
     8.728   128.484     0.200
     8.752   126.750     0.200
     8.771   127.523     0.200
     8.798   128.102     0.200
     8.878   129.414     0.200
     8.903   128.133     0.200
     8.939   128.891     0.200
     8.960   132.242     0.200
     8.966   130.539     0.200
     9.011   131.039     0.200
     9.008   130.664     0.200
     9.004   132.008     0.200
     9.025   132.680     0.200
     9.038   133.109     0.200
     9.063   132.688     0.200
     9.081   130.797     0.200
     9.195   133.375     0.200
     9.269   136.672     0.200
     9.342   137.359     0.200
     9.430   138.367     0.200
     9.503   137.266     0.200
     9.552   137.719     0.200
     9.553   138.094     0.200
     9.587   138.523     0.200
     9.588   137.953     0.200
     9.601   140.516     0.200
     9.624   139.609     0.200
     9.625   138.383     0.200
     9.678   141.961     0.200
     9.685   140.719     0.200
     9.702   141.273     0.200
     9.764   140.898     0.200
     9.750   140.336     0.200
     9.804   143.477     0.200
     9.825   142.570     0.200
     9.832   143.055     0.200
     9.833   141.383     0.200
     9.876   143.797     0.200
     9.892   142.539     0.200
     9.896   144.867     0.200
     9.936   145.484     0.200
    10.006   145.414     0.200
    10.067   145.992     0.200
    10.055   144.633     0.200
    10.096   147.453     0.200
    10.111   146.656     0.200
    10.146   145.852     0.200
    10.167   147.844     0.200
    10.177   149.133     0.200
    10.202   148.977     0.200
    10.275   149.055     0.200
    10.267   148.859     0.200
    10.321   151.023     0.200
    10.311   145.906     0.200
    10.322   147.891     0.200
    10.354   150.914     0.200
    10.342   151.375     0.200
    10.386   151.203     0.200
    10.397   152.188     0.200
    10.398   153.133     0.200
    10.412   154.086     0.200
    10.456   152.375     0.200
    10.488   151.727     0.200
    10.516   153.297     0.200
    10.512   150.797     0.200
    10.578   153.758     0.200
    10.588   152.492     0.200
    10.674   155.062     0.200
    10.701   153.773     0.200
    10.728   154.297     0.200
    10.799   157.680     0.200
    10.802   157.961     0.200
    10.802   156.930     0.200
    10.884   158.992     0.200
    10.899   159.117     0.200
    10.916   159.398     0.200
    10.951   157.141     0.200
    11.002   160.523     0.200
    11.002   161.883     0.200
    11.002   160.977     0.200
    10.995   158.391     0.200
    11.019   159.961     0.200
    11.023   160.062     0.200
    11.056   158.961     0.200
    11.104   158.641     0.200
    11.169   162.945     0.200
    11.192   161.852     0.200
    11.222   161.812     0.200
    11.252   162.391     0.200
    11.324   165.562     0.200
    11.324   162.875     0.200
    11.359   165.039     0.200
    11.377   165.938     0.200
    11.385   166.352     0.200
    11.508   167.266     0.200
    11.537   167.469     0.200
    11.588   167.719     0.200
    11.605   168.945     0.200
    11.607   169.227     0.200
    11.615   167.797     0.200
    11.654   167.875     0.200
    11.804   170.547     0.200
    11.855   170.844     0.200
    11.898   169.586     0.200
    11.935   170.523     0.200
    11.956   171.430     0.200
    11.993   174.305     0.200
    12.100   175.398     0.200
    12.104   176.820     0.200
    12.136   176.320     0.200
    12.176   178.086     0.200
    12.224   177.016     0.200
    12.297   179.078     0.200
    12.373   178.344     0.200
    12.400   177.953     0.200
    12.543   178.891     0.200
    12.584   180.766     0.200
    12.698   182.578     0.200
    12.704   184.266     0.200
    12.709   184.781     0.200
    12.722   183.133     0.200
    12.767   184.625     0.200
    12.942   184.297     0.200
    13.033   185.172     0.200
    13.039   188.234     0.200
    13.040   187.164     0.200
    13.224   189.219     0.200
    13.337   193.148     0.200
    13.365   192.602     0.200
    13.393   192.250     0.200
    13.394   192.641     0.200
    13.425   192.203     0.200
    13.433   189.953     0.200
    13.433   193.281     0.200
    13.452   193.766     0.200
    13.482   194.219     0.200
    13.492   195.359     0.200
    13.492   195.172     0.200
    13.559   195.070     0.200
    13.559   195.281     0.200
    13.591   196.977     0.200
    13.604   195.023     0.200
    13.662   194.820     0.200
    13.954   198.531     0.200
    13.968   200.945     0.200
    14.052   202.242     0.200
    14.071   202.055     0.200
    14.162   203.883     0.200
    14.255   204.891     0.200
    14.347   205.852     0.200
    14.397   203.500     0.200
    14.452   206.836     0.200
    14.452   204.117     0.200
    14.498   206.367     0.200
    14.552   208.133     0.200
    14.586   209.102     0.200
    14.685   207.906     0.200
    14.732   209.586     0.200
    14.754   209.945     0.200
    14.784   211.500     0.200
    14.841   211.352     0.200
    14.892   212.164     0.200
    14.926   211.523     0.200
    14.933   212.812     0.200
    15.127   215.016     0.200
    15.143   214.961     0.200
    15.187   216.453     0.200
    15.273   216.500     0.200
    15.499   219.797     0.200
    15.557   219.766     0.200
    15.679   221.523     0.200
    15.778   222.891     0.200
    15.900   224.680     0.200
    15.900   223.102     0.200
    15.901   223.820     0.200
    16.021   225.070     0.200
    16.036   225.023     0.200
    16.052   225.305     0.200
    16.061   225.438     0.200
    16.318   229.180     0.200
    16.517   231.633     0.200
    16.619   232.859     0.200
    16.755   233.375     0.200
    16.945   236.781     0.200
    17.389   242.281     0.200
    17.392   242.234     0.200
    17.747   246.867     0.200
    18.133   248.086     0.200
    18.307   252.984     0.200
    18.559   257.281     0.200
     0.773    12.951     0.200
     1.272    21.592     0.200
     1.332    21.672     0.200
     2.555    40.092     0.200
     2.712    42.441     0.200
     3.386    50.871     0.200
     3.967    57.922     0.200
     4.006    58.332     0.200
     4.543    68.512     0.200
     5.417    80.281     0.200
     6.454    94.121     0.200
     6.777    97.701     0.200
     7.328   106.711     0.200
     7.574   109.082     0.200
     7.608   110.391     0.200
     7.633   110.842     0.200
     7.916   115.121     0.200
     7.916   114.201     0.200
     8.635   123.400     0.200
     9.842   140.381     0.200
    10.662   152.471     0.200
     1.187    21.325     0.200
     1.238    21.336     0.200
     1.333    21.840     0.200
     1.321    21.437     0.200
     1.302    22.836     0.200
     1.323    22.985     0.200
     1.378    24.405     0.200
     1.537    24.429     0.200
     1.619    25.315     0.200
     1.767    27.684     0.200
     1.815    28.540     0.200
     2.054    32.216     0.200
     2.114    32.349     0.200
     2.201    34.133     0.200
     2.460    37.652     0.200
     2.734    43.105     0.200
     2.759    42.307     0.200
     3.002    46.436     0.200
     3.055    48.195     0.200
     3.791    55.796     0.200
     4.254    64.956     0.200
     4.526    68.306     0.200
     5.427    81.275     0.200
     5.637    83.905     0.200
     6.521    97.046     0.200
     6.653   101.445     0.200
     7.100   104.436     0.200
     7.178   104.855     0.200
     7.386   108.996     0.200
     7.455   108.476     0.200
     7.486   109.115     0.200
     7.682   114.605     0.200
     7.776   116.206     0.200
     7.788   113.766     0.200
     7.788   113.166     0.200
     8.084   119.105     0.200
     8.388   121.666     0.200
     8.414   120.806     0.200
     8.797   126.115     0.200
     9.230   132.815     0.200
     9.583   139.785     0.200
     9.636   139.905     0.200
    10.408   149.945     0.200
    10.782   157.586     0.200
    11.224   164.896     0.200
    11.346   161.355     0.200
    11.346   164.666     0.200
    11.420   168.105     0.200
    11.605   169.386     0.200
    11.638   170.706     0.200
    11.930   174.596     0.200
    13.955   200.306     0.200
    14.637   207.456     0.200
    14.685   208.096     0.200
    14.945   212.775     0.200
    15.497   217.905     0.200
    15.969   224.865     0.200
     1.037    17.969     0.200
     1.200    20.148     0.200
     1.200    19.992     0.200
     1.403    24.461     0.200
     1.553    25.453     0.200
     1.618    26.379     0.200
     1.775    28.434     0.200
     1.896    30.609     0.200
     1.916    30.426     0.200
     2.610    41.148     0.200
     2.648    40.793     0.200
     2.914    48.348     0.200
     3.000    47.867     0.200
     3.306    51.047     0.200
     3.541    56.699     0.200
     4.187    61.500     0.200
     4.216    64.168     0.200
     4.959    75.797     0.200
     5.759    86.258     0.200
     5.962    89.699     0.200
     6.626    98.527     0.200
     6.646    99.910     0.200
     6.989   103.938     0.200
     7.009   107.238     0.200
     7.037   106.477     0.200
     7.539   111.270     0.200
     7.614   111.809     0.200
     7.823   115.938     0.200
     7.890   115.988     0.200
     8.161   121.539     0.200
     8.232   118.820     0.200
     9.627   139.609     0.200
    10.011   147.559     0.200
    10.735   154.340     0.200
    11.702   170.238     0.200
    14.759   209.430     0.200
     1.178    18.922     0.200
     1.199    21.469     0.200
     1.210    21.438     0.200
     1.286    21.000     0.200
     1.342    21.852     0.200
     1.323    23.695     0.200
     1.333    23.117     0.200
     1.333    22.875     0.200
     1.390    21.953     0.200
     1.375    24.273     0.200
     1.413    23.625     0.200
     1.515    24.102     0.200
     1.528    25.883     0.200
     1.573    25.258     0.200
     1.580    25.219     0.200
     1.580    25.016     0.200
     1.620    26.023     0.200
     1.618    26.688     0.200
     1.641    26.398     0.200
     1.647    26.664     0.200
     1.703    27.188     0.200
     1.729    27.117     0.200
     1.783    28.102     0.200
     1.842    28.883     0.200
     1.923    30.188     0.200
     1.927    30.406     0.200
     2.017    31.672     0.200
     2.140    32.445     0.200
     2.150    33.375     0.200
     2.203    34.062     0.200
     2.425    37.273     0.200
     2.425    37.156     0.200
     2.469    38.320     0.200
     2.601    39.508     0.200
     2.721    41.758     0.200
     2.724    42.172     0.200
     2.965    47.648     0.200
     3.018    46.273     0.200
     3.100    46.602     0.200
     3.182    48.148     0.200
     3.611    53.656     0.200
     3.808    57.469     0.200
     3.811    55.266     0.200
     4.031    60.164     0.200
     4.103    60.500     0.200
     4.123    61.586     0.200
     4.123    61.172     0.200
     4.215    62.617     0.200
     4.215    62.281     0.200
     4.517    68.188     0.200
     4.533    68.195     0.200
     4.742    71.109     0.200
     4.952    73.422     0.200
     5.205    75.750     0.200
     5.237    77.359     0.200
     5.373    80.484     0.200
     5.373    80.164     0.200
     5.627    82.203     0.200
     5.689    83.164     0.200
     5.753    83.633     0.200
     5.842    85.141     0.200
     5.967    88.078     0.200
     5.967    87.641     0.200
     5.995    88.109     0.200
     6.283    92.352     0.200
     6.343    92.016     0.200
     6.343    92.266     0.200
     6.477    94.750     0.200
     6.586    96.711     0.200
     6.604    96.984     0.200
     6.609    97.383     0.200
     6.610   100.039     0.200
     6.707    97.234     0.200
     6.871   101.820     0.200
     6.940    99.992     0.200
     7.005   101.469     0.200
     6.991   102.992     0.200
     7.022   101.992     0.200
     7.061   102.680     0.200
     7.108   103.766     0.200
     7.150   103.891     0.200
     7.187   104.766     0.200
     7.209   106.711     0.200
     7.212   105.234     0.200
     7.237   106.680     0.200
     7.378   109.359     0.200
     7.378   109.258     0.200
     7.465   108.523     0.200
     7.489   110.125     0.200
     7.495   108.977     0.200
     7.628   110.000     0.200
     7.659   114.539     0.200
     7.756   113.656     0.200
     7.790   114.000     0.200
     7.795   113.867     0.200
     7.795   113.719     0.200
     7.862   115.297     0.200
     7.896   113.609     0.200
     7.998   116.914     0.200
     8.033   118.406     0.200
     8.056   115.617     0.200
     8.094   119.250     0.200
     8.099   118.945     0.200
     8.098   118.227     0.200
     8.191   119.727     0.200
     8.278   118.938     0.200
     8.309   118.836     0.200
     8.355   122.445     0.200
     8.387   120.172     0.200
     8.402   120.797     0.200
     8.404   120.891     0.200
     8.436   120.703     0.200
     8.491   123.617     0.200
     8.516   123.234     0.200
     8.654   128.453     0.200
     8.684   127.398     0.200
     8.697   127.805     0.200
     8.695   125.859     0.200
     8.725   126.078     0.200
     8.761   127.883     0.200
     8.830   126.648     0.200
     8.861   129.352     0.200
     8.868   127.578     0.200
     8.929   128.750     0.200
     8.941   128.781     0.200
     8.957   131.023     0.200
     8.981   129.719     0.200
     8.997   132.031     0.200
     9.017   129.875     0.200
     9.042   132.188     0.200
     9.093   132.555     0.200
     9.134   132.047     0.200
     9.249   134.172     0.200
     9.335   136.648     0.200
     9.335   137.359     0.200
     9.400   137.023     0.200
     9.426   136.531     0.200
     9.445   136.344     0.200
     9.550   139.609     0.200
     9.558   138.148     0.200
     9.606   141.156     0.200
     9.644   141.172     0.200
     9.655   139.297     0.200
     9.677   139.422     0.200
     9.758   140.547     0.200
     9.830   141.570     0.200
     9.861   142.289     0.200
     9.979   144.875     0.200
     9.979   143.758     0.200
    10.077   145.875     0.200
    10.077   144.703     0.200
    10.152   147.195     0.200
    10.236   146.602     0.200
    10.248   147.281     0.200
    10.316   148.484     0.200
    10.365   150.875     0.200
    10.438   151.945     0.200
    10.435   150.062     0.200
    10.435   150.062     0.200
    10.436   150.062     0.200
    10.491   151.430     0.200
    10.528   151.172     0.200
    10.609   153.766     0.200
    10.609   152.953     0.200
    10.625   152.602     0.200
    10.655   155.695     0.200
    10.741   156.227     0.200
    10.772   157.375     0.200
    10.772   156.750     0.200
    10.814   155.398     0.200
    10.877   156.328     0.200
    10.890   158.977     0.200
    11.028   157.898     0.200
    11.031   159.648     0.200
    11.038   158.367     0.200
    11.059   163.133     0.200
    11.322   165.055     0.200
    11.322   164.969     0.200
    11.322   164.969     0.200
    11.335   163.070     0.200
    11.462   165.477     0.200
    11.513   167.188     0.200
    11.564   165.727     0.200
    11.611   168.742     0.200
    11.631   169.453     0.200
    11.647   167.953     0.200
    11.680   166.602     0.200
    11.734   170.977     0.200
    11.904   172.992     0.200
    11.932   172.781     0.200
    11.946   171.641     0.200
    12.000   174.742     0.200
    12.034   172.859     0.200
    12.058   174.125     0.200
    12.087   174.117     0.200
    12.140   174.117     0.200
    12.157   174.820     0.200
    12.220   175.422     0.200
    12.231   174.023     0.200
    12.550   181.492     0.200
    12.579   180.711     0.200
    12.638   182.164     0.200
    12.682   181.656     0.200
    12.690   182.539     0.200
    12.731   184.109     0.200
    12.802   184.984     0.200
    12.849   186.703     0.200
    12.974   185.570     0.200
    12.974   186.586     0.200
    13.210   186.555     0.200
    13.210   189.766     0.200
    13.250   189.367     0.200
    13.289   190.391     0.200
    13.328   190.734     0.200
    13.350   192.383     0.200
    13.359   192.578     0.200
    13.359   192.047     0.200
    13.367   192.234     0.200
    13.372   191.430     0.200
    13.414   193.234     0.200
    13.562   194.805     0.200
    13.608   195.055     0.200
    13.663   196.242     0.200
    13.672   195.445     0.200
    13.689   195.898     0.200
    13.967   198.516     0.200
    14.085   199.656     0.200
    14.376   202.477     0.200
    14.474   206.969     0.200
    14.617   208.617     0.200
    14.668   207.195     0.200
    14.913   213.625     0.200
    14.930   213.156     0.200
    14.926   211.055     0.200
    14.936   213.688     0.200
    15.107   213.695     0.200
    15.107   214.617     0.200
    15.149   212.898     0.200
    15.204   215.719     0.200
    15.424   219.172     0.200
    15.515   219.156     0.200
    15.575   220.422     0.200
    15.896   224.195     0.200
    16.186   224.578     0.200
    16.365   230.039     0.200
    16.386   228.016     0.200
    16.519   232.766     0.200
    16.700   233.359     0.200
    16.827   236.227     0.200
    17.376   243.062     0.200
    17.496   244.062     0.200
    18.128   249.742     0.200
    18.525   258.023     0.200
    19.505   269.938     0.200
     1.194    19.135     0.200
     1.214    21.235     0.200
     1.188    21.385     0.200
     1.302    21.249     0.200
     1.316    21.365     0.200
     1.347    22.014     0.200
     1.315    23.555     0.200
     1.316    23.075     0.200
     1.317    23.115     0.200
     1.367    24.215     0.200
     1.530    24.284     0.200
     1.585    25.415     0.200
     1.593    25.225     0.200
     1.632    26.225     0.200
     1.624    26.835     0.200
     1.653    26.565     0.200
     1.657    26.845     0.200
     1.744    27.323     0.200
     1.799    28.366     0.200
     1.857    29.095     0.200
     1.934    30.355     0.200
     1.939    30.565     0.200
     2.028    31.757     0.200
     2.137    32.656     0.200
     2.210    34.138     0.200
     2.441    37.414     0.200
     2.480    38.120     0.200
     2.733    41.937     0.200
     2.735    42.305     0.200
     2.976    45.935     0.200
     3.029    49.735     0.200
     3.116    46.805     0.200
     3.198    49.315     0.200
     3.382    51.121     0.200
     3.817    57.849     0.200
     3.811    56.405     0.200
     4.043    60.141     0.200
     4.140    62.015     0.200
     4.137    61.375     0.200
     4.228    63.035     0.200
     4.228    62.329     0.200
     4.528    68.705     0.200
     4.543    67.780     0.200
     4.756    71.396     0.200
     4.959    73.195     0.200
     5.002    74.295     0.200
     5.202    76.224     0.200
     5.248    80.195     0.200
     5.382    80.475     0.200
     5.382    80.289     0.200
     5.417    80.835     0.200
     5.627    82.166     0.200
     5.691    83.347     0.200
     5.674    83.805     0.200
     5.752    84.543     0.200
     5.840    85.738     0.200
     5.983    88.915     0.200
     5.983    87.332     0.200
     5.999    88.276     0.200
     6.078    89.766     0.200
     6.291    92.089     0.200
     6.344    92.161     0.200
     6.480    94.791     0.200
     6.540    97.585     0.200
     6.559    95.515     0.200
     6.591    96.814     0.200
     6.626    96.905     0.200
     6.609    97.443     0.200
     6.618    97.556     0.200
     6.881   101.474     0.200
     7.006   102.316     0.200
     7.035   104.265     0.200
     7.064   102.472     0.200
     7.113   104.275     0.200
     7.154   104.007     0.200
     7.192   104.995     0.200
     7.216   104.800     0.200
     7.242   106.347     0.200
     7.352   109.825     0.200
     7.389   109.455     0.200
     7.389   108.997     0.200
     7.470   108.585     0.200
     7.498   109.923     0.200
     7.500   108.735     0.200
     7.675   115.735     0.200
     7.676   111.245     0.200
     7.801   114.145     0.200
     7.801   114.400     0.200
     7.821   114.055     0.200
     7.900   113.817     0.200
     8.014   120.245     0.200
     8.041   117.486     0.200
     8.072   115.915     0.200
     8.110   118.466     0.200
     8.105   117.894     0.200
     8.192   123.055     0.200
     8.278   119.057     0.200
     8.310   119.229     0.200
     8.371   119.305     0.200
     8.408   120.820     0.200
     8.405   120.667     0.200
     8.435   120.915     0.200
     8.499   123.191     0.200
     8.521   123.292     0.200
     8.701   125.449     0.200
     8.788   126.685     0.200
     8.828   127.035     0.200
     8.868   128.401     0.200
     8.927   129.199     0.200
     8.943   129.411     0.200
     8.982   129.732     0.200
     9.020   129.841     0.200
     9.138   132.150     0.200
     9.249   131.905     0.200
     9.411   136.879     0.200
     9.451   136.875     0.200
     9.584   139.815     0.200
     9.616   139.025     0.200
     9.619   140.175     0.200
     9.655   137.975     0.200
     9.756   141.019     0.200
     9.960   144.265     0.200
     9.975   143.611     0.200
    10.233   147.523     0.200
    10.431   149.945     0.200
    10.431   149.955     0.200
    10.612   150.975     0.200
    10.784   155.805     0.200
    11.647   167.935     0.200
    11.825   173.325     0.200
    12.016   175.245     0.200
    12.800   186.061     0.200
    13.153   191.075     0.200
    13.349   192.659     0.200
    13.358   192.345     0.200
    13.578   196.405     0.200
    13.606   195.480     0.200
    14.951   213.201     0.200
    15.108   211.785     0.200
    15.950   224.145     0.200
    16.826   234.665     0.200
     0.960    15.951     0.200
     1.223    21.211     0.200
     1.257    22.420     0.200
     1.697    26.842     0.200
     2.883    45.111     0.200
     3.045    48.711     0.200
     3.330    50.570     0.200
     3.717    56.891     0.200
     3.865    56.480     0.200
     4.304    64.791     0.200
     4.329    64.451     0.200
     4.679    70.682     0.200
     5.511    82.131     0.200
     5.587    83.490     0.200
     6.144    90.070     0.200
     6.564    96.410     0.200
     6.795    98.602     0.200
     7.287   106.420     0.200
     7.536   110.531     0.200
     7.564   109.451     0.200
     7.597   110.570     0.200
     7.785   115.531     0.200
     7.908   115.182     0.200
     8.115   119.551     0.200
     8.311   122.932     0.200
     8.481   121.262     0.200
     9.738   141.621     0.200
    10.442   151.102     0.200
    11.507   167.521     0.200
     0.998    16.812     0.200
     1.164    19.336     0.200
     1.250    21.383     0.200
     1.267    22.812     0.200
     1.362    22.195     0.200
     1.294    22.883     0.200
     1.291    23.211     0.200
     1.300    23.312     0.200
     1.432    23.211     0.200
     1.544    24.898     0.200
     1.587    25.539     0.200
     1.599    25.859     0.200
     1.624    27.922     0.200
     1.624    27.391     0.200
     2.232    34.594     0.200
     2.300    35.969     0.200
     2.502    37.789     0.200
     2.546    38.953     0.200
     2.799    42.531     0.200
     2.799    42.703     0.200
     2.950    44.875     0.200
     3.220    48.859     0.200
     3.798    56.312     0.200
     3.798    56.734     0.200
     3.850    58.164     0.200
     3.921    59.414     0.200
     4.123    60.102     0.200
     4.543    67.672     0.200
     4.543    68.016     0.200
     4.662    70.727     0.200
     5.102    76.109     0.200
     5.219    78.094     0.200
     5.433    79.914     0.200
     5.489    82.086     0.200
     5.489    82.227     0.200
     5.547    82.023     0.200
     5.670    83.234     0.200
     5.919    86.133     0.200
     5.950    87.141     0.200
     6.076    88.484     0.200
     6.105    92.062     0.200
     6.092    90.211     0.200
     6.211    91.242     0.200
     6.250    92.430     0.200
     6.460    98.500     0.200
     6.635    96.289     0.200
     6.716    99.430     0.200
     6.796    99.969     0.200
     6.804    99.852     0.200
     6.937   101.602     0.200
     7.218   107.195     0.200
     7.249   105.000     0.200
     7.332   107.922     0.200
     7.320   106.281     0.200
     7.376   107.391     0.200
     7.402   107.414     0.200
     7.435   108.891     0.200
     7.683   110.789     0.200
     7.921   115.641     0.200
     7.933   114.898     0.200
     7.977   115.984     0.200
     8.583   123.367     0.200
     8.591   123.078     0.200
     8.638   124.570     0.200
     8.661   124.320     0.200
     8.712   125.242     0.200
     8.753   125.461     0.200
     8.814   128.008     0.200
     9.155   131.492     0.200
     9.169   132.453     0.200
     9.202   132.430     0.200
     9.264   133.664     0.200
     9.348   135.016     0.200
    10.801   155.555     0.200
    10.849   155.109     0.200
    11.171   162.180     0.200
     1.011    17.361     0.200
     1.057    18.125     0.200
     1.312    21.775     0.200
     1.385    23.523     0.200
     1.459    24.338     0.200
     1.521    24.820     0.200
     1.671    29.135     0.200
     1.672    29.125     0.200
     1.742    28.125     0.200
     1.811    29.635     0.200
     2.091    33.086     0.200
     2.172    34.148     0.200
     2.408    39.863     0.200
     2.460    40.375     0.200
     2.514    39.125     0.200
     2.660    40.396     0.200
     2.673    41.287     0.200
     2.725    41.994     0.200
     3.684    55.725     0.200
     3.844    58.664     0.200
     4.281    63.064     0.200
     4.648    69.914     0.200
     5.252    79.254     0.200
     5.447    82.354     0.200
     5.489    82.234     0.200
     5.616    84.055     0.200
     6.499    96.834     0.200
     6.504    98.824     0.200
     6.791    99.145     0.200
     7.095   102.414     0.200
     7.454   109.305     0.200
     7.519   112.385     0.200
     7.549   110.125     0.200
     7.830   113.984     0.200
     7.955   118.285     0.200
     8.036   118.885     0.200
     8.118   117.795     0.200
     8.911   127.975     0.200
    10.999   160.943     0.200
     0.828    14.051     0.200
     0.924    15.811     0.200
     1.209    19.955     0.200
     1.198    20.217     0.200
     1.198    20.217     0.200
     1.285    20.834     0.200
     1.333    22.691     0.200
     1.443    23.039     0.200
     1.448    24.611     0.200
     1.504    25.150     0.200
     1.649    25.891     0.200
     1.757    27.568     0.200
     2.014    31.102     0.200
     2.014    30.736     0.200
     2.075    32.205     0.200
     2.423    37.070     0.200
     3.055    48.771     0.200
     3.112    50.561     0.200
     3.730    55.031     0.200
     4.100    61.910     0.200
     4.281    65.131     0.200
     4.408    66.900     0.200
     4.408    67.039     0.200
     4.656    70.240     0.200
     5.249    78.441     0.200
     5.343    79.740     0.200
     5.555    82.410     0.200
     5.951    88.121     0.200
     6.209    90.131     0.200
     6.554    98.471     0.200
     6.975   102.352     0.200
     7.054   103.041     0.200
     7.081   103.711     0.200
     7.266   107.311     0.200
     7.331   107.441     0.200
     7.585   112.252     0.200
     7.663   112.111     0.200
     7.663   111.391     0.200
     7.674   113.342     0.200
     7.766   113.021     0.200
     7.844   115.701     0.200
     7.849   115.980     0.200
     8.304   119.432     0.200
     8.333   123.711     0.200
     1.024    16.578     0.200
     0.976    16.156     0.200
     1.145    18.477     0.200
     1.309    21.000     0.200
     1.260    20.477     0.200
     1.352    21.469     0.200
     1.377    21.711     0.200
     1.294    22.781     0.200
     1.426    22.703     0.200
     1.452    23.922     0.200
     1.416    24.922     0.200
     1.409    24.383     0.200
     1.465    25.680     0.200
     1.409    24.531     0.200
     1.570    24.539     0.200
     1.570    24.438     0.200
     1.570    25.164     0.200
     1.573    25.016     0.200
     1.563    25.359     0.200
     1.618    25.836     0.200
     1.639    26.141     0.200
     1.662    26.641     0.200
     1.661    27.133     0.200
     1.661    27.156     0.200
     1.705    26.961     0.200
     1.712    26.844     0.200
     1.803    28.383     0.200
     1.932    30.070     0.200
     1.934    30.195     0.200
     2.030    31.578     0.200
     2.060    32.070     0.200
     2.094    32.945     0.200
     2.113    32.656     0.200
     2.195    34.250     0.200
     2.089    31.539     0.200
     2.294    36.031     0.200
     2.313    36.258     0.200
     2.313    36.070     0.200
     2.367    36.320     0.200
     2.371    36.641     0.200
     2.375    37.047     0.200
     2.560    38.914     0.200
     2.631    41.180     0.200
     2.724    41.680     0.200
     2.728    42.148     0.200
     2.795    42.109     0.200
     2.849    43.336     0.200
     2.862    42.922     0.200
     2.870    43.539     0.200
     2.865    43.688     0.200
     2.865    43.688     0.200
     2.884    43.125     0.200
     2.975    44.938     0.200
     3.031    45.602     0.200
     3.045    46.016     0.200
     3.045    45.891     0.200
     3.126    47.367     0.200
     3.147    47.641     0.200
     3.179    47.594     0.200
     3.364    50.328     0.200
     3.561    52.719     0.200
     3.634    52.953     0.200
     3.649    55.352     0.200
     3.649    54.438     0.200
     3.662    54.352     0.200
     3.677    56.172     0.200
     3.716    55.914     0.200
     3.745    54.336     0.200
     4.019    59.016     0.200
     4.033    59.875     0.200
     4.021    59.016     0.200
     4.054    60.242     0.200
     4.072    60.312     0.200
     4.204    61.938     0.200
     4.242    62.531     0.200
     4.262    62.781     0.200
     4.422    66.602     0.200
     4.422    66.250     0.200
     4.550    67.266     0.200
     4.577    68.438     0.200
     4.577    68.188     0.200
     4.595    68.109     0.200
     4.641    68.836     0.200
     4.672    68.648     0.200
     4.650    69.586     0.200
     4.814    71.312     0.200
     4.878    72.227     0.200
     4.905    72.062     0.200
     4.862    72.055     0.200
     4.969    74.039     0.200
     5.008    75.516     0.200
     5.132    76.391     0.200
     5.230    76.844     0.200
     5.151    74.961     0.200
     5.317    79.211     0.200
     5.281    78.477     0.200
     5.281    78.031     0.200
     5.489    82.086     0.200
     5.527    81.641     0.200
     5.857    87.141     0.200
     5.717    84.719     0.200
     5.787    84.797     0.200
     5.902    86.602     0.200
     5.902    86.062     0.200
     5.970    87.539     0.200
     5.964    89.156     0.200
     6.273    90.688     0.200
     6.273    91.203     0.200
     6.311    91.812     0.200
     6.400    94.031     0.200
     6.442    95.047     0.200
     6.486    95.656     0.200
     6.486    95.266     0.200
     6.523    96.242     0.200
     6.574    97.000     0.200
     6.519    95.961     0.200
     6.711   102.336     0.200
     6.874    99.180     0.200
     7.005   102.141     0.200
     6.985   101.312     0.200
     7.024   102.516     0.200
     7.105   103.258     0.200
     7.130   103.508     0.200
     7.283   107.820     0.200
     7.283   107.164     0.200
     7.383   106.867     0.200
     7.412   107.672     0.200
     7.453   109.359     0.200
     7.521   113.422     0.200
     7.570   111.742     0.200
     7.557   109.062     0.200
     7.598   109.992     0.200
     7.665   112.539     0.200
     7.699   111.922     0.200
     7.708   112.938     0.200
     7.708   112.211     0.200
     7.708   111.812     0.200
     7.771   114.078     0.200
     7.814   115.156     0.200
     7.855   116.391     0.200
     7.854   115.758     0.200
     7.815   112.562     0.200
     7.829   113.039     0.200
     7.913   117.500     0.200
     7.975   117.742     0.200
     7.975   115.680     0.200
     7.940   115.680     0.200
     8.011   116.312     0.200
     8.090   120.195     0.200
     8.137   119.836     0.200
     8.178   118.555     0.200
     8.287   120.242     0.200
     8.274   122.180     0.200
     8.212   117.781     0.200
     8.237   117.984     0.200
     8.324   119.586     0.200
     8.327   119.469     0.200
     8.325   118.977     0.200
     8.400   121.125     0.200
     8.465   125.352     0.200
     8.372   119.781     0.200
     8.498   126.359     0.200
     8.567   126.938     0.200
     8.646   127.289     0.200
     8.609   124.773     0.200
     8.666   126.062     0.200
     8.741   128.938     0.200
     8.820   130.398     0.200
     8.768   125.891     0.200
     8.828   127.742     0.200
     8.885   130.891     0.200
     8.868   128.383     0.200
     8.866   127.812     0.200
     8.873   127.586     0.200
     8.910   128.328     0.200
     8.937   128.828     0.200
     9.051   130.828     0.200
     9.121   134.266     0.200
     9.181   132.531     0.200
     9.305   134.930     0.200
     9.360   135.711     0.200
     9.434   137.836     0.200
     9.359   134.555     0.200
     9.409   136.125     0.200
     9.476   138.656     0.200
     9.477   139.000     0.200
     9.512   139.711     0.200
     9.520   138.141     0.200
     9.447   136.805     0.200
     9.513   138.797     0.200
     9.513   137.492     0.200
     9.483   136.758     0.200
     9.571   137.883     0.200
     9.586   138.656     0.200
     9.615   138.633     0.200
     9.655   139.273     0.200
     9.696   139.641     0.200
     9.740   141.570     0.200
     9.701   139.195     0.200
     9.755   140.492     0.200
     9.748   139.969     0.200
     9.905   145.352     0.200
     9.808   140.992     0.200
     9.884   142.906     0.200
     9.885   142.344     0.200
     9.982   144.016     0.200
     9.930   143.039     0.200
     9.946   144.719     0.200
    10.060   144.719     0.200
    10.005   142.859     0.200
    10.037   144.969     0.200
    10.042   145.312     0.200
    10.068   144.648     0.200
    10.103   144.680     0.200
    10.125   145.594     0.200
    10.199   146.375     0.200
    10.182   145.805     0.200
    10.188   146.016     0.200
    10.249   147.461     0.200
    10.271   147.773     0.200
    10.256   147.844     0.200
    10.339   152.039     0.200
    10.344   148.570     0.200
    10.396   149.602     0.200
    10.447   150.109     0.200
    10.387   148.656     0.200
    10.388   149.438     0.200
    10.444   149.938     0.200
    10.530   151.742     0.200
    10.530   151.891     0.200
    10.584   152.398     0.200
    10.576   153.383     0.200
    10.591   152.211     0.200
    10.650   153.297     0.200
    10.717   153.766     0.200
    10.677   156.336     0.200
    10.677   154.094     0.200
    10.686   153.555     0.200
    10.777   154.219     0.200
    10.806   157.859     0.200
    10.822   157.664     0.200
    10.743   153.789     0.200
    10.842   160.867     0.200
    10.777   157.062     0.200
    10.817   155.258     0.200
    10.818   155.016     0.200
    10.907   156.070     0.200
    10.966   160.852     0.200
    10.923   156.883     0.200
    10.919   157.133     0.200
    11.034   162.836     0.200
    11.034   162.195     0.200
    10.968   157.828     0.200
    10.960   157.953     0.200
    10.978   156.930     0.200
    11.120   161.578     0.200
    11.062   159.055     0.200
    11.198   164.086     0.200
    11.203   160.797     0.200
    11.235   162.039     0.200
    11.235   161.836     0.200
    11.241   160.648     0.200
    11.236   161.859     0.200
    11.285   161.938     0.200
    11.256   162.383     0.200
    11.259   161.477     0.200
    11.264   162.203     0.200
    11.276   161.484     0.200
    11.419   163.508     0.200
    11.359   162.852     0.200
    11.386   163.281     0.200
    11.349   161.859     0.200
    11.361   162.844     0.200
    11.387   163.102     0.200
    11.419   165.344     0.200
    11.436   164.148     0.200
    11.460   164.508     0.200
    11.491   165.000     0.200
    11.547   168.133     0.200
    11.505   164.344     0.200
    11.533   165.641     0.200
    11.651   169.172     0.200
    11.596   166.680     0.200
    11.725   169.180     0.200
    11.685   167.750     0.200
    11.732   168.656     0.200
    11.770   170.055     0.200
    11.768   168.266     0.200
    11.774   169.227     0.200
    11.821   169.828     0.200
    11.788   172.828     0.200
    11.820   171.133     0.200
    11.859   174.422     0.200
    11.844   170.312     0.200
    11.845   170.695     0.200
    11.917   172.727     0.200
    11.871   170.789     0.200
    11.940   169.602     0.200
    11.967   170.406     0.200
    12.022   172.891     0.200
    11.959   171.680     0.200
    11.969   170.633     0.200
    12.099   177.711     0.200
    12.025   171.789     0.200
    12.057   172.477     0.200
    12.025   172.742     0.200
    12.146   176.312     0.200
    12.147   176.078     0.200
    12.079   173.125     0.200
    12.190   179.312     0.200
    12.083   172.312     0.200
    12.138   177.742     0.200
    12.138   174.086     0.200
    12.180   174.750     0.200
    12.253   175.938     0.200
    12.260   175.445     0.200
    12.293   175.789     0.200
    12.293   175.047     0.200
    12.343   175.664     0.200
    12.363   177.500     0.200
    12.411   179.250     0.200
    12.468   183.742     0.200
    12.472   181.133     0.200
    12.472   179.953     0.200
    12.442   180.297     0.200
    12.485   179.008     0.200
    12.503   182.477     0.200
    12.472   178.984     0.200
    12.481   180.000     0.200
    12.558   180.055     0.200
    12.507   179.047     0.200
    12.594   180.953     0.200
    12.649   184.031     0.200
    12.666   183.188     0.200
    12.666   185.039     0.200
    12.576   180.375     0.200
    12.645   181.578     0.200
    12.682   184.117     0.200
    12.612   180.852     0.200
    12.647   181.930     0.200
    12.617   180.875     0.200
    12.627   179.531     0.200
    12.716   184.336     0.200
    12.727   183.406     0.200
    12.682   182.352     0.200
    12.709   183.172     0.200
    12.760   183.070     0.200
    12.746   183.461     0.200
    12.787   185.312     0.200
    12.785   182.125     0.200
    12.743   183.156     0.200
    12.842   183.953     0.200
    12.930   184.008     0.200
    12.941   184.188     0.200
    12.959   185.250     0.200
    12.893   183.422     0.200
    12.917   184.836     0.200
    12.928   185.023     0.200
    12.920   185.625     0.200
    13.002   186.211     0.200
    12.987   185.883     0.200
    13.060   189.945     0.200
    13.156   191.062     0.200
    13.138   189.352     0.200
    13.150   188.297     0.200
    13.152   187.156     0.200
    13.144   187.898     0.200
    13.182   188.766     0.200
    13.187   189.461     0.200
    13.138   188.039     0.200
    13.138   186.922     0.200
    13.160   189.258     0.200
    13.184   187.656     0.200
    13.231   189.031     0.200
    13.198   188.336     0.200
    13.278   189.562     0.200
    13.266   189.562     0.200
    13.226   188.367     0.200
    13.253   189.430     0.200
    13.272   190.633     0.200
    13.323   189.844     0.200
    13.324   190.219     0.200
    13.379   194.742     0.200
    13.294   189.688     0.200
    13.291   190.148     0.200
    13.298   191.039     0.200
    13.298   190.445     0.200
    13.426   194.539     0.200
    13.452   195.609     0.200
    13.477   193.266     0.200
    13.447   191.711     0.200
    13.531   195.680     0.200
    13.503   193.219     0.200
    13.551   192.281     0.200
    13.544   193.383     0.200
    13.544   193.781     0.200
    13.603   196.836     0.200
    13.590   193.312     0.200
    13.576   193.703     0.200
    13.584   194.039     0.200
    13.671   193.539     0.200
    13.680   193.469     0.200
    13.671   195.250     0.200
    13.637   194.078     0.200
    13.733   194.727     0.200
    13.713   194.352     0.200
    13.805   196.719     0.200
    13.751   195.164     0.200
    13.806   197.328     0.200
    13.792   196.477     0.200
    13.867   197.094     0.200
    13.789   196.172     0.200
    13.815   195.664     0.200
    13.834   196.797     0.200
    13.851   196.609     0.200
    13.842   196.883     0.200
    13.877   197.781     0.200
    13.914   199.445     0.200
    13.886   196.836     0.200
    13.962   199.508     0.200
    14.001   202.008     0.200
    13.944   197.281     0.200
    13.981   198.539     0.200
    13.972   198.359     0.200
    14.024   200.391     0.200
    14.057   200.953     0.200
    14.057   199.977     0.200
    14.100   199.711     0.200
    14.037   199.672     0.200
    14.144   201.727     0.200
    14.076   200.422     0.200
    14.102   199.555     0.200
    14.201   201.828     0.200
    14.195   201.398     0.200
    14.234   204.742     0.200
    14.186   202.812     0.200
    14.211   202.977     0.200
    14.182   200.297     0.200
    14.202   202.477     0.200
    14.324   206.258     0.200
    14.317   206.758     0.200
    14.253   203.562     0.200
    14.402   206.539     0.200
    14.402   204.383     0.200
    14.373   203.703     0.200
    14.412   204.055     0.200
    14.410   205.758     0.200
    14.439   206.023     0.200
    14.416   204.891     0.200
    14.485   208.172     0.200
    14.459   204.555     0.200
    14.477   205.422     0.200
    14.514   205.156     0.200
    14.532   208.102     0.200
    14.499   204.867     0.200
    14.543   209.359     0.200
    14.458   204.734     0.200
    14.461   204.516     0.200
    14.464   204.914     0.200
    14.576   209.391     0.200
    14.575   205.641     0.200
    14.518   205.609     0.200
    14.525   205.555     0.200
    14.560   205.305     0.200
    14.643   206.695     0.200
    14.624   206.828     0.200
    14.664   208.227     0.200
    14.657   206.703     0.200
    14.656   207.938     0.200
    14.706   210.445     0.200
    14.690   209.453     0.200
    14.749   207.867     0.200
    14.707   208.344     0.200
    14.692   207.656     0.200
    14.757   208.516     0.200
    14.840   212.516     0.200
    14.827   209.469     0.200
    14.845   210.172     0.200
    14.871   212.586     0.200
    14.845   209.852     0.200
    14.774   210.305     0.200
    14.766   211.508     0.200
    14.812   212.070     0.200
    14.927   211.156     0.200
    14.987   211.734     0.200
    15.007   211.133     0.200
    14.999   210.875     0.200
    15.002   211.242     0.200
    15.011   213.156     0.200
    15.059   213.133     0.200
    15.078   215.172     0.200
    15.036   212.086     0.200
    15.079   212.711     0.200
    15.023   212.141     0.200
    15.018   212.414     0.200
    15.037   212.602     0.200
    15.037   212.125     0.200
    15.141   215.109     0.200
    15.159   213.953     0.200
    15.116   212.828     0.200
    15.115   212.688     0.200
    15.157   213.719     0.200
    15.215   215.273     0.200
    15.214   214.211     0.200
    15.232   216.102     0.200
    15.272   215.047     0.200
    15.303   217.938     0.200
    15.237   215.438     0.200
    15.348   216.633     0.200
    15.272   216.570     0.200
    15.280   216.188     0.200
    15.395   219.438     0.200
    15.403   217.148     0.200
    15.479   219.367     0.200
    15.397   218.062     0.200
    15.517   220.438     0.200
    15.483   218.938     0.200
    15.518   219.570     0.200
    15.524   219.727     0.200
    15.565   221.508     0.200
    15.547   219.281     0.200
    15.548   219.516     0.200
    15.545   219.000     0.200
    15.597   220.391     0.200
    15.560   221.086     0.200
    15.641   221.281     0.200
    15.684   220.852     0.200
    15.679   220.977     0.200
    15.700   221.336     0.200
    15.715   223.914     0.200
    15.754   221.680     0.200
    15.808   222.180     0.200
    15.718   224.062     0.200
    15.797   223.406     0.200
    15.871   225.141     0.200
    15.871   223.242     0.200
    15.898   223.969     0.200
    15.787   225.562     0.200
    15.902   224.609     0.200
    15.938   225.734     0.200
    15.964   225.414     0.200
    15.976   226.398     0.200
    16.014   225.414     0.200
    16.027   225.438     0.200
    16.104   228.992     0.200
    16.104   227.312     0.200
    16.202   229.336     0.200
    16.207   228.094     0.200
    16.227   228.102     0.200
    16.231   229.352     0.200
    16.224   229.164     0.200
    16.292   230.055     0.200
    16.395   229.969     0.200
    16.426   231.445     0.200
    16.463   231.938     0.200
    16.472   231.430     0.200
    16.436   230.789     0.200
    16.436   230.516     0.200
    16.480   232.398     0.200
    16.480   232.055     0.200
    16.513   233.195     0.200
    16.521   231.867     0.200
    16.555   232.672     0.200
    16.576   232.812     0.200
    16.681   235.062     0.200
    16.712   234.047     0.200
    16.801   235.977     0.200
    16.835   236.281     0.200
    16.847   236.094     0.200
    16.764   237.539     0.200
    16.847   235.492     0.200
    16.876   237.297     0.200
    16.867   237.016     0.200
    17.090   238.344     0.200
    17.125   240.008     0.200
    17.127   239.672     0.200
    17.159   240.438     0.200
    17.172   240.461     0.200
    17.268   241.023     0.200
    17.305   242.172     0.200
    17.311   242.797     0.200
    17.396   242.977     0.200
    17.401   243.289     0.200
    17.445   243.773     0.200
    17.461   242.289     0.200
    17.536   244.805     0.200
    17.665   246.312     0.200
    17.751   247.992     0.200
    17.766   248.172     0.200
    17.772   248.398     0.200
    17.947   249.578     0.200
    17.975   249.922     0.200
    17.991   250.680     0.200
    18.039   251.852     0.200
    18.039   251.211     0.200
    18.163   252.742     0.200
    18.235   253.586     0.200
    18.247   253.078     0.200
    18.296   253.289     0.200
    18.306   253.703     0.200
    18.430   256.359     0.200
    19.864   274.695     0.200
     1.017    17.430     0.200
     1.239    21.820     0.200
     1.321    23.727     0.200
     1.435    25.500     0.200
     1.449    26.195     0.200
     1.481    26.180     0.200
     1.537    24.648     0.200
     2.947    47.508     0.200
     3.004    46.891     0.200
     5.263    78.328     0.200
     5.816    85.805     0.200
     5.861    85.898     0.200
     6.275    91.117     0.200
     7.631   113.977     0.200
     8.246   123.648     0.200
     8.378   120.898     0.200
    10.402   149.797     0.200
     1.156    19.520     0.200
     1.261    20.643     0.200
     1.249    22.088     0.200
     1.285    20.682     0.200
     1.286    21.857     0.200
     1.356    23.918     0.200
     1.357    23.967     0.200
     1.622    25.297     0.200
     1.692    27.514     0.200
     1.747    27.176     0.200
     1.767    27.582     0.200
     2.062    31.127     0.200
     2.062    31.576     0.200
     2.075    32.047     0.200
     2.424    36.811     0.200
     2.896    43.977     0.200
     3.021    45.777     0.200
     3.076    45.617     0.200
     3.204    47.908     0.200
     3.695    53.668     0.200
     3.734    56.734     0.200
     3.729    53.537     0.200
     4.451    68.158     0.200
     4.451    67.199     0.200
     4.635    70.158     0.200
     4.690    70.588     0.200
     4.873    72.590     0.200
     4.959    74.137     0.200
     5.298    79.527     0.200
     5.298    79.316     0.200
     5.577    82.568     0.200
     6.261    90.877     0.200
     6.261    91.084     0.200
     6.570   100.568     0.200
     6.979   100.971     0.200
     7.310   108.527     0.200
     7.383   107.078     0.200
     7.814   112.824     0.200
     7.889   118.508     0.200
     9.508   139.357     0.200
    10.359   149.227     0.200
    11.533   165.418     0.200
    13.436   195.938     0.200
     1.229    21.211     0.200
     1.249    22.469     0.200
     1.249    22.520     0.200
     1.275    23.160     0.200
     1.333    23.930     0.200
     1.368    22.305     0.200
     1.375    22.785     0.200
     1.643    26.180     0.200
     2.065    32.645     0.200
     2.132    33.039     0.200
     2.132    32.602     0.200
     3.014    49.980     0.200
     3.065    50.070     0.200
     3.258    50.762     0.200
     4.581    69.602     0.200
     5.423    80.961     0.200
     5.483    82.262     0.200
     6.050    89.992     0.200
     6.354    93.039     0.200
     6.601    99.148     0.200
     6.691   102.051     0.200
     7.440   108.902     0.200
     8.018   119.672     0.200
     8.439   125.656     0.200
    10.421   150.480     0.200
    11.402   168.129     0.200
     1.248    22.498     0.200
     1.229    21.988     0.200
     1.249    22.498     0.200
     1.276    23.178     0.200
     1.375    22.664     0.200
     1.334    23.869     0.200
     1.369    22.188     0.200
     1.643    25.953     0.200
     1.642    27.359     0.200
     1.806    28.441     0.200
     1.867    29.594     0.200
     2.066    32.561     0.200
     2.132    32.932     0.200
     2.132    32.789     0.200
     2.247    35.156     0.200
     2.508    38.535     0.200
     2.786    43.928     0.200
     2.776    42.832     0.200
     3.015    47.828     0.200
     3.066    50.158     0.200
     3.182    48.070     0.200
     3.258    50.998     0.200
     3.688    56.148     0.200
     3.818    58.178     0.200
     4.207    63.729     0.200
     4.279    65.248     0.200
     4.410    66.799     0.200
     4.581    68.559     0.200
     4.715    71.998     0.200
     4.962    74.738     0.200
     5.423    80.189     0.200
     5.692    85.109     0.200
     6.051    89.529     0.200
     6.546    95.979     0.200
     6.691    99.229     0.200
     7.217   105.758     0.200
     7.831   114.029     0.200
     8.439   121.828     0.200
     8.439   125.854     0.200
     9.638   142.018     0.200
    10.421   150.703     0.200
    10.632   152.049     0.200
    11.402   168.750     0.200
     1.237    21.613     0.200
     1.307    21.301     0.200
     1.326    21.734     0.200
     1.609    25.512     0.200
     1.646    27.395     0.200
     2.047    32.133     0.200
     2.114    32.324     0.200
     2.191    34.227     0.200
     2.719    43.113     0.200
     3.048    47.312     0.200
     3.788    56.133     0.200
     3.799    57.738     0.200
     4.141    62.652     0.200
     4.514    68.289     0.200
     4.746    70.805     0.200
     4.940    73.227     0.200
     5.364    80.172     0.200
     5.364    79.652     0.200
     5.928    85.895     0.200
     5.986    87.332     0.200
     6.321    92.543     0.200
     6.619    96.543     0.200
     7.171   104.785     0.200
     7.374   109.289     0.200
     7.374   108.172     0.200
     7.479   109.164     0.200
     7.779   113.465     0.200
     7.780   114.965     0.200
     8.373   123.387     0.200
     8.412   120.770     0.200
    10.409   149.762     0.200
    10.901   155.922     0.200
    11.051   159.703     0.200
    16.803   232.992     0.200
     1.232    22.414     0.200
     1.384    22.539     0.200
     1.387    22.961     0.200
     1.642    27.805     0.200
     1.652    26.539     0.200
     1.652    26.852     0.200
     1.611    26.273     0.200
     1.883    30.164     0.200
     2.070    32.938     0.200
     2.137    33.531     0.200
     2.137    33.289     0.200
     2.245    35.406     0.200
     2.262    35.594     0.200
     2.522    39.703     0.200
     2.552    40.594     0.200
     2.544    40.109     0.200
     2.782    43.562     0.200
     2.802    44.008     0.200
     2.852    44.445     0.200
     2.895    44.906     0.200
     3.019    48.047     0.200
     3.070    48.750     0.200
     3.270    50.312     0.200
     3.692    57.602     0.200
     3.826    56.461     0.200
     3.875    59.000     0.200
     4.188    62.773     0.200
     4.223    63.930     0.200
     4.597    68.812     0.200
     4.597    69.664     0.200
     5.009    74.742     0.200
     5.438    81.492     0.200
     5.500    81.773     0.200
     5.998    88.430     0.200
     6.066    89.312     0.200
     6.362    93.133     0.200
     6.613    98.688     0.200
     6.708   102.148     0.200
     7.074   108.430     0.200
     7.096   106.828     0.200
     7.153   104.328     0.200
     7.455   110.922     0.200
     7.850   115.969     0.200
     7.844   115.539     0.200
     8.032   118.242     0.200
     8.097   122.141     0.200
     8.275   122.328     0.200
     8.455   124.992     0.200
     8.752   130.023     0.200
     9.700   143.562     0.200
     9.696   144.031     0.200
     9.782   145.953     0.200
    10.425   152.094     0.200
    10.853   158.422     0.200
    10.989   161.867     0.200
    11.420   167.188     0.200
    12.680   184.484     0.200
    13.365   193.070     0.200
    15.163   216.000     0.200
    16.834   236.648     0.200
    20.984   285.500     0.200
     1.262    23.633     0.200
     1.386    22.867     0.200
     1.389    22.758     0.200
     1.614    25.906     0.200
     1.646    27.539     0.200
     1.657    26.797     0.200
     1.657    26.500     0.200
     1.824    28.797     0.200
     1.888    29.945     0.200
     2.076    32.953     0.200
     2.133    33.164     0.200
     2.133    33.547     0.200
     2.248    34.898     0.200
     2.261    35.242     0.200
     2.527    38.781     0.200
     2.556    39.594     0.200
     2.788    43.164     0.200
     2.806    44.469     0.200
     2.832    43.133     0.200
     2.857    44.023     0.200
     2.900    44.406     0.200
     2.961    45.383     0.200
     3.025    46.602     0.200
     3.058    45.914     0.200
     3.075    48.477     0.200
     3.223    48.523     0.200
     3.275    49.797     0.200
     3.275    49.195     0.200
     3.443    51.820     0.200
     3.698    55.398     0.200
     3.698    55.742     0.200
     3.711    55.289     0.200
     3.767    55.938     0.200
     3.822    56.797     0.200
     4.026    59.875     0.200
     4.193    62.445     0.200
     4.228    63.180     0.200
     4.283    62.992     0.200
     4.292    64.203     0.200
     4.292    63.453     0.200
     4.383    64.930     0.200
     4.427    65.797     0.200
     4.598    69.398     0.200
     4.586    68.289     0.200
     4.734    71.898     0.200
     4.734    71.281     0.200
     4.751    70.641     0.200
     4.953    75.047     0.200
     4.952    73.883     0.200
     5.014    75.523     0.200
     5.198    76.555     0.200
     5.184    77.328     0.200
     5.350    79.664     0.200
     5.437    81.055     0.200
     5.437    81.219     0.200
     5.504    82.672     0.200
     5.602    84.359     0.200
     5.713    85.398     0.200
     6.003    90.398     0.200
     6.071    89.805     0.200
     6.086    89.883     0.200
     6.360    92.984     0.200
     6.545    97.109     0.200
     6.577    96.289     0.200
     6.619   100.414     0.200
     6.771   101.602     0.200
     7.102   105.297     0.200
     7.227   105.758     0.200
     7.250   105.844     0.200
     7.456   110.789     0.200
     7.536   109.992     0.200
     7.759   116.398     0.200
     7.843   116.203     0.200
     7.843   114.578     0.200
     7.853   116.500     0.200
     7.890   116.297     0.200
     8.033   116.867     0.200
     8.160   122.398     0.200
     8.160   120.430     0.200
     8.278   124.281     0.200
     8.292   125.000     0.200
     8.323   121.727     0.200
     8.443   121.672     0.200
     8.443   121.219     0.200
     8.459   123.602     0.200
     8.552   124.438     0.200
     8.533   126.148     0.200
     8.743   126.945     0.200
     8.755   131.000     0.200
     8.829   131.359     0.200
     8.836   128.930     0.200
     8.836   129.047     0.200
     8.877   133.461     0.200
     8.988   130.750     0.200
     9.219   131.719     0.200
     9.256   134.594     0.200
     9.249   137.656     0.200
     9.249   137.469     0.200
     9.263   134.703     0.200
     9.356   136.109     0.200
     9.366   136.023     0.200
     9.462   136.375     0.200
     9.491   137.414     0.200
     9.549   137.594     0.200
     9.656   141.938     0.200
     9.669   137.562     0.200
     9.698   141.461     0.200
     9.698   143.188     0.200
     9.704   143.203     0.200
     9.714   140.328     0.200
     9.739   141.625     0.200
     9.853   145.258     0.200
     9.786   143.594     0.200
     9.857   142.031     0.200
     9.901   142.734     0.200
     9.924   144.047     0.200
    10.012   144.406     0.200
    10.064   146.438     0.200
    10.155   147.359     0.200
    10.179   147.641     0.200
    10.191   148.000     0.200
    10.234   149.820     0.200
    10.400   151.914     0.200
    10.407   151.484     0.200
    10.420   150.703     0.200
    10.446   152.453     0.200
    10.526   154.258     0.200
    10.577   154.180     0.200
    10.618   154.031     0.200
    10.640   153.953     0.200
    10.747   156.820     0.200
    10.768   154.938     0.200
    10.801   156.969     0.200
    10.833   155.938     0.200
    10.835   158.055     0.200
    10.854   157.977     0.200
    10.911   157.695     0.200
    10.917   157.945     0.200
    10.929   160.797     0.200
    10.956   159.883     0.200
    10.993   159.211     0.200
    11.069   159.758     0.200
    11.074   161.500     0.200
    11.089   162.148     0.200
    11.097   161.258     0.200
    11.110   161.352     0.200
    11.144   163.898     0.200
    11.144   165.094     0.200
    11.170   162.367     0.200
    11.179   160.797     0.200
    11.296   163.078     0.200
    11.296   166.109     0.200
    11.349   164.367     0.200
    11.355   164.680     0.200
    11.380   166.359     0.200
    11.391   166.203     0.200
    11.397   166.062     0.200
    11.401   164.516     0.200
    11.403   166.000     0.200
    11.422   166.430     0.200
    11.423   166.969     0.200
    11.423   167.195     0.200
    11.441   165.617     0.200
    11.469   166.664     0.200
    11.486   165.703     0.200
    11.513   167.352     0.200
    11.544   167.125     0.200
    11.535   168.117     0.200
    11.557   166.852     0.200
    11.559   167.734     0.200
    11.565   166.055     0.200
    11.576   167.297     0.200
    11.653   167.148     0.200
    11.656   168.625     0.200
    11.720   168.508     0.200
    11.843   171.484     0.200
    11.879   171.461     0.200
    11.877   173.672     0.200
    11.942   172.914     0.200
    11.953   174.789     0.200
    11.953   174.797     0.200
    11.953   175.078     0.200
    11.971   172.320     0.200
    11.975   173.164     0.200
    11.977   177.633     0.200
    12.031   174.953     0.200
    12.032   174.156     0.200
    12.040   172.984     0.200
    12.042   172.625     0.200
    12.090   174.367     0.200
    12.109   175.617     0.200
    12.116   174.961     0.200
    12.102   178.148     0.200
    12.137   174.805     0.200
    12.154   176.641     0.200
    12.187   176.391     0.200
    12.207   176.930     0.200
    12.209   178.727     0.200
    12.201   178.211     0.200
    12.255   176.641     0.200
    12.301   178.172     0.200
    12.318   177.750     0.200
    12.399   180.289     0.200
    12.424   180.211     0.200
    12.441   180.617     0.200
    12.444   180.172     0.200
    12.480   180.125     0.200
    12.508   180.531     0.200
    12.516   180.297     0.200
    12.567   181.297     0.200
    12.595   181.398     0.200
    12.599   181.180     0.200
    12.609   181.562     0.200
    12.611   181.266     0.200
    12.641   181.672     0.200
    12.658   183.430     0.200
    12.658   185.359     0.200
    12.673   183.336     0.200
    12.690   182.359     0.200
    12.684   184.570     0.200
    12.709   182.695     0.200
    12.720   183.086     0.200
    12.746   184.422     0.200
    12.777   185.117     0.200
    12.796   184.211     0.200
    12.796   183.680     0.200
    12.801   183.484     0.200
    12.792   186.102     0.200
    12.819   184.781     0.200
    12.805   188.312     0.200
    12.824   185.180     0.200
    12.834   185.844     0.200
    12.871   184.875     0.200
    12.921   187.023     0.200
    12.948   187.086     0.200
    12.945   188.445     0.200
    12.967   185.445     0.200
    12.970   186.711     0.200
    13.009   186.836     0.200
    13.012   188.070     0.200
    13.059   187.852     0.200
    13.048   190.039     0.200
    13.083   187.891     0.200
    13.109   188.406     0.200
    13.117   188.852     0.200
    13.129   188.820     0.200
    13.146   189.688     0.200
    13.166   189.203     0.200
    13.229   189.156     0.200
    13.259   190.148     0.200
    13.280   190.117     0.200
    13.288   191.375     0.200
    13.291   190.617     0.200
    13.295   190.344     0.200
    13.325   192.453     0.200
    13.326   193.172     0.200
    13.350   192.398     0.200
    13.353   191.969     0.200
    13.362   191.602     0.200
    13.363   193.328     0.200
    13.365   192.156     0.200
    13.389   192.547     0.200
    13.402   192.164     0.200
    13.406   192.195     0.200
    13.434   193.055     0.200
    13.445   196.883     0.200
    13.466   193.984     0.200
    13.510   194.547     0.200
    13.511   194.492     0.200
    13.527   197.938     0.200
    13.560   193.484     0.200
    13.603   195.062     0.200
    13.654   196.188     0.200
    13.666   195.375     0.200
    13.664   195.406     0.200
    13.678   195.406     0.200
    13.717   196.969     0.200
    13.717   194.438     0.200
    13.724   196.875     0.200
    13.734   197.422     0.200
    13.739   196.938     0.200
    13.770   197.352     0.200
    13.772   198.422     0.200
    13.823   197.664     0.200
    13.843   197.766     0.200
    13.847   198.766     0.200
    13.865   199.789     0.200
    13.883   199.547     0.200
    13.900   198.672     0.200
    13.910   198.953     0.200
    13.911   199.109     0.200
    13.918   199.555     0.200
    13.921   199.695     0.200
    13.950   199.398     0.200
    13.945   203.438     0.200
    13.963   199.312     0.200
    13.992   200.398     0.200
    14.022   200.414     0.200
    14.054   201.562     0.200
    14.076   201.094     0.200
    14.079   201.250     0.200
    14.080   201.289     0.200
    14.097   201.664     0.200
    14.128   202.242     0.200
    14.150   203.352     0.200
    14.185   202.984     0.200
    14.188   200.289     0.200
    14.207   203.070     0.200
    14.215   203.086     0.200
    14.234   203.609     0.200
    14.245   202.750     0.200
    14.286   203.867     0.200
    14.290   203.148     0.200
    14.302   203.148     0.200
    14.325   204.273     0.200
    14.328   205.406     0.200
    14.329   205.766     0.200
    14.384   205.359     0.200
    14.383   206.148     0.200
    14.428   206.422     0.200
    14.461   205.891     0.200
    14.461   209.672     0.200
    14.504   207.648     0.200
    14.541   207.172     0.200
    14.542   207.000     0.200
    14.542   207.555     0.200
    14.550   206.773     0.200
    14.565   207.617     0.200
    14.579   207.734     0.200
    14.579   208.797     0.200
    14.597   207.695     0.200
    14.603   208.086     0.200
    14.600   208.711     0.200
    14.641   208.492     0.200
    14.644   208.000     0.200
    14.653   208.633     0.200
    14.661   208.023     0.200
    14.678   209.062     0.200
    14.702   209.781     0.200
    14.723   212.109     0.200
    14.769   210.625     0.200
    14.782   210.602     0.200
    14.789   210.562     0.200
    14.799   210.281     0.200
    14.820   210.078     0.200
    14.827   210.109     0.200
    14.827   211.828     0.200
    14.836   210.344     0.200
    14.843   210.102     0.200
    14.856   210.852     0.200
    14.873   211.672     0.200
    14.877   211.352     0.200
    14.938   212.711     0.200
    15.014   213.516     0.200
    15.033   213.367     0.200
    15.032   213.789     0.200
    15.056   212.070     0.200
    15.089   213.844     0.200
    15.115   214.086     0.200
    15.123   213.945     0.200
    15.123   213.383     0.200
    15.143   214.547     0.200
    15.161   214.758     0.200
    15.164   214.578     0.200
    15.177   216.023     0.200
    15.181   215.617     0.200
    15.195   216.406     0.200
    15.216   215.398     0.200
    15.235   216.055     0.200
    15.247   216.180     0.200
    15.246   216.227     0.200
    15.263   216.891     0.200
    15.269   216.547     0.200
    15.314   217.570     0.200
    15.328   217.484     0.200
    15.327   220.000     0.200
    15.342   217.406     0.200
    15.343   217.266     0.200
    15.345   217.516     0.200
    15.361   217.398     0.200
    15.372   217.203     0.200
    15.402   218.391     0.200
    15.446   218.266     0.200
    15.460   219.172     0.200
    15.535   220.031     0.200
    15.591   220.734     0.200
    15.603   219.992     0.200
    15.647   220.266     0.200
    15.665   221.742     0.200
    15.697   220.445     0.200
    15.699   221.211     0.200
    15.700   221.234     0.200
    15.704   221.562     0.200
    15.714   221.055     0.200
    15.717   224.008     0.200
    15.720   221.781     0.200
    15.732   222.102     0.200
    15.761   222.578     0.200
    15.785   222.258     0.200
    15.817   222.727     0.200
    15.852   221.867     0.200
    15.854   221.547     0.200
    15.861   222.375     0.200
    15.867   223.000     0.200
    15.865   223.062     0.200
    15.872   222.922     0.200
    15.883   222.719     0.200
    15.908   223.258     0.200
    15.941   224.109     0.200
    15.951   223.734     0.200
    15.996   225.328     0.200
    16.037   228.758     0.200
    16.037   226.125     0.200
    16.065   225.281     0.200
    16.086   226.328     0.200
    16.090   224.789     0.200
    16.119   227.938     0.200
    16.152   226.836     0.200
    16.162   228.273     0.200
    16.189   227.852     0.200
    16.205   228.742     0.200
    16.289   230.180     0.200
    16.317   229.961     0.200
    16.335   230.586     0.200
    16.394   230.219     0.200
    16.395   230.695     0.200
    16.399   230.000     0.200
    16.394   231.695     0.200
    16.415   231.258     0.200
    16.418   231.547     0.200
    16.458   230.844     0.200
    16.506   231.078     0.200
    16.515   230.453     0.200
    16.560   232.180     0.200
    16.582   234.438     0.200
    16.606   233.938     0.200
    16.630   233.875     0.200
    16.639   233.984     0.200
    16.654   234.180     0.200
    16.697   236.102     0.200
    16.707   235.797     0.200
    16.743   235.961     0.200
    16.764   235.820     0.200
    16.899   238.141     0.200
    16.975   237.297     0.200
    16.984   238.820     0.200
    17.016   238.414     0.200
    17.020   238.727     0.200
    17.030   238.336     0.200
    17.032   238.703     0.200
    17.035   240.633     0.200
    17.049   239.289     0.200
    17.063   238.766     0.200
    17.063   239.031     0.200
    17.063   241.031     0.200
    17.096   239.016     0.200
    17.266   242.859     0.200
    17.276   242.953     0.200
    17.312   243.570     0.200
    17.315   243.203     0.200
    17.347   244.297     0.200
    17.455   245.109     0.200
    17.481   244.602     0.200
    17.492   245.477     0.200
    17.497   245.945     0.200
    17.578   246.578     0.200
    17.585   246.602     0.200
    17.624   246.828     0.200
    17.642   246.570     0.200
    17.647   247.281     0.200
    17.659   246.906     0.200
    17.723   248.273     0.200
    17.852   249.938     0.200
    17.938   250.992     0.200
    17.952   251.047     0.200
    17.954   251.344     0.200
    18.478   258.445     0.200
    18.654   259.914     0.200
    18.682   260.930     0.200
    18.878   262.445     0.200
    18.984   263.547     0.200
    19.008   263.922     0.200
    19.033   264.164     0.200
    19.294   267.195     0.200
    19.361   272.789     0.200
    19.376   268.406     0.200
    19.379   271.289     0.200
    19.440   272.680     0.200
    19.833   277.711     0.200
     3.254    52.227     0.200
     3.299    52.828     0.200
     3.559    55.023     0.200
     4.005    61.141     0.200
     3.924    61.188     0.200
     5.063    76.812     0.200
     5.108    76.305     0.200
     5.559    82.883     0.200
     6.339    92.805     0.200
     6.904   100.648     0.200
     7.911   115.023     0.200
     8.745   126.922     0.200
     8.976   136.516     0.200
    11.671   169.227     0.200
     1.349    23.008     0.200
     1.709    29.016     0.200
     2.041    32.586     0.200
     2.198    35.172     0.200
     2.895    46.609     0.200
     2.936    44.414     0.200
     3.115    48.547     0.200
     3.147    50.305     0.200
     3.197    51.555     0.200
     4.319    65.664     0.200
     4.415    65.953     0.200
     4.516    69.836     0.200
     4.609    70.023     0.200
     4.609    70.469     0.200
     5.212    78.406     0.200
     5.421    80.961     0.200
     5.421    81.664     0.200
     6.286    91.445     0.200
     7.106   103.805     0.200
     7.178   105.062     0.200
     7.224   107.508     0.200
     7.461   110.016     0.200
     7.454   109.023     0.200
     7.723   115.438     0.200
     7.810   113.930     0.200
     7.803   114.281     0.200
     7.803   113.055     0.200
     7.896   116.008     0.200
     7.977   117.805     0.200
     8.022   118.562     0.200
     8.164   122.188     0.200
     8.231   123.305     0.200
     8.338   124.500     0.200
     8.398   123.508     0.200
     8.552   126.508     0.200
     8.814   131.609     0.200
     8.835   129.430     0.200
     8.905   132.766     0.200
     8.941   132.305     0.200
     9.128   136.297     0.200
     9.186   132.336     0.200
     9.429   138.078     0.200
     9.593   140.023     0.200
     9.670   141.555     0.200
     9.732   143.836     0.200
     9.705   142.898     0.200
     9.730   143.000     0.200
     9.851   146.359     0.200
    10.171   150.758     0.200
    10.320   150.305     0.200
    10.320   150.281     0.200
    10.526   155.398     0.200
    10.597   155.703     0.200
    10.582   156.586     0.200
    10.620   153.758     0.200
    10.866   158.508     0.200
    11.059   162.055     0.200
    11.231   165.930     0.200
    11.265   164.109     0.200
    11.384   168.906     0.200
    11.457   168.508     0.200
    11.440   165.633     0.200
    11.445   167.359     0.200
    11.479   165.648     0.200
    11.602   168.203     0.200
    11.683   170.586     0.200
    11.781   171.953     0.200
    11.906   173.523     0.200
    11.977   174.094     0.200
    12.094   175.875     0.200
    12.172   177.305     0.200
    12.292   178.578     0.200
    12.357   179.469     0.200
    12.401   181.969     0.200
    12.442   181.867     0.200
    12.723   184.969     0.200
    12.726   185.844     0.200
    12.763   188.164     0.200
    12.765   187.180     0.200
    13.008   188.773     0.200
    13.158   190.719     0.200
    13.275   192.008     0.200
    13.322   193.383     0.200
    13.417   195.094     0.200
    13.627   197.453     0.200
    13.685   198.109     0.200
    13.707   196.617     0.200
    13.727   198.375     0.200
    13.792   200.906     0.200
    13.867   202.133     0.200
    13.947   199.203     0.200
    14.497   208.438     0.200
    14.584   210.125     0.200
    14.666   212.047     0.200
    14.795   213.086     0.200
    14.793   211.906     0.200
    14.826   213.062     0.200
    14.825   211.930     0.200
    15.104   217.805     0.200
    15.133   216.086     0.200
    15.114   214.156     0.200
    15.204   216.562     0.200
    15.342   220.305     0.200
    15.413   221.406     0.200
    15.632   223.383     0.200
    15.660   224.445     0.200
    15.725   225.273     0.200
    15.780   224.539     0.200
    15.829   226.664     0.200
    16.050   226.414     0.200
    16.136   229.508     0.200
    16.136   228.578     0.200
    16.341   230.508     0.200
    16.361   232.750     0.200
    16.464   233.969     0.200
    16.453   232.406     0.200
    16.512   232.234     0.200
    16.745   236.305     0.200
    17.437   245.359     0.200
    17.585   247.289     0.200
    18.217   253.805     0.200
    18.279   255.203     0.200
     0.932    15.531     0.200
     0.932    15.836     0.200
     0.956    16.289     0.200
     1.231    19.781     0.200
     1.261    22.016     0.200
     1.406    23.469     0.200
     1.455    23.500     0.200
     1.425    23.289     0.200
     1.529    24.531     0.200
     1.672    26.484     0.200
     1.678    27.938     0.200
     1.715    26.633     0.200
     1.715    27.133     0.200
     1.715    27.430     0.200
     1.889    29.414     0.200
     1.953    30.617     0.200
     2.119    33.164     0.200
     2.081    33.422     0.200
     2.123    33.461     0.200
     2.289    35.938     0.200
     2.305    35.758     0.200
     2.584    39.562     0.200
     2.593    39.844     0.200
     2.619    40.016     0.200
     2.761    41.922     0.200
     2.872    45.016     0.200
     2.839    43.398     0.200
     2.856    43.688     0.200
     2.890    44.633     0.200
     2.940    47.055     0.200
     3.117    47.641     0.200
     3.103    48.336     0.200
     3.267    49.680     0.200
     3.497    53.172     0.200
     3.745    56.016     0.200
     3.745    60.445     0.200
     3.907    59.195     0.200
     4.061    61.570     0.200
     4.149    62.625     0.200
     4.293    64.781     0.200
     4.349    65.141     0.200
     4.383    66.703     0.200
     4.641    69.539     0.200
     4.641    70.266     0.200
     4.630    69.109     0.200
     4.800    71.875     0.200
     4.805    71.906     0.200
     4.891    73.742     0.200
     5.035    74.984     0.200
     4.999    75.359     0.200
     5.062    76.031     0.200
     5.183    76.453     0.200
     5.215    78.336     0.200
     5.378    80.461     0.200
     5.468    81.133     0.200
     5.468    81.703     0.200
     5.565    83.172     0.200
     5.775    86.234     0.200
     6.137    90.047     0.200
     6.137    91.125     0.200
     6.359    92.633     0.200
     6.682   101.953     0.200
     6.817   101.289     0.200
     6.821   104.133     0.200
     7.168   104.273     0.200
     7.160   107.633     0.200
     7.241   105.492     0.200
     7.264   106.203     0.200
     7.497   110.758     0.200
     7.517   109.594     0.200
     7.551   110.133     0.200
     7.749   115.906     0.200
     7.816   118.242     0.200
     7.862   114.633     0.200
     7.862   114.531     0.200
     7.862   114.234     0.200
     7.908   116.031     0.200
     8.001   117.914     0.200
     8.045   118.805     0.200
     8.078   119.453     0.200
     8.223   123.930     0.200
     8.348   121.242     0.200
     8.338   123.727     0.200
     8.358   124.531     0.200
     8.435   121.250     0.200
     8.525   125.734     0.200
     8.525   125.234     0.200
     8.581   124.453     0.200
     8.763   127.219     0.200
     8.815   129.531     0.200
     8.874   128.570     0.200
     8.893   131.906     0.200
     8.938   131.672     0.200
     9.020   131.062     0.200
     9.189   136.125     0.200
     9.260   132.586     0.200
     9.283   134.148     0.200
     9.426   138.305     0.200
     9.509   137.680     0.200
     9.572   138.617     0.200
     9.667   140.492     0.200
     9.671   140.359     0.200
     9.700   142.242     0.200
     9.793   143.641     0.200
     9.748   141.391     0.200
     9.749   142.375     0.200
     9.777   141.320     0.200
     9.767   143.133     0.200
     9.847   144.500     0.200
    10.029   144.359     0.200
    10.221   148.305     0.200
    10.195   151.930     0.200
    10.399   150.133     0.200
    10.399   150.156     0.200
    10.439   150.297     0.200
    10.474   155.016     0.200
    10.553   154.430     0.200
    10.649   153.461     0.200
    10.658   153.602     0.200
    10.765   152.969     0.200
    10.833   155.648     0.200
    10.898   157.930     0.200
    11.054   162.016     0.200
    11.190   160.016     0.200
    11.201   165.094     0.200
    11.205   164.430     0.200
    11.205   165.352     0.200
    11.362   167.461     0.200
    11.404   167.633     0.200
    11.470   165.250     0.200
    11.482   166.242     0.200
    11.482   165.086     0.200
    11.482   166.133     0.200
    11.667   166.812     0.200
    11.678   170.391     0.200
    11.776   171.414     0.200
    11.795   171.336     0.200
    11.973   174.227     0.200
    12.018   174.195     0.200
    12.035   175.281     0.200
    12.165   175.562     0.200
    12.336   177.336     0.200
    12.312   180.266     0.200
    12.395   179.859     0.200
    12.392   180.883     0.200
    12.533   178.781     0.200
    12.716   183.555     0.200
    12.720   184.180     0.200
    12.728   185.492     0.200
    12.749   186.492     0.200
    13.002   189.164     0.200
    13.230   189.344     0.200
    13.306   193.461     0.200
    13.351   191.133     0.200
    13.376   191.977     0.200
    13.574   196.523     0.200
    13.673   198.734     0.200
    13.660   198.227     0.200
    13.725   195.484     0.200
    13.776   199.211     0.200
    13.833   199.375     0.200
    14.013   198.133     0.200
    14.460   208.289     0.200
    14.542   208.812     0.200
    14.644   210.180     0.200
    14.731   210.727     0.200
    14.775   212.461     0.200
    14.812   208.734     0.200
    14.776   210.453     0.200
    14.889   211.422     0.200
    15.083   214.195     0.200
    15.121   213.742     0.200
    15.094   215.836     0.200
    15.177   215.016     0.200
    15.265   215.734     0.200
    15.320   218.656     0.200
    15.544   221.852     0.200
    15.588   221.844     0.200
    15.635   223.406     0.200
    15.672   223.664     0.200
    15.672   222.961     0.200
    15.744   223.961     0.200
    15.805   224.016     0.200
    16.054   226.445     0.200
    16.274   230.430     0.200
    16.425   232.594     0.200
    16.495   231.883     0.200
    16.575   232.234     0.200
    16.522   233.633     0.200
    16.657   233.641     0.200
    16.687   229.430     0.200
    16.822   234.734     0.200
    16.870   238.039     0.200
    17.510   244.023     0.200
    17.669   247.320     0.200
    18.284   254.133     0.200
    18.285   254.016     0.200
    19.650   270.633     0.200
     0.530    10.109     0.200
     0.522     9.961     0.200
     0.564    10.695     0.200
     0.624    11.422     0.200
     0.588    11.367     0.200
     0.641    11.891     0.200
     1.230    22.430     0.200
     1.376    22.352     0.200
     1.230    22.328     0.200
     1.449    23.625     0.200
     1.610    26.125     0.200
     1.578    25.867     0.200
     2.017    32.016     0.200
     2.762    42.602     0.200
     2.789    43.445     0.200
     3.639    55.891     0.200
     3.928    59.438     0.200
     4.243    63.539     0.200
     4.642    70.586     0.200
     6.429    93.789     0.200
     7.292   106.805     0.200
     7.905   116.570     0.200
     8.513   123.180     0.200
     0.882    15.234     0.200
     0.882    14.703     0.200
     1.230    20.109     0.200
     1.401    22.820     0.200
     1.378    23.852     0.200
     1.585    25.516     0.200
     1.612    25.688     0.200
     1.763    28.141     0.200
     1.802    29.047     0.200
     2.220    34.398     0.200
     2.394    37.062     0.200
     2.466    37.914     0.200
     2.574    40.133     0.200
     2.587    40.148     0.200
     3.981    60.602     0.200
     4.047    60.516     0.200
     4.652    70.352     0.200
     4.823    71.828     0.200
     5.140    76.727     0.200
     5.446    80.539     0.200
     5.548    82.852     0.200
     7.426   108.133     0.200
     7.997   117.680     0.200
    10.677   152.930     0.200
    11.365   165.000     0.200
    15.865   224.055     0.200
     1.082    18.526     0.200
     1.195    20.036     0.200
     1.408    24.806     0.200
     1.434    24.556     0.200
     1.434    24.706     0.200
     1.512    25.333     0.200
     1.573    26.986     0.200
     1.748    27.406     0.200
     1.993    32.240     0.200
     2.057    32.186     0.200
     2.057    31.959     0.200
     2.211    34.221     0.200
     2.568    40.896     0.200
     2.887    43.506     0.200
     3.205    48.687     0.200
     4.557    68.766     0.200
     4.570    69.696     0.200
     4.693    70.986     0.200
     5.204    77.396     0.200
     5.384    80.386     0.200
     5.442    80.846     0.200
     5.765    85.436     0.200
     5.980    88.986     0.200
     6.247    92.716     0.200
     7.007   107.936     0.200
     7.058   103.516     0.200
     7.120   104.336     0.200
     7.392   108.486     0.200
     7.433   108.696     0.200
     7.476   113.186     0.200
     7.527   111.466     0.200
     7.768   114.986     0.200
     7.768   113.736     0.200
     7.821   117.186     0.200
     7.973   119.256     0.200
     8.043   118.686     0.200
     8.081   119.956     0.200
     8.130   121.696     0.200
     8.139   121.176     0.200
     8.216   117.846     0.200
     8.350   123.856     0.200
     8.432   125.486     0.200
     8.516   126.586     0.200
     8.658   130.186     0.200
     8.790   128.586     0.200
     8.790   127.886     0.200
     8.886   129.656     0.200
     8.851   131.955     0.200
     8.989   133.186     0.200
     9.057   131.996     0.200
     9.112   134.686     0.200
     9.127   135.156     0.200
     9.455   139.206     0.200
     9.455   139.496     0.200
     9.467   134.736     0.200
     9.612   139.666     0.200
     9.739   140.516     0.200
     9.756   142.766     0.200
     9.851   145.556     0.200
     9.987   146.386     0.200
    10.041   146.686     0.200
    10.128   146.686     0.200
    10.128   146.661     0.200
    10.178   148.546     0.200
    10.498   153.096     0.200
    10.799   160.556     0.200
    10.862   159.186     0.200
    10.944   159.186     0.200
    11.249   163.606     0.200
    11.474   167.886     0.200
    11.545   166.196     0.200
    11.537   166.896     0.200
    11.542   170.086     0.200
    11.614   170.086     0.200
    11.649   168.666     0.200
    11.649   168.736     0.200
    11.649   168.736     0.200
    11.730   172.846     0.200
    11.873   171.576     0.200
    11.973   172.976     0.200
    11.989   173.756     0.200
    12.093   175.526     0.200
    12.166   175.146     0.200
    12.323   178.826     0.200
    12.365   178.776     0.200
    12.371   182.176     0.200
    12.593   181.816     0.200
    12.622   185.566     0.200
    12.648   180.936     0.200
    12.713   186.366     0.200
    12.917   187.586     0.200
    12.918   188.136     0.200
    12.981   189.906     0.200
    13.016   190.856     0.200
    13.042   188.046     0.200
    13.119   188.086     0.200
    13.176   191.526     0.200
    13.203   191.446     0.200
    13.537   196.666     0.200
    13.678   197.416     0.200
    13.892   201.286     0.200
    13.871   197.886     0.200
    13.909   199.916     0.200
    13.900   201.116     0.200
    13.975   203.356     0.200
    14.007   201.966     0.200
    14.117   203.836     0.200
    14.444   207.226     0.200
    14.752   211.076     0.200
    14.756   209.996     0.200
    14.845   211.186     0.200
    14.914   210.286     0.200
    14.957   214.246     0.200
    14.923   212.266     0.200
    15.018   215.436     0.200
    15.056   214.336     0.200
    15.098   215.316     0.200
    15.156   215.516     0.200
    15.329   218.676     0.200
    15.571   221.836     0.200
    15.897   226.086     0.200
    15.925   225.116     0.200
    16.061   225.246     0.200
    16.213   229.806     0.200
    16.451   230.946     0.200
    16.560   234.046     0.200
    16.592   232.886     0.200
    18.133   252.686     0.200
    19.755   272.316     0.200
    20.031   274.986     0.200
    20.768   283.596     0.200
     0.871    14.338     0.200
     1.156    20.523     0.200
     1.264    22.313     0.200
     1.342    21.549     0.200
     1.433    23.147     0.200
     1.585    25.208     0.200
     1.998    31.471     0.200
     2.204    33.654     0.200
     2.299    35.271     0.200
     2.567    39.593     0.200
     2.757    42.256     0.200
     3.887    56.373     0.200
     3.905    58.768     0.200
     4.614    69.690     0.200
     4.834    72.427     0.200
     5.047    74.700     0.200
     5.269    76.864     0.200
     5.470    81.386     0.200
     6.422    92.950     0.200
     7.302   106.727     0.200
     7.476   109.744     0.200
     7.888   115.258     0.200
     8.509   121.932     0.200
     8.789   127.147     0.200
     9.538   137.178     0.200
    10.494   150.308     0.200
     1.357    21.582     0.200
     1.482    24.070     0.200
     1.534    26.127     0.200
     1.573    24.931     0.200
     1.573    24.447     0.200
     1.767    27.962     0.200
     1.873    29.133     0.200
     2.718    43.032     0.200
     2.924    45.887     0.200
     2.973    46.497     0.200
     3.211    50.267     0.200
     3.596    55.017     0.200
     3.933    59.067     0.200
     3.952    59.269     0.200
     4.206    64.227     0.200
     4.205    61.667     0.200
     5.095    75.159     0.200
     5.517    81.587     0.200
     6.469    93.975     0.200
     6.469    93.287     0.200
     7.018   102.718     0.200
     7.248   105.977     0.200
     7.326   106.677     0.200
     7.936   116.557     0.200
     8.088   120.667     0.200
    10.535   152.857     0.200
    11.441   167.907     0.200
     0.975    16.000     0.200
     1.392    22.771     0.200
     1.526    24.299     0.200
     1.717    27.182     0.200
     1.750    28.596     0.200
     2.017    31.427     0.200
     2.065    32.095     0.200
     2.162    33.671     0.200
     2.204    34.369     0.200
     2.284    35.087     0.200
     2.348    35.950     0.200
     2.675    40.938     0.200
     2.665    40.755     0.200
     2.936    46.031     0.200
     2.921    44.447     0.200
     2.962    45.339     0.200
     3.162    48.141     0.200
     3.775    57.000     0.200
     3.908    58.819     0.200
     4.134    61.608     0.200
     4.359    66.011     0.200
     4.657    70.149     0.200
     4.827    71.071     0.200
     4.926    73.929     0.200
     5.026    74.279     0.200
     5.127    75.505     0.200
     5.259    78.500     0.200
     5.419    81.031     0.200
     5.466    81.071     0.200
     5.466    81.381     0.200
     5.459    81.131     0.200
     5.617    83.801     0.200
     5.783    86.521     0.200
     5.828    86.701     0.200
     6.206    91.039     0.200
     6.206    91.551     0.200
     6.248    93.551     0.200
     6.317    91.280     0.200
     6.762    99.000     0.200
     6.762    99.000     0.200
     6.854   100.960     0.200
     7.146   104.000     0.200
     7.217   104.681     0.200
     7.222   109.911     0.200
     7.492   108.551     0.200
     7.509   109.956     0.200
     7.509   110.661     0.200
     7.527   109.051     0.200
     7.716   112.221     0.200
     7.771   117.191     0.200
     7.844   114.201     0.200
     7.844   114.101     0.200
     7.858   116.131     0.200
     7.945   116.801     0.200
     8.025   117.201     0.200
     8.070   118.931     0.200
     8.098   118.831     0.200
     8.210   121.730     0.200
     8.385   122.901     0.200
     8.387   119.792     0.200
     8.575   123.848     0.200
     8.592   124.726     0.200
     8.745   126.290     0.200
     8.861   130.500     0.200
     8.882   128.605     0.200
     8.949   130.401     0.200
     8.988   132.531     0.200
     9.107   136.070     0.200
     9.215   132.761     0.200
     9.475   138.571     0.200
     9.490   134.840     0.200
     9.489   136.140     0.200
     9.557   137.458     0.200
     9.623   140.261     0.200
     9.711   142.591     0.200
     9.719   141.611     0.200
     9.778   140.471     0.200
     9.824   140.101     0.200
     9.898   144.761     0.200
    10.215   147.271     0.200
    10.338   149.401     0.200
    10.338   149.351     0.200
    10.554   155.581     0.200
    10.617   153.141     0.200
    10.667   151.791     0.200
    10.914   158.101     0.200
    11.105   162.201     0.200
    11.270   164.021     0.200
    11.426   165.921     0.200
    11.493   165.521     0.200
    11.484   170.031     0.200
    11.526   165.791     0.200
    11.526   165.331     0.200
    11.526   166.301     0.200
    11.640   167.541     0.200
    11.729   170.571     0.200
    11.827   171.651     0.200
    11.846   172.171     0.200
    11.951   173.500     0.200
    12.024   173.011     0.200
    12.217   176.771     0.200
    12.338   177.641     0.200
    12.389   180.611     0.200
    12.447   180.791     0.200
    12.470   182.471     0.200
    12.565   179.151     0.200
    12.769   184.761     0.200
    12.771   184.921     0.200
    12.800   186.631     0.200
    12.808   186.901     0.200
    13.018   188.191     0.200
    13.054   189.621     0.200
    13.190   187.851     0.200
    13.300   190.601     0.200
    13.365   193.750     0.200
    13.450   194.291     0.200
    13.654   196.531     0.200
    13.738   198.471     0.200
    13.773   197.951     0.200
    13.836   199.971     0.200
    13.904   200.541     0.200
    13.984   196.301     0.200
    14.708   210.881     0.200
    14.789   211.750     0.200
    14.842   208.500     0.200
    14.837   211.960     0.200
    14.863   210.541     0.200
    15.078   213.641     0.200
    15.146   216.031     0.200
    15.153   213.891     0.200
    15.168   215.491     0.200
    15.244   214.701     0.200
    15.701   223.081     0.200
    15.816   224.011     0.200
    16.097   225.831     0.200
    16.499   230.801     0.200
    16.499   232.451     0.200
    16.551   231.521     0.200
    16.771   235.701     0.200
    17.033   237.061     0.200
    18.253   252.701     0.200
    20.914   283.901     0.200
     0.895    15.130     0.200
     0.927    15.454     0.200
     1.155    21.159     0.200
     1.220    21.369     0.200
     1.367    22.562     0.200
     1.475    23.776     0.200
     1.730    28.140     0.200
     1.756    27.829     0.200
     1.756    27.451     0.200
     1.756    27.719     0.200
     2.068    31.717     0.200
     2.068    31.909     0.200
     2.254    35.166     0.200
     2.615    39.975     0.200
     2.885    45.569     0.200
     3.120    47.949     0.200
     3.170    49.509     0.200
     3.770    56.559     0.200
     3.793    57.809     0.200
     3.876    58.813     0.200
     4.618    69.468     0.200
     4.618    69.359     0.200
     4.880    73.415     0.200
     4.999    73.810     0.200
     6.096    88.839     0.200
     6.154    90.632     0.200
     6.154    90.929     0.200
     7.472   110.679     0.200
     7.822   112.679     0.200
     8.540   123.979     0.200
    10.347   149.412     0.200
    11.478   169.036     0.200
     0.498    10.914     0.200
     1.101    18.631     0.200
     1.188    19.919     0.200
     1.432    23.341     0.200
     1.556    25.089     0.200
     1.583    26.091     0.200
     1.549    26.884     0.200
     1.550    27.774     0.200
     1.653    26.616     0.200
     1.684    27.257     0.200
     2.183    34.509     0.200
     2.377    37.282     0.200
     2.384    37.531     0.200
     2.484    38.297     0.200
     2.853    45.514     0.200
     3.205    51.254     0.200
     3.815    58.464     0.200
     3.946    60.814     0.200
     4.207    62.234     0.200
     4.378    67.794     0.200
     4.667    70.434     0.200
     5.331    80.064     0.200
     5.530    82.604     0.200
     5.613    84.554     0.200
     5.608    83.074     0.200
     6.196    92.494     0.200
     6.280    93.394     0.200
     6.630   102.884     0.200
     6.631    99.014     0.200
     6.726    98.184     0.200
     7.510   109.454     0.200
     7.538   112.254     0.200
     7.647   114.334     0.200
     7.775   114.684     0.200
     8.067   119.294     0.200
     8.090   118.194     0.200
     8.090   118.074     0.200
     8.159   121.894     0.200
     8.159   119.654     0.200
     8.837   127.094     0.200
     9.666   140.484     0.200
    10.866   156.094     0.200
    11.286   163.794     0.200
     1.131    19.236     0.200
     1.168    19.319     0.200
     1.305    22.642     0.200
     1.315    21.564     0.200
     1.450    25.307     0.200
     1.451    25.356     0.200
     1.535    24.825     0.200
     1.560    24.947     0.200
     1.596    25.692     0.200
     1.709    27.325     0.200
     1.717    27.928     0.200
     2.193    34.293     0.200
     2.418    37.550     0.200
     2.420    37.723     0.200
     2.448    37.552     0.200
     2.506    39.298     0.200
     2.511    39.010     0.200
     2.614    41.256     0.200
     2.666    40.636     0.200
     2.716    40.006     0.200
     3.339    51.966     0.200
     3.945    58.736     0.200
     4.021    61.196     0.200
     4.102    60.896     0.200
     4.474    68.376     0.200
     4.646    69.486     0.200
     5.377    80.526     0.200
     5.561    82.576     0.200
     5.579    82.946     0.200
     6.312    94.424     0.200
     6.627    96.406     0.200
     6.753    99.076     0.200
     7.347   107.236     0.200
     7.434   108.236     0.200
     7.515   111.437     0.200
     7.677   114.356     0.200
     7.739   112.396     0.200
     7.796   114.136     0.200
     8.023   116.751     0.200
     8.023   116.996     0.200
     8.014   120.446     0.200
     8.058   118.746     0.200
     8.242   123.026     0.200
     8.730   125.586     0.200
     9.657   141.756     0.200
     9.809   140.626     0.200
    10.746   154.626     0.200
    10.869   156.956     0.200
    11.324   162.977     0.200
    15.270   216.937     0.200
    15.794   224.626     0.200
    15.905   224.366     0.200
    18.500   257.416     0.200
     1.068    18.047     0.200
     1.139    19.184     0.200
     1.145    20.392     0.200
     1.387    22.755     0.200
     1.535    25.622     0.200
     1.544    25.377     0.200
     1.623    26.116     0.200
     1.594    27.749     0.200
     1.707    27.780     0.200
     1.893    30.963     0.200
     2.160    33.885     0.200
     2.168    34.576     0.200
     2.250    35.207     0.200
     2.351    37.021     0.200
     2.497    38.854     0.200
     2.603    39.810     0.200
     2.805    42.948     0.200
     3.157    50.019     0.200
     3.766    57.289     0.200
     3.909    60.469     0.200
     4.237    63.049     0.200
     4.662    70.738     0.200
     5.303    79.698     0.200
     5.567    82.858     0.200
     5.613    84.118     0.200
     5.717    86.078     0.200
     6.148    90.559     0.200
     6.231    91.828     0.200
     6.581   100.979     0.200
     6.581    96.089     0.200
     6.752    98.528     0.200
     7.533   111.488     0.200
     7.623   112.469     0.200
     7.755   113.078     0.200
     7.831   113.879     0.200
     7.880   115.078     0.200
     8.103   118.759     0.200
     9.664   140.078     0.200
    10.067   146.698     0.200
    10.903   156.684     0.200
    10.973   158.328     0.200
    11.260   162.509     0.200
    12.601   182.559     0.200
    12.653   184.398     0.200
    13.431   195.118     0.200
    14.406   206.499     0.200
    14.707   209.379     0.200
    14.703   208.749     0.200
    14.933   213.789     0.200
    15.179   216.118     0.200
    15.232   217.099     0.200
    15.513   219.549     0.200
    16.569   233.099     0.200
    16.848   236.229     0.200
    18.668   258.309     0.200
     0.592    10.867     0.200
     0.616    11.657     0.200
     0.627    11.817     0.200
     0.671    12.578     0.200
     0.859    14.633     0.200
     0.930    15.599     0.200
     1.164    21.458     0.200
     1.401    23.101     0.200
     1.455    23.538     0.200
     1.671    26.589     0.200
     1.718    27.498     0.200
     1.718    27.175     0.200
     1.683    27.934     0.200
     1.890    29.446     0.200
     1.953    30.463     0.200
     2.114    32.623     0.200
     2.127    33.336     0.200
     2.285    35.527     0.200
     2.581    39.689     0.200
     2.594    39.300     0.200
     2.872    44.928     0.200
     2.843    43.093     0.200
     2.861    43.920     0.200
     2.895    44.585     0.200
     3.077    47.888     0.200
     3.126    46.107     0.200
     3.341    50.447     0.200
     3.500    52.345     0.200
     3.749    55.407     0.200
     3.814    55.628     0.200
     4.293    64.718     0.200
     4.352    64.668     0.200
     4.638    70.268     0.200
     4.801    70.788     0.200
     5.464    81.328     0.200
     6.070    88.808     0.200
     6.137    91.197     0.200
     6.354    91.817     0.200
     7.163   104.598     0.200
     7.546   109.157     0.200
     7.814   115.878     0.200
     7.858   114.522     0.200
     7.858   113.578     0.200
     7.906   115.078     0.200
     8.222   117.647     0.200
     8.430   120.447     0.200
     8.525   124.373     0.200
     8.892   127.758     0.200
     9.425   135.647     0.200
     9.746   141.378     0.200
     9.745   141.277     0.200
    10.395   150.048     0.200
    10.644   153.447     0.200
    11.480   165.548     0.200
    15.544   218.978     0.200
    18.280   252.867     0.200
     1.220    19.898     0.200
     1.378    23.922     0.200
     1.395    22.833     0.200
     1.603    25.487     0.200
     2.456    37.804     0.200
     2.663    41.915     0.200
     2.747    44.275     0.200
     2.797    45.535     0.200
     3.041    46.465     0.200
     4.538    68.096     0.200
     4.642    70.115     0.200
     5.413    81.195     0.200
     5.788    85.705     0.200
     5.900    87.766     0.200
     6.830   103.025     0.200
     7.394   107.915     0.200
    10.676   154.255     0.200
    10.824   158.375     0.200
    11.355   163.855     0.200
     1.043    17.412     0.200
     1.094    18.033     0.200
     1.338    21.561     0.200
     1.367    24.338     0.200
     1.650    26.291     0.200
     1.780    28.135     0.200
     1.935    30.223     0.200
     1.956    30.779     0.200
     2.110    32.898     0.200
     2.123    32.498     0.200
     2.242    35.059     0.200
     2.368    37.201     0.200
     2.402    37.357     0.200
     2.586    39.570     0.200
     2.759    41.924     0.200
     2.789    42.252     0.200
     3.084    46.928     0.200
     3.365    55.379     0.200
     3.659    53.719     0.200
     4.465    67.518     0.200
     4.654    69.898     0.200
     5.425    81.098     0.200
     5.688    84.699     0.200
     5.902    87.619     0.200
     6.204    90.088     0.200
     6.318    93.289     0.200
     7.133   104.078     0.200
     7.400   109.959     0.200
     7.445   107.619     0.200
     7.495   110.488     0.200
     7.773   113.254     0.200
     7.773   113.018     0.200
     7.907   118.018     0.200
     7.982   119.359     0.200
     8.276   124.338     0.200
     8.262   118.988     0.200
     8.353   123.859     0.200
     8.445   124.018     0.200
     8.699   129.668     0.200
     9.718   142.359     0.200
    10.193   146.629     0.200
    10.521   152.518     0.200
    10.762   156.789     0.200
    11.381   165.229     0.200
    11.580   170.828     0.200
    12.897   187.869     0.200
    13.170   187.629     0.200
    15.069   213.199     0.200
    16.466   230.689     0.200
    18.157   251.039     0.200
     0.911    15.705     0.200
     0.911    15.391     0.200
     1.065    18.092     0.200
     1.136    18.820     0.200
     1.136    18.670     0.200
     1.307    23.861     0.200
     1.384    22.520     0.200
     1.533    25.062     0.200
     1.542    24.828     0.200
     1.620    25.980     0.200
     1.597    27.320     0.200
     1.598    27.420     0.200
     1.707    27.416     0.200
     2.157    33.570     0.200
     2.165    33.922     0.200
     2.247    34.748     0.200
     2.247    35.209     0.200
     2.348    36.303     0.200
     2.482    40.861     0.200
     2.496    38.295     0.200
     2.511    40.061     0.200
     2.533    39.191     0.200
     2.604    39.365     0.200
     2.604    39.160     0.200
     2.671    40.941     0.200
     2.802    42.781     0.200
     3.906    58.500     0.200
     4.237    62.400     0.200
     4.660    70.451     0.200
     5.300    79.701     0.200
     5.497    81.771     0.200
     5.564    83.441     0.200
     5.612    84.031     0.200
     5.714    85.830     0.200
     6.753    97.900     0.200
     7.526   109.541     0.200
     7.531   111.490     0.200
     7.620   113.271     0.200
     7.752   114.311     0.200
     7.830   113.631     0.200
     8.102   118.396     0.200
     9.647   140.480     0.200
    10.904   156.621     0.200
    10.972   157.920     0.200
    11.257   163.291     0.200
     1.114    20.027     0.200
     1.252    22.396     0.200
     1.252    22.766     0.200
     1.357    22.057     0.200
     1.416    23.250     0.200
     1.610    25.541     0.200
     2.025    32.283     0.200
     2.179    33.830     0.200
     2.179    33.697     0.200
     2.284    35.703     0.200
     2.361    37.156     0.200
     2.494    38.375     0.200
     2.738    42.367     0.200
     2.781    43.307     0.200
     2.974    47.207     0.200
     3.024    47.736     0.200
     3.049    47.209     0.200
     3.393    51.541     0.200
     3.647    55.877     0.200
     3.864    58.057     0.200
     3.894    59.105     0.200
     4.048    61.061     0.200
     4.201    63.707     0.200
     4.607    69.936     0.200
     5.458    81.777     0.200
     5.488    81.527     0.200
     6.041    89.266     0.200
     6.400    93.426     0.200
     7.182   104.656     0.200
     7.259   106.176     0.200
     7.568   110.016     0.200
     7.750   112.547     0.200
     7.871   113.891     0.200
     7.871   113.377     0.200
     7.848   114.127     0.200
    10.468   151.516     0.200
    11.412   165.998     0.200
     0.906    15.590     0.200
     1.026    17.230     0.200
     1.089    18.223     0.200
     1.338    21.824     0.200
     1.354    22.352     0.200
     1.492    24.266     0.200
     1.521    24.676     0.200
     1.583    25.488     0.200
     1.644    27.434     0.200
     1.644    28.113     0.200
     1.644    27.602     0.200
     1.645    28.941     0.200
     1.720    27.402     0.200
     1.843    29.883     0.200
     2.113    32.867     0.200
     2.141    33.289     0.200
     2.200    34.156     0.200
     2.204    34.383     0.200
     2.314    35.824     0.200
     2.312    36.246     0.200
     2.333    36.250     0.200
     2.414    36.844     0.200
     2.492    41.781     0.200
     2.498    38.047     0.200
     2.631    39.695     0.200
     2.631    40.113     0.200
     2.663    40.582     0.200
     2.755    42.023     0.200
     2.761    41.984     0.200
     2.863    43.660     0.200
     3.114    47.039     0.200
     3.114    51.051     0.200
     3.513    52.691     0.200
     3.657    54.566     0.200
     3.717    55.523     0.200
     3.717    55.414     0.200
     3.864    58.301     0.200
     4.285    65.422     0.200
     4.256    62.621     0.200
     4.644    70.531     0.200
     5.193    78.051     0.200
     5.265    78.801     0.200
     5.461    81.223     0.200
     5.517    82.523     0.200
     5.606    83.762     0.200
     5.670    83.984     0.200
     6.098    89.898     0.200
     6.187    92.121     0.200
     6.531    98.402     0.200
     6.532    99.422     0.200
     6.768    98.145     0.200
     7.515   111.723     0.200
     7.531   109.352     0.200
     7.588   111.633     0.200
     7.723   113.922     0.200
     7.834   113.691     0.200
     7.868   115.051     0.200
     7.887   114.523     0.200
     8.073   120.023     0.200
     8.103   117.824     0.200
     8.103   118.121     0.200
     8.534   124.934     0.200
     8.642   126.543     0.200
     8.886   127.422     0.200
     8.918   130.422     0.200
     9.136   132.824     0.200
     9.408   136.023     0.200
     9.539   138.801     0.200
     9.621   139.734     0.200
     9.662   142.164     0.200
     9.680   139.941     0.200
     9.809   148.492     0.200
    10.361   150.645     0.200
    10.685   154.973     0.200
    10.728   154.895     0.200
    10.742   155.742     0.200
    10.873   157.723     0.200
    10.930   160.723     0.200
    10.931   156.547     0.200
    10.980   158.422     0.200
    11.223   162.371     0.200
    11.223   162.621     0.200
    11.364   166.234     0.200
    11.389   166.992     0.200
    11.456   167.723     0.200
    11.575   169.184     0.200
    11.663   169.633     0.200
    11.840   172.734     0.200
    12.075   176.133     0.200
    12.356   180.723     0.200
    12.373   178.312     0.200
    12.398   180.613     0.200
    12.417   180.645     0.200
    12.560   183.895     0.200
    12.611   184.551     0.200
    12.672   186.223     0.200
    12.916   188.082     0.200
    12.985   189.723     0.200
    13.332   194.645     0.200
    13.387   194.664     0.200
    13.429   193.254     0.200
    13.621   195.645     0.200
    13.769   196.871     0.200
    13.817   198.223     0.200
    13.933   200.461     0.200
    13.943   202.395     0.200
    14.001   203.074     0.200
    14.214   204.992     0.200
    14.322   203.324     0.200
    14.361   206.961     0.200
    14.661   210.504     0.200
    14.795   210.121     0.200
    15.182   216.191     0.200
    15.806   224.395     0.200
    16.850   236.562     0.200
    18.606   258.324     0.200
    18.648   259.812     0.200
    19.621   270.164     0.200
     1.054    18.012     0.200
     1.134    19.023     0.200
     1.134    19.449     0.200
     1.134    19.184     0.200
     1.378    22.660     0.200
     1.536    25.484     0.200
     1.529    24.992     0.200
     1.609    26.223     0.200
     1.603    27.305     0.200
     1.604    28.914     0.200
     1.696    27.559     0.200
     1.888    30.695     0.200
     2.149    33.816     0.200
     2.152    34.109     0.200
     2.241    35.004     0.200
     2.249    35.508     0.200
     2.336    36.789     0.200
     2.374    38.496     0.200
     2.363    38.445     0.200
     2.459    38.016     0.200
     2.485    40.523     0.200
     2.501    39.984     0.200
     2.484    38.402     0.200
     2.536    42.953     0.200
     2.596    39.746     0.200
     2.596    39.594     0.200
     2.658    41.008     0.200
     2.798    43.023     0.200
     2.798    42.688     0.200
     2.799    42.789     0.200
     2.908    44.609     0.200
     3.158    48.328     0.200
     3.158    48.746     0.200
     3.558    53.637     0.200
     3.701    55.477     0.200
     3.763    56.523     0.200
     3.763    56.352     0.200
     3.896    58.965     0.200
     4.227    61.824     0.200
     5.289    79.555     0.200
     5.486    81.926     0.200
     5.558    82.824     0.200
     5.599    83.824     0.200
     5.706    85.035     0.200
     6.141    90.648     0.200
     6.231    91.926     0.200
     6.577    96.926     0.200
     6.742    98.297     0.200
     7.518   111.734     0.200
     7.514   109.484     0.200
     7.608   112.465     0.200
     7.740   114.324     0.200
     7.892   116.023     0.200
     7.914   116.523     0.200
     8.088   116.453     0.200
     8.108   118.324     0.200
     8.089   118.523     0.200
     8.563   124.496     0.200
     9.160   133.465     0.200
     9.437   136.926     0.200
     9.565   138.727     0.200
     9.634   140.703     0.200
     9.930   147.613     0.200
    10.044   144.727     0.200
    10.765   154.355     0.200
    10.768   157.824     0.200
    10.879   158.023     0.200
    10.896   156.699     0.200
    10.964   157.926     0.200
    10.960   158.363     0.200
    11.245   162.594     0.200
    11.245   163.234     0.200
    11.941   170.824     0.200
    12.388   181.004     0.200
    12.389   176.816     0.200
    12.588   180.766     0.200
    13.419   194.195     0.200
    13.597   193.246     0.200
    13.773   197.176     0.200
    13.787   197.227     0.200
    14.304   202.125     0.200
    14.695   208.203     0.200
    14.688   208.023     0.200
    14.921   213.414     0.200
    15.139   215.727     0.200
    15.166   215.695     0.200
    15.272   216.137     0.200
    15.433   218.023     0.200
    15.500   219.094     0.200
    15.503   219.176     0.200
    15.648   221.426     0.200
    15.648   222.250     0.200
    15.828   224.555     0.200
    16.035   225.375     0.200
    16.469   232.137     0.200
    16.834   236.496     0.200
    17.251   241.727     0.200
    18.653   259.305     0.200
    20.150   275.855     0.200
     0.945    15.844     0.200
     0.945    15.664     0.200
     1.244    22.445     0.200
     1.285    22.176     0.200
     1.312    23.504     0.200
     1.399    23.051     0.200
     1.478    23.668     0.200
     1.686    26.676     0.200
     1.742    27.887     0.200
     1.973    31.000     0.200
     2.100    32.594     0.200
     2.100    32.754     0.200
     2.150    34.016     0.200
     2.285    35.590     0.200
     2.318    35.969     0.200
     2.586    39.742     0.200
     3.148    50.086     0.200
     3.365    49.715     0.200
     3.803    57.855     0.200
     3.772    59.836     0.200
     3.906    58.941     0.200
     4.645    70.176     0.200
     5.466    81.273     0.200
     5.581    82.855     0.200
     5.791    86.105     0.200
     6.159    90.766     0.200
     6.344    92.633     0.200
     7.159   104.574     0.200
     7.231   105.336     0.200
     7.499   110.562     0.200
     7.541   109.523     0.200
     7.829   116.562     0.200
     7.855   114.750     0.200
     7.855   114.445     0.200
     8.546   126.473     0.200
    10.378   150.223     0.200
    11.495   166.273     0.200
    19.659   272.086     0.200
     0.962    16.037     0.200
     1.242    21.777     0.200
     1.274    22.757     0.200
     1.372    22.910     0.200
     1.347    23.837     0.200
     1.522    24.344     0.200
     1.704    26.947     0.200
     1.764    29.491     0.200
     1.802    28.247     0.200
     2.047    31.929     0.200
     2.213    35.019     0.200
     2.264    35.213     0.200
     2.661    40.748     0.200
     3.163    51.767     0.200
     3.419    53.567     0.200
     4.870    73.217     0.200
     5.447    81.657     0.200
     5.884    87.187     0.200
     6.199    91.307     0.200
     8.368   120.667     0.200
     8.585   127.172     0.200
     9.701   142.407     0.200
    10.321   149.472     0.200
    10.896   158.867     0.200
    11.513   166.447     0.200
    12.024   172.237     0.200
    13.826   198.427     0.200
    14.779   210.237     0.200
    18.637   260.147     0.200
     1.017    16.729     0.200
     1.017    16.547     0.200
     1.337    21.558     0.200
     1.330    23.817     0.200
     1.343    23.177     0.200
     1.343    23.427     0.200
     1.412    24.857     0.200
     1.461    25.127     0.200
     1.618    25.589     0.200
     1.756    27.499     0.200
     1.954    30.199     0.200
     1.880    30.275     0.200
     1.921    29.603     0.200
     1.921    29.841     0.200
     2.076    32.425     0.200
     2.093    32.142     0.200
     2.239    34.672     0.200
     2.334    36.345     0.200
     2.576    39.124     0.200
     2.732    41.417     0.200
     2.757    41.649     0.200
     3.011    46.157     0.200
     3.284    52.107     0.200
     3.332    51.417     0.200
     3.674    53.527     0.200
     3.869    58.295     0.200
     3.956    60.967     0.200
     4.435    66.848     0.200
     4.556    68.768     0.200
     4.643    69.715     0.200
     4.643    69.837     0.200
     4.942    73.626     0.200
     4.972    73.738     0.200
     5.012    73.675     0.200
     4.968    73.562     0.200
     4.968    73.797     0.200
     5.422    80.518     0.200
     5.663    83.808     0.200
     5.999    92.257     0.200
     6.218    90.186     0.200
     6.218    89.748     0.200
     6.247    92.288     0.200
     6.288    91.987     0.200
     6.851   100.137     0.200
     6.872   100.103     0.200
     7.140   104.087     0.200
     7.486   110.578     0.200
     7.777   112.853     0.200
     7.886   113.598     0.200
     7.964   118.167     0.200
     8.022   117.377     0.200
     8.252   126.038     0.200
     8.279   118.625     0.200
     8.422   122.257     0.200
     8.669   125.228     0.200
     9.706   141.987     0.200
     9.879   144.157     0.200
    10.217   147.527     0.200
    10.531   151.927     0.200
    10.898   158.748     0.200
    11.351   163.438     0.200
    11.559   166.777     0.200
    11.873   173.328     0.200
    11.998   174.407     0.200
    18.167   250.357     0.200
     1.301    23.386     0.200
     1.361    22.259     0.200
     1.409    23.240     0.200
     1.618    25.961     0.200
     1.618    25.819     0.200
     2.034    32.281     0.200
     3.656    55.796     0.200
     3.888    58.722     0.200
     4.204    63.776     0.200
     4.252    62.276     0.200
     4.604    69.606     0.200
     5.490    81.526     0.200
     5.698    84.316     0.200
     5.971    87.146     0.200
     6.391    93.656     0.200
     7.063   104.096     0.200
     7.252   105.726     0.200
     7.464   110.376     0.200
     7.847   113.856     0.200
     7.864   114.386     0.200
    10.459   151.261     0.200
    15.456   219.336     0.200
     1.089    18.492     0.200
     1.175    19.654     0.200
     1.175    20.853     0.200
     1.182    21.539     0.200
     1.268    20.689     0.200
     1.419    23.322     0.200
     1.549    25.155     0.200
     1.562    26.989     0.200
     1.563    27.619     0.200
     1.571    25.714     0.200
     1.642    26.633     0.200
     1.687    27.351     0.200
     1.929    31.352     0.200
     2.175    34.357     0.200
     2.187    33.970     0.200
     2.286    36.037     0.200
     2.367    37.033     0.200
     2.376    37.558     0.200
     2.483    38.245     0.200
     2.536    40.669     0.200
     2.574    39.464     0.200
     2.521    41.079     0.200
     2.571    40.729     0.200
     2.667    40.910     0.200
     2.839    43.770     0.200
     3.194    48.969     0.200
     3.802    56.999     0.200
     3.934    59.749     0.200
     4.212    62.299     0.200
     4.662    69.879     0.200
     5.321    79.819     0.200
     5.606    83.949     0.200
     5.599    83.549     0.200
     6.183    90.555     0.200
     6.268    92.520     0.200
     6.566    97.560     0.200
     6.618    96.319     0.200
     7.420   108.389     0.200
     7.511   109.289     0.200
     7.533   110.339     0.200
     7.637   113.899     0.200
     7.766   114.289     0.200
     7.954   116.520     0.200
     8.061   118.779     0.200
     8.090   118.204     0.200
     8.090   118.339     0.200
     8.147   118.854     0.200
     9.658   137.449     0.200
    10.801   155.099     0.200
    10.873   156.404     0.200
    10.955   157.589     0.200
    11.276   163.529     0.200
    12.414   176.679     0.200
    12.424   179.999     0.200
    13.455   194.879     0.200
    14.431   206.139     0.200
    14.959   212.819     0.200
    15.858   224.879     0.200
    18.583   258.079     0.200
     1.046    17.910     0.200
     1.116    18.914     0.200
     1.326    22.242     0.200
     1.363    22.586     0.200
     1.517    25.191     0.200
     1.529    25.035     0.200
     1.601    26.184     0.200
     1.618    27.785     0.200
     1.619    29.383     0.200
     1.709    27.695     0.200
     1.870    30.660     0.200
     2.137    33.672     0.200
     2.152    34.109     0.200
     2.226    34.859     0.200
     2.230    35.422     0.200
     2.331    36.707     0.200
     2.347    37.996     0.200
     2.442    38.277     0.200
     2.493    38.555     0.200
     2.613    39.887     0.200
     2.613    39.645     0.200
     2.664    41.266     0.200
     2.782    42.809     0.200
     2.782    42.543     0.200
     2.786    42.836     0.200
     2.890    44.332     0.200
     3.139    49.363     0.200
     3.886    59.113     0.200
     4.242    62.035     0.200
     4.650    70.543     0.200
     5.282    79.215     0.200
     5.479    81.715     0.200
     5.543    82.582     0.200
     5.605    84.125     0.200
     5.694    84.332     0.200
     6.125    89.703     0.200
     8.044   117.953     0.200
     8.096   117.762     0.200
     8.099   118.387     0.200
     8.099   118.262     0.200
     9.633   138.172     0.200
    10.880   156.254     0.200
    10.913   156.512     0.200
    10.972   157.941     0.200
    11.240   162.715     0.200
    15.128   215.012     0.200
    15.208   215.645     0.200
    18.599   259.012     0.200
     0.940    15.871     0.200
     1.224    22.266     0.200
     1.249    21.875     0.200
     1.420    23.691     0.200
     1.455    23.785     0.200
     1.679    26.660     0.200
     1.666    27.656     0.200
     1.708    27.305     0.200
     1.708    27.414     0.200
     1.708    26.984     0.200
     1.955    30.922     0.200
     2.133    33.395     0.200
     2.133    32.758     0.200
     2.114    33.680     0.200
     2.302    35.824     0.200
     2.313    35.875     0.200
     2.596    40.262     0.200
     2.623    40.465     0.200
     2.843    43.723     0.200
     2.874    45.258     0.200
     2.878    44.707     0.200
     3.063    49.875     0.200
     3.124    47.609     0.200
     3.111    49.105     0.200
     3.735    58.066     0.200
     3.834    57.168     0.200
     4.295    64.465     0.200
     4.341    65.316     0.200
     4.485    68.734     0.200
     4.652    70.086     0.200
     5.481    81.695     0.200
     5.571    82.887     0.200
     5.780    85.957     0.200
     6.138    90.445     0.200
     6.373    92.625     0.200
     7.182   104.695     0.200
     7.255   105.957     0.200
     7.509   111.035     0.200
     7.876   114.207     0.200
     7.876   114.945     0.200
     7.916   114.965     0.200
     8.089   119.578     0.200
     8.527   123.305     0.200
    10.413   150.625     0.200
    10.909   157.746     0.200
    11.488   165.672     0.200
     1.012    16.977     0.200
     1.012    16.742     0.200
     1.073    17.691     0.200
     1.317    21.742     0.200
     1.367    23.043     0.200
     1.367    24.359     0.200
     1.353    24.191     0.200
     1.406    23.621     0.200
     1.435    25.070     0.200
     1.622    25.922     0.200
     1.750    27.871     0.200
     1.930    30.273     0.200
     1.930    29.910     0.200
     1.901    31.109     0.200
     1.935    30.383     0.200
     2.093    32.234     0.200
     2.219    34.625     0.200
     2.372    36.715     0.200
     2.352    36.879     0.200
     2.560    39.277     0.200
     2.728    41.828     0.200
     2.761    42.238     0.200
     3.191    49.207     0.200
     3.351    54.172     0.200
     4.627    69.793     0.200
     4.695    71.430     0.200
     5.403    80.473     0.200
     5.657    83.852     0.200
     6.195    89.703     0.200
     6.289    92.602     0.200
     6.881   102.406     0.200
     7.117   104.242     0.200
     7.470   109.340     0.200
     7.755   114.055     0.200
     8.669   125.406     0.200
    10.193   147.945     0.200
    11.550   167.320     0.200
     1.073    18.328     0.200
     1.176    19.758     0.200
     1.181    21.430     0.200
     1.192    21.242     0.200
     1.197    21.781     0.200
     1.205    21.336     0.200
     1.268    21.758     0.200
     1.410    23.211     0.200
     1.527    24.930     0.200
     1.580    25.984     0.200
     1.624    26.328     0.200
     1.664    27.047     0.200
     1.929    31.227     0.200
     2.175    34.125     0.200
     2.275    35.438     0.200
     2.292    36.023     0.200
     2.348    36.750     0.200
     2.391    37.977     0.200
     2.460    37.648     0.200
     2.529    41.414     0.200
     2.556    39.227     0.200
     2.556    39.445     0.200
     3.202    49.047     0.200
     3.805    56.820     0.200
     3.920    60.195     0.200
     3.973    60.398     0.200
     4.192    61.164     0.200
     4.638    69.297     0.200
     5.302    80.445     0.200
     5.501    81.758     0.200
     5.582    83.305     0.200
     5.592    83.086     0.200
     5.733    86.156     0.200
     6.179    91.633     0.200
     6.547    96.695     0.200
     6.616    96.875     0.200
     6.708    97.750     0.200
     8.066   117.133     0.200
     8.066   117.898     0.200
    10.856   155.883     0.200
    11.257   161.656     0.200
    15.678   221.086     0.200
    15.678   219.531     0.200
     1.071    18.582     0.200
     1.081    18.022     0.200
     1.081    18.292     0.200
     1.152    19.664     0.200
     1.360    24.521     0.200
     1.411    24.432     0.200
     1.411    24.962     0.200
     1.411    24.852     0.200
     1.475    25.055     0.200
     1.449    25.911     0.200
     1.542    26.132     0.200
     1.702    27.872     0.200
     1.816    29.269     0.200
     1.961    31.911     0.200
     2.014    31.925     0.200
     2.014    32.352     0.200
     1.900    30.021     0.200
     2.435    37.818     0.200
     2.841    44.255     0.200
     3.087    49.161     0.200
     3.173    48.940     0.200
     3.421    53.411     0.200
     3.629    56.222     0.200
     4.046    63.151     0.200
     4.512    68.661     0.200
     4.667    71.191     0.200
     4.607    69.231     0.200
     4.607    65.271     0.200
     5.425    81.422     0.200
     5.724    86.542     0.200
     6.334    94.271     0.200
     6.175    91.142     0.200
     6.367    95.372     0.200
     6.906   104.741     0.200
     6.962   104.325     0.200
     7.504   112.552     0.200
     7.761   114.392     0.200
     7.761   115.082     0.200
     8.009   120.422     0.200
     8.052   120.012     0.200
     8.113   121.892     0.200
     8.311   124.472     0.200
     8.478   126.052     0.200
     9.573   141.472     0.200
     9.820   142.812     0.200
    10.149   148.116     0.200
    10.754   155.771     0.200
    10.816   157.502     0.200
    10.919   157.741     0.200
    11.571   169.132     0.200
    11.612   169.271     0.200
    12.939   188.521     0.200
    13.871   197.842     0.200
    15.851   225.281     0.200
    18.134   253.342     0.200
     0.965    16.762     0.200
     0.965    16.635     0.200
     1.029    17.725     0.200
     1.029    17.586     0.200
     1.304    21.729     0.200
     1.416    23.416     0.200
     1.414    24.115     0.200
     1.557    25.154     0.200
     1.587    25.652     0.200
     1.685    28.695     0.200
     1.686    29.545     0.200
     1.783    28.713     0.200
     1.794    28.850     0.200
     2.132    33.514     0.200
     2.160    33.705     0.200
     2.171    34.279     0.200
     2.253    35.547     0.200
     2.365    39.305     0.200
     2.564    39.510     0.200
     2.707    41.361     0.200
     2.707    41.885     0.200
     2.718    41.543     0.200
     2.712    41.645     0.200
     3.651    55.166     0.200
     3.838    57.846     0.200
     3.848    58.846     0.200
     4.253    64.445     0.200
     4.334    63.125     0.200
     4.688    70.814     0.200
     5.269    79.906     0.200
     5.476    82.326     0.200
     5.662    84.996     0.200
     6.049    89.539     0.200
     6.468    96.445     0.200
     6.474    97.406     0.200
     6.524    99.055     0.200
     6.844    99.795     0.200
     7.504   109.855     0.200
     7.558   112.635     0.200
     7.599   110.885     0.200
     7.742   114.836     0.200
     7.871   114.666     0.200
     7.884   114.314     0.200
     8.051   117.100     0.200
     8.072   119.086     0.200
     8.167   119.150     0.200
     8.167   119.576     0.200
     8.964   131.375     0.200
     8.964   129.295     0.200
     9.401   137.666     0.200
     9.647   140.406     0.200
     9.698   141.596     0.200
     9.880   143.246     0.200
    10.416   153.545     0.200
    10.910   159.516     0.200
    11.012   158.826     0.200
    11.051   160.195     0.200
    11.231   162.529     0.200
    11.663   168.395     0.200
    14.344   204.486     0.200
    14.644   206.855     0.200
    14.866   211.506     0.200
    15.162   214.865     0.200
    15.580   221.375     0.200
    15.580   218.736     0.200
    18.676   259.875     0.200
     0.448     9.123     0.200
     0.715    13.922     0.200
     1.073    17.838     0.200
     1.367    22.363     0.200
     1.316    23.012     0.200
     1.357    23.402     0.200
     1.424    23.623     0.200
     1.402    24.242     0.200
     1.675    26.627     0.200
     1.811    28.629     0.200
     1.950    30.098     0.200
     1.908    30.975     0.200
     1.969    30.787     0.200
     2.130    32.621     0.200
     2.150    33.443     0.200
     2.272    35.523     0.200
     2.374    36.902     0.200
     2.434    37.457     0.200
     2.617    40.033     0.200
     2.788    42.521     0.200
     2.814    42.836     0.200
     3.093    47.266     0.200
     3.120    47.271     0.200
     3.253    49.135     0.200
     3.492    52.275     0.200
     3.584    55.232     0.200
     3.678    53.582     0.200
     4.493    67.402     0.200
     4.685    70.682     0.200
     5.455    81.393     0.200
     5.933    87.822     0.200
     6.223    90.012     0.200
     6.303    91.861     0.200
     6.345    92.963     0.200
     6.905   103.303     0.200
     6.926   101.479     0.200
     7.093   103.803     0.200
     7.158   104.072     0.200
     7.526   110.781     0.200
     7.939   117.201     0.200
     8.014   118.252     0.200
     8.130   119.752     0.200
     8.384   121.512     0.200
     8.476   124.492     0.200
     8.726   126.361     0.200
     9.084   133.062     0.200
     9.570   140.473     0.200
     9.831   144.082     0.200
    10.203   147.062     0.200
    11.612   166.562     0.200
    12.625   181.322     0.200
    12.927   187.672     0.200
    14.904   211.723     0.200
    16.316   229.688     0.200
     1.077    19.805     0.200
     1.225    19.672     0.200
     1.293    17.625     0.200
     1.687    27.297     0.200
     1.706    27.383     0.200
     1.736    28.367     0.200
     1.742    28.625     0.200
     1.757    28.695     0.200
     2.071    33.211     0.200
     3.829    57.562     0.200
     4.339    65.047     0.200
     4.645    69.984     0.200
     4.795    71.203     0.200
     5.215    78.617     0.200
     5.474    81.836     0.200
     6.368    93.156     0.200
     7.526   109.961     0.200
     7.752   117.828     0.200
     7.870   115.258     0.200
     8.004   119.305     0.200
     8.048   119.602     0.200
     8.673   124.555     0.200
     8.879   130.086     0.200
     9.704   142.375     0.200
    14.021   197.008     0.200
    16.268   225.883     0.200
     0.626    12.410     0.200
     0.804    13.460     0.200
     0.854    14.438     0.200
     0.891    15.180     0.200
     0.952    15.910     0.200
     1.014    17.190     0.200
     1.175    20.680     0.200
     1.179    19.844     0.200
     1.227    19.270     0.200
     1.246    22.320     0.200
     1.265    22.760     0.200
     1.312    23.190     0.200
     1.397    22.753     0.200
     1.449    23.072     0.200
     1.485    24.420     0.200
     1.607    26.500     0.200
     1.633    26.890     0.200
     1.664    26.236     0.200
     1.682    27.403     0.200
     1.682    27.600     0.200
     1.697    27.070     0.200
     1.714    27.170     0.200
     1.714    26.962     0.200
     1.745    28.050     0.200
     1.753    28.100     0.200
     1.766    28.410     0.200
     1.824    29.090     0.200
     1.947    30.105     0.200
     2.113    32.487     0.200
     2.113    32.220     0.200
     2.125    32.950     0.200
     2.280    35.341     0.200
     2.575    39.328     0.200
     2.588    39.092     0.200
     2.861    42.965     0.200
     2.894    43.936     0.200
     3.074    45.850     0.200
     3.109    47.857     0.200
     3.123    47.480     0.200
     3.263    48.542     0.200
     3.336    50.990     0.200
     3.397    55.100     0.200
     3.747    54.970     0.200
     3.812    56.200     0.200
     3.898    58.522     0.200
     4.260    62.840     0.200
     4.449    65.930     0.200
     5.207    78.190     0.200
     5.460    81.320     0.200
     6.131    89.460     0.200
     6.352    91.630     0.200
     6.679   102.590     0.200
     7.488   110.670     0.200
     7.509   109.130     0.200
     7.854   114.445     0.200
     7.993   118.780     0.200
     8.036   120.120     0.200
     8.865   129.940     0.200
     9.692   142.110     0.200
    10.394   150.170     0.200
    10.394   150.170     0.200
    10.889   159.040     0.200
    12.753   182.050     0.200
     1.025    17.414     0.200
     1.031    17.499     0.200
     1.116    18.734     0.200
     1.228    22.369     0.200
     1.226    22.429     0.200
     1.223    22.079     0.200
     1.352    22.190     0.200
     1.329    24.199     0.200
     1.503    24.261     0.200
     1.526    24.994     0.200
     1.580    25.765     0.200
     1.629    27.809     0.200
     1.630    28.699     0.200
     1.684    27.083     0.200
     1.869    30.375     0.200
     2.121    33.122     0.200
     2.125    33.259     0.200
     2.216    34.484     0.200
     2.236    34.997     0.200
     2.472    39.349     0.200
     2.474    40.399     0.200
     2.467    37.670     0.200
     2.527    41.869     0.200
     2.594    39.267     0.200
     2.637    40.257     0.200
     2.775    42.439     0.200
     3.148    49.669     0.200
     3.746    56.019     0.200
     3.913    58.469     0.200
     4.220    61.709     0.200
     4.622    69.539     0.200
     5.260    79.069     0.200
     5.457    81.429     0.200
     5.533    82.669     0.200
     5.578    82.489     0.200
     5.678    83.499     0.200
     6.118    89.209     0.200
     6.507    97.189     0.200
     6.555    98.869     0.200
     6.560    97.089     0.200
     6.732    97.819     0.200
     7.406   108.079     0.200
     7.493   110.229     0.200
     7.499   109.069     0.200
     7.712   113.159     0.200
     7.845   117.529     0.200
     7.863   113.999     0.200
     7.885   114.419     0.200
     7.907   116.549     0.200
     8.017   117.979     0.200
     8.072   117.739     0.200
     8.535   123.029     0.200
     9.131   133.499     0.200
     9.408   136.239     0.200
     9.536   138.859     0.200
     9.607   139.059     0.200
    10.853   157.879     0.200
    10.894   155.659     0.200
    10.936   160.099     0.200
    10.946   157.779     0.200
    11.217   160.609     0.200
    11.925   173.509     0.200
    12.359   181.569     0.200
    14.289   201.279     0.200
    14.365   206.639     0.200
    14.660   207.809     0.200
    14.667   208.079     0.200
    15.111   214.789     0.200
    15.622   221.499     0.200
    15.799   222.889     0.200
     1.089    18.449     0.200
     1.173    19.562     0.200
     1.173    19.355     0.200
     1.172    20.684     0.200
     1.270    21.496     0.200
     1.417    23.230     0.200
     1.550    25.098     0.200
     1.569    25.727     0.200
     1.564    26.879     0.200
     1.641    26.570     0.200
     1.689    27.289     0.200
     1.927    31.059     0.200
     2.176    34.156     0.200
     2.186    34.148     0.200
     2.281    35.422     0.200
     2.284    36.051     0.200
     2.367    37.137     0.200
     2.373    37.254     0.200
     2.380    37.344     0.200
     2.485    38.270     0.200
     2.518    41.316     0.200
     2.568    39.816     0.200
     2.576    39.148     0.200
     2.576    38.969     0.200
     2.838    43.137     0.200
     3.191    51.156     0.200
     3.740    55.871     0.200
     3.800    57.008     0.200
     3.933    59.719     0.200
     3.974    58.738     0.200
     4.039    60.648     0.200
     4.214    61.027     0.200
     4.663    70.047     0.200
     5.321    79.816     0.200
     5.518    82.105     0.200
     5.607    83.617     0.200
     5.744    84.777     0.200
     6.181    91.453     0.200
     6.566   100.098     0.200
     6.615    99.379     0.200
     6.732    97.836     0.200
     7.422   107.617     0.200
     7.513   109.176     0.200
     7.533   111.098     0.200
     7.637   114.117     0.200
     7.766   114.328     0.200
     7.955   116.758     0.200
     8.092   118.129     0.200
     8.092   118.016     0.200
     9.643   139.438     0.200
     9.659   140.367     0.200
    10.876   156.102     0.200
    10.957   159.879     0.200
     0.947    16.359     0.200
     1.009    17.551     0.200
     1.222    19.539     0.200
     1.328    21.500     0.200
     1.311    23.371     0.200
     1.398    23.574     0.200
     1.445    23.551     0.200
     1.481    25.430     0.200
     1.541    24.781     0.200
     1.555    24.801     0.200
     1.603    26.859     0.200
     1.661    26.723     0.200
     1.678    28.375     0.200
     1.678    28.449     0.200
     1.692    27.379     0.200
     1.709    27.102     0.200
     1.741    28.078     0.200
     1.749    28.602     0.200
     1.762    28.648     0.200
     1.820    29.320     0.200
     1.880    29.770     0.200
     1.880    30.031     0.200
     1.943    30.789     0.200
     1.993    31.469     0.200
     2.031    32.480     0.200
     2.039    32.449     0.200
     2.120    33.738     0.200
     2.115    32.887     0.200
     2.115    32.328     0.200
     2.280    35.953     0.200
     2.294    35.984     0.200
     2.419    37.988     0.200
     2.461    38.902     0.200
     2.461    39.359     0.200
     2.496    39.398     0.200
     2.574    40.387     0.200
     2.584    40.094     0.200
     2.608    40.609     0.200
     2.753    42.402     0.200
     2.835    43.953     0.200
     2.836    44.641     0.200
     2.861    45.191     0.200
     2.858    44.137     0.200
     2.890    44.430     0.200
     2.938    45.145     0.200
     2.985    48.512     0.200
     3.001    45.840     0.200
     3.015    46.273     0.200
     3.070    47.102     0.200
     3.106    47.332     0.200
     3.119    48.059     0.200
     3.258    49.422     0.200
     3.266    49.738     0.200
     3.290    50.828     0.200
     3.331    50.199     0.200
     3.331    50.633     0.200
     3.492    53.441     0.200
     3.742    56.656     0.200
     3.742    57.191     0.200
     3.768    56.164     0.200
     3.820    57.316     0.200
     3.814    56.199     0.200
     3.844    58.820     0.200
     3.898    59.547     0.200
     4.060    61.230     0.200
     4.145    62.363     0.200
     4.214    66.859     0.200
     4.248    63.480     0.200
     4.283    64.551     0.200
     4.322    64.152     0.200
     4.343    64.602     0.200
     4.440    66.180     0.200
     4.482    66.898     0.200
     4.631    70.145     0.200
     4.631    70.539     0.200
     4.791    72.102     0.200
     4.800    70.996     0.200
     4.880    73.426     0.200
     4.909    74.551     0.200
     4.996    73.883     0.200
     5.026    75.176     0.200
     5.051    76.672     0.200
     5.070    75.691     0.200
     5.180    76.527     0.200
     5.204    78.602     0.200
     5.235    78.031     0.200
     5.366    80.570     0.200
     5.405    80.387     0.200
     5.459    81.816     0.200
     5.459    81.680     0.200
     5.554    83.000     0.200
     5.548    84.230     0.200
     5.725    86.559     0.200
     5.764    85.801     0.200
     6.060    89.602     0.200
     6.127    90.598     0.200
     6.127    90.699     0.200
     6.141    92.516     0.200
     6.170    92.039     0.200
     6.197    93.328     0.200
     6.353    92.906     0.200
     6.353    91.988     0.200
     6.675    99.227     0.200
     6.759   101.410     0.200
     6.778   100.699     0.200
     6.806   101.480     0.200
     6.817    98.699     0.200
     7.134   108.531     0.200
     7.154   105.102     0.200
     7.160   105.000     0.200
     7.234   105.719     0.200
     7.256   106.719     0.200
     7.487   110.984     0.200
     7.487   110.250     0.200
     7.510   109.852     0.200
     7.738   117.719     0.200
     7.805   115.828     0.200
     7.854   115.398     0.200
     7.854   114.773     0.200
     7.854   114.461     0.200
     7.897   116.500     0.200
     7.991   118.059     0.200
     8.034   119.559     0.200
     8.212   123.602     0.200
     8.212   122.035     0.200
     8.327   121.379     0.200
     8.349   122.301     0.200
     8.431   121.551     0.200
     8.515   124.500     0.200
     8.515   124.352     0.200
     8.803   130.398     0.200
     8.864   129.418     0.200
     8.864   129.770     0.200
     8.882   130.789     0.200
     8.927   131.039     0.200
     8.978   133.340     0.200
     9.011   132.113     0.200
     9.195   137.168     0.200
     9.254   134.012     0.200
     9.274   136.172     0.200
     9.415   138.219     0.200
     9.483   139.742     0.200
     9.563   139.902     0.200
     9.662   140.441     0.200
     9.690   142.641     0.200
     9.738   142.859     0.200
     9.739   141.387     0.200
     9.757   142.500     0.200
     9.767   142.227     0.200
     9.836   145.051     0.200
     9.881   144.262     0.200
     9.917   145.902     0.200
    10.021   146.203     0.200
    10.099   147.211     0.200
    10.189   148.500     0.200
    10.186   147.762     0.200
    10.191   147.566     0.200
    10.211   149.363     0.200
    10.211   150.719     0.200
    10.260   148.992     0.200
    10.288   150.180     0.200
    10.397   150.324     0.200
    10.416   151.559     0.200
    10.430   153.387     0.200
    10.466   154.270     0.200
    10.478   152.766     0.200
    10.491   156.672     0.200
    10.544   154.000     0.200
    10.579   155.484     0.200
    10.614   154.355     0.200
    10.647   154.996     0.200
    10.647   154.621     0.200
    10.642   156.090     0.200
    10.642   153.699     0.200
    10.760   156.113     0.200
    10.771   156.895     0.200
    10.820   158.246     0.200
    10.827   156.504     0.200
    10.890   160.602     0.200
    10.887   158.301     0.200
    10.887   157.371     0.200
    10.915   158.453     0.200
    10.922   158.480     0.200
    10.982   161.234     0.200
    10.991   159.504     0.200
    11.043   160.879     0.200
    11.070   161.242     0.200
    11.095   161.555     0.200
    11.127   161.051     0.200
    11.127   162.961     0.200
    11.124   163.094     0.200
    11.191   163.070     0.200
    11.183   163.461     0.200
    11.198   163.898     0.200
    11.198   163.152     0.200
    11.197   162.039     0.200
    11.304   163.535     0.200
    11.351   165.586     0.200
    11.351   165.879     0.200
    11.338   164.789     0.200
    11.349   165.086     0.200
    11.396   169.699     0.200
    11.401   166.371     0.200
    11.413   166.176     0.200
    11.420   166.695     0.200
    11.420   165.930     0.200
    11.433   166.270     0.200
    11.459   166.852     0.200
    11.459   168.102     0.200
    11.470   165.461     0.200
    11.471   165.801     0.200
    11.484   166.590     0.200
    11.509   168.020     0.200
    11.533   166.980     0.200
    11.544   167.301     0.200
    11.572   167.129     0.200
    11.590   168.867     0.200
    11.586   166.430     0.200
    11.579   166.789     0.200
    11.667   170.559     0.200
    11.659   168.609     0.200
    11.659   167.328     0.200
    11.682   169.578     0.200
    11.727   169.418     0.200
    11.765   172.102     0.200
    11.784   172.988     0.200
    11.865   170.988     0.200
    11.888   173.809     0.200
    11.895   171.926     0.200
    11.962   174.840     0.200
    11.973   174.750     0.200
    11.969   174.000     0.200
    11.988   174.055     0.200
    11.991   175.523     0.200
    11.986   173.840     0.200
    12.009   175.297     0.200
    12.007   176.711     0.200
    12.028   175.559     0.200
    12.031   174.453     0.200
    12.031   173.559     0.200
    12.072   175.254     0.200
    12.080   175.445     0.200
    12.076   175.164     0.200
    12.110   174.801     0.200
    12.121   175.793     0.200
    12.136   175.797     0.200
    12.154   177.461     0.200
    12.156   177.930     0.200
    12.197   175.141     0.200
    12.187   175.801     0.200
    12.225   176.273     0.200
    12.256   178.203     0.200
    12.259   176.777     0.200
    12.258   176.746     0.200
    12.303   181.871     0.200
    12.326   178.828     0.200
    12.326   178.469     0.200
    12.330   177.934     0.200
    12.384   181.461     0.200
    12.432   179.141     0.200
    12.460   180.750     0.200
    12.484   179.941     0.200
    12.487   179.832     0.200
    12.522   180.023     0.200
    12.522   180.988     0.200
    12.524   180.574     0.200
    12.546   181.629     0.200
    12.588   181.699     0.200
    12.594   180.926     0.200
    12.601   181.648     0.200
    12.620   182.352     0.200
    12.635   182.359     0.200
    12.627   181.957     0.200
    12.679   182.859     0.200
    12.705   183.629     0.200
    12.709   182.691     0.200
    12.709   184.352     0.200
    12.718   186.160     0.200
    12.701   181.961     0.200
    12.718   183.895     0.200
    12.721   182.609     0.200
    12.738   186.578     0.200
    12.794   184.289     0.200
    12.785   184.844     0.200
    12.794   183.629     0.200
    12.815   185.367     0.200
    12.813   184.754     0.200
    12.826   186.230     0.200
    12.832   184.543     0.200
    12.847   186.516     0.200
    12.860   188.602     0.200
    12.859   185.711     0.200
    12.886   188.180     0.200
    12.894   185.418     0.200
    12.953   186.266     0.200
    12.964   189.449     0.200
    12.948   185.273     0.200
    12.988   190.910     0.200
    12.990   189.090     0.200
    12.995   187.473     0.200
    13.001   188.598     0.200
    13.010   185.750     0.200
    13.013   186.336     0.200
    13.040   188.133     0.200
    13.074   186.910     0.200
    13.102   188.074     0.200
    13.103   187.789     0.200
    13.115   187.949     0.200
    13.160   189.113     0.200
    13.174   188.961     0.200
    13.196   189.789     0.200
    13.192   189.027     0.200
    13.224   189.988     0.200
    13.224   188.699     0.200
    13.249   190.391     0.200
    13.272   190.445     0.200
    13.295   194.691     0.200
    13.282   191.336     0.200
    13.297   190.562     0.200
    13.307   190.098     0.200
    13.334   192.102     0.200
    13.355   190.953     0.200
    13.366   195.621     0.200
    13.351   191.219     0.200
    13.347   192.102     0.200
    13.347   191.293     0.200
    13.375   191.992     0.200
    13.373   191.703     0.200
    13.398   192.070     0.200
    13.400   192.391     0.200
    13.403   191.906     0.200
    13.411   191.293     0.200
    13.417   192.051     0.200
    13.461   192.973     0.200
    13.514   193.258     0.200
    13.555   194.012     0.200
    13.567   197.301     0.200
    13.562   192.902     0.200
    13.585   193.828     0.200
    13.652   199.570     0.200
    13.657   195.211     0.200
    13.673   195.316     0.200
    13.672   195.535     0.200
    13.713   197.762     0.200
    13.738   195.727     0.200
    13.747   195.453     0.200
    13.747   194.738     0.200
    13.766   199.031     0.200
    13.763   196.566     0.200
    13.771   196.312     0.200
    13.804   197.203     0.200
    13.801   196.699     0.200
    13.828   197.789     0.200
    13.850   200.301     0.200
    13.838   197.418     0.200
    13.879   197.969     0.200
    13.905   198.477     0.200
    13.892   197.723     0.200
    13.900   198.324     0.200
    13.912   198.152     0.200
    13.926   197.887     0.200
    13.948   198.660     0.200
    13.967   199.414     0.200
    13.984   200.258     0.200
    14.006   199.301     0.200
    14.035   199.973     0.200
    14.037   200.500     0.200
    14.081   200.672     0.200
    14.087   201.410     0.200
    14.082   201.117     0.200
    14.103   200.980     0.200
    14.105   201.227     0.200
    14.111   201.324     0.200
    14.195   202.379     0.200
    14.208   202.613     0.200
    14.218   201.602     0.200
    14.225   202.598     0.200
    14.238   204.469     0.200
    14.224   202.930     0.200
    14.268   203.809     0.200
    14.268   203.062     0.200
    14.307   203.488     0.200
    14.327   204.402     0.200
    14.339   203.207     0.200
    14.366   204.445     0.200
    14.384   204.695     0.200
    14.414   205.242     0.200
    14.430   205.867     0.200
    14.477   205.875     0.200
    14.476   205.312     0.200
    14.533   209.391     0.200
    14.531   205.520     0.200
    14.547   206.273     0.200
    14.539   205.598     0.200
    14.545   205.688     0.200
    14.550   206.090     0.200
    14.569   206.863     0.200
    14.565   206.523     0.200
    14.585   206.703     0.200
    14.585   206.746     0.200
    14.634   207.922     0.200
    14.634   211.051     0.200
    14.628   207.180     0.200
    14.619   207.703     0.200
    14.648   207.723     0.200
    14.659   206.934     0.200
    14.679   207.988     0.200
    14.685   208.484     0.200
    14.713   208.426     0.200
    14.747   209.258     0.200
    14.765   212.391     0.200
    14.772   209.371     0.200
    14.801   209.500     0.200
    14.799   209.469     0.200
    14.804   209.328     0.200
    14.799   209.988     0.200
    14.801   208.438     0.200
    14.826   209.887     0.200
    14.840   209.605     0.200
    14.867   211.328     0.200
    14.865   209.746     0.200
    14.873   210.719     0.200
    14.882   210.617     0.200
    14.882   209.691     0.200
    14.900   210.199     0.200
    14.985   212.285     0.200
    15.035   213.523     0.200
    15.056   212.477     0.200
    15.072   216.289     0.200
    15.079   214.141     0.200
    15.077   213.012     0.200
    15.082   213.625     0.200
    15.110   213.773     0.200
    15.116   213.465     0.200
    15.116   214.969     0.200
    15.158   213.832     0.200
    15.169   214.688     0.200
    15.169   215.461     0.200
    15.170   214.699     0.200
    15.183   214.410     0.200
    15.204   215.031     0.200
    15.211   215.566     0.200
    15.214   215.102     0.200
    15.241   215.426     0.200
    15.225   214.879     0.200
    15.246   215.590     0.200
    15.257   215.367     0.200
    15.257   216.102     0.200
    15.296   216.883     0.200
    15.302   216.816     0.200
    15.309   219.461     0.200
    15.311   215.418     0.200
    15.316   216.547     0.200
    15.329   216.309     0.200
    15.345   216.840     0.200
    15.385   216.777     0.200
    15.377   216.820     0.200
    15.394   217.180     0.200
    15.427   218.148     0.200
    15.505   219.316     0.200
    15.534   221.871     0.200
    15.583   220.199     0.200
    15.638   220.066     0.200
    15.673   220.828     0.200
    15.716   223.070     0.200
    15.706   220.988     0.200
    15.704   221.578     0.200
    15.715   221.344     0.200
    15.738   223.410     0.200
    15.739   222.000     0.200
    15.749   222.547     0.200
    15.747   221.973     0.200
    15.771   222.938     0.200
    15.834   223.195     0.200
    15.850   222.707     0.200
    15.841   222.906     0.200
    15.842   223.641     0.200
    15.868   222.609     0.200
    15.884   222.848     0.200
    15.907   224.711     0.200
    15.892   223.656     0.200
    15.910   224.598     0.200
    15.919   223.777     0.200
    15.971   224.184     0.200
    15.985   225.520     0.200
    16.043   227.629     0.200
    16.064   224.910     0.200
    16.093   225.699     0.200
    16.093   228.551     0.200
    16.090   225.504     0.200
    16.124   226.777     0.200
    16.134   227.344     0.200
    16.155   226.680     0.200
    16.198   227.246     0.200
    16.213   227.855     0.200
    16.220   227.031     0.200
    16.239   228.188     0.200
    16.341   229.812     0.200
    16.358   230.480     0.200
    16.381   229.910     0.200
    16.388   229.215     0.200
    16.424   231.199     0.200
    16.444   231.012     0.200
    16.461   232.156     0.200
    16.463   231.910     0.200
    16.472   230.797     0.200
    16.485   231.246     0.200
    16.485   233.602     0.200
    16.501   230.809     0.200
    16.508   230.914     0.200
    16.527   231.648     0.200
    16.567   231.328     0.200
    16.567   233.949     0.200
    16.627   234.414     0.200
    16.641   233.305     0.200
    16.648   233.059     0.200
    16.648   234.820     0.200
    16.692   233.746     0.200
    16.737   233.883     0.200
    16.748   234.047     0.200
    16.792   234.934     0.200
    16.810   234.660     0.200
    16.918   236.555     0.200
    16.942   237.668     0.200
    16.965   236.730     0.200
    17.008   237.473     0.200
    17.061   238.887     0.200
    17.051   235.746     0.200
    17.066   238.172     0.200
    17.059   238.750     0.200
    17.080   238.496     0.200
    17.085   237.738     0.200
    17.089   238.926     0.200
    17.249   239.652     0.200
    17.318   241.422     0.200
    17.393   242.406     0.200
    17.409   242.695     0.200
    17.499   244.160     0.200
    17.541   244.074     0.200
    17.548   244.453     0.200
    17.615   245.410     0.200
    17.625   244.949     0.200
    17.636   245.727     0.200
    17.658   246.234     0.200
    17.658   246.020     0.200
    17.650   245.926     0.200
    17.688   245.523     0.200
    17.766   247.910     0.200
    17.765   247.203     0.200
    17.902   250.148     0.200
    17.983   250.840     0.200
    17.988   250.785     0.200
    18.001   251.105     0.200
    18.100   251.527     0.200
    18.184   252.629     0.200
    18.192   251.980     0.200
    18.200   253.211     0.200
    18.202   253.219     0.200
    18.220   252.539     0.200
    18.274   254.195     0.200
    18.277   254.699     0.200
    18.480   257.016     0.200
    18.922   262.547     0.200
    19.073   264.234     0.200
    20.948   286.398     0.200
     0.883    15.169     0.200
     0.883    14.743     0.200
     1.120    17.743     0.200
     1.155    19.743     0.200
     1.214    19.743     0.200
     1.217    22.103     0.200
     1.252    22.303     0.200
     1.253    22.343     0.200
     1.302    20.743     0.200
     1.270    22.833     0.200
     1.353    22.117     0.200
     1.370    22.743     0.200
     1.441    23.823     0.200
     1.570    26.136     0.200
     1.592    25.593     0.200
     1.616    25.965     0.200
     1.774    28.035     0.200
     1.863    29.286     0.200
     2.002    31.405     0.200
     2.207    34.079     0.200
     2.308    35.869     0.200
     2.489    38.134     0.200
     2.578    39.478     0.200
     2.780    42.682     0.200
    10.496   151.568     0.200
     0.588    11.904     0.200
     0.854    14.402     0.200
     0.955    15.867     0.200
     1.209    21.975     0.200
     1.274    22.824     0.200
     1.435    23.430     0.200
     1.465    23.482     0.200
     1.694    26.719     0.200
     1.660    27.217     0.200
     1.710    27.055     0.200
     1.710    26.904     0.200
     1.892    29.318     0.200
     1.967    30.746     0.200
     2.144    32.977     0.200
     2.144    32.805     0.200
     2.112    32.967     0.200
     2.318    35.926     0.200
     2.328    35.902     0.200
     2.463    38.084     0.200
     2.612    40.252     0.200
     2.602    39.631     0.200
     3.062    48.283     0.200
     3.733    55.574     0.200
     3.846    56.305     0.200
     4.306    64.854     0.200
     4.343    64.014     0.200
     4.489    66.193     0.200
     4.668    70.404     0.200
     4.808    73.055     0.200
     5.497    81.465     0.200
     5.584    83.494     0.200
     5.794    86.033     0.200
     6.074    90.453     0.200
     6.148    90.543     0.200
     6.386    92.754     0.200
     6.791   103.305     0.200
     7.270   105.994     0.200
     7.525   111.293     0.200
     7.580   109.645     0.200
     7.891   114.703     0.200
     7.891   114.055     0.200
     7.931   117.164     0.200
     8.105   119.283     0.200
     8.461   121.604     0.200
     8.537   123.404     0.200
     8.537   123.514     0.200
     8.902   129.754     0.200
     9.727   142.594     0.200
    10.422   150.680     0.200
    10.677   155.314     0.200
    10.925   158.994     0.200
    11.202   164.332     0.200
    11.503   165.104     0.200
    11.918   174.264     0.200
     0.903    15.148     0.200
     0.903    15.047     0.200
     1.209    21.977     0.200
     1.225    21.906     0.200
     1.225    21.930     0.200
     1.265    22.688     0.200
     1.381    22.344     0.200
     1.444    23.570     0.200
     1.587    26.508     0.200
     1.619    25.852     0.200
     1.638    25.922     0.200
     1.802    28.258     0.200
     1.890    29.664     0.200
     2.026    32.016     0.200
     2.196    33.750     0.200
     2.196    33.523     0.200
     2.315    36.008     0.200
     2.518    38.953     0.200
     2.568    39.695     0.200
     2.590    39.836     0.200
     2.798    43.461     0.200
     2.976    48.531     0.200
     3.025    45.500     0.200
     3.249    50.094     0.200
     3.885    57.461     0.200
     4.252    63.172     0.200
     4.398    65.094     0.200
     4.640    69.781     0.200
     5.489    82.000     0.200
     5.519    82.070     0.200
     5.727    84.523     0.200
     6.066    89.469     0.200
     6.422    93.742     0.200
     6.731   100.562     0.200
     7.286   106.117     0.200
     7.500   110.750     0.200
     7.880   114.141     0.200
     7.900   116.125     0.200
    10.482   151.297     0.200
    11.444   167.945     0.200
     0.876    14.914     0.200
     0.931    15.617     0.200
     0.931    15.719     0.200
     0.931    15.945     0.200
     0.970    16.469     0.200
     1.246    19.844     0.200
     1.255    22.594     0.200
     1.286    22.633     0.200
     1.352    21.633     0.200
     1.322    23.547     0.200
     1.388    22.930     0.200
     1.447    23.883     0.200
     1.466    23.805     0.200
     1.507    24.180     0.200
     1.565    24.617     0.200
     1.628    26.898     0.200
     1.672    26.609     0.200
     1.655    27.234     0.200
     1.703    28.234     0.200
     1.703    28.305     0.200
     1.719    27.586     0.200
     1.735    27.609     0.200
     1.735    27.258     0.200
     1.768    28.445     0.200
     1.775    28.789     0.200
     1.788    28.836     0.200
     1.846    29.547     0.200
     1.904    29.906     0.200
     1.961    30.750     0.200
     1.961    30.930     0.200
     2.017    31.555     0.200
     2.058    32.406     0.200
     2.065    32.664     0.200
     2.095    32.398     0.200
     2.103    33.227     0.200
     2.147    34.055     0.200
     2.273    35.102     0.200
     2.304    35.859     0.200
     2.439    38.023     0.200
     2.487    38.867     0.200
     2.573    39.695     0.200
     2.605    39.984     0.200
     2.623    40.242     0.200
     2.777    42.219     0.200
     2.862    43.664     0.200
     2.879    44.805     0.200
     2.863    44.664     0.200
     2.881    43.820     0.200
     2.915    44.977     0.200
     3.117    46.961     0.200
     3.126    48.812     0.200
     3.145    51.516     0.200
     3.280    49.398     0.200
     3.356    50.742     0.200
     3.519    52.828     0.200
     3.769    57.477     0.200
     3.790    56.875     0.200
     3.796    55.398     0.200
     3.893    58.977     0.200
     4.086    61.781     0.200
     4.172    63.133     0.200
     4.273    64.031     0.200
     4.302    64.758     0.200
     4.370    65.156     0.200
     4.370    64.938     0.200
     4.507    67.148     0.200
     4.631    70.039     0.200
     4.631    70.688     0.200
     4.813    71.125     0.200
     4.813    72.609     0.200
     4.887    73.789     0.200
     5.022    76.406     0.200
     5.065    76.078     0.200
     5.159    76.070     0.200
     5.215    77.875     0.200
     5.376    80.688     0.200
     5.369    81.328     0.200
     5.454    81.453     0.200
     5.454    81.688     0.200
     5.567    83.047     0.200
     5.778    85.688     0.200
     6.083    89.859     0.200
     6.147    90.086     0.200
     6.336    92.008     0.200
     6.497    95.016     0.200
     6.770    99.477     0.200
     6.814   100.984     0.200
     7.149   104.516     0.200
     7.159   104.789     0.200
     7.180   103.219     0.200
     7.222   105.258     0.200
     7.244   105.758     0.200
     7.486   109.836     0.200
     7.486   110.516     0.200
     7.498   109.312     0.200
     7.531   109.914     0.200
     7.741   115.805     0.200
     7.844   114.734     0.200
     7.844   114.453     0.200
     7.905   117.383     0.200
     7.994   117.867     0.200
     8.038   119.484     0.200
     8.162   119.273     0.200
     8.226   120.188     0.200
     8.338   123.180     0.200
     8.371   123.117     0.200
     8.412   120.883     0.200
     8.534   124.758     0.200
     8.534   123.594     0.200
     8.815   129.969     0.200
     8.862   129.086     0.200
     8.897   128.664     0.200
     8.940   130.969     0.200
     9.169   134.852     0.200
     9.236   132.445     0.200
     9.428   134.867     0.200
     9.691   141.914     0.200
     9.735   141.305     0.200
     9.743   139.648     0.200
     9.772   142.086     0.200
     9.849   143.125     0.200
    10.205   148.758     0.200
    10.374   150.055     0.200
    10.374   150.062     0.200
    10.425   147.469     0.200
    10.491   155.016     0.200
    10.628   155.125     0.200
    10.888   158.914     0.200
    11.056   159.062     0.200
    11.211   159.609     0.200
    11.224   164.578     0.200
    11.224   163.789     0.200
    11.369   164.719     0.200
    11.481   167.867     0.200
    11.481   164.867     0.200
    11.481   164.867     0.200
    11.647   166.062     0.200
    11.680   167.703     0.200
    11.778   169.938     0.200
    11.902   172.312     0.200
    11.975   170.969     0.200
    12.053   171.156     0.200
    12.398   178.695     0.200
    12.722   181.984     0.200
    12.900   185.805     0.200
    13.208   189.297     0.200
    13.328   192.438     0.200
    13.389   193.508     0.200
    13.591   195.734     0.200
    13.726   197.117     0.200
    13.782   195.734     0.200
    13.852   197.375     0.200
    13.875   196.531     0.200
    14.472   207.812     0.200
    14.651   208.609     0.200
    14.759   209.180     0.200
    14.774   211.359     0.200
    14.782   211.406     0.200
    14.792   209.594     0.200
    14.806   210.414     0.200
    15.090   214.094     0.200
    15.106   214.953     0.200
    15.157   213.867     0.200
    15.381   217.180     0.200
    15.834   223.875     0.200
    16.053   225.969     0.200
    16.114   227.523     0.200
    16.438   231.289     0.200
    16.556   231.133     0.200
    16.798   234.359     0.200
    16.878   235.680     0.200
    17.562   242.484     0.200
    18.263   252.289     0.200
     0.884    15.242     0.200
     1.037    17.496     0.200
     1.125    18.938     0.200
     1.125    18.801     0.200
     1.319    22.500     0.200
     1.363    22.293     0.200
     1.512    24.395     0.200
     1.533    24.812     0.200
     1.591    25.699     0.200
     1.617    27.750     0.200
     1.618    28.430     0.200
     1.618    27.039     0.200
     1.686    27.105     0.200
     1.879    30.418     0.200
     2.135    33.582     0.200
     2.133    33.273     0.200
     2.228    34.613     0.200
     2.243    35.094     0.200
     2.319    36.312     0.200
     2.352    35.992     0.200
     2.369    36.723     0.200
     2.374    36.344     0.200
     2.448    37.656     0.200
     2.471    38.031     0.200
     2.484    39.418     0.200
     2.533    41.668     0.200
     2.592    39.227     0.200
     2.643    40.633     0.200
     2.784    42.465     0.200
     2.785    42.551     0.200
     2.785    42.309     0.200
     2.900    44.645     0.200
     2.901    44.285     0.200
     3.155    48.188     0.200
     3.510    52.375     0.200
     3.553    53.555     0.200
     3.689    55.203     0.200
     3.755    56.082     0.200
     3.755    56.398     0.200
     3.880    58.590     0.200
     3.924    58.570     0.200
     4.017    60.113     0.200
     4.220    61.660     0.200
     4.209    62.441     0.200
     4.309    64.605     0.200
     4.410    65.590     0.200
     4.534    67.684     0.200
     4.631    69.730     0.200
     4.631    70.000     0.200
     4.735    71.238     0.200
     5.200    77.070     0.200
     5.271    78.918     0.200
     5.469    81.160     0.200
     5.545    82.328     0.200
     5.584    83.184     0.200
     5.649    82.250     0.200
     5.690    83.625     0.200
     5.690    83.730     0.200
     6.092    89.699     0.200
     6.129    90.086     0.200
     6.227    90.430     0.200
     6.519    97.000     0.200
     6.565    97.270     0.200
     6.569    96.301     0.200
     6.733    97.984     0.200
     6.733    97.648     0.200
     7.410   108.059     0.200
     7.502   109.059     0.200
     7.501   111.391     0.200
     7.591   112.430     0.200
     7.722   113.801     0.200
     7.856   113.188     0.200
     7.875   112.910     0.200
     7.897   114.176     0.200
     7.897   113.668     0.200
     8.026   117.711     0.200
     8.077   117.266     0.200
     8.077   117.621     0.200
     8.070   118.750     0.200
     8.092   117.516     0.200
     8.546   124.020     0.200
     8.554   124.680     0.200
     8.650   125.738     0.200
     8.850   126.715     0.200
     8.903   130.090     0.200
     9.111   132.797     0.200
     9.143   134.438     0.200
     9.427   137.125     0.200
     9.420   135.801     0.200
     9.446   137.199     0.200
     9.598   139.578     0.200
     9.617   139.867     0.200
     9.617   140.758     0.200
     9.759   141.375     0.200
     9.811   142.301     0.200
     9.814   141.699     0.200
     9.968   144.441     0.200
    10.049   144.762     0.200
    10.086   145.078     0.200
    10.142   145.648     0.200
    10.320   148.840     0.200
    10.341   149.000     0.200
    10.400   149.695     0.200
    10.466   151.129     0.200
    10.532   151.727     0.200
    10.547   151.688     0.200
    10.594   152.594     0.200
    10.622   156.844     0.200
    10.671   153.234     0.200
    10.751   156.758     0.200
    10.853   155.270     0.200
    10.862   156.473     0.200
    10.862   158.250     0.200
    10.892   156.184     0.200
    10.941   158.328     0.200
    10.950   157.852     0.200
    10.950   157.570     0.200
    10.948   157.816     0.200
    10.948   157.160     0.200
    10.962   157.691     0.200
    11.039   159.059     0.200
    11.133   159.023     0.200
    11.149   158.199     0.200
    11.195   160.504     0.200
    11.217   160.230     0.200
    11.228   162.051     0.200
    11.228   160.531     0.200
    11.244   159.582     0.200
    11.254   160.551     0.200
    11.313   161.852     0.200
    11.382   162.703     0.200
    11.382   162.266     0.200
    11.395   162.469     0.200
    11.467   164.066     0.200
    11.511   164.688     0.200
    11.580   165.605     0.200
    11.716   167.715     0.200
    11.744   167.660     0.200
    11.749   167.898     0.200
    11.825   168.969     0.200
    11.825   169.336     0.200
    11.842   169.867     0.200
    11.842   170.117     0.200
    11.859   170.699     0.200
    11.869   170.715     0.200
    11.900   171.457     0.200
    11.929   171.215     0.200
    11.929   171.828     0.200
    11.942   170.688     0.200
    11.968   172.504     0.200
    11.965   173.086     0.200
    11.987   172.102     0.200
    11.991   171.762     0.200
    12.027   171.980     0.200
    12.060   173.320     0.200
    12.174   174.289     0.200
    12.213   176.453     0.200
    12.275   177.297     0.200
    12.308   175.547     0.200
    12.289   175.293     0.200
    12.372   177.793     0.200
    12.371   176.773     0.200
    12.371   174.789     0.200
    12.372   178.125     0.200
    12.371   181.879     0.200
    12.392   179.426     0.200
    12.408   179.352     0.200
    12.424   177.406     0.200
    12.442   176.926     0.200
    12.477   177.887     0.200
    12.458   178.805     0.200
    12.503   179.797     0.200
    12.507   178.484     0.200
    12.524   180.152     0.200
    12.543   177.703     0.200
    12.550   179.902     0.200
    12.573   179.512     0.200
    12.570   181.031     0.200
    12.623   182.301     0.200
    12.688   181.711     0.200
    12.704   182.012     0.200
    12.724   182.551     0.200
    12.769   182.879     0.200
    12.858   183.875     0.200
    12.881   184.453     0.200
    12.915   184.379     0.200
    12.956   184.633     0.200
    12.969   185.180     0.200
    12.973   185.445     0.200
    12.980   183.781     0.200
    13.034   186.191     0.200
    13.038   186.855     0.200
    13.058   187.367     0.200
    13.090   186.898     0.200
    13.089   186.395     0.200
    13.112   188.016     0.200
    13.132   187.539     0.200
    13.231   188.590     0.200
    13.280   189.758     0.200
    13.300   190.125     0.200
    13.293   191.055     0.200
    13.373   191.730     0.200
    13.380   191.844     0.200
    13.416   191.676     0.200
    13.436   190.848     0.200
    13.517   190.875     0.200
    13.587   192.918     0.200
    13.587   192.281     0.200
    13.636   193.309     0.200
    13.654   194.609     0.200
    13.660   192.883     0.200
    13.689   193.969     0.200
    13.703   195.406     0.200
    13.716   195.480     0.200
    13.778   196.359     0.200
    13.780   196.898     0.200
    13.780   194.988     0.200
    13.811   197.512     0.200
    13.850   197.652     0.200
    13.860   197.641     0.200
    13.943   198.234     0.200
    14.045   200.766     0.200
    14.137   201.855     0.200
    14.200   201.684     0.200
    14.197   202.188     0.200
    14.210   202.508     0.200
    14.232   201.957     0.200
    14.274   202.180     0.200
    14.287   202.957     0.200
    14.293   199.598     0.200
    14.291   203.141     0.200
    14.298   203.418     0.200
    14.303   203.449     0.200
    14.320   203.699     0.200
    14.372   203.238     0.200
    14.365   206.531     0.200
    14.394   204.715     0.200
    14.513   205.898     0.200
    14.522   207.012     0.200
    14.568   207.773     0.200
    14.579   207.641     0.200
    14.660   209.387     0.200
    14.670   208.520     0.200
    14.698   207.180     0.200
    14.700   209.723     0.200
    14.754   210.168     0.200
    14.799   210.512     0.200
    14.797   210.887     0.200
    14.891   210.836     0.200
    14.898   210.602     0.200
    14.907   210.984     0.200
    14.907   213.062     0.200
    14.919   210.852     0.200
    14.931   211.469     0.200
    14.994   211.625     0.200
    15.000   212.742     0.200
    15.003   212.707     0.200
    15.023   211.680     0.200
    15.026   211.809     0.200
    15.025   213.453     0.200
    15.066   214.055     0.200
    15.119   214.738     0.200
    15.154   215.535     0.200
    15.154   214.281     0.200
    15.251   215.832     0.200
    15.307   217.145     0.200
    15.410   217.410     0.200
    15.420   217.227     0.200
    15.420   216.781     0.200
    15.471   219.000     0.200
    15.487   218.832     0.200
    15.494   218.371     0.200
    15.494   219.188     0.200
    15.502   219.266     0.200
    15.518   219.609     0.200
    15.550   219.562     0.200
    15.555   220.742     0.200
    15.583   220.836     0.200
    15.624   220.820     0.200
    15.633   221.688     0.200
    15.648   221.910     0.200
    15.696   221.598     0.200
    15.740   221.969     0.200
    15.761   221.312     0.200
    15.762   223.195     0.200
    15.805   223.504     0.200
    15.810   221.449     0.200
    15.879   223.672     0.200
    15.907   223.746     0.200
    15.962   224.676     0.200
    16.019   224.949     0.200
    16.058   226.477     0.200
    16.084   227.016     0.200
    16.098   227.047     0.200
    16.647   233.523     0.200
    16.667   232.742     0.200
    17.251   240.781     0.200
    17.370   242.176     0.200
    17.397   242.629     0.200
    18.531   257.457     0.200
    18.577   257.750     0.200
    18.585   256.883     0.200
    18.636   258.809     0.200
    18.636   259.410     0.200
    18.923   262.656     0.200
    19.403   267.812     0.200
    19.500   268.121     0.200
    19.589   269.152     0.200
    20.445   279.285     0.200
    20.886   282.922     0.200
     1.116    20.566     0.200
     1.195    20.727     0.200
     1.250    22.180     0.200
     1.360    22.008     0.200
     1.405    23.094     0.200
     1.609    26.277     0.200
     1.603    25.527     0.200
     1.619    25.812     0.200
     1.619    25.559     0.200
     1.790    28.496     0.200
     1.864    29.270     0.200
     2.036    31.934     0.200
     2.166    33.375     0.200
     2.238    34.707     0.200
     2.274    35.250     0.200
     2.498    38.188     0.200
     2.550    39.680     0.200
     2.663    40.812     0.200
     2.748    42.371     0.200
     2.782    43.816     0.200
     2.985    47.488     0.200
     3.036    48.660     0.200
     3.658    55.059     0.200
     3.851    56.840     0.200
     4.203    63.207     0.200
     4.254    63.199     0.200
     4.391    66.430     0.200
     4.600    69.430     0.200
     5.448    81.066     0.200
     5.487    81.527     0.200
     5.696    85.137     0.200
     6.044    89.438     0.200
     6.387    93.410     0.200
     6.698    98.809     0.200
     7.043   105.828     0.200
     7.064   105.129     0.200
     7.248   105.750     0.200
     7.460   110.648     0.200
     7.747   117.598     0.200
     7.861   115.539     0.200
     7.861   115.000     0.200
     7.844   113.680     0.200
     8.033   118.418     0.200
     8.085   117.039     0.200
     8.434   123.090     0.200
     8.810   126.938     0.200
     9.286   137.934     0.200
     9.685   139.918     0.200
     9.693   142.699     0.200
     9.770   140.457     0.200
    10.455   150.812     0.200
    10.664   152.520     0.200
    10.976   158.410     0.200
    11.410   165.969     0.200
    11.410   168.539     0.200
    12.473   177.969     0.200
    15.151   211.930     0.200
    16.781   233.379     0.200
    18.298   252.527     0.200
    20.965   284.078     0.200
     1.035    17.793     0.200
     1.124    19.129     0.200
     1.124    18.969     0.200
     1.214    22.297     0.200
     1.218    22.277     0.200
     1.220    22.328     0.200
     1.320    22.859     0.200
     1.361    22.648     0.200
     1.510    24.781     0.200
     1.532    25.418     0.200
     1.589    25.914     0.200
     1.619    27.930     0.200
     1.619    28.129     0.200
     1.685    27.488     0.200
     1.877    30.824     0.200
     2.130    33.555     0.200
     2.225    34.844     0.200
     2.242    35.406     0.200
     2.369    38.621     0.200
     2.470    38.398     0.200
     2.481    39.879     0.200
     2.480    40.758     0.200
     2.592    39.668     0.200
     2.592    39.547     0.200
     2.782    42.719     0.200
     2.900    44.688     0.200
     3.241    49.055     0.200
     3.687    55.191     0.200
     3.753    55.988     0.200
     3.753    56.617     0.200
     3.878    58.930     0.200
     3.922    58.809     0.200
     4.015    61.344     0.200
     4.307    64.434     0.200
     4.409    65.434     0.200
     4.532    67.461     0.200
     5.269    79.117     0.200
     5.466    81.359     0.200
     5.583    83.906     0.200
     6.127    90.402     0.200
     6.516    99.449     0.200
     6.733    98.266     0.200
     6.733    98.090     0.200
     7.500   110.559     0.200
     7.720   114.758     0.200
     8.024   117.340     0.200
     8.075   118.203     0.200
     8.090   121.402     0.200
    10.892   156.680     0.200
    10.949   158.977     0.200
     0.877    14.750     0.200
     0.936    15.328     0.200
     0.936    15.500     0.200
     0.982    16.164     0.200
     1.100    21.453     0.200
     1.144    19.148     0.200
     1.215    20.789     0.200
     1.250    20.984     0.200
     1.308    20.484     0.200
     1.360    20.250     0.200
     1.402    22.625     0.200
     1.414    22.203     0.200
     1.528    24.273     0.200
     1.549    24.781     0.200
     1.605    25.234     0.200
     1.723    26.992     0.200
     1.699    27.594     0.200
     1.743    28.367     0.200
     1.743    28.703     0.200
     1.775    28.133     0.200
     1.794    27.969     0.200
     1.794    28.078     0.200
     1.845    29.398     0.200
     1.902    30.070     0.200
     1.967    30.461     0.200
     2.021    31.359     0.200
     2.075    31.703     0.200
     2.111    32.922     0.200
     2.119    33.172     0.200
     2.158    33.719     0.200
     2.199    34.133     0.200
     2.293    35.312     0.200
     2.605    39.672     0.200
     2.680    40.414     0.200
     2.667    40.375     0.200
     2.940    45.641     0.200
     2.916    44.445     0.200
     2.955    45.281     0.200
     3.169    46.867     0.200
     3.148    50.062     0.200
     3.196    51.320     0.200
     4.875    73.172     0.200
     5.266    78.672     0.200
     6.255    93.523     0.200
     6.761   100.750     0.200
     6.761   100.750     0.200
     6.862   101.562     0.200
     7.156   104.578     0.200
     7.227   104.992     0.200
     7.502   109.094     0.200
     7.779   118.031     0.200
     7.854   113.148     0.200
     8.033   118.039     0.200
     8.595   125.672     0.200
     8.891   130.570     0.200
     9.727   142.430     0.200
    10.347   147.547     0.200
    10.630   157.125     0.200
    11.284   166.289     0.200
    11.483   169.922     0.200
    11.533   165.719     0.200
    11.533   165.719     0.200
    12.389   181.773     0.200
    13.653   198.344     0.200
     1.026    17.191     0.200
     1.081    18.023     0.200
     1.327    21.980     0.200
     1.345    23.777     0.200
     1.365    23.465     0.200
     1.365    23.898     0.200
     1.411    23.715     0.200
     1.428    24.965     0.200
     1.634    26.254     0.200
     1.764    27.973     0.200
     1.904    30.922     0.200
     1.933    30.004     0.200
     1.944    30.676     0.200
     2.095    32.527     0.200
     2.106    32.789     0.200
     2.231    34.875     0.200
     2.358    37.105     0.200
     2.386    37.008     0.200
     2.572    39.570     0.200
     2.742    42.199     0.200
     2.773    42.352     0.200
     3.024    47.246     0.200
     3.073    47.281     0.200
     3.070    46.539     0.200
     3.116    47.629     0.200
     3.205    48.379     0.200
     3.453    51.676     0.200
     3.656    54.195     0.200
     4.449    67.527     0.200
     4.640    69.926     0.200
     4.984    74.477     0.200
     5.414    81.117     0.200
     5.671    84.738     0.200
     5.886    87.078     0.200
     6.200    89.586     0.200
     6.302    92.508     0.200
     6.857   104.625     0.200
     7.060   103.738     0.200
     7.126   103.477     0.200
     7.360   110.285     0.200
     7.437   109.027     0.200
     7.482   109.715     0.200
     7.764   112.727     0.200
     7.891   114.848     0.200
     7.967   118.125     0.200
     8.085   119.258     0.200
     8.260   119.027     0.200
     8.337   123.137     0.200
     8.429   123.477     0.200
     8.682   126.328     0.200
     8.847   129.695     0.200
     9.014   130.867     0.200
     9.703   142.367     0.200
     9.949   143.695     0.200
    10.195   147.000     0.200
    10.515   155.086     0.200
    10.683   158.195     0.200
    10.894   158.008     0.200
    11.365   167.516     0.200
    11.427   168.945     0.200
    11.509   167.266     0.200
    11.546   168.527     0.200
    11.564   167.227     0.200
    11.781   171.867     0.200
    11.881   172.586     0.200
    12.006   175.238     0.200
    12.075   176.738     0.200
    12.501   181.605     0.200
    12.578   180.945     0.200
    13.073   188.035     0.200
    13.885   200.148     0.200
    13.907   202.465     0.200
    14.915   211.258     0.200
    14.959   212.855     0.200
    15.062   214.695     0.200
    16.465   231.207     0.200
    18.151   250.598     0.200
    18.626   260.195     0.200
     0.911    15.363     0.200
     0.953    16.473     0.200
     1.009    16.914     0.200
     1.065    20.344     0.200
     1.067    17.629     0.200
     1.318    21.738     0.200
     1.349    23.875     0.200
     1.361    23.633     0.200
     1.400    23.590     0.200
     1.432    24.953     0.200
     1.617    25.828     0.200
     1.747    27.789     0.200
     1.934    30.086     0.200
     1.929    30.168     0.200
     1.929    30.324     0.200
     2.089    32.598     0.200
     2.079    32.426     0.200
     2.221    34.750     0.200
     2.756    41.996     0.200
     3.108    47.648     0.200
     3.654    54.273     0.200
     4.627    70.113     0.200
     5.404    80.945     0.200
     5.869    87.434     0.200
     6.199    89.746     0.200
     6.319    92.812     0.200
     6.285    92.613     0.200
     6.841   102.855     0.200
     6.875   102.051     0.200
     7.120   103.355     0.200
     7.758   114.398     0.200
    10.199   147.348     0.200
     0.805    15.281     0.200
     1.356    24.461     0.200
     1.370    24.441     0.200
     1.439    25.664     0.200
     1.926    30.922     0.200
     1.937    30.293     0.200
     5.577    86.902     0.200
     6.011    93.062     0.200
     6.881   103.418     0.200
     7.114   104.801     0.200
     7.351   112.742     0.200
     7.425   108.461     0.200
     7.381   108.402     0.200
     7.751   112.793     0.200
     8.413   122.473     0.200
     8.669   125.191     0.200
     8.887   129.391     0.200
     8.934   134.711     0.200
     9.768   139.582     0.200
     9.874   145.031     0.200
    10.190   147.793     0.200
    10.504   150.973     0.200
    10.673   158.664     0.200
    10.735   159.414     0.200
    10.879   161.004     0.200
    11.216   165.414     0.200
    11.471   168.293     0.200
    11.419   167.871     0.200
    11.419   167.754     0.200
    11.495   168.891     0.200
    11.535   166.891     0.200
    11.549   166.043     0.200
    11.766   172.832     0.200
    11.865   173.070     0.200
    11.991   174.754     0.200
    12.059   175.480     0.200
    12.277   176.711     0.200
    12.257   178.602     0.200
    12.247   179.941     0.200
    12.485   181.504     0.200
    12.562   183.004     0.200
    13.064   189.352     0.200
    13.065   190.531     0.200
    13.162   188.891     0.200
    13.422   194.211     0.200
    13.874   196.031     0.200
    14.776   212.211     0.200
    14.843   212.633     0.200
    14.901   212.531     0.200
    14.950   212.223     0.200
    15.050   214.691     0.200
    15.211   215.102     0.200
    15.452   216.723     0.200
    16.447   230.773     0.200
    18.140   251.434     0.200
    18.342   254.004     0.200
     0.975    16.109     0.200
     1.256    22.352     0.200
     1.256    22.000     0.200
     1.278    22.902     0.200
     1.353    24.102     0.200
     1.823    28.211     0.200
     2.034    31.211     0.200
     2.946    45.742     0.200
     3.231    49.449     0.200
     3.439    53.621     0.200
     3.746    54.750     0.200
     4.369    66.609     0.200
     4.645    69.883     0.200
     5.619    83.160     0.200
     6.217    91.801     0.200
     7.821   114.547     0.200
     8.602   128.547     0.200
    10.306   148.945     0.200
    11.525   169.051     0.200
     1.224    22.262     0.200
     1.282    23.082     0.200
     1.384    22.492     0.200
     1.427    23.555     0.200
     1.605    26.727     0.200
     1.631    26.211     0.200
     1.631    26.102     0.200
     1.809    28.539     0.200
     1.890    29.762     0.200
     2.041    32.293     0.200
     2.177    33.711     0.200
     2.177    33.891     0.200
     2.299    35.641     0.200
     2.521    38.746     0.200
     2.565    39.688     0.200
     2.577    39.805     0.200
     2.756    42.242     0.200
     2.789    42.434     0.200
     3.040    48.293     0.200
     3.663    57.082     0.200
     4.228    63.840     0.200
     4.265    64.711     0.200
     4.407    66.020     0.200
     4.628    70.371     0.200
     5.474    82.090     0.200
     5.724    85.191     0.200
     6.068    89.961     0.200
     6.404    93.660     0.200
     7.883   115.855     0.200
    10.464   152.457     0.200
    11.121   164.922     0.200
    11.438   170.031     0.200
     0.731    12.526     0.200
     1.305    22.486     0.200
     1.317    23.227     0.200
     1.394    24.356     0.200
     1.865    28.816     0.200
     1.986    30.137     0.200
     3.230    50.977     0.200
     4.387    65.597     0.200
     4.626    69.097     0.200
     5.419    80.177     0.200
     5.837    86.276     0.200
     6.193    91.066     0.200
     6.243    90.427     0.200
     6.816    99.257     0.200
     7.084   102.937     0.200
     7.309   106.827     0.200
     7.474   109.356     0.200
     7.934   115.267     0.200
     8.001   118.227     0.200
     8.069   117.097     0.200
     8.309   118.557     0.200
    10.256   148.467     0.200
     0.936    15.869     0.200
     0.936    16.007     0.200
     1.034    17.423     0.200
     1.070    17.945     0.200
     1.191    21.647     0.200
     1.197    21.657     0.200
     1.211    22.087     0.200
     1.331    21.838     0.200
     1.373    22.077     0.200
     1.464    23.906     0.200
     1.543    24.971     0.200
     1.593    25.729     0.200
     1.653    27.888     0.200
     1.824    29.729     0.200
     2.113    33.004     0.200
     2.190    34.139     0.200
     2.296    37.177     0.200
     2.413    39.397     0.200
     2.464    39.867     0.200
     2.476    39.147     0.200
     2.665    40.139     0.200
     2.665    40.018     0.200
     2.742    42.308     0.200
     3.086    48.087     0.200
     3.487    52.824     0.200
     3.641    54.820     0.200
     3.695    56.808     0.200
     3.866    58.457     0.200
     3.876    58.867     0.200
     4.290    63.178     0.200
     4.670    70.317     0.200
     5.470    81.127     0.200
     5.507    82.308     0.200
     5.635    83.907     0.200
     5.668    84.308     0.200
     6.160    92.127     0.200
     6.511    96.207     0.200
     6.527    96.768     0.200
     6.802    98.617     0.200
     7.470   109.447     0.200
     7.540   111.638     0.200
     7.564   110.147     0.200
     7.602   113.257     0.200
     7.739   113.587     0.200
     7.946   117.797     0.200
     8.058   118.497     0.200
     8.134   117.837     0.200
     8.920   127.817     0.200
    11.013   161.308     0.200
     0.562    10.309     0.200
     0.873    14.766     0.200
     0.873    14.559     0.200
     1.170    19.246     0.200
     1.197    21.777     0.200
     1.320    21.496     0.200
     1.311    22.461     0.200
     1.447    24.797     0.200
     1.590    25.527     0.200
     1.709    27.203     0.200
     1.723    27.578     0.200
     2.074    33.137     0.200
     2.288    35.164     0.200
     2.413    37.070     0.200
     2.420    37.723     0.200
     2.442    36.863     0.200
     2.442    37.027     0.200
     2.672    41.098     0.200
     2.722    41.590     0.200
     2.977    45.383     0.200
     2.971    45.148     0.200
     3.345    50.930     0.200
     3.951    58.949     0.200
     4.023    60.520     0.200
     4.096    59.750     0.200
     4.113    61.250     0.200
     4.643    70.898     0.200
     5.377    80.238     0.200
     5.557    83.289     0.200
     5.579    82.867     0.200
     5.723    84.609     0.200
     6.316    92.625     0.200
     6.621    95.957     0.200
     7.342   107.098     0.200
     7.429   108.258     0.200
     7.513   111.418     0.200
     8.019   117.043     0.200
     8.019   116.570     0.200
     8.725   124.488     0.200
    10.740   154.168     0.200
    10.864   158.617     0.200
    11.324   166.422     0.200
     1.046    17.766     0.200
     1.115    18.695     0.200
     1.363    22.367     0.200
     1.516    24.797     0.200
     1.530    24.914     0.200
     1.601    26.008     0.200
     1.619    28.070     0.200
     1.620    29.031     0.200
     1.620    27.719     0.200
     1.710    27.664     0.200
     1.869    30.449     0.200
     2.136    33.508     0.200
     2.225    34.785     0.200
     2.228    35.082     0.200
     2.331    36.652     0.200
     2.345    38.094     0.200
     2.441    38.000     0.200
     2.495    38.461     0.200
     2.614    39.738     0.200
     2.665    41.152     0.200
     2.781    42.609     0.200
     2.785    42.609     0.200
     2.888    44.270     0.200
     2.915    44.914     0.200
     3.538    53.570     0.200
     3.683    55.176     0.200
     3.743    55.930     0.200
     3.885    58.648     0.200
     3.917    58.719     0.200
     4.039    61.145     0.200
     4.243    62.371     0.200
     4.310    64.637     0.200
     4.530    67.777     0.200
     4.651    70.180     0.200
     4.751    71.879     0.200
     5.223    77.656     0.200
     5.282    79.172     0.200
     5.542    82.969     0.200
     5.607    83.980     0.200
     5.672    82.941     0.200
     6.124    90.195     0.200
     6.531    96.879     0.200
     6.558    96.590     0.200
     6.757    98.355     0.200
     7.521   110.590     0.200
     8.044   117.961     0.200
     8.096   117.844     0.200
     8.100   117.070     0.200
     8.873   127.555     0.200
    10.914   156.797     0.200
    11.240   163.570     0.200
     0.910    15.695     0.200
     0.910    15.586     0.200
     1.047    17.777     0.200
     1.059    17.906     0.200
     1.114    18.691     0.200
     1.197    21.695     0.200
     1.199    21.855     0.200
     1.363    22.410     0.200
     1.513    24.711     0.200
     1.533    24.852     0.200
     1.603    25.945     0.200
     1.619    27.617     0.200
     1.620    28.957     0.200
     1.620    27.617     0.200
     1.714    27.578     0.200
     1.868    30.387     0.200
     2.137    33.477     0.200
     2.155    33.957     0.200
     2.225    34.676     0.200
     2.226    34.938     0.200
     2.333    36.465     0.200
     2.341    37.879     0.200
     2.440    38.023     0.200
     2.499    38.512     0.200
     2.618    39.688     0.200
     2.669    41.129     0.200
     2.780    42.625     0.200
     2.786    42.648     0.200
     2.886    44.242     0.200
     3.102    46.809     0.200
     3.232    48.973     0.200
     3.536    53.434     0.200
     3.682    55.180     0.200
     3.741    55.922     0.200
     4.043    61.031     0.200
     4.194    62.434     0.200
     4.248    62.004     0.200
     4.310    64.785     0.200
     4.529    67.742     0.200
     4.654    70.148     0.200
     4.754    71.809     0.200
     5.227    77.703     0.200
     5.611    83.836     0.200
     5.694    84.133     0.200
     5.676    82.844     0.200
     6.123    90.141     0.200
     6.761    98.445     0.200
     8.096   117.789     0.200
     8.104   118.391     0.200
     8.877   127.484     0.200
     8.927   130.141     0.200
     9.637   139.844     0.200
     9.835   142.715     0.200
     9.839   142.227     0.200
    10.488   153.375     0.200
    10.568   154.320     0.200
    10.885   158.801     0.200
    10.918   156.574     0.200
    10.962   160.066     0.200
    10.978   160.562     0.200
    11.242   161.648     0.200
    11.223   161.312     0.200
    15.635   221.266     0.200
     1.121    20.680     0.200
     1.131    20.578     0.200
     1.254    22.688     0.200
     1.619    25.719     0.200
     2.162    33.629     0.200
     2.779    43.711     0.200
     2.987    48.277     0.200
     3.038    47.969     0.200
     3.239    51.059     0.200
     4.200    63.668     0.200
     4.254    63.699     0.200
     4.390    66.000     0.200
     4.595    69.230     0.200
     5.443    81.527     0.200
     5.483    81.348     0.200
     5.692    84.680     0.200
     6.041    88.711     0.200
     6.383    92.141     0.200
     6.694    98.789     0.200
     7.855   115.340     0.200
     8.431   125.539     0.200
    10.451   151.688     0.200
    11.406   168.938     0.200
     1.037    17.680     0.200
     1.080    18.426     0.200
     1.208    22.066     0.200
     1.339    22.246     0.200
     1.362    20.938     0.200
     1.475    24.477     0.200
     1.541    25.117     0.200
     1.595    25.984     0.200
     1.645    28.270     0.200
     1.645    28.160     0.200
     1.646    29.359     0.200
     1.646    28.328     0.200
     1.744    28.266     0.200
     2.118    33.465     0.200
     2.160    34.234     0.200
     2.189    34.754     0.200
     2.199    34.562     0.200
     2.290    36.531     0.200
     2.313    37.574     0.200
     2.307    37.641     0.200
     2.408    37.762     0.200
     2.425    40.160     0.200
     2.480    39.816     0.200
     2.476    39.598     0.200
     2.523    39.086     0.200
     2.654    40.402     0.200
     2.654    40.277     0.200
     2.687    41.543     0.200
     2.751    42.414     0.200
     2.764    42.625     0.200
     2.850    43.961     0.200
     2.918    45.156     0.200
     3.064    47.480     0.200
     3.098    48.129     0.200
     3.199    48.730     0.200
     3.247    49.383     0.200
     3.499    52.754     0.200
     3.651    54.965     0.200
     3.706    55.633     0.200
     3.871    58.590     0.200
     3.885    58.379     0.200
     3.887    58.488     0.200
     4.062    61.184     0.200
     4.158    61.984     0.200
     4.287    64.699     0.200
     4.280    62.859     0.200
     4.501    67.555     0.200
     4.666    70.270     0.200
     4.666    69.637     0.200
     4.756    71.742     0.200
     5.249    78.141     0.200
     5.277    79.117     0.200
     5.516    81.777     0.200
     5.629    83.957     0.200
     5.629    84.508     0.200
     5.674    84.324     0.200
     5.674    84.188     0.200
     5.711    83.676     0.200
     6.094    90.152     0.200
     6.171    89.438     0.200
     6.522    95.949     0.200
     6.524    94.188     0.200
     6.529    95.168     0.200
     6.792    99.027     0.200
     6.792    98.867     0.200
     7.345   105.637     0.200
     7.462   109.059     0.200
     7.537   112.273     0.200
     7.537   111.148     0.200
     7.556   110.109     0.200
     7.603   108.949     0.200
     7.586   111.012     0.200
     7.739   114.238     0.200
     7.859   114.250     0.200
     7.880   112.988     0.200
     7.898   114.598     0.200
     8.056   118.207     0.200
     8.078   118.062     0.200
     8.078   117.059     0.200
     8.127   118.188     0.200
     8.127   117.160     0.200
     8.667   124.738     0.200
     8.910   128.453     0.200
     8.910   128.000     0.200
     8.940   130.152     0.200
     9.148   132.359     0.200
     9.485   137.910     0.200
     9.551   141.418     0.200
     9.639   140.578     0.200
     9.639   139.000     0.200
     9.848   143.223     0.200
     9.853   142.316     0.200
    10.078   146.555     0.200
    10.161   148.105     0.200
    10.229   149.352     0.200
    10.358   149.891     0.200
    10.385   151.531     0.200
    10.498   153.543     0.200
    10.574   153.898     0.200
    10.706   155.633     0.200
    10.893   158.605     0.200
    10.936   160.117     0.200
    10.969   157.449     0.200
    10.954   157.207     0.200
    11.006   160.203     0.200
    11.005   159.172     0.200
    11.005   158.680     0.200
    11.064   160.121     0.200
    11.208   161.992     0.200
    11.236   162.238     0.200
    11.260   162.758     0.200
    11.254   162.148     0.200
    11.983   170.680     0.200
    12.390   175.457     0.200
    12.440   177.578     0.200
    13.395   195.488     0.200
    13.841   198.000     0.200
    14.367   204.867     0.200
    14.347   203.848     0.200
    14.668   209.289     0.200
    14.690   206.750     0.200
    14.792   208.848     0.200
    14.892   210.129     0.200
    15.110   213.340     0.200
    15.190   214.008     0.200
    15.244   213.238     0.200
    15.537   219.578     0.200
    15.553   219.598     0.200
    15.613   221.863     0.200
    15.613   222.020     0.200
    16.874   235.258     0.200
    17.304   240.660     0.200
    18.059   250.539     0.200
    18.631   258.879     0.200
    18.669   259.598     0.200
     1.062    20.055     0.200
     1.174    22.104     0.200
     1.223    22.675     0.200
     1.269    23.104     0.200
     1.325    23.544     0.200
     1.543    24.865     0.200
     2.270    34.885     0.200
     2.768    44.084     0.200
     2.894    44.084     0.200
     2.942    46.035     0.200
     3.566    55.965     0.200
     3.953    58.665     0.200
     4.174    62.665     0.200
     4.185    63.485     0.200
     4.328    64.755     0.200
     4.657    71.055     0.200
     4.666    70.524     0.200
     5.496    82.415     0.200
     5.523    82.935     0.200
     6.488    94.604     0.200
     6.715    97.415     0.200
     7.520   111.825     0.200
     7.647   111.655     0.200
     7.873   116.095     0.200
     7.947   116.689     0.200
     7.947   116.555     0.200
     7.998   117.845     0.200
     8.576   123.965     0.200
    10.560   153.265     0.200
     0.805    13.988     0.200
     0.809    13.758     0.200
     0.896    14.816     0.200
     1.400    22.805     0.200
     1.407    22.570     0.200
     1.635    25.750     0.200
     1.647    27.160     0.200
     1.669    26.117     0.200
     1.669    26.465     0.200
     1.840    28.727     0.200
     1.907    29.781     0.200
     2.083    32.551     0.200
     2.137    32.816     0.200
     2.269    35.117     0.200
     2.277    35.250     0.200
     2.421    37.758     0.200
     2.546    38.793     0.200
     2.563    39.262     0.200
     2.713    41.121     0.200
     2.797    42.848     0.200
     2.826    43.988     0.200
     2.830    43.309     0.200
     2.859    43.883     0.200
     3.032    47.918     0.200
     3.079    46.422     0.200
     3.219    48.238     0.200
     3.290    50.316     0.200
     3.453    52.039     0.200
     3.705    56.859     0.200
     3.830    56.117     0.200
     3.891    58.566     0.200
     4.107    61.543     0.200
     4.208    62.027     0.200
     4.247    63.168     0.200
     4.303    64.219     0.200
     4.441    65.316     0.200
     4.617    69.238     0.200
     4.617    69.684     0.200
     4.752    70.918     0.200
     4.857    72.988     0.200
     4.959    74.215     0.200
     5.024    74.383     0.200
     5.202    76.277     0.200
     5.305    81.789     0.200
     5.454    81.078     0.200
     6.020    91.020     0.200
     6.090    89.578     0.200
     6.090    89.180     0.200
     6.368    92.418     0.200
     6.368    92.758     0.200
     6.732   100.438     0.200
     6.750    99.418     0.200
     7.093   104.578     0.200
     7.114   105.816     0.200
     7.165   104.656     0.200
     7.240   105.398     0.200
     7.263   105.797     0.200
     7.475   110.277     0.200
     7.475   109.844     0.200
     7.549   109.719     0.200
     7.779   116.047     0.200
     7.857   113.293     0.200
     7.857   114.117     0.200
     7.857   113.977     0.200
     7.873   115.316     0.200
     8.121   120.148     0.200
     8.180   122.520     0.200
     8.299   119.629     0.200
     8.449   120.770     0.200
     8.449   121.145     0.200
     8.479   123.367     0.200
     8.479   123.219     0.200
     8.854   128.840     0.200
     8.850   129.719     0.200
     8.894   130.199     0.200
     9.235   136.688     0.200
     9.386   137.109     0.200
     9.718   140.180     0.200
     9.731   140.988     0.200
     9.731   140.168     0.200
     9.757   140.637     0.200
     9.806   144.316     0.200
    10.208   149.387     0.200
    10.423   150.168     0.200
    10.505   155.219     0.200
    10.597   154.152     0.200
    10.636   153.867     0.200
    10.652   153.699     0.200
    10.652   154.699     0.200
    10.776   157.117     0.200
    10.817   157.605     0.200
    10.873   158.117     0.200
    10.873   157.898     0.200
    11.013   160.707     0.200
    11.154   164.777     0.200
    11.158   163.684     0.200
    11.158   164.418     0.200
    11.316   167.309     0.200
    11.356   168.488     0.200
    11.442   166.188     0.200
    11.443   165.230     0.200
    11.637   169.047     0.200
    11.735   170.746     0.200
    11.755   171.219     0.200
    11.858   172.547     0.200
    11.932   172.246     0.200
    11.990   175.008     0.200
    12.027   173.188     0.200
    12.318   177.840     0.200
    12.354   179.297     0.200
    12.500   179.438     0.200
    12.704   185.340     0.200
    12.920   187.207     0.200
    13.238   191.168     0.200
    13.262   192.906     0.200
    13.327   193.988     0.200
    13.367   192.219     0.200
    13.526   196.867     0.200
    13.732   196.656     0.200
    14.014   199.117     0.200
    14.494   206.539     0.200
    14.730   209.148     0.200
    14.780   209.520     0.200
    15.038   214.816     0.200
    15.131   214.578     0.200
    15.260   215.879     0.200
    15.589   220.816     0.200
    16.573   232.367     0.200
    16.837   236.418     0.200
    18.622   258.578     0.200
    20.961   285.617     0.200
     1.037    19.410     0.200
     1.037    19.613     0.200
     1.041    17.512     0.200
     1.152    21.340     0.200
     1.511    25.711     0.200
     1.913    29.703     0.200
     1.970    31.082     0.200
     3.335    51.750     0.200
     3.575    55.543     0.200
     3.638    53.293     0.200
     4.468    67.750     0.200
     4.642    70.230     0.200
     4.730    70.223     0.200
     5.409    80.980     0.200
     6.183    89.672     0.200
     6.322    93.410     0.200
     6.887   102.562     0.200
     7.426   107.930     0.200
     7.482   110.211     0.200
     7.754   113.625     0.200
     7.754   113.293     0.200
    10.172   147.453     0.200
     0.955    16.549     0.200
     1.030    17.758     0.200
     1.228    22.268     0.200
     1.413    24.068     0.200
     1.687    29.309     0.200
     1.688    29.688     0.200
     2.370    40.639     0.200
     2.706    42.129     0.200
     2.704    40.828     0.200
     3.043    49.457     0.200
     3.843    58.648     0.200
     4.325    64.049     0.200
     4.678    70.598     0.200
     5.651    84.578     0.200
     6.048    88.646     0.200
     6.517    99.748     0.200
     6.537   100.908     0.200
     6.834    99.527     0.200
     7.494   109.318     0.200
     7.548   112.537     0.200
     7.733   114.479     0.200
     7.892   115.059     0.200
     8.062   119.379     0.200
     8.156   119.043     0.200
     8.955   129.158     0.200
    11.003   158.547     0.200
    11.041   159.848     0.200
    11.223   165.537     0.200
     0.949    16.373     0.200
     1.035    17.604     0.200
     1.058    17.904     0.200
     1.058    18.041     0.200
     1.184    21.523     0.200
     1.192    21.613     0.200
     1.211    22.043     0.200
     1.325    21.920     0.200
     1.448    24.311     0.200
     1.552    25.236     0.200
     1.661    28.414     0.200
     1.661    28.613     0.200
     1.662    28.533     0.200
     1.811    29.758     0.200
     2.109    33.229     0.200
     2.169    34.342     0.200
     2.279    37.312     0.200
     2.683    40.713     0.200
     2.733    42.334     0.200
     3.070    48.645     0.200
     3.631    54.543     0.200
     3.681    55.484     0.200
     3.863    58.324     0.200
     3.865    58.113     0.200
     4.274    64.168     0.200
     4.308    63.533     0.200
     4.680    70.404     0.200
     4.680    70.580     0.200
     5.648    84.453     0.200
     6.497    95.314     0.200
     6.551   100.094     0.200
     6.819    99.373     0.200
     7.485   109.523     0.200
     7.550   111.953     0.200
     7.550   112.143     0.200
     7.609   111.023     0.200
     8.149   118.834     0.200
     8.937   128.244     0.200
     8.937   128.516     0.200
     9.869   142.693     0.200
     9.869   142.943     0.200
    11.029   159.623     0.200
     1.034    17.664     0.200
     1.103    18.539     0.200
     1.103    18.719     0.200
     1.208    22.078     0.200
     1.209    22.039     0.200
     1.211    22.211     0.200
     1.350    22.344     0.200
     1.340    20.992     0.200
     1.523    24.797     0.200
     1.506    25.000     0.200
     1.591    25.977     0.200
     1.631    27.906     0.200
     1.632    27.938     0.200
     1.632    29.062     0.200
     1.857    30.453     0.200
     2.124    33.617     0.200
     2.144    33.984     0.200
     2.212    34.711     0.200
     2.218    35.594     0.200
     2.341    38.242     0.200
     2.455    40.750     0.200
     2.480    39.859     0.200
     2.506    42.258     0.200
     2.620    39.867     0.200
     2.620    39.977     0.200
     2.768    42.531     0.200
     2.773    42.766     0.200
     2.877    44.320     0.200
     3.128    47.852     0.200
     3.670    55.273     0.200
     3.731    56.047     0.200
     3.905    58.578     0.200
     4.247    62.922     0.200
     4.297    65.594     0.200
     4.297    65.359     0.200
     4.645    70.508     0.200
     4.645    69.398     0.200
     4.727    72.250     0.200
     4.987    75.328     0.200
     5.530    82.148     0.200
     5.603    84.062     0.200
     5.603    83.438     0.200
     5.681    83.828     0.200
     5.681    84.570     0.200
     6.111    91.617     0.200
     6.111    91.023     0.200
     6.201    94.828     0.200
     6.521    97.094     0.200
     6.541    97.883     0.200
     6.545   100.594     0.200
     6.546    95.617     0.200
     6.759    98.094     0.200
     6.759    98.422     0.200
     7.432   109.070     0.200
     7.516   110.688     0.200
     7.516   112.133     0.200
     7.526   109.711     0.200
     7.555   110.789     0.200
     7.594   112.688     0.200
     7.688   116.391     0.200
     7.728   114.000     0.200
     7.807   113.578     0.200
     7.829   114.070     0.200
     7.843   115.156     0.200
     7.927   116.461     0.200
     7.960   118.188     0.200
     8.037   116.789     0.200
     8.072   118.102     0.200
     8.083   118.227     0.200
     8.098   117.477     0.200
     8.098   118.594     0.200
     8.543   126.562     0.200
     8.661   124.977     0.200
     8.877   127.844     0.200
     8.877   127.547     0.200
     8.918   130.789     0.200
     8.918   129.805     0.200
     9.143   135.344     0.200
     9.417   135.398     0.200
     9.584   137.867     0.200
     9.625   138.281     0.200
     9.664   141.211     0.200
     9.671   140.078     0.200
     9.826   143.125     0.200
     9.830   142.594     0.200
     9.830   142.164     0.200
     9.795   144.594     0.200
    10.016   147.523     0.200
    10.061   146.883     0.200
    10.148   147.875     0.200
    10.208   149.430     0.200
    10.401   152.672     0.200
    10.478   153.430     0.200
    10.558   154.227     0.200
    10.600   155.680     0.200
    10.685   155.719     0.200
    10.685   155.594     0.200
    10.740   156.781     0.200
    10.874   158.758     0.200
    10.874   159.203     0.200
    10.941   160.648     0.200
    10.919   157.250     0.200
    10.920   157.477     0.200
    10.974   159.250     0.200
    10.974   159.609     0.200
    11.175   159.148     0.200
    11.230   163.328     0.200
    11.221   160.930     0.200
    11.334   164.602     0.200
    11.372   165.641     0.200
    11.583   170.609     0.200
    11.600   166.609     0.200
    11.671   169.992     0.200
    11.759   169.977     0.200
    11.770   175.273     0.200
    11.776   169.070     0.200
    11.848   173.750     0.200
    11.870   170.539     0.200
    11.952   172.539     0.200
    11.952   173.047     0.200
    12.018   172.508     0.200
    12.083   175.203     0.200
    12.080   174.359     0.200
    12.189   177.328     0.200
    12.233   180.820     0.200
    12.269   179.648     0.200
    12.279   177.469     0.200
    12.333   178.094     0.200
    12.366   180.852     0.200
    12.378   178.883     0.200
    12.378   177.883     0.200
    12.406   181.312     0.200
    12.534   181.086     0.200
    12.568   183.289     0.200
    12.574   180.953     0.200
    12.619   183.812     0.200
    12.600   181.445     0.200
    12.722   182.148     0.200
    12.826   188.297     0.200
    12.926   189.594     0.200
    12.977   185.859     0.200
    12.998   189.273     0.200
    13.058   188.000     0.200
    13.085   189.133     0.200
    13.109   191.719     0.200
    13.258   190.828     0.200
    13.324   190.445     0.200
    13.374   192.547     0.200
    13.384   195.383     0.200
    13.397   195.359     0.200
    13.436   194.922     0.200
    13.443   193.125     0.200
    13.534   193.516     0.200
    13.574   198.211     0.200
    13.613   195.188     0.200
    13.613   194.977     0.200
    13.681   196.047     0.200
    13.686   195.312     0.200
    13.714   195.594     0.200
    13.730   197.062     0.200
    13.740   196.867     0.200
    13.805   198.273     0.200
    13.807   198.242     0.200
    13.883   198.859     0.200
    13.955   202.648     0.200
    13.966   199.828     0.200
    14.014   203.031     0.200
    14.073   201.727     0.200
    14.226   202.305     0.200
    14.315   204.086     0.200
    14.300   203.773     0.200
    14.316   203.211     0.200
    14.312   203.680     0.200
    14.319   204.734     0.200
    14.330   204.352     0.200
    14.371   206.062     0.200
    14.346   204.625     0.200
    14.418   205.984     0.200
    14.537   209.219     0.200
    14.602   208.078     0.200
    14.672   210.773     0.200
    14.677   209.008     0.200
    14.671   208.578     0.200
    14.728   211.312     0.200
    14.809   212.523     0.200
    14.932   211.562     0.200
    14.945   211.711     0.200
    14.958   212.172     0.200
    15.027   213.633     0.200
    15.042   214.398     0.200
    15.027   213.211     0.200
    15.030   213.797     0.200
    15.048   213.797     0.200
    15.063   213.633     0.200
    15.090   214.367     0.200
    15.140   214.344     0.200
    15.177   215.969     0.200
    15.258   217.367     0.200
    15.443   219.250     0.200
    15.443   219.023     0.200
    15.497   219.695     0.200
    15.509   219.188     0.200
    15.509   219.562     0.200
    15.520   219.953     0.200
    15.520   220.211     0.200
    15.622   222.148     0.200
    15.794   223.094     0.200
    15.812   223.891     0.200
    15.905   225.438     0.200
    15.905   225.227     0.200
    16.015   225.250     0.200
    16.028   226.453     0.200
    16.396   231.117     0.200
    16.439   231.844     0.200
    16.435   230.578     0.200
    16.811   236.250     0.200
    16.845   236.609     0.200
    17.089   238.594     0.200
    17.831   247.875     0.200
    18.536   257.992     0.200
    18.580   257.914     0.200
    18.598   258.102     0.200
    18.600   258.211     0.200
    18.649   259.531     0.200
    18.649   258.711     0.200
    18.842   262.102     0.200
    18.931   262.758     0.200
    19.228   266.016     0.200
    19.411   267.773     0.200
    19.506   269.859     0.200
    19.506   269.430     0.200
    19.594   269.984     0.200
    19.598   270.047     0.200
    19.952   273.430     0.200
    19.980   274.492     0.200
    20.064   275.148     0.200
    20.151   279.156     0.200
    20.450   278.992     0.200
    20.629   280.922     0.200
     1.053    17.961     0.200
     1.113    18.742     0.200
     1.113    18.930     0.200
     1.330    21.969     0.200
     1.365    22.648     0.200
     1.509    25.086     0.200
     1.542    25.180     0.200
     1.610    26.273     0.200
     1.616    27.820     0.200
     1.618    27.977     0.200
     1.618    28.727     0.200
     1.867    30.648     0.200
     2.141    33.750     0.200
     2.164    34.320     0.200
     2.223    35.312     0.200
     2.227    34.953     0.200
     2.340    36.711     0.200
     2.334    38.141     0.200
     2.440    38.242     0.200
     2.499    39.773     0.200
     2.509    41.953     0.200
     2.625    39.844     0.200
     2.625    40.008     0.200
     2.781    42.648     0.200
     2.781    42.828     0.200
     2.884    44.477     0.200
     3.274    49.930     0.200
     3.532    53.781     0.200
     3.682    55.359     0.200
     3.739    56.180     0.200
     3.915    59.055     0.200
     3.916    58.312     0.200
     4.191    63.578     0.200
     4.256    62.273     0.200
     4.313    64.898     0.200
     4.663    70.477     0.200
     5.544    82.250     0.200
     5.620    84.039     0.200
     5.698    83.430     0.200
     6.124    90.570     0.200
     6.205    92.094     0.200
     6.540    97.398     0.200
     6.555    95.344     0.200
     6.556   100.227     0.200
     6.561    99.359     0.200
     6.770    98.492     0.200
     6.770    98.797     0.200
     7.447   108.570     0.200
     7.534   111.477     0.200
     7.539   109.930     0.200
     7.614   114.281     0.200
     7.747   114.758     0.200
     7.843   113.938     0.200
     7.858   115.344     0.200
     7.914   118.891     0.200
     7.946   117.070     0.200
     8.056   119.547     0.200
     8.101   119.023     0.200
     8.113   117.969     0.200
     8.562   127.359     0.200
     8.680   127.961     0.200
     8.886   127.633     0.200
     8.886   128.133     0.200
     9.435   137.531     0.200
     9.593   140.789     0.200
     9.645   141.422     0.200
     9.682   139.969     0.200
     9.683   142.094     0.200
     9.786   143.938     0.200
     9.844   143.867     0.200
     9.848   142.703     0.200
     9.848   143.164     0.200
    10.030   149.320     0.200
    10.053   146.102     0.200
    10.085   146.453     0.200
    10.610   156.234     0.200
    10.756   155.742     0.200
    10.893   158.867     0.200
    10.925   157.344     0.200
    10.958   160.461     0.200
    10.987   158.859     0.200
    11.185   160.383     0.200
    11.232   160.695     0.200
    11.249   163.547     0.200
    11.391   167.523     0.200
    11.419   166.633     0.200
    11.445   166.570     0.200
    11.453   167.062     0.200
    11.483   168.047     0.200
    11.510   168.453     0.200
    11.690   170.828     0.200
    11.688   170.836     0.200
    11.778   172.062     0.200
    11.863   172.016     0.200
    11.867   174.383     0.200
    11.877   170.438     0.200
    11.966   171.133     0.200
    12.026   172.133     0.200
    12.052   174.070     0.200
    12.096   175.180     0.200
    12.102   177.398     0.200
    12.207   176.047     0.200
    12.233   178.977     0.200
    12.298   177.805     0.200
    12.296   181.141     0.200
    12.345   177.922     0.200
    12.384   181.828     0.200
    12.397   180.023     0.200
    12.425   181.883     0.200
    12.587   180.672     0.200
    12.608   180.875     0.200
    12.716   185.883     0.200
    12.739   182.617     0.200
    12.944   189.023     0.200
    12.997   187.680     0.200
    13.071   188.266     0.200
    13.094   188.758     0.200
    13.266   189.703     0.200
    13.302   192.281     0.200
    13.415   194.414     0.200
    13.587   198.203     0.200
    13.624   193.992     0.200
    13.690   194.938     0.200
    13.726   194.172     0.200
    13.739   196.000     0.200
    13.813   198.398     0.200
    13.816   195.883     0.200
    13.897   199.422     0.200
    13.960   199.391     0.200
    13.980   199.266     0.200
    14.029   203.188     0.200
    14.311   203.539     0.200
    14.324   203.422     0.200
    14.330   202.297     0.200
    14.389   207.367     0.200
    14.689   210.742     0.200
    14.734   211.625     0.200
    14.944   212.734     0.200
    14.956   212.656     0.200
    14.968   213.156     0.200
    15.036   213.922     0.200
    15.063   213.953     0.200
    15.103   215.828     0.200
    15.391   218.938     0.200
    15.524   218.688     0.200
    15.660   222.547     0.200
    15.829   225.031     0.200
    15.888   225.047     0.200
    15.924   223.914     0.200
    17.280   239.047     0.200
    18.522   258.117     0.200
    18.556   257.680     0.200
    18.599   258.070     0.200
    18.614   258.258     0.200
    18.668   259.320     0.200
    19.247   266.539     0.200
    19.526   270.164     0.200
    20.083   276.453     0.200
    20.470   280.508     0.200
     1.052    17.898     0.200
     1.106    18.676     0.200
     1.187    21.436     0.200
     1.194    21.936     0.200
     1.337    21.596     0.200
     1.361    22.488     0.200
     1.500    24.864     0.200
     1.544    25.109     0.200
     1.609    26.412     0.200
     1.622    27.936     0.200
     1.623    27.815     0.200
     1.623    28.936     0.200
     1.730    27.889     0.200
     2.450    40.405     0.200
     2.514    38.797     0.200
     2.634    39.855     0.200
     2.634    40.072     0.200
     2.775    42.735     0.200
     2.926    45.117     0.200
     3.123    48.665     0.200
     3.910    58.905     0.200
     4.057    61.508     0.200
     4.263    63.056     0.200
     4.308    66.575     0.200
     4.666    70.775     0.200
     4.666    70.522     0.200
     5.242    78.047     0.200
     5.625    84.466     0.200
     5.625    83.992     0.200
     6.118    89.820     0.200
     6.540    96.665     0.200
     6.547    96.665     0.200
     6.549    95.806     0.200
     6.560    96.315     0.200
     6.777    98.785     0.200
     7.453   109.096     0.200
     7.537   111.436     0.200
     7.537   111.998     0.200
     7.546   110.275     0.200
     7.748   114.386     0.200
     7.912   114.966     0.200
     8.059   118.065     0.200
     8.119   118.366     0.200
     8.119   117.815     0.200
     8.893   128.355     0.200
     8.893   128.228     0.200
     8.940   131.176     0.200
     9.686   142.655     0.200
    10.934   157.364     0.200
    10.993   156.955     0.200
    11.248   164.063     0.200
     1.057    17.875     0.200
     1.189    21.686     0.200
     1.197    21.744     0.200
     1.215    22.215     0.200
     1.386    22.004     0.200
     1.664    28.484     0.200
     1.665    29.686     0.200
     2.680    40.346     0.200
     3.070    50.664     0.200
     3.863    58.115     0.200
     4.304    63.404     0.200
     6.526    99.695     0.200
     6.546    99.875     0.200
     7.545   112.254     0.200
     8.062   119.176     0.200
     9.689   142.244     0.200
     1.310    23.627     0.200
     1.401    23.041     0.200
     1.473    23.863     0.200
     1.683    26.873     0.200
     1.698    28.088     0.200
     1.736    27.598     0.200
     1.736    27.750     0.200
     1.909    30.760     0.200
     1.969    31.141     0.200
     2.104    32.627     0.200
     2.104    32.859     0.200
     2.145    34.025     0.200
     2.286    35.961     0.200
     2.315    36.383     0.200
     2.488    39.824     0.200
     2.612    40.219     0.200
     2.632    40.791     0.200
     2.861    44.455     0.200
     2.874    44.242     0.200
     2.888    45.117     0.200
     2.910    45.023     0.200
     3.128    48.449     0.200
     3.286    49.893     0.200
     3.359    52.258     0.200
     3.519    53.934     0.200
     3.713    56.854     0.200
     3.806    56.117     0.200
     3.906    59.109     0.200
     4.081    61.775     0.200
     4.310    64.967     0.200
     4.644    70.646     0.200
     5.466    81.828     0.200
     6.088    92.457     0.200
     6.154    90.236     0.200
     6.347    92.258     0.200
     6.703    99.422     0.200
     6.781   102.896     0.200
     6.800   102.928     0.200
     7.161   104.697     0.200
     7.234   105.527     0.200
     7.499   111.848     0.200
     7.856   114.848     0.200
     7.916   116.828     0.200
     8.421   121.037     0.200
     9.704   142.518     0.200
     9.748   141.668     0.200
    10.382   150.381     0.200
    10.640   154.787     0.200
    11.226   164.164     0.200
    11.464   160.838     0.200
    11.492   170.129     0.200
    15.386   217.447     0.200
    15.561   218.566     0.200
     1.244    22.609     0.200
     1.283    22.098     0.200
     1.312    23.520     0.200
     1.399    23.129     0.200
     1.474    23.936     0.200
     1.683    26.982     0.200
     1.700    28.287     0.200
     1.738    27.783     0.200
     1.738    27.885     0.200
     1.970    31.080     0.200
     2.102    32.699     0.200
     2.147    33.992     0.200
     2.285    35.893     0.200
     2.613    40.211     0.200
     2.876    44.289     0.200
     2.889    45.229     0.200
     2.912    44.914     0.200
     3.361    51.578     0.200
     3.905    59.438     0.200
     4.311    65.318     0.200
     4.643    70.799     0.200
     4.643    70.438     0.200
     4.898    74.170     0.200
     5.030    74.986     0.200
     5.165    75.920     0.200
     5.465    81.398     0.200
     5.465    81.730     0.200
     6.345    92.498     0.200
     6.345    92.260     0.200
     6.704   100.051     0.200
     6.781   103.098     0.200
     6.800   102.648     0.200
     7.232   105.619     0.200
     7.855   114.359     0.200
     7.855   114.178     0.200
     8.082   118.898     0.200
     8.419   120.838     0.200
     8.419   121.301     0.200
    10.380   150.309     0.200
    11.228   164.938     0.200
    11.492   168.787     0.200
     1.025    17.007     0.200
     1.062    17.936     0.200
     1.076    18.327     0.200
     1.080    18.077     0.200
     1.109    18.427     0.200
     1.109    18.574     0.200
     1.127    19.207     0.200
     1.202    20.327     0.200
     1.175    21.557     0.200
     1.177    21.567     0.200
     1.183    21.837     0.200
     1.368    22.387     0.200
     1.410    23.117     0.200
     1.418    23.337     0.200
     1.457    23.907     0.200
     1.477    24.047     0.200
     1.499    24.588     0.200
     1.556    25.307     0.200
     1.556    25.236     0.200
     1.619    26.227     0.200
     1.615    27.307     0.200
     1.617    27.297     0.200
     1.617    26.907     0.200
     1.739    28.006     0.200
     1.801    29.097     0.200
     1.812    29.457     0.200
     1.862    30.209     0.200
     2.029    32.317     0.200
     2.146    33.617     0.200
     2.177    34.193     0.200
     2.215    34.684     0.200
     2.215    35.067     0.200
     2.228    34.686     0.200
     2.306    37.757     0.200
     2.307    36.140     0.200
     2.318    36.452     0.200
     2.350    36.946     0.200
     2.371    38.477     0.200
     2.437    37.659     0.200
     2.448    37.857     0.200
     2.479    39.117     0.200
     2.498    40.157     0.200
     2.506    39.697     0.200
     2.525    38.989     0.200
     2.706    41.707     0.200
     2.640    40.028     0.200
     2.694    41.583     0.200
     2.780    42.457     0.200
     2.793    42.677     0.200
     2.877    44.050     0.200
     2.907    46.277     0.200
     2.938    45.326     0.200
     3.084    47.051     0.200
     3.228    48.786     0.200
     3.263    49.277     0.200
     3.276    49.443     0.200
     3.440    51.827     0.200
     3.467    53.136     0.200
     3.495    52.367     0.200
     3.524    53.347     0.200
     3.524    52.995     0.200
     3.680    54.935     0.200
     3.713    57.210     0.200
     3.733    55.897     0.200
     3.898    58.797     0.200
     3.914    58.627     0.200
     3.916    59.179     0.200
     4.069    61.051     0.200
     4.184    62.001     0.200
     4.226    62.929     0.200
     4.316    64.777     0.200
     4.272    62.497     0.200
     4.375    65.094     0.200
     4.530    67.486     0.200
     4.678    70.187     0.200
     4.765    71.387     0.200
     4.775    71.663     0.200
     4.830    71.680     0.200
     5.018    75.557     0.200
     5.204    78.217     0.200
     5.253    77.996     0.200
     5.497    82.097     0.200
     5.509    83.217     0.200
     5.545    82.227     0.200
     5.636    84.437     0.200
     5.636    84.165     0.200
     5.703    84.467     0.200
     5.703    83.869     0.200
     5.698    83.132     0.200
     5.924    88.097     0.200
     6.044    91.027     0.200
     6.123    89.797     0.200
     6.123    90.227     0.200
     6.196    94.057     0.200
     6.549    95.997     0.200
     6.551    97.577     0.200
     6.572    98.787     0.200
     6.667    98.847     0.200
     6.786    98.794     0.200
     7.339   107.277     0.200
     7.463   108.737     0.200
     7.549   111.867     0.200
     7.549   111.201     0.200
     7.556   109.927     0.200
     7.585   110.626     0.200
     7.686   112.487     0.200
     7.722   116.347     0.200
     7.759   114.577     0.200
     7.860   115.257     0.200
     7.837   113.757     0.200
     7.859   114.027     0.200
     7.960   116.937     0.200
     7.993   117.997     0.200
     8.071   118.877     0.200
     8.106   119.302     0.200
     8.106   118.067     0.200
     8.101   121.767     0.200
     8.130   117.904     0.200
     8.282   122.757     0.200
     8.342   124.147     0.200
     8.570   128.037     0.200
     8.901   127.917     0.200
     8.901   127.814     0.200
     8.952   131.097     0.200
     8.952   130.400     0.200
     9.443   139.607     0.200
     9.496   137.233     0.200
     9.575   141.827     0.200
     9.658   140.777     0.200
     9.658   139.555     0.200
     9.697   141.857     0.200
     9.859   142.594     0.200
     9.863   142.777     0.200
    10.397   152.997     0.200
    10.392   150.877     0.200
    10.392   149.956     0.200
    10.512   151.978     0.200
    10.606   155.260     0.200
    10.591   152.834     0.200
    10.719   155.277     0.200
    10.719   154.529     0.200
    10.908   158.887     0.200
    10.908   157.893     0.200
    10.964   161.117     0.200
    10.939   157.227     0.200
    10.940   157.027     0.200
    10.940   157.027     0.200
    10.985   159.309     0.200
    11.003   158.497     0.200
    11.201   160.432     0.200
    11.259   163.527     0.200
    11.259   162.687     0.200
    11.259   162.689     0.200
    11.248   161.467     0.200
    11.308   162.300     0.200
    11.400   167.517     0.200
    11.452   164.934     0.200
    11.425   167.847     0.200
    11.425   166.669     0.200
    11.436   165.302     0.200
    11.521   165.615     0.200
    11.632   167.486     0.200
    11.699   171.127     0.200
    11.682   167.752     0.200
    11.787   171.577     0.200
    11.769   169.001     0.200
    11.793   166.149     0.200
    11.801   167.128     0.200
    11.823   168.138     0.200
    11.876   174.017     0.200
    11.874   168.266     0.200
    11.878   169.050     0.200
    11.878   169.139     0.200
    11.913   172.018     0.200
    11.923   170.601     0.200
    11.983   169.886     0.200
    12.019   173.798     0.200
    12.040   171.667     0.200
    12.042   173.008     0.200
    12.113   174.094     0.200
    12.252   180.087     0.200
    12.222   176.056     0.200
    12.278   177.714     0.200
    12.309   176.743     0.200
    12.391   182.437     0.200
    12.362   176.658     0.200
    12.410   178.117     0.200
    12.410   176.589     0.200
    12.452   178.596     0.200
    12.424   177.323     0.200
    12.494   178.092     0.200
    12.559   180.153     0.200
    12.530   178.493     0.200
    12.557   180.293     0.200
    12.559   182.062     0.200
    12.623   179.966     0.200
    12.801   182.455     0.200
    12.867   187.927     0.200
    12.920   182.545     0.200
    13.008   184.257     0.200
    13.027   185.527     0.200
    13.091   186.450     0.200
    13.109   187.550     0.200
    13.142   186.886     0.200
    13.142   186.924     0.200
    13.276   188.928     0.200
    13.312   189.426     0.200
    13.282   189.945     0.200
    13.312   188.940     0.200
    13.371   189.696     0.200
    13.354   189.100     0.200
    13.409   192.252     0.200
    13.422   195.207     0.200
    13.407   191.203     0.200
    13.434   190.166     0.200
    13.567   192.886     0.200
    13.593   195.339     0.200
    13.640   195.747     0.200
    13.640   194.129     0.200
    13.729   196.602     0.200
    13.706   194.608     0.200
    13.713   193.145     0.200
    13.743   195.478     0.200
    13.755   194.805     0.200
    13.829   198.909     0.200
    13.881   198.702     0.200
    13.832   198.747     0.200
    13.832   196.895     0.200
    13.973   202.227     0.200
    14.095   202.587     0.200
    14.217   204.147     0.200
    14.225   203.908     0.200
    14.248   205.222     0.200
    14.186   201.371     0.200
    14.253   201.460     0.200
    14.348   203.009     0.200
    14.327   202.500     0.200
    14.341   204.123     0.200
    14.346   203.717     0.200
    14.356   204.400     0.200
    14.371   204.920     0.200
    14.423   205.004     0.200
    14.448   205.746     0.200
    14.596   209.277     0.200
    14.709   208.537     0.200
    14.926   208.733     0.200
    14.960   211.491     0.200
    14.972   210.645     0.200
    14.984   212.420     0.200
    15.057   212.609     0.200
    15.048   211.594     0.200
    15.052   212.861     0.200
    15.075   212.822     0.200
    15.054   212.422     0.200
    15.079   213.185     0.200
    15.095   211.818     0.200
    15.120   213.788     0.200
    15.218   215.977     0.200
    15.169   214.984     0.200
    15.167   215.428     0.200
    15.207   216.217     0.200
    15.290   216.951     0.200
    15.474   219.217     0.200
    15.474   218.633     0.200
    15.525   219.705     0.200
    15.540   219.667     0.200
    15.540   218.434     0.200
    15.547   219.917     0.200
    15.547   219.773     0.200
    15.590   219.559     0.200
    15.567   221.379     0.200
    15.677   221.496     0.200
    15.823   222.441     0.200
    15.874   222.696     0.200
    15.869   224.602     0.200
    15.936   224.381     0.200
    16.016   225.127     0.200
    16.126   228.036     0.200
    16.109   227.836     0.200
    16.151   228.378     0.200
    16.243   228.740     0.200
    16.326   229.011     0.200
    16.340   230.363     0.200
    16.387   230.740     0.200
    16.428   231.668     0.200
    16.470   231.151     0.200
    16.546   232.340     0.200
    16.528   232.838     0.200
    16.719   232.731     0.200
    16.805   235.380     0.200
    16.844   235.324     0.200
    16.876   236.832     0.200
    17.122   238.614     0.200
    17.119   237.307     0.200
    17.149   236.918     0.200
    17.293   241.479     0.200
    17.422   242.079     0.200
    17.450   241.859     0.200
    17.484   242.807     0.200
    17.504   243.485     0.200
    18.000   249.959     0.200
    18.630   258.777     0.200
    18.683   259.387     0.200
    20.651   281.997     0.200
     1.059    17.887     0.200
     1.086    18.359     0.200
     1.186    21.668     0.200
     1.354    22.285     0.200
     1.357    20.840     0.200
     1.472    24.445     0.200
     1.566    25.348     0.200
     1.632    27.320     0.200
     1.633    28.020     0.200
     1.633    28.609     0.200
     1.764    28.324     0.200
     1.840    30.094     0.200
     2.137    33.488     0.200
     2.189    34.906     0.200
     2.185    34.422     0.200
     2.291    37.352     0.200
     2.546    39.203     0.200
     2.668    40.367     0.200
     2.711    41.738     0.200
     2.762    42.547     0.200
     2.852    43.789     0.200
     2.942    45.266     0.200
     3.660    54.930     0.200
     3.894    58.438     0.200
     3.890    58.777     0.200
     4.087    61.367     0.200
     4.298    63.309     0.200
     4.512    67.574     0.200
     4.691    70.828     0.200
     4.691    70.586     0.200
     4.781    71.863     0.200
     5.273    78.328     0.200
     5.654    84.500     0.200
     5.654    84.625     0.200
     5.692    83.750     0.200
     5.692    84.156     0.200
     5.726    83.910     0.200
     6.104    90.059     0.200
     6.552    96.379     0.200
     6.812    98.969     0.200
     7.485   109.348     0.200
     7.562   112.148     0.200
     7.578   110.289     0.200
     7.608   111.145     0.200
     7.764   115.129     0.200
     7.882   114.270     0.200
     8.057   118.930     0.200
     8.081   118.469     0.200
     8.150   119.234     0.200
     8.928   128.320     0.200
     8.928   128.508     0.200
     8.965   130.867     0.200
     9.573   137.547     0.200
     9.708   141.570     0.200
     9.873   143.625     0.200
     9.878   141.887     0.200
     9.878   142.840     0.200
    10.968   158.109     0.200
    11.027   158.770     0.200
    11.260   165.086     0.200
    12.005   172.109     0.200
    13.858   198.117     0.200
    15.843   222.918     0.200
     1.010    16.846     0.200
     1.010    17.152     0.200
     1.019    17.186     0.200
     1.019    16.885     0.200
     1.051    17.621     0.200
     1.150    20.885     0.200
     1.165    21.166     0.200
     1.201    21.865     0.200
     1.312    21.477     0.200
     1.389    22.941     0.200
     1.429    22.346     0.200
     1.597    25.570     0.200
     1.687    29.115     0.200
     1.771    28.932     0.200
     1.839    29.176     0.200
     2.387    39.945     0.200
     2.610    39.883     0.200
     2.762    42.271     0.200
     2.752    41.225     0.200
     2.752    41.381     0.200
     3.011    47.635     0.200
     3.634    55.195     0.200
     3.832    57.506     0.200
     3.865    58.305     0.200
     4.139    62.201     0.200
     4.378    64.125     0.200
     4.799    72.115     0.200
     5.330    79.211     0.200
     5.477    81.326     0.200
     5.658    82.396     0.200
     5.706    84.775     0.200
     6.044    87.871     0.200
     6.452    94.035     0.200
     6.464    95.076     0.200
     6.888    99.836     0.200
     6.888    99.973     0.200
     7.550   108.975     0.200
     7.599   111.656     0.200
     7.907   114.256     0.200
     8.212   117.986     0.200
     9.008   128.676     0.200
     9.008   129.881     0.200
    11.258   161.336     0.200
     1.093    18.461     0.200
     1.182    19.793     0.200
     1.182    19.523     0.200
     1.182    19.629     0.200
     1.174    21.473     0.200
     1.279    22.441     0.200
     1.424    23.293     0.200
     1.550    25.141     0.200
     1.578    25.633     0.200
     1.556    26.832     0.200
     1.557    26.902     0.200
     1.645    26.684     0.200
     1.682    27.383     0.200
     1.863    31.094     0.200
     1.888    31.473     0.200
     1.936    31.312     0.200
     1.953    32.391     0.200
     2.067    34.062     0.200
     2.143    35.141     0.200
     2.176    34.352     0.200
     2.192    34.422     0.200
     2.288    35.586     0.200
     2.293    35.867     0.200
     2.293    37.262     0.200
     2.370    37.105     0.200
     2.382    36.879     0.200
     2.388    37.781     0.200
     2.411    39.012     0.200
     2.448    40.191     0.200
     2.481    38.441     0.200
     2.507    38.812     0.200
     2.527    38.891     0.200
     2.540    39.852     0.200
     2.558    41.023     0.200
     2.578    39.871     0.200
     2.568    38.941     0.200
     2.568    39.180     0.200
     2.665    41.090     0.200
     2.712    43.242     0.200
     2.725    43.453     0.200
     2.725    42.055     0.200
     2.777    44.141     0.200
     2.845    43.602     0.200
     2.845    43.328     0.200
     2.844    43.609     0.200
     2.954    45.145     0.200
     2.946    45.500     0.200
     3.162    47.688     0.200
     3.200    48.254     0.200
     3.200    48.738     0.200
     3.603    54.109     0.200
     3.748    56.016     0.200
     3.792    56.551     0.200
     3.809    56.613     0.200
     3.809    57.125     0.200
     3.838    59.402     0.200
     3.915    60.402     0.200
     3.938    59.152     0.200
     3.983    59.164     0.200
     4.036    60.953     0.200
     4.090    61.391     0.200
     4.207    61.363     0.200
     4.261    63.402     0.200
     4.370    66.043     0.200
     4.370    65.805     0.200
     4.454    66.988     0.200
     4.594    69.066     0.200
     4.661    70.320     0.200
     4.778    71.781     0.200
     4.800    69.730     0.200
     5.032    75.613     0.200
     5.215    77.527     0.200
     5.604    83.402     0.200
     5.604    83.859     0.200
     5.628    82.449     0.200
     5.750    84.863     0.200
     5.750    85.379     0.200
     6.189    91.391     0.200
     6.189    91.523     0.200
     6.589    96.992     0.200
     6.623    99.051     0.200
     6.624    94.531     0.200
     6.725    97.562     0.200
     6.725    98.020     0.200
     7.417   108.012     0.200
     7.508   108.922     0.200
     7.532   111.383     0.200
     7.532   111.656     0.200
     7.536   109.664     0.200
     7.639   112.164     0.200
     7.715   116.941     0.200
     7.768   113.543     0.200
     7.788   113.203     0.200
     7.812   113.441     0.200
     7.917   114.281     0.200
     7.927   116.754     0.200
     7.952   115.402     0.200
     7.952   118.195     0.200
     7.989   118.453     0.200
     8.042   119.082     0.200
     8.061   118.512     0.200
     8.087   118.266     0.200
     8.122   117.723     0.200
     8.151   120.301     0.200
     8.151   117.102     0.200
     8.602   125.031     0.200
     8.712   127.844     0.200
     8.837   127.004     0.200
     8.932   130.812     0.200
     8.932   130.461     0.200
     9.195   135.273     0.200
     9.476   136.164     0.200
     9.473   137.078     0.200
     9.659   139.941     0.200
     9.659   139.672     0.200
     9.839   142.383     0.200
     9.839   142.125     0.200
    10.012   145.262     0.200
    10.086   146.523     0.200
    10.186   147.371     0.200
    10.361   152.441     0.200
    10.361   149.066     0.200
    10.585   152.754     0.200
    10.679   157.234     0.200
    10.679   154.914     0.200
    10.702   155.441     0.200
    10.702   153.871     0.200
    10.804   156.672     0.200
    10.810   155.184     0.200
    10.867   156.062     0.200
    10.868   156.191     0.200
    10.897   157.613     0.200
    10.951   157.914     0.200
    10.981   158.641     0.200
    11.007   159.480     0.200
    11.140   161.523     0.200
    11.189   161.855     0.200
    11.238   162.039     0.200
    11.278   162.113     0.200
    11.279   163.543     0.200
    11.426   164.730     0.200
    11.513   165.141     0.200
    11.520   167.914     0.200
    11.545   168.871     0.200
    11.639   170.273     0.200
    11.725   170.273     0.200
    11.814   171.902     0.200
    11.904   171.793     0.200
    11.935   172.633     0.200
    13.076   190.691     0.200
    13.376   194.691     0.200
    13.459   193.363     0.200
    13.489   192.871     0.200
    13.582   191.844     0.200
    14.089   203.531     0.200
    14.421   205.543     0.200
    14.713   205.992     0.200
    14.737   210.781     0.200
    14.886   209.613     0.200
    15.182   212.461     0.200
    15.160   215.512     0.200
    15.315   215.223     0.200
    15.487   217.941     0.200
    15.497   217.941     0.200
    15.694   221.301     0.200
    16.812   235.684     0.200
    17.061   237.453     0.200
    18.580   258.023     0.200
    18.669   258.453     0.200
     1.168    19.602     0.200
     1.168    19.348     0.200
     1.548    25.312     0.200
     1.570    28.738     0.200
     1.570    27.469     0.200
     1.564    25.648     0.200
     1.691    27.156     0.200
     2.368    38.340     0.200
     2.376    38.570     0.200
     2.580    39.438     0.200
     2.942    45.625     0.200
     5.027    75.059     0.200
     5.220    77.789     0.200
     5.608    83.359     0.200
     5.608    83.621     0.200
     6.583    96.117     0.200
     6.735    98.219     0.200
     7.533   110.289     0.200
     7.543   110.066     0.200
     7.795   113.520     0.200
     7.819   113.418     0.200
     8.061   119.199     0.200
     8.093   117.828     0.200
     8.141   118.719     0.200
     8.847   127.309     0.200
     8.933   130.457     0.200
     9.841   142.457     0.200
    10.880   156.504     0.200
    14.304   200.848     0.200
    14.426   207.727     0.200
    15.682   221.609     0.200
    16.502   231.699     0.200
    17.048   238.988     0.200
    18.587   258.270     0.200
     1.094    18.508     0.200
     1.182    19.703     0.200
     1.158    21.305     0.200
     1.179    20.875     0.200
     1.172    21.469     0.200
     1.179    21.094     0.200
     1.425    23.375     0.200
     1.552    25.109     0.200
     1.577    25.852     0.200
     1.557    27.453     0.200
     1.647    26.641     0.200
     1.684    27.211     0.200
     2.483    38.336     0.200
     2.527    41.328     0.200
     2.569    38.719     0.200
     2.569    39.039     0.200
     2.577    39.164     0.200
     2.846    43.664     0.200
     3.809    57.039     0.200
     3.940    58.820     0.200
     3.983    59.383     0.200
     4.209    61.930     0.200
     4.779    72.258     0.200
     5.217    77.844     0.200
     5.606    81.953     0.200
     5.606    83.094     0.200
     6.190    91.016     0.200
     6.591    96.977     0.200
     6.624    94.898     0.200
     6.727    97.719     0.200
     6.727    97.953     0.200
     7.534   111.203     0.200
     7.770   114.430     0.200
     8.089   117.719     0.200
     0.933    15.924     0.200
     1.054    17.643     0.200
     1.100    18.289     0.200
     1.181    21.393     0.200
     1.184    21.373     0.200
     1.191    21.703     0.200
     1.359    22.160     0.200
     1.342    20.383     0.200
     1.492    24.270     0.200
     1.551    24.945     0.200
     1.612    25.898     0.200
     1.624    28.193     0.200
     1.624    27.424     0.200
     1.625    27.934     0.200
     1.625    28.533     0.200
     1.740    27.730     0.200
     1.854    29.967     0.200
     2.171    34.006     0.200
     2.343    36.439     0.200
     2.442    39.562     0.200
     2.492    39.482     0.200
     2.523    38.666     0.200
     2.644    39.803     0.200
     2.691    41.287     0.200
     2.772    42.223     0.200
     2.869    43.791     0.200
     2.931    44.973     0.200
     3.517    52.969     0.200
     3.671    54.709     0.200
     3.725    55.338     0.200
     3.889    59.824     0.200
     3.906    58.723     0.200
     4.066    61.209     0.200
     4.274    63.283     0.200
     4.521    67.252     0.200
     4.674    70.393     0.200
     4.674    70.211     0.200
     4.769    71.576     0.200
     5.251    77.887     0.200
     5.536    81.354     0.200
     5.633    84.174     0.200
     5.633    83.963     0.200
     6.114    90.088     0.200
     6.544    96.562     0.200
     6.544    95.873     0.200
     6.564    97.303     0.200
     6.787    98.543     0.200
     6.787    98.104     0.200
     7.545   111.693     0.200
     8.683   125.463     0.200
     8.903   127.891     0.200
    10.943   156.889     0.200
    11.252   162.812     0.200
     0.923    15.438     0.200
     1.180    22.828     0.200
     1.180    21.617     0.200
     1.239    21.656     0.200
     1.294    23.312     0.200
     1.414    23.273     0.200
     1.435    23.258     0.200
     1.655    27.211     0.200
     1.690    27.008     0.200
     1.866    29.336     0.200
     2.099    33.125     0.200
     2.137    32.773     0.200
     2.137    32.961     0.200
     3.910    59.281     0.200
     4.275    64.875     0.200
     4.324    64.664     0.200
     4.639    69.758     0.200
     4.639    69.938     0.200
     4.931    76.062     0.200
     5.040    74.867     0.200
     5.472    81.727     0.200
     5.472    81.609     0.200
     6.374    92.383     0.200
     6.374    92.656     0.200
     6.659    98.578     0.200
     7.117   105.305     0.200
     7.135   104.734     0.200
     7.252   105.664     0.200
     7.497   111.156     0.200
     7.561   109.422     0.200
     7.871   115.102     0.200
     7.899   114.312     0.200
     8.209   119.586     0.200
     8.452   121.648     0.200
     8.507   126.031     0.200
     9.817   145.016     0.200
    10.420   150.656     0.200
    10.661   156.453     0.200
    10.896   157.016     0.200
    11.180   163.070     0.200
    11.381   168.852     0.200
    11.471   166.758     0.200
    11.886   173.031     0.200
    12.010   177.633     0.200
    12.369   181.883     0.200
    13.369   189.984     0.200
    13.658   197.594     0.200
    14.759   210.961     0.200
    16.084   226.148     0.200
    16.404   230.633     0.200
    18.296   252.953     0.200
     0.983    16.441     0.200
     0.963    16.160     0.200
     1.250    22.145     0.200
     1.284    21.832     0.200
     1.270    22.812     0.200
     1.345    23.863     0.200
     1.360    23.414     0.200
     1.545    24.898     0.200
     1.724    27.398     0.200
     1.778    29.441     0.200
     1.823    28.863     0.200
     1.990    31.016     0.200
     2.041    31.566     0.200
     2.033    31.801     0.200
     2.231    34.949     0.200
     2.684    41.055     0.200
     2.948    45.301     0.200
     2.990    45.703     0.200
     3.181    50.652     0.200
     3.229    49.605     0.200
     3.361    50.516     0.200
     3.442    52.473     0.200
     3.753    54.926     0.200
     3.853    60.055     0.200
     4.375    66.105     0.200
     4.457    66.805     0.200
     4.594    69.426     0.200
     4.653    70.320     0.200
     4.893    72.348     0.200
     5.456    81.207     0.200
     5.456    81.754     0.200
     6.223    91.215     0.200
     6.223    91.453     0.200
     6.296    91.168     0.200
     6.296    91.293     0.200
     6.823   100.082     0.200
     6.841   102.004     0.200
     7.130   104.055     0.200
     7.200   105.074     0.200
     7.829   114.363     0.200
     8.106   119.965     0.200
     8.363   120.191     0.200
     8.363   119.543     0.200
     8.608   124.504     0.200
    10.312   148.504     0.200
    11.306   162.234     0.200
    11.533   166.344     0.200
    12.710   182.449     0.200
    12.869   182.531     0.200
    13.184   188.715     0.200
    13.213   189.680     0.200
    13.261   190.070     0.200
    13.829   196.953     0.200
    14.467   206.246     0.200
    14.479   206.270     0.200
    14.517   206.836     0.200
     0.981    16.824     0.200
     1.044    17.738     0.200
     1.038    17.645     0.200
     1.038    17.484     0.200
     1.176    21.543     0.200
     1.319    21.781     0.200
     1.418    23.914     0.200
     1.576    25.508     0.200
     1.605    26.133     0.200
     2.109    33.211     0.200
     2.173    34.133     0.200
     2.243    36.648     0.200
     2.719    41.973     0.200
     2.719    41.742     0.200
     2.719    41.582     0.200
     3.615    54.352     0.200
     3.658    55.184     0.200
     3.866    58.543     0.200
     4.344    65.203     0.200
     4.706    70.270     0.200
     5.287    78.691     0.200
     5.678    84.020     0.200
     5.678    84.711     0.200
     6.543    98.484     0.200
     6.855    99.812     0.200
     6.855    99.914     0.200
     7.576   112.133     0.200
     7.761   112.383     0.200
     8.064   119.504     0.200
     8.090   119.664     0.200
     8.182   119.742     0.200
     8.974   129.543     0.200
    11.064   160.691     0.200
     1.008    16.771     0.200
     1.008    17.252     0.200
     1.058    17.785     0.200
     1.340    24.252     0.200
     1.350    24.021     0.200
     1.390    23.660     0.200
     1.422    25.082     0.200
     1.466    25.492     0.200
     1.612    25.900     0.200
     1.885    30.771     0.200
     1.921    30.283     0.200
     1.921    30.512     0.200
     1.945    30.236     0.200
     1.945    30.482     0.200
     2.086    32.977     0.200
     3.097    47.941     0.200
     3.286    54.033     0.200
     3.335    52.912     0.200
     3.665    54.043     0.200
     3.958    60.922     0.200
     4.428    67.432     0.200
     4.632    70.609     0.200
     4.632    70.803     0.200
     4.682    70.582     0.200
     5.411    81.162     0.200
     5.654    85.193     0.200
     6.209    90.484     0.200
     6.209    90.742     0.200
     6.242    94.062     0.200
     6.281    93.662     0.200
     6.330    91.512     0.200
     6.842   101.082     0.200
     6.868   100.182     0.200
     7.063   104.543     0.200
     7.475   110.631     0.200
     7.475   110.852     0.200
     7.766   115.432     0.200
     8.076   120.252     0.200
     8.092   121.033     0.200
     8.152   118.412     0.200
     8.662   127.982     0.200
    10.210   148.057     0.200
     1.262    22.867     0.200
     1.273    22.707     0.200
     1.273    22.707     0.200
     1.316    23.578     0.200
     1.338    21.547     0.200
     1.424    24.805     0.200
     1.582    25.223     0.200
     1.602    25.371     0.200
     1.842    29.355     0.200
     2.023    31.930     0.200
     2.168    33.246     0.200
     2.168    33.578     0.200
     2.972    46.238     0.200
     4.180    63.305     0.200
     4.583    69.402     0.200
     4.583    69.598     0.200
     5.435    81.281     0.200
     5.435    81.086     0.200
     5.465    80.996     0.200
     6.384    93.121     0.200
     7.851   114.828     0.200
    10.658   152.758     0.200
     0.892    15.367     0.200
     1.074    17.477     0.200
     1.142    19.328     0.200
     1.236    21.344     0.200
     1.236    21.891     0.200
     1.280    20.711     0.200
     1.272    21.828     0.200
     1.272    21.711     0.200
     1.258    22.609     0.200
     1.344    21.992     0.200
     1.365    22.227     0.200
     1.357    23.648     0.200
     1.358    23.711     0.200
     1.358    23.500     0.200
     1.389    24.680     0.200
     1.442    25.641     0.200
     1.474    23.539     0.200
     1.471    24.000     0.200
     1.474    23.555     0.200
     1.584    25.594     0.200
     1.610    25.750     0.200
     1.611    25.148     0.200
     1.611    25.328     0.200
     1.609    25.922     0.200
     1.656    26.391     0.200
     1.678    27.516     0.200
     1.678    27.617     0.200
     1.693    27.289     0.200
     1.739    27.273     0.200
     1.764    27.742     0.200
     1.852    29.008     0.200
     1.965    30.859     0.200
     1.969    30.891     0.200
     2.003    31.367     0.200
     2.062    32.258     0.200
     2.077    31.617     0.200
     2.419    37.242     0.200
     3.008    48.203     0.200
     3.063    46.977     0.200
     3.195    48.852     0.200
     3.333    50.344     0.200
     3.682    56.148     0.200
     3.706    55.812     0.200
     3.743    54.906     0.200
     4.107    61.992     0.200
     4.245    61.883     0.200
     4.352    64.688     0.200
     4.458    68.125     0.200
     4.458    67.961     0.200
     4.629    69.227     0.200
     4.938    72.773     0.200
     5.017    74.680     0.200
     5.279    77.141     0.200
     5.308    79.805     0.200
     5.308    79.312     0.200
     5.367    79.727     0.200
     5.955    88.234     0.200
     6.274    91.445     0.200
     6.274    90.828     0.200
     6.535    95.570     0.200
     6.590    98.047     0.200
     7.039   103.883     0.200
     7.118   103.992     0.200
     7.318   108.250     0.200
     7.396   107.062     0.200
     7.618   110.531     0.200
     7.710   114.633     0.200
     7.726   113.227     0.200
     7.726   112.312     0.200
     7.812   114.680     0.200
     7.854   115.352     0.200
     7.895   118.477     0.200
     7.962   115.750     0.200
     8.189   117.719     0.200
     8.339   121.320     0.200
     8.735   129.438     0.200
     9.555   135.719     0.200
     9.572   137.523     0.200
     9.918   144.969     0.200
    10.373   150.602     0.200
    10.373   149.078     0.200
    10.540   155.328     0.200
    10.540   152.688     0.200
    11.283   161.883     0.200
    11.283   166.500     0.200
    11.967   173.227     0.200
    13.428   193.344     0.200
    13.582   194.609     0.200
    14.584   206.508     0.200
    14.618   206.969     0.200
    15.130   214.008     0.200
    15.210   213.070     0.200
    15.356   214.992     0.200
    15.448   215.469     0.200
    15.924   224.469     0.200
    20.865   286.617     0.200
     1.070    19.859     0.200
     1.175    21.330     0.200
     1.138    21.160     0.200
     1.138    20.609     0.200
     1.176    21.479     0.200
     1.144    19.729     0.200
     1.228    21.779     0.200
     1.437    23.203     0.200
     1.461    24.830     0.200
     1.645    27.350     0.200
     1.669    26.715     0.200
     1.685    26.812     0.200
     1.865    29.350     0.200
     1.939    30.639     0.200
     2.091    33.084     0.200
     2.150    33.262     0.200
     2.150    33.410     0.200
     2.438    38.477     0.200
     2.574    39.863     0.200
     2.808    43.365     0.200
     2.823    43.588     0.200
     2.857    44.121     0.200
     3.247    49.275     0.200
     3.467    52.891     0.200
     3.798    57.354     0.200
     3.848    56.420     0.200
     4.028    61.400     0.200
     4.229    63.670     0.200
     4.279    64.379     0.200
     4.319    64.715     0.200
     4.463    68.479     0.200
     4.597    69.152     0.200
     4.650    70.592     0.200
     4.650    70.420     0.200
     4.780    71.467     0.200
     5.484    81.945     0.200
     5.484    82.189     0.200
     5.558    83.650     0.200
     6.046    91.189     0.200
     6.120    89.992     0.200
     6.387    93.182     0.200
     6.387    92.789     0.200
     6.766   101.910     0.200
     6.785   102.309     0.200
     7.287   106.529     0.200
     7.508   110.992     0.200
     7.508   111.400     0.200
     7.883   114.590     0.200
     7.908   117.189     0.200
     8.086   119.590     0.200
     8.090   118.889     0.200
     8.510   124.314     0.200
     8.886   129.578     0.200
     8.929   129.379     0.200
     9.752   143.389     0.200
     9.762   142.809     0.200
     9.758   141.189     0.200
     9.789   141.756     0.200
     9.840   144.549     0.200
    10.117   147.832     0.200
    10.237   148.754     0.200
    10.431   150.389     0.200
    10.631   154.418     0.200
    10.674   154.379     0.200
    10.674   155.859     0.200
    10.861   155.543     0.200
    10.907   158.705     0.200
    10.907   159.199     0.200
    10.948   159.441     0.200
    11.009   160.043     0.200
    11.102   162.014     0.200
    11.152   163.191     0.200
    11.214   164.479     0.200
    11.383   166.707     0.200
    11.447   165.549     0.200
    11.445   168.012     0.200
    11.476   168.523     0.200
    11.478   167.240     0.200
    11.517   166.271     0.200
    11.690   171.072     0.200
    11.890   173.051     0.200
    11.923   173.723     0.200
    11.991   177.643     0.200
    12.065   176.164     0.200
    12.110   176.521     0.200
    12.290   177.090     0.200
    12.388   178.170     0.200
    12.497   180.479     0.200
    12.661   183.664     0.200
    12.713   183.971     0.200
    12.753   183.604     0.200
    12.819   186.504     0.200
    12.829   187.486     0.200
    12.982   187.184     0.200
    13.044   186.535     0.200
    13.283   189.670     0.200
    13.316   190.709     0.200
    13.369   193.340     0.200
    13.382   193.123     0.200
    13.522   194.502     0.200
    13.871   197.736     0.200
    13.933   199.859     0.200
    14.145   203.855     0.200
    14.338   206.129     0.200
    14.367   206.461     0.200
    14.599   209.244     0.200
    14.619   209.289     0.200
    14.654   210.156     0.200
    14.804   211.908     0.200
    14.869   212.057     0.200
    14.913   213.205     0.200
    15.199   216.707     0.200
    15.636   222.420     0.200
    15.891   225.285     0.200
    16.141   228.092     0.200
    16.598   232.639     0.200
    16.607   233.678     0.200
    17.281   240.355     0.200
    18.655   260.891     0.200
    18.655   260.270     0.200
    20.157   276.295     0.200
     1.042    17.825     0.200
     1.042    17.720     0.200
     1.051    17.820     0.200
     1.325    21.959     0.200
     1.418    23.496     0.200
     1.583    25.495     0.200
     1.612    26.083     0.200
     1.667    28.676     0.200
     1.668    29.016     0.200
     1.668    28.646     0.200
     1.794    29.436     0.200
     2.115    33.136     0.200
     2.137    33.942     0.200
     2.137    34.075     0.200
     2.178    34.107     0.200
     2.198    34.729     0.200
     2.224    34.663     0.200
     2.239    35.937     0.200
     2.250    35.024     0.200
     2.350    36.680     0.200
     2.374    37.146     0.200
     2.475    38.615     0.200
     2.565    39.544     0.200
     2.724    41.898     0.200
     2.755    42.258     0.200
     2.721    41.098     0.200
     2.802    43.161     0.200
     3.001    45.229     0.200
     3.040    46.520     0.200
     3.160    48.044     0.200
     3.231    48.916     0.200
     3.384    50.620     0.200
     3.446    52.379     0.200
     3.508    54.056     0.200
     3.619    54.411     0.200
     3.630    54.389     0.200
     3.660    54.912     0.200
     3.681    55.466     0.200
     3.853    57.825     0.200
     3.864    57.582     0.200
     3.872    57.995     0.200
     3.929    59.224     0.200
     4.074    62.306     0.200
     4.108    61.323     0.200
     4.161    62.329     0.200
     4.274    64.325     0.200
     4.274    64.167     0.200
     4.294    63.734     0.200
     4.348    63.625     0.200
     4.474    66.871     0.200
     4.548    67.494     0.200
     4.641    68.936     0.200
     4.713    70.526     0.200
     4.767    71.122     0.200
     4.754    71.896     0.200
     5.022    75.426     0.200
     5.211    77.945     0.200
     5.295    79.306     0.200
     5.494    82.312     0.200
     5.494    81.525     0.200
     5.488    81.726     0.200
     5.508    82.676     0.200
     5.610    81.815     0.200
     5.669    83.768     0.200
     5.669    83.955     0.200
     5.685    84.354     0.200
     5.685    84.506     0.200
     5.918    87.855     0.200
     6.064    89.735     0.200
     6.064    89.400     0.200
     6.051    90.426     0.200
     6.213    92.065     0.200
     6.477    94.625     0.200
     6.487   100.155     0.200
     6.550    97.556     0.200
     6.571    97.625     0.200
     6.676    99.256     0.200
     6.860    99.742     0.200
     7.002   103.545     0.200
     7.155   103.146     0.200
     7.236   107.125     0.200
     7.323   106.865     0.200
     7.358   108.756     0.200
     7.525   110.266     0.200
     7.584   111.188     0.200
     7.584   112.025     0.200
     7.628   114.306     0.200
     7.619   110.795     0.200
     7.650   111.368     0.200
     7.746   117.045     0.200
     7.768   114.726     0.200
     7.813   114.325     0.200
     7.882   115.105     0.200
     7.897   117.346     0.200
     7.909   116.125     0.200
     7.909   115.140     0.200
     7.901   115.235     0.200
     7.922   115.545     0.200
     7.983   118.266     0.200
     8.014   119.025     0.200
     8.073   117.250     0.200
     8.073   117.426     0.200
     8.071   120.085     0.200
     8.097   119.795     0.200
     8.098   120.025     0.200
     8.188   119.025     0.200
     8.188   119.426     0.200
     8.289   121.976     0.200
     8.285   120.835     0.200
     8.346   122.756     0.200
     8.553   124.365     0.200
     8.574   123.426     0.200
     8.671   126.315     0.200
     8.685   128.495     0.200
     8.716   122.835     0.200
     8.828   129.405     0.200
     8.833   129.295     0.200
     8.951   131.025     0.200
     8.989   130.127     0.200
     8.989   130.936     0.200
     9.139   133.545     0.200
     9.165   134.205     0.200
     9.380   136.806     0.200
     9.426   136.825     0.200
     9.429   136.775     0.200
     9.460   138.115     0.200
     9.517   138.525     0.200
     9.536   137.597     0.200
     9.566   140.176     0.200
     9.639   141.795     0.200
     9.673   140.577     0.200
     9.673   141.375     0.200
     9.693   141.966     0.200
     9.725   142.806     0.200
     9.803   142.075     0.200
     9.772   142.256     0.200
     9.809   143.375     0.200
     9.833   142.896     0.200
     9.909   144.017     0.200
     9.861   142.226     0.200
     9.861   144.364     0.200
     9.897   143.282     0.200
     9.904   142.816     0.200
     9.904   143.476     0.200
     9.979   145.426     0.200
     9.980   146.915     0.200
    10.119   148.597     0.200
    10.175   148.355     0.200
    10.243   147.499     0.200
    10.305   152.226     0.200
    10.275   150.119     0.200
    10.315   150.490     0.200
    10.468   153.315     0.200
    10.440   150.819     0.200
    10.440   151.905     0.200
    10.537   154.286     0.200
    10.537   154.516     0.200
    10.542   153.979     0.200
    10.576   151.035     0.200
    10.724   156.006     0.200
    10.779   158.575     0.200
    10.767   156.686     0.200
    10.754   155.202     0.200
    10.754   156.226     0.200
    10.934   159.449     0.200
    10.934   158.115     0.200
    10.955   159.446     0.200
    10.962   161.655     0.200
    10.936   158.926     0.200
    10.936   159.383     0.200
    11.021   158.426     0.200
    11.020   158.815     0.200
    11.021   158.450     0.200
    11.062   158.771     0.200
    11.070   159.357     0.200
    11.263   163.646     0.200
    11.256   163.355     0.200
    11.257   163.476     0.200
    11.257   163.476     0.200
    11.254   162.249     0.200
    11.275   162.738     0.200
    11.320   162.436     0.200
    11.374   166.905     0.200
    11.356   163.596     0.200
    11.391   164.596     0.200
    11.389   165.186     0.200
    11.377   163.240     0.200
    11.420   164.534     0.200
    11.446   165.327     0.200
    11.446   167.045     0.200
    11.480   166.075     0.200
    11.510   167.955     0.200
    11.508   166.035     0.200
    11.502   165.811     0.200
    11.598   168.605     0.200
    11.622   169.506     0.200
    11.585   166.573     0.200
    11.604   167.123     0.200
    11.689   170.275     0.200
    11.668   168.083     0.200
    11.683   168.689     0.200
    11.732   172.176     0.200
    11.740   169.790     0.200
    11.776   170.726     0.200
    11.760   169.034     0.200
    11.832   170.259     0.200
    11.863   172.585     0.200
    11.841   170.445     0.200
    11.872   170.989     0.200
    11.878   171.686     0.200
    11.877   170.429     0.200
    11.947   171.709     0.200
    11.952   172.157     0.200
    11.992   172.365     0.200
    11.971   171.599     0.200
    11.980   172.513     0.200
    11.987   172.247     0.200
    12.046   172.684     0.200
    12.063   173.738     0.200
    12.098   174.705     0.200
    12.102   173.634     0.200
    12.159   177.335     0.200
    12.119   173.411     0.200
    12.164   175.248     0.200
    12.215   177.949     0.200
    12.259   177.199     0.200
    12.311   177.144     0.200
    12.324   177.586     0.200
    12.393   180.745     0.200
    12.408   181.065     0.200
    12.422   180.403     0.200
    12.422   179.545     0.200
    12.420   177.465     0.200
    12.456   179.100     0.200
    12.431   177.581     0.200
    12.473   179.663     0.200
    12.491   179.418     0.200
    12.491   180.665     0.200
    12.563   179.842     0.200
    12.569   181.268     0.200
    12.581   183.006     0.200
    12.551   179.787     0.200
    12.569   180.783     0.200
    12.605   182.915     0.200
    12.626   183.825     0.200
    12.629   184.216     0.200
    12.602   180.282     0.200
    12.637   182.749     0.200
    12.624   182.020     0.200
    12.657   183.915     0.200
    12.643   181.574     0.200
    12.636   181.717     0.200
    12.694   185.045     0.200
    12.669   181.543     0.200
    12.721   184.886     0.200
    12.702   183.190     0.200
    12.775   183.314     0.200
    12.801   184.034     0.200
    12.818   186.855     0.200
    12.801   183.610     0.200
    12.801   183.395     0.200
    12.878   187.393     0.200
    12.928   188.775     0.200
    12.948   187.815     0.200
    12.934   184.264     0.200
    12.970   186.209     0.200
    12.980   186.694     0.200
    13.011   186.143     0.200
    13.019   186.908     0.200
    13.067   190.266     0.200
    13.072   186.974     0.200
    13.071   186.168     0.200
    13.081   186.634     0.200
    13.136   188.840     0.200
    13.152   188.313     0.200
    13.147   187.355     0.200
    13.155   188.350     0.200
    13.214   189.825     0.200
    13.231   190.192     0.200
    13.187   188.863     0.200
    13.216   188.674     0.200
    13.217   188.708     0.200
    13.255   189.174     0.200
    13.320   193.176     0.200
    13.310   190.817     0.200
    13.323   193.426     0.200
    13.322   190.614     0.200
    13.322   191.078     0.200
    13.347   190.561     0.200
    13.365   189.801     0.200
    13.399   193.386     0.200
    13.360   191.253     0.200
    13.392   191.167     0.200
    13.415   191.262     0.200
    13.418   192.119     0.200
    13.439   193.569     0.200
    13.439   192.795     0.200
    13.456   192.867     0.200
    13.455   190.490     0.200
    13.496   193.183     0.200
    13.545   193.814     0.200
    13.572   193.183     0.200
    13.591   194.093     0.200
    13.611   194.666     0.200
    13.653   194.956     0.200
    13.755   195.316     0.200
    13.712   195.052     0.200
    13.712   195.506     0.200
    13.749   196.043     0.200
    13.746   194.967     0.200
    13.789   195.327     0.200
    13.781   195.306     0.200
    13.787   195.541     0.200
    13.824   197.023     0.200
    13.812   195.855     0.200
    13.836   194.750     0.200
    13.836   198.013     0.200
    13.831   197.274     0.200
    13.836   196.909     0.200
    13.876   197.652     0.200
    13.928   200.875     0.200
    13.923   198.157     0.200
    13.911   197.448     0.200
    13.907   198.702     0.200
    13.909   199.125     0.200
    13.909   198.168     0.200
    13.936   198.865     0.200
    13.932   199.062     0.200
    13.957   199.405     0.200
    13.980   201.985     0.200
    13.991   202.205     0.200
    13.979   198.845     0.200
    14.022   198.893     0.200
    14.039   199.245     0.200
    14.036   199.112     0.200
    14.059   200.117     0.200
    14.158   203.266     0.200
    14.192   204.655     0.200
    14.191   201.686     0.200
    14.174   201.648     0.200
    14.218   204.313     0.200
    14.218   204.205     0.200
    14.192   200.933     0.200
    14.233   202.301     0.200
    14.242   201.925     0.200
    14.253   203.271     0.200
    14.267   202.950     0.200
    14.289   203.434     0.200
    14.304   205.358     0.200
    14.318   204.377     0.200
    14.325   203.574     0.200
    14.364   207.216     0.200
    14.367   206.346     0.200
    14.390   205.288     0.200
    14.411   204.417     0.200
    14.419   203.674     0.200
    14.400   204.068     0.200
    14.411   204.325     0.200
    14.410   204.358     0.200
    14.422   204.529     0.200
    14.462   206.258     0.200
    14.421   203.988     0.200
    14.430   204.869     0.200
    14.490   207.485     0.200
    14.448   205.670     0.200
    14.472   204.537     0.200
    14.498   206.312     0.200
    14.548   208.325     0.200
    14.515   206.503     0.200
    14.577   205.502     0.200
    14.631   207.262     0.200
    14.667   210.315     0.200
    14.652   208.528     0.200
    14.640   206.786     0.200
    14.651   209.187     0.200
    14.691   208.716     0.200
    14.696   207.943     0.200
    14.723   209.726     0.200
    14.697   210.030     0.200
    14.728   208.607     0.200
    14.765   210.726     0.200
    14.742   208.208     0.200
    14.755   208.003     0.200
    14.777   208.815     0.200
    14.786   208.524     0.200
    14.800   209.688     0.200
    14.803   209.059     0.200
    14.829   211.513     0.200
    14.889   213.235     0.200
    14.883   211.001     0.200
    14.931   210.482     0.200
    14.912   210.830     0.200
    14.945   210.267     0.200
    14.961   210.778     0.200
    15.011   214.535     0.200
    15.001   212.309     0.200
    15.032   212.802     0.200
    15.058   211.523     0.200
    15.031   212.100     0.200
    15.045   212.295     0.200
    15.058   213.048     0.200
    15.106   216.646     0.200
    15.124   211.940     0.200
    15.117   213.423     0.200
    15.128   214.182     0.200
    15.137   213.150     0.200
    15.131   214.259     0.200
    15.151   212.435     0.200
    15.184   217.445     0.200
    15.215   216.766     0.200
    15.185   214.870     0.200
    15.203   215.220     0.200
    15.241   217.926     0.200
    15.244   216.981     0.200
    15.255   216.318     0.200
    15.236   214.695     0.200
    15.286   218.355     0.200
    15.248   216.115     0.200
    15.270   215.873     0.200
    15.270   216.985     0.200
    15.284   216.277     0.200
    15.303   216.256     0.200
    15.345   215.454     0.200
    15.365   219.615     0.200
    15.416   217.363     0.200
    15.412   216.633     0.200
    15.398   218.363     0.200
    15.421   215.078     0.200
    15.409   217.922     0.200
    15.450   216.356     0.200
    15.538   220.020     0.200
    15.534   219.974     0.200
    15.534   219.815     0.200
    15.600   221.525     0.200
    15.600   222.226     0.200
    15.597   219.785     0.200
    15.598   219.724     0.200
    15.598   220.596     0.200
    15.596   219.340     0.200
    15.620   220.211     0.200
    15.620   220.646     0.200
    15.640   219.584     0.200
    15.648   221.654     0.200
    15.673   220.508     0.200
    15.708   222.427     0.200
    15.709   222.215     0.200
    15.728   220.841     0.200
    15.711   221.792     0.200
    15.749   222.327     0.200
    15.751   221.750     0.200
    15.811   222.708     0.200
    15.823   222.038     0.200
    15.840   223.394     0.200
    15.847   222.312     0.200
    15.843   224.897     0.200
    15.879   225.245     0.200
    15.898   225.525     0.200
    15.904   224.787     0.200
    15.870   224.919     0.200
    15.902   225.524     0.200
    15.889   223.073     0.200
    15.891   224.516     0.200
    15.890   224.899     0.200
    15.952   223.091     0.200
    15.951   226.370     0.200
    15.969   224.348     0.200
    16.026   227.721     0.200
    16.022   224.982     0.200
    15.999   224.094     0.200
    16.039   225.751     0.200
    16.020   227.502     0.200
    16.065   225.318     0.200
    16.077   227.526     0.200
    16.076   225.897     0.200
    16.147   227.661     0.200
    16.176   228.516     0.200
    16.163   226.121     0.200
    16.192   226.363     0.200
    16.198   227.139     0.200
    16.188   229.691     0.200
    16.251   228.504     0.200
    16.225   228.573     0.200
    16.251   228.991     0.200
    16.268   229.347     0.200
    16.278   229.059     0.200
    16.289   229.925     0.200
    16.305   229.283     0.200
    16.344   229.938     0.200
    16.379   230.557     0.200
    16.398   230.771     0.200
    16.405   229.912     0.200
    16.474   231.454     0.200
    16.465   232.976     0.200
    16.489   230.356     0.200
    16.485   230.763     0.200
    16.524   232.708     0.200
    16.545   232.283     0.200
    16.528   231.117     0.200
    16.617   234.520     0.200
    16.595   233.104     0.200
    16.622   232.827     0.200
    16.624   233.384     0.200
    16.607   234.809     0.200
    16.651   233.274     0.200
    16.650   234.397     0.200
    16.665   233.905     0.200
    16.670   235.104     0.200
    16.704   236.013     0.200
    16.773   234.605     0.200
    16.811   236.060     0.200
    16.835   237.246     0.200
    16.864   235.789     0.200
    16.893   236.323     0.200
    16.893   236.605     0.200
    16.914   237.206     0.200
    16.921   236.690     0.200
    16.936   236.996     0.200
    16.936   237.176     0.200
    16.931   237.890     0.200
    16.935   237.979     0.200
    16.977   237.908     0.200
    16.985   238.666     0.200
    16.982   237.587     0.200
    17.004   237.333     0.200
    17.008   238.092     0.200
    17.007   237.729     0.200
    17.044   238.354     0.200
    17.076   239.413     0.200
    17.107   240.271     0.200
    17.095   239.971     0.200
    17.084   240.058     0.200
    17.160   240.883     0.200
    17.183   240.078     0.200
    17.209   240.836     0.200
    17.215   240.085     0.200
    17.214   240.473     0.200
    17.257   240.697     0.200
    17.311   242.070     0.200
    17.354   242.688     0.200
    17.347   241.787     0.200
    17.454   243.523     0.200
    17.497   244.430     0.200
    17.536   244.398     0.200
    17.523   245.458     0.200
    17.536   244.515     0.200
    17.536   245.039     0.200
    17.594   245.696     0.200
    17.573   244.955     0.200
    17.599   246.199     0.200
    17.586   245.310     0.200
    17.597   246.229     0.200
    17.643   246.428     0.200
    17.718   246.775     0.200
    17.733   247.041     0.200
    17.761   247.703     0.200
    17.778   247.294     0.200
    17.828   248.966     0.200
    17.925   249.459     0.200
    17.983   249.935     0.200
    18.007   250.874     0.200
    18.061   250.750     0.200
    18.053   250.702     0.200
    18.063   251.485     0.200
    18.082   251.818     0.200
    18.086   251.325     0.200
    18.113   252.016     0.200
    18.118   251.674     0.200
    18.131   252.204     0.200
    18.152   252.530     0.200
    18.163   253.169     0.200
    18.245   253.589     0.200
    18.269   254.319     0.200
    18.313   254.165     0.200
    18.401   255.375     0.200
    18.407   255.801     0.200
    18.575   258.723     0.200
    18.713   259.480     0.200
    18.713   259.966     0.200
    18.711   259.683     0.200
    18.776   260.776     0.200
    18.873   261.509     0.200
    18.873   262.035     0.200
    19.205   265.089     0.200
    19.634   270.119     0.200
    19.710   271.256     0.200
     1.023    17.617     0.200
     1.008    17.213     0.200
     1.053    17.752     0.200
     1.199    21.914     0.200
     1.315    21.771     0.200
     1.683    30.115     0.200
     1.775    29.365     0.200
     2.166    34.102     0.200
     2.213    36.307     0.200
     2.709    41.736     0.200
     2.746    42.236     0.200
     2.748    42.025     0.200
     3.602    54.508     0.200
     3.638    54.764     0.200
     3.836    58.244     0.200
     3.868    58.955     0.200
     4.263    64.424     0.200
     4.374    64.385     0.200
     4.459    66.990     0.200
     4.728    71.418     0.200
     5.297    79.404     0.200
     5.481    82.025     0.200
     5.661    83.725     0.200
     5.704    85.152     0.200
     5.704    85.045     0.200
     6.048    89.664     0.200
     6.456    94.984     0.200
     6.554    97.725     0.200
     6.575    97.914     0.200
     6.885   100.172     0.200
     7.547   110.354     0.200
     7.598   112.820     0.200
     7.598   113.225     0.200
     7.633   110.285     0.200
     7.642   111.475     0.200
     7.673   112.490     0.200
     7.801   114.715     0.200
     7.775   116.324     0.200
     7.945   115.494     0.200
     7.994   118.404     0.200
     8.066   118.139     0.200
     8.083   119.715     0.200
     8.110   117.914     0.200
     8.210   119.490     0.200
     8.210   119.865     0.200
     8.551   127.385     0.200
     8.687   128.555     0.200
     9.004   131.701     0.200
     9.566   139.094     0.200
     9.682   140.205     0.200
     9.737   142.455     0.200
     9.912   144.104     0.200
     9.921   143.418     0.200
    10.517   154.205     0.200
    10.949   160.549     0.200
    10.949   159.814     0.200
    11.048   158.664     0.200
    11.081   160.611     0.200
    11.093   160.264     0.200
    11.093   160.064     0.200
    11.259   164.504     0.200
    11.259   164.414     0.200
    11.301   163.682     0.200
    11.389   168.354     0.200
    11.346   162.967     0.200
    11.402   164.475     0.200
    11.440   166.004     0.200
    11.526   166.904     0.200
    11.621   167.365     0.200
    11.608   168.627     0.200
    11.702   169.123     0.200
    11.875   172.381     0.200
    11.972   172.006     0.200
    12.004   174.840     0.200
    11.998   172.850     0.200
    12.068   174.414     0.200
    12.146   173.975     0.200
    12.184   176.139     0.200
    12.315   179.596     0.200
    12.651   183.807     0.200
    12.648   183.236     0.200
    12.728   184.654     0.200
    12.819   184.600     0.200
    12.924   189.404     0.200
    13.016   188.125     0.200
    13.179   189.635     0.200
    13.213   191.000     0.200
    13.279   190.340     0.200
    13.340   191.842     0.200
    13.395   193.094     0.200
    13.387   193.357     0.200
    13.457   194.584     0.200
    13.441   192.156     0.200
    13.519   194.531     0.200
    13.572   195.256     0.200
    13.674   198.043     0.200
    13.807   197.998     0.200
    13.812   197.510     0.200
    13.836   197.160     0.200
    13.857   198.920     0.200
    13.933   200.350     0.200
    13.935   200.211     0.200
    13.935   200.395     0.200
    14.002   200.252     0.200
    14.036   201.025     0.200
    14.081   201.623     0.200
    14.212   204.814     0.200
    14.201   202.709     0.200
    14.269   205.072     0.200
    14.311   205.877     0.200
    14.362   205.705     0.200
    14.350   205.154     0.200
    14.425   205.201     0.200
    14.434   206.006     0.200
    14.456   205.680     0.200
    14.474   206.354     0.200
    14.538   207.574     0.200
    14.677   209.822     0.200
    14.731   208.215     0.200
    14.821   212.125     0.200
    14.883   209.844     0.200
    15.100   215.264     0.200
    15.084   214.727     0.200
    15.177   214.215     0.200
    15.154   215.521     0.200
    15.158   215.896     0.200
    15.275   218.213     0.200
    15.430   220.152     0.200
    15.590   220.154     0.200
    15.645   221.115     0.200
    15.777   224.248     0.200
    16.099   227.014     0.200
    16.423   232.121     0.200
    16.507   232.434     0.200
    17.029   239.248     0.200
    17.185   240.594     0.200
    18.727   261.318     0.200
    18.719   259.514     0.200
    20.113   278.053     0.200
    20.589   282.180     0.200
    20.942   284.979     0.200
     0.608    12.568     0.200
     1.014    17.574     0.200
     1.010    17.438     0.200
     1.048    17.846     0.200
     1.205    22.049     0.200
     1.308    21.752     0.200
     1.385    23.467     0.200
     1.595    25.846     0.200
     1.610    26.225     0.200
     1.691    28.039     0.200
     1.691    29.830     0.200
     1.766    29.352     0.200
     2.103    33.170     0.200
     2.105    33.701     0.200
     2.158    34.041     0.200
     2.206    34.803     0.200
     2.207    36.225     0.200
     2.701    41.789     0.200
     2.739    42.150     0.200
     2.771    43.066     0.200
     2.754    41.623     0.200
     3.133    47.922     0.200
     3.213    48.848     0.200
     3.413    52.289     0.200
     3.593    54.277     0.200
     3.630    54.816     0.200
     3.828    58.000     0.200
     3.895    59.402     0.200
     4.077    61.260     0.200
     4.256    64.205     0.200
     4.379    64.600     0.200
     4.451    66.965     0.200
     4.727    71.273     0.200
     5.292    79.590     0.200
     5.473    81.770     0.200
     5.705    85.314     0.200
     6.040    89.502     0.200
     6.448    94.969     0.200
     6.460    96.068     0.200
     6.550    98.229     0.200
     6.571    99.898     0.200
     6.889   100.307     0.200
     7.550   109.840     0.200
     7.597   112.623     0.200
     7.645   111.619     0.200
     7.675   112.104     0.200
     8.059   118.795     0.200
     8.212   119.520     0.200
     9.912   143.855     0.200
     9.921   143.689     0.200
     9.921   143.469     0.200
    10.509   155.947     0.200
    10.554   152.238     0.200
    11.054   158.869     0.200
    11.097   160.199     0.200
    11.255   163.307     0.200
    11.350   162.584     0.200
    11.442   165.000     0.200
    11.529   166.291     0.200
    11.703   169.629     0.200
    12.007   174.594     0.200
    12.184   176.285     0.200
    12.273   177.846     0.200
    12.424   177.424     0.200
    12.631   181.395     0.200
    12.651   183.375     0.200
    13.812   196.236     0.200
    13.862   198.117     0.200
    13.939   199.223     0.200
    14.084   202.049     0.200
    14.205   204.756     0.200
    14.407   206.387     0.200
    14.438   205.879     0.200
    14.461   206.139     0.200
    14.541   207.967     0.200
    15.074   214.430     0.200
    15.089   214.584     0.200
    15.211   216.469     0.200
    20.109   277.049     0.200
    20.494   279.896     0.200
     0.984    16.924     0.200
     1.061    17.945     0.200
     1.059    17.961     0.200
     1.059    17.715     0.200
     1.152    21.016     0.200
     1.161    21.096     0.200
     1.185    21.725     0.200
     1.386    23.195     0.200
     1.340    22.105     0.200
     1.435    24.127     0.200
     1.586    25.660     0.200
     1.651    28.154     0.200
     1.622    26.381     0.200
     1.812    29.750     0.200
     2.129    33.617     0.200
     2.154    34.471     0.200
     2.202    34.850     0.200
     2.194    34.572     0.200
     2.251    36.604     0.200
     2.358    37.477     0.200
     2.708    41.039     0.200
     2.708    41.404     0.200
     2.769    42.477     0.200
     3.178    48.754     0.200
     3.247    49.338     0.200
     3.636    54.906     0.200
     3.870    57.805     0.200
     3.885    58.795     0.200
     3.880    58.787     0.200
     4.126    61.744     0.200
     4.337    64.936     0.200
     4.289    64.414     0.200
     4.491    67.111     0.200
     4.715    70.883     0.200
     4.715    71.295     0.200
     5.304    79.494     0.200
     5.510    82.195     0.200
     5.683    84.855     0.200
     6.081    90.600     0.200
     6.559   100.395     0.200
     6.580   100.664     0.200
     6.850    99.443     0.200
     6.850    99.855     0.200
     8.075   120.516     0.200
     8.183   119.186     0.200
     9.576   142.016     0.200
    11.008   159.766     0.200
    11.063   160.371     0.200
    11.063   161.125     0.200
    11.266   163.035     0.200
    13.533   195.594     0.200
    13.896   200.539     0.200
    15.714   223.312     0.200
    16.037   226.715     0.200
    18.716   262.541     0.200
    20.112   277.508     0.200
    20.942   285.479     0.200
     1.010    17.516     0.200
     1.009    17.246     0.200
     1.044    17.820     0.200
     1.172    21.363     0.200
     1.209    21.992     0.200
     1.303    21.691     0.200
     1.382    23.391     0.200
     1.437    25.512     0.200
     1.592    25.809     0.200
     1.606    26.207     0.200
     1.762    29.336     0.200
     1.695    29.723     0.200
     2.098    33.086     0.200
     2.101    33.773     0.200
     2.154    33.973     0.200
     2.203    34.762     0.200
     2.206    36.125     0.200
     2.696    41.781     0.200
     2.756    41.461     0.200
     3.823    57.562     0.200
     3.857    59.512     0.200
     4.380    64.934     0.200
     4.725    71.012     0.200
     5.468    81.363     0.200
     5.650    83.113     0.200
     5.703    84.832     0.200
     6.546    99.324     0.200
     6.890   100.332     0.200
     7.595   113.004     0.200
     7.644   111.301     0.200
     8.078   119.773     0.200
     8.211   119.621     0.200
     9.919   143.754     0.200
    11.096   162.633     0.200
     0.918    15.463     0.200
     0.918    15.619     0.200
     1.076    18.029     0.200
     1.145    18.961     0.200
     1.298    21.078     0.200
     1.395    22.711     0.200
     1.539    25.152     0.200
     1.551    24.992     0.200
     1.587    27.049     0.200
     1.631    26.180     0.200
     1.899    30.551     0.200
     2.168    34.137     0.200
     2.175    34.074     0.200
     2.345    36.779     0.200
     2.354    38.150     0.200
     2.603    39.277     0.200
     2.915    44.598     0.200
     3.917    60.318     0.200
     3.948    59.809     0.200
     4.238    62.199     0.200
     4.342    66.127     0.200
     4.669    70.289     0.200
     4.669    70.049     0.200
     5.311    79.289     0.200
     5.574    84.139     0.200
     5.619    84.051     0.200
     6.155    92.979     0.200
     6.559    99.539     0.200
     6.579    97.760     0.200
     6.586    99.318     0.200
     6.754    98.125     0.200
     7.439   108.260     0.200
     7.539   111.594     0.200
     7.539   111.729     0.200
     7.631   113.920     0.200
     7.762   113.779     0.200
     7.835   113.520     0.200
     8.044   119.209     0.200
     8.065   119.109     0.200
     8.107   117.834     0.200
     8.107   118.059     0.200
     8.941   130.586     0.200
     9.657   141.199     0.200
     9.657   140.809     0.200
     9.691   141.680     0.200
     9.850   142.156     0.200
     9.850   142.020     0.200
    10.709   154.941     0.200
    10.903   156.459     0.200
    10.976   160.518     0.200
    10.976   159.760     0.200
    11.268   163.816     0.200
    11.408   166.316     0.200
    11.885   173.010     0.200
    11.958   174.721     0.200
    12.094   175.057     0.200
    13.722   197.150     0.200
    13.971   199.965     0.200
    14.296   203.275     0.200
    14.312   203.955     0.200
    14.320   203.189     0.200
    20.673   283.350     0.200
     1.204    21.516     0.200
     1.409    22.738     0.200
     1.437    25.168     0.200
     1.620    27.438     0.200
     1.655    26.512     0.200
     1.835    29.223     0.200
     1.914    30.469     0.200
     2.062    32.910     0.200
     2.168    33.598     0.200
     2.168    32.879     0.200
     2.547    39.559     0.200
     2.801    43.516     0.200
     2.832    44.152     0.200
     4.253    63.938     0.200
     4.288    64.270     0.200
     4.432    66.879     0.200
     4.642    70.949     0.200
     4.642    70.586     0.200
     5.483    81.695     0.200
     5.483    82.348     0.200
     5.537    83.109     0.200
     6.093    89.727     0.200
     6.093    89.938     0.200
     6.400    93.141     0.200
     6.627    96.547     0.200
     6.766   100.559     0.200
     7.501   111.637     0.200
     7.887   116.891     0.200
     8.076   120.688     0.200
     8.079   120.746     0.200
     8.483   123.723     0.200
     8.880   129.848     0.200
    10.452   151.543     0.200
    10.683   157.359     0.200
     1.084    19.945     0.200
     1.182    20.816     0.200
     1.182    21.156     0.200
     1.226    22.066     0.200
     1.381    22.461     0.200
     1.415    24.758     0.200
     1.597    26.805     0.200
     1.633    26.066     0.200
     1.625    26.008     0.200
     1.889    29.746     0.200
     2.185    33.754     0.200
     2.185    33.547     0.200
     2.806    44.227     0.200
     3.656    56.727     0.200
     3.875    57.105     0.200
     4.226    64.527     0.200
     4.258    65.316     0.200
     4.402    66.035     0.200
     5.174    77.707     0.200
     5.256    76.348     0.200
     5.480    82.195     0.200
     5.516    82.246     0.200
     6.066    89.098     0.200
     6.249    91.207     0.200
     6.412    93.617     0.200
     6.727   101.027     0.200
     6.746   102.426     0.200
     7.053   109.324     0.200
     7.070   102.125     0.200
     7.492   110.758     0.200
     7.553   110.527     0.200
     7.733   115.395     0.200
     7.875   113.926     0.200
     7.984   116.887     0.200
     8.065   118.836     0.200
     8.067   119.125     0.200
    10.472   151.645     0.200
    11.439   167.590     0.200
     1.004    17.268     0.200
     1.061    17.963     0.200
     1.287    23.490     0.200
     1.350    24.389     0.200
     1.359    24.010     0.200
     1.396    23.775     0.200
     1.416    23.920     0.200
     1.432    25.479     0.200
     1.474    25.299     0.200
     1.612    26.193     0.200
     1.742    28.135     0.200
     1.892    31.428     0.200
     1.892    31.830     0.200
     1.936    30.574     0.200
     1.936    30.439     0.200
     1.924    30.609     0.200
     2.039    33.820     0.200
     2.083    32.854     0.200
     2.297    37.559     0.200
     2.750    42.312     0.200
     3.430    51.793     0.200
     4.426    67.580     0.200
     4.623    70.650     0.200
     4.962    75.809     0.200
     5.277    79.719     0.200
     5.402    81.729     0.200
     5.649    85.090     0.200
     6.279    92.139     0.200
     6.854   103.959     0.200
     7.053   103.139     0.200
     7.394   107.809     0.200
     7.467   111.420     0.200
     7.756   112.270     0.200
     7.870   116.490     0.200
     7.947   119.500     0.200
     8.003   120.139     0.200
     8.050   120.250     0.200
     8.068   121.219     0.200
     8.084   121.809     0.200
    10.200   148.260     0.200
     0.983    16.438     0.200
     0.983    16.789     0.200
     0.982    16.680     0.200
     1.275    22.410     0.200
     1.290    23.320     0.200
     1.308    22.285     0.200
     1.343    21.512     0.200
     1.367    24.262     0.200
     1.385    23.809     0.200
     1.385    23.691     0.200
     1.556    25.332     0.200
     1.556    25.168     0.200
     1.638    26.281     0.200
     1.759    28.641     0.200
     1.803    29.543     0.200
     1.803    29.590     0.200
     1.827    29.172     0.200
     1.844    29.129     0.200
     1.876    29.840     0.200
     1.883    30.379     0.200
     1.897    30.141     0.200
     1.955    31.012     0.200
     2.005    31.430     0.200
     2.040    32.066     0.200
     2.040    31.871     0.200
     2.118    33.012     0.200
     2.167    34.121     0.200
     2.174    34.191     0.200
     2.212    34.711     0.200
     2.255    35.559     0.200
     2.352    36.883     0.200
     2.524    38.762     0.200
     2.595    40.484     0.200
     2.631    40.680     0.200
     2.695    41.336     0.200
     2.695    41.191     0.200
     2.877    43.750     0.200
     2.971    44.941     0.200
     2.971    45.512     0.200
     2.971    45.551     0.200
     2.959    46.352     0.200
     2.974    45.270     0.200
     3.068    47.402     0.200
     3.147    47.738     0.200
     3.235    49.270     0.200
     3.253    50.859     0.200
     3.373    50.773     0.200
     3.400    51.504     0.200
     3.458    50.984     0.200
     3.628    54.570     0.200
     3.822    57.082     0.200
     3.877    58.199     0.200
     3.877    59.809     0.200
     3.953    58.949     0.200
     4.187    62.039     0.200
     4.280    64.086     0.200
     4.378    64.844     0.200
     4.452    65.250     0.200
     4.478    66.480     0.200
     4.562    66.516     0.200
     4.611    68.281     0.200
     4.643    69.867     0.200
     4.643    69.742     0.200
     4.760    70.660     0.200
     4.905    73.781     0.200
     4.905    72.531     0.200
     4.936    73.078     0.200
     4.940    73.227     0.200
     5.130    76.383     0.200
     5.131    77.379     0.200
     5.195    76.914     0.200
     5.264    79.281     0.200
     5.421    81.242     0.200
     5.477    81.941     0.200
     5.440    81.707     0.200
     5.613    83.539     0.200
     5.627    84.250     0.200
     5.790    87.199     0.200
     5.839    87.082     0.200
     6.231    91.266     0.200
     6.272    92.867     0.200
     6.249    93.949     0.200
     6.272    91.453     0.200
     6.470    96.801     0.200
     6.801   102.902     0.200
     6.801   100.430     0.200
     6.854   101.770     0.200
     6.953   103.281     0.200
     7.110   104.422     0.200
     7.200   105.391     0.200
     7.288   106.281     0.200
     7.454   108.820     0.200
     7.491   110.848     0.200
     7.491   111.121     0.200
     7.760   117.500     0.200
     7.810   112.855     0.200
     7.810   114.082     0.200
     7.810   113.930     0.200
     8.015   118.250     0.200
     8.061   119.691     0.200
     8.085   119.262     0.200
     8.180   120.930     0.200
     8.289   121.203     0.200
     8.339   120.129     0.200
     8.499   125.449     0.200
     8.560   126.902     0.200
     8.813   127.230     0.200
     8.862   128.602     0.200
     8.862   128.902     0.200
     9.063   132.125     0.200
     9.667   142.551     0.200
     9.772   141.719     0.200
     9.973   147.020     0.200
    10.050   147.820     0.200
    10.286   148.430     0.200
    10.286   148.730     0.200
    10.577   152.383     0.200
    10.648   152.949     0.200
    10.675   153.602     0.200
    10.747   153.824     0.200
    10.842   155.434     0.200
    10.877   157.098     0.200
    10.899   157.234     0.200
    11.020   157.258     0.200
    11.004   158.871     0.200
    11.086   160.273     0.200
    11.123   160.438     0.200
    11.252   162.207     0.200
    11.248   160.824     0.200
    11.269   160.715     0.200
    11.330   163.184     0.200
    11.281   162.859     0.200
    11.354   163.414     0.200
    11.346   163.613     0.200
    11.410   164.121     0.200
    11.452   164.613     0.200
    11.483   166.078     0.200
    11.483   167.930     0.200
    11.523   170.082     0.200
    11.524   170.402     0.200
    11.477   165.035     0.200
    11.518   165.387     0.200
    11.532   165.930     0.200
    11.602   166.879     0.200
    11.602   168.242     0.200
    11.719   166.875     0.200
    11.672   168.191     0.200
    11.895   171.336     0.200
    11.962   174.512     0.200
    11.939   172.629     0.200
    11.941   171.934     0.200
    11.945   171.633     0.200
    11.980   173.137     0.200
    12.020   171.965     0.200
    12.030   172.879     0.200
    12.135   173.500     0.200
    12.133   174.191     0.200
    12.119   174.488     0.200
    12.287   180.301     0.200
    12.288   175.969     0.200
    12.314   176.938     0.200
    12.385   178.152     0.200
    12.423   182.680     0.200
    12.489   178.805     0.200
    12.515   178.805     0.200
    12.549   179.301     0.200
    12.561   178.828     0.200
    12.531   179.637     0.200
    12.546   178.996     0.200
    12.567   180.074     0.200
    12.570   180.098     0.200
    12.588   180.484     0.200
    12.628   180.668     0.200
    12.615   180.141     0.200
    12.653   181.789     0.200
    12.685   181.840     0.200
    12.720   182.070     0.200
    12.782   182.652     0.200
    12.782   182.254     0.200
    12.789   182.660     0.200
    12.856   183.000     0.200
    12.844   184.230     0.200
    12.875   183.758     0.200
    12.880   183.926     0.200
    12.976   184.145     0.200
    13.039   185.641     0.200
    13.036   186.035     0.200
    13.109   191.691     0.200
    13.058   186.512     0.200
    13.080   186.719     0.200
    13.126   187.457     0.200
    13.145   186.844     0.200
    13.160   186.977     0.200
    13.182   187.715     0.200
    13.233   187.234     0.200
    13.187   187.516     0.200
    13.189   188.246     0.200
    13.245   189.168     0.200
    13.236   189.113     0.200
    13.251   190.980     0.200
    13.251   189.512     0.200
    13.275   188.684     0.200
    13.277   189.016     0.200
    13.335   190.320     0.200
    13.359   189.855     0.200
    13.371   190.387     0.200
    13.392   190.414     0.200
    13.410   190.773     0.200
    13.421   190.426     0.200
    13.483   196.551     0.200
    13.456   191.500     0.200
    13.483   192.918     0.200
    13.498   191.605     0.200
    13.571   192.414     0.200
    13.549   193.980     0.200
    13.614   193.637     0.200
    13.646   194.523     0.200
    13.693   198.832     0.200
    13.705   199.262     0.200
    13.699   194.504     0.200
    13.690   195.734     0.200
    13.774   200.551     0.200
    13.750   195.977     0.200
    13.750   195.332     0.200
    13.781   196.105     0.200
    13.758   195.836     0.200
    13.795   195.285     0.200
    13.820   196.645     0.200
    13.805   196.574     0.200
    13.808   195.586     0.200
    13.810   196.363     0.200
    13.873   197.281     0.200
    13.874   197.270     0.200
    13.910   196.586     0.200
    13.952   197.777     0.200
    13.963   197.230     0.200
    13.984   199.191     0.200
    14.013   198.754     0.200
    14.009   199.594     0.200
    14.040   199.586     0.200
    14.096   199.906     0.200
    14.117   200.781     0.200
    14.155   200.746     0.200
    14.159   201.395     0.200
    14.192   200.504     0.200
    14.196   201.719     0.200
    14.220   201.992     0.200
    14.241   201.410     0.200
    14.249   202.734     0.200
    14.299   202.492     0.200
    14.395   204.723     0.200
    14.418   204.219     0.200
    14.441   204.957     0.200
    14.442   205.680     0.200
    14.513   203.168     0.200
    14.455   205.227     0.200
    14.466   205.504     0.200
    14.467   205.387     0.200
    14.497   206.047     0.200
    14.492   206.031     0.200
    14.507   206.199     0.200
    14.562   205.770     0.200
    14.586   205.848     0.200
    14.617   207.387     0.200
    14.694   207.578     0.200
    14.704   207.059     0.200
    14.696   207.691     0.200
    14.730   208.965     0.200
    14.709   208.832     0.200
    14.724   207.633     0.200
    14.731   208.617     0.200
    14.751   209.078     0.200
    14.786   209.352     0.200
    14.798   208.355     0.200
    14.824   210.121     0.200
    14.844   208.895     0.200
    14.867   208.832     0.200
    14.900   210.629     0.200
    14.894   210.188     0.200
    14.926   212.016     0.200
    15.031   211.312     0.200
    15.033   212.887     0.200
    15.078   213.984     0.200
    15.099   213.777     0.200
    15.119   213.629     0.200
    15.115   213.879     0.200
    15.137   214.520     0.200
    15.140   213.262     0.200
    15.135   214.273     0.200
    15.158   214.422     0.200
    15.206   213.383     0.200
    15.244   217.262     0.200
    15.223   215.043     0.200
    15.224   214.309     0.200
    15.208   214.867     0.200
    15.202   215.051     0.200
    15.210   215.371     0.200
    15.233   215.328     0.200
    15.330   217.535     0.200
    15.327   215.668     0.200
    15.324   216.613     0.200
    15.350   214.527     0.200
    15.345   216.547     0.200
    15.374   217.039     0.200
    15.421   217.367     0.200
    15.403   216.426     0.200
    15.430   217.480     0.200
    15.476   219.809     0.200
    15.546   219.180     0.200
    15.604   220.195     0.200
    15.617   220.215     0.200
    15.651   220.133     0.200
    15.663   219.434     0.200
    15.652   220.590     0.200
    15.688   221.172     0.200
    15.751   222.016     0.200
    15.756   222.578     0.200
    15.729   223.410     0.200
    15.763   222.629     0.200
    15.750   223.492     0.200
    15.803   222.926     0.200
    15.778   222.398     0.200
    15.793   223.977     0.200
    15.815   223.285     0.200
    15.829   222.508     0.200
    15.833   222.824     0.200
    15.827   222.961     0.200
    15.859   222.816     0.200
    15.868   222.871     0.200
    15.894   223.320     0.200
    15.904   222.340     0.200
    15.944   224.910     0.200
    15.925   223.762     0.200
    15.920   224.914     0.200
    15.947   223.934     0.200
    15.953   224.730     0.200
    15.948   224.785     0.200
    16.078   224.988     0.200
    16.100   226.637     0.200
    16.073   225.621     0.200
    16.110   226.367     0.200
    16.153   226.887     0.200
    16.201   228.098     0.200
    16.176   227.031     0.200
    16.226   228.684     0.200
    16.253   228.988     0.200
    16.273   227.711     0.200
    16.286   229.875     0.200
    16.298   229.582     0.200
    16.316   228.516     0.200
    16.392   230.070     0.200
    16.375   230.391     0.200
    16.418   230.465     0.200
    16.424   230.676     0.200
    16.423   230.652     0.200
    16.432   231.000     0.200
    16.426   230.355     0.200
    16.440   230.969     0.200
    16.477   230.066     0.200
    16.502   231.664     0.200
    16.506   231.797     0.200
    16.501   232.160     0.200
    16.508   231.312     0.200
    16.513   231.191     0.200
    16.613   232.820     0.200
    16.619   232.355     0.200
    16.631   233.602     0.200
    16.642   233.129     0.200
    16.636   233.434     0.200
    16.682   233.703     0.200
    16.690   233.488     0.200
    16.716   234.262     0.200
    16.720   233.273     0.200
    16.725   233.363     0.200
    16.734   234.637     0.200
    16.769   233.957     0.200
    16.786   234.145     0.200
    16.863   236.250     0.200
    16.875   237.449     0.200
    16.964   235.738     0.200
    16.922   237.984     0.200
    16.943   236.852     0.200
    16.986   237.762     0.200
    16.967   236.941     0.200
    16.981   238.441     0.200
    17.002   237.820     0.200
    17.007   238.820     0.200
    17.048   238.293     0.200
    17.034   238.512     0.200
    17.041   238.332     0.200
    17.080   239.051     0.200
    17.096   239.102     0.200
    17.106   239.137     0.200
    17.106   238.613     0.200
    17.125   239.180     0.200
    17.187   239.848     0.200
    17.193   240.305     0.200
    17.185   240.035     0.200
    17.225   239.980     0.200
    17.217   240.227     0.200
    17.338   241.180     0.200
    17.358   242.352     0.200
    17.402   242.746     0.200
    17.419   242.566     0.200
    17.426   243.242     0.200
    17.422   243.629     0.200
    17.463   243.914     0.200
    17.468   243.988     0.200
    17.536   244.656     0.200
    17.531   243.891     0.200
    17.565   244.707     0.200
    17.555   244.672     0.200
    17.566   244.316     0.200
    17.564   245.285     0.200
    17.600   245.320     0.200
    17.638   244.875     0.200
    17.623   245.410     0.200
    17.655   245.488     0.200
    17.660   246.371     0.200
    17.674   246.668     0.200
    17.688   246.598     0.200
    17.724   247.203     0.200
    17.712   246.336     0.200
    17.714   247.137     0.200
    17.728   247.012     0.200
    17.775   247.703     0.200
    17.808   247.043     0.200
    17.816   247.312     0.200
    17.912   248.980     0.200
    17.944   249.566     0.200
    18.031   250.055     0.200
    18.126   251.168     0.200
    18.152   251.660     0.200
    18.160   251.957     0.200
    18.158   251.840     0.200
    18.212   253.031     0.200
    18.286   253.785     0.200
    18.530   256.773     0.200
    18.577   257.289     0.200
    18.738   259.383     0.200
    18.749   259.230     0.200
    19.084   263.137     0.200
    19.106   263.961     0.200
    19.223   265.148     0.200
    19.713   270.781     0.200
    19.792   271.496     0.200
    19.825   271.836     0.200
     0.886    14.803     0.200
     0.941    15.340     0.200
     0.941    16.125     0.200
     1.195    21.154     0.200
     1.195    21.006     0.200
     1.209    20.873     0.200
     1.292    22.926     0.200
     1.477    23.600     0.200
     1.709    28.426     0.200
     1.746    27.564     0.200
     1.916    30.336     0.200
     1.972    30.895     0.200
     2.092    32.293     0.200
     2.092    32.596     0.200
     2.155    33.902     0.200
     2.314    35.764     0.200
     2.497    38.955     0.200
     2.616    39.973     0.200
     2.871    44.336     0.200
     2.891    45.215     0.200
     2.886    44.287     0.200
     3.291    49.500     0.200
     3.367    52.404     0.200
     3.725    56.436     0.200
     3.777    59.016     0.200
     4.313    64.996     0.200
     4.518    66.145     0.200
     5.459    81.756     0.200
     5.578    83.195     0.200
     6.158    90.895     0.200
     7.191   108.086     0.200
     7.847   114.766     0.200
     9.159   135.109     0.200
    10.371   150.365     0.200
     0.907    15.238     0.200
     1.126    20.090     0.200
     1.208    21.209     0.200
     1.206    21.529     0.200
     1.644    26.229     0.200
     1.624    27.121     0.200
     1.654    26.275     0.200
     1.654    26.010     0.200
     1.832    28.748     0.200
     1.909    30.068     0.200
     2.063    32.287     0.200
     2.163    33.213     0.200
     2.163    32.959     0.200
     2.542    38.945     0.200
     2.778    42.646     0.200
     2.827    43.840     0.200
     3.013    45.850     0.200
     3.062    45.760     0.200
     3.280    50.430     0.200
     3.685    55.059     0.200
     4.247    63.799     0.200
     4.288    63.770     0.200
     4.634    69.469     0.200
     5.475    80.680     0.200
     5.531    82.068     0.200
     6.088    89.010     0.200
     6.394    91.998     0.200
     6.759   102.129     0.200
     7.099   105.199     0.200
     7.493   110.770     0.200
     7.880   114.680     0.200
     7.885   116.109     0.200
     8.069   119.059     0.200
     8.475   121.260     0.200
     8.478   123.209     0.200
    11.939   169.289     0.200
    16.053   225.869     0.200
     1.055    20.004     0.200
     1.055    20.104     0.200
     1.016    18.544     0.200
     1.017    17.169     0.200
     1.017    17.784     0.200
     1.051    17.770     0.200
     1.123    21.134     0.200
     1.376    23.563     0.200
     1.757    28.254     0.200
     1.869    31.130     0.200
     1.965    30.889     0.200
     1.912    30.425     0.200
     1.912    30.544     0.200
     2.069    32.826     0.200
     2.090    32.903     0.200
     2.324    37.131     0.200
     2.752    42.293     0.200
     3.008    47.524     0.200
     3.274    52.634     0.200
     3.322    52.114     0.200
     3.431    52.011     0.200
     3.523    53.961     0.200
     3.523    54.474     0.200
     4.432    67.144     0.200
     4.547    69.394     0.200
     4.648    70.875     0.200
     4.677    70.954     0.200
     4.829    73.212     0.200
     4.963    74.655     0.200
     5.199    79.240     0.200
     5.430    82.140     0.200
     5.430    81.964     0.200
     5.663    85.254     0.200
     6.229    91.230     0.200
     6.284    92.930     0.200
     6.284    92.764     0.200
     6.870   101.864     0.200
     7.083   104.424     0.200
     7.461   109.244     0.200
     7.492   111.738     0.200
     7.492   110.684     0.200
     7.786   114.269     0.200
     7.888   117.604     0.200
     7.966   118.994     0.200
     8.092   120.554     0.200
     8.291   119.647     0.200
     8.253   120.264     0.200
     8.327   122.154     0.200
     8.666   128.374     0.200
     8.859   129.287     0.200
     9.004   130.444     0.200
     9.474   137.604     0.200
     9.721   142.074     0.200
     9.879   144.454     0.200
     9.942   145.384     0.200
    10.228   148.201     0.200
    10.541   151.304     0.200
    10.705   154.030     0.200
    10.657   153.794     0.200
    10.903   158.861     0.200
    11.347   162.864     0.200
    11.398   167.373     0.200
    12.200   180.058     0.200
    12.918   186.341     0.200
    13.027   188.530     0.200
    13.041   191.249     0.200
    13.112   189.512     0.200
    13.139   189.678     0.200
    13.183   190.643     0.200
    13.174   193.004     0.200
    13.687   199.294     0.200
    13.755   197.248     0.200
    13.763   197.176     0.200
    13.766   201.174     0.200
    14.709   207.924     0.200
    14.988   210.934     0.200
    15.452   217.954     0.200
    15.679   221.624     0.200
    15.772   222.594     0.200
    16.483   231.094     0.200
    18.177   252.634     0.200
     0.933    15.686     0.200
     1.236    21.980     0.200
     1.261    21.811     0.200
     1.261    21.701     0.200
     1.674    26.599     0.200
     1.678    27.729     0.200
     1.678    27.841     0.200
     1.715    27.188     0.200
     1.889    29.469     0.200
     1.954    30.635     0.200
     2.120    32.878     0.200
     2.594    39.686     0.200
     2.839    43.836     0.200
     2.855    43.851     0.200
     2.873    44.801     0.200
     3.073    50.301     0.200
     3.122    48.451     0.200
     3.268    48.974     0.200
     3.339    52.001     0.200
     3.395    53.421     0.200
     3.717    57.211     0.200
     3.745    58.131     0.200
     3.820    56.211     0.200
     4.294    64.711     0.200
     4.490    67.791     0.200
     4.642    70.119     0.200
     4.801    71.908     0.200
     4.801    72.761     0.200
     5.379    80.631     0.200
     5.470    81.670     0.200
     5.470    80.951     0.200
     5.566    83.031     0.200
     5.801    88.730     0.200
     6.138    90.050     0.200
     6.210    93.331     0.200
     6.360    92.355     0.200
     6.790   100.711     0.200
     7.169   104.631     0.200
     7.160   105.561     0.200
     7.265   106.023     0.200
     7.498   111.641     0.200
     7.518   109.480     0.200
     7.552   109.681     0.200
     7.750   113.521     0.200
     7.817   112.621     0.200
     7.863   114.291     0.200
     7.863   114.671     0.200
     7.909   116.690     0.200
     8.003   119.131     0.200
     8.080   119.161     0.200
     8.086   119.241     0.200
     8.436   121.144     0.200
     8.436   121.431     0.200
     8.463   124.531     0.200
    10.399   150.911     0.200
    10.400   150.315     0.200
    10.650   154.891     0.200
    13.255   190.482     0.200
    13.287   191.374     0.200
    13.339   193.196     0.200
    13.352   192.819     0.200
    13.904   199.420     0.200
     0.914    15.633     0.200
     1.001    16.906     0.200
     1.138    19.023     0.200
     1.248    20.953     0.200
     1.477    23.969     0.200
     1.519    24.359     0.200
     1.598    26.555     0.200
     1.598    27.773     0.200
     1.863    30.984     0.200
     1.864    31.125     0.200
     1.941    30.508     0.200
     1.955    31.117     0.200
     1.985    31.250     0.200
     2.114    33.055     0.200
     2.149    35.148     0.200
     2.195    36.445     0.200
     2.332    36.703     0.200
     2.527    39.000     0.200
     2.571    39.406     0.200
     2.614    40.375     0.200
     2.840    42.219     0.200
     2.852    44.602     0.200
     2.964    44.531     0.200
     3.042    45.812     0.200
     3.248    49.852     0.200
     3.265    49.453     0.200
     3.421    51.453     0.200
     3.469    52.031     0.200
     3.469    52.156     0.200
     3.655    54.758     0.200
     3.702    56.094     0.200
     3.964    59.469     0.200
     4.085    61.461     0.200
     4.085    61.266     0.200
     4.278    64.195     0.200
     4.433    64.773     0.200
     4.658    69.758     0.200
     4.658    69.914     0.200
     4.953    73.836     0.200
     5.093    76.508     0.200
     5.153    77.305     0.200
     5.375    81.070     0.200
     5.457    80.703     0.200
     5.488    81.242     0.200
     5.667    84.023     0.200
     5.867    85.844     0.200
     5.867    86.617     0.200
     6.439    98.188     0.200
     6.562    97.555     0.200
     6.929   100.117     0.200
     6.929    99.992     0.200
     7.525   111.883     0.200
     7.545   110.211     0.200
     7.621   111.664     0.200
     7.652   113.906     0.200
     7.664   115.812     0.200
     7.894   113.664     0.200
     7.894   114.258     0.200
     7.896   116.414     0.200
     7.925   117.320     0.200
     7.929   114.641     0.200
     7.946   114.883     0.200
     8.021   118.516     0.200
     8.195   120.836     0.200
     8.198   119.242     0.200
     8.198   119.633     0.200
     8.895   131.273     0.200
     9.061   129.539     0.200
     9.061   129.727     0.200
     9.843   141.734     0.200
     9.863   141.953     0.200
    11.107   162.672     0.200
    11.119   163.258     0.200
    11.135   158.727     0.200
    11.136   159.141     0.200
    12.447   180.086     0.200
    12.750   185.734     0.200
    15.412   218.992     0.200
    18.727   260.305     0.200
    20.793   283.211     0.200
     1.090    18.396     0.200
     1.177    19.676     0.200
     1.178    20.871     0.200
     1.176    21.031     0.200
     1.265    21.092     0.200
     1.420    23.211     0.200
     1.548    25.145     0.200
     1.574    25.818     0.200
     1.560    27.082     0.200
     1.642    26.633     0.200
     1.931    31.227     0.200
     2.175    33.941     0.200
     2.284    35.400     0.200
     2.289    35.799     0.200
     2.379    37.359     0.200
     2.385    38.697     0.200
     2.571    39.254     0.200
     2.571    39.111     0.200
     2.950    44.791     0.200
     3.196    52.182     0.200
     3.744    56.113     0.200
     4.209    62.312     0.200
     4.661    70.045     0.200
     4.661    70.691     0.200
     4.796    69.781     0.200
     5.212    78.322     0.200
     5.281    83.482     0.200
     5.321    80.191     0.200
     5.604    83.232     0.200
     5.604    84.162     0.200
     6.586    99.572     0.200
     6.727    97.852     0.200
     7.531   111.941     0.200
     7.713   116.971     0.200
     7.790   113.441     0.200
     7.988   118.682     0.200
     8.041   119.322     0.200
     8.060   120.262     0.200
     8.088   118.592     0.200
     8.839   126.342     0.200
     8.931   130.771     0.200
    10.952   159.572     0.200
     0.940    16.258     0.200
     0.940    15.781     0.200
     1.241    22.203     0.200
     1.276    22.383     0.200
     1.276    22.031     0.200
     1.308    23.273     0.200
     1.308    23.121     0.200
     1.469    23.691     0.200
     1.693    28.680     0.200
     1.681    26.988     0.200
     1.731    27.293     0.200
     1.731    27.484     0.200
     1.966    30.863     0.200
     2.140    33.957     0.200
     2.108    32.719     0.200
     2.108    32.512     0.200
     2.314    36.551     0.200
     2.483    39.441     0.200
     2.608    40.445     0.200
     2.630    41.137     0.200
     2.777    42.770     0.200
     2.856    44.145     0.200
     2.905    45.383     0.200
     3.089    49.902     0.200
     3.138    47.824     0.200
     3.355    52.324     0.200
     3.762    58.555     0.200
     3.810    55.965     0.200
     4.307    65.121     0.200
     4.365    65.152     0.200
     4.505    68.031     0.200
     4.644    70.383     0.200
     4.815    72.293     0.200
     5.073    76.031     0.200
     5.386    80.594     0.200
     5.525    85.742     0.200
     5.575    83.281     0.200
     5.746    86.703     0.200
     5.786    86.242     0.200
     6.151    90.684     0.200
     6.216    93.844     0.200
     6.355    97.145     0.200
     6.350    92.504     0.200
     6.698    98.020     0.200
     6.798   100.234     0.200
     6.838   103.203     0.200
     6.824   101.402     0.200
     7.163   104.883     0.200
     7.258   106.664     0.200
     7.499   109.832     0.200
     7.512   109.512     0.200
     7.546   109.254     0.200
     7.753   117.324     0.200
     7.824   113.422     0.200
     7.858   114.895     0.200
     7.915   115.473     0.200
     8.050   119.465     0.200
     8.082   119.844     0.200
     8.089   120.082     0.200
     8.147   120.914     0.200
     8.171   120.555     0.200
     8.233   119.273     0.200
     8.347   125.312     0.200
     8.373   126.262     0.200
     8.425   121.043     0.200
     8.469   125.102     0.200
     8.538   123.703     0.200
     8.875   129.562     0.200
     8.904   132.062     0.200
     8.948   133.094     0.200
     9.172   136.488     0.200
     9.658   141.332     0.200
     9.776   144.465     0.200
     9.704   143.094     0.200
     9.755   143.555     0.200
     9.749   141.465     0.200
     9.779   142.602     0.200
     9.857   145.242     0.200
    10.219   148.914     0.200
    10.386   150.344     0.200
    10.387   150.066     0.200
    10.490   155.781     0.200
    10.568   157.133     0.200
    10.642   155.492     0.200
    10.901   159.402     0.200
    11.064   162.754     0.200
    11.221   165.184     0.200
    11.221   166.102     0.200
    11.215   166.055     0.200
    11.375   167.715     0.200
    11.431   168.914     0.200
    11.475   167.691     0.200
    11.490   166.582     0.200
    11.490   165.789     0.200
    11.661   167.652     0.200
    11.688   170.293     0.200
    11.983   174.422     0.200
    12.022   175.133     0.200
    12.336   181.344     0.200
    12.406   180.691     0.200
    12.539   179.152     0.200
    12.742   187.164     0.200
    12.761   186.844     0.200
    12.907   188.621     0.200
    13.222   192.293     0.200
    13.318   194.543     0.200
    13.341   192.941     0.200
    13.590   197.895     0.200
    13.734   198.012     0.200
    14.818   212.172     0.200
    14.884   212.555     0.200
    15.112   215.652     0.200
    15.171   215.965     0.200
    15.260   216.883     0.200
    18.646   261.055     0.200
    20.486   280.793     0.200
    20.968   284.512     0.200
     0.933    15.701     0.200
     0.933    16.137     0.200
     1.055    17.611     0.200
     1.102    18.264     0.200
     1.180    21.086     0.200
     1.183    21.027     0.200
     1.196    21.127     0.200
     1.190    21.377     0.200
     1.341    23.676     0.200
     1.360    22.143     0.200
     1.494    24.439     0.200
     1.551    24.918     0.200
     1.600    27.326     0.200
     1.612    25.893     0.200
     1.806    30.268     0.200
     1.855    30.010     0.200
     1.869    31.166     0.200
     2.022    33.256     0.200
     2.059    33.916     0.200
     2.139    33.281     0.200
     2.220    34.408     0.200
     2.317    37.363     0.200
     2.425    39.197     0.200
     2.474    39.807     0.200
     2.499    39.457     0.200
     2.627    42.018     0.200
     2.642    39.725     0.200
     2.642    39.486     0.200
     2.766    43.967     0.200
     2.773    41.896     0.200
     3.256    50.887     0.200
     3.518    53.002     0.200
     3.673    54.709     0.200
     3.727    55.539     0.200
     3.727    57.697     0.200
     3.765    58.166     0.200
     3.890    58.756     0.200
     4.273    62.496     0.200
     4.308    65.857     0.200
     4.522    67.375     0.200
     4.674    70.287     0.200
     4.674    70.607     0.200
     5.294    79.477     0.200
     5.633    84.051     0.200
     5.633    84.197     0.200
     5.695    84.877     0.200
     6.565   100.506     0.200
     6.661    99.117     0.200
     6.786    98.486     0.200
     7.462   109.197     0.200
     7.545   111.967     0.200
     7.545   110.947     0.200
     7.618   112.146     0.200
     7.753   114.506     0.200
     7.836   113.797     0.200
     7.858   114.227     0.200
     7.955   118.107     0.200
     8.043   118.916     0.200
     8.066   120.207     0.200
     8.128   118.637     0.200
     8.902   127.977     0.200
     8.947   130.367     0.200
     8.947   130.787     0.200
    11.002   161.117     0.200
     1.177    22.115     0.200
     1.178    22.125     0.200
     1.224    21.736     0.200
     1.224    21.896     0.200
     1.216    22.406     0.200
     1.278    23.225     0.200
     1.434    23.648     0.200
     1.456    25.076     0.200
     1.640    27.797     0.200
     1.681    27.111     0.200
     1.861    30.434     0.200
     1.938    31.559     0.200
     2.086    33.557     0.200
     2.154    33.736     0.200
     2.303    36.553     0.200
     2.572    40.424     0.200
     2.852    44.102     0.200
     3.036    48.936     0.200
     3.084    49.826     0.200
     3.708    54.865     0.200
     3.852    56.996     0.200
     4.276    64.965     0.200
     4.651    69.869     0.200
     4.651    71.135     0.200
     5.487    81.766     0.200
     6.391    93.285     0.200
     6.654   100.061     0.200
     6.784    98.285     0.200
     7.193   105.445     0.200
     7.509   111.246     0.200
     7.577   109.926     0.200
     7.886   115.586     0.200
     8.469   122.006     0.200
    10.436   151.086     0.200
    13.386   192.295     0.200
     1.027    17.344     0.200
     1.027    17.445     0.200
     1.099    18.508     0.200
     1.099    18.328     0.200
     1.120    18.641     0.200
     1.393    22.711     0.200
     1.456    24.133     0.200
     1.603    27.516     0.200
     1.604    27.094     0.200
     1.639    26.500     0.200
     1.680    26.969     0.200
     1.850    30.172     0.200
     1.828    29.078     0.200
     2.185    34.047     0.200
     2.239    36.336     0.200
     2.245    35.000     0.200
     2.716    41.070     0.200
     2.716    41.227     0.200
     2.787    42.828     0.200
     2.785    42.773     0.200
     2.850    43.852     0.200
     3.012    46.703     0.200
     3.217    48.758     0.200
     3.488    53.047     0.200
     3.679    55.117     0.200
     3.710    55.539     0.200
     3.942    59.883     0.200
     4.160    62.977     0.200
     4.356    64.266     0.200
     4.852    73.305     0.200
     4.919    73.805     0.200
     5.345    79.523     0.200
     5.363    80.516     0.200
     5.738    85.266     0.200
     5.727    85.484     0.200
     6.544    96.773     0.200
     6.638    97.656     0.200
     6.873   100.109     0.200
     8.154   119.086     0.200
     0.939    15.711     0.200
     0.939    15.828     0.200
     1.172    20.297     0.200
     1.415    23.320     0.200
     1.457    23.508     0.200
     1.672    27.797     0.200
     1.713    27.242     0.200
     1.889    29.641     0.200
     1.957    30.883     0.200
     2.127    32.906     0.200
     2.593    40.102     0.200
     2.876    44.969     0.200
     3.124    48.898     0.200
     3.270    49.172     0.200
     3.339    49.891     0.200
     3.494    52.875     0.200
     3.828    56.039     0.200
     3.828    56.242     0.200
     3.916    59.203     0.200
     4.297    64.180     0.200
     4.650    70.312     0.200
     4.650    70.125     0.200
     4.898    73.875     0.200
     5.044    74.969     0.200
     5.191    77.125     0.200
     5.478    81.602     0.200
     5.478    81.500     0.200
     5.542    81.359     0.200
     5.571    82.461     0.200
     5.781    89.383     0.200
     6.140    90.000     0.200
     6.140    90.195     0.200
     6.363    96.859     0.200
     6.368    92.297     0.200
     6.795    98.891     0.200
     7.177   105.055     0.200
     7.273   106.773     0.200
     7.506   110.891     0.200
     7.527   109.234     0.200
     7.560   109.812     0.200
     7.872   114.492     0.200
     8.444   121.430     0.200
     8.444   120.883     0.200
     8.883   129.133     0.200
     8.883   129.625     0.200
    10.406   150.453     0.200
    10.658   157.219     0.200
     1.035    17.391     0.200
     1.035    17.230     0.200
     1.082    18.199     0.200
     1.334    24.078     0.200
     1.358    24.379     0.200
     1.395    24.391     0.200
     1.408    24.102     0.200
     1.418    25.199     0.200
     1.480    25.910     0.200
     1.480    25.168     0.200
     1.640    26.449     0.200
     1.773    28.250     0.200
     1.899    32.008     0.200
     1.944    30.910     0.200
     1.944    30.660     0.200
     1.942    30.379     0.200
     1.942    30.230     0.200
     2.099    33.324     0.200
     2.113    33.297     0.200
     2.356    37.477     0.200
     2.396    37.660     0.200
     2.695    42.281     0.200
     2.751    42.781     0.200
     2.779    42.926     0.200
     2.970    45.504     0.200
     3.032    47.559     0.200
     3.072    47.887     0.200
     3.111    48.586     0.200
     3.245    50.109     0.200
     3.306    52.070     0.200
     3.354    53.629     0.200
     3.458    52.480     0.200
     3.501    52.629     0.200
     3.553    53.172     0.200
     3.553    53.898     0.200
     3.665    55.113     0.200
     3.665    53.699     0.200
     3.729    56.070     0.200
     3.921    58.273     0.200
     3.926    62.719     0.200
     3.974    59.344     0.200
     3.978    59.965     0.200
     3.978    60.949     0.200
     4.052    61.262     0.200
     4.456    67.219     0.200
     4.474    66.852     0.200
     4.579    68.539     0.200
     4.579    67.469     0.200
     4.654    69.703     0.200
     4.651    70.629     0.200
     4.651    70.270     0.200
     4.674    69.340     0.200
     4.674    68.738     0.200
     4.708    69.598     0.200
     4.990    74.852     0.200
     5.037    75.453     0.200
     5.231    78.383     0.200
     5.289    79.242     0.200
     5.317    80.340     0.200
     5.317    80.688     0.200
     5.426    81.379     0.200
     5.426    81.238     0.200
     5.471    82.395     0.200
     5.517    81.898     0.200
     5.632    84.375     0.200
     6.210    90.367     0.200
     6.210    90.180     0.200
     6.309    93.188     0.200
     6.309    93.020     0.200
     6.895   102.035     0.200
     7.054   102.598     0.200
     7.071   103.988     0.200
     7.448   108.578     0.200
     7.494   110.285     0.200
     7.775   112.285     0.200
     7.775   112.926     0.200
     8.113   119.508     0.200
     8.269   119.359     0.200
     8.269   118.898     0.200
     8.346   123.727     0.200
     8.858   129.551     0.200
     8.964   133.430     0.200
     8.964   130.840     0.200
     9.104   131.938     0.200
     9.714   142.418     0.200
     9.718   141.949     0.200
     9.718   140.391     0.200
     9.795   145.020     0.200
     9.959   143.301     0.200
    10.168   149.758     0.200
    10.202   147.383     0.200
    10.526   153.707     0.200
    10.526   151.988     0.200
    10.647   155.016     0.200
    10.687   154.668     0.200
    10.752   158.719     0.200
    10.812   158.242     0.200
    10.906   158.934     0.200
    10.906   158.348     0.200
    11.118   163.430     0.200
    11.167   161.980     0.200
    11.214   163.551     0.200
    11.372   166.359     0.200
    11.429   168.062     0.200
    11.498   167.809     0.200
    11.517   168.973     0.200
    11.517   169.398     0.200
    11.557   167.535     0.200
    11.557   165.090     0.200
    11.574   168.801     0.200
    11.574   167.008     0.200
    11.790   170.121     0.200
    12.046   174.891     0.200
    12.173   177.570     0.200
    12.230   179.246     0.200
    12.282   177.320     0.200
    12.303   179.883     0.200
    12.303   177.840     0.200
    12.461   180.727     0.200
    12.481   181.074     0.200
    12.510   180.898     0.200
    12.549   181.273     0.200
    12.589   181.891     0.200
    12.589   180.449     0.200
    12.756   183.789     0.200
    12.757   183.555     0.200
    12.835   184.820     0.200
    12.835   182.969     0.200
    12.867   186.984     0.200
    13.061   189.855     0.200
    13.072   190.145     0.200
    13.083   189.555     0.200
    13.083   185.730     0.200
    13.177   190.062     0.200
    13.177   188.320     0.200
    13.335   191.703     0.200
    13.376   192.137     0.200
    13.448   192.977     0.200
    13.568   194.766     0.200
    13.606   196.371     0.200
    13.624   196.148     0.200
    13.667   196.594     0.200
    13.697   196.520     0.200
    13.733   196.207     0.200
    13.750   196.977     0.200
    13.750   195.391     0.200
    13.741   196.047     0.200
    13.743   196.266     0.200
    13.830   196.867     0.200
    13.817   197.152     0.200
    13.831   196.719     0.200
    13.908   199.059     0.200
    13.930   199.629     0.200
    13.946   198.512     0.200
    13.960   199.980     0.200
    13.974   199.555     0.200
    14.003   200.406     0.200
    14.044   201.043     0.200
    14.036   201.355     0.200
    14.087   201.398     0.200
    14.076   201.754     0.200
    14.105   201.523     0.200
    14.172   203.027     0.200
    14.178   203.258     0.200
    14.203   202.137     0.200
    14.267   203.562     0.200
    14.374   204.785     0.200
    14.391   205.207     0.200
    14.392   204.383     0.200
    14.415   205.129     0.200
    14.404   205.152     0.200
    14.412   205.719     0.200
    14.418   206.285     0.200
    14.421   204.961     0.200
    14.421   205.938     0.200
    14.455   205.613     0.200
    14.447   208.660     0.200
    14.560   206.832     0.200
    14.606   207.879     0.200
    14.659   208.914     0.200
    14.677   208.812     0.200
    14.720   208.773     0.200
    14.764   209.344     0.200
    14.778   209.445     0.200
    14.778   209.070     0.200
    14.819   209.840     0.200
    14.843   210.199     0.200
    14.859   209.859     0.200
    14.859   208.871     0.200
    14.922   211.711     0.200
    14.968   213.273     0.200
    14.968   211.180     0.200
    14.970   212.844     0.200
    15.007   214.320     0.200
    15.050   215.066     0.200
    15.069   214.109     0.200
    15.073   213.941     0.200
    15.073   213.340     0.200
    15.087   214.020     0.200
    15.083   214.512     0.200
    15.089   215.133     0.200
    15.115   213.617     0.200
    15.136   216.129     0.200
    15.133   213.168     0.200
    15.158   214.508     0.200
    15.169   216.859     0.200
    15.244   216.480     0.200
    15.273   215.680     0.200
    15.319   216.555     0.200
    15.357   216.609     0.200
    15.351   216.930     0.200
    15.394   218.309     0.200
    15.427   218.086     0.200
    15.445   218.484     0.200
    15.499   219.590     0.200
    15.550   219.617     0.200
    15.569   219.879     0.200
    15.608   221.047     0.200
    15.654   221.859     0.200
    15.642   222.887     0.200
    15.666   222.461     0.200
    15.679   223.348     0.200
    15.717   222.887     0.200
    15.716   223.957     0.200
    15.750   223.879     0.200
    15.750   223.961     0.200
    15.767   223.688     0.200
    15.780   223.246     0.200
    15.769   223.504     0.200
    15.793   223.609     0.200
    15.797   223.820     0.200
    15.854   223.469     0.200
    15.864   224.148     0.200
    15.867   223.961     0.200
    15.875   224.582     0.200
    15.898   225.207     0.200
    15.899   224.938     0.200
    15.927   225.035     0.200
    15.970   226.105     0.200
    16.026   226.297     0.200
    16.067   226.402     0.200
    16.073   226.621     0.200
    16.141   228.156     0.200
    16.141   228.848     0.200
    16.172   228.949     0.200
    16.190   228.395     0.200
    16.213   230.090     0.200
    16.256   229.250     0.200
    16.280   228.656     0.200
    16.292   229.344     0.200
    16.332   229.988     0.200
    16.340   231.172     0.200
    16.362   231.375     0.200
    16.362   230.820     0.200
    16.373   231.016     0.200
    16.399   231.562     0.200
    16.452   231.824     0.200
    16.469   232.738     0.200
    16.469   232.090     0.200
    16.474   232.023     0.200
    16.474   233.008     0.200
    16.470   231.805     0.200
    16.592   233.543     0.200
    16.591   234.250     0.200
    16.595   233.398     0.200
    16.599   233.391     0.200
    16.661   235.062     0.200
    16.669   234.254     0.200
    16.674   234.562     0.200
    16.683   235.762     0.200
    16.735   234.141     0.200
    16.732   235.688     0.200
    16.791   236.582     0.200
    16.812   237.445     0.200
    16.805   237.336     0.200
    16.858   237.855     0.200
    16.855   237.113     0.200
    16.886   237.801     0.200
    16.925   237.941     0.200
    16.940   237.570     0.200
    16.944   237.977     0.200
    16.969   238.160     0.200
    16.990   238.898     0.200
    17.017   239.141     0.200
    17.084   239.398     0.200
    17.120   240.699     0.200
    17.135   240.254     0.200
    17.170   240.230     0.200
    17.178   241.477     0.200
    17.187   241.078     0.200
    17.323   242.914     0.200
    17.357   243.164     0.200
    17.357   241.238     0.200
    17.365   243.141     0.200
    17.386   243.836     0.200
    17.400   244.105     0.200
    17.415   243.988     0.200
    17.498   245.344     0.200
    17.554   246.168     0.200
    17.567   246.227     0.200
    17.579   245.984     0.200
    17.656   247.367     0.200
    17.717   248.086     0.200
    17.721   248.324     0.200
    17.793   248.570     0.200
    17.838   249.445     0.200
    17.840   249.031     0.200
    17.928   250.008     0.200
    18.052   252.172     0.200
    18.088   252.570     0.200
    18.093   252.727     0.200
    18.129   252.336     0.200
    18.139   252.418     0.200
    18.161   252.660     0.200
    18.199   253.691     0.200
    18.197   253.664     0.200
    18.253   253.691     0.200
    18.311   255.219     0.200
    18.368   255.094     0.200
    18.387   255.898     0.200
    18.411   255.957     0.200
    18.521   258.168     0.200
    18.561   258.379     0.200
    18.742   260.828     0.200
    18.746   261.043     0.200
    18.752   260.680     0.200
    18.774   260.918     0.200
    18.763   261.160     0.200
    18.886   262.102     0.200
    18.898   262.527     0.200
    18.974   264.105     0.200
    18.999   263.195     0.200
    19.025   264.141     0.200
    19.067   264.836     0.200
    19.088   264.371     0.200
    19.143   265.773     0.200
    19.217   266.629     0.200
    19.249   266.723     0.200
    19.258   266.367     0.200
    19.285   266.969     0.200
    19.344   267.297     0.200
    19.481   269.672     0.200
    19.503   269.707     0.200
    19.699   271.836     0.200
    19.699   271.598     0.200
    19.732   272.422     0.200
    19.820   272.965     0.200
    20.666   282.242     0.200
    20.722   282.750     0.200
    20.728   283.410     0.200
    20.788   284.266     0.200
    20.809   284.250     0.200
     0.931    15.531     0.200
     0.973    16.297     0.200
     1.249    21.625     0.200
     1.248    21.211     0.200
     1.323    23.047     0.200
     1.325    22.688     0.200
     1.325    22.945     0.200
     1.521    24.328     0.200
     1.548    26.227     0.200
     1.556    26.102     0.200
     1.599    25.789     0.200
     1.622    26.219     0.200
     1.671    27.891     0.200
     1.715    27.609     0.200
     1.715    27.180     0.200
     1.715    27.031     0.200
     1.743    28.781     0.200
     1.743    28.750     0.200
     1.771    28.578     0.200
     1.790    28.109     0.200
     1.790    27.805     0.200
     1.790    28.211     0.200
     1.820    29.250     0.200
     1.824    29.898     0.200
     1.841    29.547     0.200
     1.961    30.578     0.200
     2.013    31.492     0.200
     2.074    32.430     0.200
     2.071    32.133     0.200
     2.109    33.570     0.200
     2.116    33.625     0.200
     2.155    34.141     0.200
     2.196    34.555     0.200
     2.346    36.273     0.200
     2.493    38.336     0.200
     2.597    40.156     0.200
     2.660    40.648     0.200
     2.671    41.023     0.200
     2.833    43.336     0.200
     2.914    44.688     0.200
     2.913    44.789     0.200
     2.914    44.984     0.200
     2.932    45.328     0.200
     2.955    45.211     0.200
     3.008    46.852     0.200
     3.146    48.508     0.200
     3.160    47.961     0.200
     3.341    51.289     0.200
     3.336    49.758     0.200
     3.412    51.812     0.200
     3.412    52.711     0.200
     3.468    53.008     0.200
     3.761    56.305     0.200
     3.776    56.289     0.200
     3.776    57.836     0.200
     3.781    55.297     0.200
     3.781    55.500     0.200
     3.818    58.258     0.200
     3.818    59.891     0.200
     3.901    59.148     0.200
     3.910    58.906     0.200
     4.127    61.945     0.200
     4.223    63.312     0.200
     4.330    64.773     0.200
     4.355    65.625     0.200
     4.392    65.953     0.200
     4.423    65.742     0.200
     4.423    65.891     0.200
     4.563    68.469     0.200
     4.658    70.258     0.200
     4.658    70.070     0.200
     4.834    71.297     0.200
     4.868    72.469     0.200
     4.868    72.875     0.200
     4.880    73.047     0.200
     5.151    77.250     0.200
     5.418    81.266     0.200
     5.468    81.266     0.200
     5.468    81.617     0.200
     5.614    83.609     0.200
     5.814    87.375     0.200
     6.201    90.961     0.200
     6.323    91.719     0.200
     6.323    91.609     0.200
     6.398    96.180     0.200
     6.755    98.461     0.200
     6.832   102.039     0.200
     7.150   104.680     0.200
     7.215   106.445     0.200
     7.242   105.867     0.200
     7.242   106.008     0.200
     7.496   109.258     0.200
     7.510   110.828     0.200
     7.510   111.070     0.200
     7.531   109.484     0.200
     7.771   117.078     0.200
     7.848   114.117     0.200
     7.848   114.570     0.200
     7.856   115.445     0.200
     7.943   116.797     0.200
     8.025   118.047     0.200
     8.070   119.258     0.200
     8.098   119.906     0.200
     8.107   119.969     0.200
     8.178   120.438     0.200
     8.208   122.367     0.200
     8.273   123.406     0.200
     8.393   120.609     0.200
     8.498   124.789     0.200
     8.587   123.633     0.200
     8.587   124.641     0.200
     8.883   129.289     0.200
     8.883   129.609     0.200
     8.946   129.320     0.200
     8.979   129.445     0.200
     9.718   143.102     0.200
     9.719   141.867     0.200
     9.777   142.188     0.200
     9.777   143.852     0.200
     9.820   142.320     0.200
     9.895   142.297     0.200
    10.218   151.578     0.200
    10.344   149.258     0.200
    10.345   149.836     0.200
    10.623   155.156     0.200
    10.622   157.008     0.200
    10.915   157.891     0.200
    10.915   159.008     0.200
    11.102   162.320     0.200
    11.265   165.617     0.200
    11.279   165.445     0.200
    11.279   164.570     0.200
    11.421   167.617     0.200
    11.493   166.258     0.200
    11.524   166.711     0.200
    11.524   166.680     0.200
    11.524   165.406     0.200
    11.726   170.586     0.200
    11.843   171.820     0.200
    12.021   173.148     0.200
    12.117   174.828     0.200
    12.564   176.781     0.200
    12.768   186.328     0.200
    12.947   184.727     0.200
    12.970   189.617     0.200
    13.015   188.359     0.200
    13.081   186.352     0.200
    13.195   187.055     0.200
    13.306   191.336     0.200
    13.361   193.906     0.200
    13.732   196.789     0.200
    13.771   197.695     0.200
    13.771   198.180     0.200
    13.832   200.602     0.200
    13.859   196.992     0.200
    13.899   202.109     0.200
    14.161   199.648     0.200
    14.714   208.586     0.200
    14.841   209.445     0.200
    14.841   209.648     0.200
    14.906   210.188     0.200
    15.426   218.047     0.200
    15.948   224.367     0.200
    15.970   223.891     0.200
    16.095   226.820     0.200
    16.095   227.602     0.200
    16.161   227.727     0.200
    16.168   228.086     0.200
    16.403   230.812     0.200
    16.555   232.188     0.200
    16.674   234.375     0.200
    16.726   234.969     0.200
    16.776   235.305     0.200
    16.790   235.906     0.200
    17.101   238.805     0.200
    17.810   247.172     0.200
    17.813   247.547     0.200
    18.258   253.133     0.200
    18.582   257.766     0.200
    18.656   258.711     0.200
    18.656   260.430     0.200
    18.740   259.109     0.200
    18.740   259.375     0.200
    18.794   259.750     0.200
     0.909    15.564     0.200
     1.160    19.670     0.200
     1.249    22.254     0.200
     1.249    22.094     0.200
     1.257    21.914     0.200
     1.257    21.803     0.200
     1.259    22.424     0.200
     1.295    21.035     0.200
     1.288    22.133     0.200
     1.346    23.963     0.200
     1.346    23.453     0.200
     1.347    23.533     0.200
     1.347    24.023     0.200
     1.394    24.613     0.200
     1.448    25.303     0.200
     1.481    23.877     0.200
     1.630    25.654     0.200
     1.695    27.750     0.200
     1.757    27.684     0.200
     1.777    28.092     0.200
     2.060    31.898     0.200
     2.081    32.570     0.200
     2.375    37.053     0.200
     2.433    37.760     0.200
     2.435    37.615     0.200
     2.900    44.240     0.200
     3.730    55.104     0.200
     4.370    64.203     0.200
     4.458    67.043     0.200
     5.969    87.863     0.200
     6.262    91.273     0.200
     6.553    97.477     0.200
     7.067   105.143     0.200
     7.317   108.123     0.200
     7.719   114.104     0.200
     7.719   111.504     0.200
     8.353   122.229     0.200
     8.355   119.014     0.200
     9.559   138.264     0.200
    10.357   149.529     0.200
    10.529   152.494     0.200
    11.290   164.453     0.200
     1.227    21.766     0.200
     1.253    21.727     0.200
     1.296    21.062     0.200
     1.333    23.695     0.200
     1.334    23.680     0.200
     1.334    24.039     0.200
     1.358    23.945     0.200
     1.411    24.617     0.200
     1.502    23.945     0.200
     1.611    25.070     0.200
     1.611    25.336     0.200
     1.611    25.180     0.200
     1.661    27.109     0.200
     1.749    27.188     0.200
     1.786    27.953     0.200
     2.055    32.227     0.200
     2.096    32.227     0.200
     2.136    32.664     0.200
     2.436    37.055     0.200
     2.447    37.852     0.200
     2.621    40.031     0.200
     2.756    41.836     0.200
     2.859    43.922     0.200
     2.867    44.000     0.200
     3.113    46.273     0.200
     3.204    47.750     0.200
     3.403    51.445     0.200
     3.626    54.344     0.200
     3.767    54.961     0.200
     4.490    67.695     0.200
     4.572    68.320     0.200
     4.976    72.719     0.200
     5.339    79.492     0.200
     5.974    86.930     0.200
     5.974    87.180     0.200
     6.300    91.203     0.200
     6.300    91.516     0.200
     6.545    95.891     0.200
     6.743   101.445     0.200
     7.350   108.797     0.200
     7.923   117.102     0.200
     7.926   117.180     0.200
     8.051   117.617     0.200
     8.360   125.070     0.200
     8.360   123.766     0.200
     8.392   120.078     0.200
     9.546   138.641     0.200
     9.675   140.969     0.200
    10.392   149.391     0.200
    10.567   154.156     0.200
    11.038   161.031     0.200
    11.085   161.734     0.200
    11.194   163.867     0.200
    11.311   167.016     0.200
    11.574   166.117     0.200
    11.802   169.625     0.200
    13.315   190.625     0.200
    14.546   205.594     0.200
    15.064   212.812     0.200
     0.853    15.932     0.200
     1.057    17.727     0.200
     1.167    19.281     0.200
     1.167    19.141     0.200
     1.278    21.701     0.200
     1.397    22.654     0.200
     1.511    24.324     0.200
     1.577    25.463     0.200
     1.584    27.092     0.200
     1.584    26.621     0.200
     1.585    27.221     0.200
     1.585    26.682     0.200
     1.608    25.811     0.200
     1.655    26.650     0.200
     1.921    30.875     0.200
     2.332    36.195     0.200
     2.406    38.137     0.200
     2.505    39.922     0.200
     2.552    38.703     0.200
     2.629    40.400     0.200
     2.823    43.301     0.200
     2.907    44.201     0.200
     3.199    50.842     0.200
     3.798    58.381     0.200
     3.963    59.412     0.200
     4.000    60.752     0.200
     4.185    62.508     0.200
     4.185    62.041     0.200
     4.341    65.832     0.200
     4.623    70.381     0.200
     4.738    71.471     0.200
     4.833    72.381     0.200
     5.176    77.650     0.200
     5.181    76.980     0.200
     5.489    82.801     0.200
     5.567    84.002     0.200
     5.568    82.898     0.200
     5.568    83.451     0.200
     6.015    90.361     0.200
     6.700    97.477     0.200
     7.385   108.592     0.200
     7.494   111.264     0.200
     7.676   113.291     0.200
     7.758   112.912     0.200
     7.890   113.391     0.200
     7.915   117.182     0.200
     7.916   117.102     0.200
     7.950   117.951     0.200
     8.022   119.111     0.200
     8.054   117.244     0.200
     8.054   117.820     0.200
     8.084   115.961     0.200
     8.277   120.162     0.200
     8.674   125.381     0.200
     8.814   126.791     0.200
     8.814   126.980     0.200
     8.894   129.623     0.200
     8.894   130.051     0.200
     9.620   140.541     0.200
     9.802   142.191     0.200
    10.767   156.551     0.200
    10.922   159.615     0.200
    10.922   160.641     0.200
     0.972    16.218     0.200
     0.998    16.690     0.200
     1.079    20.127     0.200
     1.079    20.117     0.200
     1.557    24.933     0.200
     1.739    27.314     0.200
     1.778    29.166     0.200
     1.823    28.847     0.200
     1.831    29.005     0.200
     2.047    31.774     0.200
     2.047    31.437     0.200
     3.761    57.267     0.200
     4.603    69.907     0.200
     4.668    70.067     0.200
     6.236    92.717     0.200
     6.304    91.327     0.200
     8.120   119.947     0.200
    10.608   152.757     0.200
     0.950    16.062     0.200
     0.979    16.281     0.200
     1.269    21.617     0.200
     1.262    22.484     0.200
     1.345    23.305     0.200
     1.336    23.445     0.200
     1.385    22.562     0.200
     1.535    24.641     0.200
     1.720    27.219     0.200
     1.720    27.438     0.200
     1.764    28.539     0.200
     1.803    28.586     0.200
     1.810    28.547     0.200
     1.978    30.977     0.200
     2.025    31.586     0.200
     2.053    31.836     0.200
     2.217    34.711     0.200
     2.350    36.250     0.200
     2.593    40.602     0.200
     2.675    40.633     0.200
     2.680    40.695     0.200
     3.116    47.586     0.200
     3.166    48.164     0.200
     3.167    48.758     0.200
     3.430    52.445     0.200
     3.903    59.086     0.200
     4.367    65.828     0.200
     4.444    66.469     0.200
     4.582    67.625     0.200
     4.655    70.273     0.200
     4.883    72.906     0.200
     4.927    73.977     0.200
     5.020    74.344     0.200
     5.137    76.672     0.200
     5.262    78.562     0.200
     5.461    81.352     0.200
     5.621    83.695     0.200
     5.818    86.203     0.200
     6.214    91.672     0.200
     6.403    95.578     0.200
     6.488    95.227     0.200
     7.535   107.688     0.200
    10.324   149.297     0.200
    14.305   205.508     0.200
     1.048    17.863     0.200
     1.146    19.434     0.200
     1.153    19.508     0.200
     1.153    19.363     0.200
     1.204    21.492     0.200
     1.217    21.660     0.200
     1.222    21.742     0.200
     1.292    21.230     0.200
     1.384    22.953     0.200
     1.508    24.574     0.200
     1.563    25.645     0.200
     1.600    26.012     0.200
     1.596    27.492     0.200
     1.597    27.480     0.200
     1.663    26.953     0.200
     1.907    30.488     0.200
     2.149    33.695     0.200
     2.133    33.617     0.200
     2.250    35.086     0.200
     2.273    35.816     0.200
     2.325    36.684     0.200
     2.396    38.031     0.200
     2.474    38.457     0.200
     2.496    39.844     0.200
     2.511    40.961     0.200
     2.564    41.133     0.200
     2.563    39.062     0.200
     2.631    40.543     0.200
     2.803    42.941     0.200
     2.810    42.941     0.200
     2.810    43.094     0.200
     2.902    44.773     0.200
     2.931    44.730     0.200
     3.155    49.012     0.200
     3.185    49.230     0.200
     3.248    50.641     0.200
     3.270    49.535     0.200
     3.583    54.141     0.200
     3.715    55.848     0.200
     3.784    56.809     0.200
     3.784    57.043     0.200
     3.894    59.480     0.200
     3.949    59.332     0.200
     4.003    60.512     0.200
     4.110    61.961     0.200
     4.194    61.512     0.200
     4.329    65.145     0.200
     4.329    65.461     0.200
     4.440    67.023     0.200
     4.558    68.406     0.200
     4.623    69.496     0.200
     4.734    71.512     0.200
     4.826    72.703     0.200
     4.987    75.363     0.200
     5.184    77.254     0.200
     5.279    79.363     0.200
     5.562    83.621     0.200
     5.571    82.816     0.200
     5.571    83.562     0.200
     5.621    82.191     0.200
     6.085    90.523     0.200
     6.116    90.383     0.200
     6.127    92.141     0.200
     6.154    90.883     0.200
     6.154    90.898     0.200
     6.544    98.832     0.200
     6.592    98.012     0.200
     6.597    98.133     0.200
     6.709    97.781     0.200
     7.391   108.301     0.200
     7.493   111.434     0.200
     7.512   109.344     0.200
     7.605   112.672     0.200
     7.653   112.633     0.200
     7.673   113.480     0.200
     7.724   114.254     0.200
     7.763   112.902     0.200
     7.786   113.242     0.200
     7.877   116.254     0.200
     7.882   114.172     0.200
     7.907   117.012     0.200
     7.913   116.723     0.200
     7.947   117.602     0.200
     8.021   117.891     0.200
     8.059   118.133     0.200
     8.059   117.633     0.200
     8.108   118.363     0.200
     8.272   120.652     0.200
     8.557   127.754     0.200
     8.571   121.121     0.200
     8.667   126.953     0.200
     8.824   126.730     0.200
     8.894   129.672     0.200
     9.150   133.043     0.200
     9.647   141.332     0.200
     9.803   142.043     0.200
     9.992   145.141     0.200
    10.327   150.312     0.200
    10.663   153.941     0.200
    10.759   155.793     0.200
    10.862   155.434     0.200
    10.863   155.980     0.200
    10.863   155.980     0.200
    10.963   161.480     0.200
    10.928   159.223     0.200
    11.233   165.191     0.200
    11.234   165.332     0.200
    11.234   164.781     0.200
    11.379   167.051     0.200
    13.444   192.070     0.200
    13.564   196.012     0.200
    13.754   198.344     0.200
    16.803   234.211     0.200
    18.556   257.684     0.200
     0.989    16.410     0.200
     0.989    16.578     0.200
     1.009    17.004     0.200
     1.304    23.160     0.200
     1.345    22.109     0.200
     1.338    22.707     0.200
     1.337    23.359     0.200
     1.415    24.477     0.200
     1.575    25.191     0.200
     1.730    27.383     0.200
     1.730    27.809     0.200
     1.833    30.465     0.200
     1.864    29.430     0.200
     1.871    29.562     0.200
     1.989    30.730     0.200
     2.028    31.602     0.200
     2.054    31.848     0.200
     2.571    39.840     0.200
     2.973    46.348     0.200
     3.000    46.055     0.200
     3.046    46.465     0.200
     3.174    48.238     0.200
     3.234    50.809     0.200
     3.704    54.238     0.200
     3.704    54.359     0.200
     3.872    58.457     0.200
     4.397    67.227     0.200
     4.636    69.395     0.200
     4.636    70.598     0.200
     4.924    74.387     0.200
     4.925    72.699     0.200
     4.925    74.828     0.200
     4.981    74.160     0.200
     5.049    74.949     0.200
     5.148    76.797     0.200
     5.269    79.168     0.200
     5.427    80.984     0.200
     5.427    81.430     0.200
     5.635    83.559     0.200
     5.740    86.027     0.200
     5.822    88.438     0.200
     6.247    90.723     0.200
     6.247    90.477     0.200
     6.248    92.559     0.200
     6.408    97.289     0.200
     6.845   104.090     0.200
     6.927   101.309     0.200
     6.928   102.047     0.200
     7.091   104.379     0.200
     7.434   108.898     0.200
     7.470   108.547     0.200
     7.483   110.938     0.200
     7.755   113.566     0.200
     7.792   113.816     0.200
     8.011   118.957     0.200
     8.079   119.090     0.200
     8.093   121.168     0.200
     8.183   117.578     0.200
     8.225   118.547     0.200
     8.313   119.293     0.200
     8.313   119.988     0.200
     9.699   142.277     0.200
    10.257   148.359     0.200
    10.257   148.488     0.200
    10.257   148.488     0.200
    11.535   167.352     0.200
     1.038    18.789     0.200
     1.236    20.742     0.200
     1.298    22.344     0.200
     1.320    22.461     0.200
     1.345    23.008     0.200
     1.485    24.359     0.200
     1.567    26.680     0.200
     1.573    26.547     0.200
     1.631    26.797     0.200
     1.683    27.438     0.200
     1.769    29.172     0.200
     1.757    29.422     0.200
     1.778    29.195     0.200
     1.979    31.781     0.200
     2.077    33.812     0.200
     2.086    32.422     0.200
     2.298    36.648     0.200
     2.293    36.492     0.200
     2.341    37.391     0.200
     2.612    41.570     0.200
     2.631    41.531     0.200
     2.723    43.906     0.200
     2.784    43.914     0.200
     2.799    43.969     0.200
     2.910    46.031     0.200
     2.943    44.367     0.200
     3.001    45.773     0.200
     3.081    47.945     0.200
     3.081    46.422     0.200
     3.203    50.141     0.200
     3.252    48.711     0.200
     3.279    51.258     0.200
     3.279    51.367     0.200
     3.406    53.688     0.200
     3.678    56.648     0.200
     3.696    57.188     0.200
     3.910    60.141     0.200
     4.563    69.773     0.200
     4.721    69.492     0.200
     4.744    71.703     0.200
     4.900    74.773     0.200
     4.900    75.398     0.200
     5.400    81.219     0.200
     5.476    82.539     0.200
     5.540    83.344     0.200
     5.517    83.219     0.200
     5.582    84.250     0.200
     5.571    81.922     0.200
     5.754    86.977     0.200
     5.902    87.797     0.200
     5.942    89.500     0.200
     6.021    90.789     0.200
     6.054    89.820     0.200
     6.157    92.977     0.200
     6.239    94.398     0.200
     6.312    93.609     0.200
     6.312    94.508     0.200
     6.892   105.133     0.200
     7.263   106.102     0.200
     7.302   111.969     0.200
     8.064   118.258     0.200
     8.270   123.406     0.200
     8.419   122.867     0.200
     8.450   123.289     0.200
     8.458   128.047     0.200
     8.699   129.000     0.200
     8.733   129.617     0.200
     8.751   127.562     0.200
     8.751   128.469     0.200
     8.805   131.109     0.200
     9.328   134.750     0.200
     9.328   134.648     0.200
     9.666   141.102     0.200
    11.239   162.398     0.200
    11.556   169.672     0.200
    14.238   206.383     0.200
    14.918   212.969     0.200
    15.059   215.211     0.200
    15.433   218.820     0.200
    19.191   267.008     0.200
     0.625    11.727     0.200
     0.733    12.250     0.200
     0.713    12.547     0.200
     0.781    13.070     0.200
     0.761    14.461     0.200
     0.805    14.094     0.200
     0.948    16.695     0.200
     1.018    16.320     0.200
     0.993    16.211     0.200
     1.399    22.391     0.200
     1.363    21.156     0.200
     1.760    27.172     0.200
     1.832    28.906     0.200
     1.844    28.766     0.200
     1.851    28.969     0.200
     1.851    28.797     0.200
     2.041    31.156     0.200
     2.023    31.164     0.200
     2.069    31.555     0.200
     2.215    34.562     0.200
     2.254    34.906     0.200
     2.618    40.156     0.200
     2.720    40.992     0.200
     2.973    45.336     0.200
     3.004    45.633     0.200
     3.204    48.586     0.200
     3.396    50.594     0.200
     3.759    54.344     0.200
     3.819    59.516     0.200
     3.923    58.773     0.200
     4.175    62.922     0.200
     4.342    67.953     0.200
     4.411    65.883     0.200
     4.445    64.641     0.200
     4.485    67.406     0.200
     4.682    70.711     0.200
     4.677    65.805     0.200
     4.778    70.688     0.200
     4.929    72.656     0.200
     4.962    74.211     0.200
     4.908    75.195     0.200
     5.034    74.250     0.200
     5.101    75.281     0.200
     5.177    76.555     0.200
     5.301    78.703     0.200
     5.479    81.102     0.200
     5.548    84.172     0.200
     5.662    83.141     0.200
     5.769    85.375     0.200
     5.855    85.594     0.200
     6.259    91.664     0.200
     6.302    90.422     0.200
     7.489   109.070     0.200
     7.619   107.086     0.200
     8.366   119.945     0.200
     0.874    14.844     0.200
     0.944    15.609     0.200
     1.193    20.164     0.200
     1.405    23.012     0.200
     1.472    23.637     0.200
     1.692    27.898     0.200
     1.684    26.387     0.200
     1.726    27.309     0.200
     1.730    27.492     0.200
     1.733    27.414     0.200
     1.907    29.707     0.200
     1.969    30.957     0.200
     2.109    32.488     0.200
     2.109    32.613     0.200
     2.140    33.457     0.200
     2.317    35.633     0.200
     2.589    40.434     0.200
     2.610    39.785     0.200
     2.868    43.855     0.200
     2.904    44.910     0.200
     2.887    45.402     0.200
     3.090    48.094     0.200
     3.129    47.824     0.200
     3.762    55.633     0.200
     3.812    56.141     0.200
     3.910    58.953     0.200
     4.309    64.512     0.200
     4.507    67.621     0.200
     4.647    69.691     0.200
     4.901    73.352     0.200
     5.035    74.781     0.200
     5.098    75.754     0.200
     5.173    75.934     0.200
     5.471    81.254     0.200
     5.579    83.211     0.200
     5.689    84.703     0.200
     6.153    90.652     0.200
     6.352    92.254     0.200
     6.813   100.371     0.200
     7.502   110.562     0.200
     7.514   108.754     0.200
     7.548   109.254     0.200
     7.756   115.062     0.200
     7.861   114.512     0.200
     7.861   115.094     0.200
     8.009   118.273     0.200
     8.053   118.613     0.200
     8.085   118.051     0.200
     8.092   118.742     0.200
     8.307   121.324     0.200
     8.427   120.902     0.200
     8.878   129.391     0.200
     9.170   136.281     0.200
    10.387   148.211     0.200
    10.388   150.262     0.200
    11.494   168.934     0.200
     1.189    22.258     0.200
     1.239    21.898     0.200
     1.239    22.047     0.200
     1.317    21.340     0.200
     1.307    24.000     0.200
     1.327    23.449     0.200
     1.330    22.387     0.200
     1.532    24.430     0.200
     1.613    25.410     0.200
     1.616    25.535     0.200
     1.649    27.164     0.200
     1.763    27.785     0.200
     1.810    28.543     0.200
     2.052    32.227     0.200
     2.113    32.719     0.200
     2.113    32.930     0.200
     2.166    33.840     0.200
     2.475    38.531     0.200
     2.471    38.758     0.200
     2.635    40.770     0.200
     2.729    42.770     0.200
     2.844    43.148     0.200
     2.856    43.816     0.200
     2.890    44.453     0.200
     2.976    46.297     0.200
     3.674    56.418     0.200
     3.702    58.348     0.200
     3.789    56.148     0.200
     3.789    57.039     0.200
     3.805    57.777     0.200
     4.151    63.316     0.200
     4.521    68.680     0.200
     4.521    69.289     0.200
     4.665    70.957     0.200
     4.755    72.199     0.200
     4.943    74.770     0.200
     5.178    76.129     0.200
     5.422    81.848     0.200
     5.533    83.059     0.200
     5.996    89.707     0.200
     6.280    95.379     0.200
     6.322    92.512     0.200
     6.322    92.719     0.200
     6.517   100.059     0.200
     6.648   102.168     0.200
     7.381   108.203     0.200
     7.771   115.199     0.200
     7.785   115.074     0.200
     7.785   112.207     0.200
     7.874   115.777     0.200
     8.413   121.617     0.200
    10.406   148.637     0.200
    10.407   150.637     0.200
    10.593   156.039     0.200
    11.341   168.766     0.200
     0.991    16.609     0.200
     1.001    16.758     0.200
     1.267    22.527     0.200
     1.274    22.668     0.200
     1.309    22.332     0.200
     1.301    22.750     0.200
     1.379    22.938     0.200
     1.352    23.750     0.200
     1.382    23.828     0.200
     1.382    24.000     0.200
     1.571    25.230     0.200
     1.613    27.180     0.200
     1.743    27.758     0.200
     1.801    29.883     0.200
     1.801    29.809     0.200
     1.848    29.227     0.200
     1.851    29.238     0.200
     2.017    31.434     0.200
     2.026    31.637     0.200
     2.056    32.113     0.200
     2.258    35.383     0.200
     2.371    36.855     0.200
     2.598    40.438     0.200
     2.602    40.660     0.200
     2.707    41.656     0.200
     2.710    41.367     0.200
     2.889    43.785     0.200
     2.975    46.297     0.200
     2.975    45.695     0.200
     2.969    44.945     0.200
     3.013    45.727     0.200
     3.068    45.922     0.200
     3.156    47.664     0.200
     3.187    48.527     0.200
     3.207    48.789     0.200
     3.255    51.879     0.200
     3.387    50.863     0.200
     3.402    50.840     0.200
     3.469    51.918     0.200
     3.469    52.090     0.200
     3.633    54.684     0.200
     3.741    55.027     0.200
     3.741    55.387     0.200
     3.821    56.734     0.200
     3.831    57.180     0.200
     3.879    57.957     0.200
     3.879    58.688     0.200
     3.900    57.969     0.200
     3.903    59.227     0.200
     3.961    58.949     0.200
     4.185    61.727     0.200
     4.285    63.590     0.200
     4.388    65.254     0.200
     4.399    65.547     0.200
     4.452    65.754     0.200
     4.485    66.516     0.200
     4.575    69.344     0.200
     4.622    69.289     0.200
     4.662    70.215     0.200
     4.662    70.688     0.200
     4.762    70.754     0.200
     4.919    73.035     0.200
     4.919    73.289     0.200
     4.943    74.289     0.200
     4.941    73.129     0.200
     5.014    74.637     0.200
     5.086    74.910     0.200
     5.132    75.055     0.200
     5.160    76.828     0.200
     5.376    78.406     0.200
     5.441    81.090     0.200
     5.459    81.043     0.200
     5.459    81.520     0.200
     5.552    84.066     0.200
     5.646    84.188     0.200
     5.614    85.309     0.200
     5.753    85.559     0.200
     5.810    87.039     0.200
     5.858    86.988     0.200
     6.206    91.398     0.200
     6.247    91.484     0.200
     6.247    91.727     0.200
     6.285    91.500     0.200
     6.381    95.637     0.200
     6.423    96.059     0.200
     6.414    94.219     0.200
     6.516    96.109     0.200
     6.770   100.977     0.200
     6.812    99.910     0.200
     6.812   100.109     0.200
     6.859   101.789     0.200
     6.874   101.797     0.200
     6.874   101.738     0.200
     6.956   102.488     0.200
     7.063   101.180     0.200
     7.126   104.129     0.200
     7.195   105.508     0.200
     7.215   104.422     0.200
     7.215   105.590     0.200
     7.216   104.344     0.200
     7.274   110.367     0.200
     7.296   106.789     0.200
     7.333   107.688     0.200
     7.389   106.789     0.200
     7.469   108.379     0.200
     7.511   109.492     0.200
     7.511   110.910     0.200
     7.506   108.809     0.200
     7.553   108.027     0.200
     7.780   117.668     0.200
     7.827   113.906     0.200
     7.827   113.289     0.200
     7.827   114.379     0.200
     7.846   117.207     0.200
     7.880   116.137     0.200
     7.963   116.887     0.200
     8.035   118.648     0.200
     8.081   119.289     0.200
     8.104   118.418     0.200
     8.200   121.137     0.200
     8.238   122.758     0.200
     8.308   121.008     0.200
     8.308   123.590     0.200
     8.320   125.418     0.200
     8.350   119.988     0.200
     8.350   119.859     0.200
     8.411   124.078     0.200
     8.478   123.789     0.200
     8.519   124.367     0.200
     8.720   127.469     0.200
     8.811   131.180     0.200
     8.881   128.871     0.200
     8.881   129.316     0.200
     8.982   131.887     0.200
     9.008   132.797     0.200
     9.015   132.609     0.200
     9.032   133.188     0.200
     9.054   131.059     0.200
     9.125   135.090     0.200
     9.181   131.109     0.200
     9.454   138.910     0.200
     9.502   140.098     0.200
     9.658   141.680     0.200
     9.725   142.488     0.200
     9.747   140.699     0.200
     9.747   140.977     0.200
     9.768   140.504     0.200
     9.792   141.512     0.200
     9.792   140.000     0.200
     9.760   142.398     0.200
     9.856   143.988     0.200
    10.001   144.547     0.200
    10.178   148.098     0.200
    10.206   147.871     0.200
    10.206   148.098     0.200
    10.293   148.727     0.200
    10.293   148.715     0.200
    10.604   156.160     0.200
    10.591   152.277     0.200
    10.591   153.008     0.200
    10.667   154.098     0.200
    10.677   154.789     0.200
    10.720   154.895     0.200
    10.919   156.832     0.200
    10.919   159.289     0.200
    11.030   158.543     0.200
    11.124   158.496     0.200
    11.311   164.648     0.200
    11.339   166.805     0.200
    11.464   167.449     0.200
    11.502   164.031     0.200
    11.502   167.430     0.200
    11.504   166.957     0.200
    11.538   169.770     0.200
    11.535   169.727     0.200
    11.550   165.336     0.200
    11.550   166.559     0.200
    11.550   166.648     0.200
    11.550   167.188     0.200
    11.550   166.297     0.200
    11.617   166.266     0.200
    11.617   165.809     0.200
    11.730   167.129     0.200
    11.757   171.098     0.200
    11.856   171.840     0.200
    11.875   170.598     0.200
    11.981   174.008     0.200
    12.072   172.637     0.200
    12.148   175.988     0.200
    12.147   177.379     0.200
    12.247   177.770     0.200
    12.333   174.969     0.200
    12.333   178.910     0.200
    12.395   176.484     0.200
    12.581   179.113     0.200
    12.581   179.918     0.200
    12.633   183.328     0.200
    12.798   184.309     0.200
    12.800   181.969     0.200
    12.844   186.938     0.200
    12.968   188.918     0.200
    12.980   188.488     0.200
    12.987   187.039     0.200
    13.001   185.988     0.200
    13.015   188.727     0.200
    13.084   189.957     0.200
    13.138   187.691     0.200
    13.157   187.340     0.200
    13.157   188.949     0.200
    13.243   189.359     0.200
    13.261   189.754     0.200
    13.261   190.488     0.200
    13.400   194.719     0.200
    13.497   196.469     0.200
    13.705   198.879     0.200
    13.762   197.555     0.200
    13.762   198.090     0.200
    13.769   195.094     0.200
    13.769   194.566     0.200
    13.787   199.750     0.200
    13.800   196.516     0.200
    13.800   196.918     0.200
    13.947   201.707     0.200
    13.965   197.898     0.200
    13.959   197.270     0.200
    13.959   198.188     0.200
    14.056   200.039     0.200
    14.167   199.793     0.200
    14.259   201.746     0.200
    14.524   206.152     0.200
    14.746   210.270     0.200
    14.855   209.293     0.200
    14.855   209.688     0.200
    15.045   213.168     0.200
    15.045   212.617     0.200
    15.089   213.328     0.200
    15.213   216.699     0.200
    15.565   220.559     0.200
    15.604   220.379     0.200
    15.621   220.402     0.200
    15.666   220.930     0.200
    15.666   221.340     0.200
    15.741   222.270     0.200
    15.846   221.996     0.200
    15.912   223.879     0.200
    16.120   227.223     0.200
    16.120   226.457     0.200
    16.127   224.918     0.200
    16.216   228.223     0.200
    16.291   227.230     0.200
    16.334   230.219     0.200
    16.392   230.160     0.200
    16.437   231.465     0.200
    16.449   230.336     0.200
    16.496   229.910     0.200
    16.529   231.617     0.200
    16.529   231.738     0.200
    16.631   231.953     0.200
    16.637   232.969     0.200
    16.637   234.078     0.200
    16.652   233.238     0.200
    16.660   233.617     0.200
    16.708   233.641     0.200
    16.739   232.891     0.200
    16.749   234.152     0.200
    16.749   234.727     0.200
    16.883   235.719     0.200
    16.961   236.445     0.200
    16.984   237.113     0.200
    17.049   237.707     0.200
    17.141   239.379     0.200
    17.206   240.035     0.200
    17.211   239.062     0.200
    17.234   239.594     0.200
    17.244   240.879     0.200
    17.357   240.949     0.200
    17.390   242.000     0.200
    17.438   241.422     0.200
    17.434   242.750     0.200
    17.478   242.621     0.200
    17.549   243.531     0.200
    17.549   244.207     0.200
    17.584   244.863     0.200
    17.617   244.953     0.200
    17.638   245.129     0.200
    17.707   245.125     0.200
    17.728   246.871     0.200
    17.745   246.453     0.200
    17.782   247.559     0.200
    17.834   247.418     0.200
    17.894   248.539     0.200
    17.931   247.332     0.200
    17.962   249.027     0.200
    18.087   250.516     0.200
    18.171   251.305     0.200
    18.164   251.418     0.200
    18.175   251.219     0.200
    18.178   251.473     0.200
    18.227   252.102     0.200
    18.252   252.770     0.200
    18.305   253.391     0.200
    18.305   253.281     0.200
    18.452   256.023     0.200
    18.597   257.086     0.200
    18.609   258.207     0.200
    18.657   258.816     0.200
    18.671   259.066     0.200
    18.825   260.020     0.200
    19.010   261.941     0.200
    19.151   265.590     0.200
    19.257   265.012     0.200
    19.250   265.707     0.200
    19.276   265.551     0.200
    19.281   266.078     0.200
    19.314   266.020     0.200
    19.331   265.918     0.200
    19.397   266.930     0.200
    19.694   270.316     0.200
    19.720   271.199     0.200
    20.038   273.918     0.200
    20.455   278.688     0.200
    20.882   284.719     0.200
    20.863   283.848     0.200
     0.938    15.978     0.200
     0.938    16.195     0.200
     1.184    21.005     0.200
     1.202    22.205     0.200
     1.227    22.245     0.200
     1.252    21.975     0.200
     1.293    22.915     0.200
     1.416    23.545     0.200
     1.455    23.595     0.200
     1.678    26.611     0.200
     1.669    27.609     0.200
     1.707    27.575     0.200
     1.710    27.328     0.200
     1.710    27.045     0.200
     1.886    29.560     0.200
     1.955    30.725     0.200
     2.130    33.167     0.200
     2.116    33.450     0.200
     2.311    36.148     0.200
     2.593    39.675     0.200
     2.593    39.719     0.200
     2.622    40.378     0.200
     2.833    43.984     0.200
     2.873    45.375     0.200
     2.881    44.618     0.200
     3.122    49.075     0.200
     3.114    47.825     0.200
     3.267    49.341     0.200
     3.830    56.184     0.200
     3.830    57.025     0.200
     3.917    59.225     0.200
     4.295    65.155     0.200
     4.486    66.715     0.200
     4.650    69.985     0.200
     4.897    74.495     0.200
     4.914    76.334     0.200
     5.045    75.265     0.200
     5.090    76.515     0.200
     5.478    81.424     0.200
     5.680    85.515     0.200
     5.779    88.205     0.200
     6.064    92.225     0.200
     6.370    92.873     0.200
     6.370    92.405     0.200
     6.794   104.165     0.200
     7.178   105.795     0.200
     7.506   110.378     0.200
     7.506   110.795     0.200
     7.528   110.035     0.200
     7.562   110.645     0.200
     7.873   114.910     0.200
     8.009   119.545     0.200
     8.086   118.765     0.200
     8.092   120.945     0.200
     8.446   121.300     0.200
     8.446   121.185     0.200
     8.883   130.495     0.200
     9.709   143.465     0.200
    10.410   150.525     0.200
    10.409   151.375     0.200
    10.410   150.525     0.200
    10.660   157.645     0.200
    10.906   158.925     0.200
    14.024   197.475     0.200
     0.998    16.760     0.200
     0.982    16.529     0.200
     1.017    17.516     0.200
     1.077    20.206     0.200
     1.193    22.176     0.200
     1.258    22.406     0.200
     1.299    22.190     0.200
     1.382    22.815     0.200
     1.372    23.706     0.200
     1.564    25.252     0.200
     1.740    27.735     0.200
     1.740    28.036     0.200
     1.791    29.771     0.200
     1.839    28.706     0.200
     1.841    29.200     0.200
     2.034    31.635     0.200
     2.034    31.436     0.200
     2.599    40.916     0.200
     2.703    41.527     0.200
     3.184    49.696     0.200
     3.245    50.556     0.200
     3.749    57.156     0.200
     3.905    59.436     0.200
     4.393    66.926     0.200
     4.475    67.855     0.200
     4.942    74.886     0.200
     5.018    75.286     0.200
     5.094    75.506     0.200
     5.157    77.346     0.200
     5.281    79.436     0.200
     5.462    80.855     0.200
     5.749    85.886     0.200
     5.835    87.286     0.200
     6.241    91.565     0.200
     6.292    91.216     0.200
     7.680   114.996     0.200
    10.302   149.536     0.200
     0.955    15.914     0.200
     0.955    16.016     0.200
     1.060    19.523     0.200
     1.143    21.125     0.200
     1.143    20.938     0.200
     1.143    21.156     0.200
     1.158    20.984     0.200
     1.178    20.492     0.200
     1.185    20.977     0.200
     1.218    22.148     0.200
     1.472    23.648     0.200
     1.695    26.781     0.200
     1.720    27.578     0.200
     1.723    27.367     0.200
     1.723    27.594     0.200
     1.903    30.133     0.200
     1.973    30.953     0.200
     2.126    33.648     0.200
     2.130    32.898     0.200
     2.130    33.062     0.200
     3.833    56.367     0.200
     4.313    65.977     0.200
     4.664    70.508     0.200
     5.108    76.516     0.200
     5.238    78.484     0.200
     5.797    89.484     0.200
     6.373    92.766     0.200
     6.811   104.102     0.200
     7.187   105.195     0.200
     7.520   111.445     0.200
     7.536   109.695     0.200
     7.569   110.062     0.200
     7.772   117.648     0.200
     7.882   115.203     0.200
     8.024   119.477     0.200
     8.068   119.828     0.200
     8.107   119.867     0.200
     8.448   121.633     0.200
     9.723   143.086     0.200
    10.407   151.062     0.200
    10.408   150.867     0.200
    10.921   159.555     0.200
     0.898    14.844     0.200
     0.970    15.875     0.200
     0.970    15.979     0.200
     1.209    20.648     0.200
     1.211    21.258     0.200
     1.285    22.268     0.200
     1.295    22.928     0.200
     1.418    22.818     0.200
     1.499    23.953     0.200
     1.710    26.742     0.200
     1.703    28.158     0.200
     1.703    28.318     0.200
     1.752    27.688     0.200
     1.755    27.576     0.200
     1.755    27.678     0.200
     1.997    30.990     0.200
     2.108    32.133     0.200
     2.158    33.908     0.200
     2.609    40.018     0.200
     2.638    40.135     0.200
     2.915    45.568     0.200
     3.108    48.898     0.200
     3.156    48.627     0.200
     3.155    50.098     0.200
     3.779    57.479     0.200
     3.927    58.947     0.200
     4.337    65.707     0.200
     4.668    70.777     0.200
     4.926    74.217     0.200
     5.050    75.197     0.200
     5.125    76.498     0.200
     5.170    76.457     0.200
     5.254    78.668     0.200
     5.606    83.547     0.200
     5.716    85.168     0.200
     5.811    87.248     0.200
     6.394    95.758     0.200
     6.467    97.107     0.200
     6.828   101.777     0.200
     6.840   100.979     0.200
     7.523   110.137     0.200
     8.076   118.178     0.200
     8.115   120.568     0.200
     9.027   130.348     0.200
    10.382   149.707     0.200
     1.228    20.570     0.200
     1.581    26.141     0.200
     1.637    27.188     0.200
     1.640    27.121     0.200
     1.794    29.117     0.200
     1.922    31.336     0.200
     1.949    31.961     0.200
     1.945    31.172     0.200
     2.122    34.039     0.200
     2.388    38.703     0.200
     2.483    38.020     0.200
     2.615    41.199     0.200
     2.691    42.145     0.200
     3.028    48.270     0.200
     3.329    52.520     0.200
     3.376    52.219     0.200
     4.234    64.539     0.200
     4.199    63.047     0.200
     4.280    64.699     0.200
     4.433    66.770     0.200
     4.456    68.617     0.200
     4.869    74.188     0.200
     4.985    75.910     0.200
     5.182    78.539     0.200
     5.324    80.047     0.200
     5.418    80.938     0.200
     5.472    82.477     0.200
     5.540    80.750     0.200
     5.788    87.090     0.200
     5.844    87.488     0.200
     5.909    88.797     0.200
     6.039    91.059     0.200
     6.179    90.629     0.200
     6.249    93.777     0.200
     6.612    99.020     0.200
     6.613    99.520     0.200
     7.037   107.449     0.200
     7.848   116.270     0.200
     7.908   115.449     0.200
     8.078   118.379     0.200
     8.077   119.469     0.200
     8.189   121.250     0.200
     8.251   120.414     0.200
     8.325   123.348     0.200
     8.365   123.590     0.200
     8.410   125.598     0.200
     8.409   124.227     0.200
     8.413   124.488     0.200
     8.741   129.000     0.200
     8.808   126.387     0.200
     9.233   136.387     0.200
    10.037   148.328     0.200
    10.739   156.238     0.200
    10.739   155.668     0.200
    11.730   170.520     0.200
     0.953    15.984     0.200
     0.991    16.527     0.200
     0.991    17.043     0.200
     1.072    20.113     0.200
     1.088    20.404     0.200
     1.088    20.293     0.200
     1.089    20.414     0.200
     1.267    21.758     0.200
     1.261    21.953     0.200
     1.340    23.254     0.200
     1.398    22.934     0.200
     1.543    24.809     0.200
     1.759    29.135     0.200
     1.759    29.594     0.200
     1.809    28.754     0.200
     1.811    28.688     0.200
     1.811    28.414     0.200
     2.216    34.783     0.200
     2.606    40.264     0.200
     2.682    41.004     0.200
     2.953    46.334     0.200
     3.213    49.604     0.200
     3.775    55.783     0.200
     3.917    59.693     0.200
     4.376    66.613     0.200
     4.445    67.395     0.200
     4.586    68.283     0.200
     4.669    70.439     0.200
     4.669    70.803     0.200
     4.891    74.594     0.200
     4.940    74.604     0.200
     5.124    75.174     0.200
     5.149    77.684     0.200
     5.275    79.404     0.200
     5.475    81.594     0.200
     5.741    86.504     0.200
     5.830    87.574     0.200
     6.222    92.584     0.200
     6.318    91.635     0.200
     7.151   104.023     0.200
     7.520   111.014     0.200
     7.531   109.844     0.200
     8.038   118.803     0.200
     8.083   119.303     0.200
     8.110   119.463     0.200
     8.293   120.574     0.200
     8.385   120.449     0.200
    10.332   149.664     0.200
     1.103    18.775     0.200
     1.223    20.600     0.200
     1.223    20.494     0.200
     1.409    24.924     0.200
     1.409    24.795     0.200
     1.577    26.197     0.200
     1.634    27.395     0.200
     1.636    27.137     0.200
     1.791    28.975     0.200
     1.918    31.213     0.200
     1.940    30.980     0.200
     1.940    31.266     0.200
     1.946    31.881     0.200
     2.118    33.963     0.200
     2.385    38.840     0.200
     2.481    37.959     0.200
     2.614    41.193     0.200
     2.938    45.945     0.200
     3.371    53.254     0.200
     4.276    64.824     0.200
     4.428    68.385     0.200
     4.452    68.275     0.200
     4.865    75.064     0.200
     5.178    78.574     0.200
     5.225    80.105     0.200
     5.319    80.174     0.200
     5.414    80.924     0.200
     5.467    82.635     0.200
     5.783    87.064     0.200
     5.840    87.605     0.200
     5.905    88.965     0.200
     5.882    89.125     0.200
     6.035    91.145     0.200
     6.609    99.436     0.200
     6.608    98.775     0.200
     7.033   106.215     0.200
     7.555   111.365     0.200
     7.844   116.664     0.200
     7.905   115.574     0.200
     8.074   118.475     0.200
     8.185   119.814     0.200
     8.320   122.686     0.200
     8.385   121.404     0.200
     8.408   125.285     0.200
     9.229   135.525     0.200
    12.337   178.164     0.200
     0.932    15.543     0.200
     1.407    22.879     0.200
     1.454    23.418     0.200
     1.676    28.215     0.200
     1.676    28.008     0.200
     1.711    27.238     0.200
     1.713    27.117     0.200
     1.713    27.277     0.200
     1.888    29.566     0.200
     1.953    30.711     0.200
     2.122    33.566     0.200
     2.121    32.738     0.200
     2.465    38.246     0.200
     2.593    39.828     0.200
     2.838    43.969     0.200
     2.854    44.047     0.200
     2.888    44.477     0.200
     2.871    45.117     0.200
     3.117    48.727     0.200
     3.337    51.129     0.200
     3.821    56.930     0.200
     3.908    59.289     0.200
     4.293    65.129     0.200
     4.642    71.207     0.200
     4.799    72.367     0.200
     4.891    73.797     0.200
     5.036    75.250     0.200
     5.085    76.027     0.200
     5.185    77.367     0.200
     5.470    81.750     0.200
     5.565    82.887     0.200
     5.676    84.418     0.200
     5.774    86.129     0.200
     6.136    89.059     0.200
     6.249    95.469     0.200
     6.357    96.777     0.200
     6.789    99.117     0.200
     7.169   105.129     0.200
     7.498   111.297     0.200
     8.437   121.148     0.200
    10.400   149.809     0.200
     1.019    17.199     0.200
     1.141    18.949     0.200
     1.143    19.125     0.200
     1.143    18.879     0.200
     1.201    20.766     0.200
     1.201    20.789     0.200
     1.236    22.129     0.200
     1.250    22.316     0.200
     1.255    22.379     0.200
     1.363    22.402     0.200
     1.475    23.863     0.200
     1.570    25.301     0.200
     1.564    25.379     0.200
     1.640    26.379     0.200
     1.619    27.590     0.200
     1.896    30.395     0.200
     2.100    32.949     0.200
     2.124    33.016     0.200
     2.270    35.516     0.200
     2.293    35.797     0.200
     2.393    37.051     0.200
     2.412    37.301     0.200
     2.467    38.949     0.200
     2.512    40.438     0.200
     2.565    41.617     0.200
     2.549    38.703     0.200
     2.793    42.688     0.200
     2.870    44.340     0.200
     2.925    44.633     0.200
     3.186    47.027     0.200
     3.700    55.207     0.200
     3.776    56.184     0.200
     3.776    56.398     0.200
     3.867    58.590     0.200
     3.934    58.539     0.200
     3.972    60.309     0.200
     4.174    61.273     0.200
     4.174    60.199     0.200
     4.306    64.348     0.200
     4.306    64.809     0.200
     4.590    68.875     0.200
     4.590    69.078     0.200
     4.701    70.637     0.200
     4.794    71.699     0.200
     5.155    76.816     0.200
     5.248    78.508     0.200
     5.375    79.348     0.200
     5.507    80.867     0.200
     5.529    83.859     0.200
     5.540    82.824     0.200
     5.540    82.527     0.200
     5.634    84.938     0.200
     5.605    81.469     0.200
     5.681    82.656     0.200
     5.681    82.316     0.200
     5.774    83.156     0.200
     6.056    89.449     0.200
     6.095    90.617     0.200
     6.099    87.387     0.200
     6.137    90.289     0.200
     6.137    90.762     0.200
     6.145    91.387     0.200
     6.221    93.590     0.200
     6.256    90.867     0.200
     6.385    93.199     0.200
     6.506    95.398     0.200
     6.512    96.469     0.200
     6.579    97.309     0.200
     6.588    97.359     0.200
     6.670    98.156     0.200
     6.687    97.379     0.200
     6.868    99.559     0.200
     6.937   101.020     0.200
     7.363   107.418     0.200
     7.485   108.520     0.200
     7.595   109.090     0.200
     7.640   113.648     0.200
     7.691   113.090     0.200
     7.737   112.219     0.200
     7.759   112.566     0.200
     7.851   115.027     0.200
     7.855   114.328     0.200
     7.876   117.918     0.200
     7.880   114.867     0.200
     7.901   114.398     0.200
     7.968   117.359     0.200
     7.988   115.770     0.200
     8.030   117.680     0.200
     8.030   117.066     0.200
     8.082   119.727     0.200
     8.145   118.957     0.200
     8.177   119.559     0.200
     8.804   126.457     0.200
     8.804   126.227     0.200
     8.862   127.957     0.200
     9.525   137.699     0.200
     9.599   138.148     0.200
     9.771   140.168     0.200
    10.638   153.996     0.200
    10.848   154.957     0.200
    10.849   155.703     0.200
    10.903   154.738     0.200
    11.202   163.129     0.200
    11.202   160.750     0.200
    14.968   213.887     0.200
    15.448   215.828     0.200
    15.537   215.930     0.200
     1.024    17.648     0.200
     1.201    21.586     0.200
     1.236    20.445     0.200
     1.236    20.312     0.200
     1.227    22.000     0.200
     1.314    21.750     0.200
     1.399    24.648     0.200
     1.578    26.469     0.200
     1.589    26.102     0.200
     1.635    26.945     0.200
     1.806    28.859     0.200
     1.951    30.844     0.200
     1.940    31.828     0.200
     2.528    40.727     0.200
     2.603    41.375     0.200
     2.691    41.711     0.200
     2.679    41.812     0.200
     2.679    41.914     0.200
     2.952    46.039     0.200
     3.382    52.844     0.200
     3.439    52.688     0.200
     3.684    59.641     0.200
     4.212    64.234     0.200
     4.291    65.359     0.200
     4.680    68.000     0.200
     4.995    76.141     0.200
     5.429    81.312     0.200
     5.477    82.805     0.200
     5.792    87.336     0.200
     5.917    93.516     0.200
     7.852   117.531     0.200
    12.804   187.961     0.200
    16.064   223.234     0.200
     1.026    18.094     0.200
     1.071    18.727     0.200
     1.236    20.602     0.200
     1.320    21.898     0.200
     1.367    24.281     0.200
     1.396    24.789     0.200
     1.407    24.805     0.200
     1.407    24.781     0.200
     1.595    26.117     0.200
     1.586    26.617     0.200
     1.642    27.102     0.200
     1.803    28.961     0.200
     1.895    31.406     0.200
     1.926    31.344     0.200
     1.953    31.227     0.200
     1.953    31.375     0.200
     1.948    31.891     0.200
     2.035    33.031     0.200
     2.129    34.008     0.200
     2.111    34.281     0.200
     2.611    41.656     0.200
     2.697    41.867     0.200
     2.786    43.109     0.200
     2.838    44.117     0.200
     2.889    48.164     0.200
     2.951    45.984     0.200
     2.925    45.961     0.200
     3.035    47.781     0.200
     3.333    51.727     0.200
     3.328    49.500     0.200
     3.384    52.008     0.200
     3.368    51.969     0.200
     3.447    53.422     0.200
     4.289    65.141     0.200
     4.439    68.141     0.200
     4.458    68.039     0.200
     4.794    73.633     0.200
     4.874    73.867     0.200
     4.874    74.305     0.200
     4.994    75.438     0.200
     4.994    76.086     0.200
     5.191    78.305     0.200
     5.226    80.461     0.200
     5.332    80.328     0.200
     5.427    81.734     0.200
     5.480    82.758     0.200
     5.795    87.305     0.200
     5.853    87.016     0.200
     5.853    87.789     0.200
     5.917    89.086     0.200
     6.047    90.414     0.200
     6.621    98.719     0.200
     6.672    98.820     0.200
     6.672    98.203     0.200
     6.916   102.648     0.200
     7.045   105.727     0.200
     8.260   122.750     0.200
     8.298   122.289     0.200
     8.310   122.430     0.200
     8.347   120.766     0.200
     8.353   126.055     0.200
     8.368   124.578     0.200
     8.374   123.367     0.200
     8.404   121.898     0.200
     8.420   123.938     0.200
     8.503   125.156     0.200
     8.585   126.008     0.200
    10.746   155.359     0.200
    12.745   183.008     0.200
     0.950    16.047     0.200
     1.209    21.627     0.200
     1.236    21.877     0.200
     1.236    21.656     0.200
     1.274    22.526     0.200
     1.458    23.641     0.200
     1.435    23.656     0.200
     1.469    25.167     0.200
     1.654    27.798     0.200
     1.654    27.826     0.200
     1.700    27.076     0.200
     1.703    27.271     0.200
     1.689    26.899     0.200
     1.885    29.695     0.200
     1.960    30.955     0.200
     2.105    33.293     0.200
     2.148    33.139     0.200
     2.323    35.981     0.200
     2.455    38.775     0.200
     2.595    39.917     0.200
     2.609    40.486     0.200
     2.630    40.737     0.200
     2.757    42.120     0.200
     2.823    43.604     0.200
     2.829    43.643     0.200
     2.866    44.623     0.200
     2.879    44.977     0.200
     2.917    44.158     0.200
     3.014    45.954     0.200
     3.055    49.687     0.200
     3.103    51.557     0.200
     3.133    47.807     0.200
     3.250    49.004     0.200
     3.268    49.205     0.200
     3.333    50.341     0.200
     3.483    52.784     0.200
     3.671    56.022     0.200
     3.691    55.727     0.200
     3.727    55.901     0.200
     3.727    57.057     0.200
     3.776    56.675     0.200
     3.816    56.598     0.200
     3.849    56.740     0.200
     3.849    56.356     0.200
     3.934    59.406     0.200
     4.037    60.154     0.200
     4.132    61.297     0.200
     4.248    62.973     0.200
     4.300    64.977     0.200
     4.335    64.472     0.200
     4.335    64.927     0.200
     4.445    66.819     0.200
     4.482    67.007     0.200
     4.609    68.807     0.200
     4.665    70.947     0.200
     4.665    70.406     0.200
     4.791    71.303     0.200
     4.801    72.180     0.200
     4.801    72.387     0.200
     4.806    71.664     0.200
     4.910    74.187     0.200
     4.979    74.094     0.200
     5.074    75.617     0.200
     5.063    75.337     0.200
     5.100    76.227     0.200
     5.232    78.536     0.200
     5.496    82.001     0.200
     5.496    82.106     0.200
     5.579    83.757     0.200
     5.690    85.366     0.200
     5.791    87.477     0.200
     6.053    90.606     0.200
     6.141    90.302     0.200
     6.237    94.276     0.200
     6.373    95.656     0.200
     6.388    92.887     0.200
     6.435    95.396     0.200
     6.636   100.786     0.200
     6.677   102.316     0.200
     6.804   103.597     0.200
     6.805   104.076     0.200
     7.132   109.177     0.200
     7.148   103.917     0.200
     7.197   105.307     0.200
     7.271   105.727     0.200
     7.293   106.529     0.200
     7.293   107.007     0.200
     7.293   106.432     0.200
     7.510   113.437     0.200
     7.504   110.097     0.200
     7.522   111.118     0.200
     7.522   111.437     0.200
     7.547   110.026     0.200
     7.580   110.477     0.200
     7.772   117.937     0.200
     7.800   118.387     0.200
     7.906   121.267     0.200
     7.889   114.819     0.200
     7.891   115.281     0.200
     7.891   114.782     0.200
     7.892   114.864     0.200
     7.926   117.557     0.200
     8.024   119.566     0.200
     8.035   119.456     0.200
     8.061   119.837     0.200
     8.067   119.767     0.200
     8.102   119.937     0.200
     8.107   120.467     0.200
     8.157   121.377     0.200
     8.235   121.434     0.200
     8.235   123.146     0.200
     8.277   122.826     0.200
     8.298   123.036     0.200
     8.358   124.437     0.200
     8.480   125.687     0.200
     8.465   121.786     0.200
     8.531   128.087     0.200
     8.669   129.446     0.200
     8.904   133.706     0.200
     8.900   129.673     0.200
     8.949   134.187     0.200
     8.952   134.637     0.200
     9.381   139.526     0.200
     9.622   139.501     0.200
     9.724   143.036     0.200
     9.803   144.606     0.200
     9.778   144.307     0.200
     9.770   142.401     0.200
     9.770   143.887     0.200
     9.775   140.295     0.200
     9.775   142.047     0.200
     9.861   145.517     0.200
    10.248   148.642     0.200
    10.248   150.137     0.200
    10.469   155.717     0.200
    10.426   150.956     0.200
    10.427   150.786     0.200
    10.482   156.366     0.200
    10.574   153.979     0.200
    10.683   153.465     0.200
    10.679   155.258     0.200
    10.888   159.055     0.200
    10.922   159.114     0.200
    10.922   159.446     0.200
    10.978   161.611     0.200
    11.068   162.526     0.200
    11.195   165.064     0.200
    11.195   165.326     0.200
    11.206   164.687     0.200
    11.369   164.927     0.200
    11.369   165.727     0.200
    11.399   168.906     0.200
    11.415   169.307     0.200
    11.497   166.354     0.200
    11.498   166.667     0.200
    11.498   168.727     0.200
    11.493   167.602     0.200
    11.493   168.557     0.200
    11.590   164.777     0.200
    11.691   170.696     0.200
    11.696   169.191     0.200
    11.696   167.797     0.200
    11.789   172.746     0.200
    11.912   173.906     0.200
    11.987   175.246     0.200
    12.011   175.445     0.200
    12.025   174.587     0.200
    12.082   176.477     0.200
    12.178   178.017     0.200
    12.256   179.037     0.200
    12.362   177.919     0.200
    12.362   181.007     0.200
    12.389   182.627     0.200
    12.408   180.996     0.200
    12.553   179.337     0.200
    12.553   181.307     0.200
    12.564   183.816     0.200
    12.758   187.227     0.200
    12.822   186.307     0.200
    12.848   187.715     0.200
    12.942   189.146     0.200
    13.004   189.866     0.200
    13.101   189.850     0.200
    13.260   188.395     0.200
    13.260   191.387     0.200
    13.375   195.257     0.200
    13.381   191.179     0.200
    13.381   192.387     0.200
    13.569   197.236     0.200
    13.657   199.206     0.200
    13.683   196.776     0.200
    13.739   196.768     0.200
    13.739   196.356     0.200
    13.786   200.347     0.200
    13.782   197.274     0.200
    13.782   195.146     0.200
    13.833   198.185     0.200
    13.835   201.507     0.200
    14.043   198.857     0.200
    14.299   201.587     0.200
    14.651   209.400     0.200
    14.651   210.856     0.200
    14.833   210.418     0.200
    15.151   213.029     0.200
    15.204   213.628     0.200
    15.204   216.156     0.200
    16.071   226.411     0.200
    16.071   226.257     0.200
    16.364   229.343     0.200
    16.364   231.156     0.200
    16.517   233.326     0.200
    16.521   231.339     0.200
    16.605   232.201     0.200
    16.605   233.587     0.200
    16.685   233.674     0.200
    16.685   233.927     0.200
    17.419   243.360     0.200
    17.540   244.979     0.200
    17.870   248.806     0.200
    17.963   250.013     0.200
    18.170   251.959     0.200
    18.229   252.236     0.200
    18.267   253.410     0.200
    18.314   253.748     0.200
    18.330   253.779     0.200
    18.369   254.218     0.200
    18.370   254.201     0.200
    18.462   256.154     0.200
    18.669   258.667     0.200
    18.754   259.601     0.200
    18.754   260.937     0.200
    18.837   261.036     0.200
    18.860   261.415     0.200
    18.860   263.337     0.200
    18.936   261.809     0.200
    18.935   261.890     0.200
    18.975   262.205     0.200
    18.975   263.236     0.200
    18.977   264.337     0.200
    18.981   262.555     0.200
    18.981   264.106     0.200
    18.993   262.757     0.200
    19.118   264.356     0.200
    19.163   264.265     0.200
    19.304   265.929     0.200
    19.397   267.076     0.200
    19.425   267.327     0.200
    19.425   267.486     0.200
    19.579   269.087     0.200
    19.567   269.402     0.200
    19.591   269.357     0.200
    19.585   269.625     0.200
    19.624   269.986     0.200
    19.811   273.297     0.200
    19.913   274.337     0.200
    20.084   276.557     0.200
    20.127   275.393     0.200
    20.180   276.328     0.200
    20.201   276.214     0.200
    20.201   276.587     0.200
    20.239   278.057     0.200
    20.539   280.187     0.200
    20.670   281.536     0.200
    20.831   284.656     0.200
    20.903   285.906     0.200
     1.412    23.484     0.200
     1.458    23.824     0.200
     1.490    25.805     0.200
     1.675    28.096     0.200
     1.675    28.625     0.200
     1.712    27.584     0.200
     1.715    27.574     0.200
     1.957    31.467     0.200
     2.122    34.016     0.200
     2.124    33.137     0.200
     2.596    40.162     0.200
     2.838    44.250     0.200
     3.824    57.695     0.200
     3.914    60.105     0.200
     4.297    65.615     0.200
     4.647    71.004     0.200
     4.896    74.664     0.200
     5.041    75.365     0.200
     5.221    79.004     0.200
     7.247   106.074     0.200
     7.503   111.844     0.200
     7.524   110.084     0.200
    10.403   150.664     0.200
    11.487   164.785     0.200
     0.946    15.807     0.200
     0.946    16.141     0.200
     1.426    23.432     0.200
     1.460    23.684     0.200
     1.664    27.957     0.200
     1.685    26.771     0.200
     1.707    27.721     0.200
     1.710    27.449     0.200
     1.710    27.711     0.200
     1.889    29.748     0.200
     1.961    30.834     0.200
     2.114    33.529     0.200
     2.137    33.086     0.200
     2.319    35.896     0.200
     2.462    38.926     0.200
     2.598    39.885     0.200
     2.629    40.426     0.200
     2.761    42.176     0.200
     2.831    43.740     0.200
     2.840    43.438     0.200
     2.876    43.861     0.200
     2.879    45.572     0.200
     2.927    44.586     0.200
     3.019    45.621     0.200
     3.130    47.961     0.200
     3.259    49.074     0.200
     3.271    49.232     0.200
     3.338    50.303     0.200
     3.490    52.734     0.200
     3.680    55.627     0.200
     3.702    55.643     0.200
     3.702    59.301     0.200
     3.735    55.867     0.200
     3.735    58.201     0.200
     3.822    56.930     0.200
     3.838    56.279     0.200
     3.926    60.162     0.200
     4.047    60.443     0.200
     4.141    61.611     0.200
     4.254    62.943     0.200
     4.300    65.172     0.200
     4.343    64.484     0.200
     4.343    65.742     0.200
     4.487    67.742     0.200
     4.619    68.740     0.200
     4.659    70.510     0.200
     4.659    71.102     0.200
     4.798    71.256     0.200
     4.803    71.635     0.200
     4.803    73.111     0.200
     4.905    74.781     0.200
     4.916    72.480     0.200
     4.916    76.572     0.200
     4.988    72.613     0.200
     5.054    75.721     0.200
     5.079    75.250     0.200
     5.097    76.662     0.200
     5.228    78.891     0.200
     5.410    79.816     0.200
     5.488    81.592     0.200
     5.488    82.412     0.200
     5.577    84.141     0.200
     5.688    85.512     0.200
     5.787    86.650     0.200
     6.062    90.311     0.200
     6.143    89.863     0.200
     6.143    90.852     0.200
     6.195    93.941     0.200
     6.243    94.332     0.200
     6.369    96.672     0.200
     6.378    92.711     0.200
     6.434    95.822     0.200
     6.641    98.502     0.200
     6.682   103.230     0.200
     6.682    99.264     0.200
     6.802   104.021     0.200
     7.138   109.531     0.200
     7.155   105.281     0.200
     7.188   104.961     0.200
     7.261   105.701     0.200
     7.283   106.203     0.200
     7.283   106.207     0.200
     7.494   109.051     0.200
     7.515   109.941     0.200
     7.515   110.611     0.200
     7.537   109.811     0.200
     7.571   110.221     0.200
     7.766   117.441     0.200
     7.880   114.422     0.200
     7.882   115.131     0.200
     7.882   114.654     0.200
     7.882   114.625     0.200
     7.911   120.861     0.200
     7.922   118.971     0.200
     8.018   119.441     0.200
     8.029   119.361     0.200
     8.055   120.111     0.200
     8.062   119.762     0.200
     8.095   119.961     0.200
     8.101   120.742     0.200
     8.153   122.811     0.200
     8.271   123.051     0.200
     8.292   122.912     0.200
     8.350   125.111     0.200
     8.454   121.186     0.200
     8.454   121.371     0.200
     8.532   125.861     0.200
     8.675   129.322     0.200
     8.892   128.795     0.200
     8.892   129.582     0.200
     8.903   131.672     0.200
     8.946   133.871     0.200
     8.950   134.072     0.200
     9.192   135.855     0.200
     9.278   135.252     0.200
     9.379   139.141     0.200
     9.628   139.225     0.200
     9.797   144.832     0.200
     9.718   142.811     0.200
     9.765   141.572     0.200
     9.765   143.822     0.200
     9.767   141.492     0.200
     9.777   143.602     0.200
     9.858   145.512     0.200
    10.240   150.111     0.200
    10.415   150.311     0.200
    10.416   150.611     0.200
    10.473   155.621     0.200
    10.669   155.012     0.200
    10.915   159.201     0.200
    11.066   162.971     0.200
    11.201   164.959     0.200
    11.201   165.301     0.200
    11.207   164.861     0.200
    11.369   166.539     0.200
    11.369   167.762     0.200
    11.404   168.811     0.200
    11.418   168.861     0.200
    11.494   168.871     0.200
    11.495   170.531     0.200
    11.495   166.061     0.200
    11.495   167.451     0.200
    11.686   166.947     0.200
    11.686   168.111     0.200
    11.689   170.752     0.200
    11.787   172.502     0.200
    11.807   172.451     0.200
    11.910   173.102     0.200
    11.933   173.719     0.200
    11.985   175.572     0.200
    12.016   175.428     0.200
    12.031   176.602     0.200
    12.080   175.621     0.200
    12.176   177.322     0.200
    12.261   175.938     0.200
    12.393   182.230     0.200
    12.407   180.650     0.200
    12.562   183.551     0.200
    12.731   183.605     0.200
    12.732   186.701     0.200
    12.758   187.061     0.200
    12.828   187.871     0.200
    12.853   184.205     0.200
    12.907   189.582     0.200
    12.941   188.932     0.200
    13.009   189.490     0.200
    13.249   190.344     0.200
    13.249   190.980     0.200
    13.315   194.252     0.200
    13.370   191.562     0.200
    13.370   192.400     0.200
    13.378   195.811     0.200
    13.574   196.961     0.200
    13.682   196.770     0.200
    13.737   194.773     0.200
    13.737   198.031     0.200
    13.786   200.891     0.200
    14.033   198.283     0.200
    14.033   199.650     0.200
    14.652   208.850     0.200
    15.140   213.385     0.200
    15.140   214.611     0.200
    15.193   214.619     0.200
    15.193   216.061     0.200
    16.068   226.582     0.200
    16.068   226.811     0.200
    16.108   227.166     0.200
    16.363   229.818     0.200
    16.595   232.285     0.200
    16.595   233.461     0.200
    17.529   244.459     0.200
    17.860   248.639     0.200
    17.953   249.848     0.200
    18.129   251.971     0.200
    18.159   251.875     0.200
    18.304   254.139     0.200
    18.320   253.846     0.200
    18.360   254.342     0.200
    18.662   258.900     0.200
    18.744   260.211     0.200
    18.827   260.881     0.200
    18.849   262.512     0.200
    18.925   262.164     0.200
    18.967   263.162     0.200
    18.971   264.061     0.200
    18.983   262.730     0.200
    19.109   264.131     0.200
    19.415   268.127     0.200
    19.557   271.182     0.200
    19.613   269.619     0.200
    19.905   273.531     0.200
    20.179   277.061     0.200
    20.230   277.730     0.200
    20.510   279.971     0.200
    20.529   280.361     0.200
    20.824   284.361     0.200
    20.893   285.262     0.200
    20.973   286.182     0.200
     1.167    22.283     0.200
     1.168    22.023     0.200
     1.236    22.184     0.200
     1.255    22.424     0.200
     1.255    22.693     0.200
     1.301    23.104     0.200
     1.408    23.584     0.200
     1.450    23.684     0.200
     1.670    26.830     0.200
     1.670    27.043     0.200
     1.706    27.574     0.200
     1.708    27.490     0.200
     1.883    29.703     0.200
     1.949    30.826     0.200
     2.124    32.717     0.200
     2.117    33.758     0.200
     2.460    38.809     0.200
     2.588    40.059     0.200
     2.615    40.555     0.200
     2.833    44.123     0.200
     2.867    45.402     0.200
     2.884    44.889     0.200
     3.115    49.133     0.200
     3.333    52.232     0.200
     3.908    59.812     0.200
     4.289    65.074     0.200
     4.483    68.803     0.200
     4.641    70.803     0.200
     4.889    73.982     0.200
     5.036    75.383     0.200
     5.082    76.393     0.200
     5.188    77.434     0.200
     5.213    78.174     0.200
     5.562    83.574     0.200
     5.673    85.074     0.200
     6.132    90.684     0.200
     6.421    95.553     0.200
     6.677   101.164     0.200
     6.786   104.293     0.200
     7.244   105.844     0.200
     7.497   111.303     0.200
     7.520   109.854     0.200
     7.865   116.533     0.200
     8.012   119.104     0.200
     8.044   119.754     0.200
     8.078   120.074     0.200
     8.084   121.004     0.200
     8.254   122.732     0.200
     8.275   123.684     0.200
     8.440   121.783     0.200
     8.521   127.488     0.200
     8.671   130.773     0.200
     8.931   133.664     0.200
     9.844   147.174     0.200
     9.892   143.053     0.200
    10.404   150.834     0.200
    10.405   150.688     0.200
    11.198   165.502     0.200
    11.198   165.953     0.200
    11.398   169.264     0.200
    11.479   169.305     0.200
    11.773   172.553     0.200
    11.896   173.482     0.200
    12.388   182.732     0.200
    13.356   193.312     0.200
    13.568   197.934     0.200
     0.931    15.719     0.200
     0.979    16.336     0.200
     0.979    16.617     0.200
     1.104    20.379     0.200
     1.104    20.328     0.200
     1.212    21.695     0.200
     1.245    21.344     0.200
     1.244    21.816     0.200
     1.320    23.258     0.200
     1.524    24.637     0.200
     1.720    27.148     0.200
     1.739    28.906     0.200
     1.739    29.336     0.200
     1.770    28.379     0.200
     1.786    28.598     0.200
     1.789    28.441     0.200
     1.789    28.598     0.200
     1.962    30.641     0.200
     2.017    31.449     0.200
     2.077    32.016     0.200
     2.663    40.602     0.200
     3.787    55.559     0.200
     4.358    66.176     0.200
     4.665    70.738     0.200
     5.136    77.078     0.200
     5.476    81.867     0.200
     5.619    84.297     0.200
     5.728    85.367     0.200
     5.819    87.309     0.200
     6.204    90.539     0.200
     6.409    95.598     0.200
     6.952   101.367     0.200
     7.157   104.836     0.200
     7.503   109.566     0.200
     7.855   116.039     0.200
     7.986   118.867     0.200
     8.001   119.168     0.200
     8.003   119.219     0.200
     8.032   119.238     0.200
     8.037   120.117     0.200
     8.041   119.238     0.200
     8.047   119.789     0.200
     8.061   120.195     0.200
     8.066   119.945     0.200
     8.112   120.438     0.200
     8.204   122.508     0.200
     8.281   123.238     0.200
     8.399   120.656     0.200
     9.726   142.617     0.200
    10.349   149.488     0.200
     0.943    15.816     0.200
     0.989    16.500     0.200
     0.989    16.617     0.200
     1.092    20.797     0.200
     1.092    21.297     0.200
     1.217    21.734     0.200
     1.217    21.586     0.200
     1.249    21.816     0.200
     1.328    23.016     0.200
     1.536    24.625     0.200
     1.746    28.891     0.200
     1.746    29.074     0.200
     1.781    28.438     0.200
     1.798    28.504     0.200
     1.801    28.570     0.200
     2.029    31.969     0.200
     2.074    31.902     0.200
     2.204    34.445     0.200
     2.675    40.766     0.200
     2.959    45.336     0.200
     2.948    46.207     0.200
     3.154    47.637     0.200
     3.201    49.824     0.200
     4.370    66.285     0.200
     4.672    70.062     0.200
     4.672    70.766     0.200
     5.147    77.457     0.200
     5.480    80.992     0.200
     5.480    81.945     0.200
     6.328    91.477     0.200
     7.523   111.945     0.200
     8.119   121.535     0.200
    10.344   149.977     0.200
     0.868    14.588     0.200
     1.049    17.434     0.200
     1.139    18.928     0.200
     1.139    18.787     0.200
     1.227    20.207     0.200
     1.181    20.908     0.200
     1.264    22.037     0.200
     1.610    25.732     0.200
     1.619    26.934     0.200
     1.596    25.818     0.200
     1.668    26.367     0.200
     1.818    30.758     0.200
     1.820    30.768     0.200
     1.932    30.924     0.200
     2.008    31.965     0.200
     2.001    31.139     0.200
     2.031    32.936     0.200
     2.043    31.910     0.200
     2.054    32.189     0.200
     2.034    32.781     0.200
     2.156    35.809     0.200
     2.203    37.027     0.200
     2.211    34.775     0.200
     2.261    35.092     0.200
     2.357    36.420     0.200
     2.451    38.398     0.200
     2.579    39.707     0.200
     2.605    40.434     0.200
     2.659    40.705     0.200
     2.782    43.092     0.200
     2.827    46.107     0.200
     2.870    43.668     0.200
     2.881    44.527     0.200
     2.984    45.475     0.200
     2.934    43.912     0.200
     2.981    45.357     0.200
     3.118    47.105     0.200
     3.165    48.598     0.200
     3.239    49.145     0.200
     3.402    51.299     0.200
     3.412    51.713     0.200
     3.458    52.033     0.200
     3.468    52.117     0.200
     3.468    51.889     0.200
     3.712    56.160     0.200
     3.730    55.273     0.200
     3.807    57.127     0.200
     3.816    57.598     0.200
     3.909    58.398     0.200
     3.989    59.658     0.200
     4.080    61.045     0.200
     4.164    62.488     0.200
     4.251    63.738     0.200
     4.329    64.975     0.200
     4.501    70.309     0.200
     4.548    67.438     0.200
     4.548    66.658     0.200
     4.600    68.662     0.200
     4.806    72.018     0.200
     4.806    71.787     0.200
     4.832    72.457     0.200
     5.451    80.598     0.200
     5.579    82.438     0.200
     5.579    81.566     0.200
     5.813    86.287     0.200
     5.813    86.184     0.200
     5.909    87.668     0.200
     5.909    87.238     0.200
     5.906    87.328     0.200
     5.988    87.098     0.200
     6.152    90.617     0.200
     6.287    92.197     0.200
     6.313    93.848     0.200
     6.460    94.799     0.200
     6.403    95.088     0.200
     6.686    97.898     0.200
     6.895   101.889     0.200
     7.052   102.209     0.200
     7.099   104.287     0.200
     7.300   107.688     0.200
     7.395   108.469     0.200
     7.689   112.197     0.200
     7.673   112.008     0.200
     7.685   111.408     0.200
     7.784   112.697     0.200
     7.810   116.768     0.200
     7.851   116.158     0.200
     7.873   116.848     0.200
     8.031   119.598     0.200
     8.025   118.098     0.200
     8.030   118.357     0.200
     8.030   118.318     0.200
     8.033   118.008     0.200
     8.042   117.348     0.200
     8.049   118.127     0.200
     8.061   118.438     0.200
     8.069   119.508     0.200
     8.071   119.277     0.200
     8.075   118.928     0.200
     8.067   116.627     0.200
     8.089   119.219     0.200
     8.085   116.678     0.200
     8.108   119.648     0.200
     8.111   119.729     0.200
     8.143   120.059     0.200
     8.167   120.758     0.200
     8.203   120.607     0.200
     8.221   121.537     0.200
     8.295   121.768     0.200
     8.340   121.607     0.200
     9.085   133.178     0.200
     9.145   134.729     0.200
     9.177   131.639     0.200
     9.378   135.648     0.200
     9.538   139.668     0.200
     9.712   141.408     0.200
     9.794   142.658     0.200
    10.011   145.158     0.200
    10.737   158.287     0.200
    11.008   158.648     0.200
    11.247   163.068     0.200
    11.247   163.178     0.200
    11.247   163.438     0.200
    11.243   162.117     0.200
    11.233   160.818     0.200
    11.234   160.889     0.200
    11.499   167.479     0.200
    11.563   168.318     0.200
    11.658   169.139     0.200
    11.743   169.508     0.200
    12.064   173.357     0.200
    12.303   180.668     0.200
    12.786   186.578     0.200
    13.335   189.418     0.200
    13.431   190.787     0.200
    13.806   198.398     0.200
    13.846   198.578     0.200
    14.136   203.299     0.200
    14.303   205.688     0.200
    15.831   224.088     0.200
    18.864   260.117     0.200
    19.494   270.168     0.200
    20.957   286.238     0.200
     0.955    16.068     0.200
     0.986    16.513     0.200
     1.236    21.983     0.200
     1.236    21.833     0.200
     1.269    21.963     0.200
     1.272    21.718     0.200
     1.347    23.113     0.200
     1.542    24.847     0.200
     1.571    26.003     0.200
     1.728    27.518     0.200
     1.765    29.013     0.200
     1.796    28.622     0.200
     1.812    28.663     0.200
     1.814    28.653     0.200
     1.984    30.965     0.200
     2.032    31.639     0.200
     2.054    32.023     0.200
     2.221    34.801     0.200
     2.357    36.483     0.200
     2.566    40.183     0.200
     2.681    41.365     0.200
     2.938    45.343     0.200
     2.951    46.263     0.200
     2.977    45.625     0.200
     3.170    49.733     0.200
     3.766    55.473     0.200
     3.766    55.127     0.200
     3.797    59.953     0.200
     4.247    63.536     0.200
     4.374    66.503     0.200
     4.448    67.503     0.200
     4.587    69.803     0.200
     4.662    70.233     0.200
     4.662    70.647     0.200
     4.725    70.593     0.200
     4.810    73.193     0.200
     4.890    73.627     0.200
     5.095    76.379     0.200
     5.144    76.873     0.200
     5.270    78.933     0.200
     5.466    81.707     0.200
     5.628    83.473     0.200
     5.736    84.633     0.200
     5.825    86.673     0.200
     6.221    91.723     0.200
     6.309    91.798     0.200
     6.345    94.153     0.200
     6.410    94.213     0.200
     6.495    96.773     0.200
     6.737    99.633     0.200
     6.845   100.833     0.200
     6.859   100.373     0.200
     7.142   104.643     0.200
     7.212   105.333     0.200
     7.487   109.483     0.200
     7.512   111.209     0.200
     7.523   109.223     0.200
     7.590   111.033     0.200
     7.776   115.953     0.200
     7.841   113.618     0.200
     7.841   114.294     0.200
     7.868   116.983     0.200
     7.953   116.393     0.200
     7.984   117.683     0.200
     8.000   117.733     0.200
     8.001   117.433     0.200
     8.010   118.354     0.200
     8.031   117.833     0.200
     8.037   117.743     0.200
     8.040   117.953     0.200
     8.042   118.623     0.200
     8.046   118.683     0.200
     8.059   118.553     0.200
     8.064   118.633     0.200
     8.076   118.604     0.200
     8.103   119.153     0.200
     8.102   119.133     0.200
     8.110   120.273     0.200
     8.188   120.583     0.200
     8.204   120.683     0.200
     8.280   121.893     0.200
     8.289   120.253     0.200
     8.377   120.373     0.200
     8.508   124.653     0.200
     8.992   130.783     0.200
     9.723   141.703     0.200
     9.752   141.323     0.200
    10.325   148.523     0.200
    10.325   149.798     0.200
    10.918   159.243     0.200
    10.918   158.887     0.200
    11.536   166.223     0.200
     1.210    20.742     0.200
     1.210    21.516     0.200
     1.215    21.672     0.200
     1.269    20.789     0.200
     1.337    23.613     0.200
     1.332    21.742     0.200
     1.350    23.645     0.200
     1.350    23.703     0.200
     1.387    24.254     0.200
     1.567    24.652     0.200
     1.570    24.594     0.200
     1.570    24.820     0.200
     1.618    26.516     0.200
     1.618    26.395     0.200
     1.766    27.633     0.200
     2.011    31.484     0.200
     2.138    32.660     0.200
     2.409    36.742     0.200
     2.941    45.363     0.200
     3.795    57.215     0.200
     3.806    55.855     0.200
     4.106    60.844     0.200
     4.501    67.992     0.200
     4.725    71.355     0.200
     5.039    75.305     0.200
     5.202    75.844     0.200
     5.383    80.324     0.200
     5.496    82.082     0.200
     6.239    95.535     0.200
     7.011   103.973     0.200
     7.178   104.273     0.200
     7.363   108.492     0.200
     7.549   112.234     0.200
     7.863   114.945     0.200
     7.933   116.973     0.200
     8.014   117.023     0.200
     8.020   118.434     0.200
     8.745   126.383     0.200
    10.435   151.020     0.200
    11.047   162.883     0.200
     0.881    15.269     0.200
     0.947    15.702     0.200
     1.155    21.048     0.200
     1.155    20.968     0.200
     1.155    21.139     0.200
     1.174    20.769     0.200
     1.215    20.809     0.200
     1.243    21.729     0.200
     1.243    21.838     0.200
     1.428    23.358     0.200
     1.458    23.412     0.200
     1.465    24.948     0.200
     1.686    26.729     0.200
     1.686    26.623     0.200
     1.661    27.617     0.200
     1.661    27.729     0.200
     1.707    26.938     0.200
     1.707    27.053     0.200
     1.960    30.504     0.200
     2.140    32.778     0.200
     2.140    32.916     0.200
     2.111    33.295     0.200
     2.604    40.028     0.200
     2.596    39.601     0.200
     2.629    40.017     0.200
     2.828    43.531     0.200
     2.879    45.428     0.200
     2.873    44.318     0.200
     3.131    48.788     0.200
     3.108    49.238     0.200
     3.336    51.448     0.200
     3.732    56.639     0.200
     3.841    56.418     0.200
     3.928    59.208     0.200
     4.300    65.368     0.200
     4.340    65.488     0.200
     4.485    66.019     0.200
     4.660    70.519     0.200
     4.660    70.182     0.200
     4.802    73.108     0.200
     4.919    72.488     0.200
     4.906    73.979     0.200
     5.057    75.208     0.200
     5.204    76.378     0.200
     5.490    81.858     0.200
     5.490    81.417     0.200
     6.142    91.678     0.200
     6.142    90.244     0.200
     6.381    92.568     0.200
     6.680   100.158     0.200
     6.929   101.128     0.200
     7.190   105.099     0.200
     7.264   105.898     0.200
     7.286   106.139     0.200
     7.517   110.908     0.200
     7.540   109.559     0.200
     7.885   115.288     0.200
     7.885   114.448     0.200
     8.457   120.488     0.200
     8.457   121.510     0.200
     9.719   142.648     0.200
    10.419   150.559     0.200
    10.419   150.578     0.200
    10.420   150.559     0.200
    11.495   165.917     0.200
    18.299   250.458     0.200
     1.124    19.266     0.200
     1.205    21.559     0.200
     1.214    21.262     0.200
     1.248    21.340     0.200
     1.248    21.441     0.200
     1.295    21.066     0.200
     1.308    21.422     0.200
     1.333    23.770     0.200
     1.450    23.988     0.200
     1.482    24.781     0.200
     1.504    23.953     0.200
     1.600    25.188     0.200
     1.607    25.281     0.200
     1.656    27.180     0.200
     1.746    27.383     0.200
     1.785    27.996     0.200
     2.102    32.121     0.200
     2.138    33.707     0.200
     2.434    37.250     0.200
     2.862    44.023     0.200
     2.948    45.762     0.200
     2.997    46.289     0.200
     3.051    48.141     0.200
     3.051    49.750     0.200
     3.111    46.914     0.200
     3.202    50.180     0.200
     3.671    56.379     0.200
     3.779    57.262     0.200
     3.773    56.348     0.200
     3.773    57.031     0.200
     4.127    61.199     0.200
     4.357    63.621     0.200
     4.493    68.176     0.200
     4.493    68.391     0.200
     4.644    69.637     0.200
     4.726    71.590     0.200
     4.915    73.711     0.200
     4.920    72.988     0.200
     5.046    76.012     0.200
     5.167    74.922     0.200
     5.343    79.887     0.200
     5.343    79.039     0.200
     5.394    80.238     0.200
     5.506    82.441     0.200
     5.606    83.379     0.200
     5.973    88.152     0.200
     5.973    88.379     0.200
     6.122    88.160     0.200
     6.254    90.398     0.200
     6.305    92.477     0.200
     6.305    90.762     0.200
     6.305    92.020     0.200
     6.500    94.582     0.200
     6.543    95.758     0.200
     6.543    95.129     0.200
     6.619    96.129     0.200
     6.794    98.711     0.200
     7.013   101.898     0.200
     7.047   101.961     0.200
     7.152   104.398     0.200
     7.177   105.012     0.200
     7.353   108.973     0.200
     7.430   109.000     0.200
     7.761   111.555     0.200
    10.398   148.734     0.200
    11.312   165.809     0.200
    11.312   165.809     0.200
     0.898    15.238     0.200
     0.950    15.918     0.200
     1.201    21.539     0.200
     1.220    21.082     0.200
     1.229    21.617     0.200
     1.393    23.047     0.200
     1.691    27.109     0.200
     1.718    28.414     0.200
     1.718    28.609     0.200
     1.758    27.848     0.200
     1.983    31.207     0.200
     2.087    32.426     0.200
     2.585    40.090     0.200
     2.629    40.469     0.200
     2.930    45.156     0.200
     3.136    49.180     0.200
     3.164    50.297     0.200
     3.792    55.805     0.200
     3.792    57.469     0.200
     3.902    59.148     0.200
     4.325    65.758     0.200
     4.645    69.969     0.200
     4.645    69.570     0.200
     4.904    73.898     0.200
     5.025    74.309     0.200
     5.150    76.398     0.200
     5.106    75.867     0.200
     5.234    78.090     0.200
     5.462    81.629     0.200
     5.462    81.090     0.200
     5.588    83.430     0.200
     5.698    83.758     0.200
     5.791    85.180     0.200
     6.333    92.199     0.200
     6.333    92.477     0.200
     7.224   105.039     0.200
     7.498   110.238     0.200
     7.848   114.680     0.200
     8.406   121.164     0.200
     8.873   128.199     0.200
    10.363   149.770     0.200
    10.363   149.758     0.200
     0.922    15.814     0.200
     0.962    15.814     0.200
     1.128    18.584     0.200
     1.143    18.444     0.200
     1.115    18.834     0.200
     1.198    20.614     0.200
     1.216    20.894     0.200
     1.231    20.654     0.200
     1.233    20.659     0.200
     1.240    21.314     0.200
     1.287    20.904     0.200
     1.383    22.305     0.200
     1.385    23.184     0.200
     1.420    22.804     0.200
     1.406    23.544     0.200
     1.409    23.774     0.200
     1.438    23.271     0.200
     1.440    24.293     0.200
     1.457    24.344     0.200
     1.501    26.344     0.200
     1.554    25.364     0.200
     1.502    26.384     0.200
     1.626    26.158     0.200
     1.682    27.214     0.200
     1.678    27.524     0.200
     1.699    27.954     0.200
     1.724    27.624     0.200
     1.790    29.464     0.200
     1.980    32.674     0.200
     1.851    30.334     0.200
     1.835    30.864     0.200
     1.949    31.699     0.200
     1.949    31.894     0.200
     1.965    32.304     0.200
     1.998    31.308     0.200
     2.001    31.482     0.200
     2.012    32.814     0.200
     2.012    31.874     0.200
     2.071    32.524     0.200
     2.072    32.555     0.200
     2.114    34.254     0.200
     2.145    33.634     0.200
     2.156    33.900     0.200
     2.176    34.964     0.200
     2.184    34.565     0.200
     2.227    35.464     0.200
     2.326    36.894     0.200
     2.364    37.024     0.200
     2.368    37.384     0.200
     2.398    38.364     0.200
     2.437    37.872     0.200
     2.445    37.924     0.200
     2.452    39.124     0.200
     2.556    39.662     0.200
     2.542    39.547     0.200
     2.745    41.884     0.200
     2.874    44.102     0.200
     2.907    44.408     0.200
     2.942    45.166     0.200
     2.962    44.539     0.200
     3.025    46.651     0.200
     3.025    47.284     0.200
     3.055    46.448     0.200
     3.248    49.497     0.200
     3.302    50.459     0.200
     3.355    51.284     0.200
     3.468    53.063     0.200
     3.504    52.810     0.200
     3.747    56.788     0.200
     3.800    57.128     0.200
     3.870    58.794     0.200
     4.210    63.364     0.200
     4.261    63.583     0.200
     4.312    64.724     0.200
     4.516    67.674     0.200
     4.552    68.082     0.200
     4.641    68.177     0.200
     4.687    70.203     0.200
     4.696    70.834     0.200
     4.929    74.182     0.200
     5.126    76.277     0.200
     5.126    77.064     0.200
     5.201    77.914     0.200
     5.421    80.844     0.200
     5.677    84.434     0.200
     5.676    85.784     0.200
     5.719    86.524     0.200
     5.975    87.822     0.200
     5.975    88.204     0.200
     6.001    90.194     0.200
     6.027    87.694     0.200
     6.084    89.994     0.200
     6.109    89.094     0.200
     6.494    95.894     0.200
     6.556    97.914     0.200
     6.566    96.934     0.200
     6.629   100.694     0.200
     6.815   100.174     0.200
     6.963   104.174     0.200
     7.014   103.754     0.200
     7.170   104.033     0.200
     7.170   104.384     0.200
     7.215   107.034     0.200
     7.583   108.114     0.200
     7.981   116.014     0.200
     8.164   117.874     0.200
     8.261   120.374     0.200
     8.275   120.234     0.200
     8.383   122.124     0.200
     8.566   123.687     0.200
     8.566   125.104     0.200
     9.266   133.347     0.200
     9.401   137.564     0.200
    10.313   147.728     0.200
    11.246   162.384     0.200
    11.246   162.164     0.200
    12.788   181.968     0.200
    12.788   182.534     0.200
     0.839    13.380     0.200
     1.079    17.271     0.200
     1.149    19.780     0.200
     1.225    21.141     0.200
     1.295    21.054     0.200
     1.331    21.840     0.200
     1.320    21.300     0.200
     1.327    23.371     0.200
     1.327    22.210     0.200
     1.374    22.030     0.200
     1.545    22.601     0.200
     1.427    23.680     0.200
     1.424    24.610     0.200
     1.516    25.880     0.200
     1.544    25.150     0.200
     1.570    26.000     0.200
     1.588    25.331     0.200
     1.592    25.210     0.200
     1.594    25.213     0.200
     1.635    26.161     0.200
     1.634    27.128     0.200
     1.634    26.840     0.200
     1.656    26.641     0.200
     1.736    25.680     0.200
     1.741    27.676     0.200
     1.789    28.373     0.200
     2.033    32.137     0.200
     2.125    32.694     0.200
     2.125    32.470     0.200
     2.125    32.891     0.200
     2.434    37.391     0.200
     2.463    38.260     0.200
     2.960    45.930     0.200
     2.981    45.831     0.200
     3.034    47.090     0.200
     3.195    48.610     0.200
     3.654    55.101     0.200
     3.800    57.200     0.200
     3.800    57.490     0.200
     3.797    56.207     0.200
     3.797    56.430     0.200
     4.130    62.090     0.200
     4.230    63.180     0.200
     4.512    68.438     0.200
     4.642    68.430     0.200
     4.926    72.960     0.200
     5.058    74.780     0.200
     5.516    80.820     0.200
     5.618    82.980     0.200
     5.975    87.720     0.200
     5.975    87.990     0.200
     6.064    88.331     0.200
     6.113    88.240     0.200
     6.261    90.831     0.200
     6.329    91.771     0.200
     7.338   105.061     0.200
     7.373   109.082     0.200
     7.784   114.398     0.200
     7.784   111.690     0.200
     7.834   111.851     0.200
     7.843   112.480     0.200
     7.985   113.940     0.200
     8.000   113.661     0.200
     8.039   114.411     0.200
     8.774   124.780     0.200
     9.384   133.630     0.200
     9.604   135.871     0.200
    10.419   147.440     0.200
    12.558   178.970     0.200
    12.866   182.320     0.200
     0.810    14.086     0.200
     0.870    13.969     0.200
     0.910    15.062     0.200
     1.084    17.508     0.200
     1.293    21.078     0.200
     1.338    23.484     0.200
     1.339    23.547     0.200
     1.541    25.406     0.200
     1.454    23.727     0.200
     1.462    24.312     0.200
     1.606    25.312     0.200
     1.613    25.312     0.200
     1.613    25.461     0.200
     1.668    27.383     0.200
     1.689    27.609     0.200
     1.967    30.797     0.200
     2.089    32.047     0.200
     2.089    32.438     0.200
     2.089    31.922     0.200
     3.006    47.539     0.200
     3.162    51.055     0.200
     3.759    56.414     0.200
     4.481    67.492     0.200
     4.973    73.844     0.200
     5.038    74.836     0.200
     5.330    79.234     0.200
     5.387    79.367     0.200
     5.498    81.703     0.200
     5.597    82.656     0.200
     5.919    86.203     0.200
     6.248    92.156     0.200
     6.291    91.695     0.200
     6.611    95.219     0.200
     7.847   115.914     0.200
     7.852   113.930     0.200
     7.915   117.133     0.200
     8.384   120.195     0.200
     9.578   136.062     0.200
    11.795   168.133     0.200
    11.851   168.016     0.200
     0.815    13.984     0.200
     0.910    15.336     0.200
     1.085    17.336     0.200
     1.111    18.250     0.200
     1.140    19.242     0.200
     1.195    19.273     0.200
     1.191    20.672     0.200
     1.225    21.750     0.200
     1.266    21.336     0.200
     1.293    21.102     0.200
     1.347    21.391     0.200
     1.326    23.492     0.200
     1.341    23.570     0.200
     1.377    21.992     0.200
     1.341    23.680     0.200
     1.540    23.492     0.200
     1.458    23.625     0.200
     1.467    24.031     0.200
     1.558    26.625     0.200
     1.581    25.844     0.200
     1.601    25.109     0.200
     1.613    25.250     0.200
     1.614    25.555     0.200
     1.606    26.195     0.200
     1.616    25.531     0.200
     1.616    25.172     0.200
     1.651    26.680     0.200
     1.660    26.336     0.200
     1.681    27.180     0.200
     1.673    27.172     0.200
     1.673    27.539     0.200
     1.694    27.383     0.200
     1.700    26.719     0.200
     1.749    27.375     0.200
     1.744    27.539     0.200
     1.780    28.141     0.200
     1.941    30.500     0.200
     1.968    31.055     0.200
     1.971    30.781     0.200
     2.006    31.414     0.200
     2.063    32.047     0.200
     2.125    33.133     0.200
     2.303    35.953     0.200
     2.433    37.211     0.200
     3.110    46.883     0.200
     3.165    45.344     0.200
     3.753    56.141     0.200
     3.753    55.031     0.200
     4.476    67.977     0.200
     5.034    74.414     0.200
     5.238    79.289     0.200
     5.324    79.781     0.200
     5.920    86.594     0.200
     6.246    90.000     0.200
     6.546    96.297     0.200
     6.650    94.219     0.200
     7.312   104.664     0.200
     7.335   108.477     0.200
     7.741   112.430     0.200
     7.788   109.305     0.200
     7.810   110.180     0.200
     7.847   111.883     0.200
     7.912   112.062     0.200
     7.959   112.773     0.200
     8.080   116.000     0.200
     8.084   118.180     0.200
     8.354   122.211     0.200
    10.378   148.500     0.200
    10.379   150.164     0.200
    11.301   163.516     0.200
    12.002   168.992     0.200
     0.858    13.641     0.200
     0.911    15.461     0.200
     1.081    17.242     0.200
     1.101    18.039     0.200
     1.122    18.742     0.200
     1.181    19.344     0.200
     1.245    20.852     0.200
     1.245    21.539     0.200
     1.293    21.180     0.200
     1.333    21.484     0.200
     1.334    23.422     0.200
     1.374    22.125     0.200
     1.335    23.484     0.200
     1.406    22.789     0.200
     1.543    23.414     0.200
     1.442    23.750     0.200
     1.448    23.984     0.200
     1.444    24.609     0.200
     1.480    24.883     0.200
     1.562    25.656     0.200
     1.587    25.883     0.200
     1.590    24.695     0.200
     1.600    25.594     0.200
     1.600    25.344     0.200
     1.602    25.102     0.200
     1.605    25.336     0.200
     1.605    25.055     0.200
     1.637    26.195     0.200
     1.647    26.375     0.200
     1.653    27.156     0.200
     1.653    27.391     0.200
     1.678    27.070     0.200
     1.731    27.469     0.200
     1.718    26.000     0.200
     1.956    30.773     0.200
     2.048    31.594     0.200
     2.104    32.180     0.200
     2.433    37.062     0.200
     2.834    46.219     0.200
     2.859    43.211     0.200
     2.995    47.000     0.200
     3.049    48.203     0.200
     3.669    54.609     0.200
     3.775    54.000     0.200
     4.125    61.680     0.200
     4.494    68.156     0.200
     5.027    74.906     0.200
     4.984    75.094     0.200
     5.338    79.289     0.200
     5.344    79.055     0.200
     5.505    82.492     0.200
     5.971    87.719     0.200
     6.253    91.133     0.200
     6.307    92.062     0.200
     6.307    90.961     0.200
     6.443    93.789     0.200
     6.498    95.211     0.200
     6.619    95.195     0.200
     6.629    95.055     0.200
     6.655    97.531     0.200
     7.045   103.125     0.200
     7.357   106.133     0.200
     7.354   108.695     0.200
     7.432   108.461     0.200
     7.595   112.484     0.200
     7.763   113.281     0.200
     7.763   112.961     0.200
     7.805   112.656     0.200
     7.859   115.516     0.200
     7.863   117.125     0.200
     7.878   116.242     0.200
     7.929   116.805     0.200
     7.929   113.906     0.200
     8.100   115.664     0.200
     8.400   120.945     0.200
    10.399   149.219     0.200
    10.399   149.234     0.200
    10.400   150.109     0.200
    10.400   149.641     0.200
    11.312   164.508     0.200
    15.245   211.219     0.200
     0.850    14.438     0.200
     0.854    14.758     0.200
     0.858    14.708     0.200
     0.891    14.858     0.200
     0.987    16.349     0.200
     0.972    16.628     0.200
     0.988    16.428     0.200
     1.017    17.048     0.200
     1.127    18.559     0.200
     1.192    19.789     0.200
     1.366    22.778     0.200
     1.377    24.298     0.200
     1.577    25.253     0.200
     1.589    26.135     0.200
     1.643    26.108     0.200
     1.909    30.322     0.200
     2.008    31.501     0.200
     2.001    31.405     0.200
     2.020    31.789     0.200
     2.184    36.678     0.200
     2.879    45.409     0.200
     2.939    43.745     0.200
     3.096    47.798     0.200
     3.204    49.758     0.200
     3.395    51.849     0.200
     3.441    53.088     0.200
     3.455    53.358     0.200
     3.772    57.159     0.200
     3.992    60.858     0.200
     4.129    62.188     0.200
     4.782    71.729     0.200
     4.790    70.769     0.200
     4.802    71.718     0.200
     5.001    74.438     0.200
     5.333    78.809     0.200
     5.435    80.488     0.200
     6.345    93.428     0.200
     7.047   102.178     0.200
     7.951   115.048     0.200
    11.213   162.168     0.200
    11.238   160.818     0.200
    11.470   162.579     0.200
     0.783    13.285     0.200
     0.786    13.633     0.200
     0.841    14.242     0.200
     0.885    14.902     0.200
     0.934    15.684     0.200
     0.963    15.625     0.200
     0.979    16.652     0.200
     1.016    16.824     0.200
     0.995    18.664     0.200
     1.018    16.832     0.200
     1.112    18.402     0.200
     1.338    21.445     0.200
     1.188    20.824     0.200
     1.254    20.902     0.200
     1.327    22.613     0.200
     1.327    21.855     0.200
     1.341    23.172     0.200
     1.342    22.863     0.200
     1.367    22.984     0.200
     1.378    23.625     0.200
     1.402    22.254     0.200
     1.492    23.824     0.200
     1.464    25.125     0.200
     1.504    23.484     0.200
     1.520    23.562     0.200
     1.487    24.805     0.200
     1.553    24.395     0.200
     1.582    24.875     0.200
     1.570    24.582     0.200
     1.624    25.812     0.200
     1.642    26.812     0.200
     1.656    26.562     0.200
     1.660    27.453     0.200
     1.696    28.234     0.200
     1.747    29.273     0.200
     1.813    27.742     0.200
     1.825    28.195     0.200
     1.827    28.242     0.200
     1.842    30.074     0.200
     1.844    31.016     0.200
     1.868    29.254     0.200
     1.892    29.953     0.200
     1.945    29.973     0.200
     1.945    29.832     0.200
     2.046    34.363     0.200
     2.446    38.035     0.200
     2.630    39.953     0.200
     2.906    43.242     0.200
     3.067    47.824     0.200
     3.646    53.703     0.200
     3.646    53.363     0.200
     4.194    62.215     0.200
     4.303    64.863     0.200
     4.531    68.742     0.200
     4.817    72.344     0.200
     4.841    71.582     0.200
     4.889    72.305     0.200
     5.042    74.875     0.200
     5.162    76.934     0.200
     5.202    77.395     0.200
     5.530    82.266     0.200
     5.715    85.383     0.200
     6.157    90.293     0.200
     6.187    89.152     0.200
     6.187    89.312     0.200
     6.292    90.973     0.200
     6.660    96.574     0.200
     6.820    98.934     0.200
     7.707   112.016     0.200
     0.753    12.931     0.200
     0.855    14.320     0.200
     0.878    13.931     0.200
     1.066    17.351     0.200
     1.097    19.771     0.200
     1.184    19.341     0.200
     1.182    20.530     0.200
     1.219    21.521     0.200
     1.227    21.141     0.200
     1.290    21.311     0.200
     1.349    23.570     0.200
     1.551    22.580     0.200
     1.551    21.521     0.200
     1.551    22.771     0.200
     1.448    23.620     0.200
     1.457    23.971     0.200
     1.458    24.421     0.200
     1.485    23.891     0.200
     1.492    24.820     0.200
     1.551    26.070     0.200
     1.551    26.540     0.200
     1.605    25.190     0.200
     1.711    28.561     0.200
     1.711    26.240     0.200
     1.711    26.471     0.200
     2.238    34.330     0.200
     2.930    44.110     0.200
     3.054    48.030     0.200
     3.113    45.261     0.200
     3.194    47.721     0.200
     3.349    50.561     0.200
     3.610    53.650     0.200
     3.721    57.521     0.200
     3.760    55.620     0.200
     3.977    58.790     0.200
     4.112    62.211     0.200
     4.239    63.211     0.200
     4.324    64.160     0.200
     4.474    67.681     0.200
     4.548    67.521     0.200
     4.632    68.471     0.200
     4.707    70.650     0.200
     4.897    72.721     0.200
     4.901    72.471     0.200
     4.980    73.030     0.200
     5.028    75.320     0.200
     5.189    76.051     0.200
     5.462    80.570     0.200
     5.488    81.080     0.200
     5.587    82.711     0.200
     5.673    82.851     0.200
     5.959    86.761     0.200
     6.291    91.851     0.200
     6.291    91.721     0.200
     6.368    92.561     0.200
     6.535    95.711     0.200
     6.535    93.421     0.200
     6.641    95.681     0.200
     7.051   101.780     0.200
     7.160   104.181     0.200
     7.334   108.471     0.200
     7.743   111.570     0.200
     7.743   113.340     0.200
     7.922   111.570     0.200
     7.954   114.131     0.200
     8.045   115.650     0.200
     8.150   117.700     0.200
     8.191   117.801     0.200
     8.345   121.070     0.200
     9.318   133.989     0.200
    10.388   149.546     0.200
    11.077   162.299     0.200
    11.294   163.104     0.200
    14.102   196.700     0.200
    14.265   199.940     0.200
    14.632   205.330     0.200
    15.042   210.381     0.200
    15.616   217.011     0.200
    15.665   220.131     0.200
    15.928   223.261     0.200
    15.928   222.515     0.200
    16.468   230.091     0.200
    16.711   232.021     0.200
    17.039   235.381     0.200
    17.661   244.681     0.200
    18.098   249.240     0.200
    18.190   250.120     0.200
     0.797    13.664     0.200
     0.879    14.914     0.200
     0.898    15.273     0.200
     1.191    20.664     0.200
     1.374    20.102     0.200
     1.211    21.086     0.200
     1.281    22.023     0.200
     1.540    26.367     0.200
     1.665    25.195     0.200
     1.685    26.664     0.200
     1.737    27.414     0.200
     2.325    36.156     0.200
     2.587    39.828     0.200
     3.035    44.922     0.200
     3.144    48.211     0.200
     3.361    50.406     0.200
     3.551    52.828     0.200
     3.735    55.641     0.200
     3.740    54.984     0.200
     3.908    58.758     0.200
     4.156    62.453     0.200
     4.312    64.953     0.200
     4.646    70.258     0.200
     4.731    70.812     0.200
     4.780    72.258     0.200
     4.821    71.594     0.200
     4.884    71.734     0.200
     4.884    74.531     0.200
     5.220    78.008     0.200
     5.628    83.305     0.200
     5.727    85.086     0.200
     5.786    86.141     0.200
     6.156    90.531     0.200
     6.347    92.562     0.200
     6.474    94.328     0.200
     6.704    98.938     0.200
     6.843   100.938     0.200
     6.851    98.977     0.200
     7.383   106.633     0.200
     7.501   110.641     0.200
     7.501   110.906     0.200
     7.511   109.094     0.200
     7.858   114.742     0.200
     7.858   114.531     0.200
     7.858   114.977     0.200
     7.918   115.992     0.200
     7.978   118.242     0.200
     8.238   122.758     0.200
     8.422   121.008     0.200
     8.473   124.352     0.200
     8.544   123.906     0.200
     8.897   129.492     0.200
     8.952   130.617     0.200
     9.166   133.477     0.200
     9.547   137.984     0.200
     9.729   141.125     0.200
     9.861   145.031     0.200
     9.865   140.484     0.200
    10.220   147.070     0.200
    10.383   149.484     0.200
    10.574   152.727     0.200
    10.661   153.633     0.200
    10.903   158.602     0.200
    11.069   161.703     0.200
    11.227   162.773     0.200
    11.380   165.773     0.200
    11.477   165.117     0.200
    11.494   165.883     0.200
    12.542   179.094     0.200
    14.005   195.672     0.200
    14.005   199.484     0.200
    14.821   209.195     0.200
    15.110   210.203     0.200
    15.576   219.312     0.200
    15.609   222.688     0.200
    16.066   226.602     0.200
    16.123   228.992     0.200
    16.123   227.227     0.200
    16.159   226.375     0.200
    16.808   234.117     0.200
    17.040   235.711     0.200
    18.648   258.297     0.200
     0.678    11.531     0.200
     0.734    12.681     0.200
     0.889    14.791     0.200
     0.902    15.141     0.200
     0.954    15.831     0.200
     0.958    15.601     0.200
     0.970    15.771     0.200
     1.022    17.440     0.200
     1.042    18.230     0.200
     1.098    18.631     0.200
     1.128    18.021     0.200
     1.141    18.601     0.200
     1.144    18.650     0.200
     1.144    18.531     0.200
     1.150    18.980     0.200
     1.172    20.011     0.200
     1.190    19.671     0.200
     1.193    19.750     0.200
     1.194    19.651     0.200
     1.214    19.801     0.200
     1.252    20.781     0.200
     1.269    21.521     0.200
     1.281    20.940     0.200
     1.297    20.361     0.200
     1.315    21.791     0.200
     1.314    20.710     0.200
     1.383    22.111     0.200
     1.410    22.651     0.200
     1.465    23.771     0.200
     1.478    23.721     0.200
     1.486    23.681     0.200
     1.513    24.201     0.200
     1.513    24.281     0.200
     1.504    23.891     0.200
     1.545    24.611     0.200
     1.807    28.421     0.200
     1.988    30.480     0.200
     1.883    30.401     0.200
     2.137    32.071     0.200
     2.153    33.571     0.200
     2.300    35.591     0.200
     2.452    36.771     0.200
     2.556    39.641     0.200
     2.616    40.641     0.200
     2.718    41.561     0.200
     2.723    42.471     0.200
     2.746    42.051     0.200
     3.021    46.061     0.200
     3.074    46.750     0.200
     3.146    47.591     0.200
     3.230    49.041     0.200
     3.242    48.661     0.200
     3.262    49.161     0.200
     3.382    50.771     0.200
     3.491    51.730     0.200
     3.545    53.201     0.200
     3.756    55.741     0.200
     3.778    56.521     0.200
     3.811    56.741     0.200
     3.858    56.631     0.200
     4.051    59.471     0.200
     4.226    62.371     0.200
     4.426    65.361     0.200
     4.486    66.401     0.200
     4.651    68.601     0.200
     4.746    69.521     0.200
     4.996    73.221     0.200
     5.211    76.051     0.200
     5.498    80.081     0.200
     5.718    82.440     0.200
     6.089    90.325     0.200
     6.089    87.921     0.200
     6.309    91.031     0.200
     6.555    94.791     0.200
    10.748   153.906     0.200
    10.748   153.271     0.200
    15.128   212.211     0.200
     0.854    14.443     0.200
     0.860    14.344     0.200
     0.864    13.555     0.200
     1.096    18.014     0.200
     1.204    21.324     0.200
     1.212    21.023     0.200
     1.244    21.514     0.200
     1.286    21.004     0.200
     1.306    21.145     0.200
     1.308    23.305     0.200
     1.329    21.273     0.200
     1.342    23.475     0.200
     1.550    22.684     0.200
     1.550    22.834     0.200
     1.560    25.574     0.200
     1.585    25.104     0.200
     1.600    25.174     0.200
     1.600    25.285     0.200
     1.721    25.344     0.200
     2.105    32.414     0.200
     2.230    35.254     0.200
     3.774    55.625     0.200
     4.988    76.664     0.200
     5.259    75.354     0.200
     6.529    96.074     0.200
     6.534    94.674     0.200
     7.759   112.898     0.200
     8.350   120.779     0.200
    10.401   149.879     0.200
    11.304   164.045     0.200
     0.896    15.008     0.200
     0.896    15.528     0.200
     0.939    15.538     0.200
     0.984    16.738     0.200
     1.079    18.158     0.200
     1.082    17.548     0.200
     1.093    17.938     0.200
     1.114    17.908     0.200
     1.146    20.738     0.200
     1.191    21.328     0.200
     1.266    21.548     0.200
     1.319    23.308     0.200
     1.345    22.748     0.200
     1.350    21.708     0.200
     1.373    22.888     0.200
     1.524    22.568     0.200
     1.465    24.048     0.200
     1.466    23.738     0.200
     1.575    25.676     0.200
     1.575    25.178     0.200
     1.625    26.688     0.200
     1.764    28.278     0.200
     1.765    29.468     0.200
     1.795    27.868     0.200
     1.817    27.788     0.200
     2.195    34.968     0.200
     2.330    36.718     0.200
     2.597    39.638     0.200
     2.930    44.098     0.200
     2.979    45.728     0.200
     3.177    47.328     0.200
     3.209    47.918     0.200
     3.483    52.528     0.200
     3.689    55.508     0.200
     3.805    56.978     0.200
     3.919    57.178     0.200
     3.919    57.818     0.200
     3.937    60.058     0.200
     4.012    59.108     0.200
     4.591    68.048     0.200
     4.643    70.488     0.200
     4.680    69.888     0.200
     4.687    70.488     0.200
     5.027    75.008     0.200
     5.048    74.418     0.200
     5.102    75.978     0.200
     5.165    76.858     0.200
     5.500    81.298     0.200
     5.616    82.438     0.200
     5.624    83.168     0.200
     6.554    97.114     0.200
     7.920   116.597     0.200
     8.428   122.625     0.200
    10.521   151.928     0.200
    10.522   151.955     0.200
    11.429   168.044     0.200
     0.894    15.129     0.200
     0.908    15.512     0.200
     0.939    16.141     0.200
     0.918    15.750     0.200
     0.944    15.641     0.200
     0.976    16.551     0.200
     0.938    11.871     0.200
     1.009    17.102     0.200
     1.022    17.219     0.200
     1.021    17.051     0.200
     1.009    13.051     0.200
     1.050    19.500     0.200
     1.108    20.379     0.200
     1.199    20.289     0.200
     1.274    20.988     0.200
     1.336    23.699     0.200
     1.470    24.250     0.200
     1.499    24.270     0.200
     1.536    24.898     0.200
     1.616    26.230     0.200
     1.745    27.828     0.200
     1.964    31.121     0.200
     2.140    33.641     0.200
     2.330    35.359     0.200
     2.379    36.668     0.200
     2.432    38.020     0.200
     2.579    39.738     0.200
     2.660    40.859     0.200
     2.688    41.289     0.200
     2.675    40.219     0.200
     2.757    42.020     0.200
     2.866    43.961     0.200
     2.924    44.891     0.200
     3.061    46.762     0.200
     3.053    44.980     0.200
     3.337    50.398     0.200
     3.335    50.500     0.200
     3.405    51.262     0.200
     3.485    53.609     0.200
     3.514    52.941     0.200
     3.806    57.469     0.200
     4.037    61.020     0.200
     4.104    60.578     0.200
     4.105    61.531     0.200
     4.137    61.898     0.200
     4.152    61.730     0.200
     4.249    64.359     0.200
     4.289    63.469     0.200
     4.629    69.988     0.200
     4.709    70.609     0.200
     4.707    71.148     0.200
     4.733    70.488     0.200
     4.773    71.590     0.200
     4.762    69.961     0.200
     4.942    74.371     0.200
     5.228    77.941     0.200
     5.320    79.328     0.200
     5.548    82.078     0.200
     5.539    81.910     0.200
     5.695    83.301     0.200
     5.728    83.371     0.200
     6.796    98.648     0.200
     7.545   109.328     0.200
     7.714   111.781     0.200
     8.111   118.160     0.200
    10.974   157.191     0.200
    11.179   161.484     0.200
    15.547   217.660     0.200
     1.176    21.408     0.200
     1.176    21.527     0.200
     1.176    20.787     0.200
     1.244    20.877     0.200
     1.225    22.158     0.200
     1.225    21.258     0.200
     1.256    21.537     0.200
     1.310    21.828     0.200
     1.272    23.168     0.200
     1.272    22.717     0.200
     1.293    22.467     0.200
     1.299    22.387     0.200
     1.328    21.658     0.200
     1.340    21.857     0.200
     1.531    22.547     0.200
     1.531    22.027     0.200
     1.431    23.867     0.200
     1.460    22.898     0.200
     1.460    24.697     0.200
     1.532    25.098     0.200
     1.513    26.527     0.200
     1.547    25.479     0.200
     1.591    24.898     0.200
     1.604    25.309     0.200
     1.604    25.441     0.200
     1.633    26.238     0.200
     1.569    26.387     0.200
     1.671    29.168     0.200
     1.726    27.518     0.200
     1.724    28.188     0.200
     1.754    27.688     0.200
     1.733    27.479     0.200
     1.805    29.158     0.200
     1.805    29.367     0.200
     1.817    28.648     0.200
     1.844    29.488     0.200
     1.842    31.107     0.200
     1.927    31.828     0.200
     1.922    30.328     0.200
     1.989    31.658     0.200
     2.039    32.068     0.200
     2.195    34.568     0.200
     2.227    35.537     0.200
     2.223    35.797     0.200
     2.283    35.697     0.200
     2.439    38.088     0.200
     2.744    43.248     0.200
     2.976    45.457     0.200
     2.987    48.877     0.200
     3.702    59.137     0.200
     3.813    57.627     0.200
     3.802    56.447     0.200
     4.527    68.479     0.200
     4.757    71.707     0.200
     4.942    74.127     0.200
     4.954    73.748     0.200
     5.275    76.887     0.200
     5.850    84.678     0.200
     6.550    96.863     0.200
     7.795   114.742     0.200
     8.147   117.768     0.200
     8.378   122.373     0.200
    10.421   151.172     0.200
    11.340   165.748     0.200
    11.320   166.738     0.200
    14.311   200.287     0.200
    15.229   212.357     0.200
    15.560   217.418     0.200
    17.085   236.848     0.200
     0.922    15.319     0.200
     0.998    18.449     0.200
     1.116    17.889     0.200
     1.245    21.239     0.200
     1.270    22.519     0.200
     1.342    21.809     0.200
     1.511    24.299     0.200
     1.511    23.729     0.200
     1.395    23.039     0.200
     1.522    25.619     0.200
     1.584    25.589     0.200
     1.596    25.409     0.200
     1.606    25.688     0.200
     1.661    26.929     0.200
     1.758    27.418     0.200
     1.795    30.049     0.200
     2.027    32.619     0.200
     2.209    34.839     0.200
     2.318    36.309     0.200
     2.535    39.519     0.200
     2.737    42.619     0.200
     3.521    54.749     0.200
     3.871    58.799     0.200
     4.686    70.079     0.200
     5.010    74.529     0.200
     5.230    77.249     0.200
     7.850   114.388     0.200
     8.414   124.394     0.200
    10.456   150.494     0.200
     0.866    14.547     0.200
     0.872    13.816     0.200
     1.081    18.406     0.200
     1.221    21.547     0.200
     1.221    21.738     0.200
     1.230    21.477     0.200
     1.263    22.316     0.200
     1.285    21.848     0.200
     1.294    21.047     0.200
     1.291    21.316     0.200
     1.299    23.289     0.200
     1.333    23.906     0.200
     1.339    23.438     0.200
     1.540    23.938     0.200
     1.540    25.367     0.200
     1.554    25.348     0.200
     1.555    25.816     0.200
     1.578    25.949     0.200
     1.615    25.066     0.200
     1.615    25.328     0.200
     1.691    27.777     0.200
     1.703    25.219     0.200
     1.832    29.168     0.200
     1.829    28.977     0.200
     2.047    32.219     0.200
     2.431    40.488     0.200
     2.443    40.738     0.200
     2.474    40.059     0.200
     2.538    41.867     0.200
     2.761    42.180     0.200
     2.940    46.508     0.200
     3.398    53.438     0.200
     3.757    56.617     0.200
     3.764    56.379     0.200
     3.763    56.168     0.200
     4.089    61.578     0.200
     4.100    62.328     0.200
     4.123    63.039     0.200
     4.479    67.879     0.200
     4.715    71.020     0.200
     4.904    72.629     0.200
     8.356   124.359     0.200
    10.383   150.930     0.200
    11.303   165.043     0.200
     0.941    15.695     0.200
     1.010    16.676     0.200
     1.224    19.375     0.200
     1.217    21.426     0.200
     1.224    21.227     0.200
     1.283    21.006     0.200
     1.293    21.195     0.200
     1.335    21.346     0.200
     1.326    22.576     0.200
     1.348    23.807     0.200
     1.551    22.936     0.200
     1.551    24.467     0.200
     1.549    26.955     0.200
     1.604    25.176     0.200
     1.712    27.076     0.200
     1.712    26.346     0.200
     1.712    26.426     0.200
     1.738    27.695     0.200
     1.772    28.375     0.200
     1.884    31.717     0.200
     1.955    30.916     0.200
     1.959    30.666     0.200
     1.991    31.025     0.200
     2.036    31.666     0.200
     2.093    32.066     0.200
     2.237    34.916     0.200
     2.282    35.967     0.200
     2.421    36.945     0.200
     2.426    37.307     0.200
     2.751    41.727     0.200
     3.393    51.326     0.200
     3.762    56.926     0.200
     3.764    56.125     0.200
     3.762    55.775     0.200
     3.762    55.586     0.200
     4.476    67.967     0.200
     4.709    70.955     0.200
     4.899    73.086     0.200
     6.293    91.496     0.200
    10.390   149.873     0.200
    15.929   224.705     0.200
     0.835    14.289     0.200
     0.868    14.688     0.200
     0.911    15.449     0.200
     0.950    15.938     0.200
     0.970    16.488     0.200
     1.179    19.527     0.200
     1.317    22.129     0.200
     1.440    25.828     0.200
     1.532    24.637     0.200
     1.576    25.309     0.200
     1.805    28.598     0.200
     1.861    29.488     0.200
     1.896    29.738     0.200
     1.919    30.258     0.200
     1.955    29.750     0.200
     2.223    30.969     0.200
     2.241    33.656     0.200
     2.423    37.707     0.200
     2.556    39.539     0.200
     2.743    42.508     0.200
     2.864    43.656     0.200
     2.863    45.750     0.200
     2.896    44.699     0.200
     2.867    42.906     0.200
     3.079    46.566     0.200
     3.158    47.699     0.200
     3.179    48.289     0.200
     3.254    48.918     0.200
     3.398    51.156     0.200
     3.558    54.137     0.200
     3.702    56.898     0.200
     3.749    56.590     0.200
     3.983    59.840     0.200
     4.015    59.277     0.200
     4.012    60.008     0.200
     4.158    62.617     0.200
     4.184    63.566     0.200
     4.307    64.770     0.200
     4.301    63.340     0.200
     4.470    65.457     0.200
     4.566    68.059     0.200
     4.569    66.867     0.200
     4.591    67.379     0.200
     4.715    70.348     0.200
     4.747    70.898     0.200
     4.821    71.949     0.200
     4.886    72.129     0.200
     4.954    73.629     0.200
     4.966    73.137     0.200
     5.187    74.898     0.200
     5.271    77.656     0.200
     5.349    80.500     0.200
     5.359    79.098     0.200
     5.391    79.367     0.200
     5.419    79.879     0.200
     5.535    81.750     0.200
     5.567    82.348     0.200
     5.693    83.668     0.200
     5.779    84.340     0.200
     5.859    85.066     0.200
     5.893    86.805     0.200
     5.893    84.809     0.200
     5.893    85.688     0.200
     5.869    85.207     0.200
     5.937    85.969     0.200
     5.917    85.098     0.200
     5.974    85.867     0.200
     6.309    91.988     0.200
     6.438    93.477     0.200
     6.677    96.770     0.200
     6.893   100.188     0.200
     6.970   100.430     0.200
     7.303   102.488     0.200
     7.387   106.059     0.200
     7.452   105.719     0.200
     7.695   109.797     0.200
     7.819   111.277     0.200
     7.937   114.277     0.200
     7.937   113.129     0.200
     7.973   112.977     0.200
     8.021   112.656     0.200
     8.044   118.188     0.200
     8.249   118.848     0.200
     8.871   127.000     0.200
     9.098   130.227     0.200
     9.627   136.777     0.200
     9.919   142.656     0.200
    11.173   158.359     0.200
    11.173   161.379     0.200
    11.165   159.430     0.200
    12.594   178.840     0.200
    13.041   183.000     0.200
     0.842    14.121     0.200
     0.930    15.531     0.200
     0.937    15.980     0.200
     0.974    16.090     0.200
     1.026    16.941     0.200
     1.027    16.910     0.200
     1.017    16.832     0.200
     1.011    17.871     0.200
     1.053    17.043     0.200
     1.060    17.711     0.200
     1.052    18.051     0.200
     1.031    18.293     0.200
     1.077    18.109     0.200
     1.112    18.512     0.200
     1.152    19.512     0.200
     1.184    19.160     0.200
     1.190    19.922     0.200
     1.197    19.473     0.200
     1.196    19.551     0.200
     1.197    19.566     0.200
     1.197    19.609     0.200
     1.196    19.570     0.200
     1.195    19.793     0.200
     1.244    20.332     0.200
     1.276    20.609     0.200
     1.261    20.973     0.200
     1.285    21.441     0.200
     1.326    21.762     0.200
     1.343    21.609     0.200
     1.333    22.082     0.200
     1.332    21.941     0.200
     1.366    22.141     0.200
     1.361    22.211     0.200
     1.413    22.781     0.200
     1.413    22.832     0.200
     1.392    23.102     0.200
     1.444    23.109     0.200
     1.426    23.512     0.200
     1.439    23.352     0.200
     1.484    24.242     0.200
     1.491    24.180     0.200
     1.523    24.570     0.200
     1.549    24.770     0.200
     1.549    25.020     0.200
     1.555    25.070     0.200
     1.562    25.531     0.200
     1.561    24.973     0.200
     1.586    25.430     0.200
     1.632    26.391     0.200
     1.625    26.223     0.200
     1.652    26.441     0.200
     1.701    27.301     0.200
     1.784    26.152     0.200
     1.820    29.301     0.200
     1.841    29.410     0.200
     1.874    30.461     0.200
     1.868    29.609     0.200
     1.893    30.391     0.200
     1.986    31.672     0.200
     2.101    31.852     0.200
    15.610   217.965     0.200
     0.926    15.430     0.200
     1.023    17.008     0.200
     1.015    16.641     0.200
     1.195    19.914     0.200
     1.195    19.305     0.200
     1.209    20.492     0.200
     1.279    22.133     0.200
     1.284    23.273     0.200
     1.306    23.938     0.200
     1.367    22.344     0.200
     1.369    24.680     0.200
     1.426    23.484     0.200
     1.506    24.539     0.200
     1.508    24.664     0.200
     1.630    25.953     0.200
     1.925    30.398     0.200
     1.873    29.242     0.200
     2.052    31.742     0.200
     2.122    33.523     0.200
     2.217    34.500     0.200
     2.267    35.805     0.200
     2.344    36.117     0.200
     2.492    39.812     0.200
     2.653    40.734     0.200
     2.777    43.211     0.200
     2.808    44.492     0.200
     3.121    48.820     0.200
     3.823    56.383     0.200
     6.152    91.883     0.200
     7.898   116.633     0.200
    10.731   153.562     0.200
    11.121   161.383     0.200
     0.933    15.707     0.200
     0.950    15.838     0.200
     0.942    15.979     0.200
     0.942    16.178     0.200
     0.994    17.107     0.200
     1.001    17.098     0.200
     0.995    17.207     0.200
     1.010    17.197     0.200
     1.009    17.348     0.200
     1.010    17.396     0.200
     1.012    17.197     0.200
     1.010    17.428     0.200
     1.059    18.238     0.200
     1.107    18.828     0.200
     1.166    19.898     0.200
     1.208    20.457     0.200
     1.210    20.568     0.200
     1.277    21.537     0.200
     1.292    21.578     0.200
     1.300    22.107     0.200
     1.291    21.617     0.200
     1.309    22.248     0.200
     1.317    22.238     0.200
     1.314    22.867     0.200
     1.348    22.738     0.200
     1.360    22.928     0.200
     1.347    24.338     0.200
     1.332    24.527     0.200
     1.409    23.988     0.200
     1.442    24.768     0.200
     1.460    24.389     0.200
     1.414    25.457     0.200
     1.432    26.559     0.200
     1.432    24.018     0.200
     1.472    24.678     0.200
     1.554    25.867     0.200
     1.593    27.068     0.200
     1.710    29.207     0.200
     1.779    28.537     0.200
     1.952    31.508     0.200
     2.073    30.268     0.200
     1.966    31.088     0.200
     2.120    34.168     0.200
     2.140    33.848     0.200
     2.142    35.707     0.200
     2.292    36.178     0.200
     2.419    37.738     0.200
     2.409    39.018     0.200
     2.544    40.178     0.200
     2.569    39.998     0.200
     2.684    41.639     0.200
     2.692    42.078     0.200
     2.766    42.857     0.200
     2.890    45.178     0.200
     2.906    45.188     0.200
     3.017    46.309     0.200
     3.031    47.547     0.200
     3.053    47.098     0.200
     3.129    48.168     0.200
     3.184    48.268     0.200
     3.250    49.928     0.200
     3.319    50.729     0.200
     3.348    51.957     0.200
     3.514    53.277     0.200
     3.513    54.158     0.200
     3.731    57.947     0.200
     3.817    57.668     0.200
     3.821    57.838     0.200
     4.070    61.848     0.200
     4.088    61.068     0.200
     4.105    62.088     0.200
     4.128    62.107     0.200
     4.156    63.758     0.200
     4.178    62.857     0.200
     4.181    63.018     0.200
     4.186    62.758     0.200
     4.225    63.967     0.200
     4.241    64.389     0.200
     4.300    65.127     0.200
     4.322    63.867     0.200
     4.720    70.748     0.200
     4.732    71.418     0.200
     4.793    72.068     0.200
     4.942    73.617     0.200
     4.964    74.328     0.200
     5.008    74.668     0.200
     5.021    74.918     0.200
     5.055    75.398     0.200
     5.142    77.107     0.200
     5.237    78.059     0.200
     5.262    78.107     0.200
     5.354    79.018     0.200
     5.370    80.467     0.200
     5.450    80.908     0.200
     5.545    82.127     0.200
     5.573    82.988     0.200
     5.636    83.648     0.200
     5.655    84.139     0.200
     5.728    84.127     0.200
     5.760    84.627     0.200
     6.026    88.449     0.200
     6.026    89.338     0.200
     6.050    89.797     0.200
     6.102    91.467     0.200
     6.565    96.568     0.200
     6.682    98.688     0.200
     6.829    99.598     0.200
     6.938   101.527     0.200
     7.383   108.059     0.200
     7.556   109.867     0.200
     7.710   112.988     0.200
     7.748   112.508     0.200
     8.021   116.455     0.200
     8.021   117.648     0.200
     8.144   117.277     0.200
     8.144   118.418     0.200
     8.145   118.188     0.200
     8.145   118.537     0.200
     8.952   128.428     0.200
     9.473   136.688     0.200
    10.442   149.797     0.200
    10.702   153.627     0.200
    10.829   155.447     0.200
    11.004   158.207     0.200
    11.005   157.508     0.200
    11.005   157.867     0.200
    11.198   162.041     0.200
    11.218   159.918     0.200
    11.930   168.668     0.200
    12.091   171.139     0.200
    13.679   192.648     0.200
    14.149   201.367     0.200
    14.314   203.428     0.200
    14.357   203.688     0.200
    14.371   204.467     0.200
    14.396   204.178     0.200
    14.436   204.479     0.200
    14.464   204.188     0.200
    14.568   206.508     0.200
    14.599   207.547     0.200
    14.612   207.068     0.200
    14.682   207.287     0.200
    14.779   208.729     0.200
    14.848   209.998     0.200
    14.981   212.508     0.200
    15.054   212.457     0.200
    15.075   213.678     0.200
    15.126   213.287     0.200
    15.145   213.309     0.200
    15.179   213.748     0.200
    15.277   214.838     0.200
    15.283   215.928     0.200
    15.330   216.957     0.200
    15.551   220.908     0.200
    15.588   219.787     0.200
    15.637   219.857     0.200
    15.880   223.088     0.200
    15.925   223.658     0.200
    15.958   224.047     0.200
    16.086   225.508     0.200
    16.122   227.037     0.200
    17.168   238.967     0.200
    17.346   241.357     0.200
    17.414   242.488     0.200
    19.270   265.148     0.200
    20.586   280.238     0.200
     0.986    16.502     0.200
     1.041    17.172     0.200
     1.045    17.971     0.200
     1.190    19.980     0.200
     1.287    21.361     0.200
     1.290    21.992     0.200
     1.327    24.311     0.200
     1.346    22.381     0.200
     1.609    25.611     0.200
     1.485    24.271     0.200
     1.512    24.471     0.200
     1.603    25.852     0.200
     1.649    27.121     0.200
     1.685    27.291     0.200
     1.811    29.082     0.200
     1.813    30.422     0.200
     1.887    29.332     0.200
     1.929    31.121     0.200
     1.906    29.242     0.200
     2.068    33.021     0.200
     2.240    35.832     0.200
     2.311    35.730     0.200
     2.376    36.531     0.200
     2.505    38.451     0.200
     2.603    40.951     0.200
     2.816    42.941     0.200
     2.886    43.271     0.200
     3.026    46.371     0.200
     3.038    47.602     0.200
     3.111    47.461     0.200
     3.126    47.980     0.200
     3.389    51.242     0.200
     3.494    53.381     0.200
     3.584    52.932     0.200
     3.718    57.602     0.200
     3.933    60.691     0.200
     3.960    60.031     0.200
     3.980    59.400     0.200
     3.986    59.811     0.200
     3.986    57.611     0.200
     4.116    61.582     0.200
     4.139    63.641     0.200
     4.197    64.711     0.200
     4.227    64.641     0.200
     4.245    64.871     0.200
     4.291    65.521     0.200
     4.407    67.121     0.200
     4.568    68.861     0.200
     4.648    70.582     0.200
     4.840    72.961     0.200
     4.992    74.662     0.200
     5.112    76.221     0.200
     5.135    77.121     0.200
     5.142    76.621     0.200
     5.197    77.352     0.200
     5.259    79.281     0.200
     5.346    80.471     0.200
     5.339    79.861     0.200
     5.416    79.582     0.200
     5.461    82.162     0.200
     5.526    82.721     0.200
     5.529    84.861     0.200
     6.518    95.361     0.200
     6.730    99.412     0.200
     6.999   103.811     0.200
     7.152   105.561     0.200
     7.322   107.361     0.200
     7.513   111.682     0.200
     7.513   109.641     0.200
     7.849   115.521     0.200
     7.996   119.492     0.200
    13.325   187.871     0.200
    13.361   189.111     0.200
     0.773    13.646     0.200
     1.065    18.086     0.200
     1.170    19.957     0.200
     1.035    17.697     0.200
     1.160    19.266     0.200
     1.236    20.576     0.200
     0.848    14.227     0.200
     0.983    16.756     0.200
     0.850    14.316     0.200
     0.837    13.807     0.200
     0.809    13.516     0.200
     0.737    12.516     0.200
     1.212    20.146     0.200
     0.826    13.846     0.200
     1.108    18.346     0.200
     0.954    15.447     0.200
     1.247    19.117     0.200
     1.057    17.277     0.200
     1.355    22.027     0.200
     1.251    20.527     0.200
     1.095    18.176     0.200
     1.173    19.438     0.200
     1.250    20.646     0.200
     1.103    17.787     0.200
     1.103    17.986     0.200
     1.103    17.971     0.200
     0.957    15.916     0.200
     1.087    17.527     0.200
     1.240    20.277     0.200
     0.922    15.086     0.200
     0.875    14.836     0.200
     0.922    15.406     0.200
     1.141    18.586     0.200
     1.222    19.938     0.200
     0.965    16.836     0.200
     1.239    19.857     0.200
     1.343    21.486     0.200
     1.261    20.447     0.200
     1.767    27.766     0.200
     1.534    24.557     0.200
     1.533    24.367     0.200
     1.312    21.107     0.200
     1.418    22.846     0.200
     2.258    35.006     0.200
     1.951    30.727     0.200
     2.046    31.867     0.200
     1.937    30.656     0.200
     2.489    37.176     0.200
     2.136    33.326     0.200
     2.661    40.236     0.200
     2.391    36.246     0.200
     2.639    40.117     0.200
     2.707    40.896     0.200
     3.033    45.797     0.200
     2.693    41.027     0.200
     3.107    46.197     0.200
     2.707    41.617     0.200
     3.106    46.816     0.200
     4.083    59.756     0.200
     6.051    89.273     0.200
     7.301   108.266     0.200
     7.893   114.967     0.200
     7.893   115.873     0.200
     7.950   114.428     0.200
     8.712   124.887     0.200
    10.784   154.277     0.200
    10.575   157.006     0.200
    11.044   157.289     0.200
    15.083   210.746     0.200
    15.078   210.426     0.200
    15.184   210.688     0.200
    15.137   209.516     0.200
    15.342   214.236     0.200
    15.250   211.926     0.200
    15.257   212.607     0.200
    15.428   215.336     0.200
    15.615   217.557     0.200
    15.581   216.607     0.200
    15.583   217.107     0.200
    15.507   219.740     0.200
    15.628   216.957     0.200
    15.706   218.617     0.200
    15.674   217.438     0.200
    15.655   216.986     0.200
    15.834   219.457     0.200
    15.871   220.146     0.200
    15.954   221.326     0.200
    15.849   220.406     0.200
    16.029   224.447     0.200
    16.012   224.637     0.200
    16.190   225.197     0.200
    16.406   229.256     0.200
    16.423   227.357     0.200
    16.338   225.467     0.200
    16.642   232.367     0.200
    16.599   231.486     0.200
     0.822    13.994     0.200
     0.851    14.016     0.200
     0.863    14.504     0.200
     0.861    14.414     0.200
     0.934    15.875     0.200
     0.945    16.154     0.200
     0.995    16.914     0.200
     0.995    16.904     0.200
     1.075    18.186     0.200
     1.117    18.824     0.200
     1.116    18.189     0.200
     1.225    20.295     0.200
     1.367    22.404     0.200
     1.547    25.805     0.200
     1.940    33.305     0.200
     1.964    33.135     0.200
     2.060    34.635     0.200
     2.272    35.385     0.200
     2.478    37.334     0.200
     4.542    68.615     0.200
     5.314    78.516     0.200
     6.065    89.096     0.200
     7.960   118.814     0.200
    10.773   154.500     0.200
    15.518   217.635     0.200
     0.753    12.674     0.200
     0.824    13.824     0.200
     0.852    14.033     0.200
     0.888    15.033     0.200
     0.864    14.594     0.200
     0.862    14.494     0.200
     0.937    15.273     0.200
     0.947    15.344     0.200
     0.969    15.703     0.200
     1.047    17.164     0.200
     1.102    17.764     0.200
     1.096    18.494     0.200
     1.118    18.385     0.200
     1.118    18.277     0.200
     1.120    18.283     0.200
     1.123    18.555     0.200
     1.157    18.814     0.200
     1.255    19.334     0.200
     1.187    19.715     0.200
     1.170    19.604     0.200
     1.219    19.805     0.200
     1.237    20.135     0.200
     1.225    20.373     0.200
     1.276    20.674     0.200
     1.255    20.523     0.200
     1.265    20.965     0.200
     1.265    20.764     0.200
     1.246    20.814     0.200
     1.317    21.654     0.200
     1.290    20.953     0.200
     1.286    23.844     0.200
     1.325    21.783     0.200
     1.337    21.443     0.200
     1.337    21.514     0.200
     1.358    21.703     0.200
     1.362    21.984     0.200
     1.345    22.023     0.200
     1.333    24.385     0.200
     1.368    22.484     0.200
     1.356    22.305     0.200
     1.429    22.895     0.200
     1.369    22.135     0.200
     1.462    23.244     0.200
     1.439    23.354     0.200
     1.431    23.725     0.200
     1.452    23.283     0.200
     1.440    23.203     0.200
     1.440    23.344     0.200
     1.472    23.623     0.200
     1.486    23.805     0.200
     1.486    23.734     0.200
     1.501    24.373     0.200
     1.502    23.854     0.200
     1.526    24.414     0.200
     1.516    24.154     0.200
     1.549    24.885     0.200
     1.574    25.234     0.200
     1.533    26.135     0.200
     1.572    25.783     0.200
     1.589    25.344     0.200
     1.636    25.924     0.200
     1.648    26.344     0.200
     1.780    28.045     0.200
     1.894    28.314     0.200
     1.943    30.863     0.200
     1.966    30.953     0.200
     2.062    32.805     0.200
     2.146    33.254     0.200
     2.273    35.354     0.200
     2.406    39.225     0.200
     6.067    89.082     0.200
     7.963   117.895     0.200
    10.773   154.357     0.200
    11.053   161.578     0.200
     0.994    15.623     0.200
     1.134    19.243     0.200
     1.164    18.973     0.200
     1.212    19.583     0.200
     1.281    21.013     0.200
     1.320    21.672     0.200
     1.391    21.843     0.200
     1.557    25.493     0.200
     1.499    23.922     0.200
     1.545    25.413     0.200
     1.587    25.257     0.200
     1.729    26.982     0.200
     1.797    28.573     0.200
     1.874    31.413     0.200
     2.021    31.973     0.200
     3.790    56.373     0.200
     5.001    77.833     0.200
     5.275    80.172     0.200
     6.526    95.663     0.200
     7.772   113.057     0.200
     8.347   123.638     0.200
     8.347   122.623     0.200
    10.416   149.788     0.200
    11.307   165.874     0.200
    11.307   162.982     0.200
    15.113   215.292     0.200
    15.366   216.633     0.200
    15.482   218.453     0.200
    15.928   226.481     0.200
    15.928   225.723     0.200
    16.055   225.252     0.200
    16.548   232.133     0.200
    16.548   231.732     0.200
    17.801   247.292     0.200
     0.836    14.367     0.200
     0.843    14.328     0.200
     0.921    15.641     0.200
     0.986    16.359     0.200
     1.035    17.070     0.200
     1.053    17.070     0.200
     1.046    17.797     0.200
     1.194    19.734     0.200
     1.266    20.750     0.200
     1.309    21.055     0.200
     1.308    21.461     0.200
     1.378    21.516     0.200
     1.571    22.828     0.200
     1.482    23.805     0.200
     1.545    26.344     0.200
     1.579    25.367     0.200
     1.579    25.234     0.200
     1.758    28.211     0.200
     1.794    29.000     0.200
     1.892    31.055     0.200
     2.011    31.945     0.200
     2.117    33.727     0.200
     2.257    36.469     0.200
     2.400    38.039     0.200
     2.516    39.789     0.200
     2.524    39.180     0.200
     2.726    43.086     0.200
     2.828    44.906     0.200
     2.926    44.734     0.200
     3.027    46.766     0.200
     3.089    46.758     0.200
     3.738    57.109     0.200
     3.783    55.195     0.200
     3.783    56.914     0.200
     3.783    55.398     0.200
     5.007    73.461     0.200
     5.274    77.844     0.200
     5.274    78.477     0.200
     5.696    87.219     0.200
     5.696    85.625     0.200
     5.872    87.016     0.200
     6.513    94.922     0.200
     6.543    96.078     0.200
     7.760   113.078     0.200
     7.760   112.539     0.200
     7.760   113.820     0.200
     8.163   117.711     0.200
     8.331   120.570     0.200
     8.685   124.836     0.200
     9.342   135.195     0.200
     9.652   141.594     0.200
     9.956   142.695     0.200
    10.372   153.414     0.200
    10.379   153.047     0.200
    10.412   148.719     0.200
    10.413   149.016     0.200
    10.414   149.320     0.200
    10.736   156.078     0.200
    10.859   157.945     0.200
    11.290   163.969     0.200
    11.334   165.266     0.200
    12.738   183.266     0.200
    13.934   197.969     0.200
    15.070   213.047     0.200
    15.078   212.945     0.200
    15.102   213.141     0.200
    15.111   213.828     0.200
    15.190   213.023     0.200
    15.146   213.828     0.200
    15.159   213.336     0.200
    15.271   215.227     0.200
    15.419   217.688     0.200
    15.480   218.117     0.200
    15.682   220.227     0.200
    15.734   221.758     0.200
    15.735   221.797     0.200
    15.864   222.594     0.200
    15.913   226.562     0.200
    15.908   223.805     0.200
    16.023   223.984     0.200
    16.239   226.727     0.200
    16.232   227.680     0.200
    16.462   230.820     0.200
     0.983    15.984     0.200
     1.039    17.617     0.200
     1.090    21.000     0.200
     1.202    19.852     0.200
     1.270    20.586     0.200
     1.305    20.945     0.200
     1.293    23.273     0.200
     1.320    21.391     0.200
     1.398    24.750     0.200
     1.569    22.695     0.200
     1.537    26.227     0.200
     1.576    24.852     0.200
     1.576    25.117     0.200
     1.718    28.195     0.200
     1.787    29.227     0.200
     2.009    32.516     0.200
     2.253    36.602     0.200
     2.401    38.656     0.200
     2.516    40.891     0.200
     2.721    43.414     0.200
     2.831    44.633     0.200
     3.021    47.922     0.200
     3.405    53.203     0.200
     3.501    54.977     0.200
     3.737    57.023     0.200
     3.794    55.695     0.200
     5.012    74.961     0.200
     7.772   113.594     0.200
     8.336   121.102     0.200
    10.423   149.656     0.200
    15.917   225.914     0.200
    15.917   223.305     0.200
    15.918   220.930     0.200
    15.920   222.117     0.200
    15.981   221.867     0.200
    16.025   223.703     0.200
    16.847   234.227     0.200
    17.072   239.031     0.200
     0.985    16.391     0.200
     1.040    17.781     0.200
     1.206    20.211     0.200
     1.566    22.812     0.200
     1.323    21.812     0.200
     1.273    20.719     0.200
     1.306    21.023     0.200
     1.382    21.523     0.200
     1.515    26.180     0.200
     1.495    24.062     0.200
     1.537    25.188     0.200
     1.578    24.992     0.200
     1.675    28.047     0.200
     1.744    26.922     0.200
     1.788    28.406     0.200
     2.012    31.422     0.200
     2.130    35.008     0.200
     2.206    35.242     0.200
     2.255    36.359     0.200
     2.404    39.227     0.200
     2.519    40.797     0.200
     2.723    42.398     0.200
     2.834    45.008     0.200
     3.022    47.922     0.200
     3.735    56.094     0.200
     3.795    56.211     0.200
     5.010    73.758     0.200
     5.283    77.219     0.200
     5.694    84.023     0.200
     5.874    86.742     0.200
     6.517    94.602     0.200
     7.775   113.789     0.200
     7.775   113.891     0.200
     8.340   120.422     0.200
     9.664   142.367     0.200
    10.424   149.797     0.200
    10.751   156.273     0.200
    11.303   165.148     0.200
    13.698   198.094     0.200
    13.948   200.594     0.200
    14.924   210.477     0.200
    15.091   212.047     0.200
    15.125   211.422     0.200
    15.158   212.688     0.200
    15.074   210.578     0.200
    15.173   213.781     0.200
    15.195   213.703     0.200
    15.455   217.148     0.200
    15.544   219.523     0.200
    15.697   219.852     0.200
    15.647   221.672     0.200
    15.749   221.109     0.200
    15.772   222.172     0.200
    15.809   222.094     0.200
    15.920   226.547     0.200
    16.028   225.383     0.200
    16.168   226.922     0.200
    16.246   227.820     0.200
    16.357   229.680     0.200
    16.550   231.938     0.200
    16.812   234.969     0.200
    17.718   245.922     0.200
    18.047   249.867     0.200
    18.224   251.961     0.200
    15.285   214.578     0.200
     0.914    15.339     0.200
     0.985    15.979     0.200
     1.047    16.859     0.200
     1.050    17.409     0.200
     1.159    18.859     0.200
     1.181    19.789     0.200
     1.257    20.039     0.200
     1.311    20.959     0.200
     1.294    21.139     0.200
     1.578    22.809     0.200
     1.467    23.449     0.200
     1.551    25.409     0.200
     1.579    24.729     0.200
     1.579    24.833     0.200
     1.711    27.349     0.200
     1.746    27.619     0.200
     1.798    28.559     0.200
     1.906    31.839     0.200
     2.010    31.529     0.200
     3.771    55.309     0.200
     5.005    77.029     0.200
     6.508    95.639     0.200
     7.103   103.689     0.200
     7.745   114.119     0.200
     8.320   121.439     0.200
     8.708   126.039     0.200
     8.894   124.869     0.200
     9.555   138.770     0.200
     9.873   142.129     0.200
    10.120   142.589     0.200
    10.405   148.398     0.200
    10.563   152.079     0.200
    11.276   162.239     0.200
    14.568   205.699     0.200
    15.667   219.459     0.200
    15.781   221.299     0.200
    15.903   224.833     0.200
    15.903   223.779     0.200
    15.638   220.419     0.200
     0.794    13.770     0.200
     0.809    13.961     0.200
     0.858    14.859     0.200
     0.865    14.830     0.200
     0.890    15.340     0.200
     1.014    16.699     0.200
     1.067    17.510     0.200
     1.196    20.391     0.200
     1.229    21.461     0.200
     1.280    21.160     0.200
     1.281    20.779     0.200
     1.266    21.471     0.200
     1.341    21.359     0.200
     1.400    21.891     0.200
     1.354    23.439     0.200
     1.552    22.580     0.200
     1.579    25.289     0.200
     1.608    25.029     0.200
     1.608    25.145     0.200
     1.704    26.240     0.200
     1.706    26.340     0.200
     1.738    27.189     0.200
     1.767    27.820     0.200
     1.827    28.850     0.200
     1.892    31.529     0.200
     2.039    31.920     0.200
     2.112    32.900     0.200
     2.249    35.180     0.200
     2.244    34.930     0.200
     2.287    35.699     0.200
     2.426    37.471     0.200
     2.757    42.230     0.200
     3.612    54.711     0.200
     3.678    57.381     0.200
     3.750    55.840     0.200
     4.891    73.000     0.200
     4.975    76.279     0.200
     5.147    75.490     0.200
     5.184    77.510     0.200
     5.240    77.850     0.200
     5.240    78.480     0.200
     5.371    80.109     0.200
     5.843    87.910     0.200
     6.508    96.039     0.200
     6.535    95.176     0.200
     7.088   103.240     0.200
     7.733   113.900     0.200
     8.132   119.381     0.200
     8.375   120.160     0.200
    10.096   145.109     0.200
    10.378   149.180     0.200
    10.379   149.486     0.200
    10.379   149.990     0.200
    11.287   165.449     0.200
    13.428   190.189     0.200
    14.590   205.570     0.200
    14.623   206.410     0.200
    15.501   217.150     0.200
    15.766   220.250     0.200
    15.925   223.061     0.200
     0.720    12.223     0.200
     0.720    12.410     0.200
     0.730    12.691     0.200
     0.748    12.590     0.200
     0.776    13.180     0.200
     0.817    14.000     0.200
     1.017    16.191     0.200
     1.180    19.852     0.200
     1.258    20.441     0.200
     1.272    20.613     0.200
     1.348    21.023     0.200
     1.559    22.852     0.200
     1.397    21.953     0.200
     1.460    23.160     0.200
     1.592    25.453     0.200
     1.612    24.863     0.200
     1.612    25.145     0.200
     1.693    26.062     0.200
     1.698    26.152     0.200
     1.735    26.902     0.200
     1.754    27.352     0.200
     1.836    28.703     0.200
     1.909    31.613     0.200
     2.066    31.652     0.200
     2.040    31.242     0.200
     2.093    31.562     0.200
     2.238    34.352     0.200
     2.253    34.301     0.200
     2.292    34.801     0.200
     2.410    37.160     0.200
     2.415    36.523     0.200
     2.763    41.992     0.200
     2.840    42.113     0.200
     2.905    43.773     0.200
     3.092    46.371     0.200
     3.142    47.090     0.200
     3.170    47.703     0.200
     3.192    48.070     0.200
     3.686    54.102     0.200
     3.727    56.062     0.200
     3.731    54.641     0.200
     3.731    55.453     0.200
     3.731    53.922     0.200
     3.719    60.133     0.200
     4.010    58.273     0.200
     4.053    60.953     0.200
     4.087    61.730     0.200
     4.096    61.660     0.200
     4.245    62.492     0.200
     4.275    64.742     0.200
     4.395    64.910     0.200
     4.622    68.430     0.200
     4.713    70.160     0.200
     4.839    69.820     0.200
     4.873    72.922     0.200
     4.845    72.223     0.200
     4.969    77.930     0.200
     5.003    74.930     0.200
     4.997    74.691     0.200
     5.084    75.371     0.200
     5.130    74.793     0.200
     5.165    77.320     0.200
     5.169    76.930     0.200
     5.226    78.793     0.200
     5.229    78.352     0.200
     5.253    77.902     0.200
     5.354    79.891     0.200
     5.398    78.883     0.200
     5.673    85.793     0.200
     5.672    83.730     0.200
     5.839    86.891     0.200
     6.027    89.230     0.200
     6.217    90.840     0.200
     6.261    90.781     0.200
     6.531    95.027     0.200
     6.618    97.180     0.200
     6.897   100.910     0.200
     7.066   102.430     0.200
     7.258   104.852     0.200
     7.302   108.371     0.200
     7.696   112.543     0.200
     7.711   113.750     0.200
     8.013   119.410     0.200
     8.330   120.227     0.200
     8.357   119.242     0.200
     9.636   141.262     0.200
     9.832   141.531     0.200
    10.221   146.492     0.200
    10.362   149.152     0.200
    10.363   147.801     0.200
    10.363   150.652     0.200
    10.364   149.000     0.200
    10.698   156.102     0.200
    11.269   162.750     0.200
    13.883   195.363     0.200
    13.984   194.863     0.200
    14.017   194.000     0.200
    14.094   195.332     0.200
    14.311   200.672     0.200
    14.365   202.082     0.200
    14.434   202.660     0.200
    14.603   208.543     0.200
    15.915   224.121     0.200
    16.938   234.492     0.200
    17.008   234.883     0.200
    17.387   240.691     0.200
    18.037   247.711     0.200
    18.072   247.422     0.200
    18.072   247.562     0.200
    15.603   218.500     0.200
     0.811    14.004     0.200
     0.841    14.570     0.200
     0.896    14.953     0.200
     0.896    14.844     0.200
     0.926    15.402     0.200
     0.985    17.973     0.200
     1.006    16.762     0.200
     1.074    19.352     0.200
     1.091    19.273     0.200
     1.190    22.633     0.200
     1.146    20.320     0.200
     1.244    21.711     0.200
     1.256    22.504     0.200
     1.511    21.652     0.200
     1.335    22.891     0.200
     1.329    21.883     0.200
     1.360    21.660     0.200
     1.379    24.633     0.200
     1.419    24.812     0.200
     1.456    23.211     0.200
     1.482    25.383     0.200
     1.573    26.980     0.200
     1.591    25.082     0.200
     2.264    37.242     0.200
     2.466    40.902     0.200
     2.508    41.273     0.200
     2.560    41.410     0.200
     2.601    40.363     0.200
     2.903    44.891     0.200
     3.905    56.691     0.200
    15.132   213.379     0.200
    15.204   212.355     0.200
    15.446   214.910     0.200
    15.459   216.762     0.200
    15.830   221.145     0.200
    15.940   221.730     0.200
    16.007   225.410     0.200
    16.095   225.285     0.200
    16.526   231.363     0.200
    16.915   234.160     0.200
    17.433   241.949     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.179    60.459     0.200
     3.275    62.090     0.200
     3.793    73.249     0.200
     4.217    81.159     0.200
     5.385    99.669     0.200
     6.612   124.449     0.200
     6.713   127.629     0.200
     7.167   134.199     0.200
     7.642   144.489     0.200
     7.738   144.060     0.200
     8.030   153.959     0.200
     8.041   153.319     0.200
     8.343   159.659     0.200
     3.288    62.746     0.200
     4.220    79.406     0.200
     5.907   114.160     0.200
     8.342   159.961     0.200
     5.520   102.477     0.200
     3.723    71.086     0.200
     4.674    87.359     0.200
     5.020    91.984     0.200
     6.350   119.719     0.200
     2.835    53.805     0.200
     3.179    60.211     0.200
     4.008    76.203     0.200
     4.604    86.375     0.200
     5.121    94.188     0.200
     5.256    96.500     0.200
     7.678   145.273     0.200
     2.625    51.002     0.200
     3.834    70.803     0.200
     4.479    85.271     0.200
     5.824   112.283     0.200
     6.444   120.430     0.200
     6.566   125.082     0.200
     7.599   140.963     0.200
     7.699   145.021     0.200
     7.904   146.963     0.200
     7.931   148.363     0.200
     7.986   150.793     0.200
     8.111   157.963     0.200
     8.277   155.613     0.200
     8.578   163.143     0.200
     8.590   161.002     0.200
     9.132   174.373     0.200
     9.528   181.543     0.200
     9.616   181.152     0.200
    10.732   201.062     0.200
    11.115   208.941     0.200
     2.619    51.781     0.200
     2.939    56.055     0.200
     3.090    60.141     0.200
     3.558    67.711     0.200
     3.618    70.211     0.200
     4.126    79.352     0.200
     4.482    84.695     0.200
     5.813   112.125     0.200
     6.932   131.828     0.200
     7.347   138.172     0.200
     6.433   123.680     0.200
     7.796   146.078     0.200
     8.270   157.906     0.200
     2.629    49.322     0.200
     2.901    53.523     0.200
     2.956    53.812     0.200
     3.575    65.223     0.200
     3.834    72.283     0.200
     4.143    77.723     0.200
     4.481    85.582     0.200
     8.281   155.969     0.200
     2.622    49.445     0.200
     2.881    53.164     0.200
     3.091    58.531     0.200
     3.613    70.398     0.200
     3.853    72.281     0.200
     4.489    84.055     0.200
     5.334    98.781     0.200
     5.542   104.766     0.200
     5.815   108.781     0.200
     6.569   125.352     0.200
     6.931   130.992     0.200
     7.353   139.781     0.200
     7.483   143.039     0.200
     7.602   144.539     0.200
     7.704   146.844     0.200
     7.933   150.484     0.200
     8.273   157.539     0.200
     8.579   162.266     0.200
     8.653   164.250     0.200
     2.627    48.384     0.200
     4.549    84.534     0.200
     5.340   100.764     0.200
     5.547   103.904     0.200
     6.574   123.964     0.200
     6.621   126.185     0.200
     6.932   129.995     0.200
     7.127   135.254     0.200
     7.489   139.834     0.200
     7.608   142.054     0.200
     7.711   143.915     0.200
     7.810   146.764     0.200
     7.919   148.174     0.200
     7.922   147.725     0.200
     7.944   146.574     0.200
     7.992   148.294     0.200
     8.107   152.534     0.200
     8.120   151.044     0.200
     8.278   156.830     0.200
     8.326   157.453     0.200
     2.679    53.117     0.200
     3.253    60.055     0.200
    11.290   214.359     0.200
     2.856    55.849     0.200
     3.027    56.499     0.200
     3.305    64.129     0.200
     4.307    78.459     0.200
     4.659    88.509     0.200
     5.560   106.099     0.200
     6.649   123.034     0.200
     6.788   128.608     0.200
     8.507   160.134     0.200
     3.658    67.422     0.200
     4.128    78.281     0.200
     4.232    77.094     0.200
     4.507    82.391     0.200
     5.610   105.508     0.200
     6.627   123.008     0.200
     7.005   130.312     0.200
     7.038   129.539     0.200
     7.367   140.023     0.200
     7.656   144.031     0.200
     7.820   150.945     0.200
     7.939   146.328     0.200
     7.941   146.211     0.200
     7.997   150.758     0.200
     8.057   152.953     0.200
     2.734    51.246     0.200
     3.002    55.056     0.200
     3.055    56.306     0.200
     3.221    59.416     0.200
     3.791    70.046     0.200
     4.254    77.586     0.200
     4.526    83.626     0.200
     5.427   101.256     0.200
     5.637   105.785     0.200
     5.690   107.785     0.200
     6.521   123.775     0.200
     6.634   123.785     0.200
     6.653   122.445     0.200
     7.788   144.086     0.200
     8.201   153.325     0.200
     8.228   154.285     0.200
     8.388   158.315     0.200
     8.797   161.716     0.200
     3.306    60.859     0.200
     3.182    59.758     0.200
     4.123    77.906     0.200
     7.795   144.469     0.200
     3.922    71.508     0.200
     3.844    73.424     0.200
     5.162    95.125     0.200
     5.647   106.613     0.200
     6.500   120.904     0.200
     3.216    60.701     0.200
     3.678    69.611     0.200
     3.730    68.342     0.200
     4.281    80.811     0.200
     5.343   100.051     0.200
     5.555   103.730     0.200
     7.081   134.221     0.200
     7.844   143.922     0.200
     7.849   144.070     0.200
     6.925   133.359     0.200
     6.969   133.719     0.200
     7.697   147.477     0.200
    11.198   216.297     0.200
    11.281   215.727     0.200
     5.984   114.871     0.200
     5.985   115.029     0.200
     6.601   122.592     0.200
     7.738   145.738     0.200
     8.139   155.648     0.200
     2.994    55.203     0.200
     3.208    60.523     0.200
     4.363    84.652     0.200
     4.228    81.547     0.200
     3.090    58.406     0.200
     4.715    89.570     0.200
     3.132    57.086     0.200
     3.460    64.636     0.200
     3.622    65.876     0.200
     2.789    52.007     0.200
     4.206    81.107     0.200
     4.205    77.367     0.200
     5.718   108.187     0.200
     5.951   114.477     0.200
     3.800    69.241     0.200
     2.885    55.009     0.200
     3.770    71.219     0.200
     4.823    92.729     0.200
     5.567   107.259     0.200
     5.778   105.859     0.200
     6.096   117.319     0.200
     6.154   115.049     0.200
     2.548    48.284     0.200
     3.946    74.344     0.200
     4.378    82.984     0.200
     5.331   102.314     0.200
     5.530   102.564     0.200
     5.613   105.614     0.200
     5.758   109.444     0.200
     6.630   121.824     0.200
     6.631   124.364     0.200
     7.538   141.554     0.200
     8.159   152.194     0.200
     3.945    73.006     0.200
     4.021    74.496     0.200
     5.579   107.156     0.200
     5.843   111.687     0.200
     6.753   126.106     0.200
     8.014   153.466     0.200
     8.058   149.477     0.200
     2.805    51.198     0.200
     3.909    74.028     0.200
     4.662    88.049     0.200
     5.303    98.719     0.200
     5.500   103.589     0.200
     5.717   107.499     0.200
     7.533   142.738     0.200
     2.663    50.726     0.200
     3.041    55.936     0.200
     4.026    74.556     0.200
     4.074    77.425     0.200
     4.538    85.565     0.200
     5.413   101.795     0.200
     5.788   110.115     0.200
     5.900   110.266     0.200
     7.703   143.315     0.200
     3.041    59.928     0.200
     3.565    69.568     0.200
     4.591    86.459     0.200
     5.688   107.408     0.200
     5.902   111.018     0.200
     6.318   121.299     0.200
     7.773   145.738     0.200
     7.907   151.418     0.200
     7.982   148.939     0.200
     8.276   157.979     0.200
     8.353   156.289     0.200
     8.699   166.588     0.200
     3.155    58.852     0.200
     6.578   124.432     0.200
     5.697   107.977     0.200
     5.965   114.605     0.200
     6.577   121.615     0.200
     7.035   131.906     0.200
     7.871   148.291     0.200
     8.431   162.566     0.200
    11.412   216.646     0.200
     6.093   115.875     0.200
     6.159   117.375     0.200
     6.708   126.074     0.200
     7.855   147.949     0.200
     2.929    57.167     0.200
     6.143   119.257     0.200
     6.199   117.937     0.200
     6.762   127.751     0.200
     8.585   161.197     0.200
     3.956    73.357     0.200
     4.556    85.627     0.200
     5.663   106.808     0.200
     6.247   119.137     0.200
     6.288   116.907     0.200
     6.851   125.478     0.200
     4.252    80.006     0.200
     5.698   107.406     0.200
     5.971   115.146     0.200
     6.584   125.461     0.200
     7.464   140.026     0.200
     7.847   145.736     0.200
     2.536    46.329     0.200
     3.934    75.489     0.200
     6.183   112.829     0.200
     6.125   112.250     0.200
     8.096   151.562     0.200
     3.335    62.465     0.200
     6.066   116.285     0.200
     6.679   124.207     0.200
     6.881   131.449     0.200
     3.805    71.055     0.200
     3.920    75.070     0.200
     4.638    87.852     0.200
     3.629    70.332     0.200
     6.962   133.542     0.200
     7.761   146.741     0.200
     8.746   166.142     0.200
     5.137    94.314     0.200
     7.794   149.695     0.200
     8.051   153.076     0.200
     8.167   154.750     0.200
     6.133   114.297     0.200
     6.770   127.914     0.200
     6.679   127.900     0.200
     6.679   127.895     0.200
     3.746    68.709     0.200
     3.913    71.179     0.200
     4.220    77.529     0.200
     4.622    87.599     0.200
     5.260    96.369     0.200
     5.457   103.869     0.200
     5.578   102.699     0.200
     5.678   106.479     0.200
     6.118   112.484     0.200
     6.507   122.779     0.200
     6.555   120.949     0.200
     7.493   141.639     0.200
     7.580   142.499     0.200
     7.845   149.429     0.200
     7.885   149.129     0.200
     8.017   149.819     0.200
     8.535   163.069     0.200
     2.835    51.500     0.200
     2.836    51.770     0.200
     2.861    54.531     0.200
     3.002    55.141     0.200
     3.331    61.828     0.200
     3.814    70.078     0.200
     4.214    77.770     0.200
     6.060   115.629     0.200
     6.127   117.488     0.200
     5.800   108.895     0.200
     6.685   124.430     0.200
     8.537   160.229     0.200
     6.066   112.641     0.200
     6.594   121.312     0.200
     7.900   150.703     0.200
     2.879    53.695     0.200
     3.796    72.398     0.200
     4.302    81.398     0.200
     4.370    80.625     0.200
     4.507    84.484     0.200
     7.815   144.477     0.200
     8.534   162.211     0.200
     8.534   161.578     0.200
     8.092   150.711     0.200
     2.782    55.340     0.200
     2.985    56.219     0.200
     3.036    57.000     0.200
     3.851    73.188     0.200
     6.543   123.840     0.200
     6.761   126.469     0.200
     6.761   126.469     0.200
     8.216   157.672     0.200
     8.282   158.422     0.200
     8.595   163.484     0.200
     3.307    60.785     0.200
     2.946    55.730     0.200
     3.439    65.711     0.200
     3.746    71.461     0.200
     4.369    83.770     0.200
     4.645    87.891     0.200
     5.447   103.652     0.200
     5.619   106.723     0.200
     3.867    73.441     0.200
     4.407    84.031     0.200
     6.068   115.793     0.200
     6.602   124.281     0.200
     2.963    54.497     0.200
     3.230    58.637     0.200
     3.279    60.247     0.200
     3.700    69.197     0.200
     4.387    81.047     0.200
     4.500    82.787     0.200
     4.628    86.187     0.200
     6.193   118.486     0.200
     6.816   126.517     0.200
     7.084   133.957     0.200
     7.474   138.227     0.200
     7.854   146.307     0.200
     2.665    50.497     0.200
     3.866    72.518     0.200
     3.876    70.787     0.200
     4.670    88.007     0.200
     5.470   100.587     0.200
     5.668   106.707     0.200
     6.527   121.598     0.200
     8.058   151.228     0.200
     6.316   116.535     0.200
     2.781    52.281     0.200
     3.743    71.371     0.200
     3.885    74.512     0.200
     3.917    74.051     0.200
     4.243    80.160     0.200
     5.282    99.129     0.200
     6.558   124.582     0.200
     7.521   144.160     0.200
     8.044   152.789     0.200
     6.123   111.941     0.200
     8.096   153.340     0.200
     2.779    53.211     0.200
     2.987    56.258     0.200
     3.038    56.570     0.200
     3.239    60.688     0.200
     3.847    73.141     0.200
     4.200    78.859     0.200
     4.254    80.008     0.200
     4.390    83.160     0.200
     4.595    87.367     0.200
     5.692   108.348     0.200
     6.583   124.289     0.200
     6.694   126.789     0.200
     6.094   111.176     0.200
     8.078   153.488     0.200
     8.127   155.438     0.200
     3.182    58.645     0.200
     3.953    73.765     0.200
     4.185    79.274     0.200
     4.328    79.225     0.200
     5.924   113.805     0.200
     6.019   115.915     0.200
     6.527   123.918     0.200
     4.441    85.520     0.200
     8.052   151.699     0.200
     3.043    59.613     0.200
     4.007    74.242     0.200
     4.468    85.773     0.200
     4.605    85.340     0.200
     6.288   120.211     0.200
     6.048   110.518     0.200
     8.046   152.617     0.200
     5.681   105.602     0.200
     3.739    68.633     0.200
     2.634    48.006     0.200
     3.910    71.186     0.200
     4.666    85.495     0.200
     4.722    91.226     0.200
     6.118   111.814     0.200
     6.549   122.155     0.200
     8.097   151.945     0.200
     3.863    70.525     0.200
     5.661   105.154     0.200
     6.500   120.234     0.200
     2.888    56.367     0.200
     3.359    63.547     0.200
     3.806    72.057     0.200
     4.310    81.047     0.200
     4.370    80.287     0.200
     6.154   117.178     0.200
     6.781   128.047     0.200
     3.361    62.238     0.200
     6.155   117.469     0.200
     3.834    70.057     0.200
     4.066    74.167     0.200
     2.705    49.076     0.200
     3.865    71.705     0.200
     5.658   105.195     0.200
     3.938    75.191     0.200
     3.977    74.293     0.200
     3.983    72.684     0.200
     4.207    80.391     0.200
     4.297    79.777     0.200
     4.661    89.473     0.200
     7.917   151.121     0.200
     7.952   148.754     0.200
     7.955   150.863     0.200
     8.042   149.312     0.200
     2.594    48.027     0.200
     3.689    67.547     0.200
     4.358    82.656     0.200
     4.662    86.527     0.200
     3.889    74.693     0.200
     3.906    73.803     0.200
     5.536   104.643     0.200
     3.835    75.031     0.200
     3.442    63.984     0.200
     4.375    83.523     0.200
     6.167   118.844     0.200
     6.223   118.715     0.200
     6.785   128.086     0.200
     2.719    49.652     0.200
     5.662   106.621     0.200
     7.902   150.699     0.200
     3.665    70.412     0.200
     5.654   107.533     0.200
     6.842   129.703     0.200
     6.860   129.623     0.200
     7.953   152.021     0.200
     4.180    80.375     0.200
     4.583    87.285     0.200
     5.465   103.746     0.200
     6.384   121.816     0.200
     3.848    73.410     0.200
     4.279    82.740     0.200
     4.463    85.549     0.200
     5.558   104.840     0.200
     6.046   117.729     0.200
     6.120   117.330     0.200
     6.657   125.189     0.200
     6.766   129.479     0.200
     6.785   131.160     0.200
     7.908   146.570     0.200
     8.086   153.650     0.200
     8.090   152.660     0.200
     8.929   170.059     0.200
     6.064   111.075     0.200
     8.073   152.700     0.200
     2.748    52.594     0.200
     3.836    70.055     0.200
     3.868    71.854     0.200
     4.374    80.385     0.200
     4.728    89.354     0.200
     5.297    98.664     0.200
     5.661   106.305     0.200
     6.048   110.789     0.200
     6.468   118.854     0.200
     7.598   146.914     0.200
     7.633   144.785     0.200
     8.066   151.414     0.200
     6.040   110.244     0.200
     8.059   152.318     0.200
     2.708    50.654     0.200
     3.870    70.525     0.200
     3.885    74.516     0.200
     5.683   106.846     0.200
     6.081   111.311     0.200
     6.504   121.424     0.200
     7.920   149.346     0.200
     8.075   152.516     0.200
     8.087   152.734     0.200
     6.455   118.504     0.200
     2.603    49.840     0.200
     2.812    51.359     0.200
     3.917    75.238     0.200
     4.238    79.398     0.200
     5.574   104.568     0.200
     5.725   107.639     0.200
     6.586   123.840     0.200
     6.587   123.539     0.200
     8.044   148.828     0.200
     8.065   155.068     0.200
     4.432    84.367     0.200
     5.713   105.957     0.200
     6.066   114.918     0.200
     7.200   136.008     0.200
     3.057    55.670     0.200
     3.964    73.199     0.200
     8.187   155.029     0.200
     2.959    58.410     0.200
     4.643    88.461     0.200
     6.158   117.695     0.200
     2.827    54.139     0.200
     3.280    60.279     0.200
     4.247    78.689     0.200
     4.288    78.469     0.200
     4.430    83.629     0.200
     5.531   103.049     0.200
     6.088   113.559     0.200
     2.873    55.400     0.200
     3.820    71.400     0.200
     4.294    81.851     0.200
     4.490    83.911     0.200
     5.566   102.631     0.200
     5.801   109.541     0.200
     6.138   117.251     0.200
     7.817   145.061     0.200
     3.372    61.367     0.200
     3.655    66.875     0.200
     3.702    71.125     0.200
     4.085    76.773     0.200
     5.488   102.562     0.200
     5.867   107.211     0.200
     5.939   115.227     0.200
     7.621   142.664     0.200
     7.753   148.992     0.200
     7.848   149.922     0.200
     7.894   145.914     0.200
     7.894   147.914     0.200
     8.198   154.242     0.200
     8.393   159.945     0.200
     2.603    47.732     0.200
     7.713   146.492     0.200
     2.642    52.256     0.200
     2.773    50.506     0.200
     3.487    63.906     0.200
     3.626    66.197     0.200
     3.890    74.637     0.200
     5.695   106.617     0.200
     6.654   124.135     0.200
     2.558    49.125     0.200
     2.716    52.555     0.200
     5.208    94.812     0.200
     5.738   108.219     0.200
     5.777   112.305     0.200
     6.091   115.078     0.200
     6.151   114.969     0.200
     6.544   120.727     0.200
     7.804   150.273     0.200
     7.979   154.156     0.200
     8.041   148.656     0.200
     8.074   152.203     0.200
     6.755   128.305     0.200
     5.969   110.744     0.200
     2.505    47.971     0.200
     3.258    60.172     0.200
     3.304    60.904     0.200
     3.952    72.795     0.200
     4.341    81.756     0.200
     4.623    89.541     0.200
     5.567   104.971     0.200
     6.606   122.961     0.200
     3.761    70.347     0.200
     4.603    86.027     0.200
     4.668    87.217     0.200
     6.236   118.647     0.200
     3.430    64.789     0.200
     4.444    83.633     0.200
     4.582    86.422     0.200
     4.655    87.523     0.200
     4.883    93.242     0.200
     5.115    99.156     0.200
     6.214   115.672     0.200
     6.773   129.492     0.200
     6.915   129.383     0.200
     3.292    61.656     0.200
     3.939    73.777     0.200
     4.329    82.543     0.200
     4.623    88.023     0.200
     4.826    93.160     0.200
     4.987    94.383     0.200
     5.562   107.523     0.200
     5.707   107.125     0.200
     5.707   107.684     0.200
     6.116   116.441     0.200
     6.127   114.441     0.200
     6.154   115.441     0.200
     7.933   151.551     0.200
     8.108   153.223     0.200
     6.927   133.789     0.200
     6.928   132.047     0.200
     4.485    82.891     0.200
     6.700   127.789     0.200
     6.135   116.648     0.200
     7.027   131.117     0.200
     7.078   136.578     0.200
     7.374   142.578     0.200
     7.676   144.359     0.200
     3.336    61.755     0.200
     3.830    69.885     0.200
     5.779   112.775     0.200
     6.138   114.725     0.200
     6.638   127.375     0.200
     6.680   128.975     0.200
     7.137   136.785     0.200
     7.155   137.854     0.200
     7.498   137.584     0.200
     7.757   147.005     0.200
     3.245    59.156     0.200
     4.275    83.636     0.200
     4.475    81.966     0.200
     4.613    85.746     0.200
     4.912    93.656     0.200
     5.642   107.186     0.200
     5.835   110.216     0.200
     6.241   118.086     0.200
     4.356    81.258     0.200
     4.501    82.125     0.200
     6.257   120.539     0.200
     6.654   129.117     0.200
     6.696   128.992     0.200
     7.168   137.805     0.200
     7.772   146.297     0.200
     2.876    52.680     0.200
     3.536    66.309     0.200
     6.179   114.668     0.200
     6.634   124.559     0.200
     6.669   125.660     0.200
     6.669   124.762     0.200
     6.913   130.117     0.200
     7.873   147.824     0.200
     8.038   151.033     0.200
     3.024    57.025     0.200
     4.221    80.494     0.200
     6.245   121.055     0.200
     3.337    63.578     0.200
     4.347    81.938     0.200
     4.799    92.258     0.200
     6.136   117.477     0.200
     6.357   120.957     0.200
     4.227    77.734     0.200
     4.451    83.742     0.200
     7.043   131.445     0.200
     3.328    61.258     0.200
     3.691    68.106     0.200
     3.849    73.206     0.200
     4.482    84.406     0.200
     4.665    88.347     0.200
     5.551   105.496     0.200
     7.887   147.956     0.200
     2.875    56.875     0.200
     3.071    56.164     0.200
     3.120    57.174     0.200
     3.340    65.365     0.200
     4.138    76.084     0.200
     4.348    83.484     0.200
     4.490    87.125     0.200
     4.803    91.744     0.200
     5.681   106.654     0.200
     6.140   116.865     0.200
     6.429   125.885     0.200
     7.913   149.705     0.200
     5.412   105.754     0.200
     6.635   126.584     0.200
     6.677   126.934     0.200
     7.135   136.703     0.200
     7.199   135.504     0.200
     7.748   149.594     0.200
     8.001   150.293     0.200
     4.370    80.867     0.200
     4.883    94.727     0.200
     5.738   109.367     0.200
     5.829   112.465     0.200
     8.119   151.016     0.200
     3.455    63.287     0.200
     5.909   108.828     0.200
     5.909   107.896     0.200
     6.313   116.219     0.200
     6.460   118.947     0.200
     6.686   122.787     0.200
     6.895   129.787     0.200
     7.873   148.068     0.200
     8.340   154.957     0.200
     2.951    57.563     0.200
     3.436    66.383     0.200
     3.766    68.463     0.200
     4.587    86.243     0.200
     4.662    86.813     0.200
     4.890    93.083     0.200
     5.628   105.283     0.200
     6.737   126.933     0.200
     6.779   130.743     0.200
     7.029   131.583     0.200
     7.239   135.823     0.200
     6.680   127.283     0.200
     3.034    56.190     0.200
     3.654    66.860     0.200
     2.763    51.383     0.200
     2.903    54.344     0.200
     3.624    68.578     0.200
     3.714    68.898     0.200
     5.969   113.812     0.200
     2.597    47.518     0.200
     3.177    58.778     0.200
     3.209    60.598     0.200
     3.601    65.678     0.200
     3.660    67.978     0.200
     3.805    71.838     0.200
     3.919    73.228     0.200
     4.012    74.258     0.200
     4.591    85.498     0.200
     6.554   124.277     0.200
     8.378   155.297     0.200
     6.567   121.844     0.200
     6.546   121.242     0.200
     7.745   145.301     0.200
     8.356   158.281     0.200
     7.937   147.879     0.200
     6.152   114.359     0.200
     8.046   151.336     0.200
     4.262    79.967     0.200
     6.241   114.178     0.200
     6.051   111.627     0.200
     7.893   148.371     0.200
     7.950   146.244     0.200
     6.065   110.752     0.200
     7.888   149.953     0.200
     7.960   149.936     0.200
     7.890   148.781     0.200
     7.963   149.246     0.200
     6.526   119.087     0.200
     7.772   145.356     0.200
     8.347   158.062     0.200
     6.513   119.445     0.200
     7.760   143.461     0.200
     8.331   155.219     0.200
     7.772   145.844     0.200
     8.336   154.945     0.200
     7.775   147.195     0.200
     8.340   155.172     0.200
     6.508   122.589     0.200
     8.320   156.364     0.200
     8.341   156.926     0.200
     8.330   154.727     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.103     1.959     0.200
     0.073     2.060     0.200
     0.340     7.039     0.200
     0.425     8.119     0.200
     0.469     8.379     0.200
     0.605    10.789     0.200
     0.614    11.010     0.200
     0.720    13.329     0.200
     0.760    13.060     0.200
     0.733    13.949     0.200
     0.733    14.270     0.200
     1.186    21.579     0.200
     0.467     8.426     0.200
     0.609    10.906     0.200
     0.713    13.156     0.200
     0.716    13.227     0.200
     0.750    13.676     0.200
     0.776    13.547     0.200
     1.275    23.496     0.200
     1.328    23.496     0.200
     5.654   100.125     0.200
     0.403     7.701     0.200
     0.501     9.080     0.200
     0.517     9.820     0.200
     0.570    10.590     0.200
     0.630    11.490     0.200
     0.649    11.600     0.200
     0.740    12.779     0.200
     0.758    13.971     0.200
     0.793    14.381     0.200
     0.806    14.041     0.200
     1.225    22.311     0.200
     1.324    23.760     0.200
     1.330    24.150     0.200
     1.354    24.010     0.200
     1.379    24.961     0.200
     0.477     8.645     0.200
     0.625    11.133     0.200
     0.734    13.465     0.200
     0.740    12.574     0.200
     1.205    21.234     0.200
     1.312    24.504     0.200
     1.367    24.504     0.200
     7.023   125.074     0.200
     0.052     1.672     0.200
     0.086     2.250     0.200
     0.111     2.059     0.200
     0.212     3.387     0.200
     0.274     5.168     0.200
     0.316     5.957     0.200
     0.333     5.789     0.200
     0.378     6.652     0.200
     0.527     9.477     0.200
     0.639    11.949     0.200
     0.681    12.820     0.200
     0.759    13.988     0.200
     0.798    14.289     0.200
     0.914    16.012     0.200
     0.954    17.527     0.200
     0.973    17.660     0.200
     1.102    20.188     0.200
     1.126    20.387     0.200
     2.686    48.359     0.200
     3.805    68.609     0.200
     0.153     2.773     0.200
     0.203     2.992     0.200
     0.179     3.438     0.200
     0.207     3.773     0.200
     0.216     4.156     0.200
     0.250     4.555     0.200
     0.396     6.906     0.200
     0.674    12.445     0.200
     0.762    13.906     0.200
     0.912    15.984     0.200
     0.912    15.805     0.200
     0.867    15.703     0.200
     0.957    16.836     0.200
     0.964    16.867     0.200
     1.013    18.234     0.200
     1.086    19.625     0.200
     1.234    22.258     0.200
     1.306    22.977     0.200
     1.257    22.664     0.200
     2.254    39.555     0.200
     2.594    46.844     0.200
     3.534    63.898     0.200
     5.934   103.672     0.200
     0.055     1.680     0.200
     0.055     1.367     0.200
     0.080     2.250     0.200
     0.100     1.992     0.200
     0.219     3.617     0.200
     0.271     5.273     0.200
     0.265     5.047     0.200
     0.314     5.977     0.200
     0.336     5.742     0.200
     0.390     6.797     0.200
     0.535     9.570     0.200
     0.640    11.867     0.200
     0.671    11.625     0.200
     0.749    13.703     0.200
     0.793    14.094     0.200
     0.950    17.422     0.200
     0.999    17.500     0.200
     1.098    20.055     0.200
     1.121    20.383     0.200
     2.156    37.430     0.200
     2.163    39.180     0.200
     2.289    39.734     0.200
     2.336    42.227     0.200
     2.482    43.000     0.200
     2.518    43.695     0.200
     2.738    48.031     0.200
     2.960    50.672     0.200
     3.213    54.438     0.200
     3.582    60.383     0.200
     3.582    64.820     0.200
     3.743    68.016     0.200
     5.107    90.852     0.200
     0.034     1.703     0.200
     0.070     2.203     0.200
     0.143     4.082     0.200
     0.400     7.453     0.200
     0.422     8.441     0.200
     0.441     8.572     0.200
     0.466     9.113     0.200
     0.528     9.842     0.200
     0.551     9.941     0.200
     0.565    10.373     0.200
     0.625    10.967     0.200
     0.641    11.158     0.200
     0.657    11.652     0.200
     0.696    12.506     0.200
     0.696    12.762     0.200
     0.703    12.533     0.200
     0.711    12.572     0.200
     0.746    14.402     0.200
     0.725    12.156     0.200
     0.725    12.562     0.200
     0.725    12.373     0.200
     0.909    15.932     0.200
     1.002    17.252     0.200
     1.033    17.703     0.200
     1.348    24.293     0.200
     1.811    35.053     0.200
     2.178    37.969     0.200
     0.024     1.531     0.200
     0.075     1.734     0.200
     0.136     3.945     0.200
     0.406     7.516     0.200
     0.433     8.516     0.200
     0.450     8.438     0.200
     0.455     9.031     0.200
     0.537     9.922     0.200
     0.556    10.047     0.200
     0.625    11.047     0.200
     0.650    11.219     0.200
     0.658    11.453     0.200
     0.701    12.875     0.200
     0.711    12.625     0.200
     0.733    12.555     0.200
     0.733    12.211     0.200
     0.740    14.227     0.200
     0.991    17.352     0.200
     1.039    17.938     0.200
     1.151    20.688     0.200
     1.173    20.211     0.200
     1.343    24.203     0.200
     0.046     2.047     0.200
     0.385     7.086     0.200
     0.412     8.141     0.200
     0.439     8.305     0.200
     0.475     9.195     0.200
     0.514     9.477     0.200
     0.536     9.578     0.200
     0.637    11.141     0.200
     0.627    10.836     0.200
     0.669    11.602     0.200
     0.682    12.430     0.200
     0.688    12.148     0.200
     0.726    12.398     0.200
     0.742    14.039     0.200
     1.018    17.375     0.200
     1.342    23.789     0.200
     2.884    48.508     0.200
     6.432   110.320     0.200
     0.036     1.746     0.200
     0.088     2.476     0.200
     0.152     4.506     0.200
     0.425     7.966     0.200
     0.454     8.226     0.200
     0.462     9.236     0.200
     0.538     9.496     0.200
     0.642    10.896     0.200
     0.636    10.962     0.200
     0.675    11.576     0.200
     0.683    12.239     0.200
     0.694    12.156     0.200
     0.740    12.449     0.200
     0.740    13.126     0.200
     0.729    14.256     0.200
     0.999    17.586     0.200
     1.134    20.836     0.200
     1.155    20.716     0.200
     1.331    24.155     0.200
     0.045     1.488     0.200
     0.413     8.047     0.200
     0.439     8.238     0.200
     0.475     9.020     0.200
     0.538     9.598     0.200
     0.635    11.109     0.200
     0.628    10.840     0.200
     0.668    11.547     0.200
     0.683    12.262     0.200
     0.690    12.238     0.200
     0.726    12.402     0.200
     0.743    14.047     0.200
     1.011    18.648     0.200
     1.020    17.547     0.200
     1.140    20.289     0.200
     1.343    24.098     0.200
     2.940    51.188     0.200
     0.045     0.730     0.200
     0.414     8.031     0.200
     0.444     8.289     0.200
     0.473     9.211     0.200
     0.533     9.699     0.200
     0.627    10.812     0.200
     0.641    11.273     0.200
     0.679    12.430     0.200
     0.674    11.730     0.200
     0.687    12.172     0.200
     0.732    12.496     0.200
     0.737    14.160     0.200
     1.016    17.547     0.200
     1.134    20.270     0.200
     1.152    19.820     0.200
     1.337    23.852     0.200
     1.379    24.520     0.200
     2.883    48.430     0.200
     0.031     1.773     0.200
     0.401     7.504     0.200
     0.463     8.973     0.200
     0.552     9.973     0.200
     0.643    11.215     0.200
     0.626    11.057     0.200
     0.705    12.562     0.200
     0.728    12.516     0.200
     0.728    12.633     0.200
     0.998    18.822     0.200
     1.035    17.764     0.200
     1.150    20.354     0.200
     1.346    23.973     0.200
     1.405    25.863     0.200
     0.031     0.766     0.200
     0.398     7.325     0.200
     0.427     8.275     0.200
     0.449     8.445     0.200
     0.461     9.255     0.200
     0.529     9.705     0.200
     0.547     9.936     0.200
     0.642    10.670     0.200
     0.664    11.785     0.200
     0.659    12.335     0.200
     0.702    12.476     0.200
     0.734    12.455     0.200
     0.737    13.525     0.200
     0.997    18.195     0.200
     1.339    24.365     0.200
     1.383    24.726     0.200
     2.898    48.405     0.200
     2.952    51.915     0.200
     0.046     1.883     0.200
     0.085     2.539     0.200
     0.161     4.359     0.200
     0.381     7.094     0.200
     0.414     8.219     0.200
     0.444     8.500     0.200
     0.513     9.516     0.200
     0.532     9.555     0.200
     0.626    10.922     0.200
     0.643    10.953     0.200
     0.645    11.969     0.200
     0.675    11.773     0.200
     0.686    12.195     0.200
     0.677    12.305     0.200
     0.736    13.914     0.200
     1.015    17.516     0.200
     1.133    20.109     0.200
     1.151    20.320     0.200
     2.936    49.930     0.200
     0.380     7.054     0.200
     0.417     8.214     0.200
     0.450     8.554     0.200
     0.513     9.464     0.200
     0.529     9.554     0.200
     0.626    10.815     0.200
     0.641    11.915     0.200
     0.648    11.354     0.200
     0.685    12.354     0.200
     0.674    12.335     0.200
     0.680    11.774     0.200
     0.729    13.875     0.200
     1.012    17.475     0.200
     1.147    19.734     0.200
     1.128    20.084     0.200
     2.880    50.435     0.200
     3.554    64.384     0.200
     5.547    94.674     0.200
     6.574   112.194     0.200
     0.018     1.188     0.200
     0.104     2.188     0.200
     0.119     3.773     0.200
     0.424     7.836     0.200
     0.449     8.578     0.200
     0.487     9.047     0.200
     0.564    10.297     0.200
     0.568    10.328     0.200
     0.678    11.641     0.200
     0.635    11.289     0.200
     0.675    12.672     0.200
     0.669    11.828     0.200
     0.711    13.164     0.200
     0.733    12.961     0.200
     0.767    13.000     0.200
     0.712    14.086     0.200
     1.053    18.328     0.200
     1.144    20.828     0.200
     1.179    20.312     0.200
     1.319    23.508     0.200
     2.981    52.398     0.200
     0.408     7.680     0.200
     0.405     7.523     0.200
     0.479     9.016     0.200
     0.478     8.719     0.200
     0.493     9.578     0.200
     0.495     9.719     0.200
     0.580    10.164     0.200
     0.609    11.203     0.200
     0.626    11.164     0.200
     0.734    13.484     0.200
     0.769    13.773     0.200
     0.784    13.664     0.200
     0.752    14.125     0.200
     0.934    16.805     0.200
     1.238    22.125     0.200
     1.364    24.625     0.200
     1.415    25.094     0.200
     1.849    33.062     0.200
     2.032    34.906     0.200
     2.116    37.766     0.200
     2.492    44.891     0.200
     2.998    51.141     0.200
     3.177    57.469     0.200
     3.268    55.453     0.200
     3.688    62.406     0.200
     3.723    63.172     0.200
     0.198     2.599     0.200
     0.248     4.979     0.200
     0.535     9.749     0.200
     0.586    11.119     0.200
     0.649    11.608     0.200
     0.667    11.989     0.200
     0.729    13.039     0.200
     0.753    13.269     0.200
     0.788    14.559     0.200
     1.122    20.379     0.200
     1.213    21.419     0.200
     1.177    21.289     0.200
     1.206    21.889     0.200
     1.206    21.369     0.200
     3.075    54.789     0.200
     3.863    69.568     0.200
     0.480     8.852     0.200
     0.508     9.391     0.200
     0.514     9.891     0.200
     0.601    10.570     0.200
     0.619    11.352     0.200
     0.623    11.312     0.200
     0.635    10.984     0.200
     0.724    13.891     0.200
     0.728    13.305     0.200
     0.732    12.547     0.200
     0.765    14.125     0.200
     0.774    13.078     0.200
     0.789    13.898     0.200
     1.109    19.094     0.200
     1.230    21.242     0.200
     1.288    23.102     0.200
     1.337    24.055     0.200
     1.330    23.570     0.200
     1.390    24.773     0.200
     3.037    53.508     0.200
     5.400    95.570     0.200
     6.726   116.234     0.200
     0.059     1.383     0.200
     0.139     3.430     0.200
     0.162     4.250     0.200
     0.388     7.141     0.200
     0.463     8.883     0.200
     0.507     9.344     0.200
     0.527     9.547     0.200
     0.538     9.781     0.200
     0.652    11.203     0.200
     0.668    12.375     0.200
     0.676    12.984     0.200
     0.715    12.375     0.200
     1.013    17.594     0.200
     1.097    20.062     0.200
     1.279    23.297     0.200
     2.781    47.844     0.200
     4.239    73.289     0.200
     0.209     4.031     0.200
     0.329     6.592     0.200
     0.358     6.820     0.200
     0.362     6.582     0.200
     0.463     8.801     0.200
     0.481     9.031     0.200
     0.517     9.512     0.200
     0.708    13.301     0.200
     0.987    17.701     0.200
     0.997    18.381     0.200
     1.272    23.070     0.200
     1.299    23.400     0.200
     0.085     1.466     0.200
     0.535     9.836     0.200
     0.498     9.065     0.200
     0.541    10.176     0.200
     0.643    11.365     0.200
     0.675    11.636     0.200
     0.641    11.716     0.200
     0.799    13.516     0.200
     0.755    12.933     0.200
     0.708    13.405     0.200
     0.776    14.339     0.200
     0.808    14.186     0.200
     1.123    19.375     0.200
     1.323    23.706     0.200
     7.100   126.766     0.200
     0.265     5.457     0.200
     0.464     7.660     0.200
     0.534     9.570     0.200
     0.559     9.848     0.200
     0.629    11.797     0.200
     0.632    11.387     0.200
     0.643    11.887     0.200
     0.799    14.520     0.200
     0.831    14.848     0.200
     0.825    15.297     0.200
     0.839    15.918     0.200
     0.901    15.828     0.200
     0.876    16.500     0.200
     0.876    15.918     0.200
     0.904    16.559     0.200
     0.933    17.430     0.200
     0.977    17.605     0.200
     0.984    17.629     0.200
     1.088    20.078     0.200
     1.934    33.680     0.200
     2.671    46.117     0.200
     2.877    49.508     0.200
     3.059    52.590     0.200
     3.351    58.949     0.200
     3.541    61.527     0.200
     0.046     0.922     0.200
     0.086     1.992     0.200
     0.119     2.555     0.200
     0.444     8.422     0.200
     0.461     8.328     0.200
     0.499     8.484     0.200
     0.487     9.266     0.200
     0.507     9.406     0.200
     0.602    10.984     0.200
     0.603    10.859     0.200
     0.639    11.344     0.200
     0.716    12.344     0.200
     0.707    12.945     0.200
     0.712    13.125     0.200
     0.744    13.688     0.200
     0.779    13.336     0.200
     0.779    13.211     0.200
     0.770    13.555     0.200
     0.791    13.797     0.200
     0.868    15.227     0.200
     0.969    16.922     0.200
     1.089    18.711     0.200
     1.089    18.711     0.200
     1.167    21.109     0.200
     1.923    36.242     0.200
     2.857    49.602     0.200
     2.965    52.922     0.200
     3.370    57.586     0.200
     0.062     0.945     0.200
     0.135     2.955     0.200
     0.084     1.935     0.200
     0.458     8.695     0.200
     0.467     9.215     0.200
     0.500     9.415     0.200
     0.524     9.725     0.200
     0.502     8.915     0.200
     0.616    11.135     0.200
     0.611    11.045     0.200
     0.729    12.505     0.200
     0.713    12.995     0.200
     0.702    13.175     0.200
     0.751    13.717     0.200
     0.782    13.775     0.200
     0.793    13.475     0.200
     0.807    14.005     0.200
     0.882    15.425     0.200
     0.978    17.075     0.200
     1.098    18.874     0.200
     1.097    18.874     0.200
     1.167    21.125     0.200
     1.419    25.515     0.200
     1.530    27.455     0.200
     1.536    27.375     0.200
     2.831    48.856     0.200
     2.865    49.924     0.200
     2.976    51.165     0.200
     3.029    52.805     0.200
     3.176    55.245     0.200
     0.223     4.160     0.200
     0.226     4.342     0.200
     0.573    11.182     0.200
     0.601    10.891     0.200
     0.623    11.391     0.200
     0.652    12.041     0.200
     0.667    11.861     0.200
     0.693    12.311     0.200
     0.729    13.301     0.200
     0.743    13.420     0.200
     0.762    13.420     0.200
     1.041    19.102     0.200
     1.124    20.092     0.200
     1.149    20.660     0.200
     1.150    20.602     0.200
     1.193    21.541     0.200
     3.092    53.480     0.200
     0.194     3.844     0.200
     0.235     4.359     0.200
     0.306     5.328     0.200
     0.350     6.312     0.200
     0.371     6.859     0.200
     0.384     7.164     0.200
     0.381     7.672     0.200
     0.482     9.164     0.200
     0.458     9.195     0.200
     0.692    12.617     0.200
     0.692    12.617     0.200
     0.788    13.305     0.200
     0.788    13.625     0.200
     0.758    13.484     0.200
     0.778    14.062     0.200
     0.866    15.516     0.200
     2.463    41.992     0.200
     2.463    41.992     0.200
     2.546    45.227     0.200
     2.601    43.820     0.200
     3.610    62.008     0.200
     0.089     1.863     0.200
     0.100     2.035     0.200
     0.179     3.375     0.200
     0.230     4.098     0.200
     0.253     3.980     0.200
     0.537     9.465     0.200
     0.536     9.465     0.200
     0.523    10.244     0.200
     0.606    11.805     0.200
     0.709    12.764     0.200
     0.799    14.725     0.200
     0.799    14.844     0.200
     0.862    15.234     0.200
     0.918    15.834     0.200
     1.091    19.246     0.200
     2.454    45.234     0.200
     2.460    42.885     0.200
     2.607    45.523     0.200
     2.725    48.955     0.200
     3.081    54.094     0.200
     3.684    66.574     0.200
     0.149     3.990     0.200
     0.418     8.041     0.200
     0.466     8.602     0.200
     0.519     8.990     0.200
     0.563    10.381     0.200
     0.702    11.881     0.200
     0.716    12.801     0.200
     0.787    13.287     0.200
     0.832    14.791     0.200
     0.861    15.283     0.200
     2.074    36.186     0.200
     2.354    41.557     0.200
     2.404    42.795     0.200
     4.408    80.121     0.200
     0.084     3.352     0.200
     0.035     2.508     0.200
     0.351     6.617     0.200
     0.488     9.070     0.200
     0.483     9.141     0.200
     0.543    10.312     0.200
     0.569    10.211     0.200
     0.564     9.820     0.200
     0.453     8.281     0.200
     0.597    11.062     0.200
     0.638    11.578     0.200
     0.572     9.891     0.200
     0.708    12.164     0.200
     0.688    11.539     0.200
     0.688    11.891     0.200
     0.747    13.062     0.200
     0.752    14.031     0.200
     0.780    13.609     0.200
     0.784    14.250     0.200
     0.806    15.047     0.200
     0.992    17.062     0.200
     1.118    18.984     0.200
     1.118    18.984     0.200
     1.238    22.078     0.200
     1.570    29.609     0.200
     0.101     2.789     0.200
     0.320     5.992     0.200
     0.430     7.859     0.200
     0.494     8.555     0.200
     0.463     8.445     0.200
     0.460     8.961     0.200
     0.517     9.648     0.200
     0.528     9.539     0.200
     0.569     9.977     0.200
     0.622    10.992     0.200
     0.654    11.086     0.200
     0.741    13.359     0.200
     0.829    14.922     0.200
     1.537    27.297     0.200
     0.022     2.498     0.200
     0.101     3.387     0.200
     0.416     7.018     0.200
     0.399     8.207     0.200
     0.523     9.748     0.200
     0.571    10.158     0.200
     0.612    10.498     0.200
     0.647    11.658     0.200
     0.672    12.178     0.200
     0.731    12.518     0.200
     0.731    12.172     0.200
     0.759    12.695     0.200
     0.781    14.217     0.200
     0.784    15.207     0.200
     0.816    14.650     0.200
     0.919    15.887     0.200
     1.266    22.818     0.200
     1.399    24.998     0.200
     1.471    25.420     0.200
     1.453    25.658     0.200
     1.622    29.812     0.200
     2.772    47.176     0.200
     0.128     2.180     0.200
     0.142     2.852     0.200
     0.512     9.332     0.200
     0.590    10.902     0.200
     0.658    12.461     0.200
     0.641    11.500     0.200
     0.667    12.172     0.200
     0.686    12.422     0.200
     0.734    13.250     0.200
     0.781    13.375     0.200
     0.841    14.781     0.200
     0.825    14.621     0.200
     0.856    14.582     0.200
     0.856    14.441     0.200
     1.137    20.871     0.200
     1.126    19.566     0.200
     1.161    21.109     0.200
     0.142     2.789     0.200
     0.129     2.178     0.200
     0.658    12.549     0.200
     0.734    13.209     0.200
     0.781    13.348     0.200
     0.840    14.818     0.200
     0.856    14.459     0.200
     0.856    14.949     0.200
     1.127    19.572     0.200
     1.137    20.848     0.200
     1.161    21.068     0.200
     0.073     2.004     0.200
     0.366     6.934     0.200
     0.744    12.898     0.200
     0.784    13.238     0.200
     0.898    16.895     0.200
     1.118    19.445     0.200
     1.317    23.863     0.200
     1.318    23.512     0.200
     2.157    38.285     0.200
     3.399    57.711     0.200
     0.144     2.531     0.200
     0.160     3.164     0.200
     0.289     5.602     0.200
     0.644    11.734     0.200
     0.677    12.281     0.200
     0.699    12.422     0.200
     0.791    13.734     0.200
     0.827    14.898     0.200
     0.873    14.859     0.200
     1.129    19.758     0.200
     1.154    21.102     0.200
     1.227    21.859     0.200
     0.148     2.672     0.200
     0.162     3.211     0.200
     0.222     4.711     0.200
     0.284     4.820     0.200
     0.305     6.961     0.200
     0.538    10.148     0.200
     0.524     9.641     0.200
     0.549    10.672     0.200
     0.565    10.609     0.200
     0.611    11.109     0.200
     0.611    11.383     0.200
     0.650    11.773     0.200
     0.698    12.406     0.200
     0.683    12.492     0.200
     0.796    13.797     0.200
     0.837    14.977     0.200
     0.876    15.398     0.200
     0.876    14.812     0.200
     1.135    19.891     0.200
     1.158    21.719     0.200
     1.228    22.359     0.200
     1.228    22.508     0.200
     1.232    22.562     0.200
     0.840    15.578     0.200
     0.880    16.562     0.200
     1.864    32.305     0.200
     2.112    37.750     0.200
     0.230     4.367     0.200
     0.190     3.453     0.200
     0.689    12.227     0.200
     0.918    16.148     0.200
     0.928    15.805     0.200
     0.928    16.242     0.200
     0.218     5.023     0.200
     0.577    10.414     0.200
     0.674    12.242     0.200
     0.695    12.680     0.200
     0.742    13.453     0.200
     0.856    14.594     0.200
     1.163    21.523     0.200
     1.164    21.594     0.200
     1.169    20.984     0.200
     1.238    22.172     0.200
     2.839    51.242     0.200
     3.073    54.031     0.200
     3.122    54.891     0.200
     3.269    56.438     0.200
     3.395    59.977     0.200
     3.697    66.695     0.200
     3.727    63.656     0.200
     0.202     4.219     0.200
     0.312     5.547     0.200
     0.745    13.148     0.200
     0.773    13.141     0.200
     0.754    13.375     0.200
     0.785    14.172     0.200
     0.870    15.211     0.200
     0.903    15.422     0.200
     0.962    17.406     0.200
     1.087    20.086     0.200
     1.163    21.047     0.200
     1.527    27.352     0.200
     0.374     6.750     0.200
     0.444     8.180     0.200
     0.555     9.547     0.200
     0.575    10.172     0.200
     0.572    10.172     0.200
     0.654    10.703     0.200
     0.714    11.703     0.200
     0.723    12.703     0.200
     0.738    12.703     0.200
     0.968    17.734     0.200
     2.518    43.719     0.200
     2.626    45.688     0.200
     2.948    51.344     0.200
     3.424    58.930     0.200
     3.753    65.531     0.200
     0.185     2.516     0.200
     0.488     8.966     0.200
     0.799    14.446     0.200
     0.925    16.376     0.200
     0.933    17.026     0.200
     0.964    17.576     0.200
     1.010    17.556     0.200
     0.964    17.676     0.200
     1.234    21.356     0.200
     1.957    35.896     0.200
     3.413    60.386     0.200
     3.666    65.886     0.200
     0.178     4.083     0.200
     0.497     9.513     0.200
     0.495     9.503     0.200
     0.539    10.003     0.200
     0.613    11.183     0.200
     0.711    12.123     0.200
     0.727    12.463     0.200
     0.888    15.453     0.200
     0.944    17.123     0.200
     1.057    18.815     0.200
     1.091    19.513     0.200
     1.570    27.619     0.200
     2.712    47.292     0.200
     2.780    47.945     0.200
     2.822    48.714     0.200
     3.145    54.514     0.200
     3.368    59.632     0.200
     3.621    62.106     0.200
     0.226     3.967     0.200
     0.720    12.483     0.200
     0.910    15.910     0.200
     1.028    18.353     0.200
     1.045    18.917     0.200
     1.118    19.877     0.200
     1.246    22.127     0.200
     2.692    47.267     0.200
     2.745    47.857     0.200
     2.791    48.256     0.200
     2.973    53.777     0.200
     3.120    54.604     0.200
     3.352    57.834     0.200
     3.596    61.972     0.200
     4.001    69.506     0.200
     0.148     2.250     0.200
     0.272     5.921     0.200
     0.824    14.991     0.200
     1.105    19.991     0.200
     1.105    20.141     0.200
     1.224    21.811     0.200
     1.255    21.731     0.200
     2.124    39.301     0.200
     2.921    52.851     0.200
     3.016    52.298     0.200
     3.153    55.701     0.200
     3.201    56.621     0.200
     3.349    58.635     0.200
     3.825    65.831     0.200
     0.221     4.469     0.200
     3.170    56.429     0.200
     3.793    68.139     0.200
     0.269     5.014     0.200
     0.366     6.090     0.200
     0.646    11.610     0.200
     0.731    12.024     0.200
     0.784    14.214     0.200
     0.816    15.234     0.200
     0.909    15.794     0.200
     1.188    21.414     0.200
     1.182    20.924     0.200
     2.532    43.564     0.200
     2.582    44.044     0.200
     2.853    51.384     0.200
     3.815    68.554     0.200
     0.364     6.796     0.200
     0.473     8.259     0.200
     0.486     8.606     0.200
     0.565    10.496     0.200
     0.601     9.557     0.200
     0.778    13.925     0.200
     0.876    14.925     0.200
     0.893    16.296     0.200
     0.893    16.187     0.200
     0.900    16.156     0.200
     0.232     4.259     0.200
     0.307     5.499     0.200
     0.323     5.382     0.200
     0.602    11.027     0.200
     0.607    10.519     0.200
     0.752    13.778     0.200
     0.781    13.549     0.200
     0.805    15.269     0.200
     0.913    15.852     0.200
     1.304    23.039     0.200
     1.594    27.858     0.200
     1.595    28.129     0.200
     2.484    41.238     0.200
     2.484    45.459     0.200
     2.535    43.049     0.200
     3.157    56.408     0.200
     3.766    67.419     0.200
     0.718    12.617     0.200
     1.181    20.346     0.200
     1.173    21.478     0.200
     1.266    22.288     0.200
     3.814    66.788     0.200
     0.872    14.922     0.200
     0.857    15.435     0.200
     0.940    17.226     0.200
     0.969    17.346     0.200
     1.798    31.971     0.200
     2.148    36.445     0.200
     2.380    43.016     0.200
     0.138     2.699     0.200
     0.557    10.539     0.200
     1.033    19.328     0.200
     0.119     2.500     0.200
     0.229     4.391     0.200
     0.305     5.381     0.200
     0.320     5.551     0.200
     0.600    10.941     0.200
     0.751    13.701     0.200
     0.783    14.521     0.200
     0.806    15.021     0.200
     1.144    20.201     0.200
     0.321     5.527     0.200
     0.474     8.596     0.200
     0.598    10.787     0.200
     0.636    11.576     0.200
     0.861    14.816     0.200
     0.750    12.875     0.200
     0.871    14.869     0.200
     0.871    14.686     0.200
     1.083    18.611     0.200
     0.069     1.914     0.200
     0.103     2.352     0.200
     0.191     3.852     0.200
     0.258     4.691     0.200
     0.275     4.840     0.200
     0.330     6.781     0.200
     0.442     8.352     0.200
     0.567    10.367     0.200
     0.605    11.113     0.200
     0.733    13.352     0.200
     0.809    14.934     0.200
     0.905    15.953     0.200
     1.118    19.703     0.200
     2.441    42.922     0.200
     2.471    42.602     0.200
     0.131     2.203     0.200
     0.219     4.074     0.200
     0.304     5.246     0.200
     0.313     5.344     0.200
     0.323     6.746     0.200
     0.449     9.055     0.200
     0.606    10.973     0.200
     0.593    11.203     0.200
     0.761    13.773     0.200
     0.819    15.086     0.200
     0.819    15.234     0.200
     0.898    15.688     0.200
     1.153    20.375     0.200
     2.485    44.203     0.200
     0.194     2.484     0.200
     0.237     4.574     0.200
     0.606    11.086     0.200
     0.604    10.934     0.200
     0.624    11.895     0.200
     0.640    12.023     0.200
     0.651    12.402     0.200
     0.691    12.375     0.200
     0.718    12.625     0.200
     0.695    12.844     0.200
     0.732    12.074     0.200
     0.722    12.805     0.200
     0.769    13.945     0.200
     0.802    14.363     0.200
     0.883    15.215     0.200
     0.918    16.453     0.200
     1.082    19.895     0.200
     1.145    20.855     0.200
     1.145    20.734     0.200
     1.188    21.152     0.200
     1.204    20.812     0.200
     1.703    29.734     0.200
     0.156     1.277     0.200
     0.285     5.167     0.200
     0.683    10.807     0.200
     0.698    12.487     0.200
     0.656    12.537     0.200
     0.666    12.037     0.200
     0.722    12.707     0.200
     0.828    14.837     0.200
     0.865    15.617     0.200
     0.980    17.367     0.200
     1.115    20.427     0.200
     1.100    20.107     0.200
     1.115    20.517     0.200
     0.134     2.697     0.200
     0.394     7.667     0.200
     0.587    10.947     0.200
     0.721    13.868     0.200
     0.906    16.067     0.200
     0.984    17.788     0.200
     1.056    19.297     0.200
     1.056    19.387     0.200
     1.101    19.547     0.200
     1.132    20.587     0.200
     0.127     2.326     0.200
     0.315     4.456     0.200
     0.483     8.656     0.200
     0.608    10.836     0.200
     0.596    11.036     0.200
     0.629    11.836     0.200
     0.698    12.576     0.200
     0.719    12.976     0.200
     0.758    12.769     0.200
     0.855    13.676     0.200
     0.870    14.946     0.200
     0.870    14.806     0.200
     1.093    19.269     0.200
     1.113    20.516     0.200
     1.123    20.206     0.200
     1.192    21.416     0.200
     1.245    22.616     0.200
     1.249    22.386     0.200
     2.169    38.622     0.200
     2.278    39.946     0.200
     3.656    65.396     0.200
     0.151     2.770     0.200
     0.257     4.999     0.200
     0.273     5.189     0.200
     0.353     6.258     0.200
     0.420     8.499     0.200
     0.636    11.577     0.200
     0.681    12.539     0.200
     0.744    13.359     0.200
     0.778    14.129     0.200
     0.817    15.259     0.200
     0.906    15.756     0.200
     1.162    21.319     0.200
     1.175    21.449     0.200
     2.404    41.489     0.200
     2.839    51.449     0.200
     3.802    68.569     0.200
     0.144     3.012     0.200
     0.210     3.965     0.200
     0.249     4.684     0.200
     0.285     5.012     0.200
     0.299     5.262     0.200
     0.468     9.375     0.200
     0.588    10.746     0.200
     0.727    13.285     0.200
     0.811    15.074     0.200
     0.802    13.914     0.200
     0.905    15.750     0.200
     1.136    19.984     0.200
     1.201    21.883     0.200
     1.201    21.965     0.200
     1.201    21.934     0.200
     2.517    43.164     0.200
     0.220     3.086     0.200
     0.216     4.215     0.200
     0.604    11.816     0.200
     0.678    12.266     0.200
     0.685    12.355     0.200
     0.737    13.445     0.200
     0.759    12.406     0.200
     0.765    13.906     0.200
     0.850    14.633     0.200
     0.883    15.516     0.200
     1.070    19.688     0.200
     1.160    21.105     0.200
     1.154    20.734     0.200
     1.154    20.527     0.200
     1.166    21.188     0.200
     1.289    23.484     0.200
     1.886    34.375     0.200
     2.830    49.676     0.200
     4.341    77.188     0.200
     0.155     3.500     0.200
     0.405     8.180     0.200
     0.586    11.359     0.200
     0.670    12.020     0.200
     0.803    14.070     0.200
     0.744    14.293     0.200
     0.803    14.320     0.200
     0.924    16.090     0.200
     1.004    17.711     0.200
     1.063    19.430     0.200
     1.063    19.453     0.200
     1.153    20.742     0.200
     0.168     3.109     0.200
     0.244     4.516     0.200
     0.293     5.531     0.200
     0.344     5.984     0.200
     0.346     6.117     0.200
     0.491    10.031     0.200
     0.649    11.891     0.200
     0.698    13.125     0.200
     0.741    12.680     0.200
     0.798    14.109     0.200
     0.840    15.430     0.200
     0.882    15.406     0.200
     0.882    14.867     0.200
     1.571    28.219     0.200
     2.580    43.797     0.200
     0.166     3.292     0.200
     0.442     7.611     0.200
     0.486     8.071     0.200
     0.764    14.592     0.200
     0.711    12.122     0.200
     1.001    19.212     0.200
     1.001    19.222     0.200
     1.145    21.021     0.200
     0.151     2.846     0.200
     0.201     3.326     0.200
     0.181     3.814     0.200
     0.208     3.775     0.200
     0.261     4.426     0.200
     0.424     7.916     0.200
     0.486     9.016     0.200
     0.570    11.016     0.200
     0.656    12.016     0.200
     0.654    12.725     0.200
     0.754    13.775     0.200
     0.766    14.086     0.200
     0.896    14.865     0.200
     1.026    17.863     0.200
     1.038    18.389     0.200
     2.416    41.455     0.200
     0.116     1.762     0.200
     0.412     8.553     0.200
     0.530     8.803     0.200
     1.001    18.553     0.200
     1.018    17.643     0.200
     1.001    18.582     0.200
     1.107    20.053     0.200
     0.165     4.156     0.200
     0.193     3.586     0.200
     0.202     5.125     0.200
     0.210     3.844     0.200
     0.218     4.625     0.200
     0.294     5.094     0.200
     0.363     7.602     0.200
     0.352     7.375     0.200
     0.363     8.328     0.200
     0.454     8.734     0.200
     0.610    11.828     0.200
     0.766    14.086     0.200
     1.166    21.414     0.200
     1.158    20.656     0.200
     1.166    21.383     0.200
     1.230    22.375     0.200
     1.295    23.367     0.200
     1.471    26.641     0.200
     1.593    28.797     0.200
     1.668    29.586     0.200
     1.815    33.414     0.200
     2.033    37.062     0.200
     2.588    45.133     0.200
     0.210     4.550     0.200
     0.209     4.240     0.200
     0.223     5.120     0.200
     0.586    10.750     0.200
     0.577    10.580     0.200
     0.611    11.470     0.200
     0.623    11.690     0.200
     0.667    11.790     0.200
     0.696    12.440     0.200
     0.713    12.480     0.200
     0.741    13.270     0.200
     0.760    13.870     0.200
     0.779    14.190     0.200
     1.070    19.500     0.200
     1.091    19.900     0.200
     1.170    20.990     0.200
     1.170    21.060     0.200
     1.664    30.390     0.200
     2.043    37.520     0.200
     2.081    37.950     0.200
     2.466    42.402     0.200
     2.612    45.605     0.200
     2.758    47.335     0.200
     2.840    49.983     0.200
     2.840    50.800     0.200
     2.942    50.890     0.200
     0.286     4.759     0.200
     0.274     5.169     0.200
     0.455     8.699     0.200
     0.538    10.489     0.200
     0.574    10.689     0.200
     0.604    10.674     0.200
     0.769    13.729     0.200
     0.746    13.449     0.200
     0.801    14.479     0.200
     0.838    15.199     0.200
     2.472    45.609     0.200
     2.527    44.369     0.200
     2.775    49.759     0.200
     3.148    54.749     0.200
     6.560   116.349     0.200
     0.149     2.719     0.200
     0.256     4.879     0.200
     0.270     5.156     0.200
     0.342     6.078     0.200
     0.352     6.227     0.200
     0.422     8.406     0.200
     0.633    11.488     0.200
     0.682    12.586     0.200
     0.746    12.777     0.200
     0.776    13.855     0.200
     0.815    15.156     0.200
     1.162    21.289     0.200
     1.175    21.426     0.200
     1.181    21.488     0.200
     0.205     4.102     0.200
     0.207     4.309     0.200
     0.227     2.770     0.200
     0.572    10.520     0.200
     0.583    10.930     0.200
     0.618    11.871     0.200
     0.626    11.801     0.200
     0.663    12.039     0.200
     0.662    12.449     0.200
     0.692    12.391     0.200
     0.713    12.738     0.200
     0.736    13.379     0.200
     0.775    13.949     0.200
     0.799    13.859     0.200
     0.765    12.531     0.200
     0.800    13.672     0.200
     0.850    14.980     0.200
     0.850    14.609     0.200
     0.886    15.691     0.200
     0.921    15.699     0.200
     1.065    19.109     0.200
     1.092    20.031     0.200
     1.175    20.746     0.200
     1.172    21.230     0.200
     1.172    21.539     0.200
     1.174    22.109     0.200
     1.246    22.602     0.200
     3.119    55.289     0.200
     0.134     2.853     0.200
     0.134     3.073     0.200
     0.188     4.153     0.200
     0.332     6.103     0.200
     0.454     8.413     0.200
     0.507     9.743     0.200
     0.503     9.743     0.200
     0.546     9.743     0.200
     0.603    11.203     0.200
     0.603    10.743     0.200
     0.604    11.603     0.200
     0.663    12.073     0.200
     0.723    11.743     0.200
     0.752    12.743     0.200
     0.734    12.903     0.200
     0.734    12.743     0.200
     0.751    12.743     0.200
     0.848    14.743     0.200
     0.896    15.743     0.200
     0.872    15.633     0.200
     0.948    16.743     0.200
     1.059    18.480     0.200
     1.086    19.773     0.200
     1.091    20.013     0.200
     0.213     3.703     0.200
     0.227     4.533     0.200
     0.240     4.744     0.200
     0.571    10.584     0.200
     0.692    12.293     0.200
     0.683    12.404     0.200
     0.751    13.064     0.200
     0.752    12.664     0.200
     0.741    13.135     0.200
     0.761    13.924     0.200
     1.054    19.523     0.200
     1.148    20.895     0.200
     1.148    20.904     0.200
     1.144    20.305     0.200
     1.144    20.514     0.200
     1.163    19.816     0.200
     0.157     2.719     0.200
     0.304     5.922     0.200
     0.626    11.281     0.200
     0.593    11.289     0.200
     0.649    11.773     0.200
     0.682    12.062     0.200
     0.762    13.133     0.200
     0.774    13.141     0.200
     0.754    13.203     0.200
     0.794    14.031     0.200
     0.843    15.203     0.200
     1.081    18.789     0.200
     1.095    19.820     0.200
     1.076    19.742     0.200
     1.172    20.148     0.200
     0.220     4.164     0.200
     0.226     4.133     0.200
     0.206     3.055     0.200
     0.592    10.984     0.200
     0.599    10.867     0.200
     0.629    11.945     0.200
     0.644    12.047     0.200
     0.678    12.117     0.200
     0.635    12.078     0.200
     0.689    12.734     0.200
     0.706    12.477     0.200
     0.706    12.336     0.200
     0.719    12.812     0.200
     0.762    13.688     0.200
     0.742    12.758     0.200
     0.813    13.758     0.200
     0.817    13.336     0.200
     0.801    14.484     0.200
     0.913    15.867     0.200
     1.034    17.844     0.200
     1.092    18.992     0.200
     1.095    20.008     0.200
     1.158    20.906     0.200
     1.158    20.977     0.200
     1.201    20.844     0.200
     1.193    21.273     0.200
     1.672    30.383     0.200
     1.775    32.375     0.200
     2.058    37.438     0.200
     2.863    51.445     0.200
     2.964    51.234     0.200
     3.096    54.469     0.200
     3.293    56.609     0.200
     3.419    60.328     0.200
     3.769    65.977     0.200
     0.031     1.738     0.200
     0.136     3.000     0.200
     0.203     4.020     0.200
     0.271     5.418     0.200
     0.298     5.262     0.200
     0.295     5.359     0.200
     0.450     9.078     0.200
     0.533    10.680     0.200
     0.580    10.770     0.200
     0.607    11.133     0.200
     0.734    13.609     0.200
     0.792    13.988     0.200
     0.769    14.039     0.200
     0.832    15.668     0.200
     1.157    20.109     0.200
     1.211    22.250     0.200
     1.216    22.230     0.200
     1.218    22.309     0.200
     1.617    28.438     0.200
     2.681    45.543     0.200
     3.155    53.090     0.200
     0.125     2.297     0.200
     0.125     2.449     0.200
     0.160     3.277     0.200
     0.315     5.949     0.200
     0.484     8.957     0.200
     0.633    12.328     0.200
     0.594    10.719     0.200
     0.610    11.008     0.200
     0.645    11.699     0.200
     0.715    12.660     0.200
     0.701    12.719     0.200
     0.759    13.027     0.200
     0.855    14.797     0.200
     0.867    14.594     0.200
     1.096    18.855     0.200
     1.127    20.250     0.200
     1.127    20.598     0.200
     1.251    22.500     0.200
     1.249    22.637     0.200
     1.305    23.367     0.200
     2.985    52.688     0.200
     3.036    53.727     0.200
     3.658    65.449     0.200
     0.030     0.848     0.200
     0.137     2.598     0.200
     0.200     3.859     0.200
     0.272     5.219     0.200
     0.450     8.879     0.200
     0.534    10.109     0.200
     0.607    11.102     0.200
     0.736    13.520     0.200
     0.769    14.047     0.200
     0.769    13.797     0.200
     0.793    13.977     0.200
     0.834    15.598     0.200
     0.882    15.527     0.200
     1.157    20.555     0.200
     2.373    41.277     0.200
     2.532    43.199     0.200
     3.154    55.047     0.200
     6.127   109.754     0.200
     0.144     3.461     0.200
     0.277     6.023     0.200
     0.288     5.914     0.200
     0.626    12.703     0.200
     0.679    12.875     0.200
     1.100    19.641     0.200
     1.100    19.672     0.200
     1.628    30.289     0.200
     2.917    52.703     0.200
     0.145     2.328     0.200
     0.373     7.816     0.200
     0.415     8.406     0.200
     0.573     9.805     0.200
     0.683    12.016     0.200
     0.696    12.695     0.200
     0.738    14.516     0.200
     0.816    14.305     0.200
     0.810    14.637     0.200
     1.008    17.945     0.200
     1.049    19.176     0.200
     1.049    19.348     0.200
     1.049    19.348     0.200
     1.049    19.086     0.200
     1.143    20.836     0.200
     0.153     2.312     0.200
     0.356     7.324     0.200
     0.399     7.926     0.200
     0.399     7.785     0.200
     0.590    10.195     0.200
     0.670    11.926     0.200
     0.741    14.062     0.200
     0.798    13.996     0.200
     0.797    14.113     0.200
     0.918    15.984     0.200
     0.998    17.703     0.200
     1.065    19.445     0.200
     1.065    19.426     0.200
     1.041    18.988     0.200
     1.151    20.715     0.200
     0.158     1.980     0.200
     0.406     7.961     0.200
     0.586    10.102     0.200
     0.748    14.082     0.200
     0.802    14.453     0.200
     0.891    16.512     0.200
     1.007    18.332     0.200
     1.064    19.473     0.200
     1.065    19.543     0.200
     1.156    21.023     0.200
     0.142     2.551     0.200
     0.281     5.672     0.200
     0.305     5.902     0.200
     0.305     6.051     0.200
     0.663    12.090     0.200
     0.661    12.492     0.200
     0.686    12.352     0.200
     0.700    12.223     0.200
     0.739    12.941     0.200
     0.804    14.160     0.200
     0.884    15.852     0.200
     1.100    19.402     0.200
     1.100    20.121     0.200
     1.099    20.262     0.200
     1.100    20.109     0.200
     1.100    20.422     0.200
     0.152     2.910     0.200
     0.188     3.590     0.200
     0.493     9.090     0.200
     0.607    11.652     0.200
     0.622    11.391     0.200
     0.700    12.723     0.200
     0.739    13.473     0.200
     0.738    13.070     0.200
     0.773    13.535     0.200
     0.895    15.230     0.200
     1.089    20.000     0.200
     1.097    19.211     0.200
     1.113    20.250     0.200
     1.190    21.180     0.200
     1.225    21.812     0.200
     1.225    21.922     0.200
     0.146     4.047     0.200
     0.302     5.477     0.200
     0.338     6.537     0.200
     0.639    11.947     0.200
     0.702    13.856     0.200
     0.933    16.387     0.200
     0.933    16.146     0.200
     0.978    16.787     0.200
     1.094    19.937     0.200
     1.094    19.927     0.200
     1.130    20.427     0.200
     1.865    34.367     0.200
     0.071     1.957     0.200
     0.103     2.397     0.200
     0.202     4.037     0.200
     0.210     4.215     0.200
     0.210     4.247     0.200
     0.239     4.247     0.200
     0.275     4.526     0.200
     0.534     9.452     0.200
     0.522     9.027     0.200
     0.522    10.067     0.200
     0.606    11.707     0.200
     0.699    12.747     0.200
     0.746    13.627     0.200
     0.780    14.237     0.200
     0.780    14.497     0.200
     0.851    14.317     0.200
     1.070    19.218     0.200
     1.084    18.849     0.200
     1.654    30.287     0.200
     2.301    40.099     0.200
     2.398    43.141     0.200
     2.476    46.207     0.200
     2.611    45.157     0.200
     2.742    49.638     0.200
     2.742    48.867     0.200
     3.695    66.237     0.200
     0.279     5.520     0.200
     0.298     5.289     0.200
     0.369     7.410     0.200
     0.368     6.938     0.200
     0.401     7.340     0.200
     0.432     7.926     0.200
     0.477     8.355     0.200
     0.491     8.797     0.200
     0.623    11.508     0.200
     0.784    14.121     0.200
     0.906    16.340     0.200
     0.898    16.500     0.200
     1.120    20.480     0.200
     1.173    21.520     0.200
     1.448    26.488     0.200
     0.055     1.602     0.200
     0.112     2.301     0.200
     0.210     4.012     0.200
     0.247     4.820     0.200
     0.256     4.953     0.200
     0.284     5.012     0.200
     0.299     4.953     0.200
     0.469     9.340     0.200
     0.554     9.910     0.200
     0.587    10.355     0.200
     0.603    11.270     0.200
     0.745    13.559     0.200
     0.727    13.359     0.200
     0.809    15.051     0.200
     0.906    15.520     0.200
     1.134    20.031     0.200
     1.200    21.879     0.200
     1.200    21.730     0.200
     1.201    21.781     0.200
     3.138    53.805     0.200
     0.059     1.547     0.200
     0.108     2.195     0.200
     0.212     4.105     0.200
     0.243     4.688     0.200
     0.252     4.855     0.200
     0.282     5.027     0.200
     0.299     5.246     0.200
     0.473     9.227     0.200
     0.557    10.766     0.200
     0.583    10.594     0.200
     0.607    11.246     0.200
     0.741    13.438     0.200
     0.725    13.215     0.200
     0.805    14.906     0.200
     1.130    19.941     0.200
     1.197    21.637     0.200
     1.620    29.215     0.200
     3.135    53.887     0.200
     0.122     2.039     0.200
     0.155     3.199     0.200
     0.486     8.840     0.200
     0.612    11.000     0.200
     0.638    12.289     0.200
     0.590    10.840     0.200
     0.645    11.668     0.200
     0.704    12.770     0.200
     0.710    12.820     0.200
     1.199    21.629     0.200
     1.199    21.059     0.200
     1.254    22.898     0.200
     1.254    22.629     0.200
     1.310    23.629     0.200
     1.619    30.719     0.200
     0.079     1.648     0.200
     0.092     1.977     0.200
     0.204     3.816     0.200
     0.220     4.219     0.200
     0.249     4.207     0.200
     0.217     4.117     0.200
     0.280     4.477     0.200
     0.510    10.289     0.200
     0.510    10.160     0.200
     0.546     9.566     0.200
     0.594    11.789     0.200
     0.629    11.738     0.200
     0.709    12.867     0.200
     0.741    13.637     0.200
     0.786    14.469     0.200
     0.786    14.660     0.200
     0.929    16.219     0.200
     0.929    16.008     0.200
     1.080    18.863     0.200
     1.095    19.305     0.200
     1.192    21.809     0.200
     1.197    21.840     0.200
     2.623    45.902     0.200
     3.449    60.148     0.200
     0.161     3.075     0.200
     0.234     4.985     0.200
     0.402     7.095     0.200
     0.460     8.715     0.200
     0.486     9.265     0.200
     0.568    11.075     0.200
     0.499     9.225     0.200
     0.515     9.035     0.200
     0.578    10.695     0.200
     0.600    10.765     0.200
     0.577    10.895     0.200
     0.612    11.245     0.200
     0.690    12.125     0.200
     0.804    14.245     0.200
     0.903    15.245     0.200
     1.025    18.875     0.200
     1.091    19.325     0.200
     1.268    23.055     0.200
     2.270    40.794     0.200
     2.894    49.314     0.200
     2.942    52.215     0.200
     3.566    64.345     0.200
     3.953    68.024     0.200
     4.174    74.635     0.200
     4.666    82.965     0.200
     0.168     3.387     0.200
     0.182     3.746     0.200
     0.533     9.969     0.200
     0.559    10.258     0.200
     0.622    11.508     0.200
     0.631    11.168     0.200
     0.628    12.598     0.200
     0.655    11.930     0.200
     0.696    12.457     0.200
     0.712    12.316     0.200
     0.742    13.629     0.200
     0.764    12.957     0.200
     0.782    14.344     0.200
     1.102    20.297     0.200
     1.140    19.508     0.200
     1.152    20.547     0.200
     1.152    20.656     0.200
     1.208    21.777     0.200
     1.232    21.207     0.200
     1.247    22.609     0.200
     1.308    23.418     0.200
     0.396     7.930     0.200
     0.440     8.832     0.200
     0.553    10.023     0.200
     0.684    11.953     0.200
     0.713    12.871     0.200
     0.755    14.590     0.200
     0.837    15.012     0.200
     0.836    14.461     0.200
     0.924    16.523     0.200
     1.035    18.562     0.200
     1.358    24.473     0.200
     1.388    24.750     0.200
     1.388    24.492     0.200
     1.444    25.371     0.200
     1.970    36.363     0.200
     3.335    60.551     0.200
     0.062     1.408     0.200
     0.140     2.668     0.200
     0.190     3.848     0.200
     0.192     3.658     0.200
     0.200     3.438     0.200
     0.198     3.697     0.200
     0.254     4.309     0.200
     0.382     7.629     0.200
     0.564    10.598     0.200
     0.648    12.078     0.200
     0.666    12.117     0.200
     0.764    14.037     0.200
     0.764    14.148     0.200
     0.771    13.828     0.200
     0.894    15.947     0.200
     1.193    21.527     0.200
     1.204    21.799     0.200
     1.687    30.568     0.200
     1.688    30.738     0.200
     2.421    42.037     0.200
     2.458    42.188     0.200
     0.138     2.613     0.200
     0.194     3.709     0.200
     0.196     3.764     0.200
     0.273     4.441     0.200
     0.374     7.514     0.200
     0.539    10.514     0.200
     0.517     9.264     0.200
     0.623    12.053     0.200
     0.682    12.145     0.200
     0.682    12.334     0.200
     0.749    13.674     0.200
     0.767    14.303     0.200
     0.911    16.094     0.200
     1.067    18.768     0.200
     1.385    23.975     0.200
     2.284    39.943     0.200
     2.387    43.096     0.200
     2.397    41.734     0.200
     2.595    45.010     0.200
     2.733    49.426     0.200
     0.058     1.258     0.200
     0.113     1.969     0.200
     0.110     2.070     0.200
     0.199     3.656     0.200
     0.272     4.633     0.200
     0.286     4.578     0.200
     0.253     4.758     0.200
     0.247     4.680     0.200
     0.327     6.758     0.200
     0.477     9.469     0.200
     0.561    11.227     0.200
     0.579    10.445     0.200
     0.742    13.320     0.200
     0.738    13.500     0.200
     0.812    15.117     0.200
     0.903    15.500     0.200
     0.903    15.711     0.200
     0.972    17.312     0.200
     1.129    19.953     0.200
     6.111   105.422     0.200
     0.100     1.859     0.200
     0.133     2.281     0.200
     0.218     4.008     0.200
     0.234     4.477     0.200
     0.244     4.375     0.200
     0.281     4.820     0.200
     0.303     5.102     0.200
     0.343     7.047     0.200
     0.478     8.461     0.200
     0.478     9.547     0.200
     0.563    11.242     0.200
     0.577    10.438     0.200
     0.616    11.492     0.200
     0.720    13.273     0.200
     0.733    13.367     0.200
     0.796    14.930     0.200
     0.919    15.797     0.200
     0.919    15.969     0.200
     0.964    17.203     0.200
     1.123    19.883     0.200
     1.189    21.773     0.200
     1.190    21.719     0.200
     1.192    21.961     0.200
     2.656    46.133     0.200
     0.075     1.646     0.200
     0.092     1.926     0.200
     0.133     2.436     0.200
     0.216     4.065     0.200
     0.228     4.485     0.200
     0.236     4.603     0.200
     0.274     4.756     0.200
     0.299     4.862     0.200
     0.348     7.115     0.200
     0.487     9.646     0.200
     0.569    10.350     0.200
     0.572    11.296     0.200
     0.621    11.575     0.200
     0.705    13.125     0.200
     0.725    12.955     0.200
     0.723    13.386     0.200
     0.791    14.836     0.200
     0.924    15.886     0.200
     1.115    19.740     0.200
     1.189    21.355     0.200
     2.215    39.093     0.200
     2.312    40.357     0.200
     2.336    40.767     0.200
     2.450    43.226     0.200
     2.450    44.886     0.200
     2.500    43.296     0.200
     2.648    46.004     0.200
     2.775    49.995     0.200
     3.123    55.556     0.200
     5.625   100.285     0.200
     0.062     1.574     0.200
     0.118     2.445     0.200
     0.134     2.635     0.200
     0.198     3.926     0.200
     0.177     3.754     0.200
     0.200     3.945     0.200
     0.202     3.846     0.200
     0.537    10.426     0.200
     0.622    11.975     0.200
     0.647    12.025     0.200
     0.685    12.285     0.200
     0.685    12.494     0.200
     0.753    13.814     0.200
     0.740    13.676     0.200
     0.772    14.355     0.200
     0.914    16.275     0.200
     2.397    41.635     0.200
     2.448    42.535     0.200
     0.230     4.477     0.200
     0.230     4.736     0.200
     0.233     4.348     0.200
     0.233     4.668     0.200
     0.599    10.848     0.200
     0.603    11.258     0.200
     0.622    12.178     0.200
     0.688    12.396     0.200
     0.690    12.877     0.200
     0.719    12.637     0.200
     0.716    12.736     0.200
     0.737    12.768     0.200
     0.797    14.678     0.200
     0.839    15.367     0.200
     1.082    20.236     0.200
     1.148    21.008     0.200
     1.149    21.248     0.200
     1.184    20.986     0.200
     1.184    21.207     0.200
     1.198    20.775     0.200
     1.243    22.537     0.200
     1.280    22.248     0.200
     2.104    38.986     0.200
     3.094    54.117     0.200
     3.143    54.178     0.200
     0.230     4.799     0.200
     0.233     4.619     0.200
     0.603    11.289     0.200
     0.601    11.098     0.200
     0.601    10.568     0.200
     0.624    12.309     0.200
     0.688    12.449     0.200
     0.717    12.748     0.200
     0.692    12.838     0.200
     0.736    12.629     0.200
     0.766    14.008     0.200
     0.799    14.619     0.200
     0.841    15.348     0.200
     0.914    16.209     0.200
     1.083    20.078     0.200
     1.148    21.049     0.200
     1.186    21.309     0.200
     1.200    20.699     0.200
     3.096    54.248     0.200
     3.145    55.229     0.200
     3.769    65.168     0.200
     0.084     2.067     0.200
     0.084     2.177     0.200
     0.144     2.967     0.200
     0.172     3.827     0.200
     0.227     4.417     0.200
     0.228     4.547     0.200
     0.218     4.457     0.200
     0.277     4.947     0.200
     0.446     8.437     0.200
     0.491     9.787     0.200
     0.565    10.323     0.200
     0.561    10.687     0.200
     0.576    11.377     0.200
     0.631    11.497     0.200
     0.632    11.777     0.200
     0.717    12.947     0.200
     0.715    13.277     0.200
     0.779    13.237     0.200
     0.714    13.327     0.200
     0.803    14.077     0.200
     0.780    14.427     0.200
     0.897    15.897     0.200
     0.948    16.987     0.200
     1.008    17.847     0.200
     1.032    18.307     0.200
     1.038    18.117     0.200
     1.108    19.637     0.200
     1.108    19.627     0.200
     1.128    19.477     0.200
     1.148    19.687     0.200
     1.875    33.247     0.200
     2.064    36.817     0.200
     2.215    39.287     0.200
     2.333    40.325     0.200
     2.538    45.997     0.200
     2.646    45.512     0.200
     2.871    48.027     0.200
     3.121    53.237     0.200
     3.121    53.399     0.200
     0.151     2.969     0.200
     0.194     3.988     0.200
     0.201     3.703     0.200
     0.227     4.359     0.200
     0.299     4.965     0.200
     0.378     7.668     0.200
     0.519     8.789     0.200
     0.519    10.059     0.200
     0.563    10.629     0.200
     0.605    11.758     0.200
     0.653    12.059     0.200
     0.690    12.559     0.200
     0.690    12.660     0.200
     0.722    13.328     0.200
     0.761    13.660     0.200
     0.761    14.320     0.200
     0.739    13.598     0.200
     0.921    16.469     0.200
     1.081    18.957     0.200
     1.167    21.340     0.200
     1.172    21.387     0.200
     2.304    39.551     0.200
     2.471    41.789     0.200
     0.043     1.775     0.200
     0.126     2.953     0.200
     0.139     3.246     0.200
     0.195     4.006     0.200
     0.190     3.896     0.200
     0.246     4.785     0.200
     0.286     4.816     0.200
     0.438     8.756     0.200
     0.605    10.465     0.200
     0.612    11.096     0.200
     0.612    11.205     0.200
     0.711    13.295     0.200
     0.755    13.865     0.200
     0.841    14.906     0.200
     0.997    17.496     0.200
     2.107    37.764     0.200
     2.338    40.506     0.200
     2.352    42.434     0.200
     2.486    46.006     0.200
     2.775    48.953     0.200
     3.011    54.305     0.200
     3.634    65.676     0.200
     3.832    69.416     0.200
     4.378    79.396     0.200
     0.157     2.992     0.200
     0.157     2.883     0.200
     0.171     3.172     0.200
     0.171     3.320     0.200
     0.172     3.582     0.200
     0.278     5.254     0.200
     0.298     5.641     0.200
     0.350     6.301     0.200
     0.335     6.953     0.200
     0.359     6.363     0.200
     0.414     8.441     0.200
     0.525     9.633     0.200
     0.525     9.754     0.200
     0.500    10.152     0.200
     0.582    11.141     0.200
     0.596    11.121     0.200
     0.615    11.320     0.200
     0.663    12.441     0.200
     0.678    12.543     0.200
     0.783    14.211     0.200
     0.817    14.164     0.200
     0.819    15.223     0.200
     0.872    15.754     0.200
     0.904    15.434     0.200
     0.971    17.391     0.200
     1.016    18.242     0.200
     1.083    19.102     0.200
     1.084    19.281     0.200
     1.091    19.492     0.200
     1.108    19.684     0.200
     1.121    19.992     0.200
     1.153    20.312     0.200
     1.181    20.859     0.200
     1.159    21.352     0.200
     1.204    21.152     0.200
     1.207    21.531     0.200
     1.181    21.543     0.200
     2.411    41.469     0.200
     2.527    44.453     0.200
     3.200    54.723     0.200
     0.144     2.789     0.200
     0.162     3.156     0.200
     0.251     4.887     0.200
     0.267     5.090     0.200
     0.286     5.336     0.200
     0.347     6.117     0.200
     0.427     8.406     0.200
     0.686    12.559     0.200
     0.772    13.797     0.200
     0.772    14.000     0.200
     0.814    15.098     0.200
     0.907    15.609     0.200
     1.005    17.938     0.200
     1.166    21.316     0.200
     1.177    21.109     0.200
     1.168    20.574     0.200
     1.182    21.277     0.200
     1.569    29.027     0.200
     1.939    34.066     0.200
     2.278    40.574     0.200
     2.397    41.391     0.200
     2.513    43.777     0.200
     2.563    44.027     0.200
     2.711    45.980     0.200
     2.934    53.039     0.200
     3.163    57.090     0.200
     3.186    53.797     0.200
     3.795    68.578     0.200
     3.969    71.637     0.200
     0.173     3.320     0.200
     0.156     2.914     0.200
     0.262     5.070     0.200
     0.276     5.234     0.200
     0.297     5.547     0.200
     0.337     6.836     0.200
     0.351     6.305     0.200
     0.359     6.336     0.200
     0.415     8.547     0.200
     0.676    12.516     0.200
     0.782    14.180     0.200
     0.782    14.320     0.200
     0.818    15.289     0.200
     0.906    15.602     0.200
     1.261    21.547     0.200
     0.085     2.164     0.200
     0.082     2.074     0.200
     0.138     2.943     0.200
     0.168     3.732     0.200
     0.219     4.373     0.200
     0.218     4.363     0.200
     0.226     4.346     0.200
     0.269     4.873     0.200
     0.299     5.303     0.200
     0.357     7.303     0.200
     0.496     9.623     0.200
     0.496     8.533     0.200
     0.559    10.059     0.200
     0.715    13.043     0.200
     0.722    13.203     0.200
     0.782    14.143     0.200
     0.782    14.523     0.200
     0.946    16.902     0.200
     1.105    19.447     0.200
     0.196     4.352     0.200
     0.196     3.781     0.200
     0.552    10.172     0.200
     0.563    10.008     0.200
     0.600    11.422     0.200
     0.611    11.586     0.200
     0.644    11.961     0.200
     0.660    11.648     0.200
     0.670    11.984     0.200
     0.718    12.852     0.200
     0.728    12.523     0.200
     0.753    13.375     0.200
     0.794    14.180     0.200
     0.779    13.148     0.200
     0.832    14.422     0.200
     1.081    19.625     0.200
     1.150    20.633     0.200
     1.153    20.398     0.200
     1.179    21.836     0.200
     1.231    22.242     0.200
     3.097    54.203     0.200
     0.308     6.234     0.200
     0.645    11.812     0.200
     0.659    11.875     0.200
     0.708    12.535     0.200
     0.653    12.973     0.200
     0.686    12.504     0.200
     0.713    13.254     0.200
     0.745    13.133     0.200
     0.732    13.402     0.200
     0.777    13.992     0.200
     0.803    14.355     0.200
     0.881    15.934     0.200
     0.924    16.527     0.200
     1.094    20.113     0.200
     1.090    19.984     0.200
     2.041    36.082     0.200
     3.181    55.984     0.200
     3.229    56.734     0.200
     0.035     1.371     0.200
     0.168     3.324     0.200
     0.158     2.977     0.200
     0.164     3.395     0.200
     0.213     3.562     0.200
     0.215     4.434     0.200
     0.227     4.254     0.200
     0.279     4.676     0.200
     0.408     8.164     0.200
     0.483     8.605     0.200
     0.573    10.973     0.200
     0.658    11.293     0.200
     0.645    11.574     0.200
     0.645    11.793     0.200
     0.737    13.453     0.200
     0.737    13.754     0.200
     0.750    13.734     0.200
     0.875    15.543     0.200
     1.030    18.195     0.200
     1.165    21.281     0.200
     1.204    22.051     0.200
     1.673    29.461     0.200
     2.135    37.500     0.200
     2.367    41.082     0.200
     2.417    42.062     0.200
     3.040    51.852     0.200
     0.392     7.932     0.200
     0.392     8.113     0.200
     0.594    10.893     0.200
     0.675    11.893     0.200
     0.678    12.293     0.200
     0.731    14.213     0.200
     0.787    14.482     0.200
     0.794    14.932     0.200
     0.795    13.863     0.200
     0.874    15.992     0.200
     0.908    15.932     0.200
     0.988    18.021     0.200
     1.030    18.463     0.200
     1.065    19.682     0.200
     1.065    19.443     0.200
     1.065    20.002     0.200
     1.065    19.422     0.200
     4.449    76.520     0.200
     0.144     2.926     0.200
     0.469     8.656     0.200
     0.496     9.527     0.200
     0.512     9.695     0.200
     0.509     9.707     0.200
     0.555    10.348     0.200
     0.572    10.438     0.200
     0.599    10.766     0.200
     0.627    11.328     0.200
     0.648    12.535     0.200
     0.693    12.598     0.200
     0.729    13.324     0.200
     0.741    12.660     0.200
     0.847    14.262     0.200
     0.847    14.137     0.200
     0.876    15.188     0.200
     1.085    18.812     0.200
     1.128    20.438     0.200
     1.133    20.668     0.200
     1.190    21.336     0.200
     0.019     1.703     0.200
     0.087     2.789     0.200
     0.396     7.367     0.200
     0.396     7.492     0.200
     0.462     9.172     0.200
     0.478     8.547     0.200
     0.478     8.953     0.200
     0.509     9.352     0.200
     0.523     9.852     0.200
     0.523    10.070     0.200
     0.577    10.438     0.200
     0.577    10.883     0.200
     0.583    10.250     0.200
     0.621    10.797     0.200
     0.635    11.711     0.200
     0.658    11.844     0.200
     0.734    12.266     0.200
     0.734    12.508     0.200
     0.747    12.578     0.200
     0.747    12.992     0.200
     0.767    14.023     0.200
     0.797    14.312     0.200
     0.775    14.977     0.200
     0.796    14.336     0.200
     0.813    14.258     0.200
     0.924    15.953     0.200
     1.018    17.562     0.200
     2.760    47.180     0.200
     0.200     3.740     0.200
     0.547    10.029     0.200
     0.593    11.029     0.200
     0.594    11.309     0.200
     0.596    11.340     0.200
     0.639    11.959     0.200
     0.665    11.969     0.200
     0.662    11.939     0.200
     0.740    13.070     0.200
     0.780    13.699     0.200
     0.743    13.549     0.200
     0.785    14.379     0.200
     0.828    14.236     0.200
     0.931    15.641     0.200
     1.218    22.439     0.200
     1.281    23.020     0.200
     2.906    50.176     0.200
     3.237    56.777     0.200
     0.153     2.970     0.200
     0.158     3.405     0.200
     0.174     3.466     0.200
     0.217     3.695     0.200
     0.234     4.436     0.200
     0.221     4.585     0.200
     0.286     4.506     0.200
     0.414     8.285     0.200
     0.482     8.422     0.200
     0.574    11.065     0.200
     0.641    11.745     0.200
     0.659    12.585     0.200
     0.730    13.716     0.200
     0.744    13.686     0.200
     0.871    15.516     0.200
     0.952    18.766     0.200
     0.988    17.019     0.200
     1.028    17.818     0.200
     1.157    21.226     0.200
     1.169    21.375     0.200
     1.197    21.945     0.200
     0.129     2.580     0.200
     0.140     2.904     0.200
     0.193     3.445     0.200
     0.288     4.660     0.200
     0.288     4.805     0.200
     0.455     8.150     0.200
     0.435     8.404     0.200
     0.615    11.215     0.200
     0.601    11.314     0.200
     0.712    13.285     0.200
     0.752    13.654     0.200
     0.844    15.014     0.200
     1.001    17.590     0.200
     1.149    21.035     0.200
     1.164    21.434     0.200
     0.126     2.367     0.200
     0.141     2.949     0.200
     0.197     3.139     0.200
     0.195     3.680     0.200
     0.245     4.500     0.200
     0.246     4.949     0.200
     0.283     4.488     0.200
     0.283     4.789     0.200
     0.438     8.520     0.200
     0.448     8.084     0.200
     0.611    11.139     0.200
     0.608    11.488     0.200
     0.693    13.209     0.200
     0.712    13.068     0.200
     0.712    13.330     0.200
     0.760    13.859     0.200
     0.840    14.959     0.200
     0.995    17.482     0.200
     1.152    21.109     0.200
     1.168    21.340     0.200
     2.216    38.811     0.200
     2.348    42.432     0.200
     2.531    43.920     0.200
     0.022     1.074     0.200
     0.148     2.914     0.200
     0.174     3.186     0.200
     0.161     3.225     0.200
     0.162     3.053     0.200
     0.162     3.234     0.200
     0.217     4.395     0.200
     0.239     4.424     0.200
     0.234     3.875     0.200
     0.297     4.990     0.200
     0.409     8.154     0.200
     0.558    10.674     0.200
     0.497     8.760     0.200
     0.644    11.615     0.200
     0.651    11.865     0.200
     0.730    13.414     0.200
     0.732    13.686     0.200
     0.882    15.654     0.200
     1.040    18.275     0.200
     1.652    30.385     0.200
     2.265    39.174     0.200
     2.582    44.879     0.200
     2.741    49.637     0.200
     2.820    49.855     0.200
     0.051     1.273     0.200
     0.126     2.340     0.200
     0.193     3.043     0.200
     0.143     2.922     0.200
     0.194     3.703     0.200
     0.242     4.492     0.200
     0.246     4.992     0.200
     0.279     4.453     0.200
     0.279     4.711     0.200
     0.437     8.723     0.200
     0.445     7.750     0.200
     0.610    10.934     0.200
     0.610    11.082     0.200
     0.610    11.812     0.200
     0.714    13.324     0.200
     0.764    13.941     0.200
     0.839    14.914     0.200
     0.993    17.473     0.200
     1.694    31.211     0.200
     2.213    39.113     0.200
     2.331    40.613     0.200
     2.381    40.633     0.200
     2.478    41.934     0.200
     0.063     1.680     0.200
     0.121     2.498     0.200
     0.152     3.029     0.200
     0.166     3.559     0.200
     0.240     4.699     0.200
     0.247     4.828     0.200
     0.263     4.789     0.200
     0.313     5.639     0.200
     0.331     5.564     0.200
     0.331     5.850     0.200
     0.344     6.998     0.200
     0.451     8.828     0.200
     0.485     9.109     0.200
     0.569    10.600     0.200
     0.604    10.654     0.200
     0.612    11.260     0.200
     0.696    12.760     0.200
     0.751    13.498     0.200
     0.751    13.619     0.200
     0.800    14.859     0.200
     0.983    17.498     0.200
     1.145    20.146     0.200
     1.172    21.459     0.200
     1.176    21.389     0.200
     1.179    21.379     0.200
     2.372    41.094     0.200
     2.488    43.068     0.200
     2.522    44.078     0.200
     2.538    44.109     0.200
     3.771    67.609     0.200
     0.175     3.328     0.200
     0.175     3.176     0.200
     0.203     4.117     0.200
     0.516     9.277     0.200
     0.566    10.719     0.200
     0.565    10.766     0.200
     0.578    10.848     0.200
     0.599    11.516     0.200
     0.608    11.328     0.200
     0.634    11.129     0.200
     0.644    11.617     0.200
     0.684    12.488     0.200
     0.717    12.988     0.200
     0.757    13.641     0.200
     0.797    13.789     0.200
     0.797    14.016     0.200
     0.810    14.699     0.200
     0.830    14.809     0.200
     0.914    15.398     0.200
     0.914    15.816     0.200
     0.959    16.816     0.200
     1.120    20.488     0.200
     1.116    19.824     0.200
     1.200    21.617     0.200
     1.200    21.766     0.200
     1.201    21.758     0.200
     1.217    22.277     0.200
     1.277    23.336     0.200
     2.168    39.508     0.200
     3.012    52.539     0.200
     3.060    52.578     0.200
     3.684    64.539     0.200
     0.153     2.797     0.200
     0.487     8.816     0.200
     0.537    10.258     0.200
     0.535    10.227     0.200
     0.563    10.668     0.200
     0.578    10.824     0.200
     0.606    10.785     0.200
     0.602    11.496     0.200
     0.654    11.938     0.200
     0.691    12.445     0.200
     0.731    13.129     0.200
     0.767    13.230     0.200
     0.840    14.938     0.200
     0.898    15.195     0.200
     0.898    14.996     0.200
     1.089    18.969     0.200
     1.218    22.188     0.200
     1.275    22.906     0.200
     2.983    51.355     0.200
     3.032    52.766     0.200
     0.350     7.559     0.200
     0.394     8.199     0.200
     0.596    11.359     0.200
     0.667    12.330     0.200
     0.741    14.479     0.200
     0.795    15.029     0.200
     0.792    14.400     0.200
     0.831    15.260     0.200
     0.878    15.900     0.200
     0.914    16.279     0.200
     0.994    18.020     0.200
     1.037    18.535     0.200
     1.037    18.879     0.200
     1.070    20.010     0.200
     1.070    19.910     0.200
     1.105    19.889     0.200
     1.132    19.859     0.200
     1.152    21.090     0.200
     2.260    42.029     0.200
     3.340    58.570     0.200
     3.529    63.559     0.200
     0.295     6.332     0.200
     0.295     6.520     0.200
     0.323     6.602     0.200
     0.646    12.051     0.200
     0.675    13.320     0.200
     0.708    12.660     0.200
     0.647    12.480     0.200
     0.727    13.492     0.200
     0.694    12.699     0.200
     0.751    13.441     0.200
     0.751    12.941     0.200
     0.751    13.340     0.200
     0.797    13.949     0.200
     0.797    14.371     0.200
     0.826    14.711     0.200
     0.826    14.520     0.200
     0.905    16.391     0.200
     0.948    16.805     0.200
     0.948    17.152     0.200
     0.948    16.941     0.200
     1.021    17.719     0.200
     1.067    18.621     0.200
     1.107    20.492     0.200
     1.091    20.281     0.200
     1.091    20.359     0.200
     1.200    20.570     0.200
     2.355    43.570     0.200
     2.631    47.500     0.200
     2.971    53.750     0.200
     3.527    62.691     0.200
     3.829    68.551     0.200
     0.230     4.795     0.200
     0.230     4.936     0.200
     0.237     4.865     0.200
     0.602    10.996     0.200
     0.640    11.984     0.200
     0.631    12.336     0.200
     0.689    12.166     0.200
     0.711    12.465     0.200
     0.727    12.904     0.200
     0.731    13.215     0.200
     0.772    13.996     0.200
     0.850    15.402     0.200
     1.147    20.645     0.200
     1.147    20.715     0.200
     2.971    51.641     0.200
     3.105    53.965     0.200
     0.169     3.578     0.200
     0.196     4.379     0.200
     0.516     9.479     0.200
     0.571    10.600     0.200
     0.561    10.619     0.200
     0.607    11.449     0.200
     0.638    11.488     0.200
     0.606    11.709     0.200
     0.635    11.418     0.200
     0.682    12.398     0.200
     0.719    13.068     0.200
     0.760    13.885     0.200
     0.796    13.596     0.200
     0.813    14.969     0.200
     1.118    19.150     0.200
     2.163    38.600     0.200
     3.013    53.559     0.200
     3.062    54.988     0.200
     3.685    65.439     0.200
     0.350     7.504     0.200
     0.387     8.004     0.200
     0.387     5.844     0.200
     0.591    11.554     0.200
     0.528     9.464     0.200
     0.692    12.434     0.200
     0.685    12.704     0.200
     0.791    14.674     0.200
     0.799    14.224     0.200
     0.820    15.184     0.200
     0.866    15.674     0.200
     0.895    16.054     0.200
     1.016    18.278     0.200
     1.332    24.244     0.200
     1.450    25.844     0.200
     0.219     4.641     0.200
     0.219     4.791     0.200
     0.216     4.301     0.200
     0.577    10.641     0.200
     0.595    11.071     0.200
     0.616    11.741     0.200
     0.616    11.730     0.200
     0.625    11.261     0.200
     0.675    12.081     0.200
     0.669    12.291     0.200
     0.669    11.801     0.200
     0.695    12.561     0.200
     0.723    12.871     0.200
     0.756    13.831     0.200
     0.776    13.771     0.200
     0.818    14.877     0.200
     0.818    15.011     0.200
     0.856    14.440     0.200
     0.856    14.991     0.200
     0.891    15.831     0.200
     0.957    17.381     0.200
     1.016    17.851     0.200
     1.069    19.261     0.200
     1.162    21.061     0.200
     1.163    21.171     0.200
     1.168    20.821     0.200
     1.177    20.182     0.200
     1.752    32.181     0.200
     2.035    37.241     0.200
     2.120    38.711     0.200
     3.395    59.891     0.200
     4.349    77.641     0.200
     0.035     1.352     0.200
     0.185     3.031     0.200
     0.185     3.367     0.200
     0.214     4.352     0.200
     0.226     4.602     0.200
     0.220     4.523     0.200
     0.220     4.211     0.200
     0.244     4.961     0.200
     0.265     4.555     0.200
     0.310     5.883     0.200
     0.465     9.133     0.200
     0.597    10.766     0.200
     0.731    13.336     0.200
     0.731    12.961     0.200
     0.784    14.312     0.200
     0.810    14.234     0.200
     0.807    14.344     0.200
     0.845    14.688     0.200
     0.845    14.789     0.200
     0.934    16.516     0.200
     2.105    36.609     0.200
     2.277    41.203     0.200
     2.397    41.219     0.200
     2.527    45.617     0.200
     2.869    48.094     0.200
     3.469    62.016     0.200
     0.062     1.412     0.200
     0.168     3.201     0.200
     0.154     3.012     0.200
     0.258     4.951     0.200
     0.275     4.922     0.200
     0.295     5.592     0.200
     0.335     6.902     0.200
     0.346     6.211     0.200
     0.355     6.207     0.200
     0.417     8.492     0.200
     0.504     9.662     0.200
     0.504     9.182     0.200
     0.639    11.656     0.200
     0.681    12.391     0.200
     0.781    14.322     0.200
     0.795    14.621     0.200
     0.819    15.432     0.200
     0.904    15.721     0.200
     1.014    18.232     0.200
     1.177    21.182     0.200
     1.162    20.982     0.200
     2.289    41.031     0.200
     2.407    41.912     0.200
     2.523    43.682     0.200
     2.574    44.961     0.200
     0.229     4.453     0.200
     0.228     4.734     0.200
     0.228     4.984     0.200
     0.594    10.922     0.200
     0.621    11.941     0.200
     0.602    11.012     0.200
     0.685    12.633     0.200
     0.711    12.742     0.200
     0.685    12.074     0.200
     0.741    13.703     0.200
     0.720    12.633     0.200
     0.759    13.562     0.200
     0.792    14.172     0.200
     0.792    14.055     0.200
     0.834    15.434     0.200
     0.873    15.180     0.200
     1.151    20.992     0.200
     1.180    21.203     0.200
     1.152    21.121     0.200
     1.193    21.754     0.200
     0.083     2.156     0.200
     0.084     2.207     0.200
     0.138     2.887     0.200
     0.138     2.768     0.200
     0.168     3.576     0.200
     0.218     4.006     0.200
     0.227     4.244     0.200
     0.227     4.598     0.200
     0.220     4.287     0.200
     0.300     5.217     0.200
     0.441     8.326     0.200
     0.471     8.518     0.200
     0.495     9.537     0.200
     0.561     9.914     0.200
     0.554    10.598     0.200
     0.627    11.348     0.200
     0.630    11.457     0.200
     0.716    13.117     0.200
     0.714    12.986     0.200
     0.721    12.877     0.200
     0.771    13.348     0.200
     0.782    14.627     0.200
     0.797    14.326     0.200
     0.812    14.736     0.200
     0.895    16.197     0.200
     0.947    16.906     0.200
     1.005    18.047     0.200
     1.017    18.006     0.200
     1.029    18.438     0.200
     1.031    18.467     0.200
     1.070    18.996     0.200
     1.072    19.127     0.200
     1.106    19.369     0.200
     1.106    19.486     0.200
     1.122    20.217     0.200
     1.121    19.848     0.200
     1.142    20.197     0.200
     1.624    29.957     0.200
     2.209    39.205     0.200
     2.209    39.396     0.200
     2.329    39.838     0.200
     2.493    43.326     0.200
     2.499    47.537     0.200
     2.641    45.725     0.200
     2.773    50.068     0.200
     3.727    66.666     0.200
     3.765    65.268     0.200
     0.198     3.035     0.200
     0.198     3.715     0.200
     0.591    11.316     0.200
     0.635    12.105     0.200
     0.739    13.215     0.200
     0.780    14.465     0.200
     0.824    14.453     0.200
     0.783    14.846     0.200
     0.931    16.031     0.200
     1.139    20.246     0.200
     1.133    21.045     0.200
     1.669    29.434     0.200
     3.232    55.570     0.200
     3.462    59.438     0.200
     3.708    63.176     0.200
     0.043     1.406     0.200
     0.152     3.273     0.200
     0.152     2.906     0.200
     0.175     3.414     0.200
     0.225     4.289     0.200
     0.261     5.203     0.200
     0.296     5.609     0.200
     0.355     5.945     0.200
     0.451     8.883     0.200
     0.507     8.906     0.200
     0.558    10.766     0.200
     0.634    11.727     0.200
     0.634    11.469     0.200
     0.655    12.188     0.200
     0.646    12.414     0.200
     0.688    13.164     0.200
     0.867    15.586     0.200
     1.033    18.320     0.200
     1.096    19.664     0.200
     1.104    19.703     0.200
     1.127    20.547     0.200
     1.604    29.047     0.200
     2.180    38.453     0.200
     2.237    38.797     0.200
     2.405    40.188     0.200
     2.434    43.812     0.200
     2.452    42.516     0.200
     3.077    52.664     0.200
     0.218     4.062     0.200
     0.225     4.375     0.200
     0.574    10.570     0.200
     0.601    11.102     0.200
     0.666    12.398     0.200
     0.679    12.281     0.200
     0.690    12.469     0.200
     0.741    13.398     0.200
     0.731    12.758     0.200
     0.771    13.531     0.200
     0.813    14.852     0.200
     0.813    14.719     0.200
     0.855    14.562     0.200
     1.160    20.844     0.200
     1.159    21.109     0.200
     1.186    20.922     0.200
     1.255    21.984     0.200
     1.294    23.242     0.200
     1.679    30.281     0.200
     1.679    28.859     0.200
     3.828    66.781     0.200
     0.378     8.008     0.200
     0.418     8.539     0.200
     0.418     8.641     0.200
     0.532     9.598     0.200
     0.694    12.590     0.200
     0.705    13.000     0.200
     0.809    14.758     0.200
     0.823    14.609     0.200
     0.898    16.258     0.200
     0.927    16.668     0.200
     0.969    17.410     0.200
     1.005    18.031     0.200
     1.048    19.141     0.200
     1.048    18.887     0.200
     1.039    19.801     0.200
     1.131    20.719     0.200
     1.944    36.586     0.200
     7.775   136.008     0.200
     0.268     5.836     0.200
     0.282     5.656     0.200
     0.282     5.852     0.200
     0.686    12.680     0.200
     0.743    13.547     0.200
     0.845    14.781     0.200
     0.869    14.664     0.200
     0.888    15.984     0.200
     0.888    15.781     0.200
     1.078    19.445     0.200
     1.108    20.352     0.200
     1.108    20.477     0.200
     1.108    20.477     0.200
     1.325    23.117     0.200
     1.790    32.633     0.200
     1.824    33.758     0.200
     2.300    43.008     0.200
     2.914    52.695     0.200
     3.008    52.125     0.200
     3.008    52.258     0.200
     3.146    56.289     0.200
     3.194    53.320     0.200
     3.341    58.664     0.200
     3.468    61.430     0.200
     0.032     1.993     0.200
     0.105     3.254     0.200
     0.402     7.514     0.200
     0.480     9.283     0.200
     0.490     9.133     0.200
     0.528     9.754     0.200
     0.542    10.363     0.200
     0.574    10.293     0.200
     0.596    11.043     0.200
     0.654    11.873     0.200
     0.676    12.254     0.200
     0.740    12.717     0.200
     0.766    13.000     0.200
     0.784    13.734     0.200
     0.814    14.754     0.200
     0.814    14.566     0.200
     2.627    45.164     0.200
     2.779    47.656     0.200
     0.076     1.938     0.200
     0.426     8.062     0.200
     0.503     9.406     0.200
     0.500     9.125     0.200
     0.572    10.539     0.200
     0.612    10.992     0.200
     0.634    11.539     0.200
     0.645    11.586     0.200
     0.747    12.727     0.200
     0.750    13.250     0.200
     0.763    13.062     0.200
     0.781    14.312     0.200
     0.907    16.102     0.200
     1.130    19.328     0.200
     1.211    21.602     0.200
     1.211    21.836     0.200
     1.220    22.156     0.200
     2.898    50.961     0.200
     3.056    53.172     0.200
     3.649    62.758     0.200
     0.030     1.471     0.200
     0.134     2.932     0.200
     0.140     2.820     0.200
     0.172     3.480     0.200
     0.230     4.471     0.200
     0.301     5.451     0.200
     0.297     6.131     0.200
     0.316     6.131     0.200
     0.316     5.877     0.200
     0.328     6.332     0.200
     0.332     5.467     0.200
     0.406     8.150     0.200
     0.406     8.631     0.200
     0.490     9.871     0.200
     0.577    10.342     0.200
     0.650    11.824     0.200
     0.633    11.832     0.200
     0.804    14.711     0.200
     0.826    15.131     0.200
     0.868    14.748     0.200
     0.868    14.900     0.200
     1.036    18.582     0.200
     1.196    21.012     0.200
     1.197    21.521     0.200
     1.220    21.832     0.200
     2.289    40.912     0.200
     2.525    44.771     0.200
     2.577    45.291     0.200
     2.725    47.797     0.200
     2.945    51.887     0.200
     3.168    53.154     0.200
     3.285    59.289     0.200
     3.597    64.270     0.200
     3.798    68.281     0.200
     3.798    68.172     0.200
     3.963    72.031     0.200
     0.300     6.117     0.200
     0.300     5.937     0.200
     0.320     6.667     0.200
     0.320     5.537     0.200
     0.320     6.527     0.200
     0.660    12.087     0.200
     0.692    12.627     0.200
     0.722    12.767     0.200
     0.648    12.317     0.200
     0.759    13.457     0.200
     0.784    13.957     0.200
     0.883    15.767     0.200
     0.931    16.721     0.200
     0.931    16.897     0.200
     1.078    19.677     0.200
     1.246    22.157     0.200
     1.287    21.950     0.200
     1.279    22.287     0.200
     1.335    23.697     0.200
     2.047    37.487     0.200
     0.279     5.836     0.200
     0.297     5.969     0.200
     0.641    11.688     0.200
     0.672    12.219     0.200
     0.670    12.406     0.200
     0.713    12.492     0.200
     0.702    13.172     0.200
     0.738    12.992     0.200
     0.763    13.969     0.200
     0.788    14.266     0.200
     0.866    15.539     0.200
     0.914    16.469     0.200
     1.085    19.656     0.200
     1.099    20.156     0.200
     1.099    20.203     0.200
     1.237    22.008     0.200
     0.128     2.402     0.200
     0.127     2.621     0.200
     0.162     3.102     0.200
     0.218     4.262     0.200
     0.319     5.281     0.200
     0.324     5.863     0.200
     0.294     5.141     0.200
     0.319     6.070     0.200
     0.419     8.363     0.200
     0.503     9.934     0.200
     0.503    10.043     0.200
     0.637    11.398     0.200
     0.794    14.512     0.200
     0.820    14.980     0.200
     0.849    15.832     0.200
     0.870    15.102     0.200
     1.026    18.371     0.200
     1.146    19.832     0.200
     1.185    21.020     0.200
     2.274    41.121     0.200
     2.404    41.527     0.200
     3.185    55.688     0.200
     0.346     6.949     0.200
     0.629    11.449     0.200
     0.655    11.988     0.200
     0.684    12.000     0.200
     0.736    13.449     0.200
     0.750    13.977     0.200
     0.764    13.438     0.200
     0.778    14.367     0.200
     0.825    14.809     0.200
     0.856    15.207     0.200
     0.896    15.938     0.200
     0.936    16.660     0.200
     0.983    17.691     0.200
     1.083    19.816     0.200
     1.121    20.238     0.200
     3.000    54.340     0.200
     3.099    53.941     0.200
     3.283    56.758     0.200
     3.482    62.707     0.200
     0.387     6.812     0.200
     0.387     7.242     0.200
     0.437     8.258     0.200
     0.439     8.133     0.200
     0.485     8.492     0.200
     0.485     8.242     0.200
     0.855    14.727     0.200
     0.863    15.406     0.200
     0.886    16.719     0.200
     0.909    16.758     0.200
     0.904    16.078     0.200
     0.959    17.570     0.200
     1.015    18.094     0.200
     1.470    25.633     0.200
     1.544    27.523     0.200
     1.640    29.906     0.200
     2.342    40.320     0.200
     2.429    42.328     0.200
     2.457    41.820     0.200
     0.343     6.492     0.200
     0.567    10.031     0.200
     0.805    14.883     0.200
     1.057    19.375     0.200
     1.057    19.242     0.200
     1.058    19.383     0.200
     1.069    19.656     0.200
     1.199    20.367     0.200
     1.253    22.086     0.200
     1.253    21.977     0.200
     1.255    22.602     0.200
     1.304    21.992     0.200
     1.289    22.297     0.200
     1.289    22.094     0.200
     1.333    23.453     0.200
     1.792    32.641     0.200
     3.203    56.555     0.200
     3.251    56.516     0.200
     0.231     4.742     0.200
     0.231     5.023     0.200
     0.605    10.961     0.200
     0.633    12.031     0.200
     0.642    12.172     0.200
     0.686    12.391     0.200
     0.688    12.062     0.200
     0.739    13.672     0.200
     0.723    12.574     0.200
     0.761    13.863     0.200
     0.792    14.254     0.200
     0.839    15.082     0.200
     1.148    21.023     0.200
     1.149    20.992     0.200
     1.178    21.113     0.200
     1.178    20.992     0.200
     1.206    21.062     0.200
     1.238    22.254     0.200
     1.305    22.961     0.200
     1.684    29.863     0.200
     2.485    42.746     0.200
     0.082     1.699     0.200
     0.081     1.008     0.200
     0.457     8.566     0.200
     0.485     9.500     0.200
     0.523     9.816     0.200
     0.530     9.777     0.200
     0.574    10.457     0.200
     0.636    11.527     0.200
     0.639    11.559     0.200
     0.640    11.398     0.200
     0.752    12.938     0.200
     0.780    14.316     0.200
     0.806    14.168     0.200
     0.794    13.484     0.200
     0.794    13.727     0.200
     0.888    16.027     0.200
     1.122    19.379     0.200
     1.189    21.590     0.200
     1.200    21.930     0.200
     1.195    21.547     0.200
     1.327    23.680     0.200
     3.000    50.520     0.200
     3.053    54.168     0.200
     0.311     6.250     0.200
     0.311     6.020     0.200
     0.335     5.547     0.200
     0.546    10.379     0.200
     0.665    12.078     0.200
     0.633    12.520     0.200
     0.713    12.707     0.200
     0.740    13.578     0.200
     0.768    13.410     0.200
     0.759    13.797     0.200
     0.804    14.348     0.200
     0.829    14.719     0.200
     0.905    15.898     0.200
     0.954    17.055     0.200
     1.073    19.379     0.200
     1.089    19.957     0.200
     0.223     4.735     0.200
     0.215     3.295     0.200
     0.600    11.104     0.200
     0.614    11.665     0.200
     0.677    12.185     0.200
     0.663    12.455     0.200
     0.687    12.325     0.200
     0.732    13.095     0.200
     0.738    13.435     0.200
     0.759    14.135     0.200
     0.768    13.475     0.200
     0.811    14.104     0.200
     0.815    14.870     0.200
     0.852    14.645     0.200
     1.073    19.765     0.200
     1.161    21.354     0.200
     1.161    21.475     0.200
     1.161    20.395     0.200
     1.158    20.795     0.200
     1.158    20.965     0.200
     1.169    20.392     0.200
     2.130    38.965     0.200
     2.931    50.956     0.200
     3.066    52.145     0.200
     3.114    55.845     0.200
     3.491    59.721     0.200
     3.738    63.165     0.200
     4.486    79.975     0.200
     0.305     6.346     0.200
     0.327     5.896     0.200
     0.661    12.186     0.200
     0.640    12.216     0.200
     0.715    12.815     0.200
     0.704    12.886     0.200
     0.732    13.626     0.200
     0.762    13.546     0.200
     0.795    14.376     0.200
     0.819    14.716     0.200
     0.896    15.485     0.200
     0.896    15.886     0.200
     0.944    16.909     0.200
     1.085    19.896     0.200
     1.269    23.096     0.200
     1.346    24.186     0.200
     1.748    31.826     0.200
     1.791    32.376     0.200
     3.184    57.315     0.200
     3.197    57.815     0.200
     3.860    69.065     0.200
     4.275    73.946     0.200
     0.584    10.703     0.200
     0.577    10.719     0.200
     0.617    11.305     0.200
     0.631    11.852     0.200
     0.677    12.625     0.200
     0.697    12.625     0.200
     0.695    12.273     0.200
     0.742    13.703     0.200
     0.776    13.289     0.200
     0.776    13.398     0.200
     0.823    15.039     0.200
     0.866    14.688     0.200
     1.218    21.812     0.200
     1.257    22.836     0.200
     1.257    22.047     0.200
     1.284    22.648     0.200
     3.076    54.367     0.200
     3.124    56.117     0.200
     0.259     5.068     0.200
     0.616    11.318     0.200
     0.712    13.197     0.200
     0.716    12.457     0.200
     0.709    12.848     0.200
     0.729    13.158     0.200
     0.784    14.277     0.200
     0.806    13.967     0.200
     0.854    15.332     0.200
     1.060    19.037     0.200
     1.121    20.508     0.200
     1.121    20.547     0.200
     1.710    29.447     0.200
     0.489     9.137     0.200
     0.561    10.117     0.200
     0.582    10.340     0.200
     0.592    10.219     0.200
     0.647    11.723     0.200
     0.670    12.449     0.200
     0.755    14.219     0.200
     0.735    13.816     0.200
     0.858    15.477     0.200
     0.853    15.977     0.200
     0.843    14.969     0.200
     0.913    16.938     0.200
     0.993    18.105     0.200
     0.992    17.910     0.200
     1.062    20.098     0.200
     1.063    20.129     0.200
     1.212    21.547     0.200
     1.410    24.859     0.200
     1.410    24.879     0.200
     2.687    46.387     0.200
     2.890    48.867     0.200
     2.926    50.707     0.200
     3.554    61.617     0.200
     0.304     6.314     0.200
     0.673    12.344     0.200
     0.663    12.674     0.200
     0.708    13.154     0.200
     0.726    12.773     0.200
     0.721    13.283     0.200
     0.748    13.184     0.200
     0.765    13.854     0.200
     0.787    14.174     0.200
     0.863    15.023     0.200
     0.911    16.404     0.200
     1.089    20.293     0.200
     1.249    22.744     0.200
     1.340    23.623     0.200
     1.733    32.334     0.200
     2.934    53.104     0.200
     0.485     9.135     0.200
     0.556    10.145     0.200
     0.579    10.395     0.200
     0.644    11.746     0.200
     0.739    13.895     0.200
     0.845    15.004     0.200
     0.823    15.535     0.200
     0.823    15.275     0.200
     0.871    15.904     0.200
     0.857    16.064     0.200
     0.991    18.146     0.200
     0.991    17.945     0.200
     1.066    20.135     0.200
     1.067    20.094     0.200
     2.540    44.570     0.200
     2.685    46.523     0.200
     2.696    47.199     0.200
     2.888    50.266     0.200
     2.924    50.074     0.200
     3.365    58.688     0.200
     3.403    57.645     0.200
     3.552    59.975     0.200
     0.214     3.957     0.200
     0.576    10.570     0.200
     0.614    11.578     0.200
     0.623    11.699     0.200
     0.667    12.359     0.200
     0.674    11.949     0.200
     0.693    12.500     0.200
     0.723    12.617     0.200
     0.758    13.648     0.200
     0.775    13.148     0.200
     0.775    13.578     0.200
     0.822    15.020     0.200
     0.855    14.512     0.200
     1.081    19.629     0.200
     1.167    21.000     0.200
     1.163    21.160     0.200
     1.164    21.168     0.200
     1.175    20.492     0.200
     1.192    21.047     0.200
     1.260    22.188     0.200
     1.260    22.359     0.200
     3.071    54.617     0.200
     3.120    54.680     0.200
     3.117    56.098     0.200
     5.676    99.719     0.200
     0.017     1.508     0.200
     0.105     2.258     0.200
     0.194     3.867     0.200
     0.182     3.668     0.200
     0.265     5.738     0.200
     0.299     5.184     0.200
     0.319     5.828     0.200
     0.318     5.867     0.200
     0.340     6.590     0.200
     0.415     8.359     0.200
     0.543     9.918     0.200
     0.534    10.168     0.200
     0.647    11.789     0.200
     0.814    15.000     0.200
     0.814    14.867     0.200
     0.839    14.551     0.200
     0.839    14.668     0.200
     0.847    15.457     0.200
     0.869    15.566     0.200
     0.878    16.348     0.200
     1.045    18.699     0.200
     1.475    26.539     0.200
     2.272    40.848     0.200
     3.186    54.086     0.200
     0.499     8.945     0.200
     0.563    10.445     0.200
     0.561     9.984     0.200
     0.579    10.242     0.200
     0.586    11.016     0.200
     0.640    11.578     0.200
     0.658    12.281     0.200
     0.670    12.930     0.200
     0.819    14.992     0.200
     0.810    15.234     0.200
     0.810    14.953     0.200
     0.857    15.312     0.200
     0.852    14.445     0.200
     0.842    15.586     0.200
     0.859    15.602     0.200
     0.916    16.953     0.200
     0.936    16.336     0.200
     0.901    16.609     0.200
     0.985    18.000     0.200
     0.982    17.719     0.200
     1.065    19.523     0.200
     1.066    19.609     0.200
     1.359    24.320     0.200
     1.388    25.344     0.200
     1.399    24.836     0.200
     1.575    28.555     0.200
     1.694    31.359     0.200
     1.951    35.016     0.200
     1.933    35.086     0.200
     2.674    46.883     0.200
     2.735    48.172     0.200
     2.881    50.031     0.200
     2.917    50.680     0.200
     3.343    59.930     0.200
     4.680    82.641     0.200
     0.498     9.109     0.200
     0.562    10.734     0.200
     0.566    10.164     0.200
     0.586    10.469     0.200
     0.663    12.477     0.200
     0.648    11.742     0.200
     0.676    12.359     0.200
     0.676    12.930     0.200
     0.763    14.164     0.200
     0.763    14.320     0.200
     0.726    13.438     0.200
     0.863    15.508     0.200
     0.817    15.367     0.200
     0.817    15.156     0.200
     0.844    14.594     0.200
     0.867    15.781     0.200
     0.844    15.719     0.200
     0.938    16.586     0.200
     0.924    17.117     0.200
     0.993    18.125     0.200
     0.990    17.867     0.200
     0.990    17.969     0.200
     1.059    19.680     0.200
     1.060    19.719     0.200
     1.209    21.445     0.200
     1.235    22.250     0.200
     1.583    28.734     0.200
     1.702    32.211     0.200
     1.879    33.930     0.200
     1.941    34.938     0.200
     2.390    41.297     0.200
     2.682    47.367     0.200
     2.687    46.727     0.200
     2.743    47.977     0.200
     2.953    52.594     0.200
     3.070    53.023     0.200
     3.552    61.461     0.200
     3.552    61.578     0.200
     3.788    66.430     0.200
     0.220     3.427     0.200
     0.235     4.767     0.200
     0.235     4.637     0.200
     0.657    12.297     0.200
     0.676    12.356     0.200
     0.686    12.356     0.200
     0.755    12.956     0.200
     0.750    13.217     0.200
     0.802    14.792     0.200
     0.760    13.837     0.200
     0.846    14.636     0.200
     1.056    19.167     0.200
     1.140    20.677     0.200
     1.140    21.257     0.200
     1.157    20.210     0.200
     1.167    20.706     0.200
     1.167    21.187     0.200
     1.154    21.167     0.200
     1.155    21.087     0.200
     1.703    31.826     0.200
     2.823    51.076     0.200
     3.849    68.236     0.200
     0.218     3.314     0.200
     0.223     4.764     0.200
     0.223     4.324     0.200
     0.617    11.965     0.200
     0.668    12.654     0.200
     0.671    12.475     0.200
     0.774    13.244     0.200
     0.755    14.025     0.200
     0.821    15.107     0.200
     0.856    14.920     0.200
     0.938    15.984     0.200
     1.164    21.225     0.200
     1.164    21.395     0.200
     1.159    21.215     0.200
     1.160    21.004     0.200
     1.160    21.535     0.200
     1.175    20.533     0.200
     1.190    21.264     0.200
     1.258    22.184     0.200
     1.258    22.625     0.200
     1.678    30.445     0.200
     2.590    45.455     0.200
     3.122    56.584     0.200
     0.221     3.191     0.200
     0.231     4.582     0.200
     0.618    11.771     0.200
     0.621    11.811     0.200
     0.663    12.551     0.200
     0.684    12.230     0.200
     0.685    12.492     0.200
     0.739    13.521     0.200
     0.741    13.002     0.200
     0.756    13.922     0.200
     0.764    13.131     0.200
     0.812    14.975     0.200
     0.852    14.781     0.200
     1.064    19.541     0.200
     1.151    21.041     0.200
     1.155    21.230     0.200
     1.155    21.211     0.200
     1.166    20.436     0.200
     1.177    21.172     0.200
     1.218    22.051     0.200
     1.247    22.072     0.200
     1.247    22.822     0.200
     1.284    22.980     0.200
     3.063    54.541     0.200
     3.111    55.322     0.200
     0.216     4.324     0.200
     0.216     3.994     0.200
     0.210     3.133     0.200
     0.610    11.863     0.200
     0.618    11.744     0.200
     0.670    12.113     0.200
     0.662    12.514     0.200
     0.688    12.473     0.200
     0.724    12.732     0.200
     0.762    14.014     0.200
     0.770    13.152     0.200
     0.817    14.908     0.200
     0.850    14.732     0.200
     0.930    15.633     0.200
     0.930    15.883     0.200
     1.081    19.744     0.200
     1.167    21.043     0.200
     1.168    21.062     0.200
     1.164    21.273     0.200
     1.171    20.559     0.200
     1.189    21.324     0.200
     1.708    32.389     0.200
     2.834    51.254     0.200
     3.067    54.494     0.200
     3.115    54.943     0.200
     3.739    65.453     0.200
     0.273     5.938     0.200
     0.273     5.809     0.200
     0.284     5.879     0.200
     0.699    12.996     0.200
     0.727    12.676     0.200
     0.684    12.688     0.200
     0.765    13.906     0.200
     0.817    14.527     0.200
     0.890    16.117     0.200
     6.952   120.727     0.200
     0.296     6.047     0.200
     0.284     5.977     0.200
     0.284     5.855     0.200
     0.711    13.164     0.200
     0.700    13.035     0.200
     0.754    13.617     0.200
     0.775    13.945     0.200
     0.731    12.785     0.200
     0.829    15.137     0.200
     0.851    14.734     0.200
     0.899    16.184     0.200
     1.255    21.473     0.200
     1.731    30.812     0.200
     1.731    30.996     0.200
     0.129     3.059     0.200
     0.263     4.729     0.200
     0.225     4.309     0.200
     0.333     5.748     0.200
     0.333     5.484     0.200
     0.346     6.748     0.200
     0.357     6.729     0.200
     0.405     8.059     0.200
     0.457     8.318     0.200
     0.457     8.207     0.200
     0.565     9.877     0.200
     0.604    10.627     0.200
     0.586    11.398     0.200
     0.638    11.957     0.200
     0.676    11.857     0.200
     0.814    14.328     0.200
     0.819    14.248     0.200
     0.819    14.188     0.200
     0.792    14.178     0.200
     0.875    15.211     0.200
     0.877    15.588     0.200
     1.144    20.088     0.200
     1.207    20.580     0.200
     0.286     6.133     0.200
     0.304     6.193     0.200
     0.708    13.253     0.200
     0.718    12.753     0.200
     0.724    13.333     0.200
     0.768    14.053     0.200
     0.869    14.923     0.200
     0.917    16.343     0.200
     1.092    20.113     0.200
     1.092    20.233     0.200
     1.092    20.243     0.200
     3.170    56.043     0.200
     3.842    67.553     0.200
     4.448    80.113     0.200
     0.034     1.223     0.200
     0.278     5.863     0.200
     0.456     8.402     0.200
     0.529     9.883     0.200
     0.600    10.902     0.200
     0.643    11.414     0.200
     0.706    12.223     0.200
     0.707    12.234     0.200
     0.707    12.594     0.200
     0.747    13.699     0.200
     0.762    12.773     0.200
     0.762    12.980     0.200
     0.936    17.625     0.200
     1.085    18.738     0.200
     1.173    21.043     0.200
     1.180    20.766     0.200
     1.180    21.254     0.200
     1.445    25.562     0.200
     2.958    53.402     0.200
     3.012    51.766     0.200
     4.617    78.902     0.200
     6.511   111.500     0.200
     0.232     4.448     0.200
     0.220     4.288     0.200
     0.447     8.778     0.200
     0.579    10.099     0.200
     0.616    11.658     0.200
     0.618    11.708     0.200
     0.661    12.389     0.200
     0.682    12.389     0.200
     0.761    13.128     0.200
     0.809    14.828     0.200
     0.850    14.391     0.200
     0.850    14.928     0.200
     1.147    20.428     0.200
     1.147    20.608     0.200
     1.163    20.045     0.200
     1.163    20.398     0.200
     3.060    53.928     0.200
     0.072     2.070     0.200
     0.568    10.480     0.200
     0.745    12.859     0.200
     0.743    12.664     0.200
     0.785    14.227     0.200
     0.802    14.039     0.200
     0.765    13.012     0.200
     0.909    17.480     0.200
     1.599    29.352     0.200
     2.618    45.582     0.200
     2.752    47.984     0.200
     3.398    59.145     0.200
     0.241     5.250     0.200
     0.241     5.137     0.200
     0.250     5.227     0.200
     0.486     9.328     0.200
     0.818    14.289     0.200
     0.866    15.586     0.200
     2.882    50.711     0.200
     0.261     5.304     0.200
     0.268     5.284     0.200
     0.295     5.614     0.200
     0.348     7.134     0.200
     0.348     6.844     0.200
     0.450     8.394     0.200
     0.512     9.474     0.200
     0.467     8.524     0.200
     0.521     9.419     0.200
     0.559    10.134     0.200
     0.585    10.884     0.200
     0.602    10.964     0.200
     0.649    12.064     0.200
     0.682    12.232     0.200
     0.616    12.174     0.200
     0.668    11.814     0.200
     0.677    12.834     0.200
     0.701    12.274     0.200
     0.815    14.194     0.200
     0.834    14.444     0.200
     0.865    14.964     0.200
     0.888    15.584     0.200
     0.867    14.995     0.200
     0.905    16.974     0.200
     1.087    18.714     0.200
     1.141    19.644     0.200
     1.152    19.994     0.200
     1.980    33.614     0.200
     0.059     3.440     0.200
     0.059     1.300     0.200
     0.150     3.141     0.200
     0.176     4.050     0.200
     0.303     5.930     0.200
     0.303     6.411     0.200
     0.443     8.331     0.200
     0.463     9.110     0.200
     0.463     9.250     0.200
     0.477     8.710     0.200
     0.511     9.470     0.200
     0.514     9.840     0.200
     0.553    10.000     0.200
     0.619    11.161     0.200
     0.619    11.210     0.200
     0.653    11.260     0.200
     0.679    13.320     0.200
     0.720    12.500     0.200
     0.730    12.608     0.200
     0.723    12.690     0.200
     0.751    13.041     0.200
     0.779    13.184     0.200
     0.764    14.001     0.200
     0.786    13.920     0.200
     0.882    15.331     0.200
     0.911    16.210     0.200
     0.985    17.240     0.200
     1.066    19.510     0.200
     1.105    19.163     0.200
     1.105    19.280     0.200
     1.149    20.891     0.200
     1.190    21.331     0.200
     1.225    22.090     0.200
     1.283    23.180     0.200
     1.283    23.650     0.200
     1.402    26.851     0.200
     1.634    29.460     0.200
     2.434    42.132     0.200
     2.456    44.581     0.200
     0.080     2.234     0.200
     0.121     2.453     0.200
     0.318     6.203     0.200
     0.318     6.586     0.200
     0.418     7.805     0.200
     0.470     9.547     0.200
     0.497     9.289     0.200
     0.504     9.156     0.200
     0.519     9.930     0.200
     0.603    10.758     0.200
     0.575    10.797     0.200
     0.634    10.969     0.200
     0.638    11.633     0.200
     0.650    11.695     0.200
     0.729    12.766     0.200
     0.714    13.914     0.200
     0.756    12.836     0.200
     0.749    12.828     0.200
     0.757    13.086     0.200
     0.757    13.195     0.200
     0.797    14.406     0.200
     0.897    15.688     0.200
     1.013    17.477     0.200
     1.135    19.312     0.200
     1.185    21.609     0.200
     1.219    21.758     0.200
     1.260    21.875     0.200
     1.260    22.039     0.200
     1.320    23.867     0.200
     1.339    23.883     0.200
     1.541    25.906     0.200
     1.495    26.445     0.200
     1.552    27.719     0.200
     1.668    29.195     0.200
     1.705    29.430     0.200
     1.748    32.312     0.200
     1.781    31.719     0.200
     5.024    89.836     0.200
     5.970   106.156     0.200
     6.179   105.734     0.200
     0.085     2.000     0.200
     0.117     2.562     0.200
     0.139     3.734     0.200
     0.321     6.539     0.200
     0.360     7.375     0.200
     0.414     7.875     0.200
     0.472     9.312     0.200
     0.472     9.445     0.200
     0.495     9.250     0.200
     0.509     9.062     0.200
     0.579    10.484     0.200
     0.597    10.664     0.200
     0.630    10.992     0.200
     0.642    11.461     0.200
     0.655    11.516     0.200
     0.730    12.742     0.200
     0.752    12.891     0.200
     0.720    13.750     0.200
     0.752    12.672     0.200
     0.762    12.883     0.200
     0.802    14.273     0.200
     0.899    15.594     0.200
     1.018    17.391     0.200
     1.234    22.195     0.200
     1.466    26.281     0.200
     1.500    26.664     0.200
     2.872    50.219     0.200
     3.408    58.375     0.200
     0.069     1.820     0.200
     0.132     2.812     0.200
     0.158     3.766     0.200
     0.428     8.086     0.200
     0.466     9.289     0.200
     0.492     9.023     0.200
     0.502     9.453     0.200
     0.516     9.969     0.200
     0.565    10.312     0.200
     0.629    11.445     0.200
     0.637    11.539     0.200
     0.641    11.133     0.200
     0.619    11.031     0.200
     0.699    13.594     0.200
     0.740    12.711     0.200
     0.742    12.844     0.200
     0.761    13.242     0.200
     0.765    13.016     0.200
     0.782    14.344     0.200
     0.800    14.086     0.200
     0.890    15.344     0.200
     1.001    17.484     0.200
     1.122    19.195     0.200
     1.169    21.211     0.200
     1.203    21.492     0.200
     1.212    21.195     0.200
     1.304    23.492     0.200
     1.503    26.883     0.200
     1.653    29.750     0.200
     2.521    41.992     0.200
     2.749    47.414     0.200
     4.240    75.641     0.200
     5.917   101.633     0.200
     6.187   106.445     0.200
     0.162     3.488     0.200
     0.243     4.599     0.200
     0.243     4.559     0.200
     0.254     4.791     0.200
     0.299     5.289     0.200
     0.313     5.428     0.200
     0.345     6.528     0.200
     0.345     6.688     0.200
     0.382     7.139     0.200
     0.393     6.829     0.200
     0.403     7.488     0.200
     0.425     7.838     0.200
     0.472     8.519     0.200
     0.465     8.628     0.200
     0.492     9.678     0.200
     0.470     8.678     0.200
     0.518     9.849     0.200
     0.580    11.218     0.200
     0.580    11.088     0.200
     0.578    10.418     0.200
     0.591    10.878     0.200
     0.576    10.409     0.200
     0.591    10.778     0.200
     0.610    11.818     0.200
     0.603    10.639     0.200
     0.667    12.249     0.200
     0.667    12.378     0.200
     0.684    12.079     0.200
     0.703    12.378     0.200
     0.700    12.588     0.200
     0.775    13.648     0.200
     0.804    14.458     0.200
     0.789    14.579     0.200
     0.807    15.128     0.200
     0.819    14.289     0.200
     0.820    14.999     0.200
     0.843    14.713     0.200
     0.831    15.249     0.200
     0.831    15.458     0.200
     0.860    15.499     0.200
     0.880    15.938     0.200
     0.967    17.139     0.200
     1.029    18.619     0.200
     1.041    18.729     0.200
     1.094    19.039     0.200
     1.101    18.928     0.200
     1.186    20.369     0.200
     2.019    35.059     0.200
     2.332    40.243     0.200
     0.109     3.254     0.200
     0.111     3.004     0.200
     0.097     2.793     0.200
     0.235     5.242     0.200
     0.235     6.172     0.200
     0.285     5.355     0.200
     0.291     6.172     0.200
     0.291     6.055     0.200
     0.371     5.965     0.200
     0.371     7.785     0.200
     0.418     8.125     0.200
     0.412     8.145     0.200
     0.483     9.473     0.200
     0.503     9.773     0.200
     0.533    10.062     0.200
     0.533    10.266     0.200
     0.552    10.355     0.200
     0.530    10.184     0.200
     0.539    10.344     0.200
     0.543    10.273     0.200
     0.564    10.285     0.200
     0.542     9.992     0.200
     0.573    10.754     0.200
     0.559    11.113     0.200
     0.587    10.922     0.200
     0.602    11.953     0.200
     0.670    11.883     0.200
     0.673    12.363     0.200
     0.755    14.004     0.200
     0.841    15.055     0.200
     0.883    16.082     0.200
     0.963    16.562     0.200
     0.995    18.035     0.200
     1.378    25.633     0.200
     1.553    27.945     0.200
     1.642    29.793     0.200
     1.961    35.734     0.200
     1.951    35.125     0.200
     2.250    40.414     0.200
     0.033     2.021     0.200
     0.043     2.561     0.200
     0.075     2.001     0.200
     0.113     2.570     0.200
     0.129     3.480     0.200
     0.150     3.801     0.200
     0.227     4.631     0.200
     0.248     5.150     0.200
     0.253     5.160     0.200
     0.309     6.551     0.200
     0.312     6.751     0.200
     0.323     6.711     0.200
     0.337     6.381     0.200
     0.364     7.461     0.200
     0.409     7.891     0.200
     0.447     8.521     0.200
     0.460     9.290     0.200
     0.487     9.290     0.200
     0.509     9.860     0.200
     0.555    11.051     0.200
     0.568    10.530     0.200
     0.589    11.101     0.200
     0.587    11.381     0.200
     0.624    11.021     0.200
     0.630    11.501     0.200
     0.645    11.601     0.200
     0.645    11.551     0.200
     0.719    12.771     0.200
     0.719    13.891     0.200
     0.740    12.700     0.200
     0.746    12.931     0.200
     0.794    13.891     0.200
     0.793    14.320     0.200
     0.803    14.061     0.200
     0.921    16.330     0.200
     1.097    19.950     0.200
     1.130    19.311     0.200
     1.323    23.400     0.200
     1.323    23.620     0.200
     1.351    23.900     0.200
     1.425    25.160     0.200
     1.885    31.961     0.200
     0.050     2.133     0.200
     0.127     2.836     0.200
     0.234     4.805     0.200
     0.234     5.055     0.200
     0.232     5.227     0.200
     0.267     5.852     0.200
     0.309     6.125     0.200
     0.362     6.945     0.200
     0.407     8.703     0.200
     0.437     8.297     0.200
     0.447     8.875     0.200
     0.469     9.453     0.200
     0.506    10.047     0.200
     0.503    10.133     0.200
     0.510     9.977     0.200
     0.518    10.172     0.200
     0.555    10.445     0.200
     0.573    10.883     0.200
     0.598    11.836     0.200
     0.605    11.055     0.200
     0.636    12.016     0.200
     0.691    12.852     0.200
     0.689    12.625     0.200
     0.690    12.234     0.200
     0.717    11.922     0.200
     0.716    13.055     0.200
     0.717    12.781     0.200
     0.735    13.672     0.200
     0.755    13.664     0.200
     0.767    13.617     0.200
     0.845    15.266     0.200
     0.901    16.805     0.200
     0.890    15.383     0.200
     0.913    15.875     0.200
     1.038    17.922     0.200
     1.146    20.664     0.200
     1.183    20.992     0.200
     1.737    32.617     0.200
     3.552    59.531     0.200
     0.099     3.291     0.200
     0.113     3.471     0.200
     0.142     3.671     0.200
     0.152     3.851     0.200
     0.153     4.201     0.200
     0.177     4.011     0.200
     0.190     4.611     0.200
     0.219     4.821     0.200
     0.282     5.230     0.200
     0.284     5.791     0.200
     0.331     6.361     0.200
     0.330     6.391     0.200
     0.366     7.331     0.200
     0.375     7.051     0.200
     0.377     7.371     0.200
     0.396     7.791     0.200
     0.414     8.241     0.200
     0.443     9.491     0.200
     0.458     9.190     0.200
     0.469     8.811     0.200
     0.482     9.271     0.200
     0.478     9.171     0.200
     0.525     9.041     0.200
     0.530     9.341     0.200
     0.589    10.891     0.200
     0.591    11.011     0.200
     0.615    10.761     0.200
     0.604    11.051     0.200
     0.626    10.891     0.200
     0.638    11.181     0.200
     0.650    10.940     0.200
     0.658    11.980     0.200
     0.678    11.861     0.200
     0.757    14.141     0.200
     0.820    15.061     0.200
     0.910    16.831     0.200
     0.938    16.271     0.200
     0.947    16.561     0.200
     0.947    16.721     0.200
     1.037    18.601     0.200
     1.172    20.311     0.200
     1.291    22.521     0.200
     1.291    22.960     0.200
     0.048     1.584     0.200
     0.065     1.604     0.200
     0.105     2.395     0.200
     0.108     2.484     0.200
     0.106     1.975     0.200
     0.132     3.314     0.200
     0.155     3.904     0.200
     0.160     3.943     0.200
     0.242     4.875     0.200
     0.259     5.254     0.200
     0.255     5.135     0.200
     0.245     4.924     0.200
     0.276     5.814     0.200
     0.305     6.395     0.200
     0.303     6.285     0.200
     0.314     6.824     0.200
     0.319     6.834     0.200
     0.327     5.875     0.200
     0.356     7.865     0.200
     0.344     6.725     0.200
     0.359     7.184     0.200
     0.421     8.035     0.200
     0.459     9.135     0.200
     0.494     9.334     0.200
     0.489     8.934     0.200
     0.514     9.715     0.200
     0.509     9.785     0.200
     0.541    10.654     0.200
     0.561    10.404     0.200
     0.587    10.914     0.200
     0.594    11.404     0.200
     0.633    11.084     0.200
     0.624    11.295     0.200
     0.634    11.404     0.200
     0.634    11.564     0.200
     0.694    13.084     0.200
     0.718    12.664     0.200
     0.704    13.545     0.200
     0.735    12.535     0.200
     0.757    13.135     0.200
     0.741    12.635     0.200
     0.756    13.184     0.200
     0.781    14.164     0.200
     0.796    13.904     0.200
     0.918    16.295     0.200
     1.086    20.004     0.200
     1.315    23.684     0.200
     1.444    26.064     0.200
     0.148     2.728     0.200
     0.199     3.668     0.200
     0.216     4.218     0.200
     0.234     4.998     0.200
     0.275     5.118     0.200
     0.283     5.938     0.200
     0.298     5.918     0.200
     0.306     6.138     0.200
     0.285     5.908     0.200
     0.323     6.578     0.200
     0.326     6.488     0.200
     0.356     6.948     0.200
     0.365     7.128     0.200
     0.386     7.688     0.200
     0.411     7.748     0.200
     0.405     8.148     0.200
     0.406     8.168     0.200
     0.406     8.048     0.200
     0.436     8.018     0.200
     0.503     9.738     0.200
     0.538    10.368     0.200
     0.553     9.888     0.200
     0.552     9.958     0.200
     0.542    10.168     0.200
     0.559    10.638     0.200
     0.549    10.768     0.200
     0.566    10.488     0.200
     0.609    11.268     0.200
     0.611    11.508     0.200
     0.611    11.048     0.200
     0.618    11.318     0.200
     0.638    10.688     0.200
     0.684    12.518     0.200
     0.661    12.618     0.200
     0.720    12.668     0.200
     0.739    12.968     0.200
     0.749    13.488     0.200
     0.748    13.398     0.200
     0.763    12.928     0.200
     0.829    14.588     0.200
     0.883    15.628     0.200
     0.884    15.408     0.200
     0.882    15.448     0.200
     0.961    17.728     0.200
     0.961    17.848     0.200
     1.045    19.118     0.200
     1.060    19.378     0.200
     1.076    19.358     0.200
     1.130    20.338     0.200
     1.363    24.208     0.200
     1.425    27.788     0.200
     1.535    27.488     0.200
     1.751    31.158     0.200
     2.930    52.288     0.200
     2.979    52.478     0.200
     3.483    62.898     0.200
     4.687    80.228     0.200
     0.110     2.539     0.200
     0.125     2.578     0.200
     0.154     3.539     0.200
     0.191     3.398     0.200
     0.163     3.309     0.200
     0.216     3.539     0.200
     0.224     3.762     0.200
     0.205     4.391     0.200
     0.227     4.371     0.200
     0.244     5.078     0.200
     0.243     4.840     0.200
     0.289     5.770     0.200
     0.240     4.969     0.200
     0.290     5.551     0.200
     0.315     6.480     0.200
     0.338     6.750     0.200
     0.338     6.719     0.200
     0.323     6.629     0.200
     0.362     7.180     0.200
     0.375     7.168     0.200
     0.346     7.129     0.200
     0.385     7.281     0.200
     0.372     7.602     0.200
     0.383     7.750     0.200
     0.395     7.879     0.200
     0.397     8.141     0.200
     0.445     8.488     0.200
     0.448     8.551     0.200
     0.451     8.371     0.200
     0.483     8.859     0.200
     0.452     8.520     0.200
     0.507     9.160     0.200
     0.514     9.820     0.200
     0.562    10.262     0.200
     0.539     9.840     0.200
     0.588    10.738     0.200
     0.548    10.191     0.200
     0.546    10.238     0.200
     0.559    11.129     0.200
     0.553    10.250     0.200
     0.573    10.250     0.200
     0.626    11.168     0.200
     0.590    10.789     0.200
     0.616    11.168     0.200
     0.612    11.340     0.200
     0.639    11.262     0.200
     0.628    11.660     0.200
     0.640    11.969     0.200
     0.638    12.578     0.200
     0.676    11.621     0.200
     0.690    11.719     0.200
     0.665    12.129     0.200
     0.672    12.820     0.200
     0.669    12.320     0.200
     0.687    12.488     0.200
     0.724    12.781     0.200
     0.640    12.109     0.200
     0.705    12.852     0.200
     0.753    12.949     0.200
     0.744    12.898     0.200
     0.742    13.301     0.200
     0.763    13.078     0.200
     0.736    13.340     0.200
     0.730    13.570     0.200
     0.756    13.578     0.200
     0.772    13.852     0.200
     0.774    13.941     0.200
     0.827    13.949     0.200
     0.800    14.418     0.200
     0.826    15.078     0.200
     0.826    15.051     0.200
     0.813    15.051     0.200
     0.854    15.500     0.200
     0.864    15.352     0.200
     0.927    16.051     0.200
     0.932    16.109     0.200
     0.924    16.680     0.200
     0.917    16.590     0.200
     0.917    16.820     0.200
     0.931    16.551     0.200
     0.931    16.578     0.200
     0.930    16.828     0.200
     0.948    17.430     0.200
     0.967    17.230     0.200
     0.996    17.180     0.200
     0.997    17.168     0.200
     1.018    18.770     0.200
     1.067    18.352     0.200
     1.058    19.590     0.200
     1.108    20.570     0.200
     6.030   103.414     0.200
     0.072     1.377     0.200
     0.073     1.348     0.200
     0.139     2.908     0.200
     0.128     2.527     0.200
     0.165     3.148     0.200
     0.175     3.887     0.200
     0.215     3.938     0.200
     0.292     5.918     0.200
     0.297     5.777     0.200
     0.315     6.367     0.200
     0.319     5.828     0.200
     0.324     6.627     0.200
     0.389     7.447     0.200
     0.476     9.408     0.200
     0.476     9.428     0.200
     0.483     9.367     0.200
     0.483     8.818     0.200
     0.494     9.059     0.200
     0.494     9.229     0.200
     0.528     9.668     0.200
     0.502     9.809     0.200
     0.533    10.627     0.200
     0.600    11.188     0.200
     0.595    11.328     0.200
     0.595    11.488     0.200
     0.629    11.398     0.200
     0.622    11.328     0.200
     0.644    11.367     0.200
     0.663    12.508     0.200
     0.733    12.867     0.200
     0.724    12.309     0.200
     0.740    12.748     0.200
     0.760    13.217     0.200
     0.776    13.537     0.200
     0.766    14.027     0.200
     0.795    13.318     0.200
     0.811    13.707     0.200
     0.873    15.438     0.200
     0.881    15.498     0.200
     0.854    16.447     0.200
     0.896    15.838     0.200
     0.896    16.078     0.200
     0.961    17.059     0.200
     0.930    17.857     0.200
     0.969    17.797     0.200
     1.049    18.967     0.200
     1.141    20.809     0.200
     1.147    20.857     0.200
     1.159    21.127     0.200
     0.106     1.699     0.200
     0.107     1.679     0.200
     0.144     2.139     0.200
     0.150     3.009     0.200
     0.182     3.499     0.200
     0.214     4.619     0.200
     0.308     5.499     0.200
     0.332     6.579     0.200
     0.330     6.309     0.200
     0.352     6.769     0.200
     0.345     6.789     0.200
     0.345     7.299     0.200
     0.369     7.219     0.200
     0.441     8.069     0.200
     0.444     8.779     0.200
     0.473     8.659     0.200
     0.491     9.369     0.200
     0.500     9.639     0.200
     0.500     9.659     0.200
     0.514     9.688     0.200
     0.514     9.648     0.200
     0.554    10.549     0.200
     0.547     9.639     0.200
     0.575    10.699     0.200
     0.575    10.549     0.200
     0.602    10.859     0.200
     0.618    11.539     0.200
     0.608    11.648     0.200
     0.608    11.739     0.200
     0.633    11.519     0.200
     0.696    11.759     0.200
     0.701    11.969     0.200
     0.720    12.398     0.200
     0.726    13.779     0.200
     0.744    12.849     0.200
     0.744    12.849     0.200
     0.740    13.479     0.200
     0.787    14.099     0.200
     0.800    13.918     0.200
     0.805    14.769     0.200
     0.832    14.628     0.200
     0.848    14.279     0.200
     0.865    14.688     0.200
     0.902    15.878     0.200
     0.872    15.779     0.200
     0.939    17.179     0.200
     1.031    18.779     0.200
     1.131    20.589     0.200
     1.131    20.449     0.200
     1.145    20.769     0.200
     1.193    21.489     0.200
     1.217    22.389     0.200
     1.257    21.929     0.200
     1.472    26.519     0.200
     1.924    34.819     0.200
     1.936    35.109     0.200
     2.325    41.409     0.200
     2.348    41.659     0.200
     0.040     2.168     0.200
     0.082     2.098     0.200
     0.118     3.168     0.200
     0.142     3.430     0.200
     0.227     4.367     0.200
     0.256     5.059     0.200
     0.242     4.988     0.200
     0.302     6.496     0.200
     0.319     6.566     0.200
     0.345     6.328     0.200
     0.417     7.789     0.200
     0.417     7.836     0.200
     0.446     8.488     0.200
     0.471     9.316     0.200
     0.471     9.348     0.200
     0.469     9.020     0.200
     0.497     9.227     0.200
     0.506     9.109     0.200
     0.520    10.047     0.200
     0.549    10.828     0.200
     0.578    11.098     0.200
     0.599    10.289     0.200
     0.600    10.957     0.200
     0.633    10.898     0.200
     0.640    11.496     0.200
     0.759    13.188     0.200
     0.716    13.406     0.200
     0.751    12.887     0.200
     0.751    12.836     0.200
     0.755    12.906     0.200
     0.762    13.086     0.200
     0.770    14.059     0.200
     0.799    14.418     0.200
     0.799    14.547     0.200
     0.812    14.258     0.200
     0.849    15.039     0.200
     0.898    15.668     0.200
     0.909    16.246     0.200
     0.909    16.469     0.200
     1.005    18.246     0.200
     1.100    19.906     0.200
     1.089    19.668     0.200
     1.187    21.477     0.200
     1.191    21.539     0.200
     1.212    20.637     0.200
     1.336    24.387     0.200
     1.357    24.617     0.200
     1.411    27.020     0.200
     1.615    27.801     0.200
     2.263    38.488     0.200
     0.036     1.996     0.200
     0.073     1.996     0.200
     0.075     1.926     0.200
     0.129     3.416     0.200
     0.151     3.736     0.200
     0.229     4.566     0.200
     0.250     5.086     0.200
     0.278     5.926     0.200
     0.251     5.137     0.200
     0.309     6.516     0.200
     0.313     6.666     0.200
     0.345     6.516     0.200
     0.336     6.316     0.200
     0.348     7.076     0.200
     0.411     7.826     0.200
     0.411     7.816     0.200
     0.449     8.375     0.200
     0.459     8.797     0.200
     0.488     9.217     0.200
     0.497     9.047     0.200
     0.510     9.775     0.200
     0.552    10.967     0.200
     0.589    11.006     0.200
     0.589    11.006     0.200
     0.594    10.336     0.200
     0.588    11.166     0.200
     0.588    11.176     0.200
     0.625    10.955     0.200
     0.629    11.436     0.200
     0.643    11.535     0.200
     0.719    12.686     0.200
     0.717    13.816     0.200
     0.748    12.855     0.200
     0.757    13.365     0.200
     0.761    13.297     0.200
     0.764    13.176     0.200
     0.794    13.855     0.200
     0.791    14.246     0.200
     0.802    13.977     0.200
     0.839    14.766     0.200
     0.887    15.346     0.200
     0.997    18.195     0.200
     1.095    19.945     0.200
     1.456    26.105     0.200
     2.433    42.307     0.200
     2.951    51.227     0.200
     0.052     1.949     0.200
     0.074     2.527     0.200
     0.177     3.887     0.200
     0.229     4.117     0.200
     0.268     5.277     0.200
     0.352     6.207     0.200
     0.350     6.688     0.200
     0.358     6.430     0.200
     0.344     6.449     0.200
     0.318     6.180     0.200
     0.412     7.418     0.200
     0.384     7.906     0.200
     0.420     7.887     0.200
     0.415     8.469     0.200
     0.411     7.848     0.200
     0.446     8.707     0.200
     0.472     8.750     0.200
     0.493     9.520     0.200
     0.507     9.488     0.200
     0.498     9.168     0.200
     0.513     9.879     0.200
     0.503     9.988     0.200
     0.547     9.598     0.200
     0.574    10.348     0.200
     0.539    10.797     0.200
     0.537    10.047     0.200
     0.547    10.047     0.200
     0.602    10.867     0.200
     0.610    11.109     0.200
     0.633    11.559     0.200
     0.650    11.668     0.200
     0.660    12.078     0.200
     0.674    11.598     0.200
     0.652    11.930     0.200
     0.730    13.418     0.200
     0.772    13.930     0.200
     0.727    13.578     0.200
     0.740    13.328     0.200
     0.761    13.617     0.200
     0.776    13.816     0.200
     0.777    13.770     0.200
     0.783    13.977     0.200
     0.830    14.816     0.200
     0.864    15.039     0.200
     0.864    15.398     0.200
     0.816    15.109     0.200
     0.850    15.129     0.200
     0.877    15.539     0.200
     0.883    16.109     0.200
     0.754    16.348     0.200
     0.906    16.906     0.200
     0.944    16.457     0.200
     0.922    16.520     0.200
     0.966    17.859     0.200
     1.005    17.879     0.200
     1.083    19.418     0.200
     1.123    20.578     0.200
     0.098     1.590     0.200
     0.153     2.562     0.200
     0.100     2.410     0.200
     0.154     3.641     0.200
     0.146     3.090     0.200
     0.146     3.191     0.200
     0.222     4.359     0.200
     0.341     6.543     0.200
     0.333     5.812     0.200
     0.356     6.770     0.200
     0.353     6.262     0.200
     0.339     6.742     0.200
     0.337     6.711     0.200
     0.415     7.859     0.200
     0.392     7.621     0.200
     0.407     7.621     0.200
     0.403     7.320     0.200
     0.438     8.320     0.200
     0.396     7.859     0.200
     0.408     7.859     0.200
     0.448     8.090     0.200
     0.497     9.230     0.200
     0.488     9.199     0.200
     0.444     9.242     0.200
     0.503     9.062     0.200
     0.469     8.762     0.200
     0.485     9.262     0.200
     0.485     9.262     0.200
     0.468     8.793     0.200
     0.567     9.832     0.200
     0.595    10.500     0.200
     0.533    10.262     0.200
     0.605    10.820     0.200
     0.555    10.602     0.200
     0.592    10.922     0.200
     0.670    11.480     0.200
     0.697    12.410     0.200
     0.698    12.281     0.200
     0.685    12.621     0.200
     0.721    12.109     0.200
     0.716    12.270     0.200
     0.685    12.973     0.200
     0.720    13.062     0.200
     0.777    13.461     0.200
     0.775    13.980     0.200
     0.752    14.051     0.200
     0.784    14.430     0.200
     0.840    14.941     0.200
     0.904    16.070     0.200
     0.894    16.230     0.200
     0.929    16.422     0.200
     0.941    16.852     0.200
     1.005    18.430     0.200
     1.106    19.000     0.200
     1.170    20.242     0.200
     1.208    20.531     0.200
     1.282    23.531     0.200
     1.294    24.121     0.200
     1.337    23.332     0.200
     1.301    23.070     0.200
     1.356    24.551     0.200
     1.364    24.922     0.200
     1.469    24.922     0.200
     1.458    25.430     0.200
     2.025    34.930     0.200
     0.093     1.703     0.200
     0.072     1.680     0.200
     0.104     2.430     0.200
     0.147     2.641     0.200
     0.107     2.617     0.200
     0.150     3.070     0.200
     0.151     3.141     0.200
     0.214     4.203     0.200
     0.214     4.203     0.200
     0.181     3.758     0.200
     0.220     4.391     0.200
     0.331     5.867     0.200
     0.331     5.891     0.200
     0.336     6.422     0.200
     0.351     6.398     0.200
     0.339     6.430     0.200
     0.410     7.859     0.200
     0.403     7.281     0.200
     0.398     7.820     0.200
     0.389     7.484     0.200
     0.403     7.438     0.200
     0.396     8.062     0.200
     0.451     8.055     0.200
     0.410     8.234     0.200
     0.485     9.414     0.200
     0.470     8.742     0.200
     0.492     9.180     0.200
     0.471     8.781     0.200
     0.498     8.953     0.200
     0.444     9.062     0.200
     0.482     9.109     0.200
     0.482     9.117     0.200
     0.562     9.742     0.200
     0.535    10.102     0.200
     0.602    10.641     0.200
     0.558    10.422     0.200
     0.558    10.273     0.200
     0.556    10.328     0.200
     0.556    10.438     0.200
     0.596    10.742     0.200
     0.681    11.828     0.200
     0.694    12.289     0.200
     0.686    12.461     0.200
     0.667    11.352     0.200
     0.697    12.273     0.200
     0.717    11.984     0.200
     0.711    12.031     0.200
     0.690    12.820     0.200
     0.776    13.508     0.200
     0.776    14.008     0.200
     0.752    13.789     0.200
     0.787    14.383     0.200
     0.758    13.922     0.200
     0.840    15.039     0.200
     0.906    16.102     0.200
     0.897    16.258     0.200
     0.944    17.008     0.200
     1.029    17.891     0.200
     1.010    18.508     0.200
     1.464    26.430     0.200
     0.086     1.957     0.200
     0.122     2.809     0.200
     0.177     3.059     0.200
     0.179     2.877     0.200
     0.149     2.818     0.200
     0.197     3.729     0.200
     0.190     3.688     0.200
     0.229     3.617     0.200
     0.229     3.668     0.200
     0.234     3.787     0.200
     0.220     4.428     0.200
     0.209     4.207     0.200
     0.239     4.818     0.200
     0.209     4.408     0.200
     0.320     6.318     0.200
     0.320     6.318     0.200
     0.330     6.377     0.200
     0.312     5.918     0.200
     0.347     7.037     0.200
     0.371     7.389     0.200
     0.372     7.428     0.200
     0.393     7.287     0.200
     0.399     7.639     0.200
     0.395     7.787     0.200
     0.376     7.758     0.200
     0.455     7.889     0.200
     0.418     7.898     0.200
     0.473     9.088     0.200
     0.494     8.809     0.200
     0.502     9.207     0.200
     0.505     9.258     0.200
     0.512     9.398     0.200
     0.524     9.918     0.200
     0.519     9.648     0.200
     0.561    10.037     0.200
     0.558    10.248     0.200
     0.589    11.229     0.200
     0.607    10.947     0.200
     0.573    11.168     0.200
     0.571    11.127     0.200
     0.638    11.287     0.200
     0.650    11.607     0.200
     0.635    11.588     0.200
     0.650    11.877     0.200
     0.635    11.758     0.200
     0.657    11.928     0.200
     0.662    12.328     0.200
     0.655    11.248     0.200
     0.671    12.777     0.200
     0.705    12.148     0.200
     0.672    12.309     0.200
     0.707    12.518     0.200
     0.702    12.848     0.200
     0.728    12.998     0.200
     0.705    13.467     0.200
     0.705    13.479     0.200
     0.758    13.168     0.200
     0.752    13.678     0.200
     0.752    13.648     0.200
     0.740    13.357     0.200
     0.720    13.438     0.200
     0.733    13.467     0.200
     0.729    13.617     0.200
     0.759    14.088     0.200
     0.759    14.318     0.200
     0.766    13.877     0.200
     0.797    13.797     0.200
     0.802    14.559     0.200
     0.773    14.207     0.200
     0.831    14.309     0.200
     0.781    14.588     0.200
     0.797    14.748     0.200
     0.827    14.928     0.200
     0.824    14.967     0.200
     0.824    14.748     0.200
     0.832    14.828     0.200
     0.899    16.479     0.200
     0.920    16.238     0.200
     0.896    16.148     0.200
     0.928    15.787     0.200
     0.931    17.008     0.200
     0.936    16.617     0.200
     0.980    17.277     0.200
     0.981    17.268     0.200
     0.954    17.338     0.200
     1.007    18.078     0.200
     1.004    18.158     0.200
     1.014    18.537     0.200
     1.013    18.857     0.200
     1.038    18.518     0.200
     1.038    18.748     0.200
     1.016    18.938     0.200
     1.051    18.508     0.200
     1.030    19.447     0.200
     1.084    18.838     0.200
     1.064    18.988     0.200
     1.082    19.389     0.200
     1.102    19.297     0.200
     1.080    20.139     0.200
     1.106    19.277     0.200
     1.120    19.768     0.200
     1.142    19.729     0.200
     1.150    21.127     0.200
     1.150    21.527     0.200
     1.174    20.918     0.200
     1.197    21.498     0.200
     1.215    21.297     0.200
     1.238    21.229     0.200
     1.229    21.547     0.200
     1.255    21.918     0.200
     1.215    22.367     0.200
     6.026   106.699     0.200
     0.169     2.912     0.200
     0.168     2.912     0.200
     0.186     3.182     0.200
     0.253     5.021     0.200
     0.269     5.320     0.200
     0.298     5.691     0.200
     0.290     5.092     0.200
     0.344     6.252     0.200
     0.336     6.461     0.200
     0.336     6.471     0.200
     0.359     7.301     0.200
     0.413     8.021     0.200
     0.414     8.041     0.200
     0.400     7.641     0.200
     0.440     8.631     0.200
     0.441     8.611     0.200
     0.453     8.582     0.200
     0.481     9.031     0.200
     0.497     9.602     0.200
     0.493     9.781     0.200
     0.538    10.311     0.200
     0.538    10.311     0.200
     0.569    10.631     0.200
     0.587    10.781     0.200
     0.585    11.092     0.200
     0.593    10.771     0.200
     0.633    11.301     0.200
     0.633    11.291     0.200
     0.651    11.691     0.200
     0.657    11.992     0.200
     0.664    12.242     0.200
     0.675    12.502     0.200
     0.673    12.230     0.200
     0.731    13.320     0.200
     0.746    12.820     0.200
     0.766    13.012     0.200
     0.753    14.172     0.200
     0.753    14.141     0.200
     0.799    14.701     0.200
     0.790    14.492     0.200
     0.823    14.512     0.200
     0.885    14.992     0.200
     0.882    16.082     0.200
     0.903    15.752     0.200
     0.901    16.320     0.200
     0.972    16.951     0.200
     0.963    17.582     0.200
     0.982    17.900     0.200
     0.986    17.992     0.200
     0.967    16.900     0.200
     0.966    16.961     0.200
     0.992    18.230     0.200
     1.016    17.762     0.200
     1.002    18.051     0.200
     1.002    18.512     0.200
     1.044    18.852     0.200
     1.067    19.561     0.200
     1.098    19.471     0.200
     1.109    20.102     0.200
     1.117    20.191     0.200
     1.173    21.342     0.200
     1.217    22.400     0.200
     1.238    22.301     0.200
     1.256    22.721     0.200
     1.279    23.320     0.200
     1.278    22.881     0.200
     1.375    23.631     0.200
     0.835    15.416     0.200
     0.781    14.406     0.200
     0.453     8.537     0.200
     0.461     8.846     0.200
     0.314     6.188     0.200
     1.024    18.486     0.200
     0.247     5.127     0.200
     0.670    12.516     0.200
     0.178     3.986     0.200
     0.983    17.336     0.200
     0.366     7.547     0.200
     0.771    14.166     0.200
     0.887    15.867     0.200
     0.696    12.377     0.200
     0.430     8.277     0.200
     0.437     8.277     0.200
     0.435     8.287     0.200
     0.194     4.736     0.200
     0.033     2.396     0.200
     0.921    16.256     0.200
     0.630    11.367     0.200
     0.338     6.396     0.200
     1.017    17.736     0.200
     0.499     9.637     0.200
     0.136     3.266     0.200
     0.136     3.377     0.200
     0.795    14.336     0.200
     0.988    17.146     0.200
     0.082     2.027     0.200
     0.241     4.557     0.200
     0.262     4.938     0.200
     0.627    11.357     0.200
     0.524     9.967     0.200
     0.524     9.977     0.200
     1.147    19.797     0.200
     0.718    12.867     0.200
     0.884    15.496     0.200
     0.452     8.926     0.200
     1.143    19.486     0.200
     0.632    11.416     0.200
     0.215     4.406     0.200
     0.253     5.146     0.200
     0.423     8.236     0.200
     0.386     7.707     0.200
     0.613    10.857     0.200
     0.284     5.486     0.200
     0.509     9.297     0.200
     0.316     6.316     0.200
     0.336     6.736     0.200
     0.398     7.607     0.200
     0.693    12.066     0.200
     0.509     9.527     0.200
     0.393     7.336     0.200
     0.399     7.377     0.200
     0.597    10.717     0.200
     0.983    16.797     0.200
     0.493     8.896     0.200
     0.546     9.447     0.200
     0.580    10.166     0.200
     0.678    11.586     0.200
     0.617    10.646     0.200
     0.692    11.906     0.200
     0.027     2.205     0.200
     0.149     3.705     0.200
     0.223     4.385     0.200
     0.180     4.445     0.200
     0.176     3.875     0.200
     0.264     5.174     0.200
     0.254     4.664     0.200
     0.254     4.605     0.200
     0.285     5.436     0.200
     0.276     5.064     0.200
     0.236     4.875     0.200
     0.325     6.346     0.200
     0.347     6.846     0.200
     0.318     6.125     0.200
     0.318     6.234     0.200
     0.349     6.436     0.200
     0.404     7.414     0.200
     0.410     7.475     0.200
     0.392     7.395     0.200
     0.374     7.525     0.200
     0.413     8.074     0.200
     0.439     8.295     0.200
     0.421     8.016     0.200
     0.423     8.016     0.200
     0.440     8.705     0.200
     0.504     8.936     0.200
     0.457     8.455     0.200
     0.466     8.834     0.200
     0.499     9.605     0.200
     0.522     9.484     0.200
     0.542     9.314     0.200
     0.511    10.154     0.200
     0.511     9.775     0.200
     0.592    10.664     0.200
     0.611    10.924     0.200
     0.629    10.625     0.200
     0.626    10.965     0.200
     0.619    11.346     0.200
     0.638    11.564     0.200
     0.616    11.424     0.200
     0.632    11.814     0.200
     0.671    11.516     0.200
     0.689    11.754     0.200
     0.676    12.504     0.200
     0.706    12.145     0.200
     0.683    12.164     0.200
     0.750    13.035     0.200
     0.729    12.975     0.200
     0.785    13.715     0.200
     0.777    14.145     0.200
     0.772    14.174     0.200
     0.800    14.254     0.200
     0.804    14.445     0.200
     0.839    15.234     0.200
     0.799    14.555     0.200
     0.885    15.355     0.200
     0.829    15.234     0.200
     0.894    15.535     0.200
     0.935    16.455     0.200
     0.912    15.766     0.200
     0.893    16.045     0.200
     0.893    15.875     0.200
     0.969    17.074     0.200
     0.969    17.244     0.200
     0.928    16.305     0.200
     0.928    16.805     0.200
     0.996    17.266     0.200
     1.046    18.145     0.200
     1.027    18.516     0.200
     1.109    19.936     0.200
     1.170    20.234     0.200
     1.274    22.096     0.200
     1.314    22.654     0.200
     1.426    24.414     0.200
     1.416    25.025     0.200
     1.525    26.045     0.200
     1.779    29.686     0.200
     0.150     3.453     0.200
     0.226     4.484     0.200
     0.178     4.494     0.200
     0.174     3.934     0.200
     0.267     5.283     0.200
     0.267     5.273     0.200
     0.255     4.715     0.200
     0.255     4.715     0.200
     0.287     5.453     0.200
     0.277     5.123     0.200
     0.233     4.943     0.200
     0.328     6.404     0.200
     0.349     6.924     0.200
     0.316     6.174     0.200
     0.349     6.574     0.200
     0.394     7.504     0.200
     0.407     7.545     0.200
     0.413     7.594     0.200
     0.402     7.953     0.200
     0.373     7.645     0.200
     0.414     8.123     0.200
     0.440     8.783     0.200
     0.421     8.084     0.200
     0.419     8.084     0.200
     0.438     8.404     0.200
     0.507     9.045     0.200
     0.500     9.424     0.200
     0.455     8.504     0.200
     0.464     8.863     0.200
     0.484     9.475     0.200
     0.524     9.564     0.200
     0.544     9.395     0.200
     0.510     9.795     0.200
     0.510     9.814     0.200
     0.595    10.965     0.200
     0.606    10.953     0.200
     0.613    10.953     0.200
     0.632    10.645     0.200
     0.627    11.045     0.200
     0.618    11.215     0.200
     0.614    11.174     0.200
     0.638    11.635     0.200
     0.630    11.314     0.200
     0.672    11.555     0.200
     0.691    11.824     0.200
     0.707    12.215     0.200
     0.675    12.584     0.200
     0.681    12.193     0.200
     0.729    13.033     0.200
     0.786    13.844     0.200
     0.776    14.283     0.200
     0.769    14.244     0.200
     0.841    14.824     0.200
     0.803    14.494     0.200
     0.826    15.254     0.200
     0.936    16.215     0.200
     0.894    15.645     0.200
     0.912    15.844     0.200
     0.892    15.984     0.200
     0.972    16.965     0.200
     0.972    17.234     0.200
     0.927    16.453     0.200
     0.994    17.324     0.200
     1.023    17.885     0.200
     1.024    18.574     0.200
     1.074    18.264     0.200
     1.110    19.834     0.200
     1.151    19.645     0.200
     1.255    21.604     0.200
     1.268    21.994     0.200
     1.315    22.523     0.200
     1.325    22.363     0.200
     0.051     1.323     0.200
     0.053     1.283     0.200
     0.059     1.292     0.200
     0.145     2.903     0.200
     0.145     2.903     0.200
     0.143     3.223     0.200
     0.175     3.933     0.200
     0.265     5.283     0.200
     0.257     4.913     0.200
     0.246     4.703     0.200
     0.294     6.062     0.200
     0.312     5.703     0.200
     0.356     6.772     0.200
     0.333     6.823     0.200
     0.426     8.062     0.200
     0.426     8.062     0.200
     0.451     9.083     0.200
     0.451     9.113     0.200
     0.465     9.073     0.200
     0.474     8.633     0.200
     0.477     8.732     0.200
     0.477     8.863     0.200
     0.495     9.303     0.200
     0.489     9.473     0.200
     0.502     9.643     0.200
     0.531    10.393     0.200
     0.577    10.933     0.200
     0.577    10.883     0.200
     0.613    10.603     0.200
     0.612    11.192     0.200
     0.612    11.002     0.200
     0.619    11.083     0.200
     0.619    11.203     0.200
     0.607    11.653     0.200
     0.607    11.653     0.200
     0.636    11.042     0.200
     0.709    12.093     0.200
     0.693    13.263     0.200
     0.723    12.442     0.200
     0.723    12.453     0.200
     0.737    13.663     0.200
     0.744    13.022     0.200
     0.750    13.232     0.200
     0.762    12.973     0.200
     0.765    13.993     0.200
     0.785    13.792     0.200
     0.782    13.723     0.200
     0.791    13.533     0.200
     0.816    14.513     0.200
     0.873    15.223     0.200
     0.971    17.772     0.200
     1.189    21.192     0.200
     1.197    21.603     0.200
     1.229    21.453     0.200
     1.266    22.692     0.200
     1.299    23.562     0.200
     1.302    23.792     0.200
     1.343    23.333     0.200
     0.048     1.625     0.200
     0.049     1.516     0.200
     0.048     1.648     0.200
     0.132     2.625     0.200
     0.132     2.711     0.200
     0.152     3.609     0.200
     0.152     3.711     0.200
     0.177     4.078     0.200
     0.247     5.016     0.200
     0.247     4.789     0.200
     0.247     4.914     0.200
     0.310     5.773     0.200
     0.310     5.648     0.200
     0.338     6.258     0.200
     0.263     5.273     0.200
     0.338     7.023     0.200
     0.409     7.594     0.200
     0.409     7.766     0.200
     0.439     8.711     0.200
     0.456     8.945     0.200
     0.471     8.547     0.200
     0.471     8.680     0.200
     0.481     9.305     0.200
     0.478     9.070     0.200
     0.489     9.508     0.200
     0.468     8.930     0.200
     0.468     8.828     0.200
     0.566    10.859     0.200
     0.566    10.898     0.200
     0.604    11.016     0.200
     0.547    10.898     0.200
     0.596    10.305     0.200
     0.619    10.711     0.200
     0.618    11.055     0.200
     0.618    11.164     0.200
     0.697    12.617     0.200
     0.613    11.859     0.200
     0.613    11.844     0.200
     0.715    12.578     0.200
     0.715    12.320     0.200
     0.727    12.430     0.200
     0.735    13.688     0.200
     0.745    13.008     0.200
     0.745    12.758     0.200
     0.707    13.688     0.200
     0.773    13.609     0.200
     0.777    13.688     0.200
     0.766    13.930     0.200
     0.814    14.523     0.200
     0.781    13.484     0.200
     0.863    15.117     0.200
     0.973    17.789     0.200
     0.938    16.695     0.200
     1.197    21.289     0.200
     1.203    20.867     0.200
     1.231    21.625     0.200
     1.303    22.211     0.200
     1.347    23.766     0.200
     1.359    23.664     0.200
     0.041     1.312     0.200
     0.043     1.320     0.200
     0.060     1.102     0.200
     0.060     1.242     0.200
     0.144     2.844     0.200
     0.144     2.930     0.200
     0.154     3.391     0.200
     0.258     5.125     0.200
     0.184     4.070     0.200
     0.259     4.984     0.200
     0.303     5.656     0.200
     0.257     4.984     0.200
     0.420     7.930     0.200
     0.420     7.883     0.200
     0.343     7.023     0.200
     0.439     8.781     0.200
     0.465     8.492     0.200
     0.486     9.242     0.200
     0.486     9.031     0.200
     0.490     9.461     0.200
     0.479     9.125     0.200
     0.566    10.664     0.200
     0.601    10.914     0.200
     0.608    10.375     0.200
     0.536    10.555     0.200
     0.628    10.734     0.200
     0.610    11.031     0.200
     0.617    11.836     0.200
     0.618    11.805     0.200
     0.712    12.227     0.200
     0.738    13.086     0.200
     0.728    13.500     0.200
     0.755    12.844     0.200
     0.774    13.523     0.200
     0.695    13.586     0.200
     0.772    13.562     0.200
     0.757    13.781     0.200
     0.807    14.375     0.200
     0.793    13.344     0.200
     0.861    14.977     0.200
     0.935    16.320     0.200
     0.935    16.344     0.200
     1.185    21.055     0.200
     1.192    20.734     0.200
     1.222    21.664     0.200
     1.336    23.586     0.200
     1.884    31.484     0.200
     0.152     3.477     0.200
     0.062     1.227     0.200
     0.042     1.289     0.200
     0.044     1.188     0.200
     0.183     4.078     0.200
     0.253     4.953     0.200
     0.147     2.961     0.200
     0.147     2.992     0.200
     0.261     5.094     0.200
     0.342     6.969     0.200
     0.262     5.141     0.200
     0.303     5.617     0.200
     0.352     6.977     0.200
     0.532    10.508     0.200
     0.481     8.812     0.200
     0.424     7.891     0.200
     0.424     7.930     0.200
     0.466     8.531     0.200
     0.442     8.828     0.200
     0.456     8.992     0.200
     0.483     9.297     0.200
     0.489     9.188     0.200
     0.493     9.453     0.200
     0.568    10.930     0.200
     0.568    10.828     0.200
     0.610    11.102     0.200
     0.610    10.961     0.200
     0.611    10.367     0.200
     0.603    10.906     0.200
     0.632    10.797     0.200
     0.729    13.648     0.200
     0.700    12.438     0.200
     0.714    12.406     0.200
     0.714    12.461     0.200
     0.757    13.938     0.200
     0.795    13.492     0.200
     0.741    13.070     0.200
     0.759    13.031     0.200
     0.773    13.609     0.200
     0.932    16.352     0.200
     0.932    16.430     0.200
     0.777    13.867     0.200
     0.807    14.344     0.200
     0.864    15.383     0.200
     0.964    17.648     0.200
     1.184    21.141     0.200
     1.191    20.797     0.200
     1.221    21.242     0.200
     1.349    23.477     0.200
     1.880    31.469     0.200
     0.035     1.909     0.200
     0.056     1.859     0.200
     0.057     1.829     0.200
     0.117     2.589     0.200
     0.117     2.599     0.200
     0.156     3.899     0.200
     0.173     4.129     0.200
     0.232     4.779     0.200
     0.234     4.689     0.200
     0.275     5.459     0.200
     0.316     5.959     0.200
     0.324     6.199     0.200
     0.337     7.199     0.200
     0.394     7.619     0.200
     0.394     7.539     0.200
     0.433     8.889     0.200
     0.433     8.929     0.200
     0.456     9.409     0.200
     0.465     8.829     0.200
     0.454     8.539     0.200
     0.476     8.719     0.200
     0.482     9.389     0.200
     0.480     9.349     0.200
     0.562    10.589     0.200
     0.562    10.839     0.200
     0.580    10.129     0.200
     0.564    11.089     0.200
     0.604    11.039     0.200
     0.604    11.239     0.200
     0.604    10.619     0.200
     0.625    11.059     0.200
     0.625    11.199     0.200
     0.613    11.799     0.200
     0.613    11.819     0.200
     0.692    12.319     0.200
     0.715    12.419     0.200
     0.715    12.179     0.200
     0.730    12.949     0.200
     0.730    11.959     0.200
     0.730    12.569     0.200
     0.735    12.599     0.200
     0.741    13.909     0.200
     0.723    13.889     0.200
     0.767    13.449     0.200
     0.779    13.629     0.200
     0.774    14.109     0.200
     0.766    12.729     0.200
     0.819    14.509     0.200
     0.838    14.629     0.200
     0.861    15.039     0.200
     0.947    16.479     0.200
     0.947    16.520     0.200
     0.982    18.049     0.200
     1.115    20.029     0.200
     1.209    21.279     0.200
     1.214    21.439     0.200
     1.313    22.369     0.200
     1.363    23.819     0.200
     0.024     2.551     0.200
     0.108     2.529     0.200
     0.082     2.590     0.200
     0.144     3.631     0.200
     0.217     4.420     0.200
     0.240     4.980     0.200
     0.258     5.420     0.200
     0.312     6.660     0.200
     0.336     6.471     0.200
     0.308     6.570     0.200
     0.344     6.529     0.200
     0.401     7.699     0.200
     0.401     7.721     0.200
     0.436     8.189     0.200
     0.461     9.199     0.200
     0.461     9.340     0.200
     0.481     9.051     0.200
     0.486     9.660     0.200
     0.509     9.641     0.200
     0.510     9.920     0.200
     0.505     9.221     0.200
     0.583    10.131     0.200
     0.591    11.080     0.200
     0.591    11.070     0.200
     0.617    10.750     0.200
     0.583    11.119     0.200
     0.564    11.381     0.200
     0.634    11.461     0.200
     0.652    11.830     0.200
     0.720    12.680     0.200
     0.720    12.609     0.200
     0.739    12.590     0.200
     0.751    13.080     0.200
     0.744    12.580     0.200
     0.744    12.580     0.200
     0.761    13.020     0.200
     0.769    13.961     0.200
     0.801    14.330     0.200
     0.848    14.811     0.200
     0.923    16.490     0.200
     0.923    16.170     0.200
     1.236    21.480     0.200
     1.601    27.000     0.200
     0.010     1.840     0.200
     0.010     2.863     0.200
     0.085     2.223     0.200
     0.097     2.891     0.200
     0.137     3.633     0.200
     0.196     4.113     0.200
     0.222     4.723     0.200
     0.275     5.812     0.200
     0.304     6.660     0.200
     0.315     6.793     0.200
     0.357     6.773     0.200
     0.416     8.121     0.200
     0.467     8.922     0.200
     0.459     9.383     0.200
     0.506     9.680     0.200
     0.515     9.441     0.200
     0.579    11.262     0.200
     0.590    11.062     0.200
     0.587    11.703     0.200
     0.639    11.500     0.200
     0.665    11.941     0.200
     0.717    12.621     0.200
     0.932    16.262     0.200
     0.932    16.121     0.200
     1.255    21.492     0.200
     1.604    27.551     0.200
     3.731    62.840     0.200
     6.531   117.176     0.200
     0.147     3.160     0.200
     0.148     3.152     0.200
     0.201     4.434     0.200
     0.271     5.941     0.200
     0.288     6.094     0.200
     0.288     6.102     0.200
     0.290     5.543     0.200
     0.389     8.113     0.200
     0.390     8.070     0.200
     0.340     6.953     0.200
     0.391     7.660     0.200
     0.403     7.820     0.200
     0.451     8.402     0.200
     0.513     9.852     0.200
     0.564    10.473     0.200
     0.569    10.320     0.200
     0.569    10.672     0.200
     0.607    11.242     0.200
     0.644    12.281     0.200
     0.644    12.293     0.200
     0.614    11.043     0.200
     0.623    11.422     0.200
     0.623    11.672     0.200
     0.623    11.641     0.200
     0.655    11.023     0.200
     0.701    12.832     0.200
     0.735    12.691     0.200
     0.735    12.672     0.200
     0.755    12.742     0.200
     0.753    13.492     0.200
     0.764    12.910     0.200
     0.765    13.473     0.200
     0.774    14.211     0.200
     0.869    15.363     0.200
     0.894    16.441     0.200
     0.897    15.594     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.720    24.689     0.200
     0.760    24.260     0.200
     0.733    24.550     0.200
     0.713    23.527     0.200
     0.716    24.195     0.200
     0.765    25.930     0.200
     8.379   215.500     0.200
     0.755    25.105     0.200
     0.734    23.906     0.200
     0.734    24.543     0.200
     0.734    24.984     0.200
     0.759    24.668     0.200
     0.987    29.500     0.200
     0.987    30.234     0.200
     1.090    32.652     0.200
     1.126    30.527     0.200
     2.114    60.641     0.200
     2.125    61.211     0.200
     2.145    61.988     0.200
     2.897    79.812     0.200
     2.977    82.094     0.200
     3.525    94.840     0.200
     9.092   232.000     0.200
     0.957    29.914     0.200
     0.964    29.477     0.200
     1.257    35.234     0.200
     2.143    62.133     0.200
     2.180    63.305     0.200
     2.594    72.547     0.200
     3.024    84.266     0.200
     3.534    98.016     0.200
     4.674   126.094     0.200
     0.671    22.141     0.200
     0.999    30.031     0.200
     0.999    30.672     0.200
     1.121    30.750     0.200
     1.121    32.672     0.200
     2.986    82.023     0.200
     5.335   140.133     0.200
     6.419   169.422     0.200
     7.627   197.281     0.200
     7.678   197.102     0.200
     7.666   198.914     0.200
     7.825   202.805     0.200
     8.004   208.344     0.200
     9.084   233.617     0.200
     0.696    22.172     0.200
     1.206    35.441     0.200
     1.505    42.684     0.200
     1.505    41.883     0.200
     2.438    64.969     0.200
     2.652    73.311     0.200
     3.321    87.855     0.200
     3.551    93.762     0.200
     3.962   104.301     0.200
     4.180   108.498     0.200
     7.503   188.701     0.200
     9.414   238.902     0.200
    19.368   481.441     0.200
     0.455    17.141     0.200
     0.701    22.375     0.200
     1.344    39.664     0.200
     1.514    42.820     0.200
     2.100    57.500     0.200
     2.174    60.664     0.200
     6.602   169.281     0.200
    10.021   252.664     0.200
    15.798   397.977     0.200
    17.741   444.000     0.200
     0.475    16.852     0.200
     0.742    25.078     0.200
     1.197    34.102     0.200
     1.491    42.016     0.200
     2.884    81.055     0.200
     2.939    82.672     0.200
     3.618    99.398     0.200
     4.126   110.789     0.200
     4.482   119.891     0.200
     6.932   181.031     0.200
     0.729    24.276     0.200
     1.361    40.220     0.200
     2.207    61.755     0.200
     0.475    16.270     0.200
     0.683    22.082     0.200
     0.743    24.180     0.200
     1.492    42.555     0.200
     2.190    59.957     0.200
     0.473    16.449     0.200
     0.679    21.754     0.200
     0.737    24.172     0.200
     1.491    42.055     0.200
     1.555    45.488     0.200
     0.463    15.832     0.200
     0.463    16.713     0.200
     0.665    21.482     0.200
     0.697    22.152     0.200
     0.744    24.363     0.200
     1.170    34.213     0.200
     1.210    34.521     0.200
     1.508    42.471     0.200
     1.508    42.312     0.200
     1.711    48.057     0.200
     3.575    99.742     0.200
     0.461    16.436     0.200
     0.461    17.386     0.200
     0.737    24.646     0.200
     1.506    43.049     0.200
     1.569    45.760     0.200
     0.645    20.961     0.200
     0.732    21.961     0.200
     0.732    22.398     0.200
     2.881    81.172     0.200
     3.091    85.648     0.200
     3.613    99.273     0.200
     3.853   104.375     0.200
     4.489   119.250     0.200
     5.542   146.672     0.200
     6.569   170.273     0.200
     6.622   172.969     0.200
     6.931   180.570     0.200
     7.121   184.820     0.200
     7.602   196.305     0.200
     7.912   203.281     0.200
     7.915   204.773     0.200
     7.933   205.203     0.200
     8.114   207.664     0.200
     8.592   222.375     0.200
     8.653   223.125     0.200
     9.132   236.992     0.200
     9.199   238.469     0.200
     9.629   248.172     0.200
     9.963   257.773     0.200
    10.742   274.391     0.200
    10.823   278.578     0.200
    11.447   290.266     0.200
    11.565   293.633     0.200
    11.632   295.648     0.200
    11.743   298.711     0.200
    11.837   299.898     0.200
    11.932   304.703     0.200
    12.473   316.914     0.200
    12.482   320.039     0.200
    12.504   318.648     0.200
    12.661   319.953     0.200
    12.768   321.469     0.200
    13.062   333.883     0.200
    13.406   334.672     0.200
    13.497   341.664     0.200
    13.533   341.172     0.200
    14.287   359.883     0.200
    14.395   361.789     0.200
    14.623   368.570     0.200
    14.835   373.328     0.200
    15.070   378.445     0.200
    16.116   404.461     0.200
    16.567   415.625     0.200
    16.872   422.070     0.200
    18.499   460.828     0.200
     0.626    19.803     0.200
     0.648    20.479     0.200
     0.674    21.749     0.200
     0.739    21.966     0.200
     0.739    22.234     0.200
     1.147    32.975     0.200
     1.204    35.176     0.200
     1.490    42.354     0.200
     8.278   209.955     0.200
     0.711    22.938     0.200
    15.880   396.031     0.200
     0.405    14.359     0.200
     0.744    22.078     0.200
     1.269    36.547     0.200
     0.586    22.019     0.200
     0.788    25.419     0.200
     0.935    28.389     0.200
     8.480   216.358     0.200
     0.724    24.883     0.200
     0.728    25.094     0.200
     0.732    23.508     0.200
     1.293    37.102     0.200
     8.416   215.555     0.200
     0.668    21.664     0.200
     0.676    22.164     0.200
     0.795    23.812     0.200
     1.253    35.562     0.200
     1.403    39.500     0.200
     1.514    42.219     0.200
     1.649    46.859     0.200
     2.846    77.828     0.200
     0.708    22.682     0.200
     0.773    23.410     0.200
     1.332    38.051     0.200
     7.608   194.852     0.200
     7.633   197.160     0.200
     9.438   240.111     0.200
     9.819   250.582     0.200
    10.662   269.422     0.200
     0.755    23.532     0.200
     0.708    23.596     0.200
     0.776    24.767     0.200
     1.333    39.505     0.200
     2.734    74.235     0.200
     7.788   199.166     0.200
    10.408   265.726     0.200
     0.825    26.699     0.200
     0.876    28.449     0.200
     0.977    30.371     0.200
     0.984    30.117     0.200
     1.200    35.648     0.200
     1.200    34.473     0.200
     3.541    99.500     0.200
    10.735   271.629     0.200
     0.716    22.547     0.200
     0.707    23.047     0.200
     0.707    23.617     0.200
     0.744    23.953     0.200
     1.342    38.875     0.200
     1.580    45.547     0.200
     3.018    85.266     0.200
     5.689   147.539     0.200
     9.968   249.969     0.200
     0.713    22.805     0.200
     0.702    23.105     0.200
     0.751    23.715     0.200
     1.302    36.564     0.200
     1.347    39.313     0.200
     1.593    45.575     0.200
     3.029    82.895     0.200
     3.811   100.535     0.200
     5.002   132.145     0.200
     5.674   148.375     0.200
     6.559   168.625     0.200
     9.960   253.735     0.200
    10.431   268.285     0.200
    10.431   268.285     0.200
     0.573    18.932     0.200
     0.601    19.410     0.200
     0.743    23.781     0.200
     0.762    24.361     0.200
     0.960    29.000     0.200
     0.458    17.336     0.200
     0.758    24.266     0.200
     0.998    28.828     0.200
     1.164    34.383     0.200
     1.624    47.680     0.200
     2.463    70.602     0.200
     2.463    70.602     0.200
     5.433   142.461     0.200
     6.092   158.844     0.200
     6.937   180.227     0.200
     0.606    22.193     0.200
     0.799    25.424     0.200
     0.862    27.254     0.200
     1.011    30.143     0.200
     1.057    31.805     0.200
     1.091    33.170     0.200
     1.742    49.570     0.200
     2.282    66.225     0.200
     7.095   183.535     0.200
     0.418    14.371     0.200
     1.209    35.084     0.200
     1.649    46.422     0.200
     0.976    29.133     0.200
     1.118    32.516     0.200
     1.118    32.516     0.200
     1.661    47.891     0.200
     5.008   131.820     0.200
     5.717   150.062     0.200
     6.519   170.141     0.200
     9.362   240.945     0.200
     9.946   255.758     0.200
    12.052   306.461     0.200
     0.741    23.625     0.200
     0.741    25.297     0.200
     0.741    26.625     0.200
     0.829    26.680     0.200
     0.399    14.467     0.200
     0.759    23.852     0.200
     1.261    36.873     0.200
     1.356    40.027     0.200
     4.959   129.887     0.200
     6.261   164.947     0.200
     0.734    25.031     0.200
     0.841    26.609     0.200
     3.818   102.742     0.200
     0.734    25.619     0.200
     0.840    26.309     0.200
     0.856    26.598     0.200
     1.375    39.838     0.200
     1.643    46.480     0.200
     3.818   101.439     0.200
     4.962   131.389     0.200
     6.546   169.729     0.200
     0.719    24.184     0.200
     1.326    39.164     0.200
     2.719    73.113     0.200
     2.262    66.172     0.200
     2.403    68.703     0.200
     2.522    71.656     0.200
     0.611    21.453     0.200
     0.796    25.672     0.200
     0.876    28.602     0.200
     1.232    35.461     0.200
     1.386    40.914     0.200
     1.614    46.633     0.200
     1.646    48.625     0.200
     2.076    59.578     0.200
     2.133    61.000     0.200
     3.075    85.469     0.200
     4.953   133.344     0.200
     5.602   148.859     0.200
     6.360   166.703     0.200
     6.577   168.859     0.200
     7.890   203.297     0.200
    11.144   286.500     0.200
    13.717   349.977     0.200
    15.123   377.102     0.200
    17.481   438.656     0.200
    17.512   438.461     0.200
     0.880    28.406     0.200
     1.473    42.016     0.200
     4.005   107.422     0.200
     3.924   107.422     0.200
     5.108   133.516     0.200
     5.559   143.227     0.200
     6.339   162.195     0.200
     1.246    37.562     0.200
     1.341    39.305     0.200
     1.758    51.469     0.200
     2.239    65.703     0.200
     2.911    83.281     0.200
    16.322   410.250     0.200
     0.932    28.430     0.200
     0.932    27.055     0.200
     1.406    40.406     0.200
     2.584    70.984     0.200
     2.619    71.344     0.200
     0.754    24.500     0.200
     0.754    24.016     0.200
     0.903    27.711     0.200
     0.903    27.531     0.200
     1.376    39.391     0.200
     1.449    41.258     0.200
     1.795    50.094     0.200
     2.512    67.555     0.200
     2.762    75.859     0.200
     2.921    79.070     0.200
     3.078    81.453     0.200
     0.882    26.141     0.200
     1.164    28.703     0.200
     1.557    44.227     0.200
     2.394    66.000     0.200
     2.466    65.875     0.200
     0.933    28.346     0.200
     1.123    32.986     0.200
     1.748    47.758     0.200
     2.211    58.499     0.200
     2.261    60.736     0.200
     2.463    69.706     0.200
     2.808    76.628     0.200
     2.842    75.612     0.200
     0.497    17.653     0.200
     0.539    18.033     0.200
     0.711    22.613     0.200
     0.871    25.158     0.200
     1.433    40.253     0.200
     2.299    63.526     0.200
     2.757    76.553     0.200
     5.047   132.654     0.200
     5.470   142.827     0.200
     6.422   162.827     0.200
     0.910    26.669     0.200
     0.910    27.097     0.200
     1.357    37.988     0.200
     1.482    42.124     0.200
     1.573    44.732     0.200
     1.573    44.043     0.200
     1.573    43.847     0.200
     2.557    67.778     0.200
     0.938    27.533     0.200
     0.975    27.500     0.200
     0.975    28.765     0.200
     1.255    36.852     0.200
     1.392    39.733     0.200
     1.526    42.660     0.200
     1.797    49.476     0.200
     2.065    56.040     0.200
     3.775    98.401     0.200
     4.431   115.801     0.200
     5.026   129.869     0.200
     6.902   174.121     0.200
     0.927    27.347     0.200
     1.220    36.179     0.200
     1.367    39.178     0.200
     0.498    18.994     0.200
     0.816    26.174     0.200
     1.101    31.995     0.200
     1.188    34.754     0.200
     1.556    45.113     0.200
     1.653    47.462     0.200
     1.684    47.982     0.200
     2.582    75.284     0.200
     8.837   228.484     0.200
     0.900    27.536     0.200
     1.168    33.727     0.200
     1.315    38.176     0.200
     1.315    38.007     0.200
     1.315    37.846     0.200
     1.535    43.062     0.200
     1.596    45.190     0.200
     1.717    49.345     0.200
     2.448    66.376     0.200
     6.627   170.656     0.200
     0.805    26.028     0.200
     1.068    31.037     0.200
     1.139    33.658     0.200
     1.387    40.161     0.200
     1.544    44.221     0.200
     1.707    48.550     0.200
     1.893    53.692     0.200
     2.168    59.043     0.200
     2.250    61.272     0.200
     0.930    27.767     0.200
     1.401    40.315     0.200
     1.455    41.832     0.200
     1.671    46.965     0.200
     1.718    48.848     0.200
     0.857    26.558     0.200
     1.378    41.241     0.200
     1.395    39.618     0.200
     1.395    39.445     0.200
     1.551    43.997     0.200
     0.557    18.379     0.200
     1.043    30.215     0.200
     1.043    31.598     0.200
     1.094    32.248     0.200
     1.338    38.816     0.200
     1.650    46.039     0.200
     1.935    54.895     0.200
     1.956    54.301     0.200
     2.242    61.500     0.200
     2.402    64.852     0.200
     0.783    25.121     0.200
     0.806    25.352     0.200
     0.911    27.320     0.200
     0.911    27.891     0.200
     1.065    31.111     0.200
     1.136    33.545     0.200
     1.136    32.955     0.200
     1.384    39.334     0.200
     1.542    43.873     0.200
     1.707    48.158     0.200
     2.157    59.307     0.200
     2.348    64.307     0.200
     2.354    65.729     0.200
     2.604    68.971     0.200
     2.802    78.711     0.200
     3.155    88.301     0.200
     5.300   140.590     0.200
     6.753   174.621     0.200
     7.620   198.980     0.200
     0.861    26.746     0.200
     1.357    38.428     0.200
     1.416    42.195     0.200
     1.610    45.566     0.200
     2.179    60.656     0.200
     3.024    84.406     0.200
     5.458   142.086     0.200
     7.182   185.207     0.200
     7.568   195.336     0.200
     7.750   199.326     0.200
     0.905    27.613     0.200
     0.906    27.375     0.200
     1.026    30.781     0.200
     1.089    31.875     0.200
     1.089    31.703     0.200
     1.338    38.984     0.200
     1.492    43.164     0.200
     1.521    43.691     0.200
     1.720    48.648     0.200
     1.843    52.562     0.200
     2.113    58.234     0.200
     2.141    58.434     0.200
     2.331    65.633     0.200
     2.663    72.613     0.200
     0.819    26.523     0.200
     0.819    26.016     0.200
     1.054    31.117     0.200
     1.134    33.926     0.200
     1.134    33.633     0.200
     1.134    33.516     0.200
     1.378    40.707     0.200
     1.529    44.328     0.200
     1.696    49.145     0.200
     1.888    54.473     0.200
     2.149    60.184     0.200
     2.241    62.211     0.200
     2.363    68.547     0.200
     0.802    25.305     0.200
     0.802    27.402     0.200
     0.945    28.191     0.200
     1.399    40.055     0.200
     2.100    58.512     0.200
     2.285    63.953     0.200
     0.865    27.107     0.200
     0.962    28.322     0.200
     1.372    39.701     0.200
     1.346    39.067     0.200
     1.522    42.954     0.200
    10.321   264.234     0.200
     0.394    13.907     0.200
     0.587    19.248     0.200
     0.721    23.728     0.200
     1.017    29.518     0.200
     1.017    29.887     0.200
     1.337    38.393     0.200
     1.618    45.262     0.200
     1.954    54.354     0.200
     1.921    52.487     0.200
     2.239    61.163     0.200
     2.380    64.985     0.200
     3.284    92.107     0.200
     3.869   100.687     0.200
     4.643   123.348     0.200
     5.422   140.657     0.200
    10.217   261.853     0.200
     0.698    22.246     0.200
     0.698    23.576     0.200
     1.361    39.163     0.200
     1.618    45.603     0.200
     1.618    45.116     0.200
     5.698   148.106     0.200
     0.744    23.939     0.200
     0.817    26.109     0.200
     1.089    31.746     0.200
     1.175    34.229     0.200
     1.175    34.373     0.200
     1.268    38.159     0.200
     1.419    40.086     0.200
     1.687    47.947     0.200
     2.574    69.483     0.200
     3.194    90.810     0.200
     4.212   108.779     0.200
    10.873   278.302     0.200
     0.811    25.895     0.200
     0.811    26.004     0.200
     0.802    27.262     0.200
     1.046    30.590     0.200
     1.116    33.387     0.200
     1.116    33.805     0.200
     1.136    34.367     0.200
     1.363    39.969     0.200
     1.529    44.930     0.200
     1.709    49.047     0.200
     2.152    59.316     0.200
     2.331    63.488     0.200
     2.517    70.895     0.200
     3.139    85.965     0.200
     4.650   126.965     0.200
     8.099   205.672     0.200
     9.633   247.762     0.200
    10.972   274.941     0.200
     0.765    25.617     0.200
     0.940    27.777     0.200
     1.420    40.836     0.200
     0.586    19.473     0.200
     0.744    24.793     0.200
     1.012    30.562     0.200
     1.317    38.945     0.200
     1.367    39.781     0.200
     1.622    45.418     0.200
     1.750    51.035     0.200
     1.930    54.500     0.200
     1.935    53.883     0.200
     1.935    54.895     0.200
     2.219    61.227     0.200
     3.650    96.961     0.200
     0.491    18.875     0.200
     0.698    22.906     0.200
     0.741    23.602     0.200
     0.840    27.000     0.200
     1.073    31.648     0.200
     1.176    34.656     0.200
     1.176    34.859     0.200
     1.410    40.930     0.200
     1.527    43.930     0.200
     1.570    43.156     0.200
     1.580    45.812     0.200
     1.664    47.516     0.200
     1.929    54.047     0.200
     2.153    59.484     0.200
     2.175    60.008     0.200
     2.580    72.945     0.200
     3.202    88.500     0.200
     0.764    25.852     0.200
     1.071    33.052     0.200
     1.081    33.610     0.200
     1.081    32.832     0.200
     1.411    41.832     0.200
     1.961    57.914     0.200
     2.800    79.094     0.200
     4.607   122.372     0.200
     0.654    23.355     0.200
     0.754    24.875     0.200
     0.754    24.535     0.200
     0.766    24.805     0.200
     0.965    29.287     0.200
     0.965    29.496     0.200
     1.029    31.076     0.200
     1.029    31.434     0.200
     1.304    38.629     0.200
     1.794    50.691     0.200
     2.251    62.977     0.200
     3.038    83.205     0.200
     0.448    15.182     0.200
     0.715    23.662     0.200
     1.073    31.531     0.200
     1.367    38.805     0.200
     1.675    46.689     0.200
     1.811    50.811     0.200
     1.950    53.514     0.200
     2.272    61.842     0.200
     2.434    65.018     0.200
     8.726   221.162     0.200
     0.766    24.344     0.200
     0.933    27.711     0.200
     1.706    47.438     0.200
     3.063    86.992     0.200
     3.331    90.172     0.200
     4.645   124.234     0.200
     0.626    21.130     0.200
     0.760    24.790     0.200
     0.779    24.460     0.200
     0.854    26.087     0.200
     1.397    39.712     0.200
     1.449    41.117     0.200
     1.664    46.016     0.200
     1.714    47.304     0.200
     2.865    80.390     0.200
     3.123    86.580     0.200
     3.336    92.050     0.200
     4.287   114.690     0.200
     4.632   123.160     0.200
     4.795   126.690     0.200
     6.131   161.360     0.200
    16.271   407.490     0.200
     0.746    23.639     0.200
     0.801    25.759     0.200
     0.838    26.939     0.200
     0.838    26.309     0.200
     1.025    30.339     0.200
     1.116    32.784     0.200
     1.116    33.436     0.200
     1.116    32.239     0.200
     1.352    39.476     0.200
     1.580    45.946     0.200
     1.684    47.928     0.200
     1.869    53.438     0.200
     0.815    26.219     0.200
     1.089    31.977     0.200
     1.173    34.172     0.200
     1.550    44.906     0.200
     1.569    45.375     0.200
     1.641    46.789     0.200
     1.689    47.891     0.200
     0.775    24.770     0.200
     0.921    28.801     0.200
     1.398    41.301     0.200
     1.445    42.301     0.200
     1.709    49.699     0.200
     3.070    87.699     0.200
     3.814   100.801     0.200
     4.909   130.539     0.200
     4.909   127.738     0.200
     5.548   147.328     0.200
     5.548   149.352     0.200
     9.254   237.961     0.200
     0.663    23.073     0.200
     0.723    22.743     0.200
     0.883    26.641     0.200
     0.883    25.743     0.200
     0.896    26.743     0.200
     1.353    38.627     0.200
     1.441    41.152     0.200
     1.592    44.722     0.200
     2.207    60.615     0.200
     0.588    20.123     0.200
     0.752    23.434     0.200
     0.761    24.264     0.200
     0.955    27.604     0.200
     1.435    40.668     0.200
     2.144    58.152     0.200
     2.318    62.412     0.200
    10.422   263.805     0.200
     0.682    21.867     0.200
     0.682    23.703     0.200
     0.843    27.273     0.200
     0.903    27.258     0.200
     1.381    39.461     0.200
     1.444    41.133     0.200
     1.619    45.992     0.200
     0.742    23.680     0.200
     0.801    25.156     0.200
     0.931    28.289     0.200
     1.388    40.961     0.200
     1.466    42.625     0.200
     1.735    48.367     0.200
     6.497   167.086     0.200
    12.900   324.688     0.200
    16.290   406.578     0.200
     0.450    16.520     0.200
     0.792    24.891     0.200
     0.884    26.523     0.200
     0.884    26.949     0.200
     1.125    32.684     0.200
     1.686    48.441     0.200
     4.220   109.371     0.200
     4.631   122.340     0.200
     8.026   204.648     0.200
     0.855    26.988     0.200
     1.405    41.004     0.200
     2.166    60.035     0.200
     2.663    73.176     0.200
     3.046    83.043     0.200
     0.534    20.047     0.200
     0.834    26.938     0.200
     0.882    27.758     0.200
     1.035    30.801     0.200
     1.124    33.629     0.200
     1.124    33.977     0.200
     1.685    48.551     0.200
     2.369    68.379     0.200
     2.592    70.391     0.200
     5.583   145.547     0.200
     0.626    21.969     0.200
     0.679    22.422     0.200
     0.679    23.555     0.200
     0.982    27.727     0.200
     0.982    28.602     0.200
     1.100    32.492     0.200
     1.402    39.203     0.200
     3.148    88.805     0.200
     3.196    88.219     0.200
     3.917   103.383     0.200
     0.738    25.188     0.200
     1.026    30.191     0.200
     1.026    31.105     0.200
     1.081    32.172     0.200
     1.327    38.754     0.200
     1.634    46.285     0.200
     8.682   220.301     0.200
     0.741    24.535     0.200
     1.318    37.801     0.200
     0.748    24.820     0.200
     1.011    28.926     0.200
     1.313    38.430     0.200
     1.622    46.508     0.200
     1.926    54.352     0.200
     2.216    61.312     0.200
     3.847   101.855     0.200
     0.663    21.770     0.200
     0.663    22.691     0.200
     0.661    21.723     0.200
     0.975    28.961     0.200
     2.946    82.281     0.200
     3.231    89.301     0.200
     4.645   123.973     0.200
     5.447   145.199     0.200
     6.288   165.551     0.200
     0.700    24.480     0.200
     0.773    24.910     0.200
     1.384    40.520     0.200
     1.427    41.047     0.200
     1.631    46.375     0.200
     2.177    61.340     0.200
     3.040    83.223     0.200
     4.628   124.102     0.200
     0.639    21.117     0.200
     0.978    28.167     0.200
     3.230    89.057     0.200
     4.387   118.127     0.200
     8.309   213.247     0.200
     0.522    19.627     0.200
     0.606    20.647     0.200
     0.746    24.407     0.200
     0.746    24.968     0.200
     0.780    24.917     0.200
     0.936    28.127     0.200
     0.936    28.367     0.200
     1.070    31.709     0.200
     1.070    33.127     0.200
     1.084    32.821     0.200
     2.476    69.917     0.200
     0.873    25.707     0.200
     2.442    66.641     0.200
     6.621   169.938     0.200
     0.469    17.469     0.200
     0.809    26.148     0.200
     0.809    25.602     0.200
     0.809    25.930     0.200
     0.906    27.352     0.200
     1.046    30.582     0.200
     1.115    33.172     0.200
     1.115    32.676     0.200
     1.134    34.230     0.200
     1.620    47.320     0.200
     2.331    66.820     0.200
     2.345    67.566     0.200
     2.781    77.699     0.200
     3.743   103.672     0.200
     3.917   107.012     0.200
     4.651   125.301     0.200
     6.531   170.629     0.200
     6.558   172.641     0.200
     8.044   209.129     0.200
     0.725    23.734     0.200
     0.805    26.426     0.200
     0.805    25.426     0.200
     0.805    25.656     0.200
     0.910    27.500     0.200
     2.341    66.328     0.200
     2.669    73.012     0.200
     0.704    24.777     0.200
     1.131    34.230     0.200
     2.987    83.078     0.200
     3.038    82.359     0.200
     3.239    87.738     0.200
     3.847   105.520     0.200
     4.254   114.301     0.200
     4.595   123.391     0.200
     5.483   145.059     0.200
     6.383   167.160     0.200
     0.510    19.309     0.200
     0.594    20.648     0.200
     0.741    24.566     0.200
     0.786    25.258     0.200
     0.786    25.148     0.200
     1.080    32.262     0.200
     1.080    32.590     0.200
     1.095    33.102     0.200
     1.362    39.930     0.200
     2.290    66.500     0.200
     2.307    66.734     0.200
     2.425    69.508     0.200
     2.654    72.457     0.200
     2.751    77.137     0.200
     3.098    84.438     0.200
     3.706    99.777     0.200
     3.871   103.387     0.200
     5.277   136.797     0.200
     5.629   146.930     0.200
     7.859   200.930     0.200
     7.880   201.137     0.200
     7.898   203.359     0.200
     8.127   207.219     0.200
     8.910   228.359     0.200
     9.148   238.047     0.200
    11.983   302.520     0.200
    14.690   367.840     0.200
     0.568    21.985     0.200
     0.910    29.165     0.200
     1.091    32.765     0.200
     1.543    45.625     0.200
     0.628    21.316     0.200
     0.742    23.906     0.200
     0.809    24.762     0.200
     0.896    26.520     0.200
     0.896    27.227     0.200
     2.826    77.867     0.200
     4.247   113.199     0.200
     4.441   119.117     0.200
     4.617   125.059     0.200
     5.454   143.059     0.200
     5.454   142.434     0.200
     6.090   159.387     0.200
     6.368   166.840     0.200
     6.732   175.238     0.200
     6.750   175.617     0.200
     7.165   185.438     0.200
     7.240   187.758     0.200
     7.475   193.648     0.200
     7.857   202.930     0.200
     8.121   209.168     0.200
     8.180   210.617     0.200
     8.299   215.277     0.200
     8.449   214.430     0.200
     8.479   218.219     0.200
     8.850   224.828     0.200
     9.718   250.539     0.200
     9.806   254.566     0.200
    10.505   270.617     0.200
    10.652   271.367     0.200
    11.316   290.289     0.200
    11.637   296.359     0.200
    11.666   297.867     0.200
    11.755   296.629     0.200
    11.932   305.547     0.200
    12.124   310.430     0.200
    12.318   314.020     0.200
    12.354   314.027     0.200
    12.500   316.746     0.200
    12.920   327.566     0.200
    13.732   346.508     0.200
    18.287   457.520     0.200
     0.553    20.000     0.200
     0.553    20.180     0.200
     0.755    25.070     0.200
     1.041    30.551     0.200
     0.764    24.537     0.200
     0.764    25.838     0.200
     0.764    25.998     0.200
     0.955    28.998     0.200
     1.030    31.238     0.200
     3.043    84.809     0.200
     0.623    22.504     0.200
     0.749    23.883     0.200
     0.767    25.824     0.200
     0.767    24.895     0.200
     0.949    29.184     0.200
     0.949    28.570     0.200
     1.035    30.283     0.200
     1.058    31.613     0.200
     1.067    32.371     0.200
     1.811    52.768     0.200
     2.397    69.273     0.200
     3.070    87.254     0.200
     0.738    24.492     0.200
     0.812    26.062     0.200
     1.103    33.023     0.200
     1.103    33.211     0.200
     1.129    34.336     0.200
     1.340    39.781     0.200
     2.341    66.953     0.200
     2.506    69.930     0.200
     0.720    23.914     0.200
     0.796    25.398     0.200
     0.919    28.617     0.200
     1.053    31.125     0.200
     1.113    33.250     0.200
     1.123    34.203     0.200
     0.487    17.105     0.200
     0.487    18.875     0.200
     0.791    25.405     0.200
     0.924    28.025     0.200
     1.106    32.825     0.200
     1.115    33.854     0.200
     1.337    40.035     0.200
     1.730    48.705     0.200
     2.450    70.485     0.200
     3.910   106.936     0.200
     7.748   200.756     0.200
     8.893   228.306     0.200
     0.537    18.725     0.200
     0.622    21.865     0.200
     0.772    24.455     0.200
     0.772    25.084     0.200
     0.772    24.865     0.200
     1.057    31.855     0.200
     1.386    41.404     0.200
     0.839    26.486     0.200
     0.839    26.715     0.200
     1.401    39.748     0.200
     1.473    42.756     0.200
     1.683    48.920     0.200
     1.909    54.703     0.200
     2.104    59.172     0.200
     8.421   219.457     0.200
     0.624    21.189     0.200
     0.799    25.719     0.200
     0.799    26.578     0.200
     0.841    26.828     0.200
     0.841    26.559     0.200
     1.399    39.980     0.200
     2.285    62.621     0.200
     8.419   217.289     0.200
     0.714    23.287     0.200
     0.780    24.847     0.200
     1.109    33.380     0.200
     4.272   111.037     0.200
     0.722    23.707     0.200
     0.761    24.520     0.200
     1.081    32.770     0.200
     1.086    32.535     0.200
     1.357    39.859     0.200
     0.711    23.006     0.200
     0.755    24.115     0.200
     1.010    30.326     0.200
     0.997    30.051     0.200
     1.019    30.660     0.200
     1.019    30.775     0.200
     1.051    30.312     0.200
     1.429    41.625     0.200
     1.597    46.107     0.200
     3.011    84.375     0.200
     0.904    27.883     0.200
     1.093    32.332     0.200
     1.182    34.492     0.200
     1.182    34.793     0.200
     1.174    33.754     0.200
     1.261    36.012     0.200
     1.578    45.871     0.200
    10.868   276.266     0.200
    11.967   307.352     0.200
    12.059   306.871     0.200
    13.489   339.594     0.200
    15.954   397.223     0.200
     1.085    31.562     0.200
     1.177    33.367     0.200
     1.168    35.359     0.200
     1.168    34.152     0.200
     1.168    33.879     0.200
     2.376    68.363     0.200
     0.676    23.406     0.200
     0.818    26.305     0.200
     1.094    31.789     0.200
     6.727   170.305     0.200
     0.496    19.664     0.200
     0.782    25.174     0.200
     0.933    27.818     0.200
     1.054    30.260     0.200
     1.100    32.238     0.200
     1.342    38.443     0.200
     1.612    46.537     0.200
     2.442    69.254     0.200
     2.492    69.533     0.200
     2.772    76.834     0.200
     3.889   101.754     0.200
     4.274   114.193     0.200
     4.674   123.303     0.200
     5.633   143.934     0.200
     6.544   168.324     0.200
     6.787   173.854     0.200
     8.066   206.883     0.200
     8.903   228.084     0.200
     0.753    23.883     0.200
     0.794    24.789     0.200
     0.923    27.266     0.200
     1.414    40.953     0.200
     0.659    21.344     0.200
     0.653    21.543     0.200
     0.983    28.402     0.200
     0.963    29.137     0.200
     7.200   181.344     0.200
     0.573    19.602     0.200
     0.573    21.121     0.200
     0.981    29.535     0.200
     0.981    29.254     0.200
     1.044    30.938     0.200
     1.038    31.168     0.200
     1.038    30.211     0.200
     1.030    31.320     0.200
     2.226    64.668     0.200
     2.243    64.594     0.200
     0.731    24.303     0.200
     1.008    29.971     0.200
     1.008    31.082     0.200
     1.612    45.928     0.200
     1.921    54.107     0.200
     1.945    54.146     0.200
     2.751    73.514     0.200
     3.286    93.703     0.200
     3.335    93.973     0.200
     3.665    99.012     0.200
     4.428   120.713     0.200
     4.556   123.553     0.200
     4.632   124.771     0.200
     5.411   142.002     0.200
     6.209   159.793     0.200
     6.242   164.262     0.200
     6.281   164.543     0.200
     6.330   163.092     0.200
     6.842   180.393     0.200
     6.860   181.092     0.200
     7.063   185.812     0.200
     7.475   193.193     0.200
     7.953   206.252     0.200
     8.076   206.713     0.200
     8.662   222.707     0.200
    10.210   259.982     0.200
     0.648    21.977     0.200
     0.693    24.035     0.200
     1.085    33.512     0.200
     4.180   112.777     0.200
     5.435   144.477     0.200
     6.384   167.328     0.200
     7.444   194.078     0.200
     0.767    25.773     0.200
     0.775    25.422     0.200
     0.780    25.160     0.200
     0.785    25.555     0.200
     3.848   101.869     0.200
     3.848   105.830     0.200
     4.279   116.189     0.200
     4.463   121.020     0.200
     4.650   126.490     0.200
     5.484   146.289     0.200
     5.558   148.760     0.200
     6.046   158.799     0.200
     6.120   162.920     0.200
     6.387   165.039     0.200
     6.766   175.180     0.200
     7.908   205.600     0.200
     8.086   212.049     0.200
     9.752   247.979     0.200
     9.762   250.570     0.200
     0.414    14.695     0.200
     0.574    21.226     0.200
     0.659    21.806     0.200
     0.730    23.726     0.200
     0.871    26.665     0.200
     0.988    29.909     0.200
     2.224    63.322     0.200
     2.239    63.797     0.200
     6.064   153.735     0.200
     6.064   157.476     0.200
     6.213   162.516     0.200
     7.155   182.915     0.200
     9.861   253.636     0.200
     1.001    30.543     0.200
     1.023    31.006     0.200
     1.023    31.434     0.200
     1.008    29.898     0.200
     2.213    64.402     0.200
     0.608    21.549     0.200
     0.712    24.029     0.200
     0.995    30.312     0.200
     1.014    30.828     0.200
     1.014    31.068     0.200
     1.010    30.262     0.200
     1.308    37.502     0.200
     1.433    40.439     0.200
     1.690    50.129     0.200
     1.691    49.549     0.200
     2.158    59.643     0.200
     2.190    63.139     0.200
     2.207    63.672     0.200
     2.701    73.588     0.200
     0.730    24.455     0.200
     0.732    24.945     0.200
     0.984    29.424     0.200
     1.061    31.225     0.200
     1.040    31.572     0.200
     1.059    31.791     0.200
     1.059    31.924     0.200
     1.651    45.164     0.200
     1.812    52.299     0.200
     2.238    64.625     0.200
     0.610    21.004     0.200
     1.010    30.598     0.200
     0.993    30.113     0.200
     1.009    30.297     0.200
     1.044    30.816     0.200
     2.154    59.387     0.200
     2.188    63.465     0.200
     2.206    63.941     0.200
     0.696    23.639     0.200
     0.800    25.469     0.200
     0.918    27.316     0.200
     0.918    28.119     0.200
     1.145    33.252     0.200
     1.145    34.625     0.200
     1.298    38.600     0.200
     1.899    54.391     0.200
     0.757    24.051     0.200
     0.810    26.328     0.200
     0.914    27.242     0.200
     0.914    27.816     0.200
     0.602    20.277     0.200
     0.840    26.586     0.200
     0.898    27.074     0.200
     3.875   102.426     0.200
     0.741    25.479     0.200
     0.994    31.020     0.200
     1.612    45.639     0.200
     4.687   122.229     0.200
     0.675    21.742     0.200
     0.647    21.699     0.200
     0.948    28.219     0.200
     0.983    28.973     0.200
     0.982    28.617     0.200
     1.308    38.172     0.200
     1.803    51.621     0.200
     2.959    81.512     0.200
     3.877   106.289     0.200
     8.927   228.359     0.200
    10.286   262.832     0.200
    10.626   265.352     0.200
     0.731    23.475     0.200
     0.850    26.898     0.200
     0.886    27.090     0.200
     0.941    27.639     0.200
     0.941    28.045     0.200
     0.606    20.168     0.200
     0.719    22.879     0.200
     0.719    22.529     0.200
     0.760    23.668     0.200
     0.907    26.459     0.200
     0.907    26.850     0.200
     3.685    99.209     0.200
     4.247   114.010     0.200
     5.475   144.209     0.200
     0.710    24.544     0.200
     8.291   213.444     0.200
     0.756    24.351     0.200
     0.756    25.650     0.200
     0.818    25.562     0.200
     0.818    26.131     0.200
     1.177    35.283     0.200
     8.436   217.021     0.200
     0.731    24.773     0.200
     0.784    24.914     0.200
     0.810    25.273     0.200
     0.845    25.086     0.200
     0.845    25.766     0.200
     0.934    28.461     0.200
     1.138    34.062     0.200
     1.863    54.477     0.200
     2.101    60.297     0.200
     7.944   207.617     0.200
    13.232   336.562     0.200
    16.179   404.062     0.200
     0.504    18.652     0.200
     0.681    22.521     0.200
     0.819    26.342     0.200
     0.904    27.270     0.200
     1.090    31.650     0.200
     1.548    44.916     0.200
     1.642    47.381     0.200
     8.839   227.500     0.200
     0.621    21.254     0.200
     0.741    24.102     0.200
     0.792    25.691     0.200
     0.834    26.973     0.200
     0.873    27.266     0.200
     0.940    28.043     0.200
     6.350   161.672     0.200
    10.387   264.691     0.200
     0.782    25.086     0.200
     0.933    27.650     0.200
     0.933    28.357     0.200
     1.102    31.861     0.200
     1.102    32.518     0.200
     1.106    33.453     0.200
     0.783    25.945     0.200
     1.133    34.816     0.200
     4.276   111.346     0.200
     8.469   217.625     0.200
     0.558    20.258     0.200
     0.688    22.414     0.200
     1.033    31.430     0.200
     1.027    30.758     0.200
     1.120    33.719     0.200
     1.603    46.734     0.200
     1.604    45.812     0.200
     1.604    46.758     0.200
     2.239    64.133     0.200
     9.952   255.625     0.200
     0.771    24.969     0.200
     0.813    25.531     0.200
     0.939    27.609     0.200
     1.160    34.742     0.200
     1.713    48.094     0.200
     1.713    47.758     0.200
     1.957    55.289     0.200
     4.297   113.164     0.200
    13.731   347.000     0.200
     1.035    31.504     0.200
     1.358    40.031     0.200
     1.395    41.281     0.200
     4.674   122.930     0.200
     5.317   139.789     0.200
     5.517   144.379     0.200
     0.686    22.680     0.200
     0.845    26.227     0.200
     0.931    27.875     0.200
     0.973    28.742     0.200
     0.973    28.438     0.200
     1.743    50.820     0.200
     2.196    61.930     0.200
     4.834   126.055     0.200
     6.323   165.977     0.200
     6.478   168.547     0.200
     8.107   211.570     0.200
     0.766    24.020     0.200
     0.784    24.934     0.200
     1.160    34.629     0.200
     1.295    36.836     0.200
     1.347    40.084     0.200
     1.630    45.854     0.200
     2.433    67.273     0.200
     3.082    85.133     0.200
     8.355   215.633     0.200
     0.747    23.617     0.200
     0.750    23.789     0.200
     3.649    97.250     0.200
     0.804    25.162     0.200
     0.826    25.742     0.200
     0.853    27.242     0.200
     1.057    30.480     0.200
     1.167    33.779     0.200
     1.167    34.061     0.200
     1.584    45.191     0.200
     1.585    46.811     0.200
     0.648    22.057     0.200
     0.998    28.794     0.200
     1.279    37.287     0.200
     1.557    43.720     0.200
     1.739    49.545     0.200
     1.831    51.767     0.200
     2.368    64.646     0.200
     0.670    21.703     0.200
     0.950    28.641     0.200
     0.979    29.148     0.200
     0.979    28.797     0.200
     1.385    39.562     0.200
     1.720    50.195     0.200
     1.810    50.055     0.200
     3.029    83.008     0.200
     9.255   232.773     0.200
    10.052   259.016     0.200
    16.070   404.344     0.200
     0.820    25.684     0.200
     1.048    30.934     0.200
     1.146    33.133     0.200
     1.146    33.996     0.200
     1.153    33.957     0.200
     1.153    34.133     0.200
     1.153    34.391     0.200
     1.508    42.004     0.200
     2.396    68.270     0.200
     3.248    88.691     0.200
    13.368   335.844     0.200
     0.629    20.578     0.200
     0.989    28.387     0.200
     0.989    29.797     0.200
     1.345    38.688     0.200
     1.575    44.707     0.200
     1.730    47.770     0.200
     1.730    51.090     0.200
     1.989    55.762     0.200
     1.989    56.617     0.200
     2.356    63.145     0.200
     2.622    70.863     0.200
     2.700    71.406     0.200
     3.004    82.398     0.200
     3.482    93.527     0.200
     3.872   102.750     0.200
     4.636   124.930     0.200
     4.981   130.059     0.200
     6.247   160.379     0.200
     8.093   211.719     0.200
     0.959    31.320     0.200
     1.236    37.492     0.200
     1.242    36.859     0.200
     1.470    44.672     0.200
     1.567    46.836     0.200
     1.573    47.055     0.200
     1.573    44.852     0.200
     1.631    46.922     0.200
     1.631    46.477     0.200
     1.778    51.305     0.200
     1.979    55.945     0.200
     2.293    64.570     0.200
     2.429    67.000     0.200
     2.612    74.367     0.200
     2.631    73.242     0.200
     2.943    78.938     0.200
     2.943    79.273     0.200
     3.705   102.133     0.200
     4.354   119.430     0.200
     4.721   124.570     0.200
     4.744   122.789     0.200
     4.900   125.492     0.200
     5.582   146.789     0.200
     0.625    20.961     0.200
     0.625    22.141     0.200
     1.018    29.383     0.200
     1.018    28.844     0.200
     1.399    38.711     0.200
     2.673    74.453     0.200
     4.218   112.703     0.200
     9.621   239.844     0.200
    13.382   334.484     0.200
     0.792    24.801     0.200
     0.944    27.527     0.200
     0.944    27.711     0.200
     1.405    40.672     0.200
     1.733    47.184     0.200
     2.589    71.414     0.200
     3.090    85.391     0.200
     3.812   102.832     0.200
     5.471   144.711     0.200
     6.352   160.504     0.200
     0.780    25.262     0.200
     0.780    25.410     0.200
     0.888    28.590     0.200
     1.317    38.328     0.200
     1.616    46.508     0.200
    10.407   265.438     0.200
     0.546    18.188     0.200
     0.633    21.078     0.200
     0.804    25.457     0.200
     1.001    29.090     0.200
     1.379    39.879     0.200
     2.598    68.660     0.200
     3.207    89.688     0.200
     8.308   211.090     0.200
     8.301   216.977     0.200
     8.350   214.418     0.200
     0.852    26.612     0.200
     0.938    28.053     0.200
     2.130    56.665     0.200
     2.130    59.135     0.200
     3.114    84.815     0.200
     6.370   164.035     0.200
     6.370   164.135     0.200
    12.900   328.505     0.200
     0.640    21.626     0.200
     0.795    26.896     0.200
     0.998    30.126     0.200
     0.998    29.546     0.200
     0.998    30.436     0.200
     1.382    39.346     0.200
     1.839    48.906     0.200
     3.245    89.496     0.200
     4.275   117.636     0.200
     6.292   160.855     0.200
     0.742    24.438     0.200
     0.742    25.492     0.200
     0.866    26.898     0.200
    12.041   305.805     0.200
     0.712    22.678     0.200
     0.806    26.098     0.200
     0.898    26.869     0.200
     0.970    27.533     0.200
     0.970    27.928     0.200
     1.710    49.152     0.200
     0.735    24.738     0.200
     1.228    35.598     0.200
     1.410    42.648     0.200
     1.410    42.797     0.200
     2.540    72.621     0.200
     2.615    74.172     0.200
     0.663    22.453     0.200
     0.863    27.883     0.200
     1.261    37.334     0.200
     1.543    43.311     0.200
     1.733    49.697     0.200
     2.363    62.809     0.200
     2.691    72.584     0.200
     3.026    83.506     0.200
     1.223    35.682     0.200
     1.223    36.424     0.200
     1.409    42.664     0.200
     1.409    42.885     0.200
     1.577    44.658     0.200
     2.540    72.676     0.200
     2.614    74.215     0.200
     0.758    24.598     0.200
     0.775    25.680     0.200
     0.822    25.719     0.200
     0.415    14.816     0.200
     0.814    25.277     0.200
     0.839    25.449     0.200
     0.839    25.148     0.200
     0.847    26.078     0.200
     1.019    29.797     0.200
     1.141    33.180     0.200
     1.143    33.613     0.200
     1.143    33.109     0.200
     1.475    43.297     0.200
     1.896    53.148     0.200
     2.413    68.547     0.200
     3.259    86.965     0.200
     4.174   109.789     0.200
     0.810    26.359     0.200
     0.852    27.742     0.200
     0.982    30.648     0.200
     1.024    30.992     0.200
     1.236    35.656     0.200
     1.236    35.781     0.200
     1.635    46.930     0.200
     1.920    53.039     0.200
     2.587    69.750     0.200
     2.603    73.984     0.200
     2.691    71.734     0.200
     2.835    76.219     0.200
     0.763    25.969     0.200
     0.904    28.961     0.200
     1.026    31.266     0.200
     1.236    35.609     0.200
     1.236    35.859     0.200
     1.407    42.773     0.200
     1.407    42.688     0.200
     1.803    52.844     0.200
     1.953    55.281     0.200
     2.611    74.102     0.200
     2.838    77.344     0.200
     2.889    81.086     0.200
     2.925    81.320     0.200
     3.035    82.250     0.200
     3.333    90.891     0.200
     0.802    25.312     0.200
     0.760    24.406     0.200
     1.435    40.307     0.200
     2.609    69.887     0.200
     3.055    86.206     0.200
     3.849   104.887     0.200
     8.465   217.887     0.200
     1.412    40.814     0.200
     1.957    56.543     0.200
     0.812    25.477     0.200
     2.319    63.713     0.200
     2.629    71.203     0.200
     0.762    26.043     0.200
     0.770    24.803     0.200
     0.817    25.938     0.200
     1.408    40.373     0.200
     0.684    22.605     0.200
     0.890    28.270     0.200
     0.979    27.941     0.200
     0.979    28.766     0.200
     1.244    36.445     0.200
     1.524    43.332     0.200
     1.720    47.375     0.200
     1.770    50.020     0.200
     2.017    58.742     0.200
     2.077    58.070     0.200
     2.351    62.766     0.200
     2.909    80.668     0.200
     3.787    99.406     0.200
     0.989    28.289     0.200
     0.989    28.715     0.200
     1.217    36.207     0.200
     1.249    36.496     0.200
     1.746    51.059     0.200
     1.731    49.898     0.200
     0.586    21.148     0.200
     0.638    20.809     0.200
     0.875    25.889     0.200
     1.049    30.131     0.200
     1.139    32.469     0.200
     1.668    47.781     0.200
     2.008    57.787     0.200
     2.034    57.980     0.200
     8.067   207.947     0.200
     0.986    28.470     0.200
     8.377   214.723     0.200
    10.325   261.123     0.200
     0.747    23.863     0.200
     1.497    42.484     0.200
     1.570    44.492     0.200
     2.011    55.352     0.200
     0.809    25.401     0.200
     0.947    28.218     0.200
     0.947    27.396     0.200
     1.428    40.479     0.200
     1.686    49.019     0.200
     2.460    66.256     0.200
     2.604    70.778     0.200
     2.879    80.028     0.200
     3.060    84.858     0.200
     3.131    85.458     0.200
     3.108    86.298     0.200
     3.732   100.229     0.200
     3.841   101.928     0.200
     3.928   103.188     0.200
     4.300   112.229     0.200
     4.340   114.998     0.200
     4.660   123.858     0.200
     5.204   137.599     0.200
     7.517   193.718     0.200
     7.540   191.908     0.200
     8.457   216.309     0.200
     0.785    25.266     0.200
     0.765    24.219     0.200
     1.607    45.480     0.200
     2.102    57.480     0.200
     6.305   161.699     0.200
     0.866    27.234     0.200
     0.950    27.555     0.200
     1.229    36.688     0.200
     1.393    39.660     0.200
     1.489    42.984     0.200
     2.087    57.879     0.200
     3.792    99.074     0.200
     8.406   214.047     0.200
     0.616    21.334     0.200
     0.677    22.574     0.200
     0.737    23.724     0.200
     1.231    36.364     0.200
     1.383    38.750     0.200
     1.383    39.374     0.200
     1.440    42.928     0.200
     2.001    57.124     0.200
     2.012    57.481     0.200
     2.156    61.176     0.200
     2.962    79.804     0.200
     3.025    83.274     0.200
     7.170   182.664     0.200
     0.619    21.200     0.200
     0.619    20.010     0.200
     0.679    22.610     0.200
     0.751    23.740     0.200
     0.764    24.750     0.200
     0.764    24.530     0.200
     0.786    25.521     0.200
     1.169    34.940     0.200
     1.295    36.496     0.200
     1.320    38.110     0.200
     1.427    42.050     0.200
     1.581    44.740     0.200
     1.588    45.430     0.200
     1.594    45.278     0.200
     1.635    45.940     0.200
     1.634    46.309     0.200
     1.718    49.420     0.200
     0.638    20.805     0.200
     0.714    24.227     0.200
     0.749    23.414     0.200
     0.870    25.516     0.200
     1.541    44.492     0.200
     2.089    55.406     0.200
     2.089    55.844     0.200
     0.579    19.164     0.200
     0.752    23.773     0.200
     0.752    23.336     0.200
     0.720    24.102     0.200
     0.752    23.555     0.200
     0.876    25.789     0.200
     1.347    37.281     0.200
     2.083    55.359     0.200
     3.753    97.711     0.200
     6.285   160.484     0.200
     0.699    23.461     0.200
     0.765    23.320     0.200
     0.800    24.320     0.200
     0.858    25.180     0.200
     1.293    37.172     0.200
     1.637    46.930     0.200
     1.647    48.055     0.200
     0.492    17.309     0.200
     0.580    20.968     0.200
     0.591    20.789     0.200
     0.610    21.488     0.200
     0.667    21.718     0.200
     0.667    21.528     0.200
     0.815    25.258     0.200
     0.807    25.668     0.200
     0.819    24.896     0.200
     0.841    25.508     0.200
     0.840    25.818     0.200
     0.843    25.088     0.200
     0.850    26.099     0.200
     0.858    25.378     0.200
     0.967    29.318     0.200
     0.988    28.878     0.200
     0.980    29.668     0.200
     1.127    32.218     0.200
     1.127    32.000     0.200
     1.149    34.039     0.200
     2.001    57.485     0.200
     0.418    14.465     0.200
     0.412    14.984     0.200
     0.483    17.145     0.200
     0.503    17.785     0.200
     0.503    19.094     0.200
     0.533    18.934     0.200
     0.533    19.855     0.200
     0.552    18.855     0.200
     0.543    18.883     0.200
     0.564    18.195     0.200
     0.542    19.594     0.200
     0.573    20.754     0.200
     0.559    19.055     0.200
     0.587    20.242     0.200
     0.670    21.914     0.200
     0.707    22.766     0.200
     0.731    25.055     0.200
     0.783    23.695     0.200
     0.934    27.684     0.200
     1.338    36.863     0.200
     6.187   157.016     0.200
     0.460    17.561     0.200
     0.487    17.320     0.200
     0.509    18.521     0.200
     0.568    19.771     0.200
     0.589    20.881     0.200
     0.630    21.830     0.200
     0.645    20.570     0.200
     0.719    24.080     0.200
     0.740    22.851     0.200
     0.746    22.881     0.200
     1.227    36.061     0.200
     1.349    39.280     0.200
     1.551    40.150     0.200
     3.760    95.650     0.200
     0.407    15.055     0.200
     0.437    14.938     0.200
     0.447    16.445     0.200
     0.469    17.234     0.200
     0.503    18.023     0.200
     0.503    18.414     0.200
     0.510    18.266     0.200
     0.518    18.422     0.200
     0.555    18.664     0.200
     0.598    20.273     0.200
     0.605    20.672     0.200
     0.636    22.703     0.200
     0.691    23.242     0.200
     0.689    24.016     0.200
     0.716    22.711     0.200
     0.716    23.297     0.200
     0.717    22.727     0.200
     0.735    23.602     0.200
     0.755    24.391     0.200
     0.797    23.891     0.200
     0.879    26.336     0.200
     1.211    35.695     0.200
     6.347   162.109     0.200
     0.366    13.821     0.200
     0.375    12.781     0.200
     0.377    13.581     0.200
     0.427    15.500     0.200
     0.443    17.491     0.200
     0.469    15.451     0.200
     0.482    15.940     0.200
     0.478    17.000     0.200
     0.591    21.171     0.200
     0.604    21.431     0.200
     0.626    21.210     0.200
     0.638    20.980     0.200
     0.678    20.480     0.200
     0.889    26.281     0.200
     0.902    26.801     0.200
     1.144    33.683     0.200
    10.748   272.978     0.200
     0.421    14.975     0.200
     0.459    17.365     0.200
     0.494    17.354     0.200
     0.509    18.334     0.200
     0.587    20.404     0.200
     0.624    21.285     0.200
     0.718    23.943     0.200
     0.704    23.385     0.200
     0.735    22.895     0.200
     0.757    23.795     0.200
     0.756    23.754     0.200
     0.796    24.375     0.200
     1.550    43.664     0.200
     3.774    98.773     0.200
     5.259   135.785     0.200
     6.529   170.564     0.200
     0.503    18.278     0.200
     0.559    19.698     0.200
     0.566    19.088     0.200
     0.609    20.788     0.200
     0.611    21.228     0.200
     0.611    20.468     0.200
     0.661    22.888     0.200
     0.749    23.928     0.200
     0.896    27.458     0.200
     0.939    27.458     0.200
     1.524    41.608     0.200
     1.465    43.178     0.200
     0.445    15.918     0.200
     0.514    17.738     0.200
     0.588    19.809     0.200
     0.548    19.000     0.200
     0.626    20.531     0.200
     0.616    20.641     0.200
     0.612    19.699     0.200
     0.639    20.801     0.200
     0.628    21.352     0.200
     0.640    21.102     0.200
     0.665    21.148     0.200
     0.705    22.352     0.200
     0.753    23.738     0.200
     0.728    23.012     0.200
     0.742    23.398     0.200
     0.736    24.641     0.200
     0.730    23.750     0.200
     0.730    24.641     0.200
     0.772    25.012     0.200
     0.800    25.469     0.200
     0.826    25.602     0.200
     0.813    25.949     0.200
     0.864    26.531     0.200
     0.894    26.680     0.200
     0.908    27.270     0.200
     0.944    28.211     0.200
     0.976    28.988     0.200
     0.997    29.852     0.200
     1.022    30.410     0.200
     0.494    17.758     0.200
     0.609    21.188     0.200
     0.595    21.777     0.200
     0.740    24.328     0.200
     0.760    25.309     0.200
     0.811    25.377     0.200
     0.896    28.787     0.200
     0.896    29.617     0.200
     1.531    43.357     0.200
     1.604    46.367     0.200
     3.802    98.438     0.200
     0.444    16.469     0.200
     0.491    17.659     0.200
     0.500    19.109     0.200
     0.514    17.309     0.200
     0.554    19.648     0.200
     0.547    18.529     0.200
     0.575    19.999     0.200
     0.602    19.469     0.200
     0.618    21.199     0.200
     0.608    21.729     0.200
     0.608    21.418     0.200
     0.633    21.699     0.200
     0.726    24.229     0.200
     0.740    23.668     0.200
     0.787    25.749     0.200
     0.805    26.199     0.200
     0.832    27.279     0.200
     0.922    27.599     0.200
     1.511    42.438     0.200
     1.606    45.638     0.200
     0.417    14.758     0.200
     0.471    17.129     0.200
     0.497    17.348     0.200
     0.520    19.227     0.200
     0.549    19.289     0.200
     0.600    20.977     0.200
     0.640    21.758     0.200
     0.716    24.117     0.200
     0.751    23.586     0.200
     0.799    25.418     0.200
     0.866    25.848     0.200
     1.221    36.309     0.200
     5.241   139.297     0.200
     0.552    19.227     0.200
     0.589    20.406     0.200
     0.594    19.326     0.200
     0.625    19.855     0.200
     0.629    21.375     0.200
     0.643    20.586     0.200
     0.748    23.205     0.200
     0.761    23.996     0.200
     1.067    31.566     0.200
     1.551    42.436     0.200
     1.604    45.189     0.200
     3.762   100.125     0.200
     4.981   128.576     0.200
     0.415    15.309     0.200
     0.446    16.148     0.200
     0.493    17.449     0.200
     0.507    16.648     0.200
     0.513    18.469     0.200
     0.503    18.238     0.200
     0.513    18.859     0.200
     0.539    19.418     0.200
     0.602    19.930     0.200
     0.650    20.879     0.200
     0.681    21.738     0.200
     0.652    20.559     0.200
     0.730    22.957     0.200
     0.772    24.039     0.200
     0.727    23.039     0.200
     0.740    23.938     0.200
     0.777    25.137     0.200
     0.821    25.129     0.200
     0.864    25.938     0.200
     0.863    26.227     0.200
     0.864    25.922     0.200
     0.864    26.117     0.200
     0.873    26.109     0.200
     0.904    27.328     0.200
     0.911    27.277     0.200
     0.754    28.129     0.200
     0.944    28.457     0.200
     0.950    28.656     0.200
     1.179    34.020     0.200
     1.317    38.840     0.200
     0.407    14.160     0.200
     0.438    15.723     0.200
     0.595    19.859     0.200
     0.533    19.223     0.200
     0.559    19.871     0.200
     0.555    19.992     0.200
     0.697    22.762     0.200
     0.698    22.633     0.200
     0.685    22.672     0.200
     0.685    22.812     0.200
     0.720    24.160     0.200
     0.775    25.461     0.200
     0.752    25.891     0.200
     0.784    25.000     0.200
     0.930    28.301     0.200
     0.974    28.793     0.200
     1.053    30.980     0.200
     1.197    34.941     0.200
     0.485    17.219     0.200
     0.471    17.172     0.200
     0.444    17.414     0.200
     0.482    16.617     0.200
     0.482    17.055     0.200
     0.591    19.883     0.200
     0.535    18.969     0.200
     0.558    19.555     0.200
     0.556    19.688     0.200
     0.596    19.312     0.200
     0.681    22.414     0.200
     0.692    23.203     0.200
     0.694    22.703     0.200
     0.686    22.344     0.200
     0.697    22.719     0.200
     0.690    22.633     0.200
     0.722    24.031     0.200
     0.776    25.359     0.200
     0.787    24.984     0.200
     0.758    23.969     0.200
     0.840    27.000     0.200
     0.927    28.281     0.200
     0.969    28.781     0.200
     1.023    29.883     0.200
     1.195    34.727     0.200
     1.209    36.258     0.200
     1.367    40.734     0.200
     1.426    41.844     0.200
     0.573    20.527     0.200
     0.671    23.568     0.200
     0.728    23.338     0.200
     0.705    24.809     0.200
     0.752    24.617     0.200
     0.720    23.857     0.200
     0.729    24.537     0.200
     0.729    24.889     0.200
     0.759    25.918     0.200
     0.766    24.287     0.200
     0.773    25.027     0.200
     0.781    24.877     0.200
     0.824    26.248     0.200
     0.824    27.158     0.200
     0.896    28.008     0.200
     0.928    28.467     0.200
     0.950    28.088     0.200
     0.942    28.568     0.200
     0.936    28.498     0.200
     0.994    29.527     0.200
     0.995    30.518     0.200
     1.009    30.947     0.200
     1.010    30.848     0.200
     1.012    30.037     0.200
     1.010    30.697     0.200
     1.059    32.168     0.200
     1.107    33.328     0.200
     1.208    35.809     0.200
     1.210    35.518     0.200
     1.292    38.617     0.200
     1.348    40.229     0.200
     1.360    40.787     0.200
     1.408    41.488     0.200
     1.409    41.518     0.200
     1.432    41.377     0.200
     2.073    56.898     0.200
    11.005   280.262     0.200
     0.453    15.861     0.200
     0.497    17.861     0.200
     0.538    19.002     0.200
     0.569    19.412     0.200
     0.587    19.852     0.200
     0.651    21.502     0.200
     0.657    21.672     0.200
     0.664    21.551     0.200
     0.675    23.150     0.200
     0.675    24.012     0.200
     0.673    22.711     0.200
     0.673    22.242     0.200
     0.753    25.711     0.200
     0.753    25.521     0.200
     0.882    27.900     0.200
     0.901    28.242     0.200
     0.986    29.031     0.200
     1.041    30.721     0.200
     1.290    38.262     0.200
     1.609    43.041     0.200
     1.813    53.172     0.200
     3.986   104.951     0.200
     6.730   172.781     0.200
     6.730   175.242     0.200
     0.453    15.707     0.200
     0.453    16.697     0.200
     0.461    15.396     0.200
     0.461    15.926     0.200
     0.670    21.777     0.200
     0.366    13.646     0.200
     0.696    23.037     0.200
     0.696    22.197     0.200
     0.430    14.688     0.200
     0.437    16.467     0.200
     0.435    16.227     0.200
     0.630    21.516     0.200
     0.630    22.566     0.200
     0.630    21.857     0.200
     0.645    22.787     0.200
     0.627    21.086     0.200
     0.632    21.057     0.200
     0.423    15.127     0.200
     0.386    14.127     0.200
     0.613    20.266     0.200
     0.398    14.086     0.200
     0.693    22.816     0.200
     0.597    20.006     0.200
     0.848    25.816     0.200
     0.493    16.857     0.200
     0.591    19.467     0.200
     1.103    32.197     0.200
     1.103    32.121     0.200
     0.400    14.484     0.200
     0.392    13.695     0.200
     0.374    13.584     0.200
     0.413    14.744     0.200
     0.439    15.574     0.200
     0.504    17.135     0.200
     0.457    15.734     0.200
     0.603    19.314     0.200
     0.611    20.385     0.200
     0.626    20.465     0.200
     0.619    21.254     0.200
     0.638    20.875     0.200
     0.616    21.475     0.200
     0.676    22.174     0.200
     0.706    23.004     0.200
     0.683    22.365     0.200
     0.729    23.846     0.200
     0.995    29.965     0.200
     1.033    30.955     0.200
     1.116    32.430     0.200
     0.394    13.885     0.200
     0.402    14.674     0.200
     0.373    13.783     0.200
     0.421    15.504     0.200
     0.438    15.215     0.200
     0.464    15.484     0.200
     0.484    16.773     0.200
     0.524    16.924     0.200
     0.606    19.975     0.200
     0.627    20.604     0.200
     0.618    20.635     0.200
     0.614    21.254     0.200
     0.638    20.414     0.200
     0.707    22.924     0.200
     0.675    21.924     0.200
     0.681    21.895     0.200
     0.852    25.904     0.200
     0.888    25.934     0.200
     0.862    26.123     0.200
     0.937    27.555     0.200
     1.047    30.594     0.200
     1.110    31.734     0.200
     1.118    32.664     0.200
     1.118    32.527     0.200
     0.426    14.962     0.200
     0.426    14.853     0.200
     0.451    17.013     0.200
     0.465    16.953     0.200
     0.495    17.333     0.200
     0.495    18.143     0.200
     0.489    17.873     0.200
     0.502    18.442     0.200
     0.502    18.042     0.200
     0.502    18.933     0.200
     0.531    18.363     0.200
     0.531    19.062     0.200
     0.579    19.942     0.200
     0.577    20.232     0.200
     0.577    21.413     0.200
     0.612    20.383     0.200
     0.607    21.913     0.200
     0.693    23.223     0.200
     0.723    22.962     0.200
     0.737    24.823     0.200
     0.744    23.623     0.200
     0.750    25.002     0.200
     0.762    23.772     0.200
     0.765    24.353     0.200
     0.782    24.883     0.200
     0.816    26.442     0.200
     1.049    31.502     0.200
     1.212    35.922     0.200
     1.281    36.353     0.200
     1.557    44.223     0.200
     3.790   103.613     0.200
     0.409    14.484     0.200
     0.439    16.797     0.200
     0.456    17.070     0.200
     0.471    15.680     0.200
     0.481    17.664     0.200
     0.478    16.836     0.200
     0.478    17.461     0.200
     0.489    17.344     0.200
     0.468    16.219     0.200
     0.468    15.875     0.200
     0.566    20.141     0.200
     0.566    20.156     0.200
     0.604    20.656     0.200
     0.547    19.180     0.200
     0.618    19.891     0.200
     0.613    21.258     0.200
     0.735    24.680     0.200
     0.707    23.438     0.200
     0.773    25.547     0.200
     0.777    24.555     0.200
     0.777    24.375     0.200
     0.766    24.516     0.200
     0.766    25.039     0.200
     0.814    24.438     0.200
     0.843    25.000     0.200
     0.921    27.539     0.200
     1.571    43.641     0.200
     3.738   101.469     0.200
     3.783    99.578     0.200
     5.007   133.391     0.200
     5.274   139.055     0.200
     5.274   141.086     0.200
     5.696   150.398     0.200
     5.872   155.469     0.200
     8.685   224.688     0.200
     9.956   256.211     0.200
    10.379   268.516     0.200
    12.738   326.078     0.200
     0.536    18.453     0.200
     0.536    18.617     0.200
     0.610    20.336     0.200
     0.617    22.141     0.200
     0.618    22.086     0.200
     0.695    23.234     0.200
     0.983    29.703     0.200
     1.569    41.391     0.200
     0.442    16.570     0.200
     0.456    16.969     0.200
     0.616    21.898     0.200
     0.480    17.570     0.200
     0.489    17.406     0.200
     0.493    18.008     0.200
     0.568    19.648     0.200
     0.572    19.828     0.200
     0.603    20.219     0.200
     0.729    24.352     0.200
     0.757    24.453     0.200
     0.741    24.891     0.200
     0.773    24.930     0.200
     0.777    25.750     0.200
     0.807    26.148     0.200
     0.985    29.828     0.200
     1.578    45.070     0.200
     1.744    49.438     0.200
     3.795   104.211     0.200
     5.010   131.391     0.200
     5.283   138.789     0.200
     5.694   149.883     0.200
     5.874   154.039     0.200
     0.394    13.959     0.200
     0.394    14.129     0.200
     0.433    16.679     0.200
     0.456    17.109     0.200
     0.465    16.520     0.200
     0.465    16.359     0.200
     0.454    15.679     0.200
     0.482    17.529     0.200
     0.480    17.469     0.200
     0.554    19.079     0.200
     0.562    19.989     0.200
     0.562    19.969     0.200
     0.564    19.299     0.200
     0.564    19.419     0.200
     0.604    20.639     0.200
     0.604    19.319     0.200
     0.730    24.009     0.200
     0.723    24.249     0.200
     0.767    25.520     0.200
     0.830    25.329     0.200
     0.838    25.449     0.200
     1.050    31.409     0.200
     1.181    35.179     0.200
     1.257    35.349     0.200
     1.578    41.520     0.200
     1.579    44.958     0.200
     3.771    99.569     0.200
     5.872   152.319     0.200
     6.534   169.020     0.200
     8.894   225.559     0.200
     0.401    14.221     0.200
     0.401    14.109     0.200
     0.401    14.461     0.200
     0.401    15.270     0.200
     0.436    15.270     0.200
     0.436    15.580     0.200
     0.461    17.830     0.200
     0.461    15.971     0.200
     0.481    17.010     0.200
     0.481    16.900     0.200
     0.481    17.529     0.200
     0.486    18.260     0.200
     0.509    18.471     0.200
     0.509    18.221     0.200
     0.505    17.609     0.200
     0.505    18.301     0.200
     0.505    17.119     0.200
     0.578    19.920     0.200
     0.591    21.080     0.200
     0.591    20.230     0.200
     0.583    20.410     0.200
     0.564    20.029     0.200
     0.634    21.900     0.200
     0.634    21.480     0.200
     0.652    21.570     0.200
     0.652    21.740     0.200
     0.744    23.789     0.200
     0.890    26.980     0.200
     1.552    40.500     0.200
     1.608    45.645     0.200
     3.750    99.580     0.200
     5.843   156.010     0.200
     0.357    12.922     0.200
     0.467    16.703     0.200
     0.506    18.172     0.200
     0.515    17.410     0.200
     0.515    18.242     0.200
     0.579    19.891     0.200
     0.590    20.781     0.200
     0.587    20.133     0.200
     0.639    21.453     0.200
     0.665    21.180     0.200
     0.665    22.082     0.200
     0.665    22.582     0.200
     0.720    21.773     0.200
     0.730    21.672     0.200
     1.612    44.422     0.200
     3.719   102.340     0.200
     4.969   133.250     0.200
     5.226   139.250     0.200
     0.391    14.094     0.200
     0.488    17.492     0.200
     0.508    18.273     0.200
     0.513    18.531     0.200
     0.513    17.852     0.200
     0.564    19.773     0.200
     0.569    20.121     0.200
     0.607    19.922     0.200
     0.607    20.594     0.200
     0.644    22.141     0.200
     0.644    22.160     0.200
     0.614    20.633     0.200
     0.614    19.551     0.200
     0.623    21.004     0.200
     0.623    21.191     0.200
     0.623    21.172     0.200
     0.668    22.230     0.200
     0.695    22.883     0.200
     0.701    22.023     0.200
     0.701    23.512     0.200
     0.765    24.184     0.200
     0.774    24.613     0.200
     0.896    27.254     0.200
     0.926    26.863     0.200
     3.905   102.301     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.103     5.919     0.200
     0.720    22.819     0.200
     1.186    37.129     0.200
     1.286    41.129     0.200
     1.290    42.760     0.200
     1.345    42.760     0.200
     1.347    44.680     0.200
     0.777    23.977     0.200
     1.173    37.727     0.200
     1.271    40.715     0.200
     1.275    42.297     0.200
     1.333    42.375     0.200
     0.758    24.561     0.200
     1.225    38.910     0.200
     1.324    42.090     0.200
     1.354    44.621     0.200
     1.379    44.121     0.200
     1.432    45.480     0.200
     0.740    22.215     0.200
     1.205    38.184     0.200
     1.308    41.375     0.200
     1.362    43.355     0.200
     1.367    43.562     0.200
     1.418    44.934     0.200
     3.775   115.062     0.200
     0.052     3.113     0.200
     0.086     3.918     0.200
     0.333    10.285     0.200
     0.378    11.453     0.200
     0.639    20.758     0.200
     0.681    22.008     0.200
     0.914    27.648     0.200
     0.954    30.367     0.200
     0.973    31.238     0.200
     1.102    35.027     0.200
     1.126    35.660     0.200
     1.327    40.434     0.200
     0.203     5.578     0.200
     0.179     6.570     0.200
     0.216     7.984     0.200
     0.396    12.586     0.200
     0.674    21.883     0.200
     0.762    24.609     0.200
     0.912    28.219     0.200
     0.912    27.812     0.200
     0.867    27.578     0.200
     0.990    30.680     0.200
     0.990    30.086     0.200
     1.013    32.109     0.200
     1.086    34.469     0.200
     1.201    36.906     0.200
     1.234    39.383     0.200
     1.306    40.195     0.200
     1.257    40.070     0.200
     1.537    47.352     0.200
     1.532    47.906     0.200
     1.665    50.602     0.200
     2.254    69.945     0.200
     3.534   108.328     0.200
     3.759   116.094     0.200
     5.934   181.906     0.200
     6.350   195.359     0.200
     0.080     4.023     0.200
     0.535    16.586     0.200
     0.535    16.844     0.200
     0.640    20.656     0.200
     0.749    24.023     0.200
     0.950    30.320     0.200
     1.098    34.883     0.200
     1.121    35.555     0.200
     1.697    53.922     0.200
     0.625    19.662     0.200
     0.641    20.014     0.200
     0.725    22.074     0.200
     0.725    22.312     0.200
     1.033    31.555     0.200
     1.151    35.502     0.200
     1.392    43.682     0.200
     1.408    42.662     0.200
     2.189    64.961     0.200
     2.776    83.424     0.200
     2.800    84.193     0.200
     2.855    85.258     0.200
     2.899    87.672     0.200
     2.913    87.287     0.200
     3.102    93.195     0.200
     3.297    98.971     0.200
     3.573   106.096     0.200
     0.024     3.750     0.200
     0.075     5.031     0.200
     0.625    19.625     0.200
     0.650    20.422     0.200
     0.733    22.242     0.200
     0.991    32.203     0.200
     1.039    32.039     0.200
     1.151    37.094     0.200
     1.398    46.125     0.200
     1.577    48.438     0.200
     1.850    56.188     0.200
     1.960    59.953     0.200
     2.192    66.586     0.200
     2.444    74.086     0.200
     2.478    74.922     0.200
     2.785    83.656     0.200
     2.780    84.094     0.200
     2.780    84.484     0.200
     2.807    85.898     0.200
     0.046     4.281     0.200
     0.627    19.766     0.200
     0.726    22.055     0.200
     1.012    33.078     0.200
     1.139    35.969     0.200
     1.156    36.109     0.200
     1.354    40.734     0.200
     1.342    42.945     0.200
     1.384    43.727     0.200
     1.558    47.664     0.200
     1.701    52.227     0.200
     1.937    59.523     0.200
     2.090    63.297     0.200
     2.469    74.633     0.200
     0.642    20.128     0.200
     0.636    20.189     0.200
     0.683    21.976     0.200
     0.740    22.424     0.200
     0.999    31.856     0.200
     1.021    31.845     0.200
     1.134    36.696     0.200
     1.155    36.056     0.200
     1.331    41.456     0.200
     1.400    43.495     0.200
     1.400    47.356     0.200
     1.559    47.933     0.200
     1.715    52.829     0.200
     1.860    56.505     0.200
     1.943    59.882     0.200
     2.105    63.415     0.200
     2.248    69.183     0.200
     2.455    74.077     0.200
     2.644    81.188     0.200
     2.762    83.819     0.200
     2.789    84.329     0.200
     2.944    90.485     0.200
     0.045     3.930     0.200
     0.635    20.082     0.200
     0.628    20.090     0.200
     0.726    22.148     0.200
     1.011    33.020     0.200
     1.020    31.262     0.200
     1.140    36.219     0.200
     1.157    35.879     0.200
     1.352    40.582     0.200
     1.343    42.859     0.200
     1.386    44.039     0.200
     1.414    45.719     0.200
     1.560    47.875     0.200
     1.846    55.805     0.200
     1.939    59.422     0.200
     2.090    62.988     0.200
     2.196    66.652     0.200
     2.443    74.156     0.200
     2.469    74.855     0.200
     2.762    83.391     0.200
     2.940    90.430     0.200
     0.045     2.719     0.200
     0.473    15.949     0.200
     0.627    19.523     0.200
     0.641    20.332     0.200
     0.732    22.109     0.200
     1.010    33.090     0.200
     1.016    30.965     0.200
     1.134    36.191     0.200
     1.152    35.270     0.200
     1.201    36.477     0.200
     1.337    42.430     0.200
     1.359    40.578     0.200
     1.379    44.070     0.200
     1.411    43.281     0.200
     1.852    56.227     0.200
     1.936    59.438     0.200
     2.095    62.742     0.200
     2.203    66.738     0.200
     2.475    74.836     0.200
     2.758    83.180     0.200
     2.783    84.738     0.200
     2.883    88.680     0.200
     0.031     3.383     0.200
     0.031     3.533     0.200
     0.643    20.035     0.200
     0.626    19.225     0.200
     0.728    22.195     0.200
     0.998    32.453     0.200
     1.035    31.357     0.200
     1.344    40.729     0.200
     1.346    42.854     0.200
     1.390    44.043     0.200
     1.574    48.109     0.200
     1.846    55.795     0.200
     1.954    59.732     0.200
     2.094    62.631     0.200
     2.776    83.826     0.200
     2.802    85.176     0.200
     2.901    89.943     0.200
     2.956    89.873     0.200
     0.031     2.455     0.200
     0.632    20.123     0.200
     0.642    19.992     0.200
     0.659    21.565     0.200
     0.692    22.234     0.200
     0.734    21.975     0.200
     0.997    32.605     0.200
     1.031    31.557     0.200
     1.144    35.726     0.200
     1.165    36.235     0.200
     1.350    40.384     0.200
     1.339    42.755     0.200
     1.383    43.646     0.200
     1.852    56.314     0.200
     1.951    59.992     0.200
     2.197    67.017     0.200
     2.478    75.133     0.200
     2.772    84.579     0.200
     0.626    19.281     0.200
     0.643    20.109     0.200
     0.677    21.156     0.200
     0.736    24.211     0.200
     1.015    31.266     0.200
     1.133    36.203     0.200
     1.133    36.453     0.200
     1.151    36.398     0.200
     1.460    44.180     0.200
     1.411    44.875     0.200
     1.853    56.250     0.200
     2.096    62.930     0.200
     2.475    74.688     0.200
     2.756    82.727     0.200
     2.757    83.547     0.200
     2.782    84.547     0.200
     3.555   108.828     0.200
     0.729    24.944     0.200
     1.012    31.294     0.200
     1.466    44.094     0.200
     1.551    47.649     0.200
     1.709    52.208     0.200
     1.934    59.066     0.200
     2.102    62.849     0.200
     2.481    75.113     0.200
     2.754    83.560     0.200
     2.754    83.680     0.200
     2.780    84.125     0.200
     3.083    92.947     0.200
     3.281    99.268     0.200
     0.018     3.492     0.200
     0.018     3.992     0.200
     0.678    21.438     0.200
     0.635    20.266     0.200
     0.767    23.227     0.200
     1.053    32.656     0.200
     1.144    36.578     0.200
     1.179    36.484     0.200
     1.357    40.859     0.200
     1.499    45.445     0.200
     1.586    48.641     0.200
     1.607    48.609     0.200
     0.580    18.195     0.200
     0.744    23.156     0.200
     0.769    24.594     0.200
     0.752    25.758     0.200
     0.934    30.094     0.200
     1.203    36.750     0.200
     1.303    39.047     0.200
     1.561    46.984     0.200
     1.645    50.234     0.200
     2.026    60.234     0.200
     2.163    64.258     0.200
     0.198     5.419     0.200
     0.248     8.949     0.200
     1.122    35.849     0.200
     1.213    37.019     0.200
     1.177    38.079     0.200
     1.206    37.349     0.200
     1.206    38.799     0.200
     1.268    40.289     0.200
     3.027    92.239     0.200
     3.075    93.299     0.200
     0.060     2.734     0.200
     0.601    18.992     0.200
     0.774    23.703     0.200
     1.109    33.484     0.200
     1.187    37.109     0.200
     1.230    37.641     0.200
     1.330    41.633     0.200
     1.330    45.312     0.200
     1.587    48.250     0.200
     1.639    50.086     0.200
     1.879    56.969     0.200
     2.046    61.500     0.200
     2.146    64.438     0.200
     2.188    65.203     0.200
     4.507   139.281     0.200
     0.139     7.047     0.200
     0.652    20.219     0.200
     0.965    30.195     0.200
     1.013    31.164     0.200
     1.097    34.820     0.200
     1.324    41.891     0.200
     1.354    43.773     0.200
     1.354    44.000     0.200
     1.522    45.711     0.200
     1.541    47.508     0.200
     1.944    59.656     0.200
     2.130    64.055     0.200
     2.651    79.992     0.200
     2.748    82.305     0.200
     2.781    85.336     0.200
     3.092    93.680     0.200
     3.302    99.664     0.200
     3.533   106.523     0.200
     3.584   107.922     0.200
     0.481    15.660     0.200
     0.987    30.801     0.200
     0.997    31.531     0.200
     2.712    83.371     0.200
     2.765    82.711     0.200
     0.799    23.855     0.200
     0.799    24.319     0.200
     1.123    34.690     0.200
     1.187    37.556     0.200
     1.238    38.485     0.200
     1.537    46.832     0.200
     1.815    56.056     0.200
     2.054    63.483     0.200
     2.171    65.604     0.200
     2.856    85.728     0.200
     2.891    87.611     0.200
     2.981    90.858     0.200
     3.055    92.855     0.200
     3.791   116.386     0.200
     4.254   130.376     0.200
     0.265     9.289     0.200
     0.632    19.422     0.200
     1.088    35.359     0.200
     1.403    42.586     0.200
     2.671    80.551     0.200
     2.877    88.699     0.200
     2.914    89.457     0.200
     3.059    92.555     0.200
     4.216   131.180     0.200
     0.082     5.594     0.200
     0.086     5.633     0.200
     0.119     6.555     0.200
     0.499    15.914     0.200
     0.779    23.375     0.200
     1.089    33.734     0.200
     1.089    33.734     0.200
     1.167    36.906     0.200
     1.199    38.086     0.200
     1.210    37.719     0.200
     1.333    41.383     0.200
     1.333    43.367     0.200
     1.618    49.938     0.200
     2.150    64.758     0.200
     2.825    85.461     0.200
     2.857    86.039     0.200
     3.166    96.734     0.200
     0.090     4.665     0.200
     0.135     6.905     0.200
     0.084     5.605     0.200
     0.502    16.645     0.200
     0.793    23.925     0.200
     0.793    24.233     0.200
     1.098    34.139     0.200
     1.097    34.139     0.200
     1.167    36.745     0.200
     1.214    36.875     0.200
     1.316    40.435     0.200
     1.317    42.015     0.200
     2.831    85.381     0.200
     2.865    86.645     0.200
     3.811   117.085     0.200
     0.223     7.781     0.200
     0.226     7.730     0.200
     1.041    33.521     0.200
     1.124    35.891     0.200
     1.149    37.580     0.200
     1.150    36.791     0.200
     1.150    38.830     0.200
     1.150    39.920     0.200
     1.193    37.961     0.200
     1.223    37.111     0.200
     1.257    39.842     0.200
     1.697    51.580     0.200
     1.697    51.852     0.200
     3.045    92.121     0.200
     0.371    12.094     0.200
     0.371    12.570     0.200
     0.384    12.375     0.200
     0.381    13.961     0.200
     0.692    21.617     0.200
     0.692    21.617     0.200
     0.788    24.172     0.200
     0.778    24.320     0.200
     1.250    37.898     0.200
     1.294    40.461     0.200
     1.624    48.836     0.200
     2.439    74.047     0.200
     2.454    73.930     0.200
     2.601    78.430     0.200
     2.749    82.781     0.200
     0.253     7.578     0.200
     0.537    16.801     0.200
     0.536    16.801     0.200
     0.523    18.014     0.200
     0.709    22.404     0.200
     0.799    25.264     0.200
     0.918    28.178     0.200
     1.057    32.637     0.200
     1.385    42.725     0.200
     1.459    44.592     0.200
     1.671    52.113     0.200
     1.672    54.824     0.200
     1.811    56.105     0.200
     2.170    65.584     0.200
     2.408    73.004     0.200
     2.460    73.805     0.200
     2.607    79.137     0.200
     3.052    92.604     0.200
     3.081    95.174     0.200
     3.684   112.135     0.200
     0.149     6.971     0.200
     0.702    21.182     0.200
     0.832    27.160     0.200
     0.828    26.051     0.200
     0.861    27.309     0.200
     0.924    28.602     0.200
     1.333    40.801     0.200
     1.443    43.475     0.200
     1.448    46.182     0.200
     1.504    47.551     0.200
     2.075    61.297     0.200
     2.074    61.637     0.200
     5.343   165.980     0.200
     0.084     5.219     0.200
     0.035     4.320     0.200
     0.688    20.578     0.200
     0.784    24.211     0.200
     0.806    25.812     0.200
     0.806    26.430     0.200
     1.238    39.297     0.200
     1.426    43.391     0.200
     1.409    42.008     0.200
     1.409    43.727     0.200
     1.570    47.938     0.200
     2.060    62.414     0.200
     2.113    64.750     0.200
     2.870    86.797     0.200
     2.865    85.547     0.200
     2.865    85.547     0.200
     3.716   114.359     0.200
     0.101     5.336     0.200
     0.430    14.336     0.200
     0.494    16.211     0.200
     0.528    17.000     0.200
     1.017    31.500     0.200
     1.239    38.969     0.200
     1.321    42.117     0.200
     1.435    44.898     0.200
     1.449    47.352     0.200
     1.481    46.281     0.200
     0.022     4.627     0.200
     0.101     5.168     0.200
     0.416    13.238     0.200
     0.731    21.607     0.200
     0.784    26.047     0.200
     0.919    28.568     0.200
     1.692    52.072     0.200
     2.062    64.098     0.200
     2.896    88.002     0.200
     0.128     4.090     0.200
     0.142     4.859     0.200
     0.658    21.930     0.200
     0.734    23.621     0.200
     0.856    26.141     0.200
     1.137    36.629     0.200
     1.126    34.805     0.200
     1.161    36.570     0.200
     1.229    37.781     0.200
     1.249    39.070     0.200
     1.249    40.609     0.200
     1.275    40.551     0.200
     1.642    49.992     0.200
     1.643    51.055     0.200
     2.065    63.480     0.200
     0.129     4.799     0.200
     0.658    21.588     0.200
     0.856    25.510     0.200
     1.127    34.709     0.200
     1.137    36.289     0.200
     1.161    36.508     0.200
     1.248    38.898     0.200
     1.229    38.078     0.200
     1.249    39.529     0.200
     1.276    40.258     0.200
     1.334    41.959     0.200
     1.643    51.979     0.200
     2.066    63.459     0.200
     2.132    66.059     0.200
     2.853    86.195     0.200
     2.894    87.645     0.200
     3.213    97.416     0.200
     0.073     2.883     0.200
     0.784    23.652     0.200
     1.317    41.043     0.200
     1.646    50.988     0.200
     2.157    65.133     0.200
     0.144     4.742     0.200
     0.160     5.531     0.200
     0.289    10.359     0.200
     0.791    24.039     0.200
     0.873    27.133     0.200
     1.129    35.297     0.200
     1.227    38.117     0.200
     1.232    39.102     0.200
     1.384    43.016     0.200
     1.387    42.164     0.200
     1.652    51.539     0.200
     1.652    50.312     0.200
     1.611    49.742     0.200
     1.819    54.719     0.200
     2.137    66.430     0.200
     2.782    85.578     0.200
     0.162     5.297     0.200
     0.876    26.758     0.200
     1.135    35.234     0.200
     1.228    39.656     0.200
     1.252    40.945     0.200
     1.398    44.148     0.200
     2.306    71.102     0.200
     2.967    91.047     0.200
     3.031    91.383     0.200
     3.028    91.648     0.200
     3.096    93.172     0.200
     3.254    99.328     0.200
     3.299    99.438     0.200
     0.230     8.508     0.200
     0.190     7.469     0.200
     0.928    29.336     0.200
     1.149    37.117     0.200
     1.149    38.656     0.200
     1.349    41.289     0.200
     1.780    54.156     0.200
     1.976    61.781     0.200
     2.936    88.453     0.200
     2.970    90.508     0.200
     3.018    90.812     0.200
     3.344   102.164     0.200
     3.820   116.445     0.200
     3.888   120.953     0.200
     4.140   124.859     0.200
     4.415   136.773     0.200
     0.218     7.109     0.200
     1.163    36.844     0.200
     1.164    41.227     0.200
     1.169    36.500     0.200
     1.238    38.422     0.200
     1.261    38.641     0.200
     1.678    50.555     0.200
     1.715    53.836     0.200
     1.715    53.336     0.200
     2.123    64.477     0.200
     2.839    85.516     0.200
     2.890    87.438     0.200
     2.940    88.766     0.200
     3.073    95.234     0.200
     3.122    94.734     0.200
     3.269    99.320     0.200
     3.745   112.617     0.200
     0.202     6.141     0.200
     0.312    10.727     0.200
     1.087    34.398     0.200
     1.163    35.828     0.200
     1.230    39.148     0.200
     1.230    39.609     0.200
     1.527    45.758     0.200
     1.578    47.406     0.200
     0.312     9.625     0.200
     0.361    11.703     0.200
     0.654    19.703     0.200
     0.936    30.375     0.200
     0.968    30.016     0.200
     1.378    41.875     0.200
     1.378    41.266     0.200
     1.379    43.734     0.200
     1.802    54.750     0.200
     2.518    75.086     0.200
     2.587    78.727     0.200
     2.626    79.445     0.200
     2.948    88.523     0.200
     0.185     5.476     0.200
     0.488    16.806     0.200
     0.964    31.836     0.200
     0.964    31.026     0.200
     1.512    46.123     0.200
     1.573    48.526     0.200
     1.888    58.396     0.200
     1.993    61.426     0.200
     3.148    96.414     0.200
     3.205    97.736     0.200
     3.267    99.358     0.200
     3.460   107.216     0.200
     0.888    27.783     0.200
     1.057    32.802     0.200
     1.156    35.543     0.200
     1.264    42.583     0.200
     1.264    41.573     0.200
     1.585    48.783     0.200
     1.998    61.452     0.200
     2.240    68.289     0.200
     2.337    71.764     0.200
     2.712    81.839     0.200
     2.780    83.207     0.200
     2.822    85.047     0.200
     3.145    95.364     0.200
     3.368   102.482     0.200
     3.621   108.764     0.200
     4.219   127.905     0.200
     0.226     5.837     0.200
     0.720    22.718     0.200
     1.028    31.631     0.200
     1.045    33.107     0.200
     1.045    33.537     0.200
     1.118    34.277     0.200
     1.246    39.817     0.200
     1.534    46.108     0.200
     1.975    59.931     0.200
     2.247    70.299     0.200
     2.692    80.725     0.200
     2.718    83.236     0.200
     2.745    83.404     0.200
     2.791    83.955     0.200
     2.924    89.477     0.200
     2.973    89.757     0.200
     3.120    94.769     0.200
     3.596   107.690     0.200
     3.596   109.317     0.200
     4.206   129.698     0.200
     4.205   126.917     0.200
     0.148     5.271     0.200
     0.272     8.361     0.200
     1.105    35.851     0.200
     1.105    37.721     0.200
     1.224    38.871     0.200
     1.224    38.621     0.200
     1.717    51.907     0.200
     1.797    55.500     0.200
     2.204    67.287     0.200
     2.348    71.377     0.200
     2.962    89.113     0.200
     3.016    90.546     0.200
     3.153    96.401     0.200
     3.201    96.431     0.200
     3.825   114.125     0.200
     0.927    28.419     0.200
     1.155    36.929     0.200
     1.227    37.339     0.200
     1.756    52.389     0.200
     2.068    63.229     0.200
     2.171    66.595     0.200
     2.254    68.459     0.200
     2.300    69.337     0.200
     2.558    77.352     0.200
     2.885    88.078     0.200
     2.885    87.149     0.200
     2.942    89.161     0.200
     2.990    90.178     0.200
     3.120    95.199     0.200
     3.170    96.379     0.200
     3.317   100.744     0.200
     3.541   108.025     0.200
     3.770   114.509     0.200
     6.096   188.619     0.200
     0.366    11.110     0.200
     0.646    19.846     0.200
     0.784    24.314     0.200
     0.816    24.714     0.200
     0.909    27.485     0.200
     1.188    36.219     0.200
     1.182    36.059     0.200
     1.583    48.483     0.200
     1.549    47.054     0.200
     1.549    49.944     0.200
     1.550    48.804     0.200
     2.298    69.358     0.200
     2.567    78.644     0.200
     3.205    97.514     0.200
     3.815   116.514     0.200
     5.613   169.914     0.200
     0.473    14.333     0.200
     0.601    17.937     0.200
     0.778    24.144     0.200
     0.876    26.400     0.200
     0.893    28.236     0.200
     0.893    28.396     0.200
     1.131    34.496     0.200
     1.305    39.477     0.200
     1.450    45.116     0.200
     1.451    46.006     0.200
     2.448    77.176     0.200
     2.432    73.094     0.200
     2.545    76.449     0.200
     2.666    81.096     0.200
     2.716    82.026     0.200
     2.864    86.249     0.200
     2.977    89.541     0.200
     2.967    91.096     0.200
     3.091    92.799     0.200
     3.339    99.694     0.200
     3.339   102.316     0.200
     3.945   120.596     0.200
     0.602    18.525     0.200
     0.752    23.408     0.200
     0.781    24.519     0.200
     0.913    27.568     0.200
     1.145    34.966     0.200
     1.304    40.578     0.200
     1.594    50.158     0.200
     1.595    50.358     0.200
     2.249    67.383     0.200
     2.344    70.676     0.200
     2.484    75.358     0.200
     2.535    75.438     0.200
     3.157    97.719     0.200
     3.766   114.419     0.200
     6.581   198.959     0.200
     0.930    28.498     0.200
     1.181    36.506     0.200
     1.173    36.628     0.200
     1.164    37.367     0.200
     1.266    39.117     0.200
     1.683    51.631     0.200
     2.114    65.317     0.200
     2.127    64.987     0.200
     2.895    87.560     0.200
     2.944    88.895     0.200
     3.077    94.388     0.200
     3.126    95.817     0.200
     3.814   117.888     0.200
     4.293   132.688     0.200
     4.638   143.258     0.200
     0.969    30.285     0.200
     1.388    43.465     0.200
     1.798    54.464     0.200
     2.513    75.460     0.200
     2.586    78.387     0.200
     2.624    78.777     0.200
     2.747    84.115     0.200
     2.797    85.445     0.200
     2.945    89.362     0.200
     3.041    93.896     0.200
     3.172    94.887     0.200
     3.420   102.740     0.200
     3.420   105.096     0.200
     4.026   125.235     0.200
     4.044   124.896     0.200
     1.033    33.928     0.200
     1.367    43.168     0.200
     1.367    42.229     0.200
     1.419    43.252     0.200
     1.490    46.279     0.200
     1.909    58.018     0.200
     1.956    58.578     0.200
     2.368    72.467     0.200
     3.084    93.666     0.200
     3.073    93.174     0.200
     3.121    94.662     0.200
     3.178    96.318     0.200
     3.257    97.441     0.200
     3.365   101.439     0.200
     5.425   163.098     0.200
     6.204   189.109     0.200
     0.320     9.660     0.200
     0.600    18.510     0.200
     0.751    23.400     0.200
     1.136    34.611     0.200
     1.144    34.678     0.200
     1.307    41.102     0.200
     1.597    48.170     0.200
     2.247    67.193     0.200
     2.368    71.170     0.200
     0.321    10.467     0.200
     0.871    26.182     0.200
     1.114    35.316     0.200
     1.083    33.475     0.200
     1.252    40.717     0.200
     1.596    48.475     0.200
     1.610    50.186     0.200
     1.606    47.979     0.200
     1.863    57.141     0.200
     2.025    62.564     0.200
     2.241    67.557     0.200
     2.738    83.350     0.200
     2.807    84.621     0.200
     2.849    86.219     0.200
     2.781    80.996     0.200
     3.172    96.344     0.200
     3.647   108.961     0.200
     0.567    17.895     0.200
     0.733    22.574     0.200
     0.809    25.602     0.200
     1.089    33.922     0.200
     1.118    33.973     0.200
     1.644    49.824     0.200
     2.204    66.562     0.200
     2.312    70.000     0.200
     2.333    70.594     0.200
     2.441    74.223     0.200
     0.313     9.348     0.200
     0.449    16.023     0.200
     0.606    18.867     0.200
     0.761    23.594     0.200
     0.898    27.613     0.200
     1.153    35.262     0.200
     1.536    48.074     0.200
     1.603    49.055     0.200
     2.249    68.820     0.200
     0.194     5.836     0.200
     0.237     8.465     0.200
     0.624    20.473     0.200
     0.732    22.215     0.200
     0.945    28.965     0.200
     1.082    34.684     0.200
     1.145    36.223     0.200
     1.145    35.984     0.200
     1.145    38.863     0.200
     1.188    36.945     0.200
     1.188    37.234     0.200
     1.204    37.070     0.200
     1.244    39.223     0.200
     1.285    39.184     0.200
     1.312    41.555     0.200
     1.703    52.000     0.200
     1.742    52.949     0.200
     2.150    66.059     0.200
     2.867    86.672     0.200
     2.915    87.891     0.200
     2.965    89.645     0.200
     3.296   100.082     0.200
     3.772   112.828     0.200
     0.156     4.377     0.200
     0.683    20.787     0.200
     0.656    22.057     0.200
     1.115    34.927     0.200
     1.100    35.697     0.200
     1.115    36.737     0.200
     1.115    37.827     0.200
     1.115    39.217     0.200
     1.242    39.047     0.200
     1.274    40.597     0.200
     1.347    42.137     0.200
     1.764    53.126     0.200
     2.213    68.261     0.200
     2.929    89.439     0.200
     2.976    90.749     0.200
     3.028    91.568     0.200
     3.163    96.447     0.200
     3.359   102.267     0.200
     0.134     5.047     0.200
     0.984    31.377     0.200
     1.056    33.248     0.200
     1.056    33.417     0.200
     1.056    37.447     0.200
     1.132    35.907     0.200
     1.330    41.137     0.200
     1.343    40.797     0.200
     1.343    41.637     0.200
     1.343    43.407     0.200
     1.387    43.189     0.200
     1.461    44.387     0.200
     1.880    57.304     0.200
     1.921    58.978     0.200
     2.334    71.610     0.200
     3.050    92.373     0.200
     3.092    93.837     0.200
     3.147    95.116     0.200
     3.332   101.188     0.200
     3.480   105.483     0.200
     3.674   113.467     0.200
     3.706   112.457     0.200
     3.956   118.624     0.200
     6.218   191.377     0.200
     0.127     4.596     0.200
     0.315     9.366     0.200
     0.629    20.716     0.200
     0.758    23.024     0.200
     0.855    25.986     0.200
     0.870    26.416     0.200
     1.093    33.787     0.200
     1.113    35.576     0.200
     1.123    35.356     0.200
     1.192    36.706     0.200
     1.245    39.326     0.200
     1.606    49.201     0.200
     1.866    56.919     0.200
     2.034    62.557     0.200
     2.747    83.225     0.200
     2.793    84.804     0.200
     2.816    85.142     0.200
     2.859    86.677     0.200
     3.181    96.714     0.200
     3.402   103.810     0.200
     3.656   110.102     0.200
     3.656   111.946     0.200
     4.204   129.016     0.200
     5.490   169.776     0.200
     7.063   218.646     0.200
     0.273     9.009     0.200
     0.353    11.102     0.200
     0.636    19.785     0.200
     0.681    22.329     0.200
     0.778    24.199     0.200
     0.817    25.179     0.200
     0.906    27.518     0.200
     1.162    36.779     0.200
     1.175    35.903     0.200
     1.562    48.409     0.200
     1.563    51.999     0.200
     2.286    68.576     0.200
     2.521    76.919     0.200
     2.571    77.379     0.200
     6.618   201.049     0.200
     0.249     8.555     0.200
     0.299     8.895     0.200
     0.588    18.398     0.200
     0.727    23.395     0.200
     0.802    25.242     0.200
     0.905    27.555     0.200
     1.201    37.984     0.200
     1.201    38.441     0.200
     1.201    38.715     0.200
     1.326    40.805     0.200
     1.618    51.473     0.200
     1.870    57.199     0.200
     2.230    67.422     0.200
     2.332    69.984     0.200
     0.220     6.715     0.200
     0.216     7.816     0.200
     0.604    20.207     0.200
     0.759    23.316     0.200
     0.765    24.047     0.200
     0.850    25.883     0.200
     1.070    33.727     0.200
     1.160    38.066     0.200
     1.160    40.766     0.200
     1.154    35.285     0.200
     1.154    36.355     0.200
     1.166    36.219     0.200
     1.224    38.727     0.200
     1.249    37.957     0.200
     1.289    40.746     0.200
     1.666    50.238     0.200
     1.708    51.008     0.200
     2.133    64.938     0.200
     2.133    65.836     0.200
     2.114    65.270     0.200
     2.830    85.789     0.200
     2.843    86.988     0.200
     2.878    87.383     0.200
     2.928    88.887     0.200
     0.155     6.332     0.200
     1.004    32.102     0.200
     1.073    32.645     0.200
     1.063    35.133     0.200
     1.063    34.551     0.200
     1.063    34.102     0.200
     1.153    36.953     0.200
     1.367    43.121     0.200
     1.406    43.312     0.200
     1.901    58.242     0.200
     2.352    72.863     0.200
     3.070    93.184     0.200
     3.114    94.633     0.200
     3.167    95.887     0.200
     0.293     9.969     0.200
     0.344    10.352     0.200
     0.649    20.125     0.200
     0.798    24.727     0.200
     0.882    26.766     0.200
     0.882    26.516     0.200
     1.181    38.086     0.200
     1.192    36.266     0.200
     1.197    38.211     0.200
     1.205    38.375     0.200
     1.268    38.820     0.200
     1.571    50.000     0.200
     2.292    69.062     0.200
     2.529    77.078     0.200
     2.728    82.258     0.200
     2.924    87.148     0.200
     2.951    88.906     0.200
     3.805   117.891     0.200
     1.001    34.661     0.200
     1.411    43.781     0.200
     1.475    46.873     0.200
     1.542    48.932     0.200
     3.421   105.582     0.200
     0.181     6.814     0.200
     0.261     7.893     0.200
     0.261     8.006     0.200
     0.486    15.312     0.200
     0.656    20.486     0.200
     0.896    27.125     0.200
     1.026    31.977     0.200
     1.038    31.965     0.200
     1.416    43.582     0.200
     1.414    43.695     0.200
     1.685    52.314     0.200
     2.132    64.457     0.200
     2.171    65.838     0.200
     2.253    69.127     0.200
     2.564    77.670     0.200
     2.794    84.969     0.200
     0.116     4.342     0.200
     0.530    16.771     0.200
     1.001    32.312     0.200
     1.018    31.512     0.200
     1.001    33.201     0.200
     1.001    34.422     0.200
     1.001    34.861     0.200
     1.109    33.672     0.200
     1.316    42.002     0.200
     1.357    42.383     0.200
     1.424    44.008     0.200
     1.908    58.695     0.200
     1.969    60.537     0.200
     2.374    72.754     0.200
     3.067    93.037     0.200
     3.093    93.898     0.200
     3.120    94.555     0.200
     3.179    96.100     0.200
     0.165     7.594     0.200
     0.193     6.664     0.200
     0.210     7.633     0.200
     0.218     6.914     0.200
     0.294    10.828     0.200
     0.363    13.242     0.200
     0.454    15.703     0.200
     0.610    20.477     0.200
     1.077    34.664     0.200
     1.166    36.586     0.200
     1.158    36.695     0.200
     1.166    37.641     0.200
     1.166    40.438     0.200
     1.230    39.344     0.200
     1.295    40.914     0.200
     1.620    49.703     0.200
     2.033    61.961     0.200
     0.210     6.730     0.200
     0.209     7.010     0.200
     0.223     9.010     0.200
     1.170    35.240     0.200
     1.170    39.770     0.200
     1.175    36.740     0.200
     1.175    37.480     0.200
     1.265    38.860     0.200
     1.714    52.095     0.200
     2.113    64.227     0.200
     2.125    65.440     0.200
     2.280    68.847     0.200
     2.466    75.548     0.200
     2.575    78.296     0.200
     4.449   135.190     0.200
     0.286     8.644     0.200
     0.274     9.029     0.200
     0.455    15.259     0.200
     0.538    17.269     0.200
     0.604    18.674     0.200
     0.769    23.749     0.200
     1.156    35.233     0.200
     1.228    38.629     0.200
     1.226    38.899     0.200
     1.223    38.349     0.200
     1.329    41.749     0.200
     1.526    46.599     0.200
     1.629    48.459     0.200
     1.629    48.599     0.200
     2.474    74.399     0.200
     2.527    75.899     0.200
     3.148    95.719     0.200
     3.746   114.719     0.200
     3.913   120.729     0.200
     4.220   130.379     0.200
     6.560   202.199     0.200
     0.270     9.047     0.200
     0.352    10.961     0.200
     0.422    14.699     0.200
     0.633    19.504     0.200
     0.746    23.348     0.200
     0.776    23.848     0.200
     1.172    35.461     0.200
     1.162    36.918     0.200
     1.175    37.258     0.200
     1.181    37.289     0.200
     1.270    39.016     0.200
     2.284    68.621     0.200
     2.402    72.465     0.200
     2.518    76.309     0.200
     2.716    81.719     0.200
     0.205     7.230     0.200
     0.205     5.160     0.200
     0.207     5.559     0.200
     0.227     5.980     0.200
     0.765    23.281     0.200
     0.850    25.910     0.200
     1.175    36.109     0.200
     1.172    36.680     0.200
     1.172    37.289     0.200
     1.174    38.828     0.200
     2.120    65.289     0.200
     2.115    65.688     0.200
     2.294    69.492     0.200
     2.835    86.262     0.200
     2.858    86.594     0.200
     2.890    87.070     0.200
     2.938    88.914     0.200
     3.106    92.723     0.200
     3.119    94.289     0.200
     3.266    98.699     0.200
     3.742   112.062     0.200
     4.283   130.852     0.200
     4.343   134.988     0.200
     6.353   196.012     0.200
     0.134     5.643     0.200
     0.134     6.203     0.200
     0.188     6.493     0.200
     0.332    11.293     0.200
     0.604    19.993     0.200
     0.663    21.203     0.200
     0.734    22.713     0.200
     0.872    27.743     0.200
     1.059    32.630     0.200
     1.086    33.833     0.200
     1.086    34.853     0.200
     1.091    34.613     0.200
     1.155    35.743     0.200
     1.217    38.343     0.200
     1.252    38.383     0.200
     1.252    39.393     0.200
     1.270    39.873     0.200
     1.570    47.888     0.200
     1.592    49.433     0.200
     2.002    61.357     0.200
     2.252    67.730     0.200
     2.717    82.101     0.200
     2.756    83.650     0.200
     2.780    83.911     0.200
     2.824    84.921     0.200
     0.213     7.424     0.200
     0.240     6.984     0.200
     0.854    26.576     0.200
     0.955    29.088     0.200
     1.148    35.744     0.200
     1.148    39.334     0.200
     1.148    36.543     0.200
     1.144    35.465     0.200
     1.144    36.014     0.200
     1.163    35.502     0.200
     1.694    51.758     0.200
     1.660    50.814     0.200
     1.710    52.652     0.200
     1.710    52.914     0.200
     2.112    65.020     0.200
     2.328    70.539     0.200
     2.612    79.084     0.200
     2.830    85.963     0.200
     2.834    85.611     0.200
     2.872    87.066     0.200
     2.924    88.727     0.200
     3.062    94.334     0.200
     3.109    93.684     0.200
     3.257    98.453     0.200
     3.490   105.539     0.200
     3.846   118.074     0.200
     0.157     5.227     0.200
     0.304    10.500     0.200
     0.762    23.594     0.200
     1.081    32.852     0.200
     1.095    34.992     0.200
     1.076    34.430     0.200
     1.172    36.102     0.200
     1.209    38.109     0.200
     1.225    38.289     0.200
     1.225    39.219     0.200
     1.225    40.820     0.200
     1.265    39.828     0.200
     1.587    48.625     0.200
     1.619    49.898     0.200
     1.890    57.836     0.200
     2.026    62.297     0.200
     2.196    66.945     0.200
     2.273    68.992     0.200
     2.568    78.469     0.200
     2.742    83.359     0.200
     2.798    84.758     0.200
     3.025    92.047     0.200
     3.172    96.023     0.200
     3.400   103.367     0.200
     3.885   118.109     0.200
     4.252   130.711     0.200
     0.220     6.117     0.200
     0.226     7.469     0.200
     0.206     7.086     0.200
     0.635    20.859     0.200
     0.876    27.375     0.200
     1.095    35.312     0.200
     1.158    35.625     0.200
     1.158    37.508     0.200
     1.158    38.242     0.200
     1.158    39.617     0.200
     1.158    35.484     0.200
     1.201    36.781     0.200
     1.193    36.516     0.200
     1.193    37.055     0.200
     1.255    40.195     0.200
     1.286    39.367     0.200
     1.322    41.562     0.200
     1.703    52.492     0.200
     1.735    53.688     0.200
     1.735    53.320     0.200
     2.147    66.672     0.200
     2.862    87.039     0.200
     3.145    95.398     0.200
     0.271     9.051     0.200
     0.298     9.211     0.200
     0.533    17.648     0.200
     0.607    18.973     0.200
     0.734    23.520     0.200
     0.769    24.031     0.200
     0.832    26.480     0.200
     0.832    26.371     0.200
     1.157    35.176     0.200
     1.211    38.230     0.200
     1.216    38.051     0.200
     1.218    37.988     0.200
     1.319    40.730     0.200
     1.533    46.789     0.200
     1.617    49.109     0.200
     1.617    50.980     0.200
     1.618    51.531     0.200
     1.879    57.203     0.200
     2.243    67.594     0.200
     2.352    70.812     0.200
     2.448    74.992     0.200
     2.533    75.359     0.200
     2.681    80.590     0.200
     2.901    87.699     0.200
     3.155    94.574     0.200
     0.125     5.090     0.200
     0.160     5.680     0.200
     0.315    10.598     0.200
     0.633    20.930     0.200
     0.701    22.078     0.200
     0.759    23.109     0.200
     0.867    26.508     0.200
     1.116    36.000     0.200
     1.096    33.938     0.200
     1.127    35.590     0.200
     1.195    36.816     0.200
     1.250    38.410     0.200
     1.251    42.637     0.200
     1.251    39.387     0.200
     1.249    39.527     0.200
     1.609    49.238     0.200
     1.619    50.090     0.200
     2.036    62.500     0.200
     2.166    66.500     0.200
     2.238    67.184     0.200
     2.748    83.734     0.200
     2.796    83.086     0.200
     2.819    84.781     0.200
     2.862    85.871     0.200
     3.036    92.699     0.200
     3.183    96.898     0.200
     3.851   115.988     0.200
     3.851   118.047     0.200
     0.272     9.488     0.200
     0.450    15.059     0.200
     0.607    18.871     0.200
     0.736    23.559     0.200
     0.769    24.020     0.200
     0.793    25.047     0.200
     0.834    26.078     0.200
     1.157    35.492     0.200
     1.214    38.758     0.200
     1.218    38.668     0.200
     1.220    38.949     0.200
     1.320    40.727     0.200
     1.361    41.355     0.200
     1.532    47.211     0.200
     1.619    51.449     0.200
     1.619    49.637     0.200
     1.877    57.254     0.200
     2.242    67.895     0.200
     2.480    75.406     0.200
     2.532    75.457     0.200
     3.154    95.598     0.200
     0.144     6.211     0.200
     0.288     9.281     0.200
     0.846    26.695     0.200
     1.100    34.273     0.200
     1.215    38.961     0.200
     1.215    38.641     0.200
     1.215    37.172     0.200
     1.324    40.070     0.200
     1.699    51.883     0.200
     1.743    52.820     0.200
     1.794    54.375     0.200
     2.075    63.430     0.200
     2.111    65.102     0.200
     2.119    65.000     0.200
     2.158    66.109     0.200
     2.765    84.812     0.200
     2.955    89.398     0.200
     3.181    97.562     0.200
     3.820   113.656     0.200
     0.145     5.215     0.200
     0.415    13.137     0.200
     0.573    18.066     0.200
     1.008    32.027     0.200
     1.049    34.027     0.200
     1.049    32.285     0.200
     1.049    36.426     0.200
     1.049    32.277     0.200
     1.143    37.008     0.200
     1.345    42.457     0.200
     1.365    41.836     0.200
     1.365    43.508     0.200
     1.411    43.156     0.200
     1.428    44.648     0.200
     1.904    58.207     0.200
     2.386    72.480     0.200
     3.171    96.492     0.200
     0.153     5.094     0.200
     0.399    13.305     0.200
     0.590    18.555     0.200
     0.998    31.523     0.200
     1.065    35.145     0.200
     1.065    34.465     0.200
     1.065    34.516     0.200
     1.065    36.473     0.200
     1.041    32.723     0.200
     1.151    36.805     0.200
     1.349    42.766     0.200
     1.361    42.895     0.200
     1.361    43.184     0.200
     1.400    43.457     0.200
     1.432    44.945     0.200
     1.934    57.004     0.200
     0.158     4.594     0.200
     0.406    13.582     0.200
     0.406    14.672     0.200
     0.586    18.523     0.200
     1.007    31.914     0.200
     1.064    34.473     0.200
     1.065    34.613     0.200
     1.065    37.773     0.200
     1.156    36.980     0.200
     1.356    43.371     0.200
     1.370    43.602     0.200
     1.370    44.293     0.200
     1.409    43.262     0.200
     1.439    45.512     0.200
     2.355    72.777     0.200
     3.069    93.820     0.200
     3.117    95.832     0.200
     3.170    96.168     0.200
     3.501   106.195     0.200
     3.724   112.246     0.200
     3.977   119.285     0.200
     0.142     5.262     0.200
     0.305    11.020     0.200
     0.884    27.551     0.200
     1.100    36.223     0.200
     1.100    35.109     0.200
     1.100    35.301     0.200
     1.099    34.832     0.200
     1.100    35.781     0.200
     1.256    40.262     0.200
     1.256    39.141     0.200
     1.256    38.723     0.200
     1.278    40.430     0.200
     1.353    42.551     0.200
     1.823    56.871     0.200
     0.152     5.402     0.200
     0.188     5.992     0.200
     0.607    20.902     0.200
     0.700    22.250     0.200
     0.739    23.512     0.200
     0.895    27.633     0.200
     1.089    35.180     0.200
     1.097    33.852     0.200
     1.113    35.191     0.200
     1.190    37.102     0.200
     1.224    38.883     0.200
     1.225    37.602     0.200
     1.225    38.852     0.200
     1.225    39.621     0.200
     1.282    40.691     0.200
     1.605    49.188     0.200
     2.041    62.375     0.200
     2.266    68.977     0.200
     2.299    69.730     0.200
     2.789    84.434     0.200
     2.816    85.223     0.200
     2.862    86.859     0.200
     0.146     7.057     0.200
     0.302    11.526     0.200
     0.338    11.007     0.200
     0.702    23.207     0.200
     0.933    30.187     0.200
     1.094    35.217     0.200
     1.094    35.736     0.200
     1.094    37.667     0.200
     1.130    35.927     0.200
     1.305    41.106     0.200
     1.305    40.807     0.200
     1.317    41.207     0.200
     1.394    43.937     0.200
     3.230    99.986     0.200
     3.279   100.247     0.200
     3.700   113.407     0.200
     4.500   137.457     0.200
     6.193   191.047     0.200
     6.238   191.057     0.200
     0.210     7.389     0.200
     0.210     7.537     0.200
     0.534    16.614     0.200
     0.522    16.777     0.200
     0.699    21.867     0.200
     0.780    24.277     0.200
     0.851    26.268     0.200
     1.191    37.327     0.200
     1.197    37.897     0.200
     1.211    38.308     0.200
     1.373    41.728     0.200
     1.373    44.058     0.200
     1.464    44.236     0.200
     1.653    50.428     0.200
     1.654    52.638     0.200
     2.178    65.739     0.200
     2.301    69.331     0.200
     2.413    73.167     0.200
     2.464    74.138     0.200
     2.611    78.983     0.200
     2.839    85.556     0.200
     3.086    92.994     0.200
     3.487   105.333     0.200
     3.695   112.587     0.200
     3.876   118.348     0.200
     5.635   171.058     0.200
     6.511   198.218     0.200
     0.279     9.898     0.200
     0.369    12.367     0.200
     0.401    13.547     0.200
     0.432    13.566     0.200
     0.784    24.016     0.200
     0.898    28.430     0.200
     0.898    28.648     0.200
     1.120    35.449     0.200
     1.173    37.559     0.200
     1.197    37.898     0.200
     1.320    40.367     0.200
     1.320    40.480     0.200
     1.311    39.723     0.200
     1.447    44.367     0.200
     1.447    43.328     0.200
     1.448    46.348     0.200
     1.448    48.238     0.200
     1.723    52.910     0.200
     2.074    64.055     0.200
     2.437    73.387     0.200
     2.552    76.945     0.200
     2.640    81.527     0.200
     2.722    83.238     0.200
     2.870    86.852     0.200
     3.097    94.078     0.200
     0.247     8.309     0.200
     0.256     8.484     0.200
     0.299     9.000     0.200
     0.469    16.719     0.200
     0.554    17.980     0.200
     0.587    18.094     0.200
     0.727    23.492     0.200
     1.115    34.352     0.200
     1.200    37.820     0.200
     1.200    37.980     0.200
     1.201    37.781     0.200
     1.516    46.023     0.200
     1.619    49.398     0.200
     2.228    67.426     0.200
     2.354    71.867     0.200
     2.664    80.652     0.200
     2.888    87.051     0.200
     0.252     8.434     0.200
     0.299     9.129     0.200
     0.557    17.715     0.200
     0.583    18.012     0.200
     1.114    33.965     0.200
     1.130    34.246     0.200
     1.197    37.746     0.200
     1.197    38.266     0.200
     1.199    37.926     0.200
     1.199    39.086     0.200
     1.619    49.465     0.200
     1.620    51.195     0.200
     1.620    51.785     0.200
     1.620    53.227     0.200
     2.226    67.094     0.200
     2.351    70.742     0.200
     2.661    80.422     0.200
     2.886    87.066     0.200
     3.102    93.566     0.200
     3.135    94.441     0.200
     0.122     4.230     0.200
     0.122     4.629     0.200
     0.155     5.348     0.200
     0.638    21.141     0.200
     0.704    22.617     0.200
     1.131    35.758     0.200
     1.131    35.867     0.200
     1.199    37.238     0.200
     1.254    38.719     0.200
     1.254    42.391     0.200
     1.254    43.180     0.200
     1.619    49.660     0.200
     1.619    51.020     0.200
     2.162    63.988     0.200
     0.220     7.008     0.200
     0.217     7.578     0.200
     0.280     8.496     0.200
     0.546    16.992     0.200
     0.709    22.238     0.200
     0.929    28.867     0.200
     1.037    32.172     0.200
     1.080    33.047     0.200
     1.362    43.258     0.200
     1.645    51.539     0.200
     1.645    52.680     0.200
     1.646    55.367     0.200
     1.646    51.098     0.200
     2.623    80.359     0.200
     0.161     5.895     0.200
     0.234     7.015     0.200
     0.568    19.245     0.200
     0.600    18.575     0.200
     0.600    18.715     0.200
     0.910    27.695     0.200
     0.903    26.845     0.200
     1.025    32.314     0.200
     1.025    33.334     0.200
     1.268    40.774     0.200
     1.269    40.245     0.200
     1.269    41.435     0.200
     2.270    71.274     0.200
     2.894    89.375     0.200
     2.942    89.015     0.200
     3.953   121.485     0.200
     4.174   129.035     0.200
     4.185   128.215     0.200
     0.182     5.938     0.200
     0.782    24.508     0.200
     0.805    25.008     0.200
     0.805    25.109     0.200
     1.140    35.145     0.200
     1.152    35.770     0.200
     1.152    36.277     0.200
     1.208    37.996     0.200
     1.208    37.359     0.200
     1.232    37.746     0.200
     1.247    39.438     0.200
     1.308    41.449     0.200
     1.669    51.316     0.200
     2.830    85.863     0.200
     2.859    86.789     0.200
     2.904    87.844     0.200
     2.975    89.578     0.200
     3.705   111.672     0.200
     0.440    14.793     0.200
     0.553    18.312     0.200
     1.037    34.551     0.200
     1.037    34.031     0.200
     1.037    36.223     0.200
     1.035    32.852     0.200
     1.152    36.863     0.200
     1.358    42.742     0.200
     1.388    43.512     0.200
     1.444    44.863     0.200
     1.511    46.672     0.200
     3.335   102.531     0.200
     0.140     5.418     0.200
     0.192     6.889     0.200
     0.564    19.088     0.200
     0.666    21.008     0.200
     0.764    24.088     0.200
     1.413    43.488     0.200
     1.687    53.357     0.200
     1.688    53.219     0.200
     2.421    71.408     0.200
     0.138     5.584     0.200
     0.196     7.174     0.200
     0.273     8.131     0.200
     0.517    16.148     0.200
     0.682    21.193     0.200
     0.682    21.434     0.200
     1.385    43.424     0.200
     1.385    44.283     0.200
     1.448    44.297     0.200
     2.163    64.852     0.200
     2.284    68.832     0.200
     2.595    78.986     0.200
     2.825    85.082     0.200
     3.035    91.316     0.200
     3.070    93.428     0.200
     3.681   111.242     0.200
     0.253     8.500     0.200
     0.247     8.578     0.200
     0.477    16.930     0.200
     0.561    18.891     0.200
     0.579    17.945     0.200
     0.742    22.969     0.200
     0.903    27.703     0.200
     1.209    38.492     0.200
     1.211    38.617     0.200
     1.506    46.602     0.200
     1.631    48.930     0.200
     1.632    49.203     0.200
     1.857    57.383     0.200
     2.218    67.219     0.200
     2.324    70.398     0.200
     2.346    71.391     0.200
     2.654    80.250     0.200
     2.768    85.133     0.200
     2.877    86.930     0.200
     3.128    94.328     0.200
     3.222    98.461     0.200
     3.731   114.391     0.200
     0.234     8.242     0.200
     0.478    15.242     0.200
     0.563    18.812     0.200
     0.577    17.891     0.200
     0.919    28.016     0.200
     1.190    37.992     0.200
     1.192    37.992     0.200
     1.330    40.539     0.200
     1.616    49.312     0.200
     1.618    54.078     0.200
     0.133     5.075     0.200
     0.228     7.735     0.200
     0.569    17.655     0.200
     0.572    18.336     0.200
     0.725    22.455     0.200
     0.723    23.336     0.200
     1.187    37.476     0.200
     1.189    37.726     0.200
     1.194    38.115     0.200
     1.337    43.306     0.200
     1.500    46.194     0.200
     1.622    49.495     0.200
     1.623    48.525     0.200
     1.623    51.726     0.200
     1.859    57.734     0.200
     2.215    66.671     0.200
     2.312    69.846     0.200
     2.450    75.275     0.200
     2.496    76.705     0.200
     2.500    75.346     0.200
     2.775    85.125     0.200
     2.876    86.632     0.200
     3.123    96.476     0.200
     3.910   121.216     0.200
     5.538   167.985     0.200
     5.625   172.115     0.200
     0.134     5.096     0.200
     0.198     6.725     0.200
     0.200     7.145     0.200
     0.685    21.244     0.200
     1.189    37.645     0.200
     1.197    37.824     0.200
     1.215    38.785     0.200
     1.386    42.805     0.200
     1.664    51.686     0.200
     1.665    53.074     0.200
     2.397    73.016     0.200
     2.448    73.266     0.200
     0.230     7.037     0.200
     0.233     7.367     0.200
     0.622    21.168     0.200
     0.622    20.928     0.200
     0.737    22.967     0.200
     0.797    24.977     0.200
     1.082    35.037     0.200
     1.149    37.438     0.200
     1.149    40.477     0.200
     1.184    36.977     0.200
     1.198    37.344     0.200
     1.243    39.807     0.200
     1.280    39.396     0.200
     1.310    41.057     0.200
     1.698    51.416     0.200
     1.736    53.672     0.200
     2.145    66.203     0.200
     2.315    71.180     0.200
     2.488    77.016     0.200
     2.861    86.934     0.200
     3.094    94.617     0.200
     3.143    95.088     0.200
     0.230     7.109     0.200
     0.233     7.498     0.200
     0.736    23.039     0.200
     1.083    34.898     0.200
     1.148    37.838     0.200
     1.186    37.568     0.200
     1.200    36.771     0.200
     1.244    39.648     0.200
     1.283    39.428     0.200
     1.312    41.418     0.200
     1.700    52.182     0.200
     1.738    53.633     0.200
     2.147    65.656     0.200
     2.876    86.494     0.200
     2.912    88.539     0.200
     0.144     5.617     0.200
     0.228     7.967     0.200
     0.228     7.738     0.200
     0.218     7.577     0.200
     0.565    17.602     0.200
     0.717    22.107     0.200
     0.717    22.297     0.200
     0.780    24.587     0.200
     0.948    29.417     0.200
     1.109    34.411     0.200
     1.108    33.650     0.200
     1.175    36.817     0.200
     1.177    36.657     0.200
     1.183    37.487     0.200
     1.499    45.491     0.200
     1.615    49.027     0.200
     1.617    49.747     0.200
     1.617    53.487     0.200
     2.215    66.787     0.200
     2.307    69.658     0.200
     2.333    70.367     0.200
     2.646    79.600     0.200
     2.694    81.499     0.200
     2.877    86.442     0.200
     3.084    92.309     0.200
     4.066   125.257     0.200
     0.151     5.918     0.200
     0.194     6.570     0.200
     0.299     9.098     0.200
     0.519    17.699     0.200
     0.690    21.340     0.200
     0.761    23.008     0.200
     1.167    37.109     0.200
     1.172    37.320     0.200
     1.186    38.020     0.200
     1.472    44.867     0.200
     1.633    52.047     0.200
     1.840    56.676     0.200
     2.189    65.898     0.200
     2.278    68.664     0.200
     0.126     5.252     0.200
     0.139     5.785     0.200
     0.195     7.635     0.200
     0.286     8.707     0.200
     0.605    18.346     0.200
     0.612    19.336     0.200
     1.150    35.896     0.200
     1.165    36.596     0.200
     1.201    37.756     0.200
     1.389    41.906     0.200
     1.613    49.160     0.200
     1.687    52.566     0.200
     1.771    54.207     0.200
     2.107    65.289     0.200
     2.109    63.023     0.200
     2.218    66.615     0.200
     2.338    70.676     0.200
     2.387    71.865     0.200
     2.752    85.166     0.200
     3.011    93.336     0.200
     3.634   110.676     0.200
     3.832   118.305     0.200
     4.378   132.396     0.200
     6.452   196.725     0.200
     0.171     6.172     0.200
     0.278     9.320     0.200
     0.298     9.840     0.200
     0.359    10.734     0.200
     0.414    14.434     0.200
     0.500    16.852     0.200
     0.678    22.051     0.200
     0.783    24.141     0.200
     0.819    25.961     0.200
     1.181    35.953     0.200
     1.159    37.113     0.200
     1.174    37.141     0.200
     1.181    37.273     0.200
     1.556    46.672     0.200
     1.557    46.652     0.200
     1.557    49.773     0.200
     2.176    65.988     0.200
     2.293    69.102     0.200
     2.411    73.082     0.200
     2.507    75.613     0.200
     2.578    77.184     0.200
     2.725    82.902     0.200
     2.954    89.715     0.200
     3.603   109.605     0.200
     0.162     6.129     0.200
     0.267     9.219     0.200
     0.286     9.434     0.200
     0.347    10.488     0.200
     0.686    22.617     0.200
     0.772    24.078     0.200
     0.814    26.109     0.200
     0.907    27.367     0.200
     1.166    36.809     0.200
     1.177    36.938     0.200
     1.570    49.238     0.200
     1.564    47.348     0.200
     2.174    65.543     0.200
     2.278    68.066     0.200
     3.795   115.848     0.200
     0.276     9.477     0.200
     0.297     9.820     0.200
     0.415    15.117     0.200
     0.782    23.984     0.200
     1.182    36.375     0.200
     1.158    36.953     0.200
     1.179    35.852     0.200
     1.172    37.305     0.200
     1.179    37.438     0.200
     1.261    39.016     0.200
     1.261    39.664     0.200
     1.577    48.070     0.200
     1.557    49.594     0.200
     1.557    51.789     0.200
     2.527    76.438     0.200
     2.577    76.133     0.200
     0.138     5.623     0.200
     0.218     7.643     0.200
     0.226     7.748     0.200
     0.299     9.191     0.200
     0.496    15.924     0.200
     0.559    17.396     0.200
     0.715    22.123     0.200
     0.722    22.652     0.200
     0.933    28.902     0.200
     0.946    29.113     0.200
     1.105    33.436     0.200
     1.342    42.414     0.200
     1.492    45.664     0.200
     1.624    51.613     0.200
     1.625    51.264     0.200
     2.207    66.588     0.200
     2.302    69.590     0.200
     2.327    69.754     0.200
     0.196     7.102     0.200
     0.563    17.656     0.200
     0.611    20.164     0.200
     0.779    23.883     0.200
     0.832    25.367     0.200
     0.923    28.305     0.200
     1.081    34.438     0.200
     1.150    36.602     0.200
     1.153    35.852     0.200
     1.179    37.375     0.200
     1.180    39.578     0.200
     1.180    39.203     0.200
     1.231    38.977     0.200
     1.239    37.938     0.200
     1.294    40.703     0.200
     1.655    50.305     0.200
     1.690    50.953     0.200
     2.099    64.789     0.200
     2.296    69.578     0.200
     0.308    10.535     0.200
     0.881    27.934     0.200
     0.924    28.840     0.200
     1.094    35.113     0.200
     1.090    34.793     0.200
     1.284    39.473     0.200
     1.270    40.223     0.200
     1.345    42.152     0.200
     1.360    41.234     0.200
     2.231    68.398     0.200
     2.354    70.805     0.200
     2.948    89.715     0.200
     2.990    89.965     0.200
     3.044    91.117     0.200
     3.229    98.375     0.200
     3.377   102.465     0.200
     3.606   109.969     0.200
     3.753   116.023     0.200
     0.168     6.512     0.200
     0.164     5.984     0.200
     0.164     6.133     0.200
     0.279     8.461     0.200
     0.483    15.082     0.200
     0.645    19.914     0.200
     0.737    22.863     0.200
     0.737    23.672     0.200
     1.165    36.832     0.200
     1.176    37.383     0.200
     1.204    38.102     0.200
     1.418    43.832     0.200
     1.673    52.711     0.200
     2.135    64.609     0.200
     2.251    68.398     0.200
     2.565    77.965     0.200
     2.800    85.375     0.200
     3.002    90.449     0.200
     0.392    13.352     0.200
     0.594    19.293     0.200
     0.988    31.703     0.200
     1.030    32.295     0.200
     1.065    35.953     0.200
     1.065    34.982     0.200
     1.390    43.760     0.200
     1.466    45.393     0.200
     1.885    57.436     0.200
     1.945    58.553     0.200
     2.336    72.133     0.200
     3.097    93.998     0.200
     3.150    95.957     0.200
     3.482   105.938     0.200
     0.144     5.238     0.200
     0.693    21.848     0.200
     0.729    22.953     0.200
     0.847    25.773     0.200
     0.847    25.648     0.200
     0.876    27.195     0.200
     1.128    35.078     0.200
     1.128    35.387     0.200
     1.190    36.438     0.200
     1.273    38.648     0.200
     1.602    48.613     0.200
     2.023    62.027     0.200
     2.168    63.805     0.200
     2.217    67.316     0.200
     2.734    83.355     0.200
     0.019     4.094     0.200
     0.087     4.641     0.200
     0.734    22.273     0.200
     0.734    22.102     0.200
     0.924    28.852     0.200
     1.236    37.992     0.200
     1.236    39.023     0.200
     1.272    39.477     0.200
     1.357    43.211     0.200
     1.358    42.008     0.200
     1.474    44.828     0.200
     1.678    51.828     0.200
     1.764    54.734     0.200
     2.107    63.578     0.200
     0.200     6.090     0.200
     0.743    23.879     0.200
     1.070    35.049     0.200
     1.175    38.209     0.200
     1.138    34.969     0.200
     1.138    36.139     0.200
     1.176    37.529     0.200
     1.176    38.869     0.200
     1.144    36.289     0.200
     1.218    39.670     0.200
     1.281    41.020     0.200
     1.645    50.303     0.200
     1.685    53.109     0.200
     2.091    64.514     0.200
     2.150    65.299     0.200
     2.304    69.404     0.200
     2.808    85.219     0.200
     2.857    86.787     0.200
     2.906    87.998     0.200
     3.237    98.566     0.200
     3.467   106.143     0.200
     3.713   111.605     0.200
     0.174     6.955     0.200
     0.286     8.533     0.200
     0.482    14.826     0.200
     0.641    19.985     0.200
     0.730    22.756     0.200
     1.028    31.223     0.200
     1.042    31.625     0.200
     1.042    31.882     0.200
     1.418    43.244     0.200
     1.667    50.146     0.200
     1.668    50.596     0.200
     1.794    55.019     0.200
     2.137    65.288     0.200
     2.250    68.081     0.200
     2.565    77.647     0.200
     2.755    85.372     0.200
     2.802    85.701     0.200
     3.001    91.362     0.200
     3.040    93.295     0.200
     3.160    96.468     0.200
     3.231    97.872     0.200
     3.446   104.349     0.200
     3.630   110.644     0.200
     3.660   110.832     0.200
     3.872   116.905     0.200
     4.294   129.243     0.200
     0.193     7.055     0.200
     0.288     8.562     0.200
     0.455    14.275     0.200
     0.615    19.484     0.200
     0.601    20.254     0.200
     0.752    24.055     0.200
     0.844    26.334     0.200
     1.053    32.553     0.200
     1.149    36.445     0.200
     1.164    36.984     0.200
     1.199    37.895     0.200
     1.393    42.982     0.200
     1.683    53.654     0.200
     2.113    64.957     0.200
     2.223    68.303     0.200
     2.539    77.381     0.200
     2.779    84.285     0.200
     2.974    89.938     0.200
     3.141    95.750     0.200
     3.422   103.795     0.200
     4.374   131.984     0.200
     0.126     4.799     0.200
     0.283     8.613     0.200
     0.448    14.062     0.200
     0.611    19.189     0.200
     0.693    21.930     0.200
     0.712    22.600     0.200
     0.712    23.238     0.200
     0.840    25.760     0.200
     1.048    32.412     0.200
     1.205    38.219     0.200
     1.385    42.023     0.200
     1.433    43.889     0.200
     2.105    63.303     0.200
     2.216    66.494     0.200
     2.350    71.889     0.200
     2.531    76.789     0.200
     2.771    83.342     0.200
     3.007    89.346     0.200
     3.413   103.504     0.200
     0.174     6.404     0.200
     0.161     5.564     0.200
     0.162     5.498     0.200
     0.162     5.984     0.200
     0.297     8.910     0.200
     0.558    18.295     0.200
     0.497    15.355     0.200
     0.651    20.375     0.200
     0.730    23.234     0.200
     0.732    23.074     0.200
     0.732    23.465     0.200
     1.152    36.686     0.200
     1.161    36.965     0.200
     1.185    38.195     0.200
     1.386    42.504     0.200
     1.435    43.977     0.200
     1.652    52.025     0.200
     2.129    66.504     0.200
     2.154    64.857     0.200
     2.265    68.363     0.200
     2.582    78.354     0.200
     2.820    85.250     0.200
     3.017    91.826     0.200
     3.463   104.719     0.200
     0.143     5.551     0.200
     0.194     7.395     0.200
     0.279     8.613     0.200
     0.445    13.895     0.200
     0.610    18.984     0.200
     0.714    23.184     0.200
     1.382    42.449     0.200
     1.437    45.742     0.200
     1.694    54.352     0.200
     1.695    53.371     0.200
     1.695    56.273     0.200
     2.101    63.617     0.200
     2.213    67.809     0.200
     2.767    83.828     0.200
     3.410   103.215     0.200
     0.152     5.869     0.200
     0.247     8.488     0.200
     0.263     8.730     0.200
     0.331    10.238     0.200
     0.451    15.770     0.200
     0.604    18.705     0.200
     0.751    23.350     0.200
     0.751    23.180     0.200
     1.145    34.689     0.200
     1.172    37.260     0.200
     1.176    36.998     0.200
     1.179    37.260     0.200
     1.539    46.846     0.200
     1.587    50.389     0.200
     2.254    67.488     0.200
     2.372    70.773     0.200
     2.488    75.568     0.200
     2.538    77.398     0.200
     2.915    87.777     0.200
     3.771   114.055     0.200
     3.771   115.529     0.200
     6.586   204.828     0.200
     0.175     7.227     0.200
     0.175     5.699     0.200
     0.203     6.637     0.200
     0.599    20.137     0.200
     0.717    22.836     0.200
     0.797    24.902     0.200
     1.120    35.598     0.200
     1.120    35.438     0.200
     1.116    34.582     0.200
     1.200    38.766     0.200
     1.200    39.066     0.200
     1.204    37.109     0.200
     1.201    38.359     0.200
     1.201    38.926     0.200
     1.217    38.477     0.200
     1.277    40.297     0.200
     1.655    50.469     0.200
     2.062    63.461     0.200
     2.778    84.207     0.200
     2.832    86.355     0.200
     3.012    91.828     0.200
     3.060    91.996     0.200
     3.208    97.758     0.200
     3.436   104.578     0.200
     3.684   110.891     0.200
     0.153     5.285     0.200
     0.691    21.707     0.200
     0.731    23.102     0.200
     0.767    24.023     0.200
     1.089    33.520     0.200
     1.084    35.105     0.200
     1.182    36.297     0.200
     1.218    38.574     0.200
     1.226    39.605     0.200
     1.275    40.355     0.200
     1.597    48.426     0.200
     2.034    62.625     0.200
     2.185    65.117     0.200
     2.808    84.848     0.200
     2.983    90.625     0.200
     3.032    91.406     0.200
     3.180    96.531     0.200
     3.407   103.754     0.200
     3.656   110.984     0.200
     7.070   219.137     0.200
     0.394    13.889     0.200
     0.596    19.859     0.200
     0.994    32.170     0.200
     1.037    33.152     0.200
     1.070    35.189     0.200
     1.070    35.109     0.200
     1.152    37.510     0.200
     1.350    43.400     0.200
     1.359    44.150     0.200
     1.396    43.631     0.200
     1.432    45.590     0.200
     1.474    46.150     0.200
     1.892    57.520     0.200
     2.342    72.760     0.200
     3.056    93.812     0.200
     3.157    95.201     0.200
     0.295     9.090     0.200
     0.323    10.512     0.200
     0.905    27.781     0.200
     0.982    30.180     0.200
     1.107    34.949     0.200
     1.091    34.660     0.200
     1.091    35.492     0.200
     1.091    34.770     0.200
     1.091    35.500     0.200
     1.091    37.422     0.200
     1.275    39.652     0.200
     1.275    39.090     0.200
     1.290    40.121     0.200
     1.385    42.531     0.200
     2.040    62.258     0.200
     2.016    60.059     0.200
     2.352    72.250     0.200
     2.974    89.199     0.200
     3.068    92.000     0.200
     3.253    99.051     0.200
     3.400   102.203     0.200
     3.628   109.336     0.200
     4.478   137.250     0.200
     6.470   198.391     0.200
     7.288   225.742     0.200
     0.230     9.125     0.200
     0.237     8.615     0.200
     1.147    35.975     0.200
     1.147    35.746     0.200
     1.147    36.135     0.200
     1.147    36.814     0.200
     1.147    39.025     0.200
     1.195    37.115     0.200
     1.209    37.238     0.200
     1.292    39.945     0.200
     1.746    53.990     0.200
     2.092    64.025     0.200
     2.155    66.203     0.200
     2.871    86.369     0.200
     2.886    86.816     0.200
     2.971    89.072     0.200
     0.169     5.998     0.200
     0.196     6.680     0.200
     0.813    26.260     0.200
     1.118    34.076     0.200
     1.126    34.668     0.200
     1.126    35.449     0.200
     1.208    37.068     0.200
     1.624    49.188     0.200
     2.063    63.361     0.200
     2.163    65.039     0.200
     2.778    84.256     0.200
     2.882    85.814     0.200
     3.013    91.789     0.200
     3.062    93.299     0.200
     3.209    97.195     0.200
     3.685   110.873     0.200
     4.247   131.289     0.200
     4.288   133.238     0.200
     6.394   196.260     0.200
     0.350    10.094     0.200
     0.387    11.444     0.200
     0.591    20.084     0.200
     0.973    30.734     0.200
     1.055    36.344     0.200
     1.016    32.743     0.200
     1.017    31.614     0.200
     1.332    41.464     0.200
     1.376    43.527     0.200
     1.869    57.748     0.200
     2.324    71.981     0.200
     3.040    93.403     0.200
     3.136    95.069     0.200
     3.469   105.970     0.200
     3.946   118.202     0.200
     0.219     6.940     0.200
     0.216     7.771     0.200
     0.216     6.480     0.200
     0.616    20.351     0.200
     0.776    23.881     0.200
     1.162    36.501     0.200
     1.163    41.451     0.200
     1.163    35.881     0.200
     1.168    36.621     0.200
     1.168    38.051     0.200
     1.236    38.621     0.200
     1.261    39.230     0.200
     1.261    38.821     0.200
     1.425    43.650     0.200
     1.678    50.892     0.200
     1.715    52.151     0.200
     1.715    52.610     0.200
     1.752    54.480     0.200
     2.120    65.221     0.200
     2.123    65.333     0.200
     2.467    75.469     0.200
     2.839    85.591     0.200
     2.939    88.772     0.200
     3.073    93.491     0.200
     3.122    94.150     0.200
     3.269    98.766     0.200
     3.497   107.212     0.200
     3.745   112.402     0.200
     3.745   112.131     0.200
     7.160   217.991     0.200
     0.185     6.234     0.200
     0.185     6.383     0.200
     0.214     7.664     0.200
     0.214     7.375     0.200
     0.265     8.508     0.200
     0.361    11.523     0.200
     0.597    18.641     0.200
     0.807    24.664     0.200
     0.914    28.312     0.200
     0.929    30.117     0.200
     1.248    37.922     0.200
     1.477    44.977     0.200
     1.519    46.922     0.200
     1.598    48.711     0.200
     1.598    48.977     0.200
     1.598    50.125     0.200
     1.955    58.664     0.200
     2.105    63.656     0.200
     2.114    64.188     0.200
     2.222    67.680     0.200
     2.249    66.836     0.200
     2.397    72.266     0.200
     2.614    78.562     0.200
     2.852    86.289     0.200
     2.869    86.469     0.200
     3.248    98.859     0.200
     3.265    99.016     0.200
     0.275     8.451     0.200
     0.295     9.600     0.200
     0.417    14.512     0.200
     0.639    19.715     0.200
     0.781    24.232     0.200
     0.795    24.701     0.200
     1.014    31.271     0.200
     1.177    35.924     0.200
     1.178    35.672     0.200
     1.265    38.842     0.200
     1.574    48.160     0.200
     1.560    49.002     0.200
     1.931    58.955     0.200
     2.175    65.027     0.200
     2.289    69.125     0.200
     2.379    72.230     0.200
     2.407    72.793     0.200
     2.523    76.662     0.200
     2.574    77.701     0.200
     2.721    82.158     0.200
     2.950    88.771     0.200
     3.159    95.102     0.200
     3.196    96.590     0.200
     3.296   100.053     0.200
     3.805   115.271     0.200
     0.229     7.215     0.200
     0.228     7.074     0.200
     0.792    24.262     0.200
     1.151    37.031     0.200
     1.180    37.191     0.200
     1.152    39.902     0.200
     1.193    36.312     0.200
     1.276    39.652     0.200
     1.469    45.098     0.200
     1.693    51.750     0.200
     1.681    52.070     0.200
     2.140    66.141     0.200
     2.314    70.230     0.200
     2.483    76.723     0.200
     2.856    86.105     0.200
     3.089    93.645     0.200
     3.138    94.684     0.200
     7.177   222.312     0.200
     0.218     7.236     0.200
     0.495    16.227     0.200
     0.561    17.248     0.200
     1.341    41.727     0.200
     1.494    44.881     0.200
     1.855    56.807     0.200
     1.869    56.666     0.200
     2.209    66.207     0.200
     2.209    67.707     0.200
     2.287    69.797     0.200
     2.304    69.074     0.200
     2.329    69.910     0.200
     2.474    74.816     0.200
     2.493    74.756     0.200
     2.493    74.977     0.200
     2.641    79.629     0.200
     2.871    86.334     0.200
     3.727   111.947     0.200
     0.198     7.076     0.200
     0.198     6.105     0.200
     0.739    22.936     0.200
     0.780    24.686     0.200
     0.780    24.924     0.200
     0.824    25.416     0.200
     0.931    28.641     0.200
     1.139    35.420     0.200
     1.133    36.256     0.200
     1.177    38.555     0.200
     1.177    38.035     0.200
     1.178    38.525     0.200
     1.178    41.256     0.200
     1.178    37.785     0.200
     1.224    38.256     0.200
     1.216    39.055     0.200
     1.278    40.375     0.200
     1.640    50.510     0.200
     1.681    51.260     0.200
     1.681    51.738     0.200
     2.086    64.584     0.200
     2.154    66.855     0.200
     2.433    75.010     0.200
     2.803    85.115     0.200
     2.852    86.627     0.200
     2.902    88.449     0.200
     3.036    93.096     0.200
     3.084    93.695     0.200
     3.852   117.375     0.200
     0.152     5.633     0.200
     0.355    10.602     0.200
     0.507    15.602     0.200
     0.655    20.734     0.200
     0.646    20.109     0.200
     1.099    33.586     0.200
     1.127    35.773     0.200
     1.456    44.219     0.200
     1.604    51.094     0.200
     1.850    56.562     0.200
     2.180    65.539     0.200
     2.850    86.273     0.200
     0.218     6.758     0.200
     0.225     6.969     0.200
     0.771    23.719     0.200
     1.160    36.625     0.200
     1.159    35.891     0.200
     1.172    35.625     0.200
     1.255    38.508     0.200
     1.672    50.680     0.200
     2.119    64.695     0.200
     2.127    64.219     0.200
     2.312    69.883     0.200
     2.465    76.180     0.200
     2.836    85.984     0.200
     2.884    87.141     0.200
     0.378    11.551     0.200
     0.418    14.168     0.200
     0.532    17.230     0.200
     1.005    32.031     0.200
     1.048    33.727     0.200
     1.039    34.641     0.200
     1.039    33.879     0.200
     1.131    36.121     0.200
     1.408    44.590     0.200
     1.480    46.828     0.200
     1.899    59.148     0.200
     2.356    73.273     0.200
     2.396    73.000     0.200
     3.111    94.965     0.200
     3.354   102.871     0.200
     3.978   122.648     0.200
     0.268     8.195     0.200
     0.282     9.555     0.200
     0.282     9.680     0.200
     0.888    27.852     0.200
     1.078    33.711     0.200
     1.108    35.617     0.200
     1.108    37.977     0.200
     1.108    35.398     0.200
     1.249    37.852     0.200
     1.248    37.672     0.200
     1.790    55.055     0.200
     1.790    55.203     0.200
     2.071    63.477     0.200
     2.913    88.359     0.200
     3.008    91.148     0.200
     0.032     4.823     0.200
     0.105     4.924     0.200
     0.105     4.563     0.200
     0.740    22.420     0.200
     0.909    27.863     0.200
     1.249    38.043     0.200
     1.249    38.963     0.200
     1.257    38.703     0.200
     1.346    41.584     0.200
     1.346    41.074     0.200
     1.481    44.795     0.200
     1.630    51.094     0.200
     1.777    54.092     0.200
     2.060    62.178     0.200
     2.060    61.414     0.200
     2.081    63.758     0.200
     2.114    63.389     0.200
     2.435    74.582     0.200
     2.900    87.740     0.200
     3.730   114.764     0.200
     0.076     3.961     0.200
     0.763    22.781     0.200
     0.781    24.500     0.200
     0.907    28.500     0.200
     1.211    38.047     0.200
     1.211    37.859     0.200
     1.220    37.516     0.200
     1.227    38.938     0.200
     1.333    42.117     0.200
     1.333    41.836     0.200
     1.333    44.336     0.200
     1.334    42.008     0.200
     1.334    44.375     0.200
     1.358    42.516     0.200
     1.411    44.062     0.200
     1.611    50.242     0.200
     1.661    51.328     0.200
     2.867    86.242     0.200
     2.898    88.844     0.200
     0.140     5.662     0.200
     0.301     9.781     0.200
     0.316    10.523     0.200
     0.406    14.582     0.200
     0.490    14.531     0.200
     0.650    20.166     0.200
     0.868    26.025     0.200
     0.868    26.441     0.200
     1.196    36.336     0.200
     1.197    37.701     0.200
     1.278    39.441     0.200
     1.511    46.672     0.200
     1.584    48.191     0.200
     2.287    68.611     0.200
     2.417    73.258     0.200
     2.525    76.672     0.200
     2.725    82.203     0.200
     2.945    89.174     0.200
     3.199    98.592     0.200
     0.300     9.347     0.200
     0.320    10.447     0.200
     0.320    11.357     0.200
     0.883    27.427     0.200
     0.931    29.128     0.200
     0.972    30.643     0.200
     1.078    34.897     0.200
     1.079    34.397     0.200
     1.079    34.457     0.200
     1.079    37.077     0.200
     1.287    39.475     0.200
     1.778    54.436     0.200
     2.047    61.120     0.200
     2.047    62.587     0.200
     2.236    68.465     0.200
     2.990    90.097     0.200
     4.668   144.187     0.200
     0.279     8.273     0.200
     0.297     9.375     0.200
     0.866    27.719     0.200
     0.914    28.734     0.200
     1.085    34.648     0.200
     1.099    35.266     0.200
     1.099    35.586     0.200
     1.099    35.695     0.200
     1.099    37.312     0.200
     1.237    38.102     0.200
     1.237    38.766     0.200
     1.269    38.344     0.200
     1.269    39.102     0.200
     2.053    62.734     0.200
     2.934    89.312     0.200
     2.976    90.734     0.200
     3.167    96.586     0.200
     3.215    98.055     0.200
     3.362   101.844     0.200
     3.839   115.352     0.200
     3.839   116.125     0.200
     3.903   121.172     0.200
     5.115   158.703     0.200
     5.818   177.078     0.200
     0.319     8.934     0.200
     0.294     9.363     0.200
     0.319    10.570     0.200
     0.319    10.441     0.200
     0.419    14.391     0.200
     0.637    19.984     0.200
     0.794    24.051     0.200
     0.849    27.254     0.200
     0.849    27.121     0.200
     0.870    26.578     0.200
     1.185    36.309     0.200
     1.204    37.672     0.200
     1.204    39.133     0.200
     1.292    39.113     0.200
     1.563    48.113     0.200
     1.596    51.281     0.200
     1.597    50.023     0.200
     1.597    50.973     0.200
     2.273    68.523     0.200
     2.404    73.234     0.200
     2.511    75.141     0.200
     2.564    76.602     0.200
     2.711    81.996     0.200
     2.931    88.699     0.200
     3.185    94.363     0.200
     0.346    12.008     0.200
     0.936    29.500     0.200
     0.983    31.246     0.200
     0.983    31.398     0.200
     1.083    34.180     0.200
     1.121    35.828     0.200
     1.304    40.770     0.200
     1.304    41.227     0.200
     1.338    40.980     0.200
     1.337    40.648     0.200
     1.415    43.898     0.200
     1.833    56.066     0.200
     1.871    58.113     0.200
     3.046    91.637     0.200
     3.099    92.984     0.200
     3.234    98.949     0.200
     3.430   103.062     0.200
     3.906   117.754     0.200
     0.387    11.148     0.200
     0.387    12.219     0.200
     0.437    14.711     0.200
     0.439    14.609     0.200
     0.485    14.727     0.200
     0.606    19.828     0.200
     1.015    31.359     0.200
     1.038    31.852     0.200
     2.342    69.953     0.200
     3.081    91.961     0.200
     3.407   103.320     0.200
     0.567    17.555     0.200
     0.899    28.250     0.200
     0.948    29.273     0.200
     0.993    30.922     0.200
     1.057    33.891     0.200
     1.057    32.922     0.200
     1.058    34.750     0.200
     1.058    32.672     0.200
     1.069    34.734     0.200
     1.253    38.906     0.200
     1.373    41.961     0.200
     1.844    56.945     0.200
     2.167    66.570     0.200
     2.215    67.805     0.200
     2.254    69.031     0.200
     2.973    90.859     0.200
     2.957    89.828     0.200
     3.004    90.867     0.200
     3.061    92.680     0.200
     3.398   103.078     0.200
     4.282   129.812     0.200
     0.231     8.211     0.200
     0.231     8.984     0.200
     0.231     7.414     0.200
     0.839    26.613     0.200
     1.148    37.414     0.200
     1.149    35.891     0.200
     1.193    36.391     0.200
     1.206    37.234     0.200
     1.275    39.621     0.200
     1.692    51.969     0.200
     1.684    50.191     0.200
     1.726    52.184     0.200
     4.309   130.914     0.200
     0.082     2.949     0.200
     0.081     3.668     0.200
     0.752    23.875     0.200
     0.794    24.625     0.200
     0.794    24.520     0.200
     1.122    35.293     0.200
     1.189    38.590     0.200
     1.189    38.270     0.200
     1.200    38.180     0.200
     1.195    38.590     0.200
     1.307    42.637     0.200
     1.307    42.168     0.200
     1.649    51.141     0.200
     1.810    55.578     0.200
     2.052    63.852     0.200
     2.166    65.805     0.200
     2.757    84.656     0.200
     2.844    85.789     0.200
     2.856    86.695     0.200
     2.890    88.445     0.200
     3.201    96.906     0.200
     3.642   108.844     0.200
     3.674   110.953     0.200
     0.311    10.828     0.200
     0.335    10.258     0.200
     0.335    12.289     0.200
     0.954    29.680     0.200
     1.073    35.340     0.200
     1.073    34.387     0.200
     1.073    36.340     0.200
     1.089    34.348     0.200
     1.267    39.508     0.200
     1.301    39.559     0.200
     1.352    41.988     0.200
     1.801    55.059     0.200
     1.848    56.887     0.200
     1.851    56.988     0.200
     2.026    62.000     0.200
     0.223     6.845     0.200
     0.215     6.385     0.200
     0.768    24.604     0.200
     0.768    23.985     0.200
     0.815    25.489     0.200
     1.073    34.445     0.200
     1.161    36.905     0.200
     1.161    37.584     0.200
     1.161    36.425     0.200
     1.161    36.555     0.200
     1.158    36.575     0.200
     1.158    36.755     0.200
     1.169    35.688     0.200
     1.184    36.405     0.200
     1.252    38.705     0.200
     1.669    51.277     0.200
     2.116    65.124     0.200
     2.311    70.360     0.200
     2.462    75.879     0.200
     2.833    86.530     0.200
     2.846    86.578     0.200
     2.881    86.733     0.200
     2.931    89.203     0.200
     3.066    93.635     0.200
     3.122    93.285     0.200
     3.114    95.015     0.200
     3.261   100.108     0.200
     3.491   106.588     0.200
     3.684   111.461     0.200
     4.650   143.635     0.200
     6.138   189.295     0.200
     7.506   228.975     0.200
     0.327    10.456     0.200
     0.944    29.668     0.200
     1.077    35.596     0.200
     1.085    35.116     0.200
     1.140    37.326     0.200
     1.258    39.656     0.200
     1.299    40.461     0.200
     1.372    42.286     0.200
     1.372    43.046     0.200
     1.598    49.065     0.200
     1.721    53.076     0.200
     1.748    54.086     0.200
     1.791    54.766     0.200
     1.951    61.096     0.200
     2.556    77.176     0.200
     3.184    96.446     0.200
     3.197    97.985     0.200
     3.245    98.936     0.200
     4.475   138.936     0.200
     0.776    24.992     0.200
     0.823    25.883     0.200
     1.143    37.094     0.200
     1.143    36.625     0.200
     1.158    36.695     0.200
     1.158    36.883     0.200
     1.178    36.234     0.200
     1.185    36.516     0.200
     1.257    39.086     0.200
     1.674    51.625     0.200
     3.076    93.164     0.200
     0.259     8.498     0.200
     0.259    10.547     0.200
     0.806    24.047     0.200
     0.854    26.779     0.200
     1.060    34.188     0.200
     1.121    36.107     0.200
     1.121    35.809     0.200
     1.121    35.447     0.200
     1.209    36.525     0.200
     1.211    36.578     0.200
     1.285    39.457     0.200
     1.710    51.527     0.200
     1.703    51.934     0.200
     1.755    53.568     0.200
     2.158    66.537     0.200
     2.507    76.879     0.200
     2.876    87.869     0.200
     2.915    87.967     0.200
     2.969    90.455     0.200
     3.303   100.195     0.200
     3.536   107.650     0.200
     3.779   114.424     0.200
     0.489    16.059     0.200
     0.592    19.750     0.200
     0.647    19.902     0.200
     0.735    23.949     0.200
     0.858    26.773     0.200
     0.843    26.707     0.200
     0.993    30.770     0.200
     0.992    30.547     0.200
     1.062    33.797     0.200
     1.063    33.430     0.200
     1.640    50.113     0.200
     2.388    74.336     0.200
     2.687    81.367     0.200
     2.698    82.043     0.200
     3.072    93.465     0.200
     3.368   102.762     0.200
     3.450   105.277     0.200
     0.911    28.723     0.200
     1.072    34.023     0.200
     1.088    34.814     0.200
     1.089    34.123     0.200
     1.267    38.961     0.200
     1.340    41.363     0.200
     1.571    48.484     0.200
     1.759    53.957     0.200
     1.759    54.023     0.200
     1.809    55.984     0.200
     1.811    55.984     0.200
     2.216    67.979     0.200
     2.934    88.957     0.200
     2.971    89.432     0.200
     3.360   101.795     0.200
     0.644    19.922     0.200
     0.739    23.535     0.200
     0.854    26.914     0.200
     0.845    26.475     0.200
     0.823    26.385     0.200
     0.823    27.016     0.200
     0.823    25.305     0.200
     0.871    26.205     0.200
     0.991    30.863     0.200
     0.991    30.664     0.200
     1.066    35.164     0.200
     1.066    33.834     0.200
     1.067    34.734     0.200
     1.067    33.824     0.200
     1.634    51.135     0.200
     1.636    50.426     0.200
     1.636    50.975     0.200
     1.946    59.697     0.200
     2.385    72.834     0.200
     2.685    81.441     0.200
     2.696    82.510     0.200
     2.888    87.895     0.200
     2.924    89.725     0.200
     3.070    92.760     0.200
     3.365   102.852     0.200
     3.448   105.232     0.200
     0.214     7.398     0.200
     0.855    26.121     0.200
     1.167    36.648     0.200
     1.167    36.438     0.200
     1.163    37.488     0.200
     1.164    38.008     0.200
     1.175    36.395     0.200
     1.192    36.789     0.200
     1.260    38.609     0.200
     1.676    51.297     0.200
     1.673    50.340     0.200
     1.713    52.234     0.200
     2.122    65.457     0.200
     2.306    69.758     0.200
     2.465    75.941     0.200
     3.071    93.668     0.200
     0.105     4.566     0.200
     0.299     9.133     0.200
     0.318    10.039     0.200
     0.318    10.348     0.200
     0.340    11.262     0.200
     0.647    20.152     0.200
     0.814    25.109     0.200
     0.869    27.617     0.200
     0.878    27.777     0.200
     1.201    36.543     0.200
     1.201    36.250     0.200
     1.236    38.527     0.200
     1.618    49.289     0.200
     1.619    49.066     0.200
     2.270    68.211     0.200
     2.412    72.926     0.200
     0.499    15.891     0.200
     0.586    18.734     0.200
     0.640    19.859     0.200
     0.670    22.141     0.200
     0.852    25.695     0.200
     0.859    26.742     0.200
     0.985    30.766     0.200
     1.029    33.680     0.200
     1.065    35.164     0.200
     1.066    34.391     0.200
     1.227    37.945     0.200
     1.359    41.836     0.200
     1.388    42.734     0.200
     1.399    42.555     0.200
     1.399    42.664     0.200
     1.578    49.234     0.200
     1.575    49.109     0.200
     1.633    51.516     0.200
     1.694    52.891     0.200
     1.940    59.125     0.200
     2.679    80.672     0.200
     2.687    81.797     0.200
     3.062    92.508     0.200
     3.361   102.234     0.200
     3.977   120.477     0.200
     4.680   141.672     0.200
     0.498    16.406     0.200
     0.648    19.961     0.200
     0.676    22.281     0.200
     0.863    26.656     0.200
     0.817    26.031     0.200
     0.844    26.234     0.200
     0.867    26.984     0.200
     0.844    26.727     0.200
     0.993    31.102     0.200
     0.990    30.461     0.200
     1.035    33.734     0.200
     1.059    34.031     0.200
     1.060    34.117     0.200
     1.060    36.945     0.200
     1.060    39.156     0.200
     1.060    33.078     0.200
     1.235    38.117     0.200
     1.314    40.797     0.200
     1.367    42.047     0.200
     1.396    42.734     0.200
     1.642    51.172     0.200
     1.641    51.789     0.200
     1.702    53.688     0.200
     1.879    57.836     0.200
     1.895    57.555     0.200
     1.941    59.836     0.200
     2.390    73.594     0.200
     2.695    82.297     0.200
     3.070    92.875     0.200
     3.203    97.227     0.200
     3.368   103.344     0.200
     3.447   104.867     0.200
     3.756   115.242     0.200
     3.985   120.578     0.200
     0.220     6.427     0.200
     0.235     7.227     0.200
     1.056    33.696     0.200
     1.140    36.036     0.200
     1.140    35.356     0.200
     1.157    36.170     0.200
     1.167    35.937     0.200
     1.154    36.257     0.200
     1.154    38.507     0.200
     1.155    39.156     0.200
     1.236    38.387     0.200
     1.654    49.316     0.200
     1.703    51.246     0.200
     2.105    65.136     0.200
     3.133    97.026     0.200
     3.849   118.547     0.200
     6.804   208.507     0.200
     7.148   221.696     0.200
     0.218     6.455     0.200
     0.223     6.945     0.200
     0.755    24.154     0.200
     0.821    25.863     0.200
     0.856    26.635     0.200
     1.164    36.715     0.200
     1.164    37.395     0.200
     1.159    38.824     0.200
     1.160    39.584     0.200
     1.160    38.635     0.200
     1.175    36.920     0.200
     1.190    37.465     0.200
     1.258    39.004     0.200
     1.675    51.000     0.200
     1.675    51.414     0.200
     1.678    50.777     0.200
     1.715    52.977     0.200
     2.122    65.717     0.200
     3.071    95.324     0.200
     3.120    94.514     0.200
     3.122    95.885     0.200
     0.221     6.541     0.200
     0.231     7.162     0.200
     0.756    24.061     0.200
     0.764    23.521     0.200
     0.852    26.422     0.200
     1.064    33.521     0.200
     1.151    36.230     0.200
     1.151    35.992     0.200
     1.155    36.381     0.200
     1.155    36.082     0.200
     1.166    36.264     0.200
     1.177    36.582     0.200
     1.247    38.650     0.200
     1.664    51.260     0.200
     1.710    52.305     0.200
     2.114    64.186     0.200
     2.831    85.656     0.200
     0.216     6.334     0.200
     0.210     6.344     0.200
     0.762    24.133     0.200
     0.850    26.297     0.200
     1.167    38.482     0.200
     1.168    38.633     0.200
     1.164    36.773     0.200
     1.164    37.094     0.200
     1.171    36.289     0.200
     1.189    37.113     0.200
     1.672    51.316     0.200
     1.708    52.170     0.200
     1.708    52.893     0.200
     2.833    86.416     0.200
     2.884    87.324     0.200
     3.115    95.473     0.200
     0.284    10.316     0.200
     0.284    11.098     0.200
     1.104    35.309     0.200
     1.104    35.039     0.200
     1.104    34.445     0.200
     1.212    38.316     0.200
     1.245    38.457     0.200
     1.320    40.836     0.200
     2.951    89.188     0.200
     3.005    91.309     0.200
     3.338   100.367     0.200
     3.571   107.691     0.200
     3.815   114.133     0.200
     4.123   126.598     0.200
     6.952   214.105     0.200
     0.296     9.965     0.200
     0.899    28.473     0.200
     0.943    29.664     0.200
     1.092    35.406     0.200
     1.092    35.426     0.200
     1.217    38.246     0.200
     1.255    38.648     0.200
     1.328    40.965     0.200
     1.781    54.637     0.200
     1.731    53.516     0.200
     1.801    55.324     0.200
     2.204    67.715     0.200
     2.361    71.535     0.200
     2.916    89.262     0.200
     2.922    88.910     0.200
     2.959    89.512     0.200
     3.013    91.363     0.200
     3.348   102.191     0.200
     3.582   109.141     0.200
     4.434   134.551     0.200
     0.129     5.729     0.200
     0.129     5.582     0.200
     0.263     8.367     0.200
     0.263     8.225     0.200
     0.333    10.178     0.200
     0.333    10.291     0.200
     0.457    14.508     0.200
     0.565    17.988     0.200
     0.676    20.818     0.200
     0.819    24.723     0.200
     0.819    24.707     0.200
     1.207    36.604     0.200
     1.619    49.002     0.200
     1.932    58.008     0.200
     2.031    62.219     0.200
     2.156    65.438     0.200
     2.203    66.498     0.200
     2.211    67.393     0.200
     2.350    70.482     0.200
     2.605    78.596     0.200
     2.659    81.498     0.200
     2.782    83.812     0.200
     2.827    86.314     0.200
     2.984    90.189     0.200
     0.286     8.354     0.200
     0.304    11.333     0.200
     0.869    26.273     0.200
     0.917    29.093     0.200
     0.917    28.443     0.200
     1.092    36.013     0.200
     1.092    35.483     0.200
     1.236    39.233     0.200
     1.236    38.723     0.200
     1.269    38.463     0.200
     1.272    39.192     0.200
     1.765    53.440     0.200
     1.796    55.591     0.200
     2.221    68.495     0.200
     2.357    70.992     0.200
     2.935    88.458     0.200
     2.977    89.747     0.200
     3.031    91.921     0.200
     3.365   101.600     0.200
     3.597   109.738     0.200
     3.766   116.123     0.200
     3.842   114.403     0.200
     3.842   115.509     0.200
     0.034     2.984     0.200
     0.072     3.266     0.200
     0.706    22.082     0.200
     0.762    23.246     0.200
     0.936    30.652     0.200
     1.085    33.633     0.200
     1.173    35.902     0.200
     1.350    42.145     0.200
     1.350    42.215     0.200
     1.350    44.543     0.200
     1.618    49.680     0.200
     2.133    64.324     0.200
     2.138    65.438     0.200
     0.232     7.028     0.200
     0.220     7.809     0.200
     0.579    18.118     0.200
     0.761    22.849     0.200
     1.155    37.028     0.200
     1.155    35.798     0.200
     1.155    39.258     0.200
     1.147    35.168     0.200
     1.147    35.748     0.200
     1.163    35.223     0.200
     1.174    36.148     0.200
     1.243    38.438     0.200
     1.661    50.624     0.200
     1.661    50.729     0.200
     2.140    65.088     0.200
     2.111    64.951     0.200
     2.320    69.541     0.200
     2.873    86.283     0.200
     2.924    87.229     0.200
     3.256    98.484     0.200
     3.732   111.265     0.200
     0.072     3.102     0.200
     0.053     2.809     0.200
     0.745    22.500     0.200
     0.765    23.855     0.200
     0.909    30.250     0.200
     1.124    35.543     0.200
     1.205    37.941     0.200
     1.214    38.461     0.200
     1.248    39.070     0.200
     1.308    39.379     0.200
     1.333    43.250     0.200
     1.504    45.820     0.200
     1.656    51.258     0.200
     1.656    49.941     0.200
     2.138    64.738     0.200
     2.862    87.633     0.200
     2.892    88.836     0.200
     0.241     9.508     0.200
     0.250     8.477     0.200
     0.818    24.758     0.200
     0.898    28.211     0.200
     1.201    37.559     0.200
     1.201    36.449     0.200
     1.220    37.844     0.200
     1.229    37.379     0.200
     1.718    52.477     0.200
     1.758    53.836     0.200
     2.166    66.434     0.200
     2.323    69.289     0.200
     2.882    87.270     0.200
     2.930    88.422     0.200
     2.981    90.281     0.200
     3.312   101.172     0.200
     3.788   113.844     0.200
     0.261     8.974     0.200
     0.261     9.684     0.200
     0.268     8.964     0.200
     0.295     9.524     0.200
     0.340    10.844     0.200
     0.340    10.714     0.200
     0.467    15.544     0.200
     0.467    15.434     0.200
     0.521    15.882     0.200
     0.521    16.064     0.200
     0.585    19.114     0.200
     0.602    19.204     0.200
     0.682    20.934     0.200
     0.682    21.114     0.200
     0.668    20.594     0.200
     0.668    20.764     0.200
     0.701    21.204     0.200
     0.701    21.334     0.200
     0.834    25.184     0.200
     0.865    25.944     0.200
     0.867    26.351     0.200
     0.905    26.554     0.200
     1.074    34.374     0.200
     1.233    37.976     0.200
     1.501    46.244     0.200
     1.501    46.474     0.200
     1.502    47.284     0.200
     1.949    59.897     0.200
     2.556    78.101     0.200
     2.542    75.998     0.200
     2.875    87.101     0.200
     0.059     5.590     0.200
     0.073     3.121     0.200
     0.073     3.021     0.200
     0.150     6.911     0.200
     0.176     8.000     0.200
     0.303    11.230     0.200
     0.477    15.411     0.200
     0.653    20.340     0.200
     0.730    22.614     0.200
     0.730    21.920     0.200
     0.723    21.990     0.200
     0.779    23.904     0.200
     0.882    27.161     0.200
     1.093    33.161     0.200
     1.105    34.404     0.200
     1.190    36.311     0.200
     1.225    38.371     0.200
     2.841    86.255     0.200
     3.797   115.216     0.200
     0.042     2.969     0.200
     0.121     5.539     0.200
     0.318    12.547     0.200
     0.504    15.906     0.200
     0.634    19.883     0.200
     0.756    23.406     0.200
     0.757    23.023     0.200
     0.797    25.383     0.200
     0.910    28.016     0.200
     1.135    35.664     0.200
     1.185    37.414     0.200
     1.219    38.508     0.200
     1.260    39.664     0.200
     1.338    43.898     0.200
     1.338    43.445     0.200
     1.339    43.633     0.200
     1.339    44.562     0.200
     1.339    44.805     0.200
     1.462    44.992     0.200
     1.460    45.656     0.200
     1.576    48.109     0.200
     1.601    48.680     0.200
     1.668    51.266     0.200
     2.873    87.195     0.200
     0.085     4.016     0.200
     0.117     5.719     0.200
     0.139     7.055     0.200
     0.752    23.227     0.200
     0.762    22.883     0.200
     0.802    25.844     0.200
     0.802    25.594     0.200
     0.815    26.570     0.200
     0.899    29.945     0.200
     0.910    29.555     0.200
     1.111    35.891     0.200
     1.140    35.570     0.200
     1.191    37.484     0.200
     1.234    38.633     0.200
     1.266    39.555     0.200
     1.341    41.203     0.200
     1.341    43.906     0.200
     1.458    45.625     0.200
     1.491    46.320     0.200
     1.467    45.469     0.200
     1.500    46.625     0.200
     2.125    64.758     0.200
     2.433    75.547     0.200
     2.879    88.102     0.200
     0.132     6.234     0.200
     0.158     7.352     0.200
     0.311    12.523     0.200
     0.641    20.000     0.200
     0.740    23.156     0.200
     0.740    22.781     0.200
     0.742    22.664     0.200
     0.782    24.539     0.200
     0.782    24.734     0.200
     1.122    34.859     0.200
     1.122    34.703     0.200
     1.169    36.875     0.200
     1.203    38.516     0.200
     1.212    37.984     0.200
     1.245    38.969     0.200
     1.334    41.711     0.200
     1.334    43.531     0.200
     1.448    44.820     0.200
     1.444    45.125     0.200
     1.562    47.094     0.200
     1.587    49.133     0.200
     1.653    50.391     0.200
     2.048    62.188     0.200
     2.137    64.266     0.200
     2.859    85.703     0.200
     2.890    87.180     0.200
     3.197    96.867     0.200
     0.162     6.338     0.200
     0.243     8.119     0.200
     0.243     8.119     0.200
     0.254     8.256     0.200
     0.254     8.468     0.200
     0.299     9.398     0.200
     0.313     9.838     0.200
     0.345    12.499     0.200
     0.345    12.378     0.200
     0.382    12.999     0.200
     0.393    11.928     0.200
     0.393    12.028     0.200
     0.403    13.858     0.200
     0.484    15.448     0.200
     0.472    14.798     0.200
     0.465    15.028     0.200
     0.470    15.008     0.200
     0.513    15.238     0.200
     0.578    17.798     0.200
     0.576    18.059     0.200
     0.603    18.448     0.200
     0.684    21.068     0.200
     0.684    20.948     0.200
     0.703    21.519     0.200
     0.700    21.698     0.200
     0.775    23.749     0.200
     0.820    26.349     0.200
     0.831    26.628     0.200
     0.860    26.418     0.200
     0.844    26.119     0.200
     0.880    27.358     0.200
     0.905    27.688     0.200
     0.987    31.159     0.200
     1.017    31.052     0.200
     1.041    32.938     0.200
     1.041    32.718     0.200
     1.094    33.198     0.200
     1.101    33.639     0.200
     1.111    33.738     0.200
     1.153    34.688     0.200
     1.181    36.188     0.200
     1.186    36.378     0.200
     1.186    36.219     0.200
     1.272    38.628     0.200
     1.377    41.599     0.200
     1.589    48.598     0.200
     1.909    57.625     0.200
     2.020    61.986     0.200
     2.019    62.079     0.200
     2.180    66.677     0.200
     2.332    70.896     0.200
     2.579    77.966     0.200
     2.624    80.002     0.200
     2.808    84.423     0.200
     2.954    90.371     0.200
     3.083    94.768     0.200
     3.216    97.708     0.200
     3.426   105.131     0.200
     3.441   105.493     0.200
     0.111     5.832     0.200
     0.111     6.023     0.200
     0.097     5.645     0.200
     0.285    10.465     0.200
     0.291    11.082     0.200
     0.291    11.344     0.200
     0.371    11.766     0.200
     0.371    13.766     0.200
     0.755    24.375     0.200
     0.813    27.223     0.200
     0.885    27.062     0.200
     0.963    29.695     0.200
     0.979    30.754     0.200
     1.018    32.402     0.200
     1.342    42.605     0.200
     1.427    44.535     0.200
     1.487    46.184     0.200
     1.553    48.645     0.200
     1.614    49.754     0.200
     1.660    51.043     0.200
     1.761    54.062     0.200
     0.033     4.101     0.200
     0.075     4.761     0.200
     0.113     5.820     0.200
     0.129     7.261     0.200
     0.150     7.521     0.200
     0.227     8.700     0.200
     0.253    10.091     0.200
     0.409    14.511     0.200
     0.447    15.461     0.200
     0.753    22.681     0.200
     0.753    24.040     0.200
     0.793    25.040     0.200
     0.803    26.101     0.200
     0.855    26.221     0.200
     0.050     4.766     0.200
     0.050     5.031     0.200
     0.127     5.617     0.200
     0.234     9.781     0.200
     0.234     8.758     0.200
     0.232     7.688     0.200
     0.267    10.984     0.200
     0.309    11.414     0.200
     0.362    12.883     0.200
     0.767    25.023     0.200
     0.845    26.828     0.200
     0.901    29.508     0.200
     0.890    28.078     0.200
     0.898    28.836     0.200
     0.913    29.297     0.200
     1.038    31.805     0.200
     1.146    35.766     0.200
     1.737    53.656     0.200
     0.102     5.821     0.200
     0.099     6.541     0.200
     0.152     7.611     0.200
     0.177     7.851     0.200
     0.190     8.791     0.200
     0.284    10.801     0.200
     0.331    11.381     0.200
     0.330    11.551     0.200
     0.330    11.871     0.200
     0.469    15.241     0.200
     0.525    15.891     0.200
     0.530    16.621     0.200
     0.650    20.531     0.200
     0.734    22.730     0.200
     0.757    24.791     0.200
     0.757    26.351     0.200
     0.774    26.061     0.200
     0.910    28.661     0.200
     0.938    29.031     0.200
     0.947    29.901     0.200
     0.947    29.500     0.200
     0.954    29.460     0.200
     0.970    30.500     0.200
     1.022    30.690     0.200
     1.042    32.601     0.200
     1.098    33.631     0.200
     0.048     3.154     0.200
     0.065     3.615     0.200
     0.105     5.504     0.200
     0.108     6.234     0.200
     0.106     5.375     0.200
     0.160     7.814     0.200
     0.242     8.924     0.200
     0.245     9.004     0.200
     0.359    13.494     0.200
     0.489    15.984     0.200
     0.741    22.365     0.200
     0.854    26.664     0.200
     0.884    28.934     0.200
     1.204    38.285     0.200
     1.212    37.715     0.200
     1.342    43.514     0.200
     0.148     5.888     0.200
     0.210     5.898     0.200
     0.199     6.838     0.200
     0.216     8.338     0.200
     0.275     9.368     0.200
     0.298    11.098     0.200
     0.285    10.958     0.200
     0.285    11.228     0.200
     0.326    12.198     0.200
     0.356    13.058     0.200
     0.365    13.308     0.200
     0.386    13.398     0.200
     0.411    13.958     0.200
     0.405    14.868     0.200
     0.406    15.028     0.200
     0.436    14.018     0.200
     0.553    17.538     0.200
     0.542    17.628     0.200
     0.684    21.668     0.200
     0.763    23.428     0.200
     0.883    29.468     0.200
     0.882    28.058     0.200
     0.961    31.468     0.200
     1.060    33.528     0.200
     1.079    33.748     0.200
     1.076    33.478     0.200
     1.130    34.508     0.200
     1.146    36.128     0.200
     1.191    36.748     0.200
     1.266    39.078     0.200
     1.283    39.318     0.200
     1.319    40.658     0.200
     1.345    41.388     0.200
     1.373    42.888     0.200
     1.535    47.328     0.200
     1.575    49.447     0.200
     1.765    52.638     0.200
     0.151     5.852     0.200
     0.110     4.730     0.200
     0.125     5.051     0.200
     0.154     6.500     0.200
     0.191     6.379     0.200
     0.216     6.512     0.200
     0.224     6.781     0.200
     0.205     7.059     0.200
     0.227     7.781     0.200
     0.243     8.488     0.200
     0.289    10.980     0.200
     0.240     8.559     0.200
     0.240     8.891     0.200
     0.240     8.660     0.200
     0.290    10.230     0.200
     0.338    12.629     0.200
     0.362    13.480     0.200
     0.375    13.020     0.200
     0.346    12.770     0.200
     0.385    13.602     0.200
     0.451    14.828     0.200
     0.483    15.781     0.200
     0.486    15.609     0.200
     0.452    14.840     0.200
     0.507    16.219     0.200
     0.546    17.340     0.200
     0.553    17.711     0.200
     0.573    17.711     0.200
     0.590    18.820     0.200
     0.676    20.609     0.200
     0.690    20.980     0.200
     0.669    21.031     0.200
     0.687    21.441     0.200
     0.724    22.270     0.200
     0.744    22.930     0.200
     0.763    23.488     0.200
     0.868    26.949     0.200
     0.864    27.020     0.200
     0.931    29.180     0.200
     0.932    29.730     0.200
     0.924    29.051     0.200
     0.917    28.500     0.200
     0.931    28.648     0.200
     0.930    28.539     0.200
     0.967    29.539     0.200
     0.128     5.627     0.200
     0.175     8.008     0.200
     0.215     8.498     0.200
     0.297    11.438     0.200
     0.319    11.627     0.200
     0.297    11.547     0.200
     0.389    14.107     0.200
     0.644    20.447     0.200
     1.187    37.488     0.200
     0.106     4.648     0.200
     0.107     3.429     0.200
     0.144     4.438     0.200
     0.150     6.609     0.200
     0.150     6.779     0.200
     0.214     8.799     0.200
     0.214     8.958     0.200
     0.332    12.559     0.200
     0.330    12.139     0.200
     0.473    15.799     0.200
     0.701    21.898     0.200
     0.865    26.168     0.200
     0.902    28.659     0.200
     0.872    27.839     0.200
     0.998    32.688     0.200
     1.031    32.398     0.200
     1.111    34.679     0.200
     1.124    35.918     0.200
     1.134    35.579     0.200
     1.131    35.449     0.200
     1.145    35.609     0.200
     1.193    37.319     0.200
     1.245    38.489     0.200
     1.270    39.119     0.200
     1.795    55.668     0.200
     0.040     2.609     0.200
     0.040     2.758     0.200
     0.082     4.957     0.200
     0.118     6.137     0.200
     0.142     6.770     0.200
     0.227     8.719     0.200
     0.256    10.047     0.200
     0.242     9.258     0.200
     0.345    11.617     0.200
     0.446    15.309     0.200
     0.469    15.867     0.200
     0.506    16.789     0.200
     0.599    18.906     0.200
     0.633    20.117     0.200
     0.759    22.789     0.200
     0.755    23.047     0.200
     0.762    23.469     0.200
     0.849    26.328     0.200
     0.898    29.430     0.200
     0.909    30.156     0.200
     1.005    31.656     0.200
     1.081    33.066     0.200
     1.089    36.168     0.200
     1.187    37.188     0.200
     1.191    37.469     0.200
     1.230    37.609     0.200
     1.263    39.656     0.200
     1.285    40.258     0.200
     1.299    40.418     0.200
     1.333    41.836     0.200
     1.336    41.789     0.200
     1.339    41.688     0.200
     1.357    40.938     0.200
     1.456    45.246     0.200
     1.464    45.297     0.200
     1.462    45.688     0.200
     1.550    47.906     0.200
     1.615    48.328     0.200
     1.757    53.977     0.200
     0.036     3.355     0.200
     0.073     4.455     0.200
     0.073     6.467     0.200
     0.129     6.977     0.200
     0.151     7.387     0.200
     0.250     9.836     0.200
     0.278    11.125     0.200
     0.251     9.516     0.200
     0.251    10.076     0.200
     0.309    12.266     0.200
     0.313    12.086     0.200
     0.345    12.416     0.200
     0.336    11.656     0.200
     0.348    13.396     0.200
     0.459    15.566     0.200
     0.757    22.785     0.200
     0.764    23.266     0.200
     0.791    25.516     0.200
     0.802    25.717     0.200
     1.217    37.057     0.200
     1.224    37.566     0.200
     1.348    43.125     0.200
     1.884    56.406     0.200
     0.052     3.898     0.200
     0.074     5.047     0.200
     0.177     6.930     0.200
     0.229     7.477     0.200
     0.241     7.828     0.200
     0.268     9.957     0.200
     0.352    11.047     0.200
     0.350    12.379     0.200
     0.358    11.488     0.200
     0.344    11.309     0.200
     0.318    10.777     0.200
     0.412    13.117     0.200
     0.384    14.707     0.200
     0.420    13.859     0.200
     0.411    13.648     0.200
     0.472    15.168     0.200
     0.507    16.289     0.200
     0.498    15.727     0.200
     0.534    17.117     0.200
     0.547    16.316     0.200
     0.574    17.938     0.200
     0.537    17.277     0.200
     0.547    17.398     0.200
     0.610    19.258     0.200
     0.633    19.699     0.200
     0.660    20.387     0.200
     0.674    20.438     0.200
     0.686    21.270     0.200
     0.679    21.027     0.200
     0.776    23.797     0.200
     0.783    24.340     0.200
     0.835    25.617     0.200
     0.868    26.816     0.200
     0.816    26.000     0.200
     0.850    26.250     0.200
     0.863    27.148     0.200
     0.869    27.219     0.200
     0.893    28.238     0.200
     0.877    27.289     0.200
     0.883    28.078     0.200
     0.906    28.699     0.200
     0.944    29.199     0.200
     0.922    28.547     0.200
     0.970    29.488     0.200
     1.005    30.930     0.200
     1.083    33.219     0.200
     1.440    45.898     0.200
     0.077     4.012     0.200
     0.098     4.371     0.200
     0.099     5.281     0.200
     0.073     4.402     0.200
     0.154     6.332     0.200
     0.154     6.371     0.200
     0.107     5.949     0.200
     0.100     5.031     0.200
     0.205     7.152     0.200
     0.205     8.051     0.200
     0.154     6.801     0.200
     0.146     6.062     0.200
     0.219     8.391     0.200
     0.219     8.391     0.200
     0.146     6.543     0.200
     0.146     6.652     0.200
     0.222     8.781     0.200
     0.341    11.930     0.200
     0.333    10.781     0.200
     0.333    10.512     0.200
     0.356    12.672     0.200
     0.353    11.672     0.200
     0.392    14.082     0.200
     0.403    13.492     0.200
     0.396    14.359     0.200
     0.448    14.270     0.200
     0.497    16.461     0.200
     0.488    17.199     0.200
     0.485    17.012     0.200
     0.485    16.902     0.200
     0.468    15.621     0.200
     0.567    17.570     0.200
     0.605    19.141     0.200
     0.592    19.691     0.200
     0.670    20.562     0.200
     0.721    22.082     0.200
     0.716    21.270     0.200
     0.777    23.641     0.200
     0.842    26.680     0.200
     0.840    26.531     0.200
     0.894    28.152     0.200
     0.929    29.473     0.200
     0.941    29.582     0.200
     1.017    31.500     0.200
     0.995    31.512     0.200
     1.011    32.109     0.200
     1.005    32.242     0.200
     1.052    32.531     0.200
     1.031    32.930     0.200
     1.077    33.020     0.200
     1.092    33.660     0.200
     1.106    34.141     0.200
     1.152    35.980     0.200
     1.161    36.570     0.200
     1.170    36.590     0.200
     1.208    37.512     0.200
     1.205    37.352     0.200
     1.276    40.672     0.200
     1.301    41.562     0.200
     0.074     4.234     0.200
     0.093     4.391     0.200
     0.097     5.391     0.200
     0.072     4.148     0.200
     0.104     5.031     0.200
     0.148     6.391     0.200
     0.148     6.328     0.200
     0.107     5.703     0.200
     0.150     6.203     0.200
     0.200     7.961     0.200
     0.151     6.383     0.200
     0.214     8.461     0.200
     0.214     8.461     0.200
     0.351    11.594     0.200
     0.410    14.922     0.200
     0.403    13.539     0.200
     0.398    14.172     0.200
     0.389    13.758     0.200
     0.403    13.938     0.200
     0.451    14.102     0.200
     0.451    14.484     0.200
     0.451    14.609     0.200
     0.470    15.617     0.200
     0.492    16.555     0.200
     0.471    15.508     0.200
     0.562    17.359     0.200
     0.667    20.289     0.200
     0.717    22.117     0.200
     0.711    20.758     0.200
     0.776    24.070     0.200
     0.906    28.531     0.200
     0.897    28.211     0.200
     0.944    29.602     0.200
     1.010    31.867     0.200
     1.279    39.898     0.200
     1.306    40.812     0.200
     1.506    45.562     0.200
     0.086     4.158     0.200
     0.177     6.627     0.200
     0.149     5.309     0.200
     0.197     6.838     0.200
     0.229     7.238     0.200
     0.229     7.627     0.200
     0.234     6.889     0.200
     0.209     7.697     0.200
     0.320    12.188     0.200
     0.312    10.318     0.200
     0.312    11.107     0.200
     0.347    13.238     0.200
     0.376    13.697     0.200
     0.494    16.139     0.200
     0.502    16.658     0.200
     0.505    16.207     0.200
     0.512    16.639     0.200
     0.519    16.627     0.200
     0.561    18.148     0.200
     0.558    17.697     0.200
     0.589    18.678     0.200
     0.571    18.217     0.200
     0.638    20.287     0.200
     0.635    20.088     0.200
     0.635    20.578     0.200
     0.657    20.389     0.200
     0.655    20.258     0.200
     0.705    21.658     0.200
     0.672    21.287     0.200
     0.707    21.588     0.200
     0.702    21.738     0.200
     0.740    23.158     0.200
     0.733    22.947     0.200
     0.797    24.877     0.200
     0.802    24.748     0.200
     0.827    25.717     0.200
     0.832    25.818     0.200
     0.920    28.857     0.200
     0.980    30.467     0.200
     0.981    30.408     0.200
     1.004    31.938     0.200
     1.025    32.178     0.200
     1.064    33.648     0.200
     1.106    34.168     0.200
     1.142    34.898     0.200
     1.166    35.639     0.200
     1.710    51.047     0.200
     0.169     6.141     0.200
     0.186     6.352     0.200
     0.186     7.102     0.200
     0.269    10.371     0.200
     0.298    11.082     0.200
     0.290     9.182     0.200
     0.344    11.432     0.200
     0.413    15.111     0.200
     0.440    16.381     0.200
     0.593    19.121     0.200
     0.633    20.061     0.200
     0.746    23.141     0.200
     0.766    23.311     0.200
     0.823    25.781     0.200
     0.885    26.730     0.200
     0.914    28.650     0.200
     0.963    29.791     0.200
     0.967    30.771     0.200
     0.967    30.082     0.200
     0.966    31.041     0.200
     0.992    31.361     0.200
     1.002    31.031     0.200
     1.044    32.650     0.200
     1.238    38.162     0.200
     1.256    38.611     0.200
     1.278    39.391     0.200
     1.375    42.371     0.200
     0.835    26.967     0.200
     0.781    24.846     0.200
     0.781    26.736     0.200
     0.781    24.947     0.200
     0.314    11.006     0.200
     0.314    11.447     0.200
     1.024    32.207     0.200
     0.247     9.797     0.200
     0.247     9.646     0.200
     0.178     7.246     0.200
     0.983    30.627     0.200
     0.887    27.916     0.200
     0.033     5.117     0.200
     0.035     5.326     0.200
     0.921    28.846     0.200
     0.921    29.096     0.200
     0.338    11.846     0.200
     0.338    11.697     0.200
     0.136     6.676     0.200
     0.795    25.357     0.200
     0.241     8.287     0.200
     0.241     8.256     0.200
     0.262     8.996     0.200
     0.120     6.477     0.200
     1.147    35.107     0.200
     0.119     5.727     0.200
     0.119     5.787     0.200
     0.718    24.047     0.200
     0.148     6.707     0.200
     1.143    34.926     0.200
     0.773    24.816     0.200
     1.065    32.146     0.200
     1.065    33.756     0.200
     0.284    10.287     0.200
     0.509    16.406     0.200
     0.900    28.146     0.200
     0.316    12.066     0.200
     0.336    12.707     0.200
     0.393    13.316     0.200
     0.983    29.688     0.200
     0.812    25.086     0.200
     0.812    27.096     0.200
     0.850    26.006     0.200
     0.546    16.986     0.200
     0.837    26.387     0.200
     0.678    20.846     0.200
     0.809    26.127     0.200
     0.692    20.867     0.200
     1.057    32.596     0.200
     1.095    33.027     0.200
     0.922    28.736     0.200
     0.875    27.016     0.200
     0.922    29.076     0.200
     1.312    39.637     0.200
     0.114     5.695     0.200
     0.147     6.436     0.200
     0.149     6.775     0.200
     0.176     7.285     0.200
     0.254     8.695     0.200
     0.254     8.615     0.200
     0.254     9.064     0.200
     0.285    10.084     0.200
     0.276     9.404     0.200
     0.236     9.295     0.200
     0.325    12.186     0.200
     0.318    10.555     0.200
     0.318    11.744     0.200
     0.318    11.324     0.200
     0.349    11.904     0.200
     0.457    15.465     0.200
     0.466    15.244     0.200
     0.466    15.494     0.200
     0.522    16.965     0.200
     0.542    16.725     0.200
     0.671    20.484     0.200
     0.689    20.244     0.200
     0.706    21.414     0.200
     0.750    23.924     0.200
     0.785    25.035     0.200
     0.777    24.715     0.200
     0.822    26.574     0.200
     0.772    25.674     0.200
     0.772    25.445     0.200
     0.800    25.195     0.200
     0.804    25.895     0.200
     0.799    26.516     0.200
     0.851    26.445     0.200
     0.829    26.705     0.200
     0.934    29.324     0.200
     0.912    28.945     0.200
     0.893    27.914     0.200
     0.928    28.775     0.200
     1.109    33.285     0.200
     0.131     6.033     0.200
     0.116     5.854     0.200
     0.149     6.523     0.200
     0.150     6.773     0.200
     0.178     8.623     0.200
     0.174     7.104     0.200
     0.255     8.885     0.200
     0.287    10.225     0.200
     0.277     9.465     0.200
     0.233     9.385     0.200
     0.233     9.104     0.200
     0.316    11.055     0.200
     0.316    11.334     0.200
     0.316    11.904     0.200
     0.349    12.064     0.200
     0.544    16.885     0.200
     0.632    19.674     0.200
     0.672    20.523     0.200
     0.691    20.725     0.200
     0.753    23.953     0.200
     0.729    23.475     0.200
     0.786    24.953     0.200
     0.800    26.795     0.200
     0.776    24.674     0.200
     0.769    25.244     0.200
     0.769    25.414     0.200
     0.797    25.523     0.200
     0.803    25.885     0.200
     0.826    26.564     0.200
     0.892    28.023     0.200
     0.927    29.193     0.200
     0.051     3.143     0.200
     0.053     3.542     0.200
     0.059     2.633     0.200
     0.059     2.752     0.200
     0.059     3.433     0.200
     0.145     6.283     0.200
     0.145     6.312     0.200
     0.143     6.792     0.200
     0.143     6.002     0.200
     0.143     6.312     0.200
     0.175     7.863     0.200
     0.265    10.363     0.200
     0.257     9.683     0.200
     0.246     8.783     0.200
     0.294    11.272     0.200
     0.312    11.292     0.200
     0.312    10.982     0.200
     0.356    12.743     0.200
     0.474    15.942     0.200
     0.477    16.192     0.200
     0.495    17.013     0.200
     0.613    19.283     0.200
     0.619    19.292     0.200
     0.636    19.873     0.200
     0.762    23.163     0.200
     0.791    24.002     0.200
     0.873    28.593     0.200
     0.934    29.203     0.200
     0.971    30.853     0.200
     1.082    35.883     0.200
     1.157    36.982     0.200
     1.153    36.292     0.200
     1.189    38.243     0.200
     1.197    37.113     0.200
     1.229    37.683     0.200
     1.229    38.573     0.200
     1.299    40.873     0.200
     1.302    40.653     0.200
     1.343    43.493     0.200
     1.545    46.933     0.200
     1.874    58.792     0.200
     0.048     4.211     0.200
     0.049     3.320     0.200
     0.132     6.109     0.200
     0.132     5.547     0.200
     0.152     7.766     0.200
     0.152     6.609     0.200
     0.177     8.195     0.200
     0.177     8.023     0.200
     0.247     9.945     0.200
     0.247     9.445     0.200
     0.310    10.859     0.200
     0.310    11.109     0.200
     0.263     9.359     0.200
     0.263     9.906     0.200
     0.338    12.219     0.200
     0.409    14.234     0.200
     0.596    18.828     0.200
     0.619    19.375     0.200
     0.836    25.906     0.200
     0.781    23.914     0.200
     0.863    27.898     0.200
     0.973    31.328     0.200
     0.938    30.094     0.200
     0.938    30.914     0.200
     1.197    37.664     0.200
     1.203    37.328     0.200
     1.359    44.266     0.200
     1.579    47.859     0.200
     1.892    55.859     0.200
     0.041     3.766     0.200
     0.043     3.477     0.200
     0.060     3.367     0.200
     0.060     3.227     0.200
     0.060     3.664     0.200
     0.144     6.336     0.200
     0.144     6.781     0.200
     0.154     6.930     0.200
     0.258    10.047     0.200
     0.184     7.547     0.200
     0.259     9.625     0.200
     0.303    10.617     0.200
     0.303    10.406     0.200
     0.257     9.367     0.200
     0.479    16.117     0.200
     0.608    18.633     0.200
     0.755    23.133     0.200
     0.793    23.750     0.200
     0.935    30.742     0.200
     0.935    29.836     0.200
     1.185    37.086     0.200
     1.192    36.633     0.200
     1.353    43.203     0.200
     1.884    59.180     0.200
     0.152     6.867     0.200
     0.044     3.281     0.200
     0.147     6.523     0.200
     0.261     9.711     0.200
     0.262     9.781     0.200
     0.303    10.523     0.200
     0.303    10.680     0.200
     0.424    14.656     0.200
     0.424    14.680     0.200
     0.466    15.477     0.200
     0.610    19.562     0.200
     0.714    22.477     0.200
     0.795    24.203     0.200
     0.759    23.617     0.200
     0.932    29.359     0.200
     0.932    29.906     0.200
     0.864    27.938     0.200
     0.964    30.453     0.200
     1.184    37.789     0.200
     1.191    36.352     0.200
     1.349    41.578     0.200
     0.035     3.439     0.200
     0.035     3.339     0.200
     0.035     4.199     0.200
     0.056     4.020     0.200
     0.057     4.219     0.200
     0.117     5.789     0.200
     0.117     5.809     0.200
     0.173     8.139     0.200
     0.232     9.399     0.200
     0.234     9.289     0.200
     0.234     9.149     0.200
     0.275    10.020     0.200
     0.316    11.399     0.200
     0.316    11.520     0.200
     0.324    11.919     0.200
     0.337    11.849     0.200
     0.476    15.939     0.200
     0.625    19.270     0.200
     0.779    24.639     0.200
     0.779    25.319     0.200
     0.774    24.779     0.200
     0.766    23.209     0.200
     0.861    27.439     0.200
     0.947    30.169     0.200
     0.947    30.699     0.200
     0.947    31.579     0.200
     0.982    31.349     0.200
     1.209    37.789     0.200
     1.214    37.509     0.200
     1.372    42.209     0.200
     1.906    57.289     0.200
     0.024     4.070     0.200
     0.024     5.369     0.200
     0.108     4.961     0.200
     0.082     5.270     0.200
     0.144     7.211     0.200
     0.217     8.529     0.200
     0.240     8.990     0.200
     0.336    11.900     0.200
     0.308    11.869     0.200
     0.583    17.760     0.200
     0.617    19.211     0.200
     0.739    22.721     0.200
     0.751    22.830     0.200
     0.794    26.369     0.200
     0.801    26.199     0.200
     0.923    28.721     0.200
     0.923    29.859     0.200
     1.229    39.500     0.200
     1.280    38.330     0.200
     1.236    38.520     0.200
     1.354    44.119     0.200
     1.892    57.260     0.200
     0.010     4.551     0.200
     0.010     5.363     0.200
     0.097     6.023     0.200
     0.137     7.152     0.200
     0.196     8.043     0.200
     0.222     9.293     0.200
     0.304    11.590     0.200
     0.315    12.402     0.200
     0.416    14.543     0.200
     0.416    14.750     0.200
     0.748    23.660     0.200
     0.817    25.750     0.200
     0.932    28.973     0.200
     0.932    29.742     0.200
     1.249    40.070     0.200
     1.255    38.941     0.200
     1.369    43.711     0.200
     1.909    59.281     0.200
     0.147     6.594     0.200
     0.148     6.051     0.200
     0.290     9.910     0.200
     0.290    10.531     0.200
     0.389    13.691     0.200
     0.340    12.043     0.200
     0.451    14.523     0.200
     0.564    18.852     0.200
     0.564    18.672     0.200
     0.569    17.691     0.200
     0.735    23.070     0.200
     0.735    23.191     0.200
     0.755    22.633     0.200
     0.869    28.312     0.200
     0.869    27.891     0.200
     0.811    25.602     0.200
     0.894    28.043     0.200
     0.897    29.633     0.200
     0.902    29.031     0.200
     0.985    31.012     0.200
     1.011    31.922     0.200
     1.006    31.652     0.200
     1.146    35.004     0.200
     1.244    39.051     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.793   120.499     0.200
     7.445   240.270     0.200
     7.475   238.289     0.200
     8.343   265.859     0.200
     8.419   272.239     0.200
     7.789   244.562     0.200
    11.321   364.113     0.200
     3.754   119.189     0.200
     8.342   265.461     0.200
     7.335   231.484     0.200
     7.718   244.176     0.200
    11.286   360.738     0.200
    15.912   505.133     0.200
     2.594    81.016     0.200
     3.723   117.133     0.200
     4.674   149.320     0.200
     6.482   205.633     0.200
     7.678   243.430     0.200
     8.004   259.953     0.200
    11.300   361.000     0.200
     4.140   128.691     0.200
     4.479   143.553     0.200
     7.343   230.533     0.200
     7.699   242.982     0.200
     7.904   247.553     0.200
     8.111   259.113     0.200
     8.590   275.072     0.200
     9.414   302.463     0.200
    10.981   348.332     0.200
    11.259   359.387     0.200
    23.974   752.402     0.200
    26.268   827.977     0.200
     6.455   208.281     0.200
    10.472   329.992     0.200
    10.990   350.586     0.200
     2.619    84.250     0.200
     2.884    90.695     0.200
     3.558   114.602     0.200
     3.618   117.945     0.200
     4.126   129.695     0.200
     4.482   144.242     0.200
     5.813   187.461     0.200
     6.932   222.242     0.200
     2.890    89.706     0.200
     3.618   113.946     0.200
     3.851   124.985     0.200
     4.495   143.696     0.200
     5.344   169.017     0.200
    11.271   357.812     0.200
    26.286   829.251     0.200
     3.846   123.277     0.200
     7.346   235.137     0.200
     7.698   247.340     0.200
    10.494   330.801     0.200
     2.629    83.854     0.200
     3.834   124.043     0.200
     4.143   130.562     0.200
     7.345   233.162     0.200
     7.789   247.242     0.200
     8.281   264.242     0.200
     7.796   243.436     0.200
     8.283   261.085     0.200
     2.622    86.695     0.200
     2.881    91.023     0.200
     3.613   113.250     0.200
     3.853   123.383     0.200
     4.125   130.914     0.200
     4.489   145.164     0.200
     6.569   207.062     0.200
     6.622   212.094     0.200
     7.353   234.070     0.200
     7.602   242.641     0.200
     7.704   246.180     0.200
     7.933   253.625     0.200
     7.986   255.359     0.200
     8.103   262.875     0.200
     8.579   274.883     0.200
     8.653   277.102     0.200
     9.427   301.562     0.200
    10.495   330.094     0.200
    22.892   721.695     0.200
     2.627    82.424     0.200
     5.547   173.844     0.200
     6.574   205.784     0.200
     6.932   216.194     0.200
     7.360   230.314     0.200
     7.489   237.464     0.200
     7.608   240.804     0.200
     7.711   240.665     0.200
     7.810   241.455     0.200
     7.810   241.984     0.200
     7.919   249.524     0.200
     7.939   251.834     0.200
     8.278   257.904     0.200
     8.485   268.725     0.200
     9.425   303.673     0.200
     6.489   206.227     0.200
     8.326   259.406     0.200
     3.253   104.953     0.200
    10.407   330.633     0.200
     2.856    94.358     0.200
     6.788   215.979     0.200
     7.517   236.329     0.200
     7.897   249.934     0.200
     8.507   268.659     0.200
     3.791   118.664     0.200
     4.128   130.320     0.200
     7.038   222.273     0.200
     7.367   232.984     0.200
     7.656   243.422     0.200
     7.778   242.148     0.200
     7.939   246.375     0.200
    11.320   361.180     0.200
     6.302   205.396     0.200
     3.002    93.796     0.200
     4.526   141.785     0.200
     5.637   175.636     0.200
     6.653   207.466     0.200
     7.386   229.405     0.200
     7.788   241.836     0.200
    10.408   326.436     0.200
    11.224   353.746     0.200
    11.346   358.136     0.200
    10.735   341.430     0.200
    10.436   328.969     0.200
    15.934   505.039     0.200
     4.137   132.535     0.200
     7.801   245.975     0.200
    10.431   330.285     0.200
     3.865   122.701     0.200
    10.442   328.762     0.200
     6.144   195.281     0.200
     7.977   249.336     0.200
     8.069   253.406     0.200
    10.801   339.805     0.200
    11.171   355.766     0.200
     2.725    85.635     0.200
     3.844   123.914     0.200
     5.647   180.904     0.200
     6.499   204.004     0.200
     3.055    99.211     0.200
     3.112    97.252     0.200
     3.678   114.980     0.200
     4.100   129.830     0.200
     5.555   180.910     0.200
     5.951   192.691     0.200
     6.209   200.131     0.200
     6.975   223.771     0.200
     7.266   231.941     0.200
     7.663   238.865     0.200
     7.674   242.650     0.200
     7.766   250.121     0.200
     7.849   251.451     0.200
     8.333   264.592     0.200
    10.312   324.721     0.200
     7.708   242.070     0.200
    10.388   326.609     0.200
    10.402   328.039     0.200
     5.577   178.408     0.200
     7.715   246.838     0.200
    10.359   325.977     0.200
     7.832   246.781     0.200
     8.439   265.754     0.200
    10.421   330.949     0.200
     6.051   192.959     0.200
     7.831   244.053     0.200
     2.994    93.812     0.200
     3.788   120.734     0.200
     4.141   132.875     0.200
     8.373   267.387     0.200
    10.409   329.164     0.200
     7.844   249.617     0.200
     8.455   268.312     0.200
    10.425   330.828     0.200
     3.090    98.086     0.200
     6.359   202.047     0.200
     6.904   218.414     0.200
     7.911   247.250     0.200
     2.548    81.305     0.200
     3.115    98.414     0.200
    11.479   364.148     0.200
     6.682   218.031     0.200
     9.189   295.156     0.200
    10.399   327.109     0.200
     6.586   213.602     0.200
     8.452   268.195     0.200
    10.491   328.008     0.200
     8.307   264.305     0.200
    10.677   334.281     0.200
     4.561   147.066     0.200
     7.007   226.696     0.200
     7.007   226.692     0.200
    10.128   317.236     0.200
    16.384   516.811     0.200
    23.186   732.436     0.200
     4.658   146.577     0.200
     7.844   246.926     0.200
     8.592   269.801     0.200
    10.338   321.579     0.200
    23.113   726.176     0.200
     3.793   119.039     0.200
     4.618   144.769     0.200
     5.778   180.319     0.200
     7.472   235.209     0.200
     2.548    79.274     0.200
     2.853    90.574     0.200
     4.667   148.594     0.200
     5.530   174.214     0.200
     5.608   181.144     0.200
     6.196   196.573     0.200
     6.630   209.214     0.200
     7.538   237.214     0.200
     7.647   245.814     0.200
     8.067   252.174     0.200
     8.090   257.804     0.200
     8.159   257.269     0.200
     8.159   256.924     0.200
    10.866   342.386     0.200
     4.021   125.376     0.200
     4.474   147.416     0.200
     5.561   178.937     0.200
     5.579   178.727     0.200
     6.753   212.937     0.200
     7.515   238.786     0.200
     8.023   250.826     0.200
     8.058   252.557     0.200
     8.242   256.376     0.200
    10.746   336.373     0.200
     2.805    88.179     0.200
     3.909   124.818     0.200
     4.662   147.988     0.200
     5.303   167.539     0.200
     5.500   175.648     0.200
     5.717   184.078     0.200
     6.752   214.969     0.200
     7.533   240.919     0.200
     7.880   250.469     0.200
    10.903   342.672     0.200
     4.352   137.378     0.200
     6.354   200.458     0.200
     4.642   146.045     0.200
     5.900   190.146     0.200
     7.510   234.835     0.200
     7.703   243.065     0.200
    10.676   334.239     0.200
     3.041   100.908     0.200
     3.317   104.568     0.200
     3.659   118.568     0.200
     3.989   124.689     0.200
     4.591   143.518     0.200
     5.688   185.939     0.200
     6.280   202.848     0.200
     6.318   203.379     0.200
     7.133   230.578     0.200
     7.445   240.059     0.200
     7.495   240.529     0.200
     7.773   243.928     0.200
     7.907   253.389     0.200
     8.276   267.609     0.200
    10.193   317.775     0.200
    11.580   368.727     0.200
    23.135   730.154     0.200
     2.533    80.141     0.200
     3.906   123.820     0.200
     5.612   179.211     0.200
     5.714   184.891     0.200
     6.145   196.650     0.200
     8.102   254.396     0.200
     3.647   116.506     0.200
     3.864   122.746     0.200
     4.607   148.686     0.200
     5.488   177.797     0.200
     5.697   179.877     0.200
     6.041   195.467     0.200
     6.577   211.055     0.200
     7.468   238.967     0.200
     8.431   264.766     0.200
     6.098   194.871     0.200
     8.073   253.199     0.200
     6.141   194.727     0.200
    10.896   343.559     0.200
    11.245   355.367     0.200
     7.855   243.449     0.200
     7.824   247.147     0.200
     8.585   273.322     0.200
    10.321   324.784     0.200
     3.011    94.137     0.200
     3.284   102.567     0.200
     4.556   142.478     0.200
     5.663   178.237     0.200
     5.877   185.018     0.200
     6.288   201.748     0.200
     6.851   219.308     0.200
     7.777   241.677     0.200
     8.252   261.538     0.200
     8.669   274.828     0.200
     3.855   121.026     0.200
     4.252   134.556     0.200
     2.839    88.929     0.200
     3.802   118.289     0.200
     3.934   122.439     0.200
     5.745   181.789     0.200
     6.183   195.454     0.200
     6.566   205.529     0.200
     7.533   235.619     0.200
     8.061   250.069     0.200
     8.147   256.429     0.200
     2.613    81.363     0.200
     4.242   133.414     0.200
     5.543   175.203     0.200
     5.605   178.953     0.200
     6.125   194.238     0.200
     8.096   256.812     0.200
     7.876   245.457     0.200
    10.413   328.898     0.200
     7.755   243.457     0.200
    10.193   323.570     0.200
     2.556    81.680     0.200
     3.920   124.695     0.200
     3.973   125.008     0.200
     4.192   132.586     0.200
     5.302   169.547     0.200
     8.066   250.359     0.200
     4.046   128.932     0.200
     5.724   187.012     0.200
     7.504   234.281     0.200
     7.761   246.292     0.200
     8.746   279.917     0.200
     8.051   254.900     0.200
    11.012   344.701     0.200
     8.726   276.137     0.200
    10.203   321.162     0.200
     4.290   136.062     0.200
     4.339   135.242     0.200
     7.509   239.580     0.200
    10.394   324.840     0.200
    10.394   324.845     0.200
    11.474   368.780     0.200
     2.775    87.169     0.200
     5.457   173.319     0.200
     5.533   174.149     0.200
     5.578   178.229     0.200
     5.678   181.129     0.200
     6.732   214.759     0.200
     7.406   238.319     0.200
     7.493   230.689     0.200
     7.580   241.049     0.200
     7.712   241.779     0.200
     8.017   251.209     0.200
     8.080   254.709     0.200
     8.072   255.039     0.200
    10.876   342.238     0.200
     3.814   124.012     0.200
     4.214   134.219     0.200
     5.764   186.449     0.200
     6.675   215.121     0.200
     7.487   237.309     0.200
     7.854   244.781     0.200
     8.882   288.719     0.200
     9.738   311.320     0.200
    11.471   365.699     0.200
    13.224   414.922     0.200
    23.072   726.324     0.200
    10.496   333.368     0.200
     7.891   245.283     0.200
     8.537   265.859     0.200
    10.422   327.037     0.200
     6.066   190.188     0.200
     3.796   118.578     0.200
     7.844   244.836     0.200
     8.534   265.336     0.200
    11.481   365.383     0.200
    11.481   365.383     0.200
     3.880   121.328     0.200
     5.271   167.871     0.200
     5.584   177.348     0.200
     5.690   180.078     0.200
     6.565   207.340     0.200
     8.077   250.262     0.200
     8.077   253.168     0.200
    10.892   344.375     0.200
     6.387   203.137     0.200
     8.434   267.188     0.200
    10.455   328.238     0.200
     7.720   245.527     0.200
     8.075   255.543     0.200
     8.090   257.477     0.200
     8.595   271.125     0.200
     7.764   243.301     0.200
     8.682   274.125     0.200
    10.195   322.152     0.200
    10.190   319.594     0.200
     2.946    94.043     0.200
     3.439   109.750     0.200
     3.746   119.680     0.200
     4.645   147.652     0.200
     5.447   174.449     0.200
     5.619   178.711     0.200
     3.663   115.832     0.200
     4.407   140.922     0.200
     7.883   249.555     0.200
     8.458   269.355     0.200
    10.464   330.730     0.200
     7.934   248.767     0.200
     2.742    86.037     0.200
     3.866   123.058     0.200
     5.470   171.827     0.200
     5.668   182.468     0.200
     8.058   254.938     0.200
    10.740   340.297     0.200
     2.781    87.551     0.200
     3.885   123.160     0.200
     3.917   122.820     0.200
     5.542   177.141     0.200
     6.124   196.770     0.200
     8.096   253.297     0.200
     8.100   254.371     0.200
     8.096   252.242     0.200
     8.104   255.234     0.200
     2.987    94.320     0.200
     3.847   121.348     0.200
     5.692   181.668     0.200
     2.523    79.160     0.200
     4.280   135.457     0.200
     5.629   180.938     0.200
     5.674   180.027     0.200
     6.094   195.551     0.200
     6.171   192.910     0.200
     8.078   254.539     0.200
     8.127   255.289     0.200
     3.566   111.774     0.200
     4.328   135.345     0.200
     3.032    97.309     0.200
     3.705   118.859     0.200
     3.830   123.137     0.200
     4.303   137.066     0.200
     7.857   245.418     0.200
     8.052   254.156     0.200
    10.423   328.109     0.200
    11.443   366.117     0.200
     3.638   113.102     0.200
     7.754   245.652     0.200
    10.172   321.676     0.200
     8.046   255.293     0.200
     6.541   206.383     0.200
     6.545   206.617     0.200
     7.728   244.258     0.200
     8.037   249.727     0.200
     8.083   252.828     0.200
     9.795   313.297     0.200
    10.600   333.883     0.200
    10.685   354.773     0.200
    10.941   345.930     0.200
    11.392   370.852     0.200
    11.583   378.406     0.200
     8.101   252.945     0.200
     8.113   252.352     0.200
     9.786   312.414     0.200
    10.610   333.188     0.200
     6.549   205.926     0.200
     6.560   205.676     0.200
     6.777   216.955     0.200
     7.748   243.955     0.200
     7.912   251.375     0.200
     8.097   254.379     0.200
     8.097   252.905     0.200
     8.119   257.998     0.200
     8.119   253.556     0.200
     3.863   120.926     0.200
     6.500   206.375     0.200
     3.806   120.037     0.200
     4.370   137.957     0.200
    10.380   326.234     0.200
    11.492   365.035     0.200
     3.834   130.227     0.200
     8.130   253.097     0.200
    10.606   332.085     0.200
     8.096   253.109     0.200
     8.150   257.484     0.200
    10.968   344.262     0.200
     2.705    84.365     0.200
     3.865   121.676     0.200
     6.464   202.756     0.200
     8.063   254.486     0.200
     6.189   196.668     0.200
     6.725   217.164     0.200
     8.151   255.242     0.200
    10.880   342.598     0.200
     3.889   122.902     0.200
     3.906   125.283     0.200
     4.274   135.963     0.200
     5.536   174.652     0.200
     7.871   247.758     0.200
     4.375   136.453     0.200
     5.456   175.664     0.200
     8.608   271.504     0.200
    10.312   324.777     0.200
     3.665   115.453     0.200
     3.958   125.443     0.200
     4.428   141.502     0.200
     4.682   151.053     0.200
     5.654   179.352     0.200
     6.209   201.283     0.200
     6.281   202.752     0.200
     6.842   219.943     0.200
     6.860   218.342     0.200
     2.972    95.555     0.200
     4.180   131.207     0.200
     4.583   145.707     0.200
     5.435   172.336     0.200
     6.384   203.938     0.200
     7.444   236.578     0.200
     4.107   127.867     0.200
     7.560   251.008     0.200
    11.283   358.602     0.200
     4.279   136.170     0.200
     7.508   241.500     0.200
     7.883   247.590     0.200
     8.086   252.900     0.200
     8.090   256.609     0.200
    12.737   410.369     0.200
     8.073   252.450     0.200
     8.188   257.275     0.200
     9.861   315.244     0.200
    11.021   349.512     0.200
    15.600   490.961     0.200
    26.696   840.201     0.200
     2.748    92.314     0.200
     3.836   122.834     0.200
     3.868   122.965     0.200
     6.468   204.305     0.200
     6.575   207.064     0.200
     7.547   245.094     0.200
     8.066   254.240     0.200
     8.066   253.514     0.200
     8.210   256.564     0.200
     4.715   149.904     0.200
     5.683   182.115     0.200
     6.081   192.715     0.200
     7.920   253.725     0.200
     8.075   255.494     0.200
     8.087   254.969     0.200
     8.183   259.109     0.200
     2.812    89.238     0.200
     3.917   124.199     0.200
     3.948   126.529     0.200
     6.155   195.578     0.200
     6.587   206.779     0.200
     8.044   254.908     0.200
     8.128   256.010     0.200
    10.903   344.465     0.200
     6.627   210.461     0.200
     8.483   268.711     0.200
     3.875   121.547     0.200
     4.258   132.785     0.200
     8.187   265.689     0.200
     4.643   148.379     0.200
     4.905   161.039     0.200
     5.477   174.352     0.200
     5.925   191.992     0.200
     6.801   218.422     0.200
     6.953   222.879     0.200
     7.110   230.980     0.200
     7.760   256.340     0.200
     8.085   253.031     0.200
     8.499   269.309     0.200
    16.201   510.707     0.200
    23.107   725.457     0.200
    26.252   826.305     0.200
     7.847   246.465     0.200
    10.371   328.215     0.200
     2.827    90.479     0.200
     3.685   116.760     0.200
     4.634   146.879     0.200
     5.475   173.270     0.200
     6.088   192.689     0.200
     7.493   234.779     0.200
     8.072   253.498     0.200
     8.475   269.818     0.200
     5.663   182.234     0.200
     7.786   242.709     0.200
    10.228   323.236     0.200
     3.339   106.980     0.200
     3.820   118.801     0.200
     4.294   137.980     0.200
     5.566   177.480     0.200
     6.360   201.251     0.200
     7.169   230.860     0.200
     7.840   246.922     0.200
     7.894   246.086     0.200
     7.944   248.094     0.200
     7.944   263.914     0.200
     8.198   255.539     0.200
     3.810   119.703     0.200
     4.365   136.383     0.200
     6.698   213.531     0.200
     7.499   235.473     0.200
     7.546   239.793     0.200
     9.172   292.586     0.200
    10.490   354.121     0.200
     2.773    86.617     0.200
     5.294   167.848     0.200
     6.544   206.039     0.200
     3.306   103.320     0.200
     7.448   237.750     0.200
     7.775   246.133     0.200
     8.113   258.051     0.200
    10.202   324.535     0.200
     6.478   208.977     0.200
     4.458   139.674     0.200
     6.553   212.443     0.200
    10.357   326.488     0.200
    11.290   359.342     0.200
     6.545   209.344     0.200
     8.360   265.195     0.200
    10.392   327.164     0.200
    11.311   358.008     0.200
    15.942   503.836     0.200
     3.761   119.497     0.200
     4.603   144.467     0.200
     4.444   139.289     0.200
     4.655   147.477     0.200
     4.927   156.562     0.200
     5.461   173.094     0.200
     5.621   177.195     0.200
    10.052   327.828     0.200
     4.826   152.262     0.200
     7.605   237.633     0.200
    10.863   340.480     0.200
    10.863   340.477     0.200
     3.283   103.328     0.200
     7.755   253.289     0.200
    10.257   320.578     0.200
    10.257   320.582     0.200
     3.910   125.441     0.200
     4.647   149.613     0.200
     6.700   217.770     0.200
    10.388   328.145     0.200
    11.494   365.383     0.200
     7.785   246.238     0.200
    10.407   326.984     0.200
    10.293   321.391     0.200
    11.339   358.637     0.200
     3.830   119.935     0.200
     6.370   202.334     0.200
     7.873   248.875     0.200
     8.086   253.785     0.200
     9.756   312.955     0.200
     5.642   181.025     0.200
     6.292   197.976     0.200
     3.748   119.555     0.200
     6.257   202.336     0.200
     6.373   203.242     0.200
     8.107   256.578     0.200
    10.408   330.156     0.200
     6.669   212.000     0.200
     6.741   216.059     0.200
     8.650   276.238     0.200
    10.739   341.863     0.200
     3.837   119.484     0.200
     8.385   270.984     0.200
     8.140   261.168     0.200
     8.276   261.348     0.200
     6.137   194.379     0.200
     4.212   137.305     0.200
     2.535    79.211     0.200
    10.746   336.734     0.200
     4.482   142.347     0.200
     4.665   146.616     0.200
     6.677   212.462     0.200
     7.887   253.196     0.200
     7.891   246.031     0.200
     8.235   258.526     0.200
     8.531   266.387     0.200
     9.770   308.717     0.200
     9.775   301.526     0.200
    10.469   348.877     0.200
    11.696   368.597     0.200
    14.043   439.206     0.200
    14.833   453.406     0.200
     6.682   213.865     0.200
     7.882   248.707     0.200
     8.532   269.912     0.200
    10.416   328.715     0.200
     3.067    98.043     0.200
     6.677   213.488     0.200
     7.865   247.033     0.200
     8.521   270.312     0.200
     6.409   200.117     0.200
     3.825   119.395     0.200
     7.099   226.838     0.200
     8.340   263.357     0.200
     2.951    97.953     0.200
     3.170    99.183     0.200
     4.374   138.623     0.200
     4.810   159.203     0.200
     4.890   159.983     0.200
     5.144   163.433     0.200
     5.270   172.273     0.200
     5.736   182.383     0.200
     7.512   237.333     0.200
     8.377   268.063     0.200
    10.325   323.698     0.200
     7.784   242.840     0.200
     4.919   162.809     0.200
     6.543   206.434     0.200
     7.761   243.855     0.200
    11.312   360.309     0.200
     8.354   260.781     0.200
    10.379   325.109     0.200
    11.301   358.766     0.200
     6.541   208.789     0.200
     7.763   241.258     0.200
    10.400   324.914     0.200
    11.312   355.391     0.200
     2.906    93.715     0.200
     7.743   239.189     0.200
     8.345   263.096     0.200
    10.388   325.443     0.200
    11.294   359.346     0.200
     7.858   246.602     0.200
     8.544   268.008     0.200
     9.166   293.203     0.200
    10.383   324.016     0.200
    11.227   352.133     0.200
    16.123   505.477     0.200
     6.089   196.531     0.200
     7.875   249.065     0.200
     7.979   249.655     0.200
    11.059   354.816     0.200
     6.554   208.561     0.200
     8.428   266.719     0.200
    10.522   331.568     0.200
    10.974   346.363     0.200
     7.795   246.768     0.200
     8.378   260.498     0.200
    11.340   361.148     0.200
     6.567   210.744     0.200
     7.850   245.888     0.200
     8.414   264.969     0.200
    10.456   326.944     0.200
     8.356   265.684     0.200
    10.383   328.902     0.200
     7.746   241.205     0.200
    10.390   328.436     0.200
     7.937   248.727     0.200
     8.249   255.598     0.200
     7.898   245.203     0.200
     8.046   253.938     0.200
    10.731   339.859     0.200
    11.121   353.180     0.200
     8.021   252.303     0.200
    11.005   345.754     0.200
    11.198   355.162     0.200
     7.893   248.639     0.200
     7.950   246.746     0.200
     6.065   192.732     0.200
     7.963   250.979     0.200
     6.526   207.087     0.200
     7.772   240.856     0.200
     8.347   262.337     0.200
    10.416   327.837     0.200
     7.760   243.508     0.200
    10.414   327.641     0.200
    11.053   346.438     0.200
    11.290   358.516     0.200
    11.052   347.992     0.200
     8.340   263.672     0.200
    10.424   331.477     0.200
    11.054   345.711     0.200
     7.745   243.208     0.200
     8.320   259.664     0.200
     3.715   120.471     0.200
     6.535   208.125     0.200
     7.733   243.744     0.200
    10.379   326.750     0.200
    15.925   501.770     0.200
     7.711   241.797     0.200
     8.330   259.051     0.200
    11.269   355.711     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.103     5.919     0.200
     0.720    22.819     0.200
     1.186    37.129     0.200
     1.286    41.129     0.200
     1.290    42.760     0.200
     1.345    42.760     0.200
     1.347    44.680     0.200
     0.777    23.977     0.200
     1.173    37.727     0.200
     1.271    40.715     0.200
     1.275    42.297     0.200
     1.333    42.375     0.200
     0.758    24.561     0.200
     1.225    38.910     0.200
     1.324    42.090     0.200
     1.354    44.621     0.200
     1.379    44.121     0.200
     1.432    45.480     0.200
     0.740    22.215     0.200
     1.205    38.184     0.200
     1.308    41.375     0.200
     1.362    43.355     0.200
     1.367    43.562     0.200
     1.418    44.934     0.200
     3.775   115.062     0.200
     0.052     3.113     0.200
     0.086     3.918     0.200
     0.333    10.285     0.200
     0.378    11.453     0.200
     0.639    20.758     0.200
     0.681    22.008     0.200
     0.914    27.648     0.200
     0.954    30.367     0.200
     0.973    31.238     0.200
     1.102    35.027     0.200
     1.126    35.660     0.200
     1.327    40.434     0.200
     0.203     5.578     0.200
     0.179     6.570     0.200
     0.216     7.984     0.200
     0.396    12.586     0.200
     0.674    21.883     0.200
     0.762    24.609     0.200
     0.912    28.219     0.200
     0.912    27.812     0.200
     0.867    27.578     0.200
     0.990    30.680     0.200
     0.990    30.086     0.200
     1.013    32.109     0.200
     1.086    34.469     0.200
     1.201    36.906     0.200
     1.234    39.383     0.200
     1.306    40.195     0.200
     1.257    40.070     0.200
     1.537    47.352     0.200
     1.532    47.906     0.200
     1.665    50.602     0.200
     2.254    69.945     0.200
     3.534   108.328     0.200
     3.759   116.094     0.200
     5.934   181.906     0.200
     6.350   195.359     0.200
     0.080     4.023     0.200
     0.535    16.586     0.200
     0.535    16.844     0.200
     0.640    20.656     0.200
     0.749    24.023     0.200
     0.950    30.320     0.200
     1.098    34.883     0.200
     1.121    35.555     0.200
     1.697    53.922     0.200
     0.625    19.662     0.200
     0.641    20.014     0.200
     0.725    22.074     0.200
     0.725    22.312     0.200
     1.033    31.555     0.200
     1.151    35.502     0.200
     1.392    43.682     0.200
     1.408    42.662     0.200
     2.189    64.961     0.200
     2.776    83.424     0.200
     2.800    84.193     0.200
     2.855    85.258     0.200
     2.899    87.672     0.200
     2.913    87.287     0.200
     3.102    93.195     0.200
     3.297    98.971     0.200
     3.573   106.096     0.200
     0.024     3.750     0.200
     0.075     5.031     0.200
     0.625    19.625     0.200
     0.650    20.422     0.200
     0.733    22.242     0.200
     0.991    32.203     0.200
     1.039    32.039     0.200
     1.151    37.094     0.200
     1.398    46.125     0.200
     1.577    48.438     0.200
     1.850    56.188     0.200
     1.960    59.953     0.200
     2.192    66.586     0.200
     2.444    74.086     0.200
     2.478    74.922     0.200
     2.785    83.656     0.200
     2.780    84.094     0.200
     2.780    84.484     0.200
     2.807    85.898     0.200
     0.046     4.281     0.200
     0.627    19.766     0.200
     0.726    22.055     0.200
     1.012    33.078     0.200
     1.139    35.969     0.200
     1.156    36.109     0.200
     1.354    40.734     0.200
     1.342    42.945     0.200
     1.384    43.727     0.200
     1.558    47.664     0.200
     1.701    52.227     0.200
     1.937    59.523     0.200
     2.090    63.297     0.200
     2.469    74.633     0.200
     0.642    20.128     0.200
     0.636    20.189     0.200
     0.683    21.976     0.200
     0.740    22.424     0.200
     0.999    31.856     0.200
     1.021    31.845     0.200
     1.134    36.696     0.200
     1.155    36.056     0.200
     1.331    41.456     0.200
     1.400    43.495     0.200
     1.400    47.356     0.200
     1.559    47.933     0.200
     1.715    52.829     0.200
     1.860    56.505     0.200
     1.943    59.882     0.200
     2.105    63.415     0.200
     2.248    69.183     0.200
     2.455    74.077     0.200
     2.644    81.188     0.200
     2.762    83.819     0.200
     2.789    84.329     0.200
     2.944    90.485     0.200
     0.045     3.930     0.200
     0.635    20.082     0.200
     0.628    20.090     0.200
     0.726    22.148     0.200
     1.011    33.020     0.200
     1.020    31.262     0.200
     1.140    36.219     0.200
     1.157    35.879     0.200
     1.352    40.582     0.200
     1.343    42.859     0.200
     1.386    44.039     0.200
     1.414    45.719     0.200
     1.560    47.875     0.200
     1.846    55.805     0.200
     1.939    59.422     0.200
     2.090    62.988     0.200
     2.196    66.652     0.200
     2.443    74.156     0.200
     2.469    74.855     0.200
     2.762    83.391     0.200
     2.940    90.430     0.200
     0.045     2.719     0.200
     0.473    15.949     0.200
     0.627    19.523     0.200
     0.641    20.332     0.200
     0.732    22.109     0.200
     1.010    33.090     0.200
     1.016    30.965     0.200
     1.134    36.191     0.200
     1.152    35.270     0.200
     1.201    36.477     0.200
     1.337    42.430     0.200
     1.359    40.578     0.200
     1.379    44.070     0.200
     1.411    43.281     0.200
     1.852    56.227     0.200
     1.936    59.438     0.200
     2.095    62.742     0.200
     2.203    66.738     0.200
     2.475    74.836     0.200
     2.758    83.180     0.200
     2.783    84.738     0.200
     2.883    88.680     0.200
     0.031     3.383     0.200
     0.031     3.533     0.200
     0.643    20.035     0.200
     0.626    19.225     0.200
     0.728    22.195     0.200
     0.998    32.453     0.200
     1.035    31.357     0.200
     1.344    40.729     0.200
     1.346    42.854     0.200
     1.390    44.043     0.200
     1.574    48.109     0.200
     1.846    55.795     0.200
     1.954    59.732     0.200
     2.094    62.631     0.200
     2.776    83.826     0.200
     2.802    85.176     0.200
     2.901    89.943     0.200
     2.956    89.873     0.200
     0.031     2.455     0.200
     0.632    20.123     0.200
     0.642    19.992     0.200
     0.659    21.565     0.200
     0.692    22.234     0.200
     0.734    21.975     0.200
     0.997    32.605     0.200
     1.031    31.557     0.200
     1.144    35.726     0.200
     1.165    36.235     0.200
     1.350    40.384     0.200
     1.339    42.755     0.200
     1.383    43.646     0.200
     1.852    56.314     0.200
     1.951    59.992     0.200
     2.197    67.017     0.200
     2.478    75.133     0.200
     2.772    84.579     0.200
     0.626    19.281     0.200
     0.643    20.109     0.200
     0.677    21.156     0.200
     0.736    24.211     0.200
     1.015    31.266     0.200
     1.133    36.203     0.200
     1.133    36.453     0.200
     1.151    36.398     0.200
     1.460    44.180     0.200
     1.411    44.875     0.200
     1.853    56.250     0.200
     2.096    62.930     0.200
     2.475    74.688     0.200
     2.756    82.727     0.200
     2.757    83.547     0.200
     2.782    84.547     0.200
     3.555   108.828     0.200
     0.729    24.944     0.200
     1.012    31.294     0.200
     1.466    44.094     0.200
     1.551    47.649     0.200
     1.709    52.208     0.200
     1.934    59.066     0.200
     2.102    62.849     0.200
     2.481    75.113     0.200
     2.754    83.560     0.200
     2.754    83.680     0.200
     2.780    84.125     0.200
     3.083    92.947     0.200
     3.281    99.268     0.200
     0.018     3.492     0.200
     0.018     3.992     0.200
     0.678    21.438     0.200
     0.635    20.266     0.200
     0.767    23.227     0.200
     1.053    32.656     0.200
     1.144    36.578     0.200
     1.179    36.484     0.200
     1.357    40.859     0.200
     1.499    45.445     0.200
     1.586    48.641     0.200
     1.607    48.609     0.200
     0.580    18.195     0.200
     0.744    23.156     0.200
     0.769    24.594     0.200
     0.752    25.758     0.200
     0.934    30.094     0.200
     1.203    36.750     0.200
     1.303    39.047     0.200
     1.561    46.984     0.200
     1.645    50.234     0.200
     2.026    60.234     0.200
     2.163    64.258     0.200
     0.198     5.419     0.200
     0.248     8.949     0.200
     1.122    35.849     0.200
     1.213    37.019     0.200
     1.177    38.079     0.200
     1.206    37.349     0.200
     1.206    38.799     0.200
     1.268    40.289     0.200
     3.027    92.239     0.200
     3.075    93.299     0.200
     0.060     2.734     0.200
     0.601    18.992     0.200
     0.774    23.703     0.200
     1.109    33.484     0.200
     1.187    37.109     0.200
     1.230    37.641     0.200
     1.330    41.633     0.200
     1.330    45.312     0.200
     1.587    48.250     0.200
     1.639    50.086     0.200
     1.879    56.969     0.200
     2.046    61.500     0.200
     2.146    64.438     0.200
     2.188    65.203     0.200
     4.507   139.281     0.200
     0.139     7.047     0.200
     0.652    20.219     0.200
     0.965    30.195     0.200
     1.013    31.164     0.200
     1.097    34.820     0.200
     1.324    41.891     0.200
     1.354    43.773     0.200
     1.354    44.000     0.200
     1.522    45.711     0.200
     1.541    47.508     0.200
     1.944    59.656     0.200
     2.130    64.055     0.200
     2.651    79.992     0.200
     2.748    82.305     0.200
     2.781    85.336     0.200
     3.092    93.680     0.200
     3.302    99.664     0.200
     3.533   106.523     0.200
     3.584   107.922     0.200
     0.481    15.660     0.200
     0.987    30.801     0.200
     0.997    31.531     0.200
     2.712    83.371     0.200
     2.765    82.711     0.200
     0.799    23.855     0.200
     0.799    24.319     0.200
     1.123    34.690     0.200
     1.187    37.556     0.200
     1.238    38.485     0.200
     1.537    46.832     0.200
     1.815    56.056     0.200
     2.054    63.483     0.200
     2.171    65.604     0.200
     2.856    85.728     0.200
     2.891    87.611     0.200
     2.981    90.858     0.200
     3.055    92.855     0.200
     3.791   116.386     0.200
     4.254   130.376     0.200
     0.265     9.289     0.200
     0.632    19.422     0.200
     1.088    35.359     0.200
     1.403    42.586     0.200
     2.671    80.551     0.200
     2.877    88.699     0.200
     2.914    89.457     0.200
     3.059    92.555     0.200
     4.216   131.180     0.200
     0.082     5.594     0.200
     0.086     5.633     0.200
     0.119     6.555     0.200
     0.499    15.914     0.200
     0.779    23.375     0.200
     1.089    33.734     0.200
     1.089    33.734     0.200
     1.167    36.906     0.200
     1.199    38.086     0.200
     1.210    37.719     0.200
     1.333    41.383     0.200
     1.333    43.367     0.200
     1.618    49.938     0.200
     2.150    64.758     0.200
     2.825    85.461     0.200
     2.857    86.039     0.200
     3.166    96.734     0.200
     0.090     4.665     0.200
     0.135     6.905     0.200
     0.084     5.605     0.200
     0.502    16.645     0.200
     0.793    23.925     0.200
     0.793    24.233     0.200
     1.098    34.139     0.200
     1.097    34.139     0.200
     1.167    36.745     0.200
     1.214    36.875     0.200
     1.316    40.435     0.200
     1.317    42.015     0.200
     2.831    85.381     0.200
     2.865    86.645     0.200
     3.811   117.085     0.200
     0.223     7.781     0.200
     0.226     7.730     0.200
     1.041    33.521     0.200
     1.124    35.891     0.200
     1.149    37.580     0.200
     1.150    36.791     0.200
     1.150    38.830     0.200
     1.150    39.920     0.200
     1.193    37.961     0.200
     1.223    37.111     0.200
     1.257    39.842     0.200
     1.697    51.580     0.200
     1.697    51.852     0.200
     3.045    92.121     0.200
     0.371    12.094     0.200
     0.371    12.570     0.200
     0.384    12.375     0.200
     0.381    13.961     0.200
     0.692    21.617     0.200
     0.692    21.617     0.200
     0.788    24.172     0.200
     0.778    24.320     0.200
     1.250    37.898     0.200
     1.294    40.461     0.200
     1.624    48.836     0.200
     2.439    74.047     0.200
     2.454    73.930     0.200
     2.601    78.430     0.200
     2.749    82.781     0.200
     0.253     7.578     0.200
     0.537    16.801     0.200
     0.536    16.801     0.200
     0.523    18.014     0.200
     0.709    22.404     0.200
     0.799    25.264     0.200
     0.918    28.178     0.200
     1.057    32.637     0.200
     1.385    42.725     0.200
     1.459    44.592     0.200
     1.671    52.113     0.200
     1.672    54.824     0.200
     1.811    56.105     0.200
     2.170    65.584     0.200
     2.408    73.004     0.200
     2.460    73.805     0.200
     2.607    79.137     0.200
     3.052    92.604     0.200
     3.081    95.174     0.200
     3.684   112.135     0.200
     0.149     6.971     0.200
     0.702    21.182     0.200
     0.832    27.160     0.200
     0.828    26.051     0.200
     0.861    27.309     0.200
     0.924    28.602     0.200
     1.333    40.801     0.200
     1.443    43.475     0.200
     1.448    46.182     0.200
     1.504    47.551     0.200
     2.075    61.297     0.200
     2.074    61.637     0.200
     5.343   165.980     0.200
     0.084     5.219     0.200
     0.035     4.320     0.200
     0.688    20.578     0.200
     0.784    24.211     0.200
     0.806    25.812     0.200
     0.806    26.430     0.200
     1.238    39.297     0.200
     1.426    43.391     0.200
     1.409    42.008     0.200
     1.409    43.727     0.200
     1.570    47.938     0.200
     2.060    62.414     0.200
     2.113    64.750     0.200
     2.870    86.797     0.200
     2.865    85.547     0.200
     2.865    85.547     0.200
     3.716   114.359     0.200
     0.101     5.336     0.200
     0.430    14.336     0.200
     0.494    16.211     0.200
     0.528    17.000     0.200
     1.017    31.500     0.200
     1.239    38.969     0.200
     1.321    42.117     0.200
     1.435    44.898     0.200
     1.449    47.352     0.200
     1.481    46.281     0.200
     0.022     4.627     0.200
     0.101     5.168     0.200
     0.416    13.238     0.200
     0.731    21.607     0.200
     0.784    26.047     0.200
     0.919    28.568     0.200
     1.692    52.072     0.200
     2.062    64.098     0.200
     2.896    88.002     0.200
     0.128     4.090     0.200
     0.142     4.859     0.200
     0.658    21.930     0.200
     0.734    23.621     0.200
     0.856    26.141     0.200
     1.137    36.629     0.200
     1.126    34.805     0.200
     1.161    36.570     0.200
     1.229    37.781     0.200
     1.249 