#!/bin/bash
gmt begin elmayor5.35_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source elmayor5.35'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6 -10.0
  0.6 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.103    -0.964     0.200
     0.073    -0.551     0.200
     0.340     0.526     0.200
     0.425     0.157     0.200
     0.469    -0.346     0.200
     0.605    -0.277     0.200
     0.614    -0.232     0.200
     0.720     0.146     0.200
     0.760    -0.760     0.200
     0.733     0.531     0.200
     0.733     0.851     0.200
     0.467    -0.300     0.200
     0.609    -0.276     0.200
     0.713     0.076     0.200
     0.716     0.076     0.200
     0.750    -0.009     0.200
     0.776    -0.517     0.200
     0.403     0.246     0.200
     0.501    -0.152     0.200
     0.517     0.315     0.200
     0.570     0.120     0.200
     0.630    -0.054     0.200
     0.649    -0.311     0.200
     0.740    -0.766     0.200
     0.758     0.066     0.200
     0.793    -0.101     0.200
     0.806    -0.609     0.200
     0.477    -0.181     0.200
     0.625    -0.280     0.200
     0.734     0.063     0.200
     0.740    -0.876     0.200
     0.052    -0.099     0.200
     0.086     0.015     0.200
     0.111    -0.385     0.200
     0.212    -0.709     0.200
     0.274    -0.004     0.200
     0.316     0.055     0.200
     0.333    -0.429     0.200
     0.378    -0.480     0.200
     0.527    -0.253     0.200
     0.639     0.140     0.200
     0.681     0.352     0.200
     0.759     0.050     0.200
     0.798    -0.216     0.200
     0.914    -0.528     0.200
     0.954     0.292     0.200
     0.973     0.105     0.200
     0.153    -0.173     0.200
     0.203    -0.821     0.200
     0.179    -0.003     0.200
     0.207    -0.106     0.200
     0.216     0.020     0.200
     0.250    -0.104     0.200
     0.396    -0.479     0.200
     0.674     0.120     0.200
     0.762    -0.078     0.200
     0.912    -0.715     0.200
     0.912    -0.894     0.200
     0.867    -0.206     0.200
     0.957    -0.643     0.200
     0.964    -0.662     0.200
     0.055    -0.153     0.200
     0.055    -0.466     0.200
     0.080     0.067     0.200
     0.100    -0.319     0.200
     0.219    -0.609     0.200
     0.271     0.144     0.200
     0.265     0.020     0.200
     0.314     0.091     0.200
     0.336    -0.535     0.200
     0.390    -0.551     0.200
     0.535    -0.305     0.200
     0.640     0.052     0.200
     0.671    -0.644     0.200
     0.749    -0.044     0.200
     0.793    -0.310     0.200
     0.950     0.260     0.200
     0.999    -0.587     0.200
     0.034    -0.786     0.200
     0.070    -0.491     0.200
     0.143     0.570     0.200
     0.400    -0.112     0.200
     0.422     0.503     0.200
     0.441     0.308     0.200
     0.466     0.427     0.200
     0.528     0.084     0.200
     0.551    -0.221     0.200
     0.565    -0.017     0.200
     0.625    -0.472     0.200
     0.641    -0.559     0.200
     0.657    -0.347     0.200
     0.696    -0.231     0.200
     0.696     0.025     0.200
     0.703    -0.262     0.200
     0.711    -0.343     0.200
     0.746     0.744     0.200
     0.725    -1.062     0.200
     0.725    -0.656     0.200
     0.725    -0.845     0.200
     0.909    -0.474     0.200
     0.024    -0.562     0.200
     0.075    -0.694     0.200
     0.136     0.769     0.200
     0.406    -0.089     0.200
     0.433     0.463     0.200
     0.450     0.075     0.200
     0.455     0.585     0.200
     0.537     0.054     0.200
     0.556    -0.164     0.200
     0.625    -0.360     0.200
     0.650    -0.623     0.200
     0.658    -0.520     0.200
     0.701     0.086     0.200
     0.711    -0.278     0.200
     0.733    -0.774     0.200
     0.733    -1.118     0.200
     0.740     0.702     0.200
     0.991    -0.441     0.200
     0.046    -0.473     0.200
     0.385    -0.218     0.200
     0.412     0.387     0.200
     0.439     0.084     0.200
     0.475     0.354     0.200
     0.514    -0.032     0.200
     0.536    -0.324     0.200
     0.637    -0.499     0.200
     0.627    -0.633     0.200
     0.669    -0.595     0.200
     0.682    -0.050     0.200
     0.688    -0.386     0.200
     0.726    -0.836     0.200
     0.742     0.449     0.200
     0.036    -0.331     0.200
     0.088    -0.032     0.200
     0.152     1.134     0.200
     0.425     0.059     0.200
     0.454    -0.183     0.200
     0.462     0.685     0.200
     0.538    -0.390     0.200
     0.642    -0.810     0.200
     0.636    -0.626     0.200
     0.675    -0.694     0.200
     0.683    -0.224     0.200
     0.694    -0.455     0.200
     0.740    -0.999     0.200
     0.740    -0.323     0.200
     0.729     0.915     0.200
     0.999    -0.345     0.200
     0.045    -0.863     0.200
     0.413     0.318     0.200
     0.439     0.054     0.200
     0.475     0.217     0.200
     0.538    -0.307     0.200
     0.635    -0.489     0.200
     0.628    -0.633     0.200
     0.668    -0.610     0.200
     0.683    -0.229     0.200
     0.690    -0.305     0.200
     0.726    -0.809     0.200
     0.743     0.458     0.200
     0.045    -1.606     0.200
     0.414     0.274     0.200
     0.444     0.019     0.200
     0.473     0.448     0.200
     0.533    -0.131     0.200
     0.627    -0.638     0.200
     0.641    -0.429     0.200
     0.679     0.019     0.200
     0.674    -0.531     0.200
     0.687    -0.327     0.200
     0.732    -0.816     0.200
     0.737     0.681     0.200
     0.031    -0.610     0.200
     0.401    -0.066     0.200
     0.463     0.361     0.200
     0.552    -0.195     0.200
     0.643    -0.536     0.200
     0.626    -0.382     0.200
     0.705    -0.259     0.200
     0.728    -0.744     0.200
     0.728    -0.627     0.200
     0.998     0.893     0.200
     0.031    -1.448     0.200
     0.398    -0.145     0.200
     0.427     0.313     0.200
     0.449     0.094     0.200
     0.461     0.703     0.200
     0.529    -0.028     0.200
     0.547    -0.133     0.200
     0.642    -1.036     0.200
     0.664    -0.311     0.200
     0.659     0.229     0.200
     0.702    -0.281     0.200
     0.734    -0.889     0.200
     0.737     0.037     0.200
     0.997     0.295     0.200
     0.046    -0.802     0.200
     0.085    -0.409     0.200
     0.161     0.527     0.200
     0.381    -0.199     0.200
     0.414     0.393     0.200
     0.444     0.153     0.200
     0.513     0.001     0.200
     0.532    -0.302     0.200
     0.626    -0.548     0.200
     0.643    -0.815     0.200
     0.645     0.073     0.200
     0.675    -0.550     0.200
     0.686    -0.314     0.200
     0.677    -0.116     0.200
     0.736     0.415     0.200
     0.380    -0.227     0.200
     0.417     0.314     0.200
     0.450     0.090     0.200
     0.513    -0.071     0.200
     0.529    -0.268     0.200
     0.626    -0.675     0.200
     0.641     0.070     0.200
     0.648    -0.512     0.200
     0.685    -0.149     0.200
     0.674    -0.040     0.200
     0.680    -0.650     0.200
     0.729     0.481     0.200
     0.018    -0.902     0.200
     0.104    -0.587     0.200
     0.119     0.816     0.200
     0.424    -0.080     0.200
     0.449     0.246     0.200
     0.487     0.043     0.200
     0.564    -0.046     0.200
     0.568    -0.095     0.200
     0.678    -0.687     0.200
     0.635    -0.299     0.200
     0.675     0.303     0.200
     0.669    -0.340     0.200
     0.711     0.207     0.200
     0.733    -0.323     0.200
     0.767    -0.918     0.200
     0.712     1.053     0.200
     0.408    -0.093     0.200
     0.405    -0.198     0.200
     0.479     0.043     0.200
     0.478    -0.246     0.200
     0.493     0.367     0.200
     0.495     0.470     0.200
     0.580    -0.531     0.200
     0.609     0.009     0.200
     0.626    -0.333     0.200
     0.734     0.022     0.200
     0.769    -0.258     0.200
     0.784    -0.558     0.200
     0.752     0.333     0.200
     0.934    -0.034     0.200
     0.198    -1.392     0.200
     0.248     0.163     0.200
     0.535    -0.066     0.200
     0.586     0.285     0.200
     0.649    -0.203     0.200
     0.667    -0.128     0.200
     0.729    -0.259     0.200
     0.753    -0.359     0.200
     0.788     0.326     0.200
     0.480    -0.038     0.200
     0.508     0.029     0.200
     0.514     0.434     0.200
     0.601    -0.415     0.200
     0.619     0.056     0.200
     0.623    -0.070     0.200
     0.635    -0.594     0.200
     0.724     0.641     0.200
     0.728     0.012     0.200
     0.732    -0.730     0.200
     0.765     0.224     0.200
     0.774    -0.970     0.200
     0.789    -0.366     0.200
     0.059    -1.197     0.200
     0.139     0.020     0.200
     0.162     0.518     0.200
     0.388    -0.208     0.200
     0.463     0.265     0.200
     0.507    -0.033     0.200
     0.527    -0.192     0.200
     0.538    -0.140     0.200
     0.652    -0.699     0.200
     0.668     0.146     0.200
     0.676     0.554     0.200
     0.715    -0.623     0.200
     0.209    -0.501     0.200
     0.329     0.182     0.200
     0.358    -0.069     0.200
     0.362    -0.388     0.200
     0.463     0.141     0.200
     0.481    -0.045     0.200
     0.517    -0.086     0.200
     0.708     0.280     0.200
     0.987    -0.081     0.200
     0.997     0.364     0.200
     0.085    -1.046     0.200
     0.535     0.009     0.200
     0.498    -0.118     0.200
     0.541     0.255     0.200
     0.643    -0.355     0.200
     0.675    -0.638     0.200
     0.641     0.036     0.200
     0.799    -0.957     0.200
     0.755    -0.735     0.200
     0.708     0.439     0.200
     0.776     0.237     0.200
     0.808    -0.409     0.200
     0.265     0.431     0.200
     0.464    -0.852     0.200
     0.534    -0.202     0.200
     0.559    -0.398     0.200
     0.629     0.293     0.200
     0.632    -0.220     0.200
     0.643     0.132     0.200
     0.799    -0.073     0.200
     0.831    -0.338     0.200
     0.825     0.165     0.200
     0.839     0.599     0.200
     0.901    -0.589     0.200
     0.876     0.455     0.200
     0.876    -0.127     0.200
     0.904     0.071     0.200
     0.933     0.430     0.200
     0.977    -0.275     0.200
     0.984    -0.278     0.200
     0.046    -1.335     0.200
     0.086    -0.596     0.200
     0.119    -0.424     0.200
     0.444     0.158     0.200
     0.461    -0.232     0.200
     0.499    -0.724     0.200
     0.487     0.269     0.200
     0.507     0.048     0.200
     0.602    -0.023     0.200
     0.603    -0.175     0.200
     0.639    -0.306     0.200
     0.716    -0.648     0.200
     0.707     0.008     0.200
     0.712     0.086     0.200
     0.744     0.141     0.200
     0.779    -0.796     0.200
     0.779    -0.921     0.200
     0.770    -0.388     0.200
     0.791    -0.501     0.200
     0.868    -0.408     0.200
     0.969    -0.509     0.200
     0.062    -1.476     0.200
     0.135    -0.266     0.200
     0.084    -0.667     0.200
     0.458     0.187     0.200
     0.467     0.554     0.200
     0.500     0.189     0.200
     0.524     0.083     0.200
     0.502    -0.349     0.200
     0.616    -0.109     0.200
     0.611    -0.132     0.200
     0.729    -0.725     0.200
     0.713    -0.047     0.200
     0.702     0.309     0.200
     0.751     0.049     0.200
     0.782    -0.369     0.200
     0.793    -0.912     0.200
     0.807    -0.579     0.200
     0.882    -0.464     0.200
     0.978    -0.521     0.200
     0.223    -0.369     0.200
     0.226    -0.250     0.200
     0.573     0.568     0.200
     0.601    -0.102     0.200
     0.623     0.026     0.200
     0.652     0.173     0.200
     0.667    -0.279     0.200
     0.693    -0.287     0.200
     0.729     0.085     0.200
     0.743    -0.140     0.200
     0.762    -0.371     0.200
     0.194    -0.162     0.200
     0.235    -0.325     0.200
     0.306    -0.545     0.200
     0.350    -0.303     0.200
     0.371    -0.226     0.200
     0.384    -0.103     0.200
     0.381     0.521     0.200
     0.482     0.269     0.200
     0.458     0.714     0.200
     0.692    -0.091     0.200
     0.692    -0.081     0.200
     0.788    -0.981     0.200
     0.788    -0.661     0.200
     0.758    -0.238     0.200
     0.778    -0.134     0.200
     0.866    -0.128     0.200
     0.089    -0.189     0.200
     0.100    -0.158     0.200
     0.179    -0.105     0.200
     0.230    -0.321     0.200
     0.253    -0.797     0.200
     0.537    -0.495     0.200
     0.536    -0.485     0.200
     0.523     0.632     0.200
     0.606     0.702     0.200
     0.709    -0.243     0.200
     0.799     0.094     0.200
     0.799     0.213     0.200
     0.862    -0.411     0.200
     0.918    -0.832     0.200
     0.149     0.520     0.200
     0.418     0.226     0.200
     0.466    -0.055     0.200
     0.519    -0.579     0.200
     0.563     0.043     0.200
     0.702    -0.909     0.200
     0.716    -0.204     0.200
     0.787    -0.958     0.200
     0.832    -0.354     0.200
     0.861    -0.310     0.200
     0.084     0.530     0.200
     0.035     0.074     0.200
     0.351    -0.116     0.200
     0.488     0.017     0.200
     0.483     0.161     0.200
     0.543     0.300     0.200
     0.569    -0.248     0.200
     0.564    -0.559     0.200
     0.453    -0.180     0.200
     0.597     0.118     0.200
     0.638    -0.083     0.200
     0.572    -0.620     0.200
     0.708    -0.711     0.200
     0.688    -1.024     0.200
     0.688    -0.673     0.200
     0.747    -0.483     0.200
     0.752     0.283     0.200
     0.780    -0.525     0.200
     0.784    -0.010     0.200
     0.806     0.349     0.200
     0.992    -0.780     0.200
     0.101     0.353     0.200
     0.320    -0.045     0.200
     0.430    -0.141     0.200
     0.494    -0.558     0.200
     0.463    -0.136     0.200
     0.460     0.438     0.200
     0.517     0.131     0.200
     0.528    -0.171     0.200
     0.569    -0.454     0.200
     0.622    -0.367     0.200
     0.654    -0.865     0.200
     0.741    -0.169     0.200
     0.829    -0.176     0.200
     0.022     0.193     0.200
     0.101     0.449     0.200
     0.416    -0.801     0.200
     0.399     0.689     0.200
     0.523     0.095     0.200
     0.571    -0.325     0.200
     0.612    -0.702     0.200
     0.647    -0.145     0.200
     0.672    -0.073     0.200
     0.731    -0.790     0.200
     0.731    -1.136     0.200
     0.759    -1.060     0.200
     0.781    -0.027     0.200
     0.784     0.890     0.200
     0.816    -0.160     0.200
     0.919    -0.653     0.200
     0.128    -0.583     0.200
     0.142    -0.117     0.200
     0.512    -0.103     0.200
     0.590     0.068     0.200
     0.658     0.322     0.200
     0.641    -0.232     0.200
     0.667    -0.010     0.200
     0.686    -0.091     0.200
     0.734    -0.189     0.200
     0.781    -0.803     0.200
     0.841    -0.435     0.200
     0.825    -0.316     0.200
     0.856    -0.934     0.200
     0.856    -1.074     0.200
     0.142    -0.228     0.200
     0.129    -0.644     0.200
     0.658     0.434     0.200
     0.734    -0.212     0.200
     0.781    -0.812     0.200
     0.840    -0.364     0.200
     0.856    -1.031     0.200
     0.856    -0.540     0.200
     0.073    -0.317     0.200
     0.366     0.050     0.200
     0.744    -0.587     0.200
     0.784    -0.980     0.200
     0.898     0.729     0.200
     0.144    -0.265     0.200
     0.160     0.111     0.200
     0.289     0.250     0.200
     0.644    -0.052     0.200
     0.677    -0.090     0.200
     0.699    -0.348     0.200
     0.791    -0.710     0.200
     0.827    -0.202     0.200
     0.873    -1.102     0.200
     0.148    -0.250     0.200
     0.162     0.079     0.200
     0.222     0.524     0.200
     0.284    -0.465     0.200
     0.305     1.308     0.200
     0.538     0.285     0.200
     0.524     0.036     0.200
     0.549     0.606     0.200
     0.565     0.264     0.200
     0.611    -0.074     0.200
     0.611     0.204     0.200
     0.650    -0.120     0.200
     0.698    -0.352     0.200
     0.683     0.009     0.200
     0.796    -0.754     0.200
     0.837    -0.284     0.200
     0.876    -0.571     0.200
     0.876    -1.157     0.200
     0.840     0.273     0.200
     0.880     0.557     0.200
     0.230     0.137     0.200
     0.190    -0.055     0.200
     0.689    -0.336     0.200
     0.918    -0.599     0.200
     0.928    -1.156     0.200
     0.928    -0.719     0.200
     0.218     0.714     0.200
     0.577    -0.143     0.200
     0.674     0.000     0.200
     0.695     0.058     0.200
     0.742     0.013     0.200
     0.856    -0.841     0.200
     0.202     0.251     0.200
     0.312    -0.318     0.200
     0.745    -0.393     0.200
     0.773    -0.882     0.200
     0.754    -0.322     0.200
     0.785    -0.059     0.200
     0.870    -0.500     0.200
     0.903    -0.908     0.200
     0.962     0.053     0.200
     0.374    -0.317     0.200
     0.444    -0.073     0.200
     0.555    -0.638     0.200
     0.575    -0.358     0.200
     0.572    -0.316     0.200
     0.654    -1.203     0.200
     0.714    -1.250     0.200
     0.723    -0.397     0.200
     0.738    -0.671     0.200
     0.968     0.306     0.200
     0.185    -1.233     0.200
     0.488    -0.026     0.200
     0.799     0.012     0.200
     0.925    -0.265     0.200
     0.933     0.259     0.200
     0.964     0.261     0.200
     0.964     0.161     0.200
     0.178     0.179     0.200
     0.497     0.325     0.200
     0.495     0.343     0.200
     0.539     0.088     0.200
     0.613    -0.028     0.200
     0.711    -0.800     0.200
     0.727    -0.734     0.200
     0.888    -0.535     0.200
     0.944     0.111     0.200
     0.226    -0.591     0.200
     0.720    -0.581     0.200
     0.910    -0.501     0.200
     0.148    -1.253     0.200
     0.272     0.519     0.200
     0.824     0.102     0.200
     0.221     0.060     0.200
     0.269    -0.066     0.200
     0.366    -0.724     0.200
     0.646    -0.359     0.200
     0.731    -1.304     0.200
     0.784    -0.070     0.200
     0.816     0.328     0.200
     0.909    -0.688     0.200
     0.364    -0.035     0.200
     0.473    -0.480     0.200
     0.486    -0.353     0.200
     0.565     0.158     0.200
     0.601    -1.419     0.200
     0.778    -0.265     0.200
     0.876    -0.893     0.200
     0.893     0.138     0.200
     0.893     0.029     0.200
     0.900    -0.066     0.200
     0.232    -0.175     0.200
     0.307    -0.261     0.200
     0.323    -0.663     0.200
     0.602    -0.125     0.200
     0.607    -0.623     0.200
     0.752     0.056     0.200
     0.781    -0.647     0.200
     0.805     0.567     0.200
     0.913    -0.694     0.200
     0.718    -0.399     0.200
     0.872    -0.831     0.200
     0.857    -0.141     0.200
     0.940     0.236     0.200
     0.969    -0.091     0.200
     0.138    -0.380     0.200
     0.557     0.343     0.200
     0.119    -0.300     0.200
     0.229    -0.119     0.200
     0.305    -0.420     0.200
     0.320    -0.523     0.200
     0.600    -0.149     0.200
     0.751     0.072     0.200
     0.783     0.366     0.200
     0.806     0.386     0.200
     0.321    -0.540     0.200
     0.474    -0.170     0.200
     0.598    -0.162     0.200
     0.636    -0.023     0.200
     0.861    -0.710     0.200
     0.750    -0.720     0.200
     0.871    -0.874     0.200
     0.871    -1.057     0.200
     0.069    -0.128     0.200
     0.103    -0.133     0.200
     0.191     0.034     0.200
     0.258    -0.276     0.200
     0.275    -0.427     0.200
     0.330     0.570     0.200
     0.442     0.117     0.200
     0.567    -0.148     0.200
     0.605     0.060     0.200
     0.733     0.030     0.200
     0.809     0.225     0.200
     0.905    -0.362     0.200
     0.131    -0.513     0.200
     0.219    -0.130     0.200
     0.304    -0.441     0.200
     0.313    -0.510     0.200
     0.323     0.711     0.200
     0.449     0.758     0.200
     0.606    -0.261     0.200
     0.593     0.319     0.200
     0.761    -0.124     0.200
     0.819     0.134     0.200
     0.819     0.282     0.200
     0.898    -0.608     0.200
     0.194    -1.435     0.200
     0.237    -0.073     0.200
     0.606     0.030     0.200
     0.604    -0.101     0.200
     0.624     0.404     0.200
     0.640     0.383     0.200
     0.651     0.558     0.200
     0.691    -0.172     0.200
     0.718    -0.389     0.200
     0.695     0.227     0.200
     0.732    -1.180     0.200
     0.722    -0.285     0.200
     0.769     0.035     0.200
     0.802    -0.225     0.200
     0.883    -0.691     0.200
     0.918    -0.063     0.200
     0.156    -1.948     0.200
     0.285    -0.252     0.200
     0.683    -1.629     0.200
     0.698    -0.219     0.200
     0.656     0.448     0.200
     0.666    -0.108     0.200
     0.722    -0.423     0.200
     0.828    -0.134     0.200
     0.865    -0.100     0.200
     0.980    -0.261     0.200
     0.134    -0.605     0.200
     0.394     0.218     0.200
     0.587     0.179     0.200
     0.721     0.655     0.200
     0.906    -0.256     0.200
     0.984     0.003     0.200
     0.127    -0.520     0.200
     0.315    -1.512     0.200
     0.483    -0.257     0.200
     0.608    -0.272     0.200
     0.596     0.142     0.200
     0.629     0.246     0.200
     0.698    -0.198     0.200
     0.719    -0.063     0.200
     0.758    -0.956     0.200
     0.855    -1.731     0.200
     0.870    -0.766     0.200
     0.870    -0.906     0.200
     0.151    -0.344     0.200
     0.257     0.115     0.200
     0.273    -0.074     0.200
     0.353    -0.338     0.200
     0.420     0.712     0.200
     0.636    -0.199     0.200
     0.681    -0.017     0.200
     0.744    -0.169     0.200
     0.778    -0.033     0.200
     0.817     0.369     0.200
     0.906    -0.649     0.200
     0.144     0.120     0.200
     0.210    -0.047     0.200
     0.249    -0.105     0.200
     0.285    -0.329     0.200
     0.299    -0.334     0.200
     0.468     0.760     0.200
     0.588    -0.147     0.200
     0.727    -0.117     0.200
     0.811     0.236     0.200
     0.802    -0.688     0.200
     0.905    -0.692     0.200
     0.220    -1.195     0.200
     0.216    -0.010     0.200
     0.604     0.645     0.200
     0.678    -0.094     0.200
     0.685    -0.126     0.200
     0.737     0.069     0.200
     0.759    -1.366     0.200
     0.765    -0.066     0.200
     0.850    -0.736     0.200
     0.883    -0.420     0.200
     0.155     0.218     0.200
     0.405     0.628     0.200
     0.586     0.651     0.200
     0.670    -0.162     0.200
     0.803    -0.427     0.200
     0.744     0.697     0.200
     0.803    -0.180     0.200
     0.924    -0.536     0.200
     0.168    -0.277     0.200
     0.244    -0.149     0.200
     0.293    -0.099     0.200
     0.344    -0.458     0.200
     0.346    -0.343     0.200
     0.491     0.967     0.200
     0.649    -0.112     0.200
     0.698     0.285     0.200
     0.741    -0.803     0.200
     0.798    -0.390     0.200
     0.840     0.130     0.200
     0.882    -0.574     0.200
     0.882    -1.113     0.200
     0.166     0.214     0.200
     0.442    -0.466     0.200
     0.486    -0.804     0.200
     0.764     0.573     0.200
     0.711    -0.848     0.200
     0.151    -0.210     0.200
     0.201    -0.577     0.200
     0.181     0.130     0.200
     0.208    -0.241     0.200
     0.261    -0.524     0.200
     0.424     0.078     0.200
     0.486    -0.054     0.200
     0.570     0.533     0.200
     0.656    -0.038     0.200
     0.654     0.743     0.200
     0.754    -0.038     0.200
     0.766     0.024     0.200
     0.896    -1.342     0.200
     0.116    -1.108     0.200
     0.412     0.871     0.200
     0.530    -0.941     0.200
     0.165     0.884     0.200
     0.193    -0.155     0.200
     0.202     1.228     0.200
     0.210    -0.214     0.200
     0.218     0.442     0.200
     0.294    -0.426     0.200
     0.363     0.865     0.200
     0.352     0.827     0.200
     0.363     1.587     0.200
     0.454     0.357     0.200
     0.610     0.536     0.200
     0.766     0.035     0.200
     0.210     0.180     0.200
     0.209    -0.130     0.200
     0.223     0.554     0.200
     0.586     0.024     0.200
     0.577    -0.002     0.200
     0.611     0.307     0.200
     0.623     0.321     0.200
     0.667    -0.348     0.200
     0.696    -0.227     0.200
     0.713    -0.470     0.200
     0.741    -0.157     0.200
     0.760     0.095     0.200
     0.779    -0.015     0.200
     0.286    -0.742     0.200
     0.274    -0.230     0.200
     0.455     0.268     0.200
     0.538     0.625     0.200
     0.574     0.185     0.200
     0.604    -0.475     0.200
     0.769    -0.215     0.200
     0.746    -0.169     0.200
     0.801     0.012     0.200
     0.838     0.000     0.200
     0.149    -0.450     0.200
     0.256    -0.048     0.200
     0.270    -0.129     0.200
     0.342    -0.354     0.200
     0.352    -0.388     0.200
     0.422     0.541     0.200
     0.633    -0.188     0.200
     0.682     0.073     0.200
     0.746    -0.737     0.200
     0.776    -0.210     0.200
     0.815     0.351     0.200
     0.205     0.156     0.200
     0.207     0.335     0.200
     0.227    -1.556     0.200
     0.572     0.014     0.200
     0.583     0.242     0.200
     0.618     0.547     0.200
     0.626     0.231     0.200
     0.663    -0.103     0.200
     0.662     0.318     0.200
     0.692    -0.290     0.200
     0.713    -0.299     0.200
     0.736    -0.057     0.200
     0.775    -0.277     0.200
     0.799    -0.676     0.200
     0.765    -1.419     0.200
     0.800    -0.901     0.200
     0.850    -0.451     0.200
     0.850    -0.822     0.200
     0.886    -0.374     0.200
     0.921    -1.016     0.200
     0.134    -0.232     0.200
     0.134    -0.012     0.200
     0.188     0.271     0.200
     0.332    -0.194     0.200
     0.454     0.000     0.200
     0.507     0.410     0.200
     0.503     0.490     0.200
     0.546    -0.259     0.200
     0.603     0.198     0.200
     0.603    -0.262     0.200
     0.604     0.465     0.200
     0.663    -0.079     0.200
     0.723    -1.366     0.200
     0.752    -0.879     0.200
     0.734    -0.407     0.200
     0.734    -0.567     0.200
     0.751    -0.856     0.200
     0.848    -0.534     0.200
     0.896    -0.376     0.200
     0.872    -0.069     0.200
     0.948    -0.320     0.200
     0.213    -0.655     0.200
     0.227    -0.065     0.200
     0.240    -0.047     0.200
     0.571     0.124     0.200
     0.692    -0.272     0.200
     0.683    -0.021     0.200
     0.751    -0.536     0.200
     0.752    -0.964     0.200
     0.741    -0.283     0.200
     0.761     0.051     0.200
     0.157    -0.685     0.200
     0.304     0.119     0.200
     0.626    -0.136     0.200
     0.593     0.339     0.200
     0.649    -0.036     0.200
     0.682    -0.431     0.200
     0.762    -0.666     0.200
     0.774    -0.863     0.200
     0.754    -0.453     0.200
     0.794    -0.314     0.200
     0.843     0.003     0.200
     0.220    -0.221     0.200
     0.226    -0.372     0.200
     0.206    -1.111     0.200
     0.592     0.167     0.200
     0.599    -0.076     0.200
     0.629     0.485     0.200
     0.644     0.327     0.200
     0.678    -0.201     0.200
     0.635     0.395     0.200
     0.689     0.231     0.200
     0.706    -0.333     0.200
     0.706    -0.474     0.200
     0.719    -0.226     0.200
     0.762    -0.095     0.200
     0.742    -0.680     0.200
     0.813    -0.922     0.200
     0.817    -1.405     0.200
     0.801    -0.088     0.200
     0.913    -0.557     0.200
     0.031    -0.344     0.200
     0.136    -0.182     0.200
     0.203    -0.146     0.200
     0.271     0.012     0.200
     0.298    -0.485     0.200
     0.295    -0.338     0.200
     0.450     0.721     0.200
     0.533     0.881     0.200
     0.580     0.163     0.200
     0.607    -0.091     0.200
     0.734     0.191     0.200
     0.792    -0.321     0.200
     0.769     0.101     0.200
     0.832     0.564     0.200
     0.125    -0.600     0.200
     0.125    -0.447     0.200
     0.160    -0.121     0.200
     0.315    -0.041     0.200
     0.484     0.017     0.200
     0.633     0.675     0.200
     0.594    -0.132     0.200
     0.610    -0.138     0.200
     0.645    -0.041     0.200
     0.715    -0.307     0.200
     0.701    -0.101     0.200
     0.759    -0.708     0.200
     0.855    -0.608     0.200
     0.867    -1.065     0.200
     0.030    -0.489     0.200
     0.137    -0.181     0.200
     0.200     0.019     0.200
     0.272     0.024     0.200
     0.450     0.577     0.200
     0.534     0.311     0.200
     0.607    -0.128     0.200
     0.736    -0.055     0.200
     0.769    -0.017     0.200
     0.769    -0.267     0.200
     0.793    -0.478     0.200
     0.834     0.352     0.200
     0.882    -0.521     0.200
     0.144    -0.009     0.200
     0.277     0.545     0.200
     0.288     0.225     0.200
     0.626     1.138     0.200
     0.679     0.507     0.200
     0.145    -0.744     0.200
     0.373     0.850     0.200
     0.415     0.682     0.200
     0.573    -0.698     0.200
     0.683    -0.409     0.200
     0.696     0.038     0.200
     0.738     1.007     0.200
     0.816    -0.443     0.200
     0.810    -0.009     0.200
     0.153    -0.945     0.200
     0.356     0.639     0.200
     0.399     0.474     0.200
     0.399     0.334     0.200
     0.590    -0.588     0.200
     0.670    -0.257     0.200
     0.741     0.532     0.200
     0.798    -0.426     0.200
     0.797    -0.281     0.200
     0.918    -0.535     0.200
     0.998    -0.309     0.200
     0.158    -1.084     0.200
     0.406     0.480     0.200
     0.586    -0.636     0.200
     0.748     0.317     0.200
     0.802    -0.203     0.200
     0.891     0.303     0.200
     0.142    -0.655     0.200
     0.281     0.240     0.200
     0.305     0.051     0.200
     0.305     0.199     0.200
     0.663     0.022     0.200
     0.661     0.340     0.200
     0.686    -0.120     0.200
     0.700    -0.479     0.200
     0.739    -0.441     0.200
     0.804    -0.376     0.200
     0.884    -0.160     0.200
     0.152    -0.227     0.200
     0.188    -0.116     0.200
     0.493    -0.016     0.200
     0.607     0.396     0.200
     0.622    -0.006     0.200
     0.700    -0.127     0.200
     0.739    -0.031     0.200
     0.738    -0.352     0.200
     0.773    -0.505     0.200
     0.895    -0.987     0.200
     0.146     0.194     0.200
     0.302    -0.627     0.200
     0.338    -0.153     0.200
     0.639     0.211     0.200
     0.702     0.899     0.200
     0.933    -0.548     0.200
     0.933    -0.788     0.200
     0.978    -0.873     0.200
     0.071    -0.230     0.200
     0.103    -0.166     0.200
     0.202    -0.026     0.200
     0.210    -0.057     0.200
     0.210    -0.064     0.200
     0.239    -0.430     0.200
     0.275    -0.769     0.200
     0.534    -0.485     0.200
     0.522    -0.568     0.200
     0.522     0.472     0.200
     0.606     0.651     0.200
     0.699     0.038     0.200
     0.746    -0.002     0.200
     0.780     0.057     0.200
     0.780     0.316     0.200
     0.851    -1.029     0.200
     0.279     0.093     0.200
     0.298    -0.451     0.200
     0.369     0.473     0.200
     0.368     0.014     0.200
     0.401    -0.257     0.200
     0.432    -0.166     0.200
     0.477    -0.467     0.200
     0.491    -0.268     0.200
     0.623     0.026     0.200
     0.784    -0.183     0.200
     0.906     0.006     0.200
     0.898     0.245     0.200
     0.055    -0.211     0.200
     0.112    -0.251     0.200
     0.210    -0.090     0.200
     0.247    -0.032     0.200
     0.256    -0.009     0.200
     0.284    -0.378     0.200
     0.299    -0.700     0.200
     0.469     0.653     0.200
     0.554    -0.270     0.200
     0.587    -0.536     0.200
     0.603     0.232     0.200
     0.745    -0.001     0.200
     0.727     0.030     0.200
     0.809     0.310     0.200
     0.906    -0.863     0.200
     0.059    -0.376     0.200
     0.108    -0.346     0.200
     0.212    -0.057     0.200
     0.243    -0.121     0.200
     0.252    -0.061     0.200
     0.282    -0.357     0.200
     0.299    -0.439     0.200
     0.473     0.475     0.200
     0.557     0.547     0.200
     0.583    -0.213     0.200
     0.607     0.158     0.200
     0.741    -0.027     0.200
     0.725    -0.067     0.200
     0.805     0.261     0.200
     0.122    -0.578     0.200
     0.155     0.067     0.200
     0.486    -0.115     0.200
     0.612    -0.251     0.200
     0.638     0.469     0.200
     0.590     0.001     0.200
     0.645    -0.148     0.200
     0.704    -0.176     0.200
     0.710    -0.133     0.200
     0.079    -0.327     0.200
     0.092    -0.173     0.200
     0.204    -0.121     0.200
     0.220    -0.068     0.200
     0.249    -0.526     0.200
     0.217    -0.162     0.200
     0.280    -0.807     0.200
     0.510     0.895     0.200
     0.510     0.766     0.200
     0.546    -0.579     0.200
     0.594     0.881     0.200
     0.629     0.195     0.200
     0.709    -0.102     0.200
     0.741     0.015     0.200
     0.786     0.100     0.200
     0.786     0.291     0.200
     0.929    -0.621     0.200
     0.929    -0.832     0.200
     0.161    -0.048     0.200
     0.234     0.602     0.200
     0.402    -0.312     0.200
     0.460     0.274     0.200
     0.486     0.347     0.200
     0.568     0.579     0.200
     0.499     0.080     0.200
     0.515    -0.421     0.200
     0.578     0.114     0.200
     0.600    -0.291     0.200
     0.577     0.326     0.200
     0.612     0.052     0.200
     0.690    -0.504     0.200
     0.804    -0.442     0.200
     0.903    -1.212     0.200
     0.168    -0.393     0.200
     0.182    -0.220     0.200
     0.533     0.139     0.200
     0.559    -0.006     0.200
     0.622     0.138     0.200
     0.631    -0.363     0.200
     0.628     1.008     0.200
     0.655    -0.030     0.200
     0.696    -0.187     0.200
     0.712    -0.623     0.200
     0.742     0.072     0.200
     0.764    -0.881     0.200
     0.782     0.138     0.200
     0.396     0.542     0.200
     0.440     0.660     0.200
     0.553    -0.116     0.200
     0.684    -0.476     0.200
     0.713    -0.055     0.200
     0.755     0.814     0.200
     0.837    -0.084     0.200
     0.836    -0.610     0.200
     0.924    -0.091     0.200
     0.062    -0.215     0.200
     0.140    -0.127     0.200
     0.190     0.203     0.200
     0.192    -0.118     0.200
     0.200    -0.388     0.200
     0.198    -0.090     0.200
     0.254    -0.471     0.200
     0.382     0.578     0.200
     0.564     0.254     0.200
     0.648     0.226     0.200
     0.666    -0.098     0.200
     0.764    -0.015     0.200
     0.764     0.096     0.200
     0.771    -0.373     0.200
     0.894    -0.294     0.200
     0.138    -0.251     0.200
     0.194    -0.143     0.200
     0.196    -0.165     0.200
     0.273    -0.721     0.200
     0.374     0.563     0.200
     0.539     0.592     0.200
     0.517    -0.362     0.200
     0.623     0.616     0.200
     0.682    -0.344     0.200
     0.682    -0.155     0.200
     0.749    -0.087     0.200
     0.767     0.268     0.200
     0.911    -0.380     0.200
     0.058    -0.317     0.200
     0.113    -0.393     0.200
     0.110    -0.260     0.200
     0.199    -0.140     0.200
     0.272    -0.463     0.200
     0.286    -0.774     0.200
     0.253    -0.051     0.200
     0.247    -0.065     0.200
     0.327     0.696     0.200
     0.477     0.685     0.200
     0.561     0.937     0.200
     0.579    -0.278     0.200
     0.742    -0.272     0.200
     0.738    -0.099     0.200
     0.812     0.232     0.200
     0.903    -0.924     0.200
     0.903    -0.713     0.200
     0.972    -0.290     0.200
     0.100    -0.347     0.200
     0.133    -0.425     0.200
     0.218    -0.137     0.200
     0.234    -0.058     0.200
     0.244    -0.289     0.200
     0.281    -0.452     0.200
     0.303    -0.561     0.200
     0.343     0.675     0.200
     0.478    -0.345     0.200
     0.478     0.741     0.200
     0.563     0.910     0.200
     0.577    -0.256     0.200
     0.616     0.204     0.200
     0.720    -0.019     0.200
     0.733    -0.054     0.200
     0.796     0.344     0.200
     0.919    -0.896     0.200
     0.919    -0.724     0.200
     0.964    -0.234     0.200
     0.075    -0.273     0.200
     0.092    -0.237     0.200
     0.133    -0.327     0.200
     0.216    -0.090     0.200
     0.228     0.029     0.200
     0.236     0.039     0.200
     0.274    -0.418     0.200
     0.299    -0.759     0.200
     0.348     0.637     0.200
     0.487     0.671     0.200
     0.569    -0.205     0.200
     0.572     0.797     0.200
     0.621     0.174     0.200
     0.705     0.254     0.200
     0.725    -0.300     0.200
     0.723     0.076     0.200
     0.791     0.373     0.200
     0.924    -0.861     0.200
     0.062    -0.276     0.200
     0.118    -0.142     0.200
     0.134    -0.185     0.200
     0.198    -0.017     0.200
     0.177     0.221     0.200
     0.200    -0.086     0.200
     0.202    -0.105     0.200
     0.537     0.524     0.200
     0.622     0.589     0.200
     0.647     0.191     0.200
     0.685    -0.248     0.200
     0.685    -0.039     0.200
     0.753     0.010     0.200
     0.740     0.226     0.200
     0.772     0.257     0.200
     0.914    -0.239     0.200
     0.230     0.101     0.200
     0.230     0.361     0.200
     0.233    -0.086     0.200
     0.233     0.234     0.200
     0.599    -0.140     0.200
     0.603     0.191     0.200
     0.622     0.670     0.200
     0.688    -0.193     0.200
     0.690     0.252     0.200
     0.719    -0.496     0.200
     0.716    -0.362     0.200
     0.737    -0.680     0.200
     0.797     0.078     0.200
     0.839     0.076     0.200
     0.230     0.402     0.200
     0.233     0.150     0.200
     0.603     0.217     0.200
     0.601     0.070     0.200
     0.601    -0.459     0.200
     0.624     0.767     0.200
     0.688    -0.128     0.200
     0.717    -0.344     0.200
     0.692     0.202     0.200
     0.736    -0.779     0.200
     0.766     0.079     0.200
     0.799     0.002     0.200
     0.841     0.040     0.200
     0.914    -0.328     0.200
     0.084    -0.340     0.200
     0.084    -0.222     0.200
     0.144    -0.226     0.200
     0.172     0.208     0.200
     0.227    -0.081     0.200
     0.228    -0.050     0.200
     0.218    -0.017     0.200
     0.277    -0.408     0.200
     0.446     0.151     0.200
     0.491     0.730     0.200
     0.565    -0.146     0.200
     0.561     0.419     0.200
     0.576     0.838     0.200
     0.631    -0.007     0.200
     0.632     0.255     0.200
     0.717    -0.081     0.200
     0.715     0.321     0.200
     0.779    -0.843     0.200
     0.714     0.263     0.200
     0.803    -0.442     0.200
     0.780     0.244     0.200
     0.897    -0.262     0.200
     0.948    -0.060     0.200
     0.151    -0.189     0.200
     0.194     0.004     0.200
     0.201    -0.350     0.200
     0.227    -0.056     0.200
     0.299    -0.712     0.200
     0.378     0.618     0.200
     0.519    -0.782     0.200
     0.519     0.487     0.200
     0.563     0.302     0.200
     0.605     0.702     0.200
     0.653     0.158     0.200
     0.690    -0.033     0.200
     0.690     0.069     0.200
     0.722     0.098     0.200
     0.761    -0.223     0.200
     0.761     0.437     0.200
     0.739     0.197     0.200
     0.921    -0.135     0.200
     0.043    -0.299     0.200
     0.126    -0.113     0.200
     0.139    -0.063     0.200
     0.195    -0.004     0.200
     0.190    -0.046     0.200
     0.246    -0.058     0.200
     0.286    -0.712     0.200
     0.438     0.632     0.200
     0.605    -0.590     0.200
     0.612    -0.104     0.200
     0.612     0.006     0.200
     0.711     0.314     0.200
     0.755     0.072     0.200
     0.841    -0.268     0.200
     0.997    -0.401     0.200
     0.157    -0.273     0.200
     0.157    -0.383     0.200
     0.171    -0.300     0.200
     0.171    -0.152     0.200
     0.172     0.104     0.200
     0.278    -0.128     0.200
     0.298    -0.062     0.200
     0.350    -0.267     0.200
     0.335     0.658     0.200
     0.359    -0.352     0.200
     0.414     0.744     0.200
     0.525    -0.061     0.200
     0.525     0.060     0.200
     0.500     0.915     0.200
     0.582     0.470     0.200
     0.596     0.209     0.200
     0.615     0.070     0.200
     0.663     0.362     0.200
     0.678     0.083     0.200
     0.783    -0.010     0.200
     0.817    -0.621     0.200
     0.819     0.317     0.200
     0.872     0.019     0.200
     0.904    -0.914     0.200
     0.971    -0.094     0.200
     0.144    -0.190     0.200
     0.162    -0.090     0.200
     0.251     0.109     0.200
     0.267    -0.066     0.200
     0.286    -0.111     0.200
     0.347    -0.355     0.200
     0.427     0.500     0.200
     0.686    -0.090     0.200
     0.772    -0.277     0.200
     0.772    -0.074     0.200
     0.814     0.244     0.200
     0.907    -0.836     0.200
     0.173    -0.158     0.200
     0.156    -0.319     0.200
     0.262     0.063     0.200
     0.276    -0.111     0.200
     0.297    -0.124     0.200
     0.337     0.514     0.200
     0.351    -0.257     0.200
     0.359    -0.389     0.200
     0.415     0.838     0.200
     0.676     0.072     0.200
     0.782    -0.024     0.200
     0.782     0.116     0.200
     0.818     0.407     0.200
     0.906    -0.789     0.200
     0.085    -0.254     0.200
     0.082    -0.322     0.200
     0.138    -0.164     0.200
     0.168     0.169     0.200
     0.219    -0.006     0.200
     0.218    -0.119     0.200
     0.226    -0.222     0.200
     0.269    -0.344     0.200
     0.299    -0.434     0.200
     0.357     0.588     0.200
     0.496     0.475     0.200
     0.496    -0.615     0.200
     0.559    -0.321     0.200
     0.715     0.048     0.200
     0.722    -0.008     0.200
     0.782    -0.081     0.200
     0.782     0.300     0.200
     0.946    -0.104     0.200
     0.196     0.363     0.200
     0.196    -0.208     0.200
     0.552     0.046     0.200
     0.563    -0.308     0.200
     0.600     0.471     0.200
     0.611     0.323     0.200
     0.644     0.247     0.200
     0.660    -0.348     0.200
     0.670    -0.208     0.200
     0.718    -0.166     0.200
     0.728    -0.668     0.200
     0.753    -0.349     0.200
     0.794    -0.223     0.200
     0.779    -0.932     0.200
     0.832    -0.589     0.200
     0.308     0.349     0.200
     0.645     0.067     0.200
     0.659    -0.118     0.200
     0.708    -0.317     0.200
     0.653     0.968     0.200
     0.686     0.039     0.200
     0.713     0.329     0.200
     0.745    -0.353     0.200
     0.732     0.149     0.200
     0.777    -0.045     0.200
     0.803    -0.151     0.200
     0.881    -0.028     0.200
     0.924    -0.145     0.200
     0.035    -0.176     0.200
     0.168    -0.023     0.200
     0.158    -0.291     0.200
     0.164    -0.022     0.200
     0.213    -0.554     0.200
     0.215     0.279     0.200
     0.227    -0.100     0.200
     0.279    -0.603     0.200
     0.408     0.615     0.200
     0.483    -0.408     0.200
     0.573     0.441     0.200
     0.658    -0.739     0.200
     0.645    -0.275     0.200
     0.645    -0.056     0.200
     0.737    -0.048     0.200
     0.737     0.253     0.200
     0.750    -0.038     0.200
     0.875    -0.289     0.200
     0.392     0.687     0.200
     0.392     0.869     0.200
     0.594     0.004     0.200
     0.675    -0.472     0.200
     0.678    -0.109     0.200
     0.731     0.733     0.200
     0.787     0.130     0.200
     0.794     0.472     0.200
     0.795    -0.623     0.200
     0.874     0.123     0.200
     0.908    -0.534     0.200
     0.988     0.071     0.200
     0.144    -0.213     0.200
     0.469    -0.021     0.200
     0.496     0.388     0.200
     0.512     0.277     0.200
     0.509     0.345     0.200
     0.555     0.177     0.200
     0.572    -0.032     0.200
     0.599    -0.181     0.200
     0.627    -0.092     0.200
     0.648     0.632     0.200
     0.693    -0.080     0.200
     0.729     0.049     0.200
     0.741    -0.757     0.200
     0.847    -1.044     0.200
     0.847    -1.169     0.200
     0.876    -0.585     0.200
     0.019    -0.453     0.200
     0.087     0.117     0.200
     0.396    -0.072     0.200
     0.396     0.053     0.200
     0.462     0.598     0.200
     0.478    -0.313     0.200
     0.478     0.093     0.200
     0.509    -0.047     0.200
     0.523     0.221     0.200
     0.523     0.440     0.200
     0.577    -0.128     0.200
     0.577     0.317     0.200
     0.583    -0.433     0.200
     0.621    -0.550     0.200
     0.635     0.129     0.200
     0.658    -0.150     0.200
     0.734    -1.085     0.200
     0.734    -0.842     0.200
     0.747    -0.964     0.200
     0.747    -0.550     0.200
     0.767     0.038     0.200
     0.797    -0.085     0.200
     0.775     0.833     0.200
     0.796    -0.122     0.200
     0.813    -0.425     0.200
     0.924    -0.669     0.200
     0.200    -0.080     0.200
     0.547     0.001     0.200
     0.593     0.159     0.200
     0.594     0.427     0.200
     0.596     0.418     0.200
     0.639     0.261     0.200
     0.665    -0.209     0.200
     0.662    -0.191     0.200
     0.740    -0.469     0.200
     0.780    -0.540     0.200
     0.743    -0.122     0.200
     0.785    -0.009     0.200
     0.828    -0.850     0.200
     0.931    -1.279     0.200
     0.153    -0.480     0.200
     0.158    -0.168     0.200
     0.174    -0.211     0.200
     0.217    -0.679     0.200
     0.234    -0.204     0.200
     0.221     0.157     0.200
     0.286    -1.020     0.200
     0.414     0.582     0.200
     0.482    -0.602     0.200
     0.574     0.556     0.200
     0.641     0.039     0.200
     0.659     0.595     0.200
     0.730     0.401     0.200
     0.744     0.090     0.200
     0.871    -0.178     0.200
     0.952     1.654     0.200
     0.988    -0.755     0.200
     0.129    -0.062     0.200
     0.140     0.031     0.200
     0.193    -0.232     0.200
     0.288    -0.697     0.200
     0.288    -0.553     0.200
     0.455    -0.309     0.200
     0.435     0.403     0.200
     0.615    -0.071     0.200
     0.601     0.311     0.200
     0.712     0.199     0.200
     0.752    -0.189     0.200
     0.844    -0.383     0.200
     0.126    -0.306     0.200
     0.141    -0.012     0.200
     0.197    -0.656     0.200
     0.195    -0.071     0.200
     0.245    -0.117     0.200
     0.246     0.307     0.200
     0.283    -0.821     0.200
     0.283    -0.520     0.200
     0.438     0.456     0.200
     0.448    -0.270     0.200
     0.611    -0.085     0.200
     0.608     0.340     0.200
     0.693     0.522     0.200
     0.712    -0.048     0.200
     0.712     0.213     0.200
     0.760    -0.121     0.200
     0.840    -0.308     0.200
     0.995    -0.498     0.200
     0.022    -0.267     0.200
     0.148    -0.072     0.200
     0.174    -0.212     0.200
     0.161    -0.077     0.200
     0.162    -0.230     0.200
     0.162    -0.049     0.200
     0.217     0.250     0.200
     0.239    -0.105     0.200
     0.234    -0.571     0.200
     0.297    -0.573     0.200
     0.409     0.599     0.200
     0.558     0.413     0.200
     0.497    -0.491     0.200
     0.644    -0.191     0.200
     0.651    -0.092     0.200
     0.730    -0.039     0.200
     0.732     0.236     0.200
     0.882    -0.341     0.200
     0.051    -0.272     0.200
     0.126    -0.334     0.200
     0.193    -0.668     0.200
     0.143    -0.070     0.200
     0.194    -0.025     0.200
     0.242    -0.077     0.200
     0.246     0.361     0.200
     0.279    -0.785     0.200
     0.279    -0.528     0.200
     0.437     0.672     0.200
     0.445    -0.556     0.200
     0.610    -0.279     0.200
     0.610    -0.131     0.200
     0.610     0.620     0.200
     0.714     0.191     0.200
     0.764    -0.122     0.200
     0.839    -0.343     0.200
     0.993    -0.487     0.200
     0.063    -0.281     0.200
     0.121    -0.225     0.200
     0.152    -0.161     0.200
     0.166     0.147     0.200
     0.240     0.046     0.200
     0.247    -0.050     0.200
     0.263    -0.324     0.200
     0.313    -0.288     0.200
     0.331    -0.678     0.200
     0.331    -0.393     0.200
     0.344     0.534     0.200
     0.451     0.444     0.200
     0.485     0.115     0.200
     0.569     0.170     0.200
     0.604    -0.516     0.200
     0.612     0.080     0.200
     0.696    -0.003     0.200
     0.751    -0.137     0.200
     0.751    -0.016     0.200
     0.800     0.306     0.200
     0.983    -0.172     0.200
     0.175    -0.159     0.200
     0.175    -0.312     0.200
     0.203     0.175     0.200
     0.516    -0.231     0.200
     0.566     0.326     0.200
     0.565     0.377     0.200
     0.578     0.227     0.200
     0.599     0.428     0.200
     0.608     0.161     0.200
     0.634    -0.498     0.200
     0.644    -0.183     0.200
     0.684    -0.007     0.200
     0.717    -0.180     0.200
     0.757    -0.201     0.200
     0.797    -0.698     0.200
     0.797    -0.472     0.200
     0.810     0.000     0.200
     0.830    -0.243     0.200
     0.914    -1.170     0.200
     0.914    -0.752     0.200
     0.959    -0.476     0.200
     0.153    -0.426     0.200
     0.487    -0.172     0.200
     0.537     0.400     0.200
     0.535     0.394     0.200
     0.563     0.348     0.200
     0.578     0.240     0.200
     0.606    -0.293     0.200
     0.602     0.384     0.200
     0.654     0.036     0.200
     0.691    -0.216     0.200
     0.731    -0.189     0.200
     0.767    -0.663     0.200
     0.840    -0.220     0.200
     0.898    -1.017     0.200
     0.898    -1.216     0.200
     0.350     1.135     0.200
     0.394     0.979     0.200
     0.596     0.473     0.200
     0.667     0.156     0.200
     0.741     0.867     0.200
     0.795     0.526     0.200
     0.792    -0.052     0.200
     0.831     0.103     0.200
     0.878    -0.120     0.200
     0.914    -0.393     0.200
     0.994    -0.182     0.200
     0.295     0.654     0.200
     0.295     0.841     0.200
     0.323     0.431     0.200
     0.646     0.286     0.200
     0.675     0.936     0.200
     0.708    -0.187     0.200
     0.647     0.690     0.200
     0.727     0.308     0.200
     0.694     0.090     0.200
     0.751    -0.158     0.200
     0.751    -0.649     0.200
     0.751    -0.250     0.200
     0.797    -0.447     0.200
     0.797    -0.025     0.200
     0.826    -0.209     0.200
     0.826    -0.401     0.200
     0.905    -0.005     0.200
     0.948    -0.295     0.200
     0.948     0.053     0.200
     0.948    -0.158     0.200
     0.230     0.247     0.200
     0.230     0.388     0.200
     0.237     0.185     0.200
     0.602     0.005     0.200
     0.640     0.326     0.200
     0.631     0.715     0.200
     0.689    -0.344     0.200
     0.711    -0.428     0.200
     0.727    -0.278     0.200
     0.731    -0.022     0.200
     0.772     0.031     0.200
     0.850     0.020     0.200
     0.169    -0.173     0.200
     0.196     0.253     0.200
     0.516    -0.043     0.200
     0.571     0.133     0.200
     0.561     0.319     0.200
     0.607     0.348     0.200
     0.638    -0.142     0.200
     0.606     0.505     0.200
     0.635    -0.176     0.200
     0.682    -0.008     0.200
     0.719    -0.086     0.200
     0.760     0.067     0.200
     0.796    -0.800     0.200
     0.813     0.282     0.200
     0.350     1.072     0.200
     0.387     0.895     0.200
     0.387    -1.265     0.200
     0.591     0.744     0.200
     0.528    -0.190     0.200
     0.692    -0.209     0.200
     0.685     0.199     0.200
     0.791     0.247     0.200
     0.799    -0.360     0.200
     0.820     0.229     0.200
     0.866    -0.121     0.200
     0.895    -0.290     0.200
     0.219     0.316     0.200
     0.219     0.466     0.200
     0.216     0.027     0.200
     0.577     0.079     0.200
     0.595     0.207     0.200
     0.616     0.386     0.200
     0.616     0.505     0.200
     0.625    -0.120     0.200
     0.675    -0.180     0.200
     0.669     0.143     0.200
     0.669    -0.347     0.200
     0.695    -0.061     0.200
     0.723    -0.234     0.200
     0.756     0.153     0.200
     0.776    -0.365     0.200
     0.818     0.056     0.200
     0.818     0.190     0.200
     0.856    -1.002     0.200
     0.856    -0.451     0.200
     0.891    -0.212     0.200
     0.957     0.193     0.200
     0.035    -0.685     0.200
     0.185    -0.851     0.200
     0.185    -0.515     0.200
     0.214    -0.052     0.200
     0.226     0.081     0.200
     0.220     0.073     0.200
     0.220    -0.220     0.200
     0.244     0.153     0.200
     0.265    -0.736     0.200
     0.310    -0.044     0.200
     0.465     0.529     0.200
     0.597    -0.182     0.200
     0.731     0.080     0.200
     0.731    -0.295     0.200
     0.784     0.052     0.200
     0.810    -0.389     0.200
     0.807    -0.236     0.200
     0.845    -0.641     0.200
     0.845    -0.539     0.200
     0.934    -0.290     0.200
     0.062    -0.474     0.200
     0.168    -0.199     0.200
     0.154    -0.185     0.200
     0.258     0.027     0.200
     0.275    -0.411     0.200
     0.295    -0.051     0.200
     0.335     0.629     0.200
     0.346    -0.274     0.200
     0.355    -0.431     0.200
     0.417     0.741     0.200
     0.504     0.370     0.200
     0.504    -0.111     0.200
     0.639    -0.146     0.200
     0.681    -0.133     0.200
     0.781     0.136     0.200
     0.795     0.202     0.200
     0.819     0.529     0.200
     0.904    -0.633     0.200
     0.229     0.057     0.200
     0.228     0.370     0.200
     0.228     0.620     0.200
     0.594     0.014     0.200
     0.621     0.457     0.200
     0.602    -0.036     0.200
     0.685     0.122     0.200
     0.711    -0.240     0.200
     0.685    -0.440     0.200
     0.741     0.207     0.200
     0.720    -0.497     0.200
     0.759    -0.244     0.200
     0.792    -0.314     0.200
     0.792    -0.431     0.200
     0.834     0.257     0.200
     0.873    -0.622     0.200
     0.083    -0.088     0.200
     0.084    -0.039     0.200
     0.138    -0.110     0.200
     0.138    -0.229     0.200
     0.168     0.111     0.200
     0.218    -0.409     0.200
     0.227    -0.268     0.200
     0.227     0.085     0.200
     0.220    -0.034     0.200
     0.300    -0.499     0.200
     0.441     0.127     0.200
     0.471    -0.174     0.200
     0.495     0.415     0.200
     0.561    -0.487     0.200
     0.554     0.443     0.200
     0.627    -0.087     0.200
     0.630    -0.027     0.200
     0.716     0.103     0.200
     0.714     0.039     0.200
     0.721    -0.319     0.200
     0.771    -0.607     0.200
     0.782     0.394     0.200
     0.797    -0.087     0.200
     0.812     0.073     0.200
     0.895     0.080     0.200
     0.947    -0.122     0.200
     0.198    -0.678     0.200
     0.198     0.002     0.200
     0.591     0.513     0.200
     0.635     0.506     0.200
     0.739    -0.349     0.200
     0.780     0.176     0.200
     0.824    -0.591     0.200
     0.783     0.543     0.200
     0.931    -0.964     0.200
     0.043    -0.304     0.200
     0.152     0.052     0.200
     0.152    -0.315     0.200
     0.175    -0.118     0.200
     0.225    -0.064     0.200
     0.261     0.217     0.200
     0.296     0.023     0.200
     0.355    -0.705     0.200
     0.451     0.540     0.200
     0.507    -0.558     0.200
     0.558     0.501     0.200
     0.634     0.106     0.200
     0.634    -0.151     0.200
     0.655     0.206     0.200
     0.646     0.621     0.200
     0.688     0.542     0.200
     0.867    -0.083     0.200
     0.218    -0.269     0.200
     0.225    -0.058     0.200
     0.574     0.060     0.200
     0.601     0.136     0.200
     0.666     0.288     0.200
     0.679    -0.055     0.200
     0.690    -0.077     0.200
     0.741    -0.022     0.200
     0.731    -0.491     0.200
     0.771    -0.510     0.200
     0.813     0.118     0.200
     0.813    -0.015     0.200
     0.855    -0.851     0.200
     0.378     1.074     0.200
     0.418     0.876     0.200
     0.418     0.977     0.200
     0.532    -0.128     0.200
     0.694    -0.091     0.200
     0.705     0.130     0.200
     0.809    -0.018     0.200
     0.823    -0.410     0.200
     0.898    -0.121     0.200
     0.927    -0.242     0.200
     0.969    -0.212     0.200
     0.268     0.648     0.200
     0.282     0.230     0.200
     0.282     0.426     0.200
     0.686     0.225     0.200
     0.743     0.093     0.200
     0.845    -0.558     0.200
     0.869    -0.997     0.200
     0.888    -0.065     0.200
     0.888    -0.268     0.200
     0.032    -0.032     0.200
     0.105     0.517     0.200
     0.402     0.003     0.200
     0.480     0.416     0.200
     0.490     0.092     0.200
     0.528     0.048     0.200
     0.542     0.415     0.200
     0.574    -0.219     0.200
     0.596     0.157     0.200
     0.654    -0.033     0.200
     0.676    -0.042     0.200
     0.740    -0.737     0.200
     0.766    -0.868     0.200
     0.784    -0.539     0.200
     0.814    -0.003     0.200
     0.814    -0.190     0.200
     0.076    -0.703     0.200
     0.426     0.097     0.200
     0.503     0.113     0.200
     0.500    -0.126     0.200
     0.572     0.040     0.200
     0.612    -0.205     0.200
     0.634    -0.035     0.200
     0.645    -0.183     0.200
     0.747    -0.819     0.200
     0.750    -0.448     0.200
     0.763    -0.800     0.200
     0.781     0.110     0.200
     0.907    -0.237     0.200
     0.030    -0.336     0.200
     0.134    -0.035     0.200
     0.140    -0.239     0.200
     0.172    -0.099     0.200
     0.230    -0.035     0.200
     0.301    -0.393     0.200
     0.297     0.469     0.200
     0.316     0.080     0.200
     0.316    -0.174     0.200
     0.328     0.059     0.200
     0.332    -0.805     0.200
     0.406     0.576     0.200
     0.406     1.057     0.200
     0.490     0.837     0.200
     0.577    -0.201     0.200
     0.650    -0.132     0.200
     0.633     0.309     0.200
     0.804     0.160     0.200
     0.826     0.208     0.200
     0.868    -0.931     0.200
     0.868    -0.779     0.200
     0.300     0.398     0.200
     0.300     0.218     0.200
     0.320     0.600     0.200
     0.320    -0.530     0.200
     0.320     0.460     0.200
     0.660     0.084     0.200
     0.692     0.053     0.200
     0.722    -0.320     0.200
     0.648     0.532     0.200
     0.759    -0.273     0.200
     0.784    -0.209     0.200
     0.883    -0.229     0.200
     0.931    -0.085     0.200
     0.931     0.091     0.200
     0.279     0.455     0.200
     0.297     0.261     0.200
     0.641     0.017     0.200
     0.672    -0.005     0.200
     0.670     0.228     0.200
     0.713    -0.437     0.200
     0.702     0.442     0.200
     0.738    -0.372     0.200
     0.763     0.166     0.200
     0.788     0.009     0.200
     0.866    -0.172     0.200
     0.914    -0.045     0.200
     0.128    -0.358     0.200
     0.127    -0.120     0.200
     0.162    -0.212     0.200
     0.218     0.025     0.200
     0.319    -0.719     0.200
     0.324    -0.230     0.200
     0.294    -0.507     0.200
     0.319     0.015     0.200
     0.419     0.571     0.200
     0.503     0.649     0.200
     0.503     0.758     0.200
     0.637    -0.380     0.200
     0.794     0.082     0.200
     0.820     0.115     0.200
     0.849     0.403     0.200
     0.870    -0.657     0.200
     0.346     0.424     0.200
     0.629    -0.005     0.200
     0.655     0.084     0.200
     0.684    -0.422     0.200
     0.736     0.109     0.200
     0.750     0.403     0.200
     0.764    -0.387     0.200
     0.778     0.302     0.200
     0.825    -0.066     0.200
     0.856    -0.229     0.200
     0.896    -0.183     0.200
     0.936    -0.259     0.200
     0.983    -0.027     0.200
     0.387    -0.305     0.200
     0.387     0.125     0.200
     0.437     0.235     0.200
     0.439     0.108     0.200
     0.485    -0.364     0.200
     0.485    -0.614     0.200
     0.855    -0.954     0.200
     0.863    -0.346     0.200
     0.886     0.569     0.200
     0.909     0.188     0.200
     0.904    -0.402     0.200
     0.959     0.087     0.200
     0.343    -0.194     0.200
     0.567    -0.431     0.200
     0.805     0.298     0.200
     0.231     0.088     0.200
     0.231     0.393     0.200
     0.605    -0.090     0.200
     0.633     0.501     0.200
     0.642     0.472     0.200
     0.686    -0.075     0.200
     0.688    -0.437     0.200
     0.739     0.283     0.200
     0.723    -0.537     0.200
     0.761     0.100     0.200
     0.792    -0.162     0.200
     0.839    -0.124     0.200
     0.082    -0.326     0.200
     0.081    -0.992     0.200
     0.457     0.140     0.200
     0.485     0.558     0.200
     0.523     0.193     0.200
     0.530     0.030     0.200
     0.574    -0.078     0.200
     0.636    -0.152     0.200
     0.639    -0.151     0.200
     0.640    -0.335     0.200
     0.752    -0.761     0.200
     0.780     0.081     0.200
     0.806    -0.474     0.200
     0.794    -0.975     0.200
     0.794    -0.732     0.200
     0.888    -0.048     0.200
     0.311     0.275     0.200
     0.311     0.045     0.200
     0.335    -0.856     0.200
     0.546     0.340     0.200
     0.665    -0.020     0.200
     0.633     0.973     0.200
     0.713    -0.238     0.200
     0.740     0.172     0.200
     0.768    -0.485     0.200
     0.759     0.051     0.200
     0.804    -0.179     0.200
     0.829    -0.252     0.200
     0.905    -0.501     0.200
     0.954    -0.153     0.200
     0.223     0.416     0.200
     0.215    -0.901     0.200
     0.600     0.105     0.200
     0.614     0.417     0.200
     0.677    -0.173     0.200
     0.663     0.346     0.200
     0.687    -0.218     0.200
     0.732    -0.222     0.200
     0.738     0.016     0.200
     0.759     0.356     0.200
     0.768    -0.566     0.200
     0.811    -0.595     0.200
     0.815     0.038     0.200
     0.852    -0.768     0.200
     0.305     0.635     0.200
     0.327    -0.228     0.200
     0.661     0.082     0.200
     0.640     0.474     0.200
     0.715    -0.239     0.200
     0.704     0.032     0.200
     0.732     0.287     0.200
     0.762    -0.329     0.200
     0.795    -0.060     0.200
     0.819    -0.156     0.200
     0.896    -0.815     0.200
     0.896    -0.415     0.200
     0.944    -0.201     0.200
     0.584    -0.000     0.200
     0.577     0.143     0.200
     0.617     0.036     0.200
     0.631     0.332     0.200
     0.677     0.301     0.200
     0.697    -0.067     0.200
     0.695    -0.370     0.200
     0.742     0.240     0.200
     0.776    -0.858     0.200
     0.776    -0.749     0.200
     0.823     0.092     0.200
     0.866    -0.952     0.200
     0.259    -0.055     0.200
     0.616     0.067     0.200
     0.712     0.269     0.200
     0.716    -0.526     0.200
     0.709    -0.016     0.200
     0.729    -0.070     0.200
     0.784     0.097     0.200
     0.806    -0.695     0.200
     0.854    -0.134     0.200
     0.489     0.194     0.200
     0.561    -0.119     0.200
     0.582    -0.297     0.200
     0.592    -0.670     0.200
     0.647    -0.124     0.200
     0.670     0.226     0.200
     0.755     0.443     0.200
     0.735     0.361     0.200
     0.858    -0.170     0.200
     0.853     0.358     0.200
     0.843    -0.404     0.200
     0.913     0.261     0.200
     0.993    -0.102     0.200
     0.992    -0.207     0.200
     0.304     0.572     0.200
     0.673     0.064     0.200
     0.663     0.569     0.200
     0.708     0.274     0.200
     0.726    -0.437     0.200
     0.721     0.170     0.200
     0.748    -0.404     0.200
     0.765    -0.026     0.200
     0.787    -0.100     0.200
     0.863    -0.671     0.200
     0.911    -0.101     0.200
     0.485     0.272     0.200
     0.556    -0.010     0.200
     0.579    -0.172     0.200
     0.644    -0.044     0.200
     0.739     0.365     0.200
     0.845    -0.401     0.200
     0.823     0.462     0.200
     0.823     0.202     0.200
     0.871     0.002     0.200
     0.857     0.385     0.200
     0.991    -0.014     0.200
     0.991    -0.148     0.200
     0.214    -0.280     0.200
     0.576     0.035     0.200
     0.614     0.377     0.200
     0.623     0.345     0.200
     0.667     0.238     0.200
     0.674    -0.295     0.200
     0.693    -0.096     0.200
     0.723    -0.495     0.200
     0.758    -0.064     0.200
     0.775    -0.963     0.200
     0.775    -0.534     0.200
     0.822     0.121     0.200
     0.855    -0.904     0.200
     0.017    -0.442     0.200
     0.105    -0.434     0.200
     0.194    -0.120     0.200
     0.182    -0.164     0.200
     0.265     0.577     0.200
     0.299    -0.560     0.200
     0.319    -0.256     0.200
     0.318    -0.304     0.200
     0.340     0.091     0.200
     0.415     0.615     0.200
     0.543    -0.040     0.200
     0.534     0.364     0.200
     0.647    -0.124     0.200
     0.814     0.262     0.200
     0.814     0.129     0.200
     0.839    -0.626     0.200
     0.839    -0.509     0.200
     0.847     0.164     0.200
     0.869    -0.100     0.200
     0.878     0.449     0.200
     0.499    -0.194     0.200
     0.563     0.147     0.200
     0.561    -0.272     0.200
     0.579    -0.345     0.200
     0.586     0.228     0.200
     0.640    -0.165     0.200
     0.658     0.259     0.200
     0.670     0.692     0.200
     0.819     0.034     0.200
     0.810     0.386     0.200
     0.810     0.105     0.200
     0.857    -0.328     0.200
     0.852    -1.104     0.200
     0.842     0.165     0.200
     0.859    -0.095     0.200
     0.916     0.215     0.200
     0.936    -0.731     0.200
     0.901     0.147     0.200
     0.985    -0.053     0.200
     0.982    -0.173     0.200
     0.498    -0.002     0.200
     0.562     0.478     0.200
     0.566    -0.176     0.200
     0.586    -0.229     0.200
     0.663     0.377     0.200
     0.648    -0.126     0.200
     0.676     0.034     0.200
     0.676     0.604     0.200
     0.763     0.249     0.200
     0.763     0.405     0.200
     0.726     0.146     0.200
     0.863    -0.231     0.200
     0.817     0.400     0.200
     0.817     0.189     0.200
     0.844    -0.801     0.200
     0.867    -0.043     0.200
     0.844     0.268     0.200
     0.938    -0.515     0.200
     0.924     0.253     0.200
     0.993    -0.085     0.200
     0.990    -0.203     0.200
     0.990    -0.101     0.200
     0.220    -0.847     0.200
     0.235     0.252     0.200
     0.235     0.122     0.200
     0.657     0.294     0.200
     0.676     0.004     0.200
     0.686    -0.153     0.200
     0.755    -0.855     0.200
     0.750    -0.422     0.200
     0.802     0.183     0.200
     0.760     0.028     0.200
     0.846    -0.690     0.200
     0.218    -0.775     0.200
     0.223     0.587     0.200
     0.223     0.147     0.200
     0.617     0.679     0.200
     0.668     0.445     0.200
     0.671     0.214     0.200
     0.774    -0.966     0.200
     0.755     0.240     0.200
     0.821     0.066     0.200
     0.856    -0.718     0.200
     0.938    -1.108     0.200
     0.221    -1.069     0.200
     0.231     0.152     0.200
     0.618     0.438     0.200
     0.621     0.421     0.200
     0.663     0.414     0.200
     0.684    -0.271     0.200
     0.685    -0.032     0.200
     0.739     0.063     0.200
     0.741    -0.500     0.200
     0.756     0.170     0.200
     0.764    -0.867     0.200
     0.812     0.181     0.200
     0.852    -0.669     0.200
     0.216     0.252     0.200
     0.216    -0.078     0.200
     0.210    -0.849     0.200
     0.610     0.705     0.200
     0.618     0.434     0.200
     0.670    -0.147     0.200
     0.662     0.408     0.200
     0.688    -0.126     0.200
     0.724    -0.498     0.200
     0.762     0.084     0.200
     0.770    -1.003     0.200
     0.817    -0.067     0.200
     0.850    -0.754     0.200
     0.930    -1.290     0.200
     0.930    -1.040     0.200
     0.273     0.736     0.200
     0.273     0.607     0.200
     0.284     0.471     0.200
     0.699     0.291     0.200
     0.727    -0.522     0.200
     0.684     0.239     0.200
     0.765     0.036     0.200
     0.817    -0.245     0.200
     0.890     0.005     0.200
     0.296     0.392     0.200
     0.284     0.542     0.200
     0.284     0.421     0.200
     0.711     0.276     0.200
     0.700     0.345     0.200
     0.754    -0.030     0.200
     0.775    -0.077     0.200
     0.731    -0.468     0.200
     0.829     0.182     0.200
     0.851    -0.705     0.200
     0.899    -0.066     0.200
     0.129    -0.118     0.200
     0.263    -0.587     0.200
     0.225    -0.231     0.200
     0.333    -0.603     0.200
     0.333    -0.867     0.200
     0.346     0.194     0.200
     0.357    -0.011     0.200
     0.405     0.494     0.200
     0.457    -0.196     0.200
     0.457    -0.307     0.200
     0.565    -0.497     0.200
     0.604    -0.409     0.200
     0.586     0.681     0.200
     0.638     0.236     0.200
     0.676    -0.436     0.200
     0.814    -0.444     0.200
     0.819    -0.545     0.200
     0.819    -0.605     0.200
     0.792    -0.153     0.200
     0.875    -0.638     0.200
     0.877    -0.217     0.200
     0.286     0.664     0.200
     0.304     0.405     0.200
     0.708     0.417     0.200
     0.718    -0.272     0.200
     0.724     0.223     0.200
     0.768     0.169     0.200
     0.869    -0.828     0.200
     0.917    -0.214     0.200
     0.034    -1.081     0.200
     0.278     0.403     0.200
     0.456    -0.080     0.200
     0.529     0.135     0.200
     0.600    -0.095     0.200
     0.643    -0.314     0.200
     0.706    -0.602     0.200
     0.707    -0.706     0.200
     0.707    -0.346     0.200
     0.747     0.102     0.200
     0.762    -1.068     0.200
     0.762    -0.861     0.200
     0.936     0.782     0.200
     0.232    -0.150     0.200
     0.220    -0.129     0.200
     0.447     0.499     0.200
     0.579    -0.485     0.200
     0.616     0.420     0.200
     0.618     0.432     0.200
     0.661     0.369     0.200
     0.682    -0.008     0.200
     0.761    -0.739     0.200
     0.809     0.166     0.200
     0.850    -0.944     0.200
     0.850    -0.407     0.200
     0.072    -0.262     0.200
     0.568     0.088     0.200
     0.745    -0.724     0.200
     0.743    -0.794     0.200
     0.785    -0.024     0.200
     0.802    -0.451     0.200
     0.765    -0.870     0.200
     0.909     1.124     0.200
     0.241     0.553     0.200
     0.241     0.439     0.200
     0.250     0.367     0.200
     0.486     0.362     0.200
     0.818    -0.575     0.200
     0.866    -0.071     0.200
     0.261     0.220     0.200
     0.268     0.077     0.200
     0.295    -0.022     0.200
     0.348     0.599     0.200
     0.348     0.309     0.200
     0.450     0.024     0.200
     0.512     0.007     0.200
     0.467    -0.209     0.200
     0.521    -0.300     0.200
     0.559    -0.140     0.200
     0.585     0.153     0.200
     0.602    -0.079     0.200
     0.649     0.223     0.200
     0.682    -0.209     0.200
     0.616     0.895     0.200
     0.668    -0.378     0.200
     0.677     0.486     0.200
     0.701    -0.494     0.200
     0.815    -0.573     0.200
     0.834    -0.678     0.200
     0.865    -0.692     0.200
     0.888    -0.467     0.200
     0.867    -0.669     0.200
     0.905     0.659     0.200
     0.059     1.019     0.200
     0.059    -1.121     0.200
     0.150    -0.310     0.200
     0.176     0.224     0.200
     0.303     0.061     0.200
     0.303     0.542     0.200
     0.443     0.084     0.200
     0.463     0.522     0.200
     0.463     0.662     0.200
     0.477    -0.136     0.200
     0.511     0.040     0.200
     0.514     0.365     0.200
     0.553    -0.150     0.200
     0.619    -0.140     0.200
     0.619    -0.111     0.200
     0.653    -0.642     0.200
     0.679     0.859     0.200
     0.720    -0.560     0.200
     0.730    -0.643     0.200
     0.723    -0.530     0.200
     0.751    -0.574     0.200
     0.779    -0.946     0.200
     0.764     0.106     0.200
     0.786    -0.300     0.200
     0.882    -0.549     0.200
     0.911    -0.184     0.200
     0.985    -0.474     0.200
     0.080    -0.366     0.200
     0.121    -0.598     0.200
     0.318     0.091     0.200
     0.318     0.474     0.200
     0.418    -0.014     0.200
     0.470     0.830     0.200
     0.497     0.103     0.200
     0.504    -0.159     0.200
     0.519     0.360     0.200
     0.603    -0.275     0.200
     0.575     0.253     0.200
     0.634    -0.598     0.200
     0.638    -0.003     0.200
     0.650    -0.163     0.200
     0.729    -0.446     0.200
     0.714     0.839     0.200
     0.756    -0.894     0.200
     0.749    -0.747     0.200
     0.757    -0.717     0.200
     0.757    -0.608     0.200
     0.797    -0.058     0.200
     0.897    -0.454     0.200
     0.085    -0.764     0.200
     0.117    -0.530     0.200
     0.139     0.350     0.200
     0.321     0.341     0.200
     0.360     0.516     0.200
     0.414     0.101     0.200
     0.472     0.550     0.200
     0.472     0.682     0.200
     0.495     0.085     0.200
     0.509    -0.353     0.200
     0.579    -0.143     0.200
     0.597    -0.269     0.200
     0.630    -0.530     0.200
     0.642    -0.245     0.200
     0.655    -0.446     0.200
     0.730    -0.505     0.200
     0.752    -0.779     0.200
     0.720     0.556     0.200
     0.752    -0.968     0.200
     0.762    -1.030     0.200
     0.802    -0.296     0.200
     0.899    -0.599     0.200
     0.069    -0.850     0.200
     0.132    -0.519     0.200
     0.158     0.095     0.200
     0.428     0.064     0.200
     0.466     0.612     0.200
     0.492    -0.113     0.200
     0.502     0.153     0.200
     0.516     0.430     0.200
     0.565    -0.076     0.200
     0.629    -0.055     0.200
     0.637    -0.104     0.200
     0.641    -0.579     0.200
     0.619    -0.295     0.200
     0.699     0.755     0.200
     0.740    -0.729     0.200
     0.742    -0.724     0.200
     0.761    -0.565     0.200
     0.765    -0.884     0.200
     0.782     0.112     0.200
     0.800    -0.382     0.200
     0.890    -0.684     0.200
     0.162    -0.162     0.200
     0.243    -0.236     0.200
     0.243    -0.286     0.200
     0.254    -0.380     0.200
     0.299    -0.489     0.200
     0.313    -0.571     0.200
     0.345    -0.016     0.200
     0.345     0.156     0.200
     0.382    -0.050     0.200
     0.393    -0.550     0.200
     0.403    -0.037     0.200
     0.425    -0.073     0.200
     0.472    -0.312     0.200
     0.465    -0.031     0.200
     0.492     0.591     0.200
     0.470    -0.064     0.200
     0.518     0.319     0.200
     0.580     0.598     0.200
     0.580     0.468     0.200
     0.578    -0.239     0.200
     0.591     0.082     0.200
     0.576    -0.175     0.200
     0.591    -0.042     0.200
     0.610     0.684     0.200
     0.603    -0.380     0.200
     0.667     0.021     0.200
     0.667     0.151     0.200
     0.684    -0.349     0.200
     0.703    -0.412     0.200
     0.700    -0.125     0.200
     0.775    -0.388     0.200
     0.804    -0.085     0.200
     0.789     0.310     0.200
     0.807     0.545     0.200
     0.819    -0.514     0.200
     0.820     0.083     0.200
     0.843    -0.578     0.200
     0.831     0.245     0.200
     0.831     0.455     0.200
     0.860    -0.091     0.200
     0.880     0.073     0.200
     0.967    -0.321     0.200
     0.109     0.191     0.200
     0.111    -0.079     0.200
     0.097    -0.137     0.200
     0.235     0.415     0.200
     0.235     1.345     0.200
     0.285    -0.277     0.200
     0.291     0.422     0.200
     0.291     0.305     0.200
     0.371    -1.105     0.200
     0.371     0.723     0.200
     0.418     0.268     0.200
     0.412     0.380     0.200
     0.483     0.507     0.200
     0.503     0.458     0.200
     0.533     0.222     0.200
     0.533     0.425     0.200
     0.552     0.186     0.200
     0.530     0.391     0.200
     0.539     0.400     0.200
     0.543     0.258     0.200
     0.564    -0.092     0.200
     0.542     0.000     0.200
     0.573     0.233     0.200
     0.559     0.805     0.200
     0.587     0.148     0.200
     0.602     0.930     0.200
     0.670    -0.336     0.200
     0.673     0.095     0.200
     0.755     0.197     0.200
     0.841    -0.149     0.200
     0.883     0.078     0.200
     0.963    -0.761     0.200
     0.995     0.107     0.200
     0.033    -0.464     0.200
     0.043     0.024     0.200
     0.075    -0.784     0.200
     0.113    -0.578     0.200
     0.129     0.129     0.200
     0.150     0.182     0.200
     0.227    -0.106     0.200
     0.248     0.087     0.200
     0.253     0.023     0.200
     0.309     0.499     0.200
     0.312     0.653     0.200
     0.323     0.429     0.200
     0.337    -0.131     0.200
     0.364     0.507     0.200
     0.409     0.171     0.200
     0.447     0.154     0.200
     0.460     0.697     0.200
     0.487     0.242     0.200
     0.509     0.427     0.200
     0.555     0.809     0.200
     0.568     0.080     0.200
     0.589     0.293     0.200
     0.587     0.597     0.200
     0.624    -0.401     0.200
     0.630    -0.020     0.200
     0.645    -0.191     0.200
     0.645    -0.251     0.200
     0.719    -0.290     0.200
     0.719     0.698     0.200
     0.740    -0.750     0.200
     0.746    -0.655     0.200
     0.794    -0.477     0.200
     0.793    -0.093     0.200
     0.803    -0.480     0.200
     0.921    -0.253     0.200
     0.050    -0.352     0.200
     0.127    -0.413     0.200
     0.234    -0.020     0.200
     0.234     0.230     0.200
     0.232     0.458     0.200
     0.267     0.518     0.200
     0.309     0.115     0.200
     0.362     0.041     0.200
     0.407     1.008     0.200
     0.437     0.124     0.200
     0.447     0.521     0.200
     0.469     0.730     0.200
     0.506     0.676     0.200
     0.503     0.822     0.200
     0.510     0.537     0.200
     0.518     0.607     0.200
     0.555     0.236     0.200
     0.573     0.359     0.200
     0.598     0.755     0.200
     0.605    -0.030     0.200
     0.636     0.398     0.200
     0.691     0.281     0.200
     0.689     0.083     0.200
     0.690    -0.315     0.200
     0.717    -1.102     0.200
     0.716     0.031     0.200
     0.717    -0.253     0.200
     0.735     0.329     0.200
     0.755    -0.017     0.200
     0.767    -0.274     0.200
     0.845    -0.051     0.200
     0.901     0.515     0.200
     0.890    -0.656     0.200
     0.913    -0.578     0.200
     0.099    -0.051     0.200
     0.113    -0.013     0.200
     0.142    -0.145     0.200
     0.152    -0.071     0.200
     0.153     0.259     0.200
     0.177    -0.233     0.200
     0.190     0.179     0.200
     0.219    -0.009     0.200
     0.282    -0.570     0.200
     0.284    -0.018     0.200
     0.331    -0.212     0.200
     0.330    -0.174     0.200
     0.366     0.206     0.200
     0.375    -0.235     0.200
     0.377     0.057     0.200
     0.396     0.154     0.200
     0.414     0.319     0.200
     0.443     1.077     0.200
     0.458     0.541     0.200
     0.469    -0.157     0.200
     0.482     0.141     0.200
     0.478     0.180     0.200
     0.525    -0.776     0.200
     0.530    -0.550     0.200
     0.589     0.008     0.200
     0.591     0.092     0.200
     0.615    -0.566     0.200
     0.604    -0.088     0.200
     0.626    -0.626     0.200
     0.638    -0.548     0.200
     0.650    -0.987     0.200
     0.658    -0.093     0.200
     0.678    -0.594     0.200
     0.757     0.343     0.200
     0.820     0.080     0.200
     0.910     0.368     0.200
     0.938    -0.738     0.200
     0.947    -0.554     0.200
     0.947    -0.394     0.200
     0.048    -0.740     0.200
     0.065    -0.882     0.200
     0.105    -0.481     0.200
     0.108    -0.428     0.200
     0.106    -0.906     0.200
     0.132     0.104     0.200
     0.155     0.367     0.200
     0.160     0.340     0.200
     0.242     0.006     0.200
     0.259     0.108     0.200
     0.255     0.060     0.200
     0.245     0.009     0.200
     0.276     0.386     0.200
     0.305     0.491     0.200
     0.303     0.412     0.200
     0.314     0.770     0.200
     0.319     0.697     0.200
     0.327    -0.394     0.200
     0.356     1.097     0.200
     0.344     0.159     0.200
     0.359     0.371     0.200
     0.421     0.167     0.200
     0.459     0.600     0.200
     0.494     0.191     0.200
     0.489    -0.120     0.200
     0.514     0.229     0.200
     0.509     0.388     0.200
     0.541     0.690     0.200
     0.561     0.111     0.200
     0.587     0.172     0.200
     0.594     0.538     0.200
     0.633    -0.482     0.200
     0.624    -0.102     0.200
     0.634    -0.172     0.200
     0.634    -0.023     0.200
     0.694     0.377     0.200
     0.718    -0.357     0.200
     0.704     0.636     0.200
     0.735    -0.803     0.200
     0.757    -0.626     0.200
     0.741    -0.897     0.200
     0.756    -0.523     0.200
     0.781    -0.027     0.200
     0.796    -0.483     0.200
     0.918    -0.228     0.200
     0.148    -0.527     0.200
     0.199    -0.365     0.200
     0.216    -0.097     0.200
     0.234     0.378     0.200
     0.275    -0.181     0.200
     0.283     0.489     0.200
     0.298     0.224     0.200
     0.306     0.309     0.200
     0.285     0.435     0.200
     0.323     0.448     0.200
     0.326     0.307     0.200
     0.356     0.255     0.200
     0.365     0.280     0.200
     0.386     0.449     0.200
     0.411     0.092     0.200
     0.405     0.594     0.200
     0.406     0.605     0.200
     0.406     0.485     0.200
     0.436    -0.076     0.200
     0.503     0.479     0.200
     0.538     0.483     0.200
     0.553    -0.250     0.200
     0.552    -0.170     0.200
     0.542     0.109     0.200
     0.559     0.404     0.200
     0.549     0.591     0.200
     0.566     0.125     0.200
     0.609     0.161     0.200
     0.611     0.362     0.200
     0.611    -0.103     0.200
     0.618     0.039     0.200
     0.638    -1.034     0.200
     0.684     0.031     0.200
     0.661     0.598     0.200
     0.720    -0.394     0.200
     0.739    -0.421     0.200
     0.749    -0.078     0.200
     0.748    -0.144     0.200
     0.763    -0.883     0.200
     0.829    -0.369     0.200
     0.883    -0.273     0.200
     0.884    -0.500     0.200
     0.882    -0.441     0.200
     0.961     0.412     0.200
     0.961     0.532     0.200
     0.110    -0.225     0.200
     0.125    -0.385     0.200
     0.154     0.152     0.200
     0.191    -0.550     0.200
     0.163    -0.191     0.200
     0.216    -0.817     0.200
     0.224    -0.727     0.200
     0.205     0.221     0.200
     0.227    -0.177     0.200
     0.244     0.281     0.200
     0.243    -0.026     0.200
     0.289     0.217     0.200
     0.240     0.104     0.200
     0.290    -0.031     0.200
     0.315     0.470     0.200
     0.338     0.361     0.200
     0.338     0.330     0.200
     0.323     0.482     0.200
     0.362     0.374     0.200
     0.375     0.142     0.200
     0.346     0.593     0.200
     0.385     0.079     0.200
     0.372     0.611     0.200
     0.383     0.579     0.200
     0.395     0.490     0.200
     0.397     0.720     0.200
     0.445     0.234     0.200
     0.448     0.256     0.200
     0.451    -0.017     0.200
     0.483    -0.049     0.200
     0.452     0.067     0.200
     0.507    -0.174     0.200
     0.514     0.358     0.200
     0.562    -0.027     0.200
     0.539    -0.086     0.200
     0.588    -0.005     0.200
     0.548     0.129     0.200
     0.546     0.205     0.200
     0.559     0.894     0.200
     0.553     0.054     0.200
     0.573    -0.243     0.200
     0.626    -0.239     0.200
     0.590    -0.071     0.200
     0.616    -0.073     0.200
     0.612     0.134     0.200
     0.639    -0.363     0.200
     0.628     0.206     0.200
     0.640     0.322     0.200
     0.638     0.952     0.200
     0.676    -0.682     0.200
     0.690    -0.813     0.200
     0.665    -0.059     0.200
     0.672     0.608     0.200
     0.669     0.115     0.200
     0.687    -0.068     0.200
     0.724    -0.361     0.200
     0.640     0.462     0.200
     0.705     0.019     0.200
     0.753    -0.674     0.200
     0.744    -0.590     0.200
     0.742    -0.157     0.200
     0.763    -0.741     0.200
     0.736     0.006     0.200
     0.730     0.330     0.200
     0.756    -0.110     0.200
     0.772    -0.110     0.200
     0.774    -0.112     0.200
     0.827    -0.981     0.200
     0.800    -0.073     0.200
     0.826     0.104     0.200
     0.826     0.077     0.200
     0.813     0.290     0.200
     0.854     0.044     0.200
     0.864    -0.224     0.200
     0.927    -0.615     0.200
     0.932    -0.831     0.200
     0.924     0.008     0.200
     0.917     0.063     0.200
     0.917     0.314     0.200
     0.931    -0.199     0.200
     0.931    -0.172     0.200
     0.930     0.101     0.200
     0.948     0.389     0.200
     0.967    -0.165     0.200
     0.996    -0.769     0.200
     0.997    -0.804     0.200
     0.072    -0.653     0.200
     0.073    -0.707     0.200
     0.139    -0.048     0.200
     0.128    -0.264     0.200
     0.165    -0.218     0.200
     0.175     0.349     0.200
     0.215    -0.263     0.200
     0.292     0.386     0.200
     0.297     0.156     0.200
     0.315     0.428     0.200
     0.319    -0.173     0.200
     0.324     0.538     0.200
     0.389     0.202     0.200
     0.476     0.601     0.200
     0.476     0.620     0.200
     0.483     0.439     0.200
     0.483    -0.117     0.200
     0.494    -0.074     0.200
     0.494     0.096     0.200
     0.528    -0.051     0.200
     0.502     0.526     0.200
     0.533     0.704     0.200
     0.600     0.206     0.200
     0.595     0.435     0.200
     0.595     0.591     0.200
     0.629    -0.082     0.200
     0.622    -0.051     0.200
     0.644    -0.407     0.200
     0.663     0.323     0.200
     0.733    -0.440     0.200
     0.724    -0.943     0.200
     0.740    -0.693     0.200
     0.760    -0.582     0.200
     0.776    -0.512     0.200
     0.766     0.084     0.200
     0.795    -1.112     0.200
     0.811    -0.980     0.200
     0.873    -0.318     0.200
     0.881    -0.384     0.200
     0.854     0.967     0.200
     0.896    -0.324     0.200
     0.896    -0.084     0.200
     0.961    -0.223     0.200
     0.930     1.051     0.200
     0.969     0.293     0.200
     0.106    -0.899     0.200
     0.107    -0.940     0.200
     0.144    -0.997     0.200
     0.150    -0.212     0.200
     0.182    -0.238     0.200
     0.214     0.364     0.200
     0.308    -0.359     0.200
     0.332     0.314     0.200
     0.330     0.064     0.200
     0.352     0.154     0.200
     0.345     0.297     0.200
     0.345     0.808     0.200
     0.369     0.300     0.200
     0.441    -0.098     0.200
     0.444     0.535     0.200
     0.473    -0.084     0.200
     0.491     0.322     0.200
     0.500     0.438     0.200
     0.500     0.458     0.200
     0.514     0.247     0.200
     0.514     0.207     0.200
     0.554     0.407     0.200
     0.547    -0.383     0.200
     0.575     0.188     0.200
     0.575     0.038     0.200
     0.602    -0.140     0.200
     0.618     0.281     0.200
     0.608     0.556     0.200
     0.608     0.642     0.200
     0.633     0.000     0.200
     0.696    -0.977     0.200
     0.701    -0.767     0.200
     0.720    -0.664     0.200
     0.726     0.612     0.200
     0.744    -0.637     0.200
     0.744    -0.636     0.200
     0.740     0.011     0.200
     0.787    -0.118     0.200
     0.800    -0.519     0.200
     0.805     0.212     0.200
     0.832    -0.379     0.200
     0.848    -1.056     0.200
     0.865    -0.910     0.200
     0.902    -0.350     0.200
     0.872     0.071     0.200
     0.939     0.234     0.200
     0.040     0.067     0.200
     0.082    -0.399     0.200
     0.118     0.258     0.200
     0.142     0.191     0.200
     0.227    -0.183     0.200
     0.256     0.022     0.200
     0.242     0.183     0.200
     0.302     0.687     0.200
     0.319     0.466     0.200
     0.345    -0.201     0.200
     0.417     0.014     0.200
     0.417     0.061     0.200
     0.446     0.209     0.200
     0.471     0.599     0.200
     0.471     0.630     0.200
     0.469     0.341     0.200
     0.497     0.063     0.200
     0.506    -0.227     0.200
     0.520     0.476     0.200
     0.549     0.727     0.200
     0.578     0.529     0.200
     0.599    -0.672     0.200
     0.600     0.003     0.200
     0.633    -0.646     0.200
     0.640    -0.160     0.200
     0.759    -0.651     0.200
     0.716     0.304     0.200
     0.751    -0.712     0.200
     0.751    -0.762     0.200
     0.755    -0.798     0.200
     0.762    -0.716     0.200
     0.770     0.123     0.200
     0.799    -0.081     0.200
     0.799     0.048     0.200
     0.812    -0.416     0.200
     0.849    -0.282     0.200
     0.898    -0.492     0.200
     0.909    -0.121     0.200
     0.909     0.102     0.200
     0.036    -0.317     0.200
     0.073    -0.614     0.200
     0.075    -0.701     0.200
     0.129     0.194     0.200
     0.151     0.218     0.200
     0.229    -0.123     0.200
     0.250     0.069     0.200
     0.278     0.446     0.200
     0.251     0.100     0.200
     0.309     0.532     0.200
     0.313     0.614     0.200
     0.345    -0.070     0.200
     0.336    -0.117     0.200
     0.348     0.433     0.200
     0.411     0.114     0.200
     0.411     0.104     0.200
     0.449     0.005     0.200
     0.459     0.255     0.200
     0.488     0.176     0.200
     0.497    -0.153     0.200
     0.510     0.367     0.200
     0.552     0.791     0.200
     0.589     0.222     0.200
     0.589     0.222     0.200
     0.594    -0.567     0.200
     0.588     0.396     0.200
     0.588     0.402     0.200
     0.625    -0.476     0.200
     0.629    -0.054     0.200
     0.643    -0.210     0.200
     0.719    -0.360     0.200
     0.717     0.684     0.200
     0.748    -0.749     0.200
     0.757    -0.351     0.200
     0.761    -0.497     0.200
     0.764    -0.677     0.200
     0.794    -0.502     0.200
     0.791    -0.124     0.200
     0.802    -0.533     0.200
     0.839    -0.405     0.200
     0.887    -0.633     0.200
     0.997     0.213     0.200
     0.052    -0.493     0.200
     0.074    -0.076     0.200
     0.177    -0.093     0.200
     0.229    -0.583     0.200
     0.268    -0.018     0.200
     0.352    -0.500     0.200
     0.350     0.018     0.200
     0.358    -0.379     0.200
     0.344    -0.164     0.200
     0.318     0.043     0.200
     0.412    -0.331     0.200
     0.384     0.659     0.200
     0.420    -0.016     0.200
     0.415     0.692     0.200
     0.411     0.067     0.200
     0.446     0.401     0.200
     0.472    -0.114     0.200
     0.493     0.406     0.200
     0.507     0.123     0.200
     0.498    -0.126     0.200
     0.513     0.410     0.200
     0.503     0.693     0.200
     0.547    -0.475     0.200
     0.574    -0.204     0.200
     0.539     0.881     0.200
     0.537     0.126     0.200
     0.547    -0.052     0.200
     0.602    -0.148     0.200
     0.610    -0.107     0.200
     0.633    -0.075     0.200
     0.650    -0.181     0.200
     0.660     0.000     0.200
     0.674    -0.669     0.200
     0.652     0.015     0.200
     0.730     0.107     0.200
     0.772    -0.235     0.200
     0.727     0.301     0.200
     0.740    -0.102     0.200
     0.761    -0.181     0.200
     0.776    -0.261     0.200
     0.777    -0.287     0.200
     0.783    -0.203     0.200
     0.830    -0.172     0.200
     0.864    -0.629     0.200
     0.864    -0.268     0.200
     0.816     0.253     0.200
     0.850    -0.221     0.200
     0.877    -0.270     0.200
     0.883     0.196     0.200
     0.754     2.676     0.200
     0.906     0.578     0.200
     0.944    -0.635     0.200
     0.922    -0.082     0.200
     0.966     0.500     0.200
     0.098    -1.125     0.200
     0.153    -0.878     0.200
     0.100    -0.331     0.200
     0.154     0.171     0.200
     0.146    -0.271     0.200
     0.146    -0.160     0.200
     0.222    -0.143     0.200
     0.341     0.060     0.200
     0.333    -0.545     0.200
     0.356     0.036     0.200
     0.353    -0.451     0.200
     0.339     0.278     0.200
     0.337     0.277     0.200
     0.415     0.112     0.200
     0.392     0.262     0.200
     0.407    -0.005     0.200
     0.403    -0.236     0.200
     0.438     0.170     0.200
     0.396     0.427     0.200
     0.408     0.221     0.200
     0.448    -0.335     0.200
     0.497     0.070     0.200
     0.488     0.191     0.200
     0.444     0.986     0.200
     0.503    -0.206     0.200
     0.469     0.058     0.200
     0.485     0.298     0.200
     0.485     0.298     0.200
     0.468     0.061     0.200
     0.567    -0.572     0.200
     0.595    -0.380     0.200
     0.533     0.463     0.200
     0.605    -0.232     0.200
     0.555     0.422     0.200
     0.592     0.090     0.200
     0.670    -0.737     0.200
     0.697    -0.249     0.200
     0.698    -0.407     0.200
     0.685     0.141     0.200
     0.721    -0.976     0.200
     0.716    -0.760     0.200
     0.685     0.505     0.200
     0.720     0.002     0.200
     0.777    -0.604     0.200
     0.775    -0.077     0.200
     0.752     0.311     0.200
     0.784     0.187     0.200
     0.840    -0.254     0.200
     0.904    -0.316     0.200
     0.894     0.092     0.200
     0.929    -0.362     0.200
     0.941    -0.101     0.200
     0.093    -0.766     0.200
     0.072    -0.546     0.200
     0.104    -0.174     0.200
     0.147    -0.579     0.200
     0.107    -0.032     0.200
     0.150    -0.197     0.200
     0.151    -0.140     0.200
     0.214    -0.075     0.200
     0.214    -0.075     0.200
     0.181     0.007     0.200
     0.220     0.015     0.200
     0.331    -0.403     0.200
     0.331    -0.379     0.200
     0.336     0.081     0.200
     0.351    -0.234     0.200
     0.339     0.013     0.200
     0.410     0.228     0.200
     0.403    -0.239     0.200
     0.398     0.392     0.200
     0.389     0.213     0.200
     0.403    -0.077     0.200
     0.396     0.673     0.200
     0.451    -0.399     0.200
     0.410     0.608     0.200
     0.485     0.480     0.200
     0.470     0.038     0.200
     0.492     0.117     0.200
     0.471     0.024     0.200
     0.498    -0.218     0.200
     0.444     0.830     0.200
     0.482     0.223     0.200
     0.482     0.232     0.200
     0.562    -0.565     0.200
     0.535     0.286     0.200
     0.602    -0.358     0.200
     0.558     0.198     0.200
     0.558     0.049     0.200
     0.556     0.143     0.200
     0.556     0.252     0.200
     0.596    -0.132     0.200
     0.681    -0.532     0.200
     0.694    -0.314     0.200
     0.686    -0.018     0.200
     0.667    -0.790     0.200
     0.697    -0.383     0.200
     0.717    -1.014     0.200
     0.711    -0.906     0.200
     0.690     0.274     0.200
     0.776    -0.530     0.200
     0.776    -0.053     0.200
     0.752     0.182     0.200
     0.787     0.098     0.200
     0.758     0.098     0.200
     0.840    -0.152     0.200
     0.906    -0.297     0.200
     0.897     0.069     0.200
     0.944     0.015     0.200
     0.086    -0.138     0.200
     0.122     0.189     0.200
     0.177    -0.446     0.200
     0.179    -0.666     0.200
     0.149    -0.225     0.200
     0.197    -0.131     0.200
     0.190    -0.034     0.200
     0.229    -0.785     0.200
     0.229    -0.734     0.200
     0.234    -0.700     0.200
     0.220     0.199     0.200
     0.209     0.085     0.200
     0.239     0.254     0.200
     0.209     0.255     0.200
     0.320     0.341     0.200
     0.320     0.341     0.200
     0.330     0.213     0.200
     0.312     0.069     0.200
     0.347     0.570     0.200
     0.371     0.487     0.200
     0.372     0.525     0.200
     0.393    -0.004     0.200
     0.399     0.239     0.200
     0.395     0.462     0.200
     0.376     0.764     0.200
     0.455    -0.522     0.200
     0.418     0.096     0.200
     0.473     0.376     0.200
     0.494    -0.308     0.200
     0.502    -0.040     0.200
     0.505    -0.035     0.200
     0.512    -0.060     0.200
     0.524     0.271     0.200
     0.519     0.045     0.200
     0.561    -0.280     0.200
     0.558    -0.074     0.200
     0.589     0.390     0.200
     0.607    -0.186     0.200
     0.573     0.637     0.200
     0.571     0.625     0.200
     0.638    -0.394     0.200
     0.650    -0.292     0.200
     0.635    -0.165     0.200
     0.650    -0.030     0.200
     0.635     0.073     0.200
     0.657    -0.166     0.200
     0.662     0.220     0.200
     0.655    -0.742     0.200
     0.671     0.502     0.200
     0.705    -0.713     0.200
     0.672    -0.007     0.200
     0.707    -0.396     0.200
     0.702    -0.063     0.200
     0.728    -0.281     0.200
     0.705     0.607     0.200
     0.705     0.618     0.200
     0.758    -0.630     0.200
     0.752    -0.008     0.200
     0.752    -0.037     0.200
     0.740    -0.182     0.200
     0.720     0.192     0.200
     0.733     0.087     0.200
     0.729     0.306     0.200
     0.759     0.284     0.200
     0.759     0.515     0.200
     0.766    -0.095     0.200
     0.797    -0.685     0.200
     0.802    -0.076     0.200
     0.773     0.155     0.200
     0.831    -0.751     0.200
     0.781     0.309     0.200
     0.797     0.276     0.200
     0.827    -0.115     0.200
     0.824     0.020     0.200
     0.824    -0.199     0.200
     0.832    -0.271     0.200
     0.899     0.156     0.200
     0.920    -0.568     0.200
     0.896    -0.061     0.200
     0.928    -1.005     0.200
     0.931     0.186     0.200
     0.936    -0.325     0.200
     0.980    -0.461     0.200
     0.981    -0.495     0.200
     0.954     0.116     0.200
     0.169    -0.484     0.200
     0.168    -0.480     0.200
     0.186    -0.497     0.200
     0.253     0.194     0.200
     0.269     0.223     0.200
     0.298     0.073     0.200
     0.290    -0.382     0.200
     0.344    -0.179     0.200
     0.336     0.187     0.200
     0.336     0.197     0.200
     0.359     0.612     0.200
     0.413     0.366     0.200
     0.414     0.369     0.200
     0.400     0.191     0.200
     0.440     0.485     0.200
     0.441     0.465     0.200
     0.453     0.209     0.200
     0.481     0.151     0.200
     0.497     0.434     0.200
     0.493     0.689     0.200
     0.538     0.417     0.200
     0.538     0.417     0.200
     0.569     0.177     0.200
     0.587    -0.006     0.200
     0.585     0.331     0.200
     0.593    -0.182     0.200
     0.633    -0.305     0.200
     0.633    -0.314     0.200
     0.651    -0.224     0.200
     0.657    -0.021     0.200
     0.664     0.094     0.200
     0.675     0.177     0.200
     0.673    -0.069     0.200
     0.731     0.023     0.200
     0.746    -0.750     0.200
     0.766    -0.928     0.200
     0.753     0.489     0.200
     0.753     0.453     0.200
     0.799     0.216     0.200
     0.790     0.085     0.200
     0.823    -0.391     0.200
     0.885    -1.053     0.200
     0.882     0.073     0.200
     0.903    -0.567     0.200
     0.901     0.015     0.200
     0.972    -0.568     0.200
     0.963     0.179     0.200
     0.982     0.174     0.200
     0.986     0.146     0.200
     0.967    -0.529     0.200
     0.966    -0.462     0.200
     0.992     0.277     0.200
     0.835     0.195     0.200
     0.781     0.217     0.200
     0.453    -0.070     0.200
     0.461     0.145     0.200
     0.314    -0.006     0.200
     0.247     0.026     0.200
     0.670     0.209     0.200
     0.178    -0.109     0.200
     0.983    -0.359     0.200
     0.366     0.496     0.200
     0.771     0.128     0.200
     0.887    -0.182     0.200
     0.696    -0.311     0.200
     0.430     0.146     0.200
     0.437     0.045     0.200
     0.435     0.086     0.200
     0.194     0.429     0.200
     0.033    -0.209     0.200
     0.921    -0.372     0.200
     0.630    -0.170     0.200
     0.338    -0.174     0.200
     0.499     0.353     0.200
     0.136    -0.257     0.200
     0.136    -0.145     0.200
     0.795    -0.146     0.200
     0.988    -0.676     0.200
     0.082    -0.899     0.200
     0.241    -0.463     0.200
     0.262    -0.431     0.200
     0.627    -0.153     0.200
     0.524     0.248     0.200
     0.524     0.257     0.200
     0.718    -0.237     0.200
     0.884    -0.533     0.200
     0.452     0.441     0.200
     0.632    -0.153     0.200
     0.215    -0.207     0.200
     0.253    -0.050     0.200
     0.423     0.240     0.200
     0.386     0.345     0.200
     0.613    -0.397     0.200
     0.284    -0.207     0.200
     0.509    -0.153     0.200
     0.316     0.119     0.200
     0.336     0.211     0.200
     0.398     0.033     0.200
     0.693    -0.580     0.200
     0.509     0.077     0.200
     0.393    -0.137     0.200
     0.399    -0.197     0.200
     0.597    -0.258     0.200
     0.983    -0.951     0.200
     0.493    -0.280     0.200
     0.546    -0.655     0.200
     0.580    -0.499     0.200
     0.678    -0.814     0.200
     0.617    -0.680     0.200
     0.692    -0.755     0.200
     0.027    -0.238     0.200
     0.149     0.113     0.200
     0.223    -0.282     0.200
     0.180     0.416     0.200
     0.176    -0.109     0.200
     0.264    -0.132     0.200
     0.254    -0.504     0.200
     0.254    -0.563     0.200
     0.285    -0.207     0.200
     0.276    -0.460     0.200
     0.236     0.006     0.200
     0.325     0.039     0.200
     0.347     0.187     0.200
     0.318    -0.074     0.200
     0.318     0.035     0.200
     0.349    -0.282     0.200
     0.404    -0.214     0.200
     0.410    -0.257     0.200
     0.392    -0.041     0.200
     0.374     0.387     0.200
     0.413     0.286     0.200
     0.439     0.045     0.200
     0.421     0.080     0.200
     0.423     0.048     0.200
     0.440     0.457     0.200
     0.504    -0.398     0.200
     0.457    -0.184     0.200
     0.466     0.074     0.200
     0.499     0.342     0.200
     0.522    -0.177     0.200
     0.542    -0.693     0.200
     0.511     0.692     0.200
     0.511     0.312     0.200
     0.592    -0.194     0.200
     0.611    -0.268     0.200
     0.629    -0.880     0.200
     0.626    -0.502     0.200
     0.619     0.022     0.200
     0.638    -0.122     0.200
     0.616     0.143     0.200
     0.632     0.263     0.200
     0.671    -0.738     0.200
     0.689    -0.828     0.200
     0.676     0.103     0.200
     0.706    -0.717     0.200
     0.683    -0.280     0.200
     0.750    -0.573     0.200
     0.729    -0.308     0.200
     0.785    -0.548     0.200
     0.777     0.006     0.200
     0.772     0.162     0.200
     0.800    -0.226     0.200
     0.804    -0.183     0.200
     0.839     0.077     0.200
     0.799     0.100     0.200
     0.885    -0.685     0.200
     0.829     0.143     0.200
     0.894    -0.658     0.200
     0.935    -0.403     0.200
     0.912    -0.753     0.200
     0.893    -0.096     0.200
     0.893    -0.266     0.200
     0.969    -0.353     0.200
     0.969    -0.183     0.200
     0.928    -0.442     0.200
     0.928     0.058     0.200
     0.996    -0.684     0.200
     0.150    -0.230     0.200
     0.226    -0.290     0.200
     0.178     0.415     0.200
     0.174    -0.086     0.200
     0.267    -0.121     0.200
     0.267    -0.131     0.200
     0.255    -0.527     0.200
     0.255    -0.527     0.200
     0.287    -0.280     0.200
     0.277    -0.471     0.200
     0.233     0.061     0.200
     0.328     0.007     0.200
     0.349     0.178     0.200
     0.316    -0.035     0.200
     0.349    -0.182     0.200
     0.394     0.008     0.200
     0.407    -0.162     0.200
     0.413    -0.216     0.200
     0.402     0.333     0.200
     0.373     0.490     0.200
     0.414     0.295     0.200
     0.440     0.510     0.200
     0.421     0.119     0.200
     0.419     0.150     0.200
     0.438     0.141     0.200
     0.507    -0.361     0.200
     0.500     0.123     0.200
     0.455    -0.130     0.200
     0.464     0.106     0.200
     0.484     0.455     0.200
     0.524    -0.145     0.200
     0.544    -0.668     0.200
     0.510     0.328     0.200
     0.510     0.346     0.200
     0.595     0.044     0.200
     0.606    -0.161     0.200
     0.613    -0.288     0.200
     0.632    -0.925     0.200
     0.627    -0.455     0.200
     0.618    -0.113     0.200
     0.614    -0.093     0.200
     0.638    -0.065     0.200
     0.630    -0.227     0.200
     0.672    -0.737     0.200
     0.691    -0.809     0.200
     0.707    -0.676     0.200
     0.675     0.194     0.200
     0.681    -0.225     0.200
     0.729    -0.260     0.200
     0.786    -0.434     0.200
     0.776     0.158     0.200
     0.769     0.273     0.200
     0.841    -0.384     0.200
     0.803    -0.131     0.200
     0.826     0.205     0.200
     0.936    -0.678     0.200
     0.894    -0.549     0.200
     0.912    -0.685     0.200
     0.892    -0.137     0.200
     0.972    -0.522     0.200
     0.972    -0.259     0.200
     0.927    -0.281     0.200
     0.994    -0.612     0.200
     0.051    -0.870     0.200
     0.053    -0.927     0.200
     0.059    -0.938     0.200
     0.145    -0.369     0.200
     0.145    -0.369     0.200
     0.143    -0.018     0.200
     0.175     0.210     0.200
     0.265     0.116     0.200
     0.257    -0.123     0.200
     0.246    -0.159     0.200
     0.294     0.398     0.200
     0.312    -0.262     0.200
     0.356     0.054     0.200
     0.333     0.502     0.200
     0.426     0.127     0.200
     0.426     0.127     0.200
     0.451     0.720     0.200
     0.451     0.750     0.200
     0.465     0.469     0.200
     0.474    -0.144     0.200
     0.477    -0.078     0.200
     0.477     0.052     0.200
     0.495     0.173     0.200
     0.489     0.451     0.200
     0.502     0.399     0.200
     0.531     0.609     0.200
     0.577     0.374     0.200
     0.577     0.324     0.200
     0.613    -0.604     0.200
     0.612     0.026     0.200
     0.612    -0.164     0.200
     0.619    -0.213     0.200
     0.619    -0.093     0.200
     0.607     0.576     0.200
     0.607     0.571     0.200
     0.636    -0.560     0.200
     0.709    -0.764     0.200
     0.693     0.569     0.200
     0.723    -0.674     0.200
     0.723    -0.663     0.200
     0.737     0.299     0.200
     0.744    -0.459     0.200
     0.750    -0.335     0.200
     0.762    -0.860     0.200
     0.765     0.083     0.200
     0.785    -0.398     0.200
     0.782    -0.415     0.200
     0.791    -0.779     0.200
     0.816    -0.236     0.200
     0.873    -0.495     0.200
     0.971     0.259     0.200
     0.048    -0.727     0.200
     0.049    -0.849     0.200
     0.048    -0.676     0.200
     0.132    -0.591     0.200
     0.132    -0.505     0.200
     0.152     0.113     0.200
     0.152     0.215     0.200
     0.177     0.224     0.200
     0.247     0.061     0.200
     0.247    -0.163     0.200
     0.247    -0.038     0.200
     0.310    -0.215     0.200
     0.310    -0.340     0.200
     0.338    -0.208     0.200
     0.263     0.070     0.200
     0.338     0.561     0.200
     0.409    -0.079     0.200
     0.409     0.093     0.200
     0.439     0.537     0.200
     0.456     0.462     0.200
     0.471    -0.200     0.200
     0.471    -0.067     0.200
     0.481     0.401     0.200
     0.478     0.215     0.200
     0.489     0.471     0.200
     0.468     0.250     0.200
     0.468     0.148     0.200
     0.566     0.481     0.200
     0.566     0.520     0.200
     0.604    -0.031     0.200
     0.547     0.815     0.200
     0.596    -0.631     0.200
     0.619    -0.603     0.200
     0.618    -0.245     0.200
     0.618    -0.135     0.200
     0.697    -0.039     0.200
     0.613     0.655     0.200
     0.613     0.635     0.200
     0.715    -0.408     0.200
     0.715    -0.665     0.200
     0.727    -0.858     0.200
     0.735     0.348     0.200
     0.745    -0.533     0.200
     0.745    -0.783     0.200
     0.707     0.730     0.200
     0.773    -0.369     0.200
     0.777    -0.371     0.200
     0.766    -0.004     0.200
     0.814    -0.198     0.200
     0.781    -0.653     0.200
     0.863    -0.438     0.200
     0.973     0.233     0.200
     0.938    -0.181     0.200
     0.041    -0.589     0.200
     0.043    -0.596     0.200
     0.060    -0.930     0.200
     0.060    -0.789     0.200
     0.144    -0.293     0.200
     0.144    -0.207     0.200
     0.154     0.103     0.200
     0.258     0.133     0.200
     0.184     0.311     0.200
     0.259    -0.026     0.200
     0.303    -0.108     0.200
     0.257     0.013     0.200
     0.420     0.129     0.200
     0.420     0.081     0.200
     0.343     0.561     0.200
     0.439     0.638     0.200
     0.465    -0.102     0.200
     0.486     0.291     0.200
     0.486     0.080     0.200
     0.490     0.433     0.200
     0.479     0.283     0.200
     0.566     0.317     0.200
     0.601    -0.052     0.200
     0.608    -0.732     0.200
     0.536     0.702     0.200
     0.628    -0.715     0.200
     0.610    -0.108     0.200
     0.617     0.582     0.200
     0.618     0.546     0.200
     0.712    -0.690     0.200
     0.738    -0.274     0.200
     0.728     0.301     0.200
     0.755    -0.855     0.200
     0.774    -0.460     0.200
     0.695     0.859     0.200
     0.772    -0.391     0.200
     0.757     0.013     0.200
     0.807    -0.210     0.200
     0.793    -0.988     0.200
     0.861    -0.538     0.200
     0.935    -0.489     0.200
     0.935    -0.470     0.200
     0.152     0.102     0.200
     0.062    -1.027     0.200
     0.042    -0.839     0.200
     0.044    -0.955     0.200
     0.183     0.227     0.200
     0.253    -0.021     0.200
     0.147    -0.340     0.200
     0.147    -0.309     0.200
     0.261    -0.012     0.200
     0.342     0.493     0.200
     0.262     0.022     0.200
     0.303    -0.203     0.200
     0.352     0.331     0.200
     0.532     0.706     0.200
     0.481    -0.077     0.200
     0.424     0.004     0.200
     0.424     0.043     0.200
     0.466    -0.093     0.200
     0.442     0.617     0.200
     0.456     0.548     0.200
     0.483     0.380     0.200
     0.489     0.156     0.200
     0.493     0.359     0.200
     0.568     0.528     0.200
     0.568     0.426     0.200
     0.610    -0.050     0.200
     0.610    -0.190     0.200
     0.611    -0.811     0.200
     0.603    -0.100     0.200
     0.632    -0.727     0.200
     0.729     0.434     0.200
     0.700    -0.265     0.200
     0.714    -0.550     0.200
     0.714    -0.495     0.200
     0.757     0.165     0.200
     0.795    -0.883     0.200
     0.741    -0.347     0.200
     0.759    -0.739     0.200
     0.773    -0.371     0.200
     0.932    -0.408     0.200
     0.932    -0.326     0.200
     0.777    -0.172     0.200
     0.807    -0.256     0.200
     0.864    -0.175     0.200
     0.964     0.265     0.200
     0.035    -0.445     0.200
     0.056    -0.651     0.200
     0.057    -0.692     0.200
     0.117    -0.509     0.200
     0.117    -0.499     0.200
     0.156     0.282     0.200
     0.173     0.270     0.200
     0.232     0.029     0.200
     0.234    -0.094     0.200
     0.275     0.018     0.200
     0.316    -0.165     0.200
     0.324    -0.051     0.200
     0.337     0.725     0.200
     0.394     0.191     0.200
     0.394     0.111     0.200
     0.433     0.786     0.200
     0.433     0.826     0.200
     0.456     0.916     0.200
     0.465     0.184     0.200
     0.454     0.069     0.200
     0.476    -0.125     0.200
     0.482     0.443     0.200
     0.480     0.433     0.200
     0.562     0.266     0.200
     0.562     0.516     0.200
     0.580    -0.540     0.200
     0.564     0.713     0.200
     0.604    -0.020     0.200
     0.604     0.180     0.200
     0.604    -0.454     0.200
     0.625    -0.369     0.200
     0.625    -0.228     0.200
     0.613     0.593     0.200
     0.613     0.610     0.200
     0.692    -0.258     0.200
     0.715    -0.569     0.200
     0.715    -0.808     0.200
     0.730    -0.297     0.200
     0.730    -1.325     0.200
     0.730    -0.715     0.200
     0.735    -0.846     0.200
     0.741     0.466     0.200
     0.723     0.644     0.200
     0.767    -0.437     0.200
     0.779    -0.482     0.200
     0.774     0.031     0.200
     0.766    -1.167     0.200
     0.819    -0.312     0.200
     0.838    -0.490     0.200
     0.861    -0.484     0.200
     0.947    -0.551     0.200
     0.947    -0.507     0.200
     0.982     0.334     0.200
     0.024     0.301     0.200
     0.108    -0.412     0.200
     0.082    -0.091     0.200
     0.144     0.225     0.200
     0.217    -0.063     0.200
     0.240     0.121     0.200
     0.258     0.276     0.200
     0.312     0.622     0.200
     0.336     0.027     0.200
     0.308     0.611     0.200
     0.344    -0.045     0.200
     0.401     0.160     0.200
     0.401     0.181     0.200
     0.436     0.038     0.200
     0.461     0.629     0.200
     0.461     0.769     0.200
     0.481     0.126     0.200
     0.486     0.666     0.200
     0.509     0.235     0.200
     0.510     0.501     0.200
     0.505    -0.111     0.200
     0.583    -0.578     0.200
     0.591     0.268     0.200
     0.591     0.258     0.200
     0.617    -0.535     0.200
     0.583     0.432     0.200
     0.564     1.000     0.200
     0.634    -0.108     0.200
     0.652    -0.070     0.200
     0.720    -0.380     0.200
     0.720    -0.450     0.200
     0.739    -0.848     0.200
     0.751    -0.549     0.200
     0.744    -0.919     0.200
     0.744    -0.919     0.200
     0.761    -0.873     0.200
     0.769     0.027     0.200
     0.801    -0.209     0.200
     0.848    -0.503     0.200
     0.923    -0.116     0.200
     0.923    -0.436     0.200
     0.010    -0.782     0.200
     0.010     0.241     0.200
     0.085    -0.810     0.200
     0.097    -0.276     0.200
     0.137     0.044     0.200
     0.196    -0.262     0.200
     0.222    -0.037     0.200
     0.275     0.240     0.200
     0.304     0.625     0.200
     0.315     0.562     0.200
     0.357    -0.130     0.200
     0.416     0.231     0.200
     0.467     0.168     0.200
     0.459     0.768     0.200
     0.506     0.266     0.200
     0.515    -0.141     0.200
     0.579     0.586     0.200
     0.590     0.205     0.200
     0.587     0.879     0.200
     0.639    -0.199     0.200
     0.665    -0.231     0.200
     0.717    -0.439     0.200
     0.932    -0.531     0.200
     0.932    -0.671     0.200
     0.147    -0.289     0.200
     0.148    -0.312     0.200
     0.201     0.213     0.200
     0.271     0.596     0.200
     0.288     0.470     0.200
     0.288     0.478     0.200
     0.290    -0.108     0.200
     0.389     0.769     0.200
     0.390     0.731     0.200
     0.340     0.447     0.200
     0.391     0.291     0.200
     0.403     0.253     0.200
     0.451    -0.006     0.200
     0.513     0.388     0.200
     0.564     0.114     0.200
     0.569    -0.122     0.200
     0.569     0.245     0.200
     0.607     0.135     0.200
     0.644     0.535     0.200
     0.644     0.542     0.200
     0.614    -0.179     0.200
     0.623     0.045     0.200
     0.623     0.301     0.200
     0.623     0.269     0.200
     0.655    -1.008     0.200
     0.701     0.037     0.200
     0.735    -0.637     0.200
     0.735    -0.657     0.200
     0.755    -0.953     0.200
     0.753    -0.161     0.200
     0.764    -0.938     0.200
     0.765    -0.383     0.200
     0.774     0.189     0.200
     0.869    -0.306     0.200
     0.894     0.263     0.200
     0.897    -0.554     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.777    -0.833     0.200
     0.765     0.322     0.200
     0.755     0.213     0.200
     0.987    -0.730     0.200
     0.987    -0.629     0.200
     0.990    -0.940     0.200
     0.990    -1.167     0.200
     0.999    -0.727     0.200
     0.444    -0.784     0.200
     0.531    -0.691     0.200
     0.697    -0.244     0.200
     0.744     0.316     0.200
     0.732    -0.794     0.200
     0.739    -0.863     0.200
     0.721    -0.852     0.200
     0.744    -0.812     0.200
     0.705    -0.494     0.200
     0.935    -1.241     0.200
     0.795    -0.985     0.200
     0.795    -1.470     0.200
     0.965    -0.924     0.200
     0.773    -0.998     0.200
     0.960    -0.924     0.200
     0.998    -0.760     0.200
     0.828    -0.984     0.200
     0.924    -0.416     0.200
     0.976    -0.705     0.200
     0.932    -1.186     0.200
     0.932    -0.881     0.200
     0.956    -0.694     0.200
     0.530    -0.942     0.200
     0.522    -0.986     0.200
     0.564    -0.847     0.200
     0.624    -0.975     0.200
     0.588    -0.534     0.200
     0.641    -0.737     0.200
     0.882    -0.543     0.200
     0.882    -1.074     0.200
     0.871    -1.193     0.200
     0.975    -0.974     0.200
     0.895    -0.900     0.200
     0.927    -1.087     0.200
     0.498     0.241     0.200
     0.592    -0.811     0.200
     0.616    -0.366     0.200
     0.627    -0.354     0.200
     0.671    -0.220     0.200
     0.859    -0.846     0.200
     0.930    -0.954     0.200
     0.911    -0.670     0.200
     0.911    -0.984     0.200
     0.906    -0.791     0.200
     0.945    -1.041     0.200
     0.945    -1.221     0.200
     0.962    -1.211     0.200
     0.940    -1.053     0.200
     0.965    -0.619     0.200
     0.965    -0.746     0.200
     0.448    -0.498     0.200
     0.715     0.350     0.200
     0.626     0.227     0.200
     0.804    -1.088     0.200
     0.854    -0.824     0.200
     0.891    -0.588     0.200
     0.952    -0.718     0.200
     0.947    -0.761     0.200
     0.883    -0.740     0.200
     0.883    -1.166     0.200
     0.588     0.183     0.200
     0.854    -0.927     0.200
     0.955    -0.946     0.200
     0.903    -1.056     0.200
     0.903    -1.157     0.200
     0.876    -0.841     0.200
     0.931    -0.979     0.200
     0.931    -0.877     0.200
     0.931    -0.651     0.200
     0.970    -0.609     0.200
     0.884    -0.593     0.200
     0.877    -0.754     0.200
     0.936    -1.015     0.200
     0.936    -0.843     0.200
     0.982    -0.891     0.200
     0.911    -0.980     0.200
     0.953    -0.449     0.200
     0.805     0.038     0.200
     0.975    -1.073     0.200
     0.731    -0.590     0.200
     0.936    -0.852     0.200
     0.936    -0.715     0.200
     0.562    -0.913     0.200
     0.873    -0.939     0.200
     0.873    -1.146     0.200
     0.910    -0.758     0.200
     0.910    -0.867     0.200
     0.805    -0.508     0.200
     0.809    -0.826     0.200
     0.896    -1.056     0.200
     0.955    -0.819     0.200
     0.949    -0.770     0.200
     0.933    -0.693     0.200
     0.923    -1.091     0.200
     0.983    -0.911     0.200
     0.963    -0.861     0.200
     0.981    -0.765     0.200
     0.892    -0.437     0.200
     0.608     0.244     0.200
     0.984    -0.789     0.200
     0.918    -1.104     0.200
     0.918    -0.948     0.200
     0.983    -0.756     0.200
     0.983    -0.404     0.200
     0.982    -0.566     0.200
     0.886    -1.129     0.200
     0.941    -1.426     0.200
     0.941    -0.641     0.200
     0.907    -0.849     0.200
     0.933    -1.058     0.200
     0.914    -0.744     0.200
     0.940    -0.768     0.200
     0.940    -1.245     0.200
     0.933    -1.040     0.200
     0.933    -0.604     0.200
     0.939    -1.077     0.200
     0.939    -0.960     0.200
     0.931    -1.037     0.200
     0.973    -0.930     0.200
     0.909    -0.576     0.200
     0.853     0.308     0.200
     0.972    -0.974     0.200
     0.998    -0.929     0.200
     0.950    -0.744     0.200
     0.979    -0.988     0.200
     0.989    -1.134     0.200
     0.989    -0.966     0.200
     0.625     0.014     0.200
     0.733    -1.025     0.200
     0.713    -0.443     0.200
     0.781    -0.888     0.200
     0.761     0.792     0.200
     0.805    -0.195     0.200
     0.948     0.278     0.200
     0.993    -0.765     0.200
     0.874    -0.790     0.200
     0.944    -1.068     0.200
     0.991    -0.648     0.200
     0.938    -0.961     0.200
     0.938    -0.744     0.200
     0.998    -1.098     0.200
     0.982    -1.040     0.200
     0.955    -1.206     0.200
     0.955    -1.105     0.200
     0.898    -1.098     0.200
     0.970    -1.144     0.200
     0.970    -1.040     0.200
     0.953    -1.092     0.200
     0.991    -1.144     0.200
     0.991    -0.629     0.200
     0.932    -1.206     0.200
     0.950    -1.070     0.200
     0.946    -1.298     0.200
     0.946    -0.964     0.200
     0.931    -1.000     0.200
     0.979    -1.123     0.200
     0.979    -0.842     0.200
     0.943    -1.002     0.200
     0.989    -1.035     0.200
     0.989    -0.918     0.200
     0.868    -1.096     0.200
     0.955    -0.902     0.200
     0.986    -0.950     0.200
     0.881    -0.551     0.200
     0.947    -1.111     0.200
     0.898    -0.922     0.200
     0.950    -1.033     0.200
     0.922    -0.803     0.200
     0.962    -1.362     0.200
     0.839    -1.653     0.200
     0.810    -0.567     0.200
     0.870    -1.515     0.200
     0.910    -0.989     0.200
     0.815    -0.645     0.200
     0.910    -0.637     0.200
     0.858    -1.544     0.200
     0.911    -0.484     0.200
     0.850    -0.915     0.200
     0.854    -0.579     0.200
     0.858    -0.732     0.200
     0.891    -1.074     0.200
     0.987    -0.933     0.200
     0.972    -0.378     0.200
     0.988    -0.825     0.200
     0.783    -0.874     0.200
     0.786    -0.535     0.200
     0.841    -0.722     0.200
     0.885    -0.744     0.200
     0.934    -0.751     0.200
     0.963    -1.077     0.200
     0.979    -0.357     0.200
     0.995     1.449     0.200
     0.753    -0.893     0.200
     0.855    -0.835     0.200
     0.878    -1.492     0.200
     0.797    -0.849     0.200
     0.879    -0.610     0.200
     0.898    -0.531     0.200
     0.678    -0.883     0.200
     0.734    -0.491     0.200
     0.889    -0.588     0.200
     0.902    -0.526     0.200
     0.954    -0.493     0.200
     0.958    -0.796     0.200
     0.970    -0.797     0.200
     0.854    -0.803     0.200
     0.860    -1.018     0.200
     0.864    -1.817     0.200
     0.896    -1.111     0.200
     0.896    -0.591     0.200
     0.939    -1.150     0.200
     0.984    -0.548     0.200
     0.894    -0.877     0.200
     0.908    -0.727     0.200
     0.939    -0.483     0.200
     0.918    -0.559     0.200
     0.944    -1.109     0.200
     0.976    -0.726     0.200
     0.938    -4.750     0.200
     0.922    -1.188     0.200
     0.998     0.824     0.200
     0.866    -1.022     0.200
     0.872    -1.784     0.200
     0.941    -0.755     0.200
     0.835    -0.731     0.200
     0.868    -0.794     0.200
     0.911    -0.582     0.200
     0.950    -0.698     0.200
     0.970    -0.506     0.200
     0.842    -1.017     0.200
     0.930    -0.879     0.200
     0.937    -0.521     0.200
     0.974    -1.056     0.200
     0.926    -1.075     0.200
     0.933    -1.204     0.200
     0.950    -1.314     0.200
     0.942    -1.057     0.200
     0.942    -0.858     0.200
     0.994    -0.735     0.200
     0.995    -0.687     0.200
     0.986    -1.079     0.200
     0.773    -0.292     0.200
     0.848    -0.745     0.200
     0.983    -0.219     0.200
     0.850    -0.674     0.200
     0.837    -1.001     0.200
     0.809    -0.866     0.200
     0.737    -0.858     0.200
     0.826    -0.788     0.200
     0.954    -0.996     0.200
     0.957    -0.581     0.200
     0.922    -0.970     0.200
     0.875    -0.633     0.200
     0.922    -0.648     0.200
     0.965     0.212     0.200
     0.822    -0.664     0.200
     0.851    -1.068     0.200
     0.863    -0.761     0.200
     0.861    -0.827     0.200
     0.934    -0.420     0.200
     0.945    -0.315     0.200
     0.995    -0.319     0.200
     0.995    -0.329     0.200
     0.753    -0.927     0.200
     0.824    -0.787     0.200
     0.852    -0.996     0.200
     0.888    -0.624     0.200
     0.864    -0.613     0.200
     0.862    -0.686     0.200
     0.937    -1.007     0.200
     0.947    -1.085     0.200
     0.969    -0.970     0.200
     0.994    -1.745     0.200
     0.836    -0.619     0.200
     0.843    -0.763     0.200
     0.921    -0.554     0.200
     0.986    -0.766     0.200
     0.983    -1.361     0.200
     0.985    -0.846     0.200
     0.914    -0.697     0.200
     0.985    -1.067     0.200
     0.794    -0.602     0.200
     0.809    -0.623     0.200
     0.858    -0.411     0.200
     0.865    -0.547     0.200
     0.890    -0.387     0.200
     0.720    -0.925     0.200
     0.720    -0.738     0.200
     0.730    -0.541     0.200
     0.748    -0.904     0.200
     0.776    -0.857     0.200
     0.817    -0.456     0.200
     0.811    -0.618     0.200
     0.841    -0.477     0.200
     0.896    -0.954     0.200
     0.896    -1.063     0.200
     0.926    -0.874     0.200
     0.985     0.787     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.103     0.754     0.200
     0.720    -0.398     0.200
     0.777    -0.931     0.200
     0.758     0.066     0.200
     0.740    -1.508     0.200
     0.052    -0.002     0.200
     0.086    -0.001     0.200
     0.333    -0.703     0.200
     0.378    -1.051     0.200
     0.639    -0.047     0.200
     0.681    -0.006     0.200
     0.914    -1.549     0.200
     0.954    -0.054     0.200
     0.973     0.245     0.200
     0.203    -1.156     0.200
     0.179     0.528     0.200
     0.216     0.747     0.200
     0.396    -0.341     0.200
     0.674     0.105     0.200
     0.762    -0.006     0.200
     0.912    -1.217     0.200
     0.912    -1.624     0.200
     0.867    -0.494     0.200
     0.990    -1.118     0.200
     0.990    -1.711     0.200
     0.080     0.195     0.200
     0.535    -0.841     0.200
     0.535    -0.583     0.200
     0.640    -0.159     0.200
     0.749    -0.180     0.200
     0.950     0.030     0.200
     0.625    -0.534     0.200
     0.641    -0.671     0.200
     0.725    -1.239     0.200
     0.725    -1.001     0.200
     0.024     0.053     0.200
     0.075     0.740     0.200
     0.625    -0.515     0.200
     0.650    -0.484     0.200
     0.733    -1.266     0.200
     0.991     0.796     0.200
     0.046    -0.167     0.200
     0.627    -0.481     0.200
     0.726    -1.287     0.200
     0.642    -0.539     0.200
     0.636    -0.268     0.200
     0.683     0.005     0.200
     0.740    -1.296     0.200
     0.999     0.206     0.200
     0.045    -0.222     0.200
     0.635    -0.396     0.200
     0.628    -0.163     0.200
     0.726    -1.153     0.200
     0.045    -1.408     0.200
     0.473     0.471     0.200
     0.627    -0.692     0.200
     0.641    -0.330     0.200
     0.732    -1.370     0.200
     0.031    -0.825     0.200
     0.031    -0.675     0.200
     0.643    -0.709     0.200
     0.626    -0.971     0.200
     0.728    -1.191     0.200
     0.998     0.805     0.200
     0.031    -1.454     0.200
     0.632    -0.238     0.200
     0.642    -0.673     0.200
     0.659     0.247     0.200
     0.692    -0.057     0.200
     0.734    -1.561     0.200
     0.997     1.008     0.200
     0.626    -0.968     0.200
     0.643    -0.666     0.200
     0.677    -0.739     0.200
     0.736     0.448     0.200
     0.729     1.367     0.200
     0.018    -0.197     0.200
     0.018     0.303     0.200
     0.678    -0.324     0.200
     0.635    -0.195     0.200
     0.767    -1.322     0.200
     0.580    -0.687     0.200
     0.744    -0.791     0.200
     0.769    -0.143     0.200
     0.752     1.477     0.200
     0.934     0.370     0.200
     0.198    -1.630     0.200
     0.248     0.436     0.200
     0.060    -1.365     0.200
     0.601    -0.405     0.200
     0.774    -1.074     0.200
     0.139     1.022     0.200
     0.652    -0.792     0.200
     0.965    -0.442     0.200
     0.481    -0.315     0.200
     0.987    -0.568     0.200
     0.997    -0.219     0.200
     0.799    -1.671     0.200
     0.799    -1.207     0.200
     0.265     0.503     0.200
     0.632    -1.027     0.200
     0.082     1.105     0.200
     0.086     1.059     0.200
     0.119     1.291     0.200
     0.499    -0.350     0.200
     0.779    -1.550     0.200
     0.090    -0.040     0.200
     0.135     1.214     0.200
     0.084     1.006     0.200
     0.502     0.283     0.200
     0.793    -1.449     0.200
     0.793    -1.141     0.200
     0.223    -0.222     0.200
     0.226    -0.378     0.200
     0.371    -0.369     0.200
     0.371     0.108     0.200
     0.384    -0.430     0.200
     0.381     1.334     0.200
     0.692    -0.742     0.200
     0.692    -0.726     0.200
     0.788    -1.026     0.200
     0.778    -0.672     0.200
     0.253    -0.862     0.200
     0.537    -0.677     0.200
     0.536    -0.661     0.200
     0.523     1.030     0.200
     0.709    -0.560     0.200
     0.799    -0.520     0.200
     0.918    -1.223     0.200
     0.149     0.843     0.200
     0.702    -1.376     0.200
     0.832     0.494     0.200
     0.828    -0.462     0.200
     0.861    -0.184     0.200
     0.924    -0.735     0.200
     0.084     0.236     0.200
     0.035     0.021     0.200
     0.688    -1.580     0.200
     0.784    -0.929     0.200
     0.806    -0.065     0.200
     0.806     0.552     0.200
     0.101     1.033     0.200
     0.430     0.193     0.200
     0.494     0.113     0.200
     0.528    -0.152     0.200
     0.022     0.554     0.200
     0.101    -0.020     0.200
     0.416    -0.571     0.200
     0.731    -1.864     0.200
     0.784     0.842     0.200
     0.919    -0.629     0.200
     0.128    -0.790     0.200
     0.142    -0.389     0.200
     0.658     0.566     0.200
     0.734    -0.049     0.200
     0.856    -1.228     0.200
     0.129    -0.185     0.200
     0.658     0.267     0.200
     0.856    -1.812     0.200
     0.073    -1.216     0.200
     0.784    -1.425     0.200
     0.144    -0.195     0.200
     0.160     0.133     0.200
     0.289     0.898     0.200
     0.791    -1.488     0.200
     0.873    -1.031     0.200
     0.162    -0.240     0.200
     0.876    -1.418     0.200
     0.230     1.028     0.200
     0.190     1.266     0.200
     0.928    -0.605     0.200
     0.218    -0.509     0.200
     0.202    -0.874     0.200
     0.312     0.357     0.200
     0.312    -0.944     0.200
     0.361    -0.351     0.200
     0.654    -1.321     0.200
     0.936     0.570     0.200
     0.968    -0.729     0.200
     0.185    -1.152     0.200
     0.488     0.922     0.200
     0.964     1.039     0.200
     0.964     0.229     0.200
     0.888    -0.444     0.200
     0.226    -2.217     0.200
     0.720    -0.344     0.200
     0.148    -0.919     0.200
     0.272    -1.183     0.200
     0.927    -1.053     0.200
     0.366    -0.930     0.200
     0.646    -1.214     0.200
     0.784    -0.889     0.200
     0.816    -1.554     0.200
     0.909    -1.590     0.200
     0.473    -1.100     0.200
     0.601    -1.447     0.200
     0.778    -0.829     0.200
     0.876    -1.498     0.200
     0.893    -0.234     0.200
     0.893    -0.074     0.200
     0.602    -1.063     0.200
     0.752    -0.805     0.200
     0.781    -0.551     0.200
     0.913    -1.620     0.200
     0.930    -1.082     0.200
     0.969    -0.474     0.200
     0.320    -1.069     0.200
     0.600    -0.996     0.200
     0.751    -0.643     0.200
     0.321    -0.260     0.200
     0.871    -1.586     0.200
     0.567    -0.598     0.200
     0.733    -0.927     0.200
     0.809    -0.314     0.200
     0.313    -0.995     0.200
     0.449     1.364     0.200
     0.606    -0.863     0.200
     0.761    -0.927     0.200
     0.898    -1.133     0.200
     0.194    -1.094     0.200
     0.237     0.255     0.200
     0.624     0.253     0.200
     0.732    -1.187     0.200
     0.945    -1.051     0.200
     0.156    -1.324     0.200
     0.683    -1.172     0.200
     0.656     0.781     0.200
     0.134    -0.787     0.200
     0.984     0.044     0.200
     0.127    -0.430     0.200
     0.315    -1.186     0.200
     0.629     0.321     0.200
     0.758    -1.203     0.200
     0.855    -1.214     0.200
     0.870    -1.298     0.200
     0.273    -0.231     0.200
     0.353    -0.552     0.200
     0.636    -0.932     0.200
     0.681     0.229     0.200
     0.778    -0.787     0.200
     0.817    -1.059     0.200
     0.906    -1.420     0.200
     0.249     0.156     0.200
     0.299    -0.991     0.200
     0.588    -0.727     0.200
     0.727    -0.203     0.200
     0.802    -0.544     0.200
     0.905    -1.451     0.200
     0.220    -0.854     0.200
     0.216     0.353     0.200
     0.604     0.550     0.200
     0.759    -1.001     0.200
     0.765    -0.562     0.200
     0.850    -1.246     0.200
     0.155     0.529     0.200
     0.293     0.082     0.200
     0.344    -1.032     0.200
     0.649    -0.992     0.200
     0.798    -0.855     0.200
     0.882    -1.424     0.200
     0.882    -1.674     0.200
     0.181     0.353     0.200
     0.261    -0.853     0.200
     0.261    -0.739     0.200
     0.486    -0.604     0.200
     0.656    -0.783     0.200
     0.896    -1.491     0.200
     0.116    -0.729     0.200
     0.530    -0.438     0.200
     0.165     1.809     0.200
     0.193     0.050     0.200
     0.210     0.466     0.200
     0.218    -0.482     0.200
     0.294     1.069     0.200
     0.363     1.332     0.200
     0.454     0.892     0.200
     0.610     0.632     0.200
     0.210    -0.992     0.200
     0.209    -0.706     0.200
     0.223     0.943     0.200
     0.286    -1.075     0.200
     0.274    -0.460     0.200
     0.455     0.372     0.200
     0.538    -0.155     0.200
     0.604    -0.936     0.200
     0.769    -0.848     0.200
     0.270    -0.238     0.200
     0.352    -0.727     0.200
     0.422     0.808     0.200
     0.633    -1.035     0.200
     0.746    -0.515     0.200
     0.776    -0.966     0.200
     0.205     0.261     0.200
     0.205    -1.809     0.200
     0.207    -1.467     0.200
     0.227    -1.668     0.200
     0.765    -1.354     0.200
     0.850    -1.333     0.200
     0.134     0.194     0.200
     0.134     0.754     0.200
     0.188    -0.368     0.200
     0.332     0.166     0.200
     0.604     0.396     0.200
     0.663    -0.195     0.200
     0.734    -0.783     0.200
     0.872     0.024     0.200
     0.213    -0.277     0.200
     0.240    -1.481     0.200
     0.854    -0.615     0.200
     0.955    -1.243     0.200
     0.157    -0.785     0.200
     0.304     0.245     0.200
     0.762    -0.764     0.200
     0.220    -1.633     0.200
     0.226    -0.487     0.200
     0.206    -0.277     0.200
     0.635     0.300     0.200
     0.876    -0.474     0.200
     0.271    -0.453     0.200
     0.298    -0.939     0.200
     0.533     0.342     0.200
     0.607    -0.770     0.200
     0.734    -0.101     0.200
     0.769    -0.557     0.200
     0.832    -0.131     0.200
     0.832    -0.241     0.200
     0.125    -0.026     0.200
     0.160    -0.328     0.200
     0.315     0.011     0.200
     0.633     0.423     0.200
     0.701    -0.499     0.200
     0.759    -1.137     0.200
     0.867    -1.110     0.200
     0.272     0.375     0.200
     0.450     0.391     0.200
     0.607    -0.847     0.200
     0.736    -0.343     0.200
     0.769    -0.798     0.200
     0.793    -0.480     0.200
     0.834    -0.791     0.200
     0.144     0.080     0.200
     0.288    -0.764     0.200
     0.846    -0.400     0.200
     0.145    -0.217     0.200
     0.415    -0.512     0.200
     0.573    -0.483     0.200
     0.153    -0.666     0.200
     0.399     0.144     0.200
     0.590    -0.489     0.200
     0.998    -0.210     0.200
     0.158    -0.824     0.200
     0.406     0.367     0.200
     0.406     1.457     0.200
     0.586    -0.458     0.200
     0.142    -0.405     0.200
     0.305     0.686     0.200
     0.884    -0.656     0.200
     0.152    -0.140     0.200
     0.188    -0.560     0.200
     0.607     1.094     0.200
     0.700    -0.382     0.200
     0.739    -0.298     0.200
     0.895    -0.974     0.200
     0.146     0.251     0.200
     0.302     0.747     0.200
     0.338    -0.804     0.200
     0.702     0.397     0.200
     0.933     0.352     0.200
     0.210    -0.134     0.200
     0.210    -0.036     0.200
     0.534    -0.858     0.200
     0.522    -0.164     0.200
     0.699    -0.553     0.200
     0.780    -0.706     0.200
     0.851    -0.827     0.200
     0.279     0.315     0.200
     0.369     0.110     0.200
     0.401     0.183     0.200
     0.432    -0.693     0.200
     0.784    -1.160     0.200
     0.898    -0.212     0.200
     0.898     0.006     0.200
     0.247    -0.211     0.200
     0.256    -0.250     0.200
     0.299    -0.988     0.200
     0.469     1.371     0.200
     0.554    -0.003     0.200
     0.587    -1.062     0.200
     0.727     0.029     0.200
     0.252    -0.223     0.200
     0.299    -0.917     0.200
     0.557    -0.335     0.200
     0.583    -0.994     0.200
     0.122    -0.391     0.200
     0.122     0.007     0.200
     0.155    -0.190     0.200
     0.638     0.337     0.200
     0.704    -0.184     0.200
     0.220    -0.534     0.200
     0.217     0.071     0.200
     0.280    -0.839     0.200
     0.546    -0.819     0.200
     0.709    -0.646     0.200
     0.929    -0.839     0.200
     0.161     0.380     0.200
     0.234    -0.734     0.200
     0.568     0.818     0.200
     0.600    -0.862     0.200
     0.600    -0.722     0.200
     0.910    -1.521     0.200
     0.903    -2.190     0.200
     0.182    -1.070     0.200
     0.782    -0.537     0.200
     0.805    -0.686     0.200
     0.805    -0.584     0.200
     0.440     0.362     0.200
     0.553     0.406     0.200
     0.140     0.475     0.200
     0.192     0.274     0.200
     0.564     0.813     0.200
     0.666    -0.552     0.200
     0.764    -0.676     0.200
     0.138     0.519     0.200
     0.196     0.283     0.200
     0.273    -0.991     0.200
     0.517    -0.748     0.200
     0.682    -0.842     0.200
     0.682    -0.602     0.200
     0.253     0.042     0.200
     0.247     0.260     0.200
     0.477     1.411     0.200
     0.561     0.697     0.200
     0.579    -0.877     0.200
     0.742    -1.034     0.200
     0.903    -1.272     0.200
     0.234     0.290     0.200
     0.478    -0.316     0.200
     0.563     0.544     0.200
     0.577    -0.882     0.200
     0.919    -1.433     0.200
     0.133     0.191     0.200
     0.228    -0.083     0.200
     0.569    -0.878     0.200
     0.572    -0.226     0.200
     0.725    -0.933     0.200
     0.723    -0.095     0.200
     0.134     0.109     0.200
     0.198    -0.214     0.200
     0.200     0.071     0.200
     0.685    -0.869     0.200
     0.230    -0.699     0.200
     0.233    -0.464     0.200
     0.622     0.945     0.200
     0.622     0.705     0.200
     0.737    -0.781     0.200
     0.797    -0.745     0.200
     0.230    -0.665     0.200
     0.233    -0.396     0.200
     0.736    -0.639     0.200
     0.144    -0.027     0.200
     0.228    -0.129     0.200
     0.228    -0.358     0.200
     0.218    -0.284     0.200
     0.565    -0.808     0.200
     0.717    -0.876     0.200
     0.717    -0.686     0.200
     0.780    -0.401     0.200
     0.948    -0.671     0.200
     0.151     0.334     0.200
     0.194    -0.424     0.200
     0.299    -0.933     0.200
     0.519     0.799     0.200
     0.690    -0.874     0.200
     0.761    -1.452     0.200
     0.126    -0.147     0.200
     0.139    -0.029     0.200
     0.195     0.548     0.200
     0.286    -1.059     0.200
     0.605    -1.170     0.200
     0.612    -0.422     0.200
     0.171     0.033     0.200
     0.278    -0.133     0.200
     0.298    -0.202     0.200
     0.359    -1.133     0.200
     0.414     0.835     0.200
     0.500     0.531     0.200
     0.678     0.121     0.200
     0.783    -0.948     0.200
     0.819    -0.303     0.200
     0.162     0.388     0.200
     0.267     0.170     0.200
     0.286    -0.155     0.200
     0.347    -0.948     0.200
     0.686     0.352     0.200
     0.772    -0.754     0.200
     0.814    -0.065     0.200
     0.907    -1.642     0.200
     0.276     0.090     0.200
     0.297    -0.165     0.200
     0.415     1.497     0.200
     0.782    -1.075     0.200
     0.138     0.130     0.200
     0.218    -0.233     0.200
     0.226    -0.296     0.200
     0.299    -0.941     0.200
     0.496    -0.228     0.200
     0.559    -0.857     0.200
     0.715    -0.802     0.200
     0.722    -0.601     0.200
     0.933    -0.755     0.200
     0.946    -0.904     0.200
     0.196     0.056     0.200
     0.563    -0.562     0.200
     0.611     0.346     0.200
     0.779    -0.976     0.200
     0.832    -1.129     0.200
     0.923    -1.040     0.200
     0.308     0.140     0.200
     0.881    -0.185     0.200
     0.924    -0.555     0.200
     0.168     0.593     0.200
     0.164    -0.007     0.200
     0.164     0.142     0.200
     0.279    -0.865     0.200
     0.483    -0.737     0.200
     0.645    -0.993     0.200
     0.737    -0.925     0.200
     0.737    -0.117     0.200
     0.392     0.553     0.200
     0.594     0.043     0.200
     0.988     0.071     0.200
     0.144    -0.310     0.200
     0.693    -0.477     0.200
     0.729    -0.449     0.200
     0.847    -1.223     0.200
     0.847    -1.348     0.200
     0.876    -0.648     0.200
     0.019     0.283     0.200
     0.087    -0.078     0.200
     0.734    -1.273     0.200
     0.734    -1.444     0.200
     0.924    -0.491     0.200
     0.200    -0.656     0.200
     0.743    -0.256     0.200
     0.174     0.456     0.200
     0.286    -1.227     0.200
     0.482    -1.036     0.200
     0.641    -0.666     0.200
     0.730    -0.701     0.200
     0.193     0.553     0.200
     0.288    -0.902     0.200
     0.455    -0.552     0.200
     0.615    -0.432     0.200
     0.601     0.812     0.200
     0.752    -0.282     0.200
     0.844    -0.852     0.200
     0.126     0.099     0.200
     0.283    -0.767     0.200
     0.448    -0.587     0.200
     0.611    -0.619     0.200
     0.693    -0.498     0.200
     0.712    -0.513     0.200
     0.712     0.125     0.200
     0.840    -1.195     0.200
     0.174     0.397     0.200
     0.161    -0.221     0.200
     0.162    -0.275     0.200
     0.162     0.212     0.200
     0.297    -0.919     0.200
     0.558     0.166     0.200
     0.497    -0.876     0.200
     0.651    -0.730     0.200
     0.730    -0.452     0.200
     0.732    -0.625     0.200
     0.732    -0.235     0.200
     0.143     0.310     0.200
     0.194     0.803     0.200
     0.279    -0.642     0.200
     0.445    -0.671     0.200
     0.610    -0.805     0.200
     0.714     0.004     0.200
     0.152     0.227     0.200
     0.247    -0.079     0.200
     0.263    -0.273     0.200
     0.331    -0.792     0.200
     0.451     0.963     0.200
     0.604    -0.942     0.200
     0.751    -0.706     0.200
     0.751    -0.876     0.200
     0.175     1.067     0.200
     0.175    -0.461     0.200
     0.203    -0.333     0.200
     0.599     0.651     0.200
     0.717    -0.359     0.200
     0.797    -0.674     0.200
     0.153    -0.408     0.200
     0.691    -0.590     0.200
     0.731    -0.377     0.200
     0.767    -0.503     0.200
     0.394     1.136     0.200
     0.596     0.615     0.200
     0.994     0.088     0.200
     0.295    -0.944     0.200
     0.323    -0.386     0.200
     0.905    -1.102     0.200
     0.982    -1.005     0.200
     0.230     1.086     0.200
     0.237     0.349     0.200
     0.169    -0.625     0.200
     0.196    -0.610     0.200
     0.813     0.333     0.200
     0.350    -1.279     0.200
     0.387    -1.112     0.200
     0.591     0.974     0.200
     0.973    -0.648     0.200
     0.219    -0.706     0.200
     0.216     0.221     0.200
     0.216    -1.069     0.200
     0.616     0.370     0.200
     0.776    -1.015     0.200
     0.185    -0.622     0.200
     0.185    -0.474     0.200
     0.214    -0.091     0.200
     0.214    -0.380     0.200
     0.265    -0.793     0.200
     0.361    -0.657     0.200
     0.597    -0.673     0.200
     0.807    -1.073     0.200
     0.914    -0.821     0.200
     0.929     0.471     0.200
     0.275    -0.914     0.200
     0.295    -0.336     0.200
     0.417     0.816     0.200
     0.639    -1.048     0.200
     0.781    -0.795     0.200
     0.795    -0.746     0.200
     0.229    -0.550     0.200
     0.228    -0.643     0.200
     0.792    -1.256     0.200
     0.218    -0.516     0.200
     0.495     0.118     0.200
     0.561    -1.042     0.200
     0.198     0.521     0.200
     0.198    -0.450     0.200
     0.739    -0.919     0.200
     0.780    -0.497     0.200
     0.780    -0.259     0.200
     0.824    -1.169     0.200
     0.931    -1.347     0.200
     0.152    -0.036     0.200
     0.355    -1.149     0.200
     0.507    -1.016     0.200
     0.655    -0.412     0.200
     0.646    -0.719     0.200
     0.218    -0.894     0.200
     0.225    -0.867     0.200
     0.771    -1.012     0.200
     0.378    -0.710     0.200
     0.418     0.631     0.200
     0.532     0.038     0.200
     0.268    -0.974     0.200
     0.282    -0.029     0.200
     0.282     0.096     0.200
     0.888    -0.444     0.200
     0.032     1.244     0.200
     0.105     0.090     0.200
     0.105    -0.271     0.200
     0.740    -1.309     0.200
     0.909    -0.998     0.200
     0.076    -0.701     0.200
     0.763    -1.669     0.200
     0.781    -0.538     0.200
     0.907    -0.342     0.200
     0.140     0.254     0.200
     0.301    -0.490     0.200
     0.316    -0.135     0.200
     0.406     1.205     0.200
     0.490    -1.429     0.200
     0.650    -0.868     0.200
     0.868    -1.630     0.200
     0.868    -1.213     0.200
     0.300    -0.762     0.200
     0.320    -0.269     0.200
     0.320     0.640     0.200
     0.883    -0.752     0.200
     0.931    -0.502     0.200
     0.972    -0.164     0.200
     0.279    -1.237     0.200
     0.297    -0.706     0.200
     0.866     0.042     0.200
     0.914    -0.380     0.200
     0.319    -1.669     0.200
     0.294    -0.555     0.200
     0.319    -0.090     0.200
     0.319    -0.219     0.200
     0.419     0.624     0.200
     0.637    -0.737     0.200
     0.794    -1.407     0.200
     0.849     0.066     0.200
     0.849    -0.066     0.200
     0.870    -1.218     0.200
     0.346     0.482     0.200
     0.936    -0.307     0.200
     0.983     0.008     0.200
     0.983     0.160     0.200
     0.387    -1.343     0.200
     0.387    -0.272     0.200
     0.437     0.603     0.200
     0.439     0.450     0.200
     0.485    -0.907     0.200
     0.606     0.261     0.200
     0.567    -0.920     0.200
     0.899    -0.504     0.200
     0.948    -0.936     0.200
     0.993    -0.611     0.200
     0.231    -0.009     0.200
     0.231     0.765     0.200
     0.231    -0.769     0.200
     0.839    -0.195     0.200
     0.082    -0.628     0.200
     0.081     0.132     0.200
     0.752    -0.310     0.200
     0.794    -0.881     0.200
     0.794    -0.987     0.200
     0.311     0.271     0.200
     0.335    -1.049     0.200
     0.335     0.982     0.200
     0.954    -0.658     0.200
     0.223    -0.791     0.200
     0.215    -1.026     0.200
     0.768    -0.127     0.200
     0.768    -0.747     0.200
     0.815    -0.660     0.200
     0.327    -0.361     0.200
     0.944    -0.501     0.200
     0.776     0.074     0.200
     0.823    -0.469     0.200
     0.259    -0.549     0.200
     0.259     1.500     0.200
     0.806    -1.779     0.200
     0.854    -0.487     0.200
     0.489     0.264     0.200
     0.592     0.618     0.200
     0.647    -0.968     0.200
     0.735     0.236     0.200
     0.858    -0.880     0.200
     0.843    -0.470     0.200
     0.993    -1.274     0.200
     0.992    -1.448     0.200
     0.911    -0.378     0.200
     0.644    -0.853     0.200
     0.739    -0.312     0.200
     0.854    -0.603     0.200
     0.845    -0.759     0.200
     0.823    -0.169     0.200
     0.823     0.461     0.200
     0.823    -1.250     0.200
     0.871    -1.886     0.200
     0.991    -1.102     0.200
     0.991    -1.288     0.200
     0.214    -0.086     0.200
     0.855    -1.089     0.200
     0.105    -0.191     0.200
     0.299    -1.011     0.200
     0.318    -0.811     0.200
     0.318    -0.502     0.200
     0.340    -0.187     0.200
     0.647    -0.804     0.200
     0.814    -0.890     0.200
     0.869    -0.039     0.200
     0.878    -0.237     0.200
     0.499    -0.254     0.200
     0.586    -0.219     0.200
     0.640    -0.824     0.200
     0.670     0.502     0.200
     0.852    -1.795     0.200
     0.859    -0.982     0.200
     0.985    -1.033     0.200
     0.498     0.312     0.200
     0.648    -0.949     0.200
     0.676     0.488     0.200
     0.863    -1.161     0.200
     0.817    -0.332     0.200
     0.844    -0.982     0.200
     0.867    -0.969     0.200
     0.844    -0.509     0.200
     0.993    -1.065     0.200
     0.990    -1.450     0.200
     0.220    -1.123     0.200
     0.235    -0.756     0.200
     0.218    -0.767     0.200
     0.223    -0.440     0.200
     0.755    -0.216     0.200
     0.821    -0.650     0.200
     0.856    -0.977     0.200
     0.221    -0.985     0.200
     0.231    -0.671     0.200
     0.756    -0.224     0.200
     0.764    -1.135     0.200
     0.852    -0.854     0.200
     0.216    -0.867     0.200
     0.210    -0.688     0.200
     0.762    -0.494     0.200
     0.850    -1.046     0.200
     0.284     0.763     0.200
     0.284     1.544     0.200
     0.296    -0.026     0.200
     0.899    -0.174     0.200
     0.943    -0.250     0.200
     0.129     0.135     0.200
     0.129    -0.012     0.200
     0.263    -0.963     0.200
     0.263    -1.106     0.200
     0.333    -1.040     0.200
     0.333    -0.927     0.200
     0.457    -0.512     0.200
     0.565    -0.320     0.200
     0.676    -0.886     0.200
     0.819    -1.388     0.200
     0.819    -1.403     0.200
     0.286    -1.314     0.200
     0.304     1.109     0.200
     0.869    -1.473     0.200
     0.917    -0.097     0.200
     0.917    -0.747     0.200
     0.034    -1.083     0.200
     0.072    -1.228     0.200
     0.706    -0.556     0.200
     0.762    -1.166     0.200
     0.936     0.921     0.200
     0.232    -1.099     0.200
     0.220     0.006     0.200
     0.579    -0.572     0.200
     0.761    -1.574     0.200
     0.072    -1.018     0.200
     0.053    -0.965     0.200
     0.745    -1.423     0.200
     0.765    -0.628     0.200
     0.909     1.376     0.200
     0.241     1.204     0.200
     0.250    -0.108     0.200
     0.818    -1.424     0.200
     0.898    -0.335     0.200
     0.261     0.042     0.200
     0.261     0.751     0.200
     0.268    -0.179     0.200
     0.295    -0.398     0.200
     0.340    -0.469     0.200
     0.340    -0.599     0.200
     0.467     0.201     0.200
     0.467     0.091     0.200
     0.521    -1.246     0.200
     0.521    -1.064     0.200
     0.585     0.158     0.200
     0.602    -0.294     0.200
     0.682    -1.030     0.200
     0.682    -0.851     0.200
     0.668    -0.933     0.200
     0.668    -0.763     0.200
     0.701    -1.337     0.200
     0.701    -1.207     0.200
     0.834    -1.495     0.200
     0.865    -1.677     0.200
     0.867    -1.299     0.200
     0.905    -2.250     0.200
     0.059     1.315     0.200
     0.073    -1.326     0.200
     0.073    -1.426     0.200
     0.150     0.813     0.200
     0.176     1.239     0.200
     0.303     0.862     0.200
     0.477    -0.211     0.200
     0.653    -0.671     0.200
     0.730    -0.778     0.200
     0.730    -1.471     0.200
     0.723    -1.293     0.200
     0.779    -1.017     0.200
     0.882    -0.876     0.200
     0.042    -1.018     0.200
     0.121     0.147     0.200
     0.318     1.749     0.200
     0.504    -0.542     0.200
     0.634    -0.538     0.200
     0.756    -0.810     0.200
     0.757    -1.288     0.200
     0.797    -0.116     0.200
     0.910    -0.901     0.200
     0.085    -0.864     0.200
     0.117     0.255     0.200
     0.139     1.075     0.200
     0.752    -0.851     0.200
     0.762    -1.622     0.200
     0.802     0.159     0.200
     0.802    -0.091     0.200
     0.815     0.575     0.200
     0.899     1.356     0.200
     0.910     0.618     0.200
     0.132     0.348     0.200
     0.158     0.866     0.200
     0.311     1.835     0.200
     0.641    -0.676     0.200
     0.740    -0.568     0.200
     0.740    -0.943     0.200
     0.742    -1.232     0.200
     0.782    -0.550     0.200
     0.782    -0.354     0.200
     0.162    -0.089     0.200
     0.243    -0.420     0.200
     0.243    -0.436     0.200
     0.254    -0.819     0.200
     0.254    -0.607     0.200
     0.299    -0.802     0.200
     0.313    -0.757     0.200
     0.345     0.934     0.200
     0.345     0.836     0.200
     0.382     0.302     0.200
     0.393    -1.100     0.200
     0.393    -1.000     0.200
     0.403     0.561     0.200
     0.484    -0.350     0.200
     0.472    -0.747     0.200
     0.465    -0.247     0.200
     0.470    -0.415     0.200
     0.513    -1.471     0.200
     0.578    -0.978     0.200
     0.576    -0.610     0.200
     0.603    -1.005     0.200
     0.684    -0.872     0.200
     0.684    -0.992     0.200
     0.703    -1.046     0.200
     0.700    -0.744     0.200
     0.775    -1.026     0.200
     0.820     0.083     0.200
     0.831     0.148     0.200
     0.860    -1.049     0.200
     0.844    -0.776     0.200
     0.880    -0.637     0.200
     0.905    -1.168     0.200
     0.987    -0.113     0.200
     0.111     0.385     0.200
     0.111     0.576     0.200
     0.097     0.469     0.200
     0.285     0.515     0.200
     0.291     0.930     0.200
     0.291     1.191     0.200
     0.371    -0.722     0.200
     0.371     1.292     0.200
     0.755     0.066     0.200
     0.813     1.268     0.200
     0.885    -1.140     0.200
     0.963    -0.879     0.200
     0.979    -0.372     0.200
     0.033    -0.289     0.200
     0.075    -0.158     0.200
     0.113     0.258     0.200
     0.129     1.340     0.200
     0.150     1.128     0.200
     0.227     0.332     0.200
     0.253     1.016     0.200
     0.409     0.876     0.200
     0.447     0.686     0.200
     0.753    -1.563     0.200
     0.753    -0.203     0.200
     0.793    -0.370     0.200
     0.803     0.431     0.200
     0.855    -1.061     0.200
     0.050     0.375     0.200
     0.050     0.641     0.200
     0.127    -0.123     0.200
     0.234     1.263     0.200
     0.234     0.239     0.200
     0.232    -0.738     0.200
     0.267     1.562     0.200
     0.309     0.796     0.200
     0.362     0.686     0.200
     0.767     0.497     0.200
     0.845    -0.174     0.200
     0.901     0.783     0.200
     0.890    -0.238     0.200
     0.898     0.266     0.200
     0.913     0.254     0.200
     0.102    -0.130     0.200
     0.099     0.639     0.200
     0.152     0.684     0.200
     0.177     0.355     0.200
     0.190     0.963     0.200
     0.284     0.541     0.200
     0.331    -0.222     0.200
     0.330    -0.038     0.200
     0.330     0.282     0.200
     0.469    -0.545     0.200
     0.525    -1.434     0.200
     0.530    -0.839     0.200
     0.650    -0.526     0.200
     0.734    -0.915     0.200
     0.757     0.445     0.200
     0.757     2.005     0.200
     0.774     1.223     0.200
     0.910    -0.377     0.200
     0.938    -0.938     0.200
     0.947    -0.290     0.200
     0.947    -0.691     0.200
     0.954    -0.919     0.200
     0.970    -0.394     0.200
     0.048    -0.952     0.200
     0.065    -0.774     0.200
     0.105     0.424     0.200
     0.108     1.089     0.200
     0.106     0.284     0.200
     0.160     1.449     0.200
     0.242     0.321     0.200
     0.245     0.321     0.200
     0.359     1.458     0.200
     0.489    -0.003     0.200
     0.741    -1.468     0.200
     0.854    -0.527     0.200
     0.884     0.826     0.200
     0.148     0.139     0.200
     0.210    -1.548     0.200
     0.199    -0.290     0.200
     0.216     0.712     0.200
     0.275     0.003     0.200
     0.298     1.034     0.200
     0.285     1.285     0.200
     0.285     1.555     0.200
     0.326     1.275     0.200
     0.356     1.231     0.200
     0.365     1.207     0.200
     0.386     0.620     0.200
     0.411     0.431     0.200
     0.405     1.521     0.200
     0.406     1.665     0.200
     0.436    -0.278     0.200
     0.553    -0.360     0.200
     0.542    -0.070     0.200
     0.684    -0.342     0.200
     0.763    -0.950     0.200
     0.883     1.393     0.200
     0.882     0.009     0.200
     0.961     0.933     0.200
     0.151    -0.014     0.200
     0.110    -0.152     0.200
     0.125    -0.185     0.200
     0.154     0.517     0.200
     0.191    -0.597     0.200
     0.216    -1.184     0.200
     0.224    -1.145     0.200
     0.205    -0.312     0.200
     0.227    -0.248     0.200
     0.243    -0.081     0.200
     0.289     1.166     0.200
     0.240     0.008     0.200
     0.240     0.340     0.200
     0.240     0.110     0.200
     0.290     0.367     0.200
     0.338     1.338     0.200
     0.362     1.452     0.200
     0.375     0.603     0.200
     0.346     1.222     0.200
     0.385     0.872     0.200
     0.451     0.025     0.200
     0.483     0.041     0.200
     0.486    -0.222     0.200
     0.452    -0.050     0.200
     0.507    -0.265     0.200
     0.546    -0.374     0.200
     0.553    -0.262     0.200
     0.573    -0.821     0.200
     0.590    -0.313     0.200
     0.676    -1.105     0.200
     0.690    -1.146     0.200
     0.669    -0.498     0.200
     0.687    -0.687     0.200
     0.724    -0.926     0.200
     0.744    -0.879     0.200
     0.763    -0.905     0.200
     0.868    -0.770     0.200
     0.864    -0.472     0.200
     0.931    -0.405     0.200
     0.932    -0.063     0.200
     0.924    -0.345     0.200
     0.917    -0.656     0.200
     0.931    -0.916     0.200
     0.930    -0.983     0.200
     0.967    -1.149     0.200
     0.128     0.692     0.200
     0.175     1.753     0.200
     0.215     1.072     0.200
     0.297     1.500     0.200
     0.319     1.017     0.200
     0.297     1.609     0.200
     0.389     1.299     0.200
     0.644    -0.334     0.200
     0.106     0.061     0.200
     0.107    -1.197     0.200
     0.144    -1.104     0.200
     0.150     0.915     0.200
     0.150     1.085     0.200
     0.214     1.277     0.200
     0.214     1.437     0.200
     0.332     1.488     0.200
     0.330     1.102     0.200
     0.473     0.357     0.200
     0.701    -0.576     0.200
     0.865    -1.361     0.200
     0.902     0.007     0.200
     0.872     0.109     0.200
     0.998     1.009     0.200
     0.040    -1.104     0.200
     0.040    -0.956     0.200
     0.082     0.548     0.200
     0.118     0.993     0.200
     0.142     1.046     0.200
     0.227     0.678     0.200
     0.256     1.147     0.200
     0.242     0.767     0.200
     0.345     0.081     0.200
     0.446     0.684     0.200
     0.469     0.538     0.200
     0.506     0.302     0.200
     0.599    -0.439     0.200
     0.633    -0.263     0.200
     0.759    -1.584     0.200
     0.755    -1.124     0.200
     0.762    -0.891     0.200
     0.849    -0.709     0.200
     0.898     0.899     0.200
     0.909     1.265     0.200
     0.036    -0.732     0.200
     0.073    -0.154     0.200
     0.073     1.857     0.200
     0.129     1.284     0.200
     0.151     1.170     0.200
     0.250     0.973     0.200
     0.278     1.443     0.200
     0.251     0.617     0.200
     0.251     1.177     0.200
     0.309     1.696     0.200
     0.313     1.395     0.200
     0.345     0.783     0.200
     0.336     0.290     0.200
     0.348     1.660     0.200
     0.459     0.479     0.200
     0.757    -1.435     0.200
     0.764    -1.184     0.200
     0.791     0.183     0.200
     0.802     0.102     0.200
     0.052    -0.412     0.200
     0.074     0.449     0.200
     0.177    -0.079     0.200
     0.229    -0.822     0.200
     0.241    -0.786     0.200
     0.268     0.600     0.200
     0.352    -0.798     0.200
     0.350     0.594     0.200
     0.358    -0.539     0.200
     0.344    -0.356     0.200
     0.318    -0.061     0.200
     0.412    -0.565     0.200
     0.384     1.904     0.200
     0.420    -0.081     0.200
     0.411    -0.064     0.200
     0.472    -0.430     0.200
     0.507    -0.252     0.200
     0.498    -0.648     0.200
     0.534    -0.359     0.200
     0.547    -1.463     0.200
     0.574    -0.687     0.200
     0.537    -0.222     0.200
     0.547    -0.417     0.200
     0.610    -0.514     0.200
     0.633    -0.799     0.200
     0.660    -0.909     0.200
     0.674    -1.221     0.200
     0.686    -0.890     0.200
     0.679    -0.788     0.200
     0.776    -1.038     0.200
     0.783    -0.691     0.200
     0.835    -1.045     0.200
     0.868    -0.853     0.200
     0.816    -0.162     0.200
     0.850    -0.842     0.200
     0.863    -0.344     0.200
     0.869    -0.592     0.200
     0.893    -0.276     0.200
     0.877    -0.616     0.200
     0.883    -0.015     0.200
     0.906    -0.116     0.200
     0.944    -0.878     0.200
     0.922    -0.755     0.200
     0.970    -1.362     0.200
     0.077    -0.381     0.200
     0.098    -0.427     0.200
     0.099     0.451     0.200
     0.073     0.064     0.200
     0.154     0.224     0.200
     0.154     0.262     0.200
     0.107     0.947     0.200
     0.100     0.187     0.200
     0.205    -0.343     0.200
     0.205     0.555     0.200
     0.154     0.669     0.200
     0.146     0.127     0.200
     0.219     0.521     0.200
     0.219     0.521     0.200
     0.146     0.621     0.200
     0.146     0.730     0.200
     0.222     0.825     0.200
     0.341     0.475     0.200
     0.333    -0.448     0.200
     0.333    -0.717     0.200
     0.356     0.772     0.200
     0.353    -0.180     0.200
     0.392     1.082     0.200
     0.403     0.146     0.200
     0.396     1.234     0.200
     0.448    -0.556     0.200
     0.497     0.277     0.200
     0.488     1.285     0.200
     0.485     1.178     0.200
     0.485     1.069     0.200
     0.468     0.234     0.200
     0.567    -0.799     0.200
     0.605    -0.375     0.200
     0.592     0.563     0.200
     0.670    -0.997     0.200
     0.721    -1.020     0.200
     0.716    -1.712     0.200
     0.777    -1.183     0.200
     0.842    -0.139     0.200
     0.840    -0.274     0.200
     0.894    -0.315     0.200
     0.929    -0.113     0.200
     0.941    -0.324     0.200
     0.995    -0.029     0.200
     0.074     0.275     0.200
     0.093     0.026     0.200
     0.097     0.948     0.200
     0.072     0.215     0.200
     0.104     0.429     0.200
     0.148     0.673     0.200
     0.148     0.609     0.200
     0.107     1.022     0.200
     0.150     0.430     0.200
     0.200     0.805     0.200
     0.151     0.584     0.200
     0.214     0.898     0.200
     0.214     0.898     0.200
     0.351    -0.119     0.200
     0.410     1.435     0.200
     0.403     0.254     0.200
     0.398     1.053     0.200
     0.389     0.910     0.200
     0.403     0.660     0.200
     0.451    -0.774     0.200
     0.451    -0.391     0.200
     0.451    -0.266     0.200
     0.470     0.251     0.200
     0.492     0.542     0.200
     0.471     0.076     0.200
     0.562    -0.838     0.200
     0.667    -1.137     0.200
     0.717    -0.832     0.200
     0.711    -2.061     0.200
     0.776    -0.705     0.200
     0.906    -0.355     0.200
     0.897    -0.345     0.200
     0.944    -0.375     0.200
     0.086     0.458     0.200
     0.177     0.430     0.200
     0.149    -0.069     0.200
     0.197     0.024     0.200
     0.229    -0.540     0.200
     0.229    -0.150     0.200
     0.234    -1.035     0.200
     0.209     0.411     0.200
     0.320     1.618     0.200
     0.312    -0.024     0.200
     0.312     0.765     0.200
     0.347     1.804     0.200
     0.376     1.334     0.200
     0.494     0.027     0.200
     0.502     0.305     0.200
     0.505    -0.227     0.200
     0.512    -0.052     0.200
     0.519    -0.298     0.200
     0.561    -0.092     0.200
     0.558    -0.477     0.200
     0.589    -0.449     0.200
     0.571    -0.339     0.200
     0.638    -0.350     0.200
     0.635    -0.606     0.200
     0.635    -0.038     0.200
     0.657    -0.928     0.200
     0.655    -0.920     0.200
     0.705    -1.054     0.200
     0.672    -0.444     0.200
     0.707    -1.208     0.200
     0.702    -1.006     0.200
     0.740    -0.714     0.200
     0.733    -0.668     0.200
     0.797    -0.690     0.200
     0.802    -1.046     0.200
     0.827    -0.811     0.200
     0.832    -0.835     0.200
     0.920    -0.702     0.200
     0.980    -0.807     0.200
     0.981    -0.901     0.200
     0.169     0.142     0.200
     0.186    -0.152     0.200
     0.186     0.598     0.200
     0.269     1.361     0.200
     0.298     1.149     0.200
     0.290    -0.496     0.200
     0.344     0.066     0.200
     0.413     1.575     0.200
     0.440     1.977     0.200
     0.593    -0.189     0.200
     0.633    -0.431     0.200
     0.746    -0.818     0.200
     0.766    -1.291     0.200
     0.823    -0.536     0.200
     0.885    -1.573     0.200
     0.914    -0.475     0.200
     0.963    -0.910     0.200
     0.967     0.003     0.200
     0.967    -0.687     0.200
     0.966     0.283     0.200
     0.992    -0.280     0.200
     0.835     0.162     0.200
     0.781    -0.193     0.200
     0.781     1.698     0.200
     0.781    -0.091     0.200
     0.314     0.071     0.200
     0.314     0.513     0.200
     0.247     0.786     0.200
     0.247     0.636     0.200
     0.178     0.014     0.200
     0.983    -0.594     0.200
     0.887    -0.395     0.200
     0.033     0.513     0.200
     0.035     0.712     0.200
     0.921    -0.486     0.200
     0.921    -0.236     0.200
     0.338     0.241     0.200
     0.338     0.093     0.200
     0.136     0.453     0.200
     0.795    -0.163     0.200
     0.241    -0.576     0.200
     0.241    -0.607     0.200
     0.262    -0.480     0.200
     0.120     0.610     0.200
     0.119    -0.120     0.200
     0.119    -0.060     0.200
     0.718     0.932     0.200
     0.148     0.232     0.200
     0.773     0.004     0.200
     0.284     0.229     0.200
     0.509    -0.281     0.200
     0.900    -0.619     0.200
     0.316     1.117     0.200
     0.336     1.179     0.200
     0.393     0.114     0.200
     0.983    -1.596     0.200
     0.812    -0.869     0.200
     0.812     1.140     0.200
     0.850    -1.119     0.200
     0.546    -0.848     0.200
     0.837    -0.347     0.200
     0.678    -1.035     0.200
     0.809     0.284     0.200
     0.692    -1.463     0.200
     0.922    -0.633     0.200
     0.875    -0.979     0.200
     0.922    -0.298     0.200
     0.114     0.136     0.200
     0.147     0.149     0.200
     0.149     0.429     0.200
     0.176     0.249     0.200
     0.254    -0.431     0.200
     0.254    -0.511     0.200
     0.254    -0.061     0.200
     0.285     0.116     0.200
     0.276    -0.349     0.200
     0.236     0.693     0.200
     0.325     1.043     0.200
     0.318    -0.391     0.200
     0.318     0.799     0.200
     0.318     0.379     0.200
     0.349     0.040     0.200
     0.457     0.261     0.200
     0.466    -0.192     0.200
     0.466     0.058     0.200
     0.522    -0.095     0.200
     0.542    -0.943     0.200
     0.671    -1.139     0.200
     0.689    -1.947     0.200
     0.706    -1.286     0.200
     0.750    -0.103     0.200
     0.785    -0.123     0.200
     0.777    -0.213     0.200
     0.822     0.333     0.200
     0.772     0.948     0.200
     0.772     0.720     0.200
     0.800    -0.367     0.200
     0.804     0.115     0.200
     0.799     0.997     0.200
     0.851    -0.686     0.200
     0.829     0.130     0.200
     0.934    -0.376     0.200
     0.912    -0.160     0.200
     0.893    -0.558     0.200
     0.928    -0.767     0.200
     0.131    -0.054     0.200
     0.116     0.090     0.200
     0.149     0.032     0.200
     0.150     0.266     0.200
     0.178     1.418     0.200
     0.174     0.005     0.200
     0.255    -0.371     0.200
     0.287     0.096     0.200
     0.277    -0.409     0.200
     0.233     0.759     0.200
     0.233     0.478     0.200
     0.316     0.093     0.200
     0.316     0.372     0.200
     0.316     0.942     0.200
     0.349     0.134     0.200
     0.544    -0.880     0.200
     0.632    -0.754     0.200
     0.672    -1.166     0.200
     0.691    -1.556     0.200
     0.753    -0.169     0.200
     0.729     0.026     0.200
     0.786    -0.231     0.200
     0.800     1.220     0.200
     0.776    -0.230     0.200
     0.769     0.591     0.200
     0.769     0.760     0.200
     0.797     0.033     0.200
     0.803     0.110     0.200
     0.826     0.063     0.200
     0.892    -0.414     0.200
     0.927    -0.326     0.200
     0.051    -0.731     0.200
     0.053    -0.359     0.200
     0.059    -1.308     0.200
     0.059    -1.189     0.200
     0.059    -0.509     0.200
     0.145     0.500     0.200
     0.145     0.531     0.200
     0.143     1.065     0.200
     0.143     0.275     0.200
     0.143     0.585     0.200
     0.175     1.285     0.200
     0.265     1.233     0.200
     0.257     0.784     0.200
     0.246     0.191     0.200
     0.294     1.265     0.200
     0.312     0.753     0.200
     0.312     0.443     0.200
     0.356     0.873     0.200
     0.474     0.442     0.200
     0.477     0.630     0.200
     0.495     0.887     0.200
     0.613    -0.496     0.200
     0.619    -0.648     0.200
     0.636    -0.611     0.200
     0.762    -1.234     0.200
     0.791    -1.257     0.200
     0.873     0.842     0.200
     0.934    -0.445     0.200
     0.971    -0.021     0.200
     0.048     0.057     0.200
     0.049    -0.855     0.200
     0.132     0.427     0.200
     0.132    -0.135     0.200
     0.152     1.587     0.200
     0.152     0.431     0.200
     0.177     1.386     0.200
     0.177     1.214     0.200
     0.247     1.192     0.200
     0.247     0.697     0.200
     0.310     0.279     0.200
     0.310     0.529     0.200
     0.263     0.166     0.200
     0.263     0.713     0.200
     0.338     0.801     0.200
     0.409     0.680     0.200
     0.596    -0.470     0.200
     0.619    -0.598     0.200
     0.836    -0.722     0.200
     0.781    -1.037     0.200
     0.863     0.434     0.200
     0.973     0.379     0.200
     0.938     0.304     0.200
     0.938     1.124     0.200
     0.041     0.407     0.200
     0.043     0.092     0.200
     0.060    -0.225     0.200
     0.060    -0.365     0.200
     0.060     0.072     0.200
     0.144     0.791     0.200
     0.144     1.236     0.200
     0.154     1.118     0.200
     0.258     1.222     0.200
     0.184     0.901     0.200
     0.259     0.768     0.200
     0.303     0.429     0.200
     0.303     0.218     0.200
     0.257     0.580     0.200
     0.479     0.498     0.200
     0.608    -0.970     0.200
     0.755    -1.028     0.200
     0.793    -1.546     0.200
     0.935     1.069     0.200
     0.935     0.156     0.200
     0.152     0.903     0.200
     0.044    -0.502     0.200
     0.147     0.690     0.200
     0.261     0.688     0.200
     0.262     0.737     0.200
     0.303     0.239     0.200
     0.303     0.395     0.200
     0.424     0.723     0.200
     0.424     0.747     0.200
     0.466     0.246     0.200
     0.610    -0.124     0.200
     0.714    -0.395     0.200
     0.795    -1.169     0.200
     0.759    -0.670     0.200
     0.932    -0.226     0.200
     0.932     0.321     0.200
     0.864     0.469     0.200
     0.964    -0.190     0.200
     0.035    -0.719     0.200
     0.035    -0.820     0.200
     0.035     0.040     0.200
     0.056    -0.413     0.200
     0.057    -0.232     0.200
     0.117     0.316     0.200
     0.117     0.336     0.200
     0.173     1.322     0.200
     0.232     1.008     0.200
     0.234     0.838     0.200
     0.234     0.699     0.200
     0.275     0.407     0.200
     0.316     0.580     0.200
     0.316     0.700     0.200
     0.324     0.878     0.200
     0.337     0.411     0.200
     0.476     0.324     0.200
     0.625    -0.902     0.200
     0.779    -0.273     0.200
     0.779     0.408     0.200
     0.774    -0.038     0.200
     0.766    -1.317     0.200
     0.861     0.033     0.200
     0.947     0.108     0.200
     0.947     0.638     0.200
     0.947     1.524     0.200
     0.982     0.120     0.200
     0.024     0.095     0.200
     0.024     1.394     0.200
     0.108    -0.237     0.200
     0.082     0.536     0.200
     0.144     1.193     0.200
     0.217     0.609     0.200
     0.240     0.405     0.200
     0.336     0.518     0.200
     0.308     1.341     0.200
     0.583    -1.139     0.200
     0.617    -0.710     0.200
     0.739    -0.980     0.200
     0.751    -1.224     0.200
     0.794     1.012     0.200
     0.801     0.569     0.200
     0.923    -0.592     0.200
     0.923     0.546     0.200
     0.010    -0.081     0.200
     0.010     0.731     0.200
     0.097     0.433     0.200
     0.137     0.812     0.200
     0.196     0.315     0.200
     0.222     0.885     0.200
     0.304     0.930     0.200
     0.315     1.398     0.200
     0.416     0.609     0.200
     0.416     0.816     0.200
     0.748    -0.357     0.200
     0.817    -0.360     0.200
     0.932    -0.669     0.200
     0.932     0.101     0.200
     0.147     0.504     0.200
     0.148    -0.066     0.200
     0.290    -0.074     0.200
     0.290     0.547     0.200
     0.389     0.729     0.200
     0.340     0.550     0.200
     0.451    -0.326     0.200
     0.564     0.558     0.200
     0.564     0.379     0.200
     0.569    -0.743     0.200
     0.735    -0.458     0.200
     0.735    -0.337     0.200
     0.755    -1.533     0.200
     0.869     0.661     0.200
     0.869     0.229     0.200
     0.811    -0.253     0.200
     0.894    -0.475     0.200
     0.897     1.124     0.200
     0.902     0.378     0.200
     0.985    -0.277     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.720     1.029     0.200
     0.760    -0.261     0.200
     0.733     0.548     0.200
     0.713     0.274     0.200
     0.716     0.837     0.200
     0.765     0.095     0.200
     0.755     0.171     0.200
     0.734    -0.473     0.200
     0.734     0.163     0.200
     0.734     0.605     0.200
     0.759    -0.958     0.200
     0.987    -1.759     0.200
     0.987    -1.024     0.200
     0.957    -1.066     0.200
     0.964    -1.474     0.200
     0.671    -0.969     0.200
     0.999    -1.482     0.200
     0.999    -0.841     0.200
     0.696    -0.659     0.200
     0.455     0.118     0.200
     0.701    -0.948     0.200
     0.475    -0.324     0.200
     0.742     0.942     0.200
     0.729     0.031     0.200
     0.475    -1.071     0.200
     0.683    -0.637     0.200
     0.743    -0.156     0.200
     0.473    -0.855     0.200
     0.679    -0.869     0.200
     0.737    -0.025     0.200
     0.463    -1.092     0.200
     0.463    -0.212     0.200
     0.665    -0.750     0.200
     0.697    -0.800     0.200
     0.744     0.128     0.200
     0.461    -0.623     0.200
     0.461     0.327     0.200
     0.737     0.383     0.200
     0.645    -0.530     0.200
     0.732    -1.581     0.200
     0.732    -1.143     0.200
     0.626    -0.945     0.200
     0.648    -0.791     0.200
     0.674    -0.316     0.200
     0.739    -1.669     0.200
     0.739    -1.401     0.200
     0.711    -0.609     0.200
     0.405    -0.740     0.200
     0.744    -1.614     0.200
     0.586     1.038     0.200
     0.788    -0.262     0.200
     0.935    -1.109     0.200
     0.724     0.854     0.200
     0.728     1.007     0.200
     0.732    -0.466     0.200
     0.668    -0.517     0.200
     0.676    -0.349     0.200
     0.795    -1.492     0.200
     0.708    -0.430     0.200
     0.773    -1.129     0.200
     0.755    -1.068     0.200
     0.708    -0.100     0.200
     0.776    -0.501     0.200
     0.825    -0.984     0.200
     0.876    -0.439     0.200
     0.977    -1.228     0.200
     0.984    -1.400     0.200
     0.716    -0.968     0.200
     0.707    -0.480     0.200
     0.707     0.091     0.200
     0.744    -0.401     0.200
     0.713    -0.817     0.200
     0.702    -0.270     0.200
     0.751    -0.759     0.200
     0.573    -1.262     0.200
     0.601    -1.214     0.200
     0.743    -0.622     0.200
     0.762    -0.232     0.200
     0.960    -0.674     0.200
     0.458     0.146     0.200
     0.758    -0.401     0.200
     0.998    -2.060     0.200
     0.606     0.549     0.200
     0.799    -1.254     0.200
     0.862    -0.763     0.200
     0.418    -1.563     0.200
     0.976    -0.518     0.200
     0.741    -1.248     0.200
     0.741     0.424     0.200
     0.741     1.752     0.200
     0.829    -0.438     0.200
     0.399    -0.890     0.200
     0.759    -0.520     0.200
     0.734     0.184     0.200
     0.841    -0.631     0.200
     0.734     0.869     0.200
     0.840    -0.812     0.200
     0.856    -1.045     0.200
     0.719     0.137     0.200
     0.611    -0.513     0.200
     0.796    -0.939     0.200
     0.876    -0.069     0.200
     0.880    -0.288     0.200
     0.932    -0.977     0.200
     0.932    -2.352     0.200
     0.754    -0.599     0.200
     0.754    -1.084     0.200
     0.903    -1.175     0.200
     0.903    -1.354     0.200
     0.882    -1.611     0.200
     0.933    -0.994     0.200
     0.497    -0.229     0.200
     0.539    -0.889     0.200
     0.711    -0.623     0.200
     0.871    -2.159     0.200
     0.910    -1.777     0.200
     0.910    -1.349     0.200
     0.938    -1.284     0.200
     0.975    -2.344     0.200
     0.975    -1.080     0.200
     0.927    -1.746     0.200
     0.498     0.161     0.200
     0.816    -0.816     0.200
     0.900    -1.035     0.200
     0.805    -0.669     0.200
     0.930    -1.347     0.200
     0.857    -1.112     0.200
     0.557    -1.399     0.200
     0.783    -0.366     0.200
     0.806    -0.925     0.200
     0.911    -1.487     0.200
     0.911    -0.917     0.200
     0.861    -0.830     0.200
     0.905    -1.115     0.200
     0.906    -1.446     0.200
     0.819    -0.542     0.200
     0.819    -1.049     0.200
     0.802    -0.990     0.200
     0.802     1.108     0.200
     0.945    -1.508     0.200
     0.865    -0.939     0.200
     0.962    -2.018     0.200
     0.394    -1.427     0.200
     0.587    -0.825     0.200
     0.721     0.013     0.200
     0.698    -1.525     0.200
     0.698    -0.194     0.200
     0.744    -0.919     0.200
     0.817    -0.797     0.200
     0.811    -1.080     0.200
     0.811    -0.971     0.200
     0.802     0.733     0.200
     0.765     0.056     0.200
     0.940    -1.995     0.200
     0.586    -1.154     0.200
     0.744    -0.095     0.200
     0.491     0.316     0.200
     0.698    -1.097     0.200
     0.741    -1.179     0.200
     0.840    -0.478     0.200
     0.764    -0.779     0.200
     0.654     0.648     0.200
     0.754    -0.542     0.200
     0.754    -0.881     0.200
     0.766    -0.997     0.200
     0.965    -1.292     0.200
     0.965    -1.083     0.200
     0.448    -1.788     0.200
     0.715    -0.206     0.200
     0.766    -1.484     0.200
     0.933    -2.127     0.200
     0.626    -0.297     0.200
     0.760     0.325     0.200
     0.779    -0.755     0.200
     0.854    -0.767     0.200
     0.746    -1.169     0.200
     0.801    -0.121     0.200
     0.838    -0.091     0.200
     0.838    -0.721     0.200
     0.815    -0.424     0.200
     0.775    -1.344     0.200
     0.921    -0.801     0.200
     0.663     0.436     0.200
     0.723    -1.162     0.200
     0.883    -1.345     0.200
     0.883    -2.243     0.200
     0.896    -1.439     0.200
     0.588    -0.498     0.200
     0.752    -0.963     0.200
     0.761    -0.620     0.200
     0.955    -1.963     0.200
     0.682    -1.274     0.200
     0.682     0.562     0.200
     0.843     0.414     0.200
     0.903    -1.246     0.200
     0.742    -0.669     0.200
     0.801    -0.949     0.200
     0.931    -0.901     0.200
     0.450    -0.433     0.200
     0.792    -0.546     0.200
     0.884    -1.334     0.200
     0.884    -0.908     0.200
     0.855    -0.247     0.200
     0.534     0.176     0.200
     0.834    -0.629     0.200
     0.882    -0.918     0.200
     0.626     0.671     0.200
     0.679     0.112     0.200
     0.679     1.245     0.200
     0.982    -2.259     0.200
     0.982    -1.384     0.200
     0.738     0.314     0.200
     0.741    -0.244     0.200
     0.748    -0.890     0.200
     0.663    -0.541     0.200
     0.663     0.381     0.200
     0.661    -0.851     0.200
     0.975    -1.255     0.200
     0.700     0.458     0.200
     0.773    -0.713     0.200
     0.639     0.377     0.200
     0.978    -1.172     0.200
     0.522     0.618     0.200
     0.606    -0.429     0.200
     0.746    -0.465     0.200
     0.746     0.095     0.200
     0.780    -0.711     0.200
     0.936    -1.288     0.200
     0.936    -1.048     0.200
     0.873    -1.920     0.200
     0.469    -0.494     0.200
     0.809    -0.485     0.200
     0.809    -1.032     0.200
     0.809    -0.704     0.200
     0.906    -1.586     0.200
     0.725    -0.790     0.200
     0.805    -0.013     0.200
     0.805    -1.013     0.200
     0.805    -0.782     0.200
     0.910    -1.447     0.200
     0.704     0.573     0.200
     0.510     0.147     0.200
     0.594    -0.583     0.200
     0.741    -0.621     0.200
     0.786    -0.964     0.200
     0.786    -1.073     0.200
     0.568     0.751     0.200
     0.910    -0.277     0.200
     0.628    -0.089     0.200
     0.742    -0.311     0.200
     0.809    -0.903     0.200
     0.896    -1.395     0.200
     0.896    -0.688     0.200
     0.553     0.134     0.200
     0.553     0.314     0.200
     0.755    -0.126     0.200
     0.764    -1.374     0.200
     0.764    -0.074     0.200
     0.764     0.087     0.200
     0.955    -1.562     0.200
     0.623     0.584     0.200
     0.749    -1.479     0.200
     0.767     0.103     0.200
     0.767    -0.826     0.200
     0.949    -0.978     0.200
     0.949    -1.592     0.200
     0.738    -0.835     0.200
     0.812    -1.024     0.200
     0.720    -0.887     0.200
     0.796    -1.215     0.200
     0.919    -0.963     0.200
     0.487    -1.477     0.200
     0.487     0.293     0.200
     0.791    -0.951     0.200
     0.924    -1.548     0.200
     0.537    -1.008     0.200
     0.622     0.066     0.200
     0.772    -1.309     0.200
     0.772    -0.680     0.200
     0.772    -0.899     0.200
     0.839    -1.089     0.200
     0.839    -0.860     0.200
     0.624    -1.093     0.200
     0.799    -0.893     0.200
     0.799    -0.033     0.200
     0.841    -0.723     0.200
     0.841    -0.993     0.200
     0.714    -0.679     0.200
     0.780    -0.684     0.200
     0.722    -0.768     0.200
     0.761    -0.856     0.200
     0.711    -0.743     0.200
     0.755    -0.822     0.200
     0.997    -0.628     0.200
     0.904    -0.981     0.200
     0.676     0.015     0.200
     0.818    -0.531     0.200
     0.496     1.415     0.200
     0.782    -0.399     0.200
     0.933    -1.411     0.200
     0.753    -1.097     0.200
     0.794    -1.114     0.200
     0.923    -1.808     0.200
     0.659    -0.980     0.200
     0.653    -0.942     0.200
     0.983    -2.113     0.200
     0.963    -0.809     0.200
     0.573    -1.066     0.200
     0.573     0.454     0.200
     0.981    -1.408     0.200
     0.981    -1.690     0.200
     0.731    -0.791     0.200
     0.648    -0.443     0.200
     0.693     0.516     0.200
     0.767     0.823     0.200
     0.775     0.240     0.200
     0.780    -0.914     0.200
     0.785    -0.829     0.200
     0.414    -1.437     0.200
     0.574     1.085     0.200
     0.659    -0.432     0.200
     0.730    -0.500     0.200
     0.871    -0.869     0.200
     0.988    -0.635     0.200
     0.608    -0.178     0.200
     0.712    -0.490     0.200
     0.995    -1.058     0.200
     0.730    -0.551     0.200
     0.732    -0.025     0.200
     0.984    -1.740     0.200
     0.610    -0.804     0.200
     0.993    -1.240     0.200
     0.696    -0.147     0.200
     0.800    -0.838     0.200
     0.918    -1.830     0.200
     0.918    -1.027     0.200
     0.757    -1.389     0.200
     0.810    -0.235     0.200
     0.914    -2.067     0.200
     0.914    -1.492     0.200
     0.602    -1.152     0.200
     0.840    -0.464     0.200
     0.898    -1.560     0.200
     0.741    -0.397     0.200
     0.994    -1.134     0.200
     0.675    -1.093     0.200
     0.647    -0.146     0.200
     0.948    -1.291     0.200
     0.983    -1.272     0.200
     0.982    -1.709     0.200
     0.731    -0.639     0.200
     0.850    -0.367     0.200
     0.886    -0.947     0.200
     0.941    -1.850     0.200
     0.941    -1.444     0.200
     0.606    -0.797     0.200
     0.719    -0.872     0.200
     0.719    -1.221     0.200
     0.760    -0.988     0.200
     0.907    -1.834     0.200
     0.907    -1.443     0.200
     0.710    -0.465     0.200
     0.756    -0.540     0.200
     0.756     0.760     0.200
     0.818    -1.055     0.200
     0.818    -0.485     0.200
     0.731     0.755     0.200
     0.784    -0.622     0.200
     0.810    -0.680     0.200
     0.845    -2.007     0.200
     0.845    -1.327     0.200
     0.934    -0.626     0.200
     0.504    -0.135     0.200
     0.681    -0.983     0.200
     0.819    -0.523     0.200
     0.904    -1.628     0.200
     0.621    -0.907     0.200
     0.741    -0.748     0.200
     0.792    -0.709     0.200
     0.834    -0.368     0.200
     0.873    -0.913     0.200
     0.940    -1.912     0.200
     0.782    -0.729     0.200
     0.933    -1.801     0.200
     0.933    -1.094     0.200
     0.783    -0.529     0.200
     0.558     0.087     0.200
     0.688    -1.201     0.200
     0.771    -0.514     0.200
     0.813    -0.894     0.200
     0.939    -1.919     0.200
     0.686    -0.319     0.200
     0.845    -1.022     0.200
     0.931    -1.277     0.200
     0.973    -1.555     0.200
     0.973    -1.860     0.200
     0.766    -0.882     0.200
     0.784    -0.636     0.200
     0.747    -0.510     0.200
     0.750    -0.644     0.200
     0.804    -0.976     0.200
     0.826    -0.906     0.200
     0.853    -0.234     0.200
     0.648    -0.071     0.200
     0.998    -2.191     0.200
     0.670    -0.834     0.200
     0.950    -0.929     0.200
     0.979    -1.222     0.200
     0.979    -1.573     0.200
     0.820    -1.067     0.200
     0.629    -1.161     0.200
     0.989    -2.469     0.200
     0.989    -1.059     0.200
     0.959    -0.377     0.200
     0.625     0.340     0.200
     0.625     1.520     0.200
     0.792    -0.892     0.200
     0.944    -1.801     0.200
     0.944    -1.617     0.200
     0.780    -0.747     0.200
     0.780    -0.599     0.200
     0.888     0.055     0.200
     0.546    -1.080     0.200
     0.633    -0.311     0.200
     0.804    -0.218     0.200
     0.852    -0.953     0.200
     0.938    -1.747     0.200
     0.640    -0.735     0.200
     0.795     0.662     0.200
     0.998    -1.287     0.200
     0.998    -1.867     0.200
     0.998    -0.977     0.200
     0.742    -0.235     0.200
     0.742     0.820     0.200
     0.866    -0.918     0.200
     0.712    -0.704     0.200
     0.806     0.105     0.200
     0.898    -1.180     0.200
     0.970    -2.394     0.200
     0.970    -1.999     0.200
     0.735    -1.045     0.200
     0.663    -0.332     0.200
     0.863    -0.157     0.200
     0.758    -0.370     0.200
     0.775     0.002     0.200
     0.822    -1.038     0.200
     0.415    -1.351     0.200
     0.814    -0.908     0.200
     0.839    -1.382     0.200
     0.839    -1.682     0.200
     0.847    -0.879     0.200
     0.810    -1.073     0.200
     0.852    -0.501     0.200
     0.982    -0.931     0.200
     0.763    -0.360     0.200
     0.904    -0.933     0.200
     0.802    -1.175     0.200
     0.760    -0.841     0.200
     0.812    -1.321     0.200
     0.762     0.336     0.200
     0.770    -1.388     0.200
     0.817    -1.332     0.200
     0.684    -0.621     0.200
     0.890    -0.275     0.200
     0.979    -2.767     0.200
     0.979    -1.943     0.200
     0.989    -2.551     0.200
     0.989    -2.125     0.200
     0.586     0.841     0.200
     0.638    -1.018     0.200
     0.875    -1.863     0.200
     0.986    -2.242     0.200
     0.747    -0.422     0.200
     0.809    -0.774     0.200
     0.947    -1.352     0.200
     0.947    -2.174     0.200
     0.785    -0.267     0.200
     0.765    -0.778     0.200
     0.866    -0.524     0.200
     0.950    -2.261     0.200
     0.616    -0.262     0.200
     0.677    -0.579     0.200
     0.737    -0.891     0.200
     0.619     0.202     0.200
     0.619    -1.023     0.200
     0.679    -0.144     0.200
     0.751    -0.581     0.200
     0.764    -0.016     0.200
     0.764    -0.235     0.200
     0.786     0.351     0.200
     0.638    -0.689     0.200
     0.714     0.577     0.200
     0.749    -0.862     0.200
     0.870    -1.730     0.200
     0.579    -0.717     0.200
     0.752    -0.518     0.200
     0.752    -0.955     0.200
     0.720     0.444     0.200
     0.752    -0.653     0.200
     0.876    -1.447     0.200
     0.699     0.387     0.200
     0.765    -1.225     0.200
     0.800    -0.988     0.200
     0.858    -1.537     0.200
     0.492    -0.670     0.200
     0.580     0.802     0.200
     0.591     0.370     0.200
     0.610     0.589     0.200
     0.667    -0.831     0.200
     0.667    -1.021     0.200
     0.815    -1.067     0.200
     0.807    -0.164     0.200
     0.819    -1.253     0.200
     0.841    -1.403     0.200
     0.840    -1.077     0.200
     0.843    -1.868     0.200
     0.850    -0.912     0.200
     0.858    -1.789     0.200
     0.967    -0.732     0.200
     0.988    -1.474     0.200
     0.980    -0.486     0.200
     0.418    -1.317     0.200
     0.412    -0.673     0.200
     0.483    -0.253     0.200
     0.503    -0.119     0.200
     0.503     1.190     0.200
     0.533     0.272     0.200
     0.533     1.194     0.200
     0.552    -0.284     0.200
     0.543    -0.031     0.200
     0.564    -1.241     0.200
     0.542     0.722     0.200
     0.573     1.115     0.200
     0.559    -0.272     0.200
     0.587     0.240     0.200
     0.670    -0.167     0.200
     0.707    -0.232     0.200
     0.731     1.484     0.200
     0.783    -1.222     0.200
     0.934    -1.201     0.200
     0.460     0.785     0.200
     0.487    -0.121     0.200
     0.509     0.527     0.200
     0.568     0.319     0.200
     0.589     0.908     0.200
     0.630     0.836     0.200
     0.645    -0.832     0.200
     0.719     0.592     0.200
     0.740    -0.920     0.200
     0.746    -1.125     0.200
     0.407    -0.525     0.200
     0.437    -1.351     0.200
     0.447    -0.111     0.200
     0.469     0.140     0.200
     0.503     0.119     0.200
     0.503     0.509     0.200
     0.510     0.137     0.200
     0.518     0.116     0.200
     0.555    -0.559     0.200
     0.598    -0.303     0.200
     0.605     0.181     0.200
     0.636     1.450     0.200
     0.691     0.629     0.200
     0.689     1.439     0.200
     0.716    -0.561     0.200
     0.716     0.025     0.200
     0.717    -0.560     0.200
     0.735    -0.085     0.200
     0.755     0.186     0.200
     0.797    -1.625     0.200
     0.879    -0.976     0.200
     0.366    -0.161     0.200
     0.375    -1.431     0.200
     0.377    -0.670     0.200
     0.427     0.012     0.200
     0.443     1.611     0.200
     0.469    -1.339     0.200
     0.482    -1.060     0.200
     0.478     0.255     0.200
     0.591     1.614     0.200
     0.604     1.557     0.200
     0.626     0.754     0.200
     0.638     0.218     0.200
     0.678    -1.364     0.200
     0.889    -0.766     0.200
     0.902    -0.728     0.200
     0.421    -1.080     0.200
     0.459     0.347     0.200
     0.494    -0.545     0.200
     0.509     0.076     0.200
     0.587     0.221     0.200
     0.624     0.169     0.200
     0.718     0.505     0.200
     0.704     0.008     0.200
     0.735    -1.007     0.200
     0.757    -0.751     0.200
     0.756    -0.681     0.200
     0.796    -1.014     0.200
     0.503    -0.191     0.200
     0.559    -0.158     0.200
     0.566    -0.948     0.200
     0.609    -0.310     0.200
     0.611     0.074     0.200
     0.611    -0.697     0.200
     0.661     0.522     0.200
     0.749    -0.675     0.200
     0.896    -0.897     0.200
     0.939    -1.900     0.200
     0.445    -1.017     0.200
     0.514    -0.892     0.200
     0.588    -0.681     0.200
     0.548    -0.499     0.200
     0.626    -0.903     0.200
     0.616    -0.545     0.200
     0.612    -1.485     0.200
     0.639    -0.946     0.200
     0.628    -0.132     0.200
     0.640    -0.652     0.200
     0.665    -1.507     0.200
     0.705    -1.133     0.200
     0.753    -0.861     0.200
     0.728    -1.206     0.200
     0.742    -0.978     0.200
     0.736     0.491     0.200
     0.730    -0.287     0.200
     0.730     0.604     0.200
     0.772    -0.035     0.200
     0.800    -0.383     0.200
     0.826    -0.997     0.200
     0.813    -0.336     0.200
     0.864    -0.840     0.200
     0.894    -1.484     0.200
     0.908    -1.297     0.200
     0.944    -1.249     0.200
     0.976    -1.384     0.200
     0.997    -1.027     0.200
     0.494    -0.783     0.200
     0.609    -0.226     0.200
     0.595     0.747     0.200
     0.740    -0.368     0.200
     0.760     0.096     0.200
     0.811    -1.086     0.200
     0.896     0.259     0.200
     0.896     1.089     0.200
     0.444    -0.639     0.200
     0.491    -0.607     0.200
     0.500     0.621     0.200
     0.514    -1.519     0.200
     0.554    -0.177     0.200
     0.547    -1.111     0.200
     0.575    -0.357     0.200
     0.602    -1.582     0.200
     0.618    -0.216     0.200
     0.608     0.585     0.200
     0.608     0.268     0.200
     0.633    -0.084     0.200
     0.726     0.092     0.200
     0.740    -0.952     0.200
     0.787     0.122     0.200
     0.805     0.075     0.200
     0.832     0.529     0.200
     0.922    -1.444     0.200
     0.417    -1.403     0.200
     0.471    -0.382     0.200
     0.497    -0.807     0.200
     0.520     0.496     0.200
     0.549    -0.187     0.200
     0.600     0.273     0.200
     0.640     0.056     0.200
     0.716     0.251     0.200
     0.751    -0.897     0.200
     0.799    -0.399     0.200
     0.866    -1.545     0.200
     0.552    -0.058     0.200
     0.589     0.239     0.200
     0.594    -1.036     0.200
     0.625    -1.254     0.200
     0.629     0.201     0.200
     0.643    -0.960     0.200
     0.748    -1.045     0.200
     0.761    -0.490     0.200
     0.415    -0.527     0.200
     0.446    -0.462     0.200
     0.493    -0.328     0.200
     0.507    -1.495     0.200
     0.513     0.182     0.200
     0.503     0.213     0.200
     0.513     0.593     0.200
     0.539     0.504     0.200
     0.602    -0.581     0.200
     0.650    -0.834     0.200
     0.681    -0.744     0.200
     0.652    -1.261     0.200
     0.730    -0.902     0.200
     0.772    -1.190     0.200
     0.727    -0.777     0.200
     0.740    -0.016     0.200
     0.777     0.290     0.200
     0.821    -1.056     0.200
     0.864    -1.327     0.200
     0.863    -1.013     0.200
     0.864    -1.342     0.200
     0.864    -1.147     0.200
     0.873    -1.199     0.200
     0.904    -0.967     0.200
     0.911    -0.929     0.200
     0.754     3.837     0.200
     0.944    -0.869     0.200
     0.950    -0.600     0.200
     0.407    -1.655     0.200
     0.438    -0.860     0.200
     0.595    -0.632     0.200
     0.533     0.315     0.200
     0.559     0.318     0.200
     0.555     0.538     0.200
     0.697    -0.270     0.200
     0.698    -0.443     0.200
     0.685    -0.122     0.200
     0.685     0.068     0.200
     0.720     0.590     0.200
     0.775     0.408     0.200
     0.752     1.226     0.200
     0.784    -0.333     0.200
     0.930    -0.570     0.200
     0.974    -1.345     0.200
     0.485    -0.796     0.200
     0.471    -0.639     0.200
     0.444     0.432     0.200
     0.482    -1.311     0.200
     0.482    -0.872     0.200
     0.591    -0.773     0.200
     0.535    -0.267     0.200
     0.558    -0.269     0.200
     0.556    -0.077     0.200
     0.596    -1.431     0.200
     0.681    -0.480     0.200
     0.692     0.028     0.200
     0.694    -0.541     0.200
     0.686    -0.742     0.200
     0.697    -0.605     0.200
     0.690    -0.517     0.200
     0.722     0.145     0.200
     0.776     0.011     0.200
     0.787    -0.698     0.200
     0.758    -1.107     0.200
     0.840     0.039     0.200
     0.927    -0.751     0.200
     0.969    -1.513     0.200
     0.573    -0.159     0.200
     0.671     0.449     0.200
     0.728    -1.255     0.200
     0.705     0.859     0.200
     0.752    -0.514     0.200
     0.720    -0.762     0.200
     0.729    -0.070     0.200
     0.729     0.282     0.200
     0.759     0.629     0.200
     0.766    -1.293     0.200
     0.773    -0.614     0.200
     0.781    -1.191     0.200
     0.824    -0.674     0.200
     0.824     0.237     0.200
     0.896    -0.728     0.200
     0.928    -1.117     0.200
     0.950    -2.089     0.200
     0.942    -1.406     0.200
     0.936    -1.315     0.200
     0.994    -1.847     0.200
     0.995    -0.944     0.200
     0.453    -1.776     0.200
     0.497    -0.898     0.200
     0.538    -0.760     0.200
     0.569    -1.115     0.200
     0.587    -1.145     0.200
     0.651    -1.117     0.200
     0.657    -1.069     0.200
     0.664    -1.393     0.200
     0.675    -0.032     0.200
     0.675     0.830     0.200
     0.673    -0.417     0.200
     0.673    -0.886     0.200
     0.753     0.629     0.200
     0.753     0.432     0.200
     0.882    -0.580     0.200
     0.901    -0.632     0.200
     0.986    -1.906     0.200
     0.453    -0.977     0.200
     0.453     0.014     0.200
     0.461    -1.393     0.200
     0.461    -0.863     0.200
     0.670    -0.245     0.200
     0.366    -0.662     0.200
     0.696     0.553     0.200
     0.696    -0.287     0.200
     0.430    -1.231     0.200
     0.437     0.420     0.200
     0.435     0.225     0.200
     0.630     0.686     0.200
     0.630     1.736     0.200
     0.630     1.028     0.200
     0.645     1.568     0.200
     0.627     0.246     0.200
     0.632     0.177     0.200
     0.423    -0.574     0.200
     0.386    -0.661     0.200
     0.613    -0.195     0.200
     0.398    -1.001     0.200
     0.693     0.348     0.200
     0.597    -0.051     0.200
     0.848    -0.523     0.200
     0.493    -0.597     0.200
     0.591    -0.423     0.200
     0.400    -0.790     0.200
     0.392    -1.389     0.200
     0.374    -1.062     0.200
     0.413    -0.850     0.200
     0.439    -0.714     0.200
     0.504    -0.733     0.200
     0.457    -1.191     0.200
     0.603    -1.028     0.200
     0.611    -0.160     0.200
     0.626    -0.475     0.200
     0.619     0.552     0.200
     0.638    -0.393     0.200
     0.616     0.839     0.200
     0.676    -0.156     0.200
     0.706     0.058     0.200
     0.683     0.061     0.200
     0.729     0.281     0.200
     0.995    -0.325     0.200
     0.394    -1.110     0.200
     0.402    -0.519     0.200
     0.373    -0.703     0.200
     0.421    -0.171     0.200
     0.438    -0.920     0.200
     0.464    -1.410     0.200
     0.484    -0.435     0.200
     0.524    -1.326     0.200
     0.606    -0.303     0.200
     0.627    -0.230     0.200
     0.618     0.082     0.200
     0.614     0.794     0.200
     0.638    -0.719     0.200
     0.707     0.086     0.200
     0.675    -0.237     0.200
     0.681    -0.221     0.200
     0.852    -0.537     0.200
     0.888    -1.586     0.200
     0.862    -0.583     0.200
     0.937    -1.070     0.200
     0.426    -1.447     0.200
     0.426    -1.557     0.200
     0.451    -0.010     0.200
     0.465    -0.410     0.200
     0.495    -0.792     0.200
     0.495     0.018     0.200
     0.489    -0.089     0.200
     0.502     0.160     0.200
     0.502    -0.240     0.200
     0.502     0.650     0.200
     0.531    -0.678     0.200
     0.531     0.022     0.200
     0.579    -0.273     0.200
     0.577     0.075     0.200
     0.577     1.255     0.200
     0.612    -0.640     0.200
     0.607     1.051     0.200
     0.693    -0.078     0.200
     0.723    -0.852     0.200
     0.737     0.664     0.200
     0.744    -0.718     0.200
     0.750     0.556     0.200
     0.762    -1.103     0.200
     0.765    -0.642     0.200
     0.782    -0.376     0.200
     0.816     0.299     0.200
     0.409    -1.286     0.200
     0.439     0.299     0.200
     0.456     0.131     0.200
     0.471    -1.640     0.200
     0.481     0.119     0.200
     0.478    -0.649     0.200
     0.478    -0.024     0.200
     0.489    -0.397     0.200
     0.468    -0.988     0.200
     0.468    -1.332     0.200
     0.566     0.478     0.200
     0.566     0.494     0.200
     0.604     0.041     0.200
     0.547    -0.048     0.200
     0.618    -1.092     0.200
     0.613     0.442     0.200
     0.735     0.783     0.200
     0.707    -0.008     0.200
     0.773     0.742     0.200
     0.777    -0.365     0.200
     0.777    -0.544     0.200
     0.766    -0.285     0.200
     0.766     0.238     0.200
     0.814    -1.440     0.200
     0.843    -1.560     0.200
     0.921    -0.956     0.200
     0.536    -0.947     0.200
     0.536    -0.783     0.200
     0.610    -0.910     0.200
     0.617     0.770     0.200
     0.618     0.708     0.200
     0.695    -0.368     0.200
     0.983    -0.816     0.200
     0.442    -0.236     0.200
     0.456    -0.166     0.200
     0.616     0.803     0.200
     0.480    -0.162     0.200
     0.489    -0.579     0.200
     0.493    -0.061     0.200
     0.568    -0.286     0.200
     0.572    -0.197     0.200
     0.603    -0.575     0.200
     0.729     0.405     0.200
     0.757    -0.345     0.200
     0.741     0.658     0.200
     0.773    -0.105     0.200
     0.777     0.633     0.200
     0.807     0.218     0.200
     0.985    -0.495     0.200
     0.394    -1.309     0.200
     0.394    -1.139     0.200
     0.433     0.428     0.200
     0.456     0.298     0.200
     0.465    -0.523     0.200
     0.465    -0.683     0.200
     0.454    -1.084     0.200
     0.482     0.059     0.200
     0.480     0.046     0.200
     0.554    -0.193     0.200
     0.562     0.540     0.200
     0.562     0.519     0.200
     0.564    -0.216     0.200
     0.564    -0.096     0.200
     0.604     0.137     0.200
     0.604    -1.222     0.200
     0.730     0.375     0.200
     0.723     0.520     0.200
     0.767     0.971     0.200
     0.830    -0.794     0.200
     0.838    -0.859     0.200
     0.401    -1.295     0.200
     0.401    -1.407     0.200
     0.401    -1.056     0.200
     0.401    -0.247     0.200
     0.436    -1.115     0.200
     0.436    -0.804     0.200
     0.461     0.822     0.200
     0.461    -1.038     0.200
     0.481    -0.516     0.200
     0.481    -0.626     0.200
     0.481     0.003     0.200
     0.486     0.646     0.200
     0.509     0.260     0.200
     0.509     0.010     0.200
     0.505    -0.492     0.200
     0.505     0.199     0.200
     0.505    -0.982     0.200
     0.578    -0.008     0.200
     0.591     0.853     0.200
     0.591     0.004     0.200
     0.583     0.397     0.200
     0.564     0.430     0.200
     0.634     0.594     0.200
     0.634     0.174     0.200
     0.652    -0.217     0.200
     0.652    -0.047     0.200
     0.744    -0.289     0.200
     0.890    -0.694     0.200
     0.357    -1.050     0.200
     0.467    -0.035     0.200
     0.506     0.478     0.200
     0.515    -0.526     0.200
     0.515     0.306     0.200
     0.579     0.401     0.200
     0.590     0.995     0.200
     0.587     0.405     0.200
     0.639     0.457     0.200
     0.665    -0.503     0.200
     0.665     0.399     0.200
     0.665     0.899     0.200
     0.720    -1.358     0.200
     0.730    -1.621     0.200
     0.391    -1.200     0.200
     0.488    -0.215     0.200
     0.508     0.056     0.200
     0.513     0.195     0.200
     0.513    -0.485     0.200
     0.564     0.159     0.200
     0.569     0.404     0.200
     0.607    -0.753     0.200
     0.607    -0.081     0.200
     0.644     0.572     0.200
     0.644     0.584     0.200
     0.614    -0.225     0.200
     0.614    -1.307     0.200
     0.623    -0.069     0.200
     0.623     0.124     0.200
     0.623     0.104     0.200
     0.668     0.027     0.200
     0.695    -0.005     0.200
     0.701    -1.137     0.200
     0.701     0.351     0.200
     0.765    -0.433     0.200
     0.774    -0.252     0.200
     0.896    -0.722     0.200
     0.926    -1.772     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.014
 0.60    0.014
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.598
 0.60   -0.598
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 0.60    0.1
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.3
 0.60   -0.3
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.6)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.6 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.3 (dashed green line)
EOF
gmt end
