#!/bin/bash
gmt begin elmayor5.35_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic elmayor5.35'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.725
   137.000     1.817
   137.500     1.912
   138.000     2.010
   138.500     2.111
   139.000     2.217
   139.500     2.325
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.802
   142.000     2.932
   142.500     3.067
   143.000     3.207
   143.500     3.352
   144.000     3.503
   144.500     3.659
   145.000     3.821
   145.500     3.990
   146.000     4.164
   146.500     4.346
   147.000     4.534
   147.500     4.730
   148.000     4.933
   148.500     5.144
   149.000     5.363
   149.500     5.592
   150.000     5.830
   150.500     6.078
   151.000     6.336
   151.500     6.605
   152.000     6.883
   152.500     7.172
   153.000     7.471
   153.500     7.780
   154.000     8.101
   154.500     8.432
   155.000     8.774
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.689
   145.500     0.274
   146.000     1.301
   146.500     2.370
   147.000     3.474
   147.500     4.608
   148.000     5.769
   148.500     6.955
   149.000     8.165
   149.500     9.397
   150.000    10.652
   150.500    11.928
   151.000    13.224
   151.500    14.541
   152.000    15.876
   152.500    17.229
   153.000    18.600
   153.500    19.990
   154.000    21.396
   154.500    22.821
   155.000    24.262
   155.500    25.720
   156.000    27.196
   156.500    28.688
   157.000    30.197
   157.500    31.722
   158.000    33.264
   158.500    34.823
   159.000    36.398
   159.500    37.989
   160.000    39.597
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.692
   145.500     0.075
   146.000     0.768
   146.500     1.410
   147.000     2.009
   147.500     2.569
   148.000     3.094
   148.500     3.586
   149.000     4.052
   149.500     4.498
   150.000     4.928
   150.500     5.346
   151.000     5.752
   151.500     6.149
   152.000     6.538
   152.500     6.919
   153.000     7.295
   153.500     7.666
   154.000     8.035
   154.500     8.402
   155.000     8.766
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   142.710    -1.434     0.200
   144.726    -0.367     0.200
   144.726    -0.879     0.200
   144.793    -0.590     0.200
   145.951     0.758     0.200
   144.709    -0.594     0.200
   145.040     1.148     0.200
   144.744    -0.624     0.200
   144.744    -0.765     0.200
   145.130     0.748     0.200
   144.715     1.190     0.200
   144.781     0.923     0.200
   144.991     1.062     0.200
   137.798     0.300     0.200
   137.823    -1.511     0.200
   139.643    -1.049     0.200
   142.773    -0.776     0.200
   143.108    -3.196     0.200
   144.611     0.697     0.200
   149.913     4.002     0.200
   151.220    -1.053     0.200
   144.324     0.005     0.200
   142.725     0.031     0.200
   144.517     0.925     0.200
   144.993     0.162     0.200
   144.545    -1.624     0.200
   145.915     0.628     0.200
   144.621    -1.070     0.200
   144.771    -0.987     0.200
   144.277    -0.329     0.200
   144.277    -0.816     0.200
   144.855     0.467     0.200
   144.855     0.867     0.200
   145.674     1.458     0.200
   144.477    -1.396     0.200
   142.780    -1.799     0.200
   144.555    -2.396     0.200
   144.592    -1.380     0.200
   145.006     0.465     0.200
   146.331    -0.048     0.200
   136.408    -0.387     0.200
   141.054    -1.004     0.200
   143.134    -1.392     0.200
   143.134    -1.110     0.200
   145.024    -0.390     0.200
   145.575     1.452     0.200
   146.472     2.191     0.200
   148.098     2.395     0.200
   144.452    -1.249     0.200
   144.975     0.932     0.200
   144.524    -1.271     0.200
   144.531    -1.618     0.200
   144.526    -1.192     0.200
   144.738    -1.161     0.200
   144.729    -1.807     0.200
   144.739     0.223     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   145.041     0.489     0.200
   145.078     0.652     0.200
   145.068     0.081     0.200
   145.063     0.408     0.200
   145.080     0.764     0.200
   145.024    -0.697     0.200
   145.898     0.049     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   145.953     1.581     0.200
   145.969     1.472     0.200
   145.976     1.542     0.200
   145.905     1.993     0.200
   147.598     5.429     0.200
   147.760     6.715     0.200
   147.768     6.256     0.200
   147.849     4.693     0.200
   147.991     8.177     0.200
   145.998     1.149     0.200
   145.862     1.706     0.200
   145.575     1.842     0.200
   146.472     2.297     0.200
   147.198     3.347     0.200
   145.813     1.892     0.200
   145.737     1.960     0.200
   145.581     1.552     0.200
   145.910     1.266     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   135.894     1.836     0.200
   145.951     2.782     0.200
   145.972     2.451     0.200
   145.998     2.433     0.200
   145.059     1.752     0.200
   145.925     3.026     0.200
   142.647     3.361     0.200
   135.932     4.670     0.200
   136.126     1.317     0.200
   137.134     0.626     0.200
   137.823     3.590     0.200
   139.643     1.850     0.200
   139.643     1.647     0.200
   139.716     3.780     0.200
   140.538     1.430     0.200
   142.773     2.896     0.200
   145.072     3.305     0.200
   145.926     2.841     0.200
   146.465     4.177     0.200
   146.631     6.349     0.200
   147.208     5.999     0.200
   147.235     4.626     0.200
   151.220     6.361     0.200
   151.220     8.494     0.200
   145.855     2.703     0.200
   139.650     1.386     0.200
   145.838     2.666     0.200
   139.685     2.369     0.200
   145.911     2.356     0.200
   145.911     2.856     0.200
   136.408     2.042     0.200
   137.460     1.474     0.200
   139.723     3.588     0.200
   139.723     2.457     0.200
   139.723     3.906     0.200
   147.613     4.105     0.200
   147.728     3.836     0.200
   148.204     4.441     0.200
   148.384     4.826     0.200
   145.822     2.288     0.200
   145.901     2.958     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
