#!/bin/bash
gmt begin elmayor5.35_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P elmayor5.35'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.710
    79.000     8.535
    80.000     7.445
    81.000     6.440
    82.000     5.521
    83.000     4.686
    84.000     3.935
    85.000     3.271
    86.000     2.693
    87.000     2.193
    88.000     1.797
    89.000     1.498
    90.000     1.240
    91.000     1.013
    92.000     0.812
    93.000     0.630
    94.000     0.465
    95.000     0.319
    96.000     0.200
    97.000     0.107
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.161     5.051     0.200
    14.369     4.761     0.200
    14.548     4.602     0.200
    14.649     6.402     0.200
    15.216     4.406     0.200
    16.117     4.249     0.200
    16.688     2.636     0.200
    17.380     2.882     0.200
    17.868     4.675     0.200
    18.504     0.913     0.200
    19.242     1.370     0.200
    20.400     0.587     0.200
    20.871     0.976     0.200
    21.029    -0.327     0.200
    21.275     1.024     0.200
    21.427    -1.364     0.200
    21.663     1.446     0.200
    21.722     1.387     0.200
    21.778     1.317     0.200
    22.123     2.269     0.200
    22.655     2.314     0.200
    22.750     0.966     0.200
    22.951     1.432     0.200
    23.193     1.773     0.200
    23.770    -0.040     0.200
    24.237     0.697     0.200
    24.219     0.556     0.200
    24.295     1.062     0.200
    24.500     1.241     0.200
    26.411     2.946     0.200
    26.389     2.416     0.200
    27.059     1.122     0.200
    27.909     2.113     0.200
    27.909     2.387     0.200
    28.401     0.504     0.200
    28.599     1.161     0.200
    28.648     1.230     0.200
    28.913     1.147     0.200
    29.359    -0.084     0.200
    29.413     0.612     0.200
    29.441     1.846     0.200
    29.993     1.174     0.200
    30.127     0.982     0.200
    30.195     1.458     0.200
    30.579     0.145     0.200
    30.967     0.859     0.200
    32.502     1.551     0.200
    33.764     0.996     0.200
    33.948     0.662     0.200
    34.296     1.095     0.200
    34.494     1.496     0.200
    34.540     2.959     0.200
    35.086     2.759     0.200
    35.568     1.017     0.200
    35.849     1.891     0.200
    35.849     3.061     0.200
    36.476     2.981     0.200
    37.480     2.086     0.200
    37.480     1.536     0.200
    37.779     2.412     0.200
    38.150     3.074     0.200
    38.219     6.496     0.200
    38.801     1.494     0.200
    39.893     2.286     0.200
    40.574     0.291     0.200
    40.574     0.480     0.200
    43.559     0.677     0.200
    45.671     1.513     0.200
    46.259     1.674     0.200
    46.259     1.276     0.200
    46.453     3.101     0.200
    46.769     1.114     0.200
    46.793     0.009     0.200
    47.006     0.205     0.200
    47.020     3.424     0.200
    47.126     3.427     0.200
    47.352     3.106     0.200
    47.408     1.822     0.200
    47.408     1.468     0.200
    47.619     2.024     0.200
    49.810     1.686     0.200
    50.762     1.955     0.200
    50.762     2.095     0.200
    52.705     3.712     0.200
    53.457     0.739     0.200
    55.499     1.488     0.200
    56.045     3.482     0.200
    56.045     2.291     0.200
    60.246     0.566     0.200
    66.159     1.898     0.200
    66.159     1.248     0.200
    67.129    -1.146     0.200
    67.129     1.554     0.200
    70.377     2.696     0.200
    72.473     1.756     0.200
    72.473     2.376     0.200
    74.427     0.773     0.200
    74.427     0.797     0.200
    74.454     2.592     0.200
    77.244     1.659     0.200
    77.244     0.684     0.200
    77.272     1.280     0.200
    77.593     5.103     0.200
    77.648     1.295     0.200
    79.284    -2.438     0.200
    79.304     0.456     0.200
    79.615     0.461     0.200
    79.734     0.611     0.200
    80.073     2.178     0.200
    80.332     1.557     0.200
    80.332     0.782     0.200
    80.469     1.745     0.200
    80.505     0.552     0.200
    80.544     0.541     0.200
    80.796     0.289     0.200
    80.910     3.486     0.200
    81.094     0.103     0.200
    81.199     2.845     0.200
    81.374     0.514     0.200
    81.493     2.983     0.200
    81.522     0.931     0.200
    81.997     0.226     0.200
    82.044    -0.121     0.200
    82.158     1.813     0.200
    82.262     0.635     0.200
    82.307     0.103     0.200
    82.416     3.630     0.200
    82.693     2.485     0.200
    82.982     0.960     0.200
    82.983     0.980     0.200
    82.983     1.680     0.200
    82.983     0.680     0.200
    83.190     1.208     0.200
    83.318    -0.250     0.200
    83.492     0.054     0.200
    83.591     2.546     0.200
    83.646     0.362     0.200
    83.651     0.137     0.200
    83.652     0.235     0.200
    83.692     2.726     0.200
    83.692     0.425     0.200
    83.659     2.294     0.200
    83.753    -0.185     0.200
    83.766     0.346     0.200
    84.099     2.449     0.200
    84.100    -0.359     0.200
    84.163     1.637     0.200
    84.166     0.408     0.200
    84.307    -0.212     0.200
    84.427     0.382     0.200
    84.439     2.023     0.200
    84.444     2.395     0.200
    84.465     2.087     0.200
    84.592     0.248     0.200
    84.628     2.666     0.200
    84.672     2.441     0.200
    84.734     2.128     0.200
    84.803     0.283     0.200
    84.833     1.331     0.200
    84.914     2.124     0.200
    85.066     1.862     0.200
    85.114     0.219     0.200
    85.260     0.489     0.200
    85.315     0.114     0.200
    85.367     1.755     0.200
    85.431     0.335     0.200
    85.710     2.149     0.200
    85.736     0.219     0.200
    85.785     2.207     0.200
    85.831     0.148     0.200
    85.866     2.013     0.200
    86.103     1.701     0.200
    86.342     0.524     0.200
    86.365     0.513     0.200
    86.637     0.773     0.200
    86.942     1.583     0.200
    87.211     0.538     0.200
    87.657     0.223     0.200
    87.743     0.215     0.200
    87.855    -0.122     0.200
    88.454     1.841     0.200
    89.558     2.253     0.200
    89.588     3.412     0.200
    89.588     3.712     0.200
    89.588     2.412     0.200
    90.213     2.293     0.200
    90.452     3.180     0.200
    90.525     2.740     0.200
    90.813     3.200     0.200
    91.072     1.397     0.200
    91.382     2.056     0.200
    91.525     0.821     0.200
    91.558     3.442     0.200
    91.558     0.093     0.200
    91.834     2.463     0.200
    93.631     0.070     0.200
    94.146     1.204     0.200
    94.308     3.265     0.200
    94.613    -0.041     0.200
    94.780     2.498     0.200
    94.943     1.350     0.200
    96.020     1.795     0.200
    96.357     1.606     0.200
    97.306     1.005     0.200
    98.025     1.370     0.200
    14.606     8.602     0.200
    15.935     3.103     0.200
    15.935     3.892     0.200
    30.139     0.364     0.200
    37.786     2.247     0.200
    83.320    -4.498     0.200
    95.273    -2.499     0.200
    15.925     3.393     0.200
    16.514     2.815     0.200
    16.770     3.779     0.200
    20.867    -0.046     0.200
    37.792     0.504     0.200
    83.342    -2.990     0.200
    14.533     7.032     0.200
    14.628     4.534     0.200
    15.912     3.597     0.200
    15.912     3.363     0.200
    16.527     3.261     0.200
    16.674     2.779     0.200
    16.792     1.697     0.200
    17.374     4.336     0.200
    18.202     0.581     0.200
    20.378     0.844     0.200
    20.858     0.032     0.200
    21.007     0.826     0.200
    22.729     0.842     0.200
    22.930     1.359     0.200
    23.749     0.377     0.200
    27.902     3.023     0.200
    27.902     2.797     0.200
    30.114     2.023     0.200
    35.080     2.257     0.200
    36.472     0.930     0.200
    37.471     1.231     0.200
    37.773     2.377     0.200
    74.411    -0.135     0.200
    81.356     0.452     0.200
    83.320    -0.267     0.200
    86.105     1.884     0.200
    91.506     0.296     0.200
    22.720    -0.315     0.200
    82.661    -2.950     0.200
    92.994    -1.511     0.200
    94.653    -0.037     0.200
    14.083     4.761     0.200
    14.212     4.618     0.200
    14.280     4.591     0.200
    14.762     4.275     0.200
    14.990     4.035     0.200
    15.123     3.832     0.200
    15.148     3.508     0.200
    15.425     3.523     0.200
    15.720     2.945     0.200
    15.897     2.779     0.200
    15.978     2.643     0.200
    16.116     2.885     0.200
    16.141     5.577     0.200
    16.565     2.384     0.200
    16.599     2.455     0.200
    16.624     3.009     0.200
    16.715     1.567     0.200
    16.854     1.929     0.200
    17.012     2.781     0.200
    17.262     3.547     0.200
    17.304     4.169     0.200
    18.067     1.147     0.200
    18.067     0.996     0.200
    19.368     1.091     0.200
    20.411     0.815     0.200
    20.808     0.521     0.200
    21.041     0.997     0.200
    21.285     1.473     0.200
    21.356     2.900     0.200
    21.444     1.295     0.200
    21.471    -1.126     0.200
    21.588     0.816     0.200
    21.811     0.393     0.200
    21.959     1.146     0.200
    22.142     1.797     0.200
    22.342     0.856     0.200
    22.368     1.188     0.200
    22.773     0.936     0.200
    22.886    -0.119     0.200
    22.954     0.855     0.200
    22.971     1.083     0.200
    23.206     2.051     0.200
    23.748    -0.198     0.200
    23.798     1.433     0.200
    23.974     1.480     0.200
    24.027     2.483     0.200
    24.187     0.210     0.200
    24.229     1.132     0.200
    24.287     0.874     0.200
    24.308     0.709     0.200
    24.523     0.490     0.200
    25.667     0.681     0.200
    26.268     1.882     0.200
    26.430     1.296     0.200
    26.696     0.641     0.200
    26.806     0.653     0.200
    26.876     0.416     0.200
    27.066     0.749     0.200
    27.834     2.872     0.200
    28.929     0.768     0.200
    29.422     0.702     0.200
    29.468     1.491     0.200
    29.947     1.156     0.200
    30.061     0.929     0.200
    30.974     0.740     0.200
    31.454     2.980     0.200
    35.011     2.436     0.200
    35.637     0.626     0.200
    35.637     0.732     0.200
    35.637    -0.133     0.200
    36.046     2.380     0.200
    36.398     2.705     0.200
    37.674     2.068     0.200
    38.074     1.084     0.200
    38.254     0.971     0.200
    38.327     1.747     0.200
    38.724     2.020     0.200
    40.371     2.210     0.200
    40.552    -0.131     0.200
    43.499     0.529     0.200
    43.499     0.004     0.200
    45.638     1.188     0.200
    46.815     1.501     0.200
    47.086     1.953     0.200
    47.262     2.861     0.200
    47.468     0.888     0.200
    52.779     2.984     0.200
    53.397     0.551     0.200
    55.451     2.461     0.200
    55.968     2.404     0.200
    55.968     2.275     0.200
    62.658     2.138     0.200
    63.075     1.864     0.200
    67.054     0.606     0.200
    67.054     0.305     0.200
    70.452     2.860     0.200
    72.396     1.590     0.200
    74.378     0.905     0.200
    74.372     0.091     0.200
    77.199     1.406     0.200
    77.450    -0.021     0.200
    77.626     3.294     0.200
    77.712     1.687     0.200
    77.906     1.536     0.200
    78.700     1.449     0.200
    79.207    -2.042     0.200
    80.405     1.389     0.200
    81.017    -0.312     0.200
    81.966     2.468     0.200
    82.294     2.144     0.200
    83.241    -4.380     0.200
    83.465     2.968     0.200
    83.623     1.758     0.200
    83.630     2.922     0.200
    83.664     2.149     0.200
    83.737     0.399     0.200
    84.144     2.495     0.200
    84.146     0.358     0.200
    84.396     1.915     0.200
    84.560     2.984     0.200
    84.567     1.551     0.200
    84.772     1.715     0.200
    84.777     1.389     0.200
    84.977     1.283     0.200
    85.029     3.425     0.200
    85.117     2.580     0.200
    85.407     2.731     0.200
    85.458     4.478     0.200
    85.458     4.478     0.200
    85.747     2.641     0.200
    86.313     2.942     0.200
    86.336     2.231     0.200
    87.175     2.414     0.200
    89.505     1.975     0.200
    89.511     2.947     0.200
    89.511     2.648     0.200
    89.511     2.228     0.200
    90.375     3.513     0.200
    90.736     2.034     0.200
    91.478    -0.136     0.200
    91.608     1.786     0.200
    91.757     2.417     0.200
    92.207     2.289     0.200
    94.739     1.296     0.200
    95.192    -0.814     0.200
    96.285     2.123     0.200
    96.388     1.657     0.200
    97.949    -2.814     0.200
    14.166     7.196     0.200
    14.500     6.404     0.200
    14.547     4.713     0.200
    14.560     4.718     0.200
    14.624     5.037     0.200
    14.627     7.536     0.200
    14.871     6.438     0.200
    15.436     4.525     0.200
    15.798     3.749     0.200
    16.151     5.570     0.200
    16.295     5.954     0.200
    16.634     3.200     0.200
    16.662     7.670     0.200
    16.762     2.776     0.200
    16.848     3.027     0.200
    16.852     2.198     0.200
    16.967     2.640     0.200
    17.004     2.876     0.200
    17.189     2.366     0.200
    17.306     2.591     0.200
    17.315     4.993     0.200
    17.741     3.584     0.200
    18.249     1.456     0.200
    20.818     0.420     0.200
    20.945     2.455     0.200
    21.044     2.284     0.200
    21.288     0.353     0.200
    21.595     0.710     0.200
    22.346     0.718     0.200
    22.894    -0.295     0.200
    22.956     1.754     0.200
    22.972     0.374     0.200
    23.755     2.544     0.200
    23.799     3.458     0.200
    24.027     3.390     0.200
    24.197     0.016     0.200
    24.232     0.095     0.200
    24.292     0.322     0.200
    26.269     1.387     0.200
    27.069     0.642     0.200
    27.845     3.322     0.200
    30.072     0.784     0.200
    31.448     5.209     0.200
    35.021     2.951     0.200
    36.056     3.048     0.200
    36.408     1.810     0.200
    37.684     0.267     0.200
    37.976     1.269     0.200
    38.264     0.278     0.200
    38.959     3.143     0.200
    40.381     3.033     0.200
    45.728    -0.184     0.200
    46.514     1.357     0.200
    47.080     3.503     0.200
    47.189     1.214     0.200
    47.255     1.810     0.200
    47.367     1.276     0.200
    50.730     3.983     0.200
    52.771     2.373     0.200
    55.461     1.605     0.200
    55.978     1.910     0.200
    55.978    -0.215     0.200
    63.083     3.325     0.200
    67.064    -0.693     0.200
    67.064     2.674     0.200
    72.406     2.794     0.200
    72.406     1.466     0.200
    77.208     0.993     0.200
    80.397     0.715     0.200
    81.027     2.093     0.200
    82.917     3.703     0.200
    83.250    -2.966     0.200
    83.472     3.187     0.200
    83.637     2.047     0.200
    83.671     1.971     0.200
    84.404     1.838     0.200
    84.780     1.438     0.200
    84.787     0.301     0.200
    84.939     5.731     0.200
    85.466     6.296     0.200
    85.466     6.296     0.200
    86.035    -0.030     0.200
    87.183     1.617     0.200
    89.521     1.655     0.200
    89.521     0.327     0.200
    90.746     0.246     0.200
    91.487    -0.171     0.200
    91.767     4.941     0.200
    92.218     4.176     0.200
    93.563    -1.484     0.200
    95.202    -1.298     0.200
    97.635    -3.444     0.200
    97.957    -0.394     0.200
    99.223    -2.263     0.200
    14.283     4.423     0.200
    14.311     4.684     0.200
    14.552     4.342     0.200
    14.846     3.303     0.200
    14.852     4.227     0.200
    15.125     3.988     0.200
    15.149     3.020     0.200
    15.860     2.580     0.200
    16.126     2.359     0.200
    16.142     5.549     0.200
    16.284     5.463     0.200
    16.570     3.189     0.200
    16.631     2.826     0.200
    16.870     1.384     0.200
    17.306     3.555     0.200
    17.531     0.893     0.200
    18.080     1.801     0.200
    20.429     0.547     0.200
    20.815     0.765     0.200
    21.059     0.129     0.200
    21.303     1.605     0.200
    21.603     1.165     0.200
    21.977     1.138     0.200
    22.359     1.194     0.200
    22.386     1.090     0.200
    22.791     1.050     0.200
    22.900     1.997     0.200
    22.989     1.616     0.200
    23.816     2.193     0.200
    23.984     1.488     0.200
    24.044     2.555     0.200
    24.199     0.604     0.200
    24.303     1.200     0.200
    27.836     2.680     0.200
    30.068     0.463     0.200
    43.508    -0.006     0.200
    47.272     1.718     0.200
    55.464     0.999     0.200
    55.966     2.991     0.200
    55.966     2.530     0.200
    62.655     2.030     0.200
    63.068     0.553     0.200
    67.055     2.166     0.200
    70.802     0.940     0.200
    77.212     2.574     0.200
    78.712     1.866     0.200
    83.236    -0.190     0.200
    86.021     0.939     0.200
    89.511     3.605     0.200
    90.735     1.593     0.200
    93.549    -2.122     0.200
    95.189    -3.042     0.200
    97.942     0.072     0.200
    14.286     5.103     0.200
    14.392     7.215     0.200
    15.847     1.818     0.200
    30.054    -0.240     0.200
    14.288     4.960     0.200
    14.528     6.863     0.200
    15.849     3.630     0.200
    21.595     1.147     0.200
    23.991     2.188     0.200
    14.300     4.811     0.200
    15.137     4.738     0.200
    15.294     5.720     0.200
    16.493     3.448     0.200
    16.620     2.335     0.200
    17.294     1.667     0.200
    18.499    -0.672     0.200
    19.944    -0.894     0.200
    20.427     1.042     0.200
    20.804     0.656     0.200
    20.963     0.813     0.200
    21.057    -0.877     0.200
    21.158     0.441     0.200
    21.595     1.242     0.200
    21.706     0.848     0.200
    22.354    -1.479     0.200
    22.790     0.842     0.200
    22.892     2.211     0.200
    22.969     0.340     0.200
    22.987     0.410     0.200
    23.222     1.585     0.200
    23.992     2.195     0.200
    24.045     2.109     0.200
    24.189    -0.250     0.200
    24.540     0.263     0.200
    25.683     0.217     0.200
    27.081     1.610     0.200
    27.825     3.138     0.200
    27.825     2.935     0.200
    30.057     0.622     0.200
    31.473     1.136     0.200
    36.386     0.120     0.200
    37.662     0.071     0.200
    38.063     0.989     0.200
    38.063     0.864     0.200
    38.710     1.378     0.200
    40.360     3.360     0.200
    40.705     1.110     0.200
    43.497     1.351     0.200
    47.280     2.181     0.200
    47.487     0.998     0.200
    55.454     1.126     0.200
    55.955     2.104     0.200
    62.645     2.647     0.200
    63.059     5.389     0.200
    67.044     3.387     0.200
    72.384     3.584     0.200
    74.362     0.920     0.200
    74.379     2.334     0.200
    76.677     2.343     0.200
    77.203     3.434     0.200
    80.422     2.617     0.200
    81.005    -0.534     0.200
    83.226    -0.183     0.200
    83.432     0.959     0.200
    83.626     1.060     0.200
    83.630    -0.164     0.200
    83.671     1.330     0.200
    83.733     0.711     0.200
    84.080     0.843     0.200
    84.779     1.099     0.200
    84.976     0.907     0.200
    85.038     1.295     0.200
    85.238     0.998     0.200
    86.011     1.451     0.200
    89.500     3.424     0.200
    90.724     2.906     0.200
    91.468     3.054     0.200
    91.481     3.222     0.200
    92.199     2.947     0.200
    93.539    -0.713     0.200
    95.178     0.073     0.200
    97.933     0.277     0.200
    14.303     4.865     0.200
    14.400     7.417     0.200
    14.494     4.995     0.200
    14.533     3.338     0.200
    14.840     3.179     0.200
    15.075     6.625     0.200
    15.116     3.968     0.200
    15.141     3.931     0.200
    15.234     4.244     0.200
    15.299     6.521     0.200
    15.388     3.151     0.200
    15.427     4.297     0.200
    15.604     5.680     0.200
    15.628     2.910     0.200
    15.853     2.740     0.200
    16.062     3.042     0.200
    16.121     3.442     0.200
    16.496     3.467     0.200
    16.573     1.422     0.200
    16.625     3.122     0.200
    16.877     1.396     0.200
    17.297     4.614     0.200
    17.537     2.280     0.200
    18.077     1.390     0.200
    18.271     0.702     0.200
    19.951     0.334     0.200
    20.433     0.067     0.200
    20.809    -0.067     0.200
    21.063     0.810     0.200
    22.796     0.415     0.200
    22.899     1.634     0.200
    22.975     0.918     0.200
    22.993     1.106     0.200
    23.994     1.678     0.200
    24.195     1.010     0.200
    27.827     1.881     0.200
    29.956     1.309     0.200
    30.062     0.576     0.200
    43.502     1.734     0.200
    47.281     2.759     0.200
    55.460     0.570     0.200
    63.059     4.782     0.200
    77.209     2.196     0.200
    84.163     1.664     0.200
    14.188     9.439     0.200
    14.343     4.936     0.200
    14.355     4.668     0.200
    14.538     4.421     0.200
    15.436     3.574     0.200
    15.656     5.014     0.200
    15.903     3.468     0.200
    16.163     2.886     0.200
    16.186     5.298     0.200
    17.350     2.477     0.200
    18.112     1.677     0.200
    19.279     0.499     0.200
    20.432     1.626     0.200
    20.856    -0.095     0.200
    20.952     1.834     0.200
    21.856     4.409     0.200
    21.978     0.680     0.200
    22.927    -0.120     0.200
    22.975     1.848     0.200
    22.987    -1.177     0.200
    23.785     1.242     0.200
    23.949     0.907     0.200
    27.089     0.339     0.200
    29.992     1.477     0.200
    30.110     0.369     0.200
    36.091     1.874     0.200
    37.455     1.759     0.200
    37.455    -0.506     0.200
    38.654     2.597     0.200
    40.760    -2.250     0.200
    46.499     3.207     0.200
    47.066     2.167     0.200
    47.171     1.818     0.200
    47.236     2.724     0.200
    47.397     2.627     0.200
    56.010     4.193     0.200
    60.949     0.990     0.200
    67.099     0.335     0.200
    80.376     0.784     0.200
    86.063     1.313     0.200
    91.524     2.083     0.200
    92.254     3.415     0.200
    94.787     1.912     0.200
    95.231    -1.362     0.200
    97.982     0.268     0.200
    23.062    -0.460     0.200
    14.386     4.321     0.200
    14.398     5.302     0.200
    14.609     9.194     0.200
    15.154     5.366     0.200
    15.215     3.941     0.200
    15.233     2.967     0.200
    15.379     2.842     0.200
    15.470     3.207     0.200
    15.700     4.740     0.200
    15.894     1.533     0.200
    15.941     2.965     0.200
    16.186     1.691     0.200
    16.377     3.541     0.200
    16.556     3.593     0.200
    16.704     2.468     0.200
    16.807     2.616     0.200
    17.397     4.443     0.200
    17.476     2.233     0.200
    18.225     0.055     0.200
    20.888     0.131     0.200
    21.033     0.764     0.200
    21.628     0.245     0.200
    22.932     0.660     0.200
    22.954     0.846     0.200
    23.892     2.304     0.200
    24.310     0.455     0.200
    27.926     3.323     0.200
    27.926     2.894     0.200
    30.144     1.396     0.200
    35.935     3.090     0.200
    36.138     2.285     0.200
    37.298     2.964     0.200
    37.497     2.353     0.200
    37.497     2.009     0.200
    37.767     2.543     0.200
    37.795     2.731     0.200
    38.420     2.527     0.200
    38.704     2.078     0.200
    39.909     1.957     0.200
    47.180     2.498     0.200
    77.258     1.524     0.200
    81.390     1.494     0.200
    83.332    -3.426     0.200
    86.118    -2.280     0.200
    86.392    -0.743     0.200
    86.610    -0.755     0.200
    86.795    -0.896     0.200
    88.952     2.388     0.200
    91.850     1.478     0.200
    92.297     1.286     0.200
    93.646    -3.505     0.200
    95.285    -2.123     0.200
    14.335     5.049     0.200
    14.692     3.252     0.200
    14.901     3.265     0.200
    15.162     2.962     0.200
    15.613     2.291     0.200
    15.901     2.789     0.200
    16.052     4.272     0.200
    16.232     1.634     0.200
    16.526     1.954     0.200
    16.531     1.468     0.200
    16.620     1.680     0.200
    16.670     1.730     0.200
    16.677     2.695     0.200
    16.678     1.826     0.200
    16.896     2.163     0.200
    18.033     1.084     0.200
    18.133     0.999     0.200
    20.999     2.964     0.200
    21.657     0.711     0.200
    22.955    -0.706     0.200
    23.986     0.483     0.200
    31.392     2.824     0.200
    35.653     0.050     0.200
    37.448     2.114     0.200
    37.731     1.238     0.200
    47.274     1.809     0.200
    52.782     3.191     0.200
    55.516     1.503     0.200
    55.991     0.595     0.200
    66.238     1.741     0.200
    86.034    -1.528     0.200
    89.567     2.042     0.200
    92.246     1.112     0.200
    93.565    -1.594     0.200
    95.207    -1.729     0.200
    97.951    -1.671     0.200
    24.164    -0.619     0.200
    37.559     1.593     0.200
    95.025    -3.131     0.200
    97.768    -2.280     0.200
    15.969     4.252     0.200
    16.569     4.030     0.200
    16.804     0.540     0.200
    18.230     1.189     0.200
    22.962    -0.448     0.200
    30.172     0.356     0.200
    37.821     1.964     0.200
    47.163     1.472     0.200
    56.086     2.069     0.200
    81.416     0.963     0.200
    91.875     2.541     0.200
    92.325     0.504     0.200
    23.356     0.063     0.200
    30.403     0.271     0.200
    37.891     1.142     0.200
    95.280    -2.941     0.200
    95.280    -2.141     0.200
    14.474     4.107     0.200
    15.362     2.836     0.200
    15.464     3.618     0.200
    15.562     2.988     0.200
    15.635     3.383     0.200
    15.657     3.782     0.200
    15.682     2.752     0.200
    15.934     2.908     0.200
    15.934     2.501     0.200
    15.985     3.592     0.200
    16.570     1.931     0.200
    16.792     2.773     0.200
    17.385     1.087     0.200
    18.243     1.897     0.200
    19.957    -0.270     0.200
    20.884     0.667     0.200
    20.913     1.596     0.200
    20.931     1.663     0.200
    21.295     1.076     0.200
    21.632     2.912     0.200
    21.636     0.872     0.200
    21.683    -1.271     0.200
    22.368    -0.872     0.200
    22.385    -0.058     0.200
    22.770     1.415     0.200
    22.964     1.633     0.200
    22.972     1.832     0.200
    23.214     0.272     0.200
    23.788     1.565     0.200
    23.990     3.296     0.200
    24.011     3.188     0.200
    24.240     1.581     0.200
    24.321     1.205     0.200
    35.849     3.265     0.200
    36.126     3.048     0.200
    36.408     3.498     0.200
    36.478     3.655     0.200
    37.283     3.760     0.200
    37.384     3.274     0.200
    37.754     3.473     0.200
    37.783     1.891     0.200
    37.783     1.172     0.200
    37.783     1.172     0.200
    38.406     3.096     0.200
    38.672     2.724     0.200
    38.802     2.067     0.200
    40.772     1.748     0.200
    40.797    -0.245     0.200
    47.199     3.050     0.200
    55.516     1.241     0.200
    81.390     0.516     0.200
    81.390     0.516     0.200
    82.259    -0.193     0.200
    82.328    -0.551     0.200
    83.512     0.409     0.200
    83.670     0.701     0.200
    83.671     0.991     0.200
    83.659     2.300     0.200
    83.712     1.381     0.200
    83.766     0.901     0.200
    83.773     0.368     0.200
    84.120    -0.203     0.200
    84.183     2.507     0.200
    84.446     1.742     0.200
    84.611     1.510     0.200
    84.822     2.444     0.200
    85.085     1.924     0.200
    85.280     1.049     0.200
    85.803     3.599     0.200
    91.542     2.369     0.200
    91.542     2.369     0.200
    92.288     1.872     0.200
    92.288     2.185     0.200
    93.630    -3.067     0.200
    94.818     3.322     0.200
    95.269    -1.790     0.200
    96.365     2.235     0.200
    96.468     1.762     0.200
    98.020    -2.455     0.200
    15.950     5.101     0.200
    21.803     1.256     0.200
    37.798     1.212     0.200
    37.798     1.202     0.200
    81.406     1.000     0.200
    81.406     1.000     0.200
    86.114     0.614     0.200
    95.283    -0.841     0.200
    37.932     1.120     0.200
    95.391    -4.210     0.200
    37.811     0.727     0.200
    14.932     4.214     0.200
    15.159     4.471     0.200
    15.431     4.049     0.200
    15.477     4.453     0.200
    15.612     4.697     0.200
    16.325     4.039     0.200
    16.292     6.019     0.200
    16.629     2.697     0.200
    16.743     5.133     0.200
    17.342     5.494     0.200
    18.430     3.339     0.200
    18.467     1.187     0.200
    18.479     0.800     0.200
    18.494     1.247     0.200
    18.486     0.934     0.200
    18.690     0.983     0.200
    18.801     0.577     0.200
    18.820     1.395     0.200
    18.849     0.209     0.200
    18.957     1.389     0.200
    19.107     0.523     0.200
    19.188     0.041     0.200
    19.182     2.073     0.200
    19.412     0.805     0.200
    19.522     1.167     0.200
    19.840     1.122     0.200
    19.915     1.394     0.200
    19.978     1.594     0.200
    20.372     1.198     0.200
    20.438     0.863     0.200
    20.812     0.475     0.200
    20.802     1.014     0.200
    21.207     1.413     0.200
    21.363     4.534     0.200
    21.542     0.973     0.200
    21.542     0.504     0.200
    21.537     4.114     0.200
    21.604     0.650     0.200
    21.660     2.770     0.200
    21.853     1.832     0.200
    21.880     1.255     0.200
    22.274     3.581     0.200
    22.294     2.922     0.200
    22.845    -0.480     0.200
    22.845    -0.253     0.200
    22.889     1.061     0.200
    23.712     1.049     0.200
    23.900     2.304     0.200
    23.900     0.695     0.200
    23.939     2.668     0.200
    24.168     0.397     0.200
    24.152     1.338     0.200
    24.439     1.738     0.200
    25.583     1.613     0.200
    26.232     3.493     0.200
    26.185     2.311     0.200
    26.348     5.495     0.200
    26.764     3.090     0.200
    26.990     1.304     0.200
    27.869     3.168     0.200
    27.869     2.418     0.200
    28.205     0.304     0.200
    28.341     1.006     0.200
    29.290     0.272     0.200
    29.922     1.271     0.200
    30.070     0.760     0.200
    30.070    -0.349     0.200
    30.178     3.654     0.200
    30.860     1.457     0.200
    31.372     4.433     0.200
    31.926     3.878     0.200
    34.004     4.235     0.200
    34.370     5.362     0.200
    35.048     3.006     0.200
    35.452     1.062     0.200
    35.556     2.629     0.200
    35.556     5.020     0.200
    35.686     3.451     0.200
    35.829     2.218     0.200
    35.901     3.444     0.200
    36.043     3.248     0.200
    36.073    -0.194     0.200
    36.083     2.906     0.200
    36.379     2.940     0.200
    36.447     3.001     0.200
    37.258     2.976     0.200
    37.356     5.109     0.200
    37.434     2.399     0.200
    37.434     2.024     0.200
    37.718     2.792     0.200
    37.744     1.231     0.200
    37.744     2.176     0.200
    38.012     2.705     0.200
    38.116     2.034     0.200
    38.116     3.448     0.200
    38.300     2.401     0.200
    38.375     2.552     0.200
    38.639     2.158     0.200
    38.777     2.301     0.200
    38.911     3.053     0.200
    40.410     3.187     0.200
    40.735     1.672     0.200
    41.981     5.089     0.200
    43.497     1.456     0.200
    43.493     0.430     0.200
    43.800     7.022     0.200
    44.186     6.740     0.200
    45.234     5.183     0.200
    45.687     1.987     0.200
    45.648     4.164     0.200
    45.873     1.374     0.200
    45.966     5.606     0.200
    46.210     4.257     0.200
    46.437     5.859     0.200
    46.460     3.986     0.200
    46.712     1.987     0.200
    46.772     3.237     0.200
    46.818     5.706     0.200
    47.003     5.314     0.200
    47.184     3.817     0.200
    47.184     2.848     0.200
    47.288     0.909     0.200
    47.341     2.750     0.200
    47.337     5.060     0.200
    47.381     4.712     0.200
    47.601     2.431     0.200
    47.619     2.862     0.200
    48.215     2.210     0.200
    49.793     1.431     0.200
    52.706     5.155     0.200
    55.429     1.380     0.200
    55.429     1.279     0.200
    59.625     7.009     0.200
    60.879     0.730     0.200
    61.623    -0.006     0.200
    62.622     1.718     0.200
    62.712     1.683     0.200
    63.142     1.176     0.200
    63.142     0.848     0.200
    63.142     1.223     0.200
    67.091     0.778     0.200
    67.091    -0.441     0.200
    67.337     5.571     0.200
    67.364     6.392     0.200
    67.775     2.848     0.200
    68.024     6.577     0.200
    68.275     6.835     0.200
    68.846     7.088     0.200
    69.125     5.426     0.200
    69.432     7.111     0.200
    69.565     7.274     0.200
    70.058     6.986     0.200
    70.101     6.654     0.200
    72.444     0.807     0.200
    72.444     0.612     0.200
    74.361     1.207     0.200
    74.447     0.910     0.200
    74.447     0.754     0.200
    76.014     0.540     0.200
    76.766    -0.674     0.200
    77.044     6.082     0.200
    77.173     1.133     0.200
    77.442     1.223     0.200
    77.648     2.275     0.200
    77.970     4.281     0.200
    79.692     6.715     0.200
    80.054     2.813     0.200
    80.796     0.268     0.200
    81.048     6.525     0.200
    81.125     7.116     0.200
    81.265    -0.327     0.200
    81.306     1.154     0.200
    81.428     1.504     0.200
    81.448     2.399     0.200
    81.923     0.290     0.200
    81.951     4.347     0.200
    81.970    -0.353     0.200
    82.017     3.999     0.200
    82.230     1.209     0.200
    82.308     6.676     0.200
    82.404     3.674     0.200
    82.620     6.643     0.200
    82.901     3.885     0.200
    82.985     1.155     0.200
    82.985    -0.052     0.200
    82.985     1.745     0.200
    83.078     5.367     0.200
    83.117     3.972     0.200
    83.307     0.585     0.200
    83.418    -0.488     0.200
    83.485     4.165     0.200
    83.572    -0.475     0.200
    83.577    -0.400     0.200
    83.692    -0.491     0.200
    83.792     3.592     0.200
    83.817     0.963     0.200
    84.019     0.339     0.200
    84.025     5.207     0.200
    84.026    -0.605     0.200
    84.062     3.518     0.200
    84.112     6.084     0.200
    84.131     4.031     0.200
    84.353    -0.360     0.200
    84.370     3.450     0.200
    84.434     3.320     0.200
    84.434     4.812     0.200
    84.518    -0.399     0.200
    84.548     3.652     0.200
    84.598     5.490     0.200
    84.840     6.271     0.200
    84.973     1.410     0.200
    84.993     2.706     0.200
    84.993     3.308     0.200
    85.108     1.426     0.200
    85.076     4.589     0.200
    85.076     3.190     0.200
    85.166     3.635     0.200
    85.337     3.383     0.200
    85.357    -0.512     0.200
    85.410     3.416     0.200
    85.420     3.971     0.200
    85.429     3.726     0.200
    85.428     3.531     0.200
    85.486     3.540     0.200
    85.593     3.507     0.200
    85.682     6.662     0.200
    85.712     3.517     0.200
    85.798     3.691     0.200
    86.090    -0.755     0.200
    86.524     5.668     0.200
    86.524     4.106     0.200
    86.632     3.577     0.200
    86.697     5.056     0.200
    86.821     4.600     0.200
    87.083     5.977     0.200
    87.090     2.738     0.200
    87.138     1.814     0.200
    87.735    -2.771     0.200
    88.010     3.822     0.200
    88.067     2.755     0.200
    88.871     0.651     0.200
    88.905     2.984     0.200
    89.280     2.131     0.200
    89.490     0.745     0.200
    89.769     4.850     0.200
    90.271     4.100     0.200
    90.417     4.325     0.200
    90.466     6.191     0.200
    90.554     2.688     0.200
    90.780     1.431     0.200
    91.297     0.932     0.200
    91.323     2.114     0.200
    91.323     1.442     0.200
    91.454     1.200     0.200
    91.457     1.659     0.200
    91.530     4.750     0.200
    91.634     0.969     0.200
    91.792     2.206     0.200
    91.805     2.677     0.200
    92.235     2.761     0.200
    92.235     2.793     0.200
    92.712    -2.577     0.200
    92.738     2.162     0.200
    92.743     3.141     0.200
    93.615     0.621     0.200
    94.195     1.455     0.200
    94.513     3.801     0.200
    94.542     3.566     0.200
    94.578     5.149     0.200
    94.726     1.019     0.200
    94.726     3.723     0.200
    94.806    -0.441     0.200
    95.877     1.466     0.200
    97.302    -0.996     0.200
    98.018     0.281     0.200
    99.566     2.153     0.200
    37.704     0.526     0.200
    15.928     5.376     0.200
    37.801     2.133     0.200
    16.017     2.553     0.200
    37.859     2.041     0.200
    15.954     3.074     0.200
    22.941     0.122     0.200
    86.130    -1.575     0.200
    95.297    -1.819     0.200
    14.758     3.928     0.200
    15.126     2.611     0.200
    15.250     4.341     0.200
    15.474     5.535     0.200
    16.032     2.876     0.200
    16.032     4.532     0.200
    18.277     1.661     0.200
    21.723     0.441     0.200
    23.013     1.737     0.200
    23.029     2.393     0.200
    28.007     2.273     0.200
    30.239     2.120     0.200
    37.584     2.124     0.200
    37.871     2.241     0.200
    60.362     1.488     0.200
    62.815     1.972     0.200
    63.212     2.184     0.200
    77.358     1.120     0.200
    81.489     2.050     0.200
    14.812     5.897     0.200
    17.358     2.229     0.200
    17.512     2.594     0.200
    17.812     5.645     0.200
    18.062     1.891     0.200
    18.135     2.154     0.200
    18.160     1.931     0.200
    18.178     2.248     0.200
    18.210     1.262     0.200
    18.227     1.428     0.200
    18.423     1.739     0.200
    18.435     1.615     0.200
    18.603     0.604     0.200
    18.663     0.787     0.200
    19.475     0.507     0.200
    19.598     0.846     0.200
    19.709     0.424     0.200
    19.735     0.254     0.200
    19.777     2.253     0.200
    19.780    -3.335     0.200
    20.025    -0.234     0.200
    20.102     0.934     0.200
    20.164     0.222     0.200
    20.365     1.879     0.200
    20.558     0.226     0.200
    20.624     0.528     0.200
    20.988    -0.204     0.200
    21.032     6.033     0.200
    21.044     4.383     0.200
    21.238     5.912     0.200
    21.515    -1.303     0.200
    21.710     0.196     0.200
    21.716     0.768     0.200
    21.725     0.842     0.200
    21.985     1.311     0.200
    22.189     4.172     0.200
    23.031     0.666     0.200
    23.560     3.945     0.200
    23.815     0.181     0.200
    23.860     2.749     0.200
    24.046     0.510     0.200
    24.398     0.228     0.200
    24.556    -0.753     0.200
    25.386     4.767     0.200
    26.305     1.548     0.200
    26.898     0.595     0.200
    28.012     2.441     0.200
    28.012     0.652     0.200
    28.323     0.260     0.200
    28.400     3.261     0.200
    28.977    -0.417     0.200
    29.490     0.232     0.200
    30.054     5.444     0.200
    30.243     1.663     0.200
    30.667    -0.401     0.200
    31.799    -0.191     0.200
    32.582    -0.383     0.200
    34.032    -1.828     0.200
    35.123     5.772     0.200
    35.531     0.970     0.200
    35.705    -1.125     0.200
    35.876     3.708     0.200
    35.930     4.046     0.200
    36.270     4.032     0.200
    36.270     5.032     0.200
    36.689     1.241     0.200
    36.705     6.249     0.200
    36.730     1.886     0.200
    36.849     6.413     0.200
    37.258     4.865     0.200
    37.395     7.066     0.200
    37.463     3.402     0.200
    37.589     1.822     0.200
    37.713     4.160     0.200
    37.876     1.733     0.200
    38.032    -1.823     0.200
    39.417    -1.856     0.200
    40.055     3.950     0.200
    40.055    -2.182     0.200
    40.407     3.044     0.200
    40.490    -1.332     0.200
    40.679     1.083     0.200
    41.551    -0.826     0.200
    42.054    -0.678     0.200
    42.282     5.906     0.200
    42.774     0.682     0.200
    43.153    -2.399     0.200
    43.493     0.914     0.200
    43.677     1.084     0.200
    43.785     3.911     0.200
    44.178     3.302     0.200
    44.210    -1.595     0.200
    44.691     0.858     0.200
    45.225     2.906     0.200
    45.302    -2.738     0.200
    45.457    -0.922     0.200
    45.515    -1.023     0.200
    45.607    -2.119     0.200
    45.653     2.394     0.200
    45.805    -1.145     0.200
    45.827     6.645     0.200
    45.922    -1.213     0.200
    45.930    -1.057     0.200
    46.040     1.809     0.200
    46.062    -1.515     0.200
    46.197     4.796     0.200
    46.423     3.086     0.200
    46.423     2.804     0.200
    46.771     2.212     0.200
    46.786    -2.157     0.200
    46.794     4.750     0.200
    46.822    -0.280     0.200
    46.992     3.930     0.200
    47.120     3.064     0.200
    47.141     3.786     0.200
    47.147     3.701     0.200
    47.175    -1.996     0.200
    47.176     2.659     0.200
    47.312     2.668     0.200
    47.321     4.140     0.200
    47.395     1.717     0.200
    47.395    -0.713     0.200
    47.592     2.678     0.200
    47.599     3.073     0.200
    47.609    -1.371     0.200
    48.055    -2.659     0.200
    49.718    -2.173     0.200
    49.780     4.848     0.200
    50.165    -3.442     0.200
    50.817     1.749     0.200
    50.877     1.463     0.200
    50.877     2.893     0.200
    51.099     4.427     0.200
    52.095    -1.824     0.200
    52.981    -0.898     0.200
    53.576     0.832     0.200
    54.223    -1.993     0.200
    55.617     2.407     0.200
    55.617     0.102     0.200
    56.136     2.181     0.200
    59.443     5.298     0.200
    60.365     0.202     0.200
    61.632     2.297     0.200
    62.821     1.712     0.200
    62.949     0.508     0.200
    63.218     2.214     0.200
    64.413    -0.922     0.200
    64.960     2.038     0.200
    65.028    -1.198     0.200
    65.028    -1.432     0.200
    65.051     5.559     0.200
    66.106     0.423     0.200
    66.106     3.696     0.200
    66.186     2.871     0.200
    66.910     2.383     0.200
    66.912     3.535     0.200
    68.302     5.192     0.200
    68.524     3.799     0.200
    68.592     3.981     0.200
    68.647     4.737     0.200
    68.689     2.092     0.200
    68.736     3.680     0.200
    69.349     5.419     0.200
    70.768     4.758     0.200
    70.842     6.507     0.200
    70.890    -3.486     0.200
    71.180     5.161     0.200
    71.558     1.672     0.200
    71.600     3.522     0.200
    72.564     0.398     0.200
    72.928     1.767     0.200
    73.023     3.783     0.200
    73.094     5.677     0.200
    73.512     5.241     0.200
    73.545     3.824     0.200
    73.677     2.855     0.200
    73.956     2.534     0.200
    74.001     3.041     0.200
    74.094     5.766     0.200
    74.239     4.951     0.200
    74.269     3.675     0.200
    74.417     2.418     0.200
    74.519     2.310     0.200
    74.518     1.644     0.200
    74.546     1.504     0.200
    74.546     3.738     0.200
    74.609     3.187     0.200
    74.606     1.883     0.200
    74.648     0.791     0.200
    74.648    -0.967     0.200
    74.686     4.147     0.200
    74.810     3.805     0.200
    74.956    -2.352     0.200
    75.042     2.134     0.200
    75.060     3.350     0.200
    75.092     4.613     0.200
    75.104     3.583     0.200
    75.117     1.856     0.200
    75.215     5.966     0.200
    75.216     1.881     0.200
    75.297    -0.857     0.200
    75.297     4.104     0.200
    75.412     4.158     0.200
    75.470     3.718     0.200
    75.509     2.273     0.200
    75.598     4.264     0.200
    75.715     3.272     0.200
    75.844     4.760     0.200
    75.893     4.876     0.200
    75.909     2.446     0.200
    76.025     6.126     0.200
    76.074     1.874     0.200
    76.077    -1.459     0.200
    76.168     3.776     0.200
    76.458     5.580     0.200
    76.514     3.899     0.200
    76.728     3.982     0.200
    76.757     3.079     0.200
    76.779     6.881     0.200
    76.824    -0.190     0.200
    76.845     3.995     0.200
    76.986     4.202     0.200
    77.091     4.626     0.200
    77.285     2.920     0.200
    77.318     3.782     0.200
    77.359     3.474     0.200
    77.361     2.556     0.200
    77.507     2.107     0.200
    77.549     3.379     0.200
    77.626     2.440     0.200
    77.626     1.323     0.200
    77.691     1.786     0.200
    77.712     2.959     0.200
    77.736     1.528     0.200
    77.762     4.116     0.200
    77.785     5.092     0.200
    77.804     4.259     0.200
    77.814     3.829     0.200
    77.905     3.751     0.200
    77.981     4.420     0.200
    78.025     3.641     0.200
    78.054     2.355     0.200
    78.347     3.142     0.200
    78.654     3.456     0.200
    79.359    -1.729     0.200
    79.411     0.487     0.200
    79.701     6.087     0.200
    79.722     0.600     0.200
    79.842     0.448     0.200
    79.880     5.640     0.200
    79.913     4.368     0.200
    80.047     2.913     0.200
    80.274     5.207     0.200
    80.539     4.688     0.200
    80.568     4.225     0.200
    80.613     0.883     0.200
    80.652     0.979     0.200
    80.843    -2.041     0.200
    80.904     4.528     0.200
    80.905     0.822     0.200
    80.983     2.211     0.200
    81.009     2.174     0.200
    81.188     0.415     0.200
    81.220     2.142     0.200
    81.222     3.835     0.200
    81.299     4.325     0.200
    81.347     5.172     0.200
    81.451     2.721     0.200
    81.496     5.383     0.200
    81.493     2.157     0.200
    81.526     2.927     0.200
    81.535     3.380     0.200
    81.568     3.257     0.200
    81.568     5.796     0.200
    81.612     2.370     0.200
    81.620     4.826     0.200
    81.686     6.316     0.200
    81.703     6.085     0.200
    81.742     2.879     0.200
    81.844     1.578     0.200
    81.879     3.761     0.200
    82.015     3.052     0.200
    82.108     1.055     0.200
    82.138     2.998     0.200
    82.151     0.829     0.200
    82.204     2.757     0.200
    82.269     2.604     0.200
    82.279     4.558     0.200
    82.305     2.986     0.200
    82.313     4.980     0.200
    82.308     1.634     0.200
    82.335     1.672     0.200
    82.373     1.064     0.200
    82.386     2.593     0.200
    82.403     1.314     0.200
    82.445     3.322     0.200
    82.479     4.513     0.200
    82.511     2.945     0.200
    82.586     1.885     0.200
    82.591     2.337     0.200
    82.669     3.122     0.200
    82.669     5.326     0.200
    82.681     5.266     0.200
    82.696     2.950     0.200
    82.696     4.786     0.200
    82.906     3.390     0.200
    83.027     3.661     0.200
    83.034     1.869     0.200
    83.035     1.326     0.200
    83.072     3.337     0.200
    83.088     2.752     0.200
    83.179     1.077     0.200
    83.201     5.761     0.200
    83.233     3.596     0.200
    83.247     4.932     0.200
    83.302     2.805     0.200
    83.388    -0.976     0.200
    83.566     0.986     0.200
    83.577     2.430     0.200
    83.600     0.810     0.200
    83.672     2.939     0.200
    83.690     1.154     0.200
    83.754     0.822     0.200
    83.756     1.214     0.200
    83.760     0.886     0.200
    83.760     0.989     0.200
    83.802     1.080     0.200
    83.857     1.295     0.200
    83.862     0.570     0.200
    83.873     0.909     0.200
    84.004     2.445     0.200
    84.104    -0.964     0.200
    84.174    -1.985     0.200
    84.209     0.595     0.200
    84.248     2.497     0.200
    84.262     2.082     0.200
    84.270     1.590     0.200
    84.414     0.756     0.200
    84.537     0.930     0.200
    84.694     1.044     0.200
    84.703     0.899     0.200
    84.914     0.736     0.200
    85.080     2.500     0.200
    85.155     2.424     0.200
    85.180     2.398     0.200
    85.180     2.101     0.200
    85.212     3.838     0.200
    85.261     2.096     0.200
    85.352    -1.163     0.200
    85.352     2.438     0.200
    85.365     2.973     0.200
    85.370     1.154     0.200
    85.489    -1.349     0.200
    85.537     1.016     0.200
    85.606     2.875     0.200
    85.606    -0.227     0.200
    85.615     2.432     0.200
    85.794    -2.770     0.200
    85.799     5.710     0.200
    85.844     0.888     0.200
    85.899     2.147     0.200
    85.899     2.319     0.200
    85.938     1.227     0.200
    85.984     2.692     0.200
    86.421     1.642     0.200
    86.429     0.602     0.200
    86.451     1.297     0.200
    86.474     1.686     0.200
    86.495     2.604     0.200
    86.495     2.245     0.200
    86.712     2.215     0.200
    86.712     2.320     0.200
    86.738     2.530     0.200
    86.741     2.572     0.200
    86.746    -0.649     0.200
    86.748     2.937     0.200
    86.819     1.586     0.200
    86.873     2.528     0.200
    86.873     2.427     0.200
    86.885     1.571     0.200
    86.885     1.766     0.200
    86.898     1.883     0.200
    86.898     2.219     0.200
    86.917     1.017     0.200
    87.006     2.322     0.200
    87.019     0.812     0.200
    87.030     1.760     0.200
    87.056     1.339     0.200
    87.069     0.454     0.200
    87.269     2.304     0.200
    87.278     1.955     0.200
    87.324     1.543     0.200
    87.330     2.046     0.200
    87.494     1.402     0.200
    87.746     5.504     0.200
    87.753     3.270     0.200
    87.765     0.110     0.200
    87.823     5.036     0.200
    87.850     0.204     0.200
    87.923     0.960     0.200
    87.964     1.266     0.200
    88.197     2.160     0.200
    88.218     1.762     0.200
    88.218    -1.074     0.200
    88.238     1.171     0.200
    88.244     5.236     0.200
    88.242     7.128     0.200
    88.323     1.876     0.200
    88.360     2.113     0.200
    88.363     6.865     0.200
    88.413     1.537     0.200
    88.493     1.869     0.200
    88.510     6.713     0.200
    88.526     6.208     0.200
    88.755     1.821     0.200
    88.801     6.855     0.200
    88.824     6.093     0.200
    88.843     2.908     0.200
    88.956     2.484     0.200
    88.965     3.422     0.200
    89.001     2.720     0.200
    89.000     1.669     0.200
    89.001     2.767     0.200
    89.180     7.018     0.200
    89.245    -1.463     0.200
    89.331     1.693     0.200
    89.337     3.492     0.200
    89.379     6.553     0.200
    89.381     6.943     0.200
    89.444     5.290     0.200
    89.466     1.593     0.200
    89.553     0.753     0.200
    89.549     6.929     0.200
    89.593     2.694     0.200
    89.593     4.990     0.200
    89.623     1.272     0.200
    89.677     1.903     0.200
    89.667     6.693     0.200
    89.670     6.725     0.200
    89.684     3.370     0.200
    89.684     3.691     0.200
    89.684     6.500     0.200
    89.702    -0.120     0.200
    89.713     1.594     0.200
    89.714    -1.374     0.200
    89.718     6.009     0.200
    89.751     6.352     0.200
    89.753     1.240     0.200
    89.759     4.016     0.200
    89.810     1.617     0.200
    89.957     2.595     0.200
    90.205     3.231     0.200
    90.291     6.834     0.200
    90.329     1.858     0.200
    90.346     6.749     0.200
    90.400     2.120     0.200
    90.413     1.366     0.200
    90.420     2.028     0.200
    90.459     2.449     0.200
    90.480     5.248     0.200
    90.549     1.776     0.200
    90.549     3.629     0.200
    90.633     5.534     0.200
    90.640     2.606     0.200
    90.640    -1.011     0.200
    90.654     5.438     0.200
    90.683     4.712     0.200
    90.742     2.531     0.200
    90.860     6.448     0.200
    90.908     2.664     0.200
    91.037     6.359     0.200
    91.188     2.260     0.200
    91.448     6.750     0.200
    91.484     1.289     0.200
    91.502     6.003     0.200
    91.503     3.303     0.200
    91.503     5.702     0.200
    91.499     1.513     0.200
    91.562     6.131     0.200
    91.642     1.053     0.200
    91.649     0.024     0.200
    91.649     2.469     0.200
    91.790     0.474     0.200
    91.925     3.432     0.200
    92.063    -0.994     0.200
    92.084    -1.639     0.200
    92.143     7.236     0.200
    92.187     6.637     0.200
    92.211     5.323     0.200
    92.211     4.597     0.200
    92.211    -1.607     0.200
    92.243     2.775     0.200
    92.335     6.750     0.200
    92.388     4.106     0.200
    92.388     2.059     0.200
    92.589     5.176     0.200
    92.671     1.696     0.200
    92.741     6.077     0.200
    92.778     6.306     0.200
    92.828     5.870     0.200
    92.931     2.599     0.200
    93.025     5.369     0.200
    93.079     1.916     0.200
    93.108     2.484     0.200
    93.304     6.082     0.200
    93.410     2.392     0.200
    93.495     6.701     0.200
    93.511     2.027     0.200
    93.707    -3.181     0.200
    93.727    -1.366     0.200
    93.745     2.144     0.200
    93.849     1.668     0.200
    93.882     3.921     0.200
    93.984     4.455     0.200
    94.097     4.832     0.200
    94.128     5.191     0.200
    94.145     2.809     0.200
    94.209     3.708     0.200
    94.332     4.853     0.200
    94.351     5.667     0.200
    94.383     2.121     0.200
    94.386     4.606     0.200
    94.397     5.355     0.200
    94.537     3.510     0.200
    94.600     2.526     0.200
    94.685     4.033     0.200
    94.694     4.594     0.200
    94.701     4.757     0.200
    94.730     4.325     0.200
    94.754     3.014     0.200
    94.754     4.420     0.200
    94.754     3.014     0.200
    94.757     2.735     0.200
    94.915     4.579     0.200
    94.936     4.680     0.200
    94.949     2.026     0.200
    94.965     1.752     0.200
    94.994     2.414     0.200
    95.120     4.542     0.200
    95.437     1.490     0.200
    95.533     4.357     0.200
    95.645    -1.576     0.200
    95.799     3.442     0.200
    95.826     1.920     0.200
    95.880     4.779     0.200
    95.921     0.886     0.200
    96.046     5.422     0.200
    96.065     1.435     0.200
    96.087     5.842     0.200
    96.130     3.139     0.200
    96.130    -1.135     0.200
    96.261     2.044     0.200
    96.263     5.232     0.200
    96.334    -0.094     0.200
    96.334     4.508     0.200
    96.334     1.008     0.200
    96.423     5.308     0.200
    96.501     5.144     0.200
    96.541     1.367     0.200
    96.677     0.452     0.200
    96.786     1.961     0.200
    96.786     1.860     0.200
    96.786    -1.078     0.200
    96.871     0.575     0.200
    96.879     1.537     0.200
    96.888     5.293     0.200
    96.887     2.298     0.200
    97.022     1.592     0.200
    97.174     1.499     0.200
    97.371     1.315     0.200
    97.380     1.273     0.200
    97.557    -0.524     0.200
    97.930     0.693     0.200
    98.027     1.358     0.200
    98.089    -2.020     0.200
    98.730    -2.121     0.200
    22.270     1.104     0.200
    23.245     0.529     0.200
    28.301     1.714     0.200
    30.358     1.050     0.200
    30.529     0.185     0.200
    37.642     0.018     0.200
    37.879     1.280     0.200
    38.161     1.614     0.200
    38.417     0.215     0.200
    38.532     1.155     0.200
    38.774     1.629     0.200
    43.003     0.548     0.200
    43.955     0.323     0.200
    46.712    -1.259     0.200
    56.415     1.685     0.200
    63.092     1.222     0.200
    63.462     0.561     0.200
    70.477     2.285     0.200
    74.814     0.601     0.200
    77.603     1.259     0.200
    77.603     1.259     0.200
    77.897    -1.277     0.200
    79.912     0.854     0.200
    80.848     1.125     0.200
    81.102     0.963     0.200
    81.751     1.253     0.200
    82.316     1.158     0.200
    82.343     1.020     0.200
    82.485     1.174     0.200
    82.554     0.816     0.200
    82.583     1.165     0.200
    82.553     1.170     0.200
    83.252     1.294     0.200
    83.771     1.329     0.200
    83.794     0.803     0.200
    83.951     0.808     0.200
    83.959     1.063     0.200
    83.965     1.135     0.200
    84.002     1.243     0.200
    84.059     0.855     0.200
    84.064     1.332     0.200
    84.064     1.130     0.200
    84.407     0.781     0.200
    84.425     1.114     0.200
    84.605     1.087     0.200
    84.744     1.183     0.200
    84.912     1.041     0.200
    85.120     0.994     0.200
    85.430     0.344     0.200
    85.572     1.035     0.200
    87.545     0.462     0.200
    89.237     2.077     0.200
    89.237     2.053     0.200
    91.890    -0.362     0.200
    15.048     4.796     0.200
    15.568     3.251     0.200
    15.695     4.639     0.200
    15.866     3.195     0.200
    16.574     3.244     0.200
    16.893     2.140     0.200
    17.001     3.093     0.200
    18.608     0.674     0.200
    19.239     0.104     0.200
    20.011     0.590     0.200
    20.882     1.452     0.200
    21.077     0.569     0.200
    21.311    -0.064     0.200
    21.443     0.510     0.200
    21.657     0.017     0.200
    21.714     0.065     0.200
    21.750     0.004     0.200
    21.790     0.167     0.200
    21.972     0.479     0.200
    22.101     2.289     0.200
    22.423    -0.272     0.200
    22.961     0.521     0.200
    22.978    -0.014     0.200
    23.064    -0.567     0.200
    23.220    -0.306     0.200
    23.750     0.351     0.200
    23.741     1.858     0.200
    23.889     0.414     0.200
    23.956     1.764     0.200
    24.018     0.970     0.200
    24.257    -0.175     0.200
    24.324     0.405     0.200
    24.416    -0.133     0.200
    24.502     0.306     0.200
    26.253     0.685     0.200
    26.253     1.958     0.200
    26.656     0.841     0.200
    27.102    -0.069     0.200
    28.124     1.416     0.200
    28.268     0.270     0.200
    29.412     0.505     0.200
    29.428     0.111     0.200
    30.335    -0.012     0.200
    30.335    -0.012     0.200
    30.652    -0.185     0.200
    32.556     1.457     0.200
    33.520    -0.199     0.200
    33.833     0.832     0.200
    34.357     0.032     0.200
    35.143     2.488     0.200
    35.301     2.670     0.200
    35.414     4.464     0.200
    36.122     3.797     0.200
    36.336     0.915     0.200
    37.490     1.164     0.200
    37.695     0.544     0.200
    37.963     1.032     0.200
    37.992     0.947     0.200
    37.992     0.572     0.200
    38.254     0.885     0.200
    38.364     1.548     0.200
    38.542     1.782     0.200
    38.614     1.160     0.200
    38.880     1.789     0.200
    39.008     2.192     0.200
    40.661     2.373     0.200
    40.694    -0.408     0.200
    40.694    -0.174     0.200
    40.981     0.893     0.200
    42.817     0.086     0.200
    43.758     0.932     0.200
    43.758     0.729     0.200
    46.308     5.574     0.200
    46.659     3.007     0.200
    46.697     0.093     0.200
    46.943     1.847     0.200
    46.878     2.554     0.200
    47.003     6.143     0.200
    47.023     5.231     0.200
    47.027     1.625     0.200
    47.027     1.328     0.200
    47.288     2.042     0.200
    47.288     0.440     0.200
    47.478     1.498     0.200
    50.922     0.420     0.200
    52.526     2.892     0.200
    55.674     0.254     0.200
    56.256     3.896     0.200
    60.433    -1.607     0.200
    61.523     1.203     0.200
    62.821     3.881     0.200
    62.942     0.777     0.200
    63.338     1.471     0.200
    63.341     1.440     0.200
    65.105     0.950     0.200
    65.985     2.888     0.200
    66.264    -0.750     0.200
    66.264    -0.758     0.200
    70.192     1.581     0.200
    70.559     0.120     0.200
    72.684     1.483     0.200
    74.618    -0.688     0.200
    74.618    -0.688     0.200
    75.341     1.163     0.200
    77.413     0.179     0.200
    77.413     0.023     0.200
    77.413     0.023     0.200
    77.441     0.819     0.200
    77.701     4.070     0.200
    77.701     2.039     0.200
    78.914     0.495     0.200
    79.432     0.819     0.200
    79.742     0.835     0.200
    79.863     0.474     0.200
    79.934    -0.013     0.200
    79.934     2.440     0.200
    80.637     1.004     0.200
    80.675     1.300     0.200
    80.909     3.848     0.200
    80.929     1.139     0.200
    81.224     4.569     0.200
    81.306     1.233     0.200
    81.520     1.395     0.200
    81.556     0.203     0.200
    81.556     0.180     0.200
    81.623     4.551     0.200
    81.623     1.614     0.200
    81.687     3.217     0.200
    82.138     1.942     0.200
    82.172     1.266     0.200
    82.280     3.596     0.200
    82.311     4.231     0.200
    82.334     2.215     0.200
    82.404     1.245     0.200
    82.402     1.856     0.200
    82.431     1.457     0.200
    82.904     4.143     0.200
    83.151     3.967     0.200
    83.155     2.027     0.200
    83.156     2.039     0.200
    83.511    -4.589     0.200
    83.455     0.499     0.200
    83.455     1.546     0.200
    83.594     1.485     0.200
    83.622     1.240     0.200
    83.708     1.594     0.200
    83.769     1.282     0.200
    83.778     1.239     0.200
    83.785     1.406     0.200
    83.788     1.287     0.200
    83.827     1.486     0.200
    83.887     1.682     0.200
    83.886     1.084     0.200
    83.893     1.350     0.200
    84.069     4.555     0.200
    84.234     1.015     0.200
    84.268     1.060     0.200
    84.284     2.656     0.200
    84.434     1.198     0.200
    84.566     1.225     0.200
    84.709     1.504     0.200
    84.733     1.382     0.200
    84.943     1.133     0.200
    85.220     1.537     0.200
    85.233     1.175     0.200
    85.334     2.866     0.200
    85.396     1.454     0.200
    85.554     1.370     0.200
    85.642     3.831     0.200
    85.866     1.023     0.200
    85.939     3.466     0.200
    85.958     1.567     0.200
    86.461     1.180     0.200
    86.477     1.706     0.200
    86.499     1.798     0.200
    86.859     1.034     0.200
    86.926     1.404     0.200
    86.939     1.545     0.200
    87.072     0.191     0.200
    87.094     1.494     0.200
    87.133     1.277     0.200
    87.320     0.691     0.200
    87.362     0.286     0.200
    87.362     0.270     0.200
    87.432     1.220     0.200
    87.788     0.645     0.200
    88.238     1.421     0.200
    89.124     2.199     0.200
    89.124     0.410     0.200
    89.744     3.521     0.200
    89.801     3.255     0.200
    89.796     3.082     0.200
    90.003     4.014     0.200
    90.665     2.629     0.200
    90.703     2.749     0.200
    91.025    -0.146     0.200
    91.278     3.082     0.200
    91.587     3.351     0.200
    91.698     2.233     0.200
    91.698     1.233     0.200
    91.698     1.233     0.200
    91.699     0.627     0.200
    91.896     0.219     0.200
    92.045     2.170     0.200
    92.045     2.170     0.200
    92.491     1.537     0.200
    92.495     2.745     0.200
    92.495     1.526     0.200
    93.222     4.097     0.200
    93.830     0.997     0.200
    95.019     1.928     0.200
    95.041     1.707     0.200
    96.571     2.475     0.200
    96.673     2.033     0.200
    97.534     0.995     0.200
    15.366     3.416     0.200
    15.819     2.916     0.200
    16.103     2.628     0.200
    16.103     3.128     0.200
    16.352     2.537     0.200
    16.956     3.427     0.200
    17.540     2.065     0.200
    17.546     3.816     0.200
    18.644     0.326     0.200
    19.306     1.394     0.200
    20.057    -0.483     0.200
    20.954     2.040     0.200
    21.054     0.346     0.200
    21.369     0.456     0.200
    21.725     0.936     0.200
    21.751     0.938     0.200
    21.774    -0.078     0.200
    22.032     0.540     0.200
    22.469     0.089     0.200
    23.025    -0.008     0.200
    23.036     0.388     0.200
    23.083     0.384     0.200
    23.280    -0.694     0.200
    23.820    -0.030     0.200
    23.818     1.376     0.200
    23.919     0.829     0.200
    24.029     2.044     0.200
    24.072     0.458     0.200
    24.383     0.268     0.200
    24.415     1.078     0.200
    24.415     0.476     0.200
    24.438     0.404     0.200
    26.318     0.405     0.200
    26.318     0.725     0.200
    26.725     0.427     0.200
    26.900     0.588     0.200
    26.961     1.639     0.200
    27.158     0.278     0.200
    28.077     1.950     0.200
    28.077     2.340     0.200
    28.334    -0.285     0.200
    28.361    -0.181     0.200
    28.994     0.441     0.200
    29.347    -0.107     0.200
    29.465     0.056     0.200
    29.497     0.299     0.200
    30.309     1.030     0.200
    30.309     1.030     0.200
    30.699    -0.034     0.200
    31.009    -0.246     0.200
    31.066     0.257     0.200
    31.250     0.517     0.200
    32.211     0.084     0.200
    32.609     0.287     0.200
    33.575     0.140     0.200
    33.592     0.347     0.200
    33.881     0.355     0.200
    34.360     0.690     0.200
    34.408     0.411     0.200
    34.557     1.860     0.200
    35.306     0.693     0.200
    35.252     2.379     0.200
    35.492     2.511     0.200
    35.492     3.878     0.200
    35.735     1.118     0.200
    35.903    -0.319     0.200
    36.269     2.432     0.200
    36.287     1.891     0.200
    36.558     1.610     0.200
    36.685    -0.129     0.200
    36.629     1.576     0.200
    37.380     1.392     0.200
    37.430     1.728     0.200
    37.655     1.540     0.200
    37.908     1.522     0.200
    37.940     1.753     0.200
    37.940     1.370     0.200
    38.199     2.117     0.200
    38.311     1.716     0.200
    38.487     1.421     0.200
    38.557     1.959     0.200
    38.824     1.331     0.200
    38.948     2.582     0.200
    40.649     0.515     0.200
    40.610     1.890     0.200
    40.724     0.074     0.200
    40.724    -0.762     0.200
    40.851     0.544     0.200
    40.928     1.591     0.200
    42.829    -0.577     0.200
    43.742     0.995     0.200
    43.742     1.198     0.200
    45.190     5.762     0.200
    45.622     4.311     0.200
    45.866     1.608     0.200
    46.008     1.988     0.200
    46.161     6.380     0.200
    46.387     3.163     0.200
    46.738     1.125     0.200
    46.774     1.597     0.200
    46.957     2.052     0.200
    47.081     2.237     0.200
    47.102     2.793     0.200
    47.104     3.322     0.200
    47.104     0.228     0.200
    47.135     3.438     0.200
    47.284     5.165     0.200
    47.368     1.624     0.200
    47.557     1.954     0.200
    50.878     1.210     0.200
    50.933     0.888     0.200
    50.933     0.692     0.200
    55.676     0.509     0.200
    56.198     4.269     0.200
    56.198     1.613     0.200
    60.427     0.210     0.200
    62.750     4.726     0.200
    63.267     2.492     0.200
    63.271     2.470     0.200
    64.375    -0.790     0.200
    66.060     0.910     0.200
    70.264     2.056     0.200
    72.626     3.809     0.200
    74.609     0.490     0.200
    74.609     0.482     0.200
    75.360     0.894     0.200
    77.419     0.545     0.200
    77.419     1.138     0.200
    77.419     1.138     0.200
    77.689     1.227     0.200
    77.689     2.329     0.200
    78.108     3.397     0.200
    79.415     0.016     0.200
    79.769     0.987     0.200
    80.014    -0.440     0.200
    80.014     2.021     0.200
    80.662     1.274     0.200
    80.700     1.067     0.200
    80.945     5.056     0.200
    80.953     1.012     0.200
    81.251     2.132     0.200
    81.513     1.239     0.200
    81.537     2.310     0.200
    81.554     0.526     0.200
    81.554     0.471     0.200
    81.675     4.180     0.200
    82.159     1.339     0.200
    82.198     1.226     0.200
    82.320     1.427     0.200
    82.351     2.230     0.200
    82.373     1.616     0.200
    82.424     1.348     0.200
    82.361     1.908     0.200
    82.442     1.258     0.200
    82.442     1.453     0.200
    83.080     3.441     0.200
    83.080     2.134     0.200
    83.081     2.131     0.200
    83.353     2.491     0.200
    83.442    -1.327     0.200
    83.518     0.581     0.200
    83.518     1.409     0.200
    83.616     1.475     0.200
    83.648     1.116     0.200
    83.736     1.561     0.200
    83.803     1.017     0.200
    83.809     1.384     0.200
    83.810     1.182     0.200
    83.851     1.373     0.200
    83.908     1.581     0.200
    83.910     0.866     0.200
    83.920     1.119     0.200
    84.065     3.880     0.200
    84.258     0.900     0.200
    84.304     0.714     0.200
    84.315     1.907     0.200
    84.461     1.164     0.200
    84.588     1.227     0.200
    84.739     1.361     0.200
    84.754     1.187     0.200
    84.964     1.129     0.200
    85.234     0.875     0.200
    85.219    -0.250     0.200
    85.271     4.988     0.200
    85.419     1.249     0.200
    85.583     1.636     0.200
    85.659     1.157     0.200
    85.892     1.204     0.200
    85.953     2.049     0.200
    85.985     1.641     0.200
    86.477     1.011     0.200
    86.500     1.703     0.200
    86.523     1.788     0.200
    87.154     0.495     0.200
    87.378    -0.075     0.200
    87.378    -0.098     0.200
    87.382     1.375     0.200
    87.452     0.565     0.200
    88.252    -0.503     0.200
    89.052     1.631     0.200
    89.052     1.631     0.200
    89.606    -0.149     0.200
    89.676    -0.053     0.200
    89.738     4.459     0.200
    89.747     2.022     0.200
    89.808     1.937     0.200
    90.013     0.584     0.200
    90.186    -1.023     0.200
    90.475     1.224     0.200
    90.613     5.288     0.200
    90.695     0.304     0.200
    90.695     1.234     0.200
    90.971     4.217     0.200
    91.254     5.903     0.200
    91.538    -0.608     0.200
    91.565     4.766     0.200
    91.701     3.134     0.200
    91.701     0.305     0.200
    91.701     0.329     0.200
    91.855     1.116     0.200
    91.987     2.250     0.200
    91.987     2.250     0.200
    92.450     1.620     0.200
    92.454     1.600     0.200
    92.727     0.792     0.200
    92.988     0.792     0.200
    93.173     3.836     0.200
    93.253    -0.032     0.200
    94.439     0.309     0.200
    94.443     0.792     0.200
    94.655     3.717     0.200
    94.757     0.158     0.200
    94.988     0.751     0.200
    95.022     3.346     0.200
    95.051     2.713     0.200
    95.051    -0.248     0.200
    96.122     0.123     0.200
    96.533     0.758     0.200
    96.635     0.269     0.200
    96.843    -0.544     0.200
    16.024     5.095     0.200
    23.063     1.143     0.200
    27.984     2.282     0.200
    30.236     0.711     0.200
    37.810     1.623     0.200
    37.843     1.847     0.200
    40.514     0.746     0.200
    45.765     0.953     0.200
    47.059     3.513     0.200
    47.209     2.724     0.200
    47.465     1.219     0.200
    55.634     1.180     0.200
    70.742    -0.575     0.200
    74.555     0.327     0.200
    77.382     0.718     0.200
    77.382     1.289     0.200
    77.616     0.933     0.200
    79.880     0.648     0.200
    80.650     0.999     0.200
    80.941     0.939     0.200
    81.506     0.991     0.200
    82.189     1.043     0.200
    82.254     0.719     0.200
    82.383     1.234     0.200
    82.406     1.306     0.200
    82.451     0.876     0.200
    82.974     2.954     0.200
    83.600     1.226     0.200
    83.637     0.830     0.200
    83.791     0.846     0.200
    83.795     1.024     0.200
    83.796     1.117     0.200
    83.797     1.510     0.200
    83.837     1.211     0.200
    83.891     1.530     0.200
    83.898     0.698     0.200
    83.912     1.026     0.200
    84.245     0.725     0.200
    84.308     0.360     0.200
    84.311     1.795     0.200
    84.453     0.875     0.200
    84.571     1.072     0.200
    84.736     1.148     0.200
    84.947     0.982     0.200
    85.405     1.191     0.200
    85.636     1.641     0.200
    86.465     0.542     0.200
    86.487     1.234     0.200
    86.509     1.724     0.200
    87.354    -0.424     0.200
    91.661    -0.435     0.200
    91.886     1.640     0.200
    92.366     0.432     0.200
    15.865     3.630     0.200
    20.847     0.371     0.200
    21.738     0.755     0.200
    23.025     0.907     0.200
    24.136     2.487     0.200
    27.798     1.820     0.200
    30.090     0.502     0.200
    37.393     1.473     0.200
    37.648     1.807     0.200
    45.562     0.578     0.200
    46.311     1.490     0.200
    46.470     6.897     0.200
    47.422     3.259     0.200
    47.865     2.830     0.200
    55.552     0.966     0.200
    55.552     1.356     0.200
    60.275    -0.290     0.200
    62.570     1.336     0.200
    70.954    -0.651     0.200
    74.447     0.686     0.200
    77.309     0.924     0.200
    77.309     0.424     0.200
    79.432    -0.114     0.200
    80.627     0.520     0.200
    80.669     0.502     0.200
    80.919     0.460     0.200
    81.413     0.740     0.200
    82.108     0.576     0.200
    82.173     0.633     0.200
    82.372     0.788     0.200
    82.404     0.822     0.200
    82.472     0.466     0.200
    83.569     0.786     0.200
    83.618     0.435     0.200
    83.716     0.933     0.200
    83.765     0.579     0.200
    83.770     0.358     0.200
    83.772     0.745     0.200
    83.793     1.140     0.200
    83.812     0.836     0.200
    83.859     1.002     0.200
    83.875     0.219     0.200
    83.896     0.610     0.200
    84.222     0.247     0.200
    84.306     1.420     0.200
    84.318     1.437     0.200
    84.437     0.458     0.200
    84.540     0.635     0.200
    84.702     0.622     0.200
    84.915     0.546     0.200
    85.378     0.731     0.200
    85.565     0.694     0.200
    85.861     0.522     0.200
    86.461     1.061     0.200
    86.484     1.051     0.200
    87.032     0.572     0.200
    87.307     1.090     0.200
    91.581     0.413     0.200
    91.684     0.264     0.200
    14.895     3.807     0.200
    15.391     3.493     0.200
    15.452     8.131     0.200
    15.683     3.303     0.200
    15.799     3.357     0.200
    15.895     2.829     0.200
    15.998     6.022     0.200
    16.034     2.955     0.200
    16.135     3.698     0.200
    16.384     2.260     0.200
    16.384     2.535     0.200
    16.847     4.623     0.200
    17.123     1.843     0.200
    17.266     3.586     0.200
    17.723     2.394     0.200
    17.851     2.505     0.200
    18.438     1.098     0.200
    18.668     0.284     0.200
    19.158     0.673     0.200
    21.306     0.162     0.200
    21.572     0.694     0.200
    21.773     0.823     0.200
    21.855     0.197     0.200
    21.927     0.944     0.200
    22.445     1.961     0.200
    22.896     1.985     0.200
    22.944     1.232     0.200
    23.186     1.221     0.200
    23.177     1.689     0.200
    23.488     1.861     0.200
    23.649     1.364     0.200
    23.970    -0.839     0.200
    24.002     0.747     0.200
    24.282     1.016     0.200
    24.454     0.371     0.200
    24.595    -0.837     0.200
    24.595    -0.137     0.200
    26.182     0.456     0.200
    26.182     1.181     0.200
    27.079     0.761     0.200
    27.286     1.280     0.200
    28.193     1.098     0.200
    28.392     2.285     0.200
    28.392     2.500     0.200
    28.877     1.201     0.200
    29.400     0.955     0.200
    29.582     1.072     0.200
    30.332     0.705     0.200
    30.570     0.943     0.200
    30.570     0.948     0.200
    30.898    -0.461     0.200
    30.988     0.574     0.200
    31.172     0.764     0.200
    31.196     1.202     0.200
    32.125     0.717     0.200
    32.448     2.578     0.200
    32.546     2.173     0.200
    33.500     0.267     0.200
    33.555     1.399     0.200
    33.844     2.302     0.200
    34.024     1.717     0.200
    34.357     1.701     0.200
    34.768     1.670     0.200
    35.571     2.533     0.200
    35.691     0.719     0.200
    35.841     1.833     0.200
    36.330     2.853     0.200
    36.564     1.455     0.200
    36.595     2.859     0.200
    36.606     1.789     0.200
    36.962     2.357     0.200
    37.955     1.668     0.200
    38.238     2.462     0.200
    38.266     1.827     0.200
    38.266     1.517     0.200
    38.530     1.993     0.200
    38.637     2.099     0.200
    38.818     1.935     0.200
    38.891     2.415     0.200
    39.156     2.612     0.200
    40.776     0.493     0.200
    40.776    -0.107     0.200
    40.933     1.750     0.200
    41.256     1.663     0.200
    42.957    -0.965     0.200
    43.974     0.656     0.200
    43.974     0.781     0.200
    46.201     1.825     0.200
    46.431     2.428     0.200
    46.643     3.115     0.200
    46.643     2.357     0.200
    46.773     2.749     0.200
    46.773     1.489     0.200
    46.777     4.362     0.200
    46.807     2.311     0.200
    47.074     0.937     0.200
    47.220     2.265     0.200
    47.244     1.951     0.200
    51.067     1.105     0.200
    52.261     3.833     0.200
    53.873     0.398     0.200
    55.845     1.318     0.200
    55.845     1.118     0.200
    56.532     1.709     0.200
    56.532     2.589     0.200
    60.624    -0.714     0.200
    63.219     1.254     0.200
    64.052     0.199     0.200
    65.314     2.494     0.200
    66.473     0.260     0.200
    66.473     0.255     0.200
    69.922     0.660     0.200
    72.960     0.649     0.200
    74.815     0.116     0.200
    74.814     0.111     0.200
    74.919    -0.218     0.200
    74.912     1.722     0.200
    75.460     2.289     0.200
    77.211     3.926     0.200
    77.572     1.305     0.200
    77.572     2.055     0.200
    77.572     2.055     0.200
    77.905     3.448     0.200
    79.074     1.476     0.200
    79.525     0.033     0.200
    79.702    -0.129     0.200
    79.702     1.911     0.200
    79.833     0.456     0.200
    79.957     0.386     0.200
    80.737     0.489     0.200
    80.773     0.697     0.200
    81.029     0.431     0.200
    81.230    -1.144     0.200
    81.581    -0.802     0.200
    81.712    -0.693     0.200
    81.738     1.570     0.200
    81.738     1.520     0.200
    81.890    -0.430     0.200
    81.989     3.606     0.200
    82.251     0.772     0.200
    82.264     0.504     0.200
    82.519     0.975     0.200
    82.534     3.185     0.200
    82.737     3.148     0.200
    83.177     1.054     0.200
    83.177     1.229     0.200
    83.449     3.475     0.200
    83.417     1.057     0.200
    83.417     1.016     0.200
    83.704     0.846     0.200
    83.718     0.570     0.200
    83.797     1.068     0.200
    83.785    -3.871     0.200
    83.847     0.911     0.200
    83.876     0.462     0.200
    83.886     0.711     0.200
    83.897     0.658     0.200
    83.930     0.787     0.200
    83.986     0.301     0.200
    83.985     0.708     0.200
    83.998     1.042     0.200
    84.254     2.836     0.200
    84.327     1.294     0.200
    84.334     0.329     0.200
    84.526     0.560     0.200
    84.677     0.695     0.200
    84.790     1.025     0.200
    84.847     0.638     0.200
    85.054     0.500     0.200
    85.355     2.695     0.200
    85.408    -0.172     0.200
    85.444    -1.353     0.200
    85.502     0.860     0.200
    85.612     2.514     0.200
    85.640     0.570     0.200
    85.768     3.737     0.200
    85.963     0.770     0.200
    86.051     0.737     0.200
    86.074     2.890     0.200
    86.580     1.130     0.200
    86.596     2.450     0.200
    86.603     1.519     0.200
    86.885     2.138     0.200
    86.993     0.511     0.200
    87.034     0.409     0.200
    87.145     0.572     0.200
    87.210     1.854     0.200
    87.223     0.895     0.200
    87.458     1.254     0.200
    87.490     1.650     0.200
    87.547     0.759     0.200
    87.884     0.014     0.200
    87.920    -0.155     0.200
    87.968     0.016     0.200
    88.087     1.051     0.200
    88.597     0.940     0.200
    88.946     1.198     0.200
    89.782     1.077     0.200
    89.932     1.677     0.200
    89.932     1.011     0.200
    89.935     2.166     0.200
    90.075     2.910     0.200
    90.149     1.765     0.200
    90.527     2.104     0.200
    90.606     2.034     0.200
    90.650     2.831     0.200
    90.822     0.530     0.200
    90.936     1.503     0.200
    90.938     3.890     0.200
    91.300     2.712     0.200
    91.508     2.946     0.200
    91.814     2.128     0.200
    91.865     1.196     0.200
    91.865     0.596     0.200
    91.865     0.596     0.200
    91.866     0.192     0.200
    92.155    -0.145     0.200
    92.321     2.767     0.200
    92.321     2.767     0.200
    92.752     1.266     0.200
    92.756     1.252     0.200
    99.616    -0.074     0.200
    15.990     2.429     0.200
    23.032     0.150     0.200
    16.003     3.026     0.200
    23.070     1.586     0.200
    27.956     1.395     0.200
    30.219    -0.329     0.200
    37.542     1.584     0.200
    37.812     1.930     0.200
    55.632     1.929     0.200
    81.502     1.244     0.200
    14.300     4.726     0.200
    14.533     4.082     0.200
    14.617     3.687     0.200
    15.384     2.768     0.200
    15.444     3.452     0.200
    15.609     2.653     0.200
    15.736     2.796     0.200
    15.752     3.646     0.200
    15.870     2.690     0.200
    15.896     2.793     0.200
    16.174     2.092     0.200
    16.174     2.816     0.200
    16.406     1.836     0.200
    16.934     2.183     0.200
    18.326     0.794     0.200
    18.655    -0.840     0.200
    19.680     0.670     0.200
    20.056    -1.121     0.200
    21.118     0.582     0.200
    21.353     0.753     0.200
    21.693     0.595     0.200
    21.761     1.274     0.200
    21.799     0.713     0.200
    22.012     0.664     0.200
    22.469     2.014     0.200
    22.999     1.093     0.200
    23.019     0.673     0.200
    23.113     0.371     0.200
    23.261     1.139     0.200
    23.741     1.216     0.200
    23.784     1.114     0.200
    23.937     0.038     0.200
    24.298     0.605     0.200
    24.365     0.700     0.200
    24.447     0.225     0.200
    24.463     0.501     0.200
    26.290     0.010     0.200
    26.290     0.485     0.200
    26.691     0.297     0.200
    27.144     1.031     0.200
    28.155     2.242     0.200
    28.155     2.637     0.200
    28.305     0.464     0.200
    29.463     1.361     0.200
    30.213     0.897     0.200
    30.375     0.810     0.200
    30.375     0.815     0.200
    30.988     0.396     0.200
    33.563     0.653     0.200
    33.589     0.043     0.200
    34.401     0.767     0.200
    35.331     2.097     0.200
    36.366     2.363     0.200
    37.511     3.447     0.200
    37.729     1.676     0.200
    38.020     2.049     0.200
    38.020     1.719     0.200
    38.391     3.120     0.200
    38.391     1.740     0.200
    38.638     0.711     0.200
    40.689     1.092     0.200
    40.742    -0.100     0.200
    40.742    -0.695     0.200
    41.008     1.617     0.200
    43.390     1.649     0.200
    43.802    -0.005     0.200
    46.668     2.172     0.200
    47.026     1.176     0.200
    47.301     1.757     0.200
    47.301     1.867     0.200
    47.485     2.022     0.200
    50.928     1.719     0.200
    50.971     1.297     0.200
    55.722     0.871     0.200
    55.722     1.671     0.200
    56.279     1.379     0.200
    60.479    -0.551     0.200
    62.962     0.963     0.200
    63.349    -0.271     0.200
    63.352    -0.299     0.200
    72.707    -0.164     0.200
    74.663     0.023     0.200
    74.663     0.028     0.200
    74.765    -0.939     0.200
    77.461     1.117     0.200
    77.461     1.448     0.200
    77.461     1.443     0.200
    77.745     1.027     0.200
    77.745    -0.193     0.200
    79.790     0.583     0.200
    79.911     1.226     0.200
    80.686     0.857     0.200
    80.724     0.853     0.200
    80.977     0.898     0.200
    81.094    -1.522     0.200
    81.331    -1.085     0.200
    81.566     0.373     0.200
    81.603     1.077     0.200
    81.603     1.028     0.200
    82.187     1.805     0.200
    82.220     1.030     0.200
    82.381     1.490     0.200
    82.449     1.132     0.200
    82.453     1.814     0.200
    82.442     0.693     0.200
    83.159     0.493     0.200
    83.160     0.539     0.200
    83.524     1.064     0.200
    83.643     1.155     0.200
    83.671     1.811     0.200
    83.757     1.170     0.200
    83.826     1.215     0.200
    83.833     1.278     0.200
    83.837     0.961     0.200
    83.876     1.162     0.200
    83.934     0.762     0.200
    83.935     1.358     0.200
    83.942     0.924     0.200
    84.282     0.592     0.200
    84.315     1.074     0.200
    84.332     1.637     0.200
    84.483     0.874     0.200
    84.615     1.005     0.200
    84.782     0.964     0.200
    84.991     0.910     0.200
    85.269     1.420     0.200
    85.277     0.178     0.200
    85.445     1.141     0.200
    85.988     1.965     0.200
    86.501     0.716     0.200
    86.525     1.497     0.200
    86.548     1.586     0.200
    86.987     1.038     0.200
    87.092     0.825     0.200
    87.142     4.185     0.200
    87.368     1.387     0.200
    87.410     0.285     0.200
    87.410     0.310     0.200
    87.481     1.815     0.200
    87.836     0.643     0.200
    89.790     0.443     0.200
    89.827     5.669     0.200
    90.051     0.923     0.200
    90.512     1.272     0.200
    91.746    -0.803     0.200
    91.746    -0.753     0.200
    92.068     1.398     0.200
    92.525    -0.404     0.200
    92.529    -0.423     0.200
    93.846     0.858     0.200
    16.122     1.843     0.200
    30.324     1.694     0.200
    37.973     1.042     0.200
    22.984     0.312     0.200
    29.939     1.446     0.200
    37.448     1.450     0.200
    15.050     3.589     0.200
    15.354     3.057     0.200
    17.123     1.741     0.200
    21.717     0.535     0.200
    21.940     1.171     0.200
    22.999     0.149     0.200
    24.218     0.673     0.200
    27.289    -0.099     0.200
    27.718     2.279     0.200
    30.024    -0.416     0.200
    37.316     0.558     0.200
    37.566     1.142     0.200
    80.898     1.084     0.200
    81.365     1.027     0.200
    82.469     0.793     0.200
    83.598     1.146     0.200
    83.790     1.360     0.200
    83.835     1.733     0.200
    83.878     1.312     0.200
    84.201     0.866     0.200
    84.310     0.858     0.200
    84.515     1.370     0.200
    84.676     1.456     0.200
    84.891     1.275     0.200
    15.151     2.996     0.200
    15.284     3.197     0.200
    15.659     1.945     0.200
    15.842     1.779     0.200
    16.049     1.542     0.200
    17.261     1.372     0.200
    18.081     1.013     0.200
    18.600    -1.044     0.200
    20.665     0.238     0.200
    21.696     0.038     0.200
    22.040     0.029     0.200
    22.965     0.148     0.200
    23.252     0.335     0.200
    23.303     0.743     0.200
    24.398     2.964     0.200
    24.523     1.352     0.200
    27.351     0.841     0.200
    27.559     2.207     0.200
    29.898    -0.030     0.200
    32.773     1.367     0.200
    34.553     0.866     0.200
    37.166     0.655     0.200
    37.399     1.376     0.200
    47.685     3.270     0.200
    81.282     1.816     0.200
    82.854    -0.811     0.200
    91.960     0.187     0.200
    93.179    -2.019     0.200
    16.104     2.928     0.200
    21.771    -0.026     0.200
    23.080     0.367     0.200
    26.313     2.913     0.200
    28.079     2.676     0.200
    30.309     2.085     0.200
    37.656     1.824     0.200
    37.942     2.230     0.200
    81.552     1.618     0.200
    23.015     0.870     0.200
    27.790     2.461     0.200
    37.384     2.759     0.200
    37.640     1.232     0.200
    14.932     3.278     0.200
    15.710     3.991     0.200
    15.805     3.685     0.200
    16.642     1.089     0.200
    22.913     0.913     0.200
    26.201    -0.046     0.200
    28.292     2.521     0.200
    30.480     1.384     0.200
    38.164     2.478     0.200
    22.963     1.120     0.200
    37.163     3.754     0.200
    16.005     1.759     0.200
    23.030     1.575     0.200
    30.215     0.616     0.200
    37.834     1.999     0.200
    14.350     3.947     0.200
    14.673     8.324     0.200
    14.886     3.162     0.200
    15.105     4.395     0.200
    15.185     4.199     0.200
    15.230     3.141     0.200
    15.249     3.924     0.200
    15.363     3.820     0.200
    15.448     3.485     0.200
    15.610     2.646     0.200
    15.610     2.747     0.200
    15.897     3.515     0.200
    16.006     2.425     0.200
    16.435     2.931     0.200
    16.553     4.813     0.200
    16.814     1.644     0.200
    17.280     2.153     0.200
    18.045     1.635     0.200
    20.618     0.585     0.200
    21.233     0.558     0.200
    21.335     3.010     0.200
    22.046     0.209     0.200
    22.558     1.655     0.200
    22.935     2.065     0.200
    22.935     1.162     0.200
    23.306     1.953     0.200
    24.120     1.286     0.200
    24.174     2.260     0.200
    24.244     2.312     0.200
    24.438     3.374     0.200
    24.519     2.045     0.200
    24.613     2.492     0.200
    24.870     1.292     0.200
    26.608     1.391     0.200
    26.608     0.367     0.200
    27.063     1.398     0.200
    27.345     1.150     0.200
    27.509     1.069     0.200
    28.780     1.453     0.200
    28.973     1.786     0.200
    29.249     1.282     0.200
    29.851     0.599     0.200
    31.252     1.037     0.200
    31.254     3.687     0.200
    32.893     4.437     0.200
    34.185    -1.595     0.200
    36.103     4.576     0.200
    36.103     3.220     0.200
    37.116     2.440     0.200
    37.349     1.265     0.200
    37.949     1.701     0.200
    40.330     2.459     0.200
    40.667     1.338     0.200
    46.261     5.089     0.200
    46.760     5.029     0.200
    46.987     4.380     0.200
    47.323     1.763     0.200
    47.693     5.672     0.200
    47.713     6.648     0.200
    47.726     4.848     0.200
    47.931     3.831     0.200
    47.931     4.191     0.200
    48.152     3.245     0.200
    60.093     1.705     0.200
    62.259     4.849     0.200
    62.635     4.532     0.200
    66.719     3.747     0.200
    77.166     2.893     0.200
    80.648     2.049     0.200
    80.727     1.927     0.200
    81.173     2.348     0.200
    81.241     0.311     0.200
    81.725     4.125     0.200
    82.451     3.967     0.200
    82.807    -2.539     0.200
    83.743     4.629     0.200
    84.826     3.031     0.200
    87.200     2.904     0.200
    88.416     5.079     0.200
    88.417     5.078     0.200
    89.149     4.534     0.200
    89.149     4.682     0.200
    89.791     4.624     0.200
    90.263     0.219     0.200
    90.573     5.378     0.200
    91.125     3.010     0.200
    91.376     4.485     0.200
    91.428     2.930     0.200
    91.909     4.303     0.200
    93.131    -2.265     0.200
    97.505    -0.132     0.200
    15.220     2.883     0.200
    15.500     5.877     0.200
    16.553     2.532     0.200
    18.067     1.775     0.200
    18.588     0.229     0.200
    19.603    -2.135     0.200
    20.653     0.268     0.200
    21.681     0.536     0.200
    21.761     0.377     0.200
    22.028     1.067     0.200
    22.256     0.635     0.200
    22.557     0.931     0.200
    22.950    -0.040     0.200
    23.238     0.534     0.200
    23.290     0.774     0.200
    23.502    -0.047     0.200
    24.146    -0.301     0.200
    24.153     1.327     0.200
    24.237     0.814     0.200
    24.396     0.563     0.200
    24.601     0.845     0.200
    26.592     1.482     0.200
    27.551     0.704     0.200
    29.887     0.222     0.200
    32.758     1.306     0.200
    34.539     0.516     0.200
    37.157     0.633     0.200
    37.393     0.625     0.200
    40.676     0.224     0.200
    55.421    -0.217     0.200
    55.634     0.648     0.200
    55.634     1.249     0.200
    62.304     0.372     0.200
    66.762     0.796     0.200
    72.061     1.321     0.200
    77.347     1.370     0.200
    81.268     0.320     0.200
    84.859     0.285     0.200
    89.193     3.541     0.200
    91.160     0.965     0.200
    91.452     0.310     0.200
    91.951     0.752     0.200
    94.535     0.684     0.200
    94.827     0.061     0.200
    96.046     1.092     0.200
    96.149     0.601     0.200
    97.550     0.184     0.200
    14.795     8.568     0.200
    16.126     2.969     0.200
    21.074     0.127     0.200
    21.781    -0.163     0.200
    23.091    -0.050     0.200
    37.966     2.283     0.200
    16.168     3.006     0.200
    21.110     0.486     0.200
    21.782     1.040     0.200
    23.097    -0.868     0.200
    23.097     0.177     0.200
    30.368     0.520     0.200
    37.726     1.292     0.200
    38.020     1.033     0.200
    81.590     0.200     0.200
    16.258     2.329     0.200
    22.920     0.846     0.200
    23.119     0.602     0.200
    26.209     0.466     0.200
    30.451     0.342     0.200
    38.130     0.164     0.200
    56.395     1.476     0.200
    95.614    -0.998     0.200
    20.966    -0.030     0.200
    23.029    -0.284     0.200
    24.407     0.954     0.200
    30.219     1.834     0.200
    37.841     3.240     0.200
    81.480     2.119     0.200
    91.632     2.657     0.200
    95.312    -1.830     0.200
    98.048    -0.329     0.200
    15.688     5.017     0.200
    18.097     0.341     0.200
    21.704    -0.142     0.200
    22.976    -0.268     0.200
    24.362     1.534     0.200
    27.342     0.830     0.200
    29.926    -0.080     0.200
    37.434     2.826     0.200
    94.867     1.031     0.200
    15.635     2.473     0.200
    16.027     2.650     0.200
    21.679     0.689     0.200
    22.948     0.489     0.200
    27.344     1.213     0.200
    29.874     1.676     0.200
    37.376     1.238     0.200
    62.286     3.283     0.200
    94.808     0.130     0.200
    16.104     3.171     0.200
    21.784     0.681     0.200
    23.092    -0.481     0.200
    37.936     1.350     0.200
    16.260     2.223     0.200
    28.265     1.208     0.200
    37.829     0.574     0.200
    38.139     0.686     0.200
    22.954     0.277     0.200
    37.191     1.389     0.200
    37.431    -0.204     0.200
    15.528     2.774     0.200
    15.755     2.486     0.200
    16.339     3.970     0.200
    16.339     1.576     0.200
    16.519     2.427     0.200
    21.262    -0.174     0.200
    21.827     0.885     0.200
    22.894     2.232     0.200
    23.155     1.575     0.200
    30.526     1.429     0.200
    38.220     2.546     0.200
    43.932     1.367     0.200
    15.084     3.444     0.200
    16.358     1.601     0.200
    20.597     0.257     0.200
    21.695     0.961     0.200
    22.956    -0.273     0.200
    29.826     0.286     0.200
    37.076     0.630     0.200
    37.296     0.878     0.200
    15.738     1.926     0.200
    16.316     1.962     0.200
    30.508     0.304     0.200
    38.184     1.943     0.200
    16.098     3.450     0.200
    16.271     1.175     0.200
    37.937     0.507     0.200
    37.937     0.507     0.200
    15.192     2.864     0.200
    15.622     2.309     0.200
    16.441     3.066     0.200
    18.627    -0.397     0.200
    20.625     0.168     0.200
    21.653     0.664     0.200
    22.923    -0.721     0.200
    27.317     1.005     0.200
    27.528     1.391     0.200
    29.859     0.593     0.200
    37.132     0.327     0.200
    37.371     0.652     0.200
    94.809     0.060     0.200
    97.537    -0.837     0.200
    14.720     3.928     0.200
    14.758     4.749     0.200
    14.768     3.532     0.200
    14.787     4.901     0.200
    15.084     3.604     0.200
    15.086     3.367     0.200
    15.357     3.066     0.200
    15.579     3.309     0.200
    15.625     3.149     0.200
    15.662     3.744     0.200
    15.734     3.060     0.200
    15.795     3.590     0.200
    15.810     3.926     0.200
    16.341     3.070     0.200
    16.416     2.655     0.200
    16.515     2.337     0.200
    16.817     2.763     0.200
    16.860     2.696     0.200
    16.948     3.871     0.200
    17.505     2.423     0.200
    17.531     3.628     0.200
    17.538     1.846     0.200
    18.274     1.426     0.200
    18.470     0.214     0.200
    18.515    -0.385     0.200
    18.537    -0.076     0.200
    18.634    -0.919     0.200
    18.696     0.145     0.200
    18.702    -0.366     0.200
    18.713     0.587     0.200
    18.729     0.660     0.200
    19.022     0.313     0.200
    19.053    -0.056     0.200
    19.185     0.581     0.200
    19.338    -0.096     0.200
    19.420     1.082     0.200
    19.514     0.771     0.200
    19.639     1.026     0.200
    19.751     0.811     0.200
    20.047     1.035     0.200
    20.064    -0.627     0.200
    20.145    -0.351     0.200
    20.600     0.552     0.200
    20.664     0.066     0.200
    21.029    -0.399     0.200
    21.360     0.746     0.200
    21.718    -2.097     0.200
    21.740     0.018     0.200
    21.740     2.240     0.200
    21.763    -0.609     0.200
    21.763    -0.422     0.200
    21.787    -0.039     0.200
    22.024     1.060     0.200
    22.459    -0.516     0.200
    23.018     1.166     0.200
    23.027    -1.209     0.200
    23.072     0.596     0.200
    23.072    -0.607     0.200
    23.272     2.533     0.200
    23.814     0.247     0.200
    23.820    -0.344     0.200
    24.023     2.630     0.200
    24.063    -0.207     0.200
    24.305     2.055     0.200
    24.375     0.316     0.200
    24.404     0.852     0.200
    24.404    -0.148     0.200
    26.310     1.041     0.200
    26.310     1.166     0.200
    26.718     0.860     0.200
    26.894    -0.142     0.200
    27.149     0.702     0.200
    28.069     2.144     0.200
    28.327    -0.598     0.200
    28.327     1.082     0.200
    28.362    -2.898     0.200
    29.456     0.668     0.200
    30.158     0.889     0.200
    30.299     0.742     0.200
    32.117     2.243     0.200
    32.600     0.272     0.200
    33.872     0.554     0.200
    34.181     3.580     0.200
    34.399     0.389     0.200
    34.549     2.578     0.200
    35.079     2.354     0.200
    35.244     2.139     0.200
    35.855     2.333     0.200
    36.228     2.668     0.200
    36.279     2.208     0.200
    36.551     0.986     0.200
    37.370     2.965     0.200
    37.423     2.209     0.200
    37.646     1.606     0.200
    37.901     2.448     0.200
    37.932     1.881     0.200
    38.191     2.292     0.200
    38.304     2.348     0.200
    38.304     2.160     0.200
    38.479     1.510     0.200
    38.550     1.765     0.200
    38.817     2.399     0.200
    38.941     1.695     0.200
    38.945     3.238     0.200
    40.602     2.329     0.200
    40.713     0.125     0.200
    40.713     1.172     0.200
    40.920     1.487     0.200
    43.731     0.745     0.200
    44.144     1.909     0.200
    45.859     0.406     0.200
    46.388     5.487     0.200
    46.738     1.807     0.200
    46.770     3.244     0.200
    46.875     0.986     0.200
    46.958     4.784     0.200
    47.082     3.306     0.200
    47.103     2.675     0.200
    47.106     0.330     0.200
    47.106     3.549     0.200
    47.137     4.270     0.200
    47.273     2.274     0.200
    47.367     2.015     0.200
    47.367     1.238     0.200
    47.558     1.920     0.200
    50.867     1.448     0.200
    50.922     2.931     0.200
    50.922     3.802     0.200
    53.630     1.011     0.200
    55.665     1.236     0.200
    55.665     1.439     0.200
    56.191     2.669     0.200
    56.191     1.599     0.200
    60.416    -0.169     0.200
    61.602     1.543     0.200
    61.602     0.961     0.200
    62.746     2.604     0.200
    63.266     1.117     0.200
    66.062     1.938     0.200
    67.287     0.666     0.200
    67.287     0.248     0.200
    70.268     1.865     0.200
    70.638    -1.232     0.200
    72.619     0.393     0.200
    72.619    -0.845     0.200
    74.566     0.548     0.200
    74.566     1.478     0.200
    74.598    -0.639     0.200
    74.700    -1.529     0.200
    77.407     0.843     0.200
    77.407     1.167     0.200
    77.514     1.045     0.200
    77.678     0.227     0.200
    77.764     4.747     0.200
    77.831     0.980     0.200
    78.103     2.065     0.200
    79.447     0.969     0.200
    79.758     1.081     0.200
    79.878     0.928     0.200
    79.924     3.582     0.200
    80.651     1.367     0.200
    80.689     1.359     0.200
    80.935     3.548     0.200
    80.943     1.206     0.200
    81.033    -0.276     0.200
    81.039     4.092     0.200
    81.243    -0.095     0.200
    81.250     4.169     0.200
    81.502    -0.070     0.200
    81.527     6.505     0.200
    81.543     0.994     0.200
    81.650     1.659     0.200
    81.987     4.775     0.200
    82.015     1.326     0.200
    82.148     1.329     0.200
    82.188     1.320     0.200
    82.309     1.429     0.200
    82.308     3.892     0.200
    82.341     4.016     0.200
    82.356     0.789     0.200
    82.363     2.004     0.200
    82.413     1.541     0.200
    82.426     1.385     0.200
    82.432     1.645     0.200
    82.508     4.248     0.200
    82.539     5.087     0.200
    82.697     5.063     0.200
    83.077     0.823     0.200
    83.078     3.085     0.200
    83.078     0.784     0.200
    83.437    -1.672     0.200
    83.524     2.809     0.200
    83.605     1.467     0.200
    83.637     1.205     0.200
    83.726     1.649     0.200
    83.790     1.621     0.200
    83.792     1.309     0.200
    83.798     1.477     0.200
    83.799     1.373     0.200
    83.840     1.564     0.200
    83.897     1.772     0.200
    83.899     1.060     0.200
    83.910     1.406     0.200
    84.135    -0.538     0.200
    84.247     0.988     0.200
    84.293     0.730     0.200
    84.304     2.100     0.200
    84.451     1.153     0.200
    84.577     1.316     0.200
    84.729     1.350     0.200
    84.743     1.381     0.200
    84.823     0.175     0.200
    84.953     1.220     0.200
    85.208     0.641     0.200
    85.223     0.865     0.200
    85.301     4.777     0.200
    85.301     0.957     0.200
    85.408     1.542     0.200
    85.572     1.425     0.200
    85.648     2.049     0.200
    85.881     1.489     0.200
    85.942     1.300     0.200
    85.974     1.628     0.200
    86.489     1.691     0.200
    86.512     1.978     0.200
    86.778     1.610     0.200
    86.862     3.160     0.200
    86.920     0.584     0.200
    86.954     1.817     0.200
    87.057     1.210     0.200
    87.074     3.031     0.200
    87.098     1.813     0.200
    87.322     3.029     0.200
    87.367     1.061     0.200
    87.722     3.904     0.200
    87.789     3.279     0.200
    87.802     0.616     0.200
    87.887     0.614     0.200
    88.001     1.471     0.200
    88.298     3.063     0.200
    88.457     2.512     0.200
    89.048     3.883     0.200
    89.048     3.933     0.200
    89.727     1.448     0.200
    89.797     3.719     0.200
    90.002     1.468     0.200
    90.605     4.854     0.200
    90.787     4.009     0.200
    90.963     1.989     0.200
    91.554     3.946     0.200
    91.690     3.215     0.200
    91.690    -0.460     0.200
    91.691     0.113     0.200
    91.703     3.557     0.200
    91.846     0.095     0.200
    91.980     1.777     0.200
    92.445     0.629     0.200
    93.758    -1.829     0.200
    98.136    -1.347     0.200
    37.822     0.478     0.200
    16.113     2.076     0.200
    23.107    -0.084     0.200
    37.942     0.928     0.200
    37.851     0.341     0.200
    14.105     7.613     0.200
    14.556     3.996     0.200
    14.568     4.658     0.200
    14.736     4.357     0.200
    15.405     2.672     0.200
    15.602     3.210     0.200
    15.869     3.284     0.200
    16.114     1.936     0.200
    18.633    -0.656     0.200
    21.740    -0.989     0.200
    21.767     0.537     0.200
    22.455     0.099     0.200
    23.005    -0.367     0.200
    23.077     0.256     0.200
    24.416     0.331     0.200
    28.092     2.060     0.200
    28.092     0.334     0.200
    30.318    -0.284     0.200
    30.318    -0.292     0.200
    37.668     0.044     0.200
    37.957     2.133     0.200
    37.957     0.250     0.200
    40.945     0.487     0.200
    77.417     0.921     0.200
    77.417     0.929     0.200
    81.555     1.303     0.200
    81.555     1.303     0.200
    84.293     0.835     0.200
    92.005     3.973     0.200
    95.429    -1.529     0.200
    98.163    -0.112     0.200
    14.029     4.391     0.200
    14.377     3.925     0.200
    14.591     3.504     0.200
    14.679     3.470     0.200
    15.633     2.136     0.200
    15.633     2.425     0.200
    16.018     2.032     0.200
    16.018     2.840     0.200
    16.159     2.011     0.200
    16.198     1.147     0.200
    16.213     2.229     0.200
    16.336     1.144     0.200
    16.435     0.888     0.200
    16.453     3.123     0.200
    16.583     1.200     0.200
    16.589     1.432     0.200
    16.606     1.699     0.200
    16.768     1.080     0.200
    16.807     1.734     0.200
    16.839     0.603     0.200
    16.926     1.783     0.200
    17.025     1.603     0.200
    17.087     1.249     0.200
    17.097     1.166     0.200
    17.130     0.905     0.200
    17.240     1.054     0.200
    17.244     2.441     0.200
    17.286     0.626     0.200
    17.511     0.754     0.200
    17.548     0.223     0.200
    17.610     2.428     0.200
    17.921     1.443     0.200
    17.948     1.045     0.200
    18.049     1.100     0.200
    18.049     1.412     0.200
    18.276     1.610     0.200
    18.359    -0.119     0.200
    20.637     0.383     0.200
    21.491     3.988     0.200
    21.663     0.851     0.200
    21.663     0.312     0.200
    22.243     0.672     0.200
    22.933    -0.191     0.200
    24.128     1.427     0.200
    27.323     0.991     0.200
    27.539     2.731     0.200
    29.871     1.815     0.200
    36.063     3.851     0.200
    37.381     2.786     0.200
    43.356     1.084     0.200
    55.403     0.943     0.200
    62.295     3.944     0.200
    62.674     4.884     0.200
    82.846     0.713     0.200
    91.937     3.900     0.200
    16.009     4.676     0.200
    16.009     3.523     0.200
    21.722     0.290     0.200
    23.026     0.681     0.200
    30.218     0.936     0.200
    37.558     0.570     0.200
    37.842     2.330     0.200
    70.718    -0.224     0.200
    91.630     3.145     0.200
    15.631     3.426     0.200
    29.869    -1.211     0.200
    16.176     1.244     0.200
    28.155    -0.049     0.200
    30.378     0.465     0.200
    37.731     0.751     0.200
    38.019     0.338     0.200
    81.609     0.687     0.200
    15.467     4.499     0.200
    15.567     3.327     0.200
    15.694     7.523     0.200
    16.273     2.124     0.200
    17.018     2.735     0.200
    21.201     0.049     0.200
    21.928     0.882     0.200
    22.906     1.088     0.200
    22.941     1.008     0.200
    23.586     0.741     0.200
    24.282     1.232     0.200
    26.194     1.834     0.200
    28.277     2.378     0.200
    30.464     0.852     0.200
    37.842     2.093     0.200
    38.150     2.120     0.200
    41.140     1.950     0.200
    38.133     1.591     0.200
    14.627     4.235     0.200
    14.719     3.863     0.200
    14.939     3.910     0.200
    15.265     2.322     0.200
    15.774     2.048     0.200
    15.771     2.725     0.200
    15.909     2.794     0.200
    16.260     1.999     0.200
    16.260     1.324     0.200
    16.409     2.798     0.200
    16.450     2.505     0.200
    16.491     2.567     0.200
    16.721     5.952     0.200
    17.482     3.163     0.200
    17.605     3.735     0.200
    17.725     2.747     0.200
    17.755     2.432     0.200
    21.187     0.231     0.200
    21.780     0.494     0.200
    22.248     1.762     0.200
    22.894     0.486     0.200
    22.928     0.219     0.200
    23.104     0.984     0.200
    24.492    -0.501     0.200
    28.266     2.277     0.200
    30.450    -0.101     0.200
    35.445     2.275     0.200
    36.480     2.101     0.200
    37.830     0.489     0.200
    38.139     1.474     0.200
    38.511     1.343     0.200
    38.693     2.368     0.200
    41.130     1.098     0.200
    56.407     4.390     0.200
    81.634     2.647     0.200
    38.040     1.939     0.200
    37.859     1.410     0.200
    37.570     0.441     0.200
    15.634     2.528     0.200
    22.948    -0.017     0.200
    27.535     0.918     0.200
    29.874     0.194     0.200
    37.375     1.099     0.200
    62.660    -1.084     0.200
    74.276    -0.256     0.200
    22.951     0.071     0.200
    24.419     2.131     0.200
    29.875    -0.361     0.200
    37.374     1.028     0.200
    43.363     0.340     0.200
    62.657    -0.335     0.200
    78.683     0.077     0.200
    81.262     0.335     0.200
    91.935     0.036     0.200
    94.521     0.030     0.200
    96.031    -0.155     0.200
    96.134    -0.623     0.200
    16.007     5.513     0.200
    23.021     1.223     0.200
    37.841     3.322     0.200
    15.819     2.095     0.200
    16.837     1.196     0.200
    21.686     0.801     0.200
    21.777     1.721     0.200
    22.653    -0.815     0.200
    22.952    -0.328     0.200
    24.456     2.585     0.200
    27.506     1.143     0.200
    29.855     0.984     0.200
    37.343     1.528     0.200
    62.621     2.306     0.200
    94.771    -1.853     0.200
    97.490    -1.719     0.200
    15.979     4.406     0.200
    23.062     2.280     0.200
    37.783     1.752     0.200
    14.599     4.704     0.200
    14.687     3.995     0.200
    15.274     3.544     0.200
    15.317     3.084     0.200
    15.498     3.854     0.200
    15.696     3.343     0.200
    15.770     3.648     0.200
    16.056     2.135     0.200
    16.056     2.982     0.200
    16.377     2.185     0.200
    18.248     1.584     0.200
    18.287     1.451     0.200
    20.970     0.847     0.200
    21.727     1.409     0.200
    21.728     1.401     0.200
    21.745     0.778     0.200
    22.453     1.661     0.200
    22.459     1.168     0.200
    23.024     1.609     0.200
    23.029     0.994     0.200
    23.051    -0.551     0.200
    23.051    -0.176     0.200
    23.825     1.471     0.200
    23.855    -0.883     0.200
    23.893    -0.383     0.200
    24.038     3.053     0.200
    24.062     2.356     0.200
    24.376     0.170     0.200
    24.417     0.379     0.200
    24.568     0.366     0.200
    27.149     0.720     0.200
    28.029     1.864     0.200
    30.131     0.993     0.200
    30.263     0.576     0.200
    35.204     1.357     0.200
    36.581     2.724     0.200
    37.607     0.438     0.200
    37.860     2.366     0.200
    37.892     1.799     0.200
    38.263     0.167     0.200
    38.263     0.929     0.200
    38.439     0.810     0.200
    38.510     2.534     0.200
    40.562     3.427     0.200
    40.880     1.992     0.200
    47.141     3.178     0.200
    47.396     1.736     0.200
    55.637     0.644     0.200
    55.637     0.144     0.200
    56.151    -0.233     0.200
    63.227     0.648     0.200
    67.247    -0.654     0.200
    67.247    -0.372     0.200
    70.306     2.085     0.200
    74.567     0.354     0.200
    77.381     0.929     0.200
    77.381     1.281     0.200
    79.741     0.518     0.200
    80.272     1.067     0.200
    80.272     1.243     0.200
    81.513     1.043     0.200
    81.513     0.918     0.200
    82.128     1.782     0.200
    82.353     0.703     0.200
    82.393     0.893     0.200
    82.421     0.345     0.200
    83.564     1.527     0.200
    83.585     0.815     0.200
    83.780     0.720     0.200
    83.780     0.620     0.200
    83.821     0.805     0.200
    83.877     1.019     0.200
    84.229     0.329     0.200
    84.281    -0.037     0.200
    84.557     0.664     0.200
    84.723     0.727     0.200
    84.933     0.569     0.200
    84.972     0.772     0.200
    85.175     1.858     0.200
    85.201     0.929     0.200
    85.919     1.203     0.200
    86.186     0.233     0.200
    87.298     1.094     0.200
    87.345    -0.181     0.200
    89.774     4.384     0.200
    89.905    -1.169     0.200
    89.977     1.236     0.200
    91.663    -0.004     0.200
    91.663     0.296     0.200
    92.405     0.590     0.200
    93.719    -0.890     0.200
    94.940     0.640     0.200
    14.194     4.104     0.200
    14.224     5.646     0.200
    14.265     4.306     0.200
    14.897     4.855     0.200
    15.049     4.667     0.200
    15.115     4.745     0.200
    15.196     3.632     0.200
    15.248     2.500     0.200
    15.262     3.410     0.200
    15.332     2.770     0.200
    15.555     3.088     0.200
    15.557     3.007     0.200
    15.575     1.844     0.200
    15.622     1.819     0.200
    15.810     1.751     0.200
    15.850     2.626     0.200
    15.881     3.429     0.200
    15.948     1.720     0.200
    16.093     1.908     0.200
    16.158     1.223     0.200
    16.225     1.190     0.200
    16.233     1.404     0.200
    16.445     3.147     0.200
    16.524     4.305     0.200
    16.604     2.965     0.200
    16.609     2.895     0.200
    16.623     1.742     0.200
    16.659     1.982     0.200
    16.687     1.365     0.200
    16.773     1.655     0.200
    16.818     2.587     0.200
    16.811     0.863     0.200
    16.881     3.591     0.200
    16.920     2.738     0.200
    16.933     1.805     0.200
    16.934     0.761     0.200
    16.983     1.203     0.200
    17.094     3.192     0.200
    17.132     1.693     0.200
    17.119     0.538     0.200
    17.249     1.747     0.200
    17.260     0.990     0.200
    17.271     0.723     0.200
    17.318     2.792     0.200
    17.476     1.059     0.200
    17.604     1.516     0.200
    17.621     1.126     0.200
    17.620     2.259     0.200
    17.765     2.409     0.200
    17.922     1.111     0.200
    18.052     1.175     0.200
    18.079     0.586     0.200
    18.364     0.555     0.200
    20.537     0.194     0.200
    20.893     0.495     0.200
    21.228     0.720     0.200
    21.327     2.039     0.200
    21.672     0.811     0.200
    21.672     0.202     0.200
    21.757     1.114     0.200
    22.040    -1.432     0.200
    22.940    -0.719     0.200
    22.940    -0.375     0.200
    23.245     0.755     0.200
    23.300     0.896     0.200
    24.128    -0.033     0.200
    24.167     1.691     0.200
    24.242     0.724     0.200
    24.242     0.958     0.200
    24.425     2.139     0.200
    24.516     1.640     0.200
    26.603     1.810     0.200
    27.056     0.483     0.200
    27.342     0.696     0.200
    27.522     1.441     0.200
    27.522     3.160     0.200
    29.862     0.716     0.200
    29.911     1.041     0.200
    31.249     1.915     0.200
    33.162     2.038     0.200
    35.723     2.420     0.200
    35.910     2.629     0.200
    37.129     1.441     0.200
    37.322     2.410     0.200
    37.363     1.559     0.200
    37.609     3.149     0.200
    37.897     1.672     0.200
    37.963     1.942     0.200
    38.232     3.502     0.200
    38.761     3.309     0.200
    40.344     1.600     0.200
    40.669    -0.455     0.200
    43.350     2.395     0.200
    55.404     0.521     0.200
    62.273     1.517     0.200
    62.649     2.743     0.200
    75.212     0.618     0.200
    77.173     0.592     0.200
    81.249     0.914     0.200
    81.739     3.032     0.200
    82.465     2.998     0.200
    84.129     2.890     0.200
    84.296     0.535     0.200
    85.610     1.336     0.200
    87.206     1.038     0.200
    91.435    -0.036     0.200
    91.922     0.162     0.200
    14.816     3.214     0.200
    14.914     4.587     0.200
    15.133     4.394     0.200
    15.213     3.018     0.200
    15.266     6.672     0.200
    15.331     2.884     0.200
    15.638     2.542     0.200
    15.638     2.183     0.200
    15.638     2.769     0.200
    15.960     1.699     0.200
    16.034     4.297     0.200
    16.463     2.844     0.200
    16.828     1.220     0.200
    16.935     2.809     0.200
    16.953     2.167     0.200
    16.996     1.453     0.200
    17.113     5.289     0.200
    17.203     2.915     0.200
    17.268     2.562     0.200
    17.338     2.687     0.200
    17.624     1.413     0.200
    17.639     1.286     0.200
    17.639     2.036     0.200
    17.640     2.059     0.200
    17.784     3.066     0.200
    17.845     2.709     0.200
    17.941     2.880     0.200
    18.030     1.497     0.200
    18.099     0.681     0.200
    18.384     1.135     0.200
    20.646     0.501     0.200
    20.912     1.013     0.200
    21.691     0.004     0.200
    21.691     0.754     0.200
    22.959    -0.172     0.200
    24.147    -0.327     0.200
    24.179     0.778     0.200
    24.424     2.085     0.200
    27.535     1.703     0.200
    29.879     1.010     0.200
    29.931     1.314     0.200
    33.977    -0.085     0.200
    35.735     2.029     0.200
    36.834     0.673     0.200
    37.143     2.083     0.200
    37.374     1.247     0.200
    37.620     2.477     0.200
    37.907     1.376     0.200
    37.973     2.813     0.200
    40.356     1.356     0.200
    62.282     1.942     0.200
    62.655     2.724     0.200
    66.745     0.550     0.200
    77.192     1.909     0.200
    81.268     0.911     0.200
    81.745     2.553     0.200
    82.467     2.925     0.200
    84.120     2.555     0.200
    85.617     0.690     0.200
    91.401     2.878     0.200
    91.455     1.473     0.200
    91.937     0.421     0.200
    94.524     1.803     0.200
    15.634     2.292     0.200
    37.368    -0.483     0.200
    94.745     0.489     0.200
    16.121     1.670     0.200
    18.275     0.193     0.200
    21.070     0.094     0.200
    30.326     0.984     0.200
    37.674     1.176     0.200
    37.961     1.053     0.200
    16.122     2.844     0.200
    37.962     1.351     0.200
    14.030     4.445     0.200
    14.248     3.813     0.200
    14.395     3.928     0.200
    14.695     3.471     0.200
    14.920     6.320     0.200
    15.138     8.028     0.200
    15.260     3.140     0.200
    15.641     2.175     0.200
    15.641     2.785     0.200
    15.641     1.768     0.200
    15.926     2.152     0.200
    15.933     2.312     0.200
    16.042     1.530     0.200
    16.060     1.735     0.200
    16.266     1.734     0.200
    16.259     1.446     0.200
    16.468     3.271     0.200
    16.844     2.208     0.200
    16.876     1.481     0.200
    17.295     1.971     0.200
    17.514     1.920     0.200
    17.861     0.990     0.200
    17.951     0.176     0.200
    18.411    -0.410     0.200
    18.638    -0.443     0.200
    18.683    -0.170     0.200
    21.260     0.837     0.200
    21.355     3.009     0.200
    21.704     1.479     0.200
    21.704    -0.740     0.200
    21.791     1.935     0.200
    21.791     0.271     0.200
    22.070     2.143     0.200
    22.591     1.720     0.200
    22.660     0.984     0.200
    22.971     0.249     0.200
    22.971     0.409     0.200
    23.277     1.206     0.200
    23.331     0.694     0.200
    24.435     0.234     0.200
    24.548     1.635     0.200
    27.375     1.598     0.200
    27.535     1.268     0.200
    29.883     0.625     0.200
    29.883     0.621     0.200
    37.144     0.677     0.200
    37.372     1.043     0.200
    37.372     1.311     0.200
    37.372     1.312     0.200
    37.904     2.130     0.200
    38.265     1.257     0.200
    38.770     1.664     0.200
    40.353     1.147     0.200
    40.702    -0.731     0.200
    47.936     2.347     0.200
    62.277    -0.230     0.200
    62.643     2.797     0.200
    62.647     2.776     0.200
    74.291     0.604     0.200
    74.291     0.605     0.200
    81.277     0.589     0.200
    81.277     0.588     0.200
    84.329     0.700     0.200
    91.397     3.582     0.200
    91.933     2.862     0.200
    91.937     4.353     0.200
    91.937     2.841     0.200
    94.527     1.146     0.200
    96.035     2.455     0.200
    96.137     1.992     0.200
    15.628     3.006     0.200
    21.711     0.461     0.200
    37.352     2.676     0.200
    14.291     4.060     0.200
    14.653     4.837     0.200
    14.963     3.941     0.200
    15.694     2.277     0.200
    16.512     3.202     0.200
    17.230     2.160     0.200
    18.099     0.709     0.200
    21.216     1.270     0.200
    21.705     0.190     0.200
    21.777     1.375     0.200
    22.020     0.034     0.200
    22.567     0.675     0.200
    22.628    -1.176     0.200
    22.977    -0.094     0.200
    22.977    -0.621     0.200
    23.239    -0.609     0.200
    23.286     2.689     0.200
    23.898    -0.651     0.200
    24.142     1.927     0.200
    24.181    -0.641     0.200
    24.241     1.361     0.200
    24.356     1.439     0.200
    27.340     0.709     0.200
    27.599     1.566     0.200
    27.599     1.042     0.200
    29.233    -1.528     0.200
    29.625     1.264     0.200
    29.931     0.827     0.200
    29.962     1.528     0.200
    32.764     1.613     0.200
    33.160     1.432     0.200
    33.709     1.904     0.200
    34.546    -0.920     0.200
    35.800     1.195     0.200
    35.988     3.998     0.200
    37.204     1.001     0.200
    37.204     2.122     0.200
    37.441     0.495     0.200
    37.688     0.095     0.200
    38.041     0.866     0.200
    38.335     0.156     0.200
    47.643     0.782     0.200
    47.862     2.154     0.200
    55.456     0.086     0.200
    55.682     1.251     0.200
    62.351     1.309     0.200
    62.725    -0.891     0.200
    66.810     0.411     0.200
    74.325    -1.051     0.200
    77.222     0.177     0.200
    81.305     0.495     0.200
    82.536     0.450     0.200
    84.318     0.412     0.200
    91.487    -0.294     0.200
    91.998     0.595     0.200
    93.223    -1.036     0.200
    94.580     1.611     0.200
    96.093     1.258     0.200
    96.196     0.787     0.200
    14.953     6.830     0.200
    15.172     2.702     0.200
    15.305     3.668     0.200
    15.682     5.157     0.200
    17.241     1.145     0.200
    20.686    -0.042     0.200
    21.777     0.375     0.200
    22.569     0.514     0.200
    22.974    -0.772     0.200
    24.175     0.543     0.200
    24.370     1.767     0.200
    34.549     0.216     0.200
    37.192     3.987     0.200
    38.027     0.524     0.200
    38.322    -0.414     0.200
    40.409     1.037     0.200
    47.874     3.581     0.200
    55.449     2.419     0.200
    62.337     3.153     0.200
    62.710     1.959     0.200
    66.796     2.020     0.200
    72.094     0.856     0.200
    77.216     2.081     0.200
    81.298     1.607     0.200
    82.522     2.742     0.200
    83.584     3.173     0.200
    91.455     0.848     0.200
    91.481     0.749     0.200
    91.985     2.490     0.200
    94.569     3.207     0.200
    96.081     1.963     0.200
    96.183     1.491     0.200
    37.441     0.437     0.200
    16.084     3.027     0.200
    16.839     2.131     0.200
    21.769     2.081     0.200
    23.077     2.256     0.200
    37.917     0.409     0.200
    40.904     0.627     0.200
    77.409     1.997     0.200
    81.541     1.035     0.200
    86.206    -1.676     0.200
    95.384    -1.845     0.200
    16.197     1.476     0.200
    16.416     1.683     0.200
    16.512     2.346     0.200
    30.688    -1.101     0.200
    38.043     2.090     0.200
    95.517    -2.350     0.200
    16.375     4.595     0.200
    16.681     3.143     0.200
    21.583     1.020     0.200
    23.865     1.404     0.200
    26.830     2.596     0.200
    27.920     3.111     0.200
    30.123     2.387     0.200
    36.134     3.471     0.200
    37.793     2.496     0.200
    37.793     1.355     0.200
    38.422     1.630     0.200
    38.704     2.790     0.200
    40.784     1.465     0.200
    56.063     1.259     0.200
    86.132    -0.733     0.200
    95.294    -2.446     0.200
    14.763     5.150     0.200
    16.085     2.918     0.200
    16.461     1.626     0.200
    17.556     1.705     0.200
    17.794     0.884     0.200
    17.877     0.678     0.200
    18.009     2.138     0.200
    18.190     3.765     0.200
    18.309     1.339     0.200
    21.043     1.506     0.200
    21.040     0.856     0.200
    21.779     1.525     0.200
    21.779     1.096     0.200
    23.049     1.648     0.200
    37.915     2.309     0.200
    15.219     3.239     0.200
    15.663     6.713     0.200
    16.026     2.831     0.200
    16.375     2.925     0.200
    16.437     2.825     0.200
    16.475     3.183     0.200
    16.624     2.414     0.200
    16.719     2.602     0.200
    16.856     2.216     0.200
    16.938     1.619     0.200
    16.953     1.639     0.200
    17.107     1.912     0.200
    17.189     2.326     0.200
    17.372     1.857     0.200
    17.567     1.621     0.200
    17.640     1.498     0.200
    17.791     1.617     0.200
    17.826     1.192     0.200
    17.944     1.105     0.200
    18.081     1.230     0.200
    18.081     1.550     0.200
    18.124     1.270     0.200
    18.253     1.617     0.200
    18.462     0.240     0.200
    18.491     0.859     0.200
    18.623     0.746     0.200
    18.646     0.165     0.200
    18.688     0.746     0.200
    18.695     0.852     0.200
    18.771     0.991     0.200
    18.981     0.685     0.200
    19.004    -0.010     0.200
    19.085     0.022     0.200
    19.262     0.809     0.200
    19.459     0.510     0.200
    19.550     0.726     0.200
    19.550     1.359     0.200
    19.634     1.149     0.200
    19.998    -0.035     0.200
    20.018     1.664     0.200
    20.106     0.726     0.200
    20.491     1.272     0.200
    20.581     0.877     0.200
    20.620     0.335     0.200
    20.935     0.882     0.200
    21.319     0.796     0.200
    21.421     1.359     0.200
    21.426     1.857     0.200
    21.660     1.323     0.200
    21.721     0.079     0.200
    21.721     0.723     0.200
    21.821     0.853     0.200
    21.821     1.640     0.200
    21.856     1.398     0.200
    22.135     1.134     0.200
    22.167     1.546     0.200
    22.216     1.426     0.200
    22.353     0.723     0.200
    22.559     1.828     0.200
    22.631     1.354     0.200
    22.709     1.186     0.200
    23.331     1.582     0.200
    23.392     1.919     0.200
    23.598     1.293     0.200
    23.929     0.552     0.200
    24.147    -0.067     0.200
    24.147     0.333     0.200
    24.264     2.418     0.200
    24.324     1.099     0.200
    24.324     1.263     0.200
    24.514     2.380     0.200
    24.517     2.600     0.200
    24.601     1.388     0.200
    24.697     1.320     0.200
    24.958     1.223     0.200
    25.786     1.086     0.200
    26.098     0.960     0.200
    26.335     1.606     0.200
    26.696     0.821     0.200
    26.696     1.555     0.200
    26.845     1.170     0.200
    27.084     1.107     0.200
    27.201     1.345     0.200
    27.369     1.808     0.200
    27.369     2.160     0.200
    27.426     1.686     0.200
    27.478     1.106     0.200
    27.478     1.746     0.200
    27.585     0.079     0.200
    27.585     1.788     0.200
    28.721     1.917     0.200
    28.721     0.481     0.200
    28.888     1.443     0.200
    28.868     0.761     0.200
    29.335     1.719     0.200
    29.687     1.377     0.200
    29.755     0.751     0.200
    29.848     0.169     0.200
    29.848    -0.606     0.200
    29.936     0.795     0.200
    30.031     2.562     0.200
    30.870     0.616     0.200
    31.333     1.869     0.200
    31.339     0.986     0.200
    31.502     0.638     0.200
    31.470     1.397     0.200
    31.616     1.065     0.200
    31.719     1.339     0.200
    32.492     1.652     0.200
    32.972     1.669     0.200
    33.246     1.764     0.200
    33.537     2.412     0.200
    33.778     1.441     0.200
    33.909     1.478     0.200
    34.066     1.342     0.200
    34.361     1.681     0.200
    34.437     2.043     0.200
    34.585     1.147     0.200
    34.643     1.651     0.200
    34.620     1.256     0.200
    35.015     1.825     0.200
    35.197     1.778     0.200
    35.306     1.713     0.200
    35.464     1.758     0.200
    35.542     1.707     0.200
    35.595     2.234     0.200
    35.676     1.530     0.200
    35.974     1.785     0.200
    36.090     1.806     0.200
    36.134     2.312     0.200
    36.144     0.325     0.200
    36.185     2.278     0.200
    36.761     2.099     0.200
    36.869     1.781     0.200
    37.026     0.399     0.200
    37.077     1.419     0.200
    37.094     0.148     0.200
    37.094     1.224     0.200
    37.267     1.756     0.200
    37.311     1.334     0.200
    37.311     1.285     0.200
    37.311     1.285     0.200
    37.481     1.040     0.200
    37.510     0.535     0.200
    37.553     1.415     0.200
    37.564     1.968     0.200
    37.572     1.693     0.200
    37.680     1.755     0.200
    37.732     1.011     0.200
    37.857     1.023     0.200
    38.201     1.226     0.200
    38.278     1.140     0.200
    38.491     2.170     0.200
    38.707     1.652     0.200
    39.145     1.592     0.200
    39.989     1.608     0.200
    40.290     1.220     0.200
    40.725    -0.868     0.200
    40.725    -0.503     0.200
    41.403     0.624     0.200
    42.669    -0.642     0.200
    43.348     0.209     0.200
    43.348     0.654     0.200
    44.130     1.698     0.200
    44.822     5.791     0.200
    45.943     1.426     0.200
    46.214     1.315     0.200
    46.286     0.570     0.200
    46.480     1.676     0.200
    46.488     1.617     0.200
    46.620     1.916     0.200
    46.831     1.496     0.200
    46.844     2.804     0.200
    46.843     3.632     0.200
    47.013     1.890     0.200
    47.069     2.828     0.200
    47.409     2.095     0.200
    47.638     2.969     0.200
    47.638     4.016     0.200
    47.638     4.406     0.200
    47.740     3.631     0.200
    47.804     2.315     0.200
    47.804     3.145     0.200
    47.832     2.509     0.200
    47.925     1.789     0.200
    48.019     1.060     0.200
    48.019     3.660     0.200
    48.237     1.017     0.200
    49.445     0.652     0.200
    50.584     0.943     0.200
    50.757     0.832     0.200
    50.757     0.402     0.200
    50.757     1.183     0.200
    53.243    -0.087     0.200
    55.424     1.233     0.200
    55.424     0.983     0.200
    55.544     1.071     0.200
    55.544     1.302     0.200
    59.439     2.994     0.200
    59.439     1.744     0.200
    60.112    -0.419     0.200
    62.048     0.242     0.200
    62.048     0.592     0.200
    62.207     0.777     0.200
    62.261     1.936     0.200
    62.566     0.918     0.200
    62.569     0.854     0.200
    62.569     0.899     0.200
    64.717     0.472     0.200
    65.065    -0.451     0.200
    65.875     0.348     0.200
    65.875     0.768     0.200
    65.875     0.768     0.200
    66.611     0.744     0.200
    66.686    -0.429     0.200
    66.764     1.071     0.200
    66.764     1.469     0.200
    68.373    -0.120     0.200
    70.968     2.352     0.200
    71.875    -1.374     0.200
    71.970    -0.110     0.200
    71.970     0.153     0.200
    73.000     0.302     0.200
    73.434    -0.552     0.200
    73.867     0.809     0.200
    73.867     0.428     0.200
    74.272     0.378     0.200
    74.272     0.490     0.200
    74.272    -1.761     0.200
    74.922     2.388     0.200
    74.934     0.809     0.200
    74.961     1.191     0.200
    75.242     1.121     0.200
    75.253     0.031     0.200
    75.422     0.435     0.200
    76.167     0.430     0.200
    76.649     2.566     0.200
    77.071     1.139     0.200
    77.129    -0.112     0.200
    77.198     0.803     0.200
    77.198     0.053     0.200
    77.198     0.053     0.200
    77.329     1.266     0.200
    77.329     1.165     0.200
    77.329     0.946     0.200
    77.410    -0.290     0.200
    77.422     0.949     0.200
    77.529     2.095     0.200
    77.640     1.290     0.200
    77.640     1.729     0.200
    78.218     0.864     0.200
    78.695     1.246     0.200
    78.721    -3.662     0.200
    78.721    -3.262     0.200
    79.423     0.393     0.200
    79.500     4.873     0.200
    79.737     0.584     0.200
    79.763     1.743     0.200
    79.755     4.487     0.200
    79.851     0.466     0.200
    79.978     2.176     0.200
    79.990     3.310     0.200
    80.369     3.765     0.200
    80.606    -1.104     0.200
    80.608     0.886     0.200
    80.652     1.050     0.200
    80.665     1.376     0.200
    80.690     2.125     0.200
    80.690     2.785     0.200
    80.899     0.926     0.200
    80.937     1.125     0.200
    81.108     1.712     0.200
    81.264     1.182     0.200
    81.264     1.207     0.200
    81.318     1.295     0.200
    81.337     0.997     0.200
    81.388     1.223     0.200
    81.577     0.926     0.200
    81.593     1.241     0.200
    81.660     0.814     0.200
    81.639     0.659     0.200
    81.644     1.770     0.200
    81.699     0.921     0.200
    81.799     1.761     0.200
    81.946     1.027     0.200
    82.036     1.507     0.200
    82.068     0.938     0.200
    82.097     1.183     0.200
    82.127     1.628     0.200
    82.163     0.838     0.200
    82.226     1.998     0.200
    82.251     2.260     0.200
    82.330     1.066     0.200
    82.337     1.809     0.200
    82.376     0.735     0.200
    82.377    -0.079     0.200
    82.377     0.479     0.200
    82.377     0.020     0.200
    82.390    -0.946     0.200
    82.394     1.432     0.200
    82.446     4.158     0.200
    82.462     1.078     0.200
    82.523     1.156     0.200
    82.532     1.930     0.200
    82.532     1.211     0.200
    82.530     0.723     0.200
    82.530     1.522     0.200
    82.600     1.555     0.200
    82.650     6.793     0.200
    82.743     0.012     0.200
    82.743    -0.148     0.200
    82.824     3.091     0.200
    82.837     0.142     0.200
    82.837     1.622     0.200
    82.938     1.201     0.200
    83.041     1.365     0.200
    83.171     1.190     0.200
    83.255     2.469     0.200
    83.255     1.658     0.200
    83.255     2.158     0.200
    83.339     2.426     0.200
    83.358     1.128     0.200
    83.382     1.404     0.200
    83.534     0.922     0.200
    83.586     1.455     0.200
    83.603     0.671     0.200
    83.712     1.109     0.200
    83.731     0.808     0.200
    83.749     0.919     0.200
    83.765     1.938     0.200
    83.751     0.706     0.200
    83.787     0.924     0.200
    83.805     0.334     0.200
    83.822     1.245     0.200
    83.854     0.582     0.200
    83.888     0.807     0.200
    83.914     1.573     0.200
    83.992     0.779     0.200
    84.172     1.160     0.200
    84.175     2.042     0.200
    84.200     0.417     0.200
    84.202     1.609     0.200
    84.197     2.032     0.200
    84.197     2.321     0.200
    84.317     1.423     0.200
    84.357     1.597     0.200
    84.375     2.526     0.200
    84.430     0.751     0.200
    84.503     0.778     0.200
    84.506     1.967     0.200
    84.545     2.669     0.200
    84.660     0.885     0.200
    84.735     0.808     0.200
    84.743     1.567     0.200
    84.848     3.239     0.200
    84.878     0.687     0.200
    84.888     1.737     0.200
    84.988     1.636     0.200
    84.997     0.992     0.200
    85.084     0.554     0.200
    85.084     0.352     0.200
    85.084     1.173     0.200
    85.193     1.905     0.200
    85.213     1.705     0.200
    85.213     1.506     0.200
    85.232     1.312     0.200
    85.296     1.291     0.200
    85.349     0.929     0.200
    85.534    -0.192     0.200
    85.528     1.033     0.200
    85.532     1.615     0.200
    85.532     2.115     0.200
    85.565     1.051     0.200
    85.659     1.384     0.200
    85.801     1.018     0.200
    85.840     1.888     0.200
    85.845     0.759     0.200
    85.905     1.166     0.200
    85.951     0.738     0.200
    86.322     1.505     0.200
    86.423     0.707     0.200
    86.436     1.346     0.200
    86.458     1.434     0.200
    86.662     0.836     0.200
    86.685     1.420     0.200
    86.691     1.318     0.200
    86.703     0.035     0.200
    86.725     0.527     0.200
    86.774     0.785     0.200
    86.884     1.050     0.200
    86.924     0.754     0.200
    86.920     0.971     0.200
    86.952     1.323     0.200
    86.973     0.515     0.200
    86.973     0.136     0.200
    87.010     0.733     0.200
    87.059     1.128     0.200
    87.171     0.953     0.200
    87.214     1.072     0.200
    87.243     0.801     0.200
    87.243     0.301     0.200
    87.243     0.503     0.200
    87.280     1.668     0.200
    87.357     1.862     0.200
    87.517     1.177     0.200
    87.570     1.123     0.200
    87.652     0.932     0.200
    87.681     0.893     0.200
    87.725    -0.219     0.200
    87.757     2.530     0.200
    87.766     0.183     0.200
    87.854     0.165     0.200
    87.883     1.129     0.200
    88.096     0.918     0.200
    88.108     0.957     0.200
    88.246     0.567     0.200
    88.348     1.425     0.200
    88.315     0.080     0.200
    88.319     0.129     0.200
    88.299     1.155     0.200
    88.302     0.803     0.200
    88.348     1.425     0.200
    88.424     0.264     0.200
    88.427     0.613     0.200
    88.629     0.596     0.200
    88.869     0.998     0.200
    89.108     1.443     0.200
    89.108     1.648     0.200
    89.108     1.943     0.200
    89.359    -0.036     0.200
    89.354     0.988     0.200
    89.397     0.087     0.200
    89.427     0.549     0.200
    89.469     1.149     0.200
    89.480     0.143     0.200
    89.515    -1.385     0.200
    89.827     1.975     0.200
    89.981     1.955     0.200
    90.189     1.283     0.200
    90.301     0.563     0.200
    90.305     1.046     0.200
    90.329    -0.568     0.200
    90.484    -1.047     0.200
    90.505     0.513     0.200
    90.528     1.704     0.200
    90.528     1.245     0.200
    90.528     1.405     0.200
    90.609     0.428     0.200
    90.803     1.325     0.200
    91.125     1.028     0.200
    91.296    -0.060     0.200
    91.317     1.477     0.200
    91.331     1.618     0.200
    91.331     1.621     0.200
    91.392    -0.006     0.200
    91.457     0.387     0.200
    91.457     0.593     0.200
    91.457     0.391     0.200
    91.458     0.127     0.200
    91.460    -0.221     0.200
    91.881     1.106     0.200
    91.885     0.438     0.200
    91.885     1.083     0.200
    92.284     0.863     0.200
    92.784     1.177     0.200
    92.788     1.437     0.200
    93.091     0.541     0.200
    93.633     0.546     0.200
    93.659     0.722     0.200
    93.895     0.537     0.200
    94.249     0.611     0.200
    94.272     0.905     0.200
    94.458     0.551     0.200
    94.458     1.051     0.200
    94.485     1.339     0.200
    94.567    -0.049     0.200
    94.572     0.928     0.200
    94.726     0.026     0.200
    94.804     1.266     0.200
    94.804     0.416     0.200
    94.822     1.084     0.200
    94.859     0.915     0.200
    95.402     1.435     0.200
    95.917     0.484     0.200
    95.986     0.570     0.200
    96.089     0.576     0.200
    96.236     0.634     0.200
    96.397     0.504     0.200
    96.640     0.803     0.200
    96.712    -1.828     0.200
    97.082     0.601     0.200
    97.437     0.196     0.200
    97.681     1.098     0.200
    98.078    -0.393     0.200
    98.353     0.874     0.200
    99.169    -1.073     0.200
    14.212     4.516     0.200
    15.234     2.378     0.200
    15.590     2.055     0.200
    15.590     2.162     0.200
    15.843     2.009     0.200
    17.238     0.719     0.200
    17.277     0.817     0.200
    17.398     0.629     0.200
    17.799     0.511     0.200
    18.101     0.420     0.200
    18.132     2.246     0.200
    18.305     1.117     0.200
    20.613     0.258     0.200
    21.730     1.569     0.200
    22.159     2.131     0.200
    27.463     1.742     0.200
    37.081     0.848     0.200
    37.293     0.414     0.200
    38.183    -0.764     0.200
    81.636     1.915     0.200
    94.704    -1.757     0.200
    97.413    -0.677     0.200
    14.313     4.849     0.200
    15.583     3.333     0.200
    21.727     0.695     0.200
    37.285     1.647     0.200
    14.625     3.727     0.200
    15.048     2.765     0.200
    15.118     2.506     0.200
    15.615     2.475     0.200
    15.854     2.316     0.200
    37.328     0.027     0.200
    15.667     5.933     0.200
    15.845     1.767     0.200
    16.058     1.923     0.200
    14.662     4.772     0.200
    14.728     3.880     0.200
    14.869     4.300     0.200
    14.893     2.898     0.200
    15.199     3.322     0.200
    15.497     2.739     0.200
    15.699     3.706     0.200
    15.791     4.214     0.200
    15.846     3.077     0.200
    15.933     3.478     0.200
    16.201     2.504     0.200
    16.416     2.183     0.200
    16.958     1.623     0.200
    17.068     5.464     0.200
    17.546     0.894     0.200
    18.008     0.562     0.200
    18.118     1.410     0.200
    18.161     1.167     0.200
    18.200     0.489     0.200
    18.234     0.505     0.200
    18.242     1.207     0.200
    18.329     0.851     0.200
    18.433     0.266     0.200
    18.538    -1.312     0.200
    18.531    -0.595     0.200
    18.581     0.081     0.200
    18.637     0.230     0.200
    18.732     0.427     0.200
    18.814     0.243     0.200
    18.969    -0.228     0.200
    19.011     0.115     0.200
    19.049     0.283     0.200
    19.262     0.215     0.200
    19.381    -0.663     0.200
    19.469     0.346     0.200
    19.544     0.414     0.200
    19.648    -0.687     0.200
    19.675     0.831     0.200
    20.019     0.711     0.200
    20.019     0.893     0.200
    20.060    -0.450     0.200
    20.096     0.102     0.200
    20.187    -0.087     0.200
    20.244     0.224     0.200
    20.439    -0.468     0.200
    20.519    -0.048     0.200
    20.579    -0.304     0.200
    20.639     0.358     0.200
    20.699    -0.949     0.200
    20.870     0.245     0.200
    20.913     0.975     0.200
    20.998    -0.064     0.200
    21.047    -0.303     0.200
    21.058    -0.176     0.200
    21.066    -1.403     0.200
    21.374     0.118     0.200
    21.487     1.183     0.200
    21.503    -0.897     0.200
    21.518    -0.358     0.200
    21.573    -0.224     0.200
    21.699     2.615     0.200
    21.743     0.312     0.200
    21.789    -0.501     0.200
    22.001     0.117     0.200
    22.168     1.728     0.200
    22.431    -0.008     0.200
    22.555     0.255     0.200
    23.107    -0.211     0.200
    23.688     0.288     0.200
    23.923    -0.291     0.200
    23.923     0.850     0.200
    26.252     0.405     0.200
    26.916     1.779     0.200
    28.191     0.408     0.200
    28.266     0.252     0.200
    28.392     1.545     0.200
    30.398     0.222     0.200
    30.398     0.222     0.200
    32.549    -0.487     0.200
    32.682    -0.117     0.200
    34.816     5.354     0.200
    35.368     2.993     0.200
    35.504     5.300     0.200
    35.860     4.183     0.200
    36.117     0.935     0.200
    36.236     4.990     0.200
    36.390     6.032     0.200
    36.697     3.254     0.200
    37.296     2.938     0.200
    37.657     4.771     0.200
    37.762     4.113     0.200
    37.791     4.666     0.200
    38.059     0.692     0.200
    38.059     1.476     0.200
    38.059     1.484     0.200
    38.235     2.877     0.200
    38.262     1.413     0.200
    38.431     2.573     0.200
    38.865     3.069     0.200
    38.946     2.423     0.200
    39.464     3.324     0.200
    40.728    -0.178     0.200
    43.337     0.698     0.200
    46.034     7.479     0.200
    46.159     1.397     0.200
    46.615     1.218     0.200
    46.832     4.050     0.200
    52.469     1.811     0.200
    55.727     1.809     0.200
    61.482     0.279     0.200
    63.007     0.840     0.200
    63.007     3.289     0.200
    63.398     0.694     0.200
    63.402     0.671     0.200
    64.860     1.198     0.200
    65.928     1.426     0.200
    70.132     0.996     0.200
    74.675     0.722     0.200
    74.675    -0.474     0.200
    74.701    -0.501     0.200
    77.379     0.565     0.200
    77.463     1.669     0.200
    77.463    -0.019     0.200
    77.463    -0.019     0.200
    77.759     1.917     0.200
    78.965    -0.396     0.200
    80.101     0.490     0.200
    80.938     4.075     0.200
    81.372     0.264     0.200
    81.611     1.302     0.200
    81.611     1.274     0.200
    81.652     1.812     0.200
    82.337     2.383     0.200
    82.492     0.950     0.200
    82.661     3.296     0.200
    82.693     2.427     0.200
    82.718     3.398     0.200
    83.211     1.278     0.200
    83.212     1.235     0.200
    84.297     0.412     0.200
    87.406     0.470     0.200
    87.406     0.462     0.200
    88.033     0.083     0.200
    89.183     0.458     0.200
    89.183     0.458     0.200
    89.183     0.446     0.200
    89.867     3.141     0.200
    91.750    -1.597     0.200
    91.750     1.091     0.200
    92.111     2.173     0.200
    92.111     2.173     0.200
    92.557     0.308     0.200
    92.562     0.285     0.200
    95.083     0.726     0.200
    95.537    -2.030     0.200
    98.272     0.094     0.200
    21.775    -0.024     0.200
    23.086    -1.706     0.200
    61.573    -0.542     0.200
    14.317     6.138     0.200
    14.963     5.151     0.200
    16.024     4.042     0.200
    16.255     2.231     0.200
    22.930    -0.571     0.200
    38.123     1.861     0.200
    95.409    -1.386     0.200
    15.004     4.927     0.200
    15.412     3.655     0.200
    37.113     1.385     0.200
    94.533    -0.424     0.200
    14.557     4.075     0.200
    14.657     3.169     0.200
    14.662     4.394     0.200
    14.775     4.105     0.200
    15.109     4.814     0.200
    15.332     6.922     0.200
    15.557     3.837     0.200
    15.648     3.256     0.200
    16.063     1.527     0.200
    16.117     1.215     0.200
    16.117     2.477     0.200
    16.363     2.566     0.200
    16.440     1.952     0.200
    16.655     0.862     0.200
    16.883     2.717     0.200
    18.278     2.303     0.200
    21.067     0.390     0.200
    21.779     1.392     0.200
    23.020     1.676     0.200
    23.089    -0.290     0.200
    23.802     0.842     0.200
    24.425     0.293     0.200
    24.562     2.766     0.200
    26.312    -0.250     0.200
    28.093     1.329     0.200
    30.322    -0.234     0.200
    36.962     6.378     0.200
    37.670     0.900     0.200
    37.956     1.428     0.200
    39.360     1.920     0.200
    47.354     1.569     0.200
    62.897     3.679     0.200
    81.564     0.417     0.200
    83.096     2.111     0.200
    83.501     1.687     0.200
    92.469     1.045     0.200
    95.426    -3.311     0.200
    98.157    -1.080     0.200
    94.791    -2.149     0.200
    16.083     4.284     0.200
    37.911     1.023     0.200
    14.219     5.080     0.200
    14.737     3.768     0.200
    15.011     3.243     0.200
    15.048     3.512     0.200
    15.571     3.157     0.200
    15.796     2.715     0.200
    16.073     2.830     0.200
    16.280     2.710     0.200
    16.280     2.034     0.200
    16.595     1.776     0.200
    16.921     1.970     0.200
    16.983     1.529     0.200
    17.026     2.017     0.200
    17.054     1.076     0.200
    17.096     3.366     0.200
    17.223     1.366     0.200
    17.399     1.498     0.200
    17.492     1.199     0.200
    17.578     1.344     0.200
    17.697     0.863     0.200
    17.749     0.742     0.200
    17.753     1.623     0.200
    18.021     0.540     0.200
    18.144     0.539     0.200
    18.161     1.132     0.200
    18.192     0.802     0.200
    18.257     0.536     0.200
    18.368     1.365     0.200
    18.373     0.457     0.200
    18.583    -0.818     0.200
    18.612    -0.223     0.200
    18.608    -0.802     0.200
    18.637    -0.416     0.200
    18.637    -1.005     0.200
    18.697    -0.819     0.200
    18.720    -0.301     0.200
    18.767    -0.028     0.200
    18.772     0.626     0.200
    18.779     0.184     0.200
    19.067     0.164     0.200
    19.185     0.407     0.200
    19.563     0.554     0.200
    19.564     0.031     0.200
    19.605    -0.196     0.200
    19.624    -0.048     0.200
    19.654     0.186     0.200
    19.849    -0.019     0.200
    19.935     0.606     0.200
    19.954     0.234     0.200
    20.028     0.462     0.200
    20.103    -1.177     0.200
    20.117    -0.255     0.200
    20.158     0.590     0.200
    20.217     1.143     0.200
    20.236     0.343     0.200
    20.282    -0.031     0.200
    20.369     0.351     0.200
    20.389     1.039     0.200
    20.539     0.336     0.200
    20.721     1.328     0.200
    20.764     1.522     0.200
    21.020     1.922     0.200
    21.018     1.488     0.200
    21.056     1.719     0.200
    21.071     2.516     0.200
    21.091     2.122     0.200
    21.170     1.719     0.200
    21.209    -0.178     0.200
    21.286     0.255     0.200
    21.360     0.121     0.200
    21.386     0.915     0.200
    21.487     1.722     0.200
    21.502     1.909     0.200
    21.511     2.505     0.200
    21.537     0.955     0.200
    21.601     0.698     0.200
    21.635     2.257     0.200
    21.743     1.310     0.200
    21.743     2.689     0.200
    21.807     1.338     0.200
    21.807     0.510     0.200
    21.914    -0.466     0.200
    21.928     0.469     0.200
    22.145     0.330     0.200
    22.430     0.685     0.200
    22.464    -0.822     0.200
    22.545    -0.617     0.200
    22.563    -0.755     0.200
    22.952    -0.329     0.200
    23.188     0.835     0.200
    23.589     0.553     0.200
    24.293     1.987     0.200
    24.518    -1.572     0.200
    26.085     2.633     0.200
    26.205    -0.326     0.200
    27.082     0.309     0.200
    28.218    -0.191     0.200
    28.281     2.072     0.200
    29.432     0.446     0.200
    29.738     0.427     0.200
    30.448     0.165     0.200
    30.471     0.445     0.200
    30.912    -0.266     0.200
    35.459     2.208     0.200
    36.451     1.583     0.200
    36.495     1.528     0.200
    36.684     0.071     0.200
    36.780     1.400     0.200
    36.849     1.178     0.200
    37.654     4.213     0.200
    37.847     0.920     0.200
    37.847     1.061     0.200
    38.125     1.479     0.200
    38.153     1.791     0.200
    38.417     1.859     0.200
    38.525     1.539     0.200
    38.705     1.739     0.200
    38.778     1.738     0.200
    39.062     1.284     0.200
    40.737     1.230     0.200
    45.133     3.194     0.200
    46.521    -0.981     0.200
    46.874     3.640     0.200
    47.033     1.237     0.200
    47.157    -1.272     0.200
    48.050     3.506     0.200
    56.419     1.006     0.200
    62.983    -0.821     0.200
    63.106     1.837     0.200
    63.106     0.560     0.200
    63.503     2.978     0.200
    67.502    -0.265     0.200
    67.502    -1.042     0.200
    72.847     3.091     0.200
    72.891     2.825     0.200
    74.730     2.192     0.200
    74.803     0.122     0.200
    77.502     1.112     0.200
    77.563     2.996     0.200
    77.818     0.397     0.200
    80.000     2.241     0.200
    81.250     2.213     0.200
    81.468    -0.542     0.200
    81.650     4.498     0.200
    81.659     1.345     0.200
    81.981     2.754     0.200
    82.013     0.783     0.200
    82.304     1.556     0.200
    82.331     2.015     0.200
    82.424     1.831     0.200
    82.481     4.492     0.200
    82.593     3.421     0.200
    82.683     4.559     0.200
    82.693     1.326     0.200
    83.312     2.632     0.200
    83.396     3.355     0.200
    83.396     0.656     0.200
    84.297     1.803     0.200
    84.367     0.320     0.200
    85.141    -0.675     0.200
    85.520     0.726     0.200
    85.712    -0.587     0.200
    85.854     2.470     0.200
    86.014     3.785     0.200
    86.462    -1.233     0.200
    86.933     2.257     0.200
    87.397     2.408     0.200
    87.433     0.258     0.200
    89.851    -0.091     0.200
    89.962     1.791     0.200
    90.297    -3.571     0.200
    91.187     1.989     0.200
    91.718    -0.872     0.200
    91.792     0.860     0.200
    92.208     3.083     0.200
    92.648     1.305     0.200
    95.133    -2.392     0.200
    98.374     0.229     0.200
    14.298     4.570     0.200
    14.611     3.767     0.200
    14.624     4.280     0.200
    14.704     3.372     0.200
    14.830     4.357     0.200
    14.833     3.313     0.200
    15.142     2.883     0.200
    15.162     2.785     0.200
    15.157     3.151     0.200
    15.379     2.830     0.200
    15.437     3.710     0.200
    15.605     3.893     0.200
    15.659     3.745     0.200
    15.696     3.217     0.200
    15.811     2.531     0.200
    15.866     2.927     0.200
    15.890     4.073     0.200
    15.925     2.888     0.200
    15.949     2.771     0.200
    16.168     1.789     0.200
    16.168     2.618     0.200
    16.383     2.967     0.200
    16.403     2.787     0.200
    16.493     2.112     0.200
    16.504     1.471     0.200
    16.930     2.894     0.200
    17.027     5.043     0.200
    17.546     0.533     0.200
    18.240     0.877     0.200
    18.258     2.081     0.200
    18.325     0.418     0.200
    18.325     1.606     0.200
    18.639     0.002     0.200
    18.842     0.126     0.200
    19.336     0.110     0.200
    19.419    -0.237     0.200
    19.468     0.262     0.200
    19.725    -1.815     0.200
    19.771    -0.182     0.200
    19.795     0.318     0.200
    19.895    -0.350     0.200
    20.019    -0.543     0.200
    20.033    -0.038     0.200
    20.103     0.109     0.200
    20.111    -0.155     0.200
    20.165    -0.883     0.200
    20.248     0.532     0.200
    20.323    -0.215     0.200
    20.400    -0.137     0.200
    20.527    -0.049     0.200
    20.643     0.776     0.200
    20.647    -0.448     0.200
    20.704     0.491     0.200
    21.005     0.584     0.200
    21.029     0.257     0.200
    21.061     0.304     0.200
    21.070     0.475     0.200
    21.114     0.285     0.200
    21.115     0.570     0.200
    21.384     0.014     0.200
    21.387     0.701     0.200
    21.516     0.467     0.200
    21.526    -0.207     0.200
    21.649    -1.026     0.200
    21.799     0.006     0.200
    21.799     0.670     0.200
    21.900    -0.199     0.200
    21.921    -0.002     0.200
    22.156    -0.765     0.200
    22.419    -0.951     0.200
    22.454    -0.247     0.200
    22.569    -0.628     0.200
    23.023     1.687     0.200
    23.112    -0.912     0.200
    23.112     0.284     0.200
    24.461     0.505     0.200
    24.543     2.767     0.200
    26.295     1.108     0.200
    28.149     1.309     0.200
    28.149     3.028     0.200
    30.211     0.869     0.200
    30.371    -0.370     0.200
    30.700    -1.771     0.200
    36.359     2.499     0.200
    38.013     1.525     0.200
    38.013     1.032     0.200
    38.013     2.048     0.200
    39.418     2.168     0.200
    55.719     1.186     0.200
    61.542     0.509     0.200
    62.955     1.739     0.200
    74.660     0.397     0.200
    81.600     0.257     0.200
    84.316     1.307     0.200
    87.409    -0.149     0.200
    89.843     5.480     0.200
    91.744    -0.178     0.200
    95.052     0.293     0.200
    98.214    -2.924     0.200
    15.938     1.693     0.200
    27.936     1.101     0.200
    37.811     0.874     0.200
    15.942     4.586     0.200
    15.942     4.313     0.200
    16.783     2.991     0.200
    19.627     0.386     0.200
    21.484    -0.461     0.200
    21.614     0.798     0.200
    22.919     0.480     0.200
    23.873     0.843     0.200
    24.292     0.715     0.200
    24.485    -1.029     0.200
    27.932     0.432     0.200
    30.143     0.771     0.200
    37.502     1.807     0.200
    37.804     1.728     0.200
    81.382     0.601     0.200
    14.849     3.959     0.200
    17.025     1.621     0.200
    21.662     0.025     0.200
    37.407     1.276     0.200
    94.847    -2.008     0.200
    16.218     1.535     0.200
    38.083     2.437     0.200
    15.046     6.903     0.200
    36.422     0.434     0.200
    15.964     5.228     0.200
    37.818     2.130     0.200
    62.772     0.901     0.200
    14.259     3.915     0.200
    14.577     3.622     0.200
    14.547     4.390     0.200
    14.681     4.026     0.200
    14.746     3.219     0.200
    14.882     4.104     0.200
    15.493     3.334     0.200
    15.712     2.736     0.200
    15.680     2.957     0.200
    15.803     4.788     0.200
    15.861     2.706     0.200
    15.945     3.380     0.200
    16.001     2.811     0.200
    16.216     2.611     0.200
    16.216     2.263     0.200
    16.437     2.613     0.200
    16.496     1.835     0.200
    16.545     1.896     0.200
    16.652     2.556     0.200
    16.973     2.633     0.200
    16.977     1.310     0.200
    17.019     1.265     0.200
    17.081     3.332     0.200
    17.434     1.946     0.200
    17.674     3.981     0.200
    17.630     2.375     0.200
    17.693     1.345     0.200
    17.830     0.625     0.200
    17.985     1.479     0.200
    18.064     2.067     0.200
    18.219     0.488     0.200
    18.227     1.218     0.200
    18.270     0.605     0.200
    18.348     1.184     0.200
    18.348     2.012     0.200
    18.382     0.615     0.200
    18.424    -0.462     0.200
    18.422    -1.155     0.200
    18.445    -0.417     0.200
    18.453    -0.281     0.200
    18.466    -1.188     0.200
    18.550    -0.404     0.200
    18.615    -1.087     0.200
    18.657     0.126     0.200
    18.671    -0.243     0.200
    18.752    -0.570     0.200
    18.772     0.337     0.200
    18.778    -0.448     0.200
    18.782    -0.169     0.200
    18.833    -0.816     0.200
    18.824    -2.796     0.200
    18.838    -0.116     0.200
    18.836    -1.236     0.200
    18.878    -0.642     0.200
    18.881     0.082     0.200
    18.914     0.362     0.200
    18.935     0.124     0.200
    18.944    -0.230     0.200
    18.980     0.211     0.200
    19.030    -0.399     0.200
    19.022    -0.751     0.200
    19.068     0.306     0.200
    19.103    -0.155     0.200
    19.103    -0.276     0.200
    19.116     0.249     0.200
    19.134    -0.432     0.200
    19.313     0.703     0.200
    19.349     0.529     0.200
    19.342     0.345     0.200
    19.454     0.058     0.200
    19.461     0.098     0.200
    19.482    -1.142     0.200
    19.509    -0.427     0.200
    19.521     0.109     0.200
    19.576     0.451     0.200
    19.597     0.745     0.200
    19.609    -1.179     0.200
    19.629    -0.708     0.200
    19.643    -0.665     0.200
    19.648     0.116     0.200
    19.667    -0.794     0.200
    19.692    -0.386     0.200
    19.704    -1.227     0.200
    19.709    -0.765     0.200
    19.732    -0.230     0.200
    19.763    -0.156     0.200
    19.836    -0.902     0.200
    19.884    -0.192     0.200
    19.891    -0.109     0.200
    19.897    -0.671     0.200
    19.940    -0.274     0.200
    19.976     0.209     0.200
    19.988    -0.654     0.200
    20.001    -2.278     0.200
    20.039    -0.708     0.200
    20.017    -1.967     0.200
    20.050    -0.484     0.200
    20.050     0.836     0.200
    20.067    -0.180     0.200
    20.080     0.335     0.200
    20.076    -1.782     0.200
    20.080    -0.236     0.200
    20.105     0.161     0.200
    20.090     0.568     0.200
    20.107    -0.361     0.200
    20.148     0.361     0.200
    20.196    -0.705     0.200
    20.189     0.275     0.200
    20.241    -0.570     0.200
    20.255    -0.675     0.200
    20.315    -0.485     0.200
    20.395     0.000     0.200
    20.393     0.101     0.200
    20.423    -0.410     0.200
    20.421    -0.444     0.200
    20.431    -0.270     0.200
    20.428    -0.249     0.200
    20.459    -2.773     0.200
    20.451    -2.100     0.200
    20.539    -0.216     0.200
    20.598    -0.002     0.200
    20.601    -1.812     0.200
    20.602    -1.058     0.200
    20.627    -0.224     0.200
    20.634     0.421     0.200
    20.640    -0.326     0.200
    20.665    -1.549     0.200
    20.738    -0.615     0.200
    20.748    -1.162     0.200
    20.762    -0.674     0.200
    20.761    -0.389     0.200
    20.812    -0.579     0.200
    20.798    -1.445     0.200
    20.843    -0.052     0.200
    20.861    -0.258     0.200
    20.864    -0.196     0.200
    20.882     0.391     0.200
    20.903    -1.992     0.200
    20.912     0.798     0.200
    20.922    -0.612     0.200
    20.921     0.702     0.200
    20.929     1.346     0.200
    20.971    -1.716     0.200
    21.018    -0.708     0.200
    21.032    -0.057     0.200
    21.016    -0.335     0.200
    21.067    -2.422     0.200
    21.058    -1.097     0.200
    21.078    -2.397     0.200
    21.073    -1.159     0.200
    21.073     0.054     0.200
    21.082     1.076     0.200
    21.110     0.136     0.200
    21.162     0.326     0.200
    21.159    -0.496     0.200
    21.164    -1.366     0.200
    21.188    -0.395     0.200
    21.198     1.523     0.200
    21.236     2.117     0.200
    21.263     0.643     0.200
    21.246     0.363     0.200
    21.290    -0.294     0.200
    21.299    -0.534     0.200
    21.336     1.933     0.200
    21.340    -0.132     0.200
    21.332     0.144     0.200
    21.339     0.696     0.200
    21.382     1.091     0.200
    21.394     1.195     0.200
    21.412     0.977     0.200
    21.428     0.720     0.200
    21.442     1.025     0.200
    21.477     0.707     0.200
    21.494     0.522     0.200
    21.506     1.521     0.200
    21.512     1.210     0.200
    21.522    -0.510     0.200
    21.513     0.688     0.200
    21.537    -1.348     0.200
    21.574     0.258     0.200
    21.630     0.756     0.200
    21.629    -0.573     0.200
    21.651     0.349     0.200
    21.667    -0.050     0.200
    21.667     1.680     0.200
    21.682    -0.947     0.200
    21.758    -0.732     0.200
    21.762     0.945     0.200
    21.762     2.406     0.200
    21.759    -1.052     0.200
    21.774     0.081     0.200
    21.779    -0.018     0.200
    21.809     0.306     0.200
    21.809     1.076     0.200
    21.804    -0.215     0.200
    21.828     0.004     0.200
    21.849     0.470     0.200
    21.892    -0.596     0.200
    21.879    -1.844     0.200
    21.913    -0.147     0.200
    21.932    -1.592     0.200
    21.961     0.351     0.200
    21.961     0.131     0.200
    21.973    -1.370     0.200
    21.993     1.119     0.200
    22.006    -0.717     0.200
    22.021    -0.058     0.200
    22.047    -0.469     0.200
    22.075     0.106     0.200
    22.067    -0.266     0.200
    22.077    -0.449     0.200
    22.118     1.555     0.200
    22.116     0.114     0.200
    22.159     0.823     0.200
    22.143     0.434     0.200
    22.170    -0.064     0.200
    22.233     0.454     0.200
    22.302    -0.070     0.200
    22.318    -1.929     0.200
    22.325    -0.003     0.200
    22.321     0.155     0.200
    22.345    -1.209     0.200
    22.347    -0.809     0.200
    22.371    -3.008     0.200
    22.426    -0.514     0.200
    22.449    -0.788     0.200
    22.449     0.708     0.200
    22.465    -1.597     0.200
    22.463    -1.009     0.200
    22.463     0.881     0.200
    22.467    -1.524     0.200
    22.491    -0.123     0.200
    22.511    -0.159     0.200
    22.509    -1.684     0.200
    22.549    -1.212     0.200
    22.574     0.524     0.200
    22.572    -1.048     0.200
    22.576    -1.952     0.200
    22.632    -1.546     0.200
    22.685    -4.330     0.200
    22.689     0.095     0.200
    22.706     0.901     0.200
    22.723     0.227     0.200
    22.724    -0.312     0.200
    22.733     0.461     0.200
    22.760     1.517     0.200
    22.800    -2.007     0.200
    22.809    -0.934     0.200
    22.844    -0.306     0.200
    22.918    -0.778     0.200
    22.956     1.614     0.200
    22.948     0.326     0.200
    22.974    -1.603     0.200
    22.985     0.195     0.200
    22.976    -2.413     0.200
    22.977    -0.027     0.200
    22.977     1.633     0.200
    22.982    -0.680     0.200
    22.980    -0.192     0.200
    23.002     1.052     0.200
    23.020    -0.514     0.200
    23.042    -0.889     0.200
    23.085    -1.157     0.200
    23.127     0.127     0.200
    23.127     0.752     0.200
    23.138    -0.844     0.200
    23.153    -0.069     0.200
    23.174    -0.296     0.200
    23.206    -0.900     0.200
    23.219     0.352     0.200
    23.242     2.117     0.200
    23.237    -0.414     0.200
    23.255    -1.529     0.200
    23.259     0.215     0.200
    23.282    -2.209     0.200
    23.314    -3.962     0.200
    23.363    -1.275     0.200
    23.375    -1.290     0.200
    23.391    -0.577     0.200
    23.402    -0.185     0.200
    23.415    -0.966     0.200
    23.433    -0.249     0.200
    23.426     0.359     0.200
    23.499    -0.461     0.200
    23.551     0.177     0.200
    23.544     0.407     0.200
    23.571     0.198     0.200
    23.602     0.565     0.200
    23.617     0.129     0.200
    23.621     0.033     0.200
    23.696    -0.677     0.200
    23.695     0.133     0.200
    23.718     0.739     0.200
    23.688     0.315     0.200
    23.755     0.593     0.200
    23.755     1.413     0.200
    23.772    -0.335     0.200
    23.785     0.432     0.200
    23.805    -0.781     0.200
    23.826    -1.628     0.200
    23.945    -1.139     0.200
    23.973    -1.768     0.200
    24.032    -1.456     0.200
    24.047    -0.649     0.200
    24.047     2.652     0.200
    24.130    -0.429     0.200
    24.170    -2.914     0.200
    24.177    -0.974     0.200
    24.176    -1.753     0.200
    24.212    -3.252     0.200
    24.282     2.647     0.200
    24.313    -2.217     0.200
    24.324    -3.155     0.200
    24.346    -1.428     0.200
    24.346     3.158     0.200
    24.420    -1.061     0.200
    24.489     0.653     0.200
    24.482    -0.561     0.200
    24.491    -2.031     0.200
    24.514     1.210     0.200
    24.617    -1.185     0.200
    24.632    -1.811     0.200
    24.657    -2.162     0.200
    24.694    -1.931     0.200
    24.736    -1.826     0.200
    24.773    -0.218     0.200
    25.197    -0.556     0.200
    25.209    -2.037     0.200
    25.662     1.152     0.200
    26.184     3.305     0.200
    26.267     1.039     0.200
    26.267     0.914     0.200
    26.441     1.400     0.200
    26.663     0.740     0.200
    26.980     1.806     0.200
    27.129     0.036     0.200
    27.129     1.657     0.200
    27.142     1.748     0.200
    27.587     1.438     0.200
    28.204     2.691     0.200
    28.281    -0.176     0.200
    28.281     1.285     0.200
    28.406     1.214     0.200
    28.950    -2.374     0.200
    28.950     1.579     0.200
    29.435     0.642     0.200
    29.435     2.068     0.200
    29.478     3.248     0.200
    29.540     1.973     0.200
    29.782     1.220     0.200
    30.415     0.381     0.200
    30.483     2.615     0.200
    30.968     1.120     0.200
    35.380     2.538     0.200
    35.364     2.583     0.200
    36.415     2.537     0.200
    37.078     2.692     0.200
    37.306     2.824     0.200
    37.666     2.472     0.200
    37.776     1.797     0.200
    38.040     2.593     0.200
    38.070     1.946     0.200
    38.070     2.106     0.200
    38.070     2.157     0.200
    38.273     1.978     0.200
    38.331     2.131     0.200
    38.442     3.278     0.200
    38.619     2.053     0.200
    38.619     2.180     0.200
    38.691     2.681     0.200
    38.877     3.017     0.200
    38.957     1.828     0.200
    38.977     1.859     0.200
    39.083     1.654     0.200
    39.475     0.642     0.200
    40.740     2.542     0.200
    41.053     1.860     0.200
    41.529     2.191     0.200
    43.341     0.905     0.200
    43.836     1.098     0.200
    45.666     1.648     0.200
    45.794     3.467     0.200
    46.169     1.715     0.200
    46.535     2.762     0.200
    46.618     1.415     0.200
    46.973     3.833     0.200
    46.973     3.212     0.200
    47.131     1.624     0.200
    47.253     2.273     0.200
    47.253     2.101     0.200
    49.363     1.089     0.200
    55.746     0.473     0.200
    55.746     1.536     0.200
    60.508     0.127     0.200
    61.192    -0.821     0.200
    61.486     1.378     0.200
    61.486     1.706     0.200
    62.886     0.698     0.200
    63.016     1.262     0.200
    63.016    -1.562     0.200
    64.867     1.145     0.200
    65.926     1.295     0.200
    67.423     0.369     0.200
    70.507     1.012     0.200
    72.759     0.121     0.200
    72.795    -2.112     0.200
    74.693     0.619     0.200
    74.693     0.627     0.200
    74.705     1.682     0.200
    77.483     0.440     0.200
    77.483     0.443     0.200
    78.984     1.042     0.200
    79.551    -4.543     0.200
    80.099     2.081     0.200
    81.383    -0.588     0.200
    81.630     1.105     0.200
    81.630     1.132     0.200
    82.497     1.906     0.200
    83.213     0.789     0.200
    85.102     0.026     0.200
    85.102     0.127     0.200
    85.286     1.408     0.200
    87.426     1.220     0.200
    89.315     1.636     0.200
    89.878     2.600     0.200
    91.770    -0.043     0.200
    92.120     2.005     0.200
    92.120     2.009     0.200
    92.571     1.332     0.200
    92.576     1.305     0.200
    95.545    -3.554     0.200
    96.651     1.214     0.200
    96.754     0.695     0.200
    98.276    -0.114     0.200
    18.301    -0.181     0.200
    37.953     3.380     0.200
    95.417    -0.590     0.200
    23.384     1.304     0.200
    18.941    -1.955     0.200
    37.391     1.521     0.200
    37.915     0.813     0.200
    37.915     0.813     0.200
    14.541     3.824     0.200
    14.699     4.501     0.200
    15.094     3.469     0.200
    15.362     3.716     0.200
    15.551     4.224     0.200
    15.745     2.722     0.200
    15.815     3.986     0.200
    16.106     2.552     0.200
    16.106     1.956     0.200
    16.877     2.376     0.200
    16.851     1.381     0.200
    17.540     0.797     0.200
    18.139     1.057     0.200
    18.170     0.927     0.200
    18.302     1.647     0.200
    18.302     0.905     0.200
    18.314     0.746     0.200
    18.482    -0.443     0.200
    18.478    -0.928     0.200
    18.503    -0.549     0.200
    18.519    -0.940     0.200
    18.556    -0.958     0.200
    18.601    -2.246     0.200
    18.669    -0.739     0.200
    18.685    -0.048     0.200
    18.813    -0.340     0.200
    18.827    -0.044     0.200
    18.837     0.201     0.200
    18.880     0.107     0.200
    18.926    -0.374     0.200
    18.926     0.321     0.200
    18.977     0.234     0.200
    18.993     0.311     0.200
    19.009     0.072     0.200
    19.019     0.377     0.200
    19.118     0.294     0.200
    19.114    -0.181     0.200
    19.177     0.419     0.200
    19.191     0.256     0.200
    19.312     0.412     0.200
    19.382     0.432     0.200
    19.386     0.419     0.200
    19.464     0.423     0.200
    19.535     0.283     0.200
    19.533     0.468     0.200
    19.596     0.687     0.200
    19.662     0.665     0.200
    19.685     0.786     0.200
    19.692     0.796     0.200
    19.766    -0.217     0.200
    19.766     0.775     0.200
    19.767    -0.106     0.200
    19.795    -0.234     0.200
    19.801     0.137     0.200
    19.913     0.025     0.200
    19.922     0.143     0.200
    19.924     0.112     0.200
    19.967     0.266     0.200
    20.024     0.016     0.200
    20.022     0.090     0.200
    20.055     0.423     0.200
    20.058    -0.230     0.200
    20.073     0.548     0.200
    20.084     0.903     0.200
    20.132     0.150     0.200
    20.155     0.838     0.200
    20.189     1.061     0.200
    20.193     0.928     0.200
    20.210     0.840     0.200
    20.239    -0.011     0.200
    20.266    -0.149     0.200
    20.284     0.532     0.200
    20.316    -0.117     0.200
    20.348     0.221     0.200
    20.419    -0.116     0.200
    20.441     0.525     0.200
    20.455     0.159     0.200
    20.481    -0.014     0.200
    20.499    -0.602     0.200
    20.499     0.348     0.200
    20.512     0.502     0.200
    20.519     0.661     0.200
    20.539     0.738     0.200
    20.604     0.413     0.200
    20.667     0.126     0.200
    20.670     0.059     0.200
    20.686    -0.300     0.200
    20.692     0.147     0.200
    20.747     0.020     0.200
    20.763     0.012     0.200
    20.831    -0.122     0.200
    20.829     0.278     0.200
    20.841    -0.065     0.200
    20.863     0.631     0.200
    20.905    -0.415     0.200
    20.906     0.072     0.200
    20.903     1.227     0.200
    20.959     1.205     0.200
    20.976     0.635     0.200
    20.983     0.556     0.200
    20.983     2.422     0.200
    21.006     0.119     0.200
    21.002     0.320     0.200
    21.012     1.004     0.200
    21.020     0.793     0.200
    21.037     0.147     0.200
    21.066     0.538     0.200
    21.114     0.371     0.200
    21.107     0.009     0.200
    21.136    -0.106     0.200
    21.145    -0.069     0.200
    21.147     1.933     0.200
    21.199     0.390     0.200
    21.215     0.246     0.200
    21.218    -0.097     0.200
    21.294    -0.268     0.200
    21.355    -0.022     0.200
    21.368    -0.471     0.200
    21.370    -0.205     0.200
    21.387     1.002     0.200
    21.399     1.013     0.200
    21.437    -0.027     0.200
    21.496     1.123     0.200
    21.518     0.710     0.200
    21.534     0.045     0.200
    21.530     0.552     0.200
    21.577     0.138     0.200
    21.658     0.138     0.200
    21.658     3.005     0.200
    21.658    -0.508     0.200
    21.666     0.862     0.200
    21.701    -0.109     0.200
    21.754     0.370     0.200
    21.754     1.465     0.200
    21.776     0.049     0.200
    21.776     3.346     0.200
    21.770    -0.428     0.200
    21.796     0.013     0.200
    21.796     0.500     0.200
    21.801    -0.153     0.200
    21.807    -0.046     0.200
    21.830    -0.403     0.200
    21.846    -0.142     0.200
    21.836    -0.351     0.200
    21.863    -0.393     0.200
    21.885    -0.361     0.200
    21.933     0.115     0.200
    21.986     0.866     0.200
    21.984    -0.066     0.200
    22.020    -0.118     0.200
    22.020    -0.410     0.200
    22.029     0.002     0.200
    22.045    -0.413     0.200
    22.061     1.395     0.200
    22.130     0.103     0.200
    22.127     0.165     0.200
    22.163    -0.259     0.200
    22.165    -0.121     0.200
    22.168     0.211     0.200
    22.211     0.112     0.200
    22.235    -0.138     0.200
    22.234    -0.321     0.200
    22.310     0.530     0.200
    22.332     0.092     0.200
    22.353    -0.449     0.200
    22.382    -0.020     0.200
    22.389    -0.038     0.200
    22.421    -0.121     0.200
    22.450     0.661     0.200
    22.434     0.319     0.200
    22.487    -0.030     0.200
    22.496     0.341     0.200
    22.496     0.188     0.200
    22.499    -0.292     0.200
    22.499     0.520     0.200
    22.539    -0.366     0.200
    22.559    -0.898     0.200
    22.575    -0.771     0.200
    22.575    -1.301     0.200
    22.602    -0.038     0.200
    22.595     0.104     0.200
    22.612    -0.376     0.200
    22.612     0.577     0.200
    22.610     0.020     0.200
    22.679    -0.551     0.200
    22.691     0.110     0.200
    22.700    -0.661     0.200
    22.762    -0.083     0.200
    22.781    -0.543     0.200
    22.783    -0.113     0.200
    22.814    -0.173     0.200
    22.813     0.025     0.200
    22.826    -0.212     0.200
    22.821     0.120     0.200
    22.821     1.808     0.200
    22.844     1.191     0.200
    22.865    -0.404     0.200
    22.948     1.893     0.200
    22.939    -0.156     0.200
    22.963    -1.830     0.200
    23.027    -0.044     0.200
    23.042    -0.301     0.200
    23.035    -0.589     0.200
    23.044    -0.922     0.200
    23.049    -0.640     0.200
    23.055    -0.241     0.200
    23.055     0.858     0.200
    23.065     1.403     0.200
    23.083    -0.522     0.200
    23.077    -0.816     0.200
    23.071    -1.039     0.200
    23.103    -1.394     0.200
    23.165    -0.433     0.200
    23.165     0.923     0.200
    23.214    -0.413     0.200
    23.214     0.839     0.200
    23.236    -0.222     0.200
    23.243    -0.147     0.200
    23.269    -0.295     0.200
    23.299     0.397     0.200
    23.299     0.160     0.200
    23.299     2.592     0.200
    23.322     0.196     0.200
    23.337     0.513     0.200
    23.353     0.340     0.200
    23.408    -0.392     0.200
    23.413    -0.437     0.200
    23.411    -0.781     0.200
    23.434    -0.617     0.200
    23.434     0.526     0.200
    23.457    -0.413     0.200
    23.459    -0.301     0.200
    23.459     1.657     0.200
    23.502    -0.510     0.200
    23.522    -0.439     0.200
    23.604    -0.233     0.200
    23.617    -0.365     0.200
    23.634    -0.383     0.200
    23.675    -0.070     0.200
    23.675     2.483     0.200
    23.708    -0.734     0.200
    23.708    -0.398     0.200
    23.708     0.214     0.200
    23.747    -0.495     0.200
    23.747     1.227     0.200
    23.767    -0.740     0.200
    23.765    -0.497     0.200
    23.779    -0.290     0.200
    23.850    -0.498     0.200
    23.850     1.320     0.200
    23.866    -0.050     0.200
    23.866     1.323     0.200
    23.872    -0.202     0.200
    23.884    -0.107     0.200
    23.914    -0.501     0.200
    23.914     0.262     0.200
    23.908     0.583     0.200
    23.948    -1.109     0.200
    23.993    -1.050     0.200
    24.066    -0.371     0.200
    24.070     0.058     0.200
    24.100     2.183     0.200
    24.108    -0.070     0.200
    24.141     0.017     0.200
    24.225     1.393     0.200
    24.224    -1.391     0.200
    24.236    -1.499     0.200
    24.250    -1.354     0.200
    24.266    -1.399     0.200
    24.267    -0.776     0.200
    24.299    -0.666     0.200
    24.331     1.475     0.200
    24.327    -1.498     0.200
    24.343     1.737     0.200
    24.387    -1.254     0.200
    24.430     1.081     0.200
    24.413    -0.993     0.200
    24.413    -0.570     0.200
    24.463     0.777     0.200
    24.470    -1.017     0.200
    24.552    -1.751     0.200
    24.568    -1.274     0.200
    24.597     1.166     0.200
    24.613    -1.206     0.200
    24.662    -0.748     0.200
    24.720    -1.281     0.200
    24.714    -0.033     0.200
    24.729    -0.761     0.200
    24.721    -1.098     0.200
    24.726    -0.210     0.200
    24.826    -0.150     0.200
    24.859    -0.713     0.200
    24.938    -0.096     0.200
    25.058     0.113     0.200
    25.105     0.320     0.200
    25.237     0.374     0.200
    25.261     0.177     0.200
    25.268    -0.074     0.200
    25.283     0.380     0.200
    25.296    -0.574     0.200
    25.306     0.262     0.200
    25.343    -0.526     0.200
    25.382     0.602     0.200
    25.507    -0.571     0.200
    25.744     1.305     0.200
    25.797     0.375     0.200
    25.797     0.913     0.200
    25.797     0.416     0.200
    25.797     1.065     0.200
    25.875     0.039     0.200
    25.875     0.738     0.200
    25.987    -0.153     0.200
    26.215     0.207     0.200
    26.215     1.058     0.200
    26.298    -0.832     0.200
    26.347     1.411     0.200
    26.375     0.257     0.200
    26.491     0.224     0.200
    26.488     0.153     0.200
    26.517     0.266     0.200
    26.613     0.326     0.200
    26.638    -0.943     0.200
    26.691    -0.041     0.200
    26.754     0.081     0.200
    26.793    -0.076     0.200
    26.865     0.414     0.200
    26.974    -0.770     0.200
    27.030    -0.091     0.200
    27.064     1.914     0.200
    27.097    -0.263     0.200
    27.131    -0.819     0.200
    27.130    -0.491     0.200
    27.153    -0.157     0.200
    27.186    -0.307     0.200
    27.186     0.228     0.200
    27.294    -0.052     0.200
    27.303    -1.017     0.200
    27.354     0.310     0.200
    27.686    -0.424     0.200
    27.784    -0.022     0.200
    27.883    -0.064     0.200
    28.074     1.925     0.200
    28.074     1.110     0.200
    28.181    -1.279     0.200
    28.364    -0.756     0.200
    29.023     0.463     0.200
    29.532    -0.966     0.200
    29.670    -0.116     0.200
    29.834     0.137     0.200
    30.315     2.095     0.200
    30.555     0.257     0.200
    30.741    -0.016     0.200
    31.095     0.364     0.200
    31.167     0.961     0.200
    32.637     0.418     0.200
    32.716     0.426     0.200
    33.909    -0.037     0.200
    34.129    -1.157     0.200
    35.931    -1.108     0.200
    35.977     5.515     0.200
    36.283     0.982     0.200
    36.480     2.566     0.200
    36.620     2.150     0.200
    37.654    -0.284     0.200
    37.711    -1.440     0.200
    37.901     2.059     0.200
    37.934     1.160     0.200
    37.934     1.720     0.200
    37.934     1.769     0.200
    38.137     1.914     0.200
    38.191     1.881     0.200
    38.482     2.083     0.200
    38.549     2.240     0.200
    38.744     3.042     0.200
    38.816     1.799     0.200
    38.838     1.578     0.200
    39.338     1.975     0.200
    40.605     2.983     0.200
    40.915     0.633     0.200
    64.397    -1.255     0.200
    78.936     2.181     0.200
    80.252     2.905     0.200
    81.568     1.879     0.200
    95.397    -0.670     0.200
    98.124    -1.422     0.200
    14.464     4.852     0.200
    14.545     4.186     0.200
    14.652     4.585     0.200
    14.689     3.974     0.200
    14.740     6.507     0.200
    15.366     3.735     0.200
    15.552     6.681     0.200
    15.590     4.001     0.200
    15.671     2.531     0.200
    15.748     3.135     0.200
    15.819     3.906     0.200
    16.108     2.176     0.200
    16.108     2.551     0.200
    16.363     3.387     0.200
    16.428     2.048     0.200
    16.522     5.646     0.200
    16.840     1.769     0.200
    16.878     2.863     0.200
    16.958     5.561     0.200
    17.529     1.712     0.200
    18.159     0.772     0.200
    18.304     0.592     0.200
    18.473    -0.776     0.200
    18.509    -0.263     0.200
    18.546    -0.733     0.200
    18.595    -1.056     0.200
    18.662    -0.540     0.200
    18.675    -0.757     0.200
    18.744    -0.024     0.200
    18.827    -0.258     0.200
    18.849     0.195     0.200
    18.871    -0.241     0.200
    18.916    -0.461     0.200
    18.925     0.301     0.200
    18.967    -0.510     0.200
    18.971     0.499     0.200
    18.983    -0.306     0.200
    19.009    -1.073     0.200
    19.104    -0.735     0.200
    19.109    -0.079     0.200
    19.167    -0.453     0.200
    19.373    -0.680     0.200
    19.377    -0.250     0.200
    19.387     0.799     0.200
    19.415     0.799     0.200
    19.454    -0.350     0.200
    19.523    -0.498     0.200
    19.527    -0.025     0.200
    19.557    -0.357     0.200
    19.682     0.571     0.200
    19.757     0.217     0.200
    19.757     0.944     0.200
    19.757    -0.275     0.200
    19.787     0.070     0.200
    19.791    -0.270     0.200
    19.905     0.001     0.200
    19.913     0.975     0.200
    19.958    -0.045     0.200
    20.045    -0.274     0.200
    20.049     0.060     0.200
    20.124    -0.183     0.200
    20.145    -0.562     0.200
    20.169    -0.222     0.200
    20.179     0.171     0.200
    20.192    -0.025     0.200
    20.192     0.901     0.200
    20.230     0.911     0.200
    20.259     0.169     0.200
    20.274     0.905     0.200
    20.307    -0.334     0.200
    20.340     0.778     0.200
    20.412    -0.454     0.200
    20.433     0.686     0.200
    20.446    -1.209     0.200
    20.472    -0.304     0.200
    20.489    -0.151     0.200
    20.489     0.570     0.200
    20.502     0.204     0.200
    20.510     0.989     0.200
    20.529     0.362     0.200
    20.658     0.736     0.200
    20.662     1.328     0.200
    20.683     0.456     0.200
    20.756     0.518     0.200
    20.819    -0.479     0.200
    20.824     0.670     0.200
    20.852     0.720     0.200
    20.893     0.098     0.200
    20.897    -0.218     0.200
    20.897     0.060     0.200
    20.948     0.720     0.200
    20.967     0.560     0.200
    20.973    -0.454     0.200
    20.992     0.543     0.200
    20.998    -0.076     0.200
    21.009    -0.327     0.200
    21.030     0.948     0.200
    21.059     0.052     0.200
    21.096    -0.576     0.200
    21.106    -0.097     0.200
    21.129     0.037     0.200
    21.135    -0.530     0.200
    21.138     1.853     0.200
    21.192    -0.249     0.200
    21.206    -0.124     0.200
    21.209    -0.156     0.200
    21.286    -0.253     0.200
    21.358     0.033     0.200
    21.378     0.128     0.200
    21.378     0.633     0.200
    21.427    -0.027     0.200
    21.487     0.545     0.200
    21.487     1.088     0.200
    21.519     1.272     0.200
    21.522     0.364     0.200
    21.522     0.581     0.200
    21.527     0.827     0.200
    21.567     0.972     0.200
    21.650    -0.285     0.200
    21.652     0.120     0.200
    21.652     2.944     0.200
    21.656     0.872     0.200
    21.691    -0.516     0.200
    21.744    -1.134     0.200
    21.744     1.331     0.200
    21.760    -0.948     0.200
    21.769     0.199     0.200
    21.769     1.589     0.200
    21.790     0.462     0.200
    21.790     1.097     0.200
    21.792     0.328     0.200
    21.799    -0.521     0.200
    21.826    -0.177     0.200
    21.854     0.060     0.200
    21.923    -0.184     0.200
    21.973    -0.025     0.200
    21.973     2.382     0.200
    21.979    -0.814     0.200
    21.979     4.373     0.200
    22.011    -0.438     0.200
    22.019    -0.865     0.200
    22.036    -0.437     0.200
    22.051     0.714     0.200
    22.155     2.188     0.200
    22.157    -0.728     0.200
    22.200    -0.218     0.200
    22.224    -0.180     0.200
    22.225    -0.966     0.200
    22.324    -0.428     0.200
    22.334    -0.030     0.200
    22.372    -0.173     0.200
    22.415    -0.497     0.200
    22.424    -0.296     0.200
    22.445     0.530     0.200
    22.480    -0.281     0.200
    22.488     0.587     0.200
    22.488     1.731     0.200
    22.490    -0.442     0.200
    22.490    -0.129     0.200
    22.533     0.423     0.200
    22.550    -0.186     0.200
    22.568     0.722     0.200
    22.585     0.160     0.200
    22.594     0.408     0.200
    22.599     1.078     0.200
    22.603     0.332     0.200
    22.693     0.293     0.200
    22.751     0.158     0.200
    22.772    -0.129     0.200
    22.803     0.151     0.200
    22.806     0.009     0.200
    22.811     0.362     0.200
    22.811     1.715     0.200
    22.819    -0.586     0.200
    22.834     0.786     0.200
    22.855     0.024     0.200
    22.928    -0.074     0.200
    22.942     1.787     0.200
    22.954     0.542     0.200
    22.981     0.358     0.200
    23.018    -0.444     0.200
    23.025     0.547     0.200
    23.035     0.273     0.200
    23.034    -1.092     0.200
    23.039     0.148     0.200
    23.045     0.492     0.200
    23.045     1.460     0.200
    23.055     0.748     0.200
    23.060    -0.298     0.200
    23.069     0.082     0.200
    23.077     0.033     0.200
    23.157     0.597     0.200
    23.157     0.901     0.200
    23.207     0.145     0.200
    23.207     0.748     0.200
    23.226    -0.112     0.200
    23.233     0.145     0.200
    23.262    -0.041     0.200
    23.289    -0.144     0.200
    23.289     2.341     0.200
    23.289     0.143     0.200
    23.314    -0.238     0.200
    23.327     0.875     0.200
    23.342     0.448     0.200
    23.399    -0.341     0.200
    23.400    -0.223     0.200
    23.404    -0.472     0.200
    23.426    -0.067     0.200
    23.426     0.140     0.200
    23.447     0.015     0.200
    23.450    -0.534     0.200
    23.450     1.390     0.200
    23.492    -0.108     0.200
    23.515     0.742     0.200
    23.608    -0.562     0.200
    23.608     0.315     0.200
    23.624    -0.110     0.200
    23.666     0.564     0.200
    23.666     2.316     0.200
    23.698    -0.442     0.200
    23.698     0.292     0.200
    23.701    -0.324     0.200
    23.739    -0.245     0.200
    23.739     1.114     0.200
    23.756    -0.931     0.200
    23.756    -0.043     0.200
    23.759    -0.168     0.200
    23.769    -0.123     0.200
    23.839     0.295     0.200
    23.839     1.319     0.200
    23.856    -0.128     0.200
    23.856     1.179     0.200
    23.862    -0.309     0.200
    23.875     0.573     0.200
    23.898    -0.404     0.200
    23.941    -0.287     0.200
    24.048     0.449     0.200
    24.048     2.123     0.200
    24.059    -0.820     0.200
    24.091     0.576     0.200
    24.091     2.078     0.200
    24.098     0.495     0.200
    24.134     0.349     0.200
    24.213     0.624     0.200
    24.217    -0.045     0.200
    24.217     1.229     0.200
    24.227    -0.133     0.200
    24.241    -0.826     0.200
    24.257    -0.121     0.200
    24.257     1.537     0.200
    24.258    -0.061     0.200
    24.289    -0.138     0.200
    24.317     0.177     0.200
    24.324    -0.021     0.200
    24.333     1.106     0.200
    24.377     0.212     0.200
    24.428     2.049     0.200
    24.456     0.657     0.200
    24.462    -0.117     0.200
    24.543     0.202     0.200
    24.580    -0.082     0.200
    24.580     1.814     0.200
    24.587     0.932     0.200
    24.703    -0.226     0.200
    24.715    -0.558     0.200
    24.715     1.556     0.200
    24.750     0.200     0.200
    24.760     0.359     0.200
    24.816    -0.131     0.200
    24.849    -0.573     0.200
    24.928     0.266     0.200
    25.095    -0.476     0.200
    25.095     0.897     0.200
    25.251     0.938     0.200
    25.258    -0.153     0.200
    25.286    -0.015     0.200
    25.296     0.224     0.200
    25.372    -0.042     0.200
    25.480     0.872     0.200
    25.497     0.902     0.200
    25.734     0.940     0.200
    25.787    -0.033     0.200
    25.787     0.971     0.200
    25.786     0.580     0.200
    25.786     2.824     0.200
    25.865     0.181     0.200
    25.865     1.163     0.200
    25.977     0.548     0.200
    26.205     0.536     0.200
    26.288    -0.385     0.200
    26.337    -0.236     0.200
    26.337     2.116     0.200
    26.365    -0.129     0.200
    26.365     1.188     0.200
    26.478     0.799     0.200
    26.481     0.169     0.200
    26.602     1.554     0.200
    26.671     0.192     0.200
    26.744    -0.157     0.200
    26.783     0.520     0.200
    26.855     1.200     0.200
    26.919    -0.127     0.200
    27.120     0.504     0.200
    27.122     0.508     0.200
    27.177     0.158     0.200
    27.177     1.295     0.200
    27.284     0.182     0.200
    27.344     0.516     0.200
    27.676     0.182     0.200
    28.078     2.052     0.200
    28.078     2.466     0.200
    28.242    -0.461     0.200
    28.354    -1.060     0.200
    28.787    -1.105     0.200
    29.474    -0.792     0.200
    29.505    -0.422     0.200
    29.523     0.458     0.200
    29.825     0.453     0.200
    29.973    -0.082     0.200
    30.316     0.380     0.200
    30.546    -0.262     0.200
    30.648    -1.057     0.200
    32.628    -0.333     0.200
    32.707    -0.682     0.200
    35.754    -0.793     0.200
    36.287     2.217     0.200
    36.626     2.314     0.200
    37.657     1.623     0.200
    37.775     1.862     0.200
    37.907     2.067     0.200
    37.939     0.781     0.200
    37.939     1.341     0.200
    37.939     1.892     0.200
    38.142     1.345     0.200
    38.197     2.048     0.200
    38.487     1.534     0.200
    38.555     2.225     0.200
    38.749     2.537     0.200
    38.822     1.344     0.200
    38.843     1.386     0.200
    39.343     1.824     0.200
    40.610     2.478     0.200
    40.920     1.203     0.200
    41.401     0.233     0.200
    41.401     2.660     0.200
    47.266     1.622     0.200
    55.689     1.220     0.200
    66.260    -2.076     0.200
    78.933     1.252     0.200
    81.566     0.420     0.200
    95.404     0.907     0.200
    98.132    -1.451     0.200
    37.934     1.408     0.200
    15.020     7.367     0.200
    15.489     2.425     0.200
    17.017     1.203     0.200
    21.762     0.632     0.200
    23.008    -0.998     0.200
    23.008     0.338     0.200
    23.304     0.978     0.200
    23.550     1.439     0.200
    23.988    -0.339     0.200
    24.027     1.864     0.200
    37.146     1.357     0.200
    40.116     0.957     0.200
    94.533    -1.111     0.200
    17.803     1.655     0.200
    21.090     0.180     0.200
    21.805     0.292     0.200
    38.037     1.854     0.200
    37.769     1.665     0.200
    23.099     2.206     0.200
    15.941     2.487     0.200
    37.801    -0.414     0.200
    37.801    -0.414     0.200
    40.785     2.045     0.200
    94.794    -1.569     0.200
    15.938     2.717     0.200
    22.906     0.772     0.200
    26.932    -2.417     0.200
    29.503    -2.190     0.200
    30.138     0.483     0.200
    37.049    -1.253     0.200
    37.499     0.671     0.200
    37.804     1.576     0.200
    62.766     0.493     0.200
    67.152     0.726     0.200
    77.238     1.044     0.200
    81.373     1.498     0.200
    95.301     1.179     0.200
    15.940     2.976     0.200
    30.141     1.334     0.200
    37.498     0.742     0.200
    37.799     0.838     0.200
    95.292    -1.358     0.200
    95.514    -2.127     0.200
    18.481    -2.507     0.200
    18.865    -3.360     0.200
    19.437    -1.346     0.200
    19.614    -2.369     0.200
    19.844    -1.791     0.200
    20.879    -2.472     0.200
    20.998    -4.074     0.200
    21.221    -2.654     0.200
    21.523    -2.037     0.200
    21.597    -1.069     0.200
    22.902     0.758     0.200
    38.369    -3.001     0.200
    38.703    -2.357     0.200
    78.733    -1.220     0.200
    82.264     0.336     0.200
    91.514    -1.626     0.200
    92.289    -1.343     0.200
    95.290    -0.308     0.200
    16.367     2.791     0.200
    16.808     0.729     0.200
    18.220     1.451     0.200
    18.276     0.381     0.200
    18.297     1.166     0.200
    19.360    -1.085     0.200
    20.486     1.540     0.200
    21.113    -1.649     0.200
    21.632    -3.065     0.200
    21.754    -0.176     0.200
    21.781     0.587     0.200
    21.994    -3.336     0.200
    22.468    -2.448     0.200
    23.018     1.513     0.200
    23.032    -1.493     0.200
    23.091    -0.039     0.200
    23.091     0.227     0.200
    23.194    -3.132     0.200
    23.797     1.746     0.200
    23.810    -0.993     0.200
    24.228    -1.805     0.200
    24.231    -1.685     0.200
    24.572    -1.852     0.200
    25.469     0.084     0.200
    25.757    -0.713     0.200
    26.913    -3.049     0.200
    26.913    -2.244     0.200
    27.154    -0.631     0.200
    28.099     0.234     0.200
    28.099     2.437     0.200
    28.554     1.949     0.200
    32.454     1.777     0.200
    32.539     2.219     0.200
    32.606     0.583     0.200
    32.936     1.049     0.200
    33.376     1.387     0.200
    33.720     1.245     0.200
    34.166     1.796     0.200
    34.321     1.315     0.200
    34.611     2.110     0.200
    34.940    -0.256     0.200
    34.940     2.784     0.200
    35.016     1.503     0.200
    35.069     1.885     0.200
    35.177     2.647     0.200
    35.274     2.542     0.200
    35.503     1.599     0.200
    35.584     1.507     0.200
    35.985     2.017     0.200
    36.061     2.161     0.200
    36.309     1.923     0.200
    36.309     1.001     0.200
    36.508     1.232     0.200
    36.527     1.120     0.200
    36.559    -0.125     0.200
    36.559     1.687     0.200
    36.562     1.351     0.200
    36.769     0.631     0.200
    36.770     1.437     0.200
    36.790     0.992     0.200
    36.931     1.380     0.200
    37.259     1.190     0.200
    37.296     1.653     0.200
    37.386     0.953     0.200
    37.450     0.964     0.200
    37.549     0.842     0.200
    37.627     1.373     0.200
    37.676     1.232     0.200
    37.676     1.795     0.200
    37.931     0.811     0.200
    37.962     0.997     0.200
    38.039     1.275     0.200
    38.084     0.480     0.200
    38.221     1.384     0.200
    38.281     0.470     0.200
    38.364     0.430     0.200
    38.373     1.336     0.200
    38.527     0.578     0.200
    38.679     1.017     0.200
    38.712     1.358     0.200
    38.846     0.888     0.200
    38.867     0.886     0.200
    38.888     1.099     0.200
    38.992     0.985     0.200
    38.995    -0.506     0.200
    38.995     1.112     0.200
    39.002     0.998     0.200
    39.034     0.954     0.200
    39.034     1.125     0.200
    39.129     0.779     0.200
    39.153     1.109     0.200
    39.204     1.802     0.200
    39.220     1.308     0.200
    39.247    -0.649     0.200
    39.266     1.193     0.200
    39.340     1.450     0.200
    39.366     1.562     0.200
    39.500     1.657     0.200
    39.547     1.531     0.200
    39.641     1.432     0.200
    39.856     1.771     0.200
    39.872     2.095     0.200
    39.905     0.825     0.200
    39.982     1.170     0.200
    40.033     1.759     0.200
    40.067     0.482     0.200
    40.120     0.725     0.200
    40.182     0.838     0.200
    40.218     1.071     0.200
    40.218     0.868     0.200
    40.235     0.946     0.200
    40.396     1.262     0.200
    40.436     1.731     0.200
    40.475     1.841     0.200
    40.502    -0.081     0.200
    40.502     1.840     0.200
    40.606     1.598     0.200
    40.614     1.829     0.200
    40.632     2.307     0.200
    40.737     2.642     0.200
    40.744     1.964     0.200
    40.818     1.953     0.200
    40.878     2.040     0.200
    40.916     1.016     0.200
    40.944     1.663     0.200
    41.031     1.264     0.200
    41.039     2.198     0.200
    41.113     1.831     0.200
    41.185     1.249     0.200
    41.201     1.909     0.200
    41.234     2.051     0.200
    41.338     2.638     0.200
    41.396     2.384     0.200
    41.422     1.815     0.200
    41.510     1.795     0.200
    41.589     1.580     0.200
    41.602     1.911     0.200
    41.610     2.034     0.200
    41.632     2.118     0.200
    41.696     1.802     0.200
    41.940     1.797     0.200
    41.964     2.025     0.200
    42.157     1.435     0.200
    42.425     1.119     0.200
    42.425     1.548     0.200
    42.512     2.109     0.200
    42.520     1.999     0.200
    42.558     2.210     0.200
    42.572     1.878     0.200
    42.762     2.117     0.200
    42.927     1.866     0.200
    43.058     1.631     0.200
    43.085     1.508     0.200
    43.100     1.513     0.200
    43.188     0.831     0.200
    43.430     1.167     0.200
    43.573     1.847     0.200
    43.781     1.131     0.200
    44.161     1.544     0.200
    44.369     2.044     0.200
    44.824     1.795     0.200
    47.083     0.821     0.200
    62.754    -0.257     0.200
    77.431     1.005     0.200
    77.431     0.177     0.200
    78.932    -0.438     0.200
    81.568    -0.516     0.200
    84.307     0.628     0.200
    91.714    -0.645     0.200
    92.010     0.675     0.200
    92.475    -0.459     0.200
    95.432    -2.092     0.200
    15.538     4.327     0.200
    15.932     1.670     0.200
    22.914    -0.192     0.200
    30.134    -0.512     0.200
    37.792     0.050     0.200
    95.286    -2.624     0.200
    15.997     3.616     0.200
    37.811    -0.533     0.200
    95.270    -1.145     0.200
    22.901    -0.157     0.200
    15.958     3.252     0.200
    21.050    -2.927     0.200
    22.952     1.346     0.200
    30.162     1.115     0.200
    37.808     2.491     0.200
    70.709     3.087     0.200
    81.410     1.549     0.200
    82.260     2.472     0.200
    83.635     4.620     0.200
    91.861     3.492     0.200
    94.842     2.327     0.200
    95.294    -2.937     0.200
    96.492     2.753     0.200
    98.044    -1.400     0.200
    15.939     4.106     0.200
    37.804     1.170     0.200
    37.793     0.755     0.200
    80.220     0.083     0.200
    15.450     3.621     0.200
    18.656    -0.422     0.200
    19.071    -0.871     0.200
    19.283    -0.505     0.200
    19.360    -0.606     0.200
    19.715    -0.283     0.200
    19.966    -1.320     0.200
    19.984    -0.358     0.200
    20.379    -1.073     0.200
    21.383    -0.368     0.200
    21.391    -0.592     0.200
    21.533    -1.209     0.200
    21.613    -1.164     0.200
    21.663    -0.324     0.200
    21.711    -0.676     0.200
    21.926    -1.325     0.200
    22.276    -0.330     0.200
    22.317    -0.026     0.200
    22.593    -0.062     0.200
    22.659    -0.109     0.200
    22.726    -1.101     0.200
    22.924    -0.226     0.200
    23.178    -1.783     0.200
    23.947    -0.030     0.200
    24.554    -0.311     0.200
    24.992    -0.516     0.200
    27.158    -0.839     0.200
    28.720     0.327     0.200
    28.959     0.283     0.200
    29.361    -0.333     0.200
    29.797    -1.196     0.200
    31.159     0.137     0.200
    37.275     1.881     0.200
    79.694     0.607     0.200
    79.694     0.111     0.200
    80.946     1.393     0.200
    82.108    -1.449     0.200
    91.842     0.703     0.200
    94.437     1.274     0.200
    14.474     3.851     0.200
    18.404     1.983     0.200
    18.435    -1.859     0.200
    18.821    -1.727     0.200
    19.018    -1.483     0.200
    19.110    -2.406     0.200
    19.049    -1.648     0.200
    19.038    -1.815     0.200
    19.587    -1.655     0.200
    19.570    -2.106     0.200
    19.735    -3.577     0.200
    20.133    -3.028     0.200
    20.405    -2.313     0.200
    20.624    -2.533     0.200
    21.562    -1.598     0.200
    21.142    -2.263     0.200
    21.133    -2.224     0.200
    21.418    -0.091     0.200
    21.290    -2.370     0.200
    22.026    -3.181     0.200
    22.414    -2.793     0.200
    22.564    -3.531     0.200
    22.738    -0.585     0.200
    23.424    -3.307     0.200
    23.578    -3.353     0.200
    24.353     2.197     0.200
    23.629    -2.768     0.200
    23.661     1.914     0.200
    25.218    -3.464     0.200
    27.450     2.411     0.200
    29.732     1.897     0.200
    32.873    -4.994     0.200
    37.309     1.383     0.200
    55.586     1.125     0.200
    62.255     0.796     0.200
    62.674     1.016     0.200
    64.111     0.913     0.200
    76.768     1.566     0.200
    78.486     1.718     0.200
    79.733     0.581     0.200
    81.077     2.236     0.200
    89.115     1.496     0.200
    91.357     3.449     0.200
    91.254     1.757     0.200
    91.835     2.247     0.200
    23.932     0.312     0.200
    23.958    -0.044     0.200
    26.397     0.241     0.200
    27.463     1.976     0.200
    29.743     1.699     0.200
    37.322    -0.621     0.200
    40.304     0.637     0.200
    40.461     1.091     0.200
    40.461     0.411     0.200
    90.318     3.377     0.200
    15.806     2.730     0.200
    18.909    -0.463     0.200
    20.875     0.027     0.200
    21.617     0.156     0.200
    30.131     1.011     0.200
    30.131     1.135     0.200
    98.617    -0.231     0.200
    14.728     3.499     0.200
    14.769     3.439     0.200
    14.769     4.079     0.200
    15.913     1.616     0.200
    16.534     2.481     0.200
    16.800     1.608     0.200
    16.800     1.342     0.200
    17.372     2.292     0.200
    17.714     0.120     0.200
    17.678     0.582     0.200
    17.868     3.820     0.200
    18.033    -0.257     0.200
    18.210     1.041     0.200
    18.488     0.969     0.200
    18.704     0.202     0.200
    18.847     2.499     0.200
    18.823    -0.573     0.200
    18.886     0.662     0.200
    18.898     0.093     0.200
    20.859     0.045     0.200
    20.822     0.022     0.200
    21.297     3.484     0.200
    21.402     2.871     0.200
    21.600     0.730     0.200
    21.710     2.562     0.200
    21.880     2.119     0.200
    21.880     1.095     0.200
    21.842     2.986     0.200
    22.246     2.434     0.200
    22.275     1.160     0.200
    22.903    -0.210     0.200
    22.840     1.228     0.200
    22.938     1.252     0.200
    22.938     0.619     0.200
    22.938     0.845     0.200
    23.562    -1.735     0.200
    23.754    -0.607     0.200
    23.757     0.890     0.200
    23.902     1.861     0.200
    23.902     0.908     0.200
    24.222    -0.053     0.200
    24.281     0.797     0.200
    24.281     0.149     0.200
    24.281    -0.140     0.200
    24.267     1.789     0.200
    24.506     0.628     0.200
    26.387     0.979     0.200
    26.656     0.709     0.200
    30.115     0.509     0.200
    30.115     0.283     0.200
    30.348     0.253     0.200
    30.563    -0.705     0.200
    30.952     0.823     0.200
    30.952     0.073     0.200
    31.074     1.047     0.200
    32.487     1.547     0.200
    35.106     4.617     0.200
    35.106     3.398     0.200
    35.565     1.881     0.200
    35.565     0.740     0.200
    35.781     1.824     0.200
    35.845     3.202     0.200
    36.101    -0.004     0.200
    36.113     2.699     0.200
    37.471     2.078     0.200
    37.744     2.073     0.200
    37.758     1.551     0.200
    37.771     1.642     0.200
    37.771     2.088     0.200
    37.771     1.252     0.200
    38.143     2.878     0.200
    38.143     1.011     0.200
    38.663     1.063     0.200
    38.813     0.243     0.200
    38.929     0.596     0.200
    39.178     0.614     0.200
    39.333     0.923     0.200
    40.292     0.844     0.200
    40.558    -0.090     0.200
    40.558    -0.191     0.200
    41.034     1.192     0.200
    41.512     0.222     0.200
    43.546     0.092     0.200
    44.753     0.811     0.200
    46.250     1.415     0.200
    47.402     0.157     0.200
    50.683     1.402     0.200
    50.746    -0.113     0.200
    52.705     2.902     0.200
    53.444    -0.103     0.200
    55.484     1.387     0.200
    55.484     0.387     0.200
    56.039     2.234     0.200
    60.934     0.597     0.200
    60.934     0.245     0.200
    63.149     1.333     0.200
    63.149     0.763     0.200
    64.589     1.577     0.200
    64.895     1.204     0.200
    66.159     1.464     0.200
    67.121    -0.532     0.200
    69.288     0.742     0.200
    70.719     0.827     0.200
    72.467     0.210     0.200
    72.467     1.155     0.200
    74.413    -0.253     0.200
    74.413     0.098     0.200
    74.500     2.382     0.200
    75.169     0.402     0.200
    75.181     0.390     0.200
    75.733     2.675     0.200
    77.190    -0.232     0.200
    77.228     1.106     0.200
    77.228    -0.050     0.200
    77.417     0.941     0.200
    77.653     0.269     0.200
    77.638     1.133     0.200
    78.729     0.548     0.200
    78.815     0.374     0.200
    78.815     2.694     0.200
    80.158     3.744     0.200
    80.198     0.586     0.200
    80.331     1.843     0.200
    80.331     0.264     0.200
    80.556     1.337     0.200
    80.824     0.804     0.200
    81.360     0.842     0.200
    81.360     0.412     0.200
    81.506     1.245     0.200
    81.846     1.421     0.200
    81.470     4.723     0.200
    82.165     4.241     0.200
    82.238     0.088     0.200
    82.238     0.744     0.200
    82.317     2.656     0.200
    82.366     3.472     0.200
    82.402     1.566     0.200
    82.458     1.702     0.200
    82.983     1.425     0.200
    82.983     0.871     0.200
    83.175     0.918     0.200
    83.664     2.657     0.200
    83.664     1.189     0.200
    83.664     2.032     0.200
    83.989     0.871     0.200
    84.073     1.238     0.200
    84.147    -0.020     0.200
    84.147     0.753     0.200
    84.657     1.576     0.200
    85.050     1.196     0.200
    85.134     0.536     0.200
    85.134     1.083     0.200
    85.365     0.979     0.200
    85.754     1.187     0.200
    86.100     1.572     0.200
    86.690     1.276     0.200
    86.927     3.219     0.200
    86.958     2.064     0.200
    87.148     1.339     0.200
    87.195     0.154     0.200
    87.195     0.490     0.200
    87.547     1.109     0.200
    87.741     0.782     0.200
    88.067     0.826     0.200
    88.073    -0.383     0.200
    88.088     0.898     0.200
    88.176     0.903     0.200
    88.194    -0.504     0.200
    88.233    -0.388     0.200
    88.365    -0.467     0.200
    88.526     1.357     0.200
    88.827    -0.975     0.200
    88.938     1.271     0.200
    88.938     0.395     0.200
    88.943    -0.009     0.200
    89.032     1.860     0.200
    89.079     1.568     0.200
    89.202    -0.253     0.200
    89.352     3.311     0.200
    89.949     0.338     0.200
    91.387     0.890     0.200
    91.510     0.048     0.200
    91.510     0.150     0.200
    91.510     1.322     0.200
    91.511     0.028     0.200
    91.552     1.274     0.200
    91.828     1.918     0.200
    91.828     1.512     0.200
    92.270     1.200     0.200
    92.270     0.575     0.200
    92.439     1.123     0.200
    92.769     2.501     0.200
    94.796     1.147     0.200
    96.346     0.468     0.200
    96.449     0.471     0.200
    98.600     1.193     0.200
    40.756     0.725     0.200
    87.780     0.939     0.200
    77.136     0.344     0.200
    77.190     0.213     0.200
    80.198     0.468     0.200
    16.075     1.524     0.200
    20.567    -2.032     0.200
    20.912    -1.475     0.200
    37.772    -1.462     0.200
    37.772     0.202     0.200
    37.772    -0.485     0.200
    80.198     0.705     0.200
    15.920     3.264     0.200
    16.812     3.101     0.200
    18.050    -0.129     0.200
    18.503     1.432     0.200
    18.719    -0.731     0.200
    18.837    -0.512     0.200
    18.912    -0.610     0.200
    18.852     2.276     0.200
    18.984    -0.382     0.200
    19.464    -0.494     0.200
    20.070     0.263     0.200
    20.116    -0.025     0.200
    20.914    -0.703     0.200
    21.030     0.038     0.200
    21.615     0.670     0.200
    21.615    -0.650     0.200
    22.258    -0.396     0.200
    22.952     3.537     0.200
    23.479    -0.748     0.200
    23.907    -0.875     0.200
    26.897     0.854     0.200
    30.124     0.239     0.200
    30.124     0.005     0.200
    30.967     2.773     0.200
    32.502     3.402     0.200
    36.118     2.156     0.200
    37.477     1.942     0.200
    37.775     0.043     0.200
    38.147     2.655     0.200
    38.665    -0.090     0.200
    40.295     0.724     0.200
    41.464    -0.354     0.200
    41.974     0.068     0.200
    48.883     3.398     0.200
    50.695     0.925     0.200
    52.588     3.734     0.200
    55.496     1.439     0.200
    55.496     0.510     0.200
    56.041     2.158     0.200
    67.125    -0.390     0.200
    68.845     2.046     0.200
    72.469     0.334     0.200
    74.450     1.770     0.200
    75.733     0.863     0.200
    76.200     1.403     0.200
    77.324     4.193     0.200
    77.197    -1.329     0.200
    77.242     0.850     0.200
    77.639    -1.557     0.200
    77.666     1.379     0.200
    78.225     0.468     0.200
    78.246     1.610     0.200
    78.742    -0.386     0.200
    80.068     1.480     0.200
    80.335    -0.058     0.200
    80.553     1.028     0.200
    80.824     0.620     0.200
    81.372    -0.188     0.200
    81.761     3.955     0.200
    82.979    -0.542     0.200
    82.979    -0.081     0.200
    83.050     3.043     0.200
    83.569     1.126     0.200
    84.055     1.460     0.200
    84.085     1.662     0.200
    84.528     3.096     0.200
    84.671     2.795     0.200
    85.072     1.061     0.200
    85.279     3.021     0.200
    85.766     1.321     0.200
    85.783     3.802     0.200
    86.704     1.304     0.200
    86.753     2.279     0.200
    87.289     1.735     0.200
    87.561     2.935     0.200
    89.328     1.298     0.200
    89.352     0.236     0.200
    89.476     2.679     0.200
    90.297     1.373     0.200
    90.523     1.710     0.200
    91.523     0.201     0.200
    91.523    -0.369     0.200
    92.125     1.498     0.200
    92.277    -0.131     0.200
    92.277    -0.928     0.200
    93.081     0.653     0.200
    94.293     3.078     0.200
    98.383     0.385     0.200
    77.197    -0.642     0.200
    19.614    -1.771     0.200
    21.584    -0.310     0.200
    30.104     0.461     0.200
    30.104     0.826     0.200
    37.766     1.572     0.200
    37.766    -0.073     0.200
    44.739    -0.522     0.200
    80.192     0.579     0.200
    81.346     0.381     0.200
    81.346     0.171     0.200
    19.603    -0.519     0.200
    20.869    -1.108     0.200
    22.815    -1.844     0.200
    37.793     2.186     0.200
    38.704    -1.765     0.200
    40.270    -1.611     0.200
    40.316    -1.860     0.200
    44.754    -1.282     0.200
    40.778     0.223     0.200
    14.603     5.200     0.200
    14.729     4.468     0.200
    15.915     3.288     0.200
    18.449    -2.605     0.200
    18.848    -2.155     0.200
    18.857     2.805     0.200
    19.175    -1.720     0.200
    19.235    -2.024     0.200
    19.813    -2.600     0.200
    19.876    -1.512     0.200
    20.008    -2.684     0.200
    20.848    -1.349     0.200
    21.491    -2.113     0.200
    22.873     0.730     0.200
    23.553    -2.345     0.200
    23.701    -2.562     0.200
    23.718     2.590     0.200
    30.113     0.859     0.200
    35.522     5.487     0.200
    35.872     3.629     0.200
    36.128     2.827     0.200
    37.479     2.136     0.200
    37.479     4.097     0.200
    37.789     3.173     0.200
    37.789     1.275     0.200
    38.161     3.283     0.200
    38.684    -1.351     0.200
    38.753    -1.231     0.200
    38.823    -1.605     0.200
    38.827    -1.961     0.200
    42.309     3.972     0.200
    42.336    -1.594     0.200
    51.326     3.059     0.200
    56.060     2.743     0.200
    56.079     0.246     0.200
    62.756     0.752     0.200
    63.183     0.538     0.200
    66.120     3.114     0.200
    67.135     0.422     0.200
    67.135    -1.148     0.200
    68.024     6.314     0.200
    68.330     7.247     0.200
    68.769     7.083     0.200
    68.769    -1.117     0.200
    68.806     6.551     0.200
    69.525     7.208     0.200
    70.018     6.921     0.200
    71.099     7.349     0.200
    71.887     7.161     0.200
    72.489     2.192     0.200
    73.103     7.344     0.200
    74.352     6.615     0.200
    75.701     6.006     0.200
    75.827     6.380     0.200
    76.151     6.306     0.200
    76.505     6.515     0.200
    80.216     0.537     0.200
    80.292     3.892     0.200
    80.852    -1.236     0.200
    81.330     6.581     0.200
    81.342     1.274     0.200
    82.272     0.584     0.200
    83.022    -0.442     0.200
    83.637     1.857     0.200
    84.108     1.406     0.200
    85.103     2.640     0.200
    96.455     1.620     0.200
    97.377     6.688     0.200
    20.007    -1.803     0.200
    20.392    -1.281     0.200
    21.032    -1.261     0.200
    21.306    -1.873     0.200
    25.845    -1.566     0.200
    29.675    -0.468     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
    99.611     1.200     0.200
   101.315     3.601     0.200
   101.402     1.914     0.200
   102.663    -1.090     0.200
   101.324    -1.674     0.200
   102.661    -3.695     0.200
   100.837     0.511     0.200
   101.240     3.111     0.200
   101.350     1.324     0.200
   102.585    -2.668     0.200
   106.931     2.013     0.200
   109.075    -1.720     0.200
   101.251     2.116     0.200
   102.595    -2.554     0.200
   106.940     2.026     0.200
   109.084    -1.208     0.200
   101.242     0.358     0.200
   102.582    -1.400     0.200
   109.070    -0.342     0.200
   101.231     3.774     0.200
   106.917     1.098     0.200
   109.060    -0.235     0.200
   102.573     2.456     0.200
   109.060    -0.585     0.200
   101.286     3.640     0.200
   102.625    -0.017     0.200
   106.970     1.975     0.200
   109.111     0.149     0.200
   102.678    -2.768     0.200
   101.274     0.510     0.200
   109.083    -2.000     0.200
   101.108    -0.981     0.200
   102.422    -1.323     0.200
   101.462    -1.007     0.200
   101.321    -0.270     0.200
   102.663    -3.135     0.200
   107.007    -0.949     0.200
   109.149    -1.776     0.200
   101.479    -0.538     0.200
   107.128    -2.452     0.200
   100.942    -0.360     0.200
   101.275     2.259     0.200
   101.472     0.182     0.200
   102.640     0.192     0.200
   106.989     0.857     0.200
   109.139     0.299     0.200
   113.086     0.753     0.200
   102.696    -1.991     0.200
   101.346    -0.483     0.200
   102.691    -1.163     0.200
    99.719     1.571     0.200
    99.770     1.967     0.200
    99.956     4.347     0.200
    99.984     3.721     0.200
   100.192     1.794     0.200
   100.248     2.243     0.200
   100.257     1.701     0.200
   100.336     4.157     0.200
   100.365     4.721     0.200
   100.402     1.862     0.200
   100.559    -0.538     0.200
   101.037     3.836     0.200
   101.299    -0.726     0.200
   101.785     2.863     0.200
   101.804     0.127     0.200
   101.901     0.594     0.200
   102.167     3.416     0.200
   102.198     4.981     0.200
   102.371    -1.097     0.200
   102.795     2.123     0.200
   102.993     4.876     0.200
   103.297     3.288     0.200
   103.330    -0.054     0.200
   103.450     1.859     0.200
   103.493     3.520     0.200
   103.903     3.299     0.200
   104.103     4.438     0.200
   104.121     4.936     0.200
   104.512    -1.614     0.200
   104.742     3.120     0.200
   104.806    -1.520     0.200
   104.920    -1.620     0.200
   104.972    -0.954     0.200
   106.918     3.292     0.200
   107.088     2.637     0.200
   109.893     2.932     0.200
    99.826     1.624     0.200
    99.826     2.257     0.200
    99.826     1.632     0.200
   101.531     1.579     0.200
   107.211     1.429     0.200
    99.784     1.688     0.200
    99.784     1.681     0.200
   101.483     4.308     0.200
   101.583     1.663     0.200
   107.146     3.532     0.200
   100.088     3.029     0.200
   101.775     2.131     0.200
   101.799     5.024     0.200
   101.987    -1.312     0.200
   109.361    -0.193     0.200
   100.912     4.252     0.200
   102.183     0.205     0.200
   106.517     3.534     0.200
   107.353     4.517     0.200
   108.644    -0.924     0.200
   112.564    -0.946     0.200
   100.955     2.178     0.200
   106.562     0.148     0.200
   107.393     3.555     0.200
   108.690    -0.208     0.200
   101.665     3.764     0.200
   102.068    -1.326     0.200
   107.352     1.182     0.200
   108.048     3.288     0.200
   101.385    -0.005     0.200
   102.709    -0.388     0.200
   107.049    -0.484     0.200
   107.786     3.338     0.200
   100.997     0.147     0.200
   106.602    -1.373     0.200
   107.435     4.427     0.200
   100.932     2.103     0.200
   101.065    -2.991     0.200
   102.210    -0.280     0.200
   106.545     0.147     0.200
   101.572     1.245     0.200
   102.800    -1.916     0.200
   109.274    -1.196     0.200
   113.194    -1.426     0.200
   101.397     3.491     0.200
   102.712     0.149     0.200
   101.499    -1.677     0.200
   102.826    -3.376     0.200
   107.167    -1.469     0.200
   100.943     2.672     0.200
   102.219     0.395     0.200
   100.909     1.515     0.200
   102.173    -2.107     0.200
   106.506    -0.370     0.200
   107.353     4.168     0.200
   100.925     3.814     0.200
   102.197    -1.339     0.200
   106.531     2.698     0.200
   102.206    -0.186     0.200
   100.888     0.534     0.200
   102.148    -1.869     0.200
   101.503     0.862     0.200
   102.828    -0.825     0.200
   107.440     2.284     0.200
   112.652    -0.385     0.200
   107.428     2.206     0.200
   101.461     1.579     0.200
   107.121    -2.086     0.200
   101.583     2.137     0.200
   101.326    -0.342     0.200
   107.033    -2.316     0.200
   100.880     1.414     0.200
   100.905    -2.097     0.200
   102.130    -0.741     0.200
   102.635    -2.485     0.200
   102.635    -2.487     0.200
   105.028     0.005     0.200
   105.028     0.001     0.200
   106.460    -0.893     0.200
   108.582     0.077     0.200
   110.580     2.206     0.200
   112.493    -0.812     0.200
   100.865    -0.899     0.200
   100.865     0.101     0.200
   102.109    -2.031     0.200
   106.439    -2.478     0.200
   101.597    -1.219     0.200
   107.274    -3.055     0.200
   107.986     3.378     0.200
   109.409    -2.046     0.200
   113.329     1.526     0.200
   101.484     2.145     0.200
   102.807    -1.236     0.200
   100.683     0.266     0.200
   102.823    -3.056     0.200
   107.897     1.985     0.200
   100.930     1.519     0.200
   102.194    -0.900     0.200
    99.979     1.740     0.200
   102.300    -1.554     0.200
   103.033     0.990     0.200
   101.555     0.499     0.200
   100.967     1.650     0.200
    99.907    -0.102     0.200
    99.907    -0.099     0.200
   101.610    -1.464     0.200
   102.942    -1.685     0.200
   108.001     3.324     0.200
   101.498     1.821     0.200
   101.484     2.213     0.200
   101.065     0.712     0.200
   101.338     1.772     0.200
   101.334     2.799     0.200
   101.505     0.048     0.200
   101.307     1.894     0.200
   101.312     1.388     0.200
   104.772     4.261     0.200
    99.611    -0.393     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    30.127   182.382     0.200
    30.579   179.069     0.200
    33.948   160.032     0.200
    37.480   138.612     0.200
    37.480   139.737     0.200
    37.779   137.512     0.200
    38.150   136.574     0.200
    43.559   108.677     0.200
    95.273     2.501     0.200
    98.025    -0.471     0.200
    86.127     4.665     0.200
    55.968    59.605     0.200
    77.906     8.536     0.200
    77.906    11.036     0.200
    99.538     0.554     0.200
    15.070   308.728     0.200
    98.030     0.476     0.200
    30.172   181.707     0.200
    15.149   309.360     0.200
    15.159   312.425     0.200
    77.970     9.382     0.200
    81.428     6.707     0.200
    86.884     9.196     0.200
    98.554     2.188     0.200
    99.566     4.559     0.200
    99.566     3.356     0.200
    46.786    88.187     0.200
    47.395    89.959     0.200
    56.136    61.486     0.200
    62.698    38.447     0.200
    74.090    19.136     0.200
    74.518    18.144     0.200
    77.736    10.325     0.200
    77.736    15.427     0.200
    78.054     7.261     0.200
    78.054    11.855     0.200
    83.027     6.263     0.200
    85.155     5.729     0.200
    85.899     6.069     0.200
    86.421     5.244     0.200
    86.712     6.113     0.200
    86.819     5.492     0.200
    87.030     6.056     0.200
    87.056     5.636     0.200
    87.278     6.260     0.200
    87.575     2.585     0.200
    88.413     5.639     0.200
    88.755     4.923     0.200
    89.593     5.295     0.200
    89.623     5.733     0.200
    89.713     5.773     0.200
    89.753     5.544     0.200
    89.810     5.734     0.200
    90.459     6.051     0.200
    90.742     6.234     0.200
    97.125     3.821     0.200
    97.165     1.947     0.200
    97.355     3.087     0.200
    97.371     3.315     0.200
    97.380     2.071     0.200
    97.380     4.570     0.200
    97.492     1.770     0.200
    97.585     2.747     0.200
    97.635     3.523     0.200
    97.695     3.554     0.200
    97.713     2.974     0.200
    97.844     4.082     0.200
    97.855     4.529     0.200
    98.071     4.558     0.200
    98.201     2.974     0.200
    98.229     4.155     0.200
    98.304     3.319     0.200
    98.391     3.520     0.200
    98.500     4.636     0.200
    98.527     1.819     0.200
    98.700     2.135     0.200
    98.730     2.307     0.200
    98.734     3.987     0.200
    98.762     1.765     0.200
    98.881     1.533     0.200
    98.983     3.576     0.200
    99.064     2.816     0.200
    99.172     2.733     0.200
    99.381     4.505     0.200
    99.399     4.017     0.200
    99.446     2.511     0.200
    99.485     3.441     0.200
    99.595     5.051     0.200
    30.335   182.387     0.200
    98.212     1.466     0.200
    78.108     8.100     0.200
    78.108    12.498     0.200
    81.675     8.180     0.200
    85.234     4.875     0.200
    89.676     3.635     0.200
    90.186     3.313     0.200
    30.570   179.943     0.200
    30.570   179.948     0.200
    87.458     6.554     0.200
    15.609   298.943     0.200
    30.375   177.955     0.200
    85.269     4.420     0.200
    87.368     5.887     0.200
    89.790     3.543     0.200
    98.222     2.659     0.200
    30.024   182.283     0.200
    29.851   186.501     0.200
    99.238     3.886     0.200
    55.634    60.648     0.200
    99.279     1.935     0.200
    97.587     1.369     0.200
    15.625   300.048     0.200
    15.662   305.612     0.200
    72.619    14.597     0.200
    78.103    11.362     0.200
    85.223     4.565     0.200
    99.430     0.666     0.200
    16.290   289.506     0.200
    16.309   296.692     0.200
    97.544     2.846     0.200
    98.050    -0.335     0.200
    30.464   179.449     0.200
    30.450   181.848     0.200
    91.018     2.487     0.200
    98.098     1.381     0.200
    15.115   306.831     0.200
    97.519     1.230     0.200
    97.524     0.798     0.200
    35.988   144.858     0.200
    36.111   145.027     0.200
    97.594     1.121     0.200
    97.579     0.652     0.200
    98.116     0.486     0.200
    29.848   183.868     0.200
    29.848   183.464     0.200
    31.333   174.189     0.200
    31.339   174.466     0.200
    31.502   173.788     0.200
    31.470   172.938     0.200
    33.909   158.468     0.200
    37.311   140.455     0.200
    37.680   137.054     0.200
    37.732   137.421     0.200
    66.686    27.151     0.200
    71.970    18.855     0.200
    73.867    12.809     0.200
    77.410     9.911     0.200
    82.378     3.815     0.200
    86.322     6.405     0.200
    97.231     1.427     0.200
    99.213     0.480     0.200
    99.213     0.480     0.200
    99.234     0.076     0.200
    97.256     0.486     0.200
    30.471   182.042     0.200
    97.198     0.120     0.200
    16.355   292.629     0.200
    29.487   184.332     0.200
    30.162   181.840     0.200
    30.115   182.158     0.200
    37.771   136.564     0.200
    87.203     1.516     0.200
    87.804     1.083     0.200
    88.886     1.029     0.200
    89.425     1.047     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
