#!/bin/bash
gmt begin elmayor5.35_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times elmayor5.35'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.837
    25.500   328.380
    26.000   332.912
    26.500   337.433
    27.000   341.941
    27.500   346.433
    28.000   350.905
    28.500   355.361
    29.000   359.806
    29.500   364.243
    30.000   368.671
    30.500   373.092
    31.000   377.505
    31.500   381.911
    32.000   386.308
    32.500   390.695
    33.000   395.073
    33.500   399.437
    34.000   403.787
    34.500   408.123
    35.000   412.443
    35.500   416.749
    36.000   421.039
    36.500   425.314
    37.000   429.574
    37.500   433.817
    38.000   438.045
    38.500   442.257
    39.000   446.452
    39.500   450.631
    40.000   454.792
    40.500   458.936
    41.000   463.064
    41.500   467.174
    42.000   471.267
    42.500   475.343
    43.000   479.401
    43.500   483.442
    44.000   487.465
    44.500   491.471
    45.000   495.458
    45.500   499.428
    46.000   503.379
    46.500   507.313
    47.000   511.228
    47.500   515.126
    48.000   519.005
    48.500   522.866
    49.000   526.709
    49.500   530.534
    50.000   534.341
    50.500   538.129
    51.000   541.899
    51.500   545.650
    52.000   549.384
    52.500   553.100
    53.000   556.798
    53.500   560.478
    54.000   564.140
    54.500   567.784
    55.000   571.409
    55.500   575.016
    56.000   578.604
    56.500   582.174
    57.000   585.725
    57.500   589.259
    58.000   592.774
    58.500   596.271
    59.000   599.750
    59.500   603.211
    60.000   606.653
    60.500   610.077
    61.000   613.483
    61.500   616.870
    62.000   620.239
    62.500   623.590
    63.000   626.923
    63.500   630.238
    64.000   633.535
    64.500   636.814
    65.000   640.075
    65.500   643.319
    66.000   646.544
    66.500   649.751
    67.000   652.940
    67.500   656.112
    68.000   659.264
    68.500   662.399
    69.000   665.516
    69.500   668.614
    70.000   671.694
    70.500   674.757
    71.000   677.801
    71.500   680.826
    72.000   683.834
    72.500   686.824
    73.000   689.795
    73.500   692.747
    74.000   695.681
    74.500   698.596
    75.000   701.493
    75.500   704.371
    76.000   707.230
    76.500   710.071
    77.000   712.895
    77.500   715.700
    78.000   718.487
    78.500   721.256
    79.000   724.007
    79.500   726.739
    80.000   729.453
    80.500   732.147
    81.000   734.823
    81.500   737.479
    82.000   740.116
    82.500   742.734
    83.000   745.333
    83.500   747.914
    84.000   750.475
    84.500   753.016
    85.000   755.536
    85.500   758.036
    86.000   760.518
    86.500   762.982
    87.000   765.429
    87.500   767.852
    88.000   770.241
    88.500   772.607
    89.000   774.961
    89.500   777.307
    90.000   779.645
    90.500   781.976
    91.000   784.301
    91.500   786.620
    92.000   788.935
    92.500   791.246
    93.000   793.553
    93.500   795.857
    94.000   798.157
    94.500   800.453
    95.000   802.743
    95.500   805.027
    96.000   807.305
    96.500   809.577
    97.000   811.842
    97.500   814.101
    98.000   816.352
    98.500   818.596
    99.000   820.833
    99.500   823.062
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1122.077
   116.000  1123.039
   116.500  1124.001
   117.000  1124.963
   117.500  1125.925
   118.000  1126.887
   118.500  1127.849
   119.000  1128.810
   119.500  1129.772
   120.000  1130.733
   120.500  1131.694
   121.000  1132.655
   121.500  1133.615
   122.000  1134.576
   122.500  1135.536
   123.000  1136.495
   123.500  1137.454
   124.000  1138.413
   124.500  1139.371
   125.000  1140.329
   125.500  1141.286
   126.000  1142.242
   126.500  1143.198
   127.000  1144.153
   127.500  1145.108
   128.000  1146.061
   128.500  1147.014
   129.000  1147.966
   129.500  1148.917
   130.000  1149.867
   130.500  1150.816
   131.000  1151.763
   131.500  1152.710
   132.000  1153.655
   132.500  1154.598
   133.000  1155.541
   133.500  1156.481
   134.000  1157.420
   134.500  1158.357
   135.000  1159.292
   135.500  1160.226
   136.000  1161.157
   136.500  1162.086
   137.000  1163.012
   137.500  1163.936
   138.000  1164.857
   138.500  1165.776
   139.000  1166.692
   139.500  1167.604
   140.000  1168.514
   140.500  1169.420
   141.000  1170.323
   141.500  1171.221
   142.000  1172.116
   142.500  1173.006
   143.000  1173.892
   143.500  1174.773
   144.000  1175.650
   144.500  1176.521
   145.000  1177.387
   145.500  1178.246
   146.000  1179.100
   146.500  1179.948
   147.000  1180.789
   147.500  1181.623
   148.000  1182.450
   148.500  1183.270
   149.000  1184.081
   149.500  1184.884
   150.000  1185.677
   150.500  1186.461
   151.000  1187.234
   151.500  1187.997
   152.000  1188.751
   152.500  1189.494
   153.000  1190.228
   153.500  1190.951
   154.000  1191.663
   154.500  1192.365
   155.000  1193.055
   155.500  1193.734
   156.000  1194.401
   156.500  1195.057
   157.000  1195.700
   157.500  1196.332
   158.000  1196.951
   158.500  1197.558
   159.000  1198.152
   159.500  1198.733
   160.000  1199.302
   160.500  1199.857
   161.000  1200.400
   161.500  1200.929
   162.000  1201.445
   162.500  1201.948
   163.000  1202.438
   163.500  1202.914
   164.000  1203.376
   164.500  1203.824
   165.000  1204.259
   165.500  1204.680
   166.000  1205.087
   166.500  1205.479
   167.000  1205.859
   167.500  1206.224
   168.000  1206.575
   168.500  1206.912
   169.000  1207.235
   169.500  1207.544
   170.000  1207.838
   170.500  1208.119
   171.000  1208.385
   171.500  1208.636
   172.000  1208.874
   172.500  1209.097
   173.000  1209.306
   173.500  1209.501
   174.000  1209.681
   174.500  1209.847
   175.000  1209.998
   175.500  1210.135
   176.000  1210.258
   176.500  1210.366
   177.000  1210.460
   177.500  1210.539
   178.000  1210.604
   178.500  1210.655
   179.000  1210.691
   179.500  1210.713
   180.000  1210.720
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   993.019
     1.000   993.027
     1.500   993.041
     2.000   993.061
     2.500   993.086
     3.000   993.117
     3.500   993.153
     4.000   993.195
     4.500   993.242
     5.000   993.296
     5.500   993.354
     6.000   993.419
     6.500   993.488
     7.000   993.564
     7.500   993.645
     8.000   993.732
     8.500   993.824
     9.000   993.922
     9.500   994.025
    10.000   994.134
    10.500   994.248
    11.000   994.368
    11.500   994.494
    12.000   994.625
    12.500   994.761
    13.000   994.904
    13.500   995.051
    14.000   995.205
    14.500   995.363
    15.000   995.528
    15.500   995.697
    16.000   995.873
    16.500   996.053
    17.000   996.240
    17.500   996.431
    18.000   996.629
    18.500   996.831
    19.000   997.039
    19.500   997.253
    20.000   997.472
    20.500   997.697
    21.000   997.927
    21.500   998.162
    22.000   998.403
    22.500   998.649
    23.000   998.901
    23.500   999.158
    24.000   999.420
    24.500   999.688
    25.000   999.961
    25.500  1000.239
    26.000  1000.523
    26.500  1000.812
    27.000  1001.107
    27.500  1001.406
    28.000  1001.712
    28.500  1002.022
    29.000  1002.338
    29.500  1002.659
    30.000  1002.985
    30.500  1003.316
    31.000  1003.653
    31.500  1003.995
    32.000  1004.342
    32.500  1004.695
    33.000  1005.052
    33.500  1005.415
    34.000  1005.783
    34.500  1006.156
    35.000  1006.534
    35.500  1006.918
    36.000  1007.306
    36.500  1007.700
    37.000  1008.099
    37.500  1008.502
    38.000  1008.911
    38.500  1009.325
    39.000  1009.744
    39.500  1010.168
    40.000  1010.597
    40.500  1011.031
    41.000  1011.470
    41.500  1011.914
    42.000  1012.363
    42.500  1012.817
    43.000  1013.275
    43.500  1013.739
    44.000  1014.208
    44.500  1014.681
    45.000  1015.159
    45.500  1015.643
    46.000  1016.131
    46.500  1016.623
    47.000  1017.121
    47.500  1017.623
    48.000  1018.131
    48.500  1018.642
    49.000  1019.159
    49.500  1019.681
    50.000  1020.207
    50.500  1020.737
    51.000  1021.273
    51.500  1021.813
    52.000  1022.358
    52.500  1022.907
    53.000  1023.461
    53.500  1024.019
    54.000  1024.582
    54.500  1025.150
    55.000  1025.722
    55.500  1026.299
    56.000  1026.880
    56.500  1027.466
    57.000  1028.056
    57.500  1028.650
    58.000  1029.249
    58.500  1029.853
    59.000  1030.460
    59.500  1031.072
    60.000  1031.689
    60.500  1032.309
    61.000  1032.934
    61.500  1033.564
    62.000  1034.197
    62.500  1034.835
    63.000  1035.477
    63.500  1036.123
    64.000  1036.774
    64.500  1037.428
    65.000  1038.087
    65.500  1038.750
    66.000  1039.417
    66.500  1040.088
    67.000  1040.763
    67.500  1041.442
    68.000  1042.125
    68.500  1042.812
    69.000  1043.504
    69.500  1044.199
    70.000  1044.898
    70.500  1045.601
    71.000  1046.308
    71.500  1047.018
    72.000  1047.733
    72.500  1048.451
    73.000  1049.174
    73.500  1049.899
    74.000  1050.629
    74.500  1051.363
    75.000  1052.100
    75.500  1052.841
    76.000  1053.586
    76.500  1054.334
    77.000  1055.086
    77.500  1055.841
    78.000  1056.600
    78.500  1057.363
    79.000  1058.129
    79.500  1058.899
    80.000  1059.672
    80.500  1060.449
    81.000  1061.229
    81.500  1062.013
    82.000  1062.800
    82.500  1063.590
    83.000  1064.384
    83.500  1065.181
    84.000  1065.981
    84.500  1066.785
    85.000  1067.592
    85.500  1068.402
    86.000  1069.216
    86.500  1070.033
    87.000  1070.853
    87.500  1071.676
    88.000  1072.502
    88.500  1073.331
    89.000  1074.163
    89.500  1074.999
    90.000  1075.837
    90.500  1076.679
    91.000  1077.523
    91.500  1078.371
    92.000  1079.221
    92.500  1080.074
    93.000  1080.931
    93.500  1081.790
    94.000  1082.652
    94.500  1083.517
    95.000  1084.384
    95.500  1085.255
    96.000  1086.128
    96.500  1087.004
    97.000  1087.882
    97.500  1088.764
    98.000  1089.647
    98.500  1090.534
    99.000  1091.423
    99.500  1092.315
   100.000  1093.209
   100.500  1094.106
   101.000  1095.006
   101.500  1095.908
   102.000  1096.812
   102.500  1097.719
   103.000  1098.628
   103.500  1099.540
   104.000  1100.454
   104.500  1101.370
   105.000  1102.289
   105.500  1103.210
   106.000  1104.133
   106.500  1105.059
   107.000  1105.987
   107.500  1106.917
   108.000  1107.849
   108.500  1108.783
   109.000  1109.719
   109.500  1110.658
   110.000  1111.599
   110.500  1112.541
   111.000  1113.486
   111.500  1114.433
   112.000  1115.382
   112.500  1116.332
   113.000  1117.285
   113.500  1118.240
   114.000  1119.196
   114.500  1120.155
   115.000  1121.115
   115.500  1122.077
   116.000  1123.041
   116.500  1124.006
   117.000  1124.974
   117.500  1125.943
   118.000  1126.913
   118.500  1127.886
   119.000  1128.860
   119.500  1129.836
   120.000  1130.813
   120.500  1131.792
   121.000  1132.772
   121.500  1133.754
   122.000  1134.738
   122.500  1135.723
   123.000  1136.709
   123.500  1137.697
   124.000  1138.687
   124.500  1139.677
   125.000  1140.669
   125.500  1141.663
   126.000  1142.658
   126.500  1143.654
   127.000  1144.651
   127.500  1145.650
   128.000  1146.649
   128.500  1147.650
   129.000  1148.652
   129.500  1149.656
   130.000  1150.660
   130.500  1151.666
   131.000  1152.673
   131.500  1153.680
   132.000  1154.689
   132.500  1155.699
   133.000  1156.710
   133.500  1157.721
   134.000  1158.734
   134.500  1159.748
   135.000  1160.762
   135.500  1161.778
   136.000  1162.794
   136.500  1163.811
   137.000  1164.829
   137.500  1165.848
   138.000  1166.867
   138.500  1167.887
   139.000  1168.908
   139.500  1169.930
   140.000  1170.952
   140.500  1171.975
   141.000  1172.999
   141.500  1174.023
   142.000  1175.048
   142.500  1176.073
   143.000  1177.099
   143.500  1178.125
   144.000  1179.152
   144.500  1180.180
   145.000  1181.208
   145.500  1182.236
   146.000  1183.265
   146.500  1184.294
   147.000  1185.323
   147.500  1186.353
   148.000  1187.383
   148.500  1188.414
   149.000  1189.445
   149.500  1190.476
   150.000  1191.507
   150.500  1192.538
   151.000  1193.570
   151.500  1194.602
   152.000  1195.634
   152.500  1196.666
   153.000  1197.699
   153.500  1198.731
   154.000  1199.764
   154.500  1200.796
   155.000  1201.829
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.698
   145.500  1178.520
   146.000  1180.401
   146.500  1182.318
   147.000  1184.263
   147.500  1186.231
   148.000  1188.219
   148.500  1190.225
   149.000  1192.246
   149.500  1194.281
   150.000  1196.329
   150.500  1198.388
   151.000  1200.458
   151.500  1202.538
   152.000  1204.626
   152.500  1206.723
   153.000  1208.828
   153.500  1210.940
   154.000  1213.059
   154.500  1215.185
   155.000  1217.317
   155.500  1219.454
   156.000  1221.597
   156.500  1223.745
   157.000  1225.897
   157.500  1228.054
   158.000  1230.215
   158.500  1232.381
   159.000  1234.550
   159.500  1236.723
   160.000  1238.899
   160.500  1241.078
   161.000  1243.261
   161.500  1245.446
   162.000  1247.635
   162.500  1249.825
   163.000  1252.018
   163.500  1254.214
   164.000  1256.411
   164.500  1258.611
   165.000  1260.812
   165.500  1263.016
   166.000  1265.221
   166.500  1267.428
   167.000  1269.636
   167.500  1271.846
   168.000  1274.057
   168.500  1276.269
   169.000  1278.482
   169.500  1280.697
   170.000  1282.912
   170.500  1285.128
   171.000  1287.346
   171.500  1289.564
   172.000  1291.782
   172.500  1294.002
   173.000  1296.222
   173.500  1298.442
   174.000  1300.663
   174.500  1302.885
   175.000  1305.106
   175.500  1307.328
   176.000  1309.551
   176.500  1311.773
   177.000  1313.996
   177.500  1316.219
   178.000  1318.441
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.695
   145.500  1178.321
   146.000  1179.868
   146.500  1181.358
   147.000  1182.798
   147.500  1184.192
   148.000  1185.544
   148.500  1186.856
   149.000  1188.134
   149.500  1189.382
   150.000  1190.605
   150.500  1191.806
   151.000  1192.986
   151.500  1194.147
   152.000  1195.289
   152.500  1196.414
   153.000  1197.523
   153.500  1198.617
   154.000  1199.698
   154.500  1200.766
   155.000  1201.821
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.894
     1.000   509.930
     1.500   509.990
     2.000   510.074
     2.500   510.182
     3.000   510.314
     3.500   510.470
     4.000   510.650
     4.500   510.853
     5.000   511.081
     5.500   511.332
     6.000   511.607
     6.500   511.906
     7.000   512.228
     7.500   512.574
     8.000   512.944
     8.500   513.336
     9.000   513.753
     9.500   514.192
    10.000   514.655
    10.500   515.141
    11.000   515.649
    11.500   516.181
    12.000   516.735
    12.500   517.313
    13.000   517.912
    13.500   518.535
    14.000   519.179
    14.500   519.846
    15.000   520.536
    15.500   521.247
    16.000   521.980
    16.500   522.734
    17.000   523.511
    17.500   524.309
    18.000   525.128
    18.500   525.969
    19.000   526.830
    19.500   527.713
    20.000   528.616
    20.500   529.540
    21.000   530.484
    21.500   531.448
    22.000   532.433
    22.500   533.438
    23.000   534.463
    23.500   535.507
    24.000   536.570
    24.500   537.653
    25.000   538.756
    25.500   539.877
    26.000   541.017
    26.500   542.175
    27.000   543.352
    27.500   544.547
    28.000   545.761
    28.500   546.992
    29.000   548.241
    29.500   549.508
    30.000   550.791
    30.500   552.092
    31.000   553.411
    31.500   554.745
    32.000   556.097
    32.500   557.465
    33.000   558.849
    33.500   560.249
    34.000   561.666
    34.500   563.097
    35.000   564.545
    35.500   566.008
    36.000   567.485
    36.500   568.978
    37.000   570.486
    37.500   572.008
    38.000   573.544
    38.500   575.095
    39.000   576.660
    39.500   578.238
    40.000   579.830
    40.500   581.436
    41.000   583.055
    41.500   584.687
    42.000   586.332
    42.500   587.990
    43.000   589.660
    43.500   591.343
    44.000   593.037
    44.500   594.744
    45.000   596.463
    45.500   598.193
    46.000   599.935
    46.500   601.688
    47.000   603.453
    47.500   605.228
    48.000   607.014
    48.500   608.811
    49.000   610.618
    49.500   612.435
    50.000   614.263
    50.500   616.100
    51.000   617.948
    51.500   619.805
    52.000   621.671
    52.500   623.547
    53.000   625.432
    53.500   627.326
    54.000   629.228
    54.500   631.140
    55.000   633.059
    55.500   634.988
    56.000   636.924
    56.500   638.869
    57.000   640.821
    57.500   642.781
    58.000   644.749
    58.500   646.724
    59.000   648.707
    59.500   650.697
    60.000   652.694
    60.500   654.697
    61.000   656.708
    61.500   658.725
    62.000   660.749
    62.500   662.779
    63.000   664.815
    63.500   666.857
    64.000   668.906
    64.500   670.960
    65.000   673.020
    65.500   675.085
    66.000   677.156
    66.500   679.232
    67.000   681.314
    67.500   683.400
    68.000   685.492
    68.500   687.588
    69.000   689.690
    69.500   691.795
    70.000   693.906
    70.500   696.020
    71.000   698.139
    71.500   700.263
    72.000   702.390
    72.500   704.521
    73.000   706.656
    73.500   708.795
    74.000   710.937
    74.500   713.083
    75.000   715.233
    75.500   717.386
    76.000   719.542
    76.500   721.701
    77.000   723.864
    77.500   726.029
    78.000   728.197
    78.500   730.368
    79.000   732.542
    79.500   734.718
    80.000   736.897
    80.500   739.079
    81.000   741.262
    81.500   743.448
    82.000   745.636
    82.500   747.827
    83.000   750.019
    83.500   752.213
    84.000   754.410
    84.500   756.608
    85.000   758.807
    85.500   761.009
    86.000   763.212
    86.500   765.416
    87.000   767.622
    87.500   769.829
    88.000   772.038
    88.500   774.248
    89.000   776.459
    89.500   778.671
    90.000   780.885
    90.500   783.099
    91.000   785.314
    91.500   787.530
    92.000   789.747
    92.500   791.965
    93.000   794.183
    93.500   796.402
    94.000   798.622
    94.500   800.842
    95.000   803.062
    95.500   805.283
    96.000   807.505
    96.500   809.727
    97.000   811.949
    97.500   814.171
    98.000   816.394
    98.500   818.616
    99.000   820.839
    99.500   823.062
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.672
    29.000   425.230
    29.500   430.787
    30.000   436.343
    30.500   441.898
    31.000   447.451
    31.500   453.003
    32.000   458.553
    32.500   464.100
    33.000   469.645
    33.500   475.186
    34.000   480.723
    34.500   486.257
    35.000   491.786
    35.500   497.309
    36.000   502.827
    36.500   508.340
    37.000   513.845
    37.500   519.343
    38.000   524.834
    38.500   530.316
    39.000   535.790
    39.500   541.254
    40.000   546.708
    40.500   552.151
    41.000   557.584
    41.500   563.004
    42.000   568.413
    42.500   573.808
    43.000   579.190
    43.500   584.558
    44.000   589.912
    44.500   595.251
    45.000   600.575
    45.500   605.883
    46.000   611.175
    46.500   616.450
    47.000   621.708
    47.500   626.458
    48.000   631.029
    48.500   635.595
    49.000   640.156
    49.500   644.713
    50.000   649.264
    50.500   653.811
    51.000   658.352
    51.500   662.887
    52.000   667.417
    52.500   671.941
    53.000   676.460
    53.500   680.972
    54.000   685.477
    54.500   689.974
    55.000   694.463
    55.500   698.941
    56.000   703.409
    56.500   707.869
    57.000   712.322
    57.500   716.771
    58.000   721.214
    58.500   725.653
    59.000   730.088
    59.500   734.518
    60.000   738.945
    60.500   743.368
    61.000   747.788
    61.500   752.203
    62.000   756.615
    62.500   761.022
    63.000   765.426
    63.500   769.826
    64.000   774.221
    64.500   778.612
    65.000   782.998
    65.500   787.378
    66.000   791.753
    66.500   796.122
    67.000   800.483
    67.500   804.838
    68.000   809.186
    68.500   813.526
    69.000   817.858
    69.500   822.183
    70.000   826.500
    70.500   830.810
    71.000   835.113
    71.500   839.407
    72.000   843.694
    72.500   847.974
    73.000   852.246
    73.500   856.510
    74.000   860.767
    74.500   865.015
    75.000   869.256
    75.500   873.489
    76.000   877.713
    76.500   881.930
    77.000   886.138
    77.500   890.339
    78.000   894.530
    78.500   898.714
    79.000   902.889
    79.500   907.055
    80.000   911.213
    80.500   915.362
    81.000   919.503
    81.500   923.635
    82.000   927.759
    82.500   931.874
    83.000   935.981
    83.500   940.079
    84.000   944.168
    84.500   948.249
    85.000   952.322
    85.500   956.385
    86.000   960.440
    86.500   964.486
    87.000   968.523
    87.500   972.552
    88.000   976.571
    88.500   980.582
    89.000   984.584
    89.500   988.576
    90.000   992.560
    90.500   996.535
    91.000  1000.501
    91.500  1004.458
    92.000  1008.406
    92.500  1012.345
    93.000  1016.274
    93.500  1020.195
    94.000  1024.107
    94.500  1028.010
    95.000  1031.903
    95.500  1035.788
    96.000  1039.664
    96.500  1043.530
    97.000  1047.388
    97.500  1051.236
    98.000  1055.075
    98.500  1058.905
    99.000  1062.726
    99.500  1066.538
   100.000  1070.341
   100.500  1074.134
   101.000  1077.919
   101.500  1081.694
   102.000  1085.460
   102.500  1089.217
   103.000  1092.964
   103.500  1096.703
   104.000  1100.433
   104.500  1104.154
   105.000  1107.866
   105.500  1111.569
   106.000  1115.264
   106.500  1118.949
   107.000  1122.625
   107.500  1126.293
   108.000  1129.951
   108.500  1133.600
   109.000  1137.240
   109.500  1140.870
   110.000  1144.492
   110.500  1148.104
   111.000  1151.707
   111.500  1155.300
   112.000  1158.884
   112.500  1162.459
   113.000  1166.025
   113.500  1169.582
   114.000  1173.130
   114.500  1176.668
   115.000  1180.198
   115.500  1183.719
   116.000  1187.230
   116.500  1190.732
   117.000  1194.226
   117.500  1197.710
   118.000  1201.185
   118.500  1204.651
   119.000  1208.108
   119.500  1211.556
   120.000  1214.994
   120.500  1218.423
   121.000  1221.843
   121.500  1225.254
   122.000  1228.656
   122.500  1232.048
   123.000  1235.431
   123.500  1238.805
   124.000  1242.170
   124.500  1245.526
   125.000  1248.873
   125.500  1252.211
   126.000  1255.540
   126.500  1258.860
   127.000  1262.172
   127.500  1265.474
   128.000  1268.767
   128.500  1272.051
   129.000  1275.327
   129.500  1278.593
   130.000  1281.851
   130.500  1285.099
   131.000  1288.339
   131.500  1291.569
   132.000  1294.791
   132.500  1298.003
   133.000  1301.206
   133.500  1304.401
   134.000  1307.586
   134.500  1310.762
   135.000  1313.929
   135.500  1317.087
   136.000  1320.236
   136.500  1323.376
   137.000  1326.507
   137.500  1329.628
   138.000  1332.741
   138.500  1335.845
   139.000  1338.939
   139.500  1342.024
   140.000  1345.101
   140.500  1348.168
   141.000  1351.226
   141.500  1354.275
   142.000  1357.315
   142.500  1360.346
   143.000  1363.368
   143.500  1366.381
   144.000  1369.385
   144.500  1372.379
   145.000  1375.365
   145.500  1378.341
   146.000  1381.308
   146.500  1384.266
   147.000  1387.215
   147.500  1390.154
   148.000  1393.083
   148.500  1396.004
   149.000  1398.915
   149.500  1401.816
   150.000  1404.708
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.285
   100.500   827.508
   101.000   829.730
   101.500   831.953
   102.000   834.176
   102.500   836.399
   103.000   838.622
   103.500   840.845
   104.000   843.067
   104.500   845.290
   105.000   847.513
   105.500   849.736
   106.000   851.959
   106.500   854.182
   107.000   856.404
   107.500   858.627
   108.000   860.850
   108.500   863.073
   109.000   865.296
   109.500   867.519
   110.000   869.741
   110.500   871.964
   111.000   874.187
   111.500   876.410
   112.000   878.633
   112.500   880.856
   113.000   883.078
   113.500   885.301
   114.000   887.524
   114.500   889.747
   115.000   891.970
   115.500   894.193
   116.000   896.415
   116.500   898.638
   117.000   900.861
   117.500   903.084
   118.000   905.307
   118.500   907.530
   119.000   909.752
   119.500   911.975
   120.000   914.198
   120.500   916.421
   121.000   918.644
   121.500   920.867
   122.000   923.089
   122.500   925.312
   123.000   927.535
   123.500   929.758
   124.000   931.981
   124.500   934.204
   125.000   936.426
   125.500   938.649
   126.000   940.872
   126.500   943.095
   127.000   945.318
   127.500   947.541
   128.000   949.763
   128.500   951.986
   129.000   954.209
   129.500   956.432
   130.000   958.655
   130.500   960.878
   131.000   963.100
   131.500   965.323
   132.000   967.546
   132.500   969.769
   133.000   971.992
   133.500   974.215
   134.000   976.438
   134.500   978.660
   135.000   980.883
   135.500   983.106
   136.000   985.329
   136.500   987.552
   137.000   989.774
   137.500   991.997
   138.000   994.220
   138.500   996.443
   139.000   998.666
   139.500  1000.889
   140.000  1003.112
   140.500  1005.334
   141.000  1007.557
   141.500  1009.780
   142.000  1012.003
   142.500  1014.226
   143.000  1016.449
   143.500  1018.671
   144.000  1020.894
   144.500  1023.117
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.621
    15.000   395.859
    15.500   406.094
    16.000   416.322
    16.500   426.539
    17.000   436.743
    17.500   446.928
    18.000   457.090
    18.500   467.224
    19.000   477.325
    19.500   487.386
    20.000   497.401
    20.500   507.365
    21.000   517.271
    21.500   527.114
    22.000   536.890
    22.500   546.593
    23.000   555.274
    23.500   563.416
    24.000   571.526
    24.500   579.603
    25.000   587.636
    25.500   595.589
    26.000   603.501
    26.500   611.401
    27.000   619.293
    27.500   627.177
    28.000   635.054
    28.500   642.924
    29.000   650.788
    29.500   658.645
    30.000   666.495
    30.500   674.337
    31.000   682.169
    31.500   689.990
    32.000   697.798
    32.500   705.592
    33.000   713.371
    33.500   721.132
    34.000   728.876
    34.500   736.602
    35.000   744.308
    35.500   751.995
    36.000   759.662
    36.500   767.309
    37.000   774.936
    37.500   782.543
    38.000   790.128
    38.500   797.691
    39.000   805.233
    39.500   812.752
    40.000   820.248
    40.500   827.721
    41.000   835.171
    41.500   842.597
    42.000   849.999
    42.500   857.377
    43.000   864.730
    43.500   872.059
    44.000   879.363
    44.500   886.643
    45.000   893.897
    45.500   901.126
    46.000   908.329
    46.500   915.507
    47.000   922.658
    47.500   929.783
    48.000   936.882
    48.500   943.953
    49.000   950.998
    49.500   958.015
    50.000   965.006
    50.500   971.969
    51.000   978.906
    51.500   985.814
    52.000   992.695
    52.500   999.549
    53.000  1006.375
    53.500  1013.175
    54.000  1019.950
    54.500  1026.698
    55.000  1033.419
    55.500  1040.114
    56.000  1046.781
    56.500  1053.420
    57.000  1060.031
    57.500  1066.614
    58.000  1073.169
    58.500  1079.696
    59.000  1086.195
    59.500  1092.667
    60.000  1099.111
    60.500  1105.527
    61.000  1111.916
    61.500  1118.276
    62.000  1124.609
    62.500  1130.912
    63.000  1137.188
    63.500  1143.434
    64.000  1149.653
    64.500  1155.843
    65.000  1162.005
    65.500  1168.138
    66.000  1174.244
    66.500  1180.321
    67.000  1186.369
    67.500  1192.390
    68.000  1198.381
    68.500  1204.344
    69.000  1210.279
    69.500  1216.184
    70.000  1222.062
    70.500  1227.910
    71.000  1233.729
    71.500  1239.520
    72.000  1245.281
    72.500  1251.013
    73.000  1256.716
    73.500  1262.388
    74.000  1268.030
    74.500  1273.643
    75.000  1279.225
    75.500  1284.778
    76.000  1290.302
    76.500  1295.797
    77.000  1301.262
    77.500  1306.696
    78.000  1312.101
    78.500  1317.475
    79.000  1322.819
    79.500  1328.134
    80.000  1333.419
    80.500  1338.676
    81.000  1343.901
    81.500  1349.096
    82.000  1354.259
    82.500  1359.390
    83.000  1364.489
    83.500  1369.556
    84.000  1374.593
    84.500  1379.598
    85.000  1384.573
    85.500  1389.516
    86.000  1394.427
    86.500  1399.307
    87.000  1404.154
    87.500  1408.968
    88.000  1413.750
    88.500  1418.499
    89.000  1423.214
    89.500  1427.896
    90.000  1432.544
    90.500  1437.158
    91.000  1441.739
    91.500  1446.286
    92.000  1450.798
    92.500  1455.278
    93.000  1459.723
    93.500  1464.134
    94.000  1468.519
    94.500  1472.887
    95.000  1477.242
    95.500  1481.585
    96.000  1485.917
    96.500  1490.235
    97.000  1494.537
    97.500  1498.819
    98.000  1503.081
    98.500  1507.323
    99.000  1511.546
    99.500  1515.749
   100.000  1519.930
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   720.723
     1.000   720.770
     1.500   720.847
     2.000   720.956
     2.500   721.096
     3.000   721.268
     3.500   721.470
     4.000   721.703
     4.500   721.967
     5.000   722.261
     5.500   722.587
     6.000   722.943
     6.500   723.330
     7.000   723.747
     7.500   724.195
     8.000   724.673
     8.500   725.181
     9.000   725.719
     9.500   726.287
    10.000   726.885
    10.500   727.513
    11.000   728.170
    11.500   728.856
    12.000   729.572
    12.500   730.317
    13.000   731.090
    13.500   731.892
    14.000   732.722
    14.500   733.581
    15.000   734.468
    15.500   735.383
    16.000   736.325
    16.500   737.295
    17.000   738.292
    17.500   739.316
    18.000   740.366
    18.500   741.443
    19.000   742.547
    19.500   743.676
    20.000   744.832
    20.500   746.012
    21.000   747.218
    21.500   748.449
    22.000   749.705
    22.500   750.985
    23.000   752.289
    23.500   753.617
    24.000   754.969
    24.500   756.344
    25.000   757.742
    25.500   759.163
    26.000   760.606
    26.500   762.071
    27.000   763.558
    27.500   765.067
    28.000   766.597
    28.500   768.148
    29.000   769.719
    29.500   771.310
    30.000   772.922
    30.500   774.553
    31.000   776.203
    31.500   777.873
    32.000   779.561
    32.500   781.267
    33.000   782.992
    33.500   784.734
    34.000   786.493
    34.500   788.270
    35.000   790.063
    35.500   791.872
    36.000   793.698
    36.500   795.539
    37.000   797.395
    37.500   799.267
    38.000   801.153
    38.500   803.053
    39.000   804.968
    39.500   806.896
    40.000   808.837
    40.500   810.792
    41.000   812.759
    41.500   814.738
    42.000   816.730
    42.500   818.733
    43.000   820.747
    43.500   822.773
    44.000   824.809
    44.500   826.855
    45.000   828.911
    45.500   830.977
    46.000   833.053
    46.500   835.137
    47.000   837.231
    47.500   839.332
    48.000   841.442
    48.500   843.559
    49.000   845.684
    49.500   847.816
    50.000   849.955
    50.500   852.101
    51.000   854.252
    51.500   856.410
    52.000   858.573
    52.500   860.742
    53.000   862.916
    53.500   865.094
    54.000   867.277
    54.500   869.465
    55.000   871.656
    55.500   873.851
    56.000   876.049
    56.500   878.251
    57.000   880.456
    57.500   882.663
    58.000   884.873
    58.500   887.085
    59.000   889.299
    59.500   891.515
    60.000   893.732
    60.500   895.951
    61.000   898.171
    61.500   900.392
    62.000   902.614
    62.500   904.836
    63.000   907.058
    63.500   909.281
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   932.777
     1.000   932.843
     1.500   932.954
     2.000   933.109
     2.500   933.308
     3.000   933.552
     3.500   933.839
     4.000   934.171
     4.500   934.547
     5.000   934.966
     5.500   935.430
     6.000   935.937
     6.500   936.488
     7.000   937.082
     7.500   937.720
     8.000   938.402
     8.500   939.126
     9.000   939.894
     9.500   940.704
    10.000   941.558
    10.500   942.454
    11.000   943.392
    11.500   944.373
    12.000   945.396
    12.500   946.461
    13.000   947.568
    13.500   948.716
    14.000   949.905
    14.500   951.136
    15.000   952.407
    15.500   953.720
    16.000   955.072
    16.500   956.465
    17.000   957.898
    17.500   959.370
    18.000   960.883
    18.500   962.434
    19.000   964.024
    19.500   965.653
    20.000   967.320
    20.500   969.026
    21.000   970.769
    21.500   972.550
    22.000   974.368
    22.500   976.223
    23.000   978.115
    23.500   980.044
    24.000   982.008
    24.500   984.008
    25.000   986.044
    25.500   988.114
    26.000   990.220
    26.500   992.360
    27.000   994.535
    27.500   996.743
    28.000   998.985
    28.500  1001.260
    29.000  1003.568
    29.500  1005.909
    30.000  1008.282
    30.500  1010.687
    31.000  1013.123
    31.500  1015.591
    32.000  1018.090
    32.500  1020.619
    33.000  1023.178
    33.500  1025.768
    34.000  1028.387
    34.500  1031.035
    35.000  1033.712
    35.500  1036.418
    36.000  1039.152
    36.500  1041.914
    37.000  1044.703
    37.500  1047.520
    38.000  1050.364
    38.500  1053.234
    39.000  1056.130
    39.500  1059.052
    40.000  1062.000
    40.500  1064.973
    41.000  1067.971
    41.500  1070.993
    42.000  1074.040
    42.500  1077.111
    43.000  1080.205
    43.500  1083.322
    44.000  1086.463
    44.500  1089.625
    45.000  1092.811
    45.500  1096.018
    46.000  1099.247
    46.500  1102.497
    47.000  1105.768
    47.500  1109.060
    48.000  1112.372
    48.500  1115.705
    49.000  1119.057
    49.500  1122.429
    50.000  1125.819
    50.500  1129.229
    51.000  1132.658
    51.500  1136.104
    52.000  1139.569
    52.500  1143.051
    53.000  1146.551
    53.500  1150.068
    54.000  1153.601
    54.500  1157.151
    55.000  1160.718
    55.500  1164.300
    56.000  1167.899
    56.500  1171.512
    57.000  1175.141
    57.500  1178.785
    58.000  1182.443
    58.500  1186.116
    59.000  1189.803
    59.500  1193.504
    60.000  1197.218
    60.500  1200.946
    61.000  1204.687
    61.500  1208.441
    62.000  1212.207
    62.500  1215.985
    63.000  1219.776
    63.500  1223.579
    64.000  1227.393
    64.500  1231.219
    65.000  1235.056
    65.500  1238.903
    66.000  1242.762
    66.500  1246.631
    67.000  1250.510
    67.500  1254.400
    68.000  1258.299
    68.500  1262.207
    69.000  1266.125
    69.500  1270.053
    70.000  1273.989
    70.500  1277.934
    71.000  1281.888
    71.500  1285.850
    72.000  1289.820
    72.500  1293.798
    73.000  1297.784
    73.500  1301.777
    74.000  1305.778
    74.500  1309.786
    75.000  1313.801
    75.500  1317.823
    76.000  1321.851
    76.500  1325.886
    77.000  1329.927
    77.500  1333.974
    78.000  1338.027
    78.500  1342.086
    79.000  1346.151
    79.500  1350.221
    80.000  1354.296
    80.500  1358.376
    81.000  1362.461
    81.500  1366.551
    82.000  1370.646
    82.500  1374.744
    83.000  1378.848
    83.500  1382.955
    84.000  1387.066
    84.500  1391.182
    85.000  1395.301
    85.500  1399.423
    86.000  1403.549
    86.500  1407.678
    87.000  1411.810
    87.500  1415.945
    88.000  1420.083
    88.500  1424.224
    89.000  1428.368
    89.500  1432.513
    90.000  1436.661
    90.500  1440.812
    91.000  1444.964
    91.500  1449.119
    92.000  1453.275
    92.500  1457.433
    93.000  1461.592
    93.500  1465.753
    94.000  1469.916
    94.500  1474.079
    95.000  1478.244
    95.500  1482.410
    96.000  1486.576
    96.500  1490.744
    97.000  1494.912
    97.500  1499.081
    98.000  1503.250
    98.500  1507.420
    99.000  1511.590
    99.500  1515.760
   100.000  1519.930
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.575
    29.500   783.814
    30.000   794.052
    30.500   804.289
    31.000   814.523
    31.500   824.753
    32.000   834.980
    32.500   845.201
    33.000   855.417
    33.500   865.625
    34.000   875.826
    34.500   886.018
    35.000   896.200
    35.500   906.370
    36.000   916.528
    36.500   926.672
    37.000   936.801
    37.500   946.913
    38.000   957.007
    38.500   966.730
    39.000   977.135
    39.500   987.166
    40.000   997.173
    40.500  1007.154
    41.000  1017.108
    41.500  1027.034
    42.000  1036.930
    42.500  1046.795
    43.000  1056.626
    43.500  1066.425
    44.000  1076.188
    44.500  1085.915
    45.000  1095.604
    45.500  1104.986
    46.000  1113.156
    46.500  1121.309
    47.000  1129.446
    47.500  1137.565
    48.000  1145.669
    48.500  1153.756
    49.000  1161.825
    49.500  1169.874
    50.000  1177.897
    50.500  1185.883
    51.000  1193.814
    51.500  1201.730
    52.000  1209.639
    52.500  1217.542
    53.000  1225.441
    53.500  1233.334
    54.000  1241.224
    54.500  1249.110
    55.000  1256.993
    55.500  1264.872
    56.000  1272.748
    56.500  1280.620
    57.000  1288.490
    57.500  1296.355
    58.000  1304.218
    58.500  1312.077
    59.000  1319.933
    59.500  1327.786
    60.000  1335.634
    60.500  1343.478
    61.000  1351.318
    61.500  1359.154
    62.000  1366.984
    62.500  1374.808
    63.000  1382.626
    63.500  1390.438
    64.000  1398.244
    64.500  1406.043
    65.000  1413.834
    65.500  1421.617
    66.000  1429.392
    66.500  1437.159
    67.000  1444.917
    67.500  1452.667
    68.000  1460.407
    68.500  1468.138
    69.000  1475.860
    69.500  1483.572
    70.000  1491.275
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     0.073     6.100     0.150
     0.340    13.409     0.150
     0.469     8.379     0.150
     0.720    40.029     0.150
     0.720    13.329     0.150
     0.733    25.659     0.150
     0.733    31.199     0.150
     1.286    41.129     0.150
     1.396    23.229     0.150
     1.396    45.100     0.150
     3.793    59.359     0.150
     5.385    81.439     0.150
     5.594    84.760     0.150
     6.713    97.749     0.150
     7.642   247.209     0.150
     7.738   114.409     0.150
     7.738   250.840     0.150
     8.183   121.729     0.150
     8.575   119.600     0.150
     8.630   133.600     0.150
     8.710   136.739     0.150
     9.336   243.039     0.150
     9.585   140.329     0.150
    10.381   152.079     0.150
    10.421   149.890     0.150
    10.751   156.909     0.150
    11.179   157.699     0.150
    11.305   353.510     0.150
    12.710   187.539     0.150
    12.741   186.159     0.150
    13.423   196.459     0.150
    13.490   194.909     0.150
    13.654   200.159     0.150
    13.845   202.520     0.150
    13.947   197.430     0.150
    14.161   205.199     0.150
    14.649   213.109     0.150
    14.770   377.800     0.150
    15.879   218.470     0.150
    15.924   225.609     0.150
    16.809   235.390     0.150
    18.223   253.129     0.150
    20.400   277.100     0.150
    21.029   282.970     0.150
    21.275   286.979     0.150
    21.663   291.550     0.150
    22.951   305.300     0.150
    24.219   316.760     0.150
    24.295   317.939     0.150
    28.913   359.680     0.150
    29.993   369.289     0.150
    30.127   370.260     0.150
    30.127   551.649     0.150
    30.579   373.409     0.150
    30.579   552.329     0.150
    36.476   427.550     0.150
    37.480   434.609     0.150
    37.480   572.819     0.150
    38.150   441.890     0.150
    38.150   575.329     0.150
    39.893   455.649     0.150
    43.559   484.079     0.150
    43.559   592.029     0.150
    46.259   506.159     0.150
    47.020   510.079     0.150
    50.762   541.659     0.150
    60.246   608.359     0.150
    62.631   623.359     0.150
    66.159   648.270     0.150
    77.244   714.379     0.150
    77.593   709.260     0.150
    79.615   727.260     0.150
    79.615   727.260     0.150
    79.734   728.060     0.150
    79.734   728.060     0.150
    80.332   731.479     0.150
    80.505   732.159     0.150
    80.505   732.159     0.150
    80.544   732.359     0.150
    80.544   732.359     0.150
    80.796   733.459     0.150
    80.796   733.459     0.150
    81.522  1636.959     0.150
    82.044   739.659     0.150
    82.044   739.659     0.150
    82.158     1.860     0.150
    82.983   745.609     0.150
    82.983   745.359     0.150
    83.190   746.959     0.150
    83.492   747.359     0.150
    83.492   747.359     0.150
    83.651   748.260     0.150
    83.651   748.260     0.150
    83.652   748.359     0.150
    83.652   748.359     0.150
    83.692   748.760     0.150
    83.692   748.760     0.150
    83.659   750.430     0.150
    83.753   748.459     0.150
    83.753   748.459     0.150
    83.766   749.060     0.150
    83.885   744.159     0.150
    84.100   750.060     0.150
    84.100   750.060     0.150
    84.166   751.159     0.150
    84.166   751.159     0.150
    84.307   751.260     0.150
    84.307   751.260     0.150
    84.427   752.459     0.150
    84.427   752.459     0.150
    84.592   753.159     0.150
    84.592   753.159     0.150
    84.589   752.560     0.150
    84.589   752.560     0.150
    84.589   752.560     0.150
    85.066   757.160     0.150
    85.260   756.760     0.150
    85.260   756.760     0.150
    85.431   757.459     0.150
    85.431   757.459     0.150
    85.736   758.859     0.150
    85.736   758.859     0.150
    85.785   761.059     0.150
    86.342   762.160     0.150
    86.342   762.160     0.150
    86.637   763.840     0.150
    87.657   768.260     0.150
    87.657   768.260     0.150
    87.743   768.660     0.150
    87.743   768.660     0.150
    90.213   782.389     0.150
    90.525   784.299     0.150
    91.382  1811.959     0.150
    91.382   787.459     0.150
    94.146   799.500     0.150
    94.943   803.289     0.150
    95.270   806.160     0.150
    95.270  1441.959     0.150
    95.270  1479.160     0.150
    95.270  1868.859     0.150
    98.025     3.500     0.150
    98.025     6.900     0.150
    99.611   824.180     0.150
   101.402   832.959     0.150
   125.307  1146.660     0.150
   125.307  1149.559     0.150
   125.307  1158.959     0.150
   125.307  1178.859     0.150
   125.804  1148.559     0.150
   125.804  1151.260     0.150
   125.804  1160.859     0.150
   125.804  1180.260     0.150
   126.070  1148.160     0.150
   126.070  1150.959     0.150
   126.070  1160.160     0.150
   126.070  1180.160     0.150
   127.429  1159.260     0.150
     0.713    26.387     0.150
     0.713    13.156     0.150
     0.713    23.527     0.150
     0.716    26.328     0.150
     0.716    13.227     0.150
     0.716    24.195     0.150
     1.328    40.637     0.150
     1.328    42.297     0.150
     1.380    43.547     0.150
     3.805   104.766     0.150
     5.400    84.316     0.150
     5.609    81.816     0.150
     5.907    93.309     0.150
     6.485   109.926     0.150
     6.528    98.980     0.150
     6.528   124.027     0.150
     6.609   111.988     0.150
     6.628   106.715     0.150
     7.026   119.906     0.150
     7.658   125.727     0.150
     7.862   112.508     0.150
     7.997   124.086     0.150
     8.430   208.906     0.150
    11.321   167.137     0.150
    11.321   364.105     0.150
    11.610   163.957     0.150
    11.657   164.016     0.150
    15.935   510.137     0.150
    20.884   280.418     0.150
    83.320   748.188     0.150
    83.320     9.000     0.150
    95.273     7.000     0.150
     0.765    28.500     0.150
     0.758    27.160     0.150
     0.758    13.971     0.150
     0.758    24.561     0.150
     1.379    42.141     0.150
     1.606    28.920     0.150
     3.193    50.920     0.150
     6.490   110.080     0.150
     6.534   103.439     0.150
     6.534   219.160     0.150
     7.737   235.439     0.150
    11.289   169.240     0.150
    11.289   373.512     0.150
    11.485   163.330     0.150
    11.583   166.230     0.150
    11.972   171.600     0.150
    15.925   509.090     0.150
    86.127   755.740     0.150
    98.051   812.740     0.150
     0.755    56.473     0.150
     0.755    56.484     0.150
     1.367    40.906     0.150
     5.367    89.465     0.150
     5.891    93.555     0.150
     6.515   100.785     0.150
     6.515   221.160     0.150
     7.752   239.535     0.150
     7.906   119.426     0.150
     8.024   122.914     0.150
     9.649   135.184     0.150
    10.406   148.223     0.150
    11.165   155.934     0.150
    11.286   164.895     0.150
    11.286   360.734     0.150
    15.860   229.336     0.150
    22.898   301.559     0.150
    30.114   371.523     0.150
    91.506   786.754     0.150
   112.290  1119.234     0.150
     0.759    29.348     0.150
     0.954    34.387     0.150
     0.973    34.840     0.150
     1.126    17.668     0.150
     5.463    99.598     0.150
     7.674   105.457     0.150
    94.653     4.898     0.150
    94.653     7.000     0.150
   100.837   833.898     0.150
     0.090     0.570     0.150
     0.216     9.320     0.150
     0.867    36.367     0.150
     1.257    19.898     0.150
     1.520    26.438     0.150
     1.537    26.742     0.150
     3.534    53.930     0.150
     3.723   102.125     0.150
     5.934    86.930     0.150
     5.934   103.664     0.150
     5.934   181.906     0.150
     6.357   114.883     0.150
    11.095   352.938     0.150
    11.095   158.750     0.150
    11.095   352.938     0.150
     0.535     9.625     0.150
     0.749    28.781     0.150
     0.924    15.969     0.150
     0.999    17.164     0.150
     1.121    17.586     0.150
     3.179    47.734     0.150
     3.600    60.734     0.150
     3.842    56.484     0.150
     3.930    57.695     0.150
     4.796    69.859     0.150
     4.953    74.875     0.150
     5.131    93.328     0.150
     5.526    80.945     0.150
     6.031   188.797     0.150
     6.618    95.336     0.150
     7.825   125.484     0.150
     7.976   133.984     0.150
     8.288   264.625     0.150
     9.800   140.945     0.150
    11.124   359.570     0.150
     0.143     8.973     0.150
     0.441     8.572     0.150
     0.466     9.072     0.150
     0.528     9.842     0.150
     0.551     9.941     0.150
     0.657    11.602     0.150
     0.703    12.533     0.150
     1.002    17.303     0.150
     1.151    21.582     0.150
     1.170    34.602     0.150
     1.573    45.906     0.150
     1.811    35.053     0.150
     1.844    54.924     0.150
     1.952    58.643     0.150
     2.091    61.594     0.150
     2.470    72.617     0.150
     2.775    82.117     0.150
     2.954    85.203     0.150
     3.297    48.697     0.150
     3.321    98.346     0.150
     3.719   110.006     0.150
     3.962    57.947     0.150
     4.023    58.723     0.150
     4.140    80.662     0.150
     4.250   126.492     0.150
     4.588    68.650     0.150
     5.081   126.643     0.150
     5.489    78.957     0.150
     5.602   166.654     0.150
     5.645    81.254     0.150
     5.824    86.592     0.150
     6.444   211.820     0.150
     6.444    94.572     0.150
     6.444   120.432     0.150
     6.444   211.822     0.150
     6.566    97.572     0.150
     6.566   212.543     0.150
     6.607   165.252     0.150
     6.945   207.441     0.150
     7.213   102.523     0.150
     7.343   108.672     0.150
     7.699   112.953     0.150
     7.788   240.777     0.150
     7.788   251.033     0.150
     7.820   142.363     0.150
     7.986   247.102     0.150
     8.111   114.643     0.150
     8.277   242.293     0.150
     8.590   127.473     0.150
     9.414   235.691     0.150
     9.414   302.463     0.150
     9.528   138.941     0.150
     9.616   291.662     0.150
     9.977   145.482     0.150
    10.027   247.691     0.150
    10.308   152.072     0.150
    10.476   313.203     0.150
    10.476   150.203     0.150
    10.476   313.203     0.150
    10.732   337.213     0.150
    11.115   344.982     0.150
    11.483   161.170     0.150
    11.587   162.363     0.150
    12.331   172.359     0.150
    12.486   175.096     0.150
    12.638   176.469     0.150
    13.970   197.393     0.150
    14.616   207.482     0.150
    14.880   369.441     0.150
    15.123   216.902     0.150
    15.803   391.572     0.150
    15.855   225.162     0.150
    16.854   237.271     0.150
    18.248   253.283     0.150
    21.041   284.283     0.150
    21.285   287.373     0.150
    22.342   298.102     0.150
    22.886   718.027     0.150
    22.886   302.902     0.150
    22.886   718.033     0.150
    22.971   304.982     0.150
    23.974   315.322     0.150
    23.974   752.402     0.150
    24.187   316.043     0.150
    24.229   317.332     0.150
    24.308   317.572     0.150
    26.268   336.572     0.150
    26.268   827.982     0.150
    26.696   339.242     0.150
    26.876   340.582     0.150
    27.834   351.613     0.150
    28.929   359.293     0.150
    30.061   369.492     0.150
    36.398   426.502     0.150
    37.674   436.742     0.150
    38.074   439.123     0.150
    40.552   458.572     0.150
    43.499   483.293     0.150
    77.537   721.602     0.150
    77.712   717.873     0.150
    77.906  1002.303     0.150
    77.906  1818.203     0.150
    79.278   728.203     0.150
    79.589   729.203     0.150
    79.589   729.203     0.150
    79.589   729.203     0.150
    79.708   730.402     0.150
    79.708   730.402     0.150
    79.708   730.402     0.150
    80.405   732.322     0.150
    80.477   734.502     0.150
    80.477   734.502     0.150
    80.477   734.502     0.150
    80.769   735.803     0.150
    80.769   735.803     0.150
    80.769   735.803     0.150
    81.966   741.703     0.150
    81.966   741.703     0.150
    82.018   742.502     0.150
    82.018   742.502     0.150
    82.018   742.502     0.150
    82.230   743.902     0.150
    83.425   750.002     0.150
    83.559   750.402     0.150
    83.619   750.602     0.150
    83.619   750.602     0.150
    83.619   750.602     0.150
    83.623   749.602     0.150
    83.623   749.602     0.150
    83.664   750.203     0.150
    83.664   750.203     0.150
    83.725   750.902     0.150
    83.737   748.822     0.150
    83.741   751.502     0.150
    83.741   751.502     0.150
    83.741   751.502     0.150
    84.072   752.803     0.150
    84.072   752.803     0.150
    84.072   752.803     0.150
    84.144   753.002     0.150
    84.144   753.002     0.150
    84.146   750.873     0.150
    84.282   754.203     0.150
    84.282   754.203     0.150
    84.282   754.203     0.150
    84.396   753.703     0.150
    84.396   753.703     0.150
    84.560   755.602     0.150
    84.560   755.602     0.150
    84.931   763.902     0.150
    85.029   769.402     0.150
    85.029  2110.402     0.150
    85.029   758.402     0.150
    85.029   769.402     0.150
    85.029  1398.402     0.150
    85.117   757.973     0.150
    85.231   759.102     0.150
    85.231   759.102     0.150
    85.231   759.102     0.150
    85.458   761.602     0.150
    85.709   761.602     0.150
    85.747   761.182     0.150
    86.026   756.002     0.150
    86.026  1727.602     0.150
    86.293   764.303     0.150
    91.478   785.672     0.150
    93.554   790.602     0.150
    95.192     4.801     0.150
    95.192  1859.602     0.150
    99.538   823.072     0.150
   101.661   827.902     0.150
   109.075  1137.303     0.150
   109.075  1322.602     0.150
   112.212  1161.902     0.150
   122.289  1134.783     0.150
     0.136     8.703     0.150
     0.406     7.516     0.150
     0.450     8.438     0.150
     1.343    23.484     0.150
     1.398    50.422     0.150
     1.514    24.023     0.150
     2.636    44.664     0.150
     2.961    50.141     0.150
     3.636    55.016     0.150
     4.267   139.375     0.150
     5.073   128.750     0.150
     5.569    83.203     0.150
     5.582    89.344     0.150
     5.834    91.547     0.150
     6.455    97.820     0.150
     6.575    92.945     0.150
     6.647   111.844     0.150
     6.922   110.703     0.150
     6.955   106.344     0.150
     7.607   116.805     0.150
     7.790   240.922     0.150
     7.941   121.414     0.150
     7.996   118.805     0.150
     8.121   125.242     0.150
     8.288   120.562     0.150
     8.718   136.414     0.150
     9.621   141.727     0.150
    10.246   155.656     0.150
    10.739   156.742     0.150
    10.990   164.648     0.150
    10.990   164.641     0.150
    10.990   350.586     0.150
    11.266   167.586     0.150
    11.268   352.172     0.150
    11.573   171.984     0.150
    12.341   179.898     0.150
    12.491   186.344     0.150
    13.279   196.914     0.150
    13.385   192.344     0.150
    13.607   198.641     0.150
    13.878   205.156     0.150
    14.166   207.500     0.150
    15.134   217.266     0.150
    15.843   220.188     0.150
    16.556   236.906     0.150
    16.852   237.812     0.150
    18.249   254.477     0.150
    19.267   270.656     0.150
    20.043   267.844     0.150
    20.414   279.211     0.150
    21.962   298.547     0.150
    22.346   298.375     0.150
    22.371   301.805     0.150
    22.774   305.586     0.150
    22.972   304.625     0.150
    23.209   316.625     0.150
    24.197   316.227     0.150
    25.668   334.273     0.150
    37.684   435.297     0.150
    43.876   485.695     0.150
    47.414   515.453     0.150
    50.730   543.547     0.150
    60.913   616.641     0.150
    60.913   616.641     0.150
    60.913   616.641     0.150
    79.596   729.945     0.150
    80.776   736.445     0.150
    80.776   736.445     0.150
    80.776   736.445     0.150
    83.472   750.641     0.150
    83.472   750.641     0.150
    83.626   751.344     0.150
    83.626   751.344     0.150
    83.626   751.344     0.150
    83.630   751.547     0.150
    83.630   751.547     0.150
    83.630   751.547     0.150
    83.671   750.445     0.150
    83.732   751.742     0.150
    83.732   751.742     0.150
    83.732   751.742     0.150
    83.748   752.047     0.150
    83.748   752.047     0.150
    83.748   752.047     0.150
    84.080   753.445     0.150
    84.080   753.445     0.150
    84.080   753.445     0.150
    84.152   754.719     0.150
    84.289   754.641     0.150
    84.289   754.641     0.150
    84.289   754.641     0.150
    84.404   754.047     0.150
    84.404   754.047     0.150
    84.568   756.047     0.150
    84.780   755.547     0.150
    84.780   755.547     0.150
    85.037   760.344     0.150
    85.037   760.344     0.150
    85.238   759.641     0.150
    85.238   759.641     0.150
    85.238   759.641     0.150
    90.386   788.844     0.150
    91.487   786.062     0.150
    95.202     4.797     0.150
    95.202  1472.047     0.150
   109.084  1322.945     0.150
   112.221  1115.945     0.150
   119.697  1139.453     0.150
     0.726    12.406     0.150
     0.726    22.086     0.150
     1.012    33.891     0.150
     1.012    36.461     0.150
     1.342    40.852     0.150
     1.414    27.508     0.150
     1.414    57.109     0.150
     1.414    58.008     0.150
     1.491    32.992     0.150
     1.491    49.445     0.150
     2.198    33.078     0.150
     2.619    42.289     0.150
     2.884    55.445     0.150
     3.090    52.531     0.150
     3.558    99.945     0.150
     4.126    64.375     0.150
     6.432   124.273     0.150
     6.432   220.328     0.150
     6.432   110.320     0.150
     6.432   124.281     0.150
     6.432   220.328     0.150
     7.347   183.672     0.150
     7.347   235.367     0.150
     7.797   232.750     0.150
    10.491   316.203     0.150
    11.257   168.320     0.150
    11.257   205.750     0.150
    11.257   354.531     0.150
     0.740    12.426     0.150
     0.740    22.166     0.150
     1.134    39.526     0.150
     1.134    43.155     0.150
     1.331    40.946     0.150
     1.374    44.257     0.150
     1.400    26.976     0.150
     1.400    54.396     0.150
     2.484    75.739     0.150
     3.293    49.325     0.150
     4.119    62.603     0.150
     4.135    61.376     0.150
     4.495    66.308     0.150
     5.070    77.187     0.150
     5.169    75.386     0.150
     5.562    83.562     0.150
     5.830    87.331     0.150
     5.826    87.286     0.150
     5.900    88.267     0.150
     6.444   203.513     0.150
     6.578    99.825     0.150
     6.578   111.356     0.150
     6.740    97.522     0.150
     6.910   109.706     0.150
     7.022   103.909     0.150
     7.359   229.276     0.150
     7.611   118.757     0.150
     7.806   241.126     0.150
     7.835   243.626     0.150
     7.997   116.276     0.150
     8.114   224.226     0.150
     8.284   264.386     0.150
    10.310   150.677     0.150
    10.491   334.339     0.150
    10.748   157.026     0.150
    10.978   162.030     0.150
    10.978   356.530     0.150
    10.978   161.985     0.150
    11.847   167.136     0.150
    13.403   192.616     0.150
    13.988   198.126     0.150
    14.179   200.735     0.150
    14.631   207.325     0.150
    15.860   225.636     0.150
    16.870   237.306     0.150
    18.266   253.087     0.150
    20.429   277.606     0.150
    21.059   284.007     0.150
    21.303   288.075     0.150
    22.359   299.026     0.150
    22.900   727.126     0.150
    22.989   306.126     0.150
    23.984   315.847     0.150
    24.199   316.876     0.150
    26.286   332.677     0.150
    27.836   351.896     0.150
    47.098   511.739     0.150
    52.787   555.052     0.150
    55.966   585.825     0.150
    63.068   627.696     0.150
    77.212   716.427     0.150
    89.516   782.126     0.150
    89.516   785.726     0.150
    95.189  1433.427     0.150
    95.189  1858.325     0.150
   101.242  1468.126     0.150
   109.070  1324.726     0.150
     0.475    18.590     0.150
     0.475     9.020     0.150
     0.475    16.270     0.150
     0.726    21.754     0.150
     0.726    12.379     0.150
     0.726    12.367     0.150
     1.343    40.109     0.150
     1.492    23.508     0.150
     2.510    37.840     0.150
     2.619    94.668     0.150
     3.559    50.566     0.150
     3.559   118.270     0.150
     4.128    64.258     0.150
     4.543    92.039     0.150
     5.560   108.387     0.150
     6.933   106.609     0.150
     7.698   117.066     0.150
     7.796   253.254     0.150
     7.796   116.500     0.150
     7.796   146.078     0.150
     7.796   253.250     0.150
     7.906   254.859     0.150
     7.928   124.219     0.150
     8.587   130.879     0.150
     8.704   131.938     0.150
     9.621   135.840     0.150
    10.489   338.672     0.150
    11.109   166.758     0.150
    11.257   364.961     0.150
    11.539   172.168     0.150
    11.560   171.438     0.150
    13.058   191.129     0.150
    13.529   199.797     0.150
    15.113   220.207     0.150
    15.136   220.617     0.150
    16.617   241.000     0.150
    18.065   256.199     0.150
    27.824   348.277     0.150
     0.473     9.211     0.150
     0.732    21.727     0.150
     0.732    12.500     0.150
     0.732    12.570     0.150
     0.737    14.172     0.150
     0.737    25.641     0.150
     1.010    35.309     0.150
     1.337    39.770     0.150
     1.411    26.539     0.150
     1.411    48.500     0.150
     1.491    23.570     0.150
     1.491    49.500     0.150
     2.622    94.570     0.150
     3.557   121.359     0.150
     4.012    60.562     0.150
     4.126   138.102     0.150
     6.434   100.234     0.150
     7.352   239.961     0.150
     7.802   252.324     0.150
     7.912   121.922     0.150
     9.132   138.570     0.150
    11.262   364.453     0.150
    11.262   165.328     0.150
    11.262   364.449     0.150
    13.062   183.559     0.150
    13.750   201.500     0.150
    14.300   209.852     0.150
    22.892   306.926     0.150
    22.892   306.922     0.150
    30.057   367.367     0.150
    83.227   740.949     0.150
    95.179   798.648     0.150
    95.179    10.602     0.150
    95.179    15.301     0.150
    95.179  1029.648     0.150
    95.179  1430.148     0.150
    95.179  1854.551     0.150
   102.573   831.750     0.150
   102.573   846.250     0.150
     0.031     1.773     0.150
     0.463     8.924     0.150
     0.665    12.412     0.150
     0.728    22.213     0.150
     0.744    14.104     0.150
     0.744    25.203     0.150
     1.346    40.803     0.150
     1.405    41.822     0.150
     1.405    51.332     0.150
     1.405    55.604     0.150
     1.508    23.924     0.150
     3.575    99.742     0.150
     4.481   140.322     0.150
     6.447    99.742     0.150
     6.447   124.893     0.150
     7.789   112.963     0.150
     7.789   247.242     0.150
     8.281   124.094     0.150
     8.281   155.963     0.150
     8.281   264.242     0.150
    10.475   333.281     0.150
    11.262   173.531     0.150
    11.262   366.943     0.150
     0.461     9.255     0.150
     0.461    16.436     0.150
     0.632    10.236     0.150
     0.692    11.539     0.150
     0.734    11.519     0.150
     0.734    21.976     0.150
     1.339    39.795     0.150
     2.632    40.516     0.150
     4.141    63.976     0.150
     5.828    91.505     0.150
     6.448    98.235     0.150
     7.351   110.056     0.150
     7.796   117.085     0.150
     7.796   116.155     0.150
     8.283   117.724     0.150
    10.481   340.390     0.150
    11.267   365.731     0.150
     0.473    15.781     0.150
     0.473    23.969     0.150
     0.732    12.680     0.150
     1.010    25.492     0.150
     1.010    39.891     0.150
     1.133    39.125     0.150
     1.335    24.930     0.150
     1.378    25.359     0.150
     1.411    55.102     0.150
     1.411    56.266     0.150
     1.490    43.172     0.150
     1.554    45.672     0.150
     2.881    44.828     0.150
     2.881    81.211     0.150
     2.936    85.250     0.150
     3.555    67.984     0.150
     3.853    55.430     0.150
     3.853   104.414     0.150
     4.125   114.273     0.150
     4.125    60.711     0.150
     4.125    80.570     0.150
     4.125   114.234     0.150
     4.545    92.719     0.150
     4.545   143.914     0.150
     5.542    82.625     0.150
     5.542   146.680     0.150
     5.542   172.672     0.150
     5.815   169.898     0.150
     6.433   213.125     0.150
     6.569    98.648     0.150
     6.569   170.266     0.150
     6.622    99.273     0.150
     6.622   131.500     0.150
     6.622   172.945     0.150
     6.899   107.516     0.150
     6.931   101.812     0.150
     6.931   180.555     0.150
     6.931   221.719     0.150
     7.121   136.680     0.150
     7.121   234.992     0.150
     7.483   234.102     0.150
     7.804   238.297     0.150
     7.804   149.992     0.150
     7.804   251.539     0.150
     7.912   152.805     0.150
     7.912   252.789     0.150
     7.933   119.703     0.150
     7.942   125.539     0.150
     7.986   113.281     0.150
     8.103   119.328     0.150
     8.103   158.148     0.150
     8.114   159.078     0.150
     8.114   259.141     0.150
     8.273   250.422     0.150
     8.273   118.781     0.150
     8.273   253.500     0.150
     8.592   128.453     0.150
     8.592   166.359     0.150
     8.592   222.391     0.150
     8.592   274.852     0.150
     8.709   131.359     0.150
     9.199   106.312     0.150
     9.528   249.180     0.150
     9.963   142.766     0.150
     9.963   257.750     0.150
    10.299   267.273     0.150
    10.299   149.766     0.150
    10.299   267.219     0.150
    10.495   150.195     0.150
    10.495   330.094     0.150
    10.823   153.305     0.150
    10.967   352.773     0.150
    10.967   284.484     0.150
    11.112   287.312     0.150
    11.262   348.164     0.150
    11.543   165.211     0.150
    11.543   291.109     0.150
    11.565   164.695     0.150
    12.689   178.875     0.150
    12.689   178.875     0.150
    12.689   308.234     0.150
    12.768   182.922     0.150
    13.062   185.281     0.150
    13.432   341.242     0.150
    13.406   190.148     0.150
    13.406   334.664     0.150
    13.589   197.969     0.150
    13.614   190.430     0.150
    13.987   358.109     0.150
    14.528   366.414     0.150
    14.623   206.000     0.150
    14.623   368.570     0.150
    15.113   215.242     0.150
    15.113   512.102     0.150
    15.838   389.500     0.150
    15.849   224.742     0.150
    16.872   236.172     0.150
    16.872   422.109     0.150
    18.265   253.805     0.150
    20.427   277.570     0.150
    21.057   282.422     0.150
    21.057   517.484     0.150
    21.706   291.125     0.150
    21.975   293.016     0.150
    22.354   295.719     0.150
    22.987   304.398     0.150
    24.189   318.469     0.150
    29.950   372.875     0.150
    29.950   372.852     0.150
    43.497   483.992     0.150
    62.539   630.570     0.150
    62.539  1136.070     0.150
    77.203   716.672     0.150
    83.432   747.672     0.150
    83.630   747.570     0.150
    83.630   747.570     0.150
    83.671   749.273     0.150
    83.671   749.273     0.150
    84.776   758.969     0.150
    91.481   788.891     0.150
    91.744   794.672     0.150
    93.539  1456.773     0.150
    94.733   804.961     0.150
    95.178     4.500     0.150
    96.278   814.344     0.150
    96.380   814.344     0.150
   109.060  1324.469     0.150
     0.046    -0.156     0.150
     0.470    16.554     0.150
     0.470    23.084     0.150
     0.739    12.484     0.150
     1.007    24.625     0.150
     1.007    37.475     0.150
     1.007    44.344     0.150
     1.007    55.625     0.150
     1.128    33.714     0.150
     1.490    23.554     0.150
     1.406    53.834     0.150
     2.880    84.944     0.150
     4.047   113.074     0.150
     4.577    66.942     0.150
     4.831    70.625     0.150
     5.340   164.514     0.150
     5.561    88.484     0.150
     5.818    93.024     0.150
     6.436    97.504     0.150
     6.436   123.830     0.150
     6.436   202.104     0.150
     6.574   112.194     0.150
     7.360   134.754     0.150
     7.608   108.174     0.150
     7.711   130.294     0.150
     7.922   250.455     0.150
     7.992   119.944     0.150
     7.992   248.725     0.150
     8.485   152.564     0.150
    10.228   145.014     0.150
    10.499   326.354     0.150
    10.969   347.783     0.150
    11.268   352.759     0.150
    11.570   174.214     0.150
    12.477   184.725     0.150
    12.730   202.205     0.150
    12.773   190.614     0.150
    13.593   198.534     0.150
    14.182   203.114     0.150
    43.502   484.324     0.150
   109.060  1324.554     0.150
     0.018     1.188     0.150
     0.119     8.062     0.150
     0.711    13.211     0.150
     0.767    12.984     0.150
     0.767    23.117     0.150
     0.712    25.766     0.150
     1.366    23.672     0.150
     1.359    67.508     0.150
     1.542    24.336     0.150
     1.881    56.203     0.150
     3.308    50.891     0.150
     3.332    51.398     0.150
     5.614    91.867     0.150
     6.489    99.445     0.150
     6.489   125.945     0.150
     6.489    99.445     0.150
     6.489   125.945     0.150
     6.489   206.227     0.150
     6.954    99.484     0.150
     7.807   238.078     0.150
     7.978   113.195     0.150
     8.034   114.688     0.150
     8.326   118.852     0.150
    10.280   142.164     0.150
    11.021   359.359     0.150
    11.305   353.227     0.150
    11.875   175.781     0.150
    13.644   201.438     0.150
    13.984   191.867     0.150
    14.658   210.984     0.150
    16.329   240.328     0.150
    21.061   287.227     0.150
    21.461   285.938     0.150
    21.627   294.273     0.150
    22.786   296.523     0.150
    22.927   714.656     0.150
    24.234   314.102     0.150
    24.320   319.773     0.150
    25.681   340.242     0.150
    27.880   356.555     0.150
    35.056   420.156     0.150
    37.717   439.875     0.150
    55.497   571.172     0.150
    60.949   613.805     0.150
    63.109   632.945     0.150
    91.524   788.477     0.150
    95.231     7.102     0.150
    95.231  1472.305     0.150
    95.231  1860.406     0.150
   109.111  1324.102     0.150
     0.405     7.523     0.150
     0.405    14.359     0.150
     0.405    17.109     0.150
     0.405    20.484     0.150
     0.744    12.641     0.150
     2.409    35.898     0.150
     2.748    40.789     0.150
     2.856    42.516     0.150
     3.177    53.625     0.150
     3.349    49.852     0.150
     3.723    54.328     0.150
     3.768    54.914     0.150
     4.221    65.336     0.150
     4.362    63.500     0.150
     4.478    64.492     0.150
     4.706    68.789     0.150
     4.911    71.172     0.150
     5.058    74.898     0.150
     5.581    83.688     0.150
     5.591    79.914     0.150
     5.651    81.641     0.150
     6.518   105.531     0.150
     6.518   119.109     0.150
     6.518   221.531     0.150
     7.069   104.609     0.150
     7.197   103.805     0.150
     7.755   251.008     0.150
     7.755   117.781     0.150
     7.755   251.008     0.150
     8.622   123.789     0.150
     9.533   136.633     0.150
    11.290   172.055     0.150
    11.290   372.203     0.150
    22.902   310.578     0.150
    30.118   375.852     0.150
    37.475   437.578     0.150
     3.075    45.209     0.150
     3.863   126.049     0.150
     4.307   142.409     0.150
     4.659   145.729     0.150
     5.769    87.589     0.150
     6.649   105.074     0.150
     6.649   105.068     0.150
     6.649   123.028     0.150
     7.897   114.739     0.150
     7.897   249.929     0.150
     8.507   128.634     0.150
    10.447   322.989     0.150
     0.060     0.508     0.150
     0.480     8.852     0.150
     0.508     9.391     0.150
     0.514     9.891     0.150
     0.619    11.352     0.150
     0.724    13.891     0.150
     0.724    24.883     0.150
     0.765    25.211     0.150
     0.774    13.023     0.150
     0.774    23.000     0.150
     0.774    13.102     0.150
     1.288    43.539     0.150
     1.337    23.102     0.150
     1.337    43.539     0.150
     2.886    43.305     0.150
     3.195    67.328     0.150
     5.400   168.773     0.150
     5.610   165.695     0.150
     5.665    94.695     0.150
     6.537   104.852     0.150
     6.537   215.625     0.150
     6.537   104.852     0.150
     6.537   215.625     0.150
     6.627    93.562     0.150
     6.726    96.172     0.150
     7.941   237.562     0.150
     8.046   159.492     0.150
     8.057   122.164     0.150
     8.175   116.523     0.150
     8.200   152.461     0.150
     8.726   287.281     0.150
     8.774   123.695     0.150
     9.203   305.578     0.150
     9.563   177.445     0.150
     9.601   312.664     0.150
    10.329   144.891     0.150
    10.398   146.812     0.150
    10.415   331.648     0.150
    10.762   197.883     0.150
    11.196   213.500     0.150
    11.196   357.023     0.150
    11.393   371.219     0.150
    11.611   391.609     0.150
    11.903   402.055     0.150
    12.551   185.883     0.150
    12.726   187.578     0.150
    13.685   191.008     0.150
    14.917   217.992     0.150
    20.404   270.391     0.150
    24.252   311.664     0.150
    30.144   371.039     0.150
    92.297   791.273     0.150
   102.678   848.203     0.150
   145.905  1180.594     0.150
     0.795    12.922     0.150
     1.133    19.406     0.150
     1.354    50.562     0.150
     1.354    51.914     0.150
     1.514    24.023     0.150
     2.892    43.320     0.150
     2.945    41.734     0.150
     3.130    47.023     0.150
     3.130    47.023     0.150
     3.883    56.227     0.150
     4.150    61.523     0.150
     4.609    69.219     0.150
     4.755    70.234     0.150
     5.603    83.023     0.150
     5.714    84.516     0.150
     6.473    98.172     0.150
     6.473   203.125     0.150
     6.473    98.172     0.150
     6.473   203.125     0.150
     6.631    98.422     0.150
     6.636    96.227     0.150
     6.958   101.922     0.150
     7.750   113.523     0.150
     7.767   112.727     0.150
     7.852   240.297     0.150
     7.852   113.320     0.150
     8.047   120.625     0.150
     8.152   120.320     0.150
     8.655   128.023     0.150
     9.193   131.773     0.150
     9.587   138.523     0.150
    10.185   149.125     0.150
    10.345   147.023     0.150
    10.345   147.023     0.150
    10.512   327.273     0.150
    10.512   150.805     0.150
    10.512   327.273     0.150
    10.512   150.820     0.150
    10.802   156.922     0.150
    11.169   159.094     0.150
    11.195   160.664     0.150
    11.324   159.891     0.150
    11.324   352.945     0.150
    11.324   162.875     0.150
    11.324   352.945     0.150
    11.327   153.656     0.150
    11.516   168.039     0.150
    12.853   180.328     0.150
    13.121   186.633     0.150
    13.433   193.320     0.150
    13.492   195.227     0.150
    13.791   200.844     0.150
    14.685   207.922     0.150
    15.901   226.023     0.150
    16.955   237.508     0.150
    18.307   253.023     0.150
    22.833   304.680     0.150
    22.955   303.094     0.150
    22.955   303.125     0.150
    23.032   310.773     0.150
    23.032   310.820     0.150
    23.986   314.500     0.150
    24.251   322.227     0.150
    37.448   434.906     0.150
    37.448   434.922     0.150
    37.731   436.422     0.150
    37.731   436.422     0.150
    52.782   557.773     0.150
    55.516   576.023     0.150
    55.516   576.023     0.150
    66.238   649.195     0.150
    66.238   649.227     0.150
    83.248   740.422     0.150
    92.246   790.547     0.150
    92.246   790.523     0.150
    95.207     7.500     0.150
   109.083  1321.320     0.150
   119.165  1131.320     0.150
   144.744  1175.625     0.150
   145.130  1177.727     0.150
     1.272    37.301     0.150
     1.272    40.391     0.150
     1.299    41.031     0.150
     2.765    45.441     0.150
     6.302    97.047     0.150
     6.302    97.041     0.150
     6.302   205.400     0.150
     7.241    98.121     0.150
     7.328   189.551     0.150
     7.574   146.521     0.150
     7.574   247.971     0.150
     8.635   216.521     0.150
     9.438   133.602     0.150
     9.819   139.381     0.150
    10.662   330.496     0.150
    10.662   152.471     0.150
    10.662   269.422     0.150
    10.662   330.502     0.150
    24.164   314.820     0.150
    37.559   435.121     0.150
    85.851   751.871     0.150
    95.025     8.301     0.150
    95.025    11.301     0.150
     0.535     9.836     0.150
     0.498     9.065     0.150
     0.541    10.176     0.150
     0.643    11.365     0.150
     0.675    11.636     0.150
     0.641    11.716     0.150
     0.799    13.565     0.150
     0.799    13.575     0.150
     0.708    13.386     0.150
     0.708    23.596     0.150
     0.708    26.596     0.150
     0.808    14.186     0.150
     1.302    41.336     0.150
     1.302    60.865     0.150
     1.378    24.405     0.150
     6.563   101.546     0.150
     6.563   214.246     0.150
     6.563   101.541     0.150
     6.563   214.246     0.150
     6.634   101.646     0.150
     6.634   112.905     0.150
     6.634   205.136     0.150
     7.061   138.056     0.150
     7.455   134.596     0.150
     7.682   138.956     0.150
     7.682   228.176     0.150
     7.776   139.285     0.150
     7.776   233.996     0.150
     7.788   234.936     0.150
     7.788   241.841     0.150
     8.084   145.285     0.150
     8.084   250.006     0.150
     8.201   116.336     0.150
     8.228   249.646     0.150
     8.388   253.655     0.150
     8.678   125.256     0.150
     8.678   159.876     0.150
     8.678   267.396     0.150
     9.583   177.195     0.150
     9.709   144.956     0.150
    10.408   149.940     0.150
    10.408   265.723     0.150
    10.408   326.433     0.150
    11.346   164.666     0.150
    11.346   358.140     0.150
    11.657   175.105     0.150
    11.835   183.825     0.150
    12.027   170.996     0.150
    13.167   188.535     0.150
    13.336   184.336     0.150
    13.587   200.726     0.150
    13.638   193.035     0.150
    14.506   216.146     0.150
    22.955   307.746     0.150
    22.955   307.740     0.150
    30.172   370.311     0.150
    30.172   551.660     0.150
    37.821   438.266     0.150
    81.416   737.740     0.150
    91.875   790.645     0.150
    92.325   790.690     0.150
     0.265     5.457     0.150
     0.265     9.258     0.150
     0.464    20.020     0.150
     0.534     9.570     0.150
     0.559     9.848     0.150
     0.632    11.367     0.150
     0.799    14.520     0.150
     0.831    14.777     0.150
     0.879    15.617     0.150
     0.901    15.828     0.150
     0.933    30.047     0.150
     0.933    17.430     0.150
     0.933    30.047     0.150
     0.984    17.617     0.150
     4.187   137.918     0.150
     6.646    99.902     0.150
     7.890   254.297     0.150
     8.232   118.824     0.150
    10.735   154.336     0.150
    10.735   271.629     0.150
    10.735   341.422     0.150
    11.702   170.234     0.150
    23.356   309.348     0.150
    30.403   373.242     0.150
    37.891   439.020     0.150
     0.046     0.922     0.150
     0.082     1.539     0.150
     0.507     9.375     0.150
     0.603    10.789     0.150
     0.716    12.312     0.150
     0.716    12.312     0.150
     0.716    22.547     0.150
     0.707    12.945     0.150
     0.707    23.047     0.150
     0.712    13.125     0.150
     0.744    13.688     0.150
     0.744    23.953     0.150
     0.779    21.773     0.150
     0.779    13.211     0.150
     0.779    23.375     0.150
     1.286    21.000     0.150
     1.342    21.852     0.150
     1.342    38.875     0.150
     1.333    23.117     0.150
     1.333    41.383     0.150
     1.333    46.703     0.150
     1.515    27.258     0.150
     1.515    24.102     0.150
     1.580    42.492     0.150
     1.580    25.219     0.150
     1.580    45.539     0.150
     1.580    25.016     0.150
     1.618    26.688     0.150
     1.618    49.938     0.150
     1.729    27.117     0.150
     1.783    28.102     0.150
     2.017    31.672     0.150
     2.140    32.445     0.150
     2.150    33.375     0.150
     2.150    64.758     0.150
     2.203    34.062     0.150
     2.425    37.156     0.150
     2.469    38.320     0.150
     2.601    39.508     0.150
     2.721    41.758     0.150
     2.825    85.461     0.150
     2.857    49.602     0.150
     2.857    86.039     0.150
     3.100    46.602     0.150
     3.166    96.734     0.150
     3.370    57.586     0.150
     3.611    53.656     0.150
     3.808    57.469     0.150
     4.031    60.164     0.150
     4.103    60.500     0.150
     4.123    70.195     0.150
     4.215    62.281     0.150
     4.533    68.195     0.150
     4.742    71.109     0.150
     4.952    73.422     0.150
     5.013    70.375     0.150
     5.013   126.953     0.150
     5.013    70.375     0.150
     5.205    75.750     0.150
     5.237    94.508     0.150
     5.237   154.195     0.150
     5.373    80.164     0.150
     5.401    77.773     0.150
     5.627    82.203     0.150
     5.689    83.164     0.150
     5.689    81.719     0.150
     5.689    81.719     0.150
     5.753    83.633     0.150
     5.842    85.141     0.150
     5.967    87.641     0.150
     5.995    88.109     0.150
     6.283    92.352     0.150
     6.343    92.266     0.150
     6.477    94.750     0.150
     6.563    92.023     0.150
     6.563   163.586     0.150
     6.563    92.023     0.150
     6.586    96.711     0.150
     6.604    96.984     0.150
     6.609    97.383     0.150
     6.871   101.820     0.150
     6.940    99.992     0.150
     7.005   101.469     0.150
     7.061   102.680     0.150
     7.150   103.891     0.150
     7.209   106.711     0.150
     7.212   105.234     0.150
     7.237   106.680     0.150
     7.378   109.258     0.150
     7.489   110.125     0.150
     7.628   110.000     0.150
     7.790   114.000     0.150
     7.795   241.148     0.150
     7.795   241.141     0.150
     7.862   115.297     0.150
     7.896   113.609     0.150
     8.094   119.250     0.150
     8.099   118.945     0.150
     8.098   118.227     0.150
     8.176   115.203     0.150
     8.278   118.938     0.150
     8.309   118.836     0.150
     8.387   120.172     0.150
     8.402   120.797     0.150
     8.404   120.891     0.150
     8.491   123.617     0.150
     8.516   123.234     0.150
     8.684   127.398     0.150
     8.697   127.805     0.150
     8.695   125.859     0.150
     8.761   127.883     0.150
     8.772   123.867     0.150
     8.830   126.648     0.150
     8.861   129.352     0.150
     8.868   127.578     0.150
     8.929   128.750     0.150
     8.941   128.781     0.150
     8.957   131.023     0.150
     8.981   129.719     0.150
     9.017   129.875     0.150
     9.042   132.188     0.150
     9.093   132.555     0.150
     9.134   132.047     0.150
     9.202   131.398     0.150
     9.335   137.359     0.150
     9.335   303.133     0.150
     9.400   137.023     0.150
     9.426   136.531     0.150
     9.445   136.344     0.150
     9.558   138.148     0.150
     9.572   137.812     0.150
     9.600   133.289     0.150
     9.677   139.422     0.150
     9.683   137.188     0.150
     9.758   140.547     0.150
     9.830   141.570     0.150
     9.861   142.289     0.150
     9.979   144.875     0.150
     9.968   140.328     0.150
     9.968   140.328     0.150
     9.979   143.758     0.150
    10.077   145.875     0.150
    10.077   144.703     0.150
    10.152   147.195     0.150
    10.436   150.062     0.150
    11.059   158.109     0.150
    11.059   354.898     0.150
    11.322   164.969     0.150
    11.322   355.992     0.150
    12.230   173.922     0.150
    12.559   177.062     0.150
    12.836   181.375     0.150
    13.137   187.836     0.150
    13.607   192.859     0.150
    13.954   201.625     0.150
    14.606   205.125     0.150
    15.934   226.812     0.150
    21.966   291.492     0.150
    25.665   332.594     0.150
    35.091   412.727     0.150
    35.849   422.664     0.150
    37.783   437.031     0.150
    38.691   441.062     0.150
    69.688  5256.805     0.150
    69.693  5257.094     0.150
    69.706  5258.109     0.150
    77.261   718.867     0.150
    80.525   731.117     0.150
    80.525   731.117     0.150
    81.390   737.039     0.150
    83.315   747.812     0.150
    83.512   748.016     0.150
    83.670   749.117     0.150
    83.671   749.414     0.150
    83.659   750.664     0.150
    83.712   750.016     0.150
    83.766   749.812     0.150
    83.773   749.312     0.150
    84.120   750.516     0.150
    84.183   753.539     0.150
    84.446   754.117     0.150
    84.611   754.719     0.150
    84.822   756.719     0.150
    85.280   757.617     0.150
    91.542   788.812     0.150
    92.288   792.078     0.150
    94.818   804.852     0.150
    95.269     6.500     0.150
   107.714   858.414     0.150
   107.714  1578.117     0.150
   109.149  1321.516     0.150
   113.084   878.812     0.150
   117.247  1128.961     0.150
   119.231  1132.664     0.150
   144.715  1177.703     0.150
   145.925  1181.617     0.150
     0.090     1.575     0.150
     0.524   937.915     0.150
     0.524     9.725     0.150
     0.611    11.045     0.150
     0.729    12.458     0.150
     0.729    12.458     0.150
     0.713    25.425     0.150
     0.713    25.745     0.150
     0.751    23.715     0.150
     0.751    13.717     0.150
     0.751    23.715     0.150
     0.793    19.765     0.150
     0.793    13.435     0.150
     0.793    24.233     0.150
     0.793    13.435     0.150
     0.793    24.233     0.150
     1.098    34.139     0.150
     1.302    36.564     0.150
     1.302    21.249     0.150
     1.302    36.564     0.150
     1.347    39.313     0.150
     1.347    22.014     0.150
     1.347    39.313     0.150
     1.316    23.075     0.150
     1.316    40.435     0.150
     1.406    27.705     0.150
     1.423    28.035     0.150
     1.530    24.284     0.150
     1.593    25.250     0.150
     1.593    45.575     0.150
     1.593    25.230     0.150
     1.593    25.230     0.150
     1.624    48.329     0.150
     1.624    48.329     0.150
     1.624    26.835     0.150
     1.624    48.329     0.150
     1.744    27.323     0.150
     1.799    28.366     0.150
     2.028    61.110     0.150
     2.028    61.110     0.150
     2.028    31.757     0.150
     2.028    61.110     0.150
     2.137    32.656     0.150
     2.210    34.138     0.150
     2.441    37.414     0.150
     2.480    38.120     0.150
     2.733    41.937     0.150
     2.831    85.381     0.150
     2.831    48.856     0.150
     2.831    85.381     0.150
     2.865    86.645     0.150
     2.865    49.924     0.150
     2.865    86.645     0.150
     3.116    46.805     0.150
     3.176    55.245     0.150
     3.382    51.121     0.150
     3.817    57.849     0.150
     4.043    60.141     0.150
     4.137    66.445     0.150
     4.137   116.115     0.150
     4.228    62.329     0.150
     4.528    68.694     0.150
     4.528    68.694     0.150
     4.543    67.780     0.150
     4.756    71.396     0.150
     4.959    73.195     0.150
     5.002    74.295     0.150
     5.002   132.145     0.150
     5.202    76.224     0.150
     5.382    80.289     0.150
     5.627    82.166     0.150
     5.691    83.347     0.150
     5.674    83.805     0.150
     5.674   148.375     0.150
     5.752    84.543     0.150
     5.840    85.738     0.150
     5.983    87.332     0.150
     5.999    88.276     0.150
     6.078    89.766     0.150
     6.291    92.089     0.150
     6.344    92.161     0.150
     6.480    94.791     0.150
     6.540   101.955     0.150
     6.559    95.515     0.150
     6.559   168.625     0.150
     6.591    96.814     0.150
     6.609    97.443     0.150
     6.618    97.556     0.150
     6.881   101.474     0.150
     7.006    99.015     0.150
     7.006   102.316     0.150
     7.064   102.472     0.150
     7.154   104.007     0.150
     7.216   104.800     0.150
     7.242   106.347     0.150
     7.389   108.997     0.150
     7.498   109.923     0.150
     7.676   111.245     0.150
     7.771   117.015     0.150
     7.801   245.975     0.150
     7.900   113.817     0.150
     8.041   117.486     0.150
     8.107   118.644     0.150
     8.107   118.644     0.150
     8.110   118.466     0.150
     8.105   117.894     0.150
     8.278   119.057     0.150
     8.310   119.229     0.150
     8.408   120.820     0.150
     8.405   120.667     0.150
     8.499   123.191     0.150
     8.542   120.495     0.150
     8.521   123.292     0.150
     8.670   121.895     0.150
     8.701   125.449     0.150
     8.741   122.145     0.150
     8.828   127.035     0.150
     8.868   128.401     0.150
     8.927   129.199     0.150
     8.943   129.411     0.150
     8.982   129.732     0.150
     9.020   129.841     0.150
     9.138   132.150     0.150
     9.218   128.555     0.150
     9.411   136.879     0.150
     9.451   136.875     0.150
     9.653   137.235     0.150
     9.699   138.095     0.150
     9.756   141.019     0.150
     9.960   144.265     0.150
     9.960   253.735     0.150
    10.431   149.950     0.150
    10.431   268.282     0.150
    10.431   330.282     0.150
    11.266   161.525     0.150
    11.338   157.565     0.150
    11.338   169.525     0.150
    11.338   169.525     0.150
    11.338   365.485     0.150
    11.338   169.525     0.150
    11.338   365.483     0.150
    11.409   159.985     0.150
    11.529   162.465     0.150
    11.627   162.245     0.150
    11.895   167.315     0.150
    12.596   179.205     0.150
    13.433   188.025     0.150
    20.900   279.515     0.150
    37.798   437.160     0.150
    81.406   737.561     0.150
     0.223     4.160     0.150
     0.223     7.781     0.150
     0.573    11.182     0.150
     0.573    18.932     0.150
     0.667    11.861     0.150
     0.693    12.311     0.150
     0.729    13.301     0.150
     0.743    13.420     0.150
     0.743    23.781     0.150
     1.124    20.031     0.150
     1.124    35.891     0.150
     1.150    20.602     0.150
     1.257    22.420     0.150
     1.257    39.842     0.150
     1.697    26.932     0.150
     1.697    51.580     0.150
     2.883   100.102     0.150
     3.092    89.801     0.150
     5.796    83.820     0.150
     6.564   192.961     0.150
     6.675    95.330     0.150
     6.675    95.332     0.150
     7.214   102.201     0.150
     7.908   242.211     0.150
     7.908   115.131     0.150
     7.908   242.205     0.150
    10.442   151.105     0.150
    10.442   328.756     0.150
    11.507   167.525     0.150
    37.932   438.230     0.150
    95.391    11.799     0.150
    95.391  1432.631     0.150
     0.078     1.773     0.150
     0.070     1.602     0.150
     0.070     1.602     0.150
     0.194     3.844     0.150
     0.306     5.328     0.150
     0.384     7.164     0.150
     0.384    12.375     0.150
     0.381    24.789     0.150
     0.788    13.625     0.150
     0.788    24.172     0.150
     0.758    29.336     0.150
     0.998    16.812     0.150
     0.998    28.828     0.150
     1.164    19.266     0.150
     1.164    19.266     0.150
     1.164    19.336     0.150
     1.164    34.383     0.150
     1.250    21.383     0.150
     1.250    37.898     0.150
     1.362    22.195     0.150
     1.294    46.039     0.150
     1.432    23.211     0.150
     1.544    24.898     0.150
     1.587    25.539     0.150
     1.599    47.242     0.150
     1.599    25.859     0.150
     1.599    47.242     0.150
     1.624    27.922     0.150
     2.232    34.594     0.150
     2.300    35.969     0.150
     2.446    37.344     0.150
     2.439    74.047     0.150
     2.454    73.930     0.150
     2.502    37.789     0.150
     2.749    82.781     0.150
     2.799    42.703     0.150
     2.950    44.875     0.150
     3.610    62.008     0.150
     3.798    56.734     0.150
     3.922    71.508     0.150
     3.921    59.414     0.150
     4.543    68.016     0.150
     4.662    70.727     0.150
     5.102    76.109     0.150
     5.418    78.555     0.150
     5.433    79.914     0.150
     5.433   142.461     0.150
     5.489    82.227     0.150
     5.919    86.133     0.150
     5.950    87.141     0.150
     6.076    88.484     0.150
     6.144    87.680     0.150
     6.144    87.680     0.150
     6.144   195.281     0.150
     6.092    90.211     0.150
     6.092   158.844     0.150
     6.211    91.242     0.150
     6.250    92.430     0.150
     6.635    96.289     0.150
     6.716    99.430     0.150
     6.731    97.773     0.150
     6.731    97.773     0.150
     6.796    99.969     0.150
     6.804    99.852     0.150
     6.937   101.602     0.150
     6.937   180.227     0.150
     7.249   105.000     0.150
     7.310   102.320     0.150
     7.332   107.922     0.150
     7.320   106.281     0.150
     7.376   107.391     0.150
     7.413   107.641     0.150
     7.435   108.891     0.150
     7.921   115.641     0.150
     7.933   114.898     0.150
     7.977   115.984     0.150
     7.977   249.336     0.150
     8.127   118.133     0.150
     8.127   118.133     0.150
     8.583   123.367     0.150
     8.591   123.078     0.150
     8.638   124.570     0.150
     8.661   124.320     0.150
     8.712   125.242     0.150
     8.814   128.008     0.150
     9.155   131.492     0.150
     9.169   132.453     0.150
     9.202   132.430     0.150
     9.264   133.664     0.150
     9.348   135.016     0.150
    10.801   155.555     0.150
    10.801   339.805     0.150
    11.171   162.180     0.150
    11.171   355.766     0.150
     0.230     4.098     0.150
     0.253     3.980     0.150
     0.253     7.578     0.150
     0.523    26.104     0.150
     0.799    14.725     0.150
     0.799    25.264     0.150
     0.862    31.014     0.150
     0.918    15.779     0.150
     0.918    15.779     0.150
     0.918    28.178     0.150
     1.011    17.361     0.150
     1.011    30.143     0.150
     1.057    18.107     0.150
     1.057    18.107     0.150
     1.057    32.637     0.150
     1.091    19.246     0.150
     1.091    33.170     0.150
     1.312    21.775     0.150
     1.385    48.193     0.150
     1.459    24.338     0.150
     1.459    44.592     0.150
     1.521    24.820     0.150
     1.569    26.654     0.150
     1.569    26.654     0.150
     1.671    29.135     0.150
     1.671    52.113     0.150
     1.672    56.844     0.150
     1.742    28.125     0.150
     1.742    49.570     0.150
     1.811    29.635     0.150
     1.811    56.105     0.150
     2.091    33.086     0.150
     2.170    65.584     0.150
     2.172    34.148     0.150
     2.282    66.225     0.150
     2.454    79.693     0.150
     2.514    39.125     0.150
     2.607    45.523     0.150
     2.607    79.137     0.150
     2.660    40.396     0.150
     2.673    41.287     0.150
     3.052    92.604     0.150
     5.447   105.934     0.150
     5.489    99.635     0.150
     5.489   172.084     0.150
     7.095   102.414     0.150
     7.095   183.535     0.150
     0.149    16.230     0.150
     0.149    17.900     0.150
     0.418    22.352     0.150
     0.418    23.900     0.150
     0.702    11.855     0.150
     0.702    21.021     0.150
     0.702    11.855     0.150
     0.702    21.021     0.150
     0.787    13.287     0.150
     0.832    29.592     0.150
     0.832    30.262     0.150
     0.861    15.283     0.150
     0.861    27.309     0.150
     1.209    19.955     0.150
     1.209    35.084     0.150
     1.285    20.834     0.150
     1.311    22.211     0.150
     1.443    23.039     0.150
     1.443    43.475     0.150
     1.649    25.871     0.150
     1.649    25.871     0.150
     1.649    25.916     0.150
     1.649    46.416     0.150
     1.757    27.568     0.150
     2.014    64.740     0.150
     2.014    30.736     0.150
     2.075    32.205     0.150
     2.075    61.297     0.150
     2.074    36.186     0.150
     2.074    61.637     0.150
     2.354    41.557     0.150
     2.404    42.795     0.150
     2.423    37.070     0.150
     2.675    43.441     0.150
     2.675    93.291     0.150
     3.216    52.480     0.150
     3.216   105.131     0.150
     3.678    57.381     0.150
     3.730   125.830     0.150
     4.100    75.551     0.150
     4.281   150.041     0.150
     4.408   145.672     0.150
     4.408    67.039     0.150
     4.656    70.240     0.150
     5.249   176.432     0.150
     5.951   110.031     0.150
     6.554   118.941     0.150
     6.554   206.740     0.150
     6.554    98.469     0.150
     6.554   118.943     0.150
     6.554   206.740     0.150
     7.081   229.191     0.150
     7.331   241.092     0.150
     7.585   237.320     0.150
     7.663   148.230     0.150
     7.663   236.561     0.150
     7.674   138.752     0.150
     7.844   253.240     0.150
     8.004   121.611     0.150
     8.304   216.951     0.150
     8.333   123.717     0.150
     8.333   264.592     0.150
    10.312   144.551     0.150
    10.312   144.547     0.150
    10.312   324.723     0.150
    37.811   436.740     0.150
     0.084     3.336     0.150
     0.084     5.227     0.150
     0.453     8.281     0.150
     0.638    11.586     0.150
     0.708    10.859     0.150
     0.708    12.164     0.150
     0.688    11.500     0.150
     0.688    20.578     0.150
     0.688    20.578     0.150
     0.688    11.891     0.150
     0.688    20.578     0.150
     0.752    14.031     0.150
     0.784    14.273     0.150
     0.784    24.211     0.150
     0.784    24.211     0.150
     0.784    14.273     0.150
     0.784    24.211     0.150
     0.806    15.047     0.150
     1.118    32.516     0.150
     1.118    32.516     0.150
     1.238    46.070     0.150
     1.238    46.250     0.150
     1.259    21.297     0.150
     1.260    38.648     0.150
     1.260    38.648     0.150
     1.260    38.648     0.150
     1.260    20.477     0.150
     1.260    38.648     0.150
     1.426    43.391     0.150
     1.426    43.391     0.150
     1.426    22.703     0.150
     1.426    43.391     0.150
     1.465    25.680     0.150
     1.570    24.461     0.150
     1.570    24.625     0.150
     1.570    24.625     0.150
     1.570    29.617     0.150
     1.662    26.602     0.150
     1.661    47.891     0.150
     1.661    47.891     0.150
     1.661    27.133     0.150
     1.661    47.891     0.150
     1.712    26.844     0.150
     2.030    31.578     0.150
     2.060    62.414     0.150
     2.060    62.414     0.150
     2.060    32.070     0.150
     2.060    62.414     0.150
     2.113    64.750     0.150
     2.113    64.750     0.150
     2.113    32.656     0.150
     2.113    64.750     0.150
     2.089    31.461     0.150
     2.313    36.070     0.150
     2.367    34.211     0.150
     2.367    36.320     0.150
     2.371    36.641     0.150
     2.375    37.047     0.150
     2.560    38.914     0.150
     2.724    41.680     0.150
     2.849    43.336     0.150
     2.862    84.148     0.150
     2.862    84.148     0.150
     2.862    84.148     0.150
     2.862    42.922     0.150
     2.862    84.148     0.150
     2.870    86.797     0.150
     2.870    86.797     0.150
     2.870    43.539     0.150
     2.870    86.797     0.150
     2.865    85.547     0.150
     2.865    85.547     0.150
     2.884    43.125     0.150
     2.975    44.938     0.150
     3.045    45.891     0.150
     3.147    47.648     0.150
     3.147    47.664     0.150
     3.147    47.664     0.150
     3.179    47.594     0.150
     3.364    50.328     0.150
     3.561    52.719     0.150
     3.634    52.953     0.150
     3.649    54.438     0.150
     3.662    54.352     0.150
     3.716   114.359     0.150
     3.716   114.359     0.150
     3.716    55.914     0.150
     3.716   114.359     0.150
     3.745    54.320     0.150
     4.033    59.875     0.150
     4.072    60.312     0.150
     4.204    61.938     0.150
     4.204    61.859     0.150
     4.204    61.859     0.150
     4.242    62.531     0.150
     4.262    62.781     0.150
     4.422    66.250     0.150
     4.550    67.266     0.150
     4.577    68.391     0.150
     4.577    68.188     0.150
     4.641    68.836     0.150
     4.672    68.648     0.150
     4.650    69.586     0.150
     4.878    72.227     0.150
     4.905    72.062     0.150
     4.862    72.055     0.150
     4.969    74.078     0.150
     5.230    76.844     0.150
     5.151    74.961     0.150
     5.281    78.031     0.150
     5.527    81.641     0.150
     5.857    87.141     0.150
     5.787    84.797     0.150
     5.902    86.062     0.150
     5.970    87.539     0.150
     6.273    91.203     0.150
     6.311    91.812     0.150
     6.486    95.266     0.150
     6.711   102.312     0.150
     6.963   107.148     0.150
     6.874    99.180     0.150
     7.005   102.141     0.150
     6.985   101.312     0.150
     7.130   103.508     0.150
     7.283   107.164     0.150
     7.453   109.359     0.150
     7.557   109.062     0.150
     7.598   109.992     0.150
     7.665   112.500     0.150
     7.699   111.922     0.150
     7.708   242.062     0.150
     7.826   130.336     0.150
     7.826   130.328     0.150
     7.815   112.562     0.150
     7.829   113.039     0.150
     7.975   117.742     0.150
     7.975   115.680     0.150
     7.998   121.922     0.150
     7.940   115.680     0.150
     8.011   116.312     0.150
     8.137   119.867     0.150
     8.178   118.555     0.150
     8.287   120.266     0.150
     8.212   117.781     0.150
     8.237   117.984     0.150
     8.324   119.586     0.150
     8.327   119.469     0.150
     8.325   118.977     0.150
     8.400   121.125     0.150
     8.567   126.930     0.150
     8.609   124.773     0.150
     8.666   126.062     0.150
     8.768   125.891     0.150
     8.828   127.742     0.150
     8.868   128.383     0.150
     8.866   127.812     0.150
     8.873   127.586     0.150
     8.910   128.328     0.150
     8.937   128.828     0.150
     9.051   130.828     0.150
     9.141   126.195     0.150
     9.305   134.930     0.150
     9.360   135.711     0.150
     9.359   134.555     0.150
     9.409   136.125     0.150
     9.362   135.227     0.150
     9.520   138.117     0.150
     9.447   136.805     0.150
     9.513   137.492     0.150
     9.483   136.758     0.150
     9.550   135.719     0.150
     9.571   137.883     0.150
     9.615   138.633     0.150
     9.655   139.273     0.150
     9.696   139.641     0.150
     9.701   139.195     0.150
     9.755   140.492     0.150
     9.748   139.969     0.150
     9.808   140.992     0.150
     9.884   142.906     0.150
     9.936   148.078     0.150
     9.885   142.344     0.150
     9.964   143.148     0.150
     9.964   253.586     0.150
     9.982   144.016     0.150
    10.035   150.039     0.150
    10.035   150.070     0.150
     9.930   143.039     0.150
    10.278   153.398     0.150
    10.339   152.047     0.150
    10.388   149.391     0.150
    10.388   149.391     0.150
    10.388   326.617     0.150
    10.677   156.328     0.150
    11.034   162.797     0.150
    11.120   158.938     0.150
    11.170   159.508     0.150
    11.219   157.367     0.150
    11.235   161.836     0.150
    11.430   159.828     0.150
    11.788   163.000     0.150
    11.843   168.875     0.150
    12.052   173.070     0.150
    12.140   172.930     0.150
    12.243   174.680     0.150
    12.696   182.383     0.150
    13.298   191.000     0.150
    13.426   194.562     0.150
    13.576   195.891     0.150
    13.671   193.562     0.150
    13.886   196.828     0.150
    14.317   204.555     0.150
    14.575   205.680     0.150
    14.766   377.422     0.150
    14.812   378.492     0.150
    15.159   218.039     0.150
    15.718   400.062     0.150
    15.871   225.102     0.150
    16.764   237.508     0.150
    17.445   247.008     0.150
    17.879   249.336     0.150
    18.163   252.688     0.150
    19.291   264.273     0.150
    19.412   267.352     0.150
    20.812   281.289     0.150
    21.207   286.562     0.150
    21.604   290.078     0.150
    21.715   296.516     0.150
    21.853   293.891     0.150
    22.274   300.180     0.150
    22.845   302.180     0.150
    22.889   304.172     0.150
    23.127   311.727     0.150
    23.696   315.883     0.150
    24.168   316.039     0.150
    24.152   316.867     0.150
    26.185   339.836     0.150
    26.185   339.852     0.150
    26.611   343.938     0.150
    26.611   343.898     0.150
    26.805   348.141     0.150
    26.805   348.102     0.150
    28.243   360.336     0.150
    28.243   360.367     0.150
    28.205   357.906     0.150
    28.341   354.297     0.150
    28.341     5.211     0.150
    28.849   365.039     0.150
    28.849   365.062     0.150
    29.922   368.602     0.150
    30.070   420.742     0.150
    30.070   369.391     0.150
    30.070   420.727     0.150
    30.070   369.383     0.150
    30.070   420.734     0.150
    30.507   375.289     0.150
    30.507   375.289     0.150
    32.432   395.328     0.150
    32.810   399.117     0.150
    33.404   404.141     0.150
    33.404   404.148     0.150
    33.405   403.617     0.150
    33.693   405.461     0.150
    33.877   408.297     0.150
    34.226   409.742     0.150
    34.901   415.898     0.150
    35.556   419.211     0.150
    36.043   424.070     0.150
    36.281   414.438     0.150
    36.281   414.461     0.150
    36.447   427.250     0.150
    37.718   437.812     0.150
    37.744   437.438     0.150
    40.500   463.289     0.150
    40.500   463.289     0.150
    43.497   484.211     0.150
    47.003   518.961     0.150
    47.381   519.789     0.150
    50.690   544.242     0.150
    52.706   559.141     0.150
    55.429   575.219     0.150
    56.606   591.336     0.150
    56.661   591.641     0.150
    57.416   594.508     0.150
    58.387  1086.141     0.150
    59.098   608.836     0.150
    59.495   611.438     0.150
    59.625   610.438     0.150
    59.633   612.539     0.150
    59.643   612.641     0.150
    59.643  1102.836     0.150
    59.705   612.836     0.150
    60.179   612.539     0.150
    60.179   612.539     0.150
    60.879   617.938     0.150
    60.879   612.742     0.150
    60.879   617.938     0.150
    62.622   630.336     0.150
    62.712   626.039     0.150
    62.712   626.039     0.150
    63.142   628.461     0.150
    63.142   628.461     0.150
    64.407  1162.836     0.150
    64.434   639.617     0.150
    66.158   653.641     0.150
    66.158   653.648     0.150
    70.382   680.062     0.150
    74.361   702.742     0.150
    74.361   698.289     0.150
    74.361   698.289     0.150
    74.447  1272.539     0.150
    77.173   719.836     0.150
    77.173   719.836     0.150
    77.173   714.320     0.150
    77.173   714.312     0.150
    77.528   712.742     0.150
    77.528   729.336     0.150
    77.597   722.438     0.150
    77.597   722.477     0.150
    77.648   718.141     0.150
    77.970  1612.539     0.150
    77.970  1817.141     0.150
    79.540   725.641     0.150
    79.540   725.641     0.150
    79.540   725.641     0.150
    79.692   733.836     0.150
    80.054   736.641     0.150
    80.054   736.633     0.150
    80.330   737.938     0.150
    80.330   737.961     0.150
    80.330   737.086     0.150
    80.470   730.742     0.150
    80.470   730.742     0.150
    80.470   730.742     0.150
    80.731   740.039     0.150
    80.796   733.336     0.150
    81.265   735.242     0.150
    81.306   736.945     0.150
    81.322   743.336     0.150
    81.814   744.039     0.150
    81.923   739.336     0.150
    81.923   739.336     0.150
    81.951   762.438     0.150
    81.970   738.938     0.150
    81.970   738.938     0.150
    82.017   762.641     0.150
    82.084   746.297     0.150
    82.165   739.242     0.150
    82.165   739.242     0.150
    82.188   740.242     0.150
    82.188   740.242     0.150
    82.188   740.242     0.150
    82.233   739.242     0.150
    82.400   751.672     0.150
    82.404   764.438     0.150
    82.901   767.242     0.150
    82.985   745.695     0.150
    82.985   745.703     0.150
    82.985   751.898     0.150
    83.117   753.148     0.150
    83.117   755.141     0.150
    83.117   768.641     0.150
    83.117   755.180     0.150
    83.381   746.242     0.150
    83.381   746.242     0.150
    83.418   746.336     0.150
    83.418   746.336     0.150
    83.485   770.539     0.150
    83.572   747.141     0.150
    83.572   747.141     0.150
    83.576   747.242     0.150
    83.576   747.242     0.150
    83.577   747.242     0.150
    83.577   747.242     0.150
    83.618   747.539     0.150
    83.618   747.539     0.150
    83.673   747.938     0.150
    83.673   747.938     0.150
    83.679   747.438     0.150
    83.679   747.438     0.150
    83.679   747.438     0.150
    83.692   747.742     0.150
    83.692   747.742     0.150
    83.681   755.836     0.150
    83.681   755.789     0.150
    83.681   754.562     0.150
    84.026   749.336     0.150
    84.026   749.336     0.150
    84.062   773.141     0.150
    84.089   753.367     0.150
    84.089   753.367     0.150
    84.131   754.508     0.150
    84.353   751.242     0.150
    84.353   751.242     0.150
    84.434   774.836     0.150
    84.518   752.039     0.150
    84.518   752.039     0.150
    84.548   775.539     0.150
    84.729   752.836     0.150
    84.729   752.836     0.150
    84.729   752.836     0.150
    84.993    19.297     0.150
    84.993   757.539     0.150
    84.993   769.539     0.150
    84.993   776.836     0.150
    84.993   957.539     0.150
    84.993  1386.539     0.150
    84.993  1928.539     0.150
    84.993  2102.539     0.150
    85.108   756.789     0.150
    85.076   759.797     0.150
    85.186   755.641     0.150
    85.186   755.641     0.150
    85.186   755.641     0.150
    85.337    19.305     0.150
    85.357   756.141     0.150
    85.357   756.141     0.150
    85.410    19.406     0.150
    85.429    19.195     0.150
    85.428    19.297     0.150
    85.486    19.500     0.150
    85.557   765.336     0.150
    85.557   773.742     0.150
    85.557   765.336     0.150
    85.557  1394.742     0.150
    85.593    19.203     0.150
    85.712   766.070     0.150
    85.712   783.195     0.150
    85.712  1399.539     0.150
    85.712  1707.539     0.150
    85.712   766.039     0.150
    85.712    19.398     0.150
    85.798    19.297     0.150
    86.234   768.242     0.150
    86.234   768.242     0.150
    86.307   767.492     0.150
    86.632   766.539     0.150
    86.632  1405.242     0.150
    86.685   770.242     0.150
    86.685   770.219     0.150
    86.710   769.609     0.150
    86.843   771.836     0.150
    86.843   771.836     0.150
    86.869   770.938     0.150
    86.869   770.938     0.150
    86.869  1407.336     0.150
    87.074   770.539     0.150
    87.090   767.938     0.150
    87.090  1408.336     0.150
    87.090   768.797     0.150
    87.138   769.039     0.150
    87.138   767.227     0.150
    87.138   767.227     0.150
    87.145   770.344     0.150
    87.216   771.391     0.150
    87.735   765.539     0.150
    89.555   785.039     0.150
    89.555   785.336     0.150
    89.769   782.742     0.150
    90.271   784.336     0.150
    90.554   784.242     0.150
    91.013   790.836     0.150
    91.013   999.641     0.150
    91.013  1804.539     0.150
    91.323  1511.742     0.150
    91.323  1811.242     0.150
    91.454   786.961     0.150
    91.454   786.953     0.150
    91.455   788.039     0.150
    91.455   789.750     0.150
    91.530   790.820     0.150
    91.805   790.000     0.150
    91.805  1010.680     0.150
    91.805   790.000     0.150
    91.805  1010.680     0.150
    92.235  1015.438     0.150
    92.235   792.141     0.150
    92.235  1015.422     0.150
    92.235   792.141     0.150
    92.235  1015.414     0.150
    92.968   792.438     0.150
    93.615  1845.539     0.150
    94.351   808.242     0.150
    94.542  1446.539     0.150
    94.542   803.539     0.150
    94.542  1472.539     0.150
    94.542  1546.539     0.150
    94.578   809.836     0.150
    95.250   806.039     0.150
    95.250  1441.336     0.150
    96.308   813.938     0.150
    96.308   813.977     0.150
    99.193   816.039     0.150
    99.193  1458.938     0.150
    99.566   824.812     0.150
    99.566  1073.039     0.150
    99.566   827.242     0.150
    99.566  1073.070     0.150
    99.566  1073.062     0.150
    99.566  1810.266     0.150
    99.587   828.336     0.150
   100.942  1082.141     0.150
   100.942  2167.242     0.150
   101.472  1949.336     0.150
   101.728   826.039     0.150
   102.607  1098.641     0.150
   102.607  1800.938     0.150
   104.599  1113.000     0.150
   104.599  1113.000     0.150
   104.599  1797.812     0.150
   109.139  1324.039     0.150
   117.321  1130.141     0.150
   117.321  1130.141     0.150
   119.308  1134.242     0.150
   119.308  1134.188     0.150
   119.308  1134.188     0.150
   119.452  1130.859     0.150
   119.750  1137.648     0.150
   119.750  1132.039     0.150
   122.279  1140.898     0.150
   125.143   929.539     0.150
   125.143  1824.539     0.150
   125.143  2270.539     0.150
   127.464  1150.367     0.150
   142.647  1175.961     0.150
   144.781  1177.258     0.150
   144.781  1177.227     0.150
   144.991  1177.695     0.150
     0.494    17.922     0.150
     0.494    27.695     0.150
     0.494     8.555     0.150
     0.494    16.211     0.150
     0.463     8.445     0.150
     0.569     9.328     0.150
     0.622    10.992     0.150
     0.741    13.359     0.150
     0.829    28.648     0.150
     0.829    14.922     0.150
     1.017    49.906     0.150
     1.247    20.602     0.150
     1.537    51.875     0.150
     1.537    24.648     0.150
     1.537    27.297     0.150
     1.537    51.875     0.150
     2.102    29.992     0.150
     2.590    43.477     0.150
     3.108    50.719     0.150
     3.750    58.070     0.150
     4.013    62.320     0.150
     4.169    64.992     0.150
     4.396    68.289     0.150
     5.279    81.102     0.150
     5.489    84.016     0.150
     6.403    88.070     0.150
     6.447    93.352     0.150
     6.447   216.719     0.150
     6.447    93.352     0.150
     6.447   216.719     0.150
     6.486   102.102     0.150
     7.259   109.859     0.150
     7.697   115.180     0.150
     7.697   249.031     0.150
     7.697   115.172     0.150
     7.697   147.477     0.150
     7.697   249.023     0.150
     7.826   104.758     0.150
     8.246   150.398     0.150
     8.246   255.227     0.150
     8.246   123.648     0.150
     8.246   150.398     0.150
     8.246   255.227     0.150
    10.402   149.797     0.150
    10.402   328.039     0.150
    11.198   167.352     0.150
    11.198   365.180     0.150
    11.198   167.352     0.150
    11.198   216.297     0.150
    11.198   365.180     0.150
    37.704   436.203     0.150
     0.731    21.260     0.150
     0.919    38.998     0.150
     1.356    23.918     0.150
     1.356    40.027     0.150
     1.357    55.318     0.150
     1.622    55.287     0.150
     1.622    25.238     0.150
     1.622    55.287     0.150
     1.622    25.248     0.150
     2.686    37.168     0.150
     3.103    51.688     0.150
     3.734   110.510     0.150
     4.110    57.488     0.150
     4.959    74.137     0.150
     4.959   129.887     0.150
     5.366    75.848     0.150
     5.958    83.828     0.150
     6.544   100.268     0.150
     6.544   100.264     0.150
     7.027   106.027     0.150
     7.106   106.297     0.150
     7.414   109.627     0.150
     7.715   115.887     0.150
     7.715   116.680     0.150
     7.715   246.838     0.150
     8.355   117.957     0.150
     8.734   133.838     0.150
     9.571   134.398     0.150
    10.359   149.225     0.150
    10.359   325.975     0.150
    10.527   156.197     0.150
    10.707   159.938     0.150
    11.281   171.658     0.150
    11.281   367.678     0.150
    11.281   171.654     0.150
    11.281   215.723     0.150
    11.281   367.680     0.150
    15.928   229.037     0.150
    16.493   239.607     0.150
    37.801   437.957     0.150
    95.305   797.887     0.150
    95.305    12.102     0.150
    95.305  1030.287     0.150
   102.696   849.287     0.150
     1.249    22.469     0.150
     1.249    39.070     0.150
     1.275    45.590     0.150
     1.333    43.969     0.150
     1.643    26.117     0.150
     2.785    45.480     0.150
     3.818    59.332     0.150
     4.207    65.621     0.150
     4.410    68.211     0.150
     5.692    86.000     0.150
     6.601   224.172     0.150
     7.217   106.961     0.150
     7.832   121.105     0.150
    16.017   223.191     0.150
    16.017   233.180     0.150
    37.859   434.680     0.150
     0.142     2.818     0.150
     0.856    14.430     0.150
     1.248    22.498     0.150
     1.248    38.898     0.150
     1.249    43.268     0.150
     1.643    31.703     0.150
     1.643    26.035     0.150
     1.642    49.066     0.150
     4.962    74.738     0.150
     4.962   131.389     0.150
     5.483    79.328     0.150
     6.546    95.979     0.150
     6.546   169.729     0.150
     6.601   101.082     0.150
     6.601   216.125     0.150
     7.063   137.889     0.150
     7.088   142.158     0.150
     7.831   141.779     0.150
     7.831   114.029     0.150
     7.831   141.779     0.150
     7.831   145.078     0.150
     7.831   244.059     0.150
     8.439   263.451     0.150
     8.439   125.859     0.150
     8.439   163.889     0.150
     8.439   263.449     0.150
    10.421   321.814     0.150
    11.402   367.393     0.150
     0.073     0.723     0.150
     0.073     1.434     0.150
     0.366    12.832     0.150
     0.719    11.465     0.150
     0.719    11.465     0.150
     0.735    10.863     0.150
     1.237    39.414     0.150
     1.317    23.863     0.150
     1.317    41.043     0.150
     1.318    23.512     0.150
     1.333    21.484     0.150
     1.387    22.191     0.150
     1.387    21.484     0.150
     1.609    25.465     0.150
     1.800    30.547     0.150
     4.363   115.934     0.150
     4.514    68.191     0.150
     4.514   142.715     0.150
     5.661    91.242     0.150
     7.018   139.922     0.150
     7.780   253.387     0.150
     7.780   111.242     0.150
     7.780   253.395     0.150
    11.331   168.535     0.150
    11.331   372.188     0.150
    37.808   434.750     0.150
    95.297     7.500     0.150
    95.297  1430.613     0.150
    95.297  1867.914     0.150
     0.643     3.719     0.150
     0.643    13.422     0.150
     0.734     4.688     0.150
     0.734    15.023     0.150
     0.734    16.781     0.150
     0.734    18.258     0.150
     1.121    12.039     0.150
     1.121    28.008     0.150
     1.232    22.414     0.150
     1.232    39.102     0.150
     1.232    44.297     0.150
     1.642    49.352     0.150
     1.819    30.164     0.150
     1.883    56.016     0.150
     2.137    70.008     0.150
     2.245    70.297     0.150
     4.421    70.797     0.150
     4.834    72.164     0.150
     5.709    84.180     0.150
     7.538   101.602     0.150
     7.756   110.562     0.150
     8.156   124.508     0.150
     8.825   133.664     0.150
    11.420   369.352     0.150
    13.708   201.750     0.150
    15.565   225.352     0.150
    18.225   257.172     0.150
    18.277   249.484     0.150
    55.614   579.594     0.150
     0.148     2.656     0.150
     0.222     9.703     0.150
     0.222     4.773     0.150
     0.284     4.820     0.150
     0.305     9.070     0.150
     0.524     9.641     0.150
     0.611    11.109     0.150
     0.650    11.773     0.150
     0.698    12.406     0.150
     0.822    21.406     0.150
     0.822    61.258     0.150
     0.876    14.773     0.150
     0.876    15.422     0.150
     0.876    28.633     0.150
     1.228    22.359     0.150
     1.228    39.656     0.150
     1.228    22.531     0.150
     1.262    13.562     0.150
     1.657    48.703     0.150
     1.657    48.688     0.150
     1.657    26.531     0.150
     2.408    37.398     0.150
     2.545    38.945     0.150
     2.696    41.102     0.150
     3.025    46.602     0.150
     3.201    47.961     0.150
     3.275    49.812     0.150
     3.698   104.000     0.150
     3.822    56.812     0.150
     3.874    56.844     0.150
     4.098    60.547     0.150
     4.292    64.172     0.150
     4.292   146.906     0.150
     4.427    65.820     0.150
     4.598    67.820     0.150
     4.734    71.852     0.150
     4.837    72.008     0.150
     4.953    75.047     0.150
     4.953   133.344     0.150
     5.009    73.867     0.150
     5.602    84.359     0.150
     5.602   148.859     0.150
     5.713    85.398     0.150
     6.003    90.383     0.150
     6.071    89.750     0.150
     6.360    93.070     0.150
     6.545    97.109     0.150
     6.771   101.547     0.150
     7.102   105.312     0.150
     7.151   103.703     0.150
     7.456   109.109     0.150
     7.843   250.727     0.150
     7.853   116.531     0.150
     7.890   116.281     0.150
     7.890   203.344     0.150
     8.100   122.750     0.150
     8.160   122.359     0.150
     8.292   124.992     0.150
     8.459   123.625     0.150
     8.533   207.617     0.150
     8.755   130.953     0.150
     9.249   304.922     0.150
     9.704   143.227     0.150
     9.786   256.359     0.150
     9.924   144.047     0.150
     9.988   139.680     0.150
    10.420   333.391     0.150
    11.144   163.922     0.150
    11.144   286.539     0.150
    11.977   177.633     0.150
    12.658   343.602     0.150
    12.662   182.742     0.150
    13.334   193.398     0.150
    13.332   196.344     0.150
    13.609   190.102     0.150
    13.609   190.102     0.150
    14.162   203.406     0.150
    14.188   381.773     0.150
    14.723   212.109     0.150
    15.168   216.547     0.150
    15.717   224.008     0.150
    16.037  5817.500     0.150
    16.086   225.602     0.150
    17.035   240.031     0.150
    17.602   253.148     0.150
    17.812   254.039     0.150
    18.493   258.445     0.150
    18.672   260.273     0.150
    19.077   271.281     0.150
    19.236   272.633     0.150
    19.236   272.633     0.150
    19.780   267.438     0.150
    19.833   277.711     0.150
    20.365   279.023     0.150
    21.032   290.406     0.150
    21.238   292.508     0.150
    21.716   292.523     0.150
    22.189   300.969     0.150
    22.606   309.273     0.150
    22.606   309.273     0.150
    22.927  7942.500     0.150
    23.560   315.242     0.150
    23.860   320.953     0.150
    23.860   320.953     0.150
    25.386   332.719     0.150
    26.351   344.227     0.150
    26.351   344.227     0.150
    28.977   359.773     0.150
    28.977   654.180     0.150
    29.439   362.781     0.150
    30.243  2288.492     0.150
    32.875   402.703     0.150
    32.875   735.797     0.150
    35.531   415.227     0.150
    35.705   417.961     0.150
    35.705   752.477     0.150
    35.876   424.250     0.150
    35.876   759.312     0.150
    37.395   441.031     0.150
    37.395   792.969     0.150
    37.447   441.617     0.150
    38.540   450.703     0.150
    39.386   447.797     0.150
    39.386   447.797     0.150
    39.417   448.680     0.150
    40.546   459.367     0.150
    43.677   484.102     0.150
    43.677   484.141     0.150
    43.677   872.797     0.150
    46.449   500.523     0.150
    47.147   511.531     0.150
    47.278   522.500     0.150
    48.055   517.430     0.150
    50.817   997.000     0.150
    50.817   542.898     0.150
    50.817   997.000     0.150
    50.877   539.203     0.150
    50.877   539.219     0.150
    50.877   960.430     0.150
    51.099   997.703     0.150
    51.099   547.703     0.150
    51.099   997.703     0.150
    52.095   548.898     0.150
    52.095   988.117     0.150
    55.617  1060.797     0.150
    55.617   578.898     0.150
    55.617  1060.797     0.150
    56.136  1066.898     0.150
    57.351   587.703     0.150
    57.351   587.680     0.150
    58.200   603.898     0.150
    58.200  1081.797     0.150
    58.915   609.297     0.150
    59.313   611.898     0.150
    59.450   612.898     0.150
    59.461   613.203     0.150
    59.461  1098.602     0.150
    59.523   613.297     0.150
    60.365   610.000     0.150
    60.365  1120.898     0.150
    62.698   631.297     0.150
    62.698   773.398     0.150
    62.698   623.609     0.150
    62.949   625.703     0.150
    62.949   625.656     0.150
    64.223   644.898     0.150
    64.960  1195.500     0.150
    64.960  1595.500     0.150
    65.028   639.672     0.150
    65.028  1142.141     0.150
    66.106   648.328     0.150
    68.552   678.000     0.150
    69.333   685.297     0.150
    70.315   671.656     0.150
    70.890   674.250     0.150
    72.259   679.602     0.150
    72.564   692.898     0.150
    72.564   711.703     0.150
    72.564   956.398     0.150
    72.564  1258.898     0.150
    72.564  1538.602     0.150
    72.564   685.586     0.150
    73.093   696.828     0.150
    73.677  1281.500     0.150
    74.090   692.102     0.150
    74.090  1278.797     0.150
    74.215   695.633     0.150
    74.518  1281.500     0.150
    74.518   697.188     0.150
    74.648   700.898     0.150
    75.297   702.992     0.150
    76.077  1279.211     0.150
    76.779   719.188     0.150
    76.824   717.898     0.150
    77.361   718.203     0.150
    77.361   718.203     0.150
    77.712  1345.500     0.150
    77.736  1373.797     0.150
    77.785   716.102     0.150
    77.785   716.094     0.150
    78.054  1006.000     0.150
    79.411   727.398     0.150
    79.411   727.398     0.150
    79.529   735.797     0.150
    79.585   735.703     0.150
    79.722   729.203     0.150
    79.722   729.203     0.150
    79.842   729.703     0.150
    79.842   729.703     0.150
    79.880   735.102     0.150
    80.274  1371.500     0.150
    80.613   734.297     0.150
    80.613   734.297     0.150
    80.652   734.602     0.150
    80.652   734.602     0.150
    80.843   732.609     0.150
    80.905   735.797     0.150
    80.905   735.797     0.150
    80.983   737.602     0.150
    81.451   740.602     0.150
    81.496  1380.000     0.150
    81.568   741.703     0.150
    81.568  1353.203     0.150
    81.620  1380.102     0.150
    81.620   736.383     0.150
    81.703   745.297     0.150
    81.879   743.898     0.150
    81.986   745.500     0.150
    82.108   742.398     0.150
    82.108   742.398     0.150
    82.151   742.398     0.150
    82.151   742.398     0.150
    82.373   743.797     0.150
    82.373   743.797     0.150
    82.403   748.102     0.150
    82.669   747.398     0.150
    82.669  1364.797     0.150
    82.696   747.297     0.150
    82.696  1365.797     0.150
    83.035   744.703     0.150
    83.035   744.742     0.150
    83.072   749.703     0.150
    83.179   748.000     0.150
    83.302   746.000     0.150
    83.302   750.297     0.150
    83.302   745.969     0.150
    83.388   750.000     0.150
    83.388     2.797     0.150
    83.566   749.898     0.150
    83.577   746.500     0.150
    83.577   746.469     0.150
    83.600   749.898     0.150
    83.600   749.898     0.150
    83.690   750.703     0.150
    83.690   750.703     0.150
    83.754   750.703     0.150
    83.754   750.703     0.150
    83.756   751.102     0.150
    83.756   751.102     0.150
    83.760   750.797     0.150
    83.760   750.898     0.150
    83.760   750.898     0.150
    83.802   751.203     0.150
    83.802   751.203     0.150
    83.857   751.703     0.150
    83.862   751.000     0.150
    83.862   751.000     0.150
    83.873   751.398     0.150
    83.873   751.398     0.150
    84.104   750.680     0.150
    84.104  1365.211     0.150
    84.209   752.797     0.150
    84.209   752.797     0.150
    84.209  5817.500     0.150
    84.270   754.102     0.150
    84.270   754.102     0.150
    84.414   754.000     0.150
    84.414   754.000     0.150
    84.537   754.797     0.150
    84.537   754.797     0.150
    84.622   752.672     0.150
    84.694   755.703     0.150
    84.694   755.703     0.150
    84.703   755.602     0.150
    84.703   755.602     0.150
    84.783   754.000     0.150
    84.783   754.031     0.150
    84.914   756.500     0.150
    84.914   756.500     0.150
    85.180   759.500     0.150
    85.180   780.703     0.150
    85.180  1407.500     0.150
    85.180  1407.500     0.150
    85.180  1471.500     0.150
    85.180  1739.500     0.150
    85.180  1931.500     0.150
    85.212   756.078     0.150
    85.261   756.602     0.150
    85.261   756.578     0.150
    85.352   756.797     0.150
    85.352  1378.031     0.150
    85.365   761.000     0.150
    85.370   759.203     0.150
    85.370   759.203     0.150
    85.489   757.273     0.150
    85.537   759.898     0.150
    85.537   759.898     0.150
    85.606   759.000     0.150
    85.606  1391.000     0.150
    85.799   774.203     0.150
    85.844   761.297     0.150
    85.844   761.297     0.150
    85.899   794.227     0.150
    85.899  1411.500     0.150
    85.899  1741.500     0.150
    85.899   762.797     0.150
    85.899   766.703     0.150
    85.899  1393.500     0.150
    85.938   762.102     0.150
    86.175   766.398     0.150
    86.175  1745.398     0.150
    86.421   764.898     0.150
    86.421   768.500     0.150
    86.429   763.898     0.150
    86.429   763.898     0.150
    86.451   764.703     0.150
    86.451   764.703     0.150
    86.474   765.203     0.150
    86.474   765.203     0.150
    86.712   766.898     0.150
    86.712   766.961     0.150
    86.746   764.188     0.150
    86.819   766.797     0.150
    86.873  1408.602     0.150
    86.873  1431.102     0.150
    86.873   763.867     0.150
    86.885  1420.102     0.150
    86.885  1439.297     0.150
    86.917   766.703     0.150
    87.019   767.000     0.150
    87.019   767.000     0.150
    87.030   768.000     0.150
    87.056   767.703     0.150
    87.056  1415.500     0.150
    87.056   764.633     0.150
    87.262   765.500     0.150
    87.278  1416.102     0.150
    87.278   769.398     0.150
    87.278  1416.102     0.150
    87.324   770.398     0.150
    87.746   775.203     0.150
    87.765   769.898     0.150
    87.765   769.898     0.150
    87.823   775.102     0.150
    87.823  1413.703     0.150
    87.823  1439.898     0.150
    87.850   770.398     0.150
    87.850   770.398     0.150
    87.923   771.500     0.150
    87.923  1098.500     0.150
    87.964   772.000     0.150
    87.964   772.000     0.150
    88.197   774.000     0.150
    88.218   773.703     0.150
    88.242   779.180     0.150
    88.363   779.492     0.150
    88.413   774.398     0.150
    88.413  1421.703     0.150
    88.510   780.031     0.150
    88.755   779.398     0.150
    88.755  1443.797     0.150
    88.824   780.891     0.150
    89.000   992.797     0.150
    89.001   778.352     0.150
    89.337   997.500     0.150
    89.337  1521.797     0.150
    89.549   785.133     0.150
    89.593  1459.203     0.150
    89.677   785.500     0.150
    89.677   776.992     0.150
    89.684   777.422     0.150
    89.702   778.797     0.150
    89.702   778.797     0.150
    89.714   777.641     0.150
    89.714   988.398     0.150
    89.753   780.398     0.150
    89.810  1456.820     0.150
    89.957   782.703     0.150
    89.957   786.797     0.150
    90.329   783.797     0.150
    90.329  1456.703     0.150
    90.329   783.703     0.150
    90.329   780.773     0.150
    90.420   784.297     0.150
    90.420   788.797     0.150
    90.459   784.898     0.150
    90.459  1457.398     0.150
    90.549   789.289     0.150
    90.549  1459.758     0.150
    90.640   785.898     0.150
    90.640   789.398     0.150
    90.742   786.297     0.150
    90.742  1822.898     0.150
    90.997   788.297     0.150
    90.997  1543.500     0.150
    91.188  1820.797     0.150
    91.484   788.500     0.150
    91.484   791.797     0.150
    91.499  1542.797     0.150
    91.499  1553.398     0.150
    91.499   785.242     0.150
    91.499   995.641     0.150
    91.642   789.078     0.150
    91.643   786.602     0.150
    91.643   786.602     0.150
    91.643  1447.078     0.150
    91.649   788.000     0.150
    91.649  1445.453     0.150
    92.063   788.883     0.150
    92.211  1830.898     0.150
    92.243   793.500     0.150
    92.671   794.398     0.150
    92.931   796.500     0.150
    93.079   796.500     0.150
    93.198   796.703     0.150
    93.198   796.703     0.150
    93.495   803.203     0.150
    93.707  1014.000     0.150
    93.707  1452.703     0.150
    93.707  1832.602     0.150
    93.727   796.180     0.150
    93.727  1010.492     0.150
    93.849   799.797     0.150
    93.882   806.898     0.150
    94.128   804.602     0.150
    94.145   807.602     0.150
    94.209   803.500     0.150
    94.537   809.602     0.150
    94.701   806.797     0.150
    94.730  1153.500     0.150
    94.730  1592.500     0.150
    94.730   806.500     0.150
    94.730  1031.500     0.150
    94.730  1062.500     0.150
    94.730  1153.500     0.150
    94.730  1455.500     0.150
    94.730  1479.500     0.150
    94.730  1509.500     0.150
    94.730  1592.500     0.150
    94.730  1890.500     0.150
    94.754   805.297     0.150
    94.757   800.898     0.150
    94.949   805.203     0.150
    94.965   805.000     0.150
    94.994   805.797     0.150
    95.351   811.398     0.150
    95.351  1043.602     0.150
    95.351  1445.297     0.150
    95.351  1873.500     0.150
    95.533   810.203     0.150
    95.880   812.203     0.150
    95.880   812.203     0.150
    96.065   809.703     0.150
    96.261   811.203     0.150
    96.334   814.000     0.150
    96.334   809.398     0.150
    96.423   815.203     0.150
    96.423   815.203     0.150
    96.467   808.500     0.150
    96.467  1040.703     0.150
    96.467   816.281     0.150
    96.467   808.492     0.150
    96.467  1040.648     0.150
    96.541   811.797     0.150
    96.888   817.297     0.150
    96.888   817.297     0.150
    97.022   814.203     0.150
    97.022   814.203     0.150
    97.108   818.898     0.150
    97.125   816.898     0.150
    97.165   815.203     0.150
    97.355   817.203     0.150
    97.355   817.203     0.150
    97.371   817.500     0.150
    97.380   816.297     0.150
    97.380   816.297     0.150
    97.380   818.797     0.150
    97.367   819.703     0.150
    97.557   814.500     0.150
    97.557   814.500     0.150
    97.585   817.898     0.150
    97.585   817.898     0.150
    97.635   818.898     0.150
    97.695   819.203     0.150
    97.695   819.203     0.150
    97.713   818.703     0.150
    97.713   818.703     0.150
    97.802   823.398     0.150
    97.802   822.602     0.150
    97.802   822.602     0.150
    97.802   823.500     0.150
    97.802   823.398     0.150
    97.844   820.398     0.150
    97.844   820.398     0.150
    97.855   820.898     0.150
    97.855   820.898     0.150
    97.930   817.398     0.150
    98.071   821.898     0.150
    98.071   821.898     0.150
    98.201   820.898     0.150
    98.229   822.203     0.150
    98.264   824.398     0.150
    98.264   824.398     0.150
    98.264   824.398     0.150
    98.267   824.398     0.150
    98.267  1194.500     0.150
    98.297   823.898     0.150
    98.304   821.703     0.150
    98.391   822.297     0.150
    98.500   823.898     0.150
    98.527   821.203     0.150
    98.527   821.203     0.150
    98.730   822.602     0.150
    98.734   824.297     0.150
    98.734   824.297     0.150
    98.762   822.203     0.150
    98.762   822.203     0.150
    98.881   822.500     0.150
    98.881   822.500     0.150
    98.916   827.297     0.150
    98.916   827.297     0.150
    98.916   827.297     0.150
    98.983   825.000     0.150
    99.046   826.898     0.150
    99.046   826.898     0.150
    99.064   824.602     0.150
    99.268   828.398     0.150
    99.268   828.398     0.150
    99.268   828.102     0.150
    99.308   828.797     0.150
    99.308   828.797     0.150
    99.381  1466.297     0.150
    99.381  2148.203     0.150
    99.399   827.297     0.150
    99.446   826.000     0.150
    99.485   827.102     0.150
    99.595   829.203     0.150
    99.770   826.898     0.150
    99.956   830.102     0.150
    99.956   830.102     0.150
    99.984   829.602     0.150
   100.192   828.602     0.150
   100.248   829.297     0.150
   100.257   828.797     0.150
   100.336   831.602     0.150
   100.365   832.297     0.150
   100.402   829.602     0.150
   100.402   829.602     0.150
   101.037   834.398     0.150
   101.129   835.500     0.150
   101.299   830.953     0.150
   101.303   824.102     0.150
   101.303   824.062     0.150
   101.418   838.000     0.150
   101.418   844.203     0.150
   101.418  1477.500     0.150
   101.418  1534.500     0.150
   101.521   836.797     0.150
   101.521   840.156     0.150
   101.521   831.531     0.150
   101.591   838.297     0.150
   101.591  1550.703     0.150
   101.591  1959.500     0.150
   101.901   835.000     0.150
   102.013   840.000     0.150
   102.371   843.570     0.150
   102.371   835.383     0.150
   102.544   844.445     0.150
   102.569   842.500     0.150
   102.569   842.500     0.150
   102.747   844.703     0.150
   102.747   849.500     0.150
   102.747  1545.602     0.150
   102.747  1554.703     0.150
   102.747  1974.297     0.150
   102.795   840.477     0.150
   102.908   844.602     0.150
   103.297   843.898     0.150
   103.330   840.703     0.150
   103.330   840.703     0.150
   103.493  1108.398     0.150
   103.493  1236.602     0.150
   103.903   846.602     0.150
   104.511   852.320     0.150
   104.512   844.359     0.150
   104.713   853.500     0.150
   104.713  1115.500     0.150
   104.806   845.797     0.150
   104.920   846.156     0.150
   104.920  1812.500     0.150
   104.972   847.078     0.150
   105.637   857.203     0.150
   105.637   857.203     0.150
   107.816   867.500     0.150
   107.816  1595.797     0.150
   113.148   887.797     0.150
   113.148  1172.000     0.150
   113.148  2126.398     0.150
   117.211  1123.789     0.150
   119.202  1749.602     0.150
   119.542  1128.539     0.150
   122.107  1137.516     0.150
   124.956  2284.500     0.150
   125.974  1148.547     0.150
   127.278  1989.008     0.150
   127.332  1153.516     0.150
   127.332  1148.930     0.150
   128.845  2004.227     0.150
   128.846   977.500     0.150
   128.846  1597.500     0.150
   128.846  1727.500     0.150
   128.968  1160.102     0.150
   129.479  1993.711     0.150
   132.048  2026.930     0.150
     7.227  1159.500     0.150
     7.227  1159.500     0.150
     7.227  1159.500     0.150
   137.823  1163.672     0.150
   139.643  1170.414     0.150
   139.643  1167.523     0.150
   139.643  1170.422     0.150
   140.538  1166.102     0.150
   142.773  1173.367     0.150
   145.072  1181.492     0.150
   145.926  1182.484     0.150
   146.631  1187.242     0.150
   147.598  1187.922     0.150
   147.991  1191.297     0.150
   151.220  1187.242     0.150
   162.442  1460.500     0.150
   162.754  1407.500     0.150
   168.103  1196.500     0.150
   168.103  1522.500     0.150
   168.103  1920.500     0.150
     0.880    16.812     0.150
     0.880    16.812     0.150
     1.122    31.664     0.150
     1.071    22.180     0.150
     1.071    34.516     0.150
     0.953    23.328     0.150
     1.252    24.445     0.150
     1.252    42.336     0.150
     1.252    43.234     0.150
     1.473    25.242     0.150
     1.818    34.531     0.150
     1.923    29.227     0.150
     1.923    57.227     0.150
     1.923    29.188     0.150
     1.923    57.250     0.150
     2.064    33.852     0.150
     2.064    31.914     0.150
     2.171    36.609     0.150
     2.375    38.195     0.150
     2.306    42.406     0.150
     2.492    40.992     0.150
     2.676    43.969     0.150
     2.826    44.961     0.150
     3.090    47.156     0.150
     3.028    51.938     0.150
     3.096    53.211     0.150
     3.254    52.203     0.150
     3.254    99.344     0.150
     3.299    64.656     0.150
     3.445    58.719     0.150
     3.559    55.023     0.150
     4.480   127.812     0.150
     4.708    67.125     0.150
     4.708    67.102     0.150
     4.775    69.992     0.150
     5.559    81.367     0.150
     6.339    93.969     0.150
     6.359    92.102     0.150
     7.911   115.062     0.150
     8.745   126.891     0.150
    10.310   151.430     0.150
    29.028   357.625     0.150
    29.028   357.578     0.150
    29.534   359.344     0.150
    30.358   373.516     0.150
    36.510   425.883     0.150
    38.532   444.328     0.150
    43.003   480.578     0.150
    53.853   555.523     0.150
    55.867   577.523     0.150
    55.867   577.531     0.150
    77.313   720.109     0.150
    77.897   717.352     0.150
    79.912   730.523     0.150
    79.912   730.523     0.150
    80.848   735.828     0.150
    80.848   735.828     0.150
    81.102   737.023     0.150
    81.102   737.023     0.150
    82.316   743.625     0.150
    82.316   743.625     0.150
    82.343   743.625     0.150
    82.343   743.625     0.150
    82.485   744.523     0.150
    82.583   745.023     0.150
    82.583   745.023     0.150
    83.252   748.586     0.150
    83.771   751.328     0.150
    83.794   750.922     0.150
    83.794   750.922     0.150
    83.951   751.727     0.150
    83.951   751.727     0.150
    83.959   752.023     0.150
    83.959   752.023     0.150
    83.965   752.125     0.150
    84.002   752.422     0.150
    84.002   752.422     0.150
    84.059   752.328     0.150
    84.059   752.328     0.150
    84.064   752.828     0.150
    84.064   752.625     0.150
    84.064   752.625     0.150
    84.407   754.023     0.150
    84.407   754.023     0.150
    84.605   755.328     0.150
    84.605   755.328     0.150
    84.744   756.125     0.150
    84.744   756.125     0.150
    84.912   756.828     0.150
    84.912   756.828     0.150
    85.120   757.828     0.150
    85.120   757.828     0.150
    85.572   760.125     0.150
    85.572   760.125     0.150
    89.237   778.852     0.150
     0.672    13.289     0.150
     0.805    13.656     0.150
     0.928    27.703     0.150
     0.928    15.844     0.150
     0.928    27.750     0.150
     1.149    20.555     0.150
     1.149    20.555     0.150
     1.149    37.117     0.150
     1.149    22.547     0.150
     1.149    42.898     0.150
     1.246    21.375     0.150
     1.341    19.805     0.150
     1.490    25.234     0.150
     1.670    28.641     0.150
     1.758    28.547     0.150
     1.780    27.305     0.150
     1.780    53.109     0.150
     1.780    25.203     0.150
     1.780    27.289     0.150
     1.780    53.148     0.150
     1.938    32.867     0.150
     2.198    64.891     0.150
     2.239    36.250     0.150
     2.300    73.617     0.150
     2.531    79.992     0.150
     2.630    42.195     0.150
     2.911    43.891     0.150
     2.970    44.547     0.150
     3.147    93.609     0.150
     3.147    50.258     0.150
     3.147    93.625     0.150
     3.197    95.086     0.150
     3.392    56.305     0.150
     3.392    56.297     0.150
     3.745    60.508     0.150
     3.745    60.508     0.150
     3.820    64.156     0.150
     3.820   111.750     0.150
     3.862    58.469     0.150
     4.221   130.070     0.150
     4.415    69.203     0.150
     4.415    69.180     0.150
     4.545    73.008     0.150
     4.545    73.008     0.150
     4.839    76.609     0.150
     4.839    76.625     0.150
     4.877    72.953     0.150
     4.982    74.188     0.150
     5.212    78.383     0.150
     5.571    85.086     0.150
     5.782    90.609     0.150
     5.782    90.625     0.150
     6.114    94.805     0.150
     6.114    94.766     0.150
     6.167    94.875     0.150
     6.894   105.805     0.150
     6.894   105.789     0.150
     7.224   107.508     0.150
     7.200   104.797     0.150
     7.461   109.594     0.150
     7.488   108.086     0.150
     7.803   116.703     0.150
     7.803   253.680     0.150
     7.896   115.984     0.150
     8.049   116.297     0.150
     8.231   123.328     0.150
     8.398   123.508     0.150
     8.360   123.133     0.150
     8.552   126.453     0.150
     8.814   131.609     0.150
     9.128   301.828     0.150
     9.601   138.836     0.150
     9.779   146.406     0.150
     9.779   146.383     0.150
    10.320   150.289     0.150
    10.320   330.531     0.150
    10.597   155.680     0.150
    10.866   158.547     0.150
    11.265   164.086     0.150
    11.479   164.203     0.150
    12.973   182.336     0.150
    13.275   191.969     0.150
    13.685   198.055     0.150
    13.947   199.180     0.150
    14.793   211.859     0.150
    15.413   221.438     0.150
    16.136   229.523     0.150
    16.322   954.250     0.150
    16.745   236.258     0.150
    18.217   253.758     0.150
    21.077   285.898     0.150
    21.311   287.805     0.150
    21.657   291.617     0.150
    22.423   299.477     0.150
    22.961   306.047     0.150
    23.064   305.953     0.150
    23.064   305.953     0.150
    24.257   318.000     0.150
    24.324   319.227     0.150
    24.416   319.469     0.150
    26.253   336.984     0.150
    26.656   340.844     0.150
    37.963   439.898     0.150
    38.364   443.789     0.150
    43.758   487.609     0.150
    46.878   511.805     0.150
    50.922   542.883     0.150
    53.657   560.906     0.150
    55.674   577.719     0.150
    55.674   577.609     0.150
    56.256   590.406     0.150
    56.256   648.906     0.150
    60.433   609.203     0.150
    61.523   619.406     0.150
    64.296   638.805     0.150
    65.105   642.945     0.150
    74.213   704.305     0.150
    74.641   703.805     0.150
    77.413   716.609     0.150
    79.432   728.406     0.150
    79.432   728.406     0.150
    79.742   730.109     0.150
    79.742   730.109     0.150
    79.863   730.406     0.150
    79.863   730.406     0.150
    79.934   730.289     0.150
    80.637   735.109     0.150
    80.637   735.109     0.150
    80.675   735.609     0.150
    80.675   735.609     0.150
    80.929   736.805     0.150
    80.929   736.805     0.150
    81.520   740.203     0.150
    81.556   739.180     0.150
    81.556   742.406     0.150
    82.138   744.008     0.150
    82.138   744.008     0.150
    82.172   743.508     0.150
    82.172   743.508     0.150
    82.334   745.305     0.150
    82.404   744.703     0.150
    82.404   744.703     0.150
    82.402   747.609     0.150
    83.156   749.398     0.150
    83.455   749.430     0.150
    83.594   751.109     0.150
    83.622   751.008     0.150
    83.622   751.008     0.150
    83.708   751.805     0.150
    83.708   751.805     0.150
    83.769   751.805     0.150
    83.769   751.805     0.150
    83.778   751.805     0.150
    83.778   751.805     0.150
    83.785   752.008     0.150
    83.785   752.008     0.150
    83.788   751.906     0.150
    83.827   752.305     0.150
    83.827   752.305     0.150
    83.887   752.805     0.150
    83.886   752.203     0.150
    83.886   752.203     0.150
    83.893   752.508     0.150
    83.893   752.508     0.150
    84.234   753.906     0.150
    84.234   753.906     0.150
    84.284   755.805     0.150
    84.284   755.805     0.150
    84.434   755.109     0.150
    84.434   755.109     0.150
    84.566   755.805     0.150
    84.566   755.805     0.150
    84.709   756.805     0.150
    84.709   756.805     0.150
    84.733   756.805     0.150
    84.733   756.805     0.150
    84.943   757.609     0.150
    84.943   757.609     0.150
    85.220   759.406     0.150
    85.396   760.203     0.150
    85.396   760.203     0.150
    85.554   760.906     0.150
    85.554   760.906     0.150
    85.866   762.109     0.150
    85.866   762.109     0.150
    85.939   764.906     0.150
    85.958   763.109     0.150
    86.461   765.203     0.150
    86.477   765.805     0.150
    86.477   765.805     0.150
    86.499   766.008     0.150
    86.499   766.008     0.150
    86.859   767.008     0.150
    86.926   767.656     0.150
    86.939   767.906     0.150
    87.072   767.203     0.150
    87.094   768.609     0.150
    87.320   768.906     0.150
    87.362   768.688     0.150
    87.788   771.109     0.150
    87.788   771.109     0.150
    89.796   783.008     0.150
    90.003   784.906     0.150
    91.587  1809.109     0.150
    91.698   790.008     0.150
    91.698  1006.555     0.150
    91.699   789.406     0.150
    92.045  1288.617     0.150
    95.041   805.875     0.150
    96.571  1051.906     0.150
    96.571   813.625     0.150
    96.571  1051.906     0.150
   101.531   839.406     0.150
   109.347   870.203     0.150
   109.347  1146.609     0.150
   109.347  1327.805     0.150
   109.347  2065.109     0.150
   139.650  1176.609     0.150
   142.725  1174.680     0.150
   144.993  1178.766     0.150
     0.856    24.797     0.150
     0.932    15.586     0.150
     0.932    15.562     0.150
     0.932    28.422     0.150
     1.163    21.523     0.150
     1.163    36.844     0.150
     1.164    42.031     0.150
     1.169    44.180     0.150
     1.238    12.781     0.150
     1.238    28.805     0.150
     1.529    24.516     0.150
     1.715    27.172     0.150
     1.715    53.789     0.150
     2.467    41.562     0.150
     3.022    46.844     0.150
     3.073    54.055     0.150
     3.073    95.266     0.150
     3.339    55.031     0.150
     3.339    57.078     0.150
     3.339    55.023     0.150
     3.819    58.430     0.150
     3.819    97.336     0.150
     3.819    58.414     0.150
     3.819    97.305     0.150
     3.745   106.109     0.150
     4.349    69.836     0.150
     4.349    69.844     0.150
     4.800    76.930     0.150
     4.800    76.930     0.150
     5.215    78.375     0.150
     5.775    86.242     0.150
     6.068    92.531     0.150
     6.068    92.562     0.150
     6.682   101.953     0.150
     6.821   104.125     0.150
     7.160   107.625     0.150
     7.497   110.781     0.150
     7.862   250.055     0.150
     7.908   116.062     0.150
     8.161   123.625     0.150
     8.223   123.883     0.150
     8.358   124.516     0.150
     8.435   121.234     0.150
     8.525   271.633     0.150
     8.525   125.750     0.150
     8.815   129.562     0.150
     8.874   128.539     0.150
     9.767   143.102     0.150
    10.195   151.914     0.150
    10.399   150.164     0.150
    10.553   154.477     0.150
    10.649   153.406     0.150
    10.898   157.906     0.150
    11.205   164.383     0.150
    11.482   361.578     0.150
    13.351   191.172     0.150
    13.673   198.695     0.150
    14.013   198.109     0.150
    14.812   208.750     0.150
    15.366   220.266     0.150
    16.103   228.984     0.150
    16.294   239.727     0.150
    16.822   234.680     0.150
    18.284   254.086     0.150
    21.054   284.453     0.150
    21.369   287.945     0.150
    21.725   292.227     0.150
    22.049   300.281     0.150
    22.469   299.344     0.150
    23.025   305.109     0.150
    23.083   306.086     0.150
    23.083   306.086     0.150
    24.383   318.516     0.150
    24.415   319.023     0.150
    26.318  2370.633     0.150
    26.318   336.203     0.150
    26.725   339.930     0.150
    28.994   360.242     0.150
    30.169   370.234     0.150
    30.169   370.273     0.150
    33.592   400.609     0.150
    35.492   420.602     0.150
    35.735   419.945     0.150
    35.903   419.883     0.150
    36.629   428.031     0.150
    37.908   438.844     0.150
    38.311   442.477     0.150
    43.742   486.445     0.150
    46.957   517.930     0.150
    50.878   542.234     0.150
    55.676   576.836     0.150
    60.427   609.836     0.150
    74.139   703.430     0.150
    74.570   703.734     0.150
    78.108  1622.633     0.150
    79.769   729.234     0.150
    79.769   729.234     0.150
    80.014   729.109     0.150
    80.662   734.336     0.150
    80.662   734.336     0.150
    80.700   734.336     0.150
    80.700   734.336     0.150
    80.953   735.633     0.150
    80.953   735.633     0.150
    81.513   738.836     0.150
    81.554   738.281     0.150
    82.159   742.336     0.150
    82.159   742.336     0.150
    82.198   742.430     0.150
    82.198   742.430     0.150
    82.373   743.734     0.150
    82.424   743.734     0.150
    82.424   743.734     0.150
    83.081   747.922     0.150
    83.518   748.672     0.150
    83.616   750.031     0.150
    83.648   749.836     0.150
    83.648   749.836     0.150
    83.736   750.734     0.150
    83.736   750.734     0.150
    83.803   750.531     0.150
    83.803   750.531     0.150
    83.809   750.930     0.150
    83.809   750.930     0.150
    83.810   750.734     0.150
    83.851   751.133     0.150
    83.851   751.133     0.150
    83.908   751.633     0.150
    83.910   750.930     0.150
    83.910   750.930     0.150
    83.920   751.234     0.150
    83.920   751.234     0.150
    84.258   752.734     0.150
    84.258   752.734     0.150
    84.315   754.031     0.150
    84.315   754.031     0.150
    84.461   754.031     0.150
    84.461   754.031     0.150
    84.588   754.734     0.150
    84.588   754.734     0.150
    84.739   755.633     0.150
    84.739   755.633     0.150
    84.754   755.531     0.150
    84.754   755.531     0.150
    84.964   756.531     0.150
    84.964   756.531     0.150
    85.234   757.633     0.150
    85.234   761.633     0.150
    85.419   758.930     0.150
    85.419   758.930     0.150
    85.583   760.133     0.150
    85.583   760.133     0.150
    85.892   761.234     0.150
    85.892   761.234     0.150
    85.953   762.430     0.150
    85.985   762.133     0.150
    86.477   763.930     0.150
    86.477   763.930     0.150
    86.500   764.734     0.150
    86.500   764.734     0.150
    86.523   764.930     0.150
    86.523   764.930     0.150
    87.333   763.930     0.150
    87.333   763.945     0.150
    87.378   767.211     0.150
    89.747   780.484     0.150
    89.808   780.734     0.150
    90.013   780.336     0.150
    90.475   783.133     0.150
    90.695   783.234     0.150
    91.538   786.234     0.150
    91.565  1009.836     0.150
    91.701   787.906     0.150
    92.727   793.133     0.150
    92.988   794.336     0.150
    93.253   794.734     0.150
    94.757   801.836     0.150
    95.022   806.234     0.150
    95.051   805.734     0.150
    95.409   807.336     0.150
    96.122   808.031     0.150
    96.533   810.516     0.150
    96.843   810.633     0.150
   101.483   840.633     0.150
   102.806   841.234     0.150
   102.806   846.031     0.150
   102.806   848.336     0.150
   107.146  1130.430     0.150
   109.279   869.633     0.150
   109.279  1112.430     0.150
   109.279  1146.031     0.150
   109.279  1327.234     0.150
   109.279  2062.836     0.150
   142.788  1174.734     0.150
   142.788  1174.703     0.150
   145.068  1177.594     0.150
   145.915  1179.586     0.150
     0.624    11.422     0.150
     0.588    11.367     0.150
     0.641    11.875     0.150
     0.754    13.438     0.150
     0.903    15.516     0.150
     1.075    29.172     0.150
     1.075    43.906     0.150
     1.075    47.867     0.150
     1.075    50.945     0.150
     1.205    32.047     0.150
     1.205    48.211     0.150
     1.230    22.430     0.150
     1.230    39.148     0.150
     1.260    32.742     0.150
     1.260    50.016     0.150
     2.204    35.172     0.150
     2.363    35.648     0.150
     3.893    55.391     0.150
     5.492    80.930     0.150
     6.586   102.148     0.150
     8.452   127.000     0.150
    10.491   153.148     0.150
    52.707   553.945     0.150
    79.880   729.695     0.150
    80.650   734.195     0.150
    80.941   735.695     0.150
    82.189   742.398     0.150
    82.406   743.797     0.150
    83.600   749.898     0.150
    83.637   749.695     0.150
    83.791   750.500     0.150
    83.795   750.695     0.150
    83.796   750.797     0.150
    83.797   751.195     0.150
    83.837   751.102     0.150
    83.891   751.695     0.150
    83.898   750.898     0.150
    83.912   751.297     0.150
    84.245   752.695     0.150
    84.311   754.102     0.150
    84.453   753.898     0.150
    84.571   754.695     0.150
    84.736   755.602     0.150
    84.947   756.500     0.150
    85.405   759.000     0.150
    86.465   763.602     0.150
    86.487   764.398     0.150
    86.509   765.000     0.150
     0.261     4.320     0.150
     0.312     7.570     0.150
     0.361     5.703     0.150
     0.392     6.703     0.150
     0.468    -1.164     0.150
     0.468     5.164     0.150
     0.555     8.703     0.150
     0.515    11.336     0.150
     0.515    18.875     0.150
     0.590     2.555     0.150
     0.590    10.773     0.150
     0.882    25.703     0.150
     0.936    17.750     0.150
     0.936    32.797     0.150
     0.936    32.914     0.150
     1.090    11.594     0.150
     1.090    26.594     0.150
     1.230    34.109     0.150
     1.164    12.766     0.150
     1.197    13.070     0.150
     1.197    29.703     0.150
     1.401    23.250     0.150
     1.401    41.953     0.150
     1.401    41.953     0.150
     1.378    25.414     0.150
     1.378    25.414     0.150
     1.378    41.266     0.150
     1.379    25.133     0.150
     1.379    48.625     0.150
     1.557    25.883     0.150
     6.394    99.172     0.150
     6.394   213.102     0.150
     6.576    96.375     0.150
     7.997   259.852     0.150
     8.307   127.680     0.150
    11.365   369.031     0.150
    38.188   438.180     0.150
    47.265   511.891     0.150
    79.432   725.906     0.150
    80.627   733.000     0.150
    80.669   733.203     0.150
    80.919   734.500     0.150
    82.108   740.906     0.150
    82.173   741.305     0.150
    82.372   742.500     0.150
    83.569   748.703     0.150
    83.618   748.602     0.150
    83.716   749.602     0.150
    83.765   749.500     0.150
    83.770   749.305     0.150
    83.772   749.703     0.150
    83.793   750.203     0.150
    83.812   750.000     0.150
    83.859   750.406     0.150
    83.875   749.703     0.150
    83.896   750.203     0.150
    84.222   751.500     0.150
    84.306   753.102     0.150
    84.437   752.805     0.150
    84.540   753.500     0.150
    84.702   754.305     0.150
    84.915   755.305     0.150
    85.378   757.805     0.150
    85.565   758.703     0.150
    85.861   760.000     0.150
    86.443   762.703     0.150
    86.443   762.703     0.150
    86.461   763.500     0.150
    86.484   763.602     0.150
    87.032   765.805     0.150
     0.925    16.376     0.150
     1.034    17.966     0.150
     1.034    17.966     0.150
     0.964    19.026     0.150
     0.964    17.676     0.150
     0.964    18.996     0.150
     0.964    36.556     0.150
     1.082    18.526     0.150
     1.123    19.986     0.150
     1.123    14.050     0.150
     1.123    26.772     0.150
     1.123    19.976     0.150
     1.123    32.966     0.150
     1.195    18.116     0.150
     1.353    19.916     0.150
     1.353    35.359     0.150
     1.434    43.656     0.150
     1.434    43.686     0.150
     1.434    49.156     0.150
     1.856    27.190     0.150
     1.888    30.808     0.150
     2.057    32.686     0.150
     2.057    32.211     0.150
     2.215    32.121     0.150
     2.261    34.265     0.150
     2.474    36.568     0.150
     2.463    39.029     0.150
     2.623    39.237     0.150
     3.413    60.396     0.150
     3.622    49.286     0.150
     3.622    49.286     0.150
     3.666    65.876     0.150
     4.084    68.676     0.150
     4.561   131.016     0.150
     4.570    69.696     0.150
     4.691    75.386     0.150
     4.691    75.426     0.150
     5.098    80.586     0.150
     5.098    80.606     0.150
     5.384    80.336     0.150
     5.980    88.946     0.150
     6.247    92.716     0.150
     6.380    98.886     0.150
     6.380    98.876     0.150
     6.412    96.556     0.150
     7.007   107.936     0.150
     7.162   110.686     0.150
     7.162   110.726     0.150
     7.501   113.686     0.150
     7.501   113.696     0.150
     7.768   248.011     0.150
     7.768   114.996     0.150
     7.768   248.006     0.150
     8.043   118.636     0.150
     8.432   125.446     0.150
     8.658   130.226     0.150
     8.790   128.596     0.150
     8.989   133.216     0.150
     9.494   136.606     0.150
     9.987   146.346     0.150
    10.128   146.666     0.150
    10.862   159.206     0.150
    10.944   159.136     0.150
    11.335   170.206     0.150
    11.542   170.086     0.150
    11.649   366.229     0.150
    13.119   188.086     0.150
    13.892   201.266     0.150
    13.871   197.846     0.150
    14.495   224.876     0.150
    14.914   210.326     0.150
    15.683   224.286     0.150
    16.384   232.296     0.150
    16.591   228.786     0.150
    16.591   420.246     0.150
    16.592   232.886     0.150
    16.722   237.766     0.150
    18.133   252.646     0.150
    21.306   287.016     0.150
    21.572   290.336     0.150
    22.445   300.976     0.150
    22.896   305.736     0.150
    23.186   308.086     0.150
    23.186   308.086     0.150
    23.835   313.216     0.150
    24.282   318.336     0.150
    24.595   320.096     0.150
    26.182   828.436     0.150
    26.182   335.046     0.150
    28.877   359.946     0.150
    30.332   372.406     0.150
    33.555   401.356     0.150
    34.024   405.746     0.150
    35.691   419.216     0.150
    35.841   421.536     0.150
    36.330   426.826     0.150
    36.564   427.396     0.150
    36.962   431.706     0.150
    38.238   442.586     0.150
    38.637   445.616     0.150
    39.156     0.210     0.150
    43.974   487.976     0.150
    51.067   543.586     0.150
    55.845   578.836     0.150
    56.532   645.686     0.150
    60.624   610.286     0.150
    65.314   644.686     0.150
    74.919   700.886     0.150
    77.572   717.486     0.150
    79.525   726.986     0.150
    79.525   726.986     0.150
    79.702   727.816     0.150
    79.833   729.086     0.150
    79.833   729.086     0.150
    79.957   729.686     0.150
    79.957   729.686     0.150
    80.737   733.986     0.150
    80.737   733.986     0.150
    80.773   734.386     0.150
    80.773   734.386     0.150
    81.029   735.486     0.150
    81.029   735.486     0.150
    81.230   734.986     0.150
    81.712   737.986     0.150
    81.738   740.336     0.150
    82.251   742.286     0.150
    82.251   742.286     0.150
    82.264   742.086     0.150
    82.264   742.086     0.150
    82.519   743.886     0.150
    82.519   743.886     0.150
    83.177   747.356     0.150
    83.417   748.616     0.150
    83.704   749.886     0.150
    83.718   749.686     0.150
    83.718   749.686     0.150
    83.797   750.586     0.150
    83.797   750.586     0.150
    83.847   750.686     0.150
    83.847   750.686     0.150
    83.876   750.386     0.150
    83.876   750.386     0.150
    83.886   750.686     0.150
    83.886   750.686     0.150
    83.897   750.686     0.150
    83.930   750.986     0.150
    83.930   750.986     0.150
    83.986   750.786     0.150
    83.986   750.786     0.150
    83.985   751.186     0.150
    83.985   751.186     0.150
    83.998   751.586     0.150
    84.334   752.586     0.150
    84.334   752.586     0.150
    84.526   753.786     0.150
    84.526   753.786     0.150
    84.677   754.686     0.150
    84.677   754.686     0.150
    84.790   755.586     0.150
    84.790   755.586     0.150
    84.847   755.486     0.150
    84.847   755.486     0.150
    85.054   756.386     0.150
    85.054   756.386     0.150
    85.355   760.086     0.150
    85.408   757.466     0.150
    85.502   758.986     0.150
    85.502   758.986     0.150
    85.640   759.386     0.150
    85.640   759.386     0.150
    85.963   761.186     0.150
    85.963   761.186     0.150
    86.051   761.586     0.150
    86.074   763.886     0.150
    86.580   764.586     0.150
    86.580   764.586     0.150
    86.596   765.986     0.150
    86.603   765.086     0.150
    86.603   765.086     0.150
    86.885   767.086     0.150
    86.993   765.986     0.150
    87.034   766.086     0.150
    87.145   766.786     0.150
    87.145   766.786     0.150
    87.210   768.386     0.150
    87.223   767.486     0.150
    87.458   768.986     0.150
    87.490   769.586     0.150
    87.490   769.536     0.150
    87.884   769.786     0.150
    87.884   769.786     0.150
    87.920   769.786     0.150
    87.968   770.186     0.150
    87.968   770.186     0.150
    88.087   771.786     0.150
    88.087   771.786     0.150
    88.597   774.086     0.150
    89.935   781.586     0.150
    90.149   782.186     0.150
    90.527   784.286     0.150
    90.606   784.586     0.150
    90.650   785.586     0.150
    90.822   784.116     0.150
    90.936   785.586     0.150
    91.865   788.986     0.150
    91.866   788.606     0.150
    94.106   793.786     0.150
    95.750   812.586     0.150
    95.750     9.500     0.150
    95.750  1447.086     0.150
    95.750  1879.986     0.150
    98.483   824.686     0.150
   101.799   843.086     0.150
   107.488   862.586     0.150
   107.488  1133.186     0.150
   108.177   872.286     0.150
   109.622   871.586     0.150
   109.622  1113.086     0.150
   109.622  1147.886     0.150
   109.622  1328.586     0.150
   109.622  2068.486     0.150
   144.277  1175.876     0.150
   144.855  1177.686     0.150
   145.674  1180.036     0.150
     0.178     8.393     0.150
     0.727    12.177     0.150
     1.091    19.513     0.150
     1.264    22.313     0.150
     1.570    46.572     0.150
     1.585    25.157     0.150
     3.948    67.695     0.150
     4.205   124.847     0.150
    10.494   323.630     0.150
    11.409   168.556     0.150
    37.813   439.683     0.150
     0.910    16.247     0.150
     1.045    18.917     0.150
     1.246    22.127     0.150
     1.246    39.817     0.150
     1.573    24.232     0.150
     1.573    44.727     0.150
     2.789    44.527     0.150
     3.596    61.927     0.150
     3.933   117.147     0.150
     4.658    72.437     0.150
     5.718    83.197     0.150
     5.718   185.637     0.150
     5.951    80.637     0.150
     5.951   193.258     0.150
     6.469   210.857     0.150
     7.018   206.877     0.150
    10.535   337.298     0.150
     0.975    16.001     0.150
     0.975    16.011     0.150
     0.975    27.451     0.150
     1.105    35.851     0.150
     1.224    21.151     0.150
     1.224    38.871     0.150
     1.332    24.721     0.150
     1.750    50.955     0.150
     1.797    27.000     0.150
     1.797    27.026     0.150
     1.797    49.470     0.150
     1.797    27.021     0.150
     1.797    55.451     0.150
     2.595    38.713     0.150
     2.921    43.746     0.150
     3.153    55.661     0.150
     3.153    96.411     0.150
     3.418    58.301     0.150
     3.418    58.281     0.150
     3.775    57.031     0.150
     3.775    98.371     0.150
     3.825   112.831     0.150
     4.431    71.000     0.150
     4.431    70.971     0.150
     4.431   115.750     0.150
     4.532   110.261     0.150
     4.657    70.201     0.150
     4.827    71.071     0.150
     4.874    76.601     0.150
     4.874    76.621     0.150
     5.259    78.451     0.150
     5.466   152.931     0.150
     5.459    81.131     0.150
     5.828    86.701     0.150
     6.145    94.000     0.150
     6.145    93.980     0.150
     6.902   106.101     0.150
     6.902   106.071     0.150
     7.242   113.000     0.150
     7.242   112.960     0.150
     7.945   116.750     0.150
     8.277   124.901     0.150
     8.277   124.901     0.150
     8.432   126.901     0.150
     8.432   126.851     0.150
     8.592   114.500     0.150
     8.592   114.531     0.150
     8.592   213.500     0.150
     8.861   130.471     0.150
     8.882   127.611     0.150
     9.633   139.861     0.150
     9.824   140.111     0.150
    10.338   149.351     0.150
    10.914   158.081     0.150
    13.300   190.601     0.150
    13.729   202.101     0.150
    13.729   202.111     0.150
    13.984   196.321     0.150
    14.842   208.491     0.150
    15.444   220.781     0.150
    16.174   228.931     0.150
    16.771   235.681     0.150
    18.253   252.721     0.150
    21.118   284.750     0.150
    21.353   287.500     0.150
    21.693   291.011     0.150
    22.469   300.691     0.150
    22.999   305.401     0.150
    24.298   317.531     0.150
    24.365   318.221     0.150
    24.463   318.851     0.150
    26.290   334.960     0.150
    26.691   338.941     0.150
    30.213   370.931     0.150
    30.375   549.396     0.150
    33.589   399.730     0.150
    35.417   420.701     0.150
    43.802   485.261     0.150
    50.928   542.500     0.150
    50.971   542.401     0.150
    55.722   576.891     0.150
    56.279   581.361     0.150
    60.479   608.801     0.150
    74.765   698.601     0.150
    79.790   728.301     0.150
    79.790   728.301     0.150
    79.911   729.601     0.150
    79.911   729.601     0.150
    80.686   733.401     0.150
    80.686   733.401     0.150
    80.724   733.601     0.150
    80.724   733.601     0.150
    80.977   735.000     0.150
    80.977   735.000     0.150
    81.094   733.201     0.150
    81.566   737.601     0.150
    81.603   738.451     0.150
    82.187   742.301     0.150
    82.187   742.301     0.150
    82.220   741.701     0.150
    82.220   741.701     0.150
    82.381   743.000     0.150
    82.453   743.701     0.150
    82.453   743.701     0.150
    83.160   746.051     0.150
    83.643   749.201     0.150
    83.671   750.000     0.150
    83.671   750.000     0.150
    83.757   749.801     0.150
    83.757   749.801     0.150
    83.826   750.201     0.150
    83.826   750.201     0.150
    83.833   750.301     0.150
    83.833   750.301     0.150
    83.837   750.000     0.150
    83.876   750.401     0.150
    83.876   750.401     0.150
    83.934   750.301     0.150
    83.934   750.301     0.150
    83.935   750.901     0.150
    83.942   750.500     0.150
    83.942   750.500     0.150
    84.282   751.901     0.150
    84.282   751.901     0.150
    84.332   753.201     0.150
    84.332   753.201     0.150
    84.483   753.201     0.150
    84.483   753.201     0.150
    84.615   754.000     0.150
    84.615   754.000     0.150
    84.782   754.801     0.150
    84.782   754.801     0.150
    84.991   755.801     0.150
    84.991   755.801     0.150
    85.269   757.701     0.150
    85.269   760.701     0.150
    85.445   758.301     0.150
    85.445   758.301     0.150
    85.988   761.801     0.150
    86.501   763.101     0.150
    86.501   763.101     0.150
    86.525   764.000     0.150
    86.525   764.000     0.150
    86.548   764.201     0.150
    86.548   764.201     0.150
    86.987   765.801     0.150
    87.092   766.101     0.150
    87.092   766.101     0.150
    87.142   769.701     0.150
    87.368   768.000     0.150
    87.410   767.121     0.150
    87.836   769.500     0.150
    87.836   769.500     0.150
    90.051   780.201     0.150
    90.512   782.701     0.150
    91.629   791.500     0.150
    91.629  1009.901     0.150
    91.629  1423.701     0.150
    91.746   786.351     0.150
    92.068   790.041     0.150
    95.491   813.101     0.150
    95.491  1876.901     0.150
   101.561   837.101     0.150
   101.561   841.701     0.150
   107.228   861.901     0.150
   107.955   867.101     0.150
   109.361  1142.701     0.150
   109.361  1325.301     0.150
     0.927    15.359     0.150
     1.155    21.159     0.150
     1.155    36.929     0.150
     1.220    21.369     0.150
     1.220    36.179     0.150
     1.227    21.842     0.150
     1.730    50.782     0.150
     4.823    74.819     0.150
     4.823   160.039     0.150
     5.567    81.339     0.150
     5.567   184.889     0.150
     5.778    88.809     0.150
     6.154   191.799     0.150
     7.822   239.854     0.150
    10.347   318.475     0.150
     0.731    22.344     0.150
     0.784    14.194     0.150
     0.816    15.254     0.150
     0.816    31.004     0.150
     0.816    15.234     0.150
     0.816    24.714     0.150
     1.188    19.974     0.150
     1.188    36.224     0.150
     1.549    26.884     0.150
     1.550    56.384     0.150
     2.532    75.394     0.150
     2.548    42.294     0.150
     2.567    42.524     0.150
     4.207   117.794     0.150
     4.378   139.334     0.150
     4.667    93.534     0.150
     5.331   165.804     0.150
     5.758    87.554     0.150
     6.631   200.124     0.150
     6.726   221.824     0.150
     7.775   230.834     0.150
     8.159   257.274     0.150
     0.601    22.206     0.150
     0.876    14.956     0.150
     0.876    26.017     0.150
     0.893    16.296     0.150
     0.893    28.236     0.150
     1.315    20.651     0.150
     1.315    21.636     0.150
     1.315    38.176     0.150
     1.450    25.307     0.150
     1.450    45.116     0.150
     1.451    57.307     0.150
     2.448    39.376     0.150
     2.967    47.656     0.150
     4.102   118.176     0.150
     4.474    81.736     0.150
     4.646   139.406     0.150
     5.377   176.326     0.150
     5.843    84.006     0.150
     5.843   180.956     0.150
     7.347   232.616     0.150
     7.796   233.136     0.150
     8.023   250.826     0.150
     8.014   259.687     0.150
    80.898   735.426     0.150
    83.598   749.626     0.150
    83.790   750.826     0.150
    83.835   751.426     0.150
    83.878   751.227     0.150
    84.201   752.426     0.150
    84.515   754.526     0.150
    84.676   755.426     0.150
    84.891   756.326     0.150
     0.752    13.759     0.150
     0.805    15.209     0.150
     0.805    26.039     0.150
     0.805    30.919     0.150
     0.805    15.269     0.150
     0.805    26.028     0.150
     0.913    15.828     0.150
     0.913    27.448     0.150
     1.139    19.179     0.150
     1.139    33.694     0.150
     1.594    27.749     0.150
     1.594    50.158     0.150
     4.237   127.358     0.150
     5.500    80.419     0.150
     5.567   102.358     0.150
     5.613   193.039     0.150
     6.231   112.729     0.150
     6.581   119.709     0.150
     6.581   203.059     0.150
     7.831   244.179     0.150
     7.880   153.789     0.150
     8.058   116.519     0.150
     8.058   154.318     0.150
     8.120   251.134     0.150
     8.103   250.134     0.150
    15.410   219.759     0.150
    43.385   480.809     0.150
    55.435   578.358     0.150
   101.090   823.259     0.150
   101.090   828.059     0.150
   101.090   830.259     0.150
   107.403   864.759     0.150
     0.930    15.598     0.150
     1.173    21.478     0.150
     1.173    36.628     0.150
     1.164    21.458     0.150
     1.164    37.367     0.150
     1.718    27.237     0.150
     2.114    32.588     0.150
     3.341   100.067     0.150
     3.749   109.258     0.150
     4.801   140.857     0.150
     5.564    81.578     0.150
     5.564   152.867     0.150
     5.774    84.647     0.150
     5.774   164.598     0.150
     6.137   190.038     0.150
     6.684   103.322     0.150
     7.237   103.468     0.150
     7.494   107.418     0.150
     8.075   115.978     0.150
     8.525   120.878     0.150
    10.895   155.538     0.150
    11.662   163.428     0.150
    14.543   203.218     0.150
    15.083   210.027     0.150
    15.172   210.418     0.150
    16.570   228.857     0.150
    23.021   302.928     0.150
     0.547     9.613     0.150
     0.872    25.081     0.150
     0.872    14.945     0.150
     0.872    25.056     0.150
     0.940    17.226     0.150
     1.395    22.875     0.150
     1.388    20.465     0.150
     1.388    20.465     0.150
     1.388    43.465     0.150
     1.752    27.108     0.150
     2.663    95.186     0.150
     3.420    56.775     0.150
     4.026    62.075     0.150
     4.044    54.896     0.150
     4.074    62.835     0.150
     4.074   131.915     0.150
     4.538   145.186     0.150
     5.413   176.636     0.150
     5.788   188.745     0.150
     6.495    92.425     0.150
     6.830   209.886     0.150
     7.510   104.896     0.150
     7.703   102.386     0.150
     7.817   111.235     0.150
     7.817   230.445     0.150
     8.297   258.005     0.150
    12.553   180.675     0.150
     0.138     5.369     0.150
     0.734     3.689     0.150
     0.734    14.119     0.150
     1.016     7.689     0.150
     1.016    21.348     0.150
     1.043    20.729     0.150
     1.033    20.459     0.150
     1.033    34.658     0.150
     1.033    20.459     0.150
     1.033    34.658     0.150
     1.134    10.209     0.150
     1.134    25.969     0.150
     1.338    13.629     0.150
     1.338    31.889     0.150
     1.367    25.359     0.150
     1.367    45.979     0.150
     1.367    47.268     0.150
     1.367    25.359     0.150
     1.367    43.168     0.150
     1.419    24.543     0.150
     1.423    14.578     0.150
     1.423    33.518     0.150
     1.490    26.828     0.150
     1.909    29.455     0.150
     1.935    30.238     0.150
     1.956    30.689     0.150
     3.041    50.428     0.150
     3.317    55.279     0.150
     3.565    58.529     0.150
     3.565   127.689     0.150
     3.989    64.668     0.150
     4.465   131.018     0.150
     4.591    71.549     0.150
     4.654   153.539     0.150
     5.000    78.479     0.150
     5.000    98.748     0.150
     5.000   169.389     0.150
     6.280    96.359     0.150
     6.280   123.068     0.150
     6.906   109.254     0.150
     7.400   146.908     0.150
     7.400   209.768     0.150
     7.773   243.928     0.150
     7.773   264.449     0.150
     7.982   248.738     0.150
     8.262   261.398     0.150
     8.353   269.988     0.150
     8.445   157.389     0.150
     8.445   272.518     0.150
     8.699   131.053     0.150
     8.699   280.379     0.150
     8.699   279.879     0.150
     8.699   280.379     0.150
     9.053   130.658     0.150
     9.539   143.508     0.150
     9.799   147.959     0.150
     9.966   143.318     0.150
    16.147   229.898     0.150
    16.290   233.879     0.150
    21.217   288.859     0.150
    21.810   294.648     0.150
    23.135   309.578     0.150
    37.857   441.504     0.150
    81.666   742.078     0.150
     0.806    15.051     0.150
     0.806    25.391     0.150
     0.806    29.861     0.150
     0.806    15.021     0.150
     0.806    25.352     0.150
     1.136    18.844     0.150
     1.136    33.551     0.150
     1.597    27.410     0.150
     1.597    27.320     0.150
     1.597    48.170     0.150
     1.598    58.182     0.150
     1.890    29.320     0.150
     2.482    80.330     0.150
     3.763    58.391     0.150
     5.497   180.410     0.150
     5.564   143.051     0.150
     6.145    95.680     0.150
     6.145   110.795     0.150
     7.531   243.561     0.150
     8.116   124.471     0.150
     8.116   263.295     0.150
    15.656   228.670     0.150
    29.895   370.916     0.150
    37.396   437.121     0.150
     0.624     1.336     0.150
     0.624    10.066     0.150
     0.688     1.646     0.150
     0.688    10.646     0.150
     0.871    26.246     0.150
     1.109     9.887     0.150
     1.109    24.605     0.150
     1.114    36.447     0.150
     1.252    40.057     0.150
     1.239    12.037     0.150
     1.239    28.846     0.150
     1.252    42.217     0.150
     1.295    12.746     0.150
     1.295    30.307     0.150
     1.596    26.812     0.150
     1.610    25.574     0.150
     1.610    25.527     0.150
     1.610    45.566     0.150
     1.606    27.508     0.150
     1.863    30.238     0.150
     2.974    96.807     0.150
     3.233    51.176     0.150
     3.233    84.266     0.150
     4.201   136.797     0.150
     6.400   201.416     0.150
     7.035   230.006     0.150
     7.468   107.676     0.150
     7.871   245.117     0.150
     7.871   148.297     0.150
     7.871   245.117     0.150
     7.848   209.756     0.150
     8.431   126.891     0.150
    10.468   337.117     0.150
     0.809    28.012     0.150
     0.809    30.492     0.150
     0.809    14.953     0.150
     0.809    25.582     0.150
     0.829    13.262     0.150
     0.829    24.395     0.150
     1.089    18.172     0.150
     1.089    33.949     0.150
     1.089    18.148     0.150
     1.089    18.223     0.150
     1.089    33.953     0.150
     1.354    40.613     0.150
     1.644    47.211     0.150
     1.645    63.961     0.150
     2.441    42.914     0.150
     2.441    74.184     0.150
     2.755    41.926     0.150
     2.755    42.031     0.150
     3.717    55.492     0.150
     4.285    65.371     0.150
     4.256    62.652     0.150
     5.461    81.262     0.150
     5.517    82.562     0.150
     6.187    92.133     0.150
     6.532    99.441     0.150
     7.723   113.914     0.150
     7.830   108.523     0.150
     7.830   108.504     0.150
     7.887   114.551     0.150
     8.065   115.684     0.150
     8.073   119.949     0.150
     8.103   259.074     0.150
     9.408   136.012     0.150
     9.831   140.074     0.150
     9.887   140.863     0.150
    10.003   143.922     0.150
    10.003   143.941     0.150
    10.873   157.684     0.150
    10.931   341.219     0.150
    11.223   350.398     0.150
    13.817   198.234     0.150
    14.322   203.281     0.150
    14.673   215.922     0.150
    14.795   210.074     0.150
    15.610   222.672     0.150
    17.280   243.543     0.150
    17.618   250.332     0.150
    18.606   258.312     0.150
    20.618   280.031     0.150
    21.668   292.941     0.150
    21.770   298.941     0.150
    22.046   294.973     0.150
    22.269   301.254     0.150
    22.558   301.941     0.150
    22.935   306.293     0.150
    23.248   311.102     0.150
    23.306   310.094     0.150
    23.870   319.824     0.150
    24.120   317.184     0.150
    24.244   767.395     0.150
    24.519   321.664     0.150
    24.613   322.883     0.150
    26.608   339.922     0.150
    27.063   344.031     0.150
    28.780   359.402     0.150
    29.249   363.383     0.150
    29.904   371.121     0.150
    29.904   371.113     0.150
    31.393   386.223     0.150
    33.703   408.324     0.150
    33.703   408.281     0.150
    33.754   405.992     0.150
    34.543   413.664     0.150
    37.308   437.324     0.150
    37.308   437.301     0.150
    37.883   443.203     0.150
    38.328   445.504     0.150
    45.254   502.621     0.150
    47.726   523.184     0.150
    55.396   578.223     0.150
    55.396   578.211     0.150
    55.396   578.223     0.150
    60.093   609.121     0.150
    66.719   656.004     0.150
    72.016   691.121     0.150
    74.256   700.324     0.150
    77.166   718.223     0.150
    77.316   719.824     0.150
    80.727   735.422     0.150
    81.173   738.223     0.150
    82.020   745.824     0.150
    82.109   745.324     0.150
    82.109   745.324     0.150
    82.109   745.324     0.150
    83.550   752.621     0.150
    83.550   752.621     0.150
    83.550   752.621     0.150
    83.682   753.723     0.150
    83.682   753.723     0.150
    83.698   753.621     0.150
    83.698   753.621     0.150
    83.698   753.621     0.150
    83.736   754.121     0.150
    83.736   754.121     0.150
    83.736   754.121     0.150
    83.774   754.422     0.150
    83.802   754.023     0.150
    83.802   754.023     0.150
    83.802   754.023     0.150
    84.149   755.621     0.150
    84.149   755.621     0.150
    84.149   755.621     0.150
    84.375   757.023     0.150
    84.375   757.023     0.150
    84.375   757.023     0.150
    84.455   757.523     0.150
    84.455   757.523     0.150
    84.455   757.523     0.150
    84.613   758.523     0.150
    84.613   758.523     0.150
    84.613   758.523     0.150
    84.678   758.824     0.150
    84.678   758.824     0.150
    84.678   758.824     0.150
    84.830   759.324     0.150
    84.830   759.324     0.150
    84.830   759.324     0.150
    87.131   774.121     0.150
    87.131   777.422     0.150
    87.131     0.000     0.150
    88.417   777.422     0.150
    89.791   783.422     0.150
    90.263   781.223     0.150
    90.573     0.000     0.150
    91.429   791.023     0.150
    94.781   805.922     0.150
    94.781     7.199     0.150
    94.781  1036.523     0.150
    94.781  1439.723     0.150
    94.781  1475.523     0.150
    99.238   827.223     0.150
   100.912   838.723     0.150
   101.895   839.723     0.150
   102.183   843.824     0.150
   108.644  1323.121     0.150
   108.644  2047.223     0.150
   146.380  1185.199     0.150
     0.043     0.797     0.150
     0.129     1.344     0.150
     0.144     2.625     0.150
     0.219     4.074     0.150
     0.304     5.246     0.150
     0.313     5.316     0.150
     0.593    11.203     0.150
     0.761    13.684     0.150
     0.819    28.746     0.150
     0.819    32.887     0.150
     0.819    15.086     0.150
     0.819    26.523     0.150
     1.134    33.875     0.150
     1.134    19.047     0.150
     1.134    19.445     0.150
     1.134    33.875     0.150
     1.603    27.305     0.150
     1.603    49.055     0.150
     1.604    55.094     0.150
     2.350    38.328     0.150
     2.350    72.238     0.150
     2.485    40.535     0.150
     2.798    42.977     0.150
     3.763    56.516     0.150
     4.227    61.797     0.150
     4.647    65.863     0.150
     5.486    81.887     0.150
     5.558    82.844     0.150
     6.231    91.875     0.150
     6.577    96.965     0.150
     7.740   114.297     0.150
     7.914   116.516     0.150
     8.042   116.535     0.150
     8.108   118.352     0.150
     8.108   258.102     0.150
     8.089   118.426     0.150
     8.089   266.449     0.150
     9.437   136.926     0.150
    10.044   144.703     0.150
    10.879   158.035     0.150
    13.787   197.266     0.150
    14.304   202.086     0.150
    14.688   208.055     0.150
    14.838   212.824     0.150
    14.838   212.855     0.150
    15.398   220.363     0.150
    15.648   221.406     0.150
    16.035   233.703     0.150
    17.251   241.727     0.150
    18.588   257.676     0.150
    19.517   267.176     0.150
    20.653   280.305     0.150
    22.028   295.945     0.150
    22.557   301.406     0.150
    23.290   309.016     0.150
    24.146   316.094     0.150
    24.601   321.395     0.150
    26.592   340.074     0.150
    55.421   574.625     0.150
    91.452   787.121     0.150
    91.452   787.125     0.150
    96.046   809.004     0.150
   100.955   836.625     0.150
   101.282   829.523     0.150
   108.690  1140.926     0.150
   108.690  1324.324     0.150
     0.604    10.934     0.150
     0.604    10.934     0.150
     0.691    12.375     0.150
     0.691    12.375     0.150
     0.718    12.625     0.150
     0.718    12.625     0.150
     0.722    12.805     0.150
     0.722    12.805     0.150
     0.769    13.945     0.150
     1.145    20.855     0.150
     1.145    36.223     0.150
     1.145    40.773     0.150
     1.188    21.133     0.150
     1.188    21.152     0.150
     1.188    36.945     0.150
     1.742    29.551     0.150
     6.708   104.016     0.150
     7.855   147.953     0.150
     7.855   243.453     0.150
    10.378   330.723     0.150
     0.156     1.277     0.150
     0.156     4.377     0.150
     0.285     5.167     0.150
     0.698    12.487     0.150
     0.656    12.537     0.150
     0.656    22.057     0.150
     0.666    12.037     0.150
     0.722    12.707     0.150
     0.828    14.837     0.150
     0.865    15.617     0.150
     0.865    27.107     0.150
     0.962    15.950     0.150
     0.962    16.117     0.150
     0.942    15.652     0.150
     0.980    17.367     0.150
     1.115    20.517     0.150
     1.115    36.737     0.150
     1.242    44.267     0.150
     1.242    21.697     0.150
     1.242    35.747     0.150
     1.266    22.567     0.150
     1.347    23.837     0.150
     1.347    42.137     0.150
     1.802    52.497     0.150
     1.802    28.260     0.150
     2.929    47.267     0.150
     3.419    69.957     0.150
     4.436    71.147     0.150
     4.639    67.797     0.150
     4.870    96.047     0.150
     6.143    94.377     0.150
     6.803    93.507     0.150
     7.824   112.297     0.150
    18.233   250.277     0.150
     0.984    32.288     0.150
     1.056    19.297     0.150
     1.056    33.248     0.150
     1.343    45.058     0.150
     1.343    23.177     0.150
     1.343    40.797     0.150
     1.412    43.438     0.150
     1.921    29.837     0.150
     1.921    58.978     0.150
     3.530    55.808     0.150
     3.530   119.167     0.150
     3.956   116.717     0.150
     4.435   131.637     0.150
     5.877    85.397     0.150
     6.872   125.177     0.150
     6.872   225.978     0.150
     7.486   240.507     0.150
     7.777   112.837     0.150
     7.777   150.688     0.150
     7.777   241.677     0.150
     7.777   247.978     0.150
     7.886   244.938     0.150
     7.964   240.167     0.150
     8.279   118.527     0.150
     8.422   261.467     0.150
     8.669   158.703     0.150
    10.217   324.389     0.150
    11.497   172.598     0.150
    11.559   356.187     0.150
    13.897   194.917     0.150
    21.189   287.297     0.150
     0.870    26.283     0.150
     1.113    39.606     0.150
     1.123    40.526     0.150
     1.123    41.726     0.150
     1.606    28.501     0.150
     1.618    25.896     0.150
     3.240    52.966     0.150
     3.855    52.076     0.150
     4.604   155.446     0.150
     5.971   195.866     0.150
     6.391   207.926     0.150
     7.063   130.456     0.150
     7.175   106.446     0.150
     7.252   236.306     0.150
     7.464   245.776     0.150
     7.847   253.566     0.150
     7.864   243.086     0.150
     8.435   129.761     0.150
     8.435   261.936     0.150
    10.459   322.120     0.150
    11.412   169.186     0.150
    16.010   232.336     0.150
    95.312  1473.336     0.150
    95.312  1862.536     0.150
   102.709   844.836     0.150
   102.709   853.936     0.150
   102.709   858.036     0.150
   102.709   849.336     0.150
     0.062     1.179     0.150
     0.744    29.560     0.150
     0.817    15.159     0.150
     0.817    15.259     0.150
     0.817    25.179     0.150
     0.906    15.739     0.150
     0.906    27.599     0.150
     1.175    19.668     0.150
     1.268    49.049     0.150
     1.562    26.989     0.150
     1.562    48.409     0.150
     2.536    77.539     0.150
     5.599   103.169     0.150
     5.745    86.599     0.150
     5.745   110.929     0.150
     7.637   246.959     0.150
     8.090   248.029     0.150
     8.090   248.029     0.150
    10.873   337.862     0.150
     0.210     3.965     0.150
     0.249     4.684     0.150
     0.249     8.555     0.150
     0.285     5.012     0.150
     0.468     9.375     0.150
     0.601    10.082     0.150
     0.601    10.082     0.150
     0.727    13.285     0.150
     0.727    23.395     0.150
     0.811    15.094     0.150
     0.811    15.074     0.150
     0.811    25.895     0.150
     1.116    18.863     0.150
     1.201    21.883     0.150
     1.201    37.984     0.150
     1.201    43.895     0.150
     1.201    45.383     0.150
     1.517    45.109     0.150
     1.618    27.785     0.150
     1.618    27.785     0.150
     1.618    51.473     0.150
     2.332    38.230     0.150
     3.886   109.883     0.150
     5.479   180.793     0.150
     5.694   184.875     0.150
     8.044   257.902     0.150
     8.099   249.613     0.150
     8.099   249.613     0.150
    10.913   337.742     0.150
    43.362   485.562     0.150
     0.220    10.598     0.150
     0.940    15.828     0.150
     0.940    27.207     0.150
     1.160    22.305     0.150
     1.160    22.305     0.150
     1.160    38.066     0.150
     1.154    38.188     0.150
     1.154    20.734     0.150
     1.154    35.285     0.150
     1.708    27.305     0.150
     1.708    51.008     0.150
     2.313    68.668     0.150
     2.593    40.480     0.150
     6.679    95.410     0.150
     7.876   245.457     0.150
     8.527   258.785     0.150
     9.758   137.598     0.150
     1.004    35.941     0.150
     1.063    19.430     0.150
     1.153    43.262     0.150
     1.367    23.043     0.150
     1.367    39.781     0.150
     1.935    30.441     0.150
     1.935    28.770     0.150
     1.935    53.883     0.150
     3.302    45.781     0.150
     3.540    55.352     0.150
     3.650    56.152     0.150
     4.570    71.332     0.150
     8.669   278.055     0.150
     0.698    26.695     0.150
     0.741    26.547     0.150
     0.840     6.234     0.150
     0.840    14.445     0.150
     0.840    31.820     0.150
     0.840     6.234     0.150
     0.840    14.445     0.150
     1.176    19.844     0.150
     1.181    43.531     0.150
     1.570    23.516     0.150
     1.570    23.516     0.150
     1.570    43.156     0.150
     1.571    53.500     0.150
     7.509   106.680     0.150
     8.066   250.359     0.150
     8.134   260.055     0.150
    10.856   346.648     0.150
    21.681   289.555     0.150
    24.160   313.656     0.150
    94.869  1474.305     0.150
     0.166     7.991     0.150
     0.442    11.521     0.150
     0.509    10.571     0.150
     0.509    19.132     0.150
     0.878    15.212     0.150
     0.995    17.071     0.150
     1.001    19.252     0.150
     1.001    19.212     0.150
     1.001    35.832     0.150
     1.411    52.911     0.150
     1.336    22.101     0.150
     2.014    33.417     0.150
     2.014    69.741     0.150
     2.014    69.741     0.150
     1.900    28.969     0.150
     2.165    35.103     0.150
     2.170    33.908     0.150
     2.243    34.602     0.150
     2.424    39.021     0.150
     2.424    76.946     0.150
     2.598    39.914     0.150
     3.173    98.995     0.150
     3.621    57.502     0.150
     3.621    73.411     0.150
     3.629   123.472     0.150
     4.512   157.382     0.150
     4.648    71.602     0.150
     4.648   167.491     0.150
     4.667   156.031     0.150
     4.776    73.741     0.150
     4.776   175.802     0.150
     5.425   181.962     0.150
     5.940    89.922     0.150
     5.940   199.911     0.150
     6.334   229.802     0.150
     6.175   203.722     0.150
     6.367   219.531     0.150
     6.906   226.271     0.150
     7.053   106.182     0.150
     7.053   232.092     0.150
     7.116   106.922     0.150
     7.116   243.521     0.150
     7.761   146.741     0.150
     7.761   246.292     0.150
     7.761   261.531     0.150
     8.113   254.002     0.150
     8.746   132.441     0.150
    10.149   327.042     0.150
    10.499   151.151     0.150
    11.612   367.389     0.150
    23.523   315.735     0.150
     0.201     3.326     0.150
     0.261     4.326     0.150
     0.754    12.436     0.150
     0.754    44.076     0.150
     0.754    12.436     0.150
     0.754    24.875     0.150
     1.029    17.766     0.150
     1.029    17.725     0.150
     1.029    31.076     0.150
     1.029    31.346     0.150
     1.685    28.695     0.150
     1.685    52.314     0.150
     1.686    72.055     0.150
     2.464    41.525     0.150
     3.038    50.955     0.150
     5.137    73.275     0.150
     5.646    85.865     0.150
     6.049   109.275     0.150
     6.049   190.285     0.150
     8.167   260.125     0.150
     8.167   154.746     0.150
     8.167   260.125     0.150
     0.412    15.883     0.150
     1.001    18.553     0.150
     1.001    32.312     0.150
     1.109    18.793     0.150
     1.357    41.152     0.150
     1.357    23.402     0.150
     1.357    46.201     0.150
     1.357    23.402     0.150
     1.357    41.152     0.150
     1.950    30.111     0.150
     1.969    30.730     0.150
     4.603    70.973     0.150
     6.926   133.637     0.150
     7.799   111.037     0.150
     7.799   234.688     0.150
     0.202     9.508     0.150
     0.224     0.742     0.150
     0.224     4.641     0.150
     0.352    13.195     0.150
     0.363    15.227     0.150
     0.595    10.406     0.150
     0.609     6.438     0.150
     0.672    10.781     0.150
     0.763    10.578     0.150
     0.763    21.328     0.150
     0.933    17.055     0.150
     1.166    21.453     0.150
     1.166    21.414     0.150
     1.166    36.586     0.150
     1.158    20.664     0.150
     1.158    38.406     0.150
     1.158    38.734     0.150
     1.158    20.656     0.150
     1.166    41.461     0.150
     1.251    12.867     0.150
     1.251    22.047     0.150
     1.471    15.906     0.150
     1.543    30.242     0.150
     1.593    17.844     0.150
     1.620    18.281     0.150
     1.668    19.555     0.150
     1.706    19.758     0.150
     1.742    20.727     0.150
     1.815    22.125     0.150
     2.025    25.242     0.150
     2.033    25.617     0.150
     2.071    26.312     0.150
     2.868    41.812     0.150
     2.868    82.984     0.150
     3.063    40.266     0.150
     3.111    42.984     0.150
     3.111    87.555     0.150
     3.331    45.516     0.150
     3.735    52.742     0.150
     3.829   114.055     0.150
     3.843    54.781     0.150
     4.019    53.523     0.150
     4.290    61.031     0.150
     4.452    61.172     0.150
     4.481    60.844     0.150
     4.654    64.492     0.150
     5.215   176.844     0.150
     5.474   186.703     0.150
     5.564    80.086     0.150
     6.133    87.945     0.150
     6.770    95.875     0.150
     7.501   109.031     0.150
     0.209     4.240     0.150
     0.209     7.010     0.150
     0.223     5.120     0.150
     0.223     9.010     0.150
     0.577    10.580     0.150
     0.626    12.410     0.150
     0.626    21.130     0.150
     0.667    11.790     0.150
     0.696    12.440     0.150
     0.713    12.480     0.150
     0.741    13.270     0.150
     0.779    14.190     0.150
     0.779    24.460     0.150
     0.804    13.460     0.150
     0.854    14.480     0.150
     0.891    15.180     0.150
     1.170    21.030     0.150
     1.170    41.100     0.150
     1.170    21.060     0.150
     1.175    20.690     0.150
     1.175    42.810     0.150
     1.175    45.290     0.150
     1.175    20.680     0.150
     1.175    37.480     0.150
     1.179    35.234     0.150
     1.312    23.190     0.150
     1.525    23.070     0.150
     2.424    40.460     0.150
     2.865    46.020     0.150
     3.074    88.550     0.150
     3.747   105.060     0.150
     4.287    62.250     0.150
     4.348    66.590     0.150
     4.348   112.310     0.150
     4.487    69.190     0.150
     4.632    66.390     0.150
     4.795    76.140     0.150
     5.558    78.110     0.150
     6.679   102.592     0.150
     6.762    95.500     0.150
     7.159   102.290     0.150
     8.519   128.320     0.150
     8.519   273.520     0.150
    11.474   170.270     0.150
    11.474   170.270     0.150
    11.474   368.779     0.150
    16.098   232.870     0.150
     0.838    15.259     0.150
     0.838    30.779     0.150
     0.838    31.969     0.150
     0.838    15.199     0.150
     1.116    18.700     0.150
     1.116    18.649     0.150
     1.116    32.779     0.150
     1.156    19.686     0.150
     1.329    46.569     0.150
     1.629    27.809     0.150
     2.472    79.299     0.150
     2.594    39.319     0.150
     4.622   150.879     0.150
     5.260   173.949     0.150
     5.533   100.839     0.150
     6.507   210.159     0.150
     6.555   211.069     0.150
     7.580   106.399     0.150
     7.845   247.819     0.150
     7.863   258.639     0.150
     7.885   259.139     0.150
     8.080   114.434     0.150
     8.072   115.159     0.150
     8.535   271.979     0.150
    10.894   348.606     0.150
   100.932   836.459     0.150
   107.368   865.959     0.150
   107.368  1140.859     0.150
   107.368  2055.959     0.150
     0.815    31.238     0.150
     1.173    34.227     0.150
     2.536    41.648     0.150
     5.598    86.156     0.150
     8.062   115.906     0.150
    11.276   159.328     0.150
    37.432   437.277     0.150
     0.205     4.191     0.150
     0.663    12.059     0.150
     0.921    15.719     0.150
     0.921    28.750     0.150
     1.172    39.738     0.150
     1.172    21.230     0.150
     1.172    36.680     0.150
     1.174    22.109     0.150
     1.174    38.828     0.150
     1.174    43.250     0.150
     1.174    45.070     0.150
     1.661    30.211     0.150
     1.678    49.945     0.150
     1.709    27.176     0.150
     1.709    27.219     0.150
     1.709    27.121     0.150
     1.709    33.129     0.150
     1.709    49.691     0.150
     1.749    28.621     0.150
     2.115    40.230     0.150
     2.496    39.371     0.150
     2.584    40.180     0.150
     3.070    47.078     0.150
     3.070    87.719     0.150
     3.331    50.219     0.150
     3.331    56.539     0.150
     3.814    56.230     0.150
     3.814    64.660     0.150
     3.814   100.820     0.150
     4.343    64.648     0.150
     4.343    64.641     0.150
     4.482    66.898     0.150
     4.791    72.020     0.150
     4.791    72.102     0.150
     4.909    74.551     0.150
     5.204    78.621     0.150
     5.342    83.680     0.150
     5.459   179.090     0.150
     5.548    84.230     0.150
     5.764    85.828     0.150
     6.060    89.629     0.150
     6.778   100.711     0.150
     6.817    98.648     0.150
     7.154   105.121     0.150
     7.854   241.398     0.150
     7.897   116.531     0.150
     8.068   110.871     0.150
     8.150   112.512     0.150
     8.212   123.609     0.150
     8.349   122.320     0.150
     8.515   262.477     0.150
     8.803   130.430     0.150
     9.382   138.594     0.150
     9.738   136.738     0.150
     9.799   141.262     0.150
     9.757   142.520     0.150
    10.071   142.148     0.150
    10.189   148.520     0.150
    10.397   319.730     0.150
    10.544   154.012     0.150
    10.887   158.262     0.150
    10.988   157.430     0.150
    11.198   163.891     0.150
    11.198   362.980     0.150
    11.383   165.738     0.150
    11.446   158.609     0.150
    11.550   168.324     0.150
    12.919   182.801     0.150
    12.952   184.090     0.150
    13.347   192.109     0.150
    13.583   198.871     0.150
    13.662   193.000     0.150
    13.662   193.039     0.150
    13.850   200.289     0.150
    13.898   196.484     0.150
    14.006   199.340     0.150
    14.199   203.059     0.150
    14.787   214.262     0.150
    14.801   209.539     0.150
    15.113   212.348     0.150
    15.357   220.102     0.150
    15.578   221.055     0.150
    15.662   386.262     0.150
    16.093   225.699     0.150
    16.093   225.711     0.150
    16.672   232.922     0.150
    16.817   238.551     0.150
    17.022   237.199     0.150
    17.043   236.836     0.150
    17.083   237.871     0.150
    17.113   238.062     0.150
    17.362   241.500     0.150
    17.362   241.336     0.150
    18.277   254.672     0.150
    18.634   257.172     0.150
    19.299   261.930     0.150
    19.639   267.949     0.150
    20.206   274.426     0.150
    21.360   288.449     0.150
    21.718   289.461     0.150
    21.846   289.059     0.150
    22.459   298.969     0.150
    23.018   306.590     0.150
    23.018   728.410     0.150
    23.072   306.602     0.150
    23.072   726.328     0.150
    23.908   318.898     0.150
    24.063   315.488     0.150
    24.305   319.969     0.150
    24.375   318.859     0.150
    24.404   318.672     0.150
    26.718   340.699     0.150
    26.953   336.172     0.150
    30.158   371.352     0.150
    30.369   368.102     0.150
    31.058   377.039     0.150
    36.228   426.109     0.150
    37.646   437.121     0.150
    37.901   440.051     0.150
    43.731   486.449     0.150
    46.958   517.449     0.150
    50.867   542.801     0.150
    50.922   544.699     0.150
    55.665   577.891     0.150
    56.191   711.398     0.150
    59.424  1090.102     0.150
    60.416   609.801     0.150
    62.993   633.301     0.150
    64.183  1150.398     0.150
    72.619  1529.602     0.150
    74.598   698.949     0.150
    74.700   698.699     0.150
    77.407   716.500     0.150
    77.678   717.352     0.150
    77.831   718.961     0.150
    78.103  1006.000     0.150
    78.103  1821.801     0.150
    79.447   727.898     0.150
    79.447   727.898     0.150
    79.758   729.699     0.150
    79.758   729.699     0.150
    79.878   730.199     0.150
    79.878   730.199     0.150
    79.924   733.102     0.150
    80.651   734.801     0.150
    80.651   734.801     0.150
    80.689   735.000     0.150
    80.689   735.000     0.150
    80.943   736.199     0.150
    80.943   736.199     0.150
    81.033   735.199     0.150
    81.502   737.898     0.150
    81.650   744.898     0.150
    82.148   742.699     0.150
    82.148   742.699     0.150
    82.188   742.898     0.150
    82.188   742.898     0.150
    82.363   744.500     0.150
    82.413   744.301     0.150
    82.413   744.301     0.150
    82.432   747.801     0.150
    83.437     3.602     0.150
    83.437     5.203     0.150
    83.605   750.398     0.150
    83.637   750.301     0.150
    83.637   750.301     0.150
    83.726   751.199     0.150
    83.726   751.199     0.150
    83.790   751.500     0.150
    83.790   751.500     0.150
    83.792   751.199     0.150
    83.792   751.199     0.150
    83.798   751.398     0.150
    83.798   751.398     0.150
    83.799   751.301     0.150
    83.840   751.699     0.150
    83.840   751.699     0.150
    83.897   752.199     0.150
    83.899   751.500     0.150
    83.899   751.500     0.150
    83.910   751.898     0.150
    83.910   751.898     0.150
    84.135   751.109     0.150
    84.247   753.199     0.150
    84.247   753.199     0.150
    84.304   754.602     0.150
    84.304   754.602     0.150
    84.451   754.398     0.150
    84.451   754.398     0.150
    84.577   755.199     0.150
    84.577   755.199     0.150
    84.729   756.000     0.150
    84.729   756.000     0.150
    84.743   756.102     0.150
    84.743   756.102     0.150
    84.823   755.309     0.150
    84.953   757.000     0.150
    84.953   757.000     0.150
    85.223   758.000     0.150
    85.223  1389.000     0.150
    85.223  1930.000     0.150
    85.408   759.602     0.150
    85.408   759.602     0.150
    85.572   760.301     0.150
    85.572   760.301     0.150
    85.881   761.898     0.150
    85.881   761.898     0.150
    85.942   762.000     0.150
    85.942  1399.000     0.150
    85.974   762.500     0.150
    86.464   766.898     0.150
    86.464   766.898     0.150
    86.464  1399.301     0.150
    86.466   764.500     0.150
    86.466   764.500     0.150
    86.466   764.500     0.150
    86.489   765.102     0.150
    86.489   765.102     0.150
    86.512   765.500     0.150
    86.512   765.500     0.150
    86.862   768.398     0.150
    86.920   766.121     0.150
    86.954   767.500     0.150
    87.057   767.398     0.150
    87.057   767.398     0.150
    87.074   769.301     0.150
    87.098   768.199     0.150
    87.098  1408.000     0.150
    87.322   779.699     0.150
    87.322   770.500     0.150
    87.322  1411.500     0.150
    87.722   773.301     0.150
    87.789   773.000     0.150
    87.789  1414.199     0.150
    87.802   770.398     0.150
    87.802   770.398     0.150
    87.887   770.801     0.150
    87.887   770.801     0.150
    88.001   772.199     0.150
    88.001   772.199     0.150
    88.457   775.398     0.150
    89.048   779.551     0.150
    89.388   783.199     0.150
    89.727   995.199     0.150
    89.739   778.398     0.150
    89.739  1407.699     0.150
    89.797   782.898     0.150
    90.002   781.602     0.150
    90.374   786.000     0.150
    90.374   786.020     0.150
    90.787   787.801     0.150
    91.554  1010.898     0.150
    91.554  1523.801     0.150
    91.691   788.070     0.150
    95.403   808.102     0.150
   102.800  1966.500     0.150
   107.873   868.199     0.150
   107.873  1144.801     0.150
   107.873  2060.000     0.150
   109.274  1325.000     0.150
   142.780  1172.199     0.150
   145.063  1178.379     0.150
   145.911  1181.750     0.150
     0.575     9.743     0.150
     0.621    11.563     0.150
     0.621    10.743     0.150
     0.734    22.743     0.150
     0.768    12.743     0.150
     1.086    19.763     0.150
     1.086    19.773     0.150
     1.086    33.833     0.150
     1.091    38.433     0.150
     1.091    38.693     0.150
     1.252    22.343     0.150
     1.252    22.303     0.150
     1.252    38.383     0.150
     1.592    25.522     0.150
     6.565   101.742     0.150
     6.565   126.603     0.150
     6.565   225.493     0.150
     7.896   119.718     0.150
     7.896   151.171     0.150
     8.429   131.793     0.150
     8.429   157.868     0.150
     0.213     3.703     0.150
     0.213     7.424     0.150
     0.227     4.543     0.150
     0.588    11.904     0.150
     0.588    20.113     0.150
     0.761    13.924     0.150
     0.761    24.264     0.150
     0.955    15.885     0.150
     1.148    20.904     0.150
     1.144    20.514     0.150
     1.144    36.014     0.150
     1.274    22.824     0.150
     1.710    50.654     0.150
     1.710    27.033     0.150
     1.710    50.654     0.150
     3.109    51.715     0.150
     3.340    52.193     0.150
     6.685    95.781     0.150
     6.685   219.105     0.150
     7.891   245.283     0.150
     8.537   164.443     0.150
     8.537   265.854     0.150
    10.249   154.273     0.150
    11.503   355.215     0.150
     0.157     2.742     0.150
     0.903    15.164     0.150
     0.903    25.258     0.150
     1.095    41.953     0.150
     1.076    38.742     0.150
     1.619    47.398     0.150
     1.619    25.844     0.150
     1.619    24.930     0.150
     2.976    87.422     0.150
     3.648    58.594     0.150
     4.227    62.133     0.150
     4.227   130.000     0.150
     8.457   154.547     0.150
    10.482   333.875     0.150
    86.133   756.047     0.150
     0.226     2.078     0.150
     0.226     4.844     0.150
     0.206     3.055     0.150
     0.206     7.086     0.150
     0.599    10.867     0.150
     0.678    12.133     0.150
     0.635    12.078     0.150
     0.635    20.859     0.150
     0.719    12.836     0.150
     0.762    13.688     0.150
     0.813    13.336     0.150
     0.801    14.484     0.150
     0.801    25.156     0.150
     0.876    12.773     0.150
     0.876    14.977     0.150
     0.931    28.109     0.150
     1.158    20.945     0.150
     1.158    35.625     0.150
     1.193    21.297     0.150
     1.193    39.445     0.150
     1.193    21.273     0.150
     1.193    36.516     0.150
     1.322    23.547     0.150
     1.322    41.562     0.150
     1.580    30.516     0.150
     1.735    27.609     0.150
     1.735    53.680     0.150
     2.304    71.078     0.150
     2.487    77.773     0.150
     2.605    39.984     0.150
     2.862    47.492     0.150
     3.041    52.344     0.150
     3.096    91.305     0.150
     3.356    50.812     0.150
     4.281    69.016     0.150
     5.018    75.359     0.150
     6.147    90.062     0.150
     6.699   103.336     0.150
     6.699   130.734     0.150
     6.699   103.336     0.150
     6.699   130.734     0.150
     6.844   104.789     0.150
     6.844   121.898     0.150
     7.815   118.188     0.150
     8.070   115.164     0.150
     8.412   122.008     0.150
     9.773   140.883     0.150
    10.295   145.352     0.150
    10.374   331.438     0.150
    10.374   331.438     0.150
    11.224   343.641     0.150
    11.421   163.812     0.150
    11.452   160.742     0.150
    12.168   172.797     0.150
    12.326   175.492     0.150
    12.739   183.844     0.150
    12.754   183.594     0.150
    13.311   189.062     0.150
    13.677   190.164     0.150
    13.676   194.188     0.150
    13.826   343.953     0.150
    13.844   195.523     0.150
    16.290   959.688     0.150
    16.309   402.203     0.150
    21.062   282.578     0.150
    23.077   305.789     0.150
    35.268   414.992     0.150
    40.627   459.312     0.150
    92.005   792.797     0.150
    95.429     4.695     0.150
    95.429     8.297     0.150
   101.499  1467.336     0.150
   101.499  1526.336     0.150
   107.167  2027.234     0.150
   107.894   867.438     0.150
   107.894  1142.836     0.150
   107.894  2057.539     0.150
     0.450     1.938     0.150
     0.450     8.781     0.150
     0.792    28.180     0.150
     0.832    15.590     0.150
     0.832    15.969     0.150
     0.832    27.211     0.150
     0.884    15.168     0.150
     1.617    27.750     0.150
     1.617    49.109     0.150
     1.618    54.789     0.150
     1.618    48.449     0.150
     2.484    87.848     0.150
     2.592    39.129     0.150
     2.785    83.469     0.150
     3.155    91.340     0.150
     5.469   175.918     0.150
     5.584    81.680     0.150
     6.129   110.266     0.150
     6.129   192.469     0.150
     7.501   111.469     0.150
     7.532   108.664     0.150
     7.591   247.328     0.150
     7.897   252.609     0.150
     8.092   256.840     0.150
    10.622   326.309     0.150
    12.246   174.258     0.150
    12.408   174.918     0.150
    12.682   180.270     0.150
    13.402   182.168     0.150
    15.115   215.465     0.150
    16.223   227.633     0.150
    16.822   235.945     0.150
    24.398   323.723     0.150
    94.818   797.461     0.150
   102.219  1091.359     0.150
   107.379   866.359     0.150
   107.379  1592.359     0.150
     0.125     5.039     0.150
     1.127    35.609     0.150
     1.127    40.289     0.150
     1.127    20.250     0.150
     1.127    35.590     0.150
     1.250    22.180     0.150
     1.250    38.410     0.150
     1.251    22.438     0.150
     1.619    25.770     0.150
     1.619    31.109     0.150
     1.619    50.090     0.150
     2.166    33.379     0.150
     2.370    36.461     0.150
     5.971    90.988     0.150
     6.584   101.238     0.150
     8.142   116.797     0.150
    10.856   155.277     0.150
    11.410   369.066     0.150
    11.675   164.668     0.150
    27.979   355.113     0.150
    81.477   741.238     0.150
     0.450    23.117     0.150
     0.736    29.789     0.150
     0.769    23.957     0.150
     0.834    15.598     0.150
     0.834    27.867     0.150
     0.834    15.598     0.150
     0.834    25.117     0.150
     1.124    19.137     0.150
     1.124    33.723     0.150
     1.124    33.629     0.150
     1.619    27.930     0.150
     2.352    38.680     0.150
     2.446    44.594     0.150
     4.219    60.598     0.150
     4.629    71.488     0.150
     4.629   127.109     0.150
     5.688    87.477     0.150
     5.688   186.168     0.150
     8.090   150.004     0.150
     9.774   131.773     0.150
    10.892   332.961     0.150
    11.226   167.879     0.150
     0.277    11.422     0.150
     0.288     9.289     0.150
     0.288    13.266     0.150
     0.644     9.703     0.150
     0.626    23.242     0.150
     0.704    11.633     0.150
     0.736    10.922     0.150
     0.748     8.398     0.150
     0.770    10.859     0.150
     0.846    15.781     0.150
     0.846    30.844     0.150
     0.982    17.805     0.150
     0.969    15.672     0.150
     1.071    20.820     0.150
     1.071    38.125     0.150
     1.100    21.461     0.150
     1.100    19.242     0.150
     1.100    34.273     0.150
     1.215    22.633     0.150
     1.215    22.695     0.150
     1.215    39.883     0.150
     1.244    23.875     0.150
     1.317    24.922     0.150
     1.503    20.828     0.150
     1.824    26.094     0.150
     1.827    27.930     0.150
     2.940    84.953     0.150
     6.146   120.039     0.150
     7.865   141.453     0.150
     7.865   191.672     0.150
     8.078   121.148     0.150
     8.595   125.672     0.150
     8.595   271.125     0.150
    10.347   147.555     0.150
    10.347   329.773     0.150
    10.347   329.773     0.150
    13.452   197.023     0.150
    30.378   371.922     0.150
     0.145     2.328     0.150
     0.145     5.215     0.150
     0.373    13.848     0.150
     0.415     8.406     0.150
     0.415     8.336     0.150
     0.683    12.016     0.150
     0.738    14.516     0.150
     0.738    25.188     0.150
     0.810    14.637     0.150
     0.929    17.445     0.150
     1.026    17.137     0.150
     1.008    33.496     0.150
     1.008    17.945     0.150
     1.008    32.027     0.150
     1.049    19.176     0.150
     1.143    42.375     0.150
     1.365    45.996     0.150
     1.365    47.016     0.150
     1.365    23.465     0.150
     1.365    41.836     0.150
     1.944    63.750     0.150
     1.944    30.625     0.150
     3.550    55.727     0.150
     3.980    66.125     0.150
     4.579    71.418     0.150
     4.705    72.438     0.150
     5.580    92.828     0.150
     6.891   105.375     0.150
    11.499   158.918     0.150
    13.169   184.375     0.150
    14.731   214.285     0.150
    14.951   218.227     0.150
    15.225   224.828     0.150
    15.788   220.938     0.150
    16.459   232.367     0.150
    20.799   287.828     0.150
    23.120   304.402     0.150
    39.171   456.156     0.150
     0.356    14.746     0.150
     0.399     8.004     0.150
     0.399    16.094     0.150
     0.399    22.996     0.150
     0.741    26.473     0.150
     1.009    16.859     0.150
     0.998    33.453     0.150
     1.361    44.223     0.150
     1.361    23.535     0.150
     1.934    30.051     0.150
     1.929    30.449     0.150
     4.683    76.812     0.150
     4.683   137.094     0.150
     6.319    96.363     0.150
     6.319   154.344     0.150
    11.548   172.074     0.150
    16.256   233.723     0.150
     0.406     7.980     0.150
     0.802    14.453     0.150
     0.805    15.281     0.150
     0.961    17.004     0.150
     0.961    17.004     0.150
     1.011    15.809     0.150
     1.074    18.652     0.150
     1.370    45.980     0.150
     1.904    57.160     0.150
     4.043   131.344     0.150
     4.572    65.391     0.150
     7.751   239.441     0.150
     7.875   121.953     0.150
     8.244   117.492     0.150
     8.934   291.133     0.150
     9.021   129.434     0.150
     9.507   136.312     0.150
    11.351   161.691     0.150
    17.004   239.414     0.150
    20.789   287.113     0.150
    21.724   287.480     0.150
    38.404   446.664     0.150
     0.281    11.562     0.150
     0.305    15.141     0.150
     0.661    23.742     0.150
     1.100    19.402     0.150
     1.256    22.031     0.150
     1.823    27.246     0.150
     1.823    56.871     0.150
     2.034    59.199     0.150
     5.447    79.652     0.150
     6.288    89.852     0.150
     8.602   267.672     0.150
    10.306   321.633     0.150
     0.152     2.812     0.150
     0.607    23.180     0.150
     0.659    11.391     0.150
     1.113    20.223     0.150
     1.113    35.250     0.150
     1.113    39.812     0.150
     1.113    20.250     0.150
     1.113    35.191     0.150
     1.190    21.203     0.150
     1.225    21.910     0.150
     1.225    21.852     0.150
     1.225    42.590     0.150
     1.225    21.953     0.150
     1.631    26.172     0.150
     1.631    47.711     0.150
     2.383    36.680     0.150
     3.867    59.961     0.150
     6.602   102.637     0.150
     7.883   143.832     0.150
     8.458   127.805     0.150
    16.033   232.207     0.150
    23.054   308.758     0.150
    27.999   356.281     0.150
     0.146     9.767     0.150
     0.146     4.047     0.150
     0.146     7.057     0.150
     0.338     6.547     0.150
     0.338    11.077     0.150
     0.338     6.477     0.150
     0.338    10.327     0.150
     0.702    25.707     0.150
     0.702    13.877     0.150
     0.702    23.207     0.150
     0.933    29.507     0.150
     0.933    29.507     0.150
     1.094    19.957     0.150
     1.094    35.736     0.150
     1.305    22.517     0.150
     1.305    42.776     0.150
     1.305    22.507     0.150
     1.394    24.356     0.150
     1.394    43.937     0.150
     2.963    48.137     0.150
     3.474    60.887     0.150
     3.700    57.146     0.150
     4.387   135.287     0.150
     4.628    70.236     0.150
     4.626    83.606     0.150
     5.419   162.517     0.150
     5.837   104.526     0.150
     5.837   181.077     0.150
     6.238   114.896     0.150
     6.243   190.917     0.150
     6.816   124.668     0.150
     6.816   232.101     0.150
     7.084   214.617     0.150
     7.474   229.687     0.150
     7.785   119.867     0.150
     7.785   253.117     0.150
     7.934   142.566     0.150
    10.256   319.367     0.150
    11.525   220.125     0.150
    11.525   376.467     0.150
    38.074   444.816     0.150
    92.128   797.229     0.150
     0.522    20.857     0.150
     0.699    12.667     0.150
     0.780    28.647     0.150
     0.780    14.237     0.150
     0.780    24.277     0.150
     1.211    42.617     0.150
     1.211    43.027     0.150
     1.653    27.888     0.150
     1.653    50.428     0.150
     2.665    89.547     0.150
     3.086    89.797     0.150
     4.290   143.367     0.150
     4.670   152.297     0.150
     5.507    99.377     0.150
     5.507   172.047     0.150
     5.635   102.647     0.150
     6.511   116.947     0.150
     6.527   203.167     0.150
     6.802   182.728     0.150
     7.470   233.087     0.150
     7.540   235.657     0.150
     7.602   231.558     0.150
     7.739   251.157     0.150
     0.180     3.188     0.150
     0.279     5.570     0.150
     0.401    14.770     0.150
     0.623    11.508     0.150
     0.873    25.617     0.150
     0.898    16.457     0.150
     0.898    31.250     0.150
     0.898    16.500     0.150
     0.898    28.430     0.150
     1.197    21.777     0.150
     1.320    21.438     0.150
     1.447    24.797     0.150
     1.448    26.488     0.150
     2.616    40.230     0.150
     5.845    84.309     0.150
     7.795   111.398     0.150
     8.056   116.258     0.150
     0.469     9.332     0.150
     0.809    15.051     0.150
     0.809    15.051     0.150
     0.809    29.719     0.150
     0.809    15.051     0.150
     0.809    26.148     0.150
     0.906    27.250     0.150
     0.906    15.609     0.150
     1.115    18.680     0.150
     1.115    18.719     0.150
     1.115    33.172     0.150
     1.619    28.070     0.150
     1.619    49.398     0.150
     1.620    62.941     0.150
     2.781    42.602     0.150
     3.743    55.922     0.150
     4.243   116.422     0.150
     4.651    70.160     0.150
     6.531   125.898     0.150
     0.473     9.215     0.150
     0.473    17.527     0.150
     0.805    14.875     0.150
     0.805    14.895     0.150
     0.805    29.387     0.150
     0.805    14.906     0.150
     0.805    26.426     0.150
     0.910    27.516     0.150
     1.114    18.652     0.150
     1.114    33.902     0.150
     1.619    27.617     0.150
     1.619    49.465     0.150
     1.620    48.227     0.150
     4.248   108.445     0.150
     6.123   191.359     0.150
    27.534   346.414     0.150
     0.122     6.688     0.150
     0.122     2.090     0.150
     0.638    24.891     0.150
     1.131    20.617     0.150
     1.131    40.590     0.150
     1.131    20.578     0.150
     1.254    22.668     0.150
     1.254    22.629     0.150
     1.254    38.719     0.150
     2.162    41.289     0.150
     3.847    59.430     0.150
     7.455   108.820     0.150
     7.855   243.516     0.150
     8.431   258.766     0.150
     8.468   123.328     0.150
    10.451   337.363     0.150
    30.215   374.066     0.150
     0.510    10.348     0.150
     0.510    27.387     0.150
     0.510    27.590     0.150
     0.709    12.867     0.150
     0.786    14.469     0.150
     0.786    25.258     0.150
     0.929    28.535     0.150
     1.080    18.387     0.150
     1.080    32.270     0.150
     1.362    55.457     0.150
     1.645    29.379     0.150
     1.646    59.188     0.150
     2.476    70.359     0.150
     2.751    42.328     0.150
     3.706    55.598     0.150
     3.885   103.590     0.150
     4.666   122.316     0.150
     6.522   173.168     0.150
     6.792   177.898     0.150
     7.462   196.387     0.150
     7.537   188.168     0.150
     8.127   155.438     0.150
     8.127   255.289     0.150
     9.639   241.777     0.150
    10.577   152.605     0.150
    10.754   152.457     0.150
    10.893   155.789     0.150
    10.936   156.168     0.150
    10.954   336.332     0.150
    11.236   158.430     0.150
    12.364   174.449     0.150
    12.570   177.438     0.150
    13.316   187.250     0.150
    13.645   191.359     0.150
    14.359   202.539     0.150
    16.440   232.789     0.150
    20.624   279.047     0.150
   107.353  1585.238     0.150
   107.353  2043.738     0.150
     0.402     7.095     0.150
     0.460     8.715     0.150
     0.568    11.075     0.150
     0.568    19.245     0.150
     0.515     9.035     0.150
     0.578    10.695     0.150
     0.600    10.765     0.150
     0.577    10.895     0.150
     0.910    14.794     0.150
     1.025    18.875     0.150
     1.025    32.395     0.150
     1.025    18.905     0.150
     1.025    32.375     0.150
     1.025    34.725     0.150
     1.268    23.055     0.150
     1.268    40.774     0.150
     1.268    23.104     0.150
     1.269    23.104     0.150
     1.269    41.435     0.150
     2.768    86.044     0.150
     6.527   101.809     0.150
     7.998   145.455     0.150
     0.168     1.359     0.150
     0.168     3.566     0.150
     0.896    14.840     0.150
     0.896    26.477     0.150
     0.896    14.922     0.150
     1.152    20.547     0.150
     1.152    35.770     0.150
     1.152    42.008     0.150
     1.208    21.777     0.150
     1.208    21.797     0.150
     1.208    20.859     0.150
     1.208    20.770     0.150
     1.208    42.188     0.150
     1.669    26.156     0.150
     1.669    51.328     0.150
     2.137    32.754     0.150
     3.032    47.898     0.150
     3.290    50.328     0.150
     3.830    56.066     0.150
     4.303    64.199     0.150
     4.303    64.266     0.150
     4.441    65.328     0.150
     4.441   119.117     0.150
     4.752    70.938     0.150
     4.752    70.973     0.150
     4.761    71.953     0.150
     5.454    81.004     0.150
     6.020   163.316     0.150
     6.020    90.977     0.150
     6.020   163.309     0.150
     6.634   100.301     0.150
     6.634   220.727     0.150
     6.750    99.418     0.150
     6.750   175.629     0.150
     7.093   136.637     0.150
     7.093   230.090     0.150
     7.114   181.918     0.150
     7.114   105.770     0.150
     7.114   181.957     0.150
     7.549   199.789     0.150
     7.857   245.418     0.150
     7.873   205.418     0.150
     7.873   115.316     0.150
     7.873   205.379     0.150
     8.052   115.977     0.150
     8.180   122.547     0.150
     8.180   210.637     0.150
     8.479   272.742     0.150
     8.479   123.219     0.150
     8.479   218.188     0.150
     8.479   272.746     0.150
     9.386   245.039     0.150
    10.505   155.199     0.150
    10.505   270.617     0.150
    10.842   157.344     0.150
    10.873   158.137     0.150
    11.013   269.859     0.150
    11.158   164.387     0.150
    11.735   303.340     0.150
    12.264   181.738     0.150
    12.680   180.609     0.150
    12.960   184.848     0.150
    13.367   192.207     0.150
    13.629   200.719     0.150
    13.629   200.680     0.150
    13.785   200.789     0.150
    14.014   199.090     0.150
    14.780   209.559     0.150
    15.317   218.859     0.150
    16.056   228.277     0.150
    16.837   236.387     0.150
    18.287   254.758     0.150
    18.287   457.488     0.150
    21.008   281.316     0.150
    21.008   281.289     0.150
    21.727   292.238     0.150
    22.453   300.168     0.150
    23.024   306.219     0.150
    23.051   304.727     0.150
    24.376   317.797     0.150
    30.131   370.270     0.150
    36.581   428.219     0.150
    37.383   429.828     0.150
    37.860   438.758     0.150
    55.637   575.590     0.150
    56.151   589.719     0.150
    76.831   707.117     0.150
    79.741   728.020     0.150
    79.741   728.020     0.150
    80.272   731.578     0.150
    82.128   742.020     0.150
    82.128   742.020     0.150
    82.353   742.117     0.150
    82.393   742.520     0.150
    82.393   742.520     0.150
    83.585   748.617     0.150
    83.780   749.520     0.150
    83.780   749.418     0.150
    83.780   749.418     0.150
    83.821   749.816     0.150
    83.821   749.816     0.150
    83.877   750.316     0.150
    84.229   751.418     0.150
    84.229   751.418     0.150
    84.557   753.418     0.150
    84.557   753.418     0.150
    84.723   754.316     0.150
    84.723   754.316     0.150
    84.933   755.219     0.150
    84.933   755.219     0.150
    85.201   756.918     0.150
    85.919   760.816     0.150
    87.298   767.418     0.150
    89.774   782.418     0.150
    89.977   780.219     0.150
    91.018   780.520     0.150
    91.018   798.719     0.150
    95.363   799.816     0.150
    95.363  1031.816     0.150
    95.363  1431.520     0.150
    95.363  1859.316     0.150
   101.435   828.316     0.150
   107.834   864.918     0.150
   145.080  1177.727     0.150
     0.396    10.590     0.150
     0.396    10.680     0.150
     0.440    24.012     0.150
     0.755    28.941     0.150
     1.037    19.410     0.150
     1.037    34.551     0.150
     1.037    19.703     0.150
     1.035    34.273     0.150
     1.358    46.371     0.150
     1.388    24.750     0.150
     1.388    45.590     0.150
     1.511    27.902     0.150
     3.043    46.301     0.150
     4.007    56.680     0.150
     6.916   104.750     0.150
     7.754   245.652     0.150
     8.087   116.113     0.150
     8.240   116.973     0.150
     8.701   130.727     0.150
     8.701   281.375     0.150
    38.174   445.453     0.150
     0.564    10.678     0.150
     0.764    14.037     0.150
     0.764    24.088     0.150
     0.771    27.947     0.150
     1.413    49.197     0.150
     1.687    30.568     0.150
     1.687    53.357     0.150
     1.688    59.988     0.150
     2.370    69.287     0.150
     3.654    57.268     0.150
     3.838    62.248     0.150
     5.642    85.697     0.150
     6.048   190.826     0.150
     8.156   263.367     0.150
     0.539    10.533     0.150
     0.749    28.033     0.150
     0.767    14.303     0.150
     0.767    25.824     0.150
     0.767    14.234     0.150
     0.767    26.203     0.150
     0.949    16.334     0.150
     1.058    31.652     0.150
     1.385    44.354     0.150
     1.661    28.414     0.150
     1.662    28.633     0.150
     2.261    37.449     0.150
     2.261    65.576     0.150
     2.683    40.717     0.150
     2.733    80.004     0.150
     5.648    84.439     0.150
     6.819    99.311     0.150
     0.247     4.680     0.150
     0.812    15.117     0.150
     0.812    15.133     0.150
     0.812    27.430     0.150
     0.903    27.711     0.150
     1.631    27.906     0.150
     1.631    48.930     0.150
     1.632    56.633     0.150
     2.768    42.617     0.150
     3.128    91.617     0.150
     3.731    56.094     0.150
     3.905   107.508     0.150
     6.111   191.648     0.150
     6.546   193.758     0.150
     6.759   212.883     0.150
     7.875   119.258     0.150
     7.895   119.562     0.150
     8.098   249.797     0.150
     8.098   249.797     0.150
     9.877   154.078     0.150
    10.041   138.211     0.150
    10.750   150.078     0.150
    10.829   162.922     0.150
    10.920   340.117     0.150
    11.230   155.492     0.150
    11.230   360.430     0.150
    11.392   168.898     0.150
    11.435   159.820     0.150
    11.464   161.453     0.150
    11.491   164.344     0.150
    13.157   187.703     0.150
    13.316   198.500     0.150
    13.807   198.273     0.150
    15.242   223.219     0.150
    15.374   225.188     0.150
    15.622   485.562     0.150
    15.622   222.180     0.150
    15.622   485.562     0.150
    16.845   236.523     0.150
    21.757   293.258     0.150
    34.689   416.617     0.150
    38.342   441.023     0.150
    40.038   462.000     0.150
    66.676   655.797     0.150
    94.795   805.102     0.150
    94.795     5.297     0.150
    94.795     9.398     0.150
   100.925   840.203     0.150
   107.365   866.602     0.150
   107.365  1141.000     0.150
     0.303     5.117     0.150
     0.478    23.438     0.150
     0.478    23.859     0.150
     0.478    28.094     0.150
     0.796    14.930     0.150
     0.796    25.398     0.150
     0.796    14.953     0.150
     0.796    25.344     0.150
     0.796    31.672     0.150
     0.796    34.109     0.150
     1.616    27.820     0.150
     1.616    49.312     0.150
     1.618    48.617     0.150
     1.618    60.453     0.150
     2.320    38.055     0.150
     2.345    40.453     0.150
     3.739    56.219     0.150
     4.663    70.570     0.150
     5.620    84.086     0.150
     6.124   192.070     0.150
     7.894   120.398     0.150
     8.101   114.750     0.150
     8.101   252.953     0.150
    10.925   339.898     0.150
    11.249   351.055     0.150
    14.822   212.797     0.150
    18.071   254.773     0.150
    18.668   259.375     0.150
    19.614   271.000     0.150
    27.069   338.398     0.150
    27.535   348.961     0.150
    34.702   411.391     0.150
   102.206   842.922     0.150
   107.380   866.320     0.150
   107.380  1141.719     0.150
   107.380  2056.320     0.150
     0.228     4.485     0.150
     0.228     7.735     0.150
     0.487    19.836     0.150
     0.723    13.386     0.150
     0.723    23.336     0.150
     0.723    27.865     0.150
     0.791    14.905     0.150
     0.791    25.436     0.150
     0.791    14.905     0.150
     0.791    25.436     0.150
     0.791    26.625     0.150
     0.924    31.655     0.150
     0.924    15.964     0.150
     0.924    27.982     0.150
     1.106    18.687     0.150
     1.106    32.832     0.150
     1.622    27.936     0.150
     1.622    49.495     0.150
     2.496    41.426     0.150
     2.496    47.695     0.150
     4.666   142.955     0.150
     4.722    64.756     0.150
     5.538    80.096     0.150
     5.538   100.945     0.150
     6.540   119.355     0.150
     6.547   111.516     0.150
     6.547   170.466     0.150
     6.547   197.875     0.150
     6.560   116.945     0.150
     6.777    98.780     0.150
     7.537   233.985     0.150
     8.059   147.695     0.150
     8.059   256.665     0.150
     8.097   155.484     0.150
     8.097   254.375     0.150
     8.119   257.995     0.150
    10.707   166.625     0.150
    10.934   350.788     0.150
     0.062     1.574     0.150
     0.118     2.445     0.150
     0.134     2.635     0.150
     0.134     5.096     0.150
     0.177     3.754     0.150
     0.200     3.945     0.150
     0.200     7.145     0.150
     0.202     3.846     0.150
     0.537    10.426     0.150
     0.537    18.725     0.150
     0.537    20.904     0.150
     0.647    12.025     0.150
     0.753    13.814     0.150
     0.740    13.676     0.150
     0.772    14.426     0.150
     0.772    14.426     0.150
     0.772    27.025     0.150
     1.189    21.686     0.150
     1.189    37.645     0.150
     1.197    21.744     0.150
     1.197    37.824     0.150
     1.386    42.855     0.150
     1.664    28.484     0.150
     1.664    51.686     0.150
     1.665    29.686     0.150
     1.665    53.074     0.150
     2.472    47.365     0.150
     3.070    59.135     0.150
     7.545   243.645     0.150
     0.233     4.348     0.150
     0.233     7.367     0.150
     0.233    10.877     0.150
     0.599    10.848     0.150
     0.603    11.258     0.150
     0.622    12.178     0.150
     0.688    12.396     0.150
     0.690    12.877     0.150
     0.719    12.637     0.150
     0.716    12.736     0.150
     0.797    22.977     0.150
     0.797    14.678     0.150
     0.839    15.326     0.150
     1.148    21.008     0.150
     1.149    21.248     0.150
     1.149    37.438     0.150
     1.184    21.207     0.150
     1.184    36.977     0.150
     1.184    41.168     0.150
     1.243    22.537     0.150
     1.243    39.807     0.150
     1.280    22.088     0.150
     1.310    23.627     0.150
     1.310    41.057     0.150
     1.736    51.377     0.150
     3.359   109.137     0.150
     4.277    64.592     0.150
     4.370    67.387     0.150
     4.510    64.918     0.150
     4.510    87.918     0.150
     7.856   254.797     0.150
     7.856   114.768     0.150
     7.856   254.797     0.150
    10.382   333.307     0.150
    16.121   228.646     0.150
     0.233     4.619     0.150
     0.233     7.498     0.150
     0.233    10.609     0.150
     0.233    13.299     0.150
     0.603    10.498     0.150
     0.624    12.309     0.150
     0.624    21.189     0.150
     0.624    22.959     0.150
     0.688    12.408     0.150
     0.717    14.008     0.150
     0.692    12.838     0.150
     0.766    14.008     0.150
     0.799    14.619     0.150
     0.799    25.719     0.150
     0.841    15.311     0.150
     0.914    16.209     0.150
     1.148    21.049     0.150
     1.148    37.838     0.150
     1.186    21.328     0.150
     1.186    21.328     0.150
     1.186    37.568     0.150
     1.186    44.088     0.150
     1.244    22.609     0.150
     1.244    39.648     0.150
     1.312    23.520     0.150
     1.312    41.418     0.150
     4.372    67.459     0.150
     4.372    79.559     0.150
     4.512    70.789     0.150
     4.512    88.658     0.150
     6.155    88.889     0.150
     7.916   110.678     0.150
    11.464   159.789     0.150
     0.084     2.037     0.150
     0.084     2.177     0.150
     0.144     2.997     0.150
     0.227     4.417     0.150
     0.228     4.525     0.150
     0.218     4.457     0.150
     0.218     7.577     0.150
     0.446     8.417     0.150
     0.478     9.117     0.150
     0.478     9.107     0.150
     0.491     9.917     0.150
     0.561    10.667     0.150
     0.717    13.137     0.150
     0.714    13.327     0.150
     0.714    23.287     0.150
     0.780    14.637     0.150
     0.780    14.637     0.150
     0.780    24.847     0.150
     1.175    21.557     0.150
     1.175    36.817     0.150
     1.368    22.418     0.150
     1.619    26.157     0.150
     1.615    27.307     0.150
     1.615    49.027     0.150
     2.146    33.608     0.150
     2.771    47.997     0.150
     2.780    42.538     0.150
     2.793    42.684     0.150
     3.404    85.177     0.150
     3.733    55.799     0.150
     4.316    64.825     0.150
     4.678    70.168     0.150
     6.123   111.047     0.150
     6.123   192.137     0.150
     6.123   111.044     0.150
     6.123   192.140     0.150
     6.552   100.957     0.150
     7.923   123.217     0.150
     8.106   251.603     0.150
     8.106   251.597     0.150
     9.863   142.691     0.150
    10.030   149.837     0.150
    10.760   160.737     0.150
    10.839   163.347     0.150
    10.940   338.376     0.150
    11.259   350.827     0.150
    11.492   169.867     0.150
    11.561   163.001     0.150
    11.892   168.493     0.150
    11.992   169.882     0.150
    11.983   175.217     0.150
    12.604   178.886     0.150
    13.088   185.004     0.150
    13.186   187.382     0.150
    13.465   197.307     0.150
    13.770   197.827     0.150
    14.573   205.892     0.150
    14.821   213.067     0.150
    15.641   489.052     0.150
    15.641   489.047     0.150
    16.042   230.687     0.150
    17.207   239.357     0.150
    23.905   317.797     0.150
    24.156   318.937     0.150
    27.535   347.907     0.150
    34.701   415.117     0.150
    37.144   436.197     0.150
    40.702   459.767     0.150
    55.432   579.677     0.150
    79.718   732.977     0.150
    80.883   738.677     0.150
    82.145   745.477     0.150
    83.735   753.477     0.150
    83.773   754.077     0.150
    83.870   754.177     0.150
    84.185   755.577     0.150
    84.491   757.477     0.150
    91.397   789.607     0.150
     0.519    10.117     0.150
     0.761    13.660     0.150
     0.761    23.008     0.150
     1.086    18.328     0.150
     1.618    27.461     0.150
     1.632    27.320     0.150
     2.278    37.234     0.150
     2.668    42.648     0.150
     6.812    99.066     0.150
     7.562   112.230     0.150
     8.096   123.508     0.150
     8.565   122.750     0.150
    11.260   364.816     0.150
     0.139     3.246     0.150
     0.139     5.785     0.150
     0.605    22.266     0.150
     0.711    13.295     0.150
     0.711    23.006     0.150
     0.755    13.865     0.150
     0.755    24.115     0.150
     0.755    28.236     0.150
     1.019    30.666     0.150
     1.019    17.176     0.150
     1.150    20.885     0.150
     1.150    35.896     0.150
     1.429    47.236     0.150
     1.687    29.115     0.150
     1.687    52.566     0.150
     2.193    36.041     0.150
     4.729    67.846     0.150
     4.729    85.965     0.150
     5.477    98.975     0.150
     5.477   170.736     0.150
     5.658   174.725     0.150
     5.706   103.205     0.150
     5.706    84.762     0.150
     6.044   109.686     0.150
     6.452   116.006     0.150
     6.464   117.625     0.150
     6.574   119.555     0.150
     7.550   137.125     0.150
     7.599   138.555     0.150
     7.599   236.426     0.150
     7.774   110.225     0.150
     7.774   237.076     0.150
     7.907   146.355     0.150
     7.907   250.066     0.150
     8.212   115.748     0.150
     8.212   149.896     0.150
     8.212   249.316     0.150
    11.052   155.961     0.150
    11.052   342.035     0.150
     0.065     1.332     0.150
     0.298     9.840     0.150
     0.359     6.340     0.150
     0.359    10.734     0.150
     0.359     6.344     0.150
     0.414    15.973     0.150
     0.414     8.371     0.150
     0.414     8.434     0.150
     0.414    19.082     0.150
     0.596    11.211     0.150
     0.663    12.480     0.150
     0.783    14.254     0.150
     0.819    14.461     0.150
     0.819    14.461     0.150
     0.819    25.961     0.150
     0.819    26.043     0.150
     0.819    27.781     0.150
     0.904    26.664     0.150
     0.904    15.688     0.150
     0.904    27.883     0.150
     1.093    32.332     0.150
     1.182    21.367     0.150
     1.182    33.242     0.150
     1.182    34.793     0.150
     1.181    35.953     0.150
     1.174    19.152     0.150
     1.224    21.504     0.150
     1.261    18.402     0.150
     1.424    24.844     0.150
     1.489    25.801     0.150
     1.496    25.902     0.150
     1.534    26.414     0.150
     1.535    26.441     0.150
     1.550    26.863     0.150
     1.578    45.871     0.150
     1.556    26.832     0.150
     1.556    46.672     0.150
     1.557    26.992     0.150
     1.557    53.191     0.150
     1.645    28.082     0.150
     1.863    25.273     0.150
     2.176    65.988     0.150
     2.192    35.812     0.150
     2.293    37.230     0.150
     2.293    69.102     0.150
     2.411    73.082     0.150
     2.507    75.613     0.150
     2.527    72.273     0.150
     2.725    82.902     0.150
     2.954    46.672     0.150
     2.954    89.715     0.150
     3.565    55.363     0.150
     3.603    55.871     0.150
     3.603   109.605     0.150
     4.661    70.223     0.150
     5.605    80.883     0.150
     5.750   179.293     0.150
     6.569    94.664     0.150
     6.623   205.191     0.150
     8.151   129.242     0.150
     8.151   129.242     0.150
     8.151   255.242     0.150
     8.837   127.043     0.150
     9.601   135.613     0.150
     9.688   140.172     0.150
     9.839   139.121     0.150
    10.323   152.934     0.150
    10.679   339.684     0.150
    10.679   339.684     0.150
    10.897   157.520     0.150
    10.951   158.004     0.150
    12.138   172.051     0.150
    12.138   321.953     0.150
    12.416   181.363     0.150
    12.428   177.992     0.150
    12.462   175.711     0.150
    12.737   179.973     0.150
    12.988   182.633     0.150
    13.459   334.914     0.150
    13.766   193.691     0.150
    14.291   355.191     0.150
    14.436   201.402     0.150
    14.436   357.441     0.150
    14.737   359.332     0.150
    15.264   222.293     0.150
    15.316   224.094     0.150
    15.442   214.293     0.150
    15.429   214.723     0.150
    15.861   216.023     0.150
    15.984   231.344     0.150
    16.830   233.320     0.150
    20.696   279.133     0.150
    24.473   318.012     0.150
    34.766   409.992     0.150
    37.400   438.262     0.150
    37.975   435.992     0.150
    40.423   458.031     0.150
    64.266  1151.941     0.150
     0.059     1.066     0.150
     0.347     6.137     0.150
     0.427     1.449     0.150
     0.427     7.719     0.150
     0.427     8.457     0.150
     0.427    24.039     0.150
     0.600    11.559     0.150
     0.772    23.727     0.150
     0.814    15.059     0.150
     0.814    30.289     0.150
     0.907    15.598     0.150
     0.907    27.121     0.150
     1.111    17.738     0.150
     1.177    19.617     0.150
     1.182    36.617     0.150
     1.168    32.270     0.150
     1.168    19.410     0.150
     1.275    17.039     0.150
     1.275    34.617     0.150
     1.638    27.836     0.150
     2.532    41.898     0.150
     2.580    40.637     0.150
     2.832    48.309     0.150
     3.929    64.527     0.150
     3.929    78.469     0.150
     4.217    67.227     0.150
     4.786    75.977     0.150
     7.515   108.129     0.150
     7.905   110.309     0.150
     8.847   127.363     0.150
    10.020   144.527     0.150
    10.665   153.488     0.150
    11.499   171.066     0.150
    12.979   185.406     0.150
    14.077   198.367     0.150
    14.873   213.918     0.150
    15.253   223.930     0.150
    22.974   308.203     0.150
    24.473   318.520     0.150
    27.586   352.180     0.150
    34.753   409.566     0.150
    37.192   428.867     0.150
    37.427   437.270     0.150
    37.674   432.387     0.150
    47.657   522.117     0.150
    82.142   745.578     0.150
    82.142   745.578     0.150
    83.584   751.879     0.150
    83.689   753.879     0.150
    83.689   753.879     0.150
    83.720   753.777     0.150
    83.720   753.777     0.150
    83.733   753.977     0.150
    83.733   753.977     0.150
    83.772   754.277     0.150
    83.772   754.277     0.150
    83.812   754.578     0.150
    83.812   754.578     0.150
    83.837   754.078     0.150
    83.837   754.078     0.150
    83.867   754.477     0.150
    83.867   754.477     0.150
    84.184   755.777     0.150
    84.184   755.777     0.150
    84.288   757.379     0.150
    84.288   757.379     0.150
    84.318   755.953     0.150
    84.408   757.180     0.150
    84.408   757.180     0.150
    84.493   757.777     0.150
    84.493   757.777     0.150
    84.652   758.578     0.150
    84.652   758.578     0.150
    84.868   759.578     0.150
    84.868   759.578     0.150
     0.066     1.336     0.150
     0.359     6.344     0.150
     0.415    18.055     0.150
     0.415    18.773     0.150
     0.818    27.695     0.150
     1.182    18.820     0.150
     1.182    19.703     0.150
     2.542    36.219     0.150
     3.200    43.797     0.150
     4.663    68.797     0.150
     5.751    88.164     0.150
     6.624   113.234     0.150
     7.419   107.047     0.150
     9.841   133.945     0.150
    10.869   161.250     0.150
    10.869   347.375     0.150
     0.782    14.143     0.150
     0.782    25.174     0.150
     0.782    25.123     0.150
     0.933    15.861     0.150
     1.100    18.271     0.150
     1.100    32.256     0.150
     1.181    42.883     0.150
     1.624    28.193     0.150
     1.624    51.613     0.150
     2.644    75.062     0.150
     2.644    39.750     0.150
     3.906   103.193     0.150
     5.536   147.902     0.150
     6.114   110.838     0.150
     8.066   115.652     0.150
     8.128   116.238     0.150
     8.903   126.104     0.150
    10.943   337.938     0.150
     0.196    16.703     0.150
     0.196    23.352     0.150
     0.208     8.117     0.150
     0.794    24.789     0.150
     0.832    25.367     0.150
     1.150    20.633     0.150
     1.150    36.602     0.150
     1.150    20.555     0.150
     1.150    36.586     0.150
     1.150    37.586     0.150
     1.153    35.852     0.150
     1.179    21.836     0.150
     1.179    37.375     0.150
     1.414    40.953     0.150
     1.655    50.305     0.150
     1.690    26.984     0.150
     1.936    31.820     0.150
     2.099    64.789     0.150
     2.854    43.797     0.150
     3.315    47.727     0.150
     3.835    61.805     0.150
     4.466    71.773     0.150
     4.931   134.273     0.150
     4.931    76.062     0.150
     4.931   134.273     0.150
     6.046    94.188     0.150
     6.118    84.203     0.150
     7.117   228.031     0.150
     8.337   117.047     0.150
     8.452   121.625     0.150
     8.507   120.828     0.150
     9.698   140.094     0.150
    10.420   321.344     0.150
    10.531   156.656     0.150
    11.182   158.898     0.150
    12.733   178.562     0.150
    13.290   191.453     0.150
    77.409   718.602     0.150
   107.861   867.305     0.150
   107.861  1593.805     0.150
     0.308    13.145     0.150
     0.850    14.934     0.150
     1.360    23.324     0.150
     1.778    51.746     0.150
     1.823    28.773     0.150
     2.041    31.516     0.150
     3.181    93.344     0.150
     3.797   110.246     0.150
     3.853   114.633     0.150
     4.653    70.273     0.150
     6.167    94.805     0.150
     6.785   103.734     0.150
     6.785   223.328     0.150
     7.504   108.543     0.150
     7.829   111.754     0.150
     7.829   235.004     0.150
     7.829   235.004     0.150
     7.948   112.793     0.150
    11.477   167.500     0.150
     0.164     3.395     0.150
     0.279     4.734     0.150
     0.573    16.723     0.150
     0.573    10.922     0.150
     0.573    23.742     0.150
     0.658    16.824     0.150
     0.737    13.453     0.150
     0.737    22.863     0.150
     0.737    33.043     0.150
     0.981    16.844     0.150
     2.367    70.152     0.150
     3.849    55.871     0.150
     4.706    67.184     0.150
     5.489    99.562     0.150
     6.475   116.691     0.150
     6.483   117.973     0.150
     0.392    17.082     0.150
     0.731    26.582     0.150
     0.731    27.812     0.150
     1.065    19.682     0.150
     1.065    35.953     0.150
     1.350    21.963     0.150
     1.350    38.783     0.150
     1.350    21.963     0.150
     1.350    38.783     0.150
     1.350    45.762     0.150
     1.921    30.193     0.150
     1.921    55.963     0.150
     2.336    42.303     0.150
     2.751    45.406     0.150
     3.286    93.703     0.150
     3.527    56.771     0.150
     4.556    69.992     0.150
     4.556   146.672     0.150
     5.411    81.162     0.150
     6.330    91.512     0.150
     6.330   163.092     0.150
     6.860   109.213     0.150
     7.337   106.953     0.150
     7.766   143.258     0.150
     7.953   113.363     0.150
     7.953   257.203     0.150
     8.662   279.182     0.150
    10.210   324.533     0.150
    38.127   438.482     0.150
     0.648    23.258     0.150
     1.128    20.438     0.150
     1.128    35.078     0.150
     1.128    20.438     0.150
     1.128    39.566     0.150
     1.190    21.238     0.150
     1.273    22.707     0.150
     1.273    38.648     0.150
     1.273    22.715     0.150
     1.273    22.715     0.150
     1.273    44.746     0.150
     1.602    25.438     0.150
     3.849    58.695     0.150
     6.384    93.148     0.150
     7.444   107.898     0.150
     0.658    11.883     0.150
     0.775    28.469     0.150
     0.796    25.945     0.150
     1.193    19.898     0.150
     1.236    21.344     0.150
     1.236    37.992     0.150
     1.236    47.008     0.150
     1.357    23.648     0.150
     1.357    43.211     0.150
     1.357    23.680     0.150
     1.358    54.812     0.150
     1.764    27.672     0.150
     2.610    40.406     0.150
     3.097    47.680     0.150
     3.195    52.250     0.150
     3.403    53.820     0.150
     3.612    57.281     0.150
     4.245    72.977     0.150
     4.629    69.312     0.150
     5.908    90.969     0.150
     5.955    85.719     0.150
     6.535    99.750     0.150
     6.535   127.000     0.150
     6.572    91.141     0.150
     7.048    99.852     0.150
     7.560   108.391     0.150
     7.726   238.125     0.150
     7.726   238.133     0.150
     7.854   254.727     0.150
     8.026   112.148     0.150
     8.139   113.609     0.150
     8.339   124.703     0.150
     8.339   267.148     0.150
     8.339   267.828     0.150
     8.697   122.969     0.150
     8.699   122.258     0.150
     9.228   130.094     0.150
     9.515   134.250     0.150
     9.580   144.250     0.150
     9.649   135.594     0.150
    10.390   147.117     0.150
    10.373   332.000     0.150
    10.714   152.102     0.150
    11.019   154.508     0.150
    11.172   158.328     0.150
    11.258   159.141     0.150
    11.480   162.453     0.150
    11.578   164.773     0.150
    11.702   165.703     0.150
    12.197   172.969     0.150
    12.555   179.188     0.150
    13.112   184.828     0.150
    13.208   183.227     0.150
    13.897   192.789     0.150
    13.897   340.117     0.150
    14.618   373.859     0.150
    15.924   229.852     0.150
    16.254   233.852     0.150
    16.450   237.242     0.150
    74.412   700.484     0.150
     0.828    27.055     0.150
     0.931    27.119     0.150
     1.175    21.330     0.150
     1.175    38.209     0.150
     1.175    21.379     0.150
     1.138    21.160     0.150
     1.138    34.969     0.150
     1.176    21.400     0.150
     1.685    26.840     0.150
     2.150    41.709     0.150
     3.660   107.750     0.150
     6.120    89.979     0.150
     6.657   102.439     0.150
     6.785   184.559     0.150
     8.510   274.740     0.150
     8.929   289.930     0.150
    10.431   324.629     0.150
    11.584   170.670     0.150
    11.611   170.740     0.150
    12.155   179.141     0.150
    12.158   172.340     0.150
    12.737   180.180     0.150
    13.295   190.650     0.150
    13.382   193.219     0.150
    14.578   208.959     0.150
    15.736   223.812     0.150
     0.028     1.445     0.150
     0.574    11.035     0.150
     0.574    28.165     0.150
     0.730    13.716     0.150
     0.730    22.756     0.150
     0.730    13.705     0.150
     0.730    24.896     0.150
     1.042    17.775     0.150
     1.042    31.575     0.150
     1.667    28.676     0.150
     1.667    50.146     0.150
     1.667    28.596     0.150
     1.668    56.966     0.150
     2.374    67.462     0.150
     2.724    83.460     0.150
     3.325    51.125     0.150
     3.853   109.825     0.150
     3.853    57.865     0.150
     3.853   109.815     0.150
     4.274    64.346     0.150
     4.274   125.216     0.150
     4.348    63.585     0.150
     4.713    70.605     0.150
     5.022    75.375     0.150
     5.494    81.545     0.150
     5.488    81.756     0.150
     5.610    81.815     0.150
     6.064   190.443     0.150
     6.213    92.065     0.150
     6.213   162.516     0.150
     6.477    94.646     0.150
     6.571    97.596     0.150
     7.155   103.146     0.150
     7.155   182.915     0.150
     7.236   107.155     0.150
     7.768   114.686     0.150
     7.813   114.325     0.150
     7.909   116.096     0.150
     8.188   119.466     0.150
     9.345   143.226     0.150
     9.426   136.835     0.150
     9.517   138.525     0.150
     9.861   144.365     0.150
     9.861   253.636     0.150
     9.979   145.426     0.150
    10.537   321.567     0.150
    10.576   151.035     0.150
    10.936   158.926     0.150
    11.021   158.455     0.150
    11.070   159.325     0.150
    11.257   353.375     0.150
    12.046   172.775     0.150
    12.367   178.375     0.150
    12.420   177.405     0.150
    12.626   183.865     0.150
    13.214   189.785     0.150
    13.323   193.417     0.150
    13.323   193.445     0.150
    13.909   199.136     0.150
    14.314   202.549     0.150
    14.411   204.355     0.150
    14.723   209.695     0.150
    14.765   210.766     0.150
    15.454   215.929     0.150
    15.600   221.617     0.150
    15.663   400.186     0.150
    16.856   238.025     0.150
    16.867   236.673     0.150
    17.372   244.155     0.150
    18.695   259.056     0.150
    20.620   279.545     0.150
    21.660   291.686     0.150
    22.135   296.636     0.150
    22.631   302.096     0.150
    23.392   310.705     0.150
    24.147   316.176     0.150
    24.601   321.466     0.150
    24.697   322.195     0.150
    27.201   344.905     0.150
    28.868   359.235     0.150
    29.335   364.346     0.150
    29.848   367.326     0.150
    29.848   551.025     0.150
    29.936   368.715     0.150
    33.778   403.156     0.150
    34.361   408.375     0.150
    35.306   416.625     0.150
    35.464   417.996     0.150
    35.974   422.385     0.150
    36.134   424.275     0.150
    36.185   424.676     0.150
    37.026   430.025     0.150
    37.094   431.426     0.150
    37.267   433.375     0.150
    37.311   433.326     0.150
    37.680   436.885     0.150
    37.680   572.195     0.150
    37.904   436.195     0.150
    38.136   441.295     0.150
    38.908   448.125     0.150
    38.908   448.125     0.150
    43.348   482.225     0.150
    45.869   501.535     0.150
    46.831   512.225     0.150
    46.831   511.225     0.150
    47.007   516.336     0.150
    47.967   526.195     0.150
    50.757   540.725     0.150
    55.424   575.525     0.150
    55.424  1043.525     0.150
    55.544   630.025     0.150
    60.112   606.826     0.150
    62.048  1128.625     0.150
    64.717   638.545     0.150
    65.875   646.326     0.150
    66.686   650.406     0.150
    66.764   652.676     0.150
    69.113  5186.896     0.150
    69.118  5193.725     0.150
    69.131  5195.062     0.150
    69.862  5216.973     0.150
    69.867  5226.971     0.150
    69.880  5217.955     0.150
    71.970   946.426     0.150
    71.970   683.355     0.150
    72.839   687.785     0.150
    73.434  1261.326     0.150
    74.272   697.625     0.150
    75.242   703.805     0.150
    76.167   708.385     0.150
    77.198   714.625     0.150
    77.198   713.926     0.150
    77.410   996.025     0.150
    77.410  1809.525     0.150
    77.422   721.525     0.150
    77.422  1355.525     0.150
    77.640   718.045     0.150
    78.695   723.426     0.150
    79.423   726.525     0.150
    79.423   726.525     0.150
    79.500   731.426     0.150
    79.737   728.426     0.150
    79.737   728.426     0.150
    79.763   729.725     0.150
    79.755   732.426     0.150
    79.851   728.926     0.150
    79.851   728.926     0.150
    79.978   731.326     0.150
    79.990   732.525     0.150
    80.369   735.025     0.150
    80.608   733.426     0.150
    80.608   733.426     0.150
    80.652   733.826     0.150
    80.652   733.826     0.150
    80.665   734.225     0.150
    80.690   735.125     0.150
    80.899   735.025     0.150
    80.899   735.025     0.150
    80.937   735.416     0.150
    81.003   736.025     0.150
    81.003   736.025     0.150
    81.108   736.926     0.150
    81.264   737.246     0.150
    81.337   737.426     0.150
    81.388   737.926     0.150
    81.577   738.625     0.150
    81.593   739.025     0.150
    81.593  1355.926     0.150
    81.593  1667.725     0.150
    81.644   739.826     0.150
    81.699   739.225     0.150
    82.068   741.225     0.150
    82.068   741.225     0.150
    82.097   741.625     0.150
    82.163   741.625     0.150
    82.163   741.625     0.150
    82.330   742.725     0.150
    82.330   742.725     0.150
    82.378   741.426     0.150
    82.390  1661.244     0.150
    82.390  1897.514     0.150
    82.394   743.426     0.150
    82.394  1354.025     0.150
    82.394  1680.125     0.150
    82.446   746.426     0.150
    82.462   743.426     0.150
    82.532   743.895     0.150
    82.530   744.225     0.150
    82.600   744.625     0.150
    82.650   750.125     0.150
    82.743  1688.426     0.150
    82.824   747.326     0.150
    82.837   744.426     0.150
    82.837  1363.926     0.150
    82.837   745.926     0.150
    82.938   746.025     0.150
    83.041   746.725     0.150
    83.171   747.225     0.150
    83.255   748.615     0.150
    83.339   749.326     0.150
    83.358   748.125     0.150
    83.382   748.525     0.150
    83.382  1371.926     0.150
    83.534   748.826     0.150
    83.603   748.926     0.150
    83.603   748.926     0.150
    83.712   749.926     0.150
    83.712   749.926     0.150
    83.731   749.725     0.150
    83.749   749.926     0.150
    83.749   749.926     0.150
    83.751   749.725     0.150
    83.751   749.725     0.150
    83.787   750.125     0.150
    83.787   750.125     0.150
    83.805   749.625     0.150
    83.805   749.625     0.150
    83.822   750.625     0.150
    83.854   750.125     0.150
    83.854   750.125     0.150
    83.888   750.525     0.150
    83.888   750.525     0.150
    84.200   751.725     0.150
    84.200   751.725     0.150
    84.202   752.895     0.150
    84.317   753.326     0.150
    84.317   753.326     0.150
    84.430   753.225     0.150
    84.430   753.225     0.150
    84.503   753.625     0.150
    84.503   753.625     0.150
    84.660   754.525     0.150
    84.660   754.525     0.150
    84.735   754.826     0.150
    84.735   754.826     0.150
    85.084   766.525     0.150
    85.084   949.525     0.150
    85.084  1933.525     0.150
    85.084   756.125     0.150
    85.084   766.525     0.150
    85.084  1384.525     0.150
    85.213   757.826     0.150
    85.213   757.836     0.150
    85.232   757.926     0.150
    85.349   758.025     0.150
    85.349   758.025     0.150
    85.532   760.096     0.150
    85.565   759.225     0.150
    85.565   759.225     0.150
    85.659   760.025     0.150
    85.659   769.625     0.150
    85.659   954.025     0.150
    85.801  1731.525     0.150
    85.801   760.426     0.150
    85.801   760.326     0.150
    85.801  1731.525     0.150
    85.845   760.326     0.150
    85.845   760.326     0.150
    85.951   760.826     0.150
    86.322   763.426     0.150
    86.322   965.125     0.150
    86.322  1392.225     0.150
    86.423   763.125     0.150
    86.423   763.125     0.150
    86.436   763.826     0.150
    86.436   763.826     0.150
    86.458   764.025     0.150
    86.458   764.025     0.150
    86.703   763.826     0.150
    86.725   764.426     0.150
    86.725   774.025     0.150
    86.725   969.225     0.150
    86.725  1394.025     0.150
    86.725  1454.225     0.150
    86.774   764.926     0.150
    86.774  1392.525     0.150
    86.924   765.625     0.150
    86.920   765.826     0.150
    86.973   765.625     0.150
    86.973  1395.926     0.150
    86.973  1456.826     0.150
    87.010   766.025     0.150
    87.010   766.025     0.150
    87.171   767.025     0.150
    87.171   777.326     0.150
    87.171  1409.326     0.150
    87.243   766.756     0.150
    87.243   766.926     0.150
    87.570   769.125     0.150
    87.652   769.326     0.150
    87.652   779.025     0.150
    87.652  1401.025     0.150
    87.681   769.426     0.150
    87.725   768.525     0.150
    87.725   768.525     0.150
    87.725  1093.525     0.150
    87.766   769.125     0.150
    87.766   769.125     0.150
    87.854   769.525     0.150
    87.854   769.525     0.150
    88.096   771.426     0.150
    88.108   771.525     0.150
    88.108   771.445     0.150
    88.299   772.625     0.150
    88.299   978.025     0.150
    88.299  1402.625     0.150
    88.299  1418.625     0.150
    88.424   780.326     0.150
    88.629   773.625     0.150
    88.629   773.605     0.150
    89.079   774.426     0.150
    89.079   783.426     0.150
    89.079  1495.225     0.150
    89.108   776.625     0.150
    89.427   984.525     0.150
    89.469   778.125     0.150
    89.827   780.625     0.150
    90.189   781.625     0.150
    90.301   781.426     0.150
    90.505   792.926     0.150
    90.528   783.625     0.150
    90.609   782.725     0.150
    90.803  1004.225     0.150
    91.125   785.625     0.150
    91.125  1121.225     0.150
    91.125   785.756     0.150
    91.331   787.225     0.150
    91.392   785.826     0.150
    91.392   785.926     0.150
    91.457   786.615     0.150
    91.458   786.025     0.150
    91.909  1816.826     0.150
    92.788   793.826     0.150
    93.072   795.025     0.150
    93.072  1018.525     0.150
    93.091   794.326     0.150
    94.458   801.215     0.150
    94.485   801.525     0.150
    94.567   800.525     0.150
    94.567  1025.525     0.150
    94.567  1429.525     0.150
    94.567  1464.525     0.150
    94.567  1543.525     0.150
    94.572   801.525     0.150
    94.726  1482.326     0.150
    94.726  1859.625     0.150
    94.822   802.826     0.150
    94.859   802.826     0.150
    95.917   807.225     0.150
    95.986  1042.525     0.150
    95.986   807.666     0.150
    95.986  1042.506     0.150
    96.236   808.826     0.150
    96.397   809.426     0.150
    96.640   810.826     0.150
    96.640   810.836     0.150
    97.231   814.125     0.150
    97.681   815.826     0.150
    99.169  1459.525     0.150
   101.156   822.826     0.150
   101.274   830.926     0.150
   101.274  2184.125     0.150
   101.537  1074.301     0.150
   102.635   834.326     0.150
   102.635  1089.225     0.150
   106.460  1116.826     0.150
   108.582  1137.025     0.150
   108.582  1323.125     0.150
   112.493  2103.926     0.150
   115.949  1123.086     0.150
   118.768  1744.625     0.150
   118.768  1128.725     0.150
   119.200  1130.326     0.150
   125.067  2259.525     0.150
   131.792  1153.705     0.150
   139.723  1170.326     0.150
   143.134  1172.836     0.150
   145.024  1176.525     0.150
   145.575  1180.045     0.150
   146.472  1181.926     0.150
   146.472  1182.025     0.150
     0.615    11.225     0.150
     0.601    24.285     0.150
     0.601    25.205     0.150
     0.752    28.725     0.150
     1.023    17.604     0.150
     1.683    60.984     0.150
     2.197    64.117     0.150
     4.728    71.375     0.150
     4.728   154.615     0.150
     5.297   166.404     0.150
     5.481    99.945     0.150
     5.481   153.924     0.150
     5.661   170.615     0.150
     5.704   104.035     0.150
     5.704   189.264     0.150
     6.048   189.996     0.150
     6.456   198.785     0.150
     6.468   100.555     0.150
     6.554   205.064     0.150
     7.547   137.994     0.150
     7.598   237.834     0.150
     7.633   239.705     0.150
     7.909   120.215     0.150
     8.066   122.035     0.150
     8.066   151.414     0.150
     8.066   254.244     0.150
     8.110   246.484     0.150
     8.210   136.539     0.150
     8.210   136.545     0.150
     8.210   256.564     0.150
    10.489   147.834     0.150
    10.517   337.330     0.150
    11.048   342.721     0.150
    11.259   354.188     0.150
    12.363   178.275     0.150
    12.692   183.426     0.150
    21.341   291.254     0.150
    21.730   293.395     0.150
    40.272   457.324     0.150
     0.608    -0.361     0.150
     0.608     8.648     0.150
     0.712    13.068     0.150
     0.712    22.600     0.150
     1.014    17.549     0.150
     1.205    40.330     0.150
     1.433    20.590     0.150
     1.690    28.139     0.150
     1.690    28.139     0.150
     1.690    50.129     0.150
     5.705    85.219     0.150
     6.040   190.775     0.150
     8.059   249.645     0.150
     8.212   253.020     0.150
    11.054   342.734     0.150
    11.255   354.244     0.150
    13.182   187.230     0.150
     0.022     1.074     0.150
     0.148     2.914     0.150
     0.174     3.275     0.150
     0.174     6.414     0.150
     0.161     3.225     0.150
     0.161     5.564     0.150
     0.217     4.395     0.150
     0.239     4.424     0.150
     0.234     3.875     0.150
     0.297     5.004     0.150
     0.297     5.004     0.150
     0.409     8.154     0.150
     0.558     0.686     0.150
     0.558     9.174     0.150
     0.558    27.004     0.150
     0.644    17.936     0.150
     0.651    11.865     0.150
     0.651    20.375     0.150
     0.730    13.414     0.150
     0.732    13.695     0.150
     0.732    23.074     0.150
     0.732    13.695     0.150
     0.732    23.465     0.150
     1.152    21.016     0.150
     1.152    36.686     0.150
     1.161    21.096     0.150
     1.161    36.965     0.150
     1.185    41.516     0.150
     1.651    28.154     0.150
     1.651    45.164     0.150
     1.652    26.725     0.150
     1.652    43.516     0.150
     2.238    36.916     0.150
     2.391    42.801     0.150
     5.510   100.625     0.150
     5.683    84.904     0.150
    11.008   357.285     0.150
    14.402   207.648     0.150
     0.714    28.242     0.150
     1.437    58.562     0.150
     5.288    77.172     0.150
     0.800    28.559     0.150
     1.145    18.969     0.150
     2.603    39.270     0.150
     2.812    44.998     0.150
     3.124    49.896     0.150
     3.771    58.469     0.150
     5.619    83.959     0.150
     5.725    87.748     0.150
     6.155   111.529     0.150
     6.754    98.148     0.150
     8.065   258.498     0.150
     8.128   142.484     0.150
    14.323   205.207     0.150
    37.406   437.309     0.150
     0.175    10.996     0.150
     0.717    26.086     0.150
     0.810    27.637     0.150
     1.120    20.488     0.150
     1.120    35.598     0.150
     1.120    20.496     0.150
     1.120    38.477     0.150
     1.200    21.617     0.150
     1.204    21.477     0.150
     1.201    21.777     0.150
     1.620    48.285     0.150
     1.655    26.445     0.150
     3.684    59.496     0.150
     3.862    52.266     0.150
     6.400    93.176     0.150
     7.887   252.812     0.150
    10.452   335.012     0.150
    11.459   172.086     0.150
    11.459   170.250     0.150
    11.459   370.387     0.150
    37.885   433.734     0.150
     0.153     6.625     0.150
     0.602    22.074     0.150
     1.625    26.027     0.150
     3.253    56.688     0.150
     4.226   129.965     0.150
     4.723    74.848     0.150
     5.480   170.277     0.150
     5.987   116.645     0.150
     6.597   104.508     0.150
     7.276    97.527     0.150
     7.585   107.098     0.150
     7.777   110.824     0.150
     8.026   116.746     0.150
     8.113   114.598     0.150
     8.169   114.926     0.150
    10.472   333.746     0.150
    11.439   359.121     0.150
    12.000   165.355     0.150
    12.075   164.656     0.150
    12.075   325.445     0.150
    37.854   440.895     0.150
     0.350    13.750     0.150
     0.394    18.180     0.150
     0.674    11.510     0.150
     0.741    14.479     0.150
     0.741    25.479     0.150
     0.741    26.840     0.150
     0.793    13.350     0.150
     0.878    15.900     0.150
     0.914    17.209     0.150
     1.004    17.330     0.150
     0.994    18.020     0.150
     0.994    33.189     0.150
     1.037    19.449     0.150
     1.070    20.010     0.150
     1.070    35.189     0.150
     1.070    19.910     0.150
     1.070    35.109     0.150
     1.408    23.469     0.150
     1.432    25.479     0.150
     1.432    45.590     0.150
     1.848    31.969     0.150
     1.924    31.920     0.150
     1.959    32.590     0.150
     1.970    33.439     0.150
     1.980    32.889     0.150
     2.253    37.039     0.150
     2.260    37.080     0.150
     3.964   118.357     0.150
     4.559    71.439     0.150
     4.687    67.309     0.150
     4.687    67.309     0.150
     4.687   122.229     0.150
     4.684    73.959     0.150
     8.084   246.039     0.150
     8.261   121.189     0.150
     8.314   118.770     0.150
     0.323     6.512     0.150
     0.323     6.551     0.150
     0.323    10.602     0.150
     0.323    14.832     0.150
     0.646    11.461     0.150
     0.727    12.559     0.150
     0.948    17.102     0.150
     0.982    16.719     0.150
     0.982    16.680     0.150
     0.982    30.152     0.150
     1.091    20.281     0.150
     1.091    34.660     0.150
     1.091    20.270     0.150
     1.091    20.441     0.150
     1.275    22.410     0.150
     1.275    39.652     0.150
     1.275    22.441     0.150
     1.638    26.320     0.150
     1.844    54.281     0.150
     1.844    29.680     0.150
     1.844    29.066     0.150
     1.844    53.293     0.150
     1.844    29.059     0.150
     1.844    54.281     0.150
     1.844    54.730     0.150
     1.883    30.422     0.150
     2.005    31.402     0.150
     2.016    31.844     0.150
     2.016    31.789     0.150
     2.631    40.672     0.150
     2.959    98.609     0.150
     3.822   110.625     0.150
     3.877   114.789     0.150
     4.478    66.391     0.150
     4.478    66.449     0.150
     4.611    68.320     0.150
     4.905    73.750     0.150
     5.264    79.270     0.150
     5.264   168.809     0.150
     5.627   152.641     0.150
     5.627   188.621     0.150
     5.839    87.102     0.150
     5.925    92.289     0.150
     6.801   214.289     0.150
     6.953   103.301     0.150
     7.288   106.281     0.150
     7.454   250.199     0.150
     7.491   242.531     0.150
     7.810   241.605     0.150
     7.810   112.859     0.150
     7.810   241.609     0.150
     7.810   250.621     0.150
     8.015   261.750     0.150
     8.061   255.801     0.150
     8.180   258.051     0.150
     9.667   139.219     0.150
     9.667   250.590     0.150
    10.286   315.199     0.150
    10.626   159.629     0.150
    11.115   157.750     0.150
    11.330   351.160     0.150
    12.195   173.621     0.150
    12.951   182.738     0.150
    13.251   191.020     0.150
    13.439   190.055     0.150
    13.514   197.539     0.150
    13.625   198.781     0.150
    13.886   193.852     0.150
    13.886   353.691     0.150
    13.932   202.902     0.150
    14.002   196.727     0.150
    14.728   206.520     0.150
    24.030   312.105     0.150
    28.392   355.641     0.150
    36.236   427.742     0.150
    37.762   439.852     0.150
    37.791   440.641     0.150
    39.074   451.379     0.150
    45.064   502.371     0.150
    45.885   506.891     0.150
    47.128   515.379     0.150
    55.727   578.180     0.150
    56.366  4132.680     0.150
    72.750   691.879     0.150
    77.759   718.762     0.150
    81.611   739.059     0.150
    82.661   746.570     0.150
    83.212   747.422     0.150
    84.321   755.980     0.150
    85.334   762.680     0.150
    87.406   767.570     0.150
    89.183   775.992     0.150
    91.092   777.180     0.150
   101.597  1465.879     0.150
   101.597  1959.879     0.150
   101.643   837.281     0.150
   112.551  1165.379     0.150
   127.149  1144.488     0.150
   144.975  1178.000     0.150
     0.237     4.885     0.150
     0.237     8.555     0.150
     0.237    10.064     0.150
     1.147    20.645     0.150
     1.147    35.975     0.150
     1.147    20.676     0.150
     1.195    21.154     0.150
     1.195    37.115     0.150
     1.195    38.496     0.150
     1.195    38.955     0.150
     1.709    50.350     0.150
     1.746    27.555     0.150
     2.497    74.887     0.150
     3.105    90.916     0.150
     3.154    52.395     0.150
     3.154    92.545     0.150
     3.777   112.223     0.150
     3.777   108.766     0.150
     4.380    67.455     0.150
    16.063   224.105     0.150
     0.169     3.578     0.150
     0.169     3.609     0.150
     0.196     4.350     0.150
     0.606    11.709     0.150
     0.606    20.168     0.150
     0.719    13.068     0.150
     0.907    15.299     0.150
     1.126    20.168     0.150
     1.126    20.168     0.150
     1.126    35.449     0.150
     1.126    40.658     0.150
     1.126    42.430     0.150
     1.208    21.180     0.150
     4.430    68.578     0.150
     8.069   257.109     0.150
     8.072   116.248     0.150
    11.741   166.898     0.150
    38.253   437.439     0.150
     0.350     7.504     0.150
     0.387    10.494     0.150
     0.387    18.014     0.150
     0.710    14.384     0.150
     0.973    18.294     0.150
     1.055    20.004     0.150
     1.055    36.344     0.150
     1.332    24.244     0.150
     1.332    41.464     0.150
     1.332    24.204     0.150
     1.332    46.514     0.150
     1.965    30.984     0.150
     4.547    70.028     0.150
     4.706    75.894     0.150
     4.706   135.204     0.150
     4.706    75.894     0.150
     4.648    70.914     0.150
     6.229    91.274     0.150
     6.349    97.714     0.150
     6.349   172.494     0.150
     6.349    97.714     0.150
     6.865   106.569     0.150
     6.865   133.319     0.150
     6.865   226.129     0.150
     7.786   112.204     0.150
     8.291   119.594     0.150
     9.692   147.154     0.150
     9.692   256.784     0.150
     9.692   147.154     0.150
     9.711   141.014     0.150
    10.724   153.534     0.150
    10.903   155.754     0.150
    11.774   167.624     0.150
    13.835   199.895     0.150
    74.712   704.269     0.150
     0.216    11.021     0.150
     0.216     4.241     0.150
     0.595    11.001     0.150
     0.695    12.491     0.150
     0.818    15.021     0.150
     0.856    25.600     0.150
     0.933    26.901     0.150
     0.933    15.690     0.150
     0.933    27.021     0.150
     1.162    21.150     0.150
     1.162    21.061     0.150
     1.162    36.501     0.150
     1.163    21.091     0.150
     1.168    34.071     0.150
     1.168    20.841     0.150
     1.168    44.690     0.150
     1.168    20.821     0.150
     1.168    34.071     0.150
     1.232    21.081     0.150
     1.425    24.971     0.150
     1.630    28.480     0.150
     1.697    29.110     0.150
     1.715    27.121     0.150
     1.746    29.791     0.150
     1.752    30.291     0.150
     1.824    30.940     0.150
     1.954    32.711     0.150
     2.035    34.011     0.150
     2.043    34.101     0.150
     2.081    34.631     0.150
     2.120    32.831     0.150
     2.123    36.041     0.150
     2.873    98.701     0.150
     4.349    66.971     0.150
     4.642    70.150     0.150
     5.470   170.480     0.150
     6.138    90.101     0.150
     6.138   198.911     0.150
     6.360    92.271     0.150
     6.683   103.641     0.150
     6.683   106.360     0.150
     6.683   220.866     0.150
     6.790   195.521     0.150
     7.160   131.940     0.150
     7.750   122.541     0.150
     7.817   253.940     0.150
     7.863   241.896     0.150
     7.863   241.900     0.150
     7.863   248.951     0.150
     7.909   245.641     0.150
     8.080   249.261     0.150
     8.086   248.061     0.150
    10.400   319.484     0.150
    16.104   234.466     0.150
    37.941   443.141     0.150
     0.214     4.336     0.150
     0.597    10.812     0.150
     0.597    18.688     0.150
     0.784    14.312     0.150
     0.784    24.914     0.150
     0.784    28.820     0.150
     0.784    29.445     0.150
     0.845    14.672     0.150
     0.845    24.258     0.150
     0.929    16.094     0.150
     0.929    28.344     0.150
     0.929    31.297     0.150
     1.001    16.852     0.150
     1.598    53.984     0.150
     1.863    32.102     0.150
     1.863    56.188     0.150
     1.864    55.727     0.150
     2.101    34.281     0.150
     2.527    38.992     0.150
     2.840    42.188     0.150
     4.433    87.586     0.150
     4.468    62.406     0.150
     5.488    83.727     0.150
     5.867   182.320     0.150
     5.939    91.641     0.150
     6.284    97.492     0.150
     7.753   119.797     0.150
     7.755   120.562     0.150
     7.840   120.852     0.150
     7.894   246.094     0.150
     7.986   116.227     0.150
     8.198   154.242     0.150
     8.198   255.547     0.150
     8.393   130.742     0.150
     8.393   273.625     0.150
     9.417   140.812     0.150
    11.135   362.914     0.150
    11.136   360.820     0.150
    12.760   190.125     0.150
    14.927   219.281     0.150
    94.533  1032.961     0.150
   100.798   823.867     0.150
   100.798   828.562     0.150
   100.798   830.961     0.150
     0.295     5.711     0.150
     0.295     9.801     0.150
     0.355     9.596     0.150
     0.355     6.211     0.150
     0.417     8.582     0.150
     0.417    20.021     0.150
     0.417    20.111     0.150
     0.417    23.732     0.150
     0.417    23.912     0.150
     0.681    24.842     0.150
     0.681    25.082     0.150
     0.781    14.232     0.150
     0.781    24.332     0.150
     0.904    15.742     0.150
     1.560    27.082     0.150
     1.560    49.002     0.150
     2.841    47.771     0.150
     3.805    59.441     0.150
     3.935    61.791     0.150
     3.978    64.742     0.150
     4.366    69.242     0.150
     6.620   101.312     0.150
     6.727    97.752     0.150
     7.418   102.822     0.150
     7.637   119.752     0.150
     0.229    12.992     0.150
     0.621    11.871     0.150
     0.834    15.738     0.150
     0.834    15.371     0.150
     1.151    21.043     0.150
     1.151    21.062     0.150
     1.151    37.031     0.150
     1.180    39.594     0.150
     1.180    21.172     0.150
     1.152    21.074     0.150
     1.731    51.344     0.150
     1.731    51.422     0.150
     1.904    30.949     0.150
     3.810    98.594     0.150
     4.307   143.555     0.150
     4.890    70.422     0.150
     5.575   183.414     0.150
     6.698   106.191     0.150
     6.698   106.617     0.150
     7.177   100.582     0.150
     7.858   240.496     0.150
     8.538   122.668     0.150
     8.538   265.867     0.150
     8.538   265.871     0.150
     9.871   148.523     0.150
    10.387   322.535     0.150
    11.490   359.668     0.150
    12.327   186.344     0.150
    13.012   196.414     0.150
    13.391   196.562     0.150
    13.788   205.184     0.150
    14.743   205.895     0.150
    15.381   225.582     0.150
    15.758   228.512     0.150
    15.834   231.012     0.150
    16.570   233.883     0.150
    16.811   232.152     0.150
    21.753   297.305     0.150
    22.027   297.422     0.150
    23.032   311.203     0.150
    23.812   318.684     0.150
    38.159   445.844     0.150
    38.215   446.684     0.150
    38.327   447.223     0.150
    38.861   450.293     0.150
    40.626   466.473     0.150
    74.620   702.992     0.150
    77.427   720.242     0.150
    77.427   719.793     0.150
   101.874   836.844     0.150
     0.083     2.166     0.150
     0.227     4.598     0.150
     0.300     4.840     0.150
     0.300     5.426     0.150
     0.356     6.617     0.150
     0.495    25.197     0.150
     0.716    13.117     0.150
     0.716    24.537     0.150
     0.782    28.486     0.150
     0.933    16.688     0.150
     1.102    18.246     0.150
     1.360    23.787     0.150
     1.404    24.586     0.150
     1.412    24.688     0.150
     1.451    25.227     0.150
     1.469    25.396     0.150
     1.855    30.947     0.150
     2.139    34.926     0.150
     2.209    36.018     0.150
     2.209    36.047     0.150
     2.304    37.648     0.150
     2.499    47.537     0.150
     5.197    76.348     0.150
     5.294   103.717     0.150
     5.695   185.146     0.150
     6.786    98.496     0.150
     7.988   120.137     0.150
     8.902   127.938     0.150
     0.780    14.555     0.150
     1.133    21.016     0.150
     1.133    38.385     0.150
     1.133    21.045     0.150
     1.133    34.816     0.150
     1.177    22.016     0.150
     1.177    22.115     0.150
     1.177    38.555     0.150
     1.178    22.135     0.150
     1.681    27.205     0.150
     2.154    33.795     0.150
     3.310    55.025     0.150
     4.651   118.506     0.150
     8.087   116.625     0.150
     8.507   142.986     0.150
     0.558    10.812     0.150
     0.558    19.094     0.150
     0.558    23.398     0.150
     0.558    10.836     0.150
     0.646    12.359     0.150
     0.688    13.117     0.150
     0.688    22.398     0.150
     0.688    13.164     0.150
     0.688    22.414     0.150
     1.603    27.516     0.150
     1.603    46.734     0.150
     3.093    51.188     0.150
     3.710    58.398     0.150
     4.765    73.719     0.150
     6.126   112.453     0.150
     6.873   100.023     0.150
     0.218     4.148     0.150
     0.218     4.133     0.150
     0.218     6.773     0.150
     0.225     4.359     0.150
     0.813    25.562     0.150
     1.160    20.859     0.150
     1.160    20.844     0.150
     1.160    34.742     0.150
     1.159    21.094     0.150
     1.159    21.109     0.150
     1.159    35.891     0.150
     1.255    22.070     0.150
     1.713    27.195     0.150
     2.127    32.961     0.150
     2.596    39.000     0.150
     4.802    77.531     0.150
     5.571   164.641     0.150
     6.368    92.258     0.150
     6.430    99.133     0.150
     7.506   107.875     0.150
     7.872   111.578     0.150
     9.709   137.359     0.150
     0.378     8.051     0.150
     0.418    11.758     0.150
     1.035    31.488     0.150
     1.035    17.258     0.150
     1.035    31.461     0.150
     1.039    19.828     0.150
     1.039    19.801     0.150
     1.039    34.641     0.150
     1.358    24.371     0.150
     1.358    45.410     0.150
     1.358    45.598     0.150
     1.358    24.379     0.150
     1.358    40.031     0.150
     1.710    30.031     0.150
     1.944    30.828     0.150
     1.944    30.289     0.150
     1.944    36.590     0.150
     1.944    30.258     0.150
     3.306    52.059     0.150
     3.553    53.859     0.150
     3.665    95.051     0.150
     3.665    53.660     0.150
     3.665    95.059     0.150
     4.579    67.461     0.150
     4.674   122.930     0.150
     4.708    69.559     0.150
     5.317   139.789     0.150
     6.895   132.586     0.150
     7.054   102.559     0.150
     7.362   103.961     0.150
     7.389   104.020     0.150
     7.389   104.059     0.150
     7.494   110.371     0.150
     7.494   199.539     0.150
     7.775   111.148     0.150
     7.775   136.008     0.150
     7.775   246.141     0.150
     7.775   111.160     0.150
     8.096   111.559     0.150
     8.346   118.539     0.150
     8.346   118.559     0.150
     8.690   123.410     0.150
     8.690   123.461     0.150
     8.964   130.840     0.150
     9.513   133.391     0.150
     9.531   135.840     0.150
    10.423   158.418     0.150
    10.423   158.461     0.150
    10.752   158.758     0.150
    10.906   158.359     0.150
    11.429   160.270     0.150
    11.429   160.258     0.150
    11.907   169.371     0.150
    12.084   170.781     0.150
    12.257   172.320     0.150
    13.177   188.359     0.150
    13.445   190.188     0.150
    13.830   196.898     0.150
    14.076   195.891     0.150
    14.076   195.859     0.150
    14.221   202.875     0.150
    14.221   204.180     0.150
    14.221   204.160     0.150
    14.859   208.859     0.150
    14.968   461.281     0.150
    15.571   223.359     0.150
    16.280   231.359     0.150
    16.416   232.621     0.150
    16.470   231.758     0.150
    18.024   251.789     0.150
    18.161   252.660     0.150
    18.398   256.430     0.150
    19.866   272.672     0.150
    21.082   287.445     0.150
    21.209   286.258     0.150
    21.286   287.559     0.150
    21.601   291.359     0.150
    21.939   291.039     0.150
    22.430   300.258     0.150
    22.950   305.117     0.150
    24.293   320.160     0.150
    24.518   318.660     0.150
    28.281   356.258     0.150
    36.451   427.359     0.150
    36.684   427.758     0.150
    36.849   430.258     0.150
    37.847   438.660     0.150
    38.125   441.461     0.150
    38.525   444.859     0.150
    43.923   498.289     0.150
    45.108   489.250     0.150
    46.127   503.949     0.150
    47.044   510.738     0.150
    47.157   518.090     0.150
    47.336   514.129     0.150
    55.770   575.230     0.150
    55.770   575.258     0.150
    77.502   720.660     0.150
    82.361   747.730     0.150
    83.396   748.961     0.150
    85.295   761.758     0.150
    85.712   759.359     0.150
    85.854   763.160     0.150
    86.014   765.258     0.150
    86.933   768.258     0.150
    87.397   770.660     0.150
    89.851   788.758     0.150
    89.873   790.758     0.150
    89.873   790.758     0.150
    90.586   790.961     0.150
    90.586   790.961     0.150
    90.871   794.660     0.150
    90.871   794.660     0.150
    91.718  1417.258     0.150
    95.637   802.160     0.150
    95.637    10.598     0.150
    95.637    14.500     0.150
   101.688   830.660     0.150
   101.688   841.258     0.150
   101.688   845.160     0.150
   103.033   843.859     0.150
   103.033   846.160     0.150
   107.375   853.258     0.150
   107.375  1124.758     0.150
   107.375  1570.656     0.150
   131.851   958.461     0.150
     0.268     5.828     0.150
     0.282     5.859     0.150
     0.282     8.211     0.150
     0.845    27.555     0.150
     0.845    27.555     0.150
     0.888    15.867     0.150
     0.931    15.547     0.150
     0.973    16.352     0.150
     1.108    20.352     0.150
     1.108    35.617     0.150
     1.108    20.391     0.150
     1.622    56.609     0.150
     2.013    31.531     0.150
     2.071    32.078     0.150
     2.071    59.961     0.150
     3.847    58.992     0.150
     4.834    71.297     0.150
     4.834   126.055     0.150
     6.201    90.969     0.150
     6.478   102.711     0.150
     6.755   103.875     0.150
     7.848   112.406     0.150
     8.393   120.547     0.150
    10.345   330.984     0.150
    10.547   150.102     0.150
    11.524   361.008     0.150
    12.109   169.227     0.150
    12.444   175.289     0.150
    12.804   182.820     0.150
    13.051   184.320     0.150
    13.648   193.969     0.150
    16.555   237.648     0.150
    19.552   267.250     0.150
    19.680   269.078     0.150
    25.691   335.188     0.150
    30.371   371.508     0.150
    95.484   800.906     0.150
   102.881   832.508     0.150
   107.221   854.406     0.150
     0.032     1.993     0.150
     0.105     3.264     0.150
     0.814    26.471     0.150
     0.909    38.443     0.150
     1.249    43.184     0.150
     1.249    22.254     0.150
     1.249    38.043     0.150
     1.259    38.564     0.150
     1.259    44.193     0.150
     1.346    23.963     0.150
     1.346    41.584     0.150
     1.394    42.543     0.150
     1.448    44.473     0.150
     1.630    25.588     0.150
     1.630    25.723     0.150
     1.630    45.854     0.150
     1.695    51.947     0.150
     2.060    31.984     0.150
     3.082    44.623     0.150
     5.969   185.613     0.150
     6.262   168.254     0.150
     7.719   238.654     0.150
     7.719   238.654     0.150
     8.353   258.154     0.150
     0.050     0.570     0.150
     0.050     0.789     0.150
     0.076     8.578     0.150
     0.076     1.930     0.150
     0.076     2.945     0.150
     0.781    14.266     0.150
     1.130    33.664     0.150
     1.211    43.945     0.150
     1.211    21.602     0.150
     1.211    36.602     0.150
     1.333    24.086     0.150
     1.333    24.086     0.150
     1.334    48.992     0.150
     1.604   633.719     0.150
     1.611    25.070     0.150
     1.611    50.250     0.150
     2.096    32.156     0.150
     4.030    69.648     0.150
     4.360    70.570     0.150
     7.051   107.969     0.150
     8.360   265.188     0.150
    15.942   503.836     0.150
     0.406     8.242     0.150
     0.490     9.811     0.150
     0.804    14.721     0.150
     0.853    31.682     0.150
     0.853    15.992     0.150
     0.853    15.992     0.150
     0.853    27.242     0.150
     1.511    24.400     0.150
     1.584    26.621     0.150
     2.394    69.188     0.150
     3.729    67.045     0.150
     5.610    86.592     0.150
     5.718    95.771     0.150
     6.637    94.561     0.150
     7.494   111.230     0.150
     7.729   111.262     0.150
     7.939   113.361     0.150
     8.119   156.861     0.150
    10.851   158.592     0.150
     0.320     9.177     0.150
     0.692    12.627     0.150
     0.883    15.767     0.150
     0.883    27.427     0.150
     1.079    20.127     0.150
     1.079    34.397     0.150
     1.079    20.147     0.150
     1.079    20.157     0.150
     1.246    35.787     0.150
     1.246    22.117     0.150
     1.246    35.787     0.150
     1.246    22.117     0.150
     1.335    23.697     0.150
     1.831    28.917     0.150
     2.046    33.964     0.150
     6.236   194.487     0.150
     0.279     5.883     0.150
     0.297     5.875     0.150
     0.297    12.906     0.150
     0.914    16.555     0.150
     0.979    16.289     0.150
     1.099    20.117     0.150
     1.237    22.055     0.150
     1.237    42.742     0.150
     1.269    23.055     0.150
     1.345    40.438     0.150
     1.345    23.352     0.150
     1.764    51.516     0.150
     2.944    44.195     0.150
     3.166    93.656     0.150
     3.215    46.992     0.150
     3.839    53.336     0.150
     4.883   163.844     0.150
     5.115    76.922     0.150
     6.838    97.289     0.150
     7.483   106.977     0.150
     7.770   112.086     0.150
     7.837   112.039     0.150
     7.837   150.578     0.150
    10.210   144.875     0.150
    11.733   167.273     0.150
    15.046   385.094     0.150
     0.020     0.551     0.150
     0.319     5.641     0.150
     0.319     6.043     0.150
     0.419    26.660     0.150
     0.794    14.523     0.150
     0.820    15.141     0.150
     0.849    15.773     0.150
     0.849    27.121     0.150
     0.870    15.203     0.150
     0.870    27.043     0.150
     1.146   637.582     0.150
     1.153    19.473     0.150
     1.508    24.621     0.150
     4.194    61.473     0.150
     4.194    84.711     0.150
     4.623    69.504     0.150
     4.987   160.902     0.150
     5.279   165.262     0.150
     5.562   175.660     0.150
     5.707    86.043     0.150
     5.707   186.621     0.150
     6.544   111.281     0.150
     7.512   109.254     0.150
     7.595   116.172     0.150
     8.059   258.059     0.150
     8.824   126.691     0.150
     9.431   133.453     0.150
    10.862   343.410     0.150
    15.233   216.551     0.150
     0.346     6.969     0.150
     0.346     8.508     0.150
     0.983    17.727     0.150
     1.083    19.816     0.150
     1.304    23.219     0.150
     1.304    23.160     0.150
     1.304    40.770     0.150
     1.871    30.539     0.150
     1.871    35.590     0.150
     1.989    30.758     0.150
     2.571    76.008     0.150
     2.622    44.848     0.150
     2.700    39.801     0.150
     2.714    40.660     0.150
     3.174    93.898     0.150
     4.403    74.277     0.150
     4.506    74.828     0.150
     5.390    77.938     0.150
     6.248   112.707     0.150
     7.091   139.789     0.150
     9.848   149.008     0.150
     9.848   306.270     0.150
    11.535   208.938     0.150
    11.535   360.789     0.150
     0.387    13.750     0.150
     0.387     6.812     0.150
     0.387    11.148     0.150
     0.437     6.609     0.150
     0.437    11.297     0.150
     0.526     9.367     0.150
     0.526    16.820     0.150
     0.606    10.211     0.150
     0.606    17.750     0.150
     0.606    18.633     0.150
     0.642    11.242     0.150
     0.642    19.438     0.150
     0.642    11.211     0.150
     0.642    19.188     0.150
     0.705    12.391     0.150
     0.699    11.797     0.150
     0.699    11.820     0.150
     0.699    20.719     0.150
     0.855    25.523     0.150
     0.861    14.727     0.150
     1.015    18.102     0.150
     1.066    18.312     0.150
     1.066    31.664     0.150
     1.066    18.109     0.150
     1.162    22.891     0.150
     1.240    22.023     0.150
     1.240    35.031     0.150
     1.240    21.953     0.150
     1.240    22.023     0.150
     1.240    35.031     0.150
     1.242    22.078     0.150
     1.242    21.961     0.150
     1.479    24.906     0.150
     1.573    26.742     0.150
     1.631    26.773     0.150
     1.677    23.562     0.150
     1.716    29.258     0.150
     1.716    51.234     0.150
     1.979    32.594     0.150
     2.086    58.203     0.150
     2.214    34.141     0.150
     2.214    60.906     0.150
     2.298    61.562     0.150
     2.271    67.727     0.150
     2.293    36.422     0.150
     2.446    41.852     0.150
     2.457    73.414     0.150
     2.943    44.352     0.150
     3.154    49.875     0.150
     3.154    93.648     0.150
     3.252    86.883     0.150
     3.252    94.617     0.150
     3.715   111.352     0.150
     4.027    63.469     0.150
     4.354    69.133     0.150
     4.621    70.711     0.150
     9.261   139.109     0.150
    11.488   156.789     0.150
    11.985   177.891     0.150
     0.343    10.555     0.150
     0.343    14.227     0.150
     0.343     6.438     0.150
     0.343    10.305     0.150
     0.681    11.742     0.150
     0.681    11.773     0.150
     0.781    13.125     0.150
     0.805    14.094     0.150
     0.825    14.406     0.150
     0.825    14.414     0.150
     0.899    15.531     0.150
     0.948    16.656     0.150
     1.018    16.336     0.150
     1.026    17.195     0.150
     1.057    19.242     0.150
     1.057    32.922     0.150
     1.058    19.438     0.150
     1.069    37.344     0.150
     1.253    40.820     0.150
     1.253    37.461     0.150
     1.253    21.977     0.150
     1.253    37.461     0.150
     1.304    39.781     0.150
     1.289    38.016     0.150
     1.373    23.367     0.150
     1.373    23.375     0.150
     1.760    52.273     0.150
     1.760    27.250     0.150
     1.792    29.320     0.150
     1.792    52.047     0.150
     1.832    56.516     0.150
     1.851    57.398     0.150
     2.388    71.328     0.150
     2.604    80.750     0.150
     2.988    50.375     0.150
     3.474    59.188     0.150
     4.411    84.477     0.150
     4.626    71.531     0.150
     5.479    81.164     0.150
     6.259   115.633     0.150
     6.992   134.031     0.150
     8.054   150.422     0.150
    12.068   294.805     0.150
    13.031   320.406     0.150
    13.794   336.367     0.150
    14.874   365.922     0.150
    18.627   454.414     0.150
    25.681   327.234     0.150
    34.325   404.242     0.150
     0.231     4.812     0.150
     0.231     5.062     0.150
     0.792    26.332     0.150
     0.839    15.062     0.150
     0.944    15.551     0.150
     1.149    21.074     0.150
     1.178    38.973     0.150
     1.178    21.113     0.150
     1.206    21.141     0.150
     1.238    22.203     0.150
     1.275    23.621     0.150
     1.733    27.344     0.150
     2.317    68.652     0.150
     3.138    45.602     0.150
     6.700   107.586     0.150
     7.861   233.562     0.150
    16.120   234.188     0.150
    30.325   375.047     0.150
    37.958   442.812     0.150
     0.082     7.617     0.150
     0.081     1.059     0.150
     0.780    14.359     0.150
     1.307    47.488     0.150
     1.532    27.027     0.150
     1.608   817.988     0.150
     1.616    25.250     0.150
     2.364    36.387     0.150
     2.456    37.414     0.150
     2.757    41.434     0.150
     3.053    50.668     0.150
     3.132    46.781     0.150
     4.251    72.488     0.150
     4.372    68.297     0.150
     5.344    89.660     0.150
     5.995    92.887     0.150
     6.216    98.777     0.150
     6.559   102.422     0.150
     6.559   216.164     0.150
     6.658   103.707     0.150
     7.058   129.867     0.150
     7.096   102.609     0.150
     7.381   104.098     0.150
     7.477   118.137     0.150
     7.452   104.898     0.150
     7.483   107.328     0.150
     7.623   110.457     0.150
     7.785   246.238     0.150
     7.955   113.910     0.150
     8.079   147.527     0.150
     8.762   124.938     0.150
     9.578   132.629     0.150
    11.341   366.590     0.150
    22.950   309.293     0.150
    30.167   373.773     0.150
     0.311     8.848     0.150
     0.877    15.289     0.150
     0.954    17.008     0.150
     1.001    16.789     0.150
     1.001    16.758     0.150
     1.001    29.047     0.150
     1.073    20.617     0.150
     1.267    22.500     0.150
     1.267    44.770     0.150
     1.382    41.488     0.150
     1.743    27.688     0.150
     1.851    29.188     0.150
     1.851    29.207     0.150
     1.851    56.938     0.150
     2.026    31.840     0.150
     3.207    48.758     0.150
     3.207    89.707     0.150
     3.469    52.078     0.150
     3.741    55.410     0.150
     3.831    61.629     0.150
     4.485    66.488     0.150
     4.485    66.488     0.150
     4.622    69.277     0.150
     4.919    73.238     0.150
     4.949    72.758     0.150
     5.207    75.875     0.150
     5.407    86.777     0.150
     5.858    86.977     0.150
     6.812   222.090     0.150
     6.859   101.770     0.150
     6.956   102.457     0.150
     7.296   106.816     0.150
     7.333   107.680     0.150
     7.624   115.508     0.150
     7.827   113.988     0.150
     7.963   116.859     0.150
     8.308   123.547     0.150
     8.308   211.129     0.150
     8.301   124.598     0.150
     8.478   123.758     0.150
     8.720   227.707     0.150
     9.032   133.207     0.150
     9.856   143.969     0.150
    10.677   154.738     0.150
    10.919   159.238     0.150
    11.134   157.637     0.150
    11.464   162.988     0.150
    11.550   362.629     0.150
    12.169   178.719     0.150
    12.437   177.559     0.150
    12.800   181.930     0.150
    13.001   185.988     0.150
    13.261   190.438     0.150
    13.762   198.129     0.150
    13.959   198.188     0.150
    14.056   202.547     0.150
    14.855   209.707     0.150
    15.493   221.488     0.150
    16.216   229.828     0.150
    17.418   241.824     0.150
    17.443   241.008     0.150
    18.227   253.930     0.150
    19.694   267.230     0.150
    20.455   275.297     0.150
    20.455   278.680     0.150
    21.082   285.109     0.150
    21.336   288.680     0.150
    21.667   291.949     0.150
    22.152   299.598     0.150
    22.463   299.680     0.150
    22.977   305.930     0.150
    23.127   306.590     0.150
    24.346   320.988     0.150
    24.447   321.848     0.150
    24.489   319.488     0.150
    26.267   335.918     0.150
    26.663   339.297     0.150
    28.406   355.379     0.150
    28.950   360.609     0.150
    33.870   397.684     0.150
    37.776   437.590     0.150
    37.776   437.590     0.150
    38.442   444.668     0.150
    41.529   463.879     0.150
    46.973   514.500     0.150
    47.131   513.559     0.150
    47.253   515.090     0.150
    55.746   576.887     0.150
    60.508   609.887     0.150
    61.192   613.590     0.150
    62.886  1130.090     0.150
    64.867   636.887     0.150
    65.926   646.969     0.150
    67.423   652.188     0.150
    72.759   684.590     0.150
    74.693   699.988     0.150
    77.778   712.688     0.150
    81.630   738.918     0.150
    84.340   748.590     0.150
    85.286   757.988     0.150
    89.315   777.590     0.150
    91.666   783.590     0.150
    91.770   783.488     0.150
    91.844   785.387     0.150
    95.545  1861.789     0.150
    96.651   811.039     0.150
   107.282   852.789     0.150
   108.001  1132.289     0.150
   108.001  2044.590     0.150
     0.223     4.715     0.150
     0.215     3.325     0.150
     0.215     6.295     0.150
     0.677    12.185     0.150
     0.687    12.325     0.150
     0.732    13.095     0.150
     0.738    13.435     0.150
     0.768    13.475     0.150
     0.815    14.795     0.150
     1.161    21.475     0.150
     1.161    36.905     0.150
     1.161    20.395     0.150
     1.158    37.675     0.150
     1.158    38.045     0.150
     1.158    20.965     0.150
     1.158    36.755     0.150
     1.184    21.005     0.150
     1.227    22.205     0.150
     1.252    21.975     0.150
     1.293    22.915     0.150
     1.678    26.615     0.150
     2.130    33.205     0.150
     2.130    33.275     0.150
     2.873    90.225     0.150
     4.295   124.765     0.150
     4.343    67.115     0.150
     4.799    78.345     0.150
     4.799   138.425     0.150
     4.914    76.334     0.150
     5.194    78.345     0.150
     5.478    81.435     0.150
     5.569    81.555     0.150
     6.138    88.995     0.150
     6.370    92.775     0.150
     6.362   103.405     0.150
     6.428   100.145     0.150
     6.680   104.905     0.150
     6.680   221.235     0.150
     6.680   104.900     0.150
     6.680   221.232     0.150
     7.274   109.145     0.150
     7.873   114.935     0.150
     8.053   121.455     0.150
     8.092   251.545     0.150
     8.446   278.555     0.150
     8.526   129.975     0.150
     8.526   276.700     0.150
     8.674   232.265     0.150
     9.756   138.805     0.150
    10.231   152.795     0.150
    10.410   321.051     0.150
    11.487   171.745     0.150
    11.487   171.748     0.150
    13.362   188.955     0.150
    15.546   229.045     0.150
    16.104   233.225     0.150
    21.781   297.175     0.150
    23.090   309.550     0.150
    37.937   442.575     0.150
    37.937   442.575     0.150
    81.558   741.665     0.150
    81.558   741.667     0.150
     0.327    14.136     0.150
     0.661    12.186     0.150
     0.715    12.815     0.150
     0.704    12.886     0.150
     0.732    14.456     0.150
     0.750    14.605     0.150
     0.795    16.656     0.150
     0.819    14.716     0.150
     0.896    26.666     0.150
     0.896    15.485     0.150
     0.896    26.666     0.150
     0.944    16.985     0.150
     0.998    16.686     0.150
     1.077    20.206     0.150
     1.085    37.496     0.150
     1.258    22.406     0.150
     1.258    39.656     0.150
     1.269    23.176     0.150
     1.346    24.186     0.150
     1.841    29.186     0.150
     1.841    54.746     0.150
     2.970    45.786     0.150
     2.965    47.826     0.150
     4.387    74.476     0.150
     4.387    79.586     0.150
     4.663    69.176     0.150
     5.642    80.866     0.150
     6.554    91.876     0.150
     0.776    22.656     0.150
     0.823    15.086     0.150
     0.955    27.492     0.150
     0.955    27.883     0.150
     1.143    21.125     0.150
     1.143    37.094     0.150
     1.143    21.062     0.150
     1.158    20.984     0.150
     1.158    36.695     0.150
     1.158    20.953     0.150
     1.674    28.000     0.150
     2.891    46.508     0.150
     3.351    57.023     0.150
     4.817    74.492     0.150
     5.587    85.289     0.150
     6.379    99.719     0.150
     6.696   103.227     0.150
     6.696   220.688     0.150
     6.945   135.258     0.150
     8.101   122.367     0.150
    16.121   234.367     0.150
    30.328   375.500     0.150
    81.576   741.609     0.150
     0.259     5.068     0.150
     0.259     8.498     0.150
     0.660    12.127     0.150
     0.712    24.648     0.150
     0.712    13.197     0.150
     0.712    22.678     0.150
     0.854    15.408     0.150
     1.060    36.838     0.150
     1.121    20.518     0.150
     1.121    20.518     0.150
     1.121    35.809     0.150
     1.121    20.547     0.150
     1.703    50.438     0.150
     1.752    51.617     0.150
     3.382    55.197     0.150
     3.814    58.018     0.150
     4.388    67.658     0.150
     4.532    69.428     0.150
     4.845    77.068     0.150
     9.255   130.398     0.150
     0.489     9.137     0.150
     0.592     9.629     0.150
     0.592    16.508     0.150
     0.592     9.629     0.150
     0.647    11.738     0.150
     0.871    26.078     0.150
     1.062    20.039     0.150
     1.062    20.039     0.150
     1.062    33.797     0.150
     1.063    20.090     0.150
     1.228    20.668     0.150
     1.637    50.117     0.150
     1.640    27.090     0.150
     1.640    50.168     0.150
     1.949    58.496     0.150
     1.945    31.188     0.150
     2.483    37.367     0.150
     6.669   102.016     0.150
     6.741    97.387     0.150
     8.650   134.914     0.150
     0.839    14.783     0.150
     0.863    25.543     0.150
     0.911    16.453     0.150
     0.953    27.873     0.150
     0.991    28.191     0.150
     0.991    28.363     0.150
     1.072    37.383     0.150
     1.088    20.443     0.150
     1.088    20.293     0.150
     1.088    34.814     0.150
     3.178    51.254     0.150
     3.434    54.334     0.150
     5.033    74.133     0.150
     5.275   181.324     0.150
     5.475    81.574     0.150
     5.632    85.553     0.150
     7.496   107.674     0.150
     8.385   120.484     0.150
     0.590     9.654     0.150
     0.590    16.744     0.150
     0.644    11.766     0.150
     0.819    15.074     0.150
     0.854    15.582     0.150
     0.854    15.605     0.150
     0.823    28.516     0.150
     0.823    15.275     0.150
     0.823    25.305     0.150
     0.857    26.414     0.150
     1.066    20.084     0.150
     1.066    20.084     0.150
     1.066    33.834     0.150
     1.067    20.105     0.150
     1.636    27.164     0.150
     3.326    56.084     0.150
     4.231    69.814     0.150
     4.981    74.344     0.150
     6.245    96.686     0.150
     8.360   121.555     0.150
     0.822    14.969     0.150
     0.822    25.707     0.150
     0.932    27.371     0.150
     0.932    15.539     0.150
     1.167    20.977     0.150
     1.167    20.977     0.150
     1.163    21.070     0.150
     1.163    21.070     0.150
     1.163    37.488     0.150
     1.164    21.160     0.150
     1.676    49.648     0.150
     1.673    26.238     0.150
     1.673    28.637     0.150
     2.585    41.047     0.150
     6.789   122.949     0.150
     8.140   113.297     0.150
     0.299     5.277     0.150
     0.340     6.539     0.150
     0.340    11.277     0.150
     0.847    15.367     0.150
     0.878    31.359     0.150
     0.878    16.359     0.150
     0.878    27.859     0.150
     0.878    16.359     0.150
     0.878    27.859     0.150
     1.618    28.398     0.150
     1.618    28.398     0.150
     1.618    49.289     0.150
     2.599    41.918     0.150
     3.263    45.789     0.150
     7.461   106.039     0.150
     7.914   115.168     0.150
     8.082   261.805     0.150
     9.614   138.398     0.150
    10.849   344.902     0.150
     0.563    10.391     0.150
     0.563    19.500     0.150
     0.579    10.273     0.150
     0.586    16.695     0.150
     0.640    11.570     0.150
     0.810    26.305     0.150
     0.810    14.953     0.150
     0.810    26.305     0.150
     0.857    25.039     0.150
     0.857    16.164     0.150
     0.842    14.703     0.150
     0.982    17.664     0.150
     1.029    19.453     0.150
     1.065    19.539     0.150
     1.065    19.539     0.150
     1.065    35.164     0.150
     1.066    19.609     0.150
     1.066    34.391     0.150
     1.635    26.984     0.150
     1.633    27.898     0.150
     2.496    37.773     0.150
     4.212   126.539     0.150
     5.189    79.289     0.150
     5.855    86.516     0.150
     7.422   103.469     0.150
    13.863   196.266     0.150
    13.863   345.594     0.150
     0.562    10.641     0.150
     0.562    18.914     0.150
     0.586    10.477     0.150
     0.594     9.641     0.150
     0.594    16.594     0.150
     0.648    11.734     0.150
     0.726    28.367     0.150
     0.826    15.234     0.150
     0.863    16.469     0.150
     0.817    30.125     0.150
     0.817    26.039     0.150
     0.817    26.039     0.150
     0.867    15.750     0.150
     0.844    14.820     0.150
     0.904    17.719     0.150
     1.035    20.289     0.150
     1.059    19.617     0.150
     1.059    34.031     0.150
     1.060    19.648     0.150
     1.236    20.531     0.150
     1.314    24.898     0.150
     1.642    49.250     0.150
     1.641    28.594     0.150
     1.660    31.609     0.150
     1.926    31.430     0.150
     2.490    37.719     0.150
     3.203    55.477     0.150
     3.398    56.594     0.150
     4.032    65.320     0.150
     4.206    67.164     0.150
     4.235    65.719     0.150
     5.547    86.164     0.150
     6.254    94.680     0.150
     6.619    91.914     0.150
     6.672   208.156     0.150
     6.672   208.164     0.150
     7.858   118.727     0.150
     7.950   118.094     0.150
     8.198   117.945     0.150
     8.260   118.906     0.150
     8.260   254.586     0.150
     8.260   254.586     0.150
    10.745   158.508     0.150
    12.745   333.711     0.150
    16.697   410.969     0.150
    17.462   429.086     0.150
     0.220    12.637     0.150
     0.676    12.356     0.150
     0.686    12.356     0.150
     0.755    22.097     0.150
     0.755    12.956     0.150
     0.755    22.097     0.150
     0.750    13.217     0.150
     0.802    14.807     0.150
     0.950    16.026     0.150
     0.950    27.486     0.150
     1.140    20.677     0.150
     1.140    36.036     0.150
     1.154    22.427     0.150
     1.155    21.087     0.150
     1.274    22.526     0.150
     1.695   649.687     0.150
     1.703    28.066     0.150
     1.689    26.977     0.150
     3.333    50.307     0.150
     4.925    78.887     0.150
     5.400    88.837     0.150
     6.141    90.387     0.150
     6.189    96.566     0.150
     6.677   103.211     0.150
     6.804   125.696     0.150
     6.926   107.446     0.150
     7.201   110.606     0.150
     7.522   137.236     0.150
     7.522   227.667     0.150
     7.705   118.236     0.150
     7.833   119.337     0.150
     8.154   125.606     0.150
     8.182   125.917     0.150
     8.358   276.837     0.150
     8.353   127.687     0.150
     8.465   121.727     0.150
     8.465   265.036     0.150
     8.900   129.757     0.150
     9.441   142.687     0.150
     9.909   152.526     0.150
    10.427   324.212     0.150
    10.679   155.236     0.150
    10.922   327.557     0.150
    11.369   363.007     0.150
    11.477   169.456     0.150
    11.497   170.696     0.150
    11.498   171.137     0.150
    11.498   353.262     0.150
    11.498   353.257     0.150
    12.310   182.837     0.150
    12.389   317.257     0.150
    12.730   176.167     0.150
    13.315   184.047     0.150
    14.043   191.786     0.150
    14.833   210.446     0.150
    16.106   500.911     0.150
    16.106   228.576     0.150
    16.106   500.917     0.150
    20.519   279.227     0.150
    21.496   289.267     0.150
    21.571   290.620     0.150
    21.571   291.986     0.150
    22.948   303.653     0.150
    24.059   314.968     0.150
    24.059   315.307     0.150
    35.248   414.887     0.150
    41.397   465.286     0.150
    47.276   518.597     0.150
    55.692   580.967     0.150
    56.354  4145.786     0.150
    83.529   753.986     0.150
   102.796  1959.387     0.150
   119.165  1135.420     0.150
     0.218    11.654     0.150
     0.678    13.434     0.150
     0.728    14.154     0.150
     0.774    22.764     0.150
     0.821    15.084     0.150
     0.938    28.002     0.150
     0.938    17.014     0.150
     0.938    27.934     0.150
     1.164    38.115     0.150
     1.164    21.395     0.150
     1.164    37.395     0.150
     1.159    21.285     0.150
     1.159    21.285     0.150
     1.159    38.824     0.150
     1.678    28.795     0.150
     1.715    27.584     0.150
     1.890    31.148     0.150
     5.090    78.084     0.150
     7.503   117.734     0.150
     0.221    10.371     0.150
     0.221    10.971     0.150
     0.764    22.561     0.150
     0.812    14.961     0.150
     0.946    27.553     0.150
     1.151    40.131     0.150
     1.151    21.711     0.150
     1.151    21.711     0.150
     1.151    35.992     0.150
     1.155    21.262     0.150
     1.155    21.262     0.150
     1.155    36.381     0.150
     1.155    42.541     0.150
     1.155    21.252     0.150
     1.664    28.752     0.150
     1.685    29.432     0.150
     1.702   643.361     0.150
     2.602    41.711     0.150
     3.338    52.971     0.150
     3.779    55.793     0.150
     3.838    59.641     0.150
     4.812    70.928     0.150
     4.916   126.781     0.150
     4.916   126.781     0.150
     5.201    77.951     0.150
     5.408    88.072     0.150
     5.545    87.281     0.150
     7.206   111.582     0.150
     7.490   114.791     0.150
     7.711   118.150     0.150
     7.830   121.701     0.150
     7.882   114.721     0.150
     7.882   248.711     0.150
     8.161   129.230     0.150
     8.188   125.371     0.150
     8.233   124.900     0.150
     8.361   126.822     0.150
     8.476   127.162     0.150
     9.438   142.121     0.150
     9.767   141.531     0.150
    11.495   361.186     0.150
    11.495   361.191     0.150
    12.393   310.480     0.150
    12.548   186.432     0.150
    12.731   188.912     0.150
    13.661   199.781     0.150
    14.689   352.721     0.150
    14.828   218.721     0.150
    15.491   212.832     0.150
    18.298   257.621     0.150
    21.561   290.711     0.150
    21.561   292.412     0.150
    22.568   301.281     0.150
   102.802   833.262     0.150
     0.210    10.334     0.150
     0.770    22.803     0.150
     0.817    14.943     0.150
     0.930    27.414     0.150
     1.167    22.283     0.150
     1.167    38.482     0.150
     1.164    38.373     0.150
     1.164    40.514     0.150
     1.164    21.344     0.150
     1.164    21.344     0.150
     1.164    37.094     0.150
     1.672    29.127     0.150
     1.672    29.363     0.150
     1.708    28.383     0.150
     2.303    35.438     0.150
     2.584    41.523     0.150
     3.823    59.543     0.150
     3.823    97.123     0.150
     4.342    68.652     0.150
     4.795    75.732     0.150
     6.354    99.402     0.150
     6.926   134.994     0.150
     7.171   106.732     0.150
     7.554   112.184     0.150
     7.865   117.053     0.150
     7.865   247.033     0.150
     7.908   125.414     0.150
     8.874   131.383     0.150
     8.889   135.254     0.150
    10.405   324.473     0.150
    10.652   159.863     0.150
    14.640   217.033     0.150
    14.727   218.764     0.150
    16.052   232.514     0.150
     0.273     8.188     0.150
     0.931    27.609     0.150
     1.104    20.316     0.150
     1.104    20.316     0.150
     1.104    35.039     0.150
     1.104    20.258     0.150
     1.212    21.656     0.150
     1.212    36.879     0.150
     1.212    21.656     0.150
     1.212    36.879     0.150
     1.720    28.996     0.150
     1.739    50.789     0.150
     1.739    51.086     0.150
     1.789    52.977     0.150
     2.936    47.777     0.150
     3.758   109.406     0.150
     4.221   125.930     0.150
     0.296    12.438     0.150
     0.284     8.195     0.150
     0.851    25.176     0.150
     0.899    16.207     0.150
     0.899    28.484     0.150
     1.092    21.664     0.150
     1.092    21.664     0.150
     1.092    35.406     0.150
     1.217    41.125     0.150
     1.217    21.586     0.150
     1.217    36.207     0.150
     1.801    28.496     0.150
     1.975    31.875     0.150
     3.785    57.914     0.150
     4.434    63.785     0.150
     0.129     3.105     0.150
     0.182     3.117     0.150
     0.181     4.928     0.150
     0.181     8.729     0.150
     0.181     9.027     0.150
     0.181     9.229     0.150
     0.263     4.758     0.150
     0.457    14.479     0.150
     0.814    24.316     0.150
     0.792    30.828     0.150
     1.139    18.965     0.150
     1.181    18.258     0.150
     1.596    47.617     0.150
     1.668    33.578     0.150
     1.668    26.439     0.150
     2.579    39.783     0.150
     2.881    44.607     0.150
     3.807   124.938     0.150
     4.164   131.377     0.150
     4.164    62.471     0.150
     5.909   185.662     0.150
     6.152   112.697     0.150
     6.313   201.957     0.150
     6.823   188.318     0.150
     6.823   196.518     0.150
     9.177   131.578     0.150
    11.247   362.389     0.150
    11.234   359.188     0.150
    11.827   168.578     0.150
    12.919   190.549     0.150
    14.136   211.049     0.150
    14.303   211.758     0.150
    16.352   231.098     0.150
     0.286     6.073     0.150
     0.286     6.073     0.150
     0.286     8.354     0.150
     0.304    14.333     0.150
     0.718    12.753     0.150
     0.869    14.923     0.150
     0.917    16.418     0.150
     0.986    16.524     0.150
     1.092    20.233     0.150
     1.092    36.013     0.150
     1.092    20.243     0.150
     1.236    21.983     0.150
     1.236    39.233     0.150
     1.236    38.723     0.150
     1.347    23.143     0.150
     1.571    26.003     0.150
     1.814    28.664     0.150
     2.938    90.456     0.150
     3.357    51.428     0.150
     3.436    54.593     0.150
     3.597    56.456     0.150
     3.766    91.113     0.150
     4.448    68.173     0.150
     4.662   145.733     0.150
     4.890    75.253     0.150
     5.825   107.683     0.150
     5.825   191.213     0.150
     6.297   114.483     0.150
     6.779    98.263     0.150
     6.779   104.748     0.150
     7.512   109.623     0.150
     8.377   120.473     0.150
     0.072     1.004     0.150
     0.072     1.004     0.150
     0.072     3.266     0.150
     0.072     0.934     0.150
     0.706    12.234     0.150
     0.747    13.703     0.150
     0.762    13.035     0.150
     1.085    18.773     0.150
     1.173    21.043     0.150
     1.173    35.902     0.150
     1.173    21.074     0.150
     1.173    41.652     0.150
     1.350    23.645     0.150
     1.350    42.145     0.150
     1.350    23.633     0.150
     1.350    23.645     0.150
     1.497    24.766     0.150
     1.497    25.859     0.150
     2.684    36.734     0.150
     4.205    69.523     0.150
     4.906    71.574     0.150
     5.302    70.785     0.150
     5.360    77.734     0.150
     5.950    85.234     0.150
     7.784   115.715     0.150
     9.904   136.242     0.150
    10.435   331.668     0.150
    11.305   206.645     0.150
    11.874   175.414     0.150
     0.232     4.448     0.150
     0.232     7.028     0.150
     0.232     4.448     0.150
     0.220    15.458     0.150
     0.761    22.599     0.150
     0.809    14.748     0.150
     0.809    25.428     0.150
     0.850    25.239     0.150
     1.155    21.048     0.150
     1.155    37.028     0.150
     1.155    21.118     0.150
     1.147    20.428     0.150
     1.147    35.168     0.150
     1.707    50.378     0.150
     2.140    56.008     0.150
     2.828    84.064     0.150
     3.841    63.618     0.150
     3.841    56.357     0.150
     6.192    88.858     0.150
     6.381    92.564     0.150
     6.680   130.378     0.150
     6.680   108.533     0.150
     7.204   102.578     0.150
     7.517   110.938     0.150
     7.885   111.604     0.150
     7.885   114.481     0.150
     8.457   120.349     0.150
     8.531   127.908     0.150
     8.894   126.528     0.150
    14.261   198.448     0.150
    16.107   233.607     0.150
    16.598   228.838     0.150
    20.732   274.168     0.150
    20.995   280.588     0.150
    37.656   441.908     0.150
     0.072     7.051     0.150
     0.053     0.539     0.150
     0.053     0.539     0.150
     0.053     2.809     0.150
     0.743    12.738     0.150
     0.785    14.309     0.150
     0.765    13.090     0.150
     0.765    13.051     0.150
     1.124    19.289     0.150
     1.214    21.250     0.150
     1.333    23.832     0.150
     1.333    23.832     0.150
     1.333    43.250     0.150
     1.504    25.301     0.150
     1.599   583.410     0.150
     1.607    25.297     0.150
     1.656    27.238     0.150
     2.102    32.109     0.150
     2.102    32.031     0.150
     2.354    42.719     0.150
     2.443    38.719     0.150
     2.892    51.332     0.150
     4.242    65.039     0.150
     4.644    84.301     0.150
     4.981    68.871     0.150
     8.398   121.543     0.150
     8.398   121.680     0.150
    10.398   148.738     0.150
    10.398   332.867     0.150
    16.788   240.000     0.150
     0.250    10.477     0.150
     0.818    24.039     0.150
     1.201    21.500     0.150
     1.229    21.660     0.150
     1.691    28.473     0.150
     1.758    27.938     0.150
     2.087    32.430     0.150
     7.498   108.535     0.150
     8.406   121.188     0.150
     0.295     5.290     0.150
     0.295     9.604     0.150
     0.295     5.604     0.150
     0.295     9.594     0.150
     0.340     5.744     0.150
     0.340     5.724     0.150
     0.348    12.474     0.150
     0.348    12.344     0.150
     0.348     7.134     0.150
     0.348    12.384     0.150
     0.344     7.614     0.150
     0.344    13.234     0.150
     0.344    13.594     0.150
     0.344    14.144     0.150
     0.344     7.594     0.150
     0.344    13.254     0.150
     0.450    14.454     0.150
     0.450    14.484     0.150
     0.450     8.414     0.150
     0.512     9.484     0.150
     0.467     8.504     0.150
     0.521     9.444     0.150
     0.521     9.424     0.150
     0.559    10.074     0.150
     0.585    10.894     0.150
     0.585    19.054     0.150
     0.602    10.964     0.150
     0.602    19.244     0.150
     0.679    12.294     0.150
     0.616    12.174     0.150
     0.668    11.814     0.150
     0.677    12.814     0.150
     0.701    12.274     0.150
     0.737    12.694     0.150
     0.737    12.684     0.150
     0.809    14.474     0.150
     0.809    14.474     0.150
     0.815    35.314     0.150
     0.815    14.234     0.150
     0.846    15.014     0.150
     0.867    15.064     0.150
     0.905    14.804     0.150
     0.905    14.804     0.150
     1.087    32.624     0.150
     1.141    19.634     0.150
     1.231    20.594     0.150
     1.233    20.634     0.150
     1.233    20.644     0.150
     1.383    22.364     0.150
     1.383    22.354     0.150
     1.383    22.404     0.150
     1.438    23.294     0.150
     1.440    24.344     0.150
     1.501    26.354     0.150
     1.501    26.344     0.150
     1.502    26.344     0.150
     1.626    26.164     0.150
     2.012    31.904     0.150
     2.072    57.879     0.150
     2.875    44.820     0.150
     2.874    44.084     0.150
     2.962    44.534     0.150
     2.962    44.534     0.150
     3.747    95.134     0.150
     4.033    63.054     0.150
     4.641    68.094     0.150
     6.084    88.686     0.150
     7.997   113.694     0.150
     8.172   122.844     0.150
     9.266   133.434     0.150
     0.059     8.670     0.150
     0.073     0.831     0.150
     0.073     1.110     0.150
     0.073     0.911     0.150
     0.176     4.050     0.150
     0.176     8.090     0.150
     0.477     8.710     0.150
     0.477    15.411     0.150
     0.511    16.391     0.150
     0.511     9.470     0.150
     0.619    11.161     0.150
     0.730    12.641     0.150
     0.730    12.700     0.150
     0.779    13.260     0.150
     0.779    23.950     0.150
     0.779    13.230     0.150
     0.764    14.050     0.150
     0.764    14.021     0.150
     0.786    12.920     0.150
     1.066    54.260     0.150
     1.105    19.141     0.150
     1.295    21.141     0.150
     1.327    21.980     0.150
     1.327    22.230     0.150
     1.460    26.710     0.150
     1.460    43.170     0.150
     1.588    25.360     0.150
     1.594    25.161     0.150
     1.594    25.260     0.150
     1.625    46.590     0.150
     1.736    28.771     0.150
     4.512    66.470     0.150
     4.741    69.891     0.150
     4.997   126.430     0.150
     5.365    78.200     0.150
     5.404    79.041     0.150
     6.199    89.180     0.150
     6.329    92.686     0.150
     7.176   102.070     0.150
     7.373   105.760     0.150
     7.454   106.661     0.150
     8.046   114.791     0.150
     8.421   119.740     0.150
     9.637   136.811     0.150
    10.121   142.430     0.150
    10.419   146.670     0.150
    10.420   147.440     0.150
    10.768   153.831     0.150
    11.198   159.061     0.150
    13.142   183.460     0.150
     0.042     0.727     0.150
     0.042     0.727     0.150
     0.042     2.969     0.150
     0.080     2.305     0.150
     0.144     5.328     0.150
     0.418    13.016     0.150
     0.418     7.844     0.150
     0.575    10.766     0.150
     0.756    12.898     0.150
     0.756    12.859     0.150
     0.749    12.742     0.150
     0.749    12.695     0.150
     0.757    12.906     0.150
     0.797    14.406     0.150
     0.797    14.359     0.150
     0.797    25.477     0.150
     0.870    24.047     0.150
     1.135    19.336     0.150
     1.219    21.742     0.150
     1.338    25.633     0.150
     1.338    25.633     0.150
     1.338    43.898     0.150
     1.454    23.703     0.150
     1.668    29.711     0.150
     1.861    30.594     0.150
     4.123    64.367     0.150
     4.248    65.164     0.150
     4.643    66.305     0.150
     7.138   101.703     0.150
     7.874   112.148     0.150
     7.918   113.477     0.150
    11.500   163.195     0.150
     0.037     0.383     0.150
     0.037     0.461     0.150
     0.037     2.469     0.150
     0.037     0.383     0.150
     0.037     2.500     0.150
     0.037     0.422     0.150
     0.037     2.531     0.150
     0.085     2.000     0.150
     0.139     4.500     0.150
     0.509     9.062     0.150
     0.597    10.664     0.150
     0.752    12.906     0.150
     0.752    12.703     0.150
     0.752    12.672     0.150
     0.802    14.320     0.150
     0.802    14.227     0.150
     1.140    19.281     0.150
     1.234    22.195     0.150
     1.234    38.633     0.150
     1.293    21.016     0.150
     1.341    23.570     0.150
     1.614    25.492     0.150
     1.616    25.258     0.150
     1.673    27.211     0.150
     1.673    51.234     0.150
     1.780    56.094     0.150
     2.063    64.398     0.150
     2.083    32.219     0.150
     2.083    32.219     0.150
     2.083    32.195     0.150
     2.083    60.234     0.150
     2.439    38.398     0.150
     2.439    75.633     0.150
     2.621    40.523     0.150
     2.621    75.094     0.150
     2.879    45.156     0.150
     2.908    89.633     0.150
     3.753    57.102     0.150
     4.122    60.289     0.150
     4.476    64.875     0.150
     4.642    66.844     0.150
     5.324    77.766     0.150
     5.353    76.641     0.150
     5.384    79.039     0.150
     5.495    78.219     0.150
     5.593    79.180     0.150
     5.969    84.750     0.150
     6.003    84.594     0.150
     6.285    92.219     0.150
     6.285    92.156     0.150
     6.546   105.312     0.150
     6.546    93.211     0.150
     7.132   102.453     0.150
     7.335   104.609     0.150
     7.409   105.539     0.150
     7.588   107.383     0.150
     7.741   245.836     0.150
     7.741   108.594     0.150
     7.803   110.734     0.150
     7.842   110.555     0.150
     7.861   109.984     0.150
     7.869   108.000     0.150
     7.913   113.023     0.150
     7.980   111.664     0.150
     8.354   118.180     0.150
     9.909   137.773     0.150
    10.378   147.422     0.150
    10.379   147.633     0.150
    25.748   324.320     0.150
    37.499   431.250     0.150
    37.804   433.352     0.150
    55.495   571.141     0.150
    81.373   733.352     0.150
     0.069     1.836     0.150
     0.069     9.164     0.150
     0.053     0.453     0.150
     0.053     2.609     0.150
     0.053     0.453     0.150
     0.053     2.609     0.150
     0.053     0.141     0.150
     0.053     2.570     0.150
     0.158     7.656     0.150
     0.158     3.812     0.150
     0.311     6.516     0.150
     0.311     6.523     0.150
     0.428     8.086     0.150
     0.466    17.406     0.150
     0.492     9.016     0.150
     0.502     9.453     0.150
     0.516    17.641     0.150
     0.565    10.656     0.150
     0.619    11.031     0.150
     0.740    12.688     0.150
     0.765    13.156     0.150
     0.765    12.242     0.150
     0.765    23.367     0.150
     0.782    14.305     0.150
     0.782    14.266     0.150
     1.212    21.195     0.150
     1.212    37.984     0.150
     1.293    21.086     0.150
     1.334    23.422     0.150
     1.480    46.406     0.150
     1.537    24.844     0.150
     1.605    25.375     0.150
     1.653    27.164     0.150
     1.653    51.273     0.150
     2.104    32.125     0.150
     2.104    32.109     0.150
     3.669    95.031     0.150
     3.775    57.992     0.150
     4.642    77.711     0.150
     4.914    70.266     0.150
     5.046    73.625     0.150
     5.394    78.672     0.150
     5.605    95.031     0.150
     6.541    93.430     0.150
     7.058   122.930     0.150
     7.581   108.664     0.150
     7.647   130.023     0.150
     7.742   110.203     0.150
     7.820   135.734     0.150
     7.846   112.094     0.150
     7.885   112.945     0.150
     8.358   258.211     0.150
    16.180   223.492     0.150
    16.267   222.336     0.150
     0.159     2.789     0.150
     0.159     5.369     0.150
     0.162     3.476     0.150
     0.162     6.354     0.150
     0.162     3.508     0.150
     0.162     6.369     0.150
     0.214     5.318     0.150
     0.214     9.559     0.150
     0.254     4.798     0.150
     0.313     5.428     0.150
     0.313     9.827     0.150
     0.313     5.428     0.150
     0.313     9.849     0.150
     0.345     6.708     0.150
     0.393     6.829     0.150
     0.465     8.619     0.150
     0.470     8.608     0.150
     0.470    14.999     0.150
     0.518     9.838     0.150
     0.578    10.428     0.150
     0.578    17.798     0.150
     0.603    18.389     0.150
     0.667    22.979     0.150
     0.667    23.019     0.150
     0.700    12.559     0.150
     0.804    14.528     0.150
     0.804    37.418     0.150
     0.804    37.878     0.150
     0.811    24.778     0.150
     0.819    14.367     0.150
     0.843    14.778     0.150
     0.843    14.788     0.150
     0.843    25.159     0.150
     0.831    15.488     0.150
     0.854    26.738     0.150
     0.933     8.639     0.150
     0.933    15.438     0.150
     0.972    29.909     0.150
     0.987    17.028     0.150
     1.017    17.042     0.150
     1.041    18.698     0.150
     1.056    15.008     0.150
     1.056    25.829     0.150
     1.111    19.229     0.150
     1.127    18.652     0.150
     1.127    18.659     0.150
     1.192    19.813     0.150
     1.186    20.307     0.150
     2.008    61.102     0.150
     2.545    78.100     0.150
     2.589    41.568     0.150
     2.939    44.488     0.150
     4.546    68.648     0.150
     5.794    84.608     0.150
     5.877    96.819     0.150
     5.877   184.769     0.150
     7.951   244.797     0.150
     0.109     6.273     0.150
     0.109     6.625     0.150
     0.109     6.742     0.150
     0.111     2.992     0.150
     0.111     6.074     0.150
     0.235    10.355     0.150
     0.235    10.863     0.150
     0.235     5.254     0.150
     0.285    12.414     0.150
     0.291    13.805     0.150
     0.291    20.062     0.150
     0.371    14.645     0.150
     0.418     8.133     0.150
     0.418    14.535     0.150
     0.418    15.965     0.150
     0.503    10.324     0.150
     0.533    19.902     0.150
     0.707    12.273     0.150
     0.731    12.766     0.150
     0.786    26.766     0.150
     0.786    13.625     0.150
     0.813    14.164     0.150
     0.841    26.195     0.150
     0.885    14.902     0.150
     0.856    14.203     0.150
     0.934    15.625     0.150
     0.979    16.645     0.150
     1.016    31.312     0.150
     1.338    21.516     0.150
     1.338    21.465     0.150
     1.327    41.855     0.150
     1.342    26.625     0.150
     1.342    22.855     0.150
     1.402    22.203     0.150
     1.520    23.633     0.150
     1.660    30.023     0.150
     1.761    32.453     0.150
     1.827    28.234     0.150
     1.945    56.453     0.150
     1.945    30.023     0.150
     2.467    38.855     0.150
     3.094    54.664     0.150
     3.646   101.973     0.150
     9.594   136.312     0.150
    95.514     8.199     0.150
     0.033     0.391     0.150
     0.043     6.110     0.150
     0.075     2.011     0.150
     0.075     5.521     0.150
     0.075    10.181     0.150
     0.113    13.461     0.150
     0.113    19.891     0.150
     0.150     3.820     0.150
     0.150     7.540     0.150
     0.150    23.091     0.150
     0.150    28.530     0.150
     0.227     4.650     0.150
     0.227     8.900     0.150
     0.227    15.301     0.150
     0.227    23.820     0.150
     0.248    10.051     0.150
     0.248    24.771     0.150
     0.309    12.370     0.150
     0.309     6.561     0.150
     0.309    34.900     0.150
     0.309    47.480     0.150
     0.323    12.740     0.150
     0.337    38.131     0.150
     0.337    41.950     0.150
     0.364    13.891     0.150
     0.409     7.870     0.150
     0.409    14.591     0.150
     0.447     8.521     0.150
     0.447    17.181     0.150
     0.447    17.370     0.150
     0.460     9.311     0.150
     0.568    10.521     0.150
     0.624    20.271     0.150
     0.719    12.780     0.150
     0.740    12.730     0.150
     0.746    12.950     0.150
     0.753    12.910     0.150
     0.753    25.410     0.150
     0.793    14.330     0.150
     0.921    31.341     0.150
     0.921    31.471     0.150
     1.182    20.570     0.150
     1.219    21.570     0.150
     1.227    21.230     0.150
     1.349    23.620     0.150
     1.605    23.064     0.150
     1.711    26.301     0.150
     2.424    38.230     0.150
     3.113    67.370     0.150
     3.760    55.551     0.150
     6.535   218.721     0.150
     7.007   100.040     0.150
     8.277   117.921     0.150
     8.715   124.990     0.150
     9.318   288.163     0.150
    11.077   346.519     0.150
    14.377   201.320     0.150
    14.461   201.780     0.150
    14.683   204.811     0.150
    15.928   507.515     0.150
    20.369   274.570     0.150
    20.871   279.320     0.150
    21.245   283.271     0.150
    37.793   430.376     0.150
    81.366   734.846     0.150
    84.139   747.796     0.150
    94.811   797.391     0.150
     0.309    12.461     0.150
     0.362     6.977     0.150
     0.469     9.375     0.150
     0.605    11.047     0.150
     0.691    12.852     0.150
     0.690    21.617     0.150
     0.690    21.617     0.150
     0.797    13.688     0.150
     0.845    15.234     0.150
     1.737    28.328     0.150
     5.220    78.008     0.150
     6.704   210.055     0.150
     9.770   138.758     0.150
     9.729   141.125     0.150
    11.494   359.734     0.150
    15.114   210.531     0.150
    16.123   229.086     0.150
    16.404   235.406     0.150
    18.648   258.211     0.150
    20.486   275.312     0.150
    20.967   278.828     0.150
    21.781   287.695     0.150
    22.027   290.742     0.150
    47.083   512.055     0.150
     0.102     2.661     0.150
     0.102     2.671     0.150
     0.146     6.631     0.150
     0.144     3.271     0.150
     0.152     3.851     0.150
     0.153     4.201     0.150
     0.177     4.011     0.150
     0.282     9.460     0.150
     0.282     9.431     0.150
     0.284     5.791     0.150
     0.375     7.051     0.150
     0.375    12.781     0.150
     0.377     7.371     0.150
     0.377    13.581     0.150
     0.396     7.811     0.150
     0.396    18.681     0.150
     0.396    24.971     0.150
     0.427     8.451     0.150
     0.469     8.781     0.150
     0.469    15.190     0.150
     0.482     9.271     0.150
     0.482    16.031     0.150
     0.478     9.230     0.150
     0.604    11.021     0.150
     0.734    12.651     0.150
     0.774    15.210     0.150
     0.947    31.161     0.150
     1.022    17.401     0.150
     1.098    18.611     0.150
     1.098    35.261     0.150
     1.150    18.940     0.150
     1.374    23.521     0.150
     1.440    23.500     0.150
     2.437    37.960     0.150
     4.545    66.951     0.150
     7.875   118.271     0.150
     7.875   146.520     0.150
     7.979   121.057     0.150
    10.748   335.356     0.150
    11.059   165.338     0.150
    37.347   429.815     0.150
     0.048     0.594     0.150
     0.065     1.615     0.150
     0.132    11.193     0.150
     0.155     7.994     0.150
     0.149    -2.115     0.150
     0.149     1.773     0.150
     0.160     3.934     0.150
     0.160     7.824     0.150
     0.242     4.865     0.150
     0.276     6.443     0.150
     0.305    12.334     0.150
     0.305     6.334     0.150
     0.319    12.865     0.150
     0.319     6.785     0.150
     0.327    39.215     0.150
     0.421     8.064     0.150
     0.459     9.145     0.150
     0.541    21.164     0.150
     0.561    19.434     0.150
     0.561    10.434     0.150
     0.594    21.854     0.150
     0.594    21.844     0.150
     0.633    20.205     0.150
     0.634    20.064     0.150
     0.757    13.035     0.150
     0.741    12.594     0.150
     0.781    14.125     0.150
     0.918    30.814     0.150
     0.918    32.264     0.150
     1.204    21.354     0.150
     1.496    22.305     0.150
     1.600    46.598     0.150
     1.652    25.285     0.150
     1.776    26.844     0.150
     2.256    33.023     0.150
     2.438    35.805     0.150
     2.439    35.404     0.150
     2.745    40.404     0.150
     2.940    43.094     0.150
     3.717    61.225     0.150
     3.717   106.924     0.150
     4.988   135.764     0.150
     5.259    75.354     0.150
     7.759   236.949     0.150
     8.350   251.580     0.150
     0.148     2.728     0.150
     0.210     2.648     0.150
     0.234    10.228     0.150
     0.283    11.808     0.150
     0.285     5.888     0.150
     0.326     7.248     0.150
     0.406    15.078     0.150
     0.436     8.018     0.150
     0.503     9.718     0.150
     0.566    10.498     0.150
     0.566    10.478     0.150
     0.586    14.548     0.150
     0.609    11.268     0.150
     0.611    11.048     0.150
     0.618    11.288     0.150
     0.638    10.698     0.150
     0.638    18.608     0.150
     0.684    12.478     0.150
     0.661    12.548     0.150
     0.720    12.658     0.150
     0.710    10.498     0.150
     0.749    13.488     0.150
     0.748    13.378     0.150
     0.896    14.918     0.150
     0.882    15.468     0.150
     1.060    19.328     0.150
     1.060    33.578     0.150
     1.076    19.358     0.150
     1.076    33.478     0.150
     1.524    22.598     0.150
     1.524    22.598     0.150
     1.524    41.608     0.150
     1.575    25.278     0.150
     1.626    27.078     0.150
     1.765    29.468     0.150
     1.765    52.638     0.150
     1.817    30.748     0.150
     1.864    30.038     0.150
     2.161    32.738     0.150
     2.233    36.578     0.150
     2.330    44.568     0.150
     2.697    40.428     0.150
     4.680    85.018     0.150
     5.079    74.458     0.150
     7.920   150.953     0.150
     7.920   256.591     0.150
     8.428   159.003     0.150
    11.429   369.301     0.150
    23.057   308.702     0.150
     0.151     2.789     0.150
     0.151     2.789     0.150
     0.151     5.852     0.150
     0.110     2.551     0.150
     0.110     4.719     0.150
     0.125     2.578     0.150
     0.125     5.051     0.150
     0.191     3.398     0.150
     0.191     6.379     0.150
     0.243     4.852     0.150
     0.243     8.500     0.150
     0.240     4.969     0.150
     0.242    11.250     0.150
     0.362     7.180     0.150
     0.375     7.281     0.150
     0.375    13.539     0.150
     0.346    13.430     0.150
     0.346     7.109     0.150
     0.395     7.199     0.150
     0.448    15.750     0.150
     0.492    16.750     0.150
     0.562    18.270     0.150
     0.539    17.602     0.150
     0.616    11.168     0.150
     0.616    20.641     0.150
     0.638    23.789     0.150
     0.669    12.328     0.150
     0.640    22.199     0.150
     0.706    10.609     0.150
     0.705    24.668     0.150
     0.705    12.840     0.150
     0.705    22.301     0.150
     0.730    26.750     0.150
     0.772    13.648     0.150
     0.772    25.078     0.150
     0.864    30.480     0.150
     0.908    15.469     0.150
     0.996    30.109     0.150
     1.022    14.508     0.150
     1.050    19.441     0.150
    52.545    54.012     0.150
    45.837    60.789     0.150
     6.030    83.098     0.150
     6.030   185.746     0.150
     7.522   108.219     0.150
     8.013   113.066     0.150
     8.013   146.691     0.150
     8.013   255.641     0.150
     8.111   153.160     0.150
     8.111   258.160     0.150
    10.974   201.391     0.150
    11.179   364.973     0.150
    99.171   812.016     0.150
     0.128    42.898     0.150
     0.128    44.297     0.150
     0.165     7.738     0.150
     0.175    10.168     0.150
     0.175    10.217     0.150
     0.315    12.518     0.150
     0.315     6.408     0.150
     0.319    25.168     0.150
     0.319    28.678     0.150
     0.297     5.729     0.150
     0.324    13.117     0.150
     0.483     8.818     0.150
     0.528     9.668     0.150
     0.528     9.527     0.150
     0.528     9.527     0.150
     0.595    24.098     0.150
     0.629    11.398     0.150
     0.622    11.318     0.150
     0.666    12.377     0.150
     0.825    12.768     0.150
     0.896    32.988     0.150
     1.176    38.748     0.150
     1.187    21.627     0.150
     1.596   623.848     0.150
     1.664    26.588     0.150
     1.702    27.447     0.150
     0.054    27.717     0.150
     3.702   103.979     0.150
     3.702    59.137     0.150
     3.802    56.357     0.150
     5.275   136.838     0.150
     5.275    76.887     0.150
     5.850   157.758     0.150
     6.550   117.523     0.150
     6.550   204.197     0.150
     8.147   117.768     0.150
    10.421   331.723     0.150
    12.742   175.418     0.150
    15.958   507.018     0.150
    18.238   250.729     0.150
    59.536  1091.047     0.150
     0.106     5.369     0.150
     0.106    11.069     0.150
     0.150     8.199     0.150
     0.214     4.659     0.150
     0.332     6.589     0.150
     0.332    12.648     0.150
     0.330     6.398     0.150
     0.330    12.139     0.150
     0.352    12.929     0.150
     0.345    13.389     0.150
     0.345    13.529     0.150
     0.441     8.378     0.150
     0.444    17.958     0.150
     0.444    19.429     0.150
     0.554    10.549     0.150
     0.602    10.789     0.150
     0.633    11.469     0.150
     0.609    11.688     0.150
     0.609    20.438     0.150
     0.696    20.438     0.150
     0.696    11.769     0.150
     0.740    13.569     0.150
     0.753    25.079     0.150
     0.787    14.079     0.150
     0.767    11.759     0.150
     0.848    14.349     0.150
     0.872    29.319     0.150
     0.872    29.389     0.150
     0.872    15.708     0.150
     0.872    28.549     0.150
     1.041    18.139     0.150
     1.041    33.739     0.150
     1.131    35.449     0.150
     1.145    20.769     0.150
     1.145    35.609     0.150
     1.257    38.148     0.150
     1.270    22.519     0.150
     1.270    39.119     0.150
     1.511    42.438     0.150
     1.795    30.049     0.150
     1.795    55.668     0.150
     2.518    39.999     0.150
     3.847    58.729     0.150
     5.086    74.969     0.150
     5.468    79.279     0.150
     6.382    91.019     0.150
     7.850   146.238     0.150
     7.850   114.389     0.150
     8.414   159.069     0.150
     8.414   124.398     0.150
    13.885   192.469     0.150
    37.825   440.027     0.150
     0.040     0.398     0.150
     0.040     0.398     0.150
     0.040     0.398     0.150
     0.040     2.758     0.150
     0.040     4.949     0.150
     0.082     8.637     0.150
     0.084     1.336     0.150
     0.142     6.957     0.150
     0.227     4.328     0.150
     0.256    11.098     0.150
     0.302    12.449     0.150
     0.302     6.520     0.150
     0.302    12.457     0.150
     0.319    12.258     0.150
     0.319     6.566     0.150
     0.319    12.180     0.150
     0.345    15.508     0.150
     0.345    17.828     0.150
     0.549    21.137     0.150
     0.549    21.277     0.150
     0.730    11.996     0.150
     1.100    34.938     0.150
     1.230    21.477     0.150
     1.230    37.609     0.150
     1.339    23.438     0.150
     1.339    41.688     0.150
     1.494    25.227     0.150
     1.600    24.238     0.150
     1.679    25.719     0.150
     1.749    25.598     0.150
     2.087    30.488     0.150
     2.247    37.129     0.150
     2.429    39.699     0.150
     2.939    46.719     0.150
     4.971    78.680     0.150
     4.971   134.898     0.150
     5.241    85.418     0.150
     5.241    85.418     0.150
     6.546    99.777     0.150
     6.546   205.180     0.150
     7.745   115.875     0.150
     7.745   250.078     0.150
     0.073     8.887     0.150
     0.129     8.137     0.150
     0.309     6.516     0.150
     0.336    25.596     0.150
     0.449     8.375     0.150
     0.488     9.217     0.150
     0.497     9.047     0.150
     0.510     9.775     0.150
     0.552    21.227     0.150
     0.552    22.246     0.150
     0.629    11.436     0.150
     0.643    11.445     0.150
     0.719    12.695     0.150
     0.748    12.936     0.150
     0.791    14.266     0.150
     0.802    13.977     0.150
     1.010    30.566     0.150
     1.217    21.387     0.150
     1.596    35.031     0.150
     1.596   470.645     0.150
     1.604    24.705     0.150
     7.537    33.146     0.150
     3.716    53.096     0.150
     3.716    97.057     0.150
     4.981    78.686     0.150
     6.535    93.350     0.150
     7.746   110.154     0.150
     7.746   139.881     0.150
     7.746   202.555     0.150
     7.746   110.156     0.150
     8.346   116.711     0.150
     8.346   255.311     0.150
    11.296   160.402     0.150
    11.296   160.406     0.150
     0.092     1.859     0.150
     0.092     3.809     0.150
     0.218     5.359     0.150
     0.218     9.438     0.150
     0.513    10.188     0.150
     0.895    15.656     0.150
     1.049    17.637     0.150
     2.277    36.469     0.150
     2.777    43.090     0.150
     5.206    75.719     0.150
     5.344    78.117     0.150
     5.893   106.852     0.150
     5.893   184.340     0.150
     7.501   105.949     0.150
     7.582   108.078     0.150
     7.675   109.668     0.150
     7.708   109.137     0.150
     7.768   108.539     0.150
     7.806   109.340     0.150
    17.275   109.430     0.150
     7.721   109.727     0.150
     7.868   110.367     0.150
     8.000   114.309     0.150
     8.054   112.957     0.150
     8.078   115.059     0.150
     8.249   150.973     0.150
     8.993   128.508     0.150
    10.357   145.457     0.150
    11.173   156.539     0.150
     0.077     1.383     0.150
     0.099     2.172     0.150
     0.073     1.742     0.150
     0.154     2.742     0.150
     0.154     2.793     0.150
     0.107     2.691     0.150
     0.107     2.730     0.150
     0.107     5.949     0.150
     0.107     6.500     0.150
     0.205     3.840     0.150
     0.205     3.840     0.150
     0.146     3.090     0.150
     0.146     6.062     0.150
     0.219     4.133     0.150
     0.219     4.133     0.150
     0.146     3.230     0.150
     0.222     4.359     0.150
     0.333    11.422     0.150
     0.333    11.449     0.150
     0.356     6.750     0.150
     0.356    12.852     0.150
     0.339    13.070     0.150
     0.339    19.422     0.150
     0.337    13.141     0.150
     0.415    14.723     0.150
     0.407     7.621     0.150
     0.403     7.320     0.150
     0.369    14.430     0.150
     0.398     8.242     0.150
     0.398    15.180     0.150
     0.444    17.133     0.150
     0.503    16.590     0.150
     0.448     8.090     0.150
     0.468     8.801     0.150
     0.533    10.211     0.150
     0.559    10.680     0.150
     0.559    10.660     0.150
     0.559    19.852     0.150
     0.555    10.570     0.150
     0.555    20.000     0.150
     0.592    10.902     0.150
     0.716    12.359     0.150
     0.685    12.941     0.150
     0.685    22.781     0.150
     0.720    12.961     0.150
     0.720    24.211     0.150
     0.777    13.461     0.150
     0.777    24.043     0.150
     0.752    24.520     0.150
     0.904    28.961     0.150
     1.092    20.332     0.150
     1.106    35.582     0.150
     1.190   340.523     0.150
     1.296    21.223     0.150
     2.188    23.391     0.150
     7.375    27.582     0.150
     1.946    30.840     0.150
     6.156    86.414     0.150
     6.156   104.945     0.150
     6.156   189.160     0.150
     7.902   107.039     0.150
     7.902   136.816     0.150
     7.902   237.363     0.150
     8.051   111.570     0.150
     8.051   142.895     0.150
     8.051   243.672     0.150
    10.678   149.750     0.150
    10.733   147.035     0.150
    10.733   325.945     0.150
    11.127   154.621     0.150
    11.127   343.621     0.150
    22.808   295.945     0.150
    29.834   361.746     0.150
    37.413   429.449     0.150
     0.074     1.500     0.150
     0.097     2.242     0.150
     0.148     2.711     0.150
     0.148     2.758     0.150
     0.107     2.602     0.150
     0.107     5.719     0.150
     0.150     3.070     0.150
     0.150     6.203     0.150
     0.200     3.820     0.150
     0.200     3.820     0.150
     0.200     7.961     0.150
     0.151     3.117     0.150
     0.220     8.820     0.150
     0.351     6.773     0.150
     0.351    13.000     0.150
     0.339    15.641     0.150
     0.403     7.281     0.150
     0.403     7.438     0.150
     0.372    14.383     0.150
     0.396    14.984     0.150
     0.410    15.859     0.150
     0.451     8.039     0.150
     0.471     8.805     0.150
     0.602    18.078     0.150
     0.558    19.570     0.150
     0.556    19.734     0.150
     0.596    10.719     0.150
     0.690    12.852     0.150
     0.690    22.602     0.150
     0.752    25.312     0.150
     0.838    13.969     0.150
     0.929    15.578     0.150
     0.929    27.914     0.150
     0.969    15.961     0.150
     1.295    21.383     0.150
     1.841    28.438     0.150
     1.951    32.484     0.150
     2.102    35.781     0.150
     2.433    39.523     0.150
     2.472    39.844     0.150
     2.736    44.281     0.150
     2.751    44.008     0.150
     2.790    44.562     0.150
     3.205    48.234     0.150
     6.152   190.562     0.150
     6.152    91.883     0.150
     7.898   116.633     0.150
    11.121   161.383     0.150
     0.086     1.988     0.150
     0.179     2.877     0.150
     0.149     2.818     0.150
     0.149     5.309     0.150
     0.229    11.797     0.150
     0.220     6.488     0.150
     0.209     7.889     0.150
     0.209     7.838     0.150
     0.209     8.309     0.150
     0.209     9.357     0.150
     0.239     7.068     0.150
     0.209     8.947     0.150
     0.209     9.068     0.150
     0.209     4.428     0.150
     0.312    13.848     0.150
     0.312    15.229     0.150
     0.372    13.979     0.150
     0.399     7.627     0.150
     0.395     7.787     0.150
     0.406     7.848     0.150
     0.376     7.748     0.150
     0.376    15.838     0.150
     0.573    28.498     0.150
     0.650    19.688     0.150
     0.650    11.867     0.150
     0.650    11.877     0.150
     0.635    11.717     0.150
     0.705    26.537     0.150
     0.705    27.648     0.150
     0.752    26.729     0.150
     0.729    13.658     0.150
     0.729    27.197     0.150
     0.773    14.188     0.150
     0.781    14.607     0.150
     0.781    24.877     0.150
     1.003    12.178     0.150
     1.025    17.797     0.150
     1.097    18.848     0.150
     1.996    20.877     0.150
     1.363    23.568     0.150
     4.738    71.117     0.150
     5.916    88.068     0.150
     6.026   189.682     0.150
     8.021   145.791     0.150
     8.144   251.100     0.150
    10.507   150.609     0.150
    10.507   320.342     0.150
     4.272   210.758     0.150
     0.169    16.082     0.150
     0.186    12.691     0.150
     0.186     3.172     0.150
     0.186     6.381     0.150
     0.253    10.041     0.150
     0.253     5.031     0.150
     0.253    10.082     0.150
     0.253     2.922     0.150
     0.253     5.021     0.150
     0.253     5.922     0.150
     0.253    10.041     0.150
     0.298    11.871     0.150
     0.298    13.002     0.150
     0.298     5.711     0.150
     0.290     5.082     0.150
     0.344     6.252     0.150
     0.344    11.432     0.150
     0.336    12.621     0.150
     0.336    12.650     0.150
     0.359    13.381     0.150
     0.359     7.281     0.150
     0.359    13.422     0.150
     0.395    14.811     0.150
     0.414    15.141     0.150
     0.414    16.992     0.150
     0.400     7.641     0.150
     0.441    16.221     0.150
     0.453     8.531     0.150
     0.481    16.721     0.150
     0.497     9.602     0.150
     0.497    17.861     0.150
     0.548     9.041     0.150
     0.548    15.752     0.150
     0.493    17.852     0.150
     0.493     9.791     0.150
     0.493    17.852     0.150
     0.548     9.002     0.150
     0.527    10.111     0.150
     0.527    17.582     0.150
     0.587    10.781     0.150
     0.585    19.801     0.150
     0.593    10.791     0.150
     0.611    20.721     0.150
     0.633    22.471     0.150
     0.633    23.531     0.150
     0.657    11.992     0.150
     0.675    12.512     0.150
     0.675    23.150     0.150
     0.673    12.271     0.150
     0.719    10.111     0.150
     0.799    26.662     0.150
     0.790    25.172     0.150
     0.885    15.002     0.150
     0.914    15.602     0.150
     0.967    16.971     0.150
     1.002    17.391     0.150
     0.992    18.230     0.150
     0.992    31.361     0.150
     1.002    18.051     0.150
     1.002    31.031     0.150
     1.375    23.502     0.150
     1.609    25.611     0.150
     1.609    43.041     0.150
     1.813    30.422     0.150
     1.813    53.172     0.150
     3.514    54.801     0.150
     3.547    51.752     0.150
     3.802    59.422     0.150
     3.986   104.951     0.150
     4.571    70.221     0.150
     4.592    70.650     0.150
     5.142    76.621     0.150
     5.142   138.961     0.150
     5.392    81.162     0.150
     6.730    99.412     0.150
     6.730   172.781     0.150
     0.781    14.406     0.150
     0.461    15.996     0.150
     0.461     8.896     0.150
     0.461    15.416     0.150
     0.314     6.166     0.150
     0.314    10.986     0.150
     1.024    18.467     0.150
     0.247     5.117     0.150
     0.178     4.027     0.150
     0.771    24.156     0.150
     0.887    15.846     0.150
     0.887    27.926     0.150
     0.696    30.197     0.150
     0.696    12.406     0.150
     0.468    14.117     0.150
     0.437    30.938     0.150
     0.437    31.896     0.150
     0.194     9.117     0.150
     0.194     4.736     0.150
     0.194     9.127     0.150
     0.194     9.607     0.150
     0.194    21.676     0.150
     0.035     2.477     0.150
     0.921    30.146     0.150
     0.921    16.287     0.150
     0.630    22.947     0.150
     0.630    11.357     0.150
     0.338     6.477     0.150
     0.499    63.766     0.150
     0.499    69.207     0.150
     0.136     6.666     0.150
     0.645    11.447     0.150
     0.120     2.957     0.150
     0.120     2.977     0.150
     0.524    19.367     0.150
     1.147    19.807     0.150
     0.119     2.697     0.150
     0.148     3.127     0.150
     0.148     3.256     0.150
     0.812    13.957     0.150
     0.812    14.086     0.150
     1.143    19.486     0.150
     0.632    11.346     0.150
     0.253     5.117     0.150
     0.253     9.836     0.150
     1.065    36.188     0.150
     1.065    18.117     0.150
     0.509    17.586     0.150
     0.812    14.156     0.150
     0.812    29.127     0.150
     0.812    14.156     0.150
     0.692    11.896     0.150
     1.212    20.146     0.150
     1.103    18.066     0.150
     0.932    29.197     0.150
     1.204    19.586     0.150
     6.051    89.277     0.150
     7.725   118.246     0.150
     9.371   139.688     0.150
    10.577   150.705     0.150
    10.577   327.205     0.150
    10.784   342.674     0.150
    10.661   156.947     0.150
    11.044   344.977     0.150
    15.228   212.797     0.150
    15.507   215.307     0.150
    15.625   217.576     0.150
    18.435   259.217     0.150
    20.500   280.537     0.150
    20.491   274.787     0.150
    21.465   290.467     0.150
    22.070   291.646     0.150
    22.343   293.496     0.150
    22.738   298.877     0.150
    23.098   302.617     0.150
    23.516   305.967     0.150
    23.661   307.926     0.150
    23.950   316.756     0.150
    23.950   310.217     0.150
    24.401   314.277     0.150
    26.863   338.117     0.150
    27.450     0.006     0.150
    32.873   388.166     0.150
    53.098   560.816     0.150
    55.224   570.717     0.150
    55.224   575.977     0.150
    59.934   608.977     0.150
    74.102   698.402     0.150
    80.794   737.152     0.150
    84.141   756.107     0.150
    87.008   767.791     0.150
   117.047  1129.535     0.150
   146.205  1184.502     0.150
     0.081    -3.465     0.150
     0.081     1.846     0.150
     0.038    -0.475     0.150
     0.038     2.295     0.150
     0.128     2.705     0.150
     0.114     1.154     0.150
     0.114     2.645     0.150
     0.147     3.084     0.150
     0.147     3.084     0.150
     0.147     6.436     0.150
     0.149     3.705     0.150
     0.149     6.775     0.150
     0.180     8.574     0.150
     0.176     7.314     0.150
     0.176     1.875     0.150
     0.176     3.875     0.150
     0.176     7.285     0.150
     0.180     4.385     0.150
     0.264    33.674     0.150
     0.264    10.125     0.150
     0.254     9.096     0.150
     0.236     4.834     0.150
     0.236     9.275     0.150
     0.349     6.436     0.150
     0.349    11.904     0.150
     0.392     7.424     0.150
     0.392     7.395     0.150
     0.421    16.195     0.150
     0.423    20.105     0.150
     0.455    14.215     0.150
     0.455    24.965     0.150
     0.466     8.846     0.150
     0.499    17.605     0.150
     0.629    18.025     0.150
     0.619    11.355     0.150
     0.616    11.494     0.150
     0.632    22.115     0.150
     0.689    11.754     0.150
     0.706    12.186     0.150
     0.683    23.355     0.150
     0.683    23.664     0.150
     0.683    12.186     0.150
     0.772    14.234     0.150
     0.800    13.725     0.150
     0.800    36.705     0.150
     0.800    25.295     0.150
     0.799    13.914     0.150
     0.928    30.285     0.150
     0.928    30.596     0.150
     2.143    35.285     0.150
     3.821    60.115     0.150
     6.065    89.096     0.150
     7.888   118.840     0.150
     7.888   250.883     0.150
     7.960   255.904     0.150
     7.960   118.814     0.150
    10.591   152.264     0.150
    10.591   329.914     0.150
    10.591   152.266     0.150
    10.773   343.666     0.150
    11.050   166.484     0.150
    11.050   365.012     0.150
    15.518   224.602     0.150
    22.742   306.457     0.150
    27.463   347.414     0.150
    79.747   725.053     0.150
     0.131     2.805     0.150
     0.131     2.805     0.150
     0.115     2.715     0.150
     0.116     2.725     0.150
     0.149     3.154     0.150
     0.149     3.154     0.150
     0.150     3.453     0.150
     0.178     4.475     0.150
     0.255    14.215     0.150
     0.233     4.943     0.150
     0.316     6.203     0.150
     0.316    11.094     0.150
     0.394     7.504     0.150
     0.421    20.494     0.150
     0.421    27.094     0.150
     0.464    17.545     0.150
     0.464     8.895     0.150
     0.484    19.225     0.150
     0.510    19.363     0.150
     0.618    22.045     0.150
     0.618    11.244     0.150
     0.614    22.555     0.150
     0.614    11.193     0.150
     0.691    11.895     0.150
     0.707    12.244     0.150
     0.681    12.225     0.150
     0.681    21.943     0.150
     0.800    15.453     0.150
     0.769    14.254     0.150
     0.797    13.764     0.150
     0.797    13.805     0.150
     0.995    16.975     0.150
     1.046    17.953     0.150
     1.073    18.104     0.150
     1.118    18.295     0.150
     0.438    21.273     0.150
     1.386    23.654     0.150
     7.303    26.154     0.150
     6.067   110.184     0.150
     6.067   191.018     0.150
     7.890   117.436     0.150
     7.890   254.492     0.150
    10.773   342.328     0.150
    15.521   223.516     0.150
     0.051     5.853     0.150
     0.059     0.683     0.150
     0.059     0.683     0.150
     0.059     0.683     0.150
     0.059     2.633     0.150
     0.143     3.212     0.150
     0.143     8.123     0.150
     0.143     8.243     0.150
     0.175     3.962     0.150
     0.175     7.922     0.150
     0.175     8.223     0.150
     0.175     8.312     0.150
     0.257     4.933     0.150
     0.257     9.752     0.150
     0.246     4.692     0.150
     0.294    12.403     0.150
     0.294    12.573     0.150
     0.294     6.133     0.150
     0.294    11.283     0.150
     0.312    16.743     0.150
     0.312     5.732     0.150
     0.333    12.843     0.150
     0.333     6.823     0.150
     0.333    13.022     0.150
     0.333    13.473     0.150
     0.333    14.522     0.150
     0.426    15.962     0.150
     0.474     8.613     0.150
     0.495     9.292     0.150
     0.502     9.663     0.150
     0.502    18.982     0.150
     0.531    10.413     0.150
     0.577    19.953     0.150
     0.577    21.453     0.150
     0.607    21.042     0.150
     0.709    12.133     0.150
     0.709    12.383     0.150
     0.709    24.343     0.150
     0.762    13.002     0.150
     0.765    13.993     0.150
     0.782    13.712     0.150
     0.994    27.513     0.150
     1.049    17.522     0.150
     1.082    20.922     0.150
     1.189    21.192     0.150
     1.189    38.243     0.150
     1.197    21.603     0.150
     1.197    37.113     0.150
     1.315    20.493     0.150
     1.315    36.833     0.150
     1.343    23.333     0.150
     1.343    43.493     0.150
     1.557    25.493     0.150
     1.557    44.223     0.150
     1.587    24.243     0.150
     1.587    51.507     0.150
     1.774    27.643     0.150
     1.874    31.413     0.150
     1.874    58.792     0.150
     3.790    56.373     0.150
     3.790   103.613     0.150
     5.001   137.603     0.150
     5.001    77.833     0.150
     5.001   137.603     0.150
     5.275   144.133     0.150
     5.275    80.172     0.150
     5.275   144.133     0.150
     6.526    95.663     0.150
    11.307   209.462     0.150
    11.307   364.038     0.150
    37.784   435.212     0.150
    37.784   435.002     0.150
    80.210   729.312     0.150
    80.210   729.312     0.150
     0.048     6.984     0.150
     0.048     1.023     0.150
     0.048     1.039     0.150
     0.048     1.023     0.150
     0.048     6.359     0.150
     0.132     9.016     0.150
     0.152     8.445     0.150
     0.177     4.148     0.150
     0.247    25.508     0.150
     0.247    25.961     0.150
     0.247     9.484     0.150
     0.247    16.836     0.150
     0.247    38.875     0.150
     0.310    23.539     0.150
     0.263     5.297     0.150
     0.338     7.039     0.150
     0.338    12.227     0.150
     0.338    53.156     0.150
     0.338    53.977     0.150
     0.409    15.359     0.150
     0.478     8.977     0.150
     0.489     9.484     0.150
     0.489    17.367     0.150
     0.604    10.961     0.150
     0.547    10.875     0.150
     0.547    19.117     0.150
     0.697    12.539     0.150
     0.697    23.477     0.150
     0.613    22.328     0.150
     0.613    23.766     0.150
     0.715    21.969     0.150
     0.777    13.688     0.150
     0.766    13.859     0.150
     0.986    30.086     0.150
     0.938    18.016     0.150
     0.938    16.688     0.150
     1.197    21.289     0.150
     1.527    28.039     0.150
     1.717    28.297     0.150
     2.211    36.070     0.150
     2.423    38.078     0.150
     6.543   175.719     0.150
     8.163   216.516     0.150
     8.905    99.773     0.150
     8.905   239.016     0.150
     9.342   243.328     0.150
    10.130   100.594     0.150
    10.130   280.875     0.150
    10.675   109.766     0.150
    10.675   290.844     0.150
    11.053   158.727     0.150
    11.334   294.484     0.150
    11.506   115.039     0.150
    11.506   317.414     0.150
    12.127   120.828     0.150
    12.127   330.047     0.150
    13.695   200.773     0.150
    16.675   234.664     0.150
    16.800   236.539     0.150
    18.848   226.625     0.150
    29.978   367.891     0.150
    43.206   481.469     0.150
    45.247   499.305     0.150
    57.777   509.898     0.150
    47.304   514.938     0.150
    47.304   513.836     0.150
    64.589   637.773     0.150
    80.789   732.766     0.150
    81.106   734.438     0.150
    82.142   740.523     0.150
     1.482   788.875     0.150
    99.602   823.461     0.150
    99.602   823.555     0.150
   102.658   843.914     0.150
     0.041     6.156     0.150
     0.041     7.266     0.150
     0.060     1.102     0.150
     0.144     7.625     0.150
     0.154     7.570     0.150
     0.154     3.477     0.150
     0.154     8.977     0.150
     0.154     8.992     0.150
     0.184     4.094     0.150
     0.184     8.734     0.150
     0.259     4.891     0.150
     0.259    10.000     0.150
     0.259    10.180     0.150
     0.303    18.570     0.150
     0.303     5.664     0.150
     0.257     4.922     0.150
     0.257    10.141     0.150
     0.343    13.070     0.150
     0.343     7.094     0.150
     0.343    12.930     0.150
     0.465    17.336     0.150
     0.465     8.414     0.150
     0.536    10.562     0.150
     0.610    10.961     0.150
     0.697    12.422     0.150
     0.772    13.523     0.150
     0.757    13.797     0.150
     0.923    17.641     0.150
     1.353    23.445     0.150
     1.491    24.961     0.150
     1.516    27.516     0.150
     1.576    43.664     0.150
     1.764    29.305     0.150
     2.205    35.852     0.150
     2.430    39.305     0.150
     3.094    48.383     0.150
     3.172    50.500     0.150
     6.514   118.125     0.150
     8.336   259.250     0.150
    10.423   331.320     0.150
    11.299   161.273     0.150
    11.299   363.977     0.150
    16.547   230.516     0.150
     0.152     7.430     0.150
     0.062     1.109     0.150
     0.062     1.023     0.150
     0.183     8.180     0.150
     0.261     5.023     0.150
     0.261    12.859     0.150
     0.261    16.344     0.150
     0.342    13.203     0.150
     0.342    20.047     0.150
     0.303     5.641     0.150
     0.352    13.812     0.150
     0.481     8.773     0.150
     0.466     8.492     0.150
     0.616    11.211     0.150
     0.480     9.430     0.150
     0.489     9.172     0.150
     0.493     9.383     0.150
     0.603    10.930     0.150
     0.632    20.359     0.150
     0.700    12.391     0.150
     0.700    23.039     0.150
     0.773    13.688     0.150
     0.932    16.367     0.150
     1.332    21.102     0.150
     1.566    39.992     0.150
     1.880    59.008     0.150
     1.721    28.961     0.150
     1.767    30.438     0.150
     2.434    40.219     0.150
     2.939    47.531     0.150
     3.735   104.727     0.150
     6.517   116.828     0.150
     7.775   250.945     0.150
    11.054   157.141     0.150
    11.303   364.977     0.150
    18.852   259.602     0.150
    20.868   281.062     0.150
    22.917   306.672     0.150
    26.670   341.742     0.150
    37.775   435.930     0.150
    47.311   516.852     0.150
    80.201   729.773     0.150
    83.663   747.375     0.150
    91.523   787.383     0.150
     0.035     1.129     0.150
     0.035     1.129     0.150
     0.035     1.129     0.150
     0.035     3.439     0.150
     0.056     7.419     0.150
     0.156     7.879     0.150
     0.156     3.839     0.150
     0.156     7.770     0.150
     0.173     4.129     0.150
     0.173     8.049     0.150
     0.234     4.719     0.150
     0.275     5.499     0.150
     0.316    15.369     0.150
     0.316    17.389     0.150
     0.316     5.929     0.150
     0.337     7.119     0.150
     0.337    13.270     0.150
     0.394    21.249     0.150
     0.465     8.849     0.150
     0.454     8.499     0.150
     0.482     9.359     0.150
     0.482    26.509     0.150
     0.476     8.659     0.150
     0.564    11.089     0.150
     0.613    21.899     0.150
     0.613    22.959     0.150
     0.692    24.009     0.150
     0.715    21.869     0.150
     0.715    23.779     0.150
     0.730    20.749     0.150
     0.779    13.609     0.150
     0.774    14.079     0.150
     0.819    26.749     0.150
     0.985    27.629     0.150
     0.947    16.499     0.150
     1.078    18.809     0.150
     1.168    22.099     0.150
     1.209    21.279     0.150
     1.209    37.789     0.150
     1.214    21.439     0.150
     1.214    37.509     0.150
     1.240    20.869     0.150
     1.373    22.699     0.150
     1.372    23.729     0.150
     1.372    23.729     0.150
     1.372    42.209     0.150
     1.578    22.809     0.150
     1.578    41.520     0.150
     1.538    28.259     0.150
     1.906    31.839     0.150
     1.906    57.289     0.150
     3.743    62.439     0.150
     3.743    62.439     0.150
     3.771    55.309     0.150
     3.771    99.569     0.150
     5.005   135.559     0.150
     5.005    77.029     0.150
     5.005   135.559     0.150
     5.267    82.889     0.150
     5.267   142.589     0.150
     5.267    82.889     0.150
     5.267   142.589     0.150
     6.534    92.349     0.150
     6.534    92.349     0.150
     6.534   169.020     0.150
     7.451   109.729     0.150
     7.745   109.908     0.150
     8.894   124.869     0.150
     8.894   225.559     0.150
    10.120   250.139     0.150
    10.405   330.664     0.150
    10.719   152.819     0.150
    11.496   173.109     0.150
    80.192   730.489     0.150
     0.024     1.570     0.150
     0.024     1.580     0.150
     0.024     4.141     0.150
     0.024     1.570     0.150
     0.024     4.070     0.150
     0.082     9.199     0.150
     0.082    12.551     0.150
     0.312    12.920     0.150
     0.312    35.301     0.150
     0.312    38.080     0.150
     0.308    13.430     0.150
     0.344    13.561     0.150
     0.344    24.920     0.150
     0.344    35.301     0.150
     0.481     9.090     0.150
     0.481    23.990     0.150
     0.509     9.721     0.150
     0.509    19.381     0.150
     0.509    19.520     0.150
     0.510    18.980     0.150
     0.505    28.570     0.150
     0.505     9.230     0.150
     0.591    21.859     0.150
     0.591    31.670     0.150
     0.564    21.400     0.150
     0.564    22.160     0.150
     0.634    11.461     0.150
     0.634    32.750     0.150
     0.634    32.869     0.150
     0.652    11.730     0.150
     0.739    12.650     0.150
     0.744    23.801     0.150
     0.744    34.141     0.150
     0.744    34.230     0.150
     0.769    25.990     0.150
     0.809    27.039     0.150
     0.809    13.990     0.150
     0.809    47.980     0.150
     1.229    21.461     0.150
     1.229    39.500     0.150
     1.236    21.480     0.150
     1.236    38.520     0.150
     1.354    23.439     0.150
     1.354    44.119     0.150
     1.552    22.580     0.150
     1.552    40.500     0.150
     1.478    24.369     0.150
     1.467    26.859     0.150
     1.601   567.000     0.150
     1.601    27.000     0.150
     1.892    31.529     0.150
     1.892    57.260     0.150
     2.420    41.350     0.150
     3.750    55.770     0.150
     3.750    99.580     0.150
     3.715    67.881     0.150
     3.715    67.881     0.150
     4.975    76.279     0.150
     5.240    77.850     0.150
     5.240    78.480     0.150
     5.843   156.010     0.150
     6.508    96.039     0.150
     6.535   118.625     0.150
     6.535    95.180     0.150
     7.733   115.143     0.150
     8.132   119.381     0.150
     8.341   258.900     0.150
    11.287   362.301     0.150
    14.587   203.840     0.150
    15.925   227.857     0.150
    38.595   441.721     0.150
    80.220   729.850     0.150
    80.220   729.850     0.150
    57.788   114.039     0.150
     0.010     1.832     0.150
     0.137     7.922     0.150
     0.137     7.961     0.150
     0.304    13.160     0.150
     0.304    13.262     0.150
     0.315    29.031     0.150
     0.357    20.812     0.150
     0.416    14.793     0.150
     0.467    23.820     0.150
     0.515    23.973     0.150
     0.579    22.090     0.150
     0.579    27.312     0.150
     0.587    22.172     0.150
     0.665    11.551     0.150
     0.748    34.242     0.150
     0.817    54.000     0.150
     1.249    21.691     0.150
     1.282    21.250     0.150
     1.369    23.461     0.150
     1.559    40.602     0.150
     1.604   486.051     0.150
     1.612    31.070     0.150
     1.693    65.133     0.150
     1.693    68.602     0.150
     1.698    69.070     0.150
     1.698    73.203     0.150
     3.731   104.703     0.150
     5.159    76.680     0.150
     5.226    74.141     0.150
     5.226   141.250     0.150
     5.313    77.711     0.150
     5.673    89.660     0.150
     5.673   154.492     0.150
     5.839   157.531     0.150
     6.512   102.852     0.150
     6.531   201.402     0.150
     6.538   102.551     0.150
     7.711   114.469     0.150
     7.711   116.453     0.150
     9.912   149.051     0.150
    10.364   324.410     0.150
    11.078   156.891     0.150
    11.269   205.180     0.150
    12.544   176.602     0.150
    14.100   195.500     0.150
    14.368   201.621     0.150
    14.444   201.773     0.150
    14.729   213.652     0.150
    15.915   494.547     0.150
    16.748   243.051     0.150
    18.857   256.062     0.150
    20.337   279.410     0.150
    20.337   273.191     0.150
    20.829   279.023     0.150
    20.854   279.430     0.150
    22.873   726.453     0.150
    22.887   308.473     0.150
    22.887   309.152     0.150
    24.203   322.352     0.150
    27.914   347.891     0.150
    30.905   381.250     0.150
    35.055   420.980     0.150
    45.202   502.980     0.150
    46.198   509.352     0.150
    47.257   518.430     0.150
    47.354   518.863     0.150
    55.464   579.480     0.150
    74.257   702.781     0.150
   145.847  1182.125     0.150
     0.147     7.551     0.150
     0.147    17.363     0.150
     0.201     8.363     0.150
     0.201     4.434     0.150
     0.201     8.371     0.150
     0.201     8.691     0.150
     0.271    10.941     0.150
     0.271     5.980     0.150
     0.271    11.410     0.150
     0.271    24.781     0.150
     0.288    11.602     0.150
     0.288    11.371     0.150
     0.288    12.492     0.150
     0.288    12.820     0.150
     0.290     5.531     0.150
     0.290     9.910     0.150
     0.389     8.062     0.150
     0.389    13.684     0.150
     0.390    14.762     0.150
     0.340    13.023     0.150
     0.391     7.641     0.150
     0.403    14.910     0.150
     0.549    10.883     0.150
     0.549    18.441     0.150
     0.569    10.332     0.150
     0.569    10.672     0.150
     0.644    23.453     0.150
     0.614    11.043     0.150
     0.623    11.410     0.150
     0.623    20.973     0.150
     0.713    10.891     0.150
     0.701    12.812     0.150
     0.735    29.211     0.150
     0.735    30.273     0.150
     0.764    22.660     0.150
     5.786    13.902     0.150
     5.786    25.422     0.150
     0.765    13.441     0.150
     0.765    24.191     0.150
     1.011    18.094     0.150
     1.299    21.422     0.150
     1.438    24.652     0.150
     1.484    27.711     0.150
     1.628    27.262     0.150
     1.758    29.852     0.150
     1.871    30.754     0.150
     1.932    34.012     0.150
     1.997    36.184     0.150
     2.296    40.754     0.150
     2.552    40.820     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.103     1.959     0.150
     0.103     5.919     0.150
     0.073     2.060     0.150
     0.340     7.039     0.150
     0.425     8.119     0.150
     0.469     8.379     0.150
     0.605    10.789     0.150
     0.614    11.010     0.150
     0.720    13.329     0.150
     0.720    24.689     0.150
     0.720    22.819     0.150
     0.760    13.060     0.150
     0.760    24.260     0.150
     0.733    13.949     0.150
     0.733    14.270     0.150
     0.733    24.550     0.150
     1.186    21.579     0.150
     1.186    37.129     0.150
     1.286    21.579     0.150
     1.286    41.129     0.150
     1.286    23.270     0.150
     1.290    24.249     0.150
     1.290    42.760     0.150
     1.345    24.020     0.150
     1.345    42.760     0.150
     1.347    23.489     0.150
     1.347    44.680     0.150
     1.582    25.359     0.150
     3.179    60.459     0.150
     3.275    52.390     0.150
     3.275    62.090     0.150
     3.793    73.249     0.150
     3.793   120.499     0.150
     4.217    81.159     0.150
     5.244    78.659     0.150
     5.385    99.669     0.150
     6.612    98.850     0.150
     6.612   124.449     0.150
     6.713    97.760     0.150
     6.713   127.629     0.150
     7.088   103.979     0.150
     7.167   104.390     0.150
     7.167   134.199     0.150
     7.445   108.459     0.150
     7.445   240.270     0.150
     7.475   108.699     0.150
     7.475   238.289     0.150
     7.642   114.680     0.150
     7.642   144.489     0.150
     7.738   114.459     0.150
     7.738   144.060     0.150
     7.774   114.084     0.150
     7.774   113.760     0.150
     7.774   113.909     0.150
     8.030   118.979     0.150
     8.030   153.959     0.150
     8.041   153.319     0.150
     8.160   122.499     0.150
     8.183   121.760     0.150
     8.343   122.060     0.150
     8.343   159.659     0.150
     8.343   265.859     0.150
     8.419   120.699     0.150
     8.419   272.239     0.150
     8.561   124.669     0.150
     8.637   128.959     0.150
     8.759   128.590     0.150
     9.187   136.659     0.150
     9.247   134.709     0.150
     9.231   133.510     0.150
     9.336   137.933     0.150
     9.336   138.569     0.150
     9.552   140.319     0.150
     9.585   140.359     0.150
     9.627   139.390     0.150
     9.667   140.159     0.150
     9.637   139.590     0.150
    10.312   152.959     0.150
    10.381   152.060     0.150
    10.421   149.859     0.150
    10.751   156.959     0.150
    10.874   160.079     0.150
    11.058   163.863     0.150
    11.305   166.129     0.150
    11.305   164.359     0.150
    11.497   167.949     0.150
    11.595   168.069     0.150
    11.595   166.060     0.150
    11.642   170.930     0.150
    11.793   171.919     0.150
    11.885   172.229     0.150
    11.888   172.329     0.150
    11.984   174.300     0.150
    12.043   174.939     0.150
    12.215   176.899     0.150
    12.535   184.109     0.150
    12.550   183.319     0.150
    12.566   183.930     0.150
    12.715   184.149     0.150
    12.741   186.159     0.150
    12.781   184.579     0.150
    12.830   188.989     0.150
    13.490   194.959     0.150
    13.947   197.459     0.150
    14.069   202.619     0.150
    14.161   205.159     0.150
    14.369   207.699     0.150
    14.461   208.229     0.150
    14.548   209.989     0.150
    14.593   209.189     0.150
    14.649   213.159     0.150
    14.770   211.899     0.150
    15.216   218.800     0.150
    15.924   226.185     0.150
    15.924   225.659     0.150
    16.170   227.720     0.150
    16.117   230.359     0.150
    16.549   233.399     0.150
    16.688   236.020     0.150
    16.809   235.359     0.150
    17.380   244.949     0.150
    17.477   244.779     0.150
    17.868   252.789     0.150
    18.223   253.159     0.150
    18.504   256.659     0.150
    19.242   265.220     0.150
    19.426   272.359     0.150
    19.979   276.459     0.150
    20.400   277.060     0.150
    20.639   281.970     0.150
    20.871   282.560     0.150
    21.029   282.959     0.150
    21.275   286.959     0.150
    21.427   286.209     0.150
    21.663   291.560     0.150
    21.722   292.129     0.150
    21.778   292.659     0.150
    22.123   297.300     0.150
    22.655   303.010     0.150
    22.750   302.659     0.150
    22.951   305.260     0.150
    23.193   308.149     0.150
    23.770   312.060     0.150
    24.237   317.060     0.150
    24.219   316.760     0.150
    24.295   317.959     0.150
    24.500   320.010     0.150
    26.411   339.060     0.150
    26.389   338.329     0.150
    27.059   343.069     0.150
    27.909   351.685     0.150
    27.909   351.959     0.150
    28.401   354.459     0.150
    28.599   356.879     0.150
    28.648   357.390     0.150
    28.913   359.659     0.150
    29.359   362.390     0.150
    29.413   363.560     0.150
    29.441   365.039     0.150
    29.993   369.260     0.150
    30.127   370.254     0.150
    30.127   551.654     0.150
    30.195   371.329     0.150
    30.579   373.409     0.150
    30.579   552.334     0.150
    30.967   377.550     0.150
    32.502   391.739     0.150
    33.764   402.209     0.150
    33.948   403.470     0.150
    33.948   562.840     0.150
    34.296   406.930     0.150
    34.494   409.039     0.150
    34.540   410.899     0.150
    35.086   415.419     0.150
    35.568   417.824     0.150
    35.849   421.109     0.150
    35.849   422.279     0.150
    36.476   427.560     0.150
    37.480   435.209     0.150
    37.480   571.734     0.150
    37.480   434.659     0.150
    37.480   572.859     0.150
    37.779   438.060     0.150
    37.779   573.159     0.150
    38.150   441.859     0.150
    38.150   575.359     0.150
    38.219   445.859     0.150
    38.801   445.749     0.150
    39.893   455.659     0.150
    40.574   459.310     0.150
    40.574   459.499     0.150
    43.559   484.060     0.150
    43.559   592.060     0.150
    45.671   501.760     0.150
    46.259   506.558     0.150
    46.259   506.159     0.150
    46.453   509.510     0.150
    46.769   509.999     0.150
    46.793   509.079     0.150
    47.006   510.939     0.150
    47.020   514.272     0.150
    47.126   515.100     0.150
    47.352   516.539     0.150
    47.408   515.694     0.150
    47.408   515.340     0.150
    47.619   517.539     0.150
    49.810   534.039     0.150
    50.762   541.520     0.150
    50.762   541.659     0.150
    52.705   557.784     0.150
    53.457   560.359     0.150
    55.499   575.949     0.150
    56.045   581.859     0.150
    56.045   580.669     0.150
    60.246   608.359     0.150
    66.159   648.909     0.150
    66.159   648.260     0.150
    67.129   652.060     0.150
    67.129   798.359     0.150
    67.129  1183.959     0.150
    67.129   654.760     0.150
    70.377   676.140     0.150
    72.473   687.859     0.150
    72.473   688.479     0.150
    74.427   698.385     0.150
    74.427   698.409     0.150
    74.454   700.359     0.150
    77.244   715.359     0.150
    77.244   714.385     0.150
    77.272   715.140     0.150
    77.593   720.760     0.150
    77.648   717.260     0.150
    79.284   722.560     0.150
    79.284  1338.859     0.150
    79.304   725.560     0.150
    79.615   727.260     0.150
    79.734   728.060     0.150
    80.073   731.459     0.150
    80.332   732.234     0.150
    80.332   731.459     0.150
    80.469   733.159     0.150
    80.505   732.159     0.150
    80.544   732.359     0.150
    80.796   733.459     0.150
    80.910   737.260     0.150
    81.094   734.859     0.150
    81.199   738.159     0.150
    81.374   736.760     0.150
    81.493   739.859     0.150
    81.522   737.959     0.150
    81.732   742.069     0.150
    81.997   739.760     0.150
    82.044   739.659     0.150
    82.158   742.189     0.150
    82.262   741.560     0.150
    82.274   743.529     0.150
    82.307   741.260     0.150
    82.416   745.359     0.150
    82.474   744.689     0.150
    82.693   745.659     0.150
    82.982   745.635     0.150
    82.983   745.659     0.150
    82.983   746.359     0.150
    82.983  1374.359     0.150
    82.983   745.359     0.150
    82.983  1375.359     0.150
    83.190   746.959     0.150
    83.318   746.159     0.150
    83.318   936.859     0.150
    83.318  1367.760     0.150
    83.492   747.359     0.150
    83.591   750.359     0.150
    83.646   748.459     0.150
    83.651   748.260     0.150
    83.652   748.359     0.150
    83.692   751.060     0.150
    83.692   748.760     0.150
    83.659   750.459     0.150
    83.753   748.459     0.150
    83.766   749.060     0.150
    84.099   752.859     0.150
    84.100   750.060     0.150
    84.163   752.372     0.150
    84.166   751.159     0.150
    84.307   751.260     0.150
    84.427   752.459     0.150
    84.439   754.159     0.150
    84.444   754.560     0.150
    84.465   754.359     0.150
    84.592   753.159     0.150
    84.628   755.760     0.150
    84.672   755.760     0.150
    84.734   755.760     0.150
    84.803   754.260     0.150
    84.833   755.459     0.150
    84.914   756.660     0.150
    85.066   757.160     0.150
    85.066   955.359     0.150
    85.066  1395.359     0.150
    85.114   755.760     0.150
    85.260   756.760     0.150
    85.315   756.660     0.150
    85.367   758.559     0.150
    85.431   757.459     0.150
    85.710   760.660     0.150
    85.736   758.859     0.150
    85.785   761.090     0.150
    85.831   759.260     0.150
    85.866   761.299     0.150
    86.103   762.160     0.150
    86.342   762.160     0.150
    86.365   762.260     0.150
    86.637   763.859     0.150
    86.942   766.160     0.150
    87.211   766.422     0.150
    87.657   768.260     0.150
    87.743   768.660     0.150
    87.855   768.859     0.150
    88.454   773.660     0.150
    89.558   779.260     0.150
    89.588   780.559     0.150
    89.588   780.859     0.150
    89.588  1431.260     0.150
    89.588  1793.859     0.150
    89.588   779.559     0.150
    90.213   782.359     0.150
    90.452   784.359     0.150
    90.525   784.260     0.150
    90.813   786.059     0.150
    91.072   785.459     0.150
    91.382   787.559     0.150
    91.382  1004.959     0.150
    91.382  1419.559     0.150
    91.525   786.984     0.150
    91.558   789.760     0.150
    91.558   786.410     0.150
    91.834   790.059     0.150
    93.631   795.959     0.150
    94.146   799.459     0.150
    94.308   802.266     0.150
    94.613   800.359     0.150
    94.780   803.660     0.150
    94.943   803.260     0.150
    95.270  1037.660     0.150
    96.020   808.619     0.150
    96.357   809.959     0.150
    97.306   813.660     0.150
    97.306  1497.660     0.150
    98.025   817.260     0.150
    98.025  1059.660     0.150
    98.025  1500.359     0.150
    98.025  1511.359     0.150
    99.611   824.184     0.150
   101.315   834.160     0.150
   101.315  1086.160     0.150
   101.402   832.859     0.150
   102.663   835.459     0.150
   102.663  1090.359     0.150
   102.663  1472.660     0.150
   102.663  1535.359     0.150
   102.663  1965.359     0.150
   112.289  1113.359     0.150
   112.289  2098.660     0.150
   117.266  1125.918     0.150
   119.250  1129.660     0.150
   119.832  1129.834     0.150
   122.223  1135.359     0.150
   125.307  1140.859     0.150
   125.307  1143.160     0.150
   125.804  1142.760     0.150
   125.804  1144.459     0.150
   126.070  1142.160     0.150
   126.070  1144.559     0.150
   127.429  1140.859     0.150
   127.429  1142.660     0.150
   127.429  1147.459     0.150
   127.429  1149.660     0.150
   135.894  1162.209     0.150
   140.644  1349.559     0.150
   142.710  1171.359     0.150
   144.726  1175.959     0.150
   144.726  1175.447     0.150
   145.041  1177.359     0.150
     0.467     8.426     0.150
     0.609    10.906     0.150
     0.713    13.156     0.150
     0.713    23.527     0.150
     0.716    13.227     0.150
     0.716    24.195     0.150
     0.777    13.207     0.150
     0.777    23.977     0.150
     0.750    13.676     0.150
     0.776    13.547     0.150
     1.173    21.207     0.150
     1.173    37.727     0.150
     1.271    22.578     0.150
     1.271    40.715     0.150
     1.275    23.496     0.150
     1.275    42.297     0.150
     1.278    22.695     0.150
     1.328    23.496     0.150
     1.328    22.695     0.150
     1.333    23.488     0.150
     1.333    42.375     0.150
     1.380    24.496     0.150
     1.584    24.848     0.150
     3.288    49.309     0.150
     3.288    62.746     0.150
     3.805    55.215     0.150
     4.220    79.406     0.150
     4.340    64.426     0.150
     4.634    68.277     0.150
     5.654   100.125     0.150
     7.754   114.746     0.150
     7.789   111.938     0.150
     7.789   244.562     0.150
     7.789   112.309     0.150
     7.945   115.309     0.150
     8.430   121.258     0.150
    10.768   155.727     0.150
    11.192   165.148     0.150
    11.321   167.137     0.150
    11.321   364.113     0.150
    11.512   168.418     0.150
    13.137   189.465     0.150
    14.606   214.605     0.150
    15.935   226.688     0.150
    15.935   227.477     0.150
    30.139   369.531     0.150
    37.786   437.738     0.150
    83.320   741.688     0.150
    95.273   800.688     0.150
    95.273   805.688     0.150
    95.273  1032.387     0.150
    95.273  1434.387     0.150
    95.273  1472.688     0.150
    95.273  1863.387     0.150
    98.025   815.188     0.150
   101.324   828.688     0.150
   101.324  1080.887     0.150
     0.403     7.701     0.150
     0.501     9.080     0.150
     0.517     9.820     0.150
     0.570    10.590     0.150
     0.630    11.490     0.150
     0.649    11.600     0.150
     0.740    12.779     0.150
     0.765    15.010     0.150
     0.765    25.930     0.150
     0.758    13.971     0.150
     0.758    24.561     0.150
     0.793    14.381     0.150
     0.806    14.041     0.150
     1.225    22.311     0.150
     1.225    38.910     0.150
     1.324    23.760     0.150
     1.324    42.090     0.150
     1.327    24.961     0.150
     1.330    24.150     0.150
     1.354    24.010     0.150
     1.354    44.621     0.150
     1.379    24.961     0.150
     1.379    24.150     0.150
     1.379    44.121     0.150
     1.432    25.590     0.150
     1.432    45.480     0.150
     3.754    56.650     0.150
     3.754   119.189     0.150
     4.349    65.391     0.150
     4.630    70.439     0.150
     5.273    79.830     0.150
     5.372    81.189     0.150
     5.582    82.451     0.150
     5.907   114.160     0.150
     6.596    99.180     0.150
     7.050   104.121     0.150
     7.129   104.801     0.150
     7.327   108.311     0.150
     7.407   108.000     0.150
     7.437   108.561     0.150
     7.624   111.779     0.150
     7.737   112.541     0.150
     7.737   112.859     0.150
     7.717   113.490     0.150
     7.820   115.971     0.150
     8.145   119.150     0.150
     8.379   120.451     0.150
     8.379   215.500     0.150
     8.342   122.631     0.150
     8.342   159.961     0.150
     8.342   265.461     0.150
     8.621   126.311     0.150
    10.723   154.020     0.150
    11.780   169.600     0.150
    11.875   172.041     0.150
    13.116   190.240     0.150
    14.625   208.311     0.150
    15.925   227.791     0.150
    15.925   224.951     0.150
    16.514   234.770     0.150
    16.684   233.109     0.150
    16.770   238.980     0.150
    20.867   282.350     0.150
    37.792   437.189     0.150
    83.342   744.541     0.150
    86.127   766.240     0.150
     0.477     8.645     0.150
     0.625    11.133     0.150
     0.755    14.395     0.150
     0.755    25.105     0.150
     0.734    13.465     0.150
     0.734    23.906     0.150
     0.734    24.543     0.150
     0.734    24.984     0.150
     0.740    12.574     0.150
     0.740    22.215     0.150
     1.205    21.234     0.150
     1.205    38.184     0.150
     1.308    23.293     0.150
     1.308    41.375     0.150
     1.312    24.504     0.150
     1.315    23.465     0.150
     1.362    23.625     0.150
     1.362    43.355     0.150
     1.367    24.504     0.150
     1.367    23.465     0.150
     1.367    43.562     0.150
     1.418    25.164     0.150
     1.418    44.934     0.150
     1.584    24.812     0.150
     3.174    48.254     0.150
     3.775    55.293     0.150
     3.775   115.062     0.150
     4.330    64.594     0.150
     4.615    69.145     0.150
     5.577    82.965     0.150
     5.646    86.094     0.150
     6.472   101.184     0.150
     6.593    96.812     0.150
     7.066   104.324     0.150
     7.023   125.074     0.150
     7.146   103.953     0.150
     7.335   108.676     0.150
     7.335   231.484     0.150
     7.424   108.285     0.150
     7.454   108.016     0.150
     7.622   113.195     0.150
     7.718   113.875     0.150
     7.718   244.176     0.150
     7.752   113.660     0.150
     7.752   113.863     0.150
     7.824   115.586     0.150
     8.141   122.414     0.150
     8.401   120.793     0.150
     8.619   128.414     0.150
     9.212   133.703     0.150
     9.229   136.344     0.150
     9.607   139.484     0.150
    10.730   156.945     0.150
    11.286   164.895     0.150
    11.286   360.738     0.150
    11.480   167.094     0.150
    11.573   164.594     0.150
    11.578   167.953     0.150
    11.775   171.523     0.150
    11.870   172.555     0.150
    11.967   174.266     0.150
    12.197   178.016     0.150
    12.550   183.895     0.150
    13.108   191.055     0.150
    13.325   191.906     0.150
    13.474   193.145     0.150
    14.052   203.266     0.150
    14.447   204.543     0.150
    14.533   212.484     0.150
    14.578   209.023     0.150
    14.628   211.285     0.150
    15.912   227.359     0.150
    15.912   505.133     0.150
    15.912   227.125     0.150
    16.527   234.906     0.150
    16.674   236.285     0.150
    16.792   236.695     0.150
    17.374   246.625     0.150
    18.202   253.105     0.150
    19.221   264.984     0.150
    20.378   277.406     0.150
    20.858   281.793     0.150
    21.007   284.203     0.150
    22.729   302.645     0.150
    22.930   305.293     0.150
    23.749   312.633     0.150
    27.902   352.883     0.150
    27.902   352.656     0.150
    30.114   371.531     0.150
    35.080   415.215     0.150
    36.472   425.836     0.150
    37.471   434.633     0.150
    37.773   438.336     0.150
    74.411   697.758     0.150
    81.356   736.984     0.150
    83.320   746.535     0.150
    86.105   762.734     0.150
    91.506   786.758     0.150
   102.661   833.234     0.150
   102.661  1088.535     0.150
   112.290  1114.035     0.150
     0.052     1.672     0.150
     0.052     3.113     0.150
     0.086     2.250     0.150
     0.086     3.918     0.150
     0.111     2.059     0.150
     0.212     3.387     0.150
     0.274     5.168     0.150
     0.316     5.957     0.150
     0.333     5.789     0.150
     0.333    10.285     0.150
     0.378     6.652     0.150
     0.378    11.453     0.150
     0.527     9.477     0.150
     0.639    11.949     0.150
     0.639    20.758     0.150
     0.681    12.820     0.150
     0.681    22.008     0.150
     0.759    13.988     0.150
     0.759    24.668     0.150
     0.798    14.289     0.150
     0.914    16.012     0.150
     0.914    27.648     0.150
     0.954    17.527     0.150
     0.954    30.367     0.150
     0.987    17.047     0.150
     0.987    29.500     0.150
     0.987    17.148     0.150
     0.987    30.234     0.150
     0.973    17.660     0.150
     0.973    31.238     0.150
     1.090    18.398     0.150
     1.090    18.574     0.150
     1.090    32.652     0.150
     1.102    20.188     0.150
     1.102    35.027     0.150
     1.126    20.387     0.150
     1.126    30.527     0.150
     1.126    35.660     0.150
     1.327    22.676     0.150
     1.327    40.434     0.150
     1.651    26.707     0.150
     1.661    26.820     0.150
     1.735    28.824     0.150
     2.054    32.500     0.150
     2.114    34.262     0.150
     2.114    60.641     0.150
     2.125    34.508     0.150
     2.125    61.211     0.150
     2.145    61.988     0.150
     2.153    33.883     0.150
     2.173    34.082     0.150
     2.267    35.676     0.150
     2.324    36.559     0.150
     2.470    38.836     0.150
     2.654    41.375     0.150
     2.686    41.418     0.150
     2.686    48.359     0.150
     2.686    41.594     0.150
     2.691    41.199     0.150
     2.726    42.508     0.150
     2.746    42.270     0.150
     2.787    42.906     0.150
     2.838    43.543     0.150
     2.897    79.812     0.150
     2.977    46.309     0.150
     2.977    45.941     0.150
     2.977    82.094     0.150
     3.005    46.562     0.150
     3.101    47.441     0.150
     3.180    48.621     0.150
     3.192    48.723     0.150
     3.213    48.742     0.150
     3.220    49.324     0.150
     3.525    53.805     0.150
     3.525    94.840     0.150
     3.570    54.020     0.150
     3.588    53.957     0.150
     3.588    54.293     0.150
     3.653    55.184     0.150
     3.666    54.805     0.150
     3.805    57.238     0.150
     3.805    68.609     0.150
     3.827    56.797     0.150
     3.830    58.410     0.150
     3.940    60.160     0.150
     4.008    61.258     0.150
     4.436    66.809     0.150
     4.462    64.867     0.150
     4.549    67.598     0.150
     4.679    69.984     0.150
     4.797    71.918     0.150
     4.797    72.219     0.150
     4.941    73.840     0.150
     5.095    76.059     0.150
     5.109    76.531     0.150
     5.120    76.430     0.150
     5.259    78.539     0.150
     5.330    79.438     0.150
     5.350    80.027     0.150
     5.431    80.797     0.150
     5.463    80.359     0.150
     5.520    82.039     0.150
     5.520   102.477     0.150
     5.544    82.660     0.150
     5.596    83.789     0.150
     5.606    83.875     0.150
     5.665    86.648     0.150
     5.855    85.633     0.150
     6.027    89.457     0.150
     6.407    93.707     0.150
     6.613   100.008     0.150
     7.631   111.539     0.150
     7.666   113.207     0.150
     7.727   112.117     0.150
     7.821   115.488     0.150
     7.964   116.387     0.150
     8.009   116.398     0.150
     8.030   116.469     0.150
     8.293   120.219     0.150
     9.092   130.527     0.150
     9.092   232.000     0.150
     9.595   139.207     0.150
     9.799   143.418     0.150
     9.994   144.238     0.150
    12.378   180.758     0.150
    14.372   206.699     0.150
    15.584   219.070     0.150
    22.720   301.879     0.150
    82.661   741.000     0.150
    92.994   792.398     0.150
    94.653   801.500     0.150
    94.653  1032.297     0.150
    94.653  1470.500     0.150
   100.837   829.898     0.150
     0.153     2.773     0.150
     0.203     2.992     0.150
     0.203     5.578     0.150
     0.179     3.438     0.150
     0.179     6.570     0.150
     0.207     3.773     0.150
     0.216     4.156     0.150
     0.216     7.984     0.150
     0.250     4.555     0.150
     0.396     6.906     0.150
     0.396    12.586     0.150
     0.674    12.445     0.150
     0.674    21.883     0.150
     0.762    13.906     0.150
     0.762    24.609     0.150
     0.912    15.984     0.150
     0.912    28.219     0.150
     0.912    15.805     0.150
     0.912    27.812     0.150
     0.867    15.703     0.150
     0.867    27.578     0.150
     0.957    16.836     0.150
     0.957    29.914     0.150
     0.964    16.867     0.150
     0.964    29.477     0.150
     0.990    17.070     0.150
     0.990    30.680     0.150
     0.990    16.844     0.150
     0.990    30.086     0.150
     1.013    18.234     0.150
     1.013    32.109     0.150
     1.086    19.625     0.150
     1.086    34.469     0.150
     1.201    20.156     0.150
     1.201    36.906     0.150
     1.234    22.258     0.150
     1.234    39.383     0.150
     1.306    22.977     0.150
     1.306    40.195     0.150
     1.257    22.664     0.150
     1.257    40.070     0.150
     1.257    35.234     0.150
     1.537    47.352     0.150
     1.532    26.539     0.150
     1.532    47.906     0.150
     1.665    28.273     0.150
     1.665    50.602     0.150
     1.798    32.188     0.150
     1.999    31.961     0.150
     2.017    32.477     0.150
     2.143    35.094     0.150
     2.143    62.133     0.150
     2.180    63.305     0.150
     2.254    39.555     0.150
     2.254    69.945     0.150
     2.525    40.078     0.150
     2.594    41.656     0.150
     2.594    46.844     0.150
     2.594    72.547     0.150
     2.594    81.016     0.150
     2.874    45.625     0.150
     3.024    84.266     0.150
     3.064    47.953     0.150
     3.059    47.211     0.150
     3.151    48.398     0.150
     3.396    52.336     0.150
     3.534    54.023     0.150
     3.534    63.898     0.150
     3.534    98.016     0.150
     3.534   108.328     0.150
     3.537    54.133     0.150
     3.723    56.883     0.150
     3.723    71.086     0.150
     3.723   117.133     0.150
     3.759    57.625     0.150
     3.759   116.094     0.150
     4.401    65.336     0.150
     4.674    71.328     0.150
     4.674    87.359     0.150
     4.674   126.094     0.150
     4.674   149.320     0.150
     5.020    91.984     0.150
     5.934    86.922     0.150
     5.934   103.672     0.150
     5.934   181.906     0.150
     6.350    96.398     0.150
     6.350   119.719     0.150
     6.350   195.359     0.150
     6.482    98.086     0.150
     6.482   205.633     0.150
     9.721   143.016     0.150
    11.095   158.750     0.150
    11.164   163.125     0.150
     0.055     1.680     0.150
     0.055     1.367     0.150
     0.080     2.250     0.150
     0.080     4.023     0.150
     0.100     1.992     0.150
     0.219     3.617     0.150
     0.271     5.273     0.150
     0.265     5.047     0.150
     0.314     5.977     0.150
     0.336     5.742     0.150
     0.390     6.797     0.150
     0.535     9.570     0.150
     0.535    16.586     0.150
     0.535    16.844     0.150
     0.640    11.867     0.150
     0.640    20.656     0.150
     0.671    11.625     0.150
     0.671    22.141     0.150
     0.749    13.703     0.150
     0.749    24.023     0.150
     0.793    14.094     0.150
     0.950    17.422     0.150
     0.950    30.320     0.150
     0.999    17.500     0.150
     0.999    30.031     0.150
     0.999    17.195     0.150
     0.999    30.672     0.150
     1.093    18.336     0.150
     1.086    18.484     0.150
     1.086    18.344     0.150
     1.098    20.055     0.150
     1.098    34.883     0.150
     1.121    20.383     0.150
     1.121    30.750     0.150
     1.121    32.672     0.150
     1.121    35.555     0.150
     1.323    21.867     0.150
     1.656    27.156     0.150
     1.662    26.648     0.150
     1.747    28.945     0.150
     1.697    30.250     0.150
     1.697    53.922     0.150
     2.066    33.344     0.150
     2.124    34.141     0.150
     2.128    33.430     0.150
     2.134    33.508     0.150
     2.156    37.430     0.150
     2.163    34.102     0.150
     2.163    39.180     0.150
     2.172    34.016     0.150
     2.289    39.734     0.150
     2.336    36.023     0.150
     2.336    42.227     0.150
     2.482    43.000     0.150
     2.518    43.695     0.150
     2.656    40.961     0.150
     2.697    41.625     0.150
     2.697    41.484     0.150
     2.687    41.008     0.150
     2.738    41.727     0.150
     2.738    48.031     0.150
     2.756    42.336     0.150
     2.835    43.352     0.150
     2.835    53.805     0.150
     2.960    50.672     0.150
     2.986    46.406     0.150
     2.986    82.023     0.150
     3.008    46.078     0.150
     3.179    60.211     0.150
     3.213    48.727     0.150
     3.213    54.438     0.150
     3.354    50.102     0.150
     3.527    53.641     0.150
     3.582    54.070     0.150
     3.582    60.383     0.150
     3.582    64.820     0.150
     3.600    54.633     0.150
     3.600    54.336     0.150
     3.651    55.422     0.150
     3.659    54.844     0.150
     3.743    56.820     0.150
     3.743    68.016     0.150
     3.824    58.016     0.150
     4.008    76.203     0.150
     4.004    59.516     0.150
     4.104    61.453     0.150
     4.213    63.367     0.150
     4.267    64.594     0.150
     4.267    63.891     0.150
     4.416    66.305     0.150
     4.454    65.203     0.150
     4.472    66.609     0.150
     4.604    68.836     0.150
     4.604    86.375     0.150
     4.692    70.133     0.150
     4.675    70.422     0.150
     4.796    72.586     0.150
     4.977    75.289     0.150
     5.004    75.094     0.150
     5.107    90.852     0.150
     5.121    94.188     0.150
     5.131    76.445     0.150
     5.118    74.789     0.150
     5.209    77.633     0.150
     5.256    78.430     0.150
     5.256    96.500     0.150
     5.273    78.500     0.150
     5.335    79.734     0.150
     5.335   140.133     0.150
     6.031    87.672     0.150
     6.419    93.164     0.150
     6.419   169.422     0.150
     7.627   110.711     0.150
     7.627   197.281     0.150
     7.678   110.867     0.150
     7.678   145.273     0.150
     7.678   197.102     0.150
     7.678   243.430     0.150
     7.666   114.320     0.150
     7.666   198.914     0.150
     7.825   113.430     0.150
     7.825   202.805     0.150
     8.004   116.680     0.150
     8.004   208.344     0.150
     8.004   259.953     0.150
     8.288   120.383     0.150
     8.288   121.375     0.150
     9.084   130.664     0.150
     9.084   233.617     0.150
    11.124   161.195     0.150
    11.300   166.422     0.150
    11.300   361.000     0.150
    15.594   221.625     0.150
     0.034     1.703     0.150
     0.070     2.203     0.150
     0.143     4.082     0.150
     0.400     7.453     0.150
     0.422     8.441     0.150
     0.441     8.572     0.150
     0.466     9.113     0.150
     0.528     9.842     0.150
     0.551     9.941     0.150
     0.565    10.373     0.150
     0.625    10.967     0.150
     0.625    19.662     0.150
     0.641    11.158     0.150
     0.641    20.014     0.150
     0.657    11.652     0.150
     0.696    12.506     0.150
     0.696    22.172     0.150
     0.696    12.762     0.150
     0.703    12.533     0.150
     0.711    12.572     0.150
     0.746    14.402     0.150
     0.725    12.156     0.150
     0.725    22.074     0.150
     0.725    12.562     0.150
     0.725    12.373     0.150
     0.725    22.312     0.150
     0.909    15.932     0.150
     1.002    17.252     0.150
     1.033    17.703     0.150
     1.033    31.555     0.150
     1.151    35.502     0.150
     1.170    19.953     0.150
     1.206    19.875     0.150
     1.206    35.441     0.150
     1.284    23.092     0.150
     1.348    24.293     0.150
     1.348    23.092     0.150
     1.343    21.807     0.150
     1.392    24.783     0.150
     1.392    43.682     0.150
     1.408    24.512     0.150
     1.408    42.662     0.150
     1.505    24.303     0.150
     1.505    23.881     0.150
     1.505    42.684     0.150
     1.505    23.752     0.150
     1.505    41.883     0.150
     1.573    25.824     0.150
     1.648    26.000     0.150
     1.707    26.947     0.150
     1.844    28.609     0.150
     1.952    30.420     0.150
     2.091    32.502     0.150
     2.178    33.055     0.150
     2.178    37.969     0.150
     2.189    33.840     0.150
     2.189    64.961     0.150
     2.252    34.828     0.150
     2.345    35.822     0.150
     2.382    36.270     0.150
     2.438    37.674     0.150
     2.438    64.969     0.150
     2.470    38.020     0.150
     2.520    38.342     0.150
     2.617    39.811     0.150
     2.625    41.232     0.150
     2.625    51.002     0.150
     2.652    40.801     0.150
     2.652    73.311     0.150
     2.776    41.895     0.150
     2.776    83.424     0.150
     2.775    41.654     0.150
     2.784    42.076     0.150
     2.800    42.123     0.150
     2.800    84.193     0.150
     2.796    41.832     0.150
     2.855    43.109     0.150
     2.855    85.258     0.150
     2.866    43.213     0.150
     2.899    47.352     0.150
     2.899    87.672     0.150
     2.896    43.939     0.150
     2.913    43.938     0.150
     2.913    87.287     0.150
     2.954    47.533     0.150
     3.051    45.545     0.150
     3.102    93.195     0.150
     3.276    49.771     0.150
     3.297    98.971     0.150
     3.289    49.715     0.150
     3.298    48.844     0.150
     3.321    50.574     0.150
     3.321    87.855     0.150
     3.380    50.689     0.150
     3.387    50.172     0.150
     3.518    52.586     0.150
     3.531    52.803     0.150
     3.551    52.582     0.150
     3.551    93.762     0.150
     3.573   106.096     0.150
     3.573    56.812     0.150
     3.567    52.836     0.150
     3.632    53.492     0.150
     3.632    55.072     0.150
     3.666    54.494     0.150
     3.719    56.379     0.150
     3.785    56.893     0.150
     3.834    56.383     0.150
     3.834    70.803     0.150
     3.866    56.791     0.150
     3.875    56.572     0.150
     3.936    57.752     0.150
     3.952    58.285     0.150
     3.962    59.457     0.150
     3.962   104.301     0.150
     4.022    59.668     0.150
     4.046    59.852     0.150
     4.046    60.703     0.150
     4.108    61.301     0.150
     4.107    61.828     0.150
     4.140    60.383     0.150
     4.140    61.342     0.150
     4.140   128.691     0.150
     4.160    61.330     0.150
     4.180    63.395     0.150
     4.180   108.498     0.150
     4.205    60.934     0.150
     4.250    64.195     0.150
     4.292    64.008     0.150
     4.332    64.879     0.150
     4.479    66.588     0.150
     4.479    68.162     0.150
     4.479    85.271     0.150
     4.479   143.553     0.150
     4.490    65.217     0.150
     4.490    65.328     0.150
     4.517    65.705     0.150
     4.605    68.912     0.150
     4.636    67.527     0.150
     4.642    69.068     0.150
     4.702    69.889     0.150
     4.779    71.133     0.150
     4.829    70.127     0.150
     4.937    72.998     0.150
     4.951    73.598     0.150
     5.034    73.836     0.150
     5.054    75.961     0.150
     5.081    73.883     0.150
     5.082    73.559     0.150
     5.155    76.775     0.150
     5.157    75.482     0.150
     5.159    76.543     0.150
     5.240    76.107     0.150
     5.254    77.824     0.150
     5.296    78.254     0.150
     5.352    79.525     0.150
     5.502    79.441     0.150
     5.523    81.742     0.150
     5.559    82.232     0.150
     5.580    82.594     0.150
     5.602    83.164     0.150
     5.644    84.582     0.150
     5.746    85.453     0.150
     5.820    86.035     0.150
     5.824    86.602     0.150
     5.824   112.283     0.150
     5.860    87.770     0.150
     5.880    86.355     0.150
     5.889    86.086     0.150
     5.892    86.531     0.150
     5.951    87.865     0.150
     5.991    89.848     0.150
     6.077    90.166     0.150
     6.127    90.449     0.150
     6.134    89.900     0.150
     6.268    91.979     0.150
     6.310    93.324     0.150
     6.358    94.062     0.150
     6.386    93.764     0.150
     6.421    94.295     0.150
     6.444    94.578     0.150
     6.444   120.430     0.150
     6.469    95.600     0.150
     6.548    96.689     0.150
     6.566    97.602     0.150
     6.566   125.082     0.150
     6.574    96.455     0.150
     6.586    96.545     0.150
     6.607    96.412     0.150
     6.607    97.252     0.150
     6.639    97.102     0.150
     6.729    98.627     0.150
     6.740    96.330     0.150
     6.777    99.812     0.150
     6.805   101.377     0.150
     6.913   101.582     0.150
     6.933   102.119     0.150
     6.945   100.672     0.150
     6.955   100.475     0.150
     7.015   102.682     0.150
     7.021   101.121     0.150
     7.039   103.016     0.150
     7.067   103.572     0.150
     7.096   103.908     0.150
     7.214   105.854     0.150
     7.233   105.975     0.150
     7.238   105.980     0.150
     7.278   107.053     0.150
     7.314   108.299     0.150
     7.343   108.578     0.150
     7.343   230.533     0.150
     7.352   106.828     0.150
     7.390   108.873     0.150
     7.494   109.043     0.150
     7.503   110.029     0.150
     7.503   188.701     0.150
     7.517   111.049     0.150
     7.599   112.203     0.150
     7.599   140.963     0.150
     7.640   112.539     0.150
     7.669   111.123     0.150
     7.699   113.002     0.150
     7.699   112.502     0.150
     7.699   145.021     0.150
     7.699   242.982     0.150
     7.727   109.730     0.150
     7.731   112.539     0.150
     7.739   112.586     0.150
     7.788   113.752     0.150
     7.788   113.383     0.150
     7.814   113.090     0.150
     7.820   114.742     0.150
     7.850   114.939     0.150
     7.857   114.752     0.150
     7.883   115.736     0.150
     7.904   116.562     0.150
     7.904   146.963     0.150
     7.904   247.553     0.150
     7.906   116.332     0.150
     7.926   116.254     0.150
     7.931   117.953     0.150
     7.931   148.363     0.150
     7.986   117.029     0.150
     7.986   117.352     0.150
     7.986   150.793     0.150
     8.053   118.607     0.150
     8.111   157.963     0.150
     8.111   259.113     0.150
     8.112   120.543     0.150
     8.142   119.467     0.150
     8.151   119.359     0.150
     8.213   120.449     0.150
     8.252   120.873     0.150
     8.277   120.322     0.150
     8.277   155.613     0.150
     8.283   119.775     0.150
     8.387   120.471     0.150
     8.435   120.545     0.150
     8.448   124.010     0.150
     8.515   125.211     0.150
     8.555   123.818     0.150
     8.562   125.689     0.150
     8.570   121.387     0.150
     8.578   126.053     0.150
     8.578   163.143     0.150
     8.590   127.502     0.150
     8.590   161.002     0.150
     8.590   275.072     0.150
     8.616   126.098     0.150
     8.639   124.211     0.150
     8.708   128.582     0.150
     8.715   128.541     0.150
     8.815   129.312     0.150
     8.809   127.924     0.150
     8.939   129.127     0.150
     8.955   131.771     0.150
     8.971   126.750     0.150
     8.975   131.955     0.150
     8.993   131.229     0.150
     9.041   129.641     0.150
     9.058   132.221     0.150
     9.106   131.910     0.150
     9.116   132.705     0.150
     9.132   134.502     0.150
     9.132   174.373     0.150
     9.170   132.322     0.150
     9.204   134.852     0.150
     9.282   135.416     0.150
     9.283   134.467     0.150
     9.308   136.215     0.150
     9.360   136.986     0.150
     9.414   135.713     0.150
     9.414   138.363     0.150
     9.414   302.463     0.150
     9.414   138.852     0.150
     9.414   238.902     0.150
     9.438   137.705     0.150
     9.504   138.223     0.150
     9.528   138.902     0.150
     9.528   181.543     0.150
     9.555   138.898     0.150
     9.616   139.613     0.150
     9.616   181.152     0.150
     9.653   137.793     0.150
     9.680   139.590     0.150
     9.681   139.412     0.150
     9.704   140.988     0.150
     9.707   139.734     0.150
     9.732   141.820     0.150
     9.739   141.697     0.150
     9.757   141.627     0.150
     9.816   142.545     0.150
     9.891   143.732     0.150
     9.977   145.502     0.150
     9.998   140.547     0.150
    10.015   146.383     0.150
    10.027   143.303     0.150
    10.033   145.068     0.150
    10.073   147.457     0.150
    10.099   146.283     0.150
    10.172   146.996     0.150
    10.217   147.900     0.150
    10.227   147.225     0.150
    10.236   149.223     0.150
    10.257   149.441     0.150
    10.287   150.002     0.150
    10.308   152.102     0.150
    10.318   150.117     0.150
    10.347   150.559     0.150
    10.382   151.334     0.150
    10.387   151.008     0.150
    10.407   151.857     0.150
    10.451   151.904     0.150
    10.476   150.203     0.150
    10.564   154.488     0.150
    10.667   155.588     0.150
    10.686   155.584     0.150
    10.732   156.842     0.150
    10.732   201.062     0.150
    10.733   155.152     0.150
    10.773   157.438     0.150
    10.782   156.074     0.150
    10.853   158.498     0.150
    10.953   160.127     0.150
    10.954   160.316     0.150
    10.965   159.363     0.150
    10.981   161.781     0.150
    10.981   348.332     0.150
    10.981   160.922     0.150
    10.992   159.844     0.150
    11.018   161.117     0.150
    11.034   161.008     0.150
    11.046   160.760     0.150
    11.115   161.510     0.150
    11.115   162.312     0.150
    11.115   208.941     0.150
    11.167   164.289     0.150
    11.163   161.936     0.150
    11.169   163.191     0.150
    11.191   163.770     0.150
    11.259   164.480     0.150
    11.259   163.912     0.150
    11.259   164.053     0.150
    11.259   359.387     0.150
    11.326   165.752     0.150
    11.323   165.283     0.150
    11.328   165.193     0.150
    11.349   161.465     0.150
    11.407   163.846     0.150
    11.437   166.074     0.150
    11.446   166.863     0.150
    11.454   166.572     0.150
    11.480   161.287     0.150
    11.549   162.727     0.150
    11.551   166.514     0.150
    11.589   169.162     0.150
    11.615   166.303     0.150
    11.660   169.811     0.150
    11.675   170.094     0.150
    11.722   171.752     0.150
    11.741   171.531     0.150
    11.742   170.393     0.150
    11.794   171.420     0.150
    11.807   173.172     0.150
    11.934   174.412     0.150
    12.033   168.766     0.150
    12.038   174.512     0.150
    12.067   176.357     0.150
    12.085   176.496     0.150
    12.099   177.385     0.150
    12.123   177.297     0.150
    12.171   171.938     0.150
    12.246   176.154     0.150
    12.325   179.455     0.150
    12.332   172.730     0.150
    12.479   182.572     0.150
    12.481   183.092     0.150
    12.506   183.402     0.150
    12.567   175.836     0.150
    12.638   181.941     0.150
    12.651   184.820     0.150
    12.767   185.283     0.150
    12.854   187.281     0.150
    12.873   188.363     0.150
    12.884   187.660     0.150
    12.899   186.619     0.150
    12.950   188.049     0.150
    13.046   189.537     0.150
    13.064   190.232     0.150
    13.129   190.684     0.150
    13.235   192.557     0.150
    13.332   193.830     0.150
    13.337   194.049     0.150
    13.341   192.492     0.150
    13.387   191.803     0.150
    13.417   195.184     0.150
    13.427   193.994     0.150
    13.433   192.203     0.150
    13.433   194.873     0.150
    13.496   193.223     0.150
    13.496   194.082     0.150
    13.547   195.479     0.150
    13.584   195.266     0.150
    13.593   196.926     0.150
    13.595   197.400     0.150
    13.599   195.934     0.150
    13.603   194.033     0.150
    13.629   197.742     0.150
    13.760   199.682     0.150
    13.890   201.414     0.150
    13.897   201.318     0.150
    13.903   200.469     0.150
    13.908   201.475     0.150
    13.952   202.076     0.150
    13.970   197.402     0.150
    13.999   201.969     0.150
    14.017   202.145     0.150
    14.083   203.709     0.150
    14.105   203.021     0.150
    14.112   203.363     0.150
    14.212   205.318     0.150
    14.280   206.223     0.150
    14.296   205.982     0.150
    14.314   206.275     0.150
    14.338   206.461     0.150
    14.398   206.691     0.150
    14.405   207.555     0.150
    14.490   207.363     0.150
    14.514   208.840     0.150
    14.599   209.668     0.150
    14.616   207.502     0.150
    14.639   209.840     0.150
    14.662   209.889     0.150
    14.677   210.127     0.150
    14.693   210.668     0.150
    14.730   211.588     0.150
    14.728   211.008     0.150
    14.762   212.482     0.150
    14.771   211.223     0.150
    14.846   212.381     0.150
    14.843   212.188     0.150
    14.880   210.092     0.150
    14.990   215.342     0.150
    15.102   215.994     0.150
    15.123   216.902     0.150
    15.145   216.021     0.150
    15.148   216.902     0.150
    15.221   217.473     0.150
    15.241   216.832     0.150
    15.318   218.680     0.150
    15.316   218.121     0.150
    15.346   218.824     0.150
    15.388   219.303     0.150
    15.425   220.549     0.150
    15.435   219.908     0.150
    15.443   220.039     0.150
    15.496   220.471     0.150
    15.554   221.123     0.150
    15.570   220.977     0.150
    15.576   221.410     0.150
    15.643   222.557     0.150
    15.720   223.816     0.150
    15.803   222.963     0.150
    15.834   223.293     0.150
    15.855   225.203     0.150
    15.861   223.912     0.150
    15.897   225.945     0.150
    15.918   225.898     0.150
    15.978   226.863     0.150
    15.980   226.564     0.150
    16.097   228.109     0.150
    16.116   226.061     0.150
    16.116   228.873     0.150
    16.141   231.893     0.150
    16.178   228.127     0.150
    16.175   228.381     0.150
    16.187   227.240     0.150
    16.284   228.473     0.150
    16.399   230.867     0.150
    16.468   229.715     0.150
    16.466   231.594     0.150
    16.503   232.072     0.150
    16.509   231.629     0.150
    16.553   232.992     0.150
    16.565   234.117     0.150
    16.599   234.615     0.150
    16.607   231.469     0.150
    16.623   233.162     0.150
    16.624   235.482     0.150
    16.689   234.607     0.150
    16.715   231.246     0.150
    16.715   235.195     0.150
    16.752   234.127     0.150
    16.778   234.609     0.150
    16.838   235.451     0.150
    16.854   237.303     0.150
    16.957   236.316     0.150
    17.012   240.141     0.150
    17.262   244.045     0.150
    17.295   242.229     0.150
    17.304   245.191     0.150
    17.514   244.672     0.150
    18.067   251.604     0.150
    18.067   251.453     0.150
    18.248   253.303     0.150
    19.266   267.182     0.150
    19.368   266.203     0.150
    19.368   481.441     0.150
    19.931   272.922     0.150
    20.411   277.303     0.150
    20.808   281.303     0.150
    20.945   284.822     0.150
    21.041   284.303     0.150
    21.285   287.402     0.150
    21.356   289.602     0.150
    21.444   288.941     0.150
    21.471   286.812     0.150
    21.588   290.002     0.150
    21.811   291.977     0.150
    21.959   294.312     0.150
    22.142   296.912     0.150
    22.342   298.102     0.150
    22.368   298.713     0.150
    22.773   302.762     0.150
    22.886   302.902     0.150
    22.954   304.592     0.150
    22.971   305.002     0.150
    23.206   308.453     0.150
    23.748   311.582     0.150
    23.798   313.672     0.150
    23.974   315.328     0.150
    23.974   752.402     0.150
    24.027   316.812     0.150
    24.187   316.002     0.150
    24.229   317.303     0.150
    24.287   317.572     0.150
    24.308   317.602     0.150
    24.523   319.342     0.150
    25.667   329.932     0.150
    26.268   336.578     0.150
    26.268   827.977     0.150
    26.430   337.453     0.150
    26.696   339.203     0.150
    26.806   340.203     0.150
    26.876   340.602     0.150
    27.066   342.643     0.150
    27.834   351.652     0.150
    28.929   359.303     0.150
    29.422   363.613     0.150
    29.468   364.803     0.150
    29.947   368.713     0.150
    30.061   369.498     0.150
    30.974   377.373     0.150
    31.454   383.842     0.150
    35.011   414.322     0.150
    35.637   417.902     0.150
    35.637   418.008     0.150
    35.637   417.143     0.150
    36.046   423.162     0.150
    36.398   426.502     0.150
    37.674   436.703     0.150
    38.074   439.102     0.150
    38.254   440.502     0.150
    38.327   441.893     0.150
    38.724   445.502     0.150
    40.371   459.422     0.150
    40.552   458.578     0.150
    43.499   483.303     0.150
    43.499   482.777     0.150
    45.638   501.043     0.150
    46.815   510.623     0.150
    47.086   513.189     0.150
    47.262   515.473     0.150
    47.468   515.102     0.150
    52.779   557.477     0.150
    53.397   559.602     0.150
    55.451   576.453     0.150
    55.968   580.102     0.150
    55.968   637.303     0.150
    55.968   579.973     0.150
    62.658   626.102     0.150
    63.075   628.602     0.150
    67.054   653.203     0.150
    67.054   652.902     0.150
    70.452   676.633     0.150
    72.396   687.102     0.150
    74.378   698.102     0.150
    74.372   697.252     0.150
    77.199   714.727     0.150
    77.450   714.703     0.150
    77.626   719.002     0.150
    77.712   717.877     0.150
    77.906   718.803     0.150
    77.906     5.000     0.150
    77.906   725.803     0.150
    77.906   728.303     0.150
    77.906   893.703     0.150
    77.906  1312.703     0.150
    77.906  1337.402     0.150
    77.906  1614.602     0.150
    78.700   723.109     0.150
    79.207   722.402     0.150
    80.405   732.328     0.150
    81.017   733.902     0.150
    81.966   741.703     0.150
    82.294   743.102     0.150
    83.241   741.502     0.150
    83.241   935.902     0.150
    83.241  1688.902     0.150
    83.465   750.002     0.150
    83.623   749.602     0.150
    83.630   750.803     0.150
    83.664   750.203     0.150
    83.737   748.828     0.150
    84.144   753.002     0.150
    84.146   750.877     0.150
    84.396   753.703     0.150
    84.560   755.602     0.150
    84.567   754.203     0.150
    84.772   755.402     0.150
    84.777   755.102     0.150
    84.977   756.002     0.150
    85.029   758.402     0.150
    85.029  1398.402     0.150
    85.117   758.002     0.150
    85.407   759.602     0.150
    85.458   761.602     0.150
    85.458   761.602     0.150
    85.747   761.203     0.150
    86.026  1387.502     0.150
    86.313   764.303     0.150
    86.336   763.703     0.150
    87.175   767.990     0.150
    89.505   778.602     0.150
    89.511   779.602     0.150
    89.511   779.303     0.150
    89.511   778.883     0.150
    90.375   784.203     0.150
    90.736   784.402     0.150
    91.478   785.678     0.150
    91.608   788.203     0.150
    91.757   789.521     0.150
    92.207   791.477     0.150
    93.554  1452.502     0.150
    94.739   802.139     0.150
    95.192   802.102     0.150
    95.192  1033.502     0.150
    95.192  1435.102     0.150
    95.192  1472.002     0.150
    96.285   810.018     0.150
    96.388   810.018     0.150
    97.949   812.602     0.150
    99.538   823.078     0.150
   101.240   833.203     0.150
   101.240   838.402     0.150
   101.240  1470.402     0.150
   101.240  1528.402     0.150
   101.350   831.902     0.150
   102.585   833.402     0.150
   106.931   857.402     0.150
   106.931  1126.303     0.150
   106.931  2029.402     0.150
   109.075   863.203     0.150
   109.075  1106.602     0.150
   109.075  1595.102     0.150
   109.075  2053.602     0.150
   112.212  1114.902     0.150
   112.212  1118.402     0.150
   112.212  2097.402     0.150
   119.223  1129.402     0.150
   122.289  1134.787     0.150
   125.384  1140.303     0.150
   126.147  1142.602     0.150
   144.793  1175.715     0.150
   145.953  1179.877     0.150
     0.024     1.531     0.150
     0.024     3.750     0.150
     0.075     1.734     0.150
     0.075     5.031     0.150
     0.136     3.945     0.150
     0.406     7.516     0.150
     0.433     8.516     0.150
     0.450     8.438     0.150
     0.455     9.031     0.150
     0.455    17.141     0.150
     0.537     9.922     0.150
     0.556    10.047     0.150
     0.625    11.047     0.150
     0.625    19.625     0.150
     0.650    11.219     0.150
     0.650    20.422     0.150
     0.658    11.453     0.150
     0.701    12.875     0.150
     0.701    22.375     0.150
     0.711    12.625     0.150
     0.733    12.555     0.150
     0.733    22.242     0.150
     0.733    12.211     0.150
     0.740    14.227     0.150
     0.991    17.352     0.150
     0.991    32.203     0.150
     1.039    17.938     0.150
     1.039    32.039     0.150
     1.151    20.688     0.150
     1.151    37.094     0.150
     1.173    20.211     0.150
     1.217    19.906     0.150
     1.344    21.891     0.150
     1.344    39.664     0.150
     1.343    24.203     0.150
     1.343    23.367     0.150
     1.388    24.703     0.150
     1.398    25.000     0.150
     1.398    46.125     0.150
     1.514    24.047     0.150
     1.514    42.820     0.150
     1.514    23.805     0.150
     1.577    25.711     0.150
     1.577    48.438     0.150
     1.659    26.055     0.150
     1.718    26.969     0.150
     1.850    29.180     0.150
     1.850    56.188     0.150
     1.960    30.625     0.150
     1.960    59.953     0.150
     2.100    32.430     0.150
     2.100    57.500     0.150
     2.174    33.070     0.150
     2.174    60.664     0.150
     2.192    33.867     0.150
     2.192    66.586     0.150
     2.261    35.195     0.150
     2.356    35.977     0.150
     2.391    36.664     0.150
     2.444    37.477     0.150
     2.444    74.086     0.150
     2.478    38.266     0.150
     2.478    74.922     0.150
     2.531    38.625     0.150
     2.617    39.461     0.150
     2.660    40.609     0.150
     2.785    42.117     0.150
     2.785    83.656     0.150
     2.780    42.016     0.150
     2.780    84.094     0.150
     2.780    42.266     0.150
     2.780    84.484     0.150
     2.805    42.891     0.150
     2.807    42.898     0.150
     2.807    85.898     0.150
     2.861    43.547     0.150
     2.876    43.273     0.150
     2.905    43.867     0.150
     2.906    44.844     0.150
     2.917    43.578     0.150
     3.051    45.453     0.150
     3.109    46.086     0.150
     3.112    46.656     0.150
     3.112    47.523     0.150
     3.281    49.781     0.150
     3.296    48.797     0.150
     3.300    49.367     0.150
     3.306    50.180     0.150
     3.329    50.172     0.150
     3.389    50.234     0.150
     3.390    50.805     0.150
     3.521    52.211     0.150
     3.541    52.609     0.150
     3.557    53.062     0.150
     3.576    53.383     0.150
     3.580    54.516     0.150
     3.580    55.102     0.150
     3.636    55.109     0.150
     3.674    54.836     0.150
     3.726    56.102     0.150
     3.789    56.555     0.150
     3.833    56.242     0.150
     3.865    56.727     0.150
     3.872    57.148     0.150
     3.941    58.945     0.150
     3.954    58.148     0.150
     3.970    58.883     0.150
     4.032    59.828     0.150
     4.033    60.141     0.150
     4.057    60.945     0.150
     4.057    60.789     0.150
     4.113    61.602     0.150
     4.118    61.680     0.150
     4.149    61.703     0.150
     4.149    61.188     0.150
     4.161    61.867     0.150
     4.217    62.953     0.150
     4.258    63.883     0.150
     4.303    64.328     0.150
     4.341    65.047     0.150
     4.485    67.055     0.150
     4.485    67.383     0.150
     4.487    65.469     0.150
     4.491    66.938     0.150
     4.516    66.281     0.150
     4.614    68.836     0.150
     4.632    67.555     0.150
     4.647    69.359     0.150
     4.712    70.312     0.150
     4.789    71.555     0.150
     4.849    72.562     0.150
     4.940    72.953     0.150
     4.961    73.641     0.150
     5.061    76.320     0.150
     5.073    77.188     0.150
     5.081    73.938     0.150
     5.158    76.156     0.150
     5.164    77.016     0.150
     5.169    76.781     0.150
     5.237    76.195     0.150
     5.264    77.992     0.150
     5.298    78.641     0.150
     5.356    80.062     0.150
     5.499    82.102     0.150
     5.510    82.273     0.150
     5.528    82.867     0.150
     5.590    83.055     0.150
     5.606    83.422     0.150
     5.644    82.070     0.150
     5.651    84.344     0.150
     5.755    85.531     0.150
     5.830    86.383     0.150
     5.867    87.328     0.150
     5.890    87.094     0.150
     5.899    86.836     0.150
     5.902    87.086     0.150
     5.962    89.570     0.150
     5.997    89.766     0.150
     6.085    90.578     0.150
     6.136    90.273     0.150
     6.139    91.031     0.150
     6.271    92.484     0.150
     6.366    94.938     0.150
     6.397    94.273     0.150
     6.431    95.500     0.150
     6.455   208.281     0.150
     6.476    96.500     0.150
     6.584    97.273     0.150
     6.596    97.758     0.150
     6.602    96.625     0.150
     6.602   169.281     0.150
     6.615    98.086     0.150
     6.739    99.391     0.150
     6.782   100.617     0.150
     6.813   101.133     0.150
     6.916   102.219     0.150
     7.021   102.180     0.150
     7.025   103.055     0.150
     7.078   103.836     0.150
     7.106   105.000     0.150
     7.189   104.688     0.150
     7.214   106.062     0.150
     7.225   106.266     0.150
     7.235   106.383     0.150
     7.287   108.203     0.150
     7.321   108.320     0.150
     7.348   108.750     0.150
     7.348   109.031     0.150
     7.362   108.172     0.150
     7.397   108.945     0.150
     7.496   109.477     0.150
     7.505   110.664     0.150
     7.577   111.625     0.150
     7.647   113.094     0.150
     7.680   112.508     0.150
     7.708   112.859     0.150
     7.708   113.695     0.150
     7.740   114.148     0.150
     7.790   114.016     0.150
     7.790   113.914     0.150
     7.824   114.336     0.150
     7.866   115.094     0.150
     7.911   117.516     0.150
     7.934   116.570     0.150
     7.996   118.844     0.150
     7.996   117.625     0.150
     8.059   118.664     0.150
     8.150   119.266     0.150
     8.152   119.016     0.150
     8.224   120.281     0.150
     8.261   120.969     0.150
     8.288   120.641     0.150
     8.288   120.547     0.150
     8.398   122.289     0.150
     8.445   123.445     0.150
     8.458   124.383     0.150
     8.565   125.828     0.150
     8.571   126.445     0.150
     8.587   130.883     0.150
     8.599   128.844     0.150
     8.646   126.047     0.150
     8.716   130.477     0.150
     8.817   128.945     0.150
     8.949   131.414     0.150
     8.961   131.023     0.150
     8.981   131.867     0.150
     8.984   132.133     0.150
     9.001   131.523     0.150
     9.052   133.422     0.150
     9.064   132.477     0.150
     9.117   133.062     0.150
     9.142   136.102     0.150
     9.180   133.969     0.150
     9.213   134.664     0.150
     9.268   134.422     0.150
     9.291   136.148     0.150
     9.318   136.422     0.150
     9.366   137.164     0.150
     9.448   138.422     0.150
     9.511   138.648     0.150
     9.538   141.742     0.150
     9.563   139.305     0.150
     9.663   140.555     0.150
     9.690   140.766     0.150
     9.691   141.961     0.150
     9.715   142.445     0.150
     9.717   142.000     0.150
     9.766   143.016     0.150
     9.826   143.773     0.150
    10.021   147.141     0.150
    10.021   252.664     0.150
    10.026   147.086     0.150
    10.043   146.953     0.150
    10.083   148.023     0.150
    10.107   146.695     0.150
    10.182   148.922     0.150
    10.228   149.297     0.150
    10.237   149.664     0.150
    10.267   150.234     0.150
    10.328   151.750     0.150
    10.356   151.430     0.150
    10.395   151.367     0.150
    10.393   152.039     0.150
    10.418   152.531     0.150
    10.461   152.781     0.150
    10.472   150.047     0.150
    10.472   329.992     0.150
    10.575   155.281     0.150
    10.675   156.281     0.150
    10.696   156.867     0.150
    10.739   156.742     0.150
    10.783   157.852     0.150
    10.792   158.320     0.150
    10.832   158.875     0.150
    10.863   158.773     0.150
    10.956   160.695     0.150
    10.961   160.805     0.150
    10.964   160.672     0.150
    10.975   161.117     0.150
    10.990   350.586     0.150
    11.001   159.828     0.150
    11.057   161.438     0.150
    11.126   162.883     0.150
    11.126   164.305     0.150
    11.173   163.281     0.150
    11.177   164.328     0.150
    11.180   164.383     0.150
    11.201   163.578     0.150
    11.268   164.148     0.150
    11.268   165.344     0.150
    11.268   164.297     0.150
    11.336   165.805     0.150
    11.336   166.289     0.150
    11.360   166.398     0.150
    11.415   166.242     0.150
    11.447   167.961     0.150
    11.455   167.742     0.150
    11.490   167.359     0.150
    11.494   168.805     0.150
    11.533   167.492     0.150
    11.552   169.406     0.150
    11.562   169.211     0.150
    11.598   169.805     0.150
    11.617   168.055     0.150
    11.670   171.391     0.150
    11.733   171.500     0.150
    11.751   171.414     0.150
    11.804   171.898     0.150
    11.817   174.773     0.150
    11.845   170.938     0.150
    12.047   174.766     0.150
    12.078   175.844     0.150
    12.095   176.602     0.150
    12.110   176.273     0.150
    12.133   177.180     0.150
    12.181   177.484     0.150
    12.256   178.883     0.150
    12.335   179.773     0.150
    12.343   179.625     0.150
    12.496   181.867     0.150
    12.647   183.352     0.150
    12.661   184.625     0.150
    12.735   185.656     0.150
    12.764   187.367     0.150
    12.777   187.195     0.150
    12.864   187.391     0.150
    12.884   187.523     0.150
    12.894   187.266     0.150
    12.910   188.328     0.150
    12.961   188.062     0.150
    13.056   189.984     0.150
    13.074   191.094     0.150
    13.139   191.469     0.150
    13.246   192.766     0.150
    13.342   193.719     0.150
    13.347   193.977     0.150
    13.351   193.680     0.150
    13.385   192.344     0.150
    13.428   193.977     0.150
    13.437   194.461     0.150
    13.443   194.664     0.150
    13.505   195.102     0.150
    13.505   194.914     0.150
    13.544   196.852     0.150
    13.557   195.805     0.150
    13.604   196.766     0.150
    13.606   196.773     0.150
    13.609   196.375     0.150
    13.626   197.688     0.150
    13.770   196.984     0.150
    13.900   201.320     0.150
    13.907   201.023     0.150
    13.914   200.469     0.150
    13.917   200.609     0.150
    13.962   200.969     0.150
    13.971   198.742     0.150
    14.010   202.141     0.150
    14.027   202.367     0.150
    14.094   202.625     0.150
    14.115   203.117     0.150
    14.122   203.305     0.150
    14.166   207.547     0.150
    14.222   205.125     0.150
    14.306   207.125     0.150
    14.318   207.227     0.150
    14.324   206.516     0.150
    14.349   206.727     0.150
    14.408   207.703     0.150
    14.415   207.695     0.150
    14.500   211.312     0.150
    14.524   208.711     0.150
    14.541   209.391     0.150
    14.547   210.258     0.150
    14.560   210.445     0.150
    14.610   209.508     0.150
    14.624   211.641     0.150
    14.627   214.172     0.150
    14.650   210.273     0.150
    14.673   210.148     0.150
    14.688   210.625     0.150
    14.703   211.008     0.150
    14.738   211.750     0.150
    14.741   211.805     0.150
    14.781   211.625     0.150
    14.835   213.234     0.150
    14.848   213.312     0.150
    14.853   212.781     0.150
    14.857   212.656     0.150
    14.871   216.406     0.150
    14.898   213.180     0.150
    15.084   214.922     0.150
    15.112   215.789     0.150
    15.134   217.242     0.150
    15.155   216.742     0.150
    15.158   216.523     0.150
    15.231   217.250     0.150
    15.251   217.438     0.150
    15.308   218.250     0.150
    15.326   218.203     0.150
    15.328   218.516     0.150
    15.398   219.547     0.150
    15.436   221.992     0.150
    15.445   219.344     0.150
    15.454   219.766     0.150
    15.506   221.367     0.150
    15.580   221.695     0.150
    15.587   221.516     0.150
    15.654   222.828     0.150
    15.730   222.680     0.150
    15.798   225.922     0.150
    15.798   397.977     0.150
    15.865   225.945     0.150
    15.907   225.445     0.150
    15.990   226.266     0.150
    15.989   225.805     0.150
    16.108   228.461     0.150
    16.125   228.781     0.150
    16.125   229.266     0.150
    16.151   232.312     0.150
    16.185   228.828     0.150
    16.188   228.820     0.150
    16.295   234.531     0.150
    16.409   232.008     0.150
    16.475   233.023     0.150
    16.478   233.328     0.150
    16.519   233.781     0.150
    16.576   234.703     0.150
    16.610   234.406     0.150
    16.618   234.117     0.150
    16.633   234.828     0.150
    16.634   236.102     0.150
    16.662   240.922     0.150
    16.700   236.133     0.150
    16.725   236.352     0.150
    16.762   237.297     0.150
    16.848   238.625     0.150
    16.852   237.844     0.150
    16.967   239.742     0.150
    17.004   240.445     0.150
    17.022   239.883     0.150
    17.189   242.250     0.150
    17.306   243.930     0.150
    17.315   246.445     0.150
    17.513   250.766     0.150
    17.741   250.320     0.150
    17.741   444.000     0.150
    18.076   252.047     0.150
    18.076   252.164     0.150
    18.249   254.445     0.150
    19.936   275.188     0.150
    20.043   277.352     0.150
    20.414   279.242     0.150
    20.818   281.641     0.150
    20.945   285.047     0.150
    21.044   285.945     0.150
    21.288   286.641     0.150
    21.595   290.305     0.150
    22.346   298.344     0.150
    22.894   303.141     0.150
    22.956   305.852     0.150
    22.972   304.641     0.150
    23.755   314.734     0.150
    23.799   316.047     0.150
    24.027   318.062     0.150
    24.197   316.242     0.150
    24.232   316.641     0.150
    24.292   317.422     0.150
    26.269   336.445     0.150
    27.069   342.914     0.150
    27.845   352.547     0.150
    30.072   369.797     0.150
    31.448   386.367     0.150
    35.021   415.281     0.150
    36.056   424.273     0.150
    36.408   426.047     0.150
    37.684   435.344     0.150
    37.976   438.812     0.150
    38.264   440.250     0.150
    38.959   448.953     0.150
    40.381   460.688     0.150
    45.728   500.750     0.150
    46.514   508.477     0.150
    47.080   515.055     0.150
    47.189   513.617     0.150
    47.255   514.727     0.150
    47.367   515.062     0.150
    50.730   543.547     0.150
    52.771   557.172     0.150
    55.461   576.031     0.150
    55.978   580.047     0.150
    55.978   577.922     0.150
    58.355  1078.141     0.150
    59.570  1092.344     0.150
    63.083   630.492     0.150
    67.064   652.344     0.150
    67.064   655.711     0.150
    72.406   688.742     0.150
    72.406   687.414     0.150
    77.208   714.742     0.150
    80.397   731.992     0.150
    81.027   736.742     0.150
    82.917   748.289     0.150
    83.250   743.344     0.150
    83.250  1362.445     0.150
    83.250  1377.141     0.150
    83.472   750.641     0.150
    83.637   750.344     0.150
    83.671   750.445     0.150
    84.404   754.047     0.150
    84.780   755.547     0.150
    84.787   754.445     0.150
    84.939   760.641     0.150
    85.466   763.844     0.150
    85.466   763.844     0.150
    86.035   760.344     0.150
    87.183   767.617     0.150
    89.521   778.742     0.150
    89.521   777.414     0.150
    90.746   783.047     0.150
    91.487   786.070     0.150
    91.767   792.477     0.150
    92.218   793.797     0.150
    93.563   794.344     0.150
    93.563  1462.945     0.150
    95.202   802.047     0.150
    95.202  1033.141     0.150
    95.202  1435.141     0.150
    97.635   810.945     0.150
    97.957   815.445     0.150
    99.223   819.242     0.150
   101.251   832.641     0.150
   101.251   837.344     0.150
   101.251  1470.344     0.150
   101.251  1529.344     0.150
   102.595   833.945     0.150
   102.595   838.844     0.150
   102.595   841.047     0.150
   102.595  1089.547     0.150
   106.940   857.844     0.150
   106.940  1126.344     0.150
   106.940  1575.945     0.150
   109.084   864.141     0.150
   109.084  1107.547     0.150
   109.084  1139.141     0.150
   112.221  1113.547     0.150
   112.221  1161.547     0.150
   119.222  1131.539     0.150
   145.078  1177.844     0.150
   145.951  1181.469     0.150
     0.046     2.047     0.150
     0.046     4.281     0.150
     0.385     7.086     0.150
     0.412     8.141     0.150
     0.439     8.305     0.150
     0.475     9.195     0.150
     0.475    16.852     0.150
     0.514     9.477     0.150
     0.536     9.578     0.150
     0.637    11.141     0.150
     0.627    10.836     0.150
     0.627    19.766     0.150
     0.669    11.602     0.150
     0.682    12.430     0.150
     0.688    12.148     0.150
     0.726    12.398     0.150
     0.726    22.055     0.150
     0.742    14.039     0.150
     0.742    25.078     0.150
     1.012    19.117     0.150
     1.012    33.078     0.150
     1.018    17.375     0.150
     1.139    20.656     0.150
     1.139    35.969     0.150
     1.156    19.719     0.150
     1.156    36.109     0.150
     1.197    19.531     0.150
     1.197    34.102     0.150
     1.354    21.812     0.150
     1.354    40.734     0.150
     1.342    23.789     0.150
     1.342    23.172     0.150
     1.342    42.945     0.150
     1.384    24.375     0.150
     1.384    43.727     0.150
     1.491    23.625     0.150
     1.491    42.016     0.150
     1.491    23.758     0.150
     1.558    25.297     0.150
     1.558    47.664     0.150
     1.701    26.883     0.150
     1.701    52.227     0.150
     1.847    28.648     0.150
     1.937    30.156     0.150
     1.937    59.523     0.150
     2.090    63.297     0.150
     2.192    33.234     0.150
     2.336    35.336     0.150
     2.469    74.633     0.150
     2.629    39.570     0.150
     2.619    51.781     0.150
     2.619    84.250     0.150
     2.761    41.633     0.150
     2.884    48.508     0.150
     2.884    81.055     0.150
     2.884    90.695     0.150
     2.920    43.844     0.150
     2.939    44.641     0.150
     2.939    56.055     0.150
     2.939    82.672     0.150
     3.064    45.852     0.150
     3.090    60.141     0.150
     3.312    49.234     0.150
     3.526    52.242     0.150
     3.558    55.570     0.150
     3.558    67.711     0.150
     3.558   114.602     0.150
     3.618    55.828     0.150
     3.618    70.211     0.150
     3.618    99.398     0.150
     3.618   117.945     0.150
     3.879    56.938     0.150
     3.889    57.164     0.150
     4.126    79.352     0.150
     4.126   110.789     0.150
     4.126   129.695     0.150
     4.482    68.078     0.150
     4.482    84.695     0.150
     4.482   119.891     0.150
     4.482   144.242     0.150
     4.503    65.945     0.150
     4.650    67.828     0.150
     5.094    74.320     0.150
     5.164    75.031     0.150
     5.254    76.492     0.150
     5.658    82.133     0.150
     5.813    84.227     0.150
     5.813   112.125     0.150
     5.813   187.461     0.150
     6.432   110.320     0.150
     6.932   100.625     0.150
     6.932   131.828     0.150
     6.932   181.031     0.150
     6.932   222.242     0.150
     7.347   108.258     0.150
     7.347   138.172     0.150
     7.797   114.297     0.150
    10.491   150.500     0.150
     0.036     1.746     0.150
     0.088     2.476     0.150
     0.152     4.506     0.150
     0.425     7.966     0.150
     0.454     8.226     0.150
     0.462     9.236     0.150
     0.538     9.496     0.150
     0.642    10.896     0.150
     0.642    20.128     0.150
     0.636    10.962     0.150
     0.636    20.189     0.150
     0.675    11.576     0.150
     0.683    12.239     0.150
     0.683    21.976     0.150
     0.694    12.156     0.150
     0.740    12.449     0.150
     0.740    22.424     0.150
     0.740    13.126     0.150
     0.729    14.256     0.150
     0.729    24.276     0.150
     0.999    17.586     0.150
     0.999    31.856     0.150
     1.021    17.401     0.150
     1.021    31.845     0.150
     1.134    20.836     0.150
     1.134    36.696     0.150
     1.155    20.716     0.150
     1.155    36.056     0.150
     1.211    19.754     0.150
     1.361    22.001     0.150
     1.361    40.220     0.150
     1.331    24.155     0.150
     1.331    23.136     0.150
     1.331    41.456     0.150
     1.374    24.575     0.150
     1.400    43.495     0.150
     1.400    47.356     0.150
     1.500    23.601     0.150
     1.500    24.086     0.150
     1.559    25.657     0.150
     1.559    47.933     0.150
     1.649    26.097     0.150
     1.715    26.679     0.150
     1.715    52.829     0.150
     1.860    28.991     0.150
     1.860    56.505     0.150
     1.943    30.540     0.150
     1.943    59.882     0.150
     2.105    32.571     0.150
     2.105    63.415     0.150
     2.207    33.810     0.150
     2.207    61.755     0.150
     2.193    33.386     0.150
     2.248    35.251     0.150
     2.248    69.183     0.150
     2.350    36.083     0.150
     2.392    36.991     0.150
     2.455    37.511     0.150
     2.455    74.077     0.150
     2.484    38.077     0.150
     2.521    38.354     0.150
     2.633    42.007     0.150
     2.634    39.800     0.150
     2.644    40.649     0.150
     2.644    81.188     0.150
     2.762    42.013     0.150
     2.762    83.819     0.150
     2.761    42.183     0.150
     2.801    42.192     0.150
     2.789    84.329     0.150
     2.871    43.839     0.150
     2.875    44.044     0.150
     2.909    43.944     0.150
     2.890    45.735     0.150
     2.890    89.706     0.150
     2.931    43.976     0.150
     2.944    48.206     0.150
     2.944    90.485     0.150
     3.024    45.702     0.150
     3.068    46.144     0.150
     3.102    46.659     0.150
     3.102    48.347     0.150
     3.298    49.290     0.150
     3.291    49.487     0.150
     3.314    49.263     0.150
     3.336    49.978     0.150
     3.386    50.911     0.150
     3.405    50.552     0.150
     3.536    52.726     0.150
     3.533    52.989     0.150
     3.578    53.808     0.150
     3.564    55.165     0.150
     3.618    54.144     0.150
     3.618    55.575     0.150
     3.618   113.946     0.150
     3.680    55.288     0.150
     3.735    57.333     0.150
     3.803    57.589     0.150
     3.851    57.126     0.150
     3.851   124.985     0.150
     3.891    57.450     0.150
     3.923    60.321     0.150
     3.969    60.698     0.150
     3.970    58.376     0.150
     3.954    59.011     0.150
     4.031    59.714     0.150
     4.022    59.522     0.150
     4.053    61.245     0.150
     4.049    60.382     0.150
     4.124    61.343     0.150
     4.135    61.358     0.150
     4.177    62.884     0.150
     4.231    63.755     0.150
     4.265    65.155     0.150
     4.301    64.999     0.150
     4.344    65.819     0.150
     4.495    67.966     0.150
     4.495   143.696     0.150
     4.508    66.388     0.150
     4.506    66.259     0.150
     4.534    66.942     0.150
     4.556    66.825     0.150
     4.599    68.302     0.150
     4.659    70.921     0.150
     4.651    68.382     0.150
     4.712    69.911     0.150
     4.786    71.009     0.150
     4.839    72.409     0.150
     4.955    73.731     0.150
     4.964    74.202     0.150
     5.028    75.388     0.150
     5.099    74.372     0.150
     5.167    77.733     0.150
     5.167    75.226     0.150
     5.175    75.261     0.150
     5.265    77.653     0.150
     5.256    76.677     0.150
     5.314    78.888     0.150
     5.344    80.296     0.150
     5.344   169.017     0.150
     5.369    80.294     0.150
     5.491    82.177     0.150
     5.516    82.827     0.150
     5.540    83.122     0.150
     5.570    87.636     0.150
     5.592    83.415     0.150
     5.620    83.620     0.150
     5.662    82.626     0.150
     5.826    87.325     0.150
     5.895    86.497     0.150
     5.954    86.593     0.150
     6.008    89.979     0.150
     6.091    91.155     0.150
     6.152    91.897     0.150
     6.286    93.046     0.150
     6.373    94.694     0.150
     6.392    94.763     0.150
     6.425    95.323     0.150
     6.444    94.575     0.150
     6.485    96.175     0.150
     6.578    99.825     0.150
     6.583    97.501     0.150
     6.594    97.917     0.150
     6.620    98.243     0.150
     6.631    96.526     0.150
     6.742   100.081     0.150
     6.941   101.325     0.150
     7.038   103.214     0.150
     7.053   104.005     0.150
     7.076   104.183     0.150
     7.123   104.776     0.150
     7.205   105.556     0.150
     7.231   106.331     0.150
     7.359   109.466     0.150
     7.363   107.435     0.150
     7.484   109.575     0.150
     7.675   113.052     0.150
     7.713   114.325     0.150
     7.806   114.351     0.150
     7.806   114.216     0.150
     7.835   114.976     0.150
     7.920   117.466     0.150
     7.922   115.745     0.150
     7.997   116.325     0.150
     8.114   120.437     0.150
     8.124   122.546     0.150
     8.284   121.065     0.150
     8.394   121.780     0.150
     8.589   130.646     0.150
     8.719   130.905     0.150
     9.143   135.866     0.150
     9.286   134.546     0.150
     9.538   140.726     0.150
     9.633   139.517     0.150
    10.236   148.405     0.150
    10.310   150.726     0.150
    10.491   150.575     0.150
    10.748   157.026     0.150
    10.833   156.087     0.150
    10.978   162.026     0.150
    11.123   162.735     0.150
    11.271   164.026     0.150
    11.271   357.812     0.150
    11.334   166.517     0.150
    11.457   166.306     0.150
    11.554   168.985     0.150
    11.575   170.017     0.150
    11.599   168.007     0.150
    11.633   167.915     0.150
    11.753   170.476     0.150
    12.735   186.187     0.150
    12.732   186.726     0.150
    12.753   186.856     0.150
    13.073   190.636     0.150
    13.403   192.626     0.150
    13.543   196.806     0.150
    13.600   198.427     0.150
    13.620   196.716     0.150
    13.760   199.976     0.150
    13.988   198.126     0.150
    14.179   200.726     0.150
    14.283   206.437     0.150
    14.299   205.306     0.150
    14.311   207.075     0.150
    14.406   205.976     0.150
    14.552   210.026     0.150
    14.631   207.325     0.150
    14.846   212.985     0.150
    14.852   213.995     0.150
    15.081   214.507     0.150
    15.125   217.427     0.150
    15.149   216.776     0.150
    15.305   218.087     0.150
    15.847   223.026     0.150
    15.860   225.626     0.150
    16.126   228.837     0.150
    16.142   232.235     0.150
    16.284   233.976     0.150
    16.570   235.347     0.150
    16.631   235.757     0.150
    16.870   237.325     0.150
    17.306   244.956     0.150
    17.531   245.097     0.150
    18.080   252.786     0.150
    18.266   253.126     0.150
    19.284   268.187     0.150
    19.949   274.065     0.150
    20.429   277.626     0.150
    20.815   282.026     0.150
    20.962   286.046     0.150
    21.059   284.026     0.150
    21.303   288.126     0.150
    21.603   290.915     0.150
    21.977   294.896     0.150
    22.359   299.026     0.150
    22.386   299.206     0.150
    22.791   303.466     0.150
    22.900   305.575     0.150
    22.989   306.126     0.150
    23.816   315.017     0.150
    23.984   315.851     0.150
    24.044   317.466     0.150
    24.199   316.927     0.150
    24.303   318.476     0.150
    26.286   829.251     0.150
    27.836   351.901     0.150
    30.068   369.521     0.150
    43.508   483.276     0.150
    47.272   514.847     0.150
    55.464   575.526     0.150
    55.966   581.126     0.150
    55.966   580.665     0.150
    62.655   626.427     0.150
    63.068   627.700     0.150
    67.055   655.226     0.150
    70.802   677.306     0.150
    77.212   716.427     0.150
    78.712   724.058     0.150
    83.236   746.126     0.150
    83.236  1366.226     0.150
    83.236  1690.325     0.150
    86.021   761.325     0.150
    86.021  1393.927     0.150
    89.516  1410.126     0.150
    89.516  1486.626     0.150
    89.511   780.726     0.150
    90.735   784.427     0.150
    93.549   793.726     0.150
    93.549  1454.126     0.150
    93.549  1842.026     0.150
    95.189   800.325     0.150
    95.189  1031.526     0.150
    95.189  1470.726     0.150
    97.942   815.927     0.150
   101.242   830.927     0.150
   101.242   836.126     0.150
   101.242  1526.126     0.150
   102.582   835.126     0.150
   102.582   839.825     0.150
   102.582  1090.325     0.150
   102.582  1472.626     0.150
   102.582  1534.325     0.150
   102.582  1965.726     0.150
   109.070   865.026     0.150
   109.070  1591.626     0.150
   109.070  2056.026     0.150
   112.207  1115.927     0.150
   145.969  1180.276     0.150
     0.045     1.488     0.150
     0.045     3.930     0.150
     0.413     8.047     0.150
     0.439     8.238     0.150
     0.475     9.020     0.150
     0.475    16.270     0.150
     0.538     9.598     0.150
     0.635    11.109     0.150
     0.635    20.082     0.150
     0.628    10.840     0.150
     0.628    20.090     0.150
     0.668    11.547     0.150
     0.683    12.262     0.150
     0.683    22.082     0.150
     0.690    12.238     0.150
     0.726    12.402     0.150
     0.726    22.148     0.150
     0.743    14.047     0.150
     0.743    24.180     0.150
     1.011    18.648     0.150
     1.011    33.020     0.150
     1.020    17.547     0.150
     1.020    31.262     0.150
     1.140    20.289     0.150
     1.140    36.219     0.150
     1.157    19.699     0.150
     1.157    35.879     0.150
     1.198    19.562     0.150
     1.352    21.879     0.150
     1.352    40.582     0.150
     1.343    24.098     0.150
     1.343    22.867     0.150
     1.343    42.859     0.150
     1.386    24.688     0.150
     1.386    44.039     0.150
     1.414    25.098     0.150
     1.414    45.719     0.150
     1.492    23.602     0.150
     1.492    42.555     0.150
     1.560    25.617     0.150
     1.560    47.875     0.150
     1.701    26.668     0.150
     1.846    28.793     0.150
     1.846    55.805     0.150
     1.939    59.422     0.150
     2.090    62.988     0.150
     2.190    33.102     0.150
     2.190    59.957     0.150
     2.196    33.594     0.150
     2.196    66.652     0.150
     2.336    35.516     0.150
     2.443    74.156     0.150
     2.469    38.109     0.150
     2.469    74.855     0.150
     2.627    39.543     0.150
     2.619    41.098     0.150
     2.762    41.785     0.150
     2.762    83.391     0.150
     2.792    42.328     0.150
     2.860    43.305     0.150
     2.894    44.078     0.150
     2.885    47.797     0.150
     2.919    44.254     0.150
     2.940    51.188     0.150
     2.940    90.430     0.150
     3.062    45.828     0.150
     3.280    50.047     0.150
     3.284    48.609     0.150
     3.311    48.824     0.150
     3.321    51.152     0.150
     3.372    50.566     0.150
     3.396    50.402     0.150
     3.525    53.152     0.150
     3.563    54.504     0.150
     3.665    55.660     0.150
     3.791    57.375     0.150
     3.846    56.789     0.150
     3.846   123.277     0.150
     3.888    57.203     0.150
     3.960    58.836     0.150
     4.017    60.719     0.150
     4.039    60.859     0.150
     4.111    61.656     0.150
     4.104    61.707     0.150
     4.220    63.477     0.150
     4.251    63.410     0.150
     4.330    64.762     0.150
     4.482    68.387     0.150
     4.500    66.129     0.150
     4.528    66.664     0.150
     4.543    66.977     0.150
     4.648    67.539     0.150
     4.698    70.277     0.150
     5.162    75.180     0.150
     5.154    76.254     0.150
     5.153    77.082     0.150
     5.253    76.504     0.150
     5.656    82.477     0.150
     6.433    94.602     0.150
     6.433   123.680     0.150
     6.563   100.098     0.150
     7.008   102.691     0.150
     7.346   109.477     0.150
     7.346   235.137     0.150
     7.698   247.340     0.150
     7.796   113.004     0.150
     7.796   146.078     0.150
     7.906   118.148     0.150
     7.982   120.648     0.150
     8.270   121.957     0.150
     8.270   157.906     0.150
     9.128   136.566     0.150
    10.489   149.727     0.150
    10.735   157.609     0.150
    11.257   165.039     0.150
    11.257   164.871     0.150
    11.319   166.258     0.150
    11.442   168.020     0.150
    13.399   192.066     0.150
    13.492   193.629     0.150
    14.286   206.977     0.150
    14.392   210.527     0.150
    15.847   224.500     0.150
    20.801   283.688     0.150
    30.054   368.465     0.150
     0.045     0.730     0.150
     0.045     2.719     0.150
     0.414     8.031     0.150
     0.444     8.289     0.150
     0.473     9.211     0.150
     0.473    15.949     0.150
     0.473    16.449     0.150
     0.533     9.699     0.150
     0.627    10.812     0.150
     0.627    19.523     0.150
     0.641    11.273     0.150
     0.641    20.332     0.150
     0.679    12.430     0.150
     0.679    21.754     0.150
     0.674    11.730     0.150
     0.687    12.172     0.150
     0.732    12.496     0.150
     0.732    22.109     0.150
     0.737    14.160     0.150
     0.737    24.172     0.150
     1.010    19.160     0.150
     1.010    33.090     0.150
     1.016    17.547     0.150
     1.016    30.965     0.150
     1.134    20.270     0.150
     1.134    36.191     0.150
     1.152    19.820     0.150
     1.152    35.270     0.150
     1.201    19.559     0.150
     1.201    36.477     0.150
     1.337    23.852     0.150
     1.337    23.000     0.150
     1.337    42.430     0.150
     1.359    21.969     0.150
     1.359    40.578     0.150
     1.379    24.520     0.150
     1.379    44.070     0.150
     1.411    43.281     0.150
     1.491    23.602     0.150
     1.491    42.055     0.150
     1.555    25.594     0.150
     1.555    45.488     0.150
     1.638    25.605     0.150
     1.705    26.773     0.150
     1.852    29.020     0.150
     1.852    56.227     0.150
     1.936    30.641     0.150
     1.936    59.438     0.150
     2.095    62.742     0.150
     2.195    33.324     0.150
     2.203    33.949     0.150
     2.203    66.738     0.150
     2.239    34.812     0.150
     2.339    35.770     0.150
     2.382    36.637     0.150
     2.449    37.699     0.150
     2.475    38.008     0.150
     2.475    74.836     0.150
     2.511    38.531     0.150
     2.622    41.211     0.150
     2.636    40.688     0.150
     2.633    40.090     0.150
     2.758    41.848     0.150
     2.758    83.180     0.150
     2.783    84.738     0.150
     2.799    42.305     0.150
     2.864    43.102     0.150
     2.864    43.590     0.150
     2.883    48.430     0.150
     2.883    88.680     0.150
     2.899    44.285     0.150
     2.926    44.438     0.150
     3.013    45.637     0.150
     3.068    45.797     0.150
     3.282    49.980     0.150
     3.287    49.797     0.150
     3.287    49.934     0.150
     3.316    49.469     0.150
     3.327    51.188     0.150
     3.375    51.488     0.150
     3.403    50.371     0.150
     3.532    52.488     0.150
     3.557    57.211     0.150
     3.568    53.980     0.150
     3.670    55.984     0.150
     3.797    57.453     0.150
     3.851    57.500     0.150
     3.893    57.102     0.150
     3.966    58.375     0.150
     4.021    60.680     0.150
     4.108    61.719     0.150
     4.118    62.344     0.150
     4.126    62.000     0.150
     4.126    61.391     0.150
     4.227    62.871     0.150
     4.257    63.969     0.150
     4.290    64.773     0.150
     4.335    64.539     0.150
     4.506    67.039     0.150
     4.507    66.324     0.150
     4.534    66.672     0.150
     4.653    68.047     0.150
     4.702    70.062     0.150
     4.954    73.648     0.150
     5.156    76.891     0.150
     5.159    76.996     0.150
     5.168    75.324     0.150
     5.173    75.953     0.150
     5.254    77.965     0.150
     5.258    76.598     0.150
     5.311    78.723     0.150
     5.364    79.887     0.150
     5.662    82.121     0.150
     7.352   109.320     0.150
     7.802   113.977     0.150
     7.802   113.090     0.150
    10.494   149.824     0.150
    10.494   330.801     0.150
    10.968   162.305     0.150
    11.262   165.332     0.150
    14.288   206.871     0.150
    14.528   212.051     0.150
    15.849   226.359     0.150
    20.805   283.121     0.150
    21.595   290.609     0.150
    23.991   316.398     0.150
    95.179  1466.852     0.150
    95.179  1484.051     0.150
   102.573   842.449     0.150
   102.573  1086.750     0.150
     0.031     1.773     0.150
     0.031     3.383     0.150
     0.031     3.533     0.150
     0.401     7.504     0.150
     0.444     8.582     0.150
     0.463     8.973     0.150
     0.463    15.832     0.150
     0.463    16.713     0.150
     0.531     9.893     0.150
     0.552     9.973     0.150
     0.643    11.215     0.150
     0.643    20.035     0.150
     0.626    11.057     0.150
     0.626    19.225     0.150
     0.665    21.482     0.150
     0.697    12.799     0.150
     0.697    22.152     0.150
     0.705    12.562     0.150
     0.728    12.516     0.150
     0.728    22.195     0.150
     0.728    12.633     0.150
     0.744    14.104     0.150
     0.744    24.363     0.150
     0.998    18.822     0.150
     0.998    32.453     0.150
     1.035    17.764     0.150
     1.035    31.357     0.150
     1.150    20.354     0.150
     1.170    19.963     0.150
     1.170    34.213     0.150
     1.210    19.883     0.150
     1.210    34.521     0.150
     1.344    21.803     0.150
     1.344    40.729     0.150
     1.346    23.973     0.150
     1.346    22.912     0.150
     1.346    42.854     0.150
     1.390    24.492     0.150
     1.390    44.043     0.150
     1.405    25.863     0.150
     1.508    23.898     0.150
     1.508    42.471     0.150
     1.508    42.312     0.150
     1.574    25.764     0.150
     1.574    48.109     0.150
     1.651    25.836     0.150
     1.711    26.859     0.150
     1.711    48.057     0.150
     1.846    28.893     0.150
     1.846    55.795     0.150
     1.954    30.406     0.150
     1.954    59.732     0.150
     2.094    62.631     0.150
     2.177    32.869     0.150
     2.191    33.789     0.150
     2.348    35.725     0.150
     2.440    37.410     0.150
     2.473    37.889     0.150
     2.629    41.703     0.150
     2.629    49.322     0.150
     2.629    83.854     0.150
     2.617    39.701     0.150
     2.776    42.031     0.150
     2.776    83.826     0.150
     2.777    42.107     0.150
     2.785    42.072     0.150
     2.802    85.176     0.150
     2.901    44.523     0.150
     2.901    53.523     0.150
     2.901    89.943     0.150
     2.915    43.412     0.150
     2.956    45.893     0.150
     2.956    53.812     0.150
     2.956    89.873     0.150
     3.023    45.166     0.150
     3.052    45.379     0.150
     3.278    49.760     0.150
     3.293    50.811     0.150
     3.388    50.160     0.150
     3.519    52.324     0.150
     3.570    54.686     0.150
     3.575    54.832     0.150
     3.575    65.223     0.150
     3.669    55.668     0.150
     3.787    56.939     0.150
     3.834    56.072     0.150
     3.834    72.283     0.150
     3.834   124.043     0.150
     3.867    56.488     0.150
     3.875    56.910     0.150
     3.953    58.023     0.150
     4.026    60.385     0.150
     4.111    61.873     0.150
     4.110    62.221     0.150
     4.143    62.264     0.150
     4.143    77.723     0.150
     4.143   130.562     0.150
     4.161    61.156     0.150
     4.215    63.227     0.150
     4.253    64.607     0.150
     4.335    65.637     0.150
     4.481    67.914     0.150
     4.481    67.754     0.150
     4.481    85.582     0.150
     4.491    65.867     0.150
     4.489    65.623     0.150
     4.517    65.850     0.150
     4.644    69.662     0.150
     4.635    67.338     0.150
     4.705    70.260     0.150
     4.782    71.365     0.150
     4.939    73.271     0.150
     5.057    76.111     0.150
     5.082    74.100     0.150
     5.162    77.373     0.150
     5.158    76.246     0.150
     5.240    75.984     0.150
     5.298    78.514     0.150
     5.353    79.869     0.150
     5.525    82.486     0.150
     5.604    83.279     0.150
     5.646    84.617     0.150
     5.645    81.832     0.150
     5.827    85.424     0.150
     5.863    87.680     0.150
     5.993    89.738     0.150
     6.136    90.969     0.150
     6.270    92.334     0.150
     6.472    96.225     0.150
     6.779   100.488     0.150
     7.018   102.596     0.150
     7.345   108.689     0.150
     7.345   108.412     0.150
     7.345   233.162     0.150
     7.789   112.969     0.150
     7.789   247.242     0.150
     8.281   124.094     0.150
     8.281   155.969     0.150
     8.281   264.242     0.150
    10.475   150.117     0.150
    10.983   162.184     0.150
     0.031     0.766     0.150
     0.031     2.455     0.150
     0.398     7.325     0.150
     0.427     8.275     0.150
     0.449     8.445     0.150
     0.461     9.255     0.150
     0.461    16.436     0.150
     0.461    17.386     0.150
     0.529     9.705     0.150
     0.547     9.936     0.150
     0.632    20.123     0.150
     0.642    10.670     0.150
     0.642    19.992     0.150
     0.664    11.785     0.150
     0.659    12.335     0.150
     0.659    21.565     0.150
     0.692    22.234     0.150
     0.702    12.476     0.150
     0.734    21.975     0.150
     0.734    12.455     0.150
     0.737    13.525     0.150
     0.737    24.646     0.150
     0.997    18.195     0.150
     0.997    32.605     0.150
     1.031    17.622     0.150
     1.031    31.557     0.150
     1.144    20.205     0.150
     1.144    35.726     0.150
     1.165    20.105     0.150
     1.165    36.235     0.150
     1.212    19.701     0.150
     1.350    22.003     0.150
     1.350    40.384     0.150
     1.339    24.365     0.150
     1.339    22.875     0.150
     1.339    42.755     0.150
     1.383    24.726     0.150
     1.383    43.646     0.150
     1.506    23.813     0.150
     1.506    43.049     0.150
     1.506    24.195     0.150
     1.569    25.577     0.150
     1.569    45.760     0.150
     1.714    26.887     0.150
     1.852    28.860     0.150
     1.852    56.314     0.150
     1.951    30.543     0.150
     1.951    59.992     0.150
     2.182    33.274     0.150
     2.197    33.791     0.150
     2.197    67.017     0.150
     2.350    35.755     0.150
     2.478    75.133     0.150
     2.624    39.842     0.150
     2.772    84.579     0.150
     2.904    44.327     0.150
     2.898    48.405     0.150
     2.921    44.511     0.150
     2.952    51.915     0.150
     3.296    50.272     0.150
     3.304    49.164     0.150
     3.526    52.634     0.150
     3.572    58.025     0.150
     3.840    56.565     0.150
     3.873    57.058     0.150
     3.959    58.193     0.150
     4.487    67.485     0.150
     4.523    66.328     0.150
     4.640    67.970     0.150
     5.088    74.183     0.150
     5.245    76.460     0.150
     5.651    82.165     0.150
     7.796   243.436     0.150
     8.283   261.085     0.150
    10.481   149.710     0.150
    11.267   165.886     0.150
     0.046     1.883     0.150
     0.085     2.539     0.150
     0.161     4.359     0.150
     0.381     7.094     0.150
     0.414     8.219     0.150
     0.444     8.500     0.150
     0.513     9.516     0.150
     0.532     9.555     0.150
     0.626    10.922     0.150
     0.626    19.281     0.150
     0.643    10.953     0.150
     0.643    20.109     0.150
     0.645    11.969     0.150
     0.645    20.961     0.150
     0.675    11.773     0.150
     0.686    12.195     0.150
     0.677    12.305     0.150
     0.677    21.156     0.150
     0.732    12.586     0.150
     0.732    21.961     0.150
     0.732    22.398     0.150
     0.736    13.914     0.150
     0.736    24.211     0.150
     1.015    17.516     0.150
     1.015    31.266     0.150
     1.133    20.109     0.150
     1.133    36.203     0.150
     1.133    36.453     0.150
     1.151    20.320     0.150
     1.151    36.398     0.150
     1.200    19.719     0.150
     1.360    22.070     0.150
     1.335    23.648     0.150
     1.460    23.508     0.150
     1.460    44.180     0.150
     1.411    24.305     0.150
     1.411    44.875     0.150
     1.490    23.648     0.150
     1.490    23.445     0.150
     1.554    25.609     0.150
     1.638    25.820     0.150
     1.704    26.969     0.150
     1.853    29.102     0.150
     1.853    56.250     0.150
     1.935    30.188     0.150
     2.096    32.688     0.150
     2.096    62.930     0.150
     2.091    32.648     0.150
     2.197    33.289     0.150
     2.237    34.383     0.150
     2.338    35.906     0.150
     2.382    36.594     0.150
     2.450    37.531     0.150
     2.475    38.266     0.150
     2.475    74.688     0.150
     2.510    38.070     0.150
     2.622    41.180     0.150
     2.622    49.445     0.150
     2.622    86.695     0.150
     2.635    40.141     0.150
     2.635    40.172     0.150
     2.756    82.727     0.150
     2.757    42.039     0.150
     2.757    83.547     0.150
     2.782    42.719     0.150
     2.782    84.547     0.150
     2.800    42.477     0.150
     2.864    43.445     0.150
     2.865    43.367     0.150
     2.881    44.875     0.150
     2.881    81.172     0.150
     2.881    53.164     0.150
     2.881    91.023     0.150
     2.900    44.219     0.150
     2.927    44.039     0.150
     2.936    49.930     0.150
     3.012    45.281     0.150
     3.091    45.977     0.150
     3.091    46.391     0.150
     3.091    58.531     0.150
     3.091    85.648     0.150
     3.070    45.594     0.150
     3.287    49.109     0.150
     3.288    49.055     0.150
     3.328    50.609     0.150
     3.318    48.828     0.150
     3.375    50.344     0.150
     3.404    50.438     0.150
     3.533    52.695     0.150
     3.568    54.328     0.150
     3.555    55.531     0.150
     3.555   108.828     0.150
     3.613    56.070     0.150
     3.613    70.398     0.150
     3.613    99.273     0.150
     3.613   113.250     0.150
     3.671    55.594     0.150
     3.728    56.852     0.150
     3.799    57.570     0.150
     3.853    55.469     0.150
     3.853   104.375     0.150
     3.853    72.281     0.150
     3.853   123.383     0.150
     3.885    56.773     0.150
     3.894    57.164     0.150
     3.968    58.500     0.150
     4.021    59.961     0.150
     4.042    60.383     0.150
     4.109    61.273     0.150
     4.118    62.211     0.150
     4.125    60.672     0.150
     4.125   130.914     0.150
     4.177    61.719     0.150
     4.228    62.844     0.150
     4.258    63.648     0.150
     4.335    64.867     0.150
     4.489    67.312     0.150
     4.489    84.055     0.150
     4.489   119.250     0.150
     4.489   145.164     0.150
     4.508    66.250     0.150
     4.509    65.547     0.150
     4.545    66.734     0.150
     4.535    66.367     0.150
     4.655    69.445     0.150
     4.655    67.805     0.150
     4.702    69.578     0.150
     4.775    70.859     0.150
     4.954    73.766     0.150
     4.952    73.031     0.150
     5.100    74.242     0.150
     5.156    76.719     0.150
     5.160    76.453     0.150
     5.175    75.898     0.150
     5.169    74.734     0.150
     5.259    76.430     0.150
     5.313    78.297     0.150
     5.334    79.734     0.150
     5.334    98.781     0.150
     5.479    80.648     0.150
     5.542    82.672     0.150
     5.542   146.672     0.150
     5.542   104.766     0.150
     5.551    82.109     0.150
     5.559    86.430     0.150
     5.616    82.969     0.150
     5.663    82.391     0.150
     5.815    86.000     0.150
     5.815   108.781     0.150
     5.819    85.484     0.150
     5.883    86.398     0.150
     5.889    86.617     0.150
     5.942    87.016     0.150
     6.147    90.695     0.150
     6.414    94.234     0.150
     6.433    94.695     0.150
     6.479    95.758     0.150
     6.569    98.672     0.150
     6.569   170.273     0.150
     6.569   125.352     0.150
     6.569   207.062     0.150
     6.573    96.328     0.150
     6.583    96.484     0.150
     6.622    99.273     0.150
     6.622   172.969     0.150
     6.622   212.094     0.150
     6.729    98.469     0.150
     6.931   101.773     0.150
     6.931   180.570     0.150
     6.931   130.992     0.150
     7.011   102.961     0.150
     7.040   102.188     0.150
     7.090   103.961     0.150
     7.121   103.578     0.150
     7.121   184.820     0.150
     7.204   104.562     0.150
     7.230   105.836     0.150
     7.250   105.961     0.150
     7.352   108.094     0.150
     7.353   108.594     0.150
     7.353   139.781     0.150
     7.353   234.070     0.150
     7.483   108.070     0.150
     7.483   143.039     0.150
     7.511   108.766     0.150
     7.518   110.438     0.150
     7.557   110.703     0.150
     7.602   112.555     0.150
     7.602   144.539     0.150
     7.602   196.305     0.150
     7.602   242.641     0.150
     7.664   111.414     0.150
     7.704   113.398     0.150
     7.704   146.844     0.150
     7.704   246.180     0.150
     7.804   113.445     0.150
     7.804   113.250     0.150
     7.912   116.992     0.150
     7.912   203.281     0.150
     7.915   116.180     0.150
     7.915   204.773     0.150
     7.933   150.484     0.150
     7.933   205.203     0.150
     7.933   253.625     0.150
     7.986   255.359     0.150
     8.062   118.328     0.150
     8.103   119.375     0.150
     8.103   262.875     0.150
     8.114   116.484     0.150
     8.114   207.664     0.150
     8.273   118.773     0.150
     8.273   119.898     0.150
     8.273   157.539     0.150
     8.296   120.469     0.150
     8.383   121.391     0.150
     8.579   124.484     0.150
     8.579   162.266     0.150
     8.579   274.883     0.150
     8.592   128.469     0.150
     8.592   222.375     0.150
     8.653   126.742     0.150
     8.653   164.250     0.150
     8.653   223.125     0.150
     8.653   277.102     0.150
     9.069   132.250     0.150
     9.132   132.359     0.150
     9.132   236.992     0.150
     9.169   133.422     0.150
     9.199   238.469     0.150
     9.288   134.289     0.150
     9.427   140.039     0.150
     9.427   301.562     0.150
     9.528   136.555     0.150
     9.629   138.852     0.150
     9.629   248.172     0.150
     9.963   142.773     0.150
     9.963   257.773     0.150
    10.225   146.711     0.150
    10.299   149.773     0.150
    10.495   150.195     0.150
    10.495   330.094     0.150
    10.742   154.633     0.150
    10.742   274.391     0.150
    10.823   278.578     0.150
    10.967   160.453     0.150
    10.967   157.992     0.150
    11.112   160.930     0.150
    11.262   162.773     0.150
    11.447   165.484     0.150
    11.447   290.266     0.150
    11.565   293.633     0.150
    11.632   166.680     0.150
    11.632   295.648     0.150
    11.743   168.875     0.150
    11.743   298.711     0.150
    11.837   170.812     0.150
    11.837   299.898     0.150
    11.932   172.664     0.150
    11.932   304.703     0.150
    12.473   181.109     0.150
    12.473   316.914     0.150
    12.482   178.750     0.150
    12.482   320.039     0.150
    12.504   183.320     0.150
    12.504   318.648     0.150
    12.661   181.570     0.150
    12.661   319.953     0.150
    12.725   186.211     0.150
    12.768   321.469     0.150
    13.062   333.883     0.150
    13.432   193.883     0.150
    13.406   190.172     0.150
    13.406   334.672     0.150
    13.497   191.602     0.150
    13.497   341.664     0.150
    13.533   194.180     0.150
    13.533   341.172     0.150
    13.749   196.695     0.150
    13.987   197.023     0.150
    14.287   202.609     0.150
    14.287   359.883     0.150
    14.300   206.602     0.150
    14.395   204.531     0.150
    14.395   361.789     0.150
    14.488   206.562     0.150
    14.528   207.984     0.150
    14.623   205.969     0.150
    14.623   368.570     0.150
    14.835   209.922     0.150
    14.835   373.328     0.150
    15.070   212.828     0.150
    15.070   378.445     0.150
    15.070   520.984     0.150
    15.113   215.273     0.150
    15.137   217.883     0.150
    15.294   220.922     0.150
    15.383   217.344     0.150
    15.423   219.672     0.150
    15.838   222.789     0.150
    15.849   224.773     0.150
    16.116   228.148     0.150
    16.116   404.461     0.150
    16.273   228.344     0.150
    16.493   234.148     0.150
    16.567   232.734     0.150
    16.567   415.625     0.150
    16.620   234.648     0.150
    16.872   236.172     0.150
    16.872   422.070     0.150
    17.294   242.445     0.150
    17.532   245.016     0.150
    18.071   251.000     0.150
    18.265   253.773     0.150
    18.499   254.781     0.150
    18.499   460.828     0.150
    19.944   270.383     0.150
    20.068   278.969     0.150
    20.068   488.875     0.150
    20.427   277.570     0.150
    20.804   281.273     0.150
    20.963   283.148     0.150
    21.057   282.469     0.150
    21.057   517.469     0.150
    21.158   284.875     0.150
    21.158   520.000     0.150
    21.595   290.383     0.150
    21.706   291.172     0.150
    22.354   295.773     0.150
    22.790   302.719     0.150
    22.892   305.172     0.150
    22.892   721.695     0.150
    22.969   304.109     0.150
    22.987   304.375     0.150
    23.222   308.023     0.150
    23.992   316.070     0.150
    24.045   316.469     0.150
    24.189   315.422     0.150
    24.540   319.133     0.150
    25.683   329.484     0.150
    27.081   343.500     0.150
    27.825   351.695     0.150
    27.825   351.492     0.150
    30.057   369.016     0.150
    31.473   382.023     0.150
    36.386   423.672     0.150
    37.662   434.469     0.150
    38.063   438.773     0.150
    38.063   438.648     0.150
    38.710   444.609     0.150
    40.360   460.344     0.150
    40.705   460.945     0.150
    43.497   483.969     0.150
    47.280   514.789     0.150
    47.487   515.219     0.150
    55.454   574.992     0.150
    55.955   579.570     0.150
    62.539  1381.875     0.150
    62.645   626.375     0.150
    63.059   631.875     0.150
    67.044   655.773     0.150
    72.384   688.875     0.150
    74.362   697.875     0.150
    74.379   699.383     0.150
    76.677   712.570     0.150
    77.203   716.625     0.150
    80.422   733.500     0.150
    81.005   733.469     0.150
    83.226   745.469     0.150
    83.432   747.672     0.150
    83.626   748.773     0.150
    83.630   747.570     0.150
    83.671   749.273     0.150
    83.733   748.969     0.150
    84.080   750.875     0.150
    84.779   754.672     0.150
    84.976   755.469     0.150
    85.038   756.172     0.150
    85.238   756.875     0.150
    86.011   761.172     0.150
    86.011  1393.773     0.150
    89.500   779.875     0.150
    89.500  1433.273     0.150
    90.724   785.070     0.150
    91.468   788.672     0.150
    91.481   788.898     0.150
    92.199   791.945     0.150
    93.539   794.469     0.150
    93.539  1017.969     0.150
    95.178   802.773     0.150
    95.178  1033.969     0.150
    95.178  1436.070     0.150
    95.178  1473.273     0.150
    95.178  1861.570     0.150
    97.933   815.469     0.150
   101.231   833.672     0.150
   106.917   856.273     0.150
   106.917  1124.469     0.150
   106.917  1573.969     0.150
   106.917  2026.469     0.150
   109.060   864.469     0.150
   109.060  1107.672     0.150
   109.060  2054.969     0.150
   112.197  1115.172     0.150
   145.972  1180.625     0.150
     0.380     7.054     0.150
     0.417     8.214     0.150
     0.450     8.554     0.150
     0.513     9.464     0.150
     0.529     9.554     0.150
     0.626    10.815     0.150
     0.626    19.803     0.150
     0.641    11.915     0.150
     0.648    11.354     0.150
     0.648    20.479     0.150
     0.685    12.354     0.150
     0.674    12.335     0.150
     0.674    21.749     0.150
     0.680    11.774     0.150
     0.739    12.571     0.150
     0.739    21.966     0.150
     0.739    22.234     0.150
     0.729    13.875     0.150
     0.729    24.944     0.150
     1.012    17.475     0.150
     1.012    31.294     0.150
     1.147    19.734     0.150
     1.147    32.975     0.150
     1.128    20.084     0.150
     1.204    19.665     0.150
     1.204    35.176     0.150
     1.366    22.080     0.150
     1.329    22.344     0.150
     1.372    23.314     0.150
     1.466    23.343     0.150
     1.466    44.094     0.150
     1.490    23.580     0.150
     1.490    42.354     0.150
     1.406    24.145     0.150
     1.551    25.448     0.150
     1.551    47.649     0.150
     1.640    25.789     0.150
     1.709    26.633     0.150
     1.709    52.208     0.150
     1.859    29.030     0.150
     1.934    30.224     0.150
     1.934    59.066     0.150
     2.102    32.719     0.150
     2.102    62.849     0.150
     2.096    32.554     0.150
     2.210    34.020     0.150
     2.238    34.742     0.150
     2.201    33.279     0.150
     2.342    35.740     0.150
     2.387    36.613     0.150
     2.457    37.510     0.150
     2.481    38.106     0.150
     2.481    75.113     0.150
     2.513    38.154     0.150
     2.627    41.114     0.150
     2.627    48.384     0.150
     2.627    82.424     0.150
     2.634    40.255     0.150
     2.640    40.129     0.150
     2.754    41.836     0.150
     2.754    83.560     0.150
     2.754    83.680     0.150
     2.780    84.125     0.150
     2.806    42.266     0.150
     2.869    43.027     0.150
     2.871    43.292     0.150
     2.880    43.875     0.150
     2.880    50.435     0.150
     2.906    43.787     0.150
     2.933    43.887     0.150
     2.935    47.864     0.150
     3.016    45.128     0.150
     3.093    46.142     0.150
     3.093    46.245     0.150
     3.083    92.947     0.150
     3.075    45.545     0.150
     3.292    49.006     0.150
     3.281    49.134     0.150
     3.281    99.268     0.150
     3.294    49.462     0.150
     3.379    50.801     0.150
     3.322    48.808     0.150
     3.410    50.410     0.150
     3.539    52.646     0.150
     3.574    54.508     0.150
     3.554    55.094     0.150
     3.554    64.384     0.150
     3.610    55.194     0.150
     3.677    55.881     0.150
     3.735    55.778     0.150
     3.805    56.829     0.150
     3.858    57.134     0.150
     3.890    57.167     0.150
     3.898    57.293     0.150
     3.945    58.086     0.150
     3.974    58.453     0.150
     4.013    58.909     0.150
     4.026    59.323     0.150
     4.042    59.658     0.150
     4.047    60.594     0.150
     4.114    60.735     0.150
     4.126    60.476     0.150
     4.126    60.794     0.150
     4.125    61.811     0.150
     4.183    61.626     0.150
     4.234    63.209     0.150
     4.264    64.329     0.150
     4.295    64.542     0.150
     4.341    65.460     0.150
     4.495    67.806     0.150
     4.495    67.444     0.150
     4.549    84.534     0.150
     4.513    66.030     0.150
     4.513    65.607     0.150
     4.540    66.439     0.150
     4.661    69.677     0.150
     4.708    70.150     0.150
     4.659    68.014     0.150
     4.779    70.960     0.150
     4.960    73.864     0.150
     4.958    73.243     0.150
     5.070    75.775     0.150
     5.105    74.180     0.150
     5.161    77.064     0.150
     5.166    77.229     0.150
     5.180    76.110     0.150
     5.174    74.733     0.150
     5.260    77.729     0.150
     5.263    76.096     0.150
     5.340    79.174     0.150
     5.340   100.764     0.150
     5.319    78.459     0.150
     5.372    79.865     0.150
     5.515    81.790     0.150
     5.547    81.935     0.150
     5.547    94.674     0.150
     5.547   103.904     0.150
     5.547   173.844     0.150
     5.555    82.071     0.150
     5.541    82.455     0.150
     5.622    83.042     0.150
     5.659    84.758     0.150
     5.668    82.209     0.150
     5.756    86.282     0.150
     5.825    86.013     0.150
     5.874    87.817     0.150
     5.888    86.298     0.150
     5.894    86.792     0.150
     6.008    89.896     0.150
     6.154    90.907     0.150
     6.289    91.951     0.150
     6.372    94.706     0.150
     6.418    94.578     0.150
     6.485    96.072     0.150
     6.574    99.804     0.150
     6.574   123.964     0.150
     6.574   205.784     0.150
     6.578    96.138     0.150
     6.621    96.375     0.150
     6.621   126.185     0.150
     6.735    98.589     0.150
     6.820   101.328     0.150
     6.901   105.384     0.150
     6.932    99.104     0.150
     6.932   129.995     0.150
     6.932   216.194     0.150
     7.016   102.680     0.150
     7.095   104.257     0.150
     7.127   103.444     0.150
     7.127   135.254     0.150
     7.210   104.844     0.150
     7.236   105.394     0.150
     7.255   106.009     0.150
     7.360   108.995     0.150
     7.360   230.314     0.150
     7.489   108.094     0.150
     7.489   139.834     0.150
     7.489   237.464     0.150
     7.517   108.714     0.150
     7.608   142.054     0.150
     7.608   240.804     0.150
     7.711   112.444     0.150
     7.711   143.915     0.150
     7.711   240.665     0.150
     7.810   113.604     0.150
     7.810   241.455     0.150
     7.810   113.034     0.150
     7.810   146.764     0.150
     7.810   241.984     0.150
     7.919   116.935     0.150
     7.919   148.174     0.150
     7.919   249.524     0.150
     7.922   116.284     0.150
     7.922   147.725     0.150
     7.939   114.245     0.150
     7.939   251.834     0.150
     7.944   146.574     0.150
     7.992   148.294     0.150
     8.107   152.534     0.150
     8.120   117.654     0.150
     8.120   151.044     0.150
     8.278   119.804     0.150
     8.278   156.830     0.150
     8.278   209.955     0.150
     8.278   257.904     0.150
     8.278   119.384     0.150
     8.485   268.725     0.150
     8.584   127.014     0.150
     8.598   128.824     0.150
     8.658   128.364     0.150
     8.715   132.334     0.150
     9.138   131.194     0.150
     9.293   133.955     0.150
     9.533   135.284     0.150
     9.425   139.349     0.150
     9.425   303.673     0.150
     9.635   138.935     0.150
    10.302   152.014     0.150
    10.499   150.354     0.150
    10.748   156.634     0.150
    10.829   157.054     0.150
    10.969   161.096     0.150
    11.117   161.935     0.150
    11.268   165.225     0.150
    11.268   165.104     0.150
    11.330   164.594     0.150
    11.452   165.754     0.150
    11.549   167.435     0.150
    11.595   165.435     0.150
    11.638   166.384     0.150
    11.748   168.384     0.150
    11.842   171.564     0.150
    11.937   172.524     0.150
    12.509   183.044     0.150
    12.667   184.084     0.150
    12.695   182.214     0.150
    13.067   189.924     0.150
    13.411   191.864     0.150
    13.503   193.884     0.150
    13.538   195.625     0.150
    13.752   194.014     0.150
    13.993   197.274     0.150
    14.291   202.415     0.150
    14.303   206.654     0.150
    14.400   210.524     0.150
    14.494   209.384     0.150
    14.533   208.264     0.150
    14.629   205.884     0.150
    14.840   212.284     0.150
    15.075   218.895     0.150
    15.116   216.784     0.150
    15.141   217.074     0.150
    15.234   218.604     0.150
    15.299   221.734     0.150
    15.388   219.534     0.150
    15.427   221.194     0.150
    15.604   224.884     0.150
    15.628   222.424     0.150
    15.853   225.174     0.150
    16.062   228.174     0.150
    16.121   229.334     0.150
    16.496   234.154     0.150
    16.573   233.084     0.150
    16.625   235.444     0.150
    16.877   236.895     0.150
    17.297   245.375     0.150
    17.537   246.024     0.150
    18.077   251.794     0.150
    18.271   253.484     0.150
    18.506   255.544     0.150
    19.951   271.625     0.150
    20.433   276.604     0.150
    20.809   280.544     0.150
    20.968   284.165     0.150
    21.063   284.165     0.150
    22.796   302.294     0.150
    22.899   304.604     0.150
    22.975   304.694     0.150
    22.993   305.074     0.150
    23.994   315.504     0.150
    24.195   316.674     0.150
    27.827   350.404     0.150
    29.956   368.745     0.150
    30.062   368.949     0.150
    43.502   484.330     0.150
    47.281   515.314     0.150
    55.460   574.415     0.150
    63.059   631.205     0.150
    77.209   715.354     0.150
    84.163   752.052     0.150
   102.573   838.254     0.150
   102.573   841.754     0.150
   102.573   843.754     0.150
   109.060   864.054     0.150
   109.060  1108.054     0.150
   109.060  1138.754     0.150
   109.060  2052.654     0.150
   112.198  1113.554     0.150
   145.976  1179.654     0.150
     0.018     1.188     0.150
     0.018     3.492     0.150
     0.018     3.992     0.150
     0.104     2.188     0.150
     0.119     3.773     0.150
     0.424     7.836     0.150
     0.449     8.578     0.150
     0.487     9.047     0.150
     0.564    10.297     0.150
     0.568    10.328     0.150
     0.678    11.641     0.150
     0.678    21.438     0.150
     0.635    11.289     0.150
     0.635    20.266     0.150
     0.675    12.672     0.150
     0.669    11.828     0.150
     0.711    13.164     0.150
     0.711    22.938     0.150
     0.733    12.961     0.150
     0.767    13.000     0.150
     0.767    23.227     0.150
     0.712    14.086     0.150
     1.053    18.328     0.150
     1.053    32.656     0.150
     1.144    20.828     0.150
     1.144    36.578     0.150
     1.179    20.312     0.150
     1.179    36.484     0.150
     1.254    20.414     0.150
     1.319    22.852     0.150
     1.319    23.508     0.150
     1.357    22.203     0.150
     1.357    40.859     0.150
     1.366    23.688     0.150
     1.359    24.211     0.150
     1.499    23.781     0.150
     1.499    45.445     0.150
     1.542    24.430     0.150
     1.586    26.227     0.150
     1.586    48.641     0.150
     1.607    25.734     0.150
     1.607    48.609     0.150
     1.693    26.422     0.150
     1.756    27.562     0.150
     1.881    29.453     0.150
     1.980    30.977     0.150
     2.083    32.555     0.150
     2.135    33.102     0.150
     2.170    33.180     0.150
     2.212    34.242     0.150
     2.393    36.648     0.150
     2.429    37.359     0.150
     2.470    37.961     0.150
     2.513    38.625     0.150
     2.565    39.156     0.150
     2.674    41.727     0.150
     2.625    40.078     0.150
     2.683    41.188     0.150
     2.791    42.867     0.150
     2.785    43.289     0.150
     2.801    42.508     0.150
     2.891    44.117     0.150
     2.914    44.656     0.150
     2.927    44.438     0.150
     2.941    44.922     0.150
     2.941    44.203     0.150
     2.981    52.398     0.150
     3.067    46.438     0.150
     3.056    45.594     0.150
     3.146    48.984     0.150
     3.146    47.508     0.150
     3.295    48.742     0.150
     3.601    53.648     0.150
     3.642    53.352     0.150
     3.836    55.297     0.150
     4.095    61.672     0.150
     4.177    63.633     0.150
     4.514    67.945     0.150
     5.380    79.711     0.150
     5.588    82.203     0.150
     6.489   206.227     0.150
     6.611   100.273     0.150
     6.984   102.336     0.150
     7.122   103.414     0.150
     7.203   104.984     0.150
     7.377   109.648     0.150
     7.481   108.188     0.150
     7.510   108.742     0.150
     7.643   112.617     0.150
     7.743   113.492     0.150
     7.807   114.031     0.150
     7.807   113.625     0.150
     7.943   116.984     0.150
     7.943   117.367     0.150
     7.997   120.422     0.150
     8.158   119.008     0.150
     8.158   122.055     0.150
     8.326   120.758     0.150
     8.326   157.453     0.150
     8.326   259.406     0.150
     8.436   122.102     0.150
     8.483   122.266     0.150
     8.625   126.047     0.150
     8.636   127.586     0.150
     8.701   127.062     0.150
     8.753   129.562     0.150
     8.755   131.047     0.150
     8.988   129.734     0.150
     9.180   135.648     0.150
     9.273   134.422     0.150
     9.372   136.352     0.150
     9.576   138.688     0.150
     9.646   139.953     0.150
    10.354   150.445     0.150
    10.768   157.461     0.150
    10.869   159.594     0.150
    11.021   163.469     0.150
    11.305   164.844     0.150
    11.305   164.703     0.150
    11.300   163.836     0.150
    11.371   165.742     0.150
    11.492   167.312     0.150
    11.590   168.977     0.150
    11.610   168.727     0.150
    11.636   169.367     0.150
    11.630   167.531     0.150
    11.788   170.148     0.150
    11.883   172.398     0.150
    11.978   174.078     0.150
    12.529   182.594     0.150
    12.554   183.406     0.150
    12.708   183.047     0.150
    12.735   186.672     0.150
    12.773   186.445     0.150
    12.814   185.672     0.150
    13.112   191.148     0.150
    13.386   192.383     0.150
    13.481   195.414     0.150
    13.542   194.133     0.150
    13.582   194.922     0.150
    13.805   200.836     0.150
    14.064   200.117     0.150
    14.188   210.086     0.150
    14.343   207.688     0.150
    14.355   207.586     0.150
    14.447   206.336     0.150
    14.538   209.836     0.150
    14.579   209.586     0.150
    14.886   211.773     0.150
    15.122   215.531     0.150
    15.169   216.672     0.150
    15.192   217.367     0.150
    15.346   218.562     0.150
    15.436   221.023     0.150
    15.474   219.742     0.150
    15.656   225.336     0.150
    15.880   224.648     0.150
    15.880   396.031     0.150
    15.903   226.992     0.150
    16.163   229.766     0.150
    16.186   232.477     0.150
    16.578   232.516     0.150
    16.672   234.602     0.150
    16.853   236.156     0.150
    17.350   244.352     0.150
    18.112   252.977     0.150
    18.260   253.492     0.150
    18.523   258.078     0.150
    19.279   264.953     0.150
    19.960   277.016     0.150
    20.432   278.648     0.150
    20.856   281.523     0.150
    20.952   284.492     0.150
    21.856   296.781     0.150
    21.978   294.367     0.150
    22.927   303.656     0.150
    22.975   306.125     0.150
    22.987   303.227     0.150
    23.785   313.695     0.150
    23.949   314.852     0.150
    27.089   342.773     0.150
    29.992   369.773     0.150
    30.110   369.703     0.150
    36.091   423.383     0.150
    37.455   434.883     0.150
    37.455   432.617     0.150
    38.654   445.836     0.150
    40.760   458.523     0.150
    46.499   510.195     0.150
    47.066   513.594     0.150
    47.171   514.062     0.150
    47.236   515.477     0.150
    47.397   516.633     0.150
    47.380   933.602     0.150
    56.010   582.547     0.150
    60.949   613.805     0.150
    67.099   653.578     0.150
    80.376   731.930     0.150
    85.072   759.305     0.150
    86.063   761.805     0.150
    86.063  1394.406     0.150
    91.524   788.477     0.150
    92.254   793.188     0.150
    94.787   803.344     0.150
    95.231   802.102     0.150
    95.231  1033.906     0.150
    95.231  1435.305     0.150
    95.231  1481.102     0.150
    97.982   816.203     0.150
   101.286   834.305     0.150
   102.625   836.602     0.150
   102.625   841.305     0.150
   102.625   843.602     0.150
   106.970   857.906     0.150
   109.111   865.602     0.150
   109.111  1108.805     0.150
   109.111  1139.602     0.150
   109.111  2055.203     0.150
   112.250  1115.406     0.150
   145.951  1179.430     0.150
     0.408     7.680     0.150
     0.405     7.523     0.150
     0.405    14.359     0.150
     0.479     9.016     0.150
     0.478     8.719     0.150
     0.493     9.578     0.150
     0.495     9.719     0.150
     0.580    10.164     0.150
     0.580    18.195     0.150
     0.609    11.203     0.150
     0.626    11.164     0.150
     0.721    12.234     0.150
     0.744    12.656     0.150
     0.744    23.156     0.150
     0.744    22.078     0.150
     0.734    13.484     0.150
     0.769    13.773     0.150
     0.769    24.594     0.150
     0.784    13.664     0.150
     0.752    14.125     0.150
     0.752    25.758     0.150
     0.934    16.805     0.150
     0.934    30.094     0.150
     1.110    18.641     0.150
     1.203    20.617     0.150
     1.203    36.750     0.150
     1.238    22.125     0.150
     1.269    20.641     0.150
     1.269    36.547     0.150
     1.303    20.711     0.150
     1.303    39.047     0.150
     1.364    24.625     0.150
     1.364    24.164     0.150
     1.358    23.469     0.150
     1.415    25.094     0.150
     1.482    23.508     0.150
     1.561    24.680     0.150
     1.561    46.984     0.150
     1.586    24.938     0.150
     1.586    24.836     0.150
     1.645    26.289     0.150
     1.645    50.234     0.150
     1.722    26.766     0.150
     1.760    27.227     0.150
     1.849    28.289     0.150
     1.849    33.062     0.150
     2.026    31.633     0.150
     2.026    60.234     0.150
     2.032    31.383     0.150
     2.032    34.906     0.150
     2.116    37.766     0.150
     2.110    32.078     0.150
     2.163    32.992     0.150
     2.163    64.258     0.150
     2.492    44.891     0.150
     2.567    38.430     0.150
     2.679    42.039     0.150
     2.679    53.117     0.150
     2.979    46.648     0.150
     2.998    44.797     0.150
     2.998    51.141     0.150
     3.177    57.469     0.150
     3.235    47.891     0.150
     3.253    48.758     0.150
     3.253    60.055     0.150
     3.253   104.953     0.150
     3.268    49.180     0.150
     3.268    55.453     0.150
     3.338    49.047     0.150
     3.340    48.719     0.150
     3.490    51.039     0.150
     3.604    52.750     0.150
     3.653    57.398     0.150
     3.688    53.852     0.150
     3.688    62.406     0.150
     3.723    63.172     0.150
     3.776    55.539     0.150
     3.812    55.281     0.150
     3.810    55.719     0.150
     3.917    57.641     0.150
     4.070    58.961     0.150
     4.102    61.758     0.150
     4.148    61.250     0.150
     4.190    60.898     0.150
     4.262    62.641     0.150
     4.428    65.016     0.150
     4.444    64.227     0.150
     4.464    65.367     0.150
     4.478    67.883     0.150
     4.569    66.984     0.150
     4.902    72.867     0.150
     4.984    74.422     0.150
     5.030    72.422     0.150
     5.112    75.406     0.150
     5.180    77.891     0.150
     5.174    74.992     0.150
     5.260    77.812     0.150
     5.333    78.273     0.150
     5.371    80.406     0.150
     5.377    78.625     0.150
     5.719    82.648     0.150
     6.307    90.328     0.150
     6.439    94.422     0.150
     6.473    95.914     0.150
     6.547    96.250     0.150
     7.148   104.062     0.150
     7.339   108.648     0.150
     7.339   108.172     0.150
     7.426   108.477     0.150
     7.721   113.375     0.150
     7.755   113.797     0.150
     7.967   117.398     0.150
     8.145   118.203     0.150
     8.402   120.273     0.150
     8.443   122.367     0.150
     8.990   132.086     0.150
     9.653   138.914     0.150
    10.407   149.609     0.150
    10.407   330.633     0.150
    11.290   214.359     0.150
    98.030   815.953     0.150
     0.198     2.599     0.150
     0.198     5.419     0.150
     0.248     4.979     0.150
     0.248     8.949     0.150
     0.535     9.749     0.150
     0.586    11.119     0.150
     0.586    22.019     0.150
     0.649    11.608     0.150
     0.667    11.989     0.150
     0.705    12.929     0.150
     0.729    13.039     0.150
     0.753    13.269     0.150
     0.788    14.559     0.150
     0.788    25.419     0.150
     0.935    15.528     0.150
     0.935    28.389     0.150
     1.122    20.379     0.150
     1.122    35.849     0.150
     1.213    21.419     0.150
     1.213    37.019     0.150
     1.177    21.289     0.150
     1.177    38.079     0.150
     1.206    21.889     0.150
     1.206    21.369     0.150
     1.206    37.349     0.150
     1.206    38.799     0.150
     1.268    22.729     0.150
     1.268    40.289     0.150
     1.674    26.309     0.150
     2.856    44.769     0.150
     2.856    55.849     0.150
     2.856    94.358     0.150
     3.027    47.679     0.150
     3.027    56.499     0.150
     3.027    92.239     0.150
     3.075    54.789     0.150
     3.075    93.299     0.150
     3.305    51.699     0.150
     3.305    64.129     0.150
     3.863    57.159     0.150
     3.863    69.568     0.150
     4.307    65.818     0.150
     4.307    78.459     0.150
     4.659    70.789     0.150
     4.659    88.509     0.150
     5.560    82.699     0.150
     5.560   106.099     0.150
     6.649   123.034     0.150
     6.788   103.209     0.150
     6.788   128.608     0.150
     6.788   215.979     0.150
     7.204   105.278     0.150
     7.278   106.528     0.150
     7.517   110.969     0.150
     7.517   236.329     0.150
     7.555   109.869     0.150
     7.588   110.679     0.150
     7.897   114.733     0.150
     7.897   249.934     0.150
     7.913   115.438     0.150
     8.094   118.429     0.150
     8.098   119.629     0.150
     8.480   121.749     0.150
     8.480   216.358     0.150
     8.507   160.134     0.150
     8.507   268.659     0.150
     9.773   142.479     0.150
    10.447   150.559     0.150
    11.481   168.024     0.150
    23.062   305.089     0.150
     0.060     2.734     0.150
     0.480     8.852     0.150
     0.508     9.391     0.150
     0.514     9.891     0.150
     0.601    10.570     0.150
     0.601    18.992     0.150
     0.619    11.352     0.150
     0.623    11.312     0.150
     0.635    10.984     0.150
     0.724    13.891     0.150
     0.724    24.883     0.150
     0.728    13.305     0.150
     0.728    25.094     0.150
     0.732    12.547     0.150
     0.732    23.508     0.150
     0.765    14.125     0.150
     0.774    13.078     0.150
     0.774    23.703     0.150
     0.789    13.898     0.150
     1.109    19.094     0.150
     1.109    33.484     0.150
     1.187    21.891     0.150
     1.187    37.109     0.150
     1.230    21.242     0.150
     1.230    37.641     0.150
     1.288    23.102     0.150
     1.293    21.008     0.150
     1.293    37.102     0.150
     1.325    21.648     0.150
     1.337    24.055     0.150
     1.330    23.570     0.150
     1.330    41.633     0.150
     1.330    45.312     0.150
     1.390    24.773     0.150
     1.512    23.969     0.150
     1.587    25.344     0.150
     1.587    48.250     0.150
     1.596    25.133     0.150
     1.596    24.961     0.150
     1.639    27.023     0.150
     1.639    50.086     0.150
     1.741    27.266     0.150
     1.787    27.906     0.150
     1.879    29.383     0.150
     1.879    56.969     0.150
     2.046    31.812     0.150
     2.046    61.500     0.150
     2.120    32.375     0.150
     2.146    33.102     0.150
     2.146    64.438     0.150
     2.188    33.742     0.150
     2.188    65.203     0.150
     2.433    37.109     0.150
     2.453    37.656     0.150
     2.458    37.914     0.150
     2.522    38.516     0.150
     2.585    39.469     0.150
     2.613    39.680     0.150
     2.706    42.242     0.150
     2.771    42.172     0.150
     2.922    43.695     0.150
     2.984    45.711     0.150
     3.037    53.508     0.150
     3.109    46.500     0.150
     3.195    48.602     0.150
     3.247    48.344     0.150
     3.367    50.266     0.150
     3.371    50.234     0.150
     3.464    52.383     0.150
     3.515    52.492     0.150
     3.634    55.258     0.150
     3.658    54.070     0.150
     3.658    67.422     0.150
     3.718    56.273     0.150
     3.791    55.789     0.150
     3.791   118.664     0.150
     3.795    56.898     0.150
     3.821    56.516     0.150
     3.829    57.016     0.150
     3.940    58.023     0.150
     4.128    62.102     0.150
     4.128    78.281     0.150
     4.128   130.320     0.150
     4.138    61.828     0.150
     4.177    62.664     0.150
     4.215    63.375     0.150
     4.232    63.484     0.150
     4.232    77.094     0.150
     4.292    64.945     0.150
     4.392    66.023     0.150
     4.441    65.367     0.150
     4.507    67.742     0.150
     4.507    82.391     0.150
     4.507   139.281     0.150
     4.579    67.203     0.150
     4.609    68.477     0.150
     4.736    70.742     0.150
     4.861    72.383     0.150
     5.104    74.156     0.150
     5.184    75.766     0.150
     5.210    77.539     0.150
     5.283    78.305     0.150
     5.400    80.805     0.150
     5.400    95.570     0.150
     5.607    81.562     0.150
     5.610    82.945     0.150
     5.610   105.508     0.150
     6.627   123.008     0.150
     6.726   116.234     0.150
     7.005   101.453     0.150
     7.005   130.312     0.150
     7.038   102.508     0.150
     7.038   129.539     0.150
     7.038   222.273     0.150
     7.091   103.398     0.150
     7.170   104.672     0.150
     7.367   109.148     0.150
     7.367   140.023     0.150
     7.367   232.984     0.150
     7.448   108.078     0.150
     7.478   108.805     0.150
     7.656   111.391     0.150
     7.656   144.031     0.150
     7.656   243.422     0.150
     7.778   113.078     0.150
     7.778   242.148     0.150
     7.778   113.883     0.150
     7.820   150.945     0.150
     7.939   116.383     0.150
     7.939   146.328     0.150
     7.939   246.375     0.150
     7.941   117.734     0.150
     7.941   146.211     0.150
     7.997   114.258     0.150
     7.997   150.758     0.150
     8.057   152.953     0.150
     8.416   120.891     0.150
     8.416   215.555     0.150
     8.652   128.133     0.150
     8.726   127.773     0.150
     8.771   129.773     0.150
     9.203   136.844     0.150
     9.229   134.062     0.150
     9.563   140.805     0.150
     9.601   140.203     0.150
     9.631   139.758     0.150
     9.635   136.203     0.150
     9.682   142.633     0.150
    10.415   150.102     0.150
    10.762   157.352     0.150
    11.196   165.750     0.150
    11.320   161.758     0.150
    11.320   165.852     0.150
    11.320   361.180     0.150
    11.393   166.461     0.150
    11.513   168.250     0.150
    11.597   165.133     0.150
    11.611   169.422     0.150
    11.631   169.133     0.150
    11.809   171.734     0.150
    11.903   170.273     0.150
    12.000   174.602     0.150
    12.230   177.680     0.150
    12.582   184.875     0.150
    12.823   188.008     0.150
    13.139   192.242     0.150
    13.145   192.211     0.150
    13.339   191.750     0.150
    13.506   195.273     0.150
    13.561   194.664     0.150
    13.610   197.164     0.150
    13.852   200.195     0.150
    13.949   199.023     0.150
    14.386   207.672     0.150
    14.398   208.820     0.150
    14.478   207.383     0.150
    14.609   215.594     0.150
    14.662   209.469     0.150
    15.154   219.125     0.150
    15.215   218.508     0.150
    15.233   217.773     0.150
    15.379   219.555     0.150
    15.470   221.109     0.150
    15.700   225.641     0.150
    15.894   224.953     0.150
    15.941   226.992     0.150
    16.186   228.883     0.150
    16.233   223.305     0.150
    16.377   233.172     0.150
    16.556   235.500     0.150
    16.594   231.805     0.150
    16.704   236.258     0.150
    16.807   237.695     0.150
    17.397   246.914     0.150
    17.476   245.695     0.150
    18.125   250.859     0.150
    18.225   252.750     0.150
    18.514   255.680     0.150
    20.888   282.109     0.150
    20.912   284.570     0.150
    21.033   284.312     0.150
    21.628   290.195     0.150
    22.932   304.500     0.150
    22.954   304.922     0.150
    23.892   315.750     0.150
    24.310   317.719     0.150
    27.926   353.273     0.150
    27.926   352.844     0.150
    30.144   371.047     0.150
    35.935   423.273     0.150
    36.138   424.211     0.150
    37.298   434.773     0.150
    37.497   435.852     0.150
    37.497   435.508     0.150
    37.767   438.320     0.150
    37.795   438.750     0.150
    38.420   443.812     0.150
    38.704   445.750     0.150
    39.909   455.695     0.150
    47.180   514.828     0.150
    77.258   715.555     0.150
    81.390   738.070     0.150
    83.332   743.305     0.150
    86.118   758.500     0.150
    86.118  1389.203     0.150
    86.392   761.391     0.150
    86.610   762.445     0.150
    86.795   763.211     0.150
    88.952   776.805     0.150
    91.850   789.398     0.150
    92.297   791.273     0.150
    93.646   792.703     0.150
    95.285   801.602     0.150
    95.285  1032.898     0.150
    95.285  1437.305     0.150
    95.285  1474.102     0.150
    95.285  1862.703     0.150
   102.678   834.102     0.150
   102.678   844.305     0.150
   102.678  1088.898     0.150
   125.291  1137.898     0.150
   126.054  1139.703     0.150
   144.709  1175.961     0.150
   145.040  1178.273     0.150
   145.905  1180.602     0.150
     0.059     1.383     0.150
     0.139     3.430     0.150
     0.139     7.047     0.150
     0.162     4.250     0.150
     0.388     7.141     0.150
     0.463     8.883     0.150
     0.507     9.344     0.150
     0.527     9.547     0.150
     0.538     9.781     0.150
     0.652    11.203     0.150
     0.652    20.219     0.150
     0.668    12.375     0.150
     0.668    21.664     0.150
     0.676    12.984     0.150
     0.676    22.164     0.150
     0.715    12.375     0.150
     0.795    13.398     0.150
     0.795    23.812     0.150
     0.795    12.914     0.150
     0.965    15.805     0.150
     0.965    30.195     0.150
     1.013    17.594     0.150
     1.013    31.164     0.150
     1.097    20.062     0.150
     1.097    34.820     0.150
     1.253    20.367     0.150
     1.253    35.562     0.150
     1.279    23.297     0.150
     1.279    22.133     0.150
     1.324    23.805     0.150
     1.324    41.891     0.150
     1.354    23.797     0.150
     1.354    43.773     0.150
     1.354    44.000     0.150
     1.403    22.648     0.150
     1.403    39.500     0.150
     1.514    24.125     0.150
     1.514    42.219     0.150
     1.514    23.992     0.150
     1.522    24.086     0.150
     1.522    45.711     0.150
     1.541    25.594     0.150
     1.541    47.508     0.150
     1.649    25.945     0.150
     1.649    46.859     0.150
     1.680    26.375     0.150
     1.762    27.719     0.150
     1.944    30.500     0.150
     1.944    59.656     0.150
     2.130    33.141     0.150
     2.130    64.055     0.150
     2.159    33.203     0.150
     2.216    33.672     0.150
     2.255    34.398     0.150
     2.265    35.641     0.150
     2.389    36.562     0.150
     2.443    37.492     0.150
     2.508    38.383     0.150
     2.552    39.164     0.150
     2.651    40.781     0.150
     2.651    79.992     0.150
     2.679    41.977     0.150
     2.672    40.602     0.150
     2.739    41.852     0.150
     2.748    41.797     0.150
     2.748    82.305     0.150
     2.781    47.844     0.150
     2.781    85.336     0.150
     2.846    42.680     0.150
     2.846    77.828     0.150
     2.892    43.367     0.150
     2.962    44.414     0.150
     2.981    44.930     0.150
     3.062    45.906     0.150
     3.092    46.758     0.150
     3.092    93.680     0.150
     3.104    45.984     0.150
     3.130    47.109     0.150
     3.302    49.727     0.150
     3.302    99.664     0.150
     3.342    49.164     0.150
     3.533    52.406     0.150
     3.533   106.523     0.150
     3.566    52.961     0.150
     3.566    54.125     0.150
     3.584    53.219     0.150
     3.584   107.922     0.150
     3.622    53.945     0.150
     3.854    57.945     0.150
     3.883    56.172     0.150
     3.918    57.242     0.150
     3.916    57.195     0.150
     3.961    59.125     0.150
     4.015    59.172     0.150
     4.048    59.758     0.150
     4.150    61.242     0.150
     4.150    61.547     0.150
     4.177    62.164     0.150
     4.219    62.383     0.150
     4.239    73.289     0.150
     4.280    63.758     0.150
     4.320    65.070     0.150
     4.459    66.461     0.150
     4.549    68.500     0.150
     4.549    69.070     0.150
     4.535    66.016     0.150
     4.547    67.109     0.150
     4.675    68.164     0.150
     4.686    68.961     0.150
     4.821    70.867     0.150
     4.977    74.195     0.150
     5.003    74.547     0.150
     5.124    77.133     0.150
     5.136    75.070     0.150
     5.197    75.133     0.150
     5.215    76.781     0.150
     5.280    76.703     0.150
     5.359    79.258     0.150
     5.396    80.344     0.150
     5.420    80.953     0.150
     5.594    88.375     0.150
     5.592    84.031     0.150
     5.603    83.047     0.150
     5.670    83.828     0.150
     5.697    82.789     0.150
     5.755    84.344     0.150
     5.826    84.914     0.150
     5.879    86.695     0.150
     5.930    88.219     0.150
     5.937    87.414     0.150
     6.056    89.109     0.150
     6.128    90.633     0.150
     6.145    91.016     0.150
     6.203    92.000     0.150
     6.335    93.445     0.150
     6.407    94.836     0.150
     6.428    95.336     0.150
     6.413    93.094     0.150
     6.448    93.523     0.150
     6.540    96.641     0.150
     6.543    95.680     0.150
     6.631    98.453     0.150
     6.636    96.234     0.150
     6.648    97.578     0.150
     6.655    98.531     0.150
     6.662    97.750     0.150
     6.674    98.836     0.150
     6.875   102.125     0.150
     6.912   102.477     0.150
     6.958   101.883     0.150
     7.074   102.930     0.150
     7.107   104.633     0.150
     7.128   103.508     0.150
     7.168   104.812     0.150
     7.213   104.711     0.150
     7.249   105.484     0.150
     7.257   106.656     0.150
     7.274   106.711     0.150
     7.345   108.508     0.150
     7.413   109.250     0.150
     7.413   109.742     0.150
     7.459   110.367     0.150
     7.527   109.594     0.150
     7.533   111.031     0.150
     7.556   109.531     0.150
     7.665   112.742     0.150
     7.710   113.125     0.150
     7.697   110.836     0.150
     7.740   112.156     0.150
     7.750   113.484     0.150
     7.767   113.266     0.150
     7.767   112.742     0.150
     7.839   114.617     0.150
     7.852   113.352     0.150
     7.852   113.227     0.150
     7.893   115.352     0.150
     7.912   114.500     0.150
     7.926   115.930     0.150
     7.959   114.391     0.150
     7.974   117.820     0.150
     7.976   116.766     0.150
     7.973   115.867     0.150
     7.993   117.125     0.150
     8.047   118.344     0.150
     8.047   120.633     0.150
     8.079   118.383     0.150
     8.123   119.516     0.150
     8.134   119.305     0.150
     8.152   120.273     0.150
     8.155   119.062     0.150
     8.176   122.711     0.150
     8.204   118.430     0.150
     8.212   120.242     0.150
     8.320   120.531     0.150
     8.352   120.859     0.150
     8.350   119.375     0.150
     8.391   123.133     0.150
     8.378   119.898     0.150
     8.460   121.055     0.150
     8.468   121.648     0.150
     8.539   124.484     0.150
     8.576   124.734     0.150
     8.628   127.758     0.150
     8.655   128.016     0.150
     8.709   127.867     0.150
     8.713   126.750     0.150
     8.728   128.484     0.150
     8.752   126.750     0.150
     8.771   127.523     0.150
     8.798   128.102     0.150
     8.878   129.414     0.150
     8.903   128.133     0.150
     8.939   128.891     0.150
     8.960   132.242     0.150
     8.966   130.539     0.150
     9.011   131.039     0.150
     9.008   130.664     0.150
     9.004   132.008     0.150
     9.025   132.680     0.150
     9.038   133.109     0.150
     9.063   132.688     0.150
     9.081   130.797     0.150
     9.195   133.375     0.150
     9.269   136.672     0.150
     9.342   137.359     0.150
     9.430   138.367     0.150
     9.503   137.266     0.150
     9.552   137.719     0.150
     9.553   138.094     0.150
     9.587   138.523     0.150
     9.588   137.953     0.150
     9.601   140.516     0.150
     9.624   139.609     0.150
     9.625   138.383     0.150
     9.678   141.961     0.150
     9.685   140.719     0.150
     9.702   141.273     0.150
     9.764   140.898     0.150
     9.750   140.336     0.150
     9.804   143.477     0.150
     9.825   142.570     0.150
     9.832   143.055     0.150
     9.833   141.383     0.150
     9.876   143.797     0.150
     9.892   142.539     0.150
     9.896   144.867     0.150
     9.936   145.484     0.150
    10.006   145.414     0.150
    10.067   145.992     0.150
    10.055   144.633     0.150
    10.096   147.453     0.150
    10.111   146.656     0.150
    10.146   145.852     0.150
    10.167   147.844     0.150
    10.177   149.133     0.150
    10.202   148.977     0.150
    10.275   149.055     0.150
    10.267   148.859     0.150
    10.321   151.023     0.150
    10.311   145.906     0.150
    10.322   147.891     0.150
    10.354   150.914     0.150
    10.342   151.375     0.150
    10.386   151.203     0.150
    10.397   152.188     0.150
    10.398   153.133     0.150
    10.412   154.086     0.150
    10.456   152.375     0.150
    10.488   151.727     0.150
    10.516   153.297     0.150
    10.512   150.797     0.150
    10.578   153.758     0.150
    10.588   152.492     0.150
    10.674   155.062     0.150
    10.701   153.773     0.150
    10.728   154.297     0.150
    10.799   157.680     0.150
    10.802   157.961     0.150
    10.802   156.930     0.150
    10.884   158.992     0.150
    10.899   159.117     0.150
    10.916   159.398     0.150
    10.951   157.141     0.150
    11.002   160.523     0.150
    11.002   161.883     0.150
    11.002   160.977     0.150
    10.995   158.391     0.150
    11.019   159.961     0.150
    11.023   160.062     0.150
    11.056   158.961     0.150
    11.104   158.641     0.150
    11.169   162.945     0.150
    11.192   161.852     0.150
    11.222   161.812     0.150
    11.252   162.391     0.150
    11.324   165.562     0.150
    11.324   162.875     0.150
    11.359   165.039     0.150
    11.377   165.938     0.150
    11.385   166.352     0.150
    11.508   167.266     0.150
    11.537   167.469     0.150
    11.588   167.719     0.150
    11.605   168.945     0.150
    11.607   169.227     0.150
    11.615   167.797     0.150
    11.654   167.875     0.150
    11.804   170.547     0.150
    11.855   170.844     0.150
    11.898   169.586     0.150
    11.935   170.523     0.150
    11.956   171.430     0.150
    11.993   174.305     0.150
    12.100   175.398     0.150
    12.104   176.820     0.150
    12.136   176.320     0.150
    12.176   178.086     0.150
    12.224   177.016     0.150
    12.297   179.078     0.150
    12.373   178.344     0.150
    12.400   177.953     0.150
    12.543   178.891     0.150
    12.584   180.766     0.150
    12.698   182.578     0.150
    12.704   184.266     0.150
    12.709   184.781     0.150
    12.722   183.133     0.150
    12.767   184.625     0.150
    12.942   184.297     0.150
    13.033   185.172     0.150
    13.039   188.234     0.150
    13.040   187.164     0.150
    13.224   189.219     0.150
    13.337   193.148     0.150
    13.365   192.602     0.150
    13.393   192.250     0.150
    13.394   192.641     0.150
    13.425   192.203     0.150
    13.433   189.953     0.150
    13.433   193.281     0.150
    13.452   193.766     0.150
    13.482   194.219     0.150
    13.492   195.359     0.150
    13.492   195.172     0.150
    13.559   195.070     0.150
    13.559   195.281     0.150
    13.591   196.977     0.150
    13.604   195.023     0.150
    13.662   194.820     0.150
    13.954   198.531     0.150
    13.968   200.945     0.150
    14.052   202.242     0.150
    14.071   202.055     0.150
    14.162   203.883     0.150
    14.255   204.891     0.150
    14.335   207.477     0.150
    14.347   205.852     0.150
    14.397   203.500     0.150
    14.452   206.836     0.150
    14.452   204.117     0.150
    14.498   206.367     0.150
    14.552   208.133     0.150
    14.586   209.102     0.150
    14.685   207.906     0.150
    14.692   210.547     0.150
    14.732   209.586     0.150
    14.754   209.945     0.150
    14.784   211.500     0.150
    14.841   211.352     0.150
    14.892   212.164     0.150
    14.901   213.414     0.150
    14.926   211.523     0.150
    14.933   212.812     0.150
    15.127   215.016     0.150
    15.143   214.961     0.150
    15.162   216.586     0.150
    15.187   216.453     0.150
    15.273   216.500     0.150
    15.499   219.797     0.150
    15.557   219.766     0.150
    15.613   221.820     0.150
    15.679   221.523     0.150
    15.778   222.891     0.150
    15.900   224.680     0.150
    15.900   223.102     0.150
    15.901   223.820     0.150
    15.901   226.062     0.150
    16.021   225.070     0.150
    16.036   225.023     0.150
    16.052   225.305     0.150
    16.052   229.492     0.150
    16.061   225.438     0.150
    16.232   229.172     0.150
    16.318   229.180     0.150
    16.517   231.633     0.150
    16.526   233.234     0.150
    16.531   232.812     0.150
    16.619   232.859     0.150
    16.620   234.156     0.150
    16.670   234.844     0.150
    16.677   235.891     0.150
    16.678   235.039     0.150
    16.755   233.375     0.150
    16.896   238.125     0.150
    16.945   236.781     0.150
    17.389   242.281     0.150
    17.392   242.234     0.150
    17.747   246.867     0.150
    18.033   251.180     0.150
    18.133   252.320     0.150
    18.133   248.086     0.150
    18.307   252.984     0.150
    18.559   257.281     0.150
    20.999   285.875     0.150
    21.657   290.703     0.150
    22.955   303.102     0.150
    23.986   314.500     0.150
    31.392   383.195     0.150
    35.653   417.523     0.150
    37.448   434.898     0.150
    37.731   436.422     0.150
    47.274   514.570     0.150
    52.782   557.773     0.150
    55.516   576.023     0.150
    55.991   578.523     0.150
    66.238   649.195     0.150
    86.034   758.523     0.150
    86.034   959.320     0.150
    86.034  1391.125     0.150
    89.567   779.023     0.150
    92.246   790.547     0.150
    93.565   793.922     0.150
    95.207   801.320     0.150
    95.207  1032.625     0.150
    95.207  1434.820     0.150
    95.207  1472.820     0.150
    95.207  1480.320     0.150
    95.207  1860.422     0.150
    97.951   813.820     0.150
   101.274   830.820     0.150
   109.083   863.023     0.150
   109.083  1106.820     0.150
   109.083  1138.422     0.150
   109.083  2053.523     0.150
   112.223  1114.320     0.150
   119.165  1131.297     0.150
   144.744  1175.664     0.150
   144.744  1175.523     0.150
   145.130  1177.703     0.150
   145.998  1180.875     0.150
     0.209     4.031     0.150
     0.329     6.592     0.150
     0.358     6.820     0.150
     0.362     6.582     0.150
     0.463     8.801     0.150
     0.481     9.031     0.150
     0.481    15.660     0.150
     0.517     9.512     0.150
     0.708    13.301     0.150
     0.708    22.682     0.150
     0.773    12.951     0.150
     0.773    23.410     0.150
     0.987    17.701     0.150
     0.987    30.801     0.150
     0.997    18.381     0.150
     0.997    31.531     0.150
     1.272    23.070     0.150
     1.272    21.592     0.150
     1.299    23.400     0.150
     1.332    21.672     0.150
     1.332    38.051     0.150
     2.555    40.092     0.150
     2.712    42.441     0.150
     2.712    83.371     0.150
     2.765    82.711     0.150
     3.386    50.871     0.150
     3.967    57.922     0.150
     4.006    58.332     0.150
     4.543    68.512     0.150
     5.417    80.281     0.150
     6.302   205.396     0.150
     6.454    94.121     0.150
     6.777    97.701     0.150
     7.328   106.711     0.150
     7.574   109.082     0.150
     7.608   110.391     0.150
     7.608   194.852     0.150
     7.633   110.842     0.150
     7.633   197.160     0.150
     7.916   115.121     0.150
     7.916   114.201     0.150
     8.635   123.400     0.150
     9.438   240.111     0.150
     9.819   250.582     0.150
     9.842   140.381     0.150
    10.662   152.471     0.150
    10.662   269.422     0.150
    24.164   314.820     0.150
    37.559   435.121     0.150
    95.025   798.871     0.150
    95.025  1030.172     0.150
    95.025  1430.871     0.150
    95.025  1468.871     0.150
    95.025  1481.871     0.150
    95.025  1855.871     0.150
    97.768   812.172     0.150
   101.108   828.371     0.150
   102.422   833.871     0.150
   102.422   838.871     0.150
   102.422   841.172     0.150
     0.085     1.466     0.150
     0.535     9.836     0.150
     0.498     9.065     0.150
     0.541    10.176     0.150
     0.643    11.365     0.150
     0.675    11.636     0.150
     0.641    11.716     0.150
     0.799    13.516     0.150
     0.799    23.855     0.150
     0.799    24.319     0.150
     0.755    12.933     0.150
     0.755    23.532     0.150
     0.708    13.405     0.150
     0.708    23.596     0.150
     0.776    14.339     0.150
     0.776    24.767     0.150
     0.808    14.186     0.150
     1.123    19.375     0.150
     1.123    34.690     0.150
     1.187    21.325     0.150
     1.187    37.556     0.150
     1.238    21.336     0.150
     1.238    38.485     0.150
     1.333    21.840     0.150
     1.333    39.505     0.150
     1.321    21.437     0.150
     1.302    22.836     0.150
     1.323    23.706     0.150
     1.323    22.985     0.150
     1.378    24.405     0.150
     1.537    24.429     0.150
     1.537    46.832     0.150
     1.619    25.315     0.150
     1.767    27.684     0.150
     1.815    28.540     0.150
     1.815    56.056     0.150
     2.054    32.216     0.150
     2.054    63.483     0.150
     2.114    32.349     0.150
     2.171    65.604     0.150
     2.201    34.133     0.150
     2.460    37.652     0.150
     2.734    43.105     0.150
     2.734    51.246     0.150
     2.734    74.235     0.150
     2.759    42.307     0.150
     2.856    85.728     0.150
     2.891    87.611     0.150
     2.981    90.858     0.150
     3.002    46.436     0.150
     3.002    55.056     0.150
     3.002    93.796     0.150
     3.055    48.195     0.150
     3.055    56.306     0.150
     3.055    92.855     0.150
     3.221    59.416     0.150
     3.791    55.796     0.150
     3.791    70.046     0.150
     3.791   116.386     0.150
     4.254    64.956     0.150
     4.254    77.586     0.150
     4.254   130.376     0.150
     4.526    68.306     0.150
     4.526    83.626     0.150
     4.526   141.785     0.150
     5.427    81.275     0.150
     5.427   101.256     0.150
     5.637    83.905     0.150
     5.637   105.785     0.150
     5.637   175.636     0.150
     5.690   107.785     0.150
     6.521    97.046     0.150
     6.521   123.775     0.150
     6.634   123.785     0.150
     6.653   101.445     0.150
     6.653   122.445     0.150
     6.653   207.466     0.150
     7.100   104.436     0.150
     7.100   126.766     0.150
     7.178   104.855     0.150
     7.386   108.996     0.150
     7.386   229.405     0.150
     7.455   108.476     0.150
     7.486   109.115     0.150
     7.682   114.605     0.150
     7.776   116.206     0.150
     7.788   113.766     0.150
     7.788   144.086     0.150
     7.788   199.166     0.150
     7.788   241.836     0.150
     7.788   113.166     0.150
     8.084   119.105     0.150
     8.201   153.325     0.150
     8.228   154.285     0.150
     8.388   121.666     0.150
     8.388   158.315     0.150
     8.414   120.806     0.150
     8.797   126.115     0.150
     8.797   161.716     0.150
     9.230   132.815     0.150
     9.583   139.785     0.150
     9.636   139.905     0.150
    10.408   149.945     0.150
    10.408   265.726     0.150
    10.408   326.436     0.150
    10.782   157.586     0.150
    11.224   164.896     0.150
    11.224   353.746     0.150
    11.346   161.355     0.150
    11.346   164.666     0.150
    11.346   358.136     0.150
    11.420   168.105     0.150
    11.605   169.386     0.150
    11.638   170.706     0.150
    11.930   174.596     0.150
    13.955   200.306     0.150
    14.637   207.456     0.150
    14.685   208.096     0.150
    14.945   212.775     0.150
    15.497   217.905     0.150
    15.969   224.865     0.150
    15.969   228.690     0.150
    16.569   236.155     0.150
    16.804   235.646     0.150
    18.230   254.006     0.150
    22.962   303.766     0.150
    30.172   370.315     0.150
    30.172   551.666     0.150
    37.821   438.266     0.150
    47.163   513.735     0.150
    56.086   581.046     0.150
    81.416   737.746     0.150
    91.875   790.646     0.150
    92.325   790.686     0.150
     0.265     5.457     0.150
     0.265     9.289     0.150
     0.464     7.660     0.150
     0.534     9.570     0.150
     0.559     9.848     0.150
     0.629    11.797     0.150
     0.632    11.387     0.150
     0.632    19.422     0.150
     0.643    11.887     0.150
     0.799    14.520     0.150
     0.831    14.848     0.150
     0.825    15.297     0.150
     0.825    26.699     0.150
     0.839    15.918     0.150
     0.901    15.828     0.150
     0.876    16.500     0.150
     0.876    15.918     0.150
     0.876    28.449     0.150
     0.904    16.559     0.150
     0.933    17.430     0.150
     0.977    17.605     0.150
     0.977    30.371     0.150
     0.984    17.629     0.150
     0.984    30.117     0.150
     1.037    17.969     0.150
     1.088    20.078     0.150
     1.088    35.359     0.150
     1.200    20.148     0.150
     1.200    35.648     0.150
     1.200    19.992     0.150
     1.200    34.473     0.150
     1.403    24.461     0.150
     1.403    42.586     0.150
     1.553    25.453     0.150
     1.618    26.379     0.150
     1.775    28.434     0.150
     1.896    30.609     0.150
     1.916    30.426     0.150
     1.934    33.680     0.150
     2.610    41.148     0.150
     2.648    40.793     0.150
     2.671    46.117     0.150
     2.671    80.551     0.150
     2.877    49.508     0.150
     2.877    88.699     0.150
     2.914    48.348     0.150
     2.914    89.457     0.150
     3.000    47.867     0.150
     3.059    52.590     0.150
     3.059    92.555     0.150
     3.306    51.047     0.150
     3.306    60.859     0.150
     3.351    58.949     0.150
     3.541    56.699     0.150
     3.541    99.500     0.150
     3.541    61.527     0.150
     4.187    61.500     0.150
     4.216    64.168     0.150
     4.216   131.180     0.150
     4.959    75.797     0.150
     5.759    86.258     0.150
     5.962    89.699     0.150
     6.626    98.527     0.150
     6.646    99.910     0.150
     6.989   103.938     0.150
     7.009   107.238     0.150
     7.037   106.477     0.150
     7.539   111.270     0.150
     7.614   111.809     0.150
     7.823   115.938     0.150
     7.890   115.988     0.150
     8.161   121.539     0.150
     8.232   118.820     0.150
     9.627   139.609     0.150
    10.011   147.559     0.150
    10.735   154.340     0.150
    10.735   271.629     0.150
    10.735   341.430     0.150
    11.702   170.238     0.150
    14.759   209.430     0.150
    23.356   309.348     0.150
    30.403   373.250     0.150
    37.891   439.020     0.150
    95.280   801.898     0.150
    95.280   802.699     0.150
    95.280  1032.898     0.150
    95.280  1437.098     0.150
    95.280  1474.398     0.150
    95.280  1475.500     0.150
    95.280  1863.500     0.150
   101.462   831.598     0.150
     0.046     0.922     0.150
     0.082     5.594     0.150
     0.086     1.992     0.150
     0.086     5.633     0.150
     0.119     2.555     0.150
     0.119     6.555     0.150
     0.444     8.422     0.150
     0.461     8.328     0.150
     0.499     8.484     0.150
     0.499    15.914     0.150
     0.487     9.266     0.150
     0.507     9.406     0.150
     0.602    10.984     0.150
     0.603    10.859     0.150
     0.639    11.344     0.150
     0.716    12.344     0.150
     0.716    22.547     0.150
     0.707    12.945     0.150
     0.707    23.047     0.150
     0.707    23.617     0.150
     0.712    13.125     0.150
     0.744    13.688     0.150
     0.744    23.953     0.150
     0.779    13.336     0.150
     0.779    13.211     0.150
     0.779    23.375     0.150
     0.770    13.555     0.150
     0.791    13.797     0.150
     0.868    15.227     0.150
     0.969    16.922     0.150
     1.089    18.711     0.150
     1.089    33.734     0.150
     1.089    18.711     0.150
     1.089    33.734     0.150
     1.178    18.922     0.150
     1.167    21.109     0.150
     1.167    36.906     0.150
     1.199    21.469     0.150
     1.199    38.086     0.150
     1.210    21.438     0.150
     1.210    37.719     0.150
     1.286    21.000     0.150
     1.342    21.852     0.150
     1.342    38.875     0.150
     1.323    23.695     0.150
     1.333    23.117     0.150
     1.333    41.383     0.150
     1.333    22.875     0.150
     1.333    43.367     0.150
     1.390    21.953     0.150
     1.375    24.273     0.150
     1.413    23.625     0.150
     1.515    24.102     0.150
     1.528    25.883     0.150
     1.573    25.258     0.150
     1.580    25.219     0.150
     1.580    45.547     0.150
     1.580    25.016     0.150
     1.620    26.023     0.150
     1.618    26.688     0.150
     1.618    49.938     0.150
     1.641    26.398     0.150
     1.647    26.664     0.150
     1.703    27.188     0.150
     1.729    27.117     0.150
     1.783    28.102     0.150
     1.842    28.883     0.150
     1.923    30.188     0.150
     1.923    36.242     0.150
     1.927    30.406     0.150
     2.017    31.672     0.150
     2.140    32.445     0.150
     2.150    33.375     0.150
     2.150    64.758     0.150
     2.203    34.062     0.150
     2.425    37.273     0.150
     2.425    37.156     0.150
     2.469    38.320     0.150
     2.601    39.508     0.150
     2.721    41.758     0.150
     2.724    42.172     0.150
     2.825    85.461     0.150
     2.857    49.602     0.150
     2.857    86.039     0.150
     2.965    47.648     0.150
     2.965    52.922     0.150
     3.018    46.273     0.150
     3.018    85.266     0.150
     3.100    46.602     0.150
     3.166    96.734     0.150
     3.182    48.148     0.150
     3.182    59.758     0.150
     3.370    57.586     0.150
     3.611    53.656     0.150
     3.808    57.469     0.150
     3.811    55.266     0.150
     4.031    60.164     0.150
     4.103    60.500     0.150
     4.123    61.586     0.150
     4.123    77.906     0.150
     4.123    61.172     0.150
     4.215    62.617     0.150
     4.215    62.281     0.150
     4.517    68.188     0.150
     4.533    68.195     0.150
     4.742    71.109     0.150
     4.952    73.422     0.150
     5.205    75.750     0.150
     5.237    77.359     0.150
     5.237   939.016     0.150
     5.373    80.484     0.150
     5.373    80.164     0.150
     5.401   945.906     0.150
     5.627    82.203     0.150
     5.689    83.164     0.150
     5.689   147.539     0.150
     5.753    83.633     0.150
     5.842    85.141     0.150
     5.967    88.078     0.150
     5.967    87.641     0.150
     5.995    88.109     0.150
     6.283    92.352     0.150
     6.343    92.016     0.150
     6.343    92.266     0.150
     6.477    94.750     0.150
     6.586    96.711     0.150
     6.604    96.984     0.150
     6.609    97.383     0.150
     6.610   100.039     0.150
     6.707    97.234     0.150
     6.871   101.820     0.150
     6.940    99.992     0.150
     7.005   101.469     0.150
     6.991   102.992     0.150
     7.022   101.992     0.150
     7.061   102.680     0.150
     7.108   103.766     0.150
     7.150   103.891     0.150
     7.187   104.766     0.150
     7.209   106.711     0.150
     7.212   105.234     0.150
     7.237   106.680     0.150
     7.378   109.359     0.150
     7.378   109.258     0.150
     7.465   108.523     0.150
     7.489   110.125     0.150
     7.495   108.977     0.150
     7.628   110.000     0.150
     7.659   114.539     0.150
     7.756   113.656     0.150
     7.790   114.000     0.150
     7.795   113.867     0.150
     7.795   113.719     0.150
     7.795   144.469     0.150
     7.862   115.297     0.150
     7.896   113.609     0.150
     7.998   116.914     0.150
     8.033   118.406     0.150
     8.056   115.617     0.150
     8.094   119.250     0.150
     8.099   118.945     0.150
     8.098   118.227     0.150
     8.191   119.727     0.150
     8.278   118.938     0.150
     8.309   118.836     0.150
     8.355   122.445     0.150
     8.387   120.172     0.150
     8.402   120.797     0.150
     8.404   120.891     0.150
     8.436   120.703     0.150
     8.491   123.617     0.150
     8.516   123.234     0.150
     8.654   128.453     0.150
     8.684   127.398     0.150
     8.697   127.805     0.150
     8.695   125.859     0.150
     8.725   126.078     0.150
     8.761   127.883     0.150
     8.830   126.648     0.150
     8.861   129.352     0.150
     8.868   127.578     0.150
     8.929   128.750     0.150
     8.941   128.781     0.150
     8.957   131.023     0.150
     8.981   129.719     0.150
     8.997   132.031     0.150
     9.017   129.875     0.150
     9.042   132.188     0.150
     9.093   132.555     0.150
     9.134   132.047     0.150
     9.249   134.172     0.150
     9.335   136.648     0.150
     9.335   137.359     0.150
     9.400   137.023     0.150
     9.426   136.531     0.150
     9.445   136.344     0.150
     9.550   139.609     0.150
     9.558   138.148     0.150
     9.606   141.156     0.150
     9.644   141.172     0.150
     9.655   139.297     0.150
     9.677   139.422     0.150
     9.758   140.547     0.150
     9.830   141.570     0.150
     9.861   142.289     0.150
     9.979   144.875     0.150
     9.968   249.969     0.150
     9.979   143.758     0.150
    10.077   145.875     0.150
    10.077   144.703     0.150
    10.152   147.195     0.150
    10.236   146.602     0.150
    10.248   147.281     0.150
    10.316   148.484     0.150
    10.365   150.875     0.150
    10.438   151.945     0.150
    10.435   150.062     0.150
    10.435   150.062     0.150
    10.436   150.062     0.150
    10.436   328.969     0.150
    10.491   151.430     0.150
    10.528   151.172     0.150
    10.609   153.766     0.150
    10.609   152.953     0.150
    10.625   152.602     0.150
    10.655   155.695     0.150
    10.741   156.227     0.150
    10.772   157.375     0.150
    10.772   156.750     0.150
    10.814   155.398     0.150
    10.877   156.328     0.150
    10.890   158.977     0.150
    11.028   157.898     0.150
    11.031   159.648     0.150
    11.038   158.367     0.150
    11.059   163.133     0.150
    11.322   165.055     0.150
    11.322   164.969     0.150
    11.322   164.969     0.150
    11.335   163.070     0.150
    11.462   165.477     0.150
    11.513   167.188     0.150
    11.564   165.727     0.150
    11.611   168.742     0.150
    11.631   169.453     0.150
    11.647   167.953     0.150
    11.680   166.602     0.150
    11.734   170.977     0.150
    11.904   172.992     0.150
    11.932   172.781     0.150
    11.946   171.641     0.150
    12.000   174.742     0.150
    12.034   172.859     0.150
    12.058   174.125     0.150
    12.087   174.117     0.150
    12.140   174.117     0.150
    12.157   174.820     0.150
    12.220   175.422     0.150
    12.231   174.023     0.150
    12.550   181.492     0.150
    12.579   180.711     0.150
    12.638   182.164     0.150
    12.682   181.656     0.150
    12.690   182.539     0.150
    12.731   184.109     0.150
    12.802   184.984     0.150
    12.849   186.703     0.150
    12.974   185.570     0.150
    12.974   186.586     0.150
    13.210   186.555     0.150
    13.210   189.766     0.150
    13.250   189.367     0.150
    13.289   190.391     0.150
    13.328   190.734     0.150
    13.350   192.383     0.150
    13.359   192.578     0.150
    13.359   192.047     0.150
    13.367   192.234     0.150
    13.372   191.430     0.150
    13.414   193.234     0.150
    13.562   194.805     0.150
    13.608   195.055     0.150
    13.663   196.242     0.150
    13.672   195.445     0.150
    13.689   195.898     0.150
    13.967   198.516     0.150
    14.085   199.656     0.150
    14.376   202.477     0.150
    14.474   206.969     0.150
    14.474   208.625     0.150
    14.617   208.617     0.150
    14.668   207.195     0.150
    14.913   213.625     0.150
    14.930   213.156     0.150
    14.926   211.055     0.150
    14.936   213.688     0.150
    15.107   213.695     0.150
    15.107   214.617     0.150
    15.149   212.898     0.150
    15.149   523.023     0.150
    15.204   215.719     0.150
    15.362   219.297     0.150
    15.424   219.172     0.150
    15.464   221.414     0.150
    15.515   219.156     0.150
    15.562   222.062     0.150
    15.575   220.422     0.150
    15.635   223.406     0.150
    15.657   224.086     0.150
    15.682   223.391     0.150
    15.896   224.195     0.150
    15.934   226.805     0.150
    15.934   505.039     0.150
    15.934   226.398     0.150
    15.985   228.148     0.150
    16.186   224.578     0.150
    16.365   230.039     0.150
    16.386   228.016     0.150
    16.519   232.766     0.150
    16.570   233.984     0.150
    16.700   233.359     0.150
    16.792   237.633     0.150
    16.827   236.227     0.150
    17.376   243.062     0.150
    17.385   243.375     0.150
    17.496   244.062     0.150
    18.128   249.742     0.150
    18.243   254.773     0.150
    18.525   258.023     0.150
    19.505   269.938     0.150
    19.957   271.555     0.150
    20.884   282.555     0.150
    20.913   283.805     0.150
    20.931   284.062     0.150
    21.295   287.406     0.150
    21.632   292.859     0.150
    21.636   290.859     0.150
    21.683   289.227     0.150
    22.368   296.938     0.150
    22.385   297.938     0.150
    22.770   303.492     0.150
    22.964   305.766     0.150
    22.972   306.047     0.150
    23.214   307.039     0.150
    23.788   314.016     0.150
    23.990   317.586     0.150
    24.011   317.672     0.150
    24.240   318.156     0.150
    24.321   318.523     0.150
    35.849   422.664     0.150
    36.126   424.828     0.150
    36.408   427.688     0.150
    36.478   428.438     0.150
    37.283   435.398     0.150
    37.384   435.766     0.150
    37.754   439.094     0.150
    37.783   437.758     0.150
    37.783   437.039     0.150
    37.783   437.039     0.150
    38.406   444.219     0.150
    38.672   446.078     0.150
    38.802   446.516     0.150
    40.772   462.586     0.150
    40.797   460.797     0.150
    47.199   515.484     0.150
    55.516   576.016     0.150
    81.390   737.047     0.150
    81.390   737.047     0.150
    82.259   740.914     0.150
    82.328   740.914     0.150
    83.512   748.016     0.150
    83.670   749.117     0.150
    83.671   749.414     0.150
    83.659   750.664     0.150
    83.712   750.016     0.150
    83.766   749.812     0.150
    83.773   749.312     0.150
    84.120   750.516     0.150
    84.183   753.547     0.150
    84.446   754.117     0.150
    84.611   754.719     0.150
    84.822   756.719     0.150
    85.085   757.516     0.150
    85.280   757.617     0.150
    85.803   762.773     0.150
    91.542   788.812     0.150
    91.542   788.812     0.150
    92.288   791.766     0.150
    92.288   792.078     0.150
    93.630   793.016     0.150
    93.630  1465.516     0.150
    94.818   804.859     0.150
    95.269   801.812     0.150
    95.269  1032.414     0.150
    95.269  1435.914     0.150
    95.269  1471.812     0.150
    96.365   810.828     0.150
    96.468   810.820     0.150
    98.020   813.617     0.150
   101.321   830.516     0.150
   101.321   835.312     0.150
   102.663   833.617     0.150
   102.663   837.914     0.150
   102.663   841.016     0.150
   107.007   855.117     0.150
   107.007  1123.914     0.150
   107.007  1572.312     0.150
   109.149   863.812     0.150
   109.149  1106.016     0.150
   112.288  1113.312     0.150
   112.288  1118.312     0.150
   112.288  1161.812     0.150
   113.084  1622.914     0.150
   117.247  1128.969     0.150
   119.231  1132.664     0.150
   119.231  1132.664     0.150
   144.715  1177.703     0.150
   145.059  1178.859     0.150
   145.925  1181.617     0.150
     0.062     0.945     0.150
     0.090     4.665     0.150
     0.135     2.955     0.150
     0.135     6.905     0.150
     0.084     1.935     0.150
     0.084     5.605     0.150
     0.458     8.695     0.150
     0.467     9.215     0.150
     0.500     9.415     0.150
     0.524     9.725     0.150
     0.502     8.915     0.150
     0.502    16.645     0.150
     0.616    11.135     0.150
     0.611    11.045     0.150
     0.729    12.505     0.150
     0.713    12.995     0.150
     0.713    22.805     0.150
     0.702    13.175     0.150
     0.702    23.105     0.150
     0.751    13.717     0.150
     0.751    23.715     0.150
     0.782    13.775     0.150
     0.793    13.475     0.150
     0.793    23.925     0.150
     0.793    24.233     0.150
     0.807    14.005     0.150
     0.882    15.425     0.150
     0.978    17.075     0.150
     1.098    18.874     0.150
     1.098    34.139     0.150
     1.097    18.874     0.150
     1.097    34.139     0.150
     1.194    19.135     0.150
     1.167    21.125     0.150
     1.167    36.745     0.150
     1.214    21.235     0.150
     1.214    36.875     0.150
     1.188    21.385     0.150
     1.302    21.249     0.150
     1.302    36.564     0.150
     1.316    21.365     0.150
     1.347    22.014     0.150
     1.347    39.313     0.150
     1.315    23.555     0.150
     1.316    23.075     0.150
     1.316    40.435     0.150
     1.317    23.115     0.150
     1.317    42.015     0.150
     1.367    24.215     0.150
     1.419    25.515     0.150
     1.530    27.455     0.150
     1.530    24.284     0.150
     1.536    27.375     0.150
     1.585    25.415     0.150
     1.593    25.225     0.150
     1.593    45.575     0.150
     1.632    26.225     0.150
     1.624    26.835     0.150
     1.653    26.565     0.150
     1.657    26.845     0.150
     1.744    27.323     0.150
     1.799    28.366     0.150
     1.857    29.095     0.150
     1.934    30.355     0.150
     1.939    30.565     0.150
     2.028    31.757     0.150
     2.137    32.656     0.150
     2.210    34.138     0.150
     2.441    37.414     0.150
     2.480    38.120     0.150
     2.733    41.937     0.150
     2.735    42.305     0.150
     2.831    48.856     0.150
     2.831    85.381     0.150
     2.865    49.924     0.150
     2.865    86.645     0.150
     2.976    45.935     0.150
     2.976    51.165     0.150
     3.029    49.735     0.150
     3.029    52.805     0.150
     3.029    82.895     0.150
     3.116    46.805     0.150
     3.176    55.245     0.150
     3.198    49.315     0.150
     3.382    51.121     0.150
     3.817    57.849     0.150
     3.811    56.405     0.150
     3.811   100.535     0.150
     3.811   117.085     0.150
     4.043    60.141     0.150
     4.140    62.015     0.150
     4.137    61.375     0.150
     4.137   132.535     0.150
     4.137   939.165     0.150
     4.228    63.035     0.150
     4.228    62.329     0.150
     4.528    68.705     0.150
     4.543    67.780     0.150
     4.756    71.396     0.150
     4.959    73.195     0.150
     5.002    74.295     0.150
     5.002   132.145     0.150
     5.202    76.224     0.150
     5.248    80.195     0.150
     5.382    80.475     0.150
     5.382    80.289     0.150
     5.417    80.835     0.150
     5.627    82.166     0.150
     5.691    83.347     0.150
     5.674    83.805     0.150
     5.674   148.375     0.150
     5.752    84.543     0.150
     5.840    85.738     0.150
     5.983    88.915     0.150
     5.983    87.332     0.150
     5.999    88.276     0.150
     6.078    89.766     0.150
     6.291    92.089     0.150
     6.344    92.161     0.150
     6.480    94.791     0.150
     6.540    97.585     0.150
     6.559    95.515     0.150
     6.559   168.625     0.150
     6.591    96.814     0.150
     6.626    96.905     0.150
     6.609    97.443     0.150
     6.618    97.556     0.150
     6.881   101.474     0.150
     7.006   102.316     0.150
     7.035   104.265     0.150
     7.064   102.472     0.150
     7.113   104.275     0.150
     7.154   104.007     0.150
     7.192   104.995     0.150
     7.216   104.800     0.150
     7.242   106.347     0.150
     7.352   109.825     0.150
     7.389   109.455     0.150
     7.389   108.997     0.150
     7.470   108.585     0.150
     7.498   109.923     0.150
     7.500   108.735     0.150
     7.675   115.735     0.150
     7.676   111.245     0.150
     7.801   114.145     0.150
     7.801   245.975     0.150
     7.801   114.400     0.150
     7.821   114.055     0.150
     7.900   113.817     0.150
     8.014   120.245     0.150
     8.041   117.486     0.150
     8.072   115.915     0.150
     8.110   118.466     0.150
     8.105   117.894     0.150
     8.192   123.055     0.150
     8.278   119.057     0.150
     8.310   119.229     0.150
     8.371   119.305     0.150
     8.408   120.820     0.150
     8.405   120.667     0.150
     8.435   120.915     0.150
     8.499   123.191     0.150
     8.521   123.292     0.150
     8.701   125.449     0.150
     8.788   126.685     0.150
     8.828   127.035     0.150
     8.868   128.401     0.150
     8.927   129.199     0.150
     8.943   129.411     0.150
     8.982   129.732     0.150
     9.020   129.841     0.150
     9.138   132.150     0.150
     9.249   131.905     0.150
     9.411   136.879     0.150
     9.451   136.875     0.150
     9.584   139.815     0.150
     9.616   139.025     0.150
     9.619   140.175     0.150
     9.655   137.975     0.150
     9.756   141.019     0.150
     9.960   144.265     0.150
     9.960   253.735     0.150
     9.975   143.611     0.150
    10.233   147.523     0.150
    10.431   149.945     0.150
    10.431   268.285     0.150
    10.431   149.955     0.150
    10.431   268.285     0.150
    10.431   330.285     0.150
    10.612   150.975     0.150
    10.784   155.805     0.150
    11.647   167.935     0.150
    11.825   173.325     0.150
    12.016   175.245     0.150
    12.800   186.061     0.150
    13.153   191.075     0.150
    13.349   192.659     0.150
    13.358   192.345     0.150
    13.578   196.405     0.150
    13.606   195.480     0.150
    14.951   213.201     0.150
    15.108   211.785     0.150
    15.950   224.145     0.150
    15.950   229.175     0.150
    16.826   234.665     0.150
    21.803   292.995     0.150
    37.798   437.165     0.150
    37.798   437.155     0.150
    81.406   737.565     0.150
    81.406   737.565     0.150
    86.114   761.275     0.150
    95.283   802.775     0.150
    95.283  1033.975     0.150
    95.283  1438.075     0.150
    95.283  1475.275     0.150
    95.283  1476.275     0.150
    95.283  1863.975     0.150
     0.223     4.160     0.150
     0.223     7.781     0.150
     0.226     4.342     0.150
     0.226     7.730     0.150
     0.573    11.182     0.150
     0.573    18.932     0.150
     0.601    10.891     0.150
     0.601    19.410     0.150
     0.623    11.391     0.150
     0.652    12.041     0.150
     0.667    11.861     0.150
     0.693    12.311     0.150
     0.729    13.301     0.150
     0.743    13.420     0.150
     0.743    23.781     0.150
     0.762    13.420     0.150
     0.762    24.361     0.150
     0.960    15.951     0.150
     0.960    29.000     0.150
     1.041    19.102     0.150
     1.041    33.521     0.150
     1.124    20.092     0.150
     1.124    35.891     0.150
     1.149    20.660     0.150
     1.149    37.580     0.150
     1.150    20.602     0.150
     1.150    36.791     0.150
     1.150    38.830     0.150
     1.150    39.920     0.150
     1.193    21.541     0.150
     1.193    37.961     0.150
     1.223    21.211     0.150
     1.223    37.111     0.150
     1.257    22.420     0.150
     1.257    39.842     0.150
     1.697    26.842     0.150
     1.697    51.580     0.150
     1.697    51.852     0.150
     2.883    45.111     0.150
     3.045    48.711     0.150
     3.045    92.121     0.150
     3.092    53.480     0.150
     3.330    50.570     0.150
     3.717    56.891     0.150
     3.865    56.480     0.150
     3.865   122.701     0.150
     4.304    64.791     0.150
     4.329    64.451     0.150
     4.679    70.682     0.150
     5.511    82.131     0.150
     5.587    83.490     0.150
     6.144    90.070     0.150
     6.564    96.410     0.150
     6.795    98.602     0.150
     7.287   106.420     0.150
     7.536   110.531     0.150
     7.564   109.451     0.150
     7.597   110.570     0.150
     7.785   115.531     0.150
     7.908   115.182     0.150
     8.115   119.551     0.150
     8.311   122.932     0.150
     8.481   121.262     0.150
     9.738   141.621     0.150
    10.442   151.102     0.150
    10.442   328.762     0.150
    11.507   167.521     0.150
    37.932   438.230     0.150
    95.391   799.932     0.150
    95.391  1032.531     0.150
    95.391  1470.031     0.150
    95.391  1483.531     0.150
   101.479   830.932     0.150
   107.128   854.131     0.150
     0.194     3.844     0.150
     0.235     4.359     0.150
     0.306     5.328     0.150
     0.350     6.312     0.150
     0.371     6.859     0.150
     0.371    12.094     0.150
     0.371    12.570     0.150
     0.384     7.164     0.150
     0.384    12.375     0.150
     0.381     7.672     0.150
     0.381    13.961     0.150
     0.482     9.164     0.150
     0.458     9.195     0.150
     0.458    17.336     0.150
     0.692    12.617     0.150
     0.692    21.617     0.150
     0.692    12.617     0.150
     0.692    21.617     0.150
     0.788    13.305     0.150
     0.788    13.625     0.150
     0.788    24.172     0.150
     0.758    13.484     0.150
     0.758    24.266     0.150
     0.778    14.062     0.150
     0.778    24.320     0.150
     0.866    15.516     0.150
     0.998    16.812     0.150
     0.998    28.828     0.150
     1.164    19.336     0.150
     1.164    34.383     0.150
     1.250    21.383     0.150
     1.250    37.898     0.150
     1.267    22.812     0.150
     1.362    22.195     0.150
     1.294    22.883     0.150
     1.294    40.461     0.150
     1.291    23.211     0.150
     1.300    23.312     0.150
     1.432    23.211     0.150
     1.544    24.898     0.150
     1.587    25.539     0.150
     1.599    25.859     0.150
     1.624    27.922     0.150
     1.624    47.680     0.150
     1.624    48.836     0.150
     1.624    27.391     0.150
     2.232    34.594     0.150
     2.300    35.969     0.150
     2.439    74.047     0.150
     2.454    73.930     0.150
     2.463    41.992     0.150
     2.463    70.602     0.150
     2.463    41.992     0.150
     2.463    70.602     0.150
     2.502    37.789     0.150
     2.546    38.953     0.150
     2.546    45.227     0.150
     2.601    43.820     0.150
     2.601    78.430     0.150
     2.749    82.781     0.150
     2.799    42.531     0.150
     2.799    42.703     0.150
     2.950    44.875     0.150
     3.220    48.859     0.150
     3.610    62.008     0.150
     3.798    56.312     0.150
     3.798    56.734     0.150
     3.850    58.164     0.150
     3.922    71.508     0.150
     3.921    59.414     0.150
     4.123    60.102     0.150
     4.543    67.672     0.150
     4.543    68.016     0.150
     4.662    70.727     0.150
     5.102    76.109     0.150
     5.219    78.094     0.150
     5.433    79.914     0.150
     5.433   142.461     0.150
     5.489    82.086     0.150
     5.489    82.227     0.150
     5.547    82.023     0.150
     5.670    83.234     0.150
     5.919    86.133     0.150
     5.950    87.141     0.150
     6.076    88.484     0.150
     6.105    92.062     0.150
     6.144   195.281     0.150
     6.092    90.211     0.150
     6.092   158.844     0.150
     6.211    91.242     0.150
     6.250    92.430     0.150
     6.460    98.500     0.150
     6.635    96.289     0.150
     6.716    99.430     0.150
     6.796    99.969     0.150
     6.804    99.852     0.150
     6.937   101.602     0.150
     6.937   180.227     0.150
     7.218   107.195     0.150
     7.249   105.000     0.150
     7.332   107.922     0.150
     7.320   106.281     0.150
     7.376   107.391     0.150
     7.402   107.414     0.150
     7.435   108.891     0.150
     7.683   110.789     0.150
     7.921   115.641     0.150
     7.933   114.898     0.150
     7.977   115.984     0.150
     7.977   249.336     0.150
     8.069   253.406     0.150
     8.583   123.367     0.150
     8.591   123.078     0.150
     8.638   124.570     0.150
     8.661   124.320     0.150
     8.712   125.242     0.150
     8.753   125.461     0.150
     8.814   128.008     0.150
     9.155   131.492     0.150
     9.169   132.453     0.150
     9.202   132.430     0.150
     9.264   133.664     0.150
     9.348   135.016     0.150
    10.801   155.555     0.150
    10.801   339.805     0.150
    10.849   155.109     0.150
    11.171   162.180     0.150
    11.171   355.766     0.150
     0.089     1.863     0.150
     0.100     2.035     0.150
     0.179     3.375     0.150
     0.230     4.098     0.150
     0.253     3.980     0.150
     0.253     7.578     0.150
     0.537     9.465     0.150
     0.537    16.801     0.150
     0.536     9.465     0.150
     0.536    16.801     0.150
     0.523    10.244     0.150
     0.523    18.014     0.150
     0.606    11.805     0.150
     0.606    22.193     0.150
     0.709    12.764     0.150
     0.709    22.404     0.150
     0.799    14.725     0.150
     0.799    25.264     0.150
     0.799    14.844     0.150
     0.799    25.424     0.150
     0.862    15.234     0.150
     0.862    27.254     0.150
     0.918    15.834     0.150
     0.918    28.178     0.150
     1.011    17.361     0.150
     1.011    30.143     0.150
     1.057    18.125     0.150
     1.057    31.805     0.150
     1.057    32.637     0.150
     1.091    19.246     0.150
     1.091    33.170     0.150
     1.312    21.775     0.150
     1.385    23.523     0.150
     1.385    42.725     0.150
     1.459    24.338     0.150
     1.459    44.592     0.150
     1.521    24.820     0.150
     1.671    29.135     0.150
     1.671    52.113     0.150
     1.672    29.125     0.150
     1.672    54.824     0.150
     1.742    28.125     0.150
     1.742    49.570     0.150
     1.811    29.635     0.150
     1.811    56.105     0.150
     2.091    33.086     0.150
     2.170    65.584     0.150
     2.172    34.148     0.150
     2.282    66.225     0.150
     2.408    39.863     0.150
     2.408    73.004     0.150
     2.454    45.234     0.150
     2.460    40.375     0.150
     2.460    42.885     0.150
     2.460    73.805     0.150
     2.514    39.125     0.150
     2.607    45.523     0.150
     2.607    79.137     0.150
     2.660    40.396     0.150
     2.673    41.287     0.150
     2.725    41.994     0.150
     2.725    48.955     0.150
     2.725    85.635     0.150
     3.052    92.604     0.150
     3.081    54.094     0.150
     3.081    95.174     0.150
     3.684    55.725     0.150
     3.684    66.574     0.150
     3.684   112.135     0.150
     3.844    58.664     0.150
     3.844    73.424     0.150
     3.844   123.914     0.150
     4.281    63.064     0.150
     4.648    69.914     0.150
     5.162    95.125     0.150
     5.252    79.254     0.150
     5.447    82.354     0.150
     5.489    82.234     0.150
     5.616    84.055     0.150
     5.647   106.613     0.150
     5.647   180.904     0.150
     6.499    96.834     0.150
     6.499   204.004     0.150
     6.500   120.904     0.150
     6.504    98.824     0.150
     6.791    99.145     0.150
     7.095   102.414     0.150
     7.095   183.535     0.150
     7.454   109.305     0.150
     7.519   112.385     0.150
     7.549   110.125     0.150
     7.830   113.984     0.150
     7.955   118.285     0.150
     8.036   118.885     0.150
     8.118   117.795     0.150
     8.911   127.975     0.150
    10.999   160.943     0.150
     0.149     3.990     0.150
     0.149     6.971     0.150
     0.418     8.041     0.150
     0.418    14.371     0.150
     0.466     8.602     0.150
     0.519     8.990     0.150
     0.563    10.381     0.150
     0.702    11.881     0.150
     0.702    21.182     0.150
     0.716    12.801     0.150
     0.787    13.287     0.150
     0.832    14.791     0.150
     0.832    27.160     0.150
     0.828    14.051     0.150
     0.828    26.051     0.150
     0.861    15.283     0.150
     0.861    27.309     0.150
     0.924    15.811     0.150
     0.924    28.602     0.150
     1.209    19.955     0.150
     1.209    35.084     0.150
     1.198    20.217     0.150
     1.198    20.217     0.150
     1.285    20.834     0.150
     1.333    22.691     0.150
     1.333    40.801     0.150
     1.443    23.039     0.150
     1.443    43.475     0.150
     1.448    24.611     0.150
     1.448    46.182     0.150
     1.504    25.150     0.150
     1.504    47.551     0.150
     1.649    25.891     0.150
     1.649    46.422     0.150
     1.757    27.568     0.150
     2.014    31.102     0.150
     2.014    30.736     0.150
     2.075    32.205     0.150
     2.075    61.297     0.150
     2.074    36.186     0.150
     2.074    61.637     0.150
     2.354    41.557     0.150
     2.404    42.795     0.150
     2.423    37.070     0.150
     3.055    48.771     0.150
     3.055    99.211     0.150
     3.112    50.561     0.150
     3.112    97.252     0.150
     3.216    60.701     0.150
     3.678    69.611     0.150
     3.678   114.980     0.150
     3.730    55.031     0.150
     3.730    68.342     0.150
     4.100    61.910     0.150
     4.100   129.830     0.150
     4.281    65.131     0.150
     4.281    80.811     0.150
     4.408    66.900     0.150
     4.408    80.121     0.150
     4.408    67.039     0.150
     4.656    70.240     0.150
     5.249    78.441     0.150
     5.343    79.740     0.150
     5.343   100.051     0.150
     5.343   165.980     0.150
     5.555    82.410     0.150
     5.555   103.730     0.150
     5.555   180.910     0.150
     5.951    88.121     0.150
     5.951   192.691     0.150
     6.209    90.131     0.150
     6.209   200.131     0.150
     6.554    98.471     0.150
     6.975   102.352     0.150
     6.975   223.771     0.150
     7.054   103.041     0.150
     7.081   103.711     0.150
     7.081   134.221     0.150
     7.266   107.311     0.150
     7.266   231.941     0.150
     7.331   107.441     0.150
     7.585   112.252     0.150
     7.663   112.111     0.150
     7.663   111.391     0.150
     7.663   238.865     0.150
     7.674   113.342     0.150
     7.674   242.650     0.150
     7.766   113.021     0.150
     7.766   250.121     0.150
     7.844   115.701     0.150
     7.844   143.922     0.150
     7.849   115.980     0.150
     7.849   144.070     0.150
     7.849   251.451     0.150
     8.304   119.432     0.150
     8.333   123.711     0.150
     8.333   264.592     0.150
    10.312   324.721     0.150
    37.811   436.740     0.150
     0.084     3.352     0.150
     0.084     5.219     0.150
     0.035     2.508     0.150
     0.035     4.320     0.150
     0.351     6.617     0.150
     0.488     9.070     0.150
     0.483     9.141     0.150
     0.543    10.312     0.150
     0.569    10.211     0.150
     0.564     9.820     0.150
     0.453     8.281     0.150
     0.597    11.062     0.150
     0.638    11.578     0.150
     0.572     9.891     0.150
     0.708    12.164     0.150
     0.688    11.539     0.150
     0.688    11.891     0.150
     0.688    20.578     0.150
     0.747    13.062     0.150
     0.752    14.031     0.150
     0.780    13.609     0.150
     0.784    14.250     0.150
     0.784    24.211     0.150
     0.806    15.047     0.150
     0.806    25.812     0.150
     0.806    26.430     0.150
     0.992    17.062     0.150
     1.024    16.578     0.150
     0.976    16.156     0.150
     0.976    29.133     0.150
     1.118    18.984     0.150
     1.118    32.516     0.150
     1.118    18.984     0.150
     1.118    32.516     0.150
     1.145    18.477     0.150
     1.238    22.078     0.150
     1.238    39.297     0.150
     1.309    21.000     0.150
     1.260    20.477     0.150
     1.352    21.469     0.150
     1.377    21.711     0.150
     1.294    22.781     0.150
     1.426    22.703     0.150
     1.426    43.391     0.150
     1.452    23.922     0.150
     1.416    24.922     0.150
     1.409    24.383     0.150
     1.409    42.008     0.150
     1.465    25.680     0.150
     1.409    24.531     0.150
     1.409    43.727     0.150
     1.570    24.539     0.150
     1.570    24.438     0.150
     1.570    29.609     0.150
     1.570    25.164     0.150
     1.570    47.938     0.150
     1.573    25.016     0.150
     1.563    25.359     0.150
     1.618    25.836     0.150
     1.639    26.141     0.150
     1.662    26.641     0.150
     1.661    27.133     0.150
     1.661    47.891     0.150
     1.661    27.156     0.150
     1.705    26.961     0.150
     1.712    26.844     0.150
     1.803    28.383     0.150
     1.932    30.070     0.150
     1.934    30.195     0.150
     2.030    31.578     0.150
     2.060    32.070     0.150
     2.060    62.414     0.150
     2.094    32.945     0.150
     2.113    32.656     0.150
     2.113    64.750     0.150
     2.195    34.250     0.150
     2.089    31.539     0.150
     2.294    36.031     0.150
     2.313    36.258     0.150
     2.313    36.070     0.150
     2.367    36.320     0.150
     2.371    36.641     0.150
     2.375    37.047     0.150
     2.560    38.914     0.150
     2.631    41.180     0.150
     2.724    41.680     0.150
     2.728    42.148     0.150
     2.795    42.109     0.150
     2.849    43.336     0.150
     2.862    42.922     0.150
     2.870    43.539     0.150
     2.870    86.797     0.150
     2.865    43.688     0.150
     2.865    85.547     0.150
     2.865    43.688     0.150
     2.865    85.547     0.150
     2.884    43.125     0.150
     2.975    44.938     0.150
     3.031    45.602     0.150
     3.045    46.016     0.150
     3.045    45.891     0.150
     3.126    47.367     0.150
     3.147    47.641     0.150
     3.179    47.594     0.150
     3.364    50.328     0.150
     3.561    52.719     0.150
     3.634    52.953     0.150
     3.649    55.352     0.150
     3.649    54.438     0.150
     3.662    54.352     0.150
     3.677    56.172     0.150
     3.716    55.914     0.150
     3.716   114.359     0.150
     3.745    54.336     0.150
     4.019    59.016     0.150
     4.033    59.875     0.150
     4.021    59.016     0.150
     4.054    60.242     0.150
     4.072    60.312     0.150
     4.204    61.938     0.150
     4.242    62.531     0.150
     4.262    62.781     0.150
     4.422    66.602     0.150
     4.422    66.250     0.150
     4.550    67.266     0.150
     4.577    68.438     0.150
     4.577    68.188     0.150
     4.595    68.109     0.150
     4.641    68.836     0.150
     4.672    68.648     0.150
     4.650    69.586     0.150
     4.814    71.312     0.150
     4.878    72.227     0.150
     4.905    72.062     0.150
     4.862    72.055     0.150
     4.969    74.039     0.150
     5.008    75.516     0.150
     5.008   131.820     0.150
     5.132    76.391     0.150
     5.230    76.844     0.150
     5.151    74.961     0.150
     5.317    79.211     0.150
     5.281    78.477     0.150
     5.281    78.031     0.150
     5.489    82.086     0.150
     5.527    81.641     0.150
     5.857    87.141     0.150
     5.717    84.719     0.150
     5.717   150.062     0.150
     5.787    84.797     0.150
     5.902    86.602     0.150
     5.902    86.062     0.150
     5.970    87.539     0.150
     5.964    89.156     0.150
     6.273    90.688     0.150
     6.273    91.203     0.150
     6.311    91.812     0.150
     6.400    94.031     0.150
     6.442    95.047     0.150
     6.486    95.656     0.150
     6.486    95.266     0.150
     6.523    96.242     0.150
     6.574    97.000     0.150
     6.519    95.961     0.150
     6.519   170.141     0.150
     6.711   102.336     0.150
     6.874    99.180     0.150
     7.005   102.141     0.150
     6.985   101.312     0.150
     7.024   102.516     0.150
     7.105   103.258     0.150
     7.130   103.508     0.150
     7.283   107.820     0.150
     7.283   107.164     0.150
     7.383   106.867     0.150
     7.412   107.672     0.150
     7.453   109.359     0.150
     7.521   113.422     0.150
     7.570   111.742     0.150
     7.557   109.062     0.150
     7.598   109.992     0.150
     7.665   112.539     0.150
     7.699   111.922     0.150
     7.708   112.938     0.150
     7.708   112.211     0.150
     7.708   242.070     0.150
     7.708   111.812     0.150
     7.771   114.078     0.150
     7.814   115.156     0.150
     7.855   116.391     0.150
     7.854   115.758     0.150
     7.815   112.562     0.150
     7.829   113.039     0.150
     7.913   117.500     0.150
     7.975   117.742     0.150
     7.975   115.680     0.150
     7.940   115.680     0.150
     8.011   116.312     0.150
     8.090   120.195     0.150
     8.137   119.836     0.150
     8.178   118.555     0.150
     8.287   120.242     0.150
     8.274   122.180     0.150
     8.212   117.781     0.150
     8.237   117.984     0.150
     8.324   119.586     0.150
     8.327   119.469     0.150
     8.325   118.977     0.150
     8.400   121.125     0.150
     8.465   125.352     0.150
     8.372   119.781     0.150
     8.498   126.359     0.150
     8.567   126.938     0.150
     8.567   727.586     0.150
     8.646   127.289     0.150
     8.609   124.773     0.150
     8.666   126.062     0.150
     8.741   128.938     0.150
     8.820   130.398     0.150
     8.768   125.891     0.150
     8.828   127.742     0.150
     8.885   130.891     0.150
     8.868   128.383     0.150
     8.866   127.812     0.150
     8.873   127.586     0.150
     8.910   128.328     0.150
     8.937   128.828     0.150
     9.051   130.828     0.150
     9.121   134.266     0.150
     9.181   132.531     0.150
     9.305   134.930     0.150
     9.360   135.711     0.150
     9.434   137.836     0.150
     9.359   134.555     0.150
     9.409   136.125     0.150
     9.476   138.656     0.150
     9.362   240.945     0.150
     9.477   139.000     0.150
     9.512   139.711     0.150
     9.520   138.141     0.150
     9.447   136.805     0.150
     9.513   138.797     0.150
     9.513   137.492     0.150
     9.483   136.758     0.150
     9.571   137.883     0.150
     9.586   138.656     0.150
     9.615   138.633     0.150
     9.655   139.273     0.150
     9.696   139.641     0.150
     9.740   141.570     0.150
     9.701   139.195     0.150
     9.755   140.492     0.150
     9.748   139.969     0.150
     9.905   145.352     0.150
     9.808   140.992     0.150
     9.884   142.906     0.150
     9.885   142.344     0.150
     9.982   144.016     0.150
     9.930   143.039     0.150
     9.946   144.719     0.150
     9.946   255.758     0.150
    10.060   144.719     0.150
    10.005   142.859     0.150
    10.037   144.969     0.150
    10.042   145.312     0.150
    10.068   144.648     0.150
    10.103   144.680     0.150
    10.125   145.594     0.150
    10.199   146.375     0.150
    10.182   145.805     0.150
    10.188   146.016     0.150
    10.249   147.461     0.150
    10.271   147.773     0.150
    10.256   147.844     0.150
    10.339   152.039     0.150
    10.344   148.570     0.150
    10.396   149.602     0.150
    10.447   150.109     0.150
    10.387   148.656     0.150
    10.388   149.438     0.150
    10.388   326.609     0.150
    10.444   149.938     0.150
    10.530   151.742     0.150
    10.530   151.891     0.150
    10.584   152.398     0.150
    10.576   153.383     0.150
    10.591   152.211     0.150
    10.650   153.297     0.150
    10.717   153.766     0.150
    10.677   156.336     0.150
    10.677   154.094     0.150
    10.686   153.555     0.150
    10.777   154.219     0.150
    10.806   157.859     0.150
    10.822   157.664     0.150
    10.743   153.789     0.150
    10.842   160.867     0.150
    10.777   157.062     0.150
    10.817   155.258     0.150
    10.818   155.016     0.150
    10.907   156.070     0.150
    10.966   160.852     0.150
    10.923   156.883     0.150
    10.919   157.133     0.150
    11.034   162.836     0.150
    11.034   162.195     0.150
    10.968   157.828     0.150
    10.960   157.953     0.150
    10.978   156.930     0.150
    11.120   161.578     0.150
    11.062   159.055     0.150
    11.198   164.086     0.150
    11.203   160.797     0.150
    11.235   162.039     0.150
    11.235   161.836     0.150
    11.241   160.648     0.150
    11.236   161.859     0.150
    11.285   161.938     0.150
    11.256   162.383     0.150
    11.259   161.477     0.150
    11.264   162.203     0.150
    11.276   161.484     0.150
    11.419   163.508     0.150
    11.359   162.852     0.150
    11.386   163.281     0.150
    11.349   161.859     0.150
    11.361   162.844     0.150
    11.387   163.102     0.150
    11.419   165.344     0.150
    11.436   164.148     0.150
    11.460   164.508     0.150
    11.491   165.000     0.150
    11.547   168.133     0.150
    11.505   164.344     0.150
    11.533   165.641     0.150
    11.651   169.172     0.150
    11.596   166.680     0.150
    11.725   169.180     0.150
    11.685   167.750     0.150
    11.732   168.656     0.150
    11.770   170.055     0.150
    11.768   168.266     0.150
    11.774   169.227     0.150
    11.821   169.828     0.150
    11.788   172.828     0.150
    11.820   171.133     0.150
    11.859   174.422     0.150
    11.844   170.312     0.150
    11.845   170.695     0.150
    11.917   172.727     0.150
    11.871   170.789     0.150
    11.940   169.602     0.150
    11.967   170.406     0.150
    12.022   172.891     0.150
    11.959   171.680     0.150
    11.969   170.633     0.150
    12.099   177.711     0.150
    12.025   171.789     0.150
    12.057   172.477     0.150
    12.025   172.742     0.150
    12.146   176.312     0.150
    12.147   176.078     0.150
    12.079   173.125     0.150
    12.190   179.312     0.150
    12.083   172.312     0.150
    12.052   306.461     0.150
    12.138   177.742     0.150
    12.138   174.086     0.150
    12.180   174.750     0.150
    12.253   175.938     0.150
    12.260   175.445     0.150
    12.293   175.789     0.150
    12.293   175.047     0.150
    12.343   175.664     0.150
    12.363   177.500     0.150
    12.411   179.250     0.150
    12.468   183.742     0.150
    12.472   181.133     0.150
    12.472   179.953     0.150
    12.442   180.297     0.150
    12.485   179.008     0.150
    12.503   182.477     0.150
    12.472   178.984     0.150
    12.481   180.000     0.150
    12.558   180.055     0.150
    12.507   179.047     0.150
    12.594   180.953     0.150
    12.649   184.031     0.150
    12.666   183.188     0.150
    12.666   185.039     0.150
    12.576   180.375     0.150
    12.645   181.578     0.150
    12.682   184.117     0.150
    12.612   180.852     0.150
    12.647   181.930     0.150
    12.617   180.875     0.150
    12.627   179.531     0.150
    12.716   184.336     0.150
    12.727   183.406     0.150
    12.682   182.352     0.150
    12.709   183.172     0.150
    12.760   183.070     0.150
    12.746   183.461     0.150
    12.787   185.312     0.150
    12.785   182.125     0.150
    12.743   183.156     0.150
    12.842   183.953     0.150
    12.930   184.008     0.150
    12.941   184.188     0.150
    12.959   185.250     0.150
    12.893   183.422     0.150
    12.917   184.836     0.150
    12.928   185.023     0.150
    12.920   185.625     0.150
    13.002   186.211     0.150
    12.987   185.883     0.150
    13.060   189.945     0.150
    13.156   191.062     0.150
    13.138   189.352     0.150
    13.150   188.297     0.150
    13.152   187.156     0.150
    13.144   187.898     0.150
    13.182   188.766     0.150
    13.187   189.461     0.150
    13.138   188.039     0.150
    13.138   186.922     0.150
    13.160   189.258     0.150
    13.184   187.656     0.150
    13.231   189.031     0.150
    13.198   188.336     0.150
    13.278   189.562     0.150
    13.266   189.562     0.150
    13.226   188.367     0.150
    13.253   189.430     0.150
    13.272   190.633     0.150
    13.323   189.844     0.150
    13.324   190.219     0.150
    13.379   194.742     0.150
    13.294   189.688     0.150
    13.291   190.148     0.150
    13.298   191.039     0.150
    13.298   190.445     0.150
    13.426   194.539     0.150
    13.452   195.609     0.150
    13.477   193.266     0.150
    13.447   191.711     0.150
    13.531   195.680     0.150
    13.503   193.219     0.150
    13.551   192.281     0.150
    13.544   193.383     0.150
    13.544   193.781     0.150
    13.603   196.836     0.150
    13.590   193.312     0.150
    13.576   193.703     0.150
    13.584   194.039     0.150
    13.671   193.539     0.150
    13.680   193.469     0.150
    13.671   195.250     0.150
    13.637   194.078     0.150
    13.733   194.727     0.150
    13.713   194.352     0.150
    13.805   196.719     0.150
    13.751   195.164     0.150
    13.806   197.328     0.150
    13.792   196.477     0.150
    13.867   197.094     0.150
    13.789   196.172     0.150
    13.815   195.664     0.150
    13.834   196.797     0.150
    13.851   196.609     0.150
    13.842   196.883     0.150
    13.877   197.781     0.150
    13.914   199.445     0.150
    13.886   196.836     0.150
    13.962   199.508     0.150
    14.001   202.008     0.150
    13.944   197.281     0.150
    13.981   198.539     0.150
    13.972   198.359     0.150
    14.024   200.391     0.150
    14.057   200.953     0.150
    14.057   199.977     0.150
    14.100   199.711     0.150
    14.037   199.672     0.150
    14.144   201.727     0.150
    14.076   200.422     0.150
    14.102   199.555     0.150
    14.201   201.828     0.150
    14.195   201.398     0.150
    14.234   204.742     0.150
    14.186   202.812     0.150
    14.211   202.977     0.150
    14.182   200.297     0.150
    14.202   202.477     0.150
    14.324   206.258     0.150
    14.317   206.758     0.150
    14.253   203.562     0.150
    14.402   206.539     0.150
    14.402   204.383     0.150
    14.373   203.703     0.150
    14.412   204.055     0.150
    14.410   205.758     0.150
    14.439   206.023     0.150
    14.416   204.891     0.150
    14.485   208.172     0.150
    14.459   204.555     0.150
    14.477   205.422     0.150
    14.514   205.156     0.150
    14.532   208.102     0.150
    14.499   204.867     0.150
    14.543   209.359     0.150
    14.458   204.734     0.150
    14.461   204.516     0.150
    14.464   204.914     0.150
    14.576   209.391     0.150
    14.575   205.641     0.150
    14.518   205.609     0.150
    14.525   205.555     0.150
    14.560   205.305     0.150
    14.643   206.695     0.150
    14.624   206.828     0.150
    14.664   208.227     0.150
    14.657   206.703     0.150
    14.656   207.938     0.150
    14.706   210.445     0.150
    14.690   209.453     0.150
    14.749   207.867     0.150
    14.707   208.344     0.150
    14.692   207.656     0.150
    14.757   208.516     0.150
    14.840   212.516     0.150
    14.827   209.469     0.150
    14.845   210.172     0.150
    14.871   212.586     0.150
    14.845   209.852     0.150
    14.774   210.305     0.150
    14.766   211.508     0.150
    14.932   214.758     0.150
    14.812   212.070     0.150
    14.927   211.156     0.150
    14.987   211.734     0.150
    15.007   211.133     0.150
    14.999   210.875     0.150
    15.002   211.242     0.150
    15.011   213.156     0.150
    15.059   213.133     0.150
    15.078   215.172     0.150
    15.036   212.086     0.150
    15.079   212.711     0.150
    15.023   212.141     0.150
    15.018   212.414     0.150
    15.037   212.602     0.150
    15.037   212.125     0.150
    15.159   218.039     0.150
    15.159   525.992     0.150
    15.141   215.109     0.150
    15.159   213.953     0.150
    15.116   212.828     0.150
    15.115   212.688     0.150
    15.157   213.719     0.150
    15.215   215.273     0.150
    15.214   214.211     0.150
    15.232   216.102     0.150
    15.272   215.047     0.150
    15.303   217.938     0.150
    15.237   215.438     0.150
    15.348   216.633     0.150
    15.272   216.570     0.150
    15.280   216.188     0.150
    15.395   219.438     0.150
    15.403   217.148     0.150
    15.431   221.180     0.150
    15.477   222.188     0.150
    15.479   219.367     0.150
    15.397   218.062     0.150
    15.517   220.438     0.150
    15.483   218.938     0.150
    15.518   219.570     0.150
    15.524   219.727     0.150
    15.565   221.508     0.150
    15.547   219.281     0.150
    15.548   219.516     0.150
    15.545   219.000     0.150
    15.612   224.188     0.150
    15.597   220.391     0.150
    15.560   221.086     0.150
    15.641   221.281     0.150
    15.684   220.852     0.150
    15.679   220.977     0.150
    15.700   221.336     0.150
    15.715   223.914     0.150
    15.754   221.680     0.150
    15.808   222.180     0.150
    15.718   224.062     0.150
    15.797   223.406     0.150
    15.871   225.141     0.150
    15.871   223.242     0.150
    15.898   223.969     0.150
    15.787   225.562     0.150
    15.902   224.609     0.150
    15.938   225.734     0.150
    15.964   225.414     0.150
    15.976   226.398     0.150
    16.014   225.414     0.150
    16.027   225.438     0.150
    16.104   228.992     0.150
    16.104   227.312     0.150
    16.202   229.336     0.150
    16.207   228.094     0.150
    16.227   228.102     0.150
    16.231   229.352     0.150
    16.224   229.164     0.150
    16.325   232.742     0.150
    16.292   234.297     0.150
    16.292   230.055     0.150
    16.395   229.969     0.150
    16.426   231.445     0.150
    16.463   231.938     0.150
    16.472   231.430     0.150
    16.436   230.789     0.150
    16.436   230.516     0.150
    16.480   232.398     0.150
    16.480   232.055     0.150
    16.513   233.195     0.150
    16.521   231.867     0.150
    16.555   232.672     0.150
    16.576   232.812     0.150
    16.629   235.258     0.150
    16.681   235.062     0.150
    16.712   234.047     0.150
    16.743   239.141     0.150
    16.801   235.977     0.150
    16.835   236.281     0.150
    16.847   236.094     0.150
    16.764   237.539     0.150
    16.847   235.492     0.150
    16.876   237.297     0.150
    16.867   237.016     0.150
    17.090   238.344     0.150
    17.125   240.008     0.150
    17.127   239.672     0.150
    17.159   240.438     0.150
    17.172   240.461     0.150
    17.268   241.023     0.150
    17.305   242.172     0.150
    17.311   242.797     0.150
    17.342   247.008     0.150
    17.396   242.977     0.150
    17.401   243.289     0.150
    17.445   243.773     0.150
    17.461   242.289     0.150
    17.536   244.805     0.150
    17.665   246.312     0.150
    17.751   247.992     0.150
    17.766   248.172     0.150
    17.772   248.398     0.150
    17.947   249.578     0.150
    17.975   249.922     0.150
    17.991   250.680     0.150
    18.039   251.852     0.150
    18.039   251.211     0.150
    18.163   252.742     0.150
    18.235   253.586     0.150
    18.247   253.078     0.150
    18.296   253.289     0.150
    18.306   253.703     0.150
    18.430   258.188     0.150
    18.430   256.359     0.150
    18.467   256.438     0.150
    18.479   256.188     0.150
    18.494   256.797     0.150
    18.486   256.398     0.150
    18.690   258.688     0.150
    18.801   259.500     0.150
    18.820   260.523     0.150
    18.849   259.656     0.150
    18.957   262.031     0.150
    19.107   262.805     0.150
    19.188   263.211     0.150
    19.182   265.180     0.150
    19.412   266.430     0.150
    19.522   267.992     0.150
    19.840   271.422     0.150
    19.864   274.695     0.150
    19.915   272.508     0.150
    19.978   273.398     0.150
    20.372   277.281     0.150
    20.438   277.672     0.150
    20.812   281.336     0.150
    20.802   281.766     0.150
    21.207   286.539     0.150
    21.363   291.336     0.150
    21.542   289.695     0.150
    21.542   289.227     0.150
    21.537   292.789     0.150
    21.604   290.039     0.150
    21.660   292.758     0.150
    21.853   293.891     0.150
    21.880   293.602     0.150
    22.274   300.141     0.150
    22.294   299.695     0.150
    22.845   302.141     0.150
    22.845   302.367     0.150
    22.889   304.141     0.150
    23.712   312.531     0.150
    23.900   315.500     0.150
    23.900   313.891     0.150
    23.939   316.227     0.150
    24.168   316.039     0.150
    24.152   316.836     0.150
    24.439   319.859     0.150
    25.583   330.141     0.150
    26.232   337.891     0.150
    26.185   336.289     0.150
    26.348   340.945     0.150
    26.764   342.297     0.150
    26.990   342.547     0.150
    27.869   352.289     0.150
    27.869   351.539     0.150
    28.205   352.422     0.150
    28.341   354.336     0.150
    28.341     5.203     0.150
    29.290   362.039     0.150
    29.922   368.641     0.150
    30.070   369.438     0.150
    30.070   368.328     0.150
    30.178   373.289     0.150
    30.860   377.117     0.150
    31.372   384.602     0.150
    31.926   388.922     0.150
    32.810  1031.742     0.150
    34.004   407.438     0.150
    34.370   411.742     0.150
    35.048   415.242     0.150
    35.452   416.781     0.150
    35.556   419.242     0.150
    35.556   421.633     0.150
    35.686   421.180     0.150
    35.829   421.172     0.150
    35.901   423.016     0.150
    36.043   424.039     0.150
    36.073   420.852     0.150
    36.083   424.039     0.150
    36.379   426.602     0.150
    36.447   427.242     0.150
    37.258   434.117     0.150
    37.356   437.086     0.150
    37.434   435.039     0.150
    37.434   434.664     0.150
    37.718   437.836     0.150
    37.744   436.492     0.150
    37.744   437.438     0.150
    38.012   440.227     0.150
    38.116   440.438     0.150
    38.116   441.852     0.150
    38.300   442.352     0.150
    38.375   443.133     0.150
    38.639   444.961     0.150
    38.777   446.258     0.150
    38.911   448.141     0.150
    40.410   460.758     0.150
    40.412   466.031     0.150
    40.735   461.930     0.150
    41.981   475.578     0.150
    43.497   484.242     0.150
    43.493   483.188     0.150
    43.800   492.250     0.150
    44.186   495.070     0.150
    45.234   501.867     0.150
    45.687   502.266     0.150
    45.648   504.133     0.150
    45.873   503.117     0.150
    45.966   508.086     0.150
    46.210   508.656     0.150
    46.437   512.047     0.150
    46.460   510.352     0.150
    46.712   510.328     0.150
    46.772   512.047     0.150
    46.818   514.883     0.150
    47.003   515.930     0.150
    47.184   515.852     0.150
    47.184   514.883     0.150
    47.288   513.750     0.150
    47.341   516.008     0.150
    47.337   518.281     0.150
    47.381   518.281     0.150
    47.601   517.711     0.150
    47.619   518.281     0.150
    48.215   522.242     0.150
    49.793   533.562     0.150
    52.706   559.141     0.150
    55.429   575.242     0.150
    55.429   575.141     0.150
    59.625   610.438     0.150
    60.879   612.742     0.150
    61.623   617.047     0.150
    62.622  1134.438     0.150
    62.622   625.477     0.150
    62.712   626.039     0.150
    63.142   628.391     0.150
    63.142   628.062     0.150
    63.142   628.438     0.150
    67.091   653.641     0.150
    67.091   652.422     0.150
    67.337   660.000     0.150
    67.364   660.992     0.150
    67.775   660.039     0.150
    68.024   665.336     0.150
    68.275   667.172     0.150
    68.846   670.992     0.150
    69.125   671.062     0.150
    69.432   674.648     0.150
    69.565   675.633     0.150
    70.058   678.383     0.150
    70.101   678.312     0.150
    72.444   686.641     0.150
    72.444   686.445     0.150
    74.361   698.336     0.150
    74.447   698.539     0.150
    74.447     6.000     0.150
    74.447   698.383     0.150
    76.014   707.188     0.150
    76.766   710.242     0.150
    77.044   718.562     0.150
    77.173   714.336     0.150
    77.442   715.938     0.150
    77.648   718.141     0.150
    77.970   721.938     0.150
    77.970   727.039     0.150
    77.970   892.641     0.150
    77.970  1310.836     0.150
    77.970  1336.438     0.150
    79.692   733.836     0.150
    80.054   731.891     0.150
    80.796   733.336     0.150
    81.048   740.938     0.150
    81.125   741.938     0.150
    81.265   735.242     0.150
    81.306   736.938     0.150
    81.428   737.938     0.150
    81.428   743.141     0.150
    81.428   923.836     0.150
    81.428  1353.836     0.150
    81.448   738.938     0.150
    81.923   739.336     0.150
    81.951   743.539     0.150
    81.970   738.938     0.150
    82.017   743.539     0.150
    82.230   741.867     0.150
    82.308   747.742     0.150
    82.404   745.242     0.150
    82.620   749.336     0.150
    82.901   748.039     0.150
    82.985   745.742     0.150
    82.985   744.539     0.150
    82.985   746.336     0.150
    82.985  1361.141     0.150
    83.078   750.438     0.150
    83.117   749.242     0.150
    83.307   746.836     0.150
    83.307  1363.836     0.150
    83.307  1690.836     0.150
    83.418   746.336     0.150
    83.485   751.336     0.150
    83.572   747.141     0.150
    83.577   747.242     0.150
    83.692   747.742     0.150
    83.792   752.336     0.150
    83.817   749.836     0.150
    84.019   750.242     0.150
    84.025   755.141     0.150
    84.026   749.336     0.150
    84.062   753.641     0.150
    84.112   756.461     0.150
    84.131   754.508     0.150
    84.353   751.242     0.150
    84.370   755.141     0.150
    84.434   755.336     0.150
    84.434   756.828     0.150
    84.518   752.039     0.150
    84.548   756.242     0.150
    84.598   758.336     0.150
    84.840   760.336     0.150
    84.973   756.141     0.150
    84.993   757.539     0.150
    84.993  1386.539     0.150
    84.993   758.141     0.150
    84.993  1439.539     0.150
    84.993  1718.539     0.150
    85.108   756.836     0.150
    85.076   759.836     0.150
    85.076   758.438     0.150
    85.166   759.336     0.150
    85.337   759.938     0.150
    85.357   756.141     0.150
    85.410   760.336     0.150
    85.420   760.938     0.150
    85.429   760.742     0.150
    85.428   760.539     0.150
    85.486   760.836     0.150
    85.557  1394.742     0.150
    85.593   761.336     0.150
    85.682   764.938     0.150
    85.712   761.938     0.150
    85.798   762.539     0.150
    86.090   759.539     0.150
    86.090  1732.039     0.150
    86.524   768.102     0.150
    86.524   766.539     0.150
    86.632   766.539     0.150
    86.632  1405.242     0.150
    86.697   768.336     0.150
    86.697  1400.539     0.150
    86.821   768.484     0.150
    86.869  1407.336     0.150
    86.884   773.391     0.150
    87.083   771.141     0.150
    87.090   767.938     0.150
    87.090  1408.336     0.150
    87.138   767.242     0.150
    87.559  1410.438     0.150
    87.735   765.539     0.150
    87.735  1404.539     0.150
    88.010   773.438     0.150
    88.067   772.641     0.150
    88.067  1413.336     0.150
    88.871   774.336     0.150
    88.905   776.828     0.150
    89.280   777.734     0.150
    89.490   777.336     0.150
    89.490   987.141     0.150
    89.490  1418.641     0.150
    89.490  1785.641     0.150
    89.555  1412.336     0.150
    89.555  1493.141     0.150
    89.769   782.742     0.150
    90.271   784.336     0.150
    90.417   785.242     0.150
    90.466   787.336     0.150
    90.554   784.242     0.150
    90.780   784.039     0.150
    91.013  1418.836     0.150
    91.297   785.938     0.150
    91.323   787.242     0.150
    91.323  1005.836     0.150
    91.323  1419.641     0.150
    91.323   786.570     0.150
    91.454   786.938     0.150
    91.457   787.406     0.150
    91.530   790.836     0.150
    91.634   787.539     0.150
    91.634  1450.742     0.150
    91.634  1515.539     0.150
    91.792   789.508     0.150
    91.792  1009.250     0.150
    91.805   790.039     0.150
    91.805  1010.641     0.150
    92.235   792.109     0.150
    92.235  1015.312     0.150
    92.235   792.141     0.150
    92.351  1429.141     0.150
    92.351  1534.742     0.150
    92.712   788.977     0.150
    92.738   793.836     0.150
    92.743   794.836     0.150
    93.615   796.336     0.150
    93.615  1463.836     0.150
    94.195   799.836     0.150
    94.513   803.641     0.150
    94.542   803.539     0.150
    94.542  1472.539     0.150
    94.542  1546.539     0.150
    94.578   805.289     0.150
    94.726   801.836     0.150
    94.726   804.539     0.150
    94.806   800.742     0.150
    95.250  1037.836     0.150
    95.250  1478.336     0.150
    95.250  1866.039     0.150
    95.877   807.539     0.150
    97.302   811.539     0.150
    97.302  1492.039     0.150
    98.018   816.039     0.150
    98.018  1502.539     0.150
    98.554   820.352     0.150
    99.193   819.438     0.150
    99.566   824.836     0.150
    99.566   827.242     0.150
    99.566  1810.258     0.150
    99.566   826.039     0.150
    99.587  1073.961     0.150
    99.587  1810.688     0.150
   100.942   828.438     0.150
   100.942  1467.438     0.150
   100.942  1623.938     0.150
   100.942  1935.539     0.150
   101.275   832.539     0.150
   101.275  1083.539     0.150
   101.275  1471.539     0.150
   101.275  1529.539     0.150
   101.275  1952.539     0.150
   101.472   831.336     0.150
   101.472   835.039     0.150
   101.472   838.039     0.150
   101.472  1082.336     0.150
   101.472  1469.039     0.150
   101.472  1528.039     0.150
   102.607  1098.641     0.150
   102.607  1800.938     0.150
   102.640   836.539     0.150
   102.640   841.836     0.150
   102.640   845.039     0.150
   102.640  1475.039     0.150
   102.640  1538.539     0.150
   102.640  1549.039     0.150
   102.640  1968.336     0.150
   104.599  1797.820     0.150
   106.989   856.539     0.150
   106.989  1125.336     0.150
   106.989  1574.039     0.150
   106.989  2031.539     0.150
   109.139   865.539     0.150
   109.139  1109.039     0.150
   109.139  2057.336     0.150
   113.086   883.539     0.150
   113.086  1628.836     0.150
   113.331  1168.336     0.150
   119.269  1135.383     0.150
   119.452  1130.836     0.150
   119.750  1132.039     0.150
   119.772  1131.328     0.150
   119.899  1136.562     0.150
   119.899  1134.891     0.150
   127.464  1150.336     0.150
   127.464  1149.648     0.150
   142.647  1175.938     0.150
   144.781  1177.242     0.150
   144.991  1177.742     0.150
     0.101     2.789     0.150
     0.101     5.336     0.150
     0.320     5.992     0.150
     0.430     7.859     0.150
     0.430    14.336     0.150
     0.494     8.555     0.150
     0.494    16.211     0.150
     0.463     8.445     0.150
     0.460     8.961     0.150
     0.517     9.648     0.150
     0.528     9.539     0.150
     0.528    17.000     0.150
     0.569     9.977     0.150
     0.622    10.992     0.150
     0.654    11.086     0.150
     0.741    13.359     0.150
     0.741    23.625     0.150
     0.741    25.297     0.150
     0.741    26.625     0.150
     0.829    14.922     0.150
     0.829    26.680     0.150
     1.017    17.430     0.150
     1.017    31.500     0.150
     1.239    21.820     0.150
     1.239    38.969     0.150
     1.321    23.727     0.150
     1.321    42.117     0.150
     1.435    25.500     0.150
     1.435    44.898     0.150
     1.449    26.195     0.150
     1.449    47.352     0.150
     1.481    26.180     0.150
     1.481    46.281     0.150
     1.537    24.648     0.150
     1.537    27.297     0.150
     2.947    47.508     0.150
     3.004    46.891     0.150
     5.263    78.328     0.150
     5.816    85.805     0.150
     5.861    85.898     0.150
     6.275    91.117     0.150
     6.925   133.359     0.150
     6.969   133.719     0.150
     7.631   113.977     0.150
     7.697   147.477     0.150
     8.246   123.648     0.150
     8.378   120.898     0.150
    10.402   149.797     0.150
    10.402   328.039     0.150
    11.198   216.297     0.150
    37.704   436.211     0.150
     0.022     2.498     0.150
     0.022     4.627     0.150
     0.101     3.387     0.150
     0.101     5.168     0.150
     0.416     7.018     0.150
     0.416    13.238     0.150
     0.399     8.207     0.150
     0.399    14.467     0.150
     0.523     9.748     0.150
     0.571    10.158     0.150
     0.612    10.498     0.150
     0.647    11.658     0.150
     0.672    12.178     0.150
     0.731    12.518     0.150
     0.731    21.607     0.150
     0.731    12.172     0.150
     0.759    12.695     0.150
     0.759    23.852     0.150
     0.781    14.217     0.150
     0.784    15.207     0.150
     0.784    26.047     0.150
     0.816    14.650     0.150
     0.919    15.887     0.150
     0.919    28.568     0.150
     1.156    19.520     0.150
     1.261    20.643     0.150
     1.261    36.873     0.150
     1.249    22.088     0.150
     1.285    20.682     0.150
     1.266    22.818     0.150
     1.286    21.857     0.150
     1.356    23.918     0.150
     1.356    40.027     0.150
     1.357    23.967     0.150
     1.399    24.998     0.150
     1.471    25.420     0.150
     1.453    25.658     0.150
     1.622    25.297     0.150
     1.622    29.812     0.150
     1.692    27.514     0.150
     1.692    52.072     0.150
     1.747    27.176     0.150
     1.767    27.582     0.150
     2.062    31.127     0.150
     2.062    64.098     0.150
     2.062    31.576     0.150
     2.075    32.047     0.150
     2.424    36.811     0.150
     2.772    47.176     0.150
     2.896    43.977     0.150
     2.896    88.002     0.150
     3.021    45.777     0.150
     3.076    45.617     0.150
     3.204    47.908     0.150
     3.695    53.668     0.150
     3.734    56.734     0.150
     3.729    53.537     0.150
     4.451    68.158     0.150
     4.451    67.199     0.150
     4.635    70.158     0.150
     4.690    70.588     0.150
     4.873    72.590     0.150
     4.959    74.137     0.150
     4.959   129.887     0.150
     5.298    79.527     0.150
     5.298    79.316     0.150
     5.577    82.568     0.150
     5.577   178.408     0.150
     6.261    90.877     0.150
     6.261   164.947     0.150
     6.261    91.084     0.150
     6.570   100.568     0.150
     6.979   100.971     0.150
     7.310   108.527     0.150
     7.383   107.078     0.150
     7.715   246.838     0.150
     7.814   112.824     0.150
     7.889   118.508     0.150
     9.508   139.357     0.150
    10.359   149.227     0.150
    10.359   325.977     0.150
    11.281   215.727     0.150
    11.533   165.418     0.150
    13.436   195.938     0.150
    15.928   229.037     0.150
    37.801   437.957     0.150
    95.305  1468.188     0.150
   102.696   834.688     0.150
   102.696   845.387     0.150
   102.696  1089.787     0.150
     0.128     2.180     0.150
     0.128     4.090     0.150
     0.142     2.852     0.150
     0.142     4.859     0.150
     0.512     9.332     0.150
     0.590    10.902     0.150
     0.658    12.461     0.150
     0.658    21.930     0.150
     0.641    11.500     0.150
     0.667    12.172     0.150
     0.686    12.422     0.150
     0.734    13.250     0.150
     0.734    23.621     0.150
     0.734    25.031     0.150
     0.781    13.375     0.150
     0.841    14.781     0.150
     0.841    26.609     0.150
     0.825    14.621     0.150
     0.856    14.582     0.150
     0.856    26.141     0.150
     0.856    14.441     0.150
     1.137    20.871     0.150
     1.137    36.629     0.150
     1.126    19.566     0.150
     1.126    34.805     0.150
     1.161    21.109     0.150
     1.161    36.570     0.150
     1.229    21.211     0.150
     1.229    37.781     0.150
     1.249    22.469     0.150
     1.249    39.070     0.150
     1.249    22.520     0.150
     1.249    40.609     0.150
     1.275    23.160     0.150
     1.275    40.551     0.150
     1.333    23.930     0.150
     1.368    22.305     0.150
     1.375    22.785     0.150
     1.642    49.992     0.150
     1.643    26.180     0.150
     1.643    51.055     0.150
     2.065    32.645     0.150
     2.065    63.480     0.150
     2.132    33.039     0.150
     2.132    32.602     0.150
     3.014    49.980     0.150
     3.065    50.070     0.150
     3.258    50.762     0.150
     3.818   102.742     0.150
     4.581    69.602     0.150
     5.423    80.961     0.150
     5.483    82.262     0.150
     5.984   114.871     0.150
     6.050    89.992     0.150
     6.354    93.039     0.150
     6.601    99.148     0.150
     6.691   102.051     0.150
     7.440   108.902     0.150
     7.832   246.781     0.150
     8.018   119.672     0.150
     8.439   125.656     0.150
     8.439   265.754     0.150
    10.421   150.480     0.150
    10.421   330.949     0.150
    11.402   168.129     0.150
     0.142     2.789     0.150
     0.129     2.178     0.150
     0.129     4.799     0.150
     0.658    12.549     0.150
     0.658    21.588     0.150
     0.734    13.209     0.150
     0.734    25.619     0.150
     0.781    13.348     0.150
     0.840    14.818     0.150
     0.840    26.309     0.150
     0.856    14.459     0.150
     0.856    25.510     0.150
     0.856    14.949     0.150
     0.856    26.598     0.150
     1.127    19.572     0.150
     1.127    34.709     0.150
     1.137    20.848     0.150
     1.137    36.289     0.150
     1.161    21.068     0.150
     1.161    36.508     0.150
     1.248    22.498     0.150
     1.248    38.898     0.150
     1.229    21.988     0.150
     1.229    38.078     0.150
     1.249    22.498     0.150
     1.249    39.529     0.150
     1.276    23.178     0.150
     1.276    40.258     0.150
     1.375    22.664     0.150
     1.375    39.838     0.150
     1.334    23.869     0.150
     1.334    41.959     0.150
     1.369    22.188     0.150
     1.643    25.953     0.150
     1.643    46.480     0.150
     1.643    51.979     0.150
     1.642    27.359     0.150
     1.806    28.441     0.150
     1.867    29.594     0.150
     2.066    32.561     0.150
     2.066    63.459     0.150
     2.132    32.932     0.150
     2.132    32.789     0.150
     2.132    66.059     0.150
     2.247    35.156     0.150
     2.508    38.535     0.150
     2.786    43.928     0.150
     2.776    42.832     0.150
     2.853    86.195     0.150
     2.894    87.645     0.150
     3.015    47.828     0.150
     3.066    50.158     0.150
     3.182    48.070     0.150
     3.213    97.416     0.150
     3.258    50.998     0.150
     3.688    56.148     0.150
     3.818    58.178     0.150
     3.818   101.439     0.150
     4.207    63.729     0.150
     4.279    65.248     0.150
     4.410    66.799     0.150
     4.581    68.559     0.150
     4.715    71.998     0.150
     4.962    74.738     0.150
     4.962   131.389     0.150
     5.423    80.189     0.150
     5.692    85.109     0.150
     5.985   115.029     0.150
     6.051    89.529     0.150
     6.051   192.959     0.150
     6.546    95.979     0.150
     6.546   169.729     0.150
     6.601   122.592     0.150
     6.691    99.229     0.150
     7.217   105.758     0.150
     7.738   145.738     0.150
     7.831   114.029     0.150
     7.831   244.053     0.150
     8.139   155.648     0.150
     8.439   121.828     0.150
     8.439   125.854     0.150
     9.638   142.018     0.150
    10.421   150.703     0.150
    10.632   152.049     0.150
    11.402   168.750     0.150
    16.017   227.949     0.150
    37.859   439.064     0.150
     0.073     2.004     0.150
     0.073     2.883     0.150
     0.366     6.934     0.150
     0.719    24.184     0.150
     0.744    12.898     0.150
     0.784    13.238     0.150
     0.784    23.652     0.150
     0.898    16.895     0.150
     1.118    19.445     0.150
     1.237    21.613     0.150
     1.317    23.863     0.150
     1.317    41.043     0.150
     1.318    23.512     0.150
     1.307    21.301     0.150
     1.326    21.734     0.150
     1.326    39.164     0.150
     1.609    25.512     0.150
     1.646    27.395     0.150
     1.646    50.988     0.150
     2.047    32.133     0.150
     2.114    32.324     0.150
     2.157    38.285     0.150
     2.157    65.133     0.150
     2.191    34.227     0.150
     2.719    43.113     0.150
     2.719    73.113     0.150
     2.994    55.203     0.150
     2.994    93.812     0.150
     3.048    47.312     0.150
     3.208    60.523     0.150
     3.399    57.711     0.150
     3.788    56.133     0.150
     3.788   120.734     0.150
     3.799    57.738     0.150
     4.141    62.652     0.150
     4.141   132.875     0.150
     4.363    84.652     0.150
     4.514    68.289     0.150
     4.746    70.805     0.150
     4.940    73.227     0.150
     5.364    80.172     0.150
     5.364    79.652     0.150
     5.928    85.895     0.150
     5.986    87.332     0.150
     6.321    92.543     0.150
     6.619    96.543     0.150
     7.171   104.785     0.150
     7.374   109.289     0.150
     7.374   108.172     0.150
     7.479   109.164     0.150
     7.779   113.465     0.150
     7.780   114.965     0.150
     8.373   123.387     0.150
     8.373   267.387     0.150
     8.412   120.770     0.150
    10.409   149.762     0.150
    10.409   329.164     0.150
    10.901   155.922     0.150
    11.051   159.703     0.150
    15.954   227.387     0.150
    16.803   232.992     0.150
    22.941   304.188     0.150
    86.130   759.414     0.150
    95.297   802.113     0.150
    95.297  1033.113     0.150
    95.297  1473.113     0.150
    95.297  1481.414     0.150
   101.346   830.613     0.150
   101.346   835.613     0.150
   102.691   835.914     0.150
   102.691   839.113     0.150
     0.144     2.531     0.150
     0.144     4.742     0.150
     0.160     3.164     0.150
     0.160     5.531     0.150
     0.289     5.602     0.150
     0.289    10.359     0.150
     0.644    11.734     0.150
     0.677    12.281     0.150
     0.699    12.422     0.150
     0.791    13.734     0.150
     0.791    24.039     0.150
     0.827    14.898     0.150
     0.873    14.859     0.150
     0.873    27.133     0.150
     1.129    19.758     0.150
     1.129    35.297     0.150
     1.154    21.102     0.150
     1.227    21.859     0.150
     1.227    38.117     0.150
     1.232    22.414     0.150
     1.232    39.102     0.150
     1.384    22.539     0.150
     1.384    43.016     0.150
     1.387    22.961     0.150
     1.387    42.164     0.150
     1.642    27.805     0.150
     1.652    26.539     0.150
     1.652    51.539     0.150
     1.652    26.852     0.150
     1.652    50.312     0.150
     1.611    26.273     0.150
     1.611    49.742     0.150
     1.819    54.719     0.150
     1.883    30.164     0.150
     2.070    32.938     0.150
     2.137    33.531     0.150
     2.137    66.430     0.150
     2.137    33.289     0.150
     2.245    35.406     0.150
     2.262    35.594     0.150
     2.262    66.172     0.150
     2.403    68.703     0.150
     2.522    39.703     0.150
     2.522    71.656     0.150
     2.552    40.594     0.150
     2.544    40.109     0.150
     2.782    43.562     0.150
     2.782    85.578     0.150
     2.802    44.008     0.150
     2.852    44.445     0.150
     2.895    44.906     0.150
     3.019    48.047     0.150
     3.070    48.750     0.150
     3.270    50.312     0.150
     3.692    57.602     0.150
     3.826    56.461     0.150
     3.875    59.000     0.150
     4.188    62.773     0.150
     4.223    63.930     0.150
     4.597    68.812     0.150
     4.597    69.664     0.150
     5.009    74.742     0.150
     5.438    81.492     0.150
     5.500    81.773     0.150
     5.998    88.430     0.150
     6.066    89.312     0.150
     6.362    93.133     0.150
     6.613    98.688     0.150
     6.708   102.148     0.150
     7.074   108.430     0.150
     7.096   106.828     0.150
     7.153   104.328     0.150
     7.455   110.922     0.150
     7.850   115.969     0.150
     7.844   115.539     0.150
     7.844   249.617     0.150
     8.032   118.242     0.150
     8.097   122.141     0.150
     8.275   122.328     0.150
     8.455   124.992     0.150
     8.455   268.312     0.150
     8.752   130.023     0.150
     9.700   143.562     0.150
     9.696   144.031     0.150
     9.782   145.953     0.150
    10.425   152.094     0.150
    10.425   330.828     0.150
    10.853   158.422     0.150
    10.989   161.867     0.150
    11.420   167.188     0.150
    12.680   184.484     0.150
    13.365   193.070     0.150
    14.758   213.172     0.150
    15.126   216.844     0.150
    15.163   216.000     0.150
    15.250   220.203     0.150
    15.474   224.344     0.150
    16.032   228.938     0.150
    16.032   230.594     0.150
    16.834   236.648     0.150
    18.277   255.891     0.150
    20.984   285.500     0.150
    21.723   292.367     0.150
    23.013   307.398     0.150
    23.029   308.219     0.150
    28.007   353.969     0.150
    30.239   373.633     0.150
    37.584   437.391     0.150
    37.871   439.938     0.150
    60.362   611.391     0.150
    62.815   628.438     0.150
    63.212   631.289     0.150
    77.358   716.812     0.150
    81.489   740.266     0.150
   119.199  1132.281     0.150
     0.148     2.672     0.150
     0.162     3.211     0.150
     0.162     5.297     0.150
     0.222     4.711     0.150
     0.284     4.820     0.150
     0.305     6.961     0.150
     0.538    10.148     0.150
     0.524     9.641     0.150
     0.549    10.672     0.150
     0.565    10.609     0.150
     0.611    11.109     0.150
     0.611    11.383     0.150
     0.611    21.453     0.150
     0.650    11.773     0.150
     0.698    12.406     0.150
     0.683    12.492     0.150
     0.796    13.797     0.150
     0.796    25.672     0.150
     0.837    14.977     0.150
     0.876    15.398     0.150
     0.876    28.602     0.150
     0.876    14.812     0.150
     0.876    26.758     0.150
     1.135    19.891     0.150
     1.135    35.234     0.150
     1.158    21.719     0.150
     1.228    22.359     0.150
     1.228    39.656     0.150
     1.228    22.508     0.150
     1.232    22.562     0.150
     1.232    35.461     0.150
     1.262    23.633     0.150
     1.386    22.867     0.150
     1.386    40.914     0.150
     1.389    22.758     0.150
     1.614    25.906     0.150
     1.614    46.633     0.150
     1.646    27.539     0.150
     1.646    48.625     0.150
     1.657    26.797     0.150
     1.657    26.500     0.150
     1.824    28.797     0.150
     1.888    29.945     0.150
     2.076    32.953     0.150
     2.076    59.578     0.150
     2.133    33.164     0.150
     2.133    33.547     0.150
     2.133    61.000     0.150
     2.248    34.898     0.150
     2.261    35.242     0.150
     2.527    38.781     0.150
     2.556    39.594     0.150
     2.788    43.164     0.150
     2.806    44.469     0.150
     2.832    43.133     0.150
     2.857    44.023     0.150
     2.900    44.406     0.150
     2.961    45.383     0.150
     3.025    46.602     0.150
     3.058    45.914     0.150
     3.075    48.477     0.150
     3.075    85.469     0.150
     3.223    48.523     0.150
     3.275    49.797     0.150
     3.275    49.195     0.150
     3.443    51.820     0.150
     3.698    55.398     0.150
     3.698    55.742     0.150
     3.711    55.289     0.150
     3.767    55.938     0.150
     3.822    56.797     0.150
     4.026    59.875     0.150
     4.193    62.445     0.150
     4.228    63.180     0.150
     4.228    81.547     0.150
     4.283    62.992     0.150
     4.292    64.203     0.150
     4.292    63.453     0.150
     4.383    64.930     0.150
     4.427    65.797     0.150
     4.598    69.398     0.150
     4.586    68.289     0.150
     4.734    71.898     0.150
     4.734    71.281     0.150
     4.751    70.641     0.150
     4.953    75.047     0.150
     4.953   133.344     0.150
     4.952    73.883     0.150
     5.014    75.523     0.150
     5.198    76.555     0.150
     5.184    77.328     0.150
     5.350    79.664     0.150
     5.437    81.055     0.150
     5.437    81.219     0.150
     5.504    82.672     0.150
     5.602    84.359     0.150
     5.602   148.859     0.150
     5.713    85.398     0.150
     6.003    90.398     0.150
     6.071    89.805     0.150
     6.086    89.883     0.150
     6.360    92.984     0.150
     6.360   166.703     0.150
     6.545    97.109     0.150
     6.577    96.289     0.150
     6.577   168.859     0.150
     6.619   100.414     0.150
     6.771   101.602     0.150
     7.102   105.297     0.150
     7.227   105.758     0.150
     7.250   105.844     0.150
     7.456   110.789     0.150
     7.536   109.992     0.150
     7.759   116.398     0.150
     7.843   116.203     0.150
     7.843   114.578     0.150
     7.853   116.500     0.150
     7.890   116.297     0.150
     7.890   203.297     0.150
     8.033   116.867     0.150
     8.160   122.398     0.150
     8.160   120.430     0.150
     8.278   124.281     0.150
     8.292   125.000     0.150
     8.323   121.727     0.150
     8.443   121.672     0.150
     8.443   121.219     0.150
     8.459   123.602     0.150
     8.552   124.438     0.150
     8.533   126.148     0.150
     8.743   126.945     0.150
     8.755   131.000     0.150
     8.829   131.359     0.150
     8.836   128.930     0.150
     8.836   129.047     0.150
     8.877   133.461     0.150
     8.988   130.750     0.150
     9.219   131.719     0.150
     9.256   134.594     0.150
     9.249   137.656     0.150
     9.249   137.469     0.150
     9.263   134.703     0.150
     9.356   136.109     0.150
     9.366   136.023     0.150
     9.462   136.375     0.150
     9.491   137.414     0.150
     9.549   137.594     0.150
     9.656   141.938     0.150
     9.669   137.562     0.150
     9.698   141.461     0.150
     9.698   143.188     0.150
     9.704   143.203     0.150
     9.714   140.328     0.150
     9.739   141.625     0.150
     9.853   145.258     0.150
     9.786   143.594     0.150
     9.857   142.031     0.150
     9.901   142.734     0.150
     9.924   144.047     0.150
    10.012   144.406     0.150
    10.064   146.438     0.150
    10.155   147.359     0.150
    10.179   147.641     0.150
    10.191   148.000     0.150
    10.234   149.820     0.150
    10.400   151.914     0.150
    10.407   151.484     0.150
    10.420   150.703     0.150
    10.446   152.453     0.150
    10.526   154.258     0.150
    10.577   154.180     0.150
    10.618   154.031     0.150
    10.640   153.953     0.150
    10.747   156.820     0.150
    10.768   154.938     0.150
    10.801   156.969     0.150
    10.833   155.938     0.150
    10.835   158.055     0.150
    10.854   157.977     0.150
    10.911   157.695     0.150
    10.917   157.945     0.150
    10.929   160.797     0.150
    10.956   159.883     0.150
    10.993   159.211     0.150
    11.069   159.758     0.150
    11.074   161.500     0.150
    11.089   162.148     0.150
    11.097   161.258     0.150
    11.110   161.352     0.150
    11.144   163.898     0.150
    11.144   286.500     0.150
    11.144   165.094     0.150
    11.170   162.367     0.150
    11.179   160.797     0.150
    11.296   163.078     0.150
    11.296   166.109     0.150
    11.349   164.367     0.150
    11.355   164.680     0.150
    11.380   166.359     0.150
    11.391   166.203     0.150
    11.397   166.062     0.150
    11.401   164.516     0.150
    11.403   166.000     0.150
    11.422   166.430     0.150
    11.423   166.969     0.150
    11.423   167.195     0.150
    11.441   165.617     0.150
    11.469   166.664     0.150
    11.486   165.703     0.150
    11.513   167.352     0.150
    11.544   167.125     0.150
    11.535   168.117     0.150
    11.557   166.852     0.150
    11.559   167.734     0.150
    11.565   166.055     0.150
    11.576   167.297     0.150
    11.653   167.148     0.150
    11.656   168.625     0.150
    11.720   168.508     0.150
    11.843   171.484     0.150
    11.879   171.461     0.150
    11.877   173.672     0.150
    11.942   172.914     0.150
    11.953   174.789     0.150
    11.953   174.797     0.150
    11.953   175.078     0.150
    11.971   172.320     0.150
    11.975   173.164     0.150
    11.977   177.633     0.150
    12.031   174.953     0.150
    12.032   174.156     0.150
    12.040   172.984     0.150
    12.042   172.625     0.150
    12.090   174.367     0.150
    12.109   175.617     0.150
    12.116   174.961     0.150
    12.102   178.148     0.150
    12.137   174.805     0.150
    12.154   176.641     0.150
    12.187   176.391     0.150
    12.207   176.930     0.150
    12.209   178.727     0.150
    12.201   178.211     0.150
    12.255   176.641     0.150
    12.301   178.172     0.150
    12.318   177.750     0.150
    12.399   180.289     0.150
    12.424   180.211     0.150
    12.441   180.617     0.150
    12.444   180.172     0.150
    12.480   180.125     0.150
    12.508   180.531     0.150
    12.516   180.297     0.150
    12.567   181.297     0.150
    12.595   181.398     0.150
    12.599   181.180     0.150
    12.609   181.562     0.150
    12.611   181.266     0.150
    12.641   181.672     0.150
    12.658   183.430     0.150
    12.658   185.359     0.150
    12.673   183.336     0.150
    12.690   182.359     0.150
    12.684   184.570     0.150
    12.709   182.695     0.150
    12.720   183.086     0.150
    12.746   184.422     0.150
    12.777   185.117     0.150
    12.796   184.211     0.150
    12.796   183.680     0.150
    12.801   183.484     0.150
    12.792   186.102     0.150
    12.819   184.781     0.150
    12.805   188.312     0.150
    12.824   185.180     0.150
    12.834   185.844     0.150
    12.871   184.875     0.150
    12.921   187.023     0.150
    12.948   187.086     0.150
    12.945   188.445     0.150
    12.967   185.445     0.150
    12.970   186.711     0.150
    13.009   186.836     0.150
    13.012   188.070     0.150
    13.059   187.852     0.150
    13.048   190.039     0.150
    13.083   187.891     0.150
    13.109   188.406     0.150
    13.117   188.852     0.150
    13.129   188.820     0.150
    13.146   189.688     0.150
    13.166   189.203     0.150
    13.229   189.156     0.150
    13.259   190.148     0.150
    13.280   190.117     0.150
    13.288   191.375     0.150
    13.291   190.617     0.150
    13.295   190.344     0.150
    13.325   192.453     0.150
    13.326   193.172     0.150
    13.350   192.398     0.150
    13.353   191.969     0.150
    13.362   191.602     0.150
    13.363   193.328     0.150
    13.365   192.156     0.150
    13.389   192.547     0.150
    13.402   192.164     0.150
    13.406   192.195     0.150
    13.434   193.055     0.150
    13.445   196.883     0.150
    13.466   193.984     0.150
    13.510   194.547     0.150
    13.511   194.492     0.150
    13.527   197.938     0.150
    13.560   193.484     0.150
    13.603   195.062     0.150
    13.654   196.188     0.150
    13.666   195.375     0.150
    13.664   195.406     0.150
    13.678   195.406     0.150
    13.717   196.969     0.150
    13.717   194.438     0.150
    13.717   349.977     0.150
    13.724   196.875     0.150
    13.734   197.422     0.150
    13.739   196.938     0.150
    13.770   197.352     0.150
    13.772   198.422     0.150
    13.823   197.664     0.150
    13.843   197.766     0.150
    13.847   198.766     0.150
    13.865   199.789     0.150
    13.883   199.547     0.150
    13.900   198.672     0.150
    13.910   198.953     0.150
    13.911   199.109     0.150
    13.918   199.555     0.150
    13.921   199.695     0.150
    13.950   199.398     0.150
    13.945   203.438     0.150
    13.963   199.312     0.150
    13.992   200.398     0.150
    14.022   200.414     0.150
    14.054   201.562     0.150
    14.076   201.094     0.150
    14.079   201.250     0.150
    14.080   201.289     0.150
    14.097   201.664     0.150
    14.128   202.242     0.150
    14.150   203.352     0.150
    14.185   202.984     0.150
    14.188   200.289     0.150
    14.207   203.070     0.150
    14.215   203.086     0.150
    14.234   203.609     0.150
    14.245   202.750     0.150
    14.286   203.867     0.150
    14.290   203.148     0.150
    14.302   203.148     0.150
    14.325   204.273     0.150
    14.328   205.406     0.150
    14.329   205.766     0.150
    14.384   205.359     0.150
    14.383   206.148     0.150
    14.428   206.422     0.150
    14.461   205.891     0.150
    14.461   209.672     0.150
    14.504   207.648     0.150
    14.541   207.172     0.150
    14.542   207.000     0.150
    14.542   207.555     0.150
    14.550   206.773     0.150
    14.565   207.617     0.150
    14.579   207.734     0.150
    14.579   208.797     0.150
    14.597   207.695     0.150
    14.603   208.086     0.150
    14.600   208.711     0.150
    14.641   208.492     0.150
    14.644   208.000     0.150
    14.653   208.633     0.150
    14.661   208.023     0.150
    14.678   209.062     0.150
    14.702   209.781     0.150
    14.723   212.109     0.150
    14.769   210.625     0.150
    14.782   210.602     0.150
    14.789   210.562     0.150
    14.799   210.281     0.150
    14.820   210.078     0.150
    14.812   215.781     0.150
    14.827   210.109     0.150
    14.827   211.828     0.150
    14.836   210.344     0.150
    14.843   210.102     0.150
    14.856   210.852     0.150
    14.873   211.672     0.150
    14.877   211.352     0.150
    14.938   212.711     0.150
    15.014   213.516     0.150
    15.033   213.367     0.150
    15.032   213.789     0.150
    15.056   212.070     0.150
    15.089   213.844     0.150
    15.115   214.086     0.150
    15.123   213.945     0.150
    15.123   213.383     0.150
    15.123   377.102     0.150
    15.143   214.547     0.150
    15.161   214.758     0.150
    15.164   214.578     0.150
    15.177   216.023     0.150
    15.181   215.617     0.150
    15.195   216.406     0.150
    15.216   215.398     0.150
    15.235   216.055     0.150
    15.247   216.180     0.150
    15.246   216.227     0.150
    15.263   216.891     0.150
    15.269   216.547     0.150
    15.314   217.570     0.150
    15.328   217.484     0.150
    15.327   220.000     0.150
    15.342   217.406     0.150
    15.343   217.266     0.150
    15.345   217.516     0.150
    15.361   217.398     0.150
    15.372   217.203     0.150
    15.402   218.391     0.150
    15.446   218.266     0.150
    15.460   219.172     0.150
    15.535   220.031     0.150
    15.591   220.734     0.150
    15.603   219.992     0.150
    15.647   220.266     0.150
    15.665   221.742     0.150
    15.697   220.445     0.150
    15.699   221.211     0.150
    15.700   221.234     0.150
    15.704   221.562     0.150
    15.714   221.055     0.150
    15.717   224.008     0.150
    15.720   221.781     0.150
    15.732   222.102     0.150
    15.761   222.578     0.150
    15.785   222.258     0.150
    15.817   222.727     0.150
    15.852   221.867     0.150
    15.854   221.547     0.150
    15.861   222.375     0.150
    15.867   223.000     0.150
    15.865   223.062     0.150
    15.872   222.922     0.150
    15.883   222.719     0.150
    15.908   223.258     0.150
    15.941   224.109     0.150
    15.951   223.734     0.150
    15.996   225.328     0.150
    16.037   228.758     0.150
    16.037   226.125     0.150
    16.065   225.281     0.150
    16.086   226.328     0.150
    16.090   224.789     0.150
    16.119   227.938     0.150
    16.152   226.836     0.150
    16.162   228.273     0.150
    16.189   227.852     0.150
    16.205   228.742     0.150
    16.289   230.180     0.150
    16.317   229.961     0.150
    16.335   230.586     0.150
    16.394   230.219     0.150
    16.395   230.695     0.150
    16.399   230.000     0.150
    16.394   231.695     0.150
    16.415   231.258     0.150
    16.418   231.547     0.150
    16.458   230.844     0.150
    16.506   231.078     0.150
    16.515   230.453     0.150
    16.560   232.180     0.150
    16.582   234.438     0.150
    16.606   233.938     0.150
    16.630   233.875     0.150
    16.639   233.984     0.150
    16.654   234.180     0.150
    16.697   236.102     0.150
    16.707   235.797     0.150
    16.743   235.961     0.150
    16.764   235.820     0.150
    16.899   238.141     0.150
    16.975   237.297     0.150
    16.984   238.820     0.150
    17.016   238.414     0.150
    17.020   238.727     0.150
    17.030   238.336     0.150
    17.032   238.703     0.150
    17.035   240.633     0.150
    17.049   239.289     0.150
    17.063   238.766     0.150
    17.063   239.031     0.150
    17.063   241.031     0.150
    17.096   239.016     0.150
    17.266   242.859     0.150
    17.276   242.953     0.150
    17.312   243.570     0.150
    17.315   243.203     0.150
    17.347   244.297     0.150
    17.358   244.992     0.150
    17.455   245.109     0.150
    17.481   244.602     0.150
    17.481   438.656     0.150
    17.492   245.477     0.150
    17.497   245.945     0.150
    17.512   247.273     0.150
    17.512   438.461     0.150
    17.578   246.578     0.150
    17.585   246.602     0.150
    17.602   253.148     0.150
    17.624   246.828     0.150
    17.642   246.570     0.150
    17.647   247.281     0.150
    17.659   246.906     0.150
    17.723   248.273     0.150
    17.812   254.039     0.150
    17.852   249.938     0.150
    17.938   250.992     0.150
    17.952   251.047     0.150
    17.954   251.344     0.150
    18.062   253.367     0.150
    18.135   254.531     0.150
    18.160   254.617     0.150
    18.178   255.148     0.150
    18.210   254.562     0.150
    18.227   254.938     0.150
    18.423   257.633     0.150
    18.435   257.641     0.150
    18.478   258.445     0.150
    18.603   258.484     0.150
    18.654   259.914     0.150
    18.663   259.328     0.150
    18.682   260.930     0.150
    18.878   262.445     0.150
    18.984   263.547     0.150
    19.008   263.922     0.150
    19.033   264.164     0.150
    19.294   267.195     0.150
    19.344   282.883     0.150
    19.361   272.789     0.150
    19.376   268.406     0.150
    19.379   271.289     0.150
    19.430   277.773     0.150
    19.440   272.680     0.150
    19.475   267.953     0.150
    19.598   269.633     0.150
    19.709   270.422     0.150
    19.735   270.539     0.150
    19.777   273.000     0.150
    19.780   267.438     0.150
    19.833   277.711     0.150
    20.025   273.211     0.150
    20.102   275.219     0.150
    20.164   275.188     0.150
    20.365   279.023     0.150
    20.558   279.469     0.150
    20.624   280.484     0.150
    20.988   283.695     0.150
    21.032   290.406     0.150
    21.044   288.883     0.150
    21.238   292.508     0.150
    21.515   288.273     0.150
    21.710   291.867     0.150
    21.716   292.500     0.150
    21.725   292.672     0.150
    21.985   295.930     0.150
    22.189   300.969     0.150
    23.031   306.398     0.150
    23.560   315.242     0.150
    23.815   313.812     0.150
    23.860   316.797     0.150
    24.046   316.258     0.150
    24.398   319.188     0.150
    24.556   319.648     0.150
    24.556   579.547     0.150
    25.386   332.719     0.150
    26.305   337.828     0.150
    26.898   342.227     0.150
    28.012   354.062     0.150
    28.012   352.273     0.150
    28.323   354.648     0.150
    28.400   358.344     0.150
    28.977   359.797     0.150
    28.977   654.203     0.150
    29.439   656.898     0.150
    29.490   364.992     0.150
    29.490   653.789     0.150
    30.054   375.203     0.150
    30.054   692.398     0.150
    30.243   373.094     0.150
    30.667   374.773     0.150
    31.799   384.961     0.150
    31.799   693.156     0.150
    32.582   391.641     0.150
    32.582   700.898     0.150
    34.032   402.852     0.150
    34.032   727.609     0.150
    35.123   419.891     0.150
    35.531   418.602     0.150
    35.531   756.203     0.150
    35.705   418.000     0.150
    35.705   752.500     0.150
    35.876   424.297     0.150
    35.876   759.297     0.150
    35.930   425.102     0.150
    36.270   427.992     0.150
    36.270   428.992     0.150
    36.270   793.203     0.150
    36.689   428.781     0.150
    36.705   433.930     0.150
    36.730   429.773     0.150
    36.849   435.320     0.150
    37.258   437.242     0.150
    37.395   440.609     0.150
    37.463   437.523     0.150
    37.589   437.008     0.150
    37.713   440.398     0.150
    37.713   804.703     0.150
    37.876   439.352     0.150
    38.032   437.109     0.150
    39.417   448.703     0.150
    40.055   459.820     0.150
    40.055   453.688     0.150
    40.407   461.828     0.150
    40.490   458.141     0.150
    40.679   462.117     0.150
    41.551   467.391     0.150
    42.054   471.648     0.150
    42.054   845.477     0.150
    42.282   480.094     0.150
    42.774   478.875     0.150
    43.153   478.859     0.150
    43.493   484.922     0.150
    43.493     1.172     0.150
    43.677   872.797     0.150
    43.677   486.578     0.150
    43.785   490.273     0.150
    44.178   492.820     0.150
    44.210   488.180     0.150
    44.691   494.477     0.150
    45.225   500.773     0.150
    45.302   495.742     0.150
    45.457   498.789     0.150
    45.515   499.148     0.150
    45.607   498.781     0.150
    45.653   503.656     0.150
    45.805   501.320     0.150
    45.805   903.711     0.150
    45.827   509.281     0.150
    45.922   502.180     0.150
    45.930   502.398     0.150
    46.040   506.133     0.150
    46.062   502.977     0.150
    46.197   510.352     0.150
    46.423   510.422     0.150
    46.423   510.141     0.150
    46.771   512.273     0.150
    46.786   508.023     0.150
    46.786   598.367     0.150
    46.786   917.391     0.150
    46.794   514.992     0.150
    46.822   510.180     0.150
    46.822   620.297     0.150
    46.992   515.727     0.150
    47.120   515.859     0.150
    47.141   516.742     0.150
    47.147   516.703     0.150
    47.147   928.688     0.150
    47.175   511.227     0.150
    47.175   929.180     0.150
    47.176   515.891     0.150
    47.312   516.961     0.150
    47.278   932.602     0.150
    47.321   518.500     0.150
    47.395   516.656     0.150
    47.395   514.227     0.150
    47.395   604.898     0.150
    47.395   925.883     0.150
    47.592   519.148     0.150
    47.599   519.594     0.150
    47.609   515.227     0.150
    48.055   517.398     0.150
    49.718   530.656     0.150
    49.780   538.148     0.150
    50.165   532.781     0.150
    50.165   963.828     0.150
    50.817   542.898     0.150
    50.877   543.070     0.150
    50.877   544.500     0.150
    51.099   547.703     0.150
    52.095   548.898     0.150
    52.095   988.102     0.150
    52.981   556.391     0.150
    52.981  1005.781     0.150
    53.576   562.500     0.150
    54.223   564.406     0.150
    55.617   578.898     0.150
    55.617   576.594     0.150
    56.136   582.398     0.150
    56.136   641.703     0.150
    59.443   608.758     0.150
    60.365   610.000     0.150
    60.365  1120.898     0.150
    61.632   620.703     0.150
    62.698   664.000     0.150
    62.698  1151.898     0.150
    62.821   628.086     0.150
    62.949   627.734     0.150
    63.218   631.227     0.150
    64.223  1158.398     0.150
    64.413   635.969     0.150
    64.960   642.500     0.150
    64.960   781.500     0.150
    64.960  1166.500     0.150
    65.028   639.703     0.150
    65.028   639.469     0.150
    65.051   646.609     0.150
    66.106   648.297     0.150
    66.106   651.570     0.150
    66.186   651.258     0.150
    66.910   655.398     0.150
    66.912   656.562     0.150
    68.302   667.000     0.150
    68.524   667.000     0.150
    68.592   667.602     0.150
    68.592  1210.203     0.150
    68.647   668.703     0.150
    68.689   666.320     0.150
    68.736   668.203     0.150
    69.349   673.750     0.150
    70.315  1224.852     0.150
    70.768   681.797     0.150
    70.768  1229.297     0.150
    70.842   684.000     0.150
    70.890   674.297     0.150
    71.180   684.703     0.150
    71.558   683.500     0.150
    71.600   685.602     0.150
    71.600  1239.898     0.150
    72.259  1249.000     0.150
    72.564     2.703     0.150
    72.564   848.797     0.150
    72.564  1302.898     0.150
    72.564   688.258     0.150
    72.564  1251.031     0.150
    72.928   691.789     0.150
    73.023   694.367     0.150
    73.094   696.680     0.150
    73.512   698.711     0.150
    73.545   697.492     0.150
    73.677   697.297     0.150
    73.956   698.609     0.150
    74.001   699.383     0.150
    74.094   702.648     0.150
    74.090   716.000     0.150
    74.090   864.398     0.150
    74.090  1563.102     0.150
    74.239   702.680     0.150
    74.269   701.578     0.150
    74.417   701.188     0.150
    74.519   701.672     0.150
    74.518   701.000     0.150
    74.518     4.000     0.150
    74.518   717.500     0.150
    74.546   701.023     0.150
    74.546   703.258     0.150
    74.609   703.070     0.150
    74.606   701.750     0.150
    74.648   700.898     0.150
    74.648   699.141     0.150
    74.686   704.477     0.150
    74.810   704.852     0.150
    74.956   699.539     0.150
    75.042   704.523     0.150
    75.060   705.844     0.150
    75.092   707.289     0.150
    75.104   706.328     0.150
    75.117   704.680     0.150
    75.215   709.352     0.150
    75.216   705.273     0.150
    75.297   703.000     0.150
    75.297   707.961     0.150
    75.412   708.680     0.150
    75.470   708.570     0.150
    75.509   707.352     0.150
    75.598   709.852     0.150
    75.715   709.531     0.150
    75.844   711.758     0.150
    75.893   712.148     0.150
    75.909   709.812     0.150
    76.025   714.156     0.150
    76.074   710.180     0.150
    76.077   706.867     0.150
    76.077   874.656     0.150
    76.168   712.617     0.150
    76.458   716.070     0.150
    76.514   714.703     0.150
    76.728   716.000     0.150
    76.757   715.258     0.150
    76.824   712.367     0.150
    76.845   716.672     0.150
    76.986   717.672     0.150
    77.091   718.688     0.150
    77.285   718.070     0.150
    77.318   719.117     0.150
    77.359   719.039     0.150
    77.361   718.133     0.150
    77.507   718.500     0.150
    77.549   720.008     0.150
    77.626   719.500     0.150
    77.626   718.383     0.150
    77.691   719.211     0.150
    77.712   720.500     0.150
    77.712  1317.500     0.150
    77.736   719.203     0.150
    77.736   728.000     0.150
    77.736   733.102     0.150
    77.736   890.398     0.150
    77.736  1313.297     0.150
    77.736  1615.602     0.150
    77.762   721.938     0.150
    77.785   723.039     0.150
    77.804   722.312     0.150
    77.814   721.938     0.150
    77.905   722.367     0.150
    77.981   723.461     0.150
    78.025   722.922     0.150
    78.054   721.797     0.150
    78.054     3.500     0.150
    78.054   726.703     0.150
    78.054   731.297     0.150
    78.054   898.102     0.150
    78.054  1317.000     0.150
    78.054  1341.797     0.150
    78.054  1619.500     0.150
    78.347   724.211     0.150
    78.654   726.219     0.150
    79.359   724.898     0.150
    79.359  1342.297     0.150
    79.411   727.398     0.150
    79.701   734.578     0.150
    79.722   729.203     0.150
    79.842   729.703     0.150
    79.880   735.102     0.150
    79.913   734.008     0.150
    80.047   733.281     0.150
    80.274   736.797     0.150
    80.539   737.703     0.150
    80.568   737.398     0.150
    80.613   734.297     0.150
    80.652   734.602     0.150
    80.843   732.602     0.150
    80.904   739.500     0.150
    80.905   735.797     0.150
    80.983   737.602     0.150
    81.009   737.703     0.150
    81.188   736.898     0.150
    81.220   738.797     0.150
    81.222   740.500     0.150
    81.299   741.398     0.150
    81.347   742.500     0.150
    81.451   740.602     0.150
    81.496   743.500     0.150
    81.493   740.258     0.150
    81.526   741.203     0.150
    81.535   741.703     0.150
    81.568   741.758     0.150
    81.568  1353.289     0.150
    81.568   744.297     0.150
    81.612   741.102     0.150
    81.612   930.000     0.150
    81.612  1357.297     0.150
    81.620   743.602     0.150
    81.686   745.438     0.150
    81.703   745.297     0.150
    81.742   742.297     0.150
    81.844   741.531     0.150
    81.879   743.898     0.150
    82.015   743.906     0.150
    82.015  1379.547     0.150
    82.108   742.398     0.150
    82.138   744.500     0.150
    82.151   742.398     0.150
    82.204   744.602     0.150
    82.269   744.789     0.150
    82.279   746.797     0.150
    82.279  1377.898     0.150
    82.305   745.359     0.150
    82.313   747.398     0.150
    82.308   744.023     0.150
    82.335   744.203     0.150
    82.373   743.797     0.150
    82.386   745.391     0.150
    82.403   744.203     0.150
    82.445   746.430     0.150
    82.445  1380.383     0.150
    82.445  1675.430     0.150
    82.479   747.797     0.150
    82.511   746.398     0.150
    82.586   745.727     0.150
    82.591   746.203     0.150
    82.591  1370.297     0.150
    82.669   747.398     0.150
    82.669  1364.844     0.150
    82.669   749.602     0.150
    82.681   749.602     0.150
    82.696   747.367     0.150
    82.696  1365.828     0.150
    82.696   749.203     0.150
    82.906   748.898     0.150
    83.027   749.797     0.150
    83.027   752.398     0.150
    83.027  1372.297     0.150
    83.034   748.039     0.150
    83.035   747.500     0.150
    83.072   749.703     0.150
    83.088   749.203     0.150
    83.179   748.000     0.150
    83.201   752.797     0.150
    83.233   750.797     0.150
    83.247   752.203     0.150
    83.247  1388.000     0.150
    83.302   750.359     0.150
    83.388   747.023     0.150
    83.388  1374.094     0.150
    83.566   749.898     0.150
    83.577   751.398     0.150
    83.600   749.898     0.150
    83.672   752.398     0.150
    83.690   750.703     0.150
    83.754   750.703     0.150
    83.756   751.102     0.150
    83.760   750.797     0.150
    83.760   750.898     0.150
    83.802   751.203     0.150
    83.857   751.703     0.150
    83.862   751.000     0.150
    83.873   751.398     0.150
    84.004   753.602     0.150
    84.104   750.703     0.150
    84.104  1365.203     0.150
    84.174   750.039     0.150
    84.209   752.797     0.150
    84.248   754.898     0.150
    84.262   754.555     0.150
    84.270   754.102     0.150
    84.414   754.000     0.150
    84.537   754.797     0.150
    84.694   755.703     0.150
    84.703   755.602     0.150
    84.914   756.500     0.150
    85.080   759.102     0.150
    85.080  1395.398     0.150
    85.155   759.398     0.150
    85.155   762.703     0.150
    85.155  1390.898     0.150
    85.180   759.500     0.150
    85.180   759.203     0.150
    85.212   761.102     0.150
    85.261   759.602     0.150
    85.352   756.797     0.150
    85.352  1378.000     0.150
    85.352   760.398     0.150
    85.365   761.000     0.150
    85.365  1404.102     0.150
    85.365  1412.398     0.150
    85.370   759.203     0.150
    85.489   757.297     0.150
    85.537   759.898     0.150
    85.606   762.102     0.150
    85.606  1402.297     0.150
    85.606   759.000     0.150
    85.606  1391.000     0.150
    85.615   761.703     0.150
    85.794   757.391     0.150
    85.799   765.898     0.150
    85.799   964.500     0.150
    85.844   761.297     0.150
    85.899   762.828     0.150
    85.899   766.750     0.150
    85.899  1393.500     0.150
    85.899  2330.711     0.150
    85.899   763.000     0.150
    85.938   762.102     0.150
    85.984   763.797     0.150
    86.175  1394.297     0.150
    86.421   764.898     0.150
    86.421   768.500     0.150
    86.429   763.898     0.150
    86.451   764.703     0.150
    86.474   765.203     0.150
    86.495   766.227     0.150
    86.495   765.867     0.150
    86.712   766.898     0.150
    86.712   770.797     0.150
    86.712   767.008     0.150
    86.738   767.344     0.150
    86.741   767.398     0.150
    86.741  1407.500     0.150
    86.746   764.203     0.150
    86.748   767.797     0.150
    86.819   766.797     0.150
    86.819   770.703     0.150
    86.819     3.906     0.150
    86.819  1412.000     0.150
    86.873   768.000     0.150
    86.873  1408.602     0.150
    86.873   767.898     0.150
    86.885   767.102     0.150
    86.885     3.398     0.150
    86.885  1400.500     0.150
    86.885  1744.500     0.150
    86.885   767.297     0.150
    86.898   767.477     0.150
    86.898   767.812     0.150
    86.917   766.703     0.150
    87.006   768.445     0.150
    87.019   767.000     0.150
    87.030   768.000     0.150
    87.030   772.297     0.150
    87.030     4.297     0.150
    87.056   767.703     0.150
    87.056   772.000     0.150
    87.056     4.297     0.150
    87.056  1760.203     0.150
    87.069   766.883     0.150
    87.269   769.703     0.150
    87.278   769.398     0.150
    87.278   773.703     0.150
    87.324   769.211     0.150
    87.324  1844.422     0.150
    87.324  2329.047     0.150
    87.330   769.742     0.150
    87.494   769.891     0.150
    87.575   771.461     0.150
    87.746   775.203     0.150
    87.753   773.000     0.150
    87.765   769.898     0.150
    87.823   775.102     0.150
    87.823  1413.797     0.150
    87.850   770.398     0.150
    87.923   771.500     0.150
    87.923  1412.500     0.150
    87.964   772.000     0.150
    88.197   774.000     0.150
    88.218   773.703     0.150
    88.218   770.867     0.150
    88.238   773.203     0.150
    88.238  1420.500     0.150
    88.244   777.297     0.150
    88.244  1417.297     0.150
    88.242   779.180     0.150
    88.323   774.312     0.150
    88.360   774.727     0.150
    88.363   779.492     0.150
    88.413   774.398     0.150
    88.413   778.500     0.150
    88.413  1421.703     0.150
    88.413     4.102     0.150
    88.493   775.109     0.150
    88.510   780.031     0.150
    88.526   779.602     0.150
    88.526  1404.398     0.150
    88.526  1773.203     0.150
    88.755   776.297     0.150
    88.755   779.398     0.150
    88.755  1419.703     0.150
    88.801   781.547     0.150
    88.824   780.891     0.150
    88.843   777.797     0.150
    88.956   777.906     0.150
    88.965   778.883     0.150
    89.001   778.352     0.150
    89.000   777.297     0.150
    89.001   778.398     0.150
    89.180   783.492     0.150
    89.245   775.312     0.150
    89.331   778.875     0.150
    89.337   780.703     0.150
    89.337  1422.703     0.150
    89.379   783.961     0.150
    89.381   784.359     0.150
    89.444   783.000     0.150
    89.466   779.406     0.150
    89.553   778.977     0.150
    89.549   785.133     0.150
    89.593   781.102     0.150
    89.593   783.703     0.150
    89.593  1424.398     0.150
    89.593   783.398     0.150
    89.593  1425.203     0.150
    89.623   779.820     0.150
    89.623   784.281     0.150
    89.677   780.703     0.150
    89.667   785.445     0.150
    89.670   785.492     0.150
    89.684   782.203     0.150
    89.684  1410.203     0.150
    89.684   782.523     0.150
    89.684   785.336     0.150
    89.702   778.797     0.150
    89.713   780.562     0.150
    89.713   784.742     0.150
    89.714   777.602     0.150
    89.714   988.398     0.150
    89.718   785.000     0.150
    89.751   785.500     0.150
    89.753   780.398     0.150
    89.753   784.703     0.150
    89.753  1425.500     0.150
    89.753  1788.703     0.150
    89.759   783.203     0.150
    89.810   781.039     0.150
    89.810   785.156     0.150
    89.810  1430.156     0.150
    89.810  1802.047     0.150
    89.957   782.703     0.150
    90.205   784.500     0.150
    90.291   788.500     0.150
    90.329   783.703     0.150
    90.329  1430.297     0.150
    90.346   788.672     0.150
    90.400   784.297     0.150
    90.413   783.602     0.150
    90.420   784.297     0.150
    90.459   784.898     0.150
    90.459   788.500     0.150
    90.459  1807.297     0.150
    90.480   787.797     0.150
    90.549   784.648     0.150
    90.549   786.500     0.150
    90.633   788.797     0.150
    90.640   785.898     0.150
    90.640   782.281     0.150
    90.640   996.172     0.150
    90.654   788.797     0.150
    90.654  1412.000     0.150
    90.654  1441.398     0.150
    90.683   788.203     0.150
    90.742   786.297     0.150
    90.742   790.000     0.150
    90.742  1448.898     0.150
    90.860   790.766     0.150
    90.908   787.203     0.150
    90.997  1005.500     0.150
    90.997  1440.500     0.150
    90.997  1814.500     0.150
    91.037   791.500     0.150
    91.188   788.102     0.150
    91.188  1415.797     0.150
    91.448   793.797     0.150
    91.484   788.500     0.150
    91.502   793.297     0.150
    91.503   790.602     0.150
    91.503   793.000     0.150
    91.499   788.797     0.150
    91.499  1420.898     0.150
    91.499  1807.602     0.150
    91.562   793.703     0.150
    91.642   789.000     0.150
    91.642  1831.578     0.150
    91.643  1447.102     0.150
    91.643   999.312     0.150
    91.649   788.000     0.150
    91.649  1445.500     0.150
    91.649   790.445     0.150
    91.649  1000.141     0.150
    91.790   789.102     0.150
    91.790  1426.203     0.150
    91.925   792.688     0.150
    91.925  1827.250     0.150
    91.925  2319.617     0.150
    92.063   788.898     0.150
    92.084   788.352     0.150
    92.143   797.500     0.150
    92.187   797.102     0.150
    92.211   795.898     0.150
    92.211  1533.797     0.150
    92.211   795.172     0.150
    92.211   788.969     0.150
    92.243   793.500     0.150
    92.335   797.898     0.150
    92.388   795.500     0.150
    92.388   793.453     0.150
    92.589   797.500     0.150
    92.671   794.398     0.150
    92.741   799.102     0.150
    92.778   799.500     0.150
    92.828   799.297     0.150
    92.931   796.500     0.150
    93.025   799.703     0.150
    93.079   796.500     0.150
    93.108   797.203     0.150
    93.304   801.703     0.150
    93.410   798.500     0.150
    93.495   803.203     0.150
    93.511   798.602     0.150
    93.707   794.297     0.150
    93.727   796.203     0.150
    93.745   799.797     0.150
    93.849   799.797     0.150
    93.882   802.203     0.150
    93.882  1023.703     0.150
    93.984   803.203     0.150
    94.097   804.102     0.150
    94.128   804.602     0.150
    94.145   802.297     0.150
    94.145  1023.703     0.150
    94.209   803.492     0.150
    94.332   805.203     0.150
    94.351   806.102     0.150
    94.383   802.703     0.150
    94.386   805.203     0.150
    94.397   806.000     0.150
    94.537   804.797     0.150
    94.537  1025.703     0.150
    94.600   804.102     0.150
    94.685   806.000     0.150
    94.694   806.602     0.150
    94.701   806.797     0.150
    94.730   806.500     0.150
    94.730  1031.500     0.150
    94.730  1479.500     0.150
    94.754   805.297     0.150
    94.754   806.703     0.150
    94.754   805.297     0.150
    94.757   805.031     0.150
    94.915   807.602     0.150
    94.921  2315.359     0.150
    94.936   807.797     0.150
    94.949   805.203     0.150
    94.965   805.000     0.150
    94.994   805.797     0.150
    95.120   808.500     0.150
    95.351  1483.203     0.150
    95.437   806.898     0.150
    95.533   810.203     0.150
    95.645   804.781     0.150
    95.799   810.500     0.150
    95.826   809.102     0.150
    95.880   812.203     0.150
    95.921   808.500     0.150
    96.046   813.602     0.150
    96.046  1040.102     0.150
    96.046  1479.000     0.150
    96.065   809.703     0.150
    96.087   814.211     0.150
    96.130   811.703     0.150
    96.130   807.430     0.150
    96.261   811.203     0.150
    96.263   814.398     0.150
    96.334   809.398     0.150
    96.334   814.000     0.150
    96.334   810.500     0.150
    96.423   815.203     0.150
    96.467  1818.367     0.150
    96.467  2312.727     0.150
    96.501   815.391     0.150
    96.541   811.797     0.150
    96.569  1818.375     0.150
    96.569  2312.727     0.150
    96.677   811.500     0.150
    96.786   813.500     0.150
    96.786   813.398     0.150
    96.786   810.461     0.150
    96.871   812.500     0.150
    96.879   813.500     0.150
    96.888   817.297     0.150
    96.887   814.297     0.150
    97.022   814.203     0.150
    97.125   816.898     0.150
    97.165   815.203     0.150
    97.174   814.797     0.150
    97.355   817.203     0.150
    97.371   817.500     0.150
    97.371   815.500     0.150
    97.380   816.297     0.150
    97.380   818.797     0.150
    97.380   815.500     0.150
    97.367  1059.898     0.150
    97.367  1452.000     0.150
    97.367  1495.602     0.150
    97.492   816.500     0.150
    97.557   814.500     0.150
    97.585   817.898     0.150
    97.635   818.898     0.150
    97.695   819.203     0.150
    97.713   818.703     0.150
    97.844   820.398     0.150
    97.855   820.898     0.150
    97.930   817.398     0.150
    98.027   818.500     0.150
    98.071   821.898     0.150
    98.089   815.398     0.150
    98.201   820.898     0.150
    98.229   822.203     0.150
    98.267  1915.500     0.150
    98.304   821.703     0.150
    98.391   822.297     0.150
    98.500   823.898     0.150
    98.527   821.203     0.150
    98.700   822.297     0.150
    98.730   822.602     0.150
    98.734   824.297     0.150
    98.730   818.172     0.150
    98.762   822.203     0.150
    98.881   822.500     0.150
    98.983   825.000     0.150
    99.064   824.602     0.150
    99.172   825.000     0.150
    99.381   827.703     0.150
    99.381  1066.703     0.150
    99.381  1922.297     0.150
    99.399   827.297     0.150
    99.446   826.000     0.150
    99.485   827.102     0.150
    99.595   829.203     0.150
    99.719   826.273     0.150
    99.719  1810.273     0.150
    99.719  2306.875     0.150
    99.770   826.898     0.150
    99.956   830.102     0.150
    99.984   829.602     0.150
   100.192   828.602     0.150
   100.248   829.297     0.150
   100.257   828.797     0.150
   100.336   831.602     0.150
   100.365   832.297     0.150
   100.402   829.602     0.150
   100.559   827.898     0.150
   101.037   834.398     0.150
   101.129  1084.203     0.150
   101.299   831.000     0.150
   101.418  1087.500     0.150
   101.418  1956.500     0.150
   101.521  1087.500     0.150
   101.521  1478.102     0.150
   101.521  1960.797     0.150
   101.591  1091.297     0.150
   101.591  1473.797     0.150
   101.591  1532.703     0.150
   101.785   836.750     0.150
   101.804   834.102     0.150
   101.804  1089.000     0.150
   101.901   835.000     0.150
   102.013  1476.000     0.150
   102.167   839.000     0.150
   102.198   840.703     0.150
   102.371   835.398     0.150
   102.747  1100.703     0.150
   102.795   840.500     0.150
   102.795  1805.203     0.150
   102.795  2298.898     0.150
   102.993   844.133     0.150
   103.297   843.898     0.150
   103.330   840.703     0.150
   103.450   843.148     0.150
   103.493   845.000     0.150
   103.493  1483.898     0.150
   103.493  1523.703     0.150
   103.493  1655.602     0.150
   103.493  1994.500     0.150
   103.903   846.602     0.150
   104.103   848.633     0.150
   104.121   849.211     0.150
   104.512   844.398     0.150
   104.713  1485.500     0.150
   104.713  2012.500     0.150
   104.742   850.156     0.150
   104.742  1793.852     0.150
   104.806   845.797     0.150
   104.920   846.203     0.150
   104.920  1812.500     0.150
   104.972   847.102     0.150
   106.918   860.000     0.150
   107.088   860.102     0.150
   107.088  1128.797     0.150
   107.088  1578.203     0.150
   107.088  2032.602     0.150
   109.893   872.867     0.150
   114.900  1122.422     0.150
   115.852  1123.922     0.150
   116.794  1131.203     0.150
   116.853  1130.797     0.150
   116.913  1125.742     0.150
   116.992  1131.102     0.150
   117.051  1130.797     0.150
   117.132  1124.898     0.150
   117.133  1131.000     0.150
   117.146  1131.500     0.150
   117.211  1123.797     0.150
   117.214  1124.273     0.150
   117.224  1128.422     0.150
   117.224  1757.602     0.150
   117.311  1131.500     0.150
   117.313  1131.500     0.150
   117.353  1131.797     0.150
   117.495  1131.602     0.150
   117.525  1132.203     0.150
   117.644  1132.102     0.150
   118.228  1128.500     0.150
   118.440  1128.477     0.150
   118.884  1129.867     0.150
   119.069  1130.078     0.150
   119.200  1128.281     0.150
   119.202  1131.500     0.150
   119.202  1777.734     0.150
   119.202  1990.602     0.150
   119.503  1131.352     0.150
   119.542  1128.500     0.150
   119.542  1137.320     0.150
   119.713  1133.828     0.150
   119.839  1135.250     0.150
   119.839  1771.031     0.150
   120.691  1133.352     0.150
   120.828  1131.797     0.150
   121.567  1132.852     0.150
   122.414  1140.625     0.150
   122.414  1142.695     0.150
   122.640  1134.719     0.150
   122.640  1142.102     0.150
   123.480  1139.094     0.150
   124.588  1138.383     0.150
   124.829  1147.539     0.150
   124.956  1262.500     0.150
   125.138  1256.648     0.150
   125.211  1144.008     0.150
   125.374  1142.453     0.150
   125.709  1146.664     0.150
   126.217  1148.219     0.150
   126.217  1261.539     0.150
   126.217  1973.773     0.150
   126.217  2287.383     0.150
   126.691  1141.523     0.150
   127.189  1145.398     0.150
   127.278  1146.406     0.150
   127.278  1266.273     0.150
   127.278  2297.453     0.150
   127.332  1148.898     0.150
   127.349  1146.688     0.150
   128.737  1148.508     0.150
   128.745  1147.367     0.150
   128.845  1149.570     0.150
   128.845  1276.172     0.150
   128.845  2325.023     0.150
   128.846  1153.500     0.150
   128.846  1277.500     0.150
   128.846  1369.500     0.150
   128.846  1148.953     0.150
   129.367  1146.867     0.150
   129.465  1156.133     0.150
   129.479  1150.688     0.150
   129.479  1280.031     0.150
   129.479  2326.656     0.150
   129.500  1156.680     0.150
   129.738  1148.562     0.150
   129.877  1146.703     0.150
   129.975  1154.820     0.150
   129.975  1280.047     0.150
   129.975  2335.930     0.150
   130.082  1149.219     0.150
   130.148  1153.297     0.150
   130.751  1161.797     0.150
   131.537  1154.359     0.150
   131.537  1293.211     0.150
   131.537  1904.852     0.150
   131.537  2340.820     0.150
   131.715  1154.141     0.150
   132.025  1152.508     0.150
   132.048  1155.320     0.150
   132.048  1294.078     0.150
   132.048  2354.289     0.150
   132.114  1159.141     0.150
   132.114  1309.078     0.150
   132.127  1158.102     0.150
   133.043  1155.547     0.150
   135.932  1166.383     0.150
   136.126  1163.391     0.150
   137.134  1164.570     0.150
   137.798  1165.469     0.150
   137.823  1163.703     0.150
   137.823  1168.805     0.150
   139.643  1167.500     0.150
   139.643  1170.398     0.150
   139.643  1170.195     0.150
   139.716  1172.461     0.150
   140.538  1171.602     0.150
   142.773  1173.398     0.150
   142.773  1177.070     0.150
   143.108  1171.570     0.150
   144.611  1178.094     0.150
   145.072  1181.500     0.150
   145.926  1182.500     0.150
   146.465  1184.750     0.150
   146.631  1187.203     0.150
   147.208  1187.820     0.150
   147.235  1186.492     0.150
   147.598  1187.898     0.150
   147.760  1189.453     0.150
   147.768  1189.008     0.150
   147.849  1187.578     0.150
   147.991  1191.297     0.150
   149.913  1190.227     0.150
   151.220  1187.203     0.150
   151.220  1194.617     0.150
   151.220  1196.750     0.150
   162.442  2694.500     0.150
   162.754  1205.500     0.150
   168.103  2769.500     0.150
     0.840    15.578     0.150
     0.880    16.562     0.150
     0.880    28.406     0.150
     1.252    40.945     0.150
     1.473    42.016     0.150
     1.398    44.148     0.150
     1.864    32.305     0.150
     2.112    37.750     0.150
     2.306    71.102     0.150
     3.090    58.406     0.150
     3.090    98.086     0.150
     2.967    91.047     0.150
     3.031    91.383     0.150
     3.028    91.648     0.150
     3.096    93.172     0.150
     3.254    52.227     0.150
     3.254    99.328     0.150
     3.299    52.828     0.150
     3.299    99.438     0.150
     3.559    55.023     0.150
     4.005    61.141     0.150
     4.005   107.422     0.150
     3.924    61.188     0.150
     3.924   107.422     0.150
     5.063    76.812     0.150
     5.108    76.305     0.150
     5.108   133.516     0.150
     5.559    82.883     0.150
     5.559   143.227     0.150
     6.339    92.805     0.150
     6.339   162.195     0.150
     6.359   202.047     0.150
     6.904   100.648     0.150
     6.904   218.414     0.150
     7.911   115.023     0.150
     7.911   247.250     0.150
     8.745   126.922     0.150
     8.976   136.516     0.150
    11.671   169.227     0.150
    22.270   298.789     0.150
    23.245   308.547     0.150
    28.301   355.938     0.150
    30.358   373.523     0.150
    30.529   374.172     0.150
    37.642   435.688     0.150
    37.879   438.953     0.150
    38.161   441.664     0.150
    38.417   442.422     0.150
    38.532   444.328     0.150
    38.774   446.836     0.150
    43.003   480.625     0.150
    43.955   488.078     0.150
    46.712   508.375     0.150
    56.415   583.922     0.150
    63.092   629.430     0.150
    63.462   631.227     0.150
    70.477   677.586     0.150
    74.814   701.703     0.150
    77.603   718.227     0.150
    77.603   718.227     0.150
    77.897   717.328     0.150
    79.912   730.523     0.150
    80.848   735.828     0.150
    81.102   737.023     0.150
    81.751   740.750     0.150
    82.316   743.625     0.150
    82.343   743.625     0.150
    82.485   744.523     0.150
    82.554   744.523     0.150
    82.583   745.023     0.150
    82.553   744.875     0.150
    83.252   748.625     0.150
    83.771   751.328     0.150
    83.794   750.922     0.150
    83.951   751.727     0.150
    83.959   752.023     0.150
    83.965   752.125     0.150
    84.002   752.422     0.150
    84.059   752.328     0.150
    84.064   752.828     0.150
    84.064   752.625     0.150
    84.407   754.023     0.150
    84.425   754.445     0.150
    84.605   755.328     0.150
    84.744   756.125     0.150
    84.912   756.828     0.150
    85.120   757.828     0.150
    85.430   758.727     0.150
    85.572   760.125     0.150
    87.545   769.227     0.150
    89.237   778.852     0.150
    89.237   778.828     0.150
    91.890   788.766     0.150
   117.236  1128.297     0.150
   119.195  1132.109     0.150
   120.095  1134.102     0.150
   144.324  1176.938     0.150
   145.855  1182.273     0.150
     0.230     4.367     0.150
     0.230     8.508     0.150
     0.190     3.453     0.150
     0.190     7.469     0.150
     0.689    12.227     0.150
     0.918    16.148     0.150
     0.928    15.805     0.150
     0.928    16.242     0.150
     0.928    29.336     0.150
     1.149    37.117     0.150
     1.149    38.656     0.150
     1.246    37.562     0.150
     1.341    39.305     0.150
     1.349    23.008     0.150
     1.349    41.289     0.150
     1.709    29.016     0.150
     1.758    51.469     0.150
     1.780    54.156     0.150
     1.976    61.781     0.150
     2.041    32.586     0.150
     2.198    35.172     0.150
     2.239    65.703     0.150
     2.548    81.305     0.150
     2.895    46.609     0.150
     2.911    83.281     0.150
     2.936    44.414     0.150
     2.936    88.453     0.150
     2.970    90.508     0.150
     3.018    90.812     0.150
     3.115    48.547     0.150
     3.115    98.414     0.150
     3.147    50.305     0.150
     3.197    51.555     0.150
     3.344   102.164     0.150
     3.820   116.445     0.150
     3.888   120.953     0.150
     4.140   124.859     0.150
     4.319    65.664     0.150
     4.415    65.953     0.150
     4.415   136.773     0.150
     4.516    69.836     0.150
     4.609    70.023     0.150
     4.609    70.469     0.150
     5.212    78.406     0.150
     5.421    80.961     0.150
     5.421    81.664     0.150
     6.286    91.445     0.150
     7.106   103.805     0.150
     7.178   105.062     0.150
     7.224   107.508     0.150
     7.461   110.016     0.150
     7.454   109.023     0.150
     7.723   115.438     0.150
     7.810   113.930     0.150
     7.803   114.281     0.150
     7.803   113.055     0.150
     7.896   116.008     0.150
     7.977   117.805     0.150
     8.022   118.562     0.150
     8.164   122.188     0.150
     8.231   123.305     0.150
     8.338   124.500     0.150
     8.398   123.508     0.150
     8.552   126.508     0.150
     8.814   131.609     0.150
     8.835   129.430     0.150
     8.905   132.766     0.150
     8.941   132.305     0.150
     9.128   136.297     0.150
     9.186   132.336     0.150
     9.429   138.078     0.150
     9.593   140.023     0.150
     9.670   141.555     0.150
     9.732   143.836     0.150
     9.705   142.898     0.150
     9.730   143.000     0.150
     9.851   146.359     0.150
    10.171   150.758     0.150
    10.320   150.305     0.150
    10.320   150.281     0.150
    10.526   155.398     0.150
    10.597   155.703     0.150
    10.582   156.586     0.150
    10.620   153.758     0.150
    10.866   158.508     0.150
    11.059   162.055     0.150
    11.231   165.930     0.150
    11.265   164.109     0.150
    11.384   168.906     0.150
    11.457   168.508     0.150
    11.440   165.633     0.150
    11.445   167.359     0.150
    11.479   165.648     0.150
    11.479   364.148     0.150
    11.602   168.203     0.150
    11.683   170.586     0.150
    11.781   171.953     0.150
    11.906   173.523     0.150
    11.977   174.094     0.150
    12.094   175.875     0.150
    12.172   177.305     0.150
    12.292   178.578     0.150
    12.357   179.469     0.150
    12.401   181.969     0.150
    12.442   181.867     0.150
    12.723   184.969     0.150
    12.726   185.844     0.150
    12.763   188.164     0.150
    12.765   187.180     0.150
    13.008   188.773     0.150
    13.158   190.719     0.150
    13.275   192.008     0.150
    13.322   193.383     0.150
    13.417   195.094     0.150
    13.627   197.453     0.150
    13.685   198.109     0.150
    13.707   196.617     0.150
    13.727   198.375     0.150
    13.792   200.906     0.150
    13.867   202.133     0.150
    13.947   199.203     0.150
    14.219   734.867     0.150
    14.497   208.438     0.150
    14.584   210.125     0.150
    14.666   212.047     0.150
    14.795   213.086     0.150
    14.793   211.906     0.150
    14.826   213.062     0.150
    14.825   211.930     0.150
    15.048   218.305     0.150
    15.104   217.805     0.150
    15.133   216.086     0.150
    15.114   214.156     0.150
    15.204   216.562     0.150
    15.342   220.305     0.150
    15.413   221.406     0.150
    15.568   223.609     0.150
    15.632   223.383     0.150
    15.660   224.445     0.150
    15.695   226.656     0.150
    15.725   225.273     0.150
    15.780   224.539     0.150
    15.829   226.664     0.150
    15.866   227.438     0.150
    16.050   226.414     0.150
    16.136   229.508     0.150
    16.136   228.578     0.150
    16.322   410.250     0.150
    16.322   736.906     0.150
    16.341   230.508     0.150
    16.341   736.328     0.150
    16.341   743.938     0.150
    16.361   232.750     0.150
    16.464   233.969     0.150
    16.453   232.406     0.150
    16.512   232.234     0.150
    16.574   236.586     0.150
    16.745   236.305     0.150
    16.893   239.516     0.150
    17.001   241.828     0.150
    17.437   245.359     0.150
    17.585   247.289     0.150
    18.217   253.805     0.150
    18.279   255.203     0.150
    18.608   259.086     0.150
    19.239   265.445     0.150
    20.011   274.367     0.150
    20.882   284.688     0.150
    21.077   285.906     0.150
    21.311   287.805     0.150
    21.443   289.797     0.150
    21.657   291.609     0.150
    21.714   292.266     0.150
    21.750   292.594     0.150
    21.790   293.180     0.150
    21.972   295.438     0.150
    22.101   298.633     0.150
    22.423   299.508     0.150
    22.961   306.008     0.150
    22.978   305.648     0.150
    23.064   306.008     0.150
    23.220   307.914     0.150
    23.750   313.906     0.150
    23.741   315.328     0.150
    23.889   315.234     0.150
    23.956   317.203     0.150
    24.018   316.969     0.150
    24.257   318.008     0.150
    24.324   319.203     0.150
    24.416   319.508     0.150
    24.502   320.727     0.150
    26.253   337.008     0.150
    26.253   338.281     0.150
    26.656   340.805     0.150
    27.102   343.914     0.150
    28.124   354.555     0.150
    28.268   354.695     0.150
    29.412   365.094     0.150
    29.428   364.844     0.150
    30.335   372.750     0.150
    30.335   555.148     0.150
    30.335   372.750     0.150
    30.652   375.383     0.150
    32.556   393.773     0.150
    33.520   400.547     0.150
    33.833   404.305     0.150
    34.357   408.055     0.150
    35.143   417.297     0.150
    35.301   418.844     0.150
    35.414   421.609     0.150
    36.122   427.016     0.150
    36.336   425.969     0.150
    37.490   436.039     0.150
    37.695   437.156     0.150
    37.963   439.906     0.150
    37.992   440.070     0.150
    37.992   439.695     0.150
    38.254   442.219     0.150
    38.364   443.805     0.150
    38.542   445.539     0.150
    38.614   445.523     0.150
    38.880   448.383     0.150
    39.008   449.859     0.150
    40.661   463.789     0.150
    40.694   461.281     0.150
    40.694   461.516     0.150
    40.981   464.953     0.150
    42.817   479.156     0.150
    43.758   487.609     0.150
    43.758   487.406     0.150
    46.308   512.539     0.150
    46.659   512.727     0.150
    46.697   510.109     0.150
    46.943   513.789     0.150
    46.878   513.992     0.150
    47.003   518.555     0.150
    47.023   517.805     0.150
    47.027   514.227     0.150
    47.027   513.930     0.150
    47.288   516.680     0.150
    47.288   515.078     0.150
    47.478   517.617     0.150
    50.922   542.906     0.150
    52.526   557.359     0.150
    55.674   577.703     0.150
    56.256   585.508     0.150
    60.433   609.203     0.150
    61.523   619.422     0.150
    62.821   630.805     0.150
    62.942   628.508     0.150
    63.338   631.828     0.150
    63.341   631.820     0.150
    65.105   642.906     0.150
    65.985   650.531     0.150
    66.264   648.688     0.150
    66.264   648.680     0.150
    70.192   675.656     0.150
    70.559   676.445     0.150
    72.684   690.609     0.150
    74.618   699.805     0.150
    74.618   699.805     0.150
    75.341   705.836     0.150
    77.413   716.609     0.150
    77.413   716.453     0.150
    77.413   716.453     0.150
    77.441   717.406     0.150
    77.701   722.109     0.150
    77.701   720.078     0.150
    78.914   725.250     0.150
    79.432   728.406     0.150
    79.742   730.109     0.150
    79.863   730.406     0.150
    79.934   730.305     0.150
    79.934   732.758     0.150
    80.637   735.109     0.150
    80.675   735.609     0.150
    80.909   739.406     0.150
    80.929   736.805     0.150
    81.224   741.805     0.150
    81.306   738.906     0.150
    81.520   740.203     0.150
    81.556   739.203     0.150
    81.556   739.180     0.150
    81.623   743.906     0.150
    81.623   740.969     0.150
    81.687   742.906     0.150
    81.687   929.109     0.150
    82.138   744.008     0.150
    82.172   743.508     0.150
    82.280   746.406     0.150
    82.311   747.203     0.150
    82.334   745.305     0.150
    82.404   744.703     0.150
    82.402   745.305     0.150
    82.431   745.055     0.150
    82.904   750.203     0.150
    83.151   751.305     0.150
    83.155   749.391     0.150
    83.156   749.406     0.150
    83.511   744.609     0.150
    83.455   749.406     0.150
    83.455   750.453     0.150
    83.594   751.109     0.150
    83.622   751.008     0.150
    83.708   751.805     0.150
    83.769   751.805     0.150
    83.778   751.805     0.150
    83.785   752.008     0.150
    83.788   751.906     0.150
    83.827   752.305     0.150
    83.887   752.805     0.150
    83.886   752.203     0.150
    83.893   752.508     0.150
    84.069   756.609     0.150
    84.234   753.906     0.150
    84.268   754.125     0.150
    84.284   755.805     0.150
    84.434   755.109     0.150
    84.566   755.805     0.150
    84.709   756.805     0.150
    84.733   756.805     0.150
    84.943   757.609     0.150
    85.220   759.406     0.150
    85.233   759.109     0.150
    85.334   761.305     0.150
    85.396   760.203     0.150
    85.554   760.906     0.150
    85.642   763.805     0.150
    85.866   762.109     0.150
    85.939   764.914     0.150
    85.958   763.109     0.150
    86.461   765.203     0.150
    86.477   765.805     0.150
    86.499   766.008     0.150
    86.859   767.008     0.150
    86.926   767.703     0.150
    86.939   767.906     0.150
    87.072   767.203     0.150
    87.094   768.609     0.150
    87.133   768.586     0.150
    87.320   768.906     0.150
    87.362   768.703     0.150
    87.362   768.688     0.150
    87.432   769.977     0.150
    87.788   771.109     0.150
    88.238   774.023     0.150
    89.124   778.977     0.150
    89.124   777.188     0.150
    89.124     1.789     0.150
    89.744   783.203     0.150
    89.801   783.203     0.150
    89.796   783.008     0.150
    90.003   784.906     0.150
    90.665   786.609     0.150
    90.703   786.906     0.150
    91.025   785.508     0.150
    91.278   789.906     0.150
    91.587   791.609     0.150
    91.587  1009.305     0.150
    91.587  1423.703     0.150
    91.698   791.008     0.150
    91.698   790.008     0.150
    91.698  1006.555     0.150
    91.698   790.008     0.150
    91.698  1006.609     0.150
    91.699   789.406     0.150
    91.896   789.906     0.150
    92.045   792.547     0.150
    92.045  1015.586     0.150
    92.045   792.547     0.150
    92.045  1015.586     0.150
    92.491   793.977     0.150
    92.491  1015.906     0.150
    92.495   795.203     0.150
    92.495   793.984     0.150
    92.495  1015.906     0.150
    93.222   799.906     0.150
    93.830   799.609     0.150
    95.019   805.992     0.150
    95.041   805.875     0.150
    96.571   813.609     0.150
    96.673   813.633     0.150
    96.673  1051.906     0.150
    97.534   816.484     0.150
    98.212   820.008     0.150
    99.826   827.375     0.150
    99.826  1074.156     0.150
    99.826   828.008     0.150
    99.826   827.383     0.150
    99.826  1074.156     0.150
   101.531   834.906     0.150
   101.531  1088.406     0.150
   101.531  1474.406     0.150
   101.531  1532.406     0.150
   107.211   860.008     0.150
   107.211  1130.109     0.150
   107.211  1578.906     0.150
   107.211  2034.508     0.150
   109.347  1109.406     0.150
   117.293  1128.453     0.150
   119.264  1132.055     0.150
   119.264  1132.055     0.150
   119.962  1134.109     0.150
   119.962  1137.703     0.150
   119.962  1134.109     0.150
   139.650  1170.531     0.150
   142.725  1174.703     0.150
   144.517  1178.742     0.150
   144.993  1178.805     0.150
   145.838  1182.758     0.150
     0.218     5.023     0.150
     0.218     7.109     0.150
     0.577    10.414     0.150
     0.674    12.242     0.150
     0.695    12.680     0.150
     0.742    13.453     0.150
     0.856    14.594     0.150
     0.932    15.531     0.150
     0.932    28.430     0.150
     0.932    15.836     0.150
     0.932    27.055     0.150
     0.956    16.289     0.150
     1.163    21.523     0.150
     1.163    36.844     0.150
     1.164    21.594     0.150
     1.164    41.227     0.150
     1.169    20.984     0.150
     1.169    36.500     0.150
     1.231    19.781     0.150
     1.238    22.172     0.150
     1.238    38.422     0.150
     1.261    22.016     0.150
     1.261    38.641     0.150
     1.406    23.469     0.150
     1.406    40.406     0.150
     1.455    23.500     0.150
     1.425    23.289     0.150
     1.529    24.531     0.150
     1.672    26.484     0.150
     1.678    27.938     0.150
     1.678    50.555     0.150
     1.715    26.633     0.150
     1.715    27.133     0.150
     1.715    53.836     0.150
     1.715    27.430     0.150
     1.715    53.336     0.150
     1.889    29.414     0.150
     1.953    30.617     0.150
     2.119    33.164     0.150
     2.081    33.422     0.150
     2.123    33.461     0.150
     2.123    64.477     0.150
     2.289    35.938     0.150
     2.305    35.758     0.150
     2.584    39.562     0.150
     2.584    70.984     0.150
     2.593    39.844     0.150
     2.619    40.016     0.150
     2.619    71.344     0.150
     2.761    41.922     0.150
     2.872    45.016     0.150
     2.839    43.398     0.150
     2.839    85.516     0.150
     2.839    51.242     0.150
     2.856    43.688     0.150
     2.890    44.633     0.150
     2.890    87.438     0.150
     2.940    47.055     0.150
     2.940    88.766     0.150
     3.117    47.641     0.150
     3.073    54.031     0.150
     3.073    95.234     0.150
     3.103    48.336     0.150
     3.122    54.891     0.150
     3.122    94.734     0.150
     3.267    49.680     0.150
     3.269    56.438     0.150
     3.269    99.320     0.150
     3.395    59.977     0.150
     3.497    53.172     0.150
     3.697    66.695     0.150
     3.727    63.656     0.150
     3.745    56.016     0.150
     3.745   112.617     0.150
     3.745    60.445     0.150
     3.907    59.195     0.150
     4.061    61.570     0.150
     4.149    62.625     0.150
     4.293    64.781     0.150
     4.349    65.141     0.150
     4.383    66.703     0.150
     4.641    69.539     0.150
     4.641    70.266     0.150
     4.630    69.109     0.150
     4.800    71.875     0.150
     4.805    71.906     0.150
     4.891    73.742     0.150
     5.035    74.984     0.150
     4.999    75.359     0.150
     5.062    76.031     0.150
     5.183    76.453     0.150
     5.215    78.336     0.150
     5.378    80.461     0.150
     5.468    81.133     0.150
     5.468    81.703     0.150
     5.565    83.172     0.150
     5.775    86.234     0.150
     6.137    90.047     0.150
     6.137    91.125     0.150
     6.359    92.633     0.150
     6.682   101.953     0.150
     6.682   218.031     0.150
     6.817   101.289     0.150
     6.821   104.133     0.150
     7.168   104.273     0.150
     7.160   107.633     0.150
     7.241   105.492     0.150
     7.264   106.203     0.150
     7.497   110.758     0.150
     7.517   109.594     0.150
     7.551   110.133     0.150
     7.749   115.906     0.150
     7.816   118.242     0.150
     7.862   114.633     0.150
     7.862   114.531     0.150
     7.862   114.234     0.150
     7.908   116.031     0.150
     8.001   117.914     0.150
     8.045   118.805     0.150
     8.078   119.453     0.150
     8.223   123.930     0.150
     8.348   121.242     0.150
     8.338   123.727     0.150
     8.358   124.531     0.150
     8.435   121.250     0.150
     8.525   125.734     0.150
     8.525   125.234     0.150
     8.581   124.453     0.150
     8.763   127.219     0.150
     8.815   129.531     0.150
     8.874   128.570     0.150
     8.893   131.906     0.150
     8.938   131.672     0.150
     9.020   131.062     0.150
     9.189   136.125     0.150
     9.189   295.156     0.150
     9.260   132.586     0.150
     9.283   134.148     0.150
     9.426   138.305     0.150
     9.509   137.680     0.150
     9.572   138.617     0.150
     9.667   140.492     0.150
     9.671   140.359     0.150
     9.700   142.242     0.150
     9.793   143.641     0.150
     9.748   141.391     0.150
     9.749   142.375     0.150
     9.777   141.320     0.150
     9.767   143.133     0.150
     9.847   144.500     0.150
    10.029   144.359     0.150
    10.221   148.305     0.150
    10.195   151.930     0.150
    10.399   150.133     0.150
    10.399   150.156     0.150
    10.399   327.109     0.150
    10.439   150.297     0.150
    10.474   155.016     0.150
    10.553   154.430     0.150
    10.649   153.461     0.150
    10.658   153.602     0.150
    10.765   152.969     0.150
    10.833   155.648     0.150
    10.898   157.930     0.150
    11.054   162.016     0.150
    11.190   160.016     0.150
    11.201   165.094     0.150
    11.205   164.430     0.150
    11.205   165.352     0.150
    11.362   167.461     0.150
    11.404   167.633     0.150
    11.470   165.250     0.150
    11.482   166.242     0.150
    11.482   165.086     0.150
    11.482   166.133     0.150
    11.667   166.812     0.150
    11.678   170.391     0.150
    11.776   171.414     0.150
    11.795   171.336     0.150
    11.973   174.227     0.150
    12.018   174.195     0.150
    12.035   175.281     0.150
    12.165   175.562     0.150
    12.336   177.336     0.150
    12.312   180.266     0.150
    12.395   179.859     0.150
    12.392   180.883     0.150
    12.533   178.781     0.150
    12.716   183.555     0.150
    12.720   184.180     0.150
    12.728   185.492     0.150
    12.749   186.492     0.150
    13.002   189.164     0.150
    13.230   189.344     0.150
    13.306   193.461     0.150
    13.351   191.133     0.150
    13.376   191.977     0.150
    13.574   196.523     0.150
    13.673   198.734     0.150
    13.660   198.227     0.150
    13.725   195.484     0.150
    13.776   199.211     0.150
    13.833   199.375     0.150
    14.013   198.133     0.150
    14.460   208.289     0.150
    14.542   208.812     0.150
    14.644   210.180     0.150
    14.731   210.727     0.150
    14.775   212.461     0.150
    14.812   208.734     0.150
    14.776   210.453     0.150
    14.889   211.422     0.150
    15.083   214.195     0.150
    15.121   213.742     0.150
    15.094   215.836     0.150
    15.177   215.016     0.150
    15.265   215.734     0.150
    15.320   218.656     0.150
    15.366   220.234     0.150
    15.544   221.852     0.150
    15.588   221.844     0.150
    15.635   223.406     0.150
    15.672   223.664     0.150
    15.672   222.961     0.150
    15.744   223.961     0.150
    15.805   224.016     0.150
    15.819   225.641     0.150
    16.054   226.445     0.150
    16.103   229.031     0.150
    16.103   229.531     0.150
    16.274   230.430     0.150
    16.352   232.133     0.150
    16.425   232.594     0.150
    16.495   231.883     0.150
    16.575   232.234     0.150
    16.522   233.633     0.150
    16.657   233.641     0.150
    16.687   229.430     0.150
    16.822   234.734     0.150
    16.870   238.039     0.150
    16.956   240.680     0.150
    17.510   244.023     0.150
    17.540   246.602     0.150
    17.546   248.430     0.150
    17.669   247.320     0.150
    18.284   254.133     0.150
    18.285   254.016     0.150
    18.644   258.133     0.150
    19.306   266.461     0.150
    19.650   270.633     0.150
    20.057   272.789     0.150
    20.954   285.039     0.150
    21.054   284.430     0.150
    21.369   287.930     0.150
    21.725   292.234     0.150
    21.751   292.516     0.150
    21.774   291.750     0.150
    22.032   295.125     0.150
    22.469   299.336     0.150
    23.025   305.133     0.150
    23.036   305.641     0.150
    23.083   306.133     0.150
    23.280   307.133     0.150
    23.820   313.086     0.150
    23.818   314.477     0.150
    23.919   314.852     0.150
    24.029   317.070     0.150
    24.072   315.875     0.150
    24.383   318.531     0.150
    24.415   319.633     0.150
    24.415   319.031     0.150
    24.438   319.164     0.150
    26.318   336.234     0.150
    26.318   336.555     0.150
    26.725   339.930     0.150
    26.900   341.672     0.150
    26.961   343.273     0.150
    27.158   343.680     0.150
    28.077   353.586     0.150
    28.077   353.977     0.150
    28.334   353.641     0.150
    28.361   353.984     0.150
    28.994   360.234     0.150
    29.347   362.820     0.150
    29.465   364.031     0.150
    29.497   364.555     0.150
    30.309   372.477     0.150
    30.309   372.477     0.150
    30.699   374.859     0.150
    31.009   377.383     0.150
    31.066   378.391     0.150
    31.250   380.273     0.150
    32.211   388.289     0.150
    32.609   391.977     0.150
    33.575   400.273     0.150
    33.592   400.633     0.150
    33.881   403.156     0.150
    34.360   407.641     0.150
    34.408   407.781     0.150
    34.557   410.516     0.150
    35.306   415.820     0.150
    35.252   417.039     0.150
    35.492   419.234     0.150
    35.492   420.602     0.150
    35.735   419.930     0.150
    35.903   419.930     0.150
    36.269   425.820     0.150
    36.287   425.430     0.150
    36.558   427.461     0.150
    36.685   426.805     0.150
    36.629   428.031     0.150
    37.380   434.234     0.150
    37.430   434.992     0.150
    37.655   436.711     0.150
    37.908   438.836     0.150
    37.940   439.336     0.150
    37.940   438.953     0.150
    38.199   441.883     0.150
    38.311   442.430     0.150
    38.487   443.609     0.150
    38.557   444.742     0.150
    38.824   446.352     0.150
    38.948   448.641     0.150
    40.649   460.727     0.150
    40.610   461.781     0.150
    40.724   460.906     0.150
    40.724   460.070     0.150
    40.851   462.422     0.150
    40.928   464.102     0.150
    42.829   477.484     0.150
    42.829   582.156     0.150
    43.742   486.430     0.150
    43.742   486.633     0.150
    45.190   502.773     0.150
    45.622   504.750     0.150
    45.866   503.977     0.150
    46.008   505.477     0.150
    46.161   511.070     0.150
    46.387   509.633     0.150
    46.738   510.352     0.150
    46.774   511.102     0.150
    46.957   512.992     0.150
    47.081   514.141     0.150
    47.102   514.859     0.150
    47.104   515.406     0.150
    47.104   512.312     0.150
    47.135   515.766     0.150
    47.284   518.656     0.150
    47.368   515.766     0.150
    47.557   517.570     0.150
    50.878   542.234     0.150
    50.933   542.328     0.150
    50.933   542.133     0.150
    55.676   576.836     0.150
    56.198   584.336     0.150
    56.198   581.680     0.150
    60.427   609.836     0.150
    62.750   630.031     0.150
    63.267   631.234     0.150
    63.271   631.234     0.150
    64.375   635.250     0.150
    66.060   647.883     0.150
    70.264   675.414     0.150
    72.626   691.430     0.150
    74.609   699.766     0.150
    74.609   699.758     0.150
    75.360   704.508     0.150
    77.419   715.836     0.150
    77.419   716.430     0.150
    77.419   716.430     0.150
    77.689   718.031     0.150
    77.689   719.133     0.150
    78.108   722.531     0.150
    78.108     3.398     0.150
    78.108   727.234     0.150
    78.108   731.633     0.150
    78.108  1343.234     0.150
    79.415   726.336     0.150
    79.769   729.234     0.150
    80.014   729.133     0.150
    80.014   731.594     0.150
    80.662   734.336     0.150
    80.700   734.336     0.150
    80.945   739.633     0.150
    80.953   735.633     0.150
    81.251   738.336     0.150
    81.513   738.836     0.150
    81.537   740.031     0.150
    81.554   738.336     0.150
    81.554   738.281     0.150
    81.675   742.633     0.150
    81.675   746.633     0.150
    82.159   742.336     0.150
    82.198   742.430     0.150
    82.320   743.266     0.150
    82.351   744.234     0.150
    82.373   743.734     0.150
    82.424   743.734     0.150
    82.361   743.961     0.150
    82.442   743.734     0.150
    82.442   743.930     0.150
    83.080   749.234     0.150
    83.080  1370.133     0.150
    83.080   747.930     0.150
    83.081   747.930     0.150
    83.353   749.695     0.150
    83.442   746.336     0.150
    83.518   748.633     0.150
    83.518   749.461     0.150
    83.616   750.031     0.150
    83.648   749.836     0.150
    83.736   750.734     0.150
    83.803   750.531     0.150
    83.809   750.930     0.150
    83.810   750.734     0.150
    83.851   751.133     0.150
    83.908   751.633     0.150
    83.910   750.930     0.150
    83.920   751.234     0.150
    84.065   754.734     0.150
    84.258   752.734     0.150
    84.304   752.781     0.150
    84.315   754.031     0.150
    84.461   754.031     0.150
    84.588   754.734     0.150
    84.739   755.633     0.150
    84.754   755.531     0.150
    84.964   756.531     0.150
    85.234   757.633     0.150
    85.234   761.633     0.150
    85.219   756.430     0.150
    85.271   761.930     0.150
    85.419   758.930     0.150
    85.583   760.133     0.150
    85.659   760.031     0.150
    85.892   761.234     0.150
    85.953   762.383     0.150
    85.985   762.133     0.150
    86.477   763.930     0.150
    86.500   764.734     0.150
    86.523   764.930     0.150
    87.154   766.719     0.150
    87.378   767.234     0.150
    87.378   767.211     0.150
    87.382   768.703     0.150
    87.452   768.234     0.150
    87.627   773.125     0.150
    88.252   770.977     0.150
    89.052   776.883     0.150
    89.052   776.883     0.150
    89.606   777.703     0.150
    89.676   778.125     0.150
    89.676   781.812     0.150
    89.738   782.930     0.150
    89.747   780.531     0.150
    89.808   780.734     0.150
    90.013   780.336     0.150
    90.186   779.539     0.150
    90.186   783.875     0.150
    90.475   783.133     0.150
    90.613   787.836     0.150
    90.695   783.234     0.150
    90.695   784.164     0.150
    90.971   788.430     0.150
    91.254   791.430     0.150
    91.538   786.234     0.150
    91.565   791.734     0.150
    91.565  1423.930     0.150
    91.701   790.734     0.150
    91.701   787.906     0.150
    91.701   787.930     0.150
    91.855   789.430     0.150
    91.987   791.172     0.150
    91.987   791.172     0.150
    92.450   792.680     0.150
    92.454   792.680     0.150
    92.727   793.133     0.150
    92.988   794.336     0.150
    93.173   798.234     0.150
    93.253   794.734     0.150
    94.439   800.531     0.150
    94.443   801.031     0.150
    94.655   804.930     0.150
    94.757   801.836     0.150
    94.988   803.484     0.150
    95.022   806.234     0.150
    95.051   805.734     0.150
    95.051   802.773     0.150
    95.409  1039.633     0.150
    95.409  1441.234     0.150
    95.409  1479.430     0.150
    95.409  1870.336     0.150
    96.122   808.031     0.150
    96.533   810.531     0.150
    96.635   810.508     0.150
    96.843   810.633     0.150
    99.784   826.062     0.150
    99.784   826.055     0.150
   101.483   836.234     0.150
   101.483  1089.633     0.150
   101.483  1473.633     0.150
   101.583   834.031     0.150
   107.146   860.633     0.150
   107.146  1579.031     0.150
   107.146  2033.836     0.150
   117.222  1125.758     0.150
   119.195  1129.516     0.150
   119.195  1129.516     0.150
   139.685  1170.359     0.150
   144.545  1175.023     0.150
   145.068  1177.633     0.150
   145.915  1179.633     0.150
     0.202     4.219     0.150
     0.202     6.141     0.150
     0.312     5.547     0.150
     0.312    10.727     0.150
     0.530    10.109     0.150
     0.522     9.961     0.150
     0.564    10.695     0.150
     0.624    11.422     0.150
     0.588    11.367     0.150
     0.641    11.891     0.150
     0.745    13.148     0.150
     0.773    13.141     0.150
     0.754    13.375     0.150
     0.754    24.500     0.150
     0.754    24.016     0.150
     0.785    14.172     0.150
     0.870    15.211     0.150
     0.903    15.422     0.150
     0.903    27.711     0.150
     0.903    27.531     0.150
     0.962    17.406     0.150
     1.087    20.086     0.150
     1.087    34.398     0.150
     1.163    21.047     0.150
     1.163    35.828     0.150
     1.230    22.430     0.150
     1.230    39.148     0.150
     1.376    22.352     0.150
     1.376    39.391     0.150
     1.230    22.328     0.150
     1.230    39.609     0.150
     1.449    23.625     0.150
     1.449    41.258     0.150
     1.527    27.352     0.150
     1.527    45.758     0.150
     1.610    26.125     0.150
     1.578    25.867     0.150
     1.578    47.406     0.150
     1.795    50.094     0.150
     2.017    32.016     0.150
     2.512    67.555     0.150
     2.762    42.602     0.150
     2.762    75.859     0.150
     2.789    43.445     0.150
     2.921    79.070     0.150
     3.078    81.453     0.150
     3.639    55.891     0.150
     3.928    59.438     0.150
     4.243    63.539     0.150
     4.642    70.586     0.150
     4.715    89.570     0.150
     6.429    93.789     0.150
     6.586   213.602     0.150
     7.292   106.805     0.150
     7.905   116.570     0.150
     8.452   268.195     0.150
     8.513   123.180     0.150
    10.491   328.008     0.150
    16.024   230.625     0.150
    23.063   306.852     0.150
    27.984   353.273     0.150
    30.236   371.695     0.150
    37.810   438.289     0.150
    37.843   438.797     0.150
    40.514   460.031     0.150
    45.765   502.711     0.150
    47.059   515.438     0.150
    47.209   515.820     0.150
    47.465   516.305     0.150
    55.634   577.398     0.150
    70.742   675.898     0.150
    74.555   699.484     0.150
    77.382   716.000     0.150
    77.382   716.570     0.150
    77.616   717.523     0.150
    79.880   729.695     0.150
    80.650   734.195     0.150
    80.941   735.695     0.150
    81.506   738.750     0.150
    82.189   742.398     0.150
    82.254   742.414     0.150
    82.383   743.602     0.150
    82.406   743.797     0.150
    82.451   743.602     0.150
    82.974   748.398     0.150
    83.600   749.898     0.150
    83.637   749.695     0.150
    83.791   750.500     0.150
    83.795   750.695     0.150
    83.796   750.797     0.150
    83.797   751.195     0.150
    83.837   751.102     0.150
    83.891   751.695     0.150
    83.898   750.898     0.150
    83.912   751.297     0.150
    84.245   752.695     0.150
    84.308   752.648     0.150
    84.311   754.102     0.150
    84.453   753.898     0.150
    84.571   754.695     0.150
    84.736   755.602     0.150
    84.947   756.500     0.150
    85.405   759.000     0.150
    85.636   760.602     0.150
    86.465   763.602     0.150
    86.487   764.398     0.150
    86.509   765.000     0.150
    87.354   766.969     0.150
    91.661   787.180     0.150
    91.886   790.297     0.150
    92.366   791.305     0.150
   117.155  1126.648     0.150
   119.134  1129.852     0.150
   144.621  1175.914     0.150
   145.998  1180.500     0.150
     0.312     9.625     0.150
     0.361    11.703     0.150
     0.374     6.750     0.150
     0.444     8.180     0.150
     0.555     9.547     0.150
     0.575    10.172     0.150
     0.572    10.172     0.150
     0.654    10.703     0.150
     0.654    19.703     0.150
     0.714    11.703     0.150
     0.723    12.703     0.150
     0.738    12.703     0.150
     0.882    15.234     0.150
     0.882    26.141     0.150
     0.882    14.703     0.150
     0.936    30.375     0.150
     0.968    17.734     0.150
     0.968    30.016     0.150
     1.230    20.109     0.150
     1.164    28.703     0.150
     1.401    22.820     0.150
     1.378    23.852     0.150
     1.378    41.875     0.150
     1.378    41.266     0.150
     1.379    43.734     0.150
     1.557    44.227     0.150
     1.585    25.516     0.150
     1.612    25.688     0.150
     1.763    28.141     0.150
     1.802    29.047     0.150
     1.802    54.750     0.150
     2.220    34.398     0.150
     2.394    37.062     0.150
     2.394    66.000     0.150
     2.466    37.914     0.150
     2.466    65.875     0.150
     2.518    43.719     0.150
     2.518    75.086     0.150
     2.574    40.133     0.150
     2.587    40.148     0.150
     2.587    78.727     0.150
     2.626    45.688     0.150
     2.626    79.445     0.150
     2.948    51.344     0.150
     2.948    88.523     0.150
     3.424    58.930     0.150
     3.753    65.531     0.150
     3.981    60.602     0.150
     4.047    60.516     0.150
     4.652    70.352     0.150
     4.823    71.828     0.150
     5.140    76.727     0.150
     5.446    80.539     0.150
     5.548    82.852     0.150
     7.426   108.133     0.150
     7.997   117.680     0.150
     8.307   264.305     0.150
    10.677   152.930     0.150
    10.677   334.281     0.150
    11.365   165.000     0.150
    15.865   226.656     0.150
    15.865   224.055     0.150
    20.847   281.875     0.150
    21.738   291.852     0.150
    23.025   305.703     0.150
    24.136   318.125     0.150
    27.798   350.602     0.150
    30.090   369.648     0.150
    37.393   434.055     0.150
    37.648   436.555     0.150
    45.562   500.164     0.150
    46.311   506.984     0.150
    46.470   513.641     0.150
    47.422   517.445     0.150
    47.865   520.453     0.150
    55.552   576.016     0.150
    55.552   576.406     0.150
    60.275   607.906     0.150
    62.570   625.055     0.150
    70.954   676.523     0.150
    74.447   698.625     0.150
    77.309   715.203     0.150
    77.309   714.703     0.150
    79.432   725.906     0.150
    80.627   733.000     0.150
    80.669   733.203     0.150
    80.919   734.500     0.150
    81.413   737.406     0.150
    82.108   740.906     0.150
    82.173   741.305     0.150
    82.372   742.500     0.150
    82.404   742.703     0.150
    82.472   742.703     0.150
    83.569   748.703     0.150
    83.618   748.602     0.150
    83.716   749.602     0.150
    83.765   749.500     0.150
    83.770   749.305     0.150
    83.772   749.703     0.150
    83.793   750.203     0.150
    83.812   750.000     0.150
    83.859   750.406     0.150
    83.875   749.703     0.150
    83.896   750.203     0.150
    84.222   751.500     0.150
    84.306   753.102     0.150
    84.318   753.180     0.150
    84.437   752.805     0.150
    84.540   753.500     0.150
    84.702   754.305     0.150
    84.915   755.305     0.150
    85.378   757.805     0.150
    85.565   758.703     0.150
    85.861   760.000     0.150
    86.461   763.500     0.150
    86.484   763.602     0.150
    87.032   765.805     0.150
    87.307   767.656     0.150
    91.581   787.055     0.150
    91.684   787.383     0.150
   117.019  1125.234     0.150
   119.008  1129.266     0.150
   144.771  1175.641     0.150
     0.185     2.516     0.150
     0.185     5.476     0.150
     0.488     8.966     0.150
     0.488    16.806     0.150
     0.799    14.446     0.150
     0.925    16.376     0.150
     0.933    17.026     0.150
     0.933    28.346     0.150
     0.964    17.576     0.150
     1.010    17.556     0.150
     0.964    17.676     0.150
     0.964    31.836     0.150
     0.964    31.026     0.150
     1.082    18.526     0.150
     1.123    32.986     0.150
     1.195    20.036     0.150
     1.234    21.356     0.150
     1.408    24.806     0.150
     1.434    24.556     0.150
     1.434    24.706     0.150
     1.512    25.333     0.150
     1.512    46.123     0.150
     1.573    26.986     0.150
     1.573    48.526     0.150
     1.748    27.406     0.150
     1.748    47.758     0.150
     1.888    58.396     0.150
     1.957    35.896     0.150
     1.993    32.240     0.150
     1.993    61.426     0.150
     2.057    32.186     0.150
     2.057    31.959     0.150
     2.211    34.221     0.150
     2.211    58.499     0.150
     2.261    60.736     0.150
     2.463    69.706     0.150
     2.568    40.896     0.150
     2.808    76.628     0.150
     2.842    75.612     0.150
     2.887    43.506     0.150
     3.132    57.086     0.150
     3.148    96.414     0.150
     3.205    48.687     0.150
     3.205    97.736     0.150
     3.267    99.358     0.150
     3.413    60.386     0.150
     3.460    64.636     0.150
     3.460   107.216     0.150
     3.622    65.876     0.150
     3.666    65.886     0.150
     4.371   726.736     0.150
     4.557    68.766     0.150
     4.561   147.066     0.150
     4.570    69.696     0.150
     4.693    70.986     0.150
     5.204    77.396     0.150
     5.384    80.386     0.150
     5.442    80.846     0.150
     5.765    85.436     0.150
     5.980    88.986     0.150
     6.247    92.716     0.150
     7.007   107.936     0.150
     7.007   226.696     0.150
     7.007   226.692     0.150
     7.058   103.516     0.150
     7.120   104.336     0.150
     7.392   108.486     0.150
     7.433   108.696     0.150
     7.476   113.186     0.150
     7.527   111.466     0.150
     7.768   114.986     0.150
     7.768   113.736     0.150
     7.821   117.186     0.150
     7.973   119.256     0.150
     8.043   118.686     0.150
     8.081   119.956     0.150
     8.130   121.696     0.150
     8.139   121.176     0.150
     8.216   117.846     0.150
     8.350   123.856     0.150
     8.432   125.486     0.150
     8.516   126.586     0.150
     8.658   130.186     0.150
     8.790   128.586     0.150
     8.790   127.886     0.150
     8.886   129.656     0.150
     8.851   131.955     0.150
     8.989   133.186     0.150
     9.057   131.996     0.150
     9.112   134.686     0.150
     9.127   135.156     0.150
     9.455   139.206     0.150
     9.455   139.496     0.150
     9.467   134.736     0.150
     9.612   139.666     0.150
     9.739   140.516     0.150
     9.756   142.766     0.150
     9.851   145.556     0.150
     9.987   146.386     0.150
    10.041   146.686     0.150
    10.128   146.686     0.150
    10.128   146.661     0.150
    10.128   317.236     0.150
    10.178   148.546     0.150
    10.498   153.096     0.150
    10.799   160.556     0.150
    10.862   159.186     0.150
    10.944   159.186     0.150
    11.249   163.606     0.150
    11.474   167.886     0.150
    11.545   166.196     0.150
    11.537   166.896     0.150
    11.542   170.086     0.150
    11.614   170.086     0.150
    11.649   168.666     0.150
    11.649   168.736     0.150
    11.649   168.736     0.150
    11.730   172.846     0.150
    11.873   171.576     0.150
    11.973   172.976     0.150
    11.989   173.756     0.150
    12.093   175.526     0.150
    12.166   175.146     0.150
    12.323   178.826     0.150
    12.365   178.776     0.150
    12.371   182.176     0.150
    12.593   181.816     0.150
    12.622   185.566     0.150
    12.648   180.936     0.150
    12.713   186.366     0.150
    12.917   187.586     0.150
    12.918   188.136     0.150
    12.981   189.906     0.150
    13.016   190.856     0.150
    13.042   188.046     0.150
    13.119   188.086     0.150
    13.176   191.526     0.150
    13.203   191.446     0.150
    13.537   196.666     0.150
    13.678   197.416     0.150
    13.892   201.286     0.150
    13.871   197.886     0.150
    13.909   199.916     0.150
    13.900   201.116     0.150
    13.975   203.356     0.150
    14.007   201.966     0.150
    14.117   203.836     0.150
    14.444   207.226     0.150
    14.752   211.076     0.150
    14.756   209.996     0.150
    14.845   211.186     0.150
    14.895   214.386     0.150
    14.914   210.286     0.150
    14.957   214.246     0.150
    14.923   212.266     0.150
    15.018   215.436     0.150
    15.056   214.336     0.150
    15.098   215.316     0.150
    15.156   215.516     0.150
    15.329   218.676     0.150
    15.391   220.666     0.150
    15.452   226.106     0.150
    15.571   221.836     0.150
    15.683   224.286     0.150
    15.799   225.856     0.150
    15.895   226.566     0.150
    15.897   226.086     0.150
    15.925   225.116     0.150
    15.998   231.096     0.150
    16.034   228.496     0.150
    16.061   225.246     0.150
    16.135   230.536     0.150
    16.213   229.806     0.150
    16.384   232.286     0.150
    16.384   232.561     0.150
    16.384   516.811     0.150
    16.451   230.946     0.150
    16.560   234.046     0.150
    16.591   242.986     0.150
    16.591   433.216     0.150
    16.592   232.886     0.150
    16.847   240.526     0.150
    17.123   241.206     0.150
    17.266   244.746     0.150
    17.723   249.226     0.150
    17.851   250.926     0.150
    18.133   252.686     0.150
    18.438   256.666     0.150
    18.668   258.386     0.150
    19.158   264.146     0.150
    19.755   272.316     0.150
    20.031   274.986     0.150
    20.768   283.596     0.150
    21.306   286.986     0.150
    21.572   290.386     0.150
    21.773   292.666     0.150
    21.855   292.926     0.150
    21.927   294.436     0.150
    22.445   300.986     0.150
    22.896   305.786     0.150
    22.944   305.546     0.150
    23.186   308.086     0.150
    23.186   732.436     0.150
    23.177   308.456     0.150
    23.488   311.905     0.150
    23.649   312.946     0.150
    23.970   313.676     0.150
    24.002   315.556     0.150
    24.282   318.386     0.150
    24.454   319.306     0.150
    24.595   319.386     0.150
    24.595   320.086     0.150
    26.182   335.086     0.150
    26.182   335.811     0.150
    27.079   343.486     0.150
    27.286   345.866     0.150
    28.193   353.796     0.150
    28.392   356.761     0.150
    28.392   356.976     0.150
    28.877   359.986     0.150
    29.400   364.386     0.150
    29.582   366.116     0.150
    30.332   372.386     0.150
    30.570   374.731     0.150
    30.570   553.731     0.150
    30.570   374.736     0.150
    30.570   553.736     0.150
    30.898   376.216     0.150
    30.988   378.046     0.150
    31.172   379.856     0.150
    31.196   380.506     0.150
    32.125   388.196     0.150
    32.448   392.896     0.150
    32.546   393.346     0.150
    33.500   399.776     0.150
    33.555   401.386     0.150
    33.844   404.806     0.150
    34.024   405.786     0.150
    34.357   408.656     0.150
    34.768   412.186     0.150
    35.571   419.966     0.150
    35.691   419.186     0.150
    35.841   421.586     0.150
    36.330   426.786     0.150
    36.564   427.386     0.150
    36.595   429.056     0.150
    36.606   428.086     0.150
    36.962   431.686     0.150
    37.955   439.411     0.150
    38.238   442.586     0.150
    38.266   442.186     0.150
    38.266   441.876     0.150
    38.530   444.576     0.150
    38.637   445.586     0.150
    38.818   446.936     0.150
    38.891   448.026     0.150
    39.156   450.446     0.150
    40.776   461.786     0.150
    40.776   461.186     0.150
    40.933   464.336     0.150
    41.256   466.906     0.150
    42.957   478.161     0.150
    43.974   487.986     0.150
    43.974   488.111     0.150
    46.201   506.866     0.150
    46.431   509.276     0.150
    46.643   511.624     0.150
    46.643   510.866     0.150
    46.773   512.276     0.150
    46.773   511.016     0.150
    46.777   513.926     0.150
    46.807   512.106     0.150
    47.074   512.816     0.150
    47.220   515.286     0.150
    47.244   515.156     0.150
    51.067   543.586     0.150
    52.261   555.236     0.150
    53.873   563.686     0.150
    55.845   578.886     0.150
    55.845   578.686     0.150
    56.532   584.186     0.150
    56.532   585.066     0.150
    60.624   610.286     0.150
    63.219   629.711     0.150
    64.052   634.156     0.150
    65.314   644.686     0.150
    66.473   649.916     0.150
    66.473   649.911     0.150
    69.922   671.956     0.150
    72.960   690.286     0.150
    74.815   700.616     0.150
    74.814   700.611     0.150
    74.919   700.886     0.150
    74.912   702.786     0.150
    75.460   706.511     0.150
    77.211   718.086     0.150
    77.572   717.486     0.150
    77.572   718.236     0.150
    77.572   718.236     0.150
    77.905   721.486     0.150
    79.074   725.968     0.150
    79.525   726.986     0.150
    79.702   727.786     0.150
    79.702   729.826     0.150
    79.833   729.086     0.150
    79.957   729.686     0.150
    80.737   733.986     0.150
    80.773   734.386     0.150
    81.029   735.486     0.150
    81.230   734.986     0.150
    81.581   737.186     0.150
    81.712   737.986     0.150
    81.738   740.386     0.150
    81.738   740.336     0.150
    81.890   739.186     0.150
    81.989   743.746     0.150
    82.251   742.286     0.150
    82.264   742.086     0.150
    82.519   743.886     0.150
    82.534   746.176     0.150
    82.737   747.196     0.150
    83.177   747.386     0.150
    83.177   747.561     0.150
    83.449   751.206     0.150
    83.417   748.623     0.150
    83.417   748.586     0.150
    83.704   749.886     0.150
    83.718   749.686     0.150
    83.797   750.586     0.150
    83.785   745.586     0.150
    83.847   750.686     0.150
    83.876   750.386     0.150
    83.886   750.686     0.150
    83.897   750.686     0.150
    83.930   750.986     0.150
    83.986   750.786     0.150
    83.985   751.186     0.150
    83.998   751.586     0.150
    84.254   754.686     0.150
    84.327   753.511     0.150
    84.334   752.586     0.150
    84.526   753.786     0.150
    84.677   754.686     0.150
    84.790   755.586     0.150
    84.847   755.486     0.150
    85.054   756.386     0.150
    85.355   760.086     0.150
    85.355   954.086     0.150
    85.408   757.486     0.150
    85.444   756.486     0.150
    85.502   758.986     0.150
    85.612   761.186     0.150
    85.640   759.386     0.150
    85.768   763.186     0.150
    85.963   761.186     0.150
    86.051   761.586     0.150
    86.074   763.856     0.150
    86.580   764.586     0.150
    86.596   765.986     0.150
    86.603   765.086     0.150
    86.885   767.086     0.150
    86.993   765.986     0.150
    87.034   766.086     0.150
    87.145   766.786     0.150
    87.210   768.386     0.150
    87.223   767.486     0.150
    87.458   768.986     0.150
    87.458   774.286     0.150
    87.458     5.300     0.150
    87.490   769.536     0.150
    87.547   768.916     0.150
    87.884   769.786     0.150
    87.920   769.786     0.150
    87.968   770.186     0.150
    88.087   771.786     0.150
    88.597   774.086     0.150
    88.946   775.986     0.150
    89.782   779.786     0.150
    89.932   781.086     0.150
    89.932   780.420     0.150
    89.935   781.586     0.150
    90.075   782.986     0.150
    90.149   782.186     0.150
    90.527   784.286     0.150
    90.606   784.586     0.150
    90.650   785.586     0.150
    90.822   784.086     0.150
    90.936   785.586     0.150
    90.938   787.986     0.150
    91.300   788.486     0.150
    91.508   789.686     0.150
    91.814   790.286     0.150
    91.814  1009.186     0.150
    91.814  1422.786     0.150
    91.865   789.586     0.150
    91.865   788.986     0.150
    91.865   788.986     0.150
    91.866   788.586     0.150
    92.155   789.586     0.150
    92.321   793.266     0.150
    92.321   793.266     0.150
    92.752   793.756     0.150
    92.756   793.761     0.150
    95.750  1485.386     0.150
    99.616   823.586     0.150
   100.088   828.786     0.150
   101.775   835.386     0.150
   101.799   838.386     0.150
   101.799  1092.086     0.150
   101.799  1476.086     0.150
   101.987   832.886     0.150
   107.488  1582.286     0.150
   107.488  2038.886     0.150
   117.406  1130.461     0.150
   119.361  1133.746     0.150
   119.361  1133.748     0.150
   120.237  1134.736     0.150
   120.237  1134.736     0.150
   144.277  1175.886     0.150
   144.277  1175.399     0.150
   144.855  1177.686     0.150
   144.855  1178.086     0.150
   145.674  1180.086     0.150
     0.178     4.083     0.150
     0.497     9.513     0.150
     0.497    17.653     0.150
     0.495     9.503     0.150
     0.539    10.003     0.150
     0.539    18.033     0.150
     0.613    11.183     0.150
     0.711    12.123     0.150
     0.711    22.613     0.150
     0.727    12.463     0.150
     0.871    14.338     0.150
     0.871    25.158     0.150
     0.888    15.453     0.150
     0.888    27.783     0.150
     0.944    17.123     0.150
     1.057    18.815     0.150
     1.057    32.802     0.150
     1.091    19.513     0.150
     1.156    20.523     0.150
     1.156    35.543     0.150
     1.264    22.313     0.150
     1.264    42.583     0.150
     1.264    41.573     0.150
     1.342    21.549     0.150
     1.433    23.147     0.150
     1.433    40.253     0.150
     1.570    27.619     0.150
     1.585    25.208     0.150
     1.585    48.783     0.150
     1.998    31.471     0.150
     1.998    61.452     0.150
     2.204    33.654     0.150
     2.240    68.289     0.150
     2.299    35.271     0.150
     2.299    63.526     0.150
     2.337    71.764     0.150
     2.567    39.593     0.150
     2.712    47.292     0.150
     2.712    81.839     0.150
     2.757    42.256     0.150
     2.757    76.553     0.150
     2.780    47.945     0.150
     2.780    83.207     0.150
     2.822    48.714     0.150
     2.822    85.047     0.150
     3.145    54.514     0.150
     3.145    95.364     0.150
     3.368    59.632     0.150
     3.368   102.482     0.150
     3.621    62.106     0.150
     3.621   108.764     0.150
     3.887    56.373     0.150
     3.905    58.768     0.150
     4.219   127.905     0.150
     4.614    69.690     0.150
     4.834    72.427     0.150
     5.047    74.700     0.150
     5.047   132.654     0.150
     5.269    76.864     0.150
     5.470    81.386     0.150
     5.470   142.827     0.150
     6.422    92.950     0.150
     6.422   162.827     0.150
     7.302   106.727     0.150
     7.476   109.744     0.150
     7.888   115.258     0.150
     8.509   121.932     0.150
     8.789   127.147     0.150
     9.538   137.178     0.150
    10.494   150.308     0.150
    15.990   226.933     0.150
    23.032   304.858     0.150
     0.226     3.967     0.150
     0.226     5.837     0.150
     0.720    12.483     0.150
     0.720    22.718     0.150
     0.910    15.910     0.150
     0.910    26.669     0.150
     0.910    27.097     0.150
     1.028    18.353     0.150
     1.028    31.631     0.150
     1.045    18.917     0.150
     1.045    33.107     0.150
     1.045    33.537     0.150
     1.118    19.877     0.150
     1.118    34.277     0.150
     1.246    22.127     0.150
     1.246    39.817     0.150
     1.357    21.582     0.150
     1.357    37.988     0.150
     1.482    24.070     0.150
     1.482    42.124     0.150
     1.534    26.127     0.150
     1.534    46.108     0.150
     1.573    44.732     0.150
     1.573    24.931     0.150
     1.573    44.043     0.150
     1.573    24.447     0.150
     1.573    43.847     0.150
     1.767    27.962     0.150
     1.873    29.133     0.150
     1.975    59.931     0.150
     2.247    70.299     0.150
     2.557    67.778     0.150
     2.692    47.267     0.150
     2.692    80.725     0.150
     2.718    43.032     0.150
     2.718    83.236     0.150
     2.745    47.857     0.150
     2.745    83.404     0.150
     2.789    52.007     0.150
     2.791    48.256     0.150
     2.791    83.955     0.150
     2.924    45.887     0.150
     2.924    89.477     0.150
     2.973    46.497     0.150
     2.973    53.777     0.150
     2.973    89.757     0.150
     3.120    54.604     0.150
     3.120    94.769     0.150
     3.211    50.267     0.150
     3.352    57.834     0.150
     3.596    61.972     0.150
     3.596   107.690     0.150
     3.596    55.017     0.150
     3.596   109.317     0.150
     3.933    59.067     0.150
     3.952    59.269     0.150
     4.001    69.506     0.150
     4.206    64.227     0.150
     4.206    81.107     0.150
     4.206   129.698     0.150
     4.205    61.667     0.150
     4.205    77.367     0.150
     4.205   126.917     0.150
     4.658   146.577     0.150
     5.095    75.159     0.150
     5.517    81.587     0.150
     5.718   108.187     0.150
     5.951   114.477     0.150
     6.469    93.975     0.150
     6.469    93.287     0.150
     7.018   102.718     0.150
     7.248   105.977     0.150
     7.326   106.677     0.150
     7.936   116.557     0.150
     8.088   120.667     0.150
    10.535   152.857     0.150
    11.441   167.907     0.150
    16.003   227.832     0.150
    23.070   306.857     0.150
    27.956   351.582     0.150
    30.219   369.952     0.150
    37.542   435.432     0.150
    37.812   438.057     0.150
    55.632   577.557     0.150
    81.502   738.383     0.150
     0.148     2.250     0.150
     0.148     5.271     0.150
     0.272     5.921     0.150
     0.272     8.361     0.150
     0.824    14.991     0.150
     0.938    27.533     0.150
     0.975    16.000     0.150
     0.975    27.500     0.150
     0.975    28.765     0.150
     1.105    19.991     0.150
     1.105    35.851     0.150
     1.105    20.141     0.150
     1.105    37.721     0.150
     1.224    38.871     0.150
     1.224    21.811     0.150
     1.224    38.621     0.150
     1.255    21.731     0.150
     1.255    36.852     0.150
     1.392    22.771     0.150
     1.392    39.733     0.150
     1.526    24.299     0.150
     1.526    42.660     0.150
     1.717    27.182     0.150
     1.717    51.907     0.150
     1.750    28.596     0.150
     1.797    55.500     0.150
     1.797    49.476     0.150
     2.017    31.427     0.150
     2.065    32.095     0.150
     2.065    56.040     0.150
     2.124    39.301     0.150
     2.162    33.671     0.150
     2.204    34.369     0.150
     2.204    67.287     0.150
     2.284    35.087     0.150
     2.348    35.950     0.150
     2.348    71.377     0.150
     2.675    40.938     0.150
     2.665    40.755     0.150
     2.936    46.031     0.150
     2.921    52.851     0.150
     2.921    44.447     0.150
     2.962    45.339     0.150
     2.962    89.113     0.150
     3.016    52.298     0.150
     3.016    90.546     0.150
     3.162    48.141     0.150
     3.153    55.701     0.150
     3.153    96.401     0.150
     3.201    56.621     0.150
     3.201    96.431     0.150
     3.349    58.635     0.150
     3.775    57.000     0.150
     3.775    98.401     0.150
     3.800    69.241     0.150
     3.825   114.125     0.150
     3.825    65.831     0.150
     3.908    58.819     0.150
     4.134    61.608     0.150
     4.359    66.011     0.150
     4.431   115.801     0.150
     4.657    70.149     0.150
     4.827    71.071     0.150
     4.926    73.929     0.150
     5.026    74.279     0.150
     5.026   129.869     0.150
     5.127    75.505     0.150
     5.259    78.500     0.150
     5.419    81.031     0.150
     5.466    81.071     0.150
     5.466    81.381     0.150
     5.459    81.131     0.150
     5.617    83.801     0.150
     5.783    86.521     0.150
     5.828    86.701     0.150
     6.206    91.039     0.150
     6.206    91.551     0.150
     6.248    93.551     0.150
     6.317    91.280     0.150
     6.762    99.000     0.150
     6.762    99.000     0.150
     6.854   100.960     0.150
     6.902   174.121     0.150
     7.146   104.000     0.150
     7.217   104.681     0.150
     7.222   109.911     0.150
     7.492   108.551     0.150
     7.509   109.956     0.150
     7.509   110.661     0.150
     7.527   109.051     0.150
     7.716   112.221     0.150
     7.771   117.191     0.150
     7.844   114.201     0.150
     7.844   114.101     0.150
     7.844   246.926     0.150
     7.858   116.131     0.150
     7.945   116.801     0.150
     8.025   117.201     0.150
     8.070   118.931     0.150
     8.098   118.831     0.150
     8.210   121.730     0.150
     8.385   122.901     0.150
     8.387   119.792     0.150
     8.575   123.848     0.150
     8.592   124.726     0.150
     8.592   269.801     0.150
     8.745   126.290     0.150
     8.861   130.500     0.150
     8.882   128.605     0.150
     8.949   130.401     0.150
     8.988   132.531     0.150
     9.107   136.070     0.150
     9.215   132.761     0.150
     9.475   138.571     0.150
     9.490   134.840     0.150
     9.489   136.140     0.150
     9.557   137.458     0.150
     9.623   140.261     0.150
     9.711   142.591     0.150
     9.719   141.611     0.150
     9.778   140.471     0.150
     9.824   140.101     0.150
     9.898   144.761     0.150
    10.215   147.271     0.150
    10.338   149.401     0.150
    10.338   149.351     0.150
    10.338   321.579     0.150
    10.554   155.581     0.150
    10.617   153.141     0.150
    10.667   151.791     0.150
    10.914   158.101     0.150
    11.105   162.201     0.150
    11.270   164.021     0.150
    11.426   165.921     0.150
    11.493   165.521     0.150
    11.484   170.031     0.150
    11.526   165.791     0.150
    11.526   165.331     0.150
    11.526   166.301     0.150
    11.640   167.541     0.150
    11.729   170.571     0.150
    11.827   171.651     0.150
    11.846   172.171     0.150
    11.951   173.500     0.150
    12.024   173.011     0.150
    12.217   176.771     0.150
    12.338   177.641     0.150
    12.389   180.611     0.150
    12.447   180.791     0.150
    12.470   182.471     0.150
    12.565   179.151     0.150
    12.769   184.761     0.150
    12.771   184.921     0.150
    12.800   186.631     0.150
    12.808   186.901     0.150
    13.018   188.191     0.150
    13.054   189.621     0.150
    13.190   187.851     0.150
    13.300   190.601     0.150
    13.365   193.750     0.150
    13.450   194.291     0.150
    13.654   196.531     0.150
    13.738   198.471     0.150
    13.773   197.951     0.150
    13.836   199.971     0.150
    13.904   200.541     0.150
    13.984   196.301     0.150
    14.300   206.710     0.150
    14.533   209.230     0.150
    14.617   209.991     0.150
    14.708   210.881     0.150
    14.789   211.750     0.150
    14.842   208.500     0.150
    14.837   211.960     0.150
    14.863   210.541     0.150
    15.078   213.641     0.150
    15.146   216.031     0.150
    15.153   213.891     0.150
    15.168   215.491     0.150
    15.244   214.701     0.150
    15.384   219.331     0.150
    15.444   220.801     0.150
    15.609   222.161     0.150
    15.609   518.451     0.150
    15.701   223.081     0.150
    15.736   223.960     0.150
    15.752   225.011     0.150
    15.816   224.011     0.150
    15.870   225.591     0.150
    15.896   226.031     0.150
    16.097   225.831     0.150
    16.174   228.901     0.150
    16.174   229.625     0.150
    16.406   231.621     0.150
    16.499   230.801     0.150
    16.499   232.451     0.150
    16.551   231.521     0.150
    16.771   235.701     0.150
    16.934   238.651     0.150
    17.033   237.061     0.150
    18.253   252.701     0.150
    18.326   254.511     0.150
    18.655   256.541     0.150
    19.680   269.281     0.150
    20.056   271.591     0.150
    20.914   283.901     0.150
    21.118   284.801     0.150
    21.353   287.500     0.150
    21.693   291.000     0.150
    21.761   292.411     0.150
    21.799   292.250     0.150
    22.012   294.480     0.150
    22.469   300.701     0.150
    22.999   305.401     0.150
    23.019   305.191     0.150
    23.113   305.875     0.150
    23.113   726.176     0.150
    23.261   308.201     0.150
    23.741   313.020     0.150
    23.784   313.311     0.150
    23.937   313.631     0.150
    24.298   317.500     0.150
    24.365   318.201     0.150
    24.447   318.480     0.150
    24.463   318.901     0.150
    26.290   335.000     0.150
    26.290   335.476     0.150
    26.691   338.901     0.150
    27.144   343.721     0.150
    28.155   353.976     0.150
    28.155   354.371     0.150
    28.305   353.541     0.150
    29.463   364.721     0.150
    30.213   370.901     0.150
    30.375   372.246     0.150
    30.375   372.250     0.150
    30.375   549.391     0.150
    30.988   377.241     0.150
    33.563   400.081     0.150
    33.589   399.701     0.150
    34.401   407.480     0.150
    35.331   416.831     0.150
    36.366   425.971     0.150
    37.511   436.801     0.150
    37.729   436.875     0.150
    38.020   439.701     0.150
    38.020   439.371     0.150
    38.391   443.901     0.150
    38.391   442.521     0.150
    38.638   443.571     0.150
    40.689   461.031     0.150
    40.742   460.276     0.150
    40.742   459.681     0.150
    41.008   464.181     0.150
    43.390   483.641     0.150
    43.802   485.301     0.150
    46.668   510.230     0.150
    47.026   512.041     0.150
    47.301   514.761     0.150
    47.301   514.871     0.150
    47.485   516.460     0.150
    50.928   542.500     0.150
    50.971   542.401     0.150
    55.722   576.901     0.150
    55.722   577.701     0.150
    56.279   581.401     0.150
    60.479   608.801     0.150
    62.962   627.051     0.150
    63.349   628.381     0.150
    63.352   628.375     0.150
    72.707   687.301     0.150
    74.663   698.971     0.150
    74.663   698.976     0.150
    74.765   698.601     0.150
    77.461   716.000     0.150
    77.461   716.331     0.150
    77.461   716.326     0.150
    77.745   717.500     0.150
    77.745   716.281     0.150
    79.790   728.301     0.150
    79.911   729.601     0.150
    80.686   733.401     0.150
    80.724   733.601     0.150
    80.977   735.000     0.150
    81.094   733.201     0.150
    81.331   734.901     0.150
    81.566   737.601     0.150
    81.603   738.500     0.150
    81.603   738.451     0.150
    82.187   742.301     0.150
    82.220   741.701     0.150
    82.381   743.000     0.150
    82.449   743.000     0.150
    82.453   743.701     0.150
    82.442   742.526     0.150
    83.159   746.051     0.150
    83.160   746.101     0.150
    83.524   748.500     0.150
    83.643   749.201     0.150
    83.671   750.000     0.150
    83.757   749.801     0.150
    83.826   750.201     0.150
    83.833   750.301     0.150
    83.837   750.000     0.150
    83.876   750.401     0.150
    83.934   750.301     0.150
    83.935   750.901     0.150
    83.942   750.500     0.150
    84.282   751.901     0.150
    84.315   752.551     0.150
    84.332   753.201     0.150
    84.483   753.201     0.150
    84.615   754.000     0.150
    84.782   754.801     0.150
    84.991   755.801     0.150
    85.269   757.701     0.150
    85.269   760.701     0.150
    85.277   756.500     0.150
    85.445   758.301     0.150
    85.988   761.821     0.150
    86.501   763.101     0.150
    86.525   764.000     0.150
    86.548   764.201     0.150
    86.987   765.801     0.150
    87.092   766.101     0.150
    87.142   769.701     0.150
    87.368   768.000     0.150
    87.368   772.500     0.150
    87.368     4.500     0.150
    87.410   767.101     0.150
    87.410   767.125     0.150
    87.481   768.971     0.150
    87.836   769.500     0.150
    89.790   778.500     0.150
    89.790   781.601     0.150
    89.827   783.901     0.150
    90.051   780.201     0.150
    90.512   782.701     0.150
    91.629  1811.201     0.150
    91.746   786.351     0.150
    91.746   786.401     0.150
    92.068   790.042     0.150
    92.525   790.351     0.150
    92.529   790.351     0.150
    93.846   797.701     0.150
    95.491  1484.701     0.150
    98.222   819.401     0.150
   109.361   866.101     0.150
   109.361  1108.500     0.150
   109.361  2058.401     0.150
   117.261  1125.033     0.150
   119.229  1128.701     0.150
   119.977  1131.901     0.150
   119.977  1131.901     0.150
   144.477  1174.464     0.150
   145.862  1179.951     0.150
     0.221     4.469     0.150
     0.895    15.130     0.150
     0.927    15.454     0.150
     0.927    27.347     0.150
     0.927    28.419     0.150
     1.155    21.159     0.150
     1.155    36.929     0.150
     1.220    21.369     0.150
     1.220    36.179     0.150
     1.227    37.339     0.150
     1.367    22.562     0.150
     1.367    39.178     0.150
     1.475    23.776     0.150
     1.730    28.140     0.150
     1.756    27.829     0.150
     1.756    27.451     0.150
     1.756    27.719     0.150
     1.756    52.389     0.150
     2.068    31.717     0.150
     2.068    31.909     0.150
     2.068    63.229     0.150
     2.171    66.595     0.150
     2.254    35.166     0.150
     2.254    68.459     0.150
     2.300    69.337     0.150
     2.558    77.352     0.150
     2.615    39.975     0.150
     2.885    88.078     0.150
     2.885    45.569     0.150
     2.885    55.009     0.150
     2.885    87.149     0.150
     2.942    89.161     0.150
     2.990    90.178     0.150
     3.120    47.949     0.150
     3.120    95.199     0.150
     3.170    49.509     0.150
     3.170    56.429     0.150
     3.170    96.379     0.150
     3.317   100.744     0.150
     3.541   108.025     0.150
     3.770    56.559     0.150
     3.770    71.219     0.150
     3.770   114.509     0.150
     3.793    57.809     0.150
     3.793    68.139     0.150
     3.793   119.039     0.150
     3.876    58.813     0.150
     4.618    69.468     0.150
     4.618    69.359     0.150
     4.618   144.769     0.150
     4.823    92.729     0.150
     4.880    73.415     0.150
     4.999    73.810     0.150
     5.567   107.259     0.150
     5.778   105.859     0.150
     5.778   180.319     0.150
     6.096    88.839     0.150
     6.096   117.319     0.150
     6.096   188.619     0.150
     6.154    90.632     0.150
     6.154    90.929     0.150
     6.154   115.049     0.150
     7.472   110.679     0.150
     7.472   235.209     0.150
     7.822   112.679     0.150
     8.540   123.979     0.150
    10.347   149.412     0.150
    11.478   169.036     0.150
    16.122   228.354     0.150
    30.324   373.104     0.150
    37.973   438.729     0.150
     0.269     5.014     0.150
     0.366     6.090     0.150
     0.366    11.110     0.150
     0.498    10.914     0.150
     0.498    18.994     0.150
     0.646    11.610     0.150
     0.646    19.846     0.150
     0.731    12.024     0.150
     0.784    14.214     0.150
     0.784    24.314     0.150
     0.816    15.234     0.150
     0.816    24.714     0.150
     0.816    26.174     0.150
     0.909    15.794     0.150
     0.909    27.485     0.150
     1.101    18.631     0.150
     1.101    31.995     0.150
     1.188    19.919     0.150
     1.188    36.219     0.150
     1.188    21.414     0.150
     1.188    34.754     0.150
     1.182    20.924     0.150
     1.182    36.059     0.150
     1.432    23.341     0.150
     1.556    25.089     0.150
     1.556    45.113     0.150
     1.583    26.091     0.150
     1.583    48.483     0.150
     1.549    26.884     0.150
     1.549    47.054     0.150
     1.549    49.944     0.150
     1.550    27.774     0.150
     1.550    48.804     0.150
     1.653    26.616     0.150
     1.653    47.462     0.150
     1.684    27.257     0.150
     1.684    47.982     0.150
     2.183    34.509     0.150
     2.298    69.358     0.150
     2.377    37.282     0.150
     2.384    37.531     0.150
     2.484    38.297     0.150
     2.532    43.564     0.150
     2.548    48.284     0.150
     2.548    79.274     0.150
     2.582    44.044     0.150
     2.582    75.284     0.150
     2.567    78.644     0.150
     2.853    45.514     0.150
     2.853    51.384     0.150
     2.853    90.574     0.150
     3.205    51.254     0.150
     3.205    97.514     0.150
     3.815    58.464     0.150
     3.815    68.554     0.150
     3.815   116.514     0.150
     3.946    60.814     0.150
     3.946    74.344     0.150
     4.207    62.234     0.150
     4.378    67.794     0.150
     4.378    82.984     0.150
     4.667    70.434     0.150
     4.667   148.594     0.150
     5.331    80.064     0.150
     5.331   102.314     0.150
     5.530    82.604     0.150
     5.530   102.564     0.150
     5.530   174.214     0.150
     5.613    84.554     0.150
     5.613   105.614     0.150
     5.613   169.914     0.150
     5.608    83.074     0.150
     5.608   181.144     0.150
     5.758   109.444     0.150
     6.196    92.494     0.150
     6.196   196.573     0.150
     6.280    93.394     0.150
     6.630   102.884     0.150
     6.630   121.824     0.150
     6.630   209.214     0.150
     6.631    99.014     0.150
     6.631   124.364     0.150
     6.726    98.184     0.150
     7.510   109.454     0.150
     7.538   112.254     0.150
     7.538   141.554     0.150
     7.538   237.214     0.150
     7.647   114.334     0.150
     7.647   245.814     0.150
     7.775   114.684     0.150
     8.067   119.294     0.150
     8.067   252.174     0.150
     8.090   118.194     0.150
     8.090   118.074     0.150
     8.090   257.804     0.150
     8.159   121.894     0.150
     8.159   257.269     0.150
     8.159   119.654     0.150
     8.159   152.194     0.150
     8.159   256.924     0.150
     8.837   127.094     0.150
     8.837   228.484     0.150
     9.666   140.484     0.150
    10.866   156.094     0.150
    10.866   342.386     0.150
    11.286   163.794     0.150
    22.984   305.319     0.150
    29.939   369.939     0.150
    37.448   435.194     0.150
   116.884  1125.306     0.150
     0.364     6.796     0.150
     0.473     8.259     0.150
     0.473    14.333     0.150
     0.486     8.606     0.150
     0.565    10.496     0.150
     0.601     9.557     0.150
     0.601    17.937     0.150
     0.778    13.925     0.150
     0.778    24.144     0.150
     0.876    14.925     0.150
     0.876    26.400     0.150
     0.893    16.296     0.150
     0.893    28.236     0.150
     0.893    16.187     0.150
     0.893    28.396     0.150
     0.900    16.156     0.150
     0.900    27.536     0.150
     1.131    19.236     0.150
     1.131    34.496     0.150
     1.168    19.319     0.150
     1.168    33.727     0.150
     1.305    22.642     0.150
     1.305    39.477     0.150
     1.315    38.176     0.150
     1.315    21.564     0.150
     1.315    38.007     0.150
     1.315    37.846     0.150
     1.450    25.307     0.150
     1.450    45.116     0.150
     1.451    25.356     0.150
     1.451    46.006     0.150
     1.535    24.825     0.150
     1.535    43.062     0.150
     1.560    24.947     0.150
     1.596    25.692     0.150
     1.596    45.190     0.150
     1.709    27.325     0.150
     1.717    27.928     0.150
     1.717    49.345     0.150
     2.193    34.293     0.150
     2.418    37.550     0.150
     2.420    37.723     0.150
     2.448    37.552     0.150
     2.448    66.376     0.150
     2.448    77.176     0.150
     2.432    73.094     0.150
     2.506    39.298     0.150
     2.511    39.010     0.150
     2.545    76.449     0.150
     2.614    41.256     0.150
     2.666    40.636     0.150
     2.666    81.096     0.150
     2.716    40.006     0.150
     2.716    82.026     0.150
     2.864    86.249     0.150
     2.977    89.541     0.150
     2.967    91.096     0.150
     3.091    92.799     0.150
     3.339    99.694     0.150
     3.339    51.966     0.150
     3.339   102.316     0.150
     3.945    58.736     0.150
     3.945    73.006     0.150
     3.945   120.596     0.150
     4.021    61.196     0.150
     4.021    74.496     0.150
     4.021   125.376     0.150
     4.102    60.896     0.150
     4.474    68.376     0.150
     4.474   147.416     0.150
     4.646    69.486     0.150
     5.377    80.526     0.150
     5.561    82.576     0.150
     5.561   178.937     0.150
     5.579    82.946     0.150
     5.579   107.156     0.150
     5.579   178.727     0.150
     5.843   111.687     0.150
     6.312    94.424     0.150
     6.627    96.406     0.150
     6.627   170.656     0.150
     6.753    99.076     0.150
     6.753   126.106     0.150
     6.753   212.937     0.150
     7.347   107.236     0.150
     7.434   108.236     0.150
     7.515   111.437     0.150
     7.515   238.786     0.150
     7.677   114.356     0.150
     7.739   112.396     0.150
     7.796   114.136     0.150
     8.023   116.751     0.150
     8.023   250.826     0.150
     8.023   116.996     0.150
     8.014   120.446     0.150
     8.014   153.466     0.150
     8.058   118.746     0.150
     8.058   149.477     0.150
     8.058   252.557     0.150
     8.242   123.026     0.150
     8.242   256.376     0.150
     8.730   125.586     0.150
     9.657   141.756     0.150
     9.809   140.626     0.150
    10.746   154.626     0.150
    10.746   336.373     0.150
    10.869   156.956     0.150
    11.324   162.977     0.150
    15.050   216.267     0.150
    15.270   216.937     0.150
    15.354   219.736     0.150
    15.794   224.626     0.150
    15.905   224.366     0.150
    17.123   241.096     0.150
    18.500   257.416     0.150
    21.717   291.767     0.150
    21.940   294.796     0.150
    22.999   305.026     0.150
    24.218   317.445     0.150
    27.289   344.496     0.150
    27.718   350.727     0.150
    30.024   368.521     0.150
    30.024   551.221     0.150
    37.316   432.876     0.150
    37.566   435.576     0.150
    80.898   735.426     0.150
    81.365   737.852     0.150
    82.469   743.426     0.150
    83.598   749.626     0.150
    83.790   750.826     0.150
    83.835   751.426     0.150
    83.878   751.227     0.150
    84.201   752.426     0.150
    84.310   752.977     0.150
    84.515   754.526     0.150
    84.676   755.426     0.150
    84.891   756.326     0.150
     0.232     4.259     0.150
     0.307     5.499     0.150
     0.323     5.382     0.150
     0.602    11.027     0.150
     0.602    18.525     0.150
     0.607    10.519     0.150
     0.752    13.778     0.150
     0.752    23.408     0.150
     0.781    13.549     0.150
     0.781    24.519     0.150
     0.805    15.269     0.150
     0.805    26.028     0.150
     0.913    15.852     0.150
     0.913    27.568     0.150
     1.068    18.047     0.150
     1.068    31.037     0.150
     1.139    19.184     0.150
     1.139    33.658     0.150
     1.145    20.392     0.150
     1.145    34.966     0.150
     1.304    23.039     0.150
     1.304    40.578     0.150
     1.387    22.755     0.150
     1.387    40.161     0.150
     1.535    25.622     0.150
     1.544    25.377     0.150
     1.544    44.221     0.150
     1.623    26.116     0.150
     1.594    27.749     0.150
     1.594    50.158     0.150
     1.594    27.858     0.150
     1.595    28.129     0.150
     1.595    50.358     0.150
     1.707    27.780     0.150
     1.707    48.550     0.150
     1.893    30.963     0.150
     1.893    53.692     0.150
     2.160    33.885     0.150
     2.168    34.576     0.150
     2.168    59.043     0.150
     2.250    35.207     0.150
     2.250    61.272     0.150
     2.249    67.383     0.150
     2.351    37.021     0.150
     2.344    70.676     0.150
     2.484    41.238     0.150
     2.484    45.459     0.150
     2.484    75.358     0.150
     2.497    38.854     0.150
     2.535    43.049     0.150
     2.535    75.438     0.150
     2.603    39.810     0.150
     2.805    42.948     0.150
     2.805    51.198     0.150
     2.805    88.179     0.150
     3.157    50.019     0.150
     3.157    56.408     0.150
     3.157    97.719     0.150
     3.766    57.289     0.150
     3.766    67.419     0.150
     3.766   114.419     0.150
     3.909    60.469     0.150
     3.909    74.028     0.150
     3.909   124.818     0.150
     4.237    63.049     0.150
     4.662    70.738     0.150
     4.662    88.049     0.150
     4.662   147.988     0.150
     5.303    79.698     0.150
     5.303    98.719     0.150
     5.303   167.539     0.150
     5.500   103.589     0.150
     5.500   175.648     0.150
     5.567    82.858     0.150
     5.613    84.118     0.150
     5.717    86.078     0.150
     5.717   107.499     0.150
     5.717   184.078     0.150
     6.148    90.559     0.150
     6.231    91.828     0.150
     6.581   100.979     0.150
     6.581    96.089     0.150
     6.581   198.959     0.150
     6.752    98.528     0.150
     6.752   214.969     0.150
     7.533   111.488     0.150
     7.533   142.738     0.150
     7.533   240.919     0.150
     7.623   112.469     0.150
     7.755   113.078     0.150
     7.831   113.879     0.150
     7.880   115.078     0.150
     7.880   250.469     0.150
     8.103   118.759     0.150
     9.664   140.078     0.150
    10.067   146.698     0.150
    10.903   156.684     0.150
    10.903   342.672     0.150
    10.973   158.328     0.150
    11.260   162.509     0.150
    12.601   182.559     0.150
    12.653   184.398     0.150
    13.431   195.118     0.150
    14.406   206.499     0.150
    14.707   209.379     0.150
    14.703   208.749     0.150
    14.933   213.789     0.150
    15.151   217.259     0.150
    15.179   216.118     0.150
    15.232   217.099     0.150
    15.284   219.209     0.150
    15.513   219.549     0.150
    15.659   222.858     0.150
    15.842   225.078     0.150
    16.049   227.509     0.150
    16.569   233.099     0.150
    16.848   236.229     0.150
    17.261   242.709     0.150
    18.081   252.519     0.150
    18.600   256.578     0.150
    18.668   258.309     0.150
    20.665   280.408     0.150
    21.696   291.328     0.150
    22.040   295.009     0.150
    22.965   304.959     0.150
    23.252   308.169     0.150
    23.303   309.118     0.150
    24.398   321.678     0.150
    24.523   321.209     0.150
    27.351   346.299     0.150
    27.559   349.533     0.150
    29.898   368.104     0.150
    32.773   394.818     0.150
    34.553   409.818     0.150
    37.166   432.009     0.150
    37.399   434.709     0.150
    47.685   520.209     0.150
    81.282   738.533     0.150
    82.854   744.158     0.150
    91.960   789.334     0.150
    93.179   792.759     0.150
   107.403  1590.259     0.150
     0.592    10.867     0.150
     0.616    11.657     0.150
     0.627    11.817     0.150
     0.671    12.578     0.150
     0.718    12.617     0.150
     0.859    14.633     0.150
     0.930    15.599     0.150
     0.930    27.767     0.150
     0.930    28.498     0.150
     1.181    20.346     0.150
     1.181    36.506     0.150
     1.173    21.478     0.150
     1.173    36.628     0.150
     1.164    21.458     0.150
     1.164    37.367     0.150
     1.266    22.288     0.150
     1.266    39.117     0.150
     1.401    23.101     0.150
     1.401    40.315     0.150
     1.455    23.538     0.150
     1.455    41.832     0.150
     1.671    26.589     0.150
     1.671    46.965     0.150
     1.718    27.498     0.150
     1.718    27.175     0.150
     1.718    48.848     0.150
     1.683    27.934     0.150
     1.683    51.631     0.150
     1.890    29.446     0.150
     1.953    30.463     0.150
     2.114    32.623     0.150
     2.114    65.317     0.150
     2.127    33.336     0.150
     2.127    64.987     0.150
     2.285    35.527     0.150
     2.581    39.689     0.150
     2.594    39.300     0.150
     2.872    44.928     0.150
     2.843    43.093     0.150
     2.861    43.920     0.150
     2.895    44.585     0.150
     2.895    87.560     0.150
     2.944    88.895     0.150
     3.077    47.888     0.150
     3.077    94.388     0.150
     3.126    46.107     0.150
     3.126    95.817     0.150
     3.341    50.447     0.150
     3.500    52.345     0.150
     3.749    55.407     0.150
     3.814    55.628     0.150
     3.814    66.788     0.150
     3.814   117.888     0.150
     4.293    64.718     0.150
     4.293   132.688     0.150
     4.352    64.668     0.150
     4.352   137.378     0.150
     4.638    70.268     0.150
     4.638   143.258     0.150
     4.801    70.788     0.150
     5.464    81.328     0.150
     6.070    88.808     0.150
     6.137    91.197     0.150
     6.354    91.817     0.150
     6.354   200.458     0.150
     7.163   104.598     0.150
     7.546   109.157     0.150
     7.814   115.878     0.150
     7.858   114.522     0.150
     7.858   113.578     0.150
     7.906   115.078     0.150
     8.222   117.647     0.150
     8.430   120.447     0.150
     8.525   124.373     0.150
     8.892   127.758     0.150
     9.425   135.647     0.150
     9.746   141.378     0.150
     9.745   141.277     0.150
    10.395   150.048     0.150
    10.644   153.447     0.150
    11.480   165.548     0.150
    15.544   218.978     0.150
    16.104   229.147     0.150
    18.280   252.867     0.150
    21.771   291.558     0.150
    23.080   305.873     0.150
    26.313   338.473     0.150
    28.079   354.098     0.150
    30.309   373.304     0.150
    37.656   436.772     0.150
    37.942   439.598     0.150
    81.552   739.173     0.150
     0.872    14.922     0.150
     0.857    15.435     0.150
     0.857    26.558     0.150
     0.940    17.226     0.150
     0.969    17.346     0.150
     0.969    30.285     0.150
     1.220    19.898     0.150
     1.378    23.922     0.150
     1.378    41.241     0.150
     1.395    22.833     0.150
     1.395    39.618     0.150
     1.395    39.445     0.150
     1.388    43.465     0.150
     1.551    43.997     0.150
     1.603    25.487     0.150
     1.798    31.971     0.150
     1.798    54.464     0.150
     2.148    36.445     0.150
     2.380    43.016     0.150
     2.456    37.804     0.150
     2.513    75.460     0.150
     2.586    78.387     0.150
     2.624    78.777     0.150
     2.663    41.915     0.150
     2.663    50.726     0.150
     2.747    44.275     0.150
     2.747    84.115     0.150
     2.797    45.535     0.150
     2.797    85.445     0.150
     2.945    89.362     0.150
     3.041    46.465     0.150
     3.041    55.936     0.150
     3.041    93.896     0.150
     3.172    94.887     0.150
     3.420   102.740     0.150
     3.420   105.096     0.150
     4.026    74.556     0.150
     4.026   125.235     0.150
     4.044   124.896     0.150
     4.074    77.425     0.150
     4.538    68.096     0.150
     4.538    85.565     0.150
     4.642    70.115     0.150
     4.642   146.045     0.150
     5.413    81.195     0.150
     5.413   101.795     0.150
     5.788    85.705     0.150
     5.788   110.115     0.150
     5.900    87.766     0.150
     5.900   110.266     0.150
     5.900   190.146     0.150
     6.830   103.025     0.150
     7.394   107.915     0.150
     7.510   234.835     0.150
     7.703   143.315     0.150
     7.703   243.065     0.150
    10.676   154.255     0.150
    10.676   334.239     0.150
    10.824   158.375     0.150
    11.355   163.855     0.150
    23.015   305.830     0.150
    27.790   351.455     0.150
    37.384   435.556     0.150
    37.640   436.205     0.150
     0.138     2.699     0.150
     0.557    10.539     0.150
     0.557    18.379     0.150
     1.043    17.412     0.150
     1.043    30.215     0.150
     1.043    31.598     0.150
     1.094    18.033     0.150
     1.094    32.248     0.150
     1.033    19.328     0.150
     1.033    33.928     0.150
     1.338    21.561     0.150
     1.338    38.816     0.150
     1.367    43.168     0.150
     1.367    24.338     0.150
     1.367    42.229     0.150
     1.419    43.252     0.150
     1.490    46.279     0.150
     1.650    26.291     0.150
     1.650    46.039     0.150
     1.780    28.135     0.150
     1.909    58.018     0.150
     1.935    30.223     0.150
     1.935    54.895     0.150
     1.956    30.779     0.150
     1.956    58.578     0.150
     1.956    54.301     0.150
     2.110    32.898     0.150
     2.123    32.498     0.150
     2.242    35.059     0.150
     2.242    61.500     0.150
     2.368    37.201     0.150
     2.368    72.467     0.150
     2.402    37.357     0.150
     2.402    64.852     0.150
     2.586    39.570     0.150
     2.759    41.924     0.150
     2.789    42.252     0.150
     3.041    59.928     0.150
     3.041   100.908     0.150
     3.084    46.928     0.150
     3.084    93.666     0.150
     3.073    93.174     0.150
     3.121    94.662     0.150
     3.178    96.318     0.150
     3.257    97.441     0.150
     3.317   104.568     0.150
     3.365    55.379     0.150
     3.365   101.439     0.150
     3.565    69.568     0.150
     3.659    53.719     0.150
     3.659   118.568     0.150
     3.989   124.689     0.150
     4.465    67.518     0.150
     4.591    86.459     0.150
     4.591   143.518     0.150
     4.654    69.898     0.150
     5.425    81.098     0.150
     5.425   163.098     0.150
     5.688    84.699     0.150
     5.688   107.408     0.150
     5.688   185.939     0.150
     5.902    87.619     0.150
     5.902   111.018     0.150
     6.204    90.088     0.150
     6.204   189.109     0.150
     6.280   202.848     0.150
     6.318    93.289     0.150
     6.318   121.299     0.150
     6.318   203.379     0.150
     7.133   104.078     0.150
     7.133   230.578     0.150
     7.400   109.959     0.150
     7.445   107.619     0.150
     7.445   240.059     0.150
     7.495   110.488     0.150
     7.495   240.529     0.150
     7.773   113.254     0.150
     7.773   243.928     0.150
     7.773   113.018     0.150
     7.773   145.738     0.150
     7.907   118.018     0.150
     7.907   151.418     0.150
     7.907   253.389     0.150
     7.982   119.359     0.150
     7.982   148.939     0.150
     8.276   124.338     0.150
     8.276   157.979     0.150
     8.276   267.609     0.150
     8.262   118.988     0.150
     8.353   123.859     0.150
     8.353   156.289     0.150
     8.445   124.018     0.150
     8.699   129.668     0.150
     8.699   166.588     0.150
     9.718   142.359     0.150
    10.193   146.629     0.150
    10.193   317.775     0.150
    10.521   152.518     0.150
    10.762   156.789     0.150
    11.381   165.229     0.150
    11.580   170.828     0.150
    11.580   368.727     0.150
    12.897   187.869     0.150
    13.170   187.629     0.150
    14.932   214.248     0.150
    15.069   213.199     0.150
    15.710   225.209     0.150
    15.805   226.129     0.150
    16.466   230.689     0.150
    16.642   234.268     0.150
    18.157   251.039     0.150
    22.913   304.748     0.150
    23.135   730.154     0.150
    26.201   334.604     0.150
    28.292   355.953     0.150
    30.480   374.223     0.150
    38.164   441.828     0.150
     0.119     2.500     0.150
     0.229     4.391     0.150
     0.305     5.381     0.150
     0.320     5.551     0.150
     0.320     9.660     0.150
     0.600    10.941     0.150
     0.600    18.510     0.150
     0.751    13.701     0.150
     0.751    23.400     0.150
     0.783    14.521     0.150
     0.783    25.121     0.150
     0.806    15.021     0.150
     0.806    25.352     0.150
     0.911    15.705     0.150
     0.911    27.320     0.150
     0.911    15.391     0.150
     0.911    27.891     0.150
     1.065    18.092     0.150
     1.065    31.111     0.150
     1.136    18.820     0.150
     1.136    33.545     0.150
     1.136    32.955     0.150
     1.136    18.670     0.150
     1.136    34.611     0.150
     1.144    20.201     0.150
     1.144    34.678     0.150
     1.307    23.861     0.150
     1.307    41.102     0.150
     1.384    22.520     0.150
     1.384    39.334     0.150
     1.533    25.062     0.150
     1.542    24.828     0.150
     1.542    43.873     0.150
     1.620    25.980     0.150
     1.597    27.320     0.150
     1.597    48.170     0.150
     1.598    27.420     0.150
     1.707    27.416     0.150
     1.707    48.158     0.150
     2.157    33.570     0.150
     2.157    59.307     0.150
     2.165    33.922     0.150
     2.247    34.748     0.150
     2.247    35.209     0.150
     2.247    67.193     0.150
     2.348    36.303     0.150
     2.348    64.307     0.150
     2.354    65.729     0.150
     2.368    71.170     0.150
     2.482    40.861     0.150
     2.496    38.295     0.150
     2.511    40.061     0.150
     2.533    39.191     0.150
     2.533    80.141     0.150
     2.604    39.365     0.150
     2.604    39.160     0.150
     2.604    68.971     0.150
     2.671    40.941     0.150
     2.802    42.781     0.150
     2.802    78.711     0.150
     3.155    58.852     0.150
     3.155    88.301     0.150
     3.906    58.500     0.150
     3.906   123.820     0.150
     4.237    62.400     0.150
     4.660    70.451     0.150
     5.300    79.701     0.150
     5.300   140.590     0.150
     5.497    81.771     0.150
     5.564    83.441     0.150
     5.612    84.031     0.150
     5.612   179.211     0.150
     5.714    85.830     0.150
     5.714   184.891     0.150
     6.145   196.650     0.150
     6.578   124.432     0.150
     6.753    97.900     0.150
     6.753   174.621     0.150
     7.526   109.541     0.150
     7.531   111.490     0.150
     7.620   113.271     0.150
     7.620   198.980     0.150
     7.752   114.311     0.150
     7.830   113.631     0.150
     8.102   118.396     0.150
     8.102   254.396     0.150
     9.647   140.480     0.150
    10.904   156.621     0.150
    10.972   157.920     0.150
    11.257   163.291     0.150
    22.963   305.545     0.150
    37.163   434.695     0.150
     0.321     5.527     0.150
     0.321    10.467     0.150
     0.474     8.596     0.150
     0.598    10.787     0.150
     0.636    11.576     0.150
     0.861    14.816     0.150
     0.861    26.746     0.150
     0.750    12.875     0.150
     0.871    14.869     0.150
     0.871    26.182     0.150
     0.871    14.686     0.150
     1.114    20.027     0.150
     1.114    35.316     0.150
     1.083    18.611     0.150
     1.083    33.475     0.150
     1.252    22.396     0.150
     1.252    22.766     0.150
     1.252    40.717     0.150
     1.357    22.057     0.150
     1.357    38.428     0.150
     1.416    23.250     0.150
     1.416    42.195     0.150
     1.596    48.475     0.150
     1.610    25.541     0.150
     1.610    45.566     0.150
     1.610    50.186     0.150
     1.606    47.979     0.150
     1.863    57.141     0.150
     2.025    32.283     0.150
     2.025    62.564     0.150
     2.179    33.830     0.150
     2.179    33.697     0.150
     2.179    60.656     0.150
     2.241    67.557     0.150
     2.284    35.703     0.150
     2.361    37.156     0.150
     2.494    38.375     0.150
     2.738    42.367     0.150
     2.738    83.350     0.150
     2.807    84.621     0.150
     2.849    86.219     0.150
     2.781    43.307     0.150
     2.781    80.996     0.150
     2.974    47.207     0.150
     3.024    47.736     0.150
     3.024    84.406     0.150
     3.049    47.209     0.150
     3.172    96.344     0.150
     3.393    51.541     0.150
     3.647   108.961     0.150
     3.647    55.877     0.150
     3.647   116.506     0.150
     3.864    58.057     0.150
     3.864   122.746     0.150
     3.894    59.105     0.150
     4.048    61.061     0.150
     4.201    63.707     0.150
     4.607    69.936     0.150
     4.607   148.686     0.150
     5.458    81.777     0.150
     5.458   142.086     0.150
     5.488    81.527     0.150
     5.488   177.797     0.150
     5.697   107.977     0.150
     5.697   179.877     0.150
     5.965   114.605     0.150
     6.041    89.266     0.150
     6.041   195.467     0.150
     6.400    93.426     0.150
     6.577   121.615     0.150
     6.577   211.055     0.150
     7.035   131.906     0.150
     7.182   104.656     0.150
     7.182   185.207     0.150
     7.259   106.176     0.150
     7.468   238.967     0.150
     7.568   110.016     0.150
     7.568   195.336     0.150
     7.750   112.547     0.150
     7.750   199.326     0.150
     7.871   113.891     0.150
     7.871   148.291     0.150
     7.871   113.377     0.150
     7.848   114.127     0.150
     8.431   162.566     0.150
     8.431   264.766     0.150
    10.468   151.516     0.150
    11.412   165.998     0.150
    11.412   216.646     0.150
    16.005   226.967     0.150
    23.030   306.842     0.150
    30.215   371.311     0.150
    37.834   438.768     0.150
     0.069     1.914     0.150
     0.103     2.352     0.150
     0.191     3.852     0.150
     0.258     4.691     0.150
     0.275     4.840     0.150
     0.330     6.781     0.150
     0.442     8.352     0.150
     0.567    10.367     0.150
     0.567    17.895     0.150
     0.605    11.113     0.150
     0.733    13.352     0.150
     0.733    22.574     0.150
     0.809    14.934     0.150
     0.809    25.602     0.150
     0.905    15.953     0.150
     0.905    27.613     0.150
     0.906    15.590     0.150
     0.906    27.375     0.150
     1.026    17.230     0.150
     1.026    30.781     0.150
     1.089    18.223     0.150
     1.089    33.922     0.150
     1.089    31.875     0.150
     1.089    31.703     0.150
     1.118    19.703     0.150
     1.118    33.973     0.150
     1.338    21.824     0.150
     1.338    38.984     0.150
     1.354    22.352     0.150
     1.492    24.266     0.150
     1.492    43.164     0.150
     1.521    24.676     0.150
     1.521    43.691     0.150
     1.583    25.488     0.150
     1.644    27.434     0.150
     1.644    49.824     0.150
     1.644    28.113     0.150
     1.644    27.602     0.150
     1.645    28.941     0.150
     1.720    27.402     0.150
     1.720    48.648     0.150
     1.843    29.883     0.150
     1.843    52.562     0.150
     2.113    32.867     0.150
     2.113    58.234     0.150
     2.141    33.289     0.150
     2.141    58.434     0.150
     2.200    34.156     0.150
     2.204    34.383     0.150
     2.204    66.562     0.150
     2.314    35.824     0.150
     2.312    36.246     0.150
     2.312    70.000     0.150
     2.333    36.250     0.150
     2.333    70.594     0.150
     2.331    65.633     0.150
     2.414    36.844     0.150
     2.441    42.922     0.150
     2.441    74.223     0.150
     2.471    42.602     0.150
     2.492    41.781     0.150
     2.498    38.047     0.150
     2.631    39.695     0.150
     2.631    40.113     0.150
     2.663    40.582     0.150
     2.663    72.613     0.150
     2.755    42.023     0.150
     2.761    41.984     0.150
     2.863    43.660     0.150
     3.114    47.039     0.150
     3.114    51.051     0.150
     3.513    52.691     0.150
     3.657    54.566     0.150
     3.717    55.523     0.150
     3.717    55.414     0.150
     3.864    58.301     0.150
     4.285    65.422     0.150
     4.256    62.621     0.150
     4.644    70.531     0.150
     5.193    78.051     0.150
     5.265    78.801     0.150
     5.461    81.223     0.150
     5.517    82.523     0.150
     5.606    83.762     0.150
     5.670    83.984     0.150
     6.098    89.898     0.150
     6.098   194.871     0.150
     6.187    92.121     0.150
     6.531    98.402     0.150
     6.532    99.422     0.150
     6.768    98.145     0.150
     7.515   111.723     0.150
     7.531   109.352     0.150
     7.588   111.633     0.150
     7.723   113.922     0.150
     7.834   113.691     0.150
     7.868   115.051     0.150
     7.887   114.523     0.150
     8.073   120.023     0.150
     8.073   253.199     0.150
     8.103   117.824     0.150
     8.103   118.121     0.150
     8.534   124.934     0.150
     8.642   126.543     0.150
     8.886   127.422     0.150
     8.918   130.422     0.150
     9.136   132.824     0.150
     9.408   136.023     0.150
     9.539   138.801     0.150
     9.621   139.734     0.150
     9.662   142.164     0.150
     9.680   139.941     0.150
     9.809   148.492     0.150
    10.361   150.645     0.150
    10.685   154.973     0.150
    10.728   154.895     0.150
    10.742   155.742     0.150
    10.873   157.723     0.150
    10.930   160.723     0.150
    10.931   156.547     0.150
    10.980   158.422     0.150
    11.223   162.371     0.150
    11.223   162.621     0.150
    11.364   166.234     0.150
    11.389   166.992     0.150
    11.456   167.723     0.150
    11.575   169.184     0.150
    11.663   169.633     0.150
    11.840   172.734     0.150
    12.075   176.133     0.150
    12.356   180.723     0.150
    12.373   178.312     0.150
    12.398   180.613     0.150
    12.417   180.645     0.150
    12.560   183.895     0.150
    12.611   184.551     0.150
    12.672   186.223     0.150
    12.916   188.082     0.150
    12.985   189.723     0.150
    13.332   194.645     0.150
    13.387   194.664     0.150
    13.429   193.254     0.150
    13.621   195.645     0.150
    13.769   196.871     0.150
    13.817   198.223     0.150
    13.933   200.461     0.150
    13.943   202.395     0.150
    14.001   203.074     0.150
    14.214   204.992     0.150
    14.322   203.324     0.150
    14.350   207.145     0.150
    14.361   206.961     0.150
    14.661   210.504     0.150
    14.673   215.922     0.150
    14.795   210.121     0.150
    14.886   213.664     0.150
    15.105   217.844     0.150
    15.185   218.703     0.150
    15.182   216.191     0.150
    15.230   218.242     0.150
    15.249   219.273     0.150
    15.363   220.672     0.150
    15.448   221.441     0.150
    15.610   222.723     0.150
    15.610   222.824     0.150
    15.806   224.395     0.150
    15.897   227.324     0.150
    16.006   227.645     0.150
    16.435   233.645     0.150
    16.553   237.031     0.150
    16.814   237.164     0.150
    16.850   236.562     0.150
    17.280   243.523     0.150
    18.045   252.484     0.150
    18.606   258.324     0.150
    18.648   259.812     0.150
    19.621   270.164     0.150
    20.618   280.023     0.150
    21.233   286.645     0.150
    21.335   290.191     0.150
    22.046   295.023     0.150
    22.558   301.922     0.150
    22.935   306.324     0.150
    22.935   305.422     0.150
    23.248   757.004     0.150
    23.306   310.121     0.150
    23.514   750.734     0.150
    24.120   317.223     0.150
    24.174   318.684     0.150
    24.244   319.383     0.150
    24.438   322.215     0.150
    24.519   321.621     0.150
    24.613   322.922     0.150
    24.870   324.062     0.150
    26.608   339.922     0.150
    26.608   338.898     0.150
    27.063   344.023     0.150
    27.345   346.312     0.150
    27.509   347.699     0.150
    28.780   359.422     0.150
    28.973   361.473     0.150
    29.249   363.422     0.150
    29.851   368.066     0.150
    29.851   553.969     0.150
    31.252   380.883     0.150
    31.254   383.551     0.150
    32.893   398.691     0.150
    34.185   403.922     0.150
    36.103   426.621     0.150
    36.103   425.266     0.150
    37.116   433.121     0.150
    37.349   433.922     0.150
    37.949   439.434     0.150
    37.949   801.242     0.150
    40.330   460.113     0.150
    40.667   461.773     0.150
    46.261   510.645     0.150
    46.760   514.504     0.150
    46.987   515.633     0.150
    47.323   515.633     0.150
    47.693   522.422     0.150
    47.713   523.551     0.150
    47.726   521.852     0.150
    47.931   522.422     0.150
    47.931   522.781     0.150
    48.152   523.551     0.150
    60.093   609.121     0.150
    62.259   626.949     0.150
    62.635   629.148     0.150
    66.719   655.023     0.150
    77.166   716.848     0.150
    80.648   735.121     0.150
    80.727   735.422     0.150
    81.173   738.223     0.150
    81.241   736.547     0.150
    81.725   742.922     0.150
    82.451   746.574     0.150
    82.807   741.922     0.150
    83.743   753.922     0.150
    84.826   757.824     0.150
    87.200   769.438     0.150
    88.416   777.422     0.150
    88.417   777.422     0.150
    89.149   780.324     0.150
    89.149   780.473     0.150
    89.791   783.422     0.150
    90.263   781.223     0.150
    90.573   787.824     0.150
    91.125   788.023     0.150
    91.376   790.664     0.150
    91.428   789.348     0.150
    91.909   792.949     0.150
    93.131   792.023     0.150
    94.781  1861.422     0.150
    97.505   814.121     0.150
    99.238   825.910     0.150
   100.912   833.723     0.150
   102.183   835.324     0.150
   102.183   840.621     0.150
   106.517   857.922     0.150
   107.353   862.621     0.150
   107.353  1134.223     0.150
   107.353  1584.922     0.150
   107.353  2043.723     0.150
   108.644   862.922     0.150
   108.644  1106.723     0.150
   108.644  1136.523     0.150
   112.564   880.324     0.150
   119.261  1135.273     0.150
     0.131     2.203     0.150
     0.219     4.074     0.150
     0.304     5.246     0.150
     0.313     5.344     0.150
     0.313     9.348     0.150
     0.323     6.746     0.150
     0.449     9.055     0.150
     0.449    16.023     0.150
     0.606    10.973     0.150
     0.606    18.867     0.150
     0.593    11.203     0.150
     0.761    13.773     0.150
     0.761    23.594     0.150
     0.819    15.086     0.150
     0.819    26.523     0.150
     0.819    15.234     0.150
     0.819    26.016     0.150
     0.898    15.688     0.150
     0.898    27.613     0.150
     1.054    18.012     0.150
     1.054    31.117     0.150
     1.134    19.023     0.150
     1.134    33.926     0.150
     1.134    19.449     0.150
     1.134    19.184     0.150
     1.134    33.633     0.150
     1.134    33.516     0.150
     1.153    20.375     0.150
     1.153    35.262     0.150
     1.378    22.660     0.150
     1.378    40.707     0.150
     1.536    25.484     0.150
     1.536    48.074     0.150
     1.529    24.992     0.150
     1.529    44.328     0.150
     1.609    26.223     0.150
     1.603    27.305     0.150
     1.603    49.055     0.150
     1.604    28.914     0.150
     1.696    27.559     0.150
     1.696    49.145     0.150
     1.888    30.695     0.150
     1.888    54.473     0.150
     2.149    33.816     0.150
     2.149    60.184     0.150
     2.152    34.109     0.150
     2.241    35.004     0.150
     2.241    62.211     0.150
     2.249    35.508     0.150
     2.249    68.820     0.150
     2.336    36.789     0.150
     2.374    38.496     0.150
     2.363    38.445     0.150
     2.363    68.547     0.150
     2.459    38.016     0.150
     2.485    40.523     0.150
     2.485    44.203     0.150
     2.501    39.984     0.150
     2.484    38.402     0.150
     2.536    42.953     0.150
     2.596    39.746     0.150
     2.596    39.594     0.150
     2.658    41.008     0.150
     2.798    43.023     0.150
     2.798    42.688     0.150
     2.799    42.789     0.150
     2.908    44.609     0.150
     3.158    48.328     0.150
     3.158    48.746     0.150
     3.558    53.637     0.150
     3.701    55.477     0.150
     3.763    56.523     0.150
     3.763    56.352     0.150
     3.896    58.965     0.150
     4.227    61.824     0.150
     5.289    79.555     0.150
     5.486    81.926     0.150
     5.558    82.824     0.150
     5.599    83.824     0.150
     5.706    85.035     0.150
     6.141    90.648     0.150
     6.141   194.727     0.150
     6.231    91.926     0.150
     6.577    96.926     0.150
     6.742    98.297     0.150
     7.518   111.734     0.150
     7.514   109.484     0.150
     7.608   112.465     0.150
     7.740   114.324     0.150
     7.892   116.023     0.150
     7.914   116.523     0.150
     8.088   116.453     0.150
     8.108   118.324     0.150
     8.089   118.523     0.150
     8.563   124.496     0.150
     9.160   133.465     0.150
     9.437   136.926     0.150
     9.565   138.727     0.150
     9.634   140.703     0.150
     9.930   147.613     0.150
    10.044   144.727     0.150
    10.765   154.355     0.150
    10.768   157.824     0.150
    10.879   158.023     0.150
    10.896   156.699     0.150
    10.896   343.559     0.150
    10.964   157.926     0.150
    10.960   158.363     0.150
    11.245   162.594     0.150
    11.245   163.234     0.150
    11.245   355.367     0.150
    11.941   170.824     0.150
    12.388   181.004     0.150
    12.389   176.816     0.150
    12.588   180.766     0.150
    13.419   194.195     0.150
    13.597   193.246     0.150
    13.773   197.176     0.150
    13.787   197.227     0.150
    14.304   202.125     0.150
    14.695   208.203     0.150
    14.688   208.023     0.150
    14.921   213.414     0.150
    15.139   215.727     0.150
    15.166   215.695     0.150
    15.220   218.066     0.150
    15.272   216.137     0.150
    15.433   218.023     0.150
    15.500   219.094     0.150
    15.500   224.727     0.150
    15.503   219.176     0.150
    15.648   221.426     0.150
    15.648   222.250     0.150
    15.828   224.555     0.150
    16.035   225.375     0.150
    16.469   232.137     0.150
    16.553   234.977     0.150
    16.834   236.496     0.150
    17.251   241.727     0.150
    18.067   253.113     0.150
    18.588   257.727     0.150
    18.653   259.305     0.150
    19.603   266.496     0.150
    20.150   275.855     0.150
    20.653   280.324     0.150
    21.681   291.676     0.150
    21.761   292.375     0.150
    22.028   295.926     0.150
    22.256   297.934     0.150
    22.557   301.426     0.150
    22.950   304.625     0.150
    23.238   308.234     0.150
    23.290   309.023     0.150
    23.502   310.426     0.150
    24.146   316.125     0.150
    24.153   317.816     0.150
    24.237   318.074     0.150
    24.396   319.270     0.150
    24.601   321.426     0.150
    26.592   340.125     0.150
    27.551   347.977     0.150
    29.887   368.270     0.150
    32.758   394.645     0.150
    34.539   409.355     0.150
    37.157   431.926     0.150
    37.393   433.918     0.150
    40.676   461.000     0.150
    55.421   574.625     0.150
    55.634   577.023     0.150
    55.634   637.023     0.150
    55.634   577.625     0.150
    62.304   623.051     0.150
    66.762   652.625     0.150
    72.061   685.926     0.150
    77.347   716.625     0.150
    81.268   736.980     0.150
    84.859   755.523     0.150
    89.193   779.824     0.150
    91.160   786.426     0.150
    91.160  1003.324     0.150
    91.160  1418.227     0.150
    91.452   787.125     0.150
    91.951   789.875     0.150
    94.535   801.711     0.150
    94.827   802.426     0.150
    94.827  1032.523     0.150
    94.827  1437.426     0.150
    94.827  1473.023     0.150
    94.827  1859.023     0.150
    96.046   809.023     0.150
    96.149   809.000     0.150
    97.550   814.926     0.150
    99.279   824.430     0.150
   100.955   832.125     0.150
   100.955  1471.125     0.150
   100.955  1528.125     0.150
   100.955  1948.125     0.150
   106.562   855.023     0.150
   106.562  1121.926     0.150
   106.562  1571.324     0.150
   106.562  2022.125     0.150
   107.393   862.125     0.150
   107.393  1133.324     0.150
   107.393  1584.324     0.150
   107.393  2043.324     0.150
   108.690   864.125     0.150
   108.690  1108.523     0.150
   116.873  1126.387     0.150
   118.877  1128.926     0.150
     0.194     2.484     0.150
     0.194     5.836     0.150
     0.237     4.574     0.150
     0.237     8.465     0.150
     0.606    11.086     0.150
     0.604    10.934     0.150
     0.624    11.895     0.150
     0.624    20.473     0.150
     0.640    12.023     0.150
     0.651    12.402     0.150
     0.691    12.375     0.150
     0.718    12.625     0.150
     0.695    12.844     0.150
     0.732    12.074     0.150
     0.732    22.215     0.150
     0.722    12.805     0.150
     0.769    13.945     0.150
     0.802    14.363     0.150
     0.802    25.305     0.150
     0.802    27.402     0.150
     0.883    15.215     0.150
     0.918    16.453     0.150
     0.945    15.844     0.150
     0.945    28.191     0.150
     0.945    15.664     0.150
     0.945    28.965     0.150
     1.082    19.895     0.150
     1.082    34.684     0.150
     1.145    20.855     0.150
     1.145    36.223     0.150
     1.145    20.734     0.150
     1.145    35.984     0.150
     1.145    38.863     0.150
     1.188    21.152     0.150
     1.188    36.945     0.150
     1.188    37.234     0.150
     1.204    20.812     0.150
     1.204    37.070     0.150
     1.244    22.445     0.150
     1.244    39.223     0.150
     1.285    22.176     0.150
     1.285    39.184     0.150
     1.312    23.504     0.150
     1.312    41.555     0.150
     1.399    23.051     0.150
     1.399    40.055     0.150
     1.478    23.668     0.150
     1.686    26.676     0.150
     1.703    29.734     0.150
     1.703    52.000     0.150
     1.742    52.949     0.150
     1.742    27.887     0.150
     1.973    31.000     0.150
     2.100    32.594     0.150
     2.100    58.512     0.150
     2.100    32.754     0.150
     2.150    34.016     0.150
     2.150    66.059     0.150
     2.285    35.590     0.150
     2.285    63.953     0.150
     2.318    35.969     0.150
     2.586    39.742     0.150
     2.867    86.672     0.150
     2.915    87.891     0.150
     2.965    89.645     0.150
     3.148    50.086     0.150
     3.296   100.082     0.150
     3.365    49.715     0.150
     3.803    57.855     0.150
     3.772   112.828     0.150
     3.772    59.836     0.150
     3.906    58.941     0.150
     4.645    70.176     0.150
     5.466    81.273     0.150
     5.581    82.855     0.150
     5.791    86.105     0.150
     6.093   115.875     0.150
     6.159    90.766     0.150
     6.159   117.375     0.150
     6.344    92.633     0.150
     6.708   126.074     0.150
     7.159   104.574     0.150
     7.231   105.336     0.150
     7.499   110.562     0.150
     7.541   109.523     0.150
     7.829   116.562     0.150
     7.855   114.750     0.150
     7.855   147.949     0.150
     7.855   243.449     0.150
     7.855   114.445     0.150
     8.546   126.473     0.150
    10.378   150.223     0.150
    11.495   166.273     0.150
    14.795   217.754     0.150
    16.126   229.648     0.150
    19.659   272.086     0.150
    21.074   284.414     0.150
    21.781   291.723     0.150
    23.091   305.773     0.150
    37.966   440.070     0.150
     0.156     1.277     0.150
     0.156     4.377     0.150
     0.285     5.167     0.150
     0.683    10.807     0.150
     0.683    20.787     0.150
     0.698    12.487     0.150
     0.656    12.537     0.150
     0.656    22.057     0.150
     0.666    12.037     0.150
     0.722    12.707     0.150
     0.828    14.837     0.150
     0.865    15.617     0.150
     0.865    27.107     0.150
     0.962    16.037     0.150
     0.962    28.322     0.150
     0.980    17.367     0.150
     1.115    20.427     0.150
     1.115    34.927     0.150
     1.100    20.107     0.150
     1.100    35.697     0.150
     1.115    20.517     0.150
     1.115    36.737     0.150
     1.115    37.827     0.150
     1.115    39.217     0.150
     1.242    21.777     0.150
     1.242    39.047     0.150
     1.274    22.757     0.150
     1.274    40.597     0.150
     1.372    22.910     0.150
     1.372    39.701     0.150
     1.346    39.067     0.150
     1.347    23.837     0.150
     1.347    42.137     0.150
     1.522    24.344     0.150
     1.522    42.954     0.150
     1.704    26.947     0.150
     1.764    29.491     0.150
     1.764    53.126     0.150
     1.802    28.247     0.150
     2.047    31.929     0.150
     2.213    35.019     0.150
     2.213    68.261     0.150
     2.264    35.213     0.150
     2.661    40.748     0.150
     2.929    57.167     0.150
     2.929    89.439     0.150
     2.976    90.749     0.150
     3.028    91.568     0.150
     3.163    51.767     0.150
     3.163    96.447     0.150
     3.359   102.267     0.150
     3.419    53.567     0.150
     4.870    73.217     0.150
     5.447    81.657     0.150
     5.884    87.187     0.150
     6.143   119.257     0.150
     6.199    91.307     0.150
     6.199   117.937     0.150
     6.762   127.751     0.150
     7.824   247.147     0.150
     8.368   120.667     0.150
     8.585   127.172     0.150
     8.585   161.197     0.150
     8.585   273.322     0.150
     9.701   142.407     0.150
    10.321   149.472     0.150
    10.321   264.234     0.150
    10.321   324.784     0.150
    10.896   158.867     0.150
    11.513   166.447     0.150
    12.024   172.237     0.150
    13.826   198.427     0.150
    14.779   210.237     0.150
    16.168   230.372     0.150
    18.637   260.147     0.150
    21.110   285.317     0.150
    21.782   293.097     0.150
    23.097   305.172     0.150
    23.097   306.217     0.150
    30.368   372.642     0.150
    37.726   437.222     0.150
    38.020   439.447     0.150
    81.590   738.370     0.150
     0.134     2.697     0.150
     0.134     5.047     0.150
     0.394     7.667     0.150
     0.394    13.907     0.150
     0.587    10.947     0.150
     0.587    19.248     0.150
     0.721    13.868     0.150
     0.721    23.728     0.150
     0.906    16.067     0.150
     1.017    16.729     0.150
     1.017    29.518     0.150
     1.017    16.547     0.150
     1.017    29.887     0.150
     0.984    17.788     0.150
     0.984    31.377     0.150
     1.056    19.297     0.150
     1.056    33.248     0.150
     1.056    19.387     0.150
     1.056    33.417     0.150
     1.056    37.447     0.150
     1.101    19.547     0.150
     1.132    20.587     0.150
     1.132    35.907     0.150
     1.337    21.558     0.150
     1.337    38.393     0.150
     1.330    23.817     0.150
     1.330    41.137     0.150
     1.343    23.177     0.150
     1.343    40.797     0.150
     1.343    23.427     0.150
     1.343    41.637     0.150
     1.343    43.407     0.150
     1.387    43.189     0.150
     1.412    24.857     0.150
     1.461    25.127     0.150
     1.461    44.387     0.150
     1.618    25.589     0.150
     1.618    45.262     0.150
     1.756    27.499     0.150
     1.954    30.199     0.150
     1.954    54.354     0.150
     1.880    30.275     0.150
     1.880    57.304     0.150
     1.921    29.603     0.150
     1.921    58.978     0.150
     1.921    29.841     0.150
     1.921    52.487     0.150
     2.076    32.425     0.150
     2.093    32.142     0.150
     2.239    34.672     0.150
     2.239    61.163     0.150
     2.380    64.985     0.150
     2.334    36.345     0.150
     2.334    71.610     0.150
     2.576    39.124     0.150
     2.732    41.417     0.150
     2.757    41.649     0.150
     3.011    46.157     0.150
     3.011    94.137     0.150
     3.050    92.373     0.150
     3.092    93.837     0.150
     3.147    95.116     0.150
     3.284    52.107     0.150
     3.284    92.107     0.150
     3.284   102.567     0.150
     3.332    51.417     0.150
     3.332   101.188     0.150
     3.480   105.483     0.150
     3.674    53.527     0.150
     3.674   113.467     0.150
     3.706   112.457     0.150
     3.869    58.295     0.150
     3.869   100.687     0.150
     3.956   118.624     0.150
     3.956    60.967     0.150
     3.956    73.357     0.150
     4.435    66.848     0.150
     4.556    68.768     0.150
     4.556    85.627     0.150
     4.556   142.478     0.150
     4.643    69.715     0.150
     4.643    69.837     0.150
     4.643   123.348     0.150
     4.942    73.626     0.150
     4.972    73.738     0.150
     5.012    73.675     0.150
     4.968    73.562     0.150
     4.968    73.797     0.150
     5.422    80.518     0.150
     5.422   140.657     0.150
     5.663    83.808     0.150
     5.663   106.808     0.150
     5.663   178.237     0.150
     5.877   185.018     0.150
     5.999    92.257     0.150
     6.218    90.186     0.150
     6.218    89.748     0.150
     6.218   191.377     0.150
     6.247    92.288     0.150
     6.247   119.137     0.150
     6.288    91.987     0.150
     6.288   116.907     0.150
     6.288   201.748     0.150
     6.851   100.137     0.150
     6.851   125.478     0.150
     6.851   219.308     0.150
     6.872   100.103     0.150
     7.140   104.087     0.150
     7.486   110.578     0.150
     7.777   112.853     0.150
     7.777   241.677     0.150
     7.886   113.598     0.150
     7.964   118.167     0.150
     8.022   117.377     0.150
     8.252   126.038     0.150
     8.252   261.538     0.150
     8.279   118.625     0.150
     8.422   122.257     0.150
     8.669   125.228     0.150
     8.669   274.828     0.150
     9.706   141.987     0.150
     9.879   144.157     0.150
    10.217   147.527     0.150
    10.217   261.853     0.150
    10.531   151.927     0.150
    10.898   158.748     0.150
    11.351   163.438     0.150
    11.559   166.777     0.150
    11.873   173.328     0.150
    11.998   174.407     0.150
    16.258   230.252     0.150
    18.167   250.357     0.150
    22.920   304.348     0.150
    23.119   306.203     0.150
    26.209   334.752     0.150
    30.451   372.476     0.150
    38.130   438.777     0.150
    56.395   582.357     0.150
    95.614   803.978     0.150
    95.614  1036.777     0.150
    95.614  1476.377     0.150
    95.614  1867.877     0.150
   101.665   835.877     0.150
   101.665   840.877     0.150
   102.068   832.578     0.150
   107.352   858.578     0.150
   108.048   863.777     0.150
   108.048  1136.478     0.150
   108.048  1587.578     0.150
   108.048  2048.377     0.150
     0.127     2.326     0.150
     0.127     4.596     0.150
     0.315     4.456     0.150
     0.315     9.366     0.150
     0.483     8.656     0.150
     0.608    10.836     0.150
     0.596    11.036     0.150
     0.629    11.836     0.150
     0.629    20.716     0.150
     0.698    12.576     0.150
     0.698    22.246     0.150
     0.698    23.576     0.150
     0.719    12.976     0.150
     0.758    12.769     0.150
     0.758    23.024     0.150
     0.855    13.676     0.150
     0.855    25.986     0.150
     0.870    14.946     0.150
     0.870    14.806     0.150
     0.870    26.416     0.150
     1.093    19.269     0.150
     1.093    33.787     0.150
     1.113    20.516     0.150
     1.113    35.576     0.150
     1.123    20.206     0.150
     1.123    35.356     0.150
     1.192    21.416     0.150
     1.192    36.706     0.150
     1.245    22.616     0.150
     1.245    39.326     0.150
     1.249    22.386     0.150
     1.301    23.386     0.150
     1.361    22.259     0.150
     1.361    39.163     0.150
     1.409    23.240     0.150
     1.606    49.201     0.150
     1.618    25.961     0.150
     1.618    25.819     0.150
     1.618    45.603     0.150
     1.618    45.116     0.150
     1.866    56.919     0.150
     2.034    32.281     0.150
     2.034    62.557     0.150
     2.169    38.622     0.150
     2.278    39.946     0.150
     2.747    83.225     0.150
     2.793    84.804     0.150
     2.816    85.142     0.150
     2.859    86.677     0.150
     3.181    96.714     0.150
     3.402   103.810     0.150
     3.656   110.102     0.150
     3.656    55.796     0.150
     3.656    65.396     0.150
     3.656   111.946     0.150
     3.855   121.026     0.150
     3.888    58.722     0.150
     4.204    63.776     0.150
     4.204   129.016     0.150
     4.252    62.276     0.150
     4.252    80.006     0.150
     4.252   134.556     0.150
     4.604    69.606     0.150
     5.490    81.526     0.150
     5.490   169.776     0.150
     5.698    84.316     0.150
     5.698   107.406     0.150
     5.698   148.106     0.150
     5.971    87.146     0.150
     5.971   115.146     0.150
     6.391    93.656     0.150
     6.584   125.461     0.150
     7.063   104.096     0.150
     7.063   218.646     0.150
     7.252   105.726     0.150
     7.464   110.376     0.150
     7.464   140.026     0.150
     7.847   113.856     0.150
     7.847   145.736     0.150
     7.864   114.386     0.150
    10.459   151.261     0.150
    15.456   219.336     0.150
    20.966   283.146     0.150
    23.029   304.936     0.150
    24.407   319.476     0.150
    30.219   372.531     0.150
    37.841   440.036     0.150
    81.480   739.586     0.150
    91.632   789.986     0.150
    95.312   802.436     0.150
    95.312  1033.836     0.150
    95.312  1436.136     0.150
    98.048   816.336     0.150
   101.385   831.536     0.150
   101.385   834.736     0.150
   102.709   837.036     0.150
   102.709   844.736     0.150
   107.049   856.236     0.150
   107.786   863.336     0.150
   107.786  1135.536     0.150
   107.786  1586.436     0.150
   107.786  2046.036     0.150
     0.151     2.770     0.150
     0.257     4.999     0.150
     0.273     5.189     0.150
     0.273     9.009     0.150
     0.353     6.258     0.150
     0.353    11.102     0.150
     0.420     8.499     0.150
     0.636    11.577     0.150
     0.636    19.785     0.150
     0.681    12.539     0.150
     0.681    22.329     0.150
     0.744    13.359     0.150
     0.744    23.939     0.150
     0.778    14.129     0.150
     0.778    24.199     0.150
     0.817    15.259     0.150
     0.817    25.179     0.150
     0.817    26.109     0.150
     0.906    15.756     0.150
     0.906    27.518     0.150
     1.089    18.492     0.150
     1.089    31.746     0.150
     1.175    19.654     0.150
     1.175    34.229     0.150
     1.175    34.373     0.150
     1.162    21.319     0.150
     1.162    36.779     0.150
     1.175    21.449     0.150
     1.175    20.853     0.150
     1.175    35.903     0.150
     1.182    21.539     0.150
     1.268    20.689     0.150
     1.268    38.159     0.150
     1.419    23.322     0.150
     1.419    40.086     0.150
     1.549    25.155     0.150
     1.562    26.989     0.150
     1.562    48.409     0.150
     1.563    27.619     0.150
     1.563    51.999     0.150
     1.571    25.714     0.150
     1.642    26.633     0.150
     1.687    27.351     0.150
     1.687    47.947     0.150
     1.929    31.352     0.150
     2.175    34.357     0.150
     2.187    33.970     0.150
     2.286    36.037     0.150
     2.286    68.576     0.150
     2.367    37.033     0.150
     2.376    37.558     0.150
     2.404    41.489     0.150
     2.483    38.245     0.150
     2.536    40.669     0.150
     2.536    46.329     0.150
     2.574    39.464     0.150
     2.574    69.483     0.150
     2.521    41.079     0.150
     2.521    76.919     0.150
     2.571    40.729     0.150
     2.571    77.379     0.150
     2.667    40.910     0.150
     2.839    43.770     0.150
     2.839    51.449     0.150
     2.839    88.929     0.150
     3.194    48.969     0.150
     3.194    90.810     0.150
     3.802    56.999     0.150
     3.802    68.569     0.150
     3.802   118.289     0.150
     3.934    59.749     0.150
     3.934    75.489     0.150
     3.934   122.439     0.150
     4.212    62.299     0.150
     4.212   108.779     0.150
     4.662    69.879     0.150
     5.321    79.819     0.150
     5.606    83.949     0.150
     5.599    83.549     0.150
     5.745   181.789     0.150
     6.183    90.555     0.150
     6.183   112.829     0.150
     6.183   195.454     0.150
     6.268    92.520     0.150
     6.566    97.560     0.150
     6.566   205.529     0.150
     6.618    96.319     0.150
     6.618   201.049     0.150
     7.420   108.389     0.150
     7.511   109.289     0.150
     7.533   110.339     0.150
     7.533   235.619     0.150
     7.637   113.899     0.150
     7.766   114.289     0.150
     7.954   116.520     0.150
     8.061   118.779     0.150
     8.061   250.069     0.150
     8.090   118.204     0.150
     8.090   118.339     0.150
     8.147   118.854     0.150
     8.147   256.429     0.150
     9.658   137.449     0.150
    10.801   155.099     0.150
    10.873   156.404     0.150
    10.873   278.302     0.150
    10.955   157.589     0.150
    11.276   163.529     0.150
    12.414   176.679     0.150
    12.424   179.999     0.150
    13.455   194.879     0.150
    14.431   206.139     0.150
    14.959   212.819     0.150
    15.688   226.254     0.150
    15.858   224.879     0.150
    18.097   251.969     0.150
    18.583   258.079     0.150
    21.704   291.159     0.150
    22.976   304.579     0.150
    24.362   319.848     0.150
    27.342   346.129     0.150
    29.926   368.224     0.150
    37.434   436.379     0.150
    94.867   803.479     0.150
    94.867  1033.779     0.150
    94.867  1438.479     0.150
    94.867  1474.380     0.150
    94.867  1860.979     0.150
    97.587   816.179     0.150
   100.997   830.179     0.150
   100.997   835.079     0.150
   106.602   853.579     0.150
   107.435   863.079     0.150
   107.435  1134.279     0.150
   107.435  1585.179     0.150
   107.435  2043.880     0.150
   116.881  1124.863     0.150
     0.144     3.012     0.150
     0.210     3.965     0.150
     0.249     4.684     0.150
     0.249     8.555     0.150
     0.285     5.012     0.150
     0.299     5.262     0.150
     0.299     8.895     0.150
     0.468     9.375     0.150
     0.588    10.746     0.150
     0.588    18.398     0.150
     0.727    13.285     0.150
     0.727    23.395     0.150
     0.811    15.074     0.150
     0.811    25.895     0.150
     0.811    26.004     0.150
     0.802    13.914     0.150
     0.802    25.242     0.150
     0.802    27.262     0.150
     0.905    15.750     0.150
     0.905    27.555     0.150
     1.046    17.910     0.150
     1.046    30.590     0.150
     1.116    18.914     0.150
     1.116    33.387     0.150
     1.116    33.805     0.150
     1.136    19.984     0.150
     1.136    34.367     0.150
     1.201    21.883     0.150
     1.201    37.984     0.150
     1.201    21.965     0.150
     1.201    38.441     0.150
     1.201    21.934     0.150
     1.201    38.715     0.150
     1.326    22.242     0.150
     1.326    40.805     0.150
     1.363    22.586     0.150
     1.363    39.969     0.150
     1.517    25.191     0.150
     1.529    25.035     0.150
     1.529    44.930     0.150
     1.601    26.184     0.150
     1.618    27.785     0.150
     1.618    51.473     0.150
     1.619    29.383     0.150
     1.709    27.695     0.150
     1.709    49.047     0.150
     1.870    30.660     0.150
     1.870    57.199     0.150
     2.137    33.672     0.150
     2.152    34.109     0.150
     2.152    59.316     0.150
     2.226    34.859     0.150
     2.230    35.422     0.150
     2.230    67.422     0.150
     2.331    36.707     0.150
     2.331    63.488     0.150
     2.332    69.984     0.150
     2.347    37.996     0.150
     2.442    38.277     0.150
     2.493    38.555     0.150
     2.517    43.164     0.150
     2.517    70.895     0.150
     2.613    39.887     0.150
     2.613    39.645     0.150
     2.613    81.363     0.150
     2.664    41.266     0.150
     2.782    42.809     0.150
     2.782    42.543     0.150
     2.786    42.836     0.150
     2.890    44.332     0.150
     3.139    49.363     0.150
     3.139    85.965     0.150
     3.886    59.113     0.150
     4.242    62.035     0.150
     4.242   133.414     0.150
     4.650    70.543     0.150
     4.650   126.965     0.150
     5.282    79.215     0.150
     5.479    81.715     0.150
     5.543    82.582     0.150
     5.543   175.203     0.150
     5.605    84.125     0.150
     5.605   178.953     0.150
     5.694    84.332     0.150
     6.125    89.703     0.150
     6.125   112.250     0.150
     6.125   194.238     0.150
     8.044   117.953     0.150
     8.096   117.762     0.150
     8.096   151.562     0.150
     8.096   256.812     0.150
     8.099   118.387     0.150
     8.099   118.262     0.150
     8.099   205.672     0.150
     9.633   138.172     0.150
     9.633   247.762     0.150
    10.880   156.254     0.150
    10.913   156.512     0.150
    10.972   157.941     0.150
    10.972   274.941     0.150
    11.240   162.715     0.150
    15.128   215.012     0.150
    15.128   397.715     0.150
    15.208   215.645     0.150
    15.208   404.453     0.150
    15.635   223.164     0.150
    16.027   228.422     0.150
    18.599   259.012     0.150
    21.679   291.902     0.150
    22.948   305.215     0.150
    27.344   346.715     0.150
    29.874   369.707     0.150
    37.376   434.480     0.150
    62.286   625.938     0.150
    94.808   802.512     0.150
    94.808  1032.613     0.150
    94.808  1473.113     0.150
    94.808  1859.012     0.150
     0.220     3.086     0.150
     0.220     6.715     0.150
     0.216     4.215     0.150
     0.216     7.816     0.150
     0.604    11.816     0.150
     0.604    20.207     0.150
     0.678    12.266     0.150
     0.685    12.355     0.150
     0.737    13.445     0.150
     0.759    12.406     0.150
     0.759    23.316     0.150
     0.765    13.906     0.150
     0.765    24.047     0.150
     0.765    25.617     0.150
     0.850    14.633     0.150
     0.850    25.883     0.150
     0.883    15.516     0.150
     0.940    15.871     0.150
     0.940    27.777     0.150
     1.070    19.688     0.150
     1.070    33.727     0.150
     1.160    38.066     0.150
     1.160    21.105     0.150
     1.160    40.766     0.150
     1.154    20.734     0.150
     1.154    35.285     0.150
     1.154    20.527     0.150
     1.154    36.355     0.150
     1.166    21.188     0.150
     1.166    36.219     0.150
     1.224    22.266     0.150
     1.224    38.727     0.150
     1.249    21.875     0.150
     1.249    37.957     0.150
     1.289    23.484     0.150
     1.289    40.746     0.150
     1.420    23.691     0.150
     1.420    40.836     0.150
     1.455    23.785     0.150
     1.679    26.660     0.150
     1.666    27.656     0.150
     1.666    50.238     0.150
     1.708    27.305     0.150
     1.708    51.008     0.150
     1.708    27.414     0.150
     1.708    26.984     0.150
     1.886    34.375     0.150
     1.955    30.922     0.150
     2.133    33.395     0.150
     2.133    64.938     0.150
     2.133    32.758     0.150
     2.133    65.836     0.150
     2.114    33.680     0.150
     2.114    65.270     0.150
     2.302    35.824     0.150
     2.313    35.875     0.150
     2.596    40.262     0.150
     2.623    40.465     0.150
     2.830    49.676     0.150
     2.830    85.789     0.150
     2.843    43.723     0.150
     2.843    86.988     0.150
     2.874    45.258     0.150
     2.878    44.707     0.150
     2.878    87.383     0.150
     2.928    88.887     0.150
     3.063    49.875     0.150
     3.124    47.609     0.150
     3.111    49.105     0.150
     3.335    62.465     0.150
     3.735    58.066     0.150
     3.834    57.168     0.150
     4.295    64.465     0.150
     4.341    65.316     0.150
     4.341    77.188     0.150
     4.485    68.734     0.150
     4.652    70.086     0.150
     5.481    81.695     0.150
     5.571    82.887     0.150
     5.780    85.957     0.150
     6.066   116.285     0.150
     6.138    90.445     0.150
     6.373    92.625     0.150
     6.679   124.207     0.150
     7.182   104.695     0.150
     7.255   105.957     0.150
     7.509   111.035     0.150
     7.876   114.207     0.150
     7.876   245.457     0.150
     7.876   114.945     0.150
     7.916   114.965     0.150
     8.089   119.578     0.150
     8.527   123.305     0.150
    10.413   150.625     0.150
    10.413   328.898     0.150
    10.909   157.746     0.150
    11.488   165.672     0.150
    16.104   229.707     0.150
    21.784   292.758     0.150
    23.092   305.508     0.150
    37.936   439.055     0.150
     0.155     3.500     0.150
     0.155     6.332     0.150
     0.405     8.180     0.150
     0.586    11.359     0.150
     0.586    19.473     0.150
     0.670    12.020     0.150
     0.803    14.070     0.150
     0.744    14.293     0.150
     0.744    24.793     0.150
     0.803    14.320     0.150
     0.924    16.090     0.150
     1.012    16.977     0.150
     1.012    30.562     0.150
     1.012    16.742     0.150
     1.004    17.711     0.150
     1.004    32.102     0.150
     1.073    17.691     0.150
     1.073    32.645     0.150
     1.063    19.430     0.150
     1.063    35.133     0.150
     1.063    34.551     0.150
     1.063    19.453     0.150
     1.063    34.102     0.150
     1.153    20.742     0.150
     1.153    36.953     0.150
     1.317    21.742     0.150
     1.317    38.945     0.150
     1.367    23.043     0.150
     1.367    39.781     0.150
     1.367    24.359     0.150
     1.367    43.121     0.150
     1.353    24.191     0.150
     1.406    23.621     0.150
     1.406    43.312     0.150
     1.435    25.070     0.150
     1.622    25.922     0.150
     1.622    45.418     0.150
     1.750    27.871     0.150
     1.750    51.035     0.150
     1.930    30.273     0.150
     1.930    54.500     0.150
     1.930    29.910     0.150
     1.901    31.109     0.150
     1.901    58.242     0.150
     1.935    30.383     0.150
     1.935    53.883     0.150
     1.935    54.895     0.150
     2.093    32.234     0.150
     2.219    34.625     0.150
     2.219    61.227     0.150
     2.372    36.715     0.150
     2.352    36.879     0.150
     2.352    72.863     0.150
     2.560    39.277     0.150
     2.728    41.828     0.150
     2.761    42.238     0.150
     3.070    93.184     0.150
     3.114    94.633     0.150
     3.191    49.207     0.150
     3.167    95.887     0.150
     3.351    54.172     0.150
     3.650    96.961     0.150
     4.627    69.793     0.150
     4.695    71.430     0.150
     5.403    80.473     0.150
     5.657    83.852     0.150
     6.195    89.703     0.150
     6.289    92.602     0.150
     6.881   102.406     0.150
     6.881   131.449     0.150
     7.117   104.242     0.150
     7.470   109.340     0.150
     7.755   114.055     0.150
     7.755   243.457     0.150
     8.669   125.406     0.150
    10.193   147.945     0.150
    10.193   323.570     0.150
    11.550   167.320     0.150
    16.260   230.633     0.150
    28.265   354.508     0.150
    37.829   437.207     0.150
    38.139   439.930     0.150
     0.168     3.109     0.150
     0.244     4.516     0.150
     0.293     5.531     0.150
     0.293     9.969     0.150
     0.344     5.984     0.150
     0.344    10.352     0.150
     0.346     6.117     0.150
     0.491    10.031     0.150
     0.491    18.875     0.150
     0.649    11.891     0.150
     0.649    20.125     0.150
     0.698    13.125     0.150
     0.698    22.906     0.150
     0.741    12.680     0.150
     0.741    23.602     0.150
     0.798    14.109     0.150
     0.798    24.727     0.150
     0.840    15.430     0.150
     0.840    27.000     0.150
     0.882    15.406     0.150
     0.882    26.766     0.150
     0.882    14.867     0.150
     0.882    26.516     0.150
     1.073    18.328     0.150
     1.073    31.648     0.150
     1.176    19.758     0.150
     1.176    34.656     0.150
     1.176    34.859     0.150
     1.181    21.430     0.150
     1.181    38.086     0.150
     1.192    21.242     0.150
     1.192    36.266     0.150
     1.197    21.781     0.150
     1.197    38.211     0.150
     1.205    21.336     0.150
     1.205    38.375     0.150
     1.268    21.758     0.150
     1.268    38.820     0.150
     1.410    23.211     0.150
     1.410    40.930     0.150
     1.527    24.930     0.150
     1.527    43.930     0.150
     1.570    43.156     0.150
     1.571    28.219     0.150
     1.571    50.000     0.150
     1.580    25.984     0.150
     1.580    45.812     0.150
     1.624    26.328     0.150
     1.664    27.047     0.150
     1.664    47.516     0.150
     1.929    31.227     0.150
     1.929    54.047     0.150
     2.153    59.484     0.150
     2.175    34.125     0.150
     2.175    60.008     0.150
     2.275    35.438     0.150
     2.292    36.023     0.150
     2.292    69.062     0.150
     2.348    36.750     0.150
     2.391    37.977     0.150
     2.460    37.648     0.150
     2.529    41.414     0.150
     2.529    77.078     0.150
     2.556    39.227     0.150
     2.556    39.445     0.150
     2.556    81.680     0.150
     2.580    43.797     0.150
     2.580    72.945     0.150
     2.728    82.258     0.150
     2.924    87.148     0.150
     2.951    88.906     0.150
     3.202    49.047     0.150
     3.202    88.500     0.150
     3.805    56.820     0.150
     3.805    71.055     0.150
     3.805   117.891     0.150
     3.920    60.195     0.150
     3.920    75.070     0.150
     3.920   124.695     0.150
     3.973    60.398     0.150
     3.973   125.008     0.150
     4.192    61.164     0.150
     4.192   132.586     0.150
     4.638    69.297     0.150
     4.638    87.852     0.150
     5.302    80.445     0.150
     5.302   169.547     0.150
     5.501    81.758     0.150
     5.582    83.305     0.150
     5.592    83.086     0.150
     5.733    86.156     0.150
     6.179    91.633     0.150
     6.547    96.695     0.150
     6.616    96.875     0.150
     6.708    97.750     0.150
     8.066   117.133     0.150
     8.066   250.359     0.150
     8.066   117.898     0.150
    10.856   155.883     0.150
    11.257   161.656     0.150
    15.678   221.086     0.150
    15.678   219.531     0.150
    22.954   304.883     0.150
    37.191   432.859     0.150
    37.431   433.305     0.150
    94.869  1860.906     0.150
     0.166     3.292     0.150
     0.442     7.611     0.150
     0.486     8.071     0.150
     0.764    14.592     0.150
     0.764    25.852     0.150
     0.711    12.122     0.150
     1.071    18.582     0.150
     1.071    33.052     0.150
     1.081    18.022     0.150
     1.081    33.610     0.150
     1.081    18.292     0.150
     1.081    32.832     0.150
     1.001    19.212     0.150
     1.001    34.661     0.150
     1.152    19.664     0.150
     1.001    19.222     0.150
     1.145    21.021     0.150
     1.360    24.521     0.150
     1.411    24.432     0.150
     1.411    41.832     0.150
     1.411    24.962     0.150
     1.411    24.852     0.150
     1.411    43.781     0.150
     1.475    25.055     0.150
     1.475    46.873     0.150
     1.449    25.911     0.150
     1.542    26.132     0.150
     1.542    48.932     0.150
     1.702    27.872     0.150
     1.816    29.269     0.150
     1.961    31.911     0.150
     1.961    57.914     0.150
     2.014    31.925     0.150
     2.014    32.352     0.150
     1.900    30.021     0.150
     2.435    37.818     0.150
     2.800    79.094     0.150
     2.841    44.255     0.150
     3.087    49.161     0.150
     3.173    48.940     0.150
     3.421    53.411     0.150
     3.421   105.582     0.150
     3.629    56.222     0.150
     3.629    70.332     0.150
     4.046    63.151     0.150
     4.046   128.932     0.150
     4.512    68.661     0.150
     4.667    71.191     0.150
     4.607    69.231     0.150
     4.607   122.372     0.150
     4.607    65.271     0.150
     5.425    81.422     0.150
     5.724    86.542     0.150
     5.724   187.012     0.150
     6.334    94.271     0.150
     6.175    91.142     0.150
     6.367    95.372     0.150
     6.906   104.741     0.150
     6.962   104.325     0.150
     6.962   133.542     0.150
     7.504   112.552     0.150
     7.504   234.281     0.150
     7.761   114.392     0.150
     7.761   146.741     0.150
     7.761   246.292     0.150
     7.761   115.082     0.150
     8.009   120.422     0.150
     8.052   120.012     0.150
     8.113   121.892     0.150
     8.311   124.472     0.150
     8.478   126.052     0.150
     8.746   166.142     0.150
     8.746   279.917     0.150
     9.573   141.472     0.150
     9.820   142.812     0.150
    10.149   148.116     0.150
    10.754   155.771     0.150
    10.816   157.502     0.150
    10.919   157.741     0.150
    11.571   169.132     0.150
    11.612   169.271     0.150
    12.939   188.521     0.150
    13.871   197.842     0.150
    15.528   222.571     0.150
    15.755   225.252     0.150
    15.851   225.281     0.150
    16.339   234.267     0.150
    16.339   231.872     0.150
    16.519   235.031     0.150
    18.134   253.342     0.150
    21.262   287.122     0.150
    21.827   294.252     0.150
    22.894   306.962     0.150
    23.155   309.066     0.150
    30.526   375.837     0.150
    38.220   443.542     0.150
    43.932   489.392     0.150
     0.151     2.846     0.150
     0.201     3.326     0.150
     0.181     3.814     0.150
     0.181     6.814     0.150
     0.208     3.775     0.150
     0.261     4.426     0.150
     0.261     7.893     0.150
     0.261     8.006     0.150
     0.424     7.916     0.150
     0.486     9.016     0.150
     0.486    15.312     0.150
     0.570    11.016     0.150
     0.656    12.016     0.150
     0.656    20.486     0.150
     0.654    12.725     0.150
     0.654    23.355     0.150
     0.754    24.875     0.150
     0.754    13.775     0.150
     0.754    24.535     0.150
     0.766    14.086     0.150
     0.766    24.805     0.150
     0.896    14.865     0.150
     0.896    27.125     0.150
     0.965    16.762     0.150
     0.965    29.287     0.150
     0.965    16.635     0.150
     0.965    29.496     0.150
     1.026    17.863     0.150
     1.026    31.977     0.150
     1.029    17.725     0.150
     1.029    31.076     0.150
     1.029    31.434     0.150
     1.029    17.586     0.150
     1.038    18.389     0.150
     1.038    31.965     0.150
     1.304    21.729     0.150
     1.304    38.629     0.150
     1.416    23.416     0.150
     1.416    43.582     0.150
     1.414    24.115     0.150
     1.414    43.695     0.150
     1.557    25.154     0.150
     1.587    25.652     0.150
     1.685    28.695     0.150
     1.685    52.314     0.150
     1.686    29.545     0.150
     1.783    28.713     0.150
     1.794    28.850     0.150
     1.794    50.691     0.150
     2.132    33.514     0.150
     2.132    64.457     0.150
     2.160    33.705     0.150
     2.171    34.279     0.150
     2.171    65.838     0.150
     2.253    35.547     0.150
     2.253    69.127     0.150
     2.251    62.977     0.150
     2.365    39.305     0.150
     2.416    41.455     0.150
     2.564    77.670     0.150
     2.564    39.510     0.150
     2.707    41.361     0.150
     2.707    41.885     0.150
     2.718    41.543     0.150
     2.712    41.645     0.150
     2.794    84.969     0.150
     3.038    83.205     0.150
     3.651    55.166     0.150
     3.838    57.846     0.150
     3.848    58.846     0.150
     4.253    64.445     0.150
     4.334    63.125     0.150
     4.688    70.814     0.150
     5.137    94.314     0.150
     5.269    79.906     0.150
     5.476    82.326     0.150
     5.662    84.996     0.150
     6.049    89.539     0.150
     6.468    96.445     0.150
     6.474    97.406     0.150
     6.524    99.055     0.150
     6.844    99.795     0.150
     7.504   109.855     0.150
     7.558   112.635     0.150
     7.599   110.885     0.150
     7.742   114.836     0.150
     7.794   149.695     0.150
     7.871   114.666     0.150
     7.884   114.314     0.150
     8.051   117.100     0.150
     8.051   153.076     0.150
     8.051   254.900     0.150
     8.072   119.086     0.150
     8.167   119.150     0.150
     8.167   154.750     0.150
     8.167   119.576     0.150
     8.964   131.375     0.150
     8.964   129.295     0.150
     9.401   137.666     0.150
     9.647   140.406     0.150
     9.698   141.596     0.150
     9.880   143.246     0.150
    10.416   153.545     0.150
    10.910   159.516     0.150
    11.012   158.826     0.150
    11.012   344.701     0.150
    11.051   160.195     0.150
    11.231   162.529     0.150
    11.663   168.395     0.150
    14.344   204.486     0.150
    14.644   206.855     0.150
    14.866   211.506     0.150
    15.084   216.805     0.150
    15.162   214.865     0.150
    15.580   221.375     0.150
    15.580   218.736     0.150
    16.358   231.525     0.150
    18.676   259.875     0.150
    20.597   279.686     0.150
    21.695   292.225     0.150
    22.956   304.426     0.150
    29.826   367.764     0.150
    37.076   431.201     0.150
    37.296   433.322     0.150
     0.116     1.762     0.150
     0.116     4.342     0.150
     0.412     8.553     0.150
     0.448     9.123     0.150
     0.448    15.182     0.150
     0.530     8.803     0.150
     0.530    16.771     0.150
     0.715    13.922     0.150
     0.715    23.662     0.150
     1.001    18.553     0.150
     1.001    32.312     0.150
     1.018    17.643     0.150
     1.018    31.512     0.150
     1.001    18.582     0.150
     1.001    33.201     0.150
     1.001    34.422     0.150
     1.001    34.861     0.150
     1.073    17.838     0.150
     1.073    31.531     0.150
     1.109    33.672     0.150
     1.107    20.053     0.150
     1.367    22.363     0.150
     1.367    38.805     0.150
     1.316    23.012     0.150
     1.316    42.002     0.150
     1.357    23.402     0.150
     1.357    42.383     0.150
     1.424    23.623     0.150
     1.424    44.008     0.150
     1.402    24.242     0.150
     1.675    26.627     0.150
     1.675    46.689     0.150
     1.811    28.629     0.150
     1.811    50.811     0.150
     1.950    30.098     0.150
     1.950    53.514     0.150
     1.908    30.975     0.150
     1.908    58.695     0.150
     1.969    30.787     0.150
     1.969    60.537     0.150
     2.130    32.621     0.150
     2.150    33.443     0.150
     2.272    35.523     0.150
     2.272    61.842     0.150
     2.374    36.902     0.150
     2.374    72.754     0.150
     2.434    37.457     0.150
     2.434    65.018     0.150
     2.617    40.033     0.150
     2.788    42.521     0.150
     2.814    42.836     0.150
     3.067    93.037     0.150
     3.093    47.266     0.150
     3.093    93.898     0.150
     3.120    47.271     0.150
     3.120    94.555     0.150
     3.179    96.100     0.150
     3.253    49.135     0.150
     3.492    52.275     0.150
     3.584    55.232     0.150
     3.678    53.582     0.150
     4.493    67.402     0.150
     4.685    70.682     0.150
     5.455    81.393     0.150
     5.933    87.822     0.150
     6.223    90.012     0.150
     6.303    91.861     0.150
     6.345    92.963     0.150
     6.905   103.303     0.150
     6.926   101.479     0.150
     7.093   103.803     0.150
     7.158   104.072     0.150
     7.526   110.781     0.150
     7.939   117.201     0.150
     8.014   118.252     0.150
     8.130   119.752     0.150
     8.384   121.512     0.150
     8.476   124.492     0.150
     8.726   126.361     0.150
     8.726   221.162     0.150
     8.726   276.137     0.150
     9.084   133.062     0.150
     9.570   140.473     0.150
     9.831   144.082     0.150
    10.203   147.062     0.150
    10.203   321.162     0.150
    11.612   166.562     0.150
    12.625   181.322     0.150
    12.927   187.672     0.150
    14.904   211.723     0.150
    15.738   223.383     0.150
    16.316   229.688     0.150
    16.316   230.861     0.150
    30.508   373.234     0.150
    38.184   441.305     0.150
     0.165     4.156     0.150
     0.165     7.594     0.150
     0.193     3.586     0.150
     0.193     6.664     0.150
     0.202     5.125     0.150
     0.210     3.844     0.150
     0.210     7.633     0.150
     0.218     4.625     0.150
     0.218     6.914     0.150
     0.294     5.094     0.150
     0.294    10.828     0.150
     0.363     7.602     0.150
     0.363    13.242     0.150
     0.352     7.375     0.150
     0.363     8.328     0.150
     0.454     8.734     0.150
     0.454    15.703     0.150
     0.610    11.828     0.150
     0.610    20.477     0.150
     0.766    14.086     0.150
     0.766    24.344     0.150
     0.933    27.711     0.150
     1.077    19.805     0.150
     1.077    34.664     0.150
     1.166    21.414     0.150
     1.166    36.586     0.150
     1.158    20.656     0.150
     1.158    36.695     0.150
     1.166    21.383     0.150
     1.166    37.641     0.150
     1.166    40.438     0.150
     1.225    19.672     0.150
     1.230    22.375     0.150
     1.230    39.344     0.150
     1.293    17.625     0.150
     1.295    23.367     0.150
     1.295    40.914     0.150
     1.471    26.641     0.150
     1.593    28.797     0.150
     1.620    49.703     0.150
     1.668    29.586     0.150
     1.687    27.297     0.150
     1.706    27.383     0.150
     1.706    47.438     0.150
     1.736    28.367     0.150
     1.742    28.625     0.150
     1.757    28.695     0.150
     1.815    33.414     0.150
     2.033    37.062     0.150
     2.033    61.961     0.150
     2.071    33.211     0.150
     2.588    45.133     0.150
     3.063    86.992     0.150
     3.331    90.172     0.150
     3.829    57.562     0.150
     4.290   136.062     0.150
     4.339    65.047     0.150
     4.339   135.242     0.150
     4.645    69.984     0.150
     4.645   124.234     0.150
     4.795    71.203     0.150
     5.215    78.617     0.150
     5.474    81.836     0.150
     6.133   114.297     0.150
     6.368    93.156     0.150
     6.770   127.914     0.150
     7.526   109.961     0.150
     7.752   117.828     0.150
     7.870   115.258     0.150
     8.004   119.305     0.150
     8.048   119.602     0.150
     8.673   124.555     0.150
     8.879   130.086     0.150
     9.704   142.375     0.150
    14.021   197.008     0.150
    16.098   230.086     0.150
    16.268   225.883     0.150
     0.210     4.550     0.150
     0.210     6.730     0.150
     0.209     4.240     0.150
     0.209     7.010     0.150
     0.223     5.120     0.150
     0.223     9.010     0.150
     0.586    10.750     0.150
     0.577    10.580     0.150
     0.611    11.470     0.150
     0.623    11.690     0.150
     0.626    12.410     0.150
     0.626    21.130     0.150
     0.667    11.790     0.150
     0.696    12.440     0.150
     0.713    12.480     0.150
     0.741    13.270     0.150
     0.760    13.870     0.150
     0.760    24.790     0.150
     0.779    14.190     0.150
     0.779    24.460     0.150
     0.804    13.460     0.150
     0.854    14.438     0.150
     0.854    26.087     0.150
     0.891    15.180     0.150
     0.952    15.910     0.150
     1.014    17.190     0.150
     1.070    19.500     0.150
     1.091    19.900     0.150
     1.170    20.990     0.150
     1.170    35.240     0.150
     1.170    21.060     0.150
     1.170    39.770     0.150
     1.175    20.680     0.150
     1.175    36.740     0.150
     1.175    37.480     0.150
     1.179    19.844     0.150
     1.227    19.270     0.150
     1.246    22.320     0.150
     1.265    22.760     0.150
     1.265    38.860     0.150
     1.312    23.190     0.150
     1.397    22.753     0.150
     1.397    39.712     0.150
     1.449    23.072     0.150
     1.449    41.117     0.150
     1.485    24.420     0.150
     1.485   936.590     0.150
     1.607    26.500     0.150
     1.633    26.890     0.150
     1.664    30.390     0.150
     1.664    26.236     0.150
     1.664    46.016     0.150
     1.682    27.403     0.150
     1.682    27.600     0.150
     1.697    27.070     0.150
     1.714    27.170     0.150
     1.714    52.095     0.150
     1.714    26.962     0.150
     1.714    47.304     0.150
     1.745    28.050     0.150
     1.753    28.100     0.150
     1.766    28.410     0.150
     1.824    29.090     0.150
     1.947    30.105     0.150
     2.043    37.520     0.150
     2.081    37.950     0.150
     2.113    32.487     0.150
     2.113    64.227     0.150
     2.113    32.220     0.150
     2.125    32.950     0.150
     2.125    65.440     0.150
     2.280    35.341     0.150
     2.280    68.847     0.150
     2.466    42.402     0.150
     2.466    75.548     0.150
     2.575    39.328     0.150
     2.575    78.296     0.150
     2.588    39.092     0.150
     2.612    45.605     0.150
     2.758    47.335     0.150
     2.840    49.983     0.150
     2.840    50.800     0.150
     2.865    80.390     0.150
     2.861    42.965     0.150
     2.894    43.936     0.150
     2.942    50.890     0.150
     3.074    45.850     0.150
     3.109    47.857     0.150
     3.123    47.480     0.150
     3.123    86.580     0.150
     3.263    48.542     0.150
     3.336    50.990     0.150
     3.336    92.050     0.150
     3.397    55.100     0.150
     3.747    54.970     0.150
     3.812    56.200     0.150
     3.898    58.522     0.150
     4.260    62.840     0.150
     4.287   114.690     0.150
     4.449    65.930     0.150
     4.449   135.190     0.150
     4.632   123.160     0.150
     4.795   126.690     0.150
     5.207    78.190     0.150
     5.460    81.320     0.150
     6.131    89.460     0.150
     6.131   161.360     0.150
     6.352    91.630     0.150
     6.679   102.590     0.150
     6.679   127.900     0.150
     6.679   127.895     0.150
     7.488   110.670     0.150
     7.509   109.130     0.150
     7.509   239.580     0.150
     7.854   114.445     0.150
     7.993   118.780     0.150
     8.036   120.120     0.150
     8.865   129.940     0.150
     9.692   142.110     0.150
    10.394   150.170     0.150
    10.394   324.840     0.150
    10.394   150.170     0.150
    10.394   324.845     0.150
    10.889   159.040     0.150
    11.474   368.780     0.150
    12.753   182.050     0.150
    16.271   229.320     0.150
    16.271   407.490     0.150
    37.937   437.570     0.150
    37.937   437.570     0.150
     0.286     4.759     0.150
     0.286     8.644     0.150
     0.274     5.169     0.150
     0.274     9.029     0.150
     0.455     8.699     0.150
     0.455    15.259     0.150
     0.538    10.489     0.150
     0.538    17.269     0.150
     0.574    10.689     0.150
     0.604    10.674     0.150
     0.604    18.674     0.150
     0.769    13.729     0.150
     0.769    23.749     0.150
     0.746    13.449     0.150
     0.746    23.639     0.150
     0.801    14.479     0.150
     0.801    25.759     0.150
     0.838    15.199     0.150
     0.838    26.939     0.150
     0.838    26.309     0.150
     1.025    17.414     0.150
     1.025    30.339     0.150
     1.031    17.499     0.150
     1.116    18.734     0.150
     1.116    32.784     0.150
     1.116    33.436     0.150
     1.116    32.239     0.150
     1.156    35.233     0.150
     1.228    22.369     0.150
     1.228    38.629     0.150
     1.226    22.429     0.150
     1.226    38.899     0.150
     1.223    22.079     0.150
     1.223    38.349     0.150
     1.352    22.190     0.150
     1.352    39.476     0.150
     1.329    24.199     0.150
     1.329    41.749     0.150
     1.503    24.261     0.150
     1.526    24.994     0.150
     1.526    46.599     0.150
     1.580    25.765     0.150
     1.580    45.946     0.150
     1.629    27.809     0.150
     1.629    48.459     0.150
     1.629    48.599     0.150
     1.630    28.699     0.150
     1.684    27.083     0.150
     1.684    47.928     0.150
     1.869    30.375     0.150
     1.869    53.438     0.150
     2.121    33.122     0.150
     2.125    33.259     0.150
     2.216    34.484     0.150
     2.236    34.997     0.150
     2.472    39.349     0.150
     2.472    45.609     0.150
     2.474    40.399     0.150
     2.474    74.399     0.150
     2.467    37.670     0.150
     2.527    41.869     0.150
     2.527    44.369     0.150
     2.527    75.899     0.150
     2.594    39.267     0.150
     2.637    40.257     0.150
     2.775    42.439     0.150
     2.775    49.759     0.150
     2.775    87.169     0.150
     3.148    49.669     0.150
     3.148    54.749     0.150
     3.148    95.719     0.150
     3.746    56.019     0.150
     3.746    68.709     0.150
     3.746   114.719     0.150
     3.913    58.469     0.150
     3.913    71.179     0.150
     3.913   120.729     0.150
     4.220    61.709     0.150
     4.220    77.529     0.150
     4.220   130.379     0.150
     4.622    69.539     0.150
     4.622    87.599     0.150
     5.260    79.069     0.150
     5.260    96.369     0.150
     5.457    81.429     0.150
     5.457   103.869     0.150
     5.457   173.319     0.150
     5.533    82.669     0.150
     5.533   174.149     0.150
     5.578    82.489     0.150
     5.578   102.699     0.150
     5.578   178.229     0.150
     5.678    83.499     0.150
     5.678   106.479     0.150
     5.678   181.129     0.150
     6.118    89.209     0.150
     6.118   112.484     0.150
     6.507    97.189     0.150
     6.507   122.779     0.150
     6.555    98.869     0.150
     6.555   120.949     0.150
     6.560    97.089     0.150
     6.560   116.349     0.150
     6.560   202.199     0.150
     6.732    97.819     0.150
     6.732   214.759     0.150
     7.406   108.079     0.150
     7.406   238.319     0.150
     7.493   110.229     0.150
     7.493   141.639     0.150
     7.493   230.689     0.150
     7.499   109.069     0.150
     7.580   142.499     0.150
     7.580   241.049     0.150
     7.712   113.159     0.150
     7.712   241.779     0.150
     7.845   117.529     0.150
     7.845   149.429     0.150
     7.863   113.999     0.150
     7.885   114.419     0.150
     7.885   149.129     0.150
     7.907   116.549     0.150
     8.017   117.979     0.150
     8.017   149.819     0.150
     8.017   251.209     0.150
     8.080   254.709     0.150
     8.072   117.739     0.150
     8.072   255.039     0.150
     8.535   123.029     0.150
     8.535   163.069     0.150
     9.131   133.499     0.150
     9.408   136.239     0.150
     9.536   138.859     0.150
     9.607   139.059     0.150
    10.853   157.879     0.150
    10.894   155.659     0.150
    10.936   160.099     0.150
    10.946   157.779     0.150
    11.217   160.609     0.150
    11.925   173.509     0.150
    12.359   181.569     0.150
    14.289   201.279     0.150
    14.365   206.639     0.150
    14.660   207.809     0.150
    14.667   208.079     0.150
    15.111   214.789     0.150
    15.192   217.319     0.150
    15.622   222.384     0.150
    15.622   221.499     0.150
    15.799   222.889     0.150
    16.441   233.709     0.150
    18.627   257.129     0.150
    20.625   279.509     0.150
    21.653   291.099     0.150
    22.923   303.234     0.150
    27.317   345.729     0.150
    27.528   348.009     0.150
    29.859   367.954     0.150
    37.132   430.959     0.150
    37.371   433.309     0.150
    94.809   801.859     0.150
    94.809  1031.959     0.150
    94.809  1472.459     0.150
    94.809  1858.459     0.150
    97.537   813.359     0.150
   100.932   831.459     0.150
   101.065   826.959     0.150
   101.065   831.059     0.150
   101.065   834.059     0.150
   102.210   834.759     0.150
   102.210   839.959     0.150
   102.210   841.859     0.150
   102.210  1087.959     0.150
   106.545   854.459     0.150
   107.368  1540.759     0.150
     0.149     2.719     0.150
     0.256     4.879     0.150
     0.270     5.156     0.150
     0.270     9.047     0.150
     0.342     6.078     0.150
     0.352     6.227     0.150
     0.352    10.961     0.150
     0.422     8.406     0.150
     0.422    14.699     0.150
     0.633    11.488     0.150
     0.633    19.504     0.150
     0.682    12.586     0.150
     0.746    12.777     0.150
     0.746    23.348     0.150
     0.776    13.855     0.150
     0.776    23.848     0.150
     0.815    15.156     0.150
     0.815    26.219     0.150
     1.089    18.449     0.150
     1.089    31.977     0.150
     1.173    19.562     0.150
     1.173    34.172     0.150
     1.173    19.355     0.150
     1.172    20.684     0.150
     1.172    35.461     0.150
     1.162    21.289     0.150
     1.162    36.918     0.150
     1.175    21.426     0.150
     1.175    37.258     0.150
     1.181    21.488     0.150
     1.181    37.289     0.150
     1.270    21.496     0.150
     1.270    39.016     0.150
     1.417    23.230     0.150
     1.550    25.098     0.150
     1.550    44.906     0.150
     1.569    25.727     0.150
     1.569    45.375     0.150
     1.564    26.879     0.150
     1.641    26.570     0.150
     1.641    46.789     0.150
     1.689    27.289     0.150
     1.689    47.891     0.150
     1.927    31.059     0.150
     2.176    34.156     0.150
     2.186    34.148     0.150
     2.281    35.422     0.150
     2.284    36.051     0.150
     2.284    68.621     0.150
     2.367    37.137     0.150
     2.373    37.254     0.150
     2.380    37.344     0.150
     2.402    72.465     0.150
     2.485    38.270     0.150
     2.518    41.316     0.150
     2.518    76.309     0.150
     2.568    39.816     0.150
     2.576    39.148     0.150
     2.576    38.969     0.150
     2.716    81.719     0.150
     2.838    43.137     0.150
     3.191    51.156     0.150
     3.740    55.871     0.150
     3.800    57.008     0.150
     3.933    59.719     0.150
     3.974    58.738     0.150
     4.039    60.648     0.150
     4.214    61.027     0.150
     4.663    70.047     0.150
     5.321    79.816     0.150
     5.518    82.105     0.150
     5.607    83.617     0.150
     5.744    84.777     0.150
     6.181    91.453     0.150
     6.566   100.098     0.150
     6.615    99.379     0.150
     6.732    97.836     0.150
     7.422   107.617     0.150
     7.513   109.176     0.150
     7.533   111.098     0.150
     7.637   114.117     0.150
     7.766   114.328     0.150
     7.955   116.758     0.150
     8.092   118.129     0.150
     8.092   118.016     0.150
     9.643   139.438     0.150
     9.659   140.367     0.150
    10.876   156.102     0.150
    10.876   342.238     0.150
    10.957   159.879     0.150
     0.205     4.102     0.150
     0.205     7.230     0.150
     0.205     5.160     0.150
     0.207     4.309     0.150
     0.207     5.559     0.150
     0.227     2.770     0.150
     0.227     5.980     0.150
     0.572    10.520     0.150
     0.583    10.930     0.150
     0.618    11.871     0.150
     0.626    11.801     0.150
     0.663    12.039     0.150
     0.662    12.449     0.150
     0.692    12.391     0.150
     0.713    12.738     0.150
     0.736    13.379     0.150
     0.775    13.949     0.150
     0.775    24.770     0.150
     0.799    13.859     0.150
     0.765    12.531     0.150
     0.765    23.281     0.150
     0.800    13.672     0.150
     0.850    14.980     0.150
     0.850    25.910     0.150
     0.850    14.609     0.150
     0.886    15.691     0.150
     0.921    15.699     0.150
     0.921    28.801     0.150
     0.947    16.359     0.150
     1.009    17.551     0.150
     1.065    19.109     0.150
     1.092    20.031     0.150
     1.175    20.746     0.150
     1.175    36.109     0.150
     1.172    21.230     0.150
     1.172    36.680     0.150
     1.172    21.539     0.150
     1.172    37.289     0.150
     1.174    22.109     0.150
     1.174    38.828     0.150
     1.222    19.539     0.150
     1.246    22.602     0.150
     1.328    21.500     0.150
     1.311    23.371     0.150
     1.398    23.574     0.150
     1.398    41.301     0.150
     1.445    23.551     0.150
     1.445    42.301     0.150
     1.481    25.430     0.150
     1.541    24.781     0.150
     1.555    24.801     0.150
     1.603    26.859     0.150
     1.661    26.723     0.150
     1.678    28.375     0.150
     1.678    28.449     0.150
     1.692    27.379     0.150
     1.709    27.102     0.150
     1.709    49.699     0.150
     1.741    28.078     0.150
     1.749    28.602     0.150
     1.762    28.648     0.150
     1.820    29.320     0.150
     1.880    29.770     0.150
     1.880    30.031     0.150
     1.943    30.789     0.150
     1.993    31.469     0.150
     2.031    32.480     0.150
     2.039    32.449     0.150
     2.120    33.738     0.150
     2.120    65.289     0.150
     2.115    32.887     0.150
     2.115    65.688     0.150
     2.115    32.328     0.150
     2.280    35.953     0.150
     2.294    35.984     0.150
     2.294    69.492     0.150
     2.419    37.988     0.150
     2.461    38.902     0.150
     2.461    39.359     0.150
     2.496    39.398     0.150
     2.574    40.387     0.150
     2.584    40.094     0.150
     2.608    40.609     0.150
     2.753    42.402     0.150
     2.835    43.953     0.150
     2.835    86.262     0.150
     2.835    51.500     0.150
     2.836    44.641     0.150
     2.836    51.770     0.150
     2.861    45.191     0.150
     2.861    54.531     0.150
     2.858    44.137     0.150
     2.858    86.594     0.150
     2.890    44.430     0.150
     2.890    87.070     0.150
     2.938    45.145     0.150
     2.938    88.914     0.150
     2.985    48.512     0.150
     3.001    45.840     0.150
     3.002    55.141     0.150
     3.015    46.273     0.150
     3.070    47.102     0.150
     3.070    87.699     0.150
     3.106    47.332     0.150
     3.106    92.723     0.150
     3.119    48.059     0.150
     3.119    55.289     0.150
     3.119    94.289     0.150
     3.258    49.422     0.150
     3.266    49.738     0.150
     3.266    98.699     0.150
     3.290    50.828     0.150
     3.331    50.199     0.150
     3.331    50.633     0.150
     3.331    61.828     0.150
     3.492    53.441     0.150
     3.742    56.656     0.150
     3.742   112.062     0.150
     3.742    57.191     0.150
     3.768    56.164     0.150
     3.820    57.316     0.150
     3.814    56.199     0.150
     3.814   100.801     0.150
     3.814    70.078     0.150
     3.814   124.012     0.150
     3.844    58.820     0.150
     3.898    59.547     0.150
     4.060    61.230     0.150
     4.145    62.363     0.150
     4.214    66.859     0.150
     4.214    77.770     0.150
     4.214   134.219     0.150
     4.248    63.480     0.150
     4.283    64.551     0.150
     4.283   130.852     0.150
     4.322    64.152     0.150
     4.343    64.602     0.150
     4.343   134.988     0.150
     4.440    66.180     0.150
     4.482    66.898     0.150
     4.631    70.145     0.150
     4.631    70.539     0.150
     4.791    72.102     0.150
     4.800    70.996     0.150
     4.880    73.426     0.150
     4.909    74.551     0.150
     4.909   130.539     0.150
     4.909   127.738     0.150
     4.996    73.883     0.150
     5.026    75.176     0.150
     5.051    76.672     0.150
     5.070    75.691     0.150
     5.180    76.527     0.150
     5.204    78.602     0.150
     5.235    78.031     0.150
     5.366    80.570     0.150
     5.405    80.387     0.150
     5.459    81.816     0.150
     5.459    81.680     0.150
     5.554    83.000     0.150
     5.548    84.230     0.150
     5.548   147.328     0.150
     5.548   149.352     0.150
     5.725    86.559     0.150
     5.764    85.801     0.150
     5.764   186.449     0.150
     6.060    89.602     0.150
     6.060   115.629     0.150
     6.127    90.598     0.150
     6.127    90.699     0.150
     6.127   117.488     0.150
     6.141    92.516     0.150
     6.170    92.039     0.150
     6.197    93.328     0.150
     6.353    92.906     0.150
     6.353    91.988     0.150
     6.353   196.012     0.150
     6.675    99.227     0.150
     6.675   215.121     0.150
     6.759   101.410     0.150
     6.778   100.699     0.150
     6.806   101.480     0.150
     6.817    98.699     0.150
     7.134   108.531     0.150
     7.154   105.102     0.150
     7.160   105.000     0.150
     7.234   105.719     0.150
     7.256   106.719     0.150
     7.487   110.984     0.150
     7.487   110.250     0.150
     7.487   237.309     0.150
     7.510   109.852     0.150
     7.738   117.719     0.150
     7.805   115.828     0.150
     7.854   115.398     0.150
     7.854   114.773     0.150
     7.854   114.461     0.150
     7.854   244.781     0.150
     7.897   116.500     0.150
     7.991   118.059     0.150
     8.034   119.559     0.150
     8.212   123.602     0.150
     8.212   122.035     0.150
     8.327   121.379     0.150
     8.349   122.301     0.150
     8.431   121.551     0.150
     8.515   124.500     0.150
     8.515   124.352     0.150
     8.803   130.398     0.150
     8.864   129.418     0.150
     8.864   129.770     0.150
     8.882   130.789     0.150
     8.882   288.719     0.150
     8.927   131.039     0.150
     8.978   133.340     0.150
     9.011   132.113     0.150
     9.195   137.168     0.150
     9.254   134.012     0.150
     9.254   237.961     0.150
     9.274   136.172     0.150
     9.415   138.219     0.150
     9.483   139.742     0.150
     9.563   139.902     0.150
     9.662   140.441     0.150
     9.690   142.641     0.150
     9.738   142.859     0.150
     9.738   311.320     0.150
     9.739   141.387     0.150
     9.757   142.500     0.150
     9.767   142.227     0.150
     9.836   145.051     0.150
     9.881   144.262     0.150
     9.917   145.902     0.150
    10.021   146.203     0.150
    10.099   147.211     0.150
    10.189   148.500     0.150
    10.186   147.762     0.150
    10.191   147.566     0.150
    10.211   149.363     0.150
    10.211   150.719     0.150
    10.260   148.992     0.150
    10.288   150.180     0.150
    10.397   150.324     0.150
    10.416   151.559     0.150
    10.430   153.387     0.150
    10.466   154.270     0.150
    10.478   152.766     0.150
    10.491   156.672     0.150
    10.544   154.000     0.150
    10.579   155.484     0.150
    10.614   154.355     0.150
    10.647   154.996     0.150
    10.647   154.621     0.150
    10.642   156.090     0.150
    10.642   153.699     0.150
    10.760   156.113     0.150
    10.771   156.895     0.150
    10.820   158.246     0.150
    10.827   156.504     0.150
    10.890   160.602     0.150
    10.887   158.301     0.150
    10.887   157.371     0.150
    10.915   158.453     0.150
    10.922   158.480     0.150
    10.982   161.234     0.150
    10.991   159.504     0.150
    11.043   160.879     0.150
    11.070   161.242     0.150
    11.095   161.555     0.150
    11.127   161.051     0.150
    11.127   162.961     0.150
    11.124   163.094     0.150
    11.191   163.070     0.150
    11.183   163.461     0.150
    11.198   163.898     0.150
    11.198   163.152     0.150
    11.197   162.039     0.150
    11.304   163.535     0.150
    11.351   165.586     0.150
    11.351   165.879     0.150
    11.338   164.789     0.150
    11.349   165.086     0.150
    11.396   169.699     0.150
    11.401   166.371     0.150
    11.413   166.176     0.150
    11.420   166.695     0.150
    11.420   165.930     0.150
    11.433   166.270     0.150
    11.459   166.852     0.150
    11.459   168.102     0.150
    11.470   165.461     0.150
    11.471   165.801     0.150
    11.471   365.699     0.150
    11.484   166.590     0.150
    11.509   168.020     0.150
    11.533   166.980     0.150
    11.544   167.301     0.150
    11.572   167.129     0.150
    11.590   168.867     0.150
    11.586   166.430     0.150
    11.579   166.789     0.150
    11.667   170.559     0.150
    11.659   168.609     0.150
    11.659   167.328     0.150
    11.682   169.578     0.150
    11.727   169.418     0.150
    11.765   172.102     0.150
    11.784   172.988     0.150
    11.865   170.988     0.150
    11.888   173.809     0.150
    11.895   171.926     0.150
    11.962   174.840     0.150
    11.973   174.750     0.150
    11.969   174.000     0.150
    11.988   174.055     0.150
    11.991   175.523     0.150
    11.986   173.840     0.150
    12.009   175.297     0.150
    12.007   176.711     0.150
    12.028   175.559     0.150
    12.031   174.453     0.150
    12.031   173.559     0.150
    12.072   175.254     0.150
    12.080   175.445     0.150
    12.076   175.164     0.150
    12.110   174.801     0.150
    12.121   175.793     0.150
    12.136   175.797     0.150
    12.154   177.461     0.150
    12.156   177.930     0.150
    12.197   175.141     0.150
    12.187   175.801     0.150
    12.225   176.273     0.150
    12.256   178.203     0.150
    12.259   176.777     0.150
    12.258   176.746     0.150
    12.303   181.871     0.150
    12.326   178.828     0.150
    12.326   178.469     0.150
    12.330   177.934     0.150
    12.384   181.461     0.150
    12.432   179.141     0.150
    12.460   180.750     0.150
    12.484   179.941     0.150
    12.487   179.832     0.150
    12.522   180.023     0.150
    12.522   180.988     0.150
    12.524   180.574     0.150
    12.546   181.629     0.150
    12.588   181.699     0.150
    12.594   180.926     0.150
    12.601   181.648     0.150
    12.620   182.352     0.150
    12.635   182.359     0.150
    12.627   181.957     0.150
    12.679   182.859     0.150
    12.705   183.629     0.150
    12.709   182.691     0.150
    12.709   184.352     0.150
    12.718   186.160     0.150
    12.701   181.961     0.150
    12.718   183.895     0.150
    12.721   182.609     0.150
    12.738   186.578     0.150
    12.794   184.289     0.150
    12.785   184.844     0.150
    12.794   183.629     0.150
    12.815   185.367     0.150
    12.813   184.754     0.150
    12.826   186.230     0.150
    12.832   184.543     0.150
    12.847   186.516     0.150
    12.860   188.602     0.150
    12.859   185.711     0.150
    12.886   188.180     0.150
    12.894   185.418     0.150
    12.953   186.266     0.150
    12.964   189.449     0.150
    12.948   185.273     0.150
    12.988   190.910     0.150
    12.990   189.090     0.150
    12.995   187.473     0.150
    13.001   188.598     0.150
    13.010   185.750     0.150
    13.013   186.336     0.150
    13.040   188.133     0.150
    13.074   186.910     0.150
    13.102   188.074     0.150
    13.103   187.789     0.150
    13.115   187.949     0.150
    13.160   189.113     0.150
    13.174   188.961     0.150
    13.196   189.789     0.150
    13.192   189.027     0.150
    13.224   189.988     0.150
    13.224   188.699     0.150
    13.224   414.922     0.150
    13.249   190.391     0.150
    13.272   190.445     0.150
    13.295   194.691     0.150
    13.282   191.336     0.150
    13.297   190.562     0.150
    13.307   190.098     0.150
    13.334   192.102     0.150
    13.355   190.953     0.150
    13.366   195.621     0.150
    13.351   191.219     0.150
    13.347   192.102     0.150
    13.347   191.293     0.150
    13.375   191.992     0.150
    13.373   191.703     0.150
    13.398   192.070     0.150
    13.400   192.391     0.150
    13.403   191.906     0.150
    13.411   191.293     0.150
    13.417   192.051     0.150
    13.461   192.973     0.150
    13.514   193.258     0.150
    13.555   194.012     0.150
    13.567   197.301     0.150
    13.562   192.902     0.150
    13.585   193.828     0.150
    13.652   199.570     0.150
    13.657   195.211     0.150
    13.673   195.316     0.150
    13.672   195.535     0.150
    13.713   197.762     0.150
    13.738   195.727     0.150
    13.747   195.453     0.150
    13.747   194.738     0.150
    13.766   199.031     0.150
    13.763   196.566     0.150
    13.771   196.312     0.150
    13.804   197.203     0.150
    13.801   196.699     0.150
    13.828   197.789     0.150
    13.850   200.301     0.150
    13.838   197.418     0.150
    13.879   197.969     0.150
    13.905   198.477     0.150
    13.892   197.723     0.150
    13.900   198.324     0.150
    13.912   198.152     0.150
    13.926   197.887     0.150
    13.948   198.660     0.150
    13.967   199.414     0.150
    13.984   200.258     0.150
    14.006   199.301     0.150
    14.035   199.973     0.150
    14.037   200.500     0.150
    14.081   200.672     0.150
    14.087   201.410     0.150
    14.082   201.117     0.150
    14.103   200.980     0.150
    14.105   201.227     0.150
    14.111   201.324     0.150
    14.195   202.379     0.150
    14.208   202.613     0.150
    14.218   201.602     0.150
    14.225   202.598     0.150
    14.238   204.469     0.150
    14.224   202.930     0.150
    14.268   203.809     0.150
    14.268   203.062     0.150
    14.307   203.488     0.150
    14.327   204.402     0.150
    14.339   203.207     0.150
    14.366   204.445     0.150
    14.384   204.695     0.150
    14.414   205.242     0.150
    14.430   205.867     0.150
    14.477   205.875     0.150
    14.476   205.312     0.150
    14.533   209.391     0.150
    14.531   205.520     0.150
    14.547   206.273     0.150
    14.539   205.598     0.150
    14.545   205.688     0.150
    14.550   206.090     0.150
    14.569   206.863     0.150
    14.565   206.523     0.150
    14.585   206.703     0.150
    14.585   206.746     0.150
    14.634   207.922     0.150
    14.634   211.051     0.150
    14.628   207.180     0.150
    14.619   207.703     0.150
    14.648   207.723     0.150
    14.659   206.934     0.150
    14.679   207.988     0.150
    14.685   208.484     0.150
    14.713   208.426     0.150
    14.720   212.422     0.150
    14.747   209.258     0.150
    14.758   213.762     0.150
    14.765   212.391     0.150
    14.768   212.672     0.150
    14.787   214.301     0.150
    14.772   209.371     0.150
    14.801   209.500     0.150
    14.799   209.469     0.150
    14.804   209.328     0.150
    14.799   209.988     0.150
    14.801   208.438     0.150
    14.826   209.887     0.150
    14.840   209.605     0.150
    14.867   211.328     0.150
    14.865   209.746     0.150
    14.873   210.719     0.150
    14.882   210.617     0.150
    14.882   209.691     0.150
    14.900   210.199     0.150
    14.985   212.285     0.150
    15.035   213.523     0.150
    15.056   212.477     0.150
    15.072   216.289     0.150
    15.079   214.141     0.150
    15.077   213.012     0.150
    15.082   213.625     0.150
    15.084   217.051     0.150
    15.086   216.840     0.150
    15.110   213.773     0.150
    15.116   213.465     0.150
    15.116   214.969     0.150
    15.158   213.832     0.150
    15.169   214.688     0.150
    15.169   215.461     0.150
    15.170   214.699     0.150
    15.183   214.410     0.150
    15.204   215.031     0.150
    15.211   215.566     0.150
    15.214   215.102     0.150
    15.241   215.426     0.150
    15.225   214.879     0.150
    15.246   215.590     0.150
    15.257   215.367     0.150
    15.257   216.102     0.150
    15.296   216.883     0.150
    15.302   216.816     0.150
    15.309   219.461     0.150
    15.311   215.418     0.150
    15.316   216.547     0.150
    15.329   216.309     0.150
    15.345   216.840     0.150
    15.357   220.102     0.150
    15.385   216.777     0.150
    15.377   216.820     0.150
    15.394   217.180     0.150
    15.427   218.148     0.150
    15.505   219.316     0.150
    15.534   221.871     0.150
    15.579   223.250     0.150
    15.583   220.199     0.150
    15.625   223.680     0.150
    15.625   520.578     0.150
    15.638   220.066     0.150
    15.662   224.762     0.150
    15.662   526.629     0.150
    15.673   220.828     0.150
    15.716   223.070     0.150
    15.706   220.988     0.150
    15.704   221.578     0.150
    15.715   221.344     0.150
    15.734   225.020     0.150
    15.738   223.410     0.150
    15.739   222.000     0.150
    15.749   222.547     0.150
    15.747   221.973     0.150
    15.771   222.938     0.150
    15.795   226.340     0.150
    15.810   226.871     0.150
    15.834   223.195     0.150
    15.850   222.707     0.150
    15.841   222.906     0.150
    15.842   223.641     0.150
    15.868   222.609     0.150
    15.884   222.848     0.150
    15.907   224.711     0.150
    15.892   223.656     0.150
    15.910   224.598     0.150
    15.919   223.777     0.150
    15.971   224.184     0.150
    15.985   225.520     0.150
    16.043   227.629     0.150
    16.064   224.910     0.150
    16.093   225.699     0.150
    16.093   228.551     0.150
    16.090   225.504     0.150
    16.124   226.777     0.150
    16.134   227.344     0.150
    16.155   226.680     0.150
    16.198   227.246     0.150
    16.213   227.855     0.150
    16.220   227.031     0.150
    16.239   228.188     0.150
    16.341   229.812     0.150
    16.341   232.859     0.150
    16.358   230.480     0.150
    16.381   229.910     0.150
    16.388   229.215     0.150
    16.416   233.398     0.150
    16.424   231.199     0.150
    16.444   231.012     0.150
    16.461   232.156     0.150
    16.463   231.910     0.150
    16.472   230.797     0.150
    16.485   231.246     0.150
    16.485   233.602     0.150
    16.515   234.340     0.150
    16.501   230.809     0.150
    16.508   230.914     0.150
    16.527   231.648     0.150
    16.567   231.328     0.150
    16.567   233.949     0.150
    16.627   234.414     0.150
    16.641   233.305     0.150
    16.648   233.059     0.150
    16.648   234.820     0.150
    16.692   233.746     0.150
    16.737   233.883     0.150
    16.748   234.047     0.150
    16.792   234.934     0.150
    16.810   234.660     0.150
    16.817   238.602     0.150
    16.860   239.070     0.150
    16.918   236.555     0.150
    16.942   237.668     0.150
    16.948   241.352     0.150
    16.965   236.730     0.150
    17.008   237.473     0.150
    17.061   238.887     0.150
    17.051   235.746     0.150
    17.066   238.172     0.150
    17.059   238.750     0.150
    17.080   238.496     0.150
    17.085   237.738     0.150
    17.089   238.926     0.150
    17.249   239.652     0.150
    17.318   241.422     0.150
    17.393   242.406     0.150
    17.409   242.695     0.150
    17.499   244.160     0.150
    17.505   246.871     0.150
    17.531   248.398     0.150
    17.538   246.699     0.150
    17.541   244.074     0.150
    17.548   244.453     0.150
    17.615   245.410     0.150
    17.625   244.949     0.150
    17.636   245.727     0.150
    17.658   246.234     0.150
    17.658   246.020     0.150
    17.650   245.926     0.150
    17.688   245.523     0.150
    17.766   247.910     0.150
    17.765   247.203     0.150
    17.902   250.148     0.150
    17.983   250.840     0.150
    17.988   250.785     0.150
    18.001   251.105     0.150
    18.100   251.527     0.150
    18.184   252.629     0.150
    18.192   251.980     0.150
    18.200   253.211     0.150
    18.202   253.219     0.150
    18.220   252.539     0.150
    18.274   254.195     0.150
    18.274   255.359     0.150
    18.277   254.699     0.150
    18.470   256.477     0.150
    18.480   257.016     0.150
    18.515   256.367     0.150
    18.537   256.918     0.150
    18.634   257.141     0.150
    18.696   258.895     0.150
    18.702   258.449     0.150
    18.713   259.520     0.150
    18.729   259.766     0.150
    18.922   262.547     0.150
    19.022   262.641     0.150
    19.053   262.613     0.150
    19.073   264.234     0.150
    19.185   264.695     0.150
    19.338   265.688     0.150
    19.420   267.773     0.150
    19.514   268.488     0.150
    19.639   270.105     0.150
    19.751   271.117     0.150
    20.047   274.570     0.150
    20.064   273.094     0.150
    20.145   274.246     0.150
    20.600   280.094     0.150
    20.664   280.305     0.150
    20.948   286.398     0.150
    21.029   283.789     0.150
    21.360   288.500     0.150
    21.718   289.500     0.150
    21.740   291.855     0.150
    21.740   294.078     0.150
    21.763   291.473     0.150
    21.763   291.660     0.150
    21.787   292.301     0.150
    22.024   295.930     0.150
    22.459   299.000     0.150
    23.018   306.602     0.150
    23.027   304.328     0.150
    23.072   306.602     0.150
    23.072   305.398     0.150
    23.072   726.324     0.150
    23.272   310.648     0.150
    23.814   313.699     0.150
    23.820   313.168     0.150
    24.023   318.000     0.150
    24.063   315.523     0.150
    24.305   320.000     0.150
    24.375   318.898     0.150
    24.404   319.699     0.150
    24.404   318.699     0.150
    26.310   337.199     0.150
    26.310   337.324     0.150
    26.718   340.699     0.150
    26.894   341.285     0.150
    27.149   344.422     0.150
    28.069   354.102     0.150
    28.327   353.660     0.150
    28.327   355.340     0.150
    28.362   351.676     0.150
    29.456   364.961     0.150
    30.158   371.398     0.150
    30.299   372.496     0.150
    32.117   390.020     0.150
    32.600   392.281     0.150
    33.872   403.672     0.150
    34.181   409.379     0.150
    34.399   408.078     0.150
    34.549   411.570     0.150
    35.079   415.922     0.150
    35.244   417.129     0.150
    35.855   422.570     0.150
    36.228   426.102     0.150
    36.279   426.078     0.150
    36.551   427.180     0.150
    37.370   436.129     0.150
    37.423   435.820     0.150
    37.646   437.102     0.150
    37.901   440.102     0.150
    37.932   439.801     0.150
    38.191   442.398     0.150
    38.304   443.398     0.150
    38.304   443.211     0.150
    38.479   444.039     0.150
    38.550   444.891     0.150
    38.817   447.762     0.150
    38.941   448.102     0.150
    38.945   449.680     0.150
    40.602   462.559     0.150
    40.713   461.273     0.150
    40.713   462.320     0.150
    40.920   464.340     0.150
    43.731   486.500     0.150
    44.144   490.980     0.150
    45.859   503.129     0.150
    46.388   512.371     0.150
    46.738   511.441     0.150
    46.770   513.129     0.150
    46.875   511.691     0.150
    46.958   516.137     0.150
    47.082   515.629     0.150
    47.103   515.160     0.150
    47.106   512.840     0.150
    47.106   516.059     0.150
    47.137   517.020     0.150
    47.273   516.090     0.150
    47.367   516.559     0.150
    47.367   515.781     0.150
    47.558   517.949     0.150
    50.867   542.801     0.150
    50.922   544.699     0.150
    50.922   545.570     0.150
    53.630   562.898     0.150
    55.665   577.898     0.150
    55.665   578.102     0.150
    56.191   583.102     0.150
    56.191  1052.500     0.150
    56.191   582.031     0.150
    58.152  1076.500     0.150
    60.416   609.801     0.150
    61.602   619.570     0.150
    61.602   618.988     0.150
    62.746   628.301     0.150
    62.746  1132.602     0.150
    63.266   630.273     0.150
    66.062   649.352     0.150
    67.287   655.898     0.150
    67.287   655.480     0.150
    70.268   675.672     0.150
    70.638   674.840     0.150
    72.619   688.398     0.150
    72.619     7.500     0.150
    72.619   702.602     0.150
    72.619   851.000     0.150
    72.619  1250.898     0.150
    72.619  1293.000     0.150
    72.619   687.160     0.150
    74.566   700.000     0.150
    74.566   700.930     0.150
    74.598   699.000     0.150
    74.700   698.699     0.150
    77.407   716.500     0.150
    77.407   716.824     0.150
    77.514   717.301     0.150
    77.678   717.398     0.150
    77.764   722.398     0.150
    77.831   719.000     0.150
    78.103   721.602     0.150
    78.103   730.898     0.150
    78.103   898.102     0.150
    78.103  1313.898     0.150
    78.103  1331.398     0.150
    78.103  1338.301     0.150
    78.103  1616.699     0.150
    79.447   727.898     0.150
    79.758   729.699     0.150
    79.878   730.199     0.150
    79.924   733.102     0.150
    80.651   734.801     0.150
    80.689   735.000     0.150
    80.935   738.500     0.150
    80.943   736.199     0.150
    81.033   735.199     0.150
    81.039   739.602     0.150
    81.243   736.500     0.150
    81.250   740.801     0.150
    81.502   737.898     0.150
    81.527   744.602     0.150
    81.543   739.176     0.150
    81.650   740.410     0.150
    81.987   745.301     0.150
    82.015   742.000     0.150
    82.148   742.699     0.150
    82.188   742.898     0.150
    82.309   743.641     0.150
    82.308   746.102     0.150
    82.341   746.398     0.150
    82.356   743.250     0.150
    82.363   744.500     0.150
    82.413   744.301     0.150
    82.426   744.211     0.150
    82.432   744.500     0.150
    82.508   747.500     0.150
    82.539   748.500     0.150
    82.697   749.301     0.150
    83.077   747.035     0.150
    83.078   749.301     0.150
    83.078   747.000     0.150
    83.078  1379.000     0.150
    83.437   746.398     0.150
    83.437  1374.301     0.150
    83.437  1383.602     0.150
    83.524   751.324     0.150
    83.605   750.398     0.150
    83.637   750.301     0.150
    83.726   751.199     0.150
    83.790   751.500     0.150
    83.792   751.199     0.150
    83.798   751.398     0.150
    83.799   751.301     0.150
    83.840   751.699     0.150
    83.897   752.199     0.150
    83.899   751.500     0.150
    83.910   751.898     0.150
    84.135   751.102     0.150
    84.247   753.199     0.150
    84.293   753.176     0.150
    84.304   754.602     0.150
    84.451   754.398     0.150
    84.577   755.199     0.150
    84.729   756.000     0.150
    84.743   756.102     0.150
    84.823   755.301     0.150
    84.953   757.000     0.150
    85.208   757.699     0.150
    85.223   758.000     0.150
    85.223   761.699     0.150
    85.223  1389.000     0.150
    85.223     3.699     0.150
    85.223  1439.000     0.150
    85.223  1719.000     0.150
    85.301   762.301     0.150
    85.301   758.480     0.150
    85.408   759.602     0.150
    85.572   760.301     0.150
    85.648   761.301     0.150
    85.881   761.898     0.150
    85.942   762.012     0.150
    85.942  1399.000     0.150
    85.974   762.500     0.150
    86.464  1399.301     0.150
    86.489   765.102     0.150
    86.512   765.500     0.150
    86.755  1406.500     0.150
    86.778   766.438     0.150
    86.862   768.398     0.150
    86.862  1401.000     0.150
    86.920   766.102     0.150
    86.954   767.500     0.150
    87.047   768.887     0.150
    87.057   767.398     0.150
    87.074   769.301     0.150
    87.098   768.199     0.150
    87.098  1408.000     0.150
    87.322   770.500     0.150
    87.322  1411.500     0.150
    87.367   768.750     0.150
    87.371   770.074     0.150
    87.722   773.301     0.150
    87.789   773.000     0.150
    87.789  1414.199     0.150
    87.802   770.398     0.150
    87.887   770.801     0.150
    88.001   772.199     0.150
    88.298   775.199     0.150
    88.457   775.398     0.150
    89.048   779.551     0.150
    89.048   779.602     0.150
    89.727   780.301     0.150
    89.727  1408.602     0.150
    89.727  1792.102     0.150
    89.797   782.898     0.150
    90.002   781.602     0.150
    90.605   787.801     0.150
    90.787   787.801     0.150
    90.963   786.602     0.150
    90.963   997.898     0.150
    91.554   791.301     0.150
    91.554  1421.301     0.150
    91.690   791.199     0.150
    91.690   787.523     0.150
    91.691   788.102     0.150
    91.703   791.602     0.150
    91.846   788.801     0.150
    91.846  1005.699     0.150
    91.980   791.102     0.150
    92.445   792.102     0.150
    93.758   795.699     0.150
    93.758  1463.801     0.150
    93.758  1842.199     0.150
    95.403  1441.398     0.150
    95.403  1482.102     0.150
    98.136   816.102     0.150
    99.430   823.898     0.150
   101.572   834.000     0.150
   102.800   836.301     0.150
   102.800   839.602     0.150
   102.800  1091.500     0.150
   102.800  1474.000     0.150
   102.800  1533.199     0.150
   104.757  1795.477     0.150
   107.873  1542.801     0.150
   109.274   865.801     0.150
   109.274  1109.000     0.150
   109.274  1141.398     0.150
   109.274  2056.301     0.150
   112.416  1116.500     0.150
   113.194   883.000     0.150
   113.194  1165.102     0.150
   113.194  1627.801     0.150
   117.214  1127.398     0.150
   117.228  1126.523     0.150
   119.202  1130.750     0.150
   119.889  1133.102     0.150
   142.780  1172.199     0.150
   144.555  1174.715     0.150
   145.063  1178.398     0.150
   145.911  1181.801     0.150
   145.911  1182.301     0.150
     0.134     2.853     0.150
     0.134     5.643     0.150
     0.134     3.073     0.150
     0.134     6.203     0.150
     0.188     4.153     0.150
     0.188     6.493     0.150
     0.332     6.103     0.150
     0.332    11.293     0.150
     0.454     8.413     0.150
     0.507     9.743     0.150
     0.503     9.743     0.150
     0.546     9.743     0.150
     0.603    11.203     0.150
     0.603    10.743     0.150
     0.604    11.603     0.150
     0.604    19.993     0.150
     0.663    12.073     0.150
     0.663    21.203     0.150
     0.663    23.073     0.150
     0.723    11.743     0.150
     0.723    22.743     0.150
     0.752    12.743     0.150
     0.734    12.903     0.150
     0.734    22.713     0.150
     0.734    12.743     0.150
     0.751    12.743     0.150
     0.848    14.743     0.150
     0.883    15.169     0.150
     0.883    26.641     0.150
     0.883    14.743     0.150
     0.883    25.743     0.150
     0.896    15.743     0.150
     0.896    26.743     0.150
     0.872    15.633     0.150
     0.872    27.743     0.150
     0.948    16.743     0.150
     1.059    18.480     0.150
     1.059    32.630     0.150
     1.120    17.743     0.150
     1.086    19.773     0.150
     1.086    33.833     0.150
     1.086    34.853     0.150
     1.091    20.013     0.150
     1.091    34.613     0.150
     1.155    19.743     0.150
     1.155    35.743     0.150
     1.214    19.743     0.150
     1.217    22.103     0.150
     1.217    38.343     0.150
     1.252    22.303     0.150
     1.252    38.383     0.150
     1.252    39.393     0.150
     1.253    22.343     0.150
     1.302    20.743     0.150
     1.270    22.833     0.150
     1.270    39.873     0.150
     1.353    22.117     0.150
     1.353    38.627     0.150
     1.370    22.743     0.150
     1.441    23.823     0.150
     1.441    41.152     0.150
     1.570    26.136     0.150
     1.570    47.888     0.150
     1.592    25.593     0.150
     1.592    49.433     0.150
     1.592    44.722     0.150
     1.616    25.965     0.150
     1.774    28.035     0.150
     1.863    29.286     0.150
     2.002    31.405     0.150
     2.002    61.357     0.150
     2.207    34.079     0.150
     2.207    60.615     0.150
     2.252    67.730     0.150
     2.308    35.869     0.150
     2.489    38.134     0.150
     2.578    39.478     0.150
     2.717    82.101     0.150
     2.756    83.650     0.150
     2.780    42.682     0.150
     2.780    83.911     0.150
     2.824    84.921     0.150
    10.496   151.568     0.150
    10.496   333.368     0.150
    37.822   436.880     0.150
     0.213     3.703     0.150
     0.213     7.424     0.150
     0.227     4.533     0.150
     0.240     4.744     0.150
     0.240     6.984     0.150
     0.571    10.584     0.150
     0.588    11.904     0.150
     0.588    20.123     0.150
     0.692    12.293     0.150
     0.683    12.404     0.150
     0.751    13.064     0.150
     0.752    12.664     0.150
     0.752    23.434     0.150
     0.741    13.135     0.150
     0.761    13.924     0.150
     0.761    24.264     0.150
     0.854    14.402     0.150
     0.854    26.576     0.150
     0.955    15.867     0.150
     0.955    29.088     0.150
     0.955    27.604     0.150
     1.054    19.523     0.150
     1.148    20.895     0.150
     1.148    35.744     0.150
     1.148    20.904     0.150
     1.148    39.334     0.150
     1.148    36.543     0.150
     1.144    20.305     0.150
     1.144    35.465     0.150
     1.144    20.514     0.150
     1.144    36.014     0.150
     1.163    19.816     0.150
     1.163    35.502     0.150
     1.209    21.975     0.150
     1.274    22.824     0.150
     1.435    23.430     0.150
     1.435    40.668     0.150
     1.465    23.482     0.150
     1.694    26.719     0.150
     1.694    51.758     0.150
     1.660    27.217     0.150
     1.660    50.814     0.150
     1.710    27.055     0.150
     1.710    52.652     0.150
     1.710    26.904     0.150
     1.710    52.914     0.150
     1.892    29.318     0.150
     1.967    30.746     0.150
     2.144    32.977     0.150
     2.144    58.152     0.150
     2.144    32.805     0.150
     2.112    32.967     0.150
     2.112    65.020     0.150
     2.318    35.926     0.150
     2.318    62.412     0.150
     2.328    35.902     0.150
     2.328    70.539     0.150
     2.463    38.084     0.150
     2.612    40.252     0.150
     2.612    79.084     0.150
     2.602    39.631     0.150
     2.830    85.963     0.150
     2.834    85.611     0.150
     2.872    87.066     0.150
     2.924    88.727     0.150
     3.062    48.283     0.150
     3.062    94.334     0.150
     3.109    93.684     0.150
     3.257    98.453     0.150
     3.490   105.539     0.150
     3.733    55.574     0.150
     3.846    56.305     0.150
     3.846   118.074     0.150
     4.306    64.854     0.150
     4.343    64.014     0.150
     4.489    66.193     0.150
     4.668    70.404     0.150
     4.808    73.055     0.150
     5.497    81.465     0.150
     5.584    83.494     0.150
     5.794    86.033     0.150
     5.800   108.895     0.150
     6.074    90.453     0.150
     6.148    90.543     0.150
     6.386    92.754     0.150
     6.685   124.430     0.150
     6.791   103.305     0.150
     7.270   105.994     0.150
     7.525   111.293     0.150
     7.580   109.645     0.150
     7.891   114.703     0.150
     7.891   245.283     0.150
     7.891   114.055     0.150
     7.931   117.164     0.150
     8.105   119.283     0.150
     8.461   121.604     0.150
     8.537   123.404     0.150
     8.537   160.229     0.150
     8.537   265.859     0.150
     8.537   123.514     0.150
     8.902   129.754     0.150
     9.727   142.594     0.150
    10.422   150.680     0.150
    10.422   263.805     0.150
    10.422   327.037     0.150
    10.677   155.314     0.150
    10.925   158.994     0.150
    11.202   164.332     0.150
    11.503   165.104     0.150
    11.918   174.264     0.150
    16.113   228.305     0.150
    23.107   305.578     0.150
    37.942   438.154     0.150
     0.157     2.719     0.150
     0.157     5.227     0.150
     0.304     5.922     0.150
     0.304    10.500     0.150
     0.626    11.281     0.150
     0.593    11.289     0.150
     0.649    11.773     0.150
     0.682    12.062     0.150
     0.682    21.867     0.150
     0.682    23.703     0.150
     0.762    13.133     0.150
     0.762    23.594     0.150
     0.774    13.141     0.150
     0.754    13.203     0.150
     0.794    14.031     0.150
     0.843    15.203     0.150
     0.843    27.273     0.150
     0.903    15.148     0.150
     0.903    27.258     0.150
     0.903    15.047     0.150
     1.081    18.789     0.150
     1.081    32.852     0.150
     1.095    19.820     0.150
     1.095    34.992     0.150
     1.076    19.742     0.150
     1.076    34.430     0.150
     1.172    20.148     0.150
     1.172    36.102     0.150
     1.209    21.977     0.150
     1.209    38.109     0.150
     1.225    21.906     0.150
     1.225    38.289     0.150
     1.225    21.930     0.150
     1.225    39.219     0.150
     1.225    40.820     0.150
     1.265    22.688     0.150
     1.265    39.828     0.150
     1.381    22.344     0.150
     1.381    39.461     0.150
     1.444    23.570     0.150
     1.444    41.133     0.150
     1.587    26.508     0.150
     1.587    48.625     0.150
     1.619    25.852     0.150
     1.619    49.898     0.150
     1.619    45.992     0.150
     1.638    25.922     0.150
     1.802    28.258     0.150
     1.890    29.664     0.150
     1.890    57.836     0.150
     2.026    32.016     0.150
     2.026    62.297     0.150
     2.196    33.750     0.150
     2.196    66.945     0.150
     2.196    33.523     0.150
     2.273    68.992     0.150
     2.315    36.008     0.150
     2.518    38.953     0.150
     2.568    39.695     0.150
     2.568    78.469     0.150
     2.590    39.836     0.150
     2.742    83.359     0.150
     2.798    43.461     0.150
     2.798    84.758     0.150
     2.976    48.531     0.150
     3.025    45.500     0.150
     3.025    92.047     0.150
     3.172    96.023     0.150
     3.249    50.094     0.150
     3.400   103.367     0.150
     3.885    57.461     0.150
     3.885   118.109     0.150
     4.252    63.172     0.150
     4.252   130.711     0.150
     4.398    65.094     0.150
     4.640    69.781     0.150
     5.489    82.000     0.150
     5.519    82.070     0.150
     5.727    84.523     0.150
     6.066    89.469     0.150
     6.066   112.641     0.150
     6.066   190.188     0.150
     6.422    93.742     0.150
     6.594   121.312     0.150
     6.731   100.562     0.150
     7.286   106.117     0.150
     7.500   110.750     0.150
     7.880   114.141     0.150
     7.900   116.125     0.150
     7.900   150.703     0.150
    10.482   151.297     0.150
    11.444   167.945     0.150
    37.851   437.000     0.150
   101.397   834.852     0.150
   101.397   839.250     0.150
   102.712   837.352     0.150
   102.712   840.547     0.150
   102.712   842.047     0.150
   102.712  1092.750     0.150
     0.220     4.164     0.150
     0.220     6.117     0.150
     0.226     4.133     0.150
     0.226     7.469     0.150
     0.206     3.055     0.150
     0.206     7.086     0.150
     0.592    10.984     0.150
     0.599    10.867     0.150
     0.629    11.945     0.150
     0.644    12.047     0.150
     0.678    12.117     0.150
     0.635    12.078     0.150
     0.635    20.859     0.150
     0.689    12.734     0.150
     0.706    12.477     0.150
     0.706    12.336     0.150
     0.719    12.812     0.150
     0.762    13.688     0.150
     0.742    12.758     0.150
     0.742    23.680     0.150
     0.813    13.758     0.150
     0.817    13.336     0.150
     0.801    14.484     0.150
     0.801    25.156     0.150
     0.876    14.914     0.150
     0.876    27.375     0.150
     0.913    15.867     0.150
     0.931    15.617     0.150
     0.931    15.719     0.150
     0.931    28.289     0.150
     0.931    15.945     0.150
     0.970    16.469     0.150
     1.034    17.844     0.150
     1.092    18.992     0.150
     1.095    20.008     0.150
     1.095    35.312     0.150
     1.158    20.906     0.150
     1.158    35.625     0.150
     1.158    37.508     0.150
     1.158    20.977     0.150
     1.158    38.242     0.150
     1.158    39.617     0.150
     1.158    35.484     0.150
     1.201    20.844     0.150
     1.201    36.781     0.150
     1.193    21.273     0.150
     1.193    36.516     0.150
     1.193    37.055     0.150
     1.246    19.844     0.150
     1.255    22.594     0.150
     1.255    40.195     0.150
     1.286    22.633     0.150
     1.286    39.367     0.150
     1.286   934.289     0.150
     1.352    21.633     0.150
     1.322    23.547     0.150
     1.322    41.562     0.150
     1.388    22.930     0.150
     1.388    40.961     0.150
     1.447    23.883     0.150
     1.466    23.805     0.150
     1.466    42.625     0.150
     1.507    24.180     0.150
     1.565    24.617     0.150
     1.628    26.898     0.150
     1.672    30.383     0.150
     1.672    26.609     0.150
     1.655    27.234     0.150
     1.703    28.234     0.150
     1.703    52.492     0.150
     1.703    28.305     0.150
     1.719    27.586     0.150
     1.735    27.609     0.150
     1.735    53.688     0.150
     1.735    53.320     0.150
     1.735    27.258     0.150
     1.735    48.367     0.150
     1.768    28.445     0.150
     1.775    28.789     0.150
     1.775    32.375     0.150
     1.788    28.836     0.150
     1.846    29.547     0.150
     1.904    29.906     0.150
     1.961    30.750     0.150
     1.961    30.930     0.150
     2.017    31.555     0.150
     2.058    32.406     0.150
     2.058    37.438     0.150
     2.058   936.484     0.150
     2.065    32.664     0.150
     2.095    32.398     0.150
     2.103    33.227     0.150
     2.147    34.055     0.150
     2.147    66.672     0.150
     2.273    35.102     0.150
     2.304    35.859     0.150
     2.439    38.023     0.150
     2.487    38.867     0.150
     2.573    39.695     0.150
     2.605    39.984     0.150
     2.623    40.242     0.150
     2.777    42.219     0.150
     2.862    43.664     0.150
     2.862    87.039     0.150
     2.879    44.805     0.150
     2.879    53.695     0.150
     2.863    44.664     0.150
     2.863    51.445     0.150
     2.881    43.820     0.150
     2.915    44.977     0.150
     2.964    51.234     0.150
     3.096    54.469     0.150
     3.117    46.961     0.150
     3.126    48.812     0.150
     3.145    51.516     0.150
     3.145    95.398     0.150
     3.280    49.398     0.150
     3.293    56.609     0.150
     3.356    50.742     0.150
     3.419    60.328     0.150
     3.519    52.828     0.150
     3.769    57.477     0.150
     3.769    65.977     0.150
     3.790    56.875     0.150
     3.796    55.398     0.150
     3.796    72.398     0.150
     3.796   118.578     0.150
     3.893    58.977     0.150
     4.086    61.781     0.150
     4.172    63.133     0.150
     4.273    64.031     0.150
     4.302    64.758     0.150
     4.302    81.398     0.150
     4.370    65.156     0.150
     4.370    64.938     0.150
     4.370    80.625     0.150
     4.507    67.148     0.150
     4.507    84.484     0.150
     4.631    70.039     0.150
     4.631    70.688     0.150
     4.813    71.125     0.150
     4.813    72.609     0.150
     4.887    73.789     0.150
     5.022    76.406     0.150
     5.065    76.078     0.150
     5.159    76.070     0.150
     5.215    77.875     0.150
     5.376    80.688     0.150
     5.369    81.328     0.150
     5.454    81.453     0.150
     5.454    81.688     0.150
     5.567    83.047     0.150
     5.778    85.688     0.150
     6.083    89.859     0.150
     6.147    90.086     0.150
     6.336    92.008     0.150
     6.497    95.016     0.150
     6.497   167.086     0.150
     6.770    99.477     0.150
     6.814   100.984     0.150
     7.149   104.516     0.150
     7.159   104.789     0.150
     7.180   103.219     0.150
     7.222   105.258     0.150
     7.244   105.758     0.150
     7.486   109.836     0.150
     7.486   110.516     0.150
     7.498   109.312     0.150
     7.531   109.914     0.150
     7.741   115.805     0.150
     7.815   144.477     0.150
     7.844   114.734     0.150
     7.844   244.836     0.150
     7.844   114.453     0.150
     7.905   117.383     0.150
     7.994   117.867     0.150
     8.038   119.484     0.150
     8.162   119.273     0.150
     8.226   120.188     0.150
     8.338   123.180     0.150
     8.371   123.117     0.150
     8.412   120.883     0.150
     8.534   124.758     0.150
     8.534   162.211     0.150
     8.534   265.336     0.150
     8.534   123.594     0.150
     8.534   161.578     0.150
     8.815   129.969     0.150
     8.862   129.086     0.150
     8.897   128.664     0.150
     8.940   130.969     0.150
     9.169   134.852     0.150
     9.236   132.445     0.150
     9.428   134.867     0.150
     9.691   141.914     0.150
     9.735   141.305     0.150
     9.743   139.648     0.150
     9.772   142.086     0.150
     9.849   143.125     0.150
    10.205   148.758     0.150
    10.374   150.055     0.150
    10.374   150.062     0.150
    10.425   147.469     0.150
    10.491   155.016     0.150
    10.628   155.125     0.150
    10.888   158.914     0.150
    11.056   159.062     0.150
    11.211   159.609     0.150
    11.224   164.578     0.150
    11.224   163.789     0.150
    11.369   164.719     0.150
    11.481   167.867     0.150
    11.481   164.867     0.150
    11.481   365.383     0.150
    11.481   164.867     0.150
    11.481   365.383     0.150
    11.647   166.062     0.150
    11.680   167.703     0.150
    11.778   169.938     0.150
    11.902   172.312     0.150
    11.975   170.969     0.150
    12.053   171.156     0.150
    12.398   178.695     0.150
    12.722   181.984     0.150
    12.900   185.805     0.150
    12.900   324.688     0.150
    13.208   189.297     0.150
    13.328   192.438     0.150
    13.389   193.508     0.150
    13.591   195.734     0.150
    13.726   197.117     0.150
    13.782   195.734     0.150
    13.852   197.375     0.150
    13.875   196.531     0.150
    14.105   207.273     0.150
    14.472   207.812     0.150
    14.556   209.797     0.150
    14.568   210.625     0.150
    14.651   208.609     0.150
    14.736   212.617     0.150
    14.759   209.180     0.150
    14.774   211.359     0.150
    14.782   211.406     0.150
    14.792   209.594     0.150
    14.806   210.414     0.150
    15.090   214.094     0.150
    15.106   214.953     0.150
    15.157   213.867     0.150
    15.381   217.180     0.150
    15.405   219.867     0.150
    15.602   222.984     0.150
    15.834   223.875     0.150
    15.869   226.523     0.150
    16.053   225.969     0.150
    16.114   228.336     0.150
    16.114   227.523     0.150
    16.290   406.578     0.150
    16.290   518.164     0.150
    16.290   738.375     0.150
    16.309   525.594     0.150
    16.309   736.242     0.150
    16.309   957.312     0.150
    16.438   231.289     0.150
    16.556   231.133     0.150
    16.798   234.359     0.150
    16.878   235.680     0.150
    17.562   242.484     0.150
    18.263   252.289     0.150
    18.633   256.875     0.150
    21.740   290.312     0.150
    21.767   292.133     0.150
    22.455   299.039     0.150
    23.005   304.406     0.150
    23.077   305.789     0.150
    24.416   318.727     0.150
    28.092   353.664     0.150
    28.092   351.938     0.150
    30.318   371.070     0.150
    30.318   371.062     0.150
    37.668   435.156     0.150
    37.957   439.688     0.150
    37.957   437.805     0.150
    40.945   462.969     0.150
    77.417   716.023     0.150
    77.417   716.031     0.150
    81.555   738.938     0.150
    81.555  1370.094     0.150
    81.555   738.938     0.150
    84.293   752.664     0.150
    92.005   792.797     0.150
    95.429   803.039     0.150
    95.429  1035.734     0.150
    95.429  1436.938     0.150
    95.429  1474.938     0.150
    98.163   816.836     0.150
   101.499   830.133     0.150
   101.499   834.836     0.150
   101.499   837.336     0.150
   102.826   834.336     0.150
   102.826  1090.438     0.150
   102.826  1472.539     0.150
   102.826  1531.336     0.150
   107.167   855.539     0.150
   107.167  1124.734     0.150
   107.167  1573.234     0.150
   107.894  1542.633     0.150
     0.031     1.738     0.150
     0.136     3.000     0.150
     0.203     4.020     0.150
     0.271     5.418     0.150
     0.271     9.051     0.150
     0.298     5.262     0.150
     0.298     9.211     0.150
     0.295     5.359     0.150
     0.450     9.078     0.150
     0.450    16.520     0.150
     0.533    10.680     0.150
     0.533    17.648     0.150
     0.580    10.770     0.150
     0.607    11.133     0.150
     0.607    18.973     0.150
     0.734    13.609     0.150
     0.734    23.520     0.150
     0.792    13.988     0.150
     0.792    24.891     0.150
     0.769    14.039     0.150
     0.769    24.031     0.150
     0.832    15.668     0.150
     0.832    26.480     0.150
     0.832    26.371     0.150
     0.884    15.242     0.150
     0.884    26.523     0.150
     0.884    26.949     0.150
     1.037    17.496     0.150
     1.125    18.938     0.150
     1.125    32.684     0.150
     1.125    18.801     0.150
     1.157    20.109     0.150
     1.157    35.176     0.150
     1.211    22.250     0.150
     1.211    38.230     0.150
     1.216    22.230     0.150
     1.216    38.051     0.150
     1.218    22.309     0.150
     1.218    37.988     0.150
     1.319    22.500     0.150
     1.319    40.730     0.150
     1.363    22.293     0.150
     1.512    24.395     0.150
     1.533    24.812     0.150
     1.533    46.789     0.150
     1.591    25.699     0.150
     1.617    27.750     0.150
     1.617    49.109     0.150
     1.617    28.438     0.150
     1.617    50.980     0.150
     1.618    28.430     0.150
     1.618    51.531     0.150
     1.618    27.039     0.150
     1.686    27.105     0.150
     1.686    48.441     0.150
     1.879    30.418     0.150
     1.879    57.203     0.150
     2.135    33.582     0.150
     2.133    33.273     0.150
     2.228    34.613     0.150
     2.243    35.094     0.150
     2.243    67.594     0.150
     2.319    36.312     0.150
     2.352    35.992     0.150
     2.352    70.812     0.150
     2.369    36.723     0.150
     2.374    36.344     0.150
     2.448    37.656     0.150
     2.448    74.992     0.150
     2.471    38.031     0.150
     2.484    39.418     0.150
     2.533    41.668     0.150
     2.533    75.359     0.150
     2.592    39.227     0.150
     2.643    40.633     0.150
     2.681    45.543     0.150
     2.681    80.590     0.150
     2.784    42.465     0.150
     2.785    42.551     0.150
     2.785    42.309     0.150
     2.900    44.645     0.150
     2.901    44.285     0.150
     2.901    87.699     0.150
     3.155    53.090     0.150
     3.155    94.574     0.150
     3.155    48.188     0.150
     3.510    52.375     0.150
     3.553    53.555     0.150
     3.689    55.203     0.150
     3.755    56.082     0.150
     3.755    56.398     0.150
     3.880    58.590     0.150
     3.880   121.328     0.150
     3.924    58.570     0.150
     4.017    60.113     0.150
     4.220    61.660     0.150
     4.220   109.371     0.150
     4.209    62.441     0.150
     4.309    64.605     0.150
     4.410    65.590     0.150
     4.534    67.684     0.150
     4.631    69.730     0.150
     4.631    70.000     0.150
     4.631   122.340     0.150
     4.735    71.238     0.150
     5.200    77.070     0.150
     5.271    78.918     0.150
     5.271   167.871     0.150
     5.469    81.160     0.150
     5.545    82.328     0.150
     5.584    83.184     0.150
     5.584   177.348     0.150
     5.649    82.250     0.150
     5.690    83.625     0.150
     5.690    83.730     0.150
     5.690   180.078     0.150
     6.092    89.699     0.150
     6.129    90.086     0.150
     6.227    90.430     0.150
     6.519    97.000     0.150
     6.565    97.270     0.150
     6.565   207.340     0.150
     6.569    96.301     0.150
     6.733    97.984     0.150
     6.733    97.648     0.150
     7.410   108.059     0.150
     7.502   109.059     0.150
     7.501   111.391     0.150
     7.591   112.430     0.150
     7.722   113.801     0.150
     7.856   113.188     0.150
     7.875   112.910     0.150
     7.897   114.176     0.150
     7.897   113.668     0.150
     8.026   117.711     0.150
     8.026   204.648     0.150
     8.077   117.266     0.150
     8.077   250.262     0.150
     8.077   117.621     0.150
     8.077   253.168     0.150
     8.070   118.750     0.150
     8.092   117.516     0.150
     8.092   150.711     0.150
     8.546   124.020     0.150
     8.554   124.680     0.150
     8.650   125.738     0.150
     8.850   126.715     0.150
     8.903   130.090     0.150
     9.111   132.797     0.150
     9.143   134.438     0.150
     9.427   137.125     0.150
     9.420   135.801     0.150
     9.446   137.199     0.150
     9.598   139.578     0.150
     9.617   139.867     0.150
     9.617   140.758     0.150
     9.759   141.375     0.150
     9.811   142.301     0.150
     9.814   141.699     0.150
     9.968   144.441     0.150
    10.049   144.762     0.150
    10.086   145.078     0.150
    10.142   145.648     0.150
    10.320   148.840     0.150
    10.341   149.000     0.150
    10.400   149.695     0.150
    10.466   151.129     0.150
    10.532   151.727     0.150
    10.547   151.688     0.150
    10.594   152.594     0.150
    10.622   156.844     0.150
    10.671   153.234     0.150
    10.751   156.758     0.150
    10.853   155.270     0.150
    10.862   156.473     0.150
    10.862   158.250     0.150
    10.892   156.184     0.150
    10.892   344.375     0.150
    10.941   158.328     0.150
    10.950   157.852     0.150
    10.950   157.570     0.150
    10.948   157.816     0.150
    10.948   157.160     0.150
    10.962   157.691     0.150
    11.039   159.059     0.150
    11.133   159.023     0.150
    11.149   158.199     0.150
    11.195   160.504     0.150
    11.217   160.230     0.150
    11.228   162.051     0.150
    11.228   160.531     0.150
    11.244   159.582     0.150
    11.254   160.551     0.150
    11.313   161.852     0.150
    11.382   162.703     0.150
    11.382   162.266     0.150
    11.395   162.469     0.150
    11.467   164.066     0.150
    11.511   164.688     0.150
    11.580   165.605     0.150
    11.716   167.715     0.150
    11.744   167.660     0.150
    11.749   167.898     0.150
    11.825   168.969     0.150
    11.825   169.336     0.150
    11.842   169.867     0.150
    11.842   170.117     0.150
    11.859   170.699     0.150
    11.869   170.715     0.150
    11.900   171.457     0.150
    11.929   171.215     0.150
    11.929   171.828     0.150
    11.942   170.688     0.150
    11.968   172.504     0.150
    11.965   173.086     0.150
    11.987   172.102     0.150
    11.991   171.762     0.150
    12.027   171.980     0.150
    12.060   173.320     0.150
    12.174   174.289     0.150
    12.213   176.453     0.150
    12.275   177.297     0.150
    12.308   175.547     0.150
    12.289   175.293     0.150
    12.372   177.793     0.150
    12.371   176.773     0.150
    12.371   174.789     0.150
    12.372   178.125     0.150
    12.371   181.879     0.150
    12.392   179.426     0.150
    12.408   179.352     0.150
    12.424   177.406     0.150
    12.442   176.926     0.150
    12.477   177.887     0.150
    12.458   178.805     0.150
    12.503   179.797     0.150
    12.507   178.484     0.150
    12.524   180.152     0.150
    12.543   177.703     0.150
    12.550   179.902     0.150
    12.573   179.512     0.150
    12.570   181.031     0.150
    12.623   182.301     0.150
    12.688   181.711     0.150
    12.704   182.012     0.150
    12.724   182.551     0.150
    12.769   182.879     0.150
    12.858   183.875     0.150
    12.881   184.453     0.150
    12.915   184.379     0.150
    12.956   184.633     0.150
    12.969   185.180     0.150
    12.973   185.445     0.150
    12.980   183.781     0.150
    13.034   186.191     0.150
    13.038   186.855     0.150
    13.058   187.367     0.150
    13.090   186.898     0.150
    13.089   186.395     0.150
    13.112   188.016     0.150
    13.132   187.539     0.150
    13.231   188.590     0.150
    13.280   189.758     0.150
    13.300   190.125     0.150
    13.293   191.055     0.150
    13.373   191.730     0.150
    13.380   191.844     0.150
    13.416   191.676     0.150
    13.436   190.848     0.150
    13.517   190.875     0.150
    13.587   192.918     0.150
    13.587   192.281     0.150
    13.636   193.309     0.150
    13.654   194.609     0.150
    13.660   192.883     0.150
    13.689   193.969     0.150
    13.703   195.406     0.150
    13.716   195.480     0.150
    13.778   196.359     0.150
    13.780   196.898     0.150
    13.780   194.988     0.150
    13.811   197.512     0.150
    13.850   197.652     0.150
    13.860   197.641     0.150
    13.943   198.234     0.150
    14.029   202.898     0.150
    14.045   200.766     0.150
    14.137   201.855     0.150
    14.200   201.684     0.150
    14.197   202.188     0.150
    14.210   202.508     0.150
    14.232   201.957     0.150
    14.274   202.180     0.150
    14.287   202.957     0.150
    14.293   199.598     0.150
    14.291   203.141     0.150
    14.298   203.418     0.150
    14.303   203.449     0.150
    14.320   203.699     0.150
    14.372   203.238     0.150
    14.365   206.531     0.150
    14.377   207.188     0.150
    14.394   204.715     0.150
    14.513   205.898     0.150
    14.522   207.012     0.150
    14.568   207.773     0.150
    14.579   207.641     0.150
    14.591   209.676     0.150
    14.660   209.387     0.150
    14.670   208.520     0.150
    14.679   210.840     0.150
    14.698   207.180     0.150
    14.700   209.723     0.150
    14.754   210.168     0.150
    14.799   210.512     0.150
    14.797   210.887     0.150
    14.891   210.836     0.150
    14.898   210.602     0.150
    14.907   210.984     0.150
    14.907   213.062     0.150
    14.919   210.852     0.150
    14.931   211.469     0.150
    14.994   211.625     0.150
    15.000   212.742     0.150
    15.003   212.707     0.150
    15.023   211.680     0.150
    15.026   211.809     0.150
    15.025   213.453     0.150
    15.066   214.055     0.150
    15.119   214.738     0.150
    15.154   215.535     0.150
    15.154   214.281     0.150
    15.251   215.832     0.150
    15.307   217.145     0.150
    15.410   217.410     0.150
    15.420   217.227     0.150
    15.420   216.781     0.150
    15.471   219.000     0.150
    15.487   218.832     0.150
    15.494   218.371     0.150
    15.494   219.188     0.150
    15.502   219.266     0.150
    15.518   219.609     0.150
    15.550   219.562     0.150
    15.555   220.742     0.150
    15.583   220.836     0.150
    15.624   220.820     0.150
    15.633   221.688     0.150
    15.633   222.199     0.150
    15.633   222.488     0.150
    15.648   221.910     0.150
    15.696   221.598     0.150
    15.740   221.969     0.150
    15.761   221.312     0.150
    15.762   223.195     0.150
    15.805   223.504     0.150
    15.810   221.449     0.150
    15.879   223.672     0.150
    15.907   223.746     0.150
    15.962   224.676     0.150
    16.019   224.949     0.150
    16.018   227.082     0.150
    16.018   227.891     0.150
    16.058   226.477     0.150
    16.084   227.016     0.150
    16.098   227.047     0.150
    16.159   228.875     0.150
    16.198   228.520     0.150
    16.213   229.785     0.150
    16.336   230.273     0.150
    16.435   231.281     0.150
    16.453   233.750     0.150
    16.583   233.480     0.150
    16.589   233.789     0.150
    16.606   234.270     0.150
    16.647   233.523     0.150
    16.667   232.742     0.150
    16.768   235.703     0.150
    16.807   236.840     0.150
    16.839   236.121     0.150
    16.926   238.395     0.150
    17.025   239.457     0.150
    17.087   239.879     0.150
    17.097   239.918     0.150
    17.130   240.078     0.150
    17.240   241.598     0.150
    17.244   243.031     0.150
    17.251   240.781     0.150
    17.286   241.750     0.150
    17.370   242.176     0.150
    17.397   242.629     0.150
    17.511   244.676     0.150
    17.548   244.605     0.150
    17.610   247.570     0.150
    17.921   250.438     0.150
    17.948   250.367     0.150
    18.049   251.668     0.150
    18.049   251.980     0.150
    18.276   254.965     0.150
    18.359   254.250     0.150
    18.531   257.457     0.150
    18.577   257.750     0.150
    18.585   256.883     0.150
    18.636   258.809     0.150
    18.636   259.410     0.150
    18.923   262.656     0.150
    19.403   267.812     0.150
    19.500   268.121     0.150
    19.589   269.152     0.150
    20.445   279.285     0.150
    20.637   279.668     0.150
    20.886   282.922     0.150
    21.491   292.492     0.150
    21.663   291.207     0.150
    21.663   290.668     0.150
    22.243   297.230     0.150
    22.933   303.688     0.150
    24.128   317.059     0.150
    27.323   345.570     0.150
    27.539   349.250     0.150
    29.871   369.082     0.150
    36.063   425.160     0.150
    37.381   435.332     0.150
    43.356   483.098     0.150
    55.403   574.988     0.150
    62.295   625.883     0.150
    62.674   629.359     0.150
    82.846   744.961     0.150
    91.937   792.258     0.150
    97.544   816.859     0.150
   100.943   831.859     0.150
   102.219   835.258     0.150
     0.125     2.297     0.150
     0.125     5.090     0.150
     0.125     2.449     0.150
     0.160     3.277     0.150
     0.160     5.680     0.150
     0.315     5.949     0.150
     0.315    10.598     0.150
     0.484     8.957     0.150
     0.633    12.328     0.150
     0.633    20.930     0.150
     0.594    10.719     0.150
     0.610    11.008     0.150
     0.645    11.699     0.150
     0.715    12.660     0.150
     0.701    12.719     0.150
     0.701    22.078     0.150
     0.759    13.027     0.150
     0.759    23.109     0.150
     0.855    14.797     0.150
     0.855    26.988     0.150
     0.867    14.594     0.150
     0.867    26.508     0.150
     1.116    20.566     0.150
     1.116    36.000     0.150
     1.096    18.855     0.150
     1.096    33.938     0.150
     1.127    20.250     0.150
     1.127    35.590     0.150
     1.127    20.598     0.150
     1.195    20.727     0.150
     1.195    36.816     0.150
     1.250    22.180     0.150
     1.250    38.410     0.150
     1.251    22.500     0.150
     1.251    42.637     0.150
     1.251    39.387     0.150
     1.249    22.637     0.150
     1.249    39.527     0.150
     1.305    23.367     0.150
     1.360    22.008     0.150
     1.405    23.094     0.150
     1.405    41.004     0.150
     1.609    26.277     0.150
     1.609    49.238     0.150
     1.603    25.527     0.150
     1.619    25.812     0.150
     1.619    50.090     0.150
     1.619    25.559     0.150
     1.790    28.496     0.150
     1.864    29.270     0.150
     2.036    31.934     0.150
     2.036    62.500     0.150
     2.166    33.375     0.150
     2.166    60.035     0.150
     2.166    66.500     0.150
     2.238    34.707     0.150
     2.238    67.184     0.150
     2.274    35.250     0.150
     2.498    38.188     0.150
     2.550    39.680     0.150
     2.663    40.812     0.150
     2.663    73.176     0.150
     2.748    42.371     0.150
     2.748    83.734     0.150
     2.796    83.086     0.150
     2.782    43.816     0.150
     2.782    55.340     0.150
     2.819    84.781     0.150
     2.862    85.871     0.150
     2.985    47.488     0.150
     2.985    52.688     0.150
     2.985    56.219     0.150
     3.036    48.660     0.150
     3.036    53.727     0.150
     3.036    57.000     0.150
     3.036    92.699     0.150
     3.046    83.043     0.150
     3.183    96.898     0.150
     3.658    55.059     0.150
     3.658    65.449     0.150
     3.851    56.840     0.150
     3.851    73.188     0.150
     3.851   115.988     0.150
     3.851   118.047     0.150
     4.203    63.207     0.150
     4.254    63.199     0.150
     4.391    66.430     0.150
     4.600    69.430     0.150
     5.448    81.066     0.150
     5.487    81.527     0.150
     5.696    85.137     0.150
     6.044    89.438     0.150
     6.387    93.410     0.150
     6.387   203.137     0.150
     6.543   123.840     0.150
     6.698    98.809     0.150
     7.043   105.828     0.150
     7.064   105.129     0.150
     7.248   105.750     0.150
     7.460   110.648     0.150
     7.747   117.598     0.150
     7.861   115.539     0.150
     7.861   115.000     0.150
     7.844   113.680     0.150
     8.033   118.418     0.150
     8.085   117.039     0.150
     8.434   123.090     0.150
     8.434   267.188     0.150
     8.810   126.938     0.150
     9.286   137.934     0.150
     9.685   139.918     0.150
     9.693   142.699     0.150
     9.770   140.457     0.150
    10.455   150.812     0.150
    10.455   328.238     0.150
    10.664   152.520     0.150
    10.976   158.410     0.150
    11.410   165.969     0.150
    11.410   168.539     0.150
    12.473   177.969     0.150
    15.151   211.930     0.150
    16.009   229.789     0.150
    16.009   228.637     0.150
    16.781   233.379     0.150
    18.298   252.527     0.150
    20.965   284.078     0.150
    21.722   291.477     0.150
    23.026   305.738     0.150
    30.218   371.484     0.150
    37.558   434.828     0.150
    37.842   438.988     0.150
    70.718   675.809     0.150
    91.630   790.312     0.150
    98.050   816.188     0.150
   107.786  1542.988     0.150
     0.030     0.848     0.150
     0.137     2.598     0.150
     0.200     3.859     0.150
     0.272     5.219     0.150
     0.272     9.488     0.150
     0.450     8.879     0.150
     0.450    15.059     0.150
     0.534    10.109     0.150
     0.534    20.047     0.150
     0.607    11.102     0.150
     0.607    18.871     0.150
     0.736    13.520     0.150
     0.736    23.559     0.150
     0.769    14.047     0.150
     0.769    24.020     0.150
     0.769    13.797     0.150
     0.793    13.977     0.150
     0.793    25.047     0.150
     0.834    15.598     0.150
     0.834    26.938     0.150
     0.834    26.078     0.150
     0.882    15.527     0.150
     0.882    27.758     0.150
     1.035    17.793     0.150
     1.035    30.801     0.150
     1.124    19.129     0.150
     1.124    33.629     0.150
     1.124    18.969     0.150
     1.124    33.977     0.150
     1.157    20.555     0.150
     1.157    35.492     0.150
     1.214    22.297     0.150
     1.214    38.758     0.150
     1.218    22.277     0.150
     1.218    38.668     0.150
     1.220    22.328     0.150
     1.220    38.949     0.150
     1.320    22.859     0.150
     1.320    40.727     0.150
     1.361    22.648     0.150
     1.361    41.355     0.150
     1.510    24.781     0.150
     1.532    25.418     0.150
     1.532    47.211     0.150
     1.589    25.914     0.150
     1.619    27.930     0.150
     1.619    51.449     0.150
     1.619    28.129     0.150
     1.619    49.637     0.150
     1.685    27.488     0.150
     1.685    48.551     0.150
     1.877    30.824     0.150
     1.877    57.254     0.150
     2.130    33.555     0.150
     2.225    34.844     0.150
     2.242    35.406     0.150
     2.242    67.895     0.150
     2.369    38.621     0.150
     2.369    68.379     0.150
     2.373    41.277     0.150
     2.470    38.398     0.150
     2.481    39.879     0.150
     2.480    40.758     0.150
     2.480    75.406     0.150
     2.532    43.199     0.150
     2.532    75.457     0.150
     2.592    39.668     0.150
     2.592    70.391     0.150
     2.592    39.547     0.150
     2.782    42.719     0.150
     2.900    44.688     0.150
     3.154    55.047     0.150
     3.154    95.598     0.150
     3.241    49.055     0.150
     3.687    55.191     0.150
     3.753    55.988     0.150
     3.753    56.617     0.150
     3.878    58.930     0.150
     3.922    58.809     0.150
     4.015    61.344     0.150
     4.307    64.434     0.150
     4.409    65.434     0.150
     4.532    67.461     0.150
     5.269    79.117     0.150
     5.466    81.359     0.150
     5.583    83.906     0.150
     5.583   145.547     0.150
     6.127    90.402     0.150
     6.127   109.754     0.150
     6.516    99.449     0.150
     6.733    98.266     0.150
     6.733    98.090     0.150
     7.500   110.559     0.150
     7.720   114.758     0.150
     7.720   245.527     0.150
     8.024   117.340     0.150
     8.075   118.203     0.150
     8.075   255.543     0.150
     8.090   121.402     0.150
     8.090   257.477     0.150
    10.892   156.680     0.150
    10.949   158.977     0.150
    15.631   224.078     0.150
    29.869   366.785     0.150
     0.144     3.461     0.150
     0.144     6.211     0.150
     0.277     6.023     0.150
     0.288     5.914     0.150
     0.288     9.281     0.150
     0.626    12.703     0.150
     0.626    21.969     0.150
     0.679    12.875     0.150
     0.679    22.422     0.150
     0.679    23.555     0.150
     0.770   938.391     0.150
     0.877    14.750     0.150
     0.846    26.695     0.150
     0.936    15.328     0.150
     0.936    15.500     0.150
     0.982    16.164     0.150
     0.982    27.727     0.150
     0.982    28.602     0.150
     1.100    19.641     0.150
     1.100    34.273     0.150
     1.100    21.453     0.150
     1.100    19.672     0.150
     1.100    32.492     0.150
     1.144    19.148     0.150
     1.215    38.961     0.150
     1.215    38.641     0.150
     1.215    20.789     0.150
     1.215    37.172     0.150
     1.250    20.984     0.150
     1.308    20.484     0.150
     1.360    20.250     0.150
     1.324    40.070     0.150
     1.402    22.625     0.150
     1.402    39.203     0.150
     1.414    22.203     0.150
     1.528    24.273     0.150
     1.549    24.781     0.150
     1.605    25.234     0.150
     1.628    30.289     0.150
     1.723    26.992     0.150
     1.699    27.594     0.150
     1.699    51.883     0.150
     1.743    28.367     0.150
     1.743    52.820     0.150
     1.743    28.703     0.150
     1.775    28.133     0.150
     1.794    27.969     0.150
     1.794    54.375     0.150
     1.794    28.078     0.150
     1.845    29.398     0.150
     1.902    30.070     0.150
     1.967    30.461     0.150
     2.021    31.359     0.150
     2.075    31.703     0.150
     2.075    63.430     0.150
     2.111    32.922     0.150
     2.111    65.102     0.150
     2.119    33.172     0.150
     2.119    65.000     0.150
     2.158    33.719     0.150
     2.158    66.109     0.150
     2.199    34.133     0.150
     2.293    35.312     0.150
     2.605    39.672     0.150
     2.680    40.414     0.150
     2.667    40.375     0.150
     2.765    84.812     0.150
     2.940    45.641     0.150
     2.916    44.445     0.150
     2.917    52.703     0.150
     2.955    45.281     0.150
     2.955    89.398     0.150
     3.169    46.867     0.150
     3.148    50.062     0.150
     3.148    88.805     0.150
     3.181    97.562     0.150
     3.196    51.320     0.150
     3.196    88.219     0.150
     3.820   113.656     0.150
     3.917   103.383     0.150
     4.875    73.172     0.150
     5.266    78.672     0.150
     6.255    93.523     0.150
     6.761   100.750     0.150
     6.761   126.469     0.150
     6.761   100.750     0.150
     6.761   126.469     0.150
     6.862   101.562     0.150
     7.156   104.578     0.150
     7.227   104.992     0.150
     7.502   109.094     0.150
     7.779   118.031     0.150
     7.854   113.148     0.150
     8.033   118.039     0.150
     8.216   157.672     0.150
     8.282   158.422     0.150
     8.595   125.672     0.150
     8.595   271.125     0.150
     8.595   163.484     0.150
     8.891   130.570     0.150
     9.727   142.430     0.150
    10.347   147.547     0.150
    10.630   157.125     0.150
    11.284   166.289     0.150
    11.483   169.922     0.150
    11.533   165.719     0.150
    11.533   165.719     0.150
    12.389   181.773     0.150
    13.653   198.344     0.150
    16.176   228.070     0.150
    28.155   351.672     0.150
    30.378   371.914     0.150
    37.731   435.945     0.150
    38.019   437.969     0.150
    81.609   738.125     0.150
     0.145     2.328     0.150
     0.145     5.215     0.150
     0.373     7.816     0.150
     0.415     8.406     0.150
     0.415    13.137     0.150
     0.573     9.805     0.150
     0.573    18.066     0.150
     0.683    12.016     0.150
     0.696    12.695     0.150
     0.738    14.516     0.150
     0.738    25.188     0.150
     0.816    14.305     0.150
     0.810    14.637     0.150
     1.026    17.191     0.150
     1.026    30.191     0.150
     1.026    31.105     0.150
     1.008    17.945     0.150
     1.008    32.027     0.150
     1.049    19.176     0.150
     1.049    34.027     0.150
     1.049    19.348     0.150
     1.049    32.285     0.150
     1.081    18.023     0.150
     1.081    32.172     0.150
     1.049    19.348     0.150
     1.049    36.426     0.150
     1.049    19.086     0.150
     1.049    32.277     0.150
     1.143    20.836     0.150
     1.143    37.008     0.150
     1.327    21.980     0.150
     1.327    38.754     0.150
     1.345    23.777     0.150
     1.345    42.457     0.150
     1.365    23.465     0.150
     1.365    41.836     0.150
     1.365    23.898     0.150
     1.365    43.508     0.150
     1.411    23.715     0.150
     1.411    43.156     0.150
     1.428    24.965     0.150
     1.428    44.648     0.150
     1.634    26.254     0.150
     1.634    46.285     0.150
     1.764    27.973     0.150
     1.904    30.922     0.150
     1.904    58.207     0.150
     1.933    30.004     0.150
     1.944    30.676     0.150
     2.095    32.527     0.150
     2.106    32.789     0.150
     2.231    34.875     0.150
     2.358    37.105     0.150
     2.386    37.008     0.150
     2.386    72.480     0.150
     2.572    39.570     0.150
     2.742    42.199     0.150
     2.773    42.352     0.150
     3.024    47.246     0.150
     3.073    47.281     0.150
     3.070    46.539     0.150
     3.116    47.629     0.150
     3.171    96.492     0.150
     3.205    48.379     0.150
     3.307    60.785     0.150
     3.453    51.676     0.150
     3.656    54.195     0.150
     4.449    67.527     0.150
     4.640    69.926     0.150
     4.984    74.477     0.150
     5.414    81.117     0.150
     5.671    84.738     0.150
     5.886    87.078     0.150
     6.200    89.586     0.150
     6.302    92.508     0.150
     6.857   104.625     0.150
     7.060   103.738     0.150
     7.126   103.477     0.150
     7.360   110.285     0.150
     7.437   109.027     0.150
     7.482   109.715     0.150
     7.764   112.727     0.150
     7.764   243.301     0.150
     7.891   114.848     0.150
     7.967   118.125     0.150
     8.085   119.258     0.150
     8.260   119.027     0.150
     8.337   123.137     0.150
     8.429   123.477     0.150
     8.682   126.328     0.150
     8.682   220.301     0.150
     8.682   274.125     0.150
     8.847   129.695     0.150
     9.014   130.867     0.150
     9.703   142.367     0.150
     9.949   143.695     0.150
    10.195   147.000     0.150
    10.195   322.152     0.150
    10.515   155.086     0.150
    10.683   158.195     0.150
    10.894   158.008     0.150
    11.365   167.516     0.150
    11.427   168.945     0.150
    11.509   167.266     0.150
    11.546   168.527     0.150
    11.564   167.227     0.150
    11.781   171.867     0.150
    11.881   172.586     0.150
    12.006   175.238     0.150
    12.075   176.738     0.150
    12.501   181.605     0.150
    12.578   180.945     0.150
    13.073   188.035     0.150
    13.885   200.148     0.150
    13.907   202.465     0.150
    14.915   211.258     0.150
    14.959   212.855     0.150
    15.062   214.695     0.150
    15.467   222.727     0.150
    15.567   222.867     0.150
    15.694   228.715     0.150
    16.273   230.801     0.150
    16.465   231.207     0.150
    17.018   240.848     0.150
    18.151   250.598     0.150
    18.626   260.195     0.150
    21.201   285.816     0.150
    21.928   294.457     0.150
    22.906   305.066     0.150
    22.941   305.355     0.150
    23.586   311.820     0.150
    24.282   318.676     0.150
    26.194   336.652     0.150
    28.277   355.902     0.150
    30.464   373.773     0.150
    30.464   552.371     0.150
    37.842   438.953     0.150
    38.150   441.578     0.150
    41.140   466.316     0.150
     0.153     2.312     0.150
     0.153     5.094     0.150
     0.356     7.324     0.150
     0.399     7.926     0.150
     0.399    13.305     0.150
     0.399     7.785     0.150
     0.590    10.195     0.150
     0.590    18.555     0.150
     0.670    11.926     0.150
     0.741    14.062     0.150
     0.741    24.535     0.150
     0.798    13.996     0.150
     0.797    14.113     0.150
     0.911    15.363     0.150
     0.918    15.984     0.150
     0.953    16.473     0.150
     1.009    16.914     0.150
     0.998    17.703     0.150
     0.998    31.523     0.150
     1.065    20.344     0.150
     1.065    35.145     0.150
     1.065    19.445     0.150
     1.065    34.465     0.150
     1.065    19.426     0.150
     1.065    34.516     0.150
     1.065    36.473     0.150
     1.041    18.988     0.150
     1.041    32.723     0.150
     1.067    17.629     0.150
     1.151    20.715     0.150
     1.151    36.805     0.150
     1.318    21.738     0.150
     1.318    37.801     0.150
     1.349    23.875     0.150
     1.349    42.766     0.150
     1.361    23.633     0.150
     1.361    42.895     0.150
     1.361    43.184     0.150
     1.400    23.590     0.150
     1.400    43.457     0.150
     1.432    24.953     0.150
     1.432    44.945     0.150
     1.617    25.828     0.150
     1.747    27.789     0.150
     1.934    30.086     0.150
     1.934    57.004     0.150
     1.929    30.168     0.150
     1.929    30.324     0.150
     2.089    32.598     0.150
     2.079    32.426     0.150
     2.221    34.750     0.150
     2.756    41.996     0.150
     3.108    47.648     0.150
     3.654    54.273     0.150
     4.627    70.113     0.150
     5.404    80.945     0.150
     5.869    87.434     0.150
     6.199    89.746     0.150
     6.319    92.812     0.150
     6.285    92.613     0.150
     6.841   102.855     0.150
     6.875   102.051     0.150
     7.120   103.355     0.150
     7.758   114.398     0.150
    10.199   147.348     0.150
    38.133   440.773     0.150
     0.158     1.980     0.150
     0.158     4.594     0.150
     0.406     7.961     0.150
     0.406    13.582     0.150
     0.406    14.672     0.150
     0.586    10.102     0.150
     0.586    18.523     0.150
     0.748    14.082     0.150
     0.748    24.820     0.150
     0.802    14.453     0.150
     0.805    15.281     0.150
     0.891    16.512     0.150
     1.011    28.926     0.150
     1.007    18.332     0.150
     1.007    31.914     0.150
     1.064    19.473     0.150
     1.064    34.473     0.150
     1.065    19.543     0.150
     1.065    34.613     0.150
     1.065    37.773     0.150
     1.156    21.023     0.150
     1.156    36.980     0.150
     1.313    38.430     0.150
     1.356    24.461     0.150
     1.356    43.371     0.150
     1.370    24.441     0.150
     1.370    43.602     0.150
     1.370    44.293     0.150
     1.409    43.262     0.150
     1.439    25.664     0.150
     1.439    45.512     0.150
     1.622    46.508     0.150
     1.926    30.922     0.150
     1.926    54.352     0.150
     1.937    30.293     0.150
     2.216    61.312     0.150
     2.355    72.777     0.150
     3.069    93.820     0.150
     3.117    95.832     0.150
     3.170    96.168     0.150
     3.501   106.195     0.150
     3.724   112.246     0.150
     3.847   101.855     0.150
     3.977   119.285     0.150
     5.577    86.902     0.150
     6.011    93.062     0.150
     6.881   103.418     0.150
     7.114   104.801     0.150
     7.351   112.742     0.150
     7.425   108.461     0.150
     7.381   108.402     0.150
     7.751   112.793     0.150
     8.413   122.473     0.150
     8.669   125.191     0.150
     8.887   129.391     0.150
     8.934   134.711     0.150
     9.768   139.582     0.150
     9.874   145.031     0.150
    10.190   147.793     0.150
    10.190   319.594     0.150
    10.504   150.973     0.150
    10.673   158.664     0.150
    10.735   159.414     0.150
    10.879   161.004     0.150
    11.216   165.414     0.150
    11.471   168.293     0.150
    11.419   167.871     0.150
    11.419   167.754     0.150
    11.495   168.891     0.150
    11.535   166.891     0.150
    11.549   166.043     0.150
    11.766   172.832     0.150
    11.865   173.070     0.150
    11.991   174.754     0.150
    12.059   175.480     0.150
    12.277   176.711     0.150
    12.257   178.602     0.150
    12.247   179.941     0.150
    12.485   181.504     0.150
    12.562   183.004     0.150
    13.064   189.352     0.150
    13.065   190.531     0.150
    13.162   188.891     0.150
    13.422   194.211     0.150
    13.874   196.031     0.150
    14.627   211.613     0.150
    14.719   212.504     0.150
    14.776   212.211     0.150
    14.843   212.633     0.150
    14.901   212.531     0.150
    14.950   212.223     0.150
    14.939   215.543     0.150
    15.050   214.691     0.150
    15.211   215.102     0.150
    15.265   218.312     0.150
    15.452   216.723     0.150
    15.774   224.691     0.150
    15.771   225.320     0.150
    15.909   227.191     0.150
    16.260   230.918     0.150
    16.260   230.242     0.150
    16.447   230.773     0.150
    16.409   233.621     0.150
    16.450   233.852     0.150
    16.491   234.441     0.150
    16.721   240.742     0.150
    17.482   247.492     0.150
    17.605   249.594     0.150
    17.725   250.094     0.150
    17.755   250.152     0.150
    18.140   251.434     0.150
    18.342   254.004     0.150
    21.187   286.301     0.150
    21.780   292.941     0.150
    22.248   299.219     0.150
    22.894   304.801     0.150
    22.928   304.891     0.150
    23.104   307.516     0.150
    24.492   319.344     0.150
    28.266   356.191     0.150
    30.450   373.188     0.150
    30.450   555.137     0.150
    35.445   419.191     0.150
    36.480   427.891     0.150
    37.830   437.742     0.150
    38.139   441.344     0.150
    38.511   444.344     0.150
    38.693   446.891     0.150
    41.130   465.883     0.150
    56.407   586.570     0.150
    81.634   741.527     0.150
   117.385  1128.270     0.150
   119.347  1131.656     0.150
     0.142     2.551     0.150
     0.142     5.262     0.150
     0.281     5.672     0.150
     0.305     5.902     0.150
     0.305    11.020     0.150
     0.305     6.051     0.150
     0.663    12.090     0.150
     0.663    21.770     0.150
     0.663    22.691     0.150
     0.661    12.492     0.150
     0.661    21.723     0.150
     0.686    12.352     0.150
     0.700    12.223     0.150
     0.739    12.941     0.150
     0.804    14.160     0.150
     0.884    15.852     0.150
     0.884    27.551     0.150
     0.975    16.109     0.150
     0.975    28.961     0.150
     1.100    19.402     0.150
     1.100    36.223     0.150
     1.100    20.121     0.150
     1.100    35.109     0.150
     1.100    35.301     0.150
     1.099    20.262     0.150
     1.099    34.832     0.150
     1.100    20.109     0.150
     1.100    35.781     0.150
     1.100    20.422     0.150
     1.256    22.352     0.150
     1.256    40.262     0.150
     1.256    22.000     0.150
     1.256    39.141     0.150
     1.256    38.723     0.150
     1.278    22.902     0.150
     1.278    40.430     0.150
     1.353    24.102     0.150
     1.353    42.551     0.150
     1.823    56.871     0.150
     1.823    28.211     0.150
     2.034    31.211     0.150
     2.946    45.742     0.150
     2.946    55.730     0.150
     2.946    82.281     0.150
     2.946    94.043     0.150
     3.231    49.449     0.150
     3.231    89.301     0.150
     3.439    53.621     0.150
     3.439    65.711     0.150
     3.439   109.750     0.150
     3.746    54.750     0.150
     3.746    71.461     0.150
     3.746   119.680     0.150
     4.369    66.609     0.150
     4.369    83.770     0.150
     4.645    69.883     0.150
     4.645    87.891     0.150
     4.645   123.973     0.150
     4.645   147.652     0.150
     5.447   103.652     0.150
     5.447   145.199     0.150
     5.447   174.449     0.150
     5.619    83.160     0.150
     5.619   106.723     0.150
     5.619   178.711     0.150
     6.217    91.801     0.150
     6.288   165.551     0.150
     7.821   114.547     0.150
     8.602   128.547     0.150
    10.306   148.945     0.150
    11.525   169.051     0.150
    38.040   440.121     0.150
     0.152     2.910     0.150
     0.152     5.402     0.150
     0.188     3.590     0.150
     0.188     5.992     0.150
     0.493     9.090     0.150
     0.607    11.652     0.150
     0.607    20.902     0.150
     0.622    11.391     0.150
     0.700    12.723     0.150
     0.700    22.250     0.150
     0.700    24.480     0.150
     0.739    13.473     0.150
     0.739    23.512     0.150
     0.738    13.070     0.150
     0.773    13.535     0.150
     0.773    24.910     0.150
     0.895    15.230     0.150
     0.895    27.633     0.150
     1.089    20.000     0.150
     1.089    35.180     0.150
     1.097    19.211     0.150
     1.097    33.852     0.150
     1.113    20.250     0.150
     1.113    35.191     0.150
     1.190    21.180     0.150
     1.190    37.102     0.150
     1.224    22.262     0.150
     1.224    38.883     0.150
     1.225    21.812     0.150
     1.225    37.602     0.150
     1.225    38.852     0.150
     1.225    21.922     0.150
     1.225    39.621     0.150
     1.282    23.082     0.150
     1.282    40.691     0.150
     1.384    22.492     0.150
     1.384    40.520     0.150
     1.427    23.555     0.150
     1.427    41.047     0.150
     1.605    26.727     0.150
     1.605    49.188     0.150
     1.631    26.211     0.150
     1.631    46.375     0.150
     1.631    26.102     0.150
     1.809    28.539     0.150
     1.890    29.762     0.150
     2.041    32.293     0.150
     2.041    62.375     0.150
     2.177    33.711     0.150
     2.177    33.891     0.150
     2.177    61.340     0.150
     2.266    68.977     0.150
     2.299    35.641     0.150
     2.299    69.730     0.150
     2.521    38.746     0.150
     2.565    39.688     0.150
     2.577    39.805     0.150
     2.756    42.242     0.150
     2.789    42.434     0.150
     2.789    84.434     0.150
     2.816    85.223     0.150
     2.862    86.859     0.150
     3.040    48.293     0.150
     3.040    83.223     0.150
     3.663    57.082     0.150
     3.663   115.832     0.150
     3.867    73.441     0.150
     4.228    63.840     0.150
     4.265    64.711     0.150
     4.407    66.020     0.150
     4.407    84.031     0.150
     4.407   140.922     0.150
     4.628    70.371     0.150
     4.628   124.102     0.150
     5.474    82.090     0.150
     5.724    85.191     0.150
     6.068    89.961     0.150
     6.068   115.793     0.150
     6.404    93.660     0.150
     6.602   124.281     0.150
     7.883   115.855     0.150
     7.883   249.555     0.150
     8.458   269.355     0.150
    10.464   152.457     0.150
    10.464   330.730     0.150
    11.121   164.922     0.150
    11.438   170.031     0.150
    37.859   438.543     0.150
     0.146     4.047     0.150
     0.146     7.057     0.150
     0.302     5.477     0.150
     0.302    11.526     0.150
     0.338     6.537     0.150
     0.338    11.007     0.150
     0.639    11.947     0.150
     0.639    21.117     0.150
     0.731    12.526     0.150
     0.702    13.856     0.150
     0.702    23.207     0.150
     0.933    16.387     0.150
     0.933    30.187     0.150
     0.933    16.146     0.150
     0.978    16.787     0.150
     0.978    28.167     0.150
     1.094    19.937     0.150
     1.094    35.217     0.150
     1.094    19.927     0.150
     1.094    35.736     0.150
     1.094    37.667     0.150
     1.130    20.427     0.150
     1.130    35.927     0.150
     1.305    22.486     0.150
     1.305    41.106     0.150
     1.305    40.807     0.150
     1.317    23.227     0.150
     1.317    41.207     0.150
     1.394    24.356     0.150
     1.394    43.937     0.150
     1.865    28.816     0.150
     1.865    34.367     0.150
     1.986    30.137     0.150
     2.963    54.497     0.150
     3.230    50.977     0.150
     3.230    58.637     0.150
     3.230    89.057     0.150
     3.230    99.986     0.150
     3.279    60.247     0.150
     3.279   100.247     0.150
     3.700    69.197     0.150
     3.700   113.407     0.150
     4.387    65.597     0.150
     4.387    81.047     0.150
     4.387   118.127     0.150
     4.500    82.787     0.150
     4.500   137.457     0.150
     4.628    86.187     0.150
     4.626    69.097     0.150
     5.419    80.177     0.150
     5.837    86.276     0.150
     6.193    91.066     0.150
     6.193   118.486     0.150
     6.193   191.047     0.150
     6.238   191.057     0.150
     6.243    90.427     0.150
     6.816    99.257     0.150
     6.816   126.517     0.150
     7.084   102.937     0.150
     7.084   133.957     0.150
     7.309   106.827     0.150
     7.474   109.356     0.150
     7.474   138.227     0.150
     7.854   146.307     0.150
     7.934   115.267     0.150
     7.934   248.767     0.150
     8.001   118.227     0.150
     8.069   117.097     0.150
     8.309   118.557     0.150
     8.309   213.247     0.150
    10.256   148.467     0.150
     0.071     1.957     0.150
     0.103     2.397     0.150
     0.202     4.037     0.150
     0.210     4.215     0.150
     0.210     7.389     0.150
     0.210     4.247     0.150
     0.210     7.537     0.150
     0.239     4.247     0.150
     0.275     4.526     0.150
     0.534     9.452     0.150
     0.534    16.614     0.150
     0.522     9.027     0.150
     0.522    16.777     0.150
     0.522    10.067     0.150
     0.522    19.627     0.150
     0.606    11.707     0.150
     0.606    20.647     0.150
     0.699    12.747     0.150
     0.699    21.867     0.150
     0.746    13.627     0.150
     0.746    24.407     0.150
     0.746    24.968     0.150
     0.780    14.237     0.150
     0.780    24.277     0.150
     0.780    14.497     0.150
     0.780    24.917     0.150
     0.851    14.317     0.150
     0.851    26.268     0.150
     0.936    15.869     0.150
     0.936    28.127     0.150
     0.936    16.007     0.150
     0.936    28.367     0.150
     1.034    17.423     0.150
     1.070    17.945     0.150
     1.070    31.709     0.150
     1.070    19.218     0.150
     1.070    33.127     0.150
     1.084    18.849     0.150
     1.084    32.821     0.150
     1.191    21.647     0.150
     1.191    37.327     0.150
     1.197    21.657     0.150
     1.197    37.897     0.150
     1.211    22.087     0.150
     1.211    38.308     0.150
     1.331    21.838     0.150
     1.373    22.077     0.150
     1.373    41.728     0.150
     1.373    44.058     0.150
     1.464    23.906     0.150
     1.464    44.236     0.150
     1.543    24.971     0.150
     1.593    25.729     0.150
     1.653    27.888     0.150
     1.653    50.428     0.150
     1.654    52.638     0.150
     1.654    30.287     0.150
     1.824    29.729     0.150
     2.113    33.004     0.150
     2.178    65.739     0.150
     2.190    34.139     0.150
     2.296    37.177     0.150
     2.301    40.099     0.150
     2.301    69.331     0.150
     2.398    43.141     0.150
     2.413    39.397     0.150
     2.413    73.167     0.150
     2.464    39.867     0.150
     2.464    74.138     0.150
     2.476    39.147     0.150
     2.476    46.207     0.150
     2.476    69.917     0.150
     2.611    45.157     0.150
     2.611    78.983     0.150
     2.665    40.139     0.150
     2.665    40.018     0.150
     2.665    50.497     0.150
     2.742    49.638     0.150
     2.742    42.308     0.150
     2.742    48.867     0.150
     2.742    86.037     0.150
     2.839    85.556     0.150
     3.086    92.994     0.150
     3.086    48.087     0.150
     3.487    52.824     0.150
     3.487   105.333     0.150
     3.641    54.820     0.150
     3.695    56.808     0.150
     3.695    66.237     0.150
     3.695   112.587     0.150
     3.866    58.457     0.150
     3.866    72.518     0.150
     3.866   123.058     0.150
     3.876    58.867     0.150
     3.876    70.787     0.150
     3.876   118.348     0.150
     4.290    63.178     0.150
     4.670    70.317     0.150
     4.670    88.007     0.150
     5.470    81.127     0.150
     5.470   100.587     0.150
     5.470   171.827     0.150
     5.507    82.308     0.150
     5.635    83.907     0.150
     5.635   171.058     0.150
     5.668    84.308     0.150
     5.668   106.707     0.150
     5.668   182.468     0.150
     6.160    92.127     0.150
     6.511    96.207     0.150
     6.511   198.218     0.150
     6.527    96.768     0.150
     6.527   121.598     0.150
     6.802    98.617     0.150
     7.470   109.447     0.150
     7.540   111.638     0.150
     7.564   110.147     0.150
     7.602   113.257     0.150
     7.739   113.587     0.150
     7.946   117.797     0.150
     8.058   118.497     0.150
     8.058   151.228     0.150
     8.058   254.938     0.150
     8.134   117.837     0.150
     8.920   127.817     0.150
    11.013   161.308     0.150
     0.279     5.520     0.150
     0.279     9.898     0.150
     0.298     5.289     0.150
     0.369     7.410     0.150
     0.369    12.367     0.150
     0.368     6.938     0.150
     0.401     7.340     0.150
     0.401    13.547     0.150
     0.432     7.926     0.150
     0.432    13.566     0.150
     0.477     8.355     0.150
     0.491     8.797     0.150
     0.562    10.309     0.150
     0.623    11.508     0.150
     0.784    14.121     0.150
     0.784    24.016     0.150
     0.873    14.766     0.150
     0.873    25.707     0.150
     0.873    14.559     0.150
     0.906    16.340     0.150
     0.898    16.500     0.150
     0.898    28.430     0.150
     0.898    28.648     0.150
     1.170    19.246     0.150
     1.120    20.480     0.150
     1.120    35.449     0.150
     1.173    21.520     0.150
     1.173    37.559     0.150
     1.197    21.777     0.150
     1.197    37.898     0.150
     1.320    21.496     0.150
     1.320    40.367     0.150
     1.320    40.480     0.150
     1.311    22.461     0.150
     1.311    39.723     0.150
     1.447    24.797     0.150
     1.447    44.367     0.150
     1.447    43.328     0.150
     1.448    26.488     0.150
     1.448    46.348     0.150
     1.448    48.238     0.150
     1.590    25.527     0.150
     1.709    27.203     0.150
     1.723    27.578     0.150
     1.723    52.910     0.150
     2.074    33.137     0.150
     2.074    64.055     0.150
     2.288    35.164     0.150
     2.413    37.070     0.150
     2.420    37.723     0.150
     2.442    36.863     0.150
     2.442    37.027     0.150
     2.442    66.641     0.150
     2.437    73.387     0.150
     2.552    76.945     0.150
     2.640    81.527     0.150
     2.672    41.098     0.150
     2.722    41.590     0.150
     2.722    83.238     0.150
     2.870    86.852     0.150
     2.977    45.383     0.150
     2.971    45.148     0.150
     3.097    94.078     0.150
     3.345    50.930     0.150
     3.951    58.949     0.150
     4.023    60.520     0.150
     4.096    59.750     0.150
     4.113    61.250     0.150
     4.643    70.898     0.150
     5.377    80.238     0.150
     5.557    83.289     0.150
     5.579    82.867     0.150
     5.723    84.609     0.150
     6.316    92.625     0.150
     6.316   116.535     0.150
     6.621    95.957     0.150
     6.621   169.938     0.150
     7.342   107.098     0.150
     7.429   108.258     0.150
     7.513   111.418     0.150
     8.019   117.043     0.150
     8.019   116.570     0.150
     8.725   124.488     0.150
    10.740   154.168     0.150
    10.740   340.297     0.150
    10.864   158.617     0.150
    11.324   166.422     0.150
    37.570   434.617     0.150
     0.055     1.602     0.150
     0.112     2.301     0.150
     0.210     4.012     0.150
     0.247     4.820     0.150
     0.247     8.309     0.150
     0.256     4.953     0.150
     0.256     8.484     0.150
     0.284     5.012     0.150
     0.299     4.953     0.150
     0.299     9.000     0.150
     0.469     9.340     0.150
     0.469    16.719     0.150
     0.469    17.469     0.150
     0.554     9.910     0.150
     0.554    17.980     0.150
     0.587    10.355     0.150
     0.587    18.094     0.150
     0.603    11.270     0.150
     0.745    13.559     0.150
     0.727    13.359     0.150
     0.727    23.492     0.150
     0.809    15.051     0.150
     0.809    26.148     0.150
     0.809    25.602     0.150
     0.809    25.930     0.150
     0.906    15.520     0.150
     0.906    27.352     0.150
     1.046    17.766     0.150
     1.046    30.582     0.150
     1.115    18.695     0.150
     1.115    33.172     0.150
     1.115    32.676     0.150
     1.115    34.352     0.150
     1.134    20.031     0.150
     1.134    34.230     0.150
     1.200    21.879     0.150
     1.200    37.820     0.150
     1.200    21.730     0.150
     1.200    37.980     0.150
     1.201    21.781     0.150
     1.201    37.781     0.150
     1.363    22.367     0.150
     1.516    24.797     0.150
     1.516    46.023     0.150
     1.530    24.914     0.150
     1.601    26.008     0.150
     1.619    28.070     0.150
     1.619    49.398     0.150
     1.620    29.031     0.150
     1.620    27.719     0.150
     1.620    47.320     0.150
     1.710    27.664     0.150
     1.869    30.449     0.150
     2.136    33.508     0.150
     2.225    34.785     0.150
     2.228    35.082     0.150
     2.228    67.426     0.150
     2.331    36.652     0.150
     2.331    66.820     0.150
     2.345    38.094     0.150
     2.345    67.566     0.150
     2.354    71.867     0.150
     2.441    38.000     0.150
     2.495    38.461     0.150
     2.614    39.738     0.150
     2.664    80.652     0.150
     2.665    41.152     0.150
     2.781    42.609     0.150
     2.781    52.281     0.150
     2.781    77.699     0.150
     2.781    87.551     0.150
     2.785    42.609     0.150
     2.888    44.270     0.150
     2.888    87.051     0.150
     2.915    44.914     0.150
     3.138    53.805     0.150
     3.538    53.570     0.150
     3.683    55.176     0.150
     3.743    55.930     0.150
     3.743    71.371     0.150
     3.743   103.672     0.150
     3.885    58.648     0.150
     3.885    74.512     0.150
     3.885   123.160     0.150
     3.917    58.719     0.150
     3.917    74.051     0.150
     3.917   107.012     0.150
     3.917   122.820     0.150
     4.039    61.145     0.150
     4.243    62.371     0.150
     4.243    80.160     0.150
     4.310    64.637     0.150
     4.530    67.777     0.150
     4.651    70.180     0.150
     4.651   125.301     0.150
     4.751    71.879     0.150
     5.223    77.656     0.150
     5.282    79.172     0.150
     5.282    99.129     0.150
     5.542    82.969     0.150
     5.542   177.141     0.150
     5.607    83.980     0.150
     5.672    82.941     0.150
     6.124    90.195     0.150
     6.124   196.770     0.150
     6.531    96.879     0.150
     6.531   170.629     0.150
     6.558    96.590     0.150
     6.558   124.582     0.150
     6.558   172.641     0.150
     6.757    98.355     0.150
     7.521   110.590     0.150
     7.521   144.160     0.150
     8.044   117.961     0.150
     8.044   152.789     0.150
     8.044   209.129     0.150
     8.096   117.844     0.150
     8.096   253.297     0.150
     8.100   117.070     0.150
     8.100   254.371     0.150
     8.873   127.555     0.150
    10.914   156.797     0.150
    11.240   163.570     0.150
    15.634   222.996     0.150
    22.948   304.469     0.150
    27.535   347.871     0.150
    29.874   367.961     0.150
    37.375   434.070     0.150
    62.660   623.797     0.150
    74.276   697.266     0.150
   116.860  1125.289     0.150
   118.864  1131.371     0.150
     0.059     1.547     0.150
     0.108     2.195     0.150
     0.212     4.105     0.150
     0.243     4.688     0.150
     0.252     4.855     0.150
     0.252     8.434     0.150
     0.282     5.027     0.150
     0.299     5.246     0.150
     0.299     9.129     0.150
     0.473     9.227     0.150
     0.557    10.766     0.150
     0.557    17.715     0.150
     0.583    10.594     0.150
     0.583    18.012     0.150
     0.607    11.246     0.150
     0.741    13.438     0.150
     0.725    13.215     0.150
     0.725    23.734     0.150
     0.805    14.906     0.150
     0.805    26.426     0.150
     0.805    25.426     0.150
     0.805    25.656     0.150
     0.910    15.695     0.150
     0.910    27.500     0.150
     0.910    15.586     0.150
     1.047    17.777     0.150
     1.059    17.906     0.150
     1.114    18.691     0.150
     1.114    33.965     0.150
     1.130    19.941     0.150
     1.130    34.246     0.150
     1.197    21.695     0.150
     1.197    37.746     0.150
     1.197    21.637     0.150
     1.197    38.266     0.150
     1.199    21.855     0.150
     1.199    37.926     0.150
     1.199    39.086     0.150
     1.363    22.410     0.150
     1.513    24.711     0.150
     1.533    24.852     0.150
     1.603    25.945     0.150
     1.619    27.617     0.150
     1.619    49.465     0.150
     1.620    28.957     0.150
     1.620    29.215     0.150
     1.620    51.195     0.150
     1.620    51.785     0.150
     1.620    53.227     0.150
     1.620    27.617     0.150
     1.714    27.578     0.150
     1.868    30.387     0.150
     2.137    33.477     0.150
     2.155    33.957     0.150
     2.225    34.676     0.150
     2.226    34.938     0.150
     2.226    67.094     0.150
     2.333    36.465     0.150
     2.351    70.742     0.150
     2.341    37.879     0.150
     2.341    66.328     0.150
     2.440    38.023     0.150
     2.499    38.512     0.150
     2.618    39.688     0.150
     2.661    80.422     0.150
     2.669    41.129     0.150
     2.669    73.012     0.150
     2.780    42.625     0.150
     2.786    42.648     0.150
     2.886    44.242     0.150
     2.886    87.066     0.150
     3.102    46.809     0.150
     3.102    93.566     0.150
     3.135    53.887     0.150
     3.135    94.441     0.150
     3.232    48.973     0.150
     3.536    53.434     0.150
     3.682    55.180     0.150
     3.741    55.922     0.150
     4.043    61.031     0.150
     4.194    62.434     0.150
     4.248    62.004     0.150
     4.310    64.785     0.150
     4.529    67.742     0.150
     4.654    70.148     0.150
     4.754    71.809     0.150
     5.227    77.703     0.150
     5.611    83.836     0.150
     5.694    84.133     0.150
     5.676    82.844     0.150
     6.123    90.141     0.150
     6.123   111.941     0.150
     6.761    98.445     0.150
     8.096   117.789     0.150
     8.096   153.340     0.150
     8.096   252.242     0.150
     8.104   118.391     0.150
     8.104   255.234     0.150
     8.877   127.484     0.150
     8.927   130.141     0.150
     9.637   139.844     0.150
     9.835   142.715     0.150
     9.839   142.227     0.150
    10.488   153.375     0.150
    10.568   154.320     0.150
    10.885   158.801     0.150
    10.918   156.574     0.150
    10.962   160.066     0.150
    10.978   160.562     0.150
    11.242   161.648     0.150
    11.223   161.312     0.150
    15.635   221.266     0.150
    22.951   304.516     0.150
    24.419   320.809     0.150
    29.875   367.336     0.150
    37.374   433.914     0.150
    43.363   482.816     0.150
    62.657   624.449     0.150
    78.683   722.488     0.150
    81.262   736.699     0.150
    91.935   788.816     0.150
    94.521   800.727     0.150
    96.031   807.438     0.150
    96.134   807.438     0.150
   116.855  1124.941     0.150
   118.860  1128.340     0.150
     0.122     2.039     0.150
     0.122     4.230     0.150
     0.122     4.629     0.150
     0.155     3.199     0.150
     0.155     5.348     0.150
     0.486     8.840     0.150
     0.612    11.000     0.150
     0.638    12.289     0.150
     0.638    21.141     0.150
     0.590    10.840     0.150
     0.645    11.668     0.150
     0.704    12.770     0.150
     0.704    22.617     0.150
     0.704    24.777     0.150
     0.710    12.820     0.150
     1.121    20.680     0.150
     1.131    20.578     0.150
     1.131    35.758     0.150
     1.131    35.867     0.150
     1.131    34.230     0.150
     1.199    21.629     0.150
     1.199    21.059     0.150
     1.199    37.238     0.150
     1.254    22.898     0.150
     1.254    22.629     0.150
     1.254    38.719     0.150
     1.254    22.688     0.150
     1.254    42.391     0.150
     1.254    43.180     0.150
     1.310    23.629     0.150
     1.619    25.719     0.150
     1.619    30.719     0.150
     1.619    49.660     0.150
     1.619    51.020     0.150
     2.162    33.629     0.150
     2.162    63.988     0.150
     2.779    43.711     0.150
     2.779    53.211     0.150
     2.987    48.277     0.150
     2.987    56.258     0.150
     2.987    83.078     0.150
     2.987    94.320     0.150
     3.038    47.969     0.150
     3.038    56.570     0.150
     3.038    82.359     0.150
     3.239    51.059     0.150
     3.239    60.688     0.150
     3.239    87.738     0.150
     3.847    73.141     0.150
     3.847   105.520     0.150
     3.847   121.348     0.150
     4.200    63.668     0.150
     4.200    78.859     0.150
     4.254    63.699     0.150
     4.254    80.008     0.150
     4.254   114.301     0.150
     4.390    66.000     0.150
     4.390    83.160     0.150
     4.595    69.230     0.150
     4.595    87.367     0.150
     4.595   123.391     0.150
     5.443    81.527     0.150
     5.483    81.348     0.150
     5.483   145.059     0.150
     5.692    84.680     0.150
     5.692   108.348     0.150
     5.692   181.668     0.150
     6.041    88.711     0.150
     6.383    92.141     0.150
     6.383   167.160     0.150
     6.583   124.289     0.150
     6.694    98.789     0.150
     6.694   126.789     0.150
     7.855   115.340     0.150
     8.431   125.539     0.150
    10.451   151.688     0.150
    11.406   168.938     0.150
    16.007   230.914     0.150
    23.021   306.590     0.150
    37.841   440.359     0.150
     0.079     1.648     0.150
     0.092     1.977     0.150
     0.204     3.816     0.150
     0.220     4.219     0.150
     0.220     7.008     0.150
     0.249     4.207     0.150
     0.217     4.117     0.150
     0.217     7.578     0.150
     0.280     4.477     0.150
     0.280     8.496     0.150
     0.510    10.289     0.150
     0.510    10.160     0.150
     0.510    19.309     0.150
     0.546     9.566     0.150
     0.546    16.992     0.150
     0.594    11.789     0.150
     0.594    20.648     0.150
     0.629    11.738     0.150
     0.709    12.867     0.150
     0.709    22.238     0.150
     0.741    13.637     0.150
     0.741    24.566     0.150
     0.786    14.469     0.150
     0.786    25.258     0.150
     0.786    14.660     0.150
     0.786    25.148     0.150
     0.929    16.219     0.150
     0.929    16.008     0.150
     0.929    28.867     0.150
     1.037    17.680     0.150
     1.037    32.172     0.150
     1.080    18.863     0.150
     1.080    32.262     0.150
     1.080    18.426     0.150
     1.080    33.047     0.150
     1.080    32.590     0.150
     1.095    19.305     0.150
     1.095    33.102     0.150
     1.192    21.809     0.150
     1.197    21.840     0.150
     1.208    22.066     0.150
     1.339    22.246     0.150
     1.362    20.938     0.150
     1.362    39.930     0.150
     1.362    43.258     0.150
     1.475    24.477     0.150
     1.541    25.117     0.150
     1.595    25.984     0.150
     1.645    28.270     0.150
     1.645    51.539     0.150
     1.645    28.160     0.150
     1.645    52.680     0.150
     1.646    29.359     0.150
     1.646    55.367     0.150
     1.646    28.328     0.150
     1.646    51.098     0.150
     1.744    28.266     0.150
     2.118    33.465     0.150
     2.160    34.234     0.150
     2.189    34.754     0.150
     2.199    34.562     0.150
     2.290    36.531     0.150
     2.290    66.500     0.150
     2.313    37.574     0.150
     2.307    37.641     0.150
     2.307    66.734     0.150
     2.408    37.762     0.150
     2.425    40.160     0.150
     2.425    69.508     0.150
     2.480    39.816     0.150
     2.476    39.598     0.150
     2.523    39.086     0.150
     2.523    79.160     0.150
     2.623    45.902     0.150
     2.623    80.359     0.150
     2.654    40.402     0.150
     2.654    40.277     0.150
     2.654    72.457     0.150
     2.687    41.543     0.150
     2.751    42.414     0.150
     2.751    77.137     0.150
     2.764    42.625     0.150
     2.850    43.961     0.150
     2.918    45.156     0.150
     3.064    47.480     0.150
     3.098    48.129     0.150
     3.098    84.438     0.150
     3.199    48.730     0.150
     3.247    49.383     0.150
     3.449    60.148     0.150
     3.499    52.754     0.150
     3.651    54.965     0.150
     3.706    55.633     0.150
     3.706    99.777     0.150
     3.871    58.590     0.150
     3.871   103.387     0.150
     3.885    58.379     0.150
     3.887    58.488     0.150
     4.062    61.184     0.150
     4.158    61.984     0.150
     4.287    64.699     0.150
     4.280    62.859     0.150
     4.280   135.457     0.150
     4.501    67.555     0.150
     4.666    70.270     0.150
     4.666    69.637     0.150
     4.756    71.742     0.150
     5.249    78.141     0.150
     5.277    79.117     0.150
     5.277   136.797     0.150
     5.516    81.777     0.150
     5.629    83.957     0.150
     5.629    84.508     0.150
     5.629   146.930     0.150
     5.629   180.938     0.150
     5.674    84.324     0.150
     5.674    84.188     0.150
     5.674   180.027     0.150
     5.711    83.676     0.150
     6.094    90.152     0.150
     6.094   111.176     0.150
     6.094   195.551     0.150
     6.171    89.438     0.150
     6.171   192.910     0.150
     6.522    95.949     0.150
     6.524    94.188     0.150
     6.529    95.168     0.150
     6.792    99.027     0.150
     6.792    98.867     0.150
     7.345   105.637     0.150
     7.462   109.059     0.150
     7.537   112.273     0.150
     7.537   111.148     0.150
     7.556   110.109     0.150
     7.603   108.949     0.150
     7.586   111.012     0.150
     7.739   114.238     0.150
     7.859   114.250     0.150
     7.859   200.930     0.150
     7.880   112.988     0.150
     7.880   201.137     0.150
     7.898   114.598     0.150
     7.898   203.359     0.150
     8.056   118.207     0.150
     8.078   118.062     0.150
     8.078   153.488     0.150
     8.078   254.539     0.150
     8.078   117.059     0.150
     8.127   118.188     0.150
     8.127   155.438     0.150
     8.127   255.289     0.150
     8.127   117.160     0.150
     8.127   207.219     0.150
     8.667   124.738     0.150
     8.910   128.453     0.150
     8.910   128.000     0.150
     8.910   228.359     0.150
     8.940   130.152     0.150
     9.148   132.359     0.150
     9.148   238.047     0.150
     9.485   137.910     0.150
     9.551   141.418     0.150
     9.639   140.578     0.150
     9.639   139.000     0.150
     9.848   143.223     0.150
     9.853   142.316     0.150
    10.078   146.555     0.150
    10.161   148.105     0.150
    10.229   149.352     0.150
    10.358   149.891     0.150
    10.385   151.531     0.150
    10.498   153.543     0.150
    10.574   153.898     0.150
    10.706   155.633     0.150
    10.893   158.605     0.150
    10.936   160.117     0.150
    10.969   157.449     0.150
    10.954   157.207     0.150
    11.006   160.203     0.150
    11.005   159.172     0.150
    11.005   158.680     0.150
    11.064   160.121     0.150
    11.208   161.992     0.150
    11.236   162.238     0.150
    11.260   162.758     0.150
    11.254   162.148     0.150
    11.983   170.680     0.150
    11.983   302.520     0.150
    12.390   175.457     0.150
    12.440   177.578     0.150
    13.395   195.488     0.150
    13.841   198.000     0.150
    14.367   204.867     0.150
    14.347   203.848     0.150
    14.668   209.289     0.150
    14.690   206.750     0.150
    14.690   367.840     0.150
    14.792   208.848     0.150
    14.892   210.129     0.150
    15.110   213.340     0.150
    15.190   214.008     0.150
    15.244   213.238     0.150
    15.537   219.578     0.150
    15.553   219.598     0.150
    15.613   221.863     0.150
    15.613   222.020     0.150
    15.819   225.098     0.150
    16.837   237.219     0.150
    16.874   235.258     0.150
    17.304   240.660     0.150
    18.059   250.539     0.150
    18.631   258.879     0.150
    18.669   259.598     0.150
    21.686   291.988     0.150
    21.777   293.879     0.150
    22.653   300.688     0.150
    22.952   304.340     0.150
    24.456   321.832     0.150
    27.506   347.988     0.150
    29.855   368.734     0.150
    37.343   434.387     0.150
    62.621   627.090     0.150
    94.771   800.238     0.150
    94.771  1468.738     0.150
    97.490   812.738     0.150
   100.909   831.238     0.150
   102.173   833.238     0.150
   102.173   839.039     0.150
   102.173   841.238     0.150
   106.506   854.238     0.150
   106.506  1570.238     0.150
   106.506  2020.738     0.150
   107.353   862.539     0.150
   107.353  1134.238     0.150
   118.833  1130.371     0.150
     0.161     3.075     0.150
     0.161     5.895     0.150
     0.234     4.985     0.150
     0.234     7.015     0.150
     0.402     7.095     0.150
     0.460     8.715     0.150
     0.486     9.265     0.150
     0.568    11.075     0.150
     0.568    19.245     0.150
     0.568    21.985     0.150
     0.499     9.225     0.150
     0.515     9.035     0.150
     0.578    10.695     0.150
     0.600    10.765     0.150
     0.600    18.575     0.150
     0.600    18.715     0.150
     0.577    10.895     0.150
     0.612    11.245     0.150
     0.690    12.125     0.150
     0.804    14.245     0.150
     0.910    27.695     0.150
     0.910    29.165     0.150
     0.903    15.245     0.150
     0.903    26.845     0.150
     1.025    18.875     0.150
     1.025    32.314     0.150
     1.025    33.334     0.150
     1.062    20.055     0.150
     1.091    19.325     0.150
     1.091    32.765     0.150
     1.174    22.104     0.150
     1.223    22.675     0.150
     1.268    23.055     0.150
     1.268    40.774     0.150
     1.269    23.104     0.150
     1.269    40.245     0.150
     1.269    41.435     0.150
     1.325    23.544     0.150
     1.543    24.865     0.150
     1.543    45.625     0.150
     2.270    34.885     0.150
     2.270    40.794     0.150
     2.270    71.274     0.150
     2.768    44.084     0.150
     2.894    44.084     0.150
     2.894    49.314     0.150
     2.894    89.375     0.150
     2.942    46.035     0.150
     2.942    52.215     0.150
     2.942    89.015     0.150
     3.182    58.645     0.150
     3.566    55.965     0.150
     3.566    64.345     0.150
     3.566   111.774     0.150
     3.953    58.665     0.150
     3.953    68.024     0.150
     3.953    73.765     0.150
     3.953   121.485     0.150
     4.174    62.665     0.150
     4.174    74.635     0.150
     4.174   129.035     0.150
     4.185    63.485     0.150
     4.185    79.274     0.150
     4.185   128.215     0.150
     4.328    64.755     0.150
     4.328    79.225     0.150
     4.328   135.345     0.150
     4.657    71.055     0.150
     4.666    70.524     0.150
     4.666    82.965     0.150
     5.496    82.415     0.150
     5.523    82.935     0.150
     5.924   113.805     0.150
     6.019   115.915     0.150
     6.488    94.604     0.150
     6.527   123.918     0.150
     6.715    97.415     0.150
     7.520   111.825     0.150
     7.647   111.655     0.150
     7.873   116.095     0.150
     7.947   116.689     0.150
     7.947   116.555     0.150
     7.998   117.845     0.150
     8.576   123.965     0.150
    10.560   153.265     0.150
    15.979   229.715     0.150
    23.062   308.390     0.150
    37.783   438.627     0.150
     0.168     3.387     0.150
     0.182     3.746     0.150
     0.182     5.938     0.150
     0.533     9.969     0.150
     0.559    10.258     0.150
     0.622    11.508     0.150
     0.631    11.168     0.150
     0.628    12.598     0.150
     0.628    21.316     0.150
     0.655    11.930     0.150
     0.696    12.457     0.150
     0.712    12.316     0.150
     0.742    13.629     0.150
     0.742    23.906     0.150
     0.764    12.957     0.150
     0.782    14.344     0.150
     0.782    24.508     0.150
     0.805    13.988     0.150
     0.805    25.008     0.150
     0.805    25.109     0.150
     0.809    13.758     0.150
     0.809    24.762     0.150
     0.896    14.816     0.150
     0.896    26.520     0.150
     0.896    27.227     0.150
     1.102    20.297     0.150
     1.140    19.508     0.150
     1.140    35.145     0.150
     1.152    20.547     0.150
     1.152    35.770     0.150
     1.152    20.656     0.150
     1.152    36.277     0.150
     1.208    21.777     0.150
     1.208    37.996     0.150
     1.208    37.359     0.150
     1.232    21.207     0.150
     1.232    37.746     0.150
     1.247    22.609     0.150
     1.247    39.438     0.150
     1.308    23.418     0.150
     1.308    41.449     0.150
     1.400    22.805     0.150
     1.407    22.570     0.150
     1.635    25.750     0.150
     1.647    27.160     0.150
     1.669    26.117     0.150
     1.669    51.316     0.150
     1.669    26.465     0.150
     1.840    28.727     0.150
     1.907    29.781     0.150
     2.083    32.551     0.150
     2.137    32.816     0.150
     2.269    35.117     0.150
     2.277    35.250     0.150
     2.421    37.758     0.150
     2.546    38.793     0.150
     2.563    39.262     0.150
     2.713    41.121     0.150
     2.797    42.848     0.150
     2.826    43.988     0.150
     2.826    77.867     0.150
     2.830    43.309     0.150
     2.830    85.863     0.150
     2.859    43.883     0.150
     2.859    86.789     0.150
     2.904    87.844     0.150
     2.975    89.578     0.150
     3.032    47.918     0.150
     3.032    97.309     0.150
     3.079    46.422     0.150
     3.219    48.238     0.150
     3.290    50.316     0.150
     3.453    52.039     0.150
     3.705    56.859     0.150
     3.705   118.859     0.150
     3.705   111.672     0.150
     3.830    56.117     0.150
     3.830   123.137     0.150
     3.891    58.566     0.150
     4.107    61.543     0.150
     4.208    62.027     0.150
     4.247    63.168     0.150
     4.247   113.199     0.150
     4.303    64.219     0.150
     4.303   137.066     0.150
     4.441    65.316     0.150
     4.441   119.117     0.150
     4.441    85.520     0.150
     4.617    69.238     0.150
     4.617   125.059     0.150
     4.617    69.684     0.150
     4.752    70.918     0.150
     4.857    72.988     0.150
     4.959    74.215     0.150
     5.024    74.383     0.150
     5.202    76.277     0.150
     5.305    81.789     0.150
     5.454    81.078     0.150
     5.454   143.059     0.150
     5.454   142.434     0.150
     6.020    91.020     0.150
     6.090    89.578     0.150
     6.090   159.387     0.150
     6.090    89.180     0.150
     6.368    92.418     0.150
     6.368   166.840     0.150
     6.368    92.758     0.150
     6.732   100.438     0.150
     6.732   175.238     0.150
     6.750    99.418     0.150
     6.750   175.617     0.150
     7.093   104.578     0.150
     7.114   105.816     0.150
     7.165   104.656     0.150
     7.165   185.438     0.150
     7.240   105.398     0.150
     7.240   187.758     0.150
     7.263   105.797     0.150
     7.475   110.277     0.150
     7.475   193.648     0.150
     7.475   109.844     0.150
     7.549   109.719     0.150
     7.779   116.047     0.150
     7.857   113.293     0.150
     7.857   245.418     0.150
     7.857   114.117     0.150
     7.857   113.977     0.150
     7.857   202.930     0.150
     7.873   115.316     0.150
     8.052   151.699     0.150
     8.052   254.156     0.150
     8.121   120.148     0.150
     8.121   209.168     0.150
     8.180   122.520     0.150
     8.180   210.617     0.150
     8.299   119.629     0.150
     8.299   215.277     0.150
     8.449   120.770     0.150
     8.449   214.430     0.150
     8.449   121.145     0.150
     8.479   123.367     0.150
     8.479   123.219     0.150
     8.479   218.219     0.150
     8.854   128.840     0.150
     8.850   129.719     0.150
     8.850   224.828     0.150
     8.894   130.199     0.150
     9.235   136.688     0.150
     9.386   137.109     0.150
     9.718   140.180     0.150
     9.718   250.539     0.150
     9.731   140.988     0.150
     9.731   140.168     0.150
     9.757   140.637     0.150
     9.806   144.316     0.150
     9.806   254.566     0.150
    10.208   149.387     0.150
    10.423   150.168     0.150
    10.423   328.109     0.150
    10.505   155.219     0.150
    10.505   270.617     0.150
    10.597   154.152     0.150
    10.636   153.867     0.150
    10.652   153.699     0.150
    10.652   271.367     0.150
    10.652   154.699     0.150
    10.776   157.117     0.150
    10.817   157.605     0.150
    10.873   158.117     0.150
    10.873   157.898     0.150
    11.013   160.707     0.150
    11.154   164.777     0.150
    11.158   163.684     0.150
    11.158   164.418     0.150
    11.316   167.309     0.150
    11.316   290.289     0.150
    11.356   168.488     0.150
    11.442   166.188     0.150
    11.443   165.230     0.150
    11.443   366.117     0.150
    11.637   169.047     0.150
    11.637   296.359     0.150
    11.666   297.867     0.150
    11.735   170.746     0.150
    11.755   171.219     0.150
    11.755   296.629     0.150
    11.858   172.547     0.150
    11.932   172.246     0.150
    11.932   305.547     0.150
    11.990   175.008     0.150
    12.027   173.188     0.150
    12.124   310.430     0.150
    12.318   177.840     0.150
    12.318   314.020     0.150
    12.354   179.297     0.150
    12.354   314.027     0.150
    12.500   179.438     0.150
    12.500   316.746     0.150
    12.704   185.340     0.150
    12.920   187.207     0.150
    12.920   327.566     0.150
    13.238   191.168     0.150
    13.262   192.906     0.150
    13.327   193.988     0.150
    13.367   192.219     0.150
    13.526   196.867     0.150
    13.732   196.656     0.150
    13.732   346.508     0.150
    14.014   199.117     0.150
    14.494   206.539     0.150
    14.599   210.789     0.150
    14.687   211.289     0.150
    14.730   209.148     0.150
    14.780   209.520     0.150
    15.038   214.816     0.150
    15.131   214.578     0.150
    15.260   215.879     0.150
    15.274   218.707     0.150
    15.317   218.816     0.150
    15.498   221.957     0.150
    15.589   220.816     0.150
    15.696   224.020     0.150
    15.770   225.289     0.150
    16.056   227.469     0.150
    16.056   228.316     0.150
    16.377   231.637     0.150
    16.573   232.367     0.150
    16.837   236.418     0.150
    18.248   254.379     0.150
    18.287   254.719     0.150
    18.287   457.520     0.150
    18.622   258.578     0.150
    20.961   285.617     0.150
    20.970   283.508     0.150
    21.727   292.219     0.150
    21.728   292.227     0.150
    21.745   291.777     0.150
    22.453   300.219     0.150
    22.459   299.797     0.150
    23.024   306.219     0.150
    23.029   305.656     0.150
    23.051   304.344     0.150
    23.051   304.719     0.150
    23.825   314.090     0.150
    23.855   312.012     0.150
    23.893   312.859     0.150
    24.038   317.617     0.150
    24.062   317.137     0.150
    24.376   317.816     0.150
    24.417   318.398     0.150
    24.568   319.770     0.150
    27.149   343.496     0.150
    28.029   352.520     0.150
    30.131   370.316     0.150
    30.263   371.062     0.150
    35.204   415.047     0.150
    36.581   428.219     0.150
    37.607   434.645     0.150
    37.860   438.719     0.150
    37.892   438.418     0.150
    38.263   439.918     0.150
    38.263   440.680     0.150
    38.439   442.039     0.150
    38.510   444.359     0.150
    40.562   462.359     0.150
    40.880   463.547     0.150
    47.141   514.988     0.150
    47.396   515.527     0.150
    55.637   576.117     0.150
    55.637   575.617     0.150
    56.151   578.918     0.150
    63.227   628.543     0.150
    67.247   653.316     0.150
    67.247   653.598     0.150
    70.306   675.113     0.150
    74.567   698.793     0.150
    77.381   715.418     0.150
    77.381   715.770     0.150
    79.741   728.020     0.150
    80.272   731.441     0.150
    80.272   731.617     0.150
    81.513   738.043     0.150
    81.513   737.918     0.150
    82.128   742.020     0.150
    82.353   742.117     0.150
    82.393   742.520     0.150
    82.421   742.117     0.150
    83.564   749.219     0.150
    83.585   748.617     0.150
    83.780   749.520     0.150
    83.780   749.418     0.150
    83.821   749.816     0.150
    83.877   750.316     0.150
    84.229   751.418     0.150
    84.281   751.316     0.150
    84.557   753.418     0.150
    84.723   754.316     0.150
    84.933   755.219     0.150
    84.972   755.617     0.150
    85.175   757.719     0.150
    85.201   756.918     0.150
    85.919   760.770     0.150
    86.186   761.117     0.150
    87.298   767.418     0.150
    87.345   766.367     0.150
    89.774   782.418     0.150
    89.905   777.477     0.150
    89.977   780.219     0.150
    91.018   786.316     0.150
    91.663   786.816     0.150
    91.663   787.117     0.150
    92.405   790.844     0.150
    93.719   795.418     0.150
    94.940   802.555     0.150
    95.363  1469.117     0.150
    98.098   817.617     0.150
   101.435   840.520     0.150
   107.834  1137.816     0.150
   107.834  1589.020     0.150
   112.376  1116.918     0.150
   117.215  1125.281     0.150
   119.191  1128.762     0.150
   144.592  1174.730     0.150
   145.080  1177.719     0.150
     0.396     7.930     0.150
     0.440     8.832     0.150
     0.440    14.793     0.150
     0.553    10.023     0.150
     0.553    18.312     0.150
     0.553    20.000     0.150
     0.553    20.180     0.150
     0.684    11.953     0.150
     0.713    12.871     0.150
     0.755    14.590     0.150
     0.755    25.070     0.150
     0.837    15.012     0.150
     0.836    14.461     0.150
     0.924    16.523     0.150
     1.037    19.410     0.150
     1.037    34.551     0.150
     1.037    19.613     0.150
     1.037    34.031     0.150
     1.037    36.223     0.150
     1.035    18.562     0.150
     1.035    32.852     0.150
     1.041    17.512     0.150
     1.041    30.551     0.150
     1.152    21.340     0.150
     1.152    36.863     0.150
     1.358    24.473     0.150
     1.358    42.742     0.150
     1.388    24.750     0.150
     1.388    24.492     0.150
     1.388    43.512     0.150
     1.444    25.371     0.150
     1.444    44.863     0.150
     1.511    25.711     0.150
     1.511    46.672     0.150
     1.913    29.703     0.150
     1.970    31.082     0.150
     1.970    36.363     0.150
     3.043    59.613     0.150
     3.335    51.750     0.150
     3.335    60.551     0.150
     3.335   102.531     0.150
     3.575    55.543     0.150
     3.638    53.293     0.150
     3.638   113.102     0.150
     4.007    74.242     0.150
     4.468    67.750     0.150
     4.468    85.773     0.150
     4.605    85.340     0.150
     4.642    70.230     0.150
     4.730    70.223     0.150
     5.409    80.980     0.150
     6.183    89.672     0.150
     6.288   120.211     0.150
     6.322    93.410     0.150
     6.887   102.562     0.150
     7.426   107.930     0.150
     7.482   110.211     0.150
     7.754   113.625     0.150
     7.754   245.652     0.150
     7.754   113.293     0.150
    10.172   147.453     0.150
    10.172   321.676     0.150
     0.062     1.408     0.150
     0.140     2.668     0.150
     0.140     5.418     0.150
     0.190     3.848     0.150
     0.192     3.658     0.150
     0.192     6.889     0.150
     0.200     3.438     0.150
     0.198     3.697     0.150
     0.254     4.309     0.150
     0.382     7.629     0.150
     0.564    10.598     0.150
     0.564    19.088     0.150
     0.648    12.078     0.150
     0.666    12.117     0.150
     0.666    21.008     0.150
     0.764    14.037     0.150
     0.764    24.088     0.150
     0.764    14.148     0.150
     0.764    24.537     0.150
     0.764    25.838     0.150
     0.764    25.998     0.150
     0.771    13.828     0.150
     0.894    15.947     0.150
     0.955    16.549     0.150
     0.955    28.998     0.150
     1.030    17.758     0.150
     1.030    31.238     0.150
     1.193    21.527     0.150
     1.204    21.799     0.150
     1.228    22.268     0.150
     1.413    24.068     0.150
     1.413    43.488     0.150
     1.687    30.568     0.150
     1.687    53.357     0.150
     1.687    29.309     0.150
     1.688    30.738     0.150
     1.688    53.219     0.150
     1.688    29.688     0.150
     2.370    40.639     0.150
     2.421    42.037     0.150
     2.421    71.408     0.150
     2.458    42.188     0.150
     2.706    42.129     0.150
     2.704    40.828     0.150
     3.043    49.457     0.150
     3.043    84.809     0.150
     3.843    58.648     0.150
     4.325    64.049     0.150
     4.678    70.598     0.150
     5.651    84.578     0.150
     6.048    88.646     0.150
     6.048   110.518     0.150
     6.517    99.748     0.150
     6.537   100.908     0.150
     6.834    99.527     0.150
     7.494   109.318     0.150
     7.548   112.537     0.150
     7.733   114.479     0.150
     7.892   115.059     0.150
     8.046   152.617     0.150
     8.046   255.293     0.150
     8.062   119.379     0.150
     8.156   119.043     0.150
     8.955   129.158     0.150
    11.003   158.547     0.150
    11.041   159.848     0.150
    11.223   165.537     0.150
     0.138     2.613     0.150
     0.138     5.584     0.150
     0.194     3.709     0.150
     0.196     3.764     0.150
     0.196     7.174     0.150
     0.273     4.441     0.150
     0.273     8.131     0.150
     0.374     7.514     0.150
     0.539    10.514     0.150
     0.517     9.264     0.150
     0.517    16.148     0.150
     0.623    12.053     0.150
     0.623    22.504     0.150
     0.682    12.145     0.150
     0.682    21.193     0.150
     0.682    12.334     0.150
     0.682    21.434     0.150
     0.749    13.674     0.150
     0.749    23.883     0.150
     0.767    14.303     0.150
     0.767    25.824     0.150
     0.767    24.895     0.150
     0.949    16.373     0.150
     0.949    29.184     0.150
     0.949    28.570     0.150
     0.911    16.094     0.150
     1.035    17.604     0.150
     1.035    30.283     0.150
     1.058    17.904     0.150
     1.058    31.613     0.150
     1.058    18.041     0.150
     1.067    18.768     0.150
     1.067    32.371     0.150
     1.184    21.523     0.150
     1.192    21.613     0.150
     1.211    22.043     0.150
     1.325    21.920     0.150
     1.385    23.975     0.150
     1.385    43.424     0.150
     1.385    44.283     0.150
     1.448    24.311     0.150
     1.448    44.297     0.150
     1.552    25.236     0.150
     1.661    28.414     0.150
     1.661    28.613     0.150
     1.662    28.533     0.150
     1.811    29.758     0.150
     1.811    52.768     0.150
     2.109    33.229     0.150
     2.169    34.342     0.150
     2.163    64.852     0.150
     2.284    39.943     0.150
     2.284    68.832     0.150
     2.279    37.312     0.150
     2.387    43.096     0.150
     2.397    41.734     0.150
     2.397    69.273     0.150
     2.595    45.010     0.150
     2.595    78.986     0.150
     2.683    40.713     0.150
     2.733    42.334     0.150
     2.733    49.426     0.150
     2.825    85.082     0.150
     3.035    91.316     0.150
     3.070    48.645     0.150
     3.070    87.254     0.150
     3.070    93.428     0.150
     3.631    54.543     0.150
     3.681    55.484     0.150
     3.681   111.242     0.150
     3.863    58.324     0.150
     3.865    58.113     0.150
     4.274    64.168     0.150
     4.308    63.533     0.150
     4.680    70.404     0.150
     4.680    70.580     0.150
     5.648    84.453     0.150
     6.497    95.314     0.150
     6.551   100.094     0.150
     6.819    99.373     0.150
     7.485   109.523     0.150
     7.550   111.953     0.150
     7.550   112.143     0.150
     7.609   111.023     0.150
     8.149   118.834     0.150
     8.937   128.244     0.150
     8.937   128.516     0.150
     9.869   142.693     0.150
     9.869   142.943     0.150
    11.029   159.623     0.150
     0.058     1.258     0.150
     0.113     1.969     0.150
     0.110     2.070     0.150
     0.199     3.656     0.150
     0.272     4.633     0.150
     0.286     4.578     0.150
     0.253     4.758     0.150
     0.253     8.500     0.150
     0.247     4.680     0.150
     0.247     8.578     0.150
     0.327     6.758     0.150
     0.477     9.469     0.150
     0.477    16.930     0.150
     0.561    11.227     0.150
     0.561    18.891     0.150
     0.579    10.445     0.150
     0.579    17.945     0.150
     0.742    13.320     0.150
     0.742    22.969     0.150
     0.738    13.500     0.150
     0.738    24.492     0.150
     0.812    15.117     0.150
     0.812    26.062     0.150
     0.903    15.500     0.150
     0.903    27.703     0.150
     0.903    15.711     0.150
     0.972    17.312     0.150
     1.034    17.664     0.150
     1.103    18.539     0.150
     1.103    33.023     0.150
     1.103    18.719     0.150
     1.103    33.211     0.150
     1.129    19.953     0.150
     1.129    34.336     0.150
     1.208    22.078     0.150
     1.209    22.039     0.150
     1.209    38.492     0.150
     1.211    22.211     0.150
     1.211    38.617     0.150
     1.350    22.344     0.150
     1.340    20.992     0.150
     1.340    39.781     0.150
     1.523    24.797     0.150
     1.506    25.000     0.150
     1.506    46.602     0.150
     1.591    25.977     0.150
     1.631    27.906     0.150
     1.631    48.930     0.150
     1.632    27.938     0.150
     1.632    49.203     0.150
     1.632    29.062     0.150
     1.857    30.453     0.150
     1.857    57.383     0.150
     2.124    33.617     0.150
     2.144    33.984     0.150
     2.212    34.711     0.150
     2.218    35.594     0.150
     2.218    67.219     0.150
     2.324    70.398     0.150
     2.346    71.391     0.150
     2.341    38.242     0.150
     2.341    66.953     0.150
     2.455    40.750     0.150
     2.480    39.859     0.150
     2.506    42.258     0.150
     2.506    69.930     0.150
     2.620    39.867     0.150
     2.620    39.977     0.150
     2.654    80.250     0.150
     2.768    42.531     0.150
     2.768    85.133     0.150
     2.773    42.766     0.150
     2.877    44.320     0.150
     2.877    86.930     0.150
     3.128    47.852     0.150
     3.128    94.328     0.150
     3.222    98.461     0.150
     3.670    55.273     0.150
     3.731    56.047     0.150
     3.731   114.391     0.150
     3.905    58.578     0.150
     4.247    62.922     0.150
     4.297    65.594     0.150
     4.297    65.359     0.150
     4.645    70.508     0.150
     4.645    69.398     0.150
     4.727    72.250     0.150
     4.987    75.328     0.150
     5.530    82.148     0.150
     5.603    84.062     0.150
     5.603    83.438     0.150
     5.681    83.828     0.150
     5.681   105.602     0.150
     5.681    84.570     0.150
     6.111    91.617     0.150
     6.111    91.023     0.150
     6.111   105.422     0.150
     6.201    94.828     0.150
     6.521    97.094     0.150
     6.541    97.883     0.150
     6.541   206.383     0.150
     6.545   100.594     0.150
     6.545   206.617     0.150
     6.546    95.617     0.150
     6.759    98.094     0.150
     6.759    98.422     0.150
     7.432   109.070     0.150
     7.516   110.688     0.150
     7.516   112.133     0.150
     7.526   109.711     0.150
     7.555   110.789     0.150
     7.594   112.688     0.150
     7.688   116.391     0.150
     7.728   114.000     0.150
     7.728   244.258     0.150
     7.807   113.578     0.150
     7.829   114.070     0.150
     7.843   115.156     0.150
     7.927   116.461     0.150
     7.960   118.188     0.150
     8.037   116.789     0.150
     8.037   249.727     0.150
     8.072   118.102     0.150
     8.083   118.227     0.150
     8.083   252.828     0.150
     8.098   117.477     0.150
     8.098   118.594     0.150
     8.543   126.562     0.150
     8.661   124.977     0.150
     8.877   127.844     0.150
     8.877   127.547     0.150
     8.918   130.789     0.150
     8.918   129.805     0.150
     9.143   135.344     0.150
     9.417   135.398     0.150
     9.584   137.867     0.150
     9.625   138.281     0.150
     9.664   141.211     0.150
     9.671   140.078     0.150
     9.826   143.125     0.150
     9.830   142.594     0.150
     9.830   142.164     0.150
     9.795   144.594     0.150
     9.795   313.297     0.150
    10.016   147.523     0.150
    10.061   146.883     0.150
    10.148   147.875     0.150
    10.208   149.430     0.150
    10.401   152.672     0.150
    10.478   153.430     0.150
    10.558   154.227     0.150
    10.600   155.680     0.150
    10.600   333.883     0.150
    10.685   155.719     0.150
    10.685   354.773     0.150
    10.685   155.594     0.150
    10.740   156.781     0.150
    10.874   158.758     0.150
    10.874   159.203     0.150
    10.941   160.648     0.150
    10.941   345.930     0.150
    10.919   157.250     0.150
    10.920   157.477     0.150
    10.974   159.250     0.150
    10.974   159.609     0.150
    11.175   159.148     0.150
    11.230   163.328     0.150
    11.221   160.930     0.150
    11.334   164.602     0.150
    11.372   165.641     0.150
    11.392   370.852     0.150
    11.583   170.609     0.150
    11.583   378.406     0.150
    11.600   166.609     0.150
    11.671   169.992     0.150
    11.759   169.977     0.150
    11.770   175.273     0.150
    11.776   169.070     0.150
    11.848   173.750     0.150
    11.870   170.539     0.150
    11.952   172.539     0.150
    11.952   173.047     0.150
    12.018   172.508     0.150
    12.083   175.203     0.150
    12.080   174.359     0.150
    12.189   177.328     0.150
    12.233   180.820     0.150
    12.269   179.648     0.150
    12.279   177.469     0.150
    12.333   178.094     0.150
    12.366   180.852     0.150
    12.378   178.883     0.150
    12.378   177.883     0.150
    12.406   181.312     0.150
    12.534   181.086     0.150
    12.568   183.289     0.150
    12.574   180.953     0.150
    12.619   183.812     0.150
    12.600   181.445     0.150
    12.722   182.148     0.150
    12.826   188.297     0.150
    12.926   189.594     0.150
    12.977   185.859     0.150
    12.998   189.273     0.150
    13.058   188.000     0.150
    13.085   189.133     0.150
    13.109   191.719     0.150
    13.258   190.828     0.150
    13.324   190.445     0.150
    13.374   192.547     0.150
    13.384   195.383     0.150
    13.397   195.359     0.150
    13.436   194.922     0.150
    13.443   193.125     0.150
    13.534   193.516     0.150
    13.574   198.211     0.150
    13.613   195.188     0.150
    13.613   194.977     0.150
    13.681   196.047     0.150
    13.686   195.312     0.150
    13.714   195.594     0.150
    13.730   197.062     0.150
    13.740   196.867     0.150
    13.805   198.273     0.150
    13.807   198.242     0.150
    13.883   198.859     0.150
    13.955   202.648     0.150
    13.966   199.828     0.150
    14.014   203.031     0.150
    14.073   201.727     0.150
    14.194   205.500     0.150
    14.224   207.453     0.150
    14.226   202.305     0.150
    14.265   206.672     0.150
    14.315   204.086     0.150
    14.300   203.773     0.150
    14.316   203.211     0.150
    14.312   203.680     0.150
    14.319   204.734     0.150
    14.330   204.352     0.150
    14.371   206.062     0.150
    14.346   204.625     0.150
    14.418   205.984     0.150
    14.537   209.219     0.150
    14.602   208.078     0.150
    14.672   210.773     0.150
    14.677   209.008     0.150
    14.671   208.578     0.150
    14.728   211.312     0.150
    14.809   212.523     0.150
    14.897   215.828     0.150
    14.932   211.562     0.150
    14.945   211.711     0.150
    14.958   212.172     0.150
    15.027   213.633     0.150
    15.042   214.398     0.150
    15.027   213.211     0.150
    15.049   217.711     0.150
    15.030   213.797     0.150
    15.048   213.797     0.150
    15.063   213.633     0.150
    15.090   214.367     0.150
    15.115   218.672     0.150
    15.115   520.758     0.150
    15.140   214.344     0.150
    15.177   215.969     0.150
    15.196   218.617     0.150
    15.248   218.180     0.150
    15.258   217.367     0.150
    15.262   219.273     0.150
    15.332   219.547     0.150
    15.443   219.250     0.150
    15.443   219.023     0.150
    15.497   219.695     0.150
    15.509   219.188     0.150
    15.509   219.562     0.150
    15.520   219.953     0.150
    15.520   220.211     0.150
    15.555   222.781     0.150
    15.557   222.734     0.150
    15.575   221.805     0.150
    15.622   222.148     0.150
    15.622   222.391     0.150
    15.810   224.766     0.150
    15.794   223.094     0.150
    15.812   223.891     0.150
    15.850   226.164     0.150
    15.881   227.367     0.150
    15.905   225.438     0.150
    15.905   225.227     0.150
    15.948   226.531     0.150
    16.015   225.250     0.150
    16.028   226.453     0.150
    16.093   228.594     0.150
    16.158   228.742     0.150
    16.225   229.562     0.150
    16.233   229.891     0.150
    16.396   231.117     0.150
    16.439   231.844     0.150
    16.445   234.344     0.150
    16.435   230.578     0.150
    16.524   236.500     0.150
    16.604   236.180     0.150
    16.609   236.172     0.150
    16.623   235.203     0.150
    16.659   235.891     0.150
    16.687   235.633     0.150
    16.773   237.016     0.150
    16.818   238.516     0.150
    16.811   236.250     0.150
    16.811   236.703     0.150
    16.845   236.609     0.150
    16.881   240.305     0.150
    16.920   239.945     0.150
    16.933   239.180     0.150
    16.934   238.148     0.150
    16.983   239.211     0.150
    17.094   242.594     0.150
    17.089   238.594     0.150
    17.132   241.570     0.150
    17.119   240.250     0.150
    17.249   243.086     0.150
    17.260   242.469     0.150
    17.271   242.328     0.150
    17.318   244.992     0.150
    17.476   245.219     0.150
    17.604   247.273     0.150
    17.621   247.094     0.150
    17.620   248.219     0.150
    17.765   250.156     0.150
    17.831   247.875     0.150
    17.922   250.797     0.150
    18.052   252.461     0.150
    18.079   252.211     0.150
    18.364   255.672     0.150
    18.536   257.992     0.150
    18.580   257.914     0.150
    18.598   258.102     0.150
    18.600   258.211     0.150
    18.649   259.531     0.150
    18.649   258.711     0.150
    18.842   262.102     0.150
    18.931   262.758     0.150
    19.228   266.016     0.150
    19.411   267.773     0.150
    19.506   269.859     0.150
    19.506   269.430     0.150
    19.594   269.984     0.150
    19.598   270.047     0.150
    19.952   273.430     0.150
    19.980   274.492     0.150
    20.064   275.148     0.150
    20.151   279.156     0.150
    20.450   278.992     0.150
    20.537   279.141     0.150
    20.629   280.922     0.150
    20.893   283.289     0.150
    21.228   287.141     0.150
    21.327   289.523     0.150
    21.672   292.000     0.150
    21.672   291.391     0.150
    21.757   293.219     0.150
    22.040   293.703     0.150
    22.940   303.977     0.150
    22.940   304.320     0.150
    23.245   308.672     0.150
    23.300   309.398     0.150
    24.128   316.383     0.150
    24.167   318.461     0.150
    24.242   318.180     0.150
    24.242   318.414     0.150
    24.425   321.266     0.150
    24.516   321.594     0.150
    26.603   340.703     0.150
    27.056   343.461     0.150
    27.342   346.242     0.150
    27.522   348.602     0.150
    27.522   350.320     0.150
    29.862   368.695     0.150
    29.911   369.461     0.150
    31.249   382.148     0.150
    33.162   399.062     0.150
    35.723   421.617     0.150
    35.910   423.438     0.150
    37.129   432.648     0.150
    37.322   435.258     0.150
    37.363   434.750     0.150
    37.609   438.430     0.150
    37.897   439.383     0.150
    37.963   440.211     0.150
    38.232   444.039     0.150
    38.761   448.297     0.150
    40.344   459.789     0.150
    40.669   460.422     0.150
    43.350   485.172     0.150
    55.404   575.398     0.150
    62.273   624.148     0.150
    62.649   627.891     0.150
    75.212   703.906     0.150
    77.173   715.031     0.150
    81.249   737.641     0.150
    81.739   742.352     0.150
    82.465   746.125     0.150
    84.129   754.602     0.150
    84.296   753.094     0.150
    85.610   760.500     0.150
    87.206   768.047     0.150
    91.435   786.867     0.150
    91.922   789.320     0.150
    94.795  1033.102     0.150
    94.795  1473.703     0.150
    94.795  1480.500     0.150
    97.519   816.000     0.150
   100.925   833.797     0.150
   102.197   834.297     0.150
   102.197   840.398     0.150
   106.531   857.602     0.150
   106.531  1120.797     0.150
   106.531  2022.703     0.150
   107.365  1541.898     0.150
   116.859  1127.250     0.150
   118.864  1129.859     0.150
   145.006  1178.461     0.150
     0.100     1.859     0.150
     0.133     2.281     0.150
     0.218     4.008     0.150
     0.234     4.477     0.150
     0.234     8.242     0.150
     0.244     4.375     0.150
     0.281     4.820     0.150
     0.303     5.102     0.150
     0.343     7.047     0.150
     0.478     8.461     0.150
     0.478     9.547     0.150
     0.478    15.242     0.150
     0.563    11.242     0.150
     0.563    18.812     0.150
     0.577    10.438     0.150
     0.577    17.891     0.150
     0.616    11.492     0.150
     0.720    13.273     0.150
     0.720    23.914     0.150
     0.733    13.367     0.150
     0.796    14.930     0.150
     0.796    25.398     0.150
     0.919    15.797     0.150
     0.919    28.617     0.150
     0.919    15.969     0.150
     0.919    28.016     0.150
     0.964    17.203     0.150
     1.053    17.961     0.150
     1.053    31.125     0.150
     1.113    18.742     0.150
     1.113    33.250     0.150
     1.113    18.930     0.150
     1.123    19.883     0.150
     1.123    34.203     0.150
     1.189    21.773     0.150
     1.190    21.719     0.150
     1.190    37.992     0.150
     1.192    21.961     0.150
     1.192    37.992     0.150
     1.330    21.969     0.150
     1.330    40.539     0.150
     1.365    22.648     0.150
     1.509    25.086     0.150
     1.542    25.180     0.150
     1.610    26.273     0.150
     1.616    27.820     0.150
     1.616    49.312     0.150
     1.618    27.977     0.150
     1.618    28.727     0.150
     1.618    54.078     0.150
     1.867    30.648     0.150
     2.141    33.750     0.150
     2.164    34.320     0.150
     2.223    35.312     0.150
     2.227    34.953     0.150
     2.340    36.711     0.150
     2.334    38.141     0.150
     2.440    38.242     0.150
     2.499    39.773     0.150
     2.509    41.953     0.150
     2.625    39.844     0.150
     2.625    40.008     0.150
     2.656    46.133     0.150
     2.781    42.648     0.150
     2.781    42.828     0.150
     2.884    44.477     0.150
     3.274    49.930     0.150
     3.532    53.781     0.150
     3.682    55.359     0.150
     3.739    56.180     0.150
     3.739    68.633     0.150
     3.915    59.055     0.150
     3.916    58.312     0.150
     4.191    63.578     0.150
     4.256    62.273     0.150
     4.313    64.898     0.150
     4.663    70.477     0.150
     5.544    82.250     0.150
     5.620    84.039     0.150
     5.698    83.430     0.150
     6.124    90.570     0.150
     6.205    92.094     0.150
     6.540    97.398     0.150
     6.555    95.344     0.150
     6.556   100.227     0.150
     6.561    99.359     0.150
     6.770    98.492     0.150
     6.770    98.797     0.150
     7.447   108.570     0.150
     7.534   111.477     0.150
     7.539   109.930     0.150
     7.614   114.281     0.150
     7.747   114.758     0.150
     7.843   113.938     0.150
     7.858   115.344     0.150
     7.914   118.891     0.150
     7.946   117.070     0.150
     8.056   119.547     0.150
     8.101   119.023     0.150
     8.101   252.945     0.150
     8.113   117.969     0.150
     8.113   252.352     0.150
     8.562   127.359     0.150
     8.680   127.961     0.150
     8.886   127.633     0.150
     8.886   128.133     0.150
     9.435   137.531     0.150
     9.593   140.789     0.150
     9.645   141.422     0.150
     9.682   139.969     0.150
     9.683   142.094     0.150
     9.786   143.938     0.150
     9.786   312.414     0.150
     9.844   143.867     0.150
     9.848   142.703     0.150
     9.848   143.164     0.150
    10.030   149.320     0.150
    10.053   146.102     0.150
    10.085   146.453     0.150
    10.610   156.234     0.150
    10.610   333.188     0.150
    10.756   155.742     0.150
    10.893   158.867     0.150
    10.925   157.344     0.150
    10.958   160.461     0.150
    10.987   158.859     0.150
    11.185   160.383     0.150
    11.232   160.695     0.150
    11.249   163.547     0.150
    11.391   167.523     0.150
    11.419   166.633     0.150
    11.445   166.570     0.150
    11.453   167.062     0.150
    11.483   168.047     0.150
    11.510   168.453     0.150
    11.690   170.828     0.150
    11.688   170.836     0.150
    11.778   172.062     0.150
    11.863   172.016     0.150
    11.867   174.383     0.150
    11.877   170.438     0.150
    11.966   171.133     0.150
    12.026   172.133     0.150
    12.052   174.070     0.150
    12.096   175.180     0.150
    12.102   177.398     0.150
    12.207   176.047     0.150
    12.233   178.977     0.150
    12.298   177.805     0.150
    12.296   181.141     0.150
    12.345   177.922     0.150
    12.384   181.828     0.150
    12.397   180.023     0.150
    12.425   181.883     0.150
    12.587   180.672     0.150
    12.608   180.875     0.150
    12.716   185.883     0.150
    12.739   182.617     0.150
    12.944   189.023     0.150
    12.997   187.680     0.150
    13.071   188.266     0.150
    13.094   188.758     0.150
    13.266   189.703     0.150
    13.302   192.281     0.150
    13.415   194.414     0.150
    13.587   198.203     0.150
    13.624   193.992     0.150
    13.690   194.938     0.150
    13.726   194.172     0.150
    13.739   196.000     0.150
    13.813   198.398     0.150
    13.816   195.883     0.150
    13.897   199.422     0.150
    13.960   199.391     0.150
    13.980   199.266     0.150
    14.029   203.188     0.150
    14.311   203.539     0.150
    14.324   203.422     0.150
    14.330   202.297     0.150
    14.389   207.367     0.150
    14.689   210.742     0.150
    14.734   211.625     0.150
    14.816   213.031     0.150
    14.914   215.750     0.150
    14.944   212.734     0.150
    14.956   212.656     0.150
    14.968   213.156     0.150
    15.036   213.922     0.150
    15.063   213.953     0.150
    15.103   215.828     0.150
    15.133   218.500     0.150
    15.213   218.180     0.150
    15.266   222.531     0.150
    15.331   219.594     0.150
    15.391   218.938     0.150
    15.524   218.688     0.150
    15.638   223.273     0.150
    15.638   222.914     0.150
    15.638   223.500     0.150
    15.660   222.547     0.150
    15.829   225.031     0.150
    15.888   225.047     0.150
    15.924   223.914     0.150
    15.960   226.617     0.150
    16.034   230.164     0.150
    16.463   234.211     0.150
    16.828   237.219     0.150
    16.935   240.156     0.150
    16.953   239.734     0.150
    16.996   239.570     0.150
    17.113   244.875     0.150
    17.203   243.625     0.150
    17.268   244.086     0.150
    17.280   239.047     0.150
    17.338   245.078     0.150
    17.624   247.359     0.150
    17.639   247.430     0.150
    17.639   248.180     0.150
    17.640   248.211     0.150
    17.784   251.000     0.150
    17.845   251.391     0.150
    17.941   252.750     0.150
    18.030   252.469     0.150
    18.099   252.492     0.150
    18.384   256.438     0.150
    18.522   258.117     0.150
    18.556   257.680     0.150
    18.599   258.070     0.150
    18.614   258.258     0.150
    18.668   259.320     0.150
    19.247   266.539     0.150
    19.526   270.164     0.150
    20.083   276.453     0.150
    20.470   280.508     0.150
    20.646   280.570     0.150
    20.912   283.961     0.150
    21.691   291.344     0.150
    21.691   292.094     0.150
    22.959   304.672     0.150
    24.147   316.203     0.150
    24.179   317.602     0.150
    24.424   321.141     0.150
    27.535   348.922     0.150
    29.879   369.078     0.150
    29.931   369.844     0.150
    33.977   403.977     0.150
    35.735   421.273     0.150
    36.834   429.312     0.150
    37.143   433.352     0.150
    37.374   434.477     0.150
    37.620   437.789     0.150
    37.907   439.117     0.150
    37.973   441.109     0.150
    40.356   459.578     0.150
    62.282   624.570     0.150
    62.655   627.844     0.150
    66.745   652.367     0.150
    77.192   716.391     0.150
    81.268   737.672     0.150
    81.745   741.836     0.150
    82.467   746.000     0.150
    84.120   754.156     0.150
    85.617   759.820     0.150
    91.401   789.555     0.150
    91.455   788.398     0.150
    91.937   789.578     0.150
    94.524   802.883     0.150
    97.524   815.523     0.150
   102.206   835.422     0.150
   102.206   839.820     0.150
   107.380  1541.023     0.150
   116.846  1125.969     0.150
   118.851  1129.422     0.150
     0.075     1.646     0.150
     0.092     1.926     0.150
     0.133     2.436     0.150
     0.133     5.075     0.150
     0.216     4.065     0.150
     0.228     4.485     0.150
     0.228     7.735     0.150
     0.236     4.603     0.150
     0.274     4.756     0.150
     0.299     4.862     0.150
     0.348     7.115     0.150
     0.487     9.646     0.150
     0.487    17.105     0.150
     0.487    18.875     0.150
     0.569    10.350     0.150
     0.569    17.655     0.150
     0.572    11.296     0.150
     0.572    18.336     0.150
     0.621    11.575     0.150
     0.705    13.125     0.150
     0.725    12.955     0.150
     0.725    22.455     0.150
     0.723    13.386     0.150
     0.723    23.336     0.150
     0.791    14.836     0.150
     0.791    25.405     0.150
     0.924    15.886     0.150
     0.924    28.025     0.150
     1.052    17.898     0.150
     1.106    18.676     0.150
     1.106    32.825     0.150
     1.115    19.740     0.150
     1.115    33.854     0.150
     1.187    21.436     0.150
     1.187    37.476     0.150
     1.189    21.355     0.150
     1.189    37.726     0.150
     1.194    21.936     0.150
     1.194    38.115     0.150
     1.337    21.596     0.150
     1.337    40.035     0.150
     1.337    43.306     0.150
     1.361    22.488     0.150
     1.500    24.864     0.150
     1.500    46.194     0.150
     1.544    25.109     0.150
     1.609    26.412     0.150
     1.622    27.936     0.150
     1.622    49.495     0.150
     1.623    27.815     0.150
     1.623    48.525     0.150
     1.623    28.936     0.150
     1.623    51.726     0.150
     1.730    27.889     0.150
     1.730    48.705     0.150
     1.859    57.734     0.150
     2.215    39.093     0.150
     2.215    66.671     0.150
     2.312    40.357     0.150
     2.312    69.846     0.150
     2.336    40.767     0.150
     2.450    40.405     0.150
     2.450    43.226     0.150
     2.450    44.886     0.150
     2.450    70.485     0.150
     2.450    75.275     0.150
     2.496    76.705     0.150
     2.500    43.296     0.150
     2.500    75.346     0.150
     2.514    38.797     0.150
     2.634    39.855     0.150
     2.634    48.006     0.150
     2.634    40.072     0.150
     2.648    46.004     0.150
     2.775    42.735     0.150
     2.775    49.995     0.150
     2.775    85.125     0.150
     2.876    86.632     0.150
     2.926    45.117     0.150
     3.123    48.665     0.150
     3.123    55.556     0.150
     3.123    96.476     0.150
     3.910    58.905     0.150
     3.910    71.186     0.150
     3.910   106.936     0.150
     3.910   121.216     0.150
     4.057    61.508     0.150
     4.263    63.056     0.150
     4.308    66.575     0.150
     4.666    70.775     0.150
     4.666    85.495     0.150
     4.666    70.522     0.150
     4.722    91.226     0.150
     5.242    78.047     0.150
     5.538   167.985     0.150
     5.625    84.466     0.150
     5.625   100.285     0.150
     5.625   172.115     0.150
     5.625    83.992     0.150
     6.118    89.820     0.150
     6.118   111.814     0.150
     6.540    96.665     0.150
     6.547    96.665     0.150
     6.549    95.806     0.150
     6.549   122.155     0.150
     6.549   205.926     0.150
     6.560    96.315     0.150
     6.560   205.676     0.150
     6.777    98.785     0.150
     6.777   216.955     0.150
     7.453   109.096     0.150
     7.537   111.436     0.150
     7.537   111.998     0.150
     7.546   110.275     0.150
     7.748   114.386     0.150
     7.748   200.756     0.150
     7.748   243.955     0.150
     7.912   114.966     0.150
     7.912   251.375     0.150
     8.059   118.065     0.150
     8.097   254.379     0.150
     8.097   151.945     0.150
     8.097   252.905     0.150
     8.119   118.366     0.150
     8.119   257.998     0.150
     8.119   117.815     0.150
     8.119   253.556     0.150
     8.893   128.355     0.150
     8.893   228.306     0.150
     8.893   128.228     0.150
     8.940   131.176     0.150
     9.686   142.655     0.150
    10.934   157.364     0.150
    10.993   156.955     0.150
    11.248   164.063     0.150
    15.634   222.877     0.150
    37.368   432.584     0.150
     0.062     1.574     0.150
     0.118     2.445     0.150
     0.134     2.635     0.150
     0.134     5.096     0.150
     0.198     3.926     0.150
     0.198     6.725     0.150
     0.177     3.754     0.150
     0.200     3.945     0.150
     0.200     7.145     0.150
     0.202     3.846     0.150
     0.537    10.426     0.150
     0.537    18.725     0.150
     0.622    11.975     0.150
     0.622    21.865     0.150
     0.647    12.025     0.150
     0.685    12.285     0.150
     0.685    21.244     0.150
     0.685    12.494     0.150
     0.753    13.814     0.150
     0.740    13.676     0.150
     0.772    14.355     0.150
     0.772    24.455     0.150
     0.772    25.084     0.150
     0.772    24.865     0.150
     0.914    16.275     0.150
     1.057    17.875     0.150
     1.057    31.855     0.150
     1.189    21.686     0.150
     1.189    37.645     0.150
     1.197    21.744     0.150
     1.197    37.824     0.150
     1.215    22.215     0.150
     1.215    38.785     0.150
     1.386    22.004     0.150
     1.386    41.404     0.150
     1.386    42.805     0.150
     1.664    28.484     0.150
     1.664    51.686     0.150
     1.665    29.686     0.150
     1.665    53.074     0.150
     2.397    41.635     0.150
     2.397    73.016     0.150
     2.448    42.535     0.150
     2.448    73.266     0.150
     2.680    40.346     0.150
     3.070    50.664     0.150
     3.863    58.115     0.150
     3.863    70.525     0.150
     3.863   120.926     0.150
     4.304    63.404     0.150
     5.661   105.154     0.150
     6.500   120.234     0.150
     6.500   206.375     0.150
     6.526    99.695     0.150
     6.546    99.875     0.150
     7.545   112.254     0.150
     8.062   119.176     0.150
     9.689   142.244     0.150
    94.745   802.365     0.150
    94.745  1032.465     0.150
    94.745  1432.865     0.150
    94.745  1472.965     0.150
    94.745  1858.965     0.150
   100.888   830.064     0.150
   102.148   833.266     0.150
   102.148   836.965     0.150
     0.230     4.477     0.150
     0.230     7.037     0.150
     0.230     4.736     0.150
     0.233     4.348     0.150
     0.233     7.367     0.150
     0.233     4.668     0.150
     0.599    10.848     0.150
     0.603    11.258     0.150
     0.622    12.178     0.150
     0.622    21.168     0.150
     0.622    20.928     0.150
     0.688    12.396     0.150
     0.690    12.877     0.150
     0.719    12.637     0.150
     0.716    12.736     0.150
     0.737    12.768     0.150
     0.737    22.967     0.150
     0.797    14.678     0.150
     0.797    24.977     0.150
     0.839    15.367     0.150
     0.839    26.486     0.150
     0.839    26.715     0.150
     1.082    20.236     0.150
     1.082    35.037     0.150
     1.148    21.008     0.150
     1.149    21.248     0.150
     1.149    37.438     0.150
     1.149    40.477     0.150
     1.184    20.986     0.150
     1.184    21.207     0.150
     1.184    36.977     0.150
     1.198    20.775     0.150
     1.198    37.344     0.150
     1.243    22.537     0.150
     1.243    39.807     0.150
     1.280    39.396     0.150
     1.280    22.248     0.150
     1.310    23.627     0.150
     1.310    41.057     0.150
     1.401    23.041     0.150
     1.401    39.748     0.150
     1.473    23.863     0.150
     1.473    42.756     0.150
     1.683    26.873     0.150
     1.683    48.920     0.150
     1.698    28.088     0.150
     1.698    51.416     0.150
     1.736    27.598     0.150
     1.736    53.672     0.150
     1.736    27.750     0.150
     1.909    30.760     0.150
     1.909    54.703     0.150
     1.969    31.141     0.150
     2.104    32.627     0.150
     2.104    38.986     0.150
     2.104    32.859     0.150
     2.104    59.172     0.150
     2.145    34.025     0.150
     2.145    66.203     0.150
     2.286    35.961     0.150
     2.315    36.383     0.150
     2.315    71.180     0.150
     2.488    39.824     0.150
     2.488    77.016     0.150
     2.612    40.219     0.150
     2.632    40.791     0.150
     2.861    44.455     0.150
     2.861    86.934     0.150
     2.874    44.242     0.150
     2.888    45.117     0.150
     2.888    56.367     0.150
     2.910    45.023     0.150
     3.094    54.117     0.150
     3.094    94.617     0.150
     3.128    48.449     0.150
     3.143    54.178     0.150
     3.143    95.088     0.150
     3.286    49.893     0.150
     3.359    52.258     0.150
     3.359    63.547     0.150
     3.519    53.934     0.150
     3.713    56.854     0.150
     3.806    56.117     0.150
     3.806    72.057     0.150
     3.806   120.037     0.150
     3.906    59.109     0.150
     4.081    61.775     0.150
     4.310    64.967     0.150
     4.310    81.047     0.150
     4.370    80.287     0.150
     4.370   137.957     0.150
     4.644    70.646     0.150
     5.466    81.828     0.150
     6.088    92.457     0.150
     6.154    90.236     0.150
     6.154   117.178     0.150
     6.347    92.258     0.150
     6.703    99.422     0.150
     6.781   102.896     0.150
     6.781   128.047     0.150
     6.800   102.928     0.150
     7.161   104.697     0.150
     7.234   105.527     0.150
     7.499   111.848     0.150
     7.856   114.848     0.150
     7.916   116.828     0.150
     8.421   121.037     0.150
     8.421   219.457     0.1