#!/bin/bash
gmt begin elmayor5.35_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-88/88/-88/88
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation elmayor5.35'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     5.387     5.387
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.126     3.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.864     2.302
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.941    -2.575
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.847    -4.812
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.159     1.294
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.470     3.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.311     3.181
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.874    -0.937
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.519     0.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.194     0.629
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.101     2.891
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.570    -0.165
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.456     0.080
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.763     1.890
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.893     2.326
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.571     3.603
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.464     6.635
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.464     6.635 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.735     5.983
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.735     5.983 18
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.886     2.898
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.251     1.602
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.072    -0.457
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.435     2.470
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.599     2.660
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.298     3.870
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.298     3.870 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.484     1.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.937     1.684
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.165     4.728
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.859    -1.274
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.169     4.361
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.922     1.139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.249    -0.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.232     7.259
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.232     7.259 32
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.254    -3.628
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.684     2.317
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.237    -2.326
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.098     0.217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.947    -1.129
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.947    -0.962
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.488     0.427
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.269    10.004
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.269    10.004 40
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.850     2.546
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.812     1.130
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.812     1.130 42
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.435     7.715
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.435     7.715 43
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.552     5.792
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.552     5.792 44
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.592     7.123
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.592     7.123 45
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.515     0.264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.195     1.855
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.420     4.538
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.420     4.538 48
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.043    -2.456
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.020     3.337
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.407    -1.022
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.600     3.791
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.573     8.976
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.573     8.976 53
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.111     0.900
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.151     3.766
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.605     1.663
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.841   -10.007
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.841   -10.007 57
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.342     3.255
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.392     4.554
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.625    -0.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.077    -0.487
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.246     1.020
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.636    -0.728
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.583     1.143
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.116     2.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.208     0.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.850     3.397
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.111     0.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.555     8.262
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.555     8.262 69
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.035     1.999
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.102     2.181
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.538    -0.485
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.867     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.606     2.263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.967     1.819
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.344     1.954
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.144     2.745
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.199     0.564
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.134     3.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.531     2.187
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.208     0.848
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.743    -3.495
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.389     0.648
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.379     2.328
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.214     2.065
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.187    -1.280
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.214     0.826
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.157    -0.045
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.392     0.329
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.097     5.583
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.097     5.583 90
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.470     1.445
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.090     2.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.139     1.994
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.604     3.110
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.716    -1.632
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.057     3.249
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.939    -4.832
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.883    -0.140
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.207    -1.689
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.249     0.398
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.131     1.605
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.329     3.860
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.583     0.563
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.098     1.115
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.194    -0.320
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.232    -1.091
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.891    -1.182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.417     4.187
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.504     0.547
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.802     2.623
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.071     2.297
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.244    -1.384
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.942     2.331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.624     1.714
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.162     0.844
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.156     1.472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.265     2.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.060    -1.708
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.298    -0.331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.791     2.299
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.467    -2.144
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.319     2.319
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.750     3.376
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.259     2.467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.408    -2.476
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.187     3.573
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.058     0.130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.744    -0.624
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.705     0.795
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.051     1.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.346     2.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.692     1.358
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.922     2.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.028    -5.290
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.028    -5.290 134
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.519    -0.949
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.511     0.548
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.931     1.751
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.233    -0.512
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.235     0.524
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.801     2.991
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.141     1.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.050    -0.735
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.148     1.692
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.213    -0.418
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.854     1.266
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.190     1.807
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.072     0.328
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.590     5.611
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.590     5.611 148
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.803     1.409
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.549     4.499
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.337     0.715
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.521    -2.094
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.539     3.070
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.539     3.070 153
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.601    -0.520
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.552     1.607
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.753     3.875
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.748     0.386
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.152     1.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.185     0.273
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.946     0.069
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.348     3.705
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.045     1.739
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.101     2.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.011    -0.283
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.191     3.642
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.237     2.160
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.868     3.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.841     2.194
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.136     0.037
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.226     0.091
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.881    -1.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.178     3.486
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.090     1.406
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.090     1.406 173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.771     3.964
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.693    -1.250
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.322     1.959
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.477    -1.849
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.850     1.326
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.733    -3.498
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.212     3.406
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.073     1.234
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.406     0.600
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.007     2.372
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.263     2.186
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.016     1.507
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.578     1.313
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.066     0.540
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.304    -0.608
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.436     0.699
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.328     1.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.961     1.425
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.945     3.527
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.680     2.726
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.324     2.044
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.062     1.187
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.100     1.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     3.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.005     4.730
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.998     3.479
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.731     3.440
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.039     2.232
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -44.840   -74.626
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -44.840   -74.626 202
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.730     3.757
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.177     4.464
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.275     1.956
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.003     4.957
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.536     6.123
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.536     6.123 207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.381    -9.824
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.381    -9.824 208
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.670     2.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.063     3.301
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.558     0.451
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.066    -4.276
EOF
gmt plot $proj $reg -SE -Gred << EOF
     0.345     1.076     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -86.000    86.000 Author: all ( 212 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -86.000   -86.000 Average =   1.1 km at  17.8 deg; median =    2.7 km
EOF
gmt end
