#!/bin/bash
gmt begin elmayor5.35_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-15/19/0/24
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation elmayor5.35' << EOF
    -6.900
    11.100
    -5.800
    -1.600
     7.100
     4.100
     4.200
    -3.000
    -0.900
    -0.500
    -1.300
    -0.700
     2.100
     0.800
    -0.400
    -5.000
    -6.000
    -4.200
     1.300
    -1.300
    -6.400
     2.200
    13.700
    -2.000
    10.700
     2.800
     1.400
     1.100
     1.700
     4.700
    -0.000
    -6.300
     5.000
     4.300
     0.300
     1.100
     3.200
     4.300
    -1.000
    -5.400
    -1.100
    -5.500
    -3.100
    -8.200
    -3.500
     0.300
    -9.000
    -5.800
    -1.300
     1.900
    -8.400
     1.900
    -1.700
    -0.700
   -10.100
    -7.000
     0.300
     0.300
    -4.600
    -7.300
    -8.200
    -4.500
    -1.100
    -3.700
     0.700
    -2.500
    -2.400
     4.800
     2.600
     1.600
    -4.900
     3.000
    -0.700
    -2.100
     4.400
     1.600
     4.400
     2.100
     5.900
    -0.600
    -9.000
    -8.900
     3.100
    -4.300
    -9.400
    -9.400
     3.700
    -2.500
    -6.500
    -1.600
     2.700
    -0.400
    -1.500
     0.300
    -1.000
     3.400
     3.800
    -4.200
    -6.800
     4.100
     3.500
     3.000
     2.600
     4.700
     5.300
    -3.200
    -0.700
    -3.600
     0.200
     5.500
     2.100
     1.700
     4.500
     3.200
     4.600
     5.000
     5.900
     1.100
     0.200
    -0.700
     3.100
    -6.200
     4.300
     4.900
     2.600
     5.700
     2.300
     4.500
     1.800
     6.500
    -0.100
     5.000
    -0.000
     5.000
    -0.900
     3.000
     2.700
    -0.400
     4.500
     8.400
     4.400
     4.500
     1.700
    -1.600
     4.700
    -6.200
     0.900
     1.200
    -5.000
     0.200
     0.100
     6.500
    10.600
     7.200
    -4.500
    -0.400
    -0.800
    -5.700
    -8.000
     3.900
     6.700
    -2.400
     1.100
     0.700
     3.100
    11.800
     4.900
    -5.700
     1.500
    -2.100
    -4.000
     9.700
    -5.700
    -2.500
    -1.900
    -2.800
     0.700
     0.700
     2.100
     6.400
     3.000
     3.400
    -1.300
    -2.700
     4.600
     3.900
     2.900
     2.000
     5.000
     1.300
     2.100
     5.100
     2.700
     5.500
    -1.600
     1.000
     3.500
     5.700
     6.400
     3.900
     1.400
    -5.700
    -7.300
    -5.600
    -2.000
    -6.000
    -0.500
    -2.000
    -4.000
     5.600
    -1.100
     0.600
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.700    21.260 Median =   0.7 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.7  0.
  0.7  20.8
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -14.000    22.740 Author: all ( 212 samples)
EOF
gmt end
