#!/bin/bash
gmt begin elmayor5.35_dcal pdf,ps
proj=-JM16.0c+
reg=-R-118.6/-112.8/30.0/34.8
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration elmayor5.35'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -115.242    32.487
  -115.266    32.385
>
  -115.242    32.487
  -115.266    32.385
>
  -115.187    32.355
  -115.266    32.385
>
  -114.960    32.164
  -115.266    32.385
>
  -114.985    32.739
  -115.266    32.385
>
  -115.725    32.649
  -115.266    32.385
>
  -115.725    32.649
  -115.279    32.372
>
  -114.985    32.739
  -115.219    32.387
>
  -115.725    32.649
  -115.219    32.387
>
  -115.663    32.743
  -115.219    32.387
>
  -115.732    32.759
  -115.219    32.387
>
  -115.725    32.649
  -115.244    32.398
>
  -116.101    32.659
  -116.047    32.684
>
  -116.101    32.659
  -116.047    32.684
>
  -116.079    32.603
  -116.047    32.684
>
  -116.079    32.603
  -116.047    32.684
>
  -115.923    32.648
  -116.047    32.684
>
  -115.969    32.887
  -116.047    32.684
>
  -115.725    32.649
  -116.047    32.684
>
  -115.727    32.849
  -116.047    32.684
>
  -115.800    32.945
  -116.047    32.684
>
  -115.800    32.945
  -116.047    32.684
>
  -116.422    32.892
  -116.047    32.684
>
  -116.422    32.892
  -116.047    32.684
>
  -116.672    32.680
  -116.047    32.684
>
  -115.923    32.648
  -115.965    32.797
>
  -115.800    32.945
  -115.965    32.797
>
  -115.800    32.945
  -115.965    32.797
>
  -116.101    32.659
  -115.965    32.797
>
  -116.101    32.659
  -115.965    32.797
>
  -115.727    32.849
  -115.965    32.797
>
  -116.079    32.603
  -115.965    32.797
>
  -116.079    32.603
  -115.965    32.797
>
  -115.725    32.649
  -115.965    32.797
>
  -116.422    32.892
  -115.965    32.797
>
  -116.422    32.892
  -115.965    32.797
>
  -116.101    32.659
  -116.038    32.675
>
  -116.101    32.659
  -116.038    32.675
>
  -116.079    32.603
  -116.038    32.675
>
  -116.079    32.603
  -116.038    32.675
>
  -115.923    32.648
  -116.038    32.675
>
  -115.969    32.887
  -116.038    32.675
>
  -115.732    32.759
  -116.038    32.675
>
  -115.725    32.649
  -116.038    32.675
>
  -115.727    32.849
  -116.038    32.675
>
  -115.800    32.945
  -116.038    32.675
>
  -116.422    32.892
  -116.038    32.675
>
  -116.672    32.680
  -116.038    32.675
>
  -116.672    32.680
  -116.038    32.675
>
  -116.672    32.680
  -116.038    32.675
>
  -115.304    32.418
  -115.313    32.451
>
  -115.242    32.487
  -115.313    32.451
>
  -115.187    32.355
  -115.313    32.451
>
  -115.725    32.649
  -115.313    32.451
>
  -115.437    32.862
  -115.313    32.451
>
  -115.123    32.863
  -115.313    32.451
>
  -115.242    31.988
  -115.313    32.451
>
  -115.727    32.849
  -115.313    32.451
>
  -115.923    32.648
  -115.313    32.451
>
  -115.220    33.012
  -115.313    32.451
>
  -115.304    32.418
  -115.312    32.441
>
  -115.304    32.418
  -115.312    32.441
>
  -115.242    32.487
  -115.312    32.441
>
  -115.242    32.487
  -115.312    32.441
>
  -115.187    32.355
  -115.312    32.441
>
  -115.725    32.649
  -115.312    32.441
>
  -115.437    32.862
  -115.312    32.441
>
  -115.123    32.863
  -115.312    32.441
>
  -115.242    31.988
  -115.312    32.441
>
  -115.242    31.988
  -115.312    32.441
>
  -115.727    32.849
  -115.312    32.441
>
  -115.923    32.648
  -115.312    32.441
>
  -115.304    32.418
  -115.329    32.459
>
  -115.304    32.418
  -115.329    32.459
>
  -115.725    32.649
  -115.329    32.459
>
  -115.437    32.862
  -115.329    32.459
>
  -115.123    32.863
  -115.329    32.459
>
  -115.242    31.988
  -115.329    32.459
>
  -115.242    31.988
  -115.329    32.459
>
  -115.727    32.849
  -115.329    32.459
>
  -115.923    32.648
  -115.329    32.459
>
  -115.304    32.418
  -115.334    32.445
>
  -115.242    32.487
  -115.334    32.445
>
  -115.187    32.355
  -115.334    32.445
>
  -115.437    32.862
  -115.334    32.445
>
  -115.123    32.863
  -115.334    32.445
>
  -115.242    31.988
  -115.334    32.445
>
  -115.923    32.648
  -115.334    32.445
>
  -115.304    32.418
  -115.327    32.459
>
  -115.304    32.418
  -115.327    32.459
>
  -115.437    32.862
  -115.327    32.459
>
  -115.123    32.863
  -115.327    32.459
>
  -115.242    31.988
  -115.327    32.459
>
  -115.242    31.988
  -115.327    32.459
>
  -115.923    32.648
  -115.327    32.459
>
  -115.304    32.418
  -115.334    32.455
>
  -115.304    32.418
  -115.334    32.455
>
  -115.437    32.862
  -115.334    32.455
>
  -115.123    32.863
  -115.334    32.455
>
  -115.242    31.988
  -115.334    32.455
>
  -115.242    31.988
  -115.334    32.455
>
  -115.242    31.988
  -115.334    32.455
>
  -115.923    32.648
  -115.334    32.455
>
  -115.304    32.418
  -115.313    32.448
>
  -115.304    32.418
  -115.313    32.448
>
  -115.304    32.418
  -115.313    32.448
>
  -115.725    32.649
  -115.313    32.448
>
  -115.123    32.863
  -115.313    32.448
>
  -115.242    31.988
  -115.313    32.448
>
  -115.242    31.988
  -115.313    32.448
>
  -115.242    31.988
  -115.313    32.448
>
  -115.727    32.849
  -115.313    32.448
>
  -115.923    32.648
  -115.313    32.448
>
  -115.304    32.418
  -115.321    32.445
>
  -115.304    32.418
  -115.321    32.445
>
  -115.725    32.649
  -115.321    32.445
>
  -115.437    32.862
  -115.321    32.445
>
  -115.123    32.863
  -115.321    32.445
>
  -115.242    31.988
  -115.321    32.445
>
  -115.242    31.988
  -115.321    32.445
>
  -115.242    31.988
  -115.321    32.445
>
  -115.727    32.849
  -115.321    32.445
>
  -115.923    32.648
  -115.321    32.445
>
  -115.304    32.418
  -115.336    32.456
>
  -115.242    32.487
  -115.336    32.456
>
  -115.187    32.355
  -115.336    32.456
>
  -115.725    32.649
  -115.336    32.456
>
  -115.437    32.862
  -115.336    32.456
>
  -115.123    32.863
  -115.336    32.456
>
  -115.727    32.849
  -115.336    32.456
>
  -115.923    32.648
  -115.336    32.456
>
  -115.725    32.649
  -115.341    32.451
>
  -115.437    32.862
  -115.341    32.451
>
  -115.123    32.863
  -115.341    32.451
>
  -115.727    32.849
  -115.341    32.451
>
  -115.923    32.648
  -115.341    32.451
>
  -115.304    32.418
  -115.316    32.403
>
  -115.304    32.418
  -115.316    32.403
>
  -115.304    32.418
  -115.316    32.403
>
  -115.242    32.487
  -115.316    32.403
>
  -115.187    32.355
  -115.316    32.403
>
  -115.725    32.649
  -115.316    32.403
>
  -115.663    32.743
  -115.316    32.403
>
  -115.123    32.863
  -115.316    32.403
>
  -115.727    32.849
  -115.316    32.403
>
  -115.923    32.648
  -115.316    32.403
>
  -114.985    32.739
  -115.245    32.394
>
  -115.242    31.988
  -115.245    32.394
>
  -115.242    31.988
  -115.245    32.394
>
  -115.123    32.863
  -115.245    32.394
>
  -115.725    32.649
  -115.245    32.394
>
  -115.437    32.862
  -115.245    32.394
>
  -115.663    32.743
  -115.245    32.394
>
  -114.580    32.536
  -115.245    32.394
>
  -114.580    32.536
  -115.245    32.394
>
  -115.304    32.418
  -115.344    32.221
>
  -115.304    32.418
  -115.344    32.221
>
  -115.242    31.988
  -115.344    32.221
>
  -115.242    31.988
  -115.344    32.221
>
  -115.725    32.649
  -115.344    32.221
>
  -115.942    31.928
  -115.344    32.221
>
  -115.942    31.928
  -115.344    32.221
>
  -115.304    32.418
  -115.263    32.368
>
  -115.725    32.649
  -115.263    32.368
>
  -115.123    32.863
  -115.263    32.368
>
  -115.437    32.862
  -115.263    32.368
>
  -115.304    32.418
  -115.372    32.401
>
  -115.242    32.487
  -115.372    32.401
>
  -115.242    32.487
  -115.372    32.401
>
  -115.187    32.355
  -115.372    32.401
>
  -115.725    32.649
  -115.372    32.401
>
  -115.437    32.862
  -115.372    32.401
>
  -115.123    32.863
  -115.372    32.401
>
  -115.923    32.648
  -115.372    32.401
>
  -115.727    32.849
  -115.372    32.401
>
  -115.725    32.649
  -115.514    32.538
>
  -115.437    32.862
  -115.514    32.538
>
  -115.727    32.849
  -115.514    32.538
>
  -115.923    32.648
  -115.514    32.538
>
  -115.123    32.863
  -115.514    32.538
>
  -116.079    32.603
  -115.514    32.538
>
  -116.079    32.603
  -115.514    32.538
>
  -115.969    32.887
  -115.514    32.538
>
  -115.304    32.418
  -115.263    32.340
>
  -115.123    32.863
  -115.263    32.340
>
  -115.725    32.649
  -115.263    32.340
>
  -115.437    32.862
  -115.263    32.340
>
  -115.942    31.928
  -115.719    32.114
>
  -115.942    31.928
  -115.719    32.114
>
  -115.304    32.418
  -115.719    32.114
>
  -115.725    32.649
  -115.719    32.114
>
  -115.923    32.648
  -115.719    32.114
>
  -115.304    32.418
  -115.287    32.374
>
  -115.198    32.407
  -115.287    32.374
>
  -115.187    32.355
  -115.287    32.374
>
  -115.187    32.355
  -115.287    32.374
>
  -115.242    32.487
  -115.287    32.374
>
  -115.242    32.487
  -115.287    32.374
>
  -114.985    32.739
  -115.287    32.374
>
  -115.725    32.649
  -115.287    32.374
>
  -114.705    32.456
  -115.287    32.374
>
  -114.705    32.456
  -115.287    32.374
>
  -115.663    32.743
  -115.287    32.374
>
  -115.123    32.863
  -115.287    32.374
>
  -115.304    32.418
  -115.286    32.357
>
  -115.198    32.407
  -115.286    32.357
>
  -115.242    32.487
  -115.286    32.357
>
  -115.242    32.487
  -115.286    32.357
>
  -115.187    32.355
  -115.286    32.357
>
  -115.187    32.355
  -115.286    32.357
>
  -114.985    32.739
  -115.286    32.357
>
  -115.447    32.805
  -115.286    32.357
>
  -115.663    32.743
  -115.286    32.357
>
  -115.123    32.863
  -115.286    32.357
>
  -114.705    32.456
  -115.286    32.357
>
  -114.705    32.456
  -115.286    32.357
>
  -115.242    31.988
  -115.344    32.194
>
  -115.242    31.988
  -115.344    32.194
>
  -115.304    32.418
  -115.344    32.194
>
  -115.304    32.418
  -115.344    32.194
>
  -115.942    31.928
  -115.344    32.194
>
  -115.942    31.928
  -115.344    32.194
>
  -115.727    32.849
  -115.645    32.667
>
  -115.923    32.648
  -115.645    32.667
>
  -115.800    32.945
  -115.645    32.667
>
  -115.969    32.887
  -115.645    32.667
>
  -116.079    32.603
  -115.645    32.667
>
  -116.079    32.603
  -115.645    32.667
>
  -116.079    32.603
  -115.645    32.667
>
  -116.101    32.659
  -115.645    32.667
>
  -116.101    32.659
  -115.645    32.667
>
  -115.304    32.418
  -115.645    32.667
>
  -115.304    32.418
  -115.645    32.667
>
  -115.123    32.863
  -115.645    32.667
>
  -115.198    32.407
  -115.645    32.667
>
  -115.198    32.407
  -115.645    32.667
>
  -115.923    32.648
  -115.831    32.692
>
  -115.725    32.649
  -115.831    32.692
>
  -115.727    32.849
  -115.831    32.692
>
  -116.101    32.659
  -115.831    32.692
>
  -115.800    32.945
  -115.831    32.692
>
  -115.800    32.945
  -115.831    32.692
>
  -116.423    32.893
  -115.831    32.692
>
  -116.423    32.893
  -115.831    32.692
>
  -116.422    32.892
  -115.831    32.692
>
  -116.422    32.892
  -115.831    32.692
>
  -115.304    32.418
  -115.831    32.692
>
  -115.304    32.418
  -115.831    32.692
>
  -115.304    32.418
  -115.130    32.396
>
  -115.304    32.418
  -115.130    32.396
>
  -115.242    31.988
  -115.130    32.396
>
  -115.242    31.988
  -115.130    32.396
>
  -115.123    32.863
  -115.130    32.396
>
  -114.545    32.555
  -115.130    32.396
>
  -115.725    32.649
  -115.130    32.396
>
  -115.304    32.418
  -115.208    32.442
>
  -115.304    32.418
  -115.208    32.442
>
  -115.198    32.407
  -115.208    32.442
>
  -115.198    32.407
  -115.208    32.442
>
  -114.985    32.739
  -115.208    32.442
>
  -115.663    32.743
  -115.208    32.442
>
  -115.725    32.649
  -115.208    32.442
>
  -115.732    32.759
  -115.208    32.442
>
  -115.220    33.012
  -115.208    32.442
>
  -114.977    32.972
  -115.208    32.442
>
  -115.242    31.988
  -115.208    32.442
>
  -115.727    32.849
  -115.208    32.442
>
  -114.545    32.555
  -115.208    32.442
>
  -115.304    32.418
  -115.213    32.483
>
  -115.304    32.418
  -115.213    32.483
>
  -114.985    32.739
  -115.213    32.483
>
  -114.705    32.456
  -115.213    32.483
>
  -114.705    32.456
  -115.213    32.483
>
  -115.242    31.988
  -115.213    32.483
>
  -115.242    31.988
  -115.213    32.483
>
  -115.725    32.649
  -115.213    32.483
>
  -115.663    32.743
  -115.213    32.483
>
  -115.732    32.759
  -115.213    32.483
>
  -115.220    33.012
  -115.213    32.483
>
  -115.220    33.012
  -115.213    32.483
>
  -114.545    32.555
  -115.213    32.483
>
  -115.198    32.407
  -115.190    32.386
>
  -115.198    32.407
  -115.190    32.386
>
  -115.304    32.418
  -115.190    32.386
>
  -115.304    32.418
  -115.190    32.386
>
  -114.705    32.456
  -115.190    32.386
>
  -114.705    32.456
  -115.190    32.386
>
  -115.242    31.988
  -115.190    32.386
>
  -115.242    31.988
  -115.190    32.386
>
  -115.725    32.649
  -115.190    32.386
>
  -114.545    32.555
  -115.190    32.386
>
  -115.304    32.418
  -115.294    32.290
>
  -115.304    32.418
  -115.294    32.290
>
  -115.198    32.407
  -115.294    32.290
>
  -115.198    32.407
  -115.294    32.290
>
  -115.725    32.649
  -115.294    32.290
>
  -115.123    32.863
  -115.294    32.290
>
  -115.198    32.407
  -115.293    32.289
>
  -115.304    32.418
  -115.293    32.289
>
  -115.304    32.418
  -115.293    32.289
>
  -115.304    32.418
  -115.259    32.355
>
  -115.304    32.418
  -115.259    32.355
>
  -115.242    31.988
  -115.259    32.355
>
  -115.304    32.418
  -115.302    32.274
>
  -115.304    32.418
  -115.302    32.274
>
  -115.198    32.407
  -115.302    32.274
>
  -115.198    32.407
  -115.302    32.274
>
  -115.242    31.988
  -115.302    32.274
>
  -115.242    31.988
  -115.302    32.274
>
  -115.304    32.418
  -115.298    32.269
>
  -115.198    32.407
  -115.298    32.269
>
  -115.198    32.407
  -115.298    32.269
>
  -115.242    32.487
  -115.298    32.269
>
  -115.242    31.988
  -115.298    32.269
>
  -114.960    32.164
  -115.298    32.269
>
  -114.985    32.739
  -115.298    32.269
>
  -115.725    32.649
  -115.298    32.269
>
  -115.447    32.805
  -115.298    32.269
>
  -115.663    32.743
  -115.298    32.269
>
  -115.198    32.407
  -115.202    32.176
>
  -115.198    32.407
  -115.202    32.176
>
  -115.242    31.988
  -115.202    32.176
>
  -115.242    31.988
  -115.202    32.176
>
  -115.198    32.407
  -115.291    32.203
>
  -115.198    32.407
  -115.291    32.203
>
  -115.725    32.649
  -115.291    32.203
>
  -115.198    32.407
  -115.381    32.277
>
  -115.198    32.407
  -115.381    32.277
>
  -115.242    31.988
  -115.381    32.277
>
  -115.242    31.988
  -115.381    32.277
>
  -115.447    32.805
  -115.381    32.277
>
  -115.663    32.743
  -115.381    32.277
>
  -115.732    32.759
  -115.381    32.277
>
  -115.923    32.648
  -115.381    32.277
>
  -115.198    32.407
  -115.566    32.425
>
  -115.732    32.759
  -115.566    32.425
>
  -115.923    32.648
  -115.566    32.425
>
  -115.727    32.849
  -115.566    32.425
>
  -115.800    32.945
  -115.566    32.425
>
  -115.123    32.863
  -115.566    32.425
>
  -115.969    32.887
  -115.566    32.425
>
  -115.242    31.988
  -115.031    31.939
>
  -115.242    31.988
  -115.031    31.939
>
  -115.198    32.407
  -115.031    31.939
>
  -115.198    32.407
  -115.031    31.939
>
  -115.198    32.407
  -115.376    32.311
>
  -115.447    32.805
  -115.376    32.311
>
  -115.447    32.805
  -115.376    32.311
>
  -115.663    32.743
  -115.376    32.311
>
  -115.732    32.759
  -115.376    32.311
>
  -115.732    32.759
  -115.376    32.311
>
  -115.198    32.407
  -115.429    32.295
>
  -115.198    32.407
  -115.429    32.295
>
  -115.242    31.988
  -115.234    32.136
>
  -115.242    31.988
  -115.234    32.136
>
  -115.198    32.407
  -115.234    32.136
>
  -115.198    32.407
  -115.234    32.136
>
  -115.198    32.407
  -115.232    32.187
>
  -115.727    32.849
  -115.751    32.580
>
  -115.800    32.945
  -115.751    32.580
>
  -115.800    32.945
  -115.751    32.580
>
  -115.198    32.407
  -115.751    32.580
>
  -115.198    32.407
  -115.751    32.580
>
  -115.727    32.849
  -115.630    32.493
>
  -115.800    32.945
  -115.630    32.493
>
  -115.800    32.945
  -115.630    32.493
>
  -115.969    32.887
  -115.630    32.493
>
  -115.123    32.863
  -115.630    32.493
>
  -115.727    32.849
  -115.784    32.621
>
  -115.969    32.887
  -115.784    32.621
>
  -115.800    32.945
  -115.784    32.621
>
  -114.985    32.739
  -115.285    32.203
>
  -115.242    31.988
  -115.087    32.029
>
  -115.051    31.472
  -115.087    32.029
>
  -115.051    31.472
  -115.087    32.029
>
  -115.923    32.648
  -115.784    32.624
>
  -115.727    32.849
  -115.784    32.624
>
  -115.969    32.887
  -115.784    32.624
>
  -115.800    32.945
  -115.784    32.624
>
  -115.800    32.945
  -115.784    32.624
>
  -115.242    31.988
  -115.348    32.297
>
  -115.242    31.988
  -115.348    32.297
>
  -115.725    32.649
  -115.348    32.297
>
  -115.923    32.648
  -115.348    32.297
>
  -115.725    32.649
  -115.803    32.669
>
  -115.923    32.648
  -115.803    32.669
>
  -115.727    32.849
  -115.803    32.669
>
  -115.969    32.887
  -115.803    32.669
>
  -115.800    32.945
  -115.803    32.669
>
  -115.447    32.805
  -115.803    32.669
>
  -116.252    32.900
  -115.803    32.669
>
  -116.422    32.892
  -115.803    32.669
>
  -116.422    32.892
  -115.803    32.669
>
  -115.732    32.759
  -115.771    32.632
>
  -115.727    32.849
  -115.771    32.632
>
  -115.969    32.887
  -115.771    32.632
>
  -115.800    32.945
  -115.771    32.632
>
  -115.800    32.945
  -115.771    32.632
>
  -115.447    32.805
  -115.771    32.632
>
  -115.304    32.418
  -115.771    32.632
>
  -115.304    32.418
  -115.771    32.632
>
  -115.123    32.863
  -115.771    32.632
>
  -115.242    31.988
  -115.270    32.182
>
  -115.242    31.988
  -115.270    32.182
>
  -115.304    32.418
  -115.270    32.182
>
  -115.304    32.418
  -115.270    32.182
>
  -115.242    31.988
  -115.212    32.143
>
  -115.242    31.988
  -115.212    32.143
>
  -115.304    32.418
  -115.212    32.143
>
  -115.242    31.988
  -115.108    32.059
>
  -115.242    31.988
  -115.108    32.059
>
  -115.304    32.418
  -115.108    32.059
>
  -115.304    32.418
  -115.108    32.059
>
  -115.051    31.472
  -115.108    32.059
>
  -115.051    31.472
  -115.108    32.059
>
  -115.304    32.418
  -115.337    32.294
>
  -115.304    32.418
  -115.337    32.294
>
  -115.242    31.988
  -115.337    32.294
>
  -115.242    31.988
  -115.337    32.294
>
  -115.725    32.649
  -115.337    32.294
>
  -115.123    32.863
  -115.337    32.294
>
  -115.923    32.648
  -115.756    32.593
>
  -115.727    32.849
  -115.756    32.593
>
  -116.079    32.603
  -115.756    32.593
>
  -116.079    32.603
  -115.756    32.593
>
  -115.800    32.945
  -115.756    32.593
>
  -115.800    32.945
  -115.756    32.593
>
  -115.304    32.418
  -115.756    32.593
>
  -115.663    32.743
  -115.788    32.645
>
  -115.727    32.849
  -115.788    32.645
>
  -116.079    32.603
  -115.788    32.645
>
  -116.079    32.603
  -115.788    32.645
>
  -115.969    32.887
  -115.788    32.645
>
  -115.800    32.945
  -115.788    32.645
>
  -115.800    32.945
  -115.788    32.645
>
  -115.304    32.418
  -115.788    32.645
>
  -116.422    32.892
  -115.788    32.645
>
  -116.422    32.892
  -115.788    32.645
>
  -115.242    31.988
  -115.308    32.201
>
  -115.242    31.988
  -115.308    32.201
>
  -115.304    32.418
  -115.308    32.201
>
  -115.304    32.418
  -115.308    32.201
>
  -115.242    31.988
  -115.080    32.059
>
  -115.242    31.988
  -115.080    32.059
>
  -115.304    32.418
  -115.080    32.059
>
  -115.051    31.472
  -115.080    32.059
>
  -115.051    31.472
  -115.080    32.059
>
  -115.923    32.648
  -115.731    32.605
>
  -115.727    32.849
  -115.731    32.605
>
  -116.079    32.603
  -115.731    32.605
>
  -116.079    32.603
  -115.731    32.605
>
  -115.800    32.945
  -115.731    32.605
>
  -115.800    32.945
  -115.731    32.605
>
  -115.969    32.887
  -115.731    32.605
>
  -115.198    32.407
  -115.731    32.605
>
  -115.198    32.407
  -115.731    32.605
>
  -115.242    31.988
  -115.046    31.983
>
  -115.198    32.407
  -115.046    31.983
>
  -115.304    32.418
  -115.046    31.983
>
  -115.732    32.759
  -115.894    32.696
>
  -115.969    32.887
  -115.894    32.696
>
  -116.079    32.603
  -115.894    32.696
>
  -116.079    32.603
  -115.894    32.696
>
  -115.727    32.849
  -115.894    32.696
>
  -115.800    32.945
  -115.894    32.696
>
  -115.800    32.945
  -115.894    32.696
>
  -115.800    32.945
  -115.894    32.696
>
  -115.823    33.117
  -115.894    32.696
>
  -116.422    32.892
  -115.894    32.696
>
  -116.422    32.892
  -115.894    32.696
>
  -115.304    32.418
  -115.894    32.696
>
  -115.242    31.988
  -115.106    32.002
>
  -115.242    31.988
  -115.106    32.002
>
  -115.198    32.407
  -115.106    32.002
>
  -115.304    32.418
  -115.106    32.002
>
  -115.304    32.418
  -115.106    32.002
>
  -115.051    31.472
  -115.106    32.002
>
  -115.051    31.472
  -115.106    32.002
>
  -115.247    32.048
  -115.302    32.207
>
  -115.247    32.048
  -115.302    32.207
>
  -115.351    32.396
  -115.302    32.207
>
  -115.351    32.396
  -115.302    32.207
>
  -115.529    32.146
  -115.302    32.207
>
  -115.304    32.418
  -115.302    32.207
>
  -115.304    32.418
  -115.302    32.207
>
  -115.198    32.407
  -115.302    32.207
>
  -115.198    32.407
  -115.302    32.207
>
  -115.297    32.502
  -115.302    32.207
>
  -115.297    32.502
  -115.302    32.207
>
  -115.190    31.856
  -115.302    32.207
>
  -115.190    31.856
  -115.302    32.207
>
  -115.699    32.311
  -115.302    32.207
>
  -115.284    31.843
  -115.302    32.207
>
  -115.744    32.466
  -115.302    32.207
>
  -115.744    32.466
  -115.302    32.207
>
  -115.198    32.407
  -115.283    32.209
>
  -115.198    32.407
  -115.283    32.209
>
  -115.304    32.418
  -115.283    32.209
>
  -115.304    32.418
  -115.283    32.209
>
  -115.242    31.988
  -115.283    32.209
>
  -115.242    31.988
  -115.283    32.209
>
  -114.985    32.739
  -115.283    32.209
>
  -115.725    32.649
  -115.283    32.209
>
  -115.800    32.945
  -115.761    32.660
>
  -115.800    32.945
  -115.761    32.660
>
  -116.079    32.603
  -115.761    32.660
>
  -116.079    32.603
  -115.761    32.660
>
  -115.304    32.418
  -115.761    32.660
>
  -115.304    32.418
  -115.761    32.660
>
  -115.198    32.407
  -115.761    32.660
>
  -115.198    32.407
  -115.761    32.660
>
  -115.123    32.863
  -115.761    32.660
>
  -115.923    32.648
  -115.758    32.594
>
  -115.727    32.849
  -115.758    32.594
>
  -116.079    32.603
  -115.758    32.594
>
  -116.079    32.603
  -115.758    32.594
>
  -115.969    32.887
  -115.758    32.594
>
  -115.800    32.945
  -115.758    32.594
>
  -115.800    32.945
  -115.758    32.594
>
  -115.304    32.418
  -115.758    32.594
>
  -115.304    32.418
  -115.758    32.594
>
  -115.304    32.418
  -115.285    32.213
>
  -115.304    32.418
  -115.285    32.213
>
  -115.304    32.418
  -115.285    32.213
>
  -115.198    32.407
  -115.285    32.213
>
  -115.198    32.407
  -115.285    32.213
>
  -115.242    31.988
  -115.285    32.213
>
  -115.242    31.988
  -115.285    32.213
>
  -115.725    32.649
  -115.285    32.213
>
  -114.985    32.739
  -115.285    32.213
>
  -115.304    32.418
  -115.381    32.300
>
  -115.304    32.418
  -115.381    32.300
>
  -115.304    32.418
  -115.381    32.300
>
  -115.304    32.418
  -115.381    32.300
>
  -115.198    32.407
  -115.381    32.300
>
  -115.198    32.407
  -115.381    32.300
>
  -115.242    31.988
  -115.381    32.300
>
  -115.242    31.988
  -115.381    32.300
>
  -115.725    32.649
  -115.381    32.300
>
  -115.447    32.805
  -115.381    32.300
>
  -115.663    32.743
  -115.381    32.300
>
  -115.732    32.759
  -115.381    32.300
>
  -115.242    31.988
  -115.322    32.191
>
  -115.242    31.988
  -115.322    32.191
>
  -115.304    32.418
  -115.322    32.191
>
  -115.198    32.407
  -115.322    32.191
>
  -115.198    32.407
  -115.322    32.191
>
  -115.725    32.649
  -115.322    32.191
>
  -115.942    31.928
  -115.322    32.191
>
  -115.942    31.928
  -115.322    32.191
>
  -115.304    32.418
  -115.372    32.272
>
  -115.304    32.418
  -115.372    32.272
>
  -115.242    31.988
  -115.372    32.272
>
  -115.242    31.988
  -115.372    32.272
>
  -115.942    31.928
  -115.372    32.272
>
  -115.198    32.407
  -115.263    32.194
>
  -115.198    32.407
  -115.263    32.194
>
  -115.304    32.418
  -115.263    32.194
>
  -115.304    32.418
  -115.263    32.194
>
  -115.242    31.988
  -115.263    32.194
>
  -115.242    31.988
  -115.263    32.194
>
  -114.985    32.739
  -115.263    32.194
>
  -115.725    32.649
  -115.263    32.194
>
  -115.725    32.649
  -115.762    32.648
>
  -115.923    32.648
  -115.762    32.648
>
  -115.727    32.849
  -115.762    32.648
>
  -116.079    32.603
  -115.762    32.648
>
  -116.079    32.603
  -115.762    32.648
>
  -115.800    32.945
  -115.762    32.648
>
  -115.800    32.945
  -115.762    32.648
>
  -115.969    32.887
  -115.762    32.648
>
  -115.304    32.418
  -115.762    32.648
>
  -115.304    32.418
  -115.762    32.648
>
  -115.198    32.407
  -115.762    32.648
>
  -115.198    32.407
  -115.762    32.648
>
  -115.123    32.863
  -115.762    32.648
>
  -115.304    32.418
  -115.333    32.295
>
  -115.304    32.418
  -115.333    32.295
>
  -115.304    32.418
  -115.333    32.295
>
  -115.198    32.407
  -115.333    32.295
>
  -115.198    32.407
  -115.333    32.295
>
  -115.242    31.988
  -115.333    32.295
>
  -115.242    31.988
  -115.333    32.295
>
  -115.725    32.649
  -115.333    32.295
>
  -115.123    32.863
  -115.333    32.295
>
  -115.725    32.649
  -115.761    32.650
>
  -115.923    32.648
  -115.761    32.650
>
  -115.727    32.849
  -115.761    32.650
>
  -116.079    32.603
  -115.761    32.650
>
  -116.079    32.603
  -115.761    32.650
>
  -115.304    32.418
  -115.761    32.650
>
  -115.304    32.418
  -115.761    32.650
>
  -115.198    32.407
  -115.761    32.650
>
  -115.198    32.407
  -115.761    32.650
>
  -115.242    31.988
  -115.246    32.133
>
  -115.242    31.988
  -115.246    32.133
>
  -115.198    32.407
  -115.246    32.133
>
  -115.304    32.418
  -115.246    32.133
>
  -115.304    32.418
  -115.246    32.133
>
  -115.242    31.988
  -115.085    32.046
>
  -115.242    31.988
  -115.085    32.046
>
  -115.198    32.407
  -115.085    32.046
>
  -115.304    32.418
  -115.085    32.046
>
  -115.304    32.418
  -115.085    32.046
>
  -115.051    31.472
  -115.085    32.046
>
  -115.051    31.472
  -115.085    32.046
>
  -115.242    31.988
  -115.085    32.063
>
  -115.242    31.988
  -115.085    32.063
>
  -115.198    32.407
  -115.085    32.063
>
  -115.304    32.418
  -115.085    32.063
>
  -115.304    32.418
  -115.085    32.063
>
  -115.304    32.418
  -115.085    32.063
>
  -115.051    31.472
  -115.085    32.063
>
  -115.051    31.472
  -115.085    32.063
>
  -115.242    31.988
  -115.075    32.060
>
  -115.242    31.988
  -115.075    32.060
>
  -115.304    32.418
  -115.075    32.060
>
  -115.304    32.418
  -115.075    32.060
>
  -115.304    32.418
  -115.075    32.060
>
  -115.051    31.472
  -115.075    32.060
>
  -115.051    31.472
  -115.075    32.060
>
  -115.242    31.988
  -115.199    32.125
>
  -115.242    31.988
  -115.199    32.125
>
  -115.198    32.407
  -115.199    32.125
>
  -115.304    32.418
  -115.199    32.125
>
  -115.304    32.418
  -115.199    32.125
>
  -115.304    32.418
  -115.199    32.125
>
  -115.304    32.418
  -115.350    32.270
>
  -115.304    32.418
  -115.350    32.270
>
  -115.198    32.407
  -115.350    32.270
>
  -115.198    32.407
  -115.350    32.270
>
  -115.725    32.649
  -115.350    32.270
>
  -115.242    31.988
  -115.143    32.107
>
  -115.242    31.988
  -115.143    32.107
>
  -115.198    32.407
  -115.143    32.107
>
  -115.198    32.407
  -115.143    32.107
>
  -115.304    32.418
  -115.143    32.107
>
  -115.304    32.418
  -115.143    32.107
>
  -115.923    32.648
  -115.844    32.672
>
  -115.725    32.649
  -115.844    32.672
>
  -115.727    32.849
  -115.844    32.672
>
  -116.093    32.661
  -115.844    32.672
>
  -116.093    32.661
  -115.844    32.672
>
  -116.079    32.603
  -115.844    32.672
>
  -116.079    32.603
  -115.844    32.672
>
  -115.969    32.887
  -115.844    32.672
>
  -115.800    32.945
  -115.844    32.672
>
  -116.422    32.892
  -115.844    32.672
>
  -116.422    32.892
  -115.844    32.672
>
  -115.304    32.418
  -115.844    32.672
>
  -115.304    32.418
  -115.844    32.672
>
  -115.304    32.418
  -115.844    32.672
>
  -115.304    32.418
  -115.844    32.672
>
  -115.304    32.418
  -115.623    32.491
>
  -115.304    32.418
  -115.623    32.491
>
  -115.923    32.648
  -115.623    32.491
>
  -115.198    32.407
  -115.623    32.491
>
  -115.198    32.407
  -115.623    32.491
>
  -115.727    32.849
  -115.623    32.491
>
  -116.079    32.603
  -115.623    32.491
>
  -116.079    32.603
  -115.623    32.491
>
  -116.093    32.661
  -115.623    32.491
>
  -116.093    32.661
  -115.623    32.491
>
  -115.800    32.945
  -115.623    32.491
>
  -115.969    32.887
  -115.623    32.491
>
  -115.123    32.863
  -115.623    32.491
>
  -115.725    32.649
  -115.790    32.646
>
  -115.923    32.648
  -115.790    32.646
>
  -115.727    32.849
  -115.790    32.646
>
  -116.079    32.603
  -115.790    32.646
>
  -116.079    32.603
  -115.790    32.646
>
  -116.093    32.661
  -115.790    32.646
>
  -116.093    32.661
  -115.790    32.646
>
  -115.969    32.887
  -115.790    32.646
>
  -115.800    32.945
  -115.790    32.646
>
  -115.800    32.945
  -115.790    32.646
>
  -115.304    32.418
  -115.790    32.646
>
  -115.304    32.418
  -115.790    32.646
>
  -115.304    32.418
  -115.790    32.646
>
  -115.198    32.407
  -115.790    32.646
>
  -115.198    32.407
  -115.790    32.646
>
  -116.422    32.892
  -115.790    32.646
>
  -116.422    32.892
  -115.790    32.646
>
  -115.725    32.649
  -115.795    32.645
>
  -115.923    32.648
  -115.795    32.645
>
  -115.727    32.849
  -115.795    32.645
>
  -116.079    32.603
  -115.795    32.645
>
  -116.093    32.661
  -115.795    32.645
>
  -116.093    32.661
  -115.795    32.645
>
  -115.969    32.887
  -115.795    32.645
>
  -115.800    32.945
  -115.795    32.645
>
  -115.800    32.945
  -115.795    32.645
>
  -115.304    32.418
  -115.795    32.645
>
  -115.198    32.407
  -115.795    32.645
>
  -115.198    32.407
  -115.795    32.645
>
  -116.422    32.892
  -115.795    32.645
>
  -116.422    32.892
  -115.795    32.645
>
  -115.304    32.418
  -115.328    32.297
>
  -115.304    32.418
  -115.328    32.297
>
  -115.304    32.418
  -115.328    32.297
>
  -115.198    32.407
  -115.328    32.297
>
  -115.198    32.407
  -115.328    32.297
>
  -115.725    32.649
  -115.328    32.297
>
  -115.123    32.863
  -115.328    32.297
>
  -115.923    32.648
  -115.832    32.665
>
  -115.725    32.649
  -115.832    32.665
>
  -115.727    32.849
  -115.832    32.665
>
  -116.093    32.661
  -115.832    32.665
>
  -116.093    32.661
  -115.832    32.665
>
  -115.969    32.887
  -115.832    32.665
>
  -116.079    32.603
  -115.832    32.665
>
  -116.079    32.603
  -115.832    32.665
>
  -115.800    32.945
  -115.832    32.665
>
  -115.800    32.945
  -115.832    32.665
>
  -115.304    32.418
  -115.832    32.665
>
  -115.304    32.418
  -115.832    32.665
>
  -115.304    32.418
  -115.832    32.665
>
  -116.422    32.892
  -115.832    32.665
>
  -116.422    32.892
  -115.832    32.665
>
  -115.198    32.407
  -115.832    32.665
>
  -115.198    32.407
  -115.832    32.665
>
  -115.304    32.418
  -115.454    32.319
>
  -115.304    32.418
  -115.454    32.319
>
  -115.198    32.407
  -115.454    32.319
>
  -115.198    32.407
  -115.454    32.319
>
  -115.725    32.649
  -115.454    32.319
>
  -115.663    32.743
  -115.454    32.319
>
  -115.447    32.805
  -115.454    32.319
>
  -115.942    31.928
  -115.454    32.319
>
  -115.942    31.928
  -115.454    32.319
>
  -115.942    31.928
  -115.454    32.319
>
  -115.732    32.759
  -115.454    32.319
>
  -115.923    32.648
  -115.454    32.319
>
  -115.727    32.849
  -115.454    32.319
>
  -116.079    32.603
  -115.454    32.319
>
  -116.079    32.603
  -115.454    32.319
>
  -116.079    32.603
  -115.454    32.319
>
  -114.985    32.739
  -115.454    32.319
>
  -115.304    32.418
  -115.306    32.249
>
  -115.198    32.407
  -115.306    32.249
>
  -115.198    32.407
  -115.306    32.249
>
  -115.725    32.649
  -115.306    32.249
>
  -114.985    32.739
  -115.306    32.249
>
  -115.198    32.407
  -115.062    32.027
>
  -115.304    32.418
  -115.062    32.027
>
  -115.304    32.418
  -115.062    32.027
>
  -115.051    31.472
  -115.062    32.027
>
  -115.051    31.472
  -115.062    32.027
>
  -115.051    31.472
  -115.062    32.027
>
  -115.051    31.472
  -115.062    32.027
>
  -115.923    32.648
  -115.883    32.700
>
  -115.732    32.759
  -115.883    32.700
>
  -115.732    32.759
  -115.883    32.700
>
  -115.663    32.743
  -115.883    32.700
>
  -116.079    32.603
  -115.883    32.700
>
  -116.079    32.603
  -115.883    32.700
>
  -115.969    32.887
  -115.883    32.700
>
  -115.727    32.849
  -115.883    32.700
>
  -115.800    32.945
  -115.883    32.700
>
  -115.447    32.805
  -115.883    32.700
>
  -115.304    32.418
  -115.883    32.700
>
  -115.304    32.418
  -115.883    32.700
>
  -115.732    32.759
  -115.864    32.677
>
  -115.732    32.759
  -115.864    32.677
>
  -116.093    32.661
  -115.864    32.677
>
  -116.079    32.603
  -115.864    32.677
>
  -116.079    32.603
  -115.864    32.677
>
  -115.800    32.945
  -115.864    32.677
>
  -115.800    32.945
  -115.864    32.677
>
  -115.447    32.805
  -115.864    32.677
>
  -115.304    32.418
  -115.864    32.677
>
  -116.422    32.892
  -115.864    32.677
>
  -116.422    32.892
  -115.864    32.677
>
  -115.725    32.649
  -115.793    32.658
>
  -115.732    32.759
  -115.793    32.658
>
  -115.923    32.648
  -115.793    32.658
>
  -115.727    32.849
  -115.793    32.658
>
  -115.969    32.887
  -115.793    32.658
>
  -115.800    32.945
  -115.793    32.658
>
  -116.093    32.661
  -115.793    32.658
>
  -116.093    32.661
  -115.793    32.658
>
  -116.079    32.603
  -115.793    32.658
>
  -116.079    32.603
  -115.793    32.658
>
  -115.447    32.805
  -115.793    32.658
>
  -115.304    32.418
  -115.793    32.658
>
  -115.304    32.418
  -115.793    32.658
>
  -115.198    32.407
  -115.793    32.658
>
  -115.198    32.407
  -115.793    32.658
>
  -116.422    32.892
  -115.793    32.658
>
  -116.422    32.892
  -115.793    32.658
>
  -115.923    32.648
  -115.805    32.641
>
  -115.732    32.759
  -115.805    32.641
>
  -115.727    32.849
  -115.805    32.641
>
  -116.079    32.603
  -115.805    32.641
>
  -116.079    32.603
  -115.805    32.641
>
  -116.093    32.661
  -115.805    32.641
>
  -115.969    32.887
  -115.805    32.641
>
  -115.800    32.945
  -115.805    32.641
>
  -115.447    32.805
  -115.805    32.641
>
  -115.304    32.418
  -115.805    32.641
>
  -115.304    32.418
  -115.805    32.641
>
  -115.304    32.418
  -115.805    32.641
>
  -115.198    32.407
  -115.805    32.641
>
  -115.198    32.407
  -115.805    32.641
>
  -116.422    32.892
  -115.805    32.641
>
  -116.422    32.892
  -115.805    32.641
>
  -115.725    32.649
  -115.814    32.645
>
  -115.923    32.648
  -115.814    32.645
>
  -115.732    32.759
  -115.814    32.645
>
  -115.732    32.759
  -115.814    32.645
>
  -115.727    32.849
  -115.814    32.645
>
  -116.079    32.603
  -115.814    32.645
>
  -116.079    32.603
  -115.814    32.645
>
  -116.093    32.661
  -115.814    32.645
>
  -115.969    32.887
  -115.814    32.645
>
  -115.800    32.945
  -115.814    32.645
>
  -115.447    32.805
  -115.814    32.645
>
  -115.304    32.418
  -115.814    32.645
>
  -115.304    32.418
  -115.814    32.645
>
  -115.304    32.418
  -115.814    32.645
>
  -116.422    32.892
  -115.814    32.645
>
  -116.422    32.892
  -115.814    32.645
>
  -115.198    32.407
  -115.814    32.645
>
  -115.198    32.407
  -115.814    32.645
>
  -115.923    32.648
  -115.860    32.680
>
  -115.725    32.649
  -115.860    32.680
>
  -115.732    32.759
  -115.860    32.680
>
  -115.732    32.759
  -115.860    32.680
>
  -116.093    32.661
  -115.860    32.680
>
  -116.093    32.661
  -115.860    32.680
>
  -115.663    32.743
  -115.860    32.680
>
  -116.079    32.603
  -115.860    32.680
>
  -116.079    32.603
  -115.860    32.680
>
  -115.727    32.849
  -115.860    32.680
>
  -115.304    32.418
  -115.860    32.680
>
  -115.304    32.418
  -115.860    32.680
>
  -115.198    32.407
  -115.275    32.186
>
  -115.198    32.407
  -115.275    32.186
>
  -115.198    32.407
  -115.275    32.186
>
  -115.304    32.418
  -115.275    32.186
>
  -115.304    32.418
  -115.275    32.186
>
  -115.304    32.418
  -115.275    32.186
>
  -115.725    32.649
  -115.275    32.186
>
  -115.198    32.407
  -115.272    32.185
>
  -115.198    32.407
  -115.272    32.185
>
  -115.304    32.418
  -115.272    32.185
>
  -115.304    32.418
  -115.272    32.185
>
  -115.923    32.648
  -115.824    32.637
>
  -115.725    32.649
  -115.824    32.637
>
  -115.732    32.759
  -115.824    32.637
>
  -115.732    32.759
  -115.824    32.637
>
  -115.663    32.743
  -115.824    32.637
>
  -115.727    32.849
  -115.824    32.637
>
  -116.093    32.661
  -115.824    32.637
>
  -116.093    32.661
  -115.824    32.637
>
  -116.093    32.661
  -115.824    32.637
>
  -116.079    32.603
  -115.824    32.637
>
  -116.079    32.603
  -115.824    32.637
>
  -115.969    32.887
  -115.824    32.637
>
  -116.252    32.900
  -115.824    32.637
>
  -115.304    32.418
  -115.824    32.637
>
  -116.422    32.892
  -115.824    32.637
>
  -116.422    32.892
  -115.824    32.637
>
  -115.527    33.141
  -115.824    32.637
>
  -115.198    32.407
  -115.824    32.637
>
  -115.732    32.759
  -115.855    32.648
>
  -115.732    32.759
  -115.855    32.648
>
  -116.079    32.603
  -115.855    32.648
>
  -116.079    32.603
  -115.855    32.648
>
  -116.093    32.661
  -115.855    32.648
>
  -115.727    32.849
  -115.855    32.648
>
  -115.800    32.945
  -115.855    32.648
>
  -115.800    32.945
  -115.855    32.648
>
  -115.447    32.805
  -115.855    32.648
>
  -115.304    32.418
  -115.855    32.648
>
  -115.304    32.418
  -115.855    32.648
>
  -115.304    32.418
  -115.855    32.648
>
  -115.527    33.141
  -115.855    32.648
>
  -115.923    32.648
  -115.947    32.686
>
  -116.093    32.661
  -115.947    32.686
>
  -116.093    32.661
  -115.947    32.686
>
  -116.079    32.603
  -115.947    32.686
>
  -116.079    32.603
  -115.947    32.686
>
  -115.732    32.759
  -115.947    32.686
>
  -115.732    32.759
  -115.947    32.686
>
  -115.725    32.649
  -115.947    32.686
>
  -115.727    32.849
  -115.947    32.686
>
  -115.800    32.945
  -115.947    32.686
>
  -115.800    32.945
  -115.947    32.686
>
  -115.447    32.805
  -115.947    32.686
>
  -115.923    32.648
  -115.750    32.588
>
  -115.923    32.648
  -115.750    32.588
>
  -115.732    32.759
  -115.750    32.588
>
  -115.732    32.759
  -115.750    32.588
>
  -115.732    32.759
  -115.750    32.588
>
  -115.663    32.743
  -115.750    32.588
>
  -116.079    32.603
  -115.750    32.588
>
  -116.079    32.603
  -115.750    32.588
>
  -116.093    32.661
  -115.750    32.588
>
  -116.093    32.661
  -115.750    32.588
>
  -115.969    32.887
  -115.750    32.588
>
  -115.447    32.805
  -115.750    32.588
>
  -115.800    32.945
  -115.750    32.588
>
  -115.800    32.945
  -115.750    32.588
>
  -115.304    32.418
  -115.750    32.588
>
  -115.304    32.418
  -115.750    32.588
>
  -116.252    32.900
  -115.750    32.588
>
  -116.252    32.900
  -115.750    32.588
>
  -115.198    32.407
  -115.750    32.588
>
  -115.198    32.407
  -115.750    32.588
>
  -115.527    33.141
  -115.750    32.588
>
  -115.123    32.863
  -115.750    32.588
>
  -115.923    32.648
  -115.762    32.599
>
  -115.732    32.759
  -115.762    32.599
>
  -115.732    32.759
  -115.762    32.599
>
  -115.727    32.849
  -115.762    32.599
>
  -116.079    32.603
  -115.762    32.599
>
  -116.079    32.603
  -115.762    32.599
>
  -116.093    32.661
  -115.762    32.599
>
  -116.093    32.661
  -115.762    32.599
>
  -115.800    32.945
  -115.762    32.599
>
  -115.800    32.945
  -115.762    32.599
>
  -115.304    32.418
  -115.762    32.599
>
  -115.732    32.759
  -115.752    32.587
>
  -115.923    32.648
  -115.752    32.587
>
  -115.727    32.849
  -115.752    32.587
>
  -116.079    32.603
  -115.752    32.587
>
  -116.079    32.603
  -115.752    32.587
>
  -116.093    32.661
  -115.752    32.587
>
  -116.093    32.661
  -115.752    32.587
>
  -115.447    32.805
  -115.752    32.587
>
  -115.969    32.887
  -115.752    32.587
>
  -115.800    32.945
  -115.752    32.587
>
  -115.304    32.418
  -115.752    32.587
>
  -115.304    32.418
  -115.752    32.587
>
  -115.725    32.649
  -115.826    32.646
>
  -115.923    32.648
  -115.826    32.646
>
  -115.732    32.759
  -115.826    32.646
>
  -115.732    32.759
  -115.826    32.646
>
  -115.663    32.743
  -115.826    32.646
>
  -115.727    32.849
  -115.826    32.646
>
  -116.079    32.603
  -115.826    32.646
>
  -116.079    32.603
  -115.826    32.646
>
  -116.093    32.661
  -115.826    32.646
>
  -116.093    32.661
  -115.826    32.646
>
  -115.969    32.887
  -115.826    32.646
>
  -115.800    32.945
  -115.826    32.646
>
  -115.800    32.945
  -115.826    32.646
>
  -115.447    32.805
  -115.826    32.646
>
  -115.304    32.418
  -115.826    32.646
>
  -115.304    32.418
  -115.826    32.646
>
  -115.304    32.418
  -115.826    32.646
>
  -115.304    32.418
  -115.826    32.646
>
  -116.422    32.892
  -115.826    32.646
>
  -116.422    32.892
  -115.826    32.646
>
  -115.304    32.418
  -115.310    32.221
>
  -115.304    32.418
  -115.310    32.221
>
  -115.304    32.418
  -115.310    32.221
>
  -115.725    32.649
  -115.310    32.221
>
  -114.705    32.456
  -115.310    32.221
>
  -114.705    32.456
  -115.310    32.221
>
  -115.304    32.418
  -115.207    32.120
>
  -115.304    32.418
  -115.207    32.120
>
  -115.923    32.648
  -115.907    32.680
>
  -115.732    32.759
  -115.907    32.680
>
  -115.732    32.759
  -115.907    32.680
>
  -116.093    32.661
  -115.907    32.680
>
  -116.079    32.603
  -115.907    32.680
>
  -116.079    32.603
  -115.907    32.680
>
  -116.079    32.603
  -115.907    32.680
>
  -115.969    32.887
  -115.907    32.680
>
  -115.663    32.743
  -115.907    32.680
>
  -115.727    32.849
  -115.907    32.680
>
  -115.800    32.945
  -115.907    32.680
>
  -115.800    32.945
  -115.907    32.680
>
  -115.447    32.805
  -115.907    32.680
>
  -116.422    32.892
  -115.907    32.680
>
  -116.422    32.892
  -115.907    32.680
>
  -115.304    32.418
  -115.907    32.680
>
  -115.304    32.418
  -115.907    32.680
>
  -115.304    32.418
  -115.907    32.680
>
  -115.304    32.418
  -115.098    32.066
>
  -115.304    32.418
  -115.098    32.066
>
  -115.304    32.418
  -115.098    32.066
>
  -115.051    31.472
  -115.098    32.066
>
  -115.051    31.472
  -115.098    32.066
>
  -115.198    32.407
  -115.331    32.317
>
  -115.198    32.407
  -115.331    32.317
>
  -115.725    32.649
  -115.331    32.317
>
  -115.447    32.805
  -115.331    32.317
>
  -114.985    32.739
  -115.331    32.317
>
  -115.663    32.743
  -115.331    32.317
>
  -115.732    32.759
  -115.331    32.317
>
  -115.123    32.863
  -115.331    32.317
>
  -115.923    32.648
  -115.331    32.317
>
  -115.198    32.407
  -115.207    32.389
>
  -115.198    32.407
  -115.207    32.389
>
  -115.304    32.418
  -115.207    32.389
>
  -115.304    32.418
  -115.207    32.389
>
  -114.985    32.739
  -115.207    32.389
>
  -114.985    32.739
  -115.207    32.389
>
  -115.447    32.805
  -115.207    32.389
>
  -115.123    32.863
  -115.207    32.389
>
  -115.123    32.863
  -115.207    32.389
>
  -115.725    32.649
  -115.207    32.389
>
  -115.663    32.743
  -115.207    32.389
>
  -115.663    32.743
  -115.207    32.389
>
  -115.732    32.759
  -115.207    32.389
>
  -115.732    32.759
  -115.207    32.389
>
  -114.545    32.555
  -115.207    32.389
>
  -115.304    32.418
  -115.325    32.218
>
  -115.304    32.418
  -115.325    32.218
>
  -115.725    32.649
  -115.325    32.218
>
  -114.985    32.739
  -115.325    32.218
>
  -115.447    32.805
  -115.325    32.218
>
  -115.663    32.743
  -115.325    32.218
>
  -116.093    32.661
  -115.912    32.674
>
  -116.079    32.603
  -115.912    32.674
>
  -115.732    32.759
  -115.912    32.674
>
  -115.732    32.759
  -115.912    32.674
>
  -115.969    32.887
  -115.912    32.674
>
  -115.727    32.849
  -115.912    32.674
>
  -115.663    32.743
  -115.912    32.674
>
  -115.800    32.945
  -115.912    32.674
>
  -115.800    32.945
  -115.912    32.674
>
  -115.447    32.805
  -115.912    32.674
>
  -115.447    32.805
  -115.912    32.674
>
  -116.422    32.892
  -115.912    32.674
>
  -116.422    32.892
  -115.912    32.674
>
  -115.304    32.418
  -115.912    32.674
>
  -115.304    32.418
  -115.912    32.674
>
  -116.093    32.661
  -115.943    32.683
>
  -116.079    32.603
  -115.943    32.683
>
  -115.732    32.759
  -115.943    32.683
>
  -115.732    32.759
  -115.943    32.683
>
  -115.800    32.945
  -115.943    32.683
>
  -115.800    32.945
  -115.943    32.683
>
  -115.800    32.945
  -115.943    32.683
>
  -116.422    32.892
  -115.943    32.683
>
  -116.422    32.892
  -115.943    32.683
>
  -115.447    32.805
  -115.943    32.683
>
  -116.093    32.661
  -115.948    32.690
>
  -116.093    32.661
  -115.948    32.690
>
  -116.079    32.603
  -115.948    32.690
>
  -115.969    32.887
  -115.948    32.690
>
  -115.732    32.759
  -115.948    32.690
>
  -115.727    32.849
  -115.948    32.690
>
  -115.663    32.743
  -115.948    32.690
>
  -115.800    32.945
  -115.948    32.690
>
  -115.800    32.945
  -115.948    32.690
>
  -115.800    32.945
  -115.948    32.690
>
  -115.447    32.805
  -115.948    32.690
>
  -116.422    32.892
  -115.948    32.690
>
  -116.422    32.892
  -115.948    32.690
>
  -115.923    32.648
  -115.900    32.659
>
  -115.725    32.649
  -115.900    32.659
>
  -115.732    32.759
  -115.900    32.659
>
  -115.732    32.759
  -115.900    32.659
>
  -116.079    32.603
  -115.900    32.659
>
  -116.079    32.603
  -115.900    32.659
>
  -116.093    32.661
  -115.900    32.659
>
  -116.093    32.661
  -115.900    32.659
>
  -116.093    32.661
  -115.900    32.659
>
  -116.093    32.661
  -115.900    32.659
>
  -115.663    32.743
  -115.900    32.659
>
  -115.727    32.849
  -115.900    32.659
>
  -115.969    32.887
  -115.900    32.659
>
  -115.800    32.945
  -115.900    32.659
>
  -115.800    32.945
  -115.900    32.659
>
  -115.447    32.805
  -115.900    32.659
>
  -115.304    32.418
  -115.900    32.659
>
  -115.304    32.418
  -115.900    32.659
>
  -116.422    32.892
  -115.900    32.659
>
  -116.422    32.892
  -115.900    32.659
>
  -115.923    32.648
  -115.949    32.694
>
  -116.093    32.661
  -115.949    32.694
>
  -115.969    32.887
  -115.949    32.694
>
  -116.079    32.603
  -115.949    32.694
>
  -116.079    32.603
  -115.949    32.694
>
  -115.732    32.759
  -115.949    32.694
>
  -115.732    32.759
  -115.949    32.694
>
  -115.727    32.849
  -115.949    32.694
>
  -115.663    32.743
  -115.949    32.694
>
  -115.800    32.945
  -115.949    32.694
>
  -115.800    32.945
  -115.949    32.694
>
  -115.800    32.945
  -115.949    32.694
>
  -115.447    32.805
  -115.949    32.694
>
  -116.422    32.892
  -115.949    32.694
>
  -116.422    32.892
  -115.949    32.694
>
  -115.725    32.649
  -115.786    32.614
>
  -115.923    32.648
  -115.786    32.614
>
  -115.732    32.759
  -115.786    32.614
>
  -115.732    32.759
  -115.786    32.614
>
  -115.663    32.743
  -115.786    32.614
>
  -115.727    32.849
  -115.786    32.614
>
  -116.079    32.603
  -115.786    32.614
>
  -116.079    32.603
  -115.786    32.614
>
  -116.093    32.661
  -115.786    32.614
>
  -116.093    32.661
  -115.786    32.614
>
  -115.969    32.887
  -115.786    32.614
>
  -115.800    32.945
  -115.786    32.614
>
  -115.800    32.945
  -115.786    32.614
>
  -115.800    32.945
  -115.786    32.614
>
  -115.447    32.805
  -115.786    32.614
>
  -115.304    32.418
  -115.786    32.614
>
  -115.304    32.418
  -115.786    32.614
>
  -116.252    32.900
  -115.786    32.614
>
  -115.527    33.141
  -115.786    32.614
>
  -115.304    32.418
  -115.343    32.245
>
  -115.304    32.418
  -115.343    32.245
>
  -115.304    32.418
  -115.343    32.245
>
  -115.304    32.418
  -115.343    32.245
>
  -115.198    32.407
  -115.343    32.245
>
  -115.198    32.407
  -115.343    32.245
>
  -115.725    32.649
  -115.343    32.245
>
  -115.663    32.743
  -115.343    32.245
>
  -115.447    32.805
  -115.343    32.245
>
  -114.985    32.739
  -115.343    32.245
>
  -115.942    31.928
  -115.343    32.245
>
  -115.942    31.928
  -115.343    32.245
>
  -115.304    32.418
  -115.360    32.272
>
  -115.304    32.418
  -115.360    32.272
>
  -115.725    32.649
  -115.360    32.272
>
  -115.447    32.805
  -115.360    32.272
>
  -115.663    32.743
  -115.360    32.272
>
  -114.985    32.739
  -115.360    32.272
>
  -115.732    32.759
  -115.360    32.272
>
  -115.198    32.407
  -115.086    32.069
>
  -115.304    32.418
  -115.086    32.069
>
  -115.304    32.418
  -115.086    32.069
>
  -115.051    31.472
  -115.086    32.069
>
  -115.051    31.472
  -115.086    32.069
>
  -115.198    32.407
  -115.178    32.112
>
  -115.198    32.407
  -115.178    32.112
>
  -115.198    32.407
  -115.178    32.112
>
  -115.304    32.418
  -115.178    32.112
>
  -115.304    32.418
  -115.178    32.112
>
  -115.198    32.407
  -115.261    32.183
>
  -115.198    32.407
  -115.261    32.183
>
  -115.198    32.407
  -115.261    32.183
>
  -115.304    32.418
  -115.261    32.183
>
  -115.304    32.418
  -115.261    32.183
>
  -115.304    32.418
  -115.336    32.250
>
  -115.304    32.418
  -115.336    32.250
>
  -115.198    32.407
  -115.336    32.250
>
  -115.198    32.407
  -115.336    32.250
>
  -115.725    32.649
  -115.336    32.250
>
  -114.985    32.739
  -115.336    32.250
>
  -115.447    32.805
  -115.336    32.250
>
  -115.198    32.407
  -115.121    32.062
>
  -115.198    32.407
  -115.121    32.062
>
  -115.304    32.418
  -115.121    32.062
>
  -115.304    32.418
  -115.121    32.062
>
  -115.304    32.418
  -115.121    32.062
>
  -115.051    31.472
  -115.121    32.062
>
  -115.051    31.472
  -115.121    32.062
>
  -114.705    32.456
  -115.121    32.062
>
  -115.198    32.407
  -115.292    32.202
>
  -115.198    32.407
  -115.292    32.202
>
  -115.198    32.407
  -115.292    32.202
>
  -115.304    32.418
  -115.292    32.202
>
  -115.304    32.418
  -115.292    32.202
>
  -115.304    32.418
  -115.292    32.202
>
  -115.725    32.649
  -115.292    32.202
>
  -114.985    32.739
  -115.292    32.202
>
  -115.969    32.887
  -115.995    32.859
>
  -115.800    32.945
  -115.995    32.859
>
  -115.800    32.945
  -115.995    32.859
>
  -115.800    32.945
  -115.995    32.859
>
  -115.800    32.945
  -115.995    32.859
>
  -116.093    32.661
  -115.995    32.859
>
  -116.093    32.661
  -115.995    32.859
>
  -116.093    32.661
  -115.995    32.859
>
  -115.727    32.849
  -115.995    32.859
>
  -116.252    32.900
  -115.995    32.859
>
  -115.923    32.648
  -115.995    32.859
>
  -115.732    32.759
  -115.995    32.859
>
  -116.079    32.603
  -115.995    32.859
>
  -116.079    32.603
  -115.995    32.859
>
  -115.725    32.649
  -115.995    32.859
>
  -116.422    32.892
  -115.995    32.859
>
  -115.447    32.805
  -115.995    32.859
>
  -116.672    32.680
  -115.995    32.859
>
  -116.672    32.680
  -115.995    32.859
>
  -115.725    32.649
  -115.753    32.592
>
  -115.732    32.759
  -115.753    32.592
>
  -115.923    32.648
  -115.753    32.592
>
  -115.727    32.849
  -115.753    32.592
>
  -116.079    32.603
  -115.753    32.592
>
  -116.079    32.603
  -115.753    32.592
>
  -116.093    32.661
  -115.753    32.592
>
  -116.093    32.661
  -115.753    32.592
>
  -115.447    32.805
  -115.753    32.592
>
  -115.969    32.887
  -115.753    32.592
>
  -115.800    32.945
  -115.753    32.592
>
  -115.304    32.418
  -115.753    32.592
>
  -115.304    32.418
  -115.753    32.592
>
  -115.198    32.407
  -115.753    32.592
>
  -115.198    32.407
  -115.753    32.592
>
  -115.198    32.407
  -115.753    32.592
>
  -115.304    32.418
  -115.279    32.189
>
  -115.304    32.418
  -115.279    32.189
>
  -115.198    32.407
  -115.279    32.189
>
  -115.198    32.407
  -115.279    32.189
>
  -115.198    32.407
  -115.279    32.189
>
  -115.725    32.649
  -115.279    32.189
>
  -115.923    32.648
  -115.825    32.645
>
  -115.725    32.649
  -115.825    32.645
>
  -115.732    32.759
  -115.825    32.645
>
  -115.732    32.759
  -115.825    32.645
>
  -115.663    32.743
  -115.825    32.645
>
  -116.079    32.603
  -115.825    32.645
>
  -116.079    32.603
  -115.825    32.645
>
  -116.093    32.661
  -115.825    32.645
>
  -116.093    32.661
  -115.825    32.645
>
  -115.727    32.849
  -115.825    32.645
>
  -115.800    32.945
  -115.825    32.645
>
  -116.252    32.900
  -115.825    32.645
>
  -115.823    33.117
  -115.825    32.645
>
  -115.304    32.418
  -115.825    32.645
>
  -115.304    32.418
  -115.825    32.645
>
  -116.422    32.892
  -115.825    32.645
>
  -116.422    32.892
  -115.825    32.645
>
  -115.527    33.141
  -115.825    32.645
>
  -115.304    32.418
  -115.330    32.221
>
  -115.304    32.418
  -115.330    32.221
>
  -115.304    32.418
  -115.330    32.221
>
  -115.304    32.418
  -115.330    32.221
>
  -115.447    32.805
  -115.330    32.221
>
  -115.923    32.648
  -115.926    32.605
>
  -116.093    32.661
  -115.926    32.605
>
  -116.093    32.661
  -115.926    32.605
>
  -116.093    32.661
  -115.926    32.605
>
  -115.725    32.649
  -115.926    32.605
>
  -115.732    32.759
  -115.926    32.605
>
  -115.663    32.743
  -115.926    32.605
>
  -115.727    32.849
  -115.926    32.605
>
  -115.800    32.945
  -115.926    32.605
>
  -115.800    32.945
  -115.926    32.605
>
  -115.447    32.805
  -115.926    32.605
>
  -116.422    32.892
  -115.926    32.605
>
  -116.422    32.892
  -115.926    32.605
>
  -115.304    32.418
  -115.926    32.605
>
  -115.304    32.418
  -115.926    32.605
>
  -115.304    32.418
  -115.301    32.199
>
  -115.304    32.418
  -115.301    32.199
>
  -115.198    32.407
  -115.301    32.199
>
  -115.198    32.407
  -115.301    32.199
>
  -115.725    32.649
  -115.301    32.199
>
  -115.198    32.407
  -115.095    32.039
>
  -115.198    32.407
  -115.095    32.039
>
  -115.304    32.418
  -115.095    32.039
>
  -115.304    32.418
  -115.095    32.039
>
  -115.304    32.418
  -115.095    32.039
>
  -114.705    32.456
  -115.095    32.039
>
  -114.705    32.456
  -115.095    32.039
>
  -115.198    32.407
  -115.241    32.141
>
  -115.198    32.407
  -115.241    32.141
>
  -115.304    32.418
  -115.241    32.141
>
  -115.304    32.418
  -115.241    32.141
>
  -115.304    32.418
  -115.241    32.141
>
  -115.304    32.418
  -115.241    32.141
>
  -115.198    32.407
  -115.190    32.375
>
  -115.198    32.407
  -115.190    32.375
>
  -115.304    32.418
  -115.190    32.375
>
  -115.304    32.418
  -115.190    32.375
>
  -115.304    32.418
  -115.190    32.375
>
  -114.985    32.739
  -115.190    32.375
>
  -115.447    32.805
  -115.190    32.375
>
  -115.123    32.863
  -115.190    32.375
>
  -115.725    32.649
  -115.190    32.375
>
  -115.663    32.743
  -115.190    32.375
>
  -114.545    32.555
  -115.190    32.375
>
  -115.732    32.759
  -115.190    32.375
>
  -115.304    32.418
  -115.235    32.368
>
  -115.304    32.418
  -115.235    32.368
>
  -114.985    32.739
  -115.235    32.368
>
  -115.123    32.863
  -115.235    32.368
>
  -115.725    32.649
  -115.235    32.368
>
  -115.732    32.759
  -115.235    32.368
>
  -115.725    32.649
  -115.722    32.619
>
  -115.663    32.743
  -115.722    32.619
>
  -115.732    32.759
  -115.722    32.619
>
  -115.732    32.759
  -115.722    32.619
>
  -115.923    32.648
  -115.722    32.619
>
  -115.727    32.849
  -115.722    32.619
>
  -116.079    32.603
  -115.722    32.619
>
  -116.079    32.603
  -115.722    32.619
>
  -115.447    32.805
  -115.722    32.619
>
  -116.093    32.661
  -115.722    32.619
>
  -116.093    32.661
  -115.722    32.619
>
  -116.093    32.661
  -115.722    32.619
>
  -116.109    32.650
  -115.722    32.619
>
  -115.800    32.945
  -115.722    32.619
>
  -115.304    32.418
  -115.722    32.619
>
  -115.304    32.418
  -115.722    32.619
>
  -115.304    32.418
  -115.722    32.619
>
  -115.198    32.407
  -115.722    32.619
>
  -115.198    32.407
  -115.722    32.619
>
  -115.220    33.012
  -115.722    32.619
>
  -115.198    32.407
  -115.215    32.106
>
  -115.198    32.407
  -115.215    32.106
>
  -115.198    32.407
  -115.215    32.106
>
  -115.304    32.418
  -115.215    32.106
>
  -115.304    32.418
  -115.215    32.106
>
  -115.304    32.418
  -115.215    32.106
>
  -115.304    32.418
  -115.215    32.106
>
  -115.304    32.418
  -115.215    32.106
>
  -115.198    32.407
  -115.221    32.128
>
  -115.198    32.407
  -115.221    32.128
>
  -115.304    32.418
  -115.221    32.128
>
  -115.304    32.418
  -115.221    32.128
>
  -115.732    32.759
  -115.732    32.630
>
  -115.663    32.743
  -115.732    32.630
>
  -115.923    32.648
  -115.732    32.630
>
  -115.727    32.849
  -115.732    32.630
>
  -115.800    32.945
  -115.732    32.630
>
  -115.800    32.945
  -115.732    32.630
>
  -115.969    32.887
  -115.732    32.630
>
  -116.079    32.603
  -115.732    32.630
>
  -116.079    32.603
  -115.732    32.630
>
  -116.109    32.650
  -115.732    32.630
>
  -116.109    32.650
  -115.732    32.630
>
  -116.109    32.650
  -115.732    32.630
>
  -115.304    32.418
  -115.732    32.630
>
  -115.304    32.418
  -115.732    32.630
>
  -115.198    32.407
  -115.732    32.630
>
  -115.198    32.407
  -115.732    32.630
>
  -115.304    32.418
  -115.147    32.097
>
  -115.304    32.418
  -115.147    32.097
>
  -116.664    32.313
  -116.343    32.037
>
  -116.664    32.313
  -116.343    32.037
>
  -116.664    32.313
  -116.343    32.037
>
  -116.664    32.313
  -116.343    32.037
>
  -116.598    31.657
  -116.343    32.037
>
  -116.598    31.657
  -116.343    32.037
>
  -116.725    31.742
  -116.343    32.037
>
  -116.725    31.742
  -116.343    32.037
>
  -116.675    32.433
  -116.343    32.037
>
  -116.675    32.433
  -116.343    32.037
>
  -116.675    32.433
  -116.343    32.037
>
  -115.304    32.418
  -115.210    32.084
>
  -114.705    32.456
  -115.210    32.084
>
  -114.705    32.456
  -115.210    32.084
>
  -115.304    32.418
  -115.281    32.187
>
  -115.304    32.418
  -115.281    32.187
>
  -115.304    32.418
  -115.281    32.187
>
  -115.198    32.407
  -115.281    32.187
>
  -115.198    32.407
  -115.281    32.187
>
  -115.304    32.418
  -115.260    32.345
>
  -115.304    32.418
  -115.260    32.345
>
  -115.198    32.407
  -115.260    32.345
>
  -115.198    32.407
  -115.260    32.345
>
  -114.985    32.739
  -115.260    32.345
>
  -115.447    32.805
  -115.260    32.345
>
  -115.663    32.743
  -115.260    32.345
>
  -115.123    32.863
  -115.260    32.345
>
  -115.732    32.759
  -115.260    32.345
>
  -115.198    32.407
  -115.191    32.096
>
  -115.198    32.407
  -115.191    32.096
>
  -115.198    32.407
  -115.191    32.096
>
  -115.304    32.418
  -115.191    32.096
>
  -115.304    32.418
  -115.191    32.096
>
  -115.304    32.418
  -115.191    32.096
>
  -114.705    32.456
  -115.191    32.096
>
  -114.705    32.456
  -115.191    32.096
>
  -115.198    32.407
  -115.303    32.202
>
  -115.198    32.407
  -115.303    32.202
>
  -115.304    32.418
  -115.303    32.202
>
  -115.304    32.418
  -115.303    32.202
>
  -114.985    32.739
  -115.303    32.202
>
  -115.198    32.407
  -115.200    32.101
>
  -115.304    32.418
  -115.200    32.101
>
  -115.304    32.418
  -115.200    32.101
>
  -115.725    32.649
  -115.306    32.184
>
  -114.705    32.456
  -115.306    32.184
>
  -115.304    32.418
  -115.283    32.159
>
  -115.304    32.418
  -115.283    32.159
>
  -115.304    32.418
  -115.283    32.159
>
  -115.304    32.418
  -115.730    32.087
>
  -115.304    32.418
  -115.730    32.087
>
  -115.725    32.649
  -115.730    32.087
>
  -115.923    32.648
  -115.730    32.087
>
  -116.079    32.603
  -115.730    32.087
>
  -116.079    32.603
  -115.730    32.087
>
  -115.304    32.418
  -115.233    32.119
>
  -115.304    32.418
  -115.729    32.091
>
  -115.725    32.649
  -115.729    32.091
>
  -115.923    32.648
  -115.729    32.091
>
  -115.304    32.418
  -115.293    32.203
>
  -115.304    32.418
  -115.293    32.203
>
  -115.725    32.649
  -115.293    32.203
>
  -115.725    32.649
  -115.707    32.656
>
  -115.732    32.759
  -115.707    32.656
>
  -115.732    32.759
  -115.707    32.656
>
  -115.727    32.849
  -115.707    32.656
>
  -115.923    32.648
  -115.707    32.656
>
  -115.447    32.805
  -115.707    32.656
>
  -115.800    32.945
  -115.707    32.656
>
  -115.800    32.945
  -115.707    32.656
>
  -115.969    32.887
  -115.707    32.656
>
  -116.079    32.603
  -115.707    32.656
>
  -116.079    32.603
  -115.707    32.656
>
  -116.079    32.603
  -115.707    32.656
>
  -116.109    32.650
  -115.707    32.656
>
  -116.109    32.650
  -115.707    32.656
>
  -115.304    32.418
  -115.707    32.656
>
  -115.304    32.418
  -115.707    32.656
>
  -115.220    33.012
  -115.707    32.656
>
  -115.123    32.863
  -115.707    32.656
>
  -115.304    32.418
  -115.746    32.087
>
  -115.304    32.418
  -115.746    32.087
>
  -115.198    32.407
  -115.746    32.087
>
  -115.725    32.649
  -115.746    32.087
>
  -115.923    32.648
  -115.746    32.087
>
  -116.079    32.603
  -115.746    32.087
>
  -116.079    32.603
  -115.746    32.087
>
  -115.304    32.418
  -115.740    32.081
>
  -115.304    32.418
  -115.740    32.081
>
  -115.198    32.407
  -115.740    32.081
>
  -115.725    32.649
  -115.740    32.081
>
  -115.923    32.648
  -115.740    32.081
>
  -115.304    32.418
  -115.325    32.197
>
  -115.304    32.418
  -115.325    32.197
>
  -115.198    32.407
  -115.325    32.197
>
  -115.198    32.407
  -115.325    32.197
>
  -115.198    32.407
  -115.325    32.197
>
  -115.304    32.418
  -115.298    32.199
>
  -115.304    32.418
  -115.298    32.199
>
  -115.198    32.407
  -115.298    32.199
>
  -115.198    32.407
  -115.298    32.199
>
  -115.198    32.407
  -115.298    32.199
>
  -115.304    32.418
  -115.313    32.196
>
  -115.304    32.418
  -115.313    32.196
>
  -115.198    32.407
  -115.313    32.196
>
  -115.198    32.407
  -115.313    32.196
>
  -115.198    32.407
  -115.296    32.207
>
  -115.198    32.407
  -115.296    32.207
>
  -115.198    32.407
  -115.296    32.207
>
  -115.304    32.418
  -115.296    32.207
>
  -115.304    32.418
  -115.296    32.207
>
  -115.198    32.407
  -115.249    32.137
>
  -115.198    32.407
  -115.249    32.137
>
  -115.304    32.418
  -115.249    32.137
>
  -115.304    32.418
  -115.249    32.137
>
  -115.304    32.418
  -115.249    32.137
>
  -115.304    32.418
  -115.245    32.125
>
  -115.304    32.418
  -115.245    32.125
>
  -115.198    32.407
  -115.245    32.125
>
  -115.198    32.407
  -115.245    32.125
>
  -116.109    32.650
  -116.142    32.776
>
  -116.109    32.650
  -116.142    32.776
>
  -116.109    32.650
  -116.142    32.776
>
  -116.422    32.892
  -116.142    32.776
>
  -116.422    32.892
  -116.142    32.776
>
  -116.422    32.892
  -116.142    32.776
>
  -115.923    32.648
  -116.142    32.776
>
  -115.800    32.945
  -116.142    32.776
>
  -115.800    32.945
  -116.142    32.776
>
  -115.800    32.945
  -116.142    32.776
>
  -115.800    32.945
  -116.142    32.776
>
  -115.732    32.759
  -116.142    32.776
>
  -115.727    32.849
  -116.142    32.776
>
  -115.663    32.743
  -116.142    32.776
>
  -116.672    32.680
  -116.142    32.776
>
  -116.672    32.680
  -116.142    32.776
>
  -116.672    32.680
  -116.142    32.776
>
  -116.675    32.433
  -116.142    32.776
>
  -116.675    32.433
  -116.142    32.776
>
  -115.447    32.805
  -116.142    32.776
>
  -115.447    32.805
  -116.142    32.776
>
  -115.198    32.407
  -115.224    32.122
>
  -115.198    32.407
  -115.224    32.122
>
  -115.304    32.418
  -115.224    32.122
>
  -115.304    32.418
  -115.224    32.122
>
  -115.304    32.418
  -115.281    32.390
>
  -115.304    32.418
  -115.281    32.390
>
  -115.198    32.407
  -115.281    32.390
>
  -115.445    32.632
  -115.281    32.390
>
  -115.725    32.649
  -115.281    32.390
>
  -115.732    32.759
  -115.281    32.390
>
  -115.198    32.407
  -115.317    32.197
>
  -115.198    32.407
  -115.317    32.197
>
  -115.304    32.418
  -115.317    32.197
>
  -115.304    32.418
  -115.317    32.197
>
  -115.445    32.632
  -115.317    32.197
>
  -114.705    32.456
  -115.317    32.197
>
  -114.705    32.456
  -115.317    32.197
>
  -115.304    32.418
  -115.242    32.369
>
  -115.304    32.418
  -115.242    32.369
>
  -115.198    32.407
  -115.242    32.369
>
  -115.732    32.759
  -115.242    32.369
>
  -115.198    32.407
  -115.256    32.171
>
  -115.198    32.407
  -115.256    32.171
>
  -115.198    32.407
  -115.256    32.171
>
  -115.304    32.418
  -115.256    32.171
>
  -115.304    32.418
  -115.256    32.171
>
  -115.445    32.632
  -115.256    32.171
>
  -116.029    32.553
  -116.267    32.386
>
  -116.029    32.553
  -116.267    32.386
>
  -116.029    32.553
  -116.267    32.386
>
  -116.079    32.603
  -116.267    32.386
>
  -116.079    32.603
  -116.267    32.386
>
  -116.109    32.650
  -116.267    32.386
>
  -116.109    32.650
  -116.267    32.386
>
  -116.607    32.569
  -116.267    32.386
>
  -116.607    32.569
  -116.267    32.386
>
  -116.675    32.433
  -116.267    32.386
>
  -116.675    32.433
  -116.267    32.386
>
  -116.672    32.680
  -116.267    32.386
>
  -116.252    32.900
  -116.267    32.386
>
  -115.948    32.005
  -116.267    32.386
>
  -115.948    32.005
  -116.267    32.386
>
  -115.948    32.005
  -116.267    32.386
>
  -116.422    32.892
  -116.267    32.386
>
  -116.422    32.892
  -116.267    32.386
>
  -116.422    32.892
  -116.267    32.386
>
  -115.969    32.887
  -116.267    32.386
>
  -115.732    32.759
  -116.267    32.386
>
  -115.732    32.759
  -116.267    32.386
>
  -115.304    32.418
  -115.270    32.366
>
  -115.304    32.418
  -115.270    32.366
>
  -115.304    32.418
  -115.270    32.366
>
  -115.198    32.407
  -115.270    32.366
>
  -115.198    32.407
  -115.270    32.366
>
  -115.145    32.473
  -115.270    32.366
>
  -115.145    32.473
  -115.270    32.366
>
  -115.076    32.303
  -115.270    32.366
>
  -115.076    32.303
  -115.270    32.366
>
  -115.445    32.632
  -115.270    32.366
>
  -115.445    32.632
  -115.270    32.366
>
  -115.445    32.632
  -115.270    32.366
>
  -114.985    32.739
  -115.270    32.366
>
  -115.447    32.805
  -115.270    32.366
>
  -115.447    32.805
  -115.270    32.366
>
  -115.725    32.649
  -115.270    32.366
>
  -115.725    32.649
  -115.270    32.366
>
  -115.123    32.863
  -115.270    32.366
>
  -115.437    32.862
  -115.270    32.366
>
  -115.732    32.759
  -115.270    32.366
>
  -115.198    32.407
  -115.225    32.373
>
  -115.304    32.418
  -115.225    32.373
>
  -115.145    32.473
  -115.225    32.373
>
  -115.145    32.473
  -115.225    32.373
>
  -115.445    32.632
  -115.225    32.373
>
  -115.445    32.632
  -115.225    32.373
>
  -115.445    32.632
  -115.225    32.373
>
  -114.985    32.739
  -115.225    32.373
>
  -115.447    32.805
  -115.225    32.373
>
  -115.123    32.863
  -115.225    32.373
>
  -115.725    32.649
  -115.225    32.373
>
  -115.725    32.649
  -115.225    32.373
>
  -115.437    32.862
  -115.225    32.373
>
  -115.732    32.759
  -115.225    32.373
>
  -115.304    32.418
  -115.218    32.374
>
  -115.304    32.418
  -115.218    32.374
>
  -115.145    32.473
  -115.218    32.374
>
  -115.145    32.473
  -115.218    32.374
>
  -115.076    32.303
  -115.218    32.374
>
  -115.076    32.303
  -115.218    32.374
>
  -115.445    32.632
  -115.218    32.374
>
  -115.472    32.664
  -115.218    32.374
>
  -114.985    32.739
  -115.218    32.374
>
  -115.447    32.805
  -115.218    32.374
>
  -115.447    32.805
  -115.218    32.374
>
  -115.123    32.863
  -115.218    32.374
>
  -115.725    32.649
  -115.218    32.374
>
  -115.732    32.759
  -115.218    32.374
>
  -115.732    32.759
  -115.218    32.374
>
  -114.545    32.555
  -115.218    32.374
>
  -115.304    32.418
  -115.244    32.371
>
  -115.145    32.473
  -115.244    32.371
>
  -115.145    32.473
  -115.244    32.371
>
  -115.076    32.303
  -115.244    32.371
>
  -115.076    32.303
  -115.244    32.371
>
  -115.445    32.632
  -115.244    32.371
>
  -114.985    32.739
  -115.244    32.371
>
  -115.447    32.805
  -115.244    32.371
>
  -115.725    32.649
  -115.244    32.371
>
  -115.123    32.863
  -115.244    32.371
>
  -115.437    32.862
  -115.244    32.371
>
  -115.732    32.759
  -115.244    32.371
>
  -116.109    32.650
  -116.136    32.811
>
  -116.109    32.650
  -116.136    32.811
>
  -115.923    32.648
  -116.136    32.811
>
  -115.923    32.648
  -116.136    32.811
>
  -115.922    32.647
  -116.136    32.811
>
  -115.922    32.647
  -116.136    32.811
>
  -116.422    32.892
  -116.136    32.811
>
  -116.422    32.892
  -116.136    32.811
>
  -116.422    32.892
  -116.136    32.811
>
  -115.824    32.955
  -116.136    32.811
>
  -115.824    32.955
  -116.136    32.811
>
  -115.800    32.945
  -116.136    32.811
>
  -115.800    32.945
  -116.136    32.811
>
  -115.728    32.850
  -116.136    32.811
>
  -115.728    32.850
  -116.136    32.811
>
  -115.732    32.759
  -116.136    32.811
>
  -115.732    32.759
  -116.136    32.811
>
  -115.725    32.649
  -116.136    32.811
>
  -115.725    32.649
  -116.136    32.811
>
  -116.254    33.193
  -116.136    32.811
>
  -116.254    33.193
  -116.136    32.811
>
  -116.254    33.193
  -116.136    32.811
>
  -115.823    33.117
  -116.136    32.811
>
  -115.823    33.117
  -116.136    32.811
>
  -115.669    32.652
  -116.136    32.811
>
  -115.986    33.280
  -116.136    32.811
>
  -116.598    33.081
  -116.136    32.811
>
  -116.598    33.081
  -116.136    32.811
>
  -116.607    32.569
  -116.136    32.811
>
  -116.607    32.569
  -116.136    32.811
>
  -115.561    32.902
  -116.136    32.811
>
  -115.561    32.902
  -116.136    32.811
>
  -116.672    32.680
  -116.136    32.811
>
  -116.672    32.680
  -116.136    32.811
>
  -115.582    33.038
  -116.136    32.811
>
  -116.417    33.268
  -116.136    32.811
>
  -115.447    32.805
  -116.136    32.811
>
  -115.447    32.805
  -116.136    32.811
>
  -115.447    32.805
  -116.136    32.811
>
  -116.647    33.199
  -116.136    32.811
>
  -116.647    33.199
  -116.136    32.811
>
  -115.437    32.862
  -116.136    32.811
>
  -115.437    32.862
  -116.136    32.811
>
  -116.775    32.607
  -116.136    32.811
>
  -116.775    32.607
  -116.136    32.811
>
  -116.675    32.433
  -116.136    32.811
>
  -114.961    32.166
  -115.086    32.192
>
  -115.076    32.303
  -115.086    32.192
>
  -115.076    32.303
  -115.086    32.192
>
  -115.076    32.303
  -115.086    32.192
>
  -115.161    32.266
  -115.086    32.192
>
  -115.161    32.266
  -115.086    32.192
>
  -115.198    32.407
  -115.086    32.192
>
  -115.198    32.407
  -115.086    32.192
>
  -115.145    32.473
  -115.086    32.192
>
  -115.145    32.473
  -115.086    32.192
>
  -115.304    32.418
  -115.086    32.192
>
  -115.304    32.418
  -115.086    32.192
>
  -115.304    32.418
  -115.086    32.192
>
  -115.304    32.418
  -115.086    32.192
>
  -114.849    32.505
  -115.086    32.192
>
  -114.849    32.505
  -115.086    32.192
>
  -114.745    31.959
  -115.086    32.192
>
  -114.745    31.959
  -115.086    32.192
>
  -114.705    32.458
  -115.086    32.192
>
  -114.705    32.458
  -115.086    32.192
>
  -115.094    32.605
  -115.086    32.192
>
  -115.094    32.605
  -115.086    32.192
>
  -115.393    32.600
  -115.086    32.192
>
  -115.393    32.600
  -115.086    32.192
>
  -115.385    32.628
  -115.086    32.192
>
  -115.385    32.628
  -115.086    32.192
>
  -115.385    32.628
  -115.086    32.192
>
  -115.445    32.632
  -115.086    32.192
>
  -115.445    32.632
  -115.086    32.192
>
  -115.445    32.632
  -115.086    32.192
>
  -115.445    32.632
  -115.086    32.192
>
  -114.985    32.739
  -115.086    32.192
>
  -114.985    32.739
  -115.086    32.192
>
  -115.486    32.602
  -115.086    32.192
>
  -115.390    32.667
  -115.086    32.192
>
  -115.338    32.693
  -115.086    32.192
>
  -115.338    32.693
  -115.086    32.192
>
  -114.750    32.681
  -115.086    32.192
>
  -114.750    32.681
  -115.086    32.192
>
  -115.581    32.537
  -115.086    32.192
>
  -115.581    32.537
  -115.086    32.192
>
  -115.472    32.664
  -115.086    32.192
>
  -115.472    32.664
  -115.086    32.192
>
  -115.708    32.007
  -115.086    32.192
>
  -115.708    32.007
  -115.086    32.192
>
  -115.492    32.669
  -115.086    32.192
>
  -115.492    32.669
  -115.086    32.192
>
  -115.198    32.407
  -115.226    32.383
>
  -115.198    32.407
  -115.226    32.383
>
  -115.187    32.355
  -115.226    32.383
>
  -115.304    32.418
  -115.226    32.383
>
  -115.304    32.418
  -115.226    32.383
>
  -115.145    32.473
  -115.226    32.383
>
  -115.145    32.473
  -115.226    32.383
>
  -115.161    32.266
  -115.226    32.383
>
  -115.161    32.266
  -115.226    32.383
>
  -115.076    32.303
  -115.226    32.383
>
  -115.076    32.303
  -115.226    32.383
>
  -114.964    32.433
  -115.226    32.383
>
  -114.964    32.433
  -115.226    32.383
>
  -115.094    32.605
  -115.226    32.383
>
  -115.284    32.135
  -115.226    32.383
>
  -115.284    32.135
  -115.226    32.383
>
  -115.445    32.632
  -115.226    32.383
>
  -114.961    32.166
  -115.226    32.383
>
  -115.338    32.693
  -115.226    32.383
>
  -115.581    32.537
  -115.226    32.383
>
  -115.492    32.669
  -115.226    32.383
>
  -114.985    32.739
  -115.226    32.383
>
  -114.985    32.739
  -115.226    32.383
>
  -114.705    32.458
  -115.226    32.383
>
  -114.705    32.458
  -115.226    32.383
>
  -115.447    32.805
  -115.226    32.383
>
  -115.447    32.805
  -115.226    32.383
>
  -115.123    32.863
  -115.226    32.383
>
  -115.123    32.863
  -115.226    32.383
>
  -115.437    32.862
  -115.226    32.383
>
  -115.437    32.862
  -115.226    32.383
>
  -115.708    32.007
  -115.226    32.383
>
  -115.732    32.759
  -115.226    32.383
>
  -115.732    32.759
  -115.226    32.383
>
  -115.561    32.902
  -115.226    32.383
>
  -115.561    32.902
  -115.226    32.383
>
  -114.745    31.959
  -115.226    32.383
>
  -115.284    32.135
  -115.275    32.184
>
  -115.284    32.135
  -115.275    32.184
>
  -115.284    32.135
  -115.275    32.184
>
  -115.161    32.266
  -115.275    32.184
>
  -115.161    32.266
  -115.275    32.184
>
  -115.304    32.418
  -115.275    32.184
>
  -115.304    32.418
  -115.275    32.184
>
  -115.304    32.418
  -115.275    32.184
>
  -115.304    32.418
  -115.275    32.184
>
  -115.198    32.407
  -115.275    32.184
>
  -115.198    32.407
  -115.275    32.184
>
  -114.961    32.166
  -115.275    32.184
>
  -114.961    32.166
  -115.275    32.184
>
  -115.145    32.473
  -115.275    32.184
>
  -115.145    32.473
  -115.275    32.184
>
  -114.964    32.433
  -115.275    32.184
>
  -114.964    32.433
  -115.275    32.184
>
  -115.708    32.007
  -115.275    32.184
>
  -115.708    32.007
  -115.275    32.184
>
  -115.581    32.537
  -115.275    32.184
>
  -115.581    32.537
  -115.275    32.184
>
  -115.094    32.605
  -115.275    32.184
>
  -115.094    32.605
  -115.275    32.184
>
  -115.445    32.632
  -115.275    32.184
>
  -115.445    32.632
  -115.275    32.184
>
  -115.472    32.664
  -115.275    32.184
>
  -114.745    31.959
  -115.275    32.184
>
  -114.745    31.959
  -115.275    32.184
>
  -114.745    31.959
  -115.275    32.184
>
  -115.338    32.693
  -115.275    32.184
>
  -115.338    32.693
  -115.275    32.184
>
  -115.492    32.669
  -115.275    32.184
>
  -115.492    32.669
  -115.275    32.184
>
  -114.705    32.458
  -115.275    32.184
>
  -114.705    32.458
  -115.275    32.184
>
  -115.669    32.652
  -115.275    32.184
>
  -115.948    32.005
  -115.275    32.184
>
  -115.948    32.005
  -115.275    32.184
>
  -115.447    32.805
  -115.552    32.755
>
  -115.492    32.669
  -115.552    32.755
>
  -115.492    32.669
  -115.552    32.755
>
  -115.472    32.664
  -115.552    32.755
>
  -115.669    32.652
  -115.552    32.755
>
  -115.732    32.759
  -115.552    32.755
>
  -115.732    32.759
  -115.552    32.755
>
  -115.445    32.632
  -115.552    32.755
>
  -115.728    32.850
  -115.552    32.755
>
  -115.728    32.850
  -115.552    32.755
>
  -115.338    32.693
  -115.552    32.755
>
  -115.338    32.693
  -115.552    32.755
>
  -115.581    32.537
  -115.552    32.755
>
  -115.800    32.945
  -115.552    32.755
>
  -115.582    33.038
  -115.552    32.755
>
  -115.582    33.038
  -115.552    32.755
>
  -115.923    32.648
  -115.552    32.755
>
  -115.923    32.648
  -115.552    32.755
>
  -115.922    32.647
  -115.552    32.755
>
  -115.922    32.647
  -115.552    32.755
>
  -115.922    32.647
  -115.552    32.755
>
  -115.580    33.121
  -115.552    32.755
>
  -115.580    33.121
  -115.552    32.755
>
  -115.969    32.887
  -115.552    32.755
>
  -115.969    32.887
  -115.552    32.755
>
  -115.123    32.863
  -115.552    32.755
>
  -115.123    32.863
  -115.552    32.755
>
  -115.304    32.418
  -115.552    32.755
>
  -115.823    33.117
  -115.552    32.755
>
  -115.094    32.605
  -115.552    32.755
>
  -115.145    32.473
  -115.552    32.755
>
  -115.145    32.473
  -115.552    32.755
>
  -115.198    32.407
  -115.552    32.755
>
  -116.079    32.603
  -115.552    32.755
>
  -116.079    32.603
  -115.552    32.755
>
  -116.079    32.603
  -115.552    32.755
>
  -116.109    32.650
  -115.552    32.755
>
  -116.109    32.650
  -115.552    32.755
>
  -114.985    32.739
  -115.552    32.755
>
  -114.985    32.739
  -115.552    32.755
>
  -115.304    33.239
  -115.552    32.755
>
  -115.304    33.239
  -115.552    32.755
>
  -114.977    32.972
  -115.552    32.755
>
  -114.977    32.972
  -115.552    32.755
>
  -115.161    32.266
  -115.552    32.755
>
  -114.964    32.433
  -115.552    32.755
>
  -114.964    32.433
  -115.552    32.755
>
  -115.198    32.407
  -115.243    32.378
>
  -115.198    32.407
  -115.243    32.378
>
  -115.304    32.418
  -115.243    32.378
>
  -115.304    32.418
  -115.243    32.378
>
  -115.130    32.422
  -115.243    32.378
>
  -115.130    32.422
  -115.243    32.378
>
  -115.242    32.487
  -115.243    32.378
>
  -115.242    32.487
  -115.243    32.378
>
  -115.316    32.464
  -115.243    32.378
>
  -115.316    32.464
  -115.243    32.378
>
  -115.161    32.266
  -115.243    32.378
>
  -115.217    32.532
  -115.243    32.378
>
  -115.076    32.303
  -115.243    32.378
>
  -115.076    32.303
  -115.243    32.378
>
  -114.964    32.433
  -115.243    32.378
>
  -114.964    32.433
  -115.243    32.378
>
  -115.094    32.605
  -115.243    32.378
>
  -115.393    32.600
  -115.243    32.378
>
  -115.284    32.135
  -115.243    32.378
>
  -115.284    32.135
  -115.243    32.378
>
  -115.385    32.628
  -115.243    32.378
>
  -115.445    32.632
  -115.243    32.378
>
  -115.486    32.602
  -115.243    32.378
>
  -115.390    32.667
  -115.243    32.378
>
  -114.961    32.166
  -115.243    32.378
>
  -115.581    32.537
  -115.243    32.378
>
  -114.849    32.505
  -115.243    32.378
>
  -115.472    32.664
  -115.243    32.378
>
  -115.492    32.669
  -115.243    32.378
>
  -115.492    32.669
  -115.243    32.378
>
  -114.985    32.739
  -115.243    32.378
>
  -114.985    32.739
  -115.243    32.378
>
  -115.447    32.805
  -115.243    32.378
>
  -115.447    32.805
  -115.243    32.378
>
  -115.123    32.863
  -115.243    32.378
>
  -115.123    32.863
  -115.243    32.378
>
  -115.725    32.649
  -115.243    32.378
>
  -115.725    32.649
  -115.243    32.378
>
  -114.750    32.681
  -115.243    32.378
>
  -115.437    32.862
  -115.243    32.378
>
  -115.437    32.862
  -115.243    32.378
>
  -115.708    32.007
  -115.243    32.378
>
  -115.732    32.759
  -115.243    32.378
>
  -115.561    32.902
  -115.243    32.378
>
  -115.561    32.902
  -115.243    32.378
>
  -114.745    31.959
  -115.243    32.378
>
  -115.304    32.418
  -115.412    32.302
>
  -115.304    32.418
  -115.412    32.302
>
  -115.198    32.407
  -115.412    32.302
>
  -115.284    32.135
  -115.412    32.302
>
  -115.284    32.135
  -115.412    32.302
>
  -115.161    32.266
  -115.412    32.302
>
  -115.161    32.266
  -115.412    32.302
>
  -115.242    32.487
  -115.412    32.302
>
  -115.581    32.537
  -115.412    32.302
>
  -115.581    32.537
  -115.412    32.302
>
  -115.145    32.473
  -115.412    32.302
>
  -115.393    32.600
  -115.412    32.302
>
  -115.393    32.600
  -115.412    32.302
>
  -115.486    32.602
  -115.412    32.302
>
  -115.076    32.303
  -115.412    32.302
>
  -115.076    32.303
  -115.412    32.302
>
  -115.076    32.303
  -115.412    32.302
>
  -115.414    32.626
  -115.412    32.302
>
  -115.385    32.628
  -115.412    32.302
>
  -115.385    32.628
  -115.412    32.302
>
  -115.574    32.631
  -115.412    32.302
>
  -115.574    32.631
  -115.412    32.302
>
  -115.472    32.664
  -115.412    32.302
>
  -115.472    32.664
  -115.412    32.302
>
  -115.708    32.007
  -115.412    32.302
>
  -115.708    32.007
  -115.412    32.302
>
  -115.669    32.652
  -115.412    32.302
>
  -115.669    32.652
  -115.412    32.302
>
  -115.094    32.605
  -115.412    32.302
>
  -115.094    32.605
  -115.412    32.302
>
  -114.961    32.166
  -115.412    32.302
>
  -114.961    32.166
  -115.412    32.302
>
  -114.961    32.166
  -115.412    32.302
>
  -115.725    32.649
  -115.412    32.302
>
  -115.725    32.649
  -115.412    32.302
>
  -115.447    32.805
  -115.412    32.302
>
  -115.447    32.805
  -115.412    32.302
>
  -115.946    32.595
  -115.412    32.302
>
  -115.923    32.648
  -115.412    32.302
>
  -115.923    32.648
  -115.412    32.302
>
  -115.922    32.647
  -115.412    32.302
>
  -115.948    32.005
  -115.412    32.302
>
  -115.948    32.005
  -115.412    32.302
>
  -115.437    32.862
  -115.412    32.302
>
  -115.437    32.862
  -115.412    32.302
>
  -115.816    31.871
  -115.412    32.302
>
  -114.985    32.739
  -115.412    32.302
>
  -114.985    32.739
  -115.412    32.302
>
  -115.728    32.850
  -115.838    32.731
>
  -115.922    32.647
  -115.838    32.731
>
  -115.922    32.647
  -115.838    32.731
>
  -115.725    32.649
  -115.838    32.731
>
  -115.725    32.649
  -115.838    32.731
>
  -116.019    32.748
  -115.838    32.731
>
  -116.019    32.748
  -115.838    32.731
>
  -115.969    32.887
  -115.838    32.731
>
  -115.969    32.887
  -115.838    32.731
>
  -115.669    32.652
  -115.838    32.731
>
  -115.800    32.945
  -115.838    32.731
>
  -115.800    32.945
  -115.838    32.731
>
  -115.824    32.955
  -115.838    32.731
>
  -115.824    32.955
  -115.838    32.731
>
  -115.595    32.752
  -115.838    32.731
>
  -115.595    32.752
  -115.838    32.731
>
  -116.097    32.792
  -115.838    32.731
>
  -116.097    32.792
  -115.838    32.731
>
  -115.574    32.631
  -115.838    32.731
>
  -116.109    32.650
  -115.838    32.731
>
  -116.109    32.650
  -115.838    32.731
>
  -115.561    32.902
  -115.838    32.731
>
  -115.561    32.902
  -115.838    32.731
>
  -116.079    32.603
  -115.838    32.731
>
  -116.079    32.603
  -115.838    32.731
>
  -116.079    32.603
  -115.838    32.731
>
  -116.079    32.603
  -115.838    32.731
>
  -115.581    32.537
  -115.838    32.731
>
  -115.581    32.537
  -115.838    32.731
>
  -115.472    32.664
  -115.838    32.731
>
  -115.447    32.805
  -115.838    32.731
>
  -115.447    32.805
  -115.838    32.731
>
  -115.447    32.805
  -115.838    32.731
>
  -115.486    32.602
  -115.838    32.731
>
  -115.437    32.862
  -115.838    32.731
>
  -115.437    32.862
  -115.838    32.731
>
  -115.582    33.038
  -115.838    32.731
>
  -115.582    33.038
  -115.838    32.731
>
  -115.445    32.632
  -115.838    32.731
>
  -115.445    32.632
  -115.838    32.731
>
  -115.823    33.117
  -115.838    32.731
>
  -115.823    33.117
  -115.838    32.731
>
  -115.414    32.626
  -115.838    32.731
>
  -115.390    32.667
  -115.838    32.731
>
  -115.385    32.628
  -115.838    32.731
>
  -115.393    32.600
  -115.838    32.731
>
  -115.580    33.121
  -115.838    32.731
>
  -115.580    33.121
  -115.838    32.731
>
  -115.531    33.098
  -115.838    32.731
>
  -116.303    32.955
  -115.838    32.731
>
  -116.303    32.955
  -115.838    32.731
>
  -115.616    33.178
  -115.838    32.731
>
  -115.616    33.178
  -115.838    32.731
>
  -115.623    33.183
  -115.838    32.731
>
  -116.366    32.651
  -115.838    32.731
>
  -116.366    32.651
  -115.838    32.731
>
  -116.168    33.156
  -115.838    32.731
>
  -116.168    33.156
  -115.838    32.731
>
  -115.316    32.464
  -115.838    32.731
>
  -115.316    32.464
  -115.838    32.731
>
  -115.986    33.280
  -115.838    32.731
>
  -116.411    32.972
  -115.838    32.731
>
  -115.579    33.279
  -115.838    32.731
>
  -115.579    33.279
  -115.838    32.731
>
  -115.304    32.418
  -115.838    32.731
>
  -115.304    32.418
  -115.838    32.731
>
  -115.305    32.420
  -115.838    32.731
>
  -115.305    32.420
  -115.838    32.731
>
  -115.242    32.487
  -115.838    32.731
>
  -116.485    32.643
  -115.838    32.731
>
  -116.485    32.643
  -115.838    32.731
>
  -115.295    32.385
  -115.838    32.731
>
  -115.295    32.385
  -115.838    32.731
>
  -116.529    32.823
  -115.838    32.731
>
  -116.529    32.823
  -115.838    32.731
>
  -115.304    32.418
  -115.275    32.350
>
  -115.305    32.420
  -115.275    32.350
>
  -115.242    32.487
  -115.275    32.350
>
  -115.161    32.266
  -115.275    32.350
>
  -115.161    32.266
  -115.275    32.350
>
  -115.145    32.473
  -115.275    32.350
>
  -115.076    32.303
  -115.275    32.350
>
  -115.076    32.303
  -115.275    32.350
>
  -115.284    32.135
  -115.275    32.350
>
  -115.284    32.135
  -115.275    32.350
>
  -115.385    32.628
  -115.275    32.350
>
  -115.094    32.605
  -115.275    32.350
>
  -115.094    32.605
  -115.275    32.350
>
  -115.445    32.632
  -115.275    32.350
>
  -115.581    32.537
  -115.275    32.350
>
  -115.581    32.537
  -115.275    32.350
>
  -115.094    32.605
  -115.275    32.350
>
  -114.961    32.166
  -115.275    32.350
>
  -115.093    32.708
  -115.275    32.350
>
  -115.093    32.708
  -115.275    32.350
>
  -115.447    32.805
  -115.275    32.350
>
  -115.447    32.805
  -115.275    32.350
>
  -115.595    32.752
  -115.275    32.350
>
  -115.725    32.649
  -115.275    32.350
>
  -114.705    32.458
  -115.275    32.350
>
  -114.705    32.458
  -115.275    32.350
>
  -114.705    32.458
  -115.275    32.350
>
  -115.123    32.863
  -115.275    32.350
>
  -115.708    32.007
  -115.275    32.350
>
  -115.841    32.116
  -115.275    32.350
>
  -114.745    31.960
  -115.275    32.350
>
  -114.745    31.959
  -115.275    32.350
>
  -114.745    31.959
  -115.275    32.350
>
  -115.304    32.418
  -115.329    32.314
>
  -115.304    32.418
  -115.329    32.314
>
  -115.305    32.420
  -115.329    32.314
>
  -115.305    32.420
  -115.329    32.314
>
  -115.198    32.407
  -115.329    32.314
>
  -115.198    32.407
  -115.329    32.314
>
  -115.161    32.266
  -115.329    32.314
>
  -115.161    32.266
  -115.329    32.314
>
  -115.161    32.266
  -115.329    32.314
>
  -115.284    32.135
  -115.329    32.314
>
  -115.076    32.303
  -115.329    32.314
>
  -115.076    32.303
  -115.329    32.314
>
  -115.076    32.303
  -115.329    32.314
>
  -115.581    32.537
  -115.329    32.314
>
  -115.445    32.632
  -115.329    32.314
>
  -115.445    32.632
  -115.329    32.314
>
  -114.964    32.433
  -115.329    32.314
>
  -114.964    32.433
  -115.329    32.314
>
  -115.094    32.605
  -115.329    32.314
>
  -114.961    32.166
  -115.329    32.314
>
  -114.961    32.166
  -115.329    32.314
>
  -115.472    32.664
  -115.329    32.314
>
  -115.093    32.708
  -115.329    32.314
>
  -115.708    32.007
  -115.329    32.314
>
  -115.708    32.007
  -115.329    32.314
>
  -115.725    32.649
  -115.329    32.314
>
  -115.725    32.649
  -115.329    32.314
>
  -115.595    32.752
  -115.329    32.314
>
  -115.595    32.752
  -115.329    32.314
>
  -115.447    32.805
  -115.329    32.314
>
  -115.447    32.805
  -115.329    32.314
>
  -115.447    32.805
  -115.329    32.314
>
  -114.985    32.739
  -115.329    32.314
>
  -114.985    32.739
  -115.329    32.314
>
  -114.985    32.739
  -115.329    32.314
>
  -115.437    32.862
  -115.329    32.314
>
  -115.437    32.862
  -115.329    32.314
>
  -114.705    32.458
  -115.329    32.314
>
  -114.705    32.458
  -115.329    32.314
>
  -115.123    32.863
  -115.329    32.314
>
  -115.123    32.863
  -115.329    32.314
>
  -115.123    32.863
  -115.329    32.314
>
  -115.198    32.407
  -115.222    32.372
>
  -115.198    32.407
  -115.222    32.372
>
  -115.198    32.407
  -115.222    32.372
>
  -115.304    32.418
  -115.222    32.372
>
  -115.304    32.418
  -115.222    32.372
>
  -115.161    32.266
  -115.222    32.372
>
  -115.161    32.266
  -115.222    32.372
>
  -115.076    32.303
  -115.222    32.372
>
  -115.076    32.303
  -115.222    32.372
>
  -114.964    32.433
  -115.222    32.372
>
  -114.964    32.433
  -115.222    32.372
>
  -115.094    32.605
  -115.222    32.372
>
  -115.094    32.605
  -115.222    32.372
>
  -115.284    32.135
  -115.222    32.372
>
  -115.284    32.135
  -115.222    32.372
>
  -114.961    32.166
  -115.222    32.372
>
  -115.445    32.632
  -115.222    32.372
>
  -115.581    32.537
  -115.222    32.372
>
  -115.581    32.537
  -115.222    32.372
>
  -114.985    32.739
  -115.222    32.372
>
  -114.985    32.739
  -115.222    32.372
>
  -114.985    32.739
  -115.222    32.372
>
  -114.705    32.458
  -115.222    32.372
>
  -114.705    32.458
  -115.222    32.372
>
  -115.447    32.805
  -115.222    32.372
>
  -115.447    32.805
  -115.222    32.372
>
  -115.447    32.805
  -115.222    32.372
>
  -115.669    32.652
  -115.222    32.372
>
  -115.669    32.652
  -115.222    32.372
>
  -115.123    32.863
  -115.222    32.372
>
  -115.123    32.863
  -115.222    32.372
>
  -115.725    32.649
  -115.222    32.372
>
  -115.725    32.649
  -115.222    32.372
>
  -115.437    32.862
  -115.222    32.372
>
  -115.437    32.862
  -115.222    32.372
>
  -115.708    32.007
  -115.222    32.372
>
  -115.708    32.007
  -115.222    32.372
>
  -114.745    31.959
  -115.222    32.372
>
  -114.784    32.845
  -115.222    32.372
>
  -114.784    32.845
  -115.222    32.372
>
  -115.561    32.902
  -115.222    32.372
>
  -115.561    32.902
  -115.222    32.372
>
  -115.198    32.407
  -115.228    32.382
>
  -115.198    32.407
  -115.228    32.382
>
  -115.304    32.418
  -115.228    32.382
>
  -115.304    32.418
  -115.228    32.382
>
  -115.304    32.418
  -115.228    32.382
>
  -115.305    32.420
  -115.228    32.382
>
  -115.161    32.266
  -115.228    32.382
>
  -115.161    32.266
  -115.228    32.382
>
  -115.076    32.303
  -115.228    32.382
>
  -115.076    32.303
  -115.228    32.382
>
  -114.964    32.433
  -115.228    32.382
>
  -115.094    32.605
  -115.228    32.382
>
  -115.094    32.605
  -115.228    32.382
>
  -115.385    32.628
  -115.228    32.382
>
  -115.385    32.628
  -115.228    32.382
>
  -115.284    32.135
  -115.228    32.382
>
  -115.284    32.135
  -115.228    32.382
>
  -115.284    32.135
  -115.228    32.382
>
  -115.445    32.632
  -115.228    32.382
>
  -115.445    32.632
  -115.228    32.382
>
  -114.961    32.166
  -115.228    32.382
>
  -114.961    32.166
  -115.228    32.382
>
  -115.093    32.708
  -115.228    32.382
>
  -115.093    32.708
  -115.228    32.382
>
  -115.581    32.537
  -115.228    32.382
>
  -115.581    32.537
  -115.228    32.382
>
  -115.472    32.664
  -115.228    32.382
>
  -115.472    32.664
  -115.228    32.382
>
  -114.985    32.739
  -115.228    32.382
>
  -114.985    32.739
  -115.228    32.382
>
  -114.705    32.458
  -115.228    32.382
>
  -115.669    32.652
  -115.228    32.382
>
  -115.669    32.652
  -115.228    32.382
>
  -115.123    32.863
  -115.228    32.382
>
  -115.725    32.649
  -115.228    32.382
>
  -115.437    32.862
  -115.228    32.382
>
  -115.708    32.007
  -115.228    32.382
>
  -115.708    32.007
  -115.228    32.382
>
  -115.561    32.902
  -115.228    32.382
>
  -115.561    32.902
  -115.228    32.382
>
  -115.561    32.902
  -115.228    32.382
>
  -114.784    32.845
  -115.228    32.382
>
  -114.784    32.845
  -115.228    32.382
>
  -114.745    31.960
  -115.228    32.382
>
  -114.745    31.959
  -115.228    32.382
>
  -116.097    32.792
  -116.044    32.819
>
  -116.097    32.792
  -116.044    32.819
>
  -116.019    32.748
  -116.044    32.819
>
  -116.019    32.748
  -116.044    32.819
>
  -116.109    32.650
  -116.044    32.819
>
  -116.109    32.650
  -116.044    32.819
>
  -115.824    32.955
  -116.044    32.819
>
  -115.824    32.955
  -116.044    32.819
>
  -115.800    32.945
  -116.044    32.819
>
  -115.728    32.850
  -116.044    32.819
>
  -115.728    32.850
  -116.044    32.819
>
  -116.168    33.156
  -116.044    32.819
>
  -116.168    33.156
  -116.044    32.819
>
  -115.823    33.117
  -116.044    32.819
>
  -115.823    33.117
  -116.044    32.819
>
  -115.978    33.174
  -116.044    32.819
>
  -115.978    33.174
  -116.044    32.819
>
  -116.411    32.972
  -116.044    32.819
>
  -116.411    32.972
  -116.044    32.819
>
  -115.725    32.649
  -116.044    32.819
>
  -115.725    32.649
  -116.044    32.819
>
  -116.254    33.193
  -116.044    32.819
>
  -116.254    33.193
  -116.044    32.819
>
  -115.595    32.752
  -116.044    32.819
>
  -115.595    32.752
  -116.044    32.819
>
  -116.438    33.077
  -116.044    32.819
>
  -116.438    33.077
  -116.044    32.819
>
  -115.561    32.902
  -116.044    32.819
>
  -115.561    32.902
  -116.044    32.819
>
  -116.485    32.643
  -116.044    32.819
>
  -116.485    32.643
  -116.044    32.819
>
  -115.582    33.038
  -116.044    32.819
>
  -115.582    33.038
  -116.044    32.819
>
  -116.579    32.959
  -116.044    32.819
>
  -116.579    32.959
  -116.044    32.819
>
  -115.580    33.121
  -116.044    32.819
>
  -115.580    33.121
  -116.044    32.819
>
  -115.616    33.178
  -116.044    32.819
>
  -115.616    33.178
  -116.044    32.819
>
  -115.623    33.183
  -116.044    32.819
>
  -116.627    32.906
  -116.044    32.819
>
  -116.627    32.906
  -116.044    32.819
>
  -115.531    33.098
  -116.044    32.819
>
  -115.531    33.098
  -116.044    32.819
>
  -115.447    32.805
  -116.044    32.819
>
  -115.447    32.805
  -116.044    32.819
>
  -115.437    32.862
  -116.044    32.819
>
  -116.598    33.081
  -116.044    32.819
>
  -116.417    33.268
  -116.044    32.819
>
  -116.417    33.268
  -116.044    32.819
>
  -116.367    33.327
  -116.044    32.819
>
  -116.367    33.327
  -116.044    32.819
>
  -115.445    32.632
  -116.044    32.819
>
  -115.445    32.632
  -116.044    32.819
>
  -116.607    32.569
  -116.044    32.819
>
  -116.607    32.569
  -116.044    32.819
>
  -116.672    32.680
  -116.044    32.819
>
  -116.672    32.680
  -116.044    32.819
>
  -115.595    32.752
  -115.556    32.682
>
  -115.568    32.780
  -115.556    32.682
>
  -115.568    32.780
  -115.556    32.682
>
  -115.621    32.765
  -115.556    32.682
>
  -115.472    32.664
  -115.556    32.682
>
  -115.505    32.829
  -115.556    32.682
>
  -115.447    32.805
  -115.556    32.682
>
  -115.447    32.805
  -115.556    32.682
>
  -115.445    32.632
  -115.556    32.682
>
  -115.669    32.652
  -115.556    32.682
>
  -115.669    32.652
  -115.556    32.682
>
  -115.437    32.862
  -115.556    32.682
>
  -115.437    32.862
  -115.556    32.682
>
  -115.385    32.628
  -115.556    32.682
>
  -115.385    32.628
  -115.556    32.682
>
  -115.725    32.649
  -115.556    32.682
>
  -115.725    32.649
  -115.556    32.682
>
  -115.561    32.902
  -115.556    32.682
>
  -115.561    32.902
  -115.556    32.682
>
  -115.581    32.537
  -115.556    32.682
>
  -115.581    32.537
  -115.556    32.682
>
  -115.581    32.537
  -115.556    32.682
>
  -115.728    32.850
  -115.556    32.682
>
  -115.728    32.850
  -115.556    32.682
>
  -115.320    32.960
  -115.556    32.682
>
  -115.320    32.960
  -115.556    32.682
>
  -115.800    32.945
  -115.556    32.682
>
  -115.800    32.945
  -115.556    32.682
>
  -115.800    32.945
  -115.556    32.682
>
  -115.582    33.038
  -115.556    32.682
>
  -115.582    33.038
  -115.556    32.682
>
  -115.824    32.955
  -115.556    32.682
>
  -115.824    32.955
  -115.556    32.682
>
  -115.304    32.418
  -115.556    32.682
>
  -115.305    32.420
  -115.556    32.682
>
  -115.531    33.098
  -115.556    32.682
>
  -115.093    32.708
  -115.556    32.682
>
  -115.093    32.708
  -115.556    32.682
>
  -115.123    32.863
  -115.556    32.682
>
  -115.123    32.863
  -115.556    32.682
>
  -115.969    32.887
  -115.556    32.682
>
  -115.969    32.887
  -115.556    32.682
>
  -115.580    33.121
  -115.556    32.682
>
  -115.580    33.121
  -115.556    32.682
>
  -116.019    32.748
  -115.556    32.682
>
  -116.019    32.748
  -115.556    32.682
>
  -115.198    32.407
  -115.556    32.682
>
  -116.079    32.603
  -115.556    32.682
>
  -116.079    32.603
  -115.556    32.682
>
  -115.616    33.178
  -115.556    32.682
>
  -115.616    33.178
  -115.556    32.682
>
  -115.823    33.117
  -115.556    32.682
>
  -115.823    33.117
  -115.556    32.682
>
  -115.109    32.448
  -115.556    32.682
>
  -115.623    33.183
  -115.556    32.682
>
  -116.097    32.792
  -115.556    32.682
>
  -114.985    32.739
  -115.556    32.682
>
  -114.985    32.739
  -115.556    32.682
>
  -114.985    32.739
  -115.556    32.682
>
  -114.985    32.739
  -115.556    32.682
>
  -116.109    32.650
  -115.556    32.682
>
  -116.109    32.650
  -115.556    32.682
>
  -114.977    32.972
  -115.556    32.682
>
  -114.977    32.972
  -115.556    32.682
>
  -115.579    33.279
  -115.556    32.682
>
  -115.579    33.279
  -115.556    32.682
>
  -115.161    32.266
  -115.556    32.682
>
  -115.161    32.266
  -115.556    32.682
>
  -114.964    32.433
  -115.556    32.682
>
  -115.076    32.303
  -115.556    32.682
>
  -115.076    32.303
  -115.556    32.682
>
  -115.284    32.135
  -115.556    32.682
>
  -115.284    32.135
  -115.556    32.682
>
  -115.595    32.752
  -115.553    32.687
>
  -115.568    32.780
  -115.553    32.687
>
  -115.568    32.780
  -115.553    32.687
>
  -115.621    32.765
  -115.553    32.687
>
  -115.472    32.664
  -115.553    32.687
>
  -115.472    32.664
  -115.553    32.687
>
  -115.669    32.652
  -115.553    32.687
>
  -115.669    32.652
  -115.553    32.687
>
  -115.505    32.829
  -115.553    32.687
>
  -115.447    32.805
  -115.553    32.687
>
  -115.447    32.805
  -115.553    32.687
>
  -115.445    32.632
  -115.553    32.687
>
  -115.445    32.632
  -115.553    32.687
>
  -115.725    32.649
  -115.553    32.687
>
  -115.725    32.649
  -115.553    32.687
>
  -115.437    32.862
  -115.553    32.687
>
  -115.581    32.537
  -115.553    32.687
>
  -115.581    32.537
  -115.553    32.687
>
  -115.561    32.902
  -115.553    32.687
>
  -115.561    32.902
  -115.553    32.687
>
  -115.561    32.902
  -115.553    32.687
>
  -115.561    32.902
  -115.553    32.687
>
  -115.338    32.693
  -115.553    32.687
>
  -115.728    32.850
  -115.553    32.687
>
  -115.800    32.945
  -115.553    32.687
>
  -115.800    32.945
  -115.553    32.687
>
  -115.320    32.960
  -115.553    32.687
>
  -115.824    32.955
  -115.553    32.687
>
  -115.824    32.955
  -115.553    32.687
>
  -115.305    32.420
  -115.553    32.687
>
  -115.531    33.098
  -115.553    32.687
>
  -115.531    33.098
  -115.553    32.687
>
  -115.969    32.887
  -115.553    32.687
>
  -115.969    32.887
  -115.553    32.687
>
  -116.019    32.748
  -115.553    32.687
>
  -116.019    32.748
  -115.553    32.687
>
  -115.093    32.708
  -115.553    32.687
>
  -115.093    32.708
  -115.553    32.687
>
  -115.123    32.863
  -115.553    32.687
>
  -115.123    32.863
  -115.553    32.687
>
  -115.094    32.605
  -115.553    32.687
>
  -116.079    32.603
  -115.553    32.687
>
  -116.079    32.603
  -115.553    32.687
>
  -115.198    32.407
  -115.553    32.687
>
  -116.079    32.603
  -115.553    32.687
>
  -116.079    32.603
  -115.553    32.687
>
  -115.823    33.117
  -115.553    32.687
>
  -115.823    33.117
  -115.553    32.687
>
  -116.097    32.792
  -115.553    32.687
>
  -116.097    32.792
  -115.553    32.687
>
  -115.616    33.178
  -115.553    32.687
>
  -115.616    33.178
  -115.553    32.687
>
  -116.109    32.650
  -115.553    32.687
>
  -116.109    32.650
  -115.553    32.687
>
  -116.109    32.650
  -115.553    32.687
>
  -115.623    33.183
  -115.553    32.687
>
  -115.109    32.448
  -115.553    32.687
>
  -115.109    32.448
  -115.553    32.687
>
  -114.985    32.739
  -115.553    32.687
>
  -114.985    32.739
  -115.553    32.687
>
  -114.985    32.739
  -115.553    32.687
>
  -114.985    32.739
  -115.553    32.687
>
  -114.977    32.972
  -115.553    32.687
>
  -114.977    32.972
  -115.553    32.687
>
  -115.579    33.279
  -115.553    32.687
>
  -115.161    32.266
  -115.553    32.687
>
  -115.161    32.266
  -115.553    32.687
>
  -114.964    32.433
  -115.553    32.687
>
  -114.964    32.433
  -115.553    32.687
>
  -114.964    32.433
  -115.553    32.687
>
  -115.076    32.303
  -115.553    32.687
>
  -115.076    32.303
  -115.553    32.687
>
  -115.076    32.303
  -115.553    32.687
>
  -115.284    32.135
  -115.553    32.687
>
  -115.284    32.135
  -115.553    32.687
>
  -115.922    32.647
  -115.877    32.725
>
  -115.922    32.647
  -115.877    32.725
>
  -116.019    32.748
  -115.877    32.725
>
  -115.728    32.850
  -115.877    32.725
>
  -115.728    32.850
  -115.877    32.725
>
  -115.969    32.887
  -115.877    32.725
>
  -115.725    32.649
  -115.877    32.725
>
  -115.725    32.649
  -115.877    32.725
>
  -116.097    32.792
  -115.877    32.725
>
  -116.097    32.792
  -115.877    32.725
>
  -115.669    32.652
  -115.877    32.725
>
  -115.800    32.945
  -115.877    32.725
>
  -115.800    32.945
  -115.877    32.725
>
  -115.800    32.945
  -115.877    32.725
>
  -115.800    32.945
  -115.877    32.725
>
  -115.824    32.955
  -115.877    32.725
>
  -115.824    32.955
  -115.877    32.725
>
  -115.621    32.765
  -115.877    32.725
>
  -116.109    32.650
  -115.877    32.725
>
  -115.595    32.752
  -115.877    32.725
>
  -116.079    32.603
  -115.877    32.725
>
  -116.079    32.603
  -115.877    32.725
>
  -115.561    32.902
  -115.877    32.725
>
  -115.561    32.902
  -115.877    32.725
>
  -115.561    32.902
  -115.877    32.725
>
  -115.505    32.829
  -115.877    32.725
>
  -115.581    32.537
  -115.877    32.725
>
  -115.581    32.537
  -115.877    32.725
>
  -115.581    32.537
  -115.877    32.725
>
  -115.472    32.664
  -115.877    32.725
>
  -115.472    32.664
  -115.877    32.725
>
  -115.447    32.805
  -115.877    32.725
>
  -115.447    32.805
  -115.877    32.725
>
  -115.823    33.117
  -115.877    32.725
>
  -115.582    33.038
  -115.877    32.725
>
  -115.437    32.862
  -115.877    32.725
>
  -115.445    32.632
  -115.877    32.725
>
  -115.445    32.632
  -115.877    32.725
>
  -115.978    33.174
  -115.877    32.725
>
  -116.366    32.651
  -115.877    32.725
>
  -115.531    33.098
  -115.877    32.725
>
  -116.168    33.156
  -115.877    32.725
>
  -116.168    33.156
  -115.877    32.725
>
  -115.616    33.178
  -115.877    32.725
>
  -115.616    33.178
  -115.877    32.725
>
  -115.623    33.183
  -115.877    32.725
>
  -115.623    33.183
  -115.877    32.725
>
  -116.411    32.972
  -115.877    32.725
>
  -116.411    32.972
  -115.877    32.725
>
  -115.320    32.960
  -115.877    32.725
>
  -116.485    32.643
  -115.877    32.725
>
  -116.485    32.643
  -115.877    32.725
>
  -115.986    33.280
  -115.877    32.725
>
  -115.986    33.280
  -115.877    32.725
>
  -116.529    32.823
  -115.877    32.725
>
  -116.529    32.823
  -115.877    32.725
>
  -116.438    33.077
  -115.877    32.725
>
  -116.438    33.077
  -115.877    32.725
>
  -115.304    32.418
  -115.877    32.725
>
  -115.304    32.418
  -115.877    32.725
>
  -115.305    32.420
  -115.877    32.725
>
  -115.305    32.420
  -115.877    32.725
>
  -115.304    32.418
  -115.494    32.365
>
  -115.304    32.418
  -115.494    32.365
>
  -115.305    32.420
  -115.494    32.365
>
  -115.581    32.537
  -115.494    32.365
>
  -115.581    32.537
  -115.494    32.365
>
  -115.581    32.537
  -115.494    32.365
>
  -115.198    32.407
  -115.494    32.365
>
  -115.445    32.632
  -115.494    32.365
>
  -115.445    32.632
  -115.494    32.365
>
  -115.161    32.266
  -115.494    32.365
>
  -115.161    32.266
  -115.494    32.365
>
  -115.284    32.135
  -115.494    32.365
>
  -115.284    32.135
  -115.494    32.365
>
  -115.725    32.649
  -115.494    32.365
>
  -115.725    32.649
  -115.494    32.365
>
  -115.109    32.448
  -115.494    32.365
>
  -115.109    32.448
  -115.494    32.365
>
  -115.076    32.303
  -115.494    32.365
>
  -115.621    32.765
  -115.494    32.365
>
  -115.621    32.765
  -115.494    32.365
>
  -115.094    32.605
  -115.494    32.365
>
  -115.708    32.007
  -115.494    32.365
>
  -115.447    32.805
  -115.494    32.365
>
  -115.447    32.805
  -115.494    32.365
>
  -115.447    32.805
  -115.494    32.365
>
  -114.964    32.433
  -115.494    32.365
>
  -114.964    32.433
  -115.494    32.365
>
  -115.093    32.708
  -115.494    32.365
>
  -115.437    32.862
  -115.494    32.365
>
  -115.437    32.862
  -115.494    32.365
>
  -114.961    32.166
  -115.494    32.365
>
  -115.561    32.902
  -115.494    32.365
>
  -115.561    32.902
  -115.494    32.365
>
  -115.561    32.902
  -115.494    32.365
>
  -114.985    32.739
  -115.494    32.365
>
  -114.985    32.739
  -115.494    32.365
>
  -115.123    32.863
  -115.494    32.365
>
  -115.123    32.863
  -115.494    32.365
>
  -116.019    32.748
  -115.494    32.365
>
  -116.109    32.650
  -115.494    32.365
>
  -116.109    32.650
  -115.494    32.365
>
  -116.079    32.603
  -115.587    32.784
>
  -116.079    32.603
  -115.587    32.784
>
  -116.079    32.603
  -115.587    32.784
>
  -116.109    32.650
  -115.587    32.784
>
  -116.109    32.650
  -115.587    32.784
>
  -116.109    32.650
  -115.587    32.784
>
  -115.922    32.647
  -115.587    32.784
>
  -115.922    32.647
  -115.587    32.784
>
  -115.922    32.647
  -115.587    32.784
>
  -115.581    32.537
  -115.587    32.784
>
  -115.581    32.537
  -115.587    32.784
>
  -115.581    32.537
  -115.587    32.784
>
  -115.725    32.649
  -115.587    32.784
>
  -115.725    32.649
  -115.587    32.784
>
  -116.019    32.748
  -115.587    32.784
>
  -116.019    32.748
  -115.587    32.784
>
  -116.097    32.792
  -115.587    32.784
>
  -116.097    32.792
  -115.587    32.784
>
  -115.304    32.418
  -115.587    32.784
>
  -115.304    32.418
  -115.587    32.784
>
  -115.305    32.420
  -115.587    32.784
>
  -115.305    32.420
  -115.587    32.784
>
  -115.445    32.632
  -115.587    32.784
>
  -115.595    32.752
  -115.587    32.784
>
  -115.595    32.752
  -115.587    32.784
>
  -115.621    32.765
  -115.587    32.784
>
  -115.969    32.887
  -115.587    32.784
>
  -115.969    32.887
  -115.587    32.784
>
  -115.969    32.887
  -115.587    32.784
>
  -115.198    32.407
  -115.587    32.784
>
  -115.728    32.850
  -115.587    32.784
>
  -115.728    32.850
  -115.587    32.784
>
  -115.728    32.850
  -115.587    32.784
>
  -115.505    32.829
  -115.587    32.784
>
  -115.800    32.945
  -115.587    32.784
>
  -115.800    32.945
  -115.587    32.784
>
  -115.800    32.945
  -115.587    32.784
>
  -115.824    32.955
  -115.587    32.784
>
  -115.824    32.955
  -115.587    32.784
>
  -115.447    32.805
  -115.587    32.784
>
  -115.109    32.448
  -115.587    32.784
>
  -115.109    32.448
  -115.587    32.784
>
  -115.561    32.902
  -115.587    32.784
>
  -115.561    32.902
  -115.587    32.784
>
  -115.437    32.862
  -115.587    32.784
>
  -115.094    32.605
  -115.587    32.784
>
  -115.513    32.991
  -115.587    32.784
>
  -115.582    33.038
  -115.587    32.784
>
  -115.093    32.708
  -115.587    32.784
>
  -115.093    32.708
  -115.587    32.784
>
  -115.823    33.117
  -115.587    32.784
>
  -115.823    33.117
  -115.587    32.784
>
  -115.320    32.960
  -115.587    32.784
>
  -115.320    32.960
  -115.587    32.784
>
  -115.978    33.174
  -115.587    32.784
>
  -115.978    33.174
  -115.587    32.784
>
  -115.531    33.098
  -115.587    32.784
>
  -115.531    33.098
  -115.587    32.784
>
  -115.580    33.121
  -115.587    32.784
>
  -115.580    33.121
  -115.587    32.784
>
  -115.123    32.863
  -115.587    32.784
>
  -115.123    32.863
  -115.587    32.784
>
  -114.985    32.739
  -115.587    32.784
>
  -115.616    33.178
  -115.587    32.784
>
  -115.616    33.178
  -115.587    32.784
>
  -115.623    33.183
  -115.587    32.784
>
  -115.986    33.280
  -115.587    32.784
>
  -115.986    33.280
  -115.587    32.784
>
  -115.579    33.279
  -115.587    32.784
>
  -115.579    33.279
  -115.587    32.784
>
  -114.977    32.972
  -115.587    32.784
>
  -114.977    32.972
  -115.587    32.784
>
  -115.733    33.353
  -115.587    32.784
>
  -115.730    33.365
  -115.587    32.784
>
  -115.595    32.752
  -115.576    32.774
>
  -115.447    32.805
  -115.576    32.774
>
  -115.437    32.862
  -115.576    32.774
>
  -115.728    32.850
  -115.576    32.774
>
  -115.728    32.850
  -115.576    32.774
>
  -115.513    32.991
  -115.576    32.774
>
  -115.445    32.632
  -115.576    32.774
>
  -115.725    32.649
  -115.576    32.774
>
  -115.725    32.649
  -115.576    32.774
>
  -115.582    33.038
  -115.576    32.774
>
  -115.800    32.945
  -115.576    32.774
>
  -115.800    32.945
  -115.576    32.774
>
  -115.800    32.945
  -115.576    32.774
>
  -115.800    32.945
  -115.576    32.774
>
  -115.800    32.945
  -115.576    32.774
>
  -115.320    32.960
  -115.576    32.774
>
  -115.320    32.960
  -115.576    32.774
>
  -115.824    32.955
  -115.576    32.774
>
  -115.824    32.955
  -115.576    32.774
>
  -115.581    32.537
  -115.576    32.774
>
  -115.581    32.537
  -115.576    32.774
>
  -115.531    33.098
  -115.576    32.774
>
  -115.531    33.098
  -115.576    32.774
>
  -115.580    33.121
  -115.576    32.774
>
  -115.922    32.647
  -115.576    32.774
>
  -115.922    32.647
  -115.576    32.774
>
  -115.922    32.647
  -115.576    32.774
>
  -115.922    32.647
  -115.576    32.774
>
  -115.922    32.647
  -115.576    32.774
>
  -115.969    32.887
  -115.576    32.774
>
  -115.969    32.887
  -115.576    32.774
>
  -115.616    33.178
  -115.576    32.774
>
  -115.823    33.117
  -115.576    32.774
>
  -115.623    33.183
  -115.576    32.774
>
  -115.123    32.863
  -115.576    32.774
>
  -115.123    32.863
  -115.576    32.774
>
  -116.019    32.748
  -115.576    32.774
>
  -116.019    32.748
  -115.576    32.774
>
  -115.093    32.708
  -115.576    32.774
>
  -115.093    32.708
  -115.576    32.774
>
  -116.097    32.792
  -115.576    32.774
>
  -116.097    32.792
  -115.576    32.774
>
  -115.305    32.420
  -115.576    32.774
>
  -115.304    32.418
  -115.576    32.774
>
  -115.094    32.605
  -115.576    32.774
>
  -115.579    33.279
  -115.576    32.774
>
  -115.579    33.279
  -115.576    32.774
>
  -116.079    32.603
  -115.576    32.774
>
  -116.079    32.603
  -115.576    32.774
>
  -116.079    32.603
  -115.576    32.774
>
  -116.109    32.650
  -115.576    32.774
>
  -116.109    32.650
  -115.576    32.774
>
  -116.109    32.650
  -115.576    32.774
>
  -114.985    32.739
  -115.576    32.774
>
  -115.978    33.174
  -115.576    32.774
>
  -115.978    33.174
  -115.576    32.774
>
  -114.977    32.972
  -115.576    32.774
>
  -114.977    32.972
  -115.576    32.774
>
  -115.109    32.448
  -115.576    32.774
>
  -115.109    32.448
  -115.576    32.774
>
  -115.733    33.353
  -115.576    32.774
>
  -115.561    32.902
  -115.578    32.771
>
  -115.447    32.805
  -115.578    32.771
>
  -115.437    32.862
  -115.578    32.771
>
  -115.728    32.850
  -115.578    32.771
>
  -115.728    32.850
  -115.578    32.771
>
  -115.513    32.991
  -115.578    32.771
>
  -115.445    32.632
  -115.578    32.771
>
  -115.445    32.632
  -115.578    32.771
>
  -115.725    32.649
  -115.578    32.771
>
  -115.725    32.649
  -115.578    32.771
>
  -115.582    33.038
  -115.578    32.771
>
  -115.582    33.038
  -115.578    32.771
>
  -115.800    32.945
  -115.578    32.771
>
  -115.800    32.945
  -115.578    32.771
>
  -115.800    32.945
  -115.578    32.771
>
  -115.320    32.960
  -115.578    32.771
>
  -115.320    32.960
  -115.578    32.771
>
  -115.824    32.955
  -115.578    32.771
>
  -115.824    32.955
  -115.578    32.771
>
  -115.581    32.537
  -115.578    32.771
>
  -115.581    32.537
  -115.578    32.771
>
  -115.581    32.537
  -115.578    32.771
>
  -115.531    33.098
  -115.578    32.771
>
  -115.580    33.121
  -115.578    32.771
>
  -115.922    32.647
  -115.578    32.771
>
  -115.922    32.647
  -115.578    32.771
>
  -115.922    32.647
  -115.578    32.771
>
  -115.922    32.647
  -115.578    32.771
>
  -115.969    32.887
  -115.578    32.771
>
  -115.969    32.887
  -115.578    32.771
>
  -115.123    32.863
  -115.578    32.771
>
  -115.123    32.863
  -115.578    32.771
>
  -115.616    33.178
  -115.578    32.771
>
  -115.623    33.183
  -115.578    32.771
>
  -115.823    33.117
  -115.578    32.771
>
  -115.823    33.117
  -115.578    32.771
>
  -116.019    32.748
  -115.578    32.771
>
  -116.019    32.748
  -115.578    32.771
>
  -115.093    32.708
  -115.578    32.771
>
  -115.094    32.605
  -115.578    32.771
>
  -115.304    32.418
  -115.578    32.771
>
  -115.304    32.418
  -115.578    32.771
>
  -115.305    32.420
  -115.578    32.771
>
  -116.097    32.792
  -115.578    32.771
>
  -116.097    32.792
  -115.578    32.771
>
  -115.579    33.279
  -115.578    32.771
>
  -114.985    32.739
  -115.578    32.771
>
  -116.079    32.603
  -115.578    32.771
>
  -116.109    32.650
  -115.578    32.771
>
  -116.109    32.650
  -115.578    32.771
>
  -115.198    32.407
  -115.578    32.771
>
  -115.198    32.407
  -115.578    32.771
>
  -115.978    33.174
  -115.578    32.771
>
  -115.978    33.174
  -115.578    32.771
>
  -114.977    32.972
  -115.578    32.771
>
  -114.977    32.972
  -115.578    32.771
>
  -115.109    32.448
  -115.578    32.771
>
  -115.109    32.448
  -115.578    32.771
>
  -115.733    33.353
  -115.578    32.771
>
  -115.304    32.418
  -115.261    32.381
>
  -115.304    32.418
  -115.261    32.381
>
  -115.305    32.420
  -115.261    32.381
>
  -115.305    32.420
  -115.261    32.381
>
  -115.198    32.407
  -115.261    32.381
>
  -115.198    32.407
  -115.261    32.381
>
  -115.198    32.407
  -115.261    32.381
>
  -115.198    32.407
  -115.261    32.381
>
  -115.109    32.448
  -115.261    32.381
>
  -115.109    32.448
  -115.261    32.381
>
  -115.109    32.448
  -115.261    32.381
>
  -115.109    32.448
  -115.261    32.381
>
  -115.161    32.266
  -115.261    32.381
>
  -115.161    32.266
  -115.261    32.381
>
  -115.161    32.266
  -115.261    32.381
>
  -115.161    32.266
  -115.261    32.381
>
  -115.076    32.303
  -115.261    32.381
>
  -115.076    32.303
  -115.261    32.381
>
  -115.094    32.605
  -115.261    32.381
>
  -115.094    32.605
  -115.261    32.381
>
  -114.964    32.433
  -115.261    32.381
>
  -114.964    32.433
  -115.261    32.381
>
  -115.284    32.135
  -115.261    32.381
>
  -115.284    32.135
  -115.261    32.381
>
  -115.445    32.632
  -115.261    32.381
>
  -115.445    32.632
  -115.261    32.381
>
  -115.581    32.537
  -115.261    32.381
>
  -115.581    32.537
  -115.261    32.381
>
  -115.581    32.537
  -115.261    32.381
>
  -115.093    32.708
  -115.261    32.381
>
  -115.093    32.708
  -115.261    32.381
>
  -114.961    32.166
  -115.261    32.381
>
  -114.985    32.739
  -115.261    32.381
>
  -114.985    32.739
  -115.261    32.381
>
  -114.985    32.739
  -115.261    32.381
>
  -114.985    32.739
  -115.261    32.381
>
  -115.447    32.805
  -115.261    32.381
>
  -115.447    32.805
  -115.261    32.381
>
  -115.447    32.805
  -115.261    32.381
>
  -115.595    32.752
  -115.261    32.381
>
  -115.595    32.752
  -115.261    32.381
>
  -115.725    32.649
  -115.261    32.381
>
  -115.725    32.649
  -115.261    32.381
>
  -114.705    32.458
  -115.261    32.381
>
  -114.705    32.458
  -115.261    32.381
>
  -114.705    32.458
  -115.261    32.381
>
  -115.123    32.863
  -115.261    32.381
>
  -115.123    32.863
  -115.261    32.381
>
  -115.123    32.863
  -115.261    32.381
>
  -115.123    32.863
  -115.261    32.381
>
  -115.621    32.765
  -115.261    32.381
>
  -115.621    32.765
  -115.261    32.381
>
  -115.437    32.862
  -115.261    32.381
>
  -115.437    32.862
  -115.261    32.381
>
  -115.437    32.862
  -115.261    32.381
>
  -115.437    32.862
  -115.261    32.381
>
  -115.708    32.007
  -115.261    32.381
>
  -115.708    32.007
  -115.261    32.381
>
  -115.708    32.007
  -115.261    32.381
>
  -115.320    32.960
  -115.261    32.381
>
  -115.561    32.902
  -115.261    32.381
>
  -115.561    32.902
  -115.261    32.381
>
  -115.561    32.902
  -115.261    32.381
>
  -115.561    32.902
  -115.261    32.381
>
  -115.304    32.418
  -115.253    32.397
>
  -115.304    32.418
  -115.253    32.397
>
  -115.305    32.420
  -115.253    32.397
>
  -115.305    32.420
  -115.253    32.397
>
  -115.198    32.407
  -115.253    32.397
>
  -115.109    32.448
  -115.253    32.397
>
  -115.109    32.448
  -115.253    32.397
>
  -115.109    32.448
  -115.253    32.397
>
  -115.109    32.448
  -115.253    32.397
>
  -115.161    32.266
  -115.253    32.397
>
  -115.161    32.266
  -115.253    32.397
>
  -115.161    32.266
  -115.253    32.397
>
  -115.161    32.266
  -115.253    32.397
>
  -115.076    32.303
  -115.253    32.397
>
  -115.076    32.303
  -115.253    32.397
>
  -115.076    32.303
  -115.253    32.397
>
  -115.094    32.605
  -115.253    32.397
>
  -115.094    32.605
  -115.253    32.397
>
  -114.964    32.433
  -115.253    32.397
>
  -114.964    32.433
  -115.253    32.397
>
  -114.964    32.433
  -115.253    32.397
>
  -115.581    32.537
  -115.253    32.397
>
  -115.581    32.537
  -115.253    32.397
>
  -115.581    32.537
  -115.253    32.397
>
  -115.581    32.537
  -115.253    32.397
>
  -115.093    32.708
  -115.253    32.397
>
  -115.284    32.135
  -115.253    32.397
>
  -115.284    32.135
  -115.253    32.397
>
  -115.284    32.135
  -115.253    32.397
>
  -114.961    32.166
  -115.253    32.397
>
  -114.961    32.166
  -115.253    32.397
>
  -114.985    32.739
  -115.253    32.397
>
  -114.985    32.739
  -115.253    32.397
>
  -114.985    32.739
  -115.253    32.397
>
  -114.985    32.739
  -115.253    32.397
>
  -115.447    32.805
  -115.253    32.397
>
  -115.447    32.805
  -115.253    32.397
>
  -115.595    32.752
  -115.253    32.397
>
  -115.595    32.752
  -115.253    32.397
>
  -115.725    32.649
  -115.253    32.397
>
  -115.725    32.649
  -115.253    32.397
>
  -115.725    32.649
  -115.253    32.397
>
  -115.621    32.765
  -115.253    32.397
>
  -115.621    32.765
  -115.253    32.397
>
  -115.123    32.863
  -115.253    32.397
>
  -115.123    32.863
  -115.253    32.397
>
  -115.123    32.863
  -115.253    32.397
>
  -115.437    32.862
  -115.253    32.397
>
  -115.437    32.862
  -115.253    32.397
>
  -114.705    32.458
  -115.253    32.397
>
  -114.705    32.458
  -115.253    32.397
>
  -114.705    32.458
  -115.253    32.397
>
  -114.705    32.458
  -115.253    32.397
>
  -115.561    32.902
  -115.253    32.397
>
  -115.561    32.902
  -115.253    32.397
>
  -115.561    32.902
  -115.253    32.397
>
  -115.561    32.902
  -115.253    32.397
>
  -115.708    32.007
  -115.253    32.397
>
  -115.708    32.007
  -115.253    32.397
>
  -114.784    32.845
  -115.253    32.397
>
  -114.784    32.845
  -115.253    32.397
>
  -115.304    32.418
  -115.266    32.392
>
  -115.304    32.418
  -115.266    32.392
>
  -115.305    32.420
  -115.266    32.392
>
  -115.305    32.420
  -115.266    32.392
>
  -115.198    32.407
  -115.266    32.392
>
  -115.198    32.407
  -115.266    32.392
>
  -115.198    32.407
  -115.266    32.392
>
  -115.198    32.407
  -115.266    32.392
>
  -115.198    32.407
  -115.266    32.392
>
  -115.109    32.448
  -115.266    32.392
>
  -115.109    32.448
  -115.266    32.392
>
  -115.109    32.448
  -115.266    32.392
>
  -115.109    32.448
  -115.266    32.392
>
  -115.161    32.266
  -115.266    32.392
>
  -115.161    32.266
  -115.266    32.392
>
  -115.094    32.605
  -115.266    32.392
>
  -115.094    32.605
  -115.266    32.392
>
  -115.076    32.303
  -115.266    32.392
>
  -115.076    32.303
  -115.266    32.392
>
  -114.964    32.433
  -115.266    32.392
>
  -114.964    32.433
  -115.266    32.392
>
  -115.581    32.537
  -115.266    32.392
>
  -115.581    32.537
  -115.266    32.392
>
  -115.581    32.537
  -115.266    32.392
>
  -115.284    32.135
  -115.266    32.392
>
  -115.284    32.135
  -115.266    32.392
>
  -114.985    32.739
  -115.266    32.392
>
  -114.985    32.739
  -115.266    32.392
>
  -114.961    32.166
  -115.266    32.392
>
  -115.447    32.805
  -115.266    32.392
>
  -115.725    32.649
  -115.266    32.392
>
  -115.123    32.863
  -115.266    32.392
>
  -115.123    32.863
  -115.266    32.392
>
  -115.437    32.862
  -115.266    32.392
>
  -114.705    32.458
  -115.266    32.392
>
  -114.705    32.458
  -115.266    32.392
>
  -115.561    32.902
  -115.266    32.392
>
  -115.708    32.007
  -115.266    32.392
>
  -115.708    32.007
  -115.266    32.392
>
  -115.708    32.007
  -115.266    32.392
>
  -115.161    32.266
  -115.268    32.388
>
  -115.161    32.266
  -115.268    32.388
>
  -115.198    32.407
  -115.268    32.388
>
  -115.304    32.418
  -115.268    32.388
>
  -115.305    32.420
  -115.268    32.388
>
  -115.305    32.420
  -115.268    32.388
>
  -115.076    32.303
  -115.268    32.388
>
  -115.284    32.135
  -115.268    32.388
>
  -115.109    32.448
  -115.268    32.388
>
  -115.109    32.448
  -115.268    32.388
>
  -115.109    32.448
  -115.268    32.388
>
  -114.964    32.433
  -115.268    32.388
>
  -114.964    32.433
  -115.268    32.388
>
  -114.961    32.166
  -115.268    32.388
>
  -115.094    32.605
  -115.268    32.388
>
  -115.094    32.605
  -115.268    32.388
>
  -115.581    32.537
  -115.268    32.388
>
  -115.581    32.537
  -115.268    32.388
>
  -115.581    32.537
  -115.268    32.388
>
  -115.093    32.708
  -115.268    32.388
>
  -115.708    32.007
  -115.268    32.388
>
  -114.705    32.458
  -115.268    32.388
>
  -114.985    32.739
  -115.268    32.388
>
  -114.985    32.739
  -115.268    32.388
>
  -114.985    32.739
  -115.268    32.388
>
  -114.985    32.739
  -115.268    32.388
>
  -115.725    32.649
  -115.268    32.388
>
  -115.447    32.805
  -115.268    32.388
>
  -115.447    32.805
  -115.268    32.388
>
  -115.725    32.649
  -115.268    32.388
>
  -115.595    32.752
  -115.268    32.388
>
  -115.595    32.752
  -115.268    32.388
>
  -115.621    32.765
  -115.268    32.388
>
  -115.505    32.829
  -115.268    32.388
>
  -115.123    32.863
  -115.268    32.388
>
  -115.123    32.863
  -115.268    32.388
>
  -115.437    32.862
  -115.268    32.388
>
  -115.437    32.862
  -115.268    32.388
>
  -115.561    32.902
  -115.268    32.388
>
  -115.561    32.902
  -115.268    32.388
>
  -115.561    32.902
  -115.268    32.388
>
  -115.320    32.960
  -115.268    32.388
>
  -115.198    32.407
  -115.239    32.408
>
  -115.198    32.407
  -115.239    32.408
>
  -115.198    32.407
  -115.239    32.408
>
  -115.198    32.407
  -115.239    32.408
>
  -115.304    32.418
  -115.239    32.408
>
  -115.304    32.418
  -115.239    32.408
>
  -115.305    32.420
  -115.239    32.408
>
  -115.305    32.420
  -115.239    32.408
>
  -115.109    32.448
  -115.239    32.408
>
  -115.109    32.448
  -115.239    32.408
>
  -115.109    32.448
  -115.239    32.408
>
  -115.109    32.448
  -115.239    32.408
>
  -115.161    32.266
  -115.239    32.408
>
  -115.076    32.303
  -115.239    32.408
>
  -115.076    32.303
  -115.239    32.408
>
  -115.094    32.605
  -115.239    32.408
>
  -115.094    32.605
  -115.239    32.408
>
  -114.964    32.433
  -115.239    32.408
>
  -114.964    32.433
  -115.239    32.408
>
  -114.964    32.433
  -115.239    32.408
>
  -115.284    32.135
  -115.239    32.408
>
  -115.284    32.135
  -115.239    32.408
>
  -115.581    32.537
  -115.239    32.408
>
  -115.581    32.537
  -115.239    32.408
>
  -115.581    32.537
  -115.239    32.408
>
  -115.093    32.708
  -115.239    32.408
>
  -115.093    32.708
  -115.239    32.408
>
  -114.961    32.166
  -115.239    32.408
>
  -114.961    32.166
  -115.239    32.408
>
  -114.985    32.739
  -115.239    32.408
>
  -114.985    32.739
  -115.239    32.408
>
  -114.985    32.739
  -115.239    32.408
>
  -114.985    32.739
  -115.239    32.408
>
  -115.447    32.805
  -115.239    32.408
>
  -115.447    32.805
  -115.239    32.408
>
  -115.447    32.805
  -115.239    32.408
>
  -115.595    32.752
  -115.239    32.408
>
  -115.595    32.752
  -115.239    32.408
>
  -115.123    32.863
  -115.239    32.408
>
  -115.123    32.863
  -115.239    32.408
>
  -115.123    32.863
  -115.239    32.408
>
  -114.705    32.458
  -115.239    32.408
>
  -114.705    32.458
  -115.239    32.408
>
  -115.725    32.649
  -115.239    32.408
>
  -115.437    32.862
  -115.239    32.408
>
  -115.437    32.862
  -115.239    32.408
>
  -115.621    32.765
  -115.239    32.408
>
  -115.621    32.765
  -115.239    32.408
>
  -115.725    32.649
  -115.239    32.408
>
  -115.320    32.960
  -115.239    32.408
>
  -115.561    32.902
  -115.239    32.408
>
  -115.561    32.902
  -115.239    32.408
>
  -115.561    32.902
  -115.239    32.408
>
  -115.561    32.902
  -115.239    32.408
>
  -114.784    32.845
  -115.239    32.408
>
  -115.708    32.007
  -115.239    32.408
>
  -115.708    32.007
  -115.239    32.408
>
  -115.708    32.007
  -115.239    32.408
>
  -115.198    32.407
  -115.214    32.387
>
  -115.198    32.407
  -115.214    32.387
>
  -115.198    32.407
  -115.214    32.387
>
  -115.109    32.448
  -115.214    32.387
>
  -115.109    32.448
  -115.214    32.387
>
  -115.304    32.418
  -115.214    32.387
>
  -115.304    32.418
  -115.214    32.387
>
  -115.076    32.303
  -115.214    32.387
>
  -115.076    32.303
  -115.214    32.387
>
  -114.964    32.433
  -115.214    32.387
>
  -114.964    32.433
  -115.214    32.387
>
  -115.094    32.605
  -115.214    32.387
>
  -115.094    32.605
  -115.214    32.387
>
  -115.284    32.135
  -115.214    32.387
>
  -115.445    32.632
  -115.214    32.387
>
  -115.093    32.708
  -115.214    32.387
>
  -115.093    32.708
  -115.214    32.387
>
  -114.961    32.166
  -115.214    32.387
>
  -114.961    32.166
  -115.214    32.387
>
  -115.581    32.537
  -115.214    32.387
>
  -114.985    32.739
  -115.214    32.387
>
  -114.985    32.739
  -115.214    32.387
>
  -114.985    32.739
  -115.214    32.387
>
  -114.985    32.739
  -115.214    32.387
>
  -114.985    32.739
  -115.214    32.387
>
  -114.985    32.739
  -115.214    32.387
>
  -114.705    32.458
  -115.214    32.387
>
  -114.705    32.458
  -115.214    32.387
>
  -114.705    32.458
  -115.214    32.387
>
  -115.447    32.805
  -115.214    32.387
>
  -115.447    32.805
  -115.214    32.387
>
  -115.447    32.805
  -115.214    32.387
>
  -115.447    32.805
  -115.214    32.387
>
  -115.123    32.863
  -115.214    32.387
>
  -115.123    32.863
  -115.214    32.387
>
  -115.123    32.863
  -115.214    32.387
>
  -115.123    32.863
  -115.214    32.387
>
  -115.595    32.752
  -115.214    32.387
>
  -115.595    32.752
  -115.214    32.387
>
  -115.437    32.862
  -115.214    32.387
>
  -115.437    32.862
  -115.214    32.387
>
  -115.437    32.862
  -115.214    32.387
>
  -115.621    32.765
  -115.214    32.387
>
  -115.725    32.649
  -115.214    32.387
>
  -115.725    32.649
  -115.214    32.387
>
  -115.725    32.649
  -115.214    32.387
>
  -115.725    32.649
  -115.214    32.387
>
  -114.784    32.845
  -115.214    32.387
>
  -114.784    32.845
  -115.214    32.387
>
  -115.320    32.960
  -115.214    32.387
>
  -115.561    32.902
  -115.214    32.387
>
  -115.561    32.902
  -115.214    32.387
>
  -115.561    32.902
  -115.214    32.387
>
  -115.561    32.902
  -115.214    32.387
>
  -114.745    31.959
  -115.214    32.387
>
  -114.745    31.959
  -115.214    32.387
>
  -115.708    32.007
  -115.214    32.387
>
  -115.708    32.007
  -115.214    32.387
>
  -115.198    32.407
  -115.192    32.399
>
  -115.198    32.407
  -115.192    32.399
>
  -115.198    32.407
  -115.192    32.399
>
  -115.198    32.407
  -115.192    32.399
>
  -115.109    32.448
  -115.192    32.399
>
  -115.304    32.418
  -115.192    32.399
>
  -115.304    32.418
  -115.192    32.399
>
  -115.076    32.303
  -115.192    32.399
>
  -115.076    32.303
  -115.192    32.399
>
  -114.964    32.433
  -115.192    32.399
>
  -114.964    32.433
  -115.192    32.399
>
  -115.094    32.605
  -115.192    32.399
>
  -115.094    32.605
  -115.192    32.399
>
  -115.284    32.135
  -115.192    32.399
>
  -114.961    32.166
  -115.192    32.399
>
  -114.961    32.166
  -115.192    32.399
>
  -115.445    32.632
  -115.192    32.399
>
  -115.445    32.632
  -115.192    32.399
>
  -115.581    32.537
  -115.192    32.399
>
  -115.581    32.537
  -115.192    32.399
>
  -114.705    32.458
  -115.192    32.399
>
  -114.705    32.458
  -115.192    32.399
>
  -114.705    32.458
  -115.192    32.399
>
  -115.123    32.863
  -115.192    32.399
>
  -115.123    32.863
  -115.192    32.399
>
  -115.447    32.805
  -115.192    32.399
>
  -115.437    32.862
  -115.192    32.399
>
  -115.437    32.862
  -115.192    32.399
>
  -115.725    32.649
  -115.192    32.399
>
  -115.725    32.649
  -115.192    32.399
>
  -115.725    32.649
  -115.192    32.399
>
  -114.745    31.959
  -115.192    32.399
>
  -114.745    31.959
  -115.192    32.399
>
  -115.561    32.902
  -115.192    32.399
>
  -115.561    32.902
  -115.192    32.399
>
  -115.708    32.007
  -115.192    32.399
>
  -115.708    32.007
  -115.192    32.399
>
  -115.304    32.418
  -115.396    32.293
>
  -115.304    32.418
  -115.396    32.293
>
  -115.305    32.420
  -115.396    32.293
>
  -115.305    32.420
  -115.396    32.293
>
  -115.161    32.266
  -115.396    32.293
>
  -115.076    32.303
  -115.396    32.293
>
  -115.109    32.448
  -115.396    32.293
>
  -115.109    32.448
  -115.396    32.293
>
  -115.581    32.537
  -115.396    32.293
>
  -115.581    32.537
  -115.396    32.293
>
  -115.581    32.537
  -115.396    32.293
>
  -115.708    32.007
  -115.396    32.293
>
  -115.708    32.007
  -115.396    32.293
>
  -114.961    32.166
  -115.396    32.293
>
  -115.445    32.632
  -115.396    32.293
>
  -115.445    32.632
  -115.396    32.293
>
  -114.964    32.433
  -115.396    32.293
>
  -114.964    32.433
  -115.396    32.293
>
  -115.094    32.605
  -115.396    32.293
>
  -115.725    32.649
  -115.396    32.293
>
  -115.725    32.649
  -115.396    32.293
>
  -115.595    32.752
  -115.396    32.293
>
  -115.621    32.765
  -115.396    32.293
>
  -115.447    32.805
  -115.396    32.293
>
  -115.447    32.805
  -115.396    32.293
>
  -115.447    32.805
  -115.396    32.293
>
  -114.985    32.739
  -115.396    32.293
>
  -114.985    32.739
  -115.396    32.293
>
  -114.985    32.739
  -115.396    32.293
>
  -114.985    32.739
  -115.396    32.293
>
  -115.922    32.647
  -115.396    32.293
>
  -115.922    32.647
  -115.396    32.293
>
  -115.437    32.862
  -115.396    32.293
>
  -115.437    32.862
  -115.396    32.293
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -115.242    32.487     0.300
  -115.187    32.355     0.300
  -114.960    32.164     0.300
  -114.985    32.739     0.300
  -115.725    32.649     0.300
  -115.663    32.743     0.300
  -115.732    32.759     0.300
  -116.101    32.659     0.300
  -116.079    32.603     0.300
  -115.923    32.648     0.300
  -115.969    32.887     0.300
  -115.727    32.849     0.300
  -115.800    32.945     0.300
  -116.422    32.892     0.300
  -116.672    32.680     0.300
  -115.304    32.418     0.300
  -115.437    32.862     0.300
  -115.123    32.863     0.300
  -115.242    31.988     0.300
  -115.220    33.012     0.300
  -114.580    32.536     0.300
  -115.942    31.928     0.300
  -115.198    32.407     0.300
  -114.705    32.456     0.300
  -115.447    32.805     0.300
  -116.423    32.893     0.300
  -114.545    32.555     0.300
  -114.977    32.972     0.300
  -115.051    31.472     0.300
  -116.252    32.900     0.300
  -115.823    33.117     0.300
  -115.247    32.048     0.300
  -115.351    32.396     0.300
  -115.529    32.146     0.300
  -115.297    32.502     0.300
  -115.190    31.856     0.300
  -115.699    32.311     0.300
  -115.284    31.843     0.300
  -115.744    32.466     0.300
  -116.093    32.661     0.300
  -115.527    33.141     0.300
  -116.109    32.650     0.300
  -116.664    32.313     0.300
  -116.598    31.657     0.300
  -116.725    31.742     0.300
  -116.675    32.433     0.300
  -115.445    32.632     0.300
  -116.029    32.553     0.300
  -116.607    32.569     0.300
  -115.948    32.005     0.300
  -115.145    32.473     0.300
  -115.076    32.303     0.300
  -115.472    32.664     0.300
  -115.922    32.647     0.300
  -115.824    32.955     0.300
  -115.728    32.850     0.300
  -116.254    33.193     0.300
  -115.669    32.652     0.300
  -115.986    33.280     0.300
  -116.598    33.081     0.300
  -115.561    32.902     0.300
  -115.582    33.038     0.300
  -116.417    33.268     0.300
  -116.647    33.199     0.300
  -116.775    32.607     0.300
  -114.961    32.166     0.300
  -115.161    32.266     0.300
  -114.849    32.505     0.300
  -114.745    31.959     0.300
  -114.705    32.458     0.300
  -115.094    32.605     0.300
  -115.393    32.600     0.300
  -115.385    32.628     0.300
  -115.486    32.602     0.300
  -115.390    32.667     0.300
  -115.338    32.693     0.300
  -114.750    32.681     0.300
  -115.581    32.537     0.300
  -115.708    32.007     0.300
  -115.492    32.669     0.300
  -114.964    32.433     0.300
  -115.284    32.135     0.300
  -115.580    33.121     0.300
  -115.304    33.239     0.300
  -115.130    32.422     0.300
  -115.316    32.464     0.300
  -115.217    32.532     0.300
  -115.414    32.626     0.300
  -115.574    32.631     0.300
  -115.946    32.595     0.300
  -115.816    31.871     0.300
  -116.019    32.748     0.300
  -115.824    32.955     0.300
  -115.595    32.752     0.300
  -116.097    32.792     0.300
  -115.561    32.902     0.300
  -115.447    32.805     0.300
  -115.823    33.117     0.300
  -115.531    33.098     0.300
  -116.303    32.955     0.300
  -115.616    33.178     0.300
  -115.623    33.183     0.300
  -116.366    32.651     0.300
  -116.168    33.156     0.300
  -115.986    33.280     0.300
  -116.411    32.972     0.300
  -115.579    33.279     0.300
  -115.305    32.420     0.300
  -116.485    32.643     0.300
  -115.295    32.385     0.300
  -116.529    32.823     0.300
  -115.093    32.708     0.300
  -115.841    32.116     0.300
  -114.745    31.960     0.300
  -115.094    32.605     0.300
  -114.985    32.739     0.300
  -114.784    32.845     0.300
  -115.800    32.945     0.300
  -115.978    33.174     0.300
  -116.438    33.077     0.300
  -115.582    33.038     0.300
  -116.579    32.959     0.300
  -116.627    32.906     0.300
  -116.598    33.081     0.300
  -116.417    33.268     0.300
  -116.367    33.327     0.300
  -115.568    32.780     0.300
  -115.621    32.765     0.300
  -115.505    32.829     0.300
  -115.320    32.960     0.300
  -115.109    32.448     0.300
  -115.109    32.448     0.300
  -115.513    32.991     0.300
  -115.733    33.353     0.300
  -115.730    33.365     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -115.266    32.385     0.200
>
  -115.279    32.372     0.200
>
  -115.219    32.387     0.200
>
  -115.244    32.398     0.200
>
  -116.047    32.684     0.200
>
  -115.965    32.797     0.200
>
  -116.038    32.675     0.200
>
  -115.313    32.451     0.200
>
  -115.312    32.441     0.200
>
  -115.329    32.459     0.200
>
  -115.334    32.445     0.200
>
  -115.327    32.459     0.200
>
  -115.334    32.455     0.200
>
  -115.313    32.448     0.200
>
  -115.321    32.445     0.200
>
  -115.336    32.456     0.200
>
  -115.341    32.451     0.200
>
  -115.316    32.403     0.200
>
  -115.245    32.394     0.200
>
  -115.344    32.221     0.200
>
  -115.263    32.368     0.200
>
  -115.372    32.401     0.200
>
  -115.514    32.538     0.200
>
  -115.263    32.340     0.200
>
  -115.719    32.114     0.200
>
  -115.287    32.374     0.200
>
  -115.286    32.357     0.200
>
  -115.344    32.194     0.200
>
  -115.645    32.667     0.200
>
  -115.831    32.692     0.200
>
  -115.130    32.396     0.200
>
  -115.208    32.442     0.200
>
  -115.213    32.483     0.200
>
  -115.190    32.386     0.200
>
  -115.294    32.290     0.200
>
  -115.293    32.289     0.200
>
  -115.259    32.355     0.200
>
  -115.302    32.274     0.200
>
  -115.298    32.269     0.200
>
  -115.240    31.982     0.200
>
  -115.202    32.176     0.200
>
  -115.291    32.203     0.200
>
  -115.381    32.277     0.200
>
  -115.566    32.425     0.200
>
  -115.031    31.939     0.200
>
  -115.376    32.311     0.200
>
  -115.429    32.295     0.200
>
  -115.234    32.136     0.200
>
  -115.232    32.187     0.200
>
  -115.751    32.580     0.200
>
  -115.630    32.493     0.200
>
  -115.784    32.621     0.200
>
  -115.285    32.203     0.200
>
  -115.558    32.438     0.200
>
  -115.087    32.029     0.200
>
  -115.784    32.624     0.200
>
  -115.348    32.297     0.200
>
  -115.803    32.669     0.200
>
  -115.771    32.632     0.200
>
  -115.270    32.182     0.200
>
  -115.212    32.143     0.200
>
  -115.108    32.059     0.200
>
  -115.337    32.294     0.200
>
  -115.756    32.593     0.200
>
  -115.788    32.645     0.200
>
  -115.308    32.201     0.200
>
  -115.080    32.059     0.200
>
  -115.731    32.605     0.200
>
  -115.046    31.983     0.200
>
  -115.894    32.696     0.200
>
  -115.106    32.002     0.200
>
  -115.302    32.207     0.200
>
  -115.283    32.209     0.200
>
  -115.761    32.660     0.200
>
  -115.758    32.594     0.200
>
  -115.285    32.213     0.200
>
  -115.381    32.300     0.200
>
  -115.322    32.191     0.200
>
  -115.372    32.272     0.200
>
  -115.263    32.194     0.200
>
  -115.762    32.648     0.200
>
  -115.333    32.295     0.200
>
  -115.761    32.650     0.200
>
  -115.246    32.133     0.200
>
  -115.085    32.046     0.200
>
  -115.085    32.063     0.200
>
  -115.075    32.060     0.200
>
  -115.199    32.125     0.200
>
  -115.350    32.270     0.200
>
  -115.143    32.107     0.200
>
  -115.844    32.672     0.200
>
  -115.623    32.491     0.200
>
  -115.790    32.646     0.200
>
  -115.795    32.645     0.200
>
  -115.328    32.297     0.200
>
  -115.832    32.665     0.200
>
  -115.454    32.319     0.200
>
  -115.306    32.249     0.200
>
  -115.062    32.027     0.200
>
  -115.883    32.700     0.200
>
  -115.864    32.677     0.200
>
  -115.793    32.658     0.200
>
  -115.805    32.641     0.200
>
  -115.814    32.645     0.200
>
  -115.860    32.680     0.200
>
  -115.275    32.186     0.200
>
  -115.272    32.185     0.200
>
  -115.824    32.637     0.200
>
  -115.855    32.648     0.200
>
  -115.947    32.686     0.200
>
  -115.750    32.588     0.200
>
  -115.762    32.599     0.200
>
  -115.752    32.587     0.200
>
  -115.826    32.646     0.200
>
  -115.310    32.221     0.200
>
  -115.207    32.120     0.200
>
  -115.907    32.680     0.200
>
  -115.098    32.066     0.200
>
  -115.331    32.317     0.200
>
  -115.207    32.389     0.200
>
  -115.325    32.218     0.200
>
  -115.912    32.674     0.200
>
  -115.943    32.683     0.200
>
  -115.948    32.690     0.200
>
  -115.900    32.659     0.200
>
  -115.949    32.694     0.200
>
  -115.786    32.614     0.200
>
  -115.343    32.245     0.200
>
  -115.360    32.272     0.200
>
  -115.086    32.069     0.200
>
  -115.178    32.112     0.200
>
  -115.261    32.183     0.200
>
  -115.336    32.250     0.200
>
  -115.121    32.062     0.200
>
  -115.292    32.202     0.200
>
  -115.995    32.859     0.200
>
  -115.753    32.592     0.200
>
  -115.279    32.189     0.200
>
  -115.825    32.645     0.200
>
  -115.330    32.221     0.200
>
  -115.926    32.605     0.200
>
  -115.301    32.199     0.200
>
  -115.095    32.039     0.200
>
  -115.241    32.141     0.200
>
  -115.190    32.375     0.200
>
  -115.235    32.368     0.200
>
  -115.722    32.619     0.200
>
  -115.215    32.106     0.200
>
  -115.221    32.128     0.200
>
  -115.732    32.630     0.200
>
  -115.147    32.097     0.200
>
  -116.343    32.037     0.200
>
  -115.210    32.084     0.200
>
  -115.281    32.187     0.200
>
  -115.260    32.345     0.200
>
  -115.191    32.096     0.200
>
  -115.303    32.202     0.200
>
  -115.200    32.101     0.200
>
  -115.306    32.184     0.200
>
  -115.283    32.159     0.200
>
  -115.730    32.087     0.200
>
  -115.233    32.119     0.200
>
  -115.729    32.091     0.200
>
  -115.293    32.203     0.200
>
  -115.707    32.656     0.200
>
  -115.746    32.087     0.200
>
  -115.740    32.081     0.200
>
  -115.325    32.197     0.200
>
  -115.298    32.199     0.200
>
  -115.313    32.196     0.200
>
  -115.296    32.207     0.200
>
  -115.249    32.137     0.200
>
  -115.245    32.125     0.200
>
  -116.142    32.776     0.200
>
  -115.224    32.122     0.200
>
  -115.281    32.390     0.200
>
  -115.317    32.197     0.200
>
  -115.242    32.369     0.200
>
  -115.256    32.171     0.200
>
  -116.267    32.386     0.200
>
  -115.270    32.366     0.200
>
  -115.225    32.373     0.200
>
  -115.218    32.374     0.200
>
  -115.244    32.371     0.200
>
  -116.136    32.811     0.200
>
  -115.086    32.192     0.200
>
  -115.226    32.383     0.200
>
  -115.275    32.184     0.200
>
  -115.552    32.755     0.200
>
  -115.243    32.378     0.200
>
  -115.412    32.302     0.200
>
  -115.838    32.731     0.200
>
  -115.275    32.350     0.200
>
  -115.329    32.314     0.200
>
  -115.222    32.372     0.200
>
  -115.228    32.382     0.200
>
  -116.044    32.819     0.200
>
  -115.556    32.682     0.200
>
  -115.553    32.687     0.200
>
  -115.877    32.725     0.200
>
  -115.494    32.365     0.200
>
  -115.587    32.784     0.200
>
  -115.576    32.774     0.200
>
  -115.578    32.771     0.200
>
  -115.261    32.381     0.200
>
  -115.253    32.397     0.200
>
  -115.266    32.392     0.200
>
  -115.268    32.388     0.200
>
  -115.239    32.408     0.200
>
  -115.214    32.387     0.200
>
  -115.192    32.399     0.200
>
  -115.396    32.293     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -115.446    32.373     0.000   222.000   222.000
  -115.446    32.373     0.000   444.000   444.000
EOF
gmt end
