#!/bin/bash
gmt begin elmayor5.35_base pdf,ps
proj=-JM16.0c+
reg=-R-116.4/-114.9/31.8/33.0
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map elmayor5.35'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -115.266    32.385 1
  -115.279    32.372 2
  -115.219    32.387 3
  -115.244    32.398 4
  -116.047    32.684 5
  -115.965    32.797 6
  -116.038    32.675 7
  -115.313    32.451 8
  -115.312    32.441 9
  -115.329    32.459 10
  -115.334    32.445 11
  -115.327    32.459 12
  -115.334    32.455 13
  -115.313    32.448 14
  -115.321    32.445 15
  -115.336    32.456 16
  -115.341    32.451 17
  -115.316    32.403 18
  -115.245    32.394 19
  -115.344    32.221 20
  -115.263    32.368 21
  -115.372    32.401 22
  -115.514    32.538 23
  -115.263    32.340 24
  -115.719    32.114 25
  -115.287    32.374 26
  -115.286    32.357 27
  -115.344    32.194 28
  -115.645    32.667 29
  -115.831    32.692 30
  -115.130    32.396 31
  -115.208    32.442 32
  -115.213    32.483 33
  -115.190    32.386 34
  -115.294    32.290 35
  -115.293    32.289 36
  -115.259    32.355 37
  -115.302    32.274 38
  -115.298    32.269 39
  -115.240    31.982 40
  -115.202    32.176 41
  -115.291    32.203 42
  -115.381    32.277 43
  -115.566    32.425 44
  -115.031    31.939 45
  -115.376    32.311 46
  -115.429    32.295 47
  -115.234    32.136 48
  -115.232    32.187 49
  -115.751    32.580 50
  -115.630    32.493 51
  -115.784    32.621 52
  -115.285    32.203 53
  -115.558    32.438 54
  -115.087    32.029 55
  -115.784    32.624 56
  -115.348    32.297 57
  -115.803    32.669 58
  -115.771    32.632 59
  -115.270    32.182 60
  -115.212    32.143 61
  -115.108    32.059 62
  -115.337    32.294 63
  -115.756    32.593 64
  -115.788    32.645 65
  -115.308    32.201 66
  -115.080    32.059 67
  -115.731    32.605 68
  -115.046    31.983 69
  -115.894    32.696 70
  -115.106    32.002 71
  -115.302    32.207 72
  -115.283    32.209 73
  -115.761    32.660 74
  -115.758    32.594 75
  -115.285    32.213 76
  -115.381    32.300 77
  -115.322    32.191 78
  -115.372    32.272 79
  -115.263    32.194 80
  -115.762    32.648 81
  -115.333    32.295 82
  -115.761    32.650 83
  -115.246    32.133 84
  -115.085    32.046 85
  -115.085    32.063 86
  -115.075    32.060 87
  -115.199    32.125 88
  -115.350    32.270 89
  -115.143    32.107 90
  -115.844    32.672 91
  -115.623    32.491 92
  -115.790    32.646 93
  -115.795    32.645 94
  -115.328    32.297 95
  -115.832    32.665 96
  -115.454    32.319 97
  -115.306    32.249 98
  -115.062    32.027 99
  -115.883    32.700 100
  -115.864    32.677 101
  -115.793    32.658 102
  -115.805    32.641 103
  -115.814    32.645 104
  -115.860    32.680 105
  -115.275    32.186 106
  -115.272    32.185 107
  -115.824    32.637 108
  -115.855    32.648 109
  -115.947    32.686 110
  -115.750    32.588 111
  -115.762    32.599 112
  -115.752    32.587 113
  -115.826    32.646 114
  -115.310    32.221 115
  -115.207    32.120 116
  -115.907    32.680 117
  -115.098    32.066 118
  -115.331    32.317 119
  -115.207    32.389 120
  -115.325    32.218 121
  -115.912    32.674 122
  -115.943    32.683 123
  -115.948    32.690 124
  -115.900    32.659 125
  -115.949    32.694 126
  -115.786    32.614 127
  -115.343    32.245 128
  -115.360    32.272 129
  -115.086    32.069 130
  -115.178    32.112 131
  -115.261    32.183 132
  -115.336    32.250 133
  -115.121    32.062 134
  -115.292    32.202 135
  -115.995    32.859 136
  -115.753    32.592 137
  -115.279    32.189 138
  -115.825    32.645 139
  -115.330    32.221 140
  -115.926    32.605 141
  -115.301    32.199 142
  -115.095    32.039 143
  -115.241    32.141 144
  -115.190    32.375 145
  -115.235    32.368 146
  -115.722    32.619 147
  -115.215    32.106 148
  -115.221    32.128 149
  -115.732    32.630 150
  -115.147    32.097 151
  -116.343    32.037 152
  -115.210    32.084 153
  -115.281    32.187 154
  -115.260    32.345 155
  -115.191    32.096 156
  -115.303    32.202 157
  -115.200    32.101 158
  -115.306    32.184 159
  -115.283    32.159 160
  -115.730    32.087 161
  -115.233    32.119 162
  -115.729    32.091 163
  -115.293    32.203 164
  -115.707    32.656 165
  -115.746    32.087 166
  -115.740    32.081 167
  -115.325    32.197 168
  -115.298    32.199 169
  -115.313    32.196 170
  -115.296    32.207 171
  -115.249    32.137 172
  -115.245    32.125 173
  -116.142    32.776 174
  -115.224    32.122 175
  -115.281    32.390 176
  -115.317    32.197 177
  -115.242    32.369 178
  -115.256    32.171 179
  -116.267    32.386 180
  -115.270    32.366 181
  -115.225    32.373 182
  -115.218    32.374 183
  -115.244    32.371 184
  -116.136    32.811 185
  -115.086    32.192 186
  -115.226    32.383 187
  -115.275    32.184 188
  -115.552    32.755 189
  -115.243    32.378 190
  -115.412    32.302 191
  -115.838    32.731 192
  -115.275    32.350 193
  -115.329    32.314 194
  -115.222    32.372 195
  -115.228    32.382 196
  -116.044    32.819 197
  -115.556    32.682 198
  -115.553    32.687 199
  -115.877    32.725 200
  -115.494    32.365 201
  -115.587    32.784 202
  -115.576    32.774 203
  -115.578    32.771 204
  -115.261    32.381 205
  -115.253    32.397 206
  -115.266    32.392 207
  -115.268    32.388 208
  -115.239    32.408 209
  -115.214    32.387 210
  -115.192    32.399 211
  -115.396    32.293 212
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -115.267    32.418
  -115.266    32.385
>
  -115.259    32.393
  -115.279    32.372
>
  -115.198    32.364
  -115.219    32.387
>
  -115.225    32.354
  -115.244    32.398
>
  -116.045    32.696
  -116.047    32.684
>
  -115.981    32.830
  -115.965    32.797
>
  -116.062    32.704
  -116.038    32.675
>
  -115.323    32.443
  -115.313    32.451
>
  -115.306    32.443
  -115.312    32.441
>
  -115.305    32.465
  -115.329    32.459
>
  -115.311    32.471
  -115.334    32.445
>
  -115.310    32.457
  -115.327    32.459
>
  -115.339    32.456
  -115.334    32.455
>
  -115.322    32.465
  -115.313    32.448
>
  -115.311    32.466
  -115.321    32.445
>
  -115.330    32.488
  -115.336    32.456
>
  -115.336    32.511
  -115.341    32.451
>
  -115.324    32.457
  -115.316    32.403
>
  -115.236    32.420
  -115.245    32.394
>
  -115.357    32.236
  -115.344    32.221
>
  -115.264    32.364
  -115.263    32.368
>
  -115.367    32.423
  -115.372    32.401
>
  -115.532    32.562
  -115.514    32.538
>
  -115.217    32.375
  -115.263    32.340
>
  -115.714    32.130
  -115.719    32.114
>
  -115.266    32.389
  -115.287    32.374
>
  -115.285    32.400
  -115.286    32.357
>
  -115.354    32.182
  -115.344    32.194
>
  -115.633    32.706
  -115.645    32.667
>
  -115.841    32.703
  -115.831    32.692
>
  -115.117    32.392
  -115.130    32.396
>
  -115.243    32.507
  -115.208    32.442
>
  -115.216    32.450
  -115.213    32.483
>
  -115.172    32.407
  -115.190    32.386
>
  -115.307    32.269
  -115.294    32.290
>
  -115.260    32.291
  -115.293    32.289
>
  -115.270    32.345
  -115.259    32.355
>
  -115.354    32.265
  -115.302    32.274
>
  -115.282    32.273
  -115.298    32.269
>
  -115.162    32.071
  -115.240    31.982
>
  -115.221    32.199
  -115.202    32.176
>
  -115.229    32.213
  -115.291    32.203
>
  -115.345    32.347
  -115.381    32.277
>
  -115.549    32.478
  -115.566    32.425
>
  -115.003    32.003
  -115.031    31.939
>
  -115.349    32.313
  -115.376    32.311
>
  -115.432    32.312
  -115.429    32.295
>
  -115.198    32.177
  -115.234    32.136
>
  -115.221    32.165
  -115.232    32.187
>
  -115.761    32.610
  -115.751    32.580
>
  -115.615    32.484
  -115.630    32.493
>
  -115.790    32.655
  -115.784    32.621
>
  -115.236    32.284
  -115.285    32.203
>
  -115.547    32.446
  -115.558    32.438
>
  -115.075    32.063
  -115.087    32.029
>
  -115.778    32.639
  -115.784    32.624
>
  -115.389    32.207
  -115.348    32.297
>
  -115.807    32.699
  -115.803    32.669
>
  -115.786    32.674
  -115.771    32.632
>
  -115.243    32.175
  -115.270    32.182
>
  -115.179    32.139
  -115.212    32.143
>
  -115.052    32.069
  -115.108    32.059
>
  -115.355    32.287
  -115.337    32.294
>
  -115.707    32.603
  -115.756    32.593
>
  -115.789    32.665
  -115.788    32.645
>
  -115.274    32.203
  -115.308    32.201
>
  -115.050    32.090
  -115.080    32.059
>
  -115.719    32.608
  -115.731    32.605
>
  -115.137    32.058
  -115.046    31.983
>
  -115.894    32.714
  -115.894    32.696
>
  -115.062    32.021
  -115.106    32.002
>
  -115.297    32.202
  -115.302    32.207
>
  -115.273    32.209
  -115.283    32.209
>
  -115.767    32.680
  -115.761    32.660
>
  -115.748    32.610
  -115.758    32.594
>
  -115.289    32.231
  -115.285    32.213
>
  -115.358    32.325
  -115.381    32.300
>
  -115.288    32.196
  -115.322    32.191
>
  -115.374    32.306
  -115.372    32.272
>
  -115.247    32.214
  -115.263    32.194
>
  -115.738    32.656
  -115.762    32.648
>
  -115.325    32.263
  -115.333    32.295
>
  -115.746    32.656
  -115.761    32.650
>
  -115.199    32.154
  -115.246    32.133
>
  -115.061    32.065
  -115.085    32.046
>
  -115.041    32.052
  -115.085    32.063
>
  -115.020    32.067
  -115.075    32.060
>
  -115.197    32.125
  -115.199    32.125
>
  -115.354    32.273
  -115.350    32.270
>
  -115.141    32.158
  -115.143    32.107
>
  -115.849    32.685
  -115.844    32.672
>
  -115.590    32.509
  -115.623    32.491
>
  -115.792    32.664
  -115.790    32.646
>
  -115.789    32.673
  -115.795    32.645
>
  -115.356    32.283
  -115.328    32.297
>
  -115.833    32.695
  -115.832    32.665
>
  -115.464    32.275
  -115.454    32.319
>
  -115.297    32.248
  -115.306    32.249
>
  -115.064    32.012
  -115.062    32.027
>
  -115.885    32.703
  -115.883    32.700
>
  -115.841    32.691
  -115.864    32.677
>
  -115.779    32.693
  -115.793    32.658
>
  -115.799    32.646
  -115.805    32.641
>
  -115.815    32.655
  -115.814    32.645
>
  -115.872    32.677
  -115.860    32.680
>
  -115.272    32.176
  -115.275    32.186
>
  -115.252    32.175
  -115.272    32.185
>
  -115.850    32.674
  -115.824    32.637
>
  -115.871    32.653
  -115.855    32.648
>
  -115.938    32.709
  -115.947    32.686
>
  -115.762    32.609
  -115.750    32.588
>
  -115.759    32.587
  -115.762    32.599
>
  -115.742    32.608
  -115.752    32.587
>
  -115.819    32.661
  -115.826    32.646
>
  -115.323    32.229
  -115.310    32.221
>
  -115.174    32.133
  -115.207    32.120
>
  -115.894    32.700
  -115.907    32.680
>
  -115.097    32.051
  -115.098    32.066
>
  -115.328    32.314
  -115.331    32.317
>
  -115.215    32.410
  -115.207    32.389
>
  -115.299    32.199
  -115.325    32.218
>
  -115.937    32.695
  -115.912    32.674
>
  -115.983    32.713
  -115.943    32.683
>
  -115.951    32.712
  -115.948    32.690
>
  -115.864    32.637
  -115.900    32.659
>
  -115.947    32.727
  -115.949    32.694
>
  -115.787    32.615
  -115.786    32.614
>
  -115.351    32.239
  -115.343    32.245
>
  -115.342    32.279
  -115.360    32.272
>
  -115.065    32.078
  -115.086    32.069
>
  -115.214    32.134
  -115.178    32.112
>
  -115.254    32.195
  -115.261    32.183
>
  -115.305    32.272
  -115.336    32.250
>
  -115.110    32.014
  -115.121    32.062
>
  -115.275    32.193
  -115.292    32.202
>
  -115.990    32.864
  -115.995    32.859
>
  -115.743    32.608
  -115.753    32.592
>
  -115.313    32.185
  -115.279    32.189
>
  -115.838    32.649
  -115.825    32.645
>
  -115.322    32.248
  -115.330    32.221
>
  -115.938    32.616
  -115.926    32.605
>
  -115.312    32.193
  -115.301    32.199
>
  -115.097    32.054
  -115.095    32.039
>
  -115.254    32.137
  -115.241    32.141
>
  -115.181    32.387
  -115.190    32.375
>
  -115.233    32.385
  -115.235    32.368
>
  -115.733    32.622
  -115.722    32.619
>
  -115.221    32.157
  -115.215    32.106
>
  -115.201    32.141
  -115.221    32.128
>
  -115.749    32.671
  -115.732    32.630
>
  -115.122    32.104
  -115.147    32.097
>
  -116.327    32.019
  -116.343    32.037
>
  -115.151    32.111
  -115.210    32.084
>
  -115.298    32.182
  -115.281    32.187
>
  -115.277    32.359
  -115.260    32.345
>
  -115.183    32.131
  -115.191    32.096
>
  -115.274    32.205
  -115.303    32.202
>
  -115.177    32.117
  -115.200    32.101
>
  -115.319    32.186
  -115.306    32.184
>
  -115.241    32.159
  -115.283    32.159
>
  -115.745    32.120
  -115.730    32.087
>
  -115.222    32.135
  -115.233    32.119
>
  -115.696    32.113
  -115.729    32.091
>
  -115.314    32.201
  -115.293    32.203
>
  -115.705    32.689
  -115.707    32.656
>
  -115.723    32.107
  -115.746    32.087
>
  -115.710    32.116
  -115.740    32.081
>
  -115.345    32.217
  -115.325    32.197
>
  -115.320    32.199
  -115.298    32.199
>
  -115.310    32.197
  -115.313    32.196
>
  -115.276    32.193
  -115.296    32.207
>
  -115.226    32.168
  -115.249    32.137
>
  -115.310    32.138
  -115.245    32.125
>
  -116.150    32.812
  -116.142    32.776
>
  -115.216    32.111
  -115.224    32.122
>
  -115.295    32.408
  -115.281    32.390
>
  -115.280    32.181
  -115.317    32.197
>
  -115.283    32.381
  -115.242    32.369
>
  -115.227    32.139
  -115.256    32.171
>
  -116.244    32.417
  -116.267    32.386
>
  -115.258    32.377
  -115.270    32.366
>
  -115.200    32.378
  -115.225    32.373
>
  -115.207    32.395
  -115.218    32.374
>
  -115.268    32.390
  -115.244    32.371
>
  -116.125    32.825
  -116.136    32.811
>
  -115.059    32.204
  -115.086    32.192
>
  -115.227    32.388
  -115.226    32.383
>
  -115.289    32.179
  -115.275    32.184
>
  -115.557    32.761
  -115.552    32.755
>
  -115.229    32.389
  -115.243    32.378
>
  -115.422    32.315
  -115.412    32.302
>
  -115.827    32.763
  -115.838    32.731
>
  -115.268    32.375
  -115.275    32.350
>
  -115.325    32.332
  -115.329    32.314
>
  -115.222    32.383
  -115.222    32.372
>
  -115.227    32.399
  -115.228    32.382
>
  -116.044    32.848
  -116.044    32.819
>
  -115.546    32.725
  -115.556    32.682
>
  -115.564    32.718
  -115.553    32.687
>
  -115.870    32.756
  -115.877    32.725
>
  -115.493    32.385
  -115.494    32.365
>
  -116.059    32.109
  -115.587    32.784
>
  -115.569    32.807
  -115.576    32.774
>
  -115.554    32.811
  -115.578    32.771
>
  -115.258    32.399
  -115.261    32.381
>
  -115.274    32.442
  -115.253    32.397
>
  -115.272    32.447
  -115.266    32.392
>
  -115.254    32.300
  -115.268    32.388
>
  -115.246    32.431
  -115.239    32.408
>
  -115.193    32.417
  -115.214    32.387
>
  -115.164    32.403
  -115.192    32.399
>
  -115.385    32.254
  -115.396    32.293
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -115.265    32.385
  -115.266    32.385
>
  -115.279    32.373
  -115.279    32.372
>
  -115.219    32.387
  -115.219    32.387
>
  -115.244    32.398
  -115.244    32.398
>
  -116.047    32.684
  -116.047    32.684
>
  -115.967    32.800
  -115.965    32.797
>
  -116.038    32.675
  -116.038    32.675
>
  -115.314    32.451
  -115.313    32.451
>
  -115.312    32.441
  -115.312    32.441
>
  -115.329    32.459
  -115.329    32.459
>
  -115.334    32.445
  -115.334    32.445
>
  -115.327    32.459
  -115.327    32.459
>
  -115.334    32.456
  -115.334    32.455
>
  -115.314    32.448
  -115.313    32.448
>
  -115.320    32.445
  -115.321    32.445
>
  -115.336    32.456
  -115.336    32.456
>
  -115.341    32.451
  -115.341    32.451
>
  -115.316    32.403
  -115.316    32.403
>
  -115.245    32.393
  -115.245    32.394
>
  -115.344    32.222
  -115.344    32.221
>
  -115.263    32.368
  -115.263    32.368
>
  -115.372    32.401
  -115.372    32.401
>
  -115.514    32.538
  -115.514    32.538
>
  -115.263    32.340
  -115.263    32.340
>
  -115.719    32.114
  -115.719    32.114
>
  -115.287    32.374
  -115.287    32.374
>
  -115.286    32.357
  -115.286    32.357
>
  -115.344    32.194
  -115.344    32.194
>
  -115.645    32.667
  -115.645    32.667
>
  -115.831    32.692
  -115.831    32.692
>
  -115.130    32.396
  -115.130    32.396
>
  -115.209    32.441
  -115.208    32.442
>
  -115.213    32.482
  -115.213    32.483
>
  -115.191    32.386
  -115.190    32.386
>
  -115.294    32.290
  -115.294    32.290
>
  -115.293    32.289
  -115.293    32.289
>
  -115.260    32.355
  -115.259    32.355
>
  -115.302    32.274
  -115.302    32.274
>
  -115.298    32.269
  -115.298    32.269
>
  -115.240    31.982
  -115.240    31.982
>
  -115.202    32.177
  -115.202    32.176
>
  -115.291    32.202
  -115.291    32.203
>
  -115.381    32.277
  -115.381    32.277
>
  -115.565    32.427
  -115.566    32.425
>
  -115.027    31.945
  -115.031    31.939
>
  -115.376    32.311
  -115.376    32.311
>
  -115.429    32.295
  -115.429    32.295
>
  -115.234    32.136
  -115.234    32.136
>
  -115.232    32.187
  -115.232    32.187
>
  -115.751    32.580
  -115.751    32.580
>
  -115.630    32.493
  -115.630    32.493
>
  -115.784    32.622
  -115.784    32.621
>
  -115.285    32.203
  -115.285    32.203
>
  -115.558    32.423
  -115.558    32.438
>
  -115.087    32.029
  -115.087    32.029
>
  -115.784    32.624
  -115.784    32.624
>
  -115.348    32.297
  -115.348    32.297
>
  -115.803    32.669
  -115.803    32.669
>
  -115.771    32.633
  -115.771    32.632
>
  -115.271    32.182
  -115.270    32.182
>
  -115.212    32.143
  -115.212    32.143
>
  -115.108    32.059
  -115.108    32.059
>
  -115.337    32.294
  -115.337    32.294
>
  -115.756    32.593
  -115.756    32.593
>
  -115.788    32.645
  -115.788    32.645
>
  -115.307    32.202
  -115.308    32.201
>
  -115.080    32.059
  -115.080    32.059
>
  -115.731    32.605
  -115.731    32.605
>
  -115.046    31.982
  -115.046    31.983
>
  -115.894    32.695
  -115.894    32.696
>
  -115.106    32.002
  -115.106    32.002
>
  -115.302    32.208
  -115.302    32.207
>
  -115.283    32.209
  -115.283    32.209
>
  -115.761    32.660
  -115.761    32.660
>
  -115.758    32.594
  -115.758    32.594
>
  -115.285    32.213
  -115.285    32.213
>
  -115.381    32.300
  -115.381    32.300
>
  -115.322    32.190
  -115.322    32.191
>
  -115.373    32.272
  -115.372    32.272
>
  -115.263    32.194
  -115.263    32.194
>
  -115.762    32.648
  -115.762    32.648
>
  -115.333    32.295
  -115.333    32.295
>
  -115.761    32.650
  -115.761    32.650
>
  -115.246    32.133
  -115.246    32.133
>
  -115.085    32.046
  -115.085    32.046
>
  -115.085    32.063
  -115.085    32.063
>
  -115.077    32.063
  -115.075    32.060
>
  -115.199    32.126
  -115.199    32.125
>
  -115.350    32.270
  -115.350    32.270
>
  -115.144    32.111
  -115.143    32.107
>
  -115.844    32.672
  -115.844    32.672
>
  -115.623    32.491
  -115.623    32.491
>
  -115.790    32.645
  -115.790    32.646
>
  -115.795    32.645
  -115.795    32.645
>
  -115.328    32.298
  -115.328    32.297
>
  -115.832    32.666
  -115.832    32.665
>
  -115.454    32.319
  -115.454    32.319
>
  -115.306    32.249
  -115.306    32.249
>
  -115.062    32.027
  -115.062    32.027
>
  -115.882    32.699
  -115.883    32.700
>
  -115.864    32.677
  -115.864    32.677
>
  -115.793    32.659
  -115.793    32.658
>
  -115.805    32.641
  -115.805    32.641
>
  -115.814    32.646
  -115.814    32.645
>
  -115.860    32.680
  -115.860    32.680
>
  -115.274    32.185
  -115.275    32.186
>
  -115.272    32.185
  -115.272    32.185
>
  -115.824    32.637
  -115.824    32.637
>
  -115.855    32.648
  -115.855    32.648
>
  -115.947    32.686
  -115.947    32.686
>
  -115.750    32.588
  -115.750    32.588
>
  -115.762    32.599
  -115.762    32.599
>
  -115.752    32.587
  -115.752    32.587
>
  -115.826    32.646
  -115.826    32.646
>
  -115.310    32.221
  -115.310    32.221
>
  -115.207    32.120
  -115.207    32.120
>
  -115.907    32.680
  -115.907    32.680
>
  -115.098    32.066
  -115.098    32.066
>
  -115.332    32.318
  -115.331    32.317
>
  -115.207    32.389
  -115.207    32.389
>
  -115.325    32.218
  -115.325    32.218
>
  -115.912    32.674
  -115.912    32.674
>
  -115.943    32.683
  -115.943    32.683
>
  -115.948    32.690
  -115.948    32.690
>
  -115.900    32.660
  -115.900    32.659
>
  -115.948    32.695
  -115.949    32.694
>
  -115.786    32.613
  -115.786    32.614
>
  -115.344    32.245
  -115.343    32.245
>
  -115.360    32.272
  -115.360    32.272
>
  -115.087    32.068
  -115.086    32.069
>
  -115.178    32.114
  -115.178    32.112
>
  -115.261    32.183
  -115.261    32.183
>
  -115.337    32.250
  -115.336    32.250
>
  -115.121    32.062
  -115.121    32.062
>
  -115.291    32.202
  -115.292    32.202
>
  -115.995    32.859
  -115.995    32.859
>
  -115.753    32.592
  -115.753    32.592
>
  -115.279    32.190
  -115.279    32.189
>
  -115.824    32.644
  -115.825    32.645
>
  -115.330    32.221
  -115.330    32.221
>
  -115.926    32.605
  -115.926    32.605
>
  -115.301    32.199
  -115.301    32.199
>
  -115.095    32.038
  -115.095    32.039
>
  -115.241    32.141
  -115.241    32.141
>
  -115.191    32.375
  -115.190    32.375
>
  -115.236    32.371
  -115.235    32.368
>
  -115.722    32.619
  -115.722    32.619
>
  -115.215    32.107
  -115.215    32.106
>
  -115.221    32.128
  -115.221    32.128
>
  -115.732    32.631
  -115.732    32.630
>
  -115.147    32.097
  -115.147    32.097
>
  -116.343    32.037
  -116.343    32.037
>
  -115.210    32.084
  -115.210    32.084
>
  -115.281    32.186
  -115.281    32.187
>
  -115.260    32.345
  -115.260    32.345
>
  -115.190    32.098
  -115.191    32.096
>
  -115.304    32.202
  -115.303    32.202
>
  -115.200    32.102
  -115.200    32.101
>
  -115.306    32.184
  -115.306    32.184
>
  -115.286    32.160
  -115.283    32.159
>
  -115.731    32.087
  -115.730    32.087
>
  -115.233    32.119
  -115.233    32.119
>
  -115.729    32.091
  -115.729    32.091
>
  -115.294    32.203
  -115.293    32.203
>
  -115.707    32.656
  -115.707    32.656
>
  -115.746    32.087
  -115.746    32.087
>
  -115.739    32.082
  -115.740    32.081
>
  -115.325    32.198
  -115.325    32.197
>
  -115.297    32.199
  -115.298    32.199
>
  -115.313    32.197
  -115.313    32.196
>
  -115.296    32.208
  -115.296    32.207
>
  -115.249    32.137
  -115.249    32.137
>
  -115.245    32.123
  -115.245    32.125
>
  -116.141    32.776
  -116.142    32.776
>
  -115.224    32.122
  -115.224    32.122
>
  -115.281    32.390
  -115.281    32.390
>
  -115.317    32.197
  -115.317    32.197
>
  -115.241    32.369
  -115.242    32.369
>
  -115.257    32.170
  -115.256    32.171
>
  -116.267    32.387
  -116.267    32.386
>
  -115.270    32.366
  -115.270    32.366
>
  -115.225    32.373
  -115.225    32.373
>
  -115.218    32.374
  -115.218    32.374
>
  -115.243    32.371
  -115.244    32.371
>
  -116.135    32.812
  -116.136    32.811
>
  -115.086    32.192
  -115.086    32.192
>
  -115.226    32.383
  -115.226    32.383
>
  -115.276    32.184
  -115.275    32.184
>
  -115.552    32.755
  -115.552    32.755
>
  -115.243    32.378
  -115.243    32.378
>
  -115.412    32.301
  -115.412    32.302
>
  -115.837    32.731
  -115.838    32.731
>
  -115.275    32.350
  -115.275    32.350
>
  -115.328    32.314
  -115.329    32.314
>
  -115.222    32.372
  -115.222    32.372
>
  -115.228    32.382
  -115.228    32.382
>
  -116.044    32.819
  -116.044    32.819
>
  -115.556    32.682
  -115.556    32.682
>
  -115.554    32.688
  -115.553    32.687
>
  -115.877    32.725
  -115.877    32.725
>
  -115.494    32.364
  -115.494    32.365
>
  -115.586    32.784
  -115.587    32.784
>
  -115.576    32.774
  -115.576    32.774
>
  -115.577    32.770
  -115.578    32.771
>
  -115.261    32.381
  -115.261    32.381
>
  -115.255    32.398
  -115.253    32.397
>
  -115.267    32.391
  -115.266    32.392
>
  -115.268    32.388
  -115.268    32.388
>
  -115.239    32.408
  -115.239    32.408
>
  -115.215    32.386
  -115.214    32.387
>
  -115.192    32.399
  -115.192    32.399
>
  -115.396    32.292
  -115.396    32.293
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -115.266    32.385    84.971     1.194     1.820
  -115.279    32.372    53.517     2.328     3.224
  -115.219    32.387    61.593     1.578     2.364
  -115.244    32.398    65.739     1.401     2.476
  -116.047    32.684    85.278     0.915     1.149
  -115.965    32.797    47.700     1.107     1.295
  -116.038    32.675    74.754     1.125     1.245
  -115.313    32.451   -84.048     0.677     1.129
  -115.312    32.441   -85.436     0.701     1.163
  -115.329    32.459   -86.143     0.929     1.432
  -115.334    32.445   -86.597     0.881     1.473
  -115.327    32.459    82.895     0.925     1.488
  -115.334    32.455    86.070     0.856     1.367
  -115.313    32.448    84.320     0.832     1.370
  -115.321    32.445    80.163     1.000     1.642
  -115.336    32.456   -83.906     0.779     1.332
  -115.341    32.451   -79.031     0.780     1.470
  -115.316    32.403   -85.454     0.823     1.786
  -115.245    32.394   -84.416     1.171     2.282
  -115.344    32.221    68.478     1.716     2.429
  -115.263    32.368    89.983     0.807     1.378
  -115.372    32.401   -75.703     0.669     1.266
  -115.514    32.538    74.963     1.848     2.585
  -115.263    32.340   -88.668     1.206     1.931
  -115.719    32.114    63.942     1.897     2.255
  -115.287    32.374   -75.536     0.662     1.392
  -115.286    32.357   -77.187     0.681     1.459
  -115.344    32.194    58.046     1.253     1.682
  -115.645    32.667   -82.468     0.808     1.490
  -115.831    32.692   -85.358     0.825     1.245
  -115.130    32.396    77.837     1.317     2.253
  -115.208    32.442   -78.760     0.667     1.126
  -115.213    32.483    70.161     1.603     2.624
  -115.190    32.386    88.916     1.450     2.082
  -115.294    32.290    85.180     1.309     1.649
  -115.293    32.289    69.917     1.377     1.789
  -115.259    32.355   -83.161     2.120     2.741
  -115.302    32.274   -77.718     1.463     2.517
  -115.298    32.269   -65.847     0.773     1.334
  -115.240    31.982    22.233     0.055     2.021
  -115.202    32.176   -74.951     1.637     2.203
  -115.291    32.203   -74.051     0.966     1.590
  -115.381    32.277   -69.185     1.484     2.105
  -115.566    32.425   -81.243     1.438     2.962
  -115.031    31.939   -60.850     1.363     2.380
  -115.376    32.311   -73.666     1.136     2.169
  -115.429    32.295   -79.218     1.845     3.682
  -115.234    32.136   -66.058     1.107     1.680
  -115.232    32.187   -77.192     1.661     2.741
  -115.751    32.580   -88.456     1.304     1.909
  -115.630    32.493   -72.090     1.105     1.591
  -115.784    32.621   -78.364     1.344     1.800
  -115.285    32.203    88.101     1.359     2.500
  -115.558    32.438   -82.720     2.114     3.663
  -115.087    32.029   -71.814     1.741     3.283
  -115.784    32.624   -86.483     1.111     1.640
  -115.348    32.297   -72.381     1.222     2.012
  -115.803    32.669   -86.930     1.249     1.853
  -115.771    32.632   -86.433     1.011     1.555
  -115.270    32.182    83.826     1.039     1.428
  -115.212    32.143    76.009     1.514     1.883
  -115.108    32.059   -89.474     1.202     1.752
  -115.337    32.294    74.646     1.268     1.582
  -115.756    32.593    65.010     1.218     1.414
  -115.788    32.645    42.389     0.990     1.198
  -115.308    32.201    85.550     1.247     1.654
  -115.080    32.059    89.005     1.550     2.149
  -115.731    32.605    73.028     1.122     1.359
  -115.046    31.983    68.794     2.548     3.510
  -115.894    32.696    85.412     1.157     1.588
  -115.106    32.002    82.619     1.261     1.624
  -115.302    32.207    42.046     1.585     2.322
  -115.283    32.209   -84.344     1.197     1.554
  -115.761    32.660    62.466     1.062     1.169
  -115.758    32.594    53.804     0.973     1.092
  -115.285    32.213   -74.501     0.706     1.169
  -115.381    32.300    70.108     1.093     1.381
  -115.322    32.191   -85.091     1.053     1.383
  -115.372    32.272    67.461     1.037     1.235
  -115.263    32.194    85.964     0.963     1.389
  -115.762    32.648    87.285     0.859     1.049
  -115.333    32.295    85.366     1.143     1.457
  -115.761    32.650    74.268     1.059     1.218
  -115.246    32.133   -77.994     1.543     2.264
  -115.085    32.046    69.893     1.260     1.622
  -115.085    32.063    77.220     1.278     1.666
  -115.075    32.060    79.660     1.935     2.358
  -115.199    32.125    42.074     1.651     1.990
  -115.350    32.270    80.884     1.050     1.402
  -115.143    32.107    62.515     1.753     2.450
  -115.844    32.672    72.300     0.905     1.007
  -115.623    32.491   -84.989     1.026     1.213
  -115.790    32.646    66.484     0.757     0.859
  -115.795    32.645    67.389     0.787     0.968
  -115.328    32.297    83.413     1.846     2.282
  -115.832    32.665    79.895     0.812     1.095
  -115.454    32.319    88.730     1.451     1.845
  -115.306    32.249   -88.986     0.869     1.254
  -115.062    32.027    62.211     1.561     2.159
  -115.883    32.700    57.430     1.108     1.718
  -115.864    32.677    84.417     0.884     1.147
  -115.793    32.658    89.229     0.716     1.028
  -115.805    32.641    77.408     0.868     1.136
  -115.814    32.645    83.831     0.899     1.093
  -115.860    32.680    68.975     0.945     1.585
  -115.275    32.186    78.274     1.146     1.591
  -115.272    32.185    87.580     0.888     1.308
  -115.824    32.637    86.916     0.730     1.166
  -115.855    32.648    69.655     0.866     1.202
  -115.947    32.686    77.174     1.014     1.292
  -115.750    32.588    87.099     0.861     1.201
  -115.762    32.599    68.872     1.204     1.525
  -115.752    32.587    75.767     1.156     1.533
  -115.826    32.646    81.783     0.758     1.177
  -115.310    32.221    86.995     1.109     1.460
  -115.207    32.120   -87.895     1.067     1.412
  -115.907    32.680    63.550     0.981     1.327
  -115.098    32.066   -75.493     1.486     1.961
  -115.331    32.317    79.942     1.139     1.574
  -115.207    32.389    76.438     1.259     1.895
  -115.325    32.218   -87.253     1.190     1.651
  -115.912    32.674   -85.059     0.653     0.888
  -115.943    32.683    76.046     0.896     1.199
  -115.948    32.690    69.435     0.735     1.069
  -115.900    32.659    72.732     0.833     1.110
  -115.949    32.694    79.988     1.034     1.431
  -115.786    32.614    67.405     0.853     1.190
  -115.343    32.245    75.625     1.165     1.392
  -115.360    32.272    80.725     1.147     1.509
  -115.086    32.069    86.369     1.778     2.290
  -115.178    32.112   -76.692     0.730     1.251
  -115.261    32.183   -75.409     1.575     2.169
  -115.336    32.250   -80.373     1.327     2.200
  -115.121    32.062   -78.011     1.506     2.087
  -115.292    32.202   -74.873     1.106     1.743
  -115.995    32.859    63.116     0.787     0.873
  -115.753    32.592    86.104     0.909     1.381
  -115.279    32.189   -76.575     1.218     1.758
  -115.825    32.645    89.362     1.000     1.475
  -115.330    32.221   -81.717     1.393     1.863
  -115.926    32.605    85.856     0.786     1.034
  -115.301    32.199   -81.622     1.102     2.251
  -115.095    32.039   -73.706     0.866     1.666
  -115.241    32.141   -80.346     1.009     1.517
  -115.190    32.375    77.321     1.284     1.591
  -115.235    32.368    76.562     1.211     1.692
  -115.722    32.619    81.187     0.904     1.430
  -115.215    32.106    75.202     1.198     1.727
  -115.221    32.128    86.485     1.086     1.474
  -115.732    32.630    84.083     0.836     1.200
  -115.147    32.097   -84.594     1.159     1.968
  -116.343    32.037    51.705     1.837     1.989
  -115.210    32.084   -84.284     1.465     1.813
  -115.281    32.187   -85.084     1.181     1.808
  -115.260    32.345    82.841     1.478     2.101
  -115.191    32.096   -75.885     0.739     1.257
  -115.303    32.202    83.491     1.017     1.480
  -115.200    32.101    86.694     1.294     2.037
  -115.306    32.184   -83.396     1.383     1.826
  -115.283    32.159   -80.881     1.426     1.821
  -115.730    32.087   -66.079     1.568     1.763
  -115.233    32.119   -73.816     1.154     1.540
  -115.729    32.091   -59.521     1.400     1.654
  -115.293    32.203   -85.772     1.224     1.742
  -115.707    32.656    80.252     0.997     1.602
  -115.746    32.087   -60.122     1.488     1.997
  -115.740    32.081   -69.385     1.220     1.427
  -115.325    32.197   -77.528     0.742     1.309
  -115.298    32.199   -84.372     1.335     1.830
  -115.313    32.196   -73.830     0.789     1.353
  -115.296    32.207   -85.642     1.329     1.698
  -115.249    32.137   -80.459     1.653     2.524
  -115.245    32.125   -80.066     1.591     2.629
  -116.142    32.776   -84.155     0.772     1.111
  -115.224    32.122   -67.666     1.045     1.717
  -115.281    32.390    85.244     1.255     1.908
  -115.317    32.197   -75.895     1.105     1.946
  -115.242    32.369    88.452     1.538     2.982
  -115.256    32.171   -82.023     1.594     3.612
  -116.267    32.386   -53.242     0.763     1.218
  -115.270    32.366   -84.694     1.091     1.487
  -115.225    32.373    85.644     1.198     1.429
  -115.218    32.374    85.459     1.186     1.688
  -115.244    32.371    87.944     0.952     1.350
  -116.136    32.811   -74.044     0.568     0.776
  -115.086    32.192   -82.128     0.919     1.197
  -115.226    32.383   -68.179     0.929     1.307
  -115.275    32.184   -61.728     0.944     1.366
  -115.552    32.755    89.094     0.786     1.084
  -115.243    32.378   -61.422     0.836     1.171
  -115.412    32.302   -70.317     0.705     1.038
  -115.838    32.731   -87.975     0.447     0.633
  -115.275    32.350   -62.656     0.910     1.178
  -115.329    32.314   -73.723     0.631     1.025
  -115.222    32.372   -83.453     0.722     1.077
  -115.228    32.382   -64.069     0.710     0.979
  -116.044    32.819    83.821     0.572     0.784
  -115.556    32.682   -78.485     0.516     0.706
  -115.553    32.687   -82.798     0.651     0.918
  -115.877    32.725   -83.658     0.459     0.649
  -115.494    32.365   -60.189     0.667     0.963
  -115.587    32.784   -79.645     0.604     0.734
  -115.576    32.774   -78.444     0.606     0.724
  -115.578    32.771   -79.673     0.488     0.585
  -115.261    32.381   -73.806     0.619     0.838
  -115.253    32.397   -68.610     0.578     0.808
  -115.266    32.392   -61.441     0.802     1.101
  -115.268    32.388   -69.791     0.721     1.032
  -115.239    32.408   -69.660     0.659     0.875
  -115.214    32.387   -66.614     0.736     0.980
  -115.192    32.399   -57.897     0.948     1.531
  -115.396    32.293   -60.559     0.748     1.228
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -115.298    32.269     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -116.379    31.893   -61.878     0.761     0.918
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -116.357    31.893   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -116.379    31.893     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -116.379    31.893     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -116.379    31.848   5 km
EOF
gmt end
