#!/bin/bash
gmt begin chara1.31_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases chara1.31'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.500     1.620
     2.000    -2.230
     2.500    -6.080
     3.000    -9.930
     3.500   -13.780
     4.000   -17.633
     4.500   -21.487
     5.000   -25.343
     5.500   -29.199
     6.000   -33.058
     6.500   -36.920
     7.000   -40.784
     7.500   -44.651
     8.000   -48.521
     8.500   -52.394
     9.000   -56.271
     9.500   -60.151
    10.000   -64.034
    10.500   -67.922
    11.000   -71.815
    11.500   -75.712
    12.000   -79.613
    12.500   -83.521
    13.000   -87.433
    13.500   -91.350
    14.000   -95.274
    14.500   -99.203
    15.000  -103.138
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -84.433 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.398
     1.000     0.510
     1.500    -0.358
     2.000    -1.814
     2.500    -3.269
     3.000    -4.726
     3.500    -6.184
     4.000    -7.644
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -10.644 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.692    -2.617     0.200
     5.017     0.083     0.200
     2.550    -2.271     0.200
     4.742    -2.444     0.200
     2.566    -1.619     0.200
     2.659     0.124     0.200
     3.781    -2.232     0.200
     4.722    -2.658     0.200
     5.061    -2.601     0.200
     5.119     2.663     0.200
     5.948    -5.335     0.200
     3.133    -0.532     0.200
     3.459    -1.984     0.200
     4.401    -1.316     0.200
     4.534    -3.034     0.200
     4.818     0.952     0.200
     4.870    -2.701     0.200
     5.635    -3.953     0.200
     7.293    -2.015     0.200
     7.594    -4.054     0.200
     2.574    -0.624     0.200
     2.613    -0.680     0.200
     2.692     0.241     0.200
     2.820     0.770     0.200
     2.879    -0.406     0.200
     3.160    -1.203     0.200
     3.616    -2.472     0.200
     3.945    -1.892     0.200
     4.886    -1.711     0.200
     5.279     3.512     0.200
     5.461    -1.946     0.200
     6.112    -1.097     0.200
     7.579    -2.489     0.200
     7.792    -3.438     0.200
     8.048    -4.248     0.200
     9.140    -3.574     0.200
     9.776    -4.419     0.200
    10.276    -7.583     0.200
    11.367    -5.772     0.200
     2.559    -0.043     0.200
     2.701    -2.149     0.200
     2.683    -0.393     0.200
     2.814     0.070     0.200
     2.869     0.227     0.200
     3.131    -1.288     0.200
     3.607    -0.579     0.200
     3.933    -1.918     0.200
     4.874    -2.957     0.200
     5.007    -2.859     0.200
     5.432    -1.620     0.200
     6.090    -3.676     0.200
     7.533    -2.024     0.200
     7.765    -3.598     0.200
     2.600    -0.247     0.200
     3.028    -1.333     0.200
     3.971    -1.619     0.200
     4.512    -2.257     0.200
     4.547    -2.470     0.200
     6.945    -2.382     0.200
     2.748    -1.210     0.200
     3.325    -1.889     0.200
     3.558    -0.886     0.200
     4.500    -2.759     0.200
     4.631    -2.890     0.200
     4.834    -1.324     0.200
     5.049    -2.357     0.200
     5.695    -0.646     0.200
     6.222    -3.650     0.200
    26.376    23.481     0.200
     2.676     0.328     0.200
     3.113    -1.826     0.200
     3.282    -0.997     0.200
     4.169    -2.309     0.200
     4.557    -1.912     0.200
     5.473    -2.944     0.200
     5.612    -2.041     0.200
     6.070    -6.184     0.200
     6.588    -3.703     0.200
     6.588    -1.583     0.200
     7.723    -4.666     0.200
     8.045    -2.577     0.200
     8.054    -3.258     0.200
     9.038    -6.946     0.200
     2.708     0.322     0.200
     3.522    -2.967     0.200
     3.862    -3.269     0.200
     3.862    -3.066     0.200
     4.246    -2.235     0.200
     4.798    -2.425     0.200
     4.798     0.075     0.200
     5.313    -1.750     0.200
     5.474    -0.852     0.200
     6.675    -2.938     0.200
     7.087    -6.702     0.200
     9.768    -3.467     0.200
    10.252    -6.822     0.200
    10.706    -8.099     0.200
    11.134    -7.557     0.200
    11.312    -6.904     0.200
    13.438    -4.417     0.200
    14.183    -6.039     0.200
    14.624    -7.895     0.200
    15.269    -5.347     0.200
    15.401    -5.236     0.200
    16.365    -5.594     0.200
     2.675    -1.283     0.200
     3.831    -1.422     0.200
     4.214    -1.248     0.200
     4.767    -1.993     0.200
     5.285    -2.927     0.200
     5.441    -1.364     0.200
     7.701    -4.396     0.200
     2.573     0.405     0.200
     2.684    -0.606     0.200
     3.839    -0.531     0.200
     4.222    -3.164     0.200
     4.775    -2.193     0.200
     5.292    -1.597     0.200
     5.449    -1.280     0.200
     2.574     0.132     0.200
     2.684    -0.657     0.200
     3.840    -1.301     0.200
     4.222    -1.420     0.200
     4.776    -1.966     0.200
     5.291    -1.413     0.200
     5.449    -1.027     0.200
     2.721    -1.765     0.200
     3.873    -1.579     0.200
     4.259    -1.818     0.200
     4.808    -2.725     0.200
     5.328    -2.005     0.200
     5.487    -1.763     0.200
     2.572    -0.478     0.200
     2.681    -1.716     0.200
     3.838    -1.607     0.200
     4.219    -1.187     0.200
     4.774    -1.976     0.200
     5.286    -2.599     0.200
     5.446    -1.667     0.200
     6.648    -4.481     0.200
     7.701    -3.957     0.200
     7.758    -5.964     0.200
     8.036    -4.564     0.200
     9.098    -5.251     0.200
     2.513    -0.942     0.200
     2.590    -0.295     0.200
     2.708    -1.851     0.200
     3.516    -2.037     0.200
     3.857    -1.169     0.200
     4.246    -1.490     0.200
     4.792    -2.907     0.200
     5.325    -1.000     0.200
     2.578    -0.031     0.200
     2.690    -1.272     0.200
     3.504    -1.879     0.200
     3.844    -0.774     0.200
     4.228    -1.732     0.200
     4.780    -2.533     0.200
     5.298    -2.673     0.200
     5.456    -1.253     0.200
     2.568     0.460     0.200
     2.679    -0.957     0.200
     3.835    -1.281     0.200
     4.217    -1.819     0.200
     4.770    -2.647     0.200
     5.290    -2.108     0.200
     5.445    -3.043     0.200
     6.646    -4.022     0.200
     2.591    -0.122     0.200
     2.700    -0.478     0.200
     3.517    -2.072     0.200
     3.857    -1.756     0.200
     4.239    -1.947     0.200
     4.793    -1.922     0.200
     5.301    -0.621     0.200
     5.465    -2.220     0.200
     6.668    -2.344     0.200
     7.715    -4.059     0.200
     7.777    -5.524     0.200
     2.586    -0.093     0.200
     2.696    -0.789     0.200
     3.511    -1.843     0.200
     3.852    -2.531     0.200
     4.234    -1.153     0.200
     4.787    -1.995     0.200
     5.300    -2.248     0.200
     5.461    -1.749     0.200
     6.663    -3.852     0.200
     7.715    -4.195     0.200
     7.773    -5.339     0.200
     2.574     0.043     0.200
     3.334    -0.855     0.200
     3.979    -1.219     0.200
     4.489     0.514     0.200
     4.540    -1.402     0.200
     6.922    -2.193     0.200
     2.504     0.145     0.200
     3.528    -1.317     0.200
     3.869    -3.142     0.200
     3.869    -1.642     0.200
     4.804    -1.284     0.200
     4.804    -0.784     0.200
     5.329    -0.708     0.200
     5.486    -1.381     0.200
     6.053    -2.379     0.200
     6.686    -2.417     0.200
     7.744    -4.455     0.200
     7.796    -4.630     0.200
     8.076    -5.478     0.200
     9.136    -4.894     0.200
     9.778    -3.859     0.200
    10.262    -4.290     0.200
    11.143    -7.718     0.200
     2.715    -1.257     0.200
     3.526    -0.360     0.200
     3.867    -0.375     0.200
     4.253    -1.607     0.200
     4.803    -2.124     0.200
     5.323    -2.127     0.200
     5.482    -1.353     0.200
     6.682    -1.410     0.200
     7.738    -2.671     0.200
     2.560    -0.012     0.200
     2.526    -0.955     0.200
     2.680    -0.339     0.200
     3.485    -2.354     0.200
     3.827    -2.394     0.200
     4.217    -0.464     0.200
     4.762    -1.325     0.200
     5.309    -2.167     0.200
     5.450    -2.127     0.200
     5.604    -0.222     0.200
     6.647    -3.176     0.200
     7.758    -2.817     0.200
     7.726    -3.174     0.200
     8.039    -3.726     0.200
     9.097    -5.156     0.200
     9.740    -6.344     0.200
    10.737    -5.244     0.200
     2.524    -0.528     0.200
     2.551    -0.563     0.200
     2.670    -2.147     0.200
     3.476    -2.203     0.200
     3.818    -2.234     0.200
     4.207    -1.580     0.200
     4.753    -2.569     0.200
     5.299    -2.385     0.200
     5.439    -1.631     0.200
     5.610    -6.228     0.200
     6.636    -2.588     0.200
     7.716    -5.102     0.200
     7.748    -4.623     0.200
     9.087    -4.067     0.200
     3.857     0.179     0.200
     4.235    -0.504     0.200
     2.512    -2.066     0.200
     2.635     0.329     0.200
     2.738    -1.023     0.200
     3.900    -1.581     0.200
     4.277    -1.517     0.200
     4.836    -3.159     0.200
     5.316    -0.955     0.200
     5.499    -1.662     0.200
     5.515    -1.769     0.200
     6.004    -0.379     0.200
     2.505    -0.912     0.200
     2.688    -0.107     0.200
     2.810    -0.974     0.200
     3.956    -2.409     0.200
     4.348    -1.715     0.200
     4.891    -2.626     0.200
     5.407    -0.890     0.200
     5.577    -3.490     0.200
     6.777    -3.821     0.200
     7.819    -3.155     0.200
     7.888    -3.442     0.200
     8.167    -2.587     0.200
     9.227    -4.400     0.200
     9.870    -5.771     0.200
    10.353    -7.686     0.200
    10.865    -5.714     0.200
    11.234    -6.405     0.200
    11.409    -7.151     0.200
     2.513    -0.300     0.200
     2.696    -0.928     0.200
     3.222    -2.883     0.200
     3.846    -2.067     0.200
     4.234    -1.770     0.200
     5.315    -0.135     0.200
     5.584    -3.947     0.200
     2.633    -0.334     0.200
     2.638    -0.687     0.200
     3.555    -1.567     0.200
     3.878    -1.788     0.200
     4.178    -0.319     0.200
     4.820    -2.451     0.200
     5.355    -0.620     0.200
     6.599    -1.041     0.200
     7.447    -3.935     0.200
     7.692    -3.684     0.200
     2.507    -2.152     0.200
     2.649     0.448     0.200
     2.759    -0.254     0.200
     3.915    -1.108     0.200
     4.298    -1.526     0.200
     4.851    -3.561     0.200
     5.346    -1.874     0.200
     5.523    -1.666     0.200
     5.515    -2.599     0.200
     6.727    -1.623     0.200
     7.759    -3.346     0.200
     7.836    -4.695     0.200
    10.304    -4.416     0.200
     2.633     0.679     0.200
     3.273    -0.099     0.200
     3.911    -0.834     0.200
     4.470    -1.259     0.200
     6.904    -0.915     0.200
     3.171    -0.922     0.200
     3.500    -1.936     0.200
     3.841    -1.755     0.200
     4.440    -2.151     0.200
     4.919    -2.926     0.200
     6.268    -1.489     0.200
     7.341    -2.615     0.200
     7.373    -1.616     0.200
     8.716    -6.708     0.200
     2.551    -2.478     0.200
     3.011    -0.181     0.200
     3.233    -2.108     0.200
     3.953     2.079     0.200
     4.284    -3.211     0.200
     4.755    -0.751     0.200
     6.023    -2.332     0.200
     8.347    -3.903     0.200
     8.611    -3.192     0.200
     9.635    -6.732     0.200
    11.305    -7.386     0.200
    11.755    -6.661     0.200
    17.221    -3.130     0.200
     2.659    -0.260     0.200
     2.692    -0.809     0.200
     3.911    -1.850     0.200
     4.234    -0.671     0.200
     4.852    -2.279     0.200
     5.423    -2.169     0.200
     5.406    -1.549     0.200
     5.877     1.442     0.200
     2.528    -0.456     0.200
     4.897     0.442     0.200
     5.896    -2.211     0.200
     7.573    -5.763     0.200
     3.295     0.528     0.200
     3.621    -1.294     0.200
     4.054    -2.739     0.200
     4.209    -1.730     0.200
     4.562    -2.838     0.200
    18.327    -0.094     0.200
     3.133    -1.702     0.200
     3.459    -0.040     0.200
     3.792    -2.487     0.200
     4.400    -1.774     0.200
     4.865    -2.095     0.200
     5.002    -0.749     0.200
     6.218    -3.405     0.200
     7.288    -3.506     0.200
     7.322    -3.692     0.200
     7.591    -3.027     0.200
     8.666    -4.609     0.200
     9.305    -4.257     0.200
     9.799    -6.197     0.200
    10.290    -5.382     0.200
    10.684    -6.766     0.200
     3.402    -0.318     0.200
     3.735    -1.283     0.200
     4.092    -2.582     0.200
     4.829    -2.939     0.200
     8.610    -2.819     0.200
     9.249    -2.681     0.200
     9.742    -6.193     0.200
    10.236    -3.650     0.200
    10.627    -7.357     0.200
    10.824    -7.993     0.200
     3.365    -0.748     0.200
     3.680    -1.627     0.200
     4.307    -2.420     0.200
     4.747    -2.138     0.200
     4.883    -0.866     0.200
     6.105    -3.600     0.200
     3.652     0.436     0.200
     4.290    -2.994     0.200
     4.702     0.050     0.200
     4.849    -0.721     0.200
     7.127    -4.904     0.200
     3.222    -1.363     0.200
     3.551    -0.605     0.200
     3.894     0.522     0.200
     4.492    -2.513     0.200
     4.959    -2.343     0.200
     6.321    -0.814     0.200
     7.426    -1.834     0.200
     7.697    -4.209     0.200
     9.409    -6.696     0.200
     9.901    -4.890     0.200
    10.674    -4.093     0.200
    10.786    -4.637     0.200
     2.730    -2.034     0.200
     2.717    -0.504     0.200
     3.640    -0.371     0.200
     3.964    -1.658     0.200
     4.271    -0.873     0.200
     4.906    -3.209     0.200
     5.126    -1.486     0.200
     5.449    -1.206     0.200
     7.524    -1.702     0.200
     7.785    -4.567     0.200
     8.034    -2.652     0.200
     9.135    -5.579     0.200
     9.769    -7.155     0.200
    10.274    -5.877     0.200
    10.734    -6.238     0.200
    11.164    -6.779     0.200
    11.375    -5.286     0.200
     3.069    -1.480     0.200
     3.920    -1.861     0.200
     4.257    -1.038     0.200
     5.195    -2.263     0.200
     5.501    -0.463     0.200
     5.810    -1.757     0.200
     7.036    -1.942     0.200
     7.893    -5.101     0.200
     8.137    -2.044     0.200
     9.484    -8.221     0.200
    10.617    -4.446     0.200
    11.097    -4.857     0.200
     2.652    -1.901     0.200
     2.621    -0.705     0.200
     3.850    -1.894     0.200
     4.162    -1.760     0.200
     4.792    -2.244     0.200
     5.062    -2.797     0.200
     5.346    -2.503     0.200
     6.584    -2.540     0.200
     7.466    -0.916     0.200
     7.679    -3.561     0.200
     3.081    -1.768     0.200
     4.267    -1.274     0.200
     4.267    -1.673     0.200
     4.622     0.373     0.200
     5.205    -0.891     0.200
     5.164    -1.209     0.200
     5.514    -1.597     0.200
     5.667     0.374     0.200
     5.823    -1.968     0.200
     7.049    -4.833     0.200
     2.575    -0.047     0.200
     2.629    -2.555     0.200
     2.595    -0.669     0.200
     3.498    -1.313     0.200
     3.823    -0.809     0.200
     4.136    -1.025     0.200
     5.048     0.563     0.200
     5.322    -0.623     0.200
     2.564     0.954     0.200
     3.953    -1.253     0.200
     4.507    -2.035     0.200
     5.099    -1.092     0.200
     5.187    -1.889     0.200
     5.802    -2.482     0.200
     6.275     0.013     0.200
     7.430    -3.196     0.200
     7.915    -3.580     0.200
     2.825    -2.086     0.200
     3.252    -2.425     0.200
     4.314    -3.183     0.200
     4.777    -3.156     0.200
     5.426    -2.929     0.200
     5.968    -2.808     0.200
     6.872    -1.877     0.200
     8.054    -6.049     0.200
     8.058    -6.175     0.200
     8.338    -3.558     0.200
     2.728    -0.632     0.200
     2.838    -0.916     0.200
     3.731    -2.633     0.200
     4.059    -1.237     0.200
     4.059    -1.635     0.200
     4.379    -1.174     0.200
     5.000    -2.658     0.200
     5.239    -2.840     0.200
     5.562    -0.982     0.200
     6.801    -3.860     0.200
     7.635    -2.880     0.200
     7.774    -5.188     0.200
     7.897    -6.080     0.200
    10.384    -5.115     0.200
     2.858    -2.703     0.200
     3.254    -2.835     0.200
     3.472     0.026     0.200
     3.639    -2.740     0.200
     4.471    -3.434     0.200
     4.756    -4.150     0.200
     4.813    -3.685     0.200
     4.813    -1.486     0.200
     5.180    -2.199     0.200
     5.295    -1.755     0.200
     5.748    -3.818     0.200
     5.748    -2.417     0.200
     5.977    -3.573     0.200
     6.375    -3.486     0.200
     7.542    -2.900     0.200
     7.606    -4.100     0.200
     8.344    -6.115     0.200
     8.586    -3.877     0.200
     8.706    -4.174     0.200
     8.961    -2.966     0.200
     9.078    -3.857     0.200
     9.579    -4.547     0.200
     9.978    -4.598     0.200
    10.053    -4.372     0.200
    10.690    -6.955     0.200
    11.186    -8.404     0.200
    12.072    -6.972     0.200
    12.260    -5.755     0.200
     2.663    -1.040     0.200
     2.895    -0.088     0.200
     3.272     0.958     0.200
     3.444    -2.487     0.200
     4.143    -1.745     0.200
     4.722    -2.008     0.200
     5.315    -1.613     0.200
     5.677    -1.592     0.200
     6.591     0.057     0.200
     2.661     0.696     0.200
     2.891    -0.882     0.200
     3.223    -0.416     0.200
     3.593    -0.943     0.200
     4.162    -3.087     0.200
     4.832    -1.518     0.200
     4.825     0.506     0.200
     6.022    -4.155     0.200
    10.118    -8.291     0.200
     2.567    -1.763     0.200
     2.568    -1.375     0.200
     2.859    -0.106     0.200
     3.406    -3.036     0.200
     3.662    -2.355     0.200
     3.919    -0.027     0.200
     4.343     0.450     0.200
     4.811    -0.698     0.200
     5.144    -1.854     0.200
     5.459    -2.429     0.200
     6.051    -0.902     0.200
     6.084    -1.135     0.200
     6.612    -3.991     0.200
     7.875    -3.234     0.200
     8.381    -5.558     0.200
     8.370    -6.423     0.200
     8.960    -6.229     0.200
     9.289    -4.433     0.200
    10.224    -3.590     0.200
    11.888    -7.135     0.200
     2.687     0.210     0.200
     2.687    -0.790     0.200
     2.627    -0.007     0.200
     2.627     1.093     0.200
     3.002    -0.885     0.200
     3.313    -1.359     0.200
     3.313    -1.059     0.200
     3.945    -0.771     0.200
     3.945    -1.771     0.200
     4.529    -2.900     0.200
     4.529    -2.300     0.200
     4.510    -0.006     0.200
     5.740    -3.976     0.200
     6.538    -1.769     0.200
     6.542    -1.905     0.200
     6.844    -4.196     0.200
     6.944    -1.151     0.200
     7.255    -2.405     0.200
     8.120    -3.145     0.200
     8.827    -3.954     0.200
     9.320    -6.666     0.200
     9.817    -4.527     0.200
    10.206    -7.244     0.200
    10.407    -7.941     0.200
     2.661    -0.774     0.200
     2.661    -0.274     0.200
     2.892    -0.718     0.200
     3.225    -1.651     0.200
     3.225    -0.451     0.200
     3.595    -2.585     0.200
     3.595    -0.882     0.200
     4.164    -1.424     0.200
     4.164    -1.525     0.200
     2.522    -0.085     0.200
     2.968    -0.414     0.200
     3.169     0.014     0.200
     3.958    -1.793     0.200
     4.304    -2.187     0.200
     4.706    -1.122     0.200
     5.250    -5.350     0.200
     5.236    -3.520     0.200
     5.705    -0.082     0.200
     5.934    -0.732     0.200
     2.504     0.395     0.200
     3.227    -0.908     0.200
     3.542    -0.592     0.200
     4.169    -1.981     0.200
     4.351    -1.561     0.200
     4.545    -1.809     0.200
     4.750    -1.603     0.200
     7.087    -1.195     0.200
     2.907    -1.224     0.200
     2.990    -1.076     0.200
     3.028    -2.494     0.200
     4.249    -1.384     0.200
     4.527    -0.403     0.200
     5.035    -0.913     0.200
     5.192    -1.964     0.200
     5.233    -2.388     0.200
     5.678    -1.565     0.200
     7.609    -2.504     0.200
     2.823    -1.365     0.200
     2.915    -0.968     0.200
     2.915    -1.468     0.200
     3.506     0.488     0.200
     3.527    -1.791     0.200
     3.677    -3.327     0.200
     4.388    -1.293     0.200
     4.533    -0.972     0.200
     4.839    -1.490     0.200
     4.853     1.391     0.200
     5.046    -0.626     0.200
     5.414    -1.713     0.200
     5.782    -1.772     0.200
     6.127    -1.293     0.200
     7.434    -2.722     0.200
     7.725    -3.055     0.200
     8.079    -4.384     0.200
     8.628    -4.581     0.200
     8.684    -3.456     0.200
     8.761    -4.308     0.200
     9.741    -3.855     0.200
     9.856    -4.005     0.200
    11.012    -7.772     0.200
    11.376    -6.213     0.200
    11.914    -5.755     0.200
    12.178    -7.225     0.200
    16.152     1.281     0.200
     2.538    -1.555     0.200
     2.538    -1.860     0.200
     3.324    -1.477     0.200
     3.645    -2.144     0.200
     3.934    -2.221     0.200
     3.947    -1.328     0.200
     4.587    -1.319     0.200
     4.891    -1.757     0.200
     5.132    -0.807     0.200
     6.369    -2.398     0.200
     7.134    -4.654     0.200
     7.173    -4.503     0.200
     7.304    -3.137     0.200
     7.464    -3.935     0.200
     7.667    -4.260     0.200
     7.840    -2.636     0.200
     9.448    -4.017     0.200
     9.951    -7.456     0.200
    10.419    -7.094     0.200
     2.792    -2.586     0.200
     2.878    -0.739     0.200
     3.041    -1.394     0.200
     3.354    -2.712     0.200
     3.446    -3.815     0.200
     3.729    -1.712     0.200
     3.883    -2.389     0.200
     4.221    -1.609     0.200
     4.582    -1.045     0.200
     5.158    -2.312     0.200
     5.215    -0.820     0.200
     5.500    -1.226     0.200
     5.717    -0.819     0.200
     5.787    -2.133     0.200
     7.009    -1.672     0.200
     7.791    -5.976     0.200
     7.827    -3.299     0.200
     7.895    -4.867     0.200
     8.112    -5.134     0.200
     8.498    -4.189     0.200
     2.806    -2.839     0.200
     2.881     0.095     0.200
     3.039    -1.016     0.200
     3.039    -0.416     0.200
     3.350    -0.666     0.200
     3.442    -1.707     0.200
     3.717    -0.600     0.200
     3.887    -0.597     0.200
     4.224    -1.886     0.200
     4.224    -1.187     0.200
     4.580    -0.973     0.200
     5.162    -2.005     0.200
     5.203    -1.202     0.200
     5.485    -0.064     0.200
     5.703    -0.353     0.200
     5.782    -3.467     0.200
     7.006    -2.286     0.200
     8.492    -2.576     0.200
     9.382    -6.382     0.200
    10.587    -5.581     0.200
    11.069    -4.775     0.200
    11.472    -4.845     0.200
    11.664    -7.516     0.200
     2.530    -0.249     0.200
     3.219    -2.112     0.200
     4.984    -2.253     0.200
     5.372    -3.641     0.200
     5.915    -2.679     0.200
     6.192    -0.834     0.200
     6.577    -3.162     0.200
     7.420    -2.172     0.200
     8.579    -5.124     0.200
     8.557    -3.807     0.200
     8.903    -3.697     0.200
     2.592    -0.551     0.200
     3.451    -1.479     0.200
     3.829    -1.869     0.200
     4.389    -2.303     0.200
     5.003    -1.493     0.200
     6.258    -3.877     0.200
     6.362    -0.777     0.200
     7.080    -3.335     0.200
     7.100    -5.643     0.200
     7.371    -2.835     0.200
     7.430    -5.829     0.200
     9.834    -3.738     0.200
     2.505    -1.793     0.200
     2.598    -0.540     0.200
     2.598    -0.243     0.200
     2.789    -1.408     0.200
     2.789    -1.009     0.200
     3.596    -0.468     0.200
     3.596    -1.273     0.200
     3.733    -1.222     0.200
     3.733    -2.417     0.200
     3.938    -2.124     0.200
     3.938    -1.921     0.200
     4.025    -1.982     0.200
     4.327    -2.155     0.200
     4.327    -2.460     0.200
     4.873    -2.352     0.200
     4.873    -2.251     0.200
     5.386    -1.626     0.200
     6.394    -2.493     0.200
     6.756    -3.464     0.200
     7.568    -3.492     0.200
     7.798    -5.001     0.200
     7.867    -3.370     0.200
     8.095    -2.596     0.200
     8.280    -1.757     0.200
     9.145    -3.581     0.200
     9.849    -5.608     0.200
    10.333    -5.836     0.200
    10.844    -5.535     0.200
    11.214    -6.160     0.200
    11.390    -6.532     0.200
     2.684    -0.668     0.200
     2.684    -0.867     0.200
     3.500    -0.134     0.200
     3.500    -0.434     0.200
     3.840    -1.719     0.200
     3.840    -1.418     0.200
     3.828    -2.130     0.200
     4.092    -1.483     0.200
     4.222    -1.432     0.200
     4.776    -1.283     0.200
     5.291    -1.301     0.200
     5.449    -2.030     0.200
     6.064    -4.096     0.200
     6.651    -3.028     0.200
     7.462    -2.812     0.200
     7.486    -5.794     0.200
     7.761    -5.216     0.200
     8.039    -2.524     0.200
     8.173    -2.973     0.200
     9.039    -4.915     0.200
     9.102    -5.998     0.200
     9.744    -4.750     0.200
    10.228    -6.916     0.200
    10.737    -5.356     0.200
     2.502    -0.295     0.200
     2.502    -0.194     0.200
     2.691    -1.189     0.200
     2.691    -1.689     0.200
     3.502    -0.491     0.200
     3.502    -0.792     0.200
     3.826    -1.385     0.200
     3.843    -0.900     0.200
     3.843    -2.400     0.200
     4.097    -4.074     0.200
     4.229    -1.739     0.200
     4.778    -0.953     0.200
     4.778    -2.550     0.200
     5.306    -0.277     0.200
     5.458    -2.809     0.200
     5.582    -3.736     0.200
     6.071     1.255     0.200
     6.658    -2.843     0.200
     7.471    -3.507     0.200
    10.234    -7.116     0.200
    10.746    -5.131     0.200
    11.115    -9.245     0.200
    11.292    -5.159     0.200
     2.507    -1.089     0.200
     2.695    -0.948     0.200
     2.695    -1.249     0.200
     3.507    -0.693     0.200
     3.821    -4.124     0.200
     3.821    -4.425     0.200
     3.848    -1.202     0.200
     4.091    -3.582     0.200
     4.233    -2.303     0.200
     4.784    -0.652     0.200
     5.306    -2.516     0.200
     5.462    -2.447     0.200
     5.575    -5.740     0.200
     6.064    -2.450     0.200
     7.474    -3.740     0.200
     7.498    -1.704     0.200
     7.773    -5.009     0.200
     8.001    -4.042     0.200
     8.186    -2.712     0.200
     9.051    -6.118     0.200
     9.755    -6.943     0.200
    10.239    -5.582     0.200
    10.750    -4.271     0.200
    11.120    -6.219     0.200
    11.298    -8.745     0.200
     2.535    -0.391     0.200
     3.397    -0.120     0.200
     3.729    -2.439     0.200
     3.939    -0.594     0.200
     4.076    -1.142     0.200
     4.126    -3.132     0.200
     4.669    -0.224     0.200
     5.096    -2.157     0.200
     5.286    -1.492     0.200
     5.606    -3.840     0.200
     6.503    -2.272     0.200
     7.294    -4.145     0.200
     8.882    -3.082     0.200
    10.083    -3.953     0.200
    11.161    -5.426     0.200
     2.687    -1.294     0.200
     3.505    -0.935     0.200
     3.823    -3.906     0.200
     3.845    -2.109     0.200
     4.084    -3.585     0.200
     4.225    -1.565     0.200
     4.781    -1.880     0.200
     5.288    -1.163     0.200
     5.451    -2.628     0.200
     5.568    -6.934     0.200
     6.056    -1.287     0.200
     6.654    -4.461     0.200
     7.703    -4.809     0.200
     7.764    -3.037     0.200
     2.661    -0.812     0.200
     2.661    -0.312     0.200
     3.482    -1.316     0.200
     3.821    -2.475     0.200
     3.821    -0.875     0.200
     3.847    -1.492     0.200
     3.847    -1.292     0.200
     3.871    -4.276     0.200
     4.011    -4.596     0.200
     4.200    -2.386     0.200
     4.495    -4.140     0.200
     4.757    -2.954     0.200
     5.266    -1.390     0.200
     5.426    -2.443     0.200
     6.071     1.192     0.200
     6.629    -2.781     0.200
     7.682    -4.158     0.200
     7.738    -3.853     0.200
     8.149    -2.975     0.200
     2.655    -1.108     0.200
     3.853    -1.992     0.200
     4.008    -2.508     0.200
     4.107    -1.638     0.200
     4.107    -3.138     0.200
     4.193    -1.582     0.200
     5.591    -2.975     0.200
     7.958    -7.111     0.200
     8.099    -8.401     0.200
     2.626    -1.375     0.200
     3.797    -2.510     0.200
     3.869    -3.891     0.200
     4.037    -3.518     0.200
     4.102    -1.569     0.200
     4.166    -1.982     0.200
     4.735    -2.129     0.200
     5.214    -2.908     0.200
     8.001    -7.153     0.200
     2.646    -0.436     0.200
     3.468    -0.620     0.200
     3.807    -0.963     0.200
     3.860    -3.138     0.200
     3.860    -2.840     0.200
     3.860    -2.539     0.200
     4.110    -1.950     0.200
     4.184    -1.016     0.200
     4.744    -2.252     0.200
     5.250    -2.200     0.200
     5.409    -2.950     0.200
     5.593    -2.880     0.200
     6.078    -1.033     0.200
     6.613    -3.307     0.200
     7.421    -2.518     0.200
     7.446    -5.722     0.200
     7.666    -4.378     0.200
     7.722    -4.071     0.200
     7.948    -3.536     0.200
     8.133    -2.975     0.200
     9.000    -5.561     0.200
     9.705    -6.512     0.200
    10.190    -6.610     0.200
    10.697    -5.377     0.200
    11.072    -7.968     0.200
    11.253    -7.101     0.200
     2.517    -1.387     0.200
     2.517    -0.887     0.200
     2.718    -2.171     0.200
     2.718    -1.769     0.200
     3.523    -2.599     0.200
     3.523    -1.701     0.200
     3.865    -3.140     0.200
     3.865    -2.941     0.200
     3.805    -3.339     0.200
     3.805    -3.539     0.200
     4.087    -2.464     0.200
     4.087    -3.866     0.200
     4.255    -3.105     0.200
     4.435    -4.098     0.200
     4.800    -2.573     0.200
     5.335    -2.847     0.200
     5.486    -4.026     0.200
     5.572    -6.339     0.200
     7.499    -4.938     0.200
     7.751    -3.713     0.200
     7.796    -4.844     0.200
     8.211    -5.417     0.200
     2.502    -0.879     0.200
     2.689    -0.799     0.200
     2.689    -0.697     0.200
     3.503    -1.999     0.200
     3.503    -0.499     0.200
     3.825    -3.412     0.200
     3.825    -3.310     0.200
     3.844    -1.795     0.200
     3.844    -1.897     0.200
     4.005    -4.205     0.200
     4.092    -3.462     0.200
     4.092    -3.962     0.200
     4.227    -1.456     0.200
     4.466    -4.215     0.200
     4.779    -1.751     0.200
     5.298    -1.708     0.200
     5.455    -2.380     0.200
     5.576    -6.620     0.200
     7.714    -4.676     0.200
     7.767    -6.254     0.200
     8.362    -8.734     0.200
     2.674    -1.057     0.200
     3.493    -1.103     0.200
     3.832    -0.875     0.200
     3.836    -3.482     0.200
     4.011    -2.756     0.200
     4.095    -0.500     0.200
     4.213    -1.827     0.200
     5.579    -3.842     0.200
     2.500    -0.403     0.200
     2.500    -0.602     0.200
     2.687    -1.330     0.200
     2.687    -1.130     0.200
     3.499    -0.291     0.200
     3.499    -0.791     0.200
     3.840    -2.092     0.200
     3.829    -3.336     0.200
     3.829    -2.636     0.200
     4.225    -1.984     0.200
     4.225    -2.584     0.200
     4.097    -1.830     0.200
     4.097    -3.230     0.200
     4.468    -3.083     0.200
     4.776    -3.448     0.200
     4.776    -3.248     0.200
     5.299    -3.243     0.200
     5.453    -3.929     0.200
     6.292    -3.010     0.200
     6.654    -4.686     0.200
     7.466    -5.223     0.200
     7.490    -1.386     0.200
     7.764    -4.890     0.200
     7.715    -4.413     0.200
     7.992    -4.723     0.200
     8.043    -2.927     0.200
     8.659    -4.159     0.200
     9.042    -6.397     0.200
     9.104    -3.760     0.200
     9.746    -6.622     0.200
    10.230    -6.765     0.200
    11.289    -7.031     0.200
    14.642    -5.207     0.200
     2.667    -1.022     0.200
     2.667    -1.322     0.200
     3.484    -1.410     0.200
     3.484    -0.613     0.200
     3.824    -0.989     0.200
     3.824    -1.891     0.200
     3.845    -2.058     0.200
     3.845    -4.257     0.200
     4.002    -3.762     0.200
     4.205    -2.188     0.200
     4.105    -2.304     0.200
     4.105    -4.203     0.200
     4.488    -4.256     0.200
     4.760    -0.560     0.200
     5.277    -3.670     0.200
     5.277    -2.069     0.200
     5.432    -1.991     0.200
     5.589    -4.549     0.200
     7.445    -3.976     0.200
     7.693    -2.047     0.200
     7.744    -3.676     0.200
     9.022    -3.075     0.200
    10.211    -4.074     0.200
    10.720    -4.019     0.200
    11.277    -0.523     0.200
     2.676    -1.574     0.200
     3.493    -0.876     0.200
     3.835    -2.443     0.200
     3.835    -3.342     0.200
     3.833    -1.552     0.200
     4.008    -2.917     0.200
     4.096    -1.612     0.200
     4.096    -3.315     0.200
     4.214    -1.841     0.200
     4.769    -0.721     0.200
     5.283    -1.513     0.200
     5.441    -2.731     0.200
     5.581    -5.660     0.200
     2.643    -0.127     0.200
     2.696    -1.806     0.200
     3.802    -0.847     0.200
     3.802    -1.246     0.200
     3.881    -1.471     0.200
     3.927    -0.714     0.200
     3.927     0.583     0.200
     4.184    -1.260     0.200
     4.823    -0.832     0.200
     5.055    -1.270     0.200
     2.668    -0.968     0.200
     3.484    -0.457     0.200
     3.824    -1.636     0.200
     3.844    -3.263     0.200
     4.003    -3.800     0.200
     4.206    -2.431     0.200
     4.104    -4.110     0.200
     4.104    -3.810     0.200
     4.488    -3.265     0.200
     4.760    -1.904     0.200
     5.278    -0.406     0.200
     5.433    -2.535     0.200
     5.588    -6.156     0.200
     6.635    -4.430     0.200
     7.128    -6.466     0.200
     7.445    -3.820     0.200
     7.470    -1.498     0.200
     7.693    -3.682     0.200
     7.745    -2.819     0.200
     7.972    -3.726     0.200
     8.157    -4.586     0.200
     9.022    -3.119     0.200
    10.212    -5.718     0.200
    11.272    -6.333     0.200
    11.277    -4.579     0.200
     2.504    -0.850     0.200
     2.679    -1.094     0.200
     2.679    -1.793     0.200
     3.491    -0.024     0.200
     3.491    -0.422     0.200
     3.837    -3.798     0.200
     3.867    -3.633     0.200
     3.832    -2.629     0.200
     3.832    -1.727     0.200
     3.993    -3.643     0.200
     4.105    -4.491     0.200
     4.105    -4.292     0.200
     4.217    -3.243     0.200
     4.767    -3.181     0.200
     5.446    -3.606     0.200
     6.078    -6.128     0.200
     6.646    -4.347     0.200
     7.117    -7.050     0.200
     9.035    -3.665     0.200
     9.739    -5.985     0.200
    10.223    -4.321     0.200
    11.281    -7.072     0.200
     2.495    -0.523     0.200
     2.664    -0.894     0.200
     3.820    -1.837     0.200
     3.848    -3.735     0.200
     3.875    -3.391     0.200
     3.999    -2.703     0.200
     4.109    -1.798     0.200
     4.202    -2.255     0.200
     7.132    -7.517     0.200
     2.637    -0.811     0.200
     2.829    -1.293     0.200
     3.747    -2.717     0.200
     3.801    -3.231     0.200
     3.851    -0.419     0.200
     3.851    -0.216     0.200
     3.912    -1.833     0.200
     4.172    -0.989     0.200
     4.456    -1.980     0.200
     4.643    -3.308     0.200
     4.855    -1.424     0.200
     5.321    -3.202     0.200
     7.216    -7.379     0.200
     8.366    -8.927     0.200
     8.674    -6.902     0.200
     2.522     0.582     0.200
     2.522    -0.018     0.200
     2.719    -2.268     0.200
     2.719    -1.868     0.200
     3.789    -1.394     0.200
     3.789    -1.194     0.200
     3.977    -1.438     0.200
     4.059    -1.757     0.200
     4.059    -0.358     0.200
     4.732    -0.584     0.200
     4.883    -2.875     0.200
     4.883    -1.375     0.200
     5.219    -1.533     0.200
     2.869    -1.295     0.200
     3.029    -0.846     0.200
     3.454    -2.228     0.200
     3.454    -2.927     0.200
     3.729    -1.247     0.200
     3.729    -2.348     0.200
     4.155    -4.741     0.200
     4.213    -2.375     0.200
     4.570    -1.400     0.200
     5.215    -1.849     0.200
     6.771    -6.365     0.200
     7.681    -8.115     0.200
     7.828    -7.988     0.200
     2.801    -2.886     0.200
     2.872    -0.838     0.200
     3.030    -1.333     0.200
     3.451    -2.398     0.200
     3.451    -2.296     0.200
     3.451    -2.796     0.200
     3.723    -1.306     0.200
     3.723    -3.107     0.200
     3.878    -0.238     0.200
     3.878     0.360     0.200
     4.156    -4.228     0.200
     4.215    -1.922     0.200
     4.215    -2.723     0.200
     4.571    -2.691     0.200
     4.571    -2.991     0.200
     5.153    -2.346     0.200
     5.209    -5.207     0.200
     5.477    -0.408     0.200
     5.772    -1.383     0.200
     6.770    -6.411     0.200
     6.997    -1.403     0.200
     7.684    -7.971     0.200
     7.872    -4.227     0.200
     8.099    -3.029     0.200
     9.372    -2.998     0.200
    10.577    -4.302     0.200
    11.655    -6.041     0.200
     2.640     0.105     0.200
     2.640    -0.395     0.200
     2.631     0.003     0.200
     2.951    -1.962     0.200
     2.951    -0.759     0.200
     3.249    -0.514     0.200
     3.894    -1.150     0.200
     4.460    -1.806     0.200
     4.442    -1.231     0.200
     4.793    -0.953     0.200
     5.675    -2.806     0.200
     6.778    -2.773     0.200
     6.876    -2.086     0.200
     9.256    -4.714     0.200
     2.784    -2.276     0.200
     3.021    -1.279     0.200
     3.021    -2.178     0.200
     3.463    -2.475     0.200
     3.739    -1.527     0.200
     3.866    -3.671     0.200
     3.866     0.329     0.200
     4.204    -2.669     0.200
     4.204    -0.872     0.200
     4.562    -1.328     0.200
     4.562    -1.633     0.200
     5.141    -2.780     0.200
     5.478    -2.070     0.200
     5.766    -1.891     0.200
     6.989    -4.453     0.200
     7.874    -2.819     0.200
     8.091    -5.801     0.200
     2.859    -2.116     0.200
     2.590    -0.709     0.200
     2.590    -0.912     0.200
     2.929    -1.144     0.200
     3.640    -1.588     0.200
     4.771    -3.041     0.200
     5.178    -1.545     0.200
     5.700    -3.688     0.200
     6.091    -1.991     0.200
     6.400    -1.476     0.200
     8.472    -3.576     0.200
    11.184    -9.218     0.200
     2.534    -0.965     0.200
     2.534    -1.364     0.200
     2.781    -1.386     0.200
     2.781    -2.488     0.200
     3.505    -0.346     0.200
     3.790    -3.073     0.200
     3.816    -2.484     0.200
     3.816    -2.789     0.200
     4.069    -1.821     0.200
     4.759    -1.876     0.200
     4.845    -1.835     0.200
     5.403    -5.912     0.200
     6.480    -3.767     0.200
     7.243    -3.825     0.200
     7.563    -3.598     0.200
     7.798    -2.418     0.200
     8.828    -4.781     0.200
     9.547    -6.877     0.200
    10.064    -7.354     0.200
    10.497    -7.991     0.200
    10.920    -6.814     0.200
    10.958    -7.889     0.200
     2.538    -0.577     0.200
     2.538    -0.975     0.200
     2.782    -1.407     0.200
     2.782    -2.610     0.200
     3.509    -0.236     0.200
     3.509    -0.642     0.200
     3.819    -2.684     0.200
     3.819    -2.285     0.200
     4.073    -1.435     0.200
     4.073    -3.037     0.200
     4.762    -2.576     0.200
     4.762    -1.975     0.200
     4.850    -3.152     0.200
     4.850    -3.847     0.200
     5.221    -2.339     0.200
     5.400    -6.306     0.200
     7.247    -4.231     0.200
     7.568    -4.014     0.200
     3.560    -1.744     0.200
     3.560    -1.642     0.200
     3.892    -0.062     0.200
     3.892    -2.761     0.200
     4.113    -3.949     0.200
     4.501    -1.375     0.200
     4.929    -1.947     0.200
     5.098    -1.893     0.200
     5.731    -4.558     0.200
     6.188    -4.029     0.200
     6.318    -3.664     0.200
     7.349    -3.239     0.200
     7.420    -1.812     0.200
     3.236     0.009     0.200
     3.236    -1.191     0.200
     3.563    -1.464     0.200
     3.563    -2.464     0.200
     3.897    -0.329     0.200
     4.109    -2.668     0.200
     3.227    -1.426     0.200
     3.554    -1.072     0.200
     3.884    -0.440     0.200
     4.495    -1.406     0.200
     5.089    -0.956     0.200
     5.735    -4.921     0.200
     7.340    -3.288     0.200
     3.231    -0.876     0.200
     3.231    -0.177     0.200
     3.558    -1.126     0.200
     3.558    -1.727     0.200
     3.888    -0.400     0.200
     3.888    -1.798     0.200
     4.499    -2.061     0.200
     4.923    -2.712     0.200
     5.094    -1.211     0.200
     5.935    -1.275     0.200
     6.314    -1.798     0.200
     6.556    -2.974     0.200
     7.343    -2.604     0.200
     7.416    -3.438     0.200
     7.810    -2.736     0.200
     8.690    -6.831     0.200
     9.895    -6.904     0.200
    10.980    -7.996     0.200
     2.527    -0.091     0.200
     2.696    -0.252     0.200
     3.288    -0.909     0.200
     3.288     1.489     0.200
     3.635    -1.310     0.200
     3.635    -1.907     0.200
     4.057    -1.386     0.200
     4.566    -2.032     0.200
     4.566    -1.231     0.200
     5.274    -1.564     0.200
     5.312    -1.251     0.200
     6.486    -2.496     0.200
     7.605    -2.963     0.200
     7.700    -2.567     0.200
     3.235    -0.826     0.200
     3.235    -0.326     0.200
     3.562    -1.995     0.200
     3.562    -2.198     0.200
     3.895    -0.859     0.200
     3.895    -3.359     0.200
     4.110    -3.282     0.200
     4.503    -1.128     0.200
     4.503    -2.128     0.200
     4.935    -3.320     0.200
     5.102    -1.412     0.200
     5.731    -4.466     0.200
     6.321    -3.461     0.200
     7.354    -3.813     0.200
     7.424    -2.519     0.200
     9.407    -3.389     0.200
     9.902    -3.960     0.200
    10.787    -6.344     0.200
    10.985    -5.413     0.200
     2.813    -2.854     0.200
     2.887    -1.517     0.200
     3.045    -1.009     0.200
     3.045    -1.204     0.200
     3.436    -2.610     0.200
     3.710    -1.793     0.200
     3.893    -1.008     0.200
     4.141    -2.172     0.200
     4.231    -1.296     0.200
     4.231    -2.499     0.200
     4.586    -1.163     0.200
     4.586    -3.062     0.200
     5.168    -1.516     0.200
     5.168    -3.821     0.200
     5.488    -1.549     0.200
     5.787    -2.138     0.200
     6.630    -1.947     0.200
     6.755    -6.835     0.200
     7.790    -4.246     0.200
     7.827    -3.713     0.200
     7.882    -2.645     0.200
     8.497    -3.342     0.200
    10.097    -4.372     0.200
    11.478    -6.340     0.200
    11.554    -2.362     0.200
    11.670    -7.319     0.200
     2.698    -1.908     0.200
     2.698    -1.807     0.200
     2.769    -0.940     0.200
     3.005    -0.940     0.200
     3.005    -1.346     0.200
     3.606    -3.587     0.200
     3.745    -1.989     0.200
     3.745    -1.192     0.200
     4.141    -3.051     0.200
     4.098    -2.666     0.200
     4.535    -2.034     0.200
     4.535    -2.237     0.200
     5.024    -2.337     0.200
     5.670    -2.024     0.200
     5.787    -3.135     0.200
     6.622    -2.697     0.200
     6.964    -3.246     0.200
     7.749    -3.306     0.200
     7.805    -5.490     0.200
     8.085    -3.861     0.200
     8.327    -2.457     0.200
     8.377    -4.727     0.200
     8.520    -3.458     0.200
     9.365    -4.844     0.200
     9.416    -6.571     0.200
    10.534    -6.613     0.200
    11.073    -4.592     0.200
    11.410    -7.864     0.200
    11.665    -5.353     0.200
     2.711    -1.685     0.200
     2.773    -1.768     0.200
     3.013    -1.448     0.200
     3.013    -1.549     0.200
     3.605    -2.726     0.200
     3.748    -2.374     0.200
     3.748    -1.273     0.200
     4.024    -3.403     0.200
     4.101    -2.566     0.200
     4.101    -2.466     0.200
     4.542    -2.420     0.200
     5.027    -2.717     0.200
     5.683    -2.293     0.200
     5.796    -3.069     0.200
     6.799    -6.378     0.200
     6.971    -3.827     0.200
     3.231    -1.573     0.200
     3.231     0.327     0.200
     3.558    -1.655     0.200
     3.558    -2.555     0.200
     4.261    -1.146     0.200
     4.499    -1.480     0.200
     4.937    -2.861     0.200
     5.101    -1.846     0.200
     5.941    -3.404     0.200
     6.319    -3.271     0.200
     7.357    -5.267     0.200
     7.422    -3.438     0.200
     2.541    -0.492     0.200
     2.541    -1.393     0.200
     2.710    -2.636     0.200
     3.563    -0.971     0.200
     3.563    -0.172     0.200
     3.800    -2.401     0.200
     3.918    -1.435     0.200
     3.885    -2.078     0.200
     3.885    -2.478     0.200
     4.183    -1.338     0.200
     4.183    -0.137     0.200
     4.827    -3.643     0.200
     5.043    -2.492     0.200
     5.043    -2.892     0.200
     5.394    -5.816     0.200
     5.358    -1.186     0.200
     6.203    -1.658     0.200
     6.603    -2.547     0.200
     7.178    -7.383     0.200
     7.355    -4.285     0.200
     7.695    -2.172     0.200
     7.891    -3.860     0.200
    11.102    -1.613     0.200
    11.290    -7.231     0.200
     2.523    -1.161     0.200
     2.633    -1.751     0.200
     2.633    -1.550     0.200
     2.675    -2.176     0.200
     3.543    -0.900     0.200
     3.814    -4.185     0.200
     3.867    -3.565     0.200
     3.946    -2.559     0.200
     4.174    -2.796     0.200
     4.174    -2.196     0.200
     4.809    -3.520     0.200
     5.355    -2.634     0.200
     6.199    -2.490     0.200
     6.595    -1.853     0.200
     7.462    -4.132     0.200
     7.689    -2.841     0.200
     2.536    -0.823     0.200
     2.640    -0.138     0.200
     2.640    -0.333     0.200
     2.698    -1.563     0.200
     2.698    -1.664     0.200
     3.557    -0.485     0.200
     3.557    -0.086     0.200
     3.804    -2.737     0.200
     3.879    -1.915     0.200
     3.927    -3.030     0.200
     4.181    -2.167     0.200
     4.181    -2.870     0.200
     4.821    -1.676     0.200
     4.821    -1.973     0.200
     5.358    -1.185     0.200
     5.403    -3.729     0.200
     6.202    -3.351     0.200
     6.601    -1.995     0.200
     7.355    -5.110     0.200
     7.451    -3.635     0.200
     7.694    -3.846     0.200
     8.963    -6.179     0.200
    10.184    -4.267     0.200
    11.106    -5.284     0.200
     2.540    -0.613     0.200
     2.540    -1.711     0.200
     2.701    -1.298     0.200
     3.800    -3.832     0.200
     3.800    -4.035     0.200
     3.884    -1.406     0.200
     3.884    -3.304     0.200
     3.923    -1.153     0.200
     4.185    -1.968     0.200
     4.577    -3.578     0.200
     4.826    -2.768     0.200
     5.399    -5.449     0.200
     6.606    -2.593     0.200
     7.360    -4.405     0.200
     7.454    -2.993     0.200
     7.699    -4.240     0.200
     2.544    -0.155     0.200
     2.706    -1.379     0.200
     3.565     0.077     0.200
     3.888    -1.746     0.200
     3.918    -0.998     0.200
     4.189    -0.978     0.200
     4.575    -2.624     0.200
     4.830    -1.908     0.200
     5.365    -1.570     0.200
     6.210    -1.638     0.200
     6.609    -1.699     0.200
     7.362    -3.483     0.200
     7.454    -2.383     0.200
     7.702    -2.838     0.200
     8.066    -2.486     0.200
    11.111    -3.426     0.200
     3.243    -1.382     0.200
     3.572    -2.617     0.200
     3.572    -2.820     0.200
     3.914    -0.745     0.200
     4.098    -3.069     0.200
     4.513    -2.426     0.200
     4.969    -0.906     0.200
     5.125    -1.554     0.200
     6.341    -2.175     0.200
     7.424    -5.433     0.200
     7.389    -4.518     0.200
     7.445    -3.682     0.200
     8.720    -4.207     0.200
     9.921    -6.257     0.200
     2.502    -1.606     0.200
     2.502    -2.206     0.200
     2.554    -0.067     0.200
     2.736    -0.433     0.200
     2.736    -0.933     0.200
     3.556    -0.521     0.200
     3.556     0.279     0.200
     3.773    -3.295     0.200
     3.773    -4.195     0.200
     3.800    -4.073     0.200
     3.896    -1.098     0.200
     3.896    -2.098     0.200
     4.039    -4.053     0.200
     4.275    -1.315     0.200
     4.422    -3.483     0.200
     4.832    -1.768     0.200
     5.321    -0.583     0.200
     5.499    -1.813     0.200
     6.703    -3.006     0.200
     7.059    -6.691     0.200
     7.452    -3.142     0.200
     7.734    -1.563     0.200
     7.812    -2.563     0.200
     9.090    -4.447     0.200
     9.795    -5.904     0.200
    10.281    -6.309     0.200
    11.343    -6.479     0.200
     3.367    -0.833     0.200
     3.701    -0.647     0.200
     4.308    -1.372     0.200
     4.810    -1.985     0.200
     4.916    -0.445     0.200
     5.908    -5.484     0.200
     6.128    -3.581     0.200
     7.236    -4.792     0.200
     2.527    -1.533     0.200
     2.527    -0.233     0.200
     2.636    -1.162     0.200
     2.636    -0.761     0.200
     2.683    -2.559     0.200
     2.683    -1.459     0.200
     3.786    -3.328     0.200
     3.871    -2.632     0.200
     3.871    -2.132     0.200
     4.176    -2.503     0.200
     4.176    -1.303     0.200
     4.813    -2.790     0.200
     5.056    -0.982     0.200
     5.356    -2.799     0.200
     6.200    -1.459     0.200
     6.597    -2.649     0.200
     7.354    -2.948     0.200
     7.458    -3.540     0.200
     8.059    -3.271     0.200
     2.645    -1.569     0.200
     2.645    -0.765     0.200
     3.481    -0.167     0.200
     3.481    -0.269     0.200
     3.849    -2.342     0.200
     3.849    -3.647     0.200
     3.818    -2.150     0.200
     4.082    -3.145     0.200
     4.184    -1.078     0.200
     4.755    -2.566     0.200
     4.755    -2.667     0.200
     5.224    -0.730     0.200
     5.403    -1.420     0.200
     5.565    -6.153     0.200
     6.047    -4.008     0.200
     6.243    -2.543     0.200
     6.613    -3.050     0.200
     7.392    -3.358     0.200
     7.413    -4.037     0.200
     7.441    -3.521     0.200
     7.638    -3.251     0.200
     7.720    -2.547     0.200
     8.996    -5.210     0.200
    10.191    -7.188     0.200
    11.074    -6.182     0.200
    11.259    -6.951     0.200
     2.639    -1.569     0.200
     2.639    -0.268     0.200
     3.480    -0.112     0.200
     3.851    -3.576     0.200
     3.865    -3.024     0.200
     3.816    -2.970     0.200
     3.816    -1.970     0.200
     4.179    -0.590     0.200
     4.525    -2.142     0.200
     4.754    -2.201     0.200
     4.754    -2.599     0.200
     5.211    -0.105     0.200
     5.560    -5.671     0.200
     6.041    -4.790     0.200
     6.236    -1.900     0.200
     6.607    -2.856     0.200
     7.377    -3.770     0.200
     7.434    -4.179     0.200
     7.625    -4.215     0.200
     7.714    -2.633     0.200
     8.116    -5.885     0.200
     8.990    -4.383     0.200
     9.697    -3.788     0.200
    10.186    -7.000     0.200
    11.069    -7.005     0.200
    11.256    -6.620     0.200
     2.636    -0.554     0.200
     2.636    -0.156     0.200
     3.475    -0.052     0.200
     3.812    -2.913     0.200
     3.812    -1.811     0.200
     3.855    -2.481     0.200
     3.855    -3.582     0.200
     3.870    -2.951     0.200
     4.176    -0.673     0.200
     4.749    -1.941     0.200
     4.749    -2.242     0.200
     5.212    -1.617     0.200
     5.394    -1.476     0.200
     6.234    -1.405     0.200
     6.604    -4.943     0.200
     7.382    -3.061     0.200
     7.404    -1.686     0.200
     7.432    -2.082     0.200
     7.626    -3.636     0.200
     7.627    -4.953     0.200
     7.984    -4.361     0.200
     8.987    -5.084     0.200
     9.694    -4.882     0.200
    10.183    -6.985     0.200
    10.682    -7.609     0.200
    11.222    -2.932     0.200
    11.252    -5.681     0.200
     2.639    -1.202     0.200
     2.639    -0.202     0.200
     3.474    -1.686     0.200
     3.811    -2.264     0.200
     3.856    -0.674     0.200
     3.872    -3.803     0.200
     4.178    -0.810     0.200
     4.178    -2.208     0.200
     4.749    -1.882     0.200
     4.749    -2.382     0.200
     5.221    -2.355     0.200
     6.238    -1.186     0.200
     6.607    -1.682     0.200
     7.394    -2.332     0.200
     7.408    -2.992     0.200
     7.436    -1.867     0.200
     7.631    -3.569     0.200
     7.635    -3.590     0.200
     7.714    -3.989     0.200
     7.987    -5.152     0.200
    10.686    -7.995     0.200
    11.253    -6.071     0.200
     2.701    -1.973     0.200
     2.701    -0.473     0.200
     2.803    -2.824     0.200
     2.803    -2.621     0.200
     3.783    -1.978     0.200
     4.045    -2.982     0.200
     4.987    -2.831     0.200
     5.526    -1.841     0.200
     6.371    -2.017     0.200
     6.772    -2.618     0.200
     7.522    -4.417     0.200
     7.577    -3.839     0.200
     7.733    -4.906     0.200
     7.864    -4.841     0.200
     8.225    -4.694     0.200
    10.354    -6.688     0.200
    11.244    -6.899     0.200
    11.456    -7.221     0.200
     2.698    -1.460     0.200
     2.698    -0.655     0.200
     2.805    -2.549     0.200
     3.783    -1.862     0.200
     4.042    -2.263     0.200
     4.984    -2.216     0.200
     5.521    -2.150     0.200
     6.366    -1.734     0.200
     6.767    -2.642     0.200
     7.517    -3.514     0.200
     7.570    -3.387     0.200
     7.728    -4.200     0.200
     8.053    -3.209     0.200
     2.819    -0.284     0.200
     2.669    -2.641     0.200
     3.203    -1.856     0.200
     3.920    -1.366     0.200
     4.136    -2.629     0.200
     4.893    -3.127     0.200
     5.673    -2.945     0.200
     6.172    -3.863     0.200
     6.547    -3.852     0.200
     6.898    -3.883     0.200
     7.738    -3.324     0.200
     8.936    -4.399     0.200
     9.124    -3.652     0.200
     9.613    -3.362     0.200
     2.529    -2.379     0.200
     2.715    -2.792     0.200
     2.913    -1.751     0.200
     3.273    -3.268     0.200
     3.453    -2.167     0.200
     3.453    -3.066     0.200
     3.931    -1.425     0.200
     4.161    -2.121     0.200
     4.897    -2.048     0.200
     5.254    -2.174     0.200
     5.695    -1.457     0.200
     6.175    -2.464     0.200
     6.612    -2.310     0.200
     6.930    -2.705     0.200
     7.769    -1.498     0.200
     8.125    -3.378     0.200
     8.967    -5.076     0.200
     9.162    -2.856     0.200
     9.240    -2.221     0.200
     9.469    -3.986     0.200
     9.651    -3.135     0.200
    10.519    -4.061     0.200
    11.221    -6.824     0.200
    11.697    -7.916     0.200
    12.218    -6.233     0.200
    12.574    -7.397     0.200
    12.724    -5.873     0.200
     2.547    -0.677     0.200
     2.730    -1.180     0.200
     3.548    -0.116     0.200
     3.548    -1.522     0.200
     3.780    -3.570     0.200
     3.780    -3.374     0.200
     3.808    -3.670     0.200
     3.888    -1.806     0.200
     4.269    -1.761     0.200
     4.427    -4.682     0.200
     4.824    -2.972     0.200
     5.320    -2.486     0.200
     5.493    -1.987     0.200
     6.333    -3.188     0.200
     6.697    -4.356     0.200
     7.065    -6.020     0.200
     7.457    -4.331     0.200
     7.729    -2.652     0.200
     7.807    -3.319     0.200
     8.032    -4.369     0.200
     8.216    -3.192     0.200
     9.084    -6.511     0.200
     9.789    -5.456     0.200
    10.275    -5.153     0.200
    10.781    -5.015     0.200
    11.156    -5.801     0.200
    11.336    -6.300     0.200
     2.805     0.799     0.200
     2.805    -1.100     0.200
     3.118    -2.531     0.200
     3.118    -0.827     0.200
     3.415    -1.341     0.200
     3.415    -0.341     0.200
     4.061    -1.717     0.200
     4.539    -3.870     0.200
     4.575    -2.707     0.200
     4.537    -1.904     0.200
     4.633    -1.759     0.200
     4.618    -1.762     0.200
     4.618    -1.966     0.200
     5.458    -1.619     0.200
     5.839    -1.893     0.200
     6.850    -2.243     0.200
     6.940    -3.981     0.200
     6.967    -2.556     0.200
     7.127    -4.416     0.200
     8.214    -4.266     0.200
     9.421    -5.117     0.200
    10.308    -7.452     0.200
     2.885    -1.571     0.200
     2.885    -2.571     0.200
     3.267    -2.674     0.200
     3.404    -0.806     0.200
     3.673    -0.957     0.200
     3.759    -2.558     0.200
     4.352    -3.171     0.200
     4.714    -2.855     0.200
     5.226    -6.183     0.200
     5.196    -2.105     0.200
     5.628    -3.623     0.200
     6.462    -2.341     0.200
     7.294    -2.232     0.200
     7.623    -4.051     0.200
     8.128    -3.070     0.200
     8.716    -2.395     0.200
     8.713    -3.525     0.200
     8.748    -4.916     0.200
     9.197    -3.555     0.200
    10.031    -6.304     0.200
    11.186    -6.503     0.200
    12.056    -7.882     0.200
    12.187    -7.631     0.200
    12.338    -3.747     0.200
     2.718    -1.423     0.200
     2.718    -1.323     0.200
     3.242    -1.513     0.200
     3.388    -2.253     0.200
     3.488    -3.021     0.200
     3.862    -3.275     0.200
     3.976    -1.395     0.200
     4.330    -2.128     0.200
     4.772    -3.522     0.200
     4.772    -2.622     0.200
     5.255    -3.735     0.200
     5.865    -1.560     0.200
     6.022    -2.552     0.200
     6.857    -3.935     0.200
     7.201    -2.332     0.200
     8.753    -4.714     0.200
    10.771    -6.404     0.200
    11.646    -7.947     0.200
    11.798    -9.060     0.200
     2.668    -1.156     0.200
     2.668    -0.456     0.200
     2.681    -0.583     0.200
     3.098    -2.492     0.200
     3.683    -2.329     0.200
     3.703    -2.682     0.200
     3.716    -0.373     0.200
     3.708     0.669     0.200
     3.708     0.269     0.200
     3.811    -3.894     0.200
     3.811    -2.394     0.200
     4.002    -2.339     0.200
     4.002    -0.738     0.200
     4.183    -1.370     0.200
     4.183    -0.570     0.200
     4.943    -0.865     0.200
     5.273    -0.841     0.200
     5.584    -0.994     0.200
     6.121    -2.118     0.200
     6.572    -3.004     0.200
     7.097    -3.068     0.200
     7.238    -3.333     0.200
     7.311    -1.046     0.200
     7.431    -2.443     0.200
     8.997    -3.188     0.200
    10.152    -6.987     0.200
    11.315    -5.482     0.200
     2.826     0.116     0.200
     2.980    -1.566     0.200
     3.497    -3.145     0.200
     3.514    -2.185     0.200
     3.753    -1.373     0.200
     3.834    -0.025     0.200
     4.170    -0.979     0.200
     4.522    -2.325     0.200
     4.522    -1.426     0.200
     5.108    -1.715     0.200
     5.430    -1.720     0.200
     5.722    -3.276     0.200
     6.564    -1.390     0.200
     6.948    -1.033     0.200
     7.361    -3.843     0.200
     7.725    -2.088     0.200
     7.762    -1.952     0.200
     7.826    -3.884     0.200
     7.942    -2.250     0.200
     8.049    -4.140     0.200
     8.258    -2.763     0.200
     8.310    -2.210     0.200
     8.432    -2.779     0.200
     9.322    -6.001     0.200
     9.395    -5.412     0.200
     9.395    -6.810     0.200
    10.032    -5.618     0.200
    10.528    -5.129     0.200
    11.009    -5.984     0.200
    11.211    -2.895     0.200
    11.414    -5.406     0.200
    11.607    -7.632     0.200
     2.751    -1.455     0.200
     2.841    -2.303     0.200
     2.841    -1.905     0.200
     2.894    -2.971     0.200
     2.894    -2.869     0.200
     3.562    -1.941     0.200
     3.598    -3.287     0.200
     3.709    -1.713     0.200
     3.774    -1.461     0.200
     3.774    -1.360     0.200
     4.094    -2.718     0.200
     4.380    -2.073     0.200
     5.037    -2.194     0.200
     5.147    -2.005     0.200
     5.652    -3.792     0.200
     5.540    -2.745     0.200
     6.386    -1.158     0.200
     6.796    -2.463     0.200
     7.534    -2.764     0.200
     7.530    -3.843     0.200
     7.582    -1.367     0.200
     7.738    -3.616     0.200
     7.883    -2.926     0.200
     8.068    -4.198     0.200
     8.122    -1.688     0.200
     8.230    -3.933     0.200
     9.149    -3.165     0.200
     9.237    -6.234     0.200
     9.867    -5.617     0.200
    10.821    -5.266     0.200
    10.821    -8.563     0.200
    11.239    -3.333     0.200
    11.271    -7.032     0.200
    11.493    -7.451     0.200
     3.508    -2.199     0.200
     3.746    -1.733     0.200
     4.174    -2.822     0.200
     4.524    -2.711     0.200
     5.113    -2.463     0.200
     5.231    -5.514     0.200
     5.427    -1.818     0.200
     5.726    -4.201     0.200
     2.847    -1.749     0.200
     2.883    -2.805     0.200
     2.883    -2.606     0.200
     3.257    -3.663     0.200
     3.329    -0.530     0.200
     3.580    -1.676     0.200
     3.580    -1.176     0.200
     3.710    -2.613     0.200
     4.290     0.009     0.200
     4.648    -2.255     0.200
     5.107    -2.108     0.200
     5.568    -2.501     0.200
     6.362    -1.182     0.200
     8.580    -3.776     0.200
     8.657    -3.836     0.200
     9.988    -6.932     0.200
    10.636    -7.378     0.200
    11.104    -7.197     0.200
    11.942    -3.963     0.200
     2.635     0.420     0.200
     2.635     0.120     0.200
     2.682    -0.177     0.200
     2.952    -2.136     0.200
     2.952    -1.136     0.200
     3.274    -0.842     0.200
     3.274    -0.742     0.200
     3.894    -2.114     0.200
     3.894    -1.114     0.200
     4.497    -2.030     0.200
     4.511    -1.373     0.200
     4.704    -2.790     0.200
     4.731    -2.522     0.200
     4.731    -3.522     0.200
     6.697    -2.955     0.200
     6.808    -3.889     0.200
     6.946    -2.752     0.200
     8.085    -3.873     0.200
     8.150    -3.128     0.200
     8.791    -3.535     0.200
     9.280    -3.755     0.200
    10.363    -7.064     0.200
     2.743    -0.364     0.200
     2.743    -0.665     0.200
     2.871    -0.427     0.200
     2.871    -0.927     0.200
     3.584    -1.839     0.200
     3.578    -1.440     0.200
     3.758     0.555     0.200
     4.087    -2.490     0.200
     4.412    -1.690     0.200
     4.412    -2.690     0.200
     5.028    -0.204     0.200
     5.028    -2.005     0.200
     5.277    -0.300     0.200
     6.442    -1.529     0.200
     6.835    -2.595     0.200
     7.672    -3.525     0.200
     7.931    -4.245     0.200
     8.132    -2.294     0.200
     8.302    -1.178     0.200
    10.417    -5.046     0.200
    11.510    -6.386     0.200
     2.805    -2.856     0.200
     3.447    -2.509     0.200
     3.912    -1.936     0.200
     3.912    -2.037     0.200
     4.251    -2.286     0.200
     4.615    -2.431     0.200
     5.534    -2.461     0.200
     5.821    -2.667     0.200
     7.042    -3.469     0.200
     7.430    -3.875     0.200
     7.861    -2.232     0.200
     7.929    -2.479     0.200
     8.044    -3.118     0.200
     8.145    -3.346     0.200
     8.409    -3.313     0.200
    10.129    -6.118     0.200
    10.622    -4.746     0.200
    11.109    -5.285     0.200
    11.506    -8.083     0.200
    11.694    -6.437     0.200
     2.776    -2.444     0.200
     3.456    -3.509     0.200
     3.456    -1.708     0.200
     3.744    -2.736     0.200
     3.872    -0.483     0.200
     3.872    -2.386     0.200
     4.211    -1.424     0.200
     4.574    -1.247     0.200
     5.502    -1.637     0.200
     5.781    -1.802     0.200
     7.001    -2.888     0.200
     7.421    -2.300     0.200
     7.821    -1.063     0.200
     7.898    -1.612     0.200
     8.004    -2.575     0.200
     8.105    -2.770     0.200
    10.088    -6.139     0.200
    10.581    -6.261     0.200
    11.069    -5.324     0.200
    11.466    -4.797     0.200
    11.654    -8.957     0.200
     2.778    -2.611     0.200
     2.866    -1.226     0.200
     2.866    -1.027     0.200
     3.458    -2.374     0.200
     3.458    -2.173     0.200
     3.743    -2.024     0.200
     3.871     0.740     0.200
     3.871    -0.160     0.200
     4.209    -1.091     0.200
     4.572    -2.383     0.200
     4.572    -1.084     0.200
     5.146    -2.088     0.200
     5.778    -2.216     0.200
     6.999    -0.917     0.200
     7.818    -2.479     0.200
     7.893    -3.073     0.200
     8.001    -1.879     0.200
     8.102    -1.995     0.200
    10.085    -4.763     0.200
    10.578    -4.096     0.200
    11.065    -7.036     0.200
    11.651    -8.910     0.200
     2.760    -2.459     0.200
     2.760    -2.264     0.200
     3.614    -2.934     0.200
     3.621    -2.271     0.200
     3.722    -0.254     0.200
     3.722    -1.449     0.200
     3.806    -2.630     0.200
     4.051    -2.885     0.200
     4.051    -2.385     0.200
     4.328    -2.172     0.200
     4.375    -1.974     0.200
     4.991    -1.599     0.200
     5.288    -5.905     0.200
     5.249    -2.765     0.200
     5.249     0.633     0.200
     5.562    -2.383     0.200
     5.766    -4.074     0.200
     6.405    -1.834     0.200
     6.798    -4.378     0.200
     7.646    -3.651     0.200
     9.243    -2.995     0.200
    10.380    -6.926     0.200
     2.757    -2.395     0.200
     3.612    -2.511     0.200
     3.618    -2.599     0.200
     3.618    -2.099     0.200
     3.724    -0.253     0.200
     3.724    -1.253     0.200
     4.053    -2.904     0.200
     4.323    -1.542     0.200
     4.380    -3.249     0.200
     4.380    -2.647     0.200
     4.994    -2.814     0.200
     5.567    -2.897     0.200
     5.768    -3.863     0.200
     6.411    -2.040     0.200
     6.803    -2.466     0.200
     7.608    -2.698     0.200
     7.654    -4.155     0.200
     7.900    -4.835     0.200
     9.884    -6.519     0.200
     2.708    -2.050     0.200
     2.710    -0.227     0.200
     3.938    -1.945     0.200
     4.251    -1.079     0.200
     5.369    -5.804     0.200
     2.772    -2.226     0.200
     2.926    -0.107     0.200
     3.541    -3.620     0.200
     3.549    -2.652     0.200
     3.769    -2.451     0.200
     4.269    -4.685     0.200
     2.654    -0.639     0.200
     2.755    -0.667     0.200
     3.660    -2.833     0.200
     3.997    -2.533     0.200
     4.295    -1.281     0.200
     5.121    -2.167     0.200
     5.467    -2.014     0.200
     2.541    -2.161     0.200
     2.541    -1.763     0.200
     3.343    -1.082     0.200
     3.665    -1.685     0.200
     3.991    -3.028     0.200
     4.018    -3.357     0.200
     3.971    -1.980     0.200
     4.129    -1.692     0.200
     4.195    -2.685     0.200
     4.607    -1.648     0.200
     4.772    -4.072     0.200
     4.917    -0.557     0.200
     5.602    -4.792     0.200
     6.001    -0.742     0.200
     7.199    -0.204     0.200
     7.329    -2.422     0.200
     8.761    -1.715     0.200
     8.838    -7.274     0.200
     9.473    -2.702     0.200
    10.445    -2.894     0.200
    10.864    -6.492     0.200
     2.540    -2.022     0.200
     2.540    -1.522     0.200
     3.324     0.212     0.200
     3.645    -1.352     0.200
     3.946    -1.413     0.200
     3.946    -0.613     0.200
     4.041    -3.401     0.200
     4.199    -0.634     0.200
     4.587    -0.622     0.200
     4.800    -4.263     0.200
     4.889    -3.593     0.200
     4.889    -0.292     0.200
     5.131    -2.679     0.200
     5.131    -0.578     0.200
     5.615    -5.825     0.200
     6.368    -2.382     0.200
     7.349    -1.669     0.200
     7.464    -2.508     0.200
     7.839    -1.303     0.200
     8.734    -4.097     0.200
     8.813    -5.482     0.200
     9.950    -5.941     0.200
    11.050    -7.512     0.200
     2.502    -0.437     0.200
     2.689    -0.775     0.200
     3.843    -1.749     0.200
     4.227    -1.429     0.200
     2.753    -2.571     0.200
     2.780    -0.537     0.200
     2.931    -1.497     0.200
     2.931    -0.697     0.200
     3.542    -0.295     0.200
     3.555    -3.284     0.200
     3.784    -0.040     0.200
     3.790     0.671     0.200
     4.124    -1.042     0.200
     4.258    -2.668     0.200
     4.287    -4.490     0.200
     4.472    -2.259     0.200
     5.063    -1.994     0.200
     5.671    -2.767     0.200
     5.760    -1.675     0.200
     6.514    -2.978     0.200
     7.779    -3.307     0.200
     7.998    -4.548     0.200
     8.380    -2.559     0.200
     2.502    -0.961     0.200
     2.502    -0.160     0.200
     2.687    -0.507     0.200
     2.687    -0.406     0.200
     3.504    -0.208     0.200
     3.825    -4.181     0.200
     3.852    -3.947     0.200
     3.844    -2.488     0.200
     4.225    -1.173     0.200
     4.780    -2.055     0.200
     4.780    -1.855     0.200
     5.291    -0.058     0.200
     5.452    -1.856     0.200
     6.290    -2.746     0.200
     7.488    -4.321     0.200
     7.706    -1.609     0.200
     7.706    -4.609     0.200
     7.764    -1.853     0.200
     8.041    -4.451     0.200
     8.175    -1.995     0.200
     9.041    -5.650     0.200
    11.292    -6.985     0.200
     2.686    -0.609     0.200
     3.499    -0.563     0.200
     3.829    -2.743     0.200
     3.829    -2.544     0.200
     3.859    -4.278     0.200
     3.840    -1.565     0.200
     3.840    -2.565     0.200
     4.010    -1.878     0.200
     4.224    -2.261     0.200
     4.775    -1.720     0.200
     6.653    -4.763     0.200
     7.715    -3.804     0.200
     7.715    -2.304     0.200
     7.764    -4.069     0.200
    10.230    -6.243     0.200
     2.684    -0.475     0.200
     2.684    -0.577     0.200
     3.499     0.201     0.200
     3.499    -0.400     0.200
     3.830    -3.996     0.200
     3.858    -4.291     0.200
     3.839    -3.391     0.200
     3.839    -1.891     0.200
     4.016    -2.099     0.200
     4.095    -3.198     0.200
     4.222    -3.137     0.200
     4.222    -1.735     0.200
     4.471    -3.621     0.200
     4.775    -4.154     0.200
     4.775    -2.154     0.200
     5.293    -1.897     0.200
     5.450    -2.154     0.200
     5.450    -2.455     0.200
     6.288    -3.941     0.200
     6.651    -3.438     0.200
     7.486    -4.117     0.200
     7.761    -2.730     0.200
     8.040    -3.250     0.200
     8.174    -4.410     0.200
     9.101    -5.207     0.200
     9.743    -5.865     0.200
     9.743    -4.467     0.200
    10.228    -6.221     0.200
    11.109    -6.762     0.200
     2.750    -2.484     0.200
     2.794    -0.763     0.200
     2.948    -1.371     0.200
     4.137    -2.159     0.200
     4.490    -1.528     0.200
     5.075    -2.797     0.200
     5.267    -4.683     0.200
     5.691    -2.719     0.200
     2.784    -0.205     0.200
     2.932    -0.812     0.200
     4.128    -2.013     0.200
     4.473    -1.374     0.200
     5.262    -4.766     0.200
     2.561     0.142     0.200
     2.561    -1.159     0.200
     3.256     1.213     0.200
     3.595    -2.321     0.200
     3.595    -3.224     0.200
     3.978    -1.183     0.200
     4.072    -2.062     0.200
     4.092    -3.987     0.200
     4.092     0.013     0.200
     4.531    -1.310     0.200
     4.531    -1.713     0.200
     5.120    -0.483     0.200
     5.213    -1.418     0.200
     6.408    -2.290     0.200
     7.456    -2.217     0.200
     7.520    -3.446     0.200
     7.544    -1.504     0.200
     8.799    -2.579     0.200
     9.984    -4.949     0.200
    11.042    -5.295     0.200
     2.654    -0.914     0.200
     2.654    -1.114     0.200
     2.718    -1.843     0.200
     2.718    -2.343     0.200
     2.783    -1.308     0.200
     3.666    -3.498     0.200
     3.673    -4.234     0.200
     3.669    -0.006     0.200
     3.855    -2.884     0.200
     3.998    -3.341     0.200
     3.998    -3.640     0.200
     4.295    -2.445     0.200
     4.324    -0.971     0.200
     4.324    -2.271     0.200
     5.216    -0.941     0.200
     5.513    -2.860     0.200
     6.748    -5.094     0.200
     9.829    -4.460     0.200
    10.330    -6.937     0.200
    10.800    -3.737     0.200
    11.217    -4.582     0.200
    11.421    -5.935     0.200
     2.859    -1.771     0.200
     2.866    -1.717     0.200
     3.112    -0.096     0.200
     3.401    -3.175     0.200
     3.465    -0.575     0.200
     3.465    -1.473     0.200
     3.576    -1.710     0.200
     4.479    -2.851     0.200
     4.479    -3.453     0.200
     4.809    -1.701     0.200
     4.809    -3.505     0.200
     4.844    -3.398     0.200
     5.115    -1.297     0.200
     5.750    -2.516     0.200
     5.754    -1.867     0.200
     6.270    -3.807     0.200
     7.531    -2.097     0.200
     8.103    -3.409     0.200
     8.311    -3.321     0.200
     8.456    -1.996     0.200
     8.617    -3.005     0.200
     8.848    -5.639     0.200
     8.950    -4.669     0.200
    11.115    -4.387     0.200
    11.547    -5.698     0.200
    12.007    -7.170     0.200
    12.224    -4.571     0.200
     2.552     0.837     0.200
     2.552    -0.460     0.200
     2.864    -2.627     0.200
     2.959    -0.655     0.200
     3.365    -1.416     0.200
     3.493    -1.095     0.200
     4.481    -2.200     0.200
     4.481    -1.895     0.200
     4.829    -1.941     0.200
     5.227    -2.762     0.200
     5.227    -3.762     0.200
     5.760    -4.031     0.200
     6.105    -0.480     0.200
     6.442    -0.881     0.200
     7.186    -8.176     0.200
     7.186    -8.567     0.200
     7.656    -4.147     0.200
     7.714    -2.290     0.200
     8.481    -3.693     0.200
     8.763    -5.146     0.200
     9.031    -1.537     0.200
    10.746    -3.908     0.200
    11.234    -4.360     0.200
    11.730    -4.404     0.200
    12.115    -9.602     0.200
    12.201    -2.312     0.200
    12.288    -5.885     0.200
    17.288    -7.678     0.200
     2.565    -0.311     0.200
     2.565    -1.108     0.200
     2.683    -2.268     0.200
     2.683    -0.850     0.200
     3.583    -0.891     0.200
     3.751    -2.813     0.200
     3.768    -2.453     0.200
     3.909    -3.029     0.200
     3.918    -1.721     0.200
     4.224    -1.408     0.200
     4.224    -1.307     0.200
     4.850    -2.167     0.200
     5.115    -1.061     0.200
     5.408    -1.861     0.200
     6.646    -4.594     0.200
     8.113    -3.597     0.200
     2.547    -1.681     0.200
     3.389     0.246     0.200
     3.389     0.843     0.200
     3.713    -2.443     0.200
     3.713    -3.041     0.200
     3.945    -2.682     0.200
     3.964    -3.802     0.200
     4.029    -1.344     0.200
     4.096    -2.089     0.200
     4.187    -3.248     0.200
     4.655    -0.992     0.200
     4.981     0.474     0.200
     5.220    -2.209     0.200
     6.452    -3.566     0.200
     7.392    -3.067     0.200
     7.440    -2.077     0.200
     7.550    -4.761     0.200
     7.930    -3.498     0.200
     9.534    -6.946     0.200
    10.034    -3.109     0.200
    10.507    -5.905     0.200
    10.922    -6.258     0.200
    11.128    -7.486     0.200
     3.826    -2.509     0.200
     3.842    -4.133     0.200
     4.104    -3.737     0.200
     4.208    -1.932     0.200
     4.484    -3.580     0.200
     4.762    -3.776     0.200
     2.746    -2.437     0.200
     3.775    -2.541     0.200
     3.884    -1.707     0.200
     3.914    -1.555     0.200
     4.206    -0.926     0.200
     4.569    -3.620     0.200
     4.856    -3.126     0.200
     2.522    -2.530     0.200
     2.633    -0.748     0.200
     2.506    -0.337     0.200
     2.827    -1.303     0.200
     2.827    -2.603     0.200
     3.629    -0.735     0.200
     3.700    -2.474     0.200
     3.740    -3.749     0.200
     3.972    -1.412     0.200
     4.003    -2.794     0.200
     4.364    -1.442     0.200
     4.906    -3.023     0.200
     5.594    -1.819     0.200
     6.794    -3.548     0.200
     7.831    -3.842     0.200
     7.833    -2.395     0.200
     8.318    -3.671     0.200
    11.250    -6.929     0.200
     3.250     0.057     0.200
     3.572    -1.361     0.200
     4.108    -3.136     0.200
     3.885     0.046     0.200
     4.132    -2.605     0.200
     4.221    -2.534     0.200
     8.679    -3.337     0.200
     8.754    -3.920     0.200
     8.929    -3.268     0.200
     9.390    -6.183     0.200
     9.890    -5.121     0.200
    10.366    -4.811     0.200
    10.778    -5.265     0.200
    10.984    -8.904     0.200
     2.609     0.603     0.200
     2.609    -0.096     0.200
     2.655    -0.253     0.200
     2.655    -0.956     0.200
     2.899    -1.810     0.200
     2.899    -2.009     0.200
     3.636    -1.252     0.200
     3.636     1.048     0.200
     3.720    -1.329     0.200
     3.787    -1.237     0.200
     3.804    -1.498     0.200
     3.945    -1.441     0.200
     4.187    -1.521     0.200
     4.187    -2.021     0.200
     4.543    -1.218     0.200
     4.895    -0.783     0.200
     4.888    -3.235     0.200
     5.323    -2.031     0.200
     6.170    -1.674     0.200
     6.594    -2.544     0.200
     6.778    -3.054     0.200
     6.874    -4.116     0.200
     7.283    -3.466     0.200
     7.306    -3.990     0.200
     7.364    -1.839     0.200
     7.509    -4.221     0.200
     7.673    -3.639     0.200
     7.900    -2.634     0.200
     7.979    -4.127     0.200
     8.003    -3.181     0.200
     8.540    -3.123     0.200
     8.935    -2.944     0.200
     9.030    -3.261     0.200
     9.189    -4.490     0.200
     9.656    -7.589     0.200
     9.656    -5.706     0.200
    10.992    -3.240     0.200
    10.992    -3.244     0.200
    19.737    -0.346     0.200
    19.737    -0.341     0.200
     2.615    -0.512     0.200
     2.615    -1.715     0.200
     2.739    -0.438     0.200
     2.739    -0.938     0.200
     2.704    -2.037     0.200
     2.704    -2.334     0.200
     3.632     0.049     0.200
     3.632     0.150     0.200
     3.703    -2.997     0.200
     3.715    -3.777     0.200
     3.881    -1.663     0.200
     3.959    -2.136     0.200
     3.959    -3.534     0.200
     4.280    -0.501     0.200
     4.900    -1.963     0.200
     4.900    -3.167     0.200
     5.170    -1.621     0.200
     5.467    -1.520     0.200
     6.310    -3.060     0.200
     6.703    -3.002     0.200
     6.928    -2.128     0.200
     7.508    -3.119     0.200
     7.571    -2.121     0.200
     7.681    -2.017     0.200
     7.799    -4.359     0.200
     8.053    -3.006     0.200
     8.124    -3.762     0.200
     8.172    -3.373     0.200
     9.070    -6.149     0.200
     9.321    -6.701     0.200
     9.783    -7.245     0.200
    10.285    -6.551     0.200
    10.753    -4.192     0.200
    10.946    -6.714     0.200
    11.173    -5.607     0.200
    11.379    -5.030     0.200
     2.541    -1.640     0.200
     3.666    -1.622     0.200
     4.129    -1.293     0.200
     2.507    -0.098     0.200
     3.708    -2.158     0.200
     4.049    -1.855     0.200
     4.648    -1.460     0.200
     2.592    -0.151     0.200
     2.592    -0.651     0.200
     3.002    -0.559     0.200
     3.217    -1.446     0.200
     3.780    -2.608     0.200
     3.986    -1.846     0.200
     4.752    -1.817     0.200
     5.265    -4.584     0.200
     5.987    -2.979     0.200
     8.181    -3.428     0.200
     8.712    -4.447     0.200
    11.798    -9.982     0.200
     2.567    -0.871     0.200
     3.501    -3.297     0.200
     3.541    -2.053     0.200
     4.673    -3.551     0.200
     5.079    -2.510     0.200
     5.603    -3.117     0.200
     8.393    -2.866     0.200
     8.618    -4.893     0.200
     9.019    -5.201     0.200
    11.084    -8.681     0.200
     2.841    -2.092     0.200
     3.393    -1.318     0.200
     3.688    -1.961     0.200
     3.886    -0.830     0.200
     4.094    -2.326     0.200
     4.543    -2.072     0.200
     4.629    -1.702     0.200
     5.002    -1.399     0.200
     5.481    -1.302     0.200
     6.285    -2.569     0.200
     6.454    -2.652     0.200
     6.975    -3.946     0.200
     6.980    -4.802     0.200
     7.180    -3.562     0.200
     7.357    -4.051     0.200
     7.675    -3.437     0.200
     2.540     0.156     0.200
     3.059     0.102     0.200
     3.390    -0.775     0.200
     3.745    -0.223     0.200
     3.916    -2.139     0.200
     4.279    -1.748     0.200
     4.276    -3.263     0.200
     4.330    -2.070     0.200
     4.888    -0.480     0.200
     4.970    -1.055     0.200
     5.808    -1.733     0.200
     6.173    -2.107     0.200
     6.433    -2.044     0.200
     7.210    -4.771     0.200
     7.282    -4.145     0.200
     7.315    -1.413     0.200
     7.322    -3.232     0.200
     7.509    -3.553     0.200
     7.560    -2.755     0.200
     7.623    -6.377     0.200
     7.696    -5.672     0.200
     8.168    -3.839     0.200
     8.559    -4.830     0.200
     8.807    -6.191     0.200
     9.264    -5.682     0.200
     9.751    -7.129     0.200
    10.257    -6.779     0.200
    10.573    -4.185     0.200
    10.634    -6.327     0.200
    10.823    -7.795     0.200
    12.907    -9.565     0.200
     2.570    -0.125     0.200
     2.570    -0.922     0.200
     2.622    -0.766     0.200
     2.830    -1.059     0.200
     2.830    -1.364     0.200
     3.719    -1.949     0.200
     3.769    -2.930     0.200
     3.613    -0.279     0.200
     3.978    -0.859     0.200
     3.959    -1.151     0.200
     3.959    -2.846     0.200
     4.365    -1.227     0.200
     4.365    -1.625     0.200
     4.891    -2.497     0.200
     6.795    -2.846     0.200
     7.067    -2.760     0.200
     7.901   -10.167     0.200
     7.874    -1.346     0.200
     7.909    -2.659     0.200
     8.143    -3.785     0.200
     8.193    -3.971     0.200
     8.331    -2.537     0.200
     8.798    -3.634     0.200
     9.188    -4.915     0.200
     9.435    -5.641     0.200
     9.890    -6.349     0.200
    10.369    -6.254     0.200
    10.890    -4.976     0.200
    11.248    -5.719     0.200
    11.416    -7.249     0.200
    11.460    -3.843     0.200
    14.856   -10.093     0.200
     2.576    -0.372     0.200
     2.610    -0.839     0.200
     2.610     0.560     0.200
     3.600    -0.750     0.200
     3.732    -1.912     0.200
     3.782    -3.997     0.200
     3.981    -1.401     0.200
     3.946    -0.820     0.200
     4.354    -1.332     0.200
     4.878    -1.766     0.200
     5.593    -2.807     0.200
     6.430    -2.933     0.200
     6.783    -3.350     0.200
     7.056    -2.391     0.200
     7.835    -3.082     0.200
     7.868    -1.743     0.200
     7.898    -2.273     0.200
     8.182    -4.205     0.200
     8.245    -4.879     0.200
     8.320    -2.783     0.200
     8.787    -3.754     0.200
     9.177    -6.126     0.200
    10.357    -7.050     0.200
    11.236    -6.808     0.200
    11.404    -6.536     0.200
    13.645    -8.762     0.200
    14.843   -10.156     0.200
     2.738    -0.749     0.200
     2.805    -1.297     0.200
     2.940    -2.878     0.200
     3.580    -2.261     0.200
     3.633    -3.228     0.200
     3.763    -1.242     0.200
     4.078    -1.829     0.200
     4.341    -1.968     0.200
     4.489    -4.373     0.200
     4.549    -3.277     0.200
     5.021    -2.219     0.200
     5.486    -2.883     0.200
     6.333    -3.219     0.200
     6.752    -4.612     0.200
     7.442    -4.477     0.200
     7.528    -3.800     0.200
     7.834    -4.414     0.200
     8.169    -4.240     0.200
     2.614    -0.381     0.200
     2.955    -2.184     0.200
     3.060    -2.397     0.200
     3.416    -1.610     0.200
     3.624    -2.100     0.200
     4.407    -4.323     0.200
     4.399    -2.943     0.200
     4.749    -2.762     0.200
     5.162    -2.334     0.200
     5.678    -4.185     0.200
     6.387    -3.280     0.200
     7.591    -3.844     0.200
     8.476    -4.009     0.200
     8.702    -5.758     0.200
     9.105    -5.941     0.200
     3.414    -0.289     0.200
     3.732    -1.381     0.200
     3.924    -2.356     0.200
     4.021    -0.540     0.200
     4.282    -1.927     0.200
     4.675    -2.066     0.200
     4.907    -1.413     0.200
     5.195    -2.260     0.200
     5.520    -2.360     0.200
     6.040    -2.835     0.200
     6.440    -3.033     0.200
     6.655    -2.444     0.200
     7.068    -3.014     0.200
     7.237    -2.974     0.200
     7.313    -2.609     0.200
     7.406    -3.228     0.200
     7.532    -4.646     0.200
     7.728    -4.849     0.200
     7.780    -3.809     0.200
     7.853    -3.609     0.200
     7.897    -3.997     0.200
     8.408    -4.796     0.200
     8.801    -4.068     0.200
     9.053    -5.143     0.200
     9.516    -5.433     0.200
    10.951    -4.687     0.200
     2.616    -0.199     0.200
     2.728    -2.447     0.200
     2.731    -0.449     0.200
     3.634    -1.490     0.200
     3.699    -2.453     0.200
     3.960    -1.915     0.200
     4.272    -1.098     0.200
     4.323    -1.923     0.200
     4.901    -3.258     0.200
     5.141    -1.750     0.200
     5.453    -2.241     0.200
     6.297    -2.899     0.200
     7.540    -3.403     0.200
     7.664    -4.143     0.200
     2.788    -2.373     0.200
     2.920    -1.171     0.200
     3.095    -1.824     0.200
     3.920    -0.979     0.200
     4.266    -4.043     0.200
     4.635    -2.151     0.200
     5.197    -2.742     0.200
     5.214    -3.981     0.200
     5.847    -2.663     0.200
     6.689    -3.433     0.200
     7.063    -2.612     0.200
     8.073    -4.416     0.200
     8.562    -3.418     0.200
     2.920    -0.494     0.200
     3.091    -1.201     0.200
     3.922    -2.745     0.200
     4.284    -3.034     0.200
     4.262    -1.529     0.200
     4.631    -1.835     0.200
     5.198    -2.198     0.200
     5.560    -1.466     0.200
     5.840    -2.058     0.200
     6.682    -2.042     0.200
     7.059    -3.487     0.200
     7.303    -3.719     0.200
     8.064    -2.258     0.200
     8.163    -3.295     0.200
     8.554    -3.769     0.200
     2.726    -2.768     0.200
     2.787    -0.105     0.200
     2.949    -1.531     0.200
     3.536    -1.341     0.200
     3.558    -3.334     0.200
     3.793    -1.189     0.200
     4.131    -1.383     0.200
     4.248    -3.098     0.200
     4.490    -2.579     0.200
     5.068    -1.700     0.200
     5.427    -1.592     0.200
     5.696    -2.116     0.200
     6.538    -2.801     0.200
     6.917    -3.811     0.200
     7.827    -3.159     0.200
     7.920    -3.203     0.200
     8.020    -4.086     0.200
     8.233    -4.728     0.200
     8.409    -4.413     0.200
     9.544    -4.688     0.200
    10.003    -6.757     0.200
    10.497    -7.292     0.200
    10.984    -5.736     0.200
    11.571    -6.744     0.200
     3.149    -1.363     0.200
     3.473    -1.434     0.200
     3.796    -0.878     0.200
     4.052    -2.805     0.200
     4.185    -2.204     0.200
     4.204    -2.295     0.200
     4.415    -1.584     0.200
     4.843    -1.778     0.200
     5.000    -2.247     0.200
     5.841    -2.414     0.200
     6.222    -2.964     0.200
     7.229    -3.308     0.200
     7.265    -3.144     0.200
     7.323    -4.186     0.200
     7.538    -3.485     0.200
     7.717    -4.078     0.200
     8.847    -5.082     0.200
     9.307    -4.658     0.200
    10.288    -5.376     0.200
    10.828    -1.846     0.200
     3.619    -1.714     0.200
     3.964    -2.136     0.200
     4.047    -3.262     0.200
     4.050    -3.369     0.200
     4.047    -2.670     0.200
     4.559    -2.013     0.200
     2.712    -2.223     0.200
     2.937    -0.673     0.200
     3.550    -2.494     0.200
     3.572    -3.711     0.200
     4.117    -2.271     0.200
     4.478    -2.618     0.200
     2.739    -2.458     0.200
     2.955    -0.612     0.200
     3.527    -3.534     0.200
     3.547    -3.879     0.200
     4.139    -0.743     0.200
     4.496    -1.464     0.200
     2.534    -1.228     0.200
     2.669    -1.548     0.200
     2.767    -0.819     0.200
     3.192     0.322     0.200
     4.679    -3.828     0.200
     3.464    -0.796     0.200
     4.050    -2.070     0.200
     4.194    -2.143     0.200
     2.598    -0.073     0.200
     2.701    -0.515     0.200
     2.749    -2.341     0.200
     3.715    -2.162     0.200
     3.742    -0.937     0.200
     3.942    -1.762     0.200
     4.357    -1.909     0.200
     4.884    -3.028     0.200
     2.599    -0.640     0.200
     2.739    -1.982     0.200
     2.705    -0.704     0.200
     3.714    -2.280     0.200
     3.739    -2.273     0.200
     3.943    -1.837     0.200
     4.246    -0.837     0.200
     4.344    -3.463     0.200
     4.885    -2.496     0.200
     5.099    -0.465     0.200
     5.422    -2.513     0.200
     6.266    -3.086     0.200
     6.666    -2.758     0.200
     6.882    -4.095     0.200
     7.497    -2.898     0.200
     7.631    -3.131     0.200
     7.759    -3.594     0.200
     8.634    -3.951     0.200
     2.566     0.045     0.200
     3.584    -1.329     0.200
     3.899    -2.802     0.200
     3.968    -0.599     0.200
     4.083    -3.265     0.200
     4.103    -2.781     0.200
     4.520    -1.822     0.200
     5.203    -1.751     0.200
     3.135    -0.962     0.200
     3.461    -1.415     0.200
     3.796    -1.915     0.200
     4.011    -2.745     0.200
     4.199    -3.987     0.200
     4.211    -4.185     0.200
     4.403    -3.544     0.200
     4.872    -2.013     0.200
     5.007    -3.701     0.200
     5.847    -3.442     0.200
     6.470    -3.677     0.200
     7.239    -3.476     0.200
     7.295    -3.023     0.200
    10.688    -5.991     0.200
     2.674    -0.239     0.200
     2.674    -0.137     0.200
     2.733    -3.004     0.200
     3.055    -0.599     0.200
     3.284    -2.248     0.200
     3.284    -1.549     0.200
     3.326    -3.205     0.200
     4.031    -1.645     0.200
     4.115    -3.213     0.200
     4.384    -2.933     0.200
     4.816    -1.530     0.200
     5.310    -3.289     0.200
     5.874    -2.359     0.200
     6.060    -1.562     0.200
     6.060    -3.360     0.200
     6.897    -3.782     0.200
     7.246    -3.048     0.200
     7.523    -4.550     0.200
     7.784    -2.904     0.200
     8.277    -4.842     0.200
     8.302    -4.530     0.200
     8.362    -5.550     0.200
     8.600    -5.371     0.200
     8.650    -5.262     0.200
     8.712    -4.820     0.200
     8.788    -4.934     0.200
     9.253    -4.570     0.200
     9.643    -5.633     0.200
     9.889    -7.143     0.200
    10.343    -7.234     0.200
    10.818    -7.673     0.200
    11.347    -6.557     0.200
    11.630    -6.732     0.200
    11.905    -1.572     0.200
    17.645   -11.423     0.200
     2.667     0.679     0.200
     2.908    -0.239     0.200
     2.974    -1.249     0.200
     3.296    -0.344     0.200
     3.869    -1.827     0.200
     3.917    -1.128     0.200
     4.518    -1.596     0.200
     4.524    -1.765     0.200
     4.708    -2.113     0.200
     5.356    -2.258     0.200
     5.723    -2.493     0.200
     5.982    -3.084     0.200
     6.958    -3.034     0.200
     7.058    -3.000     0.200
     7.246    -3.180     0.200
     7.716    -3.557     0.200
     8.107    -4.456     0.200
     8.355    -5.622     0.200
     9.302    -5.458     0.200
     2.705    -0.977     0.200
     2.705    -1.877     0.200
     2.785    -1.728     0.200
     2.785    -2.328     0.200
     2.959    -1.145     0.200
     2.959    -1.345     0.200
     3.673    -0.964     0.200
     3.673    -0.664     0.200
     3.690    -4.615     0.200
     4.028    -1.732     0.200
     4.484    -2.070     0.200
     4.484    -2.770     0.200
     4.952    -3.701     0.200
     5.679    -1.759     0.200
     5.747    -2.728     0.200
     6.580    -3.312     0.200
     6.912    -3.249     0.200
     7.210    -2.797     0.200
     7.777    -4.350     0.200
     8.035    -4.542     0.200
     8.098    -3.841     0.200
     8.287    -4.038     0.200
     8.336    -4.195     0.200
     8.484    -4.383     0.200
     9.318    -4.811     0.200
     9.562    -6.064     0.200
    10.013    -6.056     0.200
    10.479    -7.814     0.200
    11.031    -6.103     0.200
    11.269    -5.721     0.200
    11.352    -6.888     0.200
    11.651    -2.147     0.200
    17.950    -9.990     0.200
    18.248    -8.187     0.200
     3.544    -0.949     0.200
     3.726    -2.230     0.200
     4.536    -1.999     0.200
     4.882    -3.268     0.200
     5.267    -2.758     0.200
     2.515    -0.450     0.200
     2.623    -0.349     0.200
     2.677    -2.063     0.200
     3.798    -1.107     0.200
     3.823    -1.299     0.200
     3.859    -1.947     0.200
     4.163    -0.391     0.200
     4.296    -1.502     0.200
     5.044    -1.521     0.200
     5.343    -2.282     0.200
     6.187    -3.341     0.200
     7.384    -3.890     0.200
     7.447    -3.494     0.200
     7.678    -4.007     0.200
     8.555    -5.091     0.200
    10.167    -6.499     0.200
    11.056    -7.297     0.200
    11.268    -6.610     0.200
     2.509    -0.946     0.200
     2.612    -0.325     0.200
     3.530    -1.322     0.200
     3.832    -0.608     0.200
     3.852    -2.335     0.200
     4.152    -1.556     0.200
     4.305    -3.306     0.200
     5.027     0.029     0.200
     5.330    -1.576     0.200
     6.174    -1.943     0.200
     6.573    -2.980     0.200
     6.790    -2.768     0.200
     7.429    -3.538     0.200
     7.666    -3.431     0.200
     8.935    -3.871     0.200
     2.880    -2.408     0.200
     3.510    -1.267     0.200
     3.674    -0.771     0.200
     4.509    -2.342     0.200
     4.851    -2.984     0.200
     5.215    -1.531     0.200
     2.547    -1.306     0.200
     2.770    -1.684     0.200
     3.823    -1.468     0.200
     3.837    -1.399     0.200
     3.891    -1.422     0.200
     4.083    -1.694     0.200
     4.423    -2.489     0.200
     4.871    -0.974     0.200
     5.235    -1.709     0.200
     2.546    -0.520     0.200
     2.783    -1.747     0.200
     2.783    -1.247     0.200
     3.515     0.163     0.200
     3.515    -0.435     0.200
     3.836    -2.315     0.200
     3.893    -2.727     0.200
     3.893    -3.028     0.200
     3.826    -1.293     0.200
     3.826    -2.394     0.200
     4.081    -0.283     0.200
     4.081    -2.584     0.200
     4.438    -2.117     0.200
     4.858    -0.821     0.200
     8.447   -10.537     0.200
     8.446    -2.856     0.200
     8.840    -5.362     0.200
     8.931    -4.436     0.200
     9.093    -3.883     0.200
     9.559    -4.759     0.200
    10.076    -6.423     0.200
    10.510    -5.282     0.200
    10.808    -3.910     0.200
    10.933    -1.571     0.200
    10.970    -6.661     0.200
    11.201    -8.294     0.200
    14.874    -2.581     0.200
    17.677    -8.629     0.200
    18.543    -8.825     0.200
    19.041    -3.187     0.200
    19.820    -2.003     0.200
     2.545    -0.924     0.200
     2.545    -0.623     0.200
     2.788    -1.731     0.200
     3.516    -1.099     0.200
     3.516     0.002     0.200
     3.836    -2.442     0.200
     3.826    -1.143     0.200
     3.826    -2.342     0.200
     3.894    -2.888     0.200
     3.894    -2.989     0.200
     4.080    -1.576     0.200
     4.080    -1.877     0.200
     4.444    -1.624     0.200
     4.853    -1.188     0.200
     4.853    -1.387     0.200
     5.227    -2.662     0.200
     6.491    -3.320     0.200
     6.684    -2.749     0.200
     7.249    -3.756     0.200
     7.269    -3.383     0.200
     7.422    -4.129     0.200
     7.574    -5.046     0.200
     7.754    -4.068     0.200
     7.808    -3.759     0.200
     8.133    -3.680     0.200
     8.444    -4.520     0.200
     8.452   -11.163     0.200
     8.838    -4.527     0.200
     9.091    -3.851     0.200
     9.557    -5.527     0.200
    10.074    -6.509     0.200
    10.507    -6.133     0.200
    10.968    -7.447     0.200
    11.200    -6.402     0.200
     2.544    -1.167     0.200
     2.769    -1.804     0.200
     3.821    -1.635     0.200
     3.839    -1.536     0.200
     4.080    -1.452     0.200
     4.423    -2.526     0.200
     5.232    -2.266     0.200
     2.541    -0.587     0.200
     2.772    -1.631     0.200
     3.507    -1.625     0.200
     3.819    -1.800     0.200
     3.842    -1.632     0.200
     4.076    -1.859     0.200
     5.227    -2.439     0.200
     2.500     0.332     0.200
     2.563    -0.856     0.200
     2.779    -1.705     0.200
     3.526    -0.794     0.200
     3.821    -1.551     0.200
     3.838    -1.898     0.200
     4.099    -2.144     0.200
     4.429    -2.416     0.200
     4.883    -2.118     0.200
     5.250    -2.254     0.200
     2.552    -0.372     0.200
     2.779    -1.560     0.200
     3.830    -1.873     0.200
     3.831    -1.612     0.200
     3.886    -1.672     0.200
     4.087    -1.946     0.200
     4.432    -2.658     0.200
     4.870    -1.848     0.200
     5.238    -2.421     0.200
     6.695    -3.918     0.200
     2.503    -0.401     0.200
     2.564    -0.946     0.200
     2.784    -1.730     0.200
     3.819    -1.540     0.200
     3.841    -2.120     0.200
     3.874    -1.488     0.200
     4.099    -1.921     0.200
     4.435    -2.761     0.200
     4.880    -1.367     0.200
     5.250    -2.899     0.200
     6.707    -3.392     0.200
     2.560    -0.472     0.200
     2.785    -1.498     0.200
     3.823    -1.493     0.200
     3.838    -1.477     0.200
     4.095    -1.645     0.200
     4.437    -2.558     0.200
     5.246    -2.407     0.200
     6.508    -3.415     0.200
     6.703    -3.800     0.200
     7.271    -3.118     0.200
     2.553    -0.319     0.200
     2.786    -1.284     0.200
     3.521    -1.105     0.200
     3.833    -2.471     0.200
     3.885    -2.929     0.200
     4.089    -1.586     0.200
     4.439    -2.100     0.200
     4.866    -2.215     0.200
     5.238    -1.916     0.200
     6.501    -3.545     0.200
     6.695    -3.208     0.200
     7.262    -3.987     0.200
     7.280    -3.841     0.200
     7.584    -4.287     0.200
     8.454    -4.168     0.200
     8.849    -4.576     0.200
     9.102    -5.796     0.200
    10.084    -6.332     0.200
    10.518    -7.096     0.200
     2.542    -1.121     0.200
     2.772    -1.413     0.200
     3.508    -1.645     0.200
     3.820    -1.226     0.200
     3.841    -1.187     0.200
     3.896    -1.649     0.200
     4.078    -1.094     0.200
     4.427    -2.261     0.200
     4.863    -1.493     0.200
     6.490    -2.976     0.200
     6.686    -2.583     0.200
     7.261    -3.200     0.200
     7.425    -3.704     0.200
     7.574    -3.338     0.200
     8.839    -4.528     0.200
    10.073    -6.158     0.200
    10.509    -5.073     0.200
    10.967    -7.087     0.200
    11.197    -6.586     0.200
     2.546    -0.889     0.200
     2.546    -0.089     0.200
     2.781    -2.219     0.200
     2.781    -1.719     0.200
     3.514    -0.274     0.200
     3.835    -2.552     0.200
     3.892    -1.249     0.200
     3.892    -3.049     0.200
     3.825    -1.838     0.200
     4.082    -1.255     0.200
     4.082    -0.855     0.200
     4.435    -2.271     0.200
     4.861    -2.262     0.200
     5.231    -2.296     0.200
     7.577    -2.863     0.200
     8.445   -10.645     0.200
     8.447    -4.346     0.200
     9.095    -4.571     0.200
     9.561    -5.244     0.200
    10.077    -4.904     0.200
    10.511    -6.078     0.200
    10.971    -7.038     0.200
    10.935    -0.237     0.200
    14.877    -2.389     0.200
     2.554    -0.592     0.200
     2.785    -1.813     0.200
     3.828    -1.475     0.200
     3.884    -1.566     0.200
     4.089    -1.559     0.200
     2.552    -0.348     0.200
     2.788    -1.627     0.200
     3.521    -0.367     0.200
     3.829    -2.030     0.200
     3.832    -1.725     0.200
     3.886    -2.249     0.200
     4.087    -1.207     0.200
     4.442    -2.764     0.200
     4.862    -1.369     0.200
     5.236    -2.519     0.200
     6.693    -3.606     0.200
     7.431    -3.796     0.200
     7.582    -3.796     0.200
     8.452    -4.573     0.200
     9.099    -5.100     0.200
     2.550    -0.779     0.200
     2.794    -1.324     0.200
     3.521    -0.878     0.200
     3.521    -0.079     0.200
     3.830    -2.480     0.200
     3.889    -2.847     0.200
     3.832    -1.319     0.200
     4.084    -1.326     0.200
     4.084    -1.926     0.200
     4.449    -1.908     0.200
     4.854    -1.014     0.200
     5.231    -3.086     0.200
     5.231    -3.187     0.200
     7.425    -4.336     0.200
     8.451   -10.524     0.200
     8.448    -3.346     0.200
     8.842    -5.154     0.200
     9.095    -5.477     0.200
     9.561    -6.959     0.200
    10.079    -6.247     0.200
    10.973    -8.391     0.200
    11.205    -6.058     0.200
     2.558    -1.402     0.200
     2.781    -1.564     0.200
     3.523    -1.399     0.200
     3.825    -2.459     0.200
     3.835    -1.786     0.200
     3.880    -2.307     0.200
     4.094    -1.780     0.200
     4.433    -2.323     0.200
     4.876    -0.968     0.200
     5.245    -2.361     0.200
     6.506    -3.356     0.200
     6.702    -3.058     0.200
     7.273    -4.148     0.200
     7.441    -4.376     0.200
     7.590    -3.916     0.200
     8.461    -4.607     0.200
     9.108    -5.329     0.200
     2.540    -0.560     0.200
     2.755    -1.181     0.200
     3.813    -1.833     0.200
     4.076    -1.958     0.200
     4.408    -2.678     0.200
     4.875    -1.780     0.200
     5.230    -2.552     0.200
     6.688    -3.662     0.200
     7.274    -4.219     0.200
     2.548    -0.355     0.200
     2.786    -1.890     0.200
     3.828    -1.537     0.200
     4.083    -1.014     0.200
     4.441    -3.350     0.200
     2.551    -0.108     0.200
     2.787    -1.374     0.200
     3.520    -1.923     0.200
     3.831    -1.580     0.200
     3.887    -1.444     0.200
     4.087    -1.566     0.200
     4.441    -2.617     0.200
     4.774    -2.871     0.200
     4.862    -0.544     0.200
     5.235    -1.786     0.200
     6.498    -3.121     0.200
     6.692    -3.873     0.200
     7.258    -3.217     0.200
     7.430    -3.561     0.200
     7.581    -5.060     0.200
     7.816    -3.885     0.200
    10.515    -6.560     0.200
    10.975    -6.342     0.200
    11.207    -6.379     0.200
     2.502    -0.569     0.200
     2.638    -1.778     0.200
     2.638    -1.477     0.200
     3.432    -0.846     0.200
     3.432     0.353     0.200
     3.751    -1.561     0.200
     4.042    -0.983     0.200
     4.042    -2.085     0.200
     3.939    -2.514     0.200
     4.285    -3.290     0.200
     4.693    -1.599     0.200
     4.926    -0.406     0.200
     5.217    -1.723     0.200
     6.062    -2.394     0.200
     6.446    -2.381     0.200
     6.462    -3.878     0.200
     6.542    -3.830     0.200
     6.677    -2.611     0.200
     7.333    -2.882     0.200
     7.428    -4.494     0.200
     7.554    -4.400     0.200
     7.750    -4.309     0.200
     7.802    -3.972     0.200
     7.919    -3.861     0.200
     8.429    -3.854     0.200
     8.397    -8.541     0.200
     8.823    -5.228     0.200
     9.074    -5.903     0.200
     9.538    -5.289     0.200
    10.045    -7.156     0.200
    10.972    -2.449     0.200
    18.947    -3.487     0.200
     2.556    -1.254     0.200
     2.556    -2.117     0.200
     2.556    -1.457     0.200
     2.537    -0.355     0.200
     2.507     0.924     0.200
     3.080    -0.071     0.200
     3.494    -1.988     0.200
     3.961    -1.792     0.200
     4.789    -3.597     0.200
     4.780    -1.856     0.200
     5.126    -2.109     0.200
     5.503    -1.946     0.200
     5.840    -6.347     0.200
     6.058    -2.453     0.200
     6.867    -7.538     0.200
     6.699    -3.460     0.200
     7.024    -8.715     0.200
     7.542    -2.707     0.200
     7.674    -3.371     0.200
     7.929    -3.765     0.200
     7.927    -3.217     0.200
     8.017    -3.965     0.200
     8.159    -4.064     0.200
     8.620    -4.770     0.200
     8.908    -4.488     0.200
     9.030    -4.255     0.200
     9.232    -3.968     0.200
     9.356    -5.302     0.200
     9.399    -4.478     0.200
     9.909    -4.926     0.200
    10.302    -6.381     0.200
    10.552    -6.121     0.200
    11.013    -6.834     0.200
     2.500     0.309     0.200
     2.681    -0.738     0.200
     3.494    -1.309     0.200
     3.834    -2.284     0.200
     3.835    -1.408     0.200
     4.009    -2.746     0.200
     4.219    -1.092     0.200
     4.770    -2.540     0.200
     5.294    -0.980     0.200
     5.448    -2.037     0.200
     6.648    -4.395     0.200
     6.674    -2.821     0.200
     6.746    -3.196     0.200
     6.911    -3.724     0.200
     7.686    -4.079     0.200
     7.710    -4.555     0.200
     7.987    -4.031     0.200
     8.101    -4.360     0.200
     8.172    -4.704     0.200
     9.037    -4.804     0.200
     9.284    -5.757     0.200
    10.225    -6.173     0.200
     3.095    -0.489     0.200
     3.417    -1.281     0.200
     3.732    -1.277     0.200
     4.054    -2.561     0.200
     4.263    -3.008     0.200
     4.358    -1.809     0.200
     4.782    -1.041     0.200
     4.934    -2.062     0.200
     5.775    -3.335     0.200
     6.157    -2.642     0.200
     6.162    -2.193     0.200
     6.245    -2.640     0.200
     6.396    -2.823     0.200
     7.162    -3.303     0.200
     7.205    -3.947     0.200
     7.258    -4.835     0.200
     7.471    -3.495     0.200
     7.650    -3.976     0.200
     8.781    -4.525     0.200
     9.241    -4.210     0.200
     2.528    -2.569     0.200
     2.571    -0.542     0.200
     2.705    -0.599     0.200
     2.915    -1.150     0.200
     3.639    -3.296     0.200
     3.695    -1.058     0.200
     4.022    -1.722     0.200
     4.042    -2.155     0.200
     4.451    -1.317     0.200
     5.688    -2.548     0.200
     6.525    -2.892     0.200
     6.880    -4.135     0.200
     6.914    -3.609     0.200
     6.982    -4.447     0.200
     7.152    -3.738     0.200
     7.929    -3.785     0.200
     7.942    -3.690     0.200
     7.994    -3.749     0.200
     8.415    -4.192     0.200
    10.454    -6.138     0.200
    11.333    -8.196     0.200
    11.500    -7.496     0.200
     2.953    -2.387     0.200
     2.981    -1.472     0.200
     3.474    -1.690     0.200
     3.740    -1.035     0.200
     4.165    -4.097     0.200
     4.785    -1.865     0.200
     5.264    -1.826     0.200
     5.699    -2.138     0.200
     6.527    -3.178     0.200
     7.691    -3.681     0.200
     7.750    -3.547     0.200
     8.760    -3.068     0.200
     8.777    -4.208     0.200
     8.815    -3.620     0.200
     2.604    -2.902     0.200
     2.679    -1.450     0.200
     3.057    -0.540     0.200
     3.057    -0.330     0.200
     3.380    -1.970     0.200
     3.406    -1.210     0.200
     3.925    -1.964     0.200
     4.178    -2.272     0.200
     4.505    -2.833     0.200
     6.696    -2.908     0.200
     6.957    -3.679     0.200
     7.793    -3.284     0.200
     8.135    -4.830     0.200
     8.420    -3.267     0.200
     9.075    -3.221     0.200
     9.198    -5.525     0.200
     9.685    -4.643     0.200
     3.466    -1.088     0.200
     3.788    -0.899     0.200
     4.211    -3.888     0.200
     4.407    -2.005     0.200
     4.836    -1.796     0.200
     4.992    -2.154     0.200
     5.833    -2.423     0.200
     6.214    -2.282     0.200
     6.220    -2.483     0.200
     6.455    -2.619     0.200
     7.221    -2.913     0.200
     7.257    -2.367     0.200
     7.315    -3.099     0.200
     7.709    -4.083     0.200
     8.197    -3.854     0.200
     9.795    -5.495     0.200
    10.681    -6.997     0.200
    10.883    -6.287     0.200
     2.793    -2.204     0.200
     2.846    -0.181     0.200
     3.000    -0.444     0.200
     3.000    -1.444     0.200
     3.477    -1.574     0.200
     3.477    -3.277     0.200
     3.853    -1.113     0.200
     4.190    -2.074     0.200
     4.190    -2.277     0.200
     4.310    -2.481     0.200
     4.310    -3.083     0.200
     4.541    -2.609     0.200
     5.127    -1.985     0.200
     5.442    -1.783     0.200
     5.740    -2.727     0.200
     6.583    -4.141     0.200
     6.967    -4.009     0.200
     7.838    -2.617     0.200
     7.960    -4.679     0.200
     8.450    -4.110     0.200
     2.768    -2.361     0.200
     4.382    -3.645     0.200
     5.833    -6.525     0.200
     6.113    -6.656     0.200
     6.623    -8.069     0.200
     6.770    -7.899     0.200
     2.840    -1.507     0.200
     2.840    -1.608     0.200
     3.868    -2.318     0.200
     3.868    -2.216     0.200
     3.569    -1.429     0.200
     3.661    -2.832     0.200
     3.617    -2.648     0.200
     3.617    -1.750     0.200
     4.595    -2.533     0.200
     4.908    -3.383     0.200
     5.159    -3.512     0.200
     5.270    -1.241     0.200
     6.336    -6.156     0.200
     7.753   -11.148     0.200
     8.394    -3.363     0.200
     8.606    -4.294     0.200
     8.752    -5.434     0.200
     8.808    -3.996     0.200
     8.894    -3.925     0.200
     8.891    -4.826     0.200
     9.277    -5.568     0.200
     9.463    -6.355     0.200
     9.859    -6.821     0.200
     9.968    -7.674     0.200
    10.587    -7.293     0.200
    11.121    -6.635     0.200
    11.452    -7.116     0.200
    11.503    -9.013     0.200
    11.757    -6.453     0.200
    12.021    -7.646     0.200
    12.272    -9.324     0.200
    16.683   -12.770     0.200
    19.447    -4.946     0.200
    20.110    -3.443     0.200
     2.530    -0.531     0.200
     2.714    -0.658     0.200
     2.714    -0.158     0.200
     3.531    -1.253     0.200
     3.797    -3.671     0.200
     3.797    -1.569     0.200
     3.872    -2.651     0.200
     3.872    -1.557     0.200
     4.039    -2.362     0.200
     4.253    -1.829     0.200
     4.253    -1.329     0.200
     5.310    -1.648     0.200
     5.478    -1.884     0.200
     6.317    -2.980     0.200
     6.682    -2.722     0.200
     6.705    -4.175     0.200
     6.779    -3.099     0.200
     6.942    -3.065     0.200
     7.171    -2.722     0.200
     7.458    -3.328     0.200
     7.515    -3.356     0.200
     7.715    -4.371     0.200
     7.724    -3.361     0.200
     7.791    -4.397     0.200
     8.017    -3.769     0.200
     8.068    -3.775     0.200
     8.133    -5.023     0.200
     8.534    -4.652     0.200
     9.069    -4.991     0.200
     9.132    -4.592     0.200
     9.317    -6.351     0.200
     9.774    -6.438     0.200
    10.259    -6.422     0.200
    10.766    -6.615     0.200
    11.044    -6.015     0.200
    11.140    -7.973     0.200
    11.320    -7.954     0.200
     2.585     0.320     0.200
     2.585    -0.383     0.200
     3.273    -2.997     0.200
     3.087    -1.610     0.200
     3.087    -0.910     0.200
     3.299    -1.017     0.200
     4.421    -2.988     0.200
     4.835    -3.210     0.200
     6.906    -3.062     0.200
     7.294    -4.263     0.200
     7.412    -4.029     0.200
     7.531    -4.564     0.200
     7.701    -3.762     0.200
     8.104    -4.636     0.200
     8.236    -4.236     0.200
     8.377    -5.004     0.200
     8.607    -4.566     0.200
     8.657    -4.575     0.200
     9.265    -5.442     0.200
     9.656    -5.231     0.200
     9.715    -6.120     0.200
     9.903    -6.272     0.200
    10.359    -6.221     0.200
    10.839    -8.240     0.200
    11.609    -7.244     0.200
    11.718    -8.401     0.200
    11.883    -8.730     0.200
    11.886    -4.695     0.200
    15.346   -10.203     0.200
    15.175    -7.172     0.200
    16.871   -14.616     0.200
    17.644   -11.556     0.200
    18.552    -9.540     0.200
     2.656    -0.687     0.200
     2.667     0.679     0.200
     2.909    -0.797     0.200
     2.973    -0.634     0.200
     3.294    -0.311     0.200
     3.914    -1.073     0.200
     4.516    -2.055     0.200
     4.521    -1.313     0.200
     5.354    -2.119     0.200
     5.721    -3.057     0.200
     5.815    -2.239     0.200
     3.087    -1.546     0.200
     3.400    -0.366     0.200
     3.683    -0.137     0.200
     4.147    -1.248     0.200
     4.299    -0.967     0.200
     4.669    -0.895     0.200
     4.866    -1.133     0.200
     7.090    -3.230     0.200
     2.607    -2.374     0.200
     2.607    -2.077     0.200
     2.698    -0.036     0.200
     2.698    -0.138     0.200
     2.878    -0.759     0.200
     3.630    -2.001     0.200
     3.697    -0.436     0.200
     4.039    -1.760     0.200
     4.131    -2.387     0.200
     4.417    -1.861     0.200
     4.974    -2.391     0.200
     5.425    -0.982     0.200
     5.637    -2.230     0.200
     6.477    -2.458     0.200
     6.846    -3.446     0.200
     6.865    -3.343     0.200
     6.941    -2.966     0.200
     7.100    -3.107     0.200
     7.180    -1.602     0.200
     7.675    -4.241     0.200
     7.831    -3.282     0.200
     7.869    -4.579     0.200
     7.954    -4.567     0.200
     8.176    -3.399     0.200
     8.227    -4.313     0.200
     8.357    -4.246     0.200
     8.839    -5.318     0.200
     9.936    -9.596     0.200
    11.454    -5.392     0.200
    15.185    -8.587     0.200
    15.681   -10.204     0.200
    18.079   -10.120     0.200
     2.603    -2.270     0.200
     2.698    -0.584     0.200
     2.880    -0.957     0.200
     3.630    -2.128     0.200
     3.697    -1.061     0.200
     4.039    -2.098     0.200
     4.126    -1.633     0.200
     4.419    -1.750     0.200
     4.974    -2.122     0.200
     5.430    -1.794     0.200
     5.640    -2.851     0.200
     6.480    -2.872     0.200
     6.848    -3.330     0.200
     6.868    -3.360     0.200
     6.944    -3.164     0.200
     7.103    -3.526     0.200
     2.606    -2.263     0.200
     2.606    -2.365     0.200
     2.700    -0.734     0.200
     2.881    -1.292     0.200
     2.881    -0.487     0.200
     3.628    -2.081     0.200
     3.699    -1.021     0.200
     3.699    -0.623     0.200
     4.041    -1.657     0.200
     4.041    -1.953     0.200
     4.129    -2.530     0.200
     4.420    -1.688     0.200
     4.975    -2.183     0.200
     5.429    -1.768     0.200
     5.641    -2.277     0.200
     6.481    -2.300     0.200
     6.849    -4.267     0.200
     6.868    -2.983     0.200
     6.944    -3.394     0.200
     7.104    -2.951     0.200
     7.472    -2.514     0.200
     7.679    -3.575     0.200
     7.836    -2.774     0.200
     7.873    -3.635     0.200
     7.957    -4.496     0.200
     8.179    -4.245     0.200
     8.230    -3.760     0.200
     8.296    -5.138     0.200
     8.361    -4.394     0.200
     8.842    -5.156     0.200
     9.299    -5.624     0.200
     9.482    -6.235     0.200
     9.940    -4.179     0.200
    11.458    -4.594     0.200
     2.601    -2.143     0.200
     2.700    -0.392     0.200
     2.883    -2.003     0.200
     2.883    -0.706     0.200
     3.629    -2.432     0.200
     3.699    -2.649     0.200
     3.699    -0.853     0.200
     4.041    -3.197     0.200
     4.041    -1.798     0.200
     4.121    -2.249     0.200
     4.422    -1.893     0.200
     4.975    -2.215     0.200
     5.436    -0.929     0.200
     6.851    -3.077     0.200
     6.871    -3.128     0.200
     6.947    -3.615     0.200
     7.107    -3.195     0.200
     7.193    -0.014     0.200
     7.481    -2.447     0.200
     7.844    -2.843     0.200
     7.877    -4.498     0.200
     7.960    -3.717     0.200
     8.183    -4.287     0.200
     8.234    -4.004     0.200
     8.364    -4.152     0.200
     8.700    -4.592     0.200
     8.845    -4.284     0.200
    11.464    -6.103     0.200
    17.285   -10.198     0.200
    18.071    -9.445     0.200
     2.595    -2.552     0.200
     2.595    -2.256     0.200
     2.692    -0.443     0.200
     2.876    -0.955     0.200
     2.876    -0.658     0.200
     3.691    -0.507     0.200
     3.636    -3.972     0.200
     3.636    -1.574     0.200
     4.033    -2.748     0.200
     4.033    -1.951     0.200
     4.117    -2.714     0.200
     4.415    -3.140     0.200
     4.415    -1.843     0.200
     4.968    -2.267     0.200
     5.431    -1.648     0.200
     5.637    -2.179     0.200
     6.476    -2.595     0.200
     6.843    -3.332     0.200
     6.864    -3.382     0.200
     7.100    -3.660     0.200
     7.193    -1.901     0.200
     7.480    -3.716     0.200
     7.674    -2.776     0.200
     7.838    -2.971     0.200
     7.869    -4.359     0.200
     7.952    -3.271     0.200
     7.906   -10.775     0.200
     8.175    -4.151     0.200
     8.291    -4.941     0.200
     8.357    -4.020     0.200
     8.837    -4.441     0.200
     9.934    -8.773     0.200
    11.011    -7.200     0.200
    18.078    -9.144     0.200
     2.604    -2.422     0.200
     2.604    -2.321     0.200
     2.708    -1.317     0.200
     2.892    -1.359     0.200
     3.621    -3.279     0.200
     3.621    -2.979     0.200
     3.707    -2.691     0.200
     4.122    -1.845     0.200
     4.122    -2.145     0.200
     4.049    -2.020     0.200
     4.431    -2.544     0.200
     4.983    -2.536     0.200
     7.199    -2.460     0.200
     8.374    -5.022     0.200
     8.854    -5.849     0.200
     9.245    -7.354     0.200
    17.276   -12.073     0.200
    18.062   -11.557     0.200
     2.606    -2.018     0.200
     2.702     0.027     0.200
     2.884    -0.747     0.200
     3.626    -1.558     0.200
     4.043    -1.787     0.200
     4.127    -2.447     0.200
     4.424    -1.241     0.200
     4.978    -2.210     0.200
     5.644    -2.542     0.200
     6.852    -3.727     0.200
     6.872    -2.550     0.200
     6.948    -2.857     0.200
     7.475    -3.782     0.200
     7.841    -4.163     0.200
     2.576    -1.816     0.200
     2.691    -0.570     0.200
     2.881    -1.088     0.200
     3.640    -2.763     0.200
     3.688    -0.986     0.200
     4.031    -2.251     0.200
     4.093    -1.897     0.200
     4.419    -2.054     0.200
     4.965    -2.347     0.200
     5.645    -2.612     0.200
     6.848    -3.952     0.200
     6.945    -3.136     0.200
     7.860    -4.032     0.200
     2.605    -1.939     0.200
     2.711    -0.404     0.200
     2.896    -1.162     0.200
     3.618    -1.856     0.200
     3.710    -1.570     0.200
     4.052    -2.205     0.200
     4.122    -2.223     0.200
     4.435    -2.446     0.200
     4.986    -2.319     0.200
     5.449    -1.701     0.200
     5.657    -2.591     0.200
     6.864    -3.136     0.200
     6.884    -3.898     0.200
     6.960    -2.982     0.200
     7.489    -3.255     0.200
     7.856    -3.507     0.200
     2.611    -2.027     0.200
     2.701    -0.180     0.200
     2.881    -0.480     0.200
     3.627    -1.119     0.200
     3.702    -0.496     0.200
     4.042    -0.897     0.200
     4.135    -3.430     0.200
     4.420    -1.584     0.200
     5.425    -1.638     0.200
     5.640    -2.542     0.200
     6.480    -3.874     0.200
     6.849    -3.566     0.200
     6.867    -3.757     0.200
     6.944    -3.683     0.200
     7.465    -3.802     0.200
     2.594    -1.967     0.200
     2.696    -0.012     0.200
     2.881    -0.373     0.200
     3.633    -2.822     0.200
     3.695    -1.487     0.200
     4.037    -1.115     0.200
     4.114    -2.558     0.200
     4.420    -1.359     0.200
     4.971    -2.027     0.200
     5.643    -2.313     0.200
     6.482    -2.530     0.200
     6.849    -3.647     0.200
     6.870    -3.420     0.200
     6.945    -3.899     0.200
     7.487    -3.786     0.200
     2.613    -1.752     0.200
     2.716    -0.416     0.200
     2.716    -0.217     0.200
     2.899    -1.025     0.200
     3.613    -2.372     0.200
     3.613    -1.474     0.200
     3.715    -1.599     0.200
     4.130    -1.948     0.200
     4.057    -0.224     0.200
     4.057    -1.724     0.200
     4.438    -0.815     0.200
     4.438    -1.815     0.200
     4.991    -1.644     0.200
     6.499    -2.748     0.200
     6.887    -3.236     0.200
     6.962    -3.036     0.200
     7.195    -2.135     0.200
     7.697    -3.226     0.200
     7.854    -2.608     0.200
     7.891    -4.390     0.200
     8.249    -4.813     0.200
     8.314    -4.192     0.200
     8.379    -4.754     0.200
     8.860    -5.803     0.200
    15.189    -4.364     0.200
     2.609    -2.324     0.200
     2.711    -0.562     0.200
     2.894    -0.976     0.200
     3.618    -1.430     0.200
     3.710    -1.545     0.200
     4.052    -2.369     0.200
     4.127    -2.055     0.200
     4.433    -1.964     0.200
     4.986    -1.688     0.200
     5.444    -0.715     0.200
     5.655    -1.582     0.200
     6.494    -3.704     0.200
     6.862    -3.753     0.200
     6.882    -2.790     0.200
     6.958    -4.590     0.200
     7.118    -3.062     0.200
     7.851    -3.115     0.200
     2.604    -2.042     0.200
     2.702    -0.368     0.200
     2.885    -1.168     0.200
     3.626    -2.358     0.200
     3.626    -2.256     0.200
     3.701    -1.238     0.200
     3.702    -1.260     0.200
     4.043    -2.877     0.200
     4.043    -2.080     0.200
     4.124    -1.940     0.200
     4.424    -1.857     0.200
     4.978    -2.397     0.200
     7.192    -2.433     0.200
     7.479    -4.194     0.200
     7.844    -4.249     0.200
     7.962    -4.083     0.200
     8.184    -4.248     0.200
     8.847    -5.648     0.200
     9.303    -5.501     0.200
     9.487    -6.324     0.200
     9.944    -6.632     0.200
    10.431    -7.160     0.200
    10.934    -6.411     0.200
    11.190    -5.619     0.200
    11.313    -7.121     0.200
    11.492    -6.817     0.200
    17.283   -11.963     0.200
    18.069   -10.701     0.200
    19.146    -3.768     0.200
     2.602    -2.003     0.200
     2.696     0.307     0.200
     2.878    -0.566     0.200
     3.632    -2.479     0.200
     3.696    -0.794     0.200
     4.037    -2.208     0.200
     4.125    -2.382     0.200
     4.417    -1.960     0.200
     4.972    -2.834     0.200
     5.428    -1.917     0.200
     5.638    -2.460     0.200
     6.846    -3.040     0.200
     6.865    -3.470     0.200
     6.941    -3.476     0.200
     7.101    -3.041     0.200
     2.586    -1.378     0.200
     2.693    -1.062     0.200
     2.879    -0.580     0.200
     3.637    -3.106     0.200
     3.691    -0.912     0.200
     4.033    -0.956     0.200
     4.105    -2.541     0.200
     4.418    -1.455     0.200
     4.967    -1.965     0.200
     5.442    -2.513     0.200
     5.642    -1.752     0.200
     6.481    -2.861     0.200
     6.847    -2.950     0.200
     6.944    -3.011     0.200
     7.105    -3.434     0.200
     2.603    -1.900     0.200
     2.603    -2.299     0.200
     2.696    -0.353     0.200
     2.696    -0.952     0.200
     2.878    -0.709     0.200
     3.632    -1.701     0.200
     3.696    -2.138     0.200
     4.126    -2.087     0.200
     4.126    -2.188     0.200
     4.038    -2.668     0.200
     4.038    -1.468     0.200
     4.417    -2.802     0.200
     4.417    -2.603     0.200
     4.972    -2.996     0.200
     6.865    -3.306     0.200
     6.941    -3.416     0.200
    11.002    -5.896     0.200
    11.456    -3.524     0.200
     2.599    -2.596     0.200
     2.599    -2.096     0.200
     2.696    -0.393     0.200
     2.880    -1.802     0.200
     2.880    -0.601     0.200
     3.632    -1.964     0.200
     3.695    -0.560     0.200
     4.037    -1.703     0.200
     4.120    -2.237     0.200
     4.419    -3.290     0.200
     4.419    -1.790     0.200
     4.972    -1.725     0.200
     5.433    -0.840     0.200
     5.640    -1.416     0.200
     6.480    -2.437     0.200
     6.847    -3.378     0.200
     6.868    -3.022     0.200
     6.943    -3.015     0.200
     7.103    -3.795     0.200
     7.479    -2.315     0.200
     7.678    -2.813     0.200
     7.840    -3.355     0.200
     7.873    -3.792     0.200
     7.903    -9.955     0.200
     7.956    -4.719     0.200
     8.179    -3.587     0.200
     8.230    -3.202     0.200
     8.361    -3.552     0.200
     8.841    -4.785     0.200
     9.232    -5.990     0.200
     9.297    -4.836     0.200
     9.481    -6.261     0.200
     9.938    -4.070     0.200
     9.938    -5.463     0.200
    10.425    -6.386     0.200
    10.928    -5.549     0.200
    11.007    -4.337     0.200
    11.460    -0.430     0.200
    15.197    -4.571     0.200
    17.289   -11.262     0.200
    18.075   -10.236     0.200
    19.140    -4.545     0.200
     2.665    -0.958     0.200
     3.496    -1.687     0.200
     3.833    -1.982     0.200
     3.834    -1.610     0.200
     4.057    -2.687     0.200
     4.205    -1.560     0.200
     4.770    -1.988     0.200
     5.248    -1.846     0.200
     5.425    -2.556     0.200
     6.652    -2.960     0.200
     2.659    -1.374     0.200
     2.659    -0.874     0.200
     3.492    -0.676     0.200
     3.837    -1.706     0.200
     3.837    -2.505     0.200
     3.830    -1.685     0.200
     4.061    -1.920     0.200
     4.199    -1.381     0.200
     4.199    -1.881     0.200
     4.766    -2.071     0.200
     6.042    -1.197     0.200
     7.402    -3.120     0.200
     7.653    -3.389     0.200
     7.652    -3.550     0.200
     8.113   -10.718     0.200
     8.008    -3.135     0.200
     8.140    -4.601     0.200
     9.011    -5.430     0.200
    11.101    -6.815     0.200
    11.249    -2.320     0.200
     2.602    -2.026     0.200
     2.710    -1.034     0.200
     2.895    -0.711     0.200
     3.620    -2.293     0.200
     3.708    -1.074     0.200
     4.050    -1.731     0.200
     4.119    -2.900     0.200
     4.434    -1.993     0.200
     5.450    -2.009     0.200
     5.657    -2.853     0.200
     2.614    -2.196     0.200
     2.702     0.218     0.200
     2.881    -0.563     0.200
     3.625    -2.436     0.200
     3.702    -1.393     0.200
     4.044    -2.108     0.200
     4.138    -2.212     0.200
     4.421    -1.666     0.200
     4.979    -1.944     0.200
     5.424    -0.950     0.200
     5.640    -1.909     0.200
     6.480    -2.741     0.200
     6.849    -3.846     0.200
     6.867    -3.422     0.200
     6.944    -3.156     0.200
     2.657    -1.345     0.200
     2.657    -0.845     0.200
     3.490    -1.453     0.200
     3.828    -1.463     0.200
     3.839    -3.119     0.200
     4.061    -2.450     0.200
     4.196    -1.353     0.200
     4.196    -2.251     0.200
     4.764    -2.347     0.200
     5.237    -1.450     0.200
     5.416    -2.319     0.200
     6.256    -2.837     0.200
     6.625    -3.528     0.200
     6.644    -2.822     0.200
     6.720    -2.835     0.200
     6.879    -3.796     0.200
     7.115    -0.960     0.200
     7.401    -4.034     0.200
     7.454    -3.315     0.200
     7.651    -3.967     0.200
     7.650    -3.819     0.200
     7.732    -4.737     0.200
     7.955    -4.588     0.200
     8.006    -4.202     0.200
     8.071    -4.277     0.200
     8.137    -4.868     0.200
     8.115   -11.489     0.200
     8.617    -4.691     0.200
     9.009    -4.799     0.200
     9.074    -5.975     0.200
     9.257    -5.872     0.200
     9.715    -8.642     0.200
     9.715    -5.986     0.200
    10.203    -7.356     0.200
    10.704    -6.049     0.200
    10.973    -6.979     0.200
    11.102    -4.840     0.200
    11.246    -5.971     0.200
    11.270    -6.893     0.200
    15.245   -10.007     0.200
    17.512   -12.664     0.200
    18.540    -6.862     0.200
    18.955    -4.196     0.200
    20.265    -1.236     0.200
     2.611    -2.203     0.200
     2.707    -0.348     0.200
     2.889    -0.507     0.200
     3.621    -1.519     0.200
     3.707    -0.732     0.200
     4.048    -1.566     0.200
     4.132    -2.610     0.200
     4.428    -1.501     0.200
     4.983    -2.192     0.200
     5.436    -2.439     0.200
     5.648    -2.087     0.200
     6.488    -2.314     0.200
     6.857    -3.185     0.200
     6.876    -2.996     0.200
     7.474    -2.045     0.200
     7.842    -2.834     0.200
     7.965    -4.714     0.200
     2.608    -2.062     0.200
     2.704    -0.014     0.200
     2.886    -0.783     0.200
     3.624    -1.984     0.200
     3.703    -1.494     0.200
     4.045    -1.430     0.200
     4.129    -2.681     0.200
     4.425    -1.779     0.200
     4.980    -2.653     0.200
     5.646    -2.375     0.200
     6.486    -2.198     0.200
     6.854    -3.765     0.200
     6.873    -3.084     0.200
     2.605    -1.865     0.200
     2.711    -0.732     0.200
     2.896    -1.386     0.200
     3.619    -2.005     0.200
     3.709    -2.173     0.200
     4.052    -1.733     0.200
     4.122    -3.350     0.200
     4.435    -1.967     0.200
     4.986    -2.346     0.200
     5.449    -1.833     0.200
     5.657    -3.019     0.200
     6.497    -3.535     0.200
     6.863    -4.263     0.200
     6.884    -3.221     0.200
     7.489    -2.696     0.200
     2.611    -2.436     0.200
     2.710    -0.374     0.200
     2.892    -1.353     0.200
     2.892    -0.853     0.200
     3.619    -1.792     0.200
     3.709    -0.847     0.200
     4.130    -2.006     0.200
     4.051    -3.085     0.200
     4.051    -1.987     0.200
     4.431    -2.146     0.200
     4.431    -2.845     0.200
     4.985    -2.407     0.200
     7.190    -1.713     0.200
     8.372    -4.568     0.200
     8.853    -5.227     0.200
    10.996    -5.168     0.200
    11.470    -4.318     0.200
    15.188    -5.085     0.200
    15.668    -8.943     0.200
    17.277    -8.822     0.200
    18.063    -8.564     0.200
    18.571    -4.119     0.200
    19.153    -3.159     0.200
     2.603    -2.136     0.200
     2.705    -0.373     0.200
     3.624    -2.199     0.200
     3.704    -1.230     0.200
     4.046    -1.778     0.200
     4.428    -2.191     0.200
     4.428    -1.890     0.200
     4.980    -1.996     0.200
     5.442    -1.526     0.200
     5.650    -2.323     0.200
     6.490    -2.742     0.200
     6.857    -3.180     0.200
     6.953    -3.519     0.200
     7.113    -3.303     0.200
     7.196    -1.873     0.200
     7.484    -4.762     0.200
     7.688    -3.820     0.200
     7.849    -2.836     0.200
     7.883    -4.100     0.200
     7.965    -4.121     0.200
     8.188    -3.896     0.200
     8.239    -3.011     0.200
     8.305    -5.185     0.200
     8.370    -4.059     0.200
     8.851    -4.590     0.200
     9.242    -6.296     0.200
    15.196    -6.730     0.200
    18.065    -7.902     0.200
    18.563    -4.760     0.200
     2.538    -1.761     0.200
     3.344    -0.902     0.200
     3.666    -1.807     0.200
     3.666    -1.507     0.200
     3.973    -1.048     0.200
     4.016    -2.908     0.200
     4.607    -1.333     0.200
     4.922    -1.413     0.200
     5.161    -2.400     0.200
     6.004    -2.833     0.200
     6.390    -3.152     0.200
     6.396    -2.941     0.200
     6.480    -2.814     0.200
     6.622    -3.328     0.200
     6.856    -2.222     0.200
     7.141    -3.256     0.200
     7.334    -2.486     0.200
     7.380    -4.029     0.200
     7.492    -3.796     0.200
     7.696    -4.261     0.200
     7.748    -3.909     0.200
     7.869    -4.056     0.200
     8.370    -4.142     0.200
     8.419    -8.730     0.200
     8.763    -4.700     0.200
     8.841    -4.453     0.200
     9.014    -4.645     0.200
     9.476    -7.416     0.200
    10.946    -6.680     0.200
    11.048    -4.277     0.200
    15.122    -8.240     0.200
    18.572    -5.915     0.200
     2.519    -1.151     0.200
     2.519    -1.651     0.200
     3.345    -0.742     0.200
     3.669    -1.613     0.200
     4.009    -1.911     0.200
     4.009    -2.716     0.200
     3.984    -1.311     0.200
     3.984    -3.007     0.200
     4.609    -1.828     0.200
     6.887    -0.200     0.200
     8.394   -11.835     0.200
     8.385    -4.426     0.200
     8.778    -4.469     0.200
     8.854    -4.868     0.200
     9.489    -5.627     0.200
     9.989    -6.678     0.200
    10.464    -6.416     0.200
    10.694    -6.020     0.200
    10.877    -7.823     0.200
    11.066    -5.055     0.200
    11.083    -6.742     0.200
    15.145    -6.206     0.200
    17.738   -10.778     0.200
    18.676    -6.833     0.200
    18.851    -4.281     0.200
    20.085     3.299     0.200
     2.531    -1.863     0.200
     3.344    -1.238     0.200
     3.666    -1.069     0.200
     3.977    -1.001     0.200
     4.014    -1.593     0.200
     4.607    -2.291     0.200
     4.932    -2.175     0.200
     5.166    -1.711     0.200
     6.395    -2.360     0.200
     6.400    -3.607     0.200
     6.484    -2.696     0.200
     6.628    -2.741     0.200
     7.152    -2.670     0.200
     7.344    -3.454     0.200
     2.524    -1.770     0.200
     3.665    -1.632     0.200
     3.977    -0.930     0.200
     4.015    -0.917     0.200
     4.606    -1.550     0.200
     4.937    -0.268     0.200
     5.168    -2.284     0.200
     6.400    -2.346     0.200
     6.397    -3.033     0.200
     6.486    -2.147     0.200
     6.630    -2.918     0.200
     7.350    -2.459     0.200
     2.828     0.243     0.200
     2.828    -0.457     0.200
     2.862    -0.347     0.200
     2.862    -1.547     0.200
     3.094    -2.492     0.200
     3.587    -1.629     0.200
     3.856    -0.641     0.200
     4.162    -2.457     0.200
     4.162    -2.656     0.200
     4.390    -0.972     0.200
     6.520    -0.906     0.200
     6.808    -2.038     0.200
     6.791    -2.307     0.200
     6.856    -2.137     0.200
     6.960    -2.136     0.200
     7.366    -2.430     0.200
     7.840    -3.244     0.200
     7.864    -3.902     0.200
     8.080    -3.159     0.200
     8.175    -3.468     0.200
     8.727    -3.748     0.200
     9.122    -4.485     0.200
     9.223    -4.599     0.200
    10.487    -8.789     0.200
    11.124    -4.512     0.200
     2.526    -1.432     0.200
     3.338    -1.073     0.200
     3.661    -1.601     0.200
     3.971    -1.353     0.200
     4.020    -1.978     0.200
     4.602    -2.127     0.200
     4.929    -1.305     0.200
     5.161    -2.171     0.200
     6.004    -2.199     0.200
     6.390    -3.925     0.200
     6.394    -2.958     0.200
     6.479    -4.356     0.200
     6.623    -3.206     0.200
     7.154    -3.534     0.200
     2.517    -1.291     0.200
     2.517    -1.391     0.200
     3.337    -1.490     0.200
     3.661    -1.446     0.200
     3.661    -1.346     0.200
     3.975    -0.798     0.200
     3.975    -1.898     0.200
     4.018    -1.585     0.200
     4.601    -2.765     0.200
     4.940    -1.695     0.200
     5.167    -2.186     0.200
     6.009    -2.603     0.200
     6.395    -2.734     0.200
     6.398    -2.320     0.200
     6.484    -2.435     0.200
     6.628    -2.922     0.200
     6.882    -3.090     0.200
     7.167    -3.599     0.200
     7.207    -3.869     0.200
     7.353    -2.899     0.200
     7.387    -3.087     0.200
     7.702    -3.267     0.200
     7.754    -3.310     0.200
     7.824    -4.417     0.200
     7.877    -4.503     0.200
     8.221    -4.223     0.200
     8.375    -3.197     0.200
     8.405   -10.986     0.200
     8.768    -5.547     0.200
     9.018    -5.283     0.200
     9.480    -6.744     0.200
    10.959    -4.249     0.200
    11.068    -5.571     0.200
    18.563   -10.190     0.200
    18.678    -7.576     0.200
    18.844    -6.470     0.200
     2.513    -1.923     0.200
     2.513    -2.025     0.200
     3.341    -2.373     0.200
     3.665    -2.252     0.200
     3.665    -2.451     0.200
     4.012    -2.249     0.200
     4.012    -3.448     0.200
     3.982    -1.684     0.200
     3.982    -2.184     0.200
     4.606    -2.466     0.200
     6.892    -4.024     0.200
     8.384    -6.319     0.200
     8.776    -5.666     0.200
     9.027    -6.599     0.200
     9.488    -6.349     0.200
    10.970    -1.616     0.200
     2.603    -1.986     0.200
     2.689    -0.511     0.200
     2.869    -0.308     0.200
     3.638    -2.801     0.200
     3.689    -2.117     0.200
     4.030    -1.133     0.200
     4.408    -1.010     0.200
     4.965    -2.768     0.200
     5.416    -1.643     0.200
     5.628    -2.471     0.200
     6.468    -2.400     0.200
     6.837    -2.992     0.200
     6.855    -3.682     0.200
     6.932    -4.008     0.200
     7.823    -4.250     0.200
     2.524    -1.903     0.200
     3.350    -1.282     0.200
     3.674    -1.750     0.200
     4.005    -3.535     0.200
     3.988    -1.821     0.200
     4.614    -2.364     0.200
     4.951    -1.723     0.200
     5.180    -2.301     0.200
     6.023    -2.120     0.200
     6.409    -3.148     0.200
     6.412    -3.338     0.200
     6.497    -2.553     0.200
     6.642    -3.137     0.200
     6.884    -2.247     0.200
     7.169    -3.252     0.200
     7.221    -3.187     0.200
    10.972    -3.283     0.200
     2.514    -1.243     0.200
     3.659    -1.455     0.200
     3.974    -1.434     0.200
     4.019    -3.266     0.200
     4.600    -2.375     0.200
     4.942    -1.511     0.200
     5.167    -1.646     0.200
     6.398    -3.861     0.200
     6.395    -2.890     0.200
     6.629    -3.281     0.200
     7.170    -3.159     0.200
     7.355    -2.317     0.200
     2.527    -1.735     0.200
     2.527    -1.634     0.200
     3.351    -0.942     0.200
     3.674    -2.300     0.200
     3.674    -1.894     0.200
     4.005    -2.961     0.200
     4.005    -3.164     0.200
     3.988    -2.735     0.200
     4.615    -2.517     0.200
     5.179    -3.092     0.200
     6.880    -1.586     0.200
     8.388    -4.512     0.200
     8.781    -5.066     0.200
     8.857    -4.980     0.200
     9.492    -6.082     0.200
    11.057    -5.982     0.200
    10.969    -2.409     0.200
    15.136    -8.431     0.200
    18.552   -11.832     0.200
    18.685    -5.816     0.200
    18.858    -1.177     0.200
     2.548    -1.970     0.200
     3.674    -2.267     0.200
     3.980    -1.354     0.200
     4.009    -1.488     0.200
     4.615    -1.096     0.200
     4.922    -2.128     0.200
     5.166    -1.374     0.200
     6.395    -3.420     0.200
     6.402    -2.442     0.200
     6.486    -2.603     0.200
     6.627    -2.892     0.200
     7.134    -3.162     0.200
     7.334    -2.480     0.200
     7.384    -3.474     0.200
     7.498    -3.187     0.200
     7.874    -3.607     0.200
     2.529    -1.559     0.200
     3.336    -1.234     0.200
     3.658    -1.650     0.200
     3.967    -1.540     0.200
     4.023    -1.731     0.200
     4.599    -1.976     0.200
     4.921    -1.197     0.200
     5.156    -2.332     0.200
     5.999    -2.458     0.200
     6.385    -3.282     0.200
     6.390    -3.440     0.200
     6.474    -3.425     0.200
     6.617    -3.062     0.200
     7.147    -2.644     0.200
     3.332    -0.863     0.200
     3.657    -2.162     0.200
     3.976    -1.091     0.200
     4.020    -2.882     0.200
     4.597    -2.473     0.200
     4.955    -1.432     0.200
     5.172    -1.692     0.200
     6.014    -2.097     0.200
     6.400    -2.836     0.200
     6.400    -3.037     0.200
     6.487    -2.687     0.200
     6.634    -3.137     0.200
     6.904    -0.965     0.200
     7.189    -3.647     0.200
     7.370    -3.263     0.200
     7.394    -4.652     0.200
     7.499    -3.478     0.200
     7.708    -4.288     0.200
     7.760    -3.527     0.200
     7.884    -3.560     0.200
     8.227    -5.037     0.200
     8.379    -5.075     0.200
     8.392    -9.967     0.200
     8.772    -4.721     0.200
     9.022    -5.749     0.200
     9.483    -6.990     0.200
    10.971    -5.167     0.200
    11.085    -5.420     0.200
     2.508    -1.376     0.200
     3.650    -1.171     0.200
     3.964    -1.746     0.200
     4.029    -2.298     0.200
     4.590    -1.786     0.200
     4.935    -1.300     0.200
     5.157    -1.458     0.200
     6.000    -2.171     0.200
     6.386    -3.803     0.200
     6.388    -2.869     0.200
     6.474    -3.295     0.200
     6.619    -3.398     0.200
     7.170    -3.950     0.200
     7.348    -3.424     0.200
     2.511    -1.087     0.200
     3.327    -1.352     0.200
     3.650    -0.705     0.200
     3.964    -1.149     0.200
     4.029    -2.206     0.200
     4.591    -2.525     0.200
     4.932    -1.832     0.200
     5.156    -2.740     0.200
     6.385    -3.687     0.200
     6.387    -2.674     0.200
     6.473    -2.586     0.200
     6.618    -2.678     0.200
     7.166    -3.252     0.200
     7.346    -3.052     0.200
     2.532    -1.721     0.200
     3.343    -1.940     0.200
     3.666    -1.266     0.200
     3.975    -1.881     0.200
     4.015    -3.246     0.200
     4.606    -2.090     0.200
     4.929    -2.218     0.200
     5.165    -1.880     0.200
     6.008    -3.006     0.200
     6.393    -3.031     0.200
     6.398    -3.684     0.200
     6.483    -3.071     0.200
     6.626    -3.210     0.200
     2.619    -0.799     0.200
     2.722    -0.862     0.200
     2.722    -0.760     0.200
     2.938    -0.820     0.200
     2.939    -2.254     0.200
     2.939    -1.051     0.200
     3.275    -0.508     0.200
     3.275    -1.110     0.200
     3.880    -1.378     0.200
     4.507    -2.453     0.200
     4.507    -1.953     0.200
     4.738    -2.260     0.200
     4.545    -2.758     0.200
     6.991    -0.742     0.200
     2.535    -2.115     0.200
     2.535    -2.217     0.200
     3.355     0.098     0.200
     3.678    -1.042     0.200
     4.002    -1.603     0.200
     3.990    -1.014     0.200
     4.619    -1.266     0.200
     6.872    -0.208     0.200
     8.397    -9.978     0.200
     8.781    -4.216     0.200
     8.858    -4.146     0.200
     9.032    -5.454     0.200
     9.493    -5.386     0.200
     9.994    -5.369     0.200
    10.466    -4.927     0.200
    10.691    -5.543     0.200
    10.883    -7.925     0.200
    11.090    -7.402     0.200
    18.863    -6.560     0.200
    20.068    -1.895     0.200
    23.767    -2.670     0.200
     2.516    -1.843     0.200
     3.325    -0.899     0.200
     3.648    -1.728     0.200
     3.959    -1.096     0.200
     4.033    -1.840     0.200
     4.588    -1.953     0.200
     4.922    -1.339     0.200
     5.150    -1.550     0.200
     7.156    -3.063     0.200
     2.513    -1.251     0.200
     3.344    -0.895     0.200
     3.669    -2.278     0.200
     4.009    -3.150     0.200
     3.986    -1.436     0.200
     4.609    -2.392     0.200
     6.895    -2.276     0.200
     2.514    -1.196     0.200
     3.342    -0.825     0.200
     3.666    -1.699     0.200
     3.982    -0.722     0.200
     4.012    -1.584     0.200
     4.606    -2.116     0.200
     4.951    -1.526     0.200
     5.175    -1.747     0.200
     6.018    -2.163     0.200
     6.404    -2.592     0.200
     6.406    -3.556     0.200
     6.492    -3.681     0.200
     6.637    -2.984     0.200
     6.891    -0.091     0.200
     7.176    -3.274     0.200
     7.364    -3.337     0.200
     9.488    -8.160     0.200
     2.541    -1.624     0.200
     3.340    -0.745     0.200
     3.662    -1.729     0.200
     3.967    -1.103     0.200
     4.022    -2.641     0.200
     4.603    -2.160     0.200
     4.912    -1.554     0.200
     5.153    -2.320     0.200
     5.997    -2.952     0.200
     6.382    -2.874     0.200
     6.389    -3.589     0.200
     6.473    -3.250     0.200
     6.615    -2.838     0.200
     7.324    -3.624     0.200
     2.504    -1.669     0.200
     3.305    -1.679     0.200
     3.628    -2.102     0.200
     3.939    -1.059     0.200
     4.053    -2.584     0.200
     4.568    -2.326     0.200
     4.908    -2.180     0.200
     5.130    -1.926     0.200
     5.973    -2.943     0.200
     6.362    -3.274     0.200
     6.359    -3.273     0.200
     6.592    -3.961     0.200
     7.322    -2.517     0.200
     2.509    -1.770     0.200
     3.335    -1.652     0.200
     3.659    -1.428     0.200
     3.976    -0.762     0.200
     4.019    -1.518     0.200
     4.600    -1.445     0.200
     4.947    -1.456     0.200
     5.169    -2.300     0.200
     6.012    -2.312     0.200
     6.399    -2.393     0.200
     6.398    -3.646     0.200
     6.486    -2.325     0.200
     6.631    -2.341     0.200
     7.361    -2.370     0.200
     2.536    -1.716     0.200
     2.536    -1.314     0.200
     3.358    -2.082     0.200
     3.681    -1.626     0.200
     3.998    -2.787     0.200
     3.998    -3.486     0.200
     3.993    -1.816     0.200
     4.622    -2.748     0.200
     4.947    -1.764     0.200
     5.183    -2.846     0.200
     6.026    -2.467     0.200
     6.412    -2.795     0.200
     6.416    -2.826     0.200
     6.501    -3.824     0.200
     6.645    -3.075     0.200
     6.874    -1.472     0.200
     7.159    -3.385     0.200
     7.360    -3.733     0.200
     7.403    -4.707     0.200
     7.513    -3.813     0.200
     7.719    -3.614     0.200
     7.771    -3.662     0.200
     7.893    -4.128     0.200
     8.238    -4.279     0.200
     8.393   -11.836     0.200
     8.392    -4.571     0.200
     8.785    -4.924     0.200
     8.862    -5.553     0.200
     9.036    -5.567     0.200
     9.497    -4.626     0.200
     9.497    -4.896     0.200
     9.998    -6.974     0.200
    10.470    -7.442     0.200
    10.695    -5.365     0.200
    10.886    -7.528     0.200
    10.971    -2.991     0.200
    11.049    -4.735     0.200
    11.093    -6.896     0.200
    14.757    -9.448     0.200
    15.128    -7.141     0.200
    16.104   -10.551     0.200
    18.549    -9.598     0.200
    18.693    -6.275     0.200
    18.865    -4.809     0.200
    20.069    -2.734     0.200
     2.534    -1.746     0.200
     3.361    -0.871     0.200
     3.685    -1.932     0.200
     3.994    -3.016     0.200
     3.999    -1.370     0.200
     4.626    -1.551     0.200
     4.955    -1.888     0.200
     5.190    -2.023     0.200
     6.033    -3.146     0.200
     6.418    -2.874     0.200
     6.422    -2.987     0.200
     6.507    -2.790     0.200
     7.166    -3.561     0.200
     7.367    -3.256     0.200
     2.521    -1.598     0.200
     3.348    -1.122     0.200
     3.672    -1.096     0.200
     3.987    -1.388     0.200
     4.006    -1.897     0.200
     4.613    -1.709     0.200
     4.952    -1.274     0.200
     5.180    -1.597     0.200
     6.023    -3.008     0.200
     6.408    -2.638     0.200
     6.411    -2.816     0.200
     6.497    -2.739     0.200
     6.642    -3.130     0.200
     6.888    -0.327     0.200
     7.173    -3.269     0.200
     7.365    -2.668     0.200
     7.401    -3.595     0.200
     7.509    -4.827     0.200
     7.715    -3.479     0.200
     7.767    -4.317     0.200
     7.890    -4.416     0.200
     8.392    -9.886     0.200
     8.781    -4.255     0.200
     9.031    -5.886     0.200
    10.972    -6.318     0.200
    11.063    -6.688     0.200
    18.550   -10.530     0.200
    18.678    -5.129     0.200
     2.536    -1.602     0.200
     3.362    -0.787     0.200
     3.685    -1.739     0.200
     3.994    -1.323     0.200
     3.998    -1.464     0.200
     4.626    -2.464     0.200
     4.953    -0.842     0.200
     5.189    -1.605     0.200
     6.032    -3.031     0.200
     6.418    -2.852     0.200
     6.421    -2.778     0.200
     6.507    -2.776     0.200
     6.650    -3.438     0.200
     7.163    -3.193     0.200
     7.366    -3.106     0.200
     2.509    -1.748     0.200
     3.313    -1.527     0.200
     3.635    -0.950     0.200
     3.946    -0.603     0.200
     4.045    -2.160     0.200
     4.576    -1.872     0.200
     4.912    -2.031     0.200
     5.137    -1.955     0.200
     5.980    -3.475     0.200
     6.366    -2.705     0.200
     6.369    -3.212     0.200
     6.454    -3.916     0.200
     7.326    -3.058     0.200
     2.511    -1.199     0.200
     2.511    -1.597     0.200
     3.320    -0.938     0.200
     3.643    -1.071     0.200
     3.643    -1.672     0.200
     3.955    -1.453     0.200
     3.955    -0.153     0.200
     4.037    -3.375     0.200
     4.037    -0.175     0.200
     4.584    -2.292     0.200
     4.921    -2.376     0.200
     5.146    -2.117     0.200
     5.989    -2.835     0.200
     6.375    -2.866     0.200
     6.378    -3.167     0.200
     6.463    -2.976     0.200
     6.608    -2.952     0.200
     6.873    -0.334     0.200
     7.334    -3.095     0.200
     7.367    -4.614     0.200
     7.475    -4.564     0.200
     7.681    -3.898     0.200
     7.733    -4.639     0.200
     7.856    -3.931     0.200
     8.201    -4.656     0.200
     8.355    -4.831     0.200
     8.425   -10.546     0.200
     8.747    -4.685     0.200
     8.823    -4.899     0.200
     8.998    -5.021     0.200
     9.459    -5.427     0.200
    10.939    -3.303     0.200
    11.075    -4.068     0.200
    11.055    -6.925     0.200
     2.506    -1.033     0.200
     3.313    -0.812     0.200
     3.636    -0.845     0.200
     3.948    -1.335     0.200
     4.044    -1.788     0.200
     4.577    -2.068     0.200
     4.917    -1.343     0.200
     5.140    -1.612     0.200
     5.982    -2.528     0.200
     6.371    -3.153     0.200
     6.368    -3.159     0.200
     6.457    -2.963     0.200
     7.331    -3.273     0.200
     2.547    -1.572     0.200
     3.370    -1.068     0.200
     3.693    -1.510     0.200
     3.987    -2.725     0.200
     4.004    -0.860     0.200
     4.634    -1.231     0.200
     4.951    -0.900     0.200
     5.193    -1.752     0.200
     6.036    -3.679     0.200
     6.422    -2.403     0.200
     6.427    -3.263     0.200
     6.511    -3.849     0.200
     7.363    -3.147     0.200
     2.538    -1.299     0.200
     3.358    -1.401     0.200
     3.681    -1.742     0.200
     3.999    -3.306     0.200
     3.992    -1.006     0.200
     4.622    -2.064     0.200
     4.945    -1.293     0.200
     5.182    -1.618     0.200
     7.357    -3.659     0.200
     2.532    -1.472     0.200
     3.360    -1.728     0.200
     3.684    -1.992     0.200
     3.995    -3.238     0.200
     3.998    -1.650     0.200
     4.625    -2.111     0.200
     4.956    -0.616     0.200
     5.189    -1.615     0.200
     6.651    -2.949     0.200
     7.168    -2.522     0.200
     7.368    -2.991     0.200
     2.532    -1.594     0.200
     2.532    -1.393     0.200
     3.329    -0.936     0.200
     3.650    -1.724     0.200
     3.956    -0.913     0.200
     4.033    -2.168     0.200
     4.033    -2.868     0.200
     4.591    -1.754     0.200
     4.905    -0.425     0.200
     4.905    -1.925     0.200
     5.143    -1.352     0.200
     5.986    -1.582     0.200
     6.372    -2.803     0.200
     6.462    -2.069     0.200
     6.604    -3.078     0.200
     6.849     1.279     0.200
     7.134    -2.274     0.200
     7.318    -3.411     0.200
     7.361    -3.078     0.200
     7.474    -3.052     0.200
     7.678    -2.812     0.200
     7.730    -2.760     0.200
     7.851    -4.106     0.200
     8.197    -4.077     0.200
     8.353    -4.495     0.200
     8.436   -10.476     0.200
     8.745    -5.352     0.200
     8.823    -4.910     0.200
     8.996    -4.498     0.200
     9.458    -6.070     0.200
     9.458    -5.138     0.200
     9.960    -6.154     0.200
    10.430    -6.041     0.200
    10.652    -4.994     0.200
    10.849    -5.625     0.200
    10.928    -5.070     0.200
    11.058    -6.065     0.200
    11.056    -2.639     0.200
    15.125    -5.486     0.200
    18.590    -5.836     0.200
    18.703    -4.490     0.200
    18.840    -4.445     0.200
     2.520    -1.653     0.200
     3.650    -2.070     0.200
     3.960    -1.210     0.200
     4.031    -1.548     0.200
     5.150    -1.735     0.200
     5.993    -2.262     0.200
     6.379    -3.388     0.200
     6.383    -3.119     0.200
     6.468    -3.612     0.200
     6.612    -2.771     0.200
     7.334    -3.758     0.200
     2.533    -1.520     0.200
     3.335    -1.238     0.200
     3.657    -1.639     0.200
     3.964    -1.468     0.200
     4.025    -2.919     0.200
     4.598    -2.066     0.200
     4.914    -1.302     0.200
     5.152    -1.926     0.200
     5.995    -2.155     0.200
     6.381    -2.777     0.200
     6.386    -3.161     0.200
     6.471    -3.235     0.200
     6.613    -3.152     0.200
     7.139    -2.732     0.200
     7.327    -2.985     0.200
     3.628    -1.846     0.200
     3.941    -1.064     0.200
     4.052    -2.580     0.200
     4.569    -2.568     0.200
     5.133    -2.065     0.200
     5.976    -2.179     0.200
     6.364    -2.585     0.200
     6.362    -3.113     0.200
     6.450    -3.204     0.200
     7.162    -3.391     0.200
     7.329    -3.058     0.200
     2.532    -1.339     0.200
     3.355    -0.542     0.200
     3.679    -1.296     0.200
     4.001    -2.805     0.200
     3.991    -1.314     0.200
     4.619    -2.318     0.200
     4.948    -1.650     0.200
     5.182    -2.261     0.200
     6.025    -1.885     0.200
     6.411    -3.210     0.200
     6.415    -3.328     0.200
     6.644    -3.293     0.200
     7.163    -3.345     0.200
     7.361    -3.524     0.200
     2.504    -1.256     0.200
     3.643    -1.673     0.200
     3.958    -1.042     0.200
     4.036    -2.220     0.200
     5.151    -2.361     0.200
     5.993    -3.074     0.200
     6.381    -3.768     0.200
     6.379    -3.206     0.200
     6.612    -2.700     0.200
     7.169    -2.953     0.200
     7.344    -3.594     0.200
     2.531    -1.199     0.200
     3.323    -1.008     0.200
     3.644    -1.588     0.200
     3.949    -1.448     0.200
     4.039    -1.820     0.200
     4.585    -2.319     0.200
     5.136    -2.176     0.200
     5.979    -2.907     0.200
     6.365    -3.528     0.200
     6.371    -3.433     0.200
     6.455    -3.297     0.200
     6.597    -3.301     0.200
     7.131    -3.414     0.200
     7.312    -3.348     0.200
     2.500    -1.273     0.200
     3.304    -0.959     0.200
     3.627    -1.589     0.200
     3.939    -0.982     0.200
     4.053    -2.305     0.200
     4.568    -2.216     0.200
     4.911    -1.791     0.200
     5.131    -2.177     0.200
     5.974    -2.689     0.200
     6.362    -3.302     0.200
     6.593    -3.312     0.200
     7.325    -4.334     0.200
     2.552    -1.121     0.200
     3.324    -2.083     0.200
     3.643    -1.197     0.200
     3.940    -1.195     0.200
     3.940     0.305     0.200
     4.045    -1.032     0.200
     4.584    -2.036     0.200
     4.871    -1.721     0.200
     5.122    -2.162     0.200
     5.965    -3.308     0.200
     6.350    -4.517     0.200
     6.361    -4.240     0.200
     6.443    -3.955     0.200
     7.283    -3.481     0.200
     3.346    -2.057     0.200
     3.663    -1.096     0.200
     3.949    -1.171     0.200
     4.031    -0.562     0.200
     4.851    -0.857     0.200
     5.124    -2.215     0.200
     6.353    -3.771     0.200
     6.369    -3.059     0.200
     6.449    -3.408     0.200
     7.261    -1.748     0.200
     2.529    -1.096     0.200
     3.657    -1.282     0.200
     3.966    -0.472     0.200
     4.024    -1.096     0.200
     5.155    -1.665     0.200
     6.384    -2.315     0.200
     6.389    -3.373     0.200
     6.474    -3.358     0.200
     6.617    -3.194     0.200
     7.334    -2.724     0.200
     2.526    -1.501     0.200
     3.662    -1.710     0.200
     3.973    -1.265     0.200
     4.019    -2.821     0.200
     4.603    -1.533     0.200
     4.931    -1.333     0.200
     5.163    -1.795     0.200
     6.392    -2.342     0.200
     6.396    -3.375     0.200
     6.481    -3.169     0.200
     6.624    -3.427     0.200
     7.155    -3.544     0.200
     7.344    -3.625     0.200
     2.529    -1.214     0.200
     3.652    -1.106     0.200
     3.959    -0.654     0.200
     4.031    -0.924     0.200
     4.592    -1.637     0.200
     4.912    -2.067     0.200
     5.147    -1.622     0.200
     6.376    -2.369     0.200
     6.381    -3.043     0.200
     6.466    -3.221     0.200
     6.609    -2.450     0.200
     6.856     0.685     0.200
     7.141    -2.424     0.200
     7.325    -3.559     0.200
     8.430    -9.568     0.200
    10.934    -5.547     0.200
     3.306    -0.994     0.200
     3.629    -1.436     0.200
     3.943    -1.386     0.200
     4.050    -3.580     0.200
     4.050    -3.478     0.200
     4.570    -1.857     0.200
     4.918    -2.697     0.200
     5.136    -2.707     0.200
     5.979    -3.419     0.200
     6.367    -3.416     0.200
     6.882    -2.352     0.200
    10.933    -2.505     0.200
     2.545    -1.685     0.200
     3.329    -0.248     0.200
     3.649    -1.797     0.200
     3.950    -0.434     0.200
     4.036    -3.371     0.200
     5.134    -1.879     0.200
     7.302    -4.180     0.200
     2.520    -1.813     0.200
     3.636    -1.277     0.200
     3.942    -0.297     0.200
     4.047    -1.721     0.200
     4.576    -1.902     0.200
     4.899    -1.034     0.200
     5.131    -2.575     0.200
     5.974    -1.699     0.200
     6.359    -2.127     0.200
     6.365    -2.592     0.200
     7.313    -2.646     0.200
     2.511    -1.603     0.200
     2.511    -2.002     0.200
     3.315    -0.903     0.200
     3.638    -1.221     0.200
     3.638    -2.026     0.200
     3.949    -1.371     0.200
     3.949    -1.973     0.200
     4.043    -1.857     0.200
     4.579    -1.350     0.200
     4.913    -1.258     0.200
     5.139    -2.315     0.200
     5.982    -2.238     0.200
     6.368    -3.264     0.200
     6.372    -3.081     0.200
     6.601    -2.556     0.200
     6.869    -1.074     0.200
     7.154    -2.578     0.200
     7.180    -3.500     0.200
     7.327    -3.679     0.200
     7.360    -3.609     0.200
     7.469    -4.370     0.200
     7.675    -3.293     0.200
     7.727    -4.937     0.200
     7.797    -3.853     0.200
     7.849    -3.221     0.200
     8.348    -4.134     0.200
     8.432    -9.100     0.200
     8.741    -4.688     0.200
     8.817    -4.904     0.200
     8.991    -4.924     0.200
     9.453    -5.254     0.200
    11.076    -5.324     0.200
    15.147    -7.582     0.200
    18.681    -6.931     0.200
     2.527    -1.533     0.200
     3.322    -1.614     0.200
     3.643    -1.006     0.200
     3.949    -0.498     0.200
     4.040    -2.091     0.200
     4.584    -1.335     0.200
     4.901    -1.501     0.200
     5.137    -1.750     0.200
     6.365    -3.600     0.200
     6.371    -3.389     0.200
     6.598    -3.976     0.200
     7.315    -2.093     0.200
     2.519    -1.401     0.200
     3.310    -1.496     0.200
     3.632    -1.683     0.200
     3.938    -1.494     0.200
     4.051    -2.174     0.200
     4.573    -1.411     0.200
     5.126    -2.165     0.200
     5.970    -3.290     0.200
     6.355    -2.912     0.200
     6.361    -3.584     0.200
     6.588    -3.291     0.200
     7.137    -3.291     0.200
     7.309    -3.547     0.200
     2.520    -1.491     0.200
     3.320    -0.944     0.200
     3.642    -1.451     0.200
     3.950    -0.821     0.200
     3.950    -1.722     0.200
     4.040    -1.767     0.200
     4.583    -1.477     0.200
     4.908    -0.700     0.200
     5.139    -2.218     0.200
     5.982    -1.744     0.200
     6.368    -2.969     0.200
     6.373    -3.522     0.200
     6.860    -3.276     0.200
     7.144    -3.080     0.200
     7.322    -3.007     0.200
    10.928    -4.552     0.200
     2.517    -1.456     0.200
     3.631    -1.381     0.200
     3.938    -1.208     0.200
     4.051    -1.291     0.200
     4.572    -1.609     0.200
     4.897    -1.597     0.200
     5.127    -2.490     0.200
     5.970    -2.816     0.200
     6.356    -2.441     0.200
     6.361    -3.104     0.200
     6.588    -3.020     0.200
     7.139    -2.374     0.200
     7.311    -3.614     0.200
     2.520    -1.540     0.200
     3.317    -0.593     0.200
     3.639    -1.590     0.200
     3.946    -0.932     0.200
     4.043    -2.817     0.200
     4.580    -1.818     0.200
     5.135    -2.016     0.200
     5.978    -3.242     0.200
     6.364    -3.768     0.200
     6.369    -3.330     0.200
     6.596    -3.547     0.200
     7.317    -3.989     0.200
     2.519    -1.289     0.200
     3.341    -1.832     0.200
     3.665    -1.590     0.200
     3.979    -0.741     0.200
     4.014    -2.275     0.200
     4.605    -2.209     0.200
     5.170    -1.428     0.200
     6.013    -2.043     0.200
     6.399    -3.473     0.200
     6.632    -2.764     0.200
     7.356    -1.900     0.200
     2.514    -0.991     0.200
     3.306    -1.624     0.200
     3.628    -0.920     0.200
     3.935    -1.959     0.200
     4.054    -2.133     0.200
     4.569    -2.342     0.200
     4.896    -0.714     0.200
     5.124    -1.358     0.200
     6.586    -3.189     0.200
     7.141    -3.179     0.200
     7.310    -2.542     0.200
     2.519    -1.108     0.200
     3.320    -2.180     0.200
     3.642    -1.288     0.200
     3.950    -0.766     0.200
     3.950    -2.466     0.200
     4.040    -1.104     0.200
     4.583    -1.314     0.200
     4.909    -1.863     0.200
     5.140    -1.268     0.200
     5.140    -3.869     0.200
     5.983    -2.193     0.200
     6.368    -3.419     0.200
     6.373    -2.468     0.200
     6.601    -2.399     0.200
     7.145    -2.048     0.200
     7.323    -3.872     0.200
    10.929    -2.765     0.200
    11.068    -4.910     0.200
     2.519    -1.188     0.200
     3.635    -1.261     0.200
     3.942    -0.691     0.200
     4.048    -1.144     0.200
     4.576    -2.090     0.200
     4.900    -1.151     0.200
     5.130    -1.972     0.200
     5.974    -2.999     0.200
     6.359    -2.723     0.200
     6.364    -3.688     0.200
     6.592    -3.402     0.200
     7.139    -2.655     0.200
     7.313    -3.764     0.200
     2.523    -1.021     0.200
     3.631    -1.842     0.200
     3.936    -1.394     0.200
     4.053    -1.399     0.200
     4.572    -1.974     0.200
     5.123    -2.531     0.200
     7.303    -3.224     0.200
     2.519    -1.501     0.200
     3.314    -1.810     0.200
     3.636    -0.909     0.200
     3.943    -0.747     0.200
     4.047    -2.737     0.200
     4.577    -2.237     0.200
     4.901    -1.223     0.200
     5.132    -1.534     0.200
     5.975    -2.158     0.200
     6.360    -3.285     0.200
     6.365    -2.645     0.200
     7.315    -2.333     0.200
     2.500    -1.544     0.200
     3.628    -1.511     0.200
     3.941    -1.317     0.200
     4.052    -2.042     0.200
     4.569    -2.234     0.200
     4.913    -1.542     0.200
     5.133    -2.312     0.200
     5.976    -2.926     0.200
     6.364    -3.539     0.200
     6.361    -3.360     0.200
     6.595    -3.550     0.200
     7.161    -3.309     0.200
     7.328    -3.485     0.200
     2.501    -1.538     0.200
     3.303    -0.480     0.200
     3.626    -1.508     0.200
     3.938    -0.584     0.200
     4.054    -2.181     0.200
     4.567    -2.031     0.200
     4.909    -0.567     0.200
     5.129    -1.265     0.200
     5.129    -2.265     0.200
     5.972    -1.580     0.200
     6.358    -3.413     0.200
     6.361    -3.302     0.200
     6.873    -1.633     0.200
     7.170    -4.047     0.200
     7.158    -3.759     0.200
     7.323    -4.509     0.200
     7.351    -2.975     0.200
     7.459    -4.601     0.200
     7.717    -4.190     0.200
     7.840    -2.489     0.200
     8.439   -11.157     0.200
     8.731    -3.925     0.200
     8.981    -4.361     0.200
     9.442    -6.084     0.200
     9.943    -5.445     0.200
    10.417    -5.468     0.200
    10.649    -5.046     0.200
    10.831    -6.298     0.200
    11.038    -6.556     0.200
    11.087    -3.827     0.200
    15.156    -5.583     0.200
    18.673    -9.366     0.200
    18.600    -7.810     0.200
     3.306    -1.396     0.200
     3.630    -1.852     0.200
     3.945    -1.346     0.200
     4.049    -3.528     0.200
     4.571    -1.972     0.200
     4.923    -2.350     0.200
     5.139    -1.793     0.200
     5.982    -2.303     0.200
     6.369    -3.579     0.200
     7.172    -4.338     0.200
     7.338    -4.501     0.200
     2.509    -1.488     0.200
     3.328    -0.660     0.200
     3.652    -1.421     0.200
     3.966    -1.096     0.200
     4.027    -2.919     0.200
     4.592    -2.138     0.200
     4.936    -1.049     0.200
     5.159    -1.715     0.200
     6.002    -3.624     0.200
     6.388    -3.357     0.200
     6.390    -2.727     0.200
     6.621    -2.749     0.200
     7.350    -3.967     0.200
     2.599    -2.228     0.200
     2.599    -2.428     0.200
     2.698    -0.885     0.200
     3.630    -2.832     0.200
     3.630    -2.731     0.200
     3.697    -0.745     0.200
     3.697    -1.046     0.200
     4.039    -1.591     0.200
     4.039    -2.790     0.200
     4.421    -2.392     0.200
     4.421    -3.291     0.200
     4.974    -2.210     0.200
     5.436    -1.761     0.200
     5.643    -1.825     0.200
     5.911    -0.911     0.200
     6.850    -3.080     0.200
     7.194    -1.852     0.200
     7.482    -3.315     0.200
     7.843    -4.077     0.200
     7.876    -2.304     0.200
     7.958    -3.723     0.200
     8.232    -2.912     0.200
     8.363    -3.363     0.200
    11.008    -8.878     0.200
    18.072    -9.997     0.200
    18.562    -6.988     0.200
    19.141    -4.801     0.200
     2.514    -1.063     0.200
     3.317    -1.024     0.200
     3.639    -1.540     0.200
     3.949    -0.968     0.200
     4.042    -1.906     0.200
     4.580    -2.263     0.200
     4.912    -1.197     0.200
     5.139    -2.203     0.200
     5.982    -2.721     0.200
     6.368    -2.949     0.200
     6.372    -2.777     0.200
     7.151    -2.673     0.200
     7.326    -3.121     0.200
     3.497    -0.783     0.200
     3.831    -2.255     0.200
     3.836    -2.621     0.200
     4.209    -1.828     0.200
     4.772    -2.094     0.200
     5.256    -1.127     0.200
     5.430    -2.456     0.200
     6.637    -3.611     0.200
     7.131    -1.204     0.200
     7.418    -2.854     0.200
     7.670    -4.349     0.200
     7.745    -4.842     0.200
     8.152    -3.431     0.200
     2.530    -1.398     0.200
     3.361    -0.747     0.200
     3.685    -2.020     0.200
     3.993    -3.371     0.200
     4.000    -1.211     0.200
     4.626    -2.633     0.200
     4.960    -1.437     0.200
     5.192    -1.995     0.200
     6.035    -3.713     0.200
     6.421    -2.842     0.200
     6.654    -2.729     0.200
     7.172    -3.837     0.200
     2.554    -1.216     0.200
     3.373    -0.381     0.200
     3.696    -1.408     0.200
     3.985    -1.992     0.200
     4.004    -1.194     0.200
     4.637    -1.832     0.200
     6.861    -1.307     0.200
     8.391   -10.650     0.200
    11.030    -3.447     0.200
    10.974    -6.914     0.200
     2.595    -2.005     0.200
     2.689    -0.385     0.200
     2.872    -0.576     0.200
     3.639    -2.089     0.200
     3.689    -1.463     0.200
     4.030    -2.397     0.200
     4.411    -1.166     0.200
     4.965    -2.822     0.200
     5.425    -1.419     0.200
     5.632    -2.182     0.200
     5.914    -2.719     0.200
     6.472    -3.904     0.200
     6.840    -3.052     0.200
     6.935    -4.189     0.200
     7.096    -3.764     0.200
     2.509     0.070     0.200
     2.576    -1.464     0.200
     3.415    -1.265     0.200
     3.739    -1.723     0.200
     3.941    -1.010     0.200
     4.050    -1.185     0.200
     4.680    -1.743     0.200
     5.238    -1.837     0.200
     6.467    -2.490     0.200
     6.473    -4.084     0.200
     6.699    -3.660     0.200
     7.157    -3.161     0.200
     2.518    -1.522     0.200
     3.344    -1.006     0.200
     3.668    -1.375     0.200
     3.983    -1.070     0.200
     4.010    -2.321     0.200
     4.609    -2.192     0.200
     4.949    -2.090     0.200
     5.176    -1.777     0.200
     6.019    -2.692     0.200
     6.405    -2.924     0.200
     6.407    -2.797     0.200
     6.638    -3.514     0.200
     6.887    -0.231     0.200
     7.172    -2.866     0.200
     7.216    -3.958     0.200
     7.363    -2.790     0.200
     7.397    -3.484     0.200
     7.505    -3.306     0.200
     7.764    -4.302     0.200
     7.833    -3.408     0.200
     7.886    -3.900     0.200
     8.384    -4.384     0.200
     8.777    -5.234     0.200
     8.853    -4.432     0.200
     9.489    -6.371     0.200
    10.969    -4.354     0.200
    11.066    -5.103     0.200
    18.554    -7.676     0.200
    18.676    -5.810     0.200
    18.850    -4.905     0.200
     2.520    -1.713     0.200
     3.336    -0.576     0.200
     3.659    -1.922     0.200
     3.972    -1.124     0.200
     4.020    -2.265     0.200
     4.600    -1.641     0.200
     4.934    -2.020     0.200
     5.163    -2.083     0.200
     6.006    -2.603     0.200
     6.391    -3.230     0.200
     6.395    -3.240     0.200
     6.624    -4.116     0.200
     6.876    -0.436     0.200
     7.161    -3.816     0.200
     7.203    -3.767     0.200
     7.347    -4.423     0.200
     7.383    -3.570     0.200
     7.492    -3.733     0.200
     7.750    -3.803     0.200
     7.820    -3.917     0.200
     7.873    -3.589     0.200
     8.218    -4.718     0.200
     8.372    -5.800     0.200
     8.764    -5.553     0.200
     8.841    -4.768     0.200
     9.476    -5.472     0.200
    10.954    -3.877     0.200
    18.568   -11.147     0.200
    18.683    -5.623     0.200
     2.520    -1.403     0.200
     3.324    -0.487     0.200
     3.646    -1.703     0.200
     3.956    -0.806     0.200
     4.035    -1.909     0.200
     4.587    -2.028     0.200
     5.145    -1.718     0.200
     7.328    -2.216     0.200
     2.792    -2.803     0.200
     2.755    -0.726     0.200
     2.884    -1.016     0.200
     3.572    -3.618     0.200
     4.100    -2.051     0.200
     4.425    -1.378     0.200
     5.039    -2.128     0.200
     5.289    -1.855     0.200
     5.611    -2.973     0.200
     5.729    -2.414     0.200
     6.848    -4.386     0.200
     6.933    -2.957     0.200
     7.237    -3.194     0.200
     2.505    -1.340     0.200
     3.332    -0.747     0.200
     3.656    -1.628     0.200
     4.021    -1.804     0.200
     3.973    -0.884     0.200
     3.973    -1.184     0.200
     4.947    -2.362     0.200
     6.895    -4.127     0.200
    10.964    -3.442     0.200
     3.311    -1.035     0.200
     3.635    -2.125     0.200
     3.955    -1.543     0.200
     4.576    -2.137     0.200
     5.151    -3.157     0.200
     6.102    -3.131     0.200
     6.903    -2.167     0.200
     9.462    -7.670     0.200
    11.099    -6.345     0.200
    10.952    -5.267     0.200
     2.507    -1.252     0.200
     3.303    -1.071     0.200
     3.625    -0.877     0.200
     3.934    -0.670     0.200
     4.565    -2.303     0.200
     4.899    -1.375     0.200
     5.124    -1.199     0.200
     5.967    -3.521     0.200
     6.095    -2.175     0.200
     6.356    -3.076     0.200
     2.596    -2.044     0.200
     2.687    -0.109     0.200
     3.686    -1.400     0.200
     3.930    -2.791     0.200
     4.028    -1.626     0.200
     4.407    -1.556     0.200
     4.962    -2.255     0.200
     5.628    -2.460     0.200
     5.914    -2.701     0.200
     6.468    -3.278     0.200
     6.836    -3.542     0.200
     6.856    -3.266     0.200
     6.931    -3.172     0.200
     2.600    -1.896     0.200
     2.689    -0.821     0.200
     2.870    -0.453     0.200
     3.689    -2.017     0.200
     4.030    -2.040     0.200
     4.409    -1.948     0.200
     4.965    -1.773     0.200
     5.419    -1.570     0.200
     5.630    -2.134     0.200
     5.910    -2.920     0.200
     6.470    -4.060     0.200
     6.838    -4.335     0.200
     6.857    -3.844     0.200
     6.933    -3.659     0.200
     7.467    -3.194     0.200
     2.509    -1.865     0.200
     2.509    -0.865     0.200
     3.319    -0.515     0.200
     3.642    -2.052     0.200
     3.954    -0.544     0.200
     3.954    -1.144     0.200
     4.361    -2.104     0.200
     4.582    -1.675     0.200
     4.921    -0.603     0.200
     5.145    -2.519     0.200
     5.988    -2.535     0.200
     6.374    -2.466     0.200
     6.377    -3.461     0.200
     6.462    -2.772     0.200
     6.875    -1.520     0.200
     7.160    -4.173     0.200
     7.186    -4.500     0.200
     7.335    -4.326     0.200
     8.425    -8.144     0.200
     9.458    -7.224     0.200
    11.077    -1.917     0.200
     2.723    -0.308     0.200
     3.188    -0.742     0.200
     3.535    -1.649     0.200
     3.938    -0.904     0.200
     3.958    -1.939     0.200
     4.466    -2.363     0.200
     7.312    -1.807     0.200
     8.399    -4.838     0.200
     8.788    -6.171     0.200
     8.839    -5.171     0.200
     9.034    -6.448     0.200
     9.486    -6.818     0.200
     9.486    -6.287     0.200
     9.958    -6.038     0.200
    10.499    -5.191     0.200
    10.834    -6.617     0.200
    10.870    -5.655     0.200
    10.995    -6.627     0.200
    11.132    -4.249     0.200
    11.443    -4.693     0.200
    15.561    -7.917     0.200
    18.245    -6.454     0.200
    18.483   -10.077     0.200
    18.625    -2.924     0.200
    20.521     0.306     0.200
    22.724     1.140     0.200
    23.625     0.574     0.200
     2.718     0.159     0.200
     2.718    -0.043     0.200
     3.174    -0.518     0.200
     3.521    -0.803     0.200
     3.941    -0.715     0.200
     4.453    -1.832     0.200
     5.186    -1.970     0.200
     5.197    -1.838     0.200
     6.030    -3.549     0.200
     6.370    -2.326     0.200
     6.420    -4.307     0.200
     6.477    -4.119     0.200
     6.660    -4.012     0.200
     7.614    -3.354     0.200
     8.254    -8.809     0.200
     2.720     0.387     0.200
     3.188    -0.647     0.200
     3.535    -1.147     0.200
     3.956    -1.107     0.200
     4.466    -1.767     0.200
     5.213    -1.946     0.200
     5.200    -0.947     0.200
     6.046    -2.453     0.200
     6.386    -3.819     0.200
     6.436    -2.413     0.200
     6.493    -3.718     0.200
     6.676    -3.819     0.200
     7.629    -2.624     0.200
     2.724    -0.056     0.200
     2.724    -0.657     0.200
     3.176    -0.369     0.200
     3.522    -1.469     0.200
     3.936    -1.615     0.200
     3.944    -1.535     0.200
     4.454    -2.189     0.200
     5.192    -1.201     0.200
     7.307    -0.721     0.200
     7.455    -2.636     0.200
     7.591    -3.853     0.200
     7.621    -3.287     0.200
     7.790    -3.560     0.200
     7.938    -4.333     0.200
     8.386    -4.233     0.200
     8.775    -5.365     0.200
     8.825    -4.268     0.200
     9.020    -6.042     0.200
     9.472    -6.839     0.200
     9.472    -5.783     0.200
     9.944    -6.236     0.200
    10.485    -7.083     0.200
    10.821    -6.918     0.200
    10.857    -4.873     0.200
    10.982    -6.637     0.200
    11.119    -3.304     0.200
    18.244    -2.978     0.200
     2.701    -0.269     0.200
     3.178    -1.061     0.200
     3.523    -1.418     0.200
     3.939    -1.594     0.200
     4.455    -1.965     0.200
     5.174    -0.537     0.200
     5.193    -2.150     0.200
     6.027    -2.873     0.200
     6.369    -3.414     0.200
     6.384    -2.018     0.200
     7.602    -3.204     0.200
     2.726    -0.897     0.200
     3.173    -1.067     0.200
     3.520    -1.262     0.200
     3.934    -2.464     0.200
     3.942    -1.636     0.200
     4.451    -2.087     0.200
     6.371    -3.552     0.200
     6.422    -2.561     0.200
     6.478    -2.957     0.200
     6.662    -3.366     0.200
     7.308    -2.556     0.200
     7.453    -4.251     0.200
     7.490    -4.337     0.200
     7.739    -4.412     0.200
     7.936    -3.744     0.200
     8.772    -4.871     0.200
    11.117    -2.515     0.200
    11.451    -2.657     0.200
    15.566    -3.099     0.200
    18.243    -8.332     0.200
    18.611    -4.176     0.200
     2.706    -0.461     0.200
     3.172    -0.342     0.200
     3.518    -0.605     0.200
     3.935    -0.910     0.200
     3.952    -1.861     0.200
     4.156    -2.634     0.200
     4.450    -2.249     0.200
     5.173    -2.357     0.200
     5.189    -1.880     0.200
     6.023    -3.502     0.200
     6.364    -2.524     0.200
     6.413    -3.057     0.200
     6.471    -4.096     0.200
     6.652    -2.856     0.200
     7.286    -1.674     0.200
     7.601    -3.535     0.200
    11.103    -1.180     0.200
     2.607    -2.101     0.200
     2.709    -0.742     0.200
     2.893    -0.662     0.200
     3.620    -1.816     0.200
     3.708    -1.801     0.200
     4.050    -1.548     0.200
     4.432    -1.150     0.200
     4.984    -2.067     0.200
     5.653    -2.574     0.200
     5.902    -1.771     0.200
     6.493    -2.395     0.200
     6.860    -4.138     0.200
     6.881    -3.381     0.200
     6.956    -3.375     0.200
     7.116    -4.054     0.200
     7.851    -2.433     0.200
     2.522    -1.425     0.200
     3.309    -1.471     0.200
     3.630    -1.145     0.200
     3.935    -1.303     0.200
     4.054    -2.270     0.200
     4.571    -2.383     0.200
     4.889    -1.653     0.200
     5.122    -2.547     0.200
     5.965    -2.777     0.200
     6.083    -1.806     0.200
     6.351    -4.100     0.200
     6.357    -3.090     0.200
     6.441    -3.665     0.200
     6.584    -2.772     0.200
     7.131    -3.210     0.200
     7.163    -3.739     0.200
     2.501    -1.660     0.200
     3.306    -0.978     0.200
     3.629    -1.809     0.200
     3.941    -1.205     0.200
     4.051    -2.009     0.200
     4.355    -1.988     0.200
     5.133    -1.596     0.200
     5.976    -2.010     0.200
     6.096    -2.943     0.200
     6.362    -2.844     0.200
     6.364    -3.127     0.200
     6.450    -3.141     0.200
     6.595    -3.234     0.200
     7.160    -3.252     0.200
     7.173    -3.477     0.200
     7.327    -3.946     0.200
     7.354    -3.208     0.200
     7.462    -3.730     0.200
     7.669    -3.678     0.200
     7.844    -3.823     0.200
    10.928    -5.719     0.200
    11.087    -4.257     0.200
     3.264    -0.428     0.200
     3.585    -1.020     0.200
     3.894    -1.906     0.200
     4.097    -2.747     0.200
     4.347    -2.325     0.200
     4.526    -2.249     0.200
     4.872    -1.110     0.200
     5.085    -2.077     0.200
     5.928    -2.592     0.200
     6.314    -2.824     0.200
     6.317    -3.619     0.200
     6.402    -3.125     0.200
     7.288    -4.495     0.200
     8.480    -8.469     0.200
     9.398    -6.228     0.200
    10.883    -1.440     0.200
    15.169    -0.992     0.200
     2.563    -0.217     0.200
     3.034    -1.143     0.200
     3.343    -1.130     0.200
     3.612    -1.073     0.200
     4.284    -1.581     0.200
     4.366    -1.665     0.200
     4.368    -3.675     0.200
     4.591    -0.598     0.200
     6.732    -2.725     0.200
    11.205    -5.429     0.200
     2.532    -1.865     0.200
     2.559    -0.905     0.200
     2.731    -0.863     0.200
     3.563    -2.042     0.200
     3.765    -3.359     0.200
     3.901    -1.570     0.200
     4.271    -1.676     0.200
     4.838    -2.147     0.200
     5.292    -1.761     0.200
     3.543    -1.241     0.200
     3.872    -1.068     0.200
     4.131    -3.382     0.200
     4.483    -1.446     0.200
     4.908    -2.221     0.200
     5.077    -2.561     0.200
     6.940    -1.716     0.200
     9.383    -3.500     0.200
     3.308    -0.293     0.200
     3.308    -0.893     0.200
     3.635    -1.669     0.200
     3.635    -1.269     0.200
     3.966    -0.847     0.200
     4.037    -1.503     0.200
     4.297    -2.080     0.200
     4.575    -1.463     0.200
     4.977    -0.783     0.200
     5.169    -1.678     0.200
     6.011    -2.457     0.200
     6.122    -1.500     0.200
     6.392    -4.036     0.200
     6.397    -3.412     0.200
     6.481    -2.758     0.200
     6.631    -3.637     0.200
     6.948    -1.595     0.200
     8.380    -9.915     0.200
     9.476    -4.177     0.200
    10.982    -3.083     0.200
    18.611    -6.017     0.200
     2.727    -1.561     0.200
     3.131    -0.647     0.200
     3.131    -0.346     0.200
     3.477    -2.519     0.200
     3.477    -1.718     0.200
     3.928    -2.162     0.200
     3.896    -1.802     0.200
     4.198    -3.089     0.200
     4.409    -1.656     0.200
     5.153    -2.746     0.200
     5.151    -2.404     0.200
     5.986    -2.552     0.200
     6.325    -3.110     0.200
     6.376    -3.411     0.200
     6.432    -3.609     0.200
     7.183    -3.197     0.200
     7.292    -0.521     0.200
     7.407    -4.202     0.200
     7.444    -4.192     0.200
     7.581    -4.319     0.200
     7.742    -3.421     0.200
     7.889    -3.697     0.200
     8.295   -12.119     0.200
     8.337    -5.691     0.200
     8.726    -5.927     0.200
     8.777    -5.734     0.200
     8.972    -5.502     0.200
     9.424    -8.578     0.200
     9.424    -5.246     0.200
     9.896    -6.410     0.200
    10.437    -7.645     0.200
    10.773    -8.198     0.200
    10.935    -8.954     0.200
    11.073    -1.898     0.200
    11.469    -2.615     0.200
     2.964    -1.359     0.200
     3.392    -0.745     0.200
     3.392    -0.846     0.200
     3.420    -2.833     0.200
     3.475    -1.465     0.200
     3.475    -2.063     0.200
     4.413    -2.312     0.200
     4.735    -2.626     0.200
     5.010    -2.424     0.200
     5.583    -2.604     0.200
     6.144    -3.087     0.200
     6.767     1.487     0.200
     6.991    -3.044     0.200
     7.653    -2.000     0.200
     7.714   -10.408     0.200
     7.926    -4.273     0.200
    10.201    -4.363     0.200
    10.480    -6.845     0.200
    11.740    -5.319     0.200
     3.306    -0.345     0.200
     3.628    -1.652     0.200
     3.937    -0.934     0.200
     4.053    -2.428     0.200
     4.569    -1.775     0.200
     4.900    -1.180     0.200
     5.127    -2.654     0.200
     2.680     0.387     0.200
     3.180    -0.357     0.200
     3.524    -1.777     0.200
     3.978    -1.832     0.200
     4.148    -2.553     0.200
     4.457    -1.747     0.200
     5.156    -1.001     0.200
     5.185    -1.927     0.200
     6.019    -2.372     0.200
     6.364    -2.591     0.200
     6.371    -2.209     0.200
    11.092    -0.882     0.200
    18.288    -5.420     0.200
    18.513   -11.780     0.200
     3.119    -0.714     0.200
     3.437    -1.595     0.200
     3.737    -1.322     0.200
     4.251    -2.911     0.200
     4.378    -1.834     0.200
     4.748    -1.969     0.200
     4.929    -2.507     0.200
     5.772    -2.417     0.200
     6.160    -3.329     0.200
     6.158    -2.756     0.200
     6.245    -3.433     0.200
     6.391    -3.054     0.200
     3.126     0.262     0.200
     3.444    -0.605     0.200
     4.244    -2.174     0.200
     4.385    -0.946     0.200
     4.748     0.062     0.200
     4.934    -1.531     0.200
     5.776    -1.344     0.200
     3.119     0.496     0.200
     3.437    -1.190     0.200
     4.307    -2.491     0.200
     4.250    -2.957     0.200
     4.378    -2.127     0.200
     4.751    -1.855     0.200
     4.931    -0.855     0.200
     5.774    -2.158     0.200
     8.619   -10.215     0.200
    10.743    -1.744     0.200
    11.201    -3.763     0.200
     3.420    -1.047     0.200
     3.720    -1.639     0.200
     4.307    -3.528     0.200
     6.833    -2.079     0.200
     8.638   -10.717     0.200
    10.724    -6.927     0.200
    11.209    -3.905     0.200
     3.421    -0.382     0.200
     3.721    -1.878     0.200
     4.307    -1.009     0.200
     6.834     0.195     0.200
     7.156    -4.578     0.200
     8.637    -9.835     0.200
     8.589    -6.002     0.200
     3.434    -0.709     0.200
     3.730    -0.506     0.200
     4.322    -2.144     0.200
     6.822    -2.119     0.200
     7.632    -5.069     0.200
     8.598    -3.103     0.200
    10.727    -3.276     0.200
    11.192    -6.737     0.200
     4.299    -2.571     0.200
     4.741    -1.954     0.200
     6.145    -1.248     0.200
     6.842     0.200     0.200
     7.163    -2.521     0.200
     8.590    -4.478     0.200
     9.226    -7.770     0.200
    10.729    -3.348     0.200
    11.214    -5.329     0.200
    15.240    -7.111     0.200
    16.249   -10.162     0.200
    18.001   -12.369     0.200
    18.625    -5.252     0.200
    18.621    -4.533     0.200
    18.810    -7.593     0.200
    23.490     0.629     0.200
     3.128     0.085     0.200
     3.446    -1.210     0.200
     4.308    -2.330     0.200
     4.387    -1.949     0.200
     4.761    -1.579     0.200
     4.942    -0.216     0.200
     6.172    -1.415     0.200
     6.844    -0.155     0.200
     7.181    -2.715     0.200
     7.270    -4.218     0.200
     8.542    -2.551     0.200
     8.608   -11.570     0.200
     8.618    -4.345     0.200
     9.253    -6.337     0.200
    10.229    -4.229     0.200
    10.753    -3.238     0.200
    10.851    -4.239     0.200
    11.196    -5.411     0.200
    15.227    -7.124     0.200
    16.235   -10.337     0.200
    17.974   -12.154     0.200
    18.633    -6.132     0.200
    18.646    -2.952     0.200
    18.784    -8.381     0.200
    20.091     1.377     0.200
    23.517     0.701     0.200
     3.452    -0.610     0.200
     3.753    -0.461     0.200
     4.314    -2.561     0.200
     4.760    -2.380     0.200
     6.176    -2.964     0.200
     6.838    -1.937     0.200
     8.607   -10.473     0.200
     8.622    -2.989     0.200
     9.257    -4.924     0.200
    10.754    -3.853     0.200
    11.189    -2.766     0.200
     3.443    -1.277     0.200
     4.336    -0.438     0.200
     4.728    -1.232     0.200
     6.809    -1.988     0.200
     8.636   -10.953     0.200
     8.602    -4.042     0.200
     9.237    -2.900     0.200
    10.725    -3.134     0.200
    11.178    -3.110     0.200
    15.202    -5.934     0.200
    18.662    -4.238     0.200
     2.951    -1.995     0.200
     3.676    -1.395     0.200
     8.086    -3.909     0.200
    10.358    -6.415     0.200
    14.589    -9.416     0.200
    16.250   -10.874     0.200
    16.935   -11.548     0.200
    17.593    -4.754     0.200
    18.231    -4.737     0.200
    19.796    -5.345     0.200
    24.157    -4.344     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
    16.142  -120.369     0.200
    16.142  -116.869     0.200
    18.687  -126.665     0.200
    22.006  -149.476     0.200
    18.567  -128.651     0.200
    15.943  -114.113     0.200
    18.531  -129.167     0.200
     2.566    -7.619     0.200
     3.781   -18.732     0.200
     1.863     0.620     0.200
     3.133    -9.634     0.200
     4.401   -20.816     0.200
     4.818   -21.845     0.200
     4.870   -23.701     0.200
     5.635   -33.953     0.200
     7.293   -43.015     0.200
     5.019   -26.948     0.200
     5.279   -23.988     0.200
     5.461   -29.446     0.200
     6.112   -33.898     0.200
     7.579   -47.090     0.200
     7.792   -44.836     0.200
     8.142   -50.918     0.200
    15.928  -113.250     0.200
     2.197    -4.874     0.200
     2.701    -7.850     0.200
     3.131   -15.489     0.200
     3.933   -16.918     0.200
     4.874   -22.156     0.200
     5.007   -22.160     0.200
     5.132   -23.913     0.200
     5.432   -29.120     0.200
     6.090   -35.477     0.200
     7.533   -45.723     0.200
     1.455     1.635     0.200
     1.645     0.607     0.200
     1.708    -0.295     0.200
     2.249    -5.818     0.200
     3.971   -17.818     0.200
     3.073   -13.815     0.200
     5.400   -30.573     0.200
    17.487  -115.734     0.200
    18.892  -131.281     0.200
     2.676    -7.273     0.200
     3.647   -14.561     0.200
     4.557   -23.612     0.200
     5.473   -30.944     0.200
     5.612   -30.541     0.200
     7.920   -52.003     0.200
     5.313   -28.250     0.200
     7.087   -43.795     0.200
     7.728   -48.893     0.200
     7.786   -47.633     0.200
    10.706   -72.099     0.200
    12.147   -83.085     0.200
    14.183  -102.039     0.200
    15.269  -114.347     0.200
    15.275  -107.048     0.200
    16.663  -113.535     0.200
    20.985  -144.561     0.200
     5.449   -29.873     0.200
     2.453    -7.449     0.200
     2.574    -6.962     0.200
     4.222   -20.623     0.200
     5.487   -29.363     0.200
     2.572    -9.076     0.200
     3.838   -20.006     0.200
     5.286   -27.200     0.200
     3.857   -19.569     0.200
     2.453    -7.076     0.200
     4.228   -20.332     0.200
     4.780   -21.734     0.200
     2.679   -11.262     0.200
     3.835   -16.984     0.200
     4.793   -25.522     0.200
     2.696    -8.888     0.200
     1.209     3.813     0.200
     1.792    -0.689     0.200
     1.792     0.010     0.200
     1.811     0.206     0.200
     2.574    -6.957     0.200
     3.979   -18.418     0.200
     4.489   -21.185     0.200
     5.329   -26.509     0.200
     6.053   -35.980     0.200
     7.744   -47.455     0.200
     9.136   -59.094     0.200
     9.136   -56.094     0.200
    10.262   -65.290     0.200
    13.718   -90.347     0.200
    20.467  -140.289     0.200
     2.526    -8.056     0.200
     3.827   -20.190     0.200
     5.309   -29.870     0.200
     7.726   -48.572     0.200
     2.524    -8.731     0.200
     3.818   -20.031     0.200
     4.753   -23.671     0.200
     5.299   -28.487     0.200
     5.439   -29.427     0.200
     3.857   -16.520     0.200
     2.635    -7.468     0.200
     2.505    -6.312     0.200
     2.810   -11.474     0.200
     3.956   -16.810     0.200
     4.348   -21.115     0.200
     4.891   -28.225     0.200
     5.407   -30.491     0.200
     5.577   -31.589     0.200
     7.819   -44.056     0.200
     9.227   -56.499     0.200
     1.259     2.753     0.200
     2.442    -7.158     0.200
     2.513    -8.300     0.200
     5.515   -27.303     0.200
     7.759   -47.346     0.200
     1.742     1.228     0.200
     1.731     0.565     0.200
     2.633    -7.021     0.200
     4.919   -23.324     0.200
     2.866   -12.657     0.200
     3.233   -15.208     0.200
     3.953   -20.820     0.200
     4.755   -23.652     0.200
     5.933   -34.484     0.200
     6.023   -34.132     0.200
     9.635   -60.833     0.200
    11.755   -80.861     0.200
     2.665    -9.836     0.200
     2.692    -6.809     0.200
     3.911   -17.350     0.200
     4.234   -19.671     0.200
     4.852   -24.279     0.200
     2.252    -3.186     0.200
     2.341    -5.238     0.200
     3.621   -16.997     0.200
     4.562   -21.838     0.200
     7.362   -46.580     0.200
     2.439    -5.811     0.200
     3.459   -14.841     0.200
     4.400   -17.774     0.200
     5.002   -23.749     0.200
     2.304    -6.900     0.200
     2.467    -7.387     0.200
     3.402   -14.416     0.200
     3.735   -19.885     0.200
     4.092   -20.082     0.200
     4.829   -23.842     0.200
     4.948   -26.016     0.200
     6.162   -35.908     0.200
     7.266   -43.017     0.200
     2.139    -5.066     0.200
     2.333    -7.910     0.200
     2.430    -7.307     0.200
     3.365   -14.349     0.200
     4.307   -21.217     0.200
     4.747   -24.740     0.200
     4.883   -23.366     0.200
     7.171   -42.701     0.200
     2.111    -5.498     0.200
     2.351    -7.728     0.200
     2.409    -5.958     0.200
     3.348   -15.013     0.200
     4.290   -22.096     0.200
     4.702   -19.653     0.200
     4.849   -24.026     0.200
     2.297    -4.150     0.200
     2.353    -4.530     0.200
     3.551   -15.304     0.200
     3.894   -16.178     0.200
     4.492   -21.113     0.200
     6.321   -34.515     0.200
     8.417   -51.032     0.200
    18.236  -120.600     0.200
     1.415     1.056     0.200
     2.717   -10.004     0.200
     4.906   -25.010     0.200
     5.449   -28.206     0.200
    10.734   -66.136     0.200
     1.675    -1.185     0.200
     2.838    -9.068     0.200
     5.169   -27.256     0.200
     2.210    -5.096     0.200
     2.652    -8.698     0.200
     3.850   -16.691     0.200
     4.162   -19.760     0.200
     5.062   -25.594     0.200
     1.684    -0.779     0.200
     1.685     0.399     0.200
     2.304    -4.732     0.200
     2.842   -11.188     0.200
     3.081   -12.768     0.200
     4.267   -19.274     0.200
     4.267   -18.974     0.200
     4.622   -22.029     0.200
     5.164   -28.607     0.200
     5.667   -30.724     0.200
     5.823   -31.968     0.200
     7.049   -41.833     0.200
     2.564    -5.245     0.200
     3.570   -15.339     0.200
     3.953   -18.454     0.200
     5.802   -32.581     0.200
     1.747    -0.208     0.200
     2.597    -8.761     0.200
     2.825    -9.586     0.200
     3.252   -13.325     0.200
     4.777   -24.356     0.200
     5.426   -34.129     0.200
     2.183    -5.162     0.200
     2.778   -10.427     0.200
     5.000   -27.260     0.200
     2.858    -8.703     0.200
     3.254   -13.036     0.200
     3.254   -13.835     0.200
     4.756   -27.650     0.200
     5.180   -25.599     0.200
     5.295   -28.755     0.200
     6.375   -37.486     0.200
     7.542   -46.701     0.200
     7.606   -45.200     0.200
     8.344   -52.415     0.200
     9.978   -64.199     0.200
    11.186   -71.605     0.200
     2.663    -7.641     0.200
     2.895    -7.989     0.200
     3.444   -15.587     0.200
     4.722   -26.307     0.200
     2.859    -7.106     0.200
     3.406   -14.337     0.200
     3.662   -16.558     0.200
     3.919   -18.629     0.200
     4.343   -20.851     0.200
     5.144   -25.456     0.200
     5.459   -29.429     0.200
     5.931   -30.893     0.200
     7.258   -45.974     0.200
     3.313   -12.559     0.200
     4.529   -20.900     0.200
     4.510   -22.406     0.200
     4.685   -21.331     0.200
     6.944   -39.951     0.200
     3.225   -12.151     0.200
     3.595   -15.483     0.200
     4.826   -28.521     0.200
     2.749   -12.188     0.200
     3.958   -21.192     0.200
     4.304   -22.788     0.200
     4.706   -24.520     0.200
     5.250   -32.350     0.200
     1.884     0.154     0.200
     1.712     0.440     0.200
     1.964     0.539     0.200
     2.990   -11.873     0.200
     3.028   -12.588     0.200
     4.249   -18.884     0.200
     4.527   -20.598     0.200
     3.527   -15.697     0.200
     4.025   -18.967     0.200
     4.388   -22.894     0.200
     4.533   -23.370     0.200
     4.853   -24.609     0.200
     5.046   -26.024     0.200
     6.474   -33.518     0.200
     6.725   -39.156     0.200
     7.434   -43.621     0.200
     7.754   -49.993     0.200
     8.956   -56.688     0.200
     2.259    -5.707     0.200
     2.259    -5.308     0.200
     3.645   -17.449     0.200
     3.947   -16.532     0.200
     3.947   -17.828     0.200
     4.587   -22.014     0.200
     4.891   -22.961     0.200
     6.369   -37.601     0.200
     7.134   -40.654     0.200
     7.304   -42.340     0.200
     1.637     0.303     0.200
     2.792    -9.687     0.200
     2.878    -9.239     0.200
     3.354   -13.814     0.200
     3.729   -15.712     0.200
     3.883   -17.986     0.200
     4.582   -21.045     0.200
     5.717   -31.722     0.200
     5.787   -31.235     0.200
     7.663   -47.506     0.200
     1.642     0.682     0.200
     2.313    -4.796     0.200
     2.806    -9.639     0.200
     3.039   -11.616     0.200
     4.580   -22.473     0.200
     5.162   -28.605     0.200
     5.703   -31.553     0.200
     7.006   -42.186     0.200
     7.880   -48.871     0.200
     2.396    -6.206     0.200
     2.530    -7.448     0.200
     5.372   -28.241     0.200
     2.292    -5.848     0.200
     2.592    -7.051     0.200
     3.829   -17.169     0.200
     2.505    -7.887     0.200
     2.499    -6.414     0.200
     2.499    -6.617     0.200
     3.596   -13.570     0.200
     3.733   -13.620     0.200
     3.938   -17.624     0.200
     3.938   -18.319     0.200
     4.327   -20.859     0.200
     5.556   -29.511     0.200
     2.454    -6.383     0.200
     2.499    -8.394     0.200
     3.840   -16.118     0.200
     4.092   -17.382     0.200
     4.222   -18.729     0.200
     5.291   -27.399     0.200
     5.449   -28.229     0.200
     6.064   -36.799     0.200
     7.462   -47.312     0.200
     7.761   -46.618     0.200
     8.069   -52.291     0.200
    11.292   -71.873     0.200
     2.505    -6.392     0.200
     3.826   -16.288     0.200
     3.843   -16.502     0.200
     4.229   -19.938     0.200
     4.229   -20.840     0.200
     5.306   -25.879     0.200
     5.306   -25.680     0.200
     5.458   -29.008     0.200
     6.658   -38.242     0.200
     1.261     3.005     0.200
     2.452    -8.839     0.200
     2.499    -6.036     0.200
     3.507   -12.994     0.200
     3.821   -16.726     0.200
     4.233   -20.405     0.200
     5.462   -27.248     0.200
     1.159     3.333     0.200
     2.473    -7.013     0.200
     2.535    -8.292     0.200
     5.096   -26.557     0.200
     5.606   -31.140     0.200
     7.294   -45.245     0.200
     2.462    -6.976     0.200
     3.823   -20.105     0.200
     4.225   -18.765     0.200
     5.568   -32.234     0.200
     2.481    -6.095     0.200
     3.821   -15.875     0.200
     5.586   -32.812     0.200
     2.462    -8.581     0.200
     2.626    -7.375     0.200
     3.797   -18.510     0.200
     4.166   -20.082     0.200
     2.477    -5.484     0.200
     2.646    -6.736     0.200
     3.807   -16.565     0.200
     3.807   -16.764     0.200
     4.110   -19.151     0.200
     4.110   -18.050     0.200
     4.184   -21.315     0.200
     5.409   -28.248     0.200
     5.593   -33.380     0.200
     6.078   -34.431     0.200
     6.613   -39.707     0.200
     8.111   -48.178     0.200
     1.277     2.390     0.200
     2.450    -7.890     0.200
     7.751   -48.310     0.200
     8.026   -52.643     0.200
     1.257     3.801     0.200
     2.452    -5.990     0.200
     2.495    -6.337     0.200
     4.092   -17.267     0.200
     4.227   -20.354     0.200
     7.714   -44.972     0.200
     7.714   -45.074     0.200
     1.246     3.595     0.200
     2.500    -6.703     0.200
     4.097   -18.030     0.200
     5.299   -25.243     0.200
     5.453   -27.729     0.200
     7.764   -44.890     0.200
     8.062   -50.233     0.200
    15.749  -113.299     0.200
    18.256  -129.166     0.200
     1.238     2.790     0.200
     5.277   -28.569     0.200
     5.432   -27.092     0.200
     8.084   -49.154     0.200
     2.451    -7.357     0.200
     4.214   -21.341     0.200
     2.167    -4.140     0.200
     2.696    -8.510     0.200
     3.881   -17.573     0.200
     4.184   -19.064     0.200
     5.433   -30.435     0.200
     8.157   -50.486     0.200
     3.837   -19.595     0.200
     3.832   -16.828     0.200
     3.832   -18.227     0.200
     4.105   -19.890     0.200
     4.217   -23.641     0.200
     5.446   -30.106     0.200
     7.459   -48.707     0.200
     4.202   -20.454     0.200
     1.411     3.543     0.200
     4.172   -16.990     0.200
     1.286     3.337     0.200
     2.719    -8.768     0.200
     1.630     0.406     0.200
     2.320    -5.272     0.200
     1.633     0.440     0.200
     1.633    -0.060     0.200
     2.311    -4.560     0.200
     3.723   -14.709     0.200
     3.723   -14.509     0.200
     4.215   -18.824     0.200
     5.153   -28.244     0.200
     1.283     3.728     0.200
     1.708     0.547     0.200
     2.951   -10.157     0.200
     3.249   -12.920     0.200
     6.252   -35.889     0.200
     6.876   -40.391     0.200
     3.021   -10.279     0.200
     3.463   -14.381     0.200
     3.739   -15.324     0.200
     4.204   -20.169     0.200
     5.141   -27.585     0.200
     5.225   -28.527     0.200
     5.766   -28.087     0.200
     6.989   -41.953     0.200
     2.590    -7.111     0.200
     4.771   -23.638     0.200
     5.178   -24.346     0.200
     1.331     3.261     0.200
     2.478    -6.504     0.200
     3.816   -17.789     0.200
     3.816   -16.187     0.200
     4.759   -23.681     0.200
     5.403   -34.115     0.200
     3.819   -16.387     0.200
     3.900   -13.760     0.200
     5.400   -30.407     0.200
    10.501   -66.315     0.200
     3.560   -14.443     0.200
     3.892   -15.961     0.200
     4.929   -24.846     0.200
     7.349   -45.540     0.200
     3.563   -14.964     0.200
     3.897   -18.530     0.200
     7.356   -43.787     0.200
     2.209    -5.849     0.200
     2.390    -5.293     0.200
     2.389    -4.672     0.200
     4.923   -23.411     0.200
     2.204    -3.936     0.200
     2.204    -4.533     0.200
     3.635   -15.107     0.200
     4.057   -17.386     0.200
     4.566   -20.629     0.200
     3.562   -14.901     0.200
     4.503   -21.026     0.200
     4.935   -23.921     0.200
     7.354   -42.118     0.200
    10.787   -66.344     0.200
     1.648     1.069     0.200
     1.648     0.670     0.200
     1.650    -0.183     0.200
     3.045   -11.009     0.200
     3.436   -10.712     0.200
     3.710   -15.691     0.200
     4.141   -18.867     0.200
     4.231   -19.101     0.200
     6.755   -38.640     0.200
     7.819   -49.959     0.200
     1.517     0.443     0.200
     1.517     0.341     0.200
     2.494    -7.726     0.200
     2.698    -9.111     0.200
     2.698    -8.205     0.200
     2.769    -8.846     0.200
     2.769    -8.042     0.200
     3.005    -9.542     0.200
     3.606   -15.290     0.200
     3.745   -15.888     0.200
     4.141   -20.449     0.200
     4.098   -20.267     0.200
     4.535   -20.932     0.200
     5.787   -30.041     0.200
     7.696   -50.550     0.200
     7.696   -49.074     0.200
     7.749   -45.009     0.200
    10.063   -63.583     0.200
    11.073   -68.685     0.200
     1.522     0.210     0.200
     1.522     2.510     0.200
     2.490    -8.567     0.200
     2.711    -8.284     0.200
     2.711    -9.084     0.200
     3.605   -13.626     0.200
     4.101   -18.066     0.200
     1.004     4.608     0.200
     3.558   -14.954     0.200
     4.499   -20.680     0.200
     3.563   -13.071     0.200
     3.800   -13.401     0.200
     3.918   -16.134     0.200
     3.885   -16.578     0.200
     3.885   -16.379     0.200
     5.043   -24.593     0.200
     6.203   -34.859     0.200
     6.603   -39.346     0.200
     7.178   -40.182     0.200
     8.271   -50.307     0.200
     3.867   -17.366     0.200
     3.867   -18.565     0.200
     4.174   -18.696     0.200
     5.422   -33.872     0.200
     6.595   -40.353     0.200
     2.536    -5.916     0.200
     3.557   -13.086     0.200
     3.804   -13.541     0.200
     3.804   -15.940     0.200
     3.927   -15.936     0.200
     4.181   -19.268     0.200
     4.181   -19.065     0.200
     4.821   -22.075     0.200
     4.821   -22.371     0.200
     6.202   -34.554     0.200
     6.601   -39.198     0.200
     7.694   -44.439     0.200
     8.266   -51.271     0.200
    10.825   -65.410     0.200
    11.106   -71.331     0.200
     1.342     3.365     0.200
     2.540    -6.211     0.200
     2.701    -8.298     0.200
     3.800   -17.632     0.200
     3.800   -13.433     0.200
     3.884   -16.804     0.200
     3.884   -17.706     0.200
     3.923   -16.852     0.200
     4.826   -23.268     0.200
     5.399   -32.348     0.200
     6.606   -38.292     0.200
     1.347     3.006     0.200
     2.544    -6.555     0.200
     2.706    -9.379     0.200
     3.888   -16.746     0.200
     3.888   -19.045     0.200
     4.189   -18.478     0.200
     4.830   -24.908     0.200
     5.365   -29.570     0.200
     6.210   -34.839     0.200
     6.609   -39.499     0.200
     6.609   -39.298     0.200
     7.454   -42.582     0.200
     7.702   -44.040     0.200
     8.066   -49.087     0.200
     8.261   -51.675     0.200
     1.012     4.055     0.200
     1.454     0.921     0.200
     2.421    -6.619     0.200
     3.572   -15.515     0.200
     1.310     3.078     0.200
     2.465    -5.549     0.200
     2.502    -7.606     0.200
     3.773   -15.195     0.200
     3.773   -15.395     0.200
     3.800   -14.673     0.200
     3.896   -17.398     0.200
     4.275   -19.415     0.200
     4.422   -21.882     0.200
     7.059   -38.592     0.200
     1.667    -0.145     0.200
     2.022    -4.914     0.200
     2.488    -6.091     0.200
     5.908   -35.283     0.200
     2.527    -6.433     0.200
     3.871   -17.233     0.200
     3.871   -18.432     0.200
     4.176   -19.003     0.200
     6.597   -39.349     0.200
     2.434    -6.085     0.200
     2.474    -5.767     0.200
     2.645    -7.866     0.200
     3.818   -17.252     0.200
     5.565   -36.052     0.200
     7.638   -45.751     0.200
     2.421    -5.451     0.200
     2.488    -7.160     0.200
     2.639    -7.768     0.200
     3.851   -18.873     0.200
     3.865   -16.223     0.200
     3.816   -16.669     0.200
     4.525   -22.739     0.200
     5.560   -32.272     0.200
     6.041   -33.591     0.200
     7.625   -43.813     0.200
     2.427    -5.315     0.200
     2.468    -5.429     0.200
     2.481    -6.842     0.200
     2.636    -7.257     0.200
     3.812   -17.213     0.200
     3.761   -15.207     0.200
     3.870   -17.451     0.200
     4.176   -19.873     0.200
     4.749   -21.539     0.200
     5.212   -26.617     0.200
     7.382   -44.830     0.200
     7.626   -46.835     0.200
     7.626   -43.937     0.200
     8.140   -50.321     0.200
    10.682   -65.813     0.200
    15.842  -116.281     0.200
     2.438    -5.828     0.200
     2.474    -6.664     0.200
     2.468    -5.585     0.200
     2.639    -7.999     0.200
     2.639    -6.600     0.200
     3.762   -15.218     0.200
     3.872   -16.600     0.200
     5.221   -26.559     0.200
     5.398   -27.464     0.200
     7.635   -43.191     0.200
    10.686   -67.995     0.200
     2.803   -10.020     0.200
     3.530   -14.358     0.200
     5.526   -29.646     0.200
     6.371   -36.720     0.200
     6.772   -39.211     0.200
     8.121   -50.791     0.200
     3.533   -14.623     0.200
     3.783   -16.963     0.200
     4.042   -19.967     0.200
     4.984   -25.716     0.200
     5.521   -29.455     0.200
     8.128   -51.074     0.200
     1.194     0.432     0.200
     2.667    -8.169     0.200
     3.484   -17.074     0.200
     3.203   -11.953     0.200
     9.613   -63.362     0.200
     1.210     1.316     0.200
     1.210     1.117     0.200
     2.913   -10.154     0.200
     2.990   -12.500     0.200
     3.273   -12.967     0.200
     4.721   -28.774     0.200
     5.254   -27.377     0.200
     5.641   -29.732     0.200
     9.651   -63.135     0.200
     2.472    -5.702     0.200
     2.493    -6.868     0.200
     2.547    -6.872     0.200
     2.730    -8.180     0.200
     3.780   -16.968     0.200
     3.808   -17.467     0.200
     3.888   -18.001     0.200
     3.888   -17.306     0.200
     4.269   -20.159     0.200
     5.533   -35.026     0.200
     1.138     3.537     0.200
     1.779    -0.765     0.200
     1.779     0.430     0.200
     1.779     0.930     0.200
     1.874    -0.078     0.200
     3.118   -11.226     0.200
     4.575   -23.808     0.200
    10.207   -65.740     0.200
     2.885   -12.368     0.200
     3.099   -12.835     0.200
     3.480   -18.332     0.200
     3.759   -18.660     0.200
     2.718    -9.223     0.200
     3.242   -13.612     0.200
     3.388   -14.654     0.200
     3.862   -17.975     0.200
     1.602    -0.254     0.200
     1.602     0.347     0.200
     1.689     1.382     0.200
     2.681    -9.583     0.200
     3.708   -17.032     0.200
     3.811   -15.994     0.200
     3.811   -15.394     0.200
     4.002   -17.538     0.200
     4.002   -20.238     0.200
     4.183   -20.570     0.200
     5.273   -26.542     0.200
     6.572   -37.605     0.200
     7.635   -47.099     0.200
     7.927   -49.978     0.200
    10.563   -64.016     0.200
     1.589     0.733     0.200
     1.589     1.827     0.200
     2.300    -4.803     0.200
     2.300    -5.803     0.200
     2.776   -10.099     0.200
     2.980    -9.965     0.200
     3.403   -13.659     0.200
     3.514   -12.584     0.200
     3.753   -15.576     0.200
     4.170   -21.675     0.200
     4.522   -21.723     0.200
     7.880   -47.102     0.200
     8.432   -52.779     0.200
    14.252   -95.091     0.200
    15.739  -113.485     0.200
    19.851  -131.668     0.200
     1.557    -0.699     0.200
     1.557    -0.496     0.200
     3.598   -17.685     0.200
     3.709   -17.314     0.200
     4.094   -22.218     0.200
     5.147   -29.505     0.200
     8.149   -51.288     0.200
    10.821   -67.961     0.200
    12.763   -86.116     0.200
     2.785   -11.470     0.200
     3.508   -16.299     0.200
     3.746   -14.233     0.200
     5.231   -30.214     0.200
     5.723   -32.922     0.200
     2.847    -9.550     0.200
     3.116   -11.973     0.200
     3.116   -14.875     0.200
     3.257   -15.264     0.200
     3.710   -17.312     0.200
     3.710   -14.812     0.200
     9.988   -63.331     0.200
     3.274   -11.042     0.200
     4.704   -23.490     0.200
     6.946   -38.452     0.200
     2.786    -9.219     0.200
     1.666    -0.437     0.200
     1.666     1.661     0.200
     2.348    -5.173     0.200
     2.805    -9.157     0.200
     4.251   -21.384     0.200
     4.615   -21.431     0.200
     5.187   -25.072     0.200
     1.626    -0.389     0.200
     1.626     0.310     0.200
     2.349    -5.296     0.200
     2.776    -8.741     0.200
     3.485   -13.500     0.200
     3.744   -14.837     0.200
     4.211   -21.021     0.200
     4.574   -20.849     0.200
     1.625     0.333     0.200
     1.625     1.034     0.200
     2.344    -5.166     0.200
     2.778    -8.213     0.200
     3.743   -14.924     0.200
     4.209   -20.691     0.200
     4.572   -22.584     0.200
     1.486     2.723     0.200
     2.204    -5.461     0.200
     2.760    -9.459     0.200
     3.621   -15.873     0.200
     4.051   -18.784     0.200
     4.051   -18.987     0.200
     4.991   -24.903     0.200
     5.288   -33.202     0.200
     5.562   -29.383     0.200
     6.405   -36.131     0.200
     6.798   -38.081     0.200
     3.724   -17.054     0.200
     4.053   -19.504     0.200
     4.380   -20.948     0.200
     4.994   -25.914     0.200
     6.411   -36.440     0.200
     6.803   -38.366     0.200
     1.939    -0.678     0.200
     2.708    -8.752     0.200
     2.710    -7.625     0.200
     3.938   -17.346     0.200
     4.251   -17.977     0.200
     1.748     0.232     0.200
     2.260    -4.987     0.200
     2.772   -10.226     0.200
     3.541   -14.221     0.200
     3.769   -17.654     0.200
     2.755    -8.167     0.200
     2.790    -9.270     0.200
     4.295   -20.383     0.200
     5.467   -29.412     0.200
     3.991   -24.927     0.200
     3.991   -15.528     0.200
     4.129   -17.192     0.200
     4.195   -19.185     0.200
    10.445   -63.894     0.200
     2.256    -4.039     0.200
     3.645   -15.751     0.200
     4.012   -16.181     0.200
     4.587   -21.024     0.200
     4.889   -25.593     0.200
     5.615   -33.723     0.200
    10.418   -64.062     0.200
     2.450    -7.896     0.200
     2.498    -7.090     0.200
     3.843   -15.549     0.200
     4.227   -18.929     0.200
     1.751     0.185     0.200
     2.288    -4.542     0.200
     2.753    -8.271     0.200
     2.931    -8.697     0.200
     3.542   -13.195     0.200
     3.542   -14.195     0.200
     3.555   -15.184     0.200
     3.784   -15.840     0.200
     4.258   -19.769     0.200
     4.472   -20.959     0.200
     5.760   -31.275     0.200
     2.459    -6.382     0.200
     3.852   -15.544     0.200
     3.844   -17.688     0.200
     5.452   -28.254     0.200
     6.290   -36.746     0.200
     7.706   -48.109     0.200
    10.739   -65.584     0.200
     2.446    -6.904     0.200
     2.500    -5.914     0.200
     2.498    -7.450     0.200
     3.859   -18.574     0.200
     3.840   -16.463     0.200
     4.010   -17.179     0.200
     4.224   -19.659     0.200
     6.653   -38.661     0.200
     3.499   -13.701     0.200
     3.830   -18.195     0.200
     3.839   -16.692     0.200
     3.839   -18.293     0.200
     4.016   -18.298     0.200
     4.095   -18.901     0.200
     4.222   -19.438     0.200
     4.471   -22.621     0.200
     4.775   -24.955     0.200
     5.450   -29.255     0.200
     6.288   -37.941     0.200
     6.651   -39.336     0.200
     7.761   -46.832     0.200
     8.067   -51.523     0.200
     8.174   -51.211     0.200
     1.557     0.141     0.200
     1.740    -0.075     0.200
     2.307    -5.756     0.200
     2.750   -10.586     0.200
     2.794   -10.564     0.200
     2.948   -10.970     0.200
     4.490   -22.229     0.200
     5.267   -30.183     0.200
     1.748     0.239     0.200
     2.760    -9.866     0.200
     2.784    -9.805     0.200
     2.932    -9.212     0.200
     4.473   -20.974     0.200
     1.398     3.824     0.200
     2.284    -4.179     0.200
     2.561    -7.557     0.200
     3.595   -14.423     0.200
     4.072   -14.062     0.200
     4.092   -16.487     0.200
     5.213   -27.418     0.200
     6.408   -35.591     0.200
     3.666   -15.099     0.200
     3.855   -16.484     0.200
     3.998   -18.841     0.200
     4.324   -19.671     0.200
     6.748   -41.495     0.200
     3.112   -12.494     0.200
     3.401   -15.472     0.200
     4.809   -23.904     0.200
     5.115   -26.399     0.200
     9.881   -64.287     0.200
     2.552    -6.561     0.200
     3.188   -13.114     0.200
     4.829   -25.245     0.200
     5.227   -25.262     0.200
     7.186   -43.254     0.200
     7.186   -44.965     0.200
     7.714   -44.087     0.200
    10.039   -64.489     0.200
     3.583   -15.196     0.200
     3.751   -17.211     0.200
     3.768   -16.749     0.200
     3.918   -17.518     0.200
     4.224   -17.205     0.200
     4.850   -23.566     0.200
     5.115   -25.264     0.200
     6.646   -39.891     0.200
     1.168     3.850     0.200
     3.713   -17.744     0.200
     3.945   -17.381     0.200
     3.964   -15.602     0.200
     4.096   -18.288     0.200
     5.220   -28.408     0.200
     1.240     3.576     0.200
     2.485    -8.485     0.200
     3.826   -18.009     0.200
     4.104   -20.737     0.200
     4.208   -20.331     0.200
     4.484   -22.283     0.200
     4.762   -25.471     0.200
     3.775   -17.142     0.200
     3.884   -17.906     0.200
     4.569   -22.920     0.200
     4.856   -25.029     0.200
     1.384     0.434     0.200
     2.522    -8.831     0.200
     2.633    -7.948     0.200
     2.506    -8.937     0.200
     3.700   -13.874     0.200
     3.740   -18.849     0.200
     3.972   -18.612     0.200
     4.003   -19.193     0.200
     4.364   -22.342     0.200
     5.594   -31.418     0.200
     6.794   -41.948     0.200
     7.833   -48.695     0.200
     1.492     3.275     0.200
     2.322    -4.932     0.200
     3.572   -14.361     0.200
     3.885   -16.454     0.200
     4.221   -18.334     0.200
     4.874   -22.423     0.200
     4.874   -23.123     0.200
     8.481   -53.261     0.200
     1.923    -0.866     0.200
     1.923    -0.268     0.200
     1.987    -1.197     0.200
     1.987     1.905     0.200
     3.720   -14.529     0.200
     3.787   -13.538     0.200
     3.945   -17.441     0.200
     4.187   -17.318     0.200
     6.594   -38.642     0.200
     8.400   -51.597     0.200
     9.189   -63.490     0.200
    10.992   -73.537     0.200
    16.284  -117.324     0.200
     3.715   -14.676     0.200
     3.959   -18.237     0.200
     4.900   -22.667     0.200
     5.467   -30.020     0.200
     5.467   -30.121     0.200
     6.928   -43.527     0.200
     3.666   -16.122     0.200
     4.129   -19.493     0.200
     1.143     4.059     0.200
     3.708   -14.658     0.200
     4.049   -16.355     0.200
     1.750    -0.957     0.200
     1.750    -1.457     0.200
     3.780   -16.707     0.200
     4.752   -25.218     0.200
     5.794   -34.938     0.200
     3.038   -12.712     0.200
     4.387   -24.068     0.200
     4.673   -23.949     0.200
     5.079   -28.609     0.200
     1.632     2.523     0.200
     1.920     0.099     0.200
     2.367    -5.668     0.200
     2.364    -5.071     0.200
     2.841   -10.092     0.200
     3.688   -15.262     0.200
     3.886   -16.531     0.200
     4.094   -19.426     0.200
     5.002   -25.899     0.200
     6.285   -34.868     0.200
     6.454   -35.851     0.200
     7.357   -44.651     0.200
     7.675   -46.437     0.200
     1.624    -0.101     0.200
     6.173   -34.607     0.200
     6.433   -38.044     0.200
     7.315   -45.116     0.200
     7.509   -51.553     0.200
     2.474    -6.567     0.200
     3.959   -17.846     0.200
     4.891   -22.700     0.200
     5.603   -27.777     0.200
     6.035   -33.769     0.200
     6.795   -36.846     0.200
     7.901   -52.464     0.200
     1.358     2.227     0.200
     2.462    -5.864     0.200
     3.732   -14.513     0.200
     6.783   -42.350     0.200
     8.245   -50.176     0.200
     1.563     0.179     0.200
     1.831    -1.322     0.200
     3.633   -17.329     0.200
     3.763   -16.242     0.200
     4.078   -19.630     0.200
     4.341   -20.370     0.200
     4.489   -23.475     0.200
     4.549   -23.277     0.200
     5.021   -27.219     0.200
     5.486   -29.282     0.200
     6.752   -39.714     0.200
     7.442   -44.778     0.200
     2.614    -6.780     0.200
     2.955   -10.984     0.200
     4.399   -21.843     0.200
     4.749   -23.762     0.200
     6.387   -35.079     0.200
     8.476   -51.509     0.200
     3.414   -12.789     0.200
     3.924   -18.059     0.200
     4.021   -18.439     0.200
     4.907   -23.608     0.200
     5.195   -26.963     0.200
     6.040   -33.835     0.200
     6.440   -36.932     0.200
     6.655   -38.850     0.200
     7.313   -41.609     0.200
     7.532   -44.942     0.200
     7.897   -47.294     0.200
     8.418   -54.014     0.200
     1.917    -0.553     0.200
     2.616    -7.199     0.200
     2.728   -10.047     0.200
     2.731    -9.348     0.200
     3.699   -15.953     0.200
     4.901   -25.958     0.200
     5.453   -29.941     0.200
     1.633     0.441     0.200
     1.674     0.020     0.200
     2.393    -5.757     0.200
     1.676     0.552     0.200
     5.840   -30.659     0.200
     1.548     1.089     0.200
     1.750     0.583     0.200
     2.340    -5.119     0.200
     2.726   -10.167     0.200
     2.787    -9.105     0.200
     2.949   -10.332     0.200
     3.536   -14.642     0.200
     3.558   -15.334     0.200
     3.793   -17.490     0.200
     4.131   -19.786     0.200
     4.248   -19.700     0.200
     4.490   -21.681     0.200
     5.068   -26.899     0.200
     5.696   -30.514     0.200
     6.917   -39.510     0.200
     7.827   -46.159     0.200
     8.233   -49.228     0.200
     8.409   -52.011     0.200
    11.571   -76.147     0.200
     2.255    -4.013     0.200
     2.374    -5.987     0.200
     2.403    -5.414     0.200
     2.404    -6.342     0.200
     3.149   -11.663     0.200
     3.473   -14.733     0.200
     3.796   -15.779     0.200
     4.185   -19.005     0.200
     4.204   -20.596     0.200
     4.415   -22.785     0.200
     4.843   -23.878     0.200
     5.000   -24.747     0.200
     5.841   -31.713     0.200
     6.222   -35.164     0.200
     7.323   -43.186     0.200
     7.717   -46.777     0.200
     2.413    -7.177     0.200
     1.534     0.815     0.200
     1.764    -0.786     0.200
     2.712    -8.622     0.200
     1.557     0.509     0.200
     1.740    -0.084     0.200
     3.527   -14.135     0.200
     3.547   -14.977     0.200
     2.669    -7.099     0.200
     2.767    -6.999     0.200
     3.192    -9.139     0.200
     3.325   -13.402     0.200
     3.441   -15.185     0.200
     4.679   -22.828     0.200
     1.584     0.184     0.200
     2.406    -5.263     0.200
     4.194   -20.143     0.200
     1.400     3.520     0.200
     1.940     0.085     0.200
     1.398     3.250     0.200
     2.705    -7.302     0.200
     3.714   -16.780     0.200
     3.739   -17.172     0.200
     3.943   -18.037     0.200
     4.344   -21.463     0.200
     5.422   -28.013     0.200
     3.968   -16.896     0.200
     2.117    -4.390     0.200
     2.255    -5.662     0.200
     2.336    -6.536     0.200
     2.413    -7.477     0.200
     2.444    -6.248     0.200
     3.135   -12.064     0.200
     3.461   -14.313     0.200
     3.796   -17.313     0.200
     4.011   -19.945     0.200
     4.199   -21.686     0.200
     4.211   -21.783     0.200
     4.403   -22.946     0.200
     5.007   -26.002     0.200
     6.470   -37.478     0.200
     1.609    -1.371     0.200
     2.674    -8.338     0.200
     2.733   -10.404     0.200
     3.055   -11.500     0.200
     3.284   -13.748     0.200
     3.326   -15.305     0.200
     4.031   -18.945     0.200
     4.115   -20.514     0.200
     4.816   -27.331     0.200
     5.310   -30.188     0.200
     5.814   -35.174     0.200
     6.060   -34.460     0.200
     7.458   -49.163     0.200
     7.784   -47.103     0.200
     8.277   -52.641     0.200
     8.362   -52.849     0.200
     8.788   -56.934     0.200
     9.889   -63.243     0.200
    11.347   -74.557     0.200
     1.632     1.191     0.200
     1.755    -0.104     0.200
     1.755     2.294     0.200
     3.296   -12.444     0.200
     3.917   -18.128     0.200
     1.456     0.227     0.200
     1.456    -0.773     0.200
     2.393    -7.585     0.200
     2.705    -8.477     0.200
     2.959   -10.345     0.200
     3.673   -17.064     0.200
     3.690   -17.115     0.200
     3.839   -20.530     0.200
     4.028   -19.632     0.200
     4.028   -21.532     0.200
     4.484   -24.170     0.200
     4.952   -28.001     0.200
     5.679   -30.859     0.200
     5.747   -32.928     0.200
     7.777   -47.550     0.200
     8.035   -49.042     0.200
     8.098   -52.641     0.200
     8.098   -52.241     0.200
     8.287   -54.838     0.200
     9.562   -63.064     0.200
    15.361  -115.859     0.200
     2.490    -6.854     0.200
     3.859   -16.646     0.200
     4.163   -19.690     0.200
     5.343   -28.782     0.200
     1.244     4.634     0.200
     3.832   -16.811     0.200
     4.152   -19.056     0.200
     6.573   -38.281     0.200
     2.263    -5.761     0.200
     1.331     3.842     0.200
     3.837   -14.297     0.200
     4.423   -20.285     0.200
     5.235   -23.709     0.200
     2.091    -2.320     0.200
     2.020     0.525     0.200
     2.488    -4.296     0.200
     2.546    -7.422     0.200
     2.783    -7.848     0.200
     3.836   -13.913     0.200
     3.893   -18.528     0.200
     3.893   -15.227     0.200
     4.081   -18.880     0.200
     4.081   -17.681     0.200
     4.438   -21.117     0.200
     4.858   -20.821     0.200
     5.230   -26.205     0.200
     5.836   -30.642     0.200
     6.492   -36.835     0.200
     6.687   -38.094     0.200
     7.255   -42.704     0.200
     7.576   -44.378     0.200
     8.447   -49.006     0.200
    17.830  -117.137     0.200
     1.341     3.736     0.200
     1.372     4.256     0.200
     2.545    -6.827     0.200
     2.788    -9.032     0.200
     3.516   -14.697     0.200
     3.836   -16.242     0.200
     3.826   -17.042     0.200
     3.826   -15.944     0.200
     3.894   -15.489     0.200
     3.894   -15.591     0.200
     4.080   -17.377     0.200
     4.444   -21.624     0.200
     5.227   -27.263     0.200
     6.491   -37.019     0.200
     6.684   -38.249     0.200
     7.249   -42.158     0.200
     7.574   -43.147     0.200
     8.838   -55.624     0.200
    10.804   -72.977     0.200
     1.329     4.055     0.200
     1.329     4.015     0.200
     1.344     3.179     0.200
     2.779    -8.705     0.200
     1.339     3.989     0.200
     3.830   -16.873     0.200
     3.831   -14.014     0.200
     4.432   -21.759     0.200
     4.435   -20.956     0.200
     1.346     3.602     0.200
     2.785    -9.498     0.200
     3.885   -18.129     0.200
     4.439   -21.600     0.200
     5.238   -28.318     0.200
     1.330     3.913     0.200
     3.841   -17.086     0.200
     2.024    -3.616     0.200
     2.546    -8.288     0.200
     3.892   -13.648     0.200
     3.825   -15.639     0.200
     4.082   -19.355     0.200
     4.435   -21.371     0.200
     4.861   -24.661     0.200
     5.231   -25.596     0.200
     6.688   -40.488     0.200
    10.971   -66.538     0.200
     1.344     2.780     0.200
     1.359     2.890     0.200
     1.344     4.031     0.200
     2.495    -6.525     0.200
     2.552    -6.548     0.200
     2.788    -8.526     0.200
     3.829   -14.330     0.200
     3.832   -16.825     0.200
     3.886   -16.849     0.200
     4.087   -17.908     0.200
     4.442   -21.164     0.200
     5.236   -27.419     0.200
     7.582   -45.296     0.200
     1.369     4.731     0.200
     1.347     3.438     0.200
     2.088    -2.448     0.200
     2.494    -6.434     0.200
     2.550    -6.979     0.200
     2.794    -9.824     0.200
     3.521   -14.480     0.200
     3.830   -16.480     0.200
     3.889   -17.847     0.200
     3.889   -12.847     0.200
     3.832   -16.018     0.200
     3.832   -18.218     0.200
     4.084   -17.926     0.200
     4.449   -21.607     0.200
     4.854   -23.014     0.200
     5.231   -26.187     0.200
     6.495   -37.060     0.200
    16.280  -119.008     0.200
     1.343     2.718     0.200
     2.078    -4.092     0.200
     2.497    -5.966     0.200
     2.558    -7.002     0.200
     2.781   -10.264     0.200
     3.825   -16.859     0.200
     3.835   -16.486     0.200
     3.880   -18.707     0.200
     4.094   -19.080     0.200
     4.433   -21.523     0.200
     5.245   -27.161     0.200
     6.506   -36.856     0.200
     7.273   -43.548     0.200
     7.441   -39.876     0.200
     2.018     1.245     0.200
     1.344     4.077     0.200
     4.087   -17.964     0.200
     4.441   -21.812     0.200
     4.862   -23.646     0.200
     6.498   -37.222     0.200
     7.258   -43.115     0.200
     1.228     4.033     0.200
     2.175    -5.079     0.200
     2.502    -6.167     0.200
     3.432   -13.049     0.200
     3.751   -16.061     0.200
     4.042   -19.085     0.200
     3.939   -18.815     0.200
     4.285   -20.188     0.200
     4.926   -23.703     0.200
     5.217   -27.422     0.200
     5.956   -33.349     0.200
     6.462   -37.581     0.200
     6.542   -38.330     0.200
     7.333   -44.683     0.200
     7.554   -45.599     0.200
     7.919   -48.161     0.200
     8.397   -51.939     0.200
     8.823   -56.329     0.200
    16.158  -119.199     0.200
     2.507    -6.275     0.200
     3.080   -11.372     0.200
     3.468   -19.737     0.200
     3.494   -15.788     0.200
     5.126   -27.308     0.200
     5.503   -30.548     0.200
    15.225  -110.577     0.200
     2.444    -8.225     0.200
     2.681    -7.838     0.200
     3.834   -17.384     0.200
     4.009   -19.845     0.200
     4.219   -20.092     0.200
     4.770   -23.940     0.200
     5.448   -30.236     0.200
     6.648   -38.793     0.200
     6.674   -39.821     0.200
     6.746   -38.096     0.200
     6.911   -41.623     0.200
     7.710   -46.254     0.200
     8.172   -50.102     0.200
     2.074    -4.493     0.200
     2.191    -4.710     0.200
     2.405    -5.415     0.200
     2.463    -6.626     0.200
     3.095   -10.888     0.200
     3.417   -13.281     0.200
     4.263   -21.708     0.200
     4.358   -21.908     0.200
     4.782   -22.841     0.200
     6.157   -33.942     0.200
     6.162   -33.993     0.200
     6.396   -37.523     0.200
     7.162   -41.204     0.200
     7.205   -40.647     0.200
     8.781   -55.725     0.200
     2.528    -9.472     0.200
     2.571    -7.542     0.200
     2.915   -10.251     0.200
     4.022   -17.921     0.200
     4.042   -20.456     0.200
     5.688   -30.548     0.200
     6.880   -40.733     0.200
     6.914   -39.808     0.200
     7.942   -47.690     0.200
     3.030   -14.210     0.200
     5.264   -28.724     0.200
     1.224     1.067     0.200
     1.224     0.879     0.200
     2.604    -8.254     0.200
     2.679    -8.353     0.200
     3.057   -10.740     0.200
     3.380   -13.271     0.200
     3.406   -13.538     0.200
     2.411    -5.531     0.200
     3.788   -15.399     0.200
     7.257   -42.867     0.200
     1.688     1.332     0.200
     1.688     1.136     0.200
     3.477   -15.074     0.200
     4.190   -20.379     0.200
     4.310   -20.380     0.200
     5.717   -30.682     0.200
     1.203     0.274     0.200
     1.710    -0.981     0.200
     3.868   -18.420     0.200
     4.852   -26.285     0.200
     6.336   -36.156     0.200
     7.059   -46.758     0.200
     7.590   -49.782     0.200
     7.753   -51.468     0.200
     9.968   -64.869     0.200
    12.021   -76.349     0.200
    17.271  -116.277     0.200
    20.015  -136.278     0.200
    20.110  -138.373     0.200
    22.183  -158.791     0.200
     2.479    -7.420     0.200
     2.478    -5.268     0.200
     3.797   -17.171     0.200
     3.872   -19.057     0.200
     3.872   -17.057     0.200
     4.039   -19.862     0.200
     4.253   -21.532     0.200
     4.253   -18.930     0.200
     6.682   -39.027     0.200
     8.045   -49.841     0.200
    11.320   -73.251     0.200
     1.539    -1.139     0.200
     1.539    -0.940     0.200
     2.585    -8.582     0.200
     3.273   -15.497     0.200
     3.273   -14.400     0.200
     3.087   -12.813     0.200
     4.421   -23.789     0.200
     4.835   -27.210     0.200
     4.835   -27.007     0.200
     5.350   -29.922     0.200
     5.728   -33.422     0.200
     7.480   -46.955     0.200
     7.412   -42.251     0.200
     7.701   -47.563     0.200
     8.236   -50.736     0.200
    11.883   -79.832     0.200
     1.631     0.706     0.200
     1.753    -0.170     0.200
     3.294   -13.611     0.200
     5.721   -30.857     0.200
     1.705     1.268     0.200
     2.321    -3.783     0.200
     1.851    -0.106     0.200
     3.630   -15.001     0.200
     4.039   -18.861     0.200
     6.477   -36.958     0.200
     7.831   -47.383     0.200
     7.954   -47.763     0.200
     7.910   -51.368     0.200
     8.357   -51.348     0.200
    10.998   -73.653     0.200
    15.681  -115.376     0.200
     1.452     1.809     0.200
     1.852     0.140     0.200
     3.630   -15.823     0.200
     4.126   -19.531     0.200
     5.640   -30.452     0.200
     1.454     3.256     0.200
     1.850    -0.102     0.200
     1.850    -0.000     0.200
     2.606    -8.365     0.200
     3.628   -15.675     0.200
     4.041   -19.352     0.200
     4.129   -19.030     0.200
     4.420   -19.282     0.200
     4.420   -21.587     0.200
     5.641   -30.879     0.200
     6.481   -37.199     0.200
     6.849   -39.970     0.200
     6.868   -39.584     0.200
     6.944   -40.199     0.200
     7.104   -41.850     0.200
     7.957   -44.894     0.200
     7.957   -49.199     0.200
     7.905   -50.257     0.200
     7.905   -49.750     0.200
     1.454     3.319     0.200
     1.851    -0.493     0.200
     1.851    -0.188     0.200
     2.450    -6.559     0.200
     2.450    -5.559     0.200
     2.601    -8.041     0.200
     3.629   -16.635     0.200
     4.041   -19.798     0.200
     4.422   -20.893     0.200
     5.644   -31.417     0.200
     6.484   -37.240     0.200
     6.851   -39.983     0.200
     6.871   -40.128     0.200
     7.107   -41.695     0.200
     7.193   -38.288     0.200
     7.899   -51.921     0.200
     7.899   -50.311     0.200
     7.844   -46.640     0.200
     7.960   -48.420     0.200
     8.364   -51.152     0.200
    11.464   -72.360     0.200
    15.668  -115.221     0.200
     1.446     0.970     0.200
     1.859    -0.223     0.200
     1.859     0.176     0.200
     4.033   -18.748     0.200
     7.906   -50.126     0.200
     7.906   -46.517     0.200
    11.457   -73.369     0.200
    15.671  -115.603     0.200
     1.845    -0.357     0.200
     1.845    -0.056     0.200
     2.708    -9.117     0.200
     3.621   -16.779     0.200
     4.049   -19.221     0.200
     4.431   -22.445     0.200
     5.653   -31.184     0.200
     6.493   -37.303     0.200
     6.860   -40.135     0.200
     6.880   -40.090     0.200
     6.956   -40.477     0.200
     7.116   -42.063     0.200
     7.890   -49.332     0.200
     7.890   -50.301     0.200
     7.486   -45.391     0.200
     7.886   -47.064     0.200
     7.852   -46.100     0.200
     7.968   -48.980     0.200
     8.374   -51.823     0.200
    15.660  -114.412     0.200
     1.848     0.206     0.200
     3.626   -14.959     0.200
     2.480    -7.086     0.200
     1.464     2.717     0.200
     1.842     0.057     0.200
     2.455    -5.869     0.200
     2.605    -8.138     0.200
     1.847     0.477     0.200
     2.434    -5.427     0.200
     2.611    -7.925     0.200
     2.701    -7.078     0.200
     2.881    -8.784     0.200
     4.420   -19.881     0.200
     6.480   -36.874     0.200
     6.867   -40.453     0.200
     6.944   -43.480     0.200
     1.449     1.306     0.200
     2.457    -6.638     0.200
     2.594   -10.569     0.200
     2.881   -12.076     0.200
     3.633   -18.423     0.200
     4.420   -22.554     0.200
     4.971   -27.027     0.200
     6.870   -40.521     0.200
     1.469     1.793     0.200
     1.469     3.293     0.200
     1.836    -0.437     0.200
     1.836     0.462     0.200
     5.659   -32.727     0.200
     5.897   -32.951     0.200
     6.499   -37.248     0.200
     7.195   -38.757     0.200
     7.887   -48.140     0.200
     7.887   -50.136     0.200
    10.996   -69.806     0.200
    15.661  -114.067     0.200
     1.841     0.308     0.200
     1.849     0.094     0.200
     1.849    -0.008     0.200
     2.448    -6.396     0.200
     2.604    -7.636     0.200
     2.885    -9.168     0.200
     3.626   -15.655     0.200
     4.043   -20.580     0.200
     6.486   -36.196     0.200
     6.949   -41.879     0.200
     7.192   -42.612     0.200
     7.479   -45.194     0.200
     7.899   -46.486     0.200
     7.844   -46.655     0.200
     8.418   -56.147     0.200
    11.003   -70.483     0.200
    11.465   -71.790     0.200
    15.668  -113.999     0.200
     1.854    -0.107     0.200
     2.602    -6.807     0.200
     3.632   -14.979     0.200
     4.125   -19.086     0.200
     5.638   -30.663     0.200
     1.446     1.173     0.200
     1.861    -0.410     0.200
     1.853    -0.223     0.200
     1.853    -1.522     0.200
     1.853     0.277     0.200
     2.442    -6.294     0.200
     2.603    -8.100     0.200
     2.696    -8.152     0.200
     3.632   -14.400     0.200
     3.696   -16.337     0.200
     4.126   -18.487     0.200
     4.038   -19.068     0.200
     4.038   -17.568     0.200
     4.417   -22.802     0.200
     4.972   -24.096     0.200
     5.638   -29.598     0.200
     5.906   -33.509     0.200
     6.478   -37.021     0.200
     6.846   -40.588     0.200
     6.941   -41.515     0.200
     7.834   -47.431     0.200
    11.002   -73.870     0.200
     1.855    -0.313     0.200
     1.855    -0.112     0.200
     2.449    -6.066     0.200
     2.449    -5.667     0.200
     3.632   -16.665     0.200
     4.037   -19.504     0.200
     5.911   -30.894     0.200
     7.840   -46.255     0.200
     7.903   -51.006     0.200
     8.421   -52.580     0.200
     1.170     4.321     0.200
     2.439    -5.694     0.200
     2.482    -6.572     0.200
     2.487    -6.514     0.200
     3.837   -17.206     0.200
     4.061   -19.519     0.200
     1.844    -0.190     0.200
     2.602    -7.823     0.200
     1.845     0.277     0.200
     2.614    -8.196     0.200
     2.881    -8.263     0.200
     3.625   -15.036     0.200
     4.044   -18.208     0.200
     4.138   -17.812     0.200
     4.421   -19.865     0.200
     4.979   -24.644     0.200
     6.480   -36.541     0.200
     6.849   -38.146     0.200
     6.867   -39.222     0.200
     6.944   -41.556     0.200
     2.485    -5.789     0.200
     2.485    -6.289     0.200
     2.481    -6.985     0.200
     3.490   -16.551     0.200
     3.828   -19.060     0.200
     3.839   -19.021     0.200
     4.196   -20.251     0.200
     5.237   -27.153     0.200
     5.237   -28.153     0.200
     5.416   -28.819     0.200
     6.256   -36.638     0.200
     6.625   -39.028     0.200
     6.644   -37.822     0.200
     7.401   -46.034     0.200
     7.651   -46.170     0.200
     7.732   -46.437     0.200
     7.955   -49.389     0.200
     8.115   -52.962     0.200
     9.074   -53.475     0.200
    15.818  -114.884     0.200
    18.029  -122.034     0.200
     1.461     2.442     0.200
     1.843     0.151     0.200
     2.611    -7.601     0.200
     3.621   -15.417     0.200
     4.132   -18.310     0.200
     4.428   -21.399     0.200
     5.648   -28.689     0.200
     7.842   -46.431     0.200
     1.846     1.479     0.200
     1.842     0.908     0.200
     1.464     3.729     0.200
     1.841     0.164     0.200
     1.841     0.062     0.200
     2.444    -5.346     0.200
     2.444    -5.448     0.200
     2.611    -7.136     0.200
     3.619   -15.089     0.200
     4.130   -20.104     0.200
     4.431   -22.146     0.200
     5.898   -34.259     0.200
     7.190   -39.522     0.200
     7.477   -44.812     0.200
     7.847   -47.020     0.200
     8.412   -53.030     0.200
    15.668  -115.216     0.200
     1.847     0.132     0.200
     2.451    -6.534     0.200
     2.451    -6.833     0.200
     2.603    -8.235     0.200
     2.603    -7.636     0.200
     2.705    -8.273     0.200
     3.624   -15.699     0.200
     3.624   -13.598     0.200
     4.046   -19.579     0.200
     4.046   -17.478     0.200
     4.428   -20.790     0.200
     4.428   -20.589     0.200
     4.980   -25.396     0.200
     5.650   -30.924     0.200
     6.490   -37.043     0.200
     6.857   -39.479     0.200
     6.953   -42.420     0.200
     7.849   -46.935     0.200
     7.894   -47.405     0.200
     8.370   -52.260     0.200
     8.420   -52.634     0.200
     9.948   -62.324     0.200
     2.266    -4.334     0.200
     2.266    -4.932     0.200
     2.538    -7.062     0.200
     3.344   -13.800     0.200
     3.666   -15.210     0.200
     3.973   -17.848     0.200
     4.607   -22.236     0.200
     5.161   -27.701     0.200
     6.480   -37.212     0.200
     6.856   -36.871     0.200
     7.334   -43.486     0.200
     7.696   -46.663     0.200
     7.869   -47.658     0.200
     8.385   -51.290     0.200
     1.126     4.188     0.200
     1.394     2.698     0.200
     2.292    -5.080     0.200
     4.009   -19.115     0.200
     3.984   -18.210     0.200
     3.984   -18.311     0.200
     4.609   -23.828     0.200
     4.950   -25.619     0.200
     6.405   -35.760     0.200
     7.173   -43.283     0.200
     8.394   -52.514     0.200
     8.394   -51.507     0.200
     8.778   -54.071     0.200
     8.854   -56.071     0.200
     9.489   -57.634     0.200
    16.097  -117.458     0.200
     1.404     4.448     0.200
     1.125     4.676     0.200
     1.793    -0.257     0.200
     1.793     1.641     0.200
     1.682     0.962     0.200
     1.682     0.062     0.200
     1.784    -0.661     0.200
     1.784     0.640     0.200
     3.094   -11.893     0.200
     3.587   -14.930     0.200
     4.162   -21.156     0.200
     6.520   -35.207     0.200
    10.487   -68.238     0.200
     3.971   -17.252     0.200
     2.291    -4.828     0.200
     3.661   -14.946     0.200
     6.882   -37.666     0.200
     8.405   -52.616     0.200
     8.405   -54.728     0.200
    16.105  -118.649     0.200
     3.665   -15.752     0.200
     7.504   -43.737     0.200
     8.393   -54.811     0.200
     8.393   -54.632     0.200
    11.071   -76.819     0.200
     1.859    -0.484     0.200
     2.603    -6.286     0.200
     1.132     4.044     0.200
     8.392   -54.605     0.200
     1.133     4.165     0.200
     4.005   -19.961     0.200
     7.360   -44.637     0.200
     8.395   -52.389     0.200
     8.397   -54.303     0.200
     1.404     3.976     0.200
     4.023   -15.931     0.200
     1.111     4.847     0.200
     4.020   -18.882     0.200
     6.904   -38.140     0.200
     8.426   -51.838     0.200
     1.109     4.878     0.200
     7.348   -43.721     0.200
     1.110     5.018     0.200
     7.346   -43.552     0.200
     1.129     4.260     0.200
     1.227     1.117     0.200
     1.596     0.034     0.200
     1.596    -0.766     0.200
     2.059    -5.137     0.200
     2.059    -4.340     0.200
     2.722    -7.760     0.200
     2.722    -7.561     0.200
     2.939   -11.254     0.200
     3.275   -13.809     0.200
     3.880   -17.878     0.200
     4.507   -22.351     0.200
     5.704   -33.290     0.200
     6.755   -38.702     0.200
     6.814   -41.865     0.200
     6.991   -39.918     0.200
     6.980   -39.754     0.200
     8.909   -57.082     0.200
    16.346  -118.601     0.200
     2.275    -4.464     0.200
     4.619   -21.766     0.200
     5.179   -27.535     0.200
     7.157   -41.921     0.200
     7.356   -44.021     0.200
     8.397   -53.275     0.200
     8.397   -52.048     0.200
     8.389   -53.174     0.200
     8.781   -53.916     0.200
    10.883   -65.328     0.200
    16.108  -115.801     0.200
    20.104  -135.249     0.200
    20.976  -141.486     0.200
    21.629  -146.189     0.200
     1.421     4.061     0.200
     4.922   -24.238     0.200
     1.124     4.386     0.200
     2.299    -4.654     0.200
     2.513    -7.349     0.200
     3.669   -16.379     0.200
     4.009   -18.548     0.200
     3.986   -18.237     0.200
     5.180   -27.178     0.200
     6.410   -36.571     0.200
     7.370   -43.194     0.200
     1.122     4.627     0.200
     3.666   -15.499     0.200
     3.982   -17.823     0.200
     4.012   -18.283     0.200
     5.175   -27.450     0.200
     6.891   -35.115     0.200
     7.176   -44.774     0.200
     7.364   -43.837     0.200
     8.394   -54.876     0.200
     1.129     3.836     0.200
     1.417     2.922     0.200
     2.260    -4.313     0.200
     3.662   -15.729     0.200
     3.967   -17.900     0.200
     4.022   -18.945     0.200
     5.153   -27.218     0.200
     7.324   -43.726     0.200
     1.092     4.886     0.200
     2.504    -8.068     0.200
     3.939   -17.559     0.200
     5.130   -26.226     0.200
     1.116     4.895     0.200
     1.401     3.049     0.200
     2.300    -3.846     0.200
     3.659   -15.828     0.200
     3.976   -17.361     0.200
     4.019   -17.916     0.200
     1.141     4.601     0.200
     2.337    -5.025     0.200
     3.358   -13.179     0.200
     3.998   -19.287     0.200
     6.874   -38.249     0.200
     7.159   -44.185     0.200
     7.893   -48.429     0.200
     8.393   -49.765     0.200
     8.393   -51.105     0.200
    11.049   -71.133     0.200
    16.104  -117.727     0.200
     1.129     4.719     0.200
     2.291    -6.220     0.200
     4.006   -18.897     0.200
     6.888   -35.905     0.200
     7.173   -41.363     0.200
     8.392   -52.964     0.200
    10.972   -68.295     0.200
    16.095  -114.924     0.200
     1.381     0.591     0.200
     1.105     4.976     0.200
     2.291    -5.017     0.200
     4.921   -24.376     0.200
     6.873   -38.709     0.200
    11.075   -75.290     0.200
    16.121  -114.809     0.200
     4.044   -14.288     0.200
     1.377     4.099     0.200
     1.142     4.701     0.200
     3.650   -15.824     0.200
     4.033   -18.668     0.200
     4.905   -25.524     0.200
     6.849   -40.245     0.200
     7.134   -42.175     0.200
     8.390   -50.473     0.200
     8.436   -49.945     0.200
    16.141  -117.011     0.200
     1.113     4.639     0.200
     2.283    -4.641     0.200
     1.123     4.981     0.200
     1.138     4.852     0.200
     1.103     5.462     0.200
     1.114     5.231     0.200
     1.090     5.131     0.200
     1.122     5.100     0.200
     1.124     4.747     0.200
     1.118     5.115     0.200
     7.325   -42.160     0.200
     1.090     5.049     0.200
     2.285    -5.733     0.200
     2.497    -6.738     0.200
     3.629   -15.240     0.200
     3.943   -18.886     0.200
     4.050   -18.978     0.200
     4.570   -22.061     0.200
     5.136   -26.410     0.200
     6.367   -35.916     0.200
     1.122     5.102     0.200
     2.545    -7.083     0.200
     3.329   -13.345     0.200
     3.649   -14.797     0.200
     3.950   -17.134     0.200
     4.036   -18.071     0.200
     5.134   -25.680     0.200
     7.302   -43.680     0.200
     1.103     5.193     0.200
     1.102     4.975     0.200
     6.869   -35.903     0.200
    16.127  -115.694     0.200
     1.100     5.059     0.200
     4.051   -14.471     0.200
     1.108     4.980     0.200
     3.642   -16.250     0.200
     4.040   -14.467     0.200
     7.322   -42.407     0.200
     4.051   -18.490     0.200
     1.106     4.604     0.200
     1.435     0.556     0.200
     4.043   -19.817     0.200
     7.317   -43.688     0.200
     1.123     4.865     0.200
     2.289    -5.193     0.200
     4.014   -17.775     0.200
     1.108     5.149     0.200
     4.040   -17.804     0.200
     1.103     5.211     0.200
     2.272    -4.342     0.200
     2.523    -6.620     0.200
     1.091     4.827     0.200
     4.052   -15.744     0.200
     1.090     5.096     0.200
     4.054   -15.081     0.200
     6.873   -37.434     0.200
     7.323   -42.908     0.200
     7.323   -44.808     0.200
     8.439   -49.832     0.200
    16.128  -117.039     0.200
     2.404    -5.483     0.200
     1.853     0.010     0.200
     1.853    -0.091     0.200
     2.599    -7.826     0.200
     3.630   -16.731     0.200
     4.039   -20.489     0.200
     5.911   -33.911     0.200
     7.194   -40.520     0.200
     7.900   -50.462     0.200
     7.900   -51.981     0.200
     8.422   -54.230     0.200
    11.008   -72.039     0.200
     1.103     5.138     0.200
     2.452    -6.431     0.200
     1.142     4.211     0.200
     2.285    -4.726     0.200
     7.358   -41.997     0.200
     1.861    -0.322     0.200
     1.196     4.584     0.200
     3.941   -14.709     0.200
     4.050   -19.185     0.200
     6.473   -37.684     0.200
     1.125     4.629     0.200
     2.293    -4.373     0.200
     3.668   -15.575     0.200
     4.010   -19.221     0.200
     4.609   -22.592     0.200
     5.176   -26.977     0.200
     6.407   -37.197     0.200
     6.887   -35.796     0.200
     7.172   -42.366     0.200
     7.363   -42.490     0.200
     9.489   -58.571     0.200
    16.097  -115.030     0.200
     4.020   -19.265     0.200
     4.600   -23.942     0.200
     6.395   -36.940     0.200
     7.161   -41.816     0.200
     7.347   -42.821     0.200
     7.492   -44.331     0.200
     8.410   -51.547     0.200
    11.065   -69.371     0.200
     1.111     5.072     0.200
     1.774    -0.825     0.200
     4.425   -21.780     0.200
     1.112     4.913     0.200
     7.361   -41.886     0.200
     3.635   -16.524     0.200
     6.903   -37.593     0.200
     1.091     4.238     0.200
     1.862    -0.189     0.200
     2.596    -7.645     0.200
     4.293   -18.593     0.200
     1.444     1.359     0.200
     2.600    -7.396     0.200
     4.409   -21.151     0.200
     1.104     4.101     0.200
     4.361   -18.290     0.200
     4.921   -25.404     0.200
     6.875   -36.370     0.200
     3.938   -16.792     0.200
     3.958   -17.738     0.200
     8.235   -51.692     0.200
     8.235   -50.436     0.200
     8.810   -56.669     0.200
    18.376  -121.709     0.200
     1.464     3.091     0.200
     3.941   -19.677     0.200
     2.724    -8.356     0.200
     3.522   -15.168     0.200
     3.936   -18.089     0.200
     5.192   -25.800     0.200
     5.201   -26.787     0.200
     8.248   -52.984     0.200
     8.814   -55.614     0.200
     3.939   -17.594     0.200
     3.934   -17.316     0.200
     6.371   -35.349     0.200
     7.620   -44.235     0.200
     8.250   -50.182     0.200
     1.467     2.121     0.200
     3.952   -17.760     0.200
     1.843     0.117     0.200
     2.607    -7.500     0.200
     3.620   -14.916     0.200
     4.050   -19.449     0.200
     1.091     4.820     0.200
     4.355   -18.253     0.200
     7.327   -43.146     0.200
     4.097   -16.247     0.200
     1.781     0.664     0.200
     3.612   -12.378     0.200
     4.368   -19.901     0.200
    11.205   -73.109     0.200
     2.532    -7.564     0.200
     3.765   -16.760     0.200
     2.390    -5.194     0.200
     2.401    -6.554     0.200
     3.872   -16.365     0.200
     4.131   -21.284     0.200
     1.405     0.738     0.200
     2.358    -5.672     0.200
     2.456    -6.772     0.200
     3.966   -17.847     0.200
     3.966   -18.347     0.200
     4.037   -18.503     0.200
     6.011   -34.457     0.200
     6.392   -37.236     0.200
     8.380   -51.558     0.200
     2.110    -5.296     0.200
     2.367    -6.832     0.200
     3.928   -17.685     0.200
     3.896   -18.302     0.200
     4.198   -17.390     0.200
     5.151   -28.607     0.200
     7.581   -44.917     0.200
     8.295   -55.744     0.200
     8.295   -51.662     0.200
    15.798  -118.258     0.200
    16.276  -115.645     0.200
    18.019  -119.500     0.200
    20.477  -141.827     0.200
    20.699  -144.073     0.200
     7.714   -49.150     0.200
     1.095     4.661     0.200
     2.166    -4.704     0.200
     4.148   -20.452     0.200
     8.274   -52.395     0.200
     1.642    -0.393     0.200
     4.244   -20.674     0.200
     2.355    -4.078     0.200
     4.250   -20.855     0.200
     8.619   -55.449     0.200
    16.243  -117.636     0.200
     4.307   -21.454     0.200
     8.638   -52.041     0.200
    16.257  -117.204     0.200
     6.834   -34.750     0.200
     7.156   -41.477     0.200
     1.650     1.031     0.200
     4.322   -17.683     0.200
     8.634   -54.516     0.200
    11.192   -74.753     0.200
     4.299   -18.795     0.200
     4.741   -23.054     0.200
     6.842   -35.570     0.200
     7.163   -42.422     0.200
     9.226   -56.358     0.200
    10.729   -64.405     0.200
    11.214   -75.011     0.200
    16.249  -118.584     0.200
     4.308   -19.576     0.200
     7.181   -43.317     0.200
     8.608   -52.898     0.200
    10.753   -64.564     0.200
    16.235  -118.343     0.200
     4.760   -23.579     0.200
     4.336   -19.217     0.200
     4.728   -21.932     0.200
     7.148   -42.547     0.200
    11.178   -74.185     0.200
    16.271  -117.291     0.200
     1.502     0.540     0.200
     2.445    -5.949     0.200
     2.951    -9.895     0.200
     3.214   -11.621     0.200
     4.288   -20.243     0.200
     6.705   -37.387     0.200
     8.086   -51.559     0.200
    11.061   -72.275     0.200
    14.589  -106.866     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.503    -0.077     0.200
     0.557     0.276     0.200
     2.287    -0.668     0.200
     2.287     0.535     0.200
     0.483     0.884     0.200
     0.914    -0.287     0.200
     2.088    -0.502     0.200
     2.129     0.193     0.200
     2.209    -0.357     0.200
     2.335    -0.539     0.200
     2.341     0.864     0.200
     2.395     0.977     0.200
     2.444     0.691     0.200
     0.712     0.606     0.200
     1.383     0.318     0.200
     2.345     0.316     0.200
     8.142    -9.718     0.200
     0.535     0.596     0.200
     0.669     1.343     0.200
     1.380    -0.381     0.200
     2.197     0.327     0.200
     2.337     0.485     0.200
     2.869    -5.872     0.200
     0.538     0.713     0.200
     0.596     0.185     0.200
     1.972    -1.240     0.200
     2.179    -1.600     0.200
     2.249    -0.517     0.200
     0.387     1.641     0.200
     0.776     0.315     0.200
     1.040    -0.067     0.200
     1.972     1.096     0.200
     2.233    -0.669     0.200
     2.298    -0.755     0.200
     2.430    -1.837     0.200
     2.482    -1.781     0.200
     1.953    -2.827     0.200
     0.562     0.223     0.200
     1.130     1.036     0.200
     1.137     0.810     0.200
     1.929    -0.986     0.200
     2.379    -1.073     0.200
     1.276    -0.769     0.200
     2.027    -1.375     0.200
     2.465    -3.865     0.200
     2.492    -0.720     0.200
     0.324     1.053     0.200
     1.244     0.495     0.200
     1.245     0.461     0.200
     2.023    -1.793     0.200
     2.447    -2.642     0.200
     2.493     0.095     0.200
     1.251    -0.710     0.200
     1.253    -0.745     0.200
     2.451    -2.842     0.200
     2.492     0.154     0.200
     0.318     0.056     0.200
     1.254     0.286     0.200
     2.014    -0.920     0.200
     2.453    -2.644     0.200
     2.490     0.180     0.200
     0.281     1.075     0.200
     1.284    -0.623     0.200
     1.285    -0.665     0.200
     2.466    -2.896     0.200
     2.499    -0.730     0.200
     1.251    -0.097     0.200
     1.252    -0.130     0.200
     2.015    -2.196     0.200
     2.456    -3.570     0.200
     2.486    -0.029     0.200
     0.284     0.906     0.200
     1.268    -0.701     0.200
     1.270    -0.745     0.200
     2.002    -1.745     0.200
     2.448    -1.704     0.200
     0.310     0.346     0.200
     1.256    -0.544     0.200
     1.258    -0.581     0.200
     2.011    -1.546     0.200
     2.453    -2.477     0.200
     2.494    -0.080     0.200
     5.576    -8.057     0.200
     0.320     0.642     0.200
     1.247     0.540     0.200
     1.248     0.505     0.200
     2.020    -1.449     0.200
     2.448    -2.924     0.200
     2.494    -0.893     0.200
     1.270     0.762     0.200
     1.271     0.728     0.200
     1.997    -0.073     0.200
     2.468    -1.516     0.200
     2.483    -0.591     0.200
     0.309     0.687     0.200
     1.264     0.292     0.200
     1.265     0.257     0.200
     2.002    -1.212     0.200
     2.461    -2.560     0.200
     2.488     0.594     0.200
     0.613     0.404     0.200
     0.620     0.156     0.200
     1.209     0.512     0.200
     2.207    -1.641     0.200
     5.329   -14.708     0.200
     0.286     0.968     0.200
     1.279    -0.122     0.200
     1.280    -0.163     0.200
     1.990    -1.663     0.200
     2.463    -2.459     0.200
     2.499    -0.802     0.200
     0.303     1.020     0.200
     0.853     1.578     0.200
     2.032    -2.298     0.200
     2.422    -2.261     0.200
     3.485   -10.354     0.200
     5.309   -13.870     0.200
     5.450   -14.423     0.200
     8.039   -19.726     0.200
     0.313     1.263     0.200
     2.040    -2.688     0.200
     2.418    -4.170     0.200
     0.319     0.633     0.200
     0.826     1.560     0.200
     1.271     0.270     0.200
     1.272     0.240     0.200
     1.994    -0.965     0.200
     2.477    -2.469     0.200
     2.469     1.483     0.200
     0.297     0.646     0.200
     1.314    -0.092     0.200
     1.315    -0.122     0.200
     1.952    -1.106     0.200
     2.454     0.278     0.200
     1.367     0.085     0.200
     1.368     0.033     0.200
     1.909    -1.202     0.200
     2.512    -3.730     0.200
     6.777   -23.620     0.200
     0.295     1.608     0.200
     0.856     1.611     0.200
     1.259     0.253     0.200
     2.012    -1.536     0.200
     2.040    -2.515     0.200
     2.442    -2.258     0.200
     0.611    -0.422     0.200
     0.611     0.578     0.200
     0.584     1.132     0.200
     1.337    -0.254     0.200
     2.161     1.131     0.200
     2.699    -3.221     0.200
     7.447   -24.935     0.200
     0.266    -0.003     0.200
     0.880     1.315     0.200
     1.327     0.134     0.200
     1.329     0.096     0.200
     2.475    -0.240     0.200
     0.552    -0.067     0.200
     0.561    -0.333     0.200
     0.580     1.061     0.200
     1.256     0.636     0.200
     2.157    -1.424     0.200
     0.708     0.652     0.200
     2.247    -0.619     0.200
     2.300    -0.807     0.200
     2.341    -1.493     0.200
     2.449     0.468     0.200
     6.268   -16.489     0.200
     2.866    -4.157     0.200
     5.933   -16.084     0.200
     0.510    -0.124     0.200
     1.353     0.146     0.200
     1.352     0.185     0.200
     2.233     0.749     0.200
     2.665    -2.735     0.200
     0.550     1.246     0.200
     0.758    -0.349     0.200
     0.846     1.357     0.200
     2.153     1.225     0.200
     2.252    -0.389     0.200
     2.223    -0.273     0.200
     2.429    -0.911     0.200
     0.664     0.146     0.200
     1.073     0.183     0.200
     1.075     0.116     0.200
     2.218    -2.033     0.200
     2.372     0.002     0.200
     2.464    -1.522     0.200
     2.341    -0.035     0.200
     2.403     0.004     0.200
     0.764     1.205     0.200
     0.913     0.180     0.200
     0.915     0.103     0.200
     2.210     0.468     0.200
     2.251    -1.834     0.200
     2.339    -3.138     0.200
     2.439     0.189     0.200
     9.799   -24.997     0.200
    10.684   -31.567     0.200
     0.811     0.726     0.200
     0.859    -0.213     0.200
     0.862    -0.300     0.200
     2.194    -2.832     0.200
     2.304    -2.200     0.200
     2.467    -1.587     0.200
     4.829   -11.740     0.200
     7.253   -15.711     0.200
     0.887     0.502     0.200
     2.124     0.001     0.200
     2.139    -1.167     0.200
     2.333    -2.316     0.200
     2.430    -1.002     0.200
     2.351    -1.829     0.200
     2.409     0.440     0.200
     0.991    -0.130     0.200
     2.368    -0.396     0.200
     2.353     0.269     0.200
     6.321   -13.614     0.200
     9.901   -28.990     0.200
     0.562     0.393     0.200
     2.155     0.695     0.200
     2.745    -3.693     0.200
     0.385    -0.080     0.200
     2.297    -0.113     0.200
     2.838    -3.268     0.200
     5.501   -16.263     0.200
     0.578     0.333     0.200
     1.302    -0.311     0.200
     2.210     1.208     0.200
     0.383     0.063     0.200
     2.304    -0.830     0.200
     2.842    -3.188     0.200
     2.842    -3.489     0.200
     0.584     0.071     0.200
     1.275    -0.321     0.200
     2.225     0.044     0.200
     0.551     0.774     0.200
     2.272    -0.890     0.200
     2.415    -0.430     0.200
     0.322     1.172     0.200
     0.492     0.165     0.200
     1.498    -0.241     0.200
     1.497    -1.211     0.200
     2.183     0.237     0.200
     2.183    -0.763     0.200
     2.778    -3.724     0.200
     0.790     1.043     0.200
     0.790     0.844     0.200
     2.380    -1.056     0.200
     1.019     0.868     0.200
     2.539    -5.806     0.200
     0.658     0.910     0.200
     0.902     0.556     0.200
     1.879     0.196     0.200
     2.102    -1.971     0.200
     2.057    -0.137     0.200
     0.695     0.771     0.200
     1.183     1.315     0.200
     2.171     1.084     0.200
     2.426    -2.291     0.200
     2.526    -2.758     0.200
     3.406    -5.036     0.200
     5.931    -7.393     0.200
     0.560     0.229     0.200
     1.212     1.155     0.200
     2.153    -1.086     0.200
     2.153    -1.286     0.200
     0.659     0.577     0.200
     0.901     0.708     0.200
     2.058    -0.970     0.200
     2.102    -2.484     0.200
     2.102    -1.785     0.200
     0.267     1.411     0.200
     0.267     2.607     0.200
     2.749    -4.281     0.200
     0.727     0.716     0.200
     1.004     0.736     0.200
     2.000    -0.431     0.200
     2.255    -2.018     0.200
     0.694     0.917     0.200
     1.256     0.293     0.200
     1.256     0.097     0.200
     2.956    -6.371     0.200
     0.719     0.592     0.200
     1.117     0.393     0.200
     1.117    -0.006     0.200
     2.259    -1.410     0.200
     2.302    -0.272     0.200
     2.406    -0.582     0.200
     2.406    -0.277     0.200
     3.645    -4.644     0.200
     0.340     1.145     0.200
     2.335    -0.700     0.200
     4.140    -9.119     0.200
     4.280    -6.483     0.200
     6.757   -11.904     0.200
     0.360     0.813     0.200
     0.360     0.614     0.200
     1.642    -0.717     0.200
     2.313     0.303     0.200
     2.313    -0.697     0.200
     2.806    -3.039     0.200
     3.350    -4.467     0.200
     4.146    -6.815     0.200
     6.761   -11.301     0.200
     0.933     0.449     0.200
     0.933     0.247     0.200
     2.396    -2.607     0.200
     3.345    -4.406     0.200
     3.356    -5.650     0.200
     4.639    -6.826     0.200
     5.966    -9.580     0.200
     6.942   -10.237     0.200
     0.671     0.952     0.200
     0.871     0.397     0.200
     0.871    -0.202     0.200
     2.108     0.396     0.200
     2.209    -0.911     0.200
     2.209    -2.411     0.200
     2.292    -0.948     0.200
     2.292    -1.048     0.200
     0.226     0.650     0.200
     0.226     0.548     0.200
     1.350     0.013     0.200
     1.350     0.411     0.200
     2.505    -3.887     0.200
     2.499    -0.914     0.200
     2.499    -0.515     0.200
     0.318     0.836     0.200
     0.318     0.637     0.200
     1.254     0.964     0.200
     2.454    -2.383     0.200
     2.454    -3.082     0.200
     2.499    -0.593     0.200
     0.304     0.789     0.200
     1.256     0.608     0.200
     1.256     0.308     0.200
     2.445    -1.803     0.200
     2.445    -3.100     0.200
     2.505    -0.291     0.200
     2.505    -0.892     0.200
     0.303     0.595     0.200
     0.303     0.396     0.200
     1.261     0.302     0.200
     2.452    -2.441     0.200
     2.452    -3.038     0.200
     2.499    -0.236     0.200
     2.499    -0.736     0.200
     0.513     0.808     0.200
     1.159    -0.066     0.200
     1.159     0.434     0.200
     2.385    -0.619     0.200
     2.384    -0.593     0.200
     2.384     0.306     0.200
     2.473    -1.513     0.200
     2.473    -1.913     0.200
     0.320     0.432     0.200
     1.259    -0.036     0.200
     2.462    -2.876     0.200
     2.481     0.131     0.200
     0.343     0.583     0.200
     1.236     0.181     0.200
     1.236    -0.119     0.200
     2.063    -0.455     0.200
     2.449    -2.494     0.200
     2.449    -2.794     0.200
     2.479    -0.836     0.200
     2.481    -0.595     0.200
     0.348     0.324     0.200
     1.229     0.481     0.200
     2.069    -0.849     0.200
     2.445    -1.859     0.200
     2.473    -0.234     0.200
     2.482     0.567     0.200
     0.395     0.343     0.200
     1.216    -0.067     0.200
     2.081    -1.317     0.200
     2.462    -1.980     0.200
     2.454    -0.634     0.200
     2.444     0.281     0.200
     0.359     0.041     0.200
     1.223     0.772     0.200
     1.223     0.573     0.200
     2.076    -0.571     0.200
     2.445    -1.677     0.200
     2.465    -0.517     0.200
     2.477    -0.184     0.200
     2.477     0.216     0.200
     4.011    -4.726     0.200
     4.511    -5.480     0.200
     0.274     1.109     0.200
     1.277    -0.110     0.200
     1.277    -0.212     0.200
     2.027    -0.785     0.200
     2.450    -2.690     0.200
     3.805    -8.640     0.200
     3.992    -5.774     0.200
     8.211   -19.819     0.200
     0.311     0.303     0.200
     0.311     0.201     0.200
     1.257     0.801     0.200
     1.257     0.098     0.200
     2.044    -1.044     0.200
     2.452    -2.490     0.200
     2.452    -2.795     0.200
     2.495    -0.142     0.200
     2.495    -0.243     0.200
     0.330     0.347     0.200
     1.246     0.697     0.200
     2.053    -0.774     0.200
     2.454    -2.668     0.200
     2.491    -0.944     0.200
     2.484     0.475     0.200
     4.482    -6.362     0.200
     0.310     1.207     0.200
     0.310     0.907     0.200
     1.253    -0.692     0.200
     1.253    -0.092     0.200
     2.048    -0.586     0.200
     2.447    -3.138     0.200
     2.447    -2.238     0.200
     2.499    -1.378     0.200
     0.332     0.689     0.200
     1.238    -0.413     0.200
     1.238     0.290     0.200
     2.062    -1.057     0.200
     2.444    -3.048     0.200
     2.444    -2.446     0.200
     2.482    -1.363     0.200
     2.482    -1.160     0.200
     2.491     0.341     0.200
     7.445   -18.776     0.200
     0.326     0.599     0.200
     1.247    -0.278     0.200
     2.053    -0.944     0.200
     2.451    -2.357     0.200
     2.491    -1.125     0.200
     2.488    -0.415     0.200
     4.480    -5.870     0.200
     0.602     0.194     0.200
     1.339     0.928     0.200
     2.000    -0.233     0.200
     2.167    -0.140     0.200
     2.167     0.165     0.200
     4.577    -5.640     0.200
     0.332     0.475     0.200
     1.238     0.042     0.200
     1.238     0.742     0.200
     2.062    -0.862     0.200
     2.483    -1.507     0.200
     2.483    -1.307     0.200
     2.444    -2.590     0.200
     2.444    -2.391     0.200
     2.491    -0.574     0.200
     0.314     0.981     0.200
     1.245    -0.723     0.200
     1.245     0.277     0.200
     2.057    -0.950     0.200
     2.439    -3.286     0.200
     2.439    -2.887     0.200
     2.491    -1.215     0.200
     3.837    -6.396     0.200
     5.590    -7.645     0.200
     0.333     0.396     0.200
     1.234     0.044     0.200
     2.066    -1.041     0.200
     2.440    -2.379     0.200
     4.491    -6.303     0.200
     0.767     0.670     0.200
     0.767     0.369     0.200
     1.411     0.145     0.200
     0.765     0.873     0.200
     1.286    -0.362     0.200
     1.286    -0.062     0.200
     2.088     0.545     0.200
     2.088     0.745     0.200
     2.449    -0.823     0.200
     2.449     0.177     0.200
     0.350     0.764     0.200
     2.320     0.228     0.200
     2.320    -0.373     0.200
     2.794    -3.006     0.200
     0.359     0.636     0.200
     2.311    -0.560     0.200
     2.311    -0.263     0.200
     0.556    -0.228     0.200
     0.556     0.170     0.200
     1.283     0.830     0.200
     2.166    -1.360     0.200
     0.342     0.845     0.200
     0.342     0.743     0.200
     1.621    -0.681     0.200
     2.326    -1.136     0.200
     2.784    -4.471     0.200
     0.714     0.263     0.200
     0.714     0.661     0.200
     2.185    -1.054     0.200
     2.929    -4.843     0.200
     0.821     0.625     0.200
     1.331     0.159     0.200
     1.331     0.058     0.200
     2.019     0.552     0.200
     2.019     0.755     0.200
     2.478    -0.402     0.200
     3.904    -8.006     0.200
     0.818     0.841     0.200
     0.818     0.638     0.200
     1.334     0.193     0.200
     1.334    -0.010     0.200
     2.019     0.872     0.200
     2.019     0.974     0.200
     2.482     0.206     0.200
     2.482    -0.098     0.200
     0.685     0.595     0.200
     1.009     0.646     0.200
     1.009     0.544     0.200
     2.216     0.180     0.200
     2.216    -0.121     0.200
     2.351    -0.201     0.200
     2.404    -1.700     0.200
     2.404    -2.298     0.200
     2.392     0.377     0.200
     2.392    -0.326     0.200
     0.679     0.679     0.200
     1.010     0.572     0.200
     1.010     0.072     0.200
     2.219    -0.041     0.200
     2.355    -0.570     0.200
     2.355    -0.469     0.200
     2.402    -1.756     0.200
     2.402    -2.355     0.200
     2.396    -0.073     0.200
     0.695     0.157     0.200
     0.695     0.352     0.200
     1.004     0.864     0.200
     1.004     0.762     0.200
     2.209     0.346     0.200
     2.209    -0.349     0.200
     2.342     0.220     0.200
     2.404    -1.534     0.200
     2.404    -2.034     0.200
     2.390     0.410     0.200
     2.390     0.012     0.200
     0.691     0.344     0.200
     0.691     0.547     0.200
     1.007     0.520     0.200
     1.007     0.719     0.200
     2.213    -0.106     0.200
     2.213     0.297     0.200
     2.347    -0.237     0.200
     2.407    -1.630     0.200
     2.407    -2.232     0.200
     2.389     0.128     0.200
     4.014    -5.291     0.200
     0.429     0.610     0.200
     1.048     0.614     0.200
     2.204    -0.834     0.200
     2.300    -0.583     0.200
     2.300    -0.985     0.200
     0.680     0.365     0.200
     0.680     0.560     0.200
     2.217    -0.676     0.200
     2.217    -0.372     0.200
     2.354    -0.898     0.200
     2.354    -0.499     0.200
     2.402    -2.020     0.200
     2.396    -0.342     0.200
     0.365     0.640     0.200
     0.365     0.538     0.200
     2.309    -0.888     0.200
     2.309    -0.787     0.200
     2.813    -3.253     0.200
     3.436   -10.110     0.200
     3.436    -4.415     0.200
     0.062     2.370     0.200
     0.909     0.121     0.200
     2.494    -2.530     0.200
     2.494    -3.226     0.200
     8.520   -21.559     0.200
     0.075     2.082     0.200
     2.490    -2.468     0.200
     0.679     0.416     0.200
     0.679     0.817     0.200
     1.004     0.408     0.200
     1.004     0.509     0.200
     2.214    -0.330     0.200
     2.351    -1.101     0.200
     2.351    -0.601     0.200
     2.395    -1.596     0.200
     2.395    -1.895     0.200
     2.403    -0.423     0.200
     2.403    -0.622     0.200
     7.357   -17.866     0.200
     0.618     0.189     0.200
     0.618     0.589     0.200
     1.217     0.881     0.200
     1.346     0.601     0.200
     1.346     1.101     0.200
     2.150    -0.192     0.200
     2.710    -3.136     0.200
     5.358   -12.686     0.200
     0.589     0.140     0.200
     1.218    -0.782     0.200
     2.188    -1.659     0.200
     2.188    -1.858     0.200
     2.675    -3.974     0.200
     5.422    -7.773     0.200
     0.607     0.811     0.200
     0.607    -0.384     0.200
     1.216     1.195     0.200
     1.338     1.245     0.200
     2.164    -0.031     0.200
     7.451   -16.330     0.200
     0.605     0.943     0.200
     1.212     0.497     0.200
     1.342     0.966     0.200
     1.342    -0.534     0.200
     2.163    -0.046     0.200
     0.607     0.556     0.200
     0.607    -0.345     0.200
     1.347     0.305     0.200
     2.158     0.405     0.200
     0.648     0.590     0.200
     1.012     0.156     0.200
     1.012    -0.149     0.200
     2.228    -0.491     0.200
     2.385    -1.580     0.200
     2.373    -1.301     0.200
     2.421    -1.221     0.200
     2.421    -1.517     0.200
     7.389   -17.416     0.200
     0.290     0.498     0.200
     1.097     0.708     0.200
     1.310     0.078     0.200
     1.310    -0.622     0.200
     2.465     0.251     0.200
     2.465    -0.049     0.200
     4.422    -6.682     0.200
     0.825     0.731     0.200
     0.838     0.636     0.200
     0.838     0.236     0.200
     2.022     0.586     0.200
     2.022    -0.014     0.200
     2.160    -0.398     0.200
     2.279    -0.955     0.200
     2.279    -1.255     0.200
     2.488    -0.091     0.200
     2.488     0.010     0.200
     0.595     0.623     0.200
     1.217     0.214     0.200
     2.180    -0.010     0.200
     0.385    -0.035     0.200
     0.385     0.660     0.200
     1.184     0.323     0.200
     2.434    -0.984     0.200
     2.434    -0.085     0.200
     2.480    -1.836     0.200
     2.480    -1.430     0.200
     2.474    -1.173     0.200
     2.474    -0.470     0.200
     0.398     0.477     0.200
     0.398     0.176     0.200
     2.421     0.049     0.200
     2.488    -1.863     0.200
     2.488    -1.660     0.200
     2.472    -0.780     0.200
     2.472    -0.280     0.200
     3.851    -5.974     0.200
     0.397     0.245     0.200
     0.397     0.346     0.200
     1.231    -0.002     0.200
     1.231     0.295     0.200
     1.192     0.230     0.200
     2.427     0.088     0.200
     2.468    -1.027     0.200
     2.468     0.172     0.200
     2.481    -1.541     0.200
     2.481    -1.139     0.200
     0.388     0.550     0.200
     1.190     0.105     0.200
     1.229    -0.423     0.200
     1.229    -0.220     0.200
     2.438    -0.524     0.200
     2.474    -1.468     0.200
     2.474    -1.265     0.200
     2.468    -1.483     0.200
     2.468    -0.687     0.200
     3.856    -4.573     0.200
     0.551     0.660     0.200
     0.551     0.761     0.200
     1.052     0.601     0.200
     2.132    -0.535     0.200
     2.132    -0.433     0.200
     0.558     0.481     0.200
     1.058     0.748     0.200
     2.126    -0.236     0.200
     2.126    -0.439     0.200
     3.638    -4.263     0.200
     0.374     1.917     0.200
     2.503    -5.168     0.200
     3.484    -5.477     0.200
     3.025    -8.001     0.200
     5.661   -10.775     0.200
     0.450     1.331     0.200
     2.486    -5.510     0.200
     2.529    -4.980     0.200
     2.529    -5.777     0.200
     2.990    -5.199     0.200
     5.641    -7.931     0.200
     0.290     0.357     0.200
     0.290     0.459     0.200
     1.104     0.456     0.200
     1.302     0.084     0.200
     1.302     0.584     0.200
     2.472    -0.405     0.200
     2.472    -0.303     0.200
     2.493    -2.766     0.200
     2.493    -1.766     0.200
     5.533    -7.729     0.200
     0.672     0.412     0.200
     0.672     0.513     0.200
     2.248    -1.243     0.200
     2.248    -0.946     0.200
     3.099    -5.733     0.200
     3.099    -5.835     0.200
     3.480    -7.332     0.200
     0.288     2.922     0.200
     0.288     3.022     0.200
     1.752    -2.405     0.200
     2.666    -3.769     0.200
     2.666    -4.069     0.200
     3.388    -4.854     0.200
     4.330    -8.128     0.200
     5.346    -8.111     0.200
     1.085     1.012     0.200
     1.602    -1.153     0.200
    10.152   -29.788     0.200
     0.360    -0.212     0.200
     0.360     0.694     0.200
     2.300    -0.404     0.200
     2.300    -0.303     0.200
     2.776    -3.201     0.200
     2.776    -2.997     0.200
     2.980    -3.863     0.200
     3.497    -6.739     0.200
     0.641     0.255     0.200
     0.641     0.848     0.200
     2.034    -0.010     0.200
     3.598    -5.388     0.200
     5.186    -8.040     0.200
     7.530   -18.046     0.200
     0.369     1.192     0.200
     0.848     0.735     0.200
     2.291    -0.117     0.200
     2.785    -3.470     0.200
     0.628     1.481     0.200
     3.116    -4.973     0.200
     3.116    -4.574     0.200
     8.580   -19.873     0.200
     0.504     0.455     0.200
     0.504    -1.045     0.200
     1.239     1.355     0.200
     2.103    -0.518     0.200
     0.469     0.230     0.200
     0.469     0.027     0.200
     0.974     0.103     0.200
     1.521    -0.242     0.200
     2.198     1.102     0.200
     2.786    -3.121     0.200
     3.584    -8.538     0.200
     5.277   -12.500     0.200
     0.340     0.197     0.200
     0.340     0.697     0.200
     1.666    -0.738     0.200
     2.348    -0.673     0.200
     2.805    -3.259     0.200
     3.417    -7.649     0.200
     3.417    -8.946     0.200
     8.145   -21.249     0.200
     0.324     0.698     0.200
     0.794     0.700     0.200
     2.349    -0.694     0.200
     2.349    -0.296     0.200
     2.776    -3.041     0.200
     3.485    -4.102     0.200
     7.821   -14.762     0.200
     0.327     0.662     0.200
     2.344    -0.365     0.200
     2.344     0.234     0.200
     3.485    -4.037     0.200
     6.999   -18.717     0.200
     0.472     0.269     0.200
     1.010     1.010     0.200
     1.486    -0.378     0.200
     2.204    -0.664     0.200
     0.463     0.414     0.200
     1.004     0.871     0.200
     2.212    -0.923     0.200
     2.212    -1.125     0.200
     0.540     0.174     0.200
     1.138     0.099     0.200
     1.384     0.207     0.200
     2.190     1.363     0.200
     0.399    -0.019     0.200
     0.908     0.148     0.200
     2.260     0.208     0.200
     0.592    -0.085     0.200
     1.114     0.279     0.200
     2.113     0.307     0.200
     2.790    -2.868     0.200
     0.694     0.195     0.200
     0.694     0.492     0.200
     1.412    -0.367     0.200
     2.216    -0.849     0.200
     2.262     0.004     0.200
     2.322    -0.298     0.200
     2.430    -1.428     0.200
     2.430    -0.327     0.200
     0.722     0.311     0.200
     2.239    -0.585     0.200
     2.256     0.859     0.200
     2.256     0.160     0.200
     2.302    -0.580     0.200
     2.302     0.322     0.200
     2.405    -0.765     0.200
     2.405    -0.164     0.200
     3.645    -5.251     0.200
     4.012    -4.681     0.200
     5.975   -15.717     0.200
     0.309     0.492     0.200
     1.147     0.210     0.200
     1.257     0.348     0.200
     2.045    -0.537     0.200
     2.450    -2.095     0.200
     2.498     0.109     0.200
     0.370     0.167     0.200
     0.370     0.267     0.200
     1.546    -0.306     0.200
     2.288    -0.442     0.200
     2.288     0.058     0.200
     2.753    -2.771     0.200
     0.318     0.272     0.200
     1.148     0.251     0.200
     2.043    -0.689     0.200
     2.459    -2.183     0.200
     2.485     0.470     0.200
     3.844    -4.586     0.200
     0.310     0.420     0.200
     1.151     0.064     0.200
     1.253    -0.165     0.200
     1.253    -0.462     0.200
     2.049    -0.693     0.200
     2.446    -2.704     0.200
     2.446    -2.204     0.200
     2.500    -0.215     0.200
     2.500    -0.113     0.200
     2.498    -1.051     0.200
     0.316     0.396     0.200
     0.316     0.497     0.200
     1.152    -0.021     0.200
     1.253     0.299     0.200
     1.253     0.600     0.200
     2.048    -0.923     0.200
     2.450    -2.574     0.200
     2.450    -2.375     0.200
     2.498    -0.871     0.200
     2.494     0.249     0.200
     3.830    -6.695     0.200
     0.351     0.572     0.200
     0.881     0.375     0.200
     2.307    -0.756     0.200
     0.378     0.039     0.200
     0.899     0.026     0.200
     1.550     0.202     0.200
     2.280    -0.145     0.200
     2.760    -2.766     0.200
     0.525     0.279     0.200
     0.525    -0.221     0.200
     1.011     0.301     0.200
     1.398     0.024     0.200
     2.287    -0.855     0.200
     2.284    -0.776     0.200
     2.284    -1.878     0.200
     2.441    -0.059     0.200
     4.072    -4.863     0.200
     0.472     0.755     0.200
     0.472     0.654     0.200
     1.057     0.193     0.200
     1.434    -0.344     0.200
     1.434    -0.944     0.200
     1.875    -0.132     0.200
     2.223    -0.864     0.200
     2.783    -4.408     0.200
     0.460     1.158     0.200
     0.915     0.357     0.200
     1.065     1.577     0.200
     2.064     1.505     0.200
     2.064     1.208     0.200
     2.240    -3.355     0.200
     3.401    -4.675     0.200
     3.576    -4.913     0.200
     8.950   -22.271     0.200
     0.775     0.470     0.200
     1.151     1.761     0.200
     2.242    -0.822     0.200
     2.242    -2.119     0.200
     3.188    -4.215     0.200
     3.188    -4.411     0.200
     4.513    -6.915     0.200
     8.481   -17.193     0.200
     0.542     0.303     0.200
     1.163     0.322     0.200
     1.355    -0.269     0.200
     1.967     0.015     0.200
     2.205     0.495     0.200
     2.205     0.698     0.200
     2.683    -2.870     0.200
     0.632     0.651     0.200
     1.168     1.151     0.200
     1.168     0.850     0.200
     1.350     0.268     0.200
     2.275     0.041     0.200
     2.275     0.338     0.200
     2.369    -0.232     0.200
     2.369    -0.833     0.200
     2.487    -0.584     0.200
     0.328     0.391     0.200
     1.166     0.027     0.200
     1.240    -0.721     0.200
     2.060    -1.044     0.200
     2.443    -2.364     0.200
     2.485    -0.384     0.200
     2.494    -0.298     0.200
     0.634     0.225     0.200
     1.203    -0.216     0.200
     1.379     1.096     0.200
     2.118     1.486     0.200
     0.195     1.234     0.200
     1.015    -0.050     0.200
     1.384     0.234     0.200
     2.522    -3.431     0.200
     0.735     0.078     0.200
     0.735     0.478     0.200
     1.039     0.940     0.200
     1.039    -0.360     0.200
     1.492    -0.025     0.200
     2.307    -0.248     0.200
     2.229     0.632     0.200
     2.229     0.132     0.200
     2.322    -0.131     0.200
     2.465    -1.566     0.200
     2.343     0.109     0.200
     2.343    -0.491     0.200
     0.837     0.482     0.200
     0.837     0.583     0.200
     1.301     0.452     0.200
     1.463     0.808     0.200
     1.463    -0.591     0.200
     8.400   -11.445     0.200
     0.503     0.423     0.200
     1.104     0.569     0.200
     1.399    -0.091     0.200
     1.399    -0.286     0.200
     1.915     0.058     0.200
     2.212     0.246     0.200
     2.212    -0.457     0.200
     3.715    -6.980     0.200
     3.715   -10.379     0.200
     8.124   -16.957     0.200
     8.172   -21.373     0.200
     0.692     0.270     0.200
     1.132     0.601     0.200
     1.410    -0.014     0.200
     2.215    -0.318     0.200
     2.263     1.448     0.200
     2.323     0.665     0.200
     2.431     0.117     0.200
     0.549     0.278     0.200
     1.143     0.160     0.200
     2.165    -0.957     0.200
     2.363    -0.334     0.200
     2.367     0.543     0.200
     2.476    -2.409     0.200
     0.280     2.142     0.200
     0.659     0.332     0.200
     2.737    -4.136     0.200
     2.737    -3.837     0.200
     0.326     0.853     0.200
     0.618     1.113     0.200
     3.038    -4.412     0.200
     3.620    -7.662     0.200
     1.078     0.167     0.200
     1.304     0.805     0.200
     1.632    -0.678     0.200
     2.300     0.331     0.200
     2.367     0.531     0.200
     2.364     0.128     0.200
     0.773     0.985     0.200
     0.827     0.348     0.200
     2.045     0.949     0.200
     2.237    -2.837     0.200
     2.237    -0.235     0.200
     2.205    -0.826     0.200
     2.484    -0.845     0.200
     3.916    -7.139     0.200
     0.149     0.612     0.200
     1.371     0.304     0.200
     1.371    -0.696     0.200
     1.953     0.040     0.200
     2.474    -2.067     0.200
     2.474    -2.466     0.200
     8.331   -19.936     0.200
     9.435   -22.039     0.200
     0.156     0.544     0.200
     1.358    -0.078     0.200
     1.966    -0.425     0.200
     1.966     1.270     0.200
     2.462    -1.762     0.200
     0.738     0.749     0.200
     1.132    -0.365     0.200
     1.950     0.517     0.200
     0.275     0.689     0.200
     0.692     0.561     0.200
     1.254     0.930     0.200
     3.085    -3.699     0.200
     3.534    -5.639     0.200
     4.749    -7.663     0.200
     0.718    -0.137     0.200
     0.718     0.863     0.200
     1.212     0.498     0.200
     1.379    -0.085     0.200
     2.157     0.234     0.200
     2.176     1.149     0.200
     2.390     0.356     0.200
     2.481     0.272     0.200
     7.532   -16.646     0.200
     0.541     0.278     0.200
     1.120    -0.393     0.200
     1.407    -0.173     0.200
     2.177     1.096     0.200
     0.310     1.071     0.200
     0.733     0.548     0.200
     2.393    -0.460     0.200
     0.327     0.603     0.200
     1.628     0.581     0.200
     2.370     0.242     0.200
     2.801    -3.010     0.200
     0.318     0.259     0.200
     1.548    -0.009     0.200
     2.340    -0.420     0.200
     0.778     0.397     0.200
     0.935     0.505     0.200
     2.129     0.674     0.200
     2.255    -0.113     0.200
     2.374    -1.487     0.200
     2.403    -0.813     0.200
     2.404    -0.944     0.200
     0.603     0.514     0.200
     1.054     0.389     0.200
     2.254    -1.540     0.200
     2.275     0.012     0.200
     2.407    -2.092     0.200
     2.413    -0.077     0.200
     2.423    -0.887     0.200
     0.309     0.435     0.200
     0.890     0.220     0.200
     2.349    -0.432     0.200
     0.330     0.003     0.200
     0.872     0.123     0.200
     2.328     0.276     0.200
     0.137     0.786     0.200
     0.964     1.468     0.200
     3.325    -3.843     0.200
     3.441    -5.107     0.200
     0.786     0.587     0.200
     0.927     0.803     0.200
     2.245    -0.572     0.200
     2.369    -1.498     0.200
     2.413    -0.487     0.200
     2.406     1.135     0.200
     0.599     0.096     0.200
     1.163     0.132     0.200
     1.400     0.719     0.200
     2.133     1.086     0.200
     0.583     0.279     0.200
     1.154     0.079     0.200
     1.398     0.551     0.200
     2.147     0.590     0.200
     0.535     0.424     0.200
     1.000     0.593     0.200
     1.409     0.420     0.200
     2.242     0.613     0.200
     2.276    -1.280     0.200
     2.431     0.018     0.200
     0.758    -0.208     0.200
     0.913     0.065     0.200
     1.573    -1.142     0.200
     2.117     0.207     0.200
     2.255    -0.959     0.200
     2.336    -1.337     0.200
     2.413    -1.778     0.200
     2.444    -1.049     0.200
     0.331     1.961     0.200
     0.331     2.362     0.200
     0.635     0.316     0.200
     1.803    -2.105     0.200
     2.733    -3.804     0.200
     1.219     0.991     0.200
     2.113    -0.767     0.200
     0.127     3.928     0.200
     0.127     4.028     0.200
     1.964    -2.189     0.200
     7.712   -11.984     0.200
     0.103     2.716     0.200
     0.836     0.898     0.200
     1.074     0.256     0.200
     2.490    -0.354     0.200
     2.801    -3.905     0.200
     0.603     0.270     0.200
     1.230     0.496     0.200
     1.316     0.357     0.200
     2.021    -0.490     0.200
     2.181     0.259     0.200
     0.621     0.279     0.200
     1.244     0.435     0.200
     1.313     0.250     0.200
     2.030    -0.191     0.200
     2.169     0.813     0.200
     2.682    -2.642     0.200
     0.175     1.134     0.200
     0.828     0.920     0.200
     2.820    -3.924     0.200
     3.290    -5.113     0.200
     0.795     0.529     0.200
     1.331     0.041     0.200
     1.360     0.221     0.200
     2.036     1.680     0.200
     2.485     0.056     0.200
     0.811     0.154     0.200
     0.811     0.354     0.200
     1.368     0.300     0.200
     1.338     0.250     0.200
     1.338    -0.152     0.200
     2.091    -0.023     0.200
     2.091     0.180     0.200
     2.488     0.204     0.200
     2.488     0.004     0.200
     0.818     0.620     0.200
     1.341     0.134     0.200
     2.015     1.482     0.200
     2.093    -0.286     0.200
     2.093     0.714     0.200
     2.489    -0.255     0.200
     2.489    -0.852     0.200
     8.838   -23.124     0.200
     0.797     0.414     0.200
     1.329    -0.047     0.200
     1.363     0.074     0.200
     2.036     0.123     0.200
     2.092    -0.252     0.200
     2.482    -0.516     0.200
     0.804     0.556     0.200
     1.329     0.117     0.200
     1.369    -0.031     0.200
     2.031     0.662     0.200
     2.096     0.117     0.200
     2.481     0.009     0.200
     0.787     0.524     0.200
     1.345     0.252     0.200
     1.344    -0.321     0.200
     2.032     0.080     0.200
     2.073    -0.244     0.200
     0.799     0.688     0.200
     1.339    -0.108     0.200
     2.028     0.438     0.200
     2.085     0.043     0.200
     2.492    -0.060     0.200
     0.793     0.405     0.200
     1.348    -0.094     0.200
     2.026     0.617     0.200
     2.073    -0.271     0.200
     0.797     0.502     0.200
     1.346    -0.198     0.200
     2.024     0.635     0.200
     2.077    -0.545     0.200
     2.500     0.138     0.200
     0.806     0.581     0.200
     1.344    -0.074     0.200
     1.360    -0.191     0.200
     2.020     1.088     0.200
     2.083    -0.321     0.200
     2.495    -0.266     0.200
     0.802     0.522     0.200
     1.330     0.311     0.200
     1.367     0.531     0.200
     2.032     2.142     0.200
     2.094    -0.137     0.200
     0.808     0.422     0.200
     0.808     0.622     0.200
     1.366     0.223     0.200
     1.337     0.141     0.200
     1.337     0.641     0.200
     2.090     0.861     0.200
     2.090     0.661     0.200
     2.024     1.184     0.200
     2.488    -0.135     0.200
     0.804     0.572     0.200
     1.344     0.180     0.200
     1.359     0.191     0.200
     2.021     0.396     0.200
     2.083    -0.056     0.200
     2.495     0.274     0.200
     0.810     0.475     0.200
     1.344     0.331     0.200
     1.363    -0.155     0.200
     2.017     0.913     0.200
     2.085     0.057     0.200
     2.495    -0.826     0.200
     0.820     0.356     0.200
     0.820     0.555     0.200
     1.369     0.632     0.200
     1.347     0.139     0.200
     2.088     0.652     0.200
     2.088    -0.049     0.200
     2.009     1.652     0.200
     2.494    -0.333     0.200
     7.425   -13.635     0.200
     1.352     0.244     0.200
     1.343    -0.182     0.200
     2.027     0.419     0.200
     2.078     0.008     0.200
     2.497    -0.366     0.200
     0.785     0.550     0.200
     1.318    -0.419     0.200
     1.361     0.107     0.200
     2.052     0.513     0.200
     2.096     0.095     0.200
     0.812     0.485     0.200
     1.341     0.302     0.200
     1.367     0.296     0.200
     2.089     0.401     0.200
     0.810     0.813     0.200
     1.344     0.280     0.200
     1.363     0.263     0.200
     2.018     1.113     0.200
     2.086    -0.439     0.200
     2.494     0.523     0.200
     0.701     0.135     0.200
     0.701     0.736     0.200
     1.228     0.131     0.200
     1.228     1.033     0.200
     2.175     0.722     0.200
     2.175     0.120     0.200
     2.137    -0.980     0.200
     2.137     0.821     0.200
     2.409    -0.111     0.200
    10.045   -23.156     0.200
     0.246     0.508     0.200
     1.080     1.135     0.200
     1.080     0.725     0.200
     1.080     0.936     0.200
     3.247    -5.377     0.200
     3.468    -6.737     0.200
     3.494    -4.390     0.200
     6.344    -8.630     0.200
     7.024    -9.172     0.200
     0.315     0.370     0.200
     1.156    -0.185     0.200
     1.248     0.289     0.200
     2.053    -0.728     0.200
     2.444    -2.024     0.200
     2.494    -0.393     0.200
     0.844     0.391     0.200
     0.893     0.418     0.200
     1.640    -0.254     0.200
     2.074     0.207     0.200
     2.191    -1.010     0.200
     2.361    -2.020     0.200
     2.405     0.085     0.200
     2.463    -1.126     0.200
     0.093     1.911     0.200
     0.944     0.026     0.200
     1.878    -0.869     0.200
     1.878     0.335     0.200
     0.552     1.419     0.200
     3.030    -7.410     0.200
     0.606     1.023     0.200
     1.166     1.909     0.200
     1.166     1.280     0.200
     2.604    -3.093     0.200
     2.969    -6.583     0.200
     5.641    -8.206     0.200
     0.786     0.770     0.200
     0.930     0.598     0.200
     1.583     0.117     0.200
     2.122     0.818     0.200
     2.247    -0.334     0.200
     2.373    -0.915     0.200
     2.411    -0.932     0.200
     2.403     0.328     0.200
     0.368     0.363     0.200
     0.368     0.261     0.200
     0.831     0.210     0.200
     1.609     0.029     0.200
     2.294    -0.094     0.200
     2.294    -0.399     0.200
     2.793    -2.899     0.200
     3.477    -7.574     0.200
     0.489     2.084     0.200
     1.034     0.002     0.200
     1.248     0.894     0.200
     2.995    -5.109     0.200
     3.160    -4.382     0.200
     1.063     1.020     0.200
     1.063     1.122     0.200
     7.590   -11.079     0.200
     0.299     0.302     0.200
     0.299     0.107     0.200
     1.286     0.232     0.200
     2.015    -0.192     0.200
     2.479    -2.014     0.200
     2.479    -1.420     0.200
     2.478     0.130     0.200
     2.478     0.334     0.200
     0.365     1.793     0.200
     2.810    -4.425     0.200
     2.810    -4.625     0.200
     3.273    -4.201     0.200
     7.480   -13.310     0.200
     0.520     0.420     0.200
     1.221     0.610     0.200
     2.114    -1.216     0.200
     0.923     0.656     0.200
     0.947     0.703     0.200
     2.060     0.994     0.200
     2.142     0.188     0.200
     2.321     1.014     0.200
     2.438    -1.487     0.200
     2.496     0.470     0.200
     0.231     0.732     0.200
     0.231     0.232     0.200
     0.953     0.548     0.200
     1.452     0.944     0.200
     2.437    -0.280     0.200
     2.437    -0.381     0.200
     7.910   -14.017     0.200
     0.224     0.234     0.200
     0.952     0.260     0.200
     1.452    -0.089     0.200
     2.444    -0.529     0.200
     0.227     0.252     0.200
     0.951     0.292     0.200
     1.454     0.053     0.200
     1.454     0.850     0.200
     2.441    -0.542     0.200
     2.441    -0.347     0.200
     7.905   -14.406     0.200
     0.218     0.295     0.200
     0.950     0.289     0.200
     1.454    -0.884     0.200
     1.454     0.319     0.200
     2.450    -0.661     0.200
     2.450    -0.059     0.200
     0.219     0.458     0.200
     0.219     0.559     0.200
     0.958     0.543     0.200
     1.446    -0.233     0.200
     2.451    -0.701     0.200
     0.212     0.390     0.200
     0.942     0.372     0.200
     1.461    -1.399     0.200
     1.461    -0.399     0.200
     2.453    -1.838     0.200
     2.453    -0.938     0.200
     7.890   -15.656     0.200
     0.223     0.116     0.200
     0.948     0.734     0.200
     1.456     0.823     0.200
     2.444    -0.486     0.200
     0.957     0.111     0.200
     1.866    -0.822     0.200
     2.480    -2.184     0.200
     0.210     0.494     0.200
     0.938     0.510     0.200
     1.464     0.417     0.200
     2.455    -0.369     0.200
     0.233     0.245     0.200
     0.950     0.512     0.200
     1.456     0.796     0.200
     2.434    -0.232     0.200
     0.212     1.042     0.200
     0.953     0.340     0.200
     1.856    -0.397     0.200
     2.457    -0.638     0.200
     0.216     0.211     0.200
     0.216     0.313     0.200
     0.934     0.954     0.200
     1.469     0.594     0.200
     2.447    -0.605     0.200
     2.613    -2.549     0.200
     7.887   -12.218     0.200
     0.216     0.613     0.200
     0.939     0.800     0.200
     1.464    -0.153     0.200
     2.448    -0.649     0.200
     0.219     0.449     0.200
     0.948     0.455     0.200
     1.456    -0.566     0.200
     1.456     0.637     0.200
     2.448    -0.599     0.200
     0.225     0.138     0.200
     0.954     0.509     0.200
     1.450     0.504     0.200
     2.444    -0.417     0.200
     0.204     0.632     0.200
     0.956    -0.005     0.200
     2.466    -1.265     0.200
     0.227     0.234     0.200
     0.227     0.034     0.200
     0.954     0.474     0.200
     1.451    -0.062     0.200
     1.451     0.239     0.200
     2.442    -0.193     0.200
     0.219     0.326     0.200
     0.954     0.052     0.200
     1.450     0.712     0.200
     2.449    -0.167     0.200
     2.449     0.434     0.200
     0.361     0.387     0.200
     1.165     0.191     0.200
     1.251    -0.423     0.200
     2.047    -1.352     0.200
     2.445    -0.081     0.200
     2.481    -2.111     0.200
     2.491    -0.444     0.200
     0.369     0.510     0.200
     0.369     0.309     0.200
     1.170     0.321     0.200
     1.247    -0.119     0.200
     2.050     0.045     0.200
     2.050    -0.254     0.200
     2.439     0.005     0.200
     2.439     0.306     0.200
     2.482    -2.572     0.200
     2.482    -1.873     0.200
     2.487    -0.414     0.200
     0.207     0.303     0.200
     0.939     0.288     0.200
     1.463    -0.306     0.200
     2.458    -0.743     0.200
     0.237    -0.231     0.200
     0.950     0.576     0.200
     1.457     0.585     0.200
     2.431     0.029     0.200
     0.372     0.095     0.200
     1.245    -0.298     0.200
     1.173    -0.300     0.200
     2.052    -0.765     0.200
     2.439    -0.137     0.200
     2.439    -0.536     0.200
     2.485    -1.187     0.200
     2.485    -0.687     0.200
     2.481    -2.286     0.200
     0.225     0.239     0.200
     0.943     0.264     0.200
     1.461     0.145     0.200
     2.441    -0.307     0.200
     0.224     0.012     0.200
     0.946     0.205     0.200
     1.458     0.681     0.200
     2.443    -0.036     0.200
     0.210     0.467     0.200
     0.938     0.367     0.200
     1.464     0.096     0.200
     2.455    -0.512     0.200
     0.221     0.317     0.200
     0.940     0.313     0.200
     1.464     0.428     0.200
     1.464     0.127     0.200
     2.444    -0.549     0.200
     0.215     0.278     0.200
     0.215     0.479     0.200
     1.459     0.641     0.200
     2.451    -0.833     0.200
     7.894   -13.130     0.200
     0.689     0.058     0.200
     1.131     0.241     0.200
     1.131     0.343     0.200
     1.409     0.325     0.200
     2.266    -0.131     0.200
     2.266    -1.033     0.200
     2.322     0.181     0.200
     0.660     0.966     0.200
     0.660     0.669     0.200
     1.126     0.891     0.200
     1.394     0.104     0.200
     2.209    -0.938     0.200
     2.209    -0.235     0.200
     2.292    -0.478     0.200
     2.292     0.123     0.200
     2.325     0.095     0.200
     0.679     0.346     0.200
     1.129     0.177     0.200
     1.404     0.549     0.200
     2.213     0.203     0.200
     2.276    -0.189     0.200
     2.323     0.527     0.200
     2.435     0.357     0.200
     0.673     0.427     0.200
     1.125     0.074     0.200
     1.402     0.397     0.200
     2.214     0.169     0.200
     2.321     0.469     0.200
     2.284     1.658     0.200
     2.436    -0.269     0.200
     0.894    -0.148     0.200
     1.178     0.046     0.200
     3.094    -3.393     0.200
     8.292   -14.667     0.200
     0.681     0.057     0.200
     1.123     0.345     0.200
     1.409     0.181     0.200
     2.219    -0.793     0.200
     2.280     0.480     0.200
     2.317     0.496     0.200
     2.430    -0.292     0.200
     0.670     0.465     0.200
     0.670    -0.135     0.200
     1.120     0.402     0.200
     1.120    -0.397     0.200
     1.404     0.691     0.200
     2.291     0.272     0.200
     2.218    -0.505     0.200
     2.317     0.557     0.200
     2.317    -0.342     0.200
     2.433    -0.036     0.200
     2.433    -0.436     0.200
     0.658     0.085     0.200
     0.658    -0.016     0.200
     1.122    -0.218     0.200
     2.212    -1.178     0.200
     2.212    -1.377     0.200
     2.298    -1.098     0.200
     2.298    -1.297     0.200
     2.321    -0.444     0.200
     2.321    -0.644     0.200
     2.440    -0.821     0.200
     2.440    -1.422     0.200
     8.393   -16.339     0.200
     0.237    -0.068     0.200
     0.962     0.220     0.200
     1.444    -0.338     0.200
     2.435    -0.554     0.200
     0.659    -0.192     0.200
     1.132     0.044     0.200
     1.390    -0.053     0.200
     2.287    -0.599     0.200
     2.330    -0.043     0.200
     2.447    -0.357     0.200
     8.392   -16.581     0.200
     0.668     0.477     0.200
     1.118     0.211     0.200
     1.404     0.047     0.200
     2.219    -0.087     0.200
     2.294     0.910     0.200
     2.315     0.744     0.200
     2.433     0.327     0.200
     0.663     0.670     0.200
     0.663     0.475     0.200
     1.133    -0.038     0.200
     1.133     0.165     0.200
     2.204    -1.082     0.200
     2.204    -0.481     0.200
     2.330    -0.493     0.200
     2.330    -0.290     0.200
     2.283    -0.104     0.200
     2.283    -0.503     0.200
     0.690     0.327     0.200
     1.140    -0.055     0.200
     1.404     0.374     0.200
     2.207    -0.281     0.200
     2.257    -0.562     0.200
     2.330     0.015     0.200
     0.689     0.376     0.200
     1.122     0.433     0.200
     1.414     0.070     0.200
     2.222    -0.434     0.200
     2.275     0.902     0.200
     2.314    -0.058     0.200
     0.654    -0.168     0.200
     0.654     0.233     0.200
     1.111     0.347     0.200
     1.111     0.047     0.200
     1.399    -0.311     0.200
     2.312    -0.049     0.200
     2.312    -0.249     0.200
     2.220    -0.923     0.200
     2.220    -0.323     0.200
     2.499    -1.472     0.200
     2.499    -1.272     0.200
     0.674     0.447     0.200
     1.109     0.183     0.200
     1.413     0.216     0.200
     2.298     0.285     0.200
     2.306     0.332     0.200
     0.677     0.038     0.200
     1.110     0.917     0.200
     1.414     0.274     0.200
     2.228    -0.023     0.200
     2.294     0.576     0.200
     2.306     0.600     0.200
     0.681    -0.156     0.200
     1.129     0.359     0.200
     1.406    -0.926     0.200
     2.214    -1.351     0.200
     2.274    -0.257     0.200
     2.322    -0.170     0.200
     0.466     0.444     0.200
     1.227     0.316     0.200
     2.059    -1.739     0.200
     2.059    -1.637     0.200
     8.796   -19.454     0.200
     0.667     0.697     0.200
     0.667     0.596     0.200
     1.139     0.262     0.200
     1.139     0.160     0.200
     1.391     0.561     0.200
     2.201    -0.412     0.200
     2.275     0.036     0.200
     2.275     0.138     0.200
     2.334    -0.243     0.200
     0.687    -0.283     0.200
     1.110     0.911     0.200
     1.421     0.460     0.200
     2.232     0.249     0.200
     2.304     0.467     0.200
     2.287     0.186     0.200
     0.653     0.315     0.200
     1.124     0.585     0.200
     1.391     0.233     0.200
     2.208    -0.481     0.200
     2.299     0.346     0.200
     2.325    -0.070     0.200
     0.659     0.516     0.200
     1.122     0.229     0.200
     1.396     0.266     0.200
     2.212     0.090     0.200
     2.297    -0.699     0.200
     2.322     0.308     0.200
     0.699     0.371     0.200
     1.129     0.633     0.200
     1.417    -0.179     0.200
     2.220    -0.736     0.200
     2.260    -0.118     0.200
     2.318     0.152     0.200
     0.701     0.168     0.200
     1.092     0.286     0.200
     1.441    -0.171     0.200
     2.252    -1.092     0.200
     2.284    -0.507     0.200
     2.295    -0.247     0.200
     0.662     0.585     0.200
     1.116     0.494     0.200
     1.401     0.347     0.200
     2.218     0.053     0.200
     2.315     0.379     0.200
     2.300     0.154     0.200
     0.664     0.432     0.200
     0.664    -0.467     0.200
     1.141     0.698     0.200
     1.387     0.496     0.200
     2.198    -0.700     0.200
     2.198    -1.001     0.200
     2.276    -1.378     0.200
     2.276     0.021     0.200
     2.337    -0.025     0.200
     8.785   -22.127     0.200
     0.656     0.299     0.200
     1.143     0.349     0.200
     1.381     0.219     0.200
     2.193    -0.231     0.200
     2.280     0.029     0.200
     2.341     0.075     0.200
     0.658     0.452     0.200
     0.658     0.249     0.200
     1.129    -0.085     0.200
     1.391     0.421     0.200
     2.206    -0.915     0.200
     2.206     0.280     0.200
     2.291     0.178     0.200
     2.291    -0.720     0.200
     2.328     0.214     0.200
     0.658     0.437     0.200
     1.144     0.624     0.200
     2.193    -0.638     0.200
     2.278    -0.212     0.200
     2.341    -0.339     0.200
     0.697     0.493     0.200
     1.099     0.549     0.200
     1.434     0.638     0.200
     2.244     0.232     0.200
     2.291    -0.156     0.200
     0.689     0.580     0.200
     0.689     0.182     0.200
     1.105     0.574     0.200
     1.105     0.675     0.200
     1.425     0.447     0.200
     2.236    -0.087     0.200
     2.236    -0.786     0.200
     2.291    -0.517     0.200
     2.299     0.629     0.200
     0.692     0.563     0.200
     1.098     0.492     0.200
     1.431     0.249     0.200
     2.243     0.099     0.200
     2.292     0.253     0.200
     2.295     0.473     0.200
     0.660     0.425     0.200
     1.153     0.103     0.200
     1.377     0.699     0.200
     2.186     0.666     0.200
     2.267     0.506     0.200
     2.349     0.490     0.200
     0.666     0.133     0.200
     1.142     0.660     0.200
     1.388     0.148     0.200
     2.198    -0.416     0.200
     2.273     0.402     0.200
     2.337     0.257     0.200
     0.655     0.340     0.200
     1.142     0.604     0.200
     1.381     0.216     0.200
     2.194    -0.256     0.200
     2.282     0.461     0.200
     2.340    -0.090     0.200
     0.705     0.244     0.200
     0.705     0.545     0.200
     1.118     0.438     0.200
     1.118     0.338     0.200
     1.427     0.732     0.200
     2.232     0.439     0.200
     2.232    -0.061     0.200
     2.267     1.105     0.200
     2.267     0.204     0.200
     2.307    -0.140     0.200
    10.849   -21.125     0.200
     0.689     0.387     0.200
     1.113     0.139     0.200
     2.230     0.349     0.200
     2.283    -0.539     0.200
     0.696     0.328     0.200
     1.123     1.181     0.200
     2.224    -0.016     0.200
     2.269     0.465     0.200
     0.695     0.036     0.200
     1.090     0.603     0.200
     2.251    -0.295     0.200
     2.301     0.023     0.200
     2.499    -1.150     0.200
     0.662     0.125     0.200
     1.138     0.453     0.200
     1.388     0.313     0.200
     2.200    -0.123     0.200
     2.280     0.245     0.200
     0.679     0.285     0.200
     1.103     0.259     0.200
     1.420     0.196     0.200
     2.235    -0.141     0.200
     2.299    -0.265     0.200
     2.300     0.201     0.200
     0.711     0.283     0.200
     1.114     0.331     0.200
     1.434     0.357     0.200
     2.238    -0.211     0.200
     2.267     0.269     0.200
     2.301     0.293     0.200
     0.698     0.354     0.200
     1.090     0.131     0.200
     1.440    -0.156     0.200
     2.252    -0.514     0.200
     2.283     0.603     0.200
     2.299     0.409     0.200
     0.740     0.132     0.200
     1.122     0.732     0.200
     1.449     0.449     0.200
     2.243     0.095     0.200
     2.240    -0.713     0.200
     0.764    -0.493     0.200
     1.449     0.704     0.200
     2.229     0.481     0.200
     2.198     0.964     0.200
     2.593    -2.358     0.200
     0.689     0.618     0.200
     1.122     0.500     0.200
     1.415     0.707     0.200
     2.223     0.302     0.200
     2.275     1.046     0.200
     0.679     0.437     0.200
     1.124     0.149     0.200
     1.408     0.550     0.200
     2.218    -0.230     0.200
     2.280     0.188     0.200
     0.698     0.328     0.200
     1.118     0.716     0.200
     1.423     0.640     0.200
     2.272     0.714     0.200
     2.229    -0.221     0.200
     0.690     0.323     0.200
     1.090     0.745     0.200
     1.090     0.549     0.200
     1.435     0.033     0.200
     2.249    -0.998     0.200
     2.249    -0.295     0.200
     2.304    -0.922     0.200
     2.304    -0.523     0.200
     2.285    -0.139     0.200
     2.497    -1.433     0.200
     0.721     0.514     0.200
     1.122     0.700     0.200
     1.436     0.359     0.200
     2.235    -0.554     0.200
     2.252     0.504     0.200
     2.306     0.474     0.200
     0.710     0.766     0.200
     1.103     0.693     0.200
     1.440    -0.063     0.200
     2.246     0.086     0.200
     2.292     0.715     0.200
     2.277     0.883     0.200
     3.636    -4.074     0.200
     0.696     0.553     0.200
     0.696     0.248     0.200
     1.102     0.178     0.200
     1.102     0.076     0.200
     1.431     0.533     0.200
     2.289     0.232     0.200
     2.289    -1.768     0.200
     2.294    -0.532     0.200
     2.242     0.134     0.200
     0.708     0.331     0.200
     1.111     0.553     0.200
     1.434     0.628     0.200
     2.239     0.414     0.200
     2.300    -0.218     0.200
     2.271     0.882     0.200
     0.714     0.416     0.200
     1.100    -0.144     0.200
     1.444     0.074     0.200
     2.250    -0.265     0.200
     2.288     0.299     0.200
     2.277    -0.042     0.200
     0.701     0.276     0.200
     0.701     0.576     0.200
     1.108     0.480     0.200
     1.108     0.179     0.200
     1.431     0.533     0.200
     2.279     0.340     0.200
     2.239     0.332     0.200
     2.298     0.440     0.200
     0.712     0.352     0.200
     1.099    -0.220     0.200
     1.443     0.277     0.200
     2.250    -0.487     0.200
     2.279     0.375     0.200
     0.706     0.283     0.200
     1.106     0.203     0.200
     2.242    -0.315     0.200
     2.278     0.353     0.200
     2.295     0.398     0.200
     0.667     0.329     0.200
     1.123     0.768     0.200
     1.400     0.499     0.200
     2.214     0.208     0.200
     2.289     0.307     0.200
     2.321     0.616     0.200
     0.713     0.588     0.200
     1.096     0.756     0.200
     1.446     0.852     0.200
     2.253     0.664     0.200
     2.285     0.471     0.200
     2.282     0.935     0.200
     0.700     0.562     0.200
     0.700     0.262     0.200
     1.108     0.250     0.200
     1.108     0.149     0.200
     1.431     0.705     0.200
     2.298     0.202     0.200
     2.280     0.074     0.200
     2.280    -0.926     0.200
     2.239     0.695     0.200
     8.435   -15.481     0.200
     0.710     0.365     0.200
     1.103     0.211     0.200
     1.440     0.621     0.200
     2.246     0.358     0.200
     2.291     0.724     0.200
     2.278    -0.156     0.200
     0.720     0.334     0.200
     1.102     0.739     0.200
     1.447     0.487     0.200
     2.251    -0.188     0.200
     2.272     0.758     0.200
     0.708     0.390     0.200
     1.103     0.375     0.200
     1.439     0.638     0.200
     2.245    -0.037     0.200
     2.292     0.881     0.200
     2.279     0.098     0.200
     0.696     0.341     0.200
     1.091     0.226     0.200
     1.438     0.220     0.200
     2.251    -0.157     0.200
     2.284     0.488     0.200
     2.300     0.101     0.200
     2.399     0.144     0.200
     0.700     0.145     0.200
     1.090     0.497     0.200
     1.090     0.698     0.200
     1.441     0.255     0.200
     2.282     0.588     0.200
     2.282    -0.111     0.200
     2.297     1.308     0.200
     2.297    -0.591     0.200
     2.396     0.276     0.200
     2.396    -0.325     0.200
     2.253    -0.691     0.200
     2.253    -0.793     0.200
     0.685     0.385     0.200
     1.090     0.177     0.200
     1.432     0.128     0.200
     2.248    -0.151     0.200
     2.286     0.252     0.200
     2.308     0.246     0.200
     2.404    -0.182     0.200
     2.493    -1.525     0.200
     4.049    -9.827     0.200
     0.673     0.319     0.200
     1.110     0.637     0.200
     1.411    -0.199     0.200
     2.226    -0.240     0.200
     2.298    -0.192     0.200
     2.308     0.082     0.200
     0.217     0.482     0.200
     0.951     0.398     0.200
     1.452     0.329     0.200
     2.451    -0.847     0.200
     0.697     0.435     0.200
     1.103     0.544     0.200
     1.431     0.360     0.200
     2.241    -0.507     0.200
     2.295     0.656     0.200
     2.287     0.337     0.200
     0.353     0.493     0.200
     1.252     0.483     0.200
     2.045    -0.847     0.200
     2.452    -0.532     0.200
     2.477    -2.144     0.200
     2.494    -0.659     0.200
     8.098   -11.783     0.200
     0.650    -0.307     0.200
     1.142     0.312     0.200
     1.378     0.118     0.200
     2.192    -0.694     0.200
     2.285     0.172     0.200
     2.341    -0.116     0.200
     0.666     0.929     0.200
     1.378     0.854     0.200
     2.184     0.005     0.200
     2.259     0.444     0.200
     2.352    -0.213     0.200
     0.224     0.278     0.200
     1.443     0.613     0.200
     2.448    -0.321     0.200
     0.633     0.750     0.200
     1.196     0.785     0.200
     1.332     0.166     0.200
     2.140     0.278     0.200
     2.250     0.779     0.200
     2.395    -0.219     0.200
     0.660     0.669     0.200
     1.125     0.729     0.200
     1.395     0.293     0.200
     2.293    -0.473     0.200
     2.324     0.331     0.200
     2.210    -0.746     0.200
     2.442    -0.208     0.200
     0.676     0.255     0.200
     1.120     0.377     0.200
     2.315     0.077     0.200
     2.286     0.007     0.200
     2.220    -1.081     0.200
     2.430    -0.162     0.200
     8.410   -14.723     0.200
     0.695     0.474     0.200
     1.111     0.369     0.200
     1.425     0.321     0.200
     2.234    -0.313     0.200
     2.281     0.785     0.200
     2.303     0.293     0.200
     2.414    -0.046     0.200
     7.328   -24.314     0.200
     1.533    -0.276     0.200
     2.199     0.285     0.200
     0.662     0.801     0.200
     1.112     0.313     0.200
     2.221    -0.336     0.200
     2.304     0.135     0.200
     2.304    -0.665     0.200
     2.312    -0.218     0.200
     0.669     0.508     0.200
     1.091    -0.267     0.200
     1.421    -0.219     0.200
     2.241    -1.333     0.200
     2.291    -0.014     0.200
     2.486    -1.302     0.200
     0.710     0.321     0.200
     1.091     0.137     0.200
     1.447     0.364     0.200
     2.256    -0.685     0.200
     2.281     0.314     0.200
     2.289    -0.444     0.200
     0.229     0.191     0.200
     0.964     0.291     0.200
     1.441     0.276     0.200
     2.443    -0.191     0.200
     7.265   -11.888     0.200
     0.232    -0.018     0.200
     0.962    -0.168     0.200
     1.444    -0.141     0.200
     2.440    -0.420     0.200
     0.688    -0.234     0.200
     0.688     0.167     0.200
     1.104     0.202     0.200
     1.104     0.402     0.200
     1.425     0.104     0.200
     2.293     0.011     0.200
     2.298     0.246     0.200
     2.298     0.647     0.200
     2.412    -0.584     0.200
     2.412    -0.885     0.200
     0.529     1.036     0.200
     0.948     0.383     0.200
     1.450     0.241     0.200
     2.138    -1.841     0.200
     2.200     0.289     0.200
     2.429    -0.776     0.200
     0.546     0.415     0.200
     0.933     0.538     0.200
     1.464    -0.209     0.200
     2.185     0.755     0.200
     2.136    -0.484     0.200
     2.412    -0.239     0.200
     2.412    -0.438     0.200
     2.381    -0.973     0.200
     3.941    -6.853     0.200
     0.531     0.890     0.200
     0.947     0.587     0.200
     1.451     0.118     0.200
     2.140    -0.626     0.200
     2.199     0.499     0.200
     2.369    -0.401     0.200
     2.427    -0.340     0.200
     0.543     0.484     0.200
     0.935     0.367     0.200
     0.935     1.067     0.200
     2.132    -2.375     0.200
     2.187     0.376     0.200
     2.187     0.478     0.200
     2.381    -1.694     0.200
     2.415    -0.372     0.200
     2.415    -0.271     0.200
     8.248   -14.309     0.200
     0.547     0.528     0.200
     0.935     0.728     0.200
     1.462     0.125     0.200
     2.149    -1.347     0.200
     2.186     0.664     0.200
     2.376    -0.841     0.200
     2.409    -0.186     0.200
     0.546     0.715     0.200
     0.932     0.469     0.200
     1.466     0.037     0.200
     2.129    -0.678     0.200
     2.184     0.278     0.200
     2.384    -1.268     0.200
     2.413    -0.582     0.200
     0.551     0.552     0.200
     0.930     0.246     0.200
     1.467     0.121     0.200
     2.181    -0.223     0.200
     2.143    -1.214     0.200
     2.405    -0.309     0.200
     2.381    -0.760     0.200
     0.215     0.505     0.200
     0.941     0.617     0.200
     1.463     0.370     0.200
     2.450    -0.515     0.200
     0.720    -0.108     0.200
     1.101     0.633     0.200
     1.448     0.620     0.200
     2.252    -1.060     0.200
     2.287     0.935     0.200
     2.273     0.180     0.200
     2.394    -0.052     0.200
     0.696     0.643     0.200
     1.091     0.320     0.200
     1.438     0.743     0.200
     2.250    -0.621     0.200
     2.298     1.259     0.200
     2.285     0.289     0.200
     2.399    -0.043     0.200
     0.737     0.162     0.200
     1.055     0.197     0.200
     2.242     0.066     0.200
     2.352    -0.747     0.200
     2.296    -0.849     0.200
     0.897     0.203     0.200
     1.026     0.701     0.200
     2.073     0.320     0.200
     2.318     0.637     0.200
     2.441    -2.648     0.200
     2.441    -1.148     0.200
     0.324     0.340     0.200
     1.098     0.191     0.200
     1.318    -0.074     0.200
     1.980     0.052     0.200
     2.423    -0.316     0.200
     0.707     0.253     0.200
     0.995     0.730     0.200
     1.499    -0.036     0.200
     2.332    -0.759     0.200
     2.198     0.476     0.200
     2.390     0.005     0.200
     2.401    -1.355     0.200
     2.330    -0.205     0.200
     8.460   -15.907     0.200
     0.633     0.420     0.200
     0.633     0.220     0.200
     1.081     0.511     0.200
     1.081     0.711     0.200
     2.239    -1.094     0.200
     2.239    -0.694     0.200
     2.291    -0.045     0.200
     2.358     0.228     0.200
     2.358     0.128     0.200
     2.425    -0.283     0.200
     2.425    -1.383     0.200
     2.456    -1.272     0.200
     0.591     0.965     0.200
     0.591     1.168     0.200
     0.889     0.131     0.200
     0.889     0.733     0.200
     2.140    -0.846     0.200
     2.140    -0.647     0.200
     2.423    -2.509     0.200
     2.367    -0.832     0.200
     2.367    -1.332     0.200
     0.954     0.758     0.200
     0.954     0.559     0.200
     1.163     0.328     0.200
     1.900     0.365     0.200
     1.095     0.161     0.200
     1.444     0.101     0.200
     2.252    -0.431     0.200
     2.287    -0.121     0.200
     2.396    -1.076     0.200
     2.396     0.627     0.200
     0.552     0.350     0.200
     1.461     0.324     0.200
     2.166    -1.005     0.200
     2.186     0.345     0.200
     2.371    -0.701     0.200
     2.403    -0.421     0.200
     8.274   -13.395     0.200
     0.869     0.009     0.200
     0.930     0.081     0.200
     2.094     0.448     0.200
     2.352    -0.418     0.200
     2.413    -1.732     0.200
     2.449    -1.387     0.200
     0.868     0.565     0.200
     0.938     0.230     0.200
     1.637     0.482     0.200
     2.102     0.934     0.200
     2.202     0.070     0.200
     2.344     1.575     0.200
     2.421    -1.490     0.200
     2.442    -0.354     0.200
     0.866     0.425     0.200
     0.929     0.426     0.200
     1.640     0.284     0.200
     2.095     1.158     0.200
     2.197     0.209     0.200
     2.410    -1.345     0.200
     2.355     1.023     0.200
     2.448    -0.739     0.200
     0.917     0.219     0.200
     0.884     0.541     0.200
     2.179     0.416     0.200
     2.406    -1.199     0.200
     0.883     0.473     0.200
     0.917     0.294     0.200
     2.180     0.383     0.200
     2.406    -1.511     0.200
     0.883     0.774     0.200
     0.933     0.280     0.200
     2.189     0.446     0.200
     2.422    -1.742     0.200
     8.634   -14.501     0.200
     0.878     0.897     0.200
     0.913     0.298     0.200
     2.077     0.981     0.200
     2.180    -0.776     0.200
     2.399    -1.222     0.200
     2.365     0.281     0.200
     0.856     0.803     0.200
     0.935    -0.322     0.200
     2.104     0.141     0.200
     2.208     0.254     0.200
     2.413    -1.663     0.200
     2.353    -0.364     0.200
     2.438    -0.167     0.200
     0.855     0.897     0.200
     0.942     0.542     0.200
     2.212    -0.006     0.200
     2.420    -1.506     0.200
     2.346     1.437     0.200
     0.945    -0.004     0.200
     1.647     0.230     0.200
     2.101     0.938     0.200
     2.195     0.176     0.200
     2.327     0.880     0.200
     2.447    -1.019     0.200
     0.728     0.880     0.200
     1.051     0.923     0.200
EOF
gmt end
