#!/bin/bash
gmt begin chara1.31_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional chara1.31'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.933
    15.000    42.654
    15.500    42.373
    16.000    42.089
    16.500    41.800
    17.000    41.504
    17.500    41.200
    18.000    40.885
    18.500    40.558
    19.000    40.217
    19.500    39.859
    20.000    39.482
    20.500    39.084
    21.000    38.663
    21.500    38.216
    22.000    37.740
    22.500    37.236
    23.000    36.699
    23.500    36.130
    24.000    34.930
    24.500    33.659
    25.000    32.378
    25.500    31.086
    26.000    29.783
    26.500    28.469
    27.000    27.143
    27.500    25.800
    28.000    24.437
    28.500    23.059
    29.000    21.669
    29.500    20.271
    30.000    18.864
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.437 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    10.381
     1.500    11.412
     2.000    12.442
     2.500    13.473
     3.000    14.504
     3.500    15.534
     4.000    16.562
     4.500    17.589
     5.000    18.616
     5.500    19.641
     6.000    20.665
     6.500    21.687
     7.000    22.707
     7.500    23.724
     8.000    24.741
     8.500    25.754
     9.000    26.765
     9.500    27.773
    10.000    28.779
    10.500    29.782
    11.000    30.781
    11.500    31.777
    12.000    32.769
    12.500    33.759
    13.000    34.745
    13.500    35.727
    14.000    36.705
    14.500    37.628
    15.000    38.370
    15.500    39.071
    16.000    39.694
    16.500    40.212
    17.000    40.665
    17.500    40.034
    18.000    40.384
    18.500    40.675
    19.000    40.908
    19.500    41.083
    20.000    41.199
    20.500    41.257
    21.000    41.254
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    31.745 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.857
     1.000     7.545
     1.500    10.533
     2.000    13.224
     2.500    15.915
     3.000    18.606
     3.500    21.295
     4.000    23.983
     4.500    26.670
     5.000    29.356
     5.500    32.040
     6.000    34.724
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    27.356 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    31.665
     2.000    37.830
     2.500    43.995
     3.000    50.160
     3.500    56.325
     4.000    62.487
     4.500    68.648
     5.000    74.808
     5.500    80.966
     6.000    87.122
     6.500    93.275
     7.000    99.426
     7.500   105.574
     8.000   111.719
     8.500   117.861
     9.000   123.999
     9.500   130.134
    10.000   136.266
    10.500   142.393
    11.000   148.515
    11.500   154.633
    12.000   160.747
    12.500   166.854
    13.000   172.957
    13.500   179.055
    14.000   185.146
    14.500   191.232
    15.000   197.312
    15.500   203.384
    16.000   209.450
    16.500   215.510
    17.000   221.563
    17.500   234.958
    18.000   241.230
    18.500   247.490
    19.000   253.737
    19.500   259.970
    20.000   266.190
    20.500   272.395
    21.000   278.585
    21.500   284.761
    22.000   290.920
    22.500   297.064
    23.000   303.191
    23.500   309.302
    24.000   315.395
    24.500   321.471
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    60.487 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.413
     1.000    20.540
     1.500    29.687
     2.000    38.246
     2.500    46.806
     3.000    55.364
     3.500    63.921
     4.000    72.476
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    61.921 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    23.448   295.188     0.150
    23.801   293.062     0.150
    17.598    48.048     0.150
    17.598   246.048     0.150
    20.124   398.083     0.150
    14.260   216.179     0.150
    15.483   216.910     0.150
    18.623    50.265     0.150
    18.623   249.265     0.150
    20.175    50.155     0.150
    20.802   266.832     0.150
    22.886   285.515     0.150
    23.586   303.342     0.150
    23.735   287.604     0.150
    23.735   299.604     0.150
    24.549   289.108     0.150
    26.376  -295.806     0.150
    26.376   316.788     0.150
    27.057  -306.757     0.150
    29.166   310.230     0.150
    29.166   204.230     0.150
    29.195  -329.709     0.150
    29.195   307.885     0.150
    29.578   308.420     0.150
    29.588   308.304     0.150
    15.267   222.504     0.150
    16.356    46.793     0.150
    17.915   243.601     0.150
    20.451    51.007     0.150
    27.591   311.482     0.150
    14.099   273.975     0.150
    15.281    48.186     0.150
    15.281    53.686     0.150
    16.893    58.376     0.150
    20.152   262.338     0.150
    21.000   267.447     0.150
    21.591   270.447     0.150
    23.440   290.970     0.150
    24.279   291.181     0.150
    27.256   306.438     0.150
    17.221    44.810     0.150
    19.896   393.600     0.150
    21.593   426.792     0.150
    20.120    46.157     0.150
    20.427   262.822     0.150
    23.951   288.396     0.150
    23.951   339.896     0.150
    16.337   229.665     0.150
    16.337   236.864     0.150
    16.337   332.665     0.150
    20.961    44.900     0.150
    20.961    47.700     0.150
    20.961   272.700     0.150
    20.961   278.900     0.150
    20.961   305.900     0.150
    20.961   417.400     0.150
    22.655   323.636     0.150
    22.994   283.182     0.150
    14.100   355.888     0.150
    14.100   568.788     0.150
    14.100   574.288     0.150
    14.100   788.688     0.150
    22.663   288.058     0.150
    22.663   322.458     0.150
    22.996   284.076     0.150
    22.996   290.976     0.150
    23.440   473.198     0.150
    23.469   289.251     0.150
    24.597   294.789     0.150
    24.597   303.789     0.150
    25.643   300.188     0.150
    25.643   305.988     0.150
    20.763    51.962     0.150
    20.763    54.763     0.150
    24.699   288.236     0.150
    24.308   286.430     0.150
    16.083   334.785     0.150
    16.083   546.785     0.150
    16.083   548.887     0.150
    24.823    64.122     0.150
    23.985   473.986     0.150
    18.776    63.961     0.150
    20.590   269.386     0.150
    21.888    64.241     0.150
    21.888   315.542     0.150
    22.214   284.032     0.150
    22.938   288.392     0.150
    23.074   292.645     0.150
    23.878   476.225     0.150
    24.055   257.459     0.150
    25.101   302.647     0.150
    27.110   312.400     0.150
    17.827    50.204     0.150
    16.247   230.608     0.150
    16.291   224.794     0.150
    18.754   252.957     0.150
    19.067   258.704     0.150
    19.102   256.494     0.150
    19.102   278.791     0.150
    19.447   261.142     0.150
    20.015    61.131     0.150
    21.377   274.440     0.150
    21.891   279.246     0.150
    22.183    66.537     0.150
    22.183   321.037     0.150
    22.834   288.947     0.150
    23.001   288.290     0.150
    23.169   287.908     0.150
    23.361   294.089     0.150
    24.085   292.340     0.150
    24.085   303.340     0.150
    24.916   299.346     0.150
    24.957   297.795     0.150
    25.011   298.208     0.150
    25.042   299.674     0.150
    25.879   357.903     0.150
    26.203   305.624     0.150
    27.664   310.580     0.150
    27.664   318.877     0.150
    28.387   310.141     0.150
    28.378   310.541     0.150
    19.480    51.351     0.150
    16.869   233.219     0.150
    24.070   473.709     0.150
    17.847   247.902     0.150
    20.869    44.541     0.150
    22.968   485.835     0.150
    23.878   475.298     0.150
    23.917   475.304     0.150
    25.657   303.455     0.150
    17.618   245.884     0.150
    18.061   246.418     0.150
    19.036   260.441     0.150
    22.065   292.880     0.150
    22.314   285.787     0.150
    22.753   283.356     0.150
    23.087   293.456     0.150
    23.654   291.145     0.150
    27.226   312.356     0.150
    18.836    48.736     0.150
    14.981   215.226     0.150
    16.252   227.194     0.150
    16.399   229.872     0.150
    17.617    46.875     0.150
    17.617   249.875     0.150
    17.602   240.834     0.150
    18.046    50.655     0.150
    18.070   252.000     0.150
    19.039   262.244     0.150
    19.023   260.153     0.150
    19.759   257.965     0.150
    20.104    62.239     0.150
    20.587   269.303     0.150
    21.629   310.643     0.150
    21.863    63.219     0.150
    21.863   284.117     0.150
    21.863   726.219     0.150
    22.307   286.829     0.150
    22.758   285.972     0.150
    23.077   290.441     0.150
    23.292   293.332     0.150
    23.646   290.605     0.150
    23.672   290.913     0.150
    23.754   475.746     0.150
    25.384   301.525     0.150
    25.862   309.041     0.150
    27.175  -314.526     0.150
    28.315   316.720     0.150
    17.605   240.915     0.150
    23.081   295.609     0.150
    23.757   477.115     0.150
    22.723   483.301     0.150
    22.722   284.252     0.150
    23.777   294.647     0.150
    12.847    45.368     0.150
    23.789   293.275     0.150
    23.609   475.162     0.150
    15.416   219.792     0.150
    16.611   225.746     0.150
    18.415   252.095     0.150
    22.507   286.940     0.150
    22.661    64.646     0.150
    23.356   293.531     0.150
    23.834   289.651     0.150
    25.460   299.573     0.150
    25.726   301.478     0.150
    26.795  -308.040     0.150
    23.324   482.853     0.150
    23.517   262.826     0.150
    23.543   261.827     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    17.835    42.689     0.200
    18.171    43.361     0.200
    18.186    43.585     0.200
    18.186    44.585     0.200
    18.687    40.741     0.200
    22.759    37.617     0.200
    23.448    38.188     0.200
    23.801    36.062     0.200
    24.219    34.190     0.200
    28.630    24.708     0.200
    23.028    38.685     0.200
    28.893    24.244     0.200
    18.041    42.387     0.200
    18.041    42.887     0.200
    18.337    42.835     0.200
    18.531    38.668     0.200
    18.531    38.769     0.200
    22.330    40.335     0.200
    22.776    40.624     0.200
    22.926    37.375     0.200
    22.926    37.773     0.200
    23.100    38.854     0.200
    25.883    33.872     0.200
    28.791    23.932     0.200
    28.801    24.622     0.200
    18.386    43.720     0.200
    18.431    46.399     0.200
    19.527    41.501     0.200
    18.276    41.885     0.200
    14.260    40.179     0.200
    14.473    39.192     0.200
    15.906    38.973     0.200
    17.244    42.157     0.200
    17.487    40.024     0.200
    17.775    41.163     0.200
    17.921    40.660     0.200
    21.254    38.453     0.200
    21.607    40.440     0.200
    21.607    40.737     0.200
    21.662    37.794     0.200
    21.662    38.294     0.200
    21.740    39.888     0.200
    21.740    40.287     0.200
    21.852    39.688     0.200
    21.876    37.102     0.200
    22.886    35.515     0.200
    23.586    36.138     0.200
    23.634    31.788     0.200
    23.634    32.491     0.200
    23.735    35.104     0.200
    23.771    33.189     0.200
    23.771    33.892     0.200
    24.207    32.093     0.200
    24.207    32.195     0.200
    24.324    31.737     0.200
    24.324    32.534     0.200
    24.342    33.729     0.200
    24.372    30.173     0.200
    24.372    30.470     0.200
    24.549    31.108     0.200
    24.733    30.956     0.200
    24.733    31.558     0.200
    24.746    31.805     0.200
    24.746    32.204     0.200
    25.270    28.696     0.200
    25.373    30.997     0.200
    25.410    29.064     0.200
    25.410    29.166     0.200
    25.556    28.361     0.200
    25.618    28.636     0.200
    25.618    28.737     0.200
    25.836    28.082     0.200
    26.376    26.788     0.200
    27.057    26.336     0.200
    28.499    22.810     0.200
    29.166    19.230     0.200
    29.578    19.420     0.200
    29.588    19.304     0.200
    15.267    42.504     0.200
    16.663    42.718     0.200
    16.877    40.723     0.200
    17.915    41.601     0.200
    18.033    42.226     0.200
    20.148    39.548     0.200
    20.521    38.192     0.200
    20.521    38.294     0.200
    20.985    39.774     0.200
    21.710    42.318     0.200
    21.710    43.021     0.200
    21.776    38.543     0.200
    21.776    39.442     0.200
    22.677    39.030     0.200
    23.018    38.658     0.200
    23.447    37.047     0.200
    23.450    37.117     0.200
    23.493    32.505     0.200
    23.493    33.208     0.200
    23.570    35.616     0.200
    23.570    35.717     0.200
    23.900    34.554     0.200
    23.962    34.141     0.200
    24.083    33.821     0.200
    24.250    34.467     0.200
    24.270    32.437     0.200
    24.381    31.248     0.200
    24.599    35.199     0.200
    24.862    33.530     0.200
    25.004    31.675     0.200
    25.195    30.641     0.200
    25.643    31.418     0.200
    25.697    31.990     0.200
    26.220    29.180     0.200
    27.003    26.649     0.200
    27.591    27.482     0.200
    29.115    23.899     0.200
    16.679    42.375     0.200
    17.930    43.272     0.200
    18.035    41.800     0.200
    18.035    42.050     0.200
    19.954    39.655     0.200
    19.954    40.456     0.200
    20.152    40.338     0.200
    21.000    40.447     0.200
    21.591    39.548     0.200
    21.591    39.748     0.200
    21.716    37.890     0.200
    21.779    39.350     0.200
    21.779    39.452     0.200
    22.693    39.490     0.200
    23.027    38.984     0.200
    23.500    34.276     0.200
    23.500    34.776     0.200
    23.466    38.169     0.200
    23.577    35.375     0.200
    23.577    35.976     0.200
    23.911    35.474     0.200
    23.911    35.673     0.200
    24.092    34.360     0.200
    24.092    34.559     0.200
    24.279    32.872     0.200
    24.279    33.181     0.200
    24.297    34.972     0.200
    24.391    33.877     0.200
    24.391    34.678     0.200
    24.615    35.060     0.200
    24.872    31.256     0.200
    25.012    31.625     0.200
    25.116    30.416     0.200
    25.116    31.315     0.200
    25.206    31.358     0.200
    25.330    31.913     0.200
    25.467    29.319     0.200
    25.467    29.819     0.200
    25.658    31.585     0.200
    27.256    27.438     0.200
    27.607    27.739     0.200
    29.122    23.660     0.200
    16.960    44.862     0.200
    21.593    39.792     0.200
    23.509    38.035     0.200
    24.056    35.342     0.200
    18.607    42.872     0.200
    18.528    39.696     0.200
    16.925    43.385     0.200
    19.211    41.465     0.200
    21.241    40.025     0.200
    21.743    39.161     0.200
    23.728    35.395     0.200
    23.922    37.232     0.200
    23.951    36.396     0.200
    28.136    24.854     0.200
    24.313    37.191     0.200
    16.337    45.665     0.200
    16.647    44.245     0.200
    16.670    41.907     0.200
    16.856    41.606     0.200
    17.484    40.927     0.200
    22.655    39.437     0.200
    22.994    37.983     0.200
    23.469    38.238     0.200
    23.469    36.668     0.200
    23.784    35.639     0.200
    23.930    35.730     0.200
    24.586    35.097     0.200
    25.632    32.198     0.200
    27.196    26.821     0.200
    27.238    26.636     0.200
    15.271    40.530     0.200
    17.482    40.325     0.200
    18.053    44.163     0.200
    20.031    40.416     0.200
    20.328    37.737     0.200
    22.663    39.058     0.200
    22.996    38.476     0.200
    23.440    36.898     0.200
    23.469    38.251     0.200
    24.283    32.551     0.200
    24.492    32.014     0.200
    24.492    33.754     0.200
    24.597    34.388     0.200
    25.643    31.288     0.200
    26.215    30.411     0.200
    27.027    27.581     0.200
    24.581    36.164     0.200
    26.772    26.590     0.200
    26.773    27.756     0.200
    27.183    29.156     0.200
    24.167    34.379     0.200
    24.304    37.156     0.200
    23.829    36.972     0.200
    23.868    37.630     0.200
    24.047    38.744     0.200
    25.094    35.625     0.200
    24.319    36.284     0.200
    24.319    37.010     0.200
    21.335    40.847     0.200
    23.975    34.838     0.200
    24.126    33.977     0.200
    24.182    35.445     0.200
    27.325    26.953     0.200
    27.366    25.661     0.200
    28.100    23.242     0.200
    16.034    46.550     0.200
    23.443    36.988     0.200
    23.880    38.486     0.200
    23.968    36.264     0.200
    23.957    38.737     0.200
    24.240    36.186     0.200
    24.699    35.637     0.200
    25.281    35.939     0.200
    26.948    29.290     0.200
    27.352    28.426     0.200
    28.134    26.443     0.200
    23.873    33.858     0.200
    23.953    37.705     0.200
    24.252    36.836     0.200
    27.343    29.433     0.200
    28.125    23.739     0.200
    24.570    35.785     0.200
    24.776    31.134     0.200
    20.137    39.802     0.200
    21.154    41.045     0.200
    24.126    37.314     0.200
    24.308    33.430     0.200
    24.221    36.197     0.200
    24.258    36.219     0.200
    16.083    43.683     0.200
    24.092    35.137     0.200
    24.092    35.957     0.200
    24.163    36.554     0.200
    24.187    34.848     0.200
    27.561    26.329     0.200
    27.604    25.832     0.200
    17.288    41.471     0.200
    24.716    36.804     0.200
    24.813    35.708     0.200
    23.568    37.545     0.200
    27.091    27.837     0.200
    19.164    41.164     0.200
    19.164    41.254     0.200
    19.751    40.305     0.200
    20.651    39.201     0.200
    21.402    38.235     0.200
    22.852    41.583     0.200
    22.854    41.553     0.200
    23.960    36.794     0.200
    23.960    37.942     0.200
    23.991    37.719     0.200
    23.991    37.423     0.200
    23.991    37.422     0.200
    23.991    37.719     0.200
    24.000    37.242     0.200
    24.054    37.218     0.200
    24.157    38.084     0.200
    24.823    33.223     0.200
    27.469    28.332     0.200
    27.512    27.638     0.200
    18.435    37.512     0.200
    19.037    41.026     0.200
    21.129    41.368     0.200
    23.876    36.413     0.200
    27.303    26.023     0.200
    23.800    37.628     0.200
    23.830    37.894     0.200
    23.551    38.314     0.200
    17.645    38.578     0.200
    17.645    39.027     0.200
    22.383    35.992     0.200
    23.888    32.564     0.200
    24.252    33.821     0.200
    24.349    32.718     0.200
    24.468    32.651     0.200
    24.468    32.901     0.200
    15.627    44.799     0.200
    17.950    39.393     0.200
    19.035    38.625     0.200
    19.620    38.498     0.200
    22.745    34.436     0.200
    22.745    35.986     0.200
    22.745    34.736     0.200
    23.888    34.588     0.200
    23.985    33.499     0.200
    24.108    34.080     0.200
    24.108    33.920     0.200
    24.108    34.595     0.200
    24.108    34.400     0.200
    24.237    33.517     0.200
    27.229    24.762     0.200
    14.874    43.046     0.200
    15.840    46.925     0.200
    16.120    46.649     0.200
    17.677    42.932     0.200
    18.543    41.075     0.200
    18.844    44.071     0.200
    19.408    43.779     0.200
    19.820    43.024     0.200
    19.820    43.607     0.200
    19.907    43.363     0.200
    20.590    41.785     0.200
    20.730    42.849     0.200
    21.502    42.341     0.200
    21.888    43.838     0.200
    22.067    39.270     0.200
    22.214    42.235     0.200
    22.965    38.671     0.200
    22.965    38.351     0.200
    22.965    39.062     0.200
    22.833    43.607     0.200
    22.938    39.091     0.200
    23.527    38.609     0.200
    23.510    39.102     0.200
    23.870    36.469     0.200
    23.838    37.944     0.200
    23.838    38.784     0.200
    23.878    38.213     0.200
    23.878    38.815     0.200
    23.878    37.361     0.200
    23.878    38.361     0.200
    23.933    37.688     0.200
    24.044    38.320     0.200
    24.055    41.057     0.200
    24.874    34.658     0.200
    24.874    34.201     0.200
    24.658    34.816     0.200
    25.101    34.049     0.200
    25.362    37.000     0.200
    25.681    37.081     0.200
    26.515    32.311     0.200
    27.122    28.493     0.200
    27.110    32.501     0.200
    27.344    28.348     0.200
    27.387    29.642     0.200
    27.387    28.970     0.200
    27.515    27.057     0.200
    27.722    25.235     0.200
    27.947    27.946     0.200
    27.970    25.376     0.200
    28.970    23.057     0.200
    29.049    24.250     0.200
    18.954    36.928     0.200
    23.878    35.267     0.200
    24.878    31.417     0.200
    22.965    39.906     0.200
    23.838    40.440     0.200
    23.879    39.437     0.200
    23.933    39.336     0.200
    18.794    38.236     0.200
    18.794    38.389     0.200
    23.753    38.364     0.200
    23.820    37.479     0.200
    23.820    37.752     0.200
    23.848    37.280     0.200
    27.237    28.580     0.200
    18.986    38.620     0.200
    20.082    36.842     0.200
    25.025    33.138     0.200
    25.122    32.007     0.200
    28.356    22.755     0.200
    18.740    37.761     0.200
    24.145    37.559     0.200
    24.241    36.473     0.200
    24.278    36.346     0.200
    16.247    43.311     0.200
    16.835    41.046     0.200
    19.067    41.907     0.200
    19.192    40.693     0.200
    19.192    42.404     0.200
    19.385    40.514     0.200
    19.447    40.018     0.200
    20.015    40.631     0.200
    20.110    38.589     0.200
    20.110    38.128     0.200
    20.110    40.104     0.200
    20.392    38.200     0.200
    20.392    40.802     0.200
    20.619    38.007     0.200
    20.657    36.874     0.200
    20.657    38.241     0.200
    21.377    38.940     0.200
    21.891    35.809     0.200
    21.891    36.450     0.200
    21.891    38.098     0.200
    22.453    36.646     0.200
    22.453    37.888     0.200
    22.453    38.451     0.200
    22.183    39.537     0.200
    22.996    35.805     0.200
    22.996    36.953     0.200
    23.001    38.595     0.200
    23.163    37.410     0.200
    23.167    36.707     0.200
    23.167    36.457     0.200
    23.169    35.041     0.200
    23.169    36.384     0.200
    23.143    38.122     0.200
    23.361    39.292     0.200
    23.718    34.522     0.200
    23.718    31.373     0.200
    24.131    32.648     0.200
    24.131    34.008     0.200
    23.833    35.213     0.200
    24.129    35.144     0.200
    23.868    36.669     0.200
    24.085    34.340     0.200
    24.228    33.246     0.200
    24.228    34.371     0.200
    24.386    32.760     0.200
    24.386    34.877     0.200
    24.916    31.596     0.200
    24.916    32.940     0.200
    24.916    33.932     0.200
    24.957    34.373     0.200
    24.957    33.013     0.200
    24.957    33.545     0.200
    25.011    31.810     0.200
    25.042    32.970     0.200
    25.123    31.597     0.200
    25.879    30.903     0.200
    26.203    31.124     0.200
    26.884    26.971     0.200
    28.201    24.998     0.200
    28.387    22.687     0.200
    28.415    23.206     0.200
    28.378    24.244     0.200
    28.586    23.930     0.200
    28.791    21.679     0.200
    29.041    22.930     0.200
    29.439    21.686     0.200
    18.232    44.112     0.200
    23.962    36.047     0.200
    17.644    40.152     0.200
    18.552    35.557     0.200
    18.552    38.658     0.200
    19.458    37.506     0.200
    20.398    36.864     0.200
    23.910    35.238     0.200
    24.146    32.850     0.200
    24.159    34.826     0.200
    24.405    33.721     0.200
    24.508    33.119     0.200
    27.654    24.691     0.200
    23.978    36.249     0.200
    24.074    35.177     0.200
    24.129    35.987     0.200
    24.129    34.940     0.200
    24.129    38.190     0.200
    27.379    27.010     0.200
    17.287    41.396     0.200
    18.075    41.607     0.200
    18.571    36.939     0.200
    19.145    38.906     0.200
    21.079    41.747     0.200
    22.711    39.000     0.200
    23.979    35.706     0.200
    23.979    36.160     0.200
    24.075    36.642     0.200
    24.131    35.636     0.200
    24.131    34.112     0.200
    24.131    36.440     0.200
    24.131    38.034     0.200
    24.131    36.972     0.200
    24.293    36.241     0.200
    27.379    29.064     0.200
    27.407    27.502     0.200
    29.878    20.467     0.200
    29.939    21.984     0.200
    17.285    42.977     0.200
    18.071    42.810     0.200
    19.143    41.189     0.200
    19.649    42.498     0.200
    20.288    41.423     0.200
    23.977    38.187     0.200
    24.073    35.622     0.200
    24.131    33.892     0.200
    24.131    35.666     0.200
    24.179    37.225     0.200
    24.330    35.574     0.200
    27.376    28.157     0.200
    18.078    41.334     0.200
    18.078    40.928     0.200
    18.560    36.580     0.200
    18.560    37.002     0.200
    19.135    38.564     0.200
    19.641    38.393     0.200
    23.970    36.875     0.200
    23.970    34.915     0.200
    24.066    35.756     0.200
    24.123    33.788     0.200
    24.123    35.694     0.200
    24.123    35.303     0.200
    24.285    35.393     0.200
    27.369    27.206     0.200
    16.453    46.216     0.200
    17.276    40.504     0.200
    18.062    41.341     0.200
    18.562    38.376     0.200
    18.562    36.702     0.200
    18.562    36.532     0.200
    19.149    41.751     0.200
    20.291    41.681     0.200
    21.094    41.251     0.200
    22.704    39.444     0.200
    23.203    40.544     0.200
    23.424    41.091     0.200
    23.984    34.830     0.200
    23.984    36.099     0.200
    24.080    36.735     0.200
    24.320    32.901     0.200
    24.139    33.921     0.200
    24.139    35.921     0.200
    24.139    37.321     0.200
    24.139    36.472     0.200
    24.301    36.928     0.200
    27.381    28.456     0.200
    27.409    24.354     0.200
    29.500    24.030     0.200
    16.881    45.266     0.200
    18.569    38.468     0.200
    19.158    41.598     0.200
    23.992    36.377     0.200
    24.088    35.207     0.200
    24.147    35.979     0.200
    24.147    36.276     0.200
    24.147    37.776     0.200
    27.390    27.374     0.200
    17.283    40.446     0.200
    17.283    41.399     0.200
    18.069    40.351     0.200
    18.069    41.226     0.200
    18.566    37.080     0.200
    19.146    40.992     0.200
    19.146    41.375     0.200
    20.285    36.464     0.200
    21.086    41.421     0.200
    22.963    38.196     0.200
    23.980    35.748     0.200
    24.178    33.833     0.200
    24.076    35.309     0.200
    24.133    37.059     0.200
    24.133    35.934     0.200
    24.133    36.160     0.200
    24.133    35.340     0.200
    24.329    32.053     0.200
    24.296    34.266     0.200
    27.120    26.418     0.200
    27.379    27.709     0.200
    27.407    27.654     0.200
    27.407    26.631     0.200
    27.882    25.706     0.200
    29.494    20.776     0.200
    18.078    40.757     0.200
    18.570    39.115     0.200
    23.976    37.928     0.200
    24.071    36.758     0.200
    24.128    35.779     0.200
    16.869    42.017     0.200
    18.075    40.673     0.200
    18.075    42.150     0.200
    18.563    36.952     0.200
    18.563    36.751     0.200
    19.645    39.823     0.200
    21.081    41.562     0.200
    21.210    42.157     0.200
    22.715    39.013     0.200
    22.960    39.918     0.200
    23.974    37.904     0.200
    23.974    36.363     0.200
    24.070    36.742     0.200
    24.127    33.614     0.200
    24.127    36.237     0.200
    24.127    37.014     0.200
    24.127    36.024     0.200
    27.401    28.608     0.200
    18.295    40.643     0.200
    18.540    39.686     0.200
    18.957    41.641     0.200
    23.784    37.359     0.200
    23.880    36.259     0.200
    23.919    36.014     0.200
    15.656    48.373     0.200
    16.279    43.301     0.200
    16.531    45.563     0.200
    17.512    40.130     0.200
    17.512    40.912     0.200
    17.512    40.611     0.200
    17.512    41.380     0.200
    17.847    45.601     0.200
    18.029    40.882     0.200
    18.298    41.445     0.200
    18.298    41.644     0.200
    18.540    36.191     0.200
    18.955    38.915     0.200
    18.955    39.415     0.200
    19.939    39.479     0.200
    20.265    38.707     0.200
    20.265    38.887     0.200
    21.805    38.322     0.200
    22.601    40.217     0.200
    22.766    39.825     0.200
    22.968    40.936     0.200
    22.924    39.251     0.200
    22.924    36.841     0.200
    22.924    39.939     0.200
    22.924    37.642     0.200
    23.482    36.310     0.200
    23.782    35.637     0.200
    23.782    35.176     0.200
    23.782    36.309     0.200
    23.878    35.872     0.200
    23.917    36.171     0.200
    23.917    35.359     0.200
    23.917    35.956     0.200
    23.917    36.269     0.200
    23.917    35.812     0.200
    24.079    35.170     0.200
    24.079    35.842     0.200
    24.233    34.596     0.200
    24.229    35.091     0.200
    24.235    37.018     0.200
    24.235    34.046     0.200
    24.546    34.631     0.200
    24.546    33.779     0.200
    24.546    34.498     0.200
    24.865    33.262     0.200
    25.657    32.756     0.200
    27.205    27.366     0.200
    27.234    27.262     0.200
    27.234    25.602     0.200
    27.662    25.363     0.200
    29.659    19.652     0.200
    18.063    43.200     0.200
    18.063    42.223     0.200
    18.571    40.404     0.200
    18.571    40.303     0.200
    19.153    41.215     0.200
    20.282    40.578     0.200
    21.090    41.699     0.200
    22.701    40.514     0.200
    23.988    37.890     0.200
    23.988    36.718     0.200
    24.083    35.599     0.200
    24.141    36.102     0.200
    24.141    35.402     0.200
    24.141    36.000     0.200
    27.386    26.991     0.200
    16.877    40.821     0.200
    18.065    41.662     0.200
    18.563    37.652     0.200
    19.654    38.422     0.200
    21.091    41.750     0.200
    22.804    41.453     0.200
    24.077    36.568     0.200
    24.136    35.010     0.200
    24.136    36.586     0.200
    27.885    22.457     0.200
    23.100    39.249     0.200
    23.740    37.554     0.200
    23.757    37.312     0.200
    15.995    46.318     0.200
    17.738    42.087     0.200
    17.738    42.493     0.200
    17.618    45.282     0.200
    18.061    45.020     0.200
    18.676    39.030     0.200
    18.851    41.215     0.200
    18.851    42.222     0.200
    19.938    40.701     0.200
    20.044    41.576     0.200
    20.058    41.513     0.200
    20.085    42.697     0.200
    20.085    43.041     0.200
    20.118    42.607     0.200
    22.065    41.685     0.200
    22.478    40.394     0.200
    22.753    42.356     0.200
    23.094    36.676     0.200
    23.094    38.192     0.200
    23.094    38.778     0.200
    23.094    38.574     0.200
    23.094    37.848     0.200
    23.107    36.632     0.200
    23.302    36.550     0.200
    23.087    40.956     0.200
    23.654    37.200     0.200
    23.654    35.841     0.200
    23.654    38.442     0.200
    23.661    37.042     0.200
    23.661    37.620     0.200
    23.756    36.776     0.200
    23.746    37.474     0.200
    23.746    36.177     0.200
    23.746    37.076     0.200
    23.746    38.076     0.200
    23.910    35.660     0.200
    23.910    38.441     0.200
    23.910    35.761     0.200
    24.140    37.097     0.200
    24.277    39.779     0.200
    24.824    34.489     0.200
    24.824    32.989     0.200
    24.824    34.950     0.200
    25.386    34.437     0.200
    25.875    34.921     0.200
    26.676    29.671     0.200
    26.987    32.049     0.200
    27.133    28.323     0.200
    27.226    29.356     0.200
    27.478    27.122     0.200
    27.604    28.550     0.200
    27.824    29.986     0.200
    27.850    29.673     0.200
    28.920    26.789     0.200
    29.059    25.964     0.200
    29.076    22.905     0.200
    29.076    23.484     0.200
    18.316    41.662     0.200
    19.199    36.635     0.200
    22.646    37.133     0.200
    22.646    38.608     0.200
    24.179    37.516     0.200
    24.202    36.305     0.200
    24.273    36.440     0.200
    27.689    27.799     0.200
    18.563    40.160     0.200
    18.563    39.660     0.200
    18.678    39.146     0.200
    22.468    39.020     0.200
    23.654    39.558     0.200
    23.737    38.484     0.200
    23.737    37.085     0.200
    23.749    36.074     0.200
    24.835    32.674     0.200
    18.554    37.920     0.200
    23.097    35.497     0.200
    15.136    43.520     0.200
    15.136    43.557     0.200
    15.991    45.768     0.200
    18.552    39.931     0.200
    18.685    37.599     0.200
    18.685    38.927     0.200
    18.858    41.057     0.200
    19.275    40.841     0.200
    20.076    42.280     0.200
    22.756    39.816     0.200
    23.089    38.024     0.200
    23.089    37.899     0.200
    23.649    36.438     0.200
    23.667    37.388     0.200
    23.667    38.084     0.200
    23.751    36.110     0.200
    23.751    39.009     0.200
    23.751    37.774     0.200
    23.915    37.397     0.200
    24.825    32.278     0.200
    27.140    29.510     0.200
    28.640    25.549     0.200
    29.080    24.543     0.200
    18.556    40.007     0.200
    18.657    39.723     0.200
    19.258    40.005     0.200
    23.105    38.886     0.200
    23.647    35.792     0.200
    23.735    36.367     0.200
    23.735    37.318     0.200
    23.742    38.582     0.200
    24.823    33.472     0.200
    19.981    40.845     0.200
    22.940    38.943     0.200
    23.035    37.833     0.200
    23.016    37.215     0.200
    25.531    31.792     0.200
    14.981    44.726     0.200
    15.985    46.008     0.200
    16.399    45.872     0.200
    18.070    45.277     0.200
    18.694    39.496     0.200
    18.863    41.978     0.200
    18.863    40.877     0.200
    18.863    42.595     0.200
    19.278    43.377     0.200
    19.759    44.070     0.200
    19.759    43.265     0.200
    19.759    43.570     0.200
    19.923    41.895     0.200
    20.041    43.277     0.200
    20.068    41.961     0.200
    20.068    41.942     0.200
    20.068    40.782     0.200
    20.104    42.536     0.200
    20.976    43.362     0.200
    21.629    45.842     0.200
    21.746    39.933     0.200
    21.863    41.617     0.200
    22.054    43.386     0.200
    22.307    41.829     0.200
    22.471    39.491     0.200
    22.758    42.472     0.200
    23.086    35.727     0.200
    23.086    37.938     0.200
    23.086    39.786     0.200
    23.086    37.766     0.200
    23.077    39.941     0.200
    23.292    35.832     0.200
    23.646    35.375     0.200
    23.646    39.516     0.200
    23.646    38.805     0.200
    23.646    35.805     0.200
    23.646    38.105     0.200
    23.672    38.034     0.200
    23.672    36.061     0.200
    23.672    36.303     0.200
    23.672    38.264     0.200
    23.672    39.202     0.200
    23.767    36.644     0.200
    23.754    36.945     0.200
    23.754    37.445     0.200
    23.754    37.422     0.200
    23.754    36.266     0.200
    23.764    37.422     0.200
    23.918    35.829     0.200
    23.918    37.188     0.200
    24.121    36.457     0.200
    24.123    38.251     0.200
    24.123    37.130     0.200
    24.262    39.415     0.200
    24.828    33.817     0.200
    24.828    31.555     0.200
    24.828    36.528     0.200
    24.828    34.817     0.200
    25.174    31.881     0.200
    25.174    33.670     0.200
    25.320    36.272     0.200
    25.384    34.423     0.200
    25.862    34.541     0.200
    26.347    32.472     0.200
    26.347    34.132     0.200
    26.347    33.581     0.200
    26.347    33.280     0.200
    26.666    31.165     0.200
    26.666    32.864     0.200
    26.995    30.222     0.200
    27.146    28.887     0.200
    27.175    28.127     0.200
    27.219    32.012     0.200
    27.485    28.502     0.200
    27.816    30.543     0.200
    27.831    28.163     0.200
    27.858    27.854     0.200
    28.253    26.645     0.200
    28.315    28.220     0.200
    28.843    25.162     0.200
    29.067    24.540     0.200
    29.480    25.441     0.200
    29.480    26.812     0.200
    29.887    24.753     0.200
    23.746    36.190     0.200
    23.743    36.414     0.200
    15.128    46.293     0.200
    15.128    45.350     0.200
    17.605    42.415     0.200
    17.730    41.905     0.200
    17.730    43.014     0.200
    18.549    40.105     0.200
    18.693    37.120     0.200
    18.693    36.557     0.200
    18.693    38.217     0.200
    20.028    40.135     0.200
    20.042    41.173     0.200
    20.069    40.935     0.200
    22.475    41.276     0.200
    23.083    36.984     0.200
    23.083    36.785     0.200
    23.083    38.874     0.200
    23.083    38.066     0.200
    23.096    36.838     0.200
    23.081    41.109     0.200
    23.643    38.183     0.200
    23.643    40.015     0.200
    23.643    36.155     0.200
    23.643    37.554     0.200
    23.675    37.323     0.200
    23.675    35.483     0.200
    23.675    38.542     0.200
    23.757    37.220     0.200
    23.757    36.021     0.200
    23.757    37.892     0.200
    23.757    36.958     0.200
    23.770    37.312     0.200
    23.768    36.295     0.200
    23.921    34.534     0.200
    23.921    36.792     0.200
    23.921    35.604     0.200
    24.123    36.193     0.200
    24.164    34.871     0.200
    24.823    33.775     0.200
    24.738    34.378     0.200
    24.823    32.314     0.200
    24.823    33.885     0.200
    25.175    33.170     0.200
    26.349    30.274     0.200
    27.148    28.875     0.200
    27.177    26.622     0.200
    27.177    28.212     0.200
    27.489    25.275     0.200
    15.143    43.472     0.200
    18.550    38.872     0.200
    23.091    40.088     0.200
    23.664    38.146     0.200
    23.749    35.859     0.200
    23.749    37.257     0.200
    23.749    37.757     0.200
    23.759    37.068     0.200
    24.822    33.839     0.200
    27.135    28.477     0.200
    23.637    38.861     0.200
    23.718    38.394     0.200
    23.732    37.772     0.200
    15.950    47.137     0.200
    16.222    44.170     0.200
    17.579    46.629     0.200
    19.742    40.951     0.200
    19.934    41.445     0.200
    22.021    45.295     0.200
    22.433    40.501     0.200
    22.723    41.301     0.200
    23.042    39.578     0.200
    23.117    39.006     0.200
    23.117    38.406     0.200
    23.117    39.583     0.200
    23.117    40.356     0.200
    23.647    36.199     0.200
    23.647    35.420     0.200
    23.647    36.039     0.200
    23.723    37.527     0.200
    23.723    36.926     0.200
    23.723    37.626     0.200
    23.723    37.496     0.200
    23.734    36.902     0.200
    23.742    37.461     0.200
    23.888    36.307     0.200
    23.888    37.297     0.200
    23.888    36.507     0.200
    24.235    37.955     0.200
    24.866    34.591     0.200
    27.127    29.076     0.200
    27.155    27.676     0.200
    27.181    29.272     0.200
    23.743    36.805     0.200
    18.681    39.495     0.200
    23.633    36.899     0.200
    23.713    36.370     0.200
    23.713    36.722     0.200
    23.713    37.269     0.200
    23.638    39.243     0.200
    23.716    38.155     0.200
    23.733    38.158     0.200
    15.156    41.791     0.200
    18.673    39.346     0.200
    18.812    40.066     0.200
    23.139    39.135     0.200
    23.139    39.328     0.200
    23.621    36.173     0.200
    23.621    38.481     0.200
    23.701    35.243     0.200
    23.701    37.092     0.200
    23.701    36.832     0.200
    23.716    37.798     0.200
    23.866    36.065     0.200
    24.152    38.761     0.200
    24.152    37.966     0.200
    27.098    28.957     0.200
    27.126    26.221     0.200
    27.126    26.971     0.200
    18.562    39.722     0.200
    20.289    38.142     0.200
    21.084    41.303     0.200
    23.975    33.461     0.200
    24.071    34.471     0.200
    24.129    35.564     0.200
    24.129    35.614     0.200
    24.129    36.267     0.200
    27.402    25.171     0.200
    23.925    35.092     0.200
    27.207    26.842     0.200
    18.881    41.870     0.200
    23.070    40.790     0.200
    23.785    37.802     0.200
    23.771    36.528     0.200
    27.165    28.053     0.200
    23.095    38.931     0.200
    23.745    38.048     0.200
    23.755    37.428     0.200
    18.683    36.996     0.200
    23.735    36.921     0.200
    23.748    36.638     0.200
    27.127    27.826     0.200
    18.816    40.793     0.200
    23.713    36.528     0.200
    23.717    38.006     0.200
    15.561    43.089     0.200
    15.995    43.255     0.200
    17.750    41.083     0.200
    18.483    40.004     0.200
    18.625    41.748     0.200
    18.625    41.912     0.200
    18.625    42.072     0.200
    19.140    41.454     0.200
    20.284    40.931     0.200
    20.521    40.100     0.200
    20.521    42.261     0.200
    20.521    41.902     0.200
    20.758    42.569     0.200
    21.829    42.185     0.200
    22.416    42.820     0.200
    22.722    41.951     0.200
    22.724    40.469     0.200
    23.220    37.343     0.200
    23.220    37.833     0.200
    23.220    37.107     0.200
    23.232    37.299     0.200
    23.459    37.649     0.200
    23.459    38.060     0.200
    23.403    39.911     0.200
    23.554    36.961     0.200
    23.777    37.748     0.200
    23.625    37.721     0.200
    23.625    37.371     0.200
    23.786    38.124     0.200
    23.786    36.645     0.200
    24.660    34.137     0.200
    24.660    32.527     0.200
    24.554    35.447     0.200
    25.521    33.192     0.200
    26.247    33.621     0.200
    26.864    27.641     0.200
    26.892    28.490     0.200
    26.861    31.203     0.200
    27.105    30.085     0.200
    27.509    27.655     0.200
    27.719    29.054     0.200
    27.752    29.006     0.200
    28.806    26.159     0.200
    28.789    26.566     0.200
    29.382    21.333     0.200
    29.164    25.151     0.200
    16.700    42.902     0.200
    18.496    38.744     0.200
    18.496    39.144     0.200
    18.613    41.999     0.200
    18.613    41.874     0.200
    18.613    42.544     0.200
    20.293    40.015     0.200
    20.291    40.098     0.200
    20.745    42.295     0.200
    22.150    39.339     0.200
    22.709    41.383     0.200
    23.233    35.780     0.200
    23.233    37.030     0.200
    23.392    41.005     0.200
    23.447    39.137     0.200
    23.447    38.467     0.200
    23.543    39.535     0.200
    23.612    37.643     0.200
    23.612    39.551     0.200
    23.612    37.654     0.200
    23.789    39.375     0.200
    24.557    35.469     0.200
    24.673    33.359     0.200
    26.854    31.359     0.200
    23.540    38.498     0.200
    23.609    38.583     0.200
    26.851    29.523     0.200
    23.704    39.153     0.200
    15.169    41.875     0.200
    23.626    36.760     0.200
    18.553    39.563     0.200
    18.807    39.575     0.200
    18.807    42.596     0.200
    23.621    38.224     0.200
    23.716    37.063     0.200
    23.717    36.604     0.200
    23.717    37.381     0.200
    24.810    32.845     0.200
    27.112    26.075     0.200
    15.574    39.344     0.200
    16.611    39.746     0.200
    17.811    39.280     0.200
    18.019    40.319     0.200
    18.396    42.215     0.200
    18.415    39.595     0.200
    18.545    40.206     0.200
    18.545    39.882     0.200
    18.574    39.139     0.200
    18.574    40.889     0.200
    18.574    37.416     0.200
    19.128    39.273     0.200
    19.368    42.578     0.200
    20.317    41.126     0.200
    20.477    40.931     0.200
    20.515    40.693     0.200
    20.515    39.264     0.200
    20.515    37.451     0.200
    21.420    37.415     0.200
    21.770    38.666     0.200
    22.376    40.072     0.200
    22.507    38.940     0.200
    22.661    36.947     0.200
    22.661    38.947     0.200
    22.670    38.663     0.200
    23.278    35.500     0.200
    23.278    37.098     0.200
    23.278    36.070     0.200
    23.406    36.138     0.200
    23.406    35.040     0.200
    23.406    35.849     0.200
    23.356    37.031     0.200
    23.502    36.007     0.200
    23.566    35.276     0.200
    23.566    35.526     0.200
    23.566    35.128     0.200
    23.728    34.670     0.200
    23.728    33.568     0.200
    23.834    36.350     0.200
    23.834    35.612     0.200
    23.834    35.350     0.200
    24.720    31.717     0.200
    24.569    34.132     0.200
    24.701    32.589     0.200
    24.720    32.549     0.200
    24.651    34.924     0.200
    25.358    33.642     0.200
    25.460    30.975     0.200
    25.726    29.880     0.200
    26.210    30.228     0.200
    26.818    27.527     0.200
    26.803    27.606     0.200
    26.795    28.488     0.200
    26.795    28.077     0.200
    26.962    27.211     0.200
    27.449    23.863     0.200
    27.660    25.208     0.200
    27.693    25.426     0.200
    28.084    24.257     0.200
    28.670    24.579     0.200
    28.748    22.109     0.200
    29.166    20.929     0.200
    29.379    20.561     0.200
    22.670    36.858     0.200
    14.444    39.618     0.200
    15.452    41.157     0.200
    17.686    41.140     0.200
    19.676    41.672     0.200
    19.912    39.563     0.200
    22.039    38.770     0.200
    22.039    38.332     0.200
    24.113    36.184     0.200
    24.094    35.312     0.200
    24.728    33.913     0.200
    24.803    35.530     0.200
    24.803    34.530     0.200
    24.803    32.131     0.200
    24.803    35.830     0.200
    24.823    32.778     0.200
    18.513    41.996     0.200
    18.513    41.246     0.200
    18.221    42.451     0.200
    18.633    41.224     0.200
    18.625    38.081     0.200
    18.621    42.563     0.200
    18.621    42.315     0.200
    18.810    43.427     0.200
    18.810    41.996     0.200
    20.096    42.270     0.200
    20.096    43.302     0.200
    23.351    36.024     0.200
    23.351    37.492     0.200
    23.423    37.291     0.200
    23.423    38.621     0.200
    23.490    38.177     0.200
    23.490    38.007     0.200
    23.518    37.386     0.200
    25.062    32.363     0.200
    26.918    29.853     0.200
    26.947    30.961     0.200
    18.233    42.058     0.200
    18.633    39.362     0.200
    18.646    41.138     0.200
    18.646    42.298     0.200
    18.646    41.983     0.200
    18.784    40.427     0.200
    18.784    42.013     0.200
    19.227    43.449     0.200
    20.089    40.713     0.200
    20.091    41.929     0.200
    20.091    39.826     0.200
    20.091    40.005     0.200
    23.324    37.967     0.200
    23.324    38.498     0.200
    23.324    37.652     0.200
    23.449    38.789     0.200
    23.449    38.348     0.200
    23.449    37.709     0.200
    23.517    38.219     0.200
    23.517    37.477     0.200
    23.543    37.243     0.200
    23.884    35.982     0.200
    24.225    37.721     0.200
    25.039    35.032     0.200
    26.942    28.746     0.200
    26.971    29.981     0.200
    26.971    28.811     0.200
    20.085    40.942     0.200
    18.806    42.810     0.200
    23.510    38.434     0.200
    23.543    37.927     0.200
    26.949    30.432     0.200
    16.935    40.115     0.200
    19.796    41.535     0.200
    19.796    39.160     0.200
    20.282    41.156     0.200
    20.914    37.302     0.200
    23.116    36.609     0.200
    24.425    34.307     0.200
    24.427    32.696     0.200
    24.683    33.903     0.200
    25.011    32.573     0.200
    25.011    32.099     0.200
    25.168    32.777     0.200
    25.168    32.138     0.200
    27.896    24.907     0.200
    27.922    24.499     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.425    11.526     0.200
     8.512    23.690     0.200
     8.709    26.184     0.200
    10.324    30.340     0.200
    10.324    29.942     0.200
    10.731    31.484     0.200
    16.285    39.774     0.200
    19.288    41.132     0.200
    20.241    44.314     0.200
     2.190    12.859     0.200
     2.641    12.402     0.200
     8.954    29.323     0.200
    10.554    33.252     0.200
    16.293    40.285     0.200
    18.440    43.225     0.200
     2.534    12.359     0.200
     3.692    15.838     0.200
     4.634    17.548     0.200
     5.017    19.775     0.200
     4.966    16.969     0.200
     7.529    23.461     0.200
     8.877    25.332     0.200
     8.877    26.133     0.200
    10.487    30.546     0.200
    10.487    29.648     0.200
    13.465    33.990     0.200
    14.692    36.475     0.200
    14.692    36.576     0.200
    16.329    38.862     0.200
    17.670    35.722     0.200
    17.670    36.222     0.200
    19.447    40.982     0.200
    20.124    42.083     0.200
     2.550    12.315     0.200
     2.321    12.089     0.200
     4.742    17.643     0.200
     5.112    15.620     0.200
    10.628    31.358     0.200
    14.809    37.466     0.200
    19.527    41.400     0.200
     2.287    11.935     0.200
     2.566    12.278     0.200
     3.781    15.999     0.200
     5.119    19.989     0.200
     5.948    19.809     0.200
     2.088    11.816     0.200
     2.129    12.437     0.200
     2.395    12.736     0.200
     2.444    12.653     0.200
     3.459    15.308     0.200
     4.401    18.826     0.200
     4.870    17.049     0.200
     5.635    15.918     0.200
     7.293    21.771     0.200
     2.345    12.296     0.200
     2.236    14.072     0.200
     2.574    14.130     0.200
     2.613    14.368     0.200
     2.680    12.991     0.200
     2.820    14.656     0.200
     2.879    15.567     0.200
     3.160    14.291     0.200
     3.945    16.828     0.200
     3.945    18.230     0.200
     5.019    20.392     0.200
     5.177    18.152     0.200
     5.279    21.859     0.200
     5.461    19.739     0.200
     6.112    20.335     0.200
     7.579    22.720     0.200
     7.792    24.236     0.200
     8.142    23.055     0.200
    10.276    31.446     0.200
    10.748    31.744     0.200
    10.748    32.244     0.200
    11.164    33.887     0.200
    11.367    32.514     0.200
    18.577    43.378     0.200
    18.577    43.679     0.200
     2.197    12.327     0.200
     2.701    13.545     0.200
     2.869    15.586     0.200
     3.131    14.224     0.200
     5.432    19.076     0.200
     2.179    11.037     0.200
     2.249    13.021     0.200
     2.600    13.526     0.200
     3.028    14.821     0.200
     3.971    16.920     0.200
     4.512    16.412     0.200
     4.547    17.901     0.200
     6.945    20.617     0.200
     1.972    11.989     0.200
     2.233    11.345     0.200
     2.482    12.230     0.200
     2.748    13.830     0.200
     3.325    14.804     0.200
     3.558    15.675     0.200
     4.834    18.695     0.200
     5.049    18.875     0.200
     1.953    10.697     0.200
     2.633    10.967     0.200
     3.073    12.734     0.200
     4.491    15.580     0.200
     5.400    18.682     0.200
     6.222    18.981     0.200
     9.873    27.382     0.200
     9.873    27.585     0.200
    11.558    31.713     0.200
    11.844    31.375     0.200
    14.260    33.679     0.200
    15.483    35.910     0.200
    16.668    36.076     0.200
    16.668    36.373     0.200
    18.623    40.265     0.200
    19.938    38.918     0.200
    19.938    39.519     0.200
    20.175    40.155     0.200
    20.597    40.225     0.200
    20.597    40.522     0.200
    20.802    37.832     0.200
     1.130     9.363     0.200
     1.137     9.280     0.200
     1.929    10.740     0.200
     2.379    13.383     0.200
     2.676    13.122     0.200
     3.113    14.022     0.200
     3.647    15.487     0.200
     4.169    16.594     0.200
     4.557    17.764     0.200
     5.473    19.678     0.200
     1.993     9.912     0.200
     1.993    10.912     0.200
     2.027    10.519     0.200
     2.465    10.906     0.200
     2.465    11.609     0.200
     2.492    12.591     0.200
     2.708    13.270     0.200
     3.522    15.073     0.200
     3.806    16.150     0.200
     3.862    14.597     0.200
     3.862    15.198     0.200
     3.862    15.495     0.200
     4.246    16.117     0.200
     4.798    17.679     0.200
     5.313    17.669     0.200
     5.313    17.872     0.200
     5.474    18.893     0.200
     5.561    19.272     0.200
     6.051    19.855     0.200
     6.675    21.168     0.200
     7.087    20.759     0.200
     7.728    21.593     0.200
     7.786    23.814     0.200
     8.045    19.991     0.200
     8.064    26.568     0.200
     9.126    27.379     0.200
     9.126    27.176     0.200
     9.768    28.182     0.200
    10.252    28.029     0.200
    10.706    26.439     0.200
    10.762    30.081     0.200
    10.762    30.285     0.200
    11.134    30.744     0.200
    11.312    30.166     0.200
    12.147    28.520     0.200
    13.438    30.349     0.200
    13.705    34.128     0.200
    14.183    31.653     0.200
    14.089    38.046     0.200
    14.624    32.413     0.200
    15.275    33.615     0.200
    15.267    37.504     0.200
    15.401    33.945     0.200
    16.365    35.592     0.200
    16.356    39.793     0.200
    19.304    42.692     0.200
    19.950    40.853     0.200
    19.950    41.751     0.200
    20.451    40.905     0.200
     1.245     9.590     0.200
     2.447    12.164     0.200
     2.493    12.932     0.200
     3.831    15.611     0.200
     4.214    16.750     0.200
     5.441    18.823     0.200
     2.451    12.853     0.200
     2.492    12.874     0.200
     2.684    14.348     0.200
     3.839    16.160     0.200
     4.222    16.897     0.200
     4.775    16.647     0.200
     5.449    19.173     0.200
     2.453    12.792     0.200
     2.490    12.859     0.200
     3.840    15.814     0.200
     4.776    18.893     0.200
     1.285    10.482     0.200
     2.466    11.202     0.200
     2.499    12.222     0.200
     5.328    18.709     0.200
     2.015    10.856     0.200
     2.456    11.614     0.200
     2.486    12.261     0.200
     2.572    12.949     0.200
     2.681    13.780     0.200
     3.838    14.676     0.200
     4.219    16.428     0.200
     4.774    18.254     0.200
     5.286    20.480     0.200
     5.446    19.216     0.200
     6.648    22.282     0.200
     7.701    23.097     0.200
     7.758    24.732     0.200
     1.270     9.390     0.200
     2.002    10.849     0.200
     2.448    12.536     0.200
     2.513    12.386     0.200
     4.246    16.158     0.200
     2.453    12.659     0.200
     2.494    12.880     0.200
     2.690    12.601     0.200
     3.844    15.126     0.200
     4.228    16.350     0.200
     5.456    18.322     0.200
     2.448    12.106     0.200
     2.494    12.268     0.200
     2.679    13.108     0.200
     3.835    15.423     0.200
     4.217    15.954     0.200
     5.445    18.431     0.200
     1.997    12.917     0.200
     2.468    12.016     0.200
     2.700    13.906     0.200
     2.002    11.699     0.200
     2.461    11.543     0.200
     2.488    12.331     0.200
     2.696    12.708     0.200
     4.234    16.856     0.200
     1.209    10.321     0.200
     1.811    11.487     0.200
     2.207    11.067     0.200
     3.036    14.690     0.200
     3.334    15.521     0.200
     3.979    16.487     0.200
     4.489    18.735     0.200
     4.540    17.539     0.200
     1.989    11.304     0.200
     2.461    10.796     0.200
     2.461    11.194     0.200
     2.461    10.995     0.200
     2.504    12.495     0.200
     2.719    13.789     0.200
     3.528    15.346     0.200
     3.869    15.361     0.200
     3.869    15.861     0.200
     4.256    16.945     0.200
     4.804    17.448     0.200
     4.804    18.147     0.200
     4.804    17.948     0.200
     5.329    17.328     0.200
     5.329    17.930     0.200
     5.486    19.396     0.200
     5.562    19.204     0.200
     6.053    20.372     0.200
     6.686    21.194     0.200
     7.744    23.148     0.200
     7.796    23.532     0.200
     7.796    23.430     0.200
     8.030    20.001     0.200
     8.076    24.274     0.200
     9.136    25.399     0.200
     9.136    25.298     0.200
     9.778    27.401     0.200
    10.262    27.758     0.200
    10.773    29.789     0.200
    11.143    31.477     0.200
    11.143    29.977     0.200
    11.320    30.415     0.200
    14.099    35.776     0.200
    15.281    38.385     0.200
    16.373    40.445     0.200
    16.893    41.376     0.200
    19.320    43.048     0.200
    20.467    41.466     0.200
    20.526    40.976     0.200
    20.526    41.676     0.200
     2.463    10.675     0.200
     2.499    12.254     0.200
     2.715    12.731     0.200
     3.867    16.087     0.200
     4.253    16.385     0.200
     4.803    15.974     0.200
     5.482    19.048     0.200
     7.738    22.118     0.200
     2.032    10.409     0.200
     2.422     9.756     0.200
     2.560    13.255     0.200
     2.526    11.848     0.200
     3.827    15.464     0.200
     4.762    18.054     0.200
     5.309    17.170     0.200
     5.309    20.069     0.200
     5.450    18.927     0.200
     5.604    19.329     0.200
     6.647    21.355     0.200
     2.040    10.978     0.200
     2.418    10.770     0.200
     2.524    11.932     0.200
     2.670    12.333     0.200
     3.818    14.642     0.200
     4.207    16.097     0.200
     4.753    17.730     0.200
     5.439    18.518     0.200
     1.272    10.412     0.200
     3.857    16.740     0.200
     4.235    17.328     0.200
     2.738    14.209     0.200
     3.900    16.641     0.200
     4.277    17.646     0.200
     4.836    18.012     0.200
     5.499    19.483     0.200
     2.512    12.192     0.200
     2.505    13.072     0.200
     2.688    13.639     0.200
     2.810    13.715     0.200
     3.956    16.339     0.200
     4.348    17.472     0.200
     4.891    18.436     0.200
     5.407    18.811     0.200
     5.577    19.823     0.200
     6.777    22.223     0.200
     7.819    24.061     0.200
     7.888    24.157     0.200
    10.865    33.715     0.200
    11.234    34.211     0.200
    11.409    32.268     0.200
     1.259    10.662     0.200
     2.442    12.253     0.200
     1.337    10.933     0.200
     2.161    12.319     0.200
     2.638    13.353     0.200
     2.699    11.740     0.200
     3.878    16.085     0.200
     5.355    18.744     0.200
     2.507    11.754     0.200
     2.649    13.300     0.200
     2.759    13.808     0.200
     3.915    15.722     0.200
     5.346    20.716     0.200
     5.515    22.356     0.200
     7.759    24.064     0.200
     2.157    11.274     0.200
     2.157    13.473     0.200
     2.633    14.114     0.200
     3.273    15.552     0.200
     3.911    18.801     0.200
     4.470    20.077     0.200
     6.904    20.672     0.200
     2.247    11.686     0.200
     2.300    12.264     0.200
     2.341    11.290     0.200
     2.449    12.024     0.200
     3.500    15.065     0.200
     3.841    15.781     0.200
     4.919    16.303     0.200
     7.341    21.034     0.200
     1.468    10.851     0.200
     1.722    10.886     0.200
     2.551    12.214     0.200
     2.866    12.140     0.200
     3.011    13.738     0.200
     3.953    17.853     0.200
     5.933    18.647     0.200
     6.023    19.598     0.200
     8.347    25.477     0.200
    11.305    33.352     0.200
    11.618    31.701     0.200
    17.956    39.740     0.200
    19.259    42.024     0.200
     2.233    12.478     0.200
     2.665    12.737     0.200
     2.692    14.119     0.200
     3.911    16.495     0.200
     2.252    13.412     0.200
     2.528    14.481     0.200
     3.409    17.408     0.200
     2.218    13.099     0.200
     2.464    11.433     0.200
     2.341    12.660     0.200
     2.403    12.337     0.200
     3.621    15.933     0.200
     3.945    16.551     0.200
     4.209    16.571     0.200
     4.562    17.541     0.200
     4.945    17.874     0.200
     5.144    18.748     0.200
     7.362    22.075     0.200
     7.470    22.810     0.200
    18.327    39.401     0.200
    18.814    42.928     0.200
     2.210    12.631     0.200
     2.439    13.049     0.200
     3.459    15.147     0.200
     3.792    15.466     0.200
     4.400    18.065     0.200
     4.865    18.045     0.200
     5.002    17.642     0.200
     6.218    19.947     0.200
     2.194    11.820     0.200
     2.304    10.543     0.200
     2.467    11.832     0.200
     3.402    14.725     0.200
     3.735    15.132     0.200
     4.092    16.773     0.200
     4.343    16.037     0.200
     4.829    15.577     0.200
     4.948    17.984     0.200
     6.162    20.414     0.200
     7.253    20.978     0.200
     2.124    12.339     0.200
     2.333    11.404     0.200
     2.430    13.071     0.200
     3.365    15.759     0.200
     3.680    15.882     0.200
     2.351    11.070     0.200
     2.409    12.997     0.200
     2.297    12.463     0.200
     2.368    12.236     0.200
     2.353    12.708     0.200
     3.222    15.172     0.200
     3.551    15.328     0.200
     4.116    18.135     0.200
     4.492    17.354     0.200
     4.959    17.795     0.200
     5.107    18.471     0.200
     6.321    20.902     0.200
     7.380    22.945     0.200
    10.674    33.406     0.200
    10.786    32.001     0.200
    10.786    31.402     0.200
    11.217    31.073     0.200
    18.732    41.664     0.200
    19.287    40.691     0.200
    20.005    42.309     0.200
    20.213    44.685     0.200
    20.614    43.704     0.200
     1.415    10.400     0.200
     2.155    11.864     0.200
     2.730    13.255     0.200
     2.717    12.413     0.200
     2.745    11.785     0.200
     3.964    15.750     0.200
     4.271    16.174     0.200
     4.425    16.179     0.200
     4.906    17.761     0.200
     5.126    16.892     0.200
     5.449    18.731     0.200
     6.692    20.924     0.200
     7.524    24.309     0.200
     7.785    23.166     0.200
     8.184    21.514     0.200
    10.274    29.916     0.200
    10.734    29.755     0.200
    10.909    31.805     0.200
    10.834    30.278     0.200
    11.164    30.932     0.200
    11.375    30.264     0.200
    20.423    40.875     0.200
     1.675    11.765     0.200
     4.257    17.332     0.200
     2.210    12.170     0.200
     2.652    12.419     0.200
     2.621    13.082     0.200
     3.850    16.128     0.200
     4.162    16.801     0.200
     4.792    18.241     0.200
     5.062    18.592     0.200
     5.346    17.981     0.200
     6.584    22.629     0.200
     1.685    11.245     0.200
     2.304    12.718     0.200
     2.842    13.540     0.200
     2.842    13.438     0.200
     3.081    14.648     0.200
     4.267    17.406     0.200
     4.267    17.203     0.200
     4.622    17.763     0.200
     5.205    19.966     0.200
     5.205    19.864     0.200
     5.164    19.336     0.200
     5.667    20.676     0.200
     5.823    19.657     0.200
     7.049    21.849     0.200
     2.225     8.614     0.200
     2.629    12.602     0.200
     2.564    14.316     0.200
     3.570    16.674     0.200
     3.953    17.115     0.200
     5.187    19.707     0.200
     5.802    20.432     0.200
     2.597    12.958     0.200
     2.825    12.798     0.200
     3.252    14.314     0.200
     4.777    17.921     0.200
     1.497    10.377     0.200
     2.183    12.369     0.200
     2.183    11.768     0.200
     2.728    12.308     0.200
     2.778    13.023     0.200
     2.838    13.327     0.200
     4.059    16.674     0.200
     4.059    16.373     0.200
     4.379    17.243     0.200
     5.000    18.495     0.200
     7.897    24.693     0.200
     2.226    12.626     0.200
     2.380    12.524     0.200
     2.380    12.123     0.200
     2.380    13.024     0.200
     2.858    13.547     0.200
     3.254    13.533     0.200
     3.472    15.979     0.200
     3.639    15.640     0.200
     4.471    17.923     0.200
     4.756    17.005     0.200
     4.813    18.530     0.200
     4.813    18.428     0.200
     5.180    18.754     0.200
     5.295    17.807     0.200
     5.748    20.420     0.200
     5.977    19.649     0.200
     6.375    20.906     0.200
     7.311    20.483     0.200
     7.542    20.721     0.200
     7.606    22.944     0.200
     8.344    24.324     0.200
     8.706    25.705     0.200
    10.483    27.868     0.200
    10.690    31.156     0.200
    11.186    30.358     0.200
    11.661    32.719     0.200
    12.072    34.425     0.200
    12.260    33.022     0.200
    16.538    37.909     0.200
    16.948    40.183     0.200
    20.120    42.007     0.200
    20.427    40.322     0.200
    20.663    40.762     0.200
     2.663    12.800     0.200
     2.895    13.295     0.200
     3.444    12.489     0.200
     4.143    16.332     0.200
     2.102    11.527     0.200
     2.057    11.657     0.200
     2.661    12.999     0.200
     3.223    14.542     0.200
     3.593    14.927     0.200
     2.171    12.476     0.200
     2.426    14.105     0.200
     2.567    14.357     0.200
     2.568    14.455     0.200
     2.526    14.639     0.200
     2.859    14.455     0.200
     3.406    14.375     0.200
     3.662    14.687     0.200
     4.343    17.835     0.200
     5.144    18.283     0.200
     5.459    19.611     0.200
     6.084    22.120     0.200
     1.212    11.429     0.200
     2.153    12.844     0.200
     2.627    14.414     0.200
     2.627    14.214     0.200
     3.002    14.741     0.200
     3.002    14.541     0.200
     3.313    15.606     0.200
     3.945    17.839     0.200
     3.945    17.239     0.200
     4.529    17.918     0.200
     4.510    17.936     0.200
     4.510    16.536     0.200
     4.685    19.702     0.200
     5.740    21.090     0.200
     6.844    24.898     0.200
     6.844    24.598     0.200
     6.944    23.636     0.200
    10.407    31.118     0.200
     0.901     7.952     0.200
     2.058    10.949     0.200
     2.102    11.230     0.200
     2.661    12.314     0.200
     3.225    13.733     0.200
     3.225    13.835     0.200
     3.595    14.415     0.200
     4.164    14.976     0.200
     4.833    16.759     0.200
     6.024    18.768     0.200
     2.522    11.730     0.200
     2.749    11.081     0.200
     3.169    13.983     0.200
     4.706    16.642     0.200
     5.250    15.604     0.200
     1.004     9.455     0.200
     2.504    12.852     0.200
     3.542    15.045     0.200
     1.964    12.387     0.200
     2.990    15.019     0.200
     3.028    13.666     0.200
     1.561    11.904     0.200
     1.561    12.904     0.200
     2.346    13.541     0.200
     2.915    14.011     0.200
     3.527    15.759     0.200
     3.677    15.212     0.200
     4.025    19.148     0.200
     4.388    17.607     0.200
     4.533    17.922     0.200
     4.839    18.945     0.200
     4.853    18.589     0.200
     5.046    19.336     0.200
     5.414    20.135     0.200
     5.782    22.139     0.200
     5.782    20.639     0.200
     6.127    21.026     0.200
     6.725    19.567     0.200
     7.434    23.774     0.200
     7.725    23.876     0.200
     7.754    22.725     0.200
     7.919    25.411     0.200
     7.919    26.669     0.200
     8.079    26.242     0.200
     8.492    25.824     0.200
     8.628    26.532     0.200
     8.761    26.374     0.200
     8.956    26.100     0.200
     9.741    31.046     0.200
     9.915    28.413     0.200
    11.376    34.658     0.200
    12.178    33.905     0.200
    16.196    38.213     0.200
    16.196    38.455     0.200
     2.259    13.533     0.200
     2.406    13.313     0.200
     2.538    11.775     0.200
     2.538    12.072     0.200
     3.645    15.959     0.200
     3.645    14.655     0.200
     3.947    16.525     0.200
     4.587    18.557     0.200
     4.891    18.414     0.200
     6.369    21.965     0.200
     7.304    23.055     0.200
     7.304    22.055     0.200
     7.464    24.281     0.200
     2.335    12.762     0.200
     2.792    14.230     0.200
     2.878    12.717     0.200
     3.041    14.519     0.200
     3.729    15.588     0.200
     3.883    17.594     0.200
     4.221    15.444     0.200
     4.582    17.836     0.200
     5.158    19.611     0.200
     5.215    18.843     0.200
     5.717    19.489     0.200
     6.757    22.750     0.200
     7.663    21.581     0.200
     7.895    24.274     0.200
     2.313    13.329     0.200
     2.313    12.829     0.200
     2.806    14.271     0.200
     3.039    14.855     0.200
     3.442    16.146     0.200
     3.717    15.345     0.200
     4.146    17.934     0.200
     4.224    17.224     0.200
     4.224    16.724     0.200
     4.580    18.069     0.200
     4.580    17.968     0.200
     5.162    18.583     0.200
     5.162    18.183     0.200
     5.203    18.505     0.200
     5.703    19.870     0.200
     5.782    20.244     0.200
     6.761    22.120     0.200
     7.006    22.953     0.200
     7.880    24.462     0.200
     7.880    24.761     0.200
    15.697    35.538     0.200
     2.396    12.681     0.200
     2.396    12.380     0.200
     2.530    12.418     0.200
     3.345    13.799     0.200
     3.831    15.928     0.200
     4.695    17.443     0.200
     5.372    19.151     0.200
     5.372    18.651     0.200
     2.209    11.735     0.200
     2.209    12.135     0.200
     2.292    12.264     0.200
     2.592    13.365     0.200
     2.592    13.566     0.200
     3.451    14.942     0.200
     3.829    16.028     0.200
     4.389    18.200     0.200
     5.065    18.306     0.200
     7.080    22.685     0.200
     2.505    11.683     0.200
     2.499    12.849     0.200
     2.598    14.597     0.200
     2.789    13.557     0.200
     3.596    15.749     0.200
     3.733    15.953     0.200
     3.733    17.149     0.200
     3.938    15.754     0.200
     3.938    15.957     0.200
     4.327    17.111     0.200
     4.873    18.051     0.200
     4.873    18.652     0.200
     5.386    18.161     0.200
     5.556    19.476     0.200
     5.556    18.476     0.200
     6.756    21.966     0.200
     6.756    22.263     0.200
     7.798    22.601     0.200
     7.867    24.301     0.200
     2.489    13.368     0.200
     2.454    12.077     0.200
     2.454    11.777     0.200
     2.499    12.858     0.200
     2.684    13.298     0.200
     3.500    14.974     0.200
     3.840    15.804     0.200
     3.840    16.004     0.200
     3.828    15.846     0.200
     3.828    16.448     0.200
     4.092    16.170     0.200
     4.222    16.744     0.200
     4.776    17.883     0.200
     5.291    17.877     0.200
     5.449    18.924     0.200
     6.064    20.359     0.200
     6.651    21.199     0.200
     7.459    20.541     0.200
     7.462    22.744     0.200
     7.486    23.956     0.200
     7.706    21.791     0.200
     7.761    23.842     0.200
     8.069    23.857     0.200
     8.069    21.299     0.200
     8.173    23.535     0.200
    11.133    31.394     0.200
    11.292    30.135     0.200
    14.090    39.085     0.200
    14.090    35.936     0.200
    15.822    38.770     0.200
    17.484    38.279     0.200
    19.507    39.766     0.200
    19.962    41.669     0.200
    20.318    41.643     0.200
    20.961    40.700     0.200
     2.445    12.277     0.200
     2.445    11.277     0.200
     2.502    12.218     0.200
     2.505    12.780     0.200
     2.691    13.011     0.200
     3.502    15.749     0.200
     3.826    15.556     0.200
     3.843    15.468     0.200
     3.843    15.366     0.200
     4.097    15.496     0.200
     4.229    16.362     0.200
     4.778    17.053     0.200
     4.778    18.154     0.200
     5.306    17.695     0.200
     5.458    18.317     0.200
     6.658    21.014     0.200
     2.452    12.275     0.200
     2.499    12.622     0.200
     2.499    12.724     0.200
     2.507    12.432     0.200
     2.695    13.038     0.200
     3.821    16.604     0.200
     3.848    15.879     0.200
     3.848    15.481     0.200
     4.091    16.153     0.200
     4.233    16.489     0.200
     4.784    18.666     0.200
     6.662    21.840     0.200
     1.159    10.548     0.200
     2.384    12.954     0.200
     2.473    12.616     0.200
     2.535    12.888     0.200
     3.729    15.855     0.200
     4.076    16.504     0.200
     5.286    18.886     0.200
     6.503    21.083     0.200
     2.462    13.046     0.200
     2.481    13.127     0.200
     2.687    13.325     0.200
     3.845    15.909     0.200
     4.225    16.671     0.200
     5.451    19.064     0.200
     6.654    21.726     0.200
     2.063    12.072     0.200
     2.449    11.866     0.200
     2.449    11.266     0.200
     2.481    12.098     0.200
     2.661    13.493     0.200
     3.821    15.859     0.200
     3.821    15.559     0.200
     3.871    15.670     0.200
     4.200    16.437     0.200
     5.586    19.466     0.200
     1.229    10.604     0.200
     2.482    13.483     0.200
     4.193    17.113     0.200
     2.444    12.940     0.200
     2.626    13.721     0.200
     4.166    16.853     0.200
     2.076    12.304     0.200
     2.445    12.494     0.200
     2.477    13.224     0.200
     2.477    13.424     0.200
     2.646    13.853     0.200
     3.807    16.396     0.200
     3.807    14.996     0.200
     3.860    18.079     0.200
     3.860    17.379     0.200
     4.110    16.767     0.200
     4.184    17.096     0.200
     4.744    18.867     0.200
     5.250    18.158     0.200
     5.250    20.758     0.200
     5.409    19.399     0.200
     5.409    19.500     0.200
     5.593    17.653     0.200
     6.078    20.701     0.200
     7.421    23.423     0.200
     7.666    22.468     0.200
     7.722    24.608     0.200
     7.722    24.207     0.200
     8.133    24.920     0.200
     2.450    12.292     0.200
     2.450    11.491     0.200
     2.525    12.319     0.200
     2.517    12.417     0.200
     2.517    12.519     0.200
     2.718    13.267     0.200
     3.865    15.377     0.200
     3.865    14.979     0.200
     3.805    16.379     0.200
     3.805    16.980     0.200
     3.992    15.592     0.200
     4.087    16.093     0.200
     4.087    16.292     0.200
     4.255    16.127     0.200
     4.800    17.570     0.200
     4.800    17.969     0.200
     5.335    19.419     0.200
     5.335    17.822     0.200
     7.751    21.936     0.200
     7.885    20.872     0.200
     8.026    20.620     0.200
     8.326    21.618     0.200
     2.044    11.592     0.200
     2.044    12.092     0.200
     2.452    12.428     0.200
     2.452    11.631     0.200
     2.495    13.033     0.200
     2.502    12.946     0.200
     2.689    13.665     0.200
     3.825    17.010     0.200
     3.825    16.408     0.200
     3.825    16.306     0.200
     3.844    15.895     0.200
     4.005    15.607     0.200
     4.092    16.193     0.200
     4.227    16.817     0.200
     4.227    16.715     0.200
     4.466    17.035     0.200
     4.779    19.070     0.200
     5.298    19.012     0.200
     5.455    19.183     0.200
     7.714    22.733     0.200
     7.920    22.720     0.200
     1.246    10.758     0.200
     2.484    13.123     0.200
     2.674    13.098     0.200
     3.832    15.582     0.200
     4.011    18.398     0.200
     2.447    11.179     0.200
     2.447    11.879     0.200
     2.499    12.475     0.200
     2.500    12.966     0.200
     2.687    13.184     0.200
     3.499    15.200     0.200
     3.499    15.301     0.200
     3.840    16.024     0.200
     3.840    15.824     0.200
     3.829    15.855     0.200
     3.829    14.155     0.200
     4.000    15.561     0.200
     4.225    16.336     0.200
     4.225    16.536     0.200
     4.097    16.028     0.200
     4.468    15.901     0.200
     4.776    18.007     0.200
     5.299    17.497     0.200
     5.453    18.799     0.200
     5.453    18.599     0.200
     5.581    16.205     0.200
     6.654    21.388     0.200
     7.466    22.613     0.200
     7.490    22.833     0.200
     7.470    19.961     0.200
     7.764    23.828     0.200
     7.715    22.009     0.200
     7.715    21.809     0.200
     7.992    24.566     0.200
     7.921    20.804     0.200
     8.062    20.652     0.200
     8.062    21.022     0.200
     9.042    25.916     0.200
     9.042    26.216     0.200
     9.104    26.594     0.200
     9.746    26.498     0.200
     9.746    25.938     0.200
     9.746    27.098     0.200
    10.230    28.149     0.200
    10.230    29.949     0.200
    10.741    30.189     0.200
    10.741    30.490     0.200
    11.027    29.047     0.200
    11.112    30.365     0.200
    11.289    30.292     0.200
    11.289    30.492     0.200
    11.141    27.520     0.200
    13.451    30.463     0.200
    14.100    35.888     0.200
    14.100    35.148     0.200
    14.642    36.468     0.200
    14.604    36.011     0.200
    15.417    34.117     0.200
    16.201    40.771     0.200
    16.351    40.026     0.200
    16.680    38.080     0.200
    17.482    38.115     0.200
    18.256    37.694     0.200
    18.966    42.301     0.200
    19.504    39.528     0.200
    20.448    40.415     0.200
     2.062    11.652     0.200
     2.444    11.798     0.200
     2.482    13.351     0.200
     2.491    12.743     0.200
     2.667    12.897     0.200
     3.484    15.163     0.200
     3.824    15.695     0.200
     3.845    16.653     0.200
     3.845    17.153     0.200
     4.002    16.107     0.200
     4.205    16.445     0.200
     4.205    16.343     0.200
     4.105    16.117     0.200
     4.105    15.715     0.200
     4.488    16.842     0.200
     4.760    18.675     0.200
     5.277    18.731     0.200
     5.432    18.623     0.200
     6.634    21.396     0.200
     6.634    21.497     0.200
     7.456    19.412     0.200
     7.693    22.541     0.200
     7.744    23.843     0.200
     7.943    20.828     0.200
     8.084    21.274     0.200
     8.084    20.614     0.200
     8.384    21.372     0.200
    11.005    33.884     0.200
    11.277    31.098     0.200
     2.451    11.840     0.200
     2.491    12.968     0.200
     2.488    12.609     0.200
     2.488    12.312     0.200
     2.676    13.018     0.200
     3.833    14.413     0.200
     4.008    15.170     0.200
     4.214    15.964     0.200
     5.581    19.821     0.200
     7.936    20.929     0.200
     2.167    12.771     0.200
     2.643    14.020     0.200
     3.881    16.769     0.200
     3.927    17.135     0.200
     4.184    17.136     0.200
     2.483    12.320     0.200
     2.444    11.468     0.200
     2.444    11.968     0.200
     2.491    12.822     0.200
     2.668    13.362     0.200
     3.824    16.064     0.200
     3.824    16.364     0.200
     3.844    16.833     0.200
     4.206    16.910     0.200
     4.104    16.297     0.200
     4.760    19.642     0.200
     5.278    17.303     0.200
     5.278    17.803     0.200
     5.433    18.688     0.200
     5.433    19.688     0.200
     5.588    17.777     0.200
     6.635    21.765     0.200
     7.128    22.308     0.200
     7.445    22.807     0.200
     7.455    20.887     0.200
     7.693    22.213     0.200
     7.745    23.910     0.200
     7.745    25.910     0.200
     7.942    20.806     0.200
     8.157    24.200     0.200
     9.022    26.401     0.200
     9.727    28.178     0.200
    11.006    30.855     0.200
    11.272    32.947     0.200
    11.277    30.075     0.200
     2.057    12.043     0.200
     2.439    11.673     0.200
     2.504    12.714     0.200
     2.504    12.214     0.200
     2.491    12.175     0.200
     2.679    12.873     0.200
     3.837    16.361     0.200
     3.832    15.423     0.200
     4.105    16.035     0.200
     4.217    16.126     0.200
     5.446    18.281     0.200
     6.646    21.778     0.200
     7.711    21.949     0.200
     7.926    21.446     0.200
     2.440    12.985     0.200
     2.495    12.843     0.200
     2.495    13.644     0.200
     2.664    12.866     0.200
     3.820    15.177     0.200
     3.875    16.631     0.200
     4.202    16.515     0.200
     1.411    11.205     0.200
     4.172    17.684     0.200
     1.286    10.706     0.200
     2.088    12.457     0.200
     2.088    12.657     0.200
     2.449    13.336     0.200
     2.449    13.636     0.200
     2.522    13.591     0.200
     3.789    15.800     0.200
     3.789    16.600     0.200
     4.059    17.048     0.200
     5.219    19.310     0.200
     6.474    21.661     0.200
     2.320    13.291     0.200
     2.320    12.694     0.200
     3.029    14.921     0.200
     4.570    17.834     0.200
     2.311    13.133     0.200
     2.311    12.934     0.200
     2.801    13.418     0.200
     2.801    13.219     0.200
     3.030    14.351     0.200
     3.451    14.830     0.200
     3.451    16.229     0.200
     3.451    15.830     0.200
     3.723    15.461     0.200
     3.723    15.961     0.200
     4.156    16.911     0.200
     4.215    17.111     0.200
     4.215    16.912     0.200
     4.571    17.564     0.200
     4.571    18.064     0.200
     5.772    20.342     0.200
     6.770    22.698     0.200
     6.997    23.449     0.200
     6.997    22.648     0.200
     7.831    21.912     0.200
     7.872    24.142     0.200
     7.872    23.642     0.200
     1.613    12.262     0.200
     1.708    12.061     0.200
     2.631    14.294     0.200
     2.951    14.952     0.200
     3.249    15.767     0.200
     4.460    18.440     0.200
     6.876    21.746     0.200
     2.326    13.654     0.200
     2.784    13.099     0.200
     3.021    14.438     0.200
     3.463    15.784     0.200
     3.739    15.564     0.200
     4.204    17.238     0.200
     4.562    17.750     0.200
     4.562    17.852     0.200
     5.141    18.799     0.200
     5.141    19.698     0.200
     5.225    16.521     0.200
     5.766    19.805     0.200
     6.989    22.635     0.200
     6.989    23.034     0.200
     7.874    23.903     0.200
     2.185    12.806     0.200
     2.185    12.505     0.200
     2.590    13.272     0.200
     2.929    15.321     0.200
     3.116    14.834     0.200
     4.771    17.225     0.200
     4.771    17.124     0.200
     5.178    19.974     0.200
     6.400    21.012     0.200
     8.472    26.728     0.200
     2.478    12.639     0.200
     2.781    13.017     0.200
     2.781    12.314     0.200
     3.505    16.463     0.200
     3.790    16.242     0.200
     3.904    16.200     0.200
     3.816    16.340     0.200
     3.816    16.238     0.200
     4.069    16.883     0.200
     4.759    18.335     0.200
     4.845    18.219     0.200
     5.403    16.711     0.200
     6.480    22.037     0.200
     7.243    22.143     0.200
     7.563    23.500     0.200
     7.563    23.398     0.200
     8.460    24.935     0.200
     9.547    26.851     0.200
     9.547    27.054     0.200
    10.064    28.619     0.200
    10.497    28.367     0.200
    10.636    28.646     0.200
    10.811    27.799     0.200
    10.920    30.254     0.200
    16.282    35.755     0.200
     2.019    12.513     0.200
     2.782    13.316     0.200
     3.786    16.101     0.200
     3.819    16.415     0.200
     3.819    15.110     0.200
     3.900    16.162     0.200
     4.073    16.749     0.200
     4.073    16.851     0.200
     4.762    18.411     0.200
     5.221    19.051     0.200
     5.400    17.260     0.200
     7.247    21.917     0.200
     7.568    23.763     0.200
     2.392    12.998     0.200
     3.560    15.069     0.200
     3.892    15.998     0.200
     3.892    16.197     0.200
     5.098    18.423     0.200
     7.349    21.856     0.200
     1.010     8.803     0.200
     2.219    11.899     0.200
     2.355    12.305     0.200
     2.402    11.858     0.200
     2.402    12.258     0.200
     2.396    11.726     0.200
     2.396    13.026     0.200
     3.563    15.407     0.200
     3.563    14.207     0.200
     3.897    15.917     0.200
     4.109    17.737     0.200
     7.356    21.449     0.200
     1.004     9.569     0.200
     2.209    13.001     0.200
     2.342    13.444     0.200
     2.404    13.318     0.200
     2.404    12.021     0.200
     2.390    13.388     0.200
     2.390    13.083     0.200
     3.554    15.607     0.200
     3.884    16.152     0.200
     2.347    12.969     0.200
     2.389    13.376     0.200
     3.558    15.235     0.200
     3.888    16.379     0.200
     5.094    18.516     0.200
     5.935    19.996     0.200
     6.314    21.070     0.200
     7.343    21.769     0.200
     1.048     9.899     0.200
     1.048    11.098     0.200
     2.204    12.705     0.200
     2.204    12.005     0.200
     2.527    13.831     0.200
     2.696    13.756     0.200
     3.635    16.801     0.200
     4.057    16.677     0.200
     4.566    18.835     0.200
     4.566    17.632     0.200
     5.312    19.936     0.200
     7.700    22.863     0.200
     2.217    12.239     0.200
     2.354    12.648     0.200
     2.396    12.959     0.200
     3.562    15.251     0.200
     3.895    15.864     0.200
     3.895    16.059     0.200
     4.503    17.770     0.200
     4.503    17.466     0.200
     4.935    18.128     0.200
     5.102    18.382     0.200
     5.731    19.834     0.200
     6.321    20.747     0.200
     6.321    20.848     0.200
     7.354    21.393     0.200
     7.354    21.495     0.200
     7.424    22.683     0.200
    10.985    29.622     0.200
     1.648    10.978     0.200
     2.309    12.763     0.200
     2.813    13.284     0.200
     2.813    12.987     0.200
     2.887    13.915     0.200
     3.045    14.281     0.200
     3.343    15.298     0.200
     3.436    14.511     0.200
     3.436    17.214     0.200
     3.436    16.714     0.200
     3.710    15.619     0.200
     3.893    16.673     0.200
     4.141    16.280     0.200
     4.231    16.840     0.200
     4.586    17.896     0.200
     5.168    19.501     0.200
     5.168    19.102     0.200
     5.787    20.176     0.200
     5.787    20.277     0.200
     6.630    22.047     0.200
     6.755    22.172     0.200
     7.012    22.583     0.200
     7.386    21.723     0.200
     7.790    24.195     0.200
     7.882    23.229     0.200
     7.819    23.756     0.200
     8.114    24.023     0.200
     8.497    25.756     0.200
    10.097    30.173     0.200
    10.802    28.954     0.200
    11.273    31.151     0.200
    11.478    31.866     0.200
    11.554    31.409     0.200
    11.670    32.127     0.200
     1.517    10.628     0.200
     1.517    10.425     0.200
     2.494    12.725     0.200
     2.698    13.535     0.200
     2.698    13.340     0.200
     2.769    13.611     0.200
     3.005    14.256     0.200
     3.606    16.245     0.200
     3.745    16.218     0.200
     4.141    16.695     0.200
     4.098    16.603     0.200
     4.535    17.600     0.200
     5.024    18.894     0.200
     5.024    19.699     0.200
     5.670    21.053     0.200
     5.787    19.585     0.200
     5.787    19.483     0.200
     6.622    21.641     0.200
     7.696    20.708     0.200
     7.749    22.197     0.200
     8.085    23.277     0.200
     8.520    24.994     0.200
    10.063    30.687     0.200
    11.073    32.700     0.200
    11.165    29.834     0.200
    11.395    31.245     0.200
    11.410    31.175     0.200
    11.665    32.458     0.200
     1.522    10.592     0.200
     1.522    11.691     0.200
     2.711    13.515     0.200
     2.711    13.314     0.200
     3.013    14.493     0.200
     4.101    16.786     0.200
     4.542    17.449     0.200
     5.796    19.516     0.200
     1.477    10.008     0.200
     2.351    12.599     0.200
     2.403    13.002     0.200
     2.403    12.701     0.200
     3.558    15.116     0.200
     3.558    14.116     0.200
     4.499    17.436     0.200
     5.101    18.017     0.200
     6.319    20.598     0.200
     6.319    20.897     0.200
     2.150    12.877     0.200
     2.541    13.313     0.200
     2.541    14.213     0.200
     2.710    13.346     0.200
     2.710    12.846     0.200
     3.800    17.121     0.200
     3.918    16.346     0.200
     3.885    16.635     0.200
     4.183    17.352     0.200
     4.827    19.140     0.200
     5.043    18.418     0.200
     5.394    16.823     0.200
     6.603    23.513     0.200
     6.603    22.513     0.200
     7.107    22.229     0.200
     7.178    24.100     0.200
     7.444    22.902     0.200
     7.695    24.465     0.200
     8.271    23.652     0.200
    10.869    28.424     0.200
    10.821    30.536     0.200
    11.102    30.926     0.200
    11.290    33.614     0.200
    16.077    36.049     0.200
    19.086    42.281     0.200
    19.645    42.014     0.200
    20.763    41.763     0.200
     2.188    11.575     0.200
     2.188    11.376     0.200
     2.523    13.071     0.200
     2.675    11.899     0.200
     3.867    15.288     0.200
     4.174    16.306     0.200
     4.809    16.197     0.200
     5.422    15.537     0.200
     2.164    12.712     0.200
     2.164    13.009     0.200
     2.536    14.566     0.200
     2.640    14.049     0.200
     2.698    13.172     0.200
     2.698    12.672     0.200
     3.804    17.159     0.200
     3.879    16.785     0.200
     3.927    16.530     0.200
     4.181    17.173     0.200
     4.181    17.368     0.200
     4.821    19.893     0.200
     4.821    20.393     0.200
     6.202    21.082     0.200
     6.601    22.521     0.200
     7.694    23.766     0.200
     7.694    23.867     0.200
     8.266    24.092     0.200
    10.643    31.158     0.200
    10.825    30.721     0.200
    10.881    28.476     0.200
    11.106    30.993     0.200
    19.079    44.281     0.200
     1.212    10.972     0.200
     1.342    10.548     0.200
     2.163    13.074     0.200
     2.163    12.972     0.200
     2.540    13.969     0.200
     2.540    14.669     0.200
     2.701    13.495     0.200
     3.800    16.870     0.200
     3.884    16.887     0.200
     3.923    16.529     0.200
     4.185    17.468     0.200
     4.826    19.194     0.200
     4.826    19.296     0.200
     5.399    16.700     0.200
     6.606    21.820     0.200
     6.606    22.523     0.200
     7.454    23.519     0.200
     2.158    12.823     0.200
     2.158    12.624     0.200
     2.544    13.410     0.200
     2.706    13.224     0.200
     3.888    16.931     0.200
     4.189    17.323     0.200
     4.830    18.838     0.200
     4.830    19.237     0.200
     5.365    19.393     0.200
     5.365    19.794     0.200
     6.210    21.939     0.200
     6.609    22.079     0.200
     6.609    22.678     0.200
     7.454    22.617     0.200
     7.702    25.625     0.200
     8.261    24.797     0.200
    10.873    30.215     0.200
    11.111    30.674     0.200
     1.454    10.450     0.200
     2.373    12.331     0.200
     2.421    12.669     0.200
     2.421    12.169     0.200
     3.572    14.835     0.200
     3.572    13.538     0.200
     3.914    15.449     0.200
     4.098    14.906     0.200
     1.310    10.810     0.200
     2.465    12.826     0.200
     2.502    13.700     0.200
     2.502    13.400     0.200
     2.736    13.766     0.200
     3.773    17.168     0.200
     3.800    15.945     0.200
     3.896    16.331     0.200
     4.275    17.108     0.200
     4.275    17.408     0.200
     5.499    19.425     0.200
     6.703    22.264     0.200
     6.703    22.064     0.200
     7.059    23.010     0.200
     7.734    23.042     0.200
     7.734    22.242     0.200
     1.667    11.839     0.200
     2.160    12.677     0.200
     2.279    12.094     0.200
     2.488    13.751     0.200
     3.367    15.301     0.200
     3.701    16.094     0.200
     4.916    18.321     0.200
     5.908    17.847     0.200
     2.180    12.651     0.200
     2.636    13.931     0.200
     2.683    12.579     0.200
     3.871    16.510     0.200
     3.871    16.611     0.200
     4.813    18.818     0.200
     4.813    18.619     0.200
     5.356    19.284     0.200
     6.597    20.497     0.200
     6.597    22.197     0.200
     7.458    21.850     0.200
     2.434    12.963     0.200
     2.434    13.065     0.200
     2.480    13.533     0.200
     2.474    12.991     0.200
     2.645    12.606     0.200
     2.645    13.606     0.200
     3.818    15.121     0.200
     3.818    16.214     0.200
     4.184    16.933     0.200
     4.755    18.578     0.200
     4.755    18.680     0.200
     5.403    19.208     0.200
     5.565    15.624     0.200
     6.243    20.712     0.200
     6.613    21.799     0.200
     6.613    21.698     0.200
     7.413    23.157     0.200
     7.638    22.937     0.200
     7.720    23.980     0.200
     2.421    13.142     0.200
     2.488    13.166     0.200
     2.639    13.193     0.200
     2.639    13.693     0.200
     3.816    16.461     0.200
     4.179    17.122     0.200
     4.754    18.817     0.200
     4.754    18.919     0.200
     5.396    19.319     0.200
     5.396    19.420     0.200
     6.236    21.116     0.200
     6.607    21.589     0.200
     7.625    22.811     0.200
     7.714    24.374     0.200
     8.116    25.078     0.200
     1.231    10.853     0.200
     2.427    13.198     0.200
     2.468    13.413     0.200
     2.481    12.160     0.200
     2.481    12.961     0.200
     2.636    13.151     0.200
     2.636    13.850     0.200
     3.475    15.759     0.200
     3.812    16.436     0.200
     3.761    16.827     0.200
     3.855    16.330     0.200
     3.870    16.860     0.200
     4.176    17.378     0.200
     4.749    18.992     0.200
     4.749    18.492     0.200
     5.212    18.487     0.200
     5.394    19.667     0.200
     6.234    21.165     0.200
     6.604    21.743     0.200
     7.382    21.036     0.200
     7.404    23.314     0.200
     7.432    23.383     0.200
     7.626    22.818     0.200
     7.626    22.919     0.200
     7.711    23.826     0.200
     8.140    23.724     0.200
     8.987    28.035     0.200
     9.694    28.289     0.200
    10.682    30.955     0.200
    11.222    32.640     0.200
    11.252    31.501     0.200
     2.438    12.896     0.200
     2.438    12.599     0.200
     2.474    12.477     0.200
     2.474    13.078     0.200
     2.468    13.145     0.200
     2.468    12.949     0.200
     2.639    13.652     0.200
     3.762    16.141     0.200
     3.811    16.275     0.200
     3.856    17.654     0.200
     4.178    17.182     0.200
     4.178    16.487     0.200
     4.749    19.334     0.200
     5.221    17.220     0.200
     5.398    19.452     0.200
     5.398    19.155     0.200
     6.238    21.152     0.200
     6.607    21.947     0.200
     7.635    24.148     0.200
     2.132    12.162     0.200
     2.803    12.427     0.200
     2.803    13.130     0.200
     3.783    15.797     0.200
     4.045    16.741     0.200
     4.987    18.549     0.200
     4.987    18.948     0.200
     5.526    19.453     0.200
     6.371    21.392     0.200
     6.772    22.422     0.200
     6.772    22.320     0.200
     7.522    23.754     0.200
     7.577    22.423     0.200
     2.126    12.060     0.200
     2.126    12.560     0.200
     2.698    12.388     0.200
     2.805    12.639     0.200
     2.805    13.232     0.200
     3.783    16.122     0.200
     4.042    16.702     0.200
     4.042    16.898     0.200
     4.984    18.807     0.200
     5.521    19.637     0.200
     6.366    21.583     0.200
     6.767    21.497     0.200
     6.767    23.302     0.200
     7.570    22.733     0.200
     2.667    13.354     0.200
     2.819    12.984     0.200
     2.503    12.570     0.200
     2.669    12.429     0.200
     3.025    14.284     0.200
     3.203    13.703     0.200
     4.136    16.714     0.200
     5.673    19.580     0.200
     2.486    13.280     0.200
     2.529    13.776     0.200
     2.529    13.675     0.200
     2.715    13.099     0.200
     2.913    13.494     0.200
     2.990    12.495     0.200
     3.273    14.393     0.200
     3.453    14.795     0.200
     3.453    14.595     0.200
     5.641    18.356     0.200
     8.125    25.270     0.200
     2.472    13.513     0.200
     2.472    13.107     0.200
     2.493    11.861     0.200
     2.493    12.666     0.200
     2.547    13.436     0.200
     2.730    13.696     0.200
     3.808    15.916     0.200
     3.888    14.983     0.200
     3.888    16.678     0.200
     4.269    17.138     0.200
     4.427    16.289     0.200
     4.824    17.460     0.200
     4.824    18.460     0.200
     5.533    17.192     0.200
     5.493    19.251     0.200
     6.697    21.997     0.200
     7.807    24.449     0.200
     1.779    11.954     0.200
     1.874    12.253     0.200
     1.874    12.550     0.200
     2.248    11.384     0.200
     3.118    14.729     0.200
     3.118    14.628     0.200
     3.415    15.460     0.200
     3.415    15.264     0.200
     4.633    18.046     0.200
     4.618    17.628     0.200
     4.618    17.323     0.200
     5.839    19.872     0.200
     6.940    24.128     0.200
     6.967    20.502     0.200
     2.161    11.269     0.200
     2.885    11.521     0.200
     3.099    12.433     0.200
     3.099    12.332     0.200
     3.267    12.468     0.200
     3.480    10.678     0.200
     3.673    14.224     0.200
     3.759    13.827     0.200
     4.714    16.275     0.200
     5.196    17.360     0.200
     5.628    20.111     0.200
     5.628    19.209     0.200
     6.462    20.187     0.200
    19.619    37.914     0.200
     1.752     9.895     0.200
     2.666    10.132     0.200
     2.666    10.632     0.200
     2.718    11.822     0.200
     3.242    13.215     0.200
     3.388    13.307     0.200
     3.388    12.907     0.200
     3.862    14.377     0.200
     4.330    15.309     0.200
     4.772    16.658     0.200
     4.772    16.557     0.200
     6.022    18.468     0.200
     6.022    18.168     0.200
     1.602    10.926     0.200
     1.602    11.426     0.200
     1.689    12.308     0.200
     2.668    13.282     0.200
     3.703    15.297     0.200
     4.002    15.916     0.200
     4.183    16.507     0.200
     4.183    16.406     0.200
     4.943    18.136     0.200
     4.943    17.835     0.200
     5.273    18.579     0.200
     6.121    20.284     0.200
     6.572    21.125     0.200
     6.572    20.725     0.200
     7.097    21.291     0.200
     7.097    21.791     0.200
     1.589    11.861     0.200
     2.300    12.666     0.200
     2.776    12.805     0.200
     2.776    12.907     0.200
     2.980    13.830     0.200
     2.980    14.229     0.200
     3.403    15.596     0.200
     3.497    15.599     0.200
     3.514    15.103     0.200
     3.753    16.003     0.200
     4.170    16.846     0.200
     4.522    17.640     0.200
     4.522    17.538     0.200
     5.108    18.899     0.200
     5.108    18.798     0.200
     5.722    19.834     0.200
     6.564    21.698     0.200
     6.948    22.329     0.200
     7.361    20.501     0.200
     7.725    23.853     0.200
     7.826    22.974     0.200
     7.880    21.443     0.200
     7.880    21.217     0.200
     8.049    24.179     0.200
     8.432    25.304     0.200
    10.829    27.534     0.200
    11.009    31.827     0.200
    11.211    30.772     0.200
    11.414    32.608     0.200
    11.492    31.576     0.200
    11.607    31.751     0.200
    12.881    31.884     0.200
    13.277    31.164     0.200
    14.252    35.583     0.200
    14.913    37.475     0.200
    18.011    39.922     0.200
    19.297    42.455     0.200
    19.297    42.760     0.200
    19.851    41.643     0.200
    20.137    43.404     0.200
     1.557     9.796     0.200
     1.557     9.695     0.200
     2.034    10.833     0.200
     2.841    12.709     0.200
     2.894    11.892     0.200
     3.489    14.453     0.200
     3.562    14.004     0.200
     3.598    14.083     0.200
     3.598    14.677     0.200
     3.709    14.878     0.200
     4.094    15.485     0.200
     4.380    15.958     0.200
     5.037    18.089     0.200
     5.037    18.191     0.200
     5.540    18.116     0.200
     6.386    19.949     0.200
     6.796    20.855     0.200
     7.534    21.646     0.200
     7.530    22.192     0.200
     7.883    22.871     0.200
     7.883    22.973     0.200
     8.149    21.679     0.200
     8.230    23.718     0.200
    10.953    30.445     0.200
    11.239    29.450     0.200
    12.763    29.525     0.200
    18.231    37.112     0.200
    19.282    41.598     0.200
    19.870    40.887     0.200
     2.291    12.869     0.200
     2.785    12.507     0.200
     3.508    14.366     0.200
     4.174    16.990     0.200
     4.524    17.608     0.200
     5.231    17.360     0.200
     5.723    18.814     0.200
     2.847    13.074     0.200
     2.883    12.949     0.200
     2.883    13.246     0.200
     3.116    13.936     0.200
     3.116    14.237     0.200
     3.257    13.982     0.200
     3.710    15.899     0.200
     1.239    11.175     0.200
     2.103    13.997     0.200
     2.103    12.298     0.200
     2.682    14.039     0.200
     2.952    14.388     0.200
     3.894    17.189     0.200
     3.894    18.488     0.200
     4.704    17.836     0.200
     5.701    20.602     0.200
     6.946    23.676     0.200
     8.791    26.846     0.200
     2.786    12.372     0.200
     2.743    13.871     0.200
     2.871    15.676     0.200
     3.584    17.652     0.200
     3.578    16.226     0.200
     4.087    17.280     0.200
     4.412    18.091     0.200
     5.028    21.106     0.200
     5.598    20.452     0.200
     5.598    20.952     0.200
     1.666    12.625     0.200
     2.348    12.758     0.200
     2.348    13.258     0.200
     2.805    13.426     0.200
     2.805    13.527     0.200
     4.251    16.055     0.200
     4.251    17.457     0.200
     4.615    17.604     0.200
     5.187    20.328     0.200
     5.821    20.329     0.200
     5.821    20.630     0.200
     7.042    22.582     0.200
     7.042    23.683     0.200
     1.626    12.683     0.200
     2.349    12.148     0.200
     2.349    12.648     0.200
     2.776    13.064     0.200
     3.456    16.324     0.200
     3.456    16.926     0.200
     3.485    14.995     0.200
     4.211    17.719     0.200
     5.148    19.389     0.200
     5.781    20.194     0.200
     7.001    22.652     0.200
     7.001    23.152     0.200
     7.898    23.488     0.200
     7.898    25.687     0.200
     8.105    24.176     0.200
     1.625    13.079     0.200
     2.344    12.785     0.200
     3.458    17.088     0.200
     3.458    16.188     0.200
     3.485    15.168     0.200
     4.209    16.219     0.200
     4.209    17.320     0.200
     4.572    17.788     0.200
     5.146    21.086     0.200
     5.146    19.987     0.200
     5.778    19.912     0.200
     5.778    20.014     0.200
     6.620    22.087     0.200
     6.999    22.466     0.200
     6.999    23.366     0.200
     7.893    23.127     0.200
     1.486    11.381     0.200
     2.204    13.094     0.200
     2.760    12.615     0.200
     3.614    15.545     0.200
     3.621    16.263     0.200
     3.621    15.865     0.200
     3.806    16.403     0.200
     4.051    16.946     0.200
     4.375    17.567     0.200
     4.991    19.072     0.200
     5.288    15.611     0.200
     5.562    19.916     0.200
     6.405    21.374     0.200
     6.798    22.384     0.200
     7.646    24.298     0.200
     2.212    12.479     0.200
     2.212    12.678     0.200
     2.757    12.420     0.200
     2.757    12.920     0.200
     3.612    15.238     0.200
     3.618    16.169     0.200
     4.053    15.286     0.200
     4.053    16.888     0.200
     4.380    17.679     0.200
     4.994    18.613     0.200
     5.289    15.670     0.200
     5.567    19.720     0.200
     6.803    22.198     0.200
     7.654    23.464     0.200
     7.900    22.799     0.200
     1.138    11.099     0.200
     2.708    12.784     0.200
     2.710    14.055     0.200
     5.369    15.929     0.200
     2.260    13.365     0.200
     2.772    13.590     0.200
     2.926    15.090     0.200
     3.541    16.110     0.200
     3.549    15.526     0.200
     3.769    15.550     0.200
     4.269    15.916     0.200
     2.113    12.727     0.200
     2.755    14.126     0.200
     2.790    13.118     0.200
     3.660    15.174     0.200
     3.997    16.532     0.200
     4.295    17.256     0.200
     5.467    20.285     0.200
     1.412    12.120     0.200
     2.262    13.507     0.200
     2.430    13.943     0.200
     2.541    13.943     0.200
     2.541    13.841     0.200
     4.018    17.517     0.200
     3.971    16.361     0.200
     4.607    17.034     0.200
     5.158    18.708     0.200
     7.329    22.972     0.200
     2.256    12.755     0.200
     2.256    13.654     0.200
     2.540    12.245     0.200
     3.645    15.752     0.200
     4.041    17.433     0.200
     4.800    18.372     0.200
     4.889    16.932     0.200
     7.301    22.176     0.200
     7.301    23.379     0.200
     2.502    12.680     0.200
     2.498    13.135     0.200
     2.689    13.294     0.200
     3.843    15.731     0.200
     4.227    16.345     0.200
     1.546    12.160     0.200
     1.751    11.663     0.200
     2.288    12.995     0.200
     2.753    13.473     0.200
     2.780    15.154     0.200
     2.931    14.502     0.200
     3.542    17.861     0.200
     3.542    15.961     0.200
     3.555    15.117     0.200
     3.784    15.946     0.200
     4.124    17.469     0.200
     4.258    16.814     0.200
     4.472    17.913     0.200
     5.063    19.617     0.200
     5.671    19.821     0.200
     5.760    19.788     0.200
     2.459    11.565     0.200
     2.459    13.366     0.200
     2.485    13.351     0.200
     2.485    13.452     0.200
     2.687    13.504     0.200
     3.825    16.324     0.200
     3.825    18.023     0.200
     3.852    15.608     0.200
     3.844    16.102     0.200
     3.844    16.301     0.200
     4.225    16.851     0.200
     4.780    18.879     0.200
     4.780    19.281     0.200
     5.452    18.940     0.200
     6.654    22.005     0.200
     7.706    22.834     0.200
     8.175    26.554     0.200
     2.049    12.342     0.200
     2.446    11.599     0.200
     2.446    12.599     0.200
     2.500    12.868     0.200
     2.500    13.168     0.200
     2.498    13.492     0.200
     2.686    13.401     0.200
     3.859    15.315     0.200
     3.840    15.740     0.200
     3.840    16.040     0.200
     4.010    15.848     0.200
     4.224    16.851     0.200
     4.775    17.924     0.200
     6.653    21.902     0.200
     7.715    22.118     0.200
     7.715    22.818     0.200
     2.048    12.102     0.200
     2.450    11.708     0.200
     2.450    12.106     0.200
     2.498    12.556     0.200
     2.494    13.100     0.200
     2.684    13.483     0.200
     2.684    13.382     0.200
     3.830    16.313     0.200
     3.858    15.681     0.200
     3.839    16.805     0.200
     3.839    16.004     0.200
     4.016    16.440     0.200
     4.095    16.617     0.200
     4.222    17.033     0.200
     4.471    16.329     0.200
     4.775    19.084     0.200
     5.450    19.006     0.200
     6.288    22.317     0.200
     6.651    21.885     0.200
     7.761    24.730     0.200
     8.067    20.963     0.200
     1.557    11.823     0.200
     2.307    12.463     0.200
     2.750    12.698     0.200
     2.948    14.183     0.200
     4.490    17.398     0.200
     5.075    17.662     0.200
     2.280    13.426     0.200
     2.760    14.823     0.200
     2.784    14.451     0.200
     4.473    17.230     0.200
     1.011    12.140     0.200
     2.287    13.950     0.200
     2.284    13.776     0.200
     2.441    13.441     0.200
     2.561    13.746     0.200
     2.561    13.645     0.200
     3.595    15.083     0.200
     3.978    16.708     0.200
     4.092    16.881     0.200
     4.531    19.052     0.200
     5.213    18.999     0.200
     6.408    22.858     0.200
     2.223    11.767     0.200
     2.718    10.595     0.200
     2.783    13.434     0.200
     3.666    14.730     0.200
     3.855    15.527     0.200
     3.998    16.249     0.200
     4.324    16.646     0.200
     4.324    16.946     0.200
     5.513    18.872     0.200
     2.064    11.557     0.200
     2.064    12.057     0.200
     2.240    11.806     0.200
     2.859    12.787     0.200
     2.866    13.299     0.200
     2.866    14.494     0.200
     3.112    14.131     0.200
     3.401    14.353     0.200
     3.465    14.014     0.200
     3.576    14.714     0.200
     4.809    17.424     0.200
     4.809    16.822     0.200
     5.115    18.354     0.200
     5.115    18.158     0.200
     5.750    19.948     0.200
     7.227    19.205     0.200
     8.103    25.989     0.200
     8.103    22.793     0.200
     2.242    13.284     0.200
     2.552    13.559     0.200
     2.864    15.324     0.200
     2.959    14.616     0.200
     3.188    15.038     0.200
     3.188    13.843     0.200
     3.365    16.477     0.200
     3.493    15.676     0.200
     4.829    18.884     0.200
     5.227    19.544     0.200
     5.227    19.739     0.200
     5.760    23.231     0.200
     6.442    22.161     0.200
     7.186    20.025     0.200
     7.186    20.181     0.200
     7.656    25.702     0.200
     7.656    24.897     0.200
     7.714    23.720     0.200
     8.481    25.474     0.200
    10.603    30.656     0.200
    10.746    29.742     0.200
    11.916    33.485     0.200
    12.288    35.941     0.200
    14.804    36.984     0.200
    19.863    41.899     0.200
     2.205    12.654     0.200
     2.205    12.756     0.200
     2.683    12.570     0.200
     2.683    12.172     0.200
     2.683    13.983     0.200
     3.751    15.416     0.200
     3.909    16.172     0.200
     3.918    16.259     0.200
     4.224    17.693     0.200
     4.850    17.983     0.200
     5.115    17.893     0.200
     5.408    19.267     0.200
     6.646    21.027     0.200
     7.517    23.157     0.200
     1.350    11.212     0.200
     2.275    12.415     0.200
     2.487    13.541     0.200
     3.713    15.935     0.200
     3.945    15.534     0.200
     4.029    16.354     0.200
     4.655    16.348     0.200
     6.452    21.171     0.200
     7.392    22.903     0.200
     1.240    10.908     0.200
     2.443    11.967     0.200
     2.494    12.969     0.200
     3.826    15.726     0.200
     3.842    14.737     0.200
     4.104    15.374     0.200
     4.762    18.008     0.200
     2.118    13.200     0.200
     2.746    12.968     0.200
     3.775    16.363     0.200
     3.914    15.942     0.200
     4.206    17.326     0.200
     4.569    16.396     0.200
     2.522    11.482     0.200
     2.506    12.563     0.200
     2.827    13.620     0.200
     3.700    16.133     0.200
     3.740    15.164     0.200
     3.972    15.554     0.200
     3.972    15.054     0.200
     4.364    16.378     0.200
     5.594    19.429     0.200
     1.039     9.958     0.200
     1.492    13.170     0.200
     2.307    12.863     0.200
     2.322    13.085     0.200
     2.322    12.885     0.200
     2.465    12.216     0.200
     2.465    12.316     0.200
     2.343    13.142     0.200
     3.572    15.495     0.200
     3.885    16.554     0.200
     3.885    16.654     0.200
     4.515    18.803     0.200
     5.078    18.821     0.200
     6.308    21.570     0.200
     7.291    22.002     0.200
     7.291    21.901     0.200
     7.790    24.272     0.200
     9.390    29.603     0.200
    10.607    30.098     0.200
    18.138    39.417     0.200
     1.301    11.616     0.200
     1.987    11.910     0.200
     2.609    14.157     0.200
     2.609    14.056     0.200
     2.655    14.320     0.200
     2.899    13.664     0.200
     2.899    13.363     0.200
     3.636    16.571     0.200
     3.720    16.487     0.200
     3.787    16.911     0.200
     3.787    16.712     0.200
     3.804    17.403     0.200
     3.945    17.268     0.200
     4.187    17.742     0.200
     4.187    17.640     0.200
     4.543    17.981     0.200
     4.888    18.662     0.200
     4.888    19.162     0.200
     5.323    19.786     0.200
     5.323    19.985     0.200
     6.170    20.903     0.200
     6.594    21.844     0.200
     6.874    20.976     0.200
     6.874    21.097     0.200
     7.283    22.411     0.200
     7.283    23.110     0.200
     7.673    23.055     0.200
     7.673    24.254     0.200
     8.003    25.411     0.200
     8.400    24.550     0.200
     8.935    26.727     0.200
     9.189    26.964     0.200
     9.656    27.653     0.200
     9.656    27.411     0.200
     9.656    28.411     0.200
    10.599    32.309     0.200
    10.704    30.281     0.200
    10.688    30.450     0.200
    10.979    32.069     0.200
    10.992    31.347     0.200
    10.992    31.343     0.200
    11.073    32.080     0.200
    12.786    32.186     0.200
    16.044    38.166     0.200
    18.469    43.618     0.200
    19.163    43.081     0.200
    19.164    43.066     0.200
    19.567    42.029     0.200
    19.706    43.847     0.200
    19.737    44.493     0.200
    19.737    43.837     0.200
    19.737    44.466     0.200
     2.212    12.855     0.200
     2.212    12.261     0.200
     2.615    12.158     0.200
     2.615    12.861     0.200
     2.739    14.017     0.200
     2.739    14.119     0.200
     2.704    12.721     0.200
     3.632    16.392     0.200
     3.703    15.369     0.200
     3.959    16.568     0.200
     3.959    15.068     0.200
     4.280    17.327     0.200
     4.293    17.176     0.200
     4.900    17.486     0.200
     4.900    19.689     0.200
     5.467    19.376     0.200
     6.310    20.734     0.200
     7.571    22.523     0.200
     2.215    13.246     0.200
     2.263    13.880     0.200
     2.431    14.820     0.200
     2.541    13.145     0.200
     3.666    15.912     0.200
     4.129    17.210     0.200
     2.367    12.758     0.200
     2.507    13.923     0.200
     3.708    15.213     0.200
     4.049    16.835     0.200
     2.592    12.870     0.200
     2.737    11.480     0.200
     3.217    13.881     0.200
     4.752    16.864     0.200
     1.302    10.302     0.200
     2.086    11.346     0.200
     2.567    12.441     0.200
     3.038    12.540     0.200
     3.541    14.972     0.200
     4.387    16.101     0.200
     5.079    18.424     0.200
     5.603    18.509     0.200
     1.920    12.150     0.200
     2.300    13.008     0.200
     2.367    12.835     0.200
     2.364    13.470     0.200
     3.393    16.153     0.200
     3.688    16.313     0.200
     3.886    16.905     0.200
     4.094    15.875     0.200
     4.543    17.233     0.200
     5.002    18.985     0.200
     6.285    21.512     0.200
     6.454    22.230     0.200
     6.975    22.459     0.200
     6.980    23.000     0.200
     1.624    12.531     0.200
     2.237    13.276     0.200
     2.205    12.844     0.200
     2.484    13.502     0.200
     2.540    13.739     0.200
     3.059    13.877     0.200
     3.390    15.621     0.200
     3.745    16.182     0.200
     3.916    15.883     0.200
     4.279    17.952     0.200
     4.276    16.585     0.200
     4.330    18.254     0.200
     4.970    18.285     0.200
     6.173    22.445     0.200
     7.315    21.911     0.200
     1.371    11.053     0.200
     2.570    13.352     0.200
     2.474    12.579     0.200
     2.474    12.079     0.200
     2.622    14.748     0.200
     2.830    14.022     0.200
     2.830    13.920     0.200
     3.719    16.247     0.200
     3.613    15.283     0.200
     3.978    16.121     0.200
     3.990    15.781     0.200
     3.959    15.246     0.200
     4.365    17.309     0.200
     4.365    17.504     0.200
     4.891    19.266     0.200
     5.603    19.056     0.200
     5.603    19.556     0.200
     6.795    23.549     0.200
     6.795    23.049     0.200
     7.874    22.661     0.200
     7.874    22.762     0.200
     8.331    25.030     0.200
     9.890    28.029     0.200
    10.369    32.337     0.200
    11.416    33.217     0.200
    11.460    31.429     0.200
    15.603    37.260     0.200
     1.358    12.033     0.200
     2.462    12.847     0.200
     2.576    13.323     0.200
     2.819    14.083     0.200
     2.819    14.989     0.200
     3.600    14.264     0.200
     3.732    14.529     0.200
     3.981    16.024     0.200
     3.946    16.227     0.200
     4.354    17.372     0.200
     5.593    19.516     0.200
     7.868    22.756     0.200
     1.563    11.289     0.200
     1.950    11.677     0.200
     2.738    13.283     0.200
     2.805    13.992     0.200
     2.940    12.717     0.200
     3.633    14.538     0.200
     4.078    16.347     0.200
     4.341    17.074     0.200
     4.489    15.744     0.200
     4.549    16.543     0.200
     5.021    18.640     0.200
     5.486    19.307     0.200
     6.752    22.635     0.200
     1.254    10.754     0.200
     2.164    12.939     0.200
     2.614    13.584     0.200
     2.955    13.506     0.200
     3.085    12.892     0.200
     3.624    16.196     0.200
     4.399    17.361     0.200
     4.399    19.261     0.200
     5.162    19.455     0.200
     5.678    20.536     0.200
     6.387    21.855     0.200
     8.476    26.173     0.200
     2.157    13.549     0.200
     2.176    13.435     0.200
     2.390    13.536     0.200
     2.481    13.871     0.200
     3.414    15.887     0.200
     3.732    16.570     0.200
     3.924    17.036     0.200
     4.021    17.300     0.200
     4.282    17.055     0.200
     4.675    18.976     0.200
     5.195    19.403     0.200
     6.040    20.548     0.200
     6.440    22.373     0.200
     6.655    23.160     0.200
     7.068    23.145     0.200
     7.313    23.183     0.200
     7.406    24.607     0.200
     7.532    25.029     0.200
     7.897    26.174     0.200
     8.418    25.603     0.200
    10.951    31.215     0.200
    10.956    31.767     0.200
    18.930    43.490     0.200
     2.177    13.207     0.200
     2.616    13.092     0.200
     2.728    12.786     0.200
     2.731    14.149     0.200
     3.699    14.945     0.200
     4.272    17.366     0.200
     5.453    19.281     0.200
     2.393    13.170     0.200
     2.788    14.258     0.200
     3.095    13.974     0.200
     4.635    18.296     0.200
     5.214    18.650     0.200
     2.370    13.617     0.200
     3.091    15.610     0.200
     4.262    17.839     0.200
     4.631    18.530     0.200
     5.198    19.615     0.200
     5.840    20.921     0.200
     1.548    12.192     0.200
     1.750    11.833     0.200
     2.340    13.346     0.200
     2.726    13.439     0.200
     2.787    14.124     0.200
     2.949    15.436     0.200
     3.536    14.886     0.200
     3.558    15.233     0.200
     3.793    14.886     0.200
     4.131    17.351     0.200
     4.490    17.953     0.200
     5.068    19.010     0.200
     5.696    20.080     0.200
     7.827    25.114     0.200
    11.571    32.319     0.200
     2.129    12.516     0.200
     2.255    13.247     0.200
     2.374    12.259     0.200
     2.403    14.017     0.200
     2.404    14.006     0.200
     3.149    13.611     0.200
     3.473    15.629     0.200
     3.796    16.658     0.200
     4.052    15.567     0.200
     4.185    17.021     0.200
     4.204    16.102     0.200
     4.415    17.841     0.200
     5.000    19.008     0.200
     6.222    21.754     0.200
     7.323    23.898     0.200
     7.538    24.594     0.200
     7.717    25.399     0.200
    11.224    32.930     0.200
    18.657    44.334     0.200
     2.413    13.255     0.200
     2.423    13.641     0.200
     3.619    14.579     0.200
     3.964    16.359     0.200
     2.349    12.721     0.200
     2.712    12.691     0.200
     3.550    15.409     0.200
     3.572    15.445     0.200
     4.117    15.791     0.200
     4.478    17.377     0.200
     2.328    12.809     0.200
     2.739    13.108     0.200
     2.955    14.987     0.200
     3.527    15.213     0.200
     3.547    15.176     0.200
     4.139    16.767     0.200
     4.496    17.901     0.200
     2.669    13.289     0.200
     2.767    14.054     0.200
     3.192    15.459     0.200
     3.325    13.892     0.200
     3.441    13.673     0.200
     4.679    17.093     0.200
     2.245    13.306     0.200
     2.413    12.441     0.200
     2.406    14.226     0.200
     3.464    15.983     0.200
     4.050    16.342     0.200
     4.194    17.260     0.200
     1.400    11.561     0.200
     1.940    12.652     0.200
     2.133    12.906     0.200
     2.701    14.080     0.200
     3.715    15.945     0.200
     1.398    10.946     0.200
     2.147    12.601     0.200
     2.739    12.788     0.200
     2.705    13.888     0.200
     3.714    15.714     0.200
     3.739    16.524     0.200
     3.943    16.343     0.200
     4.246    17.310     0.200
     4.344    16.358     0.200
     4.885    18.749     0.200
     6.266    22.129     0.200
     6.666    21.964     0.200
     6.882    22.248     0.200
     7.497    24.869     0.200
     2.276    12.715     0.200
     2.431    13.608     0.200
     2.566    14.135     0.200
     3.584    16.355     0.200
     3.899    16.387     0.200
     3.968    16.977     0.200
     4.103    17.502     0.200
     2.117    11.511     0.200
     2.255    12.500     0.200
     2.444    12.998     0.200
     3.135    13.728     0.200
     3.461    15.019     0.200
     3.796    15.616     0.200
     4.011    15.703     0.200
     4.199    16.614     0.200
     4.211    15.370     0.200
     5.007    17.883     0.200
     2.674    11.631     0.200
     2.674    11.830     0.200
     2.733    11.643     0.200
     3.055    13.492     0.200
     3.284    13.923     0.200
     3.326    13.722     0.200
     4.115    15.617     0.200
     4.384    15.879     0.200
     4.816    17.037     0.200
     5.310    18.373     0.200
     5.814    18.888     0.200
     6.060    19.221     0.200
     6.897    21.557     0.200
     7.458    19.023     0.200
     8.277    24.549     0.200
     8.302    25.657     0.200
     8.362    25.152     0.200
     8.788    26.287     0.200
    10.987    28.325     0.200
    10.987    28.426     0.200
    11.630    31.719     0.200
    11.905    30.339     0.200
    19.397    38.298     0.200
    19.397    40.073     0.200
    20.491    38.040     0.200
     1.219    10.705     0.200
     1.632    12.484     0.200
     2.113    12.966     0.200
     2.667    14.004     0.200
     2.974    14.522     0.200
     3.296    15.369     0.200
     3.917    17.023     0.200
     4.518    17.603     0.200
     4.524    18.140     0.200
     5.723    21.141     0.200
     2.393    10.942     0.200
     2.705    12.501     0.200
     2.785    12.062     0.200
     2.959    13.231     0.200
     3.673    14.404     0.200
     3.690    14.401     0.200
     3.839    13.765     0.200
     4.028    15.455     0.200
     4.028    15.555     0.200
     4.484    16.540     0.200
     4.952    17.281     0.200
     4.952    18.381     0.200
     5.679    19.892     0.200
     5.747    18.293     0.200
     6.129    19.439     0.200
     7.712    21.268     0.200
     7.712    19.468     0.200
     7.819    21.914     0.200
     8.035    24.398     0.200
     8.098    24.363     0.200
     8.098    22.063     0.200
     8.484    24.956     0.200
    11.269    28.738     0.200
    11.269    28.263     0.200
    11.384    30.010     0.200
    11.651    30.000     0.200
    13.754    34.559     0.200
    15.361    33.513     0.200
    15.361    34.503     0.200
    15.498    37.550     0.200
    17.060    38.580     0.200
    17.950    38.593     0.200
    18.085    38.417     0.200
    18.248    34.975     0.200
    19.035    40.075     0.200
     1.074     8.760     0.200
     2.294    12.124     0.200
     2.490    11.725     0.200
     2.490    12.530     0.200
     2.801    12.506     0.200
     3.266    12.482     0.200
     3.726    15.508     0.200
     5.267    18.429     0.200
     2.021    11.600     0.200
     2.181    12.639     0.200
     2.623    13.583     0.200
     2.677    12.850     0.200
     3.859    15.952     0.200
     4.163    16.802     0.200
     4.296    16.951     0.200
     5.343    19.037     0.200
     1.244    11.754     0.200
     2.030    12.579     0.200
     2.169    12.358     0.200
     2.612    13.093     0.200
     2.682    12.276     0.200
     3.832    17.352     0.200
     3.852    15.719     0.200
     5.330    18.877     0.200
     6.573    21.769     0.200
     7.429    23.674     0.200
     2.263    12.174     0.200
     2.375    13.064     0.200
     2.820    12.472     0.200
     2.880    12.477     0.200
     3.290    12.589     0.200
     3.674    15.613     0.200
     4.851    17.677     0.200
     5.215    19.027     0.200
     1.331    10.997     0.200
     2.036    12.765     0.200
     2.547    14.106     0.200
     3.837    16.452     0.200
     4.083    17.383     0.200
     4.423    17.210     0.200
     5.235    20.639     0.200
     1.368    12.606     0.200
     1.338    11.155     0.200
     2.091    12.969     0.200
     2.091    13.270     0.200
     2.020    12.995     0.200
     2.020    13.597     0.200
     2.488    13.738     0.200
     2.488    15.039     0.200
     2.546    13.969     0.200
     2.783    13.096     0.200
     3.515    15.860     0.200
     3.836    16.414     0.200
     3.893    16.645     0.200
     3.826    16.630     0.200
     4.081    17.355     0.200
     4.438    17.081     0.200
     4.858    18.484     0.200
     4.858    18.284     0.200
     5.230    19.646     0.200
     5.230    19.447     0.200
     5.836    20.962     0.200
     6.492    22.006     0.200
     6.931    20.873     0.200
     7.271    25.519     0.200
     7.425    24.330     0.200
     7.576    23.665     0.200
     7.576    23.966     0.200
     7.757    25.751     0.200
     8.138    25.300     0.200
     8.447    23.213     0.200
     8.447    22.576     0.200
     8.447    23.693     0.200
     8.446    27.414     0.200
     8.840    27.010     0.200
     8.931    27.151     0.200
     9.093    27.654     0.200
     9.559    29.317     0.200
    10.076    30.292     0.200
    10.510    32.028     0.200
    10.510    31.625     0.200
    10.808    30.521     0.200
    10.649    31.027     0.200
    10.649    33.206     0.200
    10.933    30.950     0.200
    10.933    31.681     0.200
    10.970    33.559     0.200
    10.970    33.860     0.200
    11.201    33.161     0.200
    11.940    33.535     0.200
    12.199    32.716     0.200
    12.280    35.368     0.200
    13.205    34.880     0.200
    13.650    38.483     0.200
    13.650    36.374     0.200
    14.743    39.029     0.200
    14.874    40.398     0.200
    14.874    39.045     0.200
    14.874    41.756     0.200
    15.766    42.780     0.200
    16.120    39.649     0.200
    16.143    40.381     0.200
    17.377    43.390     0.200
    17.677    41.448     0.200
    17.830    42.498     0.200
    18.543    41.849     0.200
    19.041    44.163     0.200
    19.041    44.089     0.200
    19.041    44.374     0.200
    19.514    44.357     0.200
    19.691    43.136     0.200
    19.693    43.102     0.200
    20.590    46.085     0.200
    20.730    43.739     0.200
     1.372    12.134     0.200
     2.093    11.924     0.200
     2.489    14.001     0.200
     2.545    14.146     0.200
     2.788    13.212     0.200
     3.516    15.220     0.200
     3.836    16.185     0.200
     3.826    16.693     0.200
     3.826    16.795     0.200
     3.894    16.805     0.200
     3.894    16.606     0.200
     4.080    17.438     0.200
     4.080    17.235     0.200
     4.444    17.187     0.200
     4.853    18.814     0.200
     5.227    19.543     0.200
     5.227    19.442     0.200
     6.491    21.996     0.200
     6.684    22.439     0.200
     7.249    24.245     0.200
     7.574    24.058     0.200
     8.133    25.530     0.200
     8.838    26.702     0.200
    10.804    28.118     0.200
    10.928    28.699     0.200
    11.200    32.840     0.200
    17.680    40.324     0.200
     2.036    12.712     0.200
     2.092    12.559     0.200
     3.839    16.170     0.200
     4.080    17.065     0.200
     1.329    11.042     0.200
     2.031    13.150     0.200
     2.096    12.897     0.200
     3.819    16.388     0.200
     3.842    16.022     0.200
     4.076    17.083     0.200
     5.227    19.256     0.200
     1.344    10.699     0.200
     2.032    12.372     0.200
     2.073    12.885     0.200
     2.563    13.476     0.200
     3.821    16.187     0.200
     3.838    16.190     0.200
     4.099    16.951     0.200
     5.250    19.111     0.200
     1.339    10.801     0.200
     2.028    13.158     0.200
     2.552    13.844     0.200
     3.830    16.333     0.200
     3.831    16.318     0.200
     3.886    16.670     0.200
     4.087    17.222     0.200
     4.432    17.205     0.200
     5.238    19.396     0.200
     1.348    11.005     0.200
     2.026    12.596     0.200
     2.073    12.141     0.200
     2.564    13.713     0.200
     3.819    16.257     0.200
     3.841    16.608     0.200
     4.099    17.089     0.200
     4.435    16.978     0.200
     5.250    19.863     0.200
     2.560    13.705     0.200
     3.823    16.373     0.200
     3.838    16.594     0.200
     4.095    17.187     0.200
     6.508    22.135     0.200
     1.344    11.041     0.200
     2.020    12.648     0.200
     2.083    12.812     0.200
     3.833    16.695     0.200
     3.885    16.585     0.200
     4.089    17.110     0.200
     4.439    17.116     0.200
     5.238    19.397     0.200
     6.501    22.263     0.200
     7.262    24.075     0.200
     7.584    24.917     0.200
     1.330    11.147     0.200
     1.367    12.112     0.200
     2.032    13.245     0.200
     2.094    13.019     0.200
     3.820    17.088     0.200
     3.841    16.539     0.200
     4.078    17.477     0.200
     6.490    22.722     0.200
     7.261    23.526     0.200
     1.366    12.186     0.200
     1.337    11.125     0.200
     2.090    13.034     0.200
     2.090    13.334     0.200
     2.024    13.215     0.200
     2.024    13.315     0.200
     2.488    13.696     0.200
     2.546    14.413     0.200
     2.781    13.579     0.200
     3.835    16.270     0.200
     3.892    17.109     0.200
     3.825    17.485     0.200
     4.082    17.497     0.200
     4.082    17.698     0.200
     4.435    17.269     0.200
     5.231    19.582     0.200
     7.258    23.230     0.200
     7.258    21.330     0.200
     7.577    24.805     0.200
    10.810    31.752     0.200
    10.935    30.535     0.200
    19.041    44.066     0.200
     1.344    11.190     0.200
     1.359    11.809     0.200
     2.021    12.781     0.200
     2.554    13.965     0.200
     3.828    16.297     0.200
     3.884    16.539     0.200
     4.089    17.347     0.200
     1.344    11.362     0.200
     2.017    12.913     0.200
     2.085    13.319     0.200
     2.552    14.169     0.200
     2.788    14.216     0.200
     3.829    15.866     0.200
     3.832    17.031     0.200
     3.886    16.497     0.200
     4.087    17.555     0.200
     5.236    19.751     0.200
     2.088    13.174     0.200
     2.009    13.094     0.200
     2.494    14.430     0.200
     2.550    14.489     0.200
     2.794    13.337     0.200
     3.830    16.441     0.200
     3.889    16.855     0.200
     3.832    17.028     0.200
     3.832    16.927     0.200
     4.084    17.581     0.200
     4.449    17.016     0.200
     5.231    19.794     0.200
     6.495    22.442     0.200
     7.250    24.538     0.200
     7.250    24.639     0.200
     7.578    25.206     0.200
    10.797    32.159     0.200
    19.049    45.483     0.200
     1.352    11.417     0.200
     1.343    10.718     0.200
     2.027    12.530     0.200
     2.078    12.637     0.200
     2.497    13.450     0.200
     2.558    14.137     0.200
     2.781    13.038     0.200
     3.825    15.954     0.200
     3.835    16.434     0.200
     3.880    16.511     0.200
     4.094    17.017     0.200
     4.433    16.962     0.200
     5.245    20.087     0.200
     6.506    21.563     0.200
     7.273    23.720     0.200
     7.590    23.714     0.200
     1.318    11.068     0.200
     2.052    12.605     0.200
     2.096    12.787     0.200
     3.813    16.351     0.200
     4.076    17.379     0.200
     1.341    11.367     0.200
     1.367    11.471     0.200
     2.018    12.469     0.200
     2.089    13.342     0.200
     2.548    14.284     0.200
     2.786    12.710     0.200
     4.083    17.670     0.200
     1.344    11.194     0.200
     2.018    13.124     0.200
     2.551    14.099     0.200
     2.787    13.951     0.200
     3.831    16.764     0.200
     3.887    16.717     0.200
     4.087    17.482     0.200
     4.441    17.342     0.200
     4.774    19.260     0.200
     5.235    19.678     0.200
     6.498    22.642     0.200
     1.228    10.728     0.200
     1.228    12.829     0.200
     2.175    13.180     0.200
     2.137    13.024     0.200
     2.409    13.245     0.200
     2.502    13.758     0.200
     2.638    13.069     0.200
     3.751    15.881     0.200
     4.042    17.185     0.200
     4.042    17.083     0.200
     3.939    16.689     0.200
     4.285    16.848     0.200
     4.693    18.197     0.200
     4.926    20.471     0.200
     5.217    19.577     0.200
     5.217    19.374     0.200
     5.956    21.550     0.200
     6.446    21.434     0.200
     6.462    21.751     0.200
     7.333    22.590     0.200
     7.333    22.289     0.200
     7.554    23.807     0.200
     7.919    25.148     0.200
     8.397    22.664     0.200
     8.397    24.605     0.200
     8.823    26.794     0.200
    10.972    30.579     0.200
    10.947    31.808     0.200
    10.947    31.034     0.200
    16.158    36.997     0.200
    16.158    36.118     0.200
    18.529    42.228     0.200
    18.947    43.117     0.200
     2.537    13.872     0.200
     2.507    13.330     0.200
     2.507    13.131     0.200
     3.080    13.151     0.200
     3.494    14.505     0.200
     3.494    14.205     0.200
     7.024    21.854     0.200
     7.024    21.956     0.200
     7.024    19.214     0.200
     7.927    24.870     0.200
     8.620    25.287     0.200
    10.346    29.444     0.200
    12.398    31.677     0.200
    17.016    39.477     0.200
     2.053    11.895     0.200
     2.444    12.532     0.200
     2.494    12.855     0.200
     2.500    13.282     0.200
     3.834    15.712     0.200
     3.835    16.002     0.200
     4.009    15.864     0.200
     4.219    17.017     0.200
     4.770    17.994     0.200
     5.448    19.080     0.200
     6.648    21.769     0.200
     6.674    22.066     0.200
     7.710    22.078     0.200
     8.172    25.186     0.200
     2.074    13.140     0.200
     2.191    12.972     0.200
     2.405    13.467     0.200
     2.463    14.000     0.200
     3.417    15.662     0.200
     3.732    16.483     0.200
     4.054    15.633     0.200
     4.263    17.386     0.200
     4.358    16.981     0.200
     4.782    18.437     0.200
     4.934    18.862     0.200
     6.157    21.386     0.200
     6.162    21.430     0.200
     7.205    20.961     0.200
     7.258    24.040     0.200
     7.650    25.660     0.200
     2.528    12.265     0.200
     2.571    12.959     0.200
     2.705    12.994     0.200
     2.915    13.943     0.200
     3.639    15.995     0.200
     3.695    15.249     0.200
     4.022    16.032     0.200
     4.042    16.100     0.200
     4.451    17.429     0.200
     5.688    19.487     0.200
     6.880    21.576     0.200
     6.914    22.079     0.200
     7.942    25.284     0.200
     2.230    11.199     0.200
     3.030    11.473     0.200
     2.953    12.166     0.200
     3.740    14.880     0.200
     4.785    17.183     0.200
     5.264    17.704     0.200
     2.604    12.965     0.200
     2.604    12.555     0.200
     2.679    13.503     0.200
     3.057    13.488     0.200
     3.380    13.921     0.200
     3.406    13.670     0.200
     4.178    16.606     0.200
     4.505    16.393     0.200
     5.706    20.066     0.200
     2.247    13.072     0.200
     2.373    12.305     0.200
     2.411    13.858     0.200
     2.403    13.854     0.200
     3.466    15.641     0.200
     3.788    16.482     0.200
     4.407    18.064     0.200
     4.992    18.836     0.200
     6.214    21.579     0.200
     7.257    23.599     0.200
     1.609    13.463     0.200
     2.294    13.161     0.200
     2.294    12.864     0.200
     2.793    13.444     0.200
     2.793    12.944     0.200
     3.000    14.636     0.200
     3.477    16.363     0.200
     3.477    14.363     0.200
     4.190    17.347     0.200
     4.310    17.142     0.200
     4.541    17.750     0.200
     5.717    21.121     0.200
     7.838    25.277     0.200
    19.316    43.053     0.200
     1.710    10.862     0.200
     2.385    12.180     0.200
     2.385    12.281     0.200
     2.840    13.070     0.200
     3.868    14.566     0.200
     3.868    13.871     0.200
     3.569    15.060     0.200
     3.661    13.991     0.200
     3.661    14.296     0.200
     3.617    14.905     0.200
     3.617    15.100     0.200
     4.267    14.822     0.200
     4.595    17.591     0.200
     4.852    18.193     0.200
     4.908    17.931     0.200
     4.908    18.032     0.200
     5.159    17.510     0.200
     5.143    18.188     0.200
     5.573    18.780     0.200
     5.850    19.942     0.200
     6.336    19.967     0.200
     6.336    20.069     0.200
     6.244    20.041     0.200
     7.059    19.738     0.200
     6.877    19.153     0.200
     7.092    22.444     0.200
     7.590    20.444     0.200
     7.402    21.832     0.200
     7.753    20.003     0.200
     7.753    19.276     0.200
     7.753    20.643     0.200
     7.540    22.815     0.200
     7.540    22.714     0.200
     7.690    23.167     0.200
     7.889    22.652     0.200
     8.394    24.665     0.200
     8.606    24.881     0.200
     8.606    24.779     0.200
     8.752    25.274     0.200
     8.894    26.519     0.200
     8.891    25.860     0.200
     9.463    26.686     0.200
     9.859    27.656     0.200
     9.968    29.790     0.200
    10.587    30.568     0.200
    11.190    30.030     0.200
    11.121    31.924     0.200
    11.413    30.728     0.200
    11.452    30.370     0.200
    11.452    31.370     0.200
    11.452    31.565     0.200
    11.503    32.781     0.200
    11.503    31.476     0.200
    11.757    30.611     0.200
    11.757    31.267     0.200
    12.021    32.733     0.200
    12.021    32.631     0.200
    12.272    32.492     0.200
    12.490    31.161     0.200
    12.836    31.914     0.200
    13.054    33.376     0.200
    13.486    33.928     0.200
    14.195    35.434     0.200
    14.510    37.579     0.200
    15.121    38.453     0.200
    15.377    39.065     0.200
    16.291    38.294     0.200
    16.314    37.610     0.200
    16.683    35.534     0.200
    16.683    37.315     0.200
    16.683    37.120     0.200
    16.683    38.284     0.200
    16.845    40.836     0.200
    17.271    40.362     0.200
    17.650    37.940     0.200
    17.650    38.643     0.200
    18.754    41.512     0.200
    19.447    41.674     0.200
     1.286    11.279     0.200
     2.479    12.744     0.200
     2.478    13.567     0.200
     2.478    13.364     0.200
     2.714    14.106     0.200
     2.714    14.208     0.200
     3.797    16.577     0.200
     3.872    16.496     0.200
     3.872    16.597     0.200
     4.039    16.144     0.200
     4.039    15.746     0.200
     4.253    17.456     0.200
     4.807    17.889     0.200
     5.478    19.848     0.200
     6.037    21.231     0.200
     6.317    21.659     0.200
     6.682    22.306     0.200
     6.682    22.205     0.200
     6.705    22.530     0.200
     6.779    22.777     0.200
     7.724    22.847     0.200
     7.724    23.043     0.200
     7.791    24.662     0.200
     8.045    22.000     0.200
    11.044    28.896     0.200
    11.140    32.577     0.200
    11.110    32.329     0.200
    11.320    32.180     0.200
    11.317    31.560     0.200
     1.835    10.847     0.200
     2.585    12.694     0.200
     2.585    12.795     0.200
     2.810    11.564     0.200
     3.273    13.763     0.200
     3.087    14.329     0.200
     3.299    14.060     0.200
     4.207    15.370     0.200
     4.421    16.765     0.200
     4.421    16.566     0.200
     4.835    17.338     0.200
     4.835    17.134     0.200
     5.350    18.832     0.200
     5.728    19.114     0.200
     6.067    19.853     0.200
     6.067    19.751     0.200
     7.480    18.889     0.200
     7.480    21.471     0.200
     7.264    22.083     0.200
     7.294    21.838     0.200
     7.412    20.361     0.200
     8.236    23.142     0.200
     8.236    22.939     0.200
     8.379    23.680     0.200
     8.377    25.096     0.200
    10.359    30.470     0.200
    10.895    30.313     0.200
    11.718    32.712     0.200
    11.883    33.286     0.200
    11.886    30.037     0.200
    15.346    35.568     0.200
    16.871    36.324     0.200
     1.221    10.665     0.200
     2.114    12.637     0.200
     2.667    13.992     0.200
     2.909    14.067     0.200
     2.973    14.317     0.200
     3.294    15.270     0.200
     3.914    16.732     0.200
     4.516    17.507     0.200
     5.721    19.943     0.200
     2.321    13.916     0.200
     2.496    14.574     0.200
     3.400    14.930     0.200
     3.683    17.128     0.200
     4.147    16.512     0.200
     4.299    18.140     0.200
     7.090    22.671     0.200
     1.452    11.530     0.200
     2.437    12.731     0.200
     2.437    13.129     0.200
     2.607    12.949     0.200
     2.607    12.746     0.200
     2.878    14.186     0.200
     3.630    15.911     0.200
     4.039    16.936     0.200
     4.039    16.741     0.200
     4.131    16.461     0.200
     4.417    17.519     0.200
     4.974    19.332     0.200
     5.637    20.282     0.200
     5.903    20.594     0.200
     6.477    21.479     0.200
     6.846    22.584     0.200
     6.846    23.084     0.200
     6.865    22.160     0.200
     6.941    22.567     0.200
     7.180    21.331     0.200
     7.831    24.880     0.200
     7.954    25.952     0.200
     7.910    21.874     0.200
     8.357    25.544     0.200
     9.936    27.737     0.200
     9.936    29.018     0.200
    10.998    29.174     0.200
    10.998    30.831     0.200
    11.454    31.612     0.200
    13.718    33.680     0.200
    18.079    39.172     0.200
    19.144    40.711     0.200
     1.452    11.397     0.200
     2.444    13.026     0.200
     2.603    13.465     0.200
     2.698    12.959     0.200
     2.880    14.334     0.200
     3.630    15.684     0.200
     4.039    16.511     0.200
     4.126    16.503     0.200
     4.419    17.676     0.200
     5.640    20.225     0.200
     6.480    22.026     0.200
     6.848    22.835     0.200
     6.868    23.800     0.200
     1.454    11.674     0.200
     2.441    12.949     0.200
     2.606    12.831     0.200
     2.700    14.136     0.200
     2.881    14.315     0.200
     3.628    15.899     0.200
     4.041    16.883     0.200
     4.129    16.461     0.200
     4.420    18.258     0.200
     4.420    17.852     0.200
     4.975    19.679     0.200
     5.641    20.515     0.200
     6.481    21.713     0.200
     6.849    23.011     0.200
     6.868    23.284     0.200
     6.944    22.600     0.200
     7.472    22.647     0.200
     7.472    22.147     0.200
     7.957    26.282     0.200
     7.957    25.282     0.200
     8.361    25.774     0.200
     8.413    24.755     0.200
     9.940    26.348     0.200
    10.929    29.998     0.200
    11.000    28.042     0.200
    11.000    30.276     0.200
    11.183    30.235     0.200
    11.183    29.860     0.200
    11.458    32.193     0.200
    11.489    31.662     0.200
    12.331    34.032     0.200
    13.721    35.219     0.200
    16.728    36.819     0.200
    17.287    38.911     0.200
    18.075    39.334     0.200
    19.145    41.492     0.200
    19.145    42.047     0.200
    19.145    43.218     0.200
    19.649    40.341     0.200
     1.851    11.895     0.200
     1.851    11.996     0.200
     2.450    12.308     0.200
     2.450    12.808     0.200
     2.601    12.651     0.200
     3.629    15.753     0.200
     3.699    16.734     0.200
     4.041    17.039     0.200
     4.041    16.640     0.200
     4.121    16.302     0.200
     4.422    17.586     0.200
     4.975    19.134     0.200
     5.644    19.930     0.200
     5.644    19.634     0.200
     5.909    20.147     0.200
     6.484    21.029     0.200
     6.851    22.947     0.200
     6.851    22.345     0.200
     6.871    22.311     0.200
     6.947    23.531     0.200
     7.107    22.560     0.200
     7.193    20.741     0.200
     7.899    22.759     0.200
     7.899    20.813     0.200
     7.844    22.763     0.200
     7.844    25.364     0.200
     7.960    26.510     0.200
     7.960    24.307     0.200
     8.364    26.387     0.200
     8.845    26.076     0.200
     9.942    28.976     0.200
    10.932    32.820     0.200
    11.006    30.303     0.200
    11.189    31.724     0.200
    11.311    34.201     0.200
    11.464    31.442     0.200
    11.490    32.512     0.200
    18.071    40.786     0.200
    19.143    43.705     0.200
     2.451    12.794     0.200
     2.595    12.820     0.200
     2.692    13.684     0.200
     2.876    14.144     0.200
     2.876    14.246     0.200
     3.636    15.867     0.200
     4.033    16.637     0.200
     4.033    16.934     0.200
     4.117    16.654     0.200
     4.415    17.582     0.200
     4.415    17.481     0.200
     4.968    19.427     0.200
     5.637    19.823     0.200
     5.637    19.721     0.200
     5.915    20.179     0.200
     6.476    22.125     0.200
     6.843    22.537     0.200
     6.864    23.500     0.200
     7.100    22.749     0.200
     7.480    22.608     0.200
     7.838    22.630     0.200
     7.838    23.427     0.200
     7.952    26.006     0.200
     7.952    25.303     0.200
     7.906    23.261     0.200
     7.906    22.441     0.200
     7.906    22.949     0.200
     8.357    25.575     0.200
     8.424    24.187     0.200
     8.837    27.173     0.200
     9.934    26.370     0.200
     9.934    26.128     0.200
    11.011    29.597     0.200
    11.303    31.994     0.200
    11.457    31.746     0.200
    11.457    29.668     0.200
    15.671    35.219     0.200
    19.135    41.173     0.200
    19.820    40.826     0.200
    20.289    40.230     0.200
    21.078    43.015     0.200
     1.845    11.992     0.200
     2.604    12.533     0.200
     2.453    12.794     0.200
     2.708    13.719     0.200
     2.892    14.569     0.200
     2.892    14.069     0.200
     3.621    14.258     0.200
     4.122    16.317     0.200
     4.122    16.217     0.200
     4.049    16.572     0.200
     4.431    17.509     0.200
     4.983    19.170     0.200
     5.653    19.847     0.200
     5.905    20.505     0.200
     6.493    21.649     0.200
     6.860    22.566     0.200
     6.860    22.666     0.200
     6.880    22.625     0.200
     6.956    23.146     0.200
     7.199    21.229     0.200
     7.890    20.635     0.200
     7.890    20.750     0.200
     7.486    21.256     0.200
     7.886    25.291     0.200
     7.852    22.883     0.200
     7.968    24.828     0.200
     7.968    25.328     0.200
     8.420    24.456     0.200
     8.854    26.695     0.200
     9.951    27.410     0.200
    11.004    29.894     0.200
    11.004    30.101     0.200
    11.198    30.539     0.200
    11.319    33.425     0.200
    11.498    31.435     0.200
    11.473    31.747     0.200
    15.196    39.696     0.200
    16.169    41.722     0.200
    17.276    36.348     0.200
    17.276    39.434     0.200
    18.062    37.341     0.200
    19.149    42.310     0.200
    19.149    42.350     0.200
     2.444    13.167     0.200
     2.606    13.076     0.200
     2.884    14.427     0.200
     3.626    14.671     0.200
     4.043    17.002     0.200
     4.424    17.564     0.200
     4.978    18.195     0.200
     6.852    23.422     0.200
     6.872    24.093     0.200
     1.866    11.257     0.200
     2.480    12.092     0.200
     2.576    12.476     0.200
     2.881    13.016     0.200
     3.640    14.755     0.200
     4.093    15.678     0.200
     4.965    18.897     0.200
     6.872    22.839     0.200
     7.860    24.107     0.200
     1.464    11.652     0.200
     1.842    11.948     0.200
     2.455    12.695     0.200
     2.605    12.341     0.200
     2.896    13.946     0.200
     3.618    14.416     0.200
     4.052    16.854     0.200
     4.122    16.737     0.200
     5.657    19.723     0.200
     6.864    22.944     0.200
     6.884    23.600     0.200
     6.960    23.522     0.200
     7.856    25.456     0.200
     1.847    11.379     0.200
     2.434    13.435     0.200
     2.611    12.670     0.200
     2.701    13.122     0.200
     2.881    14.224     0.200
     3.627    15.920     0.200
     3.702    16.545     0.200
     4.042    16.764     0.200
     4.420    18.056     0.200
     6.867    23.100     0.200
     2.696    12.787     0.200
     2.881    13.528     0.200
     4.037    15.344     0.200
     4.114    16.444     0.200
     4.420    16.874     0.200
     4.971    18.543     0.200
     1.836    12.041     0.200
     2.447    12.911     0.200
     2.613    12.679     0.200
     2.613    13.179     0.200
     2.716    14.278     0.200
     2.899    14.140     0.200
     3.613    16.103     0.200
     3.613    16.001     0.200
     4.130    16.473     0.200
     4.057    17.028     0.200
     4.438    17.577     0.200
     4.991    19.323     0.200
     5.659    20.227     0.200
     5.897    20.254     0.200
     6.499    23.024     0.200
     6.867    22.934     0.200
     6.867    23.137     0.200
     6.887    23.904     0.200
     6.962    23.817     0.200
     7.195    20.431     0.200
     7.887    22.124     0.200
     7.854    23.011     0.200
     7.854    23.112     0.200
     7.891    25.973     0.200
     7.975    26.202     0.200
     8.379    26.984     0.200
     8.412    24.893     0.200
     8.860    26.968     0.200
    10.996    28.866     0.200
    10.996    31.245     0.200
    11.326    34.690     0.200
    11.477    31.749     0.200
    18.056    42.129     0.200
    19.158    42.797     0.200
     2.448    13.392     0.200
     2.609    12.726     0.200
     2.894    14.594     0.200
     3.618    16.444     0.200
     4.052    17.585     0.200
     4.127    16.605     0.200
     4.433    17.433     0.200
     4.986    19.880     0.200
     5.655    20.679     0.200
     6.494    22.676     0.200
     6.862    23.591     0.200
     6.882    23.254     0.200
     1.456    11.804     0.200
     2.448    12.733     0.200
     2.448    12.834     0.200
     2.604    12.311     0.200
     2.604    12.710     0.200
     2.702    13.862     0.200
     2.885    14.226     0.200
     3.626    16.276     0.200
     3.626    15.979     0.200
     4.043    16.611     0.200
     4.043    16.509     0.200
     4.124    15.769     0.200
     4.424    17.562     0.200
     4.978    18.808     0.200
     5.437    16.547     0.200
     5.646    19.808     0.200
     5.646    19.512     0.200
     6.486    21.508     0.200
     6.853    22.618     0.200
     6.853    22.118     0.200
     6.873    22.282     0.200
     6.949    22.704     0.200
     7.109    23.532     0.200
     7.192    21.095     0.200
     7.479    21.944     0.200
     7.479    22.913     0.200
     7.899    21.449     0.200
     7.899    24.418     0.200
     7.844    22.658     0.200
     7.844    23.057     0.200
     7.878    24.552     0.200
     7.962    24.785     0.200
     7.962    24.386     0.200
     8.184    25.786     0.200
     8.418    25.359     0.200
     8.366    25.665     0.200
     8.847    26.851     0.200
     9.487    28.089     0.200
     9.944    28.289     0.200
     9.944    31.047     0.200
    10.431    29.368     0.200
    11.003    29.712     0.200
    11.003    30.493     0.200
    10.934    31.893     0.200
    11.190    30.315     0.200
    11.313    32.379     0.200
    11.465    31.821     0.200
    11.465    30.618     0.200
    11.492    32.180     0.200
    13.725    37.231     0.200
    14.405    33.288     0.200
    15.193    39.468     0.200
    19.146    41.867     0.200
    19.146    42.469     0.200
    19.651    41.766     0.200
    20.285    40.917     0.200
     1.450    11.641     0.200
     2.444    13.344     0.200
     2.602    13.405     0.200
     2.696    13.406     0.200
     2.878    14.680     0.200
     3.632    16.174     0.200
     4.037    17.154     0.200
     4.125    16.428     0.200
     4.417    17.921     0.200
     4.972    19.146     0.200
     5.638    19.868     0.200
     6.846    23.478     0.200
     2.466    13.423     0.200
     2.586    12.618     0.200
     1.853    12.696     0.200
     2.442    12.422     0.200
     2.442    13.223     0.200
     2.603    13.242     0.200
     2.696    13.756     0.200
     2.878    14.336     0.200
     4.126    16.567     0.200
     4.038    17.003     0.200
     4.417    17.873     0.200
     4.417    17.674     0.200
     4.972    19.096     0.200
     5.638    19.128     0.200
     6.478    21.727     0.200
     6.846    22.833     0.200
     7.834    23.294     0.200
     7.834    22.994     0.200
     8.358    25.787     0.200
    11.002    29.623     0.200
    15.677    37.069     0.200
    19.142    41.867     0.200
     2.449    12.894     0.200
     2.449    12.996     0.200
     2.599    12.954     0.200
     2.696    13.813     0.200
     2.880    14.076     0.200
     3.632    15.490     0.200
     4.037    17.764     0.200
     4.037    16.664     0.200
     4.120    16.294     0.200
     4.419    17.515     0.200
     4.419    17.314     0.200
     4.972    18.660     0.200
     5.640    19.657     0.200
     5.911    22.101     0.200
     6.480    20.959     0.200
     6.847    22.571     0.200
     6.868    22.535     0.200
     6.943    23.054     0.200
     7.840    22.884     0.200
     7.840    24.684     0.200
     7.903    23.118     0.200
     8.361    25.311     0.200
     8.421    25.902     0.200
     9.481    28.940     0.200
    10.928    30.746     0.200
    11.007    32.516     0.200
    11.185    32.948     0.200
    11.307    32.528     0.200
    13.719    35.781     0.200
    14.017    38.832     0.200
    15.197    38.237     0.200
    15.197    39.335     0.200
    15.484    37.275     0.200
    16.169    38.791     0.200
    17.289    37.312     0.200
    17.289    38.716     0.200
    17.289    38.507     0.200
    19.140    41.688     0.200
    19.140    43.770     0.200
    19.140    41.268     0.200
    19.816    41.348     0.200
    20.287    42.279     0.200
     1.251    10.328     0.200
     2.445    12.891     0.200
     2.481    12.075     0.200
     2.665    13.422     0.200
     3.833    15.994     0.200
     3.834    16.083     0.200
     4.205    16.757     0.200
     1.247    10.766     0.200
     2.050    12.402     0.200
     2.439    12.958     0.200
     2.439    13.160     0.200
     2.482    12.752     0.200
     2.487    12.899     0.200
     2.659    14.090     0.200
     2.659    13.690     0.200
     3.837    14.646     0.200
     3.837    16.447     0.200
     3.830    16.327     0.200
     4.199    16.421     0.200
     4.199    17.021     0.200
     4.766    18.799     0.200
     5.419    19.388     0.200
     6.646    21.764     0.200
     7.735    23.860     0.200
     9.717    30.490     0.200
    11.101    28.691     0.200
     2.458    13.183     0.200
     2.602    12.895     0.200
     2.895    15.078     0.200
     4.119    15.598     0.200
     2.431    13.712     0.200
     2.614    13.467     0.200
     2.881    14.951     0.200
     3.625    16.672     0.200
     4.044    16.687     0.200
     4.138    18.281     0.200
     4.421    18.585     0.200
     4.979    19.376     0.200
     6.480    23.354     0.200
     6.849    24.045     0.200
     6.867    23.233     0.200
     2.439    12.815     0.200
     2.439    13.015     0.200
     2.485    13.082     0.200
     2.481    12.319     0.200
     2.657    13.472     0.200
     2.657    13.573     0.200
     3.490    14.851     0.200
     3.828    16.108     0.200
     3.839    16.074     0.200
     4.061    15.985     0.200
     4.196    16.902     0.200
     4.764    17.879     0.200
     5.237    18.457     0.200
     5.416    19.168     0.200
     6.043    20.354     0.200
     6.256    20.770     0.200
     6.625    21.267     0.200
     6.644    21.747     0.200
     6.720    21.059     0.200
     6.879    21.797     0.200
     7.115    20.846     0.200
     7.401    21.318     0.200
     7.401    21.005     0.200
     7.454    22.887     0.200
     7.651    22.085     0.200
     7.650    23.603     0.200
     7.732    23.440     0.200
     7.955    24.246     0.200
     8.071    24.986     0.200
     8.137    24.618     0.200
     8.115    23.090     0.200
     8.115    23.371     0.200
     8.115    22.941     0.200
     8.115    23.738     0.200
     8.484    24.272     0.200
     8.617    25.413     0.200
     9.009    26.146     0.200
     9.074    26.479     0.200
     9.074    26.683     0.200
     9.257    26.548     0.200
     9.715    27.072     0.200
     9.715    28.104     0.200
    10.704    30.159     0.200
    10.704    31.757     0.200
    10.973    30.117     0.200
    10.973    31.117     0.200
    10.973    30.840     0.200
    11.086    30.905     0.200
    11.102    30.260     0.200
    11.102    29.815     0.200
    11.246    30.994     0.200
    11.270    30.851     0.200
    11.270    31.054     0.200
    12.352    35.726     0.200
    12.383    32.066     0.200
    15.244    36.874     0.200
    15.245    38.088     0.200
    15.245    37.783     0.200
    17.512    39.541     0.200
    18.955    41.392     0.200
    18.955    41.966     0.200
    19.436    42.763     0.200
    19.939    43.037     0.200
    19.937    41.708     0.200
    20.265    42.055     0.200
    20.377    40.477     0.200
    20.869    41.241     0.200
     0.943    10.757     0.200
     2.441    13.484     0.200
     2.611    13.397     0.200
     2.889    14.956     0.200
     3.621    15.810     0.200
     4.048    17.123     0.200
     4.132    17.349     0.200
     4.428    17.692     0.200
     1.846    12.858     0.200
     2.443    13.492     0.200
     2.886    14.524     0.200
     4.129    17.418     0.200
     4.425    17.659     0.200
     2.455    12.860     0.200
     2.896    14.411     0.200
     4.052    16.827     0.200
     1.841    12.039     0.200
     2.444    13.203     0.200
     2.611    12.755     0.200
     2.611    13.255     0.200
     2.710    13.901     0.200
     2.892    14.273     0.200
     3.619    16.191     0.200
     4.130    17.124     0.200
     4.051    16.950     0.200
     4.051    16.751     0.200
     4.431    17.811     0.200
     4.431    17.510     0.200
     4.985    18.744     0.200
     5.652    19.865     0.200
     5.898    20.290     0.200
     6.492    21.364     0.200
     6.860    22.368     0.200
     6.860    22.469     0.200
     6.879    22.240     0.200
     7.190    20.941     0.200
     7.477    23.961     0.200
     7.894    23.611     0.200
     7.847    24.753     0.200
     7.884    25.015     0.200
     8.412    25.256     0.200
     8.372    26.221     0.200
     9.951    30.298     0.200
    10.996    32.137     0.200
    10.996    32.797     0.200
    11.470    31.274     0.200
     1.459    12.056     0.200
     2.451    12.969     0.200
     2.451    13.171     0.200
     2.603    13.002     0.200
     2.705    14.310     0.200
     3.624    16.489     0.200
     4.046    16.961     0.200
     4.428    17.604     0.200
     4.980    19.759     0.200
     5.650    20.743     0.200
     5.650    19.743     0.200
     6.857    22.262     0.200
     7.196    21.695     0.200
     7.484    22.042     0.200
     7.849    22.980     0.200
     7.849    22.781     0.200
     8.370    25.897     0.200
     8.420    25.118     0.200
    11.004    31.500     0.200
    11.004    31.957     0.200
    11.195    29.638     0.200
    18.065    39.062     0.200
    19.147    42.644     0.200
    20.289    42.202     0.200
     2.266    13.555     0.200
     2.322    13.198     0.200
     2.538    12.581     0.200
     3.666    16.019     0.200
     3.973    16.934     0.200
     4.016    16.632     0.200
     4.607    17.941     0.200
     5.161    18.771     0.200
     5.161    19.373     0.200
     6.396    21.863     0.200
     6.396    21.363     0.200
     6.480    22.281     0.200
     6.856    20.721     0.200
     7.141    20.970     0.200
     7.141    22.271     0.200
     7.334    22.913     0.200
     7.334    22.616     0.200
     7.492    24.470     0.200
     8.385    26.254     0.200
    10.448    32.977     0.200
    10.946    31.022     0.200
    11.048    31.390     0.200
    11.048    32.671     0.200
    18.572    43.562     0.200
    18.703    41.660     0.200
    18.854    42.151     0.200
     1.126    10.344     0.200
     1.394    12.218     0.200
     2.209    12.011     0.200
     2.292    12.733     0.200
     2.292    12.835     0.200
     2.325    12.753     0.200
     2.519    12.194     0.200
     2.519    12.796     0.200
     3.345    15.755     0.200
     3.669    15.568     0.200
     4.009    16.999     0.200
     3.984    16.592     0.200
     3.984    16.388     0.200
     4.609    18.592     0.200
     4.950    18.525     0.200
     5.177    18.775     0.200
     6.068    22.074     0.200
     6.019    20.542     0.200
     6.408    21.512     0.200
     6.408    21.309     0.200
     6.405    21.234     0.200
     6.493    21.604     0.200
     6.638    21.615     0.200
     6.887    20.201     0.200
     7.173    20.789     0.200
     7.173    20.383     0.200
     7.363    21.660     0.200
     7.363    21.956     0.200
     7.398    24.356     0.200
     7.506    23.893     0.200
     7.712    23.785     0.200
     7.764    25.079     0.200
     7.887    24.441     0.200
     8.394    22.596     0.200
     8.394    23.010     0.200
     8.394    22.229     0.200
     8.394    23.189     0.200
     8.406    25.090     0.200
     8.385    26.732     0.200
     8.778    27.851     0.200
     8.854    26.664     0.200
     8.854    27.164     0.200
     9.489    28.267     0.200
     9.489    28.634     0.200
     9.489    28.845     0.200
     9.989    29.713     0.200
    10.464    33.371     0.200
    10.464    31.574     0.200
    10.694    31.426     0.200
    10.694    31.285     0.200
    10.694    32.598     0.200
    10.694    30.785     0.200
    10.877    31.149     0.200
    10.877    34.251     0.200
    11.066    31.442     0.200
    11.066    30.348     0.200
    10.962    31.266     0.200
    10.962    31.155     0.200
    10.970    31.728     0.200
    10.970    31.384     0.200
    11.083    31.147     0.200
    12.212    33.874     0.200
    12.424    35.699     0.200
    13.629    36.541     0.200
    13.470    34.995     0.200
    13.922    38.222     0.200
    13.922    36.276     0.200
    14.734    39.342     0.200
    15.132    39.292     0.200
    15.145    39.736     0.200
    15.145    38.048     0.200
    15.145    38.297     0.200
    15.145    38.750     0.200
    15.164    39.329     0.200
    16.265    41.374     0.200
    16.345    41.445     0.200
    16.345    40.242     0.200
    17.738    38.157     0.200
    17.738    39.594     0.200
    18.851    43.800     0.200
    19.036    44.238     0.200
    19.775    44.308     0.200
    19.938    42.896     0.200
    19.937    43.099     0.200
    19.937    42.927     0.200
    20.085    43.229     0.200
     1.404    12.173     0.200
     2.213    13.231     0.200
     2.276    12.897     0.200
     2.531    12.826     0.200
     3.666    15.471     0.200
     1.125    10.317     0.200
     2.214    13.313     0.200
     2.284    12.898     0.200
     2.436    13.721     0.200
     2.524    12.391     0.200
     3.665    15.578     0.200
     3.977    17.234     0.200
     4.015    17.196     0.200
     7.350    23.870     0.200
     1.793    12.659     0.200
     1.682    11.853     0.200
     1.784    12.268     0.200
     2.828    13.283     0.200
     2.862    13.882     0.200
     3.094    13.078     0.200
     3.587    14.921     0.200
     4.162    16.711     0.200
     4.390    17.254     0.200
     6.520    19.616     0.200
     6.791    21.726     0.200
     6.791    21.927     0.200
     7.366    22.618     0.200
     7.840    24.592     0.200
     7.864    25.412     0.200
     9.223    27.047     0.200
    10.487    27.292     0.200
    10.487    29.800     0.200
    10.778    31.705     0.200
    10.831    28.686     0.200
    11.271    30.749     0.200
    19.385    42.712     0.200
     2.219    13.053     0.200
     2.280    13.241     0.200
     2.526    13.163     0.200
     3.661    16.021     0.200
     3.971    17.498     0.200
     4.020    16.333     0.200
     1.404    12.011     0.200
     2.291    12.760     0.200
     2.291    12.860     0.200
     2.517    12.823     0.200
     2.517    13.122     0.200
     3.661    16.075     0.200
     3.975    16.512     0.200
     4.018    17.501     0.200
     6.398    22.031     0.200
     6.882    20.231     0.200
     7.167    21.556     0.200
     7.496    24.719     0.200
     8.405    21.714     0.200
     8.844    27.388     0.200
     9.480    27.118     0.200
    10.684    31.416     0.200
    10.959    29.206     0.200
    11.068    29.617     0.200
    11.068    29.930     0.200
    18.844    42.344     0.200
    19.261    42.615     0.200
     1.395    11.260     0.200
     2.298    11.927     0.200
     2.513    12.113     0.200
     2.513    11.813     0.200
     2.440    12.562     0.200
     3.665    15.365     0.200
     3.665    14.666     0.200
     4.012    15.817     0.200
     3.982    15.972     0.200
     5.175    18.244     0.200
     6.406    20.988     0.200
     6.892    19.184     0.200
     7.177    19.183     0.200
     7.177    19.382     0.200
     7.365    21.493     0.200
     7.504    22.870     0.200
     8.393    21.583     0.200
    11.071    27.809     0.200
    11.071    30.742     0.200
    18.554    40.120     0.200
    18.671    41.152     0.200
     2.435    13.717     0.200
     2.869    15.455     0.200
     4.030    16.898     0.200
     4.408    17.888     0.200
     1.132    12.107     0.200
     2.287    13.016     0.200
     2.447    14.053     0.200
     3.674    16.040     0.200
     4.005    16.679     0.200
     6.884    20.426     0.200
    10.972    31.251     0.200
     2.219    12.851     0.200
     2.294    12.866     0.200
     2.433    12.555     0.200
     3.659    15.936     0.200
     3.974    16.668     0.200
     1.391    11.943     0.200
     2.204    12.663     0.200
     2.330    12.788     0.200
     2.330    12.085     0.200
     2.283    12.735     0.200
     2.527    12.990     0.200
     3.674    15.799     0.200
     4.005    16.446     0.200
     4.005    16.649     0.200
     3.988    16.446     0.200
     4.615    17.822     0.200
     5.179    18.739     0.200
     5.179    18.841     0.200
     6.059    19.770     0.200
     6.411    21.862     0.200
     6.641    23.182     0.200
     6.880    20.016     0.200
     7.165    20.166     0.200
     7.165    21.666     0.200
     7.360    22.990     0.200
     7.509    24.553     0.200
     8.395    21.353     0.200
     8.395    22.783     0.200
     8.395    22.619     0.200
     8.397    24.890     0.200
     8.857    25.625     0.200
     9.492    29.622     0.200
     9.492    25.208     0.200
    10.693    33.684     0.200
    10.693    30.887     0.200
    11.057    30.645     0.200
    11.057    30.450     0.200
    10.969    32.279     0.200
    17.735    39.121     0.200
    18.858    43.268     0.200
    18.858    41.322     0.200
     1.404    12.002     0.200
     2.257    14.049     0.200
     2.275    13.363     0.200
     2.314    12.899     0.200
     3.658    16.119     0.200
     3.967    17.415     0.200
     1.111    10.191     0.200
     1.399    11.719     0.200
     2.220    11.743     0.200
     2.220    13.443     0.200
     2.499    12.485     0.200
     3.657    16.079     0.200
     3.976    16.850     0.200
     4.020    15.638     0.200
     6.904    20.178     0.200
     7.189    20.353     0.200
     8.426    25.525     0.200
     8.392    23.712     0.200
     9.483    26.285     0.200
    10.459    29.393     0.200
    10.696    28.529     0.200
    10.971    28.956     0.200
    11.085    29.959     0.200
    11.085    30.691     0.200
    18.836    41.711     0.200
     1.109    10.390     0.200
     1.413    11.731     0.200
     2.298    13.310     0.200
     2.306    12.515     0.200
     2.508    13.061     0.200
     3.650    16.135     0.200
     3.964    17.065     0.200
     7.348    24.665     0.200
     1.110    10.450     0.200
     1.414    12.401     0.200
     2.294    13.437     0.200
     2.511    13.604     0.200
     3.650    16.206     0.200
     3.964    16.850     0.200
     4.029    16.788     0.200
     7.346    23.886     0.200
     1.129    10.765     0.200
     1.406    11.931     0.200
     2.274    13.496     0.200
     3.666    16.058     0.200
     2.059    11.799     0.200
     2.722    13.060     0.200
     2.939    13.421     0.200
     2.939    14.023     0.200
     3.275    14.697     0.200
     3.880    16.042     0.200
     4.507    16.727     0.200
     4.507    17.027     0.200
     5.704    19.959     0.200
     6.814    23.208     0.200
     6.991    20.262     0.200
     6.980    20.164     0.200
    11.634    31.695     0.200
    18.139    38.239     0.200
     2.201    12.769     0.200
     2.275    12.904     0.200
     2.334    12.712     0.200
     2.535    12.065     0.200
     2.535    12.667     0.200
     3.355    15.499     0.200
     3.678    15.728     0.200
     4.002    16.951     0.200
     4.619    18.250     0.200
     4.619    17.652     0.200
     4.943    18.066     0.200
     5.179    18.709     0.200
     6.022    20.371     0.200
     6.412    21.022     0.200
     6.408    21.073     0.200
     6.497    21.628     0.200
     6.641    21.555     0.200
     6.872    20.333     0.200
     7.157    20.483     0.200
     7.356    21.812     0.200
     7.356    24.515     0.200
     7.399    23.209     0.200
     7.510    23.116     0.200
     7.510    24.417     0.200
     7.767    25.418     0.200
     7.889    24.296     0.200
     8.397    22.365     0.200
     8.397    22.857     0.200
     8.389    25.156     0.200
     8.388    25.759     0.200
     8.781    26.076     0.200
     8.858    28.182     0.200
     8.858    27.381     0.200
     9.032    27.454     0.200
     9.493    26.958     0.200
     9.493    29.267     0.200
     9.493    29.427     0.200
     9.994    30.619     0.200
    10.466    32.010     0.200
    10.466    31.612     0.200
    10.691    30.703     0.200
    10.691    30.891     0.200
    10.691    30.992     0.200
    10.691    31.203     0.200
    10.691    32.391     0.200
    10.883    32.554     0.200
    10.883    32.953     0.200
    10.967    29.850     0.200
    10.967    31.381     0.200
    11.090    31.032     0.200
    12.194    35.345     0.200
    12.410    35.432     0.200
    13.301    37.030     0.200
    13.453    35.060     0.200
    13.904    37.592     0.200
    15.128    40.292     0.200
    15.128    38.914     0.200
    15.128    38.264     0.200
    15.128    40.303     0.200
    15.729    40.598     0.200
    16.053    38.721     0.200
    16.252    42.893     0.200
    16.332    41.254     0.200
    16.399    42.673     0.200
    17.734    41.243     0.200
    17.734    39.598     0.200
    17.734    36.977     0.200
    17.602    43.635     0.200
    18.553    41.996     0.200
    18.553    41.847     0.200
    18.863    43.728     0.200
    19.039    44.584     0.200
    19.023    44.856     0.200
    19.759    44.730     0.200
    19.759    44.172     0.200
    19.923    43.754     0.200
    19.923    43.152     0.200
    19.921    43.577     0.200
    20.027    45.044     0.200
     1.110     9.742     0.200
     1.421    12.417     0.200
     2.287    13.904     0.200
     1.391    11.491     0.200
     2.208    12.951     0.200
     2.299    12.792     0.200
     2.513    12.993     0.200
     3.669    16.107     0.200
     4.009    16.743     0.200
     3.986    17.006     0.200
     4.609    18.331     0.200
     5.180    18.473     0.200
     6.022    20.741     0.200
     6.410    21.920     0.200
     7.370    23.118     0.200
    10.975    31.280     0.200
     1.396    11.816     0.200
     2.297    13.301     0.200
     2.514    13.363     0.200
     3.666    16.124     0.200
     3.982    16.735     0.200
     4.012    16.983     0.200
     5.175    19.110     0.200
     6.406    22.052     0.200
     6.891    20.512     0.200
     7.364    23.566     0.200
     1.129     9.757     0.200
     2.220    12.029     0.200
     2.260    13.261     0.200
     2.318    12.883     0.200
     2.541    12.983     0.200
     3.662    16.011     0.200
     3.967    16.553     0.200
     4.022    16.709     0.200
     4.603    17.928     0.200
     5.153    18.705     0.200
     6.389    21.380     0.200
     7.324    24.672     0.200
     1.092    10.153     0.200
     2.504    12.377     0.200
     3.628    15.959     0.200
     3.939    16.631     0.200
     5.130    19.128     0.200
     1.116    10.548     0.200
     2.218    12.684     0.200
     2.300    13.926     0.200
     2.509    12.587     0.200
     3.659    16.367     0.200
     3.976    16.773     0.200
     4.019    17.373     0.200
     6.399    22.587     0.200
     7.361    23.768     0.200
     1.141    10.452     0.200
     1.387    11.977     0.200
     2.198    12.717     0.200
     2.198    12.819     0.200
     2.276    12.906     0.200
     2.337    12.990     0.200
     2.337    12.888     0.200
     2.536    12.573     0.200
     3.681    16.006     0.200
     3.998    16.701     0.200
     3.993    16.666     0.200
     3.993    16.564     0.200
     4.622    18.328     0.200
     4.947    18.331     0.200
     5.183    19.277     0.200
     6.026    20.837     0.200
     6.412    22.738     0.200
     6.416    21.987     0.200
     6.501    22.396     0.200
     6.645    22.021     0.200
     6.874    20.442     0.200
     7.159    20.255     0.200
     7.360    22.379     0.200
     7.403    23.374     0.200
     7.513    24.385     0.200
     7.513    23.885     0.200
     7.719    25.990     0.200
     7.893    25.058     0.200
     8.393    22.045     0.200
     8.393    22.725     0.200
     8.393    22.213     0.200
     8.389    24.966     0.200
     8.785    27.043     0.200
     9.497    25.332     0.200
    10.470    33.379     0.200
    10.695    29.187     0.200
    10.695    31.554     0.200
    10.695    29.554     0.200
    10.695    32.015     0.200
    10.695    30.155     0.200
    10.886    33.223     0.200
    10.886    33.621     0.200
    10.963    30.426     0.200
    10.964    30.620     0.200
    10.971    31.587     0.200
    10.971    30.865     0.200
    11.049    31.820     0.200
    11.049    30.527     0.200
    11.093    31.903     0.200
    15.115    38.373     0.200
    15.128    38.023     0.200
    15.128    38.510     0.200
    15.147    38.504     0.200
    16.104    37.328     0.200
    17.730    40.971     0.200
    17.730    40.655     0.200
    17.730    39.951     0.200
    18.045    40.884     0.200
    18.549    41.129     0.200
    18.865    43.418     0.200
    18.865    42.457     0.200
    19.282    42.051     0.200
    19.760    42.964     0.200
    19.760    44.221     0.200
    20.069    42.904     0.200
    20.069    42.506     0.200
    20.591    43.064     0.200
     1.143    10.046     0.200
     1.381    11.375     0.200
     2.280    12.484     0.200
     2.341    12.265     0.200
     2.534    12.813     0.200
     3.685    15.080     0.200
     3.999    16.324     0.200
     4.626    17.505     0.200
     7.367    23.410     0.200
     1.391    12.278     0.200
     2.291    13.365     0.200
     2.328    12.240     0.200
     2.521    12.788     0.200
     3.672    15.555     0.200
     3.987    16.672     0.200
     4.006    17.052     0.200
     4.613    18.078     0.200
     5.180    19.255     0.200
     5.180    19.154     0.200
     6.411    22.092     0.200
     6.888    20.755     0.200
     7.365    23.651     0.200
     7.365    22.456     0.200
     8.392    25.048     0.200
     8.392    25.173     0.200
    10.697    28.872     0.200
    11.063    31.889     0.200
    11.063    31.296     0.200
    20.084    42.869     0.200
     1.381    11.863     0.200
     2.278    12.804     0.200
     2.536    12.587     0.200
     3.685    16.078     0.200
     3.994    16.877     0.200
     3.998    16.621     0.200
     4.626    18.101     0.200
     5.189    19.227     0.200
     7.366    23.325     0.200
     1.099    10.657     0.200
     1.434    12.751     0.200
     3.635    16.360     0.200
     3.946    17.335     0.200
     4.045    16.770     0.200
     4.576    18.580     0.200
     5.137    20.033     0.200
     7.326    24.186     0.200
     2.236    13.507     0.200
     2.291    12.972     0.200
     3.643    16.395     0.200
     3.643    16.195     0.200
     3.955    16.858     0.200
     3.955    16.757     0.200
     4.037    17.190     0.200
     4.584    18.916     0.200
     4.921    17.183     0.200
     5.146    19.252     0.200
     6.873    21.369     0.200
     8.425    24.181     0.200
     8.425    24.388     0.200
    10.939    29.831     0.200
    11.075    30.625     0.200
    11.075    31.054     0.200
    18.828    43.631     0.200
     1.098    10.593     0.200
     2.295    13.834     0.200
     3.948    17.240     0.200
     5.140    18.633     0.200
     5.982    21.697     0.200
     2.267    13.910     0.200
     3.693    16.364     0.200
     3.987    16.634     0.200
     4.004    17.137     0.200
     4.634    18.385     0.200
     7.363    22.435     0.200
     2.273    13.729     0.200
     3.992    16.763     0.200
     2.282    13.364     0.200
     3.684    16.097     0.200
     3.995    18.075     0.200
     3.998    17.233     0.200
     7.368    23.803     0.200
     1.118    11.732     0.200
     2.232    14.037     0.200
     2.267    13.819     0.200
     2.307    13.561     0.200
     2.532    12.928     0.200
     3.650    16.085     0.200
     3.956    16.917     0.200
     4.033    17.914     0.200
     4.033    17.614     0.200
     4.591    18.203     0.200
     4.905    18.433     0.200
     4.905    18.233     0.200
     5.143    19.061     0.200
     5.143    19.261     0.200
     5.986    21.421     0.200
     6.067    21.872     0.200
     6.372    23.122     0.200
     6.462    22.467     0.200
     6.849    21.073     0.200
     7.134    20.883     0.200
     7.134    21.023     0.200
     7.318    23.975     0.200
     7.361    23.772     0.200
     7.474    23.756     0.200
     7.474    23.456     0.200
     7.678    24.278     0.200
     7.851    24.855     0.200
     8.390    26.072     0.200
     8.436    24.462     0.200
     8.436    23.210     0.200
     8.436    24.130     0.200
     8.436    26.630     0.200
     8.745    26.219     0.200
     8.996    27.294     0.200
     9.458    26.637     0.200
     9.458    27.095     0.200
     9.458    28.005     0.200
     9.458    25.815     0.200
     9.960    30.846     0.200
    10.430    32.065     0.200
    10.430    31.065     0.200
    10.652    30.149     0.200
    10.652    32.669     0.200
    10.652    30.869     0.200
    10.652    29.549     0.200
    10.652    31.169     0.200
    10.920    31.041     0.200
    10.921    31.032     0.200
    10.928    30.258     0.200
    10.928    30.998     0.200
    11.058    33.131     0.200
    11.056    31.579     0.200
    11.056    32.362     0.200
    13.268    37.547     0.200
    15.112    40.721     0.200
    15.125    38.707     0.200
    15.125    39.559     0.200
    15.144    40.752     0.200
    16.141    39.411     0.200
    18.061    41.307     0.200
    18.590    42.004     0.200
    18.590    42.629     0.200
    18.840    41.695     0.200
    18.840    42.160     0.200
    19.249    43.249     0.200
    19.742    42.890     0.200
    19.934    41.895     0.200
    19.934    42.655     0.200
    19.932    42.903     0.200
    20.026    42.576     0.200
    20.053    42.829     0.200
     1.113    10.141     0.200
     3.650    16.038     0.200
     3.960    16.613     0.200
     5.150    19.028     0.200
     7.334    24.741     0.200
     1.123    10.578     0.200
     3.657    15.609     0.200
     3.964    16.928     0.200
     1.090     9.837     0.200
     2.301    13.108     0.200
     3.628    15.422     0.200
     3.941    16.570     0.200
     5.133    19.153     0.200
     2.280    13.211     0.200
     3.679    15.684     0.200
     3.991    16.935     0.200
     7.361    22.512     0.200
     1.103    10.047     0.200
     1.420    11.944     0.200
     2.235    13.331     0.200
     2.300    13.969     0.200
     3.643    16.196     0.200
     3.958    17.229     0.200
     5.151    19.205     0.200
     7.344    24.108     0.200
     1.114    10.435     0.200
     2.267    13.975     0.200
     3.644    16.203     0.200
     3.949    17.047     0.200
     7.312    23.903     0.200
     1.090    10.461     0.200
     2.299    13.650     0.200
     3.627    16.057     0.200
     3.939    16.415     0.200
     7.325    24.590     0.200
     3.643    16.876     0.200
     3.940    17.516     0.200
     6.361    22.663     0.200
     7.283    23.099     0.200
     3.663    17.680     0.200
     3.949    17.339     0.200
     4.031    16.183     0.200
     1.122    10.469     0.200
     2.275    13.911     0.200
     2.529    13.651     0.200
     3.657    15.176     0.200
     1.124    10.156     0.200
     1.408    12.344     0.200
     2.218    13.187     0.200
     2.280    12.957     0.200
     2.526    12.692     0.200
     3.662    16.037     0.200
     3.973    16.506     0.200
     4.019    16.772     0.200
     6.396    21.730     0.200
     1.423    12.643     0.200
     2.272    13.629     0.200
     2.529    13.037     0.200
     3.652    15.832     0.200
     3.959    16.948     0.200
     5.147    18.877     0.200
     6.381    22.278     0.200
     6.609    22.025     0.200
     7.325    23.062     0.200
     8.430    24.286     0.200
    10.934    30.470     0.200
    18.840    41.317     0.200
     1.090     9.683     0.200
     1.435    11.868     0.200
     2.249    12.860     0.200
     2.497    12.872     0.200
     2.497    12.372     0.200
     3.629    15.858     0.200
     3.943    16.789     0.200
     3.943    16.891     0.200
     4.050    16.948     0.200
     4.050    15.448     0.200
     4.570    17.576     0.200
     5.136    18.967     0.200
     5.136    19.272     0.200
     5.979    20.337     0.200
     6.367    21.412     0.200
     6.367    21.709     0.200
     6.882    21.251     0.200
    10.933    30.959     0.200
     1.122    10.284     0.200
     1.436    12.425     0.200
     2.252    14.105     0.200
     2.545    13.284     0.200
     3.649    16.695     0.200
     3.950    17.286     0.200
     5.134    19.061     0.200
     7.302    23.673     0.200
     1.103    10.592     0.200
     2.246    14.168     0.200
     2.277    13.800     0.200
     3.636    16.449     0.200
     3.942    17.064     0.200
     4.047    16.044     0.200
     5.131    19.499     0.200
     6.365    21.793     0.200
     7.313    24.432     0.200
     2.289    12.981     0.200
     2.289    12.083     0.200
     2.511    11.992     0.200
     3.638    15.842     0.200
     3.638    15.342     0.200
     3.949    16.522     0.200
     4.043    18.517     0.200
     4.579    18.066     0.200
     5.139    18.626     0.200
     5.982    20.586     0.200
     6.372    21.245     0.200
     6.869    20.714     0.200
     7.327    22.684     0.200
     7.849    24.797     0.200
     8.411    24.039     0.200
     9.453    26.585     0.200
    10.656    27.939     0.200
    10.931    29.469     0.200
    11.076    32.085     0.200
    11.076    31.538     0.200
    15.147    37.434     0.200
    18.825    42.442     0.200
    19.238    41.293     0.200
     1.111    10.508     0.200
     1.434    12.346     0.200
     2.271    14.371     0.200
     3.643    16.463     0.200
     3.949    17.394     0.200
     4.040    17.932     0.200
     5.137    19.432     0.200
     6.371    21.226     0.200
     7.315    23.318     0.200
     1.100    10.501     0.200
     2.277    13.666     0.200
     3.632    15.859     0.200
     3.938    16.988     0.200
     5.126    19.120     0.200
     6.361    21.514     0.200
     7.309    23.649     0.200
     1.108    10.369     0.200
     2.279    13.497     0.200
     2.239    13.473     0.200
     3.642    16.097     0.200
     3.950    16.899     0.200
     4.040    16.351     0.200
     5.139    19.122     0.200
     5.982    20.483     0.200
     6.373    20.926     0.200
     6.860    21.070     0.200
    10.928    31.128     0.200
     1.443    11.788     0.200
     2.279    13.632     0.200
     3.631    16.055     0.200
     3.938    16.674     0.200
     5.127    18.602     0.200
     7.311    24.817     0.200
     1.106    10.153     0.200
     1.435    11.807     0.200
     2.278    13.278     0.200
     2.520    13.545     0.200
     3.639    15.594     0.200
     3.946    16.507     0.200
     5.135    19.435     0.200
     7.317    23.670     0.200
     1.123    10.367     0.200
     1.400    11.139     0.200
     2.289    13.963     0.200
     2.519    12.676     0.200
     3.665    16.613     0.200
     3.979    16.949     0.200
     4.014    16.333     0.200
     7.356    23.838     0.200
     2.285    12.629     0.200
     2.282    13.856     0.200
     3.628    16.552     0.200
     3.935    17.161     0.200
     4.054    17.475     0.200
     5.124    19.487     0.200
     1.108    10.333     0.200
     1.431    12.662     0.200
     2.280    13.248     0.200
     2.280    13.647     0.200
     2.239    13.734     0.200
     2.519    12.856     0.200
     3.642    16.358     0.200
     3.950    16.958     0.200
     4.040    17.014     0.200
     5.140    19.278     0.200
     6.861    21.495     0.200
    11.068    32.411     0.200
     1.103    10.496     0.200
     2.246    12.951     0.200
     2.519    14.167     0.200
     3.635    16.245     0.200
     3.942    16.963     0.200
     1.102    10.608     0.200
     1.447    12.676     0.200
     2.251    13.198     0.200
     2.288    12.766     0.200
     2.272    14.258     0.200
     2.523    12.721     0.200
     1.103    10.468     0.200
     2.279    14.347     0.200
     3.636    16.213     0.200
     3.943    16.928     0.200
     4.047    17.115     0.200
     6.365    21.656     0.200
     7.315    22.778     0.200
     1.091    10.271     0.200
     1.438    12.319     0.200
     2.300    13.461     0.200
     2.399    13.400     0.200
     3.628    16.059     0.200
     3.941    16.811     0.200
     5.133    19.297     0.200
     5.976    20.863     0.200
     7.328    24.185     0.200
     1.090    10.222     0.200
     2.282    13.203     0.200
     2.297    13.527     0.200
     2.396    13.473     0.200
     2.253    12.642     0.200
     2.253    14.341     0.200
     2.501    12.852     0.200
     3.626    16.022     0.200
     3.938    16.886     0.200
     4.054    16.926     0.200
     4.567    18.642     0.200
     4.909    16.954     0.200
     5.129    19.077     0.200
     5.972    21.043     0.200
     6.098    21.578     0.200
     6.358    21.639     0.200
     6.361    22.106     0.200
     6.873    20.856     0.200
     7.158    21.108     0.200
     7.323    22.575     0.200
     7.351    23.756     0.200
     7.459    24.094     0.200
     7.840    24.746     0.200
     8.421    25.465     0.200
     8.439    24.324     0.200
     8.439    25.315     0.200
     8.439    25.154     0.200
     9.442    28.445     0.200
    10.831    29.343     0.200
    10.924    30.852     0.200
    10.924    30.612     0.200
    11.038    31.429     0.200
    11.087    31.845     0.200
    11.087    31.052     0.200
    12.215    36.684     0.200
    15.156    40.636     0.200
    16.128    36.219     0.200
    18.091    40.213     0.200
    18.600    43.000     0.200
    18.812    41.370     0.200
    18.812    41.095     0.200
    19.226    42.170     0.200
    20.545    44.674     0.200
     1.432    12.205     0.200
     2.308    13.279     0.200
     2.404    13.263     0.200
     3.630    16.053     0.200
     3.945    16.675     0.200
     4.049    15.967     0.200
     4.571    16.976     0.200
     5.139    19.043     0.200
     5.982    20.710     0.200
     6.369    21.790     0.200
     7.338    21.980     0.200
     2.298    12.922     0.200
     3.652    15.526     0.200
     3.966    16.446     0.200
     5.159    18.627     0.200
     1.452    12.208     0.200
     2.451    13.047     0.200
     2.599    13.227     0.200
     3.630    16.386     0.200
     3.630    16.085     0.200
     4.039    16.917     0.200
     4.039    16.718     0.200
     4.421    17.559     0.200
     5.911    20.477     0.200
     7.194    20.422     0.200
     7.843    22.824     0.200
     7.843    22.621     0.200
     7.958    24.580     0.200
     7.900    20.372     0.200
     8.363    25.455     0.200
     8.422    25.267     0.200
     9.941    29.015     0.200
    11.008    29.763     0.200
    11.008    28.794     0.200
    11.188    31.087     0.200
    11.463    30.056     0.200
    13.721    35.629     0.200
    18.072    39.657     0.200
    18.562    40.640     0.200
    19.141    40.683     0.200
     1.103    10.045     0.200
     3.639    16.750     0.200
     3.949    17.031     0.200
     7.326    23.824     0.200
     2.045    12.520     0.200
     2.452    12.776     0.200
     2.477    12.375     0.200
     2.494    12.986     0.200
     3.831    16.278     0.200
     3.836    15.916     0.200
     4.209    16.670     0.200
     4.772    18.395     0.200
     5.430    19.113     0.200
     6.637    21.631     0.200
     7.131    20.812     0.200
     7.670    22.176     0.200
     8.152    24.551     0.200
    11.107    29.681     0.200
    11.263    29.439     0.200
     1.142    10.183     0.200
     1.378    11.519     0.200
     2.285    13.039     0.200
     2.341    12.881     0.200
     3.685    15.594     0.200
     4.000    16.917     0.200
     2.259    13.686     0.200
     2.554    12.840     0.200
     3.696    16.316     0.200
     4.004    17.114     0.200
     5.192    19.353     0.200
     6.035    21.512     0.200
     6.427    22.043     0.200
     6.861    21.049     0.200
     7.358    22.180     0.200
     8.391    25.138     0.200
    11.030    32.139     0.200
    10.974    30.710     0.200
     1.443    12.320     0.200
     2.448    13.101     0.200
     2.872    14.649     0.200
     4.411    17.789     0.200
     5.632    19.636     0.200
     1.196    10.544     0.200
     1.196    12.245     0.200
     1.332    12.155     0.200
     2.250    13.846     0.200
     2.509    14.025     0.200
     2.576    13.139     0.200
     3.739    15.869     0.200
     3.941    16.719     0.200
     4.050    17.039     0.200
     4.680    17.892     0.200
     5.238    20.278     0.200
     6.473    22.668     0.200
     1.125     9.969     0.200
     2.293    13.247     0.200
     2.210    12.914     0.200
     2.442    13.404     0.200
     2.518    13.015     0.200
     3.668    16.395     0.200
     3.983    16.716     0.200
     4.010    16.803     0.200
     4.609    18.219     0.200
     5.176    19.198     0.200
     6.407    22.333     0.200
     6.887    20.825     0.200
     7.172    23.499     0.200
     7.216    24.286     0.200
     7.363    23.381     0.200
     7.505    24.518     0.200
     7.886    25.366     0.200
     8.406    26.199     0.200
    10.969    31.094     0.200
    11.066    31.452     0.200
    18.554    41.630     0.200
    18.850    41.912     0.200
    20.085    41.913     0.200
     2.315    12.557     0.200
     2.286    12.899     0.200
     2.220    12.176     0.200
     2.430    13.017     0.200
     2.520    12.268     0.200
     3.659    15.773     0.200
     3.972    16.428     0.200
     4.020    15.860     0.200
     4.600    17.697     0.200
     5.163    18.727     0.200
     6.006    20.191     0.200
     6.391    21.990     0.200
     6.395    20.849     0.200
     6.876    20.189     0.200
     7.161    22.711     0.200
     7.347    23.237     0.200
     7.492    22.942     0.200
     7.873    24.403     0.200
     8.403    25.514     0.200
     8.410    22.278     0.200
    10.954    30.892     0.200
    11.065    29.565     0.200
    18.844    42.370     0.200
     1.425    12.461     0.200
     2.281    13.573     0.200
     2.414    13.515     0.200
     3.646    16.036     0.200
     3.956    17.228     0.200
     4.035    17.106     0.200
     5.145    19.543     0.200
     7.328    23.772     0.200
     2.199    12.638     0.200
     2.884    14.148     0.200
     4.100    16.564     0.200
     4.425    17.462     0.200
     6.848    22.884     0.200
     1.112    10.692     0.200
     2.304    13.184     0.200
     2.304    13.084     0.200
     3.656    16.705     0.200
     3.973    16.803     0.200
     3.973    16.703     0.200
     5.168    18.966     0.200
     6.397    20.616     0.200
     7.361    23.364     0.200
     1.091     9.886     0.200
     2.241    11.761     0.200
     2.486    12.502     0.200
     3.635    15.594     0.200
     3.955    16.167     0.200
     4.576    18.217     0.200
     5.151    18.510     0.200
     6.379    21.177     0.200
     6.903    19.841     0.200
    11.099    30.240     0.200
    10.952    29.650     0.200
     1.091    10.290     0.200
     2.289    13.408     0.200
     3.625    16.124     0.200
     3.934    16.719     0.200
     5.124    18.829     0.200
     2.443    13.543     0.200
     2.596    12.959     0.200
     4.028    16.753     0.200
     4.407    17.723     0.200
     5.628    20.171     0.200
     6.836    23.077     0.200
     1.444    12.177     0.200
     2.440    13.551     0.200
     2.870    14.430     0.200
     4.030    16.887     0.200
     4.409    17.466     0.200
     6.838    23.426     0.200
     1.104    10.106     0.200
     2.293    13.531     0.200
     2.298    13.070     0.200
     2.412    13.433     0.200
     2.509    13.599     0.200
     3.642    15.888     0.200
     3.954    16.647     0.200
     4.361    16.919     0.200
     4.921    16.059     0.200
     6.377    21.467     0.200
     6.377    21.768     0.200
     6.875    20.867     0.200
     7.335    21.788     0.200
     7.335    22.288     0.200
    10.938    30.794     0.200
    11.077    32.282     0.200
     0.948    10.561     0.200
     1.450    11.893     0.200
     2.138    12.674     0.200
     2.200    13.050     0.200
     2.429    13.475     0.200
     2.723    13.940     0.200
     3.535    16.163     0.200
     3.938    16.139     0.200
     3.958    16.933     0.200
     4.466    17.897     0.200
     5.215    19.963     0.200
     6.048    21.242     0.200
     6.387    21.684     0.200
     7.312    22.019     0.200
     7.469    24.561     0.200
     7.506    24.719     0.200
     7.596    21.786     0.200
     7.596    21.677     0.200
     7.632    22.753     0.200
     8.235    22.306     0.200
     8.235    22.085     0.200
     8.235    22.415     0.200
     7.951    25.827     0.200
     8.810    27.203     0.200
     9.034    28.397     0.200
     9.486    28.011     0.200
     9.486    28.638     0.200
     9.486    28.318     0.200
    10.499    32.800     0.200
    10.499    31.700     0.200
    10.834    31.687     0.200
    10.834    31.288     0.200
    10.870    30.809     0.200
    10.870    30.969     0.200
    10.870    29.369     0.200
    10.995    31.206     0.200
    10.995    30.606     0.200
    11.124    32.500     0.200
    11.125    32.387     0.200
    11.132    31.748     0.200
    11.132    31.418     0.200
    11.443    31.403     0.200
    11.443    31.885     0.200
    12.643    32.075     0.200
    12.855    37.101     0.200
    15.548    40.170     0.200
    15.561    40.279     0.200
    15.561    42.338     0.200
    15.580    40.501     0.200
    16.726    43.026     0.200
    17.750    38.276     0.200
    17.750    40.282     0.200
    18.245    37.973     0.200
    18.245    39.697     0.200
    18.376    41.568     0.200
    20.286    43.145     0.200
    20.284    43.206     0.200
     0.933    10.325     0.200
     2.136    12.492     0.200
     2.412    13.568     0.200
     2.718    14.396     0.200
     2.718    14.197     0.200
     3.521    16.023     0.200
     3.941    16.824     0.200
     3.941    16.217     0.200
     7.614    23.958     0.200
     8.254    25.488     0.200
    18.251    40.280     0.200
     2.140    12.836     0.200
     2.720    13.968     0.200
     3.535    16.156     0.200
     3.956    16.738     0.200
     6.386    21.987     0.200
     2.132    11.819     0.200
     2.132    11.920     0.200
     2.415    13.708     0.200
     2.724    13.805     0.200
     3.522    15.387     0.200
     3.522    14.986     0.200
     3.936    16.362     0.200
     3.944    16.867     0.200
     5.192    18.301     0.200
     5.201    19.096     0.200
     5.201    20.196     0.200
     6.399    22.622     0.200
     6.373    21.815     0.200
     7.307    21.394     0.200
     7.455    23.793     0.200
     7.493    23.052     0.200
     7.591    22.953     0.200
     7.621    22.758     0.200
     7.938    24.661     0.200
     8.248    23.515     0.200
     8.248    22.935     0.200
     8.814    26.133     0.200
     9.472    28.021     0.200
    10.821    31.417     0.200
    10.821    32.417     0.200
    10.857    30.222     0.200
    10.857    29.892     0.200
    10.982    32.033     0.200
    10.982    30.433     0.200
    11.119    32.702     0.200
    11.119    31.214     0.200
    11.448    29.636     0.200
    11.448    30.493     0.200
    12.644    33.441     0.200
    16.005    36.210     0.200
    18.244    37.008     0.200
    18.385    41.054     0.200
     1.462    12.009     0.200
     2.149    12.492     0.200
     2.186    12.955     0.200
     2.376    13.947     0.200
     2.409    13.561     0.200
     2.701    14.146     0.200
     3.523    15.953     0.200
     3.939    17.102     0.200
     5.174    17.897     0.200
     5.193    19.171     0.200
     6.027    21.443     0.200
     6.369    21.648     0.200
     6.384    21.862     0.200
     7.602    25.060     0.200
     2.129    12.662     0.200
     2.184    12.826     0.200
     2.384    13.887     0.200
     2.413    13.748     0.200
     2.726    13.800     0.200
     3.520    16.331     0.200
     3.934    16.180     0.200
     3.942    17.009     0.200
     4.451    18.370     0.200
     5.199    19.235     0.200
     6.032    21.717     0.200
     6.371    21.964     0.200
     6.401    22.108     0.200
     6.478    21.804     0.200
     6.662    23.069     0.200
     7.308    22.223     0.200
     7.453    24.633     0.200
     7.490    24.493     0.200
     7.592    24.111     0.200
     7.620    23.788     0.200
     7.936    26.103     0.200
     8.250    23.423     0.200
     8.772    27.533     0.200
    11.117    32.166     0.200
    11.451    33.121     0.200
    18.243    38.491     0.200
    18.498    40.857     0.200
    18.611    41.587     0.200
    20.521    43.858     0.200
     0.930    10.473     0.200
     2.143    12.515     0.200
     2.706    14.245     0.200
     3.518    16.067     0.200
     3.935    16.906     0.200
     3.952    16.378     0.200
     4.156    17.219     0.200
     7.286    20.876     0.200
    18.615    41.499     0.200
     1.463    12.066     0.200
     2.450    13.248     0.200
     2.607    13.513     0.200
     3.620    16.190     0.200
     4.050    15.271     0.200
     4.432    18.216     0.200
     5.653    20.261     0.200
     6.860    23.374     0.200
     1.101    10.585     0.200
     1.448    13.226     0.200
     2.273    14.000     0.200
     2.394    14.089     0.200
     3.630    15.863     0.200
     3.935    17.307     0.200
     1.091     9.580     0.200
     1.438    10.941     0.200
     2.298    13.295     0.200
     3.629    15.771     0.200
     3.941    16.628     0.200
     4.355    16.523     0.200
     5.133    19.119     0.200
     5.976    20.881     0.200
     7.327    23.515     0.200
    10.928    32.259     0.200
    11.087    30.854     0.200
     2.296    12.035     0.200
     3.894    16.886     0.200
     4.097    16.115     0.200
     4.347    16.421     0.200
     7.288    22.078     0.200
     8.480    25.658     0.200
    10.883    30.443     0.200
    11.110    33.120     0.200
     1.781    12.547     0.200
     2.318    13.881     0.200
     2.563    13.922     0.200
     3.343    15.724     0.200
     3.612    16.477     0.200
     4.366    17.589     0.200
     4.368    16.909     0.200
     4.591    19.259     0.200
     6.732    20.442     0.200
    11.205    29.765     0.200
     1.318    11.225     0.200
     1.980    12.004     0.200
     2.423    13.324     0.200
     2.532    12.456     0.200
     2.559    13.445     0.200
     2.731    13.936     0.200
     3.765    15.162     0.200
     3.901    15.976     0.200
     4.271    17.167     0.200
     4.838    18.350     0.200
     0.995     9.760     0.200
     2.390    13.679     0.200
     2.401    12.546     0.200
     2.330    13.176     0.200
     3.543    15.923     0.200
     3.872    16.187     0.200
     4.263    16.823     0.200
     4.483    16.553     0.200
     6.297    21.676     0.200
     6.940    20.612     0.200
     2.239    12.549     0.200
     2.239    13.149     0.200
     2.291    12.241     0.200
     2.291    12.741     0.200
     2.358    13.259     0.200
     2.425    12.981     0.200
     2.456    12.017     0.200
     2.456    12.117     0.200
     3.635    15.850     0.200
     3.966    16.493     0.200
     4.037    17.262     0.200
     4.297    16.008     0.200
     5.169    18.555     0.200
     5.169    18.755     0.200
     6.011    20.333     0.200
     6.122    21.729     0.200
     6.392    20.987     0.200
     6.948    20.372     0.200
     7.232    20.473     0.200
     8.380    23.786     0.200
     8.470    25.731     0.200
     9.476    25.886     0.200
    10.709    29.802     0.200
    10.982    30.032     0.200
    11.058    29.930     0.200
    11.127    31.017     0.200
    11.127    31.324     0.200
    13.275    34.156     0.200
    15.210    37.476     0.200
    15.210    36.888     0.200
    16.053    36.011     0.200
     0.889     8.928     0.200
     2.110    11.272     0.200
     2.140    11.622     0.200
     2.423    12.221     0.200
     2.367    12.176     0.200
     2.367    12.075     0.200
     2.727    12.569     0.200
     3.131    13.960     0.200
     3.477    14.723     0.200
     3.928    14.225     0.200
     3.896    15.532     0.200
     4.198    16.502     0.200
     4.409    16.547     0.200
     5.153    17.562     0.200
     5.151    17.780     0.200
     5.986    19.342     0.200
     6.325    19.982     0.200
     6.376    20.093     0.200
     6.427    20.391     0.200
     6.432    20.032     0.200
     7.183    22.373     0.200
     7.292    19.593     0.200
     7.407    21.960     0.200
     7.444    22.221     0.200
     7.576    19.281     0.200
     7.581    20.828     0.200
     7.889    23.028     0.200
     8.295    21.081     0.200
     8.295    21.531     0.200
     8.295    21.191     0.200
     8.337    23.900     0.200
     8.726    24.860     0.200
     8.777    25.069     0.200
     8.828    24.272     0.200
     8.972    25.700     0.200
     9.424    25.056     0.200
     9.424    25.385     0.200
     9.424    27.017     0.200
     9.424    24.517     0.200
     9.896    26.911     0.200
    10.437    30.002     0.200
    10.437    29.103     0.200
    10.773    29.279     0.200
    10.811    28.456     0.200
    10.811    28.288     0.200
    10.811    28.729     0.200
    10.935    29.182     0.200
    10.935    29.483     0.200
    11.073    28.895     0.200
    11.073    29.153     0.200
    11.469    30.602     0.200
    11.469    31.059     0.200
    12.647    32.607     0.200
    12.770    34.371     0.200
    13.179    34.394     0.200
    14.356    37.867     0.200
    15.575    38.065     0.200
    16.276    37.859     0.200
    17.811    38.682     0.200
    17.811    36.830     0.200
    18.241    36.672     0.200
     7.292    19.706     0.200
     3.928    15.202     0.200
    15.574    37.902     0.200
     1.900    11.514     0.200
     2.186    12.170     0.200
     2.964    13.501     0.200
     3.475    15.036     0.200
     4.735    18.024     0.200
     5.010    18.321     0.200
     5.083    16.237     0.200
     5.089    18.295     0.200
     5.583    18.827     0.200
     6.767    19.060     0.200
     7.057    18.628     0.200
     7.653    23.480     0.200
     7.714    21.828     0.200
     7.714    21.683     0.200
     7.926    23.788     0.200
    10.201    26.983     0.200
    10.201    27.241     0.200
    11.442    34.157     0.200
    14.322    38.150     0.200
    16.767    37.429     0.200
    17.686    37.992     0.200
     5.083    18.245     0.200
     2.252    12.982     0.200
     2.287    13.179     0.200
     3.628    15.823     0.200
     3.937    16.624     0.200
     5.127    19.034     0.200
     1.461    11.994     0.200
     2.166    12.274     0.200
     2.371    13.582     0.200
     2.403    13.507     0.200
     2.680    14.369     0.200
     2.680    14.169     0.200
     3.524    14.816     0.200
     3.978    16.476     0.200
     4.457    18.031     0.200
     6.364    21.679     0.200
     6.371    20.996     0.200
     7.544    22.104     0.200
     7.584    25.045     0.200
     8.274    22.690     0.200
     8.274    22.108     0.200
    11.413    34.778     0.200
     0.930     9.301     0.200
     2.352    12.596     0.200
     2.449    12.263     0.200
     5.772    20.089     0.200
     6.160    21.159     0.200
     1.637    12.870     0.200
     2.202    13.276     0.200
     2.344    14.020     0.200
     2.442    14.368     0.200
     3.444    15.879     0.200
     4.244    18.039     0.200
     4.934    18.793     0.200
     1.640    13.032     0.200
     2.197    13.422     0.200
     2.355    13.786     0.200
     2.448    14.196     0.200
     3.437    15.854     0.200
     4.307    16.426     0.200
     4.250    17.868     0.200
     4.378    17.869     0.200
     4.931    18.917     0.200
     6.246    21.181     0.200
     7.123    21.138     0.200
     7.172    20.864     0.200
     8.619    21.887     0.200
     9.243    25.899     0.200
    11.201    29.354     0.200
    11.201    32.123     0.200
    12.940    30.655     0.200
    16.243    38.315     0.200
     2.179    13.650     0.200
     2.406    12.398     0.200
     3.420    15.961     0.200
     4.307    16.465     0.200
     6.833    20.680     0.200
    10.724    30.088     0.200
    11.209    32.063     0.200
     2.357    13.868     0.200
     2.180    13.236     0.200
     2.406    12.292     0.200
     3.421    15.848     0.200
     3.721    16.750     0.200
     4.307    16.307     0.200
     4.735    20.120     0.200
     6.257    22.056     0.200
     6.834    20.728     0.200
     7.156    22.464     0.200
    10.200    29.136     0.200
    10.453    31.493     0.200
    10.614    29.409     0.200
    10.725    31.944     0.200
    11.208    32.874     0.200
    12.924    33.159     0.200
     2.189    13.199     0.200
     2.422    12.481     0.200
     3.434    15.972     0.200
     3.730    16.716     0.200
     4.322    16.483     0.200
     6.822    20.431     0.200
     9.233    29.638     0.200
    10.727    30.987     0.200
    11.192    30.679     0.200
     2.180    13.393     0.200
     2.399    12.535     0.200
     2.365    13.642     0.200
     2.365    13.841     0.200
     4.299    17.072     0.200
     4.741    16.708     0.200
     6.145    21.529     0.200
     6.261    21.566     0.200
     6.842    20.963     0.200
     7.125    21.188     0.200
     7.163    22.347     0.200
     7.163    22.148     0.200
     8.590    27.286     0.200
     8.632    26.201     0.200
     8.632    26.451     0.200
     8.632    26.094     0.200
     9.226    29.294     0.200
     9.226    28.487     0.200
    10.202    29.473     0.200
    10.458    30.196     0.200
    10.615    31.762     0.200
    10.729    31.544     0.200
    10.729    31.285     0.200
    11.214    29.867     0.200
    11.214    30.609     0.200
    12.923    35.227     0.200
    15.240    39.778     0.200
     2.208    12.771     0.200
     2.413    12.171     0.200
     2.353    13.271     0.200
     2.353    13.572     0.200
     2.438    12.976     0.200
     3.446    15.317     0.200
     4.308    16.570     0.200
     6.172    21.008     0.200
     6.239    21.822     0.200
     6.844    20.979     0.200
     7.127    21.695     0.200
     8.608    24.973     0.200
     8.608    25.282     0.200
     8.608    23.752     0.200
     8.608    23.920     0.200
     8.618    28.665     0.200
     9.253    30.646     0.200
     9.253    26.866     0.200
     9.253    27.335     0.200
    10.229    32.359     0.200
    10.481    33.723     0.200
    10.481    33.283     0.200
    10.481    29.553     0.200
    10.642    32.742     0.200
    10.753    31.085     0.200
    11.196    32.272     0.200
    11.196    31.167     0.200
    12.950    34.910     0.200
    15.227    41.363     0.200
    15.227    40.115     0.200
    17.974    40.523     0.200
     3.452    15.631     0.200
     3.753    16.515     0.200
     4.314    16.466     0.200
     6.176    21.241     0.200
    10.754    31.825     0.200
    11.189    32.154     0.200
     2.195    13.538     0.200
     2.447    14.395     0.200
     3.443    15.778     0.200
     4.336    16.248     0.200
     6.809    21.368     0.200
     7.148    22.432     0.200
    10.725    31.932     0.200
    11.178    31.843     0.200
     2.445    13.519     0.200
     2.951    15.112     0.200
     3.042    14.144     0.200
     3.214    13.747     0.200
     4.288    16.987     0.200
     5.795    18.321     0.200
     6.705    17.700     0.200
     6.705    21.168     0.200
     8.086    20.983     0.200
    11.012    30.941     0.200
    11.012    31.601     0.200
    11.061    30.565     0.200
    11.061    29.082     0.200
    12.041    33.329     0.200
    12.329    33.967     0.200
    12.384    34.825     0.200
    12.384    32.325     0.200
    12.443    33.134     0.200
    12.656    33.097     0.200
    14.457    38.434     0.200
    14.589    35.832     0.200
    14.589    36.491     0.200
    15.490    36.880     0.200
    16.250    37.183     0.200
    16.250    35.475     0.200
    16.935    38.990     0.200
    18.231    37.988     0.200
    18.231    38.139     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.692    24.439     0.200
     4.634    31.548     0.200
     5.017    34.677     0.200
     7.529    50.961     0.200
     4.742    32.440     0.200
     2.659    18.088     0.200
     4.722    31.518     0.200
     5.119    36.188     0.200
     3.133    21.119     0.200
     4.401    30.326     0.200
     4.534    29.773     0.200
     4.818    31.455     0.200
     5.635    36.621     0.200
     7.293    49.068     0.200
     2.574    17.630     0.200
     2.613    18.368     0.200
     2.820    19.757     0.200
     3.616    24.164     0.200
     3.945    26.129     0.200
     4.886    32.151     0.200
     5.019    34.290     0.200
     5.461    35.938     0.200
     6.112    42.437     0.200
     7.792    52.236     0.200
     2.559    17.204     0.200
     2.814    19.228     0.200
     2.869    19.086     0.200
     3.607    23.969     0.200
     5.132    33.676     0.200
     5.432    35.675     0.200
     7.533    51.156     0.200
     2.600    17.323     0.200
     4.547    30.303     0.200
     6.945    47.218     0.200
     4.631    30.860     0.200
     4.834    32.491     0.200
     5.049    33.079     0.200
     2.676    18.423     0.200
     3.282    22.744     0.200
     3.647    24.288     0.200
     5.612    36.860     0.200
     2.708    18.169     0.200
     3.522    23.073     0.200
     4.246    27.515     0.200
     4.798    32.679     0.200
     5.313    35.068     0.200
     5.474    36.291     0.200
     2.675    17.897     0.200
     4.214    28.149     0.200
     5.285    35.039     0.200
     5.441    35.823     0.200
     2.573    17.937     0.200
     2.684    18.348     0.200
     3.839    26.160     0.200
     4.222    27.897     0.200
     4.775    31.147     0.200
     5.292    35.202     0.200
     5.449    36.572     0.200
     2.574    18.285     0.200
     2.684    17.999     0.200
     3.840    26.212     0.200
     4.222    27.751     0.200
     5.449    36.624     0.200
     2.721    18.831     0.200
     4.259    27.684     0.200
     4.808    31.375     0.200
     5.487    36.646     0.200
     2.572    17.449     0.200
     4.774    32.554     0.200
     5.286    34.679     0.200
     5.446    35.415     0.200
     6.648    43.383     0.200
     2.513    17.186     0.200
     2.590    17.083     0.200
     2.708    17.701     0.200
     4.246    29.158     0.200
     4.792    31.082     0.200
     2.578    17.604     0.200
     4.228    27.850     0.200
     4.780    31.207     0.200
     5.456    36.322     0.200
     2.568    18.004     0.200
     2.679    17.608     0.200
     4.217    27.657     0.200
     5.445    35.728     0.200
     2.591    17.879     0.200
     4.239    28.252     0.200
     4.793    32.582     0.200
     5.301    34.655     0.200
     5.465    37.142     0.200
     2.586    17.896     0.200
     2.696    18.808     0.200
     4.234    27.955     0.200
     4.787    31.798     0.200
     5.461    36.437     0.200
     3.334    22.720     0.200
     3.979    26.186     0.200
     4.489    30.235     0.200
     3.528    23.346     0.200
     4.804    32.448     0.200
     2.715    17.930     0.200
     3.867    25.486     0.200
     4.253    27.783     0.200
     4.803    31.372     0.200
     5.323    34.496     0.200
     5.482    36.645     0.200
     2.560    17.052     0.200
     2.526    16.441     0.200
     2.680    17.643     0.200
     3.485    22.453     0.200
     3.827    24.566     0.200
     4.217    28.408     0.200
     4.762    31.757     0.200
     5.309    34.170     0.200
     5.450    35.528     0.200
     5.604    37.126     0.200
     7.726    51.764     0.200
     4.207    27.792     0.200
     5.439    35.518     0.200
     2.592    18.707     0.200
     3.857    26.041     0.200
     4.235    28.328     0.200
     2.635    18.104     0.200
     2.738    18.506     0.200
     3.900    25.641     0.200
     4.277    28.247     0.200
     5.316    35.223     0.200
     5.499    35.881     0.200
     6.004    40.588     0.200
     2.505    16.872     0.200
     2.688    18.538     0.200
     4.348    29.371     0.200
     5.577    36.924     0.200
     7.819    52.762     0.200
     9.227    62.126     0.200
     2.633    18.209     0.200
     2.638    17.753     0.200
     2.699    18.641     0.200
     2.699    20.641     0.200
     3.878    27.184     0.200
     5.355    35.644     0.200
     2.649    18.198     0.200
     4.851    32.000     0.200
     5.346    35.615     0.200
     5.523    36.257     0.200
     5.515    37.255     0.200
     6.727    45.313     0.200
     2.633    18.114     0.200
     3.171    21.598     0.200
     3.500    23.866     0.200
     3.841    25.082     0.200
     3.841    26.883     0.200
     7.341    49.733     0.200
     3.011    20.138     0.200
     3.233    21.251     0.200
     3.953    28.953     0.200
     4.284    27.891     0.200
     4.755    31.390     0.200
     5.202    34.073     0.200
     6.023    40.098     0.200
     7.183    48.061     0.200
     2.659    17.904     0.200
     2.692    18.221     0.200
     4.234    29.631     0.200
     4.852    31.913     0.200
     5.406    35.344     0.200
     3.295    22.530     0.200
     3.945    27.152     0.200
     4.209    28.368     0.200
     4.945    32.569     0.200
     3.133    21.054     0.200
     3.459    24.147     0.200
     3.792    25.263     0.200
     4.400    28.764     0.200
     4.865    31.947     0.200
     5.002    32.544     0.200
     6.218    40.650     0.200
     3.735    24.335     0.200
     4.092    28.473     0.200
     4.343    29.338     0.200
     6.324    40.924     0.200
     3.365    23.056     0.200
     3.680    25.280     0.200
     4.307    29.357     0.200
     4.883    31.944     0.200
     3.652    25.389     0.200
     4.290    28.339     0.200
     3.894    26.226     0.200
     5.107    34.270     0.200
     7.426    49.808     0.200
     2.745    21.484     0.200
     3.964    27.750     0.200
     4.906    32.562     0.200
     5.126    34.692     0.200
     5.449    36.430     0.200
     6.692    44.924     0.200
     8.034    56.263     0.200
     3.069    20.295     0.200
     5.195    34.489     0.200
     5.169    34.286     0.200
     2.621    17.379     0.200
     5.062    32.889     0.200
     6.584    43.129     0.200
     7.466    50.931     0.200
     4.622    30.661     0.200
     5.205    35.563     0.200
     5.205    33.864     0.200
     5.164    34.235     0.200
     5.514    36.054     0.200
     5.667    37.977     0.200
     2.595    17.302     0.200
     3.570    24.876     0.200
     3.953    27.615     0.200
     5.099    34.737     0.200
     5.187    34.307     0.200
     5.234    34.585     0.200
     5.000    32.695     0.200
     3.472    24.079     0.200
     3.639    24.140     0.200
     4.471    30.423     0.200
     4.471    29.124     0.200
     4.813    31.428     0.200
     5.295    34.409     0.200
     5.748    37.519     0.200
     5.748    38.019     0.200
     6.375    42.606     0.200
     2.539    17.048     0.200
     2.663    18.100     0.200
     2.895    19.295     0.200
     4.722    31.372     0.200
     5.677    37.523     0.200
     2.661    17.702     0.200
     3.223    21.644     0.200
     3.593    23.724     0.200
     4.162    28.886     0.200
     3.662    24.784     0.200
     3.919    27.479     0.200
     4.343    28.937     0.200
     5.144    33.982     0.200
     6.084    41.222     0.200
     6.612    43.351     0.200
     3.002    20.241     0.200
     3.002    20.441     0.200
     3.313    22.406     0.200
     3.945    27.539     0.200
     3.945    26.239     0.200
     4.164    27.073     0.200
     4.833    31.958     0.200
     4.826    31.645     0.200
     3.169    20.889     0.200
     4.706    30.540     0.200
     5.934    39.418     0.200
     2.504    16.750     0.200
     3.542    24.346     0.200
     4.351    29.396     0.200
     4.750    31.142     0.200
     4.527    30.675     0.200
     2.823    19.480     0.200
     4.533    30.024     0.200
     4.839    33.047     0.200
     4.853    33.190     0.200
     5.046    33.836     0.200
     5.782    38.139     0.200
     6.127    40.619     0.200
     7.434    49.867     0.200
     7.725    51.376     0.200
     8.079    53.742     0.200
     4.891    32.507     0.200
     5.132    34.995     0.200
     3.354    22.468     0.200
     3.883    25.793     0.200
     4.280    28.254     0.200
     5.158    34.310     0.200
     5.717    38.692     0.200
     2.881    19.200     0.200
     3.350    22.628     0.200
     3.887    26.558     0.200
     4.224    27.823     0.200
     5.203    34.306     0.200
     2.530    16.918     0.200
     2.704    18.282     0.200
     3.219    22.070     0.200
     4.984    33.076     0.200
     5.915    39.106     0.200
     3.829    26.328     0.200
     3.829    26.628     0.200
     4.389    29.299     0.200
     5.003    33.924     0.200
     2.598    17.292     0.200
     3.596    24.054     0.200
     3.596    24.452     0.200
     4.327    28.416     0.200
     5.386    35.458     0.200
     2.684    17.997     0.200
     3.500    23.173     0.200
     3.500    23.275     0.200
     3.840    25.101     0.200
     3.840    25.304     0.200
     3.828    26.846     0.200
     4.092    27.170     0.200
     4.222    28.443     0.200
     4.222    28.045     0.200
     4.776    31.083     0.200
     4.776    32.383     0.200
     5.291    34.975     0.200
     5.449    36.225     0.200
     6.064    39.359     0.200
     6.651    43.199     0.200
     8.039    54.002     0.200
     3.502    23.948     0.200
     3.826    26.056     0.200
     3.826    25.857     0.200
     3.843    25.468     0.200
     4.229    27.764     0.200
     5.306    34.695     0.200
     5.582    36.472     0.200
     6.071    42.064     0.200
     3.507    23.260     0.200
     3.848    25.379     0.200
     4.233    29.090     0.200
     4.784    31.963     0.200
     4.784    31.666     0.200
     5.306    34.768     0.200
     5.462    36.253     0.200
     3.939    26.205     0.200
     4.076    27.104     0.200
     5.286    34.786     0.200
     2.687    17.825     0.200
     3.505    23.275     0.200
     4.225    28.171     0.200
     4.781    31.386     0.200
     5.288    35.565     0.200
     5.451    35.464     0.200
     2.661    17.693     0.200
     4.200    27.637     0.200
     4.757    31.033     0.200
     5.266    34.993     0.200
     5.426    35.833     0.200
     4.193    27.813     0.200
     2.626    17.622     0.200
     4.166    27.654     0.200
     2.646    17.954     0.200
     3.468    23.351     0.200
     3.807    25.196     0.200
     4.744    32.067     0.200
     5.250    34.658     0.200
     5.409    35.700     0.200
     6.078    40.302     0.200
     3.992    26.295     0.200
     4.800    30.969     0.200
     4.800    31.168     0.200
     5.335    34.622     0.200
     7.499    51.168     0.200
     2.502    17.048     0.200
     2.502    16.946     0.200
     2.689    18.564     0.200
     3.844    25.395     0.200
     4.005    26.411     0.200
     4.227    28.215     0.200
     4.779    31.477     0.200
     5.298    34.817     0.200
     5.298    34.715     0.200
     5.455    35.886     0.200
     2.674    17.801     0.200
     4.095    27.425     0.200
     2.500    17.066     0.200
     2.500    16.566     0.200
     2.687    17.684     0.200
     3.499    23.301     0.200
     3.840    25.424     0.200
     3.829    26.555     0.200
     3.829    25.455     0.200
     4.225    28.536     0.200
     4.225    27.936     0.200
     4.468    29.401     0.200
     4.776    32.007     0.200
     4.776    31.007     0.200
     5.299    34.797     0.200
     5.299    34.697     0.200
     5.453    35.699     0.200
     5.453    35.399     0.200
     7.490    50.233     0.200
     2.667    17.694     0.200
     3.484    23.065     0.200
     3.484    22.964     0.200
     3.824    25.496     0.200
     4.760    31.773     0.200
     5.277    34.731     0.200
     5.277    34.434     0.200
     5.432    35.822     0.200
     7.693    51.341     0.200
     3.833    25.413     0.200
     2.643    17.919     0.200
     3.881    25.871     0.200
     3.927    27.135     0.200
     4.184    27.839     0.200
     2.668    17.862     0.200
     3.484    23.931     0.200
     4.206    27.510     0.200
     4.488    29.322     0.200
     4.760    31.642     0.200
     5.278    34.903     0.200
     5.278    36.003     0.200
     5.433    35.888     0.200
     6.635    43.465     0.200
     2.504    16.714     0.200
     2.504    16.815     0.200
     3.491    23.600     0.200
     3.491    24.002     0.200
     3.837    26.060     0.200
     3.832    25.525     0.200
     4.767    32.108     0.200
     4.767    31.007     0.200
     5.296    36.142     0.200
     5.446    35.383     0.200
     2.495    17.244     0.200
     3.875    25.531     0.200
     2.637    18.003     0.200
     3.747    24.940     0.200
     4.172    28.481     0.200
     3.789    25.100     0.200
     4.732    31.396     0.200
     5.219    34.109     0.200
     4.570    30.736     0.200
     3.451    22.729     0.200
     3.878    26.345     0.200
     4.215    27.712     0.200
     4.571    29.865     0.200
     5.153    33.771     0.200
     5.477    35.793     0.200
     5.772    37.740     0.200
     2.640    17.779     0.200
     2.640    18.083     0.200
     3.249    22.369     0.200
     4.442    29.652     0.200
     3.866    27.771     0.200
     5.478    36.161     0.200
     7.874    53.497     0.200
     2.590    17.873     0.200
     2.590    17.674     0.200
     3.116    22.737     0.200
     3.437    23.192     0.200
     6.091    42.415     0.200
     2.534    16.895     0.200
     3.816    25.238     0.200
     4.759    32.132     0.200
     3.509    23.134     0.200
     4.073    26.851     0.200
     4.762    32.207     0.200
     4.850    32.586     0.200
     4.501    30.087     0.200
     5.098    33.923     0.200
     3.236    23.026     0.200
     3.236    21.326     0.200
     3.897    25.417     0.200
     6.188    40.080     0.200
     3.884    25.753     0.200
     3.231    22.447     0.200
     3.888    26.480     0.200
     4.499    29.654     0.200
     4.499    30.955     0.200
     5.094    33.414     0.200
     5.094    34.016     0.200
     5.935    39.296     0.200
     6.314    41.370     0.200
     6.314    41.171     0.200
     7.810    51.809     0.200
     2.527    17.030     0.200
     3.288    23.350     0.200
     4.566    30.132     0.200
     4.566    30.234     0.200
     5.274    34.975     0.200
     5.312    35.038     0.200
     3.235    21.671     0.200
     3.895    25.864     0.200
     4.503    30.372     0.200
     4.935    32.128     0.200
     5.102    33.780     0.200
     5.102    33.476     0.200
     6.321    41.348     0.200
     2.813    20.885     0.200
     3.436    23.409     0.200
     3.893    25.876     0.200
     3.893    26.376     0.200
     4.231    27.739     0.200
     4.586    29.990     0.200
     5.488    36.668     0.200
     5.787    37.777     0.200
     2.769    18.814     0.200
     2.769    18.713     0.200
     3.005    20.256     0.200
     3.005    19.951     0.200
     3.606    24.542     0.200
     3.745    24.718     0.200
     4.141    27.297     0.200
     4.535    30.600     0.200
     4.535    30.404     0.200
     5.024    33.597     0.200
     5.024    34.097     0.200
     5.670    37.155     0.200
     3.013    20.293     0.200
     3.013    20.793     0.200
     3.605    24.781     0.200
     4.101    27.086     0.200
     5.027    33.181     0.200
     5.027    33.481     0.200
     3.231    22.338     0.200
     4.499    30.036     0.200
     4.937    32.326     0.200
     5.101    33.417     0.200
     6.319    41.098     0.200
     2.541    16.912     0.200
     2.541    17.213     0.200
     3.563    24.092     0.200
     3.563    24.992     0.200
     3.800    25.121     0.200
     3.918    26.346     0.200
     3.885    25.735     0.200
     4.183    28.153     0.200
     4.183    28.952     0.200
     4.827    33.339     0.200
     5.043    33.219     0.200
     5.358    35.639     0.200
     7.695    52.366     0.200
     7.943    53.574     0.200
     5.355    34.923     0.200
     7.462    50.532     0.200
     2.536    17.168     0.200
     2.640    17.744     0.200
     3.557    23.753     0.200
     3.557    24.050     0.200
     3.927    25.928     0.200
     4.821    31.994     0.200
     4.821    33.096     0.200
     5.358    35.029     0.200
     2.540    17.266     0.200
     2.540    17.067     0.200
     4.185    27.867     0.200
     4.826    32.296     0.200
     4.826    33.093     0.200
     2.544    17.211     0.200
     3.565    25.695     0.200
     3.918    27.081     0.200
     4.189    27.622     0.200
     4.575    30.613     0.200
     4.830    32.537     0.200
     4.830    32.938     0.200
     6.210    40.839     0.200
     6.609    43.378     0.200
     7.454    50.617     0.200
     4.969    32.835     0.200
     5.125    33.108     0.200
     2.554    17.089     0.200
     3.556    23.999     0.200
     3.773    26.168     0.200
     4.275    28.208     0.200
     5.499    35.925     0.200
     4.916    32.721     0.200
     2.527    16.893     0.200
     2.683    19.679     0.200
     4.813    32.619     0.200
     5.356    35.284     0.200
     5.356    34.883     0.200
     3.481    22.849     0.200
     4.755    31.773     0.200
     5.403    35.208     0.200
     6.047    39.505     0.200
     3.851    25.457     0.200
     3.865    26.190     0.200
     4.179    27.821     0.200
     4.754    32.016     0.200
     4.754    32.719     0.200
     5.396    35.319     0.200
     5.396    35.420     0.200
     4.176    27.980     0.200
     4.749    32.191     0.200
     5.212    34.288     0.200
     5.394    35.366     0.200
     5.394    35.569     0.200
     6.234    40.767     0.200
     7.432    49.785     0.200
     3.856    26.053     0.200
     4.178    27.885     0.200
     4.749    32.428     0.200
     4.749    31.334     0.200
     5.221    34.322     0.200
     5.398    35.452     0.200
     5.398    35.257     0.200
     6.238    40.551     0.200
     2.701    17.928     0.200
     4.987    33.253     0.200
     2.698    18.083     0.200
     3.783    24.817     0.200
     4.984    33.213     0.200
     4.984    33.408     0.200
     2.819    18.581     0.200
     5.254    34.970     0.200
     6.930    46.212     0.200
     8.125    54.168     0.200
     2.547    17.334     0.200
     3.548    24.351     0.200
     3.780    25.942     0.200
     3.888    25.577     0.200
     4.269    29.443     0.200
     4.269    29.138     0.200
     4.824    31.757     0.200
     5.493    36.251     0.200
     4.633    31.140     0.200
     5.458    36.315     0.200
     5.839    38.668     0.200
     2.885    19.423     0.200
     3.673    24.322     0.200
     3.319    21.610     0.200
     3.388    22.507     0.200
     4.330    28.009     0.200
     4.330    29.909     0.200
     2.681    18.125     0.200
     3.683    24.338     0.200
     3.811    25.241     0.200
     4.002    27.916     0.200
     4.183    27.507     0.200
     4.183    28.507     0.200
     4.943    33.035     0.200
     4.943    33.235     0.200
     3.497    24.200     0.200
     4.170    27.948     0.200
     5.108    34.001     0.200
     5.037    32.488     0.200
     5.037    32.589     0.200
     5.147    33.197     0.200
     5.540    35.921     0.200
     7.582    50.890     0.200
     3.508    23.166     0.200
     3.746    25.193     0.200
     5.723    37.414     0.200
     3.580    23.523     0.200
     5.107    34.994     0.200
     2.682    18.639     0.200
     2.682    18.439     0.200
     3.894    26.589     0.200
     3.894    26.689     0.200
     4.731    32.330     0.200
     4.731    31.730     0.200
     2.743    19.273     0.200
     3.578    24.027     0.200
     4.412    29.790     0.200
     5.028    33.606     0.200
     5.277    36.296     0.200
     5.598    36.851     0.200
     3.417    22.490     0.200
     3.912    25.715     0.200
     5.187    35.426     0.200
     2.776    21.564     0.200
     3.456    23.223     0.200
     3.872    26.973     0.200
     5.148    34.288     0.200
     5.781    37.995     0.200
     5.781    37.694     0.200
     7.001    46.254     0.200
     7.898    52.789     0.200
     2.778    19.126     0.200
     2.866    19.090     0.200
     3.871    27.169     0.200
     3.871    25.770     0.200
     4.572    30.388     0.200
     5.146    34.586     0.200
     5.146    33.686     0.200
     5.778    37.713     0.200
     2.760    20.013     0.200
     3.722    24.890     0.200
     3.722    24.593     0.200
     4.375    29.762     0.200
     4.991    33.775     0.200
     3.724    24.534     0.200
     4.380    30.878     0.200
     4.994    33.613     0.200
     5.567    37.019     0.200
     5.567    36.419     0.200
     2.710    18.456     0.200
     2.926    19.692     0.200
     3.549    23.526     0.200
     3.997    26.634     0.200
     3.997    27.134     0.200
     4.295    28.955     0.200
     5.467    36.383     0.200
     4.607    30.936     0.200
     6.055    40.242     0.200
     3.946    26.232     0.200
     4.199    28.377     0.200
     4.587    30.454     0.200
     5.131    33.801     0.200
     2.502    16.781     0.200
     2.753    18.373     0.200
     3.542    23.461     0.200
     3.784    25.846     0.200
     3.790    27.176     0.200
     4.124    27.569     0.200
     4.472    30.413     0.200
     5.063    35.717     0.200
     5.671    37.321     0.200
     5.760    37.688     0.200
     2.502    16.758     0.200
     2.502    16.859     0.200
     3.504    23.070     0.200
     4.780    32.180     0.200
     5.452    35.440     0.200
     3.499    24.517     0.200
     3.829    25.260     0.200
     3.829    25.159     0.200
     4.775    32.025     0.200
     2.684    17.882     0.200
     3.839    25.601     0.200
     4.222    29.033     0.200
     4.222    28.130     0.200
     4.775    31.885     0.200
     5.450    36.803     0.200
     6.651    43.284     0.200
     2.794    18.890     0.200
     4.490    30.097     0.200
     2.932    19.619     0.200
     2.561    17.145     0.200
     3.595    24.981     0.200
     3.978    26.708     0.200
     4.531    31.052     0.200
     5.213    34.699     0.200
     3.673    24.243     0.200
     4.324    28.146     0.200
     5.513    36.071     0.200
     2.866    18.900     0.200
     4.844    31.520     0.200
     5.115    33.752     0.200
     7.531    49.960     0.200
     2.552    17.263     0.200
     3.365    22.477     0.200
     6.105    40.599     0.200
     6.442    42.864     0.200
     8.763    61.577     0.200
     2.565    17.455     0.200
     4.224    28.295     0.200
     4.224    29.592     0.200
     4.850    32.780     0.200
     5.408    35.470     0.200
     3.389    22.722     0.200
     5.220    34.050     0.200
     6.452    42.171     0.200
     7.440    49.246     0.200
     3.884    25.991     0.200
     3.914    25.942     0.200
     4.206    28.326     0.200
     4.856    32.644     0.200
     2.633    17.687     0.200
     2.506    16.663     0.200
     3.629    24.058     0.200
     4.364    28.978     0.200
     4.906    31.953     0.200
     5.594    37.029     0.200
     4.108    28.947     0.200
     3.885    25.754     0.200
     4.515    30.102     0.200
     4.515    31.102     0.200
     4.874    32.006     0.200
     5.078    33.521     0.200
     6.308    41.371     0.200
     2.609    17.755     0.200
     2.655    18.019     0.200
     3.804    26.204     0.200
     4.543    30.481     0.200
     4.895    32.472     0.200
     4.888    33.365     0.200
     5.323    35.384     0.200
     7.979    55.790     0.200
     2.615    17.564     0.200
     2.739    18.213     0.200
     3.632    24.095     0.200
     3.881    25.783     0.200
     4.900    31.986     0.200
     4.900    33.892     0.200
     5.467    35.876     0.200
     2.507    16.923     0.200
     4.049    26.937     0.200
     4.648    30.742     0.200
     2.592    17.069     0.200
     3.217    21.082     0.200
     5.265    34.775     0.200
     5.987    39.546     0.200
     2.841    20.503     0.200
     2.841    21.704     0.200
     3.886    26.405     0.200
     5.002    33.084     0.200
     6.285    41.112     0.200
     6.975    45.658     0.200
     3.745    25.479     0.200
     4.970    32.582     0.200
     7.315    48.208     0.200
     2.570    18.055     0.200
     2.570    17.352     0.200
     2.622    17.849     0.200
     3.719    25.044     0.200
     3.613    24.783     0.200
     4.365    29.207     0.200
     4.365    29.309     0.200
     4.891    32.672     0.200
     4.891    32.469     0.200
     5.603    36.556     0.200
     8.143    54.317     0.200
     2.576    18.120     0.200
     3.600    23.866     0.200
     3.981    26.227     0.200
     4.354    28.974     0.200
     5.593    38.212     0.200
     7.056    46.439     0.200
     7.898    52.719     0.200
     2.738    18.385     0.200
     2.805    18.793     0.200
     4.078    27.046     0.200
     4.341    28.676     0.200
     5.021    33.543     0.200
     5.486    35.909     0.200
     2.955    20.207     0.200
     4.021    27.105     0.200
     4.282    29.453     0.200
     4.675    33.070     0.200
     4.907    32.272     0.200
     5.195    34.496     0.200
     6.440    42.373     0.200
     2.616    17.892     0.200
     2.728    18.886     0.200
     2.731    18.448     0.200
     4.272    28.265     0.200
     4.323    28.667     0.200
     6.297    41.530     0.200
     2.788    18.665     0.200
     3.920    26.143     0.200
     5.847    38.356     0.200
     5.840    38.323     0.200
     2.787    18.526     0.200
     3.558    23.631     0.200
     3.793    26.585     0.200
     5.427    35.515     0.200
     6.538    42.854     0.200
     7.827    51.914     0.200
     3.796    25.658     0.200
     4.185    27.620     0.200
     4.415    29.140     0.200
     4.843    32.235     0.200
     2.712    19.391     0.200
     2.937    19.559     0.200
     4.478    29.377     0.200
     4.496    29.600     0.200
     3.192    21.440     0.200
     3.464    23.483     0.200
     4.194    27.658     0.200
     2.598    17.676     0.200
     2.701    18.182     0.200
     3.742    25.122     0.200
     2.599    17.424     0.200
     2.705    18.088     0.200
     3.714    24.815     0.200
     4.246    29.208     0.200
     5.422    35.985     0.200
     6.666    44.866     0.200
     2.566    17.236     0.200
     3.968    27.274     0.200
     5.203    34.462     0.200
     3.135    20.529     0.200
     3.461    22.918     0.200
     3.796    25.116     0.200
     4.031    26.099     0.200
     4.816    31.537     0.200
     3.917    26.222     0.200
     4.518    30.003     0.200
     2.705    18.201     0.200
     2.785    20.062     0.200
     2.959    19.731     0.200
     2.959    19.531     0.200
     3.673    24.004     0.200
     3.673    24.104     0.200
     3.839    24.865     0.200
     4.028    26.355     0.200
     4.484    29.040     0.200
     5.747    37.393     0.200
     5.747    37.093     0.200
     6.580    42.981     0.200
     2.801    19.006     0.200
     2.515    16.934     0.200
     3.823    25.175     0.200
     3.859    25.551     0.200
     4.163    28.001     0.200
     4.296    28.451     0.200
     5.343    34.736     0.200
     2.509    17.198     0.200
     3.530    24.779     0.200
     3.832    25.652     0.200
     4.152    28.116     0.200
     5.330    35.974     0.200
     6.174    41.422     0.200
     6.573    43.671     0.200
     3.674    24.515     0.200
     5.215    34.527     0.200
     3.823    25.512     0.200
     3.837    25.452     0.200
     3.891    26.019     0.200
     4.083    27.383     0.200
     4.423    29.710     0.200
     5.235    34.842     0.200
     2.783    21.897     0.200
     3.515    23.860     0.200
     3.826    25.532     0.200
     4.081    27.754     0.200
     4.081    27.554     0.200
     4.438    29.683     0.200
     4.858    32.882     0.200
     5.230    34.646     0.200
     5.836    39.564     0.200
     2.545    17.247     0.200
     2.545    17.146     0.200
     3.836    25.485     0.200
     4.080    26.938     0.200
     4.444    29.386     0.200
     5.227    34.242     0.200
     6.684    43.740     0.200
     8.133    55.831     0.200
     2.769    20.759     0.200
     4.080    26.866     0.200
     5.232    34.323     0.200
     2.541    17.002     0.200
     3.842    25.522     0.200
     4.076    26.986     0.200
     5.227    34.256     0.200
     2.500    17.309     0.200
     3.821    25.187     0.200
     3.838    25.389     0.200
     4.099    27.052     0.200
     5.250    34.712     0.200
     3.830    25.333     0.200
     3.831    25.318     0.200
     3.886    26.069     0.200
     4.087    26.925     0.200
     4.432    30.307     0.200
     2.503    17.030     0.200
     2.564    17.111     0.200
     3.819    25.257     0.200
     3.874    25.716     0.200
     4.099    26.988     0.200
     5.250    34.465     0.200
     2.560    17.106     0.200
     3.823    25.373     0.200
     3.838    25.294     0.200
     2.553    17.225     0.200
     4.089    27.008     0.200
     4.439    29.319     0.200
     6.501    42.963     0.200
     2.542    17.194     0.200
     3.841    25.539     0.200
     6.490    42.722     0.200
     7.261    48.526     0.200
     2.546    17.214     0.200
     3.514    24.017     0.200
     4.082    27.098     0.200
     4.435    29.269     0.200
     2.554    17.064     0.200
     2.552    17.369     0.200
     2.550    17.489     0.200
     3.521    24.150     0.200
     3.521    24.949     0.200
     3.832    26.028     0.200
     4.084    27.379     0.200
     4.084    27.780     0.200
     4.449    29.416     0.200
     4.854    33.000     0.200
     6.495    42.641     0.200
     2.781    22.338     0.200
     3.523    23.274     0.200
     3.835    25.834     0.200
     5.245    34.687     0.200
     6.506    42.663     0.200
     2.540    17.613     0.200
     2.755    18.601     0.200
     4.408    30.210     0.200
     5.230    34.407     0.200
     2.548    17.284     0.200
     2.551    17.099     0.200
     2.502    16.855     0.200
     3.432    23.104     0.200
     3.432    23.003     0.200
     4.042    26.884     0.200
     4.693    31.697     0.200
     5.956    39.953     0.200
     6.446    43.235     0.200
     6.462    42.251     0.200
     6.542    43.211     0.200
     7.333    49.289     0.200
     7.554    51.104     0.200
     2.556    17.248     0.200
     2.537    17.173     0.200
     2.537    17.071     0.200
     2.507    17.232     0.200
     5.126    33.864     0.200
     5.503    36.770     0.200
     7.927    52.870     0.200
     2.681    17.965     0.200
     3.835    25.203     0.200
     4.219    28.317     0.200
     4.770    31.193     0.200
     5.448    36.080     0.200
     6.674    44.265     0.200
     6.911    45.202     0.200
     3.417    22.863     0.200
     4.358    28.582     0.200
     4.934    32.862     0.200
     6.157    40.785     0.200
     6.162    40.130     0.200
     6.245    41.155     0.200
     7.162    47.256     0.200
     2.528    20.464     0.200
     2.705    18.392     0.200
     2.915    19.545     0.200
     3.639    25.495     0.200
     3.695    24.347     0.200
     4.022    26.032     0.200
     4.451    29.726     0.200
     5.688    37.084     0.200
     2.981    20.539     0.200
     3.466    23.041     0.200
     7.257    48.299     0.200
     2.846    19.927     0.200
     3.000    20.636     0.200
     3.477    23.465     0.200
     3.853    25.672     0.200
     4.190    27.644     0.200
     4.190    28.347     0.200
     4.310    29.642     0.200
     5.717    38.426     0.200
     2.840    19.476     0.200
     2.840    18.773     0.200
     3.868    25.269     0.200
     3.617    23.905     0.200
     2.530    17.253     0.200
     2.714    18.208     0.200
     2.714    18.411     0.200
     3.797    25.077     0.200
     5.478    36.051     0.200
     6.317    41.557     0.200
     6.682    43.611     0.200
     6.682    43.908     0.200
     6.779    44.777     0.200
     2.585    17.295     0.200
     3.299    21.861     0.200
     6.067    39.455     0.200
     2.667    18.192     0.200
     3.294    21.870     0.200
     3.914    25.931     0.200
     5.815    38.346     0.200
     3.683    25.128     0.200
     4.866    32.926     0.200
     2.698    18.191     0.200
     2.878    19.889     0.200
     3.697    25.124     0.200
     4.039    27.038     0.200
     4.974    32.832     0.200
     5.637    37.086     0.200
     6.477    43.081     0.200
     6.865    45.364     0.200
     2.698    18.263     0.200
     3.697    24.601     0.200
     4.126    27.604     0.200
     4.974    33.003     0.200
     5.640    36.928     0.200
     6.480    42.823     0.200
     6.848    45.335     0.200
     6.868    45.198     0.200
     6.944    45.813     0.200
     2.700    18.136     0.200
     3.699    24.870     0.200
     4.129    27.359     0.200
     4.420    29.352     0.200
     4.975    32.577     0.200
     5.429    35.983     0.200
     5.641    37.311     0.200
     5.641    36.811     0.200
     6.481    42.611     0.200
     6.849    44.917     0.200
     7.836    52.291     0.200
     3.699    25.132     0.200
     4.041    26.640     0.200
     4.422    29.289     0.200
     5.436    36.357     0.200
     5.644    37.329     0.200
     5.644    37.430     0.200
     2.692    18.286     0.200
     2.876    19.246     0.200
     2.876    19.441     0.200
     3.691    24.925     0.200
     4.033    26.738     0.200
     4.117    26.951     0.200
     4.415    29.184     0.200
     4.968    32.927     0.200
     5.637    37.120     0.200
     6.476    42.125     0.200
     6.843    45.537     0.200
     7.100    46.546     0.200
     4.122    27.516     0.200
     4.049    27.173     0.200
     5.653    37.248     0.200
     5.653    37.048     0.200
     5.905    39.005     0.200
     6.493    42.248     0.200
     2.702    18.252     0.200
     2.884    19.427     0.200
     4.424    29.465     0.200
     4.978    32.695     0.200
     5.644    37.317     0.200
     6.852    45.123     0.200
     6.872    45.292     0.200
     2.691    18.032     0.200
     4.031    26.293     0.200
     4.093    26.678     0.200
     4.419    28.463     0.200
     4.965    32.597     0.200
     5.645    36.958     0.200
     6.848    44.718     0.200
     2.711    18.903     0.200
     3.710    24.944     0.200
     4.052    26.854     0.200
     4.122    27.538     0.200
     4.986    33.152     0.200
     5.657    37.524     0.200
     6.864    45.143     0.200
     6.884    45.600     0.200
     7.856    52.057     0.200
     2.701    18.825     0.200
     2.881    19.419     0.200
     3.627    24.217     0.200
     3.702    25.443     0.200
     4.042    26.764     0.200
     4.420    29.157     0.200
     5.640    37.222     0.200
     6.867    44.796     0.200
     2.696    18.389     0.200
     2.881    19.434     0.200
     4.037    26.445     0.200
     4.971    32.340     0.200
     6.482    42.705     0.200
     2.899    19.941     0.200
     4.130    27.574     0.200
     4.057    26.829     0.200
     4.057    27.028     0.200
     4.438    30.276     0.200
     5.659    37.227     0.200
     6.499    42.626     0.200
     2.711    18.331     0.200
     3.710    24.871     0.200
     4.127    27.207     0.200
     4.986    33.482     0.200
     5.655    37.476     0.200
     6.494    42.879     0.200
     6.882    45.856     0.200
     4.124    27.363     0.200
     5.437    35.750     0.200
     5.646    37.308     0.200
     5.646    37.207     0.200
     2.696    18.406     0.200
     2.878    19.180     0.200
     5.638    37.173     0.200
     6.846    44.978     0.200
     6.941    45.863     0.200
     2.879    19.094     0.200
     4.033    26.829     0.200
     4.967    32.730     0.200
     2.696    18.055     0.200
     2.878    19.336     0.200
     2.878    19.137     0.200
     4.126    27.766     0.200
     4.038    27.204     0.200
     4.038    26.704     0.200
     4.417    29.274     0.200
     2.696    18.013     0.200
     2.696    18.313     0.200
     2.880    19.175     0.200
     3.695    24.556     0.200
     4.037    26.565     0.200
     4.419    29.115     0.200
     5.433    36.479     0.200
     5.640    37.157     0.200
     6.480    42.558     0.200
     6.847    45.071     0.200
     6.868    45.834     0.200
     6.943    45.853     0.200
     7.479    50.095     0.200
     3.496    22.931     0.200
     3.834    25.382     0.200
     4.205    27.956     0.200
     2.659    17.790     0.200
     3.830    25.528     0.200
     4.061    26.927     0.200
     4.199    28.021     0.200
     4.766    31.899     0.200
     5.419    35.786     0.200
     6.042    41.217     0.200
     2.710    18.241     0.200
     2.895    19.176     0.200
     4.434    29.018     0.200
     2.702    18.542     0.200
     2.881    19.351     0.200
     4.979    32.976     0.200
     5.640    37.559     0.200
     6.480    43.054     0.200
     6.849    45.145     0.200
     6.867    45.333     0.200
     6.944    45.537     0.200
     3.828    25.507     0.200
     4.061    26.485     0.200
     4.196    28.105     0.200
     5.237    34.855     0.200
     5.416    35.668     0.200
     6.256    40.868     0.200
     6.625    43.064     0.200
     6.644    44.048     0.200
     6.720    43.758     0.200
     6.879    44.996     0.200
     7.115    46.971     0.200
     3.621    24.212     0.200
     3.707    25.010     0.200
     4.048    26.823     0.200
     4.428    29.192     0.200
     4.983    32.818     0.200
     5.648    37.649     0.200
     6.857    45.050     0.200
     2.704    18.647     0.200
     2.886    19.422     0.200
     4.425    29.858     0.200
     5.646    37.315     0.200
     6.486    42.611     0.200
     2.711    18.473     0.200
     2.896    19.215     0.200
     4.052    26.624     0.200
     2.710    18.401     0.200
     2.892    19.273     0.200
     4.130    27.425     0.200
     4.985    32.846     0.200
     5.440    36.238     0.200
     5.652    37.564     0.200
     2.705    18.609     0.200
     4.046    26.762     0.200
     4.980    32.859     0.200
     5.650    37.445     0.200
     6.857    44.961     0.200
     6.953    45.841     0.200
     3.344    22.179     0.200
     3.973    26.235     0.200
     3.973    26.934     0.200
     4.607    30.941     0.200
     4.922    33.467     0.200
     5.161    34.174     0.200
     6.004    39.634     0.200
     6.480    42.781     0.200
     3.345    22.849     0.200
     3.984    26.490     0.200
     4.609    30.396     0.200
     4.950    32.720     0.200
     5.177    33.775     0.200
     6.019    39.339     0.200
     6.408    41.910     0.200
     6.408    41.707     0.200
     6.493    42.307     0.200
     3.666    24.471     0.200
     3.977    26.550     0.200
     5.166    34.269     0.200
     3.665    24.277     0.200
     3.977    26.433     0.200
     4.015    26.797     0.200
     7.350    48.967     0.200
     2.828    19.084     0.200
     2.828    18.982     0.200
     2.862    19.481     0.200
     3.856    26.487     0.200
     4.162    27.711     0.200
     4.390    29.555     0.200
     5.104    34.325     0.200
     5.508    36.204     0.200
     3.338    22.186     0.200
     3.661    24.420     0.200
     3.971    26.599     0.200
     4.602    30.339     0.200
     5.161    33.907     0.200
     3.337    22.451     0.200
     4.601    30.198     0.200
     5.167    34.100     0.200
     6.398    42.531     0.200
     6.398    41.931     0.200
     6.484    43.031     0.200
     6.882    45.061     0.200
     7.353    49.284     0.200
     4.951    32.357     0.200
     2.603    18.954     0.200
     2.869    19.353     0.200
     5.628    37.053     0.200
     3.988    26.269     0.200
     4.614    30.360     0.200
     3.659    24.537     0.200
     3.974    26.364     0.200
     4.600    30.263     0.200
     5.167    34.047     0.200
     3.988    27.845     0.200
     4.615    30.423     0.200
     4.947    32.545     0.200
     5.179    33.841     0.200
     6.411    41.862     0.200
     3.658    24.420     0.200
     4.599    30.340     0.200
     5.156    33.840     0.200
     6.617    43.584     0.200
     3.657    24.179     0.200
     3.976    26.850     0.200
     4.955    32.423     0.200
     5.172    33.897     0.200
     6.014    39.766     0.200
     6.400    42.060     0.200
     6.634    43.636     0.200
     3.650    24.330     0.200
     5.157    34.238     0.200
     7.348    48.766     0.200
     3.964    26.952     0.200
     4.932    32.852     0.200
     7.346    48.987     0.200
     5.165    33.766     0.200
     2.938    20.034     0.200
     3.275    21.498     0.200
     3.880    25.542     0.200
     4.507    29.625     0.200
     4.507    29.727     0.200
     3.355    22.800     0.200
     3.678    25.131     0.200
     4.002    26.951     0.200
     4.943    33.464     0.200
     5.179    34.709     0.200
     6.412    42.420     0.200
     6.408    42.471     0.200
     4.922    32.655     0.200
     3.986    26.506     0.200
     4.609    30.331     0.200
     4.956    32.385     0.200
     5.180    34.172     0.200
     6.022    39.440     0.200
     3.982    26.336     0.200
     4.012    26.580     0.200
     4.951    32.630     0.200
     5.175    34.411     0.200
     6.891    46.309     0.200
     3.340    22.457     0.200
     3.967    26.451     0.200
     5.153    33.603     0.200
     3.628    24.559     0.200
     3.939    26.331     0.200
     5.130    33.527     0.200
     3.659    24.566     0.200
     3.976    26.873     0.200
     4.019    26.774     0.200
     6.399    42.488     0.200
     7.361    49.168     0.200
     3.993    26.564     0.200
     4.947    32.628     0.200
     5.183    34.476     0.200
     6.416    41.987     0.200
     3.999    26.824     0.200
     4.626    30.806     0.200
     4.955    32.862     0.200
     5.190    34.023     0.200
     3.672    24.352     0.200
     3.987    26.273     0.200
     4.613    30.375     0.200
     4.952    32.812     0.200
     5.180    34.357     0.200
     6.023    39.522     0.200
     3.994    26.478     0.200
     3.998    26.426     0.200
     5.189    34.031     0.200
     6.032    39.389     0.200
     6.421    42.148     0.200
     3.946    26.136     0.200
     3.946    26.932     0.200
     4.576    30.681     0.200
     7.326    48.886     0.200
     3.643    24.594     0.200
     3.955    26.257     0.200
     4.921    32.284     0.200
     4.921    32.784     0.200
     5.146    34.252     0.200
     6.378    41.779     0.200
     6.463    42.481     0.200
     6.608    43.397     0.200
     6.873    47.267     0.200
     3.636    24.580     0.200
     3.948    26.740     0.200
     4.577    30.302     0.200
     5.140    34.332     0.200
     5.982    39.397     0.200
     4.004    27.337     0.200
     4.634    31.285     0.200
     7.363    48.435     0.200
     3.992    26.863     0.200
     5.182    34.179     0.200
     3.998    26.533     0.200
     4.625    30.522     0.200
     5.189    35.029     0.200
     7.368    49.100     0.200
     3.329    22.335     0.200
     3.650    24.684     0.200
     3.956    26.818     0.200
     4.033    26.814     0.200
     4.591    31.003     0.200
     4.905    32.832     0.200
     4.905    32.332     0.200
     5.143    34.961     0.200
     5.143    34.461     0.200
     6.462    42.867     0.200
     3.650    24.132     0.200
     3.960    26.511     0.200
     5.150    34.927     0.200
     3.964    26.428     0.200
     4.598    30.329     0.200
     5.152    34.065     0.200
     6.386    41.857     0.200
     7.327    48.478     0.200
     3.941    26.271     0.200
     5.133    33.854     0.200
     3.679    24.586     0.200
     3.991    26.635     0.200
     5.182    34.238     0.200
     3.643    24.196     0.200
     3.958    26.627     0.200
     5.151    34.103     0.200
     3.644    24.304     0.200
     3.949    26.547     0.200
     5.136    33.895     0.200
     3.939    26.415     0.200
     4.568    30.172     0.200
     3.643    24.076     0.200
     3.940    26.516     0.200
     4.045    27.288     0.200
     5.122    33.523     0.200
     7.283    48.099     0.200
     3.663    24.579     0.200
     4.031    27.585     0.200
     3.966    26.672     0.200
     4.024    27.001     0.200
     3.662    24.435     0.200
     3.973    27.108     0.200
     4.603    30.855     0.200
     6.396    42.132     0.200
     7.344    48.667     0.200
     4.031    26.714     0.200
     4.912    32.722     0.200
     5.147    34.181     0.200
     6.381    41.872     0.200
     6.609    43.322     0.200
     6.856    46.497     0.200
     3.306    21.927     0.200
     3.943    25.992     0.200
     5.979    39.235     0.200
     6.367    41.506     0.200
     6.367    41.811     0.200
     3.329    22.631     0.200
     3.950    26.684     0.200
     5.134    34.163     0.200
     7.302    47.974     0.200
     3.636    24.245     0.200
     4.576    30.264     0.200
     7.313    49.432     0.200
     3.315    22.809     0.200
     3.949    26.522     0.200
     3.949    26.116     0.200
     4.043    27.119     0.200
     4.579    30.464     0.200
     5.139    33.524     0.200
     5.139    34.422     0.200
     5.982    39.984     0.200
     6.869    45.363     0.200
     7.327    48.887     0.200
     3.643    24.268     0.200
     4.040    26.830     0.200
     4.901    32.480     0.200
     5.137    34.338     0.200
     7.315    48.420     0.200
     3.938    25.988     0.200
     4.051    26.967     0.200
     4.573    29.979     0.200
     5.126    33.916     0.200
     7.309    48.149     0.200
     3.950    26.600     0.200
     4.040    26.751     0.200
     5.139    33.722     0.200
     5.982    39.983     0.200
     6.373    41.727     0.200
     6.860    45.547     0.200
     3.938    26.074     0.200
     4.572    30.274     0.200
     5.127    33.602     0.200
     3.639    23.994     0.200
     3.946    26.709     0.200
     4.580    30.215     0.200
     5.135    34.134     0.200
     7.317    48.371     0.200
     3.665    24.414     0.200
     3.979    26.750     0.200
     7.356    49.338     0.200
     2.514    17.160     0.200
     3.628    24.552     0.200
     4.054    26.873     0.200
     5.124    34.089     0.200
     7.310    49.277     0.200
     3.950    26.458     0.200
     3.950    26.259     0.200
     4.040    26.913     0.200
     5.140    34.179     0.200
     5.140    34.879     0.200
     6.079    42.416     0.200
     6.373    42.285     0.200
     6.861    45.971     0.200
     2.519    17.367     0.200
     3.635    24.845     0.200
     5.130    34.191     0.200
     3.936    26.637     0.200
     4.577    30.533     0.200
     5.132    34.254     0.200
     7.315    48.380     0.200
     3.628    24.258     0.200
     3.941    26.112     0.200
     4.052    26.814     0.200
     4.569    29.979     0.200
     5.133    33.897     0.200
     7.161    47.127     0.200
     3.303    22.188     0.200
     3.938    25.985     0.200
     4.909    32.253     0.200
     5.129    34.276     0.200
     5.972    39.842     0.200
     6.873    46.330     0.200
     7.323    48.276     0.200
     3.945    26.275     0.200
     5.139    34.342     0.200
     6.101    40.021     0.200
     3.328    22.397     0.200
     3.652    24.620     0.200
     3.966    26.751     0.200
     4.592    30.049     0.200
     5.159    33.728     0.200
     2.698    18.065     0.200
     2.698    17.964     0.200
     3.697    24.808     0.200
     4.039    27.116     0.200
     4.421    29.059     0.200
     5.643    37.800     0.200
     7.843    52.621     0.200
     3.949    26.234     0.200
     5.139    34.046     0.200
     7.326    48.223     0.200
     4.772    31.793     0.200
     5.430    35.812     0.200
     4.000    27.120     0.200
     3.373    23.281     0.200
     3.696    24.716     0.200
     4.637    30.737     0.200
     6.035    39.512     0.200
     6.421    42.314     0.200
     2.689    18.182     0.200
     2.872    19.352     0.200
     4.411    29.289     0.200
     5.632    37.035     0.200
     3.941    26.418     0.200
     4.050    27.139     0.200
     4.680    31.093     0.200
     5.238    34.878     0.200
     4.010    26.403     0.200
     4.609    30.519     0.200
     5.176    34.398     0.200
     6.887    46.880     0.200
     3.336    22.645     0.200
     3.972    26.127     0.200
     5.163    34.129     0.200
     6.391    41.888     0.200
     6.395    42.052     0.200
     7.347    48.339     0.200
     3.956    26.228     0.200
     4.587    30.259     0.200
     5.145    33.946     0.200
     7.328    48.272     0.200
     2.755    18.557     0.200
     4.100    27.064     0.200
     4.425    29.462     0.200
     6.848    44.685     0.200
     3.656    24.405     0.200
     3.973    26.403     0.200
     4.947    33.235     0.200
     5.168    33.766     0.200
     6.082    41.600     0.200
     4.576    30.318     0.200
     6.379    41.580     0.200
     3.625    24.324     0.200
     3.934    26.118     0.200
     5.124    33.729     0.200
     6.095    40.399     0.200
     6.356    41.743     0.200
     2.687    17.906     0.200
     4.028    26.652     0.200
     4.407    29.121     0.200
     4.962    32.541     0.200
     5.628    37.171     0.200
     5.914    38.544     0.200
     2.689    18.142     0.200
     2.870    19.531     0.200
     4.965    32.678     0.200
     5.630    36.627     0.200
     3.954    26.445     0.200
     4.361    29.044     0.200
     4.921    33.460     0.200
     5.145    33.840     0.200
     5.988    39.104     0.200
     6.085    40.369     0.200
     6.377    41.768     0.200
     6.875    46.605     0.200
     3.188    21.615     0.200
     3.938    26.118     0.200
     4.466    29.797     0.200
     5.215    34.562     0.200
     5.204    34.391     0.200
     6.048    40.142     0.200
     6.438    41.991     0.200
     2.718    18.097     0.200
     3.941    26.122     0.200
     3.188    21.507     0.200
     3.535    23.457     0.200
     4.466    29.389     0.200
     5.213    34.072     0.200
     6.046    40.049     0.200
     5.192    34.301     0.200
     5.201    34.494     0.200
     3.523    23.453     0.200
     5.193    34.171     0.200
     3.173    21.084     0.200
     3.942    26.408     0.200
     5.199    34.039     0.200
     6.422    42.168     0.200
     6.662    43.468     0.200
     3.172    21.803     0.200
     3.518    23.267     0.200
     3.935    26.206     0.200
     5.189    34.664     0.200
     2.893    19.177     0.200
     4.050    26.972     0.200
     4.432    29.616     0.200
     4.984    32.867     0.200
     5.653    36.960     0.200
     7.851    52.416     0.200
     3.630    24.465     0.200
     5.965    39.610     0.200
     6.083    39.942     0.200
     6.441    42.057     0.200
     7.131    47.013     0.200
     3.941    26.429     0.200
     5.133    34.216     0.200
     5.976    39.682     0.200
     6.364    41.648     0.200
     4.526    29.507     0.200
     2.563    17.422     0.200
     3.343    22.427     0.200
     3.612    24.180     0.200
     4.284    28.236     0.200
     4.366    29.487     0.200
     4.368    29.440     0.200
     4.591    30.860     0.200
     2.559    17.246     0.200
     4.271    27.966     0.200
     4.838    31.950     0.200
     3.543    23.525     0.200
     3.872    25.887     0.200
     4.263    28.198     0.200
     4.483    29.651     0.200
     6.940    47.209     0.200
     3.966    26.793     0.200
     4.297    28.883     0.200
     4.977    32.999     0.200
     5.169    34.255     0.200
     6.122    39.929     0.200
     6.481    42.648     0.200
     2.727    17.968     0.200
     3.477    23.121     0.200
     3.896    26.032     0.200
     4.409    29.149     0.200
     5.986    39.545     0.200
     6.325    41.881     0.200
     6.376    42.093     0.200
     2.964    19.701     0.200
     3.392    23.000     0.200
     3.420    22.473     0.200
     3.475    23.134     0.200
     4.735    31.024     0.200
     5.010    33.020     0.200
     3.937    26.323     0.200
     4.569    30.143     0.200
     5.127    33.636     0.200
     2.680    18.169     0.200
     3.978    26.671     0.200
     4.148    27.434     0.200
     4.457    29.629     0.200
     6.364    42.479     0.200
     3.119    21.050     0.200
     3.737    24.535     0.200
     4.378    28.754     0.200
     5.772    37.792     0.200
     6.160    40.159     0.200
     3.444    23.980     0.200
     4.934    32.793     0.200
     4.931    33.218     0.200
     3.420    23.261     0.200
     4.307    28.989     0.200
     6.833    46.196     0.200
     3.421    23.747     0.200
     3.721    25.649     0.200
     4.307    28.612     0.200
     4.735    31.721     0.200
     6.834    46.228     0.200
     7.156    46.964     0.200
     3.434    23.379     0.200
     3.730    25.419     0.200
     4.322    28.686     0.200
     4.733    31.411     0.200
     6.822    45.697     0.200
     7.154    48.061     0.200
     4.299    28.665     0.200
     4.741    32.008     0.200
     6.145    41.029     0.200
     6.842    45.928     0.200
     7.163    47.046     0.200
     3.446    24.115     0.200
     6.172    40.707     0.200
     6.844    46.299     0.200
     3.452    24.131     0.200
     3.753    25.814     0.200
     6.176    40.540     0.200
     6.838    45.960     0.200
     3.443    24.078     0.200
     4.336    29.142     0.200
     4.728    32.374     0.200
     6.809    46.631     0.200
     2.951    20.112     0.200
     3.042    21.743     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     2.190    15.562     0.200
     2.641    17.402     0.200
     0.500     4.387     0.200
     2.534    15.359     0.200
     4.966    30.969     0.200
     7.787    47.051     0.200
     0.503     4.109     0.200
     2.550    15.416     0.200
     5.112    31.620     0.200
     1.225     8.724     0.200
     2.287    15.037     0.200
     2.409    16.212     0.200
     2.566    16.278     0.200
     3.781    23.999     0.200
     5.061    32.665     0.200
     5.948    37.309     0.200
     0.759     5.816     0.200
     0.914     7.016     0.200
     1.863    11.735     0.200
     1.863    12.438     0.200
     2.088    13.816     0.200
     2.129    14.437     0.200
     2.209    15.397     0.200
     2.335    15.330     0.200
     2.341    13.859     0.200
     2.341    16.062     0.200
     2.395    15.736     0.200
     2.444    16.653     0.200
     3.459    21.808     0.200
     4.870    30.846     0.200
     0.712     5.761     0.200
     1.383     9.724     0.200
     2.345    14.995     0.200
     2.613    17.368     0.200
     2.692    17.655     0.200
     2.879    19.168     0.200
     3.160    19.892     0.200
     0.669     5.751     0.200
     1.380     9.459     0.200
     2.197    14.827     0.200
     2.337    14.292     0.200
     2.337    15.792     0.200
     2.559    15.204     0.200
     2.701    17.045     0.200
     2.683    16.950     0.200
     3.131    20.025     0.200
     3.933    24.663     0.200
     0.596     4.312     0.200
     1.197     8.987     0.200
     1.455    10.679     0.200
     1.645    11.663     0.200
     1.708    11.625     0.200
     1.972    12.452     0.200
     2.179    14.037     0.200
     2.249    15.021     0.200
     3.028    18.923     0.200
     3.971    25.920     0.200
     4.512    28.611     0.200
     0.776     6.051     0.200
     1.040     7.560     0.200
     1.972    13.989     0.200
     2.233    14.345     0.200
     2.288    14.399     0.200
     2.298    15.280     0.200
     2.430    15.540     0.200
     2.482    16.137     0.200
     2.748    17.830     0.200
     3.325    20.804     0.200
     3.558    22.777     0.200
     4.500    28.381     0.200
     5.695    36.831     0.200
     0.614     5.230     0.200
     2.633    16.662     0.200
     3.073    18.734     0.200
     0.562     4.587     0.200
     1.929    12.740     0.200
     2.379    16.782     0.200
     3.113    20.022     0.200
     4.169    26.395     0.200
     5.473    34.979     0.200
     7.920    47.626     0.200
     0.296     3.221     0.200
     0.296     2.925     0.200
     1.275     8.798     0.200
     1.276     8.886     0.200
     2.465    15.203     0.200
     2.492    16.091     0.200
     3.806    23.251     0.200
     3.862    24.597     0.200
     4.798    30.382     0.200
     5.313    33.169     0.200
     7.786    47.814     0.200
     9.768    58.385     0.200
     0.324     2.939     0.200
     1.244     8.306     0.200
     1.245     8.293     0.200
     2.023    12.718     0.200
     2.447    14.766     0.200
     2.493    16.229     0.200
     3.831    24.408     0.200
     4.767    30.488     0.200
     0.317     2.764     0.200
     1.251     8.763     0.200
     1.253     8.750     0.200
     2.451    15.556     0.200
     2.492    16.281     0.200
     0.318     2.715     0.200
     1.254     8.895     0.200
     2.014    13.419     0.200
     2.453    15.589     0.200
     2.490    16.656     0.200
     4.776    29.893     0.200
     0.281     2.902     0.200
     1.284     8.696     0.200
     1.285     8.681     0.200
     1.985    12.917     0.200
     2.466    14.802     0.200
     2.499    15.722     0.200
     3.873    24.389     0.200
     0.323     3.100     0.200
     1.251     8.465     0.200
     1.252     8.453     0.200
     2.015    12.157     0.200
     2.456    14.711     0.200
     2.486    15.960     0.200
     2.681    17.483     0.200
     3.838    24.875     0.200
     4.219    27.030     0.200
     4.774    30.453     0.200
     0.284     2.994     0.200
     1.268     8.606     0.200
     1.270     8.590     0.200
     2.002    12.049     0.200
     2.448    14.936     0.200
     3.857    24.693     0.200
     0.310     2.965     0.200
     1.256     8.624     0.200
     1.258     8.610     0.200
     2.011    12.526     0.200
     2.453    15.560     0.200
     2.494    16.079     0.200
     2.690    17.400     0.200
     3.844    24.626     0.200
     0.320     2.942     0.200
     1.247     8.619     0.200
     1.248     8.606     0.200
     2.020    13.206     0.200
     2.448    15.309     0.200
     2.494    16.463     0.200
     3.835    24.626     0.200
     0.308     2.425     0.200
     1.270     9.497     0.200
     1.271     9.484     0.200
     1.997    13.917     0.200
     2.468    16.016     0.200
     2.483    16.541     0.200
     2.700    17.806     0.200
     3.857    25.203     0.200
     0.309     2.667     0.200
     1.264     9.315     0.200
     1.265     9.302     0.200
     2.461    15.643     0.200
     2.488    16.632     0.200
     3.852    24.517     0.200
     0.613     4.276     0.200
     1.209     9.321     0.200
     1.792    13.108     0.200
     1.811    13.089     0.200
     2.207    14.267     0.200
     2.574    16.592     0.200
     3.036    19.792     0.200
     0.280     2.851     0.200
     1.281     9.071     0.200
     2.504    16.296     0.200
     3.869    24.361     0.200
     5.486    33.697     0.200
     7.796    48.532     0.200
     0.286     2.887     0.200
     1.279     8.693     0.200
     1.280     8.678     0.200
     1.990    12.695     0.200
     2.463    14.675     0.200
     2.499    16.254     0.200
     7.738    46.118     0.200
     0.303     3.386     0.200
     0.853     6.465     0.200
     2.032    12.409     0.200
     2.422    14.061     0.200
     0.313     3.633     0.200
     2.040    11.978     0.200
     2.418    14.270     0.200
     2.524    15.534     0.200
     2.551    16.329     0.200
     2.670    16.833     0.200
     3.818    23.439     0.200
     4.753    29.824     0.200
     5.299    33.356     0.200
     0.826     6.111     0.200
     1.271     9.123     0.200
     1.272     9.112     0.200
     1.994    13.481     0.200
     2.477    16.346     0.200
     2.469    16.939     0.200
     0.297     2.591     0.200
     1.314     8.621     0.200
     1.315     8.610     0.200
     1.952    12.577     0.200
     2.512    16.243     0.200
     2.454    15.922     0.200
     4.836    31.215     0.200
     5.515    35.398     0.200
     0.207     2.100     0.200
     0.940     7.339     0.200
     1.367     9.761     0.200
     1.368     9.742     0.200
     1.909    12.034     0.200
     2.512    15.292     0.200
     2.810    18.315     0.200
     3.956    25.738     0.200
     4.891    30.736     0.200
     5.407    35.011     0.200
     6.777    42.423     0.200
     0.295     2.612     0.200
     0.856     7.060     0.200
     1.259     8.662     0.200
     2.012    12.768     0.200
     2.442    15.253     0.200
     2.513    16.527     0.200
     2.696    16.981     0.200
     3.222    20.651     0.200
     0.611     4.912     0.200
     0.584     5.125     0.200
     1.337     9.433     0.200
     2.161    15.018     0.200
     2.699    17.341     0.200
     3.878    24.785     0.200
     4.178    27.475     0.200
     0.266     2.315     0.200
     0.880     7.043     0.200
     1.327     9.721     0.200
     1.329     9.707     0.200
     2.507    15.660     0.200
     2.475    16.330     0.200
     2.759    18.215     0.200
     3.915    25.316     0.200
     4.298    27.057     0.200
     0.552     4.297     0.200
     0.561     4.199     0.200
     0.580     4.374     0.200
     1.256     9.588     0.200
     1.742    13.115     0.200
     1.731    12.638     0.200
     0.708     5.640     0.200
     2.247    14.584     0.200
     2.300    14.865     0.200
     2.341    14.391     0.200
     2.449    16.024     0.200
     4.919    31.202     0.200
     0.324     3.901     0.200
     2.551    16.113     0.200
     2.866    17.240     0.200
     3.011    17.238     0.200
     5.933    36.147     0.200
     6.023    36.399     0.200
     7.183    44.862     0.200
     0.510     4.089     0.200
     1.353     9.749     0.200
     1.352     9.763     0.200
     2.233    15.478     0.200
     2.665    17.440     0.200
     3.911    24.995     0.200
     0.550     4.470     0.200
     0.758     5.839     0.200
     2.153    15.356     0.200
     2.252    14.811     0.200
     2.223    15.248     0.200
     2.528    16.981     0.200
     3.409    22.408     0.200
     5.896    38.383     0.200
     0.664     5.238     0.200
     1.073     7.669     0.200
     1.075     7.645     0.200
     2.372    16.306     0.200
     2.464    15.433     0.200
     2.341    15.660     0.200
     2.403    16.141     0.200
     3.621    23.230     0.200
     4.562    29.541     0.200
     5.144    31.850     0.200
     5.666    35.858     0.200
     0.764     5.903     0.200
     0.913     7.265     0.200
     0.915     7.237     0.200
     2.339    14.119     0.200
     2.439    16.049     0.200
     0.859     6.098     0.200
     0.862     6.066     0.200
     2.194    14.617     0.200
     2.304    13.840     0.200
     3.402    21.522     0.200
     4.829    30.776     0.200
     5.874    36.471     0.200
     0.887     6.874     0.200
     2.124    14.543     0.200
     2.139    14.770     0.200
     2.333    14.709     0.200
     2.430    16.368     0.200
     4.747    30.334     0.200
     0.928     7.172     0.200
     2.111    14.372     0.200
     2.111    14.073     0.200
     2.351    15.866     0.200
     2.409    16.090     0.200
     0.661     5.156     0.200
     0.991     7.112     0.200
     2.297    16.063     0.200
     2.368    15.236     0.200
     2.353    15.808     0.200
     2.434    16.170     0.200
     3.222    21.172     0.200
     3.551    22.428     0.200
     4.492    28.454     0.200
     4.959    32.094     0.200
     0.562     4.654     0.200
     2.155    13.966     0.200
     2.717    17.510     0.200
     2.745    16.484     0.200
     3.640    23.537     0.200
     3.964    25.551     0.200
     4.271    27.275     0.200
     7.785    47.365     0.200
     0.385     3.324     0.200
     1.675    10.365     0.200
     2.297    15.102     0.200
     2.838    17.987     0.200
     4.257    27.232     0.200
     0.578     4.619     0.200
     1.302     8.869     0.200
     2.210    14.873     0.200
     2.652    17.420     0.200
     3.850    24.433     0.200
     4.162    26.894     0.200
     4.792    30.741     0.200
     5.346    33.778     0.200
     0.383     3.135     0.200
     1.684    10.953     0.200
     2.304    15.417     0.200
     2.842    18.040     0.200
     2.842    17.739     0.200
     3.081    20.046     0.200
     4.267    27.804     0.200
     5.823    37.157     0.200
     7.049    44.951     0.200
     0.584     4.668     0.200
     1.275     8.708     0.200
     2.225    15.114     0.200
     2.575    16.730     0.200
     2.629    17.102     0.200
     3.823    24.967     0.200
     4.136    26.316     0.200
     0.551     4.211     0.200
     2.272    15.123     0.200
     2.415    16.052     0.200
     2.564    16.915     0.200
     5.802    37.231     0.200
     0.322     3.013     0.200
     2.597    16.058     0.200
     2.825    18.298     0.200
     3.252    20.714     0.200
     4.314    26.923     0.200
     4.777    30.021     0.200
     6.039    36.289     0.200
     0.492     3.909     0.200
     0.492     4.112     0.200
     1.498    10.366     0.200
     2.183    15.268     0.200
     2.183    14.768     0.200
     2.728    17.109     0.200
     2.778    17.523     0.200
     2.838    18.127     0.200
     4.059    25.873     0.200
     4.059    25.674     0.200
     4.379    28.341     0.200
     0.790     6.376     0.200
     2.380    15.524     0.200
     2.380    15.323     0.200
     5.180    33.053     0.200
     1.193     8.958     0.200
     3.444    21.089     0.200
     0.658     5.286     0.200
     0.902     7.026     0.200
     1.879    13.128     0.200
     2.102    13.331     0.200
     2.057    14.461     0.200
     1.183     8.913     0.200
     2.171    15.277     0.200
     2.568    16.955     0.200
     2.859    18.256     0.200
     3.406    19.074     0.200
     3.919    24.877     0.200
     5.459    35.111     0.200
     6.051    39.102     0.200
     0.560     4.340     0.200
     0.567     4.151     0.200
     1.212     9.129     0.200
     2.153    14.144     0.200
     2.687    17.921     0.200
     2.627    17.314     0.200
     3.313    22.106     0.200
     4.529    29.118     0.200
     4.529    29.818     0.200
     4.510    29.636     0.200
     4.510    28.236     0.200
     0.659     4.877     0.200
     0.901     6.651     0.200
     2.058    13.949     0.200
     2.102    12.828     0.200
     2.102    13.429     0.200
     2.661    17.115     0.200
     2.661    16.916     0.200
     3.225    20.534     0.200
     3.225    20.835     0.200
     3.595    23.215     0.200
     4.164    26.675     0.200
     0.267     3.153     0.200
     2.522    16.027     0.200
     4.304    26.829     0.200
     5.250    31.698     0.200
     0.727     5.586     0.200
     1.004     7.752     0.200
     1.884    12.987     0.200
     2.000    13.733     0.200
     2.255    14.256     0.200
     3.227    20.920     0.200
     0.694     5.316     0.200
     1.712    11.333     0.200
     1.964    14.082     0.200
     2.990    19.816     0.200
     3.028    19.267     0.200
     4.249    27.624     0.200
     5.233    34.138     0.200
     1.256     9.659     0.200
     2.346    15.940     0.200
     3.527    22.954     0.200
     3.677    23.118     0.200
     5.414    35.338     0.200
     0.719     5.599     0.200
     1.117     7.860     0.200
     2.259    15.330     0.200
     2.302    16.227     0.200
     2.406    15.915     0.200
     2.406    15.508     0.200
     2.538    16.377     0.200
     2.538    15.971     0.200
     3.645    23.256     0.200
     3.645    22.858     0.200
     3.947    25.627     0.200
     4.587    29.760     0.200
     4.891    30.914     0.200
     5.132    32.597     0.200
     7.304    46.055     0.200
     0.340     2.947     0.200
     1.637    10.599     0.200
     2.335    15.165     0.200
     2.792    17.429     0.200
     2.878    18.518     0.200
     3.041    19.120     0.200
     3.446    22.200     0.200
     3.729    23.686     0.200
     4.140    25.897     0.200
     4.221    26.346     0.200
     4.582    29.636     0.200
     5.215    32.945     0.200
     5.787    36.976     0.200
     0.360     2.920     0.200
     1.642    10.863     0.200
     1.642    10.463     0.200
     2.313    15.629     0.200
     2.313    15.829     0.200
     2.806    18.271     0.200
     2.806    17.271     0.200
     3.039    19.654     0.200
     3.350    20.628     0.200
     3.442    21.446     0.200
     3.717    24.146     0.200
     4.224    26.623     0.200
     4.580    29.069     0.200
     4.580    28.868     0.200
     5.162    33.482     0.200
     5.782    37.244     0.200
     7.823    49.630     0.200
     0.933     7.345     0.200
     2.396    15.479     0.200
     3.345    20.500     0.200
     4.639    28.899     0.200
     4.695    30.443     0.200
     5.372    34.352     0.200
     6.942    40.820     0.200
     0.671     5.186     0.200
     0.871     6.147     0.200
     2.108    14.415     0.200
     2.209    14.435     0.200
     2.209    14.135     0.200
     2.292    15.264     0.200
     2.292    15.464     0.200
     2.592    16.766     0.200
     3.451    22.242     0.200
     5.065    32.505     0.200
     7.430    46.801     0.200
     7.430    45.702     0.200
     0.226     2.277     0.200
     0.226     2.176     0.200
     1.350     9.455     0.200
     2.505    15.785     0.200
     2.499    16.248     0.200
     2.499    16.545     0.200
     2.789    18.057     0.200
     3.733    24.250     0.200
     3.938    25.254     0.200
     4.025    24.443     0.200
     4.327    27.814     0.200
     4.873    31.652     0.200
     5.556    35.577     0.200
     5.556    34.577     0.200
     6.756    43.365     0.200
     0.318     2.910     0.200
     1.254     8.783     0.200
     1.254     8.884     0.200
     2.489    16.868     0.200
     2.454    15.577     0.200
     2.454    14.980     0.200
     2.499    16.557     0.200
     3.828    24.846     0.200
     6.651    42.699     0.200
     7.459    48.400     0.200
     7.462    48.744     0.200
     7.761    50.944     0.200
     0.304     2.871     0.200
     1.256     8.358     0.200
     1.256     8.760     0.200
     2.445    15.476     0.200
     2.445    14.675     0.200
     2.502    16.417     0.200
     2.505    15.979     0.200
     2.505    16.682     0.200
     2.691    17.308     0.200
     3.502    22.346     0.200
     3.843    24.769     0.200
     4.229    26.764     0.200
     4.778    31.053     0.200
     4.778    30.853     0.200
     5.458    35.219     0.200
     5.458    34.418     0.200
     0.303     2.756     0.200
     0.303     2.858     0.200
     1.261     8.369     0.200
     1.261     9.369     0.200
     2.452    15.474     0.200
     2.452    14.775     0.200
     2.499    16.025     0.200
     2.499    16.622     0.200
     2.507    16.233     0.200
     2.695    17.437     0.200
     2.695    17.636     0.200
     3.507    22.857     0.200
     3.821    24.201     0.200
     3.821    24.803     0.200
     3.848    24.782     0.200
     4.091    26.353     0.200
     0.513     4.085     0.200
     0.513     4.185     0.200
     1.159     7.648     0.200
     1.159     7.548     0.200
     2.385    16.145     0.200
     2.384    15.554     0.200
     2.384    16.054     0.200
     2.473    15.816     0.200
     2.473    15.316     0.200
     2.535    16.488     0.200
     3.729    23.755     0.200
     5.096    32.907     0.200
     5.286    33.886     0.200
     5.606    35.450     0.200
     0.320     2.945     0.200
     1.259     8.687     0.200
     2.462    15.445     0.200
     2.481    16.527     0.200
     3.823    23.068     0.200
     3.845    24.909     0.200
     4.084    24.720     0.200
     6.654    42.826     0.200
     0.343     3.149     0.200
     1.236     8.530     0.200
     1.236     8.630     0.200
     2.063    13.272     0.200
     2.449    15.266     0.200
     2.449    14.866     0.200
     2.481    15.997     0.200
     3.821    24.959     0.200
     3.847    22.958     0.200
     4.011    25.642     0.200
     4.495    25.294     0.200
     0.348     2.891     0.200
     1.229     9.004     0.200
     2.069    13.500     0.200
     2.445    15.516     0.200
     2.482    16.384     0.200
     2.655    17.569     0.200
     4.008    25.976     0.200
     4.107    26.723     0.200
     4.107    26.023     0.200
     0.395     3.355     0.200
     1.216     8.581     0.200
     2.081    13.374     0.200
     2.462    15.433     0.200
     2.444    16.140     0.200
     3.797    24.650     0.200
     0.359     2.936     0.200
     1.223     8.960     0.200
     2.076    14.004     0.200
     2.445    15.795     0.200
     2.445    15.595     0.200
     2.477    16.424     0.200
     3.807    24.896     0.200
     3.860    24.979     0.200
     3.860    25.280     0.200
     4.110    26.566     0.200
     4.110    26.167     0.200
     4.184    26.996     0.200
     5.409    34.999     0.200
     5.593    33.554     0.200
     0.274     2.892     0.200
     1.277     8.275     0.200
     1.277     8.076     0.200
     2.027    11.524     0.200
     2.450    15.190     0.200
     2.450    14.889     0.200
     2.525    15.819     0.200
     2.525    16.018     0.200
     2.517    15.718     0.200
     2.517    16.019     0.200
     2.718    17.068     0.200
     2.718    16.966     0.200
     3.523    22.369     0.200
     3.865    23.979     0.200
     3.865    24.479     0.200
     3.805    24.277     0.200
     3.805    24.480     0.200
     3.805    22.980     0.200
     4.087    25.394     0.200
     4.087    26.093     0.200
     4.255    27.228     0.200
     4.435    25.332     0.200
     5.335    33.419     0.200
     5.572    31.763     0.200
     0.311     2.719     0.200
     0.311     2.821     0.200
     1.257     8.776     0.200
     1.257     8.378     0.200
     2.452    15.428     0.200
     2.452    15.131     0.200
     2.495    16.432     0.200
     2.495    16.729     0.200
     2.689    17.868     0.200
     3.503    22.963     0.200
     3.825    24.510     0.200
     3.825    24.408     0.200
     3.825    24.306     0.200
     3.844    24.692     0.200
     4.092    26.295     0.200
     4.092    25.592     0.200
     4.227    27.114     0.200
     4.466    29.035     0.200
     4.779    30.273     0.200
     5.576    34.573     0.200
     0.330     2.861     0.200
     1.246     8.461     0.200
     2.053    13.347     0.200
     2.454    15.477     0.200
     2.491    16.646     0.200
     2.484    16.420     0.200
     3.836    24.542     0.200
     4.011    25.991     0.200
     0.310     3.118     0.200
     1.253     8.411     0.200
     1.253     8.612     0.200
     2.048    12.037     0.200
     2.447    14.879     0.200
     2.447    15.779     0.200
     2.499    16.375     0.200
     2.499    16.575     0.200
     2.687    17.484     0.200
     3.829    23.655     0.200
     4.097    26.428     0.200
     4.097    26.628     0.200
     6.070    37.202     0.200
     0.332     3.042     0.200
     1.238     8.374     0.200
     2.444    14.900     0.200
     2.444    15.201     0.200
     2.482    16.453     0.200
     2.482    16.152     0.200
     2.491    16.645     0.200
     2.491    16.243     0.200
     2.667    17.397     0.200
     3.824    24.898     0.200
     3.845    24.352     0.200
     3.845    24.051     0.200
     4.002    25.908     0.200
     4.205    25.945     0.200
     4.205    27.042     0.200
     4.105    25.715     0.200
     4.105    25.914     0.200
     4.488    28.541     0.200
     5.589    33.196     0.200
     6.076    37.215     0.200
     6.634    41.497     0.200
     0.326     3.035     0.200
     1.247     8.193     0.200
     2.053    12.884     0.200
     2.451    15.434     0.200
     2.491    16.569     0.200
     2.488    16.211     0.200
     2.488    16.414     0.200
     2.676    17.120     0.200
     3.835    24.185     0.200
     3.835    24.381     0.200
     4.008    25.670     0.200
     4.096    26.141     0.200
     4.096    25.235     0.200
     4.214    27.065     0.200
     5.441    34.748     0.200
     5.581    35.719     0.200
     0.602     4.643     0.200
     1.339     9.142     0.200
     2.000    13.325     0.200
     2.167    15.372     0.200
     2.167    15.271     0.200
     2.696    17.496     0.200
     3.802    24.596     0.200
     0.332     2.920     0.200
     0.332     3.021     0.200
     1.238     8.642     0.200
     1.238     8.843     0.200
     2.062    12.933     0.200
     2.483    16.620     0.200
     2.444    15.268     0.200
     2.444    15.468     0.200
     2.491    16.921     0.200
     3.824    23.864     0.200
     3.824    24.963     0.200
     3.844    24.533     0.200
     4.003    25.778     0.200
     4.104    24.597     0.200
     4.104    25.896     0.200
     0.314     3.075     0.200
     1.245     8.311     0.200
     1.245     8.413     0.200
     2.439    14.474     0.200
     2.439    15.075     0.200
     2.491    16.273     0.200
     2.679    17.174     0.200
     3.837    23.560     0.200
     3.867    23.016     0.200
     3.832    24.423     0.200
     4.105    26.336     0.200
     4.105    26.035     0.200
     4.217    27.329     0.200
     5.446    35.281     0.200
     5.590    34.712     0.200
     6.078    37.613     0.200
     0.333     2.968     0.200
     1.234     8.656     0.200
     2.066    12.943     0.200
     2.440    15.485     0.200
     2.664    17.466     0.200
     4.202    27.316     0.200
     0.767     5.827     0.200
     1.411     9.908     0.200
     2.002    14.611     0.200
     2.829    18.365     0.200
     3.912    25.322     0.200
     0.765     5.893     0.200
     1.286     8.706     0.200
     2.088    14.657     0.200
     2.449    16.535     0.200
     2.522    16.391     0.200
     2.522    16.690     0.200
     2.719    17.190     0.200
     3.789    23.800     0.200
     4.059    25.948     0.200
     4.059    26.548     0.200
     4.883    29.533     0.200
     4.883    31.233     0.200
     5.219    33.810     0.200
     0.350     2.879     0.200
     1.630    10.946     0.200
     2.320    15.495     0.200
     2.320    15.791     0.200
     2.794    17.557     0.200
     3.029    19.421     0.200
     3.454    21.855     0.200
     3.729    24.247     0.200
     4.155    25.678     0.200
     0.359     3.022     0.200
     1.633    10.946     0.200
     1.633    10.649     0.200
     2.311    15.531     0.200
     2.311    15.735     0.200
     2.801    17.617     0.200
     2.801    17.219     0.200
     2.872    18.788     0.200
     3.030    19.550     0.200
     3.030    19.448     0.200
     3.451    21.932     0.200
     3.723    23.961     0.200
     4.215    27.310     0.200
     4.571    29.365     0.200
     5.153    32.572     0.200
     5.209    31.321     0.200
     7.831    47.412     0.200
     0.556     3.803     0.200
     0.556     4.100     0.200
     2.631    17.489     0.200
     2.951    19.054     0.200
     6.252    39.535     0.200
     0.342     2.802     0.200
     1.621    10.782     0.200
     1.621    10.578     0.200
     2.326    15.154     0.200
     2.784    17.802     0.200
     2.784    16.997     0.200
     3.021    19.438     0.200
     3.021    19.235     0.200
     3.463    22.581     0.200
     3.463    21.683     0.200
     3.739    24.064     0.200
     3.866    24.373     0.200
     4.204    26.636     0.200
     4.204    26.238     0.200
     4.562    29.453     0.200
     4.562    28.953     0.200
     5.141    33.198     0.200
     5.141    33.299     0.200
     5.225    32.325     0.200
     5.766    36.601     0.200
     0.714     5.568     0.200
     2.185    14.607     0.200
     2.185    14.505     0.200
     2.859    18.242     0.200
     2.929    19.520     0.200
     3.116    18.936     0.200
     4.771    30.424     0.200
     5.178    32.571     0.200
     5.178    32.872     0.200
     6.400    39.914     0.200
     0.821     6.281     0.200
     1.331     9.430     0.200
     1.331     9.227     0.200
     2.019    13.998     0.200
     2.019    14.303     0.200
     2.478    16.741     0.200
     2.534    16.192     0.200
     2.781    17.814     0.200
     2.781    17.314     0.200
     3.505    22.658     0.200
     3.816    24.137     0.200
     4.069    26.484     0.200
     4.069    26.383     0.200
     4.759    30.031     0.200
     4.845    31.219     0.200
     5.403    33.414     0.200
     6.480    41.342     0.200
     0.818     6.232     0.200
     1.334     9.212     0.200
     1.334     9.009     0.200
     2.019    14.115     0.200
     2.019    14.216     0.200
     2.482    16.716     0.200
     2.538    16.763     0.200
     2.538    16.559     0.200
     2.782    17.917     0.200
     2.782    17.019     0.200
     3.509    22.337     0.200
     3.819    24.009     0.200
     3.819    24.509     0.200
     4.073    26.351     0.200
     4.762    29.911     0.200
     4.850    30.586     0.200
     5.221    33.644     0.200
     5.400    33.362     0.200
     0.685     5.320     0.200
     0.685     5.422     0.200
     1.009     7.148     0.200
     2.216    14.959     0.200
     2.216    15.158     0.200
     2.351    15.685     0.200
     2.404    15.458     0.200
     2.392    15.896     0.200
     2.392    16.095     0.200
     3.560    22.670     0.200
     3.560    22.569     0.200
     3.892    25.396     0.200
     4.113    26.425     0.200
     5.731    34.435     0.200
     6.188    38.709     0.200
     0.679     5.371     0.200
     1.010     7.203     0.200
     1.010     6.903     0.200
     2.219    14.799     0.200
     2.219    15.198     0.200
     2.355    15.505     0.200
     2.402    15.258     0.200
     2.396    15.925     0.200
     3.563    22.607     0.200
     3.563    22.207     0.200
     3.897    24.718     0.200
     4.109    25.937     0.200
     0.695     5.267     0.200
     0.695     5.572     0.200
     1.004     7.264     0.200
     1.004     7.162     0.200
     2.209    15.298     0.200
     2.209    15.399     0.200
     2.342    15.843     0.200
     2.404    15.419     0.200
     2.390    16.184     0.200
     3.554    22.810     0.200
     0.691     5.391     0.200
     1.007     7.399     0.200
     1.007     7.298     0.200
     2.213    15.425     0.200
     2.347    15.668     0.200
     2.407    15.572     0.200
     2.389    16.177     0.200
     2.389    16.376     0.200
     3.558    22.938     0.200
     3.888    25.281     0.200
     4.115    25.429     0.200
     4.923    31.799     0.200
     0.429     3.411     0.200
     1.048     7.297     0.200
     2.204    14.408     0.200
     2.300    15.484     0.200
     2.527    16.831     0.200
     2.696    17.858     0.200
     3.635    23.501     0.200
     3.635    22.903     0.200
     4.057    26.576     0.200
     0.680     5.384     0.200
     2.217    15.044     0.200
     2.354    15.546     0.200
     2.402    15.487     0.200
     2.396    15.857     0.200
     2.396    15.959     0.200
     3.235    21.171     0.200
     3.562    22.853     0.200
     3.562    22.548     0.200
     3.895    24.762     0.200
     4.009    20.929     0.200
     4.110    25.954     0.200
     4.503    28.466     0.200
     4.935    32.027     0.200
     7.354    46.495     0.200
     0.365     2.951     0.200
     1.648    10.775     0.200
     1.650    10.858     0.200
     2.309    15.364     0.200
     2.813    17.588     0.200
     2.813    17.784     0.200
     2.887    18.915     0.200
     2.887    18.619     0.200
     3.045    19.383     0.200
     3.045    19.578     0.200
     3.710    23.619     0.200
     4.141    25.983     0.200
     4.231    26.840     0.200
     4.586    29.795     0.200
     5.168    33.501     0.200
     5.787    37.277     0.200
     0.062     2.006     0.200
     0.909     6.522     0.200
     2.494    15.421     0.200
     2.698    17.137     0.200
     2.698    17.840     0.200
     3.745    24.523     0.200
     4.098    25.307     0.200
     0.075     1.878     0.200
     0.908     6.354     0.200
     2.490    15.598     0.200
     2.711    17.715     0.200
     2.711    17.614     0.200
     3.748    24.407     0.200
     4.542    29.249     0.200
     0.679     5.316     0.200
     0.679     5.416     0.200
     1.004     7.322     0.200
     1.004     7.122     0.200
     2.214    15.008     0.200
     2.351    15.599     0.200
     2.395    15.485     0.200
     2.403    15.802     0.200
     2.403    16.201     0.200
     3.231    21.037     0.200
     3.558    22.616     0.200
     3.558    22.316     0.200
     6.319    40.897     0.200
     0.618     4.663     0.200
     0.618     4.862     0.200
     1.217     8.864     0.200
     1.346     9.163     0.200
     1.346     9.062     0.200
     2.150    14.778     0.200
     2.150    15.377     0.200
     2.710    17.445     0.200
     2.710    17.145     0.200
     3.800    24.121     0.200
     4.827    31.240     0.200
     5.043    32.619     0.200
     5.394    33.024     0.200
     7.444    47.302     0.200
     1.218     7.805     0.200
     1.321     8.094     0.200
     2.188    13.876     0.200
     2.523    16.071     0.200
     2.633    16.486     0.200
     2.675    16.499     0.200
     2.675    16.300     0.200
     3.867    23.587     0.200
     3.867    22.888     0.200
     4.174    26.606     0.200
     4.174    26.806     0.200
     4.809    30.096     0.200
     5.422    30.236     0.200
     0.607     4.673     0.200
     1.216     8.765     0.200
     1.338     9.145     0.200
     1.338     9.043     0.200
     2.164    15.110     0.200
     2.164    15.712     0.200
     2.698    17.375     0.200
     2.698    17.273     0.200
     3.804    23.862     0.200
     3.804    24.963     0.200
     3.879    24.691     0.200
     4.181    27.267     0.200
     6.202    40.175     0.200
     0.605     4.755     0.200
     0.605     4.654     0.200
     1.212     8.671     0.200
     1.342     9.150     0.200
     1.342     9.048     0.200
     2.163    14.972     0.200
     2.163    15.375     0.200
     2.701    17.597     0.200
     3.800    24.472     0.200
     3.884    24.688     0.200
     3.884    24.387     0.200
     3.923    25.029     0.200
     5.399    32.802     0.200
     0.607     4.718     0.200
     1.347     9.085     0.200
     2.158    15.025     0.200
     2.706    17.523     0.200
     3.888    24.531     0.200
     4.189    26.823     0.200
     5.365    34.794     0.200
     7.362    47.286     0.200
     8.261    51.596     0.200
     0.648     5.268     0.200
     1.012     6.819     0.200
     1.012     6.717     0.200
     2.228    14.730     0.200
     2.385    15.191     0.200
     2.373    15.230     0.200
     2.421    15.474     0.200
     3.243    20.482     0.200
     3.572    22.139     0.200
     3.572    21.936     0.200
     3.914    25.347     0.200
     4.098    25.508     0.200
     4.513    28.861     0.200
     0.290     2.508     0.200
     1.097     7.987     0.200
     1.310     8.910     0.200
     2.465    16.026     0.200
     2.465    16.626     0.200
     2.502    16.100     0.200
     2.502    15.800     0.200
     2.736    17.966     0.200
     2.736    17.566     0.200
     3.556    22.799     0.200
     3.773    23.168     0.200
     3.896    25.031     0.200
     3.896    23.831     0.200
     4.275    27.208     0.200
     4.832    31.309     0.200
     5.499    35.425     0.200
     6.703    43.464     0.200
     0.825     6.260     0.200
     0.838     6.514     0.200
     0.838     6.414     0.200
     2.022    13.791     0.200
     2.022    13.691     0.200
     2.160    14.777     0.200
     2.160    14.677     0.200
     2.279    15.194     0.200
     2.279    14.694     0.200
     2.488    16.451     0.200
     2.488    16.651     0.200
     3.701    23.894     0.200
     5.908    36.347     0.200
     0.595     4.644     0.200
     1.327     9.000     0.200
     2.180    14.451     0.200
     2.636    16.931     0.200
     2.636    17.031     0.200
     2.683    17.079     0.200
     2.683    17.579     0.200
     3.871    24.310     0.200
     3.871    24.410     0.200
     4.176    25.850     0.200
     4.813    30.718     0.200
     6.597    41.497     0.200
     0.385     3.178     0.200
     1.184     8.546     0.200
     2.434    16.065     0.200
     2.434    15.963     0.200
     2.480    15.736     0.200
     2.480    15.931     0.200
     2.474    16.092     0.200
     2.474    16.296     0.200
     2.645    17.106     0.200
     3.849    25.152     0.200
     3.818    24.121     0.200
     3.818    24.714     0.200
     4.082    26.328     0.200
     4.184    26.433     0.200
     4.184    26.737     0.200
     4.755    29.976     0.200
     5.565    31.225     0.200
     6.243    40.009     0.200
     6.613    42.901     0.200
     0.398     3.250     0.200
     2.421    16.142     0.200
     2.488    15.865     0.200
     2.472    16.140     0.200
     2.472    16.542     0.200
     2.639    17.193     0.200
     2.639    17.294     0.200
     3.480    22.685     0.200
     3.816    23.864     0.200
     3.816    24.461     0.200
     4.525    28.688     0.200
     4.754    30.516     0.200
     5.560    32.204     0.200
     6.041    37.100     0.200
     6.236    40.417     0.200
     6.607    42.186     0.200
     0.397     3.188     0.200
     1.231     8.553     0.200
     1.192     8.608     0.200
     2.427    16.296     0.200
     2.427    16.096     0.200
     2.468    16.511     0.200
     2.468    16.812     0.200
     2.481    15.859     0.200
     2.481    16.062     0.200
     2.636    17.151     0.200
     2.636    17.452     0.200
     3.475    22.759     0.200
     3.812    24.436     0.200
     3.855    24.232     0.200
     3.870    24.860     0.200
     4.176    26.781     0.200
     4.749    30.691     0.200
     5.212    33.890     0.200
     6.604    41.844     0.200
     7.382    46.689     0.200
     7.711    48.826     0.200
     0.388     3.123     0.200
     1.190     8.552     0.200
     1.229     8.404     0.200
     2.438    16.099     0.200
     2.438    15.803     0.200
     2.474    15.578     0.200
     2.474    15.977     0.200
     2.468    16.043     0.200
     2.468    16.449     0.200
     2.639    16.652     0.200
     2.639    17.253     0.200
     3.811    23.869     0.200
     3.856    23.951     0.200
     3.872    25.062     0.200
     4.178    26.581     0.200
     5.221    33.618     0.200
     0.551     4.408     0.200
     1.052     7.365     0.200
     2.132    14.264     0.200
     2.701    17.623     0.200
     2.803    17.427     0.200
     2.803    17.825     0.200
     3.783    24.492     0.200
     4.045    25.741     0.200
     4.987    32.346     0.200
     5.526    35.351     0.200
     5.526    35.547     0.200
     8.121    49.972     0.200
     0.558     4.362     0.200
     1.058     7.728     0.200
     2.126    14.356     0.200
     2.126    14.255     0.200
     2.698    17.083     0.200
     2.805    17.639     0.200
     2.805    18.037     0.200
     3.638    23.510     0.200
     4.042    25.898     0.200
     4.042    26.101     0.200
     5.521    35.535     0.200
     5.521    35.738     0.200
     6.767    43.802     0.200
     0.374     2.913     0.200
     2.819    17.781     0.200
     2.669    15.629     0.200
     3.484    20.016     0.200
     3.203    20.004     0.200
     4.136    25.515     0.200
     5.673    35.381     0.200
     0.450     3.540     0.200
     1.210     8.663     0.200
     2.529    16.378     0.200
     2.715    17.099     0.200
     2.913    17.994     0.200
     2.913    18.193     0.200
     2.990    16.194     0.200
     3.273    20.292     0.200
     6.678    39.562     0.200
     0.290     2.474     0.200
     0.290     2.669     0.200
     1.104     8.171     0.200
     1.302     8.860     0.200
     1.302     8.961     0.200
     2.472    16.411     0.200
     2.493    15.463     0.200
     2.493    15.768     0.200
     2.730    17.899     0.200
     3.548    23.250     0.200
     3.780    22.746     0.200
     3.808    24.010     0.200
     3.888    24.178     0.200
     4.427    27.789     0.200
     4.824    31.062     0.200
     5.533    31.793     0.200
     6.697    42.200     0.200
     0.672     4.471     0.200
     0.672     4.776     0.200
     1.779    12.759     0.200
     1.779    12.158     0.200
     2.248    14.079     0.200
     2.248    14.384     0.200
     2.805    18.284     0.200
     2.805    18.581     0.200
     3.118    20.729     0.200
     3.118    20.026     0.200
     3.415    22.163     0.200
     3.415    22.358     0.200
     4.061    25.726     0.200
     4.539    28.546     0.200
     4.575    28.027     0.200
     4.575    29.628     0.200
     4.618    29.424     0.200
     5.839    37.473     0.200
     3.267    20.468     0.200
     3.480    19.479     0.200
     3.759    23.429     0.200
     4.352    27.202     0.200
     4.714    27.674     0.200
     5.196    32.360     0.200
     0.288     3.686     0.200
     0.288     3.786     0.200
     1.752    11.494     0.200
     2.666    15.332     0.200
     2.666    15.732     0.200
     2.718    16.923     0.200
     3.488    21.241     0.200
     3.862    22.477     0.200
     4.772    30.458     0.200
     5.255    33.320     0.200
     6.022    38.368     0.200
     1.085     8.350     0.200
     1.602    10.426     0.200
     2.668    17.282     0.200
     2.681    17.825     0.200
     3.703    23.297     0.200
     3.716    23.853     0.200
     3.708    23.842     0.200
     3.708    24.043     0.200
     4.002    26.116     0.200
     5.273    33.379     0.200
     5.273    34.379     0.200
     6.572    42.325     0.200
     7.097    44.491     0.200
     0.360     2.907     0.200
     0.360     3.102     0.200
     1.589    10.158     0.200
     1.589    10.462     0.200
     2.300    15.268     0.200
     2.776    17.407     0.200
     2.776    17.508     0.200
     2.826    18.027     0.200
     2.980    18.627     0.200
     2.980    18.924     0.200
     2.980    19.229     0.200
     3.497    22.396     0.200
     3.514    22.603     0.200
     3.753    24.401     0.200
     3.834    24.564     0.200
     3.834    24.462     0.200
     4.522    28.140     0.200
     4.522    28.437     0.200
     5.430    34.642     0.200
     5.722    36.334     0.200
     7.725    48.150     0.200
     0.641     5.185     0.200
     2.034    13.232     0.200
     2.034    13.528     0.200
     2.751    17.359     0.200
     2.841    17.709     0.200
     2.841    17.912     0.200
     2.894    17.697     0.200
     2.894    17.994     0.200
     3.562    21.504     0.200
     3.598    21.279     0.200
     3.709    23.480     0.200
     3.774    24.032     0.200
     3.774    22.829     0.200
     4.094    25.884     0.200
     4.380    26.958     0.200
     4.380    28.154     0.200
     5.186    28.944     0.200
     5.147    30.502     0.200
     5.652    34.013     0.200
     5.540    34.319     0.200
     8.149    45.874     0.200
     0.369     3.193     0.200
     0.848     5.913     0.200
     2.291    15.669     0.200
     2.785    17.507     0.200
     4.174    26.790     0.200
     4.524    28.808     0.200
     5.231    32.860     0.200
     5.726    35.685     0.200
     0.628     5.165     0.200
     0.628     4.966     0.200
     2.847    18.375     0.200
     2.847    17.875     0.200
     2.883    18.246     0.200
     2.883    17.347     0.200
     3.116    19.834     0.200
     3.257    18.982     0.200
     3.257    21.181     0.200
     3.329    20.749     0.200
     3.710    23.700     0.200
     4.648    29.148     0.200
     5.107    32.693     0.200
     0.504     3.652     0.200
     0.504     3.753     0.200
     1.239     9.475     0.200
     2.103    13.897     0.200
     2.094    14.096     0.200
     4.497    29.651     0.200
     4.511    28.989     0.200
     6.270    40.259     0.200
     0.469     3.712     0.200
     0.469     3.814     0.200
     0.974     6.914     0.200
     2.198    15.727     0.200
     2.786    17.372     0.200
     2.743    18.371     0.200
     2.871    18.875     0.200
     2.871    19.176     0.200
     3.584    23.051     0.200
     3.758    24.728     0.200
     4.087    26.979     0.200
     4.412    28.887     0.200
     5.277    31.999     0.200
     5.598    36.050     0.200
     8.030    48.075     0.200
     0.340     2.799     0.200
     0.340     2.901     0.200
     1.666    10.625     0.200
     2.348    15.859     0.200
     2.805    18.027     0.200
     2.805    17.426     0.200
     3.447    21.734     0.200
     4.251    26.555     0.200
     4.251    26.855     0.200
     4.615    29.104     0.200
     5.187    33.227     0.200
     5.821    37.630     0.200
     5.821    37.329     0.200
     0.324     2.683     0.200
     0.794     5.898     0.200
     1.626    10.784     0.200
     2.349    15.449     0.200
     2.349    15.551     0.200
     2.776    16.865     0.200
     2.776    17.462     0.200
     3.456    21.723     0.200
     3.485    20.995     0.200
     3.872    24.274     0.200
     4.211    25.821     0.200
     4.211    27.219     0.200
     4.574    29.378     0.200
     0.327     2.720     0.200
     0.796     5.846     0.200
     1.625    10.778     0.200
     2.344    15.785     0.200
     3.458    22.188     0.200
     3.485    20.370     0.200
     3.743    23.555     0.200
     4.209    26.519     0.200
     4.209    26.820     0.200
     4.572    27.988     0.200
     5.778    37.514     0.200
     0.472     3.715     0.200
     1.010     7.340     0.200
     1.486     9.787     0.200
     2.204    14.695     0.200
     2.760    17.318     0.200
     2.760    17.615     0.200
     3.614    22.045     0.200
     3.621    23.162     0.200
     3.806    24.106     0.200
     4.051    25.446     0.200
     4.051    25.751     0.200
     4.328    28.118     0.200
     5.562    36.119     0.200
     6.798    43.790     0.200
     0.463     3.687     0.200
     1.004     7.276     0.200
     2.212    14.479     0.200
     2.757    17.321     0.200
     2.757    17.522     0.200
     3.612    21.938     0.200
     3.618    23.368     0.200
     4.053    25.286     0.200
     4.053    25.786     0.200
     4.380    28.079     0.200
     5.289    31.170     0.200
     6.803    43.599     0.200
     0.540     4.284     0.200
     1.138     8.299     0.200
     1.384     9.731     0.200
     2.190    15.526     0.200
     2.708    17.685     0.200
     0.399     3.176     0.200
     0.908     6.839     0.200
     1.748    12.141     0.200
     2.260    15.069     0.200
     2.772    17.590     0.200
     3.541    22.907     0.200
     3.769    24.449     0.200
     4.269    26.822     0.200
     0.592     4.674     0.200
     1.114     8.183     0.200
     2.113    14.727     0.200
     2.654    17.614     0.200
     2.755    18.126     0.200
     2.790    17.720     0.200
     3.660    23.772     0.200
     0.694     5.500     0.200
     1.412    10.019     0.200
     2.216    13.739     0.200
     2.541    16.142     0.200
     2.541    16.341     0.200
     3.343    20.784     0.200
     3.665    23.130     0.200
     3.991    24.522     0.200
     4.018    24.216     0.200
     3.971    25.658     0.200
     3.971    25.759     0.200
     4.129    26.613     0.200
     4.195    27.246     0.200
     4.607    29.835     0.200
     5.158    33.407     0.200
     0.722     5.564     0.200
     2.239    14.358     0.200
     2.256    15.455     0.200
     2.256    15.755     0.200
     2.302    15.725     0.200
     2.302    15.925     0.200
     2.540    16.148     0.200
     2.540    16.347     0.200
     3.645    23.451     0.200
     3.946    25.732     0.200
     4.800    29.774     0.200
     4.889    31.533     0.200
     5.131    32.500     0.200
     5.615    33.253     0.200
     7.301    46.777     0.200
     7.301    47.078     0.200
     0.309     2.775     0.200
     1.147     8.192     0.200
     1.257     8.715     0.200
     2.045    13.118     0.200
     2.450    15.384     0.200
     2.498    16.334     0.200
     2.689    17.595     0.200
     3.843    24.630     0.200
     0.370     2.982     0.200
     1.546    10.560     0.200
     1.546    10.660     0.200
     2.288    15.595     0.200
     2.753    17.673     0.200
     2.931    18.602     0.200
     2.931    19.102     0.200
     3.555    22.318     0.200
     4.258    27.913     0.200
     0.318     2.847     0.200
     1.148     8.356     0.200
     2.043    13.621     0.200
     2.459    15.162     0.200
     2.459    15.764     0.200
     2.485    16.851     0.200
     2.485    16.652     0.200
     2.687    17.707     0.200
     3.825    25.023     0.200
     3.825    23.125     0.200
     3.852    23.307     0.200
     3.844    24.801     0.200
     3.844    24.602     0.200
     4.225    27.453     0.200
     4.780    30.281     0.200
     6.654    43.107     0.200
     0.310     2.830     0.200
     1.151     8.218     0.200
     1.253     8.630     0.200
     2.049    13.342     0.200
     2.446    15.099     0.200
     2.446    15.599     0.200
     2.500    16.969     0.200
     2.500    16.571     0.200
     2.498    16.890     0.200
     2.686    17.698     0.200
     3.859    23.218     0.200
     3.840    24.642     0.200
     3.840    25.040     0.200
     4.010    26.149     0.200
     7.715    47.919     0.200
     0.316     2.719     0.200
     0.316     2.820     0.200
     1.152     8.257     0.200
     1.253     8.688     0.200
     2.048    13.403     0.200
     2.450    15.208     0.200
     2.450    15.708     0.200
     2.498    16.556     0.200
     2.498    16.755     0.200
     2.494    16.900     0.200
     2.494    16.502     0.200
     2.684    17.581     0.200
     3.499    22.777     0.200
     3.499    22.977     0.200
     3.830    24.012     0.200
     3.839    25.004     0.200
     4.016    26.038     0.200
     4.095    26.617     0.200
     6.651    41.987     0.200
     8.067    48.861     0.200
     0.351     2.996     0.200
     0.881     6.514     0.200
     1.557    10.423     0.200
     1.740    11.582     0.200
     2.307    15.062     0.200
     2.750    17.497     0.200
     2.948    19.285     0.200
     4.137    26.709     0.200
     0.378     3.019     0.200
     0.899     6.640     0.200
     1.550    10.947     0.200
     1.748    11.942     0.200
     2.280    15.727     0.200
     2.760    17.823     0.200
     4.473    28.829     0.200
     0.525     4.205     0.200
     1.011     7.242     0.200
     1.011     7.140     0.200
     1.398    10.121     0.200
     2.287    14.848     0.200
     2.284    14.776     0.200
     2.441    16.441     0.200
     3.256    21.336     0.200
     3.595    23.083     0.200
     4.072    26.709     0.200
     4.092    25.881     0.200
     0.472     4.006     0.200
     0.472     3.905     0.200
     1.057     7.472     0.200
     1.434     9.478     0.200
     1.434     9.377     0.200
     1.875    11.928     0.200
     2.223    14.367     0.200
     2.654    17.441     0.200
     2.654    17.242     0.200
     2.718    17.395     0.200
     2.718    16.995     0.200
     2.783    18.035     0.200
     2.783    17.535     0.200
     3.666    21.930     0.200
     3.666    23.730     0.200
     3.998    24.949     0.200
     3.998    24.449     0.200
     4.295    26.987     0.200
     4.324    27.546     0.200
     5.513    34.271     0.200
     6.748    43.265     0.200
     0.915     7.076     0.200
     0.915     7.177     0.200
     1.065     8.012     0.200
     2.064    14.659     0.200
     2.064    14.557     0.200
     2.240    14.806     0.200
     2.240    14.509     0.200
     2.859    17.584     0.200
     2.866    18.697     0.200
     3.112    19.733     0.200
     3.401    20.954     0.200
     3.465    22.218     0.200
     3.576    22.917     0.200
     4.479    28.271     0.200
     4.809    30.627     0.200
     4.809    30.424     0.200
     5.115    32.658     0.200
     5.750    37.151     0.200
     6.270    39.878     0.200
     0.775     6.101     0.200
     0.775     5.999     0.200
     1.151     8.914     0.200
     2.242    15.182     0.200
     2.242    15.081     0.200
     2.552    17.161     0.200
     3.188    20.038     0.200
     3.493    22.575     0.200
     4.481    29.255     0.200
     4.829    31.189     0.200
     4.829    30.486     0.200
     5.227    33.442     0.200
     5.227    33.645     0.200
     5.760    36.731     0.200
     7.186    43.877     0.200
     7.656    48.897     0.200
     0.542     4.362     0.200
     1.163     8.413     0.200
     1.355     9.374     0.200
     1.355     9.272     0.200
     1.967    12.829     0.200
     2.205    15.256     0.200
     2.565    16.955     0.200
     2.683    17.476     0.200
     2.683    17.375     0.200
     2.683    17.780     0.200
     3.583    23.273     0.200
     3.768    24.515     0.200
     3.909    24.766     0.200
     5.408    34.868     0.200
     0.632     4.899     0.200
     1.168     8.043     0.200
     1.168     7.941     0.200
     1.350     9.313     0.200
     2.275    15.016     0.200
     2.275    15.415     0.200
     2.369    15.922     0.200
     2.487    16.241     0.200
     2.547    16.343     0.200
     2.547    16.444     0.200
     3.389    21.823     0.200
     3.713    23.337     0.200
     3.713    23.236     0.200
     3.945    25.334     0.200
     4.029    25.655     0.200
     4.096    25.065     0.200
     4.187    27.013     0.200
     4.655    29.446     0.200
     0.328     2.951     0.200
     1.166     8.374     0.200
     1.240     8.611     0.200
     2.060    13.329     0.200
     2.443    15.366     0.200
     2.485    16.482     0.200
     2.494    16.469     0.200
     3.826    24.523     0.200
     3.842    23.636     0.200
     4.104    25.874     0.200
     4.208    26.965     0.200
     4.484    27.838     0.200
     4.762    30.204     0.200
     0.634     5.018     0.200
     1.203     8.877     0.200
     1.379     9.721     0.200
     2.118    15.302     0.200
     2.746    17.866     0.200
     3.775    23.965     0.200
     4.569    29.196     0.200
     0.195     2.336     0.200
     1.015     7.271     0.200
     1.384     9.858     0.200
     2.522    15.281     0.200
     2.506    16.363     0.200
     2.827    18.421     0.200
     2.827    18.320     0.200
     3.700    23.334     0.200
     3.740    22.864     0.200
     3.972    25.554     0.200
     3.972    24.854     0.200
     0.735     5.706     0.200
     0.735     5.606     0.200
     1.039     7.557     0.200
     1.492    10.369     0.200
     2.307    15.263     0.200
     2.229    15.376     0.200
     2.229    15.276     0.200
     2.322    15.785     0.200
     2.465    16.015     0.200
     3.250    20.958     0.200
     3.572    22.896     0.200
     4.108    25.947     0.200
     4.108    26.346     0.200
     4.132    26.664     0.200
     4.221    27.522     0.200
     4.874    29.305     0.200
     5.078    32.321     0.200
     0.837     6.437     0.200
     1.301     9.315     0.200
     1.463    10.324     0.200
     1.463    10.523     0.200
     1.923    14.556     0.200
     1.987    15.007     0.200
     2.899    18.863     0.200
     3.636    23.571     0.200
     3.720    24.085     0.200
     3.945    25.666     0.200
     4.187    27.640     0.200
     5.323    34.685     0.200
     6.594    42.945     0.200
     6.594    42.644     0.200
     7.509    46.875     0.200
     8.400    52.175     0.200
     0.503     4.104     0.200
     0.503     4.002     0.200
     1.104     8.088     0.200
     1.399     9.543     0.200
     1.399     9.441     0.200
     1.915    12.523     0.200
     2.212    15.058     0.200
     2.704    17.119     0.200
     3.703    23.564     0.200
     3.715    22.822     0.200
     3.959    24.967     0.200
     4.280    27.632     0.200
     7.571    46.922     0.200
     0.692     5.420     0.200
     1.132     8.381     0.200
     1.410    10.334     0.200
     2.215    15.347     0.200
     2.263    16.282     0.200
     2.323    16.387     0.200
     2.431    16.617     0.200
     2.541    16.446     0.200
     3.666    23.912     0.200
     4.129    26.608     0.200
     0.549     4.373     0.200
     1.143     8.247     0.200
     2.165    13.715     0.200
     2.363    16.202     0.200
     2.367    16.258     0.200
     2.476    16.186     0.200
     3.708    24.111     0.200
     0.280     3.352     0.200
     0.280     3.250     0.200
     0.659     4.828     0.200
     1.750    10.697     0.200
     2.737    15.480     0.200
     2.737    15.781     0.200
     3.002    19.080     0.200
     3.780    23.106     0.200
     5.794    36.907     0.200
     0.326     2.687     0.200
     0.618     5.086     0.200
     1.302     8.003     0.200
     2.086    13.645     0.200
     2.567    16.640     0.200
     3.038    17.940     0.200
     3.114    18.158     0.200
     3.620    19.248     0.200
     3.541    22.572     0.200
     4.387    26.700     0.200
     4.673    29.257     0.200
     5.079    32.023     0.200
     5.603    34.708     0.200
     1.078     8.067     0.200
     1.304     9.331     0.200
     1.632    11.608     0.200
     1.920    13.551     0.200
     2.300    16.207     0.200
     2.367    16.434     0.200
     2.364    16.470     0.200
     2.841    18.704     0.200
     3.393    22.352     0.200
     3.688    23.813     0.200
     4.094    26.276     0.200
     4.543    28.032     0.200
     5.002    31.283     0.200
     5.481    35.587     0.200
     6.980    45.200     0.200
     0.773     6.059     0.200
     0.827     5.922     0.200
     1.624    10.625     0.200
     2.045    14.211     0.200
     2.237    14.472     0.200
     2.205    14.547     0.200
     2.484    15.900     0.200
     2.540    16.841     0.200
     3.059    19.877     0.200
     3.390    21.824     0.200
     3.916    24.985     0.200
     4.279    26.553     0.200
     4.276    26.382     0.200
     6.173    40.039     0.200
     0.149     1.704     0.200
     1.371     9.553     0.200
     1.371     9.850     0.200
     1.953    13.156     0.200
     2.474    15.478     0.200
     2.474    15.579     0.200
     2.830    18.725     0.200
     2.830    18.624     0.200
     3.990    25.882     0.200
     3.959    25.949     0.200
     3.959    25.144     0.200
     5.603    36.361     0.200
     7.067    44.783     0.200
     8.331    51.226     0.200
     0.156     1.567     0.200
     1.358     9.627     0.200
     1.966    12.945     0.200
     2.462    15.652     0.200
     2.819    18.286     0.200
     3.732    23.928     0.200
     3.946    25.125     0.200
     4.878    31.748     0.200
     0.738     5.825     0.200
     1.132     8.015     0.200
     1.563    10.488     0.200
     1.831    11.359     0.200
     1.950    13.474     0.200
     2.940    18.717     0.200
     3.633    22.835     0.200
     4.489    27.744     0.200
     4.549    28.043     0.200
     0.275     1.988     0.200
     0.692     5.519     0.200
     1.254     8.854     0.200
     2.164    14.339     0.200
     2.614    17.184     0.200
     2.955    18.807     0.200
     3.085    18.892     0.200
     3.416    22.223     0.200
     3.624    22.696     0.200
     3.624    23.596     0.200
     4.407    27.658     0.200
     4.399    27.961     0.200
     4.749    29.467     0.200
     5.162    33.355     0.200
     5.678    35.336     0.200
     6.387    41.355     0.200
     1.212     9.078     0.200
     2.157    14.651     0.200
     2.176    15.732     0.200
     2.390    16.732     0.200
     2.481    17.074     0.200
     3.414    22.692     0.200
     3.732    24.273     0.200
     3.924    25.740     0.200
     4.021    25.698     0.200
     4.282    27.953     0.200
     4.675    30.172     0.200
     6.040    39.344     0.200
     0.541     4.407     0.200
     1.407    10.001     0.200
     1.917    12.945     0.200
     2.177    15.608     0.200
     2.728    17.486     0.200
     3.699    23.945     0.200
     3.960    25.703     0.200
     4.901    31.517     0.200
     5.453    35.481     0.200
     0.310     2.776     0.200
     0.733     5.140     0.200
     1.633    11.338     0.200
     1.674    10.852     0.200
     2.393    15.967     0.200
     2.920    18.815     0.200
     3.095    19.670     0.200
     4.635    30.101     0.200
     0.327     2.660     0.200
     1.628    11.883     0.200
     1.676    11.320     0.200
     2.370    16.417     0.200
     2.920    18.698     0.200
     3.091    20.008     0.200
     4.284    27.483     0.200
     4.262    27.139     0.200
     4.631    29.729     0.200
     5.198    33.916     0.200
     0.318     2.636     0.200
     1.548    10.692     0.200
     1.750    12.133     0.200
     2.340    15.846     0.200
     2.726    17.138     0.200
     2.949    19.339     0.200
     3.536    22.886     0.200
     3.558    22.033     0.200
     3.793    24.886     0.200
     4.131    26.750     0.200
     4.248    27.683     0.200
     4.490    29.055     0.200
     5.068    33.010     0.200
     5.696    36.780     0.200
     6.917    44.132     0.200
     0.778     6.079     0.200
     0.935     6.841     0.200
     2.129    15.116     0.200
     2.255    15.446     0.200
     2.374    15.458     0.200
     2.403    16.216     0.200
     2.404    16.105     0.200
     3.149    20.910     0.200
     3.473    22.330     0.200
     4.052    25.966     0.200
     4.204    27.002     0.200
     5.000    32.607     0.200
     6.222    40.153     0.200
     0.603     4.882     0.200
     1.054     7.310     0.200
     2.254    13.709     0.200
     2.275    15.370     0.200
     2.407    15.422     0.200
     2.413    16.155     0.200
     2.423    16.041     0.200
     3.619    22.880     0.200
     3.964    25.658     0.200
     4.050    24.352     0.200
     4.047    25.488     0.200
     4.559    29.108     0.200
     0.309     2.727     0.200
     0.890     6.448     0.200
     1.534    10.636     0.200
     1.764    11.748     0.200
     2.349    16.121     0.200
     2.712    17.291     0.200
     3.550    22.709     0.200
     3.572    22.445     0.200
     4.117    26.591     0.200
     0.330     2.718     0.200
     0.872     6.694     0.200
     1.557    10.803     0.200
     1.740    12.171     0.200
     2.328    15.309     0.200
     2.739    17.010     0.200
     2.955    19.386     0.200
     3.527    22.315     0.200
     3.547    21.977     0.200
     4.139    26.170     0.200
     0.137     1.717     0.200
     0.964     7.068     0.200
     2.534    16.602     0.200
     2.669    16.910     0.200
     2.767    18.101     0.200
     3.325    19.884     0.200
     3.441    19.934     0.200
     4.679    28.855     0.200
     0.786     6.029     0.200
     0.927     6.778     0.200
     1.584    11.214     0.200
     2.245    15.400     0.200
     2.369    15.556     0.200
     2.413    15.847     0.200
     2.406    16.523     0.200
     4.050    25.842     0.200
     0.599     4.704     0.200
     1.163     8.427     0.200
     1.400     9.760     0.200
     2.133    15.406     0.200
     2.749    17.718     0.200
     3.715    24.246     0.200
     3.942    25.294     0.200
     0.583     4.658     0.200
     1.154     8.393     0.200
     1.398     9.747     0.200
     2.147    15.300     0.200
     2.739    17.890     0.200
     3.714    22.514     0.200
     3.943    25.241     0.200
     4.344    28.358     0.200
     4.885    31.953     0.200
     6.882    44.650     0.200
     0.535     4.233     0.200
     1.000     7.514     0.200
     1.409    10.036     0.200
     2.242    15.619     0.200
     2.276    15.215     0.200
     2.431    16.514     0.200
     3.899    25.481     0.200
     4.103    26.900     0.200
     0.913     6.256     0.200
     1.573    10.361     0.200
     2.117    14.210     0.200
     2.255    14.703     0.200
     2.255    15.500     0.200
     2.336    14.754     0.200
     2.413    14.254     0.200
     2.444    15.698     0.200
     4.011    25.903     0.200
     4.199    25.915     0.200
     4.211    26.370     0.200
     4.403    28.037     0.200
     5.007    32.184     0.200
     0.331     3.583     0.200
     0.635     4.632     0.200
     0.635     5.132     0.200
     1.609     9.863     0.200
     1.609    11.562     0.200
     1.803    10.503     0.200
     2.674    16.830     0.200
     2.674    16.631     0.200
     2.733    17.143     0.200
     2.733    16.844     0.200
     3.055    19.091     0.200
     3.326    19.423     0.200
     4.115    26.316     0.200
     4.816    30.637     0.200
     5.310    32.873     0.200
     6.060    38.821     0.200
     6.897    43.457     0.200
     1.219     9.205     0.200
     2.072    13.548     0.200
     2.113    14.066     0.200
     2.667    17.703     0.200
     2.908    18.999     0.200
     2.974    19.323     0.200
     3.296    21.869     0.200
     4.524    29.640     0.200
     4.708    30.288     0.200
     5.723    36.942     0.200
     0.127     3.480     0.200
     1.964    11.048     0.200
     1.964    12.048     0.200
     2.393    14.442     0.200
     2.393    14.543     0.200
     2.705    16.801     0.200
     2.785    17.762     0.200
     3.690    22.801     0.200
     3.839    23.265     0.200
     4.028    24.855     0.200
     4.952    31.681     0.200
     4.952    31.781     0.200
     5.679    36.292     0.200
     6.129    37.839     0.200
     6.912    43.801     0.200
     8.098    50.063     0.200
     0.103     2.083     0.200
     0.836     6.442     0.200
     1.074     7.362     0.200
     2.490    16.132     0.200
     3.266    19.380     0.200
     0.603     4.651     0.200
     1.230     8.733     0.200
     1.316     8.926     0.200
     2.021    13.399     0.200
     2.181    14.740     0.200
     2.623    17.183     0.200
     2.677    17.452     0.200
     3.798    24.765     0.200
     0.621     4.922     0.200
     1.244     9.055     0.200
     1.313     8.848     0.200
     2.030    13.477     0.200
     2.169    15.061     0.200
     2.612    17.191     0.200
     2.682    17.174     0.200
     3.852    25.219     0.200
     4.305    28.031     0.200
     0.175     2.043     0.200
     0.828     6.515     0.200
     1.062     7.190     0.200
     2.880    17.977     0.200
     3.290    19.788     0.200
     0.795     6.154     0.200
     1.331     9.298     0.200
     1.360     9.857     0.200
     2.036    14.566     0.200
     2.485    17.130     0.200
     2.547    17.106     0.200
     2.770    17.899     0.200
     1.368     9.708     0.200
     1.338     9.257     0.200
     1.338     9.358     0.200
     2.091    15.469     0.200
     2.020    14.597     0.200
     2.488    17.140     0.200
     2.783    17.795     0.200
     3.836    25.215     0.200
     3.893    25.145     0.200
     3.826    25.333     0.200
     0.818     6.299     0.200
     1.341     9.596     0.200
     1.341     9.495     0.200
     1.372     9.833     0.200
     2.015    14.635     0.200
     2.093    13.627     0.200
     2.093    13.424     0.200
     2.093    15.127     0.200
     2.489    17.200     0.200
     2.489    17.400     0.200
     2.788    18.012     0.200
     2.788    17.512     0.200
     3.516    22.919     0.200
     3.836    24.685     0.200
     3.826    25.095     0.200
     3.894    24.805     0.200
     3.894    24.704     0.200
     4.080    26.235     0.200
     4.853    31.314     0.200
     6.491    41.996     0.200
     7.574    47.558     0.200
     8.452    50.709     0.200
     0.797     6.075     0.200
     1.329     9.369     0.200
     1.363     9.572     0.200
     2.036    14.310     0.200
     2.092    14.657     0.200
     2.544    16.988     0.200
     2.769    17.860     0.200
     3.839    25.267     0.200
     4.423    28.961     0.200
     0.804     6.168     0.200
     1.329     9.343     0.200
     1.369     9.680     0.200
     2.031    14.349     0.200
     2.096    14.495     0.200
     2.772    17.900     0.200
     3.819    24.588     0.200
     0.787     5.893     0.200
     1.345     9.587     0.200
     1.344     9.199     0.200
     2.032    14.173     0.200
     2.073    14.084     0.200
     2.563    16.874     0.200
     2.779    18.056     0.200
     0.799     5.997     0.200
     1.339     9.402     0.200
     2.028    14.358     0.200
     2.085    13.895     0.200
     2.492    17.146     0.200
     2.552    17.043     0.200
     2.779    18.296     0.200
     0.793     6.078     0.200
     1.348     9.200     0.200
     2.026    14.291     0.200
     2.073    13.641     0.200
     2.784    17.937     0.200
     4.435    28.978     0.200
     0.797     6.074     0.200
     1.346     9.269     0.200
     2.024    14.466     0.200
     2.077    14.148     0.200
     2.785    18.282     0.200
     0.806     6.221     0.200
     1.344     9.443     0.200
     1.360     9.652     0.200
     2.020    14.550     0.200
     2.083    14.409     0.200
     2.495    16.606     0.200
     2.786    18.014     0.200
     3.833    25.195     0.200
     3.885    25.186     0.200
     5.238    33.698     0.200
     0.802     6.197     0.200
     1.330     9.342     0.200
     1.367     9.908     0.200
     2.032    14.847     0.200
     2.094    15.222     0.200
     2.772    18.111     0.200
     3.820    24.783     0.200
     4.078    26.774     0.200
     4.427    28.506     0.200
     0.808     6.202     0.200
     1.366     9.787     0.200
     1.337     9.424     0.200
     2.090    14.834     0.200
     2.024    14.615     0.200
     2.488    16.996     0.200
     2.546    17.014     0.200
     2.781    17.979     0.200
     2.781    17.878     0.200
     3.835    23.471     0.200
     3.892    24.809     0.200
     3.892    24.709     0.200
     3.825    25.186     0.200
     4.082    26.598     0.200
     4.861    31.402     0.200
     5.231    33.883     0.200
     7.258    45.129     0.200
     0.804     6.182     0.200
     1.344     9.390     0.200
     1.359     9.709     0.200
     2.021    14.580     0.200
     2.083    13.662     0.200
     2.495    16.950     0.200
     2.785    18.068     0.200
     3.828    24.997     0.200
     3.884    25.539     0.200
     4.089    26.447     0.200
     0.810     6.298     0.200
     1.344     9.661     0.200
     1.363     9.745     0.200
     2.017    14.713     0.200
     2.085    14.619     0.200
     2.495    16.540     0.200
     2.788    18.216     0.200
     3.829    24.866     0.200
     3.832    24.832     0.200
     3.886    25.497     0.200
     4.087    26.856     0.200
     4.442    28.712     0.200
     5.236    34.051     0.200
     0.820     6.375     0.200
     1.369     9.861     0.200
     1.347     9.721     0.200
     2.088    14.074     0.200
     2.009    14.795     0.200
     2.009    14.594     0.200
     2.494    17.430     0.200
     2.794    18.237     0.200
     3.830    25.042     0.200
     3.889    24.154     0.200
     3.832    25.028     0.200
     4.854    29.602     0.200
     5.231    34.093     0.200
     5.231    34.194     0.200
     7.250    37.839     0.200
     7.425    47.890     0.200
     7.578    48.308     0.200
     1.352     9.517     0.200
     1.343     9.318     0.200
     2.027    14.330     0.200
     2.078    14.437     0.200
     2.497    16.850     0.200
     2.558    16.937     0.200
     2.781    17.738     0.200
     3.825    24.154     0.200
     3.880    25.111     0.200
     4.094    26.817     0.200
     4.433    28.962     0.200
     0.785     5.882     0.200
     1.318     9.373     0.200
     1.361     9.867     0.200
     2.052    14.410     0.200
     2.096    14.482     0.200
     3.813    24.945     0.200
     0.812     6.346     0.200
     1.341     9.667     0.200
     1.367     9.871     0.200
     2.018    14.969     0.200
     2.089    15.142     0.200
     2.786    18.210     0.200
     3.828    24.844     0.200
     4.083    26.770     0.200
     0.810     6.224     0.200
     1.344     9.491     0.200
     1.363     9.865     0.200
     2.018    14.827     0.200
     2.086    13.537     0.200
     2.494    17.069     0.200
     2.787    18.053     0.200
     3.520    22.793     0.200
     3.831    24.460     0.200
     3.887    24.717     0.200
     4.087    26.584     0.200
     4.441    28.842     0.200
     4.774    29.760     0.200
     5.235    34.076     0.200
     0.701     5.377     0.200
     1.228     8.529     0.200
     1.228     8.630     0.200
     2.175    15.379     0.200
     2.137    14.723     0.200
     2.409    16.643     0.200
     2.409    16.444     0.200
     2.638    17.069     0.200
     2.638    16.870     0.200
     3.751    24.182     0.200
     4.042    25.884     0.200
     3.939    25.787     0.200
     4.285    27.950     0.200
     5.217    33.975     0.200
     5.217    33.776     0.200
     6.462    42.052     0.200
     7.333    46.289     0.200
     8.397    51.664     0.200
     0.246     2.322     0.200
     0.847     6.200     0.200
     1.080     8.474     0.200
     1.080     8.295     0.200
     3.247    17.819     0.200
     3.080    20.171     0.200
     3.468    18.495     0.200
     4.789    29.062     0.200
     5.840    34.850     0.200
     6.344    36.857     0.200
     6.867    40.532     0.200
     7.024    41.335     0.200
     0.315     2.780     0.200
     1.156     8.365     0.200
     1.248     8.989     0.200
     2.053    14.096     0.200
     2.444    15.731     0.200
     2.494    16.855     0.200
     2.500    16.481     0.200
     3.494    22.878     0.200
     3.834    24.712     0.200
     4.009    25.563     0.200
     6.648    43.070     0.200
     0.844     6.492     0.200
     0.893     6.813     0.200
     2.074    14.940     0.200
     2.191    14.772     0.200
     2.361    15.481     0.200
     2.405    16.167     0.200
     2.463    16.300     0.200
     3.095    20.514     0.200
     3.732    24.183     0.200
     4.054    26.333     0.200
     4.263    27.586     0.200
     4.782    29.736     0.200
     5.775    37.543     0.200
     0.093     2.076     0.200
     0.944     6.642     0.200
     1.878    12.451     0.200
     2.528    15.565     0.200
     2.571    16.760     0.200
     3.639    22.597     0.200
     4.042    25.400     0.200
     6.525    41.914     0.200
     6.880    43.576     0.200
     6.914    44.977     0.200
     0.552     4.383     0.200
     1.454     8.263     0.200
     2.953    17.963     0.200
     2.981    17.938     0.200
     4.165    25.323     0.200
     0.606     4.960     0.200
     1.166     8.557     0.200
     1.166     8.046     0.200
     2.604    16.067     0.200
     2.969    16.865     0.200
     3.057    19.788     0.200
     3.057    19.566     0.200
     3.406    21.209     0.200
     4.505    28.694     0.200
     5.240    32.515     0.200
     5.641    32.215     0.200
     0.786     6.018     0.200
     0.930     6.734     0.200
     1.583    10.921     0.200
     2.247    15.171     0.200
     2.373    15.606     0.200
     2.411    15.558     0.200
     2.403    16.554     0.200
     3.788    24.682     0.200
     4.407    28.865     0.200
     4.992    32.136     0.200
     6.214    40.379     0.200
     0.368     2.842     0.200
     0.831     5.948     0.200
     1.609    10.862     0.200
     1.688    12.444     0.200
     1.688    12.342     0.200
     2.294    15.966     0.200
     2.793    18.241     0.200
     2.793    17.741     0.200
     3.000    19.238     0.200
     3.477    22.363     0.200
     4.310    28.345     0.200
     4.541    29.250     0.200
     5.127    33.106     0.200
     5.740    37.049     0.200
     0.489     4.137     0.200
     1.034     7.760     0.200
     1.248     8.928     0.200
     2.995    16.274     0.200
     3.160    17.648     0.200
     4.382    26.734     0.200
     5.833    34.935     0.200
     6.113    36.022     0.200
     6.623    38.923     0.200
     6.770    40.285     0.200
     1.063     8.410     0.200
     4.267    25.322     0.200
     5.159    32.612     0.200
     5.270    30.517     0.200
     5.270    33.415     0.200
     6.336    40.569     0.200
     0.299     2.495     0.200
     0.299     2.596     0.200
     1.286     9.177     0.200
     2.015    13.767     0.200
     2.015    13.072     0.200
     2.015    13.666     0.200
     2.479    16.049     0.200
     2.478    16.263     0.200
     2.478    16.567     0.200
     3.797    23.976     0.200
     3.872    24.800     0.200
     3.872    25.402     0.200
     4.039    26.042     0.200
     4.253    27.354     0.200
     4.253    27.456     0.200
     4.807    30.990     0.200
     6.705    43.234     0.200
     7.458    47.053     0.200
     0.365     3.800     0.200
     1.539     9.496     0.200
     2.810    16.466     0.200
     2.810    16.364     0.200
     3.273    20.263     0.200
     4.207    25.468     0.200
     4.421    28.168     0.200
     4.421    27.668     0.200
     4.835    30.134     0.200
     4.835    31.037     0.200
     5.350    33.429     0.200
     7.480    45.267     0.200
     0.520     4.041     0.200
     1.221     9.165     0.200
     1.631    11.478     0.200
     1.753    12.051     0.200
     2.114    13.837     0.200
     2.656    17.315     0.200
     2.909    18.967     0.200
     2.973    19.517     0.200
     4.516    29.107     0.200
     5.721    36.643     0.200
     0.923     7.041     0.200
     0.947     7.161     0.200
     1.705    11.812     0.200
     2.142    14.806     0.200
     2.321    16.014     0.200
     2.438    16.150     0.200
     2.496    17.274     0.200
     3.400    22.633     0.200
     4.147    27.313     0.200
     4.299    27.937     0.200
     0.231     1.970     0.200
     0.231     2.072     0.200
     0.953     7.045     0.200
     1.452     9.928     0.200
     1.851    12.071     0.200
     1.851    12.172     0.200
     2.437    16.832     0.200
     2.607    16.449     0.200
     2.607    16.551     0.200
     2.698    17.996     0.200
     2.878    18.788     0.200
     3.630    23.114     0.200
     4.039    26.436     0.200
     4.131    27.165     0.200
     4.417    28.925     0.200
     6.846    44.381     0.200
     6.846    44.483     0.200
     0.224     2.031     0.200
     0.952     6.833     0.200
     1.452     9.998     0.200
     1.852    12.334     0.200
     2.444    16.729     0.200
     2.603    16.668     0.200
     2.880    18.935     0.200
     3.630    23.387     0.200
     4.039    26.409     0.200
     4.419    28.473     0.200
     0.227     1.894     0.200
     0.227     1.995     0.200
     0.951     6.840     0.200
     1.454    10.377     0.200
     1.850    12.154     0.200
     2.606    16.433     0.200
     2.881    18.815     0.200
     2.881    18.917     0.200
     3.628    23.595     0.200
     4.041    26.281     0.200
     4.041    25.984     0.200
     4.420    28.852     0.200
     6.868    44.386     0.200
     6.944    45.100     0.200
     7.836    48.088     0.200
     0.218     1.960     0.200
     0.950     6.916     0.200
     1.454    10.036     0.200
     1.454     9.935     0.200
     2.450    16.012     0.200
     2.450    16.808     0.200
     2.601    16.252     0.200
     2.601    16.549     0.200
     2.700    17.890     0.200
     2.883    18.852     0.200
     3.629    23.449     0.200
     3.699    24.132     0.200
     4.041    25.742     0.200
     4.121    27.005     0.200
     4.422    28.789     0.200
     4.975    32.236     0.200
     0.219     2.148     0.200
     0.958     6.926     0.200
     1.446    10.228     0.200
     1.446    10.431     0.200
     1.859    12.206     0.200
     1.859    12.010     0.200
     2.451    16.395     0.200
     2.451    16.700     0.200
     2.595    16.422     0.200
     2.595    16.523     0.200
     3.636    21.961     0.200
     3.636    23.461     0.200
     4.033    25.637     0.200
     4.415    28.785     0.200
     7.838    49.427     0.200
     0.212     1.943     0.200
     0.942     6.932     0.200
     1.461     9.868     0.200
     1.845    12.492     0.200
     2.604    16.333     0.200
     2.604    16.233     0.200
     2.453    15.794     0.200
     2.708    17.719     0.200
     2.892    18.969     0.200
     2.892    18.669     0.200
     3.621    23.658     0.200
     3.621    23.158     0.200
     3.707    23.859     0.200
     4.122    26.917     0.200
     4.049    26.072     0.200
     4.431    28.409     0.200
     4.983    32.370     0.200
     5.445    34.875     0.200
     7.852    49.283     0.200
     0.223     1.984     0.200
     0.948     6.823     0.200
     1.456    10.193     0.200
     1.848    12.321     0.200
     2.444    16.667     0.200
     2.606    16.576     0.200
     3.626    23.772     0.200
     4.043    26.402     0.200
     4.127    26.321     0.200
     0.957     5.972     0.200
     1.443     9.597     0.200
     1.866    11.858     0.200
     2.480    15.795     0.200
     2.881    18.516     0.200
     3.640    22.653     0.200
     6.872    43.741     0.200
     6.945    45.185     0.200
     0.210     1.893     0.200
     0.938     6.894     0.200
     1.464     9.851     0.200
     1.842    12.448     0.200
     2.455    16.296     0.200
     2.605    16.341     0.200
     2.896    18.844     0.200
     3.618    23.116     0.200
     4.435    28.385     0.200
     0.233     2.020     0.200
     1.456    10.256     0.200
     1.847    12.480     0.200
     2.434    16.630     0.200
     2.611    16.670     0.200
     6.480    41.317     0.200
     6.849    44.513     0.200
     6.944    44.809     0.200
     0.212     2.382     0.200
     0.953     6.830     0.200
     1.856    12.585     0.200
     2.457    16.178     0.200
     2.594    16.287     0.200
     3.633    22.952     0.200
     4.114    26.640     0.200
     4.420    28.569     0.200
     0.216     1.746     0.200
     0.216     1.945     0.200
     0.934     6.868     0.200
     1.469     9.921     0.200
     2.447    16.508     0.200
     2.447    16.809     0.200
     2.613    16.379     0.200
     2.613    16.480     0.200
     2.716    18.079     0.200
     2.899    19.038     0.200
     3.613    23.501     0.200
     3.613    23.603     0.200
     3.715    24.313     0.200
     4.438    29.077     0.200
     4.991    31.925     0.200
     0.216     1.845     0.200
     0.939     6.608     0.200
     1.464     9.877     0.200
     1.841    12.184     0.200
     2.448    16.595     0.200
     2.609    16.425     0.200
     2.894    18.992     0.200
     3.618    23.542     0.200
     4.052    26.085     0.200
     4.433    28.531     0.200
     6.862    43.989     0.200
     0.219     2.036     0.200
     0.948     6.934     0.200
     1.456     9.804     0.200
     1.456     9.905     0.200
     1.849    12.122     0.200
     2.448    15.834     0.200
     2.448    16.733     0.200
     2.604    16.108     0.200
     2.604    16.608     0.200
     2.702    17.862     0.200
     2.885    18.922     0.200
     3.626    23.479     0.200
     3.626    23.276     0.200
     3.701    23.899     0.200
     3.702    23.891     0.200
     4.043    25.611     0.200
     4.043    26.408     0.200
     4.424    28.359     0.200
     5.437    34.149     0.200
     5.906    38.073     0.200
     6.853    43.923     0.200
     7.844    49.362     0.200
     0.225     1.939     0.200
     0.954     6.830     0.200
     1.450    10.243     0.200
     1.854    12.231     0.200
     2.444    16.844     0.200
     2.602    16.702     0.200
     3.632    23.674     0.200
     3.696    23.837     0.200
     4.037    26.052     0.200
     4.125    26.733     0.200
     4.417    28.218     0.200
     4.972    32.247     0.200
     0.204     2.016     0.200
     0.956     7.241     0.200
     1.861    12.074     0.200
     2.466    16.023     0.200
     2.586    16.618     0.200
     2.693    17.572     0.200
     3.637    23.349     0.200
     4.105    26.188     0.200
     4.418    28.638     0.200
     0.227     2.076     0.200
     0.954     6.886     0.200
     1.451    10.193     0.200
     1.853    12.296     0.200
     2.442    16.223     0.200
     2.603    16.642     0.200
     2.696    17.856     0.200
     3.632    23.140     0.200
     3.696    23.791     0.200
     4.126    26.567     0.200
     4.417    28.373     0.200
     4.972    31.698     0.200
     5.427    34.784     0.200
     5.638    36.529     0.200
     0.219     2.020     0.200
     0.954     6.851     0.200
     1.450    10.056     0.200
     1.855    12.136     0.200
     2.449    16.095     0.200
     2.599    16.454     0.200
     2.599    16.653     0.200
     3.632    23.391     0.200
     3.632    23.191     0.200
     4.037    26.363     0.200
     4.120    26.894     0.200
     4.419    27.814     0.200
     4.972    32.259     0.200
     5.911    35.800     0.200
     0.361     3.114     0.200
     1.165     8.328     0.200
     1.251     8.527     0.200
     2.047    13.341     0.200
     2.445    16.091     0.200
     2.481    15.674     0.200
     2.491    16.452     0.200
     2.665    17.522     0.200
     3.833    24.093     0.200
     4.770    30.856     0.200
     5.425    34.912     0.200
     0.369     3.010     0.200
     1.170     8.565     0.200
     1.247     8.666     0.200
     2.050    13.601     0.200
     2.050    13.703     0.200
     2.439    15.958     0.200
     2.439    16.359     0.200
     2.482    15.852     0.200
     2.487    16.899     0.200
     3.837    24.546     0.200
     0.207     2.046     0.200
     0.939     6.703     0.200
     1.463    10.094     0.200
     1.844    12.544     0.200
     2.458    16.581     0.200
     2.602    16.594     0.200
     3.620    23.516     0.200
     3.708    23.793     0.200
     4.050    26.397     0.200
     4.119    26.696     0.200
     0.237     1.912     0.200
     0.950     6.895     0.200
     1.457    10.471     0.200
     1.845    12.440     0.200
     2.431    16.712     0.200
     2.614    16.668     0.200
     3.625    23.773     0.200
     4.044    26.387     0.200
     4.138    26.781     0.200
     4.421    29.085     0.200
     0.372     2.941     0.200
     1.245     8.644     0.200
     1.173     8.393     0.200
     2.052    12.333     0.200
     2.052    13.633     0.200
     2.439    16.413     0.200
     2.485    15.679     0.200
     2.485    16.980     0.200
     2.481    15.718     0.200
     2.481    15.819     0.200
     2.657    17.370     0.200
     2.657    17.472     0.200
     3.490    22.750     0.200
     3.828    24.108     0.200
     3.839    24.374     0.200
     4.196    27.304     0.200
     4.764    30.778     0.200
     5.237    32.555     0.200
     5.416    35.070     0.200
     6.625    42.666     0.200
     8.115    49.340     0.200
     0.225     1.942     0.200
     0.943     6.858     0.200
     1.461    10.513     0.200
     1.843    12.561     0.200
     2.441    16.383     0.200
     2.611    16.596     0.200
     2.707    17.775     0.200
     2.889    19.054     0.200
     4.132    26.950     0.200
     0.224     1.890     0.200
     0.946     6.757     0.200
     1.458    10.586     0.200
     1.846    13.757     0.200
     2.443    16.492     0.200
     2.608    16.568     0.200
     3.624    23.507     0.200
     0.210     2.062     0.200
     0.938     6.660     0.200
     1.464    10.320     0.200
     1.842    13.307     0.200
     2.455    16.157     0.200
     2.605    16.713     0.200
     3.619    22.881     0.200
     4.122    26.510     0.200
     4.435    28.858     0.200
     4.986    32.121     0.200
     0.221     1.842     0.200
     0.940     6.650     0.200
     1.464    10.244     0.200
     2.444    16.203     0.200
     2.444    16.402     0.200
     2.611    16.357     0.200
     2.611    16.755     0.200
     3.619    23.293     0.200
     3.709    24.242     0.200
     4.051    25.751     0.200
     4.051    26.450     0.200
     4.431    28.709     0.200
     4.431    28.510     0.200
     5.440    35.437     0.200
     5.898    38.087     0.200
     6.860    43.669     0.200
     6.860    44.368     0.200
     0.215     1.876     0.200
     1.459     9.857     0.200
     1.847    12.326     0.200
     2.451    16.469     0.200
     2.603    16.201     0.200
     2.603    16.602     0.200
     2.705    17.711     0.200
     3.624    23.188     0.200
     3.704    24.256     0.200
     4.428    28.804     0.200
     4.428    28.503     0.200
     7.849    49.480     0.200
     0.689     5.361     0.200
     0.689     5.259     0.200
     1.131     8.201     0.200
     1.409     9.956     0.200
     2.266    15.856     0.200
     2.266    15.957     0.200
     2.322    16.101     0.200
     2.538    16.378     0.200
     2.538    16.480     0.200
     3.666    23.621     0.200
     4.016    25.835     0.200
     4.016    26.132     0.200
     6.390    40.834     0.200
     6.396    41.664     0.200
     6.396    41.464     0.200
     7.334    45.413     0.200
     0.660     5.089     0.200
     1.394     9.617     0.200
     2.209    14.604     0.200
     2.209    14.307     0.200
     2.292    15.538     0.200
     2.325    15.753     0.200
     2.519    16.491     0.200
     2.519    15.991     0.200
     3.669    23.568     0.200
     4.009    26.194     0.200
     4.009    25.296     0.200
     3.984    25.388     0.200
     7.173    46.180     0.200
     7.363    46.261     0.200
     8.394    49.643     0.200
     0.679     5.236     0.200
     1.129     7.984     0.200
     1.404     9.974     0.200
     2.213    15.731     0.200
     2.276    15.897     0.200
     2.323    16.551     0.200
     2.435    16.235     0.200
     2.531    16.526     0.200
     4.014    25.811     0.200
     4.607    29.992     0.200
     0.673     5.300     0.200
     1.125     7.915     0.200
     1.402     9.882     0.200
     2.214    15.114     0.200
     2.321    16.159     0.200
     2.284    15.800     0.200
     2.436    16.319     0.200
     2.524    16.590     0.200
     0.894     6.853     0.200
     1.178     8.938     0.200
     1.793    11.358     0.200
     3.094    20.277     0.200
     3.094    19.978     0.200
     3.587    23.521     0.200
     4.162    26.612     0.200
     6.791    44.328     0.200
     0.681     5.195     0.200
     1.123     8.136     0.200
     1.409    10.198     0.200
     2.219    15.053     0.200
     2.280    15.843     0.200
     2.317    16.203     0.200
     2.430    16.383     0.200
     2.526    16.561     0.200
     0.670     5.179     0.200
     0.670     5.079     0.200
     1.120     8.029     0.200
     1.404    10.011     0.200
     2.291    15.460     0.200
     2.291    15.260     0.200
     2.218    13.914     0.200
     2.218    15.515     0.200
     2.317    15.960     0.200
     2.317    15.759     0.200
     2.433    16.100     0.200
     2.433    16.000     0.200
     2.517    16.522     0.200
     3.661    23.476     0.200
     3.661    23.275     0.200
     3.975    26.012     0.200
     3.975    25.712     0.200
     4.018    26.301     0.200
     6.395    41.063     0.200
     8.405    49.414     0.200
     1.122     7.250     0.200
     1.395     9.158     0.200
     2.212    13.128     0.200
     2.212    13.526     0.200
     2.298    14.525     0.200
     2.513    15.715     0.200
     2.440    15.359     0.200
     3.665    22.865     0.200
     3.665    22.564     0.200
     4.012    25.817     0.200
     4.012    25.419     0.200
     3.982    25.773     0.200
     3.982    25.672     0.200
     4.606    28.889     0.200
     5.175    33.146     0.200
     5.175    33.045     0.200
     6.406    40.586     0.200
     6.406    41.086     0.200
     6.404    40.508     0.200
     6.892    42.907     0.200
     8.393    49.888     0.200
     0.237     2.071     0.200
     0.962     6.998     0.200
     1.444    10.283     0.200
     1.859    12.244     0.200
     2.435    16.717     0.200
     2.603    16.853     0.200
     2.689    17.850     0.200
     3.638    22.475     0.200
     3.689    23.778     0.200
     4.030    26.097     0.200
     4.408    28.588     0.200
     6.837    43.747     0.200
     0.659     5.219     0.200
     1.132     7.709     0.200
     1.390     9.988     0.200
     2.204    13.793     0.200
     2.287    15.516     0.200
     2.330    15.920     0.200
     2.447    16.757     0.200
     2.524    16.357     0.200
     3.674    23.540     0.200
     4.005    25.179     0.200
     5.180    33.655     0.200
     6.412    41.691     0.200
     6.884    43.676     0.200
     8.392    47.594     0.200
     0.668     5.154     0.200
     1.118     7.902     0.200
     1.404     9.758     0.200
     2.219    14.750     0.200
     2.294    15.467     0.200
     2.433    16.157     0.200
     2.514    16.406     0.200
     4.019    25.339     0.200
     0.663     5.148     0.200
     1.133     7.761     0.200
     1.391     9.646     0.200
     2.204    14.265     0.200
     2.204    13.163     0.200
     2.204    14.367     0.200
     2.330    15.585     0.200
     2.330    15.483     0.200
     2.283    15.235     0.200
     2.283    15.133     0.200
     2.527    16.185     0.200
     3.351    21.676     0.200
     3.674    23.205     0.200
     3.674    23.104     0.200
     4.005    25.048     0.200
     3.988    25.642     0.200
     7.399    47.134     0.200
     8.395    49.283     0.200
     0.690     5.442     0.200
     1.140     7.888     0.200
     1.404    10.002     0.200
     2.207    15.130     0.200
     2.257    15.955     0.200
     2.330    15.999     0.200
     2.548    16.462     0.200
     0.689     5.371     0.200
     1.122     8.211     0.200
     1.414    10.102     0.200
     2.222    15.076     0.200
     2.275    15.963     0.200
     2.314    16.100     0.200
     2.529    16.695     0.200
     3.967    26.015     0.200
     4.023    26.456     0.200
     6.390    41.542     0.200
     0.654     5.124     0.200
     1.111     7.691     0.200
     1.399     9.719     0.200
     2.312    15.666     0.200
     2.220    14.143     0.200
     2.220    14.743     0.200
     2.499    16.186     0.200
     4.020    25.737     0.200
     4.597    29.604     0.200
     6.487    42.048     0.200
     0.674     5.152     0.200
     1.109     7.585     0.200
     1.413     9.927     0.200
     2.298    15.708     0.200
     2.306    15.921     0.200
     2.508    16.358     0.200
     3.964    25.659     0.200
     4.029    25.708     0.200
     4.590    29.556     0.200
     0.677     5.205     0.200
     1.110     7.950     0.200
     1.414    10.104     0.200
     2.228    14.302     0.200
     2.294    15.835     0.200
     2.306    15.890     0.200
     2.511    16.604     0.200
     3.650    24.011     0.200
     4.029    26.093     0.200
     4.591    29.432     0.200
     0.681     5.487     0.200
     1.129     7.465     0.200
     2.214    14.197     0.200
     2.274    15.695     0.200
     2.322    16.239     0.200
     2.532    16.491     0.200
     3.666    23.358     0.200
     3.975    25.944     0.200
     0.466     3.481     0.200
     1.596    11.001     0.200
     2.059    12.396     0.200
     2.059    13.197     0.200
     2.059    13.396     0.200
     2.722    17.060     0.200
     2.939    18.722     0.200
     2.939    18.921     0.200
     5.704    36.357     0.200
     6.755    43.395     0.200
     6.991    44.738     0.200
     0.667     5.265     0.200
     0.667     5.164     0.200
     1.139     7.767     0.200
     1.391     9.721     0.200
     2.201    14.968     0.200
     2.275    15.807     0.200
     2.334    15.712     0.200
     2.535    16.167     0.200
     2.535    16.269     0.200
     3.678    23.330     0.200
     3.990    26.298     0.200
     4.619    30.250     0.200
     6.641    42.856     0.200
     8.397    51.396     0.200
     0.687     5.381     0.200
     1.110     7.843     0.200
     1.421    10.319     0.200
     2.232    15.553     0.200
     2.287    15.904     0.200
     2.516    16.339     0.200
     0.653     4.997     0.200
     1.124     7.802     0.200
     1.391     9.593     0.200
     2.208    15.252     0.200
     2.299    15.292     0.200
     2.513    16.493     0.200
     3.669    23.607     0.200
     4.009    25.443     0.200
     6.410    41.119     0.200
     0.659     5.014     0.200
     1.122     7.805     0.200
     1.396     9.917     0.200
     2.212    13.392     0.200
     2.212    14.591     0.200
     2.297    15.703     0.200
     2.322    15.809     0.200
     2.514    16.363     0.200
     3.342    21.707     0.200
     3.666    23.925     0.200
     6.406    41.251     0.200
     0.699     5.378     0.200
     1.129     8.061     0.200
     1.417    10.002     0.200
     2.220    14.334     0.200
     2.260    15.362     0.200
     2.318    15.985     0.200
     2.541    16.381     0.200
     3.662    23.410     0.200
     4.022    25.810     0.200
     4.603    29.827     0.200
     6.389    41.380     0.200
     0.701     5.412     0.200
     1.092     8.353     0.200
     1.441     9.983     0.200
     2.252    14.814     0.200
     2.284    16.040     0.200
     2.295    15.615     0.200
     2.504    16.278     0.200
     4.053    25.896     0.200
     0.662     5.044     0.200
     1.116     7.948     0.200
     1.401    10.416     0.200
     2.218    15.483     0.200
     2.315    15.953     0.200
     2.300    15.727     0.200
     2.509    16.388     0.200
     4.600    30.090     0.200
     0.664     5.022     0.200
     0.664     5.222     0.200
     1.141     7.952     0.200
     1.141     7.651     0.200
     1.387     9.677     0.200
     2.198    14.420     0.200
     2.276    15.605     0.200
     2.276    15.406     0.200
     2.337    16.087     0.200
     2.536    16.475     0.200
     2.536    16.772     0.200
     3.358    21.978     0.200
     3.681    23.607     0.200
     3.681    23.506     0.200
     3.998    26.201     0.200
     3.993    25.967     0.200
     4.622    29.629     0.200
     6.501    41.595     0.200
     7.360    46.477     0.200
     0.656     5.035     0.200
     1.143     7.746     0.200
     1.381     9.574     0.200
     2.193    14.196     0.200
     2.280    15.285     0.200
     2.341    15.765     0.200
     2.534    16.614     0.200
     3.685    23.580     0.200
     3.994    25.580     0.200
     0.658     4.925     0.200
     0.658     5.230     0.200
     1.129     7.731     0.200
     1.391     9.574     0.200
     2.206    14.165     0.200
     2.291    15.670     0.200
     2.291    15.568     0.200
     2.328    15.740     0.200
     2.521    16.288     0.200
     4.006    26.052     0.200
     5.180    33.654     0.200
     6.411    41.491     0.200
     7.365    46.956     0.200
     0.658     5.108     0.200
     1.144     8.034     0.200
     1.381     9.660     0.200
     2.193    14.086     0.200
     2.278    15.304     0.200
     2.341    15.957     0.200
     2.536    16.291     0.200
     3.685    23.578     0.200
     4.626    29.694     0.200
     0.697     5.450     0.200
     1.099     8.059     0.200
     1.434    10.051     0.200
     2.244    14.889     0.200
     2.291    16.240     0.200
     2.291    16.347     0.200
     2.509    16.406     0.200
     3.313    21.225     0.200
     3.635    24.059     0.200
     4.045    26.473     0.200
     5.137    33.533     0.200
     0.689     5.172     0.200
     1.105     7.611     0.200
     1.425    10.383     0.200
     2.236    14.207     0.200
     2.236    15.207     0.200
     2.291    16.171     0.200
     2.291    15.972     0.200
     2.299    16.178     0.200
     2.511    16.300     0.200
     2.511    16.101     0.200
     3.643    23.996     0.200
     3.955    26.057     0.200
     4.037    26.093     0.200
     4.584    30.017     0.200
     7.367    47.540     0.200
     8.425    51.330     0.200
     0.692     5.331     0.200
     1.098     7.793     0.200
     1.431    10.212     0.200
     2.243    14.932     0.200
     2.292    15.562     0.200
     2.295    16.134     0.200
     2.506    16.365     0.200
     4.044    26.216     0.200
     0.660     5.055     0.200
     1.153     8.104     0.200
     1.377     9.988     0.200
     2.186    14.252     0.200
     2.267    15.910     0.200
     2.349    16.046     0.200
     2.547    16.641     0.200
     3.693    24.164     0.200
     3.987    25.834     0.200
     5.193    33.761     0.200
     6.427    41.463     0.200
     0.666     5.179     0.200
     1.142     8.230     0.200
     1.388    10.054     0.200
     2.198    14.506     0.200
     2.273    16.029     0.200
     2.337    16.276     0.200
     2.538    16.836     0.200
     3.681    23.994     0.200
     3.999    25.889     0.200
     4.622    29.815     0.200
     0.655     5.154     0.200
     1.142     8.068     0.200
     1.381     9.877     0.200
     2.194    14.588     0.200
     2.282    15.864     0.200
     2.340    16.184     0.200
     2.532    16.744     0.200
     3.684    23.698     0.200
     3.995    25.176     0.200
     0.705     5.357     0.200
     1.118     7.832     0.200
     1.427    10.122     0.200
     2.232    15.637     0.200
     2.232    14.637     0.200
     2.267    16.020     0.200
     2.267    15.720     0.200
     2.307    16.061     0.200
     2.532    16.328     0.200
     2.532    16.928     0.200
     3.956    26.118     0.200
     4.033    26.414     0.200
     0.689     5.288     0.200
     1.113     8.141     0.200
     2.230    14.510     0.200
     2.283    15.492     0.200
     2.520    16.320     0.200
     0.696     5.365     0.200
     1.123     8.178     0.200
     2.224    14.831     0.200
     2.269    16.009     0.200
     2.533    16.521     0.200
     3.657    24.209     0.200
     4.025    26.109     0.200
     0.695     5.352     0.200
     1.090     7.837     0.200
     2.251    15.790     0.200
     2.301    15.708     0.200
     2.499    16.799     0.200
     3.628    23.521     0.200
     0.662     5.090     0.200
     1.138     8.040     0.200
     1.388     9.816     0.200
     2.200    14.843     0.200
     2.280    15.711     0.200
     2.532    16.670     0.200
     4.001    26.227     0.200
     0.679     5.286     0.200
     1.103     8.047     0.200
     1.420     9.944     0.200
     2.235    15.831     0.200
     2.299    15.982     0.200
     2.300    15.969     0.200
     2.504    16.694     0.200
     4.036    26.115     0.200
     0.711     5.429     0.200
     1.114     8.135     0.200
     1.434    10.289     0.200
     2.238    15.113     0.200
     2.267    15.975     0.200
     2.301    16.579     0.200
     2.531    16.795     0.200
     0.698     5.332     0.200
     1.090     7.961     0.200
     1.440    10.279     0.200
     2.252    15.396     0.200
     2.283    16.036     0.200
     2.299    15.954     0.200
     2.500    16.606     0.200
     0.740     5.456     0.200
     1.122     8.301     0.200
     1.449    10.479     0.200
     2.243    14.619     0.200
     2.552    16.805     0.200
     4.584    29.792     0.200
     6.361    41.163     0.200
     0.764     5.912     0.200
     1.152     8.885     0.200
     2.229    15.519     0.200
     2.198    15.284     0.200
     2.593    17.072     0.200
     3.949    26.039     0.200
     0.689     5.319     0.200
     1.122     7.868     0.200
     1.415    10.048     0.200
     2.223    14.722     0.200
     2.275    15.812     0.200
     2.529    16.351     0.200
     3.657    24.176     0.200
     0.679     5.140     0.200
     1.124     7.555     0.200
     1.408     9.844     0.200
     2.218    15.789     0.200
     2.280    15.359     0.200
     2.526    16.391     0.200
     4.019    25.772     0.200
     0.698     5.405     0.200
     1.118     8.003     0.200
     1.423    10.339     0.200
     2.272    16.028     0.200
     2.229    14.829     0.200
     2.229    15.735     0.200
     2.529    16.834     0.200
     3.652    23.832     0.200
     3.959    25.846     0.200
     4.592    30.156     0.200
     6.466    42.191     0.200
     7.325    47.562     0.200
     0.690     5.247     0.200
     1.090     7.886     0.200
     1.435    10.064     0.200
     2.249    15.055     0.200
     2.304    15.724     0.200
     2.304    15.825     0.200
     2.285    15.042     0.200
     2.285    16.042     0.200
     2.497    16.169     0.200
     3.629    23.757     0.200
     3.943    25.789     0.200
     4.050    25.541     0.200
     4.570    29.576     0.200
     5.136    33.366     0.200
     0.721     5.562     0.200
     1.122     8.182     0.200
     1.436    10.425     0.200
     2.235    15.306     0.200
     2.252    16.203     0.200
     2.306    16.168     0.200
     2.545    16.585     0.200
     3.649    24.097     0.200
     4.036    25.876     0.200
     0.710     5.487     0.200
     1.103     7.896     0.200
     1.440    10.474     0.200
     2.246    15.566     0.200
     2.292    15.720     0.200
     2.277    15.894     0.200
     2.520    16.662     0.200
     3.942    25.963     0.200
     4.047    26.240     0.200
     5.131    33.499     0.200
     6.365    41.192     0.200
     0.696     5.383     0.200
     0.696     5.282     0.200
     1.102     7.643     0.200
     1.102     7.542     0.200
     1.431     9.901     0.200
     2.289    15.286     0.200
     2.294    15.523     0.200
     2.242    13.636     0.200
     2.242    15.136     0.200
     2.511    16.297     0.200
     2.511    15.797     0.200
     3.638    23.741     0.200
     3.638    23.444     0.200
     6.372    41.245     0.200
     0.708     5.516     0.200
     1.111     8.711     0.200
     1.434    10.143     0.200
     2.239    14.556     0.200
     2.300    16.039     0.200
     2.271    16.176     0.200
     2.527    16.586     0.200
     3.949    25.995     0.200
     4.584    30.083     0.200
     6.371    41.226     0.200
     0.714     5.512     0.200
     1.100     7.806     0.200
     1.444     9.994     0.200
     2.250    14.490     0.200
     2.250    15.294     0.200
     2.288    16.036     0.200
     2.277    15.768     0.200
     2.519    16.449     0.200
     3.632    23.859     0.200
     0.701     5.316     0.200
     0.701     5.417     0.200
     1.108     7.769     0.200
     1.431    10.097     0.200
     2.279    15.795     0.200
     2.279    15.596     0.200
     2.239    15.371     0.200
     2.298    16.075     0.200
     2.520    16.487     0.200
     3.642    23.896     0.200
     4.583    29.816     0.200
     0.712     5.520     0.200
     1.099     7.902     0.200
     1.443    10.088     0.200
     2.250    15.177     0.200
     2.279    15.632     0.200
     2.517    16.559     0.200
     3.631    23.955     0.200
     4.051    26.355     0.200
     0.706     5.422     0.200
     1.106     7.755     0.200
     1.435    10.108     0.200
     2.242    14.694     0.200
     2.278    15.578     0.200
     2.295    15.874     0.200
     2.520    16.346     0.200
     4.043    25.673     0.200
     0.667     5.191     0.200
     1.123     8.070     0.200
     1.400    10.139     0.200
     2.214    14.644     0.200
     2.289    16.162     0.200
     2.321    15.996     0.200
     2.519    16.777     0.200
     4.014    26.232     0.200
     0.713     5.469     0.200
     1.096     8.204     0.200
     1.446    10.212     0.200
     2.253    15.496     0.200
     2.285    16.129     0.200
     2.282    16.051     0.200
     3.935    25.966     0.200
     4.569    29.868     0.200
     0.700     5.287     0.200
     1.108     7.733     0.200
     1.431    10.162     0.200
     2.298    15.937     0.200
     2.280    15.947     0.200
     2.280    15.248     0.200
     2.239    15.334     0.200
     2.519    16.756     0.200
     3.642    23.858     0.200
     0.710     5.382     0.200
     1.103     7.996     0.200
     1.440    10.261     0.200
     2.246    16.250     0.200
     2.291    16.122     0.200
     2.278    15.877     0.200
     3.942    25.763     0.200
     4.048    26.628     0.200
     0.720     5.561     0.200
     1.102     8.208     0.200
     1.447    10.176     0.200
     2.251    15.399     0.200
     2.288    15.666     0.200
     2.272    16.057     0.200
     2.523    16.721     0.200
     3.631    23.991     0.200
     4.572    29.909     0.200
     0.708     5.478     0.200
     1.103     7.870     0.200
     1.439    10.352     0.200
     2.245    14.738     0.200
     2.292    16.590     0.200
     2.279    16.046     0.200
     2.519    16.447     0.200
     3.314    21.369     0.200
     3.636    23.815     0.200
     3.943    26.030     0.200
     4.047    26.416     0.200
     6.365    41.457     0.200
     0.696     5.378     0.200
     1.091     7.771     0.200
     1.438    10.018     0.200
     2.251    15.429     0.200
     2.284    16.241     0.200
     2.300    16.062     0.200
     2.399    16.299     0.200
     2.500    16.426     0.200
     6.595    42.739     0.200
     0.700     5.267     0.200
     0.700     5.467     0.200
     1.090     7.821     0.200
     1.090     8.023     0.200
     1.441    10.120     0.200
     2.282    16.002     0.200
     2.297    15.927     0.200
     2.297    15.826     0.200
     2.396    16.172     0.200
     2.396    16.274     0.200
     2.253    14.741     0.200
     2.501    16.153     0.200
     2.501    16.554     0.200
     3.626    23.422     0.200
     4.054    26.125     0.200
     4.567    29.943     0.200
     5.129    32.378     0.200
     6.358    40.938     0.200
     7.323    46.675     0.200
     0.685     5.215     0.200
     1.090     7.600     0.200
     1.432    10.006     0.200
     2.248    14.579     0.200
     2.286    15.839     0.200
     2.308    15.679     0.200
     2.404    16.064     0.200
     2.493    15.918     0.200
     3.630    23.655     0.200
     4.571    29.777     0.200
     0.673     5.190     0.200
     1.110     7.776     0.200
     1.411     9.765     0.200
     2.226    14.557     0.200
     2.298    15.422     0.200
     2.308    15.804     0.200
     2.509    16.059     0.200
     4.027    26.240     0.200
     0.217     2.122     0.200
     0.951     6.953     0.200
     1.452    10.009     0.200
     1.853    12.327     0.200
     2.451    16.250     0.200
     2.451    16.149     0.200
     2.599    16.626     0.200
     3.630    23.585     0.200
     3.697    24.007     0.200
     4.039    25.917     0.200
     4.974    31.814     0.200
     5.911    37.977     0.200
     0.697     5.392     0.200
     1.103     7.943     0.200
     1.431    10.223     0.200
     2.241    15.374     0.200
     2.295    16.032     0.200
     2.287    16.238     0.200
     2.514    16.589     0.200
     3.317    21.817     0.200
     3.639    23.852     0.200
     4.042    25.950     0.200
     4.580    30.075     0.200
     0.353     3.064     0.200
     1.252     8.471     0.200
     2.045    13.520     0.200
     2.452    15.976     0.200
     2.477    15.676     0.200
     2.494    16.287     0.200
     0.650     5.115     0.200
     1.142     7.980     0.200
     1.378     9.722     0.200
     2.192    14.220     0.200
     2.285    15.539     0.200
     2.341    15.881     0.200
     2.530    16.576     0.200
     3.685    24.094     0.200
     3.993    25.106     0.200
     4.626    30.117     0.200
     0.666     5.071     0.200
     1.378     9.760     0.200
     2.184    14.155     0.200
     2.259    15.986     0.200
     2.554    16.440     0.200
     3.985    25.635     0.200
     4.004    26.214     0.200
     5.192    33.953     0.200
     6.511    41.959     0.200
     0.224     2.054     0.200
     1.443    10.223     0.200
     1.861    12.250     0.200
     2.448    16.203     0.200
     2.595    16.580     0.200
     3.639    23.198     0.200
     3.689    23.919     0.200
     4.030    25.629     0.200
     4.965    31.723     0.200
     0.633     4.922     0.200
     1.196     8.444     0.200
     1.332     9.554     0.200
     2.140    14.035     0.200
     2.250    15.747     0.200
     2.395    16.354     0.200
     2.509    16.824     0.200
     2.576    16.739     0.200
     3.739    23.969     0.200
     6.473    42.168     0.200
     0.660     5.095     0.200
     1.125     7.669     0.200
     1.395     9.727     0.200
     2.293    15.647     0.200
     2.324    15.881     0.200
     2.210    15.314     0.200
     2.442    16.104     0.200
     2.518    16.515     0.200
     3.344    21.776     0.200
     3.668    23.695     0.200
     3.983    26.116     0.200
     4.949    32.244     0.200
     6.407    41.633     0.200
     0.676     5.292     0.200
     1.120     7.809     0.200
     2.315    15.659     0.200
     2.286    15.598     0.200
     2.220    14.075     0.200
     2.430    16.216     0.200
     2.520    16.166     0.200
     3.659    23.476     0.200
     4.020    25.360     0.200
     4.600    29.595     0.200
     6.006    38.691     0.200
     7.161    46.012     0.200
     0.695     5.386     0.200
     1.111     8.026     0.200
     1.425    10.164     0.200
     2.234    14.727     0.200
     2.281    16.175     0.200
     2.303    16.317     0.200
     2.414    16.413     0.200
     2.520    16.478     0.200
     3.646    23.836     0.200
     4.035    26.504     0.200
     1.533    10.323     0.200
     1.533    11.119     0.200
     1.774    11.905     0.200
     2.199    15.240     0.200
     2.792    17.822     0.200
     2.884    18.949     0.200
     3.572    22.623     0.200
     0.662     5.052     0.200
     1.112     7.592     0.200
     1.112     7.492     0.200
     2.221    14.452     0.200
     2.304    15.684     0.200
     2.304    15.284     0.200
     2.312    15.791     0.200
     2.505    16.238     0.200
     3.332    21.790     0.200
     4.021    25.543     0.200
     3.973    25.303     0.200
     5.168    32.966     0.200
     6.397    40.816     0.200
     6.484    41.909     0.200
     0.669     5.109     0.200
     1.091     7.386     0.200
     1.421     9.737     0.200
     2.241    14.863     0.200
     2.291    15.578     0.200
     2.486    15.901     0.200
     3.635    23.794     0.200
     3.955    25.667     0.200
     5.151    33.412     0.200
     0.710     5.439     0.200
     1.091     7.790     0.200
     1.447    10.041     0.200
     2.256    15.198     0.200
     2.281    15.603     0.200
     2.289    15.609     0.200
     2.507    16.365     0.200
     0.229     2.084     0.200
     0.964     6.906     0.200
     1.441    10.341     0.200
     1.862    12.523     0.200
     2.443    16.441     0.200
     2.596    16.858     0.200
     0.232     2.121     0.200
     0.962     6.997     0.200
     1.444    10.274     0.200
     2.440    16.449     0.200
     2.600    16.779     0.200
     3.689    23.872     0.200
     4.030    26.290     0.200
     4.409    28.568     0.200
     6.838    44.227     0.200
     0.688     5.353     0.200
     1.104     7.705     0.200
     1.425    10.152     0.200
     2.293    15.730     0.200
     2.298    15.871     0.200
     2.298    16.170     0.200
     2.412    16.134     0.200
     2.509    16.298     0.200
     2.509    16.099     0.200
     3.642    23.587     0.200
     3.954    25.945     0.200
     4.921    30.860     0.200
     6.377    41.367     0.200
     7.335    46.888     0.200
     0.948     7.061     0.200
     1.450    10.192     0.200
     2.138    14.174     0.200
     2.200    15.449     0.200
     2.429    16.475     0.200
     2.723    18.140     0.200
     3.535    23.163     0.200
     3.958    25.833     0.200
     7.469    48.061     0.200
     0.546     4.245     0.200
     0.933     6.726     0.200
     1.464    10.123     0.200
     2.185    15.216     0.200
     2.136    13.992     0.200
     2.136    13.692     0.200
     2.412    16.568     0.200
     2.412    16.269     0.200
     2.381    15.025     0.200
     2.381    15.824     0.200
     2.718    17.896     0.200
     3.521    22.823     0.200
     3.941    25.069     0.200
     4.453    28.853     0.200
     5.197    33.663     0.200
     6.477    41.323     0.200
     0.531     4.117     0.200
     0.947     6.857     0.200
     1.451    10.077     0.200
     2.140    14.035     0.200
     2.199    15.245     0.200
     2.369    15.158     0.200
     2.427    16.081     0.200
     2.720    18.068     0.200
     3.956    25.937     0.200
     6.386    41.087     0.200
     0.543     4.159     0.200
     0.935     6.687     0.200
     0.935     6.888     0.200
     2.132    13.619     0.200
     2.132    13.319     0.200
     2.381    15.004     0.200
     2.415    16.407     0.200
     2.724    18.106     0.200
     3.522    22.486     0.200
     3.944    25.867     0.200
     4.454    28.619     0.200
     0.547     4.289     0.200
     0.935     6.956     0.200
     1.462    10.212     0.200
     2.149    14.094     0.200
     2.186    15.557     0.200
     2.376    15.846     0.200
     2.409    16.460     0.200
     2.701    17.841     0.200
     3.178    20.987     0.200
     3.939    25.898     0.200
     6.369    40.648     0.200
     0.546     4.243     0.200
     0.932     7.032     0.200
     1.466    10.205     0.200
     2.129    14.264     0.200
     2.184    15.225     0.200
     2.384    15.387     0.200
     2.413    16.350     0.200
     2.726    18.004     0.200
     3.520    23.035     0.200
     3.934    25.352     0.200
     4.451    29.167     0.200
     6.032    38.819     0.200
     6.401    41.608     0.200
     0.551     4.193     0.200
     0.930     6.674     0.200
     1.467    10.206     0.200
     2.181    14.570     0.200
     2.143    14.214     0.200
     2.405    16.061     0.200
     2.381    15.037     0.200
     2.706    17.745     0.200
     3.952    24.560     0.200
     4.156    26.120     0.200
     4.450    28.891     0.200
     0.215     2.019     0.200
     0.941     6.658     0.200
     1.463    10.166     0.200
     1.843    12.130     0.200
     2.450    16.348     0.200
     2.607    16.612     0.200
     2.709    17.720     0.200
     6.860    44.274     0.200
     0.720     5.523     0.200
     1.101     8.179     0.200
     2.252    14.844     0.200
     2.287    16.437     0.200
     2.273    16.305     0.200
     2.394    16.792     0.200
     2.522    16.693     0.200
     3.935    25.706     0.200
     4.054    26.625     0.200
     4.571    29.983     0.200
     6.357    41.039     0.200
     0.696     5.291     0.200
     1.091     7.880     0.200
     2.250    14.956     0.200
     2.298    15.698     0.200
     2.285    16.152     0.200
     2.399    16.115     0.200
     2.501    16.432     0.200
     3.629    23.970     0.200
     4.051    26.538     0.200
     4.355    27.496     0.200
     1.055     7.319     0.200
     2.242    15.266     0.200
     2.352    15.573     0.200
     2.306    15.315     0.200
     2.296    14.035     0.200
     2.482    16.057     0.200
     3.585    22.888     0.200
     3.894    25.386     0.200
     4.097    26.514     0.200
     4.347    27.796     0.200
     0.897     6.573     0.200
     1.026     7.859     0.200
     2.073    14.642     0.200
     2.318    16.076     0.200
     2.441    16.145     0.200
     0.324     2.826     0.200
     1.098     7.988     0.200
     1.318     9.125     0.200
     1.980    13.303     0.200
     2.423    16.024     0.200
     2.532    16.155     0.200
     2.731    17.836     0.200
     3.765    23.862     0.200
     3.901    25.175     0.200
     0.707     5.518     0.200
     0.995     7.260     0.200
     1.499    10.281     0.200
     2.332    14.953     0.200
     2.198    14.715     0.200
     2.390    15.878     0.200
     2.401    15.546     0.200
     2.330    15.773     0.200
     4.131    26.362     0.200
     4.908    31.591     0.200
     5.077    32.325     0.200
     6.297    40.676     0.200
     0.633     5.093     0.200
     0.633     4.793     0.200
     1.081     7.762     0.200
     2.239    14.449     0.200
     2.291    15.641     0.200
     2.291    15.841     0.200
     2.358    16.259     0.200
     2.358    16.059     0.200
     2.425    16.381     0.200
     2.456    16.017     0.200
     3.308    21.470     0.200
     3.635    23.250     0.200
     3.635    23.450     0.200
     3.966    25.993     0.200
     4.037    26.162     0.200
     5.169    33.455     0.200
     6.011    38.934     0.200
     6.392    40.987     0.200
     6.397    41.522     0.200
     8.380    52.186     0.200
     0.591     4.902     0.200
     0.591     4.800     0.200
     0.889     6.428     0.200
     0.889     6.326     0.200
     2.110    13.870     0.200
     2.140    14.322     0.200
     2.140    14.622     0.200
     2.423    14.822     0.200
     2.367    15.575     0.200
     2.727    17.167     0.200
     3.131    20.160     0.200
     3.477    22.422     0.200
     4.198    26.905     0.200
     5.151    32.980     0.200
     0.954     7.556     0.200
     1.163     8.217     0.200
     1.900    13.514     0.200
     2.186    14.272     0.200
     6.144    39.282     0.200
     1.095     7.689     0.200
     1.444    10.016     0.200
     2.252    14.482     0.200
     2.287    15.679     0.200
     2.396    16.110     0.200
     3.628    23.725     0.200
     0.552     4.403     0.200
     1.461    10.291     0.200
     2.166    13.974     0.200
     2.186    15.332     0.200
     2.371    15.781     0.200
     2.403    16.405     0.200
     3.524    23.117     0.200
     0.869     6.808     0.200
     0.930     6.402     0.200
     1.642    10.889     0.200
     2.094    14.706     0.200
     2.352    15.799     0.200
     2.413    15.094     0.200
     2.449    15.669     0.200
     3.437    22.239     0.200
     4.251    27.337     0.200
     4.929    32.023     0.200
     0.868     6.644     0.200
     0.938     6.820     0.200
     1.637    11.570     0.200
     2.102    14.840     0.200
     2.202    15.175     0.200
     2.344    16.121     0.200
     2.421    15.613     0.200
     2.442    16.368     0.200
     0.866     6.566     0.200
     0.929     6.927     0.200
     1.640    11.532     0.200
     2.095    14.920     0.200
     2.197    15.122     0.200
     2.410    15.636     0.200
     2.355    16.188     0.200
     2.448    16.497     0.200
     3.437    22.456     0.200
     4.307    28.301     0.200
     0.917     6.978     0.200
     0.884     6.754     0.200
     2.179    15.252     0.200
     2.406    15.796     0.200
     0.883     6.761     0.200
     0.917     6.864     0.200
     2.180    15.541     0.200
     2.406    15.589     0.200
     0.883     6.654     0.200
     0.933     6.863     0.200
     1.650    11.692     0.200
     2.189    15.098     0.200
     2.422    15.981     0.200
     8.634    52.228     0.200
     0.878     6.687     0.200
     0.913     7.083     0.200
     2.077    14.592     0.200
     2.180    15.192     0.200
     2.399    15.936     0.200
     2.365    16.341     0.200
     0.856     6.744     0.200
     0.935     6.616     0.200
     2.104    14.982     0.200
     2.208    15.371     0.200
     2.413    15.572     0.200
     2.353    16.271     0.200
     2.438    16.976     0.200
     4.308    27.638     0.200
     8.608    52.164     0.200
     0.855     6.531     0.200
     0.942     6.817     0.200
     2.212    15.300     0.200
     2.420    15.671     0.200
     2.346    16.232     0.200
     4.760    30.265     0.200
     0.945     6.624     0.200
     1.647    11.527     0.200
     2.101    15.329     0.200
     2.195    15.038     0.200
     2.447    16.695     0.200
     7.148    45.332     0.200
     1.502    11.122     0.200
     3.214    20.548     0.200
     4.288    26.037     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    16.142   202.948     0.200
    16.142   206.448     0.200
    18.687   247.639     0.200
    22.006   291.306     0.200
    18.567   243.248     0.200
    15.943   205.226     0.200
    18.531   242.019     0.200
     2.566    43.778     0.200
     3.781    56.999     0.200
     1.863    37.938     0.200
     3.133    53.119     0.200
     4.401    67.326     0.200
     4.818    74.658     0.200
     4.870    73.846     0.200
     5.635    78.918     0.200
     7.293   103.068     0.200
     5.019    73.591     0.200
     5.279    81.757     0.200
     5.461    79.938     0.200
     6.112    88.535     0.200
     7.579   104.720     0.200
     7.792   111.236     0.200
     8.142   112.157     0.200
    15.928   205.788     0.200
     2.197    39.126     0.200
     2.701    46.245     0.200
     3.131    47.224     0.200
     3.933    61.862     0.200
     4.874    75.479     0.200
     5.007    78.131     0.200
     5.132    78.875     0.200
     5.432    79.675     0.200
     6.090    86.497     0.200
     7.533   105.156     0.200
     1.455    30.781     0.200
     1.645    33.562     0.200
     1.708    33.926     0.200
     2.249    39.221     0.200
     3.971    61.721     0.200
     3.073    47.734     0.200
     5.400    77.581     0.200
    17.487   234.524     0.200
    18.892   247.125     0.200
     2.676    46.321     0.200
     3.647    58.487     0.200
     4.557    67.667     0.200
     5.473    78.678     0.200
     5.612    81.860     0.200
     7.920   106.626     0.200
     5.313    78.169     0.200
     7.087    98.165     0.200
     7.728   105.890     0.200
     7.786   108.314     0.200
    10.706   142.337     0.200
    12.147   160.216     0.200
    14.183   182.052     0.200
    15.269   191.486     0.200
    15.275   198.912     0.200
    16.663   220.218     0.200
    20.985   275.774     0.200
     5.449    79.275     0.200
     2.453    41.690     0.200
     2.574    44.590     0.200
     4.222    63.946     0.200
     5.487    80.546     0.200
     2.572    42.449     0.200
     3.838    56.875     0.200
     5.286    78.679     0.200
     3.857    57.693     0.200
     2.453    42.060     0.200
     4.228    64.350     0.200
     4.780    74.006     0.200
     2.679    42.404     0.200
     3.835    59.821     0.200
     4.793    70.483     0.200
     2.696    45.108     0.200
     1.209    28.021     0.200
     1.792    35.210     0.200
     1.792    35.909     0.200
     1.811    36.487     0.200
     2.574    44.592     0.200
     3.979    61.288     0.200
     4.489    68.735     0.200
     5.329    80.227     0.200
     6.053    85.270     0.200
     7.744   107.648     0.200
     9.136   123.899     0.200
     9.136   126.899     0.200
    10.262   140.258     0.200
    13.718   184.426     0.200
    20.467   269.665     0.200
     2.526    42.543     0.200
     3.827    56.464     0.200
     5.309    76.467     0.200
     7.726   106.171     0.200
     2.524    41.831     0.200
     3.818    56.439     0.200
     4.753    71.527     0.200
     5.299    77.653     0.200
     5.439    79.518     0.200
     3.857    60.740     0.200
     2.635    45.307     0.200
     2.505    43.872     0.200
     2.810    44.815     0.200
     3.956    62.438     0.200
     4.348    65.972     0.200
     4.891    69.736     0.200
     5.407    77.811     0.200
     5.577    80.124     0.200
     7.819   112.561     0.200
     9.227   128.326     0.200
     1.259    27.963     0.200
     2.442    41.753     0.200
     2.513    42.027     0.200
     5.515    83.153     0.200
     7.759   108.064     0.200
     1.742    36.115     0.200
     1.731    35.239     0.200
     2.633    45.716     0.200
     4.919    75.202     0.200
     2.866    44.740     0.200
     3.233    49.551     0.200
     3.953    58.353     0.200
     4.755    71.590     0.200
     5.933    84.347     0.200
     6.023    86.499     0.200
     9.635   132.146     0.200
    11.755   154.597     0.200
     2.665    43.541     0.200
     2.692    47.119     0.200
     3.911    60.995     0.200
     4.234    65.131     0.200
     4.852    72.913     0.200
     2.252    41.912     0.200
     2.341    41.660     0.200
     3.621    55.527     0.200
     4.562    69.541     0.200
     7.362   100.872     0.200
     2.439    43.049     0.200
     3.459    54.447     0.200
     4.400    70.366     0.200
     5.002    76.442     0.200
     2.304    39.242     0.200
     2.467    42.031     0.200
     3.402    53.725     0.200
     3.735    54.933     0.200
     4.092    61.875     0.200
     4.829    72.874     0.200
     4.948    73.085     0.200
     6.162    87.516     0.200
     7.266   102.527     0.200
     2.139    37.770     0.200
     2.333    38.811     0.200
     2.430    41.368     0.200
     3.365    53.056     0.200
     4.307    65.061     0.200
     4.747    70.334     0.200
     4.883    74.444     0.200
     7.171   100.937     0.200
     2.111    36.776     0.200
     2.351    39.366     0.200
     2.409    42.293     0.200
     3.348    52.042     0.200
     4.290    63.839     0.200
     4.702    74.532     0.200
     4.849    73.110     0.200
     2.297    41.863     0.200
     2.353    42.608     0.200
     3.551    55.828     0.200
     3.894    61.825     0.200
     4.492    68.854     0.200
     6.321    92.101     0.200
     8.417   117.551     0.200
    18.236   244.660     0.200
     1.415    29.400     0.200
     2.717    44.413     0.200
     4.906    73.261     0.200
     5.449    80.930     0.200
    10.734   148.857     0.200
     1.675    32.365     0.200
     2.838    47.787     0.200
     5.169    76.286     0.200
     2.210    39.170     0.200
     2.652    44.419     0.200
     3.850    60.433     0.200
     4.162    63.598     0.200
     5.062    75.795     0.200
     1.684    32.953     0.200
     1.685    34.144     0.200
     2.304    41.417     0.200
     2.842    45.739     0.200
     3.081    48.949     0.200
     4.267    66.203     0.200
     4.267    66.504     0.200
     4.622    70.559     0.200
     5.164    74.836     0.200
     5.667    82.777     0.200
     5.823    84.657     0.200
     7.049    99.349     0.200
     2.564    46.116     0.200
     3.570    56.174     0.200
     3.953    60.714     0.200
     5.802    83.631     0.200
     1.747    34.780     0.200
     2.597    43.258     0.200
     2.825    46.998     0.200
     3.252    51.814     0.200
     4.777    71.321     0.200
     5.426    74.547     0.200
     2.183    38.569     0.200
     2.778    45.222     0.200
     5.000    72.894     0.200
     2.858    48.547     0.200
     3.254    52.132     0.200
     3.254    51.334     0.200
     4.756    67.604     0.200
     5.180    78.153     0.200
     5.295    77.307     0.200
     6.375    90.205     0.200
     7.542   104.372     0.200
     7.606   107.143     0.200
     8.344   114.723     0.200
     9.978   135.659     0.200
    11.186   152.457     0.200
     2.663    45.699     0.200
     2.895    49.994     0.200
     3.444    53.390     0.200
     4.722    68.272     0.200
     2.859    50.154     0.200
     3.406    53.875     0.200
     3.662    56.784     0.200
     3.919    59.877     0.200
     4.343    66.136     0.200
     5.144    77.584     0.200
     5.459    79.912     0.200
     5.931    87.903     0.200
     7.258    99.412     0.200
     3.313    53.806     0.200
     4.529    69.818     0.200
     4.510    67.936     0.200
     4.685    72.502     0.200
     6.944    99.136     0.200
     3.225    52.436     0.200
     3.595    56.516     0.200
     4.826    68.145     0.200
     2.749    42.878     0.200
     3.958    58.080     0.200
     4.304    63.431     0.200
     4.706    69.744     0.200
     5.250    72.799     0.200
     1.884    37.889     0.200
     1.712    34.732     0.200
     1.964    39.887     0.200
     2.990    48.019     0.200
     3.028    48.072     0.200
     4.249    66.225     0.200
     4.527    70.082     0.200
     3.527    54.954     0.200
     4.025    61.648     0.200
     4.388    65.006     0.200
     4.533    67.422     0.200
     4.853    72.589     0.200
     5.046    75.039     0.200
     6.474    96.163     0.200
     6.725    95.544     0.200
     7.434   105.274     0.200
     7.754   105.327     0.200
     8.956   122.702     0.200
     2.259    39.533     0.200
     2.259    39.931     0.200
     3.645    55.553     0.200
     3.947    62.525     0.200
     3.947    61.228     0.200
     4.587    69.861     0.200
     4.891    75.007     0.200
     6.369    89.965     0.200
     7.134   102.239     0.200
     7.304   103.953     0.200
     1.637    33.099     0.200
     2.792    46.230     0.200
     2.878    48.416     0.200
     3.354    53.367     0.200
     3.729    58.986     0.200
     3.883    59.793     0.200
     4.582    70.734     0.200
     5.717    82.790     0.200
     5.787    84.675     0.200
     7.663   105.983     0.200
     1.642    33.562     0.200
     2.313    41.529     0.200
     2.806    46.570     0.200
     3.039    49.254     0.200
     4.580    69.268     0.200
     5.162    74.783     0.200
     5.703    82.670     0.200
     7.006    98.154     0.200
     7.880   108.962     0.200
     2.396    41.780     0.200
     2.530    43.218     0.200
     5.372    79.352     0.200
     2.292    40.064     0.200
     2.592    44.865     0.200
     3.829    59.528     0.200
     2.505    42.285     0.200
     2.499    43.646     0.200
     2.499    43.443     0.200
     3.596    58.452     0.200
     3.733    61.149     0.200
     3.938    61.254     0.200
     3.938    60.559     0.200
     4.327    65.814     0.200
     5.556    81.773     0.200
     2.454    42.777     0.200
     2.499    41.659     0.200
     3.840    60.804     0.200
     4.092    64.572     0.200
     4.222    65.846     0.200
     5.291    78.576     0.200
     5.449    80.924     0.200
     6.064    84.655     0.200
     7.462   102.142     0.200
     7.761   108.842     0.200
     8.069   109.326     0.200
    11.292   154.315     0.200
     2.505    43.780     0.200
     3.826    60.357     0.200
     3.843    60.468     0.200
     4.229    64.764     0.200
     4.229    63.862     0.200
     5.306    80.395     0.200
     5.306    80.594     0.200
     5.458    80.317     0.200
     6.658    95.115     0.200
     1.261    28.271     0.200
     2.452    40.275     0.200
     2.499    44.025     0.200
     3.507    57.260     0.200
     3.821    59.803     0.200
     4.233    64.387     0.200
     5.462    82.152     0.200
     1.159    26.548     0.200
     2.473    42.516     0.200
     2.535    42.488     0.200
     5.096    75.508     0.200
     5.606    81.150     0.200
     7.294   100.853     0.200
     2.462    42.346     0.200
     3.823    56.468     0.200
     4.225    65.871     0.200
     5.568    79.299     0.200
     2.481    43.598     0.200
     3.821    60.659     0.200
     5.586    79.066     0.200
     2.462    40.733     0.200
     2.626    45.221     0.200
     3.797    57.550     0.200
     4.166    63.353     0.200
     2.477    44.123     0.200
     2.646    46.254     0.200
     3.807    59.695     0.200
     3.807    59.496     0.200
     4.110    63.166     0.200
     4.110    64.267     0.200
     4.184    62.496     0.200
     5.409    80.101     0.200
     5.593    78.653     0.200
     6.078    87.302     0.200
     6.613    92.752     0.200
     8.111   114.277     0.200
     1.277    27.978     0.200
     2.450    41.190     0.200
     7.751   106.936     0.200
     8.026   108.120     0.200
     1.257    28.979     0.200
     2.452    43.131     0.200
     2.495    43.635     0.200
     4.092    64.693     0.200
     4.227    64.317     0.200
     7.714   109.530     0.200
     7.714   109.428     0.200
     1.246    28.563     0.200
     2.500    43.366     0.200
     4.097    64.028     0.200
     5.299    80.897     0.200
     5.453    81.499     0.200
     7.764   110.629     0.200
     8.062   111.252     0.200
    15.749   202.149     0.200
    18.256   236.494     0.200
     1.238    27.577     0.200
     5.277    77.134     0.200
     5.432    81.720     0.200
     8.084   112.774     0.200
     2.451    41.739     0.200
     4.214    63.065     0.200
     2.167    39.271     0.200
     2.696    45.496     0.200
     3.881    60.167     0.200
     4.184    64.737     0.200
     5.433    78.388     0.200
     8.157   112.899     0.200
     3.837    57.263     0.200
     3.832    59.923     0.200
     3.832    58.525     0.200
     4.105    62.336     0.200
     4.217    60.829     0.200
     5.446    78.984     0.200
     7.459   100.696     0.200
     4.202    63.716     0.200
     1.411    31.807     0.200
     4.172    66.582     0.200
     1.286    29.105     0.200
     2.719    45.690     0.200
     1.630    33.048     0.200
     2.320    41.194     0.200
     1.633    33.149     0.200
     1.633    32.649     0.200
     2.311    41.735     0.200
     3.723    59.859     0.200
     3.723    60.059     0.200
     4.215    65.611     0.200
     5.153    74.970     0.200
     1.283    29.421     0.200
     1.708    34.756     0.200
     2.951    48.952     0.200
     3.249    52.165     0.200
     6.252    89.332     0.200
     6.876    97.340     0.200
     3.021    50.235     0.200
     3.463    54.980     0.200
     3.739    59.564     0.200
     4.204    64.034     0.200
     5.141    75.393     0.200
     5.225    76.122     0.200
     5.766    87.406     0.200
     6.989    98.034     0.200
     2.590    44.772     0.200
     4.771    71.924     0.200
     5.178    79.372     0.200
     1.331    29.930     0.200
     2.478    43.139     0.200
     3.816    58.637     0.200
     3.816    60.238     0.200
     4.759    71.632     0.200
     5.403    74.110     0.200
     3.819    60.110     0.200
     3.900    64.365     0.200
     5.400    77.760     0.200
    10.501   144.027     0.200
     3.560    56.869     0.200
     3.892    61.998     0.200
     4.929    73.891     0.200
     7.349   101.657     0.200
     3.563    56.407     0.200
     3.897    59.518     0.200
     7.356   103.548     0.200
     2.209    38.399     0.200
     2.390    42.583     0.200
     2.389    43.177     0.200
     4.923    75.202     0.200
     2.204    40.205     0.200
     2.204    39.607     0.200
     3.635    57.704     0.200
     4.057    63.877     0.200
     4.566    70.835     0.200
     3.562    56.446     0.200
     4.503    69.169     0.200
     4.935    74.925     0.200
     7.354   105.190     0.200
    10.787   149.728     0.200
     1.648    34.080     0.200
     1.648    33.681     0.200
     1.650    32.858     0.200
     3.045    49.976     0.200
     3.436    58.112     0.200
     3.710    58.619     0.200
     4.141    64.084     0.200
     4.231    65.637     0.200
     6.755    96.672     0.200
     7.819   106.663     0.200
     1.517    30.823     0.200
     1.517    30.721     0.200
     2.494    42.225     0.200
     2.698    44.934     0.200
     2.698    45.840     0.200
     2.769    46.611     0.200
     2.769    47.416     0.200
     3.005    50.655     0.200
     3.606    56.940     0.200
     3.745    59.124     0.200
     4.141    62.500     0.200
     4.098    61.807     0.200
     4.535    69.904     0.200
     5.787    85.882     0.200
     7.696   103.606     0.200
     7.696   105.083     0.200
     7.749   110.197     0.200
    10.063   137.984     0.200
    11.073   153.106     0.200
     1.522    30.691     0.200
     1.522    32.991     0.200
     2.490    41.298     0.200
     2.711    46.015     0.200
     2.711    45.215     0.200
     3.605    58.581     0.200
     4.101    64.086     0.200
     1.004    24.721     0.200
     3.558    56.316     0.200
     4.499    69.436     0.200
     3.563    58.293     0.200
     3.800    62.720     0.200
     3.918    62.346     0.200
     3.885    61.235     0.200
     3.885    61.434     0.200
     5.043    76.418     0.200
     6.203    89.383     0.200
     6.603    92.913     0.200
     7.178   103.600     0.200
     8.271   115.353     0.200
     3.867    60.087     0.200
     3.867    58.888     0.200
     4.174    64.905     0.200
     5.422    74.736     0.200
     6.595    91.748     0.200
     2.536    44.871     0.200
     3.557    58.151     0.200
     3.804    62.659     0.200
     3.804    60.260     0.200
     3.927    62.725     0.200
     4.181    64.470     0.200
     4.181    64.673     0.200
     4.821    74.494     0.200
     4.821    74.197     0.200
     6.202    89.675     0.200
     6.601    93.021     0.200
     7.694   109.672     0.200
     8.266   114.295     0.200
    10.825   151.424     0.200
    11.106   151.126     0.200
     1.342    30.248     0.200
     2.540    44.669     0.200
     2.701    45.796     0.200
     3.800    58.472     0.200
     3.800    62.671     0.200
     3.884    60.988     0.200
     3.884    60.086     0.200
     3.923    61.729     0.200
     4.826    73.394     0.200
     5.399    75.802     0.200
     6.606    94.023     0.200
     1.347    29.986     0.200
     2.544    44.410     0.200
     2.706    44.824     0.200
     3.888    61.131     0.200
     3.888    58.832     0.200
     4.189    65.422     0.200
     4.830    71.838     0.200
     5.365    77.893     0.200
     6.210    89.538     0.200
     6.609    92.878     0.200
     6.609    93.079     0.200
     7.454   106.719     0.200
     7.702   110.225     0.200
     8.066   112.474     0.200
     8.261   113.797     0.200
     1.012    24.319     0.200
     1.454    30.051     0.200
     2.421    41.873     0.200
     3.572    56.038     0.200
     1.310    29.310     0.200
     2.465    43.826     0.200
     2.502    42.500     0.200
     3.773    60.368     0.200
     3.773    60.168     0.200
     3.800    61.445     0.200
     3.896    60.631     0.200
     4.275    66.208     0.200
     4.422    66.689     0.200
     7.059   102.809     0.200
     1.667    33.239     0.200
     2.022    35.591     0.200
     2.488    43.751     0.200
     5.908    83.048     0.200
     2.527    44.193     0.200
     3.871    60.310     0.200
     3.871    59.111     0.200
     4.176    64.650     0.200
     6.597    92.797     0.200
     2.434    42.666     0.200
     2.474    43.796     0.200
     2.645    45.106     0.200
     3.818    59.214     0.200
     5.565    75.421     0.200
     7.638   107.234     0.200
     2.421    43.041     0.200
     2.488    42.666     0.200
     2.639    45.095     0.200
     3.851    58.257     0.200
     3.865    61.190     0.200
     3.816    59.762     0.200
     4.525    67.891     0.200
     5.560    79.102     0.200
     6.041    87.401     0.200
     7.625   108.913     0.200
     2.427    43.296     0.200
     2.468    44.011     0.200
     2.481    42.859     0.200
     2.636    45.550     0.200
     3.812    59.135     0.200
     3.761    60.128     0.200
     3.870    60.059     0.200
     4.176    63.781     0.200
     4.749    73.593     0.200
     5.212    77.788     0.200
     7.382   103.036     0.200
     7.626   105.919     0.200
     7.626   108.818     0.200
     8.140   112.724     0.200
    10.682   148.154     0.200
    15.842   201.027     0.200
     2.438    42.998     0.200
     2.474    42.883     0.200
     2.468    43.848     0.200
     2.639    44.855     0.200
     2.639    46.253     0.200
     3.762    60.141     0.200
     3.872    60.960     0.200
     5.221    78.017     0.200
     5.398    80.655     0.200
     7.635   109.741     0.200
    10.686   146.045     0.200
     2.803    46.130     0.200
     3.530    56.345     0.200
     5.526    81.047     0.200
     6.371    90.892     0.200
     6.772    96.422     0.200
     8.121   111.870     0.200
     3.533    56.144     0.200
     3.783    58.817     0.200
     4.042    60.999     0.200
     4.984    74.111     0.200
     5.521    81.137     0.200
     8.128   111.721     0.200
     1.194    24.347     0.200
     2.667    45.256     0.200
     3.484    52.719     0.200
     3.203    52.203     0.200
     9.613   129.194     0.200
     1.210    25.562     0.200
     1.210    25.362     0.200
     2.913    48.193     0.200
     2.990    47.394     0.200
     3.273    52.592     0.200
     4.721    65.793     0.200
     5.254    77.869     0.200
     5.641    83.259     0.200
     9.651   130.166     0.200
     2.472    43.810     0.200
     2.493    43.064     0.200
     2.547    44.139     0.200
     2.730    46.501     0.200
     3.780    58.746     0.200
     3.808    58.814     0.200
     3.888    59.881     0.200
     3.888    60.577     0.200
     4.269    65.341     0.200
     5.533    75.793     0.200
     1.138    26.335     0.200
     1.779    34.861     0.200
     1.779    36.056     0.200
     1.779    36.556     0.200
     1.874    37.448     0.200
     3.118    51.229     0.200
     4.575    67.824     0.200
    10.207   138.700     0.200
     2.885    45.423     0.200
     3.099    49.230     0.200
     3.480    51.377     0.200
     3.759    56.628     0.200
     2.718    45.223     0.200
     3.242    51.316     0.200
     3.388    53.207     0.200
     3.862    59.377     0.200
     1.602    31.825     0.200
     1.602    32.426     0.200
     1.689    35.208     0.200
     2.681    44.125     0.200
     3.708    57.242     0.200
     3.811    60.341     0.200
     3.811    60.941     0.200
     4.002    62.616     0.200
     4.002    59.916     0.200
     4.183    63.206     0.200
     5.273    79.079     0.200
     6.572    94.025     0.200
     7.635   105.821     0.200
     7.927   108.805     0.200
    10.563   147.552     0.200
     1.589    32.564     0.200
     1.589    33.658     0.200
     2.300    41.268     0.200
     2.300    40.268     0.200
     2.776    45.508     0.200
     2.980    49.729     0.200
     3.403    54.495     0.200
     3.514    57.798     0.200
     3.753    59.604     0.200
     4.170    61.846     0.200
     4.522    68.843     0.200
     7.880   110.740     0.200
     8.432   116.109     0.200
    14.252   190.380     0.200
    15.739   201.760     0.200
    19.851   265.948     0.200
     1.557    30.492     0.200
     1.557    30.695     0.200
     3.598    54.380     0.200
     3.709    56.980     0.200
     4.094    59.790     0.200
     5.147    73.595     0.200
     8.149   111.929     0.200
    10.821   148.787     0.200
    12.763   169.525     0.200
     2.785    44.307     0.200
     3.508    53.966     0.200
     3.746    60.793     0.200
     5.231    74.560     0.200
     5.723    81.714     0.200
     2.847    47.473     0.200
     3.116    50.436     0.200
     3.116    47.534     0.200
     3.257    49.982     0.200
     3.710    57.001     0.200
     3.710    59.501     0.200
     9.988   136.734     0.200
     3.274    54.531     0.200
     4.704    70.736     0.200
     6.946   100.676     0.200
     2.786    46.575     0.200
     1.666    32.926     0.200
     1.666    35.023     0.200
     2.348    41.859     0.200
     2.805    47.027     0.200
     4.251    63.758     0.200
     4.615    71.007     0.200
     5.187    78.828     0.200
     1.626    32.183     0.200
     1.626    32.882     0.200
     2.349    41.750     0.200
     2.776    46.865     0.200
     3.485    56.296     0.200
     3.744    60.162     0.200
     4.211    63.321     0.200
     4.574    70.777     0.200
     1.625    32.878     0.200
     1.625    33.579     0.200
     2.344    41.785     0.200
     2.778    47.424     0.200
     3.743    60.055     0.200
     4.209    63.619     0.200
     4.572    68.988     0.200
     1.486    32.482     0.200
     2.204    38.695     0.200
     2.760    45.818     0.200
     3.621    56.662     0.200
     4.051    62.353     0.200
     4.051    62.150     0.200
     4.991    75.072     0.200
     5.288    72.713     0.200
     5.562    82.017     0.200
     6.405    92.170     0.200
     6.798    98.087     0.200
     3.724    57.534     0.200
     4.053    61.687     0.200
     4.380    66.779     0.200
     4.994    74.113     0.200
     6.411    91.974     0.200
     6.803    97.899     0.200
     1.939    38.157     0.200
     2.708    45.483     0.200
     2.710    46.657     0.200
     3.938    61.528     0.200
     4.251    67.173     0.200
     1.748    35.243     0.200
     2.260    40.272     0.200
     2.772    45.294     0.200
     3.541    56.712     0.200
     3.769    57.847     0.200
     2.755    47.024     0.200
     2.790    46.618     0.200
     4.295    65.654     0.200
     5.467    80.086     0.200
     3.991    55.022     0.200
     3.991    64.420     0.200
     4.129    65.516     0.200
     4.195    64.844     0.200
    10.445   145.313     0.200
     2.256    41.154     0.200
     3.645    57.252     0.200
     4.012    64.170     0.200
     4.587    70.853     0.200
     4.889    72.330     0.200
     5.615    78.753     0.200
    10.418   144.607     0.200
     2.450    41.185     0.200
     2.498    42.936     0.200
     3.843    61.431     0.200
     4.227    65.747     0.200
     1.751    35.263     0.200
     2.288    41.295     0.200
     2.753    46.873     0.200
     2.931    50.002     0.200
     3.542    57.760     0.200
     3.542    56.760     0.200
     3.555    56.018     0.200
     3.784    59.946     0.200
     4.258    65.514     0.200
     4.472    68.614     0.200
     5.760    84.088     0.200
     2.459    42.866     0.200
     3.852    61.608     0.200
     3.844    59.301     0.200
     5.452    80.940     0.200
     6.290    89.248     0.200
     7.706   106.233     0.200
    10.739   149.526     0.200
     2.446    42.099     0.200
     2.500    44.168     0.200
     2.498    42.594     0.200
     3.859    58.718     0.200
     3.840    60.443     0.200
     4.010    63.149     0.200
     4.224    64.953     0.200
     6.653    94.605     0.200
     3.499    56.375     0.200
     3.830    58.512     0.200
     3.839    60.203     0.200
     3.839    58.601     0.200
     4.016    62.139     0.200
     4.095    63.117     0.200
     4.222    65.130     0.200
     4.471    66.931     0.200
     4.775    70.682     0.200
     5.450    79.905     0.200
     6.288    88.016     0.200
     6.651    93.885     0.200
     7.761   108.628     0.200
     8.067   110.060     0.200
     8.174   112.513     0.200
     1.557    31.323     0.200
     1.740    34.781     0.200
     2.307    40.463     0.200
     2.750    44.497     0.200
     2.794    45.390     0.200
     2.948    48.084     0.200
     4.490    67.697     0.200
     5.267    75.322     0.200
     1.748    35.241     0.200
     2.760    45.422     0.200
     2.784    45.951     0.200
     2.932    49.517     0.200
     4.473    68.630     0.200
     1.398    31.824     0.200
     2.284    41.576     0.200
     2.561    43.746     0.200
     3.595    57.583     0.200
     4.072    67.509     0.200
     4.092    65.479     0.200
     5.213    76.999     0.200
     6.408    92.757     0.200
     3.666    58.330     0.200
     3.855    60.727     0.200
     3.998    61.249     0.200
     4.324    66.946     0.200
     6.748    93.664     0.200
     3.112    49.834     0.200
     3.401    52.657     0.200
     4.809    72.424     0.200
     5.115    76.057     0.200
     9.881   133.632     0.200
     2.552    44.559     0.200
     3.188    50.741     0.200
     4.829    71.486     0.200
     5.227    79.442     0.200
     7.186   100.689     0.200
     7.186    98.978     0.200
     7.714   110.424     0.200
    10.039   136.589     0.200
     3.583    56.570     0.200
     3.751    57.916     0.200
     3.768    58.718     0.200
     3.918    60.963     0.200
     4.224    67.396     0.200
     4.850    73.585     0.200
     5.115    77.190     0.200
     6.646    93.230     0.200
     1.168    27.242     0.200
     3.713    56.634     0.200
     3.945    61.635     0.200
     3.964    63.805     0.200
     4.096    63.764     0.200
     5.220    76.151     0.200
     1.240    28.408     0.200
     2.485    41.279     0.200
     3.826    58.624     0.200
     4.104    61.476     0.200
     4.208    63.965     0.200
     4.484    67.541     0.200
     4.762    69.907     0.200
     3.775    58.465     0.200
     3.884    59.889     0.200
     4.569    68.595     0.200
     4.856    72.242     0.200
     1.384    28.158     0.200
     2.522    41.681     0.200
     2.633    44.786     0.200
     2.506    41.263     0.200
     3.700    60.234     0.200
     3.740    56.065     0.200
     3.972    60.953     0.200
     4.003    60.992     0.200
     4.364    65.078     0.200
     5.594    80.629     0.200
     6.794    94.129     0.200
     7.833   108.199     0.200
     1.492    33.170     0.200
     2.322    41.585     0.200
     3.572    57.196     0.200
     3.885    61.354     0.200
     4.221    66.222     0.200
     4.874    75.206     0.200
     4.874    74.506     0.200
     8.481   116.614     0.200
     1.923    37.657     0.200
     1.923    38.255     0.200
     1.987    38.609     0.200
     1.987    41.711     0.200
     3.720    59.987     0.200
     3.787    62.309     0.200
     3.945    61.568     0.200
     4.187    66.543     0.200
     6.594    93.445     0.200
     8.400   116.648     0.200
     9.189   120.565     0.200
    10.992   146.628     0.200
    16.284   208.845     0.200
     3.715    59.728     0.200
     3.959    61.068     0.200
     4.900    75.486     0.200
     5.467    79.478     0.200
     5.467    79.376     0.200
     6.928    95.233     0.200
     3.666    57.310     0.200
     4.129    63.210     0.200
     1.143    26.946     0.200
     3.708    59.611     0.200
     4.049    64.738     0.200
     1.750    34.095     0.200
     1.750    33.595     0.200
     3.780    59.006     0.200
     4.752    69.963     0.200
     5.794    81.108     0.200
     3.038    48.140     0.200
     4.387    63.800     0.200
     4.673    69.658     0.200
     5.079    73.123     0.200
     1.632    35.210     0.200
     1.920    38.551     0.200
     2.367    41.735     0.200
     2.364    42.271     0.200
     2.841    46.804     0.200
     3.688    58.612     0.200
     3.886    61.304     0.200
     4.094    62.577     0.200
     5.002    74.283     0.200
     6.285    91.012     0.200
     6.454    93.431     0.200
     7.357   102.701     0.200
     7.675   107.289     0.200
     1.624    32.430     0.200
     6.173    89.039     0.200
     6.433    90.809     0.200
     7.315   101.411     0.200
     7.509    98.854     0.200
     2.474    42.978     0.200
     3.959    61.449     0.200
     4.891    75.266     0.200
     5.603    84.455     0.200
     6.035    87.116     0.200
     6.795    99.252     0.200
     7.901   105.799     0.200
     1.358    29.431     0.200
     2.462    43.449     0.200
     3.732    60.232     0.200
     6.783    93.519     0.200
     8.245   114.964     0.200
     1.563    31.488     0.200
     1.831    35.359     0.200
     3.633    55.437     0.200
     3.763    59.122     0.200
     4.078    62.046     0.200
     4.341    66.574     0.200
     4.489    66.443     0.200
     4.549    67.844     0.200
     5.021    73.343     0.200
     5.486    80.608     0.200
     6.752    95.534     0.200
     7.442   104.285     0.200
     2.614    45.584     0.200
     2.955    48.207     0.200
     4.399    66.261     0.200
     4.749    71.368     0.200
     6.387    92.855     0.200
     8.476   118.273     0.200
     3.414    55.590     0.200
     3.924    60.536     0.200
     4.021    62.105     0.200
     4.907    74.670     0.200
     5.195    77.098     0.200
     6.040    87.141     0.200
     6.440    92.068     0.200
     6.655    94.457     0.200
     7.313   104.879     0.200
     7.532   105.927     0.200
     7.897   110.877     0.200
     8.418   114.603     0.200
     1.917    37.845     0.200
     2.616    45.192     0.200
     2.728    44.585     0.200
     2.731    45.349     0.200
     3.699    58.145     0.200
     4.901    72.217     0.200
     5.453    79.281     0.200
     1.633    33.143     0.200
     1.674    33.555     0.200
     2.393    42.170     0.200
     1.676    34.121     0.200
     5.840    86.323     0.200
     1.548    32.090     0.200
     1.750    35.633     0.200
     2.340    41.748     0.200
     2.726    44.439     0.200
     2.787    46.725     0.200
     2.949    48.737     0.200
     3.536    56.187     0.200
     3.558    55.932     0.200
     3.793    58.488     0.200
     4.131    62.949     0.200
     4.248    65.382     0.200
     4.490    68.254     0.200
     5.068    74.611     0.200
     5.696    83.580     0.200
     6.917    99.034     0.200
     7.827   110.614     0.200
     8.233   115.676     0.200
     8.409   116.422     0.200
    11.571   155.619     0.200
     2.255    41.147     0.200
     2.374    41.557     0.200
     2.403    42.716     0.200
     2.404    41.807     0.200
     3.149    51.410     0.200
     3.473    54.830     0.200
     3.796    60.258     0.200
     4.185    64.820     0.200
     4.204    63.602     0.200
     4.415    65.640     0.200
     4.843    73.136     0.200
     5.000    75.406     0.200
     5.841    85.290     0.200
     6.222    89.453     0.200
     7.323   103.497     0.200
     7.717   107.799     0.200
     2.413    41.155     0.200
     1.534    31.536     0.200
     1.764    34.548     0.200
     2.712    45.691     0.200
     1.557    31.701     0.200
     1.740    34.768     0.200
     3.527    56.514     0.200
     3.547    56.078     0.200
     2.669    46.371     0.200
     2.767    48.422     0.200
     3.192    54.799     0.200
     3.325    53.193     0.200
     3.441    53.743     0.200
     4.679    70.882     0.200
     1.584    31.918     0.200
     2.406    42.930     0.200
     4.194    63.862     0.200
     1.400    31.561     0.200
     1.940    38.952     0.200
     1.398    31.247     0.200
     2.705    46.888     0.200
     3.714    57.616     0.200
     3.739    57.723     0.200
     3.943    60.944     0.200
     4.344    65.558     0.200
     5.422    80.586     0.200
     3.968    62.579     0.200
     2.117    38.011     0.200
     2.255    39.500     0.200
     2.336    40.254     0.200
     2.413    40.856     0.200
     2.444    42.698     0.200
     3.135    50.728     0.200
     3.461    55.019     0.200
     3.796    58.718     0.200
     4.011    60.403     0.200
     4.199    62.415     0.200
     4.211    62.569     0.200
     4.403    65.236     0.200
     5.007    74.285     0.200
     6.470    92.111     0.200
     1.609    30.863     0.200
     2.674    45.231     0.200
     2.733    44.344     0.200
     3.055    49.691     0.200
     3.284    52.022     0.200
     3.326    51.323     0.200
     4.031    61.798     0.200
     4.115    61.916     0.200
     4.816    69.137     0.200
     5.310    76.174     0.200
     5.814    81.289     0.200
     6.060    86.922     0.200
     7.458   100.225     0.200
     7.784   108.806     0.200
     8.277   113.149     0.200
     8.362   114.652     0.200
     8.788   119.088     0.200
     9.889   134.836     0.200
    11.347   152.723     0.200
     1.632    33.883     0.200
     1.755    35.050     0.200
     1.755    37.448     0.200
     3.296    53.570     0.200
     3.917    60.324     0.200
     1.456    29.380     0.200
     1.456    28.380     0.200
     2.393    40.343     0.200
     2.705    45.701     0.200
     2.959    48.931     0.200
     3.673    56.504     0.200
     3.690    56.801     0.200
     3.839    56.365     0.200
     4.028    61.055     0.200
     4.028    59.155     0.200
     4.484    65.640     0.200
     4.952    71.181     0.200
     5.679    82.892     0.200
     5.747    82.193     0.200
     7.777   108.214     0.200
     8.035   111.898     0.200
     8.098   109.563     0.200
     8.098   109.963     0.200
     8.287   111.155     0.200
     9.562   128.472     0.200
    15.361   191.822     0.200
     2.490    43.030     0.200
     3.859    60.653     0.200
     4.163    63.703     0.200
     5.343    78.236     0.200
     1.244    29.555     0.200
     3.832    59.949     0.200
     4.152    64.116     0.200
     6.573    93.370     0.200
     2.263    39.572     0.200
     1.331    30.497     0.200
     3.837    62.553     0.200
     4.423    68.311     0.200
     5.235    81.139     0.200
     2.091    39.570     0.200
     2.020    40.995     0.200
     2.488    45.539     0.200
     2.546    43.566     0.200
     2.783    47.897     0.200
     3.836    62.914     0.200
     3.893    59.446     0.200
     3.893    62.746     0.200
     4.081    62.855     0.200
     4.081    64.054     0.200
     4.438    67.780     0.200
     4.858    76.484     0.200
     5.230    78.545     0.200
     5.836    86.263     0.200
     6.492    93.209     0.200
     6.687    95.841     0.200
     7.255   102.610     0.200
     7.576   107.364     0.200
     8.447   120.193     0.200
    17.830   239.998     0.200
     1.341    30.596     0.200
     1.372    31.736     0.200
     2.545    44.146     0.200
     2.788    46.809     0.200
     3.516    55.720     0.200
     3.836    60.583     0.200
     3.826    59.595     0.200
     3.826    60.693     0.200
     3.894    62.504     0.200
     3.894    62.403     0.200
     4.080    64.337     0.200
     4.444    67.386     0.200
     5.227    77.442     0.200
     6.491    92.996     0.200
     6.684    95.638     0.200
     7.249   103.045     0.200
     7.574   108.558     0.200
     8.838   121.405     0.200
    10.804   143.418     0.200
     1.329    30.670     0.200
     1.329    30.640     0.200
     1.344    30.098     0.200
     2.779    46.954     0.200
     1.339    30.801     0.200
     3.830    59.833     0.200
     3.831    62.717     0.200
     4.432    67.006     0.200
     4.435    67.877     0.200
     1.346    30.569     0.200
     2.785    46.282     0.200
     3.885    59.686     0.200
     4.439    67.319     0.200
     5.238    76.597     0.200
     1.330    30.546     0.200
     3.841    59.843     0.200
     2.024    36.915     0.200
     2.546    42.714     0.200
     3.892    64.309     0.200
     3.825    60.985     0.200
     4.082    62.398     0.200
     4.435    67.469     0.200
     4.861    72.703     0.200
     5.231    79.183     0.200
     6.688    93.477     0.200
    10.971   153.203     0.200
     1.344    29.690     0.200
     1.359    30.110     0.200
     1.344    30.961     0.200
     2.495    43.440     0.200
     2.552    44.569     0.200
     2.788    47.316     0.200
     3.829    62.366     0.200
     3.832    59.931     0.200
     3.886    60.997     0.200
     4.087    63.956     0.200
     4.442    67.812     0.200
     5.236    77.452     0.200
     7.582   106.571     0.200
     1.369    32.160     0.200
     1.347    30.420     0.200
     2.088    39.375     0.200
     2.494    43.530     0.200
     2.550    44.089     0.200
     2.794    46.138     0.200
     3.521    56.049     0.200
     3.830    60.241     0.200
     3.889    60.054     0.200
     3.889    65.054     0.200
     3.832    60.727     0.200
     3.832    58.528     0.200
     4.084    63.879     0.200
     4.449    67.516     0.200
     4.854    74.201     0.200
     5.231    78.593     0.200
     6.495    93.041     0.200
    16.280   207.076     0.200
     1.343    29.618     0.200
     2.078    37.537     0.200
     2.497    44.050     0.200
     2.558    44.237     0.200
     2.781    45.438     0.200
     3.825    59.754     0.200
     3.835    60.334     0.200
     3.880    59.011     0.200
     4.094    62.917     0.200
     4.433    67.262     0.200
     5.245    77.887     0.200
     6.506    93.463     0.200
     7.273   102.120     0.200
     7.441   109.159     0.200
     2.018    41.669     0.200
     1.344    30.991     0.200
     4.087    63.889     0.200
     4.441    67.147     0.200
     4.862    73.738     0.200
     6.498    92.938     0.200
     7.258   102.271     0.200
     1.228    28.630     0.200
     2.175    38.480     0.200
     2.502    43.957     0.200
     3.432    55.702     0.200
     3.751    59.080     0.200
     4.042    61.884     0.200
     3.939    60.088     0.200
     4.285    65.649     0.200
     4.926    74.971     0.200
     5.217    77.077     0.200
     5.956    85.953     0.200
     6.462    91.849     0.200
     6.542    92.711     0.200
     7.333   102.187     0.200
     7.554   105.706     0.200
     7.919   110.449     0.200
     8.397   116.258     0.200
     8.823   120.395     0.200
    16.158   204.442     0.200
     2.507    43.932     0.200
     3.080    50.319     0.200
     3.468    49.725     0.200
     3.494    54.205     0.200
     5.126    75.364     0.200
     5.503    79.668     0.200
    15.225   194.377     0.200
     2.444    40.731     0.200
     2.681    45.865     0.200
     3.834    59.411     0.200
     4.009    60.464     0.200
     4.219    64.417     0.200
     4.770    71.593     0.200
     5.448    78.881     0.200
     6.648    94.371     0.200
     6.674    93.865     0.200
     6.746    97.027     0.200
     6.911    96.804     0.200
     7.710   108.178     0.200
     8.172   113.586     0.200
     2.074    37.040     0.200
     2.191    39.172     0.200
     2.405    42.767     0.200
     2.463    42.701     0.200
     3.095    51.115     0.200
     3.417    55.162     0.200
     4.263    63.687     0.200
     4.358    65.382     0.200
     4.782    72.937     0.200
     6.157    89.386     0.200
     6.162    89.430     0.200
     6.396    90.594     0.200
     7.162   102.256     0.200
     7.205   103.661     0.200
     8.781   120.162     0.200
     2.528    41.163     0.200
     2.571    43.959     0.200
     2.915    48.142     0.200
     4.022    62.633     0.200
     4.042    60.498     0.200
     5.688    83.385     0.200
     6.880    97.076     0.200
     6.914    98.680     0.200
     7.942   111.385     0.200
     3.030    46.473     0.200
     5.264    76.704     0.200
     1.224    25.578     0.200
     1.224    25.391     0.200
     2.604    43.914     0.200
     2.679    45.299     0.200
     3.057    50.488     0.200
     3.380    54.421     0.200
     3.406    54.690     0.200
     2.411    42.758     0.200
     3.788    60.482     0.200
     7.257   102.499     0.200
     1.688    35.139     0.200
     1.688    34.944     0.200
     3.477    54.566     0.200
     4.190    63.543     0.200
     4.310    65.946     0.200
     5.717    83.825     0.200
     1.203    24.373     0.200
     1.710    33.261     0.200
     3.868    59.066     0.200
     4.852    70.896     0.200
     6.336    90.764     0.200
     7.059    94.636     0.200
     7.590   102.240     0.200
     7.753   103.831     0.200
     9.968   134.790     0.200
    12.021   164.428     0.200
    17.271   229.659     0.200
    20.015   264.631     0.200
    20.110   264.432     0.200
    22.183   285.537     0.200
     2.479    42.244     0.200
     2.478    44.364     0.200
     3.797    58.874     0.200
     3.872    58.496     0.200
     3.872    60.496     0.200
     4.039    61.042     0.200
     4.253    63.651     0.200
     4.253    66.253     0.200
     6.682    94.806     0.200
     8.045   111.297     0.200
    11.320   153.484     0.200
     1.539    29.695     0.200
     1.539    29.895     0.200
     2.585    43.194     0.200
     3.273    50.064     0.200
     3.273    51.162     0.200
     3.087    49.028     0.200
     4.421    64.765     0.200
     4.835    69.634     0.200
     4.835    69.838     0.200
     5.350    77.230     0.200
     5.728    81.313     0.200
     7.480   102.869     0.200
     7.412   106.212     0.200
     7.701   106.688     0.200
     8.236   114.240     0.200
    11.883   158.185     0.200
     1.631    33.377     0.200
     1.753    34.950     0.200
     3.294    52.370     0.200
     5.721    83.743     0.200
     1.705    35.414     0.200
     2.321    42.717     0.200
     1.851    36.969     0.200
     3.630    57.708     0.200
     4.039    62.038     0.200
     6.477    92.784     0.200
     7.831   109.481     0.200
     7.954   111.553     0.200
     7.910   107.062     0.200
     8.357   116.044     0.200
    10.998   146.628     0.200
    15.681   198.719     0.200
     1.452    30.897     0.200
     1.852    37.233     0.200
     3.630    56.887     0.200
     4.126    63.104     0.200
     5.640    82.522     0.200
     1.454    32.377     0.200
     1.850    36.951     0.200
     1.850    37.053     0.200
     2.606    43.831     0.200
     3.628    57.001     0.200
     4.041    61.586     0.200
     4.129    63.664     0.200
     4.420    69.258     0.200
     4.420    66.953     0.200
     5.641    82.108     0.200
     6.481    92.611     0.200
     6.849    97.214     0.200
     6.868    97.988     0.200
     6.944    98.897     0.200
     7.104   100.441     0.200
     7.957   114.485     0.200
     7.957   110.180     0.200
     7.905   108.083     0.200
     7.905   108.591     0.200
     1.454    32.435     0.200
     1.851    36.590     0.200
     1.851    36.895     0.200
     2.450    42.512     0.200
     2.450    43.512     0.200
     2.601    44.049     0.200
     3.629    56.050     0.200
     4.041    61.140     0.200
     4.422    67.688     0.200
     5.644    81.634     0.200
     6.484    92.631     0.200
     6.851    97.244     0.200
     6.871    97.506     0.200
     7.107   100.661     0.200
     7.193   105.796     0.200
     7.899   106.305     0.200
     7.899   107.915     0.200
     7.844   110.466     0.200
     7.960   111.010     0.200
     8.364   116.387     0.200
    11.464   157.263     0.200
    15.668   198.603     0.200
     1.446    29.931     0.200
     1.859    37.010     0.200
     1.859    37.409     0.200
     4.033    62.035     0.200
     7.906   108.230     0.200
     7.906   111.839     0.200
    11.457   156.121     0.200
    15.671   198.290     0.200
     1.845    36.592     0.200
     1.845    36.893     0.200
     2.708    45.120     0.200
     3.621    55.758     0.200
     4.049    61.872     0.200
     4.431    66.309     0.200
     5.653    82.048     0.200
     6.493    92.748     0.200
     6.860    97.266     0.200
     6.880    97.725     0.200
     6.956    98.846     0.200
     7.116   100.474     0.200
     7.890   108.709     0.200
     7.890   107.741     0.200
     7.486   104.556     0.200
     7.886   110.891     0.200
     7.852   111.182     0.200
     7.968   110.628     0.200
     8.374   115.900     0.200
    15.660   199.260     0.200
     1.848    37.221     0.200
     3.626    57.671     0.200
     2.480    42.592     0.200
     1.464    32.050     0.200
     1.842    36.948     0.200
     2.455    43.296     0.200
     2.605    44.041     0.200
     1.847    37.480     0.200
     2.434    43.333     0.200
     2.611    44.373     0.200
     2.701    47.020     0.200
     2.881    48.919     0.200
     4.420    68.657     0.200
     6.480    92.919     0.200
     6.867    97.100     0.200
     6.944    95.606     0.200
     1.449    30.336     0.200
     2.457    42.576     0.200
     2.594    41.381     0.200
     2.881    45.629     0.200
     3.633    54.350     0.200
     4.420    65.975     0.200
     4.971    72.543     0.200
     6.870    97.080     0.200
     1.469    31.222     0.200
     1.469    32.722     0.200
     1.836    36.342     0.200
     1.836    37.240     0.200
     5.659    80.626     0.200
     5.897    85.157     0.200
     6.499    92.926     0.200
     7.195   105.356     0.200
     7.887   109.827     0.200
     7.887   107.831     0.200
    10.996   150.441     0.200
    15.661   199.623     0.200
     1.841    37.184     0.200
     1.849    37.122     0.200
     1.849    37.020     0.200
     2.448    42.631     0.200
     2.604    44.514     0.200
     2.885    48.625     0.200
     3.626    56.979     0.200
     4.043    60.408     0.200
     6.486    93.711     0.200
     6.949    97.306     0.200
     7.192   101.439     0.200
     7.479   104.616     0.200
     7.899   111.722     0.200
     7.844   110.455     0.200
     8.418   112.460     0.200
    11.003   149.907     0.200
    11.465   157.853     0.200
    15.668   199.838     0.200
     1.854    37.028     0.200
     2.602    45.303     0.200
     3.632    57.776     0.200
     4.125    63.530     0.200
     5.638    82.267     0.200
     1.446    30.127     0.200
     1.861    36.875     0.200
     1.853    36.895     0.200
     1.853    35.597     0.200
     1.853    37.395     0.200
     2.442    42.622     0.200
     2.603    44.043     0.200
     2.696    45.856     0.200
     3.632    58.341     0.200
     3.696    57.691     0.200
     4.126    64.166     0.200
     4.038    61.804     0.200
     4.038    63.304     0.200
     4.417    65.674     0.200
     4.972    75.496     0.200
     5.638    83.328     0.200
     5.906    84.795     0.200
     6.478    92.727     0.200
     6.846    96.532     0.200
     6.941    97.517     0.200
     7.834   109.494     0.200
    11.002   146.498     0.200
     1.855    36.835     0.200
     1.855    37.036     0.200
     2.449    42.996     0.200
     2.449    43.394     0.200
     3.632    56.090     0.200
     4.037    61.363     0.200
     5.911    87.500     0.200
     7.840   110.784     0.200
     7.903   107.294     0.200
     8.421   116.101     0.200
     1.170    27.764     0.200
     2.439    43.160     0.200
     2.482    43.152     0.200
     2.487    43.300     0.200
     3.837    59.646     0.200
     4.061    61.828     0.200
     1.844    36.743     0.200
     2.602    44.298     0.200
     1.845    37.240     0.200
     2.614    44.168     0.200
     2.881    49.451     0.200
     3.625    57.573     0.200
     4.044    62.786     0.200
     4.138    65.081     0.200
     4.421    68.685     0.200
     4.979    75.077     0.200
     6.480    93.255     0.200
     6.849    99.045     0.200
     6.867    98.333     0.200
     6.944    97.537     0.200
     2.485    43.980     0.200
     2.485    43.480     0.200
     2.481    42.718     0.200
     3.490    53.351     0.200
     3.828    57.608     0.200
     3.839    57.874     0.200
     4.196    63.804     0.200
     5.237    77.754     0.200
     5.237    76.754     0.200
     5.416    79.668     0.200
     6.256    88.669     0.200
     6.625    93.666     0.200
     6.644    95.247     0.200
     7.401   102.208     0.200
     7.651   107.085     0.200
     7.732   108.440     0.200
     7.955   109.945     0.200
     8.115   109.590     0.200
     9.074   128.280     0.200
    15.818   201.951     0.200
    18.029   239.081     0.200
     1.461    31.712     0.200
     1.843    37.061     0.200
     2.611    44.697     0.200
     3.621    57.111     0.200
     4.132    64.450     0.200
     4.428    67.294     0.200
     5.648    84.450     0.200
     7.842   110.649     0.200
     1.846    38.456     0.200
     1.842    37.807     0.200
     1.464    33.045     0.200
     1.841    37.039     0.200
     1.841    36.937     0.200
     2.444    43.605     0.200
     2.444    43.503     0.200
     2.611    45.158     0.200
     3.619    57.394     0.200
     4.130    62.624     0.200
     4.431    66.612     0.200
     5.898    83.887     0.200
     7.190   104.492     0.200
     7.477   104.961     0.200
     7.847   110.151     0.200
     8.412   115.459     0.200
    15.668   198.605     0.200
     1.847    37.125     0.200
     2.451    42.569     0.200
     2.451    42.270     0.200
     2.603    43.902     0.200
     2.603    44.502     0.200
     2.705    45.910     0.200
     3.624    56.887     0.200
     3.624    58.989     0.200
     4.046    61.461     0.200
     4.046    63.563     0.200
     4.428    67.903     0.200
     4.428    68.104     0.200
     4.980    74.359     0.200
     5.650    82.243     0.200
     6.490    92.944     0.200
     6.857    97.861     0.200
     6.953    96.841     0.200
     7.849   110.281     0.200
     7.894   110.704     0.200
     8.370   115.397     0.200
     8.420   116.018     0.200
     9.948   136.931     0.200
     2.266    41.055     0.200
     2.266    40.457     0.200
     2.538    43.780     0.200
     3.344    53.179     0.200
     3.666    58.219     0.200
     3.973    61.735     0.200
     4.607    70.039     0.200
     5.161    75.674     0.200
     6.480    92.582     0.200
     6.856   100.448     0.200
     7.334   103.413     0.200
     7.696   107.488     0.200
     7.869   109.965     0.200
     8.385   116.652     0.200
     1.126    26.742     0.200
     1.394    30.617     0.200
     2.292    40.835     0.200
     4.009    61.194     0.200
     3.984    61.592     0.200
     3.984    61.490     0.200
     4.609    68.498     0.200
     4.950    73.525     0.200
     6.405    92.539     0.200
     7.173   100.383     0.200
     8.394   115.619     0.200
     8.394   116.627     0.200
     8.778   121.750     0.200
     8.854   121.265     0.200
     9.489   132.438     0.200
    16.097   204.957     0.200
     1.404    32.571     0.200
     1.125    27.215     0.200
     1.793    35.659     0.200
     1.793    37.557     0.200
     1.682    34.654     0.200
     1.682    33.753     0.200
     1.784    35.067     0.200
     1.784    36.368     0.200
     3.094    50.078     0.200
     3.587    56.921     0.200
     4.162    62.211     0.200
     6.520    95.396     0.200
    10.487   141.817     0.200
     3.971    62.295     0.200
     2.291    41.059     0.200
     3.661    58.376     0.200
     6.882   100.181     0.200
     8.405   115.726     0.200
     8.405   113.614     0.200
    16.105   203.939     0.200
     3.665    57.666     0.200
     7.504   106.569     0.200
     8.393   113.310     0.200
     8.393   113.490     0.200
    11.071   144.934     0.200
     1.859    36.744     0.200
     2.603    45.853     0.200
     1.132    26.709     0.200
     8.392   113.492     0.200
     1.133    26.862     0.200
     4.005    60.251     0.200
     7.360   102.787     0.200
     8.395   115.759     0.200
     8.397   113.890     0.200
     1.404    32.104     0.200
     4.023    64.656     0.200
     1.111    27.091     0.200
     4.020    61.638     0.200
     6.904   100.153     0.200
     8.426   116.925     0.200
     1.109    27.085     0.200
     7.348   103.470     0.200
     1.110    27.255     0.200
     7.346   103.581     0.200
     1.129    26.865     0.200
     1.227    25.700     0.200
     1.596    32.001     0.200
     1.596    31.200     0.200
     2.059    36.099     0.200
     2.059    36.896     0.200
     2.722    46.759     0.200
     2.722    46.958     0.200
     2.939    47.620     0.200
     3.275    51.799     0.200
     3.880    59.843     0.200
     4.507    67.926     0.200
     5.704    80.959     0.200
     6.755    96.595     0.200
     6.814    94.611     0.200
     6.991   100.113     0.200
     6.980   100.063     0.200
     8.909   121.359     0.200
    16.346   208.807     0.200
     2.275    41.104     0.200
     4.619    70.750     0.200
     5.179    76.209     0.200
     7.157   101.432     0.200
     7.356   103.312     0.200
     8.397   114.927     0.200
     8.397   116.154     0.200
     8.389   114.855     0.200
     8.781   121.975     0.200
    10.883   152.652     0.200
    16.108   206.841     0.200
    20.104   267.438     0.200
    20.976   278.663     0.200
    21.629   287.042     0.200
     1.421    32.518     0.200
     4.922    74.354     0.200
     1.124    26.904     0.200
     2.299    41.394     0.200
     2.513    42.993     0.200
     3.669    57.107     0.200
     4.009    61.743     0.200
     3.986    61.604     0.200
     5.180    76.575     0.200
     6.410    91.818     0.200
     7.370   104.419     0.200
     1.122    27.106     0.200
     3.666    57.925     0.200
     3.982    61.934     0.200
     4.012    62.080     0.200
     5.175    76.208     0.200
     6.891   102.911     0.200
     7.176    98.960     0.200
     7.364   103.664     0.200
     8.394   113.259     0.200
     1.129    26.460     0.200
     1.417    31.306     0.200
     2.260    40.964     0.200
     3.662    57.613     0.200
     3.967    61.553     0.200
     4.022    61.607     0.200
     5.153    76.002     0.200
     7.324   102.969     0.200
     1.092    26.754     0.200
     2.504    42.078     0.200
     3.939    61.331     0.200
     5.130    76.527     0.200
     1.116    27.247     0.200
     1.401    31.117     0.200
     2.300    42.227     0.200
     3.659    57.466     0.200
     3.976    62.273     0.200
     4.019    62.575     0.200
     1.141    27.452     0.200
     2.337    41.790     0.200
     3.358    54.079     0.200
     3.998    60.803     0.200
     6.874    99.442     0.200
     7.159    99.216     0.200
     7.893   109.659     0.200
     8.393   118.354     0.200
     8.393   117.014     0.200
    11.049   150.172     0.200
    16.104   204.843     0.200
     1.129    27.333     0.200
     2.291    39.670     0.200
     4.006    61.349     0.200
     6.888   102.052     0.200
     7.173   102.304     0.200
     8.392   115.118     0.200
    10.972   151.478     0.200
    16.095   207.465     0.200
     1.381    28.261     0.200
     1.105    27.111     0.200
     2.291    40.870     0.200
     4.921    74.183     0.200
     6.873    98.966     0.200
    11.075   146.551     0.200
    16.121   208.092     0.200
     4.044    66.716     0.200
     1.377    31.688     0.200
     1.142    27.568     0.200
     3.650    57.285     0.200
     4.033    62.114     0.200
     4.905    72.733     0.200
     6.849    96.948     0.200
     7.134   100.723     0.200
     8.390   117.572     0.200
     8.436   119.030     0.200
    16.141   206.298     0.200
     1.113    26.938     0.200
     2.283    41.085     0.200
     1.123    27.478     0.200
     1.138    27.638     0.200
     1.103    27.547     0.200
     1.114    27.535     0.200
     1.090    26.961     0.200
     1.122    27.569     0.200
     1.124    27.254     0.200
     1.118    27.503     0.200
     7.325   104.562     0.200
     1.090    26.886     0.200
     2.285    40.042     0.200
     2.497    43.270     0.200
     3.629    57.452     0.200
     3.943    60.094     0.200
     4.050    62.143     0.200
     4.570    69.474     0.200
     5.136    76.467     0.200
     6.367    91.608     0.200
     1.122    27.585     0.200
     2.545    43.886     0.200
     3.329    53.334     0.200
     3.649    58.297     0.200
     3.950    61.985     0.200
     4.036    62.778     0.200
     5.134    77.163     0.200
     7.302   102.571     0.200
     1.103    27.295     0.200
     1.102    27.042     0.200
     6.869   101.683     0.200
    16.127   207.334     0.200
     1.100    27.102     0.200
     4.051    66.670     0.200
     1.108    27.169     0.200
     3.642    56.697     0.200
     4.040    66.452     0.200
     7.322   104.251     0.200
     4.051    62.655     0.200
     1.106    26.755     0.200
     1.435    29.307     0.200
     4.043    61.173     0.200
     7.317   102.871     0.200
     1.123    27.367     0.200
     2.289    40.662     0.200
     4.014    62.630     0.200
     1.108    27.333     0.200
     4.040    63.113     0.200
     1.103    27.296     0.200
     2.272    41.158     0.200
     2.523    43.921     0.200
     1.091    26.671     0.200
     4.052    65.413     0.200
     1.090    26.921     0.200
     4.054    66.125     0.200
     6.873   100.231     0.200
     7.323   103.776     0.200
     7.323   101.876     0.200
     8.439   119.199     0.200
    16.128   206.012     0.200
     2.404    42.663     0.200
     1.853    37.128     0.200
     1.853    37.026     0.200
     2.599    44.227     0.200
     3.630    55.988     0.200
     4.039    60.417     0.200
     5.911    84.477     0.200
     7.194   103.582     0.200
     7.900   107.778     0.200
     7.900   106.259     0.200
     8.422   114.467     0.200
    11.008   148.446     0.200
     1.103    27.240     0.200
     2.452    42.675     0.200
     1.142    27.081     0.200
     2.285    41.039     0.200
     7.358   105.380     0.200
     1.861    36.949     0.200
     1.196    28.544     0.200
     3.941    64.219     0.200
     4.050    61.940     0.200
     6.473    91.966     0.200
     1.125    27.169     0.200
     2.293    41.547     0.200
     3.668    57.895     0.200
     4.010    61.103     0.200
     4.609    69.719     0.200
     5.176    76.698     0.200
     6.407    91.133     0.200
     6.887   102.160     0.200
     7.172   101.299     0.200
     7.363   104.981     0.200
     9.489   131.487     0.200
    16.097   207.393     0.200
     4.020    61.263     0.200
     4.600    68.197     0.200
     6.395    91.149     0.200
     7.161   101.614     0.200
     7.347   104.339     0.200
     7.492   105.743     0.200
     8.410   116.903     0.200
    11.065   152.264     0.200
     1.111    27.327     0.200
     1.774    34.705     0.200
     4.425    66.860     0.200
     1.112    27.192     0.200
     7.361   105.564     0.200
     3.635    56.294     0.200
     6.903   100.666     0.200
     1.091    26.091     0.200
     1.862    37.116     0.200
     2.596    44.358     0.200
     4.293    67.389     0.200
     1.444    30.274     0.200
     2.600    44.682     0.200
     4.409    67.165     0.200
     1.104    26.205     0.200
     4.361    69.058     0.200
     4.921    73.159     0.200
     6.875   101.332     0.200
     3.938    62.079     0.200
     3.958    61.535     0.200
     8.235   113.259     0.200
     8.235   114.515     0.200
     8.810   119.802     0.200
    18.376   246.369     0.200
     1.464    32.424     0.200
     3.941    59.268     0.200
     2.724    46.205     0.200
     3.522    55.387     0.200
     3.936    60.741     0.200
     5.192    78.201     0.200
     5.201    77.395     0.200
     8.248   112.230     0.200
     8.814   120.934     0.200
     3.939    61.305     0.200
     3.934    61.477     0.200
     6.371    92.261     0.200
     7.620   108.390     0.200
     8.250   115.071     0.200
     1.467    31.506     0.200
     3.952    61.403     0.200
     1.843    37.028     0.200
     2.607    44.714     0.200
     3.620    57.590     0.200
     4.050    61.671     0.200
     1.091    26.681     0.200
     4.355    68.973     0.200
     7.327   103.612     0.200
     4.097    65.814     0.200
     1.781    36.344     0.200
     3.612    59.977     0.200
     4.368    67.589     0.200
    11.205   151.335     0.200
     2.532    43.155     0.200
     3.765    58.662     0.200
     2.390    42.679     0.200
     2.401    41.546     0.200
     3.872    61.187     0.200
     4.131    61.460     0.200
     1.405    28.880     0.200
     2.358    41.559     0.200
     2.456    42.417     0.200
     3.966    61.592     0.200
     3.966    61.092     0.200
     4.037    62.362     0.200
     6.011    85.934     0.200
     6.392    90.787     0.200
     8.380   116.286     0.200
     2.110    36.971     0.200
     2.367    40.575     0.200
     3.928    61.002     0.200
     3.896    59.731     0.200
     4.198    66.701     0.200
     5.151    74.577     0.200
     7.581   106.929     0.200
     8.295   110.409     0.200
     8.295   114.491     0.200
    15.798   198.176     0.200
    16.276   210.359     0.200
    18.019   241.416     0.200
    20.477   268.329     0.200
    20.699   270.536     0.200
     7.714   105.363     0.200
     1.095    26.588     0.200
     2.166    38.673     0.200
     4.148    62.637     0.200
     8.274   113.331     0.200
     1.642    32.490     0.200
     4.244    64.340     0.200
     2.355    43.087     0.200
     4.250    64.271     0.200
     8.619   117.180     0.200
    16.243   207.706     0.200
     4.307    64.813     0.200
     8.638   120.969     0.200
    16.257   208.425     0.200
     6.834   102.127     0.200
     7.156   101.862     0.200
     1.650    34.090     0.200
     4.322    68.889     0.200
     8.634   118.432     0.200
    11.192   149.421     0.200
     4.299    67.316     0.200
     4.741    71.909     0.200
     6.842   101.477     0.200
     7.163   101.046     0.200
     9.226   128.444     0.200
    10.729   150.503     0.200
    11.214   149.609     0.200
    16.249   206.880     0.200
     4.308    66.706     0.200
     7.181   100.526     0.200
     8.608   119.530     0.200
    10.753   150.818     0.200
    16.235   206.849     0.200
     4.760    71.765     0.200
     4.336    67.638     0.200
     4.728    72.774     0.200
     7.148   100.632     0.200
    11.178   149.718     0.200
    16.271   208.614     0.200
     1.502    30.622     0.200
     2.445    43.019     0.200
     2.951    49.212     0.200
     3.214    52.747     0.200
     4.288    65.639     0.200
     6.705    96.918     0.200
     8.086   110.408     0.200
    11.061   149.282     0.200
    14.589   185.359     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.692    71.338     0.200
     5.017   100.576     0.200
     2.550    48.815     0.200
     4.742    92.542     0.200
     2.566    49.778     0.200
     2.659    53.389     0.200
     3.781    73.499     0.200
     4.722    91.920     0.200
     5.061    98.763     0.200
     5.119   105.188     0.200
     5.948   113.805     0.200
     3.133    62.220     0.200
     3.459    67.308     0.200
     4.401    86.826     0.200
     4.534    87.773     0.200
     4.818    97.455     0.200
     4.870    94.846     0.200
     5.635   108.918     0.200
     7.293   144.068     0.200
     7.594   148.056     0.200
     2.574    50.931     0.200
     2.613    51.668     0.200
     2.692    54.155     0.200
     2.820    57.257     0.200
     2.879    57.266     0.200
     3.160    62.092     0.200
     3.616    69.964     0.200
     3.945    77.129     0.200
     4.886    96.151     0.200
     5.279   109.257     0.200
     5.461   107.438     0.200
     6.112   121.335     0.200
     7.579   149.321     0.200
     7.792   152.635     0.200
     8.048   156.949     0.200
     9.140   179.503     0.200
     9.776   191.387     0.200
    10.276   198.246     0.200
    11.367   221.912     0.200
     2.559    51.204     0.200
     2.701    51.946     0.200
     2.683    53.350     0.200
     2.814    56.427     0.200
     2.869    57.685     0.200
     3.131    61.425     0.200
     3.607    71.668     0.200
     3.933    76.862     0.200
     4.874    94.678     0.200
     5.007    97.431     0.200
     5.432   107.175     0.200
     6.090   118.298     0.200
     7.533   148.856     0.200
     7.765   151.941     0.200
     2.600    51.823     0.200
     3.028    59.321     0.200
     3.971    77.920     0.200
     4.512    88.111     0.200
     4.547    88.600     0.200
     6.945   136.718     0.200
     2.748    53.830     0.200
     3.325    64.702     0.200
     3.558    70.378     0.200
     4.500    87.381     0.200
     4.631    89.860     0.200
     4.834    95.491     0.200
     5.049    98.774     0.200
     5.695   113.433     0.200
     6.222   120.981     0.200
    26.376   551.788     0.200
     2.676    53.923     0.200
     3.113    60.522     0.200
     3.282    64.744     0.200
     4.169    81.196     0.200
     4.557    89.366     0.200
     5.473   106.678     0.200
     5.612   110.360     0.200
     6.070   115.405     0.200
     6.588   128.262     0.200
     6.588   130.368     0.200
     7.723   150.023     0.200
     8.045   158.562     0.200
     8.054   158.059     0.200
     9.038   174.078     0.200
     2.708    54.567     0.200
     3.522    67.573     0.200
     3.862    74.097     0.200
     3.862    74.300     0.200
     4.246    82.820     0.200
     4.798    93.679     0.200
     4.798    96.179     0.200
     5.313   104.669     0.200
     5.474   108.791     0.200
     6.675   130.770     0.200
     7.087   135.259     0.200
     9.768   192.182     0.200
    10.252   198.529     0.200
    10.706   206.337     0.200
    11.134   215.447     0.200
    11.312   219.666     0.200
    13.438   264.748     0.200
    14.183   278.052     0.200
    14.624   285.015     0.200
    15.269   300.486     0.200
    15.401   303.242     0.200
    16.365   322.194     0.200
     2.675    52.303     0.200
     3.831    75.315     0.200
     4.214    83.149     0.200
     4.767    93.488     0.200
     5.285   102.938     0.200
     5.441   107.620     0.200
     7.701   149.851     0.200
     2.573    51.937     0.200
     2.684    53.144     0.200
     3.839    76.364     0.200
     4.222    81.397     0.200
     4.775    93.443     0.200
     5.292   104.405     0.200
     5.449   107.868     0.200
     2.574    51.683     0.200
     2.684    53.101     0.200
     3.840    75.611     0.200
     4.222    83.149     0.200
     4.776    93.690     0.200
     5.291   104.571     0.200
     5.449   108.124     0.200
     2.721    52.731     0.200
     3.873    75.989     0.200
     4.259    83.483     0.200
     4.808    93.575     0.200
     5.328   104.709     0.200
     5.487   108.146     0.200
     2.572    51.047     0.200
     2.681    51.983     0.200
     3.838    75.274     0.200
     4.219    83.326     0.200
     4.774    93.652     0.200
     5.286   103.281     0.200
     5.446   107.415     0.200
     6.648   128.684     0.200
     7.701   150.296     0.200
     7.758   149.431     0.200
     8.036   156.391     0.200
     9.098   176.990     0.200
     2.513    49.386     0.200
     2.590    51.583     0.200
     2.708    52.400     0.200
     3.516    68.381     0.200
     3.857    76.093     0.200
     4.246    83.558     0.200
     4.792    93.082     0.200
     5.325   105.663     0.200
     2.578    51.604     0.200
     2.690    52.601     0.200
     3.504    68.299     0.200
     3.844    76.226     0.200
     4.228    82.949     0.200
     4.780    93.207     0.200
     5.298   103.454     0.200
     5.456   108.021     0.200
     2.568    51.903     0.200
     2.679    52.709     0.200
     3.835    75.525     0.200
     4.217    82.657     0.200
     4.770    92.901     0.200
     5.290   103.841     0.200
     5.445   106.025     0.200
     6.646   129.107     0.200
     2.591    51.778     0.200
     2.700    53.606     0.200
     3.517    68.374     0.200
     3.857    75.503     0.200
     4.239    82.952     0.200
     4.793    94.082     0.200
     5.301   105.556     0.200
     5.465   107.242     0.200
     6.668   131.207     0.200
     7.715   150.479     0.200
     7.777   150.255     0.200
     2.586    51.694     0.200
     2.696    53.208     0.200
     3.511    68.489     0.200
     3.852    74.619     0.200
     4.234    83.656     0.200
     4.787    93.898     0.200
     5.300   103.915     0.200
     5.461   107.636     0.200
     6.663   129.609     0.200
     7.715   150.334     0.200
     7.773   150.356     0.200
     2.574    51.592     0.200
     3.334    65.919     0.200
     3.979    78.487     0.200
     4.489    90.434     0.200
     4.540    89.539     0.200
     6.922   136.450     0.200
     2.504    50.296     0.200
     3.528    69.346     0.200
     3.869    74.361     0.200
     3.869    75.861     0.200
     4.804    94.948     0.200
     4.804    95.448     0.200
     5.329   106.028     0.200
     5.486   108.498     0.200
     6.053   118.872     0.200
     6.686   131.495     0.200
     7.744   150.648     0.200
     7.796   151.532     0.200
     8.076   156.274     0.200
     9.136   178.098     0.200
     9.778   192.003     0.200
    10.262   201.258     0.200
    11.143   215.477     0.200
     2.715    53.130     0.200
     3.526    70.268     0.200
     3.867    77.087     0.200
     4.253    83.584     0.200
     4.803    94.071     0.200
     5.323   104.496     0.200
     5.482   108.446     0.200
     6.682   132.436     0.200
     7.738   152.317     0.200
     2.560    51.255     0.200
     2.526    49.645     0.200
     2.680    53.347     0.200
     3.485    67.453     0.200
     3.827    74.261     0.200
     4.217    84.010     0.200
     4.762    94.054     0.200
     5.309   104.170     0.200
     5.450   107.028     0.200
     5.604   112.024     0.200
     6.647   129.957     0.200
     7.758   152.584     0.200
     7.726   151.569     0.200
     8.039   157.304     0.200
     9.097   177.062     0.200
     9.740   188.753     0.200
    10.737   209.822     0.200
     2.524    50.034     0.200
     2.551    50.524     0.200
     2.670    51.333     0.200
     3.476    67.425     0.200
     3.818    74.236     0.200
     4.207    82.691     0.200
     4.753    92.629     0.200
     5.299   103.754     0.200
     5.439   107.315     0.200
     5.610   106.131     0.200
     6.636   130.341     0.200
     7.716   149.448     0.200
     7.748   150.572     0.200
     9.087   177.947     0.200
     3.857    77.439     0.200
     4.235    84.328     0.200
     2.512    48.243     0.200
     2.635    53.104     0.200
     2.738    53.811     0.200
     3.900    76.540     0.200
     4.277    84.146     0.200
     4.836    93.715     0.200
     5.316   105.520     0.200
     5.499   108.483     0.200
     5.515   108.695     0.200
     6.004   119.885     0.200
     2.505    49.272     0.200
     2.688    53.738     0.200
     2.810    55.315     0.200
     3.956    76.839     0.200
     4.348    85.371     0.200
     4.891    95.336     0.200
     5.407   107.411     0.200
     5.577   108.224     0.200
     6.777   131.923     0.200
     7.819   153.462     0.200
     7.888   154.557     0.200
     8.167   161.000     0.200
     9.227   180.426     0.200
     9.870   191.927     0.200
    10.353   199.689     0.200
    10.865   211.915     0.200
    11.234   218.611     0.200
    11.409   221.369     0.200
     2.513    50.027     0.200
     2.696    53.083     0.200
     3.222    61.651     0.200
     3.846    74.967     0.200
     4.234    83.038     0.200
     5.315   106.324     0.200
     5.584   107.891     0.200
     2.633    52.409     0.200
     2.638    52.153     0.200
     3.555    69.647     0.200
     3.878    75.885     0.200
     4.178    83.376     0.200
     4.820    94.091     0.200
     5.355   106.644     0.200
     6.599   131.131     0.200
     7.447   145.231     0.200
     7.692   150.378     0.200
     2.507    48.058     0.200
     2.649    53.503     0.200
     2.759    55.012     0.200
     3.915    77.316     0.200
     4.298    84.557     0.200
     4.851    93.602     0.200
     5.346   105.216     0.200
     5.523   108.960     0.200
     5.515   107.856     0.200
     6.727   133.110     0.200
     7.759   152.064     0.200
     7.836   152.263     0.200
    10.304   201.967     0.200
     2.633    53.415     0.200
     3.273    65.450     0.200
     3.911    77.501     0.200
     4.470    88.276     0.200
     6.904   137.372     0.200
     3.171    62.598     0.200
     3.500    68.162     0.200
     3.841    75.180     0.200
     4.440    86.788     0.200
     4.919    95.600     0.200
     6.268   124.059     0.200
     7.341   144.432     0.200
     7.373   146.063     0.200
     8.716   167.884     0.200
     2.551    48.613     0.200
     3.011    60.138     0.200
     3.233    62.651     0.200
     3.953    81.253     0.200
     4.284    82.591     0.200
     4.755    94.491     0.200
     6.023   118.298     0.200
     8.347   163.278     0.200
     8.611   169.289     0.200
     9.635   186.247     0.200
    11.305   219.052     0.200
    11.755   228.797     0.200
    17.221   341.810     0.200
     2.659    53.005     0.200
     2.692    53.119     0.200
     3.911    76.495     0.200
     4.234    84.131     0.200
     4.852    94.913     0.200
     5.423   106.455     0.200
     5.406   106.743     0.200
     5.877   119.158     0.200
     2.528    50.184     0.200
     4.897    98.536     0.200
     5.896   115.883     0.200
     7.573   145.917     0.200
     3.295    66.530     0.200
     3.621    71.230     0.200
     4.054    78.468     0.200
     4.209    82.571     0.200
     4.562    88.541     0.200
    18.327   367.003     0.200
     3.133    61.054     0.200
     3.459    69.248     0.200
     3.792    73.466     0.200
     4.400    86.366     0.200
     4.865    95.346     0.200
     5.002    99.442     0.200
     6.218   121.150     0.200
     7.288   142.468     0.200
     7.322   142.969     0.200
     7.591   149.027     0.200
     8.666   168.980     0.200
     9.305   182.127     0.200
     9.799   190.069     0.200
    10.290   200.730     0.200
    10.684   207.235     0.200
     3.402    67.823     0.200
     3.735    73.534     0.200
     4.092    79.375     0.200
     4.829    93.776     0.200
     8.610   169.644     0.200
     9.249   182.584     0.200
     9.742   188.937     0.200
    10.236   201.373     0.200
    10.627   205.505     0.200
    10.824   208.810     0.200
     3.365    66.658     0.200
     3.680    72.085     0.200
     4.307    83.857     0.200
     4.747    92.936     0.200
     4.883    96.944     0.200
     6.105   118.684     0.200
     3.652    73.585     0.200
     4.290    82.940     0.200
     4.702    94.235     0.200
     4.849    96.414     0.200
     7.127   137.841     0.200
     3.222    63.172     0.200
     3.551    70.527     0.200
     3.894    78.524     0.200
     4.492    87.454     0.200
     4.959    96.995     0.200
     6.321   125.802     0.200
     7.426   146.910     0.200
     7.697   149.953     0.200
     9.409   181.768     0.200
     9.901   193.426     0.200
    10.674   209.707     0.200
    10.786   211.402     0.200
     2.730    52.653     0.200
     2.717    53.913     0.200
     3.640    72.537     0.200
     3.964    77.750     0.200
     4.271    84.674     0.200
     4.906    95.062     0.200
     5.126   101.192     0.200
     5.449   107.930     0.200
     7.524   149.009     0.200
     7.785   151.365     0.200
     8.034   158.263     0.200
     9.135   177.404     0.200
     9.769   188.514     0.200
    10.274   199.916     0.200
    10.734   208.755     0.200
    11.164   216.834     0.200
    11.375   222.565     0.200
     3.069    59.995     0.200
     3.920    76.662     0.200
     4.257    84.232     0.200
     5.195   101.789     0.200
     5.501   109.718     0.200
     5.810   114.612     0.200
     7.036   138.997     0.200
     7.893   152.999     0.200
     8.137   160.948     0.200
     9.484   181.737     0.200
    10.617   208.212     0.200
    11.097   217.412     0.200
     2.652    51.216     0.200
     2.621    51.785     0.200
     3.850    75.230     0.200
     4.162    81.598     0.200
     4.792    93.741     0.200
     5.062    98.592     0.200
     5.346   104.575     0.200
     6.584   129.332     0.200
     7.466   148.634     0.200
     7.679   150.252     0.200
     3.081    59.949     0.200
     4.267    84.203     0.200
     4.267    83.804     0.200
     4.622    92.962     0.200
     5.205   103.364     0.200
     5.164   102.235     0.200
     5.514   108.855     0.200
     5.667   113.875     0.200
     5.823   114.657     0.200
     7.049   136.349     0.200
     2.575    51.531     0.200
     2.629    50.102     0.200
     2.595    51.302     0.200
     3.498    68.757     0.200
     3.823    75.767     0.200
     4.136    81.816     0.200
     5.048   101.673     0.200
     5.322   105.975     0.200
     2.564    52.316     0.200
     3.953    77.915     0.200
     4.507    88.242     0.200
     5.099   101.037     0.200
     5.187   102.008     0.200
     5.802   113.731     0.200
     6.275   125.707     0.200
     7.430   145.630     0.200
     7.915   154.966     0.200
     2.825    54.498     0.200
     3.252    62.714     0.200
     4.314    83.223     0.200
     4.777    92.521     0.200
     5.426   105.747     0.200
     5.968   116.723     0.200
     6.872   135.769     0.200
     8.054   155.274     0.200
     8.058   155.228     0.200
     8.338   163.458     0.200
     2.728    54.011     0.200
     2.838    55.928     0.200
     3.731    72.102     0.200
     4.059    80.072     0.200
     4.059    79.674     0.200
     4.379    86.540     0.200
     5.000    97.495     0.200
     5.239   102.103     0.200
     5.562   110.434     0.200
     6.801   132.373     0.200
     7.635   150.046     0.200
     7.774   150.524     0.200
     7.897   152.091     0.200
    10.384   202.870     0.200
     2.858    54.547     0.200
     3.254    62.334     0.200
     3.472    69.579     0.200
     3.639    70.140     0.200
     4.471    86.124     0.200
     4.756    91.104     0.200
     4.813    92.729     0.200
     4.813    94.928     0.200
     5.180   101.553     0.200
     5.295   104.307     0.200
     5.748   111.320     0.200
     5.748   112.720     0.200
     5.977   116.149     0.200
     6.375   124.205     0.200
     7.542   148.173     0.200
     7.606   148.243     0.200
     8.344   161.023     0.200
     8.586   168.103     0.200
     8.706   170.205     0.200
     8.961   176.525     0.200
     9.078   177.967     0.200
     9.579   187.317     0.200
     9.978   195.261     0.200
    10.053   196.986     0.200
    10.690   207.156     0.200
    11.186   215.658     0.200
    12.072   234.826     0.200
    12.260   239.823     0.200
     2.663    52.300     0.200
     2.895    57.894     0.200
     3.272    66.494     0.200
     3.444    66.489     0.200
     4.143    81.232     0.200
     4.722    92.572     0.200
     5.315   104.849     0.200
     5.677   112.123     0.200
     6.591   132.065     0.200
     2.661    53.999     0.200
     2.891    57.021     0.200
     3.223    64.144     0.200
     3.593    71.028     0.200
     4.162    80.285     0.200
     4.832    95.267     0.200
     4.825    97.152     0.200
     6.022   116.475     0.200
    10.118   194.380     0.200
     2.567    49.658     0.200
     2.568    50.053     0.200
     2.859    57.154     0.200
     3.406    65.176     0.200
     3.662    70.987     0.200
     3.919    78.479     0.200
     4.343    87.437     0.200
     4.811    95.670     0.200
     5.144   101.185     0.200
     5.459   106.912     0.200
     6.051   120.302     0.200
     6.084   120.722     0.200
     6.612   128.452     0.200
     7.875   154.512     0.200
     8.381   162.312     0.200
     8.370   161.236     0.200
     8.960   173.248     0.200
     9.289   181.618     0.200
    10.224   201.200     0.200
    11.888   230.984     0.200
     2.687    54.021     0.200
     2.687    53.021     0.200
     2.627    52.614     0.200
     2.627    53.714     0.200
     3.002    59.241     0.200
     3.313    65.006     0.200
     3.313    65.306     0.200
     3.945    78.239     0.200
     3.945    77.239     0.200
     4.529    87.818     0.200
     4.529    88.418     0.200
     4.510    90.336     0.200
     5.740   110.990     0.200
     6.538   129.179     0.200
     6.542   129.129     0.200
     6.844   132.898     0.200
     6.944   137.936     0.200
     7.255   142.909     0.200
     8.120   159.507     0.200
     8.827   172.857     0.200
     9.320   180.010     0.200
     9.817   192.108     0.200
    10.206   197.173     0.200
    10.407   200.518     0.200
     2.661    52.517     0.200
     2.661    53.017     0.200
     2.892    57.213     0.200
     3.225    62.936     0.200
     3.225    64.136     0.200
     3.595    69.415     0.200
     3.595    71.118     0.200
     4.164    81.976     0.200
     4.164    81.874     0.200
     2.522    50.434     0.200
     2.968    59.030     0.200
     3.169    63.483     0.200
     3.958    77.478     0.200
     4.304    84.032     0.200
     4.706    93.142     0.200
     5.250    99.799     0.200
     5.236   101.357     0.200
     5.705   114.188     0.200
     5.934   118.121     0.200
     2.504    50.551     0.200
     3.227    63.721     0.200
     3.542    70.346     0.200
     4.169    81.524     0.200
     4.351    85.595     0.200
     4.545    89.231     0.200
     4.750    93.540     0.200
     7.087   140.764     0.200
     2.907    56.995     0.200
     2.990    58.816     0.200
     3.028    58.166     0.200
     4.249    83.725     0.200
     4.527    90.277     0.200
     5.035    99.947     0.200
     5.192   102.023     0.200
     5.233   102.435     0.200
     5.678   112.157     0.200
     7.609   149.910     0.200
     2.823    55.175     0.200
     2.915    57.409     0.200
     2.915    56.909     0.200
     3.506    70.706     0.200
     3.527    68.860     0.200
     3.677    70.314     0.200
     4.388    86.607     0.200
     4.533    89.821     0.200
     4.839    95.445     0.200
     4.853    98.589     0.200
     5.046   100.438     0.200
     5.414   106.736     0.200
     5.782   114.045     0.200
     6.127   121.424     0.200
     7.434   146.172     0.200
     7.725   151.672     0.200
     8.079   157.437     0.200
     8.628   168.235     0.200
     8.684   170.480     0.200
     8.761   171.179     0.200
     9.741   191.249     0.200
     9.856   193.405     0.200
    11.012   212.806     0.200
    11.376   221.658     0.200
    11.914   232.884     0.200
    12.178   236.702     0.200
    16.152   324.809     0.200
     2.538    49.275     0.200
     2.538    48.971     0.200
     3.324    65.101     0.200
     3.645    70.858     0.200
     3.934    76.580     0.200
     3.947    77.728     0.200
     4.587    90.557     0.200
     4.891    96.210     0.200
     5.132   101.995     0.200
     6.369   125.168     0.200
     7.134   138.239     0.200
     7.173   139.178     0.200
     7.304   143.156     0.200
     7.464   145.577     0.200
     7.667   149.313     0.200
     7.840   154.398     0.200
     9.448   185.231     0.200
     9.951   191.864     0.200
    10.419   201.598     0.200
     2.792    53.331     0.200
     2.878    56.916     0.200
     3.041    59.519     0.200
     3.354    64.468     0.200
     3.446    65.200     0.200
     3.729    72.986     0.200
     3.883    75.391     0.200
     4.221    82.944     0.200
     4.582    90.734     0.200
     5.158   101.009     0.200
     5.215   103.644     0.200
     5.500   108.930     0.200
     5.717   113.692     0.200
     5.787   113.777     0.200
     7.009   138.715     0.200
     7.791   150.084     0.200
     7.827   153.471     0.200
     7.895   153.274     0.200
     8.112   157.344     0.200
     8.498   166.032     0.200
     2.806    53.370     0.200
     2.881    57.799     0.200
     3.039    59.855     0.200
     3.039    60.454     0.200
     3.350    66.428     0.200
     3.442    67.246     0.200
     3.717    73.845     0.200
     3.887    77.258     0.200
     4.224    82.724     0.200
     4.224    83.423     0.200
     4.580    90.768     0.200
     5.162   101.383     0.200
     5.203   103.005     0.200
     5.485   109.806     0.200
     5.703   113.870     0.200
     5.782   112.344     0.200
     7.006   138.054     0.200
     8.492   167.518     0.200
     9.382   181.535     0.200
    10.587   206.472     0.200
    11.069   216.941     0.200
    11.472   224.941     0.200
    11.664   226.105     0.200
     2.530    50.418     0.200
     3.219    62.369     0.200
     4.984    97.576     0.200
     5.372   103.952     0.200
     5.915   115.806     0.200
     6.192   123.182     0.200
     6.577   128.581     0.200
     7.420   146.449     0.200
     8.579   166.718     0.200
     8.557   167.582     0.200
     8.903   174.637     0.200
     2.592    51.365     0.200
     3.451    67.642     0.200
     3.829    74.828     0.200
     4.389    85.599     0.200
     5.003    98.724     0.200
     6.258   121.478     0.200
     6.362   126.664     0.200
     7.080   138.485     0.200
     7.100   136.562     0.200
     7.371   144.798     0.200
     7.430   143.002     0.200
     9.834   193.246     0.200
     2.505    48.378     0.200
     2.598    51.495     0.200
     2.598    51.792     0.200
     2.789    54.464     0.200
     2.789    54.862     0.200
     3.596    71.554     0.200
     3.596    70.749     0.200
     3.733    73.547     0.200
     3.733    72.352     0.200
     3.938    76.754     0.200
     3.938    76.957     0.200
     4.025    78.638     0.200
     4.327    84.518     0.200
     4.327    84.213     0.200
     4.873    95.246     0.200
     4.873    95.348     0.200
     5.386   106.255     0.200
     6.394   125.588     0.200
     6.756   131.865     0.200
     7.568   148.096     0.200
     7.798   151.203     0.200
     7.867   154.207     0.200
     8.095   159.547     0.200
     8.280   164.086     0.200
     9.145   179.591     0.200
     9.849   191.670     0.200
    10.333   201.128     0.200
    10.844   211.665     0.200
    11.214   218.449     0.200
    11.390   221.600     0.200
     2.684    53.095     0.200
     2.684    52.895     0.200
     3.500    69.974     0.200
     3.500    69.673     0.200
     3.840    75.203     0.200
     3.840    75.504     0.200
     3.828    74.546     0.200
     4.092    80.470     0.200
     4.222    83.143     0.200
     4.776    94.383     0.200
     5.291   104.674     0.200
     5.449   107.123     0.200
     6.064   117.359     0.200
     6.651   130.199     0.200
     7.462   146.642     0.200
     7.486   144.155     0.200
     7.761   150.245     0.200
     8.039   158.502     0.200
     8.173   160.738     0.200
     9.039   176.136     0.200
     9.102   176.305     0.200
     9.744   190.413     0.200
    10.228   197.956     0.200
    10.737   209.714     0.200
     2.502    49.816     0.200
     2.502    49.917     0.200
     2.691    52.710     0.200
     2.691    52.210     0.200
     3.502    69.647     0.200
     3.502    69.346     0.200
     3.826    75.259     0.200
     3.843    76.069     0.200
     3.843    74.569     0.200
     4.097    77.996     0.200
     4.229    82.963     0.200
     4.778    94.752     0.200
     4.778    93.154     0.200
     5.306   105.996     0.200
     5.458   106.516     0.200
     5.582   108.070     0.200
     6.071   122.860     0.200
     6.658   130.514     0.200
     7.471   146.130     0.200
    10.234   197.878     0.200
    10.746   210.108     0.200
    11.115   213.396     0.200
    11.292   221.029     0.200
     2.507    49.131     0.200
     2.695    53.038     0.200
     2.695    52.738     0.200
     3.507    69.560     0.200
     3.821    72.404     0.200
     3.821    72.104     0.200
     3.848    75.879     0.200
     4.091    78.353     0.200
     4.233    82.489     0.200
     4.784    95.166     0.200
     5.306   103.768     0.200
     5.462   106.952     0.200
     5.575   105.930     0.200
     6.064   119.018     0.200
     7.474   145.968     0.200
     7.498   148.487     0.200
     7.773   150.681     0.200
     8.001   156.218     0.200
     8.186   161.257     0.200
     9.051   175.168     0.200
     9.755   188.449     0.200
    10.239   199.504     0.200
    10.750   211.044     0.200
    11.120   216.517     0.200
    11.298   217.547     0.200
     2.535    50.388     0.200
     3.397    67.927     0.200
     3.729    72.255     0.200
     3.939    78.304     0.200
     4.076    80.504     0.200
     4.126    79.519     0.200
     4.669    93.290     0.200
     5.096    99.907     0.200
     5.286   104.386     0.200
     5.606   108.450     0.200
     6.503   127.983     0.200
     7.294   141.953     0.200
     8.882   174.822     0.200
    10.083   198.006     0.200
    11.161   218.126     0.200
     2.687    52.525     0.200
     3.505    69.275     0.200
     3.823    72.668     0.200
     3.845    74.909     0.200
     4.084    78.220     0.200
     4.225    83.071     0.200
     4.781    93.886     0.200
     5.288   104.765     0.200
     5.451   106.564     0.200
     5.568   104.600     0.200
     6.056   120.010     0.200
     6.654   128.826     0.200
     7.703   149.486     0.200
     7.764   152.476     0.200
     2.661    52.493     0.200
     2.661    52.993     0.200
     3.482    68.420     0.200
     3.821    74.059     0.200
     3.821    75.659     0.200
     3.847    75.558     0.200
     3.847    75.758     0.200
     3.871    73.270     0.200
     4.011    75.742     0.200
     4.200    81.737     0.200
     4.495    85.894     0.200
     4.757    92.333     0.200
     5.266   104.093     0.200
     5.426   106.233     0.200
     6.071   122.799     0.200
     6.629   129.993     0.200
     7.682   149.705     0.200
     7.738   151.144     0.200
     8.149   160.250     0.200
     2.655    52.069     0.200
     3.853    75.185     0.200
     4.008    77.775     0.200
     4.107    80.623     0.200
     4.107    79.123     0.200
     4.193    82.413     0.200
     5.591   109.007     0.200
     7.958   152.283     0.200
     8.099   153.830     0.200
     2.626    51.221     0.200
     3.797    73.550     0.200
     3.869    73.611     0.200
     4.037    77.349     0.200
     4.102    80.594     0.200
     4.166    81.454     0.200
     4.735    92.710     0.200
     5.214   101.522     0.200
     8.001   153.098     0.200
     2.646    52.554     0.200
     3.468    68.851     0.200
     3.807    75.297     0.200
     3.860    74.180     0.200
     3.860    74.479     0.200
     3.860    74.780     0.200
     4.110    80.367     0.200
     4.184    82.795     0.200
     4.744    92.766     0.200
     5.250   102.959     0.200
     5.409   105.399     0.200
     5.593   109.153     0.200
     6.078   120.701     0.200
     6.613   129.153     0.200
     7.421   146.124     0.200
     7.446   143.428     0.200
     7.666   149.167     0.200
     7.722   150.608     0.200
     7.948   155.670     0.200
     8.133   159.920     0.200
     9.000   174.702     0.200
     9.705   187.872     0.200
    10.190   197.505     0.200
    10.697   208.890     0.200
    11.072   213.812     0.200
    11.253   218.301     0.200
     2.517    49.019     0.200
     2.517    49.519     0.200
     2.718    52.267     0.200
     2.718    52.669     0.200
     3.523    67.970     0.200
     3.523    68.869     0.200
     3.865    74.280     0.200
     3.865    74.479     0.200
     3.805    72.879     0.200
     3.805    72.679     0.200
     4.087    79.394     0.200
     4.087    77.991     0.200
     4.255    82.127     0.200
     4.435    84.731     0.200
     4.800    93.570     0.200
     5.335   104.021     0.200
     5.486   105.863     0.200
     5.572   105.263     0.200
     7.499   145.270     0.200
     7.751   151.534     0.200
     7.796   151.307     0.200
     8.211   159.059     0.200
     2.502    49.243     0.200
     2.689    53.064     0.200
     2.689    53.165     0.200
     3.503    68.166     0.200
     3.503    69.666     0.200
     3.825    73.205     0.200
     3.825    73.306     0.200
     3.844    75.192     0.200
     3.844    75.091     0.200
     4.005    76.013     0.200
     4.092    78.498     0.200
     4.092    77.998     0.200
     4.227    83.215     0.200
     4.466    85.230     0.200
     4.779    93.977     0.200
     5.298   104.418     0.200
     5.455   106.886     0.200
     5.576   105.073     0.200
     7.714   149.827     0.200
     7.767   149.310     0.200
     8.362   158.758     0.200
     2.674    52.505     0.200
     3.493    68.852     0.200
     3.832    75.886     0.200
     3.836    73.347     0.200
     4.011    77.593     0.200
     4.095    81.519     0.200
     4.213    82.550     0.200
     5.579   107.902     0.200
     2.500    49.666     0.200
     2.500    49.466     0.200
     2.687    52.484     0.200
     2.687    52.684     0.200
     3.499    69.801     0.200
     3.499    69.301     0.200
     3.840    74.824     0.200
     3.829    73.355     0.200
     3.829    74.055     0.200
     4.225    82.636     0.200
     4.225    82.036     0.200
     4.097    80.228     0.200
     4.097    78.828     0.200
     4.468    86.401     0.200
     4.776    92.207     0.200
     4.776    92.407     0.200
     5.299   102.897     0.200
     5.453   105.299     0.200
     6.292   123.013     0.200
     6.654   128.588     0.200
     7.466   144.313     0.200
     7.490   148.633     0.200
     7.764   150.629     0.200
     7.715   150.109     0.200
     7.992   155.366     0.200
     8.043   158.175     0.200
     8.659   169.285     0.200
     9.042   174.716     0.200
     9.104   178.594     0.200
     9.746   188.598     0.200
    10.230   198.149     0.200
    11.289   219.092     0.200
    14.642   288.068     0.200
     2.667    52.397     0.200
     2.667    52.096     0.200
     3.484    68.366     0.200
     3.484    69.163     0.200
     3.824    75.598     0.200
     3.824    74.695     0.200
     3.845    74.950     0.200
     3.845    72.751     0.200
     4.002    76.408     0.200
     4.205    82.042     0.200
     4.105    79.914     0.200
     4.105    78.016     0.200
     4.488    85.642     0.200
     4.760    94.773     0.200
     5.277   102.032     0.200
     5.277   103.634     0.200
     5.432   106.822     0.200
     5.589   107.395     0.200
     7.445   145.141     0.200
     7.693   152.041     0.200
     7.744   151.441     0.200
     9.022   177.633     0.200
    10.211   200.454     0.200
    10.720   210.710     0.200
    11.277   225.352     0.200
     2.676    52.018     0.200
     3.493    69.084     0.200
     3.835    74.381     0.200
     3.835    73.482     0.200
     3.833    75.217     0.200
     4.008    77.366     0.200
     4.096    80.438     0.200
     4.096    78.735     0.200
     4.214    82.565     0.200
     4.769    94.795     0.200
     5.283   104.298     0.200
     5.441   106.248     0.200
     5.581   106.118     0.200
     2.643    52.817     0.200
     2.696    52.199     0.200
     3.802    75.299     0.200
     3.802    74.901     0.200
     3.881    76.269     0.200
     3.927    77.940     0.200
     3.927    79.237     0.200
     4.184    82.542     0.200
     4.823    95.776     0.200
     5.055    99.974     0.200
     2.668    52.462     0.200
     3.484    69.332     0.200
     3.824    74.963     0.200
     3.844    73.732     0.200
     4.003    76.378     0.200
     4.206    81.811     0.200
     4.104    78.097     0.200
     4.104    78.396     0.200
     4.488    86.622     0.200
     4.760    93.441     0.200
     5.278   105.303     0.200
     5.433   106.289     0.200
     5.588   105.777     0.200
     6.635   128.465     0.200
     7.128   136.308     0.200
     7.445   145.307     0.200
     7.470   148.120     0.200
     7.693   150.413     0.200
     7.745   152.310     0.200
     7.972   155.957     0.200
     8.157   158.800     0.200
     9.022   177.601     0.200
    10.212   198.822     0.200
    11.272   219.447     0.200
    11.277   221.306     0.200
     2.504    49.315     0.200
     2.679    52.572     0.200
     2.679    51.873     0.200
     3.491    69.901     0.200
     3.491    69.502     0.200
     3.837    73.060     0.200
     3.867    73.817     0.200
     3.832    74.122     0.200
     3.832    75.025     0.200
     3.993    76.341     0.200
     4.105    77.734     0.200
     4.105    77.933     0.200
     4.217    81.227     0.200
     4.767    92.307     0.200
     5.446   105.484     0.200
     6.078   115.613     0.200
     6.646   128.778     0.200
     7.117   135.493     0.200
     9.035   177.305     0.200
     9.739   189.088     0.200
    10.223   200.442     0.200
    11.281   218.891     0.200
     2.495    49.443     0.200
     2.664    52.466     0.200
     3.820    74.677     0.200
     3.848    73.346     0.200
     3.875    74.231     0.200
     3.999    77.390     0.200
     4.109    80.504     0.200
     4.202    81.915     0.200
     7.132   135.329     0.200
     2.637    52.003     0.200
     2.829    55.365     0.200
     3.747    72.343     0.200
     3.801    72.911     0.200
     3.851    76.725     0.200
     3.851    76.929     0.200
     3.912    76.521     0.200
     4.172    82.582     0.200
     4.456    87.273     0.200
     4.643    89.691     0.200
     4.855    95.817     0.200
     5.321   103.377     0.200
     7.216   137.162     0.200
     8.366   158.643     0.200
     8.674   166.845     0.200
     2.522    51.091     0.200
     2.522    50.491     0.200
     2.719    52.190     0.200
     2.719    52.590     0.200
     3.789    74.501     0.200
     3.789    74.701     0.200
     3.977    78.212     0.200
     4.059    79.548     0.200
     4.059    80.948     0.200
     4.732    94.197     0.200
     4.883    94.933     0.200
     4.883    96.433     0.200
     5.219   103.010     0.200
     2.869    56.178     0.200
     3.029    59.819     0.200
     3.454    66.957     0.200
     3.454    66.257     0.200
     3.729    73.447     0.200
     3.729    72.345     0.200
     4.155    78.479     0.200
     4.213    82.003     0.200
     4.570    90.134     0.200
     5.215   102.607     0.200
     6.771   129.252     0.200
     7.681   145.730     0.200
     7.828   148.810     0.200
     2.801    53.219     0.200
     2.872    56.690     0.200
     3.030    59.351     0.200
     3.451    66.729     0.200
     3.451    66.830     0.200
     3.451    66.330     0.200
     3.723    73.262     0.200
     3.723    71.461     0.200
     3.878    77.446     0.200
     3.878    78.044     0.200
     4.156    79.008     0.200
     4.215    82.513     0.200
     4.215    81.712     0.200
     4.571    88.865     0.200
     4.571    88.564     0.200
     5.153   100.869     0.200
     5.209    99.122     0.200
     5.477   109.293     0.200
     5.772   114.240     0.200
     6.770   129.198     0.200
     6.997   138.750     0.200
     7.684   145.935     0.200
     7.872   153.442     0.200
     8.099   159.192     0.200
     9.372   184.730     0.200
    10.577   207.565     0.200
    11.655   227.398     0.200
     2.640    52.982     0.200
     2.640    52.482     0.200
     2.631    52.693     0.200
     2.951    57.147     0.200
     2.951    58.351     0.200
     3.249    64.572     0.200
     3.894    76.846     0.200
     4.460    87.534     0.200
     4.442    87.746     0.200
     4.793    95.055     0.200
     5.675   110.861     0.200
     6.778   132.988     0.200
     6.876   135.645     0.200
     9.256   180.675     0.200
     2.784    53.497     0.200
     3.021    59.235     0.200
     3.021    58.336     0.200
     3.463    66.886     0.200
     3.739    73.361     0.200
     3.866    73.771     0.200
     3.866    77.771     0.200
     4.204    81.534     0.200
     4.204    83.331     0.200
     4.562    90.055     0.200
     4.562    89.750     0.200
     5.141   100.198     0.200
     5.478   107.661     0.200
     5.766   113.601     0.200
     6.989   135.534     0.200
     7.874   154.903     0.200
     8.091   156.269     0.200
     2.859    55.141     0.200
     2.590    51.174     0.200
     2.590    50.971     0.200
     2.929    57.520     0.200
     3.640    71.322     0.200
     4.771    92.522     0.200
     5.178   102.173     0.200
     5.700   110.482     0.200
     6.091   120.017     0.200
     6.400   126.715     0.200
     8.472   166.127     0.200
    11.184   214.789     0.200
     2.534    49.794     0.200
     2.534    49.395     0.200
     2.781    54.314     0.200
     2.781    53.212     0.200
     3.505    69.861     0.200
     3.790    72.836     0.200
     3.816    73.941     0.200
     3.816    73.637     0.200
     4.069    79.680     0.200
     4.759    93.437     0.200
     4.845    95.219     0.200
     5.403   102.313     0.200
     6.480   126.037     0.200
     7.243   141.245     0.200
     7.563   147.898     0.200
     7.798   153.768     0.200
     8.828   172.041     0.200
     9.547   184.351     0.200
    10.064   194.221     0.200
    10.497   202.265     0.200
    10.920   211.910     0.200
    10.958   211.593     0.200
     2.538    50.263     0.200
     2.538    49.864     0.200
     2.782    54.316     0.200
     2.782    53.113     0.200
     3.509    70.040     0.200
     3.509    69.634     0.200
     3.819    73.814     0.200
     3.819    74.212     0.200
     4.073    80.147     0.200
     4.073    78.546     0.200
     4.762    92.809     0.200
     4.762    93.411     0.200
     4.850    93.984     0.200
     4.850    93.289     0.200
     5.221   102.246     0.200
     5.400   101.862     0.200
     7.247   140.917     0.200
     7.568   147.568     0.200
     3.560    69.569     0.200
     3.560    69.670     0.200
     3.892    77.896     0.200
     3.892    75.197     0.200
     4.113    78.425     0.200
     4.501    88.786     0.200
     4.929    96.790     0.200
     5.098   100.223     0.200
     5.731   110.235     0.200
     6.188   119.908     0.200
     6.318   122.886     0.200
     7.349   143.958     0.200
     7.420   146.821     0.200
     3.236    64.826     0.200
     3.236    63.626     0.200
     3.563    69.907     0.200
     3.563    68.907     0.200
     3.897    77.718     0.200
     4.109    79.637     0.200
     3.227    63.214     0.200
     3.554    70.107     0.200
     3.884    77.355     0.200
     4.495    88.624     0.200
     5.089   100.983     0.200
     5.735   109.949     0.200
     7.340   143.723     0.200
     3.231    63.846     0.200
     3.231    64.545     0.200
     3.558    70.137     0.200
     3.558    69.535     0.200
     3.888    77.480     0.200
     3.888    76.082     0.200
     4.499    88.052     0.200
     4.923    95.901     0.200
     5.094   100.813     0.200
     5.935   117.597     0.200
     6.314   124.671     0.200
     6.556   128.345     0.200
     7.343   144.468     0.200
     7.416   145.109     0.200
     7.810   153.708     0.200
     8.690   167.239     0.200
     9.895   191.284     0.200
    10.980   211.924     0.200
     2.527    50.530     0.200
     2.696    53.756     0.200
     3.288    64.952     0.200
     3.288    67.350     0.200
     3.635    71.501     0.200
     3.635    70.903     0.200
     4.057    79.877     0.200
     4.566    89.433     0.200
     4.566    90.234     0.200
     5.274   104.076     0.200
     5.312   105.139     0.200
     6.486   127.428     0.200
     7.605   149.371     0.200
     7.700   151.664     0.200
     3.235    63.968     0.200
     3.235    64.468     0.200
     3.562    69.353     0.200
     3.562    69.150     0.200
     3.895    77.161     0.200
     3.895    74.661     0.200
     4.110    79.048     0.200
     4.503    89.067     0.200
     4.503    88.067     0.200
     4.935    95.527     0.200
     5.102   100.780     0.200
     5.731   110.334     0.200
     6.321   123.153     0.200
     7.354   143.495     0.200
     7.424   146.183     0.200
     9.407   185.038     0.200
     9.902   194.370     0.200
    10.787   209.728     0.200
    10.985   214.622     0.200
     2.813    53.487     0.200
     2.887    56.314     0.200
     3.045    59.976     0.200
     3.045    59.781     0.200
     3.436    66.214     0.200
     3.710    72.518     0.200
     3.893    76.978     0.200
     4.141    80.780     0.200
     4.231    83.442     0.200
     4.231    82.239     0.200
     4.586    90.693     0.200
     4.586    88.795     0.200
     5.168   102.001     0.200
     5.168    99.696     0.200
     5.488   108.371     0.200
     5.787   113.777     0.200
     6.630   130.844     0.200
     6.755   128.476     0.200
     7.790   151.797     0.200
     7.827   153.069     0.200
     7.882   155.229     0.200
     8.497   166.850     0.200
    10.097   197.876     0.200
    11.478   223.561     0.200
    11.554   229.073     0.200
    11.670   226.424     0.200
     2.698    52.137     0.200
     2.698    52.239     0.200
     2.769    54.517     0.200
     3.005    59.256     0.200
     3.005    58.850     0.200
     3.606    68.643     0.200
     3.745    73.023     0.200
     3.745    73.819     0.200
     4.141    79.898     0.200
     4.098    79.408     0.200
     4.535    88.803     0.200
     4.535    88.600     0.200
     5.024    98.292     0.200
     5.670   111.553     0.200
     5.787   112.788     0.200
     6.622   129.946     0.200
     6.964   136.250     0.200
     7.749   151.901     0.200
     7.805   150.840     0.200
     8.085   158.074     0.200
     8.327   164.342     0.200
     8.377   163.067     0.200
     8.520   167.197     0.200
     9.365   182.735     0.200
     9.416   182.035     0.200
    10.534   204.391     0.200
    11.073   217.200     0.200
    11.410   220.675     0.200
    11.665   228.294     0.200
     2.711    52.614     0.200
     2.773    53.784     0.200
     3.013    58.894     0.200
     3.013    58.793     0.200
     3.605    69.481     0.200
     3.748    72.707     0.200
     3.748    73.807     0.200
     4.024    77.193     0.200
     4.101    79.586     0.200
     4.101    79.687     0.200
     4.542    88.549     0.200
     5.027    97.981     0.200
     5.683   111.533     0.200
     5.796   113.016     0.200
     6.799   129.806     0.200
     6.971   135.800     0.200
     3.231    63.138     0.200
     3.231    65.037     0.200
     3.558    69.616     0.200
     3.558    68.715     0.200
     4.261    84.209     0.200
     4.499    88.636     0.200
     4.937    96.026     0.200
     5.101   100.317     0.200
     5.941   115.603     0.200
     6.319   123.298     0.200
     7.357   142.087     0.200
     7.422   145.225     0.200
     2.541    50.412     0.200
     2.541    49.512     0.200
     2.710    51.645     0.200
     3.563    70.392     0.200
     3.563    71.191     0.200
     3.800    73.720     0.200
     3.918    77.045     0.200
     3.885    75.735     0.200
     3.885    75.334     0.200
     4.183    82.452     0.200
     4.183    83.653     0.200
     4.827    93.041     0.200
     5.043    98.519     0.200
     5.043    98.119     0.200
     5.394   102.223     0.200
     5.358   106.139     0.200
     6.203   122.584     0.200
     6.603   129.712     0.200
     7.178   136.399     0.200
     7.355   143.037     0.200
     7.695   151.965     0.200
     7.891   154.187     0.200
    11.102   220.766     0.200
    11.290   218.913     0.200
     2.523    49.372     0.200
     2.633    50.986     0.200
     2.633    51.188     0.200
     2.675    51.399     0.200
     3.543    70.067     0.200
     3.814    72.206     0.200
     3.867    73.888     0.200
     3.946    76.469     0.200
     4.174    80.806     0.200
     4.174    81.405     0.200
     4.809    92.797     0.200
     5.355   104.623     0.200
     6.199   121.673     0.200
     6.595   130.248     0.200
     7.462   145.332     0.200
     7.689   151.178     0.200
     2.536    49.965     0.200
     2.640    52.744     0.200
     2.640    52.549     0.200
     2.698    52.476     0.200
     2.698    52.375     0.200
     3.557    70.753     0.200
     3.557    71.151     0.200
     3.804    73.463     0.200
     3.879    75.785     0.200
     3.927    75.631     0.200
     4.181    81.571     0.200
     4.181    80.868     0.200
     4.821    94.893     0.200
     4.821    94.596     0.200
     5.358   106.131     0.200
     5.403   104.498     0.200
     6.202   120.879     0.200
     6.601   130.224     0.200
     7.355   142.218     0.200
     7.451   145.604     0.200
     7.694   150.266     0.200
     8.963   173.358     0.200
    10.184   199.711     0.200
    11.106   217.172     0.200
     2.540    50.266     0.200
     2.540    49.169     0.200
     2.701    52.796     0.200
     3.800    72.273     0.200
     3.800    72.070     0.200
     3.884    76.387     0.200
     3.884    74.488     0.200
     3.923    77.428     0.200
     4.185    81.867     0.200
     4.577    88.099     0.200
     4.826    93.894     0.200
     5.399   102.700     0.200
     6.606   129.722     0.200
     7.360   143.018     0.200
     7.454   146.319     0.200
     7.699   149.967     0.200
     2.544    50.810     0.200
     2.706    52.824     0.200
     3.565    71.494     0.200
     3.888    76.131     0.200
     3.918    77.481     0.200
     4.189    82.922     0.200
     4.575    89.014     0.200
     4.830    94.838     0.200
     5.365   105.893     0.200
     6.210   122.740     0.200
     6.609   130.678     0.200
     7.362   143.985     0.200
     7.454   146.918     0.200
     7.702   151.426     0.200
     8.066   159.075     0.200
    11.111   219.135     0.200
     3.243    63.576     0.200
     3.572    68.936     0.200
     3.572    68.733     0.200
     3.914    77.652     0.200
     4.098    79.008     0.200
     4.513    87.962     0.200
     4.969    98.632     0.200
     5.125   101.108     0.200
     6.341   124.831     0.200
     7.424   143.279     0.200
     7.389   143.492     0.200
     7.445   145.444     0.200
     8.720   170.461     0.200
     9.921   192.453     0.200
     2.502    48.500     0.200
     2.502    47.900     0.200
     2.554    51.089     0.200
     2.736    54.366     0.200
     2.736    53.866     0.200
     3.556    70.699     0.200
     3.556    71.499     0.200
     3.773    72.268     0.200
     3.773    71.368     0.200
     3.800    72.045     0.200
     3.896    76.932     0.200
     3.896    75.932     0.200
     4.039    76.854     0.200
     4.275    84.308     0.200
     4.422    85.089     0.200
     4.832    95.009     0.200
     5.321   105.997     0.200
     5.499   108.325     0.200
     6.703   131.264     0.200
     7.059   134.710     0.200
     7.452   146.126     0.200
     7.734   153.342     0.200
     7.812   153.922     0.200
     9.090   177.618     0.200
     9.795   190.287     0.200
    10.281   199.616     0.200
    11.343   220.721     0.200
     3.367    66.601     0.200
     3.701    73.494     0.200
     4.308    84.916     0.200
     4.810    94.358     0.200
     4.916    98.021     0.200
     5.908   112.847     0.200
     6.128   119.171     0.200
     7.236   140.145     0.200
     2.527    49.093     0.200
     2.527    50.393     0.200
     2.636    51.631     0.200
     2.636    52.031     0.200
     2.683    51.180     0.200
     2.683    52.280     0.200
     3.786    72.506     0.200
     3.871    74.910     0.200
     3.871    75.410     0.200
     4.176    81.150     0.200
     4.176    82.350     0.200
     4.813    93.619     0.200
     5.056   100.287     0.200
     5.356   104.483     0.200
     6.200   122.732     0.200
     6.597   129.497     0.200
     7.354   144.362     0.200
     7.458   145.850     0.200
     8.059   158.144     0.200
     2.645    51.403     0.200
     2.645    52.207     0.200
     3.481    69.552     0.200
     3.481    69.450     0.200
     3.849    74.754     0.200
     3.849    73.449     0.200
     3.818    74.316     0.200
     4.082    78.624     0.200
     4.184    82.737     0.200
     4.755    92.680     0.200
     4.755    92.578     0.200
     5.224   103.904     0.200
     5.403   106.810     0.200
     5.565   105.319     0.200
     6.047   117.107     0.200
     6.243   122.509     0.200
     6.613   129.401     0.200
     7.392   144.704     0.200
     7.413   144.454     0.200
     7.441   145.528     0.200
     7.638   149.734     0.200
     7.720   152.081     0.200
     8.996   174.983     0.200
    10.191   196.938     0.200
    11.074   215.632     0.200
    11.259   218.573     0.200
     2.639    51.294     0.200
     2.639    52.595     0.200
     3.480    69.587     0.200
     3.851    73.554     0.200
     3.865    74.389     0.200
     3.816    73.461     0.200
     3.816    74.461     0.200
     4.179    83.122     0.200
     4.525    88.489     0.200
     4.754    93.016     0.200
     4.754    92.618     0.200
     5.211   104.278     0.200
     5.560   105.704     0.200
     6.041   116.202     0.200
     6.236   123.014     0.200
     6.607   129.487     0.200
     7.377   143.999     0.200
     7.434   144.732     0.200
     7.625   148.510     0.200
     7.714   151.874     0.200
     8.116   156.680     0.200
     8.990   175.683     0.200
     9.697   190.434     0.200
    10.186   197.024     0.200
    11.069   214.715     0.200
    11.256   218.838     0.200
     2.636    52.253     0.200
     2.636    52.651     0.200
     3.475    69.560     0.200
     3.812    73.436     0.200
     3.812    74.537     0.200
     3.855    74.732     0.200
     3.855    73.631     0.200
     3.870    74.559     0.200
     4.176    82.980     0.200
     4.749    93.191     0.200
     4.749    92.890     0.200
     5.212   102.788     0.200
     5.394   106.569     0.200
     6.234   123.466     0.200
     6.604   127.344     0.200
     7.382   144.806     0.200
     7.404   146.615     0.200
     7.432   146.785     0.200
     7.626   149.119     0.200
     7.627   147.812     0.200
     7.984   155.550     0.200
     8.987   174.933     0.200
     9.694   189.289     0.200
    10.183   196.981     0.200
    10.682   206.357     0.200
    11.222   221.839     0.200
    11.252   219.704     0.200
     2.639    51.652     0.200
     2.639    52.652     0.200
     3.474    67.902     0.200
     3.811    74.072     0.200
     3.856    76.553     0.200
     3.872    73.757     0.200
     4.178    82.885     0.200
     4.178    81.487     0.200
     4.749    93.232     0.200
     4.749    92.732     0.200
     5.221   102.220     0.200
     6.238   123.754     0.200
     6.607   130.650     0.200
     7.394   145.763     0.200
     7.408   145.392     0.200
     7.436   147.069     0.200
     7.631   149.286     0.200
     7.635   149.343     0.200
     7.714   150.524     0.200
     7.987   154.835     0.200
    10.686   206.045     0.200
    11.253   219.326     0.200
     2.701    52.123     0.200
     2.701    53.623     0.200
     2.803    53.325     0.200
     2.803    53.528     0.200
     3.783    73.797     0.200
     4.045    78.038     0.200
     4.987    97.049     0.200
     5.526   108.851     0.200
     6.371   125.595     0.200
     6.772   133.016     0.200
     7.522   146.254     0.200
     7.577   147.923     0.200
     7.733   149.994     0.200
     7.864   152.674     0.200
     8.225   160.053     0.200
    10.354   200.706     0.200
    11.244   218.320     0.200
    11.456   222.250     0.200
     2.698    52.583     0.200
     2.698    53.388     0.200
     2.805    53.639     0.200
     3.783    73.919     0.200
     4.042    78.702     0.200
     4.984    97.611     0.200
     5.521   108.441     0.200
     6.366   125.778     0.200
     6.767   132.903     0.200
     7.517   147.051     0.200
     7.570   148.233     0.200
     7.728   150.589     0.200
     8.053   158.092     0.200
     2.819    56.183     0.200
     2.669    50.828     0.200
     3.203    62.301     0.200
     3.920    77.142     0.200
     4.136    80.214     0.200
     4.893    94.879     0.200
     5.673   110.681     0.200
     6.172   119.757     0.200
     6.547   127.279     0.200
     6.898   134.283     0.200
     7.738   151.675     0.200
     8.936   174.596     0.200
     9.124   179.104     0.200
     9.613   189.194     0.200
     2.529    48.276     0.200
     2.715    51.599     0.200
     2.913    56.595     0.200
     3.273    62.292     0.200
     3.453    66.994     0.200
     3.453    66.095     0.200
     3.931    77.313     0.200
     4.161    81.228     0.200
     4.897    96.039     0.200
     5.254   103.072     0.200
     5.695   112.624     0.200
     6.175   121.225     0.200
     6.612   130.127     0.200
     6.930   136.111     0.200
     7.769   154.121     0.200
     8.125   159.368     0.200
     8.967   174.539     0.200
     9.162   180.665     0.200
     9.240   182.857     0.200
     9.469   185.682     0.200
     9.651   190.166     0.200
    10.519   206.634     0.200
    11.221   217.938     0.200
    11.697   226.382     0.200
    12.218   238.501     0.200
    12.574   244.453     0.200
    12.724   248.995     0.200
     2.547    50.334     0.200
     2.730    53.501     0.200
     3.548    70.953     0.200
     3.548    69.547     0.200
     3.780    72.145     0.200
     3.780    72.340     0.200
     3.808    72.611     0.200
     3.888    76.077     0.200
     4.269    83.740     0.200
     4.427    83.992     0.200
     4.824    93.656     0.200
     5.320   104.073     0.200
     5.493   108.047     0.200
     6.333   123.654     0.200
     6.697   129.794     0.200
     7.065   135.500     0.200
     7.457   145.032     0.200
     7.729   152.161     0.200
     7.807   153.051     0.200
     8.032   156.520     0.200
     8.216   161.376     0.200
     9.084   175.442     0.200
     9.789   190.620     0.200
    10.275   200.649     0.200
    10.781   210.938     0.200
    11.156   217.663     0.200
    11.336   220.762     0.200
     2.805    56.979     0.200
     2.805    55.081     0.200
     3.118    59.925     0.200
     3.118    61.628     0.200
     3.415    67.061     0.200
     3.415    68.061     0.200
     4.061    79.624     0.200
     4.539    87.046     0.200
     4.575    88.925     0.200
     4.537    88.969     0.200
     4.633    91.046     0.200
     4.618    90.729     0.200
     4.618    90.526     0.200
     5.458   107.714     0.200
     5.839   115.067     0.200
     6.850   134.970     0.200
     6.940   135.026     0.200
     6.967   137.002     0.200
     7.127   138.342     0.200
     8.214   160.260     0.200
     9.421   183.577     0.200
    10.308   199.018     0.200
     2.885    56.220     0.200
     2.885    55.220     0.200
     3.267    62.765     0.200
     3.404    67.372     0.200
     3.673    72.623     0.200
     3.759    72.729     0.200
     4.352    84.003     0.200
     4.714    91.576     0.200
     5.226    98.501     0.200
     5.196   101.962     0.200
     5.628   109.111     0.200
     6.462   127.085     0.200
     7.294   143.870     0.200
     7.623   148.635     0.200
     8.128   159.738     0.200
     8.716   172.179     0.200
     8.713   171.005     0.200
     8.748   170.303     0.200
     9.197   180.662     0.200
    10.031   194.625     0.200
    11.186   217.553     0.200
    12.056   233.600     0.200
    12.187   236.471     0.200
    12.338   243.393     0.200
     2.718    53.023     0.200
     2.718    53.123     0.200
     3.242    63.415     0.200
     3.388    65.607     0.200
     3.488    66.841     0.200
     3.862    74.077     0.200
     3.976    78.244     0.200
     4.330    84.609     0.200
     4.772    92.057     0.200
     4.772    92.958     0.200
     5.255   101.520     0.200
     5.865   115.906     0.200
     6.022   118.068     0.200
     6.857   133.419     0.200
     7.201   141.907     0.200
     8.753   170.601     0.200
    10.771   209.344     0.200
    11.646   225.331     0.200
    11.798   227.259     0.200
     2.668    52.282     0.200
     2.668    52.982     0.200
     2.681    53.125     0.200
     3.098    59.562     0.200
     3.683    71.438     0.200
     3.703    71.497     0.200
     3.716    74.053     0.200
     3.708    74.942     0.200
     3.708    74.543     0.200
     3.811    72.441     0.200
     3.811    73.941     0.200
     4.002    77.816     0.200
     4.002    79.416     0.200
     4.183    82.406     0.200
     4.183    83.206     0.200
     4.943    98.136     0.200
     5.273   104.779     0.200
     5.584   110.851     0.200
     6.121   120.485     0.200
     6.572   128.625     0.200
     7.097   139.091     0.200
     7.238   141.647     0.200
     7.311   145.395     0.200
     7.431   146.398     0.200
     8.997   177.021     0.200
    10.152   196.348     0.200
    11.315   221.165     0.200
     2.826    56.723     0.200
     2.980    58.127     0.200
     3.497    66.896     0.200
     3.514    68.197     0.200
     3.753    73.807     0.200
     3.834    76.767     0.200
     4.170    82.542     0.200
     4.522    88.242     0.200
     4.522    89.140     0.200
     5.108   100.595     0.200
     5.430   107.040     0.200
     5.722   111.334     0.200
     6.564   130.096     0.200
     6.948   138.126     0.200
     7.361   143.602     0.200
     7.725   152.650     0.200
     7.762   153.525     0.200
     7.826   152.873     0.200
     7.942   156.826     0.200
     8.049   157.078     0.200
     8.258   162.640     0.200
     8.310   164.230     0.200
     8.432   166.109     0.200
     9.322   180.719     0.200
     9.395   182.768     0.200
     9.395   181.370     0.200
    10.032   195.329     0.200
    10.528   205.747     0.200
    11.009   214.530     0.200
    11.211   221.670     0.200
    11.414   223.209     0.200
    11.607   224.853     0.200
     2.751    53.656     0.200
     2.841    54.608     0.200
     2.841    55.006     0.200
     2.894    54.994     0.200
     2.894    55.095     0.200
     3.562    69.402     0.200
     3.598    68.779     0.200
     3.709    72.582     0.200
     3.774    74.125     0.200
     3.774    74.227     0.200
     4.094    79.290     0.200
     4.380    85.654     0.200
     5.037    98.691     0.200
     5.147   101.095     0.200
     5.652   109.412     0.200
     5.540   108.218     0.200
     6.386   126.746     0.200
     6.796   133.660     0.200
     7.534   148.146     0.200
     7.530   146.989     0.200
     7.582   150.492     0.200
     7.738   151.367     0.200
     7.883   154.973     0.200
     8.068   157.412     0.200
     8.122   160.987     0.200
     8.230   160.921     0.200
     9.149   180.095     0.200
     9.237   178.778     0.200
     9.867   192.017     0.200
    10.821   211.482     0.200
    10.821   208.186     0.200
    11.239   221.785     0.200
    11.271   218.731     0.200
    11.493   222.748     0.200
     3.508    68.066     0.200
     3.746    73.293     0.200
     4.174    80.790     0.200
     4.524    87.908     0.200
     5.113    99.941     0.200
     5.231    99.260     0.200
     5.427   106.876     0.200
     5.726   110.485     0.200
     2.847    55.273     0.200
     2.883    54.949     0.200
     2.883    55.148     0.200
     3.257    61.583     0.200
     3.329    66.148     0.200
     3.580    70.023     0.200
     3.580    70.523     0.200
     3.710    71.700     0.200
     4.290    85.934     0.200
     4.648    90.851     0.200
     5.107   100.193     0.200
     5.568   109.021     0.200
     6.362   126.251     0.200
     8.580   168.072     0.200
     8.657   169.568     0.200
     9.988   193.132     0.200
    10.636   205.670     0.200
    11.104   215.214     0.200
    11.942   235.235     0.200
     2.635    53.190     0.200
     2.635    52.890     0.200
     2.682    53.539     0.200
     2.952    56.988     0.200
     2.952    57.988     0.200
     3.274    64.731     0.200
     3.274    64.831     0.200
     3.894    75.889     0.200
     3.894    76.889     0.200
     4.497    88.051     0.200
     4.511    88.989     0.200
     4.704    91.437     0.200
     4.731    92.230     0.200
     4.731    91.230     0.200
     6.697   131.183     0.200
     6.808   132.482     0.200
     6.946   136.376     0.200
     8.085   158.078     0.200
     8.150   160.122     0.200
     8.791   172.546     0.200
     9.280   182.132     0.200
    10.363   200.502     0.200
     2.743    54.574     0.200
     2.743    54.273     0.200
     2.871    57.078     0.200
     2.871    56.578     0.200
     3.584    69.953     0.200
     3.578    70.226     0.200
     3.758    75.825     0.200
     4.087    79.382     0.200
     4.412    86.688     0.200
     4.412    85.688     0.200
     5.028   100.504     0.200
     5.028    98.704     0.200
     5.277   105.398     0.200
     6.442   127.503     0.200
     6.835   134.315     0.200
     7.672   150.147     0.200
     7.931   154.621     0.200
     8.132   160.584     0.200
     8.302   165.102     0.200
    10.417   203.611     0.200
    11.510   224.159     0.200
     2.805    53.328     0.200
     3.447    66.535     0.200
     3.912    76.414     0.200
     3.912    76.312     0.200
     4.251    82.855     0.200
     4.615    90.007     0.200
     5.534   108.381     0.200
     5.821   113.931     0.200
     7.042   137.582     0.200
     7.430   144.951     0.200
     7.861   155.223     0.200
     7.929   156.334     0.200
     8.044   157.995     0.200
     8.145   159.806     0.200
     8.409   165.125     0.200
    10.129   196.759     0.200
    10.622   208.006     0.200
    11.109   217.224     0.200
    11.506   222.384     0.200
    11.694   227.793     0.200
     2.776    53.161     0.200
     3.456    65.723     0.200
     3.456    67.523     0.200
     3.744    72.264     0.200
     3.872    77.074     0.200
     3.872    75.172     0.200
     4.211    82.919     0.200
     4.574    90.378     0.200
     5.502   108.559     0.200
     5.781   113.995     0.200
     7.001   137.352     0.200
     7.421   146.352     0.200
     7.821   155.590     0.200
     7.898   156.589     0.200
     8.004   157.751     0.200
     8.105   159.574     0.200
    10.088   195.930     0.200
    10.581   205.678     0.200
    11.069   216.385     0.200
    11.466   224.857     0.200
    11.654   224.464     0.200
     2.778    53.026     0.200
     2.866    56.189     0.200
     2.866    56.388     0.200
     3.458    66.887     0.200
     3.458    67.088     0.200
     3.743    72.956     0.200
     3.871    78.270     0.200
     3.871    77.370     0.200
     4.209    83.219     0.200
     4.572    89.189     0.200
     4.572    90.488     0.200
     5.146   100.987     0.200
     5.778   113.514     0.200
     6.999   139.267     0.200
     7.818   154.108     0.200
     7.893   155.027     0.200
     8.001   158.373     0.200
     8.102   160.289     0.200
    10.085   197.246     0.200
    10.578   207.790     0.200
    11.065   214.606     0.200
    11.651   224.469     0.200
     2.760    52.818     0.200
     2.760    53.013     0.200
     3.614    69.451     0.200
     3.621    70.263     0.200
     3.722    74.288     0.200
     3.722    73.093     0.200
     3.806    73.606     0.200
     4.051    78.251     0.200
     4.051    78.751     0.200
     4.328    84.516     0.200
     4.375    85.661     0.200
     4.991    98.377     0.200
     5.288   100.010     0.200
     5.249   102.370     0.200
     5.249   105.769     0.200
     5.562   109.017     0.200
     5.766   111.426     0.200
     6.405   126.467     0.200
     6.798   131.790     0.200
     7.646   149.493     0.200
     9.243   182.152     0.200
    10.380   200.989     0.200
     2.757    52.821     0.200
     3.612    69.838     0.200
     3.618    69.868     0.200
     3.618    70.368     0.200
     3.724    74.334     0.200
     3.724    73.334     0.200
     4.053    78.286     0.200
     4.323    85.043     0.200
     4.380    84.478     0.200
     4.380    85.079     0.200
     4.994    97.212     0.200
     5.567   108.618     0.200
     5.768   111.675     0.200
     6.411   126.374     0.200
     6.803   133.800     0.200
     7.608   149.700     0.200
     7.654   149.163     0.200
     7.900   153.399     0.200
     9.884   191.449     0.200
     2.708    52.185     0.200
     2.710    54.055     0.200
     3.938    76.929     0.200
     4.251    84.071     0.200
     5.369   101.730     0.200
     2.772    53.294     0.200
     2.926    58.497     0.200
     3.541    67.313     0.200
     3.549    68.425     0.200
     3.769    73.050     0.200
     4.269    80.822     0.200
     2.654    52.513     0.200
     2.755    54.524     0.200
     3.660    70.471     0.200
     3.997    77.532     0.200
     4.295    84.756     0.200
     5.121   100.414     0.200
     5.467   107.485     0.200
     2.541    48.744     0.200
     2.541    49.142     0.200
     3.343    65.885     0.200
     3.665    71.728     0.200
     3.991    76.920     0.200
     4.018    77.115     0.200
     3.971    77.560     0.200
     4.129    81.016     0.200
     4.195    81.344     0.200
     4.607    90.635     0.200
     4.772    91.513     0.200
     4.917    97.924     0.200
     5.602   107.422     0.200
     6.001   119.464     0.200
     7.199   143.989     0.200
     7.329   144.375     0.200
     8.761   173.762     0.200
     8.838   169.758     0.200
     9.473   187.048     0.200
    10.445   206.313     0.200
    10.864   211.117     0.200
     2.540    48.847     0.200
     2.540    49.347     0.200
     3.324    66.794     0.200
     3.645    71.650     0.200
     3.946    77.631     0.200
     3.946    78.431     0.200
     4.041    77.531     0.200
     4.199    83.478     0.200
     4.587    91.255     0.200
     4.800    91.872     0.200
     4.889    94.330     0.200
     4.889    97.631     0.200
     5.131   100.102     0.200
     5.131   102.203     0.200
     5.615   106.652     0.200
     6.368   125.169     0.200
     7.349   145.526     0.200
     7.464   146.986     0.200
     7.839   155.706     0.200
     8.734   170.854     0.200
     8.813   171.038     0.200
     9.950   193.364     0.200
    11.050   213.827     0.200
     2.502    49.680     0.200
     2.689    53.095     0.200
     3.843    75.231     0.200
     4.227    83.247     0.200
     2.753    52.573     0.200
     2.780    55.154     0.200
     2.931    57.202     0.200
     2.931    58.002     0.200
     3.542    70.661     0.200
     3.555    67.917     0.200
     3.784    75.746     0.200
     3.790    76.577     0.200
     4.124    81.569     0.200
     4.258    82.614     0.200
     4.287    81.374     0.200
     4.472    87.314     0.200
     5.063    99.417     0.200
     5.671   110.821     0.200
     5.760   113.688     0.200
     6.514   127.488     0.200
     7.779   152.515     0.200
     7.998   155.660     0.200
     8.380   165.301     0.200
     2.502    49.156     0.200
     2.502    49.957     0.200
     2.687    53.304     0.200
     2.687    53.406     0.200
     3.504    69.969     0.200
     3.825    72.426     0.200
     3.852    73.205     0.200
     3.844    74.500     0.200
     4.225    83.453     0.200
     4.780    93.680     0.200
     4.780    93.879     0.200
     5.291   105.914     0.200
     5.452   107.338     0.200
     6.290   123.248     0.200
     7.488   145.670     0.200
     7.706   152.733     0.200
     7.706   149.733     0.200
     7.764   153.655     0.200
     8.041   156.616     0.200
     8.175   161.753     0.200
     9.041   175.446     0.200
    11.292   219.185     0.200
     2.686    53.198     0.200
     3.499    69.517     0.200
     3.829    73.960     0.200
     3.829    74.159     0.200
     3.859    73.014     0.200
     3.840    75.341     0.200
     3.840    74.341     0.200
     4.010    78.449     0.200
     4.224    82.351     0.200
     4.775    93.924     0.200
     6.653   128.504     0.200
     7.715   150.720     0.200
     7.715   152.220     0.200
     7.764   151.442     0.200
    10.230   198.663     0.200
     2.684    53.284     0.200
     2.684    53.182     0.200
     3.499    70.277     0.200
     3.499    69.676     0.200
     3.830    72.711     0.200
     3.858    72.982     0.200
     3.839    73.504     0.200
     3.839    75.004     0.200
     4.016    78.338     0.200
     4.095    78.820     0.200
     4.222    81.431     0.200
     4.222    82.834     0.200
     4.471    85.931     0.200
     4.775    91.483     0.200
     4.775    93.483     0.200
     5.293   104.129     0.200
     5.450   107.006     0.200
     5.450   106.705     0.200
     6.288   122.016     0.200
     6.651   129.784     0.200
     7.486   145.836     0.200
     7.761   152.730     0.200
     8.040   157.783     0.200
     8.174   159.313     0.200
     9.101   177.092     0.200
     9.743   189.297     0.200
     9.743   190.696     0.200
    10.228   198.644     0.200
    11.109   215.757     0.200
     2.750    52.599     0.200
     2.794    55.191     0.200
     2.948    57.683     0.200
     4.137    80.709     0.200
     4.490    88.398     0.200
     5.075    98.861     0.200
     5.267   100.822     0.200
     5.691   111.275     0.200
     2.784    55.550     0.200
     2.932    57.918     0.200
     4.128    80.665     0.200
     4.473    88.230     0.200
     5.262   100.629     0.200
     2.561    51.445     0.200
     2.561    50.145     0.200
     3.256    66.434     0.200
     3.595    69.684     0.200
     3.595    68.782     0.200
     3.978    78.505     0.200
     4.072    79.509     0.200
     4.092    77.979     0.200
     4.092    81.979     0.200
     4.531    89.454     0.200
     4.531    89.052     0.200
     5.120   102.080     0.200
     5.213   102.999     0.200
     6.408   126.057     0.200
     7.456   147.126     0.200
     7.520   147.177     0.200
     7.544   149.600     0.200
     8.799   173.657     0.200
     9.984   195.025     0.200
    11.042   215.875     0.200
     2.654    52.242     0.200
     2.654    52.042     0.200
     2.718    52.595     0.200
     2.718    52.095     0.200
     2.783    54.434     0.200
     3.666    69.930     0.200
     3.673    69.344     0.200
     3.669    73.491     0.200
     3.855    74.326     0.200
     3.998    76.749     0.200
     3.998    76.449     0.200
     4.295    83.587     0.200
     4.324    85.646     0.200
     4.324    84.346     0.200
     5.216   103.539     0.200
     5.513   107.571     0.200
     6.748   130.064     0.200
     9.829   192.410     0.200
    10.330   199.965     0.200
    10.800   212.580     0.200
    11.217   220.104     0.200
    11.421   222.828     0.200
     2.859    55.490     0.200
     2.866    55.697     0.200
     3.112    62.233     0.200
     3.401    64.954     0.200
     3.465    68.819     0.200
     3.465    67.921     0.200
     3.576    69.917     0.200
     4.479    86.873     0.200
     4.479    86.271     0.200
     4.809    94.627     0.200
     4.809    92.822     0.200
     4.844    93.622     0.200
     5.115   101.158     0.200
     5.750   112.651     0.200
     5.754   113.393     0.200
     6.270   121.777     0.200
     7.531   148.757     0.200
     8.103   158.887     0.200
     8.311   163.155     0.200
     8.456   167.370     0.200
     8.617   169.590     0.200
     8.848   171.592     0.200
     8.950   174.600     0.200
    11.115   218.238     0.200
    11.547   225.595     0.200
    12.007   233.326     0.200
    12.224   240.286     0.200
     2.552    51.958     0.200
     2.552    50.661     0.200
     2.864    54.731     0.200
     2.959    58.616     0.200
     3.365    65.977     0.200
     3.493    68.879     0.200
     4.481    87.552     0.200
     4.481    87.857     0.200
     4.829    94.790     0.200
     5.227   101.942     0.200
     5.227   100.942     0.200
     5.760   111.333     0.200
     6.105   121.802     0.200
     6.442   128.161     0.200
     7.186   135.767     0.200
     7.186   135.377     0.200
     7.656   149.202     0.200
     7.714   152.220     0.200
     8.481   166.178     0.200
     8.763   170.381     0.200
     9.031   179.352     0.200
    10.746   211.336     0.200
    11.234   220.647     0.200
    11.730   230.553     0.200
    12.115   233.063     0.200
    12.201   242.080     0.200
    12.288   240.246     0.200
    17.288   338.596     0.200
     2.565    51.056     0.200
     2.565    50.260     0.200
     2.683    51.476     0.200
     2.683    52.882     0.200
     3.583    70.875     0.200
     3.751    72.315     0.200
     3.768    73.015     0.200
     3.909    75.266     0.200
     3.918    76.759     0.200
     4.224    83.193     0.200
     4.224    83.295     0.200
     4.850    94.983     0.200
     5.115   101.393     0.200
     5.408   106.470     0.200
     6.646   128.527     0.200
     8.113   158.907     0.200
     2.547    49.343     0.200
     3.389    68.124     0.200
     3.389    68.722     0.200
     3.713    71.935     0.200
     3.713    71.337     0.200
     3.945    76.334     0.200
     3.964    75.606     0.200
     4.029    79.354     0.200
     4.096    79.964     0.200
     4.187    80.611     0.200
     4.655    92.247     0.200
     4.981   100.243     0.200
     5.220   102.350     0.200
     6.452   125.671     0.200
     7.392   145.001     0.200
     7.440   146.945     0.200
     7.550   146.463     0.200
     7.930   155.332     0.200
     9.534   184.012     0.200
    10.034   197.872     0.200
    10.507   204.554     0.200
    10.922   212.509     0.200
    11.128   215.407     0.200
     3.826    74.124     0.200
     3.842    72.831     0.200
     4.104    78.476     0.200
     4.208    82.364     0.200
     4.484    86.244     0.200
     4.762    91.602     0.200
     2.746    52.569     0.200
     3.775    73.067     0.200
     3.884    76.089     0.200
     3.914    76.840     0.200
     4.206    83.326     0.200
     4.569    87.896     0.200
     4.856    94.144     0.200
     2.522    47.982     0.200
     2.633    51.987     0.200
     2.506    49.863     0.200
     2.827    55.320     0.200
     2.827    54.021     0.200
     3.629    71.958     0.200
     3.700    71.633     0.200
     3.740    71.164     0.200
     3.972    78.154     0.200
     4.003    77.392     0.200
     4.364    85.978     0.200
     4.906    95.253     0.200
     5.594   110.229     0.200
     6.794   132.529     0.200
     7.831   153.020     0.200
     7.833   154.500     0.200
     8.318   162.939     0.200
    11.250   218.418     0.200
     3.250    65.158     0.200
     3.572    70.196     0.200
     4.108    79.147     0.200
     3.885    77.854     0.200
     4.132    80.164     0.200
     4.221    82.022     0.200
     8.679   170.503     0.200
     8.754   171.426     0.200
     8.929   175.583     0.200
     9.390   181.903     0.200
     9.890   192.972     0.200
    10.366   202.817     0.200
    10.778   210.612     0.200
    10.984   211.104     0.200
     2.609    52.857     0.200
     2.609    52.157     0.200
     2.655    52.922     0.200
     2.655    52.218     0.200
     2.899    56.265     0.200
     2.899    56.066     0.200
     3.636    71.571     0.200
     3.636    73.872     0.200
     3.720    73.187     0.200
     3.787    74.610     0.200
     3.804    74.704     0.200
     3.945    77.568     0.200
     4.187    82.340     0.200
     4.187    81.840     0.200
     4.543    89.782     0.200
     4.895    97.273     0.200
     4.888    94.662     0.200
     5.323   104.583     0.200
     6.170   121.903     0.200
     6.594   129.543     0.200
     6.778   132.705     0.200
     6.874   133.577     0.200
     7.283   142.411     0.200
     7.306   142.344     0.200
     7.364   145.663     0.200
     7.509   146.176     0.200
     7.673   150.055     0.200
     7.900   155.606     0.200
     7.979   155.688     0.200
     8.003   157.110     0.200
     8.540   167.937     0.200
     8.935   176.027     0.200
     9.030   177.616     0.200
     9.189   179.565     0.200
     9.656   185.829     0.200
     9.656   187.712     0.200
    10.992   216.925     0.200
    10.992   216.921     0.200
    19.737   394.993     0.200
    19.737   394.997     0.200
     2.615    51.861     0.200
     2.615    50.658     0.200
     2.739    54.416     0.200
     2.739    53.916     0.200
     2.704    52.119     0.200
     2.704    51.822     0.200
     3.632    72.791     0.200
     3.632    72.892     0.200
     3.703    71.166     0.200
     3.715    70.627     0.200
     3.881    76.080     0.200
     3.959    77.170     0.200
     3.959    75.771     0.200
     4.280    85.225     0.200
     4.900    96.189     0.200
     4.900    94.986     0.200
     5.170   101.938     0.200
     5.467   107.978     0.200
     6.310   123.335     0.200
     6.703   131.255     0.200
     6.928   136.631     0.200
     7.508   147.260     0.200
     7.571   149.523     0.200
     7.681   151.837     0.200
     7.799   151.859     0.200
     8.053   158.295     0.200
     8.124   158.965     0.200
     8.172   160.307     0.200
     9.070   175.526     0.200
     9.321   179.998     0.200
     9.783   188.708     0.200
    10.285   199.453     0.200
    10.753   211.187     0.200
    10.946   212.534     0.200
    11.173   218.189     0.200
    11.379   222.883     0.200
     2.541    49.247     0.200
     3.666    71.810     0.200
     4.129    81.409     0.200
     2.507    50.123     0.200
     3.708    72.111     0.200
     4.049    79.238     0.200
     4.648    91.640     0.200
     2.592    51.768     0.200
     2.592    51.268     0.200
     3.002    59.580     0.200
     3.217    62.981     0.200
     3.780    73.106     0.200
     3.986    77.998     0.200
     4.752    93.364     0.200
     5.265   100.875     0.200
     5.987   116.947     0.200
     8.181   160.443     0.200
     8.712   170.051     0.200
    11.798   226.334     0.200
     2.567    50.541     0.200
     3.501    66.835     0.200
     3.541    68.872     0.200
     4.673    90.056     0.200
     5.079    99.222     0.200
     5.603   109.109     0.200
     8.393   165.248     0.200
     8.618   167.724     0.200
     9.019   175.446     0.200
    11.084   213.340     0.200
     2.841    54.804     0.200
     3.393    66.653     0.200
     3.688    71.912     0.200
     3.886    77.005     0.200
     4.094    79.676     0.200
     4.543    88.932     0.200
     4.629    91.027     0.200
     5.002    98.783     0.200
     5.481   108.487     0.200
     6.285   123.311     0.200
     6.454   126.630     0.200
     6.975   135.757     0.200
     6.980   135.000     0.200
     7.180   140.259     0.200
     7.357   143.301     0.200
     7.675   150.289     0.200
     2.540    51.036     0.200
     3.059    61.377     0.200
     3.390    67.121     0.200
     3.745    74.784     0.200
     3.916    76.290     0.200
     4.279    83.952     0.200
     4.276    82.382     0.200
     4.330    84.653     0.200
     4.888    97.436     0.200
     4.970    98.488     0.200
     5.808   114.603     0.200
     6.173   121.539     0.200
     6.433   126.809     0.200
     7.210   139.642     0.200
     7.282   141.704     0.200
     7.315   145.114     0.200
     7.322   143.433     0.200
     7.509   146.854     0.200
     7.560   148.663     0.200
     7.623   146.317     0.200
     7.696   148.472     0.200
     8.168   159.761     0.200
     8.559   166.603     0.200
     8.807   170.209     0.200
     9.264   179.874     0.200
     9.751   188.188     0.200
    10.257   198.678     0.200
    10.573   207.595     0.200
    10.634   206.679     0.200
    10.823   208.982     0.200
    12.907   248.957     0.200
     2.570    51.352     0.200
     2.570    50.555     0.200
     2.622    51.748     0.200
     2.830    55.624     0.200
     2.830    55.319     0.200
     3.719    72.544     0.200
     3.769    72.563     0.200
     3.613    72.087     0.200
     3.978    78.824     0.200
     3.959    78.144     0.200
     3.959    76.449     0.200
     4.365    86.207     0.200
     4.365    85.809     0.200
     4.891    95.469     0.200
     6.795   133.252     0.200
     7.067   138.783     0.200
     7.901   148.096     0.200
     7.874   156.364     0.200
     7.909   155.752     0.200
     8.143   159.317     0.200
     8.193   160.136     0.200
     8.331   164.327     0.200
     8.798   172.582     0.200
     9.188   179.120     0.200
     9.435   183.340     0.200
     9.890   191.748     0.200
    10.369   201.438     0.200
    10.890   213.159     0.200
    11.248   219.579     0.200
    11.416   221.420     0.200
    11.460   225.695     0.200
    14.856   287.474     0.200
     2.576    51.221     0.200
     2.610    51.430     0.200
     2.610    52.828     0.200
     3.600    71.366     0.200
     3.732    72.834     0.200
     3.782    71.750     0.200
     3.981    78.329     0.200
     3.946    78.227     0.200
     4.354    85.872     0.200
     4.878    95.951     0.200
     5.593   109.212     0.200
     6.430   125.850     0.200
     6.783   132.519     0.200
     7.056   138.939     0.200
     7.835   153.849     0.200
     7.868   155.858     0.200
     7.898   155.914     0.200
     8.182   159.690     0.200
     8.245   160.261     0.200
     8.320   163.876     0.200
     8.787   172.242     0.200
     9.177   177.687     0.200
    10.357   200.410     0.200
    11.236   218.255     0.200
    11.404   221.890     0.200
    13.645   264.545     0.200
    14.843   287.159     0.200
     2.738    54.084     0.200
     2.805    54.894     0.200
     2.940    56.018     0.200
     3.580    69.450     0.200
     3.633    69.538     0.200
     3.763    74.122     0.200
     4.078    79.847     0.200
     4.341    84.977     0.200
     4.489    85.545     0.200
     4.549    87.844     0.200
     5.021    98.343     0.200
     5.486   107.007     0.200
     6.333   123.627     0.200
     6.752   130.635     0.200
     7.442   144.586     0.200
     7.528   146.982     0.200
     7.834   152.507     0.200
     8.169   159.393     0.200
     2.614    51.983     0.200
     2.955    57.006     0.200
     3.060    58.887     0.200
     3.416    66.822     0.200
     3.624    70.496     0.200
     4.407    83.958     0.200
     4.399    85.161     0.200
     4.749    92.368     0.200
     5.162   101.055     0.200
     5.678   109.536     0.200
     6.387   124.655     0.200
     7.591   148.205     0.200
     8.476   165.773     0.200
     8.702   168.541     0.200
     9.105   176.435     0.200
     3.414    68.090     0.200
     3.732    73.375     0.200
     3.924    76.240     0.200
     4.021    80.003     0.200
     4.282    83.852     0.200
     4.675    91.570     0.200
     4.907    96.865     0.200
     5.195   101.801     0.200
     5.520   108.206     0.200
     6.040   118.141     0.200
     6.440   125.966     0.200
     6.655   130.863     0.200
     7.068   138.551     0.200
     7.237   141.977     0.200
     7.313   143.879     0.200
     7.406   145.107     0.200
     7.532   146.224     0.200
     7.728   149.941     0.200
     7.780   152.031     0.200
     7.853   153.685     0.200
     7.897   154.174     0.200
     8.408   163.609     0.200
     8.801   172.220     0.200
     9.053   176.183     0.200
     9.516   185.174     0.200
    10.951   214.652     0.200
     2.616    52.192     0.200
     2.728    52.186     0.200
     2.731    54.248     0.200
     3.634    71.305     0.200
     3.699    71.645     0.200
     3.960    77.403     0.200
     4.272    84.465     0.200
     4.323    84.667     0.200
     4.901    94.917     0.200
     5.141   101.223     0.200
     5.453   106.981     0.200
     6.297   123.230     0.200
     7.540   147.624     0.200
     7.664   149.374     0.200
     2.788    53.461     0.200
     2.920    57.315     0.200
     3.095    60.170     0.200
     3.920    77.541     0.200
     4.266    81.409     0.200
     4.635    90.695     0.200
     5.197   101.347     0.200
     5.214   100.447     0.200
     5.847   114.458     0.200
     6.689   130.539     0.200
     7.063   138.862     0.200
     8.073   157.282     0.200
     8.562   168.075     0.200
     2.920    57.999     0.200
     3.091    60.708     0.200
     3.922    75.812     0.200
     4.284    82.780     0.200
     4.262    83.843     0.200
     4.631    90.932     0.200
     5.198   101.920     0.200
     5.560   109.895     0.200
     5.840   114.925     0.200
     6.682   131.798     0.200
     7.059   137.901     0.200
     7.303   142.555     0.200
     8.064   159.269     0.200
     8.163   160.215     0.200
     8.554   167.559     0.200
     2.726    51.838     0.200
     2.787    55.725     0.200
     2.949    57.538     0.200
     3.536    69.487     0.200
     3.558    67.932     0.200
     3.793    74.788     0.200
     4.131    81.351     0.200
     4.248    81.984     0.200
     4.490    87.356     0.200
     5.068    99.811     0.200
     5.427   107.117     0.200
     5.696   111.979     0.200
     6.538   128.155     0.200
     6.917   134.733     0.200
     7.827   153.614     0.200
     7.920   155.429     0.200
     8.020   156.557     0.200
     8.233   160.176     0.200
     8.409   164.019     0.200
     9.544   186.475     0.200
    10.003   193.612     0.200
    10.497   202.957     0.200
    10.984   214.271     0.200
    11.571   225.022     0.200
     3.149    61.711     0.200
     3.473    68.129     0.200
     3.796    75.158     0.200
     4.052    78.366     0.200
     4.185    81.620     0.200
     4.204    81.903     0.200
     4.415    86.841     0.200
     4.843    95.235     0.200
     5.000    97.906     0.200
     5.841   114.589     0.200
     6.222   121.653     0.200
     7.229   141.494     0.200
     7.265   142.375     0.200
     7.323   142.497     0.200
     7.538   147.495     0.200
     7.717   150.498     0.200
     8.847   172.118     0.200
     9.307   181.752     0.200
    10.288   200.695     0.200
    10.828   215.041     0.200
     3.619    70.778     0.200
     3.964    77.257     0.200
     4.047    77.790     0.200
     4.050    77.751     0.200
     4.047    78.388     0.200
     4.559    89.308     0.200
     2.712    52.091     0.200
     2.937    58.158     0.200
     3.550    68.609     0.200
     3.572    67.845     0.200
     4.117    80.190     0.200
     4.478    87.077     0.200
     2.739    52.409     0.200
     2.955    58.585     0.200
     3.527    67.115     0.200
     3.547    67.176     0.200
     4.139    82.170     0.200
     4.496    88.600     0.200
     2.534    49.524     0.200
     2.669    51.921     0.200
     2.767    54.601     0.200
     3.192    64.260     0.200
     4.679    89.882     0.200
     3.464    68.585     0.200
     4.050    79.045     0.200
     4.194    81.862     0.200
     2.598    51.973     0.200
     2.701    53.580     0.200
     2.749    52.718     0.200
     3.715    72.246     0.200
     3.742    74.025     0.200
     3.942    77.196     0.200
     4.357    85.356     0.200
     4.884    94.800     0.200
     2.599    51.424     0.200
     2.739    52.890     0.200
     2.705    53.486     0.200
     3.714    72.116     0.200
     3.739    72.622     0.200
     3.943    77.144     0.200
     4.246    84.208     0.200
     4.344    83.558     0.200
     4.885    95.351     0.200
     5.099   101.660     0.200
     5.422   106.086     0.200
     6.266   122.430     0.200
     6.666   130.765     0.200
     6.882   133.748     0.200
     7.497   147.268     0.200
     7.631   149.709     0.200
     7.759   151.815     0.200
     8.634   168.995     0.200
     2.566    51.439     0.200
     3.584    70.457     0.200
     3.899    75.285     0.200
     3.968    78.876     0.200
     4.083    78.526     0.200
     4.103    79.400     0.200
     4.520    88.723     0.200
     5.203   102.462     0.200
     3.135    61.830     0.200
     3.461    67.918     0.200
     3.796    74.116     0.200
     4.011    77.602     0.200
     4.199    80.114     0.200
     4.211    80.167     0.200
     4.403    84.638     0.200
     4.872    95.564     0.200
     5.007    96.586     0.200
     5.847   113.677     0.200
     6.470   125.912     0.200
     7.239   141.531     0.200
     7.295   143.087     0.200
    10.688   208.086     0.200
     2.674    53.330     0.200
     2.674    53.432     0.200
     2.733    51.745     0.200
     3.055    60.591     0.200
     3.284    63.522     0.200
     3.284    64.221     0.200
     3.326    63.423     0.200
     4.031    79.099     0.200
     4.115    79.217     0.200
     4.384    84.879     0.200
     4.816    94.938     0.200
     5.310   103.072     0.200
     5.874   115.294     0.200
     6.060   119.821     0.200
     6.060   118.022     0.200
     6.897   134.358     0.200
     7.246   142.085     0.200
     7.523   146.143     0.200
     7.784   153.005     0.200
     8.277   160.947     0.200
     8.302   161.758     0.200
     8.362   161.951     0.200
     8.600   166.883     0.200
     8.650   167.997     0.200
     8.712   169.676     0.200
     8.788   171.088     0.200
     9.253   180.763     0.200
     9.643   187.510     0.200
     9.889   190.936     0.200
    10.343   199.939     0.200
    10.818   209.002     0.200
    11.347   220.723     0.200
    11.630   226.219     0.200
    11.905   236.876     0.200
    17.645   342.001     0.200
     2.667    54.104     0.200
     2.908    57.999     0.200
     2.974    58.323     0.200
     3.296    65.670     0.200
     3.869    75.675     0.200
     3.917    77.324     0.200
     4.518    88.904     0.200
     4.524    88.841     0.200
     4.708    92.188     0.200
     5.356   105.025     0.200
     5.723   112.141     0.200
     5.982   116.727     0.200
     6.958   136.333     0.200
     7.058   138.367     0.200
     7.246   141.965     0.200
     7.716   150.989     0.200
     8.107   157.924     0.200
     8.355   161.728     0.200
     9.302   180.870     0.200
     2.705    53.201     0.200
     2.705    52.301     0.200
     2.785    54.062     0.200
     2.785    53.462     0.200
     2.959    58.131     0.200
     2.959    57.931     0.200
     3.673    72.604     0.200
     3.673    72.904     0.200
     3.690    69.301     0.200
     4.028    78.955     0.200
     4.484    87.740     0.200
     4.484    87.040     0.200
     4.952    95.481     0.200
     5.679   111.992     0.200
     5.747   112.393     0.200
     6.580   128.480     0.200
     6.912   135.201     0.200
     7.210   141.623     0.200
     7.777   151.414     0.200
     8.035   156.398     0.200
     8.098   158.363     0.200
     8.287   161.955     0.200
     8.336   162.781     0.200
     8.484   165.556     0.200
     9.318   181.826     0.200
     9.562   185.472     0.200
    10.013   194.511     0.200
    10.479   202.078     0.200
    11.031   214.839     0.200
    11.269   219.988     0.200
    11.352   220.490     0.200
    11.651   231.220     0.200
    17.950   349.543     0.200
    18.248   357.315     0.200
     3.544    70.034     0.200
     3.726    72.406     0.200
     4.536    88.855     0.200
     4.882    94.519     0.200
     5.267   102.733     0.200
     2.515    49.934     0.200
     2.623    52.183     0.200
     2.677    51.552     0.200
     3.798    74.967     0.200
     3.823    75.275     0.200
     3.859    75.352     0.200
     4.163    83.001     0.200
     4.296    84.552     0.200
     5.044    99.520     0.200
     5.343   104.736     0.200
     6.187   120.586     0.200
     7.384   144.016     0.200
     7.447   145.677     0.200
     7.678   149.785     0.200
     8.555   166.256     0.200
    10.167   197.142     0.200
    11.056   214.162     0.200
    11.268   219.090     0.200
     2.509    49.300     0.200
     2.612    51.992     0.200
     3.530    69.381     0.200
     3.832    76.152     0.200
     3.852    74.821     0.200
     4.152    81.616     0.200
     4.305    82.929     0.200
     5.027   100.713     0.200
     5.330   105.178     0.200
     6.174   121.722     0.200
     6.573   128.671     0.200
     6.790   133.234     0.200
     7.429   145.272     0.200
     7.666   150.115     0.200
     8.935   175.101     0.200
     2.880    55.277     0.200
     3.510    69.028     0.200
     3.674    72.812     0.200
     4.509    87.969     0.200
     4.851    94.177     0.200
     5.215   102.926     0.200
     2.547    49.708     0.200
     2.770    53.802     0.200
     3.823    75.110     0.200
     3.837    75.452     0.200
     3.891    76.519     0.200
     4.083    80.082     0.200
     4.423    86.108     0.200
     4.871    96.588     0.200
     5.235   103.139     0.200
     2.546    50.469     0.200
     2.783    53.998     0.200
     2.783    54.498     0.200
     3.515    70.559     0.200
     3.515    69.962     0.200
     3.836    74.512     0.200
     3.893    75.246     0.200
     3.893    74.946     0.200
     3.826    75.333     0.200
     3.826    74.231     0.200
     4.081    81.453     0.200
     4.081    79.152     0.200
     4.438    86.780     0.200
     4.858    96.484     0.200
     8.447   158.662     0.200
     8.446   166.313     0.200
     8.840   171.709     0.200
     8.931   174.451     0.200
     9.093   178.256     0.200
     9.559   186.716     0.200
    10.076   195.393     0.200
    10.510   205.227     0.200
    10.808   212.571     0.200
    10.933   217.411     0.200
    10.970   213.059     0.200
    11.201   216.059     0.200
    14.874   295.346     0.200
    17.677   345.448     0.200
    18.543   362.599     0.200
    19.041   378.210     0.200
    19.820   394.993     0.200
     2.545    50.048     0.200
     2.545    50.349     0.200
     2.788    54.110     0.200
     3.516    69.317     0.200
     3.516    70.419     0.200
     3.836    74.384     0.200
     3.826    75.494     0.200
     3.826    74.295     0.200
     3.894    75.106     0.200
     3.894    75.004     0.200
     4.080    80.138     0.200
     4.080    79.837     0.200
     4.444    87.386     0.200
     4.853    96.013     0.200
     4.853    95.814     0.200
     5.227   102.043     0.200
     6.491   126.695     0.200
     6.684   131.138     0.200
     7.249   141.448     0.200
     7.269   142.217     0.200
     7.422   144.531     0.200
     7.574   146.659     0.200
     7.754   151.252     0.200
     7.808   152.630     0.200
     8.133   159.229     0.200
     8.444   164.607     0.200
     8.452   158.131     0.200
     8.838   172.503     0.200
     9.091   178.248     0.200
     9.557   185.910     0.200
    10.074   195.278     0.200
    10.507   204.326     0.200
    10.968   212.247     0.200
    11.200   217.938     0.200
     2.544    49.788     0.200
     2.769    53.661     0.200
     3.821    74.891     0.200
     3.839    75.369     0.200
     4.080    80.265     0.200
     4.423    86.062     0.200
     5.232   102.522     0.200
     2.541    50.303     0.200
     2.772    53.900     0.200
     3.507    68.625     0.200
     3.819    74.689     0.200
     3.842    75.319     0.200
     4.076    79.786     0.200
     5.227   102.256     0.200
     2.500    50.407     0.200
     2.563    50.476     0.200
     2.779    53.954     0.200
     3.526    69.835     0.200
     3.821    74.988     0.200
     3.838    74.987     0.200
     4.099    79.951     0.200
     4.429    86.298     0.200
     4.883    95.695     0.200
     5.250   102.912     0.200
     2.552    50.743     0.200
     2.779    54.097     0.200
     3.830    74.833     0.200
     3.831    75.119     0.200
     3.886    76.170     0.200
     4.087    79.925     0.200
     4.432    86.107     0.200
     4.870    95.693     0.200
     5.238   102.497     0.200
     6.695   130.190     0.200
     2.503    49.725     0.200
     2.564    50.408     0.200
     2.784    54.039     0.200
     3.819    74.960     0.200
     3.841    74.811     0.200
     3.874    76.115     0.200
     4.099    80.191     0.200
     4.435    86.072     0.200
     4.880    96.379     0.200
     5.250   102.262     0.200
     6.707   130.958     0.200
     2.560    50.806     0.200
     2.785    54.282     0.200
     3.823    75.073     0.200
     3.838    75.394     0.200
     4.095    80.387     0.200
     4.437    86.306     0.200
     5.246   102.664     0.200
     6.508   126.935     0.200
     6.703   130.459     0.200
     7.271   142.525     0.200
     2.553    50.826     0.200
     2.786    54.514     0.200
     3.521    69.429     0.200
     3.833    74.296     0.200
     3.885    74.886     0.200
     4.089    80.309     0.200
     4.439    86.819     0.200
     4.866    95.242     0.200
     5.238   102.999     0.200
     6.501   126.662     0.200
     6.695   130.893     0.200
     7.262   141.473     0.200
     7.280   141.969     0.200
     7.584   147.620     0.200
     8.454   165.166     0.200
     8.849   172.660     0.200
     9.102   176.508     0.200
    10.084   195.646     0.200
    10.518   203.579     0.200
     2.542    49.796     0.200
     2.772    54.111     0.200
     3.508    68.623     0.200
     3.820    75.283     0.200
     3.841    75.742     0.200
     3.896    76.391     0.200
     4.078    80.579     0.200
     4.427    86.404     0.200
     4.863    95.913     0.200
     6.490   127.019     0.200
     6.686   131.335     0.200
     7.261   142.230     0.200
     7.425   145.016     0.200
     7.574   148.369     0.200
     8.839   172.515     0.200
    10.073   195.609     0.200
    10.509   205.422     0.200
    10.967   212.579     0.200
    11.197   217.690     0.200
     2.546    50.114     0.200
     2.546    50.913     0.200
     2.781    53.479     0.200
     2.781    53.979     0.200
     3.514    70.117     0.200
     3.835    74.270     0.200
     3.892    76.709     0.200
     3.892    74.909     0.200
     3.825    74.786     0.200
     4.082    80.497     0.200
     4.082    80.898     0.200
     4.435    86.569     0.200
     4.861    95.102     0.200
     5.231   102.483     0.200
     7.577   148.905     0.200
     8.445   158.500     0.200
     8.447   164.851     0.200
     9.095   177.595     0.200
     9.561   186.256     0.200
    10.077   196.933     0.200
    10.511   204.462     0.200
    10.971   212.703     0.200
    10.935   218.795     0.200
    14.877   295.592     0.200
     2.554    50.564     0.200
     2.785    53.969     0.200
     3.828    75.198     0.200
     3.884    76.238     0.200
     4.089    80.347     0.200
     2.552    50.770     0.200
     2.788    54.216     0.200
     3.521    70.160     0.200
     3.829    74.666     0.200
     3.832    75.031     0.200
     3.886    75.596     0.200
     4.087    80.656     0.200
     4.442    86.212     0.200
     4.862    96.013     0.200
     5.236   102.351     0.200
     6.693   130.448     0.200
     7.431   145.037     0.200
     7.582   148.071     0.200
     8.452   164.718     0.200
     9.099   177.161     0.200
     2.550    50.288     0.200
     2.794    54.638     0.200
     3.521    69.650     0.200
     3.521    70.449     0.200
     3.830    74.241     0.200
     3.889    75.054     0.200
     3.832    75.427     0.200
     4.084    80.479     0.200
     4.084    79.879     0.200
     4.449    87.215     0.200
     4.854    96.201     0.200
     5.231   101.694     0.200
     5.231   101.593     0.200
     7.425   144.390     0.200
     8.451   158.742     0.200
     8.448   165.859     0.200
     8.842   171.953     0.200
     9.095   176.700     0.200
     9.561   184.558     0.200
    10.079   195.626     0.200
    10.973   211.391     0.200
    11.205   218.378     0.200
     2.558    49.837     0.200
     2.781    54.138     0.200
     3.523    69.173     0.200
     3.825    74.154     0.200
     3.835    75.034     0.200
     3.880    75.411     0.200
     4.094    80.217     0.200
     4.433    86.462     0.200
     4.876    96.692     0.200
     5.245   102.687     0.200
     6.506   126.963     0.200
     6.702   131.180     0.200
     7.273   141.520     0.200
     7.441   144.659     0.200
     7.590   148.114     0.200
     8.461   164.857     0.200
     9.108   177.102     0.200
     2.540    50.308     0.200
     2.755    53.999     0.200
     3.813    74.546     0.200
     4.076    79.684     0.200
     4.408    85.609     0.200
     4.875    95.861     0.200
     5.230   102.212     0.200
     6.688   130.301     0.200
     7.274   141.469     0.200
     2.548    50.684     0.200
     2.786    53.910     0.200
     3.828    75.144     0.200
     4.083    80.770     0.200
     4.441    85.597     0.200
     2.551    50.998     0.200
     2.787    54.451     0.200
     3.520    68.589     0.200
     3.831    75.163     0.200
     3.887    76.412     0.200
     4.087    80.287     0.200
     4.441    86.342     0.200
     4.774    92.760     0.200
     4.862    96.840     0.200
     5.235   103.076     0.200
     6.498   127.040     0.200
     6.692   130.174     0.200
     7.258   142.169     0.200
     7.430   145.266     0.200
     7.581   146.797     0.200
     7.816   152.665     0.200
    10.515   204.061     0.200
    10.975   213.495     0.200
    11.207   218.092     0.200
     2.502    49.554     0.200
     2.638    51.069     0.200
     2.638    51.370     0.200
     3.432    67.905     0.200
     3.432    69.104     0.200
     3.751    73.580     0.200
     4.042    79.986     0.200
     4.042    78.884     0.200
     3.939    76.388     0.200
     4.285    82.548     0.200
     4.693    92.396     0.200
     4.926    98.268     0.200
     5.217   102.776     0.200
     6.062   119.019     0.200
     6.446   126.735     0.200
     6.462   125.552     0.200
     6.542   127.211     0.200
     6.677   131.135     0.200
     7.333   143.988     0.200
     7.428   144.281     0.200
     7.554   146.905     0.200
     7.750   150.919     0.200
     7.802   152.307     0.200
     7.919   154.750     0.200
     8.429   164.988     0.200
     8.397   159.656     0.200
     8.823   171.497     0.200
     9.074   175.859     0.200
     9.538   185.753     0.200
    10.045   194.037     0.200
    10.972   217.318     0.200
    18.947   376.031     0.200
     2.556    49.952     0.200
     2.556    49.088     0.200
     2.556    49.748     0.200
     2.537    50.470     0.200
     2.507    51.131     0.200
     3.080    61.620     0.200
     3.494    68.005     0.200
     3.961    77.556     0.200
     4.789    92.332     0.200
     4.780    93.896     0.200
     5.126   100.563     0.200
     5.503   108.270     0.200
     5.840   110.631     0.200
     6.058   118.887     0.200
     6.867   130.012     0.200
     6.699   130.711     0.200
     7.024   131.975     0.200
     7.542   148.365     0.200
     7.674   150.332     0.200
     7.929   155.051     0.200
     7.927   155.569     0.200
     8.017   156.622     0.200
     8.159   159.364     0.200
     8.620   167.889     0.200
     8.908   173.931     0.200
     9.030   176.609     0.200
     9.232   180.947     0.200
     9.356   182.100     0.200
     9.399   183.793     0.200
     9.909   193.548     0.200
    10.302   199.962     0.200
    10.552   205.239     0.200
    11.013   213.761     0.200
     2.500    50.381     0.200
     2.681    52.965     0.200
     3.494    68.679     0.200
     3.834    74.511     0.200
     3.835    75.402     0.200
     4.009    77.563     0.200
     4.219    83.417     0.200
     4.770    92.994     0.200
     5.294   105.067     0.200
     5.448   107.080     0.200
     6.648   128.769     0.200
     6.674   130.865     0.200
     6.746   131.928     0.200
     6.911   134.702     0.200
     7.686   149.864     0.200
     7.710   149.877     0.200
     7.987   155.947     0.200
     8.101   157.912     0.200
     8.172   158.985     0.200
     9.037   176.198     0.200
     9.284   180.207     0.200
    10.225   198.631     0.200
     3.095    61.514     0.200
     3.417    67.162     0.200
     3.732    73.483     0.200
     4.054    78.633     0.200
     4.263    82.386     0.200
     4.358    85.481     0.200
     4.782    94.736     0.200
     4.934    96.762     0.200
     5.775   112.342     0.200
     6.157   120.685     0.200
     6.162   121.229     0.200
     6.245   122.455     0.200
     6.396   125.295     0.200
     7.162   140.156     0.200
     7.205   140.361     0.200
     7.258   140.540     0.200
     7.471   146.151     0.200
     7.650   149.260     0.200
     8.781   171.362     0.200
     9.241   180.893     0.200
     2.528    48.065     0.200
     2.571    50.959     0.200
     2.705    53.591     0.200
     2.915    57.244     0.200
     3.639    69.597     0.200
     3.695    72.948     0.200
     4.022    78.833     0.200
     4.042    78.799     0.200
     4.451    87.828     0.200
     5.688   111.385     0.200
     6.525   127.813     0.200
     6.880   133.674     0.200
     6.914   134.880     0.200
     6.982   135.393     0.200
     7.152   139.507     0.200
     7.929   155.034     0.200
     7.942   155.385     0.200
     7.994   156.373     0.200
     8.415   164.362     0.200
    10.454   203.263     0.200
    11.333   218.808     0.200
    11.500   222.857     0.200
     2.953    56.764     0.200
     2.981    58.239     0.200
     3.474    67.888     0.200
     3.740    73.880     0.200
     4.165    79.323     0.200
     4.785    93.984     0.200
     5.264   103.602     0.200
     5.699   112.018     0.200
     6.527   127.557     0.200
     7.691   150.373     0.200
     7.750   151.686     0.200
     8.760   172.398     0.200
     8.777   171.598     0.200
     8.815   172.953     0.200
     2.604    49.266     0.200
     2.679    52.202     0.200
     3.057    60.687     0.200
     3.057    60.898     0.200
     3.380    65.721     0.200
     3.406    67.018     0.200
     3.925    76.655     0.200
     4.178    81.407     0.200
     4.505    87.393     0.200
     6.696   131.215     0.200
     6.957   135.670     0.200
     7.793   152.815     0.200
     8.135   158.120     0.200
     8.420   165.394     0.200
     9.075   178.554     0.200
     9.198   178.715     0.200
     9.685   189.340     0.200
     3.466    68.342     0.200
     3.788    74.982     0.200
     4.211    80.453     0.200
     4.407    86.264     0.200
     4.836    95.061     0.200
     4.992    97.836     0.200
     5.833   114.418     0.200
     6.214   122.179     0.200
     6.220   122.104     0.200
     6.455   126.667     0.200
     7.221   141.723     0.200
     7.257   142.999     0.200
     7.315   143.424     0.200
     7.709   150.329     0.200
     8.197   160.333     0.200
     9.795   190.690     0.200
    10.681   206.945     0.200
    10.883   211.692     0.200
     2.793    53.741     0.200
     2.846    56.825     0.200
     3.000    59.636     0.200
     3.000    58.636     0.200
     3.477    68.066     0.200
     3.477    66.363     0.200
     3.853    76.070     0.200
     4.190    81.847     0.200
     4.190    81.644     0.200
     4.310    83.845     0.200
     4.310    83.243     0.200
     4.541    88.344     0.200
     5.127   100.708     0.200
     5.442   107.229     0.200
     5.740   112.252     0.200
     6.583   127.716     0.200
     6.967   135.534     0.200
     7.838   154.371     0.200
     7.960   154.752     0.200
     8.450   165.135     0.200
     2.768    53.088     0.200
     4.382    84.132     0.200
     5.833   110.306     0.200
     6.113   115.779     0.200
     6.623   124.591     0.200
     6.770   127.707     0.200
     2.840    55.375     0.200
     2.840    55.273     0.200
     3.868    75.167     0.200
     3.868    75.269     0.200
     3.569    70.060     0.200
     3.661    70.491     0.200
     3.617    69.803     0.200
     3.617    70.702     0.200
     4.595    89.498     0.200
     4.908    94.931     0.200
     5.159    99.815     0.200
     5.270   104.314     0.200
     6.336   120.764     0.200
     7.753   144.151     0.200
     8.394   164.759     0.200
     8.606   168.084     0.200
     8.752   169.876     0.200
     8.808   172.424     0.200
     8.894   174.222     0.200
     8.891   173.259     0.200
     9.277   180.252     0.200
     9.463   183.186     0.200
     9.859   190.656     0.200
     9.968   191.986     0.200
    10.587   204.763     0.200
    11.121   216.127     0.200
    11.452   222.269     0.200
    11.503   221.383     0.200
    11.757   229.049     0.200
    12.021   233.131     0.200
    12.272   236.492     0.200
    16.683   321.393     0.200
    19.447   384.572     0.200
    20.110   399.362     0.200
     2.530    50.151     0.200
     2.714    53.708     0.200
     2.714    54.208     0.200
     3.531    69.473     0.200
     3.797    72.374     0.200
     3.797    74.476     0.200
     3.872    74.902     0.200
     3.872    75.996     0.200
     4.039    78.542     0.200
     4.253    83.354     0.200
     4.253    83.854     0.200
     5.310   104.712     0.200
     5.478   107.848     0.200
     6.317   123.557     0.200
     6.682   131.111     0.200
     6.705   130.132     0.200
     6.779   132.675     0.200
     6.942   135.976     0.200
     7.171   140.920     0.200
     7.458   146.053     0.200
     7.515   147.178     0.200
     7.715   150.151     0.200
     7.724   151.347     0.200
     7.791   151.662     0.200
     8.017   156.820     0.200
     8.068   157.829     0.200
     8.133   157.874     0.200
     8.534   166.288     0.200
     9.069   176.654     0.200
     9.132   178.316     0.200
     9.317   180.260     0.200
     9.774   189.326     0.200
    10.259   199.061     0.200
    10.766   209.036     0.200
    11.044   215.200     0.200
    11.140   215.171     0.200
    11.320   218.781     0.200
     2.585    52.096     0.200
     2.585    51.393     0.200
     3.273    62.564     0.200
     3.087    60.231     0.200
     3.087    60.931     0.200
     3.299    65.060     0.200
     4.421    85.566     0.200
     4.835    93.634     0.200
     6.906   135.266     0.200
     7.294   141.838     0.200
     7.412   144.435     0.200
     7.531   146.277     0.200
     7.701   150.489     0.200
     8.104   157.688     0.200
     8.236   160.740     0.200
     8.377   162.795     0.200
     8.607   167.823     0.200
     8.657   168.829     0.200
     9.265   180.138     0.200
     9.656   188.176     0.200
     9.715   188.480     0.200
     9.903   192.089     0.200
    10.359   201.270     0.200
    10.839   208.867     0.200
    11.609   225.284     0.200
    11.718   226.310     0.200
    11.883   229.286     0.200
    11.886   233.388     0.200
    15.346   297.185     0.200
    15.175   296.786     0.200
    16.871   323.301     0.200
    17.644   341.855     0.200
    18.552   362.057     0.200
     2.656    52.516     0.200
     2.667    54.092     0.200
     2.909    57.467     0.200
     2.973    58.917     0.200
     3.294    65.670     0.200
     3.914    77.332     0.200
     4.516    88.407     0.200
     4.521    89.249     0.200
     5.354   105.128     0.200
     5.721   111.543     0.200
     5.815   114.245     0.200
     3.087    60.285     0.200
     3.400    67.731     0.200
     3.683    73.628     0.200
     4.147    81.813     0.200
     4.299    85.140     0.200
     4.669    92.621     0.200
     4.866    96.324     0.200
     7.090   138.773     0.200
     2.607    49.848     0.200
     2.607    50.145     0.200
     2.698    53.996     0.200
     2.698    53.894     0.200
     2.878    56.889     0.200
     3.630    70.708     0.200
     3.697    73.624     0.200
     4.039    79.139     0.200
     4.131    80.360     0.200
     4.417    86.620     0.200
     4.974    97.231     0.200
     5.425   107.672     0.200
     5.637   110.688     0.200
     6.477   127.284     0.200
     6.846   133.678     0.200
     6.865   134.160     0.200
     6.941   136.067     0.200
     7.100   139.115     0.200
     7.180   142.206     0.200
     7.675   149.498     0.200
     7.831   153.583     0.200
     7.869   153.041     0.200
     7.954   154.749     0.200
     8.176   160.362     0.200
     8.227   160.470     0.200
     8.357   163.145     0.200
     8.839   171.725     0.200
     9.936   189.432     0.200
    11.454   224.034     0.200
    15.185   295.576     0.200
    15.681   303.891     0.200
    18.079   351.992     0.200
     2.603    49.871     0.200
     2.698    53.459     0.200
     2.880    56.732     0.200
     3.630    70.582     0.200
     3.697    72.999     0.200
     4.039    78.808     0.200
     4.126    81.003     0.200
     4.419    86.770     0.200
     4.974    97.503     0.200
     5.430   106.973     0.200
     5.640   110.124     0.200
     6.480   126.924     0.200
     6.848   133.835     0.200
     6.868   134.198     0.200
     6.944   135.915     0.200
     7.103   138.753     0.200
     2.606    49.933     0.200
     2.606    49.831     0.200
     2.700    53.339     0.200
     2.881    56.417     0.200
     2.881    57.221     0.200
     3.628    70.595     0.200
     3.699    73.073     0.200
     3.699    73.471     0.200
     4.041    79.281     0.200
     4.041    78.984     0.200
     4.129    80.164     0.200
     4.420    86.852     0.200
     4.975    97.476     0.200
     5.429   106.983     0.200
     5.641   110.710     0.200
     6.481   127.510     0.200
     6.849   132.917     0.200
     6.868   134.589     0.200
     6.944   135.701     0.200
     7.104   139.340     0.200
     7.472   147.147     0.200
     7.679   150.232     0.200
     7.836   154.190     0.200
     7.873   154.060     0.200
     7.957   154.884     0.200
     8.179   159.587     0.200
     8.230   161.093     0.200
     8.296   161.030     0.200
     8.361   163.071     0.200
     8.842   171.952     0.200
     9.299   180.626     0.200
     9.482   183.689     0.200
     9.940   194.911     0.200
    11.458   224.920     0.200
     2.601    49.948     0.200
     2.700    53.687     0.200
     2.883    55.750     0.200
     2.883    57.047     0.200
     3.629    70.253     0.200
     3.699    71.437     0.200
     3.699    73.234     0.200
     4.041    77.742     0.200
     4.041    79.140     0.200
     4.121    80.302     0.200
     4.422    86.688     0.200
     4.975    97.439     0.200
     5.436   107.958     0.200
     6.851   134.150     0.200
     6.871   134.506     0.200
     6.947   135.531     0.200
     7.107   139.161     0.200
     7.193   144.069     0.200
     7.481   147.394     0.200
     7.844   154.263     0.200
     7.877   153.274     0.200
     7.960   155.713     0.200
     8.183   159.611     0.200
     8.234   160.914     0.200
     8.364   163.387     0.200
     8.700   169.667     0.200
     8.845   172.881     0.200
    11.464   223.520     0.200
    17.285   336.024     0.200
    18.071   352.513     0.200
     2.595    49.422     0.200
     2.595    49.719     0.200
     2.692    53.481     0.200
     2.876    56.644     0.200
     2.876    56.941     0.200
     3.691    73.425     0.200
     3.636    68.867     0.200
     3.636    71.265     0.200
     4.033    78.035     0.200
     4.033    78.832     0.200
     4.117    79.756     0.200
     4.415    85.285     0.200
     4.415    86.582     0.200
     4.968    97.232     0.200
     5.431   107.126     0.200
     5.637   110.721     0.200
     6.476   127.125     0.200
     6.843   133.740     0.200
     6.864   134.102     0.200
     7.100   138.546     0.200
     7.193   142.165     0.200
     7.480   146.108     0.200
     7.674   150.941     0.200
     7.838   154.028     0.200
     7.869   153.265     0.200
     7.952   156.006     0.200
     7.906   147.581     0.200
     8.175   159.596     0.200
     8.291   161.137     0.200
     8.357   163.372     0.200
     8.837   172.571     0.200
     9.934   190.214     0.200
    11.011   213.347     0.200
    18.078   352.959     0.200
     2.604    49.733     0.200
     2.604    49.833     0.200
     2.708    52.920     0.200
     2.892    56.569     0.200
     3.621    69.258     0.200
     3.621    69.558     0.200
     3.707    71.559     0.200
     4.122    80.717     0.200
     4.122    80.417     0.200
     4.049    79.072     0.200
     4.431    86.210     0.200
     4.983    97.270     0.200
     7.199   141.729     0.200
     8.374   162.700     0.200
     8.854   171.494     0.200
     9.245   177.828     0.200
    17.276   333.973     0.200
    18.062   350.216     0.200
     2.606    50.177     0.200
     2.702    54.153     0.200
     2.884    57.027     0.200
     3.626    71.071     0.200
     4.043    79.201     0.200
     4.127    80.222     0.200
     4.424    87.363     0.200
     4.978    97.496     0.200
     5.644   110.516     0.200
     6.852   133.522     0.200
     6.872   135.093     0.200
     6.948   136.307     0.200
     7.475   145.950     0.200
     7.841   152.886     0.200
     2.576    49.777     0.200
     2.691    53.333     0.200
     2.881    56.617     0.200
     3.640    70.153     0.200
     3.688    72.894     0.200
     4.031    78.492     0.200
     4.093    80.076     0.200
     4.419    86.463     0.200
     4.965    97.097     0.200
     5.645   110.458     0.200
     6.848   133.218     0.200
     6.945   135.981     0.200
     7.860   153.408     0.200
     2.605    50.240     0.200
     2.711    53.903     0.200
     2.896    56.844     0.200
     3.618    70.616     0.200
     3.710    72.745     0.200
     4.052    78.956     0.200
     4.122    80.339     0.200
     4.435    86.385     0.200
     4.986    97.554     0.200
     5.449   107.449     0.200
     5.657   110.723     0.200
     6.864   134.343     0.200
     6.884   133.998     0.200
     6.960   136.421     0.200
     7.489   146.746     0.200
     7.856   153.858     0.200
     2.611    50.272     0.200
     2.701    53.918     0.200
     2.881    57.224     0.200
     3.627    71.522     0.200
     3.702    73.646     0.200
     4.042    80.069     0.200
     4.135    79.388     0.200
     4.420    86.954     0.200
     5.425   107.030     0.200
     5.640   110.425     0.200
     6.480   125.919     0.200
     6.849   133.614     0.200
     6.867   133.796     0.200
     6.944   135.402     0.200
     7.465   145.725     0.200
     2.594    49.983     0.200
     2.696    53.990     0.200
     2.881    57.332     0.200
     3.633    69.952     0.200
     3.695    72.526     0.200
     4.037    79.742     0.200
     4.114    79.843     0.200
     4.420    87.171     0.200
     4.971    97.543     0.200
     5.643   110.707     0.200
     6.482   127.307     0.200
     6.849   133.530     0.200
     6.870   134.182     0.200
     6.945   135.205     0.200
     7.487   146.180     0.200
     2.613    50.578     0.200
     2.716    53.977     0.200
     2.716    54.176     0.200
     2.899    57.038     0.200
     3.613    70.001     0.200
     3.613    70.900     0.200
     3.715    72.813     0.200
     4.130    80.773     0.200
     4.057    81.028     0.200
     4.057    79.528     0.200
     4.438    88.077     0.200
     4.438    87.077     0.200
     4.991    98.323     0.200
     6.499   127.426     0.200
     6.887   134.701     0.200
     6.962   136.418     0.200
     7.195   141.977     0.200
     7.697   150.945     0.200
     7.854   154.710     0.200
     7.891   153.676     0.200
     8.249   160.407     0.200
     8.314   162.341     0.200
     8.379   163.082     0.200
     8.860   171.667     0.200
    15.189   299.865     0.200
     2.609    49.925     0.200
     2.711    53.733     0.200
     2.894    56.992     0.200
     3.618    71.042     0.200
     3.710    72.769     0.200
     4.052    78.784     0.200
     4.127    80.605     0.200
     4.433    86.832     0.200
     4.986    98.181     0.200
     5.444   108.333     0.200
     5.655   111.679     0.200
     6.494   126.379     0.200
     6.862   133.689     0.200
     6.882   135.055     0.200
     6.958   134.770     0.200
     7.118   139.504     0.200
     7.851   154.143     0.200
     2.604    50.108     0.200
     2.702    53.760     0.200
     2.885    56.625     0.200
     3.626    70.276     0.200
     3.626    70.377     0.200
     3.701    72.899     0.200
     3.702    72.891     0.200
     4.043    78.111     0.200
     4.043    78.908     0.200
     4.124    80.668     0.200
     4.424    86.765     0.200
     4.978    97.308     0.200
     7.192   141.619     0.200
     7.479   145.616     0.200
     7.844   152.862     0.200
     7.962   155.386     0.200
     8.184   159.684     0.200
     8.847   171.554     0.200
     9.303   180.834     0.200
     9.487   183.691     0.200
     9.944   192.547     0.200
    10.431   201.766     0.200
    10.934   212.596     0.200
    11.190   218.510     0.200
    11.313   219.473     0.200
    11.492   223.376     0.200
    17.283   334.219     0.200
    18.069   351.226     0.200
    19.146   379.719     0.200
     2.602    50.108     0.200
     2.696    54.305     0.200
     2.878    57.079     0.200
     3.632    70.276     0.200
     3.696    73.236     0.200
     4.037    78.654     0.200
     4.125    80.233     0.200
     4.417    86.515     0.200
     4.972    96.747     0.200
     5.428   106.814     0.200
     5.638   110.470     0.200
     6.846   134.080     0.200
     6.865   134.045     0.200
     6.941   135.558     0.200
     7.101   139.193     0.200
     2.586    50.419     0.200
     2.693    52.873     0.200
     2.879    57.094     0.200
     3.637    69.750     0.200
     3.691    73.022     0.200
     4.033    79.829     0.200
     4.105    79.688     0.200
     4.418    87.039     0.200
     4.967    97.529     0.200
     5.442   106.489     0.200
     5.642   111.256     0.200
     6.481   126.960     0.200
     6.847   134.194     0.200
     6.944   136.067     0.200
     7.105   138.881     0.200
     2.603    50.242     0.200
     2.603    49.843     0.200
     2.696    53.655     0.200
     2.696    53.055     0.200
     2.878    56.936     0.200
     3.632    71.041     0.200
     3.696    71.891     0.200
     4.126    80.567     0.200
     4.126    80.465     0.200
     4.038    78.204     0.200
     4.038    79.403     0.200
     4.417    85.674     0.200
     4.417    85.873     0.200
     4.972    96.596     0.200
     6.865   134.205     0.200
     6.941   135.617     0.200
    11.002   214.473     0.200
    11.456   225.938     0.200
     2.599    49.454     0.200
     2.599    49.954     0.200
     2.696    53.614     0.200
     2.880    55.875     0.200
     2.880    57.076     0.200
     3.632    70.791     0.200
     3.695    73.456     0.200
     4.037    79.164     0.200
     4.120    80.294     0.200
     4.419    85.214     0.200
     4.419    86.714     0.200
     4.972    97.859     0.200
     5.433   107.979     0.200
     5.640   111.557     0.200
     6.480   127.357     0.200
     6.847   133.772     0.200
     6.868   134.535     0.200
     6.943   136.054     0.200
     7.103   138.484     0.200
     7.479   147.496     0.200
     7.678   150.977     0.200
     7.840   153.684     0.200
     7.873   153.902     0.200
     7.903   148.345     0.200
     7.956   154.635     0.200
     8.179   160.234     0.200
     8.230   161.639     0.200
     8.361   163.911     0.200
     8.841   172.303     0.200
     9.232   178.937     0.200
     9.297   181.383     0.200
     9.481   183.639     0.200
     9.938   194.993     0.200
     9.938   193.601     0.200
    10.425   202.423     0.200
    10.928   213.345     0.200
    11.007   216.141     0.200
    11.460   229.118     0.200
    15.197   299.817     0.200
    17.289   335.036     0.200
    18.075   351.798     0.200
    19.140   378.823     0.200
     2.665    52.422     0.200
     3.496    68.330     0.200
     3.833    74.793     0.200
     3.834    75.183     0.200
     4.057    78.577     0.200
     4.205    82.657     0.200
     4.770    93.557     0.200
     5.248   103.276     0.200
     5.425   106.111     0.200
     6.652   130.289     0.200
     2.659    51.889     0.200
     2.659    52.389     0.200
     3.492    69.270     0.200
     3.837    75.146     0.200
     3.837    74.347     0.200
     3.830    75.028     0.200
     4.061    79.427     0.200
     4.199    82.722     0.200
     4.199    82.222     0.200
     4.766    93.399     0.200
     6.042   119.817     0.200
     7.402   145.141     0.200
     7.653   149.908     0.200
     7.652   149.721     0.200
     8.113   151.787     0.200
     8.008   157.268     0.200
     8.140   158.434     0.200
     9.011   175.063     0.200
    11.101   215.540     0.200
    11.249   222.990     0.200
     2.602    50.094     0.200
     2.710    53.241     0.200
     2.895    57.277     0.200
     3.620    70.216     0.200
     3.708    73.192     0.200
     4.050    79.397     0.200
     4.119    79.598     0.200
     4.434    86.819     0.200
     5.450   107.161     0.200
     5.657   110.448     0.200
     2.614    50.168     0.200
     2.702    54.342     0.200
     2.881    57.151     0.200
     3.625    70.172     0.200
     3.702    72.768     0.200
     4.044    78.887     0.200
     4.138    80.681     0.200
     4.421    86.885     0.200
     4.979    97.777     0.200
     5.424   107.684     0.200
     5.640   111.059     0.200
     6.480   127.054     0.200
     6.849   133.345     0.200
     6.867   134.133     0.200
     6.944   135.937     0.200
     2.657    51.870     0.200
     2.657    52.370     0.200
     3.490    68.449     0.200
     3.828    75.206     0.200
     3.839    73.777     0.200
     4.061    78.888     0.200
     4.196    82.703     0.200
     4.196    81.804     0.200
     4.764    93.078     0.200
     5.237   103.457     0.200
     5.416   106.168     0.200
     6.256   122.470     0.200
     6.625   129.166     0.200
     6.644   130.247     0.200
     6.720   131.758     0.200
     6.879   133.996     0.200
     7.115   141.549     0.200
     7.401   144.208     0.200
     7.454   145.988     0.200
     7.651   149.288     0.200
     7.650   149.404     0.200
     7.732   150.140     0.200
     7.955   154.746     0.200
     8.006   156.152     0.200
     8.071   157.388     0.200
     8.137   158.118     0.200
     8.115   151.063     0.200
     8.617   167.913     0.200
     9.009   175.646     0.200
     9.074   175.780     0.200
     9.257   179.548     0.200
     9.715   185.947     0.200
     9.715   188.604     0.200
    10.203   197.009     0.200
    10.704   208.358     0.200
    10.973   212.816     0.200
    11.102   217.533     0.200
    11.246   219.291     0.200
    11.270   218.851     0.200
    15.245   295.342     0.200
    17.512   338.103     0.200
    18.540   364.491     0.200
    18.955   375.481     0.200
    20.265   404.664     0.200
     2.611    50.096     0.200
     2.707    53.876     0.200
     2.889    57.355     0.200
     3.621    71.009     0.200
     3.707    73.510     0.200
     4.048    79.522     0.200
     4.132    80.149     0.200
     4.428    87.192     0.200
     4.983    97.615     0.200
     5.436   106.435     0.200
     5.648   111.051     0.200
     6.488   127.648     0.200
     6.857   134.152     0.200
     6.876   134.727     0.200
     7.474   147.651     0.200
     7.842   154.247     0.200
     7.965   154.818     0.200
     2.608    50.170     0.200
     2.704    54.147     0.200
     2.886    57.024     0.200
     3.624    70.608     0.200
     3.703    72.684     0.200
     4.045    79.594     0.200
     4.129    80.020     0.200
     4.425    86.858     0.200
     4.980    97.090     0.200
     5.646   110.713     0.200
     6.486   127.713     0.200
     6.854   133.516     0.200
     6.873   134.589     0.200
     2.605    50.307     0.200
     2.711    53.567     0.200
     2.896    56.614     0.200
     3.619    70.475     0.200
     3.709    72.121     0.200
     4.052    79.421     0.200
     4.122    79.206     0.200
     4.435    86.858     0.200
     4.986    97.519     0.200
     5.449   107.314     0.200
     5.657   110.289     0.200
     6.497   126.591     0.200
     6.863   133.210     0.200
     6.884   134.669     0.200
     7.489   147.307     0.200
     2.611    49.857     0.200
     2.710    53.901     0.200
     2.892    56.574     0.200
     2.892    57.074     0.200
     3.619    70.691     0.200
     3.709    73.441     0.200
     4.130    80.722     0.200
     4.051    78.052     0.200
     4.051    79.150     0.200
     4.431    86.612     0.200
     4.431    85.912     0.200
     4.985    97.447     0.200
     7.190   142.301     0.200
     8.372   163.123     0.200
     8.853   172.104     0.200
    10.996   215.090     0.200
    11.470   225.419     0.200
    15.188   299.123     0.200
    15.668   304.878     0.200
    17.277   337.227     0.200
    18.063   353.247     0.200
    18.571   367.853     0.200
    19.153   380.481     0.200
     2.603    50.002     0.200
     2.705    53.810     0.200
     3.624    70.387     0.200
     3.704    72.955     0.200
     4.046    79.262     0.200
     4.428    86.503     0.200
     4.428    86.804     0.200
     4.980    97.759     0.200
     5.442   107.473     0.200
     5.650   110.845     0.200
     6.490   127.245     0.200
     6.857   134.160     0.200
     6.953   135.742     0.200
     7.113   139.169     0.200
     7.196   142.271     0.200
     7.484   145.141     0.200
     7.688   150.164     0.200
     7.849   154.380     0.200
     7.883   153.789     0.200
     7.965   155.424     0.200
     8.188   160.119     0.200
     8.239   162.024     0.200
     8.305   161.161     0.200
     8.370   163.598     0.200
     8.851   172.690     0.200
     9.242   178.823     0.200
    15.196   297.642     0.200
    18.065   353.937     0.200
    18.563   367.051     0.200
     2.538    49.081     0.200
     3.344    66.078     0.200
     3.666    71.621     0.200
     3.666    71.922     0.200
     3.973    78.535     0.200
     4.016    77.534     0.200
     4.607    90.941     0.200
     4.922    97.166     0.200
     5.161   100.974     0.200
     6.004   117.431     0.200
     6.390   124.834     0.200
     6.396   125.164     0.200
     6.480   126.980     0.200
     6.622   129.318     0.200
     6.856   135.096     0.200
     7.141   139.771     0.200
     7.334   144.413     0.200
     7.380   143.783     0.200
     7.492   146.270     0.200
     7.696   149.891     0.200
     7.748   151.284     0.200
     7.869   153.567     0.200
     8.370   163.519     0.200
     8.419   159.898     0.200
     8.763   170.832     0.200
     8.841   172.628     0.200
     9.014   175.907     0.200
     9.476   182.385     0.200
    10.946   212.561     0.200
    11.048   217.015     0.200
    15.122   294.645     0.200
    18.572   366.089     0.200
     2.519    49.296     0.200
     2.519    48.796     0.200
     3.345    66.255     0.200
     3.669    71.873     0.200
     4.009    78.397     0.200
     4.009    77.593     0.200
     3.984    78.490     0.200
     3.984    76.795     0.200
     4.609    90.498     0.200
     6.887   137.756     0.200
     8.394   156.299     0.200
     8.385   163.528     0.200
     8.778   171.351     0.200
     8.854   172.468     0.200
     9.489   184.446     0.200
     9.989   193.409     0.200
    10.464   203.176     0.200
    10.694   208.184     0.200
    10.877   210.048     0.200
    11.066   216.590     0.200
    11.083   215.248     0.200
    15.145   297.148     0.200
    17.738   344.508     0.200
    18.676   367.256     0.200
    18.851   373.301     0.200
    20.085   405.596     0.200
     2.531    48.826     0.200
     3.344    65.737     0.200
     3.666    72.369     0.200
     3.977    78.651     0.200
     4.014    78.811     0.200
     4.607    89.992     0.200
     4.932    96.605     0.200
     5.166   101.769     0.200
     6.395   125.730     0.200
     6.400   124.576     0.200
     6.484   127.187     0.200
     6.628   130.013     0.200
     7.152   140.591     0.200
     7.344   143.652     0.200
     2.524    48.789     0.200
     3.665    71.777     0.200
     3.977    78.734     0.200
     4.015    79.497     0.200
     4.606    90.701     0.200
     4.937    98.627     0.200
     5.168   101.235     0.200
     6.400   125.854     0.200
     6.397   125.095     0.200
     6.486   127.761     0.200
     6.630   129.877     0.200
     7.350   144.768     0.200
     2.828    56.883     0.200
     2.828    56.184     0.200
     2.862    56.981     0.200
     2.862    55.782     0.200
     3.094    59.478     0.200
     3.587    70.222     0.200
     3.856    76.588     0.200
     4.162    80.911     0.200
     4.162    80.711     0.200
     4.390    86.955     0.200
     6.520   129.696     0.200
     6.808   134.331     0.200
     6.791   133.726     0.200
     6.856   135.180     0.200
     6.960   137.264     0.200
     7.366   145.118     0.200
     7.840   153.791     0.200
     7.864   153.611     0.200
     8.080   158.687     0.200
     8.175   160.280     0.200
     8.727   171.044     0.200
     9.122   178.229     0.200
     9.223   180.146     0.200
    10.487   201.267     0.200
    11.124   218.304     0.200
     2.526    49.163     0.200
     3.338    65.787     0.200
     3.661    71.724     0.200
     3.971    78.193     0.200
     4.020    78.536     0.200
     4.602    90.042     0.200
     4.929    97.424     0.200
     5.161   101.212     0.200
     6.004   118.069     0.200
     6.390   124.068     0.200
     6.394   125.120     0.200
     6.479   125.425     0.200
     6.623   129.452     0.200
     7.154   139.757     0.200
     2.517    49.122     0.200
     2.517    49.022     0.200
     3.337    65.351     0.200
     3.661    71.876     0.200
     3.661    71.976     0.200
     3.975    78.812     0.200
     3.975    77.712     0.200
     4.018    78.901     0.200
     4.601    89.398     0.200
     4.940    97.248     0.200
     5.167   101.301     0.200
     6.009   117.765     0.200
     6.395   125.362     0.200
     6.398   125.831     0.200
     6.484   127.431     0.200
     6.628   129.843     0.200
     6.882   134.757     0.200
     7.167   139.956     0.200
     7.207   140.488     0.200
     7.353   144.384     0.200
     7.387   144.883     0.200
     7.702   151.009     0.200
     7.754   152.004     0.200
     7.824   152.292     0.200
     7.877   153.271     0.200
     8.221   160.451     0.200
     8.375   164.557     0.200
     8.405   157.356     0.200
     8.768   170.073     0.200
     9.018   175.352     0.200
     9.480   183.131     0.200
    10.959   215.262     0.200
    11.068   216.123     0.200
    18.563   361.635     0.200
    18.678   366.546     0.200
    18.844   370.974     0.200
     2.513    48.414     0.200
     2.513    48.313     0.200
     3.341    64.551     0.200
     3.665    71.166     0.200
     3.665    70.967     0.200
     4.012    78.118     0.200
     4.012    76.919     0.200
     3.982    78.074     0.200
     3.982    77.574     0.200
     4.606    89.792     0.200
     6.892   134.028     0.200
     8.384   161.605     0.200
     8.776   170.123     0.200
     9.027   174.203     0.200
     9.488   183.689     0.200
    10.970   218.113     0.200
     2.603    50.154     0.200
     2.689    53.350     0.200
     2.869    57.154     0.200
     3.638    70.073     0.200
     3.689    71.778     0.200
     4.030    79.597     0.200
     4.408    87.287     0.200
     4.965    96.687     0.200
     5.416   106.831     0.200
     5.628   110.256     0.200
     6.468   127.152     0.200
     6.837   133.947     0.200
     6.855   133.631     0.200
     6.932   134.836     0.200
     7.823   152.439     0.200
     2.524    48.654     0.200
     3.350    65.819     0.200
     3.674    71.837     0.200
     4.005    76.679     0.200
     3.988    78.066     0.200
     4.614    90.063     0.200
     4.951    97.438     0.200
     5.180   101.460     0.200
     6.023   118.523     0.200
     6.409   125.223     0.200
     6.412   125.089     0.200
     6.497   127.590     0.200
     6.642   129.902     0.200
     6.884   135.645     0.200
     7.169   140.350     0.200
     7.221   141.445     0.200
    10.972   216.477     0.200
     2.514    49.109     0.200
     3.659    71.842     0.200
     3.974    78.168     0.200
     4.019    77.237     0.200
     4.600    89.763     0.200
     4.942    97.471     0.200
     5.167   101.844     0.200
     6.398   124.284     0.200
     6.395   125.209     0.200
     6.629   129.489     0.200
     7.170   140.463     0.200
     7.355   145.008     0.200
     2.527    48.888     0.200
     2.527    48.990     0.200
     3.351    66.176     0.200
     3.674    71.299     0.200
     3.674    71.705     0.200
     4.005    77.251     0.200
     4.005    77.048     0.200
     3.988    77.142     0.200
     4.615    89.923     0.200
     5.179   100.646     0.200
     6.880   136.219     0.200
     8.388   163.497     0.200
     8.781   170.811     0.200
     8.857   172.422     0.200
     9.492   184.051     0.200
    11.057   215.489     0.200
    10.969   217.303     0.200
    15.136   294.745     0.200
    18.552   359.759     0.200
    18.685   368.450     0.200
    18.858   376.541     0.200
     2.548    49.063     0.200
     3.674    71.321     0.200
     3.980    78.356     0.200
     4.009    78.810     0.200
     4.615    91.340     0.200
     4.922    96.454     0.200
     5.166   102.103     0.200
     6.395   124.669     0.200
     6.402   125.784     0.200
     6.486   127.304     0.200
     6.627   129.854     0.200
     7.134   139.736     0.200
     7.334   144.410     0.200
     7.384   144.424     0.200
     7.498   146.993     0.200
     7.874   154.105     0.200
     2.529    49.096     0.200
     3.336    65.580     0.200
     3.658    71.619     0.200
     3.967    77.915     0.200
     4.023    78.856     0.200
     4.599    90.139     0.200
     4.921    97.377     0.200
     5.156   100.940     0.200
     5.999   117.700     0.200
     6.385   124.601     0.200
     6.390   124.542     0.200
     6.474   126.254     0.200
     6.617   129.484     0.200
     7.147   140.506     0.200
     3.332    65.870     0.200
     3.657    71.079     0.200
     3.976    78.550     0.200
     4.020    77.638     0.200
     4.597    89.604     0.200
     4.955    97.822     0.200
     5.172   101.897     0.200
     6.014   118.366     0.200
     6.400   125.360     0.200
     6.400   125.160     0.200
     6.487   127.248     0.200
     6.634   129.736     0.200
     6.904   137.328     0.200
     7.189   140.353     0.200
     7.370   144.348     0.200
     7.394   143.458     0.200
     7.499   146.734     0.200
     7.708   150.100     0.200
     7.760   151.897     0.200
     7.884   154.349     0.200
     8.227   159.745     0.200
     8.379   162.764     0.200
     8.392   158.131     0.200
     8.772   170.982     0.200
     9.022   174.963     0.200
     9.483   182.953     0.200
    10.971   214.576     0.200
    11.085   216.609     0.200
     2.508    48.858     0.200
     3.650    71.932     0.200
     3.964    77.659     0.200
     4.029    78.403     0.200
     4.590    90.158     0.200
     4.935    97.539     0.200
     5.157   101.840     0.200
     6.000   118.005     0.200
     6.386   124.103     0.200
     6.388   125.079     0.200
     6.474   126.374     0.200
     6.619   129.179     0.200
     7.170   139.658     0.200
     7.348   143.766     0.200
     2.511    49.206     0.200
     3.327    65.285     0.200
     3.650    72.409     0.200
     3.964    78.249     0.200
     4.029    78.491     0.200
     4.591    89.432     0.200
     4.932    96.953     0.200
     5.156   100.538     0.200
     6.385   124.200     0.200
     6.387   125.264     0.200
     6.473   127.069     0.200
     6.618   129.878     0.200
     7.166   140.281     0.200
     7.346   144.081     0.200
     2.532    48.991     0.200
     3.343    65.022     0.200
     3.666    72.157     0.200
     3.975    77.744     0.200
     4.015    77.179     0.200
     4.606    90.178     0.200
     4.929    96.513     0.200
     5.165   101.566     0.200
     6.008   117.327     0.200
     6.393   125.026     0.200
     6.398   124.470     0.200
     6.483   126.781     0.200
     6.626   129.510     0.200
     2.619    51.659     0.200
     2.722    53.657     0.200
     2.722    53.759     0.200
     2.938    58.034     0.200
     2.939    56.620     0.200
     2.939    57.823     0.200
     3.275    65.100     0.200
     3.275    64.498     0.200
     3.880    76.343     0.200
     4.507    87.824     0.200
     4.507    88.324     0.200
     4.738    92.634     0.200
     4.545    88.282     0.200
     6.991   139.289     0.200
     2.535    48.667     0.200
     2.535    48.565     0.200
     3.355    67.300     0.200
     3.678    72.631     0.200
     4.002    78.553     0.200
     3.990    78.896     0.200
     4.619    91.250     0.200
     6.872   137.435     0.200
     8.397   158.224     0.200
     8.781   171.674     0.200
     8.858   173.280     0.200
     9.032   175.454     0.200
     9.493   184.767     0.200
     9.994   194.819     0.200
    10.466   204.713     0.200
    10.691   208.594     0.200
    10.883   210.054     0.200
    11.090   214.732     0.200
    18.863   371.259     0.200
    20.068   400.063     0.200
    23.767   473.382     0.200
     2.516    48.542     0.200
     3.325    65.696     0.200
     3.648    71.332     0.200
     3.959    78.199     0.200
     4.033    78.935     0.200
     4.588    89.951     0.200
     4.922    97.253     0.200
     5.150   101.598     0.200
     7.156   140.281     0.200
     2.513    49.091     0.200
     3.344    66.092     0.200
     3.669    71.209     0.200
     4.009    77.142     0.200
     3.986    78.405     0.200
     4.609    89.932     0.200
     6.895   135.834     0.200
     2.514    49.163     0.200
     3.342    66.106     0.200
     3.666    71.725     0.200
     3.982    79.035     0.200
     4.012    78.780     0.200
     4.606    90.147     0.200
     4.951    97.634     0.200
     5.175   101.911     0.200
     6.018   118.374     0.200
     6.404   125.675     0.200
     6.406   124.747     0.200
     6.492   126.345     0.200
     6.637   129.953     0.200
     6.891   137.934     0.200
     7.176   140.460     0.200
     7.364   144.164     0.200
     9.488   181.874     0.200
     2.541    49.280     0.200
     3.340    66.160     0.200
     3.662    71.613     0.200
     3.967    78.350     0.200
     4.022    77.912     0.200
     4.603    90.030     0.200
     4.912    96.823     0.200
     5.153   100.900     0.200
     5.997   117.160     0.200
     6.382   124.959     0.200
     6.389   124.380     0.200
     6.473   126.400     0.200
     6.615   129.652     0.200
     7.324   143.071     0.200
     2.504    48.477     0.200
     3.305    64.523     0.200
     3.628    70.559     0.200
     3.939    77.831     0.200
     4.053    78.596     0.200
     4.568    89.180     0.200
     4.908    96.121     0.200
     5.130   100.827     0.200
     5.973   116.691     0.200
     6.362   124.152     0.200
     6.359   124.089     0.200
     6.592   128.070     0.200
     7.322   144.145     0.200
     2.509    48.488     0.200
     3.335    65.150     0.200
     3.659    71.867     0.200
     3.976    78.873     0.200
     4.019    78.973     0.200
     4.600    90.689     0.200
     4.947    97.636     0.200
     5.169   101.243     0.200
     6.012   118.109     0.200
     6.399   125.789     0.200
     6.398   124.505     0.200
     6.486   127.582     0.200
     6.631   130.483     0.200
     7.361   145.069     0.200
     2.536    49.073     0.200
     2.536    49.475     0.200
     3.358    65.177     0.200
     3.681    72.107     0.200
     3.998    77.303     0.200
     3.998    76.603     0.200
     3.993    78.166     0.200
     4.622    89.828     0.200
     4.947    97.331     0.200
     5.183   100.976     0.200
     6.026   118.239     0.200
     6.412   125.637     0.200
     6.416   125.690     0.200
     6.501   126.396     0.200
     6.645   130.021     0.200
     6.874   136.219     0.200
     7.159   140.017     0.200
     7.360   143.680     0.200
     7.403   143.573     0.200
     7.513   146.682     0.200
     7.719   150.990     0.200
     7.771   151.982     0.200
     7.893   153.960     0.200
     8.238   160.727     0.200
     8.393   156.284     0.200
     8.392   163.527     0.200
     8.785   171.043     0.200
     8.862   171.947     0.200
     9.036   175.417     0.200
     9.497   185.602     0.200
     9.497   185.332     0.200
     9.998   193.288     0.200
    10.470   202.277     0.200
    10.695   208.854     0.200
    10.886   210.524     0.200
    10.971   216.755     0.200
    11.049   216.570     0.200
    11.093   215.305     0.200
    14.757   286.144     0.200
    15.128   295.874     0.200
    16.104   312.019     0.200
    18.549   361.929     0.200
    18.693   368.143     0.200
    18.865   373.059     0.200
    20.069   399.255     0.200
     2.534    49.013     0.200
     3.361    66.459     0.200
     3.685    71.881     0.200
     3.994    76.979     0.200
     3.999    78.722     0.200
     4.626    91.103     0.200
     4.955    97.362     0.200
     5.190   101.925     0.200
     6.033   117.686     0.200
     6.418   125.684     0.200
     6.422   125.643     0.200
     6.507   127.549     0.200
     7.166   139.964     0.200
     7.367   144.312     0.200
     2.521    48.889     0.200
     3.348    65.937     0.200
     3.672    72.453     0.200
     3.987    78.477     0.200
     4.006    78.349     0.200
     4.613    90.680     0.200
     4.952    97.914     0.200
     5.180   102.154     0.200
     6.023   117.623     0.200
     6.408   125.722     0.200
     6.411   125.592     0.200
     6.497   127.388     0.200
     6.642   129.900     0.200
     6.888   137.630     0.200
     7.173   140.398     0.200
     7.365   144.854     0.200
     7.401   144.641     0.200
     7.509   145.575     0.200
     7.715   151.062     0.200
     7.767   151.262     0.200
     7.890   153.625     0.200
     8.392   158.196     0.200
     8.781   171.628     0.200
     9.031   175.011     0.200
    10.972   213.455     0.200
    11.063   214.913     0.200
    18.550   361.028     0.200
    18.678   368.985     0.200
     2.536    49.189     0.200
     3.362    66.549     0.200
     3.685    72.078     0.200
     3.994    78.673     0.200
     3.998    78.621     0.200
     4.626    90.194     0.200
     4.953    98.374     0.200
     5.189   102.328     0.200
     6.032   117.788     0.200
     6.418   125.693     0.200
     6.421   125.843     0.200
     6.507   127.552     0.200
     6.650   129.772     0.200
     7.163   140.287     0.200
     7.366   144.426     0.200
     2.509    48.504     0.200
     3.313    64.823     0.200
     3.635    71.860     0.200
     3.946    78.432     0.200
     4.045    78.871     0.200
     4.576    89.783     0.200
     4.912    96.359     0.200
     5.137   100.936     0.200
     5.980   116.299     0.200
     6.366   124.797     0.200
     6.369   124.358     0.200
     6.454   125.363     0.200
     7.326   143.686     0.200
     2.511    49.101     0.200
     2.511    48.702     0.200
     3.320    65.561     0.200
     3.643    71.895     0.200
     3.643    71.293     0.200
     3.955    77.757     0.200
     3.955    79.057     0.200
     4.037    77.491     0.200
     4.037    80.690     0.200
     4.584    89.517     0.200
     4.921    96.183     0.200
     5.146   100.955     0.200
     5.989   117.119     0.200
     6.375   124.816     0.200
     6.378   124.579     0.200
     6.463   126.481     0.200
     6.608   129.397     0.200
     6.873   137.341     0.200
     7.334   143.813     0.200
     7.367   142.939     0.200
     7.475   145.168     0.200
     7.681   149.962     0.200
     7.733   150.260     0.200
     7.856   153.425     0.200
     8.201   159.603     0.200
     8.355   162.510     0.200
     8.425   158.205     0.200
     8.747   170.524     0.200
     8.823   171.835     0.200
     8.998   175.204     0.200
     9.459   184.038     0.200
    10.939   215.796     0.200
    11.075   217.773     0.200
    11.055   214.500     0.200
     2.506    49.165     0.200
     3.313    65.548     0.200
     3.636    71.981     0.200
     3.948    77.740     0.200
     4.044    79.216     0.200
     4.577    89.602     0.200
     4.917    97.135     0.200
     5.140   101.332     0.200
     5.982   117.298     0.200
     6.371   124.460     0.200
     6.368   124.395     0.200
     6.457   126.363     0.200
     7.331   143.562     0.200
     2.547    49.441     0.200
     3.370    66.434     0.200
     3.693    72.464     0.200
     3.987    77.134     0.200
     4.004    79.337     0.200
     4.634    91.585     0.200
     4.951    98.279     0.200
     5.193   102.261     0.200
     6.036   117.222     0.200
     6.422   126.222     0.200
     6.427   125.463     0.200
     6.511   126.574     0.200
     7.363   144.335     0.200
     2.538    49.536     0.200
     3.358    65.864     0.200
     3.681    71.994     0.200
     3.999    76.789     0.200
     3.992    78.963     0.200
     4.622    90.515     0.200
     4.945    97.749     0.200
     5.182   102.179     0.200
     7.357   143.700     0.200
     2.532    49.244     0.200
     3.360    65.579     0.200
     3.684    71.800     0.200
     3.995    76.774     0.200
     3.998    78.432     0.200
     4.625    90.522     0.200
     4.956    98.655     0.200
     5.189   102.330     0.200
     6.651   130.272     0.200
     7.168   141.045     0.200
     7.368   144.600     0.200
     2.532    49.128     0.200
     2.532    49.328     0.200
     3.329    65.735     0.200
     3.650    71.384     0.200
     3.956    78.318     0.200
     4.033    78.614     0.200
     4.033    77.914     0.200
     4.591    90.203     0.200
     4.905    97.832     0.200
     4.905    96.332     0.200
     5.143   101.662     0.200
     5.986   118.321     0.200
     6.372   124.822     0.200
     6.462   127.367     0.200
     6.604   129.207     0.200
     6.849   138.472     0.200
     7.134   140.624     0.200
     7.318   143.174     0.200
     7.361   144.371     0.200
     7.474   146.656     0.200
     7.678   150.977     0.200
     7.730   152.071     0.200
     7.851   153.155     0.200
     8.197   160.116     0.200
     8.353   162.805     0.200
     8.436   158.499     0.200
     8.745   169.820     0.200
     8.823   171.815     0.200
     8.996   175.695     0.200
     9.458   183.373     0.200
     9.458   184.305     0.200
     9.960   193.346     0.200
    10.430   202.865     0.200
    10.652   208.369     0.200
    10.849   211.675     0.200
    10.928   213.820     0.200
    11.058   215.431     0.200
    11.056   218.804     0.200
    15.125   297.470     0.200
    18.590   366.530     0.200
    18.703   370.122     0.200
    18.840   372.914     0.200
     2.520    48.820     0.200
     3.650    71.038     0.200
     3.960    78.113     0.200
     4.031    79.188     0.200
     5.150   101.427     0.200
     5.993   117.784     0.200
     6.379   124.385     0.200
     6.383   124.735     0.200
     6.468   125.946     0.200
     6.612   129.667     0.200
     7.334   143.140     0.200
     2.533    49.222     0.200
     3.335    65.565     0.200
     3.657    71.609     0.200
     3.964    77.928     0.200
     4.025    77.710     0.200
     4.598    90.029     0.200
     4.914    97.134     0.200
     5.152   101.264     0.200
     5.995   117.924     0.200
     6.381   125.025     0.200
     6.386   124.757     0.200
     6.471   126.372     0.200
     6.613   129.310     0.200
     7.139   140.269     0.200
     7.327   143.778     0.200
     3.628    70.822     0.200
     3.941    77.870     0.200
     4.052    78.576     0.200
     4.569    88.943     0.200
     5.133   100.755     0.200
     5.976   117.520     0.200
     6.364   124.890     0.200
     6.362   124.315     0.200
     6.450   125.989     0.200
     7.162   140.074     0.200
     7.329   143.735     0.200
     2.532    49.370     0.200
     3.355    66.662     0.200
     3.679    72.387     0.200
     4.001    77.328     0.200
     3.991    78.635     0.200
     4.619    90.206     0.200
     4.948    97.467     0.200
     5.182   101.539     0.200
     6.025   118.800     0.200
     6.411   125.200     0.200
     6.415   125.157     0.200
     6.644   129.783     0.200
     7.163   140.125     0.200
     7.361   143.915     0.200
     2.504    48.897     0.200
     3.643    71.298     0.200
     3.958    78.229     0.200
     4.036    78.615     0.200
     5.151   100.806     0.200
     5.993   116.972     0.200
     6.381   124.047     0.200
     6.379   124.570     0.200
     6.612   129.747     0.200
     7.169   140.647     0.200
     7.344   143.506     0.200
     2.531    49.494     0.200
     3.323    65.551     0.200
     3.644    71.403     0.200
     3.949    77.647     0.200
     4.039    79.089     0.200
     4.585    89.521     0.200
     5.136   100.695     0.200
     5.979   116.854     0.200
     6.365   123.955     0.200
     6.371   124.179     0.200
     6.455   125.999     0.200
     6.597   128.841     0.200
     7.131   139.414     0.200
     7.312   143.103     0.200
     2.500    48.802     0.200
     3.304    65.222     0.200
     3.627    71.057     0.200
     3.939    77.915     0.200
     4.053    78.880     0.200
     4.568    89.274     0.200
     4.911    96.573     0.200
     5.131   100.597     0.200
     5.974   116.966     0.200
     6.362   124.135     0.200
     6.593   128.742     0.200
     7.325   142.395     0.200
     2.552    50.005     0.200
     3.324    64.500     0.200
     3.643    71.776     0.200
     3.940    77.717     0.200
     3.940    79.217     0.200
     4.045    79.988     0.200
     4.584    89.792     0.200
     4.871    95.847     0.200
     5.122   100.423     0.200
     5.965   116.177     0.200
     6.350   122.683     0.200
     6.361   123.163     0.200
     6.443   125.101     0.200
     7.283   142.399     0.200
     3.346    64.974     0.200
     3.663    72.278     0.200
     3.949    77.937     0.200
     4.031    80.183     0.200
     4.851    96.315     0.200
     5.124   100.425     0.200
     6.353   123.486     0.200
     6.369   124.506     0.200
     6.449   125.767     0.200
     7.261   143.692     0.200
     2.529    49.552     0.200
     3.657    71.977     0.200
     3.966    78.973     0.200
     4.024    79.501     0.200
     5.155   101.597     0.200
     6.384   125.558     0.200
     6.389   124.600     0.200
     6.474   126.311     0.200
     6.617   129.342     0.200
     7.334   144.173     0.200
     2.526    49.090     0.200
     3.662    71.635     0.200
     3.973    78.307     0.200
     4.019    77.670     0.200
     4.603    90.656     0.200
     4.931    97.428     0.200
     5.163   101.617     0.200
     6.392   125.680     0.200
     6.396   124.730     0.200
     6.481   126.640     0.200
     6.624   129.260     0.200
     7.155   139.771     0.200
     7.344   143.468     0.200
     2.529    49.435     0.200
     3.652    72.035     0.200
     3.959    78.643     0.200
     4.031    79.807     0.200
     4.592    90.351     0.200
     4.912    96.323     0.200
     5.147   101.478     0.200
     6.376   125.342     0.200
     6.381   124.778     0.200
     6.466   126.292     0.200
     6.609   129.923     0.200
     6.856   138.013     0.200
     7.141   140.610     0.200
     7.325   143.164     0.200
     8.430   159.286     0.200
    10.934   213.462     0.200
     3.306    65.224     0.200
     3.629    71.257     0.200
     3.943    77.594     0.200
     4.050    77.541     0.200
     4.050    77.643     0.200
     4.570    89.677     0.200
     4.918    95.815     0.200
     5.136   100.170     0.200
     5.979   116.337     0.200
     6.367   124.108     0.200
     6.882   135.493     0.200
    10.933   216.483     0.200
     2.545    49.284     0.200
     3.329    66.432     0.200
     3.649    71.297     0.200
     3.950    78.684     0.200
     4.036    77.477     0.200
     5.134   100.964     0.200
     7.302   142.071     0.200
     2.520    48.662     0.200
     3.636    71.542     0.200
     3.942    78.666     0.200
     4.047    79.341     0.200
     4.576    89.764     0.200
     4.899    97.099     0.200
     5.131   100.194     0.200
     5.974   117.957     0.200
     6.359   125.254     0.200
     6.365   124.895     0.200
     7.313   143.831     0.200
     2.511    48.695     0.200
     2.511    48.297     0.200
     3.315    65.504     0.200
     3.638    71.647     0.200
     3.638    70.842     0.200
     3.949    77.718     0.200
     3.949    77.116     0.200
     4.043    79.119     0.200
     4.579    90.363     0.200
     4.913    97.159     0.200
     5.139   100.626     0.200
     5.982   117.586     0.200
     6.368   124.287     0.200
     6.372   124.542     0.200
     6.601   129.662     0.200
     6.869   136.511     0.200
     7.154   140.711     0.200
     7.180   140.313     0.200
     7.327   143.090     0.200
     7.360   143.807     0.200
     7.469   145.235     0.200
     7.675   150.434     0.200
     7.727   149.829     0.200
     7.797   152.312     0.200
     7.849   154.000     0.200
     8.348   163.078     0.200
     8.432   159.794     0.200
     8.741   170.392     0.200
     8.817   171.705     0.200
     8.991   175.173     0.200
     9.453   184.085     0.200
    11.076   216.531     0.200
    15.147   295.808     0.200
    18.681   367.245     0.200
     2.527    49.086     0.200
     3.322    64.917     0.200
     3.643    71.963     0.200
     3.949    78.597     0.200
     4.040    78.830     0.200
     4.584    90.482     0.200
     4.901    96.675     0.200
     5.137   101.135     0.200
     6.365   123.897     0.200
     6.371   124.226     0.200
     6.598   128.182     0.200
     7.315   144.420     0.200
     2.519    49.051     0.200
     3.310    64.812     0.200
     3.632    71.062     0.200
     3.938    77.386     0.200
     4.051    78.967     0.200
     4.573    90.182     0.200
     5.126   100.518     0.200
     5.970   116.280     0.200
     6.355   124.382     0.200
     6.361   123.819     0.200
     6.588   128.666     0.200
     7.137   139.659     0.200
     7.309   142.852     0.200
     2.520    48.987     0.200
     3.320    65.553     0.200
     3.642    71.495     0.200
     3.950    78.299     0.200
     3.950    77.399     0.200
     4.040    79.151     0.200
     4.583    90.316     0.200
     4.908    97.615     0.200
     5.139   100.722     0.200
     5.982   118.083     0.200
     6.368   124.582     0.200
     6.373   124.125     0.200
     6.860   134.121     0.200
     7.144   140.022     0.200
     7.322   143.651     0.200
    10.928   214.343     0.200
     2.517    48.959     0.200
     3.631    71.355     0.200
     3.938    77.674     0.200
     4.051    79.855     0.200
     4.572    89.974     0.200
     4.897    96.486     0.200
     5.127   100.202     0.200
     5.970   116.763     0.200
     6.356   124.863     0.200
     6.361   124.303     0.200
     6.588   128.946     0.200
     7.139   140.620     0.200
     7.311   142.817     0.200
     2.520    48.945     0.200
     3.317    65.848     0.200
     3.639    71.295     0.200
     3.946    78.109     0.200
     4.043    78.173     0.200
     4.580    89.914     0.200
     5.135   100.836     0.200
     5.978   116.497     0.200
     6.364   123.696     0.200
     6.369   124.235     0.200
     6.596   128.579     0.200
     7.317   142.570     0.200
     2.519    49.176     0.200
     3.341    65.089     0.200
     3.665    71.812     0.200
     3.979    78.949     0.200
     4.014    78.130     0.200
     4.605    90.034     0.200
     5.170   102.137     0.200
     6.013   118.403     0.200
     6.399   124.701     0.200
     6.632   130.079     0.200
     7.356   145.436     0.200
     2.514    49.355     0.200
     3.306    64.602     0.200
     3.628    71.748     0.200
     3.935    76.865     0.200
     4.054    79.076     0.200
     4.569    89.173     0.200
     4.896    97.355     0.200
     5.124   101.284     0.200
     6.586   128.728     0.200
     7.141   139.853     0.200
     7.310   143.879     0.200
     2.519    49.356     0.200
     3.320    64.315     0.200
     3.642    71.658     0.200
     3.950    78.358     0.200
     3.950    76.658     0.200
     4.040    79.813     0.200
     4.583    90.478     0.200
     4.909    96.468     0.200
     5.140   101.679     0.200
     5.140    99.078     0.200
     5.983   117.640     0.200
     6.368   124.139     0.200
     6.373   125.184     0.200
     6.601   129.823     0.200
     7.145   141.072     0.200
     7.323   142.802     0.200
    10.929   216.142     0.200
    11.068   216.786     0.200
     2.519    49.267     0.200
     3.635    71.545     0.200
     3.942    78.263     0.200
     4.048    79.929     0.200
     4.576    89.564     0.200
     4.900    96.986     0.200
     5.130   100.791     0.200
     5.974   116.652     0.200
     6.359   124.651     0.200
     6.364   123.791     0.200
     6.592   128.635     0.200
     7.139   140.347     0.200
     7.313   142.719     0.200
     2.523    49.520     0.200
     3.631    70.891     0.200
     3.936    77.438     0.200
     4.053    79.773     0.200
     4.572    89.608     0.200
     5.123   100.082     0.200
     7.303   143.047     0.200
     2.519    48.947     0.200
     3.314    64.568     0.200
     3.636    71.912     0.200
     3.943    78.229     0.200
     4.047    78.318     0.200
     4.577    89.431     0.200
     4.901    96.945     0.200
     5.132   101.254     0.200
     5.975   117.517     0.200
     6.360   124.114     0.200
     6.365   124.855     0.200
     7.315   144.180     0.200
     2.500    48.526     0.200
     3.628    71.159     0.200
     3.941    77.612     0.200
     4.052    79.114     0.200
     4.569    89.280     0.200
     4.913    96.864     0.200
     5.133   100.499     0.200
     5.976   116.764     0.200
     6.364   123.930     0.200
     6.361   124.059     0.200
     6.595   128.539     0.200
     7.161   140.127     0.200
     7.328   143.285     0.200
     2.501    48.554     0.200
     3.303    65.688     0.200
     3.626    71.122     0.200
     3.938    78.286     0.200
     4.054    79.025     0.200
     4.567    89.443     0.200
     4.909    97.753     0.200
     5.129   101.478     0.200
     5.129   100.478     0.200
     5.972   118.043     0.200
     6.358   123.938     0.200
     6.361   124.106     0.200
     6.873   136.031     0.200
     7.170   139.566     0.200
     7.158   139.608     0.200
     7.323   142.175     0.200
     7.351   144.256     0.200
     7.459   144.795     0.200
     7.717   150.381     0.200
     7.840   154.545     0.200
     8.439   157.875     0.200
     8.731   170.951     0.200
     8.981   175.529     0.200
     9.442   183.046     0.200
     9.943   193.707     0.200
    10.417   203.177     0.200
    10.649   208.260     0.200
    10.831   210.642     0.200
    11.038   214.529     0.200
    11.087   218.246     0.200
    15.156   297.994     0.200
    18.673   364.651     0.200
    18.600   364.750     0.200
     3.306    64.829     0.200
     3.630    70.854     0.200
     3.945    77.675     0.200
     4.049    77.567     0.200
     4.571    89.576     0.200
     4.923    96.261     0.200
     5.139   101.143     0.200
     5.982   117.509     0.200
     6.369   123.990     0.200
     7.172   139.318     0.200
     7.338   142.480     0.200
     2.509    48.762     0.200
     3.328    65.999     0.200
     3.652    71.721     0.200
     3.966    78.352     0.200
     4.027    77.740     0.200
     4.592    89.846     0.200
     4.936    97.829     0.200
     5.159   101.627     0.200
     6.002   116.597     0.200
     6.388   124.593     0.200
     6.390   125.265     0.200
     6.621   129.872     0.200
     7.350   143.260     0.200
     2.599    49.825     0.200
     2.599    49.626     0.200
     2.698    53.163     0.200
     3.630    69.886     0.200
     3.630    69.988     0.200
     3.697    73.308     0.200
     3.697    73.007     0.200
     4.039    79.315     0.200
     4.039    78.116     0.200
     4.421    86.161     0.200
     4.421    85.262     0.200
     4.974    97.411     0.200
     5.436   107.119     0.200
     5.643   111.202     0.200
     5.911   117.477     0.200
     6.850   134.119     0.200
     7.194   142.250     0.200
     7.482   146.544     0.200
     7.843   153.024     0.200
     7.876   155.446     0.200
     7.958   155.682     0.200
     8.232   161.983     0.200
     8.363   164.154     0.200
    11.008   211.606     0.200
    18.072   351.981     0.200
    18.562   364.801     0.200
    19.141   378.593     0.200
     2.514    49.284     0.200
     3.317    65.411     0.200
     3.639    71.352     0.200
     3.949    78.133     0.200
     4.042    79.051     0.200
     4.580    89.474     0.200
     4.912    97.197     0.200
     5.139   100.741     0.200
     5.982   117.107     0.200
     6.368   124.605     0.200
     6.372   124.856     0.200
     7.151   140.568     0.200
     7.326   143.621     0.200
     3.497    69.271     0.200
     3.831    74.477     0.200
     3.836    74.217     0.200
     4.209    82.471     0.200
     4.772    93.492     0.200
     5.256   104.148     0.200
     5.430   106.312     0.200
     6.637   129.330     0.200
     7.131   141.637     0.200
     7.418   145.721     0.200
     7.670   149.278     0.200
     7.745   150.296     0.200
     8.152   159.851     0.200
     2.530    49.279     0.200
     3.361    66.579     0.200
     3.685    71.797     0.200
     3.993    76.606     0.200
     4.000    78.917     0.200
     4.626    90.024     0.200
     4.960    97.918     0.200
     5.192   102.007     0.200
     6.035   117.171     0.200
     6.421   125.770     0.200
     6.654   130.551     0.200
     7.172   139.813     0.200
     2.554    49.940     0.200
     3.373    67.181     0.200
     3.696    72.617     0.200
     3.985    77.835     0.200
     4.004    79.014     0.200
     4.637    91.037     0.200
     6.861   136.124     0.200
     8.391   157.418     0.200
    11.030   217.489     0.200
    10.974   212.897     0.200
     2.595    49.979     0.200
     2.689    53.483     0.200
     2.872    56.949     0.200
     3.639    70.799     0.200
     3.689    72.419     0.200
     4.030    78.332     0.200
     4.411    87.187     0.200
     4.965    96.625     0.200
     5.425   107.252     0.200
     5.632   110.636     0.200
     5.914   115.745     0.200
     6.472   125.735     0.200
     6.840   133.947     0.200
     6.935   134.728     0.200
     7.096   138.359     0.200
     2.509    50.324     0.200
     2.576    50.139     0.200
     3.415    67.146     0.200
     3.739    73.170     0.200
     3.941    77.918     0.200
     4.050    79.940     0.200
     4.680    91.991     0.200
     5.238   103.079     0.200
     6.467   127.038     0.200
     6.473   125.566     0.200
     6.699   130.525     0.200
     7.157   140.187     0.200
     2.518    48.915     0.200
     3.344    65.976     0.200
     3.668    72.095     0.200
     3.983    78.716     0.200
     4.010    78.003     0.200
     4.609    90.119     0.200
     4.949    97.044     0.200
     5.176   101.898     0.200
     6.019   117.863     0.200
     6.405   125.360     0.200
     6.407   125.533     0.200
     6.638   129.439     0.200
     6.887   137.725     0.200
     7.172   140.799     0.200
     7.216   140.586     0.200
     7.363   144.681     0.200
     7.397   144.678     0.200
     7.505   147.018     0.200
     7.764   151.201     0.200
     7.833   153.489     0.200
     7.886   154.066     0.200
     8.384   163.556     0.200
     8.777   170.572     0.200
     8.853   172.889     0.200
     9.489   183.687     0.200
    10.969   215.353     0.200
    11.066   216.552     0.200
    18.554   363.955     0.200
    18.676   368.275     0.200
    18.850   372.662     0.200
     2.520    48.768     0.200
     3.336    66.247     0.200
     3.659    71.374     0.200
     3.972    78.428     0.200
     4.020    78.263     0.200
     4.600    90.497     0.200
     4.934    96.802     0.200
     5.163   101.328     0.200
     6.006   117.691     0.200
     6.391   124.791     0.200
     6.395   124.849     0.200
     6.624   128.572     0.200
     6.876   137.287     0.200
     7.161   139.614     0.200
     7.203   140.515     0.200
     7.347   142.737     0.200
     7.383   144.315     0.200
     7.492   146.341     0.200
     7.750   151.434     0.200
     7.820   152.717     0.200
     7.873   154.102     0.200
     8.218   159.879     0.200
     8.372   161.882     0.200
     8.764   169.997     0.200
     8.841   172.308     0.200
     9.476   184.335     0.200
    10.954   215.528     0.200
    18.568   360.766     0.200
    18.683   368.598     0.200
     2.520    49.080     0.200
     3.324    66.097     0.200
     3.646    71.336     0.200
     3.956    78.427     0.200
     4.035    78.907     0.200
     4.587    89.856     0.200
     5.145   101.344     0.200
     7.328   144.569     0.200
     2.792    53.123     0.200
     2.755    54.455     0.200
     2.884    56.750     0.200
     3.572    67.923     0.200
     4.100    80.064     0.200
     4.425    87.262     0.200
     5.039    98.801     0.200
     5.289   104.083     0.200
     5.611   109.422     0.200
     5.729   112.345     0.200
     6.848   132.787     0.200
     6.933   135.902     0.200
     7.237   141.756     0.200
     2.505    48.838     0.200
     3.332    65.990     0.200
     3.656    71.605     0.200
     4.021    78.743     0.200
     3.973    78.703     0.200
     3.973    78.403     0.200
     4.947    96.735     0.200
     6.895   133.982     0.200
    10.964   216.172     0.200
     3.311    65.281     0.200
     3.635    70.692     0.200
     3.955    77.667     0.200
     4.576    89.518     0.200
     5.151   100.010     0.200
     6.102   119.101     0.200
     6.903   136.091     0.200
     9.462   181.845     0.200
    11.099   215.962     0.200
    10.952   214.103     0.200
     2.507    48.965     0.200
     3.303    65.081     0.200
     3.625    71.723     0.200
     3.934    78.118     0.200
     4.565    89.143     0.200
     4.899    96.752     0.200
     5.124   101.430     0.200
     5.967   115.991     0.200
     6.095   119.899     0.200
     6.356   124.243     0.200
     2.596    49.959     0.200
     2.687    53.703     0.200
     3.686    72.435     0.200
     3.930    75.936     0.200
     4.028    79.050     0.200
     4.407    86.723     0.200
     4.962    97.143     0.200
     5.628   110.272     0.200
     5.914   115.747     0.200
     6.468   126.276     0.200
     6.836   133.381     0.200
     6.856   134.050     0.200
     6.931   135.665     0.200
     2.600    50.182     0.200
     2.689    53.041     0.200
     2.870    57.031     0.200
     3.689    71.872     0.200
     4.030    78.688     0.200
     4.409    86.369     0.200
     4.965    97.678     0.200
     5.419   106.979     0.200
     5.630   110.627     0.200
     5.910   115.454     0.200
     6.470   125.524     0.200
     6.838   132.625     0.200
     6.857   133.502     0.200
     6.933   135.211     0.200
     7.467   146.379     0.200
     2.509    48.400     0.200
     2.509    49.400     0.200
     3.319    65.957     0.200
     3.642    70.888     0.200
     3.954    78.647     0.200
     3.954    78.047     0.200
     4.361    85.244     0.200
     4.582    90.109     0.200
     4.921    97.960     0.200
     5.145   100.540     0.200
     5.988   117.405     0.200
     6.374   125.201     0.200
     6.377   124.268     0.200
     6.462   126.668     0.200
     6.875   136.182     0.200
     7.160   139.233     0.200
     7.186   139.428     0.200
     7.335   142.589     0.200
     8.425   160.610     0.200
     9.458   182.226     0.200
    11.077   219.958     0.200
     2.723    54.239     0.200
     3.188    63.115     0.200
     3.535    69.163     0.200
     3.938    77.968     0.200
     3.958    77.333     0.200
     4.466    87.098     0.200
     7.312   144.644     0.200
     8.399   163.400     0.200
     8.788   169.860     0.200
     8.839   171.870     0.200
     9.034   174.497     0.200
     9.486   183.187     0.200
     9.486   183.718     0.200
     9.958   193.413     0.200
    10.499   205.099     0.200
    10.834   210.388     0.200
    10.870   212.069     0.200
    10.995   213.606     0.200
    11.132   218.728     0.200
    11.443   224.502     0.200
    15.561   303.779     0.200
    18.245   358.998     0.200
    18.483   360.129     0.200
    18.625   370.125     0.200
    20.521   411.341     0.200
    22.724   456.301     0.200
    23.625   473.775     0.200
     2.718    54.597     0.200
     2.718    54.396     0.200
     3.174    63.067     0.200
     3.521    69.724     0.200
     3.941    78.222     0.200
     4.453    87.353     0.200
     5.186   101.898     0.200
     5.197   102.262     0.200
     6.030   117.239     0.200
     6.370   125.272     0.200
     6.420   124.289     0.200
     6.477   125.622     0.200
     6.660   129.390     0.200
     7.614   149.157     0.200
     8.254   156.512     0.200
     2.720    54.866     0.200
     3.188    63.206     0.200
     3.535    69.656     0.200
     3.956    78.138     0.200
     4.466    87.689     0.200
     5.213   102.472     0.200
     5.200   103.218     0.200
     6.046   118.651     0.200
     6.386   124.087     0.200
     6.436   126.500     0.200
     6.493   126.335     0.200
     6.676   129.900     0.200
     7.629   150.181     0.200
     2.724    54.506     0.200
     2.724    53.904     0.200
     3.176    63.237     0.200
     3.522    69.086     0.200
     3.936    77.216     0.200
     3.944    77.466     0.200
     4.454    87.019     0.200
     5.192   102.801     0.200
     7.307   145.644     0.200
     7.455   146.691     0.200
     7.591   148.203     0.200
     7.621   149.359     0.200
     7.790   152.481     0.200
     7.938   154.661     0.200
     8.386   163.733     0.200
     8.775   170.393     0.200
     8.825   172.503     0.200
     9.020   174.630     0.200
     9.472   182.894     0.200
     9.472   183.951     0.200
     9.944   192.946     0.200
    10.485   202.934     0.200
    10.821   209.818     0.200
    10.857   212.593     0.200
    10.982   213.334     0.200
    11.119   219.413     0.200
    18.244   362.457     0.200
     2.701    53.841     0.200
     3.178    62.588     0.200
     3.523    69.156     0.200
     3.939    77.305     0.200
     4.455    87.278     0.200
     5.174   103.092     0.200
     5.193   101.866     0.200
     6.027   117.841     0.200
     6.369   124.148     0.200
     6.384   125.862     0.200
     7.602   149.060     0.200
     2.726    53.699     0.200
     3.173    62.482     0.200
     3.520    69.238     0.200
     3.934    76.328     0.200
     3.942    77.314     0.200
     4.451    87.065     0.200
     6.371   124.058     0.200
     6.422   126.066     0.200
     6.478   126.804     0.200
     6.662   130.069     0.200
     7.308   143.825     0.200
     7.453   145.032     0.200
     7.490   145.696     0.200
     7.739   150.595     0.200
     7.936   155.205     0.200
     8.772   170.838     0.200
    11.117   220.166     0.200
    11.451   226.699     0.200
    15.566   308.693     0.200
    18.243   357.069     0.200
    18.611   368.595     0.200
     2.706    53.745     0.200
     3.172    63.203     0.200
     3.518    69.867     0.200
     3.935    77.906     0.200
     3.952    77.303     0.200
     4.156    80.620     0.200
     4.450    86.891     0.200
     5.173   101.257     0.200
     5.189   102.065     0.200
     6.023   117.138     0.200
     6.364   124.954     0.200
     6.413   125.390     0.200
     6.471   125.513     0.200
     6.652   130.392     0.200
     7.286   144.269     0.200
     7.601   148.719     0.200
    11.103   221.213     0.200
     2.607    50.112     0.200
     2.709    53.520     0.200
     2.893    57.276     0.200
     3.620    70.690     0.200
     3.708    72.465     0.200
     4.050    79.571     0.200
     4.432    87.616     0.200
     4.984    97.767     0.200
     5.653   110.661     0.200
     5.902   116.453     0.200
     6.493   127.660     0.200
     6.860   133.274     0.200
     6.881   134.438     0.200
     6.956   135.956     0.200
     7.116   138.486     0.200
     7.851   154.816     0.200
     2.522    49.091     0.200
     3.309    64.812     0.200
     3.630    71.566     0.200
     3.935    77.511     0.200
     4.054    78.922     0.200
     4.571    89.178     0.200
     4.889    96.274     0.200
     5.122   100.051     0.200
     5.965   116.711     0.200
     6.083   120.035     0.200
     6.351   123.110     0.200
     6.357   124.242     0.200
     6.441   125.354     0.200
     6.584   129.098     0.200
     7.131   139.615     0.200
     7.163   139.736     0.200
     2.501    48.432     0.200
     3.306    65.237     0.200
     3.629    70.873     0.200
     3.941    77.729     0.200
     4.051    79.139     0.200
     4.355    85.238     0.200
     5.133   101.216     0.200
     5.976   117.682     0.200
     6.096   119.170     0.200
     6.362   124.577     0.200
     6.364   124.347     0.200
     6.450   126.048     0.200
     6.595   128.857     0.200
     7.160   140.162     0.200
     7.173   140.205     0.200
     7.327   142.811     0.200
     7.354   144.095     0.200
     7.462   145.735     0.200
     7.669   149.925     0.200
     7.844   153.282     0.200
    10.928   213.169     0.200
    11.087   217.807     0.200
     3.264    64.940     0.200
     3.585    70.788     0.200
     3.894    76.086     0.200
     4.097    79.314     0.200
     4.347    84.746     0.200
     4.526    88.407     0.200
     4.872    96.472     0.200
     5.085    99.781     0.200
     5.928   116.146     0.200
     6.314   123.643     0.200
     6.317   122.908     0.200
     6.402   125.112     0.200
     7.288   141.478     0.200
     8.480   161.383     0.200
     9.398   182.017     0.200
    10.883   216.543     0.200
    15.169   302.850     0.200
     2.563    51.125     0.200
     3.034    59.631     0.200
     3.343    65.826     0.200
     3.612    71.282     0.200
     4.284    84.236     0.200
     4.366    85.784     0.200
     4.368    83.815     0.200
     4.591    91.360     0.200
     6.732   132.122     0.200
    11.205   219.015     0.200
     2.532    48.854     0.200
     2.559    50.345     0.200
     2.731    53.836     0.200
     3.563    69.325     0.200
     3.765    72.063     0.200
     3.901    76.576     0.200
     4.271    83.866     0.200
     4.838    94.750     0.200
     5.292   104.244     0.200
     3.543    69.724     0.200
     3.872    76.484     0.200
     4.131    79.362     0.200
     4.483    88.350     0.200
     4.908    96.091     0.200
     5.077    99.126     0.200
     6.940   137.299     0.200
     9.383   184.439     0.200
     3.308    65.970     0.200
     3.308    65.370     0.200
     3.635    71.150     0.200
     3.635    71.550     0.200
     3.966    78.592     0.200
     4.037    79.362     0.200
     4.297    83.983     0.200
     4.575    90.182     0.200
     4.977    98.899     0.200
     5.169   101.855     0.200
     6.011   117.934     0.200
     6.122   121.129     0.200
     6.392   123.987     0.200
     6.397   124.722     0.200
     6.481   127.048     0.200
     6.631   129.189     0.200
     6.948   137.566     0.200
     8.380   157.929     0.200
     9.476   185.637     0.200
    10.982   216.893     0.200
    18.611   366.758     0.200
     2.727    53.069     0.200
     3.131    62.062     0.200
     3.131    62.363     0.200
     3.477    67.121     0.200
     3.477    67.922     0.200
     3.928    76.526     0.200
     3.896    76.231     0.200
     4.198    81.002     0.200
     4.409    86.649     0.200
     5.153   100.465     0.200
     5.151   100.780     0.200
     5.986   117.342     0.200
     6.325   123.584     0.200
     6.376   124.292     0.200
     6.432   125.231     0.200
     7.183   140.673     0.200
     7.292   145.546     0.200
     7.407   144.159     0.200
     7.444   144.920     0.200
     7.581   147.527     0.200
     7.742   151.649     0.200
     7.889   154.328     0.200
     8.295   154.034     0.200
     8.337   161.303     0.200
     8.726   168.860     0.200
     8.777   170.069     0.200
     8.972   174.200     0.200
     9.424   180.185     0.200
     9.424   183.517     0.200
     9.896   191.809     0.200
    10.437   201.400     0.200
    10.773   207.579     0.200
    10.935   210.080     0.200
    11.073   219.895     0.200
    11.469   227.102     0.200
     2.964    58.001     0.200
     3.392    67.199     0.200
     3.392    67.098     0.200
     3.420    65.673     0.200
     3.475    68.134     0.200
     3.475    67.536     0.200
     4.413    86.084     0.200
     4.735    92.223     0.200
     5.010    97.922     0.200
     5.583   109.229     0.200
     6.144   119.981     0.200
     6.767   137.037     0.200
     6.991   136.995     0.200
     7.653   151.281     0.200
     7.714   144.105     0.200
     7.926   154.487     0.200
    10.201   199.960     0.200
    10.480   203.074     0.200
    11.740   229.836     0.200
     3.306    65.880     0.200
     3.628    71.022     0.200
     3.937    77.921     0.200
     4.053    78.763     0.200
     4.569    89.745     0.200
     4.900    96.976     0.200
     5.127   100.034     0.200
     2.680    54.068     0.200
     3.180    63.336     0.200
     3.524    68.816     0.200
     3.978    77.847     0.200
     4.148    80.536     0.200
     4.457    87.531     0.200
     5.156   102.275     0.200
     5.185   101.933     0.200
     6.019   118.198     0.200
     6.364   124.878     0.200
     6.371   125.399     0.200
    11.092   221.286     0.200
    18.288   360.895     0.200
    18.513   359.043     0.200
     3.119    61.753     0.200
     3.437    67.239     0.200
     3.737    73.535     0.200
     4.251    82.235     0.200
     4.378    85.855     0.200
     4.748    93.136     0.200
     4.929    96.226     0.200
     5.772   113.191     0.200
     6.160   120.057     0.200
     6.158   120.584     0.200
     6.245   121.663     0.200
     6.391   124.961     0.200
     3.126    62.885     0.200
     3.444    68.379     0.200
     4.244    82.840     0.200
     4.385    86.893     0.200
     4.748    95.162     0.200
     4.934    97.293     0.200
     5.776   114.358     0.200
     3.119    62.969     0.200
     3.437    67.655     0.200
     4.307    83.782     0.200
     4.250    82.169     0.200
     4.378    85.572     0.200
     4.751    93.316     0.200
     4.931    97.917     0.200
     5.774   113.488     0.200
     8.619   162.414     0.200
    10.743   213.435     0.200
    11.201   220.588     0.200
     3.420    67.461     0.200
     3.720    72.868     0.200
     4.307    82.739     0.200
     6.833   134.794     0.200
     8.638   162.293     0.200
    10.724   207.869     0.200
    11.209   220.602     0.200
     3.421    68.145     0.200
     3.721    72.649     0.200
     4.307    85.260     0.200
     6.834   137.072     0.200
     7.156   138.761     0.200
     8.637   163.156     0.200
     8.589   166.038     0.200
     3.434    68.074     0.200
     3.730    74.216     0.200
     4.322    84.428     0.200
     6.822   134.517     0.200
     7.632   147.791     0.200
     8.598   169.115     0.200
    10.727   211.588     0.200
    11.192   217.437     0.200
     4.299    83.540     0.200
     4.741    93.008     0.200
     6.145   121.828     0.200
     6.842   137.247     0.200
     7.163   140.947     0.200
     8.590   167.586     0.200
     9.226   177.032     0.200
    10.729   211.560     0.200
    11.214   219.291     0.200
    15.240   298.137     0.200
    16.249   315.302     0.200
    18.001   348.185     0.200
    18.625   367.809     0.200
    18.621   368.436     0.200
    18.810   369.164     0.200
    23.490   471.132     0.200
     3.128    62.732     0.200
     3.446    67.817     0.200
     4.308    83.952     0.200
     4.387    85.931     0.200
     4.761    93.776     0.200
     4.942    98.765     0.200
     6.172   122.207     0.200
     6.844   136.922     0.200
     7.181   141.127     0.200
     7.270   141.395     0.200
     8.542   168.547     0.200
     8.608   160.858     0.200
     8.618   168.265     0.200
     9.253   179.009     0.200
    10.229   200.660     0.200
    10.753   212.144     0.200
    10.851   213.103     0.200
    11.196   218.852     0.200
    15.227   297.873     0.200
    16.235   314.855     0.200
    17.974   347.859     0.200
    18.633   367.086     0.200
    18.646   370.521     0.200
    18.784   367.857     0.200
    20.091   403.810     0.200
    23.517   471.746     0.200
     3.452    68.531     0.200
     3.753    74.714     0.200
     4.314    83.855     0.200
     4.760    92.964     0.200
     6.176   120.741     0.200
     6.838   135.035     0.200
     8.607   161.933     0.200
     8.622   169.701     0.200
     9.257   180.499     0.200
    10.754   211.552     0.200
    11.189   221.354     0.200
     3.443    67.678     0.200
     4.336    86.417     0.200
     4.728    93.474     0.200
     6.809   134.393     0.200
     8.636   162.034     0.200
     8.602   168.263     0.200
     9.237   182.122     0.200
    10.725   211.695     0.200
    11.178   220.793     0.200
    15.202   298.567     0.200
    18.662   369.565     0.200
     2.951    57.112     0.200
     3.676    72.245     0.200
     8.086   158.059     0.200
    10.358   201.066     0.200
    14.589   282.809     0.200
    16.250   314.608     0.200
    16.935   327.665     0.200
    17.593   347.637     0.200
    18.231   360.439     0.200
    19.796   391.160     0.200
    24.157   479.522     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.503    10.008     0.200
     0.557    11.426     0.200
     2.287    45.135     0.200
     2.287    46.338     0.200
     0.483    10.549     0.200
     0.914    18.016     0.200
     2.088    41.316     0.200
     2.129    42.835     0.200
     2.209    43.897     0.200
     2.335    46.229     0.200
     2.341    47.757     0.200
     2.395    48.939     0.200
     2.444    49.653     0.200
     0.712    14.862     0.200
     1.383    28.025     0.200
     2.345    47.296     0.200
     8.142   153.356     0.200
     0.535    11.317     0.200
     0.669    14.751     0.200
     1.380    27.259     0.200
     2.197    44.327     0.200
     2.337    47.292     0.200
     2.869    51.586     0.200
     0.538    11.485     0.200
     0.596    12.113     0.200
     1.972    38.252     0.200
     2.179    42.037     0.200
     2.249    44.521     0.200
     0.387     9.386     0.200
     0.776    15.848     0.200
     1.040    20.763     0.200
     1.972    40.591     0.200
     2.233    44.048     0.200
     2.298    45.280     0.200
     2.430    46.837     0.200
     2.482    47.933     0.200
     1.953    36.298     0.200
     0.562    11.485     0.200
     1.130    23.664     0.200
     1.137    23.581     0.200
     1.929    37.642     0.200
     2.379    46.582     0.200
     1.276    24.784     0.200
     2.027    39.222     0.200
     2.465    45.508     0.200
     2.492    49.193     0.200
     0.324     7.541     0.200
     1.244    25.407     0.200
     1.245    25.395     0.200
     2.023    38.718     0.200
     2.447    46.367     0.200
     2.493    50.026     0.200
     1.251    24.357     0.200
     1.253    24.344     0.200
     2.451    46.259     0.200
     2.492    50.077     0.200
     0.318     6.418     0.200
     1.254    25.395     0.200
     2.014    39.419     0.200
     2.453    46.495     0.200
     2.490    50.062     0.200
     0.281     6.703     0.200
     1.284    25.097     0.200
     1.285    25.082     0.200
     2.466    46.501     0.200
     2.499    49.321     0.200
     1.251    24.965     0.200
     1.252    24.953     0.200
     2.015    38.157     0.200
     2.456    45.614     0.200
     2.486    49.761     0.200
     0.284     6.594     0.200
     1.268    24.706     0.200
     1.270    24.689     0.200
     2.002    38.349     0.200
     2.448    47.336     0.200
     0.310     6.564     0.200
     1.256    24.624     0.200
     1.258    24.610     0.200
     2.011    38.725     0.200
     2.453    46.659     0.200
     2.494    49.880     0.200
     5.576   103.621     0.200
     0.320     7.044     0.200
     1.247    25.518     0.200
     1.248    25.505     0.200
     2.020    39.002     0.200
     2.448    46.106     0.200
     2.494    49.065     0.200
     1.270    26.197     0.200
     1.271    26.185     0.200
     1.997    39.917     0.200
     2.468    47.916     0.200
     2.483    49.141     0.200
     0.309     6.866     0.200
     1.264    25.614     0.200
     1.265    25.601     0.200
     2.002    38.898     0.200
     2.461    46.742     0.200
     2.488    50.431     0.200
     0.613    12.675     0.200
     0.620    12.584     0.200
     1.209    24.720     0.200
     2.207    42.567     0.200
     5.329    92.028     0.200
     0.286     6.687     0.200
     1.279    25.494     0.200
     1.280    25.478     0.200
     1.990    38.195     0.200
     2.463    46.874     0.200
     2.499    49.254     0.200
     0.303     7.089     0.200
     0.853    18.668     0.200
     2.032    38.409     0.200
     2.422    46.256     0.200
     3.485    59.453     0.200
     5.309    92.467     0.200
     5.450    94.732     0.200
     8.039   141.304     0.200
     0.313     7.539     0.200
     2.040    38.181     0.200
     2.418    44.270     0.200
     0.319     7.028     0.200
     0.826    18.111     0.200
     1.271    25.724     0.200
     1.272    25.713     0.200
     1.994    38.981     0.200
     2.477    47.147     0.200
     2.469    50.939     0.200
     0.297     6.591     0.200
     1.314    26.223     0.200
     1.315    26.212     0.200
     1.952    37.983     0.200
     2.454    49.422     0.200
     1.367    27.461     0.200
     1.368    27.441     0.200
     1.909    37.034     0.200
     2.512    46.592     0.200
     6.777   112.123     0.200
     0.295     7.511     0.200
     0.856    18.759     0.200
     1.259    25.463     0.200
     2.012    38.768     0.200
     2.040    38.344     0.200
     2.442    46.653     0.200
     0.611    11.811     0.200
     0.611    12.811     0.200
     0.584    12.825     0.200
     1.337    26.532     0.200
     2.161    44.418     0.200
     2.699    50.841     0.200
     7.447   124.231     0.200
     0.266     5.315     0.200
     0.880    18.941     0.200
     1.327    26.721     0.200
     1.329    26.707     0.200
     2.475    49.330     0.200
     0.552    10.996     0.200
     0.561    10.898     0.200
     0.580    12.675     0.200
     1.256    25.787     0.200
     2.157    41.774     0.200
     0.708    14.839     0.200
     2.247    44.385     0.200
     2.300    45.264     0.200
     2.341    45.391     0.200
     2.449    49.524     0.200
     6.268   109.059     0.200
     2.866    53.240     0.200
     5.933   102.747     0.200
     0.510    10.089     0.200
     1.353    27.249     0.200
     1.352    27.263     0.200
     2.233    45.478     0.200
     2.665    50.643     0.200
     0.550    12.267     0.200
     0.758    14.839     0.200
     0.846    18.310     0.200
     2.153    44.356     0.200
     2.252    44.709     0.200
     2.223    44.248     0.200
     2.429    47.740     0.200
     0.664    13.441     0.200
     1.073    21.669     0.200
     1.075    21.645     0.200
     2.218    42.396     0.200
     2.372    47.509     0.200
     2.464    47.831     0.200
     2.341    46.863     0.200
     2.403    48.141     0.200
     0.764    16.504     0.200
     0.913    18.464     0.200
     0.915    18.436     0.200
     2.210    44.728     0.200
     2.251    43.249     0.200
     2.339    43.717     0.200
     2.439    49.049     0.200
     9.799   171.268     0.200
    10.684   182.434     0.200
     0.811    16.965     0.200
     0.859    16.996     0.200
     0.862    16.964     0.200
     2.194    41.117     0.200
     2.304    43.941     0.200
     2.467    47.832     0.200
     4.829    84.975     0.200
     7.253   129.575     0.200
     0.887    18.272     0.200
     2.124    42.543     0.200
     2.139    41.668     0.200
     2.333    44.404     0.200
     2.430    47.672     0.200
     2.351    45.265     0.200
     2.409    48.692     0.200
     0.991    19.711     0.200
     2.368    47.037     0.200
     2.353    47.407     0.200
     6.321   113.002     0.200
     9.901   169.327     0.200
     0.562    11.654     0.200
     2.155    43.864     0.200
     2.745    51.285     0.200
     0.385     7.624     0.200
     2.297    45.902     0.200
     2.838    53.587     0.200
     5.501    93.918     0.200
     0.578    11.916     0.200
     1.302    25.767     0.200
     2.210    45.475     0.200
     0.383     7.736     0.200
     2.304    45.319     0.200
     2.842    53.739     0.200
     2.842    53.438     0.200
     0.584    11.768     0.200
     1.275    25.208     0.200
     2.225    44.614     0.200
     0.551    11.810     0.200
     2.272    44.623     0.200
     2.415    47.952     0.200
     0.322     7.613     0.200
     0.492    10.010     0.200
     1.498    29.764     0.200
     1.497    28.775     0.200
     2.183    43.967     0.200
     2.183    42.967     0.200
     2.778    51.925     0.200
     0.790    16.876     0.200
     0.790    16.677     0.200
     2.380    46.623     0.200
     1.019    21.283     0.200
     2.539    45.048     0.200
     0.658    14.083     0.200
     0.902    18.627     0.200
     1.879    37.831     0.200
     2.102    40.128     0.200
     2.057    41.055     0.200
     0.695    14.701     0.200
     1.183    25.011     0.200
     2.171    44.578     0.200
     2.426    46.304     0.200
     2.526    47.838     0.200
     3.406    63.176     0.200
     5.931   111.403     0.200
     0.560    11.440     0.200
     1.212    25.429     0.200
     2.153    42.044     0.200
     2.153    41.844     0.200
     0.659    13.775     0.200
     0.901    18.753     0.200
     2.058    40.250     0.200
     2.102    39.628     0.200
     2.102    40.328     0.200
     0.267     6.754     0.200
     0.267     7.950     0.200
     2.749    50.784     0.200
     0.727    15.285     0.200
     1.004    20.853     0.200
     2.000    39.631     0.200
     2.255    43.154     0.200
     0.694    14.816     0.200
     1.256    25.456     0.200
     1.256    25.261     0.200
     2.956    52.829     0.200
     0.719    14.998     0.200
     1.117    22.758     0.200
     1.117    22.360     0.200
     2.259    43.830     0.200
     2.302    45.828     0.200
     2.406    47.610     0.200
     2.406    47.915     0.200
     3.645    68.358     0.200
     0.340     7.947     0.200
     2.335    46.063     0.200
     4.140    73.799     0.200
     4.280    79.254     0.200
     6.757   123.449     0.200
     0.360     8.020     0.200
     0.360     7.821     0.200
     1.642    32.163     0.200
     2.313    46.629     0.200
     2.313    45.629     0.200
     2.806    53.170     0.200
     3.350    62.628     0.200
     4.146    76.233     0.200
     6.761   124.120     0.200
     0.933    19.146     0.200
     0.933    18.944     0.200
     2.396    45.380     0.200
     3.345    62.599     0.200
     3.356    61.573     0.200
     4.639    86.098     0.200
     5.966   109.917     0.200
     6.942   128.820     0.200
     0.671    14.386     0.200
     0.871    17.847     0.200
     0.871    17.247     0.200
     2.108    42.616     0.200
     2.209    43.335     0.200
     2.209    41.835     0.200
     2.292    44.964     0.200
     2.292    44.864     0.200
     0.226     5.176     0.200
     0.226     5.074     0.200
     1.350    27.056     0.200
     1.350    27.455     0.200
     2.505    46.285     0.200
     2.499    49.146     0.200
     2.499    49.545     0.200
     0.318     7.206     0.200
     0.318     7.007     0.200
     1.254    26.084     0.200
     2.454    46.777     0.200
     2.454    46.077     0.200
     2.499    49.459     0.200
     0.304     6.871     0.200
     1.256    25.760     0.200
     1.256    25.459     0.200
     2.445    47.175     0.200
     2.445    45.878     0.200
     2.505    49.882     0.200
     2.505    49.280     0.200
     0.303     6.659     0.200
     0.303     6.459     0.200
     1.261    25.568     0.200
     2.452    46.674     0.200
     2.452    46.076     0.200
     2.499    49.825     0.200
     2.499    49.325     0.200
     0.513    11.085     0.200
     1.159    23.148     0.200
     1.159    23.648     0.200
     2.385    47.145     0.200
     2.384    47.154     0.200
     2.384    48.054     0.200
     2.473    48.016     0.200
     2.473    47.616     0.200
     0.320     6.845     0.200
     1.259    25.187     0.200
     2.462    46.445     0.200
     2.481    49.827     0.200
     0.343     7.449     0.200
     1.236    24.930     0.200
     1.236    24.630     0.200
     2.063    40.872     0.200
     2.449    46.566     0.200
     2.449    46.266     0.200
     2.479    48.819     0.200
     2.481    49.098     0.200
     0.348     7.291     0.200
     1.229    25.104     0.200
     2.069    40.601     0.200
     2.445    47.116     0.200
     2.473    49.294     0.200
     2.482    50.284     0.200
     0.395     8.255     0.200
     1.216    24.280     0.200
     2.081    40.374     0.200
     2.462    47.334     0.200
     2.454    48.524     0.200
     2.444    49.241     0.200
     0.359     7.235     0.200
     1.223    25.259     0.200
     1.223    25.060     0.200
     2.076    41.004     0.200
     2.445    47.295     0.200
     2.465    48.859     0.200
     2.477    49.424     0.200
     2.477    49.824     0.200
     4.011    75.617     0.200
     4.511    84.880     0.200
     0.274     6.591     0.200
     1.277    25.478     0.200
     1.277    25.377     0.200
     2.027    39.824     0.200
     2.450    46.389     0.200
     3.805    67.578     0.200
     3.992    74.194     0.200
     8.211   144.657     0.200
     0.311     6.524     0.200
     0.311     6.422     0.200
     1.257    25.979     0.200
     1.257    25.276     0.200
     2.044    39.897     0.200
     2.452    46.631     0.200
     2.452    46.326     0.200
     2.495    49.830     0.200
     2.495    49.729     0.200
     0.330     6.955     0.200
     1.246    25.664     0.200
     2.053    40.347     0.200
     2.454    46.477     0.200
     2.491    48.943     0.200
     2.484    50.225     0.200
     4.482    83.409     0.200
     0.310     7.418     0.200
     0.310     7.118     0.200
     1.253    24.411     0.200
     1.253    25.012     0.200
     2.048    40.437     0.200
     2.447    45.879     0.200
     2.447    46.779     0.200
     2.499    48.675     0.200
     0.332     7.342     0.200
     1.238    24.374     0.200
     1.238    25.077     0.200
     2.062    40.250     0.200
     2.444    45.900     0.200
     2.444    46.501     0.200
     2.482    48.351     0.200
     2.482    48.555     0.200
     2.491    50.243     0.200
     7.445   130.340     0.200
     0.326     7.136     0.200
     1.247    24.693     0.200
     2.053    40.181     0.200
     2.451    46.739     0.200
     2.491    48.772     0.200
     2.488    49.414     0.200
     4.480    83.861     0.200
     0.602    12.245     0.200
     1.339    27.744     0.200
     2.000    39.825     0.200
     2.167    43.271     0.200
     2.167    43.575     0.200
     4.577    86.044     0.200
     0.332     7.120     0.200
     1.238    24.843     0.200
     1.238    25.543     0.200
     2.062    40.433     0.200
     2.483    48.220     0.200
     2.483    48.420     0.200
     2.444    46.368     0.200
     2.444    46.568     0.200
     2.491    49.322     0.200
     0.314     7.275     0.200
     1.245    24.213     0.200
     1.245    25.213     0.200
     2.057    40.242     0.200
     2.439    45.575     0.200
     2.439    45.974     0.200
     2.491    48.675     0.200
     3.837    70.463     0.200
     5.590   104.313     0.200
     0.333     7.068     0.200
     1.234    24.758     0.200
     2.066    40.343     0.200
     2.440    46.485     0.200
     4.491    83.647     0.200
     0.767    16.026     0.200
     0.767    15.725     0.200
     1.411    28.408     0.200
     0.765    16.193     0.200
     1.286    25.406     0.200
     1.286    25.706     0.200
     2.088    42.358     0.200
     2.088    42.558     0.200
     2.449    48.236     0.200
     2.449    49.236     0.200
     0.350     7.777     0.200
     2.320    46.694     0.200
     2.320    46.092     0.200
     2.794    52.959     0.200
     0.359     7.819     0.200
     2.311    45.735     0.200
     2.311    46.031     0.200
     0.556    10.904     0.200
     0.556    11.303     0.200
     1.283    26.523     0.200
     2.166    42.017     0.200
     0.342     7.701     0.200
     0.342     7.599     0.200
     1.621    31.782     0.200
     2.326    45.451     0.200
     2.784    51.302     0.200
     0.714    14.568     0.200
     0.714    14.966     0.200
     2.185    42.705     0.200
     2.929    53.821     0.200
     0.821    17.078     0.200
     1.331    26.829     0.200
     1.331    26.727     0.200
     2.019    40.998     0.200
     2.019    41.201     0.200
     2.478    49.241     0.200
     3.904    70.200     0.200
     0.818    17.232     0.200
     0.818    17.029     0.200
     1.334    26.915     0.200
     1.334    26.712     0.200
     2.019    41.318     0.200
     2.019    41.420     0.200
     2.482    49.919     0.200
     2.482    49.614     0.200
     0.685    14.320     0.200
     1.009    20.847     0.200
     1.009    20.746     0.200
     2.216    44.561     0.200
     2.216    44.260     0.200
     2.351    46.884     0.200
     2.404    46.458     0.200
     2.404    45.860     0.200
     2.392    48.299     0.200
     2.392    47.595     0.200
     0.679    14.271     0.200
     1.010    20.803     0.200
     1.010    20.303     0.200
     2.219    44.399     0.200
     2.355    46.605     0.200
     2.355    46.705     0.200
     2.402    46.358     0.200
     2.402    45.758     0.200
     2.396    47.925     0.200
     0.695    14.072     0.200
     0.695    14.267     0.200
     1.004    20.967     0.200
     1.004    20.865     0.200
     2.209    44.595     0.200
     2.209    43.899     0.200
     2.342    47.140     0.200
     2.404    46.622     0.200
     2.404    46.122     0.200
     2.390    48.286     0.200
     2.390    47.888     0.200
     0.691    14.188     0.200
     0.691    14.391     0.200
     1.007    20.700     0.200
     1.007    20.899     0.200
     2.213    44.226     0.200
     2.213    44.628     0.200
     2.347    46.769     0.200
     2.407    46.572     0.200
     2.407    45.971     0.200
     2.389    47.977     0.200
     4.014    75.112     0.200
     0.429     9.211     0.200
     1.048    21.598     0.200
     2.204    43.306     0.200
     2.300    45.484     0.200
     2.300    45.082     0.200
     0.680    13.986     0.200
     0.680    14.181     0.200
     2.217    43.739     0.200
     2.217    44.044     0.200
     2.354    46.250     0.200
     2.354    46.648     0.200
     2.402    46.088     0.200
     2.396    47.654     0.200
     0.365     7.951     0.200
     0.365     7.850     0.200
     2.309    45.364     0.200
     2.309    45.466     0.200
     2.813    53.088     0.200
     3.436    58.714     0.200
     3.436    64.409     0.200
     0.062     3.607     0.200
     0.909    18.319     0.200
     2.494    47.421     0.200
     2.494    46.725     0.200
     8.520   149.096     0.200
     0.075     3.578     0.200
     2.490    47.397     0.200
     0.679    14.016     0.200
     0.679    14.416     0.200
     1.004    20.521     0.200
     1.004    20.622     0.200
     2.214    44.008     0.200
     2.351    45.998     0.200
     2.351    46.498     0.200
     2.395    46.385     0.200
     2.395    46.085     0.200
     2.403    47.701     0.200
     2.403    47.502     0.200
     7.357   129.488     0.200
     0.618    12.561     0.200
     0.618    12.961     0.200
     1.217    25.264     0.200
     1.346    27.562     0.200
     1.346    28.062     0.200
     2.150    42.877     0.200
     2.710    51.145     0.200
     5.358    94.639     0.200
     0.589    11.940     0.200
     1.218    23.606     0.200
     2.188    42.175     0.200
     2.188    41.975     0.200
     2.675    49.600     0.200
     5.422   100.835     0.200
     0.607    12.970     0.200
     0.607    11.775     0.200
     1.216    25.561     0.200
     1.338    28.043     0.200
     2.164    43.305     0.200
     7.451   132.909     0.200
     0.605    13.056     0.200
     1.212    24.769     0.200
     1.342    27.849     0.200
     1.342    26.349     0.200
     2.163    43.273     0.200
     0.607    12.718     0.200
     0.607    11.818     0.200
     1.347    27.285     0.200
     2.158    43.624     0.200
     0.648    13.565     0.200
     1.012    20.420     0.200
     1.012    20.116     0.200
     2.228    44.129     0.200
     2.385    46.191     0.200
     2.373    46.230     0.200
     2.421    47.271     0.200
     2.421    46.974     0.200
     7.389   130.594     0.200
     0.290     6.308     0.200
     1.097    22.687     0.200
     1.310    26.310     0.200
     1.310    25.610     0.200
     2.465    49.626     0.200
     2.465    49.326     0.200
     4.422    81.889     0.200
     0.825    17.260     0.200
     0.838    17.414     0.200
     0.838    17.014     0.200
     2.022    41.091     0.200
     2.022    40.491     0.200
     2.160    42.877     0.200
     2.279    44.694     0.200
     2.279    44.394     0.200
     2.488    49.751     0.200
     2.488    49.851     0.200
     0.595    12.544     0.200
     1.217    24.588     0.200
     2.180    43.651     0.200
     0.385     7.678     0.200
     0.385     8.373     0.200
     1.184    24.046     0.200
     2.434    47.768     0.200
     2.434    48.666     0.200
     2.480    47.829     0.200
     2.480    48.236     0.200
     2.474    48.389     0.200
     2.474    49.092     0.200
     0.398     8.449     0.200
     0.398     8.148     0.200
     2.421    48.541     0.200
     2.488    47.963     0.200
     2.488    48.166     0.200
     2.472    48.741     0.200
     2.472    49.241     0.200
     3.851    71.156     0.200
     0.397     8.188     0.200
     0.397     8.290     0.200
     1.231    24.654     0.200
     1.231    24.951     0.200
     1.192    24.108     0.200
     2.427    48.698     0.200
     2.468    48.413     0.200
     2.468    49.613     0.200
     2.481    48.160     0.200
     2.481    48.562     0.200
     0.388     8.318     0.200
     1.190    23.951     0.200
     1.229    24.200     0.200
     1.229    24.404     0.200
     2.438    48.303     0.200
     2.474    48.078     0.200
     2.474    48.281     0.200
     2.468    47.949     0.200
     2.468    48.746     0.200
     3.856    72.654     0.200
     0.551    11.705     0.200
     0.551    11.807     0.200
     1.052    21.670     0.200
     2.132    42.162     0.200
     2.132    42.264     0.200
     0.558    11.659     0.200
     1.058    21.932     0.200
     2.126    42.356     0.200
     2.126    42.153     0.200
     3.638    68.611     0.200
     0.374     9.413     0.200
     2.503    44.969     0.200
     3.484    64.317     0.200
     3.025    52.584     0.200
     5.661   102.616     0.200
     0.450    10.340     0.200
     2.486    44.280     0.200
     2.529    45.675     0.200
     2.529    44.878     0.200
     2.990    54.694     0.200
     5.641   105.059     0.200
     0.290     6.169     0.200
     0.290     6.270     0.200
     1.104    22.569     0.200
     1.302    26.164     0.200
     1.302    26.664     0.200
     2.472    49.107     0.200
     2.472    49.208     0.200
     2.493    47.166     0.200
     2.493    48.166     0.200
     5.533   103.090     0.200
     0.672    13.870     0.200
     0.672    13.971     0.200
     2.248    43.783     0.200
     2.248    44.079     0.200
     3.099    56.332     0.200
     3.099    56.230     0.200
     3.480    62.377     0.200
     0.288     8.686     0.200
     0.288     8.786     0.200
     1.752    32.695     0.200
     2.666    49.632     0.200
     2.666    49.332     0.200
     3.388    63.007     0.200
     4.330    78.609     0.200
     5.346    98.962     0.200
     1.085    22.751     0.200
     1.602    30.926     0.200
    10.152   173.547     0.200
     0.360     7.001     0.200
     0.360     7.907     0.200
     2.300    45.666     0.200
     2.300    45.768     0.200
     2.776    52.407     0.200
     2.776    52.610     0.200
     2.980    55.830     0.200
     3.497    63.302     0.200
     0.641    13.091     0.200
     0.641    13.685     0.200
     2.034    40.732     0.200
     3.598    66.677     0.200
     5.186    95.842     0.200
     7.530   132.786     0.200
     0.369     8.593     0.200
     0.848    17.713     0.200
     2.291    45.770     0.200
     2.785    52.307     0.200
     0.628    14.064     0.200
     3.116    57.436     0.200
     3.116    57.834     0.200
     8.580   151.975     0.200
     0.504    10.552     0.200
     0.504     9.052     0.200
     1.239    26.175     0.200
     2.103    41.597     0.200
     0.469     9.615     0.200
     0.469     9.411     0.200
     0.974    19.613     0.200
     1.521    30.228     0.200
     2.198    45.130     0.200
     2.786    52.673     0.200
     3.584    63.254     0.200
     5.277    93.199     0.200
     0.340     6.998     0.200
     0.340     7.498     0.200
     1.666    32.625     0.200
     2.348    46.359     0.200
     2.805    52.926     0.200
     3.417    60.787     0.200
     3.417    59.490     0.200
     8.145   141.904     0.200
     0.324     7.183     0.200
     0.794    16.597     0.200
     2.349    46.352     0.200
     2.349    46.750     0.200
     2.776    52.564     0.200
     3.485    65.694     0.200
     7.821   141.890     0.200
     0.327     7.220     0.200
     2.344    46.586     0.200
     2.344    47.186     0.200
     3.485    65.770     0.200
     6.999   121.466     0.200
     0.472     9.715     0.200
     1.010    21.238     0.200
     1.486    29.381     0.200
     2.204    43.492     0.200
     0.463     9.687     0.200
     1.004    20.977     0.200
     2.212    43.379     0.200
     2.212    43.178     0.200
     0.540    10.985     0.200
     1.138    22.898     0.200
     1.384    27.930     0.200
     2.190    45.227     0.200
     0.399     7.980     0.200
     0.908    18.339     0.200
     2.260    45.467     0.200
     0.592    11.772     0.200
     1.114    22.586     0.200
     2.113    42.626     0.200
     2.790    53.020     0.200
     0.694    14.101     0.200
     0.694    14.398     0.200
     1.412    27.921     0.200
     2.216    43.540     0.200
     2.262    45.308     0.200
     2.322    46.206     0.200
     2.430    47.244     0.200
     2.430    48.346     0.200
     0.722    14.763     0.200
     2.239    44.257     0.200
     2.256    46.052     0.200
     2.256    45.353     0.200
     2.302    45.522     0.200
     2.302    46.425     0.200
     2.405    47.414     0.200
     2.405    48.015     0.200
     3.645    67.752     0.200
     4.012    75.670     0.200
     5.975   103.958     0.200
     0.309     6.677     0.200
     1.147    23.192     0.200
     1.257    25.516     0.200
     2.045    40.419     0.200
     2.450    46.986     0.200
     2.498    50.135     0.200
     0.370     7.581     0.200
     0.370     7.682     0.200
     1.546    30.660     0.200
     2.288    45.395     0.200
     2.288    45.895     0.200
     2.753    52.373     0.200
     0.318     6.644     0.200
     1.148    23.254     0.200
     2.043    40.223     0.200
     2.459    47.065     0.200
     2.485    50.253     0.200
     3.844    72.402     0.200
     0.310     6.631     0.200
     1.151    23.116     0.200
     1.253    24.927     0.200
     1.253    24.630     0.200
     2.049    40.342     0.200
     2.446    46.298     0.200
     2.446    46.798     0.200
     2.500    49.868     0.200
     2.500    49.969     0.200
     2.498    48.992     0.200
     0.316     6.719     0.200
     0.316     6.820     0.200
     1.152    23.058     0.200
     1.253    25.387     0.200
     1.253    25.688     0.200
     2.048    40.102     0.200
     2.450    46.509     0.200
     2.450    46.708     0.200
     2.498    49.157     0.200
     2.494    50.201     0.200
     3.830    70.012     0.200
     0.351     7.598     0.200
     0.881    18.014     0.200
     2.307    45.463     0.200
     0.378     7.619     0.200
     0.899    18.040     0.200
     1.550    31.248     0.200
     2.280    45.526     0.200
     2.760    52.522     0.200
     0.525    10.802     0.200
     0.525    10.302     0.200
     1.011    20.543     0.200
     1.398    28.023     0.200
     2.287    44.950     0.200
     2.284    44.979     0.200
     2.284    43.877     0.200
     2.441    48.844     0.200
     4.072    76.709     0.200
     0.472    10.206     0.200
     0.472    10.105     0.200
     1.057    21.372     0.200
     1.434    28.377     0.200
     1.434    27.778     0.200
     1.875    37.428     0.200
     2.223    43.667     0.200
     2.783    51.335     0.200
     0.460    10.378     0.200
     0.915    18.677     0.200
     1.065    22.918     0.200
     2.064    42.854     0.200
     2.064    42.557     0.200
     2.240    41.509     0.200
     3.401    63.454     0.200
     3.576    66.714     0.200
     8.950   156.998     0.200
     0.775    15.999     0.200
     1.151    24.812     0.200
     2.242    44.081     0.200
     2.242    42.784     0.200
     3.188    59.640     0.200
     3.188    59.445     0.200
     4.513    83.481     0.200
     8.481   152.678     0.200
     0.542    11.159     0.200
     1.163    23.616     0.200
     1.355    26.874     0.200
     1.967    39.423     0.200
     2.205    44.654     0.200
     2.205    44.858     0.200
     2.683    50.875     0.200
     0.632    13.301     0.200
     1.168    24.543     0.200
     1.168    24.242     0.200
     1.350    27.313     0.200
     2.275    45.618     0.200
     2.275    45.915     0.200
     2.369    47.223     0.200
     2.369    46.621     0.200
     2.487    49.241     0.200
     0.328     6.951     0.200
     1.166    23.374     0.200
     1.240    24.111     0.200
     2.060    40.228     0.200
     2.443    46.569     0.200
     2.485    49.381     0.200
     2.494    49.664     0.200
     0.634    12.920     0.200
     1.203    23.877     0.200
     1.379    28.721     0.200
     2.118    43.903     0.200
     0.195     5.137     0.200
     1.015    20.271     0.200
     1.384    27.958     0.200
     2.522    47.081     0.200
     0.735    14.806     0.200
     0.735    15.206     0.200
     1.039    21.758     0.200
     1.039    20.458     0.200
     1.492    29.869     0.200
     2.307    45.963     0.200
     2.229    45.276     0.200
     2.229    44.776     0.200
     2.322    46.385     0.200
     2.465    47.816     0.200
     2.343    47.042     0.200
     2.343    46.442     0.200
     0.837    17.238     0.200
     0.837    17.339     0.200
     1.301    26.515     0.200
     1.463    30.121     0.200
     1.463    28.722     0.200
     8.400   156.800     0.200
     0.503    10.502     0.200
     1.104    22.690     0.200
     1.399    27.941     0.200
     1.399    27.746     0.200
     1.915    38.422     0.200
     2.212    44.558     0.200
     2.212    43.855     0.200
     3.715    67.424     0.200
     3.715    64.025     0.200
     8.124   145.769     0.200
     8.172   142.307     0.200
     0.692    14.124     0.200
     1.132    23.279     0.200
     1.410    28.236     0.200
     2.215    44.046     0.200
     2.263    46.782     0.200
     2.323    47.188     0.200
     2.431    48.820     0.200
     0.549    11.276     0.200
     1.143    23.048     0.200
     2.165    42.414     0.200
     2.363    47.003     0.200
     2.367    47.957     0.200
     2.476    47.186     0.200
     0.280     7.750     0.200
     0.659    13.530     0.200
     2.737    50.681     0.200
     2.737    50.980     0.200
     0.326     7.388     0.200
     0.618    13.486     0.200
     3.038    56.440     0.200
     3.620    64.848     0.200
     1.078    21.768     0.200
     1.304    26.931     0.200
     1.632    32.009     0.200
     2.300    46.408     0.200
     2.367    47.934     0.200
     2.364    47.470     0.200
     0.773    16.465     0.200
     0.827    16.922     0.200
     2.045    41.914     0.200
     2.237    41.972     0.200
     2.237    44.573     0.200
     2.205    43.344     0.200
     2.484    48.900     0.200
     3.916    71.290     0.200
     0.149     3.602     0.200
     1.371    27.756     0.200
     1.371    26.756     0.200
     1.953    39.156     0.200
     2.474    47.478     0.200
     2.474    47.079     0.200
     8.331   146.929     0.200
     9.435   166.942     0.200
     0.156     3.661     0.200
     1.358    27.127     0.200
     1.966    38.945     0.200
     1.966    40.640     0.200
     2.462    47.551     0.200
     0.738    15.524     0.200
     1.132    22.316     0.200
     1.950    39.575     0.200
     0.275     6.189     0.200
     0.692    14.418     0.200
     1.254    26.054     0.200
     3.085    58.092     0.200
     3.534    65.149     0.200
     4.749    87.467     0.200
     0.718    14.245     0.200
     0.718    15.245     0.200
     1.212    24.781     0.200
     1.379    27.534     0.200
     2.157    43.448     0.200
     2.176    44.732     0.200
     2.390    48.232     0.200
     2.481    49.973     0.200
     7.532   134.224     0.200
     0.541    11.107     0.200
     1.120    22.044     0.200
     1.407    28.001     0.200
     2.177    44.707     0.200
     0.310     7.276     0.200
     0.733    15.233     0.200
     2.393    47.467     0.200
     0.327     7.160     0.200
     1.628    33.184     0.200
     2.370    47.718     0.200
     2.801    53.091     0.200
     0.318     6.636     0.200
     1.548    30.993     0.200
     2.340    46.448     0.200
     0.778    15.980     0.200
     0.935    19.242     0.200
     2.129    43.315     0.200
     2.255    45.048     0.200
     2.374    46.057     0.200
     2.403    47.318     0.200
     2.404    47.205     0.200
     0.603    12.583     0.200
     1.054    21.509     0.200
     2.254    43.609     0.200
     2.275    45.571     0.200
     2.407    46.123     0.200
     2.413    48.255     0.200
     2.423    47.641     0.200
     0.309     6.627     0.200
     0.890    18.048     0.200
     2.349    46.621     0.200
     0.330     6.621     0.200
     0.872    17.597     0.200
     2.328    46.906     0.200
     0.137     3.525     0.200
     0.964    20.767     0.200
     3.325    62.751     0.200
     3.441    63.821     0.200
     0.786    16.333     0.200
     0.927    19.380     0.200
     2.245    44.400     0.200
     2.369    45.954     0.200
     2.413    47.847     0.200
     2.406    49.328     0.200
     0.599    12.102     0.200
     1.163    23.427     0.200
     1.400    28.760     0.200
     2.133    43.808     0.200
     0.583    11.955     0.200
     1.154    23.193     0.200
     1.398    28.548     0.200
     2.147    43.601     0.200
     0.535    11.139     0.200
     1.000    20.616     0.200
     1.409    28.638     0.200
     2.242    45.517     0.200
     2.276    44.317     0.200
     2.431    48.709     0.200
     0.758    14.970     0.200
     0.913    18.358     0.200
     1.573    30.361     0.200
     2.117    42.609     0.200
     2.255    44.203     0.200
     2.336    45.454     0.200
     2.413    46.555     0.200
     2.444    47.897     0.200
     0.331     8.583     0.200
     0.331     8.984     0.200
     0.635    13.032     0.200
     1.803    34.003     0.200
     2.733    50.944     0.200
     1.219    25.406     0.200
     2.113    41.566     0.200
     0.127     6.480     0.200
     0.127     6.580     0.200
     1.964    37.148     0.200
     7.712   142.487     0.200
     0.103     4.786     0.200
     0.836    17.638     0.200
     1.074    21.760     0.200
     2.490    49.530     0.200
     2.801    52.202     0.200
     0.603    12.350     0.200
     1.230    25.134     0.200
     1.316    26.725     0.200
     2.021    39.998     0.200
     2.181    43.939     0.200
     0.621    12.723     0.200
     1.244    25.355     0.200
     1.313    26.551     0.200
     2.030    40.477     0.200
     2.169    44.260     0.200
     2.682    51.077     0.200
     0.175     4.641     0.200
     0.828    17.515     0.200
     2.820    52.570     0.200
     3.290    60.788     0.200
     0.795    16.451     0.200
     1.331    26.697     0.200
     1.360    27.459     0.200
     2.036    42.464     0.200
     2.485    49.829     0.200
     0.811    16.406     0.200
     0.811    16.605     0.200
     1.368    27.708     0.200
     1.338    27.057     0.200
     1.338    26.655     0.200
     2.091    41.867     0.200
     2.091    42.070     0.200
     2.488    50.039     0.200
     2.488    49.840     0.200
     0.818    17.002     0.200
     1.341    26.995     0.200
     2.015    41.834     0.200
     2.093    41.627     0.200
     2.093    42.627     0.200
     2.489    49.599     0.200
     2.489    49.001     0.200
     8.838   153.905     0.200
     0.797    16.376     0.200
     1.329    26.568     0.200
     1.363    27.373     0.200
     2.036    40.912     0.200
     2.092    41.657     0.200
     2.482    49.206     0.200
     0.804    16.668     0.200
     1.329    26.742     0.200
     1.369    27.383     0.200
     2.031    41.349     0.200
     2.096    42.096     0.200
     2.481    49.701     0.200
     0.787    16.295     0.200
     1.345    27.189     0.200
     1.344    26.598     0.200
     2.032    40.775     0.200
     2.073    41.287     0.200
     0.799    16.697     0.200
     1.339    26.703     0.200
     2.028    41.057     0.200
     2.085    41.798     0.200
     2.492    49.846     0.200
     0.793    16.281     0.200
     1.348    26.903     0.200
     2.026    41.189     0.200
     2.073    41.243     0.200
     0.797    16.475     0.200
     1.346    26.769     0.200
     2.024    41.166     0.200
     2.077    41.048     0.200
     2.500    50.208     0.200
     0.806    16.721     0.200
     1.344    26.842     0.200
     1.360    27.050     0.200
     2.020    41.550     0.200
     2.083    41.409     0.200
     2.495    49.708     0.200
     0.802    16.596     0.200
     1.330    26.944     0.200
     1.367    27.908     0.200
     2.032    42.847     0.200
     2.094    41.815     0.200
     0.808    16.602     0.200
     0.808    16.802     0.200
     1.366    27.586     0.200
     1.337    26.924     0.200
     1.337    27.424     0.200
     2.090    42.733     0.200
     2.090    42.534     0.200
     2.024    41.715     0.200
     2.488    49.696     0.200
     0.804    16.682     0.200
     1.344    27.091     0.200
     1.359    27.411     0.200
     2.021    40.881     0.200
     2.083    41.662     0.200
     2.495    50.251     0.200
     0.810    16.699     0.200
     1.344    27.261     0.200
     1.363    27.146     0.200
     2.017    41.313     0.200
     2.085    41.819     0.200
     2.495    49.140     0.200
     0.820    16.775     0.200
     0.820    16.975     0.200
     1.369    28.060     0.200
     1.347    27.121     0.200
     2.088    42.475     0.200
     2.088    41.774     0.200
     2.009    41.895     0.200
     2.494    49.632     0.200
     7.425   135.091     0.200
     1.352    27.317     0.200
     1.343    26.718     0.200
     2.027    41.030     0.200
     2.078    41.637     0.200
     2.497    49.650     0.200
     0.785    16.280     0.200
     1.318    25.974     0.200
     1.361    27.367     0.200
     2.052    41.605     0.200
     2.096    42.083     0.200
     0.812    16.746     0.200
     1.341    27.167     0.200
     1.367    27.671     0.200
     2.089    42.242     0.200
     0.810    17.029     0.200
     1.344    27.194     0.200
     1.363    27.568     0.200
     2.018    41.530     0.200
     2.086    41.334     0.200
     2.494    50.475     0.200
     0.701    14.178     0.200
     0.701    14.779     0.200
     1.228    24.728     0.200
     1.228    25.630     0.200
     2.175    44.281     0.200
     2.175    43.680     0.200
     2.137    41.821     0.200
     2.137    43.622     0.200
     2.409    48.143     0.200
    10.045   178.037     0.200
     0.246     5.439     0.200
     1.080    22.775     0.200
     1.080    22.365     0.200
     1.080    22.576     0.200
     3.247    59.666     0.200
     3.468    62.725     0.200
     3.494    65.603     0.200
     6.344   118.446     0.200
     7.024   131.518     0.200
     0.315     6.678     0.200
     1.156    22.966     0.200
     1.248    25.288     0.200
     2.053    40.395     0.200
     2.444    46.932     0.200
     2.494    49.554     0.200
     0.844    17.292     0.200
     0.893    18.313     0.200
     1.640    32.598     0.200
     2.074    41.741     0.200
     2.191    42.872     0.200
     2.361    45.280     0.200
     2.405    48.267     0.200
     2.463    48.201     0.200
     0.093     3.779     0.200
     0.944    18.943     0.200
     1.878    36.748     0.200
     1.878    37.951     0.200
     0.552    12.481     0.200
     3.030    53.273     0.200
     0.606    13.160     0.200
     1.166    25.257     0.200
     1.166    24.628     0.200
     2.604    49.074     0.200
     2.969    52.884     0.200
     5.641   104.793     0.200
     0.786    16.518     0.200
     0.930    19.234     0.200
     1.583    31.821     0.200
     2.122    43.326     0.200
     2.247    44.671     0.200
     2.373    46.606     0.200
     2.411    47.358     0.200
     2.403    48.453     0.200
     0.368     7.741     0.200
     0.368     7.639     0.200
     0.831    16.846     0.200
     1.609    32.260     0.200
     2.294    45.864     0.200
     2.294    45.559     0.200
     2.793    53.046     0.200
     3.477    62.066     0.200
     0.489    11.879     0.200
     1.034    20.709     0.200
     1.248    25.897     0.200
     2.995    54.876     0.200
     3.160    58.910     0.200
     1.063    22.308     0.200
     1.063    22.410     0.200
     7.590   140.944     0.200
     0.299     6.292     0.200
     0.299     6.096     0.200
     1.286    25.982     0.200
     2.015    40.166     0.200
     2.479    47.650     0.200
     2.479    48.244     0.200
     2.478    49.763     0.200
     2.478    49.966     0.200
     0.365     9.101     0.200
     2.810    51.864     0.200
     2.810    51.665     0.200
     3.273    61.361     0.200
     7.480   136.514     0.200
     0.520    10.841     0.200
     1.221    25.065     0.200
     2.114    41.137     0.200
     0.923    19.138     0.200
     0.947    19.661     0.200
     2.060    42.264     0.200
     2.142    43.103     0.200
     2.321    47.514     0.200
     2.438    47.353     0.200
     2.496    50.473     0.200
     0.231     5.369     0.200
     0.231     4.869     0.200
     0.953    19.646     0.200
     1.452    30.030     0.200
     2.437    48.536     0.200
     2.437    48.434     0.200
     7.910   144.413     0.200
     0.224     4.726     0.200
     0.952    19.333     0.200
     1.452    28.998     0.200
     2.444    48.424     0.200
     0.227     4.792     0.200
     0.951    19.340     0.200
     1.454    29.174     0.200
     1.454    29.971     0.200
     2.441    48.355     0.200
     2.441    48.550     0.200
     7.905   143.934     0.200
     0.218     4.655     0.200
     0.950    19.314     0.200
     1.454    28.232     0.200
     1.454    29.435     0.200
     2.450    48.410     0.200
     2.450    49.012     0.200
     0.219     4.843     0.200
     0.219     4.945     0.200
     0.958    19.723     0.200
     1.446    28.728     0.200
     2.451    48.395     0.200
     0.212     4.642     0.200
     0.942    19.232     0.200
     1.461    27.868     0.200
     1.461    28.868     0.200
     2.453    47.294     0.200
     2.453    48.194     0.200
     7.890   142.385     0.200
     0.223     4.584     0.200
     0.948    19.724     0.200
     1.456    29.992     0.200
     2.444    48.466     0.200
     0.957    19.273     0.200
     1.866    36.557     0.200
     2.480    47.494     0.200
     0.210     4.694     0.200
     0.938    19.297     0.200
     1.464    29.750     0.200
     2.455    48.796     0.200
     0.233     4.918     0.200
     0.950    19.549     0.200
     1.456    29.951     0.200
     2.434    48.529     0.200
     0.212     5.281     0.200
     0.953    19.432     0.200
     1.856    36.788     0.200
     2.457    48.576     0.200
     0.216     4.543     0.200
     0.216     4.644     0.200
     0.934    19.665     0.200
     1.469    30.022     0.200
     2.447    48.411     0.200
     2.613    49.781     0.200
     7.887   145.749     0.200
     0.216     4.942     0.200
     0.939    19.608     0.200
     1.464    29.177     0.200
     2.448    48.392     0.200
     0.219     4.840     0.200
     0.948    19.434     0.200
     1.456    28.601     0.200
     1.456    29.804     0.200
     2.448    48.428     0.200
     0.225     4.642     0.200
     0.954    19.627     0.200
     1.450    29.547     0.200
     2.444    48.539     0.200
     0.204     4.717     0.200
     0.956    19.142     0.200
     2.466    48.122     0.200
     0.227     4.776     0.200
     0.227     4.576     0.200
     0.954    19.587     0.200
     1.451    28.993     0.200
     1.451    29.294     0.200
     2.442    48.723     0.200
     0.219     4.720     0.200
     0.954    19.152     0.200
     1.450    29.757     0.200
     2.449    48.894     0.200
     2.449    49.496     0.200
     0.361     7.614     0.200
     1.165    23.527     0.200
     1.251    24.629     0.200
     2.047    39.640     0.200
     2.445    48.891     0.200
     2.481    47.575     0.200
     2.491    49.452     0.200
     0.369     7.911     0.200
     0.369     7.710     0.200
     1.170    23.764     0.200
     1.247    24.865     0.200
     2.050    41.101     0.200
     2.050    40.802     0.200
     2.439    48.859     0.200
     2.439    49.160     0.200
     2.482    47.152     0.200
     2.482    47.852     0.200
     2.487    49.399     0.200
     0.207     4.448     0.200
     0.939    19.101     0.200
     1.463    28.992     0.200
     2.458    48.483     0.200
     0.237     4.513     0.200
     0.950    19.595     0.200
     1.457    29.772     0.200
     2.431    48.712     0.200
     0.372     7.538     0.200
     1.245    24.644     0.200
     1.173    23.189     0.200
     2.052    40.333     0.200
     2.439    48.714     0.200
     2.439    48.315     0.200
     2.485    48.582     0.200
     2.485    49.082     0.200
     2.481    47.417     0.200
     0.225     4.743     0.200
     0.943    19.159     0.200
     1.461    29.415     0.200
     2.441    48.582     0.200
     0.224     4.492     0.200
     0.946    19.160     0.200
     1.458    29.886     0.200
     2.443    48.894     0.200
     0.210     4.664     0.200
     0.938    19.160     0.200
     1.464    29.422     0.200
     2.455    48.657     0.200
     0.221     4.745     0.200
     0.940    19.150     0.200
     1.464    29.744     0.200
     1.464    29.443     0.200
     2.444    48.402     0.200
     0.215     4.575     0.200
     0.215     4.776     0.200
     1.459    29.857     0.200
     2.451    48.270     0.200
     7.894   144.979     0.200
     0.689    13.861     0.200
     1.131    22.900     0.200
     1.131    23.002     0.200
     1.409    28.553     0.200
     2.266    45.258     0.200
     2.266    44.356     0.200
     2.322    46.698     0.200
     0.660    14.183     0.200
     0.660    13.886     0.200
     1.126    23.445     0.200
     1.394    28.023     0.200
     2.209    43.307     0.200
     2.209    44.011     0.200
     2.292    45.436     0.200
     2.292    46.038     0.200
     2.325    46.660     0.200
     0.679    13.939     0.200
     1.129    22.785     0.200
     1.404    28.673     0.200
     2.213    44.532     0.200
     2.276    45.397     0.200
     2.323    47.051     0.200
     2.435    49.138     0.200
     0.673    13.898     0.200
     1.125    22.614     0.200
     1.402    28.484     0.200
     2.214    44.512     0.200
     2.321    46.960     0.200
     2.284    47.398     0.200
     2.436    48.522     0.200
     0.894    17.754     0.200
     1.178    23.638     0.200
     3.094    58.578     0.200
     8.292   151.415     0.200
     0.681    13.695     0.200
     1.123    22.839     0.200
     1.409    28.402     0.200
     2.219    43.647     0.200
     2.280    46.140     0.200
     2.317    46.906     0.200
     2.430    48.383     0.200
     0.670    13.879     0.200
     0.670    13.279     0.200
     1.120    22.828     0.200
     1.120    22.029     0.200
     1.404    28.811     0.200
     2.291    46.159     0.200
     2.218    43.914     0.200
     2.317    46.960     0.200
     2.317    46.060     0.200
     2.433    48.700     0.200
     2.433    48.300     0.200
     0.658    13.263     0.200
     0.658    13.162     0.200
     1.122    22.250     0.200
     2.212    43.128     0.200
     2.212    42.929     0.200
     2.298    44.927     0.200
     2.298    44.728     0.200
     2.321    46.051     0.200
     2.321    45.852     0.200
     2.440    48.062     0.200
     2.440    47.461     0.200
     8.393   151.783     0.200
     0.237     4.672     0.200
     0.962    19.498     0.200
     1.444    28.583     0.200
     2.435    48.217     0.200
     0.659    13.016     0.200
     1.132    22.709     0.200
     1.390    27.792     0.200
     2.287    45.219     0.200
     2.330    46.624     0.200
     2.447    48.655     0.200
     8.392   151.516     0.200
     0.668    13.849     0.200
     1.118    22.598     0.200
     1.404    28.165     0.200
     2.219    44.351     0.200
     2.294    46.866     0.200
     2.315    47.120     0.200
     2.433    49.055     0.200
     0.663    13.945     0.200
     0.663    13.750     0.200
     1.133    22.659     0.200
     1.133    22.862     0.200
     2.204    43.062     0.200
     2.204    43.663     0.200
     2.330    46.186     0.200
     2.330    46.389     0.200
     2.283    45.633     0.200
     2.283    45.235     0.200
     0.690    14.145     0.200
     1.140    22.786     0.200
     1.404    28.502     0.200
     2.207    43.934     0.200
     2.257    44.650     0.200
     2.330    46.694     0.200
     0.689    14.171     0.200
     1.122    22.912     0.200
     1.414    28.402     0.200
     2.222    44.076     0.200
     2.275    46.463     0.200
     2.314    46.299     0.200
     0.654    12.924     0.200
     0.654    13.324     0.200
     1.111    22.591     0.200
     1.111    22.291     0.200
     1.399    27.719     0.200
     2.312    46.266     0.200
     2.312    46.066     0.200
     2.220    43.544     0.200
     2.220    44.143     0.200
     2.499    48.586     0.200
     2.499    48.786     0.200
     0.674    13.957     0.200
     1.109    22.390     0.200
     1.413    28.528     0.200
     2.298    46.310     0.200
     2.306    46.515     0.200
     0.677    13.604     0.200
     1.110    23.154     0.200
     1.414    28.604     0.200
     2.228    44.607     0.200
     2.294    46.530     0.200
     2.306    46.796     0.200
     0.681    13.487     0.200
     1.129    22.965     0.200
     1.406    27.231     0.200
     2.214    42.997     0.200
     2.274    45.296     0.200
     2.322    46.338     0.200
     0.466     9.782     0.200
     1.227    24.900     0.200
     2.059    39.498     0.200
     2.059    39.599     0.200
     8.796   156.722     0.200
     0.667    14.066     0.200
     0.667    13.965     0.200
     1.139    23.068     0.200
     1.139    22.966     0.200
     1.391    28.420     0.200
     2.201    43.671     0.200
     2.275    45.604     0.200
     2.275    45.705     0.200
     2.334    46.513     0.200
     0.687    13.478     0.200
     1.110    23.144     0.200
     1.421    28.917     0.200
     2.232    44.952     0.200
     2.304    46.611     0.200
     2.287    46.002     0.200
     0.653    13.400     0.200
     1.124    23.103     0.200
     1.391    28.093     0.200
     2.208    43.752     0.200
     2.299    46.394     0.200
     2.325    46.493     0.200
     0.659    13.713     0.200
     1.122    22.708     0.200
     1.396    28.218     0.200
     2.212    44.392     0.200
     2.297    45.301     0.200
     2.322    46.809     0.200
     0.699    14.378     0.200
     1.129    23.257     0.200
     1.417    28.205     0.200
     2.220    43.732     0.200
     2.260    45.159     0.200
     2.318    46.586     0.200
     0.701    14.211     0.200
     1.092    22.153     0.200
     1.441    28.683     0.200
     2.252    44.014     0.200
     2.284    45.240     0.200
     2.295    45.715     0.200
     0.662    13.845     0.200
     1.116    22.846     0.200
     1.401    28.416     0.200
     2.218    44.483     0.200
     2.315    46.752     0.200
     2.300    46.227     0.200
     0.664    13.722     0.200
     0.664    12.823     0.200
     1.141    23.550     0.200
     1.387    28.278     0.200
     2.198    43.319     0.200
     2.198    43.018     0.200
     2.276    44.207     0.200
     2.276    45.605     0.200
     2.337    46.790     0.200
     8.785   153.840     0.200
     0.656    13.434     0.200
     1.143    23.246     0.200
     1.381    27.875     0.200
     2.193    43.696     0.200
     2.280    45.687     0.200
     2.341    46.968     0.200
     0.658    13.628     0.200
     0.658    13.425     0.200
     1.129    22.528     0.200
     1.391    28.278     0.200
     2.206    43.266     0.200
     2.206    44.462     0.200
     2.291    46.068     0.200
     2.291    45.170     0.200
     2.328    46.842     0.200
     0.658    13.608     0.200
     1.144    23.534     0.200
     2.193    43.290     0.200
     2.278    45.406     0.200
     2.341    46.559     0.200
     0.697    14.450     0.200
     1.099    22.559     0.200
     1.434    29.352     0.200
     2.244    45.190     0.200
     2.291    45.740     0.200
     0.689    14.371     0.200
     0.689    13.973     0.200
     1.105    22.709     0.200
     1.105    22.811     0.200
     1.425    28.981     0.200
     2.236    44.707     0.200
     2.236    44.007     0.200
     2.291    45.370     0.200
     2.299    46.678     0.200
     0.692    14.431     0.200
     1.098    22.492     0.200
     1.431    28.912     0.200
     2.243    45.032     0.200
     2.292    46.163     0.200
     2.295    46.433     0.200
     0.660    13.655     0.200
     1.153    23.204     0.200
     1.377    28.288     0.200
     2.186    44.452     0.200
     2.267    45.910     0.200
     2.349    47.546     0.200
     0.666    13.479     0.200
     1.142    23.530     0.200
     1.388    27.954     0.200
     2.198    43.606     0.200
     2.273    45.929     0.200
     2.337    47.076     0.200
     0.655    13.451     0.200
     1.142    23.470     0.200
     1.381    27.877     0.200
     2.194    43.689     0.200
     2.282    46.165     0.200
     2.340    46.781     0.200
     0.705    14.357     0.200
     0.705    14.658     0.200
     1.118    22.832     0.200
     1.118    22.732     0.200
     1.427    29.322     0.200
     2.232    45.137     0.200
     2.232    44.637     0.200
     2.267    46.520     0.200
     2.267    45.619     0.200
     2.307    46.061     0.200
    10.849   196.175     0.200
     0.689    14.187     0.200
     1.113    22.438     0.200
     2.230    45.010     0.200
     2.283    45.187     0.200
     0.696    14.265     0.200
     1.123    23.678     0.200
     2.224    44.531     0.200
     2.269    45.908     0.200
     0.695    13.951     0.200
     1.090    22.438     0.200
     2.251    44.790     0.200
     2.301    46.108     0.200
     2.499    48.899     0.200
     0.662    13.387     0.200
     1.138    23.240     0.200
     1.388    28.117     0.200
     2.200    43.941     0.200
     2.280    45.910     0.200
     0.679    13.888     0.200
     1.103    22.344     0.200
     1.420    28.639     0.200
     2.235    44.627     0.200
     2.299    45.787     0.200
     2.300    46.274     0.200
     0.711    14.530     0.200
     1.114    22.635     0.200
     1.434    29.090     0.200
     2.238    44.613     0.200
     2.267    45.675     0.200
     2.301    46.379     0.200
     0.698    14.332     0.200
     1.090    21.961     0.200
     1.440    28.677     0.200
     2.252    44.599     0.200
     2.283    46.333     0.200
     2.299    46.454     0.200
     0.740    14.956     0.200
     1.122    23.201     0.200
     1.449    29.479     0.200
     2.243    45.019     0.200
     2.240    44.153     0.200
     0.764    14.811     0.200
     1.449    29.722     0.200
     2.229    45.121     0.200
     2.198    44.983     0.200
     2.593    49.572     0.200
     0.689    14.418     0.200
     1.122    22.969     0.200
     1.415    29.048     0.200
     2.223    44.821     0.200
     2.275    46.612     0.200
     0.679    14.042     0.200
     1.124    22.656     0.200
     1.408    28.742     0.200
     2.218    44.187     0.200
     2.280    45.859     0.200
     0.698    14.303     0.200
     1.118    23.104     0.200
     1.423    29.143     0.200
     2.272    46.231     0.200
     2.229    44.430     0.200
     0.690    14.153     0.200
     1.090    22.582     0.200
     1.090    22.386     0.200
     1.435    28.767     0.200
     2.249    44.055     0.200
     2.249    44.758     0.200
     2.304    45.224     0.200
     2.304    45.622     0.200
     2.285    45.635     0.200
     2.497    48.575     0.200
     0.721    14.964     0.200
     1.122    23.182     0.200
     1.436    29.124     0.200
     2.235    44.204     0.200
     2.252    45.605     0.200
     2.306    46.668     0.200
     0.710    14.987     0.200
     1.103    22.795     0.200
     1.440    28.771     0.200
     2.246    45.066     0.200
     2.292    46.626     0.200
     2.277    46.495     0.200
     3.636    68.745     0.200
     0.696    14.485     0.200
     0.696    14.180     0.200
     1.102    22.245     0.200
     1.102    22.143     0.200
     1.431    29.198     0.200
     2.289    46.083     0.200
     2.289    44.083     0.200
     2.294    45.422     0.200
     2.242    45.035     0.200
     0.708    14.516     0.200
     1.111    22.812     0.200
     1.434    29.346     0.200
     2.239    45.251     0.200
     2.300    45.843     0.200
     2.271    46.371     0.200
     0.714    14.716     0.200
     1.100    21.899     0.200
     1.444    28.994     0.200
     2.250    44.794     0.200
     2.288    46.137     0.200
     2.277    45.572     0.200
     0.701    14.316     0.200
     0.701    14.617     0.200
     1.108    22.669     0.200
     1.108    22.369     0.200
     1.431    29.197     0.200
     2.279    45.997     0.200
     2.239    45.172     0.200
     2.298    46.475     0.200
     0.712    14.620     0.200
     1.099    21.802     0.200
     1.443    29.188     0.200
     2.250    44.577     0.200
     2.279    46.032     0.200
     0.706    14.422     0.200
     1.106    22.354     0.200
     2.242    44.594     0.200
     2.278    45.977     0.200
     2.295    46.374     0.200
     0.667    13.691     0.200
     1.123    23.269     0.200
     1.400    28.541     0.200
     2.214    44.546     0.200
     2.289    46.162     0.200
     2.321    47.098     0.200
     0.713    14.868     0.200
     1.096    22.704     0.200
     1.446    29.814     0.200
     2.253    45.793     0.200
     2.285    46.230     0.200
     2.282    46.653     0.200
     0.700    14.587     0.200
     0.700    14.287     0.200
     1.108    22.433     0.200
     1.108    22.333     0.200
     1.431    29.362     0.200
     2.298    46.237     0.200
     2.280    45.748     0.200
     2.280    44.748     0.200
     2.239    45.534     0.200
     8.435   153.468     0.200
     0.710    14.581     0.200
     1.103    22.296     0.200
     1.440    29.461     0.200
     2.246    45.350     0.200
     2.291    46.622     0.200
     2.278    45.477     0.200
     0.720    14.762     0.200
     1.102    22.809     0.200
     1.447    29.477     0.200
     2.251    44.899     0.200
     2.272    46.258     0.200
     0.708    14.575     0.200
     1.103    22.468     0.200
     1.439    29.454     0.200
     2.245    44.937     0.200
     2.292    46.793     0.200
     2.279    45.745     0.200
     0.696    14.278     0.200
     1.091    22.070     0.200
     1.438    29.018     0.200
     2.251    44.929     0.200
     2.284    46.241     0.200
     2.300    46.162     0.200
     2.399    48.199     0.200
     0.700    14.168     0.200
     1.090    22.321     0.200
     1.090    22.523     0.200
     1.441    29.120     0.200
     2.282    46.303     0.200
     2.282    45.604     0.200
     2.297    47.326     0.200
     2.297    45.427     0.200
     2.396    48.274     0.200
     2.396    47.672     0.200
     2.253    44.442     0.200
     2.253    44.341     0.200
     0.685    14.116     0.200
     1.090    22.000     0.200
     1.432    28.807     0.200
     2.248    44.879     0.200
     2.286    46.038     0.200
     2.308    46.478     0.200
     2.404    47.964     0.200
     2.493    48.418     0.200
     4.049    71.268     0.200
     0.673    13.791     0.200
     1.110    22.878     0.200
     1.411    28.069     0.200
     2.226    44.354     0.200
     2.298    45.828     0.200
     2.308    46.304     0.200
     0.217     4.825     0.200
     0.951    19.453     0.200
     1.452    29.411     0.200
     2.451    48.250     0.200
     0.697    14.392     0.200
     1.103    22.646     0.200
     1.431    29.020     0.200
     2.241    44.374     0.200
     2.295    46.634     0.200
     2.287    46.136     0.200
     0.353     7.564     0.200
     1.252    25.568     0.200
     2.045    40.117     0.200
     2.452    48.573     0.200
     2.477    47.477     0.200
     2.494    49.287     0.200
     8.098   150.424     0.200
     0.650    12.717     0.200
     1.142    23.183     0.200
     1.378    27.722     0.200
     2.192    43.220     0.200
     2.285    45.937     0.200
     2.341    46.779     0.200
     0.666    14.271     0.200
     1.378    28.461     0.200
     2.184    43.755     0.200
     2.259    45.686     0.200
     2.352    46.897     0.200
     0.224     4.757     0.200
     1.443    29.523     0.200
     2.448    48.703     0.200
     0.633    13.422     0.200
     1.196    24.745     0.200
     1.332    26.855     0.200
     2.140    43.134     0.200
     2.250    45.846     0.200
     2.395    47.754     0.200
     0.660    13.895     0.200
     1.125    23.269     0.200
     1.395    28.227     0.200
     2.293    45.447     0.200
     2.324    46.881     0.200
     2.210    43.514     0.200
     2.442    48.704     0.200
     0.676    13.792     0.200
     1.120    22.809     0.200
     2.315    46.455     0.200
     2.286    45.798     0.200
     2.220    43.376     0.200
     2.430    48.517     0.200
     8.410   153.727     0.200
     0.695    14.386     0.200
     1.111    22.624     0.200
     1.425    28.863     0.200
     2.234    44.426     0.200
     2.281    46.472     0.200
     2.303    46.419     0.200
     2.414    48.316     0.200
     7.328   122.471     0.200
     1.533    30.420     0.200
     2.199    44.338     0.200
     0.662    14.052     0.200
     1.112    22.592     0.200
     2.221    44.152     0.200
     2.304    46.284     0.200
     2.304    45.484     0.200
     2.312    46.091     0.200
     0.669    13.910     0.200
     1.091    21.585     0.200
     1.421    28.237     0.200
     2.241    43.562     0.200
     2.291    45.879     0.200
     2.486    48.502     0.200
     0.710    14.539     0.200
     1.091    21.991     0.200
     1.447    29.340     0.200
     2.256    44.498     0.200
     2.281    46.003     0.200
     2.289    45.408     0.200
     0.229     4.780     0.200
     0.964    19.601     0.200
     1.441    29.138     0.200
     2.443    48.746     0.200
     7.265   133.636     0.200
     0.232     4.621     0.200
     0.962    19.099     0.200
     1.444    28.774     0.200
     2.440    48.449     0.200
     0.688    13.552     0.200
     0.688    13.952     0.200
     1.104    22.307     0.200
     1.104    22.506     0.200
     1.425    28.652     0.200
     2.293    45.931     0.200
     2.298    46.270     0.200
     2.298    46.670     0.200
     2.412    47.734     0.200
     2.412    47.433     0.200
     0.529    11.641     0.200
     0.948    19.362     0.200
     1.450    29.294     0.200
     2.138    40.974     0.200
     2.200    44.349     0.200
     2.429    47.875     0.200
     0.546    11.345     0.200
     0.933    19.226     0.200
     1.464    29.123     0.200
     2.185    44.517     0.200
     2.136    42.291     0.200
     2.412    48.068     0.200
     2.412    47.869     0.200
     2.381    46.724     0.200
     3.941    72.092     0.200
     0.531    11.517     0.200
     0.947    19.556     0.200
     1.451    29.177     0.200
     2.140    42.236     0.200
     2.199    44.546     0.200
     2.369    47.058     0.200
     2.427    48.280     0.200
     0.543    11.358     0.200
     0.935    19.087     0.200
     0.935    19.787     0.200
     2.132    40.319     0.200
     2.187    44.175     0.200
     2.187    44.277     0.200
     2.381    46.004     0.200
     2.415    48.007     0.200
     2.415    48.108     0.200
     8.248   150.906     0.200
     0.547    11.484     0.200
     0.935    19.456     0.200
     1.462    29.408     0.200
     2.149    41.696     0.200
     2.186    44.455     0.200
     2.376    46.744     0.200
     2.409    48.061     0.200
     0.546    11.642     0.200
     0.932    19.133     0.200
     1.466    29.400     0.200
     2.129    41.967     0.200
     2.184    44.022     0.200
     2.384    46.489     0.200
     2.413    47.748     0.200
     0.551    11.593     0.200
     0.930    18.873     0.200
     1.467    29.506     0.200
     2.181    43.469     0.200
     2.143    41.714     0.200
     2.405    47.861     0.200
     2.381    46.937     0.200
     0.215     4.820     0.200
     0.941    19.457     0.200
     1.463    29.666     0.200
     2.450    48.549     0.200
     0.720    14.320     0.200
     1.101    22.679     0.200
     1.448    29.625     0.200
     2.252    44.047     0.200
     2.287    46.741     0.200
     2.273    45.704     0.200
     2.394    47.894     0.200
     0.696    14.592     0.200
     1.091    22.181     0.200
     1.438    29.539     0.200
     2.250    44.456     0.200
     2.298    47.295     0.200
     2.285    46.055     0.200
     2.399    48.018     0.200
     0.737    14.925     0.200
     1.055    21.319     0.200
     2.242    44.966     0.200
     2.352    46.373     0.200
     2.296    45.135     0.200
     0.897    18.167     0.200
     1.026    21.257     0.200
     2.073    41.845     0.200
     2.318    47.076     0.200
     2.441    46.247     0.200
     2.441    47.747     0.200
     0.324     6.826     0.200
     1.098    22.189     0.200
     1.318    26.325     0.200
     1.980    39.703     0.200
     2.423    48.225     0.200
     0.707    14.416     0.200
     0.995    20.659     0.200
     1.499    29.980     0.200
     2.332    45.953     0.200
     2.198    44.512     0.200
     2.390    47.878     0.200
     2.401    46.745     0.200
     2.330    46.473     0.200
     8.460   153.556     0.200
     0.633    13.093     0.200
     0.633    12.893     0.200
     1.081    22.162     0.200
     1.081    22.362     0.200
     2.239    43.749     0.200
     2.239    44.149     0.200
     2.291    45.841     0.200
     2.358    47.458     0.200
     2.358    47.358     0.200
     2.425    48.281     0.200
     2.425    47.181     0.200
     2.456    47.917     0.200
     0.591    12.800     0.200
     0.591    13.003     0.200
     0.889    17.928     0.200
     0.889    18.530     0.200
     2.140    42.021     0.200
     2.140    42.220     0.200
     2.423    46.021     0.200
     2.367    46.575     0.200
     2.367    46.075     0.200
     0.954    19.857     0.200
     0.954    19.658     0.200
     1.163    23.616     0.200
     1.900    38.416     0.200
     1.095    22.088     0.200
     1.444    29.016     0.200
     2.252    44.681     0.200
     2.287    45.679     0.200
     2.396    46.907     0.200
     2.396    48.610     0.200
     0.552    11.403     0.200
     1.461    29.592     0.200
     2.166    42.372     0.200
     2.186    44.133     0.200
     2.371    46.781     0.200
     2.403    47.706     0.200
     8.274   152.331     0.200
     0.869    17.409     0.200
     0.930    18.699     0.200
     2.094    42.401     0.200
     2.352    46.698     0.200
     2.413    46.594     0.200
     2.449    47.669     0.200
     0.868    17.944     0.200
     0.938    19.023     0.200
     1.637    33.269     0.200
     2.102    43.039     0.200
     2.202    44.175     0.200
     2.344    48.520     0.200
     2.421    47.011     0.200
     2.442    48.567     0.200
     0.866    17.765     0.200
     0.929    19.029     0.200
     1.640    33.129     0.200
     2.095    43.119     0.200
     2.197    44.223     0.200
     2.410    46.936     0.200
     2.355    48.188     0.200
     2.448    48.297     0.200
     0.917    18.580     0.200
     0.884    18.254     0.200
     2.179    44.053     0.200
     2.406    46.995     0.200
     0.883    18.167     0.200
     0.917    18.669     0.200
     2.180    44.041     0.200
     2.406    46.690     0.200
     0.883    18.451     0.200
     0.933    18.965     0.200
     2.189    44.301     0.200
     2.422    46.778     0.200
     8.634   158.447     0.200
     0.878    18.488     0.200
     0.913    18.583     0.200
     2.077    42.592     0.200
     2.180    42.893     0.200
     2.399    46.836     0.200
     2.365    47.642     0.200
     0.856    17.946     0.200
     0.935    18.415     0.200
     2.104    42.281     0.200
     2.208    44.471     0.200
     2.413    46.671     0.200
     2.353    46.771     0.200
     2.438    48.676     0.200
     0.855    18.031     0.200
     0.942    19.417     0.200
     2.212    44.300     0.200
     2.420    46.970     0.200
     2.346    48.433     0.200
     0.945    18.924     0.200
     1.647    33.227     0.200
     2.101    43.029     0.200
     2.195    44.138     0.200
     2.327    47.494     0.200
     2.447    47.995     0.200
     0.728    15.456     0.200
     1.051    21.981     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
