#!/bin/bash
gmt begin chara1.31_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance chara1.31'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.000    22.051
     1.100    23.424
     1.200    24.797
     1.300    26.170
     1.400    27.543
     1.500    28.917
     1.600    30.290
     1.700    31.663
     1.800    33.036
     1.900    34.409
     2.000    35.782
     2.100    37.155
     2.200    38.529
     2.300    39.902
     2.400    41.275
     2.500    42.648
     2.600    44.021
     2.700    45.394
     2.800    46.767
     2.900    48.140
     3.000    49.514
     3.100    50.887
     3.200    52.260
     3.300    53.633
     3.400    55.006
     3.500    56.379
     3.600    57.751
     3.700    59.124
     3.800    60.497
     3.900    61.869
     4.000    63.242
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    55.751 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.419
     0.200     4.106
     0.300     5.934
     0.400     7.804
     0.500     9.692
     0.600    11.590
     0.700    13.492
     0.800    15.398
     0.900    17.306
     1.000    19.215
     1.100    21.126
     1.200    22.922
     1.300    24.628
     1.400    26.333
     1.500    28.038
     1.600    29.743
     1.700    31.449
     1.800    33.154
     1.900    34.859
     2.000    36.564
     2.100    38.269
     2.200    39.975
     2.300    41.680
     2.400    43.385
     2.500    45.090
     2.600    46.795
     2.700    48.501
     2.800    50.206
     2.900    51.911
     3.000    53.616
     3.100    55.320
     3.200    57.025
     3.300    58.730
     3.400    60.435
     3.500    62.140
     3.600    63.845
     3.700    65.549
     3.800    67.254
     3.900    68.959
     4.000    70.663
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    62.845 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.100    39.570
     1.200    41.970
     1.300    44.370
     1.400    46.770
     1.500    49.170
     1.600    51.570
     1.700    53.970
     1.800    56.370
     1.900    58.770
     2.000    61.170
     2.100    63.570
     2.200    65.970
     2.300    68.370
     2.400    70.770
     2.500    73.170
     2.600    75.570
     2.700    77.970
     2.800    80.370
     2.900    82.770
     3.000    85.170
     3.100    87.570
     3.200    89.970
     3.300    92.370
     3.400    94.770
     3.500    97.170
     3.600    99.570
     3.700   101.969
     3.800   104.368
     3.900   106.767
     4.000   109.167
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    97.570 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.055
     0.200     6.884
     0.300     9.948
     0.400    13.083
     0.500    16.248
     0.600    19.428
     0.700    22.617
     0.800    25.811
     0.900    29.010
     1.000    32.210
     1.100    35.413
     1.200    38.555
     1.300    41.434
     1.400    44.313
     1.500    47.192
     1.600    50.071
     1.700    52.950
     1.800    55.829
     1.900    58.707
     2.000    61.586
     2.100    64.465
     2.200    67.344
     2.300    70.223
     2.400    73.102
     2.500    75.981
     2.600    78.860
     2.700    81.739
     2.800    84.618
     2.900    87.496
     3.000    90.374
     3.100    93.253
     3.200    96.131
     3.300    99.009
     3.400   101.887
     3.500   104.766
     3.600   107.644
     3.700   110.522
     3.800   113.401
     3.900   116.278
     4.000   119.156
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   106.644 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    23.081
     1.100    24.454
     1.200    25.827
     1.300    27.200
     1.400    28.574
     1.500    29.947
     1.600    31.320
     1.700    32.693
     1.800    34.066
     1.900    35.439
     2.000    36.812
     2.100    38.185
     2.200    39.559
     2.300    40.932
     2.400    42.305
     2.500    43.678
     2.600    45.051
     2.700    46.424
     2.800    47.797
     2.900    49.171
     3.000    50.544
     3.100    51.917
     3.200    53.290
     3.300    54.663
     3.400    56.036
     3.500    57.409
     3.600    58.782
     3.700    60.154
     3.800    61.527
     3.900    62.900
     4.000    64.272
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.917
     0.200     3.834
     0.300     5.751
     0.400     7.668
     0.500     9.585
     0.600    11.502
     0.700    13.419
     0.800    15.337
     0.900    17.254
     1.000    19.171
     1.100    21.088
     1.200    23.005
     1.300    24.922
     1.400    26.839
     1.500    28.711
     1.600    30.417
     1.700    32.122
     1.800    33.827
     1.900    35.532
     2.000    37.237
     2.100    38.943
     2.200    40.648
     2.300    42.353
     2.400    44.058
     2.500    45.763
     2.600    47.469
     2.700    49.174
     2.800    50.879
     2.900    52.584
     3.000    54.289
     3.100    55.994
     3.200    57.699
     3.300    59.404
     3.400    61.109
     3.500    62.814
     3.600    64.519
     3.700    66.223
     3.800    67.928
     3.900    69.633
     4.000    71.337
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    41.215
     1.200    43.615
     1.300    46.015
     1.400    48.415
     1.500    50.815
     1.600    53.215
     1.700    55.615
     1.800    58.015
     1.900    60.415
     2.000    62.815
     2.100    65.215
     2.200    67.615
     2.300    70.015
     2.400    72.415
     2.500    74.815
     2.600    77.215
     2.700    79.615
     2.800    82.015
     2.900    84.415
     3.000    86.815
     3.100    89.215
     3.200    91.615
     3.300    94.015
     3.400    96.415
     3.500    98.815
     3.600   101.215
     3.700   103.615
     3.800   106.013
     3.900   108.413
     4.000   110.812
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.214
     0.200     6.427
     0.300     9.641
     0.400    12.854
     0.500    16.068
     0.600    19.281
     0.700    22.495
     0.800    25.709
     0.900    28.922
     1.000    32.136
     1.100    35.349
     1.200    38.563
     1.300    41.777
     1.400    44.990
     1.500    48.204
     1.600    51.168
     1.700    54.047
     1.800    56.926
     1.900    59.805
     2.000    62.684
     2.100    65.562
     2.200    68.441
     2.300    71.320
     2.400    74.199
     2.500    77.078
     2.600    79.957
     2.700    82.836
     2.800    85.715
     2.900    88.594
     3.000    91.473
     3.100    94.351
     3.200    97.229
     3.300   100.107
     3.400   102.986
     3.500   105.864
     3.600   108.742
     3.700   111.621
     3.800   114.499
     3.900   117.377
     4.000   120.255
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    15.648
     0.800    17.021
     0.900    18.395
     1.000    19.768
     1.100    21.141
     1.200    22.514
     1.300    23.887
     1.400    25.260
     1.500    26.633
     1.600    28.006
     1.700    29.380
     1.800    30.753
     1.900    32.126
     2.000    33.499
     2.100    34.872
     2.200    36.245
     2.300    37.618
     2.400    38.991
     2.500    40.365
     2.600    41.738
     2.700    43.111
     2.800    44.484
     2.900    45.857
     3.000    47.230
     3.100    48.603
     3.200    49.976
     3.300    51.349
     3.400    52.721
     3.500    54.094
     3.600    55.467
     3.700    56.839
     3.800    58.212
     3.900    59.585
     4.000    60.957
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.316
     0.200     6.197
     0.300     7.433
     0.400     8.872
     0.500    10.423
     0.600    12.036
     0.700    13.684
     0.800    15.351
     0.900    17.030
     1.000    18.716
     1.100    20.406
     1.200    22.100
     1.300    23.795
     1.400    25.492
     1.500    27.190
     1.600    28.890
     1.700    30.589
     1.800    32.290
     1.900    33.991
     2.000    35.692
     2.100    37.393
     2.200    39.095
     2.300    40.797
     2.400    42.498
     2.500    44.200
     2.600    45.903
     2.700    47.605
     2.800    49.308
     2.900    51.010
     3.000    52.712
     3.100    54.415
     3.200    56.118
     3.300    57.820
     3.400    59.523
     3.500    61.226
     3.600    62.928
     3.700    64.631
     3.800    66.333
     3.900    68.036
     4.000    69.738
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    28.746
     0.900    31.146
     1.000    33.546
     1.100    35.946
     1.200    38.346
     1.300    40.746
     1.400    43.146
     1.500    45.546
     1.600    47.946
     1.700    50.346
     1.800    52.746
     1.900    55.146
     2.000    57.546
     2.100    59.946
     2.200    62.346
     2.300    64.746
     2.400    67.146
     2.500    69.547
     2.600    71.947
     2.700    74.347
     2.800    76.747
     2.900    79.147
     3.000    81.547
     3.100    83.947
     3.200    86.347
     3.300    88.746
     3.400    91.146
     3.500    93.545
     3.600    95.944
     3.700    98.343
     3.800   100.743
     3.900   103.142
     4.000   105.541
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     8.931
     0.200    10.412
     0.300    12.491
     0.400    14.912
     0.500    17.523
     0.600    20.241
     0.700    23.019
     0.800    25.832
     0.900    28.664
     1.000    31.510
     1.100    34.363
     1.200    37.221
     1.300    40.083
     1.400    42.948
     1.500    45.815
     1.600    48.684
     1.700    51.553
     1.800    54.424
     1.900    57.295
     2.000    60.167
     2.100    63.039
     2.200    65.912
     2.300    68.786
     2.400    71.659
     2.500    74.533
     2.600    77.406
     2.700    80.281
     2.800    83.154
     2.900    86.029
     3.000    88.903
     3.100    91.778
     3.200    94.652
     3.300    97.527
     3.400   100.401
     3.500   103.276
     3.600   106.150
     3.700   109.025
     3.800   111.899
     3.900   114.774
     4.000   117.648
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.425    39.820     0.200
     8.512   123.023     0.200
     8.709   127.820     0.200
    10.324   150.820     0.200
    10.324   150.422     0.200
    10.731   156.719     0.200
    16.285   229.820     0.200
    19.288   266.219     0.200
    20.241   280.523     0.200
     2.190    38.422     0.200
     2.641    43.219     0.200
     8.954   133.820     0.200
    10.554   156.422     0.200
    16.293   230.422     0.200
    18.440   258.422     0.200
     2.534    41.926     0.200
     3.692    58.926     0.200
     4.634    71.625     0.200
     5.017    78.324     0.200
     4.966    74.926     0.200
     7.529   111.324     0.200
     8.877   128.926     0.200
     8.877   129.727     0.200
    10.487   152.926     0.200
    10.487   152.027     0.200
    13.465   191.125     0.200
    14.692   207.926     0.200
    14.692   208.027     0.200
    16.329   229.426     0.200
    17.670   241.926     0.200
    17.670   242.426     0.200
    19.447   267.926     0.200
    20.124   276.926     0.200
     2.550    42.078     0.200
     2.321    39.180     0.200
     4.742    72.984     0.200
     5.112    75.281     0.200
    10.628   155.383     0.200
    14.809   210.281     0.200
    19.527   269.281     0.200
     2.287    38.621     0.200
     2.566    42.223     0.200
     3.781    60.121     0.200
     5.119    79.723     0.200
     5.948    89.223     0.200
     2.088    36.180     0.200
     2.129    37.281     0.200
     2.395    40.680     0.200
     2.444    41.180     0.200
     3.459    55.680     0.200
     4.401    70.180     0.200
     4.870    73.883     0.200
     5.635    81.680     0.200
     7.293   106.883     0.200
     2.345    39.668     0.200
     2.236    40.168     0.200
     2.574    44.168     0.200
     2.613    44.867     0.200
     2.680    44.270     0.200
     2.820    47.566     0.200
     2.879    49.168     0.200
     3.160    51.168     0.200
     3.945    62.867     0.200
     3.945    64.270     0.200
     5.019    78.969     0.200
     5.177    78.566     0.200
     5.279    83.469     0.200
     5.461    83.469     0.200
     6.112    91.668     0.200
     7.579   111.168     0.200
     7.792   115.168     0.200
     8.142   118.066     0.200
    10.276   151.367     0.200
    10.748   157.168     0.200
    10.748   157.668     0.200
    11.164   164.168     0.200
    11.367   165.168     0.200
    18.577   260.168     0.200
    18.577   260.469     0.200
     2.197    37.963     0.200
     2.701    45.062     0.200
     2.869    49.062     0.200
     3.131    50.762     0.200
     5.432    82.463     0.200
     2.179    36.461     0.200
     2.249    39.262     0.200
     2.600    43.863     0.200
     3.028    50.160     0.200
     3.971    63.262     0.200
     4.512    69.062     0.200
     4.547    70.961     0.200
     6.945   101.660     0.200
     1.972    35.000     0.200
     2.233    37.398     0.200
     2.482    41.195     0.200
     2.748    45.898     0.200
     3.325    53.602     0.200
     3.558    57.195     0.200
     4.834    75.102     0.200
     5.049    77.797     0.200
     1.953    33.492     0.200
     2.633    41.695     0.200
     3.073    48.594     0.200
     4.491    67.992     0.200
     5.400    81.695     0.200
     6.222    91.594     0.200
     9.873   142.594     0.200
     9.873   142.797     0.200
    11.558   166.594     0.200
    11.844   169.594     0.200
    14.260   200.094     0.200
    15.483   216.594     0.200
    16.668   230.594     0.200
    16.668   230.891     0.200
    18.623   257.594     0.200
    19.938   271.594     0.200
    19.938   272.195     0.200
    20.175   275.594     0.200
    20.597   280.594     0.200
    20.597   280.891     0.200
    20.802   280.594     0.200
     1.130    22.547     0.200
     1.137    22.547     0.200
     1.929    33.246     0.200
     2.379    41.148     0.200
     2.676    44.348     0.200
     3.113    50.348     0.200
     3.647    58.047     0.200
     4.169    65.246     0.200
     4.557    70.945     0.200
     5.473    83.547     0.200
     1.993    33.172     0.200
     1.993    34.172     0.200
     2.027    34.172     0.200
     2.465    39.672     0.200
     2.465    40.375     0.200
     2.492    41.672     0.200
     2.708    44.875     0.200
     3.522    56.172     0.200
     3.806    60.570     0.200
     3.862    59.672     0.200
     3.862    60.273     0.200
     3.862    60.570     0.200
     4.246    65.672     0.200
     4.798    73.672     0.200
     5.313    79.672     0.200
     5.313    79.875     0.200
     5.474    82.773     0.200
     5.561    84.172     0.200
     6.051    90.469     0.200
     6.675    99.070     0.200
     7.087   103.469     0.200
     7.728   111.773     0.200
     7.786   114.672     0.200
     8.045   113.875     0.200
     8.064   120.672     0.200
     9.126   133.875     0.200
     9.126   133.672     0.200
     9.768   142.172     0.200
    10.252   147.672     0.200
    10.706   151.375     0.200
    10.762   155.672     0.200
    10.762   155.875     0.200
    11.134   160.672     0.200
    11.312   162.172     0.200
    12.147   170.273     0.200
    13.438   187.172     0.200
    13.705   194.070     0.200
    14.183   197.172     0.200
    14.089   202.469     0.200
    14.624   203.070     0.200
    15.275   211.875     0.200
    15.267   215.672     0.200
    15.401   213.672     0.200
    16.365   226.570     0.200
    16.356   230.672     0.200
    19.304   267.969     0.200
    19.950   273.672     0.200
    19.950   274.570     0.200
    20.451   279.570     0.200
     1.245    24.117     0.200
     2.447    40.719     0.200
     2.493    42.023     0.200
     3.831    60.320     0.200
     4.214    65.922     0.200
     5.441    82.320     0.200
     2.451    41.461     0.200
     2.492    41.961     0.200
     2.684    45.664     0.200
     3.839    60.961     0.200
     4.222    66.164     0.200
     4.775    72.367     0.200
     5.449    82.766     0.200
     2.453    41.422     0.200
     2.490    41.922     0.200
     3.840    60.625     0.200
     4.776    74.625     0.200
     1.285    25.482     0.200
     2.466    39.982     0.200
     2.499    41.383     0.200
     5.328    80.883     0.200
     2.015    34.367     0.200
     2.456    40.270     0.200
     2.486    41.270     0.200
     2.572    42.969     0.200
     2.681    45.066     0.200
     3.838    59.469     0.200
     4.219    65.668     0.200
     4.774    73.969     0.200
     5.286    82.168     0.200
     5.446    82.770     0.200
     6.648    99.867     0.200
     7.701   112.969     0.200
     7.758   115.270     0.200
     1.270    24.208     0.200
     2.002    34.208     0.200
     2.448    41.108     0.200
     2.513    41.708     0.200
     4.246    65.708     0.200
     2.453    41.287     0.200
     2.494    41.988     0.200
     2.690    43.988     0.200
     3.844    59.988     0.200
     4.228    65.688     0.200
     5.456    81.988     0.200
     2.448    40.672     0.200
     2.494    41.375     0.200
     2.679    44.375     0.200
     3.835    60.172     0.200
     4.217    65.172     0.200
     5.445    81.977     0.200
     1.997    36.217     0.200
     2.468    40.816     0.200
     2.700    45.417     0.200
     2.002    35.068     0.200
     2.461    40.268     0.200
     2.488    41.367     0.200
     2.696    44.168     0.200
     4.234    66.268     0.200
     1.209    24.426     0.200
     1.811    32.625     0.200
     2.207    36.824     0.200
     3.036    50.125     0.200
     3.334    54.426     0.200
     3.979    62.926     0.200
     4.489    71.125     0.200
     4.540    70.523     0.200
     1.989    34.516     0.200
     2.461    39.516     0.200
     2.461    39.914     0.200
     2.461    39.715     0.200
     2.504    41.715     0.200
     2.719    45.516     0.200
     3.528    56.516     0.200
     3.869    60.516     0.200
     3.869    61.016     0.200
     4.256    66.617     0.200
     4.804    73.516     0.200
     4.804    74.215     0.200
     4.804    74.016     0.200
     5.329    79.516     0.200
     5.329    80.117     0.200
     5.486    83.414     0.200
     5.562    84.117     0.200
     6.053    91.016     0.200
     6.686    99.215     0.200
     7.744   113.516     0.200
     7.796   114.516     0.200
     7.796   114.414     0.200
     8.030   113.715     0.200
     8.076   118.516     0.200
     9.136   132.016     0.200
     9.136   131.914     0.200
     9.778   141.516     0.200
    10.262   147.516     0.200
    10.773   155.516     0.200
    11.143   161.516     0.200
    11.143   160.016     0.200
    11.320   162.516     0.200
    14.099   200.316     0.200
    15.281   216.715     0.200
    16.373   231.516     0.200
    16.893   238.516     0.200
    19.320   268.516     0.200
    20.467   280.316     0.200
    20.526   280.516     0.200
    20.526   281.215     0.200
     2.463    39.418     0.200
     2.499    41.418     0.200
     2.715    44.418     0.200
     3.867    61.219     0.200
     4.253    66.020     0.200
     4.803    72.020     0.200
     5.482    83.020     0.200
     7.738   112.418     0.200
     2.032    34.125     0.200
     2.422    38.023     0.200
     2.560    43.125     0.200
     2.526    41.328     0.200
     3.827    60.125     0.200
     4.762    73.625     0.200
     5.309    79.125     0.200
     5.309    82.023     0.200
     5.450    82.523     0.200
     5.604    84.727     0.200
     6.647    98.922     0.200
     2.040    34.789     0.200
     2.418    38.992     0.200
     2.524    41.391     0.200
     2.670    43.492     0.200
     3.818    59.195     0.200
     4.207    65.195     0.200
     4.753    73.195     0.200
     5.439    81.992     0.200
     1.272    25.254     0.200
     3.857    61.754     0.200
     4.235    66.754     0.200
     2.738    46.156     0.200
     3.900    62.156     0.200
     4.277    67.555     0.200
     4.836    74.453     0.200
     5.499    83.656     0.200
     2.512    41.511     0.200
     2.505    42.311     0.200
     2.688    45.011     0.200
     2.810    46.511     0.200
     3.956    62.511     0.200
     4.348    68.211     0.200
     4.891    75.511     0.200
     5.407    81.910     0.200
     5.577    84.910     0.200
     6.777   101.311     0.200
     7.819   115.311     0.200
     7.888   116.211     0.200
    10.865   160.511     0.200
    11.234   165.311     0.200
    11.409   165.410     0.200
     1.259    25.350     0.200
     2.442    40.750     0.200
     1.337    26.539     0.200
     2.161    37.539     0.200
     2.638    44.139     0.200
     2.699    43.238     0.200
     3.878    61.339     0.200
     5.355    81.238     0.200
     2.507    41.008     0.200
     2.649    44.211     0.200
     2.759    46.008     0.200
     3.915    61.414     0.200
     5.346    83.109     0.200
     5.515    86.711     0.200
     7.759   114.609     0.200
     2.157    36.441     0.200
     2.157    38.641     0.200
     2.633    44.840     0.200
     3.273    53.742     0.200
     3.911    64.441     0.200
     4.470    72.242     0.200
     6.904   101.242     0.200
     2.247    37.906     0.200
     2.300    39.105     0.200
     2.341    38.605     0.200
     2.449    40.605     0.200
     3.500    55.906     0.200
     3.841    60.605     0.200
     4.919    73.707     0.200
     7.341   106.707     0.200
     1.468    27.981     0.200
     1.722    30.981     0.200
     2.551    41.981     0.200
     2.866    45.581     0.200
     3.011    48.881     0.200
     3.953    63.981     0.200
     5.933    87.881     0.200
     6.023    89.881     0.200
     8.347   122.881     0.200
    11.305   165.281     0.200
    11.618   167.281     0.200
    17.956   249.281     0.200
    19.259   266.781     0.200
     2.233    38.539     0.200
     2.665    43.836     0.200
     2.692    45.539     0.200
     3.911    62.141     0.200
     2.252    39.688     0.200
     2.528    43.984     0.200
     3.409    57.188     0.200
     2.218    38.984     0.200
     2.464    40.188     0.200
     2.341    39.984     0.200
     2.403    40.383     0.200
     3.621    58.188     0.200
     3.945    62.586     0.200
     4.209    65.688     0.200
     4.562    70.781     0.200
     4.945    75.586     0.200
     5.144    78.781     0.200
     7.362   107.984     0.200
     7.470   109.984     0.200
    18.327   253.281     0.200
    18.814   262.484     0.200
     2.210    38.418     0.200
     2.439    41.516     0.200
     3.459    55.516     0.200
     3.792    59.719     0.200
     4.400    69.418     0.200
     4.865    74.816     0.200
     5.002    76.016     0.200
     6.218    92.516     0.200
     2.194    37.426     0.200
     2.304    37.426     0.200
     2.467    40.625     0.200
     3.402    54.426     0.200
     3.735    58.723     0.200
     4.092    64.523     0.200
     4.343    66.723     0.200
     4.829    71.926     0.200
     4.948    75.723     0.200
     6.162    92.324     0.200
     7.253   105.625     0.200
     2.124    37.125     0.200
     2.333    38.625     0.200
     2.430    41.430     0.200
     3.365    55.031     0.200
     3.680    58.828     0.200
     2.351    38.508     0.200
     2.409    41.109     0.200
     2.297    39.271     0.200
     2.368    39.871     0.200
     2.353    40.172     0.200
     3.222    52.771     0.200
     3.551    56.771     0.200
     4.116    66.172     0.200
     4.492    69.771     0.200
     4.959    75.672     0.200
     5.107    78.072     0.200
     6.321    94.672     0.200
     7.380   109.072     0.200
    10.674   157.971     0.200
    10.786   157.871     0.200
    10.786   157.271     0.200
    11.217   161.971     0.200
    18.732   260.271     0.200
    19.287   265.771     0.200
    20.005   275.771     0.200
    20.213   280.572     0.200
    20.614   284.271     0.200
     1.415    26.914     0.200
     2.155    37.016     0.200
     2.730    45.117     0.200
     2.717    44.117     0.200
     2.745    43.816     0.200
     3.964    62.016     0.200
     4.271    66.016     0.200
     4.425    67.816     0.200
     4.906    75.016     0.200
     5.126    76.715     0.200
     5.449    82.316     0.200
     6.692    99.016     0.200
     7.524   112.117     0.200
     7.785   114.016     0.200
     8.184   117.016     0.200
    10.274   149.816     0.200
    10.734   155.016     0.200
    10.909   159.117     0.200
    10.834   156.715     0.200
    11.164   161.215     0.200
    11.375   163.016     0.200
    20.423   279.215     0.200
     1.675    31.312     0.200
     4.257    67.012     0.200
     2.210    37.961     0.200
     2.652    43.367     0.200
     2.621    43.664     0.200
     3.850    61.062     0.200
     4.162    65.367     0.200
     4.792    74.164     0.200
     5.062    77.664     0.200
     5.346    80.367     0.200
     6.584    99.461     0.200
     1.685    30.906     0.200
     2.304    39.605     0.200
     2.842    46.707     0.200
     2.842    46.605     0.200
     3.081    50.605     0.200
     4.267    67.207     0.200
     4.267    67.004     0.200
     4.622    71.707     0.200
     5.205    80.707     0.200
     5.205    80.605     0.200
     5.164    79.605     0.200
     5.667    86.805     0.200
     5.823    87.605     0.200
     7.049   104.105     0.200
     2.225    34.582     0.200
     2.629    43.281     0.200
     2.564    44.240     0.200
     3.570    58.340     0.200
     3.953    63.240     0.200
     5.187    80.240     0.200
     5.802    88.141     0.200
     2.597    43.265     0.200
     2.825    45.765     0.200
     3.252    52.265     0.200
     4.777    73.665     0.200
     1.497    27.848     0.200
     2.183    37.848     0.200
     2.183    37.246     0.200
     2.728    44.145     0.200
     2.778    45.445     0.200
     2.838    46.445     0.200
     4.059    64.047     0.200
     4.059    63.746     0.200
     4.379    68.348     0.200
     5.000    76.848     0.200
     7.897   116.848     0.200
     2.226    38.602     0.200
     2.380    40.303     0.200
     2.380    39.902     0.200
     2.380    40.803     0.200
     2.858    46.902     0.200
     3.254    51.502     0.200
     3.472    56.502     0.200
     3.639    58.102     0.200
     4.471    70.102     0.200
     4.756    72.502     0.200
     4.813    74.703     0.200
     4.813    74.602     0.200
     5.180    79.203     0.200
     5.295    79.602     0.200
     5.748    87.502     0.200
     5.977    89.402     0.200
     6.375    95.303     0.200
     7.311   105.803     0.200
     7.542   108.740     0.200
     7.606   111.703     0.200
     8.344   121.703     0.200
     8.706   127.303     0.200
    10.483   150.203     0.200
    10.690   155.902     0.200
    11.186   160.902     0.200
    11.661   168.803     0.200
    12.072   175.303     0.200
    12.260   176.102     0.200
    16.538   230.902     0.200
    16.948   237.963     0.200
    20.120   276.803     0.200
    20.427   278.703     0.200
    20.663   281.902     0.200
     2.663    43.877     0.200
     2.895    47.077     0.200
     3.444    52.677     0.200
     4.143    64.677     0.200
     2.102    36.055     0.200
     2.057    35.656     0.200
     2.661    44.055     0.200
     3.223    52.156     0.200
     3.593    56.859     0.200
     2.171    37.816     0.200
     2.426    42.418     0.200
     2.567    44.316     0.200
     2.568    44.418     0.200
     2.526    44.117     0.200
     2.859    47.816     0.200
     3.406    54.117     0.200
     3.662    57.418     0.200
     4.343    68.516     0.200
     5.144    78.316     0.200
     5.459    83.316     0.200
     6.084    93.117     0.200
     1.212    25.572     0.200
     2.153    37.972     0.200
     2.627    45.072     0.200
     2.627    44.872     0.200
     3.002    49.772     0.200
     3.002    49.572     0.200
     3.313    54.272     0.200
     3.945    63.872     0.200
     3.945    63.272     0.200
     4.529    70.772     0.200
     4.510    70.572     0.200
     4.510    69.172     0.200
     4.685    74.372     0.200
     5.740    88.072     0.200
     6.844   104.772     0.200
     6.844   104.472     0.200
     6.944   104.672     0.200
    10.407   152.572     0.200
     0.901    18.465     0.200
     2.058    34.965     0.200
     2.102    35.766     0.200
     2.661    43.363     0.200
     3.225    51.363     0.200
     3.225    51.465     0.200
     3.595    56.363     0.200
     4.164    63.566     0.200
     4.833    73.164     0.200
     6.024    89.066     0.200
     2.522    41.164     0.200
     2.749    43.164     0.200
     3.169    50.961     0.200
     4.706    71.562     0.200
     5.250    76.867     0.200
     1.004    21.176     0.200
     2.504    42.074     0.200
     3.542    56.375     0.200
     1.964    35.312     0.200
     2.990    49.914     0.200
     3.028    49.008     0.200
     1.561    30.117     0.200
     1.561    31.117     0.200
     2.346    40.922     0.200
     2.915    48.023     0.200
     3.527    56.922     0.200
     3.677    58.117     0.200
     4.025    66.117     0.200
     4.388    68.820     0.200
     4.533    70.820     0.200
     4.839    75.422     0.200
     4.853    75.219     0.200
     5.046    78.219     0.200
     5.414    83.320     0.200
     5.782    89.617     0.200
     5.782    88.117     0.200
     6.127    92.523     0.200
     6.725    98.047     0.200
     7.434   110.523     0.200
     7.725   114.023     0.200
     7.754   113.219     0.200
     7.919   117.820     0.200
     7.919   119.078     0.200
     8.079   120.523     0.200
     8.492   124.922     0.200
     8.628   127.219     0.200
     8.761   128.617     0.200
     8.956   130.617     0.200
     9.741   144.719     0.200
     9.915   144.117     0.200
    11.376   167.422     0.200
    12.178   176.023     0.200
    16.196   227.219     0.200
    16.196   227.461     0.200
     2.259    39.891     0.200
     2.406    41.391     0.200
     2.538    41.391     0.200
     2.538    41.688     0.200
     3.645    58.492     0.200
     3.645    57.188     0.200
     3.947    62.586     0.200
     4.587    72.086     0.200
     4.891    75.492     0.200
     6.369    96.289     0.200
     7.304   108.289     0.200
     7.304   107.289     0.200
     7.464   111.391     0.200
     2.335    40.008     0.200
     2.792    46.809     0.200
     2.878    46.309     0.200
     3.041    50.008     0.200
     3.729    59.109     0.200
     3.883    62.910     0.200
     4.221    64.707     0.200
     4.582    71.309     0.200
     5.158    79.809     0.200
     5.215    79.707     0.200
     5.717    86.207     0.200
     6.757   101.609     0.200
     7.663   111.008     0.200
     7.895   116.410     0.200
     2.313    40.319     0.200
     2.313    39.819     0.200
     2.806    47.020     0.200
     3.039    50.319     0.200
     3.442    56.319     0.200
     3.717    58.719     0.200
     4.146    66.319     0.200
     4.224    66.520     0.200
     4.224    66.020     0.200
     4.580    71.520     0.200
     4.580    71.419     0.200
     5.162    78.819     0.200
     5.162    78.419     0.200
     5.203    79.219     0.200
     5.703    86.419     0.200
     5.782    87.719     0.200
     6.761   101.020     0.200
     7.006   104.719     0.200
     7.880   116.419     0.200
     7.880   116.719     0.200
    15.697   218.719     0.200
     2.396    40.639     0.200
     2.396    40.338     0.200
     2.530    41.938     0.200
     3.345    52.838     0.200
     3.831    60.639     0.200
     4.695    72.238     0.200
     5.372    81.838     0.200
     5.372    81.338     0.200
     2.209    37.514     0.200
     2.209    37.914     0.200
     2.292    39.014     0.200
     2.592    43.613     0.200
     2.592    43.813     0.200
     3.451    55.214     0.200
     3.829    60.714     0.200
     4.389    69.414     0.200
     5.065    77.414     0.200
     7.080   105.313     0.200
     2.505    40.914     0.200
     2.499    42.016     0.200
     2.598    44.914     0.200
     2.789    46.109     0.200
     3.596    57.711     0.200
     3.733    59.516     0.200
     3.733    60.711     0.200
     3.938    61.711     0.200
     3.938    61.914     0.200
     4.327    67.609     0.200
     4.873    74.914     0.200
     4.873    75.516     0.200
     5.386    81.016     0.200
     5.556    84.312     0.200
     5.556    83.312     0.200
     6.756   100.812     0.200
     6.756   101.109     0.200
     7.798   113.609     0.200
     7.867   116.109     0.200
     2.489    42.418     0.200
     2.454    40.719     0.200
     2.454    40.418     0.200
     2.499    42.020     0.200
     2.684    44.621     0.200
     3.500    55.820     0.200
     3.840    60.621     0.200
     3.840    60.820     0.200
     3.828    60.520     0.200
     3.828    61.121     0.200
     4.092    63.918     0.200
     4.222    66.020     0.200
     4.776    73.621     0.200
     5.291    79.621     0.200
     5.449    82.520     0.200
     6.064    91.121     0.200
     6.651    98.820     0.200
     7.459   107.590     0.200
     7.462   109.820     0.200
     7.486   111.320     0.200
     7.706   111.719     0.200
     7.761   114.418     0.200
     8.069   118.020     0.200
     8.069   115.461     0.200
     8.173   118.918     0.200
    11.133   161.320     0.200
    11.292   161.918     0.200
    14.090   203.520     0.200
    14.090   200.371     0.200
    15.822   223.418     0.200
    17.484   242.320     0.200
    19.507   267.418     0.200
    19.962   274.621     0.200
    20.318   278.750     0.200
    20.961   285.320     0.200
     2.445    40.812     0.200
     2.445    39.812     0.200
     2.502    41.414     0.200
     2.505    42.012     0.200
     2.691    44.414     0.200
     3.502    56.613     0.200
     3.826    60.211     0.200
     3.843    60.312     0.200
     3.843    60.211     0.200
     4.097    63.312     0.200
     4.229    65.711     0.200
     4.778    72.812     0.200
     4.778    73.914     0.200
     5.306    79.613     0.200
     5.458    82.012     0.200
     6.658    98.711     0.200
     2.452    40.891     0.200
     2.499    41.789     0.200
     2.499    41.891     0.200
     2.507    41.691     0.200
     2.695    44.492     0.200
     3.821    61.191     0.200
     3.848    60.789     0.200
     3.848    60.391     0.200
     4.091    63.891     0.200
     4.233    65.891     0.200
     4.784    74.492     0.200
     6.662    99.590     0.200
     1.159    24.073     0.200
     2.384    40.773     0.200
     2.473    41.473     0.200
     2.535    42.473     0.200
     3.729    59.373     0.200
     4.076    64.073     0.200
     5.286    80.573     0.200
     6.503    96.973     0.200
     2.462    41.782     0.200
     2.481    42.082     0.200
     2.687    44.682     0.200
     3.845    60.782     0.200
     4.225    65.982     0.200
     5.451    82.682     0.200
     6.654    99.382     0.200
     2.063    36.150     0.200
     2.449    40.450     0.200
     2.449    39.850     0.200
     2.481    41.050     0.200
     2.661    44.550     0.200
     3.821    60.450     0.200
     3.821    60.150     0.200
     3.871    60.850     0.200
     4.200    65.450     0.200
     5.586    84.650     0.200
     1.229    24.950     0.200
     2.482    42.450     0.200
     4.193    66.051     0.200
     2.444    41.465     0.200
     2.626    44.365     0.200
     4.166    65.465     0.200
     2.076    36.526     0.200
     2.445    41.026     0.200
     2.477    42.127     0.200
     2.477    42.327     0.200
     2.646    44.727     0.200
     3.807    60.827     0.200
     3.807    59.427     0.200
     3.860    63.127     0.200
     3.860    62.427     0.200
     4.110    64.727     0.200
     4.184    65.927     0.200
     4.744    74.227     0.200
     5.250    79.427     0.200
     5.250    82.026     0.200
     5.409    82.526     0.200
     5.409    82.627     0.200
     5.593    82.927     0.200
     6.078    91.626     0.200
     7.421   110.026     0.200
     7.666   111.927     0.200
     7.722   114.728     0.200
     7.722   114.327     0.200
     8.133   119.827     0.200
     2.450    40.887     0.200
     2.450    40.086     0.200
     2.525    41.785     0.200
     2.517    41.785     0.200
     2.517    41.887     0.200
     2.718    44.984     0.200
     3.865    60.484     0.200
     3.865    60.086     0.200
     3.805    60.785     0.200
     3.805    61.387     0.200
     3.992    62.184     0.200
     4.087    63.785     0.200
     4.087    63.984     0.200
     4.255    65.785     0.200
     4.800    73.586     0.200
     4.800    73.984     0.200
     5.335    81.684     0.200
     5.335    80.086     0.200
     7.751   112.387     0.200
     7.885   112.887     0.200
     8.026   114.285     0.200
     8.326   118.785     0.200
     2.044    35.445     0.200
     2.044    35.945     0.200
     2.452    41.047     0.200
     2.452    40.250     0.200
     2.495    42.148     0.200
     2.502    42.148     0.200
     2.689    45.047     0.200
     3.825    61.648     0.200
     3.825    61.047     0.200
     3.825    60.945     0.200
     3.844    60.750     0.200
     4.005    62.344     0.200
     4.092    63.945     0.200
     4.227    66.148     0.200
     4.227    66.047     0.200
     4.466    69.148     0.200
     4.779    74.844     0.200
     5.298    80.844     0.200
     5.455    82.844     0.200
     7.714   112.750     0.200
     7.920   115.148     0.200
     1.246    25.305     0.200
     2.484    42.109     0.200
     2.674    44.305     0.200
     3.832    60.305     0.200
     4.011    65.211     0.200
     2.447    39.738     0.200
     2.447    40.438     0.200
     2.499    41.638     0.200
     2.500    42.138     0.200
     2.687    44.537     0.200
     3.499    56.037     0.200
     3.499    56.138     0.200
     3.840    60.838     0.200
     3.840    60.638     0.200
     3.829    60.537     0.200
     3.829    58.838     0.200
     4.000    62.238     0.200
     4.225    65.638     0.200
     4.225    65.838     0.200
     4.097    63.838     0.200
     4.468    68.037     0.200
     4.776    73.738     0.200
     5.299    79.338     0.200
     5.453    82.438     0.200
     5.453    82.238     0.200
     5.581    81.338     0.200
     6.654    99.037     0.200
     7.466   109.738     0.200
     7.490   110.238     0.200
     7.470   107.138     0.200
     7.764   114.438     0.200
     7.715   112.037     0.200
     7.715   111.838     0.200
     7.992   117.838     0.200
     7.921   113.238     0.200
     8.062   114.738     0.200
     8.062   115.108     0.200
     9.042   131.438     0.200
     9.042   131.738     0.200
     9.104   132.838     0.200
     9.746   140.238     0.200
     9.746   139.677     0.200
     9.746   140.838     0.200
    10.230   147.537     0.200
    10.230   149.338     0.200
    10.741   155.537     0.200
    10.741   155.838     0.200
    11.027   157.738     0.200
    11.112   160.037     0.200
    11.289   162.037     0.200
    11.289   162.238     0.200
    11.141   157.537     0.200
    13.451   187.438     0.200
    14.100   200.438     0.200
    14.100   199.698     0.200
    14.642   207.338     0.200
    14.604   206.438     0.200
    15.417   214.037     0.200
    16.201   229.838     0.200
    16.351   230.838     0.200
    16.680   232.738     0.200
    17.482   242.128     0.200
    18.256   250.738     0.200
    18.966   263.638     0.200
    19.504   267.138     0.200
    20.448   279.037     0.200
     2.062    35.719     0.200
     2.444    40.316     0.200
     2.482    42.316     0.200
     2.491    41.816     0.200
     2.667    44.020     0.200
     3.484    55.816     0.200
     3.824    60.316     0.200
     3.845    61.520     0.200
     3.845    62.020     0.200
     4.002    62.816     0.200
     4.205    65.520     0.200
     4.205    65.418     0.200
     4.105    64.020     0.200
     4.105    63.617     0.200
     4.488    69.219     0.200
     4.760    74.219     0.200
     5.277    80.316     0.200
     5.432    82.020     0.200
     6.634    98.816     0.200
     6.634    98.918     0.200
     7.456   106.418     0.200
     7.693   112.316     0.200
     7.744   114.219     0.200
     7.943   113.520     0.200
     8.084   115.617     0.200
     8.084   114.957     0.200
     8.384   119.219     0.200
    11.005   162.316     0.200
    11.277   162.699     0.200
     2.451    40.445     0.200
     2.491    42.039     0.200
     2.488    41.641     0.200
     2.488    41.344     0.200
     2.676    44.242     0.200
     3.833    59.141     0.200
     4.008    61.945     0.200
     4.214    65.141     0.200
     5.581    84.945     0.200
     7.936   113.539     0.200
     2.167    38.062     0.200
     2.643    44.867     0.200
     3.881    62.062     0.200
     3.927    62.961     0.200
     4.184    65.961     0.200
     2.483    41.292     0.200
     2.444    39.992     0.200
     2.444    40.492     0.200
     2.491    41.893     0.200
     2.668    44.492     0.200
     3.824    60.692     0.200
     3.824    60.992     0.200
     3.844    61.692     0.200
     4.206    65.992     0.200
     4.104    64.192     0.200
     4.760    75.192     0.200
     5.278    78.893     0.200
     5.278    79.393     0.200
     5.433    82.092     0.200
     5.433    83.092     0.200
     5.588    82.992     0.200
     6.635    99.192     0.200
     7.128   105.492     0.200
     7.445   109.692     0.200
     7.455   107.893     0.200
     7.693   111.992     0.200
     7.745   114.292     0.200
     7.745   116.292     0.200
     7.942   113.492     0.200
     8.157   119.393     0.200
     9.022   131.692     0.200
     9.727   141.692     0.200
    11.006   159.292     0.200
    11.272   164.492     0.200
    11.277   161.682     0.200
     2.057    36.043     0.200
     2.439    40.141     0.200
     2.504    41.941     0.200
     2.504    41.441     0.200
     2.491    41.242     0.200
     2.679    44.141     0.200
     3.837    61.141     0.200
     3.832    60.141     0.200
     4.105    63.941     0.200
     4.217    65.340     0.200
     5.446    81.840     0.200
     6.646    99.340     0.200
     7.711   111.941     0.200
     7.926   113.941     0.200
     2.440    41.455     0.200
     2.495    41.955     0.200
     2.495    42.756     0.200
     2.664    43.955     0.200
     3.820    59.756     0.200
     3.875    61.855     0.200
     4.202    65.555     0.200
     1.411    27.672     0.200
     4.172    66.375     0.200
     1.286    25.719     0.200
     2.088    36.818     0.200
     2.088    37.019     0.200
     2.449    41.919     0.200
     2.449    42.219     0.200
     2.522    43.019     0.200
     3.789    60.019     0.200
     3.789    60.818     0.200
     4.059    64.419     0.200
     5.219    80.219     0.200
     6.474    97.219     0.200
     2.320    40.363     0.200
     2.320    39.766     0.200
     3.029    50.266     0.200
     4.570    71.164     0.200
     2.311    40.105     0.200
     2.311    39.906     0.200
     2.801    46.105     0.200
     2.801    45.906     0.200
     3.030    49.707     0.200
     3.451    55.105     0.200
     3.451    56.504     0.200
     3.451    56.105     0.200
     3.723    58.906     0.200
     3.723    59.406     0.200
     4.156    65.406     0.200
     4.215    66.305     0.200
     4.215    66.105     0.200
     4.571    70.906     0.200
     4.571    71.406     0.200
     5.772    87.707     0.200
     6.770   101.707     0.200
     6.997   105.105     0.200
     6.997   104.305     0.200
     7.831   113.305     0.200
     7.872   116.004     0.200
     7.872   115.504     0.200
     1.613    31.086     0.200
     1.708    31.992     0.200
     2.631    44.992     0.200
     2.951    49.391     0.200
     3.249    53.688     0.200
     4.460    70.492     0.200
     6.876   101.992     0.200
     2.326    40.797     0.200
     2.784    45.594     0.200
     3.021    49.695     0.200
     3.463    56.195     0.200
     3.739    59.195     0.200
     4.204    66.297     0.200
     4.562    70.992     0.200
     4.562    71.094     0.200
     5.141    78.797     0.200
     5.141    79.695     0.200
     5.225    77.492     0.200
     5.766    87.094     0.200
     6.989   104.195     0.200
     6.989   104.594     0.200
     7.874   115.797     0.200
     2.185    38.301     0.200
     2.185    38.000     0.200
     2.590    43.500     0.200
     2.929    49.500     0.200
     3.116    51.199     0.200
     4.771    72.902     0.200
     4.771    72.801     0.200
     5.178    80.402     0.200
     6.400    95.699     0.200
     8.472   125.602     0.200
     2.478    41.562     0.200
     2.781    45.469     0.200
     2.781    44.766     0.200
     3.505    57.367     0.200
     3.790    60.469     0.200
     3.904    61.766     0.200
     3.816    60.867     0.200
     3.816    60.766     0.200
     4.069    64.367     0.200
     4.759    73.867     0.200
     4.845    74.766     0.200
     5.403    79.766     0.200
     6.480    97.664     0.200
     7.243   106.664     0.200
     7.563   111.766     0.200
     7.563   111.664     0.200
     8.460   123.664     0.200
     9.547   138.266     0.200
     9.547   138.469     0.200
    10.064   146.062     0.200
    10.497   150.867     0.200
    10.636   152.766     0.200
    10.811   153.969     0.200
    10.920   157.688     0.200
    16.282   225.766     0.200
     2.019    36.078     0.200
     2.782    45.781     0.200
     3.786    60.281     0.200
     3.819    60.984     0.200
     3.819    59.680     0.200
     3.900    61.680     0.200
     4.073    64.281     0.200
     4.073    64.383     0.200
     4.762    73.984     0.200
     5.221    79.984     0.200
     5.400    80.281     0.200
     7.247   106.484     0.200
     7.568   112.078     0.200
     2.392    40.918     0.200
     3.560    56.617     0.200
     3.892    61.418     0.200
     3.892    61.617     0.200
     5.098    77.918     0.200
     7.349   107.617     0.200
     1.010    20.590     0.200
     2.219    37.790     0.200
     2.355    39.790     0.200
     2.402    39.890     0.200
     2.402    40.290     0.200
     2.396    39.690     0.200
     2.396    40.990     0.200
     3.563    56.990     0.200
     3.563    55.790     0.200
     3.897    61.390     0.200
     4.109    65.690     0.200
     7.356   107.290     0.200
     1.004    21.281     0.200
     2.209    38.781     0.200
     2.342    40.781     0.200
     2.404    41.375     0.200
     2.404    40.078     0.200
     2.390    41.281     0.200
     2.390    40.977     0.200
     3.554    57.078     0.200
     3.884    61.477     0.200
     2.347    40.355     0.200
     2.389    41.254     0.200
     3.558    56.754     0.200
     3.888    61.754     0.200
     5.094    77.957     0.200
     5.935    89.254     0.200
     6.314    94.754     0.200
     7.343   107.457     0.200
     1.048    22.125     0.200
     1.048    23.324     0.200
     2.204    38.422     0.200
     2.204    37.723     0.200
     2.527    43.324     0.200
     2.696    45.223     0.200
     3.635    59.223     0.200
     4.057    64.023     0.200
     4.566    72.125     0.200
     4.566    70.922     0.200
     5.312    81.922     0.200
     7.700   112.723     0.200
     2.217    38.117     0.200
     2.354    40.117     0.200
     2.396    40.922     0.200
     3.562    56.820     0.200
     3.895    61.320     0.200
     3.895    61.516     0.200
     4.503    70.320     0.200
     4.503    70.016     0.200
     4.935    75.719     0.200
     5.102    77.922     0.200
     5.731    86.719     0.200
     6.321    94.516     0.200
     6.321    94.617     0.200
     7.354   107.219     0.200
     7.354   107.320     0.200
     7.424   109.320     0.200
    10.985   157.820     0.200
     1.648    30.211     0.200
     2.309    39.711     0.200
     2.813    46.109     0.200
     2.813    45.812     0.200
     2.887    47.609     0.200
     3.045    49.812     0.200
     3.343    54.312     0.200
     3.436    54.609     0.200
     3.436    57.312     0.200
     3.436    56.812     0.200
     3.710    58.914     0.200
     3.893    62.109     0.200
     4.141    64.609     0.200
     4.231    66.211     0.200
     4.586    71.414     0.200
     5.168    79.812     0.200
     5.168    79.414     0.200
     5.787    87.711     0.200
     5.787    87.812     0.200
     6.630    99.414     0.200
     6.755   101.008     0.200
     7.012   104.414     0.200
     7.386   107.914     0.200
     7.790   115.109     0.200
     7.882   115.211     0.200
     7.819   115.008     0.200
     8.114   118.711     0.200
     8.497   124.914     0.200
    10.097   148.008     0.200
    10.802   155.008     0.200
    11.273   162.711     0.200
    11.478   165.812     0.200
    11.554   166.250     0.200
    11.670   168.312     0.200
     1.517    28.328     0.200
     1.517    28.125     0.200
     2.494    41.828     0.200
     2.698    45.023     0.200
     2.698    44.828     0.200
     2.769    45.922     0.200
     3.005    49.328     0.200
     3.606    58.328     0.200
     3.745    59.922     0.200
     4.141    65.023     0.200
     4.098    64.422     0.200
     4.535    70.523     0.200
     5.024    77.523     0.200
     5.024    78.328     0.200
     5.670    87.227     0.200
     5.787    87.125     0.200
     5.787    87.023     0.200
     6.622    98.922     0.200
     7.696   110.523     0.200
     7.749   112.625     0.200
     8.085   117.625     0.200
     8.520   124.422     0.200
    10.063   148.125     0.200
    11.073   161.922     0.200
    11.165   160.125     0.200
    11.395   164.227     0.200
    11.410   164.328     0.200
    11.665   168.586     0.200
     1.522    28.351     0.200
     1.522    29.450     0.200
     2.711    45.150     0.200
     2.711    44.950     0.200
     3.013    49.650     0.200
     4.101    64.650     0.200
     4.542    70.450     0.200
     5.796    87.150     0.200
     1.477    27.239     0.200
     2.351    40.040     0.200
     2.403    41.040     0.200
     2.403    40.739     0.200
     3.558    56.640     0.200
     3.558    55.640     0.200
     4.499    69.939     0.200
     5.101    77.540     0.200
     6.319    94.340     0.200
     6.319    94.640     0.200
     2.150    37.971     0.200
     2.541    42.971     0.200
     2.541    43.871     0.200
     2.710    44.971     0.200
     2.710    44.471     0.200
     3.800    61.471     0.200
     3.918    62.070     0.200
     3.885    61.971     0.200
     4.183    66.170     0.200
     4.827    75.471     0.200
     5.043    77.270     0.200
     5.394    79.770     0.200
     6.603   100.570     0.200
     6.603    99.570     0.200
     7.107   105.170     0.200
     7.178   107.871     0.200
     7.444   109.770     0.200
     7.695   114.270     0.200
     8.271   120.170     0.200
    10.869   155.270     0.200
    10.821   156.820     0.200
    11.102   160.490     0.200
    11.290   165.371     0.200
    16.077   223.670     0.200
    19.086   265.020     0.200
    19.645   271.270     0.200
    20.763   284.070     0.200
     2.188    37.113     0.200
     2.188    36.914     0.200
     2.523    42.514     0.200
     2.675    43.113     0.200
     3.867    60.414     0.200
     4.174    65.014     0.200
     4.809    72.314     0.200
     5.422    78.814     0.200
     2.164    37.961     0.200
     2.164    38.258     0.200
     2.536    44.156     0.200
     2.640    44.859     0.200
     2.698    44.656     0.200
     2.698    44.156     0.200
     3.804    61.555     0.200
     3.879    62.055     0.200
     3.927    62.359     0.200
     4.181    65.961     0.200
     4.181    66.156     0.200
     4.821    76.156     0.200
     4.821    76.656     0.200
     6.202    93.461     0.200
     6.601    99.555     0.200
     7.694   113.555     0.200
     7.694   113.656     0.200
     8.266   120.555     0.200
    10.643   155.359     0.200
    10.825   157.055     0.200
    10.881   155.461     0.200
    11.106   160.602     0.200
    19.079   266.930     0.200
     1.212    25.113     0.200
     1.342    26.211     0.200
     2.163    38.312     0.200
     2.163    38.211     0.200
     2.540    43.613     0.200
     2.540    44.312     0.200
     2.701    45.012     0.200
     3.800    61.211     0.200
     3.884    62.211     0.200
     3.923    62.312     0.200
     4.185    66.312     0.200
     4.826    75.512     0.200
     4.826    75.613     0.200
     5.399    79.711     0.200
     6.606    98.910     0.200
     6.606    99.613     0.200
     7.454   110.512     0.200
     2.158    38.004     0.200
     2.158    37.805     0.200
     2.544    43.104     0.200
     2.706    44.805     0.200
     3.888    62.305     0.200
     4.189    66.205     0.200
     4.830    75.205     0.200
     4.830    75.604     0.200
     5.365    82.004     0.200
     5.365    82.404     0.200
     6.210    94.404     0.200
     6.609    99.205     0.200
     6.609    99.805     0.200
     7.454   109.604     0.200
     7.702   115.504     0.200
     8.261   121.205     0.200
    10.873   157.104     0.200
    11.111   160.344     0.200
     1.454    27.422     0.200
     2.373    40.023     0.200
     2.421    40.922     0.200
     2.421    40.422     0.200
     3.572    56.523     0.200
     3.572    55.227     0.200
     3.914    61.125     0.200
     4.098    62.727     0.200
     1.310    26.094     0.200
     2.465    41.594     0.200
     2.502    42.894     0.200
     2.502    42.594     0.200
     2.736    45.693     0.200
     3.773    61.193     0.200
     3.800    60.293     0.200
     3.896    61.793     0.200
     4.275    66.993     0.200
     4.275    67.293     0.200
     5.499    83.594     0.200
     6.703   100.493     0.200
     6.703   100.293     0.200
     7.059   105.394     0.200
     7.734   113.293     0.200
     7.734   112.493     0.200
     1.667    31.290     0.200
     2.160    37.890     0.200
     2.279    38.690     0.200
     2.488    42.790     0.200
     3.367    54.590     0.200
     3.701    59.290     0.200
     4.916    75.690     0.200
     5.908    86.790     0.200
     2.180    38.089     0.200
     2.636    44.689     0.200
     2.683    43.889     0.200
     3.871    61.689     0.200
     3.871    61.789     0.200
     4.813    74.989     0.200
     4.813    74.789     0.200
     5.356    81.789     0.200
     6.597    97.489     0.200
     6.597    99.189     0.200
     7.458   108.889     0.200
     2.434    41.367     0.200
     2.434    41.469     0.200
     2.480    42.469     0.200
     2.474    41.867     0.200
     2.645    43.469     0.200
     2.645    44.469     0.200
     3.818    59.672     0.200
     3.818    60.766     0.200
     4.184    65.766     0.200
     4.755    74.070     0.200
     4.755    74.172     0.200
     5.403    82.266     0.200
     5.565    80.570     0.200
     6.243    93.570     0.200
     6.613    98.969     0.200
     6.613    98.867     0.200
     7.413   109.672     0.200
     7.638   112.070     0.200
     7.720   114.070     0.200
     2.421    41.395     0.200
     2.488    42.195     0.200
     2.639    43.992     0.200
     2.639    44.492     0.200
     3.816    60.992     0.200
     4.179    65.895     0.200
     4.754    74.293     0.200
     4.754    74.395     0.200
     5.396    82.293     0.200
     5.396    82.395     0.200
     6.236    93.895     0.200
     6.607    98.695     0.200
     7.625   111.793     0.200
     7.714   114.395     0.200
     8.116   119.793     0.200
     1.231    25.219     0.200
     2.427    41.520     0.200
     2.468    42.219     0.200
     2.481    41.117     0.200
     2.481    41.918     0.200
     2.636    43.918     0.200
     2.636    44.617     0.200
     3.475    56.316     0.200
     3.812    60.918     0.200
     3.761    60.719     0.200
     3.855    61.316     0.200
     3.870    62.020     0.200
     4.176    66.117     0.200
     4.749    74.418     0.200
     4.749    73.918     0.200
     5.212    79.316     0.200
     5.394    82.617     0.200
     6.234    93.918     0.200
     6.604    98.816     0.200
     7.382   107.188     0.200
     7.404   109.719     0.200
     7.432   110.117     0.200
     7.626   111.816     0.200
     7.626   111.918     0.200
     7.711   113.816     0.200
     8.140   118.719     0.200
     8.987   132.918     0.200
     9.694   141.418     0.200
    10.682   155.617     0.200
    11.222   163.598     0.200
    11.252   162.816     0.200
     2.438    41.344     0.200
     2.438    41.047     0.200
     2.474    41.344     0.200
     2.474    41.945     0.200
     2.468    41.945     0.200
     2.468    41.750     0.200
     2.639    44.445     0.200
     3.762    60.047     0.200
     3.811    60.750     0.200
     3.856    62.648     0.200
     4.178    65.945     0.200
     4.178    65.250     0.200
     4.749    74.750     0.200
     5.221    78.148     0.200
     5.398    82.445     0.200
     5.398    82.148     0.200
     6.238    93.945     0.200
     6.607    99.047     0.200
     7.635   113.250     0.200
     2.132    37.039     0.200
     2.803    45.141     0.200
     2.803    45.844     0.200
     3.783    59.945     0.200
     4.045    63.945     0.200
     4.987    76.742     0.200
     4.987    77.141     0.200
     5.526    83.945     0.200
     6.371    95.742     0.200
     6.772   101.445     0.200
     6.772   101.344     0.200
     7.522   111.539     0.200
     7.577   110.844     0.200
     2.126    36.875     0.200
     2.126    37.375     0.200
     2.698    43.875     0.200
     2.805    45.375     0.200
     2.805    45.969     0.200
     3.783    60.273     0.200
     4.042    63.875     0.200
     4.042    64.070     0.200
     4.984    76.969     0.200
     5.521    84.070     0.200
     6.366    95.875     0.200
     6.767   100.469     0.200
     6.767   102.273     0.200
     7.570   111.070     0.200
     2.667    44.480     0.200
     2.819    45.883     0.200
     2.503    41.781     0.200
     2.669    43.582     0.200
     3.025    49.582     0.200
     3.203    51.082     0.200
     4.136    64.980     0.200
     5.673    85.781     0.200
     2.486    42.289     0.200
     2.529    43.289     0.200
     2.529    43.188     0.200
     2.715    44.789     0.200
     2.913    47.488     0.200
     2.990    47.391     0.200
     3.273    52.590     0.200
     3.453    55.090     0.200
     3.453    54.891     0.200
     5.641    84.188     0.200
     8.125   120.090     0.200
     2.472    42.359     0.200
     2.472    41.953     0.200
     2.493    40.953     0.200
     2.493    41.758     0.200
     2.547    43.156     0.200
     2.730    45.555     0.200
     3.808    60.359     0.200
     3.888    60.359     0.200
     3.888    62.055     0.200
     4.269    66.953     0.200
     4.427    67.953     0.200
     4.824    73.758     0.200
     4.824    74.758     0.200
     5.533    81.758     0.200
     5.493    83.359     0.200
     6.697   100.156     0.200
     7.807   115.555     0.200
     1.779    32.711     0.200
     1.874    34.117     0.200
     1.874    34.414     0.200
     2.248    37.617     0.200
     3.118    51.117     0.200
     3.118    51.016     0.200
     3.415    55.312     0.200
     3.415    55.117     0.200
     4.633    72.117     0.200
     4.618    71.516     0.200
     4.618    71.211     0.200
     5.839    88.016     0.200
     6.940   105.117     0.200
     6.967   101.812     0.200
     2.161    36.492     0.200
     2.885    45.191     0.200
     3.099    48.594     0.200
     3.099    48.492     0.200
     3.267    50.594     0.200
     3.480    51.293     0.200
     3.673    57.094     0.200
     3.759    57.691     0.200
     4.714    71.293     0.200
     5.196    77.992     0.200
     5.628    85.793     0.200
     5.628    84.891     0.200
     6.462    95.594     0.200
    19.619   266.867     0.200
     1.752    30.345     0.200
     2.666    41.244     0.200
     2.666    41.744     0.200
     2.718    43.544     0.200
     3.242    51.044     0.200
     3.388    52.845     0.200
     3.388    52.444     0.200
     3.862    59.444     0.200
     4.330    65.845     0.200
     4.772    72.345     0.200
     4.772    72.244     0.200
     6.022    88.744     0.200
     6.022    88.444     0.200
     1.602    29.616     0.200
     1.602    30.116     0.200
     1.689    32.016     0.200
     2.668    44.416     0.200
     3.703    58.516     0.200
     4.002    62.616     0.200
     4.183    65.316     0.200
     4.183    65.216     0.200
     4.943    75.816     0.200
     4.943    75.516     0.200
     5.273    80.116     0.200
     6.121    91.716     0.200
     6.572    97.816     0.200
     6.572    97.416     0.200
     7.097   104.116     0.200
     7.097   104.616     0.200
     1.589    30.406     0.200
     2.300    39.508     0.200
     2.776    45.203     0.200
     2.776    45.305     0.200
     2.980    48.609     0.200
     2.980    49.008     0.200
     3.403    55.305     0.200
     3.497    56.406     0.200
     3.514    56.109     0.200
     3.753    59.805     0.200
     4.170    65.508     0.200
     4.522    70.406     0.200
     4.522    70.305     0.200
     5.108    78.508     0.200
     5.108    78.406     0.200
     5.722    86.609     0.200
     6.564    98.305     0.200
     6.948   103.406     0.200
     7.361   106.406     0.200
     7.725   114.008     0.200
     7.826   114.305     0.200
     7.880   113.406     0.200
     7.880   113.180     0.200
     8.049   118.109     0.200
     8.432   123.703     0.200
    10.829   153.906     0.200
    11.009   160.305     0.200
    11.211   161.609     0.200
    11.414   165.805     0.200
    11.492   165.688     0.200
    11.607   167.203     0.200
    12.881   182.203     0.200
    13.277   186.109     0.200
    14.252   201.906     0.200
    14.913   211.508     0.200
    18.011   250.109     0.200
    19.297   267.648     0.200
    19.297   267.953     0.200
    19.851   273.305     0.200
    20.137   278.406     0.200
     1.557    27.969     0.200
     1.557    27.867     0.200
     2.034    34.570     0.200
     2.841    45.867     0.200
     2.894    45.664     0.200
     3.489    55.164     0.200
     3.562    55.570     0.200
     3.598    56.070     0.200
     3.598    56.664     0.200
     3.709    58.164     0.200
     4.094    63.266     0.200
     4.380    67.070     0.200
     5.037    76.867     0.200
     5.037    76.969     0.200
     5.540    82.766     0.200
     6.386    94.469     0.200
     6.796   100.164     0.200
     7.534   109.570     0.200
     7.530   110.070     0.200
     7.883   114.867     0.200
     7.883   114.969     0.200
     8.149   116.773     0.200
     8.230   119.766     0.200
    10.953   158.266     0.200
    11.239   160.609     0.200
    12.763   178.469     0.200
    18.231   249.867     0.200
    19.282   266.625     0.200
    19.870   272.766     0.200
     2.291    39.604     0.200
     2.785    45.004     0.200
     3.508    55.304     0.200
     4.174    65.704     0.200
     4.524    70.404     0.200
     5.231    78.404     0.200
     5.723    85.604     0.200
     2.847    46.297     0.200
     2.883    46.598     0.200
     2.883    46.895     0.200
     3.116    50.297     0.200
     3.116    50.598     0.200
     3.257    51.996     0.200
     3.710    59.195     0.200
     1.239    25.635     0.200
     2.103    38.535     0.200
     2.103    36.835     0.200
     2.682    45.335     0.200
     2.952    48.835     0.200
     3.894    62.635     0.200
     3.894    63.935     0.200
     4.704    72.735     0.200
     5.701    87.135     0.200
     6.946   104.735     0.200
     8.791   129.435     0.200
     2.786    44.879     0.200
     2.743    45.879     0.200
     2.871    49.180     0.200
     3.584    59.480     0.200
     3.578    57.980     0.200
     4.087    64.980     0.200
     4.412    69.582     0.200
     5.028    79.781     0.200
     5.598    85.781     0.200
     5.598    86.281     0.200
     1.666    32.062     0.200
     2.348    40.160     0.200
     2.348    40.660     0.200
     2.805    46.160     0.200
     2.805    46.262     0.200
     4.251    65.660     0.200
     4.251    67.062     0.200
     4.615    71.461     0.200
     5.187    80.863     0.200
     5.821    88.262     0.200
     5.821    88.562     0.200
     7.042   104.762     0.200
     7.042   105.863     0.200
     1.626    31.660     0.200
     2.349    39.559     0.200
     2.349    40.059     0.200
     2.776    45.461     0.200
     3.456    56.660     0.200
     3.456    57.262     0.200
     3.485    55.660     0.200
     4.211    66.859     0.200
     5.148    79.461     0.200
     5.781    87.660     0.200
     7.001   104.359     0.200
     7.001   104.859     0.200
     7.898   115.660     0.200
     7.898   117.859     0.200
     8.105   118.762     0.200
     1.625    32.041     0.200
     2.344    40.141     0.200
     3.458    57.441     0.200
     3.458    56.541     0.200
     3.485    55.840     0.200
     4.209    65.340     0.200
     4.209    66.441     0.200
     4.572    71.141     0.200
     5.146    81.141     0.200
     5.146    80.041     0.200
     5.778    87.340     0.200
     5.778    87.441     0.200
     6.620    99.340     0.200
     6.999   104.141     0.200
     6.999   105.041     0.200
     7.893   115.240     0.200
     1.486    28.719     0.200
     2.204    38.820     0.200
     2.760    44.820     0.200
     3.614    57.719     0.200
     3.621    58.523     0.200
     3.621    58.125     0.200
     3.806    60.820     0.200
     4.051    64.219     0.200
     4.375    68.625     0.200
     4.991    77.320     0.200
     5.288    77.320     0.200
     5.562    84.820     0.200
     6.405    96.125     0.200
     6.798   101.719     0.200
     7.646   113.523     0.200
     2.212    38.291     0.200
     2.212    38.490     0.200
     2.757    44.590     0.200
     2.757    45.090     0.200
     3.612    57.391     0.200
     3.618    58.391     0.200
     4.053    62.590     0.200
     4.053    64.191     0.200
     4.380    68.791     0.200
     4.994    76.891     0.200
     5.289    77.391     0.200
     5.567    84.691     0.200
     6.803   101.590     0.200
     7.654   112.791     0.200
     7.900   114.990     0.200
     1.138    24.383     0.200
     2.708    44.383     0.200
     2.710    45.682     0.200
     5.369    78.582     0.200
     2.260    39.734     0.200
     2.772    45.938     0.200
     2.926    49.234     0.200
     3.541    57.438     0.200
     3.549    56.938     0.200
     3.769    59.539     0.200
     4.269    65.734     0.200
     2.113    37.383     0.200
     2.755    46.281     0.200
     2.790    45.680     0.200
     3.660    57.883     0.200
     3.997    63.180     0.200
     4.295    67.383     0.200
     5.467    84.082     0.200
     1.412    28.602     0.200
     2.262    39.902     0.200
     2.430    42.301     0.200
     2.541    43.602     0.200
     2.541    43.500     0.200
     4.018    64.402     0.200
     3.971    62.703     0.200
     4.607    70.801     0.200
     5.158    78.902     0.200
     7.329   108.500     0.200
     2.256    39.086     0.200
     2.256    39.984     0.200
     2.540    41.883     0.200
     3.645    58.285     0.200
     4.041    64.586     0.200
     4.800    74.383     0.200
     4.889    73.984     0.200
     7.301   107.383     0.200
     7.301   108.586     0.200
     2.502    41.879     0.200
     2.498    42.281     0.200
     2.689    44.680     0.200
     3.843    60.582     0.200
     4.227    65.680     0.200
     1.546    30.201     0.200
     1.751    32.101     0.200
     2.288    39.701     0.200
     2.753    45.601     0.200
     2.780    47.601     0.200
     2.931    48.701     0.200
     3.542    59.201     0.200
     3.542    57.301     0.200
     3.555    56.601     0.200
     3.784    60.101     0.200
     4.124    65.601     0.200
     4.258    66.501     0.200
     4.472    70.101     0.200
     5.063    78.701     0.200
     5.671    86.001     0.200
     5.760    87.001     0.200
     2.459    40.258     0.200
     2.459    42.059     0.200
     2.485    42.355     0.200
     2.485    42.457     0.200
     2.687    44.855     0.200
     3.825    60.957     0.200
     3.825    62.656     0.200
     3.852    60.559     0.200
     3.844    60.957     0.200
     3.844    61.156     0.200
     4.225    66.156     0.200
     4.780    74.656     0.200
     4.780    75.059     0.200
     5.452    82.559     0.200
     6.654    99.656     0.200
     7.706   112.758     0.200
     8.175   121.957     0.200
     2.049    36.250     0.200
     2.446    40.148     0.200
     2.446    41.148     0.200
     2.500    42.047     0.200
     2.500    42.348     0.200
     2.498    42.648     0.200
     2.686    44.750     0.200
     3.859    60.348     0.200
     3.840    60.547     0.200
     3.840    60.848     0.200
     4.010    62.648     0.200
     4.224    66.148     0.200
     4.775    73.648     0.200
     6.653    99.547     0.200
     7.715   112.148     0.200
     7.715   112.848     0.200
     2.048    36.004     0.200
     2.450    40.305     0.200
     2.450    40.703     0.200
     2.498    41.703     0.200
     2.494    42.203     0.200
     2.684    44.805     0.200
     2.684    44.703     0.200
     3.830    61.004     0.200
     3.858    60.703     0.200
     3.839    61.605     0.200
     3.839    60.805     0.200
     4.016    63.305     0.200
     4.095    64.402     0.200
     4.222    66.305     0.200
     4.471    68.504     0.200
     4.775    74.805     0.200
     5.450    82.605     0.200
     6.288    95.703     0.200
     6.651    99.504     0.200
     7.761   115.305     0.200
     8.067   115.105     0.200
     1.557    29.990     0.200
     2.307    39.391     0.200
     2.750    44.791     0.200
     2.948    48.590     0.200
     4.490    69.791     0.200
     5.075    76.891     0.200
     2.280    40.035     0.200
     2.760    47.035     0.200
     2.784    46.936     0.200
     4.473    69.436     0.200
     1.011    23.934     0.200
     2.287    40.637     0.200
     2.284    40.434     0.200
     2.441    41.934     0.200
     2.561    43.637     0.200
     2.561    43.535     0.200
     3.595    57.035     0.200
     3.978    63.137     0.200
     4.092    64.637     0.200
     4.531    71.934     0.200
     5.213    79.836     0.200
     6.408    97.637     0.200
     2.223    37.712     0.200
     2.718    42.312     0.200
     2.783    45.911     0.200
     3.666    57.512     0.200
     3.855    60.512     0.200
     3.998    62.911     0.200
     4.324    67.111     0.200
     4.324    67.411     0.200
     5.513    83.212     0.200
     2.064    35.648     0.200
     2.064    36.148     0.200
     2.240    37.945     0.200
     2.859    46.148     0.200
     2.866    46.750     0.200
     2.866    47.945     0.200
     3.112    50.445     0.200
     3.401    54.047     0.200
     3.465    54.445     0.200
     3.576    56.445     0.200
     4.809    73.547     0.200
     4.809    72.945     0.200
     5.115    78.047     0.200
     5.115    77.852     0.200
     5.750    87.047     0.200
     7.227   103.547     0.200
     8.103   120.547     0.200
     8.103   117.352     0.200
     2.242    39.445     0.200
     2.552    43.344     0.200
     2.864    48.742     0.200
     2.959    49.148     0.200
     3.188    52.242     0.200
     3.188    51.047     0.200
     3.365    55.742     0.200
     3.493    56.445     0.200
     4.829    75.242     0.200
     5.227    80.547     0.200
     5.227    80.742     0.200
     5.760    90.445     0.200
     6.442    97.344     0.200
     7.186   103.891     0.200
     7.186   104.047     0.200
     7.656   115.047     0.200
     7.656   114.242     0.200
     7.714   113.742     0.200
     8.481   124.445     0.200
    10.603   154.398     0.200
    10.746   155.148     0.200
    11.916   172.547     0.200
    12.288   179.344     0.200
    14.804   209.742     0.200
    19.863   273.695     0.200
     2.205    38.383     0.200
     2.205    38.484     0.200
     2.683    43.883     0.200
     2.683    43.484     0.200
     2.683    45.289     0.200
     3.751    59.188     0.200
     3.909    61.789     0.200
     3.918    61.984     0.200
     4.224    66.984     0.200
     4.850    74.586     0.200
     5.115    77.586     0.200
     5.408    82.383     0.200
     6.646    98.586     0.200
     7.517   110.883     0.200
     1.350    26.969     0.200
     2.275    38.969     0.200
     2.487    42.570     0.200
     3.713    59.270     0.200
     3.945    61.570     0.200
     4.029    63.371     0.200
     4.655    70.672     0.200
     6.452    96.469     0.200
     7.392   109.172     0.200
     1.240    25.375     0.200
     2.443    40.477     0.200
     2.494    42.078     0.200
     3.826    60.375     0.200
     3.842    59.578     0.200
     4.104    63.273     0.200
     4.762    73.578     0.200
     2.118    37.914     0.200
     2.746    45.016     0.200
     3.775    60.414     0.200
     3.914    61.617     0.200
     4.206    66.414     0.200
     4.569    69.715     0.200
     2.522    40.911     0.200
     2.506    41.811     0.200
     2.827    46.610     0.200
     3.700    59.311     0.200
     3.740    58.811     0.200
     3.972    61.911     0.200
     3.972    61.411     0.200
     4.364    67.311     0.200
     5.594    84.711     0.200
     1.039    22.087     0.200
     1.492    30.587     0.200
     2.307    39.787     0.200
     2.322    40.187     0.200
     2.322    39.987     0.200
     2.465    40.987     0.200
     2.465    41.087     0.200
     2.343    40.487     0.200
     3.572    57.187     0.200
     3.885    61.887     0.200
     3.885    61.987     0.200
     4.515    71.487     0.200
     5.078    78.087     0.200
     6.308    95.187     0.200
     7.291   107.087     0.200
     7.291   106.987     0.200
     7.790   115.187     0.200
     9.390   139.187     0.200
    10.607   153.887     0.200
    18.138   251.087     0.200
     1.301    26.801     0.200
     1.987    35.102     0.200
     2.609    44.602     0.200
     2.609    44.500     0.200
     2.655    45.301     0.200
     2.899    47.500     0.200
     2.899    47.199     0.200
     3.636    59.000     0.200
     3.720    59.902     0.200
     3.787    61.102     0.200
     3.787    60.902     0.200
     3.804    61.801     0.200
     3.945    63.301     0.200
     4.187    66.602     0.200
     4.187    66.500     0.200
     4.543    71.000     0.200
     4.888    75.699     0.200
     4.888    76.199     0.200
     5.323    81.902     0.200
     5.323    82.102     0.200
     6.170    92.902     0.200
     6.594    98.801     0.200
     6.874   101.199     0.200
     6.874   101.320     0.200
     7.283   107.402     0.200
     7.283   108.102     0.200
     7.673   112.602     0.200
     7.673   113.801     0.200
     8.003   118.801     0.200
     8.400   122.574     0.200
     8.935   131.000     0.200
     9.189   134.199     0.200
     9.656   140.344     0.200
     9.656   140.102     0.200
     9.656   141.102     0.200
    10.599   156.000     0.200
    10.704   155.199     0.200
    10.688   155.176     0.200
    10.979   160.191     0.200
    10.992   159.621     0.200
    10.992   159.617     0.200
    11.073   161.301     0.200
    12.786   181.402     0.200
    16.044   225.402     0.200
    18.469   259.152     0.200
    19.163   266.711     0.200
    19.164   266.715     0.200
    19.567   270.379     0.200
    19.706   273.820     0.200
    19.737   274.828     0.200
    19.737   274.172     0.200
    19.737   274.801     0.200
     2.212    38.672     0.200
     2.212    38.078     0.200
     2.615    42.672     0.200
     2.615    43.375     0.200
     2.739    45.977     0.200
     2.739    46.078     0.200
     2.704    44.273     0.200
     3.632    58.773     0.200
     3.703    58.578     0.200
     3.959    62.773     0.200
     3.959    61.273     0.200
     4.280    67.273     0.200
     4.293    67.273     0.200
     4.900    74.672     0.200
     4.900    76.875     0.200
     5.467    83.172     0.200
     6.310    94.375     0.200
     7.571   110.875     0.200
     2.215    39.094     0.200
     2.263    40.293     0.200
     2.431    43.195     0.200
     2.541    42.793     0.200
     3.666    58.695     0.200
     4.129    65.395     0.200
     2.367    40.383     0.200
     2.507    43.184     0.200
     3.708    58.484     0.200
     4.049    64.082     0.200
     2.592    43.119     0.200
     2.737    43.418     0.200
     3.217    51.418     0.200
     4.752    72.318     0.200
     1.302    25.494     0.200
     2.086    35.695     0.200
     2.567    42.395     0.200
     3.038    47.994     0.200
     3.541    56.295     0.200
     4.387    67.295     0.200
     5.079    77.695     0.200
     5.603    83.895     0.200
     1.920    34.553     0.200
     2.300    39.854     0.200
     2.367    40.453     0.200
     2.364    41.053     0.200
     3.393    55.754     0.200
     3.688    59.354     0.200
     3.886    62.254     0.200
     4.094    63.652     0.200
     4.543    70.254     0.200
     5.002    77.354     0.200
     6.285    94.854     0.200
     6.454    97.553     0.200
     6.975   103.854     0.200
     6.980   104.453     0.200
     1.624    31.484     0.200
     2.237    39.383     0.200
     2.205    38.578     0.200
     2.484    42.484     0.200
     2.540    43.383     0.200
     3.059    49.578     0.200
     3.390    55.180     0.200
     3.745    59.883     0.200
     3.916    61.578     0.200
     4.279    67.883     0.200
     4.276    66.484     0.200
     4.330    68.781     0.200
     4.970    76.281     0.200
     6.173    94.484     0.200
     7.315   107.281     0.200
     1.371    27.047     0.200
     2.570    43.344     0.200
     2.474    41.445     0.200
     2.474    40.945     0.200
     2.622    45.344     0.200
     2.830    47.047     0.200
     2.830    46.945     0.200
     3.719    59.648     0.200
     3.613    57.445     0.200
     3.978    62.547     0.200
     3.990    62.344     0.200
     3.959    61.445     0.200
     4.365    68.250     0.200
     4.365    68.445     0.200
     4.891    76.344     0.200
     5.603    84.445     0.200
     5.603    84.945     0.200
     6.795   102.844     0.200
     6.795   102.344     0.200
     7.874   114.547     0.200
     7.874   114.648     0.200
     8.331   122.250     0.200
     9.890   143.445     0.200
    10.369   153.344     0.200
    11.416   166.445     0.200
    11.460   165.164     0.200
    15.603   219.344     0.200
     1.358    27.883     0.200
     2.462    41.578     0.200
     2.576    43.383     0.200
     2.819    46.977     0.200
     2.819    47.883     0.200
     3.600    56.281     0.200
     3.732    58.078     0.200
     3.981    62.477     0.200
     3.946    62.281     0.200
     4.354    68.180     0.200
     5.593    84.781     0.200
     7.868   114.578     0.200
     1.563    29.531     0.200
     1.950    34.434     0.200
     2.738    45.230     0.200
     2.805    46.730     0.200
     2.940    47.031     0.200
     3.633    56.934     0.200
     4.078    63.934     0.200
     4.341    67.730     0.200
     4.489    68.133     0.200
     4.549    69.633     0.200
     5.021    77.230     0.200
     5.486    83.332     0.200
     6.752   101.434     0.200
     1.254    25.393     0.200
     2.164    38.192     0.200
     2.614    44.093     0.200
     2.955    47.992     0.200
     3.085    48.893     0.200
     3.624    58.492     0.200
     4.399    68.692     0.200
     4.399    70.593     0.200
     5.162    79.692     0.200
     5.678    86.793     0.200
     6.387    96.393     0.200
     8.476   125.093     0.200
     2.157    38.727     0.200
     2.176    38.828     0.200
     2.390    41.430     0.200
     2.481    42.828     0.200
     3.414    55.727     0.200
     3.732    60.125     0.200
     3.924    62.828     0.200
     4.021    64.227     0.200
     4.282    67.031     0.200
     4.675    73.531     0.200
     5.195    80.031     0.200
     6.040    91.031     0.200
     6.440    97.531     0.200
     6.655   100.828     0.200
     7.068   105.625     0.200
     7.313   108.531     0.200
     7.406   111.031     0.200
     7.532   112.930     0.200
     7.897   118.328     0.200
     8.418   123.844     0.200
    10.951   159.008     0.200
    10.956   159.625     0.200
    18.930   264.406     0.200
     2.177    38.616     0.200
     2.616    43.616     0.200
     2.728    44.616     0.200
     2.731    46.017     0.200
     3.699    58.116     0.200
     4.272    67.217     0.200
     5.453    82.916     0.200
     2.393    41.094     0.200
     2.788    46.789     0.200
     3.095    50.094     0.200
     4.635    72.391     0.200
     5.214    79.492     0.200
     2.370    41.277     0.200
     3.091    51.680     0.200
     4.262    67.578     0.200
     4.631    72.578     0.200
     5.198    80.277     0.200
     5.840    89.078     0.200
     1.548    30.254     0.200
     1.750    32.254     0.200
     2.340    40.652     0.200
     2.726    45.254     0.200
     2.787    46.652     0.200
     2.949    49.852     0.200
     3.536    56.152     0.200
     3.558    56.754     0.200
     3.793    59.152     0.200
     4.131    65.555     0.200
     4.490    70.352     0.200
     5.068    78.152     0.200
     5.696    86.555     0.200
     7.827   116.453     0.200
    11.571   167.352     0.200
     2.129    37.359     0.200
     2.255    39.559     0.200
     2.374    39.959     0.200
     2.403    42.059     0.200
     2.404    42.059     0.200
     3.149    50.359     0.200
     3.473    56.158     0.200
     3.796    60.959     0.200
     4.052    62.859     0.200
     4.185    65.859     0.200
     4.204    65.158     0.200
     4.415    69.359     0.200
     5.000    77.359     0.200
     6.222    94.359     0.200
     7.323   109.359     0.200
     7.538   112.559     0.200
     7.717   115.459     0.200
    11.224   163.908     0.200
    18.657   262.066     0.200
     2.413    41.414     0.200
     2.423    41.914     0.200
     3.619    56.814     0.200
     3.964    62.615     0.200
     2.349    40.135     0.200
     2.712    44.335     0.200
     3.550    56.835     0.200
     3.572    57.135     0.200
     4.117    63.835     0.200
     4.478    69.635     0.200
     2.328    39.977     0.200
     2.739    45.074     0.200
     2.955    49.477     0.200
     3.527    56.375     0.200
     3.547    56.574     0.200
     4.139    65.074     0.200
     4.496    70.375     0.200
     2.669    44.441     0.200
     2.767    46.344     0.200
     3.192    52.711     0.200
     3.325    52.691     0.200
     3.441    53.832     0.200
     4.679    71.691     0.200
     2.245    39.508     0.200
     2.413    40.602     0.200
     2.406    42.305     0.200
     3.464    56.406     0.200
     4.050    63.602     0.200
     4.194    66.203     0.200
     1.400    27.898     0.200
     1.940    35.297     0.200
     2.133    37.797     0.200
     2.701    45.598     0.200
     3.715    59.297     0.200
     1.398    27.258     0.200
     2.147    37.660     0.200
     2.739    44.758     0.200
     2.705    45.461     0.200
     3.714    59.059     0.200
     3.739    60.160     0.200
     3.943    62.359     0.200
     4.246    66.859     0.200
     4.344    67.059     0.200
     4.885    75.758     0.200
     6.266    95.258     0.200
     6.666    99.758     0.200
     6.882   102.559     0.200
     7.497   112.359     0.200
     2.276    39.281     0.200
     2.431    41.977     0.200
     2.566    44.078     0.200
     3.584    58.180     0.200
     3.899    61.883     0.200
     3.968    63.281     0.200
     4.103    65.383     0.200
     2.117    36.215     0.200
     2.255    38.812     0.200
     2.444    41.516     0.200
     3.135    50.312     0.200
     3.461    55.414     0.200
     3.796    59.914     0.200
     4.011    62.516     0.200
     4.199    65.613     0.200
     4.211    64.516     0.200
     5.007    76.312     0.200
     2.674    42.842     0.200
     2.674    43.041     0.200
     2.733    43.541     0.200
     3.055    49.143     0.200
     3.284    52.242     0.200
     3.326    52.541     0.200
     4.115    63.643     0.200
     4.384    67.041     0.200
     4.816    73.242     0.200
     5.310    80.342     0.200
     5.814    86.742     0.200
     6.060    89.941     0.200
     6.897   102.041     0.200
     7.458   106.061     0.200
     8.277   121.143     0.200
     8.302   122.541     0.200
     8.362   122.742     0.200
     8.788   128.842     0.200
    10.987   156.541     0.200
    10.987   156.643     0.200
    11.630   167.441     0.200
    11.905   169.266     0.200
    19.397   264.666     0.200
    19.397   266.441     0.200
    20.491   277.170     0.200
     1.219    24.930     0.200
     1.632    31.531     0.200
     2.113    37.631     0.200
     2.667    45.131     0.200
     2.974    49.230     0.200
     3.296    53.830     0.200
     3.917    62.730     0.200
     4.518    70.330     0.200
     4.524    70.930     0.200
     5.723    87.930     0.200
     2.393    38.866     0.200
     2.705    44.066     0.200
     2.785    44.566     0.200
     2.959    47.766     0.200
     3.673    57.266     0.200
     3.690    57.466     0.200
     3.839    58.566     0.200
     4.028    62.466     0.200
     4.028    62.566     0.200
     4.484    68.866     0.200
     4.952    75.066     0.200
     4.952    76.166     0.200
     5.679    86.166     0.200
     5.747    85.366     0.200
     6.129    90.966     0.200
     7.712   111.266     0.200
     7.712   109.466     0.200
     7.819   113.166     0.200
     8.035   118.166     0.200
     8.098   118.866     0.200
     8.098   116.566     0.200
     8.484   123.966     0.200
    11.269   160.241     0.200
    11.269   159.766     0.200
    11.384   162.866     0.200
    11.651   165.966     0.200
    13.754   195.066     0.200
    15.361   212.776     0.200
    15.361   213.766     0.200
    15.498   218.416     0.200
    17.060   237.666     0.200
    17.950   248.066     0.200
    18.085   249.466     0.200
    18.248   247.926     0.200
    19.035   262.216     0.200
     1.074    21.289     0.200
     2.294    38.891     0.200
     2.490    40.789     0.200
     2.490    41.594     0.200
     2.801    45.195     0.200
     3.266    50.594     0.200
     3.726    58.992     0.200
     5.267    79.891     0.200
     2.021    35.189     0.200
     2.181    38.088     0.200
     2.623    44.189     0.200
     2.677    44.088     0.200
     3.859    60.988     0.200
     4.163    65.389     0.200
     4.296    67.088     0.200
     5.343    81.389     0.200
     1.244    26.273     0.200
     2.030    36.273     0.200
     2.169    37.672     0.200
     2.612    43.574     0.200
     2.682    43.574     0.200
     3.832    62.074     0.200
     3.852    60.672     0.200
     5.330    81.074     0.200
     6.573    98.473     0.200
     7.429   110.375     0.200
     2.263    38.586     0.200
     2.375    40.785     0.200
     2.820    45.387     0.200
     2.880    46.086     0.200
     3.290    50.984     0.200
     3.674    58.484     0.200
     4.851    74.285     0.200
     5.215    79.887     0.200
     1.331    26.527     0.200
     2.036    36.527     0.200
     2.547    43.828     0.200
     3.837    61.227     0.200
     4.083    65.027     0.200
     4.423    68.828     0.200
     5.235    81.727     0.200
     1.368    28.574     0.200
     1.338    26.773     0.200
     2.091    37.375     0.200
     2.091    37.676     0.200
     2.020    36.574     0.200
     2.020    37.176     0.200
     2.488    42.773     0.200
     2.488    44.074     0.200
     2.546    43.676     0.200
     2.783    45.574     0.200
     3.515    56.875     0.200
     3.836    61.176     0.200
     3.893    62.074     0.200
     3.826    61.273     0.200
     4.081    64.977     0.200
     4.438    68.875     0.200
     4.858    75.176     0.200
     4.858    74.977     0.200
     5.230    80.676     0.200
     5.230    80.477     0.200
     5.836    89.074     0.200
     6.492    97.773     0.200
     6.931   101.754     0.200
     7.271   110.375     0.200
     7.425   110.977     0.200
     7.576   112.074     0.200
     7.576   112.375     0.200
     7.757   116.273     0.200
     8.138   120.273     0.200
     8.447   121.793     0.200
     8.447   121.156     0.200
     8.447   122.273     0.200
     8.446   125.977     0.200
     8.840   130.176     0.200
     8.931   131.375     0.200
     9.093   133.773     0.200
     9.559   140.875     0.200
    10.076   147.875     0.200
    10.510   154.676     0.200
    10.510   154.273     0.200
    10.808   156.648     0.200
    10.649   155.297     0.200
    10.649   157.477     0.200
    10.933   158.535     0.200
    10.933   159.266     0.200
    10.970   161.574     0.200
    10.970   161.875     0.200
    11.201   163.875     0.200
    11.940   172.875     0.200
    12.199   175.074     0.200
    12.280   178.676     0.200
    13.205   188.977     0.200
    13.650   197.773     0.200
    13.650   195.664     0.200
    14.743   211.074     0.200
    14.874   213.977     0.200
    14.874   212.625     0.200
    14.874   215.336     0.200
    15.766   226.773     0.200
    16.120   227.773     0.200
    16.143   228.766     0.200
    17.377   246.176     0.200
    17.677   247.742     0.200
    17.830   250.574     0.200
    18.543   258.250     0.200
    19.041   266.375     0.200
    19.041   266.301     0.200
    19.041   266.586     0.200
    19.514   272.086     0.200
    19.691   272.926     0.200
    19.693   272.914     0.200
    20.590   286.375     0.200
    20.730   285.664     0.200
     1.372    28.145     0.200
     2.093    36.344     0.200
     2.489    43.047     0.200
     2.545    43.844     0.200
     2.788    45.746     0.200
     3.516    56.246     0.200
     3.836    60.945     0.200
     3.826    61.344     0.200
     3.826    61.445     0.200
     3.894    62.246     0.200
     3.894    62.047     0.200
     4.080    65.047     0.200
     4.080    64.844     0.200
     4.444    69.047     0.200
     4.853    75.445     0.200
     5.227    80.547     0.200
     5.227    80.445     0.200
     6.491    97.746     0.200
     6.684   100.445     0.200
     7.249   108.844     0.200
     7.574   112.445     0.200
     8.133   120.445     0.200
     8.838   129.844     0.200
    10.804   154.195     0.200
    10.928   156.234     0.200
    11.200   163.547     0.200
    17.680   246.645     0.200
     2.036    36.477     0.200
     2.092    36.977     0.200
     3.839    60.977     0.200
     4.080    64.676     0.200
     1.329    26.555     0.200
     2.031    36.855     0.200
     2.096    37.355     0.200
     3.819    60.953     0.200
     3.842    60.855     0.200
     4.076    64.652     0.200
     5.227    80.254     0.200
     1.344    26.383     0.200
     2.032    36.082     0.200
     2.073    37.082     0.200
     2.563    43.383     0.200
     3.821    60.781     0.200
     3.838    60.984     0.200
     4.099    64.781     0.200
     5.250    80.383     0.200
     1.339    26.422     0.200
     2.028    36.824     0.200
     2.552    43.625     0.200
     3.830    61.023     0.200
     3.831    61.023     0.200
     3.886    62.023     0.200
     4.087    64.922     0.200
     4.432    68.922     0.200
     5.238    80.523     0.200
     1.348    26.734     0.200
     2.026    36.234     0.200
     2.073    36.328     0.200
     2.564    43.633     0.200
     3.819    60.828     0.200
     3.841    61.430     0.200
     4.099    64.930     0.200
     4.435    68.734     0.200
     5.250    81.133     0.200
     2.560    43.581     0.200
     3.823    60.981     0.200
     3.838    61.381     0.200
     4.095    64.981     0.200
     6.508    98.081     0.200
     1.344    26.723     0.200
     2.020    36.223     0.200
     2.083    37.125     0.200
     3.833    61.422     0.200
     3.885    61.922     0.200
     4.089    64.824     0.200
     4.439    68.922     0.200
     5.238    80.523     0.200
     6.501    98.125     0.200
     7.262   108.824     0.200
     7.584   113.422     0.200
     1.330    26.664     0.200
     1.367    28.062     0.200
     2.032    36.961     0.200
     2.094    37.461     0.200
     3.820    61.664     0.200
     3.841    61.359     0.200
     4.078    65.062     0.200
     6.490    98.461     0.200
     7.261   108.258     0.200
     1.366    28.129     0.200
     1.337    26.729     0.200
     2.090    37.430     0.200
     2.090    37.729     0.200
     2.024    36.829     0.200
     2.024    36.930     0.200
     2.488    42.729     0.200
     2.546    44.129     0.200
     2.781    46.029     0.200
     3.835    61.029     0.200
     3.892    62.529     0.200
     3.825    62.129     0.200
     4.082    65.129     0.200
     4.082    65.329     0.200
     4.435    69.029     0.200
     5.231    80.629     0.200
     7.258   107.930     0.200
     7.258   106.029     0.200
     7.577   113.229     0.200
    10.810   157.904     0.200
    10.935   158.149     0.200
    19.041   266.271     0.200
     1.344    26.869     0.200
     1.359    27.668     0.200
     2.021    36.369     0.200
     2.554    43.770     0.200
     3.828    60.969     0.200
     3.884    61.869     0.200
     4.089    65.068     0.200
     1.344    27.052     0.200
     2.017    36.451     0.200
     2.085    37.651     0.200
     2.552    43.951     0.200
     2.788    46.751     0.200
     3.829    60.552     0.200
     3.832    61.751     0.200
     3.886    61.852     0.200
     4.087    65.251     0.200
     5.236    80.852     0.200
     2.088    37.541     0.200
     2.009    36.541     0.200
     2.494    43.541     0.200
     2.550    44.242     0.200
     2.794    45.941     0.200
     3.830    61.141     0.200
     3.889    62.242     0.200
     3.832    61.742     0.200
     3.832    61.641     0.200
     4.084    65.242     0.200
     4.449    68.941     0.200
     5.231    80.842     0.200
     6.495    98.242     0.200
     7.250   109.141     0.200
     7.250   109.242     0.200
     7.578   113.641     0.200
    10.797   158.166     0.200
    19.049   267.779     0.200
     1.352    27.191     0.200
     1.343    26.391     0.200
     2.027    36.191     0.200
     2.078    36.891     0.200
     2.497    42.591     0.200
     2.558    43.991     0.200
     2.781    45.491     0.200
     3.825    60.591     0.200
     3.835    61.191     0.200
     3.880    61.791     0.200
     4.094    64.791     0.200
     4.433    68.691     0.200
     5.245    81.291     0.200
     6.506    97.491     0.200
     7.273   108.591     0.200
     7.590   112.291     0.200
     1.318    26.445     0.200
     2.052    36.547     0.200
     2.096    37.250     0.200
     3.813    60.852     0.200
     4.076    64.945     0.200
     1.341    27.020     0.200
     1.367    27.420     0.200
     2.018    36.020     0.200
     2.089    37.720     0.200
     2.548    44.020     0.200
     2.786    45.220     0.200
     4.083    65.320     0.200
     1.344    26.875     0.200
     2.018    36.672     0.200
     2.551    43.875     0.200
     2.787    46.477     0.200
     3.831    61.477     0.200
     3.887    62.078     0.200
     4.087    65.172     0.200
     4.441    69.172     0.200
     4.774    74.977     0.200
     5.235    80.773     0.200
     6.498    98.477     0.200
     1.228    25.059     0.200
     1.228    27.160     0.200
     2.175    38.559     0.200
     2.137    37.961     0.200
     2.409    41.359     0.200
     2.502    42.961     0.200
     2.638    43.859     0.200
     3.751    59.660     0.200
     4.042    64.359     0.200
     4.042    64.258     0.200
     3.939    62.660     0.200
     4.285    66.859     0.200
     4.693    72.961     0.200
     4.926    77.961     0.200
     5.217    80.461     0.200
     5.217    80.258     0.200
     5.956    91.059     0.200
     6.446    96.660     0.200
     6.462    97.160     0.200
     7.333   108.160     0.200
     7.333   107.859     0.200
     7.554   111.961     0.200
     7.919   117.559     0.200
     8.397   120.660     0.200
     8.397   122.602     0.200
     8.823   129.758     0.200
    10.972   158.621     0.200
    10.947   159.559     0.200
    10.947   158.785     0.200
    16.158   225.559     0.200
    16.158   224.680     0.200
    18.529   258.461     0.200
    18.947   264.234     0.200
     2.537    43.484     0.200
     2.507    42.582     0.200
     2.507    42.383     0.200
     3.080    49.094     0.200
     3.494    55.285     0.200
     3.494    54.984     0.200
     7.024   103.824     0.200
     7.024   103.926     0.200
     7.024   101.184     0.200
     7.927   117.383     0.200
     8.620   125.883     0.200
    10.346   150.184     0.200
    12.398   176.363     0.200
    17.016   238.055     0.200
     2.053    35.854     0.200
     2.444    41.055     0.200
     2.494    41.955     0.200
     2.500    42.455     0.200
     3.834    60.455     0.200
     3.835    60.754     0.200
     4.009    62.654     0.200
     4.219    66.254     0.200
     4.770    73.654     0.200
     5.448    82.654     0.200
     6.648    99.354     0.200
     6.674    99.955     0.200
     7.710   112.055     0.200
     8.172   120.555     0.200
     2.074    37.339     0.200
     2.191    38.539     0.200
     2.405    41.539     0.200
     2.463    42.739     0.200
     3.417    55.539     0.200
     3.732    60.039     0.200
     4.054    62.939     0.200
     4.263    67.139     0.200
     4.358    67.839     0.200
     4.782    74.239     0.200
     4.934    76.439     0.200
     6.157    93.239     0.200
     6.162    93.339     0.200
     7.205   105.039     0.200
     7.258   108.739     0.200
     7.650   114.939     0.200
     2.528    41.766     0.200
     2.571    42.965     0.200
     2.705    44.566     0.200
     2.915    47.965     0.200
     3.639    58.465     0.200
     3.695    58.367     0.200
     4.022    62.965     0.200
     4.042    63.266     0.200
     4.451    69.367     0.200
     5.688    85.867     0.200
     6.880   101.867     0.200
     6.914   102.766     0.200
     7.942   117.965     0.200
     2.230    37.227     0.200
     3.030    46.828     0.200
     2.953    46.629     0.200
     3.740    58.527     0.200
     4.785    73.027     0.200
     5.264    79.129     0.200
     2.604    43.359     0.200
     2.604    42.949     0.200
     2.679    44.762     0.200
     3.057    49.160     0.200
     3.380    53.359     0.200
     3.406    53.422     0.200
     4.178    65.359     0.200
     4.505    68.961     0.200
     5.706    86.660     0.200
     2.247    39.293     0.200
     2.373    39.992     0.200
     2.411    41.992     0.200
     2.403    41.893     0.200
     3.466    56.093     0.200
     3.788    60.692     0.200
     4.407    69.492     0.200
     4.992    77.093     0.200
     6.214    94.093     0.200
     7.257   108.293     0.200
     1.609    32.242     0.200
     2.294    39.938     0.200
     2.294    39.641     0.200
     2.793    46.039     0.200
     2.793    45.539     0.200
     3.000    49.641     0.200
     3.477    56.938     0.200
     3.477    54.938     0.200
     4.190    66.242     0.200
     4.310    67.438     0.200
     4.541    70.742     0.200
     5.717    87.836     0.200
     7.838   116.742     0.200
    19.316   268.477     0.200
     1.710    30.812     0.200
     2.385    40.016     0.200
     2.385    40.117     0.200
     2.840    46.211     0.200
     3.868    59.711     0.200
     3.868    59.016     0.200
     3.569    56.711     0.200
     3.661    56.711     0.200
     3.661    57.016     0.200
     3.617    57.117     0.200
     3.617    57.312     0.200
     4.267    64.617     0.200
     4.595    71.211     0.200
     4.852    74.812     0.200
     4.908    75.211     0.200
     4.908    75.312     0.200
     5.159    77.711     0.200
     5.143    78.211     0.200
     5.573    83.812     0.200
     5.850    88.211     0.200
     6.336    93.914     0.200
     6.336    94.016     0.200
     6.244    92.914     0.200
     7.059   102.117     0.200
     6.877    99.406     0.200
     7.092   105.211     0.200
     7.590   109.016     0.200
     7.402   108.211     0.200
     7.753   110.484     0.200
     7.753   109.758     0.200
     7.753   111.125     0.200
     7.540   110.812     0.200
     7.540   110.711     0.200
     7.690   112.914     0.200
     7.889   114.711     0.200
     8.394   122.617     0.200
     8.606   125.312     0.200
     8.606   125.211     0.200
     8.752   127.414     0.200
     8.894   130.312     0.200
     8.891   129.617     0.200
     9.463   137.117     0.200
     9.859   142.711     0.200
     9.968   146.117     0.200
    10.587   154.117     0.200
    11.190   160.617     0.200
    11.121   161.711     0.200
    11.413   163.914     0.200
    11.452   164.016     0.200
    11.452   165.016     0.200
    11.452   165.211     0.200
    11.503   167.016     0.200
    11.503   165.711     0.200
    11.757   167.820     0.200
    11.757   168.477     0.200
    12.021   173.016     0.200
    12.021   172.914     0.200
    12.272   175.711     0.200
    12.490   176.914     0.200
    12.836   181.711     0.200
    13.054   185.711     0.200
    13.486   191.312     0.200
    14.195   201.086     0.200
    14.510   206.914     0.200
    15.121   214.914     0.200
    15.377   218.516     0.200
    16.291   228.414     0.200
    16.314   227.992     0.200
    16.683   230.227     0.200
    16.683   232.008     0.200
    16.683   231.812     0.200
    16.683   232.977     0.200
    16.845   237.414     0.200
    17.271   241.914     0.200
    17.650   243.914     0.200
    17.650   244.617     0.200
    18.754   260.367     0.200
    19.447   268.617     0.200
     1.286    26.281     0.200
     2.479    41.680     0.200
     2.478    42.484     0.200
     2.478    42.281     0.200
     2.714    45.781     0.200
     2.714    45.883     0.200
     3.797    60.883     0.200
     3.872    61.680     0.200
     3.872    61.781     0.200
     4.039    63.281     0.200
     4.039    62.883     0.200
     4.253    67.086     0.200
     4.807    73.984     0.200
     5.478    83.781     0.200
     6.037    91.680     0.200
     6.317    95.383     0.200
     6.682   100.281     0.200
     6.682   100.180     0.200
     6.705   100.781     0.200
     6.779   101.883     0.200
     7.724   112.984     0.200
     7.724   113.180     0.200
     7.791   115.586     0.200
     8.045   115.883     0.200
    11.044   157.781     0.200
    11.140   162.586     0.200
    11.110   161.984     0.200
    11.320   164.281     0.200
    11.317   163.625     0.200
     1.835    32.262     0.200
     2.585    42.859     0.200
     2.585    42.961     0.200
     2.810    44.359     0.200
     3.273    51.961     0.200
     3.087    50.359     0.200
     3.299    52.559     0.200
     4.207    64.461     0.200
     4.421    68.359     0.200
     4.421    68.160     0.200
     4.835    73.762     0.200
     4.835    73.559     0.200
     5.350    81.262     0.200
     5.728    85.961     0.200
     6.067    90.660     0.200
     6.067    90.559     0.200
     7.480   106.180     0.200
     7.480   108.762     0.200
     7.264   106.859     0.200
     7.294   106.961     0.200
     7.412   106.859     0.200
     8.236   119.262     0.200
     8.236   119.059     0.200
     8.379   121.461     0.200
     8.377   122.859     0.200
    10.359   151.359     0.200
    10.895   157.461     0.200
    11.718   169.461     0.200
    11.883   171.961     0.200
    11.886   168.750     0.200
    15.346   214.660     0.200
    16.871   233.203     0.200
     1.221    24.913     0.200
     2.114    37.312     0.200
     2.667    45.112     0.200
     2.909    48.013     0.200
     2.973    49.013     0.200
     3.294    53.712     0.200
     3.914    62.413     0.200
     4.516    70.212     0.200
     5.721    86.712     0.200
     2.321    41.008     0.200
     2.496    43.707     0.200
     3.400    54.605     0.200
     3.683    60.105     0.200
     4.147    64.906     0.200
     4.299    68.309     0.200
     7.090   105.406     0.200
     1.452    28.477     0.200
     2.437    41.172     0.200
     2.437    41.570     0.200
     2.607    43.375     0.200
     2.607    43.172     0.200
     2.878    47.773     0.200
     3.630    58.273     0.200
     4.039    64.070     0.200
     4.039    63.875     0.200
     4.131    64.672     0.200
     4.417    69.070     0.200
     4.974    77.375     0.200
     5.637    86.070     0.200
     5.903    89.477     0.200
     6.477    97.070     0.200
     6.846   102.477     0.200
     6.846   102.977     0.200
     6.865   102.273     0.200
     6.941   103.570     0.200
     7.180   105.117     0.200
     7.831   116.273     0.200
     7.954   118.773     0.200
     7.910   114.180     0.200
     8.357   123.070     0.200
     9.936   143.695     0.200
     9.936   144.977     0.200
    10.998   157.516     0.200
    10.998   159.172     0.200
    11.454   165.281     0.200
    13.718   193.773     0.200
    18.079   250.148     0.200
    19.144   264.125     0.200
     1.452    28.344     0.200
     2.444    41.547     0.200
     2.603    43.844     0.200
     2.698    44.445     0.200
     2.880    47.945     0.200
     3.630    58.047     0.200
     4.039    63.648     0.200
     4.126    64.648     0.200
     4.419    69.250     0.200
     5.640    86.047     0.200
     6.480    97.648     0.200
     6.848   102.750     0.200
     6.868   103.945     0.200
     1.454    28.641     0.200
     2.441    41.438     0.200
     2.606    43.242     0.200
     2.700    45.641     0.200
     2.881    47.938     0.200
     3.628    58.242     0.200
     4.041    64.039     0.200
     4.129    64.641     0.200
     4.420    69.844     0.200
     4.420    69.438     0.200
     4.975    77.742     0.200
     5.641    86.344     0.200
     6.481    97.344     0.200
     6.849   102.938     0.200
     6.868   103.438     0.200
     6.944   103.641     0.200
     7.472   109.844     0.200
     7.472   109.344     0.200
     7.957   119.141     0.200
     7.957   118.141     0.200
     8.361   123.344     0.200
     8.413   122.938     0.200
     9.940   142.344     0.200
    10.929   157.539     0.200
    11.000   156.406     0.200
    11.000   158.641     0.200
    11.183   160.742     0.200
    11.183   160.367     0.200
    11.458   165.914     0.200
    11.489   165.742     0.200
    12.331   177.938     0.200
    13.721   195.344     0.200
    16.728   232.039     0.200
    17.287   240.656     0.200
    18.075   250.266     0.200
    19.145   264.914     0.200
    19.145   265.469     0.200
    19.145   266.641     0.200
    19.649   269.641     0.200
     1.851    33.500     0.200
     1.851    33.602     0.200
     2.450    40.898     0.200
     2.450    41.398     0.200
     2.601    43.000     0.200
     3.629    58.102     0.200
     3.699    59.898     0.200
     4.041    64.195     0.200
     4.041    63.797     0.200
     4.121    64.398     0.200
     4.422    69.195     0.200
     4.975    77.195     0.200
     5.644    85.797     0.200
     5.644    85.500     0.200
     5.909    89.102     0.200
     6.484    96.695     0.200
     6.851   102.898     0.200
     6.851   102.297     0.200
     6.871   102.500     0.200
     6.947   104.602     0.200
     7.107   105.500     0.200
     7.193   104.688     0.200
     7.899   114.945     0.200
     7.899   113.000     0.200
     7.844   114.297     0.200
     7.844   116.898     0.200
     7.960   119.398     0.200
     7.960   117.195     0.200
     8.364   124.000     0.200
     8.845   129.297     0.200
     9.942   145.000     0.200
    10.932   160.398     0.200
    11.006   158.742     0.200
    11.189   162.297     0.200
    11.311   166.195     0.200
    11.464   165.227     0.200
    11.490   166.602     0.200
    18.071   251.672     0.200
    19.143   267.102     0.200
     2.451    41.398     0.200
     2.595    43.102     0.200
     2.692    45.102     0.200
     2.876    47.703     0.200
     2.876    47.805     0.200
     3.636    58.305     0.200
     4.033    63.703     0.200
     4.033    64.000     0.200
     4.117    64.703     0.200
     4.415    69.102     0.200
     4.415    69.000     0.200
     4.968    77.398     0.200
     5.637    85.602     0.200
     5.637    85.500     0.200
     5.915    89.203     0.200
     6.476    97.703     0.200
     6.843   102.398     0.200
     6.864   103.602     0.200
     7.100   105.602     0.200
     7.480   109.898     0.200
     7.838   114.102     0.200
     7.838   114.898     0.200
     7.952   118.805     0.200
     7.952   118.102     0.200
     7.906   115.523     0.200
     7.906   114.703     0.200
     7.906   115.211     0.200
     8.357   123.102     0.200
     8.424   122.500     0.200
     8.837   130.305     0.200
     9.934   142.305     0.200
     9.934   142.062     0.200
    11.011   158.094     0.200
    11.303   163.898     0.200
    11.457   165.453     0.200
    11.457   163.375     0.200
    15.671   218.102     0.200
    19.135   264.484     0.200
    19.820   272.125     0.200
    20.289   277.000     0.200
    21.078   289.000     0.200
     1.845    33.520     0.200
     2.604    42.920     0.200
     2.453    41.420     0.200
     2.708    45.319     0.200
     2.892    48.319     0.200
     2.892    47.819     0.200
     3.621    56.520     0.200
     4.122    64.420     0.200
     4.122    64.319     0.200
     4.049    63.819     0.200
     4.431    69.220     0.200
     4.983    77.319     0.200
     5.653    85.819     0.200
     5.905    89.420     0.200
     6.493    97.420     0.200
     6.860   102.619     0.200
     6.860   102.720     0.200
     6.880   102.920     0.200
     6.956   104.319     0.200
     7.199   105.237     0.200
     7.890   112.714     0.200
     7.890   112.829     0.200
     7.486   108.619     0.200
     7.886   117.319     0.200
     7.852   114.520     0.200
     7.968   117.819     0.200
     7.968   118.319     0.200
     8.420   122.720     0.200
     8.854   130.020     0.200
     9.951   143.537     0.200
    11.004   158.312     0.200
    11.004   158.520     0.200
    11.198   161.220     0.200
    11.319   165.520     0.200
    11.498   165.619     0.200
    11.473   165.640     0.200
    15.196   217.036     0.200
    16.169   230.420     0.200
    17.276   237.964     0.200
    17.276   241.050     0.200
    18.062   248.119     0.200
    19.149   265.779     0.200
    19.149   265.819     0.200
     2.444    41.688     0.200
     2.606    43.486     0.200
     2.884    48.088     0.200
     3.626    56.986     0.200
     4.043    64.188     0.200
     4.424    69.188     0.200
     4.978    76.287     0.200
     6.852   103.387     0.200
     6.872   104.287     0.200
     1.866    33.035     0.200
     2.480    41.035     0.200
     2.576    42.535     0.200
     2.881    46.637     0.200
     3.640    57.238     0.200
     4.093    63.438     0.200
     4.965    76.836     0.200
     6.872   103.035     0.200
     7.860   115.836     0.200
     1.464    28.742     0.200
     1.842    33.441     0.200
     2.455    41.340     0.200
     2.605    42.742     0.200
     2.896    47.742     0.200
     3.618    56.641     0.200
     4.052    64.141     0.200
     4.122    64.840     0.200
     5.657    85.742     0.200
     6.864   103.043     0.200
     6.884   103.941     0.200
     6.960   104.742     0.200
     7.856   117.141     0.200
     1.847    32.938     0.200
     2.434    41.844     0.200
     2.611    43.141     0.200
     2.701    44.641     0.200
     2.881    47.844     0.200
     3.627    58.242     0.200
     3.702    59.742     0.200
     4.042    63.938     0.200
     4.420    69.641     0.200
     6.867   103.242     0.200
     2.696    44.250     0.200
     2.881    47.148     0.200
     4.037    62.453     0.200
     4.114    64.453     0.200
     4.420    68.453     0.200
     4.971    76.555     0.200
     1.836    33.469     0.200
     2.447    41.469     0.200
     2.613    43.168     0.200
     2.613    43.668     0.200
     2.716    45.969     0.200
     2.899    47.969     0.200
     3.613    58.270     0.200
     3.613    58.168     0.200
     4.130    64.668     0.200
     4.057    64.367     0.200
     4.438    69.367     0.200
     4.991    77.566     0.200
     5.659    86.270     0.200
     5.897    89.066     0.200
     6.499    98.867     0.200
     6.867   103.066     0.200
     6.867   103.270     0.200
     6.887   104.270     0.200
     6.962   105.066     0.200
     7.195   104.395     0.200
     7.887   114.160     0.200
     7.854   114.668     0.200
     7.854   114.770     0.200
     7.891   118.066     0.200
     7.975   119.270     0.200
     8.379   124.770     0.200
     8.412   123.066     0.200
     8.860   130.367     0.200
    10.996   157.188     0.200
    10.996   159.566     0.200
    11.326   166.867     0.200
    11.477   165.688     0.200
    18.056   252.844     0.200
    19.158   266.367     0.200
     2.448    41.965     0.200
     2.609    43.168     0.200
     2.894    48.367     0.200
     3.618    58.668     0.200
     4.052    64.867     0.200
     4.127    64.766     0.200
     4.433    69.168     0.200
     4.986    78.066     0.200
     5.655    86.668     0.200
     6.494    98.465     0.200
     6.862   103.668     0.200
     6.882   103.566     0.200
     1.456    28.797     0.200
     2.448    41.297     0.200
     2.448    41.398     0.200
     2.604    42.695     0.200
     2.604    43.094     0.200
     2.702    45.398     0.200
     2.885    47.898     0.200
     3.626    58.594     0.200
     3.626    58.297     0.200
     4.043    63.797     0.200
     4.043    63.695     0.200
     4.124    63.898     0.200
     4.424    69.195     0.200
     4.978    76.898     0.200
     5.437    79.992     0.200
     5.646    85.695     0.200
     5.646    85.398     0.200
     6.486    97.195     0.200
     6.853   102.594     0.200
     6.853   102.094     0.200
     6.873   102.492     0.200
     6.949   103.797     0.200
     7.109   106.492     0.200
     7.192   105.023     0.200
     7.479   109.227     0.200
     7.479   110.195     0.200
     7.899   113.625     0.200
     7.899   116.594     0.200
     7.844   114.195     0.200
     7.844   114.594     0.200
     7.878   116.492     0.200
     7.962   117.695     0.200
     7.962   117.297     0.200
     8.184   121.297     0.200
     8.418   123.594     0.200
     8.366   123.297     0.200
     8.847   130.094     0.200
     9.487   138.797     0.200
     9.944   144.336     0.200
     9.944   147.094     0.200
    10.431   151.094     0.200
    11.003   158.117     0.200
    11.003   158.898     0.200
    10.934   159.492     0.200
    11.190   160.898     0.200
    11.313   164.398     0.200
    11.465   165.617     0.200
    11.465   164.414     0.200
    11.492   166.297     0.200
    13.725   197.398     0.200
    14.405   201.398     0.200
    15.193   216.773     0.200
    19.146   265.297     0.200
    19.146   265.898     0.200
    19.651   271.094     0.200
    20.285   277.648     0.200
     1.450    28.562     0.200
     2.444    41.867     0.200
     2.602    43.766     0.200
     2.696    44.867     0.200
     2.878    48.266     0.200
     3.632    58.562     0.200
     4.037    64.266     0.200
     4.125    64.562     0.200
     4.417    69.469     0.200
     4.972    77.164     0.200
     5.638    85.664     0.200
     6.846   103.367     0.200
     2.466    42.197     0.200
     2.586    42.797     0.200
     1.853    34.322     0.200
     2.442    40.922     0.200
     2.442    41.723     0.200
     2.603    43.621     0.200
     2.696    45.223     0.200
     2.878    47.922     0.200
     4.126    64.723     0.200
     4.038    64.121     0.200
     4.417    69.422     0.200
     4.417    69.223     0.200
     4.972    77.121     0.200
     5.638    84.922     0.200
     6.478    97.322     0.200
     6.846   102.723     0.200
     7.834   114.723     0.200
     7.834   114.422     0.200
     8.358   123.322     0.200
    11.002   158.016     0.200
    15.677   220.021     0.200
    19.142   265.252     0.200
     2.449    41.479     0.200
     2.449    41.580     0.200
     2.599    43.279     0.200
     2.696    45.279     0.200
     2.880    47.680     0.200
     3.632    57.879     0.200
     4.037    64.879     0.200
     4.037    63.779     0.200
     4.120    64.379     0.200
     4.419    69.080     0.200
     4.419    68.879     0.200
     4.972    76.680     0.200
     5.640    85.479     0.200
     5.911    91.080     0.200
     6.480    96.580     0.200
     6.847   102.479     0.200
     6.868   102.680     0.200
     6.943   104.080     0.200
     7.840   114.379     0.200
     7.840   116.180     0.200
     7.903   115.348     0.200
     8.361   122.879     0.200
     8.421   124.180     0.200
     9.481   139.580     0.200
    10.928   158.279     0.200
    11.007   160.973     0.200
    11.185   163.479     0.200
    11.307   164.479     0.200
    13.719   195.879     0.200
    14.017   202.410     0.200
    15.197   215.582     0.200
    15.197   216.680     0.200
    15.484   217.979     0.200
    16.169   227.479     0.200
    17.289   239.074     0.200
    17.289   240.479     0.200
    17.289   240.270     0.200
    19.140   265.049     0.200
    19.140   267.131     0.200
    19.140   264.629     0.200
    19.816   272.604     0.200
    20.287   279.029     0.200
     1.251    24.924     0.200
     2.445    41.424     0.200
     2.481    41.023     0.200
     2.665    44.523     0.200
     3.833    60.725     0.200
     3.834    60.824     0.200
     4.205    65.824     0.200
     1.247    25.322     0.200
     2.050    36.322     0.200
     2.439    41.422     0.200
     2.439    41.623     0.200
     2.482    41.723     0.200
     2.487    41.922     0.200
     2.659    45.123     0.200
     2.659    44.723     0.200
     3.837    59.422     0.200
     3.837    61.223     0.200
     3.830    61.021     0.200
     4.199    65.422     0.200
     4.199    66.021     0.200
     4.766    74.422     0.200
     5.419    82.623     0.200
     6.646    99.322     0.200
     7.735   114.123     0.200
     9.717   143.891     0.200
    11.101   158.240     0.200
     2.458    41.863     0.200
     2.602    43.262     0.200
     2.895    48.863     0.200
     4.119    63.664     0.200
     2.431    42.076     0.200
     2.614    43.976     0.200
     2.881    48.576     0.200
     3.625    58.976     0.200
     4.044    63.876     0.200
     4.138    66.576     0.200
     4.421    70.176     0.200
     4.979    77.476     0.200
     6.480    98.976     0.200
     6.849   103.976     0.200
     6.867   103.376     0.200
     2.439    41.277     0.200
     2.439    41.477     0.200
     2.485    42.078     0.200
     2.481    41.277     0.200
     2.657    44.477     0.200
     2.657    44.578     0.200
     3.490    55.578     0.200
     3.828    60.777     0.200
     3.839    60.875     0.200
     4.061    63.375     0.200
     4.196    65.875     0.200
     4.764    73.477     0.200
     5.237    79.578     0.200
     5.416    82.375     0.200
     6.043    90.875     0.200
     6.256    93.777     0.200
     6.625    98.578     0.200
     6.644    99.277     0.200
     6.720    99.477     0.200
     6.879   102.078     0.200
     7.115   103.875     0.200
     7.401   107.688     0.200
     7.401   107.375     0.200
     7.454   109.875     0.200
     7.651   111.375     0.200
     7.650   112.875     0.200
     7.732   113.676     0.200
     7.955   117.078     0.200
     8.071   119.176     0.200
     8.137   119.578     0.200
     8.115   117.797     0.200
     8.115   118.078     0.200
     8.115   117.648     0.200
     8.115   118.445     0.200
     8.484   123.277     0.200
     8.617   125.977     0.200
     9.009   131.277     0.200
     9.074   132.375     0.200
     9.074   132.578     0.200
     9.257   134.578     0.200
     9.715   140.445     0.200
     9.715   141.477     0.200
    10.704   155.078     0.200
    10.704   156.676     0.200
    10.973   158.176     0.200
    10.973   159.176     0.200
    10.973   158.898     0.200
    11.086   160.277     0.200
    11.102   159.820     0.200
    11.102   159.375     0.200
    11.246   162.238     0.200
    11.270   162.375     0.200
    11.270   162.578     0.200
    12.352   179.875     0.200
    12.383   176.578     0.200
    15.244   214.777     0.200
    15.245   215.992     0.200
    15.245   215.688     0.200
    17.512   243.906     0.200
    18.955   262.602     0.200
    18.955   263.176     0.200
    19.436   269.578     0.200
    19.939   275.727     0.200
    19.937   274.375     0.200
    20.265   278.543     0.200
    20.377   278.277     0.200
    20.869   284.777     0.200
     0.943    21.766     0.200
     2.441    41.969     0.200
     2.611    43.867     0.200
     2.889    48.668     0.200
     3.621    58.066     0.200
     4.048    64.367     0.200
     4.132    65.566     0.200
     4.428    69.367     0.200
     1.846    34.402     0.200
     2.443    42.000     0.200
     2.886    48.203     0.200
     4.129    65.602     0.200
     4.425    69.301     0.200
     2.455    41.508     0.200
     2.896    48.203     0.200
     4.052    64.109     0.200
     1.841    33.523     0.200
     2.444    41.723     0.200
     2.611    43.223     0.200
     2.611    43.723     0.200
     2.710    45.523     0.200
     2.892    48.023     0.200
     3.619    58.422     0.200
     4.130    65.324     0.200
     4.051    64.223     0.200
     4.051    64.023     0.200
     4.431    69.523     0.200
     4.431    69.223     0.200
     4.985    76.922     0.200
     5.652    85.824     0.200
     5.898    89.125     0.200
     6.492    97.125     0.200
     6.860   102.422     0.200
     6.860   102.523     0.200
     6.879   102.523     0.200
     7.190   104.848     0.200
     7.477   111.223     0.200
     7.894   115.734     0.200
     7.847   116.324     0.200
     7.884   117.023     0.200
     8.412   123.422     0.200
     8.372   123.922     0.200
     9.951   146.422     0.200
    10.996   160.465     0.200
    10.996   161.125     0.200
    11.470   165.125     0.200
     1.459    29.078     0.200
     2.451    41.578     0.200
     2.451    41.779     0.200
     2.603    43.379     0.200
     2.705    45.879     0.200
     3.624    58.779     0.200
     4.046    64.178     0.200
     4.428    69.279     0.200
     4.980    77.879     0.200
     5.650    86.678     0.200
     5.650    85.678     0.200
     6.857   102.279     0.200
     7.196   105.678     0.200
     7.484   109.379     0.200
     7.849   114.578     0.200
     7.849   114.379     0.200
     8.370   123.578     0.200
     8.420   123.379     0.200
    11.004   159.922     0.200
    11.004   160.379     0.200
    11.195   160.279     0.200
    18.065   249.879     0.200
    19.147   266.090     0.200
    20.289   278.979     0.200
     2.266    40.000     0.200
     2.322    40.301     0.200
     2.538    42.203     0.200
     3.666    58.801     0.200
     3.973    63.301     0.200
     4.016    63.500     0.200
     4.607    71.703     0.200
     5.161    79.000     0.200
     5.161    79.602     0.200
     6.396    96.500     0.200
     6.396    96.000     0.200
     6.480    97.902     0.200
     6.856   100.727     0.200
     7.141   104.301     0.200
     7.141   105.602     0.200
     7.334   108.500     0.200
     7.334   108.203     0.200
     7.492   111.902     0.200
     8.385   124.102     0.200
    10.448   154.902     0.200
    10.946   158.758     0.200
    11.048   160.320     0.200
    11.048   161.602     0.200
    18.572   260.301     0.200
    18.703   259.926     0.200
    18.854   262.176     0.200
     1.126    23.484     0.200
     1.394    28.484     0.200
     2.209    37.789     0.200
     2.292    39.484     0.200
     2.292    39.586     0.200
     2.325    39.883     0.200
     2.519    41.586     0.200
     2.519    42.188     0.200
     3.345    54.789     0.200
     3.669    58.383     0.200
     4.009    63.789     0.200
     3.984    63.086     0.200
     3.984    62.883     0.200
     4.609    72.383     0.200
     4.950    76.289     0.200
     5.177    79.188     0.200
     6.068    92.883     0.200
     6.019    90.789     0.200
     6.408    96.289     0.200
     6.408    96.086     0.200
     6.405    95.984     0.200
     6.493    97.383     0.200
     6.638    99.086     0.200
     6.887   100.578     0.200
     7.173   104.492     0.200
     7.173   104.086     0.200
     7.363   107.586     0.200
     7.363   107.883     0.200
     7.398   110.688     0.200
     7.506   111.484     0.200
     7.712   113.789     0.200
     7.764   115.688     0.200
     7.887   116.484     0.200
     8.394   120.555     0.200
     8.394   120.969     0.200
     8.394   120.188     0.200
     8.394   121.148     0.200
     8.406   123.188     0.200
     8.385   124.586     0.200
     8.778   130.289     0.200
     8.854   129.984     0.200
     8.854   130.484     0.200
     9.489   139.008     0.200
     9.489   139.375     0.200
     9.489   139.586     0.200
     9.989   146.289     0.200
    10.464   155.484     0.200
    10.464   153.688     0.200
    10.694   156.227     0.200
    10.694   156.086     0.200
    10.694   157.398     0.200
    10.694   155.586     0.200
    10.877   158.086     0.200
    10.877   161.188     0.200
    11.066   160.578     0.200
    11.066   159.484     0.200
    10.962   159.188     0.200
    10.962   159.086     0.200
    10.970   159.742     0.200
    10.970   159.398     0.200
    11.083   160.484     0.200
    12.212   176.383     0.200
    12.424   180.688     0.200
    13.629   195.586     0.200
    13.470   192.188     0.200
    13.922   200.688     0.200
    13.922   198.742     0.200
    14.734   211.289     0.200
    15.132   215.883     0.200
    15.145   216.477     0.200
    15.145   214.789     0.200
    15.145   215.039     0.200
    15.145   215.492     0.200
    15.164   216.289     0.200
    16.265   231.188     0.200
    16.345   232.188     0.200
    16.345   230.984     0.200
    17.738   245.156     0.200
    17.738   246.594     0.200
    18.851   263.789     0.200
    19.036   266.383     0.200
    19.775   275.086     0.200
    19.938   275.578     0.200
    19.937   275.758     0.200
    19.937   275.586     0.200
    20.085   277.617     0.200
     1.404    28.559     0.200
     2.213    39.059     0.200
     2.276    39.457     0.200
     2.531    42.359     0.200
     3.666    58.258     0.200
     1.125    23.449     0.200
     2.214    39.148     0.200
     2.284    39.547     0.200
     2.436    42.148     0.200
     2.524    41.848     0.200
     3.665    58.348     0.200
     3.977    63.648     0.200
     4.015    64.047     0.200
     7.350   109.648     0.200
     1.793    33.584     0.200
     1.682    31.482     0.200
     1.784    33.084     0.200
     2.828    46.283     0.200
     2.862    47.283     0.200
     3.094    49.184     0.200
     3.587    56.783     0.200
     4.162    65.283     0.200
     4.390    68.482     0.200
     6.520    95.709     0.200
     6.791   100.982     0.200
     6.791   101.184     0.200
     7.366   108.584     0.200
     7.840   116.084     0.200
     7.864   117.184     0.200
     9.223   134.684     0.200
    10.487   149.676     0.200
    10.487   152.184     0.200
    10.778   157.482     0.200
    10.831   155.084     0.200
    11.271   162.283     0.200
    19.385   268.932     0.200
     2.219    38.945     0.200
     2.280    39.844     0.200
     2.526    42.641     0.200
     3.661    58.742     0.200
     3.971    63.844     0.200
     4.020    63.242     0.200
     1.404    28.395     0.200
     2.291    39.495     0.200
     2.291    39.595     0.200
     2.517    42.195     0.200
     2.517    42.495     0.200
     3.661    58.794     0.200
     3.975    62.895     0.200
     4.018    64.395     0.200
     6.398    96.695     0.200
     6.882   100.544     0.200
     7.167   105.195     0.200
     7.496   112.195     0.200
     8.405   119.794     0.200
     8.844   130.595     0.200
     9.480   137.744     0.200
    10.684   156.095     0.200
    10.959   157.099     0.200
    11.068   158.782     0.200
    11.068   159.095     0.200
    18.844   262.252     0.200
    19.261   267.395     0.200
     1.395    27.543     0.200
     2.298    38.742     0.200
     2.513    41.441     0.200
     2.513    41.141     0.200
     2.440    41.043     0.200
     3.665    58.141     0.200
     3.665    57.441     0.200
     4.012    62.641     0.200
     3.982    62.441     0.200
     5.175    78.641     0.200
     6.406    95.742     0.200
     6.892    99.617     0.200
     7.177   102.941     0.200
     7.177   103.141     0.200
     7.365   107.441     0.200
     7.504   110.441     0.200
     8.393   119.535     0.200
    11.071   157.008     0.200
    11.071   159.941     0.200
    18.554   256.641     0.200
    18.671   259.043     0.200
     2.435    42.133     0.200
     2.869    48.934     0.200
     4.030    63.934     0.200
     4.408    69.332     0.200
     1.132    25.312     0.200
     2.287    39.711     0.200
     2.447    42.609     0.200
     3.674    58.914     0.200
     4.005    63.414     0.200
     6.884   100.766     0.200
    10.972   159.289     0.200
     2.219    38.742     0.200
     2.294    39.641     0.200
     2.433    40.945     0.200
     3.659    58.641     0.200
     3.974    63.047     0.200
     1.391    28.180     0.200
     2.204    38.383     0.200
     2.330    39.984     0.200
     2.330    39.281     0.200
     2.283    39.383     0.200
     2.527    42.484     0.200
     3.674    58.680     0.200
     4.005    63.180     0.200
     4.005    63.383     0.200
     3.988    62.984     0.200
     4.615    71.680     0.200
     5.179    79.180     0.200
     5.179    79.281     0.200
     6.059    90.484     0.200
     6.411    96.680     0.200
     6.641   100.680     0.200
     6.880   100.305     0.200
     7.165   103.781     0.200
     7.165   105.281     0.200
     7.360   108.883     0.200
     7.509   112.180     0.200
     8.395   119.320     0.200
     8.395   120.750     0.200
     8.395   120.586     0.200
     8.397   122.883     0.200
     8.857   128.984     0.200
     9.492   140.398     0.200
     9.492   135.984     0.200
    10.693   158.477     0.200
    10.693   155.680     0.200
    11.057   159.680     0.200
    11.057   159.484     0.200
    10.969   160.289     0.200
    17.735   246.086     0.200
    18.858   263.336     0.200
    18.858   261.391     0.200
     1.404    28.391     0.200
     2.257    40.391     0.200
     2.275    39.908     0.200
     2.314    39.908     0.200
     3.658    58.808     0.200
     3.967    63.708     0.200
     1.111    23.150     0.200
     1.399    28.051     0.200
     2.220    37.650     0.200
     2.220    39.351     0.200
     2.499    41.650     0.200
     3.657    58.751     0.200
     3.976    63.251     0.200
     4.020    62.551     0.200
     6.904   100.751     0.200
     7.189   104.251     0.200
     8.426   123.851     0.200
     8.392   121.650     0.200
     9.483   136.951     0.200
    10.459   151.451     0.200
    10.696   153.351     0.200
    10.971   156.984     0.200
    11.085   159.318     0.200
    11.085   160.051     0.200
    18.836   261.525     0.200
     1.109    23.328     0.200
     1.413    28.227     0.200
     2.298    40.125     0.200
     2.306    39.422     0.200
     2.508    42.328     0.200
     3.650    58.727     0.200
     3.964    63.328     0.200
     7.348   110.422     0.200
     1.110    23.406     0.200
     1.414    28.906     0.200
     2.294    40.211     0.200
     2.511    42.906     0.200
     3.650    58.805     0.200
     3.964    63.109     0.200
     4.029    63.805     0.200
     7.346   109.609     0.200
     1.129    23.936     0.200
     1.406    28.336     0.200
     2.274    40.036     0.200
     3.666    58.836     0.200
     2.059    35.824     0.200
     2.722    44.824     0.200
     2.939    47.723     0.200
     2.939    48.324     0.200
     3.275    52.922     0.200
     3.880    61.324     0.200
     4.507    69.324     0.200
     4.507    69.625     0.200
     5.704    86.523     0.200
     6.814   102.723     0.200
     6.991   101.848     0.200
     6.980   101.625     0.200
    11.634   167.465     0.200
    18.139   249.922     0.200
     2.201    38.453     0.200
     2.275    39.453     0.200
     2.334    39.953     0.200
     2.535    41.652     0.200
     2.535    42.254     0.200
     3.355    54.652     0.200
     3.678    58.652     0.200
     4.002    63.652     0.200
     4.619    72.152     0.200
     4.619    71.555     0.200
     4.943    75.754     0.200
     5.179    79.152     0.200
     6.022    90.652     0.200
     6.412    95.855     0.200
     6.408    95.855     0.200
     6.497    97.453     0.200
     6.641    99.055     0.200
     6.872   100.527     0.200
     7.157   104.004     0.200
     7.356   107.652     0.200
     7.356   110.355     0.200
     7.399   109.555     0.200
     7.510   110.754     0.200
     7.510   112.055     0.200
     7.767   116.055     0.200
     7.889   116.355     0.200
     8.397   120.363     0.200
     8.397   120.855     0.200
     8.389   123.055     0.200
     8.388   123.652     0.200
     8.781   128.555     0.200
     8.858   131.555     0.200
     8.858   130.754     0.200
     9.032   132.855     0.200
     9.493   137.746     0.200
     9.493   140.055     0.200
     9.493   140.215     0.200
     9.994   147.254     0.200
    10.466   154.152     0.200
    10.466   153.754     0.200
    10.691   155.465     0.200
    10.691   155.652     0.200
    10.691   155.754     0.200
    10.691   155.965     0.200
    10.691   157.152     0.200
    10.883   159.555     0.200
    10.883   159.953     0.200
    10.967   157.832     0.200
    10.967   159.363     0.200
    11.090   160.453     0.200
    12.194   177.652     0.200
    12.410   180.254     0.200
    13.301   192.254     0.200
    13.453   192.055     0.200
    13.904   199.855     0.200
    15.128   216.832     0.200
    15.128   215.453     0.200
    15.128   214.805     0.200
    15.128   216.844     0.200
    15.729   224.152     0.200
    16.053   226.055     0.200
    16.252   232.555     0.200
    16.332   231.844     0.200
    16.399   234.055     0.200
    17.734   248.199     0.200
    17.734   246.555     0.200
    17.734   243.934     0.200
    17.602   249.055     0.200
    18.553   258.504     0.200
    18.553   258.355     0.200
    18.863   263.855     0.200
    19.039   266.773     0.200
    19.023   266.855     0.200
    19.759   275.312     0.200
    19.759   274.754     0.200
    19.923   276.254     0.200
    19.923   275.652     0.200
    19.921   276.055     0.200
    20.027   278.754     0.200
     1.110    22.695     0.200
     1.421    28.996     0.200
     2.287    40.598     0.200
     1.391    27.723     0.200
     2.208    38.723     0.200
     2.299    39.621     0.200
     2.513    42.324     0.200
     3.669    58.922     0.200
     4.009    63.523     0.200
     3.986    63.523     0.200
     4.609    72.121     0.200
     5.180    78.922     0.200
     6.022    91.023     0.200
     6.410    96.723     0.200
     7.370   109.121     0.200
    10.975   159.355     0.200
     1.396    28.102     0.200
     2.297    40.102     0.200
     2.514    42.703     0.200
     3.666    58.902     0.200
     3.982    63.203     0.200
     4.012    63.805     0.200
     5.175    79.504     0.200
     6.406    96.805     0.200
     6.891   100.930     0.200
     7.364   109.504     0.200
     1.129    22.938     0.200
     2.220    37.938     0.200
     2.260    39.641     0.200
     2.318    39.938     0.200
     2.541    42.641     0.200
     3.662    58.742     0.200
     3.967    62.844     0.200
     4.022    63.641     0.200
     4.603    71.641     0.200
     5.153    78.844     0.200
     6.389    95.938     0.200
     7.324   110.141     0.200
     1.092    22.894     0.200
     2.504    41.594     0.200
     3.628    58.294     0.200
     3.939    62.594     0.200
     5.130    78.994     0.200
     1.116    23.570     0.200
     2.218    38.570     0.200
     2.300    40.770     0.200
     2.509    41.869     0.200
     3.659    59.070     0.200
     3.976    63.170     0.200
     4.019    64.270     0.200
     6.399    97.270     0.200
     7.361   109.670     0.200
     1.141    23.766     0.200
     1.387    28.164     0.200
     2.198    38.363     0.200
     2.198    38.465     0.200
     2.276    39.465     0.200
     2.337    40.266     0.200
     2.337    40.164     0.200
     2.536    42.164     0.200
     3.681    58.965     0.200
     3.998    63.363     0.200
     3.993    63.266     0.200
     3.993    63.164     0.200
     4.622    72.266     0.200
     4.947    76.066     0.200
     5.183    79.766     0.200
     6.026    91.164     0.200
     6.412    97.566     0.200
     6.416    96.863     0.200
     6.501    98.266     0.200
     6.645    99.566     0.200
     6.874   100.664     0.200
     7.159   103.805     0.200
     7.360   108.266     0.200
     7.403   109.766     0.200
     7.513   112.066     0.200
     7.513   111.566     0.200
     7.719   116.066     0.200
     7.893   117.164     0.200
     8.393   119.996     0.200
     8.393   120.676     0.200
     8.393   120.164     0.200
     8.389   122.863     0.200
     8.785   129.566     0.200
     9.497   136.164     0.200
    10.470   155.566     0.200
    10.695   153.996     0.200
    10.695   156.363     0.200
    10.695   154.363     0.200
    10.695   156.824     0.200
    10.695   154.965     0.200
    10.886   160.266     0.200
    10.886   160.664     0.200
    10.963   158.363     0.200
    10.964   158.566     0.200
    10.971   159.617     0.200
    10.971   158.895     0.200
    11.049   160.758     0.200
    11.049   159.465     0.200
    11.093   161.363     0.200
    15.115   214.766     0.200
    15.128   214.566     0.200
    15.128   215.055     0.200
    15.147   215.266     0.200
    16.104   225.266     0.200
    17.730   247.883     0.200
    17.730   247.566     0.200
    17.730   246.863     0.200
    18.045   251.465     0.200
    18.549   257.590     0.200
    18.865   263.574     0.200
    18.865   262.613     0.200
    19.282   267.066     0.200
    19.760   273.566     0.200
    19.760   274.824     0.200
    20.069   277.113     0.200
    20.069   276.715     0.200
    20.591   283.363     0.200
     1.143    23.387     0.200
     1.381    27.488     0.200
     2.280    39.086     0.200
     2.341    39.586     0.200
     2.534    42.387     0.200
     3.685    58.086     0.200
     3.999    62.988     0.200
     4.626    71.488     0.200
     7.367   109.387     0.200
     1.391    28.508     0.200
     2.291    40.102     0.200
     2.328    39.406     0.200
     2.521    42.203     0.200
     3.672    58.406     0.200
     3.987    63.203     0.200
     4.006    63.805     0.200
     4.613    71.906     0.200
     5.180    79.703     0.200
     5.180    79.602     0.200
     6.411    96.906     0.200
     6.888   101.133     0.200
     7.365   109.602     0.200
     7.365   108.406     0.200
     8.392   122.977     0.200
     8.392   123.102     0.200
    10.697   153.703     0.200
    11.063   161.000     0.200
    11.063   160.406     0.200
    20.084   277.250     0.200
     1.381    27.984     0.200
     2.278    39.383     0.200
     2.536    42.180     0.200
     3.685    59.086     0.200
     3.994    63.484     0.200
     3.998    63.281     0.200
     4.626    72.086     0.200
     5.189    79.781     0.200
     7.366   109.281     0.200
     1.099    23.480     0.200
     1.434    29.480     0.200
     3.635    58.781     0.200
     3.946    63.383     0.200
     4.045    63.980     0.200
     4.576    71.980     0.200
     5.137    79.980     0.200
     7.326   109.684     0.200
     2.236    39.605     0.200
     2.291    39.707     0.200
     3.643    58.906     0.200
     3.643    58.707     0.200
     3.955    63.008     0.200
     3.955    62.906     0.200
     4.037    64.305     0.200
     4.584    72.406     0.200
     4.921    74.605     0.200
     5.146    79.305     0.200
     6.873   101.582     0.200
     8.425   122.500     0.200
     8.425   122.707     0.200
    10.939   157.484     0.200
    11.075   159.875     0.200
    11.075   160.305     0.200
    18.828   263.359     0.200
     1.098    23.411     0.200
     2.295    40.611     0.200
     3.948    63.311     0.200
     5.140    78.611     0.200
     5.982    91.511     0.200
     2.267    40.363     0.200
     3.693    59.463     0.200
     3.987    63.162     0.200
     4.004    63.863     0.200
     4.634    72.463     0.200
     7.363   108.363     0.200
     2.273    40.254     0.200
     3.992    63.354     0.200
     2.282    39.992     0.200
     3.684    59.090     0.200
     3.995    64.691     0.200
     3.998    63.891     0.200
     7.368   109.793     0.200
     1.118    24.779     0.200
     2.232    40.079     0.200
     2.267    40.279     0.200
     2.307    40.479     0.200
     2.532    42.479     0.200
     3.650    58.680     0.200
     3.956    63.079     0.200
     4.033    64.979     0.200
     4.033    64.680     0.200
     4.591    71.779     0.200
     4.905    75.680     0.200
     4.905    75.479     0.200
     5.143    79.079     0.200
     5.143    79.279     0.200
     5.986    91.279     0.200
     6.067    92.680     0.200
     6.372    97.479     0.200
     6.462    97.880     0.200
     6.849   101.005     0.200
     7.134   104.140     0.200
     7.134   104.279     0.200
     7.318   109.380     0.200
     7.361   109.680     0.200
     7.474   110.979     0.200
     7.474   110.680     0.200
     7.678   113.880     0.200
     7.851   116.479     0.200
     8.390   123.979     0.200
     8.436   122.911     0.200
     8.436   121.659     0.200
     8.436   122.579     0.200
     8.436   125.079     0.200
     8.745   128.279     0.200
     8.996   132.279     0.200
     9.458   137.012     0.200
     9.458   137.470     0.200
     9.458   138.380     0.200
     9.458   136.189     0.200
     9.960   147.079     0.200
    10.430   153.779     0.200
    10.430   152.779     0.200
    10.652   154.460     0.200
    10.652   156.979     0.200
    10.652   155.180     0.200
    10.652   153.859     0.200
    10.652   155.479     0.200
    10.920   158.479     0.200
    10.921   158.479     0.200
    10.928   157.789     0.200
    10.928   158.529     0.200
    11.058   162.180     0.200
    11.056   160.598     0.200
    11.056   161.380     0.200
    13.268   192.380     0.200
    15.112   217.079     0.200
    15.125   215.217     0.200
    15.125   216.069     0.200
    15.144   217.479     0.200
    16.141   227.779     0.200
    18.061   252.079     0.200
    18.590   258.954     0.200
    18.590   259.579     0.200
    18.840   261.555     0.200
    18.840   262.020     0.200
    19.249   267.880     0.200
    19.742   273.279     0.200
    19.934   274.520     0.200
    19.934   275.279     0.200
    19.932   275.505     0.200
    20.026   276.279     0.200
    20.053   276.847     0.200
     1.113    23.133     0.200
     3.650    58.633     0.200
     3.960    62.828     0.200
     5.150    79.133     0.200
     7.334   110.328     0.200
     1.123    23.686     0.200
     3.657    58.285     0.200
     3.964    63.186     0.200
     1.090    22.559     0.200
     2.301    39.959     0.200
     3.628    57.760     0.200
     3.941    62.559     0.200
     5.133    79.059     0.200
     2.280    39.816     0.200
     3.679    58.613     0.200
     3.991    63.516     0.200
     7.361   108.414     0.200
     1.103    22.914     0.200
     1.420    28.516     0.200
     2.235    39.414     0.200
     2.300    40.812     0.200
     3.643    58.711     0.200
     3.958    63.414     0.200
     5.151    79.312     0.200
     7.344   109.812     0.200
     1.114    23.430     0.200
     2.267    40.430     0.200
     3.644    58.729     0.200
     3.949    63.130     0.200
     7.312   109.229     0.200
     1.090    23.180     0.200
     2.299    40.477     0.200
     3.627    58.383     0.200
     3.939    62.383     0.200
     7.325   110.078     0.200
     3.643    59.392     0.200
     3.940    63.492     0.200
     6.361    96.892     0.200
     7.283   108.092     0.200
     3.663    60.430     0.200
     3.949    63.430     0.200
     4.031    63.227     0.200
     1.122    23.561     0.200
     2.275    40.459     0.200
     2.529    43.160     0.200
     3.657    57.859     0.200
     1.124    23.270     0.200
     1.408    28.770     0.200
     2.218    39.066     0.200
     2.280    39.566     0.200
     2.526    42.168     0.200
     3.662    58.770     0.200
     3.973    62.867     0.200
     4.019    63.668     0.200
     6.396    96.367     0.200
     1.423    29.250     0.200
     2.272    40.148     0.200
     2.529    42.547     0.200
     3.652    58.445     0.200
     3.959    63.148     0.200
     5.147    78.945     0.200
     6.381    96.750     0.200
     6.609    99.148     0.200
     7.325   108.547     0.200
     8.430   122.664     0.200
    10.934   158.070     0.200
    18.840   261.180     0.200
     1.090    22.406     0.200
     1.435    28.609     0.200
     2.249    39.109     0.200
     2.497    42.008     0.200
     2.497    41.508     0.200
     3.629    58.211     0.200
     3.943    62.805     0.200
     3.943    62.906     0.200
     4.050    64.211     0.200
     4.050    62.711     0.200
     4.570    70.906     0.200
     5.136    78.906     0.200
     5.136    79.211     0.200
     5.979    90.109     0.200
     6.367    95.711     0.200
     6.367    96.008     0.200
     6.882   101.562     0.200
    10.933   158.547     0.200
     1.122    23.383     0.200
     1.436    29.184     0.200
     2.252    40.383     0.200
     2.545    42.980     0.200
     3.649    59.281     0.200
     3.950    63.383     0.200
     5.134    78.980     0.200
     7.302   108.883     0.200
     1.103    23.469     0.200
     2.246    40.375     0.200
     2.277    40.375     0.200
     3.636    58.875     0.200
     3.942    63.070     0.200
     4.047    63.273     0.200
     5.131    79.375     0.200
     6.365    96.070     0.200
     7.313   109.773     0.200
     2.289    39.695     0.200
     2.289    38.797     0.200
     2.511    41.297     0.200
     3.638    58.297     0.200
     3.638    57.797     0.200
     3.949    62.602     0.200
     4.043    65.695     0.200
     4.579    71.500     0.200
     5.139    78.602     0.200
     5.982    90.398     0.200
     6.372    95.602     0.200
     6.869   100.875     0.200
     7.327   108.195     0.200
     7.849   116.398     0.200
     8.411   122.195     0.200
     9.453   136.898     0.200
    10.656   152.297     0.200
    10.931   157.039     0.200
    11.076   161.344     0.200
    11.076   160.797     0.200
    15.147   214.195     0.200
    18.825   262.125     0.200
    19.238   265.797     0.200
     1.111    23.477     0.200
     1.434    29.078     0.200
     2.271    40.875     0.200
     3.643    58.977     0.200
     3.949    63.477     0.200
     4.040    65.078     0.200
     5.137    79.375     0.200
     6.371    95.578     0.200
     7.315   108.680     0.200
     1.100    23.344     0.200
     2.277    40.242     0.200
     3.632    58.242     0.200
     3.938    62.945     0.200
     5.126    78.945     0.200
     6.361    95.742     0.200
     7.309   108.945     0.200
     1.108    23.297     0.200
     2.279    40.098     0.200
     2.239    39.598     0.200
     3.642    58.598     0.200
     3.950    62.996     0.200
     4.040    63.496     0.200
     5.139    79.098     0.200
     5.982    90.297     0.200
     6.373    95.297     0.200
     6.860   101.121     0.200
    10.928   158.662     0.200
     1.443    28.632     0.200
     2.279    40.232     0.200
     3.631    58.433     0.200
     3.938    62.632     0.200
     5.127    78.433     0.200
     7.311   110.132     0.200
     1.106    23.059     0.200
     1.435    28.559     0.200
     2.278    39.859     0.200
     2.520    42.959     0.200
     3.639    58.059     0.200
     3.946    62.559     0.200
     5.135    79.359     0.200
     7.317   109.059     0.200
     1.123    23.477     0.200
     1.400    27.477     0.200
     2.289    40.680     0.200
     2.519    42.078     0.200
     3.665    59.379     0.200
     3.979    63.379     0.200
     4.014    63.180     0.200
     7.356   109.680     0.200
     2.285    39.289     0.200
     2.282    40.492     0.200
     3.628    58.891     0.200
     3.935    63.086     0.200
     4.054    64.789     0.200
     5.124    79.289     0.200
     1.108    23.258     0.200
     1.431    29.358     0.200
     2.280    39.858     0.200
     2.280    40.258     0.200
     2.239    39.858     0.200
     2.519    42.258     0.200
     3.642    58.858     0.200
     3.950    63.058     0.200
     4.040    64.158     0.200
     5.140    79.258     0.200
     6.861   101.558     0.200
    11.068   161.576     0.200
     1.103    23.363     0.200
     2.246    39.164     0.200
     2.519    43.563     0.200
     3.635    58.664     0.200
     3.942    62.964     0.200
     1.102    23.467     0.200
     1.447    29.566     0.200
     2.251    39.467     0.200
     2.288    39.467     0.200
     2.272    40.768     0.200
     2.523    42.168     0.200
     1.103    23.340     0.200
     2.279    40.941     0.200
     3.636    58.641     0.200
     3.943    62.941     0.200
     4.047    64.340     0.200
     6.365    95.941     0.200
     7.315   108.141     0.200
     1.091    22.998     0.200
     1.438    29.098     0.200
     2.300    40.297     0.200
     2.399    41.398     0.200
     3.628    58.398     0.200
     3.941    62.797     0.200
     5.133    79.197     0.200
     5.976    90.598     0.200
     7.328   109.697     0.200
     1.090    22.938     0.200
     2.282    39.838     0.200
     2.297    40.338     0.200
     2.396    41.438     0.200
     2.253    38.938     0.200
     2.253    40.637     0.200
     2.501    42.037     0.200
     3.626    58.338     0.200
     3.938    62.838     0.200
     4.054    64.238     0.200
     4.567    71.938     0.200
     4.909    74.238     0.200
     5.129    78.938     0.200
     5.972    90.738     0.200
     6.098    92.738     0.200
     6.358    95.838     0.200
     6.361    96.338     0.200
     6.873   101.062     0.200
     7.158   104.637     0.200
     7.323   108.037     0.200
     7.351   109.537     0.200
     7.459   111.137     0.200
     7.840   116.238     0.200
     8.421   123.738     0.200
     8.439   122.807     0.200
     8.439   123.797     0.200
     8.439   123.637     0.200
     9.442   138.637     0.200
    10.831   155.738     0.200
    10.924   158.338     0.200
    10.924   158.098     0.200
    11.038   160.238     0.200
    11.087   161.230     0.200
    11.087   160.438     0.200
    12.215   179.238     0.200
    15.156   217.508     0.200
    16.128   224.438     0.200
    18.091   251.338     0.200
    18.600   260.062     0.200
    18.812   260.912     0.200
    18.812   260.637     0.200
    19.226   266.537     0.200
    20.545   284.438     0.200
     1.432    28.914     0.200
     2.308    40.215     0.200
     2.404    41.314     0.200
     3.630    58.414     0.200
     3.945    62.715     0.200
     4.049    63.215     0.200
     4.571    70.314     0.200
     5.139    79.016     0.200
     5.982    90.516     0.200
     6.369    96.115     0.200
     7.338   107.615     0.200
     2.298    39.734     0.200
     3.652    58.141     0.200
     3.966    62.734     0.200
     5.159    78.836     0.200
     1.452    29.152     0.200
     2.451    41.652     0.200
     2.599    43.555     0.200
     3.630    58.754     0.200
     3.630    58.453     0.200
     4.039    64.055     0.200
     4.039    63.855     0.200
     4.421    69.152     0.200
     5.911    89.453     0.200
     7.194   104.379     0.200
     7.843   114.355     0.200
     7.843   114.152     0.200
     7.958   117.453     0.200
     7.900   112.566     0.200
     8.363   123.055     0.200
     8.422   123.555     0.200
     9.941   145.023     0.200
    11.008   158.223     0.200
    11.008   157.254     0.200
    11.188   161.652     0.200
    11.463   163.832     0.200
    13.721   195.754     0.200
    18.072   250.555     0.200
    18.562   257.254     0.200
    19.141   264.059     0.200
     1.103    22.922     0.200
     3.639    59.219     0.200
     3.949    63.117     0.200
     7.326   109.320     0.200
     2.045    36.387     0.200
     2.452    41.387     0.200
     2.477    41.285     0.200
     2.494    42.086     0.200
     3.831    60.984     0.200
     3.836    60.684     0.200
     4.209    65.785     0.200
     4.772    74.086     0.200
     5.430    82.484     0.200
     6.637    99.086     0.200
     7.131   104.035     0.200
     7.670   111.684     0.200
     8.152   119.684     0.200
    11.107   159.305     0.200
    11.263   160.883     0.200
     1.142    23.508     0.200
     1.378    27.602     0.200
     2.285    39.703     0.200
     2.341    40.203     0.200
     3.685    58.602     0.200
     4.000    63.602     0.200
     2.259    40.045     0.200
     2.554    42.645     0.200
     3.696    59.445     0.200
     4.004    63.845     0.200
     5.192    79.945     0.200
     6.035    91.945     0.200
     6.427    97.045     0.200
     6.861   101.120     0.200
     7.358   108.045     0.200
     8.391   123.059     0.200
    11.030   160.863     0.200
    10.974   158.778     0.200
     1.443    29.164     0.200
     2.448    41.664     0.200
     2.872    48.164     0.200
     4.411    69.266     0.200
     5.632    85.367     0.200
     1.196    24.504     0.200
     1.196    26.205     0.200
     1.332    27.705     0.200
     2.250    40.104     0.200
     2.509    43.305     0.200
     2.576    43.205     0.200
     3.739    59.504     0.200
     3.941    62.705     0.200
     4.050    64.305     0.200
     4.680    72.504     0.200
     5.238    81.404     0.200
     6.473    98.205     0.200
     1.125    23.101     0.200
     2.293    40.001     0.200
     2.210    38.701     0.200
     2.442    41.901     0.200
     2.518    42.401     0.200
     3.668    59.201     0.200
     3.983    63.201     0.200
     4.010    63.601     0.200
     4.609    72.001     0.200
     5.176    79.601     0.200
     6.407    97.101     0.200
     6.887   101.201     0.200
     7.172   107.201     0.200
     7.216   108.501     0.200
     7.363   109.301     0.200
     7.505   112.101     0.200
     7.886   117.401     0.200
     8.406   124.301     0.200
    10.969   159.101     0.200
    11.066   160.594     0.200
    18.554   258.151     0.200
    18.850   261.892     0.200
    20.085   276.303     0.200
     2.315    39.578     0.200
     2.286    39.578     0.200
     2.220    38.078     0.200
     2.430    41.379     0.200
     2.520    41.680     0.200
     3.659    58.477     0.200
     3.972    62.777     0.200
     4.020    62.777     0.200
     4.600    71.379     0.200
     5.163    78.977     0.200
     6.006    90.277     0.200
     6.391    96.578     0.200
     6.395    95.477     0.200
     6.876   100.430     0.200
     7.161   106.277     0.200
     7.347   108.977     0.200
     7.492   110.379     0.200
     7.873   116.277     0.200
     8.403   123.578     0.200
     8.410   120.422     0.200
    10.954   158.723     0.200
    11.065   158.695     0.200
    18.844   262.277     0.200
     1.425    29.090     0.200
     2.281    40.191     0.200
     2.414    41.691     0.200
     3.646    58.590     0.200
     3.956    63.391     0.200
     4.035    64.191     0.200
     5.145    79.590     0.200
     7.328   109.293     0.200
     2.199    38.305     0.200
     2.884    47.805     0.200
     4.100    64.406     0.200
     4.425    69.105     0.200
     6.848   102.805     0.200
     1.112    23.672     0.200
     2.304    40.072     0.200
     2.304    39.972     0.200
     3.656    59.372     0.200
     3.973    63.172     0.200
     3.973    63.072     0.200
     5.168    79.272     0.200
     6.397    95.272     0.200
     7.361   109.272     0.200
     1.091    22.617     0.200
     2.241    37.918     0.200
     2.486    41.520     0.200
     3.635    58.020     0.200
     3.955    62.316     0.200
     4.576    71.617     0.200
     5.151    78.617     0.200
     6.379    95.617     0.200
     6.903   100.395     0.200
    11.099   159.762     0.200
    10.952   157.461     0.200
     1.091    23.022     0.200
     2.289    40.123     0.200
     3.625    58.423     0.200
     3.934    62.623     0.200
     5.124    78.623     0.200
     2.443    42.055     0.200
     2.596    43.258     0.200
     4.028    63.758     0.200
     4.407    69.156     0.200
     5.628    85.852     0.200
     6.836   102.852     0.200
     1.444    29.023     0.200
     2.440    42.023     0.200
     2.870    47.922     0.200
     4.030    63.922     0.200
     4.409    68.922     0.200
     6.838   103.223     0.200
     1.104    22.984     0.200
     2.293    40.285     0.200
     2.298    39.885     0.200
     2.412    41.584     0.200
     2.509    42.885     0.200
     3.642    58.385     0.200
     3.954    62.785     0.200
     4.361    67.811     0.200
     4.921    73.484     0.200
     6.377    95.885     0.200
     6.377    96.186     0.200
     6.875   101.096     0.200
     7.335   107.385     0.200
     7.335   107.885     0.200
    10.938   158.445     0.200
    11.077   161.553     0.200
     0.948    21.619     0.200
     1.450    28.820     0.200
     2.138    37.619     0.200
     2.200    38.721     0.200
     2.429    41.820     0.200
     2.723    45.721     0.200
     3.535    57.420     0.200
     3.938    62.092     0.200
     3.958    63.119     0.200
     4.466    70.020     0.200
     5.215    80.820     0.200
     6.048    91.820     0.200
     6.387    96.221     0.200
     7.312   107.346     0.200
     7.469   111.721     0.200
     7.506   112.320     0.200
     7.596   110.430     0.200
     7.596   110.320     0.200
     7.632   111.820     0.200
     8.235   118.410     0.200
     8.235   118.189     0.200
     8.235   118.520     0.200
     7.951   118.619     0.200
     8.810   130.020     0.200
     9.034   133.820     0.200
     9.486   138.713     0.200
     9.486   139.340     0.200
     9.486   139.020     0.200
    10.499   155.320     0.200
    10.499   154.221     0.200
    10.834   158.119     0.200
    10.834   157.721     0.200
    10.870   157.660     0.200
    10.870   157.820     0.200
    10.870   156.221     0.200
    10.995   159.520     0.200
    10.995   158.920     0.200
    11.124   162.320     0.200
    11.125   162.221     0.200
    11.132   161.660     0.200
    11.132   161.330     0.200
    11.443   164.938     0.200
    11.443   165.420     0.200
    12.643   179.619     0.200
    12.855   187.119     0.200
    15.548   221.619     0.200
    15.561   221.881     0.200
    15.561   223.939     0.200
    15.580   222.320     0.200
    16.726   238.221     0.200
    17.750   245.414     0.200
    17.750   247.420     0.200
    18.245   250.895     0.200
    18.245   252.619     0.200
    18.376   256.020     0.200
    20.286   279.881     0.200
    20.284   279.920     0.200
     0.933    21.213     0.200
     2.136    37.414     0.200
     2.412    41.713     0.200
     2.718    46.113     0.200
     2.718    45.914     0.200
     3.521    57.113     0.200
     3.941    62.814     0.200
     3.941    62.213     0.200
     7.614   112.814     0.200
     8.254   121.809     0.200
    18.251   253.264     0.200
     2.140    37.809     0.200
     2.720    45.709     0.200
     3.535    57.408     0.200
     3.956    62.908     0.200
     6.386    96.508     0.200
     2.132    36.693     0.200
     2.132    36.795     0.200
     2.415    41.895     0.200
     2.724    45.594     0.200
     3.522    56.494     0.200
     3.522    56.094     0.200
     3.936    62.291     0.200
     3.944    62.895     0.200
     5.192    78.895     0.200
     5.201    79.795     0.200
     5.201    80.895     0.200
     6.399    97.295     0.200
     6.373    96.193     0.200
     7.307   106.670     0.200
     7.455   110.795     0.200
     7.493   110.494     0.200
     7.591   111.545     0.200
     7.621   111.693     0.200
     7.938   117.295     0.200
     8.248   119.773     0.200
     8.248   119.193     0.200
     8.814   128.994     0.200
     9.472   138.564     0.200
    10.821   157.693     0.200
    10.821   158.693     0.200
    10.857   156.924     0.200
    10.857   156.594     0.200
    10.982   160.193     0.200
    10.982   158.594     0.200
    11.119   162.463     0.200
    11.119   160.975     0.200
    11.448   163.236     0.200
    11.448   164.094     0.200
    12.644   180.994     0.200
    16.005   222.994     0.200
    18.244   249.920     0.200
    18.385   255.604     0.200
     1.462    29.070     0.200
     2.149    37.570     0.200
     2.186    38.469     0.200
     2.376    41.672     0.200
     2.409    41.672     0.200
     2.701    45.672     0.200
     3.523    57.070     0.200
     3.939    63.070     0.200
     5.174    78.273     0.200
     5.193    79.773     0.200
     6.027    91.773     0.200
     6.369    95.969     0.200
     6.384    96.367     0.200
     7.602   113.773     0.200
     2.129    37.508     0.200
     2.184    38.312     0.200
     2.384    41.711     0.200
     2.413    41.906     0.200
     2.726    45.609     0.200
     3.520    57.406     0.200
     3.934    62.086     0.200
     3.942    63.008     0.200
     4.451    70.312     0.200
     5.199    79.906     0.200
     6.032    92.109     0.200
     6.371    96.312     0.200
     6.401    96.812     0.200
     6.478    97.406     0.200
     6.662   100.812     0.200
     7.308   107.508     0.200
     7.453   111.609     0.200
     7.490   111.906     0.200
     7.592   112.711     0.200
     7.620   112.711     0.200
     7.936   118.711     0.200
     8.250   119.703     0.200
     8.772   129.906     0.200
    11.117   161.906     0.200
    11.451   166.750     0.200
    18.243   251.383     0.200
    18.498   256.734     0.200
    18.611   258.773     0.200
    20.521   283.336     0.200
     0.930    21.326     0.200
     2.143    37.526     0.200
     2.706    45.826     0.200
     3.518    57.126     0.200
     3.935    62.826     0.200
     3.952    62.501     0.200
     4.156    65.726     0.200
     7.286   105.906     0.200
    18.615   258.740     0.200
     1.463    29.135     0.200
     2.450    41.834     0.200
     2.607    43.934     0.200
     3.620    58.434     0.200
     4.050    62.533     0.200
     4.432    69.934     0.200
     5.653    86.234     0.200
     6.860   103.434     0.200
     1.101    23.430     0.200
     1.448    30.125     0.200
     2.273    40.523     0.200
     2.394    42.023     0.200
     3.630    58.227     0.200
     3.935    63.227     0.200
     1.091    22.316     0.200
     1.438    27.719     0.200
     2.298    40.117     0.200
     3.629    58.117     0.200
     3.941    62.617     0.200
     4.355    67.344     0.200
     5.133    79.020     0.200
     5.976    90.617     0.200
     7.327   109.020     0.200
    10.928   159.789     0.200
    11.087   160.234     0.200
     2.296    38.826     0.200
     3.894    62.326     0.200
     4.097    63.926     0.200
     4.347    67.151     0.200
     7.288   107.125     0.200
     8.480   124.619     0.200
    10.883   157.446     0.200
    11.110   162.769     0.200
     1.781    33.336     0.200
     2.318    40.938     0.200
     2.563    43.836     0.200
     3.343    54.734     0.200
     3.612    58.633     0.200
     4.366    68.539     0.200
     4.368    67.883     0.200
     4.591    72.836     0.200
     6.732    99.008     0.200
    11.205   160.531     0.200
     1.318    26.605     0.200
     1.980    35.105     0.200
     2.423    41.605     0.200
     2.532    42.006     0.200
     2.559    43.305     0.200
     2.731    45.805     0.200
     3.765    59.105     0.200
     3.901    61.506     0.200
     4.271    67.006     0.200
     4.838    74.805     0.200
     0.995    21.371     0.200
     2.390    41.570     0.200
     2.401    40.570     0.200
     2.330    40.371     0.200
     3.543    57.270     0.200
     3.872    61.371     0.200
     4.263    66.570     0.200
     4.483    68.871     0.200
     6.297    95.168     0.200
     6.940   101.605     0.200
     2.239    38.676     0.200
     2.239    39.276     0.200
     2.291    38.976     0.200
     2.291    39.476     0.200
     2.358    40.776     0.200
     2.425    41.276     0.200
     2.456    40.676     0.200
     2.456    40.776     0.200
     3.635    58.276     0.200
     3.966    62.776     0.200
     4.037    64.376     0.200
     4.297    66.151     0.200
     5.169    78.876     0.200
     5.169    79.076     0.200
     6.011    90.476     0.200
     6.122    93.176     0.200
     6.392    95.576     0.200
     6.948   101.451     0.200
     7.232   104.876     0.200
     8.380   121.576     0.200
     8.470   124.576     0.200
     9.476   136.476     0.200
    10.709   154.776     0.200
    10.982   158.196     0.200
    11.058   158.976     0.200
    11.127   160.869     0.200
    11.127   161.176     0.200
    13.275   189.076     0.200
    15.210   214.976     0.200
    15.210   214.390     0.200
    16.053   223.344     0.200
     0.889    19.297     0.200
     2.110    35.898     0.200
     2.140    36.598     0.200
     2.423    40.496     0.200
     2.367    39.797     0.200
     2.367    39.695     0.200
     2.727    44.398     0.200
     3.131    50.496     0.200
     3.477    55.297     0.200
     3.928    60.070     0.200
     3.896    60.996     0.200
     4.198    65.496     0.200
     4.409    67.996     0.200
     5.153    77.695     0.200
     5.151    77.898     0.200
     5.986    89.195     0.200
     6.325    93.797     0.200
     6.376    94.496     0.200
     6.427    95.398     0.200
     6.432    95.098     0.200
     7.183   106.195     0.200
     7.292   104.695     0.200
     7.407   108.398     0.200
     7.444   109.098     0.200
     7.576   107.695     0.200
     7.581   109.297     0.200
     7.889   115.098     0.200
     8.295   117.887     0.200
     8.295   118.336     0.200
     8.295   117.996     0.200
     8.337   121.195     0.200
     8.726   126.695     0.200
     8.777   127.496     0.200
     8.828   127.297     0.200
     8.972   130.398     0.200
     9.424   135.035     0.200
     9.424   135.363     0.200
     9.424   136.996     0.200
     9.424   134.496     0.200
     9.896   142.398     0.200
    10.437   151.797     0.200
    10.437   150.898     0.200
    10.773   154.996     0.200
    10.811   154.625     0.200
    10.811   154.457     0.200
    10.811   154.898     0.200
    10.935   156.797     0.200
    10.935   157.098     0.200
    11.073   158.117     0.200
    11.073   158.375     0.200
    11.469   164.441     0.200
    11.469   164.898     0.200
    12.647   180.195     0.200
    12.770   183.398     0.200
    13.179   188.195     0.200
    14.356   205.398     0.200
    15.575   219.820     0.200
    16.276   227.797     0.200
    17.811   246.539     0.200
    17.811   244.688     0.200
    18.241   249.547     0.200
     7.292   104.809     0.200
     3.928    61.047     0.200
    15.574   219.656     0.200
     1.900    33.684     0.200
     2.186    37.684     0.200
     2.964    48.086     0.200
     3.475    55.586     0.200
     4.735    73.285     0.200
     5.010    76.785     0.200
     5.083    75.559     0.200
     5.089    77.684     0.200
     5.583    83.984     0.200
     6.767    98.035     0.200
     7.057   100.984     0.200
     7.653   112.785     0.200
     7.714   111.852     0.200
     7.714   111.707     0.200
     7.926   116.285     0.200
    10.201   146.027     0.200
    10.201   146.285     0.200
    11.442   167.684     0.200
    14.322   205.285     0.200
    16.767   233.102     0.200
    17.686   244.387     0.200
     5.083    77.566     0.200
     2.252    39.266     0.200
     2.287    39.863     0.200
     3.628    58.164     0.200
     3.937    62.566     0.200
     5.127    78.863     0.200
     1.461    29.047     0.200
     2.166    37.547     0.200
     2.371    41.246     0.200
     2.403    41.547     0.200
     2.680    45.645     0.200
     2.680    45.445     0.200
     3.524    55.945     0.200
     3.978    62.898     0.200
     4.457    70.047     0.200
     6.364    95.945     0.200
     6.371    95.344     0.200
     7.544   110.145     0.200
     7.584   113.547     0.200
     8.274   119.246     0.200
     8.274   118.664     0.200
    11.413   167.973     0.200
     0.930    20.148     0.200
     2.352    40.047     0.200
     2.449    40.844     0.200
     5.772    87.445     0.200
     6.160    93.047     0.200
     1.637    31.973     0.200
     2.202    38.973     0.200
     2.344    41.371     0.200
     2.442    42.871     0.200
     3.444    56.070     0.200
     4.244    67.570     0.200
     4.934    76.371     0.200
     1.640    32.168     0.200
     2.197    39.066     0.200
     2.355    41.266     0.200
     2.448    42.766     0.200
     3.437    55.965     0.200
     4.307    66.691     0.200
     4.250    67.465     0.200
     4.378    68.965     0.200
     4.931    76.465     0.200
     6.246    94.066     0.200
     7.123   104.266     0.200
     7.172   104.566     0.200
     8.619   122.465     0.200
     9.243   133.766     0.200
    11.201   160.066     0.200
    11.201   162.836     0.200
    12.940   181.668     0.200
    16.243   227.867     0.200
     2.179    39.074     0.200
     2.406    40.477     0.200
     3.420    55.875     0.200
     4.307    66.727     0.200
     6.833   100.426     0.200
    10.724   155.234     0.200
    11.209   162.867     0.200
     2.357    41.375     0.200
     2.180    38.672     0.200
     2.406    40.375     0.200
     3.421    55.773     0.200
     3.721    60.172     0.200
     4.307    66.570     0.200
     4.735    75.375     0.200
     6.257    95.070     0.200
     6.834   100.477     0.200
     7.156   105.977     0.200
    10.200   148.172     0.200
    10.453   153.477     0.200
    10.614   153.273     0.200
    10.725   157.102     0.200
    11.208   163.672     0.200
    12.924   183.977     0.200
     2.189    38.750     0.200
     2.422    40.750     0.200
     3.434    56.047     0.200
     3.730    60.250     0.200
     4.322    66.922     0.200
     6.822   100.039     0.200
     9.233   137.391     0.200
    10.727   156.172     0.200
    11.192   161.289     0.200
     2.180    38.836     0.200
     2.399    40.535     0.200
     2.365    41.236     0.200
     2.365    41.436     0.200
     4.299    67.242     0.200
     4.741    72.035     0.200
     6.145    93.236     0.200
     6.261    94.635     0.200
     6.842   100.811     0.200
     7.125   104.336     0.200
     7.163   105.936     0.200
     7.163   105.736     0.200
     8.590   127.535     0.200
     8.632   126.936     0.200
     8.632   127.186     0.200
     8.632   126.828     0.200
     9.226   136.965     0.200
     9.226   136.158     0.200
    10.202   148.535     0.200
    10.458   152.236     0.200
    10.615   155.635     0.200
    10.729   156.756     0.200
    10.729   156.496     0.200
    11.214   160.736     0.200
    11.214   161.479     0.200
    12.923   186.035     0.200
    15.240   217.623     0.200
     2.208    38.533     0.200
     2.413    40.332     0.200
     2.353    40.732     0.200
     2.353    41.033     0.200
     2.438    41.434     0.200
     3.446    55.533     0.200
     4.308    66.840     0.200
     6.172    93.033     0.200
     6.239    94.633     0.200
     6.844   100.844     0.200
     7.127   104.863     0.200
     8.608   125.434     0.200
     8.608   125.742     0.200
     8.608   124.213     0.200
     8.608   124.381     0.200
     8.618   129.232     0.200
     9.253   138.633     0.200
     9.253   134.854     0.200
     9.253   135.322     0.200
    10.229   151.732     0.200
    10.481   156.033     0.200
    10.481   155.594     0.200
    10.481   151.863     0.200
    10.642   156.934     0.200
    10.753   156.572     0.200
    11.196   162.934     0.200
    11.196   161.828     0.200
    12.950   186.033     0.200
    15.227   219.062     0.200
    15.227   217.814     0.200
    17.974   250.275     0.200
     3.452    55.914     0.200
     3.753    60.314     0.200
     4.314    66.814     0.200
     6.176    93.314     0.200
    10.754   157.326     0.200
    11.189   162.732     0.200
     2.195    39.152     0.200
     2.447    42.952     0.200
     3.443    55.952     0.200
     4.336    66.852     0.200
     6.809   100.827     0.200
     7.148   105.852     0.200
    10.725   157.097     0.200
    11.178   162.295     0.200
     2.445    42.050     0.200
     2.951    49.550     0.200
     3.042    49.649     0.200
     3.214    51.249     0.200
     4.288    67.024     0.200
     5.795    85.949     0.200
     6.705    95.949     0.200
     6.705    99.417     0.200
     8.086   115.350     0.200
    11.012   159.449     0.200
    11.012   160.109     0.200
    11.061   159.649     0.200
    11.061   158.167     0.200
    12.041   173.850     0.200
    12.329   177.850     0.200
    12.384   179.350     0.200
    12.384   176.850     0.200
    12.443   178.350     0.200
    12.656   180.791     0.200
    14.457   207.149     0.200
    14.589   206.090     0.200
    14.589   206.749     0.200
    15.490   217.649     0.200
    16.250   226.817     0.200
    16.250   225.109     0.200
    16.935   236.624     0.200
    18.231   250.749     0.200
    18.231   250.899     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.692    67.527     0.200
     4.634    85.625     0.200
     5.017    93.227     0.200
     7.529   138.824     0.200
     4.742    87.781     0.200
     2.659    49.121     0.200
     4.722    86.621     0.200
     5.119    95.922     0.200
     3.133    57.680     0.200
     4.401    81.680     0.200
     4.534    82.680     0.200
     4.818    87.680     0.200
     5.635   102.383     0.200
     7.293   134.180     0.200
     2.574    47.668     0.200
     2.613    48.867     0.200
     2.820    52.668     0.200
     3.616    66.367     0.200
     3.945    72.168     0.200
     4.886    89.168     0.200
     5.019    92.867     0.200
     5.461    99.668     0.200
     6.112   113.770     0.200
     7.792   143.168     0.200
     2.559    47.062     0.200
     2.814    52.062     0.200
     2.869    52.562     0.200
     3.607    66.062     0.200
     5.132    93.562     0.200
     5.432    99.062     0.200
     7.533   139.062     0.200
     2.600    47.660     0.200
     4.547    83.363     0.200
     6.945   128.262     0.200
     4.631    84.898     0.200
     4.834    88.898     0.200
     5.049    92.000     0.200
     2.676    49.648     0.200
     3.282    61.047     0.200
     3.647    66.848     0.200
     5.612   102.348     0.200
     2.708    49.773     0.200
     3.522    64.172     0.200
     4.246    77.070     0.200
     4.798    88.672     0.200
     5.313    97.070     0.200
     5.474   100.172     0.200
     2.675    49.117     0.200
     4.214    77.320     0.200
     5.285    96.719     0.200
     5.441    99.320     0.200
     2.573    47.961     0.200
     2.684    49.664     0.200
     3.839    70.961     0.200
     4.222    77.164     0.200
     4.775    86.867     0.200
     5.292    96.961     0.200
     5.449   100.164     0.200
     2.574    48.320     0.200
     2.684    49.320     0.200
     3.840    71.023     0.200
     4.222    77.023     0.200
     5.449   100.219     0.200
     2.721    50.582     0.200
     4.259    77.383     0.200
     4.808    87.482     0.200
     5.487   100.682     0.200
     2.572    47.469     0.200
     4.774    88.270     0.200
     5.286    96.367     0.200
     5.446    98.969     0.200
     6.648   120.969     0.200
     2.513    46.508     0.200
     2.590    47.309     0.200
     2.708    49.309     0.200
     4.246    78.708     0.200
     4.792    87.008     0.200
     2.578    47.688     0.200
     4.228    77.188     0.200
     4.780    86.988     0.200
     5.456    99.988     0.200
     2.568    47.977     0.200
     2.679    48.875     0.200
     4.217    76.875     0.200
     5.445    99.273     0.200
     2.591    48.117     0.200
     4.239    77.717     0.200
     4.793    88.517     0.200
     5.301    96.517     0.200
     5.465   100.917     0.200
     2.586    48.068     0.200
     2.696    50.268     0.200
     4.234    77.367     0.200
     4.787    87.668     0.200
     5.461   100.168     0.200
     3.334    61.625     0.200
     3.979    72.625     0.200
     4.489    82.625     0.200
     3.528    64.516     0.200
     4.804    88.516     0.200
     2.715    49.617     0.200
     3.867    70.617     0.200
     4.253    77.418     0.200
     4.803    87.418     0.200
     5.323    96.617     0.200
     5.482   100.617     0.200
     2.560    46.922     0.200
     2.526    45.922     0.200
     2.680    48.922     0.200
     3.485    63.125     0.200
     3.827    69.227     0.200
     4.217    77.625     0.200
     4.762    87.328     0.200
     5.309    96.125     0.200
     5.450    99.125     0.200
     5.604   102.523     0.200
     7.726   141.922     0.200
     4.207    76.891     0.200
     5.439    98.992     0.200
     2.592    48.953     0.200
     3.857    71.055     0.200
     4.235    77.754     0.200
     2.635    48.852     0.200
     2.738    50.453     0.200
     3.900    71.156     0.200
     4.277    78.156     0.200
     5.316    97.258     0.200
     5.499   100.055     0.200
     6.004   110.656     0.200
     2.505    46.110     0.200
     2.688    49.910     0.200
     4.348    80.110     0.200
     5.577   102.011     0.200
     7.819   144.011     0.200
     9.227   169.811     0.200
     2.633    48.938     0.200
     2.638    48.539     0.200
     2.699    50.139     0.200
     2.699    52.139     0.200
     3.878    72.438     0.200
     5.355    98.139     0.200
     2.649    49.109     0.200
     4.851    88.609     0.200
     5.346    98.008     0.200
     5.523   100.711     0.200
     5.515   101.609     0.200
     6.727   123.812     0.200
     2.633    48.840     0.200
     3.171    58.605     0.200
     3.500    64.707     0.200
     3.841    69.906     0.200
     3.841    71.707     0.200
     7.341   135.406     0.200
     3.011    55.281     0.200
     3.233    58.981     0.200
     3.953    75.081     0.200
     4.284    77.881     0.200
     4.755    86.881     0.200
     5.202    94.781     0.200
     6.023   110.381     0.200
     7.183   131.881     0.200
     2.659    48.938     0.200
     2.692    49.641     0.200
     4.234    79.039     0.200
     4.852    88.539     0.200
     5.406    98.438     0.200
     3.295    60.984     0.200
     3.945    73.188     0.200
     4.209    77.484     0.200
     4.945    90.281     0.200
     3.133    57.617     0.200
     3.459    64.516     0.200
     3.792    69.516     0.200
     4.400    80.117     0.200
     4.865    88.719     0.200
     5.002    90.918     0.200
     6.218   113.219     0.200
     3.735    67.926     0.200
     4.092    76.223     0.200
     4.343    80.023     0.200
     6.324   114.723     0.200
     3.365    62.328     0.200
     3.680    68.227     0.200
     4.307    79.625     0.200
     4.883    88.930     0.200
     3.652    68.008     0.200
     4.290    78.406     0.200
     3.894    71.672     0.200
     5.107    93.871     0.200
     7.426   136.471     0.200
     2.745    53.516     0.200
     3.964    74.016     0.200
     4.906    89.816     0.200
     5.126    94.516     0.200
     5.449   100.016     0.200
     6.692   123.016     0.200
     8.034   150.016     0.200
     3.069    56.112     0.200
     5.195    95.112     0.200
     5.169    94.612     0.200
     2.621    47.961     0.200
     5.062    91.961     0.200
     6.584   119.961     0.200
     7.466   138.062     0.200
     4.622    84.605     0.200
     5.205    96.305     0.200
     5.205    94.605     0.200
     5.164    94.504     0.200
     5.514   100.406     0.200
     5.667   104.105     0.200
     2.595    47.582     0.200
     3.570    66.541     0.200
     3.953    73.740     0.200
     5.099    94.240     0.200
     5.187    94.840     0.200
     5.234    95.665     0.200
     5.000    91.047     0.200
     3.472    64.602     0.200
     3.639    66.602     0.200
     4.471    82.602     0.200
     4.471    81.303     0.200
     4.813    87.602     0.200
     5.295    96.203     0.200
     5.748   104.602     0.200
     5.748   105.102     0.200
     6.375   117.002     0.200
     2.539    46.677     0.200
     2.663    49.177     0.200
     2.895    53.077     0.200
     4.722    86.477     0.200
     5.677   103.776     0.200
     2.661    48.758     0.200
     3.223    59.258     0.200
     3.593    65.656     0.200
     4.162    77.461     0.200
     3.662    67.516     0.200
     3.919    73.219     0.200
     4.343    79.617     0.200
     5.144    94.016     0.200
     6.084   112.219     0.200
     6.612   120.516     0.200
     3.002    55.272     0.200
     3.002    55.472     0.200
     3.313    61.072     0.200
     3.945    73.572     0.200
     3.945    72.272     0.200
     4.164    75.664     0.200
     4.833    88.363     0.200
     4.826    87.965     0.200
     3.169    57.867     0.200
     4.706    85.461     0.200
     5.934   108.664     0.200
     2.504    45.973     0.200
     3.542    65.676     0.200
     4.351    80.176     0.200
     4.750    86.574     0.200
     4.527    83.508     0.200
     2.823    52.422     0.200
     4.533    82.922     0.200
     4.839    89.523     0.200
     4.853    89.820     0.200
     5.046    92.719     0.200
     5.782   105.617     0.200
     6.127   112.117     0.200
     7.434   136.617     0.200
     7.725   141.523     0.200
     8.079   148.023     0.200
     4.891    89.586     0.200
     5.132    94.891     0.200
     3.354    61.609     0.200
     3.883    71.109     0.200
     4.280    78.207     0.200
     5.158    94.508     0.200
     5.717   105.410     0.200
     2.881    52.819     0.200
     3.350    61.719     0.200
     3.887    71.919     0.200
     4.224    77.119     0.200
     5.203    95.020     0.200
     2.530    46.438     0.200
     2.704    49.838     0.200
     3.219    59.639     0.200
     4.984    91.238     0.200
     5.915   108.139     0.200
     3.829    71.014     0.200
     3.829    71.313     0.200
     4.389    80.514     0.200
     5.003    92.313     0.200
     2.598    47.609     0.200
     3.596    66.016     0.200
     3.596    66.414     0.200
     4.327    78.914     0.200
     5.386    98.312     0.200
     2.684    49.320     0.200
     3.500    64.020     0.200
     3.500    64.121     0.200
     3.840    69.918     0.200
     3.840    70.121     0.200
     3.828    71.520     0.200
     4.092    74.918     0.200
     4.222    77.719     0.200
     4.222    77.320     0.200
     4.776    86.820     0.200
     4.776    88.121     0.200
     5.291    96.719     0.200
     5.449    99.820     0.200
     6.064   110.121     0.200
     6.651   120.820     0.200
     8.039   147.820     0.200
     3.502    64.812     0.200
     3.826    70.711     0.200
     3.826    70.512     0.200
     3.843    70.312     0.200
     4.229    77.113     0.200
     5.306    96.613     0.200
     5.582   101.613     0.200
     6.071   112.914     0.200
     3.507    64.191     0.200
     3.848    70.289     0.200
     4.233    78.492     0.200
     4.784    87.789     0.200
     4.784    87.492     0.200
     5.306    96.691     0.200
     5.462    99.992     0.200
     3.939    72.173     0.200
     4.076    74.673     0.200
     5.286    96.473     0.200
     2.687    49.182     0.200
     3.505    64.182     0.200
     4.225    77.482     0.200
     4.781    87.182     0.200
     5.288    97.282     0.200
     5.451    99.082     0.200
     2.661    48.750     0.200
     4.200    76.650     0.200
     4.757    86.550     0.200
     5.266    96.450     0.200
     5.426    99.150     0.200
     4.193    76.751     0.200
     2.626    48.266     0.200
     4.166    76.266     0.200
     2.646    48.827     0.200
     3.468    63.827     0.200
     3.807    69.627     0.200
     4.744    87.427     0.200
     5.250    95.927     0.200
     5.409    98.827     0.200
     6.078   111.228     0.200
     3.992    72.887     0.200
     4.800    86.984     0.200
     4.800    87.184     0.200
     5.335    96.887     0.200
     7.499   138.684     0.200
     2.502    46.250     0.200
     2.502    46.148     0.200
     2.689    49.945     0.200
     3.844    70.250     0.200
     4.005    73.148     0.200
     4.227    77.547     0.200
     4.779    87.250     0.200
     5.298    96.648     0.200
     5.298    96.547     0.200
     5.455    99.547     0.200
     2.674    49.008     0.200
     4.095    75.211     0.200
     2.500    46.238     0.200
     2.500    45.738     0.200
     2.687    49.037     0.200
     3.499    64.138     0.200
     3.840    70.238     0.200
     3.829    71.238     0.200
     3.829    70.138     0.200
     4.225    77.838     0.200
     4.225    77.238     0.200
     4.468    81.537     0.200
     4.776    87.738     0.200
     4.776    86.738     0.200
     5.299    96.638     0.200
     5.299    96.537     0.200
     5.453    99.338     0.200
     5.453    99.037     0.200
     7.490   137.638     0.200
     2.667    48.816     0.200
     3.484    63.719     0.200
     3.484    63.617     0.200
     3.824    70.117     0.200
     4.760    87.316     0.200
     5.277    96.316     0.200
     5.277    96.020     0.200
     5.432    99.219     0.200
     7.693   141.117     0.200
     3.833    70.141     0.200
     2.643    48.766     0.200
     3.881    71.164     0.200
     3.927    72.961     0.200
     4.184    76.664     0.200
     2.668    48.992     0.200
     3.484    64.592     0.200
     4.206    76.592     0.200
     4.488    81.692     0.200
     4.760    87.192     0.200
     5.278    96.492     0.200
     5.278    97.592     0.200
     5.433    99.292     0.200
     6.635   120.893     0.200
     2.504    45.941     0.200
     2.504    46.043     0.200
     3.491    64.340     0.200
     3.491    64.742     0.200
     3.837    70.840     0.200
     3.832    70.242     0.200
     4.767    87.742     0.200
     4.767    86.641     0.200
     5.296    97.941     0.200
     5.446    98.941     0.200
     2.495    46.355     0.200
     3.875    70.756     0.200
     2.637    48.773     0.200
     3.747    68.672     0.200
     4.172    77.172     0.200
     3.789    69.318     0.200
     4.732    86.618     0.200
     5.219    95.019     0.200
     4.570    84.066     0.200
     3.451    63.004     0.200
     3.878    71.605     0.200
     4.215    76.906     0.200
     4.571    83.207     0.200
     5.153    93.906     0.200
     5.477    99.707     0.200
     5.772   105.105     0.200
     2.640    48.586     0.200
     2.640    48.891     0.200
     3.249    60.289     0.200
     4.442    81.492     0.200
     3.866    72.891     0.200
     5.478   100.094     0.200
     7.874   145.391     0.200
     2.590    48.102     0.200
     2.590    47.902     0.200
     3.116    59.102     0.200
     3.437    63.301     0.200
     6.091   113.500     0.200
     2.534    46.469     0.200
     3.816    69.766     0.200
     4.759    87.664     0.200
     3.509    64.078     0.200
     4.073    74.383     0.200
     4.762    87.781     0.200
     4.850    89.180     0.200
     4.501    82.617     0.200
     5.098    93.418     0.200
     3.236    60.790     0.200
     3.236    59.090     0.200
     3.897    70.890     0.200
     6.188   112.290     0.200
     3.884    71.078     0.200
     3.231    60.156     0.200
     3.888    71.855     0.200
     4.499    82.156     0.200
     4.499    83.457     0.200
     5.094    92.855     0.200
     5.094    93.457     0.200
     5.935   108.555     0.200
     6.314   115.055     0.200
     6.314   114.855     0.200
     7.810   142.957     0.200
     2.527    46.523     0.200
     3.288    61.723     0.200
     4.566    83.422     0.200
     4.566    83.523     0.200
     5.274    96.523     0.200
     5.312    97.023     0.200
     3.235    59.422     0.200
     3.895    71.320     0.200
     4.503    82.922     0.200
     4.935    89.719     0.200
     5.102    93.320     0.200
     5.102    93.016     0.200
     6.321   115.117     0.200
     2.813    53.711     0.200
     3.436    63.508     0.200
     3.893    71.312     0.200
     3.893    71.812     0.200
     4.231    77.109     0.200
     4.586    83.508     0.200
     5.488   100.711     0.200
     5.787   105.312     0.200
     2.769    51.125     0.200
     2.769    51.023     0.200
     3.005    55.328     0.200
     3.005    55.023     0.200
     3.606    66.625     0.200
     3.745    68.422     0.200
     4.141    75.625     0.200
     4.535    83.523     0.200
     4.535    83.328     0.200
     5.024    92.227     0.200
     5.024    92.727     0.200
     5.670   103.328     0.200
     3.013    55.450     0.200
     3.013    55.950     0.200
     3.605    66.851     0.200
     4.101    74.950     0.200
     5.027    91.851     0.200
     5.027    92.150     0.200
     3.231    60.040     0.200
     4.499    82.540     0.200
     4.937    89.939     0.200
     5.101    92.939     0.200
     6.319   114.840     0.200
     2.541    46.570     0.200
     2.541    46.871     0.200
     3.563    65.670     0.200
     3.563    66.570     0.200
     3.800    69.471     0.200
     3.918    72.070     0.200
     3.885    71.070     0.200
     4.183    76.971     0.200
     4.183    77.770     0.200
     4.827    89.670     0.200
     5.043    92.070     0.200
     5.358    98.170     0.200
     7.695   142.170     0.200
     7.943   146.270     0.200
     5.355    97.414     0.200
     7.462   137.613     0.200
     2.536    46.758     0.200
     2.640    48.555     0.200
     3.557    65.258     0.200
     3.557    65.555     0.200
     3.927    71.758     0.200
     4.821    88.258     0.200
     4.821    89.359     0.200
     5.358    97.555     0.200
     2.540    46.910     0.200
     2.540    46.711     0.200
     4.185    76.711     0.200
     4.826    88.613     0.200
     4.826    89.410     0.200
     2.544    46.904     0.200
     3.565    67.305     0.200
     3.918    72.805     0.200
     4.189    76.504     0.200
     4.575    84.004     0.200
     4.830    88.904     0.200
     4.830    89.305     0.200
     6.210   113.305     0.200
     6.609   120.504     0.200
     7.454   137.604     0.200
     4.969    90.828     0.200
     5.125    92.922     0.200
     2.554    46.894     0.200
     3.556    65.493     0.200
     3.773    70.193     0.200
     4.275    78.094     0.200
     5.499   100.094     0.200
     4.916    90.090     0.200
     2.527    46.389     0.200
     2.683    50.989     0.200
     4.813    88.789     0.200
     5.356    97.789     0.200
     5.356    97.389     0.200
     3.481    63.469     0.200
     4.755    87.266     0.200
     5.403    98.266     0.200
     6.047   110.070     0.200
     3.851    70.395     0.200
     3.865    71.293     0.200
     4.179    76.594     0.200
     4.754    87.492     0.200
     4.754    88.195     0.200
     5.396    98.293     0.200
     5.396    98.395     0.200
     4.176    76.719     0.200
     4.749    87.617     0.200
     5.212    95.117     0.200
     5.394    98.316     0.200
     5.394    98.520     0.200
     6.234   113.520     0.200
     7.432   136.520     0.200
     3.856    71.047     0.200
     4.178    76.648     0.200
     4.749    87.844     0.200
     4.749    86.750     0.200
     5.221    95.250     0.200
     5.398    98.445     0.200
     5.398    98.250     0.200
     6.238   113.344     0.200
     2.701    49.445     0.200
     4.987    91.445     0.200
     2.698    49.570     0.200
     3.783    68.969     0.200
     4.984    91.375     0.200
     4.984    91.570     0.200
     2.819    51.480     0.200
     5.254    96.289     0.200
     6.930   127.090     0.200
     8.125   148.988     0.200
     2.547    47.055     0.200
     3.548    65.758     0.200
     3.780    70.055     0.200
     3.888    70.953     0.200
     4.269    79.258     0.200
     4.269    78.953     0.200
     4.824    88.055     0.200
     5.493   100.359     0.200
     4.633    85.211     0.200
     5.458   100.016     0.200
     5.839   106.812     0.200
     2.885    53.094     0.200
     3.673    67.191     0.200
     3.319    60.345     0.200
     3.388    62.044     0.200
     4.330    78.544     0.200
     4.330    80.444     0.200
     2.681    49.416     0.200
     3.683    67.316     0.200
     3.811    69.716     0.200
     4.002    74.616     0.200
     4.183    76.316     0.200
     4.183    77.316     0.200
     4.943    90.716     0.200
     4.943    90.916     0.200
     3.497    65.008     0.200
     4.170    76.609     0.200
     5.108    93.609     0.200
     5.037    91.266     0.200
     5.037    91.367     0.200
     5.147    93.266     0.200
     5.540   100.570     0.200
     7.582   139.367     0.200
     3.508    64.104     0.200
     3.746    68.904     0.200
     5.723   104.204     0.200
     3.580    65.297     0.200
     5.107    94.598     0.200
     2.682    49.935     0.200
     2.682    49.735     0.200
     3.894    72.035     0.200
     3.894    72.135     0.200
     4.731    87.535     0.200
     4.731    86.935     0.200
     2.743    51.281     0.200
     3.578    65.781     0.200
     4.412    81.281     0.200
     5.028    92.281     0.200
     5.277    97.879     0.200
     5.598   102.180     0.200
     3.417    62.363     0.200
     3.912    71.363     0.200
     5.187    95.961     0.200
     2.776    53.961     0.200
     3.456    63.559     0.200
     3.872    72.160     0.200
     5.148    94.359     0.200
     5.781   105.461     0.200
     5.781   105.160     0.200
     7.001   127.961     0.200
     7.898   144.961     0.200
     2.778    51.541     0.200
     2.866    52.541     0.200
     3.871    72.340     0.200
     3.871    70.941     0.200
     4.572    83.740     0.200
     5.146    94.641     0.200
     5.146    93.740     0.200
     5.778   105.141     0.200
     2.760    52.219     0.200
     3.722    68.320     0.200
     3.722    68.023     0.200
     4.375    80.820     0.200
     4.991    92.023     0.200
     3.724    67.990     0.200
     4.380    81.990     0.200
     4.994    91.891     0.200
     5.567   101.990     0.200
     5.567   101.391     0.200
     2.710    50.082     0.200
     2.926    53.836     0.200
     3.549    64.938     0.200
     3.997    73.281     0.200
     3.997    73.781     0.200
     4.295    79.082     0.200
     5.467   100.180     0.200
     4.607    84.703     0.200
     6.055   110.902     0.200
     3.946    72.285     0.200
     4.199    77.383     0.200
     4.587    83.984     0.200
     5.131    93.684     0.200
     2.502    45.980     0.200
     2.753    50.501     0.200
     3.542    64.801     0.200
     3.784    70.001     0.200
     3.790    71.401     0.200
     4.124    75.701     0.200
     4.472    82.601     0.200
     5.063    94.801     0.200
     5.671   103.501     0.200
     5.760   104.901     0.200
     2.502    45.957     0.200
     2.502    46.059     0.200
     3.504    63.957     0.200
     4.780    87.957     0.200
     5.452    99.059     0.200
     3.499    65.348     0.200
     3.829    69.949     0.200
     3.829    69.848     0.200
     4.775    87.750     0.200
     2.684    49.203     0.200
     3.839    70.402     0.200
     4.222    78.305     0.200
     4.222    77.402     0.200
     4.775    87.605     0.200
     5.450   100.402     0.200
     6.651   120.902     0.200
     2.794    51.490     0.200
     4.490    82.490     0.200
     2.932    53.836     0.200
     2.561    47.035     0.200
     3.595    66.934     0.200
     3.978    73.137     0.200
     4.531    83.934     0.200
     5.213    95.535     0.200
     3.673    67.111     0.200
     4.324    78.611     0.200
     5.513   100.411     0.200
     2.866    52.352     0.200
     4.844    88.047     0.200
     5.115    93.445     0.200
     7.531   137.852     0.200
     2.552    47.047     0.200
     3.365    61.742     0.200
     6.105   111.844     0.200
     6.442   118.047     0.200
     8.763   163.844     0.200
     2.565    47.383     0.200
     4.224    77.586     0.200
     4.224    78.883     0.200
     4.850    89.383     0.200
     5.408    98.586     0.200
     3.389    62.270     0.200
     5.220    94.969     0.200
     6.452   117.469     0.200
     7.440   136.070     0.200
     3.884    71.316     0.200
     3.914    71.617     0.200
     4.206    77.414     0.200
     4.856    89.316     0.200
     2.633    48.411     0.200
     2.506    45.911     0.200
     3.629    66.411     0.200
     4.364    79.911     0.200
     4.906    89.211     0.200
     5.594   102.311     0.200
     4.108    76.887     0.200
     3.885    71.087     0.200
     4.515    82.787     0.200
     4.515    83.787     0.200
     4.874    88.887     0.200
     5.078    92.787     0.200
     6.308   114.987     0.200
     2.609    48.199     0.200
     2.655    49.000     0.200
     3.804    70.602     0.200
     4.543    83.500     0.200
     4.895    89.602     0.200
     4.888    90.402     0.200
     5.323    97.500     0.200
     7.979   148.902     0.200
     2.615    48.078     0.200
     2.739    50.172     0.200
     3.632    66.477     0.200
     3.881    71.078     0.200
     4.900    89.172     0.200
     4.900    91.078     0.200
     5.467    99.672     0.200
     2.507    46.184     0.200
     4.049    74.184     0.200
     4.648    84.984     0.200
     2.592    47.318     0.200
     3.217    58.619     0.200
     5.265    96.219     0.200
     5.987   109.418     0.200
     2.841    53.652     0.200
     2.841    54.854     0.200
     3.886    71.754     0.200
     5.002    91.453     0.200
     6.285   114.453     0.200
     6.975   127.053     0.200
     3.745    69.180     0.200
     4.970    90.578     0.200
     7.315   133.578     0.200
     2.570    48.047     0.200
     2.570    47.344     0.200
     2.622    48.445     0.200
     3.719    68.445     0.200
     3.613    66.945     0.200
     4.365    80.148     0.200
     4.365    80.250     0.200
     4.891    89.750     0.200
     4.891    89.547     0.200
     5.603   101.945     0.200
     8.143   149.344     0.200
     2.576    48.180     0.200
     3.600    65.883     0.200
     3.981    72.680     0.200
     4.354    79.781     0.200
     5.593   103.477     0.200
     7.056   128.781     0.200
     7.898   144.883     0.200
     2.738    50.332     0.200
     2.805    51.531     0.200
     4.078    74.633     0.200
     4.341    79.332     0.200
     5.021    92.133     0.200
     5.486    99.934     0.200
     2.955    54.692     0.200
     4.021    74.031     0.200
     4.282    79.430     0.200
     4.675    87.625     0.200
     4.907    89.531     0.200
     5.195    95.125     0.200
     6.440   117.531     0.200
     2.616    48.416     0.200
     2.728    50.717     0.200
     2.731    50.316     0.200
     4.272    78.116     0.200
     4.323    79.116     0.200
     6.297   115.017     0.200
     2.788    51.195     0.200
     3.920    71.891     0.200
     5.847   106.594     0.200
     5.840   106.480     0.200
     2.787    51.055     0.200
     3.558    65.152     0.200
     3.793    70.852     0.200
     5.427    98.852     0.200
     6.538   119.152     0.200
     7.827   143.254     0.200
     3.796    69.959     0.200
     4.185    76.459     0.200
     4.415    80.658     0.200
     4.843    88.758     0.200
     2.712    51.036     0.200
     2.937    53.835     0.200
     4.478    81.635     0.200
     4.496    82.074     0.200
     3.192    58.691     0.200
     3.464    63.906     0.200
     4.194    76.602     0.200
     2.598    48.000     0.200
     2.701    49.699     0.200
     3.742    68.797     0.200
     2.599    47.758     0.200
     2.705    49.660     0.200
     3.714    68.160     0.200
     4.246    78.758     0.200
     5.422    99.258     0.200
     6.666   122.660     0.200
     2.566    47.180     0.200
     3.968    73.578     0.200
     5.203    95.180     0.200
     3.135    57.113     0.200
     3.461    63.312     0.200
     3.796    69.414     0.200
     4.031    73.143     0.200
     4.816    87.742     0.200
     3.917    71.930     0.200
     4.518    82.730     0.200
     2.705    49.766     0.200
     2.785    52.566     0.200
     2.959    54.266     0.200
     2.959    54.066     0.200
     3.673    66.866     0.200
     3.673    66.966     0.200
     3.839    69.666     0.200
     4.028    73.366     0.200
     4.484    81.366     0.200
     5.747   104.466     0.200
     5.747   104.166     0.200
     6.580   119.766     0.200
     2.801    51.695     0.200
     2.515    46.289     0.200
     3.823    69.789     0.200
     3.859    70.588     0.200
     4.163    76.588     0.200
     4.296    78.588     0.200
     5.343    97.088     0.200
     2.509    46.473     0.200
     3.530    65.973     0.200
     3.832    70.375     0.200
     4.152    76.574     0.200
     5.330    98.172     0.200
     6.174   113.473     0.200
     6.573   120.375     0.200
     3.674    67.387     0.200
     5.215    95.387     0.200
     3.823    70.129     0.200
     3.837    70.227     0.200
     3.891    71.430     0.200
     4.083    75.027     0.200
     4.423    81.328     0.200
     5.235    95.930     0.200
     2.783    54.375     0.200
     3.515    64.875     0.200
     3.826    70.176     0.200
     4.081    75.375     0.200
     4.081    75.176     0.200
     4.438    81.477     0.200
     4.858    89.574     0.200
     5.230    95.676     0.200
     5.836   107.676     0.200
     2.545    46.945     0.200
     2.545    46.844     0.200
     3.836    70.246     0.200
     4.080    74.547     0.200
     4.444    81.246     0.200
     5.227    95.246     0.200
     6.684   121.746     0.200
     8.133   150.746     0.200
     2.769    53.074     0.200
     4.080    74.477     0.200
     5.232    95.375     0.200
     2.541    46.652     0.200
     3.842    70.355     0.200
     4.076    74.555     0.200
     5.227    95.254     0.200
     2.500    46.484     0.200
     3.821    69.781     0.200
     3.838    70.184     0.200
     4.099    74.883     0.200
     5.250    95.984     0.200
     3.830    70.023     0.200
     3.831    70.023     0.200
     3.886    71.422     0.200
     4.087    74.625     0.200
     4.432    82.023     0.200
     2.503    46.234     0.200
     2.564    47.031     0.200
     3.819    69.828     0.200
     3.874    70.930     0.200
     4.099    74.828     0.200
     5.250    95.734     0.200
     2.560    46.981     0.200
     3.823    69.981     0.200
     3.838    70.081     0.200
     2.553    47.023     0.200
     4.089    74.723     0.200
     4.439    81.125     0.200
     6.501   118.824     0.200
     2.542    46.859     0.200
     3.841    70.359     0.200
     6.490   118.461     0.200
     7.261   133.258     0.200
     2.546    46.930     0.200
     3.514    65.029     0.200
     4.082    74.729     0.200
     4.435    81.029     0.200
     2.554    46.869     0.200
     2.552    47.151     0.200
     2.550    47.242     0.200
     3.521    65.242     0.200
     3.521    66.041     0.200
     3.832    70.742     0.200
     4.084    75.041     0.200
     4.084    75.441     0.200
     4.449    81.342     0.200
     4.854    89.641     0.200
     6.495   118.441     0.200
     2.781    54.791     0.200
     3.523    64.391     0.200
     3.835    70.591     0.200
     5.245    95.891     0.200
     6.506   118.591     0.200
     2.540    47.250     0.200
     2.755    50.750     0.200
     4.408    81.648     0.200
     5.230    95.445     0.200
     2.548    47.020     0.200
     2.551    46.875     0.200
     2.502    46.059     0.200
     3.432    63.160     0.200
     3.432    63.059     0.200
     4.042    74.059     0.200
     4.693    86.461     0.200
     5.956   109.461     0.200
     6.446   118.461     0.200
     6.462   117.660     0.200
     6.542   119.559     0.200
     7.333   134.859     0.200
     7.554   139.258     0.200
     2.556    47.082     0.200
     2.537    46.785     0.200
     2.537    46.684     0.200
     2.507    46.484     0.200
     5.126    93.684     0.200
     5.503   100.984     0.200
     7.927   145.383     0.200
     2.681    49.254     0.200
     3.835    69.955     0.200
     4.219    77.555     0.200
     4.770    86.854     0.200
     5.448    99.654     0.200
     6.674   122.154     0.200
     6.911   125.854     0.200
     3.417    62.739     0.200
     4.358    79.439     0.200
     4.934    90.439     0.200
     6.157   112.639     0.200
     6.162   112.039     0.200
     6.245   114.039     0.200
     7.162   130.839     0.200
     2.528    49.965     0.200
     2.705    49.965     0.200
     2.915    53.566     0.200
     3.639    67.965     0.200
     3.695    67.465     0.200
     4.022    72.965     0.200
     4.451    81.664     0.200
     5.688   103.465     0.200
     2.981    55.328     0.200
     3.466    63.492     0.200
     7.257   132.992     0.200
     2.846    53.141     0.200
     3.000    55.641     0.200
     3.477    64.039     0.200
     3.853    70.641     0.200
     4.190    76.539     0.200
     4.190    77.242     0.200
     4.310    79.938     0.200
     5.717   105.141     0.200
     2.840    52.617     0.200
     2.840    51.914     0.200
     3.868    70.414     0.200
     3.617    66.117     0.200
     2.530    46.781     0.200
     2.714    49.883     0.200
     2.714    50.086     0.200
     3.797    69.383     0.200
     5.478    99.984     0.200
     6.317   115.281     0.200
     6.682   121.586     0.200
     6.682   121.883     0.200
     6.779   123.883     0.200
     2.585    47.461     0.200
     3.299    60.359     0.200
     6.067   110.262     0.200
     2.667    49.312     0.200
     3.294    60.312     0.200
     3.914    71.612     0.200
     5.815   106.212     0.200
     3.683    68.105     0.200
     4.866    89.707     0.200
     2.698    49.672     0.200
     2.878    53.477     0.200
     3.697    68.273     0.200
     4.039    74.172     0.200
     4.974    90.875     0.200
     5.637   102.875     0.200
     6.477   118.672     0.200
     6.865   125.477     0.200
     2.698    49.750     0.200
     3.697    67.750     0.200
     4.126    75.750     0.200
     4.974    91.047     0.200
     5.640   102.750     0.200
     6.480   118.445     0.200
     6.848   125.250     0.200
     6.868   125.344     0.200
     6.944   126.844     0.200
     2.700    49.641     0.200
     3.699    68.039     0.200
     4.129    75.539     0.200
     4.420    80.938     0.200
     4.975    90.641     0.200
     5.429    99.344     0.200
     5.641   103.141     0.200
     5.641   102.641     0.200
     6.481   118.242     0.200
     6.849   124.844     0.200
     7.836   143.742     0.200
     3.699    68.297     0.200
     4.041    73.797     0.200
     4.422    80.898     0.200
     5.436    99.797     0.200
     5.644   103.195     0.200
     5.644   103.297     0.200
     2.692    49.703     0.200
     2.876    52.805     0.200
     2.876    53.000     0.200
     3.691    68.000     0.200
     4.033    73.805     0.200
     4.117    75.000     0.200
     4.415    80.703     0.200
     4.968    90.898     0.200
     5.637   102.898     0.200
     6.476   117.703     0.200
     6.843   125.398     0.200
     7.100   129.398     0.200
     4.122    75.619     0.200
     4.049    74.420     0.200
     5.653   103.220     0.200
     5.653   103.020     0.200
     5.905   107.920     0.200
     6.493   118.020     0.200
     2.702    49.787     0.200
     2.884    53.088     0.200
     4.424    81.088     0.200
     4.978    90.787     0.200
     5.644   103.188     0.200
     6.852   125.088     0.200
     6.872   125.486     0.200
     2.691    49.438     0.200
     4.031    73.336     0.200
     4.093    74.438     0.200
     4.419    80.035     0.200
     4.965    90.535     0.200
     5.645   102.836     0.200
     6.848   124.637     0.200
     2.711    50.543     0.200
     3.710    68.242     0.200
     4.052    74.141     0.200
     4.122    75.641     0.200
     4.986    91.340     0.200
     5.657   103.543     0.200
     6.864   125.242     0.200
     6.884   125.941     0.200
     7.856   143.742     0.200
     2.701    50.344     0.200
     2.881    53.039     0.200
     3.627    66.539     0.200
     3.702    68.641     0.200
     4.042    73.938     0.200
     4.420    80.742     0.200
     5.640   103.039     0.200
     6.867   124.938     0.200
     2.696    49.852     0.200
     2.881    53.055     0.200
     4.037    73.555     0.200
     4.971    90.352     0.200
     6.482   118.352     0.200
     2.899    53.770     0.200
     4.130    75.770     0.200
     4.057    74.168     0.200
     4.057    74.367     0.200
     4.438    82.066     0.200
     5.659   103.270     0.200
     6.499   118.469     0.200
     2.711    49.965     0.200
     3.710    68.168     0.200
     4.127    75.367     0.200
     4.986    91.668     0.200
     5.655   103.465     0.200
     6.494   118.668     0.200
     6.882   126.168     0.200
     4.124    75.492     0.200
     5.437    99.195     0.200
     5.646   103.195     0.200
     5.646   103.094     0.200
     2.696    49.867     0.200
     2.878    52.766     0.200
     5.638   102.969     0.200
     6.846   124.867     0.200
     6.941   126.867     0.200
     2.879    52.697     0.200
     4.033    73.896     0.200
     4.967    90.697     0.200
     2.696    49.521     0.200
     2.878    52.922     0.200
     2.878    52.723     0.200
     4.126    75.922     0.200
     4.038    74.322     0.200
     4.038    73.822     0.200
     4.417    80.822     0.200
     2.696    49.479     0.200
     2.696    49.779     0.200
     2.880    52.779     0.200
     3.695    67.680     0.200
     4.037    73.680     0.200
     4.419    80.680     0.200
     5.433    99.879     0.200
     5.640   102.979     0.200
     6.480   118.180     0.200
     6.847   124.979     0.200
     6.868   125.979     0.200
     6.943   126.879     0.200
     7.479   137.379     0.200
     3.496    63.725     0.200
     3.834    70.123     0.200
     4.205    77.023     0.200
     2.659    48.822     0.200
     3.830    70.223     0.200
     4.061    74.322     0.200
     4.199    77.021     0.200
     4.766    87.521     0.200
     5.419    99.021     0.200
     6.042   111.723     0.200
     2.710    49.863     0.200
     2.895    52.961     0.200
     4.434    80.762     0.200
     2.702    50.076     0.200
     2.881    52.976     0.200
     4.979    91.076     0.200
     5.640   103.376     0.200
     6.480   118.676     0.200
     6.849   125.076     0.200
     6.867   125.476     0.200
     6.944   126.576     0.200
     3.828    70.176     0.200
     4.061    73.875     0.200
     4.196    77.078     0.200
     5.237    95.977     0.200
     5.416    98.875     0.200
     6.256   113.875     0.200
     6.625   120.375     0.200
     6.644   121.578     0.200
     6.720   122.176     0.200
     6.879   125.277     0.200
     7.115   130.000     0.200
     3.621    66.469     0.200
     3.707    68.266     0.200
     4.048    74.066     0.200
     4.428    80.867     0.200
     4.983    90.969     0.200
     5.648   103.566     0.200
     6.857   125.066     0.200
     2.704    50.203     0.200
     2.886    53.102     0.200
     4.425    81.500     0.200
     5.646   103.203     0.200
     6.486   118.301     0.200
     2.711    50.109     0.200
     2.896    53.008     0.200
     4.052    73.906     0.200
     2.710    50.023     0.200
     2.892    53.023     0.200
     4.130    75.625     0.200
     4.985    91.023     0.200
     5.440    99.723     0.200
     5.652   103.523     0.200
     2.705    50.178     0.200
     4.046    73.979     0.200
     4.980    90.979     0.200
     5.650   103.379     0.200
     6.857   124.979     0.200
     6.953   126.979     0.200
     3.344    61.203     0.200
     3.973    72.602     0.200
     3.973    73.301     0.200
     4.607    84.703     0.200
     4.922    90.902     0.200
     5.161    94.402     0.200
     6.004   109.703     0.200
     6.480   118.402     0.200
     3.345    61.883     0.200
     3.984    72.984     0.200
     4.609    84.188     0.200
     4.950    90.484     0.200
     5.177    94.188     0.200
     6.019   109.586     0.200
     6.408   116.688     0.200
     6.408   116.484     0.200
     6.493   118.086     0.200
     3.666    67.258     0.200
     3.977    72.957     0.200
     5.166    94.559     0.200
     3.665    67.047     0.200
     3.977    72.848     0.200
     4.015    73.648     0.200
     7.350   134.746     0.200
     2.828    52.084     0.200
     2.828    51.982     0.200
     2.862    52.883     0.200
     3.856    71.482     0.200
     4.162    76.283     0.200
     4.390    80.783     0.200
     5.104    93.883     0.200
     5.508   100.482     0.200
     3.338    61.141     0.200
     3.661    67.141     0.200
     3.971    72.945     0.200
     4.602    84.039     0.200
     5.161    94.141     0.200
     3.337    61.395     0.200
     4.601    83.895     0.200
     5.167    94.395     0.200
     6.398   117.195     0.200
     6.398   116.595     0.200
     6.484   118.695     0.200
     6.882   125.375     0.200
     7.353   135.095     0.200
     4.951    90.141     0.200
     2.603    49.332     0.200
     2.869    52.832     0.200
     5.628   102.730     0.200
     3.988    72.812     0.200
     4.614    84.211     0.200
     3.659    67.242     0.200
     3.974    72.742     0.200
     4.600    83.945     0.200
     5.167    94.344     0.200
     3.988    74.383     0.200
     4.615    84.281     0.200
     4.947    90.281     0.200
     5.179    94.281     0.200
     6.411   116.680     0.200
     3.658    67.108     0.200
     4.599    84.008     0.200
     5.156    94.008     0.200
     6.617   120.808     0.200
     3.657    66.851     0.200
     3.976    73.251     0.200
     4.955    90.251     0.200
     5.172    94.251     0.200
     6.014   109.951     0.200
     6.400   116.751     0.200
     6.634   121.051     0.200
     3.650    66.922     0.200
     5.157    94.422     0.200
     7.348   134.523     0.200
     3.964    73.211     0.200
     4.932    90.406     0.200
     7.346   134.711     0.200
     5.165    94.036     0.200
     2.938    54.324     0.200
     3.275    59.723     0.200
     3.880    70.824     0.200
     4.507    82.223     0.200
     4.507    82.324     0.200
     3.355    61.953     0.200
     3.678    68.055     0.200
     4.002    73.652     0.200
     4.943    91.152     0.200
     5.179    95.152     0.200
     6.412   117.254     0.200
     6.408   117.254     0.200
     4.922    90.098     0.200
     3.986    73.023     0.200
     4.609    84.121     0.200
     4.956    90.223     0.200
     5.180    94.621     0.200
     6.022   109.723     0.200
     3.982    72.805     0.200
     4.012    73.402     0.200
     4.951    90.402     0.200
     5.175    94.805     0.200
     6.891   126.727     0.200
     3.340    61.438     0.200
     3.967    72.742     0.200
     5.153    93.742     0.200
     3.628    66.894     0.200
     3.939    72.294     0.200
     5.130    93.394     0.200
     3.659    67.270     0.200
     3.976    73.270     0.200
     4.019    73.670     0.200
     6.399   117.170     0.200
     7.361   135.070     0.200
     3.993    73.164     0.200
     4.947    90.363     0.200
     5.183    94.965     0.200
     6.416   116.863     0.200
     3.999    73.488     0.200
     4.626    84.789     0.200
     4.955    90.688     0.200
     5.190    94.586     0.200
     3.672    67.203     0.200
     3.987    72.805     0.200
     4.613    84.203     0.200
     4.952    90.602     0.200
     5.180    94.805     0.200
     6.023   109.805     0.200
     3.994    73.086     0.200
     3.998    73.086     0.200
     5.189    94.586     0.200
     6.032   109.781     0.200
     6.421   117.086     0.200
     3.946    72.184     0.200
     3.946    72.980     0.200
     4.576    84.082     0.200
     7.326   134.383     0.200
     3.643    67.105     0.200
     3.955    72.406     0.200
     4.921    89.707     0.200
     4.921    90.207     0.200
     5.146    94.305     0.200
     6.378   116.207     0.200
     6.463   117.906     0.200
     6.608   120.508     0.200
     6.873   127.480     0.200
     3.636    67.011     0.200
     3.948    72.811     0.200
     4.577    83.711     0.200
     5.140    94.311     0.200
     5.982   109.211     0.200
     4.004    74.062     0.200
     4.634    85.363     0.200
     7.363   134.363     0.200
     3.992    73.454     0.200
     5.182    94.654     0.200
     3.998    73.191     0.200
     4.625    84.492     0.200
     5.189    95.590     0.200
     7.368   135.090     0.200
     3.329    61.180     0.200
     3.650    67.279     0.200
     3.956    72.979     0.200
     4.033    73.880     0.200
     4.591    84.579     0.200
     4.905    90.079     0.200
     4.905    89.579     0.200
     5.143    94.979     0.200
     5.143    94.479     0.200
     6.462   118.279     0.200
     3.650    66.727     0.200
     3.960    72.727     0.200
     5.150    95.031     0.200
     3.964    72.686     0.200
     4.598    83.985     0.200
     5.152    94.186     0.200
     6.386   116.385     0.200
     7.327   133.985     0.200
     3.941    72.260     0.200
     5.133    93.760     0.200
     3.679    67.516     0.200
     3.991    73.215     0.200
     5.182    94.715     0.200
     3.643    66.711     0.200
     3.958    72.812     0.200
     5.151    94.211     0.200
     3.644    66.830     0.200
     3.949    72.630     0.200
     5.136    93.830     0.200
     3.939    72.383     0.200
     4.568    83.477     0.200
     3.643    66.592     0.200
     3.940    72.492     0.200
     4.045    74.492     0.200
     5.122    93.292     0.200
     7.283   133.092     0.200
     3.663    67.328     0.200
     4.031    74.629     0.200
     3.966    72.959     0.200
     4.024    73.959     0.200
     3.662    67.168     0.200
     3.973    73.469     0.200
     4.603    84.566     0.200
     6.396   116.770     0.200
     7.344   134.367     0.200
     4.031    73.750     0.200
     4.912    90.047     0.200
     5.147    94.250     0.200
     6.381   116.344     0.200
     6.609   120.445     0.200
     6.856   126.508     0.200
     3.306    60.508     0.200
     3.943    72.008     0.200
     5.979   109.008     0.200
     6.367   115.805     0.200
     6.367   116.109     0.200
     3.329    61.480     0.200
     3.950    72.781     0.200
     5.134    94.082     0.200
     7.302   133.184     0.200
     3.636    66.672     0.200
     4.576    83.672     0.200
     7.313   134.773     0.200
     3.315    61.500     0.200
     3.949    72.602     0.200
     3.949    72.195     0.200
     4.043    74.297     0.200
     4.579    83.898     0.200
     5.139    93.500     0.200
     5.139    94.398     0.200
     5.982   109.797     0.200
     6.869   125.523     0.200
     7.327   134.398     0.200
     3.643    66.781     0.200
     4.040    73.977     0.200
     4.901    89.680     0.200
     5.137    94.281     0.200
     7.315   133.781     0.200
     3.938    71.945     0.200
     4.051    74.242     0.200
     4.573    83.344     0.200
     5.126    93.742     0.200
     7.309   133.445     0.200
     3.950    72.697     0.200
     4.040    73.896     0.200
     5.139    93.697     0.200
     5.982   109.797     0.200
     6.373   116.098     0.200
     6.860   125.598     0.200
     3.938    72.033     0.200
     4.572    83.632     0.200
     5.127    93.433     0.200
     3.639    66.459     0.200
     3.946    72.760     0.200
     4.580    83.660     0.200
     5.135    94.059     0.200
     7.317   133.760     0.200
     3.665    67.180     0.200
     3.979    73.180     0.200
     7.356   135.180     0.200
     2.514    46.492     0.200
     3.628    66.891     0.200
     4.054    74.188     0.200
     5.124    93.891     0.200
     7.310   134.586     0.200
     3.950    72.558     0.200
     3.950    72.358     0.200
     4.040    74.058     0.200
     5.140    94.158     0.200
     5.140    94.858     0.200
     6.079   113.358     0.200
     6.373   116.658     0.200
     6.861   126.033     0.200
     2.519    46.764     0.200
     3.635    67.264     0.200
     5.130    94.063     0.200
     3.936    72.566     0.200
     4.577    83.941     0.200
     5.132    94.141     0.200
     7.315   133.742     0.200
     3.628    66.598     0.200
     3.941    72.098     0.200
     4.052    74.098     0.200
     4.569    83.297     0.200
     5.133    93.797     0.200
     7.161   130.697     0.200
     3.303    60.738     0.200
     3.938    71.938     0.200
     4.909    89.537     0.200
     5.129    94.137     0.200
     5.972   109.537     0.200
     6.873   126.537     0.200
     7.323   133.738     0.200
     3.945    72.314     0.200
     5.139    94.314     0.200
     6.101   111.215     0.200
     3.328    61.234     0.200
     3.652    67.234     0.200
     3.966    73.039     0.200
     4.592    83.641     0.200
     5.159    93.938     0.200
     2.698    49.555     0.200
     2.698    49.453     0.200
     3.697    67.953     0.200
     4.039    74.254     0.200
     4.421    80.652     0.200
     5.643   103.652     0.200
     7.843   144.152     0.200
     3.949    72.320     0.200
     5.139    94.023     0.200
     7.326   133.719     0.200
     4.772    87.484     0.200
     5.430    99.184     0.200
     4.000    73.805     0.200
     3.373    62.645     0.200
     3.696    67.845     0.200
     4.637    84.845     0.200
     6.035   109.945     0.200
     6.421   117.245     0.200
     2.689    49.566     0.200
     2.872    52.867     0.200
     4.411    80.766     0.200
     5.632   102.766     0.200
     3.941    72.404     0.200
     4.050    74.404     0.200
     4.680    85.705     0.200
     5.238    96.004     0.200
     4.010    73.201     0.200
     4.609    84.301     0.200
     5.176    94.801     0.200
     6.887   127.256     0.200
     3.336    61.578     0.200
     3.972    72.477     0.200
     5.163    94.379     0.200
     6.391   116.477     0.200
     6.395   116.680     0.200
     7.347   134.078     0.200
     3.956    72.391     0.200
     4.587    83.793     0.200
     5.145    93.992     0.200
     7.328   133.793     0.200
     2.755    50.707     0.200
     4.100    74.906     0.200
     4.425    81.105     0.200
     6.848   124.605     0.200
     3.656    67.072     0.200
     3.973    72.772     0.200
     4.947    90.972     0.200
     5.168    94.072     0.200
     6.082   112.572     0.200
     4.576    83.719     0.200
     6.379   116.020     0.200
     3.625    66.623     0.200
     3.934    72.022     0.200
     5.124    93.522     0.200
     6.095   111.522     0.200
     6.356   115.923     0.200
     2.687    49.258     0.200
     4.028    73.656     0.200
     4.407    80.555     0.200
     4.962    90.453     0.200
     5.628   102.852     0.200
     5.914   107.555     0.200
     2.689    49.523     0.200
     2.870    53.023     0.200
     4.965    90.621     0.200
     5.630   102.324     0.200
     3.954    72.584     0.200
     4.361    79.936     0.200
     4.921    90.885     0.200
     5.145    93.885     0.200
     5.988   108.984     0.200
     6.085   111.385     0.200
     6.377   116.186     0.200
     6.875   126.834     0.200
     3.188    58.820     0.200
     3.938    72.070     0.200
     4.466    81.920     0.200
     5.215    95.420     0.200
     5.204    95.119     0.200
     6.048   110.721     0.200
     6.438   117.119     0.200
     2.718    49.814     0.200
     3.941    72.113     0.200
     3.188    58.709     0.200
     3.535    64.709     0.200
     4.466    81.508     0.200
     5.213    94.908     0.200
     6.046   110.607     0.200
     5.192    94.895     0.200
     5.201    95.193     0.200
     3.523    64.570     0.200
     5.193    94.773     0.200
     3.173    58.109     0.200
     3.942    72.406     0.200
     5.199    94.711     0.200
     6.422   117.109     0.200
     6.662   121.211     0.200
     3.172    58.826     0.200
     3.518    64.326     0.200
     3.935    72.126     0.200
     5.189    95.226     0.200
     2.893    52.934     0.200
     4.050    74.234     0.200
     4.432    81.334     0.200
     4.984    91.033     0.200
     5.653   102.934     0.200
     7.851   144.033     0.200
     3.630    66.828     0.200
     5.965   109.227     0.200
     6.083   110.930     0.200
     6.441   117.227     0.200
     7.131   130.227     0.200
     3.941    72.418     0.200
     5.133    94.117     0.200
     5.976   109.418     0.200
     6.364   115.918     0.200
     4.526    82.326     0.200
     2.563    47.336     0.200
     3.343    61.438     0.200
     3.612    66.336     0.200
     4.284    78.234     0.200
     4.366    80.438     0.200
     4.368    80.414     0.200
     4.591    84.438     0.200
     2.559    47.105     0.200
     4.271    77.805     0.200
     4.838    88.404     0.200
     3.543    64.871     0.200
     3.872    71.070     0.200
     4.263    77.945     0.200
     4.483    81.969     0.200
     6.940   128.203     0.200
     3.966    73.076     0.200
     4.297    79.026     0.200
     4.977    91.076     0.200
     5.169    94.576     0.200
     6.122   111.376     0.200
     6.481   118.276     0.200
     2.727    49.797     0.200
     3.477    63.695     0.200
     3.896    71.496     0.200
     4.409    80.598     0.200
     5.986   109.398     0.200
     6.325   115.695     0.200
     6.376   116.496     0.200
     2.964    54.285     0.200
     3.392    62.586     0.200
     3.420    62.387     0.200
     3.475    63.684     0.200
     4.735    86.285     0.200
     5.010    91.484     0.200
     3.937    72.266     0.200
     4.569    83.465     0.200
     5.127    93.465     0.200
     2.680    49.445     0.200
     3.978    73.094     0.200
     4.148    75.844     0.200
     4.457    81.645     0.200
     6.364   116.746     0.200
     3.119    57.445     0.200
     3.737    68.148     0.200
     4.378    79.844     0.200
     5.772   105.148     0.200
     6.160   112.047     0.200
     3.444    64.172     0.200
     4.934    90.371     0.200
     4.931    90.766     0.200
     3.420    63.176     0.200
     4.307    79.250     0.200
     6.833   125.941     0.200
     3.421    63.672     0.200
     3.721    69.070     0.200
     4.307    78.875     0.200
     4.735    86.977     0.200
     6.834   125.977     0.200
     7.156   130.477     0.200
     3.434    63.453     0.200
     3.730    68.953     0.200
     4.322    79.125     0.200
     4.733    86.648     0.200
     6.822   125.305     0.200
     7.154   131.547     0.200
     4.299    78.836     0.200
     4.741    87.336     0.200
     6.145   112.736     0.200
     6.842   125.775     0.200
     7.163   130.635     0.200
     3.446    64.332     0.200
     6.172   112.732     0.200
     6.844   126.164     0.200
     3.452    64.414     0.200
     3.753    69.613     0.200
     6.176   112.613     0.200
     6.838   125.764     0.200
     3.443    64.252     0.200
     4.336    79.746     0.200
     4.728    87.552     0.200
     6.809   126.090     0.200
     2.951    54.550     0.200
     3.042    57.249     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     2.190    41.125     0.200
     2.641    48.219     0.200
     0.500    10.227     0.200
     2.534    44.926     0.200
     4.966    88.926     0.200
     7.787   137.926     0.200
     0.503     9.984     0.200
     2.550    45.180     0.200
     5.112    91.281     0.200
     1.225    23.023     0.200
     2.287    41.723     0.200
     2.409    44.320     0.200
     2.566    46.223     0.200
     3.781    68.121     0.200
     5.061    91.723     0.200
     5.948   106.723     0.200
     0.759    14.680     0.200
     0.914    17.680     0.200
     1.863    33.477     0.200
     1.863    34.180     0.200
     2.088    38.180     0.200
     2.129    39.281     0.200
     2.209    41.180     0.200
     2.335    42.578     0.200
     2.341    41.180     0.200
     2.341    43.383     0.200
     2.395    43.680     0.200
     2.444    45.180     0.200
     3.459    62.180     0.200
     4.870    87.680     0.200
     0.712    14.066     0.200
     1.383    25.867     0.200
     2.345    42.367     0.200
     2.613    47.867     0.200
     2.692    49.066     0.200
     2.879    52.770     0.200
     3.160    56.770     0.200
     0.669    13.562     0.200
     1.380    25.562     0.200
     2.197    40.463     0.200
     2.337    41.562     0.200
     2.337    43.062     0.200
     2.559    45.062     0.200
     2.701    48.562     0.200
     2.683    48.262     0.200
     3.131    56.562     0.200
     3.933    70.562     0.200
     0.596    11.262     0.200
     1.197    22.961     0.200
     1.455    27.660     0.200
     1.645    30.863     0.200
     1.708    31.562     0.200
     1.972    35.461     0.200
     2.179    39.461     0.200
     2.249    41.262     0.200
     3.028    54.262     0.200
     3.971    72.262     0.200
     4.512    81.262     0.200
     0.776    15.102     0.200
     1.040    19.695     0.200
     1.972    37.000     0.200
     2.233    40.398     0.200
     2.288    41.102     0.200
     2.298    42.102     0.200
     2.430    43.898     0.200
     2.482    45.102     0.200
     2.748    49.898     0.200
     3.325    59.602     0.200
     3.558    64.297     0.200
     4.500    80.898     0.200
     5.695   103.297     0.200
     0.614    12.391     0.200
     2.633    47.391     0.200
     3.073    54.594     0.200
     0.562    11.148     0.200
     1.929    35.246     0.200
     2.379    44.547     0.200
     3.113    56.348     0.200
     4.169    75.047     0.200
     5.473    98.848     0.200
     7.920   140.047     0.200
     0.296     6.672     0.200
     0.296     6.375     0.200
     1.275    23.672     0.200
     1.276    23.773     0.200
     2.465    43.969     0.200
     2.492    45.172     0.200
     3.806    67.672     0.200
     3.862    69.672     0.200
     4.798    86.375     0.200
     5.313    95.172     0.200
     7.786   138.672     0.200
     9.768   172.375     0.200
     0.324     6.719     0.200
     1.244    22.820     0.200
     1.245    22.820     0.200
     2.023    36.320     0.200
     2.447    43.320     0.200
     2.493    45.320     0.200
     3.831    69.117     0.200
     4.767    86.117     0.200
     0.317     6.461     0.200
     1.251    23.367     0.200
     1.253    23.367     0.200
     2.451    44.164     0.200
     2.492    45.367     0.200
     0.318     6.422     0.200
     1.254    23.523     0.200
     2.014    36.922     0.200
     2.453    44.219     0.200
     2.490    45.719     0.200
     4.776    85.625     0.200
     0.281     6.182     0.200
     1.284    23.682     0.200
     1.285    23.682     0.200
     1.985    36.082     0.200
     2.466    43.582     0.200
     2.499    44.883     0.200
     3.873    69.582     0.200
     0.323     6.867     0.200
     1.251    23.066     0.200
     1.252    23.066     0.200
     2.015    35.668     0.200
     2.456    43.367     0.200
     2.486    44.969     0.200
     2.681    48.770     0.200
     3.838    69.668     0.200
     4.219    76.270     0.200
     4.774    86.168     0.200
     0.284     6.309     0.200
     1.268    23.409     0.200
     1.270    23.409     0.200
     2.002    35.409     0.200
     2.448    43.508     0.200
     3.857    69.708     0.200
     0.310     6.588     0.200
     1.256    23.287     0.200
     1.258    23.287     0.200
     2.011    35.988     0.200
     2.453    44.188     0.200
     2.494    45.188     0.200
     2.690    48.787     0.200
     3.844    69.488     0.200
     0.320     6.672     0.200
     1.247    23.172     0.200
     1.248    23.172     0.200
     2.020    36.773     0.200
     2.448    43.875     0.200
     2.494    45.570     0.200
     3.835    69.375     0.200
     0.308     6.017     0.200
     1.270    24.316     0.200
     1.271    24.316     0.200
     1.997    37.217     0.200
     2.468    44.816     0.200
     2.483    45.517     0.200
     2.700    49.316     0.200
     3.857    70.217     0.200
     0.309     6.268     0.200
     1.264    24.068     0.200
     1.265    24.068     0.200
     2.461    44.367     0.200
     2.488    45.668     0.200
     3.852    69.467     0.200
     0.613    11.426     0.200
     1.209    23.426     0.200
     1.792    34.023     0.200
     1.811    34.227     0.200
     2.207    40.023     0.200
     2.574    46.625     0.200
     3.036    55.227     0.200
     0.280     6.117     0.200
     1.281    24.016     0.200
     2.504    45.516     0.200
     3.869    69.516     0.200
     5.486    97.715     0.200
     7.796   139.516     0.200
     0.286     6.219     0.200
     1.279    23.617     0.200
     1.280    23.617     0.200
     1.990    35.918     0.200
     2.463    43.418     0.200
     2.499    45.418     0.200
     7.738   136.418     0.200
     0.303     6.922     0.200
     0.853    16.422     0.200
     2.032    36.125     0.200
     2.422    42.328     0.200
     0.313     7.289     0.200
     2.040    35.789     0.200
     2.418    42.492     0.200
     2.524    44.992     0.200
     2.551    46.094     0.200
     2.670    47.992     0.200
     3.818    67.992     0.200
     4.753    85.289     0.200
     5.299    95.195     0.200
     0.826    15.754     0.200
     1.271    23.953     0.200
     1.272    23.953     0.200
     1.994    36.754     0.200
     2.477    45.254     0.200
     2.469    45.754     0.200
     0.297     6.055     0.200
     1.314    23.953     0.200
     1.315    23.953     0.200
     1.952    35.352     0.200
     2.512    45.555     0.200
     2.454    44.555     0.200
     4.836    87.656     0.200
     5.515    99.758     0.200
     0.207     4.511     0.200
     0.940    18.311     0.200
     1.367    25.711     0.200
     1.368    25.711     0.200
     1.909    34.311     0.200
     2.512    44.610     0.200
     2.810    51.110     0.200
     3.956    71.910     0.200
     4.891    87.811     0.200
     5.407    98.110     0.200
     6.777   121.511     0.200
     0.295     6.051     0.200
     0.856    17.051     0.200
     1.259    23.350     0.200
     2.012    36.250     0.200
     2.442    43.750     0.200
     2.513    45.850     0.200
     2.696    48.449     0.200
     3.222    58.250     0.200
     0.611    12.039     0.200
     0.584    11.938     0.200
     1.337    25.039     0.200
     2.161    40.238     0.200
     2.699    48.839     0.200
     3.878    70.039     0.200
     4.178    76.238     0.200
     0.266     5.414     0.200
     0.880    17.312     0.200
     1.327    25.211     0.200
     1.329    25.211     0.200
     2.507    44.914     0.200
     2.475    45.211     0.200
     2.759    50.414     0.200
     3.915    71.008     0.200
     4.298    77.211     0.200
     0.552    10.742     0.200
     0.561    10.742     0.200
     0.580    11.141     0.200
     1.256    24.242     0.200
     1.742    33.441     0.200
     1.731    32.840     0.200
     0.708    13.906     0.200
     2.247    40.805     0.200
     2.300    41.707     0.200
     2.341    41.707     0.200
     2.449    44.605     0.200
     4.919    88.605     0.200
     0.324     7.682     0.200
     2.551    45.881     0.200
     2.866    50.682     0.200
     3.011    52.381     0.200
     5.933   105.381     0.200
     6.023   106.682     0.200
     7.183   128.682     0.200
     0.510    10.039     0.200
     1.353    25.539     0.200
     1.352    25.539     0.200
     2.233    41.539     0.200
     2.665    48.539     0.200
     3.911    70.641     0.200
     0.550    10.891     0.200
     0.758    14.688     0.200
     2.153    40.484     0.200
     2.252    41.086     0.200
     2.223    41.188     0.200
     2.528    46.484     0.200
     3.409    62.188     0.200
     5.896   107.188     0.200
     0.664    12.984     0.200
     1.073    20.188     0.200
     1.075    20.188     0.200
     2.372    43.984     0.200
     2.464    44.188     0.200
     2.341    42.984     0.200
     2.403    44.188     0.200
     3.621    65.484     0.200
     4.562    82.781     0.200
     5.144    91.883     0.200
     5.666   101.984     0.200
     0.764    14.816     0.200
     0.913    17.918     0.200
     0.915    17.918     0.200
     2.339    41.418     0.200
     2.439    44.516     0.200
     0.859    16.125     0.200
     0.862    16.125     0.200
     2.194    40.223     0.200
     2.304    40.723     0.200
     3.402    61.223     0.200
     4.829    87.125     0.200
     5.874   105.023     0.200
     0.887    17.227     0.200
     2.124    39.328     0.200
     2.139    39.727     0.200
     2.333    41.930     0.200
     2.430    44.727     0.200
     4.747    85.727     0.200
     0.928    18.008     0.200
     2.111    39.008     0.200
     2.111    38.703     0.200
     2.351    43.305     0.200
     2.409    44.203     0.200
     0.661    12.871     0.200
     0.991    18.672     0.200
     2.297    42.871     0.200
     2.368    42.871     0.200
     2.353    43.271     0.200
     2.434    44.572     0.200
     3.222    58.771     0.200
     3.551    63.871     0.200
     4.492    80.871     0.200
     4.959    89.971     0.200
     0.562    11.215     0.200
     2.155    39.117     0.200
     2.717    49.215     0.200
     2.745    48.516     0.200
     3.640    66.016     0.200
     3.964    71.816     0.200
     4.271    77.117     0.200
     7.785   138.215     0.200
     0.385     7.812     0.200
     1.675    29.912     0.200
     2.297    41.912     0.200
     2.838    51.112     0.200
     4.257    76.912     0.200
     0.578    11.367     0.200
     1.302    24.062     0.200
     2.210    40.664     0.200
     2.652    48.367     0.200
     3.850    69.367     0.200
     4.162    75.461     0.200
     4.792    86.664     0.200
     5.346    96.164     0.200
     0.383     7.605     0.200
     1.684    30.605     0.200
     2.304    42.305     0.200
     2.842    51.207     0.200
     2.842    50.906     0.200
     3.081    56.004     0.200
     4.267    77.605     0.200
     5.823   105.105     0.200
     7.049   127.207     0.200
     0.584    11.482     0.200
     1.275    23.582     0.200
     2.225    41.082     0.200
     2.575    46.781     0.200
     2.629    47.781     0.200
     3.823    69.582     0.200
     4.136    74.582     0.200
     0.551    10.641     0.200
     2.272    41.641     0.200
     2.415    44.240     0.200
     2.564    46.840     0.200
     5.802   104.939     0.200
     0.322     6.765     0.200
     2.597    46.365     0.200
     2.825    51.265     0.200
     3.252    58.665     0.200
     4.314    77.265     0.200
     4.777    85.765     0.200
     6.039   106.765     0.200
     0.492     9.645     0.200
     0.492     9.848     0.200
     1.498    27.848     0.200
     2.183    40.746     0.200
     2.183    40.246     0.200
     2.728    48.945     0.200
     2.778    49.945     0.200
     2.838    51.246     0.200
     4.059    73.246     0.200
     4.059    73.047     0.200
     4.379    79.445     0.200
     0.790    15.602     0.200
     2.380    43.303     0.200
     2.380    43.102     0.200
     5.180    93.502     0.200
     1.193    22.877     0.200
     3.444    61.276     0.200
     0.658    12.961     0.200
     0.902    17.555     0.200
     1.879    35.055     0.200
     2.102    37.859     0.200
     2.057    38.461     0.200
     1.183    22.719     0.200
     2.171    40.617     0.200
     2.568    46.918     0.200
     2.859    51.617     0.200
     3.406    58.816     0.200
     3.919    70.617     0.200
     5.459    98.816     0.200
     6.051   109.719     0.200
     0.560    10.872     0.200
     0.567    10.772     0.200
     1.212    23.272     0.200
     2.153    39.272     0.200
     2.687    49.272     0.200
     2.627    47.972     0.200
     3.313    60.772     0.200
     4.529    81.972     0.200
     4.529    82.672     0.200
     4.510    82.272     0.200
     4.510    80.872     0.200
     0.659    12.566     0.200
     0.901    17.164     0.200
     2.058    37.965     0.200
     2.102    37.363     0.200
     2.102    37.965     0.200
     2.661    48.164     0.200
     2.661    47.965     0.200
     3.225    58.164     0.200
     3.225    58.465     0.200
     3.595    65.164     0.200
     4.164    75.266     0.200
     0.267     6.266     0.200
     2.522    45.461     0.200
     4.304    77.062     0.200
     5.250    92.961     0.200
     0.727    14.074     0.200
     1.004    19.473     0.200
     1.884    34.973     0.200
     2.000    37.074     0.200
     2.255    40.574     0.200
     3.227    58.574     0.200
     0.694    13.414     0.200
     1.712    31.312     0.200
     1.964    37.008     0.200
     2.990    54.711     0.200
     3.028    54.609     0.200
     4.249    77.211     0.200
     5.233    95.211     0.200
     1.256    24.320     0.200
     2.346    43.320     0.200
     3.527    64.117     0.200
     3.677    66.023     0.200
     5.414    98.523     0.200
     0.719    13.992     0.200
     1.117    20.891     0.200
     2.259    41.688     0.200
     2.302    43.086     0.200
     2.406    43.992     0.200
     2.406    43.586     0.200
     2.538    45.992     0.200
     2.538    45.586     0.200
     3.645    65.789     0.200
     3.645    65.391     0.200
     3.947    71.688     0.200
     4.587    83.289     0.200
     4.891    87.992     0.200
     5.132    92.492     0.200
     7.304   131.289     0.200
     0.340     6.910     0.200
     1.637    29.707     0.200
     2.335    42.410     0.200
     2.792    50.008     0.200
     2.878    52.109     0.200
     3.041    54.609     0.200
     3.446    62.410     0.200
     3.729    67.207     0.200
     4.140    74.207     0.200
     4.221    75.609     0.200
     4.582    83.109     0.200
     5.215    93.809     0.200
     5.787   104.508     0.200
     0.360     7.119     0.200
     1.642    30.020     0.200
     1.642    29.619     0.200
     2.313    42.619     0.200
     2.313    42.819     0.200
     2.806    51.020     0.200
     2.806    50.020     0.200
     3.039    55.119     0.200
     3.350    59.719     0.200
     3.442    61.619     0.200
     3.717    67.520     0.200
     4.224    75.919     0.200
     4.580    82.520     0.200
     4.580    82.319     0.200
     5.162    93.719     0.200
     5.782   104.719     0.200
     7.823   140.919     0.200
     0.933    18.238     0.200
     2.396    43.438     0.200
     3.345    59.539     0.200
     4.639    83.039     0.200
     4.695    85.238     0.200
     5.372    97.039     0.200
     6.942   121.838     0.200
     0.671    13.014     0.200
     0.871    16.313     0.200
     2.108    39.014     0.200
     2.209    40.214     0.200
     2.209    39.914     0.200
     2.292    42.014     0.200
     2.292    42.214     0.200
     2.592    47.014     0.200
     3.451    62.514     0.200
     5.065    91.613     0.200
     7.430   133.514     0.200
     7.430   132.414     0.200
     0.226     4.914     0.200
     0.226     4.812     0.200
     1.350    25.211     0.200
     2.505    45.016     0.200
     2.499    45.414     0.200
     2.499    45.711     0.200
     2.789    50.609     0.200
     3.733    67.812     0.200
     3.938    71.211     0.200
     4.025    71.414     0.200
     4.327    78.312     0.200
     4.873    88.516     0.200
     5.556   100.414     0.200
     5.556    99.414     0.200
     6.756   122.211     0.200
     0.318     6.621     0.200
     1.254    23.418     0.200
     1.254    23.520     0.200
     2.489    45.918     0.200
     2.454    44.219     0.200
     2.454    43.621     0.200
     2.499    45.719     0.200
     3.828    69.520     0.200
     6.651   120.320     0.200
     7.459   135.449     0.200
     7.462   135.820     0.200
     7.761   141.520     0.200
     0.304     6.414     0.200
     1.256    23.012     0.200
     1.256    23.414     0.200
     2.445    44.012     0.200
     2.445    43.211     0.200
     2.502    45.613     0.200
     2.505    45.211     0.200
     2.505    45.914     0.200
     2.691    48.711     0.200
     3.502    63.211     0.200
     3.843    69.613     0.200
     4.229    76.113     0.200
     4.778    86.812     0.200
     4.778    86.613     0.200
     5.458    98.914     0.200
     5.458    98.113     0.200
     0.303     6.289     0.200
     0.303     6.391     0.200
     1.261    23.090     0.200
     1.261    24.090     0.200
     2.452    44.090     0.200
     2.452    43.391     0.200
     2.499    45.191     0.200
     2.499    45.789     0.200
     2.507    45.492     0.200
     2.695    48.891     0.200
     2.695    49.090     0.200
     3.507    63.789     0.200
     3.821    68.789     0.200
     3.821    69.391     0.200
     3.848    69.691     0.200
     4.091    74.090     0.200
     0.513    10.073     0.200
     0.513    10.173     0.200
     1.159    21.173     0.200
     1.159    21.073     0.200
     2.385    43.973     0.200
     2.384    43.373     0.200
     2.384    43.873     0.200
     2.473    44.673     0.200
     2.473    44.173     0.200
     2.535    46.073     0.200
     3.729    67.273     0.200
     5.096    92.373     0.200
     5.286    95.573     0.200
     5.606   100.873     0.200
     0.320     6.682     0.200
     1.259    23.382     0.200
     2.462    44.182     0.200
     2.481    45.482     0.200
     3.823    67.682     0.200
     3.845    69.782     0.200
     4.084    72.382     0.200
     6.654   120.482     0.200
     0.343     7.150     0.200
     1.236    22.950     0.200
     1.236    23.050     0.200
     2.063    37.350     0.200
     2.449    43.850     0.200
     2.449    43.450     0.200
     2.481    44.950     0.200
     3.821    69.550     0.200
     3.847    67.850     0.200
     4.011    72.450     0.200
     4.495    77.750     0.200
     0.348     6.950     0.200
     1.229    23.351     0.200
     2.069    37.650     0.200
     2.445    44.051     0.200
     2.482    45.351     0.200
     2.655    48.551     0.200
     4.008    72.751     0.200
     4.107    74.650     0.200
     4.107    73.950     0.200
     0.395     7.965     0.200
     1.216    22.766     0.200
     2.081    37.665     0.200
     2.462    44.165     0.200
     2.444    44.665     0.200
     3.797    68.965     0.200
     0.359     7.127     0.200
     1.223    23.227     0.200
     2.076    38.227     0.200
     2.445    44.327     0.200
     2.445    44.127     0.200
     2.477    45.327     0.200
     3.807    69.327     0.200
     3.860    70.026     0.200
     3.860    70.327     0.200
     4.110    74.526     0.200
     4.110    74.127     0.200
     4.184    75.827     0.200
     5.409    98.126     0.200
     5.593    98.827     0.200
     0.274     6.086     0.200
     1.277    23.184     0.200
     1.277    22.984     0.200
     2.027    35.184     0.200
     2.450    43.785     0.200
     2.450    43.484     0.200
     2.525    45.285     0.200
     2.525    45.484     0.200
     2.517    45.086     0.200
     2.517    45.387     0.200
     2.718    48.785     0.200
     2.718    48.684     0.200
     3.523    63.484     0.200
     3.865    69.086     0.200
     3.865    69.586     0.200
     3.805    68.684     0.200
     3.805    68.887     0.200
     3.805    67.387     0.200
     4.087    73.086     0.200
     4.087    73.785     0.200
     4.255    76.887     0.200
     4.435    77.086     0.200
     5.335    95.684     0.200
     5.572    96.785     0.200
     0.311     6.344     0.200
     0.311     6.445     0.200
     1.257    23.445     0.200
     1.257    23.047     0.200
     2.452    44.047     0.200
     2.452    43.750     0.200
     2.495    45.547     0.200
     2.495    45.844     0.200
     2.689    49.250     0.200
     3.503    63.844     0.200
     3.825    69.148     0.200
     3.825    69.047     0.200
     3.825    68.945     0.200
     3.844    69.547     0.200
     4.092    74.047     0.200
     4.092    73.344     0.200
     4.227    76.445     0.200
     4.466    81.148     0.200
     4.779    86.047     0.200
     5.576    99.648     0.200
     0.330     6.711     0.200
     1.246    23.008     0.200
     2.053    37.305     0.200
     2.454    44.109     0.200
     2.491    45.711     0.200
     2.484    45.406     0.200
     3.836    69.305     0.200
     4.011    72.805     0.200
     0.310     6.738     0.200
     1.253    23.037     0.200
     1.253    23.238     0.200
     2.048    35.938     0.200
     2.447    43.438     0.200
     2.447    44.338     0.200
     2.499    45.537     0.200
     2.499    45.738     0.200
     2.687    48.838     0.200
     3.829    68.338     0.200
     4.097    74.238     0.200
     4.097    74.438     0.200
     6.070   108.037     0.200
     0.332     6.918     0.200
     1.238    22.816     0.200
     2.444    43.418     0.200
     2.444    43.719     0.200
     2.482    45.418     0.200
     2.482    45.117     0.200
     2.491    45.719     0.200
     2.491    45.316     0.200
     2.667    48.520     0.200
     3.824    69.520     0.200
     3.845    69.219     0.200
     3.845    68.918     0.200
     4.002    72.617     0.200
     4.205    75.020     0.200
     4.205    76.117     0.200
     4.105    73.617     0.200
     4.105    73.816     0.200
     4.488    80.918     0.200
     5.589    98.418     0.200
     6.076   108.117     0.200
     6.634   118.918     0.200
     0.326     6.844     0.200
     1.247    22.742     0.200
     2.053    36.844     0.200
     2.451    44.039     0.200
     2.491    45.641     0.200
     2.488    45.242     0.200
     2.488    45.445     0.200
     2.676    48.344     0.200
     3.835    68.945     0.200
     3.835    69.141     0.200
     4.008    72.445     0.200
     4.096    73.945     0.200
     4.096    73.039     0.200
     4.214    76.242     0.200
     5.441    98.242     0.200
     5.581   100.844     0.200
     0.602    11.664     0.200
     1.339    24.766     0.200
     2.000    36.664     0.200
     2.167    40.664     0.200
     2.167    40.562     0.200
     2.696    48.961     0.200
     3.802    68.961     0.200
     0.332     6.792     0.200
     0.332     6.893     0.200
     1.238    23.092     0.200
     1.238    23.292     0.200
     2.062    36.992     0.200
     2.483    45.592     0.200
     2.444    43.792     0.200
     2.444    43.992     0.200
     2.491    45.992     0.200
     3.824    68.492     0.200
     3.824    69.592     0.200
     3.844    69.393     0.200
     4.003    72.492     0.200
     4.104    72.492     0.200
     4.104    73.792     0.200
     0.314     6.742     0.200
     1.245    22.840     0.200
     1.245    22.941     0.200
     2.439    42.941     0.200
     2.439    43.543     0.200
     2.491    45.340     0.200
     2.679    48.441     0.200
     3.837    68.340     0.200
     3.867    68.141     0.200
     3.832    69.141     0.200
     4.105    74.242     0.200
     4.105    73.941     0.200
     4.217    76.543     0.200
     5.446    98.840     0.200
     5.590    99.941     0.200
     6.078   108.543     0.200
     0.333     6.855     0.200
     1.234    23.055     0.200
     2.066    37.055     0.200
     2.440    43.955     0.200
     2.664    48.555     0.200
     4.202    76.355     0.200
     0.767    14.773     0.200
     1.411    26.375     0.200
     2.002    37.973     0.200
     2.829    51.375     0.200
     3.912    70.973     0.200
     0.765    14.818     0.200
     1.286    23.719     0.200
     2.088    39.019     0.200
     2.449    45.118     0.200
     2.522    45.818     0.200
     2.522    46.118     0.200
     2.719    48.919     0.200
     3.789    68.019     0.200
     4.059    73.318     0.200
     4.059    73.919     0.200
     4.883    86.519     0.200
     4.883    88.219     0.200
     5.219    94.719     0.200
     0.350     6.965     0.200
     1.630    29.965     0.200
     2.320    42.566     0.200
     2.320    42.863     0.200
     2.794    50.164     0.200
     3.029    54.766     0.200
     3.454    62.164     0.200
     3.729    67.766     0.200
     4.155    74.164     0.200
     0.359     7.207     0.200
     1.633    30.004     0.200
     1.633    29.707     0.200
     2.311    42.504     0.200
     2.311    42.707     0.200
     2.801    50.305     0.200
     2.801    49.906     0.200
     2.872    52.305     0.200
     3.030    54.906     0.200
     3.030    54.805     0.200
     3.451    62.207     0.200
     3.723    67.406     0.200
     4.215    76.504     0.200
     4.571    82.707     0.200
     5.153    92.707     0.200
     5.209    92.105     0.200
     7.831   138.805     0.200
     0.556    10.289     0.200
     0.556    10.586     0.200
     2.631    48.188     0.200
     2.951    53.492     0.200
     6.252   112.492     0.200
     0.342     6.797     0.200
     1.621    29.695     0.200
     1.621    29.492     0.200
     2.326    42.297     0.200
     2.784    50.297     0.200
     2.784    49.492     0.200
     3.021    54.695     0.200
     3.021    54.492     0.200
     3.463    62.992     0.200
     3.463    62.094     0.200
     3.739    67.695     0.200
     3.866    69.492     0.200
     4.204    75.695     0.200
     4.204    75.297     0.200
     4.562    82.695     0.200
     4.562    82.195     0.200
     5.141    93.195     0.200
     5.141    93.297     0.200
     5.225    93.297     0.200
     5.766   103.891     0.200
     0.714    13.902     0.200
     2.185    40.102     0.200
     2.185    40.000     0.200
     2.859    51.602     0.200
     2.929    53.699     0.200
     3.116    55.301     0.200
     4.771    86.102     0.200
     5.178    93.000     0.200
     5.178    93.301     0.200
     6.400   114.602     0.200
     0.821    15.867     0.200
     1.331    24.969     0.200
     1.331    24.766     0.200
     2.019    37.562     0.200
     2.019    37.867     0.200
     2.478    45.664     0.200
     2.534    45.766     0.200
     2.781    50.266     0.200
     2.781    49.766     0.200
     3.505    63.562     0.200
     3.816    68.664     0.200
     4.069    73.969     0.200
     4.069    73.867     0.200
     4.759    85.562     0.200
     4.845    87.766     0.200
     5.403    96.469     0.200
     6.480   116.969     0.200
     0.818    15.781     0.200
     1.334    24.781     0.200
     1.334    24.578     0.200
     2.019    37.680     0.200
     2.019    37.781     0.200
     2.482    45.680     0.200
     2.538    46.383     0.200
     2.538    46.180     0.200
     2.782    50.383     0.200
     2.782    49.484     0.200
     3.509    63.281     0.200
     3.819    68.578     0.200
     3.819    69.078     0.200
     4.073    73.883     0.200
     4.762    85.484     0.200
     4.850    87.180     0.200
     5.221    94.578     0.200
     5.400    96.383     0.200
     0.685    13.316     0.200
     0.685    13.418     0.200
     1.009    18.918     0.200
     2.216    40.816     0.200
     2.216    41.016     0.200
     2.351    43.117     0.200
     2.404    43.516     0.200
     2.392    43.816     0.200
     2.392    44.016     0.200
     3.560    64.219     0.200
     3.560    64.117     0.200
     3.892    70.816     0.200
     4.113    74.418     0.200
     5.731   101.316     0.200
     6.188   110.918     0.200
     0.679    13.290     0.200
     1.010    18.990     0.200
     1.010    18.690     0.200
     2.219    40.690     0.200
     2.219    41.090     0.200
     2.355    42.990     0.200
     2.402    43.290     0.200
     2.396    43.890     0.200
     3.563    64.190     0.200
     3.563    63.790     0.200
     3.897    70.190     0.200
     4.109    73.890     0.200
     0.695    13.375     0.200
     0.695    13.680     0.200
     1.004    18.977     0.200
     1.004    18.875     0.200
     2.209    41.078     0.200
     2.209    41.180     0.200
     2.342    43.180     0.200
     2.404    43.477     0.200
     2.390    44.078     0.200
     3.554    64.281     0.200
     0.691    13.457     0.200
     1.007    19.156     0.200
     1.007    19.055     0.200
     2.213    41.254     0.200
     2.347    43.055     0.200
     2.407    43.656     0.200
     2.389    44.055     0.200
     2.389    44.254     0.200
     3.558    64.457     0.200
     3.888    70.656     0.200
     4.115    73.457     0.200
     4.923    89.254     0.200
     0.429     8.422     0.200
     1.048    19.523     0.200
     2.204    40.125     0.200
     2.300    42.324     0.200
     2.527    46.324     0.200
     2.696    49.324     0.200
     3.635    65.922     0.200
     3.635    65.324     0.200
     4.057    73.922     0.200
     0.680    13.320     0.200
     2.217    40.922     0.200
     2.354    43.016     0.200
     2.402    43.516     0.200
     2.396    43.820     0.200
     2.396    43.922     0.200
     3.235    58.922     0.200
     3.562    64.422     0.200
     3.562    64.117     0.200
     3.895    70.219     0.200
     4.009    67.719     0.200
     4.110    73.922     0.200
     4.503    81.016     0.200
     4.935    89.617     0.200
     7.354   132.320     0.200
     0.365     7.211     0.200
     1.648    30.008     0.200
     1.650    30.109     0.200
     2.309    42.312     0.200
     2.813    50.414     0.200
     2.813    50.609     0.200
     2.887    52.609     0.200
     2.887    52.312     0.200
     3.045    54.914     0.200
     3.045    55.109     0.200
     3.710    66.914     0.200
     4.141    74.312     0.200
     4.231    76.211     0.200
     4.586    83.312     0.200
     5.168    93.812     0.200
     5.787   104.812     0.200
     0.062     2.727     0.200
     0.909    17.125     0.200
     2.494    44.523     0.200
     2.698    48.625     0.200
     2.698    49.328     0.200
     3.745    68.227     0.200
     4.098    73.125     0.200
     0.075     2.750     0.200
     0.908    16.950     0.200
     2.490    44.650     0.200
     2.711    49.351     0.200
     2.711    49.250     0.200
     3.748    68.150     0.200
     4.542    82.250     0.200
     0.679    13.239     0.200
     0.679    13.340     0.200
     1.004    19.040     0.200
     1.004    18.840     0.200
     2.214    40.840     0.200
     2.351    43.040     0.200
     2.395    43.439     0.200
     2.403    43.840     0.200
     2.403    44.239     0.200
     3.231    58.739     0.200
     3.558    64.140     0.200
     3.558    63.840     0.200
     6.319   114.640     0.200
     0.618    11.871     0.200
     0.618    12.070     0.200
     1.217    23.070     0.200
     1.346    24.871     0.200
     1.346    24.770     0.200
     2.150    39.871     0.200
     2.150    40.471     0.200
     2.710    49.070     0.200
     2.710    48.770     0.200
     3.800    68.471     0.200
     4.827    87.570     0.200
     5.043    91.471     0.200
     5.394    95.971     0.200
     7.444   134.170     0.200
     1.218    22.014     0.200
     1.321    23.514     0.200
     2.188    39.414     0.200
     2.523    45.514     0.200
     2.633    47.213     0.200
     2.675    47.713     0.200
     2.675    47.514     0.200
     3.867    68.713     0.200
     3.867    68.014     0.200
     4.174    75.314     0.200
     4.174    75.514     0.200
     4.809    86.213     0.200
     5.422    93.514     0.200
     0.607    11.758     0.200
     1.216    22.961     0.200
     1.338    24.758     0.200
     1.338    24.656     0.200
     2.164    40.359     0.200
     2.164    40.961     0.200
     2.698    48.859     0.200
     2.698    48.758     0.200
     3.804    68.258     0.200
     3.804    69.359     0.200
     3.879    69.961     0.200
     4.181    76.055     0.200
     6.202   112.555     0.200
     0.605    11.812     0.200
     0.605    11.711     0.200
     1.212    22.812     0.200
     1.342    24.812     0.200
     1.342    24.711     0.200
     2.163    40.211     0.200
     2.163    40.613     0.200
     2.701    49.113     0.200
     3.800    68.812     0.200
     3.884    70.012     0.200
     3.884    69.711     0.200
     3.923    70.812     0.200
     5.399    95.812     0.200
     0.607    11.805     0.200
     1.347    24.805     0.200
     2.158    40.205     0.200
     2.706    49.104     0.200
     3.888    69.904     0.200
     4.189    75.705     0.200
     5.365    97.404     0.200
     7.362   133.205     0.200
     8.261   148.004     0.200
     0.648    12.828     0.200
     1.012    18.625     0.200
     1.012    18.523     0.200
     2.228    40.727     0.200
     2.385    43.023     0.200
     2.373    42.922     0.200
     2.421    43.727     0.200
     3.243    58.328     0.200
     3.572    63.828     0.200
     3.572    63.625     0.200
     3.914    71.023     0.200
     4.098    73.328     0.200
     4.513    81.523     0.200
     0.290     5.894     0.200
     1.097    20.793     0.200
     1.310    24.193     0.200
     2.465    44.793     0.200
     2.465    45.394     0.200
     2.502    45.293     0.200
     2.502    44.993     0.200
     2.736    49.894     0.200
     2.736    49.493     0.200
     3.556    64.293     0.200
     3.773    67.193     0.200
     3.896    70.493     0.200
     3.896    69.293     0.200
     4.275    77.094     0.200
     4.832    87.693     0.200
     5.499    99.594     0.200
     6.703   121.693     0.200
     0.825    15.890     0.200
     0.838    16.290     0.200
     0.838    16.190     0.200
     2.022    37.390     0.200
     2.022    37.290     0.200
     2.160    39.990     0.200
     2.160    39.890     0.200
     2.279    41.790     0.200
     2.279    41.290     0.200
     2.488    45.490     0.200
     2.488    45.690     0.200
     3.701    67.090     0.200
     5.908   105.290     0.200
     0.595    11.589     0.200
     1.327    24.489     0.200
     2.180    39.889     0.200
     2.636    47.689     0.200
     2.636    47.789     0.200
     2.683    48.389     0.200
     2.683    48.889     0.200
     3.871    69.489     0.200
     3.871    69.589     0.200
     4.176    74.589     0.200
     4.813    86.889     0.200
     6.597   118.489     0.200
     0.385     7.672     0.200
     1.184    22.367     0.200
     2.434    44.469     0.200
     2.434    44.367     0.200
     2.480    44.672     0.200
     2.480    44.867     0.200
     2.474    44.969     0.200
     2.474    45.172     0.200
     2.645    47.969     0.200
     3.849    70.070     0.200
     3.818    68.672     0.200
     3.818    69.266     0.200
     4.082    73.969     0.200
     4.184    75.266     0.200
     4.184    75.570     0.200
     4.755    85.469     0.200
     5.565    96.172     0.200
     6.243   112.867     0.200
     6.613   120.070     0.200
     0.398     7.895     0.200
     2.421    44.395     0.200
     2.488    44.895     0.200
     2.472    44.992     0.200
     2.472    45.395     0.200
     2.639    47.992     0.200
     2.639    48.094     0.200
     3.480    63.293     0.200
     3.816    68.395     0.200
     3.816    68.992     0.200
     4.525    81.492     0.200
     4.754    85.992     0.200
     5.560    97.094     0.200
     6.041   107.594     0.200
     6.236   113.195     0.200
     6.607   119.293     0.200
     0.397     7.816     0.200
     1.231    22.918     0.200
     1.192    22.520     0.200
     2.427    44.617     0.200
     2.427    44.418     0.200
     2.468    45.316     0.200
     2.468    45.617     0.200
     2.481    44.816     0.200
     2.481    45.020     0.200
     2.636    47.918     0.200
     2.636    48.219     0.200
     3.475    63.316     0.200
     3.812    68.918     0.200
     3.855    69.219     0.200
     3.870    70.020     0.200
     4.176    75.520     0.200
     4.749    86.117     0.200
     5.212    94.719     0.200
     6.604   118.918     0.200
     7.382   132.840     0.200
     7.711   138.816     0.200
     0.388     7.648     0.200
     1.190    22.445     0.200
     1.229    22.750     0.200
     2.438    44.547     0.200
     2.438    44.250     0.200
     2.474    44.445     0.200
     2.474    44.844     0.200
     2.468    44.844     0.200
     2.468    45.250     0.200
     2.639    47.445     0.200
     2.639    48.047     0.200
     3.811    68.344     0.200
     3.856    68.945     0.200
     3.872    70.250     0.200
     4.178    75.344     0.200
     5.221    94.547     0.200
     0.551    10.844     0.200
     1.052    19.641     0.200
     2.132    39.141     0.200
     2.701    49.141     0.200
     2.803    50.141     0.200
     2.803    50.539     0.200
     3.783    68.641     0.200
     4.045    72.945     0.200
     4.987    90.539     0.200
     5.526    99.844     0.200
     5.526   100.039     0.200
     8.121   144.742     0.200
     0.558    10.875     0.200
     1.058    20.070     0.200
     2.126    39.172     0.200
     2.126    39.070     0.200
     2.698    48.570     0.200
     2.805    50.375     0.200
     2.805    50.773     0.200
     3.638    65.969     0.200
     4.042    73.070     0.200
     4.042    73.273     0.200
     5.521    99.969     0.200
     5.521   100.172     0.200
     6.767   122.773     0.200
     0.374     7.281     0.200
     2.819    50.680     0.200
     2.669    46.781     0.200
     3.484    60.680     0.200
     3.203    57.383     0.200
     4.136    73.781     0.200
     5.673   101.582     0.200
     0.450     8.789     0.200
     1.210    22.789     0.200
     2.529    45.891     0.200
     2.715    48.789     0.200
     2.913    51.988     0.200
     2.913    52.188     0.200
     2.990    51.090     0.200
     3.273    58.488     0.200
     6.678   117.488     0.200
     0.290     5.859     0.200
     0.290     6.055     0.200
     1.104    21.055     0.200
     1.302    24.055     0.200
     1.302    24.156     0.200
     2.472    45.258     0.200
     2.493    44.555     0.200
     2.493    44.859     0.200
     2.730    49.758     0.200
     3.548    64.656     0.200
     3.780    66.859     0.200
     3.808    68.453     0.200
     3.888    69.555     0.200
     4.427    79.453     0.200
     4.824    87.359     0.200
     5.533    96.359     0.200
     6.697   120.359     0.200
     0.672    12.312     0.200
     0.672    12.617     0.200
     1.779    33.516     0.200
     1.779    32.914     0.200
     2.248    40.312     0.200
     2.248    40.617     0.200
     2.805    51.016     0.200
     2.805    51.312     0.200
     3.118    57.117     0.200
     3.118    56.414     0.200
     3.415    62.016     0.200
     3.415    62.211     0.200
     4.061    73.117     0.200
     4.539    81.516     0.200
     4.575    81.414     0.200
     4.575    83.016     0.200
     4.618    83.312     0.200
     5.839   105.617     0.200
     3.267    58.594     0.200
     3.480    60.094     0.200
     3.759    67.293     0.200
     4.352    77.992     0.200
     4.714    82.691     0.200
     5.196    92.992     0.200
     0.288     7.044     0.200
     0.288     7.145     0.200
     1.752    31.944     0.200
     2.666    46.444     0.200
     2.666    46.845     0.200
     2.718    48.645     0.200
     3.488    61.944     0.200
     3.862    67.544     0.200
     4.772    86.145     0.200
     5.255    94.645     0.200
     6.022   108.645     0.200
     1.085    21.016     0.200
     1.602    29.116     0.200
     2.668    48.416     0.200
     2.681    49.116     0.200
     3.703    66.516     0.200
     3.716    67.216     0.200
     3.708    67.116     0.200
     3.708    67.316     0.200
     4.002    72.816     0.200
     5.273    94.916     0.200
     5.273    95.916     0.200
     6.572   119.016     0.200
     7.097   127.316     0.200
     0.360     7.109     0.200
     0.360     7.305     0.200
     1.589    28.703     0.200
     1.589    29.008     0.200
     2.300    42.109     0.200
     2.776    49.805     0.200
     2.776    49.906     0.200
     2.826    51.008     0.200
     2.980    53.406     0.200
     2.980    53.703     0.200
     2.980    54.008     0.200
     3.497    63.203     0.200
     3.514    63.609     0.200
     3.753    68.203     0.200
     3.834    69.305     0.200
     3.834    69.203     0.200
     4.522    80.906     0.200
     4.522    81.203     0.200
     5.430    98.008     0.200
     5.722   103.109     0.200
     7.725   138.305     0.200
     0.641    12.664     0.200
     2.034    36.969     0.200
     2.034    37.266     0.200
     2.751    49.469     0.200
     2.841    50.867     0.200
     2.841    51.070     0.200
     2.894    51.469     0.200
     2.894    51.766     0.200
     3.562    63.070     0.200
     3.598    63.266     0.200
     3.709    66.766     0.200
     3.774    68.070     0.200
     3.774    66.867     0.200
     4.094    73.664     0.200
     4.380    78.070     0.200
     4.380    79.266     0.200
     5.186    89.469     0.200
     5.147    90.570     0.200
     5.652    99.969     0.200
     5.540    98.969     0.200
     8.149   140.969     0.200
     0.369     7.504     0.200
     0.848    15.804     0.200
     2.291    42.404     0.200
     2.785    50.004     0.200
     4.174    75.504     0.200
     4.524    81.604     0.200
     5.231    93.904     0.200
     5.726   102.504     0.200
     0.628    12.496     0.200
     0.628    12.297     0.200
     2.847    51.598     0.200
     2.847    51.098     0.200
     2.883    51.895     0.200
     2.883    50.996     0.200
     3.116    56.195     0.200
     3.257    56.996     0.200
     3.257    59.195     0.200
     3.329    59.598     0.200
     3.710    66.996     0.200
     4.648    83.395     0.200
     5.107    92.297     0.200
     0.504     9.535     0.200
     0.504     9.635     0.200
     1.239    23.935     0.200
     2.103    38.435     0.200
     2.094    38.535     0.200
     4.497    82.135     0.200
     4.511    81.635     0.200
     6.270   113.435     0.200
     0.469     9.180     0.200
     0.469     9.281     0.200
     0.974    18.281     0.200
     2.198    41.379     0.200
     2.786    49.879     0.200
     2.743    50.379     0.200
     2.871    52.379     0.200
     2.871    52.680     0.200
     3.584    64.879     0.200
     3.758    68.582     0.200
     4.087    74.680     0.200
     4.412    80.379     0.200
     5.277    93.582     0.200
     5.598   101.379     0.200
     8.030   141.781     0.200
     0.340     6.762     0.200
     0.340     6.863     0.200
     1.666    30.062     0.200
     2.348    43.262     0.200
     2.805    50.762     0.200
     2.805    50.160     0.200
     3.447    61.961     0.200
     4.251    76.160     0.200
     4.251    76.461     0.200
     4.615    82.961     0.200
     5.187    93.762     0.200
     5.821   105.562     0.200
     5.821   105.262     0.200
     0.324     6.461     0.200
     0.794    15.160     0.200
     1.626    29.762     0.200
     2.349    42.859     0.200
     2.349    42.961     0.200
     2.776    49.262     0.200
     2.776    49.859     0.200
     3.456    62.059     0.200
     3.485    61.660     0.200
     3.872    69.461     0.200
     4.211    74.961     0.200
     4.211    76.359     0.200
     4.574    82.762     0.200
     0.327     6.541     0.200
     0.796    15.141     0.200
     1.625    29.740     0.200
     2.344    43.141     0.200
     3.458    62.541     0.200
     3.485    61.041     0.200
     3.743    67.240     0.200
     4.209    75.641     0.200
     4.209    75.941     0.200
     4.572    81.340     0.200
     5.778   104.941     0.200
     0.472     9.219     0.200
     1.010    19.125     0.200
     1.486    27.125     0.200
     2.204    40.422     0.200
     2.760    49.523     0.200
     2.760    49.820     0.200
     3.614    64.219     0.200
     3.621    65.422     0.200
     3.806    68.523     0.200
     4.051    72.719     0.200
     4.051    73.023     0.200
     4.328    78.625     0.200
     5.562   101.023     0.200
     6.798   123.125     0.200
     0.463     9.090     0.200
     1.004    18.990     0.200
     2.212    40.291     0.200
     2.757    49.490     0.200
     2.757    49.691     0.200
     3.612    64.090     0.200
     3.618    65.590     0.200
     4.053    72.590     0.200
     4.053    73.090     0.200
     4.380    79.191     0.200
     5.289    92.891     0.200
     6.803   122.990     0.200
     0.540    10.582     0.200
     1.138    21.582     0.200
     1.384    25.883     0.200
     2.190    41.082     0.200
     2.708    49.283     0.200
     0.399     7.836     0.200
     0.908    17.438     0.200
     1.748    32.539     0.200
     2.260    41.438     0.200
     2.772    49.938     0.200
     3.541    64.234     0.200
     3.769    68.438     0.200
     4.269    76.641     0.200
     0.592    11.582     0.200
     1.114    21.180     0.200
     2.113    39.383     0.200
     2.654    48.582     0.200
     2.755    50.281     0.200
     2.790    50.281     0.200
     3.660    66.480     0.200
     0.694    13.602     0.200
     1.412    26.500     0.200
     2.216    39.602     0.200
     2.541    45.801     0.200
     2.541    46.000     0.200
     3.343    59.801     0.200
     3.665    65.902     0.200
     3.991    71.102     0.200
     4.018    71.102     0.200
     3.971    72.000     0.200
     3.971    72.102     0.200
     4.129    74.801     0.200
     4.195    76.203     0.200
     4.607    83.602     0.200
     5.158    93.602     0.200
     0.722    13.984     0.200
     2.239    40.484     0.200
     2.256    41.785     0.200
     2.256    42.086     0.200
     2.302    42.586     0.200
     2.302    42.785     0.200
     2.540    45.785     0.200
     2.540    45.984     0.200
     3.645    65.984     0.200
     3.946    71.785     0.200
     4.800    85.785     0.200
     4.889    88.586     0.200
     5.131    92.383     0.200
     5.615    98.785     0.200
     7.301   131.984     0.200
     7.301   132.285     0.200
     0.309     6.379     0.200
     1.147    21.582     0.200
     1.257    23.379     0.200
     2.045    36.980     0.200
     2.450    43.980     0.200
     2.498    45.480     0.200
     2.689    48.980     0.200
     3.843    69.480     0.200
     0.370     7.301     0.200
     1.546    28.601     0.200
     1.546    28.701     0.200
     2.288    42.301     0.200
     2.753    49.801     0.200
     2.931    52.801     0.200
     2.931    53.301     0.200
     3.555    63.801     0.200
     4.258    77.601     0.200
     0.318     6.559     0.200
     1.148    21.758     0.200
     2.043    37.457     0.200
     2.459    43.855     0.200
     2.459    44.457     0.200
     2.485    45.855     0.200
     2.485    45.656     0.200
     2.687    49.059     0.200
     3.825    69.656     0.200
     3.825    67.758     0.200
     3.852    68.258     0.200
     3.844    69.656     0.200
     3.844    69.457     0.200
     4.225    76.758     0.200
     4.780    86.059     0.200
     6.654   120.758     0.200
     0.310     6.449     0.200
     1.151    21.648     0.200
     1.253    23.250     0.200
     2.049    37.250     0.200
     2.446    43.648     0.200
     2.446    44.148     0.200
     2.500    46.148     0.200
     2.500    45.750     0.200
     2.498    46.047     0.200
     2.686    49.047     0.200
     3.859    68.250     0.200
     3.840    69.449     0.200
     3.840    69.848     0.200
     4.010    72.949     0.200
     7.715   137.949     0.200
     0.316     6.402     0.200
     0.316     6.504     0.200
     1.152    21.703     0.200
     1.253    23.305     0.200
     2.048    37.305     0.200
     2.450    43.805     0.200
     2.450    44.305     0.200
     2.498    45.703     0.200
     2.498    45.902     0.200
     2.494    46.004     0.200
     2.494    45.605     0.200
     2.684    48.902     0.200
     3.499    63.605     0.200
     3.499    63.805     0.200
     3.830    68.703     0.200
     3.839    69.805     0.200
     4.016    72.902     0.200
     4.095    74.402     0.200
     6.651   119.605     0.200
     8.067   143.004     0.200
     0.351     7.090     0.200
     0.881    16.791     0.200
     1.557    28.590     0.200
     1.740    31.891     0.200
     2.307    41.990     0.200
     2.750    49.590     0.200
     2.948    53.691     0.200
     4.137    74.990     0.200
     0.378     7.436     0.200
     0.899    17.135     0.200
     1.550    29.035     0.200
     1.748    32.336     0.200
     2.280    42.336     0.200
     2.760    50.035     0.200
     4.473    81.035     0.200
     0.525    10.336     0.200
     1.011    19.035     0.200
     1.011    18.934     0.200
     1.398    26.434     0.200
     2.287    41.535     0.200
     2.284    41.434     0.200
     2.441    44.934     0.200
     3.256    59.336     0.200
     3.595    65.035     0.200
     4.072    74.234     0.200
     4.092    73.637     0.200
     0.472     9.512     0.200
     0.472     9.411     0.200
     1.057    19.812     0.200
     1.434    26.212     0.200
     1.434    26.111     0.200
     1.875    33.812     0.200
     2.223    40.312     0.200
     2.654    48.411     0.200
     2.654    48.212     0.200
     2.718    49.111     0.200
     2.718    48.712     0.200
     2.783    50.512     0.200
     2.783    50.012     0.200
     3.666    64.712     0.200
     3.666    66.512     0.200
     3.998    71.611     0.200
     3.998    71.111     0.200
     4.295    77.111     0.200
     4.324    78.012     0.200
     5.513    98.611     0.200
     6.748   122.012     0.200
     0.915    17.750     0.200
     0.915    17.852     0.200
     1.065    20.445     0.200
     2.064    38.750     0.200
     2.064    38.648     0.200
     2.240    40.945     0.200
     2.240    40.648     0.200
     2.859    50.945     0.200
     2.866    52.148     0.200
     3.112    56.047     0.200
     3.401    60.648     0.200
     3.465    62.648     0.200
     3.576    64.648     0.200
     4.479    80.547     0.200
     4.809    86.750     0.200
     4.809    86.547     0.200
     5.115    92.352     0.200
     5.750   104.250     0.200
     6.270   113.047     0.200
     0.775    15.148     0.200
     0.775    15.047     0.200
     1.151    22.344     0.200
     2.242    41.344     0.200
     2.242    41.242     0.200
     2.552    46.945     0.200
     3.188    57.242     0.200
     3.493    63.344     0.200
     4.481    81.547     0.200
     4.829    87.547     0.200
     4.829    86.844     0.200
     5.227    94.445     0.200
     5.227    94.648     0.200
     5.760   103.945     0.200
     7.186   127.742     0.200
     7.656   138.242     0.200
     0.542    10.688     0.200
     1.163    21.984     0.200
     1.355    25.188     0.200
     1.355    25.086     0.200
     1.967    35.789     0.200
     2.205    40.984     0.200
     2.565    46.883     0.200
     2.683    48.789     0.200
     2.683    48.688     0.200
     2.683    49.086     0.200
     3.583    65.086     0.200
     3.768    68.484     0.200
     3.909    70.383     0.200
     5.408    97.984     0.200
     0.632    12.270     0.200
     1.168    21.672     0.200
     1.168    21.570     0.200
     1.350    25.070     0.200
     2.275    41.570     0.200
     2.275    41.969     0.200
     2.369    43.570     0.200
     2.487    45.270     0.200
     2.547    46.070     0.200
     2.547    46.172     0.200
     3.389    61.371     0.200
     3.713    66.672     0.200
     3.713    66.570     0.200
     3.945    71.371     0.200
     4.029    72.672     0.200
     4.096    72.871     0.200
     4.187    75.871     0.200
     4.655    83.770     0.200
     0.328     6.773     0.200
     1.166    21.977     0.200
     1.240    23.078     0.200
     2.060    37.375     0.200
     2.443    43.875     0.200
     2.485    45.477     0.200
     2.494    45.578     0.200
     3.826    69.172     0.200
     3.842    68.477     0.200
     4.104    73.773     0.200
     4.208    76.078     0.200
     4.484    80.172     0.200
     4.762    85.773     0.200
     0.634    12.414     0.200
     1.203    22.914     0.200
     1.379    25.816     0.200
     2.118    40.016     0.200
     2.746    49.914     0.200
     3.775    68.016     0.200
     4.569    82.516     0.200
     0.195     4.610     0.200
     1.015    19.110     0.200
     1.384    26.011     0.200
     2.522    44.711     0.200
     2.506    45.610     0.200
     2.827    51.411     0.200
     2.827    51.311     0.200
     3.700    66.511     0.200
     3.740    66.511     0.200
     3.972    71.911     0.200
     3.972    71.211     0.200
     0.735    14.287     0.200
     0.735    14.187     0.200
     1.039    19.687     0.200
     1.492    27.787     0.200
     2.307    42.187     0.200
     2.229    41.387     0.200
     2.229    41.287     0.200
     2.322    42.887     0.200
     2.465    44.787     0.200
     3.250    58.887     0.200
     3.572    64.587     0.200
     4.108    73.887     0.200
     4.108    74.287     0.200
     4.132    74.887     0.200
     4.221    76.787     0.200
     4.874    86.187     0.200
     5.078    91.587     0.200
     0.837    16.199     0.200
     1.301    24.500     0.200
     1.463    27.402     0.200
     1.463    27.602     0.200
     1.923    37.000     0.200
     1.987    38.199     0.200
     2.899    52.699     0.200
     3.636    66.000     0.200
     3.720    67.500     0.200
     3.945    71.699     0.200
     4.187    76.500     0.200
     5.323    96.801     0.200
     6.594   119.902     0.200
     6.594   119.602     0.200
     7.509   134.500     0.200
     8.400   150.199     0.200
     0.503     9.977     0.200
     0.503     9.875     0.200
     1.104    20.977     0.200
     1.399    25.875     0.200
     1.399    25.773     0.200
     1.915    34.875     0.200
     2.212    40.875     0.200
     2.704    48.672     0.200
     3.703    66.773     0.200
     3.715    66.172     0.200
     3.959    71.172     0.200
     4.280    77.578     0.200
     7.571   135.273     0.200
     0.692    13.492     0.200
     1.132    21.594     0.200
     1.410    26.793     0.200
     2.215    41.195     0.200
     2.263    42.695     0.200
     2.323    43.492     0.200
     2.431    44.992     0.200
     2.541    46.094     0.200
     3.666    66.695     0.200
     4.129    74.793     0.200
     0.549    10.781     0.200
     1.143    21.582     0.200
     2.165    38.984     0.200
     2.363    43.781     0.200
     2.367    43.883     0.200
     2.476    45.082     0.200
     3.708    67.383     0.200
     0.280     6.619     0.200
     0.280     6.518     0.200
     0.659    12.518     0.200
     1.750    31.119     0.200
     2.737    47.418     0.200
     2.737    47.719     0.200
     3.002    54.119     0.200
     3.780    67.219     0.200
     5.794   104.518     0.200
     0.326     6.494     0.200
     0.618    12.295     0.200
     1.302    23.195     0.200
     2.086    37.994     0.200
     2.567    46.594     0.200
     3.038    53.395     0.200
     3.114    54.494     0.200
     3.620    61.494     0.200
     3.541    63.895     0.200
     4.387    77.895     0.200
     4.673    83.795     0.200
     5.079    91.295     0.200
     5.603   100.094     0.200
     1.078    20.652     0.200
     1.304    24.553     0.200
     1.632    30.652     0.200
     1.920    35.953     0.200
     2.300    43.053     0.200
     2.367    44.053     0.200
     2.364    44.053     0.200
     2.841    51.854     0.200
     3.393    61.953     0.200
     3.688    66.854     0.200
     4.094    74.053     0.200
     4.543    81.053     0.200
     5.002    89.652     0.200
     5.481    99.553     0.200
     6.980   126.652     0.200
     0.773    15.078     0.200
     0.827    15.578     0.200
     1.624    29.578     0.200
     2.045    38.078     0.200
     2.237    40.578     0.200
     2.205    40.281     0.200
     2.484    44.883     0.200
     2.540    46.484     0.200
     3.059    55.578     0.200
     3.390    61.383     0.200
     3.916    70.680     0.200
     4.279    76.484     0.200
     4.276    76.281     0.200
     6.173   112.078     0.200
     0.149     3.445     0.200
     1.371    25.547     0.200
     1.371    25.844     0.200
     1.953    35.945     0.200
     2.474    44.344     0.200
     2.474    44.445     0.200
     2.830    51.750     0.200
     2.830    51.648     0.200
     3.990    72.445     0.200
     3.959    72.148     0.200
     3.959    71.344     0.200
     5.603   101.750     0.200
     7.067   127.250     0.200
     8.331   148.445     0.200
     0.156     3.383     0.200
     1.358    25.477     0.200
     1.966    35.883     0.200
     2.462    44.383     0.200
     2.819    51.180     0.200
     3.732    67.477     0.200
     3.946    71.180     0.200
     4.878    88.680     0.200
     0.738    14.434     0.200
     1.132    21.230     0.200
     1.563    28.730     0.200
     1.831    32.730     0.200
     1.950    36.230     0.200
     2.940    53.031     0.200
     3.633    65.230     0.200
     4.489    80.133     0.200
     4.549    81.133     0.200
     0.275     5.192     0.200
     0.692    13.593     0.200
     1.254    23.492     0.200
     2.164    39.593     0.200
     2.614    47.692     0.200
     2.955    53.293     0.200
     3.085    54.893     0.200
     3.416    62.093     0.200
     3.624    64.992     0.200
     3.624    65.893     0.200
     4.407    79.093     0.200
     4.399    79.293     0.200
     4.749    84.893     0.200
     5.162    93.593     0.200
     5.678   101.593     0.200
     6.387   115.893     0.200
     1.212    23.227     0.200
     2.157    39.828     0.200
     2.176    41.125     0.200
     2.390    44.625     0.200
     2.481    46.031     0.200
     3.414    62.531     0.200
     3.732    67.828     0.200
     3.924    71.531     0.200
     4.021    72.625     0.200
     4.282    77.930     0.200
     4.675    84.727     0.200
     6.040   109.828     0.200
     0.541    10.717     0.200
     1.407    26.416     0.200
     1.917    35.316     0.200
     2.177    41.017     0.200
     2.728    49.316     0.200
     3.699    67.116     0.200
     3.960    71.916     0.200
     4.901    88.717     0.200
     5.453    99.116     0.200
     0.310     6.391     0.200
     0.733    13.695     0.200
     1.633    30.391     0.200
     1.674    30.391     0.200
     2.393    43.891     0.200
     2.920    52.891     0.200
     3.095    55.789     0.200
     4.635    84.195     0.200
     0.327     6.480     0.200
     1.628    30.879     0.200
     1.676    30.879     0.200
     2.370    44.078     0.200
     2.920    52.777     0.200
     3.091    56.078     0.200
     4.284    77.480     0.200
     4.262    76.879     0.200
     4.631    83.777     0.200
     5.198    94.578     0.200
     0.318     6.352     0.200
     1.548    28.754     0.200
     1.750    32.555     0.200
     2.340    43.152     0.200
     2.726    48.953     0.200
     2.949    53.754     0.200
     3.536    64.152     0.200
     3.558    63.555     0.200
     3.793    69.152     0.200
     4.131    74.953     0.200
     4.248    77.254     0.200
     4.490    81.453     0.200
     5.068    92.152     0.200
     5.696   103.254     0.200
     6.917   124.852     0.200
     0.778    15.158     0.200
     0.935    17.758     0.200
     2.129    39.959     0.200
     2.255    41.758     0.200
     2.374    43.158     0.200
     2.403    44.258     0.200
     2.404    44.158     0.200
     3.149    57.658     0.200
     3.473    62.859     0.200
     4.052    73.258     0.200
     4.204    76.059     0.200
     5.000    90.959     0.200
     6.222   112.758     0.200
     0.603    11.914     0.200
     1.054    19.615     0.200
     2.254    40.014     0.200
     2.275    41.914     0.200
     2.407    43.514     0.200
     2.413    44.314     0.200
     2.423    44.314     0.200
     3.619    65.115     0.200
     3.964    71.914     0.200
     4.050    71.615     0.200
     4.047    72.715     0.200
     4.559    82.314     0.200
     0.309     6.335     0.200
     0.890    16.835     0.200
     1.534    28.535     0.200
     1.764    32.335     0.200
     2.349    43.535     0.200
     2.712    48.935     0.200
     3.550    64.135     0.200
     3.572    64.135     0.200
     4.117    74.635     0.200
     0.330     6.574     0.200
     0.872    16.875     0.200
     1.557    28.977     0.200
     1.740    32.477     0.200
     2.328    42.477     0.200
     2.739    48.977     0.200
     2.955    53.875     0.200
     3.527    63.477     0.200
     3.547    63.375     0.200
     4.139    74.477     0.200
     0.137     3.312     0.200
     0.964    18.312     0.200
     2.534    46.172     0.200
     2.669    48.062     0.200
     2.767    50.391     0.200
     3.325    58.684     0.200
     3.441    60.094     0.200
     4.679    83.453     0.200
     0.786    15.203     0.200
     0.927    17.602     0.200
     1.584    29.703     0.200
     2.245    41.602     0.200
     2.369    43.203     0.200
     2.413    44.008     0.200
     2.406    44.602     0.200
     4.050    73.102     0.200
     0.599    11.699     0.200
     1.163    22.000     0.200
     1.400    26.098     0.200
     2.133    40.297     0.200
     2.749    49.797     0.200
     3.715    67.598     0.200
     3.942    71.297     0.200
     0.583    11.461     0.200
     1.154    21.859     0.200
     1.398    26.059     0.200
     2.147    40.359     0.200
     2.739    49.859     0.200
     3.714    65.859     0.200
     3.943    71.258     0.200
     4.344    79.059     0.200
     4.885    88.961     0.200
     6.882   124.961     0.200
     0.535    10.477     0.200
     1.000    19.180     0.200
     1.409    26.477     0.200
     2.242    41.781     0.200
     2.276    41.781     0.200
     2.431    44.883     0.200
     3.899    70.977     0.200
     4.103    74.781     0.200
     0.913    16.914     0.200
     1.573    28.715     0.200
     2.117    38.914     0.200
     2.255    41.016     0.200
     2.255    41.812     0.200
     2.336    42.016     0.200
     2.413    42.414     0.200
     2.444    44.215     0.200
     4.011    72.715     0.200
     4.199    74.914     0.200
     4.211    75.516     0.200
     4.403    79.414     0.200
     5.007    90.613     0.200
     0.331     7.441     0.200
     0.635    12.041     0.200
     0.635    12.541     0.200
     1.609    28.643     0.200
     1.609    30.342     0.200
     1.803    31.541     0.200
     2.674    48.041     0.200
     2.674    47.842     0.200
     2.733    49.041     0.200
     2.733    48.742     0.200
     3.055    54.742     0.200
     3.326    58.242     0.200
     4.115    74.342     0.200
     4.816    86.842     0.200
     5.310    94.842     0.200
     6.060   109.541     0.200
     6.897   123.941     0.200
     1.219    23.430     0.200
     2.072    37.730     0.200
     2.113    38.730     0.200
     2.667    48.830     0.200
     2.908    52.930     0.200
     2.974    54.031     0.200
     3.296    60.330     0.200
     4.524    82.430     0.200
     4.708    85.230     0.200
     5.723   103.730     0.200
     0.127     4.966     0.200
     1.964    33.966     0.200
     1.964    34.966     0.200
     2.393    42.366     0.200
     2.393    42.466     0.200
     2.705    48.366     0.200
     2.785    50.266     0.200
     3.690    65.866     0.200
     3.839    68.066     0.200
     4.028    71.866     0.200
     4.952    89.466     0.200
     4.952    89.566     0.200
     5.679   102.566     0.200
     6.129   109.366     0.200
     6.912   124.466     0.200
     8.098   144.566     0.200
     0.103     3.289     0.200
     0.836    16.195     0.200
     1.074    19.891     0.200
     2.490    45.195     0.200
     3.266    57.492     0.200
     0.603    11.689     0.200
     1.230    23.088     0.200
     1.316    24.289     0.200
     2.021    36.988     0.200
     2.181    40.189     0.200
     2.623    47.789     0.200
     2.677    48.689     0.200
     3.798    69.088     0.200
     0.621    12.172     0.200
     1.244    23.574     0.200
     1.313    24.172     0.200
     2.030    37.172     0.200
     2.169    40.375     0.200
     2.612    47.672     0.200
     2.682    48.473     0.200
     3.852    70.172     0.200
     4.305    78.273     0.200
     0.175     4.086     0.200
     0.828    16.184     0.200
     1.062    19.586     0.200
     2.880    51.586     0.200
     3.290    58.184     0.200
     0.795    15.430     0.200
     1.331    24.828     0.200
     1.360    25.727     0.200
     2.036    38.328     0.200
     2.485    46.129     0.200
     2.547    46.828     0.200
     2.770    50.227     0.200
     1.368    25.676     0.200
     1.338    24.875     0.200
     1.338    24.977     0.200
     2.091    39.875     0.200
     2.020    38.176     0.200
     2.488    46.176     0.200
     2.783    50.273     0.200
     3.836    69.977     0.200
     3.893    70.574     0.200
     3.826    69.977     0.200
     0.818    15.844     0.200
     1.341    25.246     0.200
     1.341    25.145     0.200
     1.372    25.844     0.200
     2.015    38.145     0.200
     2.093    38.047     0.200
     2.093    37.844     0.200
     2.093    39.547     0.200
     2.489    46.246     0.200
     2.489    46.445     0.200
     2.788    50.547     0.200
     2.788    50.047     0.200
     3.516    63.945     0.200
     3.836    69.445     0.200
     3.826    69.746     0.200
     3.894    70.246     0.200
     3.894    70.145     0.200
     4.080    73.844     0.200
     4.853    87.945     0.200
     6.491   117.746     0.200
     7.574   135.945     0.200
     8.452   149.344     0.200
     0.797    15.375     0.200
     1.329    24.875     0.200
     1.363    25.477     0.200
     2.036    38.074     0.200
     2.092    39.074     0.200
     2.544    46.676     0.200
     2.769    50.176     0.200
     3.839    70.074     0.200
     4.423    80.574     0.200
     0.804    15.555     0.200
     1.329    24.855     0.200
     1.369    25.652     0.200
     2.031    38.055     0.200
     2.096    38.953     0.200
     2.772    50.254     0.200
     3.819    69.152     0.200
     0.787    15.082     0.200
     1.345    25.281     0.200
     1.344    24.883     0.200
     2.032    37.883     0.200
     2.073    38.281     0.200
     2.563    46.781     0.200
     2.779    50.484     0.200
     0.799    15.324     0.200
     1.339    25.023     0.200
     2.028    38.023     0.200
     2.085    38.223     0.200
     2.492    46.223     0.200
     2.552    46.824     0.200
     2.779    50.723     0.200
     0.793    15.328     0.200
     1.348    24.930     0.200
     2.026    37.930     0.200
     2.073    37.828     0.200
     2.784    50.430     0.200
     4.435    80.734     0.200
     0.797    15.381     0.200
     1.346    24.981     0.200
     2.024    38.081     0.200
     2.077    38.381     0.200
     2.785    50.781     0.200
     0.806    15.625     0.200
     1.344    25.125     0.200
     1.360    25.523     0.200
     2.020    38.125     0.200
     2.083    38.723     0.200
     2.495    45.723     0.200
     2.786    50.523     0.200
     3.833    69.922     0.200
     3.885    70.523     0.200
     5.238    94.824     0.200
     0.802    15.562     0.200
     1.330    24.859     0.200
     1.367    25.859     0.200
     2.032    38.562     0.200
     2.094    39.664     0.200
     2.772    50.461     0.200
     3.820    69.359     0.200
     4.078    74.359     0.200
     4.427    80.164     0.200
     0.808    15.629     0.200
     1.366    25.729     0.200
     1.337    25.029     0.200
     2.090    39.229     0.200
     2.024    38.229     0.200
     2.488    46.029     0.200
     2.546    46.729     0.200
     2.781    50.430     0.200
     2.781    50.329     0.200
     3.835    68.229     0.200
     3.892    70.229     0.200
     3.892    70.129     0.200
     3.825    69.829     0.200
     4.082    74.229     0.200
     4.861    88.129     0.200
     5.231    94.930     0.200
     7.258   129.829     0.200
     0.804    15.568     0.200
     1.344    25.068     0.200
     1.359    25.568     0.200
     2.021    38.168     0.200
     2.083    37.969     0.200
     2.495    46.068     0.200
     2.785    50.568     0.200
     3.828    69.668     0.200
     3.884    70.869     0.200
     4.089    74.168     0.200
     0.810    15.751     0.200
     1.344    25.352     0.200
     1.363    25.651     0.200
     2.017    38.251     0.200
     2.085    38.951     0.200
     2.495    45.651     0.200
     2.788    50.751     0.200
     3.829    69.552     0.200
     3.832    69.552     0.200
     3.886    70.852     0.200
     4.087    74.552     0.200
     4.442    80.552     0.200
     5.236    95.151     0.200
     0.820    15.941     0.200
     1.369    25.842     0.200
     1.347    25.441     0.200
     2.088    38.441     0.200
     2.009    38.242     0.200
     2.009    38.041     0.200
     2.494    46.541     0.200
     2.794    50.842     0.200
     3.830    69.742     0.200
     3.889    69.541     0.200
     3.832    69.742     0.200
     4.854    86.242     0.200
     5.231    95.141     0.200
     5.231    95.242     0.200
     7.250   122.441     0.200
     7.425   134.541     0.200
     7.578   136.742     0.200
     1.352    25.291     0.200
     1.343    24.991     0.200
     2.027    37.991     0.200
     2.078    38.691     0.200
     2.497    45.991     0.200
     2.558    46.791     0.200
     2.781    50.191     0.200
     3.825    68.791     0.200
     3.880    70.391     0.200
     4.094    74.591     0.200
     4.433    80.691     0.200
     0.785    15.047     0.200
     1.318    24.750     0.200
     1.361    25.750     0.200
     2.052    38.352     0.200
     2.096    38.945     0.200
     3.813    69.445     0.200
     0.812    15.820     0.200
     1.341    25.320     0.200
     1.367    25.820     0.200
     2.018    38.520     0.200
     2.089    39.520     0.200
     2.786    50.720     0.200
     3.828    69.520     0.200
     4.083    74.420     0.200
     0.810    15.672     0.200
     1.344    25.172     0.200
     1.363    25.773     0.200
     2.018    38.375     0.200
     2.086    37.875     0.200
     2.494    46.172     0.200
     2.787    50.578     0.200
     3.520    63.875     0.200
     3.831    69.172     0.200
     3.887    70.078     0.200
     4.087    74.273     0.200
     4.441    80.672     0.200
     4.774    85.477     0.200
     5.235    95.172     0.200
     0.701    13.559     0.200
     1.228    22.859     0.200
     1.228    22.961     0.200
     2.175    40.758     0.200
     2.137    39.660     0.200
     2.409    44.758     0.200
     2.409    44.559     0.200
     2.638    47.859     0.200
     2.638    47.660     0.200
     3.751    67.961     0.200
     4.042    73.059     0.200
     3.939    71.758     0.200
     4.285    77.961     0.200
     5.217    94.859     0.200
     5.217    94.660     0.200
     6.462   117.461     0.200
     7.333   131.859     0.200
     8.397   149.660     0.200
     0.246     5.195     0.200
     0.847    16.082     0.200
     1.080    21.082     0.200
     1.080    20.902     0.200
     3.247    55.715     0.200
     3.080    56.113     0.200
     3.468    58.965     0.200
     4.789    84.953     0.200
     5.840   103.004     0.200
     6.344   110.895     0.200
     6.867   120.672     0.200
     7.024   123.305     0.200
     0.315     6.455     0.200
     1.156    21.854     0.200
     1.248    23.555     0.200
     2.053    38.055     0.200
     2.444    44.254     0.200
     2.494    45.955     0.200
     2.500    45.654     0.200
     3.494    63.654     0.200
     3.834    69.455     0.200
     4.009    72.354     0.200
     6.648   120.654     0.200
     0.844    16.339     0.200
     0.893    17.239     0.200
     2.074    39.139     0.200
     2.191    40.339     0.200
     2.361    43.039     0.200
     2.405    44.239     0.200
     2.463    45.039     0.200
     3.095    56.639     0.200
     3.732    67.739     0.200
     4.054    73.639     0.200
     4.263    77.339     0.200
     4.782    85.539     0.200
     5.775   104.939     0.200
     0.093     3.164     0.200
     0.944    17.664     0.200
     1.878    34.367     0.200
     2.528    45.066     0.200
     2.571    46.766     0.200
     3.639    65.066     0.200
     4.042    72.566     0.200
     6.525   118.066     0.200
     6.880   123.867     0.200
     6.914   125.664     0.200
     0.552    10.828     0.200
     1.454    25.227     0.200
     2.953    52.426     0.200
     2.981    52.727     0.200
     4.165    73.926     0.200
     0.606    12.031     0.200
     1.166    22.160     0.200
     1.166    21.648     0.200
     2.604    46.461     0.200
     2.969    51.512     0.200
     3.057    55.461     0.200
     3.057    55.238     0.200
     3.406    60.961     0.200
     4.505    81.262     0.200
     5.240    93.660     0.200
     5.641    98.051     0.200
     0.786    15.192     0.200
     0.930    17.593     0.200
     1.583    29.393     0.200
     2.247    41.393     0.200
     2.373    43.293     0.200
     2.411    43.692     0.200
     2.403    44.593     0.200
     3.788    68.893     0.200
     4.407    80.293     0.200
     4.992    90.393     0.200
     6.214   112.893     0.200
     0.368     7.141     0.200
     0.831    15.641     0.200
     1.609    29.641     0.200
     1.688    32.141     0.200
     1.688    32.039     0.200
     2.294    42.742     0.200
     2.793    50.836     0.200
     2.793    50.336     0.200
     3.000    54.242     0.200
     3.477    62.938     0.200
     4.310    78.641     0.200
     4.541    82.242     0.200
     5.127    92.938     0.200
     5.740   104.039     0.200
     0.489     9.844     0.200
     1.034    19.824     0.200
     1.248    23.496     0.200
     2.995    51.223     0.200
     3.160    54.523     0.200
     4.382    77.875     0.200
     5.833   103.004     0.200
     6.113   107.355     0.200
     6.623   116.215     0.200
     6.770   119.293     0.200
     1.063    20.812     0.200
     4.267    75.117     0.200
     5.159    92.812     0.200
     5.270    92.016     0.200
     5.270    94.914     0.200
     6.336   114.516     0.200
     0.299     5.984     0.200
     0.299     6.086     0.200
     1.286    24.180     0.200
     2.015    37.281     0.200
     2.015    36.586     0.200
     2.015    37.180     0.200
     2.479    44.984     0.200
     2.478    45.180     0.200
     2.478    45.484     0.200
     3.797    68.281     0.200
     3.872    69.984     0.200
     3.872    70.586     0.200
     4.039    73.180     0.200
     4.253    76.984     0.200
     4.253    77.086     0.200
     4.807    87.086     0.200
     6.705   121.484     0.200
     7.458   134.086     0.200
     0.365     8.059     0.200
     1.539    27.461     0.200
     2.810    49.262     0.200
     2.810    49.160     0.200
     3.273    58.461     0.200
     4.207    74.559     0.200
     4.421    79.762     0.200
     4.421    79.262     0.200
     4.835    86.559     0.200
     4.835    87.461     0.200
     5.350    95.859     0.200
     7.480   132.559     0.200
     0.520    10.112     0.200
     1.221    23.413     0.200
     1.631    30.513     0.200
     1.753    32.513     0.200
     2.114    38.513     0.200
     2.656    48.312     0.200
     2.909    52.913     0.200
     2.973    54.212     0.200
     4.516    81.812     0.200
     5.721   103.413     0.200
     0.923    17.809     0.200
     0.947    18.207     0.200
     1.705    31.707     0.200
     2.142    39.809     0.200
     2.321    43.105     0.200
     2.438    44.605     0.200
     2.496    46.406     0.200
     3.400    62.309     0.200
     4.147    75.707     0.200
     4.299    78.105     0.200
     0.231     4.672     0.200
     0.231     4.773     0.200
     0.953    18.172     0.200
     1.452    26.875     0.200
     1.851    33.672     0.200
     1.851    33.773     0.200
     2.437    45.273     0.200
     2.607    46.875     0.200
     2.607    46.977     0.200
     2.698    49.477     0.200
     2.878    52.375     0.200
     3.630    65.477     0.200
     4.039    73.570     0.200
     4.131    75.375     0.200
     4.417    80.477     0.200
     6.846   124.273     0.200
     6.846   124.375     0.200
     0.224     4.648     0.200
     0.952    17.945     0.200
     1.452    26.945     0.200
     1.852    33.945     0.200
     2.444    45.250     0.200
     2.603    47.047     0.200
     2.880    52.547     0.200
     3.630    65.750     0.200
     4.039    73.547     0.200
     4.419    80.047     0.200
     0.227     4.539     0.200
     0.227     4.641     0.200
     0.951    17.938     0.200
     1.454    27.344     0.200
     1.850    33.742     0.200
     2.606    46.844     0.200
     2.881    52.438     0.200
     2.881    52.539     0.200
     3.628    65.938     0.200
     4.041    73.438     0.200
     4.041    73.141     0.200
     4.420    80.438     0.200
     6.868   124.539     0.200
     6.944   126.141     0.200
     7.836   139.539     0.200
     0.218     4.500     0.200
     0.950    18.000     0.200
     1.454    27.000     0.200
     1.454    26.898     0.200
     2.450    44.602     0.200
     2.450    45.398     0.200
     2.601    46.602     0.200
     2.601    46.898     0.200
     2.700    49.398     0.200
     2.883    52.500     0.200
     3.629    65.797     0.200
     3.699    67.297     0.200
     4.041    72.898     0.200
     4.121    75.102     0.200
     4.422    80.398     0.200
     4.975    90.297     0.200
     0.219     4.703     0.200
     0.958    18.102     0.200
     1.446    27.102     0.200
     1.446    27.305     0.200
     1.859    33.898     0.200
     1.859    33.703     0.200
     2.451    45.000     0.200
     2.451    45.305     0.200
     2.595    46.703     0.200
     2.595    46.805     0.200
     3.636    64.398     0.200
     3.636    65.898     0.200
     4.033    72.703     0.200
     4.415    80.305     0.200
     7.838   140.898     0.200
     0.212     4.420     0.200
     0.942    17.920     0.200
     1.461    26.920     0.200
     1.845    34.020     0.200
     2.604    46.720     0.200
     2.604    46.619     0.200
     2.453    44.420     0.200
     2.708    49.319     0.200
     2.892    52.720     0.200
     2.892    52.420     0.200
     3.621    65.920     0.200
     3.621    65.420     0.200
     3.707    67.119     0.200
     4.122    75.020     0.200
     4.049    73.319     0.200
     4.431    80.119     0.200
     4.983    90.520     0.200
     5.445    98.420     0.200
     7.852   140.920     0.200
     0.223     4.588     0.200
     0.948    17.887     0.200
     1.456    27.188     0.200
     1.848    33.887     0.200
     2.444    45.188     0.200
     2.606    46.986     0.200
     3.626    66.088     0.200
     4.043    73.588     0.200
     4.127    74.486     0.200
     0.957    17.137     0.200
     1.443    26.438     0.200
     1.866    33.637     0.200
     2.480    44.738     0.200
     2.881    52.137     0.200
     3.640    65.137     0.200
     6.872   123.938     0.200
     6.945   126.238     0.200
     0.210     4.340     0.200
     0.938    17.840     0.200
     1.464    26.941     0.200
     1.842    33.941     0.200
     2.455    44.941     0.200
     2.605    46.742     0.200
     2.896    52.641     0.200
     3.618    65.340     0.200
     4.435    80.141     0.200
     0.233     4.742     0.200
     1.456    27.242     0.200
     1.847    34.039     0.200
     2.434    45.039     0.200
     2.611    47.141     0.200
     6.480   116.938     0.200
     6.849   124.438     0.200
     6.944   125.844     0.200
     0.212     4.852     0.200
     0.953    17.953     0.200
     1.856    34.250     0.200
     2.457    44.852     0.200
     2.594    46.555     0.200
     3.633    65.352     0.200
     4.114    74.648     0.200
     4.420    80.148     0.200
     0.216     4.270     0.200
     0.216     4.469     0.200
     0.934    17.770     0.200
     1.469    27.066     0.200
     2.447    45.066     0.200
     2.447    45.367     0.200
     2.613    46.867     0.200
     2.613    46.969     0.200
     2.716    49.770     0.200
     2.899    52.867     0.200
     3.613    65.668     0.200
     3.613    65.770     0.200
     3.715    67.668     0.200
     4.438    80.867     0.200
     4.991    90.168     0.200
     0.216     4.367     0.200
     0.939    17.566     0.200
     1.464    26.965     0.200
     1.841    33.668     0.200
     2.448    45.168     0.200
     2.609    46.867     0.200
     2.894    52.766     0.200
     3.618    65.766     0.200
     4.052    73.367     0.200
     4.433    80.266     0.200
     6.862   124.066     0.200
     0.219     4.594     0.200
     0.948    17.992     0.200
     1.456    26.797     0.200
     1.456    26.898     0.200
     1.849    33.695     0.200
     2.448    44.398     0.200
     2.448    45.297     0.200
     2.604    46.492     0.200
     2.604    46.992     0.200
     2.702    49.398     0.200
     2.885    52.594     0.200
     3.626    65.797     0.200
     3.626    65.594     0.200
     3.701    67.094     0.200
     3.702    67.094     0.200
     4.043    72.797     0.200
     4.043    73.594     0.200
     4.424    79.992     0.200
     5.437    97.594     0.200
     5.906   106.992     0.200
     6.853   123.898     0.200
     7.844   140.898     0.200
     0.225     4.562     0.200
     0.954    17.969     0.200
     1.450    27.164     0.200
     1.854    33.867     0.200
     2.444    45.367     0.200
     2.602    47.062     0.200
     3.632    66.062     0.200
     3.696    66.969     0.200
     4.037    73.164     0.200
     4.125    74.867     0.200
     4.417    79.766     0.200
     4.972    90.266     0.200
     0.204     4.396     0.200
     0.956    18.396     0.200
     1.861    33.797     0.200
     2.466    44.797     0.200
     2.586    46.797     0.200
     2.693    48.996     0.200
     3.637    65.797     0.200
     4.105    74.098     0.200
     4.418    80.197     0.200
     0.227     4.723     0.200
     0.954    18.021     0.200
     1.451    27.121     0.200
     1.853    33.922     0.200
     2.442    44.723     0.200
     2.603    47.021     0.200
     2.696    49.322     0.200
     3.632    65.521     0.200
     3.696    66.922     0.200
     4.126    74.723     0.200
     4.417    79.922     0.200
     4.972    89.723     0.200
     5.427    98.121     0.200
     5.638   102.322     0.200
     0.219     4.580     0.200
     0.954    17.979     0.200
     1.450    26.979     0.200
     1.855    33.779     0.200
     2.449    44.680     0.200
     2.599    46.779     0.200
     2.599    46.979     0.200
     3.632    65.779     0.200
     3.632    65.580     0.200
     4.037    73.479     0.200
     4.120    74.979     0.200
     4.419    79.379     0.200
     4.972    90.279     0.200
     5.911   104.779     0.200
     0.361     7.324     0.200
     1.165    21.924     0.200
     1.251    23.123     0.200
     2.047    37.225     0.200
     2.445    44.623     0.200
     2.481    44.623     0.200
     2.491    45.523     0.200
     2.665    48.623     0.200
     3.833    68.824     0.200
     4.770    86.523     0.200
     5.425    98.225     0.200
     0.369     7.322     0.200
     1.170    22.223     0.200
     1.247    23.223     0.200
     2.050    37.521     0.200
     2.050    37.623     0.200
     2.439    44.422     0.200
     2.439    44.822     0.200
     2.482    44.822     0.200
     2.487    45.922     0.200
     3.837    69.322     0.200
     0.207     4.461     0.200
     0.939    17.664     0.200
     1.463    27.164     0.200
     1.844    34.062     0.200
     2.458    45.262     0.200
     2.602    46.961     0.200
     3.620    65.762     0.200
     3.708    67.062     0.200
     4.050    73.664     0.200
     4.119    74.762     0.200
     0.237     4.676     0.200
     0.950    17.976     0.200
     1.457    27.476     0.200
     1.845    33.976     0.200
     2.431    45.076     0.200
     2.614    47.176     0.200
     3.625    66.076     0.200
     4.044    73.576     0.200
     4.138    75.076     0.200
     4.421    80.676     0.200
     0.372     7.277     0.200
     1.245    23.176     0.200
     1.173    22.078     0.200
     2.052    36.277     0.200
     2.052    37.578     0.200
     2.439    44.875     0.200
     2.485    44.676     0.200
     2.485    45.977     0.200
     2.481    44.676     0.200
     2.481    44.777     0.200
     2.657    48.375     0.200
     2.657    48.477     0.200
     3.490    63.477     0.200
     3.828    68.777     0.200
     3.839    69.176     0.200
     4.196    76.277     0.200
     4.764    86.375     0.200
     5.237    93.676     0.200
     5.416    98.277     0.200
     6.625   119.977     0.200
     8.115   144.047     0.200
     0.225     4.566     0.200
     0.943    17.867     0.200
     1.461    27.566     0.200
     1.843    34.066     0.200
     2.441    44.867     0.200
     2.611    47.066     0.200
     2.707    49.367     0.200
     2.889    52.766     0.200
     4.132    75.168     0.200
     0.224     4.500     0.200
     0.946    17.801     0.200
     1.458    27.602     0.200
     1.846    35.301     0.200
     2.443    45.000     0.200
     2.608    47.000     0.200
     3.624    65.801     0.200
     0.210     4.508     0.200
     0.938    17.609     0.200
     1.464    27.406     0.200
     1.842    34.805     0.200
     2.455    44.805     0.200
     2.605    47.109     0.200
     3.619    65.109     0.200
     4.122    74.609     0.200
     4.435    80.609     0.200
     4.986    90.305     0.200
     0.221     4.422     0.200
     0.940    17.625     0.200
     1.464    27.324     0.200
     2.444    44.723     0.200
     2.444    44.922     0.200
     2.611    46.824     0.200
     2.611    47.223     0.200
     3.619    65.523     0.200
     3.709    67.523     0.200
     4.051    73.023     0.200
     4.051    73.723     0.200
     4.431    80.422     0.200
     4.431    80.223     0.200
     5.440    98.922     0.200
     5.898   106.922     0.200
     6.860   123.723     0.200
     6.860   124.422     0.200
     0.215     4.379     0.200
     1.459    26.879     0.200
     1.847    33.879     0.200
     2.451    45.078     0.200
     2.603    46.578     0.200
     2.603    46.979     0.200
     2.705    49.279     0.200
     3.624    65.479     0.200
     3.704    67.479     0.200
     4.428    80.479     0.200
     4.428    80.178     0.200
     7.849   141.078     0.200
     0.689    13.402     0.200
     0.689    13.301     0.200
     1.131    21.402     0.200
     1.409    26.402     0.200
     2.266    42.301     0.200
     2.266    42.402     0.200
     2.322    43.203     0.200
     2.538    46.000     0.200
     2.538    46.102     0.200
     3.666    66.402     0.200
     4.016    72.703     0.200
     4.016    73.000     0.200
     6.390   115.402     0.200
     6.396   116.301     0.200
     6.396   116.102     0.200
     7.334   131.000     0.200
     0.660    12.789     0.200
     1.394    25.883     0.200
     2.209    40.383     0.200
     2.209    40.086     0.200
     2.292    42.289     0.200
     2.325    42.883     0.200
     2.519    45.883     0.200
     2.519    45.383     0.200
     3.669    66.383     0.200
     4.009    72.984     0.200
     4.009    72.086     0.200
     3.984    71.883     0.200
     7.173   129.883     0.200
     7.363   132.188     0.200
     8.394   147.602     0.200
     0.679    13.156     0.200
     1.129    21.156     0.200
     1.404    26.359     0.200
     2.213    41.559     0.200
     2.276    42.457     0.200
     2.323    43.656     0.200
     2.435    44.656     0.200
     2.531    46.059     0.200
     4.014    72.656     0.200
     4.607    83.758     0.200
     0.673    13.148     0.200
     1.125    21.047     0.200
     1.402    26.246     0.200
     2.214    40.949     0.200
     2.321    43.246     0.200
     2.284    42.449     0.200
     2.436    44.746     0.200
     2.524    46.047     0.200
     0.894    17.283     0.200
     1.178    22.684     0.200
     1.793    32.283     0.200
     3.094    56.383     0.200
     3.094    56.084     0.200
     3.587    65.383     0.200
     4.162    75.184     0.200
     6.791   123.584     0.200
     0.681    13.141     0.200
     1.123    21.242     0.200
     1.409    26.641     0.200
     2.219    40.945     0.200
     2.280    42.445     0.200
     2.317    43.242     0.200
     2.430    44.742     0.200
     2.526    46.039     0.200
     0.670    12.995     0.200
     0.670    12.895     0.200
     1.120    21.095     0.200
     1.404    26.395     0.200
     2.291    42.195     0.200
     2.291    41.995     0.200
     2.218    39.794     0.200
     2.218    41.395     0.200
     2.317    42.995     0.200
     2.317    42.794     0.200
     2.433    44.495     0.200
     2.433    44.395     0.200
     2.517    45.895     0.200
     3.661    66.195     0.200
     3.661    65.995     0.200
     3.975    72.395     0.200
     3.975    72.095     0.200
     4.018    73.195     0.200
     6.395   115.695     0.200
     8.405   147.495     0.200
     1.122    20.340     0.200
     1.395    25.441     0.200
     2.212    38.941     0.200
     2.212    39.340     0.200
     2.298    41.340     0.200
     2.513    45.043     0.200
     2.440    43.840     0.200
     3.665    65.641     0.200
     3.665    65.340     0.200
     4.012    72.641     0.200
     4.012    72.242     0.200
     3.982    72.242     0.200
     3.982    72.141     0.200
     4.606    82.641     0.200
     5.175    93.543     0.200
     5.175    93.441     0.200
     6.406   115.340     0.200
     6.406   115.840     0.200
     6.404   115.242     0.200
     6.892   123.340     0.200
     8.393   147.840     0.200
     0.237     4.832     0.200
     0.962    18.230     0.200
     1.444    27.133     0.200
     1.859    33.934     0.200
     2.435    45.133     0.200
     2.603    47.230     0.200
     2.689    49.230     0.200
     3.638    64.934     0.200
     3.689    66.832     0.200
     4.030    73.133     0.200
     4.408    80.031     0.200
     6.837   123.531     0.200
     0.659    12.914     0.200
     1.132    20.914     0.200
     1.390    26.211     0.200
     2.204    39.516     0.200
     2.287    42.211     0.200
     2.330    43.109     0.200
     2.447    45.312     0.200
     2.524    45.812     0.200
     3.674    66.414     0.200
     4.005    71.914     0.200
     5.180    94.109     0.200
     6.412   116.516     0.200
     6.884   124.016     0.200
     8.392   145.531     0.200
     0.668    12.945     0.200
     1.118    20.945     0.200
     1.404    26.141     0.200
     2.219    40.641     0.200
     2.294    42.242     0.200
     2.433    44.547     0.200
     2.514    45.742     0.200
     4.019    72.242     0.200
     0.663    12.883     0.200
     1.133    20.984     0.200
     1.391    25.883     0.200
     2.204    39.984     0.200
     2.204    38.883     0.200
     2.204    40.086     0.200
     2.330    42.781     0.200
     2.330    42.680     0.200
     2.283    41.883     0.200
     2.283    41.781     0.200
     2.527    45.680     0.200
     3.351    60.781     0.200
     3.674    66.086     0.200
     3.674    65.984     0.200
     4.005    71.781     0.200
     3.988    72.180     0.200
     7.399   133.484     0.200
     8.395   147.250     0.200
     0.690    13.492     0.200
     1.140    21.195     0.200
     1.404    26.391     0.200
     2.207    40.891     0.200
     2.257    42.297     0.200
     2.330    43.195     0.200
     2.548    46.195     0.200
     0.689    13.408     0.200
     1.122    21.308     0.200
     1.414    26.608     0.200
     2.222    41.008     0.200
     2.275    42.508     0.200
     2.314    43.108     0.200
     2.529    46.208     0.200
     3.967    72.308     0.200
     4.023    73.408     0.200
     6.390   116.108     0.200
     0.654    12.751     0.200
     1.111    20.650     0.200
     1.399    26.051     0.200
     2.312    42.650     0.200
     2.220    40.051     0.200
     2.220    40.650     0.200
     2.499    45.351     0.200
     4.020    72.650     0.200
     4.597    83.251     0.200
     6.487   117.751     0.200
     0.674    13.023     0.200
     1.109    20.523     0.200
     1.413    26.422     0.200
     2.298    42.523     0.200
     2.306    42.828     0.200
     2.508    45.625     0.200
     3.964    71.922     0.200
     4.029    72.727     0.200
     4.590    83.125     0.200
     0.677    13.109     0.200
     1.110    20.906     0.200
     1.414    26.609     0.200
     2.228    40.305     0.200
     2.294    42.609     0.200
     2.306    42.805     0.200
     2.511    45.906     0.200
     3.650    66.609     0.200
     4.029    73.109     0.200
     4.591    83.008     0.200
     0.681    13.436     0.200
     1.129    20.636     0.200
     2.214    40.036     0.200
     2.274    42.235     0.200
     2.322    43.336     0.200
     2.532    46.036     0.200
     3.666    66.136     0.200
     3.975    72.336     0.200
     0.466     8.922     0.200
     1.596    29.625     0.200
     2.059    36.422     0.200
     2.059    37.223     0.200
     2.059    37.422     0.200
     2.722    48.824     0.200
     2.939    53.023     0.200
     2.939    53.223     0.200
     5.704   102.922     0.200
     6.755   122.223     0.200
     6.991   126.324     0.200
     0.667    13.055     0.200
     0.667    12.953     0.200
     1.139    21.055     0.200
     1.391    25.953     0.200
     2.201    40.652     0.200
     2.275    42.355     0.200
     2.334    42.953     0.200
     2.535    45.754     0.200
     2.535    45.855     0.200
     3.678    66.254     0.200
     3.990    72.855     0.200
     4.619    84.152     0.200
     6.641   120.355     0.200
     8.397   149.395     0.200
     0.687    13.398     0.200
     1.110    20.797     0.200
     1.421    26.898     0.200
     2.232    41.598     0.200
     2.287    42.598     0.200
     2.516    45.695     0.200
     0.653    12.621     0.200
     1.124    20.922     0.200
     1.391    25.824     0.200
     2.208    41.023     0.200
     2.299    42.121     0.200
     2.513    45.824     0.200
     3.669    66.422     0.200
     4.009    72.223     0.200
     6.410   115.922     0.200
     0.659    12.703     0.200
     1.122    20.902     0.200
     1.396    26.203     0.200
     2.212    39.203     0.200
     2.212    40.402     0.200
     2.297    42.504     0.200
     2.322    42.902     0.200
     2.514    45.703     0.200
     3.342    60.703     0.200
     3.666    66.703     0.200
     6.406   116.004     0.200
     0.699    13.539     0.200
     1.129    21.242     0.200
     1.417    26.539     0.200
     2.220    40.242     0.200
     2.260    41.742     0.200
     2.318    43.039     0.200
     2.541    46.039     0.200
     3.662    66.141     0.200
     4.022    72.742     0.200
     4.603    83.539     0.200
     6.389   115.938     0.200
     0.701    13.594     0.200
     1.092    21.094     0.200
     1.441    26.794     0.200
     2.252    41.094     0.200
     2.284    42.693     0.200
     2.295    42.394     0.200
     2.504    45.494     0.200
     4.053    73.193     0.200
     0.662    12.770     0.200
     1.116    20.971     0.200
     1.401    26.770     0.200
     2.218    41.369     0.200
     2.315    42.971     0.200
     2.300    42.570     0.200
     2.509    45.670     0.200
     4.600    83.770     0.200
     0.664    12.766     0.200
     0.664    12.965     0.200
     1.141    21.266     0.200
     1.141    20.965     0.200
     1.387    25.863     0.200
     2.198    40.066     0.200
     2.276    42.164     0.200
     2.276    41.965     0.200
     2.337    43.363     0.200
     2.536    46.066     0.200
     2.536    46.363     0.200
     3.358    61.164     0.200
     3.681    66.566     0.200
     3.681    66.465     0.200
     3.998    72.863     0.200
     3.993    72.566     0.200
     4.622    83.566     0.200
     6.501   117.465     0.200
     7.360   132.363     0.200
     0.656    12.688     0.200
     1.143    21.086     0.200
     1.381    25.688     0.200
     2.193    39.789     0.200
     2.280    41.887     0.200
     2.341    43.086     0.200
     2.534    46.188     0.200
     3.685    66.586     0.200
     3.994    72.188     0.200
     0.658    12.602     0.200
     0.658    12.906     0.200
     1.129    20.906     0.200
     1.391    25.805     0.200
     2.206    39.906     0.200
     2.291    42.406     0.200
     2.291    42.305     0.200
     2.328    42.906     0.200
     2.521    45.703     0.200
     4.006    72.805     0.200
     5.180    94.102     0.200
     6.411   116.305     0.200
     7.365   132.906     0.200
     0.658    12.781     0.200
     1.144    21.383     0.200
     1.381    25.781     0.200
     2.193    39.680     0.200
     2.278    41.883     0.200
     2.341    43.281     0.200
     2.536    45.883     0.200
     3.685    66.586     0.200
     4.626    83.680     0.200
     0.697    13.582     0.200
     1.099    20.883     0.200
     1.434    26.781     0.200
     2.244    41.082     0.200
     2.291    42.980     0.200
     2.291    43.082     0.200
     2.509    45.684     0.200
     3.313    59.883     0.200
     3.635    66.480     0.200
     4.045    73.684     0.200
     5.137    93.480     0.200
     0.689    13.207     0.200
     1.105    20.508     0.200
     1.425    27.008     0.200
     2.236    40.305     0.200
     2.236    41.305     0.200
     2.291    42.906     0.200
     2.291    42.707     0.200
     2.299    43.008     0.200
     2.511    45.605     0.200
     2.511    45.406     0.200
     3.643    66.508     0.200
     3.955    72.207     0.200
     4.037    73.207     0.200
     4.584    83.508     0.200
     7.367   133.508     0.200
     8.425   149.648     0.200
     0.692    13.411     0.200
     1.098    20.611     0.200
     1.431    26.911     0.200
     2.243    41.111     0.200
     2.292    42.311     0.200
     2.295    42.911     0.200
     2.506    45.611     0.200
     4.044    73.411     0.200
     0.660    12.763     0.200
     1.153    21.562     0.200
     1.377    26.062     0.200
     2.186    39.763     0.200
     2.267    42.363     0.200
     2.349    43.463     0.200
     2.547    46.363     0.200
     3.693    67.263     0.200
     3.987    72.363     0.200
     5.193    94.363     0.200
     6.427   116.463     0.200
     0.666    12.954     0.200
     1.142    21.554     0.200
     1.388    26.254     0.200
     2.198    40.154     0.200
     2.273    42.554     0.200
     2.337    43.554     0.200
     2.538    46.454     0.200
     3.681    66.954     0.200
     3.999    72.554     0.200
     4.622    83.754     0.200
     0.655    12.793     0.200
     1.142    21.391     0.200
     1.381    25.992     0.200
     2.194    40.191     0.200
     2.282    42.492     0.200
     2.340    43.492     0.200
     2.532    46.293     0.200
     3.684    66.691     0.200
     3.995    71.793     0.200
     0.705    13.579     0.200
     1.118    20.880     0.200
     1.427    26.779     0.200
     2.232    41.680     0.200
     2.232    40.680     0.200
     2.267    42.479     0.200
     2.267    42.180     0.200
     2.307    42.979     0.200
     2.532    45.880     0.200
     2.532    46.479     0.200
     3.956    72.279     0.200
     4.033    73.479     0.200
     0.689    13.328     0.200
     1.113    21.133     0.200
     2.230    40.531     0.200
     2.283    42.133     0.200
     2.520    45.727     0.200
     0.696    13.485     0.200
     1.123    21.285     0.200
     2.224    40.785     0.200
     2.269    42.485     0.200
     2.533    46.085     0.200
     3.657    66.885     0.200
     4.025    73.085     0.200
     0.695    13.459     0.200
     1.090    20.559     0.200
     2.251    42.059     0.200
     2.301    42.559     0.200
     2.499    45.959     0.200
     3.628    65.859     0.200
     0.662    12.816     0.200
     1.138    21.316     0.200
     1.388    26.016     0.200
     2.200    40.516     0.200
     2.280    42.316     0.200
     2.532    46.215     0.200
     4.001    72.914     0.200
     0.679    13.211     0.200
     1.103    20.914     0.200
     1.420    26.516     0.200
     2.235    41.914     0.200
     2.299    42.812     0.200
     2.300    42.812     0.200
     2.504    45.914     0.200
     4.036    73.211     0.200
     0.711    13.729     0.200
     1.114    21.130     0.200
     1.434    27.029     0.200
     2.238    41.229     0.200
     2.267    42.430     0.200
     2.301    43.430     0.200
     2.531    46.330     0.200
     0.698    13.477     0.200
     1.090    20.680     0.200
     1.440    27.078     0.200
     2.252    41.680     0.200
     2.283    42.680     0.200
     2.299    42.781     0.200
     2.500    45.781     0.200
     0.740    14.092     0.200
     1.122    21.392     0.200
     1.449    27.392     0.200
     2.243    40.792     0.200
     2.552    46.592     0.200
     4.584    83.292     0.200
     6.361   115.392     0.200
     0.764    14.828     0.200
     1.152    22.328     0.200
     2.229    41.527     0.200
     2.198    40.930     0.200
     2.593    47.328     0.200
     3.949    72.129     0.200
     0.689    13.359     0.200
     1.122    20.959     0.200
     1.415    26.561     0.200
     2.223    40.660     0.200
     2.275    42.359     0.200
     2.529    45.859     0.200
     3.657    66.859     0.200
     0.679    13.066     0.200
     1.124    20.668     0.200
     1.408    26.270     0.200
     2.218    41.668     0.200
     2.280    41.969     0.200
     2.526    45.867     0.200
     4.019    72.668     0.200
     0.698    13.547     0.200
     1.118    21.047     0.200
     1.423    26.945     0.200
     2.272    42.547     0.200
     2.229    40.844     0.200
     2.229    41.750     0.200
     2.529    46.344     0.200
     3.652    66.445     0.200
     3.959    72.047     0.200
     4.592    83.750     0.200
     6.466   117.648     0.200
     7.325   133.047     0.200
     0.690    13.305     0.200
     1.090    20.609     0.200
     1.435    26.805     0.200
     2.249    41.305     0.200
     2.304    42.609     0.200
     2.304    42.711     0.200
     2.285    41.711     0.200
     2.285    42.711     0.200
     2.497    45.305     0.200
     3.629    66.109     0.200
     3.943    71.805     0.200
     4.050    72.805     0.200
     4.570    82.906     0.200
     5.136    93.305     0.200
     0.721    13.980     0.200
     1.122    21.281     0.200
     1.436    27.184     0.200
     2.235    41.383     0.200
     2.252    42.480     0.200
     2.306    43.082     0.200
     2.545    46.281     0.200
     3.649    66.684     0.200
     4.036    72.980     0.200
     0.710    13.773     0.200
     1.103    20.773     0.200
     1.440    27.273     0.200
     2.246    41.773     0.200
     2.292    42.469     0.200
     2.277    42.469     0.200
     2.520    46.070     0.200
     3.942    71.969     0.200
     4.047    73.469     0.200
     5.131    93.375     0.200
     6.365   115.469     0.200
     0.696    13.500     0.200
     0.696    13.398     0.200
     1.102    20.500     0.200
     1.102    20.398     0.200
     1.431    26.602     0.200
     2.289    42.000     0.200
     2.294    42.297     0.200
     2.242    39.797     0.200
     2.242    41.297     0.200
     2.511    45.602     0.200
     2.511    45.102     0.200
     3.638    66.195     0.200
     3.638    65.898     0.200
     6.372   115.602     0.200
     0.708    13.781     0.200
     1.111    21.680     0.200
     1.434    26.875     0.200
     2.239    40.680     0.200
     2.300    42.875     0.200
     2.271    42.680     0.200
     2.527    46.078     0.200
     3.949    72.078     0.200
     4.584    83.578     0.200
     6.371   115.578     0.200
     0.714    13.844     0.200
     1.100    20.648     0.200
     1.444    26.844     0.200
     2.250    40.742     0.200
     2.250    41.547     0.200
     2.288    42.742     0.200
     2.277    42.344     0.200
     2.519    45.844     0.200
     3.632    66.242     0.200
     0.701    13.496     0.200
     0.701    13.598     0.200
     1.108    20.697     0.200
     1.431    26.797     0.200
     2.279    42.396     0.200
     2.279    42.197     0.200
     2.239    41.496     0.200
     2.298    42.896     0.200
     2.520    45.896     0.200
     3.642    66.396     0.200
     4.583    83.297     0.200
     0.712    13.833     0.200
     1.099    20.732     0.200
     1.443    26.933     0.200
     2.250    41.433     0.200
     2.279    42.232     0.200
     2.517    45.933     0.200
     3.631    66.333     0.200
     4.051    73.632     0.200
     0.706    13.660     0.200
     1.106    20.660     0.200
     1.435    26.859     0.200
     2.242    40.859     0.200
     2.278    42.160     0.200
     2.295    42.660     0.200
     2.520    45.760     0.200
     4.043    72.859     0.200
     0.667    12.977     0.200
     1.123    21.180     0.200
     1.400    26.477     0.200
     2.214    40.477     0.200
     2.289    42.879     0.200
     2.321    43.078     0.200
     2.519    46.180     0.200
     4.014    73.078     0.200
     0.713    13.789     0.200
     1.096    20.992     0.200
     1.446    27.086     0.200
     2.253    41.789     0.200
     2.285    42.789     0.200
     2.282    42.688     0.200
     3.935    71.891     0.200
     4.569    83.188     0.200
     0.700    13.458     0.200
     1.108    20.658     0.200
     1.431    26.858     0.200
     2.298    42.758     0.200
     2.280    42.558     0.200
     2.280    41.858     0.200
     2.239    41.458     0.200
     2.519    46.158     0.200
     3.642    66.358     0.200
     0.710    13.664     0.200
     1.103    20.863     0.200
     1.440    27.063     0.200
     2.246    42.464     0.200
     2.291    42.863     0.200
     2.278    42.464     0.200
     3.942    71.764     0.200
     4.048    73.863     0.200
     0.720    13.967     0.200
     1.102    21.066     0.200
     1.447    27.066     0.200
     2.251    41.668     0.200
     2.288    42.367     0.200
     2.272    42.566     0.200
     2.523    46.168     0.200
     3.631    66.367     0.200
     4.572    83.268     0.200
     0.708    13.742     0.200
     1.103    20.742     0.200
     1.439    27.141     0.200
     2.245    40.941     0.200
     2.292    43.340     0.200
     2.279    42.641     0.200
     2.519    45.840     0.200
     3.314    60.043     0.200
     3.636    66.242     0.200
     3.943    72.043     0.200
     4.047    73.641     0.200
     6.365   115.742     0.200
     0.696    13.498     0.200
     1.091    20.498     0.200
     1.438    26.797     0.200
     2.251    41.697     0.200
     2.284    42.898     0.200
     2.300    42.898     0.200
     2.399    44.297     0.200
     2.500    45.598     0.200
     6.595   119.697     0.200
     0.700    13.438     0.200
     0.700    13.637     0.200
     1.090    20.537     0.200
     1.090    20.738     0.200
     1.441    26.938     0.200
     2.282    42.637     0.200
     2.297    42.738     0.200
     2.297    42.637     0.200
     2.396    44.137     0.200
     2.396    44.238     0.200
     2.253    41.037     0.200
     2.501    45.338     0.200
     2.501    45.738     0.200
     3.626    65.738     0.200
     4.054    73.438     0.200
     4.567    83.238     0.200
     5.129    92.238     0.200
     6.358   115.137     0.200
     7.323   132.137     0.200
     0.685    13.215     0.200
     1.090    20.314     0.200
     1.432    26.715     0.200
     2.248    40.814     0.200
     2.286    42.516     0.200
     2.308    42.615     0.200
     2.404    44.115     0.200
     2.493    45.016     0.200
     3.630    66.016     0.200
     4.571    83.115     0.200
     0.673    13.039     0.200
     1.110    20.734     0.200
     1.411    26.234     0.200
     2.226    40.539     0.200
     2.298    42.234     0.200
     2.308    42.734     0.200
     2.509    45.336     0.200
     4.027    73.234     0.200
     0.217     4.652     0.200
     0.951    18.055     0.200
     1.452    26.953     0.200
     1.853    33.953     0.200
     2.451    44.855     0.200
     2.451    44.754     0.200
     2.599    46.953     0.200
     3.630    65.953     0.200
     3.697    67.152     0.200
     4.039    73.055     0.200
     4.974    89.855     0.200
     5.911   106.953     0.200
     0.697    13.523     0.200
     1.103    20.820     0.200
     1.431    26.922     0.200
     2.241    41.523     0.200
     2.295    42.820     0.200
     2.287    42.922     0.200
     2.514    45.922     0.200
     3.317    60.523     0.200
     3.639    66.320     0.200
     4.042    73.117     0.200
     4.580    83.523     0.200
     0.353     7.184     0.200
     1.252    23.086     0.200
     2.045    37.387     0.200
     2.452    44.586     0.200
     2.477    44.586     0.200
     2.494    45.387     0.200
     0.650    12.703     0.200
     1.142    21.305     0.200
     1.378    25.805     0.200
     2.192    39.805     0.200
     2.285    42.203     0.200
     2.341    43.203     0.200
     2.530    46.102     0.200
     3.685    67.102     0.200
     3.993    71.703     0.200
     4.626    84.102     0.200
     0.666    12.845     0.200
     1.378    25.845     0.200
     2.184    39.645     0.200
     2.259    42.345     0.200
     2.554    46.245     0.200
     3.985    72.145     0.200
     4.004    72.945     0.200
     5.192    94.545     0.200
     6.511   117.945     0.200
     0.224     4.664     0.200
     1.443    27.066     0.200
     1.861    33.965     0.200
     2.448    44.766     0.200
     2.595    46.867     0.200
     3.639    65.664     0.200
     3.689    66.965     0.200
     4.030    72.664     0.200
     4.965    89.664     0.200
     0.633    12.305     0.200
     1.196    22.404     0.200
     1.332    25.104     0.200
     2.140    39.004     0.200
     2.250    42.004     0.200
     2.395    44.305     0.200
     2.509    46.104     0.200
     2.576    46.805     0.200
     3.739    67.604     0.200
     6.473   117.705     0.200
     0.660    12.801     0.200
     1.125    20.801     0.200
     1.395    26.001     0.200
     2.293    42.401     0.200
     2.324    43.001     0.200
     2.210    41.101     0.200
     2.442    44.601     0.200
     2.518    45.901     0.200
     3.344    60.801     0.200
     3.668    66.501     0.200
     3.983    72.601     0.200
     4.949    90.001     0.200
     6.407   116.401     0.200
     0.676    13.180     0.200
     1.120    20.879     0.200
     2.315    42.680     0.200
     2.286    42.277     0.200
     2.220    39.977     0.200
     2.430    44.578     0.200
     2.520    45.578     0.200
     3.659    66.180     0.200
     4.020    72.277     0.200
     4.600    83.277     0.200
     6.006   108.777     0.200
     7.161   129.578     0.200
     0.695    13.492     0.200
     1.111    20.992     0.200
     1.425    26.793     0.200
     2.234    40.793     0.200
     2.281    42.793     0.200
     2.303    43.191     0.200
     2.414    44.590     0.200
     2.520    45.891     0.200
     3.646    66.391     0.200
     4.035    73.590     0.200
     1.533    28.207     0.200
     1.533    29.004     0.200
     1.774    32.605     0.200
     2.199    40.906     0.200
     2.792    50.406     0.200
     2.884    52.605     0.200
     3.572    64.305     0.200
     0.662    12.772     0.200
     1.112    20.572     0.200
     1.112    20.472     0.200
     2.221    40.372     0.200
     2.304    42.572     0.200
     2.304    42.172     0.200
     2.312    42.772     0.200
     2.505    45.472     0.200
     3.332    60.672     0.200
     4.021    72.472     0.200
     3.973    71.672     0.200
     5.168    93.272     0.200
     6.397   115.472     0.200
     6.484   117.572     0.200
     0.669    12.918     0.200
     1.091    20.117     0.200
     1.421    26.316     0.200
     2.241    41.020     0.200
     2.291    42.316     0.200
     2.486    44.918     0.200
     3.635    66.219     0.200
     3.955    71.816     0.200
     5.151    93.520     0.200
     0.710    13.723     0.200
     1.091    20.522     0.200
     1.447    26.923     0.200
     2.256    41.522     0.200
     2.281    42.223     0.200
     2.289    42.323     0.200
     2.507    45.623     0.200
     0.229     4.758     0.200
     0.964    18.156     0.200
     1.441    27.156     0.200
     1.862    34.258     0.200
     2.443    44.953     0.200
     2.596    47.156     0.200
     0.232     4.824     0.200
     0.962    18.223     0.200
     1.444    27.121     0.200
     2.440    44.922     0.200
     2.600    47.121     0.200
     3.689    66.922     0.200
     4.030    73.324     0.200
     4.409    80.023     0.200
     6.838   124.023     0.200
     0.688    13.385     0.200
     1.104    20.584     0.200
     1.425    26.785     0.200
     2.293    42.484     0.200
     2.298    42.686     0.200
     2.298    42.984     0.200
     2.412    44.285     0.200
     2.509    45.584     0.200
     2.509    45.385     0.200
     3.642    66.084     0.200
     3.954    72.084     0.200
     4.921    88.285     0.200
     6.377   115.785     0.200
     7.335   132.484     0.200
     0.948    18.119     0.200
     1.450    27.119     0.200
     2.138    39.119     0.200
     2.200    41.119     0.200
     2.429    44.820     0.200
     2.723    49.920     0.200
     3.535    64.420     0.200
     3.958    72.020     0.200
     7.469   135.221     0.200
     0.546    10.613     0.200
     0.933    17.613     0.200
     1.464    27.213     0.200
     2.185    40.713     0.200
     2.136    38.914     0.200
     2.136    38.613     0.200
     2.412    44.713     0.200
     2.412    44.414     0.200
     2.381    42.814     0.200
     2.381    43.613     0.200
     2.718    49.613     0.200
     3.521    63.914     0.200
     3.941    71.064     0.200
     4.453    80.814     0.200
     5.197    94.314     0.200
     6.477   116.914     0.200
     0.531    10.309     0.200
     0.947    17.908     0.200
     1.451    27.008     0.200
     2.140    39.008     0.200
     2.199    40.908     0.200
     2.369    42.809     0.200
     2.427    44.408     0.200
     2.720    49.809     0.200
     3.956    72.107     0.200
     6.386   115.607     0.200
     0.543    10.494     0.200
     0.935    17.594     0.200
     0.935    17.795     0.200
     2.132    38.494     0.200
     2.132    38.193     0.200
     2.381    42.795     0.200
     2.415    44.594     0.200
     2.724    49.895     0.200
     3.522    63.594     0.200
     3.944    71.895     0.200
     4.454    80.594     0.200
     0.547    10.672     0.200
     0.935    17.867     0.200
     1.462    27.273     0.200
     2.149    39.172     0.200
     2.186    41.070     0.200
     2.376    43.570     0.200
     2.409    44.570     0.200
     2.701    49.367     0.200
     3.178    58.070     0.200
     3.939    71.867     0.200
     6.369   114.969     0.200
     0.546    10.609     0.200
     0.932    17.906     0.200
     1.466    27.312     0.200
     2.129    39.109     0.200
     2.184    40.711     0.200
     2.384    43.211     0.200
     2.413    44.508     0.200
     2.726    49.812     0.200
     3.520    64.109     0.200
     3.934    71.258     0.200
     4.451    81.109     0.200
     6.032   109.211     0.200
     6.401   116.312     0.200
     0.551    10.626     0.200
     0.930    17.526     0.200
     1.467    27.326     0.200
     2.181    40.026     0.200
     2.143    39.226     0.200
     2.405    44.126     0.200
     2.381    42.826     0.200
     2.706    49.326     0.200
     3.952    70.683     0.200
     4.156    74.626     0.200
     4.450    80.826     0.200
     0.215     4.533     0.200
     0.941    17.635     0.200
     1.463    27.234     0.200
     1.843    33.635     0.200
     2.450    44.934     0.200
     2.607    47.033     0.200
     2.709    49.334     0.200
     6.860   124.334     0.200
     0.720    13.930     0.200
     1.101    21.023     0.200
     2.252    41.125     0.200
     2.287    43.125     0.200
     2.273    42.828     0.200
     2.394    44.727     0.200
     2.522    46.125     0.200
     3.935    71.625     0.200
     4.054    73.930     0.200
     4.571    83.328     0.200
     6.357   115.227     0.200
     0.696    13.418     0.200
     1.091    20.617     0.200
     2.250    41.219     0.200
     2.298    42.520     0.200
     2.285    42.816     0.200
     2.399    44.117     0.200
     2.501    45.617     0.200
     3.629    66.316     0.200
     4.051    73.816     0.200
     4.355    78.316     0.200
     1.055    19.625     0.200
     2.242    41.426     0.200
     2.352    43.026     0.200
     2.306    42.226     0.200
     2.296    40.826     0.200
     2.482    45.026     0.200
     3.585    64.726     0.200
     3.894    70.826     0.200
     4.097    74.326     0.200
     4.347    78.526     0.200
     0.897    17.039     0.200
     1.026    19.836     0.200
     2.073    38.836     0.200
     2.318    43.133     0.200
     2.441    44.633     0.200
     0.324     6.605     0.200
     1.098    20.805     0.200
     1.318    24.506     0.200
     1.980    36.404     0.200
     2.423    44.305     0.200
     2.532    45.705     0.200
     2.731    49.705     0.200
     3.765    67.805     0.200
     3.901    70.705     0.200
     0.707    13.770     0.200
     0.995    18.871     0.200
     1.499    27.770     0.200
     2.332    42.168     0.200
     2.198    40.371     0.200
     2.390    43.770     0.200
     2.401    43.570     0.200
     2.330    42.969     0.200
     4.131    74.570     0.200
     4.908    88.871     0.200
     5.077    91.570     0.200
     6.297   114.168     0.200
     0.633    12.476     0.200
     0.633    12.176     0.200
     1.081    20.376     0.200
     2.239    40.576     0.200
     2.291    42.376     0.200
     2.291    42.576     0.200
     2.358    43.776     0.200
     2.358    43.576     0.200
     2.425    44.676     0.200
     2.456    44.676     0.200
     3.308    60.076     0.200
     3.635    65.676     0.200
     3.635    65.876     0.200
     3.966    72.276     0.200
     4.037    73.276     0.200
     5.169    93.776     0.200
     6.011   109.076     0.200
     6.392   115.576     0.200
     6.397   116.176     0.200
     8.380   149.976     0.200
     0.591    11.797     0.200
     0.591    11.695     0.200
     0.889    16.797     0.200
     0.889    16.695     0.200
     2.110    38.496     0.200
     2.140    39.297     0.200
     2.140    39.598     0.200
     2.423    43.098     0.200
     2.367    43.195     0.200
     2.727    48.996     0.200
     3.131    56.695     0.200
     3.477    62.996     0.200
     4.198    75.898     0.200
     5.151    93.098     0.200
     0.954    18.684     0.200
     1.163    21.785     0.200
     1.900    35.684     0.200
     2.186    39.785     0.200
     6.144   110.984     0.200
     1.095    20.465     0.200
     1.444    26.863     0.200
     2.252    40.766     0.200
     2.287    42.363     0.200
     2.396    44.066     0.200
     3.628    66.066     0.200
     0.552    10.844     0.200
     1.461    27.344     0.200
     2.166    39.246     0.200
     2.186    40.844     0.200
     2.371    43.445     0.200
     2.403    44.445     0.200
     3.524    64.246     0.200
     0.869    16.945     0.200
     0.930    17.250     0.200
     1.642    30.047     0.200
     2.094    39.148     0.200
     2.352    43.250     0.200
     2.413    43.250     0.200
     2.449    44.250     0.200
     3.437    62.344     0.200
     4.251    76.945     0.200
     4.929    89.547     0.200
     0.868    16.770     0.200
     0.938    17.770     0.200
     1.637    30.672     0.200
     2.102    39.371     0.200
     2.202    40.871     0.200
     2.344    43.473     0.200
     2.421    43.871     0.200
     2.442    44.871     0.200
     0.866    16.668     0.200
     0.929    17.766     0.200
     1.640    30.668     0.200
     2.095    39.367     0.200
     2.197    40.766     0.200
     2.410    43.766     0.200
     2.355    43.668     0.200
     2.448    45.066     0.200
     3.437    62.566     0.200
     4.307    78.566     0.200
     0.917    17.676     0.200
     0.884    17.074     0.200
     2.179    40.676     0.200
     2.406    43.875     0.200
     0.883    17.070     0.200
     0.917    17.570     0.200
     2.180    40.977     0.200
     2.406    43.672     0.200
     0.883    16.953     0.200
     0.933    17.750     0.200
     1.650    30.953     0.200
     2.189    40.648     0.200
     2.422    44.250     0.200
     8.634   152.992     0.200
     0.878    16.936     0.200
     0.913    17.736     0.200
     2.077    38.836     0.200
     2.180    40.635     0.200
     2.399    43.936     0.200
     2.365    43.936     0.200
     0.856    16.732     0.200
     0.935    17.533     0.200
     2.104    39.533     0.200
     2.208    41.133     0.200
     2.413    43.732     0.200
     2.353    43.732     0.200
     2.438    45.434     0.200
     4.308    77.908     0.200
     8.608   152.625     0.200
     0.855    16.514     0.200
     0.942    17.814     0.200
     2.212    41.113     0.200
     2.420    43.914     0.200
     2.346    43.613     0.200
     4.760    85.814     0.200
     0.945    17.652     0.200
     1.647    30.752     0.200
     2.101    39.852     0.200
     2.195    40.652     0.200
     2.447    45.252     0.200
     7.148   128.752     0.200
     1.502    28.649     0.200
     3.214    58.050     0.200
     4.288    76.074     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
    16.142   391.320     0.200
    16.142   394.820     0.200
    18.687   465.719     0.200
    22.006   548.117     0.200
    18.567   459.926     0.200
    15.943   391.281     0.200
    18.531   458.281     0.200
     2.566    73.723     0.200
     3.781   101.121     0.200
     1.863    59.680     0.200
     3.133    89.680     0.200
     4.401   118.680     0.200
     4.818   130.883     0.200
     4.870   130.680     0.200
     5.635   144.680     0.200
     7.293   188.180     0.200
     5.019   132.168     0.200
     5.279   143.367     0.200
     5.461   143.668     0.200
     6.112   159.867     0.200
     7.579   193.168     0.200
     7.792   202.168     0.200
     8.142   207.168     0.200
    15.928   391.668     0.200
     2.197    64.762     0.200
     2.701    77.762     0.200
     3.131    83.762     0.200
     3.933   107.762     0.200
     4.874   132.363     0.200
     5.007   136.562     0.200
     5.132   138.762     0.200
     5.432   143.062     0.200
     6.090   157.562     0.200
     7.533   193.062     0.200
     1.455    47.762     0.200
     1.645    52.762     0.200
     1.708    53.863     0.200
     2.249    65.461     0.200
     3.971   108.062     0.200
     3.073    83.594     0.200
     5.400   140.594     0.200
    17.487   438.594     0.200
    18.892   467.594     0.200
     2.676    77.547     0.200
     3.647   101.047     0.200
     4.557   120.848     0.200
     5.473   142.547     0.200
     5.612   147.348     0.200
     7.920   199.047     0.200
     5.313   140.172     0.200
     7.087   180.875     0.200
     7.728   196.070     0.200
     7.786   199.172     0.200
    10.706   267.273     0.200
    12.147   301.969     0.200
    14.183   347.570     0.200
    15.269   369.672     0.200
    15.275   377.172     0.200
    16.663   414.672     0.200
    20.985   520.672     0.200
     5.449   142.867     0.200
     2.453    70.320     0.200
     2.574    74.625     0.200
     4.222   113.219     0.200
     5.487   144.582     0.200
     2.572    72.469     0.200
     3.838   101.668     0.200
     5.286   140.367     0.200
     3.857   102.708     0.200
     2.453    70.688     0.200
     4.228   113.688     0.200
     4.780   129.787     0.200
     2.679    73.672     0.200
     3.835   104.570     0.200
     4.793   126.417     0.200
     2.696    76.568     0.200
     1.209    42.125     0.200
     1.792    56.125     0.200
     1.792    56.824     0.200
     1.811    57.625     0.200
     2.574    74.625     0.200
     3.979   107.727     0.200
     4.489   121.125     0.200
     5.329   142.414     0.200
     6.053   155.914     0.200
     7.744   198.016     0.200
     9.136   230.516     0.200
     9.136   233.516     0.200
    10.262   260.016     0.200
    13.718   344.516     0.200
    20.467   508.516     0.200
     2.526    72.023     0.200
     3.827   101.125     0.200
     5.309   138.422     0.200
     7.726   196.328     0.200
     2.524    71.289     0.200
     3.818   100.992     0.200
     4.753   126.992     0.200
     5.299   139.492     0.200
     5.439   142.992     0.200
     3.857   105.754     0.200
     2.635    76.055     0.200
     2.505    73.110     0.200
     2.810    77.610     0.200
     3.956   108.610     0.200
     4.348   116.711     0.200
     4.891   126.811     0.200
     5.407   140.910     0.200
     5.577   145.211     0.200
     7.819   203.811     0.200
     9.227   236.011     0.200
     1.259    42.650     0.200
     2.442    70.250     0.200
     2.513    71.350     0.200
     5.515   147.508     0.200
     7.759   198.609     0.200
     1.742    56.441     0.200
     1.731    55.441     0.200
     2.633    76.441     0.200
     4.919   132.605     0.200
     2.866    78.182     0.200
     3.233    87.281     0.200
     3.953   104.481     0.200
     4.755   127.081     0.200
     5.933   153.581     0.200
     6.023   156.781     0.200
     9.635   244.581     0.200
    11.755   291.781     0.200
     2.665    74.641     0.200
     2.692    78.539     0.200
     3.911   106.641     0.200
     4.234   114.539     0.200
     4.852   129.539     0.200
     2.252    68.188     0.200
     2.341    68.984     0.200
     3.621    97.781     0.200
     4.562   122.781     0.200
     7.362   186.781     0.200
     2.439    71.516     0.200
     3.459    94.816     0.200
     4.400   121.719     0.200
     5.002   134.816     0.200
     2.304    66.125     0.200
     2.467    70.824     0.200
     3.402    93.426     0.200
     3.735    98.523     0.200
     4.092   109.625     0.200
     4.829   129.223     0.200
     4.948   130.824     0.200
     6.162   159.426     0.200
     7.266   187.324     0.200
     2.139    62.727     0.200
     2.333    66.031     0.200
     2.430    69.727     0.200
     3.365    92.328     0.200
     4.307   115.328     0.200
     4.747   125.727     0.200
     4.883   131.430     0.200
     7.171   184.625     0.200
     2.111    61.406     0.200
     2.351    66.805     0.200
     2.409    70.406     0.200
     3.348    91.109     0.200
     4.290   113.906     0.200
     4.702   129.406     0.200
     4.849   129.703     0.200
     2.297    68.672     0.200
     2.353    70.072     0.200
     3.551    97.271     0.200
     3.894   107.271     0.200
     4.492   121.271     0.200
     6.321   165.871     0.200
     8.417   215.771     0.200
    18.236   457.471     0.200
     1.415    45.914     0.200
     2.717    76.117     0.200
     4.906   130.516     0.200
     5.449   144.516     0.200
    10.734   274.117     0.200
     1.675    51.912     0.200
     2.838    80.912     0.200
     5.169   136.612     0.200
     2.210    64.961     0.200
     2.652    75.367     0.200
     3.850   105.367     0.200
     4.162   112.164     0.200
     5.062   134.867     0.200
     1.684    52.605     0.200
     1.685    53.805     0.200
     2.304    68.305     0.200
     2.842    78.906     0.200
     3.081    84.906     0.200
     4.267   116.004     0.200
     4.267   116.305     0.200
     4.622   124.504     0.200
     5.164   135.105     0.200
     5.667   148.906     0.200
     5.823   152.605     0.200
     7.049   181.605     0.200
     2.564    76.041     0.200
     3.570    97.840     0.200
     3.953   106.840     0.200
     5.802   151.340     0.200
     1.747    55.165     0.200
     2.597    73.565     0.200
     2.825    79.965     0.200
     3.252    89.765     0.200
     4.777   127.065     0.200
     5.426   137.865     0.200
     2.183    64.047     0.200
     2.778    77.645     0.200
     5.000   131.246     0.200
     2.858    81.902     0.200
     3.254    90.102     0.200
     3.254    89.303     0.200
     4.756   123.102     0.200
     5.180   138.602     0.200
     5.295   139.102     0.200
     6.375   164.602     0.200
     7.542   192.391     0.200
     7.606   195.902     0.200
     8.344   212.102     0.200
     9.978   252.102     0.200
    11.186   283.002     0.200
     2.663    76.776     0.200
     2.895    83.776     0.200
     3.444    93.577     0.200
     4.722   123.377     0.200
     2.859    83.516     0.200
     3.406    93.617     0.200
     3.662    99.516     0.200
     3.919   105.617     0.200
     4.343   116.816     0.200
     5.144   137.617     0.200
     5.459   143.617     0.200
     5.931   157.117     0.200
     7.258   184.117     0.200
     3.313    92.472     0.200
     4.529   122.672     0.200
     4.510   120.572     0.200
     4.685   127.172     0.200
     6.944   180.172     0.200
     3.225    90.066     0.200
     3.595    98.465     0.200
     4.826   124.465     0.200
     2.749    74.961     0.200
     3.958   104.266     0.200
     4.304   113.664     0.200
     4.706   124.664     0.200
     5.250   134.062     0.200
     1.884    59.875     0.200
     1.712    54.711     0.200
     1.964    62.812     0.200
     2.990    82.914     0.200
     3.028    83.414     0.200
     4.249   115.812     0.200
     4.527   122.914     0.200
     3.527    96.117     0.200
     4.025   108.617     0.200
     4.388   116.219     0.200
     4.533   120.320     0.200
     4.853   129.219     0.200
     5.046   133.922     0.200
     6.474   171.719     0.200
     6.725   174.023     0.200
     7.434   192.023     0.200
     7.754   195.820     0.200
     8.956   227.219     0.200
     2.259    65.891     0.200
     2.259    66.289     0.200
     3.645    98.086     0.200
     3.947   108.586     0.200
     3.947   107.289     0.200
     4.587   123.391     0.200
     4.891   132.086     0.200
     6.369   164.289     0.200
     7.134   185.492     0.200
     7.304   189.188     0.200
     1.637    52.207     0.200
     2.792    78.809     0.200
     2.878    82.008     0.200
     3.354    92.508     0.200
     3.729   102.508     0.200
     3.883   105.109     0.200
     4.582   124.207     0.200
     5.717   149.508     0.200
     5.787   152.207     0.200
     7.663   195.410     0.200
     1.642    52.719     0.200
     2.313    68.520     0.200
     2.806    79.319     0.200
     3.039    84.719     0.200
     4.580   122.719     0.200
     5.162   135.020     0.200
     5.703   149.219     0.200
     7.006   179.919     0.200
     7.880   200.919     0.200
     2.396    69.738     0.200
     2.530    72.738     0.200
     5.372   142.039     0.200
     2.292    66.813     0.200
     2.592    75.113     0.200
     3.829   104.214     0.200
     2.505    71.516     0.200
     2.499    72.812     0.200
     2.499    72.609     0.200
     3.596   100.414     0.200
     3.733   104.711     0.200
     3.938   107.211     0.200
     3.938   106.516     0.200
     4.327   116.312     0.200
     5.556   146.609     0.200
     2.454    71.418     0.200
     2.499    70.820     0.200
     3.840   105.621     0.200
     4.092   112.320     0.200
     4.222   115.121     0.200
     5.291   140.320     0.200
     5.449   144.520     0.200
     6.064   155.418     0.200
     7.462   189.219     0.200
     7.761   199.418     0.200
     8.069   203.488     0.200
    11.292   286.098     0.200
     2.505    73.012     0.200
     3.826   105.012     0.200
     3.843   105.312     0.200
     4.229   114.113     0.200
     4.229   113.211     0.200
     5.306   142.312     0.200
     5.306   142.512     0.200
     5.458   144.012     0.200
     6.658   172.812     0.200
     1.261    42.992     0.200
     2.452    68.891     0.200
     2.499    73.191     0.200
     3.507    98.191     0.200
     3.821   104.391     0.200
     4.233   113.789     0.200
     5.462   145.891     0.200
     1.159    40.073     0.200
     2.473    71.373     0.200
     2.535    72.073     0.200
     5.096   134.973     0.200
     5.606   146.573     0.200
     7.294   185.973     0.200
     2.462    71.082     0.200
     3.823   101.082     0.200
     4.225   115.182     0.200
     5.568   144.282     0.200
     2.481    72.550     0.200
     3.821   105.250     0.200
     5.586   144.250     0.200
     2.462    69.465     0.200
     2.626    75.865     0.200
     3.797   101.865     0.200
     4.166   111.965     0.200
     2.477    73.026     0.200
     2.646    77.127     0.200
     3.807   104.126     0.200
     3.807   103.927     0.200
     4.110   111.126     0.200
     4.110   112.228     0.200
     4.184   111.327     0.200
     5.409   143.228     0.200
     5.593   143.927     0.200
     6.078   158.228     0.200
     6.613   169.927     0.200
     8.111   208.927     0.200
     1.277    42.887     0.200
     2.450    69.785     0.200
     7.751   197.387     0.200
     8.026   201.785     0.200
     1.257    43.648     0.200
     2.452    71.750     0.200
     2.495    72.750     0.200
     4.092   112.445     0.200
     4.227   113.648     0.200
     7.714   199.547     0.200
     7.714   199.445     0.200
     1.246    43.109     0.200
     2.500    72.537     0.200
     4.097   111.838     0.200
     5.299   142.738     0.200
     5.453   145.138     0.200
     7.764   201.238     0.200
     8.062   205.338     0.200
    15.749   385.938     0.200
    18.256   449.537     0.200
     1.238    42.020     0.200
     5.277   138.719     0.200
     5.432   145.117     0.200
     8.084   207.117     0.200
     2.451    70.344     0.200
     4.214   112.242     0.200
     2.167    64.562     0.200
     2.696    76.961     0.200
     3.881   105.461     0.200
     4.184   113.562     0.200
     5.433   141.792     0.200
     8.157   208.092     0.200
     3.837   102.043     0.200
     3.832   104.641     0.200
     3.832   103.242     0.200
     4.105   110.242     0.200
     4.217   110.043     0.200
     5.446   142.543     0.200
     7.459   187.742     0.200
     4.202   112.756     0.200
     1.411    48.273     0.200
     4.172   115.273     0.200
     1.286    44.118     0.200
     2.719    77.419     0.200
     1.630    52.066     0.200
     2.320    68.266     0.200
     1.633    52.207     0.200
     1.633    51.707     0.200
     2.311    68.707     0.200
     3.723   103.305     0.200
     3.723   103.504     0.200
     4.215   114.805     0.200
     5.153   135.105     0.200
     1.283    44.391     0.200
     1.708    54.688     0.200
     2.951    83.391     0.200
     3.249    90.086     0.200
     6.252   162.289     0.200
     6.876   177.586     0.200
     3.021    85.492     0.200
     3.463    95.391     0.200
     3.739   103.195     0.200
     4.204   113.094     0.200
     5.141   135.391     0.200
     5.225   137.094     0.200
     5.766   154.695     0.200
     6.989   179.594     0.200
     2.590    75.000     0.200
     4.771   127.602     0.200
     5.178   139.801     0.200
     1.331    45.469     0.200
     2.478    72.062     0.200
     3.816   103.164     0.200
     3.816   104.766     0.200
     4.759   127.164     0.200
     5.403   137.164     0.200
     3.819   104.680     0.200
     3.900   109.883     0.200
     5.400   140.781     0.200
    10.501   266.578     0.200
     3.560    98.418     0.200
     3.892   107.418     0.200
     4.929   131.418     0.200
     7.349   187.418     0.200
     3.563    97.990     0.200
     3.897   104.990     0.200
     7.356   189.390     0.200
     2.209    64.180     0.200
     2.390    70.477     0.200
     2.389    71.055     0.200
     4.923   132.656     0.200
     2.204    65.922     0.200
     2.204    65.324     0.200
     3.635   100.125     0.200
     4.057   111.223     0.200
     4.566   124.125     0.200
     3.562    98.016     0.200
     4.503   121.719     0.200
     4.935   132.516     0.200
     7.354   191.016     0.200
    10.787   275.617     0.200
     1.648    53.312     0.200
     1.648    52.914     0.200
     1.650    52.109     0.200
     3.045    85.508     0.200
     3.436    98.211     0.200
     3.710   101.914     0.200
     4.141   112.414     0.200
     4.231   115.008     0.200
     6.755   175.508     0.200
     7.819   197.914     0.200
     1.517    48.523     0.200
     1.517    48.422     0.200
     2.494    71.328     0.200
     2.698    76.422     0.200
     2.698    77.328     0.200
     2.769    78.922     0.200
     2.769    79.727     0.200
     3.005    85.727     0.200
     3.606    99.023     0.200
     3.745   102.828     0.200
     4.141   110.828     0.200
     4.098   109.625     0.200
     4.535   122.828     0.200
     5.787   153.422     0.200
     7.696   193.422     0.200
     7.696   194.898     0.200
     7.749   200.625     0.200
    10.063   255.422     0.200
    11.073   282.328     0.200
     1.522    48.450     0.200
     1.522    50.750     0.200
     2.490    70.351     0.200
     2.711    77.650     0.200
     2.711    76.851     0.200
     3.605   100.650     0.200
     4.101   111.950     0.200
     1.004    36.439     0.200
     3.558    97.840     0.200
     4.499   121.939     0.200
     3.563    99.871     0.200
     3.800   107.070     0.200
     3.918   108.070     0.200
     3.885   106.570     0.200
     3.885   106.770     0.200
     5.043   135.270     0.200
     6.203   161.770     0.200
     6.603   169.971     0.200
     7.178   187.371     0.200
     8.271   211.871     0.200
     3.867   105.213     0.200
     3.867   104.014     0.200
     4.174   113.613     0.200
     5.422   138.014     0.200
     6.595   168.713     0.200
     2.536    74.461     0.200
     3.557    99.656     0.200
     3.804   107.055     0.200
     3.804   104.656     0.200
     3.927   108.555     0.200
     4.181   113.258     0.200
     4.181   113.461     0.200
     4.821   130.758     0.200
     4.821   130.461     0.200
     6.202   162.055     0.200
     6.601   170.055     0.200
     7.694   199.461     0.200
     8.266   210.758     0.200
    10.825   277.758     0.200
    11.106   280.734     0.200
     1.342    45.910     0.200
     2.540    74.312     0.200
     2.701    77.312     0.200
     3.800   102.812     0.200
     3.800   107.012     0.200
     3.884   106.312     0.200
     3.884   105.410     0.200
     3.923   107.512     0.200
     4.826   129.711     0.200
     5.399   138.812     0.200
     6.606   171.113     0.200
     1.347    45.705     0.200
     2.544    74.104     0.200
     2.706    76.404     0.200
     3.888   106.504     0.200
     3.888   104.205     0.200
     4.189   114.305     0.200
     4.830   128.205     0.200
     5.365   140.504     0.200
     6.210   162.004     0.200
     6.609   170.004     0.200
     6.609   170.205     0.200
     7.454   193.705     0.200
     7.702   200.104     0.200
     8.066   206.604     0.200
     8.261   210.205     0.200
     1.012    36.125     0.200
     1.454    47.023     0.200
     2.421    70.125     0.200
     3.572    97.727     0.200
     1.310    44.594     0.200
     2.465    72.594     0.200
     2.502    71.693     0.200
     3.773   104.394     0.200
     3.773   104.193     0.200
     3.800   105.793     0.200
     3.896   106.094     0.200
     4.275   116.094     0.200
     4.422   118.293     0.200
     7.059   185.193     0.200
     1.667    52.690     0.200
     2.022    59.190     0.200
     2.488    72.790     0.200
     5.908   151.990     0.200
     2.527    73.689     0.200
     3.871   105.489     0.200
     3.871   104.289     0.200
     4.176   113.389     0.200
     6.597   169.789     0.200
     2.434    71.070     0.200
     2.474    72.672     0.200
     2.645    75.969     0.200
     3.818   103.766     0.200
     5.565   140.367     0.200
     7.638   196.367     0.200
     2.421    71.293     0.200
     2.488    71.695     0.200
     2.639    75.895     0.200
     3.851   103.195     0.200
     3.865   106.293     0.200
     3.816   104.293     0.200
     4.525   120.695     0.200
     5.560   143.992     0.200
     6.041   157.895     0.200
     7.625   197.895     0.200
     2.427    71.617     0.200
     2.468    72.816     0.200
     2.481    71.816     0.200
     2.636    76.316     0.200
     3.812   103.617     0.200
     3.761   104.020     0.200
     3.870   105.219     0.200
     4.176   112.520     0.200
     4.749   129.020     0.200
     5.212   138.617     0.200
     7.382   189.188     0.200
     7.626   194.918     0.200
     7.626   197.816     0.200
     8.140   207.719     0.200
    10.682   272.816     0.200
    15.842   385.898     0.200
     2.438    71.445     0.200
     2.474    71.750     0.200
     2.468    72.648     0.200
     2.639    75.648     0.200
     2.639    77.047     0.200
     3.762   104.047     0.200
     3.872   106.148     0.200
     5.221   138.945     0.200
     5.398   143.648     0.200
     7.635   198.844     0.200
    10.686   270.750     0.200
     2.803    78.844     0.200
     3.530    97.539     0.200
     5.526   145.539     0.200
     6.371   165.242     0.200
     6.772   175.445     0.200
     8.121   206.641     0.200
     3.533    97.375     0.200
     3.783   102.969     0.200
     4.042   108.172     0.200
     4.984   132.273     0.200
     5.521   145.570     0.200
     8.128   206.570     0.200
     1.194    38.281     0.200
     2.667    76.383     0.200
     3.484    93.383     0.200
     3.203    89.582     0.200
     9.613   241.383     0.200
     1.210    39.688     0.200
     1.210    39.488     0.200
     2.913    82.188     0.200
     2.990    82.289     0.200
     3.273    90.789     0.200
     4.721   120.891     0.200
     5.254   139.188     0.200
     5.641   149.090     0.200
     9.651   242.789     0.200
     2.472    72.656     0.200
     2.493    72.156     0.200
     2.547    73.859     0.200
     2.730    78.359     0.200
     3.780   102.859     0.200
     3.808   103.258     0.200
     3.888   105.258     0.200
     3.888   105.953     0.200
     4.269   115.156     0.200
     5.533   140.359     0.200
     1.138    39.617     0.200
     1.779    55.617     0.200
     1.779    56.812     0.200
     1.779    57.312     0.200
     1.874    59.312     0.200
     3.118    87.617     0.200
     4.575   121.211     0.200
    10.207   257.812     0.200
     2.885    79.094     0.200
     3.099    85.391     0.200
     3.480    91.992     0.200
     3.759   100.492     0.200
     2.718    76.944     0.200
     3.242    89.145     0.200
     3.388    92.744     0.200
     3.862   104.444     0.200
     1.602    50.516     0.200
     1.602    51.116     0.200
     1.689    54.916     0.200
     2.681    75.416     0.200
     3.708   100.516     0.200
     3.811   104.816     0.200
     3.811   105.416     0.200
     4.002   109.316     0.200
     4.002   106.616     0.200
     4.183   112.016     0.200
     5.273   140.616     0.200
     6.572   170.716     0.200
     7.635   194.916     0.200
     7.927   201.316     0.200
    10.563   270.816     0.200
     1.589    51.109     0.200
     1.589    52.203     0.200
     2.300    68.109     0.200
     2.300    67.109     0.200
     2.776    77.906     0.200
     2.980    84.508     0.200
     3.403    94.203     0.200
     3.514    98.805     0.200
     3.753   103.406     0.200
     4.170   110.508     0.200
     4.522   121.609     0.200
     7.880   202.703     0.200
     8.432   214.508     0.200
    14.252   356.703     0.200
    15.739   385.430     0.200
    19.851   497.609     0.200
     1.557    48.664     0.200
     1.557    48.867     0.200
     3.598    96.367     0.200
     3.709   100.266     0.200
     4.094   107.570     0.200
     5.147   133.664     0.200
     8.149   207.023     0.200
    10.821   275.070     0.200
    12.763   318.469     0.200
     2.785    76.804     0.200
     3.508    94.904     0.200
     3.746   104.504     0.200
     5.231   135.604     0.200
     5.723   148.504     0.200
     2.847    80.695     0.200
     3.116    86.797     0.200
     3.116    83.895     0.200
     3.257    87.996     0.200
     3.710   100.297     0.200
     3.710   102.797     0.200
     9.988   253.297     0.200
     3.274    92.735     0.200
     4.704   125.635     0.200
     6.946   181.735     0.200
     2.786    79.082     0.200
     1.666    52.363     0.200
     1.666    54.461     0.200
     2.348    69.262     0.200
     2.805    79.762     0.200
     4.251   113.363     0.200
     4.615   124.863     0.200
     5.187   139.363     0.200
     1.626    51.160     0.200
     1.626    51.859     0.200
     2.349    69.160     0.200
     2.776    79.262     0.200
     3.485    96.961     0.200
     3.744   103.859     0.200
     4.211   112.461     0.200
     4.574   124.160     0.200
     1.625    51.840     0.200
     1.625    52.541     0.200
     2.344    69.141     0.200
     2.778    79.840     0.200
     3.743   103.740     0.200
     4.209   112.740     0.200
     4.572   122.340     0.200
     1.486    49.820     0.200
     2.204    64.422     0.200
     2.760    78.023     0.200
     3.621    98.922     0.200
     4.051   109.625     0.200
     4.051   109.422     0.200
     4.991   133.320     0.200
     5.288   134.422     0.200
     5.562   146.922     0.200
     6.405   166.922     0.200
     6.798   177.422     0.200
     3.724   100.990     0.200
     4.053   108.990     0.200
     4.380   117.891     0.200
     4.994   132.391     0.200
     6.411   166.791     0.200
     6.803   177.291     0.200
     1.939    60.783     0.200
     2.708    77.082     0.200
     2.710    78.283     0.200
     3.938   107.482     0.200
     4.251   116.783     0.200
     1.748    55.641     0.200
     2.260    66.641     0.200
     2.772    77.641     0.200
     3.541    98.039     0.200
     3.769   101.836     0.200
     2.755    79.180     0.200
     2.790    79.180     0.200
     4.295   115.781     0.200
     5.467   143.883     0.200
     3.991   101.602     0.200
     3.991   111.000     0.200
     4.129   113.703     0.200
     4.195   113.801     0.200
    10.445   267.203     0.200
     2.256    67.484     0.200
     3.645    99.785     0.200
     4.012   110.984     0.200
     4.587   124.383     0.200
     4.889   129.383     0.200
     5.615   144.285     0.200
    10.418   266.184     0.200
     2.450    69.781     0.200
     2.498    72.082     0.200
     3.843   106.281     0.200
     4.227   115.082     0.200
     1.751    55.701     0.200
     2.288    68.001     0.200
     2.753    79.001     0.200
     2.931    84.201     0.200
     3.542    99.101     0.200
     3.542    98.101     0.200
     3.555    97.501     0.200
     3.784   104.101     0.200
     4.258   115.201     0.200
     4.472   120.801     0.200
     5.760   151.301     0.200
     2.459    71.559     0.200
     3.852   106.559     0.200
     3.844   104.156     0.200
     5.452   144.559     0.200
     6.290   162.656     0.200
     7.706   196.156     0.200
    10.739   274.855     0.200
     2.446    70.648     0.200
     2.500    73.348     0.200
     2.498    71.750     0.200
     3.859   103.750     0.200
     3.840   105.250     0.200
     4.010   109.949     0.200
     4.224   114.250     0.200
     6.653   172.250     0.200
     3.499    97.203     0.200
     3.830   103.203     0.200
     3.839   105.004     0.200
     3.839   103.402     0.200
     4.016   109.004     0.200
     4.095   110.902     0.200
     4.222   114.402     0.200
     4.471   119.105     0.200
     4.775   126.402     0.200
     5.450   143.504     0.200
     6.288   161.402     0.200
     6.651   171.504     0.200
     7.761   199.203     0.200
     8.067   204.203     0.200
     8.174   207.902     0.200
     1.557    49.490     0.200
     1.740    55.090     0.200
     2.307    67.391     0.200
     2.750    76.590     0.200
     2.794    77.990     0.200
     2.948    82.490     0.200
     4.490   120.090     0.200
     5.267   136.791     0.200
     1.748    55.635     0.200
     2.760    77.635     0.200
     2.784    78.436     0.200
     2.932    83.734     0.200
     4.473   120.836     0.200
     1.398    48.137     0.200
     2.284    68.234     0.200
     2.561    73.637     0.200
     3.595    99.535     0.200
     4.072   115.035     0.200
     4.092   113.234     0.200
     5.213   137.836     0.200
     6.408   167.535     0.200
     3.666   101.111     0.200
     3.855   105.712     0.200
     3.998   107.911     0.200
     4.324   117.411     0.200
     6.748   172.411     0.200
     3.112    86.148     0.200
     3.401    92.352     0.200
     4.809   128.547     0.200
     5.115   135.750     0.200
     9.881   248.945     0.200
     2.552    74.344     0.200
     3.188    87.945     0.200
     4.829   127.844     0.200
     5.227   140.445     0.200
     7.186   184.555     0.200
     7.186   182.844     0.200
     7.714   200.445     0.200
    10.039   253.742     0.200
     3.583    98.383     0.200
     3.751   101.688     0.200
     3.768   102.688     0.200
     3.918   106.688     0.200
     4.224   116.688     0.200
     4.850   130.188     0.200
     5.115   136.883     0.200
     6.646   170.789     0.200
     1.168    40.871     0.200
     3.713    99.969     0.200
     3.945   107.672     0.200
     3.964   110.070     0.200
     4.096   111.570     0.200
     5.220   137.070     0.200
     1.240    42.875     0.200
     2.485    70.273     0.200
     3.826   103.273     0.200
     4.104   109.375     0.200
     4.208   113.078     0.200
     4.484   119.875     0.200
     4.762   125.477     0.200
     3.775   102.516     0.200
     3.884   105.215     0.200
     4.569   121.914     0.200
     4.856   128.914     0.200
     1.384    44.311     0.200
     2.522    71.110     0.200
     2.633    75.511     0.200
     2.506    70.511     0.200
     3.700   103.411     0.200
     3.740    99.711     0.200
     3.972   107.311     0.200
     4.003   107.711     0.200
     4.364   116.011     0.200
     5.594   145.911     0.200
     6.794   173.411     0.200
     7.833   199.610     0.200
     1.492    50.587     0.200
     2.322    68.687     0.200
     3.572    98.887     0.200
     3.885   106.687     0.200
     4.221   115.487     0.200
     4.874   132.087     0.200
     4.874   131.387     0.200
     8.481   215.587     0.200
     1.923    60.102     0.200
     1.923    60.699     0.200
     1.987    61.801     0.200
     1.987    64.902     0.200
     3.720   103.402     0.200
     3.787   106.500     0.200
     3.945   107.602     0.200
     4.187   115.402     0.200
     6.594   170.402     0.200
     8.400   214.672     0.200
     9.189   227.801     0.200
    10.992   274.902     0.200
    16.284   398.879     0.200
     3.715   103.078     0.200
     3.959   107.273     0.200
     4.900   132.672     0.200
     5.467   143.273     0.200
     5.467   143.172     0.200
     6.928   176.078     0.200
     3.666   100.094     0.200
     4.129   111.395     0.200
     1.143    40.281     0.200
     3.708   102.883     0.200
     4.049   111.984     0.200
     1.750    54.518     0.200
     1.750    54.018     0.200
     3.780   103.119     0.200
     4.752   125.418     0.200
     5.794   148.719     0.200
     3.038    83.594     0.200
     4.387   114.994     0.200
     4.673   124.195     0.200
     5.079   132.395     0.200
     1.632    54.254     0.200
     1.920    60.953     0.200
     2.367    69.354     0.200
     2.364    69.854     0.200
     2.841    79.953     0.200
     3.688   101.652     0.200
     3.886   106.652     0.200
     4.094   110.354     0.200
     5.002   132.652     0.200
     6.285   164.354     0.200
     6.454   168.754     0.200
     7.357   188.553     0.200
     7.675   196.854     0.200
     1.624    51.383     0.200
     6.173   161.078     0.200
     6.433   165.883     0.200
     7.315   186.781     0.200
     7.509   186.484     0.200
     2.474    71.844     0.200
     3.959   107.648     0.200
     4.891   132.344     0.200
     5.603   149.844     0.200
     6.035   157.547     0.200
     6.795   178.547     0.200
     7.901   198.008     0.200
     1.358    45.281     0.200
     2.462    72.180     0.200
     3.732   103.781     0.200
     6.783   172.680     0.200
     8.245   211.180     0.200
     1.563    49.730     0.200
     1.831    56.730     0.200
     3.633    97.832     0.200
     3.763   103.031     0.200
     4.078   109.633     0.200
     4.341   117.230     0.200
     4.489   118.832     0.200
     4.549   120.934     0.200
     5.021   131.934     0.200
     5.486   144.633     0.200
     6.752   174.332     0.200
     7.442   191.133     0.200
     2.614    76.093     0.200
     2.955    82.692     0.200
     4.399   117.593     0.200
     4.749   126.793     0.200
     6.387   167.393     0.200
     8.476   217.192     0.200
     3.414    95.430     0.200
     3.924   106.328     0.200
     4.021   109.031     0.200
     4.907   131.930     0.200
     5.195   137.727     0.200
     6.040   157.625     0.200
     6.440   167.227     0.200
     6.655   172.125     0.200
     7.313   190.227     0.200
     7.532   193.828     0.200
     7.897   203.031     0.200
     8.418   212.844     0.200
     1.917    60.217     0.200
     2.616    75.717     0.200
     2.728    76.416     0.200
     2.731    77.217     0.200
     3.699   101.316     0.200
     4.901   129.416     0.200
     5.453   142.916     0.200
     1.633    52.195     0.200
     1.674    53.094     0.200
     2.393    70.094     0.200
     1.676    53.680     0.200
     5.840   154.480     0.200
     1.548    50.152     0.200
     1.750    56.055     0.200
     2.340    69.055     0.200
     2.726    76.254     0.200
     2.787    79.254     0.200
     2.949    83.152     0.200
     3.536    97.453     0.200
     3.558    97.453     0.200
     3.793   102.754     0.200
     4.131   111.152     0.200
     4.248   114.953     0.200
     4.490   120.652     0.200
     5.068   133.754     0.200
     5.696   150.055     0.200
     6.917   179.754     0.200
     7.827   201.953     0.200
     8.233   211.754     0.200
     8.409   214.555     0.200
    11.571   290.652     0.200
     2.255    67.459     0.200
     2.374    69.258     0.200
     2.403    70.758     0.200
     2.404    69.859     0.200
     3.149    88.158     0.200
     3.473    95.359     0.200
     3.796   104.559     0.200
     4.185   113.658     0.200
     4.204   112.658     0.200
     4.415   117.158     0.200
     4.843   129.658     0.200
     5.000   133.758     0.200
     5.841   153.459     0.200
     6.222   162.059     0.200
     7.323   188.959     0.200
     7.717   197.859     0.200
     2.413    69.314     0.200
     1.534    49.435     0.200
     1.764    55.135     0.200
     2.712    77.335     0.200
     1.557    49.875     0.200
     1.740    55.074     0.200
     3.527    97.676     0.200
     3.547    97.477     0.200
     2.669    77.523     0.200
     2.767    80.711     0.200
     3.192    92.051     0.200
     3.325    91.992     0.200
     3.441    93.902     0.200
     4.679   125.480     0.200
     1.584    50.406     0.200
     2.406    71.008     0.200
     4.194   112.805     0.200
     1.400    47.898     0.200
     1.940    61.598     0.200
     1.398    47.559     0.200
     2.705    78.461     0.200
     3.714   100.961     0.200
     3.739   101.359     0.200
     3.943   106.961     0.200
     4.344   116.258     0.200
     5.422   143.859     0.200
     3.968   108.883     0.200
     2.117    62.715     0.200
     2.255    65.812     0.200
     2.336    67.516     0.200
     2.413    69.016     0.200
     2.444    71.215     0.200
     3.135    87.312     0.200
     3.461    95.414     0.200
     3.796   103.016     0.200
     4.011   107.215     0.200
     4.199   111.414     0.200
     4.211   111.715     0.200
     4.403   116.613     0.200
     5.007   132.715     0.200
     6.470   167.613     0.200
     1.609    49.643     0.200
     2.674    76.441     0.200
     2.733    76.242     0.200
     3.055    85.342     0.200
     3.284    90.342     0.200
     3.326    90.143     0.200
     4.031   108.842     0.200
     4.115   109.941     0.200
     4.816   125.342     0.200
     5.310   138.143     0.200
     5.814   149.143     0.200
     6.060   157.643     0.200
     7.458   187.262     0.200
     7.784   199.643     0.200
     8.277   209.742     0.200
     8.362   212.242     0.200
     8.788   221.643     0.200
     9.889   250.242     0.200
    11.347   285.143     0.200
     1.632    52.930     0.200
     1.755    55.531     0.200
     1.755    57.930     0.200
     3.296    92.031     0.200
     3.917   106.031     0.200
     1.456    46.366     0.200
     1.456    45.366     0.200
     2.393    68.266     0.200
     2.705    77.266     0.200
     2.959    83.466     0.200
     3.673    99.366     0.200
     3.690    99.866     0.200
     3.839   101.166     0.200
     4.028   108.066     0.200
     4.028   106.166     0.200
     4.484   117.966     0.200
     4.952   128.966     0.200
     5.679   149.166     0.200
     5.747   149.266     0.200
     7.777   198.966     0.200
     8.035   205.666     0.200
     8.098   204.066     0.200
     8.098   204.466     0.200
     8.287   207.866     0.200
     9.562   240.066     0.200
    15.361   371.085     0.200
     2.490    72.094     0.200
     3.859   105.689     0.200
     4.163   112.289     0.200
     5.343   140.588     0.200
     1.244    44.074     0.200
     3.832   104.672     0.200
     4.152   112.574     0.200
     6.573   170.074     0.200
     2.263    65.984     0.200
     1.331    46.027     0.200
     3.837   107.328     0.200
     4.423   119.930     0.200
     5.235   142.227     0.200
     2.091    63.977     0.200
     2.020    64.574     0.200
     2.488    74.574     0.200
     2.546    73.273     0.200
     2.783    80.375     0.200
     3.836   107.676     0.200
     3.893   104.875     0.200
     3.893   108.176     0.200
     4.081   110.477     0.200
     4.081   111.676     0.200
     4.438   119.574     0.200
     4.858   133.176     0.200
     5.230   139.574     0.200
     5.836   154.375     0.200
     6.492   168.977     0.200
     6.687   173.875     0.200
     7.255   187.273     0.200
     7.576   195.773     0.200
     8.447   218.773     0.200
    17.830   448.074     0.200
     1.341    46.246     0.200
     1.372    47.746     0.200
     2.545    73.844     0.200
     2.788    79.344     0.200
     3.516    96.746     0.200
     3.836   105.344     0.200
     3.826   104.246     0.200
     3.826   105.344     0.200
     3.894   107.945     0.200
     3.894   107.844     0.200
     4.080   111.945     0.200
     4.444   119.246     0.200
     5.227   138.445     0.200
     6.491   168.746     0.200
     6.684   173.645     0.200
     7.249   187.645     0.200
     7.574   196.945     0.200
     8.838   224.547     0.200
    10.804   269.496     0.200
     1.329    46.176     0.200
     1.329    46.152     0.200
     1.344    45.781     0.200
     2.779    79.383     0.200
     1.339    46.422     0.200
     3.830   104.523     0.200
     3.831   107.422     0.200
     4.432   118.723     0.200
     4.435   119.633     0.200
     1.346    46.281     0.200
     2.785    78.781     0.200
     3.885   105.023     0.200
     4.439   119.125     0.200
     5.238   137.723     0.200
     1.330    46.062     0.200
     3.841   104.664     0.200
     2.024    60.529     0.200
     2.546    72.430     0.200
     3.892   109.729     0.200
     3.825   105.629     0.200
     4.082   110.029     0.200
     4.435   119.229     0.200
     4.861   129.430     0.200
     5.231   140.229     0.200
     6.688   171.529     0.200
    10.971   281.229     0.200
     1.344    45.369     0.200
     1.359    45.969     0.200
     1.344    46.651     0.200
     2.495    72.552     0.200
     2.552    74.352     0.200
     2.788    79.852     0.200
     3.829   107.052     0.200
     3.832   104.651     0.200
     3.886   106.352     0.200
     4.087   111.651     0.200
     4.442   119.651     0.200
     5.236   138.552     0.200
     7.582   195.052     0.200
     1.369    48.141     0.200
     1.347    46.141     0.200
     2.088    63.742     0.200
     2.494    72.641     0.200
     2.550    73.842     0.200
     2.794    78.742     0.200
     3.521    97.141     0.200
     3.830   104.941     0.200
     3.889   105.441     0.200
     3.889   110.441     0.200
     3.832   105.441     0.200
     3.832   103.242     0.200
     4.084   111.541     0.200
     4.449   119.441     0.200
     4.854   130.842     0.200
     5.231   139.641     0.200
     6.495   168.842     0.200
    16.280   397.061     0.200
     1.343    45.291     0.200
     2.078    61.791     0.200
     2.497    73.191     0.200
     2.558    74.091     0.200
     2.781    77.891     0.200
     3.825   104.391     0.200
     3.835   105.091     0.200
     3.880   104.291     0.200
     4.094   110.691     0.200
     4.433   118.991     0.200
     5.245   139.091     0.200
     6.506   169.391     0.200
     7.273   186.991     0.200
     7.441   195.991     0.200
     2.018    65.220     0.200
     1.344    46.672     0.200
     4.087   111.578     0.200
     4.441   118.977     0.200
     4.862   130.477     0.200
     6.498   168.773     0.200
     7.258   186.977     0.200
     1.228    42.961     0.200
     2.175    63.859     0.200
     2.502    73.160     0.200
     3.432    95.758     0.200
     3.751   102.859     0.200
     4.042   109.059     0.200
     3.939   106.059     0.200
     4.285   115.660     0.200
     4.926   132.461     0.200
     5.217   137.961     0.200
     5.956   155.461     0.200
     6.462   167.258     0.200
     6.542   169.059     0.200
     7.333   187.758     0.200
     7.554   193.859     0.200
     7.919   202.859     0.200
     8.397   214.254     0.200
     8.823   223.359     0.200
    16.158   393.004     0.200
     2.507    73.184     0.200
     3.080    86.262     0.200
     3.468    90.195     0.200
     3.494    94.984     0.200
     5.126   135.184     0.200
     5.503   143.883     0.200
    15.225   372.051     0.200
     2.444    69.254     0.200
     2.681    77.154     0.200
     3.834   104.154     0.200
     4.009   107.254     0.200
     4.219   113.654     0.200
     4.770   127.254     0.200
     5.448   142.455     0.200
     6.648   171.955     0.200
     6.674   171.754     0.200
     6.746   175.754     0.200
     6.911   177.455     0.200
     7.710   198.154     0.200
     8.172   208.955     0.200
     2.074    61.239     0.200
     2.191    64.739     0.200
     2.405    70.839     0.200
     2.463    71.439     0.200
     3.095    87.239     0.200
     3.417    95.039     0.200
     4.263   113.439     0.200
     4.358   116.239     0.200
     4.782   128.739     0.200
     6.157   161.239     0.200
     6.162   161.339     0.200
     6.396   165.239     0.200
     7.162   185.839     0.200
     7.205   187.739     0.200
     8.781   222.639     0.200
     2.528    70.664     0.200
     2.571    73.965     0.200
     2.915    82.164     0.200
     4.022   109.566     0.200
     4.042   107.664     0.200
     5.688   149.766     0.200
     6.880   177.367     0.200
     6.914   179.367     0.200
     7.942   204.066     0.200
     3.030    81.828     0.200
     5.264   138.129     0.200
     1.224    39.859     0.200
     1.224    39.672     0.200
     2.604    74.309     0.200
     2.679    76.559     0.200
     3.057    86.160     0.200
     3.380    93.859     0.200
     3.406    94.441     0.200
     2.411    70.893     0.200
     3.788   104.692     0.200
     7.257   187.192     0.200
     1.688    54.836     0.200
     1.688    54.641     0.200
     3.477    95.141     0.200
     4.190   112.438     0.200
     4.310   116.242     0.200
     5.717   150.539     0.200
     1.203    38.414     0.200
     1.710    53.211     0.200
     3.868   104.211     0.200
     4.852   127.516     0.200
     6.336   164.711     0.200
     7.059   177.016     0.200
     7.590   190.812     0.200
     7.753   194.312     0.200
     9.968   251.117     0.200
    12.021   304.711     0.200
    17.271   431.211     0.200
    20.015   498.211     0.200
    20.110   499.117     0.200
    22.183   544.414     0.200
     2.479    71.180     0.200
     2.478    73.281     0.200
     3.797   103.180     0.200
     3.872   103.680     0.200
     3.872   105.680     0.200
     4.039   108.180     0.200
     4.253   113.281     0.200
     4.253   115.883     0.200
     6.682   172.781     0.200
     8.045   205.180     0.200
    11.320   285.586     0.200
     1.539    47.660     0.200
     1.539    47.859     0.200
     2.585    73.359     0.200
     3.273    88.262     0.200
     3.273    89.359     0.200
     3.087    85.059     0.200
     4.421   116.359     0.200
     4.835   126.059     0.200
     4.835   126.262     0.200
     5.350   139.660     0.200
     5.728   148.160     0.200
     7.480   190.160     0.200
     7.412   192.711     0.200
     7.701   196.559     0.200
     8.236   210.359     0.200
    11.883   296.859     0.200
     1.631    52.413     0.200
     1.753    55.413     0.200
     3.294    90.812     0.200
     5.721   150.513     0.200
     1.705    55.309     0.200
     2.321    69.809     0.200
     1.851    58.570     0.200
     3.630   100.070     0.200
     4.039   109.172     0.200
     6.477   168.375     0.200
     7.831   200.875     0.200
     7.954   204.375     0.200
     7.910   199.367     0.200
     8.357   213.570     0.200
    10.998   274.969     0.200
    15.681   381.719     0.200
     1.452    47.844     0.200
     1.852    58.844     0.200
     3.630    99.250     0.200
     4.126   111.250     0.200
     5.640   148.344     0.200
     1.454    49.344     0.200
     1.850    58.539     0.200
     1.850    58.641     0.200
     2.606    74.242     0.200
     3.628    99.344     0.200
     4.041   108.742     0.200
     4.129   111.844     0.200
     4.420   120.844     0.200
     4.420   118.539     0.200
     5.641   147.938     0.200
     6.481   168.242     0.200
     6.849   177.141     0.200
     6.868   178.141     0.200
     6.944   179.938     0.200
     7.104   183.344     0.200
     7.957   207.344     0.200
     7.957   203.039     0.200
     7.905   200.336     0.200
     7.905   200.844     0.200
     1.454    49.398     0.200
     1.851    58.195     0.200
     1.851    58.500     0.200
     2.450    71.102     0.200
     2.450    72.102     0.200
     2.601    74.398     0.200
     3.629    98.398     0.200
     4.041   108.297     0.200
     4.422   119.297     0.200
     5.644   147.500     0.200
     6.484   168.297     0.200
     6.851   177.195     0.200
     6.871   177.695     0.200
     7.107   183.602     0.200
     7.193   189.742     0.200
     7.899   198.492     0.200
     7.899   200.102     0.200
     7.844   202.000     0.200
     7.960   203.898     0.200
     8.364   214.000     0.200
    11.464   291.047     0.200
    15.668   381.445     0.200
     1.446    46.805     0.200
     1.859    58.703     0.200
     1.859    59.102     0.200
     4.033   109.102     0.200
     7.906   200.492     0.200
     7.906   204.102     0.200
    11.457   289.828     0.200
    15.671   381.172     0.200
     1.845    58.119     0.200
     1.845    58.420     0.200
     2.708    76.720     0.200
     3.621    98.020     0.200
     4.049   109.119     0.200
     4.431   118.020     0.200
     5.653   148.020     0.200
     6.493   168.520     0.200
     6.860   177.319     0.200
     6.880   178.020     0.200
     6.956   180.020     0.200
     7.116   183.520     0.200
     7.890   200.788     0.200
     7.890   199.819     0.200
     7.486   191.920     0.200
     7.886   202.920     0.200
     7.852   202.819     0.200
     7.968   203.619     0.200
     8.374   213.619     0.200
    15.660   382.014     0.200
     1.848    58.787     0.200
     3.626    99.986     0.200
     2.480    71.535     0.200
     1.464    49.141     0.200
     1.842    58.441     0.200
     2.455    71.941     0.200
     2.605    74.441     0.200
     1.847    59.039     0.200
     2.434    71.742     0.200
     2.611    74.844     0.200
     2.701    78.539     0.200
     2.881    82.539     0.200
     4.420   120.242     0.200
     6.480   168.539     0.200
     6.867   177.242     0.200
     6.944   176.641     0.200
     1.449    47.250     0.200
     2.457    71.250     0.200
     2.594    71.648     0.200
     2.881    79.250     0.200
     3.633    96.750     0.200
     4.420   117.555     0.200
     4.971   130.555     0.200
     6.870   177.250     0.200
     1.469    48.367     0.200
     1.469    49.867     0.200
     1.836    57.770     0.200
     1.836    58.668     0.200
     5.659   146.668     0.200
     5.897   153.969     0.200
     6.499   168.770     0.200
     7.195   189.320     0.200
     7.887   201.863     0.200
     7.887   199.867     0.200
    10.996   278.762     0.200
    15.661   382.387     0.200
     1.841    58.668     0.200
     1.849    58.695     0.200
     1.849    58.594     0.200
     2.448    71.195     0.200
     2.604    74.898     0.200
     2.885    82.297     0.200
     3.626    99.297     0.200
     4.043   107.594     0.200
     6.486   169.398     0.200
     6.949   178.398     0.200
     7.192   185.367     0.200
     7.479   191.898     0.200
     7.899   203.898     0.200
     7.844   201.992     0.200
     8.418   210.695     0.200
    11.003   278.312     0.200
    11.465   291.648     0.200
    15.668   382.688     0.200
     1.854    58.664     0.200
     2.602    75.664     0.200
     3.632   100.164     0.200
     4.125   111.664     0.200
     5.638   148.062     0.200
     1.446    46.996     0.200
     1.861    58.598     0.200
     1.853    58.521     0.200
     1.853    57.223     0.200
     1.853    59.021     0.200
     2.442    71.121     0.200
     2.603    74.422     0.200
     2.696    77.322     0.200
     3.632   100.723     0.200
     3.696   100.822     0.200
     4.126   112.322     0.200
     4.038   108.922     0.200
     4.038   110.422     0.200
     4.417   117.223     0.200
     4.972   133.521     0.200
     5.638   149.121     0.200
     5.906   153.723     0.200
     6.478   168.322     0.200
     6.846   176.422     0.200
     6.941   178.521     0.200
     7.834   200.922     0.200
    11.002   274.891     0.200
     1.855    58.479     0.200
     1.855    58.680     0.200
     2.449    71.580     0.200
     2.449    71.979     0.200
     3.632    98.479     0.200
     4.037   108.479     0.200
     5.911   156.479     0.200
     7.840   202.279     0.200
     7.903   199.523     0.200
     8.421   214.379     0.200
     1.170    41.422     0.200
     2.439    71.623     0.200
     2.482    72.123     0.200
     2.487    72.322     0.200
     3.837   104.422     0.200
     4.061   109.223     0.200
     1.844    58.262     0.200
     2.602    74.664     0.200
     1.845    58.776     0.200
     2.614    74.676     0.200
     2.881    83.076     0.200
     3.625    99.876     0.200
     4.044   109.976     0.200
     4.138   113.376     0.200
     4.421   120.276     0.200
     4.979   133.176     0.200
     6.480   168.876     0.200
     6.849   178.976     0.200
     6.867   178.476     0.200
     6.944   178.576     0.200
     2.485    72.977     0.200
     2.485    72.477     0.200
     2.481    71.676     0.200
     3.490    94.078     0.200
     3.828   102.277     0.200
     3.839   102.676     0.200
     4.196   112.777     0.200
     5.237   138.875     0.200
     5.237   137.875     0.200
     5.416   142.875     0.200
     6.256   161.676     0.200
     6.625   170.977     0.200
     6.644   172.777     0.200
     7.401   188.578     0.200
     7.651   196.375     0.200
     7.732   198.676     0.200
     7.955   202.777     0.200
     8.115   204.297     0.200
     9.074   234.176     0.200
    15.818   386.547     0.200
    18.029   449.477     0.200
     1.461    48.766     0.200
     1.843    58.566     0.200
     2.611    75.168     0.200
     3.621    99.367     0.200
     4.132   112.668     0.200
     4.428   118.969     0.200
     5.648   150.367     0.200
     7.842   202.168     0.200
     1.846    60.000     0.200
     1.842    59.305     0.200
     1.464    50.125     0.200
     1.841    58.523     0.200
     1.841    58.422     0.200
     2.444    72.125     0.200
     2.444    72.023     0.200
     2.611    75.625     0.200
     3.619    99.625     0.200
     4.130   110.824     0.200
     4.431   118.324     0.200
     5.898   152.723     0.200
     7.190   188.398     0.200
     7.477   192.223     0.200
     7.847   201.723     0.200
     8.412   213.625     0.200
    15.668   381.445     0.200
     1.847    58.678     0.200
     2.451    71.178     0.200
     2.451    70.879     0.200
     2.603    74.279     0.200
     2.603    74.879     0.200
     2.705    77.479     0.200
     3.624    99.178     0.200
     3.624   101.279     0.200
     4.046   108.678     0.200
     4.046   110.779     0.200
     4.428   119.578     0.200
     4.428   119.779     0.200
     4.980   132.479     0.200
     5.650   148.178     0.200
     6.490   168.678     0.200
     6.857   177.879     0.200
     6.953   177.979     0.200
     7.849   201.879     0.200
     7.894   202.822     0.200
     8.370   213.078     0.200
     8.420   214.279     0.200
     9.948   253.021     0.200
     2.266    67.500     0.200
     2.266    66.902     0.200
     2.538    73.402     0.200
     3.344    92.203     0.200
     3.666   101.000     0.200
     3.973   108.102     0.200
     4.607   123.801     0.200
     5.161   135.902     0.200
     6.480   168.203     0.200
     6.856   180.453     0.200
     7.334   189.000     0.200
     7.696   197.301     0.200
     7.869   201.801     0.200
     8.385   214.500     0.200
     1.126    39.883     0.200
     1.394    46.883     0.200
     2.292    67.586     0.200
     4.009   107.984     0.200
     3.984   108.086     0.200
     3.984   107.984     0.200
     4.609   122.289     0.200
     4.950   131.289     0.200
     6.405   167.289     0.200
     7.173   184.086     0.200
     8.394   213.578     0.200
     8.394   214.586     0.200
     8.778   224.188     0.200
     8.854   224.586     0.200
     9.489   243.180     0.200
    16.097   392.805     0.200
     1.404    48.957     0.200
     1.125    40.348     0.200
     1.793    56.584     0.200
     1.793    58.482     0.200
     1.682    54.283     0.200
     1.682    53.383     0.200
     1.784    55.883     0.200
     1.784    57.184     0.200
     3.094    86.184     0.200
     3.587    98.783     0.200
     4.162   110.783     0.200
     6.520   171.488     0.200
    10.487   264.201     0.200
     3.971   108.641     0.200
     2.291    67.794     0.200
     3.661   101.095     0.200
     6.882   180.495     0.200
     8.405   213.807     0.200
     8.405   211.695     0.200
    16.105   391.888     0.200
     3.665   100.441     0.200
     7.504   194.141     0.200
     8.393   211.262     0.200
     8.393   211.441     0.200
    11.071   274.133     0.200
     1.859    58.434     0.200
     2.603    76.230     0.200
     1.132    39.914     0.200
     8.392   211.430     0.200
     1.133    40.086     0.200
     4.005   106.984     0.200
     7.360   188.680     0.200
     8.395   213.727     0.200
     8.397   211.883     0.200
     1.404    48.492     0.200
     4.023   111.608     0.200
     1.111    40.051     0.200
     4.020   108.551     0.200
     6.904   180.726     0.200
     8.426   215.251     0.200
     1.109    40.023     0.200
     7.348   189.227     0.200
     1.110    40.211     0.200
     7.346   189.305     0.200
     1.129    40.036     0.200
     1.227    40.023     0.200
     1.596    50.625     0.200
     1.596    49.824     0.200
     2.059    60.125     0.200
     2.059    60.922     0.200
     2.722    78.523     0.200
     2.722    78.723     0.200
     2.939    81.922     0.200
     3.275    90.023     0.200
     3.880   105.125     0.200
     4.507   120.523     0.200
     5.704   147.523     0.200
     6.755   175.422     0.200
     6.814   174.125     0.200
     6.991   181.699     0.200
     6.980   181.523     0.200
     8.909   225.324     0.200
    16.346   399.562     0.200
     2.275    67.652     0.200
     4.619   124.652     0.200
     5.179   136.652     0.200
     7.157   184.953     0.200
     7.356   189.152     0.200
     8.397   212.926     0.200
     8.397   214.152     0.200
     8.389   212.754     0.200
     8.781   224.453     0.200
    10.883   279.652     0.200
    16.108   394.820     0.200
    20.104   502.055     0.200
    20.976   523.453     0.200
    21.629   539.453     0.200
     1.421    49.098     0.200
     4.922   131.797     0.200
     1.124    40.023     0.200
     2.299    68.223     0.200
     2.513    72.324     0.200
     3.669    99.922     0.200
     4.009   108.523     0.200
     3.986   108.121     0.200
     5.180   137.023     0.200
     6.410   166.621     0.200
     7.370   190.422     0.200
     1.122    40.203     0.200
     3.666   100.703     0.200
     3.982   108.402     0.200
     4.012   108.902     0.200
     5.175   136.602     0.200
     6.891   183.328     0.200
     7.176   182.703     0.200
     7.364   189.602     0.200
     8.394   211.219     0.200
     1.129    39.641     0.200
     1.417    47.844     0.200
     2.260    67.344     0.200
     3.662   100.344     0.200
     3.967   107.844     0.200
     4.022   108.539     0.200
     5.153   136.141     0.200
     7.324   188.438     0.200
     1.092    39.494     0.200
     2.504    71.294     0.200
     3.939   107.294     0.200
     5.130   136.394     0.200
     1.116    40.270     0.200
     1.401    47.471     0.200
     2.300    69.070     0.200
     3.659   100.170     0.200
     3.976   108.670     0.200
     4.019   109.471     0.200
     1.141    40.766     0.200
     2.337    69.066     0.200
     3.358    93.266     0.200
     3.998   107.465     0.200
     6.874   179.664     0.200
     7.159   182.766     0.200
     7.893   201.766     0.200
     8.393   216.305     0.200
     8.393   214.965     0.200
    11.049   279.109     0.200
    16.104   392.781     0.200
     1.129    40.508     0.200
     2.291    66.406     0.200
     4.006   108.102     0.200
     6.888   182.430     0.200
     7.173   186.008     0.200
     8.392   213.047     0.200
    10.972   279.523     0.200
    16.095   395.297     0.200
     1.381    44.383     0.200
     1.105    40.008     0.200
     2.291    67.605     0.200
     4.921   131.605     0.200
     6.873   179.180     0.200
    11.075   275.801     0.200
    16.121   396.223     0.200
     4.044   113.911     0.200
     1.377    47.763     0.200
     1.142    40.891     0.200
     3.650    99.880     0.200
     4.033   109.180     0.200
     4.905   129.979     0.200
     6.849   176.880     0.200
     7.134   183.979     0.200
     8.390   215.479     0.200
     8.436   217.479     0.200
    16.141   394.666     0.200
     1.113    39.930     0.200
     2.283    67.727     0.200
     1.123    40.585     0.200
     1.138    40.914     0.200
     1.103    40.414     0.200
     1.114    40.529     0.200
     1.090    39.680     0.200
     1.122    40.660     0.200
     1.124    40.367     0.200
     1.118    40.547     0.200
     7.325   190.047     0.200
     1.090    39.609     0.200
     2.285    66.711     0.200
     2.497    72.406     0.200
     3.629    99.805     0.200
     3.943   106.109     0.200
     4.050   109.406     0.200
     4.570   122.805     0.200
     5.136   136.406     0.200
     6.367   165.906     0.200
     1.122    40.684     0.200
     2.545    73.582     0.200
     3.329    92.184     0.200
     3.649   100.883     0.200
     3.950   108.082     0.200
     4.036   109.883     0.200
     5.134   137.082     0.200
     7.302   187.781     0.200
     1.103    40.172     0.200
     1.102    39.898     0.200
     6.869   181.844     0.200
    16.127   395.539     0.200
     1.100    39.945     0.200
     4.051   113.945     0.200
     1.108    40.098     0.200
     3.642    99.197     0.200
     4.040   113.598     0.200
     7.322   189.697     0.200
     4.051   109.933     0.200
     1.106    39.660     0.200
     1.435    46.059     0.200
     4.043   108.359     0.200
     7.317   188.260     0.200
     1.123    40.477     0.200
     2.289    67.379     0.200
     4.014   109.477     0.200
     1.108    40.258     0.200
     4.040   110.258     0.200
     1.103    40.164     0.200
     2.272    67.668     0.200
     2.523    73.367     0.200
     1.091    39.398     0.200
     4.052   112.697     0.200
     1.090    39.637     0.200
     4.054   113.438     0.200
     6.873   180.438     0.200
     7.323   189.238     0.200
     7.323   187.338     0.200
     8.439   217.682     0.200
    16.128   394.230     0.200
     2.404    70.715     0.200
     1.853    58.754     0.200
     1.853    58.652     0.200
     2.599    74.555     0.200
     3.630    98.355     0.200
     4.039   107.555     0.200
     5.911   153.453     0.200
     7.194   187.539     0.200
     7.900   199.973     0.200
     7.900   198.453     0.200
     8.422   212.754     0.200
    11.008   276.906     0.200
     1.103    40.117     0.200
     2.452    71.285     0.200
     1.142    40.406     0.200
     2.285    67.703     0.200
     7.358   191.245     0.200
     1.861    58.664     0.200
     1.196    42.504     0.200
     3.941   110.205     0.200
     4.050   109.205     0.200
     6.473   167.504     0.200
     1.125    40.301     0.200
     2.293    68.301     0.200
     3.668   100.701     0.200
     4.010   107.901     0.200
     4.609   123.501     0.200
     5.176   137.101     0.200
     6.407   165.901     0.200
     6.887   182.536     0.200
     7.172   185.001     0.200
     7.363   190.901     0.200
     9.489   242.219     0.200
    16.097   395.245     0.200
     4.020   108.180     0.200
     4.600   121.879     0.200
     6.395   165.777     0.200
     7.161   185.180     0.200
     7.347   190.078     0.200
     7.492   193.180     0.200
     8.410   215.047     0.200
    11.065   281.395     0.200
     1.111    40.293     0.200
     1.774    55.406     0.200
     4.425   118.504     0.200
     1.112    40.172     0.200
     7.361   191.472     0.200
     3.635    98.719     0.200
     6.903   181.219     0.200
     1.091    38.823     0.200
     1.862    58.852     0.200
     2.596    74.656     0.200
     4.293   117.484     0.200
     1.444    47.121     0.200
     2.600    75.023     0.200
     4.409   118.621     0.200
     1.104    39.084     0.200
     4.361   119.949     0.200
     4.921   130.584     0.200
     6.875   181.561     0.200
     3.938   108.031     0.200
     3.958   107.721     0.200
     8.235   209.363     0.200
     8.235   210.619     0.200
     8.810   222.619     0.200
    18.376   460.820     0.200
     1.464    49.514     0.200
     3.941   105.264     0.200
     2.724    77.994     0.200
     3.522    96.494     0.200
     3.936   106.670     0.200
     5.192   138.795     0.200
     5.201   138.094     0.200
     8.248   208.488     0.200
     8.814   223.795     0.200
     3.939   107.273     0.200
     3.934   107.383     0.200
     6.371   166.609     0.200
     7.620   197.312     0.200
     8.250   211.352     0.200
     1.467    48.626     0.200
     3.952   107.526     0.200
     1.843    58.533     0.200
     2.607    75.135     0.200
     3.620    99.834     0.200
     4.050   108.934     0.200
     1.091    39.418     0.200
     4.355   119.793     0.200
     7.327   189.117     0.200
     4.097   113.625     0.200
     1.781    57.133     0.200
     3.612   102.133     0.200
     4.368   118.562     0.200
    11.205   282.102     0.200
     2.532    72.705     0.200
     3.765   102.605     0.200
     2.390    70.570     0.200
     2.401    69.570     0.200
     3.872   106.371     0.200
     4.131   109.668     0.200
     1.405    45.276     0.200
     2.358    69.076     0.200
     2.456    71.076     0.200
     3.966   107.876     0.200
     3.966   107.376     0.200
     4.037   109.476     0.200
     6.011   156.076     0.200
     6.392   165.376     0.200
     8.380   214.076     0.200
     2.110    61.598     0.200
     2.367    68.195     0.200
     3.928   106.848     0.200
     3.896   105.195     0.200
     4.198   115.695     0.200
     5.151   134.695     0.200
     7.581   195.398     0.200
     8.295   207.215     0.200
     8.295   211.297     0.200
    15.798   382.539     0.200
    16.276   400.297     0.200
    18.019   451.695     0.200
    20.477   507.297     0.200
    20.699   512.098     0.200
     7.714   195.387     0.200
     1.095    39.363     0.200
     2.166    63.945     0.200
     4.148   111.047     0.200
     8.274   209.887     0.200
     1.642    51.648     0.200
     4.244   113.871     0.200
     2.355    70.566     0.200
     4.250   113.867     0.200
     8.619   217.758     0.200
    16.243   397.258     0.200
     4.307   115.074     0.200
     8.638   221.770     0.200
    16.257   398.145     0.200
     6.834   181.875     0.200
     7.156   185.375     0.200
     1.650    53.352     0.200
     4.322   119.328     0.200
     8.634   219.195     0.200
    11.192   280.031     0.200
     4.299   117.486     0.200
     4.741   127.236     0.200
     6.842   181.324     0.200
     7.163   184.635     0.200
     9.226   236.115     0.200
    10.729   275.715     0.200
    11.214   280.479     0.200
    16.249   396.504     0.200
     4.308   116.977     0.200
     7.181   184.332     0.200
     8.608   219.990     0.200
    10.753   276.305     0.200
    16.235   396.314     0.200
     4.760   127.314     0.200
     4.336   118.242     0.200
     4.728   127.952     0.200
     7.148   184.052     0.200
    11.178   280.170     0.200
    16.271   398.495     0.200
     1.502    48.149     0.200
     2.445    71.550     0.200
     2.951    83.649     0.200
     3.214    90.249     0.200
     4.288   115.676     0.200
     6.705   175.167     0.200
     8.086   204.774     0.200
    11.061   278.367     0.200
    14.589   355.617     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.503    15.883     0.200
     0.557    17.922     0.200
     2.287    71.820     0.200
     2.287    73.023     0.200
     0.483    16.180     0.200
     0.914    28.680     0.200
     2.088    65.680     0.200
     2.129    67.680     0.200
     2.209    69.680     0.200
     2.335    73.477     0.200
     2.341    75.078     0.200
     2.395    76.883     0.200
     2.444    78.180     0.200
     0.712    23.168     0.200
     1.383    44.168     0.200
     2.345    74.668     0.200
     8.142   248.367     0.200
     0.535    17.562     0.200
     0.669    22.562     0.200
     1.380    43.363     0.200
     2.197    69.963     0.200
     2.337    74.562     0.200
     2.869    85.062     0.200
     0.538    17.762     0.200
     0.596    19.062     0.200
     1.972    61.262     0.200
     2.179    67.461     0.200
     2.249    70.762     0.200
     0.387    13.898     0.200
     0.776    24.898     0.200
     1.040    32.898     0.200
     1.972    63.602     0.200
     2.233    70.102     0.200
     2.298    72.102     0.200
     2.430    75.195     0.200
     2.482    76.898     0.200
     1.953    59.094     0.200
     0.562    18.047     0.200
     1.130    36.848     0.200
     1.137    36.848     0.200
     1.929    60.148     0.200
     2.379    74.348     0.200
     1.276    39.672     0.200
     2.027    62.875     0.200
     2.465    74.273     0.200
     2.492    78.273     0.200
     0.324    11.320     0.200
     1.244    39.922     0.200
     1.245    39.922     0.200
     2.023    62.320     0.200
     2.447    74.922     0.200
     2.493    79.117     0.200
     1.251    38.961     0.200
     1.253    38.961     0.200
     2.451    74.867     0.200
     2.492    79.164     0.200
     0.318    10.125     0.200
     1.254    40.023     0.200
     2.014    62.922     0.200
     2.453    75.125     0.200
     2.490    79.125     0.200
     0.281     9.982     0.200
     1.284    40.082     0.200
     1.285    40.082     0.200
     2.466    75.281     0.200
     2.499    78.482     0.200
     1.251    39.566     0.200
     1.252    39.566     0.200
     2.015    61.668     0.200
     2.456    74.270     0.200
     2.486    78.770     0.200
     0.284     9.909     0.200
     1.268    39.508     0.200
     1.270    39.508     0.200
     2.002    61.708     0.200
     2.448    75.909     0.200
     0.310    10.188     0.200
     1.256    39.287     0.200
     1.258    39.287     0.200
     2.011    62.188     0.200
     2.453    75.287     0.200
     2.494    78.988     0.200
     5.576   168.688     0.200
     0.320    10.773     0.200
     1.247    40.070     0.200
     1.248    40.070     0.200
     2.020    62.570     0.200
     2.448    74.672     0.200
     2.494    78.172     0.200
     1.270    41.017     0.200
     1.271    41.017     0.200
     1.997    63.217     0.200
     2.468    76.717     0.200
     2.483    78.117     0.200
     0.309    10.467     0.200
     1.264    40.367     0.200
     1.265    40.367     0.200
     2.002    62.268     0.200
     2.461    75.467     0.200
     2.488    79.467     0.200
     0.613    19.824     0.200
     0.620    19.824     0.200
     1.209    38.824     0.200
     2.207    68.324     0.200
     5.329   154.215     0.200
     0.286    10.020     0.200
     1.279    40.418     0.200
     1.280    40.418     0.200
     1.990    61.418     0.200
     2.463    75.617     0.200
     2.499    78.418     0.200
     0.303    10.625     0.200
     0.853    28.625     0.200
     2.032    62.125     0.200
     2.422    74.523     0.200
     3.485   100.125     0.200
     5.309   154.422     0.200
     5.450   158.328     0.200
     8.039   235.125     0.200
     0.313    11.195     0.200
     2.040    61.992     0.200
     2.418    72.492     0.200
     0.319    10.754     0.200
     0.826    27.754     0.200
     1.271    40.555     0.200
     1.272    40.555     0.200
     1.994    62.254     0.200
     2.477    76.055     0.200
     2.469    79.754     0.200
     0.297    10.055     0.200
     1.314    41.555     0.200
     1.315    41.555     0.200
     1.952    60.758     0.200
     2.454    78.055     0.200
     1.367    43.410     0.200
     1.368    43.410     0.200
     1.909    59.311     0.200
     2.512    75.910     0.200
     6.777   191.211     0.200
     0.295    10.949     0.200
     0.856    28.750     0.200
     1.259    40.150     0.200
     2.012    62.250     0.200
     2.040    62.150     0.200
     2.442    75.150     0.200
     0.611    18.938     0.200
     0.611    19.938     0.200
     0.584    19.639     0.200
     1.337    42.139     0.200
     2.161    69.639     0.200
     2.699    82.339     0.200
     7.447   211.139     0.200
     0.266     8.414     0.200
     0.880    29.211     0.200
     1.327    42.211     0.200
     1.329    42.211     0.200
     2.475    78.211     0.200
     0.552    17.441     0.200
     0.561    17.441     0.200
     0.580    19.441     0.200
     1.256    40.441     0.200
     2.157    66.941     0.200
     0.708    23.105     0.200
     2.247    70.605     0.200
     2.300    72.105     0.200
     2.341    72.707     0.200
     2.449    78.105     0.200
     6.268   182.207     0.200
     2.866    86.682     0.200
     5.933   171.981     0.200
     0.510    16.039     0.200
     1.353    43.039     0.200
     1.352    43.039     0.200
     2.233    71.539     0.200
     2.665    81.742     0.200
     0.550    18.688     0.200
     0.758    23.688     0.200
     0.846    28.188     0.200
     2.153    69.484     0.200
     2.252    70.984     0.200
     2.223    70.188     0.200
     2.429    76.086     0.200
     0.664    21.188     0.200
     1.073    34.188     0.200
     1.075    34.188     0.200
     2.218    68.281     0.200
     2.372    75.188     0.200
     2.464    76.586     0.200
     2.341    74.188     0.200
     2.403    76.188     0.200
     0.764    25.418     0.200
     0.913    29.117     0.200
     0.915    29.117     0.200
     2.210    70.516     0.200
     2.251    69.516     0.200
     2.339    71.016     0.200
     2.439    77.516     0.200
     9.799   285.617     0.200
    10.684   307.117     0.200
     0.811    26.426     0.200
     0.859    27.023     0.200
     0.862    27.023     0.200
     2.194    66.723     0.200
     2.304    70.824     0.200
     2.467    76.625     0.200
     4.829   141.324     0.200
     7.253   214.223     0.200
     0.887    28.625     0.200
     2.124    67.328     0.200
     2.139    66.625     0.200
     2.333    71.625     0.200
     2.430    76.031     0.200
     2.351    72.703     0.200
     2.409    76.805     0.200
     0.991    31.271     0.200
     2.368    74.672     0.200
     2.353    74.871     0.200
     6.321   186.771     0.200
     9.901   284.871     0.200
     0.562    18.215     0.200
     2.155    69.016     0.200
     2.745    83.316     0.200
     0.385    12.112     0.200
     2.297    72.712     0.200
     2.838    86.712     0.200
     5.501   158.112     0.200
     0.578    18.664     0.200
     1.302    40.961     0.200
     2.210    71.266     0.200
     0.383    12.207     0.200
     2.304    72.207     0.200
     2.842    86.906     0.200
     2.842    86.605     0.200
     0.584    18.582     0.200
     1.275    40.082     0.200
     2.225    70.582     0.200
     0.551    18.240     0.200
     2.272    71.141     0.200
     2.415    76.141     0.200
     0.322    11.365     0.200
     0.492    15.746     0.200
     1.498    47.246     0.200
     1.497    46.246     0.200
     2.183    69.445     0.200
     2.183    68.445     0.200
     2.778    84.348     0.200
     0.790    26.102     0.200
     0.790    25.902     0.200
     2.380    74.402     0.200
     1.019    33.177     0.200
     2.539    74.677     0.200
     0.658    21.758     0.200
     0.902    29.156     0.200
     1.879    59.758     0.200
     2.102    64.656     0.200
     2.057    65.055     0.200
     0.695    22.816     0.200
     1.183    38.816     0.200
     2.171    69.918     0.200
     2.426    74.617     0.200
     2.526    77.316     0.200
     3.406   102.918     0.200
     5.931   180.617     0.200
     0.560    17.972     0.200
     1.212    39.572     0.200
     2.153    67.172     0.200
     2.153    66.972     0.200
     0.659    21.465     0.200
     0.901    29.266     0.200
     2.058    64.266     0.200
     2.102    64.164     0.200
     2.102    64.863     0.200
     0.267     9.867     0.200
     0.267    11.062     0.200
     2.749    82.867     0.200
     0.727    23.773     0.200
     1.004    32.574     0.200
     2.000    62.973     0.200
     2.255    69.473     0.200
     0.694    22.914     0.200
     1.256    40.117     0.200
     1.256    39.922     0.200
     2.956    87.320     0.200
     0.719    23.391     0.200
     1.117    35.789     0.200
     1.117    35.391     0.200
     2.259    70.188     0.200
     2.302    72.688     0.200
     2.406    75.688     0.200
     2.406    75.992     0.200
     3.645   110.891     0.200
     0.340    11.910     0.200
     2.335    73.309     0.200
     4.140   122.109     0.200
     4.280   129.207     0.200
     6.757   202.309     0.200
     0.360    12.219     0.200
     0.360    12.020     0.200
     1.642    51.319     0.200
     2.313    73.619     0.200
     2.313    72.619     0.200
     2.806    85.919     0.200
     3.350   101.719     0.200
     4.146   124.619     0.200
     6.761   203.020     0.200
     0.933    30.039     0.200
     0.933    29.838     0.200
     2.396    73.338     0.200
     3.345   101.639     0.200
     3.356   100.738     0.200
     4.639   140.238     0.200
     5.966   179.539     0.200
     6.942   209.838     0.200
     0.671    22.214     0.200
     0.871    28.014     0.200
     0.871    27.414     0.200
     2.108    67.214     0.200
     2.209    69.113     0.200
     2.209    67.613     0.200
     2.292    71.714     0.200
     2.292    71.613     0.200
     0.226     7.812     0.200
     0.226     7.711     0.200
     1.350    42.812     0.200
     1.350    43.211     0.200
     2.505    75.516     0.200
     2.499    78.312     0.200
     2.499    78.711     0.200
     0.318    10.918     0.200
     0.318    10.719     0.200
     1.254    40.719     0.200
     2.454    75.418     0.200
     2.454    74.719     0.200
     2.499    78.621     0.200
     0.304    10.414     0.200
     1.256    40.414     0.200
     1.256    40.113     0.200
     2.445    75.711     0.200
     2.445    74.414     0.200
     2.505    79.113     0.200
     2.505    78.512     0.200
     0.303    10.191     0.200
     0.303     9.992     0.200
     1.261    40.289     0.200
     2.452    75.289     0.200
     2.452    74.691     0.200
     2.499    78.992     0.200
     2.499    78.492     0.200
     0.513    17.073     0.200
     1.159    36.673     0.200
     1.159    37.173     0.200
     2.385    74.973     0.200
     2.384    74.973     0.200
     2.384    75.873     0.200
     2.473    76.873     0.200
     2.473    76.473     0.200
     0.320    10.582     0.200
     1.259    39.882     0.200
     2.462    75.182     0.200
     2.481    78.782     0.200
     0.343    11.450     0.200
     1.236    39.350     0.200
     1.236    39.050     0.200
     2.063    64.950     0.200
     2.449    75.150     0.200
     2.449    74.850     0.200
     2.479    77.750     0.200
     2.481    78.050     0.200
     0.348    11.351     0.200
     1.229    39.450     0.200
     2.069    64.751     0.200
     2.445    75.650     0.200
     2.473    78.150     0.200
     2.482    79.251     0.200
     0.395    12.865     0.200
     1.216    38.465     0.200
     2.081    64.665     0.200
     2.462    76.065     0.200
     2.454    77.165     0.200
     2.444    77.766     0.200
     0.359    11.427     0.200
     1.223    39.526     0.200
     1.223    39.327     0.200
     2.076    65.227     0.200
     2.445    75.827     0.200
     2.465    77.627     0.200
     2.477    78.327     0.200
     2.477    78.727     0.200
     4.011   122.427     0.200
     4.511   137.526     0.200
     0.274     9.785     0.200
     1.277    40.387     0.200
     1.277    40.285     0.200
     2.027    63.484     0.200
     2.450    74.984     0.200
     3.805   111.984     0.200
     3.992   120.785     0.200
     8.211   240.484     0.200
     0.311    10.148     0.200
     0.311    10.047     0.200
     1.257    40.648     0.200
     1.257    39.945     0.200
     2.044    63.750     0.200
     2.452    75.250     0.200
     2.452    74.945     0.200
     2.495    78.945     0.200
     2.495    78.844     0.200
     0.330    10.805     0.200
     1.246    40.211     0.200
     2.053    64.305     0.200
     2.454    75.109     0.200
     2.491    78.008     0.200
     2.484    79.211     0.200
     4.482   135.711     0.200
     0.310    11.037     0.200
     0.310    10.738     0.200
     1.253    39.037     0.200
     1.253    39.638     0.200
     2.048    64.338     0.200
     2.447    74.438     0.200
     2.447    75.338     0.200
     2.499    77.838     0.200
     0.332    11.219     0.200
     1.238    38.816     0.200
     1.238    39.520     0.200
     2.062    64.316     0.200
     2.444    74.418     0.200
     2.444    75.020     0.200
     2.482    77.316     0.200
     2.482    77.520     0.200
     2.491    79.316     0.200
     7.445   217.219     0.200
     0.326    10.945     0.200
     1.247    39.242     0.200
     2.053    64.141     0.200
     2.451    75.344     0.200
     2.491    77.844     0.200
     2.488    78.445     0.200
     4.480   136.141     0.200
     0.602    19.266     0.200
     1.339    43.367     0.200
     2.000    63.164     0.200
     2.167    68.562     0.200
     2.167    68.867     0.200
     4.577   139.461     0.200
     0.332    10.992     0.200
     1.238    39.292     0.200
     1.238    39.992     0.200
     2.062    64.492     0.200
     2.483    77.192     0.200
     2.483    77.393     0.200
     2.444    74.893     0.200
     2.444    75.092     0.200
     2.491    78.393     0.200
     0.314    10.941     0.200
     1.245    38.742     0.200
     1.245    39.742     0.200
     2.057    64.242     0.200
     2.439    74.043     0.200
     2.439    74.441     0.200
     2.491    77.742     0.200
     3.837   115.242     0.200
     5.590   169.543     0.200
     0.333    10.955     0.200
     1.234    39.156     0.200
     2.066    64.455     0.200
     2.440    74.955     0.200
     4.491   136.055     0.200
     0.767    24.973     0.200
     0.767    24.672     0.200
     1.411    44.875     0.200
     0.765    25.118     0.200
     1.286    40.419     0.200
     1.286    40.719     0.200
     2.088    66.719     0.200
     2.088    66.919     0.200
     2.449    76.818     0.200
     2.449    77.818     0.200
     0.350    11.863     0.200
     2.320    73.766     0.200
     2.320    73.164     0.200
     2.794    85.566     0.200
     0.359    12.004     0.200
     2.311    72.707     0.200
     2.311    73.004     0.200
     0.556    17.391     0.200
     0.556    17.789     0.200
     1.283    41.492     0.200
     2.166    67.289     0.200
     0.342    11.695     0.200
     0.342    11.594     0.200
     1.621    50.695     0.200
     2.326    72.594     0.200
     2.784    83.797     0.200
     0.714    22.902     0.200
     0.714    23.301     0.200
     2.185    68.199     0.200
     2.929    88.000     0.200
     0.821    26.664     0.200
     1.331    42.367     0.200
     1.331    42.266     0.200
     2.019    64.562     0.200
     2.019    64.766     0.200
     2.478    78.164     0.200
     3.904   115.766     0.200
     0.818    26.781     0.200
     0.818    26.578     0.200
     1.334    42.484     0.200
     1.334    42.281     0.200
     2.019    64.883     0.200
     2.019    64.984     0.200
     2.482    78.883     0.200
     2.482    78.578     0.200
     0.685    22.316     0.200
     1.009    32.617     0.200
     1.009    32.516     0.200
     2.216    70.418     0.200
     2.216    70.117     0.200
     2.351    74.316     0.200
     2.404    74.516     0.200
     2.404    73.918     0.200
     2.392    76.219     0.200
     2.392    75.516     0.200
     0.679    22.190     0.200
     1.010    32.590     0.200
     1.010    32.090     0.200
     2.219    70.290     0.200
     2.355    74.090     0.200
     2.355    74.190     0.200
     2.402    74.390     0.200
     2.402    73.790     0.200
     2.396    75.890     0.200
     0.695    22.180     0.200
     0.695    22.375     0.200
     1.004    32.680     0.200
     1.004    32.578     0.200
     2.209    70.375     0.200
     2.209    69.680     0.200
     2.342    74.477     0.200
     2.404    74.680     0.200
     2.404    74.180     0.200
     2.390    76.180     0.200
     2.390    75.781     0.200
     0.691    22.254     0.200
     0.691    22.457     0.200
     1.007    32.457     0.200
     1.007    32.656     0.200
     2.213    70.055     0.200
     2.213    70.457     0.200
     2.347    74.156     0.200
     2.407    74.656     0.200
     2.407    74.055     0.200
     2.389    75.855     0.200
     4.014   121.957     0.200
     0.429    14.223     0.200
     1.048    33.824     0.200
     2.204    69.023     0.200
     2.300    72.324     0.200
     2.300    71.922     0.200
     0.680    21.922     0.200
     0.680    22.117     0.200
     2.217    69.617     0.200
     2.217    69.922     0.200
     2.354    73.719     0.200
     2.354    74.117     0.200
     2.402    74.117     0.200
     2.396    75.617     0.200
     0.365    12.211     0.200
     0.365    12.109     0.200
     2.309    72.312     0.200
     2.309    72.414     0.200
     2.813    85.914     0.200
     3.436    98.812     0.200
     3.436   104.508     0.200
     0.062     4.328     0.200
     0.909    28.922     0.200
     2.494    76.523     0.200
     2.494    75.828     0.200
     8.520   248.523     0.200
     0.075     4.450     0.200
     2.490    76.450     0.200
     0.679    21.939     0.200
     0.679    22.340     0.200
     1.004    32.239     0.200
     1.004    32.340     0.200
     2.214    69.840     0.200
     2.351    73.439     0.200
     2.351    73.939     0.200
     2.395    74.340     0.200
     2.395    74.040     0.200
     2.403    75.739     0.200
     2.403    75.540     0.200
     7.357   215.340     0.200
     0.618    19.770     0.200
     0.618    20.170     0.200
     1.217    39.471     0.200
     1.346    43.270     0.200
     1.346    43.770     0.200
     2.150    67.971     0.200
     2.710    82.770     0.200
     5.358   157.170     0.200
     0.589    18.814     0.200
     1.218    37.814     0.200
     2.188    67.713     0.200
     2.188    67.514     0.200
     2.675    80.814     0.200
     5.422   164.113     0.200
     0.607    20.055     0.200
     0.607    18.859     0.200
     1.216    39.758     0.200
     1.338    43.656     0.200
     2.164    68.555     0.200
     7.451   219.859     0.200
     0.605    20.113     0.200
     1.212    38.910     0.200
     1.342    43.512     0.200
     1.342    42.012     0.200
     2.163    68.512     0.200
     0.607    19.805     0.200
     0.607    18.904     0.200
     1.347    43.004     0.200
     2.158    68.805     0.200
     0.648    21.125     0.200
     1.012    32.227     0.200
     1.012    31.922     0.200
     2.228    70.125     0.200
     2.385    74.023     0.200
     2.373    73.922     0.200
     2.421    75.523     0.200
     2.421    75.227     0.200
     7.389   216.828     0.200
     0.290     9.693     0.200
     1.097    35.493     0.200
     1.310    41.594     0.200
     1.310    40.894     0.200
     2.465    78.394     0.200
     2.465    78.094     0.200
     4.422   133.493     0.200
     0.825    26.890     0.200
     0.838    27.190     0.200
     0.838    26.790     0.200
     2.022    64.690     0.200
     2.022    64.090     0.200
     2.160    68.090     0.200
     2.279    71.290     0.200
     2.279    70.990     0.200
     2.488    78.790     0.200
     2.488    78.890     0.200
     0.595    19.489     0.200
     1.217    38.789     0.200
     2.180    69.089     0.200
     0.385    12.172     0.200
     0.385    12.867     0.200
     1.184    37.867     0.200
     2.434    76.172     0.200
     2.434    77.070     0.200
     2.480    76.766     0.200
     2.480    77.172     0.200
     2.474    77.266     0.200
     2.474    77.969     0.200
     0.398    13.094     0.200
     0.398    12.793     0.200
     2.421    76.793     0.200
     2.488    76.992     0.200
     2.488    77.195     0.200
     2.472    77.594     0.200
     2.472    78.094     0.200
     3.851   116.094     0.200
     0.397    12.816     0.200
     0.397    12.918     0.200
     1.231    39.020     0.200
     1.231    39.316     0.200
     1.192    38.020     0.200
     2.427    77.020     0.200
     2.468    77.219     0.200
     2.468    78.418     0.200
     2.481    77.117     0.200
     2.481    77.520     0.200
     0.388    12.844     0.200
     1.190    37.844     0.200
     1.229    38.547     0.200
     1.229    38.750     0.200
     2.438    76.750     0.200
     2.474    76.945     0.200
     2.474    77.148     0.200
     2.468    76.750     0.200
     2.468    77.547     0.200
     3.856   117.648     0.200
     0.551    18.141     0.200
     0.551    18.242     0.200
     1.052    33.945     0.200
     2.132    67.039     0.200
     2.132    67.141     0.200
     0.558    18.172     0.200
     1.058    34.273     0.200
     2.126    67.172     0.200
     2.126    66.969     0.200
     3.638   111.070     0.200
     0.374    13.781     0.200
     2.503    74.180     0.200
     3.484   104.980     0.200
     3.025    87.883     0.200
     5.661   168.680     0.200
     0.450    15.590     0.200
     2.486    73.289     0.200
     2.529    75.188     0.200
     2.529    74.391     0.200
     2.990    89.590     0.200
     5.641   170.891     0.200
     0.290     9.555     0.200
     0.290     9.656     0.200
     1.104    35.453     0.200
     1.302    41.359     0.200
     1.302    41.859     0.200
     2.472    77.953     0.200
     2.472    78.055     0.200
     2.493    76.258     0.200
     2.493    77.258     0.200
     5.533   167.656     0.200
     0.672    21.711     0.200
     0.672    21.812     0.200
     2.248    70.016     0.200
     2.248    70.312     0.200
     3.099    92.492     0.200
     3.099    92.391     0.200
     3.480   102.992     0.200
     0.288    12.044     0.200
     0.288    12.145     0.200
     1.752    53.145     0.200
     2.666    80.744     0.200
     2.666    80.444     0.200
     3.388   102.544     0.200
     4.330   129.145     0.200
     5.346   161.345     0.200
     1.085    35.416     0.200
     1.602    49.616     0.200
    10.152   292.016     0.200
     0.360    11.203     0.200
     0.360    12.109     0.200
     2.300    72.508     0.200
     2.300    72.609     0.200
     2.776    84.805     0.200
     2.776    85.008     0.200
     2.980    90.609     0.200
     3.497   104.109     0.200
     0.641    20.570     0.200
     0.641    21.164     0.200
     2.034    64.469     0.200
     3.598   108.664     0.200
     5.186   156.367     0.200
     7.530   220.664     0.200
     0.369    12.904     0.200
     0.848    27.604     0.200
     2.291    72.504     0.200
     2.785    84.804     0.200
     0.628    21.395     0.200
     3.116    93.797     0.200
     3.116    94.195     0.200
     8.580   252.098     0.200
     0.504    16.435     0.200
     0.504    14.935     0.200
     1.239    40.635     0.200
     2.103    66.135     0.200
     0.469    15.082     0.200
     0.469    14.879     0.200
     0.974    30.980     0.200
     1.521    47.980     0.200
     2.198    70.781     0.200
     2.786    85.180     0.200
     3.584   105.082     0.200
     5.277   154.781     0.200
     0.340    10.961     0.200
     0.340    11.461     0.200
     1.666    52.062     0.200
     2.348    73.762     0.200
     2.805    85.660     0.200
     3.417   100.660     0.200
     3.417    99.363     0.200
     8.145   236.961     0.200
     0.324    10.961     0.200
     0.794    25.859     0.200
     2.349    73.762     0.200
     2.349    74.160     0.200
     2.776    84.961     0.200
     3.485   106.359     0.200
     7.821   233.160     0.200
     0.327    11.041     0.200
     2.344    73.941     0.200
     2.344    74.541     0.200
     3.485   106.441     0.200
     6.999   203.141     0.200
     0.472    15.219     0.200
     1.010    33.023     0.200
     1.486    46.719     0.200
     2.204    69.219     0.200
     0.463    15.090     0.200
     1.004    32.691     0.200
     2.212    69.191     0.200
     2.212    68.990     0.200
     0.540    17.283     0.200
     1.138    36.182     0.200
     1.384    44.082     0.200
     2.190    70.783     0.200
     0.399    12.641     0.200
     0.908    28.938     0.200
     2.260    71.836     0.200
     0.592    18.680     0.200
     1.114    35.582     0.200
     2.113    67.281     0.200
     2.790    85.582     0.200
     0.694    22.203     0.200
     0.694    22.500     0.200
     1.412    44.402     0.200
     2.216    69.402     0.200
     2.262    71.703     0.200
     2.322    73.301     0.200
     2.430    75.602     0.200
     2.430    76.703     0.200
     0.722    23.184     0.200
     2.239    70.383     0.200
     2.256    72.383     0.200
     2.256    71.684     0.200
     2.302    72.383     0.200
     2.302    73.285     0.200
     2.405    75.484     0.200
     2.405    76.086     0.200
     3.645   110.285     0.200
     4.012   122.484     0.200
     5.975   173.684     0.200
     0.309    10.281     0.200
     1.147    36.582     0.200
     1.257    40.180     0.200
     2.045    64.281     0.200
     2.450    75.582     0.200
     2.498    79.281     0.200
     0.370    11.901     0.200
     0.370    12.001     0.200
     1.546    48.701     0.200
     2.288    72.101     0.200
     2.288    72.601     0.200
     2.753    84.501     0.200
     0.318    10.355     0.200
     1.148    36.656     0.200
     2.043    64.059     0.200
     2.459    75.758     0.200
     2.485    79.258     0.200
     3.844   117.258     0.200
     0.310    10.250     0.200
     1.151    36.547     0.200
     1.253    39.547     0.200
     1.253    39.250     0.200
     2.049    64.250     0.200
     2.446    74.848     0.200
     2.446    75.348     0.200
     2.500    79.047     0.200
     2.500    79.148     0.200
     2.498    78.148     0.200
     0.316    10.402     0.200
     0.316    10.504     0.200
     1.152    36.504     0.200
     1.253    40.004     0.200
     1.253    40.305     0.200
     2.048    64.004     0.200
     2.450    75.105     0.200
     2.450    75.305     0.200
     2.498    78.305     0.200
     2.494    79.305     0.200
     3.830   114.703     0.200
     0.351    11.691     0.200
     0.881    28.291     0.200
     2.307    72.391     0.200
     0.378    12.035     0.200
     0.899    28.535     0.200
     1.550    49.336     0.200
     2.280    72.135     0.200
     2.760    84.734     0.200
     0.525    16.934     0.200
     0.525    16.434     0.200
     1.011    32.336     0.200
     1.398    44.336     0.200
     2.287    71.637     0.200
     2.284    71.637     0.200
     2.284    70.535     0.200
     2.441    77.336     0.200
     4.072   124.234     0.200
     0.472    15.712     0.200
     0.472    15.611     0.200
     1.057    33.712     0.200
     1.434    45.111     0.200
     1.434    44.512     0.200
     1.875    59.312     0.200
     2.223    69.611     0.200
     2.783    83.812     0.200
     0.460    15.750     0.200
     0.915    29.352     0.200
     1.065    35.352     0.200
     2.064    66.945     0.200
     2.064    66.648     0.200
     2.240    67.648     0.200
     3.401   103.148     0.200
     3.576   108.445     0.200
     8.950   261.445     0.200
     0.775    25.047     0.200
     1.151    38.242     0.200
     2.242    70.242     0.200
     2.242    68.945     0.200
     3.188    96.844     0.200
     3.188    96.648     0.200
     4.513   136.148     0.200
     8.481   251.648     0.200
     0.542    17.484     0.200
     1.163    37.188     0.200
     1.355    42.688     0.200
     1.967    62.383     0.200
     2.205    70.383     0.200
     2.205    70.586     0.200
     2.683    82.188     0.200
     0.632    20.672     0.200
     1.168    38.172     0.200
     1.168    37.871     0.200
     1.350    43.070     0.200
     2.275    72.172     0.200
     2.275    72.469     0.200
     2.369    74.871     0.200
     2.369    74.270     0.200
     2.487    78.270     0.200
     0.328    10.773     0.200
     1.166    36.977     0.200
     1.240    38.578     0.200
     2.060    64.273     0.200
     2.443    75.078     0.200
     2.485    78.375     0.200
     2.494    78.773     0.200
     0.634    20.316     0.200
     1.203    37.914     0.200
     1.379    44.816     0.200
     2.118    68.617     0.200
     0.195     7.411     0.200
     1.015    32.110     0.200
     1.384    44.110     0.200
     2.522    76.511     0.200
     0.735    23.387     0.200
     0.735    23.787     0.200
     1.039    33.887     0.200
     1.039    32.587     0.200
     1.492    47.287     0.200
     2.307    72.887     0.200
     2.229    71.287     0.200
     2.229    70.787     0.200
     2.322    73.487     0.200
     2.465    76.587     0.200
     2.343    74.387     0.200
     2.343    73.787     0.200
     0.837    27.000     0.200
     0.837    27.102     0.200
     1.301    41.699     0.200
     1.463    47.199     0.200
     1.463    45.801     0.200
     8.400   254.824     0.200
     0.503    16.375     0.200
     1.104    35.578     0.200
     1.399    44.273     0.200
     1.399    44.078     0.200
     1.915    60.773     0.200
     2.212    70.375     0.200
     2.212    69.672     0.200
     3.715   110.773     0.200
     3.715   107.375     0.200
     8.124   240.578     0.200
     8.172   237.672     0.200
     0.692    22.195     0.200
     1.132    36.492     0.200
     1.410    44.695     0.200
     2.215    69.895     0.200
     2.263    73.195     0.200
     2.323    74.293     0.200
     2.431    77.195     0.200
     0.549    17.684     0.200
     1.143    36.383     0.200
     2.165    67.684     0.200
     2.363    74.582     0.200
     2.367    75.582     0.200
     2.476    76.082     0.200
     0.280    11.018     0.200
     0.659    21.219     0.200
     2.737    82.619     0.200
     2.737    82.918     0.200
     0.326    11.195     0.200
     0.618    20.695     0.200
     3.038    91.895     0.200
     3.620   107.094     0.200
     1.078    34.354     0.200
     1.304    42.152     0.200
     1.632    51.053     0.200
     2.300    73.254     0.200
     2.367    75.553     0.200
     2.364    75.053     0.200
     0.773    25.484     0.200
     0.827    26.578     0.200
     2.045    65.781     0.200
     2.237    68.078     0.200
     2.237    70.680     0.200
     2.205    69.078     0.200
     2.484    77.883     0.200
     3.916   116.984     0.200
     0.149     5.344     0.200
     1.371    43.750     0.200
     1.371    42.750     0.200
     1.953    61.945     0.200
     2.474    76.344     0.200
     2.474    75.945     0.200
     8.331   244.148     0.200
     9.435   277.047     0.200
     0.156     5.477     0.200
     1.358    42.977     0.200
     1.966    61.883     0.200
     1.966    63.578     0.200
     2.462    76.281     0.200
     0.738    24.133     0.200
     1.132    35.531     0.200
     1.950    62.332     0.200
     0.275     9.393     0.200
     0.692    22.492     0.200
     1.254    40.692     0.200
     3.085    94.093     0.200
     3.534   106.393     0.200
     4.749   142.893     0.200
     0.718    22.625     0.200
     0.718    23.625     0.200
     1.212    38.930     0.200
     1.379    43.625     0.200
     2.157    68.625     0.200
     2.176    70.125     0.200
     2.390    76.125     0.200
     2.481    78.930     0.200
     7.532   222.125     0.200
     0.541    17.416     0.200
     1.120    35.116     0.200
     1.407    44.416     0.200
     2.177    70.116     0.200
     0.310    10.891     0.200
     0.733    23.789     0.200
     2.393    75.391     0.200
     0.327    10.980     0.200
     1.628    52.180     0.200
     2.370    75.379     0.200
     2.801    85.777     0.200
     0.318    10.352     0.200
     1.548    49.055     0.200
     2.340    73.754     0.200
     0.778    25.059     0.200
     0.935    30.158     0.200
     2.129    68.158     0.200
     2.255    71.359     0.200
     2.374    73.758     0.200
     2.403    75.359     0.200
     2.404    75.258     0.200
     0.603    19.615     0.200
     1.054    33.814     0.200
     2.254    69.914     0.200
     2.275    72.115     0.200
     2.407    74.215     0.200
     2.413    76.414     0.200
     2.423    75.914     0.200
     0.309    10.235     0.200
     0.890    28.435     0.200
     2.349    74.036     0.200
     0.330    10.477     0.200
     0.872    27.777     0.200
     2.328    74.074     0.200
     0.137     5.121     0.200
     0.964    32.012     0.200
     3.325   101.551     0.200
     3.441   103.980     0.200
     0.786    25.508     0.200
     0.927    30.203     0.200
     2.245    70.602     0.200
     2.369    73.602     0.200
     2.413    76.008     0.200
     2.406    77.406     0.200
     0.599    19.098     0.200
     1.163    37.000     0.200
     1.400    45.098     0.200
     2.133    68.699     0.200
     0.583    18.758     0.200
     1.154    36.660     0.200
     1.398    44.859     0.200
     2.147    68.660     0.200
     0.535    17.383     0.200
     1.000    32.281     0.200
     1.409    45.078     0.200
     2.242    71.680     0.200
     2.276    70.883     0.200
     2.431    77.078     0.200
     0.758    23.812     0.200
     0.913    29.016     0.200
     1.573    48.715     0.200
     2.117    67.312     0.200
     2.255    70.516     0.200
     2.336    72.715     0.200
     2.413    74.715     0.200
     2.444    76.414     0.200
     0.331    12.441     0.200
     0.331    12.842     0.200
     0.635    20.441     0.200
     1.803    55.041     0.200
     2.733    82.842     0.200
     1.219    39.631     0.200
     2.113    66.230     0.200
     0.127     7.966     0.200
     0.127     8.066     0.200
     1.964    60.066     0.200
     7.712   232.485     0.200
     0.103     5.992     0.200
     0.836    27.391     0.200
     1.074    34.289     0.200
     2.490    78.594     0.200
     2.801    84.891     0.200
     0.603    19.389     0.200
     1.230    39.488     0.200
     1.316    42.088     0.200
     2.021    63.588     0.200
     2.181    69.389     0.200
     0.621    19.973     0.200
     1.244    39.875     0.200
     1.313    41.875     0.200
     2.030    64.172     0.200
     2.169    69.574     0.200
     2.682    82.375     0.200
     0.175     6.684     0.200
     0.828    27.184     0.200
     2.820    85.484     0.200
     3.290    99.184     0.200
     0.795    25.727     0.200
     1.331    42.227     0.200
     1.360    43.328     0.200
     2.036    66.227     0.200
     2.485    78.828     0.200
     0.811    25.875     0.200
     0.811    26.074     0.200
     1.368    43.676     0.200
     1.338    42.676     0.200
     1.338    42.273     0.200
     2.091    66.273     0.200
     2.091    66.477     0.200
     2.488    79.074     0.200
     2.488    78.875     0.200
     0.818    26.547     0.200
     1.341    42.645     0.200
     2.015    65.344     0.200
     2.093    66.047     0.200
     2.093    67.047     0.200
     2.489    78.645     0.200
     2.489    78.047     0.200
     8.838   257.047     0.200
     0.797    25.676     0.200
     1.329    42.074     0.200
     1.363    43.277     0.200
     2.036    64.676     0.200
     2.092    66.074     0.200
     2.482    78.176     0.200
     0.804    26.055     0.200
     1.329    42.254     0.200
     1.369    43.355     0.200
     2.031    65.055     0.200
     2.096    66.555     0.200
     2.481    78.652     0.200
     0.787    25.484     0.200
     1.345    42.883     0.200
     1.344    42.281     0.200
     2.032    64.484     0.200
     2.073    65.484     0.200
     0.799    26.023     0.200
     1.339    42.324     0.200
     2.028    64.723     0.200
     2.085    66.125     0.200
     2.492    78.922     0.200
     0.793    25.531     0.200
     1.348    42.633     0.200
     2.026    64.828     0.200
     2.073    65.430     0.200
     0.797    25.781     0.200
     1.346    42.481     0.200
     2.024    64.781     0.200
     2.077    65.281     0.200
     2.500    79.381     0.200
     0.806    26.125     0.200
     1.344    42.523     0.200
     1.360    42.922     0.200
     2.020    65.125     0.200
     2.083    65.723     0.200
     2.495    78.824     0.200
     0.802    25.961     0.200
     1.330    42.461     0.200
     1.367    43.859     0.200
     2.032    66.562     0.200
     2.094    66.258     0.200
     0.808    26.029     0.200
     0.808    26.229     0.200
     1.366    43.529     0.200
     1.337    42.529     0.200
     1.337    43.029     0.200
     2.090    67.129     0.200
     2.090    66.930     0.200
     2.024    65.329     0.200
     2.488    78.729     0.200
     0.804    26.068     0.200
     1.344    42.770     0.200
     1.359    43.270     0.200
     2.021    64.469     0.200
     2.083    65.969     0.200
     2.495    79.369     0.200
     0.810    26.151     0.200
     1.344    42.951     0.200
     1.363    43.052     0.200
     2.017    64.852     0.200
     2.085    66.151     0.200
     2.495    78.251     0.200
     0.820    26.342     0.200
     0.820    26.541     0.200
     1.369    44.041     0.200
     1.347    42.842     0.200
     2.088    66.842     0.200
     2.088    66.141     0.200
     2.009    65.342     0.200
     2.494    78.742     0.200
     7.425   221.742     0.200
     1.352    43.091     0.200
     1.343    42.391     0.200
     2.027    64.691     0.200
     2.078    65.891     0.200
     2.497    78.791     0.200
     0.785    25.445     0.200
     1.318    41.352     0.200
     1.361    43.250     0.200
     2.052    65.547     0.200
     2.096    66.547     0.200
     0.812    26.220     0.200
     1.341    42.820     0.200
     1.367    43.620     0.200
     2.089    66.620     0.200
     0.810    26.477     0.200
     1.344    42.875     0.200
     1.363    43.477     0.200
     2.018    65.078     0.200
     2.086    65.672     0.200
     2.494    79.578     0.200
     0.701    22.359     0.200
     0.701    22.961     0.200
     1.228    39.059     0.200
     1.228    39.961     0.200
     2.175    69.660     0.200
     2.175    69.059     0.200
     2.137    66.758     0.200
     2.137    68.559     0.200
     2.409    76.258     0.200
    10.045   295.258     0.200
     0.246     8.312     0.200
     1.080    35.383     0.200
     1.080    34.973     0.200
     1.080    35.184     0.200
     3.247    97.562     0.200
     3.468   103.195     0.200
     3.494   106.383     0.200
     6.344   192.484     0.200
     7.024   213.488     0.200
     0.315    10.354     0.200
     1.156    36.455     0.200
     1.248    39.854     0.200
     2.053    64.354     0.200
     2.444    75.455     0.200
     2.494    78.654     0.200
     0.844    27.139     0.200
     0.893    28.739     0.200
     1.640    51.739     0.200
     2.074    65.939     0.200
     2.191    68.439     0.200
     2.361    72.839     0.200
     2.405    76.339     0.200
     2.463    76.939     0.200
     0.093     4.867     0.200
     0.944    29.965     0.200
     1.878    58.664     0.200
     1.878    59.867     0.200
     0.552    18.926     0.200
     3.030    88.629     0.200
     0.606    20.230     0.200
     1.166    38.859     0.200
     1.166    38.230     0.200
     2.604    79.469     0.200
     2.969    87.531     0.200
     5.641   170.629     0.200
     0.786    25.692     0.200
     0.930    30.093     0.200
     1.583    50.293     0.200
     2.122    68.093     0.200
     2.247    70.893     0.200
     2.373    74.293     0.200
     2.411    75.492     0.200
     2.403    76.492     0.200
     0.368    12.039     0.200
     0.368    11.938     0.200
     0.831    26.539     0.200
     1.609    51.039     0.200
     2.294    72.641     0.200
     2.294    72.336     0.200
     2.793    85.641     0.200
     3.477   102.641     0.200
     0.489    17.586     0.200
     1.034    32.773     0.200
     1.248    40.465     0.200
     2.995    89.824     0.200
     3.160    95.785     0.200
     1.063    34.711     0.200
     1.063    34.812     0.200
     7.590   229.516     0.200
     0.299     9.781     0.200
     0.299     9.586     0.200
     1.286    40.984     0.200
     2.015    63.680     0.200
     2.479    76.586     0.200
     2.479    77.180     0.200
     2.478    78.680     0.200
     2.478    78.883     0.200
     0.365    13.359     0.200
     2.810    84.660     0.200
     2.810    84.461     0.200
     3.273    99.559     0.200
     7.480   223.805     0.200
     0.520    16.913     0.200
     1.221    39.312     0.200
     2.114    65.812     0.200
     0.923    29.906     0.200
     0.947    30.707     0.200
     2.060    66.309     0.200
     2.142    68.105     0.200
     2.321    74.605     0.200
     2.438    75.809     0.200
     2.496    79.605     0.200
     0.231     8.070     0.200
     0.231     7.570     0.200
     0.953    30.773     0.200
     1.452    46.977     0.200
     2.437    76.977     0.200
     2.437    76.875     0.200
     7.910   236.719     0.200
     0.224     7.344     0.200
     0.952    30.445     0.200
     1.452    45.945     0.200
     2.444    76.945     0.200
     0.227     7.438     0.200
     0.951    30.438     0.200
     1.454    46.141     0.200
     1.454    46.938     0.200
     2.441    76.844     0.200
     2.441    77.039     0.200
     7.905   236.188     0.200
     0.218     7.195     0.200
     0.950    30.398     0.200
     1.454    45.195     0.200
     1.454    46.398     0.200
     2.450    77.000     0.200
     2.450    77.602     0.200
     0.219     7.398     0.200
     0.219     7.500     0.200
     0.958    30.898     0.200
     1.446    45.602     0.200
     2.451    77.000     0.200
     0.212     7.119     0.200
     0.942    30.220     0.200
     1.461    44.920     0.200
     1.461    45.920     0.200
     2.453    75.920     0.200
     2.453    76.819     0.200
     7.890   234.464     0.200
     0.223     7.188     0.200
     0.948    30.787     0.200
     1.456    46.986     0.200
     2.444    76.986     0.200
     0.957    30.438     0.200
     1.866    58.336     0.200
     2.480    76.438     0.200
     0.210     7.141     0.200
     0.938    30.242     0.200
     1.464    46.840     0.200
     2.455    77.441     0.200
     0.233     7.641     0.200
     0.950    30.641     0.200
     1.456    46.938     0.200
     2.434    76.938     0.200
     0.212     7.750     0.200
     0.953    30.555     0.200
     1.856    58.453     0.200
     2.457    77.250     0.200
     0.216     7.066     0.200
     0.216     7.168     0.200
     0.934    30.566     0.200
     1.469    47.168     0.200
     2.447    76.969     0.200
     2.613    80.270     0.200
     7.887   237.785     0.200
     0.216     7.465     0.200
     0.939    30.566     0.200
     1.464    46.266     0.200
     2.448    76.965     0.200
     0.219     7.398     0.200
     0.948    30.492     0.200
     1.456    45.594     0.200
     1.456    46.797     0.200
     2.448    76.992     0.200
     0.225     7.266     0.200
     0.954    30.766     0.200
     1.450    46.469     0.200
     2.444    77.062     0.200
     0.204     7.098     0.200
     0.956    30.297     0.200
     2.466    76.896     0.200
     0.227     7.422     0.200
     0.227     7.223     0.200
     0.954    30.723     0.200
     1.451    45.922     0.200
     1.451    46.223     0.200
     2.442    77.223     0.200
     0.219     7.279     0.200
     0.954    30.279     0.200
     1.450    46.680     0.200
     2.449    77.479     0.200
     2.449    78.080     0.200
     0.361    11.824     0.200
     1.165    37.123     0.200
     1.251    39.225     0.200
     2.047    63.523     0.200
     2.445    77.424     0.200
     2.481    76.523     0.200
     2.491    78.523     0.200
     0.369    12.223     0.200
     0.369    12.021     0.200
     1.170    37.422     0.200
     1.247    39.422     0.200
     2.050    65.021     0.200
     2.050    64.723     0.200
     2.439    77.322     0.200
     2.439    77.623     0.200
     2.482    76.123     0.200
     2.482    76.822     0.200
     2.487    78.422     0.200
     0.207     6.863     0.200
     0.939    30.062     0.200
     1.463    46.062     0.200
     2.458    77.164     0.200
     0.237     7.276     0.200
     0.950    30.676     0.200
     1.457    46.776     0.200
     2.431    77.076     0.200
     0.372    11.875     0.200
     1.245    39.176     0.200
     1.173    36.875     0.200
     2.052    64.277     0.200
     2.439    77.176     0.200
     2.439    76.777     0.200
     2.485    77.578     0.200
     2.485    78.078     0.200
     2.481    76.375     0.200
     0.225     7.367     0.200
     0.943    30.168     0.200
     1.461    46.469     0.200
     2.441    77.066     0.200
     0.224     7.102     0.200
     0.946    30.203     0.200
     1.458    46.902     0.200
     2.443    77.402     0.200
     0.210     7.109     0.200
     0.938    30.109     0.200
     1.464    46.508     0.200
     2.455    77.305     0.200
     0.221     7.324     0.200
     0.940    30.125     0.200
     1.464    46.824     0.200
     1.464    46.523     0.200
     2.444    76.922     0.200
     0.215     7.078     0.200
     0.215     7.279     0.200
     1.459    46.879     0.200
     2.451    76.879     0.200
     7.894   237.098     0.200
     0.689    21.902     0.200
     1.131    36.102     0.200
     1.131    36.203     0.200
     1.409    45.000     0.200
     2.266    71.703     0.200
     2.266    70.801     0.200
     2.322    73.801     0.200
     0.660    21.883     0.200
     0.660    21.586     0.200
     1.126    36.586     0.200
     1.394    44.289     0.200
     2.209    69.086     0.200
     2.209    69.789     0.200
     2.292    72.188     0.200
     2.292    72.789     0.200
     2.325    73.789     0.200
     0.679    21.859     0.200
     1.129    35.957     0.200
     1.404    45.059     0.200
     2.213    70.359     0.200
     2.276    71.957     0.200
     2.323    74.156     0.200
     2.435    77.559     0.200
     0.673    21.746     0.200
     1.125    35.746     0.200
     1.402    44.848     0.200
     2.214    70.348     0.200
     2.321    74.047     0.200
     2.284    74.047     0.200
     2.436    76.949     0.200
     0.894    28.184     0.200
     1.178    37.383     0.200
     3.094    94.684     0.200
     8.292   248.178     0.200
     0.681    21.641     0.200
     1.123    35.945     0.200
     1.409    44.844     0.200
     2.219    69.539     0.200
     2.280    72.742     0.200
     2.317    73.945     0.200
     2.430    76.742     0.200
     0.670    21.695     0.200
     0.670    21.095     0.200
     1.120    35.895     0.200
     1.120    35.095     0.200
     1.404    45.195     0.200
     2.291    72.895     0.200
     2.218    69.794     0.200
     2.317    73.995     0.200
     2.317    73.095     0.200
     2.433    77.095     0.200
     2.433    76.695     0.200
     0.658    20.941     0.200
     0.658    20.840     0.200
     1.122    35.340     0.200
     2.212    68.941     0.200
     2.212    68.742     0.200
     2.298    71.742     0.200
     2.298    71.543     0.200
     2.321    73.141     0.200
     2.321    72.941     0.200
     2.440    76.543     0.200
     2.440    75.941     0.200
     8.393   249.734     0.200
     0.237     7.434     0.200
     0.962    30.730     0.200
     1.444    45.434     0.200
     2.435    76.633     0.200
     0.659    20.711     0.200
     1.132    35.914     0.200
     1.390    44.016     0.200
     2.287    71.914     0.200
     2.330    73.812     0.200
     2.447    77.211     0.200
     8.392   249.453     0.200
     0.668    21.641     0.200
     1.118    35.641     0.200
     1.404    44.547     0.200
     2.219    70.242     0.200
     2.294    73.641     0.200
     2.315    74.141     0.200
     2.433    77.445     0.200
     0.663    21.680     0.200
     0.663    21.484     0.200
     1.133    35.883     0.200
     1.133    36.086     0.200
     2.204    68.781     0.200
     2.204    69.383     0.200
     2.330    73.383     0.200
     2.330    73.586     0.200
     2.283    72.281     0.200
     2.283    71.883     0.200
     0.690    22.195     0.200
     1.140    36.094     0.200
     1.404    44.891     0.200
     2.207    69.695     0.200
     2.257    70.992     0.200
     2.330    73.891     0.200
     0.689    22.208     0.200
     1.122    36.008     0.200
     1.414    44.908     0.200
     2.222    70.008     0.200
     2.275    73.008     0.200
     2.314    73.308     0.200
     0.654    20.551     0.200
     0.654    20.951     0.200
     1.111    35.551     0.200
     1.111    35.251     0.200
     1.399    44.051     0.200
     2.312    73.251     0.200
     2.312    73.051     0.200
     2.220    69.451     0.200
     2.220    70.051     0.200
     2.499    77.751     0.200
     2.499    77.951     0.200
     0.674    21.828     0.200
     1.109    35.328     0.200
     1.413    45.023     0.200
     2.298    73.125     0.200
     2.306    73.422     0.200
     0.677    21.508     0.200
     1.110    36.109     0.200
     1.414    45.109     0.200
     2.228    70.609     0.200
     2.294    73.305     0.200
     2.306    73.711     0.200
     0.681    21.436     0.200
     1.129    36.136     0.200
     1.406    43.636     0.200
     2.214    68.836     0.200
     2.274    71.836     0.200
     2.322    73.436     0.200
     0.466    15.223     0.200
     1.227    39.223     0.200
     2.059    63.523     0.200
     2.059    63.625     0.200
     8.796   259.367     0.200
     0.667    21.855     0.200
     0.667    21.754     0.200
     1.139    36.355     0.200
     1.139    36.254     0.200
     1.391    44.652     0.200
     2.201    69.355     0.200
     2.275    72.152     0.200
     2.275    72.254     0.200
     2.334    73.754     0.200
     0.687    21.496     0.200
     1.110    36.098     0.200
     1.421    45.496     0.200
     2.232    70.996     0.200
     2.304    73.496     0.200
     2.287    72.695     0.200
     0.653    21.023     0.200
     1.124    36.223     0.200
     1.391    44.324     0.200
     2.208    69.523     0.200
     2.299    73.223     0.200
     2.325    73.621     0.200
     0.659    21.402     0.200
     1.122    35.805     0.200
     1.396    44.504     0.200
     2.212    70.203     0.200
     2.297    72.102     0.200
     2.322    73.902     0.200
     0.699    22.539     0.200
     1.129    36.438     0.200
     1.417    44.742     0.200
     2.220    69.641     0.200
     2.260    71.539     0.200
     2.318    73.641     0.200
     0.701    22.394     0.200
     1.092    34.894     0.200
     1.441    45.494     0.200
     2.252    70.294     0.200
     2.284    71.894     0.200
     2.295    72.494     0.200
     0.662    21.570     0.200
     1.116    35.869     0.200
     1.401    44.770     0.200
     2.218    70.369     0.200
     2.315    73.770     0.200
     2.300    73.070     0.200
     0.664    21.465     0.200
     0.664    20.566     0.200
     1.141    36.863     0.200
     1.387    44.465     0.200
     2.198    68.965     0.200
     2.198    68.664     0.200
     2.276    70.766     0.200
     2.276    72.164     0.200
     2.337    74.066     0.200
     8.785   256.363     0.200
     0.656    21.086     0.200
     1.143    36.586     0.200
     1.381    43.988     0.200
     2.193    69.289     0.200
     2.280    72.289     0.200
     2.341    74.289     0.200
     0.658    21.305     0.200
     0.658    21.102     0.200
     1.129    35.703     0.200
     1.391    44.508     0.200
     2.206    69.008     0.200
     2.206    70.203     0.200
     2.291    72.805     0.200
     2.291    71.906     0.200
     2.328    74.008     0.200
     0.658    21.281     0.200
     1.144    36.883     0.200
     2.193    68.883     0.200
     2.278    71.984     0.200
     2.341    73.883     0.200
     0.697    22.582     0.200
     1.099    35.383     0.200
     1.434    46.082     0.200
     2.244    71.383     0.200
     2.291    72.480     0.200
     0.689    22.406     0.200
     0.689    22.008     0.200
     1.105    35.605     0.200
     1.105    35.707     0.200
     1.425    45.605     0.200
     2.236    70.805     0.200
     2.236    70.105     0.200
     2.291    72.105     0.200
     2.299    73.508     0.200
     0.692    22.511     0.200
     1.098    35.311     0.200
     1.431    45.611     0.200
     2.243    71.211     0.200
     2.292    72.911     0.200
     2.295    73.211     0.200
     0.660    21.363     0.200
     1.153    36.662     0.200
     1.377    44.363     0.200
     2.186    69.963     0.200
     2.267    72.363     0.200
     2.349    74.963     0.200
     0.666    21.254     0.200
     1.142    36.854     0.200
     1.388    44.154     0.200
     2.198    69.254     0.200
     2.273    72.454     0.200
     2.337    74.354     0.200
     0.655    21.090     0.200
     1.142    36.793     0.200
     1.381    43.992     0.200
     2.194    69.293     0.200
     2.282    72.793     0.200
     2.340    74.090     0.200
     0.705    22.579     0.200
     0.705    22.880     0.200
     1.118    35.880     0.200
     1.118    35.779     0.200
     1.427    45.979     0.200
     2.232    71.180     0.200
     2.232    70.680     0.200
     2.267    72.979     0.200
     2.267    72.079     0.200
     2.307    72.979     0.200
    10.849   322.779     0.200
     0.689    22.227     0.200
     1.113    35.430     0.200
     2.230    71.031     0.200
     2.283    71.828     0.200
     0.696    22.385     0.200
     1.123    36.785     0.200
     2.224    70.485     0.200
     2.269    72.385     0.200
     0.695    22.059     0.200
     1.090    35.160     0.200
     2.251    71.059     0.200
     2.301    72.959     0.200
     2.499    78.059     0.200
     0.662    21.113     0.200
     1.138    36.516     0.200
     1.388    44.316     0.200
     2.200    69.613     0.200
     2.280    72.516     0.200
     0.679    21.812     0.200
     1.103    35.211     0.200
     1.420    45.211     0.200
     2.235    70.711     0.200
     2.299    72.617     0.200
     2.300    73.117     0.200
     0.711    22.830     0.200
     1.114    35.630     0.200
     1.434    45.830     0.200
     2.238    70.729     0.200
     2.267    72.130     0.200
     2.301    73.229     0.200
     0.698    22.477     0.200
     1.090    34.680     0.200
     1.440    45.477     0.200
     2.252    70.883     0.200
     2.283    72.977     0.200
     2.299    73.281     0.200
     0.740    23.592     0.200
     1.122    36.292     0.200
     1.449    46.392     0.200
     2.243    71.192     0.200
     2.240    70.292     0.200
     0.764    23.727     0.200
     1.449    46.629     0.200
     2.229    71.129     0.200
     2.198    70.629     0.200
     2.593    79.828     0.200
     0.689    22.459     0.200
     1.122    36.061     0.200
     1.415    45.561     0.200
     2.223    70.760     0.200
     2.275    73.160     0.200
     0.679    21.969     0.200
     1.124    35.770     0.200
     1.408    45.168     0.200
     2.218    70.066     0.200
     2.280    72.469     0.200
     0.698    22.445     0.200
     1.118    36.148     0.200
     1.423    45.750     0.200
     2.272    72.750     0.200
     2.229    70.445     0.200
     0.690    22.211     0.200
     1.090    35.305     0.200
     1.090    35.109     0.200
     1.435    45.508     0.200
     2.249    70.305     0.200
     2.249    71.008     0.200
     2.304    72.109     0.200
     2.304    72.508     0.200
     2.285    72.305     0.200
     2.497    77.711     0.200
     0.721    23.383     0.200
     1.122    36.281     0.200
     1.436    45.883     0.200
     2.235    70.281     0.200
     2.252    71.883     0.200
     2.306    73.582     0.200
     0.710    23.273     0.200
     1.103    35.672     0.200
     1.440    45.570     0.200
     2.246    71.273     0.200
     2.292    73.375     0.200
     2.277    73.070     0.200
     3.636   111.172     0.200
     0.696    22.602     0.200
     0.696    22.297     0.200
     1.102    35.102     0.200
     1.102    35.000     0.200
     1.431    45.898     0.200
     2.289    72.797     0.200
     2.289    70.797     0.200
     2.294    72.195     0.200
     2.242    71.195     0.200
     0.708    22.781     0.200
     1.111    35.781     0.200
     1.434    46.078     0.200
     2.239    71.375     0.200
     2.300    72.680     0.200
     2.271    72.875     0.200
     0.714    23.047     0.200
     1.100    34.742     0.200
     1.444    45.844     0.200
     2.250    71.047     0.200
     2.288    72.844     0.200
     2.277    72.148     0.200
     0.701    22.496     0.200
     0.701    22.797     0.200
     1.108    35.598     0.200
     1.108    35.297     0.200
     1.431    45.896     0.200
     2.279    72.598     0.200
     2.239    71.297     0.200
     2.298    73.297     0.200
     0.712    22.933     0.200
     1.099    34.632     0.200
     1.443    46.033     0.200
     2.250    70.833     0.200
     2.279    72.632     0.200
     0.706    22.660     0.200
     1.106    35.260     0.200
     2.242    70.760     0.200
     2.278    72.559     0.200
     2.295    73.160     0.200
     0.667    21.477     0.200
     1.123    36.379     0.200
     1.400    44.879     0.200
     2.214    70.379     0.200
     2.289    72.879     0.200
     2.321    74.180     0.200
     0.713    23.188     0.200
     1.096    35.492     0.200
     1.446    46.688     0.200
     2.253    72.086     0.200
     2.285    72.891     0.200
     2.282    73.289     0.200
     0.700    22.758     0.200
     0.700    22.458     0.200
     1.108    35.358     0.200
     1.108    35.258     0.200
     1.431    46.058     0.200
     2.298    73.058     0.200
     2.280    72.358     0.200
     2.280    71.358     0.200
     2.239    71.658     0.200
     8.435   251.902     0.200
     0.710    22.863     0.200
     1.103    35.164     0.200
     1.440    46.264     0.200
     2.246    71.563     0.200
     2.291    73.363     0.200
     2.278    72.063     0.200
     0.720    23.168     0.200
     1.102    35.668     0.200
     1.447    46.367     0.200
     2.251    71.168     0.200
     2.272    72.768     0.200
     0.708    22.840     0.200
     1.103    35.340     0.200
     1.439    46.242     0.200
     2.245    71.141     0.200
     2.292    73.543     0.200
     2.279    72.340     0.200
     0.696    22.398     0.200
     1.091    34.797     0.200
     1.438    45.797     0.200
     2.251    71.197     0.200
     2.284    72.898     0.200
     2.300    72.998     0.200
     2.399    76.197     0.200
     0.700    22.338     0.200
     1.090    35.037     0.200
     1.090    35.238     0.200
     1.441    45.938     0.200
     2.282    72.938     0.200
     2.282    72.238     0.200
     2.297    74.137     0.200
     2.297    72.238     0.200
     2.396    76.238     0.200
     2.396    75.637     0.200
     2.253    70.738     0.200
     2.253    70.637     0.200
     0.685    22.115     0.200
     1.090    34.715     0.200
     1.432    45.516     0.200
     2.248    71.115     0.200
     2.286    72.715     0.200
     2.308    73.414     0.200
     2.404    76.016     0.200
     2.493    77.516     0.200
     4.049   118.516     0.200
     0.673    21.641     0.200
     1.110    35.836     0.200
     1.411    44.539     0.200
     2.226    70.336     0.200
     2.298    72.641     0.200
     2.308    73.234     0.200
     0.217     7.355     0.200
     0.951    30.555     0.200
     1.452    46.355     0.200
     2.451    76.855     0.200
     0.697    22.523     0.200
     1.103    35.523     0.200
     1.431    45.719     0.200
     2.241    70.523     0.200
     2.295    73.422     0.200
     2.287    72.820     0.200
     0.353    11.684     0.200
     1.252    40.184     0.200
     2.045    63.984     0.200
     2.452    77.184     0.200
     2.477    76.387     0.200
     2.494    78.387     0.200
     8.098   244.930     0.200
     0.650    20.305     0.200
     1.142    36.508     0.200
     1.378    43.805     0.200
     2.192    68.805     0.200
     2.285    72.602     0.200
     2.341    74.102     0.200
     0.666    22.045     0.200
     1.378    44.545     0.200
     2.184    69.245     0.200
     2.259    72.045     0.200
     2.352    74.345     0.200
     0.224     7.367     0.200
     1.443    46.367     0.200
     2.448    77.266     0.200
     0.633    20.805     0.200
     1.196    38.705     0.200
     1.332    42.404     0.200
     2.140    68.104     0.200
     2.250    72.104     0.200
     2.395    75.705     0.200
     0.660    21.601     0.200
     1.125    36.401     0.200
     1.395    44.501     0.200
     2.293    72.201     0.200
     2.324    74.001     0.200
     2.210    69.301     0.200
     2.442    77.201     0.200
     0.676    21.680     0.200
     1.120    35.879     0.200
     2.315    73.477     0.200
     2.286    72.477     0.200
     2.220    69.277     0.200
     2.430    76.879     0.200
     8.410   251.871     0.200
     0.695    22.492     0.200
     1.111    35.590     0.200
     1.425    45.492     0.200
     2.234    70.492     0.200
     2.281    73.090     0.200
     2.303    73.293     0.200
     2.414    76.492     0.200
     7.328   207.992     0.200
     1.533    48.305     0.200
     2.199    70.004     0.200
     0.662    21.772     0.200
     1.112    35.572     0.200
     2.221    70.072     0.200
     2.304    73.172     0.200
     2.304    72.372     0.200
     2.312    73.072     0.200
     0.669    21.719     0.200
     1.091    34.316     0.200
     1.421    44.816     0.200
     2.241    69.719     0.200
     2.291    72.617     0.200
     2.486    77.520     0.200
     0.710    22.823     0.200
     1.091    34.723     0.200
     1.447    46.223     0.200
     2.256    70.823     0.200
     2.281    72.623     0.200
     2.289    72.123     0.200
     0.229     7.453     0.200
     0.964    30.852     0.200
     1.441    45.953     0.200
     2.443    77.258     0.200
     7.265   218.422     0.200
     0.232     7.324     0.200
     0.962    30.324     0.200
     1.444    45.621     0.200
     2.440    76.922     0.200
     0.688    21.584     0.200
     0.688    21.984     0.200
     1.104    35.186     0.200
     1.104    35.385     0.200
     1.425    45.285     0.200
     2.293    72.686     0.200
     2.298    73.084     0.200
     2.298    73.484     0.200
     2.412    75.885     0.200
     2.412    75.584     0.200
     0.529    17.820     0.200
     0.948    30.420     0.200
     1.450    46.221     0.200
     2.138    65.920     0.200
     2.200    70.020     0.200
     2.429    76.221     0.200
     0.546    17.713     0.200
     0.933    30.113     0.200
     1.464    46.213     0.200
     2.185    70.014     0.200
     2.136    67.213     0.200
     2.412    76.213     0.200
     2.412    76.014     0.200
     2.381    74.514     0.200
     3.941   118.088     0.200
     0.531    17.709     0.200
     0.947    30.607     0.200
     1.451    46.107     0.200
     2.140    67.209     0.200
     2.199    70.209     0.200
     2.369    74.709     0.200
     2.427    76.607     0.200
     0.543    17.693     0.200
     0.935    29.994     0.200
     0.935    30.693     0.200
     2.132    65.193     0.200
     2.187    69.693     0.200
     2.187    69.795     0.200
     2.381    73.795     0.200
     2.415    76.193     0.200
     2.415    76.295     0.200
     8.248   247.164     0.200
     0.547    17.867     0.200
     0.935    30.367     0.200
     1.462    46.469     0.200
     2.149    66.773     0.200
     2.186    69.969     0.200
     2.376    74.469     0.200
     2.409    76.172     0.200
     0.546    18.008     0.200
     0.932    30.008     0.200
     1.466    46.508     0.200
     2.129    66.812     0.200
     2.184    69.508     0.200
     2.384    74.312     0.200
     2.413    75.906     0.200
     0.551    18.026     0.200
     0.930    29.726     0.200
     1.467    46.626     0.200
     2.181    68.926     0.200
     2.143    66.726     0.200
     2.405    75.926     0.200
     2.381    74.726     0.200
     0.215     7.334     0.200
     0.941    30.434     0.200
     1.463    46.734     0.200
     2.450    77.135     0.200
     0.720    22.727     0.200
     1.101    35.523     0.200
     1.448    46.523     0.200
     2.252    70.328     0.200
     2.287    73.430     0.200
     2.273    72.227     0.200
     2.394    75.828     0.200
     0.696    22.719     0.200
     1.091    34.918     0.200
     1.438    46.316     0.200
     2.250    70.719     0.200
     2.298    74.117     0.200
     2.285    72.719     0.200
     2.399    76.020     0.200
     0.737    23.526     0.200
     1.055    33.625     0.200
     2.242    71.125     0.200
     2.352    73.826     0.200
     2.296    71.926     0.200
     0.897    28.633     0.200
     1.026    33.234     0.200
     2.073    66.039     0.200
     2.318    74.133     0.200
     2.441    74.734     0.200
     2.441    76.234     0.200
     0.324    10.605     0.200
     1.098    35.006     0.200
     1.318    41.705     0.200
     1.980    62.805     0.200
     2.423    76.506     0.200
     0.707    22.668     0.200
     0.995    32.270     0.200
     1.499    47.469     0.200
     2.332    73.168     0.200
     2.198    70.168     0.200
     2.390    75.770     0.200
     2.401    74.770     0.200
     2.330    73.668     0.200
     8.460   252.289     0.200
     0.633    20.476     0.200
     0.633    20.276     0.200
     1.081    34.776     0.200
     1.081    34.976     0.200
     2.239    69.876     0.200
     2.239    70.276     0.200
     2.291    72.576     0.200
     2.358    74.976     0.200
     2.358    74.876     0.200
     2.425    76.576     0.200
     2.425    75.476     0.200
     2.456    76.576     0.200
     0.591    19.695     0.200
     0.591    19.898     0.200
     0.889    28.297     0.200
     0.889    28.898     0.200
     2.140    66.996     0.200
     2.140    67.195     0.200
     2.423    74.297     0.200
     2.367    74.195     0.200
     2.367    73.695     0.200
     0.954    30.984     0.200
     0.954    30.785     0.200
     1.163    37.184     0.200
     1.900    60.586     0.200
     1.095    34.863     0.200
     1.444    45.863     0.200
     2.252    70.965     0.200
     2.287    72.363     0.200
     2.396    74.863     0.200
     2.396    76.566     0.200
     0.552    17.844     0.200
     1.461    46.645     0.200
     2.166    67.645     0.200
     2.186    69.645     0.200
     2.371    74.445     0.200
     2.403    75.746     0.200
     8.274   248.887     0.200
     0.869    27.547     0.200
     0.930    29.547     0.200
     2.094    66.844     0.200
     2.352    74.148     0.200
     2.413    74.750     0.200
     2.449    76.250     0.200
     0.868    28.070     0.200
     0.938    29.973     0.200
     1.637    52.371     0.200
     2.102    67.570     0.200
     2.202    69.871     0.200
     2.344    75.871     0.200
     2.421    75.270     0.200
     2.442    77.070     0.200
     0.866    27.867     0.200
     0.929    29.867     0.200
     1.640    52.266     0.200
     2.095    67.566     0.200
     2.197    69.867     0.200
     2.410    75.066     0.200
     2.355    75.668     0.200
     2.448    76.867     0.200
     0.917    29.277     0.200
     0.884    28.574     0.200
     2.179    69.477     0.200
     2.406    75.074     0.200
     0.883    28.477     0.200
     0.917    29.375     0.200
     2.180    69.477     0.200
     2.406    74.773     0.200
     0.883    28.750     0.200
     0.933    29.852     0.200
     2.189    69.852     0.200
     2.422    75.047     0.200
     8.634   259.211     0.200
     0.878    28.736     0.200
     0.913    29.236     0.200
     2.077    66.836     0.200
     2.180    68.336     0.200
     2.399    74.836     0.200
     2.365    75.236     0.200
     0.856    27.934     0.200
     0.935    29.332     0.200
     2.104    66.832     0.200
     2.208    70.232     0.200
     2.413    74.832     0.200
     2.353    74.232     0.200
     2.438    77.133     0.200
     0.855    28.014     0.200
     0.942    30.414     0.200
     2.212    70.113     0.200
     2.420    75.213     0.200
     2.346    75.814     0.200
     0.945    29.952     0.200
     1.647    52.452     0.200
     2.101    67.552     0.200
     2.195    69.752     0.200
     2.327    74.652     0.200
     2.447    76.552     0.200
     0.728    23.949     0.200
     1.051    34.249     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.692   114.426     0.200
     5.017   159.125     0.200
     2.550    78.578     0.200
     4.742   147.883     0.200
     2.566    79.723     0.200
     2.659    84.422     0.200
     3.781   117.621     0.200
     4.722   147.023     0.200
     5.061   157.820     0.200
     5.119   164.922     0.200
     5.948   183.219     0.200
     3.133    98.781     0.200
     3.459   107.680     0.200
     4.401   138.180     0.200
     4.534   140.680     0.200
     4.818   153.680     0.200
     4.870   151.680     0.200
     5.635   174.680     0.200
     7.293   229.180     0.200
     7.594   236.680     0.200
     2.574    80.969     0.200
     2.613    82.168     0.200
     2.692    85.566     0.200
     2.820    90.168     0.200
     2.879    90.867     0.200
     3.160    98.969     0.200
     3.616   112.168     0.200
     3.945   123.168     0.200
     4.886   153.168     0.200
     5.279   170.867     0.200
     5.461   171.168     0.200
     6.112   192.668     0.200
     7.579   237.770     0.200
     7.792   243.566     0.200
     8.048   250.867     0.200
     9.140   286.168     0.200
     9.776   305.469     0.200
    10.276   318.168     0.200
    11.367   354.566     0.200
     2.559    81.062     0.200
     2.701    83.463     0.200
     2.683    84.662     0.200
     2.814    89.262     0.200
     2.869    91.162     0.200
     3.131    97.963     0.200
     3.607   113.762     0.200
     3.933   122.762     0.200
     4.874   151.562     0.200
     5.007   155.863     0.200
     5.432   170.562     0.200
     6.090   189.363     0.200
     7.533   236.762     0.200
     7.765   242.562     0.200
     2.600    82.160     0.200
     3.028    94.660     0.200
     3.971   124.262     0.200
     4.512   140.762     0.200
     4.547   141.660     0.200
     6.945   217.762     0.200
     2.748    85.898     0.200
     3.325   103.500     0.200
     3.558   111.898     0.200
     4.500   139.898     0.200
     4.631   143.898     0.200
     4.834   151.898     0.200
     5.049   157.695     0.200
     5.695   179.898     0.200
     6.222   193.594     0.200
    26.376   859.594     0.200
     2.676    85.148     0.200
     3.113    96.848     0.200
     3.282   103.047     0.200
     4.169   129.848     0.200
     4.557   142.547     0.200
     5.473   170.547     0.200
     5.612   175.848     0.200
     6.070   186.246     0.200
     6.588   205.148     0.200
     6.588   207.246     0.200
     7.723   240.148     0.200
     8.045   252.445     0.200
     8.054   252.047     0.200
     9.038   279.547     0.200
     2.708    86.172     0.200
     3.522   108.672     0.200
     3.862   119.172     0.200
     3.862   119.375     0.200
     4.246   132.375     0.200
     4.798   149.672     0.200
     4.798   152.172     0.200
     5.313   166.672     0.200
     5.474   172.672     0.200
     6.675   208.672     0.200
     7.087   217.969     0.200
     9.768   306.172     0.200
    10.252   318.172     0.200
    10.706   331.273     0.200
    11.134   345.375     0.200
    11.312   351.672     0.200
    13.438   421.570     0.200
    14.183   443.570     0.200
    14.624   455.672     0.200
    15.269   478.672     0.200
    15.401   482.969     0.200
    16.365   513.172     0.200
     2.675    83.523     0.200
     3.831   120.023     0.200
     4.214   132.320     0.200
     4.767   149.117     0.200
     5.285   164.617     0.200
     5.441   171.117     0.200
     7.701   239.719     0.200
     2.573    81.961     0.200
     2.684    84.461     0.200
     3.839   121.164     0.200
     4.222   130.664     0.200
     4.775   149.164     0.200
     5.292   166.164     0.200
     5.449   171.461     0.200
     2.574    81.719     0.200
     2.684    84.422     0.200
     3.840   120.422     0.200
     4.222   132.422     0.200
     4.776   149.422     0.200
     5.291   166.320     0.200
     5.449   171.719     0.200
     2.721    84.482     0.200
     3.873   121.182     0.200
     4.259   133.182     0.200
     4.808   149.682     0.200
     5.328   166.883     0.200
     5.487   172.182     0.200
     2.572    81.066     0.200
     2.681    83.270     0.200
     3.838   120.066     0.200
     4.219   132.566     0.200
     4.774   149.367     0.200
     5.286   164.969     0.200
     5.446   170.969     0.200
     6.648   206.270     0.200
     7.701   240.168     0.200
     7.758   239.969     0.200
     8.036   250.168     0.200
     9.098   283.168     0.200
     2.513    78.708     0.200
     2.590    81.809     0.200
     2.708    84.008     0.200
     3.516   109.409     0.200
     3.857   121.108     0.200
     4.246   133.108     0.200
     4.792   149.008     0.200
     5.325   167.809     0.200
     2.578    81.688     0.200
     2.690    83.988     0.200
     3.504   109.188     0.200
     3.844   121.088     0.200
     4.228   132.287     0.200
     4.780   148.988     0.200
     5.298   165.287     0.200
     5.456   171.688     0.200
     2.568    81.875     0.200
     2.679    83.977     0.200
     3.835   120.273     0.200
     4.217   131.875     0.200
     4.770   148.570     0.200
     5.290   165.570     0.200
     5.445   169.570     0.200
     6.646   206.672     0.200
     2.591    82.017     0.200
     2.700    85.117     0.200
     3.517   109.417     0.200
     3.857   120.517     0.200
     4.239   132.417     0.200
     4.793   150.017     0.200
     5.301   167.417     0.200
     5.465   171.017     0.200
     6.668   209.017     0.200
     7.715   240.517     0.200
     7.777   241.017     0.200
     2.586    81.867     0.200
     2.696    84.668     0.200
     3.511   109.467     0.200
     3.852   119.568     0.200
     4.234   133.068     0.200
     4.787   149.768     0.200
     5.300   165.768     0.200
     5.461   171.367     0.200
     6.663   207.367     0.200
     7.715   240.367     0.200
     7.773   241.068     0.200
     2.574    81.625     0.200
     3.334   104.824     0.200
     3.979   124.926     0.200
     4.489   142.824     0.200
     4.540   142.523     0.200
     6.922   217.227     0.200
     2.504    79.516     0.200
     3.528   110.516     0.200
     3.869   119.516     0.200
     3.869   121.016     0.200
     4.804   151.016     0.200
     4.804   151.516     0.200
     5.329   168.215     0.200
     5.486   172.516     0.200
     6.053   189.516     0.200
     6.686   209.516     0.200
     7.744   241.016     0.200
     7.796   242.516     0.200
     8.076   250.516     0.200
     9.136   284.715     0.200
     9.778   306.117     0.200
    10.262   321.016     0.200
    11.143   345.516     0.200
     2.715    84.816     0.200
     3.526   111.418     0.200
     3.867   122.219     0.200
     4.253   133.219     0.200
     4.803   150.117     0.200
     5.323   166.617     0.200
     5.482   172.418     0.200
     6.682   210.418     0.200
     7.738   242.617     0.200
     2.560    81.125     0.200
     2.526    79.125     0.200
     2.680    84.625     0.200
     3.485   108.125     0.200
     3.827   118.922     0.200
     4.217   133.227     0.200
     4.762   149.625     0.200
     5.309   166.125     0.200
     5.450   170.625     0.200
     5.604   177.422     0.200
     6.647   207.523     0.200
     7.758   243.125     0.200
     7.726   241.727     0.200
     8.039   251.125     0.200
     9.097   283.227     0.200
     9.740   302.422     0.200
    10.737   335.125     0.200
     2.524    79.492     0.200
     2.551    80.289     0.200
     2.670    82.492     0.200
     3.476   107.992     0.200
     3.818   118.789     0.200
     4.207   131.789     0.200
     4.753   148.094     0.200
     5.299   165.594     0.200
     5.439   170.789     0.200
     5.610   171.594     0.200
     6.636   207.789     0.200
     7.716   239.492     0.200
     7.748   240.992     0.200
     9.087   283.992     0.200
     3.857   122.453     0.200
     4.235   133.754     0.200
     2.512    77.555     0.200
     2.635    83.852     0.200
     2.738    85.758     0.200
     3.900   122.055     0.200
     4.277   134.055     0.200
     4.836   150.156     0.200
     5.316   167.555     0.200
     5.499   172.656     0.200
     5.515   173.055     0.200
     6.004   189.953     0.200
     2.505    78.511     0.200
     2.688    85.110     0.200
     2.810    88.110     0.200
     3.956   123.011     0.200
     4.348   136.110     0.200
     4.891   152.410     0.200
     5.407   170.511     0.200
     5.577   173.311     0.200
     6.777   211.011     0.200
     7.819   244.711     0.200
     7.888   246.610     0.200
     8.167   256.311     0.200
     9.227   288.110     0.200
     9.870   307.110     0.200
    10.353   320.511     0.200
    10.865   338.711     0.200
    11.234   349.711     0.200
    11.409   354.511     0.200
     2.513    79.350     0.200
     2.696    84.551     0.200
     3.222    99.250     0.200
     3.846   119.850     0.200
     4.234   132.449     0.200
     5.315   168.350     0.200
     5.584   173.051     0.200
     2.633    83.139     0.200
     2.638    82.938     0.200
     3.555   111.139     0.200
     3.878   121.139     0.200
     4.178   132.139     0.200
     4.820   150.339     0.200
     5.355   169.139     0.200
     6.599   208.139     0.200
     7.447   232.139     0.200
     7.692   240.139     0.200
     2.507    77.312     0.200
     2.649    84.414     0.200
     2.759    87.211     0.200
     3.915   123.008     0.200
     4.298   134.711     0.200
     4.851   150.211     0.200
     5.346   167.609     0.200
     5.523   173.414     0.200
     5.515   172.211     0.200
     6.727   211.609     0.200
     7.759   242.609     0.200
     7.836   243.711     0.200
    10.304   322.211     0.200
     2.633    84.141     0.200
     3.273   103.641     0.200
     3.911   123.141     0.200
     4.470   140.441     0.200
     6.904   217.941     0.200
     3.171    99.605     0.200
     3.500   109.004     0.200
     3.841   120.004     0.200
     4.440   138.605     0.200
     4.919   153.004     0.200
     6.268   197.207     0.200
     7.341   230.105     0.200
     7.373   232.105     0.200
     8.716   269.605     0.200
     2.551    78.381     0.200
     3.011    95.281     0.200
     3.233   100.381     0.200
     3.953   127.381     0.200
     4.284   132.581     0.200
     4.755   149.981     0.200
     6.023   188.581     0.200
     8.347   260.682     0.200
     8.611   269.781     0.200
     9.635   298.682     0.200
    11.305   350.981     0.200
    11.755   365.981     0.200
    17.221   542.781     0.200
     2.659    84.039     0.200
     2.692    84.539     0.200
     3.911   122.141     0.200
     4.234   133.539     0.200
     4.852   151.539     0.200
     5.423   169.742     0.200
     5.406   169.836     0.200
     5.877   187.742     0.200
     2.528    79.688     0.200
     4.897   155.688     0.200
     5.896   184.688     0.200
     7.573   234.289     0.200
     3.295   104.984     0.200
     3.621   113.484     0.200
     4.054   125.781     0.200
     4.209   131.688     0.200
     4.562   141.781     0.200
    18.327   580.883     0.200
     3.133    97.617     0.200
     3.459   109.617     0.200
     3.792   117.719     0.200
     4.400   137.719     0.200
     4.865   152.117     0.200
     5.002   157.816     0.200
     6.218   193.719     0.200
     7.288   227.516     0.200
     7.322   228.418     0.200
     7.591   237.617     0.200
     8.666   270.117     0.200
     9.305   290.719     0.200
     9.799   304.418     0.200
    10.290   320.816     0.200
    10.684   331.918     0.200
     3.402   107.523     0.200
     3.735   117.125     0.200
     4.092   127.125     0.200
     4.829   150.125     0.200
     8.610   270.125     0.200
     9.249   290.523     0.200
     9.742   302.625     0.200
    10.236   320.824     0.200
    10.627   329.523     0.200
    10.824   335.125     0.200
     3.365   105.930     0.200
     3.680   115.031     0.200
     4.307   134.125     0.200
     4.747   148.328     0.200
     4.883   153.930     0.200
     6.105   189.930     0.200
     3.652   116.203     0.200
     4.290   133.008     0.200
     4.702   149.109     0.200
     4.849   153.008     0.200
     7.127   221.008     0.200
     3.222   100.771     0.200
     3.551   111.971     0.200
     3.894   123.971     0.200
     4.492   139.871     0.200
     4.959   154.871     0.200
     6.321   199.572     0.200
     7.426   233.572     0.200
     7.697   239.771     0.200
     9.409   291.572     0.200
     9.901   308.971     0.200
    10.674   334.271     0.200
    10.786   337.271     0.200
     2.730    84.516     0.200
     2.717    85.617     0.200
     3.640   115.016     0.200
     3.964   124.016     0.200
     4.271   134.516     0.200
     4.906   152.316     0.200
     5.126   161.016     0.200
     5.449   171.516     0.200
     7.524   236.816     0.200
     7.785   242.215     0.200
     8.034   252.016     0.200
     9.135   284.016     0.200
     9.769   302.516     0.200
    10.274   319.816     0.200
    10.734   334.016     0.200
    11.164   347.117     0.200
    11.375   355.316     0.200
     3.069    95.812     0.200
     3.920   122.412     0.200
     4.257   133.912     0.200
     5.195   162.412     0.200
     5.501   173.912     0.200
     5.810   182.412     0.200
     7.036   221.112     0.200
     7.893   245.112     0.200
     8.137   255.912     0.200
     9.484   292.412     0.200
    10.617   332.112     0.200
    11.097   346.912     0.200
     2.652    82.164     0.200
     2.621    82.367     0.200
     3.850   120.164     0.200
     4.162   130.164     0.200
     4.792   149.664     0.200
     5.062   157.664     0.200
     5.346   166.961     0.200
     6.584   206.164     0.200
     7.466   235.766     0.200
     7.679   239.867     0.200
     3.081    95.906     0.200
     4.267   134.004     0.200
     4.267   133.605     0.200
     4.622   146.906     0.200
     5.205   164.105     0.200
     5.164   162.504     0.200
     5.514   173.207     0.200
     5.667   180.004     0.200
     5.823   182.605     0.200
     7.049   218.605     0.200
     2.575    81.582     0.200
     2.629    80.781     0.200
     2.595    81.582     0.200
     3.498   109.582     0.200
     3.823   120.383     0.200
     4.136   130.082     0.200
     5.048   160.582     0.200
     5.322   168.082     0.200
     2.564    82.240     0.200
     3.953   124.041     0.200
     4.507   140.840     0.200
     5.099   160.541     0.200
     5.187   162.541     0.200
     5.802   181.439     0.200
     6.275   198.939     0.200
     7.430   232.340     0.200
     7.915   247.340     0.200
     2.825    87.465     0.200
     3.252   100.665     0.200
     4.314   133.565     0.200
     4.777   148.265     0.200
     5.426   169.065     0.200
     5.968   186.365     0.200
     6.872   215.965     0.200
     8.054   249.265     0.200
     8.058   249.265     0.200
     8.338   260.765     0.200
     2.728    85.848     0.200
     2.838    89.047     0.200
     3.731   115.645     0.200
     4.059   127.445     0.200
     4.059   127.047     0.200
     4.379   137.645     0.200
     5.000   155.848     0.200
     5.239   163.246     0.200
     5.562   175.348     0.200
     6.801   211.746     0.200
     7.635   239.145     0.200
     7.774   241.246     0.200
     7.897   244.246     0.200
    10.384   324.047     0.200
     2.858    87.902     0.200
     3.254   100.303     0.200
     3.472   110.102     0.200
     3.639   112.602     0.200
     4.471   138.303     0.200
     4.756   146.602     0.200
     4.813   148.902     0.200
     4.813   151.102     0.200
     5.180   162.002     0.200
     5.295   166.102     0.200
     5.748   178.402     0.200
     5.748   179.803     0.200
     5.977   185.902     0.200
     6.375   198.602     0.200
     7.542   236.191     0.200
     7.606   237.002     0.200
     8.344   258.402     0.200
     8.586   268.303     0.200
     8.706   271.803     0.200
     8.961   281.102     0.200
     9.078   283.902     0.200
     9.579   299.102     0.200
     9.978   311.703     0.200
    10.053   314.303     0.200
    10.690   331.902     0.200
    11.186   346.203     0.200
    12.072   375.703     0.200
    12.260   382.902     0.200
     2.663    83.377     0.200
     2.895    91.677     0.200
     3.272   104.677     0.200
     3.444   106.677     0.200
     4.143   129.577     0.200
     4.722   147.677     0.200
     5.315   166.877     0.200
     5.677   178.377     0.200
     6.591   208.977     0.200
     2.661    85.055     0.200
     2.891    90.758     0.200
     3.223   101.758     0.200
     3.593   112.961     0.200
     4.162   128.859     0.200
     4.832   151.656     0.200
     4.825   153.461     0.200
     6.022   186.758     0.200
    10.118   312.461     0.200
     2.567    79.617     0.200
     2.568    80.016     0.200
     2.859    90.516     0.200
     3.406   104.918     0.200
     3.662   113.719     0.200
     3.919   124.219     0.200
     4.343   138.117     0.200
     4.811   151.816     0.200
     5.144   161.219     0.200
     5.459   170.617     0.200
     6.051   190.918     0.200
     6.084   191.719     0.200
     6.612   205.617     0.200
     7.875   246.418     0.200
     8.381   260.117     0.200
     8.370   258.918     0.200
     8.960   277.816     0.200
     9.289   290.016     0.200
    10.224   320.516     0.200
    11.888   369.719     0.200
     2.687    85.372     0.200
     2.687    84.372     0.200
     2.627    83.272     0.200
     2.627    84.372     0.200
     3.002    94.272     0.200
     3.313   103.672     0.200
     3.313   103.972     0.200
     3.945   124.272     0.200
     3.945   123.272     0.200
     4.529   140.672     0.200
     4.529   141.272     0.200
     4.510   142.972     0.200
     5.740   177.972     0.200
     6.538   205.472     0.200
     6.542   205.472     0.200
     6.844   212.772     0.200
     6.944   218.972     0.200
     7.255   227.572     0.200
     8.120   254.272     0.200
     8.827   275.872     0.200
     9.320   288.772     0.200
     9.817   306.672     0.200
    10.206   316.272     0.200
    10.407   321.972     0.200
     2.661    83.566     0.200
     2.661    84.066     0.200
     2.892    90.965     0.200
     3.225   100.566     0.200
     3.225   101.766     0.200
     3.595   111.363     0.200
     3.595   113.066     0.200
     4.164   130.566     0.200
     4.164   130.465     0.200
     2.522    79.867     0.200
     2.968    93.664     0.200
     3.169   100.461     0.200
     3.958   123.664     0.200
     4.304   134.266     0.200
     4.706   148.062     0.200
     5.250   161.062     0.200
     5.236   162.461     0.200
     5.705   180.766     0.200
     5.934   187.367     0.200
     2.504    79.773     0.200
     3.227   101.375     0.200
     3.542   111.676     0.200
     4.169   130.176     0.200
     4.351   136.375     0.200
     4.545   142.273     0.200
     4.750   148.973     0.200
     7.087   223.473     0.200
     2.907    90.914     0.200
     2.990    93.711     0.200
     3.028    93.508     0.200
     4.249   133.312     0.200
     4.527   143.109     0.200
     5.035   158.711     0.200
     5.192   162.609     0.200
     5.233   163.508     0.200
     5.678   178.414     0.200
     7.609   238.711     0.200
     2.823    88.117     0.200
     2.915    91.422     0.200
     2.915    90.922     0.200
     3.506   111.617     0.200
     3.527   110.023     0.200
     3.677   113.219     0.200
     4.388   137.820     0.200
     4.533   142.719     0.200
     4.839   151.922     0.200
     4.853   155.219     0.200
     5.046   159.320     0.200
     5.414   169.922     0.200
     5.782   181.523     0.200
     6.127   192.922     0.200
     7.434   232.922     0.200
     7.725   241.820     0.200
     8.079   251.719     0.200
     8.628   268.922     0.200
     8.684   271.820     0.200
     8.761   273.422     0.200
     9.741   304.922     0.200
     9.856   308.422     0.200
    11.012   341.320     0.200
    11.376   354.422     0.200
    11.914   371.922     0.200
    12.178   378.820     0.200
    16.152   513.305     0.200
     2.538    78.891     0.200
     2.538    78.586     0.200
     3.324   103.891     0.200
     3.645   113.391     0.200
     3.934   122.492     0.200
     3.947   123.789     0.200
     4.587   144.086     0.200
     4.891   153.289     0.200
     5.132   161.891     0.200
     6.369   199.492     0.200
     7.134   221.492     0.200
     7.173   222.891     0.200
     7.304   228.391     0.200
     7.464   232.688     0.200
     7.667   238.789     0.200
     7.840   245.891     0.200
     9.448   295.492     0.200
     9.951   307.992     0.200
    10.419   323.188     0.200
     2.792    85.910     0.200
     2.878    90.508     0.200
     3.041    95.008     0.200
     3.354   103.609     0.200
     3.446   105.410     0.200
     3.729   116.508     0.200
     3.883   120.707     0.200
     4.221   132.207     0.200
     4.582   144.207     0.200
     5.158   161.207     0.200
     5.215   164.508     0.200
     5.500   173.109     0.200
     5.717   180.410     0.200
     5.787   181.309     0.200
     7.009   220.508     0.200
     7.791   241.008     0.200
     7.827   244.809     0.200
     7.895   245.410     0.200
     8.112   252.008     0.200
     8.498   265.207     0.200
     2.806    86.119     0.200
     2.881    91.419     0.200
     3.039    95.319     0.200
     3.039    95.919     0.200
     3.350   105.520     0.200
     3.442   107.419     0.200
     3.717   117.219     0.200
     3.887   122.619     0.200
     4.224   132.020     0.200
     4.224   132.719     0.200
     4.580   144.219     0.200
     5.162   161.619     0.200
     5.203   163.719     0.200
     5.485   173.819     0.200
     5.703   180.419     0.200
     5.782   179.819     0.200
     7.006   219.819     0.200
     8.492   266.619     0.200
     9.382   291.020     0.200
    10.587   330.020     0.200
    11.069   346.119     0.200
    11.472   358.819     0.200
    11.664   362.219     0.200
     2.530    79.938     0.200
     3.219    99.938     0.200
     4.984   155.738     0.200
     5.372   166.639     0.200
     5.915   184.838     0.200
     6.192   195.438     0.200
     6.577   205.338     0.200
     7.420   233.039     0.200
     8.579   266.838     0.200
     8.557   267.438     0.200
     8.903   278.539     0.200
     2.592    81.613     0.200
     3.451   107.914     0.200
     3.829   119.514     0.200
     4.389   136.813     0.200
     5.003   157.113     0.200
     6.258   194.514     0.200
     6.362   200.914     0.200
     7.080   221.113     0.200
     7.100   219.414     0.200
     7.371   230.813     0.200
     7.430   229.714     0.200
     9.834   308.014     0.200
     2.505    77.609     0.200
     2.598    81.812     0.200
     2.598    82.109     0.200
     2.789    87.016     0.200
     2.789    87.414     0.200
     3.596   113.516     0.200
     3.596   112.711     0.200
     3.733   117.109     0.200
     3.733   115.914     0.200
     3.938   122.711     0.200
     3.938   122.914     0.200
     4.025   125.609     0.200
     4.327   135.016     0.200
     4.327   134.711     0.200
     4.873   152.109     0.200
     4.873   152.211     0.200
     5.386   169.109     0.200
     6.394   200.211     0.200
     6.756   210.711     0.200
     7.568   236.414     0.200
     7.798   242.211     0.200
     7.867   246.016     0.200
     8.095   254.016     0.200
     8.280   260.711     0.200
     9.145   286.312     0.200
     9.849   306.609     0.200
    10.333   321.711     0.200
    10.844   338.211     0.200
    11.214   349.312     0.200
    11.390   354.516     0.200
     2.684    84.418     0.200
     2.684    84.219     0.200
     3.500   110.820     0.200
     3.500   110.520     0.200
     3.840   120.020     0.200
     3.840   120.320     0.200
     3.828   119.219     0.200
     4.092   128.219     0.200
     4.222   132.418     0.200
     4.776   150.121     0.200
     5.291   166.418     0.200
     5.449   170.719     0.200
     6.064   188.121     0.200
     6.651   207.820     0.200
     7.462   233.719     0.200
     7.486   231.520     0.200
     7.761   240.820     0.200
     8.039   252.320     0.200
     8.173   256.121     0.200
     9.039   281.621     0.200
     9.102   282.520     0.200
     9.744   304.121     0.200
    10.228   317.320     0.200
    10.737   335.020     0.200
     2.502    79.012     0.200
     2.502    79.113     0.200
     2.691    84.113     0.200
     2.691    83.613     0.200
     3.502   110.512     0.200
     3.502   110.211     0.200
     3.826   119.914     0.200
     3.843   120.914     0.200
     3.843   119.414     0.200
     4.097   125.812     0.200
     4.229   132.312     0.200
     4.778   150.512     0.200
     4.778   148.914     0.200
     5.306   167.914     0.200
     5.458   170.211     0.200
     5.582   173.211     0.200
     6.071   193.711     0.200
     6.658   208.211     0.200
     7.471   233.312     0.200
    10.234   317.312     0.200
    10.746   335.512     0.200
    11.115   343.113     0.200
    11.292   352.812     0.200
     2.507    78.391     0.200
     2.695    84.492     0.200
     2.695    84.191     0.200
     3.507   110.492     0.200
     3.821   116.992     0.200
     3.821   116.691     0.200
     3.848   120.789     0.200
     4.091   126.090     0.200
     4.233   131.891     0.200
     4.784   150.992     0.200
     5.306   165.691     0.200
     5.462   170.691     0.200
     5.575   170.992     0.200
     6.064   189.789     0.200
     7.474   233.191     0.200
     7.498   235.992     0.200
     7.773   241.391     0.200
     8.001   249.590     0.200
     8.186   256.789     0.200
     9.051   280.789     0.200
     9.755   302.289     0.200
    10.239   318.992     0.200
    10.750   336.492     0.200
    11.120   346.289     0.200
    11.298   349.391     0.200
     2.535    79.973     0.200
     3.397   107.573     0.200
     3.729   115.773     0.200
     3.939   124.273     0.200
     4.076   128.073     0.200
     4.126   127.673     0.200
     4.669   147.773     0.200
     5.096   159.373     0.200
     5.286   166.073     0.200
     5.606   173.873     0.200
     6.503   203.873     0.200
     7.294   227.073     0.200
     8.882   278.473     0.200
    10.083   315.673     0.200
    11.161   348.373     0.200
     2.687    83.882     0.200
     3.505   110.182     0.200
     3.823   117.282     0.200
     3.845   119.782     0.200
     4.084   125.882     0.200
     4.225   132.382     0.200
     4.781   149.682     0.200
     5.288   166.482     0.200
     5.451   170.182     0.200
     5.568   169.582     0.200
     6.056   190.682     0.200
     6.654   206.482     0.200
     7.703   239.382     0.200
     7.764   243.082     0.200
     2.661    83.550     0.200
     2.661    84.050     0.200
     3.482   109.050     0.200
     3.821   118.650     0.200
     3.821   120.250     0.200
     3.847   120.450     0.200
     3.847   120.650     0.200
     3.871   118.450     0.200
     4.011   122.550     0.200
     4.200   130.750     0.200
     4.495   138.350     0.200
     4.757   147.850     0.200
     5.266   165.550     0.200
     5.426   169.550     0.200
     6.071   193.650     0.200
     6.629   207.350     0.200
     7.682   239.350     0.200
     7.738   241.450     0.200
     8.149   255.350     0.200
     2.655    83.051     0.200
     3.853   120.150     0.200
     4.008   124.551     0.200
     4.107   128.551     0.200
     4.107   127.051     0.200
     4.193   131.351     0.200
     5.591   174.251     0.200
     7.958   245.150     0.200
     8.099   248.351     0.200
     2.626    81.865     0.200
     3.797   117.865     0.200
     3.869   118.766     0.200
     4.037   124.465     0.200
     4.102   128.465     0.200
     4.166   130.065     0.200
     4.735   147.965     0.200
     5.214   162.365     0.200
     8.001   246.465     0.200
     2.646    83.427     0.200
     3.468   109.327     0.200
     3.807   119.728     0.200
     3.860   119.228     0.200
     3.860   119.526     0.200
     3.860   119.827     0.200
     4.110   128.327     0.200
     4.184   131.626     0.200
     4.744   148.126     0.200
     5.250   164.228     0.200
     5.409   168.526     0.200
     5.593   174.427     0.200
     6.078   191.626     0.200
     6.613   206.327     0.200
     7.421   232.728     0.200
     7.446   230.327     0.200
     7.666   238.626     0.200
     7.722   240.728     0.200
     7.948   248.427     0.200
     8.133   254.827     0.200
     9.000   279.728     0.200
     9.705   301.126     0.200
    10.190   316.427     0.200
    10.697   333.728     0.200
    11.072   343.026     0.200
    11.253   349.626     0.200
     2.517    78.387     0.200
     2.517    78.887     0.200
     2.718    83.984     0.200
     2.718    84.387     0.200
     3.523   109.086     0.200
     3.523   109.984     0.200
     3.865   119.387     0.200
     3.865   119.586     0.200
     3.805   117.285     0.200
     3.805   117.086     0.200
     4.087   127.086     0.200
     4.087   125.684     0.200
     4.255   131.785     0.200
     4.435   136.484     0.200
     4.800   149.586     0.200
     5.335   166.285     0.200
     5.486   169.887     0.200
     5.572   170.285     0.200
     7.499   232.785     0.200
     7.751   241.984     0.200
     7.796   242.285     0.200
     8.211   254.887     0.200
     2.502    78.445     0.200
     2.689    84.445     0.200
     2.689    84.547     0.200
     3.503   109.047     0.200
     3.503   110.547     0.200
     3.825   117.844     0.200
     3.825   117.945     0.200
     3.844   120.047     0.200
     3.844   119.945     0.200
     4.005   122.750     0.200
     4.092   126.250     0.200
     4.092   125.750     0.200
     4.227   132.547     0.200
     4.466   137.344     0.200
     4.779   149.750     0.200
     5.298   166.250     0.200
     5.455   170.547     0.200
     5.576   170.148     0.200
     7.714   239.844     0.200
     7.767   239.945     0.200
     8.362   256.344     0.200
     2.674    83.711     0.200
     3.493   109.609     0.200
     3.832   120.609     0.200
     3.836   118.109     0.200
     4.011   124.406     0.200
     4.095   129.305     0.200
     4.213   131.711     0.200
     5.579   173.008     0.200
     2.500    78.838     0.200
     2.500    78.638     0.200
     2.687    83.838     0.200
     2.687    84.037     0.200
     3.499   110.638     0.200
     3.499   110.138     0.200
     3.840   119.638     0.200
     3.829   118.037     0.200
     3.829   118.738     0.200
     4.225   131.938     0.200
     4.225   131.338     0.200
     4.097   128.037     0.200
     4.097   126.638     0.200
     4.468   138.537     0.200
     4.776   147.938     0.200
     4.776   148.138     0.200
     5.299   164.738     0.200
     5.453   168.938     0.200
     6.292   196.438     0.200
     6.654   206.238     0.200
     7.466   231.438     0.200
     7.490   236.037     0.200
     7.764   241.238     0.200
     7.715   240.138     0.200
     7.992   248.638     0.200
     8.043   252.037     0.200
     8.659   270.338     0.200
     9.042   280.238     0.200
     9.104   284.838     0.200
     9.746   302.338     0.200
    10.230   317.537     0.200
    11.289   350.838     0.200
    14.642   458.938     0.200
     2.667    83.520     0.200
     2.667    83.219     0.200
     3.484   109.020     0.200
     3.484   109.816     0.200
     3.824   120.219     0.200
     3.824   119.316     0.200
     3.845   119.816     0.200
     3.845   117.617     0.200
     4.002   123.117     0.200
     4.205   131.117     0.200
     4.105   127.816     0.200
     4.105   125.918     0.200
     4.488   138.020     0.200
     4.760   150.316     0.200
     5.277   163.617     0.200
     5.277   165.219     0.200
     5.432   170.219     0.200
     5.589   172.617     0.200
     7.445   232.020     0.200
     7.693   241.816     0.200
     7.744   241.816     0.200
     9.022   282.918     0.200
    10.211   319.617     0.200
    10.720   335.816     0.200
    11.277   356.953     0.200
     2.676    83.242     0.200
     3.493   109.844     0.200
     3.835   119.141     0.200
     3.835   118.242     0.200
     3.833   119.945     0.200
     4.008   124.141     0.200
     4.096   128.242     0.200
     4.096   126.539     0.200
     4.214   131.742     0.200
     4.769   150.445     0.200
     5.283   165.945     0.200
     5.441   169.742     0.200
     5.581   171.242     0.200
     2.643    83.664     0.200
     2.696    83.664     0.200
     3.802   119.664     0.200
     3.802   119.266     0.200
     3.881   121.562     0.200
     3.927   123.766     0.200
     3.927   125.062     0.200
     4.184   131.367     0.200
     4.823   152.062     0.200
     5.055   158.961     0.200
     2.668    83.592     0.200
     3.484   109.992     0.200
     3.824   119.592     0.200
     3.844   118.592     0.200
     4.003   123.092     0.200
     4.206   130.893     0.200
     4.104   125.992     0.200
     4.104   126.292     0.200
     4.488   138.992     0.200
     4.760   148.992     0.200
     5.278   166.893     0.200
     5.433   169.692     0.200
     5.588   170.992     0.200
     6.635   205.893     0.200
     7.128   219.492     0.200
     7.445   232.192     0.200
     7.470   235.292     0.200
     7.693   240.192     0.200
     7.745   242.692     0.200
     7.972   248.992     0.200
     8.157   253.992     0.200
     9.022   282.893     0.200
    10.212   317.992     0.200
    11.272   350.992     0.200
    11.277   352.912     0.200
     2.504    78.543     0.200
     2.679    83.840     0.200
     2.679    83.141     0.200
     3.491   110.641     0.200
     3.491   110.242     0.200
     3.837   117.840     0.200
     3.867   118.941     0.200
     3.832   118.840     0.200
     3.832   119.742     0.200
     3.993   122.941     0.200
     4.105   125.641     0.200
     4.105   125.840     0.200
     4.217   130.441     0.200
     4.767   147.941     0.200
     5.446   169.043     0.200
     6.078   186.543     0.200
     6.646   206.340     0.200
     7.117   218.543     0.200
     9.035   282.742     0.200
     9.739   302.742     0.200
    10.223   319.742     0.200
    11.281   350.543     0.200
     2.495    78.555     0.200
     2.664    83.555     0.200
     3.820   119.256     0.200
     3.848   118.256     0.200
     3.875   119.455     0.200
     3.999   124.055     0.200
     4.109   128.455     0.200
     4.202   130.955     0.200
     7.132   218.555     0.200
     2.637    82.773     0.200
     2.829    88.375     0.200
     3.747   116.074     0.200
     3.801   117.273     0.200
     3.851   121.672     0.200
     3.851   121.875     0.200
     3.912   122.172     0.200
     4.172   131.273     0.200
     4.456   139.273     0.200
     4.643   143.875     0.200
     4.855   152.473     0.200
     5.321   165.473     0.200
     7.216   221.375     0.200
     8.366   256.273     0.200
     8.674   268.074     0.200
     2.522    80.519     0.200
     2.522    79.919     0.200
     2.719    83.919     0.200
     2.719    84.318     0.200
     3.789   118.719     0.200
     3.789   118.919     0.200
     3.977   124.618     0.200
     4.059   126.919     0.200
     4.059   128.318     0.200
     4.732   149.419     0.200
     4.883   151.919     0.200
     4.883   153.419     0.200
     5.219   163.919     0.200
     2.869    89.664     0.200
     3.029    95.164     0.200
     3.454   107.266     0.200
     3.454   106.566     0.200
     3.729   116.965     0.200
     3.729   115.863     0.200
     4.155   126.965     0.200
     4.213   131.164     0.200
     4.570   143.465     0.200
     5.215   163.465     0.200
     6.771   208.266     0.200
     7.681   235.363     0.200
     7.828   240.164     0.200
     2.801    85.906     0.200
     2.872    90.207     0.200
     3.030    94.707     0.200
     3.451   107.004     0.200
     3.451   107.105     0.200
     3.451   106.605     0.200
     3.723   116.707     0.200
     3.723   114.906     0.200
     3.878   122.707     0.200
     3.878   123.305     0.200
     4.156   127.504     0.200
     4.215   131.707     0.200
     4.215   130.906     0.200
     4.571   142.207     0.200
     4.571   141.906     0.200
     5.153   161.004     0.200
     5.209   159.906     0.200
     5.477   173.207     0.200
     5.772   181.605     0.200
     6.770   208.207     0.200
     6.997   220.406     0.200
     7.684   235.605     0.200
     7.872   245.305     0.200
     8.099   253.707     0.200
     9.372   294.105     0.200
    10.577   331.004     0.200
    11.655   363.406     0.200
     2.640    83.789     0.200
     2.640    83.289     0.200
     2.631    83.391     0.200
     2.951    91.586     0.200
     2.951    92.789     0.200
     3.249   102.492     0.200
     3.894   122.289     0.200
     4.460   139.586     0.200
     4.442   139.586     0.200
     4.793   150.992     0.200
     5.675   177.086     0.200
     6.778   212.086     0.200
     6.876   215.891     0.200
     9.256   288.688     0.200
     2.784    85.992     0.200
     3.021    94.492     0.200
     3.021    93.594     0.200
     3.463   107.297     0.200
     3.739   116.992     0.200
     3.866   118.891     0.200
     3.866   122.891     0.200
     4.204   130.594     0.200
     4.204   132.391     0.200
     4.562   143.297     0.200
     4.562   142.992     0.200
     5.141   160.195     0.200
     5.478   171.594     0.200
     5.766   180.891     0.200
     6.989   217.094     0.200
     7.874   246.797     0.200
     8.091   250.695     0.200
     2.859    88.500     0.200
     2.590    81.402     0.200
     2.590    81.199     0.200
     2.929    91.699     0.200
     3.640   113.801     0.200
     4.771   148.199     0.200
     5.178   162.602     0.200
     5.700   177.000     0.200
     6.091   191.102     0.200
     6.400   201.402     0.200
     8.472   265.000     0.200
    11.184   345.301     0.200
     2.534    79.367     0.200
     2.534    78.969     0.200
     2.781    86.766     0.200
     2.781    85.664     0.200
     3.505   110.766     0.200
     3.790   117.062     0.200
     3.816   118.469     0.200
     3.816   118.164     0.200
     4.069   127.164     0.200
     4.759   148.969     0.200
     4.845   151.766     0.200
     5.403   165.367     0.200
     6.480   201.664     0.200
     7.243   225.766     0.200
     7.563   236.164     0.200
     7.798   244.766     0.200
     8.828   275.062     0.200
     9.547   295.766     0.200
    10.064   311.664     0.200
    10.497   324.766     0.200
    10.920   339.344     0.200
    10.958   339.469     0.200
     2.538    79.883     0.200
     2.538    79.484     0.200
     2.782    86.781     0.200
     2.782    85.578     0.200
     3.509   110.984     0.200
     3.509   110.578     0.200
     3.819   118.383     0.200
     3.819   118.781     0.200
     4.073   127.680     0.200
     4.073   126.078     0.200
     4.762   148.383     0.200
     4.762   148.984     0.200
     4.850   150.578     0.200
     4.850   149.883     0.200
     5.221   163.180     0.200
     5.400   164.883     0.200
     7.247   225.484     0.200
     7.568   235.883     0.200
     3.560   111.117     0.200
     3.560   111.219     0.200
     3.892   123.316     0.200
     3.892   120.617     0.200
     4.113   126.418     0.200
     4.501   141.316     0.200
     4.929   154.316     0.200
     5.098   159.719     0.200
     5.731   177.117     0.200
     6.188   192.117     0.200
     6.318   196.617     0.200
     7.349   229.719     0.200
     7.420   233.418     0.200
     3.236   102.590     0.200
     3.236   101.390     0.200
     3.563   111.490     0.200
     3.563   110.490     0.200
     3.897   123.190     0.200
     4.109   127.590     0.200
     3.227   100.875     0.200
     3.554   111.578     0.200
     3.884   122.680     0.200
     4.495   141.078     0.200
     5.089   160.375     0.200
     5.735   176.875     0.200
     7.340   229.375     0.200
     3.231   101.555     0.200
     3.231   102.254     0.200
     3.558   111.656     0.200
     3.558   111.055     0.200
     3.888   122.855     0.200
     3.888   121.457     0.200
     4.499   140.555     0.200
     4.923   153.355     0.200
     5.094   160.254     0.200
     5.935   186.855     0.200
     6.314   198.355     0.200
     6.556   204.855     0.200
     7.343   230.156     0.200
     7.416   231.656     0.200
     7.810   244.855     0.200
     8.690   268.656     0.200
     9.895   306.754     0.200
    10.980   340.055     0.200
     2.527    80.023     0.200
     2.696    85.223     0.200
     3.288   103.324     0.200
     3.288   105.723     0.200
     3.635   113.922     0.200
     3.635   113.324     0.200
     4.057   127.223     0.200
     4.566   142.723     0.200
     4.566   143.523     0.200
     5.274   165.625     0.200
     5.312   167.125     0.200
     6.486   203.125     0.200
     7.605   238.125     0.200
     7.700   241.523     0.200
     3.235   101.719     0.200
     3.235   102.219     0.200
     3.562   110.922     0.200
     3.562   110.719     0.200
     3.895   122.617     0.200
     3.895   120.117     0.200
     4.110   127.016     0.200
     4.503   141.617     0.200
     4.503   140.617     0.200
     4.935   153.117     0.200
     5.102   160.320     0.200
     5.731   177.219     0.200
     6.321   196.922     0.200
     7.354   229.320     0.200
     7.424   232.820     0.200
     9.407   294.820     0.200
     9.902   309.922     0.200
    10.787   335.617     0.200
    10.985   342.820     0.200
     2.813    86.312     0.200
     2.887    90.008     0.200
     3.045    95.508     0.200
     3.045    95.312     0.200
     3.436   106.312     0.200
     3.710   115.812     0.200
     3.893   122.414     0.200
     4.141   129.109     0.200
     4.231   132.812     0.200
     4.231   131.609     0.200
     4.586   144.211     0.200
     4.586   142.312     0.200
     5.168   162.312     0.200
     5.168   160.008     0.200
     5.488   172.414     0.200
     5.787   181.312     0.200
     6.630   208.211     0.200
     6.755   207.312     0.200
     7.790   242.711     0.200
     7.827   244.414     0.200
     7.882   247.211     0.200
     8.497   266.008     0.200
    10.097   315.711     0.200
    11.478   357.508     0.200
    11.554   363.914     0.200
    11.670   362.609     0.200
     2.698    83.625     0.200
     2.698    83.727     0.200
     2.769    86.828     0.200
     3.005    94.328     0.200
     3.005    93.922     0.200
     3.606   110.727     0.200
     3.745   116.727     0.200
     3.745   117.523     0.200
     4.141   128.227     0.200
     4.098   127.227     0.200
     4.535   141.727     0.200
     4.535   141.523     0.200
     5.024   156.922     0.200
     5.670   177.727     0.200
     5.787   180.328     0.200
     6.622   207.227     0.200
     6.964   217.523     0.200
     7.749   242.328     0.200
     7.805   241.922     0.200
     8.085   252.422     0.200
     8.327   261.523     0.200
     8.377   260.828     0.200
     8.520   266.625     0.200
     9.365   292.023     0.200
     9.416   291.922     0.200
    10.534   327.328     0.200
    11.073   346.422     0.200
    11.410   353.828     0.200
    11.665   364.422     0.200
     2.711    84.250     0.200
     2.773    86.150     0.200
     3.013    94.051     0.200
     3.013    93.950     0.200
     3.605   111.551     0.200
     3.748   116.450     0.200
     3.748   117.551     0.200
     4.024   124.150     0.200
     4.101   127.450     0.200
     4.101   127.551     0.200
     4.542   141.551     0.200
     5.027   156.650     0.200
     5.683   177.851     0.200
     5.796   180.650     0.200
     6.799   209.150     0.200
     6.971   217.150     0.200
     3.231   100.840     0.200
     3.231   102.739     0.200
     3.558   111.140     0.200
     3.558   110.239     0.200
     4.261   133.939     0.200
     4.499   141.140     0.200
     4.937   153.640     0.200
     5.101   159.840     0.200
     5.941   184.939     0.200
     6.319   197.040     0.200
     7.357   227.939     0.200
     7.422   231.840     0.200
     2.541    80.070     0.200
     2.541    79.170     0.200
     2.710    83.270     0.200
     3.563   111.971     0.200
     3.563   112.770     0.200
     3.800   118.070     0.200
     3.918   122.770     0.200
     3.885   121.070     0.200
     3.885   120.670     0.200
     4.183   131.270     0.200
     4.183   132.471     0.200
     4.827   149.371     0.200
     5.043   157.371     0.200
     5.043   156.971     0.200
     5.394   165.170     0.200
     5.358   168.670     0.200
     6.203   194.971     0.200
     6.603   206.770     0.200
     7.178   220.170     0.200
     7.355   228.871     0.200
     7.695   241.770     0.200
     7.891   246.270     0.200
    11.102   350.330     0.200
    11.290   350.670     0.200
     2.523    78.814     0.200
     2.633    81.713     0.200
     2.633    81.914     0.200
     2.675    82.613     0.200
     3.543   111.414     0.200
     3.814   116.713     0.200
     3.867   119.014     0.200
     3.946   122.514     0.200
     4.174   129.514     0.200
     4.174   130.113     0.200
     4.809   148.914     0.200
     5.355   167.113     0.200
     6.199   194.014     0.200
     6.595   207.213     0.200
     7.462   232.414     0.200
     7.689   240.914     0.200
     2.536    79.555     0.200
     2.640    83.555     0.200
     2.640    83.359     0.200
     2.698    83.961     0.200
     2.698    83.859     0.200
     3.557   112.258     0.200
     3.557   112.656     0.200
     3.804   117.859     0.200
     3.879   121.055     0.200
     3.927   121.461     0.200
     4.181   130.359     0.200
     4.181   129.656     0.200
     4.821   151.156     0.200
     4.821   150.859     0.200
     5.358   168.656     0.200
     5.403   167.555     0.200
     6.202   193.258     0.200
     6.601   207.258     0.200
     7.355   228.055     0.200
     7.451   232.555     0.200
     7.694   240.055     0.200
     8.963   277.961     0.200
    10.184   318.555     0.200
    11.106   346.781     0.200
     2.540    79.910     0.200
     2.540    78.812     0.200
     2.701    84.312     0.200
     3.800   116.613     0.200
     3.800   116.410     0.200
     3.884   121.711     0.200
     3.884   119.812     0.200
     3.923   123.211     0.200
     4.185   130.711     0.200
     4.577   141.512     0.200
     4.826   150.211     0.200
     5.399   165.711     0.200
     6.606   206.812     0.200
     7.360   228.910     0.200
     7.454   233.312     0.200
     7.699   239.812     0.200
     2.544    80.504     0.200
     2.706    84.404     0.200
     3.565   113.104     0.200
     3.888   121.504     0.200
     3.918   123.205     0.200
     4.189   131.805     0.200
     4.575   142.404     0.200
     4.830   151.205     0.200
     5.365   168.504     0.200
     6.210   195.205     0.200
     6.609   207.805     0.200
     7.362   229.904     0.200
     7.454   233.904     0.200
     7.702   241.305     0.200
     8.066   253.205     0.200
    11.111   348.805     0.200
     3.243   101.422     0.200
     3.572   110.625     0.200
     3.572   110.422     0.200
     3.914   123.328     0.200
     4.098   126.828     0.200
     4.513   140.625     0.200
     4.969   156.625     0.200
     5.125   160.922     0.200
     6.341   198.828     0.200
     7.424   229.922     0.200
     7.389   229.727     0.200
     7.445   232.328     0.200
     8.720   272.227     0.200
     9.921   308.227     0.200
     2.502    77.693     0.200
     2.502    77.094     0.200
     2.554    80.894     0.200
     2.736    86.293     0.200
     2.736    85.793     0.200
     3.556   112.193     0.200
     3.556   112.993     0.200
     3.773   116.293     0.200
     3.773   115.394     0.200
     3.800   116.394     0.200
     3.896   122.394     0.200
     3.896   121.394     0.200
     4.039   123.993     0.200
     4.275   134.193     0.200
     4.422   136.693     0.200
     4.832   151.394     0.200
     5.321   168.094     0.200
     5.499   172.493     0.200
     6.703   209.493     0.200
     7.059   217.094     0.200
     7.452   233.094     0.200
     7.734   243.594     0.200
     7.812   245.094     0.200
     9.090   283.693     0.200
     9.795   304.593     0.200
    10.281   319.593     0.200
    11.343   353.093     0.200
     3.367   105.890     0.200
     3.701   116.690     0.200
     4.308   135.190     0.200
     4.810   150.490     0.200
     4.916   155.390     0.200
     5.908   181.790     0.200
     6.128   190.690     0.200
     7.236   224.590     0.200
     2.527    78.589     0.200
     2.527    79.889     0.200
     2.636    82.389     0.200
     2.636    82.789     0.200
     2.683    82.489     0.200
     2.683    83.589     0.200
     3.786   116.689     0.200
     3.871   120.089     0.200
     3.871   120.589     0.200
     4.176   129.889     0.200
     4.176   131.089     0.200
     4.813   149.789     0.200
     5.056   159.289     0.200
     5.356   166.989     0.200
     6.200   195.089     0.200
     6.597   206.489     0.200
     7.354   230.189     0.200
     7.458   232.889     0.200
     8.059   252.189     0.200
     2.645    82.266     0.200
     2.645    83.070     0.200
     3.481   110.172     0.200
     3.481   110.070     0.200
     3.849   119.672     0.200
     3.849   118.367     0.200
     3.818   118.867     0.200
     4.082   126.266     0.200
     4.184   131.570     0.200
     4.755   148.172     0.200
     4.755   148.070     0.200
     5.224   164.867     0.200
     5.403   169.867     0.200
     5.565   170.266     0.200
     6.047   187.672     0.200
     6.243   195.367     0.200
     6.613   206.570     0.200
     7.392   230.969     0.200
     7.413   230.969     0.200
     7.441   232.367     0.200
     7.638   238.867     0.200
     7.720   242.172     0.200
     8.996   279.969     0.200
    10.191   315.867     0.200
    11.074   344.867     0.200
    11.259   349.969     0.200
     2.639    82.094     0.200
     2.639    83.395     0.200
     3.480   110.195     0.200
     3.851   118.492     0.200
     3.865   119.492     0.200
     3.816   117.992     0.200
     3.816   118.992     0.200
     4.179   131.895     0.200
     4.525   141.293     0.200
     4.754   148.492     0.200
     4.754   148.094     0.200
     5.211   165.094     0.200
     5.560   170.594     0.200
     6.041   186.695     0.200
     6.236   195.793     0.200
     6.607   206.594     0.200
     7.377   230.094     0.200
     7.434   231.492     0.200
     7.625   237.492     0.200
     7.714   241.895     0.200
     8.116   251.395     0.200
     8.990   280.594     0.200
     9.697   303.594     0.200
    10.186   315.895     0.200
    11.069   343.895     0.200
    11.256   350.195     0.200
     2.636    83.020     0.200
     2.636    83.418     0.200
     3.475   110.117     0.200
     3.812   117.918     0.200
     3.812   119.020     0.200
     3.855   119.719     0.200
     3.855   118.617     0.200
     3.870   119.719     0.200
     4.176   131.719     0.200
     4.749   148.617     0.200
     4.749   148.316     0.200
     5.212   163.617     0.200
     5.394   169.520     0.200
     6.234   196.219     0.200
     6.604   204.418     0.200
     7.382   230.957     0.200
     7.404   233.020     0.200
     7.432   233.520     0.200
     7.626   238.117     0.200
     7.627   236.816     0.200
     7.984   248.719     0.200
     8.987   279.816     0.200
     9.694   302.418     0.200
    10.183   315.816     0.200
    10.682   331.020     0.200
    11.222   352.797     0.200
    11.252   351.020     0.200
     2.639    82.445     0.200
     2.639    83.445     0.200
     3.474   108.445     0.200
     3.811   118.547     0.200
     3.856   121.547     0.200
     3.872   118.945     0.200
     4.178   131.648     0.200
     4.178   130.250     0.200
     4.749   148.648     0.200
     4.749   148.148     0.200
     5.221   163.148     0.200
     6.238   196.547     0.200
     6.607   207.750     0.200
     7.394   232.047     0.200
     7.408   231.844     0.200
     7.436   233.844     0.200
     7.631   238.344     0.200
     7.635   238.445     0.200
     7.714   240.547     0.200
     7.987   248.047     0.200
    10.686   330.750     0.200
    11.253   350.648     0.200
     2.701    83.641     0.200
     2.701    85.141     0.200
     2.803    86.039     0.200
     2.803    86.242     0.200
     3.783   117.945     0.200
     4.045   125.242     0.200
     4.987   155.242     0.200
     5.526   173.344     0.200
     6.371   199.945     0.200
     6.772   212.039     0.200
     7.522   234.039     0.200
     7.577   236.344     0.200
     7.733   240.242     0.200
     7.864   244.445     0.200
     8.225   256.039     0.200
    10.354   321.539     0.200
    11.244   349.539     0.200
    11.456   355.945     0.200
     2.698    84.070     0.200
     2.698    84.875     0.200
     2.805    86.375     0.200
     3.783   118.070     0.200
     4.042   125.875     0.200
     4.984   155.773     0.200
     5.521   172.875     0.200
     6.366   200.070     0.200
     6.767   211.875     0.200
     7.517   234.773     0.200
     7.570   236.570     0.200
     7.728   240.773     0.200
     8.053   252.070     0.200
     2.819    89.082     0.200
     2.669    81.980     0.200
     3.203    99.680     0.200
     3.920   122.883     0.200
     4.136   128.480     0.200
     4.893   151.980     0.200
     5.673   176.883     0.200
     6.172   191.781     0.200
     6.547   203.680     0.200
     6.898   214.781     0.200
     7.738   241.980     0.200
     8.936   278.883     0.200
     9.124   285.582     0.200
     9.613   301.383     0.200
     2.529    77.789     0.200
     2.715    83.289     0.200
     2.913    90.590     0.200
     3.273   100.488     0.200
     3.453   107.289     0.200
     3.453   106.391     0.200
     3.931   123.188     0.200
     4.161   129.789     0.200
     4.897   153.188     0.200
     5.254   164.391     0.200
     5.695   179.090     0.200
     6.175   193.289     0.200
     6.612   207.289     0.200
     6.930   216.988     0.200
     7.769   244.789     0.200
     8.125   254.188     0.200
     8.967   279.188     0.200
     9.162   287.590     0.200
     9.240   290.688     0.200
     9.469   296.188     0.200
     9.651   302.789     0.200
    10.519   329.391     0.200
    11.221   348.891     0.200
    11.697   362.891     0.200
    12.218   381.090     0.200
    12.574   391.188     0.200
    12.724   397.488     0.200
     2.547    80.055     0.200
     2.730    85.359     0.200
     3.548   112.359     0.200
     3.548   110.953     0.200
     3.780   116.258     0.200
     3.780   116.453     0.200
     3.808   117.055     0.200
     3.888   121.453     0.200
     4.269   133.555     0.200
     4.427   135.656     0.200
     4.824   149.953     0.200
     5.320   166.156     0.200
     5.493   172.156     0.200
     6.333   197.555     0.200
     6.697   207.953     0.200
     7.065   217.953     0.200
     7.457   232.055     0.200
     7.729   242.359     0.200
     7.807   244.156     0.200
     8.032   250.258     0.200
     8.216   257.258     0.200
     9.084   281.453     0.200
     9.789   304.859     0.200
    10.275   320.555     0.200
    10.781   336.758     0.200
    11.156   347.859     0.200
    11.336   353.055     0.200
     2.805    89.711     0.200
     2.805    87.812     0.200
     3.118    96.312     0.200
     3.118    98.016     0.200
     3.415   106.914     0.200
     3.415   107.914     0.200
     4.061   127.016     0.200
     4.539   140.016     0.200
     4.575   142.312     0.200
     4.537   141.914     0.200
     4.633   145.117     0.200
     4.618   144.617     0.200
     4.618   144.414     0.200
     5.458   171.414     0.200
     5.839   183.211     0.200
     6.850   214.914     0.200
     6.940   216.016     0.200
     6.967   218.312     0.200
     7.127   221.516     0.200
     8.214   256.117     0.200
     9.421   293.516     0.200
    10.308   319.312     0.200
     2.885    89.891     0.200
     2.885    88.891     0.200
     3.267   100.891     0.200
     3.404   107.094     0.200
     3.673   115.492     0.200
     3.759   116.594     0.200
     4.352   134.793     0.200
     4.714   146.594     0.200
     5.226   159.492     0.200
     5.196   162.594     0.200
     5.628   174.793     0.200
     6.462   202.492     0.200
     7.294   228.992     0.200
     7.623   237.594     0.200
     8.128   254.594     0.200
     8.716   273.891     0.200
     8.713   272.691     0.200
     8.748   272.391     0.200
     9.197   287.992     0.200
    10.031   311.691     0.200
    11.186   348.094     0.200
    12.056   374.293     0.200
    12.187   378.691     0.200
    12.338   387.383     0.200
     2.718    84.744     0.200
     2.718    84.845     0.200
     3.242   101.244     0.200
     3.388   105.145     0.200
     3.488   107.544     0.200
     3.862   119.145     0.200
     3.976   124.645     0.200
     4.330   135.145     0.200
     4.772   147.744     0.200
     4.772   148.645     0.200
     5.255   162.845     0.200
     5.865   184.345     0.200
     6.022   188.345     0.200
     6.857   213.444     0.200
     7.201   225.944     0.200
     8.753   272.744     0.200
    10.771   335.044     0.200
    11.646   361.244     0.200
    11.798   364.944     0.200
     2.668    83.416     0.200
     2.668    84.116     0.200
     2.681    84.416     0.200
     3.098    95.716     0.200
     3.683   114.416     0.200
     3.703   114.716     0.200
     3.716   117.416     0.200
     3.708   118.216     0.200
     3.708   117.816     0.200
     3.811   116.916     0.200
     3.811   118.416     0.200
     4.002   124.516     0.200
     4.002   126.116     0.200
     4.183   131.216     0.200
     4.183   132.016     0.200
     4.943   155.816     0.200
     5.273   166.316     0.200
     5.584   176.016     0.200
     6.121   191.916     0.200
     6.572   205.316     0.200
     7.097   221.916     0.200
     7.238   226.116     0.200
     7.311   230.716     0.200
     7.431   233.116     0.200
     8.997   282.016     0.200
    10.152   314.816     0.200
    11.315   353.216     0.200
     2.826    89.703     0.200
     2.980    92.906     0.200
     3.497   107.703     0.200
     3.514   109.203     0.200
     3.753   117.609     0.200
     3.834   121.508     0.200
     4.170   131.203     0.200
     4.522   141.008     0.200
     4.522   141.906     0.200
     5.108   160.203     0.200
     5.430   170.406     0.200
     5.722   178.109     0.200
     6.564   206.703     0.200
     6.948   219.203     0.200
     7.361   229.508     0.200
     7.725   242.805     0.200
     7.762   244.109     0.200
     7.826   244.203     0.200
     7.942   249.508     0.200
     8.049   251.008     0.200
     8.258   259.008     0.200
     8.310   261.203     0.200
     8.432   264.508     0.200
     9.322   289.508     0.200
     9.395   292.406     0.200
     9.395   291.008     0.200
    10.032   312.406     0.200
    10.528   328.609     0.200
    11.009   343.008     0.200
    11.211   352.508     0.200
    11.414   356.406     0.200
    11.607   360.305     0.200
     2.751    85.766     0.200
     2.841    87.766     0.200
     2.841    88.164     0.200
     2.894    88.766     0.200
     2.894    88.867     0.200
     3.562   110.969     0.200
     3.598   110.766     0.200
     3.709   115.867     0.200
     3.774   118.164     0.200
     3.774   118.266     0.200
     4.094   127.070     0.200
     4.380   136.766     0.200
     5.037   157.469     0.200
     5.147   161.164     0.200
     5.652   175.367     0.200
     5.540   172.867     0.200
     6.386   201.266     0.200
     6.796   212.969     0.200
     7.534   236.070     0.200
     7.530   234.867     0.200
     7.582   238.969     0.200
     7.738   241.664     0.200
     7.883   246.969     0.200
     8.068   251.570     0.200
     8.122   255.766     0.200
     8.230   256.969     0.200
     9.149   286.867     0.200
     9.237   286.570     0.200
     9.867   307.164     0.200
    10.821   337.766     0.200
    10.821   334.469     0.200
    11.239   352.945     0.200
    11.271   350.266     0.200
    11.493   356.867     0.200
     3.508   109.004     0.200
     3.746   117.004     0.200
     4.174   129.504     0.200
     4.524   140.704     0.200
     5.113   159.604     0.200
     5.231   160.304     0.200
     5.427   170.204     0.200
     5.726   177.304     0.200
     2.847    88.496     0.200
     2.883    88.598     0.200
     2.883    88.797     0.200
     3.257    99.598     0.200
     3.329   104.996     0.200
     3.580   111.797     0.200
     3.580   112.297     0.200
     3.710   114.996     0.200
     4.290   135.996     0.200
     4.648   145.098     0.200
     5.107   159.797     0.200
     5.568   173.996     0.200
     6.362   200.496     0.200
     8.580   268.195     0.200
     8.657   270.598     0.200
     9.988   309.695     0.200
    10.636   329.797     0.200
    11.104   344.797     0.200
    11.942   374.598     0.200
     2.635    83.935     0.200
     2.635    83.635     0.200
     2.682    84.835     0.200
     2.952    91.435     0.200
     2.952    92.435     0.200
     3.274   102.935     0.200
     3.274   103.035     0.200
     3.894   121.335     0.200
     3.894   122.335     0.200
     4.497   140.535     0.200
     4.511   141.635     0.200
     4.704   146.335     0.200
     4.731   147.435     0.200
     4.731   146.435     0.200
     6.697   209.335     0.200
     6.808   211.935     0.200
     6.946   217.435     0.200
     8.085   252.435     0.200
     8.150   255.235     0.200
     8.791   275.135     0.200
     9.280   290.435     0.200
    10.363   321.435     0.200
     2.743    86.582     0.200
     2.743    86.281     0.200
     2.871    90.582     0.200
     2.871    90.082     0.200
     3.584   111.781     0.200
     3.578   111.980     0.200
     3.758   119.680     0.200
     4.087   127.082     0.200
     4.412   138.180     0.200
     4.412   137.180     0.200
     5.028   159.180     0.200
     5.028   157.379     0.200
     5.277   166.980     0.200
     6.442   202.680     0.200
     6.835   214.082     0.200
     7.672   239.680     0.200
     7.931   247.180     0.200
     8.132   255.480     0.200
     8.302   261.980     0.200
    10.417   325.180     0.200
    11.510   358.480     0.200
     2.805    86.062     0.200
     3.447   106.762     0.200
     3.912   122.062     0.200
     3.912   121.961     0.200
     4.251   132.461     0.200
     4.615   143.863     0.200
     5.534   172.961     0.200
     5.821   181.863     0.200
     7.042   219.762     0.200
     7.430   231.660     0.200
     7.861   246.961     0.200
     7.929   248.863     0.200
     8.044   251.863     0.200
     8.145   254.863     0.200
     8.409   263.262     0.200
    10.129   314.961     0.200
    10.622   331.961     0.200
    11.109   346.863     0.200
    11.506   356.660     0.200
    11.694   364.262     0.200
     2.776    85.559     0.200
     3.456   106.059     0.200
     3.456   107.859     0.200
     3.744   115.961     0.200
     3.872   122.262     0.200
     3.872   120.359     0.200
     4.211   132.059     0.200
     4.574   143.762     0.200
     5.502   172.762     0.200
     5.781   181.461     0.200
     7.001   219.059     0.200
     7.421   232.961     0.200
     7.821   246.859     0.200
     7.898   248.762     0.200
     8.004   251.160     0.200
     8.105   254.160     0.200
    10.088   313.660     0.200
    10.581   329.160     0.200
    11.069   345.559     0.200
    11.466   358.660     0.200
    11.654   360.461     0.200
     2.778    85.441     0.200
     2.866    89.641     0.200
     2.866    89.840     0.200
     3.458   107.240     0.200
     3.458   107.441     0.200
     3.743   116.641     0.200
     3.871   123.441     0.200
     3.871   122.541     0.200
     4.209   132.340     0.200
     4.572   142.541     0.200
     4.572   143.840     0.200
     5.146   161.041     0.200
     5.778   180.941     0.200
     6.999   220.941     0.200
     7.818   245.340     0.200
     7.893   247.141     0.200
     8.001   251.740     0.200
     8.102   254.840     0.200
    10.085   314.941     0.200
    10.578   331.240     0.200
    11.065   343.740     0.200
    11.651   360.441     0.200
     2.760    85.023     0.200
     2.760    85.219     0.200
     3.614   111.625     0.200
     3.621   112.523     0.200
     3.722   117.719     0.200
     3.722   116.523     0.200
     3.806   118.023     0.200
     4.051   125.523     0.200
     4.051   126.023     0.200
     4.328   135.023     0.200
     4.375   136.719     0.200
     4.991   156.625     0.200
     5.288   161.719     0.200
     5.249   163.625     0.200
     5.249   167.023     0.200
     5.562   173.922     0.200
     5.766   178.719     0.200
     6.405   201.219     0.200
     6.798   211.125     0.200
     7.646   238.719     0.200
     9.243   290.023     0.200
    10.380   322.125     0.200
     2.757    84.990     0.200
     3.612   111.990     0.200
     3.618   112.090     0.200
     3.618   112.590     0.200
     3.724   117.791     0.200
     3.724   116.791     0.200
     4.053   125.590     0.200
     4.323   135.490     0.200
     4.380   135.590     0.200
     4.380   136.191     0.200
     4.994   155.490     0.200
     5.567   173.590     0.200
     5.768   178.990     0.200
     6.411   201.191     0.200
     6.803   213.191     0.200
     7.608   238.490     0.200
     7.654   238.490     0.200
     7.900   245.590     0.200
     9.884   306.791     0.200
     2.708    83.783     0.200
     2.710    85.682     0.200
     3.938   122.883     0.200
     4.251   133.682     0.200
     5.369   164.383     0.200
     2.772    85.641     0.200
     2.926    92.641     0.200
     3.541   108.641     0.200
     3.549   109.836     0.200
     3.769   117.039     0.200
     4.269   130.641     0.200
     2.654    83.480     0.200
     2.755    86.680     0.200
     3.660   113.180     0.200
     3.997   124.180     0.200
     4.295   134.883     0.200
     5.121   160.180     0.200
     5.467   171.281     0.200
     2.541    78.402     0.200
     2.541    78.801     0.200
     3.343   104.902     0.200
     3.665   114.500     0.200
     3.991   123.500     0.200
     4.018   124.000     0.200
     3.971   123.902     0.200
     4.129   129.203     0.200
     4.195   130.301     0.200
     4.607   144.402     0.200
     4.772   147.203     0.200
     4.917   155.301     0.200
     5.602   172.801     0.200
     6.001   189.500     0.200
     7.199   228.000     0.200
     7.329   229.902     0.200
     8.761   276.000     0.200
     8.838   272.902     0.200
     9.473   297.602     0.200
    10.445   328.203     0.200
    10.864   337.902     0.200
     2.540    78.484     0.200
     2.540    78.984     0.200
     3.324   105.586     0.200
     3.645   114.184     0.200
     3.946   123.684     0.200
     3.946   124.484     0.200
     4.041   124.684     0.200
     4.199   132.484     0.200
     4.587   144.785     0.200
     4.800   147.883     0.200
     4.889   151.383     0.200
     4.889   154.684     0.200
     5.131   159.984     0.200
     5.131   162.086     0.200
     5.615   172.184     0.200
     6.368   199.484     0.200
     7.349   231.285     0.200
     7.464   234.086     0.200
     7.839   247.184     0.200
     8.734   272.785     0.200
     8.813   273.883     0.200
     9.950   309.484     0.200
    11.050   342.785     0.200
     2.502    78.879     0.200
     2.689    84.480     0.200
     3.843   120.082     0.200
     4.227   132.582     0.200
     2.753    84.701     0.200
     2.780    87.601     0.200
     2.931    91.401     0.200
     2.931    92.201     0.200
     3.542   112.001     0.200
     3.555   109.401     0.200
     3.784   119.901     0.200
     3.790   120.801     0.200
     4.124   129.701     0.200
     4.258   132.301     0.200
     4.287   131.401     0.200
     4.472   139.501     0.200
     5.063   158.501     0.200
     5.671   177.001     0.200
     5.760   180.901     0.200
     6.514   203.501     0.200
     7.779   243.301     0.200
     7.998   249.001     0.200
     8.380   263.101     0.200
     2.502    78.355     0.200
     2.502    79.156     0.200
     2.687    84.656     0.200
     2.687    84.758     0.200
     3.504   110.855     0.200
     3.825   117.059     0.200
     3.852   118.156     0.200
     3.844   119.355     0.200
     4.225   132.758     0.200
     4.780   149.457     0.200
     4.780   149.656     0.200
     5.291   167.656     0.200
     5.452   170.957     0.200
     6.290   196.656     0.200
     7.488   233.059     0.200
     7.706   242.656     0.200
     7.706   239.656     0.200
     7.764   244.258     0.200
     8.041   250.457     0.200
     8.175   257.156     0.200
     9.041   280.957     0.200
    11.292   350.957     0.200
     2.686    84.547     0.200
     3.499   110.348     0.200
     3.829   118.648     0.200
     3.829   118.848     0.200
     3.859   118.047     0.200
     3.840   120.148     0.200
     3.840   119.148     0.200
     4.010   125.250     0.200
     4.224   131.648     0.200
     4.775   149.648     0.200
     6.653   206.148     0.200
     7.715   240.750     0.200
     7.715   242.250     0.200
     7.764   242.047     0.200
    10.230   318.047     0.200
     2.684    84.605     0.200
     2.684    84.504     0.200
     3.499   111.105     0.200
     3.499   110.504     0.200
     3.830   117.402     0.200
     3.858   118.004     0.200
     3.839   118.305     0.200
     3.839   119.805     0.200
     4.016   125.203     0.200
     4.095   126.605     0.200
     4.222   130.703     0.200
     4.222   132.105     0.200
     4.471   138.105     0.200
     4.775   147.203     0.200
     4.775   149.203     0.200
     5.293   165.902     0.200
     5.450   170.605     0.200
     5.450   170.305     0.200
     6.288   195.402     0.200
     6.651   207.402     0.200
     7.486   233.203     0.200
     7.761   243.305     0.200
     8.040   251.605     0.200
     8.174   254.703     0.200
     9.101   283.305     0.200
     9.743   303.004     0.200
     9.743   304.402     0.200
    10.228   318.004     0.200
    11.109   345.402     0.200
     2.750    84.691     0.200
     2.794    87.791     0.200
     2.948    92.090     0.200
     4.137   128.990     0.200
     4.490   140.791     0.200
     5.075   158.090     0.200
     5.267   162.291     0.200
     5.691   177.691     0.200
     2.784    88.035     0.200
     2.932    92.135     0.200
     4.128   128.836     0.200
     4.473   140.436     0.200
     5.262   162.035     0.200
     2.561    81.336     0.200
     2.561    80.035     0.200
     3.256   104.434     0.200
     3.595   111.637     0.200
     3.595   110.734     0.200
     3.978   124.934     0.200
     4.072   127.035     0.200
     4.092   125.734     0.200
     4.092   129.734     0.200
     4.531   142.336     0.200
     4.531   141.934     0.200
     5.120   161.836     0.200
     5.213   163.836     0.200
     6.408   200.836     0.200
     7.456   234.137     0.200
     7.520   234.934     0.200
     7.544   237.637     0.200
     8.799   276.336     0.200
     9.984   311.535     0.200
    11.042   344.734     0.200
     2.654    83.212     0.200
     2.654    83.012     0.200
     2.718    84.312     0.200
     2.718    83.812     0.200
     2.783    86.911     0.200
     3.666   112.712     0.200
     3.673   112.212     0.200
     3.669   116.312     0.200
     3.855   119.312     0.200
     3.998   123.411     0.200
     3.998   123.111     0.200
     4.295   133.712     0.200
     4.324   136.111     0.200
     4.324   134.812     0.200
     5.216   164.411     0.200
     5.513   171.911     0.200
     6.748   208.812     0.200
     9.829   307.111     0.200
    10.330   320.512     0.200
    10.800   338.611     0.200
    11.217   351.012     0.200
    11.421   356.111     0.200
     2.859    88.852     0.200
     2.866    89.148     0.200
     3.112    98.547     0.200
     3.401   104.648     0.200
     3.465   109.250     0.200
     3.465   108.352     0.200
     3.576   111.648     0.200
     4.479   139.148     0.200
     4.479   138.547     0.200
     4.809   150.750     0.200
     4.809   148.945     0.200
     4.844   150.148     0.200
     5.115   160.852     0.200
     5.750   179.750     0.200
     5.754   180.547     0.200
     6.270   194.945     0.200
     7.531   236.648     0.200
     8.103   253.445     0.200
     8.311   260.148     0.200
     8.456   266.047     0.200
     8.617   270.148     0.200
     8.848   274.852     0.200
     8.950   279.047     0.200
    11.115   347.945     0.200
    11.547   360.352     0.200
    12.007   373.445     0.200
    12.224   382.945     0.200
     2.552    81.742     0.200
     2.552    80.445     0.200
     2.864    88.148     0.200
     2.959    93.148     0.200
     3.365   105.242     0.200
     3.493   109.648     0.200
     4.481   139.844     0.200
     4.481   140.148     0.200
     4.829   151.148     0.200
     5.227   162.945     0.200
     5.227   161.945     0.200
     5.760   178.547     0.200
     6.105   193.047     0.200
     6.442   203.344     0.200
     7.186   219.633     0.200
     7.186   219.242     0.200
     7.656   238.547     0.200
     7.714   242.242     0.200
     8.481   265.148     0.200
     8.763   272.648     0.200
     9.031   284.742     0.200
    10.746   336.742     0.200
    11.234   351.742     0.200
    11.730   367.445     0.200
    12.115   374.445     0.200
    12.201   384.469     0.200
    12.288   383.648     0.200
    17.288   540.344     0.200
     2.565    80.984     0.200
     2.565    80.188     0.200
     2.683    82.789     0.200
     2.683    84.188     0.200
     3.583   112.688     0.200
     3.751   116.086     0.200
     3.768   116.984     0.200
     3.909   120.883     0.200
     3.918   122.484     0.200
     4.224   132.484     0.200
     4.224   132.586     0.200
     4.850   151.586     0.200
     5.115   161.086     0.200
     5.408   169.586     0.200
     6.646   206.086     0.200
     8.113   253.586     0.200
     2.547    79.070     0.200
     3.389   107.672     0.200
     3.389   108.270     0.200
     3.713   115.270     0.200
     3.713   114.672     0.200
     3.945   122.371     0.200
     3.964   121.871     0.200
     4.029   126.371     0.200
     4.096   127.770     0.200
     4.187   129.469     0.200
     4.655   146.570     0.200
     4.981   158.371     0.200
     5.220   163.270     0.200
     6.452   200.969     0.200
     7.392   231.270     0.200
     7.440   233.770     0.200
     7.550   234.570     0.200
     7.930   247.871     0.200
     9.534   295.270     0.200
    10.034   314.969     0.200
    10.507   327.172     0.200
    10.922   339.969     0.200
    11.128   345.270     0.200
     3.826   118.773     0.200
     3.842   117.672     0.200
     4.104   126.375     0.200
     4.208   131.477     0.200
     4.484   138.578     0.200
     4.762   147.172     0.200
     2.746    84.617     0.200
     3.775   117.117     0.200
     3.884   121.414     0.200
     3.914   122.516     0.200
     4.206   132.414     0.200
     4.569   141.215     0.200
     4.856   150.816     0.200
     2.522    77.411     0.200
     2.633    82.711     0.200
     2.506    79.110     0.200
     2.827    88.311     0.200
     2.827    87.011     0.200
     3.629   114.311     0.200
     3.700   114.811     0.200
     3.740   114.811     0.200
     3.972   124.511     0.200
     4.003   124.110     0.200
     4.364   136.911     0.200
     4.906   152.511     0.200
     5.594   175.511     0.200
     6.794   211.811     0.200
     7.831   244.411     0.200
     7.833   245.911     0.200
     8.318   260.011     0.200
    11.250   349.711     0.200
     3.250   103.087     0.200
     3.572   111.887     0.200
     4.108   127.087     0.200
     3.885   123.187     0.200
     4.132   128.387     0.200
     4.221   131.287     0.200
     8.679   271.787     0.200
     8.754   273.587     0.200
     8.929   279.787     0.200
     9.390   291.487     0.200
     9.890   308.387     0.200
    10.366   323.787     0.200
    10.778   336.387     0.200
    10.984   339.287     0.200
     2.609    83.301     0.200
     2.609    82.602     0.200
     2.655    83.902     0.200
     2.655    83.199     0.200
     2.899    90.102     0.200
     2.899    89.902     0.200
     3.636   114.000     0.200
     3.636   116.301     0.200
     3.720   116.602     0.200
     3.787   118.801     0.200
     3.804   119.102     0.200
     3.945   123.602     0.200
     4.187   131.199     0.200
     4.187   130.699     0.200
     4.543   142.801     0.200
     4.895   154.402     0.200
     4.888   151.699     0.200
     5.323   166.699     0.200
     6.170   193.902     0.200
     6.594   206.500     0.200
     6.778   211.801     0.200
     6.874   213.801     0.200
     7.283   227.402     0.200
     7.306   227.602     0.200
     7.364   231.602     0.200
     7.509   233.801     0.200
     7.673   239.602     0.200
     7.900   247.801     0.200
     7.979   248.801     0.200
     8.003   250.500     0.200
     8.540   267.602     0.200
     8.935   280.301     0.200
     9.030   283.000     0.200
     9.189   286.801     0.200
     9.656   298.520     0.200
     9.656   300.402     0.200
    10.992   345.199     0.200
    10.992   345.195     0.200
    19.737   625.328     0.200
    19.737   625.332     0.200
     2.615    82.375     0.200
     2.615    81.172     0.200
     2.739    86.375     0.200
     2.739    85.875     0.200
     2.704    83.672     0.200
     2.704    83.375     0.200
     3.632   115.172     0.200
     3.632   115.273     0.200
     3.703   114.375     0.200
     3.715   113.977     0.200
     3.881   121.375     0.200
     3.959   123.375     0.200
     3.959   121.977     0.200
     4.280   135.172     0.200
     4.900   153.375     0.200
     4.900   152.172     0.200
     5.170   162.273     0.200
     5.467   171.773     0.200
     6.310   196.977     0.200
     6.703   209.477     0.200
     6.928   217.477     0.200
     7.508   234.875     0.200
     7.571   237.875     0.200
     7.681   241.477     0.200
     7.799   242.875     0.200
     8.053   252.273     0.200
     8.124   253.773     0.200
     8.172   255.672     0.200
     9.070   281.375     0.200
     9.321   288.773     0.200
     9.783   302.875     0.200
    10.285   319.477     0.200
    10.753   336.672     0.200
    10.946   340.273     0.200
    11.173   348.578     0.200
    11.379   355.672     0.200
     2.541    78.895     0.200
     3.666   114.594     0.200
     4.129   129.594     0.200
     2.507    79.383     0.200
     3.708   115.383     0.200
     4.049   126.484     0.200
     4.648   145.883     0.200
     2.592    82.018     0.200
     2.592    81.518     0.200
     3.002    94.619     0.200
     3.217   100.518     0.200
     3.780   117.219     0.200
     3.986   124.518     0.200
     4.752   148.818     0.200
     5.265   162.318     0.200
     5.987   186.818     0.200
     8.181   255.918     0.200
     8.712   271.719     0.200
    11.798   364.018     0.200
     2.567    80.494     0.200
     3.501   107.695     0.200
     3.541   110.195     0.200
     4.673   144.594     0.200
     5.079   158.494     0.200
     5.603   174.494     0.200
     8.393   263.195     0.200
     8.618   268.295     0.200
     9.019   280.695     0.200
    11.084   342.695     0.200
     2.841    87.953     0.200
     3.393   106.254     0.200
     3.688   114.953     0.200
     3.886   122.354     0.200
     4.094   127.453     0.200
     4.543   141.953     0.200
     4.629   145.053     0.200
     5.002   157.152     0.200
     5.481   172.453     0.200
     6.285   196.652     0.200
     6.454   201.953     0.200
     6.975   217.152     0.200
     6.980   216.453     0.200
     7.180   224.053     0.200
     7.357   229.152     0.200
     7.675   239.854     0.200
     2.540    80.680     0.200
     3.059    97.078     0.200
     3.390   106.680     0.200
     3.745   118.484     0.200
     3.916   121.984     0.200
     4.279   133.883     0.200
     4.276   132.281     0.200
     4.330   135.180     0.200
     4.888   154.484     0.200
     4.970   156.484     0.200
     5.808   182.383     0.200
     6.173   193.578     0.200
     6.433   201.883     0.200
     7.210   223.781     0.200
     7.282   226.680     0.200
     7.315   230.484     0.200
     7.322   228.883     0.200
     7.509   234.484     0.200
     7.560   236.883     0.200
     7.623   235.281     0.200
     7.696   238.281     0.200
     8.168   255.078     0.200
     8.559   266.484     0.200
     8.807   272.984     0.200
     9.264   287.984     0.200
     9.751   301.984     0.200
    10.257   318.383     0.200
    10.573   330.984     0.200
    10.634   330.781     0.200
    10.823   335.281     0.200
    12.907   399.578     0.200
     2.570    81.344     0.200
     2.570    80.547     0.200
     2.622    82.344     0.200
     2.830    88.648     0.200
     2.830    88.344     0.200
     3.719   115.945     0.200
     3.769   116.547     0.200
     3.613   114.250     0.200
     3.978   125.250     0.200
     3.959   124.344     0.200
     3.959   122.648     0.200
     4.365   137.148     0.200
     4.365   136.750     0.200
     4.891   152.547     0.200
     6.795   212.547     0.200
     7.067   221.250     0.200
     7.901   240.305     0.200
     7.874   248.250     0.200
     7.909   248.047     0.200
     8.143   254.344     0.200
     8.193   255.750     0.200
     8.331   261.547     0.200
     8.798   275.250     0.200
     9.188   286.344     0.200
     9.435   293.445     0.200
     9.890   307.164     0.200
    10.369   322.445     0.200
    10.890   340.250     0.200
    11.248   350.844     0.200
    11.416   354.648     0.200
    11.460   359.430     0.200
    14.856   460.844     0.200
     2.576    81.281     0.200
     2.610    81.883     0.200
     2.610    83.281     0.200
     3.600   113.383     0.200
     3.732   116.383     0.200
     3.782   115.883     0.200
     3.981   124.781     0.200
     3.946   124.281     0.200
     4.354   136.680     0.200
     4.878   152.883     0.200
     5.593   174.477     0.200
     6.430   200.883     0.200
     6.783   211.680     0.200
     7.056   221.281     0.200
     7.835   245.281     0.200
     7.868   247.680     0.200
     7.898   248.078     0.200
     8.182   255.180     0.200
     8.245   256.477     0.200
     8.320   260.977     0.200
     8.787   274.781     0.200
     9.177   284.781     0.200
    10.357   321.281     0.200
    11.236   349.383     0.200
    11.404   354.977     0.200
    13.645   423.781     0.200
    14.843   460.383     0.200
     2.738    86.031     0.200
     2.805    87.633     0.200
     2.940    90.332     0.200
     3.580   111.230     0.200
     3.633   111.934     0.200
     3.763   118.031     0.200
     4.078   127.434     0.200
     4.341   135.633     0.200
     4.489   137.934     0.200
     4.549   140.934     0.200
     5.021   156.934     0.200
     5.486   171.031     0.200
     6.333   197.531     0.200
     6.752   209.434     0.200
     7.442   231.434     0.200
     7.528   234.832     0.200
     7.834   243.934     0.200
     8.169   254.730     0.200
     2.614    82.492     0.200
     2.955    91.492     0.200
     3.060    94.593     0.200
     3.416   106.692     0.200
     3.624   112.793     0.200
     4.407   135.393     0.200
     4.399   136.492     0.200
     4.749   147.793     0.200
     5.162   161.293     0.200
     5.678   175.793     0.200
     6.387   199.192     0.200
     7.591   236.793     0.200
     8.476   264.692     0.200
     8.702   270.093     0.200
     9.105   282.692     0.200
     3.414   107.930     0.200
     3.732   116.930     0.200
     3.924   122.031     0.200
     4.021   126.930     0.200
     4.282   133.828     0.200
     4.675   146.125     0.200
     4.907   154.125     0.200
     5.195   162.430     0.200
     5.520   172.625     0.200
     6.040   188.625     0.200
     6.440   201.125     0.200
     6.655   208.531     0.200
     7.068   221.031     0.200
     7.237   226.430     0.200
     7.313   229.227     0.200
     7.406   231.531     0.200
     7.532   234.125     0.200
     7.728   240.125     0.200
     7.780   242.828     0.200
     7.853   245.328     0.200
     7.897   246.328     0.200
     8.408   261.727     0.200
     8.801   274.930     0.200
     9.053   281.828     0.200
     9.516   296.227     0.200
    10.951   342.445     0.200
     2.616    82.717     0.200
     2.728    84.017     0.200
     2.731    86.116     0.200
     3.634   113.717     0.200
     3.699   114.816     0.200
     3.960   123.616     0.200
     4.272   134.316     0.200
     4.323   135.116     0.200
     4.901   152.116     0.200
     5.141   161.217     0.200
     5.453   170.616     0.200
     6.297   196.717     0.200
     7.540   235.616     0.200
     7.664   238.816     0.200
     2.788    85.992     0.200
     2.920    91.391     0.200
     3.095    96.289     0.200
     3.920   123.289     0.200
     4.266   131.195     0.200
     4.635   144.789     0.200
     5.197   161.992     0.200
     5.214   161.289     0.200
     5.847   182.695     0.200
     6.689   208.594     0.200
     7.063   221.289     0.200
     8.073   251.492     0.200
     8.562   267.992     0.200
     2.920    92.078     0.200
     3.091    96.777     0.200
     3.922   121.582     0.200
     4.284   132.777     0.200
     4.262   133.582     0.200
     4.631   144.980     0.200
     5.198   162.582     0.200
     5.560   174.777     0.200
     5.840   183.082     0.200
     6.682   209.777     0.200
     7.059   220.277     0.200
     7.303   227.777     0.200
     8.064   253.379     0.200
     8.163   255.480     0.200
     8.554   267.379     0.200
     2.726    83.652     0.200
     2.787    88.254     0.200
     2.949    91.953     0.200
     3.536   110.754     0.200
     3.558   109.453     0.200
     3.793   119.055     0.200
     4.131   129.555     0.200
     4.248   131.555     0.200
     4.490   139.754     0.200
     5.068   158.953     0.200
     5.427   170.453     0.200
     5.696   178.453     0.200
     6.538   204.453     0.200
     6.917   215.453     0.200
     7.827   244.953     0.200
     7.920   247.852     0.200
     8.020   250.152     0.200
     8.233   256.254     0.200
     8.409   262.152     0.200
     9.544   297.852     0.200
    10.003   310.352     0.200
    10.497   325.453     0.200
    10.984   342.453     0.200
    11.571   360.055     0.200
     3.149    98.459     0.200
     3.473   108.658     0.200
     3.796   119.459     0.200
     4.052   125.658     0.200
     4.185   130.459     0.200
     4.204   130.959     0.200
     4.415   138.359     0.200
     4.843   151.758     0.200
     5.000   156.258     0.200
     5.841   182.758     0.200
     6.222   194.258     0.200
     7.229   225.859     0.200
     7.265   227.158     0.200
     7.323   227.959     0.200
     7.538   235.459     0.200
     7.717   240.559     0.200
     8.847   275.359     0.200
     9.307   290.359     0.200
    10.288   320.758     0.200
    10.828   341.404     0.200
     3.619   113.014     0.200
     3.964   123.514     0.200
     4.047   125.014     0.200
     4.050   125.014     0.200
     4.047   125.615     0.200
     4.559   142.514     0.200
     2.712    83.735     0.200
     2.937    92.435     0.200
     3.550   110.036     0.200
     3.572   109.536     0.200
     4.117   128.235     0.200
     4.478   139.335     0.200
     2.739    84.375     0.200
     2.955    93.074     0.200
     3.527   108.277     0.200
     3.547   108.574     0.200
     4.139   130.477     0.200
     4.496   141.074     0.200
     2.534    79.094     0.200
     2.669    83.074     0.200
     2.767    86.891     0.200
     3.192   101.512     0.200
     4.679   144.480     0.200
     3.464   109.008     0.200
     4.050   126.305     0.200
     4.194   130.805     0.200
     2.598    82.297     0.200
     2.701    85.098     0.200
     2.749    84.797     0.200
     3.715   115.598     0.200
     3.742   117.699     0.200
     3.942   123.199     0.200
     4.357   136.199     0.200
     4.884   151.797     0.200
     2.599    81.758     0.200
     2.739    84.859     0.200
     2.705    85.059     0.200
     3.714   115.461     0.200
     3.739   116.258     0.200
     3.943   123.160     0.200
     4.246   133.758     0.200
     4.344   134.258     0.200
     4.885   152.359     0.200
     5.099   161.160     0.200
     5.422   169.359     0.200
     6.266   195.559     0.200
     6.666   208.559     0.200
     6.882   214.059     0.200
     7.497   234.758     0.200
     7.631   238.758     0.200
     7.759   242.359     0.200
     8.634   269.758     0.200
     2.566    81.383     0.200
     3.584   112.281     0.200
     3.899   120.781     0.200
     3.968   125.180     0.200
     4.083   126.180     0.200
     4.103   127.281     0.200
     4.520   141.477     0.200
     5.203   163.180     0.200
     3.135    98.414     0.200
     3.461   108.312     0.200
     3.796   118.414     0.200
     4.011   124.414     0.200
     4.199   129.113     0.200
     4.211   129.312     0.200
     4.403   136.016     0.200
     4.872   152.414     0.200
     5.007   155.016     0.200
     5.847   181.914     0.200
     6.470   201.414     0.200
     7.239   226.016     0.200
     7.295   228.215     0.200
    10.688   332.812     0.200
     2.674    84.541     0.200
     2.674    84.643     0.200
     2.733    83.643     0.200
     3.055    96.242     0.200
     3.284   101.842     0.200
     3.284   102.541     0.200
     3.326   102.242     0.200
     4.031   126.143     0.200
     4.115   127.242     0.200
     4.384   136.041     0.200
     4.816   151.143     0.200
     5.310   165.041     0.200
     5.874   183.842     0.200
     6.060   190.541     0.200
     6.060   188.742     0.200
     6.897   214.842     0.200
     7.246   226.643     0.200
     7.523   233.941     0.200
     7.784   243.842     0.200
     8.277   257.541     0.200
     8.302   258.643     0.200
     8.362   259.541     0.200
     8.600   267.242     0.200
     8.650   268.941     0.200
     8.712   271.342     0.200
     8.788   273.643     0.200
     9.253   288.742     0.200
     9.643   300.041     0.200
     9.889   306.342     0.200
    10.343   320.643     0.200
    10.818   335.242     0.200
    11.347   353.143     0.200
    11.630   361.941     0.200
    11.905   375.803     0.200
    17.645   547.916     0.200
     2.667    85.230     0.200
     2.908    91.930     0.200
     2.974    93.031     0.200
     3.296   104.131     0.200
     3.869   120.830     0.200
     3.917   123.031     0.200
     4.518   141.631     0.200
     4.524   141.631     0.200
     4.708   147.131     0.200
     5.356   167.531     0.200
     5.723   178.930     0.200
     5.982   186.531     0.200
     6.958   217.531     0.200
     7.058   220.730     0.200
     7.246   226.531     0.200
     7.716   241.031     0.200
     8.107   252.531     0.200
     8.355   259.230     0.200
     9.302   289.430     0.200
     2.705    84.766     0.200
     2.705    83.866     0.200
     2.785    86.566     0.200
     2.785    85.966     0.200
     2.959    92.666     0.200
     2.959    92.466     0.200
     3.673   115.466     0.200
     3.673   115.766     0.200
     3.690   112.366     0.200
     4.028   125.966     0.200
     4.484   140.066     0.200
     4.484   139.366     0.200
     4.952   153.266     0.200
     5.679   178.266     0.200
     5.747   179.466     0.200
     6.580   205.266     0.200
     6.912   215.866     0.200
     7.210   225.766     0.200
     7.777   242.166     0.200
     8.035   250.166     0.200
     8.098   252.866     0.200
     8.287   258.666     0.200
     8.336   260.066     0.200
     8.484   264.566     0.200
     9.318   290.566     0.200
     9.562   297.066     0.200
    10.013   311.366     0.200
    10.479   324.366     0.200
    11.031   343.566     0.200
    11.269   351.491     0.200
    11.352   352.966     0.200
    11.651   367.186     0.200
    17.950   559.016     0.200
    18.248   570.266     0.200
     3.544   111.391     0.200
     3.726   115.891     0.200
     4.536   141.789     0.200
     4.882   151.492     0.200
     5.267   164.195     0.200
     2.515    79.289     0.200
     2.623    82.789     0.200
     2.677    82.789     0.200
     3.798   119.289     0.200
     3.823   119.889     0.200
     3.859   120.389     0.200
     4.163   131.588     0.200
     4.296   134.689     0.200
     5.044   158.389     0.200
     5.343   167.088     0.200
     6.187   192.789     0.200
     7.384   230.189     0.200
     7.447   232.588     0.200
     7.678   239.389     0.200
     8.555   266.088     0.200
    10.167   315.789     0.200
    11.056   343.189     0.200
    11.268   350.588     0.200
     2.509    78.574     0.200
     2.612    82.473     0.200
     3.530   110.574     0.200
     3.832   120.875     0.200
     3.852   119.773     0.200
     4.152   130.074     0.200
     4.305   133.172     0.200
     5.027   159.375     0.200
     5.330   167.375     0.200
     6.174   193.773     0.200
     6.573   205.375     0.200
     6.790   212.473     0.200
     7.429   231.973     0.200
     7.666   239.574     0.200
     8.935   279.375     0.200
     2.880    88.887     0.200
     3.510   109.984     0.200
     3.674   115.684     0.200
     4.509   140.586     0.200
     4.851   150.785     0.200
     5.215   163.785     0.200
     2.547    79.430     0.200
     2.770    86.129     0.200
     3.823   119.727     0.200
     3.837   120.227     0.200
     3.891   121.930     0.200
     4.083   127.727     0.200
     4.423   137.727     0.200
     4.871   153.430     0.200
     5.235   164.227     0.200
     2.546    80.176     0.200
     2.783    86.477     0.200
     2.783    86.977     0.200
     3.515   111.574     0.200
     3.515   110.977     0.200
     3.836   119.273     0.200
     3.893   120.676     0.200
     3.893   120.375     0.200
     3.826   119.977     0.200
     3.826   118.875     0.200
     4.081   129.074     0.200
     4.081   126.773     0.200
     4.438   138.574     0.200
     4.858   153.176     0.200
     8.447   257.242     0.200
     8.446   264.875     0.200
     8.840   274.875     0.200
     8.931   278.676     0.200
     9.093   284.375     0.200
     9.559   298.273     0.200
    10.076   312.977     0.200
    10.510   327.875     0.200
    10.808   338.699     0.200
    10.933   344.996     0.200
    10.970   341.074     0.200
    11.201   346.773     0.200
    14.874   468.926     0.200
    17.677   551.742     0.200
    18.543   579.000     0.200
    19.041   600.422     0.200
    19.820   626.293     0.200
     2.545    79.746     0.200
     2.545    80.047     0.200
     2.788    86.645     0.200
     3.516   110.344     0.200
     3.516   111.445     0.200
     3.836   119.145     0.200
     3.826   120.145     0.200
     3.826   118.945     0.200
     3.894   120.547     0.200
     3.894   120.445     0.200
     4.080   127.746     0.200
     4.080   127.445     0.200
     4.444   139.246     0.200
     4.853   152.645     0.200
     4.853   152.445     0.200
     5.227   163.047     0.200
     6.491   202.445     0.200
     6.684   209.145     0.200
     7.249   226.047     0.200
     7.269   227.047     0.200
     7.422   231.145     0.200
     7.574   235.047     0.200
     7.754   241.746     0.200
     7.808   243.746     0.200
     8.133   254.145     0.200
     8.444   263.145     0.200
     8.452   256.766     0.200
     8.838   275.645     0.200
     9.091   284.344     0.200
     9.557   297.445     0.200
    10.074   312.844     0.200
    10.507   326.945     0.200
    10.968   340.246     0.200
    11.200   348.645     0.200
     2.544    79.477     0.200
     2.769    85.977     0.200
     3.821   119.477     0.200
     3.839   120.176     0.200
     4.080   127.875     0.200
     4.423   137.676     0.200
     5.232   163.574     0.200
     2.541    79.953     0.200
     2.772    86.254     0.200
     3.507   109.555     0.200
     3.819   119.254     0.200
     3.842   120.152     0.200
     4.076   127.355     0.200
     5.227   163.254     0.200
     2.500    79.582     0.200
     2.563    80.383     0.200
     2.779    86.383     0.200
     3.526   110.984     0.200
     3.821   119.582     0.200
     3.838   119.781     0.200
     4.099   127.781     0.200
     4.429   137.984     0.200
     4.883   152.684     0.200
     5.250   164.184     0.200
     2.552    80.523     0.200
     2.779    86.523     0.200
     3.830   119.523     0.200
     3.831   119.824     0.200
     3.886   121.523     0.200
     4.087   127.625     0.200
     4.432   137.824     0.200
     4.870   152.523     0.200
     5.238   163.625     0.200
     6.695   208.324     0.200
     2.503    78.930     0.200
     2.564    80.328     0.200
     2.784    86.531     0.200
     3.819   119.531     0.200
     3.841   119.633     0.200
     3.874   121.328     0.200
     4.099   128.031     0.200
     4.435   137.828     0.200
     4.880   153.328     0.200
     5.250   163.531     0.200
     6.707   209.234     0.200
     2.560    80.682     0.200
     2.785    86.781     0.200
     3.823   119.682     0.200
     3.838   120.182     0.200
     4.095   128.182     0.200
     4.437   138.081     0.200
     5.246   163.881     0.200
     6.508   202.881     0.200
     6.703   208.682     0.200
     7.271   227.381     0.200
     2.553    80.625     0.200
     2.786    87.023     0.200
     3.521   110.523     0.200
     3.833   119.023     0.200
     3.885   120.223     0.200
     4.089   128.023     0.200
     4.439   138.625     0.200
     4.866   152.023     0.200
     5.238   164.125     0.200
     6.501   202.523     0.200
     6.695   209.023     0.200
     7.262   226.223     0.200
     7.280   226.922     0.200
     7.584   236.125     0.200
     8.454   263.824     0.200
     8.849   275.922     0.200
     9.102   282.723     0.200
    10.084   313.324     0.200
    10.518   326.324     0.200
     2.542    79.461     0.200
     2.772    86.461     0.200
     3.508   109.562     0.200
     3.820   119.859     0.200
     3.841   120.562     0.200
     3.896   121.859     0.200
     4.078   128.164     0.200
     4.427   138.062     0.200
     4.863   152.664     0.200
     6.490   202.758     0.200
     6.686   209.359     0.200
     7.261   226.961     0.200
     7.425   231.664     0.200
     7.574   236.758     0.200
     8.839   275.664     0.200
    10.073   313.164     0.200
    10.509   328.062     0.200
    10.967   340.562     0.200
    11.197   348.359     0.200
     2.546    79.829     0.200
     2.546    80.629     0.200
     2.781    85.930     0.200
     2.781    86.430     0.200
     3.514   111.129     0.200
     3.835   119.029     0.200
     3.892   122.129     0.200
     3.892   120.329     0.200
     3.825   119.430     0.200
     4.082   128.129     0.200
     4.082   128.529     0.200
     4.435   138.329     0.200
     4.861   151.829     0.200
     5.231   163.529     0.200
     7.577   237.329     0.200
     8.445   257.048     0.200
     8.447   263.430     0.200
     9.095   283.729     0.200
     9.561   297.829     0.200
    10.077   314.529     0.200
    10.511   327.129     0.200
    10.971   340.729     0.200
    10.935   346.409     0.200
    14.877   469.204     0.200
     2.554    80.369     0.200
     2.785    86.469     0.200
     3.828   119.869     0.200
     3.884   121.568     0.200
     4.089   128.068     0.200
     2.552    80.552     0.200
     2.788    86.751     0.200
     3.521   111.251     0.200
     3.829   119.352     0.200
     3.832   119.751     0.200
     3.886   120.951     0.200
     4.087   128.352     0.200
     4.442   138.052     0.200
     4.862   152.751     0.200
     5.236   163.451     0.200
     6.693   208.552     0.200
     7.431   231.751     0.200
     7.582   236.552     0.200
     8.452   263.352     0.200
     9.099   283.352     0.200
     2.550    80.041     0.200
     2.794    87.242     0.200
     3.521   110.742     0.200
     3.521   111.541     0.200
     3.830   118.941     0.200
     3.889   120.441     0.200
     3.832   120.141     0.200
     4.084   128.141     0.200
     4.084   127.541     0.200
     4.449   139.141     0.200
     4.854   152.842     0.200
     5.231   162.742     0.200
     5.231   162.641     0.200
     7.425   231.041     0.200
     8.451   257.361     0.200
     8.448   264.441     0.200
     8.842   275.141     0.200
     9.095   282.842     0.200
     9.561   296.141     0.200
    10.079   313.242     0.200
    10.973   339.441     0.200
    11.205   349.141     0.200
     2.558    79.691     0.200
     2.781    86.591     0.200
     3.523   110.291     0.200
     3.825   118.791     0.200
     3.835   119.791     0.200
     3.880   120.691     0.200
     4.094   127.991     0.200
     4.433   138.191     0.200
     4.876   153.591     0.200
     5.245   163.891     0.200
     6.506   202.891     0.200
     6.702   209.391     0.200
     7.273   226.391     0.200
     7.441   231.491     0.200
     7.590   236.691     0.200
     8.461   263.591     0.200
     9.108   283.391     0.200
     2.540    79.945     0.200
     2.755    86.148     0.200
     3.813   119.047     0.200
     4.076   127.250     0.200
     4.408   137.047     0.200
     4.875   152.750     0.200
     5.230   163.250     0.200
     6.688   208.352     0.200
     7.274   226.352     0.200
     2.548    80.420     0.200
     2.786    86.420     0.200
     3.828   119.820     0.200
     4.083   128.420     0.200
     4.441   137.420     0.200
     2.551    80.773     0.200
     2.787    86.977     0.200
     3.520   109.672     0.200
     3.831   119.875     0.200
     3.887   121.773     0.200
     4.087   127.977     0.200
     4.441   138.172     0.200
     4.774   148.477     0.200
     4.862   153.578     0.200
     5.235   164.172     0.200
     6.498   202.875     0.200
     6.692   208.273     0.200
     7.258   226.875     0.200
     7.430   231.977     0.200
     7.581   235.273     0.200
     7.816   243.875     0.200
    10.515   326.773     0.200
    10.975   341.578     0.200
    11.207   348.875     0.200
     2.502    78.758     0.200
     2.638    81.859     0.200
     2.638    82.160     0.200
     3.432   107.961     0.200
     3.432   109.160     0.200
     3.751   117.359     0.200
     4.042   127.160     0.200
     4.042   126.059     0.200
     3.939   122.359     0.200
     4.285   132.559     0.200
     4.693   147.160     0.200
     4.926   155.758     0.200
     5.217   163.660     0.200
     6.062   189.758     0.200
     6.446   201.961     0.200
     6.462   200.961     0.200
     6.542   203.559     0.200
     6.677   209.059     0.200
     7.333   229.559     0.200
     7.428   230.961     0.200
     7.554   235.059     0.200
     7.750   241.359     0.200
     7.802   243.359     0.200
     7.919   247.160     0.200
     8.429   263.359     0.200
     8.397   257.652     0.200
     8.823   274.461     0.200
     9.074   281.758     0.200
     9.538   297.059     0.200
    10.045   311.258     0.200
    10.972   345.359     0.200
    18.947   597.148     0.200
     2.556    79.785     0.200
     2.556    78.922     0.200
     2.556    79.582     0.200
     2.537    80.082     0.200
     2.507    80.383     0.200
     3.080    97.562     0.200
     3.494   108.785     0.200
     3.961   123.785     0.200
     4.789   148.223     0.200
     4.780   149.684     0.200
     5.126   160.383     0.200
     5.503   172.484     0.200
     5.840   178.785     0.200
     6.058   189.582     0.200
     6.867   210.152     0.200
     6.699   208.883     0.200
     7.024   213.945     0.200
     7.542   236.383     0.200
     7.674   239.883     0.200
     7.929   247.582     0.200
     7.927   248.082     0.200
     8.017   250.184     0.200
     8.159   254.582     0.200
     8.620   268.484     0.200
     8.908   277.883     0.200
     9.030   281.984     0.200
     9.232   288.684     0.200
     9.356   291.285     0.200
     9.399   293.484     0.200
     9.909   309.184     0.200
    10.302   320.184     0.200
    10.552   328.383     0.200
    11.013   342.285     0.200
     2.500    79.555     0.200
     2.681    84.254     0.200
     3.494   109.455     0.200
     3.834   119.254     0.200
     3.835   120.154     0.200
     4.009   124.354     0.200
     4.219   132.654     0.200
     4.770   148.654     0.200
     5.294   166.854     0.200
     5.448   170.654     0.200
     6.648   206.354     0.200
     6.674   208.754     0.200
     6.746   210.654     0.200
     6.911   215.354     0.200
     7.686   239.555     0.200
     7.710   239.854     0.200
     7.987   249.154     0.200
     8.101   252.455     0.200
     8.172   254.354     0.200
     9.037   281.654     0.200
     9.284   288.555     0.200
    10.225   317.955     0.200
     3.095    97.639     0.200
     3.417   107.039     0.200
     3.732   117.039     0.200
     4.054   125.939     0.200
     4.263   132.139     0.200
     4.358   136.339     0.200
     4.782   150.539     0.200
     4.934   154.339     0.200
     5.775   179.739     0.200
     6.157   192.539     0.200
     6.162   193.139     0.200
     6.245   195.339     0.200
     6.396   199.939     0.200
     7.162   223.739     0.200
     7.205   224.439     0.200
     7.258   225.239     0.200
     7.471   233.339     0.200
     7.650   238.539     0.200
     8.781   273.839     0.200
     9.241   288.739     0.200
     2.528    77.566     0.200
     2.571    80.965     0.200
     2.705    85.164     0.200
     2.915    91.266     0.200
     3.639   112.066     0.200
     3.695   116.066     0.200
     4.022   125.766     0.200
     4.042   125.965     0.200
     4.451   139.766     0.200
     5.688   177.766     0.200
     6.525   203.965     0.200
     6.880   213.965     0.200
     6.914   215.566     0.200
     6.982   216.867     0.200
     7.152   222.965     0.200
     7.929   247.566     0.200
     7.942   248.066     0.200
     7.994   249.664     0.200
     8.415   262.566     0.200
    10.454   325.266     0.200
    11.333   351.066     0.200
    11.500   357.066     0.200
     2.953    91.227     0.200
     2.981    93.027     0.200
     3.474   108.426     0.200
     3.740   117.527     0.200
     4.165   127.926     0.200
     4.785   149.828     0.200
     5.264   165.027     0.200
     5.699   178.527     0.200
     6.527   203.727     0.200
     7.691   240.129     0.200
     7.750   242.129     0.200
     8.760   274.629     0.200
     8.777   274.027     0.200
     8.815   275.828     0.200
     2.604    79.660     0.200
     2.679    83.461     0.200
     3.057    96.359     0.200
     3.057    96.570     0.200
     3.380   105.160     0.200
     3.406   106.770     0.200
     3.925   122.461     0.200
     4.178   130.160     0.200
     4.505   139.961     0.200
     6.696   209.359     0.200
     6.957   216.859     0.200
     7.793   243.762     0.200
     8.135   253.059     0.200
     8.420   263.660     0.200
     9.075   284.461     0.200
     9.198   286.059     0.200
     9.685   302.359     0.200
     3.466   108.793     0.200
     3.788   119.192     0.200
     4.211   129.593     0.200
     4.407   137.692     0.200
     4.836   151.492     0.200
     4.992   156.093     0.200
     5.833   182.492     0.200
     6.214   194.692     0.200
     6.220   194.692     0.200
     6.455   201.992     0.200
     7.221   225.992     0.200
     7.257   227.692     0.200
     7.315   228.793     0.200
     7.709   240.293     0.200
     8.197   255.992     0.200
     9.795   304.992     0.200
    10.681   331.593     0.200
    10.883   338.692     0.200
     2.793    86.336     0.200
     2.846    90.039     0.200
     3.000    94.641     0.200
     3.000    93.641     0.200
     3.477   108.641     0.200
     3.477   106.938     0.200
     3.853   121.039     0.200
     4.190   130.742     0.200
     4.190   130.539     0.200
     4.310   134.141     0.200
     4.310   133.539     0.200
     4.541   141.336     0.200
     5.127   160.539     0.200
     5.442   170.742     0.200
     5.740   179.242     0.200
     6.583   204.539     0.200
     6.967   216.836     0.200
     7.838   245.836     0.200
     7.960   247.641     0.200
     8.450   263.742     0.200
     2.768    85.395     0.200
     4.382   135.273     0.200
     5.833   178.375     0.200
     6.113   187.113     0.200
     6.623   201.883     0.200
     6.770   206.715     0.200
     2.840    88.516     0.200
     2.840    88.414     0.200
     3.868   120.312     0.200
     3.868   120.414     0.200
     3.569   111.711     0.200
     3.661   113.211     0.200
     3.617   112.016     0.200
     3.617   112.914     0.200
     4.595   143.117     0.200
     4.908   152.211     0.200
     5.159   160.016     0.200
     5.270   165.812     0.200
     6.336   194.711     0.200
     7.753   234.633     0.200
     8.394   262.711     0.200
     8.606   268.516     0.200
     8.752   272.016     0.200
     8.808   275.211     0.200
     8.894   278.016     0.200
     8.891   277.016     0.200
     9.277   288.516     0.200
     9.463   293.617     0.200
     9.859   305.711     0.200
     9.968   308.312     0.200
    10.587   328.312     0.200
    11.121   345.914     0.200
    11.452   355.914     0.200
    11.503   355.617     0.200
    11.757   366.258     0.200
    12.021   373.414     0.200
    12.272   379.711     0.200
    16.683   516.086     0.200
    19.447   611.516     0.200
    20.110   634.047     0.200
     2.530    79.680     0.200
     2.714    85.383     0.200
     2.714    85.883     0.200
     3.531   110.680     0.200
     3.797   116.680     0.200
     3.797   118.781     0.200
     3.872   120.086     0.200
     3.872   121.180     0.200
     4.039   125.680     0.200
     4.253   132.984     0.200
     4.253   133.484     0.200
     5.310   166.680     0.200
     5.478   171.781     0.200
     6.317   197.281     0.200
     6.682   209.086     0.200
     6.705   208.383     0.200
     6.779   211.781     0.200
     6.942   216.984     0.200
     7.171   224.609     0.200
     7.458   233.086     0.200
     7.515   234.883     0.200
     7.715   240.180     0.200
     7.724   241.484     0.200
     7.791   242.586     0.200
     8.017   250.383     0.200
     8.068   251.984     0.200
     8.133   252.781     0.200
     8.534   265.883     0.200
     9.069   282.484     0.200
     9.132   284.883     0.200
     9.317   288.984     0.200
     9.774   303.383     0.200
    10.259   318.781     0.200
    10.766   334.680     0.200
    11.044   344.086     0.200
    11.140   345.180     0.200
    11.320   350.883     0.200
     2.585    82.262     0.200
     2.585    81.559     0.200
     3.273   100.762     0.200
     3.087    96.262     0.200
     3.087    96.961     0.200
     3.299   103.559     0.200
     4.421   137.160     0.200
     4.835   150.059     0.200
     6.906   215.859     0.200
     7.294   226.961     0.200
     7.412   230.934     0.200
     7.531   234.160     0.200
     7.701   240.359     0.200
     8.104   252.262     0.200
     8.236   256.859     0.200
     8.377   260.559     0.200
     8.607   268.262     0.200
     8.657   269.859     0.200
     9.265   288.262     0.200
     9.656   300.859     0.200
     9.715   301.859     0.200
     9.903   307.660     0.200
    10.359   322.160     0.200
    10.839   335.359     0.200
    11.609   360.762     0.200
    11.718   363.059     0.200
    11.883   367.961     0.200
    11.886   372.102     0.200
    15.346   476.277     0.200
    15.175   473.879     0.200
    16.871   520.180     0.200
    17.644   547.762     0.200
    18.552   578.559     0.200
     2.656    83.513     0.200
     2.667    85.212     0.200
     2.909    91.413     0.200
     2.973    93.612     0.200
     3.294   104.112     0.200
     3.914   123.013     0.200
     4.516   141.112     0.200
     4.521   142.013     0.200
     5.354   167.612     0.200
     5.721   178.312     0.200
     5.815   182.112     0.200
     3.087    96.309     0.200
     3.400   107.406     0.200
     3.683   116.605     0.200
     4.147   130.207     0.200
     4.299   135.309     0.200
     4.669   147.105     0.200
     4.866   153.105     0.200
     7.090   221.508     0.200
     2.607    80.273     0.200
     2.607    80.570     0.200
     2.698    85.477     0.200
     2.698    85.375     0.200
     2.878    90.477     0.200
     3.630   113.070     0.200
     3.697   116.773     0.200
     4.039   126.273     0.200
     4.131   128.570     0.200
     4.417   138.172     0.200
     4.974   155.273     0.200
     5.425   170.977     0.200
     5.637   176.477     0.200
     6.477   202.875     0.200
     6.846   213.570     0.200
     6.865   214.273     0.200
     6.941   217.070     0.200
     7.100   221.977     0.200
     7.180   225.992     0.200
     7.675   239.070     0.200
     7.831   244.977     0.200
     7.869   244.875     0.200
     7.954   247.570     0.200
     8.176   255.773     0.200
     8.227   256.477     0.200
     8.357   260.672     0.200
     8.839   274.875     0.200
     9.936   305.391     0.200
    11.454   357.703     0.200
    15.185   472.789     0.200
    15.681   486.891     0.200
    18.079   562.969     0.200
     2.603    80.250     0.200
     2.698    84.945     0.200
     2.880    90.344     0.200
     3.630   112.945     0.200
     3.697   116.148     0.200
     4.039   125.945     0.200
     4.126   129.148     0.200
     4.419   138.344     0.200
     4.974   155.547     0.200
     5.430   170.344     0.200
     5.640   175.945     0.200
     6.480   202.547     0.200
     6.848   213.750     0.200
     6.868   214.344     0.200
     6.944   216.945     0.200
     7.103   221.648     0.200
     2.606    80.344     0.200
     2.606    80.242     0.200
     2.700    84.844     0.200
     2.881    90.039     0.200
     2.881    90.844     0.200
     3.628   112.938     0.200
     3.699   116.242     0.200
     3.699   116.641     0.200
     4.041   126.438     0.200
     4.041   126.141     0.200
     4.129   128.344     0.200
     4.420   138.438     0.200
     4.975   155.539     0.200
     5.429   170.344     0.200
     5.641   176.539     0.200
     6.481   203.141     0.200
     6.849   212.844     0.200
     6.868   214.742     0.200
     6.944   216.742     0.200
     7.104   222.242     0.200
     7.472   234.344     0.200
     7.679   239.844     0.200
     7.836   245.641     0.200
     7.873   245.938     0.200
     7.957   247.742     0.200
     8.179   255.039     0.200
     8.230   257.141     0.200
     8.296   257.844     0.200
     8.361   260.641     0.200
     8.842   275.141     0.200
     9.299   289.141     0.200
     9.482   294.344     0.200
     9.940   310.906     0.200
    11.458   358.641     0.200
     2.601    80.297     0.200
     2.700    85.195     0.200
     2.883    89.398     0.200
     2.883    90.695     0.200
     3.629   112.602     0.200
     3.699   114.602     0.200
     3.699   116.398     0.200
     4.041   124.898     0.200
     4.041   126.297     0.200
     4.121   128.398     0.200
     4.422   138.297     0.200
     4.975   155.500     0.200
     5.436   171.398     0.200
     6.851   214.102     0.200
     6.871   214.695     0.200
     6.947   216.602     0.200
     7.107   222.102     0.200
     7.193   228.016     0.200
     7.481   234.695     0.200
     7.844   245.797     0.200
     7.877   245.195     0.200
     7.960   248.602     0.200
     8.183   255.102     0.200
     8.234   257.000     0.200
     8.364   261.000     0.200
     8.700   271.195     0.200
     8.845   276.102     0.200
    11.464   357.305     0.200
    17.285   537.742     0.200
    18.071   563.398     0.200
     2.595    79.703     0.200
     2.595    80.000     0.200
     2.692    84.898     0.200
     2.876    90.203     0.200
     2.876    90.500     0.200
     3.691   116.500     0.200
     3.636   111.305     0.200
     3.636   113.703     0.200
     4.033   125.102     0.200
     4.033   125.898     0.200
     4.117   127.805     0.200
     4.415   136.805     0.200
     4.415   138.102     0.200
     4.968   155.203     0.200
     5.431   170.500     0.200
     5.637   176.500     0.200
     6.476   202.703     0.200
     6.843   213.602     0.200
     6.864   214.203     0.200
     7.100   221.398     0.200
     7.193   226.102     0.200
     7.480   233.398     0.200
     7.674   240.500     0.200
     7.838   245.500     0.200
     7.869   245.102     0.200
     7.952   248.805     0.200
     7.906   239.844     0.200
     8.175   255.000     0.200
     8.291   257.898     0.200
     8.357   260.898     0.200
     8.837   275.703     0.200
     9.934   306.148     0.200
    11.011   341.844     0.200
    18.078   563.930     0.200
     2.604    80.119     0.200
     2.604    80.220     0.200
     2.708    84.520     0.200
     2.892    90.319     0.200
     3.621   111.520     0.200
     3.621   111.819     0.200
     3.707   114.819     0.200
     4.122   128.819     0.200
     4.122   128.520     0.200
     4.049   126.319     0.200
     4.431   137.920     0.200
     4.983   155.420     0.200
     7.199   225.737     0.200
     8.374   260.420     0.200
     8.854   274.819     0.200
     9.245   285.720     0.200
    17.276   535.589     0.200
    18.062   560.994     0.200
     2.606    80.588     0.200
     2.702    85.688     0.200
     2.884    90.688     0.200
     3.626   113.387     0.200
     4.043   126.387     0.200
     4.127   128.387     0.200
     4.424   138.986     0.200
     4.978   155.588     0.200
     5.644   176.387     0.200
     6.852   213.486     0.200
     6.872   215.287     0.200
     6.948   217.387     0.200
     7.475   233.188     0.200
     7.841   244.387     0.200
     2.576    79.836     0.200
     2.691    84.738     0.200
     2.881    90.238     0.200
     3.640   112.637     0.200
     3.688   115.938     0.200
     4.031   125.535     0.200
     4.093   127.836     0.200
     4.419   138.035     0.200
     4.965   155.035     0.200
     5.645   176.336     0.200
     6.848   213.137     0.200
     6.945   217.035     0.200
     7.860   245.137     0.200
     2.605    80.641     0.200
     2.711    85.543     0.200
     2.896    90.641     0.200
     3.618   112.840     0.200
     3.710   116.043     0.200
     4.052   126.242     0.200
     4.122   128.441     0.200
     4.435   138.141     0.200
     4.986   155.742     0.200
     5.449   171.043     0.200
     5.657   176.742     0.200
     6.864   214.441     0.200
     6.884   214.340     0.200
     6.960   217.641     0.200
     7.489   234.141     0.200
     7.856   245.543     0.200
     2.611    80.742     0.200
     2.701    85.438     0.200
     2.881    90.844     0.200
     3.627   113.844     0.200
     3.702   116.844     0.200
     4.042   127.242     0.200
     4.135   127.641     0.200
     4.420   138.539     0.200
     5.425   170.344     0.200
     5.640   176.242     0.200
     6.480   201.539     0.200
     6.849   213.539     0.200
     6.867   213.938     0.200
     6.944   216.438     0.200
     7.465   232.844     0.200
     2.594    80.250     0.200
     2.696    85.453     0.200
     2.881    90.953     0.200
     3.633   112.352     0.200
     3.695   115.648     0.200
     4.037   126.852     0.200
     4.114   127.852     0.200
     4.420   138.750     0.200
     4.971   155.555     0.200
     5.643   176.555     0.200
     6.482   202.953     0.200
     6.849   213.453     0.200
     6.870   214.352     0.200
     6.945   216.250     0.200
     7.487   233.555     0.200
     2.613    81.066     0.200
     2.716    85.668     0.200
     2.716    85.867     0.200
     2.899    90.867     0.200
     3.613   112.168     0.200
     3.613   113.066     0.200
     3.715   116.168     0.200
     4.130   128.969     0.200
     4.057   128.367     0.200
     4.057   126.867     0.200
     4.438   139.867     0.200
     4.438   138.867     0.200
     4.991   156.566     0.200
     6.499   203.270     0.200
     6.887   215.066     0.200
     6.962   217.668     0.200
     7.195   225.941     0.200
     7.697   240.770     0.200
     7.854   246.367     0.200
     7.891   245.770     0.200
     8.249   256.668     0.200
     8.314   259.367     0.200
     8.379   260.867     0.200
     8.860   275.066     0.200
    15.189   477.117     0.200
     2.609    80.367     0.200
     2.711    85.367     0.200
     2.894    90.766     0.200
     3.618   113.266     0.200
     3.710   116.066     0.200
     4.052   126.066     0.200
     4.127   128.766     0.200
     4.433   138.566     0.200
     4.986   156.367     0.200
     5.444   171.867     0.200
     5.655   177.668     0.200
     6.494   202.168     0.200
     6.862   213.766     0.200
     6.882   215.367     0.200
     6.958   215.965     0.200
     7.118   222.566     0.200
     7.851   245.766     0.200
     2.604    80.492     0.200
     2.702    85.297     0.200
     2.885    90.297     0.200
     3.626   112.594     0.200
     3.626   112.695     0.200
     3.701   116.094     0.200
     3.702   116.094     0.200
     4.043   125.297     0.200
     4.043   126.094     0.200
     4.124   128.797     0.200
     4.424   138.398     0.200
     4.978   155.398     0.200
     7.192   225.547     0.200
     7.479   232.898     0.200
     7.844   244.398     0.200
     7.962   248.297     0.200
     8.184   255.195     0.200
     8.847   274.797     0.200
     9.303   289.398     0.200
     9.487   294.398     0.200
     9.944   308.594     0.200
    10.431   323.492     0.200
    10.934   340.195     0.200
    11.190   349.094     0.200
    11.313   351.492     0.200
    11.492   357.492     0.200
    17.283   535.914     0.200
    18.069   562.094     0.200
    19.146   603.148     0.200
     2.602    80.469     0.200
     2.696    85.766     0.200
     2.878    90.664     0.200
     3.632   112.664     0.200
     3.696   116.367     0.200
     4.037   125.766     0.200
     4.125   128.367     0.200
     4.417   138.062     0.200
     4.972   154.766     0.200
     5.428   170.164     0.200
     5.638   176.266     0.200
     6.846   213.969     0.200
     6.865   214.164     0.200
     6.941   216.562     0.200
     7.101   222.062     0.200
     2.586    80.598     0.200
     2.693    84.297     0.200
     2.879    90.697     0.200
     3.637   112.197     0.200
     3.691   116.098     0.200
     4.033   126.896     0.200
     4.105   127.598     0.200
     4.418   138.598     0.200
     4.967   155.496     0.200
     5.442   169.996     0.200
     5.642   177.098     0.200
     6.481   202.598     0.200
     6.847   214.098     0.200
     6.944   217.098     0.200
     7.105   221.797     0.200
     2.603    80.621     0.200
     2.603    80.223     0.200
     2.696    85.121     0.200
     2.696    84.521     0.200
     2.878    90.521     0.200
     3.632   113.422     0.200
     3.696   115.021     0.200
     4.126   128.723     0.200
     4.126   128.621     0.200
     4.038   125.322     0.200
     4.038   126.521     0.200
     4.417   137.223     0.200
     4.417   137.422     0.200
     4.972   154.621     0.200
     6.865   214.322     0.200
     6.941   216.621     0.200
    11.002   342.865     0.200
    11.456   359.629     0.200
     2.599    79.779     0.200
     2.599    80.279     0.200
     2.696    85.080     0.200
     2.880    89.479     0.200
     2.880    90.680     0.200
     3.632   113.180     0.200
     3.695   116.580     0.200
     4.037   126.279     0.200
     4.120   128.379     0.200
     4.419   136.779     0.200
     4.419   138.279     0.200
     4.972   155.879     0.200
     5.433   171.379     0.200
     5.640   177.379     0.200
     6.480   202.979     0.200
     6.847   213.680     0.200
     6.868   214.680     0.200
     6.943   217.080     0.200
     7.103   221.379     0.200
     7.479   234.779     0.200
     7.678   240.580     0.200
     7.840   245.180     0.200
     7.873   245.779     0.200
     7.903   240.574     0.200
     7.956   247.479     0.200
     8.179   255.680     0.200
     8.230   257.680     0.200
     8.361   261.479     0.200
     8.841   275.479     0.200
     9.232   286.680     0.200
     9.297   289.879     0.200
     9.481   294.279     0.200
     9.938   310.973     0.200
     9.938   309.580     0.200
    10.425   324.080     0.200
    10.928   340.879     0.200
    11.007   344.598     0.200
    11.460   362.859     0.200
    15.197   477.162     0.200
    17.289   536.799     0.200
    18.075   562.729     0.200
    19.140   602.184     0.200
     2.665    83.523     0.200
     3.496   109.123     0.200
     3.833   119.523     0.200
     3.834   119.924     0.200
     4.057   125.924     0.200
     4.205   131.725     0.200
     4.770   149.225     0.200
     5.248   164.523     0.200
     5.425   169.424     0.200
     6.652   207.924     0.200
     2.659    82.922     0.200
     2.659    83.422     0.200
     3.492   110.021     0.200
     3.837   119.922     0.200
     3.837   119.123     0.200
     3.830   119.723     0.200
     4.061   126.822     0.200
     4.199   131.723     0.200
     4.199   131.223     0.200
     4.766   149.021     0.200
     6.042   190.322     0.200
     7.402   231.521     0.200
     7.653   239.223     0.200
     7.652   239.021     0.200
     8.113   246.467     0.200
     8.008   250.723     0.200
     8.140   253.422     0.200
     9.011   280.223     0.200
    11.101   345.090     0.200
    11.249   354.262     0.200
     2.602    80.461     0.200
     2.710    84.863     0.200
     2.895    91.062     0.200
     3.620   112.461     0.200
     3.708   116.461     0.200
     4.050   126.664     0.200
     4.119   127.664     0.200
     4.434   138.562     0.200
     5.450   170.766     0.200
     5.657   176.461     0.200
     2.614    80.676     0.200
     2.702    85.876     0.200
     2.881    90.776     0.200
     3.625   112.476     0.200
     3.702   115.976     0.200
     4.044   126.076     0.200
     4.138   128.976     0.200
     4.421   138.476     0.200
     4.979   155.876     0.200
     5.424   170.976     0.200
     5.640   176.876     0.200
     6.480   202.676     0.200
     6.849   213.276     0.200
     6.867   214.276     0.200
     6.944   216.976     0.200
     2.657    82.875     0.200
     2.657    83.375     0.200
     3.490   109.176     0.200
     3.828   119.875     0.200
     3.839   118.578     0.200
     4.061   126.277     0.200
     4.196   131.676     0.200
     4.196   130.777     0.200
     4.764   148.676     0.200
     5.237   164.578     0.200
     5.416   169.375     0.200
     6.256   195.477     0.200
     6.625   206.477     0.200
     6.644   207.777     0.200
     6.720   210.176     0.200
     6.879   214.277     0.200
     7.115   224.578     0.200
     7.401   230.578     0.200
     7.454   232.977     0.200
     7.651   238.578     0.200
     7.650   238.676     0.200
     7.732   240.375     0.200
     7.955   247.578     0.200
     8.006   249.578     0.200
     8.071   251.578     0.200
     8.137   253.078     0.200
     8.115   245.770     0.200
     8.617   268.477     0.200
     9.009   280.777     0.200
     9.074   281.676     0.200
     9.257   287.578     0.200
     9.715   299.320     0.200
     9.715   301.977     0.200
    10.203   316.078     0.200
    10.704   333.277     0.200
    10.973   340.875     0.200
    11.102   347.094     0.200
    11.246   350.535     0.200
    11.270   350.375     0.200
    15.245   473.246     0.200
    17.512   542.469     0.200
    18.540   580.852     0.200
    18.955   596.691     0.200
    20.265   641.152     0.200
     2.611    80.566     0.200
     2.707    85.469     0.200
     2.889    91.066     0.200
     3.621   113.266     0.200
     3.707   116.766     0.200
     4.048   126.766     0.200
     4.132   128.367     0.200
     4.428   138.867     0.200
     4.983   155.766     0.200
     5.436   169.867     0.200
     5.648   176.969     0.200
     6.488   203.367     0.200
     6.857   214.168     0.200
     6.876   214.969     0.200
     7.474   234.867     0.200
     7.842   245.766     0.200
     7.965   247.766     0.200
     2.608    80.602     0.200
     2.704    85.703     0.200
     2.886    90.703     0.200
     3.624   112.902     0.200
     3.703   115.902     0.200
     4.045   126.801     0.200
     4.129   128.203     0.200
     4.425   138.500     0.200
     4.980   155.203     0.200
     5.646   176.602     0.200
     6.486   203.402     0.200
     6.854   213.500     0.200
     6.873   214.801     0.200
     2.605    80.703     0.200
     2.711    85.203     0.200
     2.896    90.406     0.200
     3.619   112.703     0.200
     3.709   115.406     0.200
     4.052   126.703     0.200
     4.122   127.305     0.200
     4.435   138.609     0.200
     4.986   155.703     0.200
     5.449   170.906     0.200
     5.657   176.305     0.200
     6.497   202.406     0.200
     6.863   213.305     0.200
     6.884   215.008     0.200
     7.489   234.703     0.200
     2.611    80.324     0.200
     2.710    85.523     0.200
     2.892    90.324     0.200
     2.892    90.824     0.200
     3.619   112.922     0.200
     3.709   116.723     0.200
     4.130   128.922     0.200
     4.051   125.324     0.200
     4.051   126.422     0.200
     4.431   138.324     0.200
     4.431   137.625     0.200
     4.985   155.625     0.200
     7.190   226.207     0.200
     8.372   260.824     0.200
     8.853   275.422     0.200
    10.996   343.418     0.200
    11.470   359.270     0.200
    15.188   476.363     0.200
    15.668   487.719     0.200
    17.277   538.844     0.200
    18.063   564.047     0.200
    18.571   584.574     0.200
    19.153   604.000     0.200
     2.603    80.379     0.200
     2.705    85.379     0.200
     3.624   112.678     0.200
     3.704   116.178     0.200
     4.046   126.479     0.200
     4.428   138.178     0.200
     4.428   138.479     0.200
     4.980   155.879     0.200
     5.442   170.979     0.200
     5.650   176.779     0.200
     6.490   202.979     0.200
     6.857   214.178     0.200
     6.953   216.879     0.200
     7.113   222.178     0.200
     7.196   226.254     0.200
     7.484   232.479     0.200
     7.688   239.879     0.200
     7.849   245.979     0.200
     7.883   245.779     0.200
     7.965   248.379     0.200
     8.188   255.678     0.200
     8.239   258.178     0.200
     8.305   258.078     0.200
     8.370   261.279     0.200
     8.851   275.979     0.200
     9.242   286.678     0.200
    15.196   474.977     0.200
    18.065   564.754     0.200
    18.563   583.678     0.200
     2.538    78.703     0.200
     3.344   105.102     0.200
     3.666   114.402     0.200
     3.666   114.703     0.200
     3.973   124.902     0.200
     4.016   124.402     0.200
     4.607   144.703     0.200
     4.922   154.602     0.200
     5.161   161.203     0.200
     6.004   187.500     0.200
     6.390   199.402     0.200
     6.396   199.801     0.200
     6.480   202.602     0.200
     6.622   206.602     0.200
     6.856   215.102     0.200
     7.141   223.102     0.200
     7.334   230.000     0.200
     7.380   229.902     0.200
     7.492   233.703     0.200
     7.696   239.703     0.200
     7.748   241.703     0.200
     7.869   245.402     0.200
     8.370   261.203     0.200
     8.419   258.145     0.200
     8.763   273.102     0.200
     8.841   275.801     0.200
     9.014   281.102     0.200
     9.476   292.969     0.200
    10.946   340.297     0.200
    11.048   345.945     0.200
    15.122   471.113     0.200
    18.572   582.828     0.200
     2.519    78.688     0.200
     2.519    78.188     0.200
     3.345   105.289     0.200
     3.669   114.688     0.200
     4.009   125.188     0.200
     4.009   124.383     0.200
     3.984   124.984     0.200
     3.984   123.289     0.200
     4.609   144.289     0.200
     6.887   218.133     0.200
     8.394   254.258     0.200
     8.385   261.383     0.200
     8.778   273.789     0.200
     8.854   275.789     0.200
     9.489   295.188     0.200
     9.989   309.984     0.200
    10.464   325.289     0.200
    10.694   332.984     0.200
    10.877   336.984     0.200
    11.066   345.727     0.200
    11.083   344.586     0.200
    15.145   473.891     0.200
    17.738   551.508     0.200
    18.676   585.211     0.200
    18.851   593.289     0.200
    20.085   639.984     0.200
     2.531    78.359     0.200
     3.344   104.758     0.200
     3.666   115.156     0.200
     3.977   125.059     0.200
     4.014   125.656     0.200
     4.607   143.758     0.200
     4.932   154.156     0.200
     5.166   162.059     0.200
     6.395   200.359     0.200
     6.400   199.258     0.200
     6.484   202.859     0.200
     6.628   207.359     0.200
     7.152   224.059     0.200
     7.344   229.359     0.200
     2.524    78.246     0.200
     3.665   114.547     0.200
     3.977   125.148     0.200
     4.015   126.348     0.200
     4.606   144.449     0.200
     4.937   156.246     0.200
     5.168   161.547     0.200
     6.400   200.547     0.200
     6.397   199.746     0.200
     6.486   203.449     0.200
     6.630   207.246     0.200
     7.350   230.547     0.200
     2.828    89.883     0.200
     2.828    89.184     0.200
     2.862    90.383     0.200
     2.862    89.184     0.200
     3.094    95.584     0.200
     3.587   112.084     0.200
     3.856   121.584     0.200
     4.162   129.482     0.200
     4.162   129.283     0.200
     4.390   138.184     0.200
     6.520   205.789     0.200
     6.808   213.783     0.200
     6.791   212.982     0.200
     6.856   215.184     0.200
     6.960   218.482     0.200
     7.366   231.084     0.200
     7.840   245.283     0.200
     7.864   245.383     0.200
     8.080   252.982     0.200
     8.175   255.684     0.200
     8.727   272.883     0.200
     9.122   284.684     0.200
     9.223   287.783     0.200
    10.487   323.650     0.200
    11.124   348.123     0.200
     2.526    78.641     0.200
     3.338   104.742     0.200
     3.661   114.445     0.200
     3.971   124.539     0.200
     4.020   125.445     0.200
     4.602   143.742     0.200
     4.929   154.945     0.200
     5.161   161.445     0.200
     6.004   188.141     0.200
     6.390   198.641     0.200
     6.394   199.742     0.200
     6.479   201.039     0.200
     6.623   206.742     0.200
     7.154   223.242     0.200
     2.517    78.495     0.200
     2.517    78.395     0.200
     3.337   104.294     0.200
     3.661   114.595     0.200
     3.661   114.695     0.200
     3.975   125.195     0.200
     3.975   124.095     0.200
     4.018   125.794     0.200
     4.601   143.095     0.200
     4.940   154.895     0.200
     5.167   161.595     0.200
     6.009   187.895     0.200
     6.395   199.995     0.200
     6.398   200.495     0.200
     6.484   203.095     0.200
     6.628   207.195     0.200
     6.882   215.070     0.200
     7.167   223.595     0.200
     7.207   224.595     0.200
     7.353   230.195     0.200
     7.387   231.095     0.200
     7.702   240.895     0.200
     7.754   242.495     0.200
     7.824   243.595     0.200
     7.877   245.195     0.200
     8.221   256.395     0.200
     8.375   262.294     0.200
     8.405   255.437     0.200
     8.768   272.395     0.200
     9.018   280.595     0.200
     9.480   293.757     0.200
    10.959   343.155     0.200
    11.068   345.288     0.200
    18.563   578.270     0.200
    18.678   584.520     0.200
    18.844   590.883     0.200
     2.513    77.742     0.200
     2.513    77.641     0.200
     3.341   103.543     0.200
     3.665   113.941     0.200
     3.665   113.742     0.200
     4.012   124.941     0.200
     4.012   123.742     0.200
     3.982   124.543     0.200
     3.982   124.043     0.200
     4.606   143.543     0.200
     6.892   214.461     0.200
     8.384   259.441     0.200
     8.776   272.543     0.200
     9.027   279.543     0.200
     9.488   294.410     0.200
    10.970   346.133     0.200
     2.603    80.531     0.200
     2.689    84.730     0.200
     2.869    90.633     0.200
     3.638   112.531     0.200
     3.689   114.832     0.200
     4.030   126.633     0.200
     4.408   138.730     0.200
     4.965   154.633     0.200
     5.416   170.031     0.200
     5.628   175.934     0.200
     6.468   202.633     0.200
     6.837   213.730     0.200
     6.855   213.633     0.200
     6.932   215.730     0.200
     7.823   243.730     0.200
     2.524    78.109     0.200
     3.350   104.914     0.200
     3.674   114.711     0.200
     4.005   123.414     0.200
     3.988   124.609     0.200
     4.614   143.914     0.200
     4.951   155.211     0.200
     5.180   161.914     0.200
     6.023   188.812     0.200
     6.409   200.016     0.200
     6.412   199.914     0.200
     6.497   203.414     0.200
     6.642   207.414     0.200
     6.884   215.984     0.200
     7.169   224.016     0.200
     7.221   225.711     0.200
    10.972   344.516     0.200
     2.514    78.445     0.200
     3.659   114.547     0.200
     3.974   124.547     0.200
     4.019   124.141     0.200
     4.600   143.445     0.200
     4.942   155.141     0.200
     5.167   162.141     0.200
     6.398   198.945     0.200
     6.395   199.844     0.200
     6.629   206.844     0.200
     7.170   224.141     0.200
     7.355   230.844     0.200
     2.527    78.383     0.200
     2.527    78.484     0.200
     3.351   105.281     0.200
     3.674   114.180     0.200
     3.674   114.586     0.200
     4.005   123.984     0.200
     4.005   123.781     0.200
     3.988   123.680     0.200
     4.615   143.781     0.200
     5.179   161.086     0.200
     6.880   216.508     0.200
     8.388   261.383     0.200
     8.781   273.281     0.200
     8.857   275.781     0.200
     9.492   294.828     0.200
    11.057   344.523     0.200
    10.969   345.312     0.200
    15.136   471.383     0.200
    18.552   576.258     0.200
    18.685   586.508     0.200
    18.858   596.609     0.200
     2.548    78.797     0.200
     3.674   114.195     0.200
     3.980   124.797     0.200
     4.009   125.594     0.200
     4.615   145.195     0.200
     4.922   153.891     0.200
     5.166   162.391     0.200
     6.395   199.297     0.200
     6.402   200.492     0.200
     6.486   202.992     0.200
     6.627   207.195     0.200
     7.134   222.992     0.200
     7.334   229.992     0.200
     7.384   230.594     0.200
     7.498   234.492     0.200
     7.874   245.992     0.200
     2.529    78.608     0.200
     3.336   104.508     0.200
     3.658   114.308     0.200
     3.967   124.208     0.200
     4.023   125.808     0.200
     4.599   143.808     0.200
     4.921   154.808     0.200
     5.156   161.108     0.200
     5.999   187.708     0.200
     6.385   199.108     0.200
     6.390   199.108     0.200
     6.474   201.808     0.200
     6.617   206.708     0.200
     7.147   223.908     0.200
     3.332   104.751     0.200
     3.657   113.751     0.200
     3.976   124.951     0.200
     4.020   124.551     0.200
     4.597   143.251     0.200
     4.955   155.650     0.200
     5.172   162.251     0.200
     6.014   188.551     0.200
     6.400   200.051     0.200
     6.400   199.851     0.200
     6.487   202.951     0.200
     6.634   207.150     0.200
     6.904   217.900     0.200
     7.189   224.251     0.200
     7.370   230.351     0.200
     7.394   229.751     0.200
     7.499   234.251     0.200
     7.708   240.051     0.200
     7.760   242.451     0.200
     7.884   246.351     0.200
     8.227   255.751     0.200
     8.379   260.551     0.200
     8.392   256.069     0.200
     8.772   273.351     0.200
     9.022   280.251     0.200
     9.483   293.619     0.200
    10.971   342.604     0.200
    11.085   345.969     0.200
     2.508    78.125     0.200
     3.650   114.523     0.200
     3.964   123.922     0.200
     4.029   125.422     0.200
     4.590   143.727     0.200
     4.935   155.125     0.200
     5.157   162.023     0.200
     6.000   188.023     0.200
     6.386   198.625     0.200
     6.388   199.625     0.200
     6.474   201.922     0.200
     6.619   206.422     0.200
     7.170   223.328     0.200
     7.348   229.523     0.200
     2.511    78.508     0.200
     3.327   104.109     0.200
     3.650   115.008     0.200
     3.964   124.508     0.200
     4.029   125.508     0.200
     4.591   143.008     0.200
     4.932   154.508     0.200
     5.156   160.711     0.200
     6.385   198.711     0.200
     6.387   199.805     0.200
     6.473   202.609     0.200
     6.618   207.109     0.200
     7.166   223.906     0.200
     7.346   229.805     0.200
     2.532    78.536     0.200
     3.343   104.036     0.200
     3.666   114.936     0.200
     3.975   124.136     0.200
     4.015   124.036     0.200
     4.606   143.936     0.200
     4.929   154.036     0.200
     5.165   161.836     0.200
     6.008   187.436     0.200
     6.393   199.636     0.200
     6.398   199.136     0.200
     6.483   202.436     0.200
     6.626   206.836     0.200
     2.619    82.223     0.200
     2.722    85.422     0.200
     2.722    85.523     0.200
     2.938    92.324     0.200
     2.939    90.922     0.200
     2.939    92.125     0.200
     3.275   103.324     0.200
     3.275   102.723     0.200
     3.880   121.625     0.200
     4.507   140.422     0.200
     4.507   140.922     0.200
     4.738   147.922     0.200
     4.545   141.324     0.200
     6.991   220.875     0.200
     2.535    78.254     0.200
     2.535    78.152     0.200
     3.355   106.453     0.200
     3.678   115.555     0.200
     4.002   125.254     0.200
     3.990   125.453     0.200
     4.619   145.152     0.200
     6.872   217.629     0.200
     8.397   256.223     0.200
     8.781   274.152     0.200
     8.858   276.652     0.200
     9.032   280.855     0.200
     9.493   295.555     0.200
     9.994   311.453     0.200
    10.466   326.855     0.200
    10.691   333.355     0.200
    10.883   337.055     0.200
    11.090   344.152     0.200
    18.863   591.387     0.200
    20.068   634.254     0.200
    23.767   750.742     0.200
     2.516    77.898     0.200
     3.325   104.496     0.200
     3.648   113.898     0.200
     3.959   124.398     0.200
     4.033   125.996     0.200
     4.588   143.496     0.200
     4.922   154.695     0.200
     5.150   161.695     0.200
     7.156   223.797     0.200
     2.513    78.422     0.200
     3.344   105.121     0.200
     3.669   114.023     0.200
     4.009   123.922     0.200
     3.986   124.922     0.200
     4.609   143.723     0.200
     6.895   216.301     0.200
     2.514    78.504     0.200
     3.342   105.102     0.200
     3.666   114.504     0.200
     3.982   125.504     0.200
     4.012   125.602     0.200
     4.606   143.902     0.200
     4.951   155.406     0.200
     5.175   162.305     0.200
     6.018   188.602     0.200
     6.404   200.406     0.200
     6.406   199.500     0.200
     6.492   202.102     0.200
     6.637   207.406     0.200
     6.891   218.352     0.200
     7.176   224.203     0.200
     7.364   230.102     0.200
     9.488   292.594     0.200
     2.541    78.938     0.200
     3.340   105.141     0.200
     3.662   114.344     0.200
     3.967   124.641     0.200
     4.022   124.844     0.200
     4.603   143.742     0.200
     4.912   154.141     0.200
     5.153   161.039     0.200
     5.997   187.141     0.200
     6.382   199.438     0.200
     6.389   198.938     0.200
     6.473   201.938     0.200
     6.615   206.844     0.200
     7.324   228.539     0.200
     2.504    77.693     0.200
     3.305   103.094     0.200
     3.628   112.894     0.200
     3.939   123.794     0.200
     4.053   125.894     0.200
     4.568   142.494     0.200
     4.908   153.394     0.200
     5.130   160.693     0.200
     5.973   186.394     0.200
     6.362   198.394     0.200
     6.359   198.294     0.200
     6.592   204.994     0.200
     7.322   229.594     0.200
     2.509    77.770     0.200
     3.335   104.070     0.200
     3.659   114.570     0.200
     3.976   125.270     0.200
     4.019   125.869     0.200
     4.600   144.369     0.200
     4.947   155.369     0.200
     5.169   161.570     0.200
     6.012   188.270     0.200
     6.399   200.471     0.200
     6.398   199.170     0.200
     6.486   203.270     0.200
     6.631   207.869     0.200
     7.361   230.971     0.200
     2.536    78.664     0.200
     2.536    79.066     0.200
     3.358   104.363     0.200
     3.681   115.066     0.200
     3.998   123.965     0.200
     3.998   123.266     0.200
     3.993   124.766     0.200
     4.622   143.766     0.200
     4.947   155.066     0.200
     5.183   161.465     0.200
     6.026   188.566     0.200
     6.412   200.465     0.200
     6.416   200.566     0.200
     6.501   202.266     0.200
     6.645   207.566     0.200
     6.874   216.441     0.200
     7.159   223.566     0.200
     7.360   229.566     0.200
     7.403   229.965     0.200
     7.513   234.363     0.200
     7.719   241.066     0.200
     7.771   242.664     0.200
     7.893   246.066     0.200
     8.238   256.863     0.200
     8.393   254.234     0.200
     8.392   261.465     0.200
     8.785   273.566     0.200
     8.862   275.363     0.200
     9.036   280.863     0.200
     9.497   296.434     0.200
     9.497   296.164     0.200
     9.998   309.965     0.200
    10.470   324.465     0.200
    10.695   333.664     0.200
    10.886   337.566     0.200
    10.971   344.785     0.200
    11.049   345.508     0.200
    11.093   344.766     0.200
    14.757   458.363     0.200
    15.128   472.418     0.200
    16.104   499.957     0.200
    18.549   578.391     0.200
    18.693   586.289     0.200
    18.865   593.215     0.200
    20.069   633.465     0.200
     2.534    78.586     0.200
     3.361   105.688     0.200
     3.685   114.887     0.200
     3.994   123.586     0.200
     3.999   125.387     0.200
     4.626   145.086     0.200
     4.955   155.188     0.200
     5.190   162.488     0.200
     6.033   188.086     0.200
     6.418   200.586     0.200
     6.422   200.586     0.200
     6.507   203.488     0.200
     7.166   223.586     0.200
     7.367   230.289     0.200
     2.521    78.305     0.200
     3.348   105.008     0.200
     3.672   115.305     0.200
     3.987   125.008     0.200
     4.006   125.102     0.200
     4.613   144.508     0.200
     4.952   155.703     0.200
     5.180   162.602     0.200
     6.023   187.906     0.200
     6.408   200.508     0.200
     6.411   200.406     0.200
     6.497   203.203     0.200
     6.642   207.406     0.200
     6.888   218.008     0.200
     7.173   224.102     0.200
     7.365   230.805     0.200
     7.401   231.008     0.200
     7.509   233.203     0.200
     7.715   241.102     0.200
     7.767   241.906     0.200
     7.890   245.703     0.200
     8.392   256.125     0.200
     8.781   274.102     0.200
     9.031   280.406     0.200
    10.972   341.500     0.200
    11.063   344.023     0.200
    18.550   577.508     0.200
    18.678   586.953     0.200
     2.536    78.781     0.200
     3.362   105.781     0.200
     3.685   115.086     0.200
     3.994   125.281     0.200
     3.998   125.281     0.200
     4.626   144.180     0.200
     4.953   156.180     0.200
     5.189   162.883     0.200
     6.032   188.180     0.200
     6.418   200.586     0.200
     6.421   200.781     0.200
     6.507   203.484     0.200
     6.650   207.383     0.200
     7.163   223.883     0.200
     7.366   230.383     0.200
     2.509    77.781     0.200
     3.313   103.480     0.200
     3.635   114.281     0.200
     3.946   124.480     0.200
     4.045   126.082     0.200
     4.576   143.184     0.200
     4.912   153.684     0.200
     5.137   160.883     0.200
     5.980   186.082     0.200
     6.366   199.082     0.200
     6.369   198.684     0.200
     6.454   200.684     0.200
     7.326   229.184     0.200
     2.511    78.406     0.200
     2.511    78.008     0.200
     3.320   104.305     0.200
     3.643   114.406     0.200
     3.643   113.805     0.200
     3.955   123.906     0.200
     3.955   125.207     0.200
     4.037   124.605     0.200
     4.037   127.805     0.200
     4.584   143.008     0.200
     4.921   153.605     0.200
     5.146   161.008     0.200
     5.989   187.008     0.200
     6.375   199.207     0.200
     6.378   199.008     0.200
     6.463   201.906     0.200
     6.608   206.508     0.200
     6.873   217.555     0.200
     7.334   229.406     0.200
     7.367   228.906     0.200
     7.475   232.406     0.200
     7.681   239.605     0.200
     7.733   240.508     0.200
     7.856   245.105     0.200
     8.201   255.305     0.200
     8.355   260.008     0.200
     8.425   256.523     0.200
     8.747   272.605     0.200
     8.823   274.805     0.200
     8.998   280.207     0.200
     9.459   294.426     0.200
    10.939   343.449     0.200
    11.075   347.023     0.200
    11.055   343.508     0.200
     2.506    78.411     0.200
     3.313   104.211     0.200
     3.636   114.411     0.200
     3.948   123.811     0.200
     4.044   126.411     0.200
     4.577   143.011     0.200
     4.917   154.511     0.200
     5.140   161.311     0.200
     5.982   187.111     0.200
     6.371   198.811     0.200
     6.368   198.711     0.200
     6.457   201.711     0.200
     7.331   229.111     0.200
     2.547    79.162     0.200
     3.370   105.763     0.200
     3.693   115.562     0.200
     3.987   123.662     0.200
     4.004   126.062     0.200
     4.634   145.662     0.200
     4.951   156.062     0.200
     5.193   162.863     0.200
     6.036   187.662     0.200
     6.422   201.162     0.200
     6.427   200.463     0.200
     6.511   202.562     0.200
     7.363   230.263     0.200
     2.538    79.154     0.200
     3.358   105.054     0.200
     3.681   114.954     0.200
     3.999   123.454     0.200
     3.992   125.554     0.200
     4.622   144.454     0.200
     4.945   155.454     0.200
     5.182   162.654     0.200
     7.357   229.554     0.200
     2.532    78.793     0.200
     3.360   104.793     0.200
     3.684   114.793     0.200
     3.995   123.391     0.200
     3.998   125.090     0.200
     4.625   144.492     0.200
     4.956   156.492     0.200
     5.189   162.891     0.200
     6.651   207.891     0.200
     7.168   224.691     0.200
     7.368   230.590     0.200
     2.532    78.680     0.200
     2.532    78.880     0.200
     3.329   104.579     0.200
     3.650   113.979     0.200
     3.956   124.479     0.200
     4.033   125.680     0.200
     4.033   124.979     0.200
     4.591   143.779     0.200
     4.905   155.079     0.200
     4.905   153.579     0.200
     5.143   161.680     0.200
     5.986   188.180     0.200
     6.372   199.180     0.200
     6.462   202.779     0.200
     6.604   206.279     0.200
     6.849   218.404     0.200
     7.134   223.880     0.200
     7.318   228.579     0.200
     7.361   230.279     0.200
     7.474   233.880     0.200
     7.678   240.579     0.200
     7.730   242.279     0.200
     7.851   244.779     0.200
     8.197   255.779     0.200
     8.353   260.279     0.200
     8.436   256.948     0.200
     8.745   271.880     0.200
     8.823   274.779     0.200
     8.996   280.680     0.200
     9.458   293.747     0.200
     9.458   294.680     0.200
     9.960   309.579     0.200
    10.430   324.579     0.200
    10.652   332.680     0.200
    10.849   338.279     0.200
    10.928   341.352     0.200
    11.058   344.479     0.200
    11.056   347.822     0.200
    15.125   473.979     0.200
    18.590   583.479     0.200
    18.703   588.380     0.200
    18.840   592.773     0.200
     2.520    78.227     0.200
     3.650   113.633     0.200
     3.960   124.328     0.200
     4.031   126.227     0.200
     5.150   161.531     0.200
     5.993   187.727     0.200
     6.379   198.828     0.200
     6.383   199.227     0.200
     6.468   201.430     0.200
     6.612   206.828     0.200
     7.334   228.727     0.200
     2.533    78.785     0.200
     3.335   104.485     0.200
     3.657   114.285     0.200
     3.964   124.186     0.200
     4.025   124.686     0.200
     4.598   143.686     0.200
     4.914   154.485     0.200
     5.152   161.385     0.200
     5.995   187.885     0.200
     6.381   199.485     0.200
     6.386   199.285     0.200
     6.471   201.885     0.200
     6.613   206.485     0.200
     7.139   223.585     0.200
     7.327   229.285     0.200
     3.628   113.160     0.200
     3.941   123.859     0.200
     4.052   125.859     0.200
     4.569   142.260     0.200
     5.133   160.660     0.200
     5.976   187.260     0.200
     6.364   199.160     0.200
     6.362   198.559     0.200
     6.450   201.260     0.200
     7.162   223.660     0.200
     7.329   229.260     0.200
     2.532    78.914     0.200
     3.355   105.816     0.200
     3.679   115.316     0.200
     4.001   124.016     0.200
     3.991   125.215     0.200
     4.619   144.113     0.200
     4.948   155.215     0.200
     5.182   162.016     0.200
     6.025   189.113     0.200
     6.411   200.016     0.200
     6.415   200.016     0.200
     6.644   207.316     0.200
     7.163   223.715     0.200
     7.361   229.816     0.200
     2.504    78.117     0.200
     3.643   113.812     0.200
     3.958   124.414     0.200
     4.036   125.711     0.200
     5.151   160.914     0.200
     5.993   186.914     0.200
     6.381   198.516     0.200
     6.379   199.016     0.200
     6.612   206.914     0.200
     7.169   224.312     0.200
     7.344   229.211     0.200
     2.531    79.029     0.200
     3.323   104.330     0.200
     3.644   113.930     0.200
     3.949   123.729     0.200
     4.039   126.229     0.200
     4.585   143.029     0.200
     5.136   160.630     0.200
     5.979   186.630     0.200
     6.365   198.229     0.200
     6.371   198.529     0.200
     6.455   201.330     0.200
     6.597   205.830     0.200
     7.131   222.630     0.200
     7.312   228.430     0.200
     2.500    77.977     0.200
     3.304   103.781     0.200
     3.627   113.383     0.200
     3.939   123.883     0.200
     4.053   126.180     0.200
     4.568   142.578     0.200
     4.911   153.883     0.200
     5.131   160.477     0.200
     5.974   186.680     0.200
     6.362   198.383     0.200
     6.593   205.680     0.200
     7.325   227.883     0.200
     2.552    79.792     0.200
     3.324   103.292     0.200
     3.643   114.292     0.200
     3.940   123.692     0.200
     3.940   125.192     0.200
     4.045   127.192     0.200
     4.584   143.292     0.200
     4.871   152.692     0.200
     5.122   160.192     0.200
     5.965   185.792     0.200
     6.350   196.792     0.200
     6.361   197.392     0.200
     6.443   200.292     0.200
     7.283   227.392     0.200
     3.346   104.027     0.200
     3.663   115.027     0.200
     3.949   124.027     0.200
     4.031   127.227     0.200
     4.851   152.930     0.200
     5.124   160.227     0.200
     6.353   197.629     0.200
     6.369   198.828     0.200
     6.449   201.027     0.200
     7.261   228.430     0.200
     2.529    79.061     0.200
     3.657   114.660     0.200
     3.966   125.260     0.200
     4.024   126.459     0.200
     5.155   161.760     0.200
     6.384   200.061     0.200
     6.389   199.160     0.200
     6.474   201.859     0.200
     6.617   206.561     0.200
     7.334   229.760     0.200
     2.526    78.566     0.200
     3.662   114.367     0.200
     3.973   124.668     0.200
     4.019   124.566     0.200
     4.603   144.367     0.200
     4.931   154.969     0.200
     5.163   161.867     0.200
     6.392   200.270     0.200
     6.396   199.367     0.200
     6.481   202.270     0.200
     6.624   206.566     0.200
     7.155   223.270     0.200
     7.344   229.168     0.200
     2.529    78.945     0.200
     3.652   114.648     0.200
     3.959   124.844     0.200
     4.031   126.844     0.200
     4.592   143.945     0.200
     4.912   153.648     0.200
     5.147   161.547     0.200
     6.376   199.750     0.200
     6.381   199.250     0.200
     6.466   201.750     0.200
     6.609   207.047     0.200
     6.856   218.023     0.200
     7.141   223.945     0.200
     7.325   228.648     0.200
     8.430   257.664     0.200
    10.934   341.062     0.200
     3.306   103.805     0.200
     3.629   113.609     0.200
     3.943   123.609     0.200
     4.050   124.805     0.200
     4.050   124.906     0.200
     4.570   143.008     0.200
     4.918   153.211     0.200
     5.136   160.109     0.200
     5.979   186.109     0.200
     6.367   198.406     0.200
     6.882   215.805     0.200
    10.933   344.070     0.200
     2.545    78.980     0.200
     3.329   105.281     0.200
     3.649   113.883     0.200
     3.950   124.781     0.200
     4.036   124.582     0.200
     5.134   160.883     0.200
     7.302   227.281     0.200
     2.520    78.070     0.200
     3.636   113.969     0.200
     3.942   124.672     0.200
     4.047   126.570     0.200
     4.576   143.172     0.200
     4.899   154.273     0.200
     5.131   160.070     0.200
     5.974   187.672     0.200
     6.359   199.469     0.200
     6.365   199.172     0.200
     7.313   229.172     0.200
     2.511    78.000     0.200
     2.511    77.602     0.200
     3.315   104.195     0.200
     3.638   114.102     0.200
     3.638   113.297     0.200
     3.949   123.797     0.200
     3.949   123.195     0.200
     4.043   126.297     0.200
     4.579   143.797     0.200
     4.913   154.500     0.200
     5.139   160.602     0.200
     5.982   187.398     0.200
     6.368   198.602     0.200
     6.372   198.898     0.200
     6.601   206.695     0.200
     6.869   216.672     0.200
     7.154   224.195     0.200
     7.180   224.102     0.200
     7.327   228.602     0.200
     7.360   229.695     0.200
     7.469   232.398     0.200
     7.675   240.000     0.200
     7.727   240.000     0.200
     7.797   243.297     0.200
     7.849   245.602     0.200
     8.348   260.500     0.200
     8.432   258.195     0.200
     8.741   272.398     0.200
     8.817   274.602     0.200
     8.991   280.102     0.200
     9.453   294.398     0.200
    11.076   345.789     0.200
    15.147   472.570     0.200
    18.681   585.250     0.200
     2.527    78.578     0.200
     3.322   103.680     0.200
     3.643   114.477     0.200
     3.949   124.680     0.200
     4.040   125.977     0.200
     4.584   143.977     0.200
     4.901   153.875     0.200
     5.137   161.078     0.200
     6.365   198.180     0.200
     6.371   198.578     0.200
     6.598   205.180     0.200
     7.315   229.781     0.200
     2.519    78.445     0.200
     3.310   103.445     0.200
     3.632   113.445     0.200
     3.938   123.344     0.200
     4.051   126.242     0.200
     4.573   143.547     0.200
     5.126   160.344     0.200
     5.970   185.945     0.200
     6.355   198.547     0.200
     6.361   198.047     0.200
     6.588   205.547     0.200
     7.137   222.945     0.200
     7.309   228.148     0.200
     2.520    78.396     0.200
     3.320   104.297     0.200
     3.642   113.996     0.200
     3.950   124.396     0.200
     3.950   123.496     0.200
     4.040   126.297     0.200
     4.583   143.797     0.200
     4.908   154.896     0.200
     5.139   160.697     0.200
     5.982   187.896     0.200
     6.368   198.896     0.200
     6.373   198.496     0.200
     6.860   214.172     0.200
     7.144   223.396     0.200
     7.322   229.098     0.200
    10.928   341.877     0.200
     2.517    78.333     0.200
     3.631   113.732     0.200
     3.938   123.632     0.200
     4.051   127.132     0.200
     4.572   143.333     0.200
     4.897   153.632     0.200
     5.127   160.033     0.200
     5.970   186.433     0.200
     6.356   199.033     0.200
     6.361   198.533     0.200
     6.588   205.833     0.200
     7.139   223.933     0.200
     7.311   228.132     0.200
     2.520    78.359     0.200
     3.317   104.559     0.200
     3.639   113.760     0.200
     3.946   124.160     0.200
     4.043   125.359     0.200
     4.580   143.359     0.200
     5.135   160.760     0.200
     5.978   186.260     0.200
     6.364   197.959     0.200
     6.369   198.559     0.200
     6.596   205.559     0.200
     7.317   227.959     0.200
     2.519    78.578     0.200
     3.341   104.078     0.200
     3.665   114.578     0.200
     3.979   125.379     0.200
     4.014   124.977     0.200
     4.605   143.777     0.200
     5.170   162.477     0.200
     6.013   188.578     0.200
     6.399   199.379     0.200
     6.632   207.477     0.200
     7.356   231.277     0.200
     2.514    78.688     0.200
     3.306   103.188     0.200
     3.628   114.086     0.200
     3.935   122.789     0.200
     4.054   126.391     0.200
     4.569   142.492     0.200
     4.896   154.492     0.200
     5.124   161.086     0.200
     6.586   205.586     0.200
     7.141   223.188     0.200
     7.310   229.188     0.200
     2.519    78.758     0.200
     3.320   103.058     0.200
     3.642   114.158     0.200
     3.950   124.458     0.200
     3.950   122.758     0.200
     4.040   126.958     0.200
     4.583   143.958     0.200
     4.909   153.758     0.200
     5.140   161.658     0.200
     5.140   159.058     0.200
     5.983   187.458     0.200
     6.368   198.458     0.200
     6.373   199.558     0.200
     6.601   206.858     0.200
     7.145   224.458     0.200
     7.323   228.258     0.200
    10.929   343.683     0.200
    11.068   345.951     0.200
     2.519    78.664     0.200
     3.635   113.964     0.200
     3.942   124.264     0.200
     4.048   127.164     0.200
     4.576   142.964     0.200
     4.900   154.164     0.200
     5.130   160.664     0.200
     5.974   186.363     0.200
     6.359   198.863     0.200
     6.364   198.063     0.200
     6.592   205.563     0.200
     7.139   223.664     0.200
     7.313   228.063     0.200
     2.523    78.967     0.200
     3.631   113.268     0.200
     3.936   123.367     0.200
     4.053   127.066     0.200
     4.572   142.967     0.200
     5.123   159.867     0.200
     7.303   228.268     0.200
     2.519    78.340     0.200
     3.314   103.242     0.200
     3.636   114.340     0.200
     3.943   124.242     0.200
     4.047   125.543     0.200
     4.577   142.840     0.200
     4.901   154.141     0.200
     5.132   161.141     0.200
     5.975   187.242     0.200
     6.360   198.340     0.200
     6.365   199.141     0.200
     7.315   229.543     0.200
     2.500    77.697     0.200
     3.628   113.498     0.200
     3.941   123.598     0.200
     4.052   126.398     0.200
     4.569   142.598     0.200
     4.913   154.197     0.200
     5.133   160.398     0.200
     5.976   186.498     0.200
     6.364   198.197     0.200
     6.361   198.297     0.200
     6.595   205.498     0.200
     7.161   223.697     0.200
     7.328   228.797     0.200
     2.501    77.738     0.200
     3.303   104.238     0.200
     3.626   113.438     0.200
     3.938   124.238     0.200
     4.054   126.338     0.200
     4.567   142.738     0.200
     4.909   155.037     0.200
     5.129   161.338     0.200
     5.129   160.338     0.200
     5.972   187.738     0.200
     6.358   198.137     0.200
     6.361   198.338     0.200
     6.873   216.238     0.200
     7.170   223.238     0.200
     7.158   223.137     0.200
     7.323   227.637     0.200
     7.351   230.037     0.200
     7.459   231.838     0.200
     7.717   240.438     0.200
     7.840   246.037     0.200
     8.439   256.357     0.200
     8.731   272.838     0.200
     8.981   280.338     0.200
     9.442   293.238     0.200
     9.943   309.738     0.200
    10.417   324.738     0.200
    10.649   332.537     0.200
    10.831   337.037     0.200
    11.038   343.338     0.200
    11.087   347.631     0.200
    15.156   474.865     0.200
    18.673   582.562     0.200
    18.600   581.812     0.200
     3.306   103.414     0.200
     3.630   113.215     0.200
     3.945   123.715     0.200
     4.049   124.814     0.200
     4.571   142.914     0.200
     4.923   153.715     0.200
     5.139   161.115     0.200
     5.982   187.314     0.200
     6.369   198.314     0.200
     7.172   223.016     0.200
     7.338   228.115     0.200
     2.509    78.039     0.200
     3.328   104.836     0.200
     3.652   114.336     0.200
     3.966   124.641     0.200
     4.027   124.734     0.200
     4.592   143.438     0.200
     4.936   155.438     0.200
     5.159   161.836     0.200
     6.002   186.641     0.200
     6.388   199.141     0.200
     6.390   199.836     0.200
     6.621   207.141     0.200
     7.350   229.039     0.200
     2.599    80.152     0.200
     2.599    79.953     0.200
     2.698    84.652     0.200
     3.630   112.254     0.200
     3.630   112.355     0.200
     3.697   116.453     0.200
     3.697   116.152     0.200
     4.039   126.453     0.200
     4.039   125.254     0.200
     4.421   137.754     0.200
     4.421   136.855     0.200
     4.974   155.453     0.200
     5.436   170.555     0.200
     5.643   177.055     0.200
     5.911   186.453     0.200
     6.850   214.055     0.200
     7.194   226.207     0.200
     7.482   233.855     0.200
     7.843   244.555     0.200
     7.876   247.355     0.200
     7.958   248.555     0.200
     8.232   258.055     0.200
     8.363   261.754     0.200
    11.008   340.066     0.200
    18.072   562.879     0.200
    18.562   581.414     0.200
    19.141   601.969     0.200
     2.514    78.617     0.200
     3.317   104.117     0.200
     3.639   113.820     0.200
     3.949   124.219     0.200
     4.042   126.219     0.200
     4.580   142.922     0.200
     4.912   154.523     0.200
     5.139   160.719     0.200
     5.982   186.922     0.200
     6.368   198.922     0.200
     6.372   199.219     0.200
     7.151   224.023     0.200
     7.326   229.117     0.200
     3.497   110.086     0.200
     3.831   119.184     0.200
     3.836   118.984     0.200
     4.209   131.586     0.200
     4.772   149.184     0.200
     5.256   165.484     0.200
     5.430   169.684     0.200
     6.637   206.785     0.200
     7.131   224.859     0.200
     7.418   232.285     0.200
     7.670   238.785     0.200
     7.745   240.684     0.200
     8.152   254.984     0.200
     2.530    78.805     0.200
     3.361   105.805     0.200
     3.685   114.805     0.200
     3.993   123.203     0.200
     4.000   125.602     0.200
     4.626   144.008     0.200
     4.960   155.805     0.200
     5.192   162.602     0.200
     6.035   187.602     0.200
     6.421   200.703     0.200
     6.654   208.203     0.200
     7.172   223.508     0.200
     2.554    79.745     0.200
     3.373   106.545     0.200
     3.696   115.745     0.200
     3.985   124.345     0.200
     4.004   125.745     0.200
     4.637   145.145     0.200
     6.861   216.195     0.200
     8.391   255.339     0.200
    11.030   346.213     0.200
    10.974   340.965     0.200
     2.595    80.266     0.200
     2.689    84.867     0.200
     2.872    90.465     0.200
     3.639   113.266     0.200
     3.689   115.465     0.200
     4.030   125.367     0.200
     4.411   138.664     0.200
     4.965   154.566     0.200
     5.425   170.566     0.200
     5.632   176.367     0.200
     5.914   184.766     0.200
     6.472   201.266     0.200
     6.840   213.766     0.200
     6.935   215.664     0.200
     7.096   221.164     0.200
     2.509    79.604     0.200
     2.576    80.205     0.200
     3.415   107.004     0.200
     3.739   116.805     0.200
     3.941   123.904     0.200
     4.050   127.205     0.200
     4.680   146.604     0.200
     5.238   164.205     0.200
     6.467   202.504     0.200
     6.473   201.104     0.200
     6.699   208.705     0.200
     7.157   223.705     0.200
     2.518    78.301     0.200
     3.344   105.001     0.200
     3.668   114.901     0.200
     3.983   125.201     0.200
     4.010   124.801     0.200
     4.609   143.901     0.200
     4.949   154.801     0.200
     5.176   162.301     0.200
     6.019   188.101     0.200
     6.405   200.101     0.200
     6.407   200.302     0.200
     6.638   206.901     0.200
     6.887   218.101     0.200
     7.172   224.501     0.200
     7.216   224.802     0.200
     7.363   230.601     0.200
     7.397   231.001     0.200
     7.505   234.601     0.200
     7.764   241.802     0.200
     7.833   244.901     0.200
     7.886   246.101     0.200
     8.384   261.401     0.200
     8.777   273.001     0.200
     8.853   276.201     0.200
     9.489   294.419     0.200
    10.969   343.360     0.200
    11.066   345.694     0.200
    18.554   580.476     0.200
    18.676   586.226     0.200
    18.850   592.642     0.200
     2.520    78.180     0.200
     3.336   105.180     0.200
     3.659   114.078     0.200
     3.972   124.777     0.200
     4.020   125.180     0.200
     4.600   144.180     0.200
     4.934   154.379     0.200
     5.163   161.578     0.200
     6.006   187.777     0.200
     6.391   199.379     0.200
     6.395   199.477     0.200
     6.624   205.879     0.200
     6.876   217.527     0.200
     7.161   223.180     0.200
     7.203   224.578     0.200
     7.347   228.477     0.200
     7.383   230.477     0.200
     7.492   233.777     0.200
     7.750   241.879     0.200
     7.820   243.977     0.200
     7.873   245.977     0.200
     8.218   255.777     0.200
     8.372   259.578     0.200
     8.764   272.277     0.200
     8.841   275.477     0.200
     9.476   294.922     0.200
    10.954   343.359     0.200
    18.568   577.453     0.200
    18.683   586.629     0.200
     2.520    78.492     0.200
     3.324   104.891     0.200
     3.646   113.891     0.200
     3.956   124.590     0.200
     4.035   125.992     0.200
     4.587   143.391     0.200
     5.145   161.391     0.200
     7.328   230.090     0.200
     2.792    85.707     0.200
     2.755    86.605     0.200
     2.884    90.406     0.200
     3.572   109.605     0.200
     4.100   127.906     0.200
     4.425   138.906     0.200
     5.039   157.605     0.200
     5.289   165.805     0.200
     5.611   174.906     0.200
     5.729   179.207     0.200
     6.848   212.707     0.200
     6.933   216.805     0.200
     7.237   226.207     0.200
     2.505    78.072     0.200
     3.332   104.872     0.200
     3.656   114.272     0.200
     4.021   125.672     0.200
     3.973   125.072     0.200
     3.973   124.772     0.200
     4.947   154.472     0.200
     6.895   214.447     0.200
    10.964   344.124     0.200
     3.311   103.918     0.200
     3.635   113.117     0.200
     3.955   123.816     0.200
     4.576   142.918     0.200
     5.151   160.117     0.200
     6.102   190.316     0.200
     6.903   216.645     0.200
     9.462   292.262     0.200
    11.099   345.484     0.200
    10.952   341.914     0.200
     2.507    78.223     0.200
     3.303   103.623     0.200
     3.625   114.022     0.200
     3.934   124.022     0.200
     4.565   142.423     0.200
     4.899   153.923     0.200
     5.124   161.224     0.200
     5.967   185.622     0.200
     6.095   191.022     0.200
     6.356   198.423     0.200
     2.596    80.258     0.200
     2.687    85.055     0.200
     3.686   115.453     0.200
     3.930   121.805     0.200
     4.028   126.055     0.200
     4.407   138.156     0.200
     4.962   155.055     0.200
     5.628   175.953     0.200
     5.914   184.758     0.200
     6.468   201.758     0.200
     6.836   213.156     0.200
     6.856   214.055     0.200
     6.931   216.555     0.200
     2.600    80.523     0.200
     2.689    84.422     0.200
     2.870    90.523     0.200
     3.689   114.922     0.200
     4.030   125.723     0.200
     4.409   137.824     0.200
     4.965   155.621     0.200
     5.419   170.223     0.200
     5.630   176.324     0.200
     5.910   184.422     0.200
     6.470   201.023     0.200
     6.838   212.422     0.200
     6.857   213.523     0.200
     6.933   216.121     0.200
     7.467   233.523     0.200
     2.509    77.686     0.200
     2.509    78.686     0.200
     3.319   104.686     0.200
     3.642   113.385     0.200
     3.954   124.785     0.200
     3.954   124.186     0.200
     4.361   136.135     0.200
     4.582   143.584     0.200
     4.921   155.385     0.200
     5.145   160.584     0.200
     5.988   187.285     0.200
     6.374   199.584     0.200
     6.377   198.686     0.200
     6.462   202.084     0.200
     6.875   216.410     0.200
     7.160   222.785     0.200
     7.186   223.285     0.200
     7.335   228.186     0.200
     8.425   258.930     0.200
     9.458   292.604     0.200
    11.077   349.229     0.200
     2.723    86.020     0.200
     3.188   100.320     0.200
     3.535   110.420     0.200
     3.938   123.920     0.200
     3.958   123.520     0.200
     4.466   139.221     0.200
     7.312   229.971     0.200
     8.399   261.420     0.200
     8.788   272.420     0.200
     8.839   275.020     0.200
     9.034   279.920     0.200
     9.486   293.889     0.200
     9.486   294.420     0.200
     9.958   309.619     0.200
    10.499   327.619     0.200
    10.834   336.820     0.200
    10.870   338.920     0.200
    10.995   341.920     0.200
    11.132   348.641     0.200
    11.443   358.037     0.200
    15.561   485.381     0.200
    18.245   571.920     0.200
    18.483   575.820     0.200
    18.625   587.473     0.200
    20.521   650.820     0.200
    22.724   721.490     0.200
    23.625   749.475     0.200
     2.718    86.314     0.200
     2.718    86.113     0.200
     3.174   100.113     0.200
     3.521   110.814     0.200
     3.941   124.213     0.200
     4.453   139.314     0.200
     5.186   162.414     0.200
     5.197   162.914     0.200
     6.030   187.613     0.200
     6.370   199.613     0.200
     6.420   199.213     0.200
     6.477   201.213     0.200
     6.660   207.113     0.200
     7.614   238.014     0.200
     8.254   252.832     0.200
     2.720    86.607     0.200
     3.188   100.408     0.200
     3.535   110.908     0.200
     3.956   124.309     0.200
     4.466   139.809     0.200
     5.213   163.309     0.200
     5.200   163.908     0.200
     6.046   189.209     0.200
     6.386   198.607     0.200
     6.436   201.607     0.200
     6.493   202.107     0.200
     6.676   207.809     0.200
     7.629   239.209     0.200
     2.724    86.295     0.200
     2.724    85.693     0.200
     3.176   100.295     0.200
     3.522   110.193     0.200
     3.936   123.145     0.200
     3.944   123.494     0.200
     4.454   138.994     0.200
     5.192   163.395     0.200
     7.307   230.920     0.200
     7.455   233.693     0.200
     7.591   236.795     0.200
     7.621   238.295     0.200
     7.790   243.395     0.200
     7.938   247.295     0.200
     8.386   261.594     0.200
     8.775   272.795     0.200
     8.825   275.494     0.200
     9.020   279.895     0.200
     9.472   293.438     0.200
     9.472   294.494     0.200
     9.944   308.994     0.200
    10.485   325.295     0.200
    10.821   336.094     0.200
    10.857   339.295     0.200
    10.982   341.494     0.200
    11.119   349.174     0.200
    18.244   575.369     0.200
     2.701    85.367     0.200
     3.178    99.672     0.200
     3.523   110.273     0.200
     3.939   123.273     0.200
     4.455   139.273     0.200
     5.174   163.469     0.200
     5.193   162.469     0.200
     6.027   188.172     0.200
     6.369   198.469     0.200
     6.384   200.367     0.200
     7.602   237.773     0.200
     2.726    85.508     0.200
     3.173    99.508     0.200
     3.520   110.312     0.200
     3.934   122.234     0.200
     3.942   123.312     0.200
     4.451   139.008     0.200
     6.371   198.406     0.200
     6.422   201.008     0.200
     6.478   202.406     0.200
     6.662   207.812     0.200
     7.308   229.109     0.200
     7.453   232.008     0.200
     7.490   233.109     0.200
     7.739   240.906     0.200
     7.936   247.812     0.200
     8.772   273.211     0.200
    11.117   349.906     0.200
    11.451   360.328     0.200
    15.566   490.352     0.200
    18.243   569.961     0.200
    18.611   585.781     0.200
     2.706    85.326     0.200
     3.172   100.226     0.200
     3.518   110.926     0.200
     3.935   123.826     0.200
     3.952   123.426     0.200
     4.156   129.126     0.200
     4.450   138.826     0.200
     5.173   161.626     0.200
     5.189   162.626     0.200
     6.023   187.426     0.200
     6.364   199.226     0.200
     6.413   200.226     0.200
     6.471   201.026     0.200
     6.652   208.026     0.200
     7.286   229.300     0.200
     7.601   237.426     0.200
    11.103   350.784     0.200
     2.607    80.533     0.200
     2.709    85.135     0.200
     2.893    91.033     0.200
     3.620   112.934     0.200
     3.708   115.734     0.200
     4.050   126.834     0.200
     4.432   139.334     0.200
     4.984   155.934     0.200
     5.653   176.635     0.200
     5.902   185.334     0.200
     6.493   203.434     0.200
     6.860   213.334     0.200
     6.881   214.734     0.200
     6.956   217.135     0.200
     7.116   221.533     0.200
     7.851   246.434     0.200
     2.522    78.523     0.200
     3.309   103.430     0.200
     3.630   113.930     0.200
     3.935   123.430     0.200
     4.054   126.227     0.200
     4.571   142.523     0.200
     4.889   153.328     0.200
     5.122   159.828     0.200
     5.965   186.328     0.200
     6.083   191.023     0.200
     6.351   197.227     0.200
     6.357   198.430     0.200
     6.441   200.523     0.200
     6.584   205.930     0.200
     7.131   222.828     0.200
     7.163   223.328     0.200
     2.501    77.617     0.200
     3.306   103.816     0.200
     3.629   113.219     0.200
     3.941   123.719     0.200
     4.051   126.418     0.200
     4.355   136.059     0.200
     5.133   161.117     0.200
     5.976   187.418     0.200
     6.096   190.316     0.200
     6.362   198.816     0.200
     6.364   198.617     0.200
     6.450   201.316     0.200
     6.595   205.816     0.200
     7.160   223.719     0.200
     7.173   223.918     0.200
     7.327   228.316     0.200
     7.354   229.918     0.200
     7.462   232.816     0.200
     7.669   239.418     0.200
     7.844   244.816     0.200
    10.928   340.699     0.200
    11.087   347.188     0.200
     3.264   103.026     0.200
     3.585   112.625     0.200
     3.894   121.526     0.200
     4.097   127.125     0.200
     4.347   135.476     0.200
     4.526   141.226     0.200
     4.872   153.326     0.200
     5.085   159.125     0.200
     5.928   185.326     0.200
     6.314   197.326     0.200
     6.317   196.625     0.200
     6.402   199.826     0.200
     7.288   226.526     0.200
     8.480   260.344     0.200
     9.398   291.694     0.200
    10.883   343.546     0.200
    15.169   479.875     0.200
     2.563    81.039     0.200
     3.034    95.039     0.200
     3.343   104.836     0.200
     3.612   113.438     0.200
     4.284   134.234     0.200
     4.366   136.734     0.200
     4.368   134.789     0.200
     4.591   144.938     0.200
     6.732   210.688     0.200
    11.205   349.781     0.200
     2.532    78.404     0.200
     2.559    80.205     0.200
     2.731    85.705     0.200
     3.563   110.904     0.200
     3.765   116.006     0.200
     3.901   122.105     0.200
     4.271   133.705     0.200
     4.838   151.205     0.200
     5.292   166.006     0.200
     3.543   111.070     0.200
     3.872   121.668     0.200
     4.131   127.570     0.200
     4.483   140.668     0.200
     4.908   153.371     0.200
     5.077   158.371     0.200
     6.940   218.293     0.200
     9.383   293.938     0.200
     3.308   104.576     0.200
     3.308   103.976     0.200
     3.635   113.576     0.200
     3.635   113.976     0.200
     3.966   124.876     0.200
     4.037   126.476     0.200
     4.297   134.126     0.200
     4.575   143.576     0.200
     4.977   156.976     0.200
     5.169   162.176     0.200
     6.011   188.076     0.200
     6.122   192.576     0.200
     6.392   198.576     0.200
     6.397   199.376     0.200
     6.481   202.676     0.200
     6.631   206.576     0.200
     6.948   218.645     0.200
     8.380   255.719     0.200
     9.476   296.227     0.200
    10.982   345.056     0.200
    18.611   583.946     0.200
     2.727    84.898     0.200
     3.131    98.598     0.200
     3.131    98.898     0.200
     3.477   107.695     0.200
     3.477   108.496     0.200
     3.928   122.371     0.200
     3.896   121.695     0.200
     4.198   129.996     0.200
     4.409   138.098     0.200
     5.153   160.598     0.200
     5.151   160.898     0.200
     5.986   187.195     0.200
     6.325   197.398     0.200
     6.376   198.695     0.200
     6.432   200.297     0.200
     7.183   224.496     0.200
     7.292   230.648     0.200
     7.407   230.598     0.200
     7.444   231.797     0.200
     7.581   235.996     0.200
     7.742   241.996     0.200
     7.889   246.398     0.200
     8.295   250.840     0.200
     8.337   258.598     0.200
     8.726   270.695     0.200
     8.777   272.496     0.200
     8.972   278.898     0.200
     9.424   290.164     0.200
     9.424   293.496     0.200
     9.896   307.297     0.200
    10.437   323.195     0.200
    10.773   333.297     0.200
    10.935   337.695     0.200
    11.073   349.117     0.200
    11.469   360.941     0.200
     2.964    92.586     0.200
     3.392   106.785     0.200
     3.392   106.684     0.200
     3.420   105.586     0.200
     3.475   108.684     0.200
     3.475   108.086     0.200
     4.413   137.586     0.200
     4.735   147.484     0.200
     5.010   156.387     0.200
     5.583   174.387     0.200
     6.144   191.684     0.200
     6.767   216.012     0.200
     6.991   218.586     0.200
     7.653   240.586     0.200
     7.714   234.129     0.200
     7.926   246.984     0.200
    10.201   319.004     0.200
    10.480   325.379     0.200
    11.740   366.844     0.200
     3.306   104.465     0.200
     3.628   113.363     0.200
     3.937   123.863     0.200
     4.053   126.066     0.200
     4.569   143.066     0.200
     4.900   154.164     0.200
     5.127   159.863     0.200
     2.680    85.344     0.200
     3.180   100.445     0.200
     3.524   109.945     0.200
     3.978   124.270     0.200
     4.148   128.945     0.200
     4.457   139.547     0.200
     5.156   162.445     0.200
     5.185   162.445     0.200
     6.019   188.445     0.200
     6.364   199.145     0.200
     6.371   199.746     0.200
    11.092   350.727     0.200
    18.288   574.320     0.200
    18.513   575.094     0.200
     3.119    98.148     0.200
     3.437   107.344     0.200
     3.737   117.148     0.200
     4.251   131.844     0.200
     4.378   136.945     0.200
     4.748   148.547     0.200
     4.929   153.750     0.200
     5.772   180.547     0.200
     6.160   191.945     0.200
     6.158   192.445     0.200
     6.245   194.547     0.200
     6.391   199.547     0.200
     3.126    99.371     0.200
     3.444   108.570     0.200
     4.244   132.371     0.200
     4.385   138.070     0.200
     4.748   150.570     0.200
     4.934   154.871     0.200
     5.776   181.770     0.200
     3.119    99.367     0.200
     3.437   107.766     0.200
     4.307   134.047     0.200
     4.250   131.766     0.200
     4.378   136.668     0.200
     4.751   148.766     0.200
     4.931   155.465     0.200
     5.774   180.867     0.200
     8.619   262.992     0.200
    10.743   338.805     0.200
    11.201   351.301     0.200
     3.420   107.375     0.200
     3.720   116.277     0.200
     4.307   133.000     0.200
     6.833   214.539     0.200
     8.638   263.094     0.200
    10.724   333.016     0.200
    11.209   351.406     0.200
     3.421   108.070     0.200
     3.721   116.070     0.200
     4.307   135.523     0.200
     6.834   216.820     0.200
     7.156   222.273     0.200
     8.637   263.945     0.200
     8.589   266.273     0.200
     3.434   108.148     0.200
     3.730   117.750     0.200
     4.322   134.867     0.200
     6.822   214.125     0.200
     7.632   236.852     0.200
     8.598   269.453     0.200
    10.727   336.773     0.200
    11.192   348.047     0.200
     4.299   133.711     0.200
     4.741   148.336     0.200
     6.145   193.535     0.200
     6.842   217.094     0.200
     7.163   224.535     0.200
     8.590   267.836     0.200
     9.226   284.703     0.200
    10.729   336.771     0.200
    11.214   350.160     0.200
    15.240   475.982     0.200
    16.249   504.926     0.200
    18.001   558.254     0.200
    18.625   585.164     0.200
    18.621   585.738     0.200
    18.810   588.672     0.200
    23.490   745.260     0.200
     3.128    99.232     0.200
     3.446   108.033     0.200
     4.308   134.223     0.200
     4.387   137.133     0.200
     4.761   149.332     0.200
     4.942   156.434     0.200
     6.172   194.232     0.200
     6.844   216.787     0.200
     7.181   224.934     0.200
     7.270   226.232     0.200
     8.542   268.232     0.200
     8.608   261.318     0.200
     8.618   268.832     0.200
     9.253   286.996     0.200
    10.229   320.033     0.200
    10.753   337.631     0.200
    10.851   339.732     0.200
    11.196   349.514     0.200
    15.227   475.572     0.200
    16.235   504.320     0.200
    17.974   557.611     0.200
    18.633   584.533     0.200
    18.646   588.115     0.200
    18.784   587.062     0.200
    20.091   638.277     0.200
    23.517   746.189     0.200
     3.452   108.814     0.200
     3.753   118.514     0.200
     4.314   134.203     0.200
     4.760   148.514     0.200
     6.176   192.814     0.200
     6.838   214.838     0.200
     8.607   262.381     0.200
     8.622   270.314     0.200
     9.257   288.531     0.200
    10.754   337.053     0.200
    11.189   351.932     0.200
     3.443   107.852     0.200
     4.336   137.021     0.200
     4.728   148.652     0.200
     6.809   213.852     0.200
     8.636   262.820     0.200
     8.602   268.652     0.200
     9.237   289.920     0.200
    10.725   336.860     0.200
    11.178   351.245     0.200
    15.202   475.977     0.200
    18.662   587.352     0.200
     2.951    91.550     0.200
     3.676   115.149     0.200
     8.086   252.425     0.200
    10.358   321.949     0.200
    14.589   453.067     0.200
    16.250   504.242     0.200
    16.935   525.300     0.200
    17.593   552.949     0.200
    18.231   573.199     0.200
    19.796   622.175     0.200
    24.157   761.435     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.503    15.883     0.200
     0.557    17.922     0.200
     2.287    71.820     0.200
     2.287    73.023     0.200
     0.483    16.180     0.200
     0.914    28.680     0.200
     2.088    65.680     0.200
     2.129    67.680     0.200
     2.209    69.680     0.200
     2.335    73.477     0.200
     2.341    75.078     0.200
     2.395    76.883     0.200
     2.444    78.180     0.200
     0.712    23.168     0.200
     1.383    44.168     0.200
     2.345    74.668     0.200
     8.142   248.367     0.200
     0.535    17.562     0.200
     0.669    22.562     0.200
     1.380    43.363     0.200
     2.197    69.963     0.200
     2.337    74.562     0.200
     2.869    85.062     0.200
     0.538    17.762     0.200
     0.596    19.062     0.200
     1.972    61.262     0.200
     2.179    67.461     0.200
     2.249    70.762     0.200
     0.387    13.898     0.200
     0.776    24.898     0.200
     1.040    32.898     0.200
     1.972    63.602     0.200
     2.233    70.102     0.200
     2.298    72.102     0.200
     2.430    75.195     0.200
     2.482    76.898     0.200
     1.953    59.094     0.200
     0.562    18.047     0.200
     1.130    36.848     0.200
     1.137    36.848     0.200
     1.929    60.148     0.200
     2.379    74.348     0.200
     1.276    39.672     0.200
     2.027    62.875     0.200
     2.465    74.273     0.200
     2.492    78.273     0.200
     0.324    11.320     0.200
     1.244    39.922     0.200
     1.245    39.922     0.200
     2.023    62.320     0.200
     2.447    74.922     0.200
     2.493    79.117     0.200
     1.251    38.961     0.200
     1.253    38.961     0.200
     2.451    74.867     0.200
     2.492    79.164     0.200
     0.318    10.125     0.200
     1.254    40.023     0.200
     2.014    62.922     0.200
     2.453    75.125     0.200
     2.490    79.125     0.200
     0.281     9.982     0.200
     1.284    40.082     0.200
     1.285    40.082     0.200
     2.466    75.281     0.200
     2.499    78.482     0.200
     1.251    39.566     0.200
     1.252    39.566     0.200
     2.015    61.668     0.200
     2.456    74.270     0.200
     2.486    78.770     0.200
     0.284     9.909     0.200
     1.268    39.508     0.200
     1.270    39.508     0.200
     2.002    61.708     0.200
     2.448    75.909     0.200
     0.310    10.188     0.200
     1.256    39.287     0.200
     1.258    39.287     0.200
     2.011    62.188     0.200
     2.453    75.287     0.200
     2.494    78.988     0.200
     5.576   168.688     0.200
     0.320    10.773     0.200
     1.247    40.070     0.200
     1.248    40.070     0.200
     2.020    62.570     0.200
     2.448    74.672     0.200
     2.494    78.172     0.200
     1.270    41.017     0.200
     1.271    41.017     0.200
     1.997    63.217     0.200
     2.468    76.717     0.200
     2.483    78.117     0.200
     0.309    10.467     0.200
     1.264    40.367     0.200
     1.265    40.367     0.200
     2.002    62.268     0.200
     2.461    75.467     0.200
     2.488    79.467     0.200
     0.613    19.824     0.200
     0.620    19.824     0.200
     1.209    38.824     0.200
     2.207    68.324     0.200
     5.329   154.215     0.200
     0.286    10.020     0.200
     1.279    40.418     0.200
     1.280    40.418     0.200
     1.990    61.418     0.200
     2.463    75.617     0.200
     2.499    78.418     0.200
     0.303    10.625     0.200
     0.853    28.625     0.200
     2.032    62.125     0.200
     2.422    74.523     0.200
     3.485   100.125     0.200
     5.309   154.422     0.200
     5.450   158.328     0.200
     8.039   235.125     0.200
     0.313    11.195     0.200
     2.040    61.992     0.200
     2.418    72.492     0.200
     0.319    10.754     0.200
     0.826    27.754     0.200
     1.271    40.555     0.200
     1.272    40.555     0.200
     1.994    62.254     0.200
     2.477    76.055     0.200
     2.469    79.754     0.200
     0.297    10.055     0.200
     1.314    41.555     0.200
     1.315    41.555     0.200
     1.952    60.758     0.200
     2.454    78.055     0.200
     1.367    43.410     0.200
     1.368    43.410     0.200
     1.909    59.311     0.200
     2.512    75.910     0.200
     6.777   191.211     0.200
     0.295    10.949     0.200
     0.856    28.750     0.200
     1.259    40.150     0.200
     2.012    62.250     0.200
     2.040    62.150     0.200
     2.442    75.150     0.200
     0.611    18.938     0.200
     0.611    19.938     0.200
     0.584    19.639     0.200
     1.337    42.139     0.200
     2.161    69.639     0.200
     2.699    82.339     0.200
     7.447   211.139     0.200
     0.266     8.414     0.200
     0.880    29.211     0.200
     1.327    42.211     0.200
     1.329    42.211     0.200
     2.475    78.211     0.200
     0.552    17.441     0.200
     0.561    17.441     0.200
     0.580    19.441     0.200
     1.256    40.441     0.200
     2.157    66.941     0.200
     0.708    23.105     0.200
     2.247    70.605     0.200
     2.300    72.105     0.200
     2.341    72.707     0.200
     2.449    78.105     0.200
     6.268   182.207     0.200
     2.866    86.682     0.200
     5.933   171.981     0.200
     0.510    16.039     0.200
     1.353    43.039     0.200
     1.352    43.039     0.200
     2.233    71.539     0.200
     2.665    81.742     0.200
     0.550    18.688     0.200
     0.758    23.688     0.200
     0.846    28.188     0.200
     2.153    69.484     0.200
     2.252    70.984     0.200
     2.223    70.188     0.200
     2.429    76.086     0.200
     0.664    21.188     0.200
     1.073    34.188     0.200
     1.075    34.188     0.200
     2.218    68.281     0.200
     2.372    75.188     0.200
     2.464    76.586     0.200
     2.341    74.188     0.200
     2.403    76.188     0.200
     0.764    25.418     0.200
     0.913    29.117     0.200
     0.915    29.117     0.200
     2.210    70.516     0.200
     2.251    69.516     0.200
     2.339    71.016     0.200
     2.439    77.516     0.200
     9.799   285.617     0.200
    10.684   307.117     0.200
     0.811    26.426     0.200
     0.859    27.023     0.200
     0.862    27.023     0.200
     2.194    66.723     0.200
     2.304    70.824     0.200
     2.467    76.625     0.200
     4.829   141.324     0.200
     7.253   214.223     0.200
     0.887    28.625     0.200
     2.124    67.328     0.200
     2.139    66.625     0.200
     2.333    71.625     0.200
     2.430    76.031     0.200
     2.351    72.703     0.200
     2.409    76.805     0.200
     0.991    31.271     0.200
     2.368    74.672     0.200
     2.353    74.871     0.200
     6.321   186.771     0.200
     9.901   284.871     0.200
     0.562    18.215     0.200
     2.155    69.016     0.200
     2.745    83.316     0.200
     0.385    12.112     0.200
     2.297    72.712     0.200
     2.838    86.712     0.200
     5.501   158.112     0.200
     0.578    18.664     0.200
     1.302    40.961     0.200
     2.210    71.266     0.200
     0.383    12.207     0.200
     2.304    72.207     0.200
     2.842    86.906     0.200
     2.842    86.605     0.200
     0.584    18.582     0.200
     1.275    40.082     0.200
     2.225    70.582     0.200
     0.551    18.240     0.200
     2.272    71.141     0.200
     2.415    76.141     0.200
     0.322    11.365     0.200
     0.492    15.746     0.200
     1.498    47.246     0.200
     1.497    46.246     0.200
     2.183    69.445     0.200
     2.183    68.445     0.200
     2.778    84.348     0.200
     0.790    26.102     0.200
     0.790    25.902     0.200
     2.380    74.402     0.200
     1.019    33.177     0.200
     2.539    74.677     0.200
     0.658    21.758     0.200
     0.902    29.156     0.200
     1.879    59.758     0.200
     2.102    64.656     0.200
     2.057    65.055     0.200
     0.695    22.816     0.200
     1.183    38.816     0.200
     2.171    69.918     0.200
     2.426    74.617     0.200
     2.526    77.316     0.200
     3.406   102.918     0.200
     5.931   180.617     0.200
     0.560    17.972     0.200
     1.212    39.572     0.200
     2.153    67.172     0.200
     2.153    66.972     0.200
     0.659    21.465     0.200
     0.901    29.266     0.200
     2.058    64.266     0.200
     2.102    64.164     0.200
     2.102    64.863     0.200
     0.267     9.867     0.200
     0.267    11.062     0.200
     2.749    82.867     0.200
     0.727    23.773     0.200
     1.004    32.574     0.200
     2.000    62.973     0.200
     2.255    69.473     0.200
     0.694    22.914     0.200
     1.256    40.117     0.200
     1.256    39.922     0.200
     2.956    87.320     0.200
     0.719    23.391     0.200
     1.117    35.789     0.200
     1.117    35.391     0.200
     2.259    70.188     0.200
     2.302    72.688     0.200
     2.406    75.688     0.200
     2.406    75.992     0.200
     3.645   110.891     0.200
     0.340    11.910     0.200
     2.335    73.309     0.200
     4.140   122.109     0.200
     4.280   129.207     0.200
     6.757   202.309     0.200
     0.360    12.219     0.200
     0.360    12.020     0.200
     1.642    51.319     0.200
     2.313    73.619     0.200
     2.313    72.619     0.200
     2.806    85.919     0.200
     3.350   101.719     0.200
     4.146   124.619     0.200
     6.761   203.020     0.200
     0.933    30.039     0.200
     0.933    29.838     0.200
     2.396    73.338     0.200
     3.345   101.639     0.200
     3.356   100.738     0.200
     4.639   140.238     0.200
     5.966   179.539     0.200
     6.942   209.838     0.200
     0.671    22.214     0.200
     0.871    28.014     0.200
     0.871    27.414     0.200
     2.108    67.214     0.200
     2.209    69.113     0.200
     2.209    67.613     0.200
     2.292    71.714     0.200
     2.292    71.613     0.200
     0.226     7.812     0.200
     0.226     7.711     0.200
     1.350    42.812     0.200
     1.350    43.211     0.200
     2.505    75.516     0.200
     2.499    78.312     0.200
     2.499    78.711     0.200
     0.318    10.918     0.200
     0.318    10.719     0.200
     1.254    40.719     0.200
     2.454    75.418     0.200
     2.454    74.719     0.200
     2.499    78.621     0.200
     0.304    10.414     0.200
     1.256    40.414     0.200
     1.256    40.113     0.200
     2.445    75.711     0.200
     2.445    74.414     0.200
     2.505    79.113     0.200
     2.505    78.512     0.200
     0.303    10.191     0.200
     0.303     9.992     0.200
     1.261    40.289     0.200
     2.452    75.289     0.200
     2.452    74.691     0.200
     2.499    78.992     0.200
     2.499    78.492     0.200
     0.513    17.073     0.200
     1.159    36.673     0.200
     1.159    37.173     0.200
     2.385    74.973     0.200
     2.384    74.973     0.200
     2.384    75.873     0.200
     2.473    76.873     0.200
     2.473    76.473     0.200
     0.320    10.582     0.200
     1.259    39.882     0.200
     2.462    75.182     0.200
     2.481    78.782     0.200
     0.343    11.450     0.200
     1.236    39.350     0.200
     1.236    39.050     0.200
     2.063    64.950     0.200
     2.449    75.150     0.200
     2.449    74.850     0.200
     2.479    77.750     0.200
     2.481    78.050     0.200
     0.348    11.351     0.200
     1.229    39.450     0.200
     2.069    64.751     0.200
     2.445    75.650     0.200
     2.473    78.150     0.200
     2.482    79.251     0.200
     0.395    12.865     0.200
     1.216    38.465     0.200
     2.081    64.665     0.200
     2.462    76.065     0.200
     2.454    77.165     0.200
     2.444    77.766     0.200
     0.359    11.427     0.200
     1.223    39.526     0.200
     1.223    39.327     0.200
     2.076    65.227     0.200
     2.445    75.827     0.200
     2.465    77.627     0.200
     2.477    78.327     0.200
     2.477    78.727     0.200
     4.011   122.427     0.200
     4.511   137.526     0.200
     0.274     9.785     0.200
     1.277    40.387     0.200
     1.277    40.285     0.200
     2.027    63.484     0.200
     2.450    74.984     0.200
     3.805   111.984     0.200
     3.992   120.785     0.200
     8.211   240.484     0.200
     0.311    10.148     0.200
     0.311    10.047     0.200
     1.257    40.648     0.200
     1.257    39.945     0.200
     2.044    63.750     0.200
     2.452    75.250     0.200
     2.452    74.945     0.200
     2.495    78.945     0.200
     2.495    78.844     0.200
     0.330    10.805     0.200
     1.246    40.211     0.200
     2.053    64.305     0.200
     2.454    75.109     0.200
     2.491    78.008     0.200
     2.484    79.211     0.200
     4.482   135.711     0.200
     0.310    11.037     0.200
     0.310    10.738     0.200
     1.253    39.037     0.200
     1.253    39.638     0.200
     2.048    64.338     0.200
     2.447    74.438     0.200
     2.447    75.338     0.200
     2.499    77.838     0.200
     0.332    11.219     0.200
     1.238    38.816     0.200
     1.238    39.520     0.200
     2.062    64.316     0.200
     2.444    74.418     0.200
     2.444    75.020     0.200
     2.482    77.316     0.200
     2.482    77.520     0.200
     2.491    79.316     0.200
     7.445   217.219     0.200
     0.326    10.945     0.200
     1.247    39.242     0.200
     2.053    64.141     0.200
     2.451    75.344     0.200
     2.491    77.844     0.200
     2.488    78.445     0.200
     4.480   136.141     0.200
     0.602    19.266     0.200
     1.339    43.367     0.200
     2.000    63.164     0.200
     2.167    68.562     0.200
     2.167    68.867     0.200
     4.577   139.461     0.200
     0.332    10.992     0.200
     1.238    39.292     0.200
     1.238    39.992     0.200
     2.062    64.492     0.200
     2.483    77.192     0.200
     2.483    77.393     0.200
     2.444    74.893     0.200
     2.444    75.092     0.200
     2.491    78.393     0.200
     0.314    10.941     0.200
     1.245    38.742     0.200
     1.245    39.742     0.200
     2.057    64.242     0.200
     2.439    74.043     0.200
     2.439    74.441     0.200
     2.491    77.742     0.200
     3.837   115.242     0.200
     5.590   169.543     0.200
     0.333    10.955     0.200
     1.234    39.156     0.200
     2.066    64.455     0.200
     2.440    74.955     0.200
     4.491   136.055     0.200
     0.767    24.973     0.200
     0.767    24.672     0.200
     1.411    44.875     0.200
     0.765    25.118     0.200
     1.286    40.419     0.200
     1.286    40.719     0.200
     2.088    66.719     0.200
     2.088    66.919     0.200
     2.449    76.818     0.200
     2.449    77.818     0.200
     0.350    11.863     0.200
     2.320    73.766     0.200
     2.320    73.164     0.200
     2.794    85.566     0.200
     0.359    12.004     0.200
     2.311    72.707     0.200
     2.311    73.004     0.200
     0.556    17.391     0.200
     0.556    17.789     0.200
     1.283    41.492     0.200
     2.166    67.289     0.200
     0.342    11.695     0.200
     0.342    11.594     0.200
     1.621    50.695     0.200
     2.326    72.594     0.200
     2.784    83.797     0.200
     0.714    22.902     0.200
     0.714    23.301     0.200
     2.185    68.199     0.200
     2.929    88.000     0.200
     0.821    26.664     0.200
     1.331    42.367     0.200
     1.331    42.266     0.200
     2.019    64.562     0.200
     2.019    64.766     0.200
     2.478    78.164     0.200
     3.904   115.766     0.200
     0.818    26.781     0.200
     0.818    26.578     0.200
     1.334    42.484     0.200
     1.334    42.281     0.200
     2.019    64.883     0.200
     2.019    64.984     0.200
     2.482    78.883     0.200
     2.482    78.578     0.200
     0.685    22.316     0.200
     1.009    32.617     0.200
     1.009    32.516     0.200
     2.216    70.418     0.200
     2.216    70.117     0.200
     2.351    74.316     0.200
     2.404    74.516     0.200
     2.404    73.918     0.200
     2.392    76.219     0.200
     2.392    75.516     0.200
     0.679    22.190     0.200
     1.010    32.590     0.200
     1.010    32.090     0.200
     2.219    70.290     0.200
     2.355    74.090     0.200
     2.355    74.190     0.200
     2.402    74.390     0.200
     2.402    73.790     0.200
     2.396    75.890     0.200
     0.695    22.180     0.200
     0.695    22.375     0.200
     1.004    32.680     0.200
     1.004    32.578     0.200
     2.209    70.375     0.200
     2.209    69.680     0.200
     2.342    74.477     0.200
     2.404    74.680     0.200
     2.404    74.180     0.200
     2.390    76.180     0.200
     2.390    75.781     0.200
     0.691    22.254     0.200
     0.691    22.457     0.200
     1.007    32.457     0.200
     1.007    32.656     0.200
     2.213    70.055     0.200
     2.213    70.457     0.200
     2.347    74.156     0.200
     2.407    74.656     0.200
     2.407    74.055     0.200
     2.389    75.855     0.200
     4.014   121.957     0.200
     0.429    14.223     0.200
     1.048    33.824     0.200
     2.204    69.023     0.200
     2.300    72.324     0.200
     2.300    71.922     0.200
     0.680    21.922     0.200
     0.680    22.117     0.200
     2.217    69.617     0.200
     2.217    69.922     0.200
     2.354    73.719     0.200
     2.354    74.117     0.200
     2.402    74.117     0.200
     2.396    75.617     0.200
     0.365    12.211     0.200
     0.365    12.109     0.200
     2.309    72.312     0.200
     2.309    72.414     0.200
     2.813    85.914     0.200
     3.436    98.812     0.200
     3.436   104.508     0.200
     0.062     4.328     0.200
     0.909    28.922     0.200
     2.494    76.523     0.200
     2.494    75.828     0.200
     8.520   248.523     0.200
     0.075     4.450     0.200
     2.490    76.450     0.200
     0.679    21.939     0.200
     0.679    22.340     0.200
     1.004    32.239     0.200
     1.004    32.340     0.200
     2.214    69.840     0.200
     2.351    73.439     0.200
     2.351    73.939     0.200
     2.395    74.340     0.200
     2.395    74.040     0.200
     2.403    75.739     0.200
     2.403    75.540     0.200
     7.357   215.340     0.200
     0.618    19.770     0.200
     0.618    20.170     0.200
     1.217    39.471     0.200
     1.346    43.270     0.200
     1.346    43.770     0.200
     2.150    67.971     0.200
     2.710    82.770     0.200
     5.358   157.170     0.200
     0.589    18.814     0.200
     1.218    37.814     0.200
     2.188    67.713     0.200
     2.188    67.514     0.200
     2.675    80.814     0.200
     5.422   164.113     0.200
     0.607    20.055     0.200
     0.607    18.859     0.200
     1.216    39.758     0.200
     1.338    43.656     0.200
     2.164    68.555     0.200
     7.451   219.859     0.200
     0.605    20.113     0.200
     1.212    38.910     0.200
     1.342    43.512     0.200
     1.342    42.012     0.200
     2.163    68.512     0.200
     0.607    19.805     0.200
     0.607    18.904     0.200
     1.347    43.004     0.200
     2.158    68.805     0.200
     0.648    21.125     0.200
     1.012    32.227     0.200
     1.012    31.922     0.200
     2.228    70.125     0.200
     2.385    74.023     0.200
     2.373    73.922     0.200
     2.421    75.523     0.200
     2.421    75.227     0.200
     7.389   216.828     0.200
     0.290     9.693     0.200
     1.097    35.493     0.200
     1.310    41.594     0.200
     1.310    40.894     0.200
     2.465    78.394     0.200
     2.465    78.094     0.200
     4.422   133.493     0.200
     0.825    26.890     0.200
     0.838    27.190     0.200
     0.838    26.790     0.200
     2.022    64.690     0.200
     2.022    64.090     0.200
     2.160    68.090     0.200
     2.279    71.290     0.200
     2.279    70.990     0.200
     2.488    78.790     0.200
     2.488    78.890     0.200
     0.595    19.489     0.200
     1.217    38.789     0.200
     2.180    69.089     0.200
     0.385    12.172     0.200
     0.385    12.867     0.200
     1.184    37.867     0.200
     2.434    76.172     0.200
     2.434    77.070     0.200
     2.480    76.766     0.200
     2.480    77.172     0.200
     2.474    77.266     0.200
     2.474    77.969     0.200
     0.398    13.094     0.200
     0.398    12.793     0.200
     2.421    76.793     0.200
     2.488    76.992     0.200
     2.488    77.195     0.200
     2.472    77.594     0.200
     2.472    78.094     0.200
     3.851   116.094     0.200
     0.397    12.816     0.200
     0.397    12.918     0.200
     1.231    39.020     0.200
     1.231    39.316     0.200
     1.192    38.020     0.200
     2.427    77.020     0.200
     2.468    77.219     0.200
     2.468    78.418     0.200
     2.481    77.117     0.200
     2.481    77.520     0.200
     0.388    12.844     0.200
     1.190    37.844     0.200
     1.229    38.547     0.200
     1.229    38.750     0.200
     2.438    76.750     0.200
     2.474    76.945     0.200
     2.474    77.148     0.200
     2.468    76.750     0.200
     2.468    77.547     0.200
     3.856   117.648     0.200
     0.551    18.141     0.200
     0.551    18.242     0.200
     1.052    33.945     0.200
     2.132    67.039     0.200
     2.132    67.141     0.200
     0.558    18.172     0.200
     1.058    34.273     0.200
     2.126    67.172     0.200
     2.126    66.969     0.200
     3.638   111.070     0.200
     0.374    13.781     0.200
     2.503    74.180     0.200
     3.484   104.980     0.200
     3.025    87.883     0.200
     5.661   168.680     0.200
     0.450    15.590     0.200
     2.486    73.289     0.200
     2.529    75.188     0.200
     2.529    74.391     0.200
     2.990    89.590     0.200
     5.641   170.891     0.200
     0.290     9.555     0.200
     0.290     9.656     0.200
     1.104    35.453     0.200
     1.302    41.359     0.200
     1.302    41.859     0.200
     2.472    77.953     0.200
     2.472    78.055     0.200
     2.493    76.258     0.200
     2.493    77.258     0.200
     5.533   167.656     0.200
     0.672    21.711     0.200
     0.672    21.812     0.200
     2.248    70.016     0.200
     2.248    70.312     0.200
     3.099    92.492     0.200
     3.099    92.391     0.200
     3.480   102.992     0.200
     0.288    12.044     0.200
     0.288    12.145     0.200
     1.752    53.145     0.200
     2.666    80.744     0.200
     2.666    80.444     0.200
     3.388   102.544     0.200
     4.330   129.145     0.200
     5.346   161.345     0.200
     1.085    35.416     0.200
     1.602    49.616     0.200
    10.152   292.016     0.200
     0.360    11.203     0.200
     0.360    12.109     0.200
     2.300    72.508     0.200
     2.300    72.609     0.200
     2.776    84.805     0.200
     2.776    85.008     0.200
     2.980    90.609     0.200
     3.497   104.109     0.200
     0.641    20.570     0.200
     0.641    21.164     0.200
     2.034    64.469     0.200
     3.598   108.664     0.200
     5.186   156.367     0.200
     7.530   220.664     0.200
     0.369    12.904     0.200
     0.848    27.604     0.200
     2.291    72.504     0.200
     2.785    84.804     0.200
     0.628    21.395     0.200
     3.116    93.797     0.200
     3.116    94.195     0.200
     8.580   252.098     0.200
     0.504    16.435     0.200
     0.504    14.935     0.200
     1.239    40.635     0.200
     2.103    66.135     0.200
     0.469    15.082     0.200
     0.469    14.879     0.200
     0.974    30.980     0.200
     1.521    47.980     0.200
     2.198    70.781     0.200
     2.786    85.180     0.200
     3.584   105.082     0.200
     5.277   154.781     0.200
     0.340    10.961     0.200
     0.340    11.461     0.200
     1.666    52.062     0.200
     2.348    73.762     0.200
     2.805    85.660     0.200
     3.417   100.660     0.200
     3.417    99.363     0.200
     8.145   236.961     0.200
     0.324    10.961     0.200
     0.794    25.859     0.200
     2.349    73.762     0.200
     2.349    74.160     0.200
     2.776    84.961     0.200
     3.485   106.359     0.200
     7.821   233.160     0.200
     0.327    11.041     0.200
     2.344    73.941     0.200
     2.344    74.541     0.200
     3.485   106.441     0.200
     6.999   203.141     0.200
     0.472    15.219     0.200
     1.010    33.023     0.200
     1.486    46.719     0.200
     2.204    69.219     0.200
     0.463    15.090     0.200
     1.004    32.691     0.200
     2.212    69.191     0.200
     2.212    68.990     0.200
     0.540    17.283     0.200
     1.138    36.182     0.200
     1.384    44.082     0.200
     2.190    70.783     0.200
     0.399    12.641     0.200
     0.908    28.938     0.200
     2.260    71.836     0.200
     0.592    18.680     0.200
     1.114    35.582     0.200
     2.113    67.281     0.200
     2.790    85.582     0.200
     0.694    22.203     0.200
     0.694    22.500     0.200
     1.412    44.402     0.200
     2.216    69.402     0.200
     2.262    71.703     0.200
     2.322    73.301     0.200
     2.430    75.602     0.200
     2.430    76.703     0.200
     0.722    23.184     0.200
     2.239    70.383     0.200
     2.256    72.383     0.200
     2.256    71.684     0.200
     2.302    72.383     0.200
     2.302    73.285     0.200
     2.405    75.484     0.200
     2.405    76.086     0.200
     3.645   110.285     0.200
     4.012   122.484     0.200
     5.975   173.684     0.200
     0.309    10.281     0.200
     1.147    36.582     0.200
     1.257    40.180     0.200
     2.045    64.281     0.200
     2.450    75.582     0.200
     2.498    79.281     0.200
     0.370    11.901     0.200
     0.370    12.001     0.200
     1.546    48.701     0.200
     2.288    72.101     0.200
     2.288    72.601     0.200
     2.753    84.501     0.200
     0.318    10.355     0.200
     1.148    36.656     0.200
     2.043    64.059     0.200
     2.459    75.758     0.200
     2.485    79.258     0.200
     3.844   117.258     0.200
     0.310    10.250     0.200
     1.151    36.547     0.200
     1.253    39.547     0.200
     1.253    39.250     0.200
     2.049    64.250     0.200
     2.446    74.848     0.200
     2.446    75.348     0.200
     2.500    79.047     0.200
     2.500    79.148     0.200
     2.498    78.148     0.200
     0.316    10.402     0.200
     0.316    10.504     0.200
     1.152    36.504     0.200
     1.253    40.004     0.200
     1.253    40.305     0.200
     2.048    64.004     0.200
     2.450    75.105     0.200
     2.450    75.305     0.200
     2.498    78.305     0.200
     2.494    79.305     0.200
     3.830   114.703     0.200
     0.351    11.691     0.200
     0.881    28.291     0.200
     2.307    72.391     0.200
     0.378    12.035     0.200
     0.899    28.535     0.200
     1.550    49.336     0.200
     2.280    72.135     0.200
     2.760    84.734     0.200
     0.525    16.934     0.200
     0.525    16.434     0.200
     1.011    32.336     0.200
     1.398    44.336     0.200
     2.287    71.637     0.200
     2.284    71.637     0.200
     2.284    70.535     0.200
     2.441    77.336     0.200
     4.072   124.234     0.200
     0.472    15.712     0.200
     0.472    15.611     0.200
     1.057    33.712     0.200
     1.434    45.111     0.200
     1.434    44.512     0.200
     1.875    59.312     0.200
     2.223    69.611     0.200
     2.783    83.812     0.200
     0.460    15.750     0.200
     0.915    29.352     0.200
     1.065    35.352     0.200
     2.064    66.945     0.200
     2.064    66.648     0.200
     2.240    67.648     0.200
     3.401   103.148     0.200
     3.576   108.445     0.200
     8.950   261.445     0.200
     0.775    25.047     0.200
     1.151    38.242     0.200
     2.242    70.242     0.200
     2.242    68.945     0.200
     3.188    96.844     0.200
     3.188    96.648     0.200
     4.513   136.148     0.200
     8.481   251.648     0.200
     0.542    17.484     0.200
     1.163    37.188     0.200
     1.355    42.688     0.200
     1.967    62.383     0.200
     2.205    70.383     0.200
     2.205    70.586     0.200
     2.683    82.188     0.200
     0.632    20.672     0.200
     1.168    38.172     0.200
     1.168    37.871     0.200
     1.350    43.070     0.200
     2.275    72.172     0.200
     2.275    72.469     0.200
     2.369    74.871     0.200
     2.369    74.270     0.200
     2.487    78.270     0.200
     0.328    10.773     0.200
     1.166    36.977     0.200
     1.240    38.578     0.200
     2.060    64.273     0.200
     2.443    75.078     0.200
     2.485    78.375     0.200
     2.494    78.773     0.200
     0.634    20.316     0.200
     1.203    37.914     0.200
     1.379    44.816     0.200
     2.118    68.617     0.200
     0.195     7.411     0.200
     1.015    32.110     0.200
     1.384    44.110     0.200
     2.522    76.511     0.200
     0.735    23.387     0.200
     0.735    23.787     0.200
     1.039    33.887     0.200
     1.039    32.587     0.200
     1.492    47.287     0.200
     2.307    72.887     0.200
     2.229    71.287     0.200
     2.229    70.787     0.200
     2.322    73.487     0.200
     2.465    76.587     0.200
     2.343    74.387     0.200
     2.343    73.787     0.200
     0.837    27.000     0.200
     0.837    27.102     0.200
     1.301    41.699     0.200
     1.463    47.199     0.200
     1.463    45.801     0.200
     8.400   254.824     0.200
     0.503    16.375     0.200
     1.104    35.578     0.200
     1.399    44.273     0.200
     1.399    44.078     0.200
     1.915    60.773     0.200
     2.212    70.375     0.200
     2.212    69.672     0.200
     3.715   110.773     0.200
     3.715   107.375     0.200
     8.124   240.578     0.200
     8.172   237.672     0.200
     0.692    22.195     0.200
     1.132    36.492     0.200
     1.410    44.695     0.200
     2.215    69.895     0.200
     2.263    73.195     0.200
     2.323    74.293     0.200
     2.431    77.195     0.200
     0.549    17.684     0.200
     1.143    36.383     0.200
     2.165    67.684     0.200
     2.363    74.582     0.200
     2.367    75.582     0.200
     2.476    76.082     0.200
     0.280    11.018     0.200
     0.659    21.219     0.200
     2.737    82.619     0.200
     2.737    82.918     0.200
     0.326    11.195     0.200
     0.618    20.695     0.200
     3.038    91.895     0.200
     3.620   107.094     0.200
     1.078    34.354     0.200
     1.304    42.152     0.200
     1.632    51.053     0.200
     2.300    73.254     0.200
     2.367    75.553     0.200
     2.364    75.053     0.200
     0.773    25.484     0.200
     0.827    26.578     0.200
     2.045    65.781     0.200
     2.237    68.078     0.200
     2.237    70.680     0.200
     2.205    69.078     0.200
     2.484    77.883     0.200
     3.916   116.984     0.200
     0.149     5.344     0.200
     1.371    43.750     0.200
     1.371    42.750     0.200
     1.953    61.945     0.200
     2.474    76.344     0.200
     2.474    75.945     0.200
     8.331   244.148     0.200
     9.435   277.047     0.200
     0.156     5.477     0.200
     1.358    42.977     0.200
     1.966    61.883     0.200
     1.966    63.578     0.200
     2.462    76.281     0.200
     0.738    24.133     0.200
     1.132    35.531     0.200
     1.950    62.332     0.200
     0.275     9.393     0.200
     0.692    22.492     0.200
     1.254    40.692     0.200
     3.085    94.093     0.200
     3.534   106.393     0.200
     4.749   142.893     0.200
     0.718    22.625     0.200
     0.718    23.625     0.200
     1.212    38.930     0.200
     1.379    43.625     0.200
     2.157    68.625     0.200
     2.176    70.125     0.200
     2.390    76.125     0.200
     2.481    78.930     0.200
     7.532   222.125     0.200
     0.541    17.416     0.200
     1.120    35.116     0.200
     1.407    44.416     0.200
     2.177    70.116     0.200
     0.310    10.891     0.200
     0.733    23.789     0.200
     2.393    75.391     0.200
     0.327    10.980     0.200
     1.628    52.180     0.200
     2.370    75.379     0.200
     2.801    85.777     0.200
     0.318    10.352     0.200
     1.548    49.055     0.200
     2.340    73.754     0.200
     0.778    25.059     0.200
     0.935    30.158     0.200
     2.129    68.158     0.200
     2.255    71.359     0.200
     2.374    73.758     0.200
     2.403    75.359     0.200
     2.404    75.258     0.200
     0.603    19.615     0.200
     1.054    33.814     0.200
     2.254    69.914     0.200
     2.275    72.115     0.200
     2.407    74.215     0.200
     2.413    76.414     0.200
     2.423    75.914     0.200
     0.309    10.235     0.200
     0.890    28.435     0.200
     2.349    74.036     0.200
     0.330    10.477     0.200
     0.872    27.777     0.200
     2.328    74.074     0.200
     0.137     5.121     0.200
     0.964    32.012     0.200
     3.325   101.551     0.200
     3.441   103.980     0.200
     0.786    25.508     0.200
     0.927    30.203     0.200
     2.245    70.602     0.200
     2.369    73.602     0.200
     2.413    76.008     0.200
     2.406    77.406     0.200
     0.599    19.098     0.200
     1.163    37.000     0.200
     1.400    45.098     0.200
     2.133    68.699     0.200
     0.583    18.758     0.200
     1.154    36.660     0.200
     1.398    44.859     0.200
     2.147    68.660     0.200
     0.535    17.383     0.200
     1.000    32.281     0.200
     1.409    45.078     0.200
     2.242    71.680     0.200
     2.276    70.883     0.200
     2.431    77.078     0.200
     0.758    23.812     0.200
     0.913    29.016     0.200
     1.573    48.715     0.200
     2.117    67.312     0.200
     2.255    70.516     0.200
     2.336    72.715     0.200
     2.413    74.715     0.200
     2.444    76.414     0.200
     0.331    12.441     0.200
     0.331    12.842     0.200
     0.635    20.441     0.200
     1.803    55.041     0.200
     2.733    82.842     0.200
     1.219    39.631     0.200
     2.113    66.230     0.200
     0.127     7.966     0.200
     0.127     8.066     0.200
     1.964    60.066     0.200
     7.712   232.485     0.200
     0.103     5.992     0.200
     0.836    27.391     0.200
     1.074    34.289     0.200
     2.490    78.594     0.200
     2.801    84.891     0.200
     0.603    19.389     0.200
     1.230    39.488     0.200
     1.316    42.088     0.200
     2.021    63.588     0.200
     2.181    69.389     0.200
     0.621    19.973     0.200
     1.244    39.875     0.200
     1.313    41.875     0.200
     2.030    64.172     0.200
     2.169    69.574     0.200
     2.682    82.375     0.200
     0.175     6.684     0.200
     0.828    27.184     0.200
     2.820    85.484     0.200
     3.290    99.184     0.200
     0.795    25.727     0.200
     1.331    42.227     0.200
     1.360    43.328     0.200
     2.036    66.227     0.200
     2.485    78.828     0.200
     0.811    25.875     0.200
     0.811    26.074     0.200
     1.368    43.676     0.200
     1.338    42.676     0.200
     1.338    42.273     0.200
     2.091    66.273     0.200
     2.091    66.477     0.200
     2.488    79.074     0.200
     2.488    78.875     0.200
     0.818    26.547     0.200
     1.341    42.645     0.200
     2.015    65.344     0.200
     2.093    66.047     0.200
     2.093    67.047     0.200
     2.489    78.645     0.200
     2.489    78.047     0.200
     8.838   257.047     0.200
     0.797    25.676     0.200
     1.329    42.074     0.200
     1.363    43.277     0.200
     2.036    64.676     0.200
     2.092    66.074     0.200
     2.482    78.176     0.200
     0.804    26.055     0.200
     1.329    42.254     0.200
     1.369    43.355     0.200
     2.031    65.055     0.200
     2.096    66.555     0.200
     2.481    78.652     0.200
     0.787    25.484     0.200
     1.345    42.883     0.200
     1.344    42.281     0.200
     2.032    64.484     0.200
     2.073    65.484     0.200
     0.799    26.023     0.200
     1.339    42.324     0.200
     2.028    64.723     0.200
     2.085    66.125     0.200
     2.492    78.922     0.200
     0.793    25.531     0.200
     1.348    42.633     0.200
     2.026    64.828     0.200
     2.073    65.430     0.200
     0.797    25.781     0.200
     1.346    42.481     0.200
     2.024    64.781     0.200
     2.077    65.281     0.200
     2.500    79.381     0.200
     0.806    26.125     0.200
     1.344    42.523     0.200
     1.360    42.922     0.200
     2.020    65.125     0.200
     2.083    65.723     0.200
     2.495    78.824     0.200
     0.802    25.961     0.200
     1.330    42.461     0.200
     1.367    43.859     0.200
     2.032    66.562     0.200
     2.094    66.258     0.200
     0.808    26.029     0.200
     0.808    26.229     0.200
     1.366    43.529     0.200
     1.337    42.529     0.200
     1.337    43.029     0.200
     2.090    67.129     0.200
     2.090    66.930     0.200
     2.024    65.329     0.200
     2.488    78.729     0.200
     0.804    26.068     0.200
     1.344    42.770     0.200
     1.359    43.270     0.200
     2.021    64.469     0.200
     2.083    65.969     0.200
     2.495    79.369     0.200
     0.810    26.151     0.200
     1.344    42.951     0.200
     1.363    43.052     0.200
     2.017    64.852     0.200
     2.085    66.151     0.200
     2.495    78.251     0.200
     0.820    26.342     0.200
     0.820    26.541     0.200
     1.369    44.041     0.200
     1.347    42.842     0.200
     2.088    66.842     0.200
     2.088    66.141     0.200
     2.009    65.342     0.200
     2.494    78.742     0.200
     7.425   221.742     0.200
     1.352    43.091     0.200
     1.343    42.391     0.200
     2.027    64.691     0.200
     2.078    65.891     0.200
     2.497    78.791     0.200
     0.785    25.445     0.200
     1.318    41.352     0.200
     1.361    43.250     0.200
     2.052    65.547     0.200
     2.096    66.547     0.200
     0.812    26.220     0.200
     1.341    42.820     0.200
     1.367    43.620     0.200
     2.089    66.620     0.200
     0.810    26.477     0.200
     1.344    42.875     0.200
     1.363    43.477     0.200
     2.018    65.078     0.200
     2.086    65.672     0.200
     2.494    79.578     0.200
     0.701    22.359     0.200
     0.701    22.961     0.200
     1.228    39.059     0.200
     1.228    39.961     0.200
     2.175    69.660     0.200
     2.175    69.059     0.200
     2.137    66.758     0.200
     2.137    68.559     0.200
     2.409    76.258     0.200
    10.045   295.258     0.200
     0.246     8.312     0.200
     1.080    35.383     0.200
     1.080    34.973     0.200
     1.080    35.184     0.200
     3.247    97.562     0.200
     3.468   103.195     0.200
     3.494   106.383     0.200
     6.344   192.484     0.200
     7.024   213.488     0.200
     0.315    10.354     0.200
     1.156    36.455     0.200
     1.248    39.854     0.200
     2.053    64.354     0.200
     2.444    75.455     0.200
     2.494    78.654     0.200
     0.844    27.139     0.200
     0.893    28.739     0.200
     1.640    51.739     0.200
     2.074    65.939     0.200
     2.191    68.439     0.200
     2.361    72.839     0.200
     2.405    76.339     0.200
     2.463    76.939     0.200
     0.093     4.867     0.200
     0.944    29.965     0.200
     1.878    58.664     0.200
     1.878    59.867     0.200
     0.552    18.926     0.200
     3.030    88.629     0.200
     0.606    20.230     0.200
     1.166    38.859     0.200
     1.166    38.230     0.200
     2.604    79.469     0.200
     2.969    87.531     0.200
     5.641   170.629     0.200
     0.786    25.692     0.200
     0.930    30.093     0.200
     1.583    50.293     0.200
     2.122    68.093     0.200
     2.247    70.893     0.200
     2.373    74.293     0.200
     2.411    75.492     0.200
     2.403    76.492     0.200
     0.368    12.039     0.200
     0.368    11.938     0.200
     0.831    26.539     0.200
     1.609    51.039     0.200
     2.294    72.641     0.200
     2.294    72.336     0.200
     2.793    85.641     0.200
     3.477   102.641     0.200
     0.489    17.586     0.200
     1.034    32.773     0.200
     1.248    40.465     0.200
     2.995    89.824     0.200
     3.160    95.785     0.200
     1.063    34.711     0.200
     1.063    34.812     0.200
     7.590   229.516     0.200
     0.299     9.781     0.200
     0.299     9.586     0.200
     1.286    40.984     0.200
     2.015    63.680     0.200
     2.479    76.586     0.200
     2.479    77.180     0.200
     2.478    78.680     0.200
     2.478    78.883     0.200
     0.365    13.359     0.200
     2.810    84.660     0.200
     2.810    84.461     0.200
     3.273    99.559     0.200
     7.480   223.805     0.200
     0.520    16.913     0.200
     1.221    39.312     0.200
     2.114    65.812     0.200
     0.923    29.906     0.200
     0.947    30.707     0.200
     2.060    66.309     0.200
     2.142    68.105     0.200
     2.321    74.605     0.200
     2.438    75.809     0.200
     2.496    79.605     0.200
     0.231     8.070     0.200
     0.231     7.570     0.200
     0.953    30.773     0.200
     1.452    46.977     0.200
     2.437    76.977     0.200
     2.437    76.875     0.200
     7.910   236.719     0.200
     0.224     7.344     0.200
     0.952    30.445     0.200
     1.452    45.945     0.200
     2.444    76.945     0.200
     0.227     7.438     0.200
     0.951    30.438     0.200
     1.454    46.141     0.200
     1.454    46.938     0.200
     2.441    76.844     0.200
     2.441    77.039     0.200
     7.905   236.188     0.200
     0.218     7.195     0.200
     0.950    30.398     0.200
     1.454    45.195     0.200
     1.454    46.398     0.200
     2.450    77.000     0.200
     2.450    77.602     0.200
     0.219     7.398     0.200
     0.219     7.500     0.200
     0.958    30.898     0.200
     1.446    45.602     0.200
     2.451    77.000     0.200
     0.212     7.119     0.200
     0.942    30.220     0.200
     1.461    44.920     0.200
     1.461    45.920     0.200
     2.453    75.920     0.200
     2.453    76.819     0.200
     7.890   234.464     0.200
     0.223     7.188     0.200
     0.948    30.787     0.200
     1.456    46.986     0.200
     2.444    76.986     0.200
     0.957    30.438     0.200
     1.866    58.336     0.200
     2.480    76.438     0.200
     0.210     7.141     0.200
     0.938    30.242     0.200
     1.464    46.840     0.200
     2.455    77.441     0.200
     0.233     7.641     0.200
     0.950    30.641     0.200
     1.456    46.938     0.200
     2.434    76.938     0.200
     0.212     7.750     0.200
     0.953    30.555     0.200
     1.856    58.453     0.200
     2.457    77.250     0.200
     0.216     7.066     0.200
     0.216     7.168     0.200
     0.934    30.566     0.200
     1.469    47.168     0.200
     2.447    76.969     0.200
     2.613    80.270     0.200
     7.887   237.785     0.200
     0.216     7.465     0.200
     0.939    30.566     0.200
     1.464    46.266     0.200
     2.448    76.965     0.200
     0.219     7.398     0.200
     0.948    30.492     0.200
     1.456    45.594     0.200
     1.456    46.797     0.200
     2.448    76.992     0.200
     0.225     7.266     0.200
     0.954    30.766     0.200
     1.450    46.469     0.200
     2.444    77.062     0.200
     0.204     7.098     0.200
     0.956    30.297     0.200
     2.466    76.896     0.200
     0.227     7.422     0.200
     0.227     7.223     0.200
     0.954    30.723     0.200
     1.451    45.922     0.200
     1.451    46.223     0.200
     2.442    77.223     0.200
     0.219     7.279     0.200
     0.954    30.279     0.200
     1.450    46.680     0.200
     2.449    77.479     0.200
     2.449    78.080     0.200
     0.361    11.824     0.200
     1.165    37.123     0.200
     1.251    39.225     0.200
     2.047    63.523     0.200
     2.445    77.424     0.200
     2.481    76.523     0.200
     2.491    78.523     0.200
     0.369    12.223     0.200
     0.369    12.021     0.200
     1.170    37.422     0.200
     1.247    39.422     0.200
     2.050    65.021     0.200
     2.050    64.723     0.200
     2.439    77.322     0.200
     2.439    77.623     0.200
     2.482    76.123     0.200
     2.482    76.822     0.200
     2.487    78.422     0.200
     0.207     6.863     0.200
     0.939    30.062     0.200
     1.463    46.062     0.200
     2.458    77.164     0.200
     0.237     7.276     0.200
     0.950    30.676     0.200
     1.457    46.776     0.200
     2.431    77.076     0.200
     0.372    11.875     0.200
     1.245    39.176     0.200
     1.173    36.875     0.200
     2.052    64.277     0.200
     2.439    77.176     0.200
     2.439    76.777     0.200
     2.485    77.578     0.200
     2.485    78.078     0.200
     2.481    76.375     0.200
     0.225     7.367     0.200
     0.943    30.168     0.200
     1.461    46.469     0.200
     2.441    77.066     0.200
     0.224     7.102     0.200
     0.946    30.203     0.200
     1.458    46.902     0.200
     2.443    77.402     0.200
     0.210     7.109     0.200
     0.938    30.109     0.200
     1.464    46.508     0.200
     2.455    77.305     0.200
     0.221     7.324     0.200
     0.940    30.125     0.200
     1.464    46.824     0.200
     1.464    46.523     0.200
     2.444    76.922     0.200
     0.215     7.078     0.200
     0.215     7.279     0.200
     1.459    46.879     0.200
     2.451    76.879     0.200
     7.894   237.098     0.200
     0.689    21.902     0.200
     1.131    36.102     0.200
     1.131    36.203     0.200
     1.409    45.000     0.200
     2.266    71.703     0.200
     2.266    70.801     0.200
     2.322    73.801     0.200
     0.660    21.883     0.200
     0.660    21.586     0.200
     1.126    36.586     0.200
     1.394    44.289     0.200
     2.209    69.086     0.200
     2.209    69.789     0.200
     2.292    72.188     0.200
     2.292    72.789     0.200
     2.325    73.789     0.200
     0.679    21.859     0.200
     1.129    35.957     0.200
     1.404    45.059     0.200
     2.213    70.359     0.200
     2.276    71.957     0.200
     2.323    74.156     0.200
     2.435    77.559     0.200
     0.673    21.746     0.200
     1.125    35.746     0.200
     1.402    44.848     0.200
     2.214    70.348     0.200
     2.321    74.047     0.200
     2.284    74.047     0.200
     2.436    76.949     0.200
     0.894    28.184     0.200
     1.178    37.383     0.200
     3.094    94.684     0.200
     8.292   248.178     0.200
     0.681    21.641     0.200
     1.123    35.945     0.200
     1.409    44.844     0.200
     2.219    69.539     0.200
     2.280    72.742     0.200
     2.317    73.945     0.200
     2.430    76.742     0.200
     0.670    21.695     0.200
     0.670    21.095     0.200
     1.120    35.895     0.200
     1.120    35.095     0.200
     1.404    45.195     0.200
     2.291    72.895     0.200
     2.218    69.794     0.200
     2.317    73.995     0.200
     2.317    73.095     0.200
     2.433    77.095     0.200
     2.433    76.695     0.200
     0.658    20.941     0.200
     0.658    20.840     0.200
     1.122    35.340     0.200
     2.212    68.941     0.200
     2.212    68.742     0.200
     2.298    71.742     0.200
     2.298    71.543     0.200
     2.321    73.141     0.200
     2.321    72.941     0.200
     2.440    76.543     0.200
     2.440    75.941     0.200
     8.393   249.734     0.200
     0.237     7.434     0.200
     0.962    30.730     0.200
     1.444    45.434     0.200
     2.435    76.633     0.200
     0.659    20.711     0.200
     1.132    35.914     0.200
     1.390    44.016     0.200
     2.287    71.914     0.200
     2.330    73.812     0.200
     2.447    77.211     0.200
     8.392   249.453     0.200
     0.668    21.641     0.200
     1.118    35.641     0.200
     1.404    44.547     0.200
     2.219    70.242     0.200
     2.294    73.641     0.200
     2.315    74.141     0.200
     2.433    77.445     0.200
     0.663    21.680     0.200
     0.663    21.484     0.200
     1.133    35.883     0.200
     1.133    36.086     0.200
     2.204    68.781     0.200
     2.204    69.383     0.200
     2.330    73.383     0.200
     2.330    73.586     0.200
     2.283    72.281     0.200
     2.283    71.883     0.200
     0.690    22.195     0.200
     1.140    36.094     0.200
     1.404    44.891     0.200
     2.207    69.695     0.200
     2.257    70.992     0.200
     2.330    73.891     0.200
     0.689    22.208     0.200
     1.122    36.008     0.200
     1.414    44.908     0.200
     2.222    70.008     0.200
     2.275    73.008     0.200
     2.314    73.308     0.200
     0.654    20.551     0.200
     0.654    20.951     0.200
     1.111    35.551     0.200
     1.111    35.251     0.200
     1.399    44.051     0.200
     2.312    73.251     0.200
     2.312    73.051     0.200
     2.220    69.451     0.200
     2.220    70.051     0.200
     2.499    77.751     0.200
     2.499    77.951     0.200
     0.674    21.828     0.200
     1.109    35.328     0.200
     1.413    45.023     0.200
     2.298    73.125     0.200
     2.306    73.422     0.200
     0.677    21.508     0.200
     1.110    36.109     0.200
     1.414    45.109     0.200
     2.228    70.609     0.200
     2.294    73.305     0.200
     2.306    73.711     0.200
     0.681    21.436     0.200
     1.129    36.136     0.200
     1.406    43.636     0.200
     2.214    68.836     0.200
     2.274    71.836     0.200
     2.322    73.436     0.200
     0.466    15.223     0.200
     1.227    39.223     0.200
     2.059    63.523     0.200
     2.059    63.625     0.200
     8.796   259.367     0.200
     0.667    21.855     0.200
     0.667    21.754     0.200
     1.139    36.355     0.200
     1.139    36.254     0.200
     1.391    44.652     0.200
     2.201    69.355     0.200
     2.275    72.152     0.200
     2.275    72.254     0.200
     2.334    73.754     0.200
     0.687    21.496     0.200
     1.110    36.098     0.200
     1.421    45.496     0.200
     2.232    70.996     0.200
     2.304    73.496     0.200
     2.287    72.695     0.200
     0.653    21.023     0.200
     1.124    36.223     0.200
     1.391    44.324     0.200
     2.208    69.523     0.200
     2.299    73.223     0.200
     2.325    73.621     0.200
     0.659    21.402     0.200
     1.122    35.805     0.200
     1.396    44.504     0.200
     2.212    70.203     0.200
     2.297    72.102     0.200
     2.322    73.902     0.200
     0.699    22.539     0.200
     1.129    36.438     0.200
     1.417    44.742     0.200
     2.220    69.641     0.200
     2.260    71.539     0.200
     2.318    73.641     0.200
     0.701    22.394     0.200
     1.092    34.894     0.200
     1.441    45.494     0.200
     2.252    70.294     0.200
     2.284    71.894     0.200
     2.295    72.494     0.200
     0.662    21.570     0.200
     1.116    35.869     0.200
     1.401    44.770     0.200
     2.218    70.369     0.200
     2.315    73.770     0.200
     2.300    73.070     0.200
     0.664    21.465     0.200
     0.664    20.566     0.200
     1.141    36.863     0.200
     1.387    44.465     0.200
     2.198    68.965     0.200
     2.198    68.664     0.200
     2.276    70.766     0.200
     2.276    72.164     0.200
     2.337    74.066     0.200
     8.785   256.363     0.200
     0.656    21.086     0.200
     1.143    36.586     0.200
     1.381    43.988     0.200
     2.193    69.289     0.200
     2.280    72.289     0.200
     2.341    74.289     0.200
     0.658    21.305     0.200
     0.658    21.102     0.200
     1.129    35.703     0.200
     1.391    44.508     0.200
     2.206    69.008     0.200
     2.206    70.203     0.200
     2.291    72.805     0.200
     2.291    71.906     0.200
     2.328    74.008     0.200
     0.658    21.281     0.200
     1.144    36.883     0.200
     2.193    68.883     0.200
     2.278    71.984     0.200
     2.341    73.883     0.200
     0.697    22.582     0.200
     1.099    35.383     0.200
     1.434    46.082     0.200
     2.244    71.383     0.200
     2.291    72.480     0.200
     0.689    22.406     0.200
     0.689    22.008     0.200
     1.105    35.605     0.200
     1.105    35.707     0.200
     1.425    45.605     0.200
     2.236    70.805     0.200
     2.236    70.105     0.200
     2.291    72.105     0.200
     2.299    73.508     0.200
     0.692    22.511     0.200
     1.098    35.311     0.200
     1.431    45.611     0.200
     2.243    71.211     0.200
     2.292    72.911     0.200
     2.295    73.211     0.200
     0.660    21.363     0.200
     1.153    36.662     0.200
     1.377    44.363     0.200
     2.186    69.963     0.200
     2.267    72.363     0.200
     2.349    74.963     0.200
     0.666    21.254     0.200
     1.142    36.854     0.200
     1.388    44.154     0.200
     2.198    69.254     0.200
     2.273    72.454     0.200
     2.337    74.354     0.200
     0.655    21.090     0.200
     1.142    36.793     0.200
     1.381    43.992     0.200
     2.194    69.293     0.200
     2.282    72.793     0.200
     2.340    74.090     0.200
     0.705    22.579     0.200
     0.705    22.880     0.200
     1.118    35.880     0.200
     1.118    35.779     0.200
     1.427    45.979     0.200
     2.232    71.180     0.200
     2.232    70.680     0.200
     2.267    72.979     0.200
     2.267    72.079     0.200
     2.307    72.979     0.200
    10.849   322.779     0.200
     0.689    22.227     0.200
     1.113    35.430     0.200
     2.230    71.031     0.200
     2.283    71.828     0.200
     0.696    22.385     0.200
     1.123    36.785     0.200
     2.224    70.485     0.200
     2.269    72.385     0.200
     0.695    22.059     0.200
     1.090    35.160     0.200
     2.251    71.059     0.200
     2.301    72.959     0.200
     2.499    78.059     0.200
     0.662    21.113     0.200
     1.138    36.516     0.200
     1.388    44.316     0.200
     2.200    69.613     0.200
     2.280    72.516     0.200
     0.679    21.812     0.200
     1.103    35.211     0.200
     1.420    45.211     0.200
     2.235    70.711     0.200
     2.299    72.617     0.200
     2.300    73.117     0.200
     0.711    22.830     0.200
     1.114    35.630     0.200
     1.434    45.830     0.200
     2.238    70.729     0.200
     2.267    72.130     0.200
     2.301    73.229     0.200
     0.698    22.477     0.200
     1.090    34.680     0.200
     1.440    45.477     0.200
     2.252    70.883     0.200
     2.283    72.977     0.200
     2.299    73.281     0.200
     0.740    23.592     0.200
     1.122    36.292     0.200
     1.449    46.392     0.200
     2.243    71.192     0.200
     2.240    70.292     0.200
     0.764    23.727     0.200
     1.449    46.629     0.200
     2.229    71.129     0.200
     2.198    70.629     0.200
     2.593    79.828     0.200
     0.689    22.459     0.200
     1.122    36.061     0.200
     1.415    45.561     0.200
     2.223    70.760     0.200
     2.275    73.160     0.200
     0.679    21.969     0.200
     1.124    35.770     0.200
     1.408    45.168     0.200
     2.218    70.066     0.200
     2.280    72.469     0.200
     0.698    22.445     0.200
     1.118    36.148     0.200
     1.423    45.750     0.200
     2.272    72.750     0.200
     2.229    70.445     0.200
     0.690    22.211     0.200
     1.090    35.305     0.200
     1.090    35.109     0.200
     1.435    45.508     0.200
     2.249    70.305     0.200
     2.249    71.008     0.200
     2.304    72.109     0.200
     2.304    72.508     0.200
     2.285    72.305     0.200
     2.497    77.711     0.200
     0.721    23.383     0.200
     1.122    36.281     0.200
     1.436    45.883     0.200
     2.235    70.281     0.200
     2.252    71.883     0.200
     2.306    73.582     0.200
     0.710    23.273     0.200
     1.103    35.672     0.200
     1.440    45.570     0.200
     2.246    71.273     0.200
     2.292    73.375     0.200
     2.277    73.070     0.200
     3.636   111.172     0.200
     0.696    22.602     0.200
     0.696    22.297     0.200
     1.102    35.102     0.200
     1.102    35.000     0.200
     1.431    45.898     0.200
     2.289    72.797     0.200
     2.289    70.797     0.200
     2.294    72.195     0.200
     2.242    71.195     0.200
     0.708    22.781     0.200
     1.111    35.781     0.200
     1.434    46.078     0.200
     2.239    71.375     0.200
     2.300    72.680     0.200
     2.271    72.875     0.200
     0.714    23.047     0.200
     1.100    34.742     0.200
     1.444    45.844     0.200
     2.250    71.047     0.200
     2.288    72.844     0.200
     2.277    72.148     0.200
     0.701    22.496     0.200
     0.701    22.797     0.200
     1.108    35.598     0.200
     1.108    35.297     0.200
     1.431    45.896     0.200
     2.279    72.598     0.200
     2.239    71.297     0.200
     2.298    73.297     0.200
     0.712    22.933     0.200
     1.099    34.632     0.200
     1.443    46.033     0.200
     2.250    70.833     0.200
     2.279    72.632     0.200
     0.706    22.660     0.200
     1.106    35.260     0.200
     2.242    70.760     0.200
     2.278    72.559     0.200
     2.295    73.160     0.200
     0.667    21.477     0.200
     1.123    36.379     0.200
     1.400    44.879     0.200
     2.214    70.379     0.200
     2.289    72.879     0.200
     2.321    74.180     0.200
     0.713    23.188     0.200
     1.096    35.492     0.200
     1.446    46.688     0.200
     2.253    72.086     0.200
     2.285    72.891     0.200
     2.282    73.289     0.200
     0.700    22.758     0.200
     0.700    22.458     0.200
     1.108    35.358     0.200
     1.108    35.258     0.200
     1.431    46.058     0.200
     2.298    73.058     0.200
     2.280    72.358     0.200
     2.280    71.358     0.200
     2.239    71.658     0.200
     8.435   251.902     0.200
     0.710    22.863     0.200
     1.103    35.164     0.200
     1.440    46.264     0.200
     2.246    71.563     0.200
     2.291    73.363     0.200
     2.278    72.063     0.200
     0.720    23.168     0.200
     1.102    35.668     0.200
     1.447    46.367     0.200
     2.251    71.168     0.200
     2.272    72.768     0.200
     0.708    22.840     0.200
     1.103    35.340     0.200
     1.439    46.242     0.200
     2.245    71.141     0.200
     2.292    73.543     0.200
     2.279    72.340     0.200
     0.696    22.398     0.200
     1.091    34.797     0.200
     1.438    45.797     0.200
     2.251    71.197     0.200
     2.284    72.898     0.200
     2.300    72.998     0.200
     2.399    76.197     0.200
     0.700    22.338     0.200
     1.090    35.037     0.200
     1.090    35.238     0.200
     1.441    45.938     0.200
     2.282    72.938     0.200
     2.282    72.238     0.200
     2.297    74.137     0.200
     2.297    72.238     0.200
     2.396    76.238     0.200
     2.396    75.637     0.200
     2.253    70.738     0.200
     2.253    70.637     0.200
     0.685    22.115     0.200
     1.090    34.715     0.200
     1.432    45.516     0.200
     2.248    71.115     0.200
     2.286    72.715     0.200
     2.308    73.414     0.200
     2.404    76.016     0.200
     2.493    77.516     0.200
     4.049   118.516     0.200
     0.673    21.641     0.200
     1.110    35.836     0.200
     1.411    44.539     0.200
     2.226    70.336     0.200
     2.298    72.641     0.200
     2.308    73.234     0.200
     0.217     7.355     0.200
     0.951    30.555     0.200
     1.452    46.355     0.200
     2.451    76.855     0.200
     0.697    22.523     0.200
     1.103    35.523     0.200
     1.431    45.719     0.200
     2.241    70.523     0.200
     2.295    73.422     0.200
     2.287    72.820     0.200
     0.353    11.684     0.200
     1.252    40.184     0.200
     2.045    63.984     0.200
     2.452    77.184     0.200
     2.477    76.387     0.200
     2.494    78.387     0.200
     8.098   244.930     0.200
     0.650    20.305     0.200
     1.142    36.508     0.200
     1.378    43.805     0.200
     2.192    68.805     0.200
     2.285    72.602     0.200
     2.341    74.102     0.200
     0.666    22.045     0.200
     1.378    44.545     0.200
     2.184    69.245     0.200
     2.259    72.045     0.200
     2.352    74.345     0.200
     0.224     7.367     0.200
     1.443    46.367     0.200
     2.448    77.266     0.200
     0.633    20.805     0.200
     1.196    38.705     0.200
     1.332    42.404     0.200
     2.140    68.104     0.200
     2.250    72.104     0.200
     2.395    75.705     0.200
     0.660    21.601     0.200
     1.125    36.401     0.200
     1.395    44.501     0.200
     2.293    72.201     0.200
     2.324    74.001     0.200
     2.210    69.301     0.200
     2.442    77.201     0.200
     0.676    21.680     0.200
     1.120    35.879     0.200
     2.315    73.477     0.200
     2.286    72.477     0.200
     2.220    69.277     0.200
     2.430    76.879     0.200
     8.410   251.871     0.200
     0.695    22.492     0.200
     1.111    35.590     0.200
     1.425    45.492     0.200
     2.234    70.492     0.200
     2.281    73.090     0.200
     2.303    73.293     0.200
     2.414    76.492     0.200
     7.328   207.992     0.200
     1.533    48.305     0.200
     2.199    70.004     0.200
     0.662    21.772     0.200
     1.112    35.572     0.200
     2.221    70.072     0.200
     2.304    73.172     0.200
     2.304    72.372     0.200
     2.312    73.072     0.200
     0.669    21.719     0.200
     1.091    34.316     0.200
     1.421    44.816     0.200
     2.241    69.719     0.200
     2.291    72.617     0.200
     2.486    77.520     0.200
     0.710    22.823     0.200
     1.091    34.723     0.200
     1.447    46.223     0.200
     2.256    70.823     0.200
     2.281    72.623     0.200
     2.289    72.123     0.200
     0.229     7.453     0.200
     0.964    30.852     0.200
     1.441    45.953     0.200
     2.443    77.258     0.200
     7.265   218.422     0.200
     0.232     7.324     0.200
     0.962    30.324     0.200
     1.444    45.621     0.200
     2.440    76.922     0.200
     0.688    21.584     0.200
     0.688    21.984     0.200
     1.104    35.186     0.200
     1.104    35.385     0.200
     1.425    45.285     0.200
     2.293    72.686     0.200
     2.298    73.084     0.200
     2.298    73.484     0.200
     2.412    75.885     0.200
     2.412    75.584     0.200
     0.529    17.820     0.200
     0.948    30.420     0.200
     1.450    46.221     0.200
     2.138    65.920     0.200
     2.200    70.020     0.200
     2.429    76.221     0.200
     0.546    17.713     0.200
     0.933    30.113     0.200
     1.464    46.213     0.200
     2.185    70.014     0.200
     2.136    67.213     0.200
     2.412    76.213     0.200
     2.412    76.014     0.200
     2.381    74.514     0.200
     3.941   118.088     0.200
     0.531    17.709     0.200
     0.947    30.607     0.200
     1.451    46.107     0.200
     2.140    67.209     0.200
     2.199    70.209     0.200
     2.369    74.709     0.200
     2.427    76.607     0.200
     0.543    17.693     0.200
     0.935    29.994     0.200
     0.935    30.693     0.200
     2.132    65.193     0.200
     2.187    69.693     0.200
     2.187    69.795     0.200
     2.381    73.795     0.200
     2.415    76.193     0.200
     2.415    76.295     0.200
     8.248   247.164     0.200
     0.547    17.867     0.200
     0.935    30.367     0.200
     1.462    46.469     0.200
     2.149    66.773     0.200
     2.186    69.969     0.200
     2.376    74.469     0.200
     2.409    76.172     0.200
     0.546    18.008     0.200
     0.932    30.008     0.200
     1.466    46.508     0.200
     2.129    66.812     0.200
     2.184    69.508     0.200
     2.384    74.312     0.200
     2.413    75.906     0.200
     0.551    18.026     0.200
     0.930    29.726     0.200
     1.467    46.626     0.200
     2.181    68.926     0.200
     2.143    66.726     0.200
     2.405    75.926     0.200
     2.381    74.726     0.200
     0.215     7.334     0.200
     0.941    30.434     0.200
     1.463    46.734     0.200
     2.450    77.135     0.200
     0.720    22.727     0.200
     1.101    35.523     0.200
     1.448    46.523     0.200
     2.252    70.328     0.200
     2.287    73.430     0.200
     2.273    72.227     0.200
     2.394    75.828     0.200
     0.696    22.719     0.200
     1.091    34.918     0.200
     1.438    46.316     0.200
     2.250    70.719     0.200
     2.298    74.117     0.200
     2.285    72.719     0.200
     2.399    76.020     0.200
     0.737    23.526     0.200
     1.055    33.625     0.200
     2.242    71.125     0.200
     2.352    73.826     0.200
     2.296    71.926     0.200
     0.897    28.633     0.200
     1.026    33.234     0.200
     2.073    66.039     0.200
     2.318    74.133     0.200
     2.441    74.734     0.200
     2.441    76.234     0.200
     0.324    10.605     0.200
     1.098    35.006     0.200
     1.318    41.705     0.200
     1.980    62.805     0.200
     2.423    76.506     0.200
     0.707    22.668     0.200
     0.995    32.270     0.200
     1.499    47.469     0.200
     2.332    73.168     0.200
     2.198    70.168     0.200
     2.390    75.770     0.200
     2.401    74.770     0.200
     2.330    73.668     0.200
     8.460   252.289     0.200
     0.633    20.476     0.200
     0.633    20.276     0.200
     1.081    34.776     0.200
     1.081    34.976     0.200
     2.239    69.876     0.200
     2.239    70.276     0.200
     2.291    72.576     0.200
     2.358    74.976     0.200
     2.358    74.876     0.200
     2.425    76.576     0.200
     2.425    75.476     0.200
     2.456    76.576     0.200
     0.591    19.695     0.200
     0.591    19.898     0.200
     0.889    28.297     0.200
     0.889    28.898     0.200
     2.140    66.996     0.200
     2.140    67.195     0.200
     2.423    74.297     0.200
     2.367    74.195     0.200
     2.367    73.695     0.200
     0.954    30.984     0.200
     0.954    30.785     0.200
     1.163    37.184     0.200
     1.900    60.586     0.200
     1.095    34.863     0.200
     1.444    45.863     0.200
     2.252    70.965     0.200
     2.287    72.363     0.200
     2.396    74.863     0.200
     2.396    76.566     0.200
     0.552    17.844     0.200
     1.461    46.645     0.200
     2.166    67.645     0.200
     2.186    69.645     0.200
     2.371    74.445     0.200
     2.403    75.746     0.200
     8.274   248.887     0.200
     0.869    27.547     0.200
     0.930    29.547     0.200
     2.094    66.844     0.200
     2.352    74.148     0.200
     2.413    74.750     0.200
     2.449    76.250     0.200
     0.868    28.070     0.200
     0.938    29.973     0.200
     1.637    52.371     0.200
     2.102    67.570     0.200
     2.202    69.871     0.200
     2.344    75.871     0.200
     2.421    75.270     0.200
     2.442    77.070     0.200
     0.866    27.867     0.200
     0.929    29.867     0.200
     1.640    52.266     0.200
     2.095    67.566     0.200
     2.197    69.867     0.200
     2.410    75.066     0.200
     2.355    75.668     0.200
     2.448    76.867     0.200
     0.917    29.277     0.200
     0.884    28.574     0.200
     2.179    69.477     0.200
     2.406    75.074     0.200
     0.883    28.477     0.200
     0.917    29.375     0.200
     2.180    69.477     0.200
     2.406    74.773     0.200
     0.883    28.750     0.200
     0.933    29.852     0.200
     2.189    69.852     0.200
     2.422    75.047     0.200
     8.634   259.211     0.200
     0.878    28.736     0.200
     0.913    29.236     0.200
     2.077    66.836     0.200
     2.180    68.336     0.200
     2.399    74.836     0.200
     2.365    75.236     0.200
     0.856    27.934     0.200
     0.935    29.332     0.200
     2.104    66.832     0.200
     2.208    70.232     0.200
     2.413    74.832     0.200
     2.353    74.232     0.200
     2.438    77.133     0.200
     0.855    28.014     0.200
     0.942    30.414     0.200
     2.212    70.113     0.200
     2.420    75.213     0.200
     2.346    75.814     0.200
     0.945    29.952     0.200
     1.647    52.452     0.200
     2.101    67.552     0.200
     2.195    69.752     0.200
     2.327    74.652     0.200
     2.447    76.552     0.200
     0.728    23.949     0.200
     1.051    34.249     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
