#!/bin/bash
gmt begin chara1.31_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source chara1.31'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.500     0.312     0.200
     0.503     0.164     0.200
     0.759     0.012     0.200
     0.914     0.078     0.200
     0.712     0.408     0.200
     0.669     0.605     0.200
     0.596    -0.293     0.200
     0.776     0.130     0.200
     0.614     0.069     0.200
     0.562     0.219     0.200
     0.296     0.241     0.200
     0.296    -0.056     0.200
     0.324     0.081     0.200
     0.317     0.118     0.200
     0.318     0.193     0.200
     0.281     0.080     0.200
     0.323     0.120     0.200
     0.284     0.074     0.200
     0.310     0.125     0.200
     0.320     0.047     0.200
     0.308     0.037     0.200
     0.309     0.076     0.200
     0.613    -0.370     0.200
     0.280     0.113     0.200
     0.286     0.118     0.200
     0.303     0.201     0.200
     0.853     0.172     0.200
     0.313     0.146     0.200
     0.826    -0.105     0.200
     0.297     0.078     0.200
     0.207     0.145     0.200
     0.940     0.205     0.200
     0.295    -0.003     0.200
     0.856     0.505     0.200
     0.611     0.277     0.200
     0.584     0.690     0.200
     0.266     0.197     0.200
     0.880     0.408     0.200
     0.552     0.145     0.200
     0.561    -0.016     0.200
     0.580     0.016     0.200
     0.708     0.135     0.200
     0.324     0.308     0.200
     0.510     0.199     0.200
     0.550     0.339     0.200
     0.758     0.148     0.200
     0.664     0.134     0.200
     0.764     0.045     0.200
     0.913     0.317     0.200
     0.915     0.270     0.200
     0.859    -0.374     0.200
     0.862    -0.421     0.200
     0.887     0.147     0.200
     0.928     0.153     0.200
     0.661     0.133     0.200
     0.991    -0.356     0.200
     0.562     0.191     0.200
     0.385     0.127     0.200
     0.578     0.107     0.200
     0.383     0.078     0.200
     0.584     0.214     0.200
     0.551     0.060     0.200
     0.322     0.169     0.200
     0.492     0.015     0.200
     0.492     0.218     0.200
     0.790     0.223     0.200
     0.658     0.205     0.200
     0.902     0.153     0.200
     0.560     0.125     0.200
     0.567    -0.121     0.200
     0.659    -0.439     0.200
     0.901     0.025     0.200
     0.267     0.036     0.200
     0.727     0.020     0.200
     0.694     0.088     0.200
     0.719     0.111     0.200
     0.340     0.047     0.200
     0.360     0.064     0.200
     0.933     0.224     0.200
     0.671     0.007     0.200
     0.871    -0.495     0.200
     0.226     0.140     0.200
     0.226     0.038     0.200
     0.318     0.088     0.200
     0.304     0.138     0.200
     0.303     0.091     0.200
     0.303     0.193     0.200
     0.513     0.039     0.200
     0.513     0.139     0.200
     0.320     0.170     0.200
     0.343     0.172     0.200
     0.348     0.119     0.200
     0.395     0.134     0.200
     0.359     0.084     0.200
     0.274    -0.158     0.200
     0.311     0.115     0.200
     0.311     0.216     0.200
     0.330     0.128     0.200
     0.310     0.062     0.200
     0.332     0.132     0.200
     0.326     0.099     0.200
     0.602     0.092     0.200
     0.332     0.124     0.200
     0.332     0.225     0.200
     0.314     0.072     0.200
     0.333     0.164     0.200
     0.767     0.073     0.200
     0.765     0.087     0.200
     0.350     0.051     0.200
     0.359     0.136     0.200
     0.556    -0.375     0.200
     0.556    -0.078     0.200
     0.342    -0.015     0.200
     0.714     0.167     0.200
     0.821     0.022     0.200
     0.818    -0.004     0.200
     0.685     0.060     0.200
     0.685     0.161     0.200
     0.679     0.079     0.200
     0.695    -0.004     0.200
     0.695     0.300     0.200
     0.691     0.146     0.200
     0.429     0.087     0.200
     0.680     0.111     0.200
     0.365    -0.021     0.200
     0.062     0.238     0.200
     0.909    -0.416     0.200
     0.075     0.135     0.200
     0.908    -0.580     0.200
     0.679     0.021     0.200
     0.679     0.122     0.200
     0.618    -0.008     0.200
     0.618     0.191     0.200
     0.607     0.067     0.200
     0.605     0.148     0.200
     0.605     0.047     0.200
     0.607     0.126     0.200
     0.648     0.054     0.200
     0.290     0.090     0.200
     0.825    -0.007     0.200
     0.838     0.153     0.200
     0.838     0.053     0.200
     0.595    -0.020     0.200
     0.385     0.025     0.200
     0.398     0.088     0.200
     0.397     0.071     0.200
     0.388    -0.050     0.200
     0.551     0.056     0.200
     0.558    -0.005     0.200
     0.374    -0.507     0.200
     0.450    -0.240     0.200
     0.290     0.003     0.200
     0.290     0.199     0.200
     0.672    -0.689     0.200
     0.672    -0.384     0.200
     0.288    -0.033     0.200
     0.288     0.067     0.200
     0.360    -0.031     0.200
     0.360     0.164     0.200
     0.641     0.114     0.200
     0.369     0.097     0.200
     0.848    -0.579     0.200
     0.628     0.165     0.200
     0.628    -0.034     0.200
     0.504    -0.129     0.200
     0.504    -0.029     0.200
     0.469     0.197     0.200
     0.469     0.299     0.200
     0.974    -0.393     0.200
     0.340     0.045     0.200
     0.340     0.147     0.200
     0.324    -0.010     0.200
     0.794    -0.157     0.200
     0.327     0.049     0.200
     0.796    -0.211     0.200
     0.472     0.030     0.200
     0.463    -0.045     0.200
     0.540     0.217     0.200
     0.399     0.069     0.200
     0.908    -0.016     0.200
     0.592     0.161     0.200
     0.694     0.232     0.200
     0.722     0.108     0.200
     0.309     0.129     0.200
     0.370     0.085     0.200
     0.318     0.283     0.200
     0.310     0.229     0.200
     0.316     0.080     0.200
     0.316     0.182     0.200
     0.351     0.023     0.200
     0.881    -0.219     0.200
     0.378     0.093     0.200
     0.899    -0.139     0.200
     0.525     0.233     0.200
     0.472     0.079     0.200
     0.472    -0.021     0.200
     0.915     0.129     0.200
     0.915     0.231     0.200
     0.775     0.282     0.200
     0.775     0.180     0.200
     0.542     0.194     0.200
     0.632     0.003     0.200
     0.328     0.129     0.200
     0.634     0.239     0.200
     0.195     0.100     0.200
     0.735     0.134     0.200
     0.735     0.034     0.200
     0.837     0.156     0.200
     0.503     0.161     0.200
     0.503     0.059     0.200
     0.692     0.229     0.200
     0.549     0.176     0.200
     0.280     0.180     0.200
     0.280     0.079     0.200
     0.659    -0.339     0.200
     0.326    -0.185     0.200
     0.618     0.230     0.200
     0.773     0.193     0.200
     0.827    -0.346     0.200
     0.149     0.218     0.200
     0.156     0.121     0.200
     0.738     0.108     0.200
     0.275    -0.193     0.200
     0.692     0.284     0.200
     0.541     0.292     0.200
     0.310     0.123     0.200
     0.733    -0.493     0.200
     0.327     0.130     0.200
     0.318     0.108     0.200
     0.778     0.204     0.200
     0.935    -0.205     0.200
     0.603     0.196     0.200
     0.309     0.132     0.200
     0.890    -0.316     0.200
     0.330     0.069     0.200
     0.872     0.092     0.200
     0.137     0.207     0.200
     0.964    -0.219     0.200
     0.786     0.113     0.200
     0.927    -0.193     0.200
     0.599     0.191     0.200
     0.583     0.246     0.200
     0.535     0.202     0.200
     1.000     0.008     0.200
     0.913    -0.741     0.200
     0.331     0.086     0.200
     0.635    -0.416     0.200
     0.635     0.084     0.200
     0.127     0.017     0.200
     0.103    -0.346     0.200
     0.836     0.089     0.200
     0.603    -0.012     0.200
     0.621     0.210     0.200
     0.175    -0.221     0.200
     0.828     0.088     0.200
     0.795     0.180     0.200
     0.818     0.137     0.200
     0.797     0.046     0.200
     0.804     0.096     0.200
     0.787    -0.080     0.200
     0.799    -0.036     0.200
     0.793     0.081     0.200
     0.797     0.054     0.200
     0.806     0.139     0.200
     0.802     0.175     0.200
     0.808     0.131     0.200
     0.804     0.122     0.200
     0.810     0.204     0.200
     0.820     0.220     0.200
     0.785    -0.048     0.200
     0.812     0.254     0.200
     0.810     0.133     0.200
     0.701     0.085     0.200
     0.246     0.068     0.200
     0.847    -0.258     0.200
     0.315     0.146     0.200
     0.844     0.127     0.200
     0.893     0.080     0.200
     0.093     0.064     0.200
     0.944    -0.530     0.200
     0.552    -0.265     0.200
     0.606     0.154     0.200
     0.786     0.092     0.200
     0.930    -0.266     0.200
     0.368    -0.012     0.200
     0.831    -0.318     0.200
     0.489     0.096     0.200
     0.299     0.062     0.200
     0.299     0.164     0.200
     0.365     0.291     0.200
     0.520     0.034     0.200
     0.923     0.117     0.200
     0.947     0.059     0.200
     0.231     0.043     0.200
     0.231     0.144     0.200
     0.953    -0.148     0.200
     0.224     0.098     0.200
     0.952    -0.363     0.200
     0.227    -0.002     0.200
     0.227     0.100     0.200
     0.951    -0.334     0.200
     0.218     0.068     0.200
     0.950    -0.262     0.200
     0.219     0.122     0.200
     0.958    -0.337     0.200
     0.212    -0.045     0.200
     0.942    -0.213     0.200
     0.223     0.113     0.200
     0.948    -0.329     0.200
     0.957    -0.798     0.200
     0.210    -0.010     0.200
     0.938    -0.208     0.200
     0.233     0.080     0.200
     0.212     0.073     0.200
     0.953    -0.389     0.200
     0.216    -0.031     0.200
     0.216     0.168     0.200
     0.934    -0.170     0.200
     0.216     0.068     0.200
     0.939    -0.466     0.200
     0.219     0.008     0.200
     0.948    -0.255     0.200
     0.225     0.103     0.200
     0.954    -0.360     0.200
     0.204     0.000     0.200
     0.956    -0.026     0.200
     0.227     0.068     0.200
     0.954    -0.337     0.200
     0.219     0.119     0.200
     0.954    -0.354     0.200
     0.361     0.125     0.200
     0.369     0.049     0.200
     0.207     0.159     0.200
     0.939    -0.409     0.200
     0.237     0.114     0.200
     0.950    -0.233     0.200
     0.372    -0.169     0.200
     0.225     0.106     0.200
     0.943    -0.248     0.200
     0.224     0.104     0.200
     0.946    -0.363     0.200
     0.210     0.091     0.200
     0.938    -0.461     0.200
     0.221    -0.070     0.200
     0.940    -0.458     0.200
     0.215     0.005     0.200
     0.689     0.159     0.200
     0.689     0.057     0.200
     0.660     0.057     0.200
     0.679     0.123     0.200
     0.673     0.233     0.200
     0.894     0.116     0.200
     0.681     0.054     0.200
     0.670     0.074     0.200
     0.670    -0.026     0.200
     0.237     0.154     0.200
     0.962    -0.251     0.200
     0.659     0.209     0.200
     0.668     0.065     0.200
     0.663     0.027     0.200
     0.690     0.253     0.200
     0.689     0.191     0.200
     0.654     0.117     0.200
     0.674     0.030     0.200
     0.677     0.091     0.200
     0.681     0.298     0.200
     0.466    -0.355     0.200
     0.667     0.236     0.200
     0.667     0.134     0.200
     0.687     0.220     0.200
     0.653    -0.007     0.200
     0.659     0.008     0.200
     0.699     0.056     0.200
     0.701     0.076     0.200
     0.662     0.064     0.200
     0.664    -0.036     0.200
     0.664     0.163     0.200
     0.656    -0.010     0.200
     0.658    -0.074     0.200
     0.658     0.231     0.200
     0.658     0.072     0.200
     0.697     0.216     0.200
     0.689    -0.015     0.200
     0.692     0.124     0.200
     0.660     0.086     0.200
     0.666     0.157     0.200
     0.655     0.221     0.200
     0.705     0.064     0.200
     0.689     0.059     0.200
     0.696     0.133     0.200
     0.695     0.080     0.200
     0.662     0.075     0.200
     0.679     0.169     0.200
     0.711     0.080     0.200
     0.698     0.065     0.200
     0.740    -0.126     0.200
     0.764     0.178     0.200
     0.689     0.137     0.200
     0.679    -0.017     0.200
     0.698     0.164     0.200
     0.690    -0.010     0.200
     0.721     0.143     0.200
     0.710     0.154     0.200
     0.696     0.069     0.200
     0.696    -0.033     0.200
     0.708     0.197     0.200
     0.714     0.113     0.200
     0.701     0.025     0.200
     0.701     0.127     0.200
     0.712     0.145     0.200
     0.706     0.068     0.200
     0.667     0.173     0.200
     0.713     0.115     0.200
     0.700     0.013     0.200
     0.710     0.045     0.200
     0.720     0.145     0.200
     0.708     0.158     0.200
     0.696     0.126     0.200
     0.700    -0.017     0.200
     0.700     0.183     0.200
     0.685    -0.005     0.200
     0.673     0.044     0.200
     0.217     0.035     0.200
     0.951    -0.281     0.200
     0.697     0.151     0.200
     0.353     0.076     0.200
     0.650     0.154     0.200
     0.666     0.051     0.200
     0.224     0.066     0.200
     0.633     0.152     0.200
     0.660     0.094     0.200
     0.676     0.100     0.200
     0.695     0.162     0.200
     0.662    -0.013     0.200
     0.669    -0.085     0.200
     0.710     0.055     0.200
     0.229     0.120     0.200
     0.964    -0.378     0.200
     0.232     0.141     0.200
     0.962    -0.269     0.200
     0.688     0.144     0.200
     0.948    -0.067     0.200
     0.546     0.073     0.200
     0.933    -0.313     0.200
     0.531     0.075     0.200
     0.947    -0.276     0.200
     0.543     0.026     0.200
     0.935    -0.353     0.200
     0.935    -0.152     0.200
     0.547     0.143     0.200
     0.935    -0.078     0.200
     0.546     0.108     0.200
     0.932     0.021     0.200
     0.551    -0.042     0.200
     0.930    -0.355     0.200
     0.215     0.081     0.200
     0.941    -0.464     0.200
     0.720     0.113     0.200
     0.696     0.035     0.200
     0.897    -0.159     0.200
     0.324     0.133     0.200
     0.707     0.138     0.200
     0.995    -0.251     0.200
     0.633     0.261     0.200
     0.633    -0.039     0.200
     0.591     0.022     0.200
     0.591    -0.080     0.200
     0.889    -0.045     0.200
     0.889    -0.147     0.200
     0.954     0.334     0.200
     0.552     0.235     0.200
     0.869     0.200     0.200
     0.930    -0.652     0.200
     0.868     0.132     0.200
     0.938    -0.220     0.200
     0.866     0.062     0.200
     0.929    -0.048     0.200
     0.917     0.094     0.200
     0.884     0.111     0.200
     0.883     0.129     0.200
     0.917    -0.022     0.200
     0.883     0.024     0.200
     0.933    -0.142     0.200
     0.878     0.083     0.200
     0.913     0.221     0.200
     0.856     0.314     0.200
     0.935    -0.409     0.200
     0.855     0.104     0.200
     0.942    -0.259     0.200
     0.945    -0.467     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.901    -1.146     0.200
     0.943     0.132     0.200
     0.948    -0.175     0.200
     0.933    -0.141     0.200
     0.930     0.134     0.200
     0.995    -0.717     0.200
     0.889    -0.005     0.200
     0.930    -0.804     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.503    -0.578     0.200
     0.557    -0.448     0.200
     0.483     0.378     0.200
     0.914    -0.826     0.200
     0.712     0.273     0.200
     0.535     0.098     0.200
     0.669     0.843     0.200
     0.538     0.214     0.200
     0.596    -0.306     0.200
     0.387     1.100     0.200
     0.776    -0.199     0.200
     0.562    -0.273     0.200
     0.324     0.194     0.200
     0.318    -0.317     0.200
     0.281    -0.247     0.200
     0.284    -0.543     0.200
     0.310    -0.647     0.200
     0.320    -0.332     0.200
     0.309     0.088     0.200
     0.613     0.051     0.200
     0.620    -0.199     0.200
     0.286    -0.207     0.200
     0.303    -0.642     0.200
     0.853     1.291     0.200
     0.313    -0.791     0.200
     0.319     0.407     0.200
     0.826     1.169     0.200
     0.297     0.035     0.200
     0.295     0.802     0.200
     0.856     1.015     0.200
     0.611    -0.777     0.200
     0.611     0.223     0.200
     0.584     0.783     0.200
     0.266    -0.331     0.200
     0.880     0.873     0.200
     0.552    -0.323     0.200
     0.561    -0.592     0.200
     0.580     0.792     0.200
     0.708     0.021     0.200
     0.510    -0.455     0.200
     0.550     0.999     0.200
     0.758    -0.685     0.200
     0.846     0.984     0.200
     0.664    -0.353     0.200
     0.764     0.657     0.200
     0.913    -0.387     0.200
     0.915    -0.466     0.200
     0.811     0.062     0.200
     0.859    -0.723     0.200
     0.862    -0.802     0.200
     0.887    -0.006     0.200
     0.991    -0.625     0.200
     0.562    -0.265     0.200
     0.385    -0.771     0.200
     0.578    -0.211     0.200
     0.383    -0.412     0.200
     0.584    -0.307     0.200
     0.551     0.504     0.200
     0.322     0.308     0.200
     0.492    -0.396     0.200
     0.790     0.322     0.200
     0.790     0.122     0.200
     0.658     0.375     0.200
     0.902    -0.014     0.200
     0.695     0.399     0.200
     0.560    -0.043     0.200
     0.659    -0.388     0.200
     0.901     0.434     0.200
     0.267    -0.575     0.200
     0.267     0.620     0.200
     0.727     0.214     0.200
     0.694     0.577     0.200
     0.719     0.122     0.200
     0.340     0.405     0.200
     0.360     0.393     0.200
     0.360     0.193     0.200
     0.933    -0.159     0.200
     0.933    -0.360     0.200
     0.671     0.411     0.200
     0.871    -0.162     0.200
     0.871    -0.762     0.200
     0.226    -0.191     0.200
     0.226    -0.293     0.200
     0.318    -0.033     0.200
     0.318    -0.233     0.200
     0.304    -0.107     0.200
     0.303    -0.198     0.200
     0.303    -0.397     0.200
     0.513     0.253     0.200
     0.320    -0.334     0.200
     0.343    -0.246     0.200
     0.348    -0.101     0.200
     0.395    -0.262     0.200
     0.359    -0.380     0.200
     0.274    -0.682     0.200
     0.311    -0.294     0.200
     0.311    -0.395     0.200
     0.330    -0.231     0.200
     0.310    -0.153     0.200
     0.310    -0.453     0.200
     0.332    -0.157     0.200
     0.326    -0.361     0.200
     0.602    -0.133     0.200
     0.332    -0.185     0.200
     0.314    -0.239     0.200
     0.333    -0.262     0.200
     0.767     0.330     0.200
     0.767     0.029     0.200
     0.765     0.423     0.200
     0.350     0.274     0.200
     0.359     0.150     0.200
     0.556    -0.486     0.200
     0.556    -0.087     0.200
     0.342     0.277     0.200
     0.342     0.176     0.200
     0.714    -0.123     0.200
     0.714     0.276     0.200
     0.821     0.103     0.200
     0.818     0.320     0.200
     0.818     0.116     0.200
     0.685     0.094     0.200
     0.679     0.045     0.200
     0.695    -0.248     0.200
     0.695    -0.053     0.200
     0.691    -0.060     0.200
     0.691     0.144     0.200
     0.429     0.251     0.200
     0.680    -0.221     0.200
     0.680    -0.025     0.200
     0.365     0.088     0.200
     0.365    -0.013     0.200
     0.062     0.157     0.200
     0.909    -0.482     0.200
     0.075     0.067     0.200
     0.679    -0.217     0.200
     0.679     0.183     0.200
     0.618    -0.144     0.200
     0.618     0.256     0.200
     0.589    -0.788     0.200
     0.607     0.457     0.200
     0.607    -0.739     0.200
     0.605     0.560     0.200
     0.607     0.227     0.200
     0.607    -0.674     0.200
     0.648    -0.288     0.200
     0.290    -0.034     0.200
     0.825     0.242     0.200
     0.838     0.140     0.200
     0.838    -0.260     0.200
     0.595     0.030     0.200
     0.385    -0.647     0.200
     0.385     0.048     0.200
     0.398     0.007     0.200
     0.398    -0.293     0.200
     0.397    -0.167     0.200
     0.397    -0.066     0.200
     0.388    -0.061     0.200
     0.551     0.057     0.200
     0.551     0.159     0.200
     0.558    -0.066     0.200
     0.374     0.726     0.200
     0.450     0.454     0.200
     0.290    -0.262     0.200
     0.290    -0.160     0.200
     0.672    -0.084     0.200
     0.672     0.018     0.200
     0.288     0.158     0.200
     0.288     0.259     0.200
     0.360    -0.767     0.200
     0.360     0.140     0.200
     0.641    -0.523     0.200
     0.641     0.071     0.200
     0.369     0.487     0.200
     0.848     0.141     0.200
     0.628     0.724     0.200
     0.504     0.234     0.200
     0.504    -1.266     0.200
     0.469     0.025     0.200
     0.469    -0.179     0.200
     0.974    -0.324     0.200
     0.340    -0.298     0.200
     0.340     0.202     0.200
     0.324     0.115     0.200
     0.794     0.183     0.200
     0.327     0.159     0.200
     0.472    -0.184     0.200
     0.463    -0.222     0.200
     0.540    -0.092     0.200
     0.399    -0.378     0.200
     0.908    -0.321     0.200
     0.592    -0.465     0.200
     0.694    -0.209     0.200
     0.694     0.088     0.200
     0.722    -0.077     0.200
     0.309    -0.195     0.200
     0.370    -0.195     0.200
     0.370    -0.095     0.200
     0.318    -0.165     0.200
     0.310    -0.177     0.200
     0.316    -0.195     0.200
     0.316    -0.094     0.200
     0.351    -0.154     0.200
     0.881    -0.224     0.200
     0.378    -0.274     0.200
     0.899    -0.421     0.200
     0.525    -0.002     0.200
     0.525    -0.502     0.200
     0.472    -0.100     0.200
     0.472    -0.200     0.200
     0.460     0.648     0.200
     0.915    -0.186     0.200
     0.775     0.126     0.200
     0.542    -0.106     0.200
     0.632     0.110     0.200
     0.328    -0.365     0.200
     0.634    -0.093     0.200
     0.195    -0.149     0.200
     0.735    -0.338     0.200
     0.735     0.062     0.200
     0.837     0.106     0.200
     0.837     0.208     0.200
     0.503    -0.079     0.200
     0.692    -0.038     0.200
     0.549    -0.094     0.200
     0.280     0.224     0.200
     0.659    -0.391     0.200
     0.326    -0.001     0.200
     0.618     0.470     0.200
     0.773     0.533     0.200
     0.827    -0.116     0.200
     0.149    -0.067     0.200
     0.156     0.008     0.200
     0.738     0.119     0.200
     0.275     0.365     0.200
     0.692     0.182     0.200
     0.718    -0.463     0.200
     0.718     0.537     0.200
     0.541    -0.060     0.200
     0.310     0.385     0.200
     0.733     0.005     0.200
     0.327     0.336     0.200
     0.318    -0.114     0.200
     0.778    -0.009     0.200
     0.935     0.047     0.200
     0.603    -0.028     0.200
     0.309    -0.163     0.200
     0.890    -0.316     0.200
     0.330    -0.429     0.200
     0.872    -0.356     0.200
     0.137    -0.085     0.200
     0.964     0.947     0.200
     0.786     0.212     0.200
     0.927     0.375     0.200
     0.599    -0.193     0.200
     0.583    -0.042     0.200
     0.535     0.159     0.200
     1.000     0.144     0.200
     0.758    -0.883     0.200
     0.913    -0.607     0.200
     0.331     0.101     0.200
     0.331     0.502     0.200
     0.635    -0.496     0.200
     0.127    -0.341     0.200
     0.127    -0.241     0.200
     0.103    -0.101     0.200
     0.836     0.307     0.200
     0.603    -0.226     0.200
     0.621    -0.079     0.200
     0.175    -0.536     0.200
     0.828     0.202     0.200
     0.795     0.163     0.200
     0.811    -0.201     0.200
     0.811    -0.002     0.200
     0.818     0.218     0.200
     0.797    -0.019     0.200
     0.804     0.141     0.200
     0.787     0.068     0.200
     0.799     0.275     0.200
     0.793    -0.027     0.200
     0.797     0.089     0.200
     0.806     0.165     0.200
     0.802     0.167     0.200
     0.808     0.050     0.200
     0.808     0.250     0.200
     0.804     0.175     0.200
     0.810     0.091     0.200
     0.820    -0.012     0.200
     0.820     0.187     0.200
     0.785     0.141     0.200
     0.812     0.126     0.200
     0.810     0.429     0.200
     0.701    -0.226     0.200
     0.701     0.376     0.200
     0.246    -0.283     0.200
     0.315    -0.222     0.200
     0.844    -0.037     0.200
     0.893    -0.026     0.200
     0.093    -0.329     0.200
     0.944    -0.629     0.200
     0.552     0.288     0.200
     0.606     0.320     0.200
     0.786     0.380     0.200
     0.930     0.156     0.200
     0.368     0.050     0.200
     0.368    -0.052     0.200
     0.831    -0.213     0.200
     0.489     1.245     0.200
     0.299    -0.146     0.200
     0.299    -0.341     0.200
     0.365     0.339     0.200
     0.520     0.018     0.200
     0.923     0.250     0.200
     0.947     0.285     0.200
     0.231     0.310     0.200
     0.231    -0.190     0.200
     0.953     0.064     0.200
     0.224    -0.285     0.200
     0.952    -0.244     0.200
     0.227    -0.174     0.200
     0.951    -0.191     0.200
     0.218    -0.233     0.200
     0.950    -0.214     0.200
     0.219    -0.281     0.200
     0.219    -0.180     0.200
     0.958    -0.010     0.200
     0.212    -0.365     0.200
     0.942    -0.176     0.200
     0.223    -0.314     0.200
     0.948     0.252     0.200
     0.957     0.254     0.200
     0.210    -0.151     0.200
     0.938    -0.012     0.200
     0.233    -0.175     0.200
     0.950     0.029     0.200
     0.212    -0.261     0.200
     0.953    -0.289     0.200
     0.216    -0.143     0.200
     0.216    -0.042     0.200
     0.934     0.495     0.200
     0.216     0.258     0.200
     0.939     0.338     0.200
     0.219    -0.289     0.200
     0.948    -0.095     0.200
     0.225    -0.210     0.200
     0.954     0.041     0.200
     0.204    -0.272     0.200
     0.956    -0.585     0.200
     0.227    -0.380     0.200
     0.227    -0.580     0.200
     0.954    -0.052     0.200
     0.219    -0.199     0.200
     0.954    -0.452     0.200
     0.361    -0.244     0.200
     0.369     0.030     0.200
     0.369    -0.171     0.200
     0.207    -0.348     0.200
     0.939    -0.234     0.200
     0.237    -0.372     0.200
     0.950     0.153     0.200
     0.372    -0.608     0.200
     0.225    -0.110     0.200
     0.943    -0.199     0.200
     0.224    -0.268     0.200
     0.946    -0.245     0.200
     0.210    -0.295     0.200
     0.938    -0.181     0.200
     0.221    -0.205     0.200
     0.940    -0.187     0.200
     0.215    -0.254     0.200
     0.215    -0.053     0.200
     0.689    -0.298     0.200
     0.660     0.540     0.200
     0.660     0.243     0.200
     0.679     0.012     0.200
     0.673     0.095     0.200
     0.894    -0.594     0.200
     0.681    -0.296     0.200
     0.670     0.037     0.200
     0.670    -0.563     0.200
     0.658    -0.787     0.200
     0.658    -0.889     0.200
     0.237    -0.409     0.200
     0.962    -0.250     0.200
     0.659    -0.587     0.200
     0.668     0.049     0.200
     0.663     0.130     0.200
     0.663    -0.066     0.200
     0.690     0.003     0.200
     0.689     0.052     0.200
     0.654    -0.627     0.200
     0.654    -0.227     0.200
     0.674     0.048     0.200
     0.677    -0.314     0.200
     0.681    -0.587     0.200
     0.466    -0.328     0.200
     0.667     0.367     0.200
     0.667     0.265     0.200
     0.687    -0.596     0.200
     0.653    -0.145     0.200
     0.659     0.121     0.200
     0.699    -0.063     0.200
     0.701    -0.267     0.200
     0.662     0.272     0.200
     0.664     0.005     0.200
     0.664    -0.894     0.200
     0.656    -0.199     0.200
     0.658     0.058     0.200
     0.658    -0.146     0.200
     0.658    -0.023     0.200
     0.697     0.177     0.200
     0.689     0.242     0.200
     0.689    -0.156     0.200
     0.692     0.238     0.200
     0.660     0.112     0.200
     0.666    -0.197     0.200
     0.655     0.015     0.200
     0.705    -0.076     0.200
     0.705     0.225     0.200
     0.689    -0.016     0.200
     0.696     0.002     0.200
     0.695    -0.369     0.200
     0.662    -0.245     0.200
     0.679    -0.049     0.200
     0.711    -0.050     0.200
     0.698    -0.005     0.200
     0.740    -0.242     0.200
     0.764    -0.832     0.200
     0.689     0.294     0.200
     0.679     0.036     0.200
     0.698     0.011     0.200
     0.690    -0.109     0.200
     0.721     0.187     0.200
     0.710     0.443     0.200
     0.696     0.087     0.200
     0.696    -0.217     0.200
     0.708     0.009     0.200
     0.714     0.031     0.200
     0.701    -0.085     0.200
     0.701     0.216     0.200
     0.712    -0.012     0.200
     0.706    -0.125     0.200
     0.667     0.014     0.200
     0.713     0.265     0.200
     0.700     0.220     0.200
     0.700    -0.080     0.200
     0.710     0.033     0.200
     0.720    -0.002     0.200
     0.708     0.068     0.200
     0.696    -0.018     0.200
     0.700    -0.215     0.200
     0.685    -0.046     0.200
     0.673    -0.143     0.200
     0.217    -0.384     0.200
     0.951    -0.182     0.200
     0.697     0.108     0.200
     0.353    -0.231     0.200
     0.650    -0.732     0.200
     0.666     0.599     0.200
     0.224    -0.341     0.200
     0.633     0.433     0.200
     0.660     0.300     0.200
     0.676    -0.245     0.200
     0.695     0.148     0.200
     0.662     0.341     0.200
     0.669    -0.078     0.200
     0.710    -0.087     0.200
     0.229    -0.321     0.200
     0.964    -0.217     0.200
     0.232    -0.527     0.200
     0.962    -0.674     0.200
     0.688    -0.611     0.200
     0.688    -0.211     0.200
     0.529     0.731     0.200
     0.948    -0.066     0.200
     0.546     0.044     0.200
     0.933     0.064     0.200
     0.531     0.555     0.200
     0.947     0.125     0.200
     0.543     0.146     0.200
     0.935    -0.090     0.200
     0.935     0.609     0.200
     0.547     0.217     0.200
     0.935     0.285     0.200
     0.546     0.405     0.200
     0.932     0.026     0.200
     0.551     0.143     0.200
     0.930    -0.248     0.200
     0.215    -0.129     0.200
     0.941     0.094     0.200
     0.720    -0.434     0.200
     0.696     0.285     0.200
     0.737    -0.346     0.200
     0.897    -0.197     0.200
     0.324    -0.244     0.200
     0.707    -0.183     0.200
     0.995     0.216     0.200
     0.633    -0.000     0.200
     0.633    -0.200     0.200
     0.591    -0.084     0.200
     0.591     0.119     0.200
     0.889    -0.038     0.200
     0.889     0.563     0.200
     0.954     0.128     0.200
     0.954    -0.071     0.200
     0.552     0.060     0.200
     0.869    -0.523     0.200
     0.930    -0.462     0.200
     0.868     0.181     0.200
     0.938    -0.184     0.200
     0.866     0.030     0.200
     0.929     0.006     0.200
     0.917    -0.195     0.200
     0.884     0.138     0.200
     0.883     0.078     0.200
     0.917    -0.114     0.200
     0.883     0.372     0.200
     0.933    -0.142     0.200
     0.878     0.486     0.200
     0.913    -0.124     0.200
     0.856     0.412     0.200
     0.935    -0.745     0.200
     0.855     0.506     0.200
     0.942     0.117     0.200
     0.945    -0.421     0.200
     0.728     0.202     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.034
 1.00    0.034
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.340
 1.00   -0.340
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00   -0.0
 1.00   -0.0
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.3 (solid green line)
     0.050    -7.500   Sg = red circles; average =  -0.0 (dashed red line)
EOF
gmt end
