#!/bin/bash
gmt begin chara1.31_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic chara1.31'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.469
   135.500     1.552
   136.000     1.637
   136.500     1.725
   137.000     1.817
   137.500     1.911
   138.000     2.009
   138.500     2.111
   139.000     2.216
   139.500     2.325
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.801
   142.000     2.931
   142.500     3.066
   143.000     3.206
   143.500     3.351
   144.000     3.502
   144.500     3.658
   145.000     3.821
   145.500     3.989
   146.000     4.164
   146.500     4.345
   147.000     4.534
   147.500     4.729
   148.000     4.932
   148.500     5.143
   149.000     5.363
   149.500     5.591
   150.000     5.829
   150.500     6.077
   151.000     6.335
   151.500     6.604
   152.000     6.883
   152.500     7.171
   153.000     7.470
   153.500     7.779
   154.000     8.099
   154.500     8.431
   155.000     8.773
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.693
   145.500     0.269
   146.000     1.295
   146.500     2.364
   147.000     3.468
   147.500     4.602
   148.000     5.763
   148.500     6.949
   149.000     8.158
   149.500     9.391
   150.000    10.645
   150.500    11.921
   151.000    13.218
   151.500    14.534
   152.000    15.869
   152.500    17.222
   153.000    18.593
   153.500    19.982
   154.000    21.389
   154.500    22.813
   155.000    24.255
   155.500    25.713
   156.000    27.188
   156.500    28.680
   157.000    30.189
   157.500    31.714
   158.000    33.256
   158.500    34.815
   159.000    36.390
   159.500    37.981
   160.000    39.589
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.695
   145.500     0.072
   146.000     0.765
   146.500     1.408
   147.000     2.006
   147.500     2.567
   148.000     3.092
   148.500     3.585
   149.000     4.051
   149.500     4.497
   150.000     4.927
   150.500     5.344
   151.000     5.751
   151.500     6.148
   152.000     6.537
   152.500     6.918
   153.000     7.294
   153.500     7.665
   154.000     8.034
   154.500     8.401
   155.000     8.765
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   146.109    -0.408     0.200
   146.404     0.795     0.200
   143.791    -1.755     0.200
   143.921    -3.551     0.200
   152.395    -2.974     0.200
   139.413    -2.257     0.200
   151.681     1.521     0.200
   154.631     1.449     0.200
   137.538    -0.715     0.200
   137.538    -0.215     0.200
   141.901    -1.750     0.200
   143.287    -2.710     0.200
   144.616     0.269     0.200
   146.481    -0.226     0.200
   146.658     1.378     0.200
   147.987     2.061     0.200
   149.505     1.029     0.200
   151.665     1.545     0.200
   153.499     0.344     0.200
   154.271     1.247     0.200
   154.386     3.088     0.200
   154.615     0.870     0.200
   154.789     1.528     0.200
   155.730     0.751     0.200
   155.755     1.717     0.200
   157.664     1.057     0.200
   158.066     0.262     0.200
   136.626     0.331     0.200
   136.626    -0.478     0.200
   146.392    -0.212     0.200
   151.660    -0.428     0.200
   135.897     0.138     0.200
   143.425    -1.226     0.200
   144.265    -1.133     0.200
   145.886     0.417     0.200
   150.160     2.340     0.200
   146.441    -0.033     0.200
   146.432    -0.098     0.200
   146.439    -0.698     0.200
   144.091    -0.192     0.200
   145.052    -0.278     0.200
   145.722    -0.300     0.200
   146.332    -0.282     0.200
   146.332    -0.747     0.200
   146.439    -0.506     0.200
   146.077     0.171     0.200
   146.077     0.069     0.200
   144.379    -0.760     0.200
   144.605     0.027     0.200
   146.063    -0.121     0.200
   146.519    -0.399     0.200
   146.505    -0.015     0.200
   147.574    -1.797     0.200
   146.066    -0.830     0.200
   146.066    -0.323     0.200
   146.035    -0.768     0.200
   146.442    -0.878     0.200
   139.433    -1.304     0.200
   146.471    -0.802     0.200
   146.465    -0.394     0.200
   146.465    -0.164     0.200
   136.756    -0.376     0.200
   146.440     0.132     0.200
   146.067    -0.457     0.200
   145.977    -0.895     0.200
   145.985    -1.133     0.200
   147.386     0.164     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   147.246     1.059     0.200
   146.466     0.503     0.200
   146.481     0.614     0.200
   152.321     6.165     0.200
   149.530     4.395     0.200
   151.660     5.263     0.200
   151.668     5.406     0.200
   149.214     3.833     0.200
   150.577     4.800     0.200
   149.562     4.229     0.200
   150.060     4.802     0.200
   151.238     4.510     0.200
   152.742     6.008     0.200
   153.448     5.075     0.200
   150.160     4.699     0.200
   151.855     5.603     0.200
   151.871     6.102     0.200
   151.871     4.891     0.200
   149.503     4.623     0.200
   149.510     4.379     0.200
   151.609     5.833     0.200
   151.609     5.118     0.200
   153.816     7.375     0.200
   149.821     3.968     0.200
   145.341     0.745     0.200
   151.317     5.713     0.200
   146.052     0.197     0.200
   149.402     2.975     0.200
   145.024     1.292     0.200
   146.667     1.429     0.200
   149.425     4.497     0.200
   151.483     5.706     0.200
   148.653     3.160     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   153.163    16.794     0.200
   153.874    16.973     0.200
   145.886     1.315     0.200
   153.713    16.358     0.200
   174.551    90.833     0.200
   146.054     1.123     0.200
   146.723     3.054     0.200
   153.027    18.054     0.200
   153.329    19.935     0.200
   153.743    20.021     0.200
   163.195    49.450     0.200
   163.244    51.365     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   151.026     5.909     0.200
   152.395     6.627     0.200
   137.708     1.909     0.200
   140.680     2.044     0.200
   145.474     2.589     0.200
   148.003     4.632     0.200
   137.695     1.906     0.200
   139.676     4.066     0.200
   140.664     2.574     0.200
   146.489     4.562     0.200
   151.508    10.282     0.200
   145.646     2.514     0.200
   145.646     2.135     0.200
   149.530     4.828     0.200
   153.155    10.198     0.200
   153.460    10.559     0.200
   153.867    10.376     0.200
   145.636     2.408     0.200
   151.668    10.706     0.200
   153.163    10.294     0.200
   153.468    10.454     0.200
   153.874    10.373     0.200
   143.244     1.432     0.200
   153.050     7.968     0.200
   139.759     0.926     0.200
   150.184     5.263     0.200
   153.396    12.015     0.200
   149.589     4.888     0.200
   149.936     4.939     0.200
   153.104     7.248     0.200
   146.070     2.892     0.200
   139.808     2.402     0.200
   139.808     4.976     0.200
   140.931     3.983     0.200
   151.317     5.952     0.200
   152.069     9.235     0.200
   139.472     0.956     0.200
   149.425     5.098     0.200
   149.816     5.226     0.200
   151.483     6.085     0.200
   152.970     7.507     0.200
   153.686     7.743     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
